﻿USE sofia;
DROP TABLE IF EXISTS sofia.tteo_vpl;
CREATE TABLE tteo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tteo_vpl WRITE;
INSERT INTO tteo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Sauga bagubagunana koina Yaubada bulibuli yo yanuwa yaulina iyamayaleli. ");
INSERT INTO tteo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Baguna yanuwa yaulina gaibu molosina, waila bwagabwaga, nige mayale koina yo nige naga kana koleya iyayawatagili besiele sauga kabona. Yaubada Yaluyaluwana igayagayai-keikeile waila pwatana mena. ");
INSERT INTO tteo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Kabo Yaubada iwalo iba, “Mayale, kuyawatagili.” Kabo mayale iyawatagili. ");
INSERT INTO tteo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Yo Yaubada mayale igitai inamwanamwa yo iyaliyaya. Kabo iyakasa mayale ipeisuwalan boniboniyai koina. Boniboniyai ipei boniyai koina yo mayale ipei kaliyate koina. ");
INSERT INTO tteo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Mayale koina Yaubada esana ipei Kaliyate yo boniboniyai koina esana ipei Boniyai. Kabo muli mena boniyai ilau yo malala ilaoma, kaliyate kaigeda. ");
INSERT INTO tteo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Kabo Yaubada iwalo iba, “Sowasowaga kuyawatagili yo waila kuyakasali.” ");
INSERT INTO tteo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Mwa koina waila tupwana isae kewa mena yo tupwana imiyamiya na sowasowaga iyawatagili luwaluwalili mena. Yo iyawatagili besiele. ");
INSERT INTO tteo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Yo Yaubada sowasowagane esana ipei Bulibuli. Kabo muli mena boniyai ilau yo malala ilaoma, kaliyate labui. ");
INSERT INTO tteo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Kabo Yaubada iwalo iba, “Waila bulibuli yaulina mena kwalaoma kwapatu-kaigeda, kabo bwatano leleyanna iyawatagili.” Yo iyawatagili besiele. ");
INSERT INTO tteo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Mwa Yaubada bwatano leleyanna esana ipei Yanuwa Yaulina yo waila siya silaoma sipatu-kaigeda esana ipei Kalita. Kabo Yaubada ana paisowa igitai inamwanamwa. ");
INSERT INTO tteo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Kabo Yaubada iwalo iba, “Kawasi me patuli, wakin bwatano mena. Mayau uweuwe me patuli, wakin besiele mayau kami koleya uloi uloi yanuwa yaulina mena.” Yo iyawatagili besiele. ");
INSERT INTO tteo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Kabo kawasi me patuli sikin bwatano mena yo mayau uweuwe me patuli sikin besiele mayau kali koleya uloi uloi. Yo Yaubada ana paisowa igitai inamwanamwa. ");
INSERT INTO tteo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Kabo muli mena boniyai ilau yo malala ilaoma, kaliyate yaiyona. ");
INSERT INTO tteo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Kabo Yaubada iwalo mayale siyawatagili bulibuli mena na siyakasali kaliyate kana mayale yo boniyai kana mayale, siya kilakilalao bolime yo waikena yo kaliyate kali sauga kaiweli. ");
INSERT INTO tteo_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Kabo Yaubada iwalo kolili iba, “Kwalala bulibuli mena na yanuwa yaulina imayale.” Yo iyawatagili besiele. ");
INSERT INTO tteo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Yaubada dabwelo yo waikena iyamayaleli, dabwelo kaliyate mena ilala yo waikena boniyai mena ilala yo utuyao besiele, ");
INSERT INTO tteo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ipeili bulibuli dedeina mena yakato mayale siwolena yanuwa yaulina kaiwena, ");
INSERT INTO tteo_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","na tem kaliyate yo boniyai siloina-yagili silala simayale na mayale yo boniboniyai siyakasali. Yo Yaubada ana paisowa igitai inamwanamwa. ");
INSERT INTO tteo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Kabo muli mena boniyai ilau yo malala ilaoma, kaliyate esopali. ");
INSERT INTO tteo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Kabo Yaubada iwalo iba, “Yamayamayale meyawasimiu kwadebalala na kalita kwayakalapowon. Besiele man, kwadebalala na kwaeva-keikeile bulibuli yo yanuwa yaulina sonosonogali kwayakalapowon.” ");
INSERT INTO tteo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Mwa koina Yaubada yamayamayale lalakili kalita mena iyamayaleli, siya kali koleya uloili uloili sinunununu-keikeile kalita mena iyamayaleli. Besiele tabe man siya sievaeva kali koleya uloili uloili iyamayaleli. Yo Yaubada ana paisowa igitai inamwanamwa. ");
INSERT INTO tteo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Kabo Yaubada iwalo-muloloili iba, “Yamayamayale meyawasimiu, kwadebalala na kalita kwayakalapowon. Man, kwadebalala yanuwa yaulina mena.” ");
INSERT INTO tteo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Kabo muli mena boniyai ilau yo malala ilaoma, kaliyate valigigi. ");
INSERT INTO tteo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Kabo Yaubada iwalo iba, “Yamayamayale kami koleya uloi uloi, yo ginauli neneneneli kwayawatagili kwadebalala yanuwa yaulina mena.” Yo iyawatagili besiele. Mwa koina Yaubada yakayakan meuloili, sokasokali yo manamanasamli, lalakili yo kikiuli kali koleya uloili uloili simiyamiya bwatano pwatana mena iyamayaleli. Yo Yaubada ana paisowa igitai inamwanamwa. ");
INSERT INTO tteo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Muli mena Yaubada iwalo iba, “Sauga bwaite koina tomo tayamayale makamakayaula yo kala koleya besiele. Na iya kani iye yo man yo yamayamayale meuloili iloinayagili.” ");
INSERT INTO tteo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Yaubada tomo iyamayale iboma makamakayauna koina, kabo iyamayaleli tau yo sine. ");
INSERT INTO tteo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Kabo Yaubada iwalo-muloloili iba, “Kwadebalala yo yanuwa yaulina kwayakalapowon yo kwaloinayan. Iye kalita mena yo man yanuwa yaulina mena yo yamayamayale meuloili yo ginauli meuloili me yawasili bwatano mena silolokeikeile kwaloinayagili.” ");
INSERT INTO tteo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kabo muli mena Yaubada iwaloyoi iba, “Wagitai, kawasi meuloili mepatuli yaeliwa meuloili bwatano mena simiyamiya tabe mayau meuloili mepatuli uweli kolili simiyamiya kamiu kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Tabe kawasi kalakalawana meuloina yaolegili yamayamayale meuloili yo man meuloili yo ginauli sinenenene bwatano mena yo ginauli meuloina meyawasili simiyamiya kolili sikekan.” Yo iyawatagili besiele. ");
INSERT INTO tteo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Yo Yaubada ana paisowa meuloina igitai kali koleya sinamwanamwasosi. Kabo muli mena boniyai ilau yo malala ilaoma, kaliyate sikisi. ");
INSERT INTO tteo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Bwaine besiele bulibuli yo yanuwa yaulina yo ginauli meuloina Yaubada iyamayaleli. Ana paisowa meuloina iyemwawasi. ");
INSERT INTO tteo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Muli mena kaliyate sebenna (7) koina Yaubada ana paisowa igitai imwawasi mwa ikaiyawasi. ");
INSERT INTO tteo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Kabo Yaubada kaliyate seben iwalo-muloloi yo iyakasisiyan kaiwena kaliyatene bwaite koina ikaiyawasi ana yamayamayale paisowana meuloina koina. ");
INSERT INTO tteo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Yaubada bulibuli yo yanuwa yaulina iyamayaleli imwawasi yo edeededena bwaite besiele. Saugana Yeoba Yaubada bulibuli yo yanuwa yaulina iyamayaleli yo tomo tabe iyamayale. ");
INSERT INTO tteo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Baguna nige naga mayau yabo o nuwana kawasi yabo ikikin-yawatagilima bwatano mena, nuwana ule mena, nuwana tano mena kaiwena Yaubada nige naga galewa iyayataluyama bwatano iyayabuta yo nige tomo ipapagan na yakato bwatano ikatububunan na igiyali. ");
INSERT INTO tteo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Na waila idoga-saema bwatanone pwatana meuloina iyabuta. ");
INSERT INTO tteo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yaubada bwatano kauna ikalai kabo koina tomo iyamayale. Kabo yawasina iyui-panaisan isuna koina kabo iyamala tomo meyawasina. ");
INSERT INTO tteo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Kabo Yaubada tano iyamayale dedei tete bomatu mena, bwaimwa Ideni koina, kabo tomone iyayamayalewa ipei tanone koina. ");
INSERT INTO tteo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Yaubada mayau uloina uloina kali koleya namwanamwali yo kanli namwanamwali kekan kaiwena ikumaili bwaine koina na tanone luwaluwalina mena mayau labui ikumaili, yabo yawasi kana mayau yo yabo naenaena yo namwanamwana kali katai mayauna. ");
INSERT INTO tteo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Yalubwasi yabo kikiuna ididi ilaoma tano Ideni luwaluwalina mena ididi-utusi ilobi na sauga meuloina tanone iyabuyabuta. Kabo yalubwasine lagalaganao esopali ipaisowaili siyamala yalubwasi kulukulunao. ");
INSERT INTO tteo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Yalubwasi bagubagunana esana Paison, iya dedei Abila meuloina ididi-takikilan. ");
INSERT INTO tteo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Na dedeine koina gole imiyamiya, golene inamwanamwasosi. Tabe mayau yabo ikin dedeinane koina iya sikalai na koina olo bwalaina namwanamwana sipaisowai yo veku dubadubali kali koleya namwanamwali simiyamiya tabe. ");
INSERT INTO tteo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Yalubwasi labuina esana Gaiyon, iya dedei Kusa meuloina ididi-takikilan. ");
INSERT INTO tteo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Waila yaiyonana Taigilis, iya ididilau yanuwa Asiliya tete bomatu mena yo waila esopalina esana Yupeleitisi. ");
INSERT INTO tteo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Yaubada tomone ikalai yo ipei tano Ideni koina na iyapaisowa yo igite-kalatan. ");
INSERT INTO tteo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Kabo iwalo koina iba, “Sowasowana bwaite mayau meuloili tanone kalona mena kanliyao kolili ukekan, ");
INSERT INTO tteo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","na naenaena yo namwanamwana kali katai mayauna kanna tabu koina ukwekekan, kaiwena sauganane tem ukwan kani kuboita.” ");
INSERT INTO tteo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Kabo muli mena Yaubada iwaloba, “Nige inanamwanamwa tem tomo kaigedamo imiyamiya. Sowasowana kana toegelugelu yabo yayamayale na mekanakava simiyamiya.” ");
INSERT INTO tteo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Na Yaubada yakayakan meuloili iyamayaleliko, siya silolokeikeile bwatano pwatana mena yo siya sievaeva sowasowaga bwagabwaga mena, kabo iyoganli ilawagilima tomone koina na igitagitai toisabo esa kani iwolegili. Kabo tomone yakayakan siya sokasokali yo manamanasamli yo siya man sievaeva-keikeile meuloili esaliyao iwolegili. Na bwaine kamwasane koina yakayakan meuloili esaliyao sikalaili. Na Adama nige naga kana toegelugelu yabo ilolobai yakato kana tosagu namwanamwana. ");
INSERT INTO tteo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Kabo Yaubada tomone kenomate lalakina iwolena koina. Saugana ikenokeno kabo lusulusuna kaigeda ikalai yo kwapina iyapatu-yavivilayoi. ");
INSERT INTO tteo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Yo lusulusune ikalaiyama tomone koina kabo koina sine iyamayale. Imwawasi kabo iyoganama koina. ");
INSERT INTO tteo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Saugana tomone sinene igitai iba, “Ee bwaite kagu lonamwa yawasosi ele iya, kaiwena tuwatuwana ilaomaya tuwatuwagu koina yo bulumana ilaomaya bulumagu koina kabo esana yapei sine, kaiwena iya iyamayaleyamaya tau yona koina.” ");
INSERT INTO tteo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Bwaite kaiwena tau tamana yo sinana ilogabaegili ilau mewainena simiya-kaigeda, kabo yoli labuine siyamala kwapi kaigeda. ");
INSERT INTO tteo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Na Adama yo wainena sikowakowa na iyamo nige simwamwalimwaline. ");
INSERT INTO tteo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Yakayakan meuloili Yaubada iyamayaleli na kaloli mena weso isonoga-gabaegili na sonogane naenaena. Mwa wesone ineli-mwakomwakota sine koina iba, “Gubesi, Yaubada mayau meuloili tano kalona mena kanliyao iyakasisi-yagili tabu wakakanli?” ");
INSERT INTO tteo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Kabo sine weso kainana iyamaisa iba, “Sowasowana bwaite mayau meuloili tano kalona mena kanliyao kakanli, ");
INSERT INTO tteo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","bwaimwanamo mayau bwaite ikin tano luwaluwalina mena kanna nige sowasowana kakan. Yaubada iwalo kolimai iba, ‘Mayaune bwaite kanna tabu wakakan, tem wakabi-tonan kani kwaboita.’” ");
INSERT INTO tteo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Mwa wesone iwalolau sinene koina iwaloba, “Nigele, kani nige kwaboboita. ");
INSERT INTO tteo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Yaubada iwalo bwaite besiele kaiwena ikatai tem saugana wakan, kani manimiu silala na ginauli meuloina namwanamwana yo naenaena wakatai yo komiu kani besiele Yaubada.” ");
INSERT INTO tteo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Sinene mayau igitai kana koleya inamwanamwa yo kanna inamwanamwa kekan kaiwena kabo inuwanuwatu iba, “Inamwanamwamo tem yakan kabo meyagu nuwamayale.” Kabo mayaune kanna ikalai ikan na tupwana iwolena wainena ikan. ");
INSERT INTO tteo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Kabo manli ilala yo sigitaili yakato sikowakowa kabo fig liguli sikalaili yo sikonali yoli kali kokaukausi. ");
INSERT INTO tteo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Dabwelo isuguko lolau molosi mena Yaubada ilalaoma daguguna sibenalan tanone kalona mena kabo silau sikeno-wadam mayau luwali mena. ");
INSERT INTO tteo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Kabo Yaubada iyoga taune koina iba, “Toweya kowaele?” ");
INSERT INTO tteo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Taune kainana iyamaisa iba, “Kaekaem daguguna yabenalan kulalaoma tanone kalona mena, kabo yamatausi mwa yakeno-wadam kaiwena yakowakowa.” ");
INSERT INTO tteo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Kabo Yaubada iba, “Gubesi mwa ukwatai yakato kowa ukowakowa? Yaiya am wasa iyeyawa? Nuwana mayauwa yayayakasisi-yanwa kanna ukwan?” ");
INSERT INTO tteo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Mwa taune iba, “Sinewa kuyeyeyamawa mekaukava, iya mwa mayaune kanna tupwana iyeyama yakan.” ");
INSERT INTO tteo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Kabo Yaubada iwalolau sinene koina iba, “Gubesi mwa uginauli besiele?” Mwa sinene iba, “Weso imwakota-yagau mwa yakalai yakan.” ");
INSERT INTO tteo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Mwa Yaubada iwalo wesone koina iba, “Kaiwena ginauli bwaite kupaisowai kabo sauga bwaite yakawa-gulaiwo maisam yawalowen. Kam polowe yakayakan sokasokali yo manamanasamli meuloili kali polowe ilalaki-gabaegili yawasim ana miyamiya meuloina koina, kani diyam koina kunene bwatano mena yo kau koina ukekan sauga meuloina. ");
INSERT INTO tteo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Na yawalo koliwo kowa mekamkava sine kwaekalokalomagigi-lagimiu, besiele tabe natumwao yo sinene natunao siekalokalomagigi-lagili. Natunao kulukulum yo natumwao kulukululi kani sikogaogaoli yo kowa yo natumwao kae kelukeluli kani kwaletaili.” ");
INSERT INTO tteo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kabo iwalo sinene koina iba, “Kani am siumane koina polowe sibaibaiwa kulobaili yo am kabi koina kamkamna lalakina kulobai. Na iyamo wainem kana nuwanuwatu ilalaki koliwo na kani iya iloiloina-yagiwo.” ");
INSERT INTO tteo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Kabo iwalo Adama koina iba, “Kowa wainem ana edeedede kumuliya mwa mayau kanna bwaite yayakasisi-yan ukwan. Kaiwena bwaite kupaisowai kabo sauga bwaite bwatano yakawa-gulai. Yawasim ana miyamiya meuloina koina kupaisowa kaikaiwe yo kamkamna kulobai muli mena kabo kanna ukwan. ");
INSERT INTO tteo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Kabo bwatanone koina samasamali yo kawasi naenaeli kani sikinma na kowa kani mayaune sikinkin bwagabwaga tanone koina kolili kani ukekan. ");
INSERT INTO tteo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kani am paisowane koina ukwamweyai kabo kan kulobai kanasiga kupileyoi bwatano mena iya koina mwa yayamayalewo. Kaiwena kowa bwatano kauna mwa kani kupileyoi kaune koina.” ");
INSERT INTO tteo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adama wainena esana ipei Ibe kaiwena iya tomo meuloili meyawasili sinali. ");
INSERT INTO tteo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Kabo Yaubada yakayakan kwapina ikalai Adama yo wainena kali kaleko ipaisowaili mwa iyalikwali. ");
INSERT INTO tteo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Mwa Yaubada iba, “Tomo ginauli meuloina namwanamwana yo naenaena sikatai besiele kita. Nige sowasowala yawasi mayauna kanna tatalamwan tabe sikalai sikan na yawasili simiyayai.” ");
INSERT INTO tteo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kabo Yaubada itawoili siyawatagili tano Ideni koina, mwa bwatanone iyayamayalene koina iwalo ilau igiyali. ");
INSERT INTO tteo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Saugana yoli labuine itao-yawatagilagili imwawasi kabo aneloseyao me ali kaleya kelepana wedowedolili ipeili tano Ideni tete bomatu mena. Kaleya kelepana wedowedoliline siyagayaga-keikeile-yagili tanone dedeina meuloina koina. Siya sitotolo tanone sigite-kalatan tabu tomo yabo ilalau yawasi mayauna koina. ");
INSERT INTO tteo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adama mewainena Ibe sikenokeno, mwa isiuma kabo natuna tauna ikabi. Ibe iba, “Yaubada ana sagu koina melumelu tauna yalobai.” Kabo esana ipei Keni. ");
INSERT INTO tteo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Yo tabe yaboyoi kanakava Eibeli isiumayan yo ikabi. Kabo iyamala sipi kali togite-kalatan na Keni iyamala topaisowa tano. ");
INSERT INTO tteo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Kabo muli mena Keni ana tano kanna tupwana ikalai yo igabu iyamala ana pwaoli Yaubada koina. ");
INSERT INTO tteo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Eibeli ana sipi kabi baguna melumeluna namwanamwana ikalai yo iunuyamate yo igabu iyamala ana pwaoli Yaubada koina. Mwa Yaubada Eibeli ana pwaoli kaiwena iyaliyaya, ");
INSERT INTO tteo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","na Keni ana pwaoli kaiwena nige iyayaliyaya. Kabo Keni imunamunai lalakina me ana nuwanae. ");
INSERT INTO tteo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Kabo Yaubada iwalo Keni koina iba, “Tawae kaiwena kumunamunai me am nuwanae? ");
INSERT INTO tteo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Nuwana tem am paisowa idudulai kani yayaliyaya koliwo. Na tem am paisowa inae naenaena iyaele isanasana nuwanuwana ikalaiwo. Na kutonan kaiwe naenaenane ukwaiwe-gabaen.” ");
INSERT INTO tteo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kabo Keni iwalo kanakava Eibeli koina iba, “Talau talokeikeile ule mena.” Saugana silau ule mena kabo Keni isagena-tolo kanakava iunuyamate. ");
INSERT INTO tteo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Kabo Yaubada iwalo Keni koina iba, “Kamkava Eibeli toweya?” Keni kainana iyamaisa iba, “Nige yakakatai. Yakato yau kaukava kana togite-kalatan?” ");
INSERT INTO tteo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Mwa Yaubada iba, “Tawae kaiwena ginauli naenaena bwaite kupaisowai? Kamkava kwasinena ididi-lobi bwatano mena yo ivalavalam koliyau. ");
INSERT INTO tteo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Kamkava kuunuyamate yo kwasinena bwatano mena kupului kabo yakawa-gulaiwo yawalo bwatano inae nige tabe sowasowam kupaisowa yoi. ");
INSERT INTO tteo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Saugana tem ukumai bwatanone kani nige am paisowane uwena kulolobai. Kani nige am kaba miya yawasosi ipapagan, na ukwasakwasa-keikeile yanuwa yaulina mena.” ");
INSERT INTO tteo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kabo Keni iwalo Yaubada koina iba, “Maisa bwaite ilalakisosi mwa nige sowasowagu yakalai. ");
INSERT INTO tteo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Na kutawoiyauko nige tabe sowasowana bwatanone koina yapaisowa yoi mwa kagu mwayaga iyai manim mena. Nige yagu kaba miya yawasosi ipapagan, bwaimwanamo yakwasakwasa-keikeile yanuwa yaulina mena. Na tem tomo silobaiyau kani siunuyamateyau.” ");
INSERT INTO tteo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Kabo Yaubada iwalo Keni koina iba, “Nigele, tem tomo iunuyamateo, ana paisowane maisana yayamaisa koina kani ilalakisosi.” Kabo Yaubada kilakilala yabo ipei Keni yona koina yonane itabuwan na tem tomo Keni silobai nige sowasowana siunuyamate. ");
INSERT INTO tteo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Mwa Keni ilau ilosuwala kana mwayaga iyai Yaubada manna mena, ilau imiya yanuwa esana Nodi iyaele Ideni dedei tete bomatu mena. ");
INSERT INTO tteo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Keni mewainena sikenokeno mwa isiuma yo ikabi kabo melumelu esana sipei Inoke. Na Keni wauwau waluwaluna isepa yo yanuwa lalakina ipaisowai mwa natuna Inoke esana ipei-panaisan yanuwane koina. ");
INSERT INTO tteo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Kabo muli mena Inoke natuna ikabi esana Iladi. Na Iladi natuna esana Meluyael kabo Meluyael natuna esana Metusaela na Metusaela natuna esana Lemeki. ");
INSERT INTO tteo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemeki sinesineo labui ikasolanagili yabo esana Eda yo yabo esana Sila. ");
INSERT INTO tteo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Eda ikabi natuna esana Yabala. Na iya tokwasa baguna ana nume palai koina imiyamiya na sipi, gouti yo bulumakau igitegite-kalatagili. Bwaite mumugane iya kana toyatubu. ");
INSERT INTO tteo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Kanakava esana Yubala na iya api yo igo kali tovenuvenu. Na venune bwaite mumugana ilaomaya iya koina. ");
INSERT INTO tteo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila ikabi natuna esana Tubal-Keni iya ana paisowa kopa yo aeyan kali topaisowa. Na duna esana Nama. ");
INSERT INTO tteo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lemeki iwalo-saesae wainenao kolili iba, “Eda yo Sila, kwabenali koliyau yau Lemeki waineguwao komiu yagu walo kwabenalagili. Kilakai yabo iunuiyau mwa kaiwena yau yaunuyamate, ");
INSERT INTO tteo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","kabo tomone iya kagu tounuyamate maisana ilalakisosi kabo muli mena Keni kana tounuyamate maisana.” ");
INSERT INTO tteo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adama mewainena sikenokeno kabo isiuma mwa ikabi natuna tauna. Ibe iba, “Yaubada natugu yaboyoi tabe iyeyama Eibeli miyalaena kaiwena Keni Eibeli iunuyamate.” Kabo natuna esana ipei Seti. ");
INSERT INTO tteo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Kabo muli mena Seti natuna ikabi esana ipei Inosi. Na sauganane koina tomo siyatubu sitapwatapwalolo Yaubada koina. ");
INSERT INTO tteo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adama me natunao kali kulutubu edeededena besiele bwaite. Saugana Yaubada tomo iyamayale yo iya iboma makamakayauna koina iyamayale. ");
INSERT INTO tteo_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Iyamayaleli tau yo sine kabo iwalo-muloloili kabo esaliyao ipeili “tomo”. ");
INSERT INTO tteo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adama ana bolime andeledi teti (130) kabo natuna tau yaboyoi ikabi. Melumelune kana koleya besiele Adama. Kabo esana ipei Seti. ");
INSERT INTO tteo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Seti ana kabi mulina mena Adama imiyamiya yoi bolime 800 yo kalona mena natunao tatao yo sinesineo tupwaliyao yoi ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Na Adama ana bolime meuloina 930 ilobai kabo iboita. ");
INSERT INTO tteo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seti ana bolime 105 kabo natuna ikabi esana Inosi. ");
INSERT INTO tteo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Inosi ana kabi mulina mena Seti imiyamiya bolime 807 yo kalona mena natunao tatao yo sinesineo tupwaliyao tabe ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Na Seti ana bolime kana baibaiwa 912 ilobai kabo iboita. ");
INSERT INTO tteo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Inosi ana bolime 90 kabo natuna ikabi esana Kenani. ");
INSERT INTO tteo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenani ana kabi mulina mena Inosi imiyamiya bolime 815 yo kalona mena natunao tataoliyao yo sinesineo tupwaliyao tabe ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Na Inosi ana bolime meuloina 905 ilobai kabo iboita. ");
INSERT INTO tteo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenani ana bolime 70 kabo natuna ikabi esana Malaleli. ");
INSERT INTO tteo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Malaleli ana kabi mulina mena Kenani imiyamiya bolime 840 yo kalona mena natunao tatao yo sinesineo tupwaliyao ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Na Kenani ana bolime meuloina 910 ilobai kabo iboita. ");
INSERT INTO tteo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Malaleli ana bolime 65 kabo natuna ikabi esana ipei Yaledi. ");
INSERT INTO tteo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yaledi ana kabi mulina mena Malaleli imiyamiya bolime 830 yo kalona mena natunao tatao yo sinesineo tupwaliyao tabe ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Na Malaleli ana bolime meuloina 895 ilobai kabo iboita. ");
INSERT INTO tteo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaledi ana bolime 162 kabo natuna ikabi esana Inoke. ");
INSERT INTO tteo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Inoke ana kabi mulina mena Yaledi imiyamiya bolime 800 yo kalona mena natunao tatao yo sinesineo tupwaliyao tabe ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Na Yaledi ana bolime 962 ilobai kabo iboita. ");
INSERT INTO tteo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Inoke ana bolime 65 kabo natuna ikabi esana Metusela. ");
INSERT INTO tteo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Na Metusela ana kabi mulina mena Inoke ikelabilabin Yaubada koina bolime 300 yo kalona mena natunao tatao yo sinesineo tupwaliyao tabe ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Na Inoke ana bolime 365 ilobai. ");
INSERT INTO tteo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Inoke ikelabilabin Yaubada koina kabo kaliyate yabo koina Yaubada Inoke ikalai ilawan mwa nige tabe sigigitaiyoi. ");
INSERT INTO tteo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela ana bolime 187 kabo natuna esana Lemeki ikabi. ");
INSERT INTO tteo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lemeki ana kabi mulina mena Metusela imiyamiya bolime 782 yo kalona mena natunao tatao yo sinesineo tupwaliyao tabe ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Na Metusela ana bolime 969 ilobai kabo iboita. ");
INSERT INTO tteo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lemeki ana bolime 182 kabo natuna tauna ikabi. ");
INSERT INTO tteo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Kabo iba, “Beyabeyana Yaubada bwatano ikawa-gulai kabo tapaisowa kaikaiwe yo takamkamna. Na bwatanone ana paisowa koina melumelune bwaite kani iyakaiyawasila, kabo esana yapei Nowa.” ");
INSERT INTO tteo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nowa ana kabi mulina mena Lemeki imiyamiya bolime 595 yo kalona mena natunao tatao yo sinesineo tupwaliyao tabe ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Na Lemeki ana bolime 777 ilobai kabo iboita. ");
INSERT INTO tteo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nowa ana bolime 500 kabo natunao ikabili esaliyao Semi, Ami yo Yapeta. ");
INSERT INTO tteo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Saugana tomo sibaibaiwa sidebalala yanuwa yaulina mena natuliyao sinesineo sibaibaiwa sikabili. ");
INSERT INTO tteo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Na bulibuli tomonliyao tatao yanuwa yaulina tomonliyao natuliyao sinesineo sigitaili kali koleya sinamwanamwasosi kabo tataone silobi yanuwa yaulina mena na sinesineone siya nuwanuwali sikalaili na sikasolanagili. ");
INSERT INTO tteo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Kabo Yaubada iwaloba, “Yawasi bwaite yaolena tomo kolili kani nige imimiyayai. Siya kani yawasiliyao simwawasi. Kabo yawasili kana mamalawe besiele bolime 120.” ");
INSERT INTO tteo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Na saugana bulibuli tomonliyao mekalikavao yanuwa yaulina tomonliyao natuliyao sikeno-toyawa mwa sikabi natuliyao tomo lalakiliyao yo saliyaliyao malamalaweli. Natuliyaone siyamala tomo bagubagunali yo esaliyao silalaki ali paisowa namwanamwana kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yaubada igitai tomo ali pwanoli ilalakisosi yo nuwatu naenaena sinuwanuwatuili kateli mena. ");
INSERT INTO tteo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Mwa Yaubada me ana nuwanae iba, “Tawae kaiwena yayamayaleli yapeili yanuwa yaulina mena na naenaena siginauli.” Kabo katena ikamkamna lalakina. ");
INSERT INTO tteo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Kabo Yaubada iba, “Tomo bwaite siya yayamayaleli mekalikavao yakayakan siya silolokeikeile siya meyawasili yo siya sievaeva, meuloili kani yaemwawasili, nuwagu inae tawae kaiwena kabo yayamayaleli.” ");
INSERT INTO tteo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Na Yaubada Nowa ikawa-namwanamwa-yan yo iyaliyaya kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Na Nowa menatunao edeededeli bwaite besiele. Nowa mumugana idudulai yo iya ibomamo tomo luwali mena nige ana naenaena ipapagan, na mekanakava Yaubada sikelabilabin simiyamiya. ");
INSERT INTO tteo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nowa natunao tatao yaiyona esaliyao bwaite, Semi, Ami yo Yapeta. ");
INSERT INTO tteo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Na Yaubada manna mena tomo yanuwa yaulina ali paisowa inaesosi mwa unuyamate ikaiwe dedei meuloina kolili. ");
INSERT INTO tteo_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Yaubada igitai yanuwa yaulina mena tomo meuloili mumugali sinaesosi. ");
INSERT INTO tteo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Kabo Yaubada iwalo Nowa koina iba, “Yagu nuwatu tomo meuloili yanuwa yaulina mena kani yaunuyamateli simwawasi, kaiwena unuyamate ikaiwe dedei meuloina kolili. ");
INSERT INTO tteo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kabo mayau namwanamwali ukwalaili kutalili am waga yabo kupaisowai, na biliutusi kaloli mena uginaulili ukebalili kalona meuloina yo dedeina meuloina kolili. ");
INSERT INTO tteo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Na uginauli besiele bwaite. Kana mamalawe 140 mita, kana magaga 23 mita yo kana sae 13 mita yo tupwana. ");
INSERT INTO tteo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Pwatana ukwatoi yo kana magaga kana lalaki besiele 50 sentimita (cm) imiyamiya. Yo kana magaga ugite-sipwai kupei yo kana gamwa kupaisowai dedeina mena yo kalona mena kana nakanaka yaiyona kupaisowaili, yabo yauli mena, yabo luwaluwalina mena yo yabo kewana mena. ");
INSERT INTO tteo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Na yau kani galewa lalakina yayatalu yanuwa yaulina mena na idoga yo yalubwasi lalakili na kani ginauli meuloina meyawasili yasibayanaeli yo ginauli meuloina yanuwa yaulina pwatana mena siboita. ");
INSERT INTO tteo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Na kani kelabilabin kamwasana yayatubu koliwo. Kowa mekamkavao wainem, natumwao yo waineliyao kwalusae waga mena. ");
INSERT INTO tteo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Man siya sievaeva meuloili yo yakayakan siya silolokeikeile yo siya sinenenene meuloili, labui labui, tau yo sine, ukwalaili, mekamkavao kwalusae waga mena, tabu kisi siboita yalubwasi koina. ");
INSERT INTO tteo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Besiele kamiu yo kali uloi uloi ukwatububu-nagili ukwele-gogonan.” ");
INSERT INTO tteo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Kabo Nowa ginauli meuloina ipaisowaili besiele Yaubada ana nuwatu. ");
INSERT INTO tteo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Kabo kaliyate yabo Yaubada iwaloyoi Nowa koina iba, “Yaso bwaite kalona mena yagitai kubomamo mumugam idudulai kabo mekamkavao am susuyao kwalau kwalusae waga mena. ");
INSERT INTO tteo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Siya yakayakan yatalam kan yo pwaoli kaiwena tau yo sine kali baibaiwa seben mekalikavao mewaineliyao ukwalaili. Yo yakayakan siya nige yatatalam kan yo pwaoli kaiwena labui labui mewaineliyao ukwalaili. ");
INSERT INTO tteo_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Na man meuloili siya sievaeva kali baibaiwa seben me waineliyao ukwalaili. Na ukwalaili mekamkavao kwalusae waga mena, kabo man kali koleya uloina uloina yanuwa yaulina mena simiyamiya tabu kisi simwawasi, ukwalaili mekamkavao kwalusae. ");
INSERT INTO tteo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kaliyate seben imwawasi kabo kani yawalo kaliyate poti (40) yo boniyai poti galewa italu. Kabo yamayamayale meuloili yayamayaleli yaemwawasili.” ");
INSERT INTO tteo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Kabo Nowa ginauli meuloina ipaisowaili besiele Yaubada ana walo. ");
INSERT INTO tteo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Na Nowa ana bolime 600 kabo yalubwasi idoga. ");
INSERT INTO tteo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Kabo mewainena, natunao mewaineliyao silusae waga mena na yakato yalubwasi siyabubu-gabaen. ");
INSERT INTO tteo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Na mekalikavao yakayakan siya Yaubada italam kan yo pwaoli kaiwena yo siya nige itatalamwan yo man siya sievaeva yo yakayakan siya sinenenene, ");
INSERT INTO tteo_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","meuloili bwaite, labui labui, tau yo sine, mekalikavao silusae waga mena besiele Yaubada ana walo. ");
INSERT INTO tteo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Kaliyate seben imwawasi kabo yalubwasi iyawatagili idoga isae. ");
INSERT INTO tteo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Edeededena bwaite besiele. Nowa ana bolime 600 waikena labuina koina kana kaliyate 17 koina waila lalakina idoga-saema bwatano kalona mena yo bulibuli itasoke galewa lalakina italu. ");
INSERT INTO tteo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Kabo kaliyate poti yo boniyai poti galewa imiyamiya italutalu. ");
INSERT INTO tteo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Kaliyatenane koina Nowa mewainena, natunao Semi, Ami yo Yapeta mewaineliyao silusae waga mena. ");
INSERT INTO tteo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","16","Na yakayakan sokasokali yo manamanasamli yo siya sinenenene yo man sievaeva, meuloili siya kali koleya uloi uloi labui labui, tau yo sine, mekalikavao Nowa silusae waga mena, besiele Yaubada ana walo. Na saugana Nowa ilusae kabo Yaubada waga kana gamwa ikausi. ");
INSERT INTO tteo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Kaliyate poti yo boniyai poti yalubwasi iyaelemo idogadoga. Waila ilalakisosi kabo waga ipoulisae. ");
INSERT INTO tteo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","19","Waila iyaele ilalaki isaesae mwa waga ipoupouli yo iyaluyaluwan waila pwatana mena yo wailane koya isae-pwaikili, ");
INSERT INTO tteo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","koya malamalaweli na yalubwasi isae-likwaili kana mamalawe besiele seben mita kana sae. ");
INSERT INTO tteo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","Yamayamayale meuloili yanuwa yaulina mena siboita, besiele tomo tabe. Ginauli meuloili meyawasili simiyamiya bwatano mena simwawasi. Yaubada meuloili iyemwawasili. Na Nowa mekanakavao siya wagane koina ileboili sinamwanamwa. ");
INSERT INTO tteo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Yalubwasi idogadoga yanuwa yaulina mena kaliyate kana baibaiwa 150 kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","3","Na Nowa mekanakavao yakayakan meyawasili waga mena Yaubada nige inunuwa-mwatainagili. Kaliyate 150 imwawasi kabo iwalo yaumai itowa yanuwa yaulina mena yo waila igumaguma, ilobilobi. Na waila lalakina nige idodoga-saema yoi yo galewa tabe nige itataluyoi. Kabo waila iyaele iguma ilaulau, ");
INSERT INTO tteo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","yo waikena sebenna (7) kana kaliyate sebentinna (17) koina waga imiyasio koya yabo pwatana mena bwaimwa dedei Alalati koina. ");
INSERT INTO tteo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Waila iyaele igumaguma mwa waikena sanaulu (10) kana kaliyate bagubagunana koina kabo koya simayale silaulau. ");
INSERT INTO tteo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Kaliyate poti yoi imwawasi, Nowa waga kana tomlape ipapaisowaiwa isoke, ");
INSERT INTO tteo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","yo aoao iyawasa ieva-yawatagili. Nige ipipileyoima waga mena na ievaeva-takitakikili kanasiga waila imwawasi yo bwatano ileleyan. ");
INSERT INTO tteo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Kabo bunetutu iyawasa ieva yoi na tem igitai waila igumako yo bwatano ileleyanko. ");
INSERT INTO tteo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Na waila iyaelemo bwatano ikaukausi kabo bunetutu nige ana kaba towa ilolobai. Mwa ieva-pileyoi ilau waga mena, kabo Nowa nimana iyagaya-yawatagilan mwa bunetutune itowa nimana mena yo ipei-luseyan. ");
INSERT INTO tteo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nowa isanasana kaliyate seben imwawasi, kabo bunetutu iyawasa yoi iyawatagili. ");
INSERT INTO tteo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Lolau mena bunetutune ieva-pileyoi Nowa koina olibe lagalagana kilaina yabo ikapu-kalatan gamwana mena. Kabo Nowa ikatai yakato waila igumako. ");
INSERT INTO tteo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Yo tabe isanasana yoi kaliyate seben imwawasi, kabo bunetutu iyawasa yoi iyawatagili. Na sauganane koina nige ipipileyoima Nowa koina. ");
INSERT INTO tteo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nowa ana bolime 601, waikena bagubagunana kana kaliyate bagubagunana koina waila igumako yo bwatano ileleyan. Mwa Nowa waga pwatana isoke-gabaen kabo manna ilau igitai bwatano pwatana ileleyanko. ");
INSERT INTO tteo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Na waikena labuina kana kaliyate 27 na koina bwatano ileleyan molosi. ");
INSERT INTO tteo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Mwa Yaubada iwalo Nowa koina iwaloba, ");
INSERT INTO tteo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Mewainem yo natumwao mewaineliyao waga kwalogabaen wakaisulu yauli mena. ");
INSERT INTO tteo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Man siya sievaeva yo yakayakan meuloili ukwalaili mekamkavao kwayawatagili yauli mena kabo siya kani sibomayoi sidebalala yanuwa yaulina mena.” ");
INSERT INTO tteo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kabo Nowa mewainena yo natunao mewaineliyao waga silogabaen siyawatagili yauli mena. ");
INSERT INTO tteo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Kabo man siya sievaeva yo yakayakan meuloili meyawasili siyawayawatagili yakasa koina. ");
INSERT INTO tteo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Kabo Nowa kaba pwaoli ipaisowai mwa man yo yakayakan siya Yaubada italam pwaoli kaiwena tupwali ikalaili kolili ipwaoli kaba pwaoli koina. ");
INSERT INTO tteo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Saugana Yaubada pwaoline bwalaina namwanamwana ibenalan kabo iwaloba, “Kani nige sauga yabo yanuwa yaulina yakakawa-gulai yoi tomo ali paisowa kaiwena, kaiwena yakatai nuwatu naenaena tomo sinuwanuwatuili kateli mena siyatubu ali sauga gagagili koina. Yo kani nige sauga yabo yakayakan meuloili yasisibayanaeli yoi besiele yaginauliyako kolili. ");
INSERT INTO tteo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Yanuwa yaulina miyamiyana koina, sauga kuma yo sauga kelikeli, sauga tulutulu yo sauga wedowedoli, galewa yo dabwelo, kaliyate yo boniyai simiyamiya silaulau kani nige simwamwawasi.” ");
INSERT INTO tteo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Kabo Yaubada Nowa yo natunao iwalo-muloloili iwaloba, “Kwadebalala yo kwabaibaiwa na yanuwa yaulina kwaloyakalapowon. ");
INSERT INTO tteo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Yakayakan meuloili, siya silolokeikeile yo siya sievaeva yo siya sinenenene yo iye meuloili kalita mena simatausagimiu mwa yapeili ami loina koina kwaloinayagili. ");
INSERT INTO tteo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ginauli meuloili meyawasili kolili wakekan. Sauga bagubagunana koina kawasi patuli yo mayau liguliyao yaeliwa kamiu, na sauga bwaite ginauli meuloina yaeyawa kolimiu kekan kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Na buluma kwasikwasinena tabu ukwakan, kaiwena yawasi imiyamiya kwasinene koina. Kaiwena kwasinene meyawasina kabo yayakasisi-yan. ");
INSERT INTO tteo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Na tem yakayakan yabo tomo yabo kwasinena iyadidi yo yawasina imwawasi, kani maisana ilobai. Besiele tem tomo yabo kanakava kwasinena iyadidi yo yawasina imwawasi kani maisana ilobai. ");
INSERT INTO tteo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Tem tomo yabo kanakava yawasina ikele-gabaen, kani tomone tounuyamatene siunuyamate kaiwena yau Yaubada tomone yayamayale yaboma makamakayaugu koina. ");
INSERT INTO tteo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Na sowasowana kwadebalala yo kwabaibaiwa na ami boda ilalaki yanuwa yaulina mena.” ");
INSERT INTO tteo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Kabo Yaubada iwalo Nowa me natunao kolili iwaloba, ");
INSERT INTO tteo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Sauga bwaite koina kelabilabin kamwasana kani yaginauli kolimiu yo kabo muli mena tubumiyao kolili tabe, ");
INSERT INTO tteo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","yo yamayamayale meuloili siya meyawasili kolili, man siya sievaeva, yakayakan siya silolokeikeile yo siya mekamikavao kwayawatagilima waga mena. ");
INSERT INTO tteo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Kabo yawaloyameli kolimiu kani nige sauga yabo yawawalo yoi yalubwasi iyayawatagili yoi yo kani nige sowasowana yakayakan meuloili yaunuiyoili nige tabe yalubwasi yanuwa yaulina isisibayanae yoi. ");
INSERT INTO tteo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Kani yau gilo yapei yaloyaloi kolili kabo iyamala kelabilabin kamwasana kana kilakilala. Kani yapaisowai kolimiu yo yamayamayale meyawasili meuloili kolili sauga ilalaoma kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Saugana tem yaloyaloi siyawatagili kewa mena yo tabe gilo wagitai, ");
INSERT INTO tteo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","16","kabo yagu kelabilabin kamwasana yanuwatu-kalatan bwaite yaginauli kolimiu yo yamayamayale meuloili meyawasili kolili yo kani nige yalubwasi idodoga yoi yo ginauli meuloina isisibayanae yoi. Saugana tem gilo yagitai yaloyaloi kolili kabo yanuwatu-kalatan kelabilabin kamwasanane miyamiya yaina.” ");
INSERT INTO tteo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Na Yaubada iwalo Nowa koina bwaite besiele iba, “Gilo iya kelabilabin kamwasana kana kilakilala yapaisowai kolimiu yo yamayamayale meuloili kolili.” ");
INSERT INTO tteo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nowa natunao siya siyawatagilima waga mena esaliyao bwaite, Semi, Ami yo Yapeta. Na Ami iya Kenani tamana. ");
INSERT INTO tteo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Tomo yanuwa yaulina meuloili situbumaya Nowa natunao yoli yaiyonane kolili. ");
INSERT INTO tteo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowa iya topaisowa bagubaguna molosina, oine kana tano ipaisowai yo ikumai. ");
INSERT INTO tteo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Sauga yabo koina Nowa oine koina inuma kabaleya mwa ikeno kowakowa ana palai kalona mena. ");
INSERT INTO tteo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kenani tamana Ami ilusae tamana ana keno kowakowa igitai mwa iyawatagili iyawasa kanakavao labui kolili. ");
INSERT INTO tteo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kabo Semi yo Yapeta kaleko yabo tabatabana sikalai silusae gamwa mena isu labui koina sikabi-kalatan kabo me ali yakasisi dagelalali silaulau-wan silau tamali salina mena kabo kaleko koina siyakaboboi yo manli sipei-suwalan yakato tabu tamali ana kowakowa sigigitai. ");
INSERT INTO tteo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Na sauganane oine ana kaiwe imwawasi yo Nowa itolo kabo wasa ibenalan natuna Ami ana paisowa kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Kabo iba, “Sauga bwaite Kenani, iya Ami natuna, kani yakawa-gulai, iya iyamala topaisowa panpanna kanakavao kolili.” ");
INSERT INTO tteo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Yo iwaloyoi tabe iba, “Yaubada yatobalan iya Semi ana Yaubada na Kenani iyamala topaisowa panpanna Semi koina. ");
INSERT INTO tteo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Kabo yakawanoi Yaubada Yapeta ana dedei iyalalaki besiele tabe tubunao yo Semi tubunao simiya-dudulai. Na Kenani iyamala topaisowa panpanna koina.” ");
INSERT INTO tteo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Yalubwasi mulina mena kabo Nowa imiyamiya tabe bolime 350. ");
INSERT INTO tteo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ana bolime meuloina 950 ilobai kabo iboita. ");
INSERT INTO tteo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nowa natunao Semi, Ami yo Yapeta mekanakavao natuliyao yo tubuliyao edeededeli besiele bwaite. Yalubwasi mulina mena natuliyao sibaibaiwa sikabili. ");
INSERT INTO tteo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yapeta natunao tatao siya Gomeli, Magogo, Madai, Yavan, Tubali, Meseki yo Tilas. ");
INSERT INTO tteo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomeli natunao tatao bwaite, Askenas, Lipati, yo Togalama. ");
INSERT INTO tteo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","5","Yavan natunao tatao bwaite, Elaisa, Talisisi, Kitim yo Dodanim. Na Talisisi tubunao siyamala Sipein tomonliyao, Kitim tubunao siyamala bwanabwana Saipilosi tomonliyao yo Dodanim tubunao siyamala bwanabwana Lodesi tomonliyao. Na bwanabwanane Saipilosi yo Lodesi siyaele Kalita Mediteleiniya koina. Tomonliyaone kainali uloi uloi simiyamiya. ");
INSERT INTO tteo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ami natunao tatao siya Kusa, Itipita, Puti esana labuina bwaimwa Libiya, yo Kenani. ");
INSERT INTO tteo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusa natunao tatao Siba, Abila, Sabita, Lama yo Sabiteka. Lama natunao tatao Seba yo Dedani. ");
INSERT INTO tteo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusa tubuna yabo esana Nimlodi. Iya iyamala tokaleya kana tobaguna lalakina yabo yo wasana ilalaki, yo me ana bodao yanuwa sibaibaiwa siyemwawasili. ");
INSERT INTO tteo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Yaubada ana sagu koina iyamala tokeloya namwanamwasosina mwa iya kaiwena tem tomo yabo ana keloya inamwanamwa kani siwaloba, “Tomo bwaite iya besiele Nimlodi.” ");
INSERT INTO tteo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ana kaba loina ikabi bagunayan yanuwa Babilon, Eleki, Kelinei yo Akadi kolili, yanuwane siya esopaline simiyamiya dedei Babilon koina. ");
INSERT INTO tteo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Mwa ilauyoi dedei Asiliya kabo yanuwa lalakili siya Ninibe, Leoboti Ili yo Kala, ");
INSERT INTO tteo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","yo Lesen ikabili. Na Lesen imiyamiya Ninibe yo yanuwa lalakina Kala luwaluwalili mena. ");
INSERT INTO tteo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Itipita tubunao siya boda Ludiya, Anam, Leab, Napituli, ");
INSERT INTO tteo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patulusi, Kasilui, yo Kapitolimi. Na boda Pilistiya silaomaya boda Kapitolimi kolili. ");
INSERT INTO tteo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenani natuna tauna tobagubaguna iya Saidoni. Natunao tabe ikabili, kabo Kenani tubunao siya boda Iti, ");
INSERT INTO tteo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yebusi, Amoli, Giligasi, ");
INSERT INTO tteo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Ivi, Aliki, Sini, ");
INSERT INTO tteo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Abaditi, Semali yo Amati. Susu bwaite Kenani tubunao simiya-tatagwaligwali dedei uloina uloina kolili. ");
INSERT INTO tteo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kabo dedeine koina simiyamiya iyatubuya yanuwa Saidoni yo ilau Gelal kaiwena kanasiga bwaine Gasa yo besiele tabe ilau Sodoma, Gomola, Adima yo Seboim kaiweli kanasiga Lasa. ");
INSERT INTO tteo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Na Ami natunao yo tubunao bwaite besiele. Kabo susune bwaite kaina uloina koina siedeedede yo simiya-lau tupwana kali mwayaga iyai ali dedeine koina yo ali yanuwa kolili. ");
INSERT INTO tteo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Semi iya Yapeta kanakava lalakina, natunao tabe ikabili. Na iya Ibeliu meuloili tubuli bagubagunana. ");
INSERT INTO tteo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Semi natunao tatao bwaite, Elan, Asul, Alipakisadi, Ludi yo Alami. ");
INSERT INTO tteo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Alami natunao tatao bwaite, Yus, Uli, Geta yo Meseki. ");
INSERT INTO tteo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Alipakisadi iya Sela tamana yo Sela iya Ebe tamana. ");
INSERT INTO tteo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebe natunao tatao labui, yabo esana sipei Pelegi kaiwena ana sauga koina tomo simiya-tatagwaligwali yanuwa yaulina dedeina meuloina kolili. Na Pelegi kanakava esana Yokitani. ");
INSERT INTO tteo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Na Yokitani koina boda bwaite sidebalala siya Alimodad, Selepi, Asamavet, yo Yela, ");
INSERT INTO tteo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adolami, Yusali, Dikila, ");
INSERT INTO tteo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimali, Seba, ");
INSERT INTO tteo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opili, Abila yo Yobabi. Na yanuwane tomonliyaone siya tubuli Yokitani. ");
INSERT INTO tteo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Dedei bwaine koina simiyamiya iyatubuya Mesa, yo ilau Sepali, bwaimwa koya dedeina tete bomatu mena. ");
INSERT INTO tteo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Na Semi natunao yo tubunao besiele bwaite. Bodane siya kaina uloina koina siedeedede yo simiya-lau kali mwayaga iyai ali dedeine yo ali yanuwane kolili. ");
INSERT INTO tteo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Yalubwasine mulina mena bodaone bwaite siya simiyamiya dedei meuloina koina yo siedeedede kaina uloina uloina kolili siya silaomaya Nowa natunao kolili mwa siya Nowa tubunao. ");
INSERT INTO tteo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Beyabeyana yanuwa yaulina tomonliyao meuloili kainali kaigeda yo kainane kana walo nige sibabaibaiwa. ");
INSERT INTO tteo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Tomo sikwasakwasa-keikeile dedei tete bomatu mena kabo kwabu lalakina yabo silobai dedei Babilon koina kabo simiya bwaine koina. ");
INSERT INTO tteo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Siyatubu siedeedede nume kabikabi kaiwena kabo siba, “Kwalaoma bwatano takalai na biliki tapaisowai na tagabuli na sikaiwe.” Besiele siginauli, kabo bilikine koina nume sikabili yo koluta sikalai siyapatu-kalatagili. ");
INSERT INTO tteo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Kabo siba, “Kwalaoma ala yanuwa lalakina tapaisowai yo luwaluwalina mena nume yabo takabi saliyana malamalawena isae itupa yaloyaloi mena, ala kaba gagasa. Tapaisowai besiele kabo esala ilalaki na tabu tamimiya-tatagwaligwali yanuwa yaulina dedeina meuloina kolili.” ");
INSERT INTO tteo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Sikabikabi kabo Yaubada ilobima yanuwane lalakinane yo numene malamalawenane igitaili. ");
INSERT INTO tteo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Kabo iwaloba, “Tomo bwaite siya boda kaigeda yo kaina kaigeda koina siedeedede, sauga bwaite koina iyaele siyatubu sipaipaisowa, na sauga muli mena tem tawae nuwanuwali sipaisowai ee sowasowali kani sipaisowai besiele. ");
INSERT INTO tteo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kwalaoma talobi kainali taula-pwanopwano na tabu kalikavao ali edeedede sikakatai.” ");
INSERT INTO tteo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","9","Bwaine kamwasane koina Yaubada tomo itawo-gwaligwalili silau yanuwa yaulina dedeina meuloina kolili. Yo ali paisowa kabikabi silopei. Kabo yanuwa esana sipei Babeli, kaiwena yanuwane koina Yaubada tomo meuloili kainali iula-pwanopwano. ");
INSERT INTO tteo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Semi menatunao yo tubunao edeededeli besiele bwaite. Semi ana bolime 100 kabo natuna ikabi esana Alipakisadi. Bwaite iyawatagili bolime labui yalubwasi lalakina mulina mena. ");
INSERT INTO tteo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Alipakisadi ana kabi mulina mena Semi imiyamiya tabe bolime 500 kabo iboita. Natunao tatao yo sinesineo tupwaliyao ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Alipakisadi ana bolime 35 kabo natuna ikabi esana Sela. ");
INSERT INTO tteo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sela ana kabi mulina mena Alipakisadi imiyamiya tabe bolime 403 kabo iboita. Natunao tatao yo sinesineo tupwaliyao tabe ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela ana bolime 30 kabo natuna ikabi esana Ebe. ");
INSERT INTO tteo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ebe ana kabi mulina mena Sela imiyamiya tabe bolime 403 kabo iboita. Natunao tatao yo sinesineo tupwaliyao tabe ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebe ana bolime 34 kabo natuna ikabi esana Pelegi. ");
INSERT INTO tteo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pelegi ana kabi mulina mena Ebe imiyamiya tabe bolime 430 kabo iboita. Natunao tatao yo sinesineo tupwaliyao tabe ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelegi ana bolime 30 kabo natuna ikabi esana Liu. ");
INSERT INTO tteo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Liu ana kabi mulina mena Pelegi imiyamiya tabe bolime 209 kabo iboita. Natunao tatao yo sinesineo tupwaliyao tabe ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Liu ana bolime 32 kabo natuna ikabi esana Selagi. ");
INSERT INTO tteo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Selagi ana kabi mulina mena Liu imiyamiya tabe bolime 207 kabo iboita. Natunao tatao yo sinesineo tupwaliyao tabe ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Selagi ana bolime 30 kabo natuna ikabi esana Nao. ");
INSERT INTO tteo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nao ana kabi mulina mena Selagi imiyamiya tabe bolime 200 kabo iboita. Natunao tatao yo sinesineo tupwaliyao tabe ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nao ana bolime 29 kabo natuna ikabi esana Tila. ");
INSERT INTO tteo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Tila ana kabi mulina mena Nao imiyamiya tabe bolime 119 kabo iboita. Natunao tatao yo sinesineo tupwaliyao tabe ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tila ana bolime 70 kabo natunao ikabili esaliyao Abelem, Nao yo Alan. ");
INSERT INTO tteo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Na Tila me natunao yo tubunao edeededeli bwaite besiele. Tila natunao tatao ikabili esaliyao Abelem, Nao yo Alan. Kabo Alan natuna tau ikabi esana Lota. ");
INSERT INTO tteo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Lota dunao Milika yo Iska sikabili kabo tamali Alan iboita yanuwa Ula, dedei Kolodiya koina, yanuwane bwaine koina Alan sikabi. ");
INSERT INTO tteo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abelem ikasole wainena esana Sele yo Nao ikasole wainena esana Milika iya Alan natuna. ");
INSERT INTO tteo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Na Sele iya sine miyamiya yaina nige ikakabi. ");
INSERT INTO tteo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tila itolo natuna Abelem yo tubuna Lota yo bwasiyana Sele ikalaili mwa yanuwa Ula dedei Kolodiya silogabaen yakato silau Kenani. Na saugana siyawatagili yanuwa esana Alan koina bwaine koina simiya. ");
INSERT INTO tteo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tila ana bolime 205 ilobai kabo iboita yanuwa Alan koina. ");
INSERT INTO tteo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Kabo kaliyate yabo koina Yaubada iwalo Abelem koina iba, “Am yanuwa, totoumwao yo tamam ana nume kana tomiyayao kulogabaegili, kulau yanuwa bwaine kani yayakenayagiwo. ");
INSERT INTO tteo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Kani tubumwao sibaibaiwa yaeliwa siyamala boda kaikaiwena yabo yo kani yawalo-muloloiwo esam ilalaki yo kowa koliwo kani tomo mulolo lalakina silobai. ");
INSERT INTO tteo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Siya simulolo koliwo yau tabe yamulolo kolili, na siya sikawa-gulaiwo yau tabe kani yakawa-gulaili. Yo kowa koliwo susu meuloili yanuwa yaulina meuloina kani yawalo-muloloili.” ");
INSERT INTO tteo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abelem ana bolime 75, kabo yanuwa Alan ilogabaen yo ilau, besiele Yaubada ana walo koina. Na Lota tabe ilau mekanakava. ");
INSERT INTO tteo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abelem wainena Sele yo kanakava natuna Lota ikalaili mekanakavao ana gogo wasawasa meuloina yo ana topaisowao meuloili siya ilobaili yanuwa Alan koina. Kabo yanuwane silogabaen yo silalau Kenani kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Saugana siyawatagili dedei Kenani kana sigasiga koina kabo silopanaisi yo silau yanuwa Sikemi yo yanuwane bwaine koina Mole ana mayau lalakili yaowana simiyamiya na lolonyao kolili sikaiyawasi. Na sauganane koina Kenani tomonliyao siyaele simiyamiya. ");
INSERT INTO tteo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Kabo Yaubada iyawatagili Abelem koina yo iba, “Dedei bwaite kani yaolena tubumwao kolili.” Kabo Abelem kaba pwaoli iginauli yanuwane koina yo itapwalolo Yaubadane koina iya mwa iyawatagili koina. ");
INSERT INTO tteo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Imwawasi kabo Abelem ilau koya yabo koina yanuwa Betele dedei pwatana mena, yo ana palai iyatolo yanuwa Betele yo yanuwa Ai luwaluwalili mena. Na yanuwa Betele imiya-lobima dedei pae yo yanuwa Ai imiya-sae dedei pwata mena. Kabo kaba pwaoli yaboyoi iginauli yo itapwalolo Yaubada koina. ");
INSERT INTO tteo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Bwaine koina kabo ikwasa yoi ilau dedei leleyanna Negebi kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kabo guliyam lalakina iyawatagili dedeinane koina mwa Abelem ilau Itipita na tem imiyamiya bwaine koina. ");
INSERT INTO tteo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Kikiunamo Abelem iyawatagili Itipita dedeina mena mwa iwalolau wainena koina iba, “Sele, yakatai kam koleya inamwanamwasosi, ");
INSERT INTO tteo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","na tem Itipita sigitaiwo kani siba, ‘Wainena bwaite’, kabo siunuyamateyau yo kowa sikalaiwo meyawasim. Tem sineli koliwo kabo kuwalo kolili kuba, ");
INSERT INTO tteo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","‘Dugu bwaite’, kabo kowa kaiwem kani simulolo koliyau, kani nige sowasowana siunuiyau.” ");
INSERT INTO tteo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Sauganane siyawatagili Itipita koina meuloili Sele sigitai kana koleya inamwanamwasosi, ");
INSERT INTO tteo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","besiele kin ana topaisowao lalakili Sele sigitai kabo silau kin koina kana koleya sikawa-namwanamwa-yan yo sitobalan. Mwa iwalo silau siyogan silawan ana nume mena, mekanakava simiyamiya. ");
INSERT INTO tteo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Kabo kin sipi, gouti, bulumakau, donki, kameli yo ana topaisowa panpanli yo ginauli meuloina iwolegili Abelem koina Sele kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Na Yaubada kasiebwa naenaena iyawasa kin mekanakavao tomiya meuloili sikasiebwa kaiwena kin Abelem wainena ikalai silusae mekanakava simiyamiya ana nume mena. ");
INSERT INTO tteo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Mwa kin kainana iyawasa ilau Abelem koina yo saugana iyawatagilima ineli iba, “Toisabo mumuga uginauli koliyau? Tawae kaiwena yagu wasa nige kuyeyeyama yakato Sele iya wainem? ");
INSERT INTO tteo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Tawae kaiwena kuwalo yakato iya dum mwa yayogan besiele wainegu? Wainem bwaite saugamo kuyogan na kwalau.” ");
INSERT INTO tteo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Kabo kin iwalo ana topaisowao kolili mwa Abelem me wainena siyawasa-yapileyoili me ali gogo wasawasa meuloina Itipita silogabaen. ");
INSERT INTO tteo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Kabo Abelem me wainena ali wasawasa meuloina sikatububun yo Itipita silogabaen yo silau dedei Negebi. Na Lota tabe ilau mekalikava. ");
INSERT INTO tteo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abelem iwasawasasosi ana yakayakan sibaibaiwasosi besiele ana siliba yo ana gole. ");
INSERT INTO tteo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Kabo Abelem ikwasa yoi kikiuna kikiuna ilaulau yanuwa yo yanuwa kolili, kanasiga iyawatagili Betele yo Ai luwaluwalili mena bwaine beyabeyana ana palai iyatolo koina. ");
INSERT INTO tteo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Yo bwaine koina beyabeyana kaba pwaoli ipaisowai kabo itapwalolo yoi Yaubada koina. ");
INSERT INTO tteo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Na Lota iya mekanakava Abelem silolokeikeile, iya tabe ana sipi, gouti, bulumakau yo ana topaisowao sipagan. ");
INSERT INTO tteo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Abelem yo Lota nige sowasowali simiya-kaigeda kaiwena ali yakayakan sibaibaiwasosi, yo ali kaba kekan nige ilalalaki. ");
INSERT INTO tteo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Kabo gamwapakiki iyawatagili Abelem yo Lota ali yakayakan kali togite-kalatan kolili. Na sauganane koina Kenani yo Pelisi tomonliyao siyaele simiyamiya dedeine koina. ");
INSERT INTO tteo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Kabo Abelem iwalo Lota koina iba, “Nige nuwala gamwapakiki kowa yo yau kolila yo ala yakayakan kali togite-kalatan kolili kaiwena kowa te yau tubula kaigeda. ");
INSERT INTO tteo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Na sowana tamiya-suwala kulau dedei yabo na yau yalau dedei yabo. Bwatano dedei yabo ugite-sipwai na kulau kumiya koina. Tem kulau dedei teya kaluwabu mena yau kani yalau teya yavayavana mena, na tem kulau tete yavayavana mena yau kani yalau tete kaluwabu mena.” ");
INSERT INTO tteo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Kabo Lota manna igabaen waila Yolidan kwabuna inamwanamwa yo wailana ilalaki ilau kanasiga yanuwa Sowa koina besiele tabe Yaubada ana tano Ideni yo yanuwa Itipita. Na kana koleya besiele bwaite muli mena kabo kani Yaubada yanuwa Sodoma yo yanuwa Gomola isibayanaeli. ");
INSERT INTO tteo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Mwa Lota Yolidan kwabuna meuloina igite-sipwai iya iboma kaiwena kabo isae bwaine koina imiya. Na Abelem yo Lota ali miya-suwala bwaite besiele. ");
INSERT INTO tteo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Kabo Abelem ilau imiyamiya dedei Kenani koina na Lota ilau imiyamiya Yolidan kwabuna yanuwanane kalona mena mwa ana palai iyatololi Sodoma salina mena. ");
INSERT INTO tteo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Na Sodoma tomonliyao ali paisowa inaesosi kaiwena silopwano lalakina Yaubada koina. ");
INSERT INTO tteo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Na Lota ilau bwaine koina mwa Yaubada iwalolau Abelem koina iba, “Dedei bwaite koina kutotolone manim ugwabaen ilau dedei tete kaluwabu, tete yavana, tete bomatu yo tete yalasi. ");
INSERT INTO tteo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Dedeine bwaine ugitaili bwatanona meuloina yaeyawa-gabaen me tubumwao kolimiu sauga meuloina yo nige ana kaba mwawasi. ");
INSERT INTO tteo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Tubumwao sibaibaiwasosi kani yaeliwa besiele bwatano kauna. Kaiwena nige sowasowana tomo bwatano kauna iyasili woli besiele tabe nige sowasowana tubumwao siyasili woli. ");
INSERT INTO tteo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Na kulau bwatanone kana mamalawe yo kana tabataba kumankulakulaili, siya kani yaeliwa.” ");
INSERT INTO tteo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kabo Abelem ikwasa yoi ilau Ebiloni koina ana palai iyatolo Mamele ana mayau lalakili yaowana lolonyao kolili sikaiyawasi. Bwaine koina kaba pwaoli ipaisowai Yaubada kana pwalou kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","9","Na bolime tuwelo kalona mena kinne yoli paibi (5) simiyamiya, yabo Bila yanuwa Sodoma kana kin, yabo Bilisa yanuwa Gomola kana kin, yabo Sinabi yanuwa Adima kana kin, yabo Semiba yanuwa Seboim kana kin yo yanuwa Bela, esana labuina Sowa, kana kin takesi siyamayamaisa kin Kedolaoma iya yanuwa Elama kana kin koina kabo bolime tetinna (13) koina nige siyayamaisa, sisikote. Bolime potinna (14) koina kabo Kedolaoma imunamunai yo ilau yanuwa Baiboni kana kin esana Amilapeli yo yanuwa Eliyesa kana kin esana Alioki, yo yanuwa Goim kana kin esana Taidali ikalaili ilaoma siyaboda kaigeda na siloina kaleya kaiwena. Ali laune koina sikaleya yanuwa kikiuli kolili, sikaleya baguna bwaimwa boda Lapaimi siyemwawasili yanuwa Asiteloti Kanaim koina yo boda Susim siyemwawasili yanuwa Ami koina yo boda Emim siyemwawasili yanuwa Kiliyataim kwabuna koina. Tabe boda Oli sikaiwe-gabaegili Seil koyana kolili mwa sitawoili kanasiga Epalan dedei leleyanna salina mena. Mwa Kedolaoma me ana bodao sitagelakeile yo sipileyoi silau yanuwa Keidesi, esana yaboyoi Enmispat, kabo boda Amaleki siyemwawasili yo ali dedei meuloina sikalai. Besiele tabe boda Amoli siya simiyamiya yanuwa Aseson Tamal koina Kedolaoma me ana bodao sitolo Amoli bodane siyemwawasili. Imwawasi silau yanuwa Sidim kwabuna koina dedeinane koina Kalita Boiboitana imiyamiya, na bwaine koina kin yoli paibine me ali tokaleyayao silogogomako sisanasana kaleya kaiwena. Kabo Kedolaoma me ana bodao silaomayoi sikaleya kin paibi me ali tokaleyayao kolili. ");
INSERT INTO tteo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Kedolaoma me ana bodao sikaiwe mwa Sodoma ali kin mekanakavao ali tokaleya siyabubu. Na Sidim kwabunane koina bwatano gulagulali sibaibaiwa simiyamiya na gulane kaloli mena bwatano naenaena patupatuna sipowon koluta. Kabo saugana siyabubu tokaleyayao tupwali sibeku koluta kali gula kaloli mena yo tupwaliyao siyabubu silau sikawasae koya kolili. ");
INSERT INTO tteo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Na kin siya yoli esopaline silau Sodoma yo Gomola ali wasawasa yo kali meuloina sikalaili mwa silau. ");
INSERT INTO tteo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Yo tabe Abelem kanakava natuna Lota tabe sipan siyogan mekanakava ana gogo wasawasa meuloina sikalaili kaiwena sauganane koina iya imiyamiya Sodoma. ");
INSERT INTO tteo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Tomo yabo iyabubu kabo ilau ginauli meuloina iyawasayan Abelem game Ibeliu koina. Sauganane koina Abelem imiyamiya Mamele game Amoli ana mayau dedeina mena. Na Mamele mekanakavao Eskol na Anel siya Abelem kana tosaguwo kaleya koina. ");
INSERT INTO tteo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Saugana Abelem ibenalan kanakava natuna Lota sipan silawan, kabo Abelem ana bodao kali baibaiwa 318 iyoganli kabo Kedolaoma me ana bodao siyamuli kusulili kanasiga silau siyawatagili yanuwa Dani koina. ");
INSERT INTO tteo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Bwaine koina Abelem ana tokaleyayao iyakasali boda yo boda kolili. Ali kaba kaleya dedeili igite-sipwaili na silau kolili simiya kabo boniyainane koina sisagena-yawatagili meuloili yo sikaleya Kedolaoma me ana tokaleyayao kolili. Sikele-gwaligwalili yo sitawoili kanasiga yanuwa Oba bwaimwa Damasiko dedei teya kaluwabu mena. ");
INSERT INTO tteo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Kabo Abelem gogo meuloina siya Kedolaoma mekanakavao sikalaili sikele-yapileyoili. Besiele kanakava natuna Lota me ana gogo wasawasa ikalaili mekanakavao sinesineo yo tomo tupwaliyao tabe. ");
INSERT INTO tteo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Kaleya imwawasi mulina mena kabo Abelem me ana bodao sipileyoima. Kabo Salem kana kin esana Melekisedeki yo Sodoma kana kin silau mekalikava Abelem simiya-gogo Save kwabuna koina. ");
INSERT INTO tteo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melekisedeki iya Yaubada saesaesosina ana topwaoli beledi yo wain ikalailima iwolegili Abelem koina yo iwalo-muloloi, ");
INSERT INTO tteo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","iba, “Yaubada miyamiya saesaesosina iya bulibuli yo yanuwa yaulina kana toyamayale Abelem imuloloiwo. ");
INSERT INTO tteo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kabo Yaubada miyamiya saesaesosina tatobalan kaiwena kam tokalomagigiliwo ipeili nimam mena.” Kabo Abelem ginauli meuloina siya ikalaili kaleya koina iyakasali gwau sanaulu, kalona mena gwau kaigeda iwolena Melekisedeki koina. ");
INSERT INTO tteo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Imwawasi kabo Sodoma kana kin iwalo Abelem koina iba, “Ginauli meuloina ukwabi-kalatan kaiwem na yagu tomoyaomo kuyelima-yapileyoili koliyau.” ");
INSERT INTO tteo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Kabo Abelem ana walo ibenalan yo iba, “Nimagu yakeleisinan yakawalulu Yaubada koina Yaubada saesaesosina iya bulibuli yo yanuwa yaulina kana toyamayale, ");
INSERT INTO tteo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","kani nige am gogo yabo yakakalai, bwagana kikitoitoi molosina besiele buti kana maina, meuloina kani yaeyawa yapileyoili, kaiwena nige nuwagu sauga muli mena kuba, ‘Yau gogo wasawasane meuloina yaolena mwa kabona Abelem iyamala towasawasa.’ ");
INSERT INTO tteo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Kani nige ginauli yabo yakakalai, bwaimwanamo tem yau kilakaiwo sikekan yo tawae yasoiyanako kagu tosaguwo yaiyonane Anel, Eskol yo Mamele kolili ali gogone sikalai.” ");
INSERT INTO tteo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Kabo kaleyane mulina mena Yaubada kainana iyawatagili Abelem koina bwaite besiele. Kana yakeyakenayan koina Yaubada iba, “Abelem, tabu kumamatausi, yau am ebeu yakausiwo nae koina yo yau kam mulolo lalakina kani yaeyawa.” ");
INSERT INTO tteo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Mwa Abelem iba, “O Guyau Yaubada, tawae kana namwanamwa tem mulolone kuyeyama? Kaiwena yau nige natugu ipapagan. Na bwaliga tem yaboita Eliesa iya game Damasiko sikabiyan yagu nume kalona mena yo iyamala yagu topaisowa panpanna iya kani yagu wasawasa ikalai yo iloinayagili.” ");
INSERT INTO tteo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Kabo Yaubada iba, “Saugane tem kuboita tomone bwaite iya kani nige am wasawasane ikakalai. Na natum tauna yabo kani iyawatagilima kwasinem koina iya am wasawasane kani ikalaili.” ");
INSERT INTO tteo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Kabo Abelem iyoga-yawatagilan yauli mena yo iwalolau koina iba, “Manim isae mwayaga bwagabwaga mena utu ugitaili. Gubesi, sowasowam kuyasilili? Nigele, bwaliga kani tubumwao kali baibaiwa bwaine besiele.” ");
INSERT INTO tteo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abelem Yaubada imeliyan, mwa Yaubada Abelem ikawa-namwanamwa-yan ana meli kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Kabo Yaubada iwalolau Abelem koina iba, “Yau Yaubada yakalaiwo yanuwa Ula dedei Kolodiya koina yo dedei bwaite yaeyawa ukwalai am dedei.” ");
INSERT INTO tteo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Na Abelem ineli iba, “O Guyau Yaubada, gubesi na yakatai dedeine bwaite kani kuyeyama yagu dedei?” ");
INSERT INTO tteo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Kabo Yaubada iwaloba, “Bulumakau sinena kaigeda, gouti kaigeda yo sipi tauna kaigeda kali bolime yaiyona besiele tabe bunetutu kaigeda yo bunebune kaigeda ukwalaili kulawagilima koliyau.” ");
INSERT INTO tteo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Mwa Abelem yakayakan bwaite ikalaili yo ilawagili Yaubada koina mwa inigwe-labui-yagili na ipeili bwatano mena, na bunebune yo bunetutu nige ininigwe-labui-yagili. ");
INSERT INTO tteo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Na man lalakili tupwaliyao sieva-talu yakato yakayakanne kwapiliyao sikanli na Abelem itawoili. ");
INSERT INTO tteo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Dabwelo isugu kabo Abelem ikeno ana kenone koina kenona ikenoi igitai boniboniyai lalakina mwa imatausi. ");
INSERT INTO tteo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Kabo Yaubada iwalolau koina iba, “Ukwatai namwanamwai bwaite tubumwao bwaliga dedeine sikalai, na baguna silau simiya taumana yanuwa uloina koina, siyamala topaisowa panpanli yo siyakamkamnali bolime kana baibaiwa powa andeledi (400) koina. ");
INSERT INTO tteo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Siya tubumwao siyamala topaisowa panpanli yakalaili yo saugana yanuwane silogabaen kani wasawasa lalakina sikalai. Na siya kali toyakamkamnane maisa naenaena lalakina kani silobai. ");
INSERT INTO tteo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Na kowa kani kutautaubala yawasosi na me am nuwadaumwali kuboita yo kwapim sipei salai mena. ");
INSERT INTO tteo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Na tubumwao siya yaso esopalina siya kani sipileyoima dedeine bwaite koina. Kaiwena Amoli tomonliyao kani simiyamiya, kani nige yatatawoili. Na sauga ilalaoma koina kani mumugana naenaena ilalaki kolili kabo sauganane koina kani yayamaisa kolili.” ");
INSERT INTO tteo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Dabwelo isuguko mwa iboniboniyai, kabo mayau wedowedolina gulewana bogabogauna yo odam kalapulupululuna siyawatagilima yo silobi yakayakan kwapiliyao sininigwe-labui-yagiliwa luwaluwalili mena sieva-sola. ");
INSERT INTO tteo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Kaliyatenane koina kabo Abelem kenona mena igitai yakato walo yawasosi bwaite koina Yaubada kelabilabin kamwasana kana kilakilala iginauli. Kabo Yaubada iwalo Abelem koina iba, “Dedei bwaite yatalamwan yaolegili tubumwao kolili, iyatubuya Itipita kanasiga ilau waila Yupeleitisi koina, bwaimwa ");
INSERT INTO tteo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Keni ali dedei, Kenisi ali dedei, Kadimoni ali dedei, ");
INSERT INTO tteo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Iti ali dedei, Pelisi ali dedei, Lepaim ali dedei, ");
INSERT INTO tteo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amoli ali dedei, Kenani ali dedei, Giligasi ali dedei, yo Yebusi ali dedei.” ");
INSERT INTO tteo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Abelem me wainena Sele simiyamiya Kenani koina bolime sanaulu. Na Sele nige natuna yabo ikakabi na ana topaisowa panpanna sinena yabo imiyamiya esana Ega, Itipita sinena. Kabo Sele iwalo Abelem koina iba, “Yaubada ikausiyau kani nige yakakabi. Na kulau yagu topaisowa panpanna sinena mekamkava wakeno, na tem isiuma yo ikabi, kabo melumelune yakawa-natu-wan.” Mwa Abelem italam. Kabo Sele ana topaisowa panpanna Ega ilawan Abelem koina besiele wainena yaboyoi. ");
INSERT INTO tteo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abelem mekanakava Ega sikenokeno mwa isiuma. Saugana Ega ikatai isiuma, nige ana yakasisi yaboyoi Sele koina yo Sele iyamala ginauli bwagabwaga Ega manna mena. ");
INSERT INTO tteo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Mwa Sele iwalolau Abelem koina iba, “Kowa am pwanoli bwaite. Yagu topaisowa yaeyawa koliwo na sauganane isiuma mwa igite-lobiyegau. Yaubada iboma ikatai yaiya idudulai yo yaiya nigele.” ");
INSERT INTO tteo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abelem Sele kainana iyamaisa iba, “Na iya am topaisowa panpanna imiyamiya am loina koina. Uginauli koina besiele tawae am nuwatu.” Kabo Sele Ega ikalomagigilan yo paisowa polopolowena iwolena koina me ana munamunai mwa Ega Sele iyabubu-gabaen. ");
INSERT INTO tteo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ega iyabubu ilalau Sulu kana kamwasa koina bwaimwa dedei leleyanna yo iyawatagili waila doelu yabo koina sabi kaiyawasi kabo Yaubada ana anelose iyawatagili koina. ");
INSERT INTO tteo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Mwa iba, “Ega, Sele ana topaisowa panpanna, toweya kulaomaya yo toweya kulalau?” Kabo kainana iyamaisa iba, “Yagu keduluma Sele yayabubu-gabaen.” ");
INSERT INTO tteo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Kabo anelosene iba, “Kupileyoi kulau am keduluma koina na kumiyamiya ana loina yaulina mena. ");
INSERT INTO tteo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Bwaliga kani tubumwao sidebalala nige sowasowana tomo yabo iyasili woli. ");
INSERT INTO tteo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Na kusiumako mwa kani ukwabi natum tauna na esana kupei Isimeli, kaiwena am valam Yaubada ibenalanako. ");
INSERT INTO tteo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Na iboma iloinayan besiele yakayakan sokasokana, ikalekaleya tomo meuloili kolili, yo tomo meuloili sikalekaleya koina mwa kani nige mekanakavao totounao simimiya-namwanamwa.” Anelosene ana walo iyemwawasi kabo Ega ilogabaen. ");
INSERT INTO tteo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Kabo Ega me ana nuwapwanopwano yo walo bwaite iwalowen iba, “Gubesi na Yaubadane iya igitagitaiyau yau yagitaiyako?” Kabo Yaubada esana ipei ‘Yaubada kowa ugitagitaiyau.’ ");
INSERT INTO tteo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Bwaite iya kaiwena mwa tomo wailane doelune esana sipei ‘Yaubada meyawasina igiteyau wailana.’ Na wailane iyaele yanuwa bwaine Keidesi yo Belid luwaluwalili mena. ");
INSERT INTO tteo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Kabo Ega ipileyoi imiyamiya Abelem koina kanasiga ikabi kabo Abelem melumelune esana ipei Isimeli. ");
INSERT INTO tteo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Sauganane Abelem ana bolime eiti sikisi (86) kabo Ega Isimeli ikabi. ");
INSERT INTO tteo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abelem ana bolime naenti naen (99) kabo Yaubada iyawatagili koina yo iwalolau koina iba, “Yau Yaubada Tokaiwesosi. Kuobigaiyau na mesabana am paisowa meuloina sidudulai. ");
INSERT INTO tteo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Na yagu kelabilabin kamwasana kani yaginauli koliwo kabo tubumwao yayadebalalali sibaibaiwa.” ");
INSERT INTO tteo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Mwa Abelem italu-pwaopwaom bwatano mena kabo Yaubada iwalo koina iba, ");
INSERT INTO tteo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Yau yagu kelabilabin kamwasana yaginauli koliwo na kowa kani kuyamala boda meuloili tamali kowa. ");
INSERT INTO tteo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Kani nige sauga yaboyoi esam siyoyogayan Abelem na esam yapei Abelamo. Kaiwena yawaloko kowa kani kuyamala boda meuloili tubuli. ");
INSERT INTO tteo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Tubumwao kani yayadebalalali sibaibaiwa siyamala boda lalakina yo tubumwao tupwaliyao kani siyamala kin. ");
INSERT INTO tteo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Kelabilabin kamwasana bwaite yapaisowai iya waloyameli miyamiya yaina kowa koliwo yo tubumwao yaso yo yaso kolili. Na yau kani yaemala am Yaubada yo tubumwao ali Yaubada. ");
INSERT INTO tteo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Sauga bwaite koina dedei Kenani koina kumiya-taumana na bwatanona meuloina kani yaeyawa koliwo yo tubumwao kolili iyamala ami gogo miyamiya yaina. Na yau kani yaemala tubumwao ali Yaubada. ");
INSERT INTO tteo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Na nuwanuwagu kowa yagu kelabilabin kamwasana kana loina kuobigaili kowa yo tubumwao yaso yo yaso kolili. Na kami loinane bwaite besiele, ami tatao meuloili nigwenigwe mumugana sikalai. ");
INSERT INTO tteo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Yomiu isuna kwapina kwatom-gabaegili na iyamala kelabilabin kamwasana kana kilakilala yakato me ami talam. ");
INSERT INTO tteo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ami tatao yaso yo yaso saugana sikabili yo ali kaliyate eit (8) imwawasi kabo nigwenigwe mumugana meuloina sikalai. Komiu natumiyao, ami topaisowa panpanli yo siya sikabili ami nume mena yo siya simiyamiya ami nume kalona mena yo besiele ami topaisowa panpanli siya silaoma dedei uloili kolili siya tabe sikalai. ");
INSERT INTO tteo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Meuloili nigwenigwe mumugana sikalai kabo yagu kelabilabin kamwasana miyamiya yaina kana kilakilala imiyamiya kwapimiu mena. ");
INSERT INTO tteo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Tem kilakai yabo nige yona isuna kwapina sitotom-gabaen iya kani sitawoi ali susu kalona mena imiya-suwala kaiwena yagu kelabilabin kamwasana kana loina ilikwai.” ");
INSERT INTO tteo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Mwa Yaubada iwaloyoi Abelamo koina iwaloba, “Na wainem Sele, kani nige sauga yaboyoi esana siyoyogayan Sele na esana yapei Sela. ");
INSERT INTO tteo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Wainem kani yawalo-muloloi na natuna tauna kani ikabi. Na melumelune koina kani boda meuloili sidebalala yo tabe yanuwa kali kin kani siyawatagilimaya iya koina, yakato Sela boda meuloina sinali iya.” ");
INSERT INTO tteo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Kabo Abelamo italu-pwaopwaom bwatano mena iyatubu imalu yo iba, “Yagu bolime wan andeledi (100) na gubesi yakato natugu ipagan? Na Sela iya ana bolime naenti (90), na gubesi yakato kani ikabi? ");
INSERT INTO tteo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Nuwana Isimeli iya iyamala am walo-mulolo tomona, na gubesi, yakato iya bwaite kaiwena kuwalowalone koliyau?” ");
INSERT INTO tteo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Kabo Yaubada iba, “Nigele. Wainem Sela kani ikabi natuna tauna esana kupei Aisake. Yagu kelabilabin kamwasana miyamiya yaina kani yaginauli iya koina yo tubunao kolili yaso yo yaso kolili. ");
INSERT INTO tteo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Na am kawanoi Isimeli kaiwena yabenalanako. Walo yawasosi kani yawalo-muloloi na tubunao yayadebalalali meuloina, bwaliga natunao tatao kali baibaiwa tuwelo siya siyamala susu kali tobaguna, yo tubunao sibaibaiwa yaolegili siyamala boda kaikaiwena yabo. ");
INSERT INTO tteo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Na yagu kelabilabin kamwasana kani yaginauli Aisake koina iya bolime ilalaoma waikena bwaite koina Sela kani ikabi.” ");
INSERT INTO tteo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Yaubada ana edeedede iyemwawasi mwa ilogabaen. ");
INSERT INTO tteo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Kabo kaliyatenane koina Abelamo iginauli besiele Yaubada ana walo kabo tatao meuloili ana nume kana tomiya yoli kwapina isuna sitom-gabaegili, natuna Isimeli, ana topaisowa panpanli sikabili ana nume kalona mena yo ana topaisowa panpanli siya iyamaisali silaoma dedei uloili kolili, meuloili ipaisowai kolili besiele. ");
INSERT INTO tteo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Na Abelamo ana bolime naenti naen (99) kabo yona kwapina isuna itom-gabaen. ");
INSERT INTO tteo_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Yo natuna Isimeli ana bolime tetin (13). ");
INSERT INTO tteo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Sauganane koina Abelamo ipaisowai tawae Yaubada ana loina koina. Mwa Abelamo me natuna Isimeli nigwenigwe mumugana sikalai. ");
INSERT INTO tteo_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Besiele tabe kaliyatenane koina tatao meuloili ana nume kana tomiya nigwenigwe mumugana sikalai. ");
INSERT INTO tteo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abelamo imiyamiya Mamele ana mayau meuloili dedeili mena, kabo kaliyate yabo pwasinasina koina Yaubada iyawatagili yoi koina. Abelamo imiyasio ana palai gamwana mena, ");
INSERT INTO tteo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","kabo manna igabaen, yo sauganane koina tatao yoli yaiyona igitaili sitotolo nige kali mwayaga imamamalawe. Kabo itolo ilomwayamwayau ilau kolili, yo ipwalou manli mena yo italu-pwaopwaom bwatano mena. ");
INSERT INTO tteo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Yo iwalo kolili iwaloba, “Yagu tautaubalao, yau ami topaisowa, tem kwayaliyaya koliyau na tabu kwalalau na mekaukavao komiu tamiyamiya bwaite koina. ");
INSERT INTO tteo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Yawalo yagu topaisowa koina waila kikiuna ikalaiyama kabo kaemiu kwadeulili yo wakaiyawasi mayaune lolonna mena. ");
INSERT INTO tteo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Tem kwatalam kan kikiuna yakalaiyama wakekan na yomiu sikaikaiwe, kabo wakaiyawasi muli mena kwalau yoi.” Kabo kainana siyamaisa siba, “Inamwanamwa, uginauli besiele am walo.” ");
INSERT INTO tteo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Kabo Abelamo mwayamwayau ipileyoi ilau ilusae ana palai kalona mena yo iwalo Sela koina iba, “Mwayamwayau pwalawa manna namwanamwana ukoi disi lalakina yaiyona kana liye, yo kuebweli yo beledi ugwabu.” ");
INSERT INTO tteo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Kabo mwayamwayau ilau ana bulumakau bodaliyao kolili yo sinisinibuna bulumana namwanamwana yabo igite-sipwai. Mwa iwolena ana topaisowa yabo koina na iya mwayamwayau ikatububunan. ");
INSERT INTO tteo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Kabo kan ikatububunan imwawasi yo Abelamo miliki yo bata tupwana lalakina mekanakava bulumakau bulumana yo katutuna ikalaili ilau yoli yaiyonane iwolegili na sikekan. Na Abelamo itolo salili mena mayau lolonna koina yo igite-kalatagili. ");
INSERT INTO tteo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Mwa sineli Abelamo koina siba, “Wainem Sela toweya?” Kainali iyamaisa iba, “Iyaele palai kalona mena.” ");
INSERT INTO tteo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Kabo kalikava yabo iba, “Bolime ilalaoma waikena bwaite koina kani yapileyoima kabo wainem Sela natuna tauna ikabi.” Na Sela iyaele ibenabenali palaine gamwana salina mena. ");
INSERT INTO tteo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Iya kedukeduluma yo Abelamo iya tautaubala yo ali bolime ilalakisosi, yo Sela nige waikena kasiebwana ilolobai. ");
INSERT INTO tteo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Kabo ibomayoi imalu iba, “Yakedukedulumako yo yagu taubala iya itautaubalako na nige tabe sowasowagu yaliyaya bwaite yalobai yakato melumelu bwaite yakabi.” ");
INSERT INTO tteo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Kabo Yaubada iwalo Abelamo koina iba, “Tawae kaiwena Sela imalu yo iba, ‘Yau yakedukedulumako nige sowasowana yakabi’? ");
INSERT INTO tteo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Yau Yaubada, koliyau nige ginauli yabo ipopolowe. Na bolime ilalaoma waikenane bwaite koina yapileyoima kabo wainem kani ikabi natuna tauna.” ");
INSERT INTO tteo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sela imatausi yo iuvala iba, “Yau nige yamamalu.” Kainana iyamaisa iba, “Nigele, na walo yawasosi kumalu.” ");
INSERT INTO tteo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Kabo tatao yoli yaiyonane sitolo yo silau sisae putete mena manli sigabaen ilobi Sodoma sigitai. Na Abelamo ilau mekanakavao silotoyawa silau na yakato ipei-gabaegili. ");
INSERT INTO tteo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Na Yaubada ibomayoi inuwanuwatu iba, “Tawae kani yapaisowai nige sowasowana yawadam Abelamo koina. ");
INSERT INTO tteo_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Kaiwena bwaliga tubunao siyamala boda lalakina yo boda kaikaiwena yabo yo iya koina tomo meuloili yanuwa yaulina mena kani yawalo-muloloili. ");
INSERT INTO tteo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Iya yagite-sipwai natunao yo ana nume kana tomiyayao iyakenayagili yau Yaubada yagu kamwasa simuliya, kabo ginauli namwanamwana yo dudulaina sipaipaisowai, kabo tawae yawaloyameli iya kaiwena yapaisowai.” ");
INSERT INTO tteo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Kabo Yaubada itagelakeile yo iwalo Abelamo koina iba, “Yanuwa Sodoma yo Gomola wasali ilalaki yakato naenaena mumugana koina sikaiwesosi. ");
INSERT INTO tteo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Naga yalobi yagitaili tem walo yawasosi mumugali naenaena kana lalaki besiele tawae yabenalan o tem nigele.” ");
INSERT INTO tteo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Kabo tatao labuine sisalulu silobi silalau Sodoma kamwasana kaiwena. Na Yaubada mekanakava Abelamo simiyamiya putete mena. ");
INSERT INTO tteo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Na Abelamo ilau Yaubada salina mena yo ineli iba, “Gubesi, kani siya todudulai mekalikavao tonaenaeli kuyemwawasili? ");
INSERT INTO tteo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Gubesi tem siya todudulai kali baibaiwa pipti (50) siyaele yanuwane koina, kani yanuwane meuloina kusibayanae? O gubesi, todudulai yoli piptine (50) kaiweli yanuwane kani kuleboi? ");
INSERT INTO tteo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Nige sitotoyatoyawa tem todudulai yo tonaenaeli kuunuyamate kaigedaili. Kaiwena kowa yanuwa yaulina kali toyatala dudulaina kabo sowasowana loina dudulaina koina kuyatalayagili.” ");
INSERT INTO tteo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yaubada Abelamo kainana ibenalan kabo iba, “Tem todudulai kali baibaiwa pipti yalobaili yanuwa Sodoma kalona mena kani siya kaiweli yanuwa meuloina yaleboili.” ");
INSERT INTO tteo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Kabo Abelamo iwaloyoi iba, “Guyau, yau tomo bwagabwagamo besiele bwatano siebweli mwa yawalowalo kabo kutalamwagau naga yaedeedede yoi. ");
INSERT INTO tteo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Gubesi, tem todudulai kali baibaiwa poti paibi (45) siyaele bwaine yanuwane kalona mena? Todudulai yoli poti paibine kaiweli kani yanuwane kuleboi?” Yaubada kainana iyamaisa iba, “Tem todudulai kali poti paibi yalobaili kani nige yanuwane yasisibayanae.” ");
INSERT INTO tteo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Kabo Abelamo iwalo yoi iba, “Gubesi kali baibaiwa poti tem kulobaili?” Yaubada kainana iyamaisa iba, “Tem kali baibaiwa poti siyaele kani nige sowasowana yanuwane yasibayanae.” ");
INSERT INTO tteo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Na Abelamo iba, “Guyau, tabu kumumunamunai na nuwanuwagu yawalo yoi koliwo. Gubesi tem kali baibaiwa tetimo (30) kulobaili?” Kabo Yaubada iba, “Tem kali baibaiwa teti yalobaili kani nige sowasowana yasibayanaeli.” ");
INSERT INTO tteo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Kabo Abelamo iba, “Guyau yawaloko kutalamwagau na yaedeedede yoi. Gubesi tem kali baibaiwa tuwenti kulobaili?” Kainana iyamaisa iba, “Tem kali baibaiwa tuwenti yalobaili kani nige sowasowana yanuwane yasibayanae.” ");
INSERT INTO tteo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Kabo Abelamo iwaloba, “Guyau tabu kumumunamunai na nuwanuwagu mekaigeda yoi yaedeedede koliwo. Gubesi tem kali baibaiwa sanaulumo kulobaili?” Mwa Yaubada iba, “Tem kali baibaiwa sanaulu yalobaili kani nige sowasowana yanuwane yasibayanae.” ");
INSERT INTO tteo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Yaubada ana walo iyemwawasi kabo Abelamo ilogabaen yo Abelamo ipileyoi ana palai koina. ");
INSERT INTO tteo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Kaliyatene kaigedana koina lolau molosi mena kabo anelose labuine silau siyawatagili yanuwa Sodoma. Na Lota iyaele imiyasio yanuwa kana gana kaba lusalusaena mena. Saugana anelose igitaili kabo itolo yo ilau kolili kabo ipwalou manli mena italu-pwaopwaom bwatano mena. ");
INSERT INTO tteo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Kabo iwalolau kolili iba, “Yagu tautaubalao, yau ami topaisowa, yakawanoi kolimiu kwalaoma yagu nume mena na kaemiu kwadeulili, na boniyai wakeno yagu nume mena na bwaliga malala kikiuna kabo kwalau.” Kabo Lota kainana siyamaisa siba, “Nigele, kakenoya bakubaku mena bwaite kaba logogone koina.” ");
INSERT INTO tteo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Na Lota iwalo-samasamalulu kabo silau mekalikava silusae ana nume mena. Mwa iwalo ana topaisowa kolili iba, “Pwalawa nige mekanakava yisti kwaebweli wagabu yo kan wakatububunan na sikekan.” ");
INSERT INTO tteo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Na nige naga sikekeno kabo tatao meuloili, kilakaiwo yo tautaubalao silaoma yanuwa Sodoma kalona meuloina kolili silau numene sitolo-takikilan. ");
INSERT INTO tteo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Kabo siyoga-lusae Lota koina siba, “Tatao siya silaoma koliwo boniyaine bwaite koina toweya? Kuyoganli silaoma siyawatagili kolimai na kaganawali kolili.” ");
INSERT INTO tteo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Kabo Lota ilau iyawatagili kolili yo gamwa dagelana mena ikausi. ");
INSERT INTO tteo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Yo iwalolau kolili iba, “Yagu eliyamwao, tabu mumugana naenaena kwapaipaisowai. ");
INSERT INTO tteo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Na natuguwao sinesineo labui simiyamiya nige naga silalau tatao kolili. Tem nuwanuwamiu kani yakalaili na siyawatagilima kolimiu, kabo tawae nuwanuwamiu waginauli kolili. Na tabu ginauli yabo wagiginauli tataone kolili kaiwena siya silaoma kagu taumanao.” ");
INSERT INTO tteo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Na Lota kainana siyamaisa siba, “Kutolo-suwala, kaiwena kowa taumana. Yaiya kowa yakato kuloinayagimai? Kulowasi. Tem nigele, kani nae lalakina kaginauli koliwo kabo muli mena bwaite labuine.” Kabo Lota situbali-yapileyoi mwa silaoma yakato gamwane sikogwaligwali. ");
INSERT INTO tteo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Na tatao labuine nume kalona mena nimalimo siyawatagili Lota sitabe-luseyanama mwa gamwa sikausi. ");
INSERT INTO tteo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Kabo tomo meuloili nume dedeina mena manliyao siyaboniboniyaili mwa nige sowasowali gamwane sigitai yo silobai. ");
INSERT INTO tteo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Mwa tomowa labuiwa siwalolau Lota koina siwaloba, “Yanuwa bwaite mumugali naenaena wasana ilalakisosi Yaubada ibenalanako, kabo iyawasamai kalaoma na kasibayanae. Tabu am boda tupwaliyao yoi simiyamiya? Tem natumwao tatao yo sinesineo kali kawakawaluluwo, o tem totoumwao tupwaliyao yoi yanuwane bwaite koina? Tem simiyamiya kulau ukwalaili yo mekamkavao kwayawatagili kaiwena yanuwa bwaite kani kasibayanae.” ");
INSERT INTO tteo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Mwa Lota ilau natunao sinesineo kali kawakawaluluwo kolili iba, “Mwayamwayau kwalaoma yanuwa bwaite talogabaen, kaiwena Yaubada kani isibayanae.” Na ali nuwatu yakato italatalawasi. ");
INSERT INTO tteo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Malala kikiuna aneloseyao Lota situpa-tototoyai siba, “Mwayamwayau wainem yo natumwao sinesineo labui saugamo bwaite mekamkavao ukwalaili, na yanuwa bwaite kwayabubu-gabaen. Kabo kani Yaubada isibayanae na komiu kani nige kwaboboita.” ");
INSERT INTO tteo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Na Lota me ana nuwa-labulabui mwa iyaele inuwanuwatu-keikeile kabo Yaubada ikatekamkamna-yan mwa anelose labuine Lota mekanakavao wainena yo natuliyao sinesineo labui nimali mena sikabilau yo siyoganli siyawatagili yanuwane koina. ");
INSERT INTO tteo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Mwa siyawatagili imwawasi kabo anelosene yabo iwalo kolili iba, “Kwayabubu kisi kwaboita. Tabu kwatatagela-keikeile, mwayamwayau kwalau. Tabu wakakaiyawasi Yolidan kwabune mena o yanuwana yabo koina. Kwayabubu kwalau koya kolili kani nige nae kwalolobai.” ");
INSERT INTO tteo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Na kainana Lota iyamaisa iba, “Taubala besi. ");
INSERT INTO tteo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mumugamiu sinamwanamwa kwamulolo koliyau yo yawasigu kwaleboi. Na nige sowasowagu yayabubu koyane kolili, kani nige naga yayawatagili na naene bwaite yalobai kabo yaboita. ");
INSERT INTO tteo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Na sowasowagu yayabubu yalau bwaine yanuwa kikiunane koina na lebo yalobai? Kaiwena nige kana mwayaga imamamalawe yo tabe yanuwane kikiuna, wa?” ");
INSERT INTO tteo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Mwa anelose iwalo Lota koina iba, “Inamwanamwa, yatalam kulau bwaine koina besiele am kawanoi. Kabo yanuwane bwaine kani nige yasisibayanae. ");
INSERT INTO tteo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Na mwayamwayau kuyabubu kulau bwaine koina, kaiwena nige sowasowana ginauli yabo yapaisowai kanasiga kuyawatagili yanuwane koina.” Lota yanuwane ikawa-kikikikiu-wan mwa esana sipei Sowa. ");
INSERT INTO tteo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Dabwelo imwalisae kabo Lota menatunao siyawatagili yanuwa kikiuna Sowa koina. ");
INSERT INTO tteo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kabo sauganane koina Yaubada veku salepa wedowedolina isuwe-gabaen italuma yanuwa Sodoma yo Gomola kolili. ");
INSERT INTO tteo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Kabo yanuwane yo dedeine bwaine kwabuliyao kalona mena meuloina mekalikavao tomo meuloili siya simiyamiya bwaine koina yo ginauli bwaine sikinkin bwatano mena tabe Yaubada isibayanaeli. ");
INSERT INTO tteo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Na Lota dagelana mena wainena imulimuliya kabo sinene itagela-keile yo iyamala kalita kolokololona besiele tuki itotolo. ");
INSERT INTO tteo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Bwaine kaliyatene malalanane koina, Abelamo isulubon ilau itolo putetene koina laina Yaubada mekanakava sitotolo koina na siedeedede. ");
INSERT INTO tteo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Kabo manna ilobi yanuwa Sodoma yo Gomola kolili yo dedeine kwabuna meuloina koina, mwa igitaili yanuwa bogauna balubaluna isaesae besiele mayau sigabu gula kalona mena bogauna. ");
INSERT INTO tteo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Kabo edeededena besiele bwaite. Yolidan dedeina meuloina mekanakava Sodoma yo Gomola Yaubada isibayanaeli. Na Yaubada Abelamo ana kawanoi nige nuwana imwamwatainan mwa anelose Lota sitabe-niuniuli siyabubuwan yanuwane ilogabaen yo mulina mena yanuwane iwedoli woli. ");
INSERT INTO tteo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lota menatunao simiyamiya yanuwa kikiuna Sowa koina. Na Lota tomo Sowa imatausagili kabo menatunao sinesineo labui silau koya kolili kabo simiyamiya dupa yabo koina. ");
INSERT INTO tteo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Na kaliyate yabo natuna sinena lalakina iwalolau kikiuna koina iba, “Tamala itautaubalako mwa nige tatao ipapagan dedeine bwaite koina na mesabana mekalakavao takasole na natulao sipagan besiele yanuwa yaulina meuloina tatao yo sinesineo siginaginauli. ");
INSERT INTO tteo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Wain takalai tamala tayanuma yauyaule, na mesabana takalai mekalakava takeno na iya koina natulao sipagan, na tabu ala susu ikwakwalalele.” ");
INSERT INTO tteo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Kabo boniyainane koina wain sikalai tamali siyanuma yauyaule mwa lalakinane ilau ilusae yo me tamana sikeno. Na tamana nige ikakatai natuna ilau ilusae na mekanakava sikeno yo nige tabe ikakatai ana yawatagili. ");
INSERT INTO tteo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Yanuwa ilayan kabo natuna lalakina iwalo kanakava kikiuna koina iba, “Boniyai mena yau yo tamala kakeno, na kansiga boniyai tayanuma yauyaule yoi na kowa kulusae na mekamkava wakeno na mesabana iya koina natulao sipagan na tabu ala susu ikwakwalalele.” ");
INSERT INTO tteo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Mwa iboniyai tamali siyanuma yauyaule yoi kabo natuna kikiuna ilau ilusae metamana sikeno. Na tamana nige ikakatai yakato ilau ilusae na mekanakava sikeno yo nige tabe ikakatai ana yawatagili. ");
INSERT INTO tteo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Kabo Lota natunao labuine sisiuma ali siumane ilaomaya tamali koina. ");
INSERT INTO tteo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Mwa lalakina ikabi natuna tauna kabo esana ipei Mowabe. Na iya boda Mowabe sauga bwaite tubuliyao siya simiyamiya. ");
INSERT INTO tteo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Yo kikiuna tabe ikabi natuna tauna, esana ipei Benami. Na iya boda Amoni bwaite sauga tubuliyao siya simiyamiya. ");
INSERT INTO tteo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abelamo Mamele ana mayau dedeina ilogabaen mwa iyawatagili ilau dedei Negebi yo imiyamiya bwaine koina yanuwa Gelal, bwaimwa Keidesi yo Sulu luwaluwalili mena. ");
INSERT INTO tteo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Kabo Abelamo tomo ali wasa iwolegili wainena Sela kaiwena iba, “Bwaite dugu.” Kabo Abimeleki yanuwa Gelal kana kin ibenalan mwa iwalo ana topaisowa kolili silau Sela siyoganama koina yo iyoga-luseyan ana nume mena. ");
INSERT INTO tteo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Na boniyai yabo koina kenona koina Yaubada iyawatagili Abimeleki koina iba, “Kowa kani kuboita kaiwena sine bwaite ukwalai iya kasokasolena.” ");
INSERT INTO tteo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Na Abimeleki nige naga Sela mekanakava sikekeno mwa kainana iyamaisa iba, “Guyau, yau nige nae yagiginauli. Yakato yau yo yagu tomoyao kuunuyamatemai? ");
INSERT INTO tteo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abelamo yagu wasa iyeyama yakato sinene duna yo tabe Sela iwaloyoi koliyau yakato duna Abelamo. Na kategu mena meyagu nuwamayale nige naenaena yabo yapapaisowai.” ");
INSERT INTO tteo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kabo kenonane koina Yaubada iwaloyoi Abimeleki koina iba, “O, walo yawasosi, nige nae yabo ugiginauli. Kaiwena yau mwa yakausiwo naenaena koina kabo nige kwapina ukakabitonan. ");
INSERT INTO tteo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Na sine bwaite kuyapileyoi wainena koina kaiwena iya palopita yo kani ikawanoi kaiwem na tabu kuboboita. Na tem nige kuyayapileyoi kani kuboita mekamkavao am nume kana tomoyao meuloili.” ");
INSERT INTO tteo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Yanuwa ilayan malala kikiuna Abimeleki ana topaisowa lalakili meuloili iyoganlima kabo ginauli meuloina siya siyawatagili kenonane koina iedeededeyan kolili, mwa simatausi lalakina. ");
INSERT INTO tteo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Kabo Abimeleki Abelamo iyoganama yo iwalolau koina iba, “Mumugam tawatawaena uginauli kolimaine? Yau nige naenaena yabo yapapaisowai koliwo, na am paisowa kaiwena yau yo yagu tomoyao polowe lalakina kalobai. Am paisowa koliyau inaesosi kabo muli mena tomo meuloili kolili. ");
INSERT INTO tteo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Tawae kaiwena uginauli besiele?” ");
INSERT INTO tteo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abelamo kainana iyamaisa iba, “Yabatoko yanuwa bwaite tomonliyao Yaubada nige simamatausan mwa yagu nuwatu kani kwaunuyamateyau na wainegu wakalai. ");
INSERT INTO tteo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Na walo yawasosi, yau yo Sela mekaukava tamamai kaigeda na sinamaiyao uloili bwaite kaiwena mwa yakasolanan. ");
INSERT INTO tteo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Mwa saugana Yaubada iwalo tamagu ana nume kalogabaen yawalo Sela koina yaba, ‘Tem kumulolo koliyau na toisabo dedei koina talalau tomo ali wasa kuwolegili kuba, Tomo bwaite iya dugu.’” ");
INSERT INTO tteo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Kabo Abimeleki sipi, bulumakau yo topaisowa panpanli, sinesineo yo tatao, ikalaili yo iwolegili Abelamo koina. Kabo wainena Sela iwolena-yapileyoi koina. ");
INSERT INTO tteo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Mwa iwalo Abelamo koina iba, “Manim ugabaen yau kaba loina kana lalaki ugitai na dedei yabo ugite-sipwai na kulau kumiya koina.” ");
INSERT INTO tteo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Kabo iwalo Sela koina iba, “Mane siliba tausan kaigeda yaolena wainem koina bwaimwa mwalimwaline kaba yadudulaina kaiwena na tomo meuloili sikatai walo yawasosi yakato kowa nige nae yabo ugiginauli.” ");
INSERT INTO tteo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Na beyabeyana Abimeleki Sela iyoga-luseyan ana nume mena mwa koina Yaubada Abimeleki ana nume kana tomiya sinesineo meuloili kabi ikausili kolili nige sowasowali sisiuma. Kabo Abelamo ikawanoi Yaubada koina mwa Yaubada Abimeleki wainena yo ana topaisowa panpanli sinesineo iwoisili sowasowali tabe sisiuma yo sikabi. ");
INSERT INTO tteo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yeoba Sela iwalo-muloloi besiele beyabeyana ana walo, mwa iginauli koina besiele ana waloyameli. ");
INSERT INTO tteo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Kabo isiuma, mwa Abelamo ana sauga tautaubala koina natuna tauna Sela ikabi. Na sauganane koina Yaubada Abelamo iwaloyameli ana sauga yawasosi koina mwa melumelune iyawatagili. ");
INSERT INTO tteo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Kabo Sela ikabi yo Abelamo esana ipei Aisake. ");
INSERT INTO tteo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Saugana Aisake sikabi mwa ana kaliyate eit (8) ilobai, kabo Abelamo natuna Aisake yona isuna kwapina itom-gabaen, besiele Yaubada ana walo koina. ");
INSERT INTO tteo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Na Abelamo ana bolime kana lalaki wan andeledi (100) koina mwa natuna Aisake Sela ikabi. ");
INSERT INTO tteo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Kabo Sela iwalo iba, “Yaubada nuwagu iula-malumalu yamalu yo yayaliyaya. Saugana tomo meuloili wasagu sibenalan kani mekaukavao kamalu toyawa. ");
INSERT INTO tteo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Beyabeyana tomo sikataiyako yakato kani nige yakakabi yo nige yabo iwawalo Abelamo koina, ‘Wainem kani melumelu yabo iyasusu.’ Na iyamo Abelamo ana sauga tautaubala koina natuna tauna iyaele yakabiyako.” ");
INSERT INTO tteo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Kabo melumelune ilalaki sauganane koina susu siyasikotanan Abelamo kan lalakina ipaisowai kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Kaliyate yabo koina Sela igitagitai gagagiliwone sikekevenuvenu ali venune koina Isimeli, iya Abelamo natuna Ega Itipita sinena koina, itolo Aisake igamwa-kamkamna-yan. ");
INSERT INTO tteo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Kabo iwalo Abelamo koina iba, “Sine topaisowa panpanna menatuna kuyawasali silau. Kaiwena sinene natuna kani nige am gogo wasawasa ikakalaili, natugu Aisake iyamo kani ikalaili.” ");
INSERT INTO tteo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Walone bwaite kaiwena Abelamo katena ikamkamna lalakina, kaiwena Isimeli tabe iya natuna. ");
INSERT INTO tteo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Na Yaubada iwalo Abelamo koina iba, “Tabu katem ikakamkamnasosi am topaisowa panpanna me natuna kaiweli. Sela ana walo koliwo uginauli besiele kaiwena tubumwao siya yawaloyameli kaiwem kani siyawatagilimaya Aisake koina. ");
INSERT INTO tteo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Na sine topaisowa panpanna natuna tubunao sibaibaiwa kani yaolegili yo siya tabe kani siyamala kaba loina yabo, kaiwena iya tabe natum.” ");
INSERT INTO tteo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Yanuwa ilayan malala kikiuna Abelamo kan tupwali, mekanakava waila patu yabo iya gouti kwapina siginauli ikalaili mwa ilau ipeili Ega leyaleyana mena. Mwa menatuna iyawasali silau, yo silolo-bwagabwaga Biyasiba ana dedei leleyanna koina. ");
INSERT INTO tteo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Saugana waila imwawasi waila patune kalona mena, Ega mayau yabo kikiuna igitai lolonna kabo natuna ilawan ipei lolonne koina, ");
INSERT INTO tteo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","kabo mayaune ilogabaen ilau kana mamalawe besiele wan andeledi (100) mita kabo imiyasio, kaiwena ana nuwatu iba, “Tabu natugu yagitagitai na iboita.” Na Ega iyaele imiyasio imiyamiya yo ivalavalam. ");
INSERT INTO tteo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Mwa Yaubada ibenalan melumelune ivalavalam, kabo Yaubada ana anelose iyoga Ega koina kainana ilobimaya bulibuli mena iba, “Ega, gubesi? Tawae am nuwapolowe? Tabu kumamatausi, Yaubada melumelune ana valam ibenalanako toweya kupeiya. ");
INSERT INTO tteo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Kutolo kulau melumelune ukwalai kusapwali kaiwena bwaliga tubunao sibaibaiwa kani yaolena, na siya kani siyamala kaba loina kaikaiwena yabo.” ");
INSERT INTO tteo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Kabo Yaubada waila keli yabo iyakenayan, mwa Ega ilau waila patu iloyakalapowon, kabo tupwana iwolena melumelune inuma. ");
INSERT INTO tteo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Na melumelune ilalalalaki yo Yaubada imiyamiya koina. Imiyamiya ule dedei leleyanna koina yo iyamala gipoyo kana toula namwanamwana keloya kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Saugana simiyamiya dedeine leleyanna esana Palan koina, Isimeli sinana Itipita sinena yabo ilobai mwa iyoganama Isimeli ikasolanan. ");
INSERT INTO tteo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Sauga yabo koina kin Abimeleki mekanakava ana tokaleyayao ali tobaguna Pikol silau Abelamo koina, yo Abimeleki iwalolau koina iba, “Yakatai Yaubada imiyamiya koliwo mwa ginauli meuloina kupaisowaili sinamwanamwa. ");
INSERT INTO tteo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Na Yaubada manna mena ukwawalulu yakato yau, menatuguwao yo tubuguwao kani nige kumwamwakota-yagimai. Yau mumuga namwanamwana yaginauli koliwo, mwa kuwaloyameli mumuga namwanamwana tabe uginauli koliyau, yo yanuwane bwaite kumiya taumana koina kana loinao kuobigaili.” ");
INSERT INTO tteo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Kabo Abelamo italam yo ikawalulu iba, “O inamwanamwa.” ");
INSERT INTO tteo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Imwawasi kabo Abelamo Abimeleki iyokoiyan waila keli yabo kaiwena, beyabeyana Abimeleki ana topaisowao silaoma wailane siwalo-kausi. ");
INSERT INTO tteo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Na Abimeleki iuvala iwalolau koina iba, “Yau nige yakakatai analiyao ali paisowa. Beyabeyana nige yagu wasa kuyeyeyama, bwaite kabona kabo yabenalan.” ");
INSERT INTO tteo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Kabo Abelamo sipi yo bulumakau tupwali ikalaili mwa iwolegili Abimeleki koina, mwa yoli labuine ali kelabilabin kamwasana siginauli. ");
INSERT INTO tteo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Imwawasi Abelamo ilauyoi ana sipi luwali mena kabo natuliyao sinesineo seben ikalaili ipei-suwalagili. ");
INSERT INTO tteo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Kabo Abimeleki ineli koina iba, “Tawae kaiwena mwa sipi sebenne kupei-suwalagili?” ");
INSERT INTO tteo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Mwa kainana Abelamo iyamaisa iba, “Sipine bwaite tem ukwalaili na koina ukawa-yawasosi yakato waila keline yau yakeli.” Mwa Abimeleki sipine ikalaili besiele Abelamo ana walo. ");
INSERT INTO tteo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","32","Kabo yanuwane esana siyogayan Biyasiba, kaiwena dedeine koina yoli labuine kelabilabin kamwasana sipaisowai. Imwawasi kabo Abimeleki mekanakava ana tokaleyayao ali tobaguna Pikol sipileyoi ali yanuwa mena dedei Pilistiya koina. ");
INSERT INTO tteo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Mwa Abelamo mayau yabo esana tamaliski ikumai yanuwa Biyasiba koina, yo bwaine koina ipwalou Yeoba Yaubada miyamiya yaina koina. ");
INSERT INTO tteo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Na Abelamo imiyamiya tomo Pilistiya ali dedei koina sauga imamalawe. ");
INSERT INTO tteo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Kabo muli mena Yaubada Abelamo ana meli itonan. Edeededena bwaite besiele. Iwalolau koina iba, “Abelamo.” Kabo Abelamo italam iba, “O, yau elete.” ");
INSERT INTO tteo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Kabo Yaubada iwalo koina iba, “Natum kaigedamo Aisake, iya kumulolososi koina kuyogan mekamkava kwalau dedei Molaiya. Bwaine koina kani koya yabo yawalowen koliwo na natum kupwaoliyan koliyau.” ");
INSERT INTO tteo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Yanuwa ilayan malala kikiuna Abelamo ilau ana donki ikatububunan yo pwaoli kana mayau tupwali isenali imwawasi kabo ana topaisowa labui yo natuna Aisake mekanakavao silau dedeine bwaine Yaubada iwawalowenwa koina. ");
INSERT INTO tteo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Kaliyate yaiyonana koina, Abelamo manna ilau dedeine igitai kelamamalawe mena. ");
INSERT INTO tteo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Kabo iwalo ana topaisowao kolili iba, “Kwamiyamiya bwaite koina donki mekamikava. Yau mekaukava gamene kalau bwaine koina na katapwalolo Yaubada koina, kabo kapileyoima kolimiu.” ");
INSERT INTO tteo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Kabo Abelamo pwaoli kana mayau iwolena Aisake ikewai, na iya mayau wedolina yo naipi ikalaili. Saugana yoli labuine silaulau, ");
INSERT INTO tteo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","kabo Aisake iwalo tamana koina iba, “Tamagu.” Mwa Abelamo iba, “O, natugu.” Kabo Aisake ineli iwaloba, “Mayau wedolina yo pwaoli kana mayau iyaele takalakalaili na sipi natuna pwaoli kaiwena toweya?” ");
INSERT INTO tteo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Kainana Abelamo iyamaisa iba, “Natugu, Yaubada iboma kani sipi natuna iyeyama pwaoli kaiwena.” Kabo yoli labuine silauyoi. ");
INSERT INTO tteo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Saugana siyawatagili dedeine bwaine Yaubada iwawalowenwa koina, kabo Abelamo veku ikalaili kaba pwaoli ipaisowai yo mayau ipeili pwatana mena. Imwawasi natuna Aisake kaena yo nimana ipanli yo ipeiseyan kaba pwaoli pwatana mena. ");
INSERT INTO tteo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Kabo nimana ilau naipi ikalai yakato natuna iunuyamate. ");
INSERT INTO tteo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Na Yeoba ana anelose bulibuli mena iyoga-lobima iba, “Abelamo, Abelamo.” Kabo Abelamo italam iba, “O, yau elete.” ");
INSERT INTO tteo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Kabo anelosene iba, “Tabu gamene kuunuyamate. Tabu nae yabo ugiginauli koina. Bwaite sauga yakatai kuyakasisi-yagau yo kuobigaiyau kaiwena natum kaigedamo nige kununuwai koliyau.” ");
INSERT INTO tteo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Kabo Abelamo itagelakeile igitai sipi tauna yabo sokina mayau kubwakubwana lagalagana koina iloka itotolo. Kabo ilau ikalaiyama ipwaoliyan Yaubada koina natuna miyalaena. ");
INSERT INTO tteo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Mwa Abelamo yanuwane esana ipei “Yeoba kani iyeyama.” Na ilaoma kanasiga sauga kabona, tomo iyaelemo siwalowalowen “Yeoba ana koya koina kani iyeyama.” ");
INSERT INTO tteo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Kabo Yeoba ana anelose bulibuli mena ana yoga labuina Abelamo koina, ");
INSERT INTO tteo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","iba, “Yeoba iba, ‘kaiwena uginauli besiele yagu walo yo natum kaigedamo nige kununuwai koliyau, kabo yabomayoi esagu mena yakawalulu, ");
INSERT INTO tteo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","kani yawalo-muloloiwo na kani tubumwao yayadebalalali kali baibaiwa besiele utu bulibuli mena yo besiele dekawa kali baibaiwa. Tubumwao kali tokalomagigili kani yaemwawasili yo ali yanuwa siya kani sikalaili, ");
INSERT INTO tteo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","yo tubumwao kolili kani tomo meuloili yanuwa yaulina mena kali walo-mulolo silobai. Na kani yapaisowai bwaite besiele, kaiwena yagu walo kuobigai.’” ");
INSERT INTO tteo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Kabo Abelamo mekanakava natuna sipileyoi silau ana topaisowao kolili yo mekalikavao sipileyoi yanuwa Biyasiba. Kabo Abelamo imiya bwaine koina. ");
INSERT INTO tteo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Kabo muli mena Abelamo ana wasa siwolena siba, “Milika ikabikabi kabo kamkava Nao natunao ipagan. ");
INSERT INTO tteo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Esaliyao bwaite Uz iya tobagubaguna, kanakava labuina Buz, yo yaiyonana esana Kemuweli, iya Alami tamana, ");
INSERT INTO tteo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesedi, Aso, Pilidasi, Didilapi yo Betuweli.” ");
INSERT INTO tteo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Na Betuweli iya Libeka tamana. Siya bwaite Milika yo Nao natuliyao yoli eit (8). ");
INSERT INTO tteo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nao wainena labuina nige wainena yawasosi esana Luma ikabi natunao siya Teba, Gam, Tasi yo Maka. ");
INSERT INTO tteo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sela imiyamiya bolime andeledi tuwenti seben (127). ");
INSERT INTO tteo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Kabo iboita Kiliyataba koina, esana labuina Ebiloni dedei Kenani koina. Kabo Abelamo nuwana inae lalakina yo ilau ivalam koyasili wainena kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Kabo Abelamo itolo wainena yona ilogabaen yo ilau dedei kaba miyagogo bwaimwa yanuwa kana gamwa kaba lusalusae koina yo iedeedede tomo Iti kolili iba, ");
INSERT INTO tteo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Yau taumana yamiyamiya luwamiu mena. Bwatano yabo kwatalamwan na yayamaisa kolimiu na wainegu yona yapei.” ");
INSERT INTO tteo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Kabo tomo Iti Abelamo kainana siyamaisa siba, ");
INSERT INTO tteo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Taubala, ama nuwatu kawalowen na kubenalan. Kowa towasawasa yabo luwamai mena. Salai namwanamwana yabo ugite-sipwai kama salaine kolili na wainem yona koina kupei. Nige sowasowana tomo yabo luwamai mena kana salai kani inuwai.” ");
INSERT INTO tteo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Na Abelamo itolo yo me ana yakasisi ipwalou Iti tomonliyao manli mena, ");
INSERT INTO tteo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","kabo iba, “Tem kwayaliyaya yakato wainegu yona yapei bwaite koina kwawalo Epiloni, iya Saol natuna, duluwa Makipela, iyaele ana kwabu papalina mena, igimwalayan koliyau maisana yawasosi koina manimiu mena na iyamala kagu salai.” ");
INSERT INTO tteo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Na Epiloni iyaele bodane luwali mena imiyamiya, ");
INSERT INTO tteo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","yo iwaloba, “Taubala, nigele. Kani kwabune yo duluwane yaeyawa bwagabwagai koliwo tomo meuloili manli mena na wainem yona kupei koina.” ");
INSERT INTO tteo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Na Abelamo ipwalou yoi tomo manli mena, ");
INSERT INTO tteo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","yo iwalolau Epiloni koina iba, “Tem kuyaliyaya kabo yagu nuwatu yawalo-masalan. Na bwatanone bwaite yayamaisa, maisana ukwalai, na wainegu yona yapei bwaine koina.” ");
INSERT INTO tteo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Kabo Epiloni iwalo Abelamo koina iba, “Taubala, bwatano bwaite maisana kana lalaki mane siliba powa andeledi (400), na tabu bwaite iyamala ala kaba gamwapakiki. Kulau na wainem yona kupei koina.” ");
INSERT INTO tteo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Kabo tomo manli mena Abelamo italam yo manene mane siliba powa andeledi iliyeili yo isikeleili besiele togimwala mumugali yo iwolena Epiloni koina. ");
INSERT INTO tteo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Kabo Epiloni ana bwatano bwaite Makipela duluwa iyaele Mamele tete bomatu mena yo kwabune yo mayau meuloili dedeine kalona mena iwolena Abelamo koina iyamala ana gogo. ");
INSERT INTO tteo_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Tomo Iti meuloili siya siyaele kaba miyagogone koina sigitai manli mena yo sikatai bwatanone walo yawasosi Abelamo ana gogo. ");
INSERT INTO tteo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Kabo Abelamo Sela yona ipei duluwane koina Kenani ana dedei koina. ");
INSERT INTO tteo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Mwa bwatanone baguna iya Iti ali gogo sauga bwaite koina iyamala Abelamo ana gogo. ");
INSERT INTO tteo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Na Abelamo iya itautaubala yawasosi yo Yeoba iwalo-muloloi ana paisowa meuloina koina. ");
INSERT INTO tteo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Kabo Abelamo ana topaisowao kali tobaguna iya ana gogo meuloina kana togite-kalatan koina iwaloba, “Nimam kupeili kae bilagu kolili, ");
INSERT INTO tteo_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","na ukawalulu Yeoba esana mena iya bulibuli yo yanuwa yaulina kali Yaubada tabu Aisake wainena ugigite-sipwai Kenani sinesineoliyao luwali mena siya simiyamiya bwaite dedeine koina. ");
INSERT INTO tteo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Na kulau yaboma yagu yanuwa mena yo totouguwao kolili natugu Aisake wainena ugite-sipwai na kuyoganama.” ");
INSERT INTO tteo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Mwa topaisowane ineli koina iba, “Na gubesi tem sinene isikote nige nuwana mekaukava kalaoma? Yakato natum yayogan yalawan yanuwane bwaine kulalaomane koina?” ");
INSERT INTO tteo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abelamo iba, “Nigele, genuwagu ilau yanuwane koina. ");
INSERT INTO tteo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yeoba, iya bulibuli kana Yaubada, kani ana anelose iyawasa-bagunayan na mesabana natugu wainena kulobai bwaine koina kaiwena iya ikele-yawatagilagau tamagu ana boda kolili yo totouguwao ali yanuwa mena yo iwaloyameli koliyau dedei bwaite koina kani iwolena tubuguwao kolili. ");
INSERT INTO tteo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Na tem sinene isikote yo genuwana mekamkava kwalaoma bwaine nige tawae yabo, yo kani yalivasiwo am waloyameli koina. Na ginauli kaigedamo tabu natugu ukwalai kulalawan bwaine koina.” ");
INSERT INTO tteo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kabo topaisowane nimana ipeili ana taubala Abelamo kae bilana kolili na iwaloyameli koina kani natuna wainena iloyai Abelamo ana susuyao kolili. ");
INSERT INTO tteo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Mwa topaisowane mekana tosaguwo ana taubala ana kameli sanaulu ikalaili yo gogo wasawasali iwolena itaulili kabo silau yanuwane koina Abelamo kanakava Nao imiyamiya bwaimwa Mesopoteimiya dedei teya kaluwabu mena. ");
INSERT INTO tteo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Saugana siyawatagili kabo kameli siyakaiyawasili yo siwalo sitalu-miyasio waila keli salina mena yanuwane gana mulina mena. Na ilolauko mwa sinesineo ali sauga silalau waila legu kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Mwa ikawanoi iwaloba, “O Yeoba, yagu taubala Abelamo ana Yaubada, yagu taubala ukwate-kamkamna-yan na kusaguiyau sauga bwaite koina. ");
INSERT INTO tteo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Na yau ele yatotolo waila keli salina mena na kikiunamo yanuwa vesalaliyao silaoma waila legu kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kani yawalo yabo koina, ‘Tem sowasowana am kaba legu mena waila kulegu na yanuma?’ Na tem iba, ‘Inamwanamwa kunuma ee kani waila yaleguyama am kameli sinuma tabe’, kabo kani yakatai iya bwaite ugite-sipwai am topaisowa Aisake kaiwena. Tem iyawatagili besiele kabo yakatai yagu taubala ukwate-kamkamna-yan.” ");
INSERT INTO tteo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Na muliya kabo kawanoi imwawasi, Libeka iyawatagilima me ana komwa kaba legu leyaleyana mena. Na Libeka iya Betuweli natuna yo Betuweli iya Nao yo Milika natuli yo Nao iya Abelamo kanakava. ");
INSERT INTO tteo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Iya sine kana koleya namwanamwasosina yo iya nige naga tau yabo mekanakava sikekeno. Ilau waila keli mena iutusae waila keli pwatana mena ana komwa mena waila ilegu-yakalapowoni imwawasi ikaisulu bwatano mena. ");
INSERT INTO tteo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Kabo topaisowane mwayamwayau ilau Libeka koina yo iba, “Tem sowasowana waila kuyeyama yanuma?” ");
INSERT INTO tteo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Kainana iyamaisa iba, “O kunuma taubala”, kabo mwayamwayau ana komwa nimana mena ipei-yatalu ikabikabi-kalatan na inuma. ");
INSERT INTO tteo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Saugana iyanuma imwawasi kabo iwalo koina iba, “Kani yalau yoi waila yaleguyama am kameli tabe yayanumali kanasiga kali liye silobai.” ");
INSERT INTO tteo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Kabo mwayamwayau wailawa tupwanawa ana komwa mena isuwai kameli ali kaba numa koina, kabo isagena-pileyoi waila mena yo waila ilegulegu kanasiga kameli meuloili kali liye silobai. ");
INSERT INTO tteo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Na tomone imiya-mwanou yo imanmankulakula, nuwanuwana ikatai nuwana bwaine iya sinenaele Yaubada ipeiyako Aisake wainena o nigele. ");
INSERT INTO tteo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Saugana kameli ali numa imwawasi mwa tomone gole lin maisana lalakina ikalai ipei sinene isuna mena yo kelima labui maisali lalakili iyasaeli nimana mena. ");
INSERT INTO tteo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Kabo ineli iba, “Tem sowasowana yagu wasa kuyeyama tamam yaiya? Na tabu biliutusi yabo imiyamiya ana nume mena yo sowasowana kaukavao mekaukavao kakeno bwaine koina?” ");
INSERT INTO tteo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Kainana iyamaisa iba, “Yau Betuweli natuna iya Nao yo Milika natuli. ");
INSERT INTO tteo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Yo biliutusi yabo imiyamiya tamagu ana nume mena na sowasowana wakeno bwaine koina yo tabe kameli kali ilalaki imiyamiya.” ");
INSERT INTO tteo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Kabo tomone italu-miyasio ipwalou itapwalolo Yeoba koina, ");
INSERT INTO tteo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","iba, “Yeoba kowa yagu taubala Abelamo ana Yaubada yatobalanagiwo, kaiwena kubaguna-yagau talaoma yagu taubala ana susuyao kolili yo Aisake wainena kuyakenayagauko kabo yakatai yagu taubala ukate-kamkamna-yan yo am waloyameli koina iyawatagiliko.” ");
INSERT INTO tteo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Kabo sinene isagena ilau sinana ana nume mena na tawae ginauli meuloina iyawatagili koina kaiwena ali wasa iwolegili. ");
INSERT INTO tteo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Na Libeka duna esana Labana. Iya Libeka isuna mena lin igitai yo nimana mena kelima igitaili yo topaisowane ana edeedede Libeka koina ibenalagili kabo ikaisulu nume mena isagena ilau waila keline koina yo igitai tomone itotolo ana kameli mekanakavao wailane salina mena. ");
INSERT INTO tteo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Iwalo koina iwaloba, “Kowa Yeoba ana tomo yakayakasisina. Na tawae kaiwena kutotolo bwaite koina? Kulaoma talau yagu nume mena kaiwena ami kaba miya yakatububu-nanako yagu nume mena, na besiele tabe am kameli ali kaba miya.” ");
INSERT INTO tteo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Kabo Abelamo ana topaisowa me kana tosaguwo silau nume mena. Labana kameli kali kayakayale ipei-yataluli na ikalaili ilawagili ali kaba miya mena, yo kameli kali iwolegili. Imwawasi ilau waila ilegu na topaisowane me kana tosaguwo kaeliyao sideulili. ");
INSERT INTO tteo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Kabo kan sikatububunan yo sikalaiyama na topaisowane iba, “Muliya kabo yakekan na baguna yagu laomane yaina yawalowen.” Kabo Labana iwaloba, “O, inamwanamwa kuedeedede.” ");
INSERT INTO tteo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Kabo topaisowane iwaloba, “Yau Abelamo ana topaisowa. ");
INSERT INTO tteo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yeoba yagu taubala imulolo lalakina koina yo iyawasawasa, sipi, gouti yo bulumakau sibaibaiwa yo siliba yo gole silalaki, topaisowa tatao yo sinesineo yo besiele tabe kameli yo donki sibaibaiwa iwolegili. ");
INSERT INTO tteo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Yagu taubala wainena Sela ikedukedulumako kabo Abelamo natuna tauna ikabi. Na ana gogo meuloina iwolena iloinayan. ");
INSERT INTO tteo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Yagu taubala iwaloma koliyau mwa yakawalulu koina tabu yalalau Kenani sinesineoliyao kolili na natuna wainena yagigite-sipwai, ");
INSERT INTO tteo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","na iwaloba, ‘Kulau tamagu totounao yo ana susuyao kolili na natugu wainena ugite-sipwai ukwalaiyama.’ ");
INSERT INTO tteo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Mwa yagu taubala yaneliyan yawaloba, ‘Na gubesi tem sinene isikote nige nuwana mekaukava kalaoma?’ ");
INSERT INTO tteo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Kainagu iyamaisa iba, ‘Yeoba iya manna mena yamiyamiya kani ana anelose iyawasa mekamkava na am laune koina isaguiwo kabo natugu wainena kulobai totouguwao ali nume kalona mena. ");
INSERT INTO tteo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Na tem kulau kolili na sinene isikote kani yalivasiwo kawalulune koina.’ ");
INSERT INTO tteo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Kabona yalaoma waila keline koina mwa yakawanoi yaba, ‘O Yeoba, yagu taubala Abelamo ana Yaubada, tem am nuwatu besiele nuwanuwagu kusaguiyau yagu laomane koina. ");
INSERT INTO tteo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Na yau ele yatotolo waila keli salina mena na tem vesalane iya ilalaoma waila legu kaiwena, na yawalo koina yaba, Tem sowasowana am kaba legu mena waila yanuma? ");
INSERT INTO tteo_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Na tem iba, Inamwanamwa kunuma na kani tabe waila yaleguyama am kameli sinuma kabo kani yakatai iya bwaite ugite-sipwai yagu taubala natuna kaiwena.’ ");
INSERT INTO tteo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Na muliya kabo kawanoi yaemwawasi kategu mena, Libeka iyawatagilimako ana waila kaba legu komwa ikewakewai leyaleyana mena. Ilau imwalisae waila keli pwatana mena ilegu yo ikaisulu bwatano mena kabo yawalo koina yaba, ‘Tem sowasowana waila kuyeyama yanuma?’ ");
INSERT INTO tteo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Kabo mwayamwayau ana komwa nimana mena ipei-yatalu ikabikabi-kalatan yo iba, ‘O kunuma taubala, kani yalau yoi waila yaleguyama na am kameli tabe yayanumali.’ Kabo yanuma yo yagu kameli tabe iyanumali. ");
INSERT INTO tteo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Na yaneli yaba, ‘Na tamam yaiya?’ Kabo iba, ‘Yau Betuweli natuna, iya Nao yo Milika natuli.’ Kabo isuna gulana mena lin yapei nimana kolili kelima yayasaeli. ");
INSERT INTO tteo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Kabo yapwalou na yatapwalolo Yeoba koina yo yatobalan, iya yagu taubala Abelamo ana Yaubada, kaiwena iyadudulaiyau yalaoma yagu taubala kanakava tubuna sine yakalai natuna kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Na tem yagu taubala wakate-kamkamna-yan yo nuwanuwamiu waginauli besiele ana nuwatu kabo yagu wasa kwaeyama. Tem nigele, kabo yagu wasa tabe kwaeyama yoi na yanuwanuwatu tawae kani yaginauli.” ");
INSERT INTO tteo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Kabo Labana yo Betuweli kainana siyamaisa siba, “Nuwatu bwaite ilaomaya Yeoba koina mwa kai nige sowasowamai loina yabo kaginauli. ");
INSERT INTO tteo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Libeka iyaele, ukwalai mekamikava kwalau, kabo mekanakava ami taubala natuna sikasole, besiele bwaite Yeoba ana nuwatu.” ");
INSERT INTO tteo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Saugana Abelamo ana topaisowa ali walo ibenalan kabo ipwalou Yeoba koina. ");
INSERT INTO tteo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Imwawasi kabo kaleko namwanamwana yo galogalo gole yo siliba ikalailima iwolena Libeka koina. Tabe Libeka duna yo sinana kali mulolo ginauli maisali lalakili iwolena kolili. ");
INSERT INTO tteo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Imwawasi kabo topaisowane me kana tosaguwo sikekan yo sinuma boniyainane koina sikeno bwaine koina. Yanuwa ilayan sitolo yo iwalo kolili iwaloba, “Kwatalamwagau yapileyoi yagu taubala koina.” ");
INSERT INTO tteo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Na Libeka duna yo sinana siwaloba, “Nigele, tem naga mekamakava gamasinene kamiyamiya tem wiki kaigeda o kaliyate sanaulu kabo kwalau.” ");
INSERT INTO tteo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Na iwalolau kolili iba, “Tabu wakakabi-kalatagimai. Yeoba yagu laomane yaina kaiwena isaguiyauko koina kabo kwatalamwagau na yapileyoi yagu taubala koina.” ");
INSERT INTO tteo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Mwa kainana siyamaisa siba, “Naga gamasinene tayoganama na ana nuwatu tabenalan.” ");
INSERT INTO tteo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Kabo Libeka siyoganama sineli siba, “Nuwanuwam mekamkava tomone bwaite kwalau?” Kabo iwaloba, “Besiele yalalau.” ");
INSERT INTO tteo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kabo sitalam na Libeka yo ana topaisowa sinesineo na yabo iya mekikiuna mena kana togite-kalatan, Abelamo ana topaisowa yo kana tosaguwo mekalikavao silau. Na muli mena kabo silau, ");
INSERT INTO tteo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Libeka siwalo-muloloi siwaloba, “Dumai, kani kakawanoi Yeoba koina na kowa kuyamala boda tausan yo tausan sinali yo tubumwao kani kali tokalomagigiliwo siyemwawasili kabo ali yanuwa sikalaili.” ");
INSERT INTO tteo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Mwa Libeka yo ana topaisowao sinesineo sikatububu yo simwalisae kameli pwatali mena yo Abelamo ana topaisowa yo kana tosaguwo mekalikavao silau. ");
INSERT INTO tteo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Na Aisake iyaele ilolokeikeile ule bwagabwaga mena dedei Negebi koina dedeine esana ‘Yaubada meyawasina igiteyau wailana’. ");
INSERT INTO tteo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Lolau yabo koina Aisake ilau ilolokeikeile ule mena na inuwanuwatu, kabo manna ilau kameli igitaili silalaoma. ");
INSERT INTO tteo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Na saugana Libeka Aisake igitai kabo ana kameli pwatana mena ikaisulu, ");
INSERT INTO tteo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","kabo ineli Abelamo ana topaisowa koina iba, “Toisabo tomo bwaite kwabu mena ilalaomane kolila?” Mwa topaisowane iba, “Bwaimwa yagu taubala Aisake.” Kabo Libeka kaleko kayakayagena yabo ikalai yo manna isuma. ");
INSERT INTO tteo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Saugana siyawatagili, kabo topaisowane ana paisowa wasana meuloina iwalo-masalan Aisake koina. ");
INSERT INTO tteo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Kabo Aisake Libeka iyogan silau sinana Sela ana palai kalona mena mwa ikasolanan. Aisake wainena Libeka imulolo lalakina koina kabo ana nuwanae sinana kaiwena imwawasi kaiwena Libeka ikabi-yaliyaya-yan. ");
INSERT INTO tteo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abelamo sine yaboyoi ikasolanan esana Ketula. ");
INSERT INTO tteo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketula Abelamo natunao ikabili Similan, Yokisani, Midani, Midiya, Isibaki yo Suwa. ");
INSERT INTO tteo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokisani natunao labui, yabo esana Seba yo labuina esana Dedani, na iya Dedani tubunao siya boda Asiliya, boda Letusi yo boda Leum. ");
INSERT INTO tteo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiya natunao tatao Epa, Epel, Anok, Abida yo Elda. Na tomo bwaite siya Ketula tubunao. ");
INSERT INTO tteo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abelamo meyawasina koina iwalo bwaite besiele iba, “Tem saugana yaboita yau gogo meuloina Aisake kani ikalaili.” ");
INSERT INTO tteo_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Na muli mena kabo iboita, mulolo iwolegili Ega natuna yo Ketula natunao na iyawasali silau yanuwa dedei tete bomatu mena simiya-suwala natuna Aisake koina. ");
INSERT INTO tteo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abelamo ana bolime 175 ilobai, itona meuloina ilike kabo iboita. ");
INSERT INTO tteo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Kabo natunao Aisake yo Isimeli yona sikalai yo sipei duluwa kalona mena bwaimwa Makipela kwabuna koina Mamele dedei tete bomatu koina. Na kwabune yo duluwane siya beyabeyana Abelamo iyamaisa Epiloni Saol natuna koina iya Iti tomona. ");
INSERT INTO tteo_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Kabo Abelamo yona sipei duluwane koina beyabeyana wainena yona sipei koina. ");
INSERT INTO tteo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abelamo ana boita mulina mena Yaubada Aisake iwalo-muloloi. Sauganane koina iya imiyamiya yanuwa bwaine esana ‘Yaubada meyawasina igiteyau wailana’ salina mena. ");
INSERT INTO tteo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Isimeli edeededena bwaite besiele. Isimeli iya Ega natuna Abelamo koina. Na Ega iya Itipita sinena yo Sela ana topaisowa. ");
INSERT INTO tteo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Isimeli natunao tatao esaliyao silele-yakasali ali kabi kana lau koina besiele bwaite. Nibaiyoti, Kiyola, Edibil, Mibisam, ");
INSERT INTO tteo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misima, Duma, Masa, ");
INSERT INTO tteo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Edada, Tema, Deyeta, Napisi yo Kidima. ");
INSERT INTO tteo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Isimeli natunao yoli tuwelo kolili sidebalala kabo yanuwa tuwelo siyawatagilima na yanuwa kaigeda kaigeda, o nuwana tawaloba ali kaba kaiyawasi kubwakubwa, esana sipeili Isimeli natunao esaliyao kolili. ");
INSERT INTO tteo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Na Isimeli ana bolime kana lalaki wan andeledi teti seben (137) kabo iboita. ");
INSERT INTO tteo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Isimeli tubunao simiyamiya Avil yo Sulu luwaluwalili mena bwaimwa dedei Itipita tete bomatu mena talalau Asiliya kaiwena. Simiya-suwala Abelamo tubunao kolili. ");
INSERT INTO tteo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Na Abelamo natuna Aisake natunao yoli labui ali kabi kana koleya bwaite besiele. ");
INSERT INTO tteo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisake ana bolime poti (40) ilobai kabo Libeka ikasolanan. Libeka iya Betuweli natuna yo Labana duna, siya Alami tomonliyao simiyamiya dedei Mesopoteimiya koina. ");
INSERT INTO tteo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Libeka imiya mamalawe nige ikakabi kabo Aisake ikawanoi Yeoba koina wainena kaiwena. Aisake ana kawanoi Yeoba ibenalan kabo Libeka isiuma natunao gwama-didiluwaluwa. ");
INSERT INTO tteo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Naga ikakabi na diyana kalona mena melumeluwone sietubatubali-yagili kabo Libeka iba, “Gubesi mwa ginauline bwaite iyawatagili koliyau?” Mwa ilau ineli Yeoba koina ginauline bwaite kana dudulai kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Mwa kainana Yeoba iyamaisa iwaloba, “Boda labui iyaele diyam mena, natumwao siya kani ukwabili kani siyamala boda labui sikawakawa-lakwa. Na yabo kanakava ikaiwe-gabaen na tobagubaguna kani iyamala topaisowa tomulimuliyene kaiwena.” ");
INSERT INTO tteo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Libeka ana sauga kabi ilobai kabo natunao labui ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Tobagubaguna kwapina balabalagiyana yo ilopalapalasa kabo esana sipei Isowa. ");
INSERT INTO tteo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Melumelu labuina kanakava kaekelukeluna ikabikabi-kalatan kabo esana ipei Yakobo. Na Aisake ana bolime sikisti (60) koina mwa Isowa yo Yakobo sinali ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Melumeluwone silalaki. Isowa iyamala tokeloya namwanamwana na Yakobo iya tomo mwanomwanouna mwa imiyamiyaya nume mena. ");
INSERT INTO tteo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisake iyaliyaya lalakina Isowa koina kaiwena yakayakan iunuili na ikalailima Aisake koina ikekakekan. Na Libeka iyaliyaya lalakina Yakobo koina. ");
INSERT INTO tteo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Kaliyate yabo koina Yakobo iyaele bembem dikuna iligaliga. Isowa ipileyoima ule mena kamnana inae keloya koina iguliyam lalakina, ");
INSERT INTO tteo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","kabo iwalo Yakobo koina iwaloba, “Mwayamwayau bwaimwa dikune balabalagiyanane tupwana ukoiyama na yakan kaiwena yaguliyam yawasosi.” Bwaimwa iya kaiwena Isowa esana labuina siyogayan Idoma. ");
INSERT INTO tteo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Mwa Yakobo Isowa kainana iyamaisa iwaloba, “Baguna yamiyalae tamala kaiwena kuyeyama koliyau.” ");
INSERT INTO tteo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Mwa Isowa iwaloba, “Kamnagu inaesosi guliyam kaiwena kikiunamo yaboita. Tawae kana namwanamwa tem yamiyalaene koliyau na tem yaboita?” ");
INSERT INTO tteo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Na Yakobo iwaloba, “Baguna ukawalulu yo kuwaloyameli yamiyalaene kani kuyeyama koliyau.” Kabo Isowa ikawalulu yo iwaloyameli yamiyalaene kani iwolena Yakobo koina. ");
INSERT INTO tteo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Imwawasi kabo Yakobo beledi tupwana yo diku tupwana ikoi yo iwolena Isowa ikan. Ikekan yo inuma mwa itolo ilau. Na Isowa nige inuwanuwatu yamiyalaene kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Sauga yabo guliyam lalakina iyawatagili dedeinane koina besiele beyabeyana Abelamo ana sauga koina, mwa Aisake ilau yanuwa Gelal koina. Na tomo Pilistiya ali kin Abimeleki imiyamiya bwaine koina. ");
INSERT INTO tteo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Kabo Yeoba iyawatagili Aisake koina yo iwaloba, “Tabu kulau kulolobi Itipita, na kumiyamiya dedeine yawawalowenne koliwo koina. ");
INSERT INTO tteo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Kumiyamiya dedeine bwaite koina kabo yau yamiyamiya koliwo yo kani yawalo-muloloiwo. Dedeine bwaite meuloina kani yaeyawa kowa koliwo yo tubumwao kolili na yagu waloyameline yakawalulu-wanako tamam Abelamo koina kani iyamala yawasosi. ");
INSERT INTO tteo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Na kani tubumwao meuloili yayadebalalali sibaibaiwa besiele utu bulibuli mena, na yanuwa bwaite meuloina kani yaolena tubumwao kolili. Tabe siya kolili kani kaba loinao uloili meuloili yanuwa yaulina mena walo-mulolo silobai. ");
INSERT INTO tteo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Kaiwena tamam Abelamo iobigaiyau yo yagu loina lalakili yo kikiuli ibenalagili yo imuliya.” ");
INSERT INTO tteo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Kabo Aisake imiyamiya Gelal. ");
INSERT INTO tteo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Na saugana yanuwane tomonliyao silau Aisake koina sineli wainena kaiwena kabo kainali iyamaisa iwaloba, “Dugu bwaite.” Ana walone besiele kaiwena imatausi tem iwaloba, “Wainegu bwaite” ana nuwatu kisi siunuyamate na wainena sikalai, kaiwena Libeka kana koleya inamwanamwasosi. ");
INSERT INTO tteo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Aisake imiya mamalawe tomo Pilistiya ali dedei koina, kabo sauga yabo Abimeleki ilau ana tomlape mena iboe manna ilau igitai Aisake Libeka isapwali. ");
INSERT INTO tteo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Kabo Abimeleki iwalo Aisake siyoganama koina, iwalolau koina iwaloba, “Tomala wainem Libeka, na tawae kaiwena kuwalo yakato dum?” Mwa Aisake Abimeleki kainana iyamaisa iba, “Kaiwena tem yawaloba, ‘Wainegu bwaite’ kani kwaunuiyau.” ");
INSERT INTO tteo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Kabo Abimeleki iwaloba, “Mumuga tawatawaena uginauli kolimai? Nuwana tem yagu topaisowa yabo mekanakava wainem sikeno, kani naenaena kana maisa ilaoma kolimai na pwanoline yaina kowa.” ");
INSERT INTO tteo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kabo Abimeleki ana tomoyao meuloili iyanuwapeili tem analiyao siya mumuga naenaena siginauli Aisake koina o nuwana wainena Libeka koina kani loina polopolowena silobai na siboita. ");
INSERT INTO tteo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aisake bwatanone koina ipelipeli like yo bolimenane koina kanna ilobai idebalala yo ilalakisosi. Yeoba iwalo-muloloi, ");
INSERT INTO tteo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","mwa Aisake ana wasawasa iyatubu ilalaki ilaulau kanasiga ana wasawasa ilalakisosi. ");
INSERT INTO tteo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ana bulumakau, sipi yo gouti sidebalala sibaibaiwasosi besiele tabe ana topaisowao sibaibaiwa na iya kaiwena mwa Pilistiya tomonliyao Aisake silamwa-polowe-yani. ");
INSERT INTO tteo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Na waila keline siya beyabeyana Abelamo ana topaisowao sikelili Aisake iyapayapaisowaili kabo tomo Pilistiya silaoma yo sipuluili. ");
INSERT INTO tteo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Yo Abimeleki iwalo Aisake koina iba, “Kulau, ama yanuwa kulogabaen kaiwena am wasawasa yo am kaiwe ilalakisosi kabo muli mena kai.” ");
INSERT INTO tteo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Kabo Aisake yanuwane ikwasa-gabaen yo ilau Gelal kalogawana yabo koina imiya. ");
INSERT INTO tteo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Na kalogawane koina beyabeyana Abelamo me ana topaisowao simiyamiya yo waila keli sikelili. Saugana iboita na tomo Pilistiya silaoma yo waila keline sipuluili. Kabo wailane Aisake ilobaiyoili na iwalo ana topaisowao sisalayoili. Na waila keline beyabeyana Abelamo esaliyao ipeiliko mwa Aisake iyogayan yoi esa kaigedana kolili. ");
INSERT INTO tteo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Na ali kelikeline koina yabo silobai waila namwanamwasosina ibunubunuwasi, ");
INSERT INTO tteo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","kabo siya Gelal ali yakayakan kali togite-kalatan sigamwapakiki Aisake ana yakayakan kali togite-kalatanwo kolili siwalo kolili siwaloba, “Wailane bwaite kai kama waila.” Mwa Aisake waila keline bwaite esana ipei ‘Gamwapakiki wailana’. ");
INSERT INTO tteo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Kabo ana topaisowa waila keli yaboyoi sikeli na tabe besiele sigamwapakiki yoi kabo Aisake waila keline esana ipei yoi ‘Kalomagigili wailana’. ");
INSERT INTO tteo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Kabo dedeine ikwasa-gabaen ilau dedei yaboyoi koina yo waila keli yaboyoi sikeli. Na waila keline kaiwena nige gamwapakiki yaboyoi iyayawatagili, kabo esana ipei ‘Kaba miya sowasowana wailana’ yo iwaloba, “Yeoba kaba miya sowasowana iyeyama mwa dedeine bwaite koina kani tawasawasa yoi.” ");
INSERT INTO tteo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Aisake ikwasa yoi ilau Biyasiba. ");
INSERT INTO tteo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Kaliyatenane iyawatagili bwaine koina boniyainane koina Yeoba iyawatagili koina yo iwaloba, “Yau tamam Abelamo ana Yaubada, tabu kumamatausi kaiwena yau mekaukava kowa sauga meuloina yo tabe kani yawalo-muloloiwo yo tubumwao kani yayadebalalali besiele yagu waloyameli yagu topaisowa Abelamo koina.” ");
INSERT INTO tteo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Kabo Aisake kaba pwaoli ipaisowai yanuwane koina mwa ipwalou Yeoba koina. Na dedeinane koina ana palai iyatolo yo ana topaisowao waila keli yabo sikeli. ");
INSERT INTO tteo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Kabo Abimeleki mekanakavao kana tosagu lalakina Aiyusa yo ana tokaleyayao ali tobaguna Pikol silaomaya Gelal koina yo silau Aisake koina. ");
INSERT INTO tteo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Saugana Aisake igitaili ineli kin koina iwaloba, “Gubesi mwa kwalaoma koliyau? Beyabeyana wakalomagigi-lagau na dedeine koina kwatawoiyau.” ");
INSERT INTO tteo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Kainana siyamaisa siwaloba, “Kaiwena kagitai Yeoba mekamkava kabo nuwanuwamai kelabilabin kamwasana taginauli kowa yo kai, ");
INSERT INTO tteo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","na mesabana tabu nae yabo ugiginauli kolimai. Tauna kona kai nige nae yabo kagiginauli koliwo yo nuwadaumwali koina kayawasao kulau yo sauga bwaite kabo Yeoba imulolo lalakina koliwo.” ");
INSERT INTO tteo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Mwa Aisake kan lalakina ipaisowai kaiweli kabo sikekan yo sinuma. ");
INSERT INTO tteo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Yanuwa ilayan malala kikiuna kabo ali kelabilabin kamwasana siginauli na sikawalulu yo siwaloyameli tabu kaleya yaboyoi. Mwa Aisake Abimeleki yo kanakavao iyawasali silau nuwadaumwali mena. ");
INSERT INTO tteo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Kaliyatena kaigedana koina Aisake ana topaisowao silaoma yo ana wasa siwolena wailane sikekeline kaiwena siwaloba, “Waila kalobaiyako.” ");
INSERT INTO tteo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Kabo wailane esana ipei Siba yo saugana yanuwane simiya-yalalaki kabo yanuwane esana sipei Biyasiba yo esane imiyamiya kanasiga kabona. ");
INSERT INTO tteo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Saugana Isowa ana bolime poti (40) ilobai kabo Iti sinesineoliyao labui ikasolanagili, yabo esana Diudit iya Bili natuna yo yabo tabe esana Basimata iya Eloni natuna. ");
INSERT INTO tteo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Na sinesineone yoli labuine mumugali yo ali paisowa naenaeli kolili Aisake me wainena siulaula-munamunaili. ");
INSERT INTO tteo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Saugana Aisake itautaubala yo yona sibelu molosi kabo tabe manna sigibu nige sowana ginauli yabo ikilala. Kabo natuna tobagubaguna Iso iwalo ilaoma yo iba, “Natugu.” Yo Iso iba, “Yau elete tamagu.” ");
INSERT INTO tteo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Mwa Aisake iwalo iba, “Yatautaubalako mwa sauga kikiunamo kani yaboita. ");
INSERT INTO tteo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Na am gipoyo yo am wamali kelokeloyao ukwalaili kulau ule mena ukeloya yakayakan yabo kuunui ukwalaiyama kau gwaba. ");
INSERT INTO tteo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Muliya kabo yaboita nuwanuwagu kan bwalaina kamnana namwanamwana kupaisowai ukwalaiyama koliyau yakekan na kam walo-mulolo yaeyawa.” ");
INSERT INTO tteo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Sauganane koina Libeka iyaele ibenabenali tawae Aisake iwalowalowen natuna Iso koina. Kabo Iso iyawatagili ilau ule mena ikeloya na tem yakayakan yabo iunui na ikalaiyama. ");
INSERT INTO tteo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Yo Libeka iwalolau natuna Yakobo koina iba, “Yabenalan tamam iwalowalolau kamkava Iso koina iba, ");
INSERT INTO tteo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Am keloya kanna gwaba yabo ukwalaiyama na kuliga namwanamwai kamnana yo bwalaina namwanamwasosina ukwalaiyama yakan na mesabana Yaubada manna mena kam walo-mulolo yaeyawa, muli mena kabo yagu sauga imwawasi.’ ");
INSERT INTO tteo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Koinaele natugu, kubenali namwanamwa na tawae kani yawalowen koliwo uginauli besiele. ");
INSERT INTO tteo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Saugane bwaite koina kulau ebaebai kali gana mena gouti natunao labui sinisinibuli kekan sowasowana, ugite-sipwaili yo ukwalailima koliyau na yakatububu-nagili na yaliga besiele tamam kana sauga meuloina ligaligana mena yaliga besiele. ");
INSERT INTO tteo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Na ukwalai kulau yo kuwolena tamam ikekan, yo ana walo-mulolo iyeyawa koliwo muli mena kabo ana sauga imwawasi.” ");
INSERT INTO tteo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Kabo Yakobo iwalolau sinana Libeka koina iba, “Na kaukava Iso iya yona silopalapalasa, na yau nigele yogu sisapusapu. ");
INSERT INTO tteo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Na gubesi tem saugana tamagu yogu ikabi-tonagili yo ikataiyau yakato yamwakotayan? Mwa kani yaboma kagu yokoi yakabi-yamayale kabo walo-mulolo kani nige iyeyeyama.” ");
INSERT INTO tteo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Kabo Libeka iwalolau Yakobo koina iba, “Natugu kam yokoi meuloina kupeiya yau koliyau. Na kulau uginauli besiele tawae yawalowen koliwo, saugamo bwaite ukwalailima koliyau.” ");
INSERT INTO tteo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Mwa kabo Yakobo iginauli besiele sinana ana walo koina. Itolo ilau gouti natunao ikalaili sinisinibuli labui siya kekan sowasowana ikalaili ilawagili sinana koina. Kabo Libeka gouti natunao ikalaili ikatububunagili yo kan kamnana namwanamwasosina iliga besiele iya Yakobo tamana nuwanuwasosina. ");
INSERT INTO tteo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Kabo Libeka itolo ilau natuna lalakina Iso kana kaleko namwanamwana nume mena ikalai yo Yakobo iyakwamai. ");
INSERT INTO tteo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Yo tabe gouti kwapili mewiyawiyali ikalai yo Yakobo nimana isuma yo galogalona mena tabe. ");
INSERT INTO tteo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Mwa kabo Libeka kan kamnana namwanamwana yo beledi kabona ipapaisowailiwa iwolena natuna Yakobo koina. ");
INSERT INTO tteo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yo Yakobo ikalaili ilau tamana koina iba, “Tamagu.” Kabo Aisake italam iba, “Natugu tawae?” Yo ineli iba, “Yaiya kowa?” ");
INSERT INTO tteo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakobo iwalo iba, “Yau natum Iso am tobagubaguna. Iyaele yaginauliyako besiele am walowa koliyau. Na tamagu kategu kowa kutolo yo yagu keloya kanna ukwekan kabo sowasowana kagu walo-mulolo koliwo kuyeyama koliyau.” ");
INSERT INTO tteo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Kabo Aisake inelilau natunane koina iba, “Natugu, gubesi kabo ginauli bwaite mwayamwayau mena kulobaili?” Yo Yakobo tamana ana neli iyamaisa iba, “Yeoba am Yaubada iya isaguiyau.” ");
INSERT INTO tteo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Yo Aisake iwalolau Yakobo koina iba, “Natugu kulaoma saligu mena na yakabi-tonagiwo, yawasosi kowa Iso o nuwana nigele.” ");
INSERT INTO tteo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Mwa Yakobo imiya-lau tamana Aisake salina mena kabo tamana nimana ilau natuna yona ikabitonan yo iba, “Kainam besiele kabo Yakobo kainana na nimam besiele Iso nimana.” ");
INSERT INTO tteo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Na Aisake nige ikakatai iya Yakobo kaiwena nimana silopalapalasa besiele kanakava Iso nimana, mwa iwalo-muloloi. ");
INSERT INTO tteo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Muli mena kabo Aisake Yakobo iwalo-muloloi na ineliyan yoi iwaloba, “Yawasosi kowa natugu Iso?” Mwa Yakobo iba, “O, yau.” ");
INSERT INTO tteo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Kabo Aisake iba, “Natugu am keloya kanna tupwana kuyeyama yakan na mesabana yagu walo-mulolo yaeyawa koliwo.” Mwa Yakobo kan ikalai iwolena tamana ikekan tabe wain ikalai yo iwolena inuma. ");
INSERT INTO tteo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Yo Aisake iwalolau natuna Yakobo koina iba, “Natugu kulaoma koliyau kunisoiyau.” ");
INSERT INTO tteo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yo itolo ilau tamana salina mena inisoi. Mwa Aisake natuna Iso kana kaleko bwalaina ibenalan kabo Aisake Yakobo iwalo-muloloi iba, “Natugu bwalaina inamwanamwa besiele kabo bubu ule mena bwalaina Yaubada iwalo-muloloi bwalaina. ");
INSERT INTO tteo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Yakawanoi Yaubada koina, bulibuli bekubekuna ibekuma yanuwa yaulina mena am tano bubu mena ikabi-yawasawasa am witi yo wain silalaki. ");
INSERT INTO tteo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Yakawanoi Yaubada koina dedei meuloina tomonliyao siyamala topaisowawa panpanli koliwo yo tomo meuloili sipwalou koliwo. Yakawanoi Yaubada koina kamkavao meuloili kuloinayagili, yo yakawanoi Yaubada koina sinamwao natuliyao meuloili sipwalou koliwo. Yo yakawanoi Yaubada koina siya sikawa-gulaiwo Yaubada ikawa-gulaili na siya simulolo koliwo Yaubada imulolo kolili.” ");
INSERT INTO tteo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Saugana Aisake natuna Yakobo iwalo-muloloi imwawasi yo itolo iyawatagili ikaisulu kabo sauganane koina kanakava Iso ipileyoima ana keloya koina. ");
INSERT INTO tteo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Mwa Iso tabe kan kamnana namwanamwana tupwana iliga yo ikalai ilawan tamana koina. Yo iwalolau tamana koina iba, “Tamagu, kutolo yo kumiyasio na yagu keloya kanna tupwana ukwan na kuwalo-muloloiyau.” ");
INSERT INTO tteo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Yo Aisake inelilau natuna koina iba, “Yaiya kowa?” Kabo Iso iba, “Yau Iso, natum tobagubaguna.” ");
INSERT INTO tteo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Mwa Aisake isiliyata katena ipitali yona meuloina sitabubu yo ineli iba, “Na kabona yaiya ilau ikeloya mwa ana keloya kanna ikalaiyamako koliyau? Mwa yakekanko kabo bwaite kulaomane. Tabe walo-mulolo ana kaba mwawasi iyaele yaolenako koina yo walo-mulolone iya walo-mulolo yawasosi sauga meuloina.” ");
INSERT INTO tteo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Saugana Iso tamana ana walo ibenalagili bwaine koina imunamunai lalakina yo ivalam kainana lalakina yo iba, “Tamagu, yau nuwanuwagu am walo-mulolo kuyeyama koliyau.” ");
INSERT INTO tteo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Na Aisake Iso kainana iyamaisa iba, “Kamkava ilaoma imwakota-namwanamwai-yau mwa kam walo-mulolo ikalaiyako.” ");
INSERT INTO tteo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Kabo Iso iba, “Esanaele iya esana Yakobo kwapei namwanamwaiyako melabui mumugana naenaena iginauli koliyau. Tauna kona yagu tobagubaguna koliyau ikele-panaisan. Na kabona kagu walo-mulolo ikalai yoi.” Kabo tabe Iso iwalolau yoi tamana koina iba, “Isa yoi tabe walo-mulolo koliwo tem kaigeda iyaele imiyamiya kuyeyama koliyau?” ");
INSERT INTO tteo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Aisake Iso kainana iyamaisa iba, “Natugu, yayatoloyako iya am taubala yo ana tali meuloili kani siyamala ana topaisowao. Masuli yo wain iyaele yaolenako koina. Mwa koinaele kani tawae yoi yagigiginauli koliwo kaiwem.” ");
INSERT INTO tteo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Yo Iso iwalolau yoi tamana koina iba, “Na tamagu, bwai am walo-mulolone kaigedamo? Kuwalo-muloloiyau yoi.” Kabo Iso ivalam kainana lalakina mena. ");
INSERT INTO tteo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Aisake iwalolau Iso koina iba, “Bwatanone koina kumiyamiyane nige masulina ipapagan nige galewa kani ilolobima kewa mena na iula-butabuta. ");
INSERT INTO tteo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Kani kulobai sauga meuloina ukwalekaleya tomo kolili yo kuyamala kamkava ana topaisowa. Na muli mena kani ugamwa-panawa yo nige sowana iloiloina-yagiwo yoi.” ");
INSERT INTO tteo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Kabo Iso iyatubu kanakava Yakobo ikalomagigilan kaiwena kana walo-mulolo Aisake iwolena kanakava Yakobo koina. Yo Iso inuwanuwatu muli mena iwalo iba, “Tamagu ana boita yo kana nuwanae kana sauga ikelakubwamako, imwawasi kabo Yakobo yaunuyamate.” ");
INSERT INTO tteo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Muli mena Iso ana walo siwalowen Libeka koina kabo Yakobo ana wasa iwolena iba, “Natugu, kamkava Iso iwawalo kani iunuyamateo. ");
INSERT INTO tteo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Koinaele natugu kubenali na uginauli besiele tawae yagu walo koliwo. Sauga bwaite koina kuyabubu kulau yanuwa Alan, am bala Labana koina. ");
INSERT INTO tteo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Mekamkava kwamiyamiya waya bwaine koina kanasiga nuwana ilobi italu, ");
INSERT INTO tteo_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","kanasiga tem kamkava ana munamunai kaiwem imwawasi yo nuwana imwatainan mumugane ugiginauline koina kabo kaina yayawasayawa koliwo yo kupileyoima. Tawae kana namwanamwa natuguwao yomiu labui kaliyate kaigeda koina yatabe-yakwalalelemiu?” ");
INSERT INTO tteo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Yo Libeka ilau Aisake koina iwalolau iba, “Ala miyamiyane bwaite koina yogu kamnana inae kaiwena susu Iti tubunao sinesineo kolili siya Iso wainenao mumugali kaiwena. Temga Yakobo ikasole Iti sinena yabo koina kani kagu lotonan inae bwai tem yaboitamo na yakaiyawasi.” ");
INSERT INTO tteo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Kabo Aisake Yakobo walo-mulolo kikiuna koina iwalo-muloloi yo iyanuwapei iba, “Kisi Kenani sinena yabo ukwasolanan. ");
INSERT INTO tteo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Kulaumo Mesopoteimiya koina sinam tamana Betuweli ana yanuwa mena. Yo kulau sinam duna Labana natuna yabo ukwasolanan wainem. ");
INSERT INTO tteo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Yakawanoi Yaubada Tokaiwesosi koina am kasole iwalo-muloloi yo natumwao iyadebalali yo ali boda sidebalala. ");
INSERT INTO tteo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Tabe yakawanoi yoi koina kowa yo tubumwao iwalo-muloloimiu, walo-mulolone besiele tauna kona iwolena Abelamo koina na mesabana sauga ilalaoma bwatanone bwaite koina kumiyamiyane kani wakalai ami bwatano, besiele Yaubada ana waloyameli Abelamo koina kaiwena bwaite saugane koina komiu besiele tomiya taumanao.” ");
INSERT INTO tteo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Yo Aisake Yakobo iyawasa ilau yanuwa Alan Mesopoteimiya koina, Betuweli natuna Labana koina, iya Yakobo yo Iso sinali Libeka duna. ");
INSERT INTO tteo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Saugana Iso ibenalan Aisake Yakobo iwalo-muloloiyako yo iyawasa ilau Mesopoteimiya koina mwa iwalolau koina, “Kisi Kenani sinena yabo ukwasolanan.” ");
INSERT INTO tteo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yo tabe Iso ikatai-lobai Yakobo tamana yo sinana ali guguye iobigai yo itolo ilau Mesopoteimiya. ");
INSERT INTO tteo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Na Iso ikatai-lobaiyako wainenao labuine Kenani sinesineoliyao Aisake iokwatakwata-yagili. ");
INSERT INTO tteo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Iso imunamunai lalakina sinana yo tamana kolili. Kabo ilau ikasole yoi Isimeli natuna Malati mekanakava. Na Malati iya Nebayodi duna. ");
INSERT INTO tteo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Kabo Yakobo yanuwa Biyasiba itolo-gabaen na ilau yanuwa Alan kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Saugana iyawatagili yanuwa kikiuna yakayakasisina koina yo ikaiyawasi kaiwena dabwelo isusugu. Mwa veku yabo ikalai kana kulule yo bwaine koina ikeno-talu yo ikeno. ");
INSERT INTO tteo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Saugana ikenokeno kenona ikenoi kamwasa yabo igitai bwatano mena itolo isae itupa bulibuli mena yo Yaubada ana aneloseyao silobilobi yo sisaesae kamwasane koina silolokeikeile. ");
INSERT INTO tteo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Yo Yakobo kenona mena igitai Yeoba itolo kamwasa pwatana mena yo iba, “Yau Yeoba iya tubum Abelamo yo tamam Aisake ali Yaubada. Bwatano bwaite koina ukenokenone kani yaeyawa kowa yo tubumwao yaso muli mena kolimiu. ");
INSERT INTO tteo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Tubumwao kani sidebalala besiele yanuwa yaulina dekawana yo yanuwa yaulina meuloina kwamiyan, ilau tete yalasi ilau tete bolime ilau tete kaluwabu mena yo tete yavana mena. Yo kani tomo meuloili yawalo-muloloili esam mena yo yaso ilalaoma esali mena. ");
INSERT INTO tteo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Yo yau mekamkava yagite-kalatagiwo am kaba lau dedei meuloina kolili yo tabe yayapileyoiwoma bwatano bwaite koina. Nige yalologabaegiwo kanasiga yagu waloyameline yapaisowai besiele.” ");
INSERT INTO tteo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Saugana Yakobo ikeno-tolo yo inuwanuwatu yo iba, “Walo yawasosi Yeoba yanuwa bwaite koina iyaele imiyamiya.” ");
INSERT INTO tteo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yo imatausi kabo iba, “Yanuwa bwaite kana koleya ididiga. Nige tawae na bwaite Yaubada ana nume ana kaba miya, yo tabe bulibuli kana gamwa kaba lusaena.” ");
INSERT INTO tteo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yo malala kikiuna ikeno-tolo Yakobo veku kana kululewa ikalai yo iyatolo tuki. Na olo ikalai yo isuwai yo vekune ikabi-yatabu. ");
INSERT INTO tteo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Yo yanuwane esana ipei Betele. Beyabeyana yanuwa bwaine esana Lusa. ");
INSERT INTO tteo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Kabo Yakobo waloyameli yabo iginauli yo iba, “Tem Yaubada iya mekaukava yo igite-kalatagau yagu lokeikeilene koina yo kan yalobai yo kaleko iyeyama yalikwa, ");
INSERT INTO tteo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","na yagu pileyoima tamagu ana nume mena me yagu yaliyaya, kani kabo Yeoba iya yagu Yaubada yawasosi. ");
INSERT INTO tteo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Yo veku bwaite yayatolone kani iyamala kilakilala naga sauga ilalaoma koina tubuguwao ali kaba pwalou. Na ginauli meuloina iyeyama koliyau kani gwau sanaulu yapaisowaili na gwau kaigeda yaolena koina.” ");
INSERT INTO tteo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Kabo Yakobo ilomwayamwayau isae tomo simiyamiya dedei pwata mena ali yanuwa tete bomatu mena. ");
INSERT INTO tteo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Saugana iyawatagili dedei bwaine koina nige tomo simiyamiya koina yo manna igabaen ilau igite-keikeile yo waila keli yabo igitai, gamwana koina kokaukausi veku lalakina sapusapuna. Kabo sipi yo gouti yawoiyawoili yaiyona waila papalina mena simiyamiya kaiwena ali kaba numa bwaine. ");
INSERT INTO tteo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Saugana tem sipi yo gouti silogogo waila papalina mena kabo kali togite-kalatan waila kana kokaukausi iyasaga-suwalan yo waila ilegu sipi yo gouti iyanumali. Imwawasi tabe iyasaga-kausi yoi ana kaba miya mena. ");
INSERT INTO tteo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Kabo Yakobo iwalolau kolili iba, “Kaukavao komiu to kwalaomaya?” Yo kainana siyamaisa siba, “Kalaomaya yanuwa Alan.” ");
INSERT INTO tteo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yo tabe ineliyoi kolili iba, “Na Labana tabu wakakatai, Neoli tubuna tauna.” Kainana siyamaisa siwaloba, “O, kakatai.” ");
INSERT INTO tteo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Tabe ineliyoi kolili iba, “Na inamwanamwa?” Kainana siyamaisa siba, “O, inamwanamwa. Na natuna sinena iyaelene esana Litieli tamana ana sipi yo gouti iyoganli silalaoma.” ");
INSERT INTO tteo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yo Yakobo iwalolau kolili iba, “Bwaite pwasinasina nige sowana sipi yo gouti tayoga-gogonagilima. Kwayanumali na kwayapileyoili kawasi sikekan.” ");
INSERT INTO tteo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Kainana siyamaisa siba, “Nige sowana kapaisowai besiele. Kasanasana sipi yo gouti meuloili togite-kalatan sikelegogo-nagilima yo waila kana kokaukausi kayasaga-suwalan yo me toyawa kayanumali.” ");
INSERT INTO tteo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Saugana Yakobo iyaele iwalowalolau kolili Litieli iyawatagili mekanakavao tamana ana ebaebaiwo kaiwena iya kali togite-kalatan. ");
INSERT INTO tteo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Mwa saugana Yakobo Litieli igitai mekanakavao tamana ana sipi yo gouti Litieli iya Yakobo nubaina ana bala Labana natuna. Yo ilau waila keli gamwana kana kokaukausi iyasaga-suwalan yo ana bala ana ebaebaiwo iyanumali. ");
INSERT INTO tteo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yo ilau Litieli inisoi yo ivalam kainana lalakina mena. ");
INSERT INTO tteo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Iwalolau koina iba, “Yau tamam duna esana Libeka natuna.” Mwa Litieli itolo isagena ilau nume mena tamana ana wasa iwolena. ");
INSERT INTO tteo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Saugana Labana ana game Yakobo wasana ibenalan kabo itolo yo isagena ilau igitai. Kabo isau isapwali yo inisoi mwa iyogan ilawan ana nume mena. Kabo Yakobo ginauli meuloina tawae iyawatagili koina iwalo-masalan ana bala koina. ");
INSERT INTO tteo_vpl VALUES ("GN29_14a","002_29_14a","GEN","29","14a","14a","Kabo Labana iwalolau koina iba, “Kowa kwasinegu yo bulumagu tupwana.” ");
INSERT INTO tteo_vpl VALUES ("GN29_14b","002_29_14b","GEN","29","14b","14b","Kabo waikena kaigeda Yakobo imiyamiya Labana koina. ");
INSERT INTO tteo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Yo Labana iwalolau koina iba, “Kowa yau game yawasosi nige sowana kupaisowa bwagabwaga koliyau. Na kuwalo koliyau ginauli esana koina nuwanuwam yayamaisao?” ");
INSERT INTO tteo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Na Labana natunao gamagamasineo labui tobagubaguna esana Leya dagelana mena esana Litieli. ");
INSERT INTO tteo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya sine man towatowana na Litieli sine vesalana namwanamwana. ");
INSERT INTO tteo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakobo Litieli igadosisiyan lalakina mwa iwalolau Labana koina iba, “Yapaisowa koliwo bolibolime seben yo natum sinena kikiuna Litieli kutalamwan na yakasolanan.” ");
INSERT INTO tteo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labana Yakobo kainana iyamaisa iba, “Inamwanamwasosi yatalamwan koliwo kabo muli mena tomo uloina. Na mekaukava kowa tamiya bwaite koina.” ");
INSERT INTO tteo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Kabo Yakobo ipaisowa yoi bolime seben Litieli kaiwena Labana koina na tem ikalai wainena. Iyamo bolime malamalawena Yakobo ipaisowa na iyamo iya koina besiele kabo kaliyate isamo kaiwena Litieli kana nuwanuwatu katena mena ilalakisosi. ");
INSERT INTO tteo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Yo Yakobo iwalolau Labana koina iba, “Natum kuyeyama yakasolanan yagu gamwakabi kanasiga ilobaiyako.” ");
INSERT INTO tteo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Kabo Labana kasole kekanna ipaisowai kabo yanuwa tomonliyao iyoga-gogonagilima kekanne kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Yo boniyai mena Labana itolo yo natuna sine tobagubaguna Leya ikalai yo ilawan iyoga-luseyan Yakobo ana kaba keno biliutusi mena sikeno. ");
INSERT INTO tteo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Yo Labana ana topaisowa gamasine esana Silipa iwolena natuna Leya ana esimili gabuna. ");
INSERT INTO tteo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Saugana yanuwa ilayan gwaligwali Yakobo katena ipitali sine igitaiyawa uloina mekanakava sikekenowa nige Litieli besi, na Leya. Mwa ilau Labana koina iwalo-munamunai iba, “Tawae kaiwena kamwasane bwaite uginauli besiele koliyau? Ukwatai Litieli kaiwena mwa yapaisowa koliwo. Gubesi kabo kumwakota-yagau?” ");
INSERT INTO tteo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Kainana iyamaisa iba, “Kai mumugamai besiele bwaite. Tobagubaguna ikasole baguna muli mena kabo tomulimuliye. ");
INSERT INTO tteo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Kani kusanasana naga ami kasole mekamkava Leya soina kana yaliyaya wiki kaigeda koina yawalana ilawan, kabo Litieli yaeyawa. Na iyamo tabe kani bolime seben yoi kani kupaisowa yoi koliyau.” ");
INSERT INTO tteo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Mwa Yakobo italam besiele Labana ana walo koina, yo saugana mekanakava Leya ali kasole soina wiki kaigeda imwawasi kabo mwa Labana natuna Litieli iwolena Yakobo koina yo ikasolanan. ");
INSERT INTO tteo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Yo Labana ana topaisowa sinena esana Bila iwolena natuna Litieli koina ana esimili gabuna. ");
INSERT INTO tteo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yo kabo Litieli mekanakava Yakobo sikeno yo Yakobo Litieli igadosisiyan lalakisosina Leya nige igagadosisiyan sosi. Mwa kabo ipaisowa Labana koina bolime kana baibaiwa seben. ");
INSERT INTO tteo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Saugana Yeoba igitai Yakobo nige imulolososi Leya koina kaiwena nige igagadosisiyan sosi, kaiwena mwa italam sowasowana isiuma na natuna ipagan. Na Litieli iya nige natuna. ");
INSERT INTO tteo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leya isiuma yo ikabi natuna tauna mwa esana ipei Luben yo iba, “Yaubada kagu polowe igitai kani kabo wainegu igadosisi-yagau.” ");
INSERT INTO tteo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Tabe Leya isiuma yoi yo natuna tauna yoi esana ipei Simion. Yo iba, “Yaubada natugu tauna yaboyoi iyeyama kaiwena ibenalan wainegu nige imumulolo koliyau.” ");
INSERT INTO tteo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Leya isiuma yoi yaiyonana ikabi tabe tauna yoi esana ipei Libai. Iwalo iba, “Wainegune kani ipatu yawasosi koliyau kaiwena natunao tatao yaiyona yakabiliko.” ");
INSERT INTO tteo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ana kabi ana kaba mwawasi isiuma yoi ikabi natuna tauna esana ipei Yuda. Iwalo iba, “Saugane bwaite koina Yaubada yatobalan yo yawaloseyan.” Yo bwaine koina kabi ilopei. ");
INSERT INTO tteo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Saugana Litieli igitai yakato nige sowasowana ikabi kabo ilamwa-poloweyan kanakava Leya koina yo iwalolau Yakobo koina iba, “Melumelu kuyeyama yasiumayan tem nigele kani yaboita.” ");
INSERT INTO tteo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yo Yakobo imunamunai Litieli koina iwalolau koina iba, “Yau nige Yaubada besi na yakato yawalo na ukwabi. Yaubada iya mwa ikausiwo koinaele mwa nige ukwakabi.” ");
INSERT INTO tteo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Mwa tabe Litieli iwalolau Yakobo koina iba, “Yagu topaisowa gamasine Bila iyaelete mekamkava wakeno na mesabana isiuma yo ikabi yau natugu. Bwaine iya koina na natuguwao sipagan.” ");
INSERT INTO tteo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Bwaine koina Litieli ana topaisowa sine esana Bila italamwan Yakobo koina besiele yakato wainena yo mekanakava sikeno. ");
INSERT INTO tteo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Yo Bila isiuma kabo Yakobo natuna tauna yabo ikabi. ");
INSERT INTO tteo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Kabo Litieli iba, “Yeoba mumugagu igitesipwai idudulai, yo yagu kawanoi ibenalan kabo natugu tauna iyeyama.” Yo esana ipei Dani. ");
INSERT INTO tteo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Tabe Bila isiuma yoi yo Yakobo natuna tauna labuina ikabiyan. ");
INSERT INTO tteo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Kabo Litieli iba, “Yakepatesosi kaukava mekaukava iyamo yau yakaiwe-gabaen.” Mwa esana ipei Napitalai. ");
INSERT INTO tteo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Saugana Leya kana lotonan yakato kani nige ikakabiyoi kabo itolo yo ana topaisowa sinena Silipa italamwan Yakobo koina besiele yakato wainena. ");
INSERT INTO tteo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Yo Silipa isiuma Yakobo natuna ikabiyan tauna. ");
INSERT INTO tteo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Yo kabo Leya iba, “Yanamwanamwako, amokisamo.” Mwa kabo esana ipei Gada. ");
INSERT INTO tteo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Yo tabe Silipa natuna tauna Yakobo koina yaboyoi ikabiyan, ");
INSERT INTO tteo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","yo Leya iba, “Yayaliyaya molosi. Sinesineo kani siwalo siba, ‘Kowa toyaliyaya.’” Mwa esana ipei Aseli. ");
INSERT INTO tteo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Na Luben igamegameko kabo saugana witi kana sepasepa koina ilau tano mena yo kawasi yabo ilobai ana nuwatu mena iwaloba temga sinesineo sikan kani sisiuma kabo Luben ikalailima iwolena sinana Leya koina. Yo Litieli iwalolau Leya koina iba, “Kawasi bwaimwa siuma kaiwena tupwana kuyeyama yakan.” ");
INSERT INTO tteo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leya iwalolau Litieli koina iba, “Nige sowana, kaiwena iyaele wainegu ukwalaiyako na tabe tawae yoi nuwanuwam natugu ana mula yaeyawa ukwalai yoi?” Kabo Litieli iwalolau Leya koina iba, “Tem kawasine tupwana kuyeyama koliyau kani maisana kabona boniyai Yakobo mekamkava wakeno.” ");
INSERT INTO tteo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Lolaunane koina Yakobo ipileyoima tano mena yo Leya ilau yo sielobelobe kamwasa mena yo iwalolau koina iba, “Kansiga boniyai mekaukava kowa takeno, kaiwena natugu ana kawasi kabona ikalaiyama koliyau koina yayamaisaoko.” Mwa boniyainane koina Yakobo mekanakava Leya sikeno. ");
INSERT INTO tteo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Leya ana kawanoi Yeoba ibenalan yo isiuma kabo ikabi Yakobo natuna tauna valigigina. ");
INSERT INTO tteo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Kabo Leya iba, “Yeoba maisa namwanamwana iyeyama kaiwena yagu topaisowa sinena yaolena wainegu koina.” Mwa esana ipei Isako. ");
INSERT INTO tteo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Tabe Leya isiuma yoi yo ikabi Yakobo natuna tauna sikisina. ");
INSERT INTO tteo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Mwa iba, “Yeoba kagu mulolo kaigeda namwanamwasosina iyeyama yo kani wainegu iyakasisi-yagau kaiwena natunao tataoliyao yoli sikisi.” Mwa esana ipei Sebulon. ");
INSERT INTO tteo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Muli mena kabo isiuma yoi yo ikabi natuna sinena mwa esana ipei Daina. ");
INSERT INTO tteo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Yo Yaubada Litieli inuwatu-kalatan yo ana kawanoi ibenalan kabo melumelu ana kaba keno diyana mena isoke. ");
INSERT INTO tteo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Mwa Litieli isiuma yo ikabi natuna tau kaigeda mwa iba, “Kagu mwalimwaline Yaubada ikele-gabaenako.” ");
INSERT INTO tteo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Kabo esana ipei Yosepa yo iba, “Yakawanoi Yaubada koina tabe natugu yabo iyeyama yoi.” ");
INSERT INTO tteo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","26","Litieli Yosepa ikabi imwawasi mulina mena yo Yakobo iwalolau Labana koina iba, “Sinesineo bwaite kaiweli na paisowa lalakisosina yaginauli koliwo, koinaele kutalamwagau yo yakalaili mekalikavao melumeluwo tabe yo yalawagili yagu yanuwa yawasosi mena.” ");
INSERT INTO tteo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Kabo Labana Yakobo kainana iyamaisa iba, “Tem sowana walo yabo yawalowen koliwo na kumiyaya bwaite koina koliyau? Kaiwena wasawasane bwaite yagu lobailine yaina kaigedamo kowa koliwo mwa kabo Yaubada iwalo-muloloiyau. ");
INSERT INTO tteo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Koinaele kuwalo-masala koliyau tawae nuwanuwam na mesabana koina yayamaisao.” ");
INSERT INTO tteo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yo Yakobo iwalolau koina iba, “Ukwataiyako yagu paisowa koliwo am ebaebai yagite-kalatan namwanamwaili mwa kabona sidebalala. ");
INSERT INTO tteo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Tauna kona nige naga yalalaoma koliwo am ebaebaiwo nige sibabaibaiwa. Na sauga kabona mekaukava kowa tamiyamiya sitala-kabikabi yo sibaibaiwasosi. Saugana tem am ebaebai yakalaili yalawagili dedei yabo mena sikekan, na Yeoba iwalo-muloloiwo yo iyadebalalali. Na kabona meyagu susuyao nuwanuwagu kabomamo ama gogo yo kapaisowa na kagite-kalatagili yo kagite-kalatagimai.” ");
INSERT INTO tteo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Yo Labana ineli Yakobo koina iba, “Na ginauli esana nuwanuwam yaeyawa koliwo am paisowa koliyau maisana?” Mwa kainana iyamaisa iba, “Nige nuwanuwagu yagu paisowane koliwo maisana na yakato mane kuyeyama koliyau. Na yagu nuwatu koliwo bwaite besiele tem ukawa-namwanamwa ele yakato tem kutalam yoi na yapaisowa yoi koliwo am ebaebai yagite-kalatagili yoi. ");
INSERT INTO tteo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Kabona nuwanuwagu yalau am ebaebaiwo kolili yo yagite-yakayakasali kaloli mena yo sipi yo gouti yoli lololeleleleli natuliyao dubadubali tuntun-lopoli yayakasali, bwaimwa siya nuwanuwagu yakalaili maisagu. ");
INSERT INTO tteo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Yo sauga ilalaoma koina tem kulaoma kulobubu sipi yo gouti yakakalailiwa koliwo maisagu ugitaili nuwana yamwakota o yawalo yawasosi. Tem gouti yabo nige kana lelelele ipapagan yo nige sipi yabo dubadubana yagu ebaebai luwali mena bwaimwa koina ukwatai yakewali.” ");
INSERT INTO tteo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labana kainana iyamaisa iba, “Inamwanamwasosi. Taginauli besiele am nuwatune.” ");
INSERT INTO tteo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Sauganane koina Labana itolo yo ilau gouti sinesineo yo tataoliyao lololeleleleli yo tuntun-lopoliyao meuloina yo tabe sipi yoli dubadubali kikiuli meuloina ikalaili yo ilawagili natunao tatao kolili iwolegili sigite-kalatagili. ");
INSERT INTO tteo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Yo Labana menatunao sitolo sipi yo gouti sikalaili silaulau kaliyate kana baibaiwa yaiyona kali mwayaga iyai Yakobo koina. Yo Yakobo itolo yo Labana ana gouti yo sipi ilologabaegiliwa ikalaili yo igite-kalatagili. ");
INSERT INTO tteo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Kabo Yakobo mayau lagalagaliyao waluwaluli ikoutusili saido yo siyaya kabo kwapiliyao iyawasili yo ikoli yawasili luwali mena mayamayaleli simayale. ");
INSERT INTO tteo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Yo ginagina yawayawasiline iwonali ebaebai ali kaba numa papalina mena yo saugana tem silaoma sauga wedowedoli koina waila numa kaiwena na manli ilau sigitai. ");
INSERT INTO tteo_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Saugana silaoma ginaginane salili mena sikonai yo sisiuma yo sikabi sipine yo goutine sikabi kani natuliyao silolo-lelelele yo silo-tuntunlopon yo dubadubali. ");
INSERT INTO tteo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yo Yakobo gouti iyakasa-suwalan kolili ipei-lawagili Labana ana ebaebaiwo kolili siya yoli kana koleya dubadubali yo lololeleleleli ipaisowai bwaine besiele yo kabo ana ebaebaiwo sipagan nige ipepei-toyawaili Labana ana ebaebaiwo kolili. ");
INSERT INTO tteo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Saugana tem sipi yo gouti sinesineo kaikaiweli yamwayamwane kana sauga silobai Yakobo ginagina ikalaili yo manli mena iwona-yatololi na manli ilau sigitai kabo siyamwayamwane. ");
INSERT INTO tteo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Na tem siya me kali kasiebwa yo yoli belubeluli kani Yakobo nige ginaginane iwowona. Bwaine iya kaiwena mwa sipi yo goutine sibelubelu, siya Labana ana ebaebaiwo. Na siya kaikaiweli Yakobo ana ebaebaiwo. ");
INSERT INTO tteo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Bwaine kamwasane koina mwa Yakobo igogo molosi yo iwasawasa ana sipi yo gouti sibaibaiwa yo ana topaisowao sinesineo yo tatao sibaibaiwa, yo tabe besiele kameli yo donki. ");
INSERT INTO tteo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakobo walo yabo ibenalan Labana natunao tatao kolili siwaloba, “Tamala ana gogo wasawasa meuloina Yakobo ikalaili mwa koina iwasawasa.” ");
INSERT INTO tteo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yo Yakobo igite-lobai yo ilotonan Labana mumugana yo kana koleya nige idududulai koina besiele tauna kona. ");
INSERT INTO tteo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Kabo Yeoba iwalolau Yakobo koina iba, “Kutolo yo kulau tamam yo totoumwao ali dedei kolili yo yau mekamkava.” ");
INSERT INTO tteo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yo walo iyawasa ilau Litieli yo Leya kaiweli silaoma yo sigitai ule mena sipi yo gouti ali kaba kekan mena. ");
INSERT INTO tteo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Silaoma siyawatagili koina yo kolili iwalolau iba, “Yagitai tamamiu mumugana yo kana koleya nige besiele tauna kona. Na iyamo tamagu ana Yaubada iyaele mekaukava. ");
INSERT INTO tteo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Wakatai yo naga kwanuwatui yapaisowa sosi tamamiu koina yagu kaiwe meuloina mena. ");
INSERT INTO tteo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Na iyamo sauga meuloina imwakomwakota-yagau maisagu me sanaulu ibui-keileli yo ipei-suwalagili yo Yaubada nige itatalam yo isibayanaeyau. ");
INSERT INTO tteo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Tauna kona iwaloma koliyau iba, ‘Ebaebai tuntun-loponli ukwalaili maisam.’ Mwa sikabi-tuntunloponli mwa tabe iwalo-keile iba ‘Ebaebai lololeleleleli ukwalaili maisam’ mwa yakalaili maisagu. Mwa sikabi natuliyao lololeleleleli. ");
INSERT INTO tteo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Bwaine kamwasane tamamiu iginauli koliyau iya kaiwena mwa ana ebaebai meuloina Yaubada iyeyama koliyau. ");
INSERT INTO tteo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Yamwayamwane kana sauga koina kenogu yakenoi gouti tataoliyao siya mwa siyamwayamwane gouti bodane kolili siya tuntun-loponliyao yo leleleleliyao. ");
INSERT INTO tteo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Yo keno bwaine koina Yeoba ana anelose esagu ikatai iba, ‘Yakobo.’ Mwa yatalam yaba, ‘O, yau.’ ");
INSERT INTO tteo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Kabo iwalo-masala koliyau iba, ‘Labana mumugana iginaginauli koliwo iyaele yagitaiyako. Koinaele manim ilau ugitai gouti tataoliyao tuntun-loponliyao yo leleleleliyao yo dubadubali yo mekalikavao gouti sinesineoliyao siyamwayamwane. ");
INSERT INTO tteo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Yau Betele kana Yaubada yau mwa yayawatagili koliwo yo olo ukwalai kusuwai vekune kuyayatolowa pwatana mena yo waloyameli kaikaiwena kupaisowa koliyau. Yo sauga bwaite koina kutolo yo ukwatububu am gogo meuloina ukwalaili yo yanuwa bwaite kulogabaen yo kuvivila yoi am yanuwa.’” ");
INSERT INTO tteo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Yakobo ana walo-masala kolili imwawasi kabo kainana siyamaisa siba, “Ele kai tamamaine ana wasawasa yabo imiyamiya koina na yakato isoiyagili yomai labuine kolimai ana boita koina? ");
INSERT INTO tteo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Mumugana yo ana paisowa kolimai kai besiele yanuwa wenala sinesineoliyao ikune-yagimai koliwo, yo maisamai mane ikalai meuloina ikan-woliyako. ");
INSERT INTO tteo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Kabo gogo wasawasa meuloina Yeoba ikele-gabaen tamamaine koina iyaele mwa iyeyawa koliwo kai yo natumayao kaiwemai. Mwa koinaele besimo uginauli besiele tawae iwalowenako koliwo.” ");
INSERT INTO tteo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Yo Yakobo ikatububu na ipileyoi ilau tamana koina yanuwa Kenani. Natunao yo wainenao itaulili ebaebai kameli pwatali mena yo ana ebaebaiwo meuloili bodabodaliyao ibagunayagili yo ana gogo tabe ikalaili gogone siya Mesopoteimiya koina ikalailima waya. ");
INSERT INTO tteo_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ali sauga tolone koina Labana iya bwaine koina nigele, iya itolo ilaoko ana sipi wiyaliyao itomtomli. Na Litieli itolo yo tamana ana nume kana kokotomoyao ikewalili. ");
INSERT INTO tteo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakobo ana kwasa lau ana yanuwa mena wasana nige iwawalo-masalan bwasiyana Labana koina. ");
INSERT INTO tteo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ana gogo meuloina ikelegogo iyabubu wadammo ilau waila Yupeleitisi ipanaisi yo ilau dedei Giliyadi koyana iyasakona ilaumo kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Kaliyate labui simwawasi na yaiyonana koina kabo Labana ana wasa siwolena yakato Yakobo iyabubuko. ");
INSERT INTO tteo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Yo Labana kanakavao ikalaili yo mekanakavao kaliyate seben siyamuli kusulili dagelali mena kanasiga siyawatagili dedei Giliyadi koyana mena. ");
INSERT INTO tteo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Boniyainane koina Labana kenona ikenoi Yaubada iyawatagili koina iwalolau iba, “Ugite-kalatagiwo tabu walo yabo polopolowena o nuwana naenaena kisi kuwawalowen Yakobo koina.” ");
INSERT INTO tteo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yo Yakobo ana palai imomosi dedei Giliyadi koyana mena. Yo Labana ilaoma Yakobo ikabi-kalatan yo bwaine koina mekanakava kanakavao ali palai simomosi tabe. ");
INSERT INTO tteo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Yo bwaine koina Labana iwalolau Yakobo koina iba, “Gubesi mwa bwaite besiele uginauli koliyau? Kumwakota-yagau natuguwao sinesineo ukele-gogonagili besiele kabo kaleya mena ukwayaili? ");
INSERT INTO tteo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Tawae kaiwena kuyabubu-wadam-wagau? Tem tauna kona yagu wasa kuyeyama na mesabana yagu bodao yayanuwapeili yo sikabi-yaliyaya-yagimiu sikewaliwali api yo gita kolili yo sowana me am yaliyaya yayawasao kulau. ");
INSERT INTO tteo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Yo tabe nige nuwagu mena kupepei yo sauga ugogolu na tubuguwao mesinaliyao yasapwalili yo yanisoili na yakabi-tuili. Na bwaite yauyaule yawasosi uginauli. ");
INSERT INTO tteo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Kagu seyala ikinko bwaite sowasowana tawae yabo naenaena yaginauli kolimiu kabona. Na kaiwena tamam ana Yaubada kenogu mena iwaloma koliyau iba, ‘Ugite-kalatagiwo kisi walo yabo polopolowena o nuwana naenaena kuwalowen Yakobo koina.’ ");
INSERT INTO tteo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Yakataiyako kulogabaegau kaiwena nuwanuwa-molosim kupileyoi am yanuwa mena. Na iyamo tawae kaiwena yagu nume kana kokotomo ukewalili?” ");
INSERT INTO tteo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yo Yakobo Labana kainana iyamaisa iwalo iba, “Yamatausagiwo kaiwena kisi kani natumwao kunuwaili koliyau. ");
INSERT INTO tteo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Na tem am kokotomo yabo kolimai kulobai, ee tomone bwaimwa ukoyamate totoulaone manli mena. Kuboma kuloya tem am gogo yabo iyaele koliyau bwaimwa ukwalai.” Na iyamo Yakobo nige ikakatai yakato iya Litieli mwa tamana ana kokotomone ikewalili. ");
INSERT INTO tteo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Yo Labana ilau ilusae Yakobo ana palai kalona mena yo iyatubu loya ginauli meuloina kolili. Yo tabe ilusae yoi Leya ana palai kalona mena yo igite-keikeile. Yo tabe ilau ilusae yoi topaisowa labui ali palai kalona mena mwa nige ana kokotomowa ilolobaili. Mwa tabe ilau Litieli ana palai kalona mena ilusae yoi. ");
INSERT INTO tteo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Yo Litieli iya tamana Labana ana nume kana kokotomo itano-gogonagili yo ikalaili iwadamli ebaebai kameli kaba miyasio kalona mena na Litieli imiyasio pwatana mena. Kabo Labana ilusae yo igite-keikeile na nige ana nume kana kokotomo yabo ilolobai. ");
INSERT INTO tteo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Yo kabo Litieli iwalolau tamana Labana koina iba, “Taubala kisi kumunamunai koliyau nige sowasowagu yatolo manim mena kaiwena sinesineo kama kasiebwa ikalaiyau.” Na iyamo Labana iloya kaiwe molosi ginauli meuloili kolili iloya pilesili na iyamo nige yabo ana kokotomo ilolobai. ");
INSERT INTO tteo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Kabo Yakobo imunamunai Labana koina iwalo-sokasoka iba, “Tawae naenaena yaginauli koliwo? Pwanoli esana yaginauli manim mena mwa kusagena yamuli kusuliyau? ");
INSERT INTO tteo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Yau gogo meuloina kuloya-pilesiyako mwa tem am nume kana gogo yabo kulobai kaloli mena kupei-yawatagilan mayale mena mesabana am boda yo yagu boda yo yola labuine ala walo sibenalan na sikatai yaiya iwalo yawasosi. ");
INSERT INTO tteo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Bolime kana baibaiwa tuwenti yamiyamiya koliwo kanasiga kabona. Sauganane kolili am ebaebaiwo sipi yo gouti sitala-kabikabi dudulai yo sidebalala, na iyamo nige sipi natuna tauna yabo yaunui yakakan. ");
INSERT INTO tteo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Nige sauga yabo am sipi o am gouti ebaebai sokasokali sikapuyamate na yakakalaiyama koliwo na kuwalo tem yayamiyalaei yagu ebaebai koina maisana. Saugana tem am ebaebai sipi o gouti yabo sikewali kaliyate mena o nuwana boniyai mena sauga meuloina kaiwena ukawakawanoi koliyau maisana kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Sauga ibaibaiwa kaliyate koina dabwelo wedowedolina igabuyau yo boniyai koina tulutulu iunuiyau mwa man kenokeno manigu mena ikwalalele. ");
INSERT INTO tteo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Bolime tuwenti yamiyamiya koliwo mumugam koliyau bwaine besiele. Bolime potin (14) yagamwakabi koliwo natumwao sinesineo kaiweli, yo bolime sikisi yapaisowa am ebaebaiwo kolili, yo me sanaulu maisagu kubui-keileli. ");
INSERT INTO tteo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Tem tubugu Abelamo yo tamagu Aisake ali Yaubada kana pwalou nige imiyamiya koliyau, kani menima bwagabwagagu kuyawasa-yapileyoiyau yalau. Na kaiwena Yeoba yagu kamkamna yo yagu kalakisiye igitai mwa kaiwena boniyai mena iwalo-yasanapuwo.” ");
INSERT INTO tteo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Yo Labana Yakobo kainana iyamaisa iba, “Sinesineo siya bwaimwana yau natuguwao yo natuliyaone siya yau tubuguwao. Tabe ebaebaiwone yau yagu ebaebaiwo. Mwa ginauline meuloiline ugitagitailine yau yaeliwa. Na kaliyate kabona nige ginauli yabo yagiginauli na koina natuguwao sinesineoliyao me natuliyao yakabi-kalatagili. ");
INSERT INTO tteo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Mwa koinaele kowa yo yau kelabilabin kamwasana taginauli yo kana kilakilala veku tayatolo na iyanuwatu-kalatagila.” ");
INSERT INTO tteo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yakobo itolo yo veku yabo lalakina besiele kabo tuki ikalai yo iyatolo ali kaba nuwatu-kalatan. ");
INSERT INTO tteo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yo iwalolau kana kilakaiwo kolili veku sikele-gogo-nagilima yo sitalin isae kabo Labana ana boda nakanaka yabo siginauli na simiyasio papalina mena yo sikekan. ");
INSERT INTO tteo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labana kaba nuwatu-kalatan bwaine esana ipei kaina Alameiki koina ‘Yega Saduta’ yo Yakobo kaina Ibeliu koina iyogayan ‘Galiyedi’. ");
INSERT INTO tteo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labana iwalolau Yakobo koina iba, “Veku talitalinna bwaite yola labui kelabilabin kamwasana kana kilakilala kaba nuwatu-kalatanna.” Iya kaiwena mwa esana sipei Galiyedi. ");
INSERT INTO tteo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Yo tabe esana sipei yoi Mispa, kaiwena Labana iba, “Saugana tem tamiya-suwala Yeoba iya kani igite-kalatagila.” ");
INSERT INTO tteo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Labana tabe iwaloyameli iba, “Tem natuguwao sinesineoliyaone na mumugam inae kolili, o nuwana tem sinesineo uloili ukwasolanagili bwagana nige tomo yabo yagu wasa iyeyeyama iyamo kunuwatu-kalatan kowa yo yau Yeoba igitagitaila. ");
INSERT INTO tteo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Kaiwena veku talitalinna mekanakava veku malamalawena besiele tuki ugitai bwaite yakalai yo yayatolo kowa yo yau luwaluwalila mena. ");
INSERT INTO tteo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Yola labui kelabilabin kamwasana kaba nuwatu-kalatanna kilakilalana. Yau tabe nige sowasowana veku talitalinnane yalikwai na yalaowa yakaleya koliwo. Yo kowa tabe besiele nige sowana vekune talitalinnane yo vekune itotolo besiele tuki kulikwaili yo ukaleya koliyau.” ");
INSERT INTO tteo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Kabo Labana tabe iwaloyoi iba, “Tubum Abelamo ana Yaubada yo Abelamo tamana Nao ana yaubada kani siyamaisala tem kelabilabin kamwasana bwaite tagiginauline talikwai.” Yo Yakobo ikawalulu-sae tamana Aisake ana Yaubada esana mena iya mwa ipwalopwalou. ");
INSERT INTO tteo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yo koyane koina Yakobo ebaebai yabo ikalai yo ipwaoliyan Yaubada koina yo ana bodao iyoganlima sikekan ebaebaiwa koina. Kekan mulina mena sikenowaya koya mena. ");
INSERT INTO tteo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Yanuwa ilayan malala kikiuna Labana itolo ilau natunao menatuliyao isapwalili yo inisoili yo iwalo-muloloili yo ikawa-kaiyoni kolili kabo me ana bodao sipileyoi ali yanuwa mena. ");
INSERT INTO tteo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakobo me ana bodao sitolo yo silau. Silaulau kabo Yaubada ana aneloseyao Yakobo silobai. ");
INSERT INTO tteo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Saugana Yakobo anelose igitaili iwalo iba, “Yanuwa bwaite Yeoba ana kaba kaiyawasi.” Kabo esana ipei Miyaneima, na kana katai ‘kaba kaiyawasi labui’. ");
INSERT INTO tteo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yo Yakobo tosagenawasa iyawasali sisagena baguna silau kanakava Iso koina kainana siwalowen yanuwa Seya koina yanuwa Idoma dedeina mena. ");
INSERT INTO tteo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Iwalolau kolili iba, “Kwalau yagu taubala Iso koina kwawalolau bwaite besiele, ‘Yau Yakobo am topaisowa yamiyamiya waya Labana koina sauga imamalawe kanasiga kabona kabo sauga bwaite koina yapileyoima koliwo. ");
INSERT INTO tteo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Yagu bulumakau, yagu donki, yagu sipi, yagu gouti yo tabe yagu topaisowa tatao yo sinesineo siyaele. Walo yayawasayawa kowa yagu taubala koliwo nuwanuwagu katekamkamna yalobai koliwo.’” ");
INSERT INTO tteo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Yo saugana tosagenawasa sipileyoima Yakobo koina kabo ana wasa siwolena siba, “Kalau kamkava Iso koina ana wasa kaolena kainamwa kawalowenako. Mwa iyaele ilalaoma igitaiwo ana gamegameo mekanakavao kali baibaiwa po andeledi.” ");
INSERT INTO tteo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Walo bwaite Yakobo ibenalan yo imatausi lalakina me ana katewakaka. Kabo ana boda koina yakasa labui iginaulili. Tabe iginauli sipi yo gouti yo tabe bulumakau yo kameli kolili tabe. ");
INSERT INTO tteo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ana nuwatu kana koleya bwaite besiele, “Tem saugana na Iso ilaoma na kaleya iginauli na boda tobagunao iunuili sowasowana boda labuinane siyabubu.” ");
INSERT INTO tteo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Kabo Yakobo ikawanoi Yeoba koina iba, “Ae tubugu Abelamo yo tamagu Aisake ali Yaubada, yagu kawanoi kubenalan. O Yaubada, kowa mwa kuwaloma koliyau kuba, ‘Kupileyoi kulau am yanuwa mena na yau mekamkava na mesabana ginauli meuloina koliwo sidudulai.’ ");
INSERT INTO tteo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Yau am topaisowa nige yagu namwanamwa ipapagan. Na kumulolo koliyau yo am paisowa meuloina inamwanamwa koliyau. Menima bwagabwagagu mwa yalaoma waila Yolidani koina yapanaisima yagu sige kaigedamo nimagu mena mwa yalau Labana koina yamiyamiya waya. Na yagu pileyoi koina yagu boda labui mekaukavao. ");
INSERT INTO tteo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Yakawanoi kuleboiyau kaukava Iso koina. Kaiwena yamatausi kisi ilaoma ikaleya kolimai yo meuloimai iunu-olimai mekamakavao sinesineo yo melumeluwo. ");
INSERT INTO tteo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Tauna kona kuwalo kuba yakato ugite-kalatan namwanamwaiyau yo tabe tubuguwao kuyadebalalali kali baibaiwa besiele kabo gelesa dekawa mena yo nige sowana tomo yabo iyasili woli.” ");
INSERT INTO tteo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yo Yakobo ikenowaya bwaine koina kanasiga yanuwa ilayan malala mena yo ana ebaebaiwo koina iyakasa-suwalan ana mulolo kanakava Iso kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Gouti sinesineoliyao kali baibaiwa tu andeledi yo tataoliyao tuwenti sipi sinesineo kali baibaiwa tu andeledi yo tataoliyao tuwenti. ");
INSERT INTO tteo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Kameli sinesineoliyao kali baibaiwa teti (30) me natuliyao bulumakau sinesineoliyao kali baibaiwa poti (40) yo bulumakau tataoliyao kali baibaiwa sanaulu. Yo donki sinesineoliyao kali baibaiwa tuwenti yo tataoliyao kali baibaiwa sanaulu. ");
INSERT INTO tteo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Yo kabo ana topaisowawa kaigeda kaigeda ipeili ebaebai kali yakasa bodaliyao kolili sigite-kalatan. Yo tabe iwalolau kolili iba, “Ami lau bwaite besiele, boda bagubagunana ibaguna me ana ebaebaiwo mulina mena boda labuina me ana ebaebaiwo na iyamo ami laune koina tupwana mwayagamiu ipagan.” ");
INSERT INTO tteo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Kabo nuwana iwalo-yasanapu iya ana topaisowane tobaguna koina iba, “Saugana tem kaukava Iso ilobaimiu kamwasa mena na ineli-yagiwo iba, ‘Kowa yaiya am taubala? Toweya kulalau? Yaiya ana ebaebaiwo silolo-bagubagunane manim mena?’ ");
INSERT INTO tteo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Kainana kuyamaisa kuba, ‘Am topaisowa Yakobo ana ebaebaiwo bwaite. Iyawasa-baguna-yagili kowa ana taubala Iso koliwo ana mulolo. Na iya iyaele ilalaoma muligu mena.’” ");
INSERT INTO tteo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yakobo tabe iwalolau yoi ana topaisowa labuina yo yaiyonana tabe besiele siya ebaebaiwo togite-kalatan kolili iba, “Saugana tem Iso ilobaimiu bwai walone kaigedana kwawalowen koina. ");
INSERT INTO tteo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kwawalolau koina, kwaba, ‘Am topaisowa Yakobo iyaele ilalaoma mulimai mena.’” Yakobo ana nuwatu nuwana mena iba, “Mulolo yo walo yakasisi yayawasa bagunayan Iso koina na mesabana nuwana italu tabu imumunamunai koliyau. Na bwaine koina ikate-kamkamna-yagau.” ");
INSERT INTO tteo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Mwa ana mulolomo iyawasa bagunayan ilau, na iya nagamo iyaele ikenowaya ana kaba gogo mena. ");
INSERT INTO tteo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Mwa bwaine boniyai kaigedanane koina Yakobo ikeno-tolo yo wainenao yoli labui yo ali topaisowawa sinesineo labuiwa yo natuliyao ileben (11) iyoganli yo silau waila Yaboka silopanaisi. ");
INSERT INTO tteo_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Saugana ilau ipeili waila sanakawana yabo mena yo kabo tabe ipileyoi ana topaisowao kolili ana gogo meuloina sikele-gogon yo sipanaisi. ");
INSERT INTO tteo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Mwa Yakobo ibomamo silogabaen bwaine koina imiyamiya yo tomo yabo ilaoma mekanakava siesausau-wagili kanasiga ilau ee ilayan gwaligwali. ");
INSERT INTO tteo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Saugana tomone kamnana mena ilotonan nige sowasowana Yakobo ikaiwe-gabaen kabo isagena-tolo yo Yakobo gotuna kana tubwe mena ikoi yo ikopoi mwa itapwatapwai. ");
INSERT INTO tteo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Yo kabo tomone iwalolau Yakobo koina iba, “Ukwabi-gabaegau na yalau kaiwena iyaele yanuwa ilalayan gwaligwali.” Yakobo tomone kainana iyamaisa iba, “Kani nige yakakabi-gabaegiwo kanasiga tem kuwalo-muloloiyau.” ");
INSERT INTO tteo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Kabo tomone ineli Yakobo koina iba, “Na kowa esam?” Kainana iyamaisa iba, “Yau esagu Yakobo.” ");
INSERT INTO tteo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Yo tomone iba, “Sauga bwaite yo sauga ilalaoma koina nige esam Yakobo na esam ele Isileli, kaiwena mekamkava Yaubada yo tomo wakepate yo ukwaiwe-gabaegili.” ");
INSERT INTO tteo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakobo iwalolau tomone koina iba, “Yakawanoi koliwo tem esam kuwalowen yabenalan.” Kabo tomone iwalo-pileyoi Yakobo koina iba, “Tawae yaina nuwanuwam esagu ukwatai?” Yo iwalo-muloloi sauganane bwaine koina. ");
INSERT INTO tteo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Mwa Yakobo iwalo iba, “Yeoba yagitaiyako mekaukava kaemangitegite-yagimai na iyamo nige yaboboita.” Yo yanuwane esana ipei Penieli. ");
INSERT INTO tteo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Dabwelo itunsae kabo Yakobo yanuwane ilogabaen yo nige ilolo-dudulai kaiwena laugasina itapwatapwai. ");
INSERT INTO tteo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Bwaine koina yo kanasiga kabona tomo Isileli nige ebaebai laugasina o gotuna bulumana sikankan bwabwaleli kaiwena tubuli Yakobo tauna kona tomo laugasina kana tubwe yaina ikopwai. ");
INSERT INTO tteo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakobo igite-saewa Iso ilalaoma me ana gamegameo yoli powa andeledi (400) yo natunao iyakasali silau sitolo sinaliyao Leya yo Litieli yo ana topaisowawa sinesineo labui kolili. ");
INSERT INTO tteo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Sinesineo labui ana topaisowawa menatuliyao siya iyatolo-bagunayagili, salili mena Leya menatunao kabo mulimolosi mena Litieli yo Yosepa. ");
INSERT INTO tteo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Na Yakobo iya itolo baguna molosi manli mena yo ipwalou-talu bwatano mena meseben ilaulau ee kanasiga ilaoma kanakava Iso salina mena. ");
INSERT INTO tteo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Yo Iso isagena ilau kanakava Yakobo isau yo inisoi mwa kabo yoli labuiwa sivalam. ");
INSERT INTO tteo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Imwawasi Iso manna igabaen ilau sinesineo menatuliyao igitaili mwa ineli Yakobo koina iba, “Toyanuwao bwaite mekamkavao?” Yakobo kainana iyamaisa iba, “Melumeluwo bwaite siya Yeoba ikate-kamkamna-yagau mwa iyelima yau am topaisowa koliyau.” ");
INSERT INTO tteo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Yo sinesineo ana topaisowa labuina menatuliyao silaoma Iso manna mena sipwalou-talu bwatano mena siyakasisi. ");
INSERT INTO tteo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Tabe salili mena Leya menatunao silaoma siyakasisi sipwalou. Ana kaba mwawasi Yosepa mesinana Litieli silaoma siyakasisi. ");
INSERT INTO tteo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Yo Iso inelilau Yakobo koina iba, “Tatao mekalikavao sipi, gouti yo bulumakau me bodali yalaoma yalobaili tawae kana katai?” Kabo Yakobo Iso kainana iyamaisa iba, “Nuwanuwagu katekamkamna yalobai koliwo.” ");
INSERT INTO tteo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Iso iwalolau Yakobo koina iba, “Kaukava yau sowasowagu, na bwaitete ukwabi-kalatagili kowa kaiwem.” ");
INSERT INTO tteo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Na iyamo Yakobo iwalolau koina iba, “Nigele. Tem iyaele ukwate-kamkamna-yagaukone sowasowana yagu mulolone bwaite ukwalaili. Kaiwena manim kana koleya koliyau yagitai besiele kabo Yaubada manna kana koleya kaiwena kuyaliyaya molosi kaiwegu. ");
INSERT INTO tteo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Koinaele mulolo bwaite yakalailima koliwo ukwalaili kaiwenaele Yaubada ikate-kamkamna-yagau sosi kabo iginauli koliyau besiele.” Mwa Yakobo iwalo-samasamalulu sosi Iso koina kanasiga italam yo ikalaili. ");
INSERT INTO tteo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Mwa Iso iwalolau Yakobo koina iba, “Talau mekaukavao komiu.” ");
INSERT INTO tteo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yo Yakobo iwalolau koina iba, “Taubala, ukwataiyako melumeluwo siya nige sikakaiwe sosi yo yanuwanuwatu ebaebaiwo sipi bulumakau yo gouti menatuliyao kikikikiuli kaiweli. Tem yalotubatubalili kaliyate kaigeda koina kani ebaebai meuloina siboita. ");
INSERT INTO tteo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Koinaele taubala kubaguna na kai kani kikiuna kikiuna mulim mena kalaowa mekaukavao ebaebaiwo yo menatuguwao kabo taelobelobewaya Idoma koina.” ");
INSERT INTO tteo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Yo Iso iwalolau Yakobo koina iba, “Kau kilakaiwo tupwaliyao kani yapeili koliwo kabo sigelugelu-wagimiu mekamikavao kwalaoma.” Na Yakobo kainana iyamaisa iba, “Nigele besi, nuwanuwagu yakabi-yaliyaya-yagiwo. Kani kabo yagu topaisowao mekaukavao kalaowa.” ");
INSERT INTO tteo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Yo Iso itolo ipileyoi ilau ana yanuwa mena Seya Idoma koina. ");
INSERT INTO tteo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Na iya Yakobo ilau yanuwa Sukodi mwa ana palai iyatolo yo tabe ana ebaebaiwo ali lolon ikabili mwa iya bwaine kaiwena yanuwane esana ipei Sukodi. ");
INSERT INTO tteo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Saugana Yakobo Mesopoteimiya dedeina ilogabaen yo ipileyoi ilau iyawatagili Kenani dedeina mwa ilau imiya yanuwa Sikemi salina mena. Nige nae yabo silolobai kamwasa mena. ");
INSERT INTO tteo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Mwa itolo yo bwatanone imiya koina iyamaisa susu Amo kolili Sikemi tamana, bwatanone iyamaisa mane siliba kana lalaki wan andeledi siliba. ");
INSERT INTO tteo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Kaba pwaoli yabo ipaisowai mwa esana ipei Eli Eloi Isileli kana katai Isileli ali Yaubada. ");
INSERT INTO tteo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Sauga yabo mena Yakobo yo Leya natuli vesavesalana esana Daina iyawatagili ilau yanuwa Sikemi sinesineoliyao igitaili. ");
INSERT INTO tteo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Na Amo iya yanuwane bwaine kana taubala lalakina iya susu Ivi kabo natuna game esana Sikemi Daina igitai mwa ikabi-kalatan yo iyakeno. ");
INSERT INTO tteo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Na Sikemi nuwanuwana Daina kabo igadosisiyan yo iwalo bigabiga koina yo nuwana ikoi na yakato ikasolanan. ");
INSERT INTO tteo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Yo Sikemi iwalolau tamana Amo koina iba, “Tamagu, gamasine bwaine nuwanuwagu tem ukwalaiyama yakasolanan wainegu.” ");
INSERT INTO tteo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Saugana Yakobo wasa ibenalan natuna Daina Sikemi kamwasa mwalimwalinena iginauli koina yo natunao tatao siyaele ebaebaiwo sigite-kalatagili ule mena. Imwanou nige tawae yabo iwawalowen kanasiga natunao siyawatagilima yanuwa mena. ");
INSERT INTO tteo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Na Sikemi tamana Amo ilau Yakobo koina mekanakava siedeedede. ");
INSERT INTO tteo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ali edeedede luwana mena Yakobo natunao tatao siyawatagilima ule mena silobenalan tawae iyawatagiliko. Sibenalan bwaimwana duli Daina Sikemi ilokalatan iyakeno kali seyala ikin simunamunai kamwasane bwaine siya Isileli kali okwatakwata yo ali kaba mwalimwaline. ");
INSERT INTO tteo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Amo iwalolau kolili iba, “Natugu tauna Sikemi iya natumiu Daina katena ikan molosi yakawanoiyan kolimiu tem kwatalamwan ikalai wainena. ");
INSERT INTO tteo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mekamakavao komiu taekasokasola-nagila natumiyao sinesineo mekalikavao natumayao tatao sikasole. Tabe natumayao sinesineo mekalikavao natumiyao tatao sikasole, ");
INSERT INTO tteo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","na mesabana komiu yo kai tamiya-toyawa yanuwa bwaite koina. Yo tem na tawae nuwanuwamiu waginauli o nuwana toisabo dedei tem nuwanuwamiu kwamiyan wakalai kwamiyan nige kana yakasisi ipapagan.” ");
INSERT INTO tteo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Muli mena Sikemi ilau iedeedede Daina tamana yo dunao kolili iwaloba, “Tem yagu kawanoine waginauli besiele yagu nuwatune na tawae tem nuwanuwamiu wakawanoiyan koliyau yaeyawa kolimiu. ");
INSERT INTO tteo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Tem gogo esana nuwanuwamiu sine maisana mena kani yaeyawa kolimiu ginauli esana lalakisosina kani yaeyawa bwagabwagai kolimiu. Bwagana tem toweya besiele sine maisana kwapei kani yaginauli yo yaeyawa besiele ami nuwatune. Mwa bwai tem sinemo kwaeyama kakasolanan.” ");
INSERT INTO tteo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Na Yakobo natunao tatao sinuwanuwatu sosi kamwasa mwalimwalinena Sikemi iginauliyako duli Daina koina. Yo kabo mwakota yabo siginauli yo Sikemi me tamana Amo simwakota-yagili. ");
INSERT INTO tteo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Siwalolau kolili bwaite besiele siwaloba, “Nige sowasowana dumai katalamwan tomone iya nige nigwenigwe ikakalai koina na yakato ikasolanan nigele. Tem kaginauli bwaite besiele kani mwalimwaline lalakisosina kolimai. ");
INSERT INTO tteo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Mwa ginauli bagubagunana waginauli bwaite yomiu kwanigwaili besiele ami tatao meuloili yoli sinigwaili besiele kai mesabana katalam ami kawanoine koina. ");
INSERT INTO tteo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Tem waginauli besiele ama nuwatune kani katalam natumayao sinesineo ami tatao sikasolanagili, yo natumiyao sinesineo ama tatao sikasolanagili kabo komiu yo kai taboda kaigeda. ");
INSERT INTO tteo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Na tem nige ama nuwatune wagiginauli besiele tawae kawalowenako kolimiu nige nigwenigwe mumugana wakakalai, kani dumayao kakalaili yo yanuwa bwaite kalogabaen.” ");
INSERT INTO tteo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Kabo Amo me natuna Sikemi nuwatune bwaine sikawa-namwanamwa-yan. ");
INSERT INTO tteo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Kabo iya kilakaine Sikemi mwayamwayau mena ilau ipaisowai besiele, kaiwena Yakobo natuna Daina igadosisiyan molosi yo ana nume kana tomiya meuloili yo ana susuyao Sikemi siyakasisiyan lalakina yo esana ilalaki ali boda kalona mena. ");
INSERT INTO tteo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Yo Amo me natuna Sikemi silaoma ali yanuwa kana gamwa kaba lusalusae salina mena kaba egoegogo koina siwalo-masala yanuwane tautaubalaliyao kolili besiele, ");
INSERT INTO tteo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","siba, “Tataone mumugaliyao sinamwanamwasosi mwa tatalam simiya kolila, ala bwatano ilalakisosi sowasowana sibomamo ali nuwatu mena tawae nuwanuwali siginauli kani siginauli mwa koinaele sowana natuliyao sinesineo takasolanagili yo tabe siya natulao sinesineoliyao sikasolanagili. ");
INSERT INTO tteo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Na iyamo ginauli yabo nuwanuwali ele mwa yakato tem nigwenigwe mumugana takalai yo tapaisowa siya yo kita bwaine koina kabo mekalakavao taboda kaigeda. ");
INSERT INTO tteo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Yo ali ebaebai meuloina yo ali wasawasa meuloina iyaele kolili kani siyamala ala gogo. Tatalam ali kawanoi koina kabo kani silaoma simiyamiya bwaite koina luwala mena.” ");
INSERT INTO tteo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Siya tatao analiyao kabona silau yanuwa kana gana kaba lusaena mena Amo me natuna Sikemi ali edeedede sikawa-namwanamwa-yan yo sitalam koina, mwa koinaele sowasowana yanuwane tataoliyao meuloili nigwenigwe mumugana sikalai. ");
INSERT INTO tteo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Kaliyate yaiyona imwawasi tatao nigwenigwe sikalai mwa yoli kamkamnana kolili nige naga imwamwawasi. Kabo Yakobo natunao tatao yoli labui Simion yo Libai siya yoli labuine bwaite Daina dunao yawasosi, ali kaleya kelepana sikalai silusae yanuwa kalona mena nige yabo sikakabi-pei tatao meuloina simutu olili, ");
INSERT INTO tteo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","mekalikavao Amo menatuna Sikemi. Yo Daina siyoga-yawatagilan Sikemi ana nume kalona mena mwa silawan. ");
INSERT INTO tteo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Saugana Simion yo Libai tatao meuloina siunuyamateli imwawasi kabo tabe kalikavao Yakobo natunao tatao silaoma silusae yanuwa kalona mena yo Daina maisana sigumyai ginauli meuloina sikwayaili sikalaili. ");
INSERT INTO tteo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Sipi yo bulumakau yo donki yo kabo gogo yanuwa kalona mena yo yanuwa dagelana mena meuloina sikalaili. ");
INSERT INTO tteo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ali yanuwa sikwayai gogo maisaliyao lalakili ali sinesineo meuloili me natuliyao yo gogo nume kaloli mena meuloina sikalaili. ");
INSERT INTO tteo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yo Yakobo iwalolau Simion yo Libai kolili iwaloba, “Komiu kagu polowe wakabi-yamale yo kategu kwaula-wakawakaka. Tem Kenani yo Pelesaiti yo yanuwa bwaite mekalikavao siyaboda kaigedaili sowasowana kita yo ala bodao siyemwawasila kaiwena kita nige tababaibaiwa.” ");
INSERT INTO tteo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Mwa kainana siyamaisa siba, “Kaunuyamateli kaiwena nige sowana dumai katalamwan na siginauli koina besiele yakato iya toganawali yabo na yona italamwan mane kaiwena.” ");
INSERT INTO tteo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Yaubada iwalolau Yakobo koina iba, “Kutolo yo kulau yanuwa Betele koina kumiyamiya waya bwaine koina, yo kaba pwaoli yabo uginauli kaiwegu. Yau Yeoba yau mwa tauna kona yayawatagili koliwo sauganane koina kamkava Iso kuyabubu-gabaen.” ");
INSERT INTO tteo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yo Yakobo iwalolau ana nume kana tomiyayao kolili tatao yo sinesineo kolili iba, “Yanuwa wenala ali kokotomo uloina uloina kolimiu wakeke-gogonagili yo wagabaegili simiyawa yo yomiu wakatububu-nagili yo kami kaleko namwanamwaliyao kwalolikwa. ");
INSERT INTO tteo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Na yanuwa bwaite talogabaen yo tasae Betele yo bwaine koina kaba pwaoli yabo yayatolo Yeoba kaiwena, kaiwena iya sauga beyabeyana isaguiyau kagu polowe meuloina kolili yo saugana tem toweya yalauya dedei meuloina kolili iya mekaukava.” ");
INSERT INTO tteo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Yo tomo yanuwa wenala ali yaubadao kokotomo meuloili sikalailima tenaliyao me kali komwakomwa siwolena-gogon Yakobo koina ipuluili mayau keyalu yaina mena yanuwa Sikemi koina. ");
INSERT INTO tteo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Kabo saugana Yakobo me ana bodao sitolo silalau mwa Yaubada matamatausi lalakisosina iginauli siya yanuwane salili mena tomonliyao kolili mwa nige kaleya kaiwena sisasagena yamuli-kusulili. ");
INSERT INTO tteo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakobo me ana bodao meuloili silau siyawatagili yanuwa Lusa koina mwa bwaite saugane koina siba yanuwa Betele dedei Kenani koina. ");
INSERT INTO tteo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yo Yakobo kaba pwaoli yabo iginauli bwaine koina yo kabo yanuwa bwaine esana ipei Eli Betele na kana katai Betele kana Yaubada. Iginauli besiele kaiwena tauna kona kanakava Iso iyabubu-gabaen yo iyawatagili yanuwane bwaine koina yo Yaubada iyawatagili koina. ");
INSERT INTO tteo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Na Debola iya Libeka kana togite-kalatan ana sauga imwawasi yo bwaine koina yona sipei mayau keyalu yaina mena tete yavana mena Betele koina. Mwa dedeinane esana sipei Alon Bakuti, na Alon Bakuti kana katai valam mayauna. ");
INSERT INTO tteo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Mwa tabe Yakobo ipileyoima Mesopoteimiya koina yo Yeoba iyawatagili koina yo iwalo-muloloi. ");
INSERT INTO tteo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Sauganane koina Yaubada iwalolau koina iba, “Esam Yakobo kani nige siyoyogayan yoi. Na kani siyogayan Isileli.” Bwaine iya kaiwena mwa Yaubada esana ipei koina Isileli. ");
INSERT INTO tteo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Tabe besiele Yaubada iwalolau koina iba, “Yau Yaubada Tokaiwesosi, natumwao sidebalala yo kowa kuyamala yanuwa yo kaba loina koliwo situbuma yo koliwo kani kinyao siyawatagilima. ");
INSERT INTO tteo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Yo bwatano bwaite yaolena Abelamo yo Aisake kolili tabe yaolena yoi tubumwao yaso muliye kolili.” ");
INSERT INTO tteo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Sauganane koina Yaubada iedeedede woli yanuwane koina kabo Yakobo ilogabaen isaeyoi bulibuli mena. ");
INSERT INTO tteo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yo Yakobo veku yabo malamalawena lalakina ikalai yo iyatolo besiele tuki yabo kaiwena dedei bwaine koina iya yo Yaubada siedeedede. Kabo oine olona ikalai yo isuwai kaba pwaoli pwatana mena na iwalo-yakasisiyan Yaubada kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Kabo Yakobo yanuwane esana ipei Betele kaiwena bwaine koina iya yo Yaubada siedeedede. ");
INSERT INTO tteo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yakobo me ana bodao Betele silogabaen yo silalau Epalati kaiwena kabo tupwana kali mwayaga iyai yo Litieli diyana ikoi, iyamo ana kabi ipolowesosi. ");
INSERT INTO tteo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Yo iya iyaelemo naga kamkamna iunuunui melumelu ana laoma kaiwena yo kabo ana tokabikabi yaisu iwalolau koina iba, “Tabu kumamatausi, natum tauna yaboyoi bwaite.” ");
INSERT INTO tteo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Saugana Litieli yawasina iyasae yo igabaen bwaine koina yaumai imwawasi yo ikaisulu yo natunawa kabona esana ipei Benoni. Na tamana esana ipei Beniyamina. ");
INSERT INTO tteo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Yo Litieli ana sauga imwawasi yo yona sipeiya yanuwa Epalati kana kamwasa papalina mena bwaimwana iya Bedeliema. ");
INSERT INTO tteo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Na Yakobo itolo yo veku yabo ikumai Litieli kana salai mena kana kilakilala. Sauga kabona bwaite kilakilalane iyaelemo imiyamiya. ");
INSERT INTO tteo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Mwa Yakobo iutu-lau yoi yo ana palai iyatolo. Togite-kalatan ebaebaiwo ali kaba miya ilogabaen bwaimwana Migidali Edeli. ");
INSERT INTO tteo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Yakobo saugana iyaele bwaine dedeinane koina imiyamiya kabo Luben itolo yo ilau tamana wainena yabo mekanakava sikeno bwaimwana iya Bila. Yo Yakobo Luben ana paisowa wasana ibenalan. ");
INSERT INTO tteo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Yakobo natunao tatao kali baibaiwa tuwelo. Kabo siya bwaite Leya natunao ikabili. Tobagubaguna Luben, salina mena Simion, Libai, Yuda, Isako yo Sebulon. ");
INSERT INTO tteo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Litieli natunao siya Yosepa yo Beniyamina. ");
INSERT INTO tteo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Litieli ana gamasine esana Bila ikabili natunao Dani yo Napitalai. ");
INSERT INTO tteo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Yo Leya ana gamasine esana Silipa natunao ikabili esali Gada yo Aseli. Siya bwaite Yakobo natunao sikabiliya Mesopoteimiya. ");
INSERT INTO tteo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakobo ilaoma tamana Aisake koina yanuwa Mamele koina Kiliyati Alaba bwaimwa Ebiloni yanuwane tauna kona Abelamo koina imiyamiya mulina mena kabo Aisake koina tabe imiya. ");
INSERT INTO tteo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aisake ana bolime kana lalaki 180. ");
INSERT INTO tteo_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Yo itautaubala molosi mwa ana sauga imwawasi yo natunao labui Iso yo Yakobo tamali yona sikatububunani sipei salai mena. ");
INSERT INTO tteo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Iso esana labuina ele mwa Idoma, yo tubunao esaliyao bwaitete. ");
INSERT INTO tteo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","3","Iso wainenao Kenani sinesineoliyao ikasolanagili. Ada iya taubala Ilon susu Iti natuna sinena. Basimata iya Isimeli natuna sine, Nebayodi duna. Olibama iya taubala Ana natuna sinena. Na Ana tamana esana Sibiyoni iya susu Ivi. ");
INSERT INTO tteo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada ikabi natuna tauna esana Elipasi. Basimata ikabi natuna tauna esana Leuweli. ");
INSERT INTO tteo_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Olibama ikabi natunao tatao Deusi, Delem yo Kola. Iso natunao tatao meuloili ikabili waya yanuwa Kenani koina. ");
INSERT INTO tteo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Yo Iso itolo yo wainenao mekanakava natunao tatao yo sinesineo yo tabe nume gogona meuloina ana ebaebaiwo yo ana gogo meuloina ikalaili waya Kenani koina ikelegogon yo kanakava Yakobo itolo-gabaen yo ilau yo ilosuwala dedei yabo mena. ");
INSERT INTO tteo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Iso kanakava Yakobo ilogabaen kaiwena ali ebaebaiwo sibaibaiwasosi yo dedei bwaine koina simiyamiyane nige ilalalakisosi. ");
INSERT INTO tteo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Yo Iso iya esana yabo siba Idoma ilau Koya Seya koina imiya. ");
INSERT INTO tteo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Mwa bodane siya tamali Iso Seila koyane kana tomiyao iya natunao esali bwaitete, ");
INSERT INTO tteo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Elipasi Iso wainena Ada natuna, Leuweli Iso wainena Basimata natuna. ");
INSERT INTO tteo_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Yo Elipasi natunao tatao esaliyao bwaitete, Temani, Omelu, Sepo, Geitam yo Kenasi. ");
INSERT INTO tteo_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Iso natuna Elipasi wainena yabo Timina natuna ikabi esana Amaliki. Siya bwaite Iso wainena Ada tubunao. ");
INSERT INTO tteo_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Leuweli natunao tatao esaliyao bwaitete, Neyadi, Sila, Sama yo Misa. Bwaite siya tubu tatao Iso wainena Basimata tubunao. ");
INSERT INTO tteo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Iso wainena Olibama Ana natuna yo taubala Sibiyoni tubuna natunao tatao yaiyonamo ikabili Deusi, Delem yo Kola. ");
INSERT INTO tteo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Bwaite siya Iso natunao tatao ali tautaubalao susu kolili siyawatagilima esaliyao bwaitete. Iso natuna tobagubaguna Elipasi iya susu bwaite tubuli, Temani, Omelu, Sepo, Kenasi, ");
INSERT INTO tteo_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kola, Geitani yo Amaleki. Siya bwaitete Iso wainena Ada tubunao. ");
INSERT INTO tteo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Iso natuna Leuweli susu bwaitete tubuli, Neyadi, Sela, Sauna yo Misa. Siya bwaite meuloiline Iso wainena Basimata tubunao. ");
INSERT INTO tteo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Susu bwaite siya silaomaya Iso wainena Olibama Ana natuna koina. Deusi, Delem yo Kola. ");
INSERT INTO tteo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Susu bwaite siya silaomaya Iso tubunao kolili. ");
INSERT INTO tteo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Bwaite Seila iya taubala yo iya susu Olaiti me natunao siya yanuwa Idoma tomonliyao. Natunao tatao esaliyao bwaitete siyaele, Lotani, Sobali, Sibiyoni yo Ana, ");
INSERT INTO tteo_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Daison, Esili yo Disani. Bwaite siya susu Olaiti kali tautaubalao. ");
INSERT INTO tteo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotani natunao tatao labui, Oli yo Emani. Yo Lotani duna esana Timina. ");
INSERT INTO tteo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobali natunao tatao paibi Alibuli, Manayadi, Ebali, Sepa yo Onoma. ");
INSERT INTO tteo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibiyoni natunao tatao labui Aiya yo Ana. Ana iya mwa waila bunubunuwasina wedowedolina ilobai ule bwagabwaga mena dedei leleyanna mena saugana tamana ana donki igitegite-kalatagili na kawasi sikekakekan. ");
INSERT INTO tteo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana natuna tauna esana Daison yo Ana natuna sinena esana Olibama. ");
INSERT INTO tteo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Daison natunao tatao esopali Amidani, Esibani, Itilam yo Kelani. ");
INSERT INTO tteo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eso natunao tatao yaiyona, Biliyani, Seibani, yo Ekani. ");
INSERT INTO tteo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disani natunao tatao labui, Usa yo Aelan. ");
INSERT INTO tteo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Siya susu Olaiti yanuwa Idoma tomonliyao yo tautaubalao esali bwaite, Lotani, Sobali, Sibiyoni, Ana, Daison, Esali yo Disani. ");
INSERT INTO tteo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Sauganane koina bwaite siya kin siloiloina yanuwa Idoma koina muli mena kabo Isileli ali kin sipei. ");
INSERT INTO tteo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Biyo natuna Bela ana yanuwa Dinaba, iya iyamala ali kin yanuwa Idoma koina. ");
INSERT INTO tteo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Saugana kin Bela iboita mwa Yobabi Seila natuna ana yanuwa esana Bosila iyamala kin miyalaena. ");
INSERT INTO tteo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Saugana Yobabi iboita mwa Usama ilaomaya yanuwa Temani iyamiyalae iyamala kin. ");
INSERT INTO tteo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Tabe Usama iboita mwa Beyo natuna Eidadi ilaoma iyamala kin. Eidadi iya ana yanuwa Abeti. Iya Midiyan iunuili Mowabe dedeina mena. ");
INSERT INTO tteo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Saugana tabe Eidadi iboita yo Samila ana yanuwa esana Masilika ilaoma iyamiyalae yo iyamala kin. ");
INSERT INTO tteo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Yo Samila tabe iboita mwa Sauli ilaoma ana kaba miya ikalai iyamala kin. Sauli iya ana yanuwa esana Leiboli waila Yupeleitisi papalina mena. ");
INSERT INTO tteo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sauli iboita ana kaba miya Baliyanani ilaoma ikalai iyamala kin. Iya Akoba natuna. ");
INSERT INTO tteo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Tabe Baliyanani iboita mwa ana kaba miya Eidadi ikalai iyamala kin. Iya ana yanuwa esana Peu, wainena esana Mitabela, iya Matilida natuna sinena, iya tabe Miseba natuna sinena. ");
INSERT INTO tteo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Dedei Idoma ali susu ilaomaya Iso koina esaliyao bwaite siyaele, Timina, Aliba, Iyedeti, ");
INSERT INTO tteo_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Olibama, Ila, Painoni, ");
INSERT INTO tteo_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenasi, Temani, Maibisa, ");
INSERT INTO tteo_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Megidiela yo Ailami. Susu bwaite siya Idoma ali susu, yo dedei bwaine susu kaigeda kaigeda simiyamiya esali sipeipei-panapaisan siyetele-waliwaliesa-yagili susune kolili. Na Iso iya ali susu kana kulutubu yawasosi yaina. ");
INSERT INTO tteo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakobo tamana yanuwane bwaine Kenani koina imiyamiya iya tabe besiele koina imiyamiya. ");
INSERT INTO tteo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Bwaite edeededene Yakobo yo natunao edeededeli. Yosepa igamegame ana bolime sebentin (17) sinana esana Litieli, iya sipi yo gouti igitegite-kalatagili kanakavao mekanakavao, siya Bila yo Silipa natuliyao. Siya tamana wainenao tupwaliyao. Yosepa kanakavao tawae naenaena sipaipaisowai italawasawasayan tamana koina. ");
INSERT INTO tteo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yakobo (esana labuina Isileli) imulolososi Yosepa koina kabo muli mena natunao meuloili kolili, kaiwena ana sauga tautaubala mena kabo sikabi mwa kana kwama malamalawena lelelelena yo nimana malamalawena ikona. ");
INSERT INTO tteo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Saugana kanakavao sigitai tamali imulolososi Yosepa koina meuloili sikalomagigilan kabo nige sowasowana siwalo-bigabiga koina. ");
INSERT INTO tteo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Yosepa kenona ikenoi yo saugana kanakavao ali wasa iwolegili kabo simunamunai lalakina. ");
INSERT INTO tteo_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Iwalo kolili iba, “Kenogu bwaite yakenoi kwabenalan. ");
INSERT INTO tteo_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Meuloila tano mena witi tabwagibwagili, mwa yau yagu bwagili itolo-dudulai na komiu ami bwagili sitolo-takikilagau yo yagu bwagili koina sipwalou.” ");
INSERT INTO tteo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Kanakavao siwalolau koina siwaloba, “Kowa yakato kuloinayagimai wa?” Yosepa kenona yo tabe ana walo kaiweli simunamunai lalakina. ");
INSERT INTO tteo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yo tabe kenona yaboyoi ikenoi yoi kabo iba, “Yagitai dabwelo, waikena yo utu ileben koliyau sipwalou.” ");
INSERT INTO tteo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Saugana tamana yo kanakavao ali wasa iwolegili kabo tamana iyokoi yo iwaloba, “Toisabo keno bwaite ukenoi? Kubatoko, sinam, kamkavao yo yau kani kapwalou koliwo?” ");
INSERT INTO tteo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Kanakavao sikalomagigilan na iyamo tamana inuwanuwatu Yosepa ana edeedede kaiweli. ");
INSERT INTO tteo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Kabo kanakavao silau tamali ana sipi yo gouti sigitegite-kalatagili Sikemi koina. ");
INSERT INTO tteo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Yakobo iwalo Yosepa koina, “Ukwataiyako, kamkavao siyaele Sikemi, sipi yo gouti sigitegite-kalatagili. Kulaoma na kani yayawasao kulau kolili.” Yosepa iwaloba, “Inamwanamwa.” ");
INSERT INTO tteo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Yo iwaloba, “Sauga bwaite kulau ugitaili kamkavao na ali sipi yo gouti, gubesi sinamwanamwa? Na kuvivilama yagu wasa.” Kabo ali kaba miya Ebiloni bubuna ilogabaen ilau Sikemi koina. Saugana Yosepa iyawatagili Sikemi koina, ");
INSERT INTO tteo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","tomo yabo Yosepa ilobai ule mena iloyaloya-keikeile kabo tomone ineli Yosepa koina iwalo iba, “Tawae kuloyaloyai?” ");
INSERT INTO tteo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Kainana iyamaisa iwaloba, “Kaukavao yaloyaloyaili. Sowasowana kuwalo-masala koliyau toisabo dedei koina sipi yo gouti sigitegite-kalatagili?” ");
INSERT INTO tteo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Tomone iwaloba, “Dedei bwaite silogabaenako na yabenalan siedeedede yakato silalau Dotani.” Mwa Yosepa kanakavao mulili mena ilau yo ilobaili Dotani koina. ");
INSERT INTO tteo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Kabo sigitai kelamamalawe mena ilalaoma na siloina yakato kani sikoyamate. ");
INSERT INTO tteo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Siboma siedeedede siba, “Wagitai kenowa tokenokenoili ilalaoma. ");
INSERT INTO tteo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kwalaoma takoyamate yo kwapina tagabaen gula yabo koina. Na kabo taba yakayakan sokasokali ule mena sikanyako, yo tabe tagitai tawae kani imayale kenonane koina.” ");
INSERT INTO tteo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Luben ali nuwatu ikatai mwa itonan yakato Yosepa ileboi kabo iwaloba, “Tabu tauunui. ");
INSERT INTO tteo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Kwasinena tabu tayayadidi, sowana tagabaen bwaite gulane koina ule mena, tabu tayayakamkamna.” Iwalo besiele kaiwena nuwanuwana nimali mena ileboi yo iyawasa-yavivila tamana koina. ");
INSERT INTO tteo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Saugana Yosepa ilaoma kanakavao kolili mwa kana kwamawa silolo. ");
INSERT INTO tteo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Kabo sikabi-kalatan yo sigabae-lobiyen gula kalona mena. Na gulane labwalabwana nige waila kalona mena. ");
INSERT INTO tteo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Simiyasio yakato sikekan kabo sigitai Isimeli tubunao siya Midiya tomoliyao togimwala Giliyadi koina silaoma silalau Itipita. Ali kameli kolili olo kilaili sitaulili. ");
INSERT INTO tteo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda kanakavao kolili iwaloba, “Tawae kana namwanamwa tem kalakavane taunuyamate yo kwasinena tapei-wadam? ");
INSERT INTO tteo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kwalaoma tagimwala-yan togimwalane kolili na tabu taunuyamate kaiwena iya kwasinela tupwana.” Kanakavao ana nuwatu sikawa-namwanamwa-yan. ");
INSERT INTO tteo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Saugana togimwalane silalaoma Yosepa kanakavao sitabeisin gula mena yo sigimwalayan kolili siliba tuwenti (20) kaiwena, kabo Yosepa sikalai yo silawan Itipita. ");
INSERT INTO tteo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Saugana Luben ivivila ilau gula mena yo igitai Yosepa nigele nuwana inae yo kana kwama iigali. ");
INSERT INTO tteo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Kabo ivivila kanakavao kolili iwaloba, “Gamewa bwaine koina nigele na yau kani tawae yawawalowen tamala koina?” ");
INSERT INTO tteo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Kabo Yosepa kana kwama sikalai gouti yabo siunuyamate yo kwasinena koina kwamane siyalakwa. ");
INSERT INTO tteo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Kwama bwaite kwasikwasinena sikalai yo silawan tamali koina siwaloba, “Bwaite kwamane kalobai, ukilala, natum kana kwama o nigele?” ");
INSERT INTO tteo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ikilala kabo iwaloba, “Bwaitete natugu kana kwama. Nuwana yakayakan sokasokali sikanyako. Walo yawasosi Yosepa siigali-gwalagwalai-yako.” ");
INSERT INTO tteo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Kabo Yakobo kana kwama iigalili nuwanae kaiwena, kwauya kwamana kolili ilolikwa yo ivalavalam natuna kaiwena sauga imamalawe. ");
INSERT INTO tteo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Natunao tatao yo sinesineo meuloili silaoma yakato nuwana sikoi na isikote mwa iwaloba, “Nigele, kani meyagu valam kanasiga yalobi salai mena natugu koina.” Yo tamana ivalam natuna sabina. ");
INSERT INTO tteo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Na Itipita koina siya togimwalane Yosepa sigimwalayan Potipa koina, iya kin Pelo ana togite-kalatan yabo yo tokaleya ali taubala. ");
INSERT INTO tteo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Kabo Yosepa siyogan mekalikava silobiko Itipita yo Potipa kaleya kana taubala yabo Yosepa iyamaisa togimwalane kolili. Potipa iya tabe Pelo, Itipita kana kin, ana tomo lalakina yabo. ");
INSERT INTO tteo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yaubada Yosepa mekanakava mwa koina me ana katai imiyamiya ana taubala ana nume mena. ");
INSERT INTO tteo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Saugana ana taubala igite-lobai yakato Yosepa Yaubada mekanakava yo Yaubada Yosepa ana paisowa meuloili ikabi-yamalamalaeli, ");
INSERT INTO tteo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","kabo Yosepa kana meli ipei mwa iya ana esimili gabuna, yo Potipa ipeiyoi natunao, ana topaisowao yo ana gogo meuloili kali toloina yo kali togite-kalatan. ");
INSERT INTO tteo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Yosepa ana sauga loina kana sauga koina, Yaubada Potipa yo natunao yo ana topaisowa iwalo-muloloili Yosepa kaiwena. Walo-mulolo bwaite Potipa ana nume kalona yo besiele ana kaba loina simiyamiya dagela mena, meuloili silobai. ");
INSERT INTO tteo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Yo ginauli meuloili ilogabaegili Yosepa nimana mena yo iloina kolili. Nige ana golu ilalau ana gogo yabo koina bwaimwana kekanmo kaigeda kana nuwatu mwa koina imiyamiya. Sauganane koina Yosepa igamegame na kilakaina inamwanamwasosi. ");
INSERT INTO tteo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Kabo ana taubala wainena igitai, kaiwena ikaiwe mwa iba, “Kulaoma takeno.” ");
INSERT INTO tteo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Na iyamo isikote mwa iwalo iba, “Ginauli meuloili kali toloina yau. Yagu taubala imeliyagau mwa paisowa bwaite ipei nimagu mena. ");
INSERT INTO tteo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Nige tomo yabo esana ilalalaki nume bwaite koina bwaimwana yabomamo. Yagu taubala nige ginauli yabo iyayakasisi-yan koliyau, kaigedamo kowa, kaiwena wainena mwa kowa. Na tem bwaite yakasisine yalikwai kani Yaubada manna mena yalopwano.” ");
INSERT INTO tteo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Kaliyate kaigeda kaigeda kolili sinene Yosepa isamasamalului na iyamo genuwana mekanakava sikeno. ");
INSERT INTO tteo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Na sauga yabo koina Yosepa ibomamo ilau nume mena ipaipaisowa yo nige nume kana topaisowa yabo nume mena imiyamiya. ");
INSERT INTO tteo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Yo sinene Yosepa kana kwama koina ikabilau yo iwalo, “Kulaoma takeno.” Na iyabubu yo kana kwama ilogabaen sine nimana mena. ");
INSERT INTO tteo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Sauganane sinene igitai Yosepa kana kwama ilogabaen yo iyabubu-yawatagiliko nume mena, ");
INSERT INTO tteo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","kabo iyoga ana topaisowao kolili yo iwalo iba, “Wagitai. Bwaite tomo Ibeliu wainegu iyoyoganamawa isinalila kaiwena ilusaema yakato mekaukava kakeno mwa yawui. ");
INSERT INTO tteo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Saugana ibenalan yayoga sagu kaiwena, kabo kana kwama ilogabaen saligu mena yo iyabubu iyawatagili.” ");
INSERT INTO tteo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Mwa sinene Yosepa kana kwama ikabi-kalatan kanasiga ana taubala ivivilama nume mena. ");
INSERT INTO tteo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Kabo ana wasa iwolena iba, “Bwaine ala topaisowawa Ibeliu mena ukwakalai-yamawa kolila nuwanuwana isinaliwo mwa ilaoma yagu biliutusi mena yakato naenaena iginauli koliyau. ");
INSERT INTO tteo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Yo yayoga sagu kaiwena mwa kana kwama ilogabaen saligu mena na iyabubu iyawatagili. ");
INSERT INTO tteo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Bwaite besiele am topaisowa mumugane iginauli koliyau.” Kabo wainena imunamunai lalakina, ");
INSERT INTO tteo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ilau yo Yosepa ikabi-kalatan yo ipei deli mena, dedeinane kin ana tomo panpanli kaba peili. ");
INSERT INTO tteo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Iyamo Yaubada Yosepa mekanakava yo iwalo-muloloi. Yo deli kana togite-kalatan Yosepa kana nuwatu katena mena ipei imiyamiya. ");
INSERT INTO tteo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Mwa togite-kalatanne Yosepa ipei iloina siya panpanli meuloili kolili yo paisowa meuloili igite-kalatagili deli kalona mena. ");
INSERT INTO tteo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Togite-kalatanne nige paisowa yabo nimana mena igiginauli kaiwena Yaubada mekanakava Yosepa mwa ana paisowa meuloina inamwanamwa. ");
INSERT INTO tteo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Yo ginauli bwaite simwawasi kabo muli mena bwaite imayale. Itipita kana kin Pelo kana komwa tokayale yo kan tologabu ali taubala nuwana sisibayanae. ");
INSERT INTO tteo_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Kabo kin imunamunai ana topaisowane labui kolili, ");
INSERT INTO tteo_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","mwa tokaleya kali tobaguna ana nume mena ipeili deli koina, dedeinane koina Yosepa sipeiyako. ");
INSERT INTO tteo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Tokaleya kali tobaguna iwalolau Yosepa koina yakato igite-kalatagili yo kolili ipaisowa kabo kaliyate sibaibaiwa simiyamiya mekali pan. ");
INSERT INTO tteo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Yo yoli labui kenoli sikenoili, iboma iboma kenona boniyai kaigeda koina. Yo kali bui uloi uloi. ");
INSERT INTO tteo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Saugana Yosepa ilusaema kolili malala mena igitaili siya me ali katewakaka. ");
INSERT INTO tteo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Kabo kin ana topaisowao panpanli mekanakavao simiyamiya deli mena yo kolili ineli iwaloba, “Tawae kaiwena kabo wakatewakaka kaliyate kabona?” ");
INSERT INTO tteo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Kabo koina siwaloba, “Kenomayao kakenoili na nige sowasowana tomo yabo ilivasili kolimai.” Kabo Yosepa iwalo kolili, “Kenomiyao kali livasi Yaubada ana paisowa wa? Kenomiyao kwawalo-masalagili koliyau.” ");
INSERT INTO tteo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Mwa komwa kana tokayale kenona iwalowen Yosepa koina iwaloba, “Kenogu koina mayau wain mangu mena yagitai. ");
INSERT INTO tteo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Yo mayaune lagalaganao yaiyona besiele liguna waluwaluli silala yo sidibubu na wain kanna matuwali sibuina. ");
INSERT INTO tteo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Na kin kana komwa nimagu mena kabo wain kanna yakalaili yo kin kana komwa koina yatamli kabo yaolena kin koina.” ");
INSERT INTO tteo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yo Yosepa iwalo koina iba, “Bwaite kana nuwa-mayale. Lagalaga yaiyonane bwaimwa kaliyate yaiyona. ");
INSERT INTO tteo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Kaliyate yaiyona koina kin kani ilivasiwo yo am paisowa koliwo iyeyawa yoi kabo kin kana komwa nimana mena kupeiyoi besiele baguna kowa komwa kana tokayale. ");
INSERT INTO tteo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Na tem am miya namwanamwana kulobai kunuwatu-kalatagau. Yo yakawanoi koliwo ukwate-kamkamna-yagau na kin koina kuwalo-masalagau na deli mena yakaisulu. ");
INSERT INTO tteo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kaiwena sikewaliyau Ibeliu ali yanuwa mena na bwaite koina nige tawae yabo yasisibayanae na deli mena sipeiyau.” ");
INSERT INTO tteo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Kabo kan tologabu igitai yakato buine inamwanamwa kabo Yosepa koina iwaloba, “Yau besiele kenogu yakenoi yo pwalawa mayamayalena kodo yaiyona kulukulugu mena yagitaili. ");
INSERT INTO tteo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Yo kodo kewa molosi mena kan gabugabuli kin kaiwena na kulukulugu mena kodone koina man sikekakekan.” ");
INSERT INTO tteo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Kabo Yosepa iwalo koina iba, “Bwaite kana nuwa-mayale besiele. Kodo yaiyona bwaimwa kaliyate yaiyona. ");
INSERT INTO tteo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Kaliyate yaiyonana koina, kin kani iyagadosowao yo mayau koina iyatakewo na bulumam koina man sikekan.” ");
INSERT INTO tteo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Kabo kaliyate yaiyonana koina imayale kin sauga kabina kana nuwatu-kalatan yo ana topaisowa meuloili manli mena soi iginauli kabo komwa kana tokayale yo kan tologabu iyoganlima ana topaisowa meuloili manli mena. ");
INSERT INTO tteo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Yo komwa kana tokayale ana paisowa iwolena yoi. ");
INSERT INTO tteo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Na kan tologabu iyagadosowa besiele Yosepa ana walo koina. ");
INSERT INTO tteo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Na komwa kana tokayalene Yosepa ana kawanoi nige inunuwatu-kalatan na nuwana imwatainan. ");
INSERT INTO tteo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Saugana bolime labui simwawasi kabo kin kenona ikenoi yakato waila Naile papalina mena itotolo. ");
INSERT INTO tteo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Yo bulumakau seben waila mena sisaema kali koleya namwanamwali yo sinisinibuli kawasi koina sikekakekan. ");
INSERT INTO tteo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Mulili mena bulumakau seben uloili waila mena sisaeyoima, kali koleya naenaeli yo pwagepwagegeli sitotolo bulumakau salili mena waila papalina mena. ");
INSERT INTO tteo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Yo kabo bulumakau kali koleya naenaeli yo pwagepwagegeli sitolo bulumakau kali koleya namwanamwali sikanli. Kabo kin ikeno-tolo. ");
INSERT INTO tteo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ikenoyoi yo kenona labuina ikenoi yoi, pegapega yaina kaigeda na kinna meuloina seben, tubula ali kin namwanamwa. ");
INSERT INTO tteo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Mulili mena tabe pegapega seben sikinyoi giligilili yo bolibolime isapili siweweka. ");
INSERT INTO tteo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Pegapega kinli giligilili sitolo yo pegapega seben kinkin namwanamwali sisinolili. Yo kin ikeno-tolo yo ikatai yakato kenona mwa ikenokenoi. ");
INSERT INTO tteo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Malala mena me ana katewakaka mwa iwalo tokukula yo tosonoga meuloili Itipita kalona mena siyoganlima koina. Kin kenona iwalo-masalagili kolili na iyamo nige yabo sowasowana kenone kali bui ilivasili koina. ");
INSERT INTO tteo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Yo komwa tokayale iwalolau kin koina, “Kabona yagu lopwano nuwagu mena isae. ");
INSERT INTO tteo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Tauna kona kowa kumunamunai mwa yau yo kan tologabu kupeimai deli mena bwaine tokaleya kali tobaguna ana nume mena. ");
INSERT INTO tteo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Yomai labuine kenomai kakenoili boniyai kaigeda koina, na kenone labui kali bui uloi uloi. ");
INSERT INTO tteo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Kilakai yabo Ibeliu tomona mekamakava iya tokaleya kali tobaguna ana topaisowa, kenomai kawalo-masalagili koina mwa ibuili kaiwemai, kaigeda kaigeda kenona besiele. ");
INSERT INTO tteo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Yo tabe simayale kolimai besiele ana walo. Yau yagu paisowa yakalaiyoi na tomone yabone mwa siyagadosowa.” ");
INSERT INTO tteo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Kabo kin kaina iyawasa yo Yosepa siyoganama deli mena. Yosepa mwayamwayau kana koleya ikatububunan, kana kwama namwanamwana ikwamai kabo ilau kin manna mena itolo. ");
INSERT INTO tteo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kabo kin iwalolau Yosepa koina iwaloba, “Kenogu yabo yakenoi na nige yabo bwaite koina sowasowana ibui. Na yabenalan yakato tem keno yabo kubenalan sowasowam kubui.” ");
INSERT INTO tteo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yosepa iwalolau kin koina iwaloba, “Nige sowasowagu yapaisowai. Na Yaubada kani kenom maisana iyeyawa besiele am nuwatu.” ");
INSERT INTO tteo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kabo kin iwalolau Yosepa koina iwaloba, “Kenogu mena yau yatotolo waila Naile papalina mena. ");
INSERT INTO tteo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Bulumakau seben sinisinibuli yo kali koleya namwanamwali sigayosaema yo kawasi koina sikekakekan. ");
INSERT INTO tteo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Muli mena bulumakau seben yoi sigayosaema nige kali sinibu kali koleya naenaeli yo pwagepwagegeli. Nige sauga yabo koleyane bwaite naenaenane yagigitai yanuwa Itipita meuloina koina. ");
INSERT INTO tteo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Bulumakau pwagepwagegeli yo kali gite naenaeline bulumakauwa sinisinibuli sigagayosae bagunawa sikanli. ");
INSERT INTO tteo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Iyamo bwagana sikanliko kali koleya besiele nige sikakanli, kali gite naenaeline simiyayai besiele kali gite bagubagunana koina. Kabo yakeno-tolo. ");
INSERT INTO tteo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Kenogune kolili pegapega kinli seben tabe yagitailiyoi kinliyao namwanamwali sikinkin yai kaigeda koina. ");
INSERT INTO tteo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Mulili mena pegapega kinli seben sikinyoi giligilili yo bolibolime isapili yo siweweka. ");
INSERT INTO tteo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Pegapega kinli giligilili sitolo yo pegapega kinli seben namwanamwali sisinolili.” ");
INSERT INTO tteo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Kabo Yosepa iwalo kin koina, “Kenone labui kali bui kaigeda. Yaubada iwalo-masalanako koliwo tawae kani ipaisowai. ");
INSERT INTO tteo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bulumakau seben sinisinibuli yo kali koleya namwanamwali siya bolime seben yo pegapega seben kinli namwanamwali bwaimwa tabe siya bolime seben. Kabo meuloili kali bui kaigeda. ");
INSERT INTO tteo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Yo bulumakau seben pwagepwagegeli kali koleya naenaeli muli mena siyawatagili bwaimwa siya bolime seben yo besiele seben pegapega giligilili, bolibolime isapili yo siweweka, bwaimwa siya bolime seben guliyam. ");
INSERT INTO tteo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Bwaite besiele yawaloko koliwo, Yaubada iyamayaleyako koliwo tawae kani ipaisowai. ");
INSERT INTO tteo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Bolime seben koina kani masuli lalakina yanuwa Itipita meuloina koina. ");
INSERT INTO tteo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Kabo bolime seben kalona mena guliyam, yo masuli lalakina nuwali imwatainan yanuwa Itipita meuloina koina. ");
INSERT INTO tteo_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Yo masuline lalakina kani nige sinunuwatu-kalatan yanuwane koina, kaiwena guliyamne mulina mena kani kabo guliyam naenaesosina. ");
INSERT INTO tteo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Yo kenomne labui yaina nuwatune Yaubada ikabi-yakaiwe yo kani ipaisowai. ");
INSERT INTO tteo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Kabo sauga bwaite koina ilonamwa-yagiwo toloina sonosonogana ugite-sipwai na kupei iyamala gavana na Itipita iloinayan. ");
INSERT INTO tteo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Yo nuwatu bwaite uginauli, kabo yanuwa kana togite-kalatan kupeili na Itipita kali siyakasali lomwau valigigi bwaite besiele. Lomwau kaigeda sipei-suwalan lakawa mena na lomwau esopali kolili sikekan bolime seben masuli kolili. ");
INSERT INTO tteo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Kabo kan meuloina sikele-gogo-nagili saugana bolimene namwanamwali kolili, yo kuloina witi meuloina kana kaba lopei koina sipei yo siyakasisi-yan. ");
INSERT INTO tteo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Yo kan meuloina sipei guliyam kana losanasana bolime seben Itipita kalona mena kaiwena na koina tomo Itipita tabu siguguliyam.” ");
INSERT INTO tteo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Kabo nuwatu bwaite kin me ana topaisowa meuloili sikawa-namwanamwa-yan. ");
INSERT INTO tteo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Yo kin iwalo ana topaisowa meuloili kolili iba, “Sowasowana tomo yabo bwaite besiele taloyai, iya Yaubada yaluyaluwana imiyamiya koina?” ");
INSERT INTO tteo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Kabo kin iwalo Yosepa koina iba, “Ginauli meuloili Yaubada iyakenayagiwoko, nige yabo ana katai yo ana sonoga besiele kowa. ");
INSERT INTO tteo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Kowa kani yagu nume kuloinayan, yo besiele yagu tomo meuloili kani am loina simuliya. Iyamo yagu kaba miya yakayakasisina koina yalalaki-gabaegiwo.” ");
INSERT INTO tteo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Yo kin iwalo Yosepa koina iba, “Ugitai, yanuwa Itipita kana loina meuloina yaeyawa yapei nimam mena.” ");
INSERT INTO tteo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Kabo kin nimana kana pasa gibuna mena ilolo ipei Yosepa nimana mena. Yo kana kwama wasawasana koina iyakwama tabe kana galogalo gole galogalona mena iyagaloi. ");
INSERT INTO tteo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Mwa ana waga niuniuli labuina koina itauli yo manna mena siyoga siba, “Kwayakasisi-yan kaiwena iya kin ipei yanuwa Itipita meuloina kana toloina.” ");
INSERT INTO tteo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Kabo kin iwalo Yosepa koina, “Yau kin, na nige sowasowana tomo yabo Itipita meuloina koina ginauli yabo iginauli kanasiga am loina kupei.” ");
INSERT INTO tteo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Kabo kin Yosepa esana ipei Sapinadi-Paniya yo Asena iwolena wainena, iya Potipela, yanuwa Oni topwaoli natuna. Yo Yosepa iloina Itipita meuloina koina. ");
INSERT INTO tteo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yosepa ana bolime teti (30) saugana koina itolo Pelo, Itipita kana kin, manna mena yo ipaisowa. Yo Yosepa iyawatagili kin manna mena yo ilau itakikili Itipita meuloina koina. ");
INSERT INTO tteo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Saugana masuli bolime sebenne kolili yanuwa imasuli lalakina. ");
INSERT INTO tteo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Kabo masuline kana bolime seben kolili Yosepa kan meuloina itanogogon yanuwa Itipita koina yo ipei taon kolili. Taonne kaigeda kaigeda koina kanne ipeipeine silaomaya tanone salili mena kolili. ");
INSERT INTO tteo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Kabo Yosepa witi ipeipei gogon gwauli sisaeko besiele kalita dekawana, mwa nige ililiyei yoi, kaiwena kana liye ilikwai. ");
INSERT INTO tteo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Muli mena kabo guliyam kana bolime iyawatagili, melumeluwo tatao labui Yosepa natunao Asena ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yo Yosepa ana tobagubaguna tau esana Manase, kaiwena iwaloba, “Yaubada iyapaisowayau mwa yagu polowe meuloili yo tamagu ana bodao meuloili nuwagu imwatainagili.” ");
INSERT INTO tteo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Yo natuna labuina tau esana Ipeleim kaiwena iwaloba, “Yaubada iyapaisowayau mwa yamasuli yagu kamkamna yanuwanane koina.” ");
INSERT INTO tteo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Saugana masuli bolime seben Itipita kalona mena simwawasi, ");
INSERT INTO tteo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","mwa bolime seben guliyam kana sauga iyatubu, besiele Yosepa ana walo, kabo guliyam yanuwa meuloili ikalaili, na yanuwa Itipita kalona mena kan imiyamiya. ");
INSERT INTO tteo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Kabo saugana yanuwa Itipita kalona meuloina iguliyam, tomo sitasi yabayaba kin koina kan kaiwena, yo kin iwalolau Itipita tomo kolili iba, “Kwalau Yosepa koina, tawae tem iwalowen sowasowana kwapaisowai.” ");
INSERT INTO tteo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Saugana guliyam yanuwa yaulina meuloina ikeleoli, kabo Yosepa nume kan meuloili isokeli yo igimwala Itipita tomo kolili, kaiwena guliyam inae molosi Itipita kalona mena. ");
INSERT INTO tteo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Yo tomo yanuwa meuloina koina silaoma Itipita kan sigimwala Yosepa koina, kaiwena guliyam kabo inae molosi yanuwa meuloili kolili. ");
INSERT INTO tteo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Saugana Yakobo ikatai witi imiyamiya Itipita koina, iwalolau natunao kolili iwaloba, “Tawae kwanuwanuwatui na kita taguliguliyam?” ");
INSERT INTO tteo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Tabe iwaloyoi iba, “Yabenalan yakato witi imiyamiya Itipita koina. Kwalobi bwaine koina na tupwana wagimwala kaiwela na koina takekan kisi taboita.” ");
INSERT INTO tteo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Kabo Yosepa kanakavao yoli sanaulu silobi yakato kan sigimwala Itipita koina. ");
INSERT INTO tteo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Iyamo Yakobo natuna Yosepa kanakava yawasosi Beniyamina nige iyayawasa kanakavaone mekanakavao kaiwena katena iwakaka kisi isilae. ");
INSERT INTO tteo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kabo Yakobo natunao mekalikavao tomo sibaibaiwa silobi na sigimwala kaiwena guliyam imiyamiya tabe yanuwa Kenani koina. ");
INSERT INTO tteo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Na Yosepa iya Itipita yanuwane kana toloina, iya mwa gimwala kana toloina. Mwa saugana Yosepa kanakavao siyawatagili, sipwalou manna mena. ");
INSERT INTO tteo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Saugana Yosepa kanakavao igitaili, ikilalali na iyamo iboma iyakasisiyan yakato iya tomo uloi yo ikaina sikosikoko kolili, ineli iba, “To kwalaomaya?” Na Yosepa iedeedede kaina Itipita koina na tobui yabo ibuibui kaina Ibeliu koina. Kainana siyamaisa siba, “Kai kalaomaya yanuwa Kenani koina, kalaoma yakato kan kagimwala.” Ali walo siyemwawasi kabo tobuine kaina Itipita koina Yosepa ana wasa iwolena. ");
INSERT INTO tteo_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yosepa kanakavao ikilalali, na iyamo siya nige sikikilala. ");
INSERT INTO tteo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Kabo kenona kanakavao kaiweli inuwatuili yo iwalo kolili, iwaloba, “Komiu tolobubu yo kwalaoma yakato ama yanuwa wagitai toisabo dedei koina nige gana kana togite-kalatan na tem kwalusaema kwaunuimai.” ");
INSERT INTO tteo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Siwalo siba, “Nigele. Taubala, kai am topaisowao kalaoma yakato kan kagimwala. ");
INSERT INTO tteo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Kai meuloimai taubala kaigedamo natunao. Kai towalo yawasosi nige tolobubu.” ");
INSERT INTO tteo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yosepa iwalolau kolili iwaloba, “Nigele. Komiu kwalaoma yakato ama yanuwa kwalobubu.” ");
INSERT INTO tteo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Na iyamo siwaloba, “Yomai tuwelo taubala yabo yanuwa Kenani koina imiyamiya kai natunao. Tomulimuliya iyaele tamamai mekanakava na yabo iboitako.” ");
INSERT INTO tteo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yosepa iwalo kolili iwaloba, “Bwaimwa kaiwena mwa yawalo kolimiu yaba, komiu tolobubu. ");
INSERT INTO tteo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Bwaite besiele kani yatonagimiu. Kin Pelo esana mena kani nige bwaite yanuwane kwalologabaen kanasiga kamikavane tomulimuliya ilaoma bwaite koina. ");
INSERT INTO tteo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Yabo kolimiu kwayawasa ilau kamikavane ikalaiyama, na meuloimiu kani sikabi-kalatagimiu deli mena na koina ami walo yatonagili yo yagitai kwawalo-yawasosi o nigele. Tem kwamwakota kabo kin Pelo esana mena walo yawasosi komiu tolobubu.” ");
INSERT INTO tteo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Yo deli mena meuloili ipeili kaliyate yaiyona. ");
INSERT INTO tteo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Kabo kaliyate yaiyonana koina, Yosepa iwalolau kolili iwaloba, “Bwaite kani waginauli na kwanamwanamwa kaiwena Yaubada yamatausan. ");
INSERT INTO tteo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Tem komiu towalo yawasosi kani kamikava yabo imiyamiya deli mena na meuloimiu kwalau yo kan wakayale kwapileyoi ami bodao guliguliyamli kaiweli. ");
INSERT INTO tteo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Na iyamo kamikava tomulimuliya wakalaiyama koliyau na koina ami walo kani siyamala yawasosi yo tabe besiele komiu tabu kwaboboita.” Bwaite tabe siginauli besiele. ");
INSERT INTO tteo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Kabo siwalo kaigeda kaigeda koina siwaloba, “Yawasosi kani takamkamna tawae taginauliyako kalakavane koina. Yaluyaluwana ana kamkamna tagitaiyako saugana ikawanoi kolila yawasina kaiwena iyamo nige tabebenalan, iya kaiwena kamkamna bwaite ilaoma kolila.” ");
INSERT INTO tteo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Yo Luben kainali iyamaisa iwaloba, “Beyabeyana yawaloko kolimiu tabu mumugana naenaena wagiginauli gamene koina. Na iyamo nige kainagu kwabebenalan. Kabona kani kwasinena tayamaisa.” ");
INSERT INTO tteo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Na kabona walo tobui yabo iyaele iyapayapaisowa mwa kaiwena sibatoko Yosepa ali walo nige ikakatai. ");
INSERT INTO tteo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yosepa ilogabaegili ilau ivalam yo kabo ivivilamayoi kolili iedeedede. Muli mena kabo Simion ikalai yo ipan manli mena. ");
INSERT INTO tteo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yosepa iwalo ali kaba kayale witi siloyapowonli, tomo kaigeda kaigeda ana mane sipei-yavivila ana kwali kalona mena yo tabe kan siwolegili yoi kamwasa kaiwena. Ginauli meuloina kaiweli sipaisowai imwawasi. ");
INSERT INTO tteo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Kabo kali sipeili ali ase pwatali mena yo silau. ");
INSERT INTO tteo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ali kaba kaiyawasi koina yabo kolili ana kwali isoke yakato ana ase iyakan kabo ana mane igitai ana kwali kalona mena imiyamiya. ");
INSERT INTO tteo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Kanakavao kolili iwaloba, “Yagu manewa sipei-yavivila. Iyaelete yagu kwali kalona mena.” Kateli siwakaka yo sitagela-keikeile. Kaigeda kaigeda koina me ali tabubu yo siwaloba, “Tawae bwaite Yaubada iginauli kolila?” ");
INSERT INTO tteo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Saugana silaoma tamali Yakobo koina yanuwa Kenani koina, ana wasa siwolena ginauli meuloili siyawatagili kolili. Siwaloba, ");
INSERT INTO tteo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Tomone yanuwane kana toloina ikaina-sikosikoko-wagimai yo iwalo yakato kai yanuwane kana tolobubu. ");
INSERT INTO tteo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Iyamo kawalo koina kawaloba, ‘Kai towalo yawasosi nige tolobubu. ");
INSERT INTO tteo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Kai yomai tuwelo, tama kaigeda natunao, yabo iboitako na kama tomulimuliya iyaele tamamai mekanakava Kenani koina.’ ");
INSERT INTO tteo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Kabo tomone yanuwane kana toloina iwalo kolimai iwaloba, ‘Bwaite koina kani yakatai komiu towalo yawasosi, kamikava yabo kwapei koliyau na kan wakayale ami bodao guliguliyamli kaiweli na kwalau. ");
INSERT INTO tteo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Iyamo kami tomulimuliya wakalaiyama koliyau na yakatai yakato komiu nige tolobubu na towalo yawasosi. Na kabo kamikava yaeyawa yavivila kolimiu na kwalaoma wagimwagimwala yanuwa mena.’” ");
INSERT INTO tteo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Saugana ali kwali sisuwesuwe-gabaegili kaigeda kaigeda ana kwali kalona mena ana mane bwagilina imiyamiya metamali ali mane bwagilili sigitaili kabo simatausi. ");
INSERT INTO tteo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Kabo tamali Yakobo iwalo kolili iba, “Natuguwao wakalailiko koliyau, Yosepa nigele, yo Simion nigele na yakato Beniyamina wakalaiyoi. Ginauli meuloili siwenoweno koliyau.” ");
INSERT INTO tteo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Kabo Luben iwalolau tamana koina iwaloba, “Tem nige yakekele-yavivilayama kabo natuguwao tataone labui ukoyamateli. Beniyamina nimagu mena kupei na kani yayavivilayama koliwo.” ");
INSERT INTO tteo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Iyamo Yakobo iwaloba, “Natugu kani nige mekamkava kwalolobi bwaine koina, kanakava iboitako yo iya ibomamo imiyamiya. Tem kamwasa mena isilae kani itogune likelikena kwalobiyen salai mena meyagu nuwanae.” ");
INSERT INTO tteo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Guliyam lalakina yanuwa kalona mena, ");
INSERT INTO tteo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","kabo kan sikakalailima Itipita koina meuloili simwawasi, mwa tamali iwalo kolili, “Kwalau yoi yo kan tupwana wagimwalali kaiwela.” ");
INSERT INTO tteo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Iyamo Yuda iwalolau koina iwaloba, “Tomone iwalo kaiwe kolimai yakato kai kanakavao tabu kagigitai tem kamakava nige mekamakava. ");
INSERT INTO tteo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Tem kamakavane mekamakava kalau kani kan kagimwala kaiwem. ");
INSERT INTO tteo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Na tem nige ilalaoma mekamakava, kani nige kalolobi, kaiwena tomone iwalo kolimai iwaloba, ‘Kani nige kau koleya wagigitai tem kamikava nige mekamikava.’” ");
INSERT INTO tteo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Kabo Yakobo ineli, “Tawae kaiwena nae bwaite wakalaiyama koliyau yo tomone koina kwawalo-masala yakato kamikava yabo iyaele?” ");
INSERT INTO tteo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Siwalo siba, “Tomone kaigeda kaigeda ineli-yagimai ama bodao kaiweli yo kai kaiwemai. Ineli kolimai iba, ‘Tamamiu iyaele imiyamiya? Na tabu kamikava yaboyoi?’ Kai ana neli kayamaisali. Gubesi ama katakataina tem iwaloba kamikava kwayoganama bwaite koina?” ");
INSERT INTO tteo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Kabo Yuda iwalo tamana koina iwaloba, “Gamene kuyawasa ilaoma koliyau yo saugamo kalau, na koina kai yo kowa yo natulao simiyamiya nige sowasowana taboita. ");
INSERT INTO tteo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Yau yaboma kani yagite-kalatan na tem nigele kani naenane yabomamo koliyau. Na tem nige mekaukava kavivivilama koliwo yo tabe nige yapepei koliwo, kani naenane yau yakalai yagu miyamiyane meuloina koina. ");
INSERT INTO tteo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Tem besiele nuwana nige tayoyoviya kani talau yo tavivilama me labui.” ");
INSERT INTO tteo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Kabo tamali iwalo kolili, “Tem besiele kwapaisowa bwaite besiele. Yanuwa uwena yo gogona namwanamwali wakalaili yo ami kwali kolili kwataulili yo kwaolena tomone koina ami mulolo olo bwalabwalaina yo kan kamwakamwa luviluvina kikiuna. ");
INSERT INTO tteo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Manene wakakalaine kwaetulanyoi kaiwena kani silibawa ami kwali kaloli mena sitatauliliwa kwapei yavivilayoili. Nuwana bwaite lopwano. ");
INSERT INTO tteo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Kamikava mekamikava saugamo kwavivilayoi tomone koina. ");
INSERT INTO tteo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Yo Yaubada tokaiwesosi kani ikatekamkamna-yagimiu tomone manna mena na sowasowana Simion yo Beniyamina ilivasili yo sivivilama mekamikava. Na yau tem natuguwao yagabaegili kani sowana yagabaegili.” ");
INSERT INTO tteo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Kabo gamegameone mulolo bwaimwana sikalaili, besiele Beniyamina yo siliba kana lalaki sietulanyoi yo silo-mwayamwayau silobi Itipita yo sitolo Yosepa manna mena. ");
INSERT INTO tteo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Saugana Yosepa igitai Beniyamina mekalikava iwalo ana nume kana togite-kalatan koina iwaloba, “Gamegameone bwaite kuyoganli kulawagili yagu nume mena yakayakan yabo kuunui yo ukwatububun kala pwasinasina kekan kaiwena, na kani siya mekaukavao kakekan.” ");
INSERT INTO tteo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Kabo tomone ipaisowa besiele Yosepa ana walo koina yo gamegameone iyoganli silau Yosepa ana nume mena. ");
INSERT INTO tteo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Kabo gamegameone simatausi saugana siyoganli silau Yosepa ana nume mena. Kabo sinuwanuwatu siba, “Kita talaoma bwaite koina kaiwena siliba sitauli yavivilali ala kwali mena sauga bagubagunana koina. Iya nuwanuwana iunuila yo ikabi kalatagila yo ipanla yakato kita ana topaisowao panpanli na ala ase ikalaili.” ");
INSERT INTO tteo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Kabo silau Yosepa ana nume togite-kalatan koina siedeedede ana nume gamwana mena. ");
INSERT INTO tteo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Siwaloba, “Aee Taubala, kai kalobima baguna bwaite koina na kan kagimwala. ");
INSERT INTO tteo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Na yanuwane ama kaba kaiyawasi koina, ama kwali kasokeliwa kaigeda kaigeda ana siliba ilobai, meuloili kali polowe kaikaigedali ali kwali kaloli mena mwa siyaelete kakele yavivilalima mekamakava. ");
INSERT INTO tteo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Tabe besiele siliba tupwana kakele bwagabwagailima pwatana mena yakato kan kagimwala. Nige kakakatai yaiya ama silibane itaulili ama kwali kaloli mena.” ");
INSERT INTO tteo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Iwalo kolili iwaloba, “Inamwanamwa, tabu kwamamatausi. Ami Yaubada yo tamamiu ana Yaubada, gogo wasawasali iyeliwako ami kwali mena. Ami siliba yakalailiko.” Kabo Simion iyoganama kolili. ");
INSERT INTO tteo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Kabo nume kana togite-kalatan gamegameowa iyoga luseyagili Yosepa ana nume mena, waila iwolena kaekaeli sideulili yo kan iwolegili ali ase sikekan. ");
INSERT INTO tteo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ali mulolo sikatububu Yosepa ana vivilama kala pwasinasina mena, kaiwena sibenalan yakato kani mekalikava sikekanya bwaine koina. ");
INSERT INTO tteo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Saugana Yosepa iyawatagili ana nume mena, ali mulolo sikakalailimawa nume mena siwolegili koina, yo sipwalou manna mena. ");
INSERT INTO tteo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ineli kolili gubesi siya, kabo iwalo kolili iwaloba, “Na tamamiu kaiwena kwawalowalowa gubesi iya? Iyaelemo imiyamiya?” ");
INSERT INTO tteo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Kabo siwaloba, “Am topaisowa, tamamai iyaele meyawasina yo me ana namwanamwa.” Yo sipwalou koina kana yakasisi kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Kabo itagela-keile yo Beniyamina iboma kanakava, sinana natuna igitai yo ineli iba, “Bwaite kami tomulimuliyawa?” Yo iwalo Beniyamina koina iba, “Yaubada iwalo-muloloiwo, natugu.” ");
INSERT INTO tteo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Kabo Yosepa mwayamwayau ilowasi, kaiwena kanakava katena ikamkamna-yan. Kikiunamo ivalam mwa ilusae ana biliutusi kalona mena yo ivalam. ");
INSERT INTO tteo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Manna ideuli imwawasi, ilusaema ana nuwanae iboma nuwana mena kabo iwalo kan sikatububu. ");
INSERT INTO tteo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yosepa iboma ana kaba kekan uloina, kanakavao ali kaba kekan uloina yo besiele siya Itipita mekanakavao topaisowa ali kaba kekan uloina kaiwena siya Itipita ali nuwatu yakato tomo Ibeliu siya tomo bikibikili. ");
INSERT INTO tteo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Manna mena simiya yakasa kabi koina besiele tobagubaguna koina ilaoma kanasiga tomulimuliya koina kabo kanakavao simankulakula me ali nuwapwanopwano. ");
INSERT INTO tteo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yo iboma kana koina meuloili kali iyauyayoi mekaigeda na Beniyamina iboma kana mevaligigi siyauyan. Mwa sikekan toyawa yo sinuma me ali yaliyaya. ");
INSERT INTO tteo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yo Yosepa ana nume kana togite-kalatan koina iwaloba, “Gamegameone ali kwali kan koina kuloyapowon kali kayakayale ana lalaki koina. Yo game kaigeda kaigeda ana mane kupei yavivila ana kwali kalona mena. ");
INSERT INTO tteo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Kabo kagu komwa siliba kutauli tomulimuliya ana kwali mena besiele ana mane witi kaiwena.” Yo ipaisowai besiele Yosepa ana walo. ");
INSERT INTO tteo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Malala kikiuna kabo gamegameowa siyawasali ali ase kolili silau. ");
INSERT INTO tteo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Nige silolo-kelamamalawe kabo Yosepa iwalolau ana nume kana togite-kalatan koina iba, “Saugamo kutolo na tomo bwaite mulili mena kulau yo saugana kulobaili kuwalo kolili kuwaloba, ‘Tawae kaiwena namwanamwa kwayamaisa naenaena koina? ");
INSERT INTO tteo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Bwaite komwane iya yagu taubala ana kaba numa yo iyapaisowa ginauli silalaoma manna mena ana kaba kataina. Na tawae kaiwena kamwasa naenaena waginauli?’” ");
INSERT INTO tteo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Saugana togite-kalatan gamegameone ilobaili, Yosepa kainanawa iwalowen yoi kolili. ");
INSERT INTO tteo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Na siwalo koina siwaloba, “Tawae kaiwena am taubala walo bwaite besiele iwalowen? Kai am topaisowao nige sowana kamwasane bwaimwa kaginauli. ");
INSERT INTO tteo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ugitai, kai siliba kalobaili ama kwali kaloli mena yanuwa Kenani koina siyaele kayavivilalimako koliwo. Na gubesi yakato am taubala ana nume mena siliba o gole kakewalili? ");
INSERT INTO tteo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Tem yabo kolimai kulobai, iya kani iboita yo meuloimai kaemala ami topaisowa panpanli.” ");
INSERT INTO tteo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Yo togite-kalatanne iwaloba, “Inamwanamwasosi am nuwatu tapaisowai. Yaiya koina komwane tem talobai iyamala yagu topaisowa panpanna na meuloimiu kani kwalau livasi mena.” ");
INSERT INTO tteo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kaigeda kaigeda mwayamwayau ana kwali ipei-yatalu bwatano mena yo isoke. ");
INSERT INTO tteo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Kabo togite-kalatanane iloya iyatubu tobagubaguna koina kanasiga ilopei tomulimuliya koina. Yo komwawa ilobai Beniyamina ana kwali mena. ");
INSERT INTO tteo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Bwaite koina kali kwama siigalili kabo ali ase kolili sitautaulili yo sivivila silusae taon mena. ");
INSERT INTO tteo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yosepa iyaelemo nume mena saugana Yuda mekanakavao silusaema yo sibeku silobi bwatano mena iya manna mena. ");
INSERT INTO tteo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Na Yosepa kolili iwaloba, “Tawae bwaite waginauli? Tabu wakakatai yakato tomo besiele yau kani sowasowagu ami kewali yalobai?” ");
INSERT INTO tteo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda ana walo iyamaisa iba, “Tawae kani kawawalowen koliwo? Na kani gubesi ama livalivasimai? Yaubada ama nae iyamayaleliko. Sauga bwaite koina kai am topaisowa panpanli, kai meuloimai yo besiele iya komwa koina kwalobai.” ");
INSERT INTO tteo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Na Yosepa iwaloba, “Nige sowana bwaimwa besiele yapaisowai, ibomamo koina komwane kalobai kani iyamala yagu topaisowa panpanna. Meuloimiu kwavivilayoi me ami namwanamwa tamamiu koina.” ");
INSERT INTO tteo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Kabo Yuda isae koina yo iwaloba, “Aee yagu taubala, kutalamwagau walo yabo yawalowen koliwo. Tabu kumumunamunai koliyau bwagana kowa kutoyatoyawa kin Pelo koina. ");
INSERT INTO tteo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Kowa tauna kona kuneli kolimai, ‘Tabu tamamiu o kamikava yabo?’ ");
INSERT INTO tteo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Yo kai kawaloba, ‘Tamamai tautaubalana yo natuna game sikabi ana sauga tautaubala mena. Kanakava iboitako yo iya ibomamo sinana koina imiyamiya yo tamana imulolo koina.’ ");
INSERT INTO tteo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Kabo kowa kuwaloba, ‘Kwayogan kwalobima na yaboma mangu mena yagitai.’ ");
INSERT INTO tteo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Mwa kawalo koliwo kawaloba, ‘Gamene nige sowasowana tamana ilogabaen, tem ilogabaen kani tamana iboita.’ ");
INSERT INTO tteo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Na kuwalo kolimai kuwaloba, ‘Tem kami tomulimuliya nige ilolobima mekamikava kani nige mangu wagigitaiyoi.’ ");
INSERT INTO tteo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Saugana kavivila kasae tamamai koina, kainam kawalowegili koina. ");
INSERT INTO tteo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Kabo tamamai iwaloba, ‘Kwavivila kwalobi yo kan tupwana wagimwalayoi.’ ");
INSERT INTO tteo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Na kai kawaloba, ‘Kani nige kalolobi. Tem kama tomulimuliya mekamakava kani kalobi, nige sowasowana tomone manna kagitai tem kama tomulimuliya nige mekamakava.’ ");
INSERT INTO tteo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Tamamai iwaloma kolimai iwaloba, ‘Wakatai yakato wainegu natuguwao tatao labui ikabili. ");
INSERT INTO tteo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Yabo ilowasiko koliyau, nige manna yagigitai sauga imamalawe. ");
INSERT INTO tteo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Tem bwaite wakalaiyoi koliyau yo isilae komiu kani itogune likelikena kwalobiyen salai mena me yagu nuwanae.’ ");
INSERT INTO tteo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Mwa kabona tem gamene nige mekaukava saugana yavivila yalau tamamai koina yo tem tamamai iya ana miyamiya meuloina gamene mekanakava, ");
INSERT INTO tteo_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","igitai yakato gamene nige mekaukava, kani iboita. Yo kani tamamai itona likelikena kalobiyen salai mena me ana nuwanae. ");
INSERT INTO tteo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Yau yawasigu yatalamwan gamene ana namwanamwa kaiwena tamagu koina. Yo yawaloba, ‘Tem nige yayavivilanama koliwo, kani manim mena yakewane meuloina imiyayai koliyau yawasigu meuloina koina.’ ");
INSERT INTO tteo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Kabo sauga bwaite koina, gamene kutalamwan na yayamiyalaei yaemala am topaisowa panpanna na gamene kupei ivivila kanakavao mekanakavao. ");
INSERT INTO tteo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Gubesi kani yagu vivila tamagu koina tem gamene nige mekaukava? Nige nuwanuwagu naene iyawatagili tamamai koina.” ");
INSERT INTO tteo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yosepa ana nuwanae ilalakisosi genuwana ivalam ana topaisowao manli mena, mwa iwui iba, “Meuloimiu kwalogabaegau.” Yo meuloili silowasi kabo Yosepa iboma iwalo-masalan kanakavao kolili. ");
INSERT INTO tteo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ivalam wuiwui kabo Itipita tomonliyao sibenalan yo kin ana topaisowao tabe kainana sibenalan yoi. ");
INSERT INTO tteo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yosepa kanakavao kolili iwaloba, “Yau Yosepa. Gubesi tamagu iyaele imiyamiya?” Na iyamo kanakavao nige sowasowali ana neli siyamaisa. Simatausi lalakina kaiwena iya kalikava manli mena sigitai. ");
INSERT INTO tteo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Kabo Yosepa kanakavao kolili iwaloba, “Kwalaoma saligu mena.” Saugana silaoma salina mena kabo iwaloba, “Yau kamikava Yosepa, yau mwa kwatalamwagau Itipita siyamaisayau. ");
INSERT INTO tteo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Na sauga bwaite koina tabu katemiu siwawakaka yo tabu kwaboma kwauula-munamunaimiu, ami gimwalayaune bwaite kaiwena tomo leboili kaiwena mwa Yaubada iyawasayau yabagunama. ");
INSERT INTO tteo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Bwaite bolimene labui kaloli mena kani yanuwa iguliyam, na bolime valigigi silalaoma kolili kani nige kuma yo kelikeli sipapagan. ");
INSERT INTO tteo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Mwa Yaubada iyawasayau yabagunama na yakatububu kaiwemiu na yanuwa yaulina mena tupwamiu yagite-kalatagimiu na yawasimiu yapei kaba lebo lalakina koina. ");
INSERT INTO tteo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Mwa koina komiu nige kwayayawasayauma, na Yaubada iya ana sagu mena mwa kin Pelo manna mena yaemala tomo lalakina, ana nume topaisowa ali taubala yau, yo Itipita meuloina yaloinayan. ");
INSERT INTO tteo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Mwayamwayau saugamo kwavivilayoi tamagu koina kwawaloba, ‘Natum Yosepa kainana bwaite besiele, Yaubada ipeiyauko Itipita meuloina ali taubala. Kulobima koliyau tabu kuyoyoviya. ");
INSERT INTO tteo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Kani kumiya yanuwa Gosen koina saligu mena kowa, natumwao yo tubumwao, am sipi, am gouti yo am gogo meuloili. ");
INSERT INTO tteo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Kani yasaguimiu kaba sagu meuloina koina kaiwena bolime valigigi guliyam siyaelemo silalaoma. Kisi besiele kowa yo am bodao kwaboita yo am gogo meuloili simwawasi.’ ");
INSERT INTO tteo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Kaukava Beniyamina yo tabe komiu manimiu mena wagitaiyauko mwa walo yawasosi yau mwa yaedeedede kolimiu. ");
INSERT INTO tteo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Tamagu koina kwawalolau bwaite kagu meline Itipita sipepeine kaiwena yo besiele tabe tawae siyaele wagitailiko kwawalo-masalagili. Na tamagu mwayamwayau kwayogan kwalobiyenama bwaite koina.” ");
INSERT INTO tteo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Kabo kanakava Beniyamina isapwali yo ivalam yo Beniyamina Yosepa isapwali yoi sivalam toyatoyawa. ");
INSERT INTO tteo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yo kanakavao meuloili inisoili me ana valam. Muli mena kabo kanakavao siedeedede koina. ");
INSERT INTO tteo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Saugana kin me ana bodao wasa bwaite sibenalan yakato Yosepa kanakavao silaoma koina siyaliyaya lalakina. ");
INSERT INTO tteo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Kin iwalo Yosepa koina iwaloba, “Kamkavao kolili kuwalolau, ‘Bwaite kwapaisowai, ami yakayakan kali kayakayale kwaolegili na kwavivilayoi Kenani, ");
INSERT INTO tteo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","na tamamiu yo natumiyao kwayoganlima koliyau. Kani Itipita kalona mena dedei yabo wabolana yaeyawa kolimiu na me ami yaliyaya kwamiya dedeine koina.’ ");
INSERT INTO tteo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Tabe besiele kuwalo dudulai kolili, ‘Bwaite kwapaisowai, waga niuniuli tupwali Itipita koina kwaniulili natumiyao, wainemiyao yo tamamiu kwataulili na kwalaoma. ");
INSERT INTO tteo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ami gogo meuloili simiyawa, kaiwena Itipita ana wasawasa meuloili kani wakalaili.’” ");
INSERT INTO tteo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Mwa Yakobo natunao sipaisowai besiele. Yosepa waga niuniuli iwolegili besiele kin ana loina, yo besiele kali kanale ali lau kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Kaigeda kaigeda kali kaleko yo kali kwama waluwaluli iwolegili na Beniyamina koina iwolena siliba tili andeledi tabe kwama yo kaleko bwagili valigigi. ");
INSERT INTO tteo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Na bwaitete iyawasali tamana koina, ase sanaulu kali kayakayale gogomo namwanamwali Itipita gogona yo tabe ase sinesineomo sanaulu kali kayakayale witi yo pwalawa tabe gogo tupwaliyao yoi tamana koina ana lobima kaiwena. ");
INSERT INTO tteo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Kabo Yosepa kanakavao iyawasali sivivilayoi yo ali sauga tolo koina iwalo kolili iwaloba, “Tabu wagagamwa-pakiki kamwasa mena.” ");
INSERT INTO tteo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Yo siutusae Itipita silogabaen yo silaoma tamali Yakobo koina yanuwa Kenani koina. ");
INSERT INTO tteo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Siwalo koina siwaloba, “Yosepa iyaelemo meyawasina imiyamiya. Mwa yawasosi iya Itipita meuloina iloinayan.” Yakobo makamakayauna ipito, nige imemeli kolili. ");
INSERT INTO tteo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Na saugana Yosepa kainana meuloili siwalowegili koina tabe waga niuniuli Yosepa iyayawasali kaba taulina igitaili, tamali Yakobo yaluyaluwana ivivilayoi koina. ");
INSERT INTO tteo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Yo Yakobo iwaloba “Kabo nuwagu idudulai. Natugu Yosepa iyaelemo meyawasina imiyamiya. Kani yalobi yagitai na kabo muli mena yaboita.” ");
INSERT INTO tteo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Mwa Yakobo ikwasa ana gogo meuloili ikalaili yo saugana iyawatagili Biyasiba, ipwaoli tamana Aisake ana Yaubada koina. ");
INSERT INTO tteo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Yo Yaubada kenogite koina iwalolau boniyai mena iwaloba, “Yakobo. Yakobo.” Yakobo iwaloba, “Yau elete.” ");
INSERT INTO tteo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Yo iwaloba, “Yau Yaubada, tamam ana Yaubada, tabu kumamatausi lobi Itipita kaiwena. Kaiwenaele kani gwalugwalumwao yayadebalalali. ");
INSERT INTO tteo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Kani yau mekaukava kowa talobi Itipita na kani yakele-yavivilayoimiu. Yo am sauga boita koina natum Yosepa mekamkava iboma nimana mena kani manim ikausili.” ");
INSERT INTO tteo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Biyasiba ilogabaen na Yakobo natunao, tamali sikalai yo natuliyao yo waineliyao sitaulili waga niuniuli kolili kin iyayawasali kolili. ");
INSERT INTO tteo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Tabe besiele ali yakayakan yo tabe gogo meuloina Kenani koina sikalaili yo Yakobo me ana bodao meuloili silobi Itipita. ");
INSERT INTO tteo_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Natunao tatao yo tubunao tatao, natunao sinesineo yo tubunao sinesineo ana bodao meuloili ilobi-yegili Itipita. ");
INSERT INTO tteo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Kabo Yakobo Yuda iyawasa-bagunayan ilobi Yosepa koina ineli Gosen kana kamwasa kaiwena. Saugana siyawatagili Gosen bwaimwa Itipita dedei kalona mena, ");
INSERT INTO tteo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yosepa ana waga niuniuli iwalo sikatububun yo isae tamana igitai Gosen koina. Saugana Yosepa iyawatagili koina, tamana isapwali yo ivalam sauga imamalawe. ");
INSERT INTO tteo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Kabo Yakobo iwalolau Yosepa koina iwaloba, “Kabona kabo yatalamwagau tem yaboita, kaiwena iyaele yaboma mangu mena yagitaiwoko yakato kowa iyaelemo meyawasim.” ");
INSERT INTO tteo_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Yakobo natunao mekanakavao silau Itipita koina mekalikavao natuliyao siya bwaite esaliyao, ");
INSERT INTO tteo_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Luben, Simion, Libai, Yuda, ");
INSERT INTO tteo_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isako, Sebulon, Beniyamina, ");
INSERT INTO tteo_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani, Napitalai, Gada yo Aseli. ");
INSERT INTO tteo_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Siya bwaite Yakobo natunao yo tubunao kali baibaiwa sebenti. Na natuna Yosepa iyaele Itipita. ");
INSERT INTO tteo_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Simiyamiya ee kabo Yosepa yo kanakavao siya yaso bwaine siboita, ");
INSERT INTO tteo_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","na tubuliyao Isileli sikabikabi, na sibaibaiwasosi yo sikaiwe kabo Itipita siyakalapowon. ");
INSERT INTO tteo_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Bolime sibaibaiwasosi mulina mena kabo kin waluwaluna yabo itolo yo Itipita iloinayan, iya Yosepa wasana nige ibebenalan, nige ikakatai yakato Yosepa iya tomo Isileli yabo yo Itipita tomo isaguili. ");
INSERT INTO tteo_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Kin iwalo ana tomoyao Itipita kolili iba, “Eei, Isileli sidebalala yo sikaiwesosi bwaite ala kaba nae yabo iyawatagili. ");
INSERT INTO tteo_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Yamatausi yo kategu iwakaka tem kaleya iyawatagili kani Isileli kala tokalomagigiliwo sisaguili siyaboda kaigeda na silaoma sikaleya kolila kabo sikaiwe-gabaegila na siyabubu. Mwa koina sauga bwaite ilonamwayagila tem loina kolokolololi taginauli kolili kisi ali boda idebalala yo sibaibaiwa.” ");
INSERT INTO tteo_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Kabo tomo Isileli siyamala Itipita ali topaisowa panpanli na Itipita tomo Isileli siyakamkamnali paisowa polopoloweli siwolegili yakato yaluyaluwali siyakamkamnali. Mwa kaba gite bwaite, Itipita siloina kaiwe na Isileli wauwau sisepali kabo taon lalakili sikabili esali Pilom yo Lamesese, kin ana gogo kaba kalakalaina. ");
INSERT INTO tteo_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","14","Bwagana Itipita Isileli siyakamkamnali, na iyamo siya Isileli kali boda idebalala isaesae yo ali yanuwa siyalalaki yoi. Kabo Itipita simatausi Isileli kolili mwa siwalo paisowa polopoloweli siginaulili yo siwalo sipaisowa nume kana kabi koina yo tano koina, nige sikakate-kamkamna-yagili. Kabo Itipita tomo Isileli ali miyamiya sisibayanae. ");
INSERT INTO tteo_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Yo Itipita ali kin iedeedede sinesineo labui kolili esali Sipila yo Puwa, siya ali paisowa Ibeliu sinesineoliyao sisaguili kabi kana sauga koina. ");
INSERT INTO tteo_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Iwalo, “Saugana Ibeliu sinesineoliyao kwasaguili ali sauga kabi koina, tem sikabi na tau wakoyamate, na tem sine, kwapei meyawasina.” ");
INSERT INTO tteo_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Na tosagu labuine simatausi Yaubada koina kabo kin ana walo nige sibebenalan kabo tatao nige sikokoyamateli. ");
INSERT INTO tteo_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Na kin ibenalan yakato melumelu tataoliyao nige siuunuyamateli kabo walo iyawasa tosagu labuine silaoma mwa ineli-yagili iba, “Tawae kaiwena kwapaisowai besiele? Tawae kaiwena kwatalam tem tatao meyawasili?” ");
INSERT INTO tteo_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Kabo kin kainana siyamaisa siba, “Ibeliu sinesineoliyao nige besiele Itipita sinesineoliyao, ali kabi imalaesosi, sikabi kabo muli mena kayawatagilima kolili.” ");
INSERT INTO tteo_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Koinaele Yaubada sinesineo labuine isaguili siboma natuliyao iwolegili kolili kaiwena Yaubada simatausan na Isileli kali boda idebalala isaesae yo sikaiwe. ");
INSERT INTO tteo_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Kabo kin loina kaikaiwena iginauli iwaloba, “Ibeliu melumeluwo kikiuli siya tatao wakalaili wagabaegili waila Naile koina sigalomwasi, na siya melumelu sinesineo kwatalamwagili meyawasili.” ");
INSERT INTO tteo_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Na tau yabo mekanakava sine yabo sikasole, siya yoli labuine tomo Isileli, Libai ana susu, ");
INSERT INTO tteo_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","kabo natuli tau sikabi. Sinene igitai melumelu kana koleya inamwanamwasosi kabo iwadam imiyamiya kanasiga waikena yaiyona. ");
INSERT INTO tteo_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Na saugana nige sowasowana iwadamyoi, kabo kodo yabo iyalusi lei malamalaweli koina, yo bwatano mena ikebali nige sowasowana waila ilusae. Melumelu itauli na iwadam kawasi malamalawena luwana mena waila papalina mena. ");
INSERT INTO tteo_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Melumelu duna itolo-suwala igitagitai tawae kani iyawatagili koina. ");
INSERT INTO tteo_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Na kin natuna sine ilobima sabi sugu waila mena na ana topaisowa silolokeikeile waila papalina mena. Kabo kin natuna kodone igitai kawasi luwali mena yo topaisowa sine yabo iyawasa ilau ikalaiyama. ");
INSERT INTO tteo_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Saugana kin natuna kodone isoke melumelu tauna igitai, melumelune ivalavalam kabo kin natuna nuwana inae yo katena ikamkamna-yan. Iwaloba, “Ibeliu melumeluna yabo bwaite.” ");
INSERT INTO tteo_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Kabo melumelune duna ilau kin natuna koina ineli iwaloba, “Gubesi, tem sowasowana yalau Ibeliu sinena yabo yawalo ilaoma melumelune ikalai igite-kalatan na iyasusu kaiwem?” ");
INSERT INTO tteo_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Kabo kin natuna italam iwaloba, “O, kulau.” Mwa gamasinene ilau melumelu sinana yawasosi iyoganama. ");
INSERT INTO tteo_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Kabo kin natuna iwaloba, “Melumelu bwaite ukwalai, kuyasusu kaiwegu na kabo yayamaisao.” Yo melumelu ikalai iyasusu. ");
INSERT INTO tteo_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Muli mena, melumelu ilalaki kabo sinana iyapileyoi kin natuna koina yakato iya iyamala kin natunane natuna. Kin natuna inuwatui iwaloba, “Yagayo-seyanama waila mena kabo esana yapei Mosese.” ");
INSERT INTO tteo_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Saugana Mosese ilalaki nuwanuwana ilau ana tali Ibeliu igitaili. Ilau yo igitai sikamkamna kaiwena paisowa polopoloweli sipaipaisowaili Itipita ali loina koina. Kabo sauga yabo igitai Itipita tomona yabo Isileli tomona iunuunu-gwalagwalai. ");
INSERT INTO tteo_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mosese igitai kabo imunamunai yo igite-keikeile nige tomo yabo igigitai dedeinane koina kabo Itipita tomona iunuyamate yo yona ipulu-wadam bwatano mena. ");
INSERT INTO tteo_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Yanuwa ilayan kabo ivivilayoi na Ibeliu tataoliyao labui igitaili sikalekaleya, kabo iwalolau kaleya toyatubuna koina iwaloba, “Tawae kaiwena am tali Ibeliu kuunuunui?” ");
INSERT INTO tteo_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Yo tomone iwaloba, “Kowa nige kai kama toloina yo kama toyatala. Gubesi nuwanuwam kuunuyamateyau besiele laina Itipita tomona kuunuyamate?” Mwa Mosese isiliyata yo imatausi, inuwanuwatu iba, “Tomo silobaiyauko yo sikatai tawae yaginauli.” ");
INSERT INTO tteo_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Kin Mosese wasana ibenalan yakato Itipita yabo iunuyamateyako, kabo kin nuwanuwana Mosese iunuyamate na Mosese iyabubu ilau dedei Midiya. Sauganane Mosese iyawatagili Midiya koina ilau imiyasio waila keli yabo sopana mena, ");
INSERT INTO tteo_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","kabo Midiya ali topwaoli kokotomo kali tobaguna esana Yetolo natunao sinesineo yoli seben silaoma na waila silegu tamali ana sipi yo ana gouti siyanumali. ");
INSERT INTO tteo_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Na boda uloi sipi togite-kalatan tupwaliyao silaoma sinesineone sitawoili. Kabo Mosese ilau sinesineone isaguili waila ilegu ali ebaebai kaiweli. ");
INSERT INTO tteo_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Saugana sivivilayoi tamali koina kabo ineli kolili iwaloba, “Tawae kaiwena mwayamwayau kwavivilama kaliyate kabona?” ");
INSERT INTO tteo_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Siwaloba, “Saugana sipi togite-kalatan sitawoimai, kabo Itipita tomona yabo isaguimai na waila ilegu kaiwemai iwolena ala ebaebai kolili.” ");
INSERT INTO tteo_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Yo ineli natunao kolili iwaloba, “Na toweya iyaele? Tawae kaiwena kwalogabaen? Kwalau kwawalo ilaoma mekalakava takekan.” ");
INSERT INTO tteo_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Kabo silau siwalolau Mosese koina yakato mekalikava tem silau ali nume mena sikekan. Mwa Mosese italam yo ilaoma mekalikava ali nume mena sikekan. Imwawasi yo italam imiyamiya kolili, na Yetolo natuna yabo esana Sipola italamwan Mosese koina mekanakava sikasole. ");
INSERT INTO tteo_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Yo natuli tau sikabi. Mosese inuwanuwatu kabo iwaloba, “Yanuwa bwaite koina yamiya taumana kabo esana yapei Gelisoma.” ");
INSERT INTO tteo_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Bolime sibaibaiwa imwawasi kabo Itipita ali kin iboita, na Isileli siyaelemo me ali kamkamna simiyamiya Itipita koina, kabo sivalam kawakawanoi sagu kaiwena. Ali valam isae Yaubada koina, ");
INSERT INTO tteo_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","kabo ali valam kawakawanoi ibenalan yo ana waloyameli Abelamo, Aisake yo Yakobo kolili inuwatu-kalatan. ");
INSERT INTO tteo_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Igitai Isileli ali polowe yo ali kamkamna ilalakisosi kaiwena siya topaisowa panpanli mwa ikatekamkamna-yagili. ");
INSERT INTO tteo_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mosese bwasiyana Yetolo ana sipi yo ana gouti igitegite-kalatagili, na kaliyate yabo ibagunayagili yo silau dekawa bwagabwaga mena ule mena ilu-utusi yo iyawatagili Sainai koina Yaubada ana koya yakayakasisina. ");
INSERT INTO tteo_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Kabo Yaubada ana anelose iyawatagili Mosese koina mayau kalapulupululuna mena. Mosese igitai mayau kalapulupululuna iwedowedoli na iyamo mayaune itotolone nige iwewedoli. ");
INSERT INTO tteo_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Kabo nuwana ipwanopwano yo iwaloba, “Tawae kaiwena mayaune nige iwewedoli? Naga yalau salina mena na mayaune yagitai.” ");
INSERT INTO tteo_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Yeoba igitai Mosese ilau mayaune salina mena kabo iyoga koina mayau kalapulupululuna luwana mena iwaloba, “Mosese. Mosese.” Kabo Mosese Yeoba kainana iyamaisa iba, “O, yau elete.” ");
INSERT INTO tteo_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Mwa Yeoba iwaloba, “Tabu kulalaoma mayau salina mena, kaekaem kana suma ukwele-gabaegili kaiwena bwatanone koina kutotolone yakayakasisina. ");
INSERT INTO tteo_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Yau tubumwao Abelamo, Aisake yo Yakobo ali Yaubada.” Yo Mosese manna ikabi-kaukausi kaiwena imatausi tabu Yaubada igigitai. ");
INSERT INTO tteo_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Kabo Yeoba iwaloba, “Yagitaiyako Itipita yagu tomoyao Isileli siyakamkamnali lalakina, ali valam yabenalan nuwanuwali yakato yaleboili kali toloinao naenaeli kolili, ali kamkamna meuloina yagitaiyako. ");
INSERT INTO tteo_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Mwa koina sauga bwaite yalobima na tem Isileli yaleboili Itipita nimali mena, yo tabe nuwanuwagu yabaguna-yagili siyawatagili Itipita silogabaen na silau yanuwa namwanamwana yo lalakina koina, yanuwa masumasulina, yanuwa bwaine esanaele Kenani. Na bwaite sauga boda tupwaliyao simiyamiya Kenani koina, esaliyao bwaite, Kenani, Iti, Amoli, Pelisi, Ivi yo Yebusi. ");
INSERT INTO tteo_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Yagitai tomo Itipita yagu tomoyao Isileli siyakamkamnali lalakina yo ali valam yabenalanako. ");
INSERT INTO tteo_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Koinaele kulaoma yayawasao kulau Itipita ali kin koina na mesabana yagu tomoyao kubaguna-yagili siyawatagili Itipita koina.” ");
INSERT INTO tteo_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Na Mosese iwalo Yaubada koina, “Yau tomo bwagabwaga. Kani gubesi na yalau kin koina yo Isileli yabaguna-yagili siyawatagili Itipita koina?” ");
INSERT INTO tteo_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Kabo Yaubada kainana iyamaisa iwaloba, “Yau mekamkava, na tem saugana tomo kubaguna-yagili siyawatagili Itipita, kani kwatapwalolo koliyau koya bwaite koina, kabo sauganane koina ukwatai yawasosi yau yayawasao.” ");
INSERT INTO tteo_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Na Mosese iwaloba, “Saugana tem yalau Isileli kolili yo yawalo yaba, ‘Tubulao ali Yaubada iyawasayau yalaoma kolimiu’ kani sineli koliyau siba, ‘Na iya esana?’ Kani gubesi yagu walowalo kolili?” ");
INSERT INTO tteo_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Kabo Yaubada iwaloba, “Yau bwaite yau. Yau sauga meuloina nige yagu kaba mwawasi. Na kuwalo Isileli kolili kuwaloba, ‘Bwaine esane Yau bwaite yau iyawasayau kolimiu.’ ");
INSERT INTO tteo_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Kuwalo Isileli kolili yakato yau Yeoba, Abelamo, Aisake yo Yakobo ali Yaubada, yau yayawasao kolili. Esagu bwaite imiyayai, yaso yo yaso meuloili esagu kani sipei bwaite besiele. ");
INSERT INTO tteo_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Kulau yo kuwalolau Isileli ali tautaubalao simiya-gogo kabo kuwalolau kolili yakato yau Yeoba, tubuliyao ali Yaubada, yayawatagiliko koliwo. Kuyanuwapeili tabe yakato Itipita ali paisowa kolili yagitailiko. ");
INSERT INTO tteo_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Yawalo-yameliyako yakato kani yabaguna-yagili siyawatagili Itipita koina kaiwena bwaine koina Isileli kamkamna lalakina silobai, silau silusae yanuwa masumasulina mena yanuwa bwainene bodali Kenani, Iti, Amoli, Pelisi, Ivi yo Yebusi ali kaba miya mena. ");
INSERT INTO tteo_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Tautaubalaone am walo kani sibenalan. Kabo mekamkavao kwalau Itipita ali kin koina kwawaloba, ‘Yeoba, kai Ibeliu ama Yaubada, iyawatagiliko kolimai. Kabo sauga bwaite kutalamwagimai kalau kaliyate yaiyona dekawa bwagabwaga mena ule mena kapwaoli yo katapwalolo Yeoba ama Yaubada koina.’ ");
INSERT INTO tteo_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Kabo yakatai tem kin nige yayayadidiga kani nige itatalamwagimiu kwayawatagili yo kwalalau. ");
INSERT INTO tteo_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Mwa yagu kaiwe kani yayapaisowa na ginauli matamatausili mena Itipita yayamaisali. Kabo muli mena kin kani italamwagimiu na kwalau. ");
INSERT INTO tteo_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Yo yagu kaiwe kaiwena Itipita kani siyakasisi-yagimiu na saugana kwayawatagili nige sowasowana kwalau menimamiu. ");
INSERT INTO tteo_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Isileli sinesineoliyao kaigeda kaigeda kani silau Itipita kolili, siya simiyamiya salili mena yo siya mekalikavao simiya kaigeda, yo kwama yo galogalo gole yo siliba sikawanoi-yagili. Kabo muli mena komiu Isileli ginauli bwaite natumiyao kwayagaloili yo kamwasane koina Itipita ali wasawasa wakele-gogonagili yo kwalawagili.” ");
INSERT INTO tteo_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Muli mena Mosese iwalo Yeoba koina iwaloba, “Gubesi, temga Isileli yagu walo nige simumuliya yo nige sibebenalan? Tawae kani yaginauli tem siwaloma koliyau, ‘Yeoba nige iyayawatagili koliwo’?” ");
INSERT INTO tteo_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Kabo Yeoba ineli, “Tawae nimam mena?” Mosese iwaloba, “Ginaginamo iyaele nimagu mena.” ");
INSERT INTO tteo_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Yeoba iwaloba, “Ugwabaen bwatano mena.” Mosese igabaen, kabo ginaginane iyamala weso, yo Mosese isiliyata iutu-vivilama. ");
INSERT INTO tteo_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Kabo Yeoba iwalo Mosese koina, “Kupwalou-talu na ukwabilau uyawana mena ukweleisin.” Mwa Mosese ipwalou-talu yo ikabi-lobi uyawana mena ikabilau, kabo wesone iyamala ginagina yoi. ");
INSERT INTO tteo_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Yeoba iwaloba, “Uginauli besiele bwaite kabo Isileli kani sikawa-yawasosi yakato yau Yeoba, Abelamo, Aisake yo Yakobo ali Yaubada, yayawatagiliko koliwo.” ");
INSERT INTO tteo_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Yeoba iwaloyoi Mosese koina iwaloba, “Nimam kupei kam kwama kalona mena.” Mosese iginauli besiele na saugana nimana ikele-yavivila igitai ilepelo yo imayalesosi besiele polu. ");
INSERT INTO tteo_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Kabo Yeoba iwaloba, “Nimam kupeiyoi kam kwama kalona mena.” Iginauli besiele na saugana ikalai yoi, nimana inamwanamwa yoi besiele yona meuloina. ");
INSERT INTO tteo_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Yo Yeoba iwaloba, “Tem paisowa kaba nuwapwanopwano bagubagunana sigitai na nige am walo simemeliyan kabo kaba nuwapwanopwano labuina uginauli na sauganane koina sigitai kani am walo yakato yayawatagiliko koliwo sikawa-yawasosi-yan. ");
INSERT INTO tteo_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Tem paisowa kaba nuwapwanopwano labuine sigitaili, na nige am walo sikakawa-yawasosiyan yo am walo nige sibebenalan, kabo Naile wailana kulegu kusuwai bwatano mena kabo wailane kani iyamala kwasine.” ");
INSERT INTO tteo_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Na Mosese iwaloba, “Tabu, Yeoba, tabu kuyayawasayau. Yau nige toedeedede besi beyabeyana ilaoma kanasiga kabona bwagana kuwalo koliyau. Memenagu ipolowe yo yagu walo iyasayasanaloka yo iyoviyoviya.” ");
INSERT INTO tteo_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Kabo Yeoba iwaloba, “Yaiya tomo gamwana ipaisowai? Yaiya tomo tenana itabe-yakola yo kainana itabe-yakwalalele? Yaiya tomo manna itabe-yalala o tem itabe-yagibu? Yau yabomamo, Yeoba. ");
INSERT INTO tteo_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Saugamo kulau. Kani yasaguiwo na walo yayakenayagiwo yo kuwalowegili.” ");
INSERT INTO tteo_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Na Mosese iwaloba, “Taubala, tabu yau, na tomo uloina kuyawasa.” ");
INSERT INTO tteo_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Kabo Yeoba imunamunai Mosese koina yo iwaloba, “Gubesi, kamkava Eloni, susu Libai? Yakatai iya toedeedede yabo. Sauga bwaite kaiwem ilalaoma, kani igitaiwo yo iyaliyaya. ");
INSERT INTO tteo_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Sowasowana kuwalo-masala koina na tawae kuwalowen koina kani kaiwem iedeedede. Ee kabo yomiu labui yasaguimiu walo koina yo yawalo kolimiu tawae waginauli. ");
INSERT INTO tteo_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Iya am toedeedede kabo kaiwem iwalo tomo kolili. Kowa besiele yau Eloni manna mena kaiwena kuwalo koina tawae kani iwalowen. ");
INSERT INTO tteo_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ginagina bwaite kulokalai kabo koina paisowa kaba nuwapwanopwano kani uginaulili.” ");
INSERT INTO tteo_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Kabo Mosese ilau bwasiyana Yetolo koina, iwaloba, “Kutalamwagau na yavivila Itipita yagu bodao yagitaili gubesi ali miyamiya.” Yetolo italam kabo ikawa-kaiyoni koina. ");
INSERT INTO tteo_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Saugana Mosese iyaele Midiya, Yeoba iwalolau Mosese koina iba, “Kuvivila Itipita kaiwena siya tauna kona Itipita koina nuwanuwali yakato siunuiwowa meuloili siboitako.” ");
INSERT INTO tteo_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Mwa Mosese wainena yo natunao tatao ikalaili ipeili donki pwatana mena, mekanakavao silau Itipita. Mosese ginaginawa Yaubada iwawalowenwa ilokalai nimana mena. ");
INSERT INTO tteo_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Kabo Yeoba iwalolau Mosese koina, “Saugana kuvivila Itipita kunuwatu-kalatan paisowa kaba nuwapwanopwano meuloina bwaine yatalamwan koliwo uginaulili kin manna mena. Na kani kin katena yakabi-yakololo kabo nige itatalam yagu tomoyao silolowasi. ");
INSERT INTO tteo_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","23","Yo kuwalo kin koina, ‘Yeoba iwaloba, Isileli besiele natugu tobagubaguna tau kaiwena yagite-sipwaili yo yamuloloili. Yawalo koliwo, Isileli kutalamwagili silaoma sitapwalolo koliyau. Na tem nige kutatalamwagili silalaoma koliyau kani natum tobagubaguna tau yaunuyamate.’” ");
INSERT INTO tteo_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Kaba kaikaiyawasi yabo Itipita kana kamwasa koina, Yeoba iyawatagili Mosese koina yakato ikoyamate. ");
INSERT INTO tteo_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Na Sipola nabuka ikalai natuna tau yona isuna kwapina inigwe-gabaen yo ikalai iyapatu Mosese kaena mena, kabo sinene iwaloba, “Kabona bwaite nigwenigwe paisowanane yaginauli Gelisoma koina yo yayapatu kaem mena kana bui besiele kowa te yau tapatu yawasosi besiele kwasine kaigeda.” Mwa koina Yeoba Mosese nige ikokoyamate kaiwena wainena Sipola isaguiyako. ");
INSERT INTO tteo_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Sauganane koina Yeoba iwalo Eloni koina iba, “Kulau dekawa bwagabwaga mena ule mena na Mosese mekamkava kwaelobelobe.” Yo ilau Sainai Yaubada ana koya yakayakasisina koina. Saugana ilobai isapwali yo inisoi. ");
INSERT INTO tteo_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Kabo Mosese Eloni ana wasa iwolena tawae Yeoba iedeededeyan koina yakato iyawasa-yavivilali silau Itipita. Tabe besiele paisowa kaba nuwapwanopwano bwaine Yeoba iwalo kani iginaulili iwalo-masalagili Eloni koina. ");
INSERT INTO tteo_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mwa Mosese yo Eloni silau Itipita yo siwalo Isileli ali tautaubalao simiya-gogo. ");
INSERT INTO tteo_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Kabo Eloni iwalo-masalan kolili walo meuloina bwaine Yeoba iwalowen Mosese koina mwa Mosese paisowa kaba nuwapwanopwano meuloina iginaulili tautaubalaone manli mena. ");
INSERT INTO tteo_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Sigitai sikawa-yawasosi kabo saugana sibenalan yakato Yeoba ilaomako ali kamkamna igitai sitapwalolo yo sikawanoi. ");
INSERT INTO tteo_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Kabo Mosese yo Eloni silau Itipita ali kin koina siwaloba, “Yeoba, kai Isileli ama Yaubada iwaloba, ‘Yagu tomo kutalamwagili silau dekawa bwagabwaga mena ule mena na kekan yakayakasisina siginauli kaiwegu.’” ");
INSERT INTO tteo_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Mwa kin iwaloba, “Yeoba yaiya na tem kainana yabenalan kabo Isileli yatalamwagili silowasi? Yeoba nige yakakatai, koina Isileli nige sowasowana yatalamwagili silowasi.” ");
INSERT INTO tteo_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Kainana siyamaisa siwaloba, “Kai Ibeliu ama Yaubada iyawatagiliko kolimai. Kutalamwagimai kaliyate yaiyona kalau dekawa bwagabwaga mena ule mena ebaebai kakalai kapwaoli yo katapwalolo Yeoba ama Yaubada koina. Tem nigele, kani ikaleya kolimai yo kama kasiebwa ipei kabo kaboita.” ");
INSERT INTO tteo_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Kabo kin me ana munamunai iwaloba, “Gubesi yakato tomo ali paisowa kwasibayanae? Kwavivila ami kaba paisowa mena. ");
INSERT INTO tteo_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Komiu Isileli Itipita kwabaibaiwa-gabaegili.” Kabo kin imunamunai yo yona ikwatakwata iba, “Na bwaite sauga nuwanuwamiu ami paisowa kwalopei.” Kin Mosese yo Eloni imalimaliwagili silau. ");
INSERT INTO tteo_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","7","Kaliyatenane koina, kin loina kolokololona iwolena paisowa tanuwagana yo paisowa kana togite-kalatan kolili iwaloba, “Saugana lei leleyanna mekanakava bwatano siebweli sigabu iyamala biliki, tabu lei kwaolena yoi kolili. Kwawalo sibomamo lei siloyai. ");
INSERT INTO tteo_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Na kwawalo yoi biliki siginauli kali baibaiwa besiele baguna, tabu yabo ikukubwa. Ali paisowa nige ilalalaki, koina mwa kaiwena sikawanoi koliyau yakato yatalamwagili silau sipwaoli yo sitapwalolo ali yaubada koina. ");
INSERT INTO tteo_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ali paisowa kwaetulan yoi, tabu sikakaiyawasi na mesabana tabu Mosese ana walo mwakomwakota sibebenalagili.” ");
INSERT INTO tteo_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Kabo paisowa tanuwagana yo paisowa kana togite-kalatan silau siwalo Isileli kolili besiele, “Kin iwaloba, ‘Lei kani nige kaeyawa yoi. ");
INSERT INTO tteo_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Kwalau naga kwaboma lei kwaloyai na biliki waginaulili kali baibaiwa sitoyatoyawa besiele tauna kona.’” ");
INSERT INTO tteo_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Kabo Isileli Itipita kalona mena meuloina silotakikili lei loyaina kaiwena. ");
INSERT INTO tteo_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Paisowa tanuwagali siwalo-samasamalulu siwaloba, “Kaliyate kaigeda biliki waginaulili kali baibaiwa besiele tauna kona saugana lei kaeliwa kolimiu.” Na Isileli nige sowasowali kali liyene siginauli, ikololososi. ");
INSERT INTO tteo_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Mwa paisowa tanuwagaliyao paisowa kana togite-kalatanyao sisapili siwaloba, “Gubesi biliki nige kwapapaisowai kali baibaiwa besiele tauna kona?” Paisowa tanuwagali siya tomo Itipita. Paisowa kana togite-kalatan siya Isileli Itipita sigite-sipwaili na paisowa sigite-kalatan. ");
INSERT INTO tteo_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Kabo paisowa kana togite-kalatan silau kin koina siwaloba, “Tawae kaiwena uginauli kolimai besiele? ");
INSERT INTO tteo_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Lei nige siyeyelima kolimai, na siwalo biliki kaginaulili. Bwagana nige ama yauyaule na iyamo sisapi-bwagabwagaimai. Wenowenone iyaele kolimiu.” ");
INSERT INTO tteo_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Na kin kainali iyamaisa iwaloba, “Komiu yawasosi tookwatakwata, kaiwena genuwamiu paisowa. Mwa iya kaiwena kwalaoma koliyau na yakato yatalamwagimiu kwalau kwapwaoli yo kwatapwalolo ami yaubada koina. ");
INSERT INTO tteo_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Kwavivila ami kaba paisowa mena. Lei kani nige siyeyeliwa, na biliki kwapaisowaili kali baibaiwa besiele tauna kona.” ");
INSERT INTO tteo_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Paisowa kana togite-kalatanyao me ali nuwapolowe kaiwena kin iwalo, “Kaliyate kaigeda kaigeda biliki waginaulili kali baibaiwa besiele tauna kona.” Ali nuwapolowe yaina kaiwena nige sowasowali sipaisowa besiele tauna kona. ");
INSERT INTO tteo_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Sikaisulu kin silogabaen siutulau kabo Mosese yo Eloni silobaili kaiweli sisanasana. ");
INSERT INTO tteo_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Me ali munamunai siyokoi-yagili yo siwalo Mosese yo Eloni kolili, “Yeoba ami paisowa naenaena igitailiko yo kani iyamaisamiu kaiwena kin me kana tosaguwo kwaula-munamunaili kabo sikalomagigi-lagimai nuwanuwali siunuyamatemai.” ");
INSERT INTO tteo_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mulina mena Mosese iedeedede yoi Yeoba koina iwaloba, “Taubala, tawae kaiwena am tomoyao kuyakamkamnali? Tawae kaiwena kuyawasayau bwaite koina? ");
INSERT INTO tteo_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Yalau kin koina kainam yawalowen, na kin tomo Isileli iyakamkamnali. Yo tabe nige ginauli yabo ugiginauli na kusaguili.” ");
INSERT INTO tteo_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Kabo Yeoba Mosese kainana iyamaisa iba, “Sauga kikiunamo kani ugitai tawae yaginauli kin koina. Kani yayadidiga na komiu yagu tomoyao Isileli imalimaliwagimiu kwalowasi ana yanuwa mena.” ");
INSERT INTO tteo_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","3","Yo Yaubada iwalo Mosese koina iba, “Yau Yeoba yayawatagili Abelamo, Aisake yo Yakobo kolili kabo sikatai yau Yaubada Tomiyasaesosi. Yayawatagili kolili na esagu Yeoba, esa yakasisi, kana dudulai nige yayayamayale kolili. ");
INSERT INTO tteo_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Na beyabeyana yawaloyameli kolili yanuwa Kenani kani yaolegili ali yanuwa, yanuwa bwainene koina siya tauna kona simiya taumana. ");
INSERT INTO tteo_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Sauga bwaite yagu tomoyao Isileli ali kamkamna panpanna koina yagitai yo ali yaba yabenalan kaiwena Itipita Isileli siyakamkamnali kabo yagu waloyameliwa yanuwatu-kalatan. ");
INSERT INTO tteo_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Koinaele Isileli ali wasa kwaolena kwawalolau kolili, ‘Yau Yeoba kani yaleboimiu Itipita ali kalomagigili kana kamkamna yo kana polowe koina. Nimagu kaikaiwena kani yayagayan, maisa polopolowena yaolena kolili kabo yaleboimiu yo yalivasimiu. ");
INSERT INTO tteo_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Kani yayoganmiu komiu yagu tomoyao na komiu yau ami Yaubada, yo saugana yalivasimiu Itipita ali kalomagigili mena kani wakatai yawasosi yau Yeoba ami Yaubada. ");
INSERT INTO tteo_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Mulina mena kani yabaguna-yagimiu kwalau yanuwa bwaine yawalo-yameliyako Abelamo, Aisake yo Yakobo kolili, kabo yaeyawa yawasosi ami yanuwa. Yau Yeoba.’” ");
INSERT INTO tteo_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mosese iwalo besiele Isileli kolili, na iya kainana nige sibebenalan kaiwena yaluyaluwali ibelu ali kamkamna kaiwena. ");
INSERT INTO tteo_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","11","Kabo Yeoba iwalo Mosese koina, “Kulau kuwalo kin koina yakato Isileli italamwagili ana yanuwa silogabaen.” ");
INSERT INTO tteo_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Na Mosese ana nuwatu imwawasi kabo iba, “Isileli yagu walo nige sibebenalan. Na tawae kaiwena tem am nuwatu yalau Itipita ali kin koina na am walo yawalowen? Kani nige yagu walo ibebenalan. Tabe memenagu iyasayasanaloka.” ");
INSERT INTO tteo_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Kabo Yeoba iwalo kaiwe Mosese yo Eloni kolili, “Kwalau Itipita ali kin yo tomo Isileli kolili yo ali wasa kwaolena yakato yayawasamiu na mesabana Isileli kwabaguna-yagili Itipita kwalogabaen.” ");
INSERT INTO tteo_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Luben, Yakobo natuna tobagubaguna, natunao tatao yoli esopali, Anoke, Palu, Esilon yo Kami. ");
INSERT INTO tteo_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simion, Luben dagelana mena, natunao tatao yoli sikisi, Yemuela, Yamini, Onadi, Yakini, Sowa yo Sao, na Sao iya Kenani sinena natuna. ");
INSERT INTO tteo_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Libai, Simion dagelana mena, natunao tatao yoli yaiyona, Gelisoni, Koati yo Melali. Libai ana bolime 137. ");
INSERT INTO tteo_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Libai natuna tobagubaguna esana Gelisoni kabo Gelisoni natunao tatao yoli labui, Libini yo Simei. ");
INSERT INTO tteo_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Libai natuna toluwaluwali esana Koati kabo Koati natunao tatao yoli esopali, Amilami, Isa, Ebiloni yo Usiyeli. Koati ana bolime 133. ");
INSERT INTO tteo_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Libai natuna tomulimuliye esana Melali kabo Melali natunao tatao yoli labui, Mali yo Musi. ");
INSERT INTO tteo_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Libai tubuna tau esana Amilami, iya Koati natuna tobagubaguna, mekanakava tamana duna esana Yokebedi sikasole kabo Eloni yo Mosese sikabili. Amilami ana bolime 137. ");
INSERT INTO tteo_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Libai tubuna esana Isa, iya Koati natuna labuina, kabo Isa natunao tatao yoli yaiyona, Kola, Nepegi yo Sikili. ");
INSERT INTO tteo_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Libai tubuna esana Usiyeli, iya Koati natuna esopalina, kabo Usiyeli natunao tatao yoli yaiyona, Misaeli, Elisapani yo Sitili. ");
INSERT INTO tteo_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Eloni mekanakava Eliseba sikasole, Eliseba iya Nason duna yo tamali esana Aminadaba. Eloni yo Eliseba sikabi natuliyao Nadaba, Abiu, Eliyesa yo Idamali. ");
INSERT INTO tteo_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Na Koati tubuna esana Kola, iya Isa natuna tobagubaguna, kabo Kola natunao tatao yoli yaiyona, Asili, Elikana yo Akiyasapi. ");
INSERT INTO tteo_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Amilami tubuna esana Eliyesa, iya Eloni natuna yaiyonana kabo Eliyesa mekanakava Putiyeli natuna yabo sikasole kabo ikabi natuna Peniyasi. ");
INSERT INTO tteo_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Koinaele Eloni yo Mosese kali mumuga Libai. Na siya mwa yoli labuine Yeoba iwalo kolili, “Isileli susu meuloina kwabaguna-yagili Itipita silogabaen.” ");
INSERT INTO tteo_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Tabe siya yoli labuine mwa siwalo Itipita ali kin koina tomo Isileli ilivasili. ");
INSERT INTO tteo_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","29","Mosese iyaele Itipita kabo Yeoba iwalo koina iba, “Yau Yeoba. Walo meuloina bwaite yawalowen, kuwalowen Itipita ali kin koina.” ");
INSERT INTO tteo_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Na Mosese iwaloba, “Ukwatai yau nige toedeedede besi yo memenagu iyasayasanaloka. Gubesi na kin kainagu ibenalan?” ");
INSERT INTO tteo_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Kabo Yeoba iwaloba, “Kani yapeiwo kowa besiele yau Yaubada kin manna mena yo kamkava Eloni kani iedeedede kin koina besiele iya am palopita. ");
INSERT INTO tteo_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Walo meuloina tem kani yawalowen koliwo kowa kani kuyapanaisi Eloni koina yo Eloni kani iya iwalolau kin koina na Isileli italamwagili siyawatagili ana yanuwa mena. ");
INSERT INTO tteo_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","4","Na kin katena kani yakabi-yakololo kabo bwagana ginauli kaba nuwapwanopwano sibaibaiwa yaginaulili Itipita kalona mena, na iyamo kainam kani nige ibebenalan. Kabo kani nimagu yamou yayamanene yo maisa polopolowena yaolena Itipita kolili. ");
INSERT INTO tteo_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Na yagu tomoyao Isileli susu meuloili, kani yabaguna-yagili na siyawatagili. Sauganane koina kabo Itipita kani sikatai yakato yau Yeoba.” ");
INSERT INTO tteo_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Kabo Mosese yo Eloni siginauli besiele Yeoba ana walo. ");
INSERT INTO tteo_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Sauganane Mosese ana bolime eiti (80) yo Eloni ana bolime eiti tili (83) na silau siedeedede kin koina. ");
INSERT INTO tteo_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","9","Yeoba iwalo Mosese te Eloni kolili iba, “Tem kin iwaloba, ‘Paisowa kaba nuwapwanopwano yabo waginauli yagitai kabo ami walone mesabana yakawa-yawasosiyan’, ee kuwalo Eloni koina ana ginagina ikalai igabae-yatalu kin manna mena, kani iyamala weso.” ");
INSERT INTO tteo_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Kabo Mosese yo Eloni silau kin koina siginauli besiele Yeoba ana walo. Eloni ana ginagina igabae-yatalu kin yo kana tosaguwo manli mena yo iyamala weso. ");
INSERT INTO tteo_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Mwa kin ana tosonogao yo ana tokukulao iyoga-gogonagili na tem ali kukula koina sowasowali siginauli besiele. ");
INSERT INTO tteo_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ali ginaginao sigabae-yataluli kabo meuloili siyamala weso. Na Eloni ana weso siya tokukula meuloili ali wesoyao isinolili. ");
INSERT INTO tteo_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Na kin ana nuwatu nige ibubui, katena ikololososi kabo Mosese yo Eloni kainali nige ibebenalan, besiele Yeoba ana walo. ");
INSERT INTO tteo_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Kabo Yeoba iwalo Mosese koina iba, “Kin katena ikololososi, genuwana tomo Isileli italamwagili yo siyawatagili silowasi. ");
INSERT INTO tteo_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Koinaele kani malala mena kusanasana waila Naile papalina mena. Saugana kin ilolobi wailane koina kulau koina na kwaelobelobe. Ginaginawa tauna kona iyamala weso iya bwaimwa kulokalai. ");
INSERT INTO tteo_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Na saugana kwaelobelobe kuwalo koina, ‘Yeoba, kai Ibeliu ama Yaubada, iyawasayau koliwo, iwaloba, Yagu tomoyao kutalamwagili kabo sitapwalolo koliyau dekawa bwagabwaga mena ule mena. Nige naga yagu walo kubebenalan. ");
INSERT INTO tteo_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Paisowa bwaitete kani ugitai kabo ukwatai yau Yeoba. Ugitai. Ginagina bwaite yakalai kani yakoiyan waila mena kabo waila iyamala kwasine. ");
INSERT INTO tteo_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Iye kani siboita yo waila ibowa kabo Itipita nige sowasowali sinuma koina.’” ");
INSERT INTO tteo_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Yeoba iwaloyoi Mosese koina, “Kuwalo Eloni koina ana ginagina ikalai iyagayan Itipita kali waila meuloina kolili, yalubwasi yo waila bwaine sikeliutusi yo waila keli yo kabo waila meuloina kani siyamala kwasine, yo doga dedeiliyao kani sikwasine, waila patu sikwasine, gulewa bwasi wailana tabe sikwasine.” ");
INSERT INTO tteo_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Kabo Mosese yo Eloni siginauli besiele Yeoba ana walo. Muli mena, kin yo kana tosaguwo manli mena, Eloni ana ginagina ikeleisin ikoiyan waila mena kabo waila meuloili siyamala kwasine. ");
INSERT INTO tteo_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Iye meuloili waila mena siboita yo sibowa bwalailiyao sinae kabo Itipita nige sowasowali waila sinuma. Itipita kalona meuloina ikwasine. ");
INSERT INTO tteo_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Kabo kin ana tokukulao iyoga-gogonagilima kabo ali kukula koina siginauli besiele sitoyatoyawa. Kin ana tokukulao ali kukula koina igitai kabo katena ikololoyoi. Mwa kin Mosese yo Eloni kainali nige ibebenalan besiele Yeoba ana walo. ");
INSERT INTO tteo_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Yeoba ana paisowa kaba nuwa-pwanopwanone kin ikawa-mwakomwakotayan, itagelakeile yo ivivila ana nume mena, ginauline igitaine nige inunuwatu kaiwena. ");
INSERT INTO tteo_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","25","Itipita meuloili kali waila sikeli-loyaloyai waila Naile papalina mena kaiwena nige sowasowali Naile wailana sinuma. ");
INSERT INTO tteo_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Yeoba Naile wailana isibayanae, kaliyate seben simwawasi, kabo iwalolau Mosese koina iba, “Kulau naga kin koina kuwaloba, ‘Yeoba iwaloba, yagu tomoyao kutalamwagili silowasi na sitapwalolo koliyau. ");
INSERT INTO tteo_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Tem kunuwaili kani polowe yaboyoi yaeyawa, kwekwe Itipita siyakalapowon. ");
INSERT INTO tteo_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Tabe waila Naile kwekwe kani siyakalapowon yo tabe simwalisae am nume mena yo am biliutusi mena yo am kaba keno mena yo kam tosaguwo ali nume mena yo silau am kaba loliga mena yo kam gulewa kaloli mena. ");
INSERT INTO tteo_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Kani sikapusele koliwo, am tomoyao kolili yo kam tosagu meuloili kolili.’” ");
INSERT INTO tteo_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Kabo Yeoba iwalolau yoi Mosese koina, “Kuwalo Eloni koina ana ginagina iyagayan waila mena yo waila kelikeli-utusili yo waila keli kolili kabo kwekwe silusae Itipita ali yanuwa kalona meuloina siyakalapowon.” ");
INSERT INTO tteo_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Kabo Eloni ana ginagina iyagalawan waila meuloili kolili yo kwekwe siyawatagili yanuwa siloya-kalapowon. ");
INSERT INTO tteo_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Na tokukulao, ali kukula koina, siginauli besiele kabo kwekwe sietulan yo siyawatagili yoi yanuwa mena. ");
INSERT INTO tteo_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Mwa kin Mosese yo Eloni iyoganlima iwaloba, “Wakawanoi Yeoba koina kwekwe ikele-gabaegili na yau kani ami tomoyao yatalamwagili silau sitapwalolo yo ebaebai sipwaoli-yagili Yeoba koina.” ");
INSERT INTO tteo_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mosese iwaloba, “Sowasowana yakawanoi kaiwem. Kuwalo toisabo sauga na yakawanoi kaiwem, mekamkavao kam tosaguwo yo am tomoyao, kabo kwekwe simwawasi bwaimwanamo siya tupwaliyao simiyamiya waila Naile koina.” ");
INSERT INTO tteo_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Kin iwaloba, “Bwaligamo ukwawanoi.” Mosese iwaloba, “Kani yaginauli besiele am nuwatu kabo ukwatai nige Yaubada yaboyoi besiele Yeoba ama Yaubada. ");
INSERT INTO tteo_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Kabo kwekwe meuloili silogabae-gimiu, kowa me kam tosaguwo yo am tomoyao. Tabe besiele ami nume silogabaegili. Kwekwe kani simwawasi bwaimwanamo siya tupwaliyao simiyamiya waila Naile koina.” ");
INSERT INTO tteo_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Mosese yo Eloni siyawatagili silau kabo Mosese ikawanoi Yeoba koina kwekwe bwaine Itipita siyakalapowon ikele-gabaegili. ");
INSERT INTO tteo_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Yeoba iginauli besiele Mosese ana kawanoi kabo kwekwe siboita nume mena yo bubu mena yo kwabu mena. ");
INSERT INTO tteo_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Itipita kwekwe boiboitali sikuya-gogonli kabo bwalaina dedeina meuloina isibayanae. ");
INSERT INTO tteo_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Saugana kin igitai kwekwe simwawasi katena ikololoyoi kabo Mosese yo Eloni kainali nige ibebenalan, besiele Yeoba ana walo. ");
INSERT INTO tteo_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Yeoba iwaloyoi Mosese koina iba, “Kuwalo Eloni ana ginagina ikalai bwatano mena ikoiyan kabo Itipita dedeina meuloina bwatanona bogabogauna iyamala samwanigisi.” ");
INSERT INTO tteo_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Mwa Eloni ginagina ikalai bwatano isapi, Itipita bwatanona bogabogauna meuloina iyamala samwanigisi, kabo tomo yo ebaebai yoli meuloina siletaili. ");
INSERT INTO tteo_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","19","Tokukula ali kukula koina sitonan yakato tabe siya samwanigisi siyamayale besiele Yeoba ana kaiwe na iyamo nige sowasowali. Samwanigisi sibaibaiwa kabo tokukula siwalo kin koina, “Yaubada ana paisowa bwaite.” Na kin katena ikololo kabo Mosese yo Eloni kainali nige ibebenalan, besiele Yeoba ana walo. ");
INSERT INTO tteo_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Kabo Yeoba iwaloyoi Mosese koina iba, “Bwaliga malala dabwelo itunsae saugana kin ilalau waila mena kulau koina na kwaelobelobe kuwaloba, ‘Yeoba iwalo, yagu tomo kutalamwagili silaoma sitapwalolo koliyau. ");
INSERT INTO tteo_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Yayanuwapeiwo tem kunuwaili, kani nonowala yayawasa kolimiu na Itipita ali nume meuloili nonowala siyakalapowon kani bwatano sipwaiki yo besiele kowa me kam tosaguwo yo am tomoyao guliyam lalakina kwalobai. ");
INSERT INTO tteo_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Yagu tomo simiyamiya Gosen koina Itipita dedeina mena, kabo Gosen nige yasasapi yo nonowala nige sowana siyawatagili bwaine koina. Kani yaginauli besiele kabo ukwatai yau Yeoba yau elete am yanuwa mena. ");
INSERT INTO tteo_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Yagu tomoyao kani yapei-suwalagili am tomo Itipita kolili. Bwaligamo yakenayan bwaite kani iyawatagili.’” ");
INSERT INTO tteo_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Kabo Yeoba nonowala gwauna lalakina iyawasa kin ana nume wasawasa mena yo tabe kana tosaguwo ali nume mena. Nonowala kaiwena Itipita dedeina meuloina isibayanae yo tomo meuloili siguliyam. ");
INSERT INTO tteo_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Na kin Mosese yo Eloni iyoganli iwaloba, “Sowasowana ami Yaubada koina kwatapwalolo ebaebai kwapwaoli yanuwa bwaite Itipita koina.” ");
INSERT INTO tteo_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Mosese kainana iyamaisa iwaloba, “Kani nige sowasowamai kaginauli bwaite Itipita kalona mena. Kaiwena ama kaba pwaoline Yeoba ama Yaubada koina ebaebai, na komiu Itipita ami tapwalolo mumugana uloi. Tem na ebaebaine kapwaopwaolan Itipita manli mena, kani kaula-munamunaili yo veku mena sikoyamatemai. Iya kaiwena nuwanuwamai kalau kelamamalawe mena. ");
INSERT INTO tteo_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Nuwanuwamai kalau kaliyate yaiyona dekawa bwagabwaga mena ule mena katapwalolo ebaebai koina kapwaoli Yeoba ama Yaubada koina besiele ana walo kolimai.” ");
INSERT INTO tteo_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Na kin iwaloba, “Kwalau dekawa bwagabwaga mena ule mena kwatapwalolo Yeoba ami Yaubada koina yo ebaebai koina kwapwaoli, na tabu kwalolo-kelamamalawe. Ukawanoi kaiwegu na Yeoba yagu polowe ikelegabaen.” ");
INSERT INTO tteo_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Na Mosese iwaloba, “Sauga bwaite yalau na yakawanoi Yeoba koina bwaliga nonowala simwawasi molosi, kowa yo kam tosaguwo yo am tomoyao kolimiu. Na tabu kumwamwakota-yagimai yoi. Tabu tomo ukakausili na kutalamwagili silau sipwaoli Yeoba koina.” ");
INSERT INTO tteo_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","31","Mosese ilau ikawanoi Yeoba koina yo Yeoba ana kawanoi ibenalan, nonowala simwawasi molosi kin me kana tosaguwo yo ana tomoyao kolili, nige nonowala yaboyoi imiyamiya. ");
INSERT INTO tteo_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Na kin katena ikololo yoi kabo tomo nige itatalamwagili silolowasi. ");
INSERT INTO tteo_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Yeoba iwaloyoi Mosese koina iba, “Kulau kin koina kuwaloba, ‘Yeoba kai Ibeliu ama Yaubada iwaloba, Yagu tomoyao kutalamwagili silau sitapwalolo koliyau. ");
INSERT INTO tteo_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","3","Tem kusikote yoi na kunuwaili, kabo kani iyamaisa koliwo, am ebaebai meuloili kali kasiebwa naenaena ipei, am osi, donki, kameli, bulumakau, sipi yo gouti kolili. ");
INSERT INTO tteo_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Isileli ali ebaebai kani ipei-suwalagili, nige sowana yabo iboita.’ ");
INSERT INTO tteo_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Yeoba, kaliyatenane ipeiyako, bwaliga kani ipaisowai.” ");
INSERT INTO tteo_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Yanuwa ilayan kabo Yeoba iginauli besiele, Itipita ali ebaebai meuloili siboita, na Isileli ali ebaebai nige yabo iboboita. ");
INSERT INTO tteo_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Kin ana topaisowao iyawasali silau silobubu tawae iyawatagili na ana wasa siwolena yakato Isileli ali ebaebai kolili nige yabo iboboita. Na iya katena ikololo kabo tomo Isileli nige itatalamwagili silolowasi. ");
INSERT INTO tteo_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Kabo Yeoba iwaloyoi Mosese koina iba, “Kau wagagalo bosa mena yo kwalawan kin koina kabo kowa Mosese kuyasulu mwayaga mena na kin igitai. ");
INSERT INTO tteo_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Kabo kau bogabogauna kani iyui-gwaligwali Itipita kalona meuloina ipwaiki kabo baliyan kaposa situbu tomo yo ebaebai kwapili kolili yo sitamwalapan, kwapili isibayanae.” ");
INSERT INTO tteo_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Mwa Mosese yo Eloni kau sigagalo silawan kin koina, sitolo kin manna mena kabo Mosese iyasulu mwayaga mena, kin igitai kabo baliyan kaposa situbu tomo yo ebaebai kwapili kolili. ");
INSERT INTO tteo_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Baliyan kaposa kaiwena tokukula yoli sikamkamna yo simwalimwaline kabo nige sowasowali silaoma Mosese koina kaiwena silolo besiele Itipita meuloili. ");
INSERT INTO tteo_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Na Yeoba kin katena ikabi-yakololo yoi kabo Mosese yo Eloni kainali nige ibebenalan, besiele Yeoba ana walo. ");
INSERT INTO tteo_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Yeoba iwaloyoi Mosese koina iba, “Bwaliga malala kulau kin koina kuwaloba, ‘Yeoba kai Ibeliu ama Yaubada iwaloba, Yagu tomoyao kutalamwagili na silau sitapwalolo koliyau. ");
INSERT INTO tteo_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Sauga bwaite yagu yakenayan nige yakato kam tosaguwo yo am tomoyao sibomamo kaiweli, kowa besiele sowana yakenayan kulobai na ukwatai nige Yaubada yaboyoi besiele yau yanuwa yaulina mena. ");
INSERT INTO tteo_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Temga nimagu yayagayan kowa me am tomoyao yayakasiebwamiu, kani yaunu-olimiu, na nigele, nige yayapaisowai besiele. ");
INSERT INTO tteo_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Yatalam kwanamwanamwa kaiwena nuwanuwagu yagu kaiwe yayakenayagimiu kabo wasagu yanuwa yaulina meuloina ilaui. ");
INSERT INTO tteo_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Na iyamo me am nuwasae kabo yagu tomoyao kunuwaili yakato tabu silolowasi. ");
INSERT INTO tteo_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ee kabo bwaliga malala galewa lalakina kani italu, galewane nige sauga yabo besiele itatalu Itipita koina. ");
INSERT INTO tteo_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Kabo kuwalo ebaebai yo gogo meuloina siya simiyamiya mayale mena sipeili lolon mena. Ais pokopokoli kani sibeku kabo tomo yo ebaebai, siya nige lolon mena simiyamiya, siunuili.’” ");
INSERT INTO tteo_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Kin kana tosagu tupwali simatausi Yeoba ana walo kaiwena kabo siwalo ali topaisowa silusae lolon mena yo ali ebaebai sipei-luseyagili. ");
INSERT INTO tteo_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Na tupwali Yeoba ana walo nige sibebenalan kabo ali topaisowao yo ali ebaebai nige siyayabubu-wagili. ");
INSERT INTO tteo_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Kabo Yeoba iwalo Mosese koina iba, “Nimam kuyagaseyan bulibuli mena kabo ais pokopokoli sitalu Itipita kalona meuloina koina, tomo yo ebaebai yo tano kolili.” ");
INSERT INTO tteo_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","24","Yo Mosese ana ginagina iyagaseyan bulibuli mena na Yeoba tutu yo galewa iyawasa, pigabu bwatano iunui, ais pokopokoli besiele veku sitalu yo dedei meuloina ipigabu-takikilan. Galewane bwaite besiele nige sauga yabo itatalu Itipita koina. ");
INSERT INTO tteo_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ais pokopokoli ginauli meuloina mayale mena Itipita dedeina mena sisibayanaeli, tabe besiele tomo yo ebaebai. Tano siweweka meuloina yo mayau bubu mena silotagotagolu. ");
INSERT INTO tteo_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Galewa lalakina italu Itipita dedeina meuloili kolili na galewa nige itatalu Isileli ali kaba miya Gosen koina, bwaimwana iya tabe Itipita kalona mena. ");
INSERT INTO tteo_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Kabo kin Mosese yo Eloni iyoganli iba, “Walo yawasosi sauga bwaite yagu nae yagite-lobai. Yeoba ana walo idudulai na yau me yagu tomoyao kalopwano. ");
INSERT INTO tteo_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Wakawanoi Yeoba koina. Besi tutu yo ais pokopokoli. Yomai ikwatakwata. Yawaloyameli yatalamwagimiu kwalowasi, nige kwamimiya yoi bwaite koina.” ");
INSERT INTO tteo_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Kabo Mosese kainana iyamaisa iwaloba, “Saugamo bwaite yalogabaegimiu ami kaba miya mena bwaite koina yo yalau bwaine koina yo nimagu yakeleisinagili na yakawanoi Yeoba koina. Saugana yaginauli kabo tutu imwanou, galewa imasa yo ais pokopokoli simwawasi kabo ukwatai yanuwa yaulina Yeoba ana gogo. ");
INSERT INTO tteo_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Na iyamo yakataiyako kowa me kam tosaguwo nige naga Yeoba Yaubada kwamamatausan.” ");
INSERT INTO tteo_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Mayau esana palakes, kana koleya besiele imo, iya koina kaleko siginauli yo kan esana bali galewa isibayanaeli kaiwena bali imatuwako yo palakes kabo ilalala. ");
INSERT INTO tteo_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Na witi galewa nige isisibayanae kaiwena nige naga kana sauga imamatuwa. ");
INSERT INTO tteo_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mosese kin ana nume ikaisulu-gabaen, iutu-yawatagili tupwana kabo nimana ikeleisinagili ikawanoi Yeoba koina, kabo tutu imwanou yo galewa imasa yo ais pokopokoli simwawasi. ");
INSERT INTO tteo_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Kin igitai tawae iyawatagili na iyamo ilopwano yoi. Iya me kana tosaguwo kateli siyakololo. ");
INSERT INTO tteo_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Mwa kin Isileli nige itatalamwagili besiele tauna kona Yeoba iwalo kin koina Mosese gamwana mena. ");
INSERT INTO tteo_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Yo Yeoba iwalo Mosese koina iba, “Kulau naga kin ugitai yoi. Iya me kana tosaguwo kateli kani yakabi-yakololoyoili kaiwena nuwanuwagu kaba nuwapwanopwano bwaite yaginaulili kolili, ");
INSERT INTO tteo_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","na mesabana sauga mulina mena kani komiu Isileli kwaedeedede natumiyao yo tubumiyao kolili kaba nuwapwanopwano bwaine kani yaginaulili yo Itipita yakaiwe-gabaegili siyamala kaba talatalawasi na meuloimiu wakatai yakato yau Yeoba.” ");
INSERT INTO tteo_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Kabo Mosese yo Eloni silau kin koina siwaloba, “Yeoba, kai Ibeliu ama Yaubada iwaloba, ‘Am sikote ilaulau. Toisabo sauga koina nuwam ibiga, katem kutalamwan koliyau na yagu loina kumuliya? Yagu tomo kutalamwagili silowasi na sitapwalolo koliyau. ");
INSERT INTO tteo_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Tem kunuwaiyoili, bwaligamo kani yawalo mwalimwali baibaiwali silaoma am yanuwa mena. ");
INSERT INTO tteo_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Kani sibaibaiwasosi yo bwatano sipwaiki. Ginauli meuloina ais pokopokoli nige sisisibayanaeli mwalimwali kani sikanli, mayau siya simiyamiya yo liguliyao tabe kani sikanli. ");
INSERT INTO tteo_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Am nume, kam tosagu meuloili yo Itipita meuloili ali nume siyakalapowon. Nige sauga yabo tubumiyao sigigitai besiele.’” Mosese iginauli besiele Yeoba ana walo mwa ilau kin koina yo walone bwaite iwalowen kabo iutu-keile yo ivivilayoi. ");
INSERT INTO tteo_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Kin kana tosaguwo siwalo kin koina, “Meisa tomo bwaite kala nae iyeyama kolila? Isileli kutalamwagili silau sitapwalolo Yeoba ali yaubada koina. Tabu ugigite-lobai bwaite, Itipita isibayanae yo iguliyam?” ");
INSERT INTO tteo_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Kabo siwalo Mosese yo Eloni sivivila kin koina. Sivivila kabo kin iwalo kolili iba, “Kwalau, kwatapwalolo Yeoba ami Yaubada koina. Na analiyao kani silalau?” ");
INSERT INTO tteo_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mosese iwaloba, “Meuloimai, tatao yo sinesineo, kani kalowasi mekamakavao natumayao yo ama tobelu, melumeluwo yo ama ebaebai sipi, gouti yo bulumakau kakalaili kaiwena nuwanuwamai kekan lalakina kaginauli Yeoba kana yakasisi kaiwena.” ");
INSERT INTO tteo_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Na kin me ana munamunai iwaloba, “Nigele molosi. Nige sowana sinesineo yo melumeluwo yatalamwagili silau. Walo yawasosi yakatai nuwanuwamiu yagu loina kwalikwai yo yanuwa bwaite kwayabubu-gabaen. ");
INSERT INTO tteo_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Nigele. Besi na tataomo silau sitapwalolo Yeoba koina, besiele ami kawanoi.” Kabo kin kana tosaguwo Mosese yo Eloni simalimali-wagili. ");
INSERT INTO tteo_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Yo Yeoba iwalo Mosese koina iba, “Nimam kuyagalawan Itipita koina kabo mwalimwali silaoma, ginauli kinkinli siya ais pokopokoli nige sisisibayanaeli kani sikanli.” ");
INSERT INTO tteo_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Yo Mosese ana ginagina iyagalawan Itipita koina kabo Yeoba iwalo yaumai bolibolime mena ilotalotalu kaliyate yo boniyai. Yanuwa ilayan malala kabo mwalimwali siyawatagili. ");
INSERT INTO tteo_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Baibaiwali silaoma, yanuwa siyakalapowon kali baibaiwane nige sauga yabo iyayawatagili besiele, yo tabe kani nige sauga yabo iyayawatagili yoi. ");
INSERT INTO tteo_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Kabo yanuwa sipwaiki yo siula-boniboniyai. Mayau kikinli siya nige ais pokopokoli sisisibayanaeli meuloili sikan-wolili. Mayau kanli yo kawasi, liguliyao kalakalawali, meuloili siyemwawasili. ");
INSERT INTO tteo_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Kabo mwayamwayau kin Mosese yo Eloni iyoganli iwalo kolili iwaloba, “Yalopwano Yeoba ami Yaubada koina, besiele tabe yalopwano kolimiu. ");
INSERT INTO tteo_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Yagu pwanoli bwaite kwanuwatu-pwaiki yoi na wakawanoi Yeoba ami Yaubada koina maisa naenaena bwaite ikele-gabaen.” ");
INSERT INTO tteo_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","19","Mwa Mosese kin ilogabaen ilau yo ikawanoi Yeoba koina, kabo Yeoba bolibolime ibui iyuikeile ilau yalasi mena yalasi kaikaiwena itowa kabo mwalimwali iyui-sinagili yo iyui-kalaili silau Kalita Balabalagiyana koina, nige mwalimwali yaboyoi imiyamiya Itipita. ");
INSERT INTO tteo_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Na Yeoba kin katena ikabi-yakololo yoi kabo Isileli nige itatalamwagili silalau. ");
INSERT INTO tteo_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Kabo Yeoba iwalo Mosese koina iba, “Nimam kuyagaseyan bulibuli mena kabo boniboniyai Itipita meuloina iula-boniboniyai, tomo sikabikabi-lalaka.” ");
INSERT INTO tteo_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Mosese nimana iyagaseyan bulibuli mena yo kaliyate yaiyona Itipita meuloina iboniboniyai molosi. ");
INSERT INTO tteo_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Itipita nige sowasowali kalikavao mekalikavao siegitegite-yagili yo tomo meuloili simiyamiya ali nume mena, nige tomo yabo ana nume ilologabaen. Na Isileli ali kaba miya imayale. ");
INSERT INTO tteo_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Kabo kin Mosese iyogan iwaloba, “Kwalau kwatapwalolo Yeoba koina, mekamikavao sinesineo yo melumeluwo. Na ami sipi, gouti yo bulumakau simiyamiya.” ");
INSERT INTO tteo_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Kabo Mosese iwaloba, “Na tem nige me ama ebaebai yo kalau menima-bwagabwagamai, na kani gubesi pwaoli ama gabugabuna Yeoba koina? ");
INSERT INTO tteo_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Nigele. Tem kalolowasi, me ama ebaebai, nige yabo imimiya. Bulumakau meuloili kayoganili yo kayawatagili kabo bwaine koina kakatai toisabo ebaebai kabo kapwaoli koina.” ");
INSERT INTO tteo_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Yeoba kin katena ikabi-yakololo yoi kabo kin Isileli iwalo-nuwaili tabu silalau. ");
INSERT INTO tteo_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Yo iwalo Mosese koina, “Kulowasi molosi. Tabu yagigitaiyoiwo. Tem toisabo kaliyate koina yagitaiwo kani kuboita.” ");
INSERT INTO tteo_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mosese kaina iyamaisa iwaloba, “Inamwanamwa, kani nige ugigitaiyau yoi.” ");
INSERT INTO tteo_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Yo Yeoba iwalo Mosese koina iba, “Polowe kaigedamo kani yayawasa Itipita ali kin me ana tomoyao kolili. Kabo mulina mena italamwagimiu kwalowasi. Kani meuloimiu imalimaliwagimiu dedei bwaite koina. ");
INSERT INTO tteo_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Bwaite saugamo kulau Isileli kolili kuwalolau yo kuwaloba, ‘Meuloimiu kwalau Itipita kolili siya simiyamiya salimiu mena, kali galogalo gole yo siliba wakawanoi-yagili.’” ");
INSERT INTO tteo_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Yo Yeoba Isileli isaguili kabo Itipita Isileli ali kawanoine sikawa-namwanamwa-yagili kaiwena Yeoba nuwatune ipeiyako kateli mena. Besiele Mosese esana ilalaki Itipita koina, kin kana tosaguwo yo ana tomoyao meuloili manli mena. ");
INSERT INTO tteo_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","5","Mosese me ana katepatu ilauyoi kin koina yo iwaloba, “Yeoba iwaloba, ‘Boniyai luwaluwalina koina kani Itipita dedeina yalotakikilan, yo Itipita melumeluwo tobagubaguna tatao meuloili kani siboita. Iyatubu kin natuna, iya yakato naga iyamala kin, koina kanasiga topaisowa pegapega kana togili natuliyao kolili. Yo tabe bulumakau meuloili natuliyao tobagubaguna kani siboita. ");
INSERT INTO tteo_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Itipita kalona meuloina valam yo koyasili lalakina kani iyawatagili, valamne nige sauga yabo bwaite besiele iyayawatagili yo tabe kani nige iyayawatagili yoi. ");
INSERT INTO tteo_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Na Isileli kolili nigele, nige polowe kikiuna yabo kani iyayawatagili kolili, nige miya-kalekaleya yabo, nige besiele bwauwa sikwatukwatu tomo o tem ebaebai kolili. Kabo ukwatai yau Yeoba Isileli yapei-suwalagili kolimiu Itipita.’” ");
INSERT INTO tteo_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Mosese iwaloyoi iba, “Kam tosaguwo meuloili kani silaoma tutulili sitalu-sakonayagili koliyau yo sikawanoi koliyau yakato yau yo Isileli meuloili kalowasi. Ee kabo muli mena kani kalowasi.” Mosese me ana munamunai ana walo iyemwawasi kabo kin ilogabaen. ");
INSERT INTO tteo_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","10","Na tauna kona Yeoba iwalolau Mosese koina yakato kin Mosese kainana kani nige ibebenalan na mesabana ginauli kaba nuwapwanopwano sibaibaiwa iginauli Itipita dedeina mena. Bwaine besiele ginauli meuloina iyawatagili. Mosese yo Eloni ginauli kaba nuwa-pwanopwanone meuloili siginaulili kin manna mena, na Yeoba kin katena ikabi-yakololo kabo kin nige itatalamwagili silolowasi. ");
INSERT INTO tteo_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","2","Sauganane Mosese yo Eloni simiyamiya Itipita koina mwa Yeoba iwalolau kolili iba, “Waikena bwaitete komiu Isileli kwapei bolime kana waikena bagubagunana na ami kalenda waluwaluna itubu. ");
INSERT INTO tteo_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Kali loina kwaolena boda Isileli kolili yakato waikena bwaite kana kaliyate sanaulu koina, tomo kaigeda kaigeda sipi natuna o tem gouti natuna sigite-sipwai ana nume tomiya kaiweli. ");
INSERT INTO tteo_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Tem tomo yabo ana nume kana tomiya nige sibabaibaiwa yo nige sowasowali sipine meuloina sikan, kabo mekalikavao ali elieliyamwao siya salili mena mekalikavao sikekan toyawa. Wagolulauya tomo kali baibaiwa koina yo tem sowasowana tomo kaigeda kaigeda ikekan. ");
INSERT INTO tteo_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Sipi o tem gouti natuna wagite-sipwai tauna ana bolime kaigeda, yona sapusapuna, nige wenoweno o baliyan yabo koina. ");
INSERT INTO tteo_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Kabo waikena kana kaliyate potinna (14) koina dabwelo isugu lolaunane koina boda Isileli meuloili sipine kani siunuili. ");
INSERT INTO tteo_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Kabo muli mena kwasinena tupwana sikalai yo sisau numene kana gamwa pwatana mena yo kana mayau dedei labui kolili. ");
INSERT INTO tteo_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Boniyainane koina sipi wagabu kabo bulumana wakan mekanakava kalita malumaluluna bwaine sitanoi mayau kolili yo pwalawa nige kana ebwelimo yisti koina. ");
INSERT INTO tteo_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Tabu kilaina o tem ligaligana wakakan. Meuloina mekanakava kulukuluna, kaena yo malisina wagabuli simaisa namwanamwa kabo wakan. ");
INSERT INTO tteo_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Tem tupwa imiyamiya mwayamwayau meuloina wagabaen mayau wedowedolina mena iwedoli. Tabu tupwa yabo kwapepei-suwalan malala kaiwena. ");
INSERT INTO tteo_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Tabe wakatububu lowasi kaiwena. Yomiu wakatububu-nagili, kaekaemiu kali suma kwapeili, ami sige nimamiu mena tabe wakekan mwayamwayau. Mwalelikwa soina bwaite yau Yeoba kaiwegu. ");
INSERT INTO tteo_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Boniyainane koina Itipita dedeina meuloina kani yalotakikilan tomo yo ebaebai tobagubaguna tatao yaunuili na yaubadaone siya Itipita kolili sitapwatapwalolo esali kani yapei-yataluli. Yau Yeoba. ");
INSERT INTO tteo_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Kwasinene gamwa kana mayau koina iya ami nume kana kilakilala. Saugana Itipita yayamaisali kani kwasinene yagitai kabo yamwalelikwaimiu yo kani nige kwaboboita. ");
INSERT INTO tteo_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Soi bwaitete waginauli kaliyatenane koina kabo yau Yeoba kwanuwatu-kalatagau tawae yaginauli. Yaso yo yaso soi bwaitete waginauli-kalatan.” ");
INSERT INTO tteo_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Yeoba iwaloba, “Kaliyate seben kaiwena tabu pwalawa me yistina siebweli wakakan. Kaliyate bagubagunana koina, yisti meuloina wagabaegili ami nume mena kaiwena kaliyate bagubagunana kanasiga kaliyate sebenna tem tomo yabo pwalawa me yistina ikan, iya nige yagu tomo besi, kani yatom-gabaen koliyau. ");
INSERT INTO tteo_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Soi kana kaliyate bagubagunana yo tabe kana kaliyate mwawamwawasina (seben) kwalogogo kwatapwalolo. Kaliyate bwainene kolili tabu paisowa yabo wagiginauli. Na sowasowana kamiumo kwaloliga. ");
INSERT INTO tteo_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Soi bwaitete waginauli-kalatan kaiwena kaliyate bwaite koina meuloimiu kani yabaguna-yagimiu kwayawatagili Itipita kwalogabaen. Yaso yo yaso silalaoma mwalelikwa kanna waginauli kaliyate bwaite koina. ");
INSERT INTO tteo_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Kabo waikena bagubagunana kana kaliyate potin (14) lolauna kanasiga kaliyate tuwenti wan lolauna, pwalawa me yistina siebweli kwayakasisi-yan. ");
INSERT INTO tteo_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","Kaliyate sebenne kaloli mena nige sowana yisti imiyamiya ami nume mena. Tem tomo yabo, nuwana nume tanuwagana o nuwana taumana, pwalawa me yistina siebweli ikalai ikan, iya nige yagu tomo besi, kani yatom-gabaen koliyau.” ");
INSERT INTO tteo_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Isileli ali tautaubalao Mosese iyoganli kabo iwalolau kolili iwaloba, “Tomo kaigeda kaigeda sipi natuna, o tem gouti natuna, wagite-sipwai, wakoyamate me natumiyao wakekan mwalelikwa kana nuwatu-kalatan kaiwena. ");
INSERT INTO tteo_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Na sipine kwasineline kwasuwai gaeba yabo koina, kabo isopi lagalagana wakalai kwayabuta kwasinene koina na ami nume kana gamwa pwatana mena kwasau yo tabe dedei labui kolili. Tabu yabo nume mena ikakaisulu yauli mena kanasiga malala. ");
INSERT INTO tteo_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Yeoba kani ilotakikili Itipita iunuili yo saugana kwasine igitai gamwa pwatana mena yo tabe dedei labui kolili, kani iwalo-kausi boita kana anelose koina tabu ilulusae ami nume mena iunuimiu. ");
INSERT INTO tteo_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Loinane bwaite meuloiline kwanuwatu-kalatagili kwamuliya mekamikavao natumiyao sauga meuloina. ");
INSERT INTO tteo_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Naga muli mena saugana kwalusae Kenani, yanuwa bwainene Yeoba iwaloyameliyako kolimiu, waginauli besiele. ");
INSERT INTO tteo_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","27","Tem sauga muli mena natumiyao sineli, ‘Soi bwaite yaina gubesi?’ Kainali kwayamaisa kwawaloba, ‘Mwalelikwa soina bwaite Yeoba tanuwatu-kalatan kaiwena Itipita koina Isileli ala nume iutu-likwaili yo Itipita iunuili na kita ileboila’.” Mosese ana walo iyemwawasi kabo Isileli ali tautaubalao tutuliliyao sitalu-sakonayagili yo sitapwalolo Yeoba koina. ");
INSERT INTO tteo_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Yo silau siginauli besiele Yeoba ana walo Mosese yo Eloni kolili. ");
INSERT INTO tteo_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Boniyai luwaluwalina mena, Itipita tomoliyao natuliyao tatao tobagubaguna meuloili Yeoba iunuili, iyatubuya kin natuna koina, iya yakato naga kani iyamala kin, ilobi kanasiga tobubutuma molosi natuliyao kolili. Kaba gite bwaite tobubutumane siya simiyamiya nume boniboniyaina bwatano kalona mena. Tabe bulumakau natuliyao tobagubaguna siboitayoi. ");
INSERT INTO tteo_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Boniyainane koina kin yo kana tosaguwo yo Itipita meuloili sikenokeno kabo sisiliyata kaiwena valam yo koyasili lalakina sibenalan Itipita kalona mena kaiwena nume kaigeda kaigeda koina boitamo meuloina. ");
INSERT INTO tteo_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Boniyainane koina kin Mosese yo Eloni iyoganli kabo iwalolau kolili, “Kwalowasi, mekamikavao Isileli. Yagu yanuwa kwalogabaen, kwalau kwatapwalolo Yeoba koina, besiele ami nuwatu. ");
INSERT INTO tteo_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ami sipi, gouti yo bulumakau wakalaili yo kwalau. Tabe wakawanoiyoi kaiwegu yagu nuwanae kaiwena yo Yaubada ana nuwa-namwanamwa ilaoma koliyau.” ");
INSERT INTO tteo_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Yo Itipita meuloili nuwanuwali lalakina Isileli silowasi, siwaloba, “Mwayamwayau kwalau, tem komiu bwaite koina kwamiyamiya yoi kani kaboitaoli.” ");
INSERT INTO tteo_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Pwalawa siyabutayako, na nige yisti sipepei kabo sisuwai kaba gabugabu kana gulewa kolili, kaleko koina sisumali, yo sikalaili sikewaili leyaleyali mena silawagili. ");
INSERT INTO tteo_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Tauna kona Isileli siginauli besiele Mosese ana walo, na galogalo gole yo siliba yo kaleko sikawanoi-yagili Itipita kolili. ");
INSERT INTO tteo_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Kaiwena Yeoba Itipita katekamkamna iwolegili kabo ginauliliyaone siwolegili Isileli kolili besiele ali kawanoi. Yo kamwasane bwaite besiele Isileli Itipita ali wasawasa sikele-gogo-nagili yo silowasi-yagili. ");
INSERT INTO tteo_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Na saugana Isileli siyatubu Itipita dedeina silogabaen taon yabo esana Lamesese siloutusi yo kaeli mena silau Sakot. Tatao kali baibaiwa besiele sikisi andeledi tausan (600,000), sinesineo yo melumeluwo nige siyayasilili. ");
INSERT INTO tteo_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Tabe tomo uloili sibaibaiwa mekalikavao Isileli silowasi. Isileli ali sipi, gouti yo bulumakau sibaibaiwa siyoganili mekalikavao siyawatagili. ");
INSERT INTO tteo_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Pwalawa bwaine sikatububu-nanako ali nume mena Itipita koina nige yisti sipepei, sikalaiyama yo sigabu kamwasa mena. Itipita ali kin imalimaliwagili yo itawoili silowasi kabo ali totoya koina nige kali kanale sikakatububunagili ali lau kaiwena. ");
INSERT INTO tteo_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Isileli simiyamiya Itipita koina bolime powa andeledi yo teti (430). ");
INSERT INTO tteo_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Kaliyate bwainene powa andeledi yo teti bolime ana kaba mwawasi, Yeoba ana tomoyao ali susu meuloili siyawatagili Itipita koina. ");
INSERT INTO tteo_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Boniyainane koina Yeoba isilawaili yo ibagunayagili siyawatagili Itipita koina, kabo bolime kaigeda kaigeda kana nuwatu kalatan sisilasilawa boniyainane koina. ");
INSERT INTO tteo_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Mwa Yeoba iwalolau Mosese yo Eloni kolili iba, “Mwalelikwa soina kana loina bwaite besiele. Toganamuli mwalelikwa soina koina tabu yabo ikekekan. ");
INSERT INTO tteo_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Na iya panpanna kwayamaisayako sowasowana ikekan tem kilakilala nigwenigwe waginauliyako yona mena. ");
INSERT INTO tteo_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Tem topaisowa yabo iya tomiya taumana yo mane ikalakalai ana paisowa kaiwena, iya nige sowasowana ikekan. ");
INSERT INTO tteo_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Saugana tem ami tololigao ebaebaine sinigwai tabu tuwatuwana yabo sitatabe-golu. Mwalelikwa soina kanna wakanwoli-mowoi ami nume mena na tabu kantele yabo kwalalawan nume yabo koina. ");
INSERT INTO tteo_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Boda Isileli meuloina soi bwaite kani siginauli-kalatan. ");
INSERT INTO tteo_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Toganamuli siya simiyamiya kolimiu tem yabo nuwanuwana soi Yeoba kana yakasisi kaiwena ilusae, baguna sowasowana tatao meuloili ana nume mena nigwenigwe sikalai kabo iya besiele Isileli yawasosi yo ilusae soine koina. Na siya nige kilakilala nigwenigwe yoli mena tabu sikekekan. ");
INSERT INTO tteo_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Kabo Isileli yawasosi yo tomiya ganamuli simiyamiya kolimiu kami loinane kaigedamo.” ");
INSERT INTO tteo_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Kabo Isileli meuloili siobigai yo siginauli besiele Yeoba ana walo Mosese yo Eloni kolili. ");
INSERT INTO tteo_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Kaliyate bwaine koina Yeoba susu Isileli ibagunayagili siyawatagili Itipita koina. ");
INSERT INTO tteo_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","2","Kabo Yeoba iwalo Mosese koina iba, “Tobagubaguna tatao meuloili kwayakasisi-yagili koliyau kaiwena komiu Isileli kami tobagubaguna yo ami ebaebai tobagubaguna meuloili yau yagu gogo yo kaiwegu.” ");
INSERT INTO tteo_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mosese iwalo tomo kolili iba, “Kaliyate bwaite kwanuwatu-kalatan, kaiwena kaliyate bwaite koina ami kaba kamkamna yanuwana kwalogabaen. Kaliyate bwaite koina Yeoba ana kaiwe mena ikalaimiu kwayawatagili. Kabo pwalawa me yistina siebweli kwayakasisi-yan. ");
INSERT INTO tteo_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Kaliyate bwaite kwalowasi waikena bagubagunana esana Abib kalona mena. ");
INSERT INTO tteo_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Yeoba iwaloyameli tubumiyao kolili yakato Kenani, Iti, Amoli, Ivi, yo Yebusi ali yanuwa kani iyeyawa kolimiu. Saugana ibaguna-yagimiu kwalusae yanuwa masumasulina koina, yisti kana yakasisi soinane waginauli bolime kaigeda kaigeda kana waikena bagubagunana koina. ");
INSERT INTO tteo_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","7","Pwalawa nige me yistina siebweli koina wakekakekan kaliyate seben. Kabo kaliyate mwawamwawasina koina kwasoi Yeoba kaiwena. Tabu yistimo o yisti me pwalawana ami yanuwa mena imiyamiya kaliyate sebenne kalona mena, pwalawa bwagabwaga koina wakekan. ");
INSERT INTO tteo_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Sauga muli mena soi kana sauga koina kani kwawalo natumiyao kolili, ‘Taginauli besiele kaiwena Yeoba tanuwatu-kalatan tawae iginauli kaiwela saugana tayawatagili Itipita koina.’ ");
INSERT INTO tteo_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Na tem ginauli yabo nuwanuwamiu kwanuwatu-kalatan mumugamiu bwaite besiele, kilakilala yabo kwapei nimamiu mena o nuwana lamwamiu mena, mumugane ilaomaya tubumiyao kolili. Mwa soi bwaite ami kaba nuwatu-kalatan besiele kilakilala yabo. Iyanuwatu-kalatagimiu yo Yeoba ana loina kwayawasa kaiwena Yeoba ana kaiwe mena ikalaimiu kwayawatagilima Itipita koina. ");
INSERT INTO tteo_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Bolime kaigeda kaigeda soi bwaite waginauli-kalatan kana sauga yawasosi koina.” ");
INSERT INTO tteo_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","13","“Yeoba kani ibaguna-yagimiu kwalusae Kenani ali yanuwa mena kaiwena iwaloyameliyako kolimiu yo tubumiyao kolili. Saugana iyeyawa kolimiu, kabo tobagubaguna tatao meuloili kwatalamwagili Yeoba koina. Natumiyao tobagubaguna meuloili kani nige kwapwapwaoli-yagili na kwayamiyalaeli sipi natuliyao kolili. Kamwasane koina natumiyao tobagubaguna kwayamaisa-yavivilayoili. Besiele ebaebai kali tobagubaguna tatao meuloili kwatalamwagili yo kwapwaoli-yagili Yeoba koina kaiwena siya tabe Yeoba ana gogo. Na donki natuna tobagubaguna kwayamiyalae sipi natuna koina. Tem nige nuwanuwamiu waginauli besiele donki natunane galokomna wakopwai. ");
INSERT INTO tteo_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Sauga muli mena tem natumiyao sineli siba, ‘Mwa mumuga bwaite yaina gubesi?’ Kwawaloba, ‘Bwaite ala kaba nuwatu-kalatan Yeoba ana kaiwe mena ikalaila tayawatagilima ala kamkamna yanuwana koina. ");
INSERT INTO tteo_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Itipita ali kin katena ikololo iyakasisi-yagila yakato tabu talolowasi kabo Yeoba Itipita tomo yo ebaebai kali tobagubaguna meuloili iunuili siboita. Bwaite kaiwena ebaebai kali tobagubaguna tatao meuloili taolena Yeoba koina yo natulao tobagubaguna tayamaisa-yavivilali. ");
INSERT INTO tteo_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Mumuga bwaite ala kaba nuwatu-kalatan besiele kilakilala tapei nimala mena o nuwana lamwala mena. Iyanuwatu-kalatagila Yeoba ana kaiwe mena ikalaila tayawatagilima Itipita koina.’” ");
INSERT INTO tteo_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Saugana Itipita ali kin tomo italamwagili silowasi, Yaubada nige ibabagunayagili silolo-utusi kamwasa kubwakubwana mena kaiwena kamwasane bwaine kali tokalomagigili tomo Pilistiya ali dedei. Yaubada iwaloba, “Kisi tomo Isileli bwaite sauga kaleya silobai kabo ali nuwatu sibuiyoi yo sivivila Itipita.” ");
INSERT INTO tteo_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Na Yaubada iyoganli sitakikili dekawa bwagabwaga mena ule mena Kalita Balabalagiyana kana kamwasa koina. Tomo Isileli Itipita dedeina silogabaen yo ali kaba kaleya sikatububu-nonowaili. ");
INSERT INTO tteo_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mosese Yosepa tuwatuwana ikalaili kaiwena tauna kona Yosepa iwalo tubunao kolili iwaloba, “Sauga muli mena kani Yaubada ileboimiu kabo tuwatuwagu wakalaili mekamikava saugana yanuwane bwaite Itipita kwalogabaen.” ");
INSERT INTO tteo_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Boda Isileli Sakot silogabaen na sigogoya Etama ule dekawa bwagabwaga salina mena. ");
INSERT INTO tteo_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Kaliyate koina Yeoba ibagunayagili yaloyaloi malamalawena mayamayalena koina na kamwasa iyakenayagili. Na boniyai koina ibagunayagili mayau mayalena koina. Kabo sowasowali kaliyate yo boniyai silaulau. ");
INSERT INTO tteo_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Sauga meuloina kaliyate koina yaloyaloine itotolo tomo manli mena, besiele boniyai mayaune itotolo tomo manli mena. ");
INSERT INTO tteo_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","2","Kabo Yeoba iwalo Mosese koina iba, “Kuwalo Isileli kolili, ‘Kwavivilayoi wagogo dedei Pialilota koina, bwaimwa Migadoli yo Kalita Balabalagiyana luwaluwalili mena, Balisepona salina mena. ");
INSERT INTO tteo_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Kaiwena kin Pelo kani inuwatui yakato Isileli me ali nuwapwanopwano silolo-bwagabwaga yo dekawa bwagabwaga ali kamwasa ikausi. ");
INSERT INTO tteo_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Koinaele katena kani yakabi-yakololo kabo iyamuli-kusulimiu, na kin mekanakavao ana tokaleyayao kani yakaiwe-gabaegili na wasagu idebalala mesabana Itipita sikatai yau Yeoba.’” Kabo Isileli siginauli besiele yo sivivila Pialilota. ");
INSERT INTO tteo_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Saugana Itipita ali kin ibenalan yakato Isileli siyawatagiliko, mekanakavao kana tosaguwo ali nuwatu sibui, siwaloba, “Gubesi, tawae taginauli? Isileli tatalamwagili silowasiko, na kani nige sipapaisowa yoi kaiwela.” ");
INSERT INTO tteo_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Kabo kin ana waga niuniuli yo ana tokaleyayao ikatububunagili. ");
INSERT INTO tteo_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Waga niuniuli sikisi andeledi (600) namwanamwali, yo Itipita ana waga niuniuli meuloili mekalikavao kali togite-kalatan ikalaili. ");
INSERT INTO tteo_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Yeoba kin katena ikabi-yakololo kabo kinne Isileli iyamuli-kusulili. Na Isileli me ali katepatu silowasiko. ");
INSERT INTO tteo_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Itipita tokaleyayao me ali osi yo me ali waga niuniuliwo yo kali togite-kalatanwo Isileli siyamuli-kusulili kabo sigitaili sigogo simiyamiya Kalita Balabalagiyana papalina mena. ");
INSERT INTO tteo_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Isileli sigitaili kin mekanakavao ana tokaleyayao sisagesagenama dagelali mena, kabo kateli siwakaka yo simatausi yo siyoga Yeoba koina sagu kaiwena. ");
INSERT INTO tteo_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Yo Mosese siyokoiyan yo siwalolau koina siba, “Yauyaule kowa. Gubesi, am nuwatu kubatoko nige salai Itipita koina kabo ukwalaimai kalaoma dekawa bwagabwaga mena ule mena kaboita? Gubesi mwa manimai kuwoyai Itipita koina kayawatagilima? ");
INSERT INTO tteo_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Iyaele kalobaiyako besiele tauna kona kawaloko Itipita koina, kawalo koliwo kupeimai na kapaisowa Itipita kolili. Walo yawasosi ali yapaisowamai ipolowe. Na tem kaboita dekawa bwagabwaga mena ule mena bwaite inaesosi. Genuwamai.” ");
INSERT INTO tteo_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Kabo Mosese iwaloba, “Tabu kwamamatausagili. Kwatolo kaiwe na wagitai tawae Yeoba kani iginauli na ileboimiu kaliyate kabona. Tomo Itipita wagitagitailine kani nige wagigitaiyoili. ");
INSERT INTO tteo_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Kwamwanou, Yeoba kani ikaleya kaiwemiu.” ");
INSERT INTO tteo_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Kabo Yeoba iwalo Mosese koina, “Tawae kaiwena kwayogayoga koliyau sagu kaiwena? Kuwalo Isileli kolili bwai silaumo. ");
INSERT INTO tteo_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Am sige ukwalai yo kuyagalawan kalita mena na kalita itaigali na tomo silopanaisi bwatano labwalabwana mena silau dedei yabo mena. ");
INSERT INTO tteo_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","18","Na yau, Itipita kateli kani yakabi-yakolololi na komiu Isileli siyamuli-kusulimiu, yo kin mekanakavao ana tokaleyayao, ana waga niuniuli yo kali togite-kalatan kani yakaiwe-gabaegili na wasagu idebalala mesabana Itipita meuloili sikatai yau Yeoba.” ");
INSERT INTO tteo_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","20","Yo Yaubada ana anelose iya imiyamiya boda Isileli manli mena, mekanakava yaloyaloine siutu-vivila dagelali mena yo simiyamiya Itipita yo Isileli luwaluwalili mena. Yaloyaloine Itipita tomo iula-boniboniyaili, kabo iboniboniyai meuloina nige sowasowali Isileli bodane sigitaili yo nige sowasowali silau salili mena. ");
INSERT INTO tteo_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mosese nimana iyagalawan kalita mena kabo Yeoba iwalo bolibolime kaikaiwena ilotalu. Boniyai meuloina yaumaine ilotalotalu kabo kalita ikoigali iguma ilabwalabwa, ");
INSERT INTO tteo_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","kabo Isileli silopanaisi bwatano labwalabwana koina, dedei labui kalita itolo besiele salibebe. ");
INSERT INTO tteo_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Itipita mekalikavao ali osi yo waga niuniuli meuloili yo kali togite-kalatan Isileli siyamuli-kusulili. ");
INSERT INTO tteo_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Malala boniboniyaina, Yeoba iyaele imiyamiya yaloyaloi yo mayau kaloli mena kabo manna ilobi Itipita kolili yo nuwali iula-pwanopwano. ");
INSERT INTO tteo_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ali waga niuniuli kaekaeli sitalusopu kabo ali lau iyoviya. Itipita siwaloba, “Yeoba Isileli isagusaguili iya ali tokaleya yo ikalekaleya kolila, tavivilayoi.” ");
INSERT INTO tteo_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Kabo Yeoba iwalo Mosese koina iba, “Nimam kuyagalawan kalita mena na kalita iguli-vivila Itipita tokaleyayao mekalikavao ali waga niuniuli yo kali togite-kalatan iguli-pwaikili.” ");
INSERT INTO tteo_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mosese nimana iyagalawan kalita mena kabo yanuwa ilayan dabwelo itunsae yo kalita ilau ipatuyoi. Itipita tokaleyayao nuwanuwali siyabubu na nige sowasowali kaiwena Yeoba iyagalomwasiliko kalita mena. ");
INSERT INTO tteo_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Kalita ipatuyoi kabo waga niuniuli yo kali togite-kalatan, Itipita ali tokaleya meuloili sisalili kalita ipwaikili, nige yabo imimiya, meuloili siboita. ");
INSERT INTO tteo_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Na Isileli silopanaisiko bwatano labwalabwana koina. ");
INSERT INTO tteo_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Bwaine kaliyatene koina Yeoba Isileli ileboili Itipita kolili na Isileli Itipita boiboitali sigitaili busu galagala kimwana mena. ");
INSERT INTO tteo_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Isileli Yeoba ana kaiwe sigitai Itipita ikaiwe-gabaegili kabo Yeoba simatausan, simeli koina yo ana topaisowa Mosese tabe koina. ");
INSERT INTO tteo_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Kabo Mosese mekanakavao Isileli wali bwaite siwaliyan Yeoba koina. “Yawali Yeoba koina kaiwena ikaiwesosi mwa ibaguna. Waga niuniuli me osili mekalikavao kali togite-kalatan igabaegili kalita mena. ");
INSERT INTO tteo_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yeoba yagu tokaiwe, iya ileboyau, yagu Yaubada iya yatobalan, Tamagu ana Yaubada, iya ana wasawasa kani yawaliyan. ");
INSERT INTO tteo_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yaubada iya ala tokaleya, ikaleya kaiwela yo esana Yeoba. ");
INSERT INTO tteo_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Itipita ali kin ana tokaleyayao yo ali waga niuniuli igabaegili kalita mena, kana tobagunao namwanamwali sisalili Kalita Balabalagiyana koina. ");
INSERT INTO tteo_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Kalita iguli-pwaikili, besiele veku sisalili dumwakali mena. ");
INSERT INTO tteo_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Yeoba nima ulaulam ana kaiwe ilalaki, Yeoba nima ulaulam tokalomagigili isapi-gwaligwalili. ");
INSERT INTO tteo_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Am kaiwe kaiwena kam tokalomagigili ukaiwe-gabaegili, am munamunai ana wedowedoli besiele mayau wedowedolina mwa ikalaoli. ");
INSERT INTO tteo_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Isum mena kuyui kabo kalita iyui-gogon, isese besiele salibebe yo kalita gun molosina ikololo besiele masimasi. ");
INSERT INTO tteo_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Kama tokalomagigili siwaloba, ‘Mulili mena kani talau na takabi-kalatagili, ali wasawasa tayauyan na toisabo nuwanuwala takalai na toisabo tasikotanan. Tabe ala kaleya kelepana mena tomo Isileli taunuili.’ ");
INSERT INTO tteo_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Yeoba, mekaigedamo kuyui, kabo kalita Itipita ipwaikili, sisalili kalita matamatausina koina besiele veku polopolowena. ");
INSERT INTO tteo_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Yeoba, nige yaubada yabo imiyamiya besiele kowa. Nige yabo kana yakasisi besiele kowa. Nige yabo sowasowana ginauli kaba nuwapwanopwano yo ginauli kaba matamatausi iginaulili besiele kowa. ");
INSERT INTO tteo_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ulaulam kuyagayan kabo kalita itaigali yo kama tokalomagigiliwo sisalili sikwalalele. ");
INSERT INTO tteo_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Kuleboimaiko kabo kani kubaguna-yagimai kaiwena kumuloloimai, am kaiwe koina kani kubaguna-yagimai kalau yanuwa bwaine yakayakasisina koina kowa yo kai tamiyamiya. ");
INSERT INTO tteo_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Boda uloi uloi wasa kani sibenalan, kabo simatausi sitabubu, yo Pilistiya bodane besiele me ali matausi lalakina. ");
INSERT INTO tteo_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Idoma ali tobagunao tabe kani kateli siwakaka, Mowabe tokaiwe sitabutabubu, Kenani tomonliyao yoli sisawosawowoli. ");
INSERT INTO tteo_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Matausi yo katewakaka kani sikalapowon. Yeoba, am kaiwe kani sigitai yo simiya-mwanou kanasiga kalogabaegili, kaiwena kai am tomoyao kuleboimai. ");
INSERT INTO tteo_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Yo kani kuyoganmai yo kupeimai am koya mena. Yeoba, yanuwane ugite-sipwaiyako am kaba miya, dedei yakayakasisina bwaine kuboma uginauli. ");
INSERT INTO tteo_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yeoba, kowa am kaba loina imiyayai, nige ana kaba mwawasi.” ");
INSERT INTO tteo_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","21","Muli mena Miliyama iya palopita yo tabe iya Eloni duna, ana kaba seloselo gogona besiele labwa ikalai kabo sinesineo meuloili ibagunayagili siseloselo me ali labwa. Miliyama iwali bwaite besiele iwaloba, “Tawali Yeoba koina kaiwena ikaiwesosi mwa ibaguna. Waga niuniuli me osili me kali togite-kalatan igabaegili kalita mena.” Iwali besiele kaiwena Isileli kalita silopanaisi bwatano labwalabwana koina, na Itipita ali waga niuniuli me osili yo kali togite-kalatan sigalomwasi kalita mena, yo Yeoba kalita iyaguli-yavivilayoili kabo iguli-pwaikili. ");
INSERT INTO tteo_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Kabo Mosese Isileli ibagunayagili Kalita Balabalagiyana silogabaen silau dekawa bwagabwaga ule mena Sela koina. Kaliyate yaiyona kolili silolokeikeile ule mena na nige waila yabo silolobai. ");
INSERT INTO tteo_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Yo siyawatagili yanuwa yabo esana Mala koina, na wailanane imalulu nige sowasowali sinuma. Iya kaiwena esana sipei Mala. ");
INSERT INTO tteo_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Mosese sikuwaliyan yo sinelilau koina siba, “Gubesi waila bwaite imalulu yo inae, na kani kanuma?” ");
INSERT INTO tteo_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mwa Mosese ikawanoi samasamalulu Yeoba koina kabo Yeoba mayau yabo lagalagana tomna tupwatupwana iyakenayan ikenokeno dekawa mena. Mosese ikabi-talu ikalai yo igabae-lobiyen waila mena kabo wailawa kamnana inamwanamwa yo sowasowali sinuma. Yanuwa bwaine koina, Yeoba kali loina iwolena yo itonagili, ");
INSERT INTO tteo_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","iwaloba, “Tem na kainagu kwabenali-namwanamwai yo yagu nuwatu kwamuliya yo yagu loina meuloina kwabenalagili kani ginauline naenaeliwa tauna kona yaolegili Itipita kolili nige sowana yabo yaeyawa kolimiu. Yau Yeoba, kami tolebo.” ");
INSERT INTO tteo_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Muli mena silau Ilima, waila tuwelo sibunubunuwasi yo niu yai sebenti sitotolo, bwaine koina sigogo wailane papalili mena. ");
INSERT INTO tteo_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Boda Isileli meuloina Ilima silogabaen kabo muli mena siyawatagili yanuwa esana Sini dekawa bwagabwaga, Ilima yo Sainai luwaluwalili mena. Kaliyate piptinna (15) waikena labuina koina siyawatagili Sini. ");
INSERT INTO tteo_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Isileli meuloili siyaelemo ule mena kabo Mosese yo Eloni siyokoi-yagili yo sikuwalili, ");
INSERT INTO tteo_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","siwaloba, “Tem tauna kona Yeoba iunuimai Itipita koina inamwanamwa. Bwaine koina gwaba ilalaki yo kan nige sowasowamai kakan-wolili. Na kowa ukwalaimai kalaoma ule bwaite koina kabo meuloimai kani kaboita guliyam kaiwena.” ");
INSERT INTO tteo_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Yo Yeoba iwalo Mosese koina iba, “Sauga bwaitete koina bulibuli mena kan kani yasuwai ilobiwa meuloimiu kaiwemiu. Kaliyate kaigeda kaigeda tomo kani siyawatagili na kanne sitano-gogonagili kaliyate kaigeda kaiwena na yatonagili yagitai tem yagu loina simuliya o nigele. ");
INSERT INTO tteo_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Yo wiki kaigeda kaigeda koina kaliyate sikisi koina kani kan kaliyate labui kaiweli sikalai.” ");
INSERT INTO tteo_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","8","Kabo Mosese yo Eloni siwalo Isileli meuloili kolili besiele siwaloba, “Boniyai bwaitete Yeoba kami gwaba kani iyeyawa kabo wakatai yakato Yeoba iya mwa ikalaimiu kwayawatagilima Itipita koina. Tabe malala mena kan lalakina kani iyeyawa kabo saugana wagitai Yeoba ana wasawasa wakilala. Na kani iginauli besiele kaiwena ibenalagimiuko wakuwakuwali iya koina. Walo yawasosi Yeoba iya mwa wakuwakuwaline, nige kai kolimai wakukuwali kaiwena kai ana topaisowamo.” ");
INSERT INTO tteo_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mosese iwalo Eloni koina iba, “Kuwalo boda Isileli kolili silaoma sitolo Yeoba manna mena kaiwena ali kuwali ibenalanako.” ");
INSERT INTO tteo_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Saugana Eloni iedeedede boda Isileli kolili, kabo boda simiya-dagedagela-yan manli ilau ule mena na Yeoba ana wasawasa mayalena iyawatagili yaloyaloi mena. ");
INSERT INTO tteo_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","12","Yo Yeoba iwalo Mosese koina iba, “Isileli ali kuwali yabenalanako. Kuwalolau kolili dabwelo saugana isugu kali gwaba kani silobai sikekan yo tabe bwaliga malala kan lalakina kani silobai yoi na nuwali simayale yakato yau Yeoba ami Yaubada.” ");
INSERT INTO tteo_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Lolaunane koina dabwelo isugu gwaba man besiele daki yawoina sieva-yawatagili ali kaba miya siyakalapowon, kolili tomo sikekan. Kabo yanuwa ilayan malala mena sigitai wabumali ibeku ali kaba miya ipwaiki. ");
INSERT INTO tteo_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Saugana wabumaline ilabwalabwa, ginauli yabo imiyamiya bwatano pwatana mena kayakayagena yo pokopokona, bwatano ipwaiki besiele ais pokopokona. ");
INSERT INTO tteo_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Isileli sigitai kabo kalikavao sineli-yagili, “Tawae bwaite?” Kaiwena nige sikakatai tawae bwaine. Mosese iwalolau kolili iba, “Kanwa Yeoba iwalowalowenwa iya bwaimwa. ");
INSERT INTO tteo_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Yeoba ana loina besiele bwaite, kamiu wakalai kami liye mena sowasowamiumo. Ami nume kana tomiya tomo kaigeda kaigeda komwa eit (8) wakalaili.” ");
INSERT INTO tteo_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Isileli siginauli besiele, tupwali sikalai ilalaki tupwali sikalai ikikiu ali boda kana lau koina. ");
INSERT INTO tteo_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Saugana siliye, tomo kaigeda kaigeda ikalai kana liye sowasowana. Siya sikele-yalalaki nige tupwa ipapagan yo siya sikele-yakikiu silobai sowasowalimo, kaiwena ali boda kana lau koina. ");
INSERT INTO tteo_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mosese iwalo kolili iba, “Tabu yabo kwapepei bwaliga kaiwena.” ");
INSERT INTO tteo_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Na tomo tupwaliyao Mosese ana walo nige sibebenalan tupwana sikanpei. Yanuwa ilayan iwesoweso yo ibowa mwa Mosese imunamunai kolili. ");
INSERT INTO tteo_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Malala kaigeda kaigeda tomo kaigeda kaigeda ikalai kana liye sowasowana. Dabwelo ikaiwe kabo tupwana nige sikakalai iwelo. ");
INSERT INTO tteo_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Kaliyate sikisi koina kaliyate labui kana liye sikalai, tomo kaigeda kaigeda komwa sikistin (16). Mulina mena saugana boda ali tautaubalao silaoma ali paisowa siwalo-masalan Mosese koina, ");
INSERT INTO tteo_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","kabo Mosese kainali iyamaisa iwalolau kolili iwaloba, “Yeoba ana loina bwaite besiele, ‘Bwaliga kaliyate kaiyawasi yabo, yakayakasisina Yeoba koina. Kaliyate bwaite tupwana kwaloliga na tupwa imiyamiya kwapei bwaliga kaiwena.’” ");
INSERT INTO tteo_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Kabo tupwa sipei malala kaiwena besiele Mosese ana walo. Nige iwewesoweso yo nige ibobowa. ");
INSERT INTO tteo_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mosese iwaloba, “Kaliyate bwaite kan bwaitete wakan kaiwena kaliyate bwaite kaliyate kaiyawasi, yakayakasisina Yeoba koina. Kani nige kan yabo kwalolobai kaba logogo salina mena. ");
INSERT INTO tteo_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Komiu wakalai kaliyate sikisi koina, na kaliyate sebenna koina, kaliyate kaiyawasi, nige mana yaboyoi.” ");
INSERT INTO tteo_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Kaliyate sebenna koina tomo tupwaliyao Yeoba ana loina silikwai yo silau yakato kali sikalai, mwa nige yabo silolobai. ");
INSERT INTO tteo_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Kabo Yeoba Mosese iyokoiyan, iwalolau koina iba, “Toisabo sauga kabo yagu loina kwamuliya yo yagu walo kwabenalan? ");
INSERT INTO tteo_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Kwanuwatu-kalatan yau Yeoba kaliyate kaiyawasi yaeyawa yo sauga meuloina kaliyate sikisi koina kamiu yaeyawa kaliyate labui kaiwena mwa sowasowamiu. Kaliyate sebenna koina tomo kaigeda kaigeda imiyamiya ana kaba miya mena, tabu yabo ilolowasi.” ");
INSERT INTO tteo_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Kabo kaliyate sebenna koina tomo sikaiyawasi. ");
INSERT INTO tteo_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Isileli kanne esana sipei mana, kana koleya besiele patu kikiuna yabo mayamayalena yo kamnana besiele besikete kamwakamwa mekanakava siebweli. ");
INSERT INTO tteo_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mosese iwaloba, “Yeoba ana loina bwaite besiele, ‘Mana tupwana kwapeipei yaso muli mena silalaoma kaiweli mesabana sigitai kan bwaitete yaeyawa dekawa bwagabwaga ule mena.’” ");
INSERT INTO tteo_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Kabo Mosese iwalo Eloni koina iba, “Mana komwa eit (8) kuleguli yo kutauli gulewabwasi kalona mena kabo kupei Yeoba manna mena yaso mulimuliyali kaiweli.” ");
INSERT INTO tteo_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Eloni manane itauli kelabilabin kamwasana kana dedewaga kalona mena besiele Yeoba ana walo Mosese koina. ");
INSERT INTO tteo_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Isileli mana koina sikekan bolime poti dekawa bwagabwaga ule mena kanasiga siyawatagili yanuwa Kenani. ");
INSERT INTO tteo_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Ibeliu ali kaba liyeliye beyabeyana esana ‘oma’. Bwaimwana kana lalaki komwa eit (8). ");
INSERT INTO tteo_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Boda Isileli meuloina Sini silogabaen, silolo-kaikaiyawasi kanasiga tem Yeoba iwaloyoi kabo silau. Sigogo Lepidima, na nige kali waila. ");
INSERT INTO tteo_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Kabo Mosese sikuwali yo siwaloba, “Waila kuyeyama kanuma.” Mosese iwaloba, “Gubesi kwasamasamalului yau? Tawae kaiwena Yeoba kwatonatonan?” ");
INSERT INTO tteo_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Na tomo waila galogaloli simagu molosi kabo Mosese siyokoiyan siba, “Tawae kaiwena ukwalaimai kayawatagilima Itipita koina? Kani mekamakavao natumayao yo ama ebaebai kaboita galomagu kaiwena.” ");
INSERT INTO tteo_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Kabo Mosese ikawanoi samasamalulu Yeoba koina iwaloba, “Kani gubesi yagu pagapagan? Masa kikiunamo tomo bwaite veku mena siunuiyau.” ");
INSERT INTO tteo_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Kabo Yeoba iwalo Mosese koina iba, “Mekamkavao Isileli ali tautaubalao tupwali kuyoganli kwabaguna Sainai koina. Na am ginaginawa tauna kona waila Naile koina kusapisapiwa kulokalai yoi. ");
INSERT INTO tteo_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Kani yatolo manim mena veku yabo pwatana mena koya Sainai koina. Vekune kusapi kabo waila kani ididi-yawatagilima na tomo sinuma.” Yo ginauli meuloina Yeoba iwalowen koina Mosese iginauli besiele Isileli ali tautaubalao manli mena sigitai ginauli kaba nuwapwanopwano kaiwena waila ididi-yawatagilima veku mena. Kabo muli mena tomo meuloili silaoma na wailane koina sinuma. ");
INSERT INTO tteo_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Yanuwa esana sipei ‘Masa yo Meliba’ kaiwena Isileli sikuwakuwali yo Yeoba sitonan yo sinelineliyan siwaloba, “Yeoba mekalakava o nigele?” ");
INSERT INTO tteo_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Boda Amaleki silaoma na yakato Isileli mekalikavao sikaleya Lepidima koina. ");
INSERT INTO tteo_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Kabo Mosese iwalo kana tosagu Yosuwa koina iba, “Tatao tupwali ugite-sipwaili na bwaliga kuyoganli mekamkavao kwalau Amaleki mekamikavao wakaleya. Na yau kani yatoloya koya mena yo Yeoba Yaubada ana ginagina yakabi-kalatan nimagu mena.” ");
INSERT INTO tteo_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Mwa Yosuwa iginauli besiele Mosese ana walo kabo me ana tokaleyayao silau mekalikavao Amaleki sikaleya. Mosese mekanakavao Eloni yo Uli sisae koya mena. ");
INSERT INTO tteo_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Saugana tem Mosese nimana ikeleisinan Isileli sikaiwe na saugana tem nimana sisawosawowoli yo ipei-yataluli silolobine bwaimwa koina Amaleki sikaiwe. ");
INSERT INTO tteo_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mwa Mosese nimana sisawosawowoli kabo veku sikalaiyama koina imiyasio na Eloni yo Uli sitotolo salina mena nimana sikeleisinagili yo sikabi-kalakalatagili kanasiga dabwelo isugu. ");
INSERT INTO tteo_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Kabo Yosuwa me ana tokaleyayao Amaleki tokaleyayao kaleya kelepana koina siunuyamateli. ");
INSERT INTO tteo_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Yo Yeoba iwalo Mosese koina iba, “Amaleki tokaleyayaowa kwaunuyamateliwa edeededena kulele-yatalu ami kaba nuwatu-kalatan na kuwalowen Yosuwa koina na ibenalan. Kaiwena yau naga Amaleki kani yaemwawasi-yawasosili, nige tupwa yabo kani imimiya yanuwa yaulina mena.” ");
INSERT INTO tteo_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mwa Mosese veku italin-isae yo ebaebai ipwaoliyan Yeoba koina kabo kaba pwaoline esana ipei, “Yeoba kagu tobaguna.” ");
INSERT INTO tteo_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Iwaloba, “Yeoba iya tobagunayagila. Yaso yo yaso Yeoba mekanakavao Amaleki kani sikaleya.” ");
INSERT INTO tteo_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Na Mosese bwasiyana esana Yetolo. Iya Midiya ali kokotomo kana topwaoli kana tobaguna, wasa ibenalan ginauli meuloina Yaubada iginaulili ana tomoyao Isileli yo Mosese kaiweli saugana siyawatagilima Itipita koina. ");
INSERT INTO tteo_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","4","Saugana Mosese mewainena Sipola yo natuliyao simiyamiya Itipita koina kabo Mosese iyawasali sipileyoi tamana Yetolo yanuwa Midiya koina na igite-kalatagili. Mosese natuna bagubagunana esana ipei Gelisoma kaiwena saugana ikabi Mosese iwaloba, “Yanuwa wenala mena yamiya-taumana.” Natuna labuina esana ipei Eliesa kaiwena ana kabi koina Mosese iwaloba, “Tamagu ana Yaubada isaguiyau kabo Itipita ali kin nige iuunuiyau.” ");
INSERT INTO tteo_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yo Yetolo mekanakava Mosese wainena yo natunao labui silaoma Mosese koina dekawa bwagabwaga ule mena saugana sigogo Sainai koya yakayakasisina koina. ");
INSERT INTO tteo_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Wasa iyawasa-bagunayanako Mosese koina iwaloba, “Yau, bwasiyam mekaukavao wainem yo natumwao labui kalalaowa.” ");
INSERT INTO tteo_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Kabo Mosese itolo ilau yo me bwasiyana sielobelobe kabo ipwalou koina yo inisoi. Siyesapwasapwali-yagili kabo silusae Mosese ana kaba miya mena. ");
INSERT INTO tteo_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mosese iwalo-masala Yetolo koina ginauli meuloina tawae Yeoba iginauli kin mekanakavao Itipita tomonliyao kolili kabo Isileli ileboili. Iwalo-masala yoi polowe bwainene silobai kamwasa mena yo Yeoba gubesi ana sagusaguili. ");
INSERT INTO tteo_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Kabo Yetolo wasa meuloina ibenalan mwa me ana yaliyaya. ");
INSERT INTO tteo_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Iwaloba, “Yeoba tatobalan kaiwena ileboimiu kin yo Itipita tomonliyao kolili. Yeoba tatobalan kaiwena ana tomoyao ileboimiu ami kamkamna koina. ");
INSERT INTO tteo_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Kabo bwaite sauga yakatai yakato Yeoba yaubadao meuloili ilalaki-gabaegili kaiwena saugana Itipita me ali nuwasaesae komiu Isileli siyakamkamnamiu kabo Yeoba ileboimiu.” ");
INSERT INTO tteo_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Mwa Yetolo ebaebai tupwali ikalailima ana mulolo Yaubada koina, sigabuli kabo Eloni yo Isileli ali tautaubalao meuloili silogogoma mekalikava Yetolo kan yakayakasisina sikekan Yeoba kana nuwatu-kalatan kaiwena. ");
INSERT INTO tteo_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Yanuwa ilayan kabo Mosese tomo iyatalayagili malala mena kanasiga iboniyai. ");
INSERT INTO tteo_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Saugana Yetolo Mosese ana paisowa meuloina igitai ineliyan, “Tawae kaiwena ginauli meuloina bwaitete uginaginauli tomo kaiweli? Tomo sibaibaiwa simiyamiya malala mena kanasiga iboniyai sisanasana yatala kaiwena na kowa kubomamo ali yatala kupaipaisowai.” ");
INSERT INTO tteo_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mosese bwasiyana ana walo iyamaisa iwaloba, “Yaginauli besiele kaiwena tomo silalaoma koliyau nuwanuwali sikatai Yaubada ana nuwatu. ");
INSERT INTO tteo_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Saugana tem tomo labui sigamwapakiki silaoma koliyau yayatala-yagili kabo Yaubada kainana yo ana loina yawalo-masalan kolili.” ");
INSERT INTO tteo_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Kabo Yetolo iwaloba, “Kamwasa bwaimwa uginauline nige inanamwanamwasosi. ");
INSERT INTO tteo_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Kubomamo kuyakamkamnao, tabe tomo besiele sikamkamna. Ipolowesosi, kubomamo nige sowasowam. ");
INSERT INTO tteo_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Kainagu kubenalan yawalo-yasanapuwo na Yaubada iwalo-muloloiwo. Inamwanamwaele tem kutolo Yeoba manna mena tomo ali toedeedede yo ali gamwapakiki kulawan koina. ");
INSERT INTO tteo_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Yo tabe inamwanamwa tem Yaubada ana loina kuyakenayagili yo kuyakataili miyamiya namwanamwana kaiwena na siginauli besiele. ");
INSERT INTO tteo_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Na iyamo nuwanuwagu tomo tokatai tupwali ugite-sipwaili siya Yaubada simatausan, yo sowasowana ala meli tapei kolili yakato tabu loina naenaena siginauli mane kaiwena. Ugite-sipwaili kabo kupeili tomo kali tobaguna, tomo tausan kali tobaguna, tomo andeledi kaigeda kali tobaguna, tomo pipti kali tobaguna yo tomo sanaulu kali tobaguna. ");
INSERT INTO tteo_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Mwa sowasowali yatala paisowana siginauli sauga meuloina. Tem polowe lalakina silobai sikalaiyama koliwo, na tem imalamalae sibomamo siyadudulai. Tem siginauli besiele imalamalae koliwo kaiwena kowa me kam tosagu polowene kwayakasa yo kwayauyan kolimiu. ");
INSERT INTO tteo_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Yaubada ana walo bwaine, tem uginauli besiele, kani nige kamnam inanae. Tabe tomo bwaite meuloili kani sivivila ali kaba miya mena yo gamwapakiki imwawasi.” ");
INSERT INTO tteo_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Kabo Mosese bwasiyana kainana ibenalan. ");
INSERT INTO tteo_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Tomo loina kana tokatai igite-sipwaili Isileli luwali mena kabo ipeili tomo tausan kali tobaguna, tomo andeledi kali tobaguna, tomo pipti kali tobaguna yo tomo sanaulu kali tobaguna. ");
INSERT INTO tteo_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Mwa kamwasane bwaite koina tomo siyatalayagili sauga meuloina. Polowe lalakili silawagili Mosese koina, na tem imalamalae sibomamo siyadudulai. ");
INSERT INTO tteo_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Yetolo nuwanuwana ivivila ana yanuwa mena kabo Mosese ikabitui, ilogabaen yo ilau. ");
INSERT INTO tteo_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Isileli Itipita silogabaen kabo waikena yaiyona mulina mena siyawatagili silaoma yanuwa Lepidima koina bwaimwa dekawa bwagabwaga ule mena Sainai papalina mena, kabo Sainai ulena mena silusae. Muli mena sigogo koya Sainai yaulina mena. ");
INSERT INTO tteo_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","4","Yo Mosese ikawasae koya mena Yaubada koina. Yeoba iyogayoga Mosese koina koya mena iwaloba, “Kuwalo Isileli, Yakobo tubunao kolili, kuba, ‘Wagitaiyako tawae yau Yeoba yaginauli Itipita kolili yo yakalaimiu koliyau besiele magesubu natunao ikalakalaili pepena mena. ");
INSERT INTO tteo_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Tem kainagu kwabenalan yo yagu kelabilabin kamwasana wagite-kalatan, komiu yagu tomoyao. Yau yanuwa yaulina meuloina kana toyamayale, na komiu yagu gitesipwa tomonliyao. ");
INSERT INTO tteo_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Kabo tem waginauli besiele komiu boda yakayakasisina yau yaboma koliyau yo yagu paisowa yakayakasisina kani waginauli.’ Mosese, nuwanuwagu walone bwaite kuwalowen Isileli kolili.” ");
INSERT INTO tteo_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Kabo Mosese ilobima, tomo kali tobagunao iyoga-gogonagili yo ginauli meuloina Yeoba iwalowen koina iyawasa kolili. ");
INSERT INTO tteo_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Mwa tomo meuloili Mosese kainana siyamaisa siba, “O, ginauli meuloina Yeoba iwalowen kani kaginauli.” Kabo tomo ali talamne Mosese iwalo-masalan Yeoba koina. ");
INSERT INTO tteo_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Kabo Yeoba iwalo Mosese koina iba, “Kani yalaowa yaloyaloi balubaluna koina, kabo tomo Isileli meuloili kainagu sibenabenalan na kowa te yau taedeedede na mesabana simeli-yagiwo yo simuliya koliwo sauga meuloina.” ");
INSERT INTO tteo_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","11","Yeoba iwalo Mosese koina iba, “Kulau tomo kolili yo kuwalo kaliyate kabona yo bwaliga yoli sikatububu-nagili yo siyakasisi-yagili tapwalolo kaiwena, kali kwama sideulili na sikatububu-nagili bolawa kaiwena. Bolawa yau Yeoba yagu kaba miya yalogabaen yo yalobiwa koya Sainai koina tomo meuloili manli mena. ");
INSERT INTO tteo_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Sigasiga uginauli koya yaina mena tabu tomo siutu-likwai. Kuwalolau kolili tabu sisasae koya mena o tabu silalau salina mena. Tem tomo yabo iututonan kani sikoyamate, ");
INSERT INTO tteo_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","kabo kaba boita labuimo, veku yo wamali kolili, na tabu toutulikwa yabo nima gaibuli mena siunui. Tomo yo ebaebai kali loina kaigeda bwaite, tem loina silikwai kani siboita. Na tem saugana bwagigi ivalam kainana imamalawe tomo silaoma yo sisae koya mena.” ");
INSERT INTO tteo_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Kabo Mosese isaluluma koya mena yo iwalo tomo kali kwama sideulili na sikatububu tapwalolo kaiwena. ");
INSERT INTO tteo_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Yo Mosese iwalo kolili iba, “Wakatububu bolawa kaiwena, tabu yomiu kwatatalamwagili sinesineo kolili.” ");
INSERT INTO tteo_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Kaliyate yaiyonana koina malala mena ipigabu yo itutu, yaloyaloi balubaluna iyawatagili koya mena yo bwagigi kainana lalakina sibenalan kabo tomo meuloili ali kaba miya mena simatausi yo sitabutabubu. ");
INSERT INTO tteo_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Kabo Mosese ibagunayagili siyawatagilima ali kaba miya mena yakato tem Yaubada sigitai mwa sitolo koya yaina mena. ");
INSERT INTO tteo_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Bogau koya Sainai ipwaiki kaiwena Yeoba ilobi koya pwatana mena mayau bogauna luwana mena. Bogau lalakina isae besiele mayau lalakina sipei bogauna. Kabo koya imwasali yo tomo meuloili simatausi sitabutabubu. ");
INSERT INTO tteo_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Bwagigi kainana ilalakisosi. Mosese iyoga-sae kabo Yaubada kainana iyamaisa tutu koina. ");
INSERT INTO tteo_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yo Yeoba ilobi koya Sainai pwatana mena yo iyoga Mosese koina na tem yakato ikawasae koya pwatana mena. Mwa Mosese ikawasae. ");
INSERT INTO tteo_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Yeoba iwalo koina iba, “Kulobi naga tomo ukwausili tabu sigasiga sililikwai yo yakato sisaema. Tem siginauli besiele yo sigitaiyau kani sibaibaiwa siboita. ");
INSERT INTO tteo_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Besiele tabe tapwalolo kana tobagunao tem silaoma saligu mena siyakasisi-yagili ali nae sinuwa-gabaegili. Na tem nigele kani maisali yaolena siboita.” ");
INSERT INTO tteo_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mosese iwalo Yeoba koina iba, “Nige sowana tomo sisae kaiwena kowa kuwaloko yakato koya siyakasisi-yan yo sigasiga siginauli-takikilan kaiwem.” ");
INSERT INTO tteo_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Kabo Yeoba iwaloba, “Kulau Eloni kuyogan mekamkava kwasaema. Na tapwalolo kana tobagunao yo tomo meuloili tabu sigasiga sililikwai sisasaema koliyau kisi maisana silobai.” ");
INSERT INTO tteo_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Kabo Mosese ilobi yo Yeoba kainana iwalowen tomo kolili. ");
INSERT INTO tteo_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Yaubada iwalo bwaite besiele iba, ");
INSERT INTO tteo_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Yau Yeoba ami Yaubada yakalaimiu kwayawatagilima Itipita ali loina panpanna koina. ");
INSERT INTO tteo_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Tabu yaubada yabo koina kwatatapwalolo, yau yabomamo. ");
INSERT INTO tteo_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Tabu kokotomo yabo kwabomamo wagiginauli kaiwemiu, nuwana tem bulibuli mena ginauli yabo makamakayauna o tem yanuwa yaulina mena yabo makamakayauna, o tem kalita mena ginauli yabo makamakayauna. ");
INSERT INTO tteo_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Tabu kwapwapwalou kokotomo yabo koina yo tabu kwapapaisowa koina, kaiwena yau Yeoba ami Yaubada nige yatatalam tem yaiya ikalomagigilagau kani maisana yaolena kagu tokalomagigiliwone kolili. Maisane bwaite kani ilopanaisi natuliyao yo tubuliyao yo tubuliyao natuliyao kolili. ");
INSERT INTO tteo_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Na siya simulolo koliyau yo yagu loina simuliya yamulolo yaso yo yaso kolili nige ana kaba mwawasi. ");
INSERT INTO tteo_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Tabu yau Yeoba ami Yaubada esagune wakakatai-bwagabwagai kaiwena tem yabo esagune ikatai-bwagabwagai kani yayamaisa koina. ");
INSERT INTO tteo_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Kaliyate sabati kwanuwatu-kalatan yo kwayakasisi-yan Yaubada kaiwena. ");
INSERT INTO tteo_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ami paisowa waginaulili kaliyate sikisi kolili, ");
INSERT INTO tteo_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","na kaliyate sebenna koina bwaimwa kaliyate kaba kaiyawasi yakayakasisina koliyau. Kaliyatenane koina kisi yabo ipaisowa tem kowa o natumwao o am topaisowa o am ebaebai o tem taumanao siya simiyamiya am dedei mena. ");
INSERT INTO tteo_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Kaiwena yau Yeoba yanuwa yaulina yo bulibuli yo ginauli meuloili yayamayaleli kaliyate sikisi kaloli mena, na kaliyate sebenna koina yakaiyawasi. Iya kaiwena mwa kaliyate sabati yawalo-muloloi yo yayakasisi-yan. ");
INSERT INTO tteo_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Tamam yo sinam kuyakasisi-yagili na mesabana am sauga imamalawe yanuwane yaeyawane koliwo koina. ");
INSERT INTO tteo_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Tabu tomo kuunuyamate. ");
INSERT INTO tteo_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Tabu ugwanawali. ");
INSERT INTO tteo_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Tabu ukewali. ");
INSERT INTO tteo_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Tabu kuyakewa-mwakomwakota kamkavao kolili. ");
INSERT INTO tteo_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Tabu kamkava ana nume manim igagadosisiyan, wainena yo ana topaisowa yo ana bulumakau yo ana donki yo ana gogo meuloina tabu ugwagadosisi-yan.” ");
INSERT INTO tteo_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Saugana tomo tutu yo bwagigi kainana sibenalan yo pigabu yo koya mena bogau sigitai, kabo sitabubu yo simatausi yo sitolo-suwala kali mwayaga iyai. ");
INSERT INTO tteo_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Kabo siwalolau Mosese koina siba, “Kowamo tem kuedeedede kolimai kani kabenalan, na kamatausisosi tem Yaubada iedeedede kolimai kisi kaboita.” ");
INSERT INTO tteo_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mosese kainali iyamaisa iwaloba, “Tabu kwamamatausi, Yaubada ilaomako salimiu mena kaiwena nuwanuwana itonagimiu kabo kwamatausan na tabu kwalolopwano.” ");
INSERT INTO tteo_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Na tomo iyaele kali mwayaga iyai dedei yabo mena sitotolo yo Mosese ibomamo ilau yaloyaloi dubadubana yo balubaluna salina mena bwaine Yaubada imiyamiya koina. ");
INSERT INTO tteo_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Yeoba ana topaisowa esana Mosese, yo kana tosagu Yosuwa, iya Nani natuna. Mosese ana boita mulina mena, kabo Yeoba iwalo Yosuwa koina iba, ");
INSERT INTO tteo_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“Yagu topaisowa Mosese iya iboitako. Kabo sauga bwaite kowa mekamkavao Isileli meuloili wakatububu, waila Yolidan kwalopanaisi yo kwalau dedei yaeyawane kolimiu koina. ");
INSERT INTO tteo_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Toisabo dedei koina kwalau bwaimwana yatalamwan kolimiu, besiele yagu waloyameli Mosese koina. ");
INSERT INTO tteo_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Bwatano meuloina yaeyawa kolimiu iyatubu balabala gaibu mena yo ilobi tete kaluwabu mena kanasiga Lebanon koyanao kolili tabe ami bwatano isae waila lalakina Yupeleitisi koina yo ipileyoima Iti ali dedei meuloina yo ilobi ilau kanasiga kalita Mediteleiniya koina. ");
INSERT INTO tteo_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Nige tomo yabo sowasowana ikaiwe-gabaegiwo yawasim meuloina koina. Kani yasaguiwo besiele tauna kona Mosese yasasaguine. Nige sowana yalogabaegiwo kaiwena sauga meuloina yau mekaukava kowa.” ");
INSERT INTO tteo_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Yeoba iwaloyoi Yosuwa koina iba, “Ukwaiwe yo ukwatepatu kaiwena kowa kani boda bwaite kubaguna-yagili yo kwalau yanuwane koina kwamiya yanuwa bwaite yawalo-yameliyako tubumiyao kolili. ");
INSERT INTO tteo_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Bwaite sauga ukwaiwe yo katem ipatu ugite-kalatagiwo yo loina bwaite kumuliya Mosese iyeyawa ukwataili, tabu dagelam kuwowolena loinane kolili kabo yasaguiwo na tem tawae uginauli inamwanamwa. ");
INSERT INTO tteo_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Kunuwatu-kalatan loina kana buki kuyasili-kalatan. Kaliyate yo boniyai am kaba nuwanuwatu na ugite-kalatagiwo yo loina meuloina bwaite silele-yatalu ukwataili. Tem tawae yabo kupaisowai kani inamwanamwasosi. ");
INSERT INTO tteo_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Yawaloko koliwo ukwaiwe yo ukwatepatu. Tabu matausi yo tabu katewakaka kaiwena tem toisabo dedei koina kulau, yau Yeoba am Yaubada mekamkava.” ");
INSERT INTO tteo_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Yosuwa iwalo susu kaigeda kaigeda ali tobagunao kolili iba, ");
INSERT INTO tteo_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“Kwalau tomo ali kaba miya mena ali wasa kwaolegili kwawaloba, ‘Ami gogo yo kamiu wakatububu-nagili kaiwena kaliyate labuimo simiyamiya, na yaiyonana koina kabo talau, waila Yolidan talopanaisi yo talau dedei bwaine iya Yeoba ala Yaubada kani iyeyama ala yanuwa.’” ");
INSERT INTO tteo_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Kabo iwaloyoi susu Luben, susu Gada yo susu Manase tupwaliyao kolili iwaloba, ");
INSERT INTO tteo_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“Kwanuwatu-kalatan Yeoba ana topaisowa Mosese ana walo kolimiu iwaloba, ‘Yeoba ami Yaubada bwatano bwaite waila Yolidan dedei pwata yo ilau waila Yupeleitisi koina italamwan ami yanuwa yo ami kaba kaiyawasi.’ ");
INSERT INTO tteo_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Wainemiyao yo natumiyao yo ami yakayakan kwalogabaegili, siya simiyamiya ami yanuwa mena na komiu tokaleya meuloimiu ami gogo kaleya wakatububu-nagili kabo kwabaguna-yagimai yo waila Yolidan talopanaisi. Kwasaguimai kaiwena kai kamikavao. ");
INSERT INTO tteo_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","Kwabaguna-yagimai kanasiga kayawatagili na kamiya-namwanamwa besiele Yeoba iginauliyako kolimiu kabo ama yanuwa yawasosi kakalai, bwaite Yeoba iwaloyameli kolimai. Kabo muli mena kwapileyoi ami yanuwane bwaine koina Yeoba ana topaisowa Mosese iyeyawa kolimiu waila Yolidan papali isaesae koina.” ");
INSERT INTO tteo_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Mwa Yosuwa kainana siyamaisa siba, “Tem tawae kama loina kuwalowenako kolimai kani kaginauli. Besiele tem toisabo dedei koina kuyawasamai kalau. ");
INSERT INTO tteo_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Tem Yeoba ala Yaubada imiya koliwo besiele beyabeyana Mosese mekanakava na tawae am walo kolimai kani kaginauli besiele beyabeyana Mosese ana walo kabenalan. ");
INSERT INTO tteo_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Yaiya tem nige iyayakasisi-yagiwo yo nige am walo ibebenalan, kani kaunuyamate. Mwa koina ukwaiwe yo ukwatepatu.” ");
INSERT INTO tteo_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Yanuwa Sitim koina Yosuwa, Nani natuna, tolobubu labui iyawasa-wadamli iwaloba, “Kwalau dedei Kenani kwalobubunan yo yanuwa Yeliko wagite-namwanamwai.” Tolobubu labuine simuliya besiele Yosuwa ana walo. Saugana Yeliko silusae boniyai mena siyawatagili sine ganaganawalina esana Leyabi ana nume mena simiya. ");
INSERT INTO tteo_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Tomo tupwali Yeliko kana kin ana wasa siwolena siba, “Boniyai mena Isileli tomo labui silaoma silusae yo yanuwa sabi lobubunanna.” ");
INSERT INTO tteo_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Kabo kin ana tosagenawasa iyawasali silau Leyabi koina siba, “Tomo tupwali silaoma silusae am nume mena kuwalo siyawatagili na kakabi-kalatagili, kaiwena silaoma yanuwa kalona sabi lobubunanna.” ");
INSERT INTO tteo_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","6","Na Leyabi tolobubu labui ikalailiko silau nume kewana mena yo iwadamli imo palakes yaulina mena, palakes imo gwauna itakikili ana nume pwatana mena. Kabo iwalo kin ana tosagenawasa kolili iba, “Tomo silaoma yagu nume mena, yau nige yakakataili toweya silaomaya. Saugana yanuwa kana gamwa sikausi yo dabwelo isusugu bwaimwa koina tolobubune siyawatagili. Nige yakakatai toweya silau, na tem kwalomwayamwayau mulili mena kani wakabi-kalatagili.” ");
INSERT INTO tteo_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Kabo kin ana tosagenawasa sisagena-yawatagili, kabo yanuwa kana gamwa sikausi yo tolobubu siloyaili, silau kali siga waila Yolidan kaba gayo-panaisi koina. ");
INSERT INTO tteo_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Boniyainane koina kikiunamo tolobubu sikeno kabo Leyabi ilau imwalisae isae nume kewana mena. ");
INSERT INTO tteo_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","Iwalo kolili iba, “Yakatai Yeoba dedei bwaite kani iyeyawa kolimiu yo tomo meuloimai yanuwa bwaite koina kamatausi lalakina kaiwemiu. ");
INSERT INTO tteo_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Wasamiu kabenalan saugana kwayawatagili Itipita koina Yeoba Kalita Balabalagiyana isapiyaguma ilabwalabwa manimiu mena yo kwalopanaisi. Kabenalan yoi Siyon yo Ogi, Amoli ali kin labui kwaunuili Yolidan dedei pwata mena. ");
INSERT INTO tteo_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Saugana wasamiu kabenalan kamatausi lalakina yo ama kaiwe meuloina imwawasi, kaiwena kakatai Yeoba bulibuli yo yanuwa yaulina kali Yaubada. ");
INSERT INTO tteo_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","Nuwanuwagu wakawalulu Yeoba esana mena, saugana tem Yeliko wakalai yagu susu meuloili kwasaguili besiele yagu sagusaguimiu. ");
INSERT INTO tteo_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","Kilakilala yabo kwawalowen kabo yakatai yawasosi na yau mekaukavao tamagu yo sinagu, duguwao yo kaukavao, menatuliyao tabu kwauunuyamatemai na kwaleboimai.” ");
INSERT INTO tteo_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Tolobubu Leyabi kainana siyamaisa siba, “Kakawalulu koliwo, tem kwaboita naga Yeoba yomai labui iunuyamatemai. Tem nige tomo yabo ana wasa kuwowolena tawae kaginauli, kabo saugana tem Yeoba dedei bwaite iyeyama kolimai kani kasaguimiu yo kaleboimiu.” ");
INSERT INTO tteo_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Yeliko kana gana veku mena sipaisowai, na Leyabi ana nume iyaele imiyamiya gana kalona mena. Kabo maina yabo ikalai tolobubu labui iyadalolo-yataluli ana tomlape mena. ");
INSERT INTO tteo_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Iwalo kolili iwaloba, “Kwalau koya mena, kisi kin ana toloya silobaimiu. Wakeno-wadam kaliyate yaiyona, kanasiga toloyaimiune sipileyoi kabo ami kamwasa mena kwalau.” ");
INSERT INTO tteo_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Kabo siya siwalo Leyabi koina siwaloba, “Waloyameline kuwalo kaginauli koliwo kani nige kasosoke. ");
INSERT INTO tteo_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","Na kowa kunuwatu-kalatan saugana tem kapileyoima am dedei mena losalosa balabalagiyana bwaite kaeyawa kupan tomlape mena iya koina am kaba yadalolo-yatalumaiwa koina, na tamam yo sinam, dumwao yo totoumwao meuloili kuyoganli silaoma mekamkavao kwamiya am nume mena. ");
INSERT INTO tteo_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Tem yabo iyawatagili ganamuli mena kani kaunui ana lopwano maisana iboma ilobai, polowene kani nige ilalaoma kolimai. Na tem yabo am numene kalona mena nae ilobai, maisana kalobai. ");
INSERT INTO tteo_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Tem kuwalo-masalagimai, na ama waloyameli koliwo kani nige kagiginauli.” ");
INSERT INTO tteo_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Leyabi italam mwa iyawasali silau, kabo iya losalosa balabalagiyana ikalai ipan tomlapene koina. ");
INSERT INTO tteo_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Tolobubu silau sisae koya mena yo sikeno-wadam. Kin ana tosagenawasa kaliyate yaiyona tolobubu siloyaloyaili yanuwa dedeiliyao meuloili kolili, na nige silolobaili mwa sipileyoima Yeliko. ");
INSERT INTO tteo_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Na tolobubu labuine silobima koya mena waila Yolidan silopanaisi yo sipileyoi Yosuwa koina. Ginauli meuloina sigitai yo tawae iyawatagili kolili siwalo-masalan koina, ");
INSERT INTO tteo_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","yo tabe siwaloba, “Kakatai yawasosi Yeoba yanuwa meuloina iyeyama kolila. Tomo meuloili simatausi yawasosi kaiwela.” ");
INSERT INTO tteo_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Malala kikiuna koina, Yosuwa mekanakavao tomo Isileli meuloili sitolo Sitim silogabaen, kabo silau waila Yolidan koina sigogo sisanasana lopanaisi kaiwena. ");
INSERT INTO tteo_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Kaliyate yaiyona koina, kabo tobaguna silotakikili ali kaba gogone koina. ");
INSERT INTO tteo_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","Yo siwalo tomo kolili siwaloba, “Saugana tem topwaoli siya Libai ana boda wagitaili Yeoba ala Yaubada ana kelabilabin kamwasana kana dedewaga sikewai, ami kaba miya kwalogabaegili na kwamuliya. ");
INSERT INTO tteo_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Kabo kamwasa siyakena-yagimiu kaiwena nige sauga yabo kwalalaoma bwaite dedeinane koina. Tabu kwalalau kelabilabin kamwasana kana dedewaga salina mena kami mwayaga iyai tupwana besiele kilomita kaigeda.” ");
INSERT INTO tteo_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Kabo Yosuwa iwalo tomo kolili iwaloba, “Kwaeyakayakasisi-yagimiu, kaiwena bwaliga Yeoba ginauli kaba nuwapwanopwano kani ipaisowai luwaluwalila mena.” ");
INSERT INTO tteo_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Yosuwa tabe iwalo topwaoli kolili iwaloba, “Kelabilabin kamwasana kana dedewaga wakalai kwabaguna tomo manli mena.” Kabo sipaisowa besiele Yosuwa ana walo. ");
INSERT INTO tteo_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Yeoba iwalolau Yosuwa koina iwaloba, “Kaliyate kabona esam yapei-seyani boda Isileli manli mena na sikatai yau mekaukava kowa, besiele baguna yau mekaukava Mosese. ");
INSERT INTO tteo_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Kuwalo topwaoli siya kelabilabin kamwasana kana dedewaga kana tokewa kolili kuba, ‘Saugana tem kwayawatagili waila Yolidan dedeina mena kwalau kwatolo waila kalona mena.’” ");
INSERT INTO tteo_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Kabo Yosuwa iwalo tomo Isileli kolili iwaloba, “Kwalaoma bwaite koina Yeoba ala Yaubada ana walo yayawasa tabenalan. ");
INSERT INTO tteo_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","13","Ginauline bwaite wagitai, yanuwa yaulina kana Guyau ana kelabilabin kamwasana kana dedewaga kani ibaguna-yagimiu ilau waila Yolidan koina. Kabo saugana siya topwaoli dedewaga sikewai sigayolobi Yolidan koina, kabo waila bwaite ididi-lobima kewa mena kani iguma na idogadoga ana kaba miya kaigedamo. Yo wakatai yakato Yaubada yawasina miyamiya yaina iya mekalakava yo kabo Kenani, Iti, Ivi, Pelisi, Gegasi, Amoli yo Yebusi tanuwagaliyao itawoili kaiwemiu.” ");
INSERT INTO tteo_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","15","Sepasepa kana sauga kabo yanuwa ilogalewa yo yalubwasi ididi waila Yolidan koina. Saugana Isileli ali kaba gogo silogabaen silau Yolidan yakato silopanaisi, kabo topwaoli dedewaga sikalai sikewai yo sibaguna tomo manli mena. Na saugana topwaoli kaeli sipei waila kalona mena, ");
INSERT INTO tteo_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","kabo waila bwaite ana kaba didi-lobima kewa mena iguma. Waila idogadoga dedei yabo kana mwayaga imamalawe kolili, yanuwa esana Adama, yanuwa Saletan salina mena. Wailane ilobi ilau kalita yabo esana sipei Kalita Boiboitana koina. Waila iguma kepakepa kabo tomo sowasowali silopanaisi Yeliko salina mena. ");
INSERT INTO tteo_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Saugana Isileli silolopanaisi yo topwaoli siya Yeoba ana kelabilabin kamwasana kana dedewaga sikewai sitolo-dudulai bwatano labwalabwana koina Yolidan luwaluwalina mena kanasiga tomo meuloili silopanaisi woli. ");
INSERT INTO tteo_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Isileli waila Yolidan silopanaisiko kabo Yeoba iwalo Yosuwa koina iwaloba, ");
INSERT INTO tteo_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“Tatao yoli tuwelo wagite-sipwaili Isileli ana susu kaigeda kaigeda luwali mena. ");
INSERT INTO tteo_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","Yo kuwalo kolili veku tuwelo sikalailima Yolidan luwaluwalina mena toweya koina topwaoline sitotolo koina sikewaili silau sipeili yanuwa bwaite kani lolau koina wagogo.” ");
INSERT INTO tteo_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Kabo Yosuwa tatao yoli tuwelo siya igite-sipwailiko iyoga-gogonagili, ");
INSERT INTO tteo_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","yo iba, “Wakaisulu waila Yolidan Yeoba ala Yaubada ana kelabilabin kamwasana kana dedewaga manna mena kabo veku kaigeda kaigeda wakalaili wakewaili leyaleyamiu mena, kali baibaiwa tuwelo besiele Isileli susu kala baibaiwa. ");
INSERT INTO tteo_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Veku bwaite ala kaba nuwatu-kalatan tawae Yeoba iginauli kolila. Bwaliga tem natumiyao sineli kolimiu siba, ‘Veku bwaite kali katai gubesi?’ ");
INSERT INTO tteo_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","Kabo kwawaloba, ‘Beyabeyana waila Yolidan iguma saugana Yeoba ana kelabilabin kamwasana kana dedewaga sikewa-panaisan. Veku bwaite boda Isileli yaso yo yaso ali kaba nuwatu-kalatan.’” ");
INSERT INTO tteo_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","9","Kabo tataone siginauli besiele Yosuwa ana walo. Silau veku tuwelo sikalailiya waila Yolidan luwaluwalina mena kali baibaiwa besiele susu Isileli kali baibaiwa besiele Yeoba ana walo Yosuwa koina. Yo veku tuwelo sikalaili waila Yolidan luwaluwalina mena dedei bwaimwana topwaoli sitotolo vekune sikewai yo silau sipeili ali kaba gogone koina kabo Yosuwa veku igwauili. Veku bwaite siyaelemo sauga bwaite. ");
INSERT INTO tteo_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","18","Yo tomo mwayamwayau mena silopanaisi yo topwaoli siya dedewaga sikewakewai sitotolo Yolidan luwaluwalina mena kanasiga ginauli bwaite Yeoba iwalowen Yosuwa koina meuloina Isileli siginauli woli, besiele beyabeyana Mosese ana walo Yosuwa koina. Yeoba iwalo Yosuwa koina iwaloba, “Kuwalo topwaoli siya kelabilabin kamwasana kana dedewaga sikewakewai sigayosaema wailane koina.” Yo Yosuwa iwalolau topwaoli kolili iwaloba, “Wagayosaema.” Kabo topwaoli sigayosaema kelabilabin kamwasana kana dedewaga sikewakewai yo Yolidan silogabaen. Saugana sigayosaema waila dedeina mena kabo waila idoga yoi, yalubwasi ididi yoi. Boda sisanasana saugana topwaoline silopanaisi yo silau kanasiga tomo Isileli sibaguna-yagili yoi. Tataomo tokaleya siya susu Luben, Gada yo susu Manase tupwaliyao mekalikavao sikatububu kaleya kaiwena yo silopanaisi tomo meuloili manli mena, besiele beyabeyana Mosese ana walo kolili. Kali baibaiwa poti tausan (40,000) silopanaisi silau Yeliko kwabuna mena kaleya kaiwena. Kaliyatenane koina tomo Isileli Yeoba ana paisowa yo ana kaiwe sigitai kabo Yosuwa siyakasisi-yan besiele beyabeyana Mosese siyakasisi-yan. ");
INSERT INTO tteo_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Bolime kana waikena bagubagunana kana kaliyate sanaulu koina tomo Isileli Yolidan silopanaisi silau ali kaba gogowa yanuwa esana Giligali, iyaele Yeliko dedei pwatana mena. ");
INSERT INTO tteo_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Veku tuwelo sikalailiya waila Yolidan kalona mena Yosuwa igwauili yanuwane koina. ");
INSERT INTO tteo_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Kabo iwaloba, “Na sauga ilalaoma tem natumiyao sineli-yagimiu siba, ‘Veku bwaite kali katai gubesi?’ ");
INSERT INTO tteo_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","Kabo kwawalo kolili kwaba, ‘Waila Yolidan iguma yo bwatano leleyanna koina kalopanaisi.’ ");
INSERT INTO tteo_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Kwawalo bwaite besiele kaiwena Yeoba ala Yaubada waila Yolidan isapiyaguma kaiwela kanasiga talopanaisi besiele bagubagunana koina Kalita Balabalagiyana isapiyaguma kanasiga tubumiyao silopanaisi. ");
INSERT INTO tteo_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Iginauli besiele kabo tomo meuloili yanuwa yaulina mena sikatai Yeoba iya Tokaiwe yo kabo komiu Yeoba ami Yaubada kwayakasisi-yan sauga meuloina.” ");
INSERT INTO tteo_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Isileli kali tokalomagigili siya Amoli ali kin siya Yolidan salina mena dedei pae yo Kenani ali kin meuloili siya kalita Mediteleiniya papalina mena wasa sibenalan Yeoba waila Yolidan isapiyaguma kanasiga tomo Isileli meuloili silopanaisi woli. Kabo simatausi lalakina yo nige ali kaiwe ipapagan yakato mekalikavao Isileli sikaleya. ");
INSERT INTO tteo_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Kabo Yeoba iwalo Yosuwa koina iwaloba, “Nabuka tupwali kwatutuli yo Isileli tatao meuloili yoli isuli kwapili kwatom-gabaegili.” ");
INSERT INTO tteo_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Mwa Yosuwa ipaisowai besiele Yeoba ana walo yo Isileli tatao meuloili yoli isuli kwapili sitom-gabaegili. Yo yanuwane esana sipei ‘kwapi kaba tomtomna’. ");
INSERT INTO tteo_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","6","Yosuwa ana paisowa yaina bwaite besiele. Na saugana Isileli Itipita silogabaen tatao meuloili nigwenigwe sikalaiyako. Na ali lokeikeile ule mena bolime poti kalona mena melumeluwo siya sikabili nige yabo yona isuna kwapina sitotom yo tabe tatao siya kali bolime piptin (15) kanasiga pipti (50) saugana Itipita silogabaen bwaite sauga siboitako kaiwena siyauyaule. Kabo ali pwanoli maisana silobai besiele Yeoba ana walo kolili yakato Kenani, yanuwa masumasulina, kani nige sigigitai yanuwanane beyabeyana Yeoba iwaloyameli Isileli kolili. ");
INSERT INTO tteo_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Mwa natuliyao nige nigwenigwe sikakalai yo yaso waluwaluline bwaite Yosuwa iwalo yoli isuli kwapili sitom-gabaegili, kaiwena nige sigiginauli ule mena. ");
INSERT INTO tteo_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Tatao meuloili nigwenigwe imwawasi kabo simiyamiya ali kaba gogowa koina kanasiga ali kamkamna simwawasi. ");
INSERT INTO tteo_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Kabo Yeoba iwalo Yosuwa koina iwaloba, “Beyabeyana tubumiyao kamkamna lalakina silobai Itipita koina kaiwena Itipita me ali kaiwe siloina-yagili yo tubumiyao ali miya polopolowena. Kaliyate kabona mwalimwalinenawa imwawasi kaiwena yakele-gabaenako.” Yaina bwaite yanuwa esana sipei Giligali. Esa bwaite imiyayai kanasiga yo kanasiga. ");
INSERT INTO tteo_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Saugana Isileli siya siyaele Giligali bwaimwa Yeliko kwabuna mena kabo mwalelikwa soina kana nuwatu-kalatan sipaisowai waikena kana kaliyate potin (14) lolauna mena. ");
INSERT INTO tteo_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Mwalelikwa soina imwawasi sikeno yanuwa ilayan kabo silau witi kanna sikibwa. Tupwali sikavaegaili yo tupwali pwalawa gaibumo siebweli na beledi sigabu. ");
INSERT INTO tteo_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Yo kaliyatenane koina siyatubu sikekan Kenani kanna koina. Yanuwa ilayanyoi kanwa mana imwawasi nige yaboyoi silolobai. Bwaine bolimene Kenani kanna koina sikekan. ");
INSERT INTO tteo_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Yosuwa iyaele Yeliko salina mena kabo manna ilau tomo yabo igitai ana kaleya kelepana ana kaba miya mena iniwisiyama nimana mena ikabikabi-kalatan na itotolo. Mwa Yosuwa ilau koina yo ineli iba, “Kowa kama tosagu yabo o kama tokaleya yabo?” ");
INSERT INTO tteo_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Tomone iba, “Nigele, yalaomane kaiwena yau Yeoba ana tokaleya kali tobaguna.” Kabo Yosuwa me ana yakasisi italu-pwaopwaom iwaloba, “Taubala, yau am topaisowa. Tawae nuwanuwam yaginauli?” ");
INSERT INTO tteo_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Mwa Yeoba ana tokaleya kali tobaguna iwalo Yosuwa koina iba, “Kaem kali suma ukwele-gabaegili, kaiwena bwatano bwaite koina kutotolone yakayakasisina.” Kabo Yosuwa iginauli besiele tomone ana walo. ");
INSERT INTO tteo_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Na yanuwa Yeliko sigana-takikilan yo kaba lusaena sikausi na tem sigite-kalatan namwanamwai tabu Isileli silulusae yo siyakasisi-yan kisi tomo yabo ilusae yo iyawatagili. ");
INSERT INTO tteo_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Kabo Yeoba iwalo Yosuwa koina iwaloba, “Ugitai, kani Yeliko yapei nimam mena kin me ana tokaleyayao kaikaiweli meuloili. ");
INSERT INTO tteo_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","4","Kaliyate kaigeda kaigeda mekaigeda am tokaleyayao meuloili yanuwa kwalotakikili kanasiga kaliyate sikisi simwawasi. Topwaoli yoli seben ugite-sipwaili siya kani sibaguna bwagigi kana toyui yo mulili mena kelabilabin kamwasana kana dedewaga kana tokewa. Kaliyate sebenna koina kani yanuwane kwalotakikili me seben. ");
INSERT INTO tteo_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Kuyanuwapei-bagunayagili yakato kaliyate sebenna koina ali takikili sebenna koina topwaoli kani bwagigi siyui-kalatan. Na sauganane koina tem bwagigi kainana kubenalan kuwalo tomo meuloili sitalawauwau kainali ilalaki kabo gana kani ibeku itata-gwaligwali. Kabo kuwalo tokaleya meuloili silodudulai silau silusae yanuwane kalona mena.” ");
INSERT INTO tteo_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Na Yosuwa, Nani natuna, topwaoli iyoga-gogonagili yo iyakasali bwaite besiele, “Komiu topwaoli yomiu seben ami bwagigi wakatububu-nagili kwabaguna na dagelamiu mena dedewaga kana tokewa.” ");
INSERT INTO tteo_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Imwawasi kabo iwalo tokaleyayao kolili iba, “Talau yanuwa talotakikili. Na tokaleya tupwali silau sibaguna.” ");
INSERT INTO tteo_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","14","Kabo besiele Yosuwa ana walo, tokaleya tupwali sibaguna kabo bwagigi kana toyuiyui kabo dedewaga kana tokewa kabo tokaleya meuloili simuliya molosi. Na bwagigi kana toyuiyui ali bwagigi siyuiyuili ali lau koina. Na Yosuwa iwalo tomo kolili iba, “Tabu talawauwau, tabu kainamiu ilalaki yo tabu walo yabo kwawawalowen kanasiga kaliyatenane tem yawalo ee kabo kwatalawauwau yo kainamiu ilalaki.” Kabo kaliyate kaigeda kaigeda Yosuwa itolo malala kikiuna, topwaoli tupwali dedewaga sikalai yo topwaoli yoli seben ali bwagigi sikalaili yo mekalikavao tokaleyayao yanuwa silotakikili. Siginauli besiele bwaine kanasiga kaliyate sikisi. Ali takikili imwawasi sipileyoi ali kaba gogo mena sikaiyawasi. ");
INSERT INTO tteo_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Kaliyate sebenna koina malala kikiuna Isileli sitolo silau Yeliko silotakikilan meseben ali lotakikili besiele bwaite siginauli kaliyate sikisi kalona mena na kaliyate bwaite yanuwa silotakikilan meseben. ");
INSERT INTO tteo_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Ali lotakikili sebennane koina topwaoli bwagigi siyui-kalatan kabo Yosuwa iwalo tomo kolili iba, “Kwatalawauwau kaiwena Yeoba yanuwane kani iyeyama kolila. ");
INSERT INTO tteo_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Yeliko kana tomiya meuloili kalikavao yo ali yakayakan yo ali gogo meuloina tasibayanaeli kaiwena Yeoba ana walo besiele. Na Leyabi sine ganaganawalina kanakavao yo ana nume kana tomiya meuloili tabu yabo kwaunui kaiwena ala tolobubu isaguili yo iwadamli. ");
INSERT INTO tteo_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Na gogo bwaite Yeoba iwalo tasibayanaeli tabu yabo wakakalaili kisi kwaboma ami wenoweno waginauli na polowene ipanaisi meuloila kolila yo isibayanaela. ");
INSERT INTO tteo_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Gogo bwaite siginaulili siliba, gole, kopa yo aeyan tapei-suwalagili na tayakasisi-yagili Yeoba koina yo tapei-luseyagili gogo wasawasa kaba peili mena Yeoba ana nume kalona mena.” ");
INSERT INTO tteo_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Ee saugana siya topwaoli bwagigi siyui-kalatan tomo sitalawauwau kainali ilalaki kabo Yeliko kana gana ibeku itata-gwaligwali, tokaleya meuloili silodudulai silau silusae Yeliko kalona mena yo sikalai. ");
INSERT INTO tteo_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Yanuwa sisibayanae yawasosi besiele Yeoba ana walo. Kali tokaleyayao kelepa koina tatao, sinesineo, gagagiliyao yo tautaubalao mekalikavao ali bulumakau, sipi yo donki sikoyamate-olili. ");
INSERT INTO tteo_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Kabo Yosuwa iwalo tolobubu labui kolili iwaloba, “Kwalau kwalusae Leyabi ana nume mena yo kanakavao ana bodao meuloili kwayoganli silaoma besiele ami waloyameli koina.” ");
INSERT INTO tteo_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Mwa tolobubu siya tauna kona silau Yeliko silobubunan silau Leyabi kanakavao tamana, sinana, dunao yo ana bodao meuloili siyoga-gogonagili silawagili sipeili Isileli ali kaba gogo salina mena. ");
INSERT INTO tteo_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Kabo Isileli ali tokaleya Yeliko meuloina sigabu megogona. Na gogone siya siginaulili gole, siliba, kopa, yo aeyan koina sikele-gogonagili gogo wasawasa kaba peili Yeoba ana nume mena. ");
INSERT INTO tteo_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Na Yosuwa Leyabi yo ana bodao meuloili yawasili ileboili kaiwena tatao siya tauna kona iyawasali silau Yeliko silobubunan Leyabi isaguili yo iwadamli. Na Leyabi tubunao siyaele simiyamiya boda Isileli kalona mena kanasiga kabona. ");
INSERT INTO tteo_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Sauganane koina Yosuwa iwalo kaiwe iwaloyameli Isileli kolili besiele, “Yaiya tem itonan yakato Yeliko ikabi yoi kani Yeoba ana munamunai ilobai. Yaiya tem gana kana wauwau isepa yakato yanuwa iganai kani natuna tobagubaguna iboita yo tabe tem iya gana kaba lusae iyatolo kani natuna tomulimuliya iboitayoi.” ");
INSERT INTO tteo_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Yeoba mekanakava Yosuwa mwa Yosuwa wasana itakikili Kenani dedeina meuloina koina. ");
INSERT INTO tteo_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Sauga beyabeyana koina toloinao Isileli siloiloinayan kaiwena sauganane koina Isileli nige ali kin ipapagan. Guliyam lalakina silobai dedeinane bwaine koina, kabo tomo yabo esana Elimileki me wainena yo natunao tatao labui ali yanuwa Bedeliema Yudiya dedeina mena silogabaen na silau Mowabe dedeina mena simiyamiya. Wainena esana Naomi yo natunao esali Malona yo Kilion. Na Elimileki ana boda esana Epalati. ");
INSERT INTO tteo_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","4","Kabo Elimileki ana sauga imwawasi, iboita. Mwa Naomi me natunao tatao labui sibomamo simiyamiya. Kabo muli mena Malona yo Kilion Mowabe sinesineoliyao sikasolanagili, yabo esana Opa yo yabo esana Ludi. Simiyamiya bwaine koina besiele bolime sanaulu, ");
INSERT INTO tteo_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","kabo Malona yo Kilion ali sauga simwawasi, siboita. Kabo sinali Naomi, nige wainena yo nige natunao sipapagan. ");
INSERT INTO tteo_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Sauga yabo mena Naomi wasa ibenalan yakato Yeoba ana tomoyao isaguili kaiwena masuli lalakina silobai. Kabo Naomi me lawanao Opa yo Ludi sikatububu na silau Yudiya. ");
INSERT INTO tteo_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Ali yanuwa silogabaen yo silalau kamwasa mena Yudiya kaiwena. ");
INSERT INTO tteo_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Kabo Naomi iwalolau lawanao kolili iba, “Kwavivila, kwalau ami yanuwa mena totoumiyao kolili. Walo yawasosi wainemiyao kwamulolo kolili yo tabe kwamulolo koliyau, na nuwana Yeoba kani imulolo kolimiu besiele. ");
INSERT INTO tteo_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Inamwanamwa tem Yeoba isaguimiu na wakasoleyoi na ami kaba miya ipagan na kwamiya namwanamwa ami yanuwa mena.” Kabo muli mena lawanao isapwalili imuloloili yo mekanakavao sivalam. ");
INSERT INTO tteo_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Siwalo koina siba, “Nigele, mekamakava kowa talau am tomoyao kolili.” ");
INSERT INTO tteo_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Na Naomi iwalo lawanao kolili iba, “Lawaguwao kwavivila. Tawae kaiwena nuwanuwamiu muligu mena kwalaulau? Kwanuwatui yakato yau kani yakabiyoi na natuguwao wakasolanagili-yoi? ");
INSERT INTO tteo_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Kwavivila ami yanuwa mena, yau iyaele yabeluko, nige sowasowagu yakasoleyoi. Tem yawaloba yakato kani boniyai bwaite yakasole yo natuguwao sipagan, ");
INSERT INTO tteo_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","gubesi, kani sowasowamiu kwasanasana kanasiga silalaki kabo wakasolanagili? Nigele, nige sowana kwamiya kwasikwasiki kwamiyamiya. Yagu nuwanae ilalakisosi kabo muli mena komiu ami nuwanae kaiwena Yeoba iboma iyakamkamna-yau.” ");
INSERT INTO tteo_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Mwa sivalam yoi, kabo Opa lawana isapwali yo mekanakava simulolo yo ivivila ana yanuwa mena, na Ludi lawana ikabi-kalatan, genuwana ilogabaen. ");
INSERT INTO tteo_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Kabo Naomi iwalo Ludi koina iwaloba, “Lawagu ugitai, Opa ivivila totounao yo ana yaubadao kolili. Kuvivila kulau mekamkava.” ");
INSERT INTO tteo_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Na Ludi iba, “Tabu kuwalo yalologabaegiwo. Yalaowa mekaukava kowa. Toweya kulau yau tabe kani yalau, toweya koina kumiyamiya yau koina yamiyamiya, totoumwaone totouguwao yo tabe am Yaubada yagu Yaubada. ");
INSERT INTO tteo_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Toweya koina kuboita yau kani yaboita, yo bwaine kani sipuluiyau. Tem ginauli yabo luwaluwalila mena ipei-suwalagila ee kabo Yeoba ana kawa-gula ilaoma koliyau.” ");
INSERT INTO tteo_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Saugana Naomi igitai Ludi nuwanuwasosina ilau mekanakava mwa nige walo yaboyoi iwawalowen koina. ");
INSERT INTO tteo_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Silalau ee kanasiga siyawatagili Bedeliema. Saugana siyawatagili yanuwane koina kabo tomo simiyamiya yanuwane koina kateli sipitali siyaliyaya kaiwena Naomi sigitai, kabo sinesineo sibomamo sienelineli-yagili, siwaloba, “Yawasosi bwaine Naomi?” ");
INSERT INTO tteo_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Kabo Naomi iwalolau kolili iba, “Tabu esagune kwayoyogayan Naomi, na kwawaloba Mala, kaiwena Yeoba Tomiyasaesosi yagu miyamiya isibayanaeyako. ");
INSERT INTO tteo_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Saugana yanuwa bwaite yalogabaen yagu boda ilalaki yo yagu gogo sibaibaiwasosi, na yagu sauga vivilama koina Yeoba ikalaiyauma menima bwagabwagagu yabubutuma molosi. Tawae kaiwena esagune Naomi kwayogayogayan, tem Yeoba Tomiyasaesosi yagu miyamiya isibayanaeyako yo meyagu nuwanae?” ");
INSERT INTO tteo_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Naomi ana vivilama dedeina Mowabe koina mekanakava lawana Ludi, Mowabe sinena edeededena bwaite. Bali kana sauga sepasepa iyatubu kabo Naomi yo lawana siyawatagili Bedeliema. ");
INSERT INTO tteo_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Naomi kana kwauya Elimileki ana susu yabo esana Bowasa, iya ana gogo ibaibaiwa yo towasawasa. ");
INSERT INTO tteo_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Sauga yabo mena Ludi iwalolau lawana Naomi koina iwaloba, “Kutalamwagau na yalau na bali bwaine kana topaisowa tupwali silologabaegili yatanoili. Yau yagu nuwatu yakato tomo yabo yalobai na italam ana tano yapaisowa koina.” Kabo Naomi iwaloba, “Lawagu kulau.” ");
INSERT INTO tteo_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Kabo Ludi ilau bali yabo kana tano mena, bali kana topaisowao mulili mena na toweya baline nige sikakalai itanoili. Na tanone Bowasa ana tano. ");
INSERT INTO tteo_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Sauga tupwana imamalawe kabo Bowasa iyawatagili, ilaomaya Bedeliema. Ilaoma ana topaisowao igitaili kabo iwaloba, “Yeoba mekamikava.” Yo ana topaisowao siwaloba, “Yeoba imuloloiwo.” ");
INSERT INTO tteo_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Bowasa ineli ana topaisowa kali tobaguna koina iwaloba, “Toisabo sine bwaine?” ");
INSERT INTO tteo_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Yo ana topaisowa kali tobaguna kainana iyamaisa iwaloba, “Sine bwainene iya Mowabe sinena tauna kona mekanakava Naomi silaoma. ");
INSERT INTO tteo_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Ilaoma ikawanoi koliyau yakato bali bwaine topaisowa silologabaegiline itanoili. Malala mena paisowa iyatubu kanasiga sauga bwaite na nige ikakaiyawasi.” ");
INSERT INTO tteo_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Bowasa iwalolau Ludi koina, “Natugu, kubenali. Sauga bwaite kam loina yaeyawa besimo bwaite tanone koina kutanotano. Yagu topaisowa kedukedulumao bwaine mekamkavao kwapaisowa. ");
INSERT INTO tteo_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Ugitai bali toweya sigwauiya mekamkavao. Yawalolauko yagu topaisowa tatao kolili nige sowana mumuga naenaena yabo siginauli koliwo. Kabo saugana tem galogalom imagu, kulau topaisowa waila silegu nonowaiyako koina kunuma.” ");
INSERT INTO tteo_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Ludi italu-miyasio yo ipwalou Bowasa manna mena kabo iwalolau koina iba, “Tawae kaiwena mwa kunuwanuwatu kaiwegu yakato kusaguiyau? Tawae kaiwena kumulolo yanuwa uloina tomona koina?” ");
INSERT INTO tteo_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Bowasa iwaloba, “Yabenalan yakato am sauga kwabukwabuli koina ginauli meuloina uginauli lawam koina. Tabe tamam, sinam yo am yanuwa kulogabaegili yo kulaoma kumiya tomo nige ukwakataili luwali mena. ");
INSERT INTO tteo_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Sowasowana Yeoba iwalo-muloloiwo am paisowa namwanamwana kaiwena. Kulaomako Yeoba, Isileli ali Yaubada koina, kumiya nimana yaulina mena, iya am kaba kaiyawasi, na yakawanoi koina mulolo lalakisosina iyeyawa.” ");
INSERT INTO tteo_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Ludi iwaloba, “Taubala, mumugam inamwanamwasosi koliyau. Yau nige yagu namwanamwa ana lalaki besiele am topaisowa ali namwanamwa, na am walo-mulolo koliyau kaiwena kamna namwanamwasosina yalobai.” ");
INSERT INTO tteo_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Kekan kana sauga mena kabo Bowasa iwalolau Ludi koina iwaloba, “Kulaoma kam beledi tupwana ukwalai na kuyalakwa wain koina.” Kabo imiyasio mekanakavao topaisowa yo Bowasa bali kanna kavakavalegana tupwana iwolena koina. Ludi ikekan kanasiga kana liye ilobai, na kan tupwana itupwa. ");
INSERT INTO tteo_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","16","Ilau bali itanoi yoi, kabo Bowasa iwalolau ana topaisowa kolili, “Tabu kwayoyokoiyan, bwagana tem itanolikwa bali bwagilina luwana mena. Na tabe bali tupwana kwaniuli-yawatagilani bwagilinane koina yo kwapei ikalai.” ");
INSERT INTO tteo_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Kabo Ludi bali itanotano kanasiga ilolau. Saugana bali itutu, kanna kana lalaki kikiunamo laisi beiki lalakina ilobai. ");
INSERT INTO tteo_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Bali ikalai yo ivivila ilau ali yanuwa mena kabo bali bwaimwa ikalai kana lalaki lawana iyakenayan yo kan bwaimwa sikanpei iwolenayoi lawana koina. ");
INSERT INTO tteo_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Naomi lawana ineliyan, “Baline toweya ukwalailiya? Yaiya ana tano mena kutanotano? Inamwanamwa tem tomo bwaimwa iyaliyaya kaiwem yo isaguiwo Yaubada iwalo-muloloi.” Mwa Ludi iwalolau lawana koina, “Yatanotanoya tomo yabo esana Bowasa ana bali tanona mena.” ");
INSERT INTO tteo_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Naomi Yeoba itobalan yo iwaloba, “Inamwanamwa tem Yeoba ana mulolo lalakina iwolena Bowasa koina. Sauga meuloina Yeoba ana waloyameli siya siboitako yo siya meyawasili kolili inuwatu-kalatagili.” Yo iwaloyoi iba, “Tomo bwaine wainegu ana susu yabo. Iya toyamaisa-yavivila yabo kaiwela, iya sowasowana ikalaila yo igite-kalatagila.” ");
INSERT INTO tteo_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Kabo Ludi iwaloba, “Iwaloma yoi koliyau iwaloba, ‘Kutanotanoya mekamkavao yagu topaisowa kanasiga sepasepa imwawasi.’” ");
INSERT INTO tteo_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Naomi iwalolau Ludi koina iba, “Lawagu, inamwanamwa tem mekamkavao yo ana gamagamasineo bali kwatanotanoya ana tano mena. Tabu kulalau tomo uloili ali tano mena kisi tatao mumuga naenaena yabo siginauli koliwo.” ");
INSERT INTO tteo_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Yo Ludi mekanakava Bowasa ana gamagamasineo sipaisowa toyawa kanasiga bali yo witi tanoli meuloili sisepa wolili. Na Ludi imiyamiyaya lawana koina. ");
INSERT INTO tteo_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Sauga yabo koina Naomi iwalolau Ludi koina iwaloba, “Wainem yabo kani yaloyai kaiwem na mesabana igite-kalatagiwo. ");
INSERT INTO tteo_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Kunuwatu-kalatan Bowasa, iya ana gamagamasineo mekamkavao kwapaipaisowa, iya wainegu ana susu yabo. Kubenali, kabona lolau kani bali mosomosona sitatano. ");
INSERT INTO tteo_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Kulau kusugu, olo ukwalai yom kuyaoloi yo kupasa namwanamwa na kulau yanuwa bwaine Bowasa bali mosomosona ana kaba tanotanoina koina, na iyamo tabu kumamayale igigitaiwo kanasiga ikekanwoli. ");
INSERT INTO tteo_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Ugite namwanamwai toweya ikenokenoya yo saugana tem ikeno-boita kabo kulau kana kabobone kaena mena ukweleisin na ukeno. Iya kabo iwalowa koliwo tawae kani uginauli.” ");
INSERT INTO tteo_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Ludi iwaloba, “Kani yaginauli besiele walone meuloina bwaimwa kuwalowen koliyau.” ");
INSERT INTO tteo_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Kabo Ludi ilau bali mosomosona kaba tanotanoina koina yo iginauli besiele lawana ana walo koina. ");
INSERT INTO tteo_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Saugana Bowasa ikekan woli kamna namwanamwasosina ilobai, yo ilau ikeno bali bwagilina salina mena. Ludi kikiuna kikiuna ilau Bowasa kana kabobo ikeleisin kaena mena yo ikeno-talu kaena salina mena. ");
INSERT INTO tteo_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Boniyai luwaluwalina mena Bowasa ikeno-siliyata mwa manna ilala ikeno-keile kabo katena ipitali kaiwena igitai sine yabo kaena salina mena ikenokeno. ");
INSERT INTO tteo_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Bowasa ineli, “Yaiya kowa?” Ludi iwaloba, “Taubala, yau Ludi. Kowa lawagu Elimileki ana susu yo kowa toyamaisa-yavivila yabo, sowasowana ukwalaiyau ugite-kalatagau.” ");
INSERT INTO tteo_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Bowasa iwaloba, “Inamwanamwa tem Yeoba ana mulolo lalakina iyeyawa. Tauna kona am mulolo ilalaki Naomi koina na sauga bwaitete mulolo lalakisosina uginauli koliyau kaiwena kilakaiwo, tem tobubutuma o tem towasawasa, nige kulau kuloloyaili. ");
INSERT INTO tteo_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ludi, sauga bwaite koina tabu me am katewakaka. Tem tawae ukawanoiyan, kani yaginauli besiele am kawanoi, kaiwena yanuwa bwaitete kana tomiya meuloili sikatai mumugam inamwanamwa. ");
INSERT INTO tteo_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Yawasosi yau Elimileki ana susu yo yau toyamaisa-yavivila yabo sowasowagu yagite-kalatagiwo na tomo yabo yanuwatui iya Elimileki ana susu yabo. Iya tobagubaguna na yau tomulimuliya, koinaele iya ami toyamaisa-yavivila yawasosi. ");
INSERT INTO tteo_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Boniyai kabona kumiya bwaite koina, na bwaliga malala ana nuwatu tabenalan. Tem nuwanuwana iginauli besiele toyamaisa-yavivila ana paisowa yo igite-kalatagiwo, ee inamwanamwa. Na tem nigele, yawaloyameli Yeoba meyawasina koina, yau kani yaginauli. Sauga bwaite kumiyamiya yo ukeno kanasiga bwaliga malala.” ");
INSERT INTO tteo_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Ee kabo Ludi ikenoya Bowasa kaena salina mena kanasiga malala mena. Nige yanuwa ilalayan namwanamwa yo tomo kali koleya nige naga tagigite-namwanamwai, na Ludi itolo kaiwena Bowasa nige nuwanuwana tomo sikatai Ludi ikenoya koina. ");
INSERT INTO tteo_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Bowasa iwalolau Ludi koina iba, “Kam kabobo ukwelegaba na kuyese bwaite koina.” Ludi iginauli besiele kabo Bowasa bali gwauna isuwai yo iyanabai. Kabo Ludi ivivila ana yanuwa mena. ");
INSERT INTO tteo_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Saugana iyawatagili yanuwa mena, kabo lawana ineli iba, “Lawagu, gubesi ala wasa?” Yo ginauli meuloina Bowasa iginauli koina iwalo-masalan lawana koina. ");
INSERT INTO tteo_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Ludi iwaloyoi, “Bowasa iwaloma koliyau tabu yavivivilama koliwo menimagu. Kaiwena mwa bali bwaite meuloina iyeyama.” ");
INSERT INTO tteo_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Kabo Naomi iwaloba, “Lawagu, kusanasana kanasiga tagitai tawae kani iyawatagili. Bowasa nige sowana imiya-mwanou kabona kanasiga kam loina iyadudulai.” ");
INSERT INTO tteo_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Bowasa ilau yanuwane ali kaba miyagogo kaba lusalusaena koina imiyasio. Kabo Elimileki ana susu yabo ilaoma, bwaimwa iya tomonane mwa Bowasa iwalowen Ludi koina yakato iya toyamaisa-yavivila yawasosi. Yo Bowasa iwalolau koina iwaloba, “Kava, kulaoma kumiyasio bwaite koina.” Yo ilau imiyasio. ");
INSERT INTO tteo_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Mulina mena Bowasa yanuwane kana toloinao yoli sanaulu ikalaili kabo iwalo simiyasio. ");
INSERT INTO tteo_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Bowasa iwalolau tomone koina iwaloba, “Sauga bwaite Naomi ivivilamako Mowabe koina yo nuwanuwana kalakava Elimileki ana bwatano igimwalayan. ");
INSERT INTO tteo_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Yo nuwanuwagu am wasa yaeyawa na kuyamaisa ala tautaubalao yoli sanaulu bwaite siya simiyamiyane manli mena. Tem nuwanuwam kuyamaisa-yavivila, ee uginauli. Na tem nige nuwanuwam, kuwalo, kaiwena yamaisa kana dudulai besiele bagubagunana kowa kabo muli mena yau.” Kabo tomone iwaloba, “Yau kani yayamaisa.” ");
INSERT INTO tteo_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Bowasa iwaloba, “Saugana bwatanone ugimwala Naomi koina ee kabo tabe besiele Ludi Mowabe sinena, iya Malona kwabukwabulina, kani ukwalai ugite-kalatan kabo bwatano imiyamiyaya toboita esana koina yo ana susuyao esali kolili.” ");
INSERT INTO tteo_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Taubalane iwaloba, “Genuwagu bwatanone yayamaisa-yavivila kaiwena natuguwao bagubagunali nige sowasowali bwatanone sikalai. Na kowamo kuyamaisa.” ");
INSERT INTO tteo_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Bwaine sauganane koina tem Isileli bwatano yabo sigimwala o siyamaisa-yavivila, kani kilakilala yabo siginauli bwaite besiele. Toyamaisa-yavivila yawasosi kaena kana suma kani ikelegabaen yo iwolena miyalaena koina. Tem siginauli besiele, bwaimwa bwatano kana loina siginauliyako. ");
INSERT INTO tteo_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Kabo taubala bwaine yakato iya toyamaisa-yavivila yawasosi, iwalo Bowasa koina, “Kowa kuyamaisa.” Yo kaena kana suma ikelegabaen iwolena Bowasa koina. ");
INSERT INTO tteo_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Kabo Bowasa iwalolau toloinao yo tomone tomiyagogo kolili iwaloba, “Kaliyate kabona wagiteyako manimiu mena Elimileki yo natunao Kilion yo Malona ali bwatano meuloina yayamaisayako Naomi koina. ");
INSERT INTO tteo_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Besiele Ludi, Mowabe sinena, Malona kwabukwabulina, yayamaisayako wainegu. Kabo taubalane toboitane ana bwatano imiyamiya esana koina yo ana susuyao esali kolili. Esana tabu ikwakwalalele susune yo yanuwane bwaite koina. Kaliyate kabona wagiteyako manimiu mena.” ");
INSERT INTO tteo_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Toloinao yo tomo meuloili siya simiyamiya yanuwane ali kaba miyagogo lusalusaena koina siwaloba, “O, walo yawasosi, kagitaiyako manimai mena Elimileki yo natunao Kilion yo Malona ali bwatano meuloina kuyamaisayako Naomi koina. Kani kakawanoi Yeoba koina wainem besiele Litieli yo Leya, siya sikabikabi kabo Yakobo natunao sibaibaiwa. Sowasowana kuyamala boda Epalati kana towasawasa yo esam ilalaki Bedeliema kalona mena. ");
INSERT INTO tteo_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Tabe besiele inamwanamwa tem natumiyao siya Yeoba iyeliwa sibaibaiwa besiele tubula Pelesi natunao, Pelesi iya Yuda yo Tama natuli.” ");
INSERT INTO tteo_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Kabo Bowasa Ludi ikalai wainena. Yeoba Ludi iwalo-muloloi isiuma yo ikabi natuna tau. ");
INSERT INTO tteo_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Kedukedulumao siwalolau Naomi koina siwalo, “Tatobali Yeoba koina, kaiwena kaliyate kabona tubum iyeyawa iya naga ilalaki kani igite-kalatagiwo. Kakawanoi Yeoba koina na melumelu bwaite kani esana ilalaki Isileli kalona mena. ");
INSERT INTO tteo_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Naomi, lawam imulolo koliwo yo ana sagu koliwo ilalakisosi. Gubesi, tem beyabeyana natumwao tatao yoli seben ukwabili, ali sagu ilalaki besiele lawam ana sagu? Nuwana nigele. Kabo kaliyate kabona tubum yabo iyeyawa na iya kani ikabi-yaliyaya-yagiwo yo igite-kalatagiwo am sauga belu koina.” ");
INSERT INTO tteo_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Kabo Naomi melumelune ikalai ipei kaena mena yo igite-kalatan. ");
INSERT INTO tteo_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Bwagana melumelune iya Naomi tubuna na kedukedulumao siwaloba, “Naomi natuna ipaganko”, kaiwena siyaliyaya lalakina Naomi kaiwena. Yo melumelune esana sipei Obedi. Obedi natuna Yese, yo Yese natuna Deibida. ");
INSERT INTO tteo_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Pelesi tubunao wasali bwaite besiele, Pelesi natuna Esilon, Esilon natuna Lama, ");
INSERT INTO tteo_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Lama natuna Aminadaba, ");
INSERT INTO tteo_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadaba natuna Nason, Nason natuna Salimon, ");
INSERT INTO tteo_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salimon natuna Bowasa, Bowasa natuna Obedi, ");
INSERT INTO tteo_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obedi natuna Yese, Yese natuna Deibida. ");
INSERT INTO tteo_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Tomo yabo esana Elekana ilaomaya yanuwa Lama, boda Ipeleim ali dedei mala koyakoyana koina. Elekana tamana esana Yeloama. Yeloama tamana esana Eliu, Eliu tamana esana Tou, na Tou tamana esana Supi. Siya kali kulutubu ilaomaya susu Ipeleim koina. ");
INSERT INTO tteo_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Elekana wainenao labui, yabo esana Ana yo yabo esana Penina. Kabo Penina ikabikabi natunao sipagan na Ana imiyayai nige ikakabi. ");
INSERT INTO tteo_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Bolime kaigeda kaigeda mewainenao yo natunao ali yanuwa mena sitolo yo sisaesae yanuwa Sailo koina sabi tapwalolo na sipwaoli Yeoba Tokaiwesosi koina. Yo yanuwane bwaine koina Ilae menatunao tatao yoli labui Opini yo Peniyasi siya topwaoli Yeoba kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Tem kaliyatenane koina Elekana pwaoli igabu bulumakau o nuwana sipi kabo kekan kana sauga mena Penina me natunao kali wau buluma isoiyan kolili sinesineo yo tatao. ");
INSERT INTO tteo_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Bwagana Ana nige ikakabi na iyamo Elekana imulolososi koina mwa ana soi koina wau lalakina iwolewolena koina. ");
INSERT INTO tteo_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Ana diyana mena melumelu ana kaba keno Yeoba ikausi mwa iya kaiwena Penina sauga meuloina italatalawasiyan kabo Ana me ana nuwanae. ");
INSERT INTO tteo_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Mumuga bwaite sauga meuloina iginaginauli bolime kaigeda kaigeda kolili. Penina ikaiwanan-kalatan Ana ana miyayai kaiwena saugana tem sisae Sailo sabi tapwalolo yo sabi pwaoli Yeoba ana nume tabu mena. Kabo Ana ivalam yo genuwana kekan. ");
INSERT INTO tteo_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Kabo wainena Elekana ineli Ana koina iba, “Ana, tawae kaiwena mwa kuvalavalam? Na tawae yaina nige ukwekekan? Yo tawae kaiwena katem ikamkamna? Yau yamulolososi koliwo yo yagu mulolo kaiwem kana nuwanuwatu ilalakisosi. Na nige ukwakatai yagu mulolo kaiwem ilalakisosi kaiwena yau wainem. Bwaite inamwanamwasosi kabo muli mena natumwao tatao yoli sanaulu kali mulolo.” ");
INSERT INTO tteo_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","Pwaoli kanna mena sikekan yo sinuma imwawasi mulina mena Ana itolo yo ilau ikawanoi. Na Ilae topwaoli iyaele imiyasio ana kaba miya mena nume tabu gamwana kana tuki salina mena. ");
INSERT INTO tteo_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","Yo Ana yaluyaluwana inuwanae molosi saugana Ana ikawanoi Yeoba koina me ana valam. ");
INSERT INTO tteo_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Kabo ikawalulu-sae Yeoba koina iwaloba, “O Guyau Tokaiwesosi tem manimmo ilobima am topaisowa koina yo kunuwatu-kalatagau na tabu nuwam imwamwatainagau yagu nuwapolowe ugitaiyako yo yagu kawanoi kubenalan na tem natugu tauna yabo kuyeyama. Mwa tabe kani yayapileyoiyawa koliwo yawasina kana sauga meuloina koina. Na kani kayakasisiyan kaiwem nige sowasowana nabuka kayapaisowa na itona kayali-gabaen.” ");
INSERT INTO tteo_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Saugana Ana iyaelemo ikawakawanoi Yeoba koina kabo Ilae manna ilau Ana sopana imanmankulakulai. ");
INSERT INTO tteo_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Na Ana nuwana mena ikawakawanoi kabo sopana imwasamwasali nige sowana kainana sibenalan mwa Ilae ana nuwatu mena yakato Ana inuma-yauyaule. ");
INSERT INTO tteo_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","Kabo Ilae iwalolau Ana koina iba, “Sauga esana koina kabo numa kulopei? Na am numane kana kamwasa ugwabaen.” ");
INSERT INTO tteo_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Na Ana iwaloba, “Nigele molosi, yagu taubala, nige oine o waila yabo kaikaiwena yanunuma. Na iyamo yau bwaite sinegune polowe lalakisosina iyaele koliyau imiyamiya koinaele kategu kana polowe nuwanuwagu yawalo-masalan Yeoba koina. ");
INSERT INTO tteo_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Kisi kubatoko yakato yau am topaisowa yabo yauyaulena. Na nigele, iyamo kategu ikamkamnasosi yo meyagu nuwanae mwa koinaele bwaite yakawakawanoine.” ");
INSERT INTO tteo_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Kabo Ilae Ana kainana iyamaisa iba, “Me am nuwadaumwali kulau. Mwa kani yakawanoi Yeoba koina, kita Isileli ala Yaubada, na iyeyawa koliwo besiele tawae am nuwatune ukawanoiyan koina.” ");
INSERT INTO tteo_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Yo Ana iwalolau Ilae koina iba, “Taubala, sowasowana sauga meuloina am kawa-namwanamwa ilaoma koliyau.” Kabo Ana ilau yo ikekan me ana yaliyaya, ana nuwanae imwawasi. ");
INSERT INTO tteo_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Kabo malala mena sikeno-tolo yo sitapwalolo Yeoba koina yo kabo sipileyoi ali yanuwa Lama koina. Bwaine koina mwa Elekana me wainena Ana sikeno-labui yo Yaubada Ana ana kawanoiwa iyamaisa besiele ana nuwatu. ");
INSERT INTO tteo_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Kabo Ana ana sauga siuma yawasosi ilobai mwa ikabi natuna tau yo esana ipei Samuela kaiwena iwaloba, “Yakawanoi Yeoba koina mwa iyeyama.” ");
INSERT INTO tteo_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Pwaoli bolime kaigeda kaigeda siginaginauliwa kana sauga ilobaiyoi kabo Elekana me ana susu sisaeyoi yanuwa Sailo sabi pwaoli Yeoba koina yo tabe yaboyoi tauna kona ana waloyameliwa iginauli besiele. ");
INSERT INTO tteo_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Sauganane koina Ana nige isasae mekanakavao. Iwalolau wainena tau koina iba, “Yau kani nige yalalaowa mekamikava tasasae kanasiga melumelune susu yayasikotanan. Bwaimwa koina kabo yaolena-gabaen Yeoba koina na ipaisowa yawasina kana sauga meuloina koina.” ");
INSERT INTO tteo_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Mwa Elekana iwalolau wainena Ana koina iba, “Tem tawae kunuwatui inamwanamwasosi koliwo uginauli besiele. Naga kumiyamiya kanasiga melumelu ilalaki yo susu kuyasikotanan. Kabo yakawanoi Yeoba isaguiwo na am waloyameliwa iyamala yawasosi.” Mwa Ana imiya-pileyoi natuna igite-kalatan. ");
INSERT INTO tteo_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Saugana susu iyasikotanan kabo sinana yo tamana siseyan Sailo Yeoba ana nume tabu mena. Tabe bulumakau tauna kaigeda ana bolime yaiyona yo besiele pwalawa kana lalaki besiele 10 kilogelam yo oine silokalai ali pwaoli kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Yo bulumakau siunui kabo sipwaoliyan Yeoba koina, muli mena melumelu Samuela silawan Ilae koina. ");
INSERT INTO tteo_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Kabo Ana iwalo Ilae koina iba, “Taubala, tauna kona yau mwa ugitaiyau yatolo yakawakawanoi Yeoba koina. ");
INSERT INTO tteo_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Yakawanoi melumelu bwaite kaiwena kabo yagu kawanoiwa maisana iyaele Yeoba iyeyamako koliyau besiele. ");
INSERT INTO tteo_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Koinaele sauga kabona yayapileyoi koina, iyamala ana topaisowa iya kaiwena yawasina meuloina koina.” Kabo bwaine koina sitapwalolo Yeoba koina. ");
INSERT INTO tteo_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Kabo Ana ikawanoi iwaloba, “Kategu iyaliyaya molosi Yeoba koliwo yagu kaiwe kowa koliwo ilaoma. Yawalo gagasa kagu tokalomagigiliwo kolili, yayaliyaya kaiwena kuleboiyau. ");
INSERT INTO tteo_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","Kowa Yeoba tabu na yakasisi nige besiele yaiya yabo yo nige yaiya yabo mumugana besiele kowa yo tabe nige veku yabo kaikaiwena besiele kowa kai Isileli ama Yaubada. ");
INSERT INTO tteo_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","Kagu tokalomagigiliwo kolili yawalo yaba, ‘Ami walo-gagasa kwalopei yo walo saesae besi.’ Kaiwena Yeoba iya Yaubada ginauli meuloina iyamo ikataisosi mumugala yo ala paisowa meuloina iliyeiliko. ");
INSERT INTO tteo_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","Tokaleya kaikaiweli meuloina ali gipoyo iyegolu-wagili na siya tobelu ikabi-yakaiweli. ");
INSERT INTO tteo_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Siya tauna kona simasuli yo sikekan diyali isu sauga kabona siguliyam lalakina. Siya tauna kona siguliyam sauga kabona diyali isu. Sinene iya tauna kona imiyayai sauga kabona melumeluwo kali baibaiwa seben igite-kalatagili. Na iya sinene tauna kona natunao gwauli sauga kabona siboita oliko mwa iya kabona nige kana togite-kalatani. ");
INSERT INTO tteo_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","Yeoba iya yawasi kana toeyawa yo iya tabe yawasi kana tokele-yavivilayoi. Tupwali ilobi-yegili salai mena na tupwaliyao ikele-yatololi. ");
INSERT INTO tteo_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","Tomo tupwaliyao iyabubutumali yo tupwaliyao iyawasawasali. Tupwali ipei-yataluli silobi molosi na tupwaliyao ipei-seyagili sisae molosi kaba miya kewa mena koina. ");
INSERT INTO tteo_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Yo tabe Yeoba tomo tupwali ikele-yatololima bwatano kauna luwana mena yo ikeleisinagilima ali miya polowe mena kabo ali kaba miya ikatububunagili besiele kin natunao yo ipeili kaba miya wasawasana mena. Kaiwena yanuwa yaulina kana wauwau yo dedeina meuloina yo gogona meuloina iya ana gogo iya ipeili ali kaba miya mena simiya yo tabe kali loina iwolegili. ");
INSERT INTO tteo_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Yeoba ana tomo yakayakasisiliyao igite-kalatagili na siya pwanoli mumugana siginaginauli kani silau simiya boniboniyai luwana mena. Nige sowana yaiya yabo ibomamo ana kaiwe mena ibaguna. ");
INSERT INTO tteo_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Siya analiyao Yeoba sikalomagigilan Yeoba kani isibayanaeli. Kani bulibuli mena kainana ipei besiele tutu koina iyamaisali yo Yeoba yanuwa yaulina kana tomiya meuloili iyatalayagili. Na kaiwe kani iwolena ana kin koina, ana yaoyaolo tomonna ana kaiwe iyalalaki.” ");
INSERT INTO tteo_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Kabo Elekana mewainena Ana sipileyoi Lama, ali yanuwa mena. Na natuli game Samuela sipei-gabaen bwaine koina iyamala topaisowa Yeoba kaiwena Ilae topwaoli ana loina yaulina mena. ");
INSERT INTO tteo_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","Ilae natunao tatao labui Opini yo Peniyasi Yeoba nige siyayakasisi-yan mwa mumugali yo ali paisowa nige inanamwanamwa. ");
INSERT INTO tteo_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","Pwaoli bulumana siya topwaoli kaiweli kana loina nige simumuliya. Saugana tem tomo yabo ana pwaoli ikalaiyama ipwaoliyan Yeoba koina yo bulumana siliga kekan kaiwena, Opini yo Peniyasi nige sowasowana sisana kabo kali wau sisoiyan kolili. Na nigele, kani ali topaisowa yabo siyawasa ilau sisimwa lalakina manna yaiyona ikalai yo ilau. ");
INSERT INTO tteo_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","Isisimwa-lobiyen gulewa kalona mena saugana tem wau yabo isisimwa-lobai ikalai ilau topwaoli yoli labuine kaiweli. Siya boda Isileli meuloili tem silau Sailo yo sipwaoli Yeoba koina Ilae natunao sipaipaisowai mumugali besiele sauga meuloina. ");
INSERT INTO tteo_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","Naga gilisi sigabu-gabaen na topwaoli ali topaisowa siyawasa ilau na iwalo tomone koina pwaoli ipwaoliyan iba, “Buluma kilaina kuyeyama na topwaoli sigabu sibomamo siya kaiweli, kaiwena genuwali buluma kuligayako na koina sikekan.” ");
INSERT INTO tteo_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","Na tem tomo yabo iba, “Nigele, gilisi tagabu bagunayan Yeoba koina na muli mena tawae nuwanuwamiu wakalai” kani topaisowa iwaloba, “Nigele, saugamo kuyeyama koliyau. Tem nigele, kani yau yaboma yakwayai yakalai.” ");
INSERT INTO tteo_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","Mwa Ilae natunao ali yauyaule ilalaki Yeoba manna mena kaiwena nige ali yakasisi Yeoba ana pwaoli kaiweli yo sauga meuloina topwaoli ali loina silikwaili. ");
INSERT INTO tteo_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","Na Samuela topwaoli kana kaleko esana ipodi ilikwa na ipaipaisowa Yeoba koina. ");
INSERT INTO tteo_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Bolime kaigeda kaigeda sinana Ana kana kaleko ikona besiele Samuela saliyana kana liye. Mwa bolime kaigeda kaigeda Ana me wainena Elekana sisaema na bolime kana pwaoli siginauli Yeoba koina. Imwawasi kabo kaleko waluwaluna sinene ikonayako ilawan natuli koina. ");
INSERT INTO tteo_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Muliya kabo Elekana me wainena sipileyoi ali yanuwa mena Ilae iwalo-muloloili yo iwalo Ana koina iba, “Yakawanoi Yeoba iwalo-muloloiwo na kusiumayoi yo melumelu tupwali yoi ukwabili kabo melumelune Samuela kwaolena-gabaenne Yeoba koina siyamiyalae.” ");
INSERT INTO tteo_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Mwa Yeoba Ana iwalo-muloloi yo muli mena melumelu tatao yaiyona yo sinesineo labui ikabili. Na Samuela ilalalaki Yeoba ana nume mena. ");
INSERT INTO tteo_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","Na Ilae ana bolime sibaibaiwa yo natunao ali yauyaule paisowana Isileli meuloili kolili wasana ibenalan. Tabe sibenalan yakato siganaganawali sinesineo mekalikavao siya analiyao sipaipaisowa nume tabu kaba lusalusaena koina. ");
INSERT INTO tteo_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","Kabo Ilae iedeedede kolili iba, “Tawae kaiwena paisowa naenaena bwaite kwapaipaisowaili? Tomo sibaibaiwa yagu wasa siyeyama kaiwemiu. ");
INSERT INTO tteo_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","Kabo natuguwao, mumuga bwaite kwalopei. Yeoba ana tomoyao wasamiu sibenalan inae nige inanamwanamwa. ");
INSERT INTO tteo_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","Tem tomo yabo ilopwano kanakava koina sowasowana kala toloina Yeoba tomone iyadudulai. Na tem tomone ilopwano Yeoba koina nige yabo sowasowana tomone isagui.” Na Ilae natunao tamali ana yokoi nige sibebenalan, kaiwena Yeoba ana nuwatu yakato kani iunuyamateli. ");
INSERT INTO tteo_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","Na gamene Samuela ilalalaki yo Yeoba yo tomo meuloili siyaliyaya iya kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","Kaliyate yabo koina palopita yabo ilau Ilae koina yo iwaloba, “Yeoba iwalo bwaite besiele iwaloba, ‘Saugana Isileli simiyamiya Itipita ali kin ana loina yaulina mena yaboma yayakenayagau tubum Eloni yo ana susuyao kolili. ");
INSERT INTO tteo_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","Isileli susu meuloili kolili Eloni yagite-sipwai iyamala yagu topwaoli na yakayakan ipwaoli-yagili kaba pwaoli pwatana mena, inisensi igabuli yo topwaoli kana kaleko ilikwa esana ipodi yo itolo manigu mena. Tabe yatalam tubum Eloni ana susu yakayakan waunao tupwali sikanli siya tomo Isileli sikalailima ali pwaoli kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","Tawae kaiwena komiu nige ami yakasisi yagu pwaoli paisowana kaiwena? Am yakasisi natumwao kaiweli ilalaki kabo muli mena yau. Yakayakan bulumana wauna namwanamwaliyao wakekakekan mwa kwasinibusosi. ");
INSERT INTO tteo_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","Koinaele yau Yeoba komiu Isileli ami Yaubada baguna yawaloyameli yakato am susu kani sauga meuloina kwaemala yagu topwaoliyao. Na sauga bwaite koina nigele. Siya siyakasisi-yagau kani yayakasisi-yagili na siya esagu sisibayanae kani yasikotanagili. ");
INSERT INTO tteo_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","Kikiunamo kani am kaiwe yakele-gabaen yo ami tatao yaemwawasili. Kani nige tubum yabo ililike. ");
INSERT INTO tteo_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","Polowe sibaibaiwa kani siyawatagili am susu koina. Yagu walo-mulolo kani yasoiyan Isileli kolili na ugitai kabo me am lamwapolowe. Na nige yabo kolimiu kani ililike, nige yabo ana bolime ilalalaki. ");
INSERT INTO tteo_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","Kani tubumwao nige yabo sipepei iyamala topwaoli mwa siya kani sauga meuloina me ali nuwanae me ali valam yo mataliloliyao sididididi yo tubumwao meuloili ali sauga kaiwe mena kani siboitaoli. ");
INSERT INTO tteo_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","Natumwao Opini yo Pineyasi kani siboita kaliyate kaigedana koina na bwaite kani iyamala kilakilala yabo kaiwem yakato ginauli meuloina yawalowen koliwo kani iyamala yawasosi. ");
INSERT INTO tteo_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","Topwaoli yabo kani yayatolo iya sowasowana yagu meli yapei koina yo iginauli besiele kategu ana nuwatu. Tubunao kani yaolena koina na siya kani sipaisowa yagu kin iya yagu yaoyaolo tomonna manna mena. ");
INSERT INTO tteo_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","Na tubumwao, siya nige siboboita, meuloili kani silau topwaoline kolili yo sikawanoi mane yo kan kaiweli. Kani sikawanoi samasamalulu tem sitalam topwaoliyao isaguili na mesabana kan yabo ikan.’” ");
INSERT INTO tteo_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Game Samuela iyamala topaisowa Yeoba kaiwena Ilae ana loina yaulina mena. Bwaine saugaliyaone kolili Yaubada ana yakeyakenayan naga simamayale yawasosi kolili yo kainana boda Isileli nige sibebenali-yadudulai. ");
INSERT INTO tteo_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Ilae manna ibelu ilaulau kaiwena itautaubala koinaele nige sowana ginauli yabo igite-namwanamwai. Boniyai mena ana kaba keno mena ikenokeno. ");
INSERT INTO tteo_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Na game Samuela iguli-talu ikeno nume tabu kalona mena Yeoba ana kelabilabin kamwasana kana dedewaga kaba peina salina mena. Na malala boniboniyaina nume tabu kana mayale nige naga siyuyui-yamateli. ");
INSERT INTO tteo_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","Kabo Yeoba iyoga iba, “Samuela.” Mwa kainana iyamaisa iba, “O, yau elete.” ");
INSERT INTO tteo_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Yo itolo isagena ilau Ilae koina iwaloba, “Taubala kuyogayoga kaiwegu, yau elete.” Na Ilae Samuela kainana iyamaisa iba, “Yau nige yayoyoga, kupileyoi kulau ukeno.” Yo ipileyoi ilau iguli-talu ana kaba keno mena. ");
INSERT INTO tteo_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Yo Yeoba iyogayoi iba, “Samuela.” Yo tabe Samuela itoloyoi isagena ilau Ilae koina iba, “Taubala, kuyogayoga kaiwegu, yau elete.” Tabe Ilae iwaloyoi iba, “Natugu, yau nige yayoyoga koliwo kupileyoi kulau ukeno.” ");
INSERT INTO tteo_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Na Samuela nige naga Yeoba ikakatai kaiwena nige sauga yabo iwawalolau koina na mesabana ikatai. ");
INSERT INTO tteo_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Mwa tabe Yeoba iyogayoi yaiyonana yo tabe Samuela itoloyoi ilau Ilae koina iba, “Taubala yau elete, kuyogayoga kaiwegu.” Bwaine koina kabo Ilae nuwana imayale yakato Yaubada iyogayoga Samuela koina. ");
INSERT INTO tteo_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Mwa Ilae iwalolau Samuela koina iba, “Kupileyoi kulau ukeno. Tem iyogayoi na esam ikataiyoi kutalam kuba, ‘Guyau kuwalo, am topaisowa ibenabenali.’” Mwa tabe ipileyoi ana kaba keno mena. ");
INSERT INTO tteo_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Tabe Yeoba ilaoma yoi Samuela salina mena iyoga besiele tauna kona iba, “Samuela, Samuela.” Kabo kainana iyamaisa iba, “Kuedeedede am topaisowa iyaele ibenabenali.” ");
INSERT INTO tteo_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Kabo Yaubada iwalolau Samuela koina iba, “Ugitai kani ginauli yabo yaginauli Isileli kalona mena yo sibomamo wasana sibenalan tenali mena na kateli iula-wakawakaka. ");
INSERT INTO tteo_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Sauganane koina ginauli meuloina yaloinayanako Ilae ana susu kaiweli kani yaginauli. Kaba yatubu koina yo ilau ana kaba mwawasi koina kani yaginauli besiele. ");
INSERT INTO tteo_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Iyaele yawaloko koina ali pwanoli maisana kani nige yanunuwa-gabaen kani yaginaginauli-kalatan ana susu kolili kaiwena natunao mumugali manigu mena inaesosi. Ilae igitailiko yo ikatailiko na iyamo natunao nige iguguguyaili. ");
INSERT INTO tteo_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Yo yakawalulu Ilae ana susu kaiweli nige sowana nuwatu-pwaiki silobai pwaoli paisowana koina o nuwana olena-gabae mulolona yabo koina na ali pwanoline yanuwa-gabaen.” ");
INSERT INTO tteo_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Samuela ikeno-talu kanasiga ilayan gwaligwali malala kikiuna itolo yo Yeoba ana nume kana gamwa isokeli. Iyamo imatausi walolau Ilae koina saugana Yeoba tawae iwalowegili koina, kaba gitene kaiweli. ");
INSERT INTO tteo_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Na Ilae iyoga Samuela koina iba, “Samuela natugu.” Kabo Samuela iba, “O, yau.” ");
INSERT INTO tteo_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Yo Ilae inelilau koina iba, “Tawae Yeoba iwalowen koliwo? Kisi yabo kuwadam koliyau. Tem Yeoba ana walo yabo kupei-wadam koliyau kani maisa polopolowena iyeyawa koliwo.” ");
INSERT INTO tteo_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Mwa Samuela Yeoba kainana meuloina iwalo-masalan Ilae koina nige yabo ipepei-wadam. Yo Ilae iba, “Walo yawasosi iya Yeoba tem nuwanuwana ginauli inamwanamwa manna mena kani iginauli besiele ana nuwatune.” ");
INSERT INTO tteo_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Kabo Samuela ilalaki isaesae yo Yeoba mekanakava na ana walo meuloina iwalowegili nige yabo iyayamala walo bwagabwaga. ");
INSERT INTO tteo_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Na Isileli meuloili iyatubuya susu Dani ali dedei mena ilau kanasiga tete yavana Biyasiba ana dedei mena sikatai Samuela iya Yeoba ana palopita yabo. ");
INSERT INTO tteo_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Yo Yeoba iyatubu iyawayawatagili Samuela koina yanuwa Sailo koina yo kainana iwalowalo-masalan tomo Isileli kolili. ");
INSERT INTO tteo_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","Sauganane koina Isileli ali tokaleyayao sikatububu-nagili na siyawatagili Pilistiya mekalikavao sikaleya. Isileli sigogoya Ebensa na Pilistiya sigogoya Apeki koina. ");
INSERT INTO tteo_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","Kabo Pilistiya ali tokaleyayao siyawatagili Isileli mekalikavao sielobelobe yo sikaleya. Kaleya ikaiwesosi, na iyamo Pilistiya sikaiwesosi mwa Isileli tokaleya kali baibaiwa powa tausan (4,000) siboita Pilistiya nimali mena. ");
INSERT INTO tteo_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","Saugana Isileli tokaleyayao tupwali sipileyoi ali kaba gogo mena kabo tokaleya ali tobagunao sibomayoi sienelineli-yagili siba, “Tawae kaiwena Yaubada italam Pilistiya sikaiwe-gabaegila kabona?” Muli mena siba, “Kani talau Sailo na Yeoba ana kelabilabin kamwasana kana dedewaga takewaiyama mekalakava talau kaleya mena na Yeoba ileboila kala kaleyayao nimali mena.” ");
INSERT INTO tteo_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","Yo tatao tupwaliyao siyawasali silau Sailo Yeoba ana kelabilabin kamwasana kana dedewaga sikewaiyama iya Yeoba Tokaiwesosi imiyasio kewa mena selubima labui pepeliyao luwaluwalili mena. Na Ilae natunao labui Opini yo Peniyasi mekalikava dedewagane sikalaiyama. ");
INSERT INTO tteo_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","Saugana sikalaiyama ali kaba gogo mena kabo boda Isileli meuloili siwui kainali lalakina mena mwa bwatano itabubu. ");
INSERT INTO tteo_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","Na Pilistiya sibenalan wui lalakisosina kabo sineli siba, “Gubesi mwa tomo Ibeliu siwuiwui kainali lalakina koina?” Mwa kabo ali wasa siwolegili siba, “Yeoba ana kelabilabin kamwasana kana dedewaga sikalaiyama iyaele ali kaba gogo mena.” ");
INSERT INTO tteo_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","Iya kaiwena kabo simatausi lalakina yo siba, “Bwaimwana yaubada yabo sikalaiyama ali kaba gogo mena sipei. Kabo kita tanaeko. Kamwasa bwaine tauna kona kita kolila nige iyayawatagili. ");
INSERT INTO tteo_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","Yaiya kani isasaguilane bwaine yaubadaone tokaiwesosine nimali mena? Siya bwaine yaubadaone tauna kona tomo Itipita siunuili kaba nae uloina uloina kolili dedei leleyanna mena.” ");
INSERT INTO tteo_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","Kabo Pilistiya ali tobagunao siwalo kaiwe ali tokaleyayao kolili siba, “Wakaiwe. Tem kwabelu kani Ibeliu sikalaila ali topaisowa panpanna gamwali tokabina kita besiele siya tauna kona takalaili ala topaisowao. Koinaele wakaiwe me ami katepatu.” ");
INSERT INTO tteo_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","Kabo Pilistiya sikaiwesosi kaleyane koina mwa boda Isileli sikaiwe-gabaegili. Kabo Isileli tokaleyayao kali baibaiwa teti tausan (30,000) siunuyamateli yo sibaibaiwa me ali matausi siyabubu. ");
INSERT INTO tteo_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","Yo tabe Pilistiya Yeoba ana kelabilabin kamwasana kana dedewaga sikwayai Isileli nimali mena yo tabe Ilae natunao tatao labui Opini yo Peniyasi siunuyamateli. ");
INSERT INTO tteo_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","Kaliyate kaigedanane koina tomo yabo iyabubu kaba kaleya mena ilaoma yanuwa Sailo. Na tomone iya susu Beniyamina me ana nuwanae lalakina mwa kana kaleko itabei-gaigalili yo bwatano igagalo kulukuluna mena isuwai. ");
INSERT INTO tteo_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","Saugana iyawatagili na Ilae iyaele imiyasio ana kaba miyasio mena kamwasa papalina mena isanasana katena iwakaka kisi nae yabo iyawatagili Yeoba ana kelabilabin kamwasana kana dedewaga koina. Na tomone saugana ilusaema yanuwa kalona mena kaleya wasana iedeededeyan. Mwa tomo meuloili siyatubu sivalam kainali lalakina mena. ");
INSERT INTO tteo_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","Ilae kaina lalakinane ibenalan yo ineli iba, “Tawae yabo ilaulau, mwa koinaele tomo sivalam kainali lalakina mena?” Kabo tomone mwayamwayau mena ilau Ilae koina. ");
INSERT INTO tteo_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","Na Ilae ana bolime naenti eit (98) ilobaiyako yo tabe manna inae nige sowana ginauli igite-namwanamwaili. ");
INSERT INTO tteo_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","Yo tomone iwalolau Ilae koina iba, “Yau kabona kaleya luwana mena yayabubu yalaoma.” Yo Ilae ineli koina iba, “Na natugu, tawae iyawayawatagili?” ");
INSERT INTO tteo_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","Tabe tomone Ilae kainana iyamaisa yoi iba, “Kita Isileli ala tokaleyayao siyabubu Pilistiya kolili yo tabe sibaibaiwa siunuyamateli. Yo natumwao tatao labui Opini yo Peniyasi ali sauga simwawasi. Tabe Yeoba ana kelabilabin kamwasana kana dedewaga sikalaiyako.” ");
INSERT INTO tteo_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","Ilae imiyasio ana kaba miyasio mena yanuwa kana gamwa salina mena. Saugana dedewaga wasana ibenalan kaba miyasio mena ibeku-keile dagelana italutaluwan bwatano mena lomalomana ikosompwai iboita kaiwena itautaubala yo isinibusosi. Na Ilae Isileli ibagunayagili bolibolime poti (40). ");
INSERT INTO tteo_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","Ilae natuna Peniyasi wainena isiuma yo ana kabi ikelakelakubwa. Saugana wasa ibenalan Yeoba ana kelabilabin kamwasana kana dedewaga kaiwena yo lawana taubala Ilae kaiwena yo wainena Peniyasi iboita kabo melumelune sinana diyana kalona mena manna iyalala kabo sinene kabi kana kamkamna iyatubu ilalakisosi koina. ");
INSERT INTO tteo_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","Muliya kabo yawasina ilopei ana tokabikabi yaisu sinesineo siwalolau koina siba, “Ukwaiwe, ugitai natum tauna iyaele ukabiyako.” Na iyamo nige ibebenali kolili mwa nige kainali iyayamaisa. ");
INSERT INTO tteo_vpl VALUES ("S14_21","010_4_21","1SA","4","21","22","Saugana melumelune ilaoma mayale mena sinana esana ipei Ikabodi iba, “Kita Isileli Yeoba ana wasawasa ilogabaegilako.” Iwalo besiele kaiwena Yeoba ana kelabilabin kamwasana kana dedewaga iyaele sikalaiyako yo tabe lawana Ilae yo wainena Peniyasi siboitako. ");
INSERT INTO tteo_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","Siya Pilistiya Yeoba ana kelabilabin kamwasana kana dedewaga sikalai yo sikewai yanuwa Ebensa koina silawan Asidodi siya ali yanuwa lalakina yabo. ");
INSERT INTO tteo_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","Yo sikele-luseyan ali yaubada esana Deigon ana nume tapwalolo kalona mena yo sipei kokotomone Deigon salina mena. ");
INSERT INTO tteo_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","Sikeno yanuwa ilayan malala kikiuna yanuwane tomonliyao sikeno-tolo silau numene silusae sigitai kokotomone ibeku ilobi italu-pwaopwaom bwatano mena dedewagane manna mena. Mwa sikalaiyoi sipeiseyan ana kaba miya mena. ");
INSERT INTO tteo_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","Tabe sikenoyoi yanuwa ilayan malala kikiuna sitolo sigitai ibekuyoi ilobi italu-pwaopwaom yoi dedewagane manna mena. Kulukuluna yo nimana labui sitagolu yo simiyamiya gamwa kaba lusalusae mena na yonamo yo kaena situpwa simiyamiya. ");
INSERT INTO tteo_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","Na bwaite saugane koina tem Deigon ana topwaoliwo silusae ana nume tapwalolo Asidodi koina nige sowana siutulau ana kaba talu mena na siutu-likwai. ");
INSERT INTO tteo_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","Yeoba nimana kaikaiwena mena Asidodi meuloili isibayanaeli kasiebwa baliyan kaposa koina iunuili yo tabe siya simiyamiya Asidodi gana mulina mena iunuili tabe. ");
INSERT INTO tteo_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","Kabo Asidodi tomonliyao sigite-lobai tawae iyawatagili kolili mwa siba, “Tabu Isileli ali yaubada ana kelabilabin kamwasana kana dedewaga imiyamiya kolila. Iyaele ana kaiwe tagitaiyako kita yo ala yaubada Deigon kolila.” ");
INSERT INTO tteo_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","Yo Pilistiya ali yanuwa lalakili kana toloinao meuloili siyoga silaoma sineli kolili siba, “Tawae kani taginauli Isileli ali yaubada ana kelabilabin kamwasana kana dedewaga koina?” Kainali siyamaisa siba, “Wakalai kwalau yanuwa Gata.” Kabo sikalai silawan yanuwa Gata koina. ");
INSERT INTO tteo_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","Kabo tomo meuloili siyatubu melumelu koina ilau kanasiga taubala yo keduluma koina Gata koina Yeoba iunuili baliyan kaposa koina. Mwa simatausi lalakina yo gamwapakiki lalakina iyawatagili bwaine koina. ");
INSERT INTO tteo_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","Tabe siyawasa ilau yanuwa Ekilon koina. Saugana sikele-luseyan yanuwa kalona mena siwui mayale siba, “Isileli ali yaubada ana kelabilabin kamwasana kana dedewaga sikalaiyama kolila. Nuwanuwali meuloila taboitaoli tamiyawa.” ");
INSERT INTO tteo_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","Na Pilistiya ali yanuwa lalakiliyao kali toloina lalakiliyao meuloili siwalo silogogoma yoi yo siwalolau kolili siba, “Isileli ali yaubada ana kelabilabin kamwasana kana dedewaga tayapileyoi ana kaba miya yawasosi mena kisimo kani meuloila iunuyamatela.” Ali nuwatu bwaine besiele kaiwena Yeoba ana kaiwe mena boita ilalaki ali yanuwa kalona mena. Mwa simatausi kabo yanuwane kalona mena talawauwau ilalaki molosi. ");
INSERT INTO tteo_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","Yo tabe besiele siya nige siboboita baliyan kaposa yoli sikalapowon mwa siyogasae ali yaubadao kolili na tem sileboili. ");
INSERT INTO tteo_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","Yeoba ana kelabilabin kamwasana kana dedewaga imiyamiya Pilistiya ali dedei mena waikena seben. ");
INSERT INTO tteo_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","Kabo ali topwaoliyao yo ali tokukula siwalo silaoma yo siwalolau kolili siba, “Kani tawae taginauli dedewagane koina? Nuwamai kwawalo-yasanapu na tayawasa-yapileyoi ana kaba miya yawasosi mena.” ");
INSERT INTO tteo_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","Kabo kainali siyamaisa siba, “Sowasowana kana mulolo tapei na tayapileyoi tabu yakato nige kana mulolo sowana mekana mulolo kaiwena ala pwanoli maisana. Na koina tagitai tem tanamwanamwa na bwaimwa koina takatai yakato iya ana kaiwe mena mwa igumgumyai kolila.” ");
INSERT INTO tteo_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","Mwa tabe sineliyoi kolili siba, “Toisabo mulolo kani tayawasa ilau Isileli ali yaubada koina ala pwanoli maisana?” Yo tabe kainali siyamaisa yoi siba, “Gole paibi (5) wakalaili kasiebwa baliyan kaposa kaiwena yo gimwau makamakayauna tabe paibi wakalaili siya Pilistiya toloinao paibi kaiweli, kaiwena siya yo kita kasiebwa kaigedana koina iunu-toyawaila. ");
INSERT INTO tteo_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","Kabo makamakayau labuine bwaite waginaulili kaiwena bwaite labuine siya mwa ala yanuwa sisibasiba-yanae. Bwaite kamwasane koina yakasisi taolena Isileli ali yaubada koina. Taginauli bwaine besiele na ilopei. Nuwana ali yaubada kani ikate-kamkamna-yagila na ana paisowa naenaena kolila ilopei kabo kita yo ala yaubadao yo ala yanuwa takaiyawasi kamkamna koina. ");
INSERT INTO tteo_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","Kwanuwatu-kalatan tauna kona siya Itipita mekalikava ali kin Pelo kateliyao sikololo mwa Isileli ali yaubada imunamunai iyakamkamnali kabo sitalamwagili siyawatagili Itipita silogabaen. Na tabu komiu katemiyao sikokololo besiele Itipita me ali kin. ");
INSERT INTO tteo_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","Waga niuniuli waluwaluna yabo waginauli. Yo bulumakau kabikabili labui waluwaluli nige naga kwayayapaisowali wakalaili. Yo bulumakaune kwapan-kalatagili waga niuniuline manna mena na natuliyaone kwayoganli kwalau kwapei-luseyagili kali gana kalona mena. ");
INSERT INTO tteo_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","Yo dedewagane kwatauli waga niuniuline koina. Yo tabe kokotomo gole wagiginauliliwa ala pwanoli maisanawa tabe wakalai kwatauli dedewaga yabo kalona mena yo kwapei-yasali kelabilabin kamwasana kana dedewagane salina mena. Kabo bulumakaune kabona kapapanliwa kwayawasali na waga niuniuline sibomamo siniuli silawan. ");
INSERT INTO tteo_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","Yo wagite-kalatan namwanamwaili. Tem na silodudulaimo Isileli yanuwana esana Betisemesi kaiwena bwaimwa koina takatai yawasosi Isileli ali yaubada iya mwa polowene naenaena iyeyama kolila. Na tem nigele takatai polowe bwaite iya nige igiginauli kolila na imayale bwagabwagamo kolila.” ");
INSERT INTO tteo_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","Kabo ali nuwatuwa meuloina siginauli besiele ali walone koina. Kabo waga niuniuli waluwaluna kaigeda siginauli yo bulumakau kabikabili labui waluwaluli sikalaili yo sipan-kalatagili waga niuniuli manna mena. Yo natuliyao sipei-luseyagili gana kalona mena. ");
INSERT INTO tteo_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","Yo Yeoba ana kelabilabin kamwasana kana dedewaga yo tabe muya baliyan kaposa kana kokotomo gimwau gole koina siginaulili me kana dedewaga tabe sitauliyoi waga niuniuli mena. ");
INSERT INTO tteo_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","Yo sidudulaimo kamwasa mena silau Isileli yanuwana esana Betisemesi. Silaulau na silolo-kulukulum natuliyaowa kaiweli na iyamo nige natuliyaone kaiweli sinuwanuwatu bwai silodudulaimo. Mwa tabe Pilistiya ali toloinao siyamuli kusulili kanasiga Betisemesi kana sigasiga mena siyawatagili. ");
INSERT INTO tteo_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","Na yanuwa Betisemesi ali tano sisepasepali ali witi sitomtomli kalogawa mena. Saugana manli sigabaen ilau dedewagane sigitai siyaliyaya lalakina. ");
INSERT INTO tteo_vpl VALUES ("S16_14","010_6_14","1SA","6","14","15","Kabo bulumakau waga niuniuli siniuliyama Yosuwa game Betisemesi ana witi tanona mena bwaine koina sitalu-tolo veku lalakina salina mena. Yo susu Libai sitolo yo Yeoba ana kelabilabin kamwasana kana dedewaga yo kokotomo gole kana dedewaga sikele-kaisulu-wagili veku lalakina pwatana mena. Kabo sitolo waga niuniuli kana gogo meuloina sikele-gwaligwali sisena pwaoli kana mayau, mwa bulumakau siunuili yo meuloina sipwaoli-yagili Yeoba koina. Kabo kaliyatenane koina Betisemesi tomonliyao yakayakan tupwaliyao sikalaili na sipwaoli-yagili Yeoba koina lolabin pwaolina. ");
INSERT INTO tteo_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","Kabo Pilistiya ali tobagunao yoli paibi (5) paisowane bwaine manli mena sigitai tabe kaliyatenane kaigeda koina sipileyoi yanuwa Ekilon. ");
INSERT INTO tteo_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","Yo baliyan kaposa makamakayauna gole paibi tomo Pilistiya sitatauliliwa waga niuniuline koina yakato yanuwa paibiwa kaiweli siya Asidodi, Gesa, Asikelon, Gata yo Ekilon, ali pwanoli kali nuwatu-pwaiki kaiweli. ");
INSERT INTO tteo_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","Besiele tabe gimwau makamakayauna gole siya yakato Pilistiya ali taon lalakili valigigi toloinao valigigi siloiloina-yagili kaiweli yo yanuwa kikiuli tabe kaiweli. Yo veku lalakinane Yosuwa ana witi tanona mena sauga kabona imiyamiya ali kaba nuwatu-kalatan tawae bwaine koina iyawatagili. ");
INSERT INTO tteo_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","Na Betisemesi tomonliyao tatao yoli sebenti (70) Yeoba iunuili siboita kaiwena manli ilau ana kelabilabin kamwasana kana dedewaga kalona mena. Mwa tomo nuwali sinae lalakina yo sivalam Yeoba ana paisowa kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","Kabo siwalo siba, “Nige tomo yabo sowasowana Yeoba manna mena itolo kaiwena iya Yaubada yakayakasisina. Na dedewagane toweya kani tayawasa ilauya na tem imiya suwala kolila?” ");
INSERT INTO tteo_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","Kabo tosagenawasa tupwaliyao siyawasali silau Kiliyati Diyelin tomonliyao kolili siwalo siba, “Pilistiya Yeoba ana kelabilabin kamwasana kana dedewaga siyapileyoi-yamako kwalaoma na wakalai kwalawan ami yanuwa mena kwapei.” ");
INSERT INTO tteo_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","Kabo tomo Kiliyati Diyelin silau Betisemesi koina Yeoba ana kelabilabin kamwasana kana dedewaga sikalai. Yo silawan Abinadaba ana nume mena imiyamiyawaya koya mena. Yo natuna Eliesa siloina yakato iya igite-kalatan. ");
INSERT INTO tteo_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","Sauga imamalawe nuwana besiele bolime kana baibaiwa tuwenti (20) Yeoba ana kelabilabin kamwasana kana dedewaga imiyamiya yanuwa Kiliyati Diyelin koina. Bwaine sauganane koina tomo Isileli sivalavalam Yeoba koina sagu kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","Kabo Samuela iwalolau boda Isileli kolili iba, “Tem nuwanuwamiu kwapileyoi Yeoba koina yanuwa wenalao ali yaubadao yo Asitate makamakayauna kwasikotanagili. Na kwatalam-wagimiu Yeoba koina na kwapwalou ibomamo koina ee kani ileboimiu Pilistiya nimali mena.” ");
INSERT INTO tteo_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","Kabo sitolo na yaubadao mwakomwakotali makamakayauli Baal yo Asitate sisikotanagili yo sipwalou Yeoba ibomamo koina. ");
INSERT INTO tteo_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","Yo Samuela iwalolau boda Isileli kolili iba, “Kwalogogo Mispa koina na yau kabo kani yakawanoi Yeoba koina kaiwemiu.” ");
INSERT INTO tteo_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","Mwa silogogo Mispa koina waila silegu yo sisuwe-yatalu bwatano mena Yeoba manna mena yo tabe guliyam sikalakisiyeyan kaliyatenane koina yo ali pwanoli siwalo-masalan siba, “Kalopwano Yeoba manna mena.” Yo sauganane koina Samuela iya Isileli ali tobaguna. ");
INSERT INTO tteo_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","Saugana Pilistiya wasa sibenalan yakato Isileli siyaele silogogo Mispa koina kabo ali toloinao valigigi mekalikavao ali tokaleyayao silau na tem sikaleyaili. Mwa Isileli wasa sibenalan simatausi yoi Pilistiya kolili. ");
INSERT INTO tteo_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","Kabo siwalolau Samuela koina siba, “Ukwawanoi-kalatan Yeoba ala Yaubada koina kaiwela na ileboila Pilistiya nimali mena.” ");
INSERT INTO tteo_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Kabo Samuela sipi natuna susususuna yabo ikalai iunui yo ipwaoliyan kaba pwaoli mena Yeoba koina. Yo ikawanoi samasamalulu me ana valam Yeoba koina Isileli kaiweli kabo Yeoba iginauli besiele ana kawanoiwa maisana. ");
INSERT INTO tteo_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","Samuela iyaelemo naga pwaoli igabugabu kaba pwaoli mena na Pilistiya tokaleyayao silaomako Isileli salili mena na sikaleyaili. Kabo Yeoba iwalo tutu daguguna lalakina mena itutu yo Pilistiya iko-yauyauleli nuwali sipwanopwano mwa Isileli siyabubu-gabaegili. ");
INSERT INTO tteo_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","Na Isileli ali tokaleyayao silaoma siyawatagili yanuwa Mispa koina mwa Isileli sitolo yo Pilistiya sisagena-yamuli kusulili yo siunuyamateli kanasiga yanuwa Betikali yaulina mena. ");
INSERT INTO tteo_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","Mwa Samuela veku yabo ikalai kabo Mispa yo Seni luwaluwalili mena ikumai. Yo iwalo iba, “Tauna kona yo ilaoma sauga kabona Yeoba isaguila koinaele veku bwaite esana tapei Ebensa.” ");
INSERT INTO tteo_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","Isileli sitolo mwa Pilistiya sikoya-mwanou molosagili mwa nige sipipileyoi silalau Isileli sikakaleyaili ali dedei mena kaiwena Samuela yawasina meuloina mena Yeoba nimana kaikaiwena imiyamiya koina mwa Pilistiya nige sowasowali Isileli sikaleyaili. ");
INSERT INTO tteo_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","Tauna kona Pilistiya Isileli ali yanuwa sikwayaili Ekilon yo Gata luwaluwalili mena na bwaite kaleyane koina mwa Isileli ali yanuwane yo dedei tupwaliyao tabe sikele-yapileyoili kolili. Yo tabe yanuwane salili mena tomiya siya Amoli mekalikavao Isileli simiya daumwali. ");
INSERT INTO tteo_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","Samuela iya Isileli ali toloina lalakina yawasina kana sauga meuloina koina kanasiga iboita. ");
INSERT INTO tteo_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","Bolime kaigeda kaigeda koina itakitakikili Isileli yanuwaliyaone kolili ali gamwapakiki iyaduyadudulaili bwaimwana yanuwane esaliyao Betele, Giligali yo Mispa ali yatala ipaipaisowaili. ");
INSERT INTO tteo_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","Na sauga meuloina ipilepileyoi Lama koina iya ana yanuwa mena yo yatala ipaipaisowai. Kabo bwaine koina veku italin ana kaba pwaoli Yeoba koina. ");
INSERT INTO tteo_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Samuela ana sauga ilobai itautaubala kabo natunao tatao labui ipeili siya Isileli kali tobagunao. ");
INSERT INTO tteo_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","Tobagubaguna esana Yoela salina mena esana Abaidiya simiyamiya yanuwa Biyasiba koina yo yatala sipaipaisowai. ");
INSERT INTO tteo_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Na iyamo ali paisowa meuloina nige besiele tamali mumugana. Siya nuwanuwali lalakina mane kabo mwakota mena mane sikalakalai tomo kolili yo loina kana kamwasa dudulaina meuloina nige siyayadudulai. ");
INSERT INTO tteo_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Kabo Isileli ali tautaubalao meuloili silogogo silau yanuwa Lama Samuela koina, ");
INSERT INTO tteo_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","yo siwalo koina siba, “Iyaele kutautaubalako yo natumwao mumugali nige besiele kowa mumugam. Nuwanuwamai tomo yabo ugite-sipwai iyamala ama kin na ibaguna-yagimai besiele kaba loina meuloili me ali kinwo.” ");
INSERT INTO tteo_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Kabo ali kawanoi kin kaiwena Samuela koina nige iyayaliyaya na besimo ilau ikawanoi Yeoba koina. ");
INSERT INTO tteo_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Yo Yeoba iwalolau Samuela koina iba, “Kubenali tomone siya siwalowa koliwo ali nuwatune uginauli besiele kaiwena kowa nige sisisikotanagiwo na yau mwa sisikotanagau genuwali yau yaemala ali kin. ");
INSERT INTO tteo_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Mumugaline siyatubuwaya Itipita koina kaliyatenane koina yayoga-yawatagilagili ilaoma kanasiga kaliyate kabona nagamo iyaele yaubadao mwakomwakotali kolili sipwalopwalou. Na yau sipei-suwalagau. Ee mwa kamwasa kaigedana iyaele mwa koliwo tabe siginaginauli yoi. ");
INSERT INTO tteo_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Uginauli besiele ali nuwatune na kuwalo-yadidigali na sikatai yakato kinne bwaliga kani siloina-yagili me ali kaiwe yo tawae nuwanuwali siginauli kani siginauli kolili.” ");
INSERT INTO tteo_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Kabo Samuela itolo yo Yeoba kainana meuloina iwalowen tomone siya silaoma sikawanoi Samuela koina kin kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","Iwalo iba, “Kinne kani bwaliga iloina-yagimiu ana loina kana koleya bwaite besiele. Natumiyao tatao nimamiu kalona mena kani ikalaili yo tupwaliyao ipeili ana kaleya waga niuniuli mena, tupwaliyao ana osi pwatana mena yo tupwaliyao sisagena baguna ana waga niuniuli manna mena. ");
INSERT INTO tteo_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Tupwaliyao kani ipeili tokaleya tausan kali tobaguna, tupwaliyao pipti (50) kali tobaguna, tupwaliyao ana tano togiyali yo topelipeli yo tosepasepa. Tabe tupwaliyao gogo kaleya kana toginauliwo na tupwaliyao waga niuniuli kana gogo waluwaluli kana toginauliwo. ");
INSERT INTO tteo_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Yo natumiyao sinesineo ikalaili siya olo bwalabwalaili kali toginauli, tupwaliyao kan kana tololiga yo pwalawa togabugabu iya kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Ami bwatano, ami oine tanoliyao yo ami olibe yaowaliyao siya namwanamwasosili nimamiu mena kani ikalaili na iwolegili ana topaisowao siya esaliyao lalakili kolili. ");
INSERT INTO tteo_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Tem ami witi yo oine tayakasa gwau sanaulu kani kin gwau kaigeda ikalai yo isoiyan ana topaisowa siya esali lalakili yo tabe ana topaisowa tupwaliyao kolili. ");
INSERT INTO tteo_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Ami topaisowa panpanli sinesineo yo tatao tabe ami bulumakau yo donki namwanamwasosili kani ikalaili yo iyapaisowali ibomamo kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Tem ami sipi yo gouti tayakasa gwau sanaulu kani kin gwau kaigeda ikalai. Yo komiu tabe kani kwaemala ana topaisowao panpanli. ");
INSERT INTO tteo_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Saugaliyaone kolili kabo kwavalam sagu kaiwena Yeoba koina kinne wagigite-sipwaine kaiwena. Na sauganane koina Yeoba kani nige ileleboimiu.” ");
INSERT INTO tteo_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Na iyamo tomo meuloili sisikote genuwali Samuela ana edeededene sibenalan. Mwa siwalo siba, “Nigele, nuwanuwamai kin iloina-yagimai. ");
INSERT INTO tteo_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Na kai kani kaemala kaba loina besiele kaba loina tupwaliyao, ama kin ipagan na ibaguna-yagimai kaleya koina.” ");
INSERT INTO tteo_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Kabo tomo ali walo meuloina Samuela ibenalagili yo ilau iwalo-masalagili Yeoba koina. ");
INSERT INTO tteo_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Yo Yeoba Samuela kainana iyamaisa iba, “Uginauli besiele ali nuwatune yo tomo yabo ugite-sipwai na kupei ali kin.” Kabo Samuela iwalolau Isileli kolili iba, “Meuloimiu kwapileyoi kwalau kaigeda kaigeda ami kaba miya mena.” ");
INSERT INTO tteo_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Tomo yabo esana Kisi iya susu Beniyamina iya tomo kaikaiwena yo towasawasa. Tamana esana Abieli na Abieli tamana esana Siloli na Siloli tamana esana Bekoladi na Bekoladi tamana esana Apiya, siya susu Beniyamina kana tautaubalao. ");
INSERT INTO tteo_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Kisi natuna tauna yabo esana Saulo iya kilakai kana koleya inamwanamwasosi Isileli kilakailiyao kaloli mena yo kanakavao meuloili isaliya-gabaegili. ");
INSERT INTO tteo_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Na Kisi ana donki tupwaliyao silokwalalele kabo iwalolau natuna Saulo koina iba, “Topaisowa yabo kuyogan na kwalau donki kwaloyaili.” ");
INSERT INTO tteo_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","Kabo Saulo topaisowa yabo iyogan mekanakava yo siloutusi Epileim ali dedei mala koyakoyana mena yo dedei Salisa meuloina koina, na iyamo nige yabo silolobai. Kabo silopaepaeli yoi silau Salim ana dedei mena yo Beniyamina ali dedei kalona meuloina siloyai, na iyamo nige silolobaili. ");
INSERT INTO tteo_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Saugana silau yanuwa Supi koina siyawatagili kabo Saulo iwalolau topaisowane koina iba, “Kulaoma tapileyoi. Tem nige tapipileyoi kani tamagu inuwanuwatusosi kaiwela, na donki kaiweli kani nige inunuwatusosi.” ");
INSERT INTO tteo_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Mwa topaisowa Saulo kainana iyamaisa iba, “Nigele, Yeoba ana tosonoga yabo iyaele yanuwane bwaite koina kana yakasisi ilalakisosi tomo kolili. Tem ginauli iwalowegili kani situbu besiele ana walone. Talau tagitai na mesabana kamwasa esana iwalo-masalan na koina tamuliya talau.” ");
INSERT INTO tteo_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","Yo Saulo iwalolau topaisowane koina iba, “Tem talau koina kani ginauli esana iya taolena ala mulolo koina? Kanwa kabona tatatauliliwa tobwa mena simwawasiko. Mwa ginauli esana kolila na kani taolena koina?” ");
INSERT INTO tteo_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","Mwa topaisowane kainana iyamaisa iba, “Siliba mane tupwana iyaele koliyau kani yaolena koina na mesabana kamwasa iyakenayagila na koina talau.” ");
INSERT INTO tteo_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","(Bagubagunana koina tem tomo Isileli nuwanuwali tawae yabo sikatai yo nuwali imayaleyan Yeoba koina kani siwaloba, ‘Talau tosonoga koina’. Kaiwena saugaliyaone kolili palopita esaliyao siyogayoga-yagili tosonogao) ");
INSERT INTO tteo_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","Mwa Saulo iba, “Inamwanamwa talau.” Yo sitolo silalau yanuwane kaiwena palopitane iyaele koina imiyamiya. ");
INSERT INTO tteo_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","Saugana sikawasae koya mena yanuwane kaiwena silalau yo towaila legu vesala tupwaliyao silalaoma silobaili kabo sineli kolili siba, “Tosonoga iyaele?” ");
INSERT INTO tteo_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","Kabo vesalaone siba, “Ee iyaele bwaite kabo waluwaluna iyayawatagilima. Iyaele bwaimwa manimiu mena kwalalau kaiwena na kwalomwayamwayau kaiwena tomo meuloili mekanakavao kani sisae koya mena sipwaoli kaba pwaoli mena Yeoba koina. ");
INSERT INTO tteo_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","Iyaele kani kwayawatagiliwa yanuwane koina kwalobai. Muli mena kabo sisae kaba pwaoli mena sikekan. Yo tabe tomo tupwaliyao siyoganli mekalikavao nige naga sikekekan kanasiga iya isae yo kawanoi mena iwalo-muloloi kabo sikekan. Koinaele tem kwalomwayamwayau kani kwalobai.” ");
INSERT INTO tteo_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","Mwa saugana sikawasae yanuwane koina yo silusae yanuwa kana gana kaba lusalusaena mena kabo Samuela silobai ilalaoma kaiweli ilalau kaba pwaoli mena. ");
INSERT INTO tteo_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Na laina kaliyatene koina Yeoba iwaloko Samuela koina iba, ");
INSERT INTO tteo_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","“Tomo yabo kani bwaliga bwaite saugane koina yayawasayawa koliwo iya ilaomaya boda Beniyamina kolili. Olo kusuwai kulukuluna mena kuyaoloi yo iya iyamala tobaguna yagu tomoyao Isileli kolili na kani ileboili Pilistiya nimali mena. Kaiwena ali valam yabenalanako yo ali kamkamna yagitaiyako.” ");
INSERT INTO tteo_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Yo Samuela manna ilau Saulo igitai yo Yeoba iwalolau koina iba, “Laina tomowa kaiwena yawalowalowa koliwo iya kani yagu tomoyao iloinayagili bwaimwa iyaele tomonane.” ");
INSERT INTO tteo_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Kabo Saulo ilau Samuela salina mena kaba lusalusae mena yo inelilau koina iba, “Aee tem sowana tosonoga ana nume kuwalo-masalan kolimai?” ");
INSERT INTO tteo_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Kabo Samuela Saulo kainana iyamaisa iba, “Yau bwaite tosonoganaele. Kwabaguna kaba pwaoli mena kabona kaliyatene koina komiu yo yau takekan toyawa. Yo yau bwaliga malala nuwam yawalo-yamayale muli mena kabo yakabi-gabaegimiu kwalau. ");
INSERT INTO tteo_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Na ami donki sikwakwalalelewa kaliyate yaiyona kaloli mena tabu kaiweli kwanuwanuwatu iyaele silobailiko. Na yaiya boda Isileli nuwanuwasosili? Bwaimwanamo kowa yo tamam ana susuwo.” ");
INSERT INTO tteo_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","Kabo Saulo kainana iyamaisa iba, “Gubesi kabo walone bwaimwa kuwalowen koliyau? Yau yagu susu Beniyamina iya ikikiusosi Isileli ala susu meuloili kolili. Yo kai diyane bwaite esamai ikikiusosi susu Beniyamina kalona mena.” ");
INSERT INTO tteo_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","Mwa Samuela itolo yo Saulo me ana kilakai iyoganli sikawasae kaba pwaoli mena. Kabo iyoga-luseyagili nume kalona mena yo iwalo simiyasio teibele kulukuluna mena tolaoma ali bodao luwali mena. Na siya sikawanoi-yagili silaoma kali baibaiwa teti (30). ");
INSERT INTO tteo_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","Yo Samuela iwalolau tololigane koina iba, “Wauwa tauna kona yaeyawa yo yawalo kupepei-suwalanwa ukwalaiyama.” ");
INSERT INTO tteo_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","Kabo tololigane ilau yo wauwa ikalaiyama ipei Saulo manna mena. Yo Samuela iwalolau Saulo koina iba, “Ee bwaite kowa kaiwem. Ukwalai ukwekan. Kowa kaiwem mwa yawalo tololiga ipei-suwalan kekan gogone bwaite kaiwena kabo muli mena tolaoma yayoganli.” Mwa Saulo yo Samuela sikekan toyawa. ");
INSERT INTO tteo_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Kekan imwawasi kabo koya mena sikawa-salulu silobi taon mena. Kabo Samuela Saulo iyogan sisae nume pwatana mena na iedeedede koina. ");
INSERT INTO tteo_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Yanuwa ilayan sikeno-tolo yo Samuela iyoga-sae Saulo koina iba, “Ukwatububu na talau kamwasa mena yapei-gabaegiwo.” Saulo ikatububu imwawasi kabo ana topaisowa mekalikava silau siyawatagili kamwasa mena. ");
INSERT INTO tteo_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","Saugana silau siyawatagili yanuwa kana sigasiga mena kabo Samuela iwalolau Saulo koina iba, “Kuwalo am topaisowane ilolo-bagubaguna.” Yo ana topaisowa iginauli besiele kabo Samuela iwalolau Saulo koina iba, “Naga tatolo sauga kubwakubwanamo na Yeoba kainana koliyau yawalowegili koliwo kubenali.” ");
INSERT INTO tteo_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Kabo Samuela olibe olo waila patu ikalai yo Saulo kulukuluna mena isuwai yo inisoi kabo iwalo koina iba, “Olo yasuwai kulukulum mena kaiwena Yeoba igite-sipwaiwo kuyamala ana tomoyao Isileli kali tobaguna. ");
INSERT INTO tteo_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","Bwaite kabona kulogabaegau na kulalaune ee tubula keduluma Litieli kana salai yanuwa Selisa papalina mena kani tomo labui kulobaili susu Beniyamina ali sigasiga mena. Kani am wasa siyeyawa siba, ‘Donkiwa kwaloyaloyailiwa silobailiko.’ Mwa tamam nige kaiweli inuwanuwatu na komiumo kaiwemiu mwa inuwanuwatu. Iyaelemo naga inelineli-yagimiu iba, ‘Kani natugu toyalobaiya?’ ");
INSERT INTO tteo_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","Yo bwaine koina kulau kanasiga kuyawatagili keyalu lalakina yakayakasisina yanuwa Tabola koina. Yo tomo yoli yaiyona kani kulobaili silalau Betele sitapwalolo Yeoba koina. Kaigeda gouti natunao yaiyona ikewakewaili, labuinane kani beledi yaiyona ikalakalaili na yaiyonanane waila patu oine donki kwapina ikalakalai. ");
INSERT INTO tteo_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","Yo kani sikawa-toki koliwo yo beledi labui kani siyeliwa me am yaliyaya ukwalai kolili. ");
INSERT INTO tteo_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","Bwaine koina kabo kulau Gibeya iya Yeoba ana koya. Dedei bwaine koina Pilistiya tokaleya sigogo simiyamiya koina. Saugana tem kuyawatagili yanuwane salina mena kani palopitao kulobaili koya mena sisasaluluma kaba pwaoli mena. Tupwaliyao sibaguna kaba venu api, tambalin, igo sikalaili kolili sivenuvenu kabo Yeoba Yaluyaluwana kaikaiwena ilobi italu kolili mwa sipalopalopisai. ");
INSERT INTO tteo_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Na saugana tem Yeoba Yaluyaluwana kaikaiwena ilobima italu koliwo yo ipei-suwalagiwo, ee mekamkavao kwapalopisai toyawa yo kowa kani kuyamala tomo uloina. ");
INSERT INTO tteo_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Tem bwaite kilakilalane yawawalowegiline siyamala yawasosi, na tawae kunuwatui inamwanamwa yakato uginauli kaiwena Yeoba iyaele mekamkava. ");
INSERT INTO tteo_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","Mangu mena kubaguna kulau kulobi yanuwa Giligali. Kusanasana kaliyate seben kabo yalaowa pwaoli gabugabuna yo lolabin kana pwaoli yapaisowaili. Kabo am wasa yaeyawa kani tawae ugiginauli.” ");
INSERT INTO tteo_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Saugana Saulo itagela-keile yo Samuela ilogabaen kabo Yeoba Saulo katena ibui-keile yo kilakilala meuloina Samuela iwawalowegiliwa siyamala yawasosi. ");
INSERT INTO tteo_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Kabo saugana Saulo me ana topaisowa silau siyawatagili yanuwa Gibeya mwa palopita bodaliyao silobaili yo Yeoba Yaluyaluwana ana kaiwe ilobi Saulo koina yo mekanakavao sipalopalopisai. ");
INSERT INTO tteo_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Na tomo siya Saulo sikatai ana paisowa bwaite sigitai kabo sienelineli-yagili siba, “Gubesi mwa Kisi natuna Saulo bwaine besiele? Tawae iyawayawatagili koina? Kaiwena kagitai iya besiele kabo palopita kalikava yabo.” ");
INSERT INTO tteo_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","Mwa yanuwane tomona yabo kainali iyamaisa iba, “Na palopitaone tamali yaiya?” Yo siya ali walo yabo siba, “Mwa gubesi Saulo iya palopita yabo?” ");
INSERT INTO tteo_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Ana palopisai imwawasi kabo Saulo isae kaba pwaoli mena. ");
INSERT INTO tteo_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","Na Saulo madiyana, tamana kanakava, ineli Saulo yo ana kilakai kolili iba, “Toweya kwalauya?” Saulo kainana iyamaisa iba, “Kalau donki sikwakwalalelewa kaloyaili, na nige kalolobaili mwa kalau Samuela koina.” ");
INSERT INTO tteo_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Tabe Saulo madiyana ineliyoi iba, “Na yagu wasa kwaeyama tawae Samuela iwalowen kolimiu.” ");
INSERT INTO tteo_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Mwa Saulo iwalo-pileyoi iba, “Iwalo dudulai kolimai iba donki silobailiko.” Na Saulo nige iwawalo-masalan madiyanane koina ana emala kin Isileli kalona mena kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Muli mena Samuela boda Isileli iyoga-gogonagilima silau yanuwa Mispa koina yo sitolo Yeoba manna mena. ");
INSERT INTO tteo_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Yo iwalo kolili iba, “Yeoba Isileli ala Yaubada, ana walo bwaite besiele. ‘Yaleboimiu Itipita nimali mena yakele-yawatagilagimiu Itipita koina kanasiga kwalaoma Kenani. Yo tabe yaleboimiu kaba loina tupwaliyao ali loina kaikaiwena koina siula-matamatausagimiu.’ ");
INSERT INTO tteo_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Na komiu ami Yaubada kwasikotanan bwagana ileboimiu kami polowe meuloili kolili. Kabo kwawalo kwaba, ‘Ama kin yabo kwaeyama na iloina-yagimai.’ Na kwatolo Yeoba manna mena ami susu yo ami boda kolili.” ");
INSERT INTO tteo_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Saugana Samuela iwalo susu Isileli meuloili silogogoma salina mena kabo Yeoba susu Beniyamina igitesipwai. ");
INSERT INTO tteo_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Kabo susu Beniyamina me natuliyao silaoma Samuela salina mena yo Yeoba Matile ana susu igitesipwai. Mwa susune kalona mena Yaubada Saulo igitesipwai iya Kisi natuna. Sigite-loyaloyai bodane luwana mena iya nigele. ");
INSERT INTO tteo_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Yo sineli Yeoba koina, “Gubesi, Saulo ilaomako bwaite koina?” Kabo Yeoba ali neli iyamaisa iba, “Ilaomako na iyaele ikeno-wadam gogo luwali mena.” ");
INSERT INTO tteo_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Mwa sisagena silau sikele-yawatagilan yo siyoganama itolo boda luwaluwalili mena. Iya ilalakisosi kanakavao meuloili isaliya-gabaegili meuloili sisaema giligilina mena kali siga. ");
INSERT INTO tteo_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Kabo Samuela iwalolau Isileli boda kolili iba, “Wagitai, Yeoba tomo bwaite igitesipwai iyamala ami kin. Nige yaboyoi Isileli kalola mena besiele iya.” Kabo tomo meuloili siyoga, “Ala kin yawasina imamalawe.” ");
INSERT INTO tteo_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","Kabo Samuela itolo yo kin kali loina iwalo-masalan tomo kolili. Yo ilele-lobiyen buki yabo koina mwa ilau ipei Yeoba manna mena. Yo tomo iyawasa-yapileyoili kaigeda kaigeda ali yanuwa mena. ");
INSERT INTO tteo_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","Saulo tabe ilauyoi ana yanuwa mena Gibeya, tatao tupwaliyao kaikaiweli mekanakavao siya Yeoba kateli ikabi-tonagili siyamala Saulo kana tomuliyayao. ");
INSERT INTO tteo_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","Na tomo tupwaliyao yauyauleli Saulo sisinali kabo siba, “Tomone bwaine sowana kani ileboila?” Mwa nige mulolo yabo siwowolena koina. Mwa tabe Saulo nige walo yabo gamwana mena iyayawatagili kaiweli, bwai imwanou-gabaegilimo. ");
INSERT INTO tteo_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","Kabo sauga yabo koina boda Amoni ali kin Neiyasi ana tokaleyayao ikalaili silau Isileli yanuwana esana Yabesi dedei Giliyadi koina, sidale-takikilan. Mwa Yabesi tomoliyao meuloili silau kin Neiyasi koina siba, “Komiu yo kai tawaloyameli tamiya dudulai yo sowana kamiya ami loina yaulina mena.” ");
INSERT INTO tteo_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","Na kin Neiyasi kainali iyamaisa iba, “Nigele, bwaimwanamo tem meuloimiu kwatalam-wagimiu man ulaulamiu mena manpoumiu yakasi-gabaegili. Yapaisowai bwaine besiele na Isileli meuloimiu ami kaba mwalimwaline.” ");
INSERT INTO tteo_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","Kabo Yabesi ali tautaubalao sikawanoi koina siba, “Kaliyate seben kuyelima kolimai na ama tosagenawasa ilau Isileli kalona meuloina kolili ali wasa iwolegili. Tem nige yabo ilaoma isasaguimai ee kabo katalamwagimai koliwo am nuwatu tawae uginauli kolimai.” Mwa ali kawanoi kaiwena Neiyasi italam besiele. ");
INSERT INTO tteo_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","Saugana tosagenawasa silu-yawatagili Gibeya koina iya Saulo ana yanuwa yo Neiyasi ana loina siyawasayan tomo sibenalan kabo sivalam kainali lalakina mena. ");
INSERT INTO tteo_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","Sauganane koina Saulo ilaomaya tano mena ipipileyoi yanuwa mena me ana bulumakauwo iyapaisowali ana tano mena. Na valam lalakina ibenalan yo ineli tomo tupwaliyao kolili iba, “Tawae iyawayawatagili tomone kolili? Gubesi kabo sivalavalam?” Yo ana wasa siwolena Yabesi ali tosagenawasa tawae ilaoma ali wasa iwolegili. ");
INSERT INTO tteo_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","Saugana ana wasa siwolena kabo Yeoba Yaluyaluwana ana kaiwe ilobi italu koina kabo imunamunai lalakina kin Neiyasi kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","Kabo bulumakau labuiwa ikoyamateli yo iyetomtom-wagili yo iwolegili tosagenawasa kolili sikalai silotakikilan Isileli kalona meuloina koina siba, “Tem yaiya na nige Saulo yo Samuela iyayamuli kusulili yo nige ikakaleya Amoni kolili ee kani ana bulumakau iyetomtomwan bwaite besiele.” Saugana tomo walone bwaine sibenalan kabo Yeoba simatausan kaiwena ana kaiwe sigitaiyako Saulo koina. Yo tatao meuloili silaoma siyaboda kaigeda kabo meuloili siyawatagili toyawa nige yabo imimiya-pileyoi yanuwane koina. ");
INSERT INTO tteo_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","Biseki koina Saulo tatao iyasilili kali baibaiwa tili andeledi tausan (300,000) siya Isileli na siya Yuda kali baibaiwa teti tausan (30,000). ");
INSERT INTO tteo_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","Yo siwalolau tosagenawasa kolili siba, “Kwalau kamikavao Yabesi Giliyadi tomoliyao kolili kwaba, ‘Bwaliga muli mena kabo ikala-pwasinasina kai kani kaleboimiu.’” Saugana tosagenawasa silau Yabesi ali wasa siwolena mwa siyaliyaya lalakina. ");
INSERT INTO tteo_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","Kabo siwalolau Amoni kolili siba, “Kani bwaliga katalamwagimai kolimiu na tawae kwanuwanuwatuine waginauli besiele.” ");
INSERT INTO tteo_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","Boniyai mena Saulo ana tokaleyayao iyakasali boda yaiyona siginauli na nige naga itotomkewa na siyawatagili Amoni ali kaba miya mena sikoyamayamateli kanasiga isae kala pwasinasina. Siya nige sisisilae siyabubu-gwaligwali kaigeda kaigeda ana kaba lau mena ilau. ");
INSERT INTO tteo_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","Kaleya imwawasi mulina mena Isileli tokaleyayao sineli Samuela koina siba, “Tomone siya siwawalo yakato nige nuwanuwali Saulo iyamala kin toweya siyaele? Kwayoganlima kolimai na kakoyamateli?” ");
INSERT INTO tteo_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","Na Saulo iwalolau kolili iba, “Kansiga nige sowana tomo yabo takoyamate kaiwena kabona kaliyatene koina Yeoba Isileli ileboila kala tokalomagigiliwo kolili.” ");
INSERT INTO tteo_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Yo Samuela iwalolau tomo kolili iba, “Talau Giligali koina yo Saulo takawa-yawasosiyan iya ala kin.” ");
INSERT INTO tteo_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Mwa meuloili silogogo Giligali koina yo sikawa-yawasosi Saulo iya ali kin Yeoba manna mena. Yo lolabin pwaolina siginauli yo Saulo mekalikava sikekan toyawa yo siyaliyaya toyawa. ");
INSERT INTO tteo_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","Samuela iedeedede Isileli kolili iba, “Tawae ami nuwatu meuloina kwawalowen koliyau besiele yaginauliyako kolimiu. Mwa ami kin yabo iyaele yaeyawako ibaguna-yagimiu. ");
INSERT INTO tteo_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","Mwa ami kinne iya kami toloina. Na yau wagitaiyauko yabelu kaiwena yatautaubala yo itogu ilike. Yo natuguwao siyaele mekamikavao. Na yau saugana yakilakai-saema na yaemala tobaguna ilau ee kanasiga kabona. ");
INSERT INTO tteo_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","Iyaele bwaite yatolo manimiu mena. Tem yagu lopwano yabo wagite-lobai kwawalo-masalan Yeoba koina, yo ana yaoyaolo tomona, manli mena. Tomo esana ana bulumakau yakalai? Yo tomo esana ana donki yakalai? Yo tomo esana yamwakotayan na ana wasawasa yakalai? Yo yaiya polowe yaolena? Yo yaiya ana mane mwakota mena yakalai koina iyamala kagu yaga na nige yayayamaisa? Nuwanuwagu yagu wasa kwaeyama na nuwagu kwawalo-yadudulai na yayamaisa.” ");
INSERT INTO tteo_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","Kainana siyamaisa siba, “Nige tawae yabo naenaena ugiginauli kolimai, nuwana mwakota mena o mankikiwasi mena o nuwana kewali mena, meuloina nigele.” ");
INSERT INTO tteo_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","Kabo Samuela iwalolau kolili iba, “Yeoba yo ana yaoyaolo tomona iya kin ami edeedede meuloina kaliyate kabona manli mena sikawa-yawasosi kaiwena nige tawae yabo naenaena yapapaisowai kolimiu.” Siba, “O, Yeoba ikataiyako.” ");
INSERT INTO tteo_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","Yo Samuela tabe iwaloyoi kolili iba, “Yeoba Mosese yo Eloni igite-sipwaili. Mwa siya tubulao siyoga-yawatagilagilima Itipita koina, ");
INSERT INTO tteo_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","koinaele kwatolo bwaite koina Yeoba manna mena na yawalo kolimiu ginauli lalakisosili iginauliliko tubulao kaiweli yo komiu tabe kaiwemiu yawalo-masalagili. Bwaine koina na ami pwanoli yawalo-masalagili kolimiu kaiwena nuwanuwamiu kin. ");
INSERT INTO tteo_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","Beyabeyana Yakobo me ana susuwo silau Itipita kabo sidebalala bwaine koina bolime isa silaoko kolili kabo kamkamna lalakina silobai yo sivalam Yeoba koina lebo kaiwena mwa Mosese yo Eloni iyawasali silau siyoganlima dedei bwaite koina simiya. ");
INSERT INTO tteo_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","Na tubulaone siya Yeoba ali Yaubada yawasosi na iyamo silo-dagedagela-yan. Mwa italamwagili kali kaleyayao nimali mena. Kaba gite bwaite tomo Pilistiya, Mowabe ali kin yo tabe Sisela iya yanuwa Eisoli ali tokaleya ali tobaguna. ");
INSERT INTO tteo_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","Mwa sauga meuloina tubulao lebo kaiwena siyogayoga-sae Yeoba koina siba, ‘Kai kalopwano manim mena kaiwena kalodagedagela-yagiwo kapwalou pwano kokotomo Baal yo Asitate kolili. Kuleboimai kama tokalomagigiliwo nimali mena na kapwaloumo kowa koliwo.’ ");
INSERT INTO tteo_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","Sauga meuloina Yeoba tomo kaigeda kaigeda iyawayawasayama yabo bwaimwana Gidiyon salina mena Belaki salina mena Yepidiya yo yau Samuela. Mwa Yeoba ileboimiu kami tokalomagigiliwo nimali mena yo kwamiya namwanamwa. ");
INSERT INTO tteo_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","Na saugana Neiyasi Amoni ali kin wagitai me ana tokaleyayao silaoma sikakaleyaimiu na wakataiyako Yeoba iya ami kin na iyamo kwawalo koliyau kwaba, ‘Nigele, nuwanuwamaimo tem ala kin na iloina-yagila.’ ");
INSERT INTO tteo_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","Kabo kin wagigite-sipwaiwa iyaelete wakakawanoiwa mwa Yeoba iyeyawa kolimiu yo iya iloina-yagimiu. ");
INSERT INTO tteo_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","Tem Yeoba kwamatausan yo ana walo kwaobigai yo kwatapwalolo yawasosi koina ami kinne tabe iya mekamikava Yeoba ana kamwasa kwamuliya yawasosi kani kwanamwanamwa. ");
INSERT INTO tteo_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","Na tem nige kainana kwabebenalan yo ana loina kwaokwatakwatayan kani ana kaiwe mena isibayanaemiu besiele beyabeyana tubumiyao isibayanaeli. ");
INSERT INTO tteo_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","Koinaele sauga bwaite koina kwatolo mwanou na Yeoba ginauli lalakisosina iginauli manimiu mena wagitai. ");
INSERT INTO tteo_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","Na sauga bwaite kita ala dedei mena nige galewa kana sauga. Besi na yau kani yakawanoi Yeoba koina kabo kani itutu yo ilogalewa. Bwaine koina na wakatai yakato ami pwanoli ilalaki molosi Yeoba manna mena na iyamo besimo wakawanoi kin kaiwena.” ");
INSERT INTO tteo_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","Mwa Samuela iyoga-sae Yeoba koina. Sauganane koina itutu yo galewa italu. Mwa tomo meuloili Yeoba yo Samuela simatausagili kaliyatenane koina. ");
INSERT INTO tteo_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","Kabo tomo meuloili siwalolau Samuela koina siba, “Ukwawanoi Yeoba am Yaubada koina kaiwemai kisi kaboita kaiwena kai ama pwanoliwa iyaele kaetulanyoi kin kakawanoiyan.” ");
INSERT INTO tteo_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","Samuela kainali iyamaisa iba, “Tabu kwamamatausi. Walo yawasosi iyaele pwanoli waginauliliko. Na iyamo tabu Yeoba kwamimiya-dagedagelayan, kwatapwalolo koina kate-yawasosimiu mena. ");
INSERT INTO tteo_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","Tabu Yaubada kwalologabaen na kwalau kokotomo kolili kwapwalopwalou. Siya ginauli bwagabwaga molosi, nige ginauli yabo namwanamwana kani sigiginauli kolimiu yo tabe kani nige sileleboimiu. ");
INSERT INTO tteo_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","Yeoba nige sowana isikotanagimiu yawasosi kaiwena ibomamo igite-sipwaimiu ana tomoyao esana kana benali namwanamwana kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","Na yau nige sowana yalopei kawanoi Yeoba koina kaiwemiu. Tem na yalopei kawanoi kaiwemiu kani yalopwano Yeoba manna mena. Yo kamwasa dudulaina kani yayakenayagimiu. ");
INSERT INTO tteo_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","Sowana wakatai yadudulai na Yeoba kwamatausan yo kwatapwalolo yawasosi koina katemiu meuloina mena. Naga kwanuwatui ana paisowa lalakili ipaisowaili kolimiu. ");
INSERT INTO tteo_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","Tem na pwanoli mumugana waginaginauli-kalatan kani komiu yo ami kinne Yeoba ikele-gabaegimiu dedei bwaite koina.” ");
INSERT INTO tteo_vpl VALUES ("S113_1","010_13_1","1SA","13","1","2","Saulo Isileli iloinayagili bolime labui imwawasi kabo tatao kali baibaiwa tausan yaiyona (3,000) Isileli kalona mena igite-sipwaili siyamala ana tokaleyayao. Tausan labui (2,000) ikalaili mekanakavao simiyamiya yanuwa Mikimasi yo Betele dedeili mala koyakoyana mena na tausan kaigeda (1,000) iyawasali silau Diyonatan ana kaba miya mena yanuwa Gibeya susu Beniyamina ali dedei mena. Na tomo meuloili iyawasali sipileyoi ali yanuwa mena. ");
INSERT INTO tteo_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","Diyonatan me ana tokaleyayao silusae Pilistiya ali kaba gogo mena Geba koina meuloili siunuili. Yo wasali ilau Pilistiya sibenalan. Mwa Saulo tosagenawasa iyawasali Isileli meuloina koina bwagigi siyui-takikili yo siba, “Ibeliu kwabenali.” ");
INSERT INTO tteo_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","Yo Isileli meuloili wasa sibenalan siba, “Saulo ilau Pilistiya ali kaba gogo mena mwa iunuili kabo Pilistiya simunamunai molosi Isileli kolila.” Yo siwaloyoi siba, “Tatao kwalogogo yanuwa Giligali Saulo koina.” Mwa siginauli besiele. ");
INSERT INTO tteo_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","Na Pilistiya silogogo yoi Isileli sabi kaleyaili. Ali waga niuniuli kali baibaiwa tausan yaiyona (3,000) yo tokaleya simwalisae kali baibaiwa sikisi tausan (6,000). Na siya kaekaeli mena silaulau sibaibaiwa molosi besiele gelegelesa, mwa sisae sigogoya Mikimasi Beteiben tete kaluwabuna mena. ");
INSERT INTO tteo_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","Isileli sibomayoi sikatai-lobaili ali pwanoli ilalakisosi kaiwena Pilistiya sibaibaiwasosi na siya nige sibabaibaiwa. Kabo tupwaliyao silau sikeno-wadam veku gulali mena dupa mena tupwaliyao silau gunuwala mena, gula mena. ");
INSERT INTO tteo_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Yo tabe tupwaliyao Yolidan silopanaisi susu Gata ali dedei mena yo Giliyadi. Na Saulo Giligali koina imiyamiya. Tokaleyayao meuloili mekanakavao simatausi kateli siwakaka yo sitabutabubu. ");
INSERT INTO tteo_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","Kaliyate seben isanasana Samuela kaiwena, kaiwena ana laoma kana sauga igoluyako na iyamo nige ilalaoma Giligali mwa tokaleyayao siyatubu silogwaligwali. ");
INSERT INTO tteo_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","Kabo Saulo iwalo, “Pwaoline siya tagabu-wolili wakalailima yo lolabin kana pwaoli besiele wakalailima koliyau.” Yo sikalai silawan siwolegili koina na ipwaoliyan Yeoba koina. ");
INSERT INTO tteo_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","Saulo pwaoli paisowana iyemwawasi kabo Samuela iyawatagili. Saulo itolo ilau yakato Samuela imuloloi. ");
INSERT INTO tteo_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","Na Samuela ineli Saulo koina iba, “Na tawae uginauline?” Kainana iyamaisa iba, “Tokaleyayao silogabaegau silowasiko na kowa am saugawa ugogoluwa koina nige kuyayawatagilima yo Pilistiya tokaleya boda sigogoko Mikimasi koina. ");
INSERT INTO tteo_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","Yabatoko kani silobima bwaite koina Giligali na sikaleyaimai. Nige yakakawanoi Yeoba koina ana sagu kaiwena. Mwa yabomamo yagu kepate koina mwa pwaoline yagabu Yeoba koina kaiwena nige sowasowagu yasanaiwo.” ");
INSERT INTO tteo_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Na iyamo Samuela iwalolau koina iba, “Yauyaule kowa, Yeoba am Yaubada ana loina nige ugigite-kalatan yo kumumuliya. Tem ugite-kalatan yo kumuliya-dudulai kani Yeoba ikabi-yakaiweo yo tubumwao yaso muliye siyamala toloinao Isileli kalona mena kanasiga yo kanasiga. ");
INSERT INTO tteo_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Mwa kani am kaba loina nige imimiyayai, kaiwena Yeoba ana loina nige kumumuliya. Mwa Yeoba iya iboma ana gitesipwa katena mena tomonane iya kani ipei ana tomoyao ibagunayagili.” ");
INSERT INTO tteo_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","Yo Samuela Giligali ilogabaen yo isae Gibeya siya dedeine Beniyamina ali dedei kabo Saulo itolo yo tomo siya tokaleyayao mekanakavao simiyamiya iyasilili yoli sikisi andeledi (600). ");
INSERT INTO tteo_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","Kabo Saulo yo natuna Diyonatan ali tokaleyayao mekalikavao sigogoya Gibeya. Na Pilistiya ali tokaleyayao sigogoya yanuwa Mikimasi. ");
INSERT INTO tteo_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","Na Pilistiya boda yaiyona siyawasali silau Isileli ali yanuwao kolili kabo ali gogo sikwayaili. Boda yabo silau siyawatagili kamwasa ilau Opela yanuwa Suwali. ");
INSERT INTO tteo_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","Na boda labuina silobi kamwasane ilau Betoloni, na boda yaiyonana silau kamwasa isae mala koyakoyana mena kana koleya ilau Seboim galogalowana mena tagitegitelau yanuwa leleyanna mena. ");
INSERT INTO tteo_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","Yo tabe nige yabo tomo Isileli kalona mena sowasowana pwawati aeyan ipaisowai o itutu. Pilistiya nige sitatalam na paisowane bwaite siyakataili kaiwena siba kisi Isileli sibomamo sitolo yo ali kaleya gogoliyao siginaulili besiele ali kaleya kelepana yo wamali. ");
INSERT INTO tteo_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","Mwa Isileli sitolo silobi Pilistiya kolili ali gogo sikalaili yaso giyagiyali, madaka, kilam, wamali, yo naipi, kaba tomtom-witi silobi siwolegili sivakilili. ");
INSERT INTO tteo_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","Yo Pilistiya ali maisa siliba kikiuna kaigeda tem yaso giyagiyali o tem bulumakau ali kaba pan-kalatagili, na kilam yo poke siliba kikiuli labui. ");
INSERT INTO tteo_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","Koinaele kaleya kana kaliyate koina Isileli meuloili nige ali gogo kaleya, bwaimwanamo Saulo yo natuna Diyonatan. ");
INSERT INTO tteo_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","Pilistiya tokaleyayao silau sigogoya Mikimasi ana dedei mena kamwasa giligilina mena kaba lusola koina. ");
INSERT INTO tteo_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","Kaliyate yabo koina Saulo natuna Diyonatan iwalolau ana kaleya gogona kana tokayale koina iba, “Kulaoma talopanaisi Pilistiya ali kaba gogo mena.” Na tamana nige nuwana mena ipepei. ");
INSERT INTO tteo_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","Na Saulo imiyamiya mayau pomegleneiti yaulina mena yanuwa Migilon koina yanuwa Gibeya salina mena. Yo tomo yoli sikisi andeledi (600) siya tokaleyayao mekanakavao simiyamiya. ");
INSERT INTO tteo_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","Na topwaoli Aiya iyaele luwali mena kana kaleko esana ipodi iluwui. Aiya iya Ikabodi natuna kanakava esana Aitubi na Aitubi tamana esana Peniyasi na Peniyasi tamana esana Ilae. Iya tauna kona Yeoba ana topwaoli yanuwa Sailo koina. Na Diyonatan ana laune kaiwena nige tomo yabo ikakatai. ");
INSERT INTO tteo_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","Na kaba lopanaisine ilalau Pilistiya ali kaba miya mena papali labui mala naenaena. Malanaenaene yabo esana Bosesi yo yabo esana Senei. ");
INSERT INTO tteo_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","Papali labuine yabo tete bomatu mena Mikimasi manna mena yo yabo tete yavana mena Geba manna mena. ");
INSERT INTO tteo_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","Diyonatan iwalolau ana kilakai gogo kaleya kana tokayale koina iba, “Kulaoma talopanaisi talau Pilistiya ali kaba gogo mena siya nige nigwenigwe tomonliyao kolili. Nuwana kani Yeoba ginauli yabo iginauli kaiwela. Bwagana tabaibaiwa o nuwana nige tababaibaiwa nige ginauli yabo sowasowana Yeoba ana sagu ikausi kolila.” ");
INSERT INTO tteo_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","Mwa kainana iyamaisa iba, “Tawae kunuwatui uginauli bwai talaowamo yau talatalamgu koliwo.” ");
INSERT INTO tteo_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","Kabo Diyonatan iba, “Inamwanamwa talopanaisi talau talomayale kolili na sigitaila. ");
INSERT INTO tteo_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","Tem siwalo kolila siba, ‘Kwasanasanawaya kanasiga kasaewa kolimiu’ tatolomo tasanasana tabu tasasae kolili. ");
INSERT INTO tteo_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","Na tem siba, ‘Kwasaema kolimai’ takawasae kaiwena bwainene kilakilala kolila Yeoba italamwagiliko nimala kalona mena, kani taunuili.” ");
INSERT INTO tteo_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","Kabo yoli labuiwa silopanaisi yo siutu-mayale Pilistiya tokaleya kolili mwa sigitaili yo sitalawasi-yagili siba, “Wagitaili Ibeliu tokenokeno-wadamwa gula mena kabo sinene-yawatagilima.” ");
INSERT INTO tteo_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","Kabo siyogalau Diyonatan yo ana kilakai tokayale gogo kaleya kolili siba, “Ee kwasaemaya kolimai na sanapu kayakenayagimiu.” Mwa Diyonatan iwalolau kana tosagu gogo kaleya kana tokayale koina iba, “Yavinae baguna na kowa kani muligu mena kuvinaema. Kaiwena Isileli ala Yaubada Pilistiya italamwagiliko nimala mena kani kabona taunuili.” ");
INSERT INTO tteo_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","Yo Diyonatan ivinae baguna mala naenaenawa koina nimana yo kaena iyapaisowali. Na ana tokayale gogo kaleya salina mena. Yo Diyonatan Pilistiya kaleya kana tobagunao tupwaliyao itubali-yabekuli na ana kilakai salina mena itolo yo ikoyamateli. ");
INSERT INTO tteo_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","Kaleya bagubagunana koina Diyonatan me ana kilakai gogo kaleya kana tokayale mekanakava yoli tuwenti (20) siunuili dedei kikiuna kalona mena. ");
INSERT INTO tteo_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","Mwa Pilistiya tokaleya meuloili siya simiyamiya ali kaba gogo mena yo tabe siya koya mena meuloili kateli siwakaka yo simatausi lalakina yo tabe nuwali sipwanopwano. Yo mwanikiniki bwatano inukui itabubu kaiwena Yeoba ana kaiwe iyawatagili. ");
INSERT INTO tteo_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","Saulo ana tokabi kevanaiwo manli ilau Gibeya koina susu Beniyamina ali dedei mena Pilistiya tokaleyayao sisagena bwagabwaga me ali nuwa-pwanopwano. ");
INSERT INTO tteo_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","Silau Saulo ana wasa siwolena, kabo iwalo kolili iba, “Tokaleya kwayoga-gogonagilima na kwaloyai yaiya iya nige mekalakava.” Mwa siloyai yo silobai Diyonatan me ana kilakai nige simiyamiya. ");
INSERT INTO tteo_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","Yo Saulo iwalolau topwaoli Aiya koina iba, “Yeoba ana kelabilabin kamwasana kana dedewaga wakalaiyama.” ");
INSERT INTO tteo_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","Saugana Saulo iyaelemo iedeedede topwaoli Aiya koina na Pilistiya ali kaba gogo mena matausi yo nuwa-pwanopwano ilalaki molosi yo siwuiwui-keikeile mwa iba, “Besi. Nige sowana Yeoba ana nuwatu taloyai.” ");
INSERT INTO tteo_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","Kabo Saulo me ana tokaleyayao silusae kaleya luwana mena sigite-lobaili Pilistiya nuwali sipwanopwano molosi. Mwa sibomayoi ali kaleya kelepana koina siunuyamateli siboita. ");
INSERT INTO tteo_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","Tauna kona Isileli tupwaliyao silau sipatu Pilistiya kolili yo simiyamiya waya Pilistiya ali kaba kaleya mena. Sauganane koina sitolo-keile Isileli kolili na Saulo yo Diyonatan sisaguili kaleya koina. ");
INSERT INTO tteo_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","Besiele siya tauna kona tabe siyabubu silau susu Ipeleim ali dedei mena sikeno-wadam dedei mala koyakoyana mena, mwa wasa sibenalan Pilistiya siyabubu kabo sisagena-tolo kabo mulili mena sisagena sikele-tawoili. ");
INSERT INTO tteo_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","Kaleya ilikwako ilaoko Beteiben ilogabaen. Na kaliyatenane koina tomoyao Isileli Yeoba ileboili kali tokalomagigiliwo nimali mena. ");
INSERT INTO tteo_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","Muliya kabo silau kaleya koina na Saulo loina kaikaiwena iwalowen kolili iba, “Kisi tomo yabo ukekan kanasiga kaleya mena yagumyai kagu kaleyayao kolili. Tem yaiya kowa nige loina bwaite kuyayakasisi-yan na ukekan kanasiga dabwelo isugu Yeoba kani ikawa-gulaiwo.” Mwa tokaleyayao nige sikekekan mwa meuloili yoli sisawosawowoli. ");
INSERT INTO tteo_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","Kabo meuloili silusae gunuwala mena yo kamwakamwa sigitai bwatano mena. ");
INSERT INTO tteo_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","Saugana silusae gunuwala mena yo kamwakamwane sigitai ididididi-yawatagili na iyamo nige yabo nimana ilalau na ikalai inunuma kaiwena kawa-gulane sibenalanako mwa simatausi. ");
INSERT INTO tteo_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","Na Diyonatan nige ikakatai tamana ana loinane mwa ana sige isuna iyagalawan itupa-lapan yo bwasina ikalaiyama ana sige mena inuma yo yona sikaikaiwe. ");
INSERT INTO tteo_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","Kabo tokaleya yabo iwalolau Diyonatan koina iba, “Tamam loina kaikaiwena ipei iba tem yaiya kan ikan kani kawa-gula ilobai Yeoba koina. Iya kaiwena mwa yomai sisawosawowoli kaiwena nige kan yabo kakakan.” ");
INSERT INTO tteo_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","Yo Diyonatan iwalo iba, “Tamagu ana loina ipepeine kita Isileli kala polowe iyalalaki. Ugitai saugana kamwakamwa bwasina kikiuna yanuma mwa yogu sikaikaiwe. ");
INSERT INTO tteo_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","Tem tamagu italam-wagila na kala kaleyayao kan siyayabubu-gabaegili kolili takekan na yola sikaikaiwe kani Pilistiya sibaibaiwa taunuili.” ");
INSERT INTO tteo_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","Kaliyatenane koina Isileli sitolo yo Pilistiya sitawoili sikoyamateli iyatubuya yanuwa Mikimasi koina yo ilau kanasiga Aidalon. Yo guliyam kaiwena kamnali sinae yo yoli sisawosawowoli. ");
INSERT INTO tteo_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","Mwa dabwelo isugu kabo mwayamwayau sisagena silau ginauli sikwayaili Pilistiya kolili yo tabe sipi yo bulumakau menatuliyao siunuili sinigwaili bwatano mena mekwasikwasineli simiyasio mekilaili sikekan, kaiwena siguliyam molosi. ");
INSERT INTO tteo_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","Yo Saulo ana wasa siwolena siba, “Tokaleya silopwano Yeoba manna mena kaiwena buluma kilaina kwasikwasinena sikanyako.” Kabo Saulo iba, “Komiu loina kana tolikwai veku yabo lalakina kwayatapipiliyama koliyau. ");
INSERT INTO tteo_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","Kwalau tokaleya kwawalo kolili ali sipi yo ali bulumakau sikalailima bwaite koina. Siunuili vekune bwaite koina yo kwasineliyao siyadidi-gabaegili yo siloliga sikekan. Na tabu Yeoba ana loina sisisinali.” Kabo sikele-gogo silaoma bwaine koina siloliga yo sikekan. ");
INSERT INTO tteo_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","Kabo Saulo kaba pwaoli ikabi Yeoba koina. Na bwaite ana sauga bagubagunana kaba pwaoli ikabi. ");
INSERT INTO tteo_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","Yo Saulo iwalo tokaleya kolili iba, “Kani boniyai talobi Pilistiya meuloili ali gogo takwayaili yo meuloili taunuyamateli tabu yabo itutupwa. Ilau kanasiga itomkewa ilayan gwaligwali.” Yo kainana siyamaisa siba, “Tawae kunuwanuwatuine inamwanamwasosi bwai uginauli mowoi.” Na iyamo tabe topwaoli Aiya iba, “Kani naga Yeoba ana nuwatu taloyai na takatai.” ");
INSERT INTO tteo_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","Kabo Saulo Yeoba koina ineli iba, “Gubesi yalobi Pilistiya yakalaili o besi? Sowana kutalamwagili Isileli nimali mena?” Na Yeoba Saulo ana kawanoi nige iyayamaisa kaliyatenane koina. ");
INSERT INTO tteo_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","Mwa Saulo iba, “Tokaleya kali tobagunao meuloimiu kwalaoma bwaite koina na taloyai yaiya pwanoli iginauli kaliyate kabona koina. Pwanoli esana iginauline? ");
INSERT INTO tteo_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","Kagu lulu Isileli ali Yeoba me yawasina esana mena iya tolebola nuwana natugu Diyonatan o nuwana yaiya bwai kani iboitamo.” Mwa tabe nige yabo kainana iyayamaisa. ");
INSERT INTO tteo_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","Yo Saulo iwalolau Isileli tokaleyayao kolili iba, “Komiu kani kwatolo waya bwaimwa koina na yau me natugu Diyonatan kani katolo bwaite koina.” Mwa kainana siyamaisa siba, “Tawae kunuwatui inamwanamwa sosi uginauli besiele am nuwatune.” ");
INSERT INTO tteo_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","Kabo Saulo ineli Yeoba Isileli ali Yaubada koina iba, “Tawae yaina nige yagu kawanoi kuyayamaisa? Nuwanuwagu walo yawasosi kuyeyama tem pwanoli imiyamiya yau yo Diyonatan kolimai kuyamayale veku Ulim koina na tem tokaleya ali pwanoli kuyamayale veku Tamim koina.” Kabo topwaoli veku ikalai iyapaisowa lopwano imayale Saulo me natuna Diyonatan kolili. ");
INSERT INTO tteo_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","Tabe Saulo iwaloyoi iba, “Vekune ugwabaegili yoi yau yo natugu Diyonatan luwaluwalimai mena.” Mwa siginauli besiele kabo silobai Diyonatan iya lopwanone iginauli. ");
INSERT INTO tteo_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","Kabo Saulo iwalolau Diyonatan koina iba, “Kuwalo-masala koliyau ginauli esana kupaisowaine?” Kabo kainana iyamaisa iba, “Yagu sige isuna mena kamwakamwa yatupa-lapan koina na yakalaiyama yanuma, koinaele yatalamwagau besimo yaboita.” ");
INSERT INTO tteo_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","Kabo Saulo iba, “Natugu, walo yawasosi kuboita. Tem nigele, yakawanoi Yeoba koina maisa polopolowe molosina iginauli koliyau.” ");
INSERT INTO tteo_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","Na tokaleyayao siwalo Saulo koina siba, “Diyonatan iya mwa kita Isileli ileboila. Mwa kani kuwalo iboita? Kani nigele. Kakawalulu Yeoba Tokaiwesosi esana mena nige sowana yona wauna yabo ukwabi-tonan, kaiwena kaliyate kabona Yeoba isagui yo paisowa lalakina iginauli.” Yo Diyonatan ilivasi nige sowana iboita. ");
INSERT INTO tteo_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","Mwa Saulo ilopei nige Pilistiya itatawoili yoi na ikabi-gabaegili sipileyoi ali dedei mena. ");
INSERT INTO tteo_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","Saugana Saulo iyamala Isileli ali kin iyatubu ikaleya Isileli kana tokalomagigiliwo dedei uloina uloina kolili. Siya Isileli simiya-takikilagili, Mowabe, Amoni, Idoma, Soba, siya me ali kinwo yo Pilistiya. Toisabo dedei kolili ikaleya sauga meuloina iunuili, ");
INSERT INTO tteo_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","kaiwena me ana katepatu yo me ana kaiwe ikalekaleya. Besiele tabe Amaleki iunuili siya tauna kona silaoma yo Isileli ali gogo sikwayaili. ");
INSERT INTO tteo_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","Saulo natunao tatao esaliyao bwaite, Diyonatan, Isibi yo Malikisuwa. Natunao sinesineo labui tobagubaguna esana Melabi, tomulimuliye esana Mikali. ");
INSERT INTO tteo_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","Saulo wainena esana Ainowami iya Aimasi natuna. Ana tokaleyayao kali tobaguna esana Abina iya Saulo tamana Kisi kanakava esana Neli natuna. ");
INSERT INTO tteo_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","Kabo Saulo tamana esana Kisi na Abina tamana esana Neli. Kabo Kisi kanakava Neli siya yoli labuine taubala esana Abiyeli natunao. ");
INSERT INTO tteo_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","Saulo yawasina meuloina koina me ana tokaleyayao sikalekaleya Pilistiya kolili. Na Isileli tataoliyao sauga meuloina igitagitaili tem yaiya ikaiwe yo ikatepatu ikalai iyamala ana tokaleya. ");
INSERT INTO tteo_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Samuela iwalo Saulo koina iba, “Yau mwa Yeoba iyawasayauma koliwo yayaoloiwo mwa kuyamala kin Isileli meuloina koina. Na kubenali am wasa ilaomaya Yeoba koina. ");
INSERT INTO tteo_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Bwaite besiele Yeoba kainana, ‘Kani Amaleki yayakamkamnali kaiwena Isileli tauna kona Itipita koina siyawatagilima ali kamwasa simiya-kausi yo sikaleyaili. ");
INSERT INTO tteo_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Koinaele me am tokaleyayao kani kwalau wagumyai Amaleki kolili ali yanuwa meuloina kwasiba-yanayanae kisi ginauli yabo wakabi-pei, taubala, keduluma, melumelu, melumelu susususuna, bulumakau, sipi, kameli yo donki.’” ");
INSERT INTO tteo_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Yo Saulo itolo susu Isileli kalona mena tu andeledi tausan (200,000) ikele-gogonagili na susu Yuda kolili ten tausan (10,000) ikalaili. Yo meuloili iyamiya-gogonagili yanuwa Telaima koina siya ana tokaleyayao. ");
INSERT INTO tteo_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Kabo Saulo ana tokaleyayao ibagunayagili Amaleki ali yanuwa lalakina galogalowana mena na koina Amaleki sikeno-vakasili. ");
INSERT INTO tteo_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","Yo Saulo walo iyawasa boda Keni kolili siya simiyamiya Amaleki luwali mena iba, “Dedei bwaimwana kwalogabaen kisi Amaleki mekamikavao kaunu-kaigedaimiu, kaiwena tauna kona boda Isileli siyawatagilima Itipita koina silaoma komiu tubumiyao simulolo sosi kolili.” Saugana boda Keni wasa sikalai kabo Amaleki silogabaegili sitolo yo silowasi. ");
INSERT INTO tteo_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Kabo Saulo me ana tokaleyayao silusae Amaleki siunuili iyatubu yanuwa Abila koina ilau yanuwa Sulu koina Itipita dedei pwatana tete kaluwabu mena. ");
INSERT INTO tteo_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Amaleki meuloili siboita kaleya kelepana mena na ali kin Eigagi ibomamo sikabi-kalatan. ");
INSERT INTO tteo_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Eigagi ibomamo yawasina sileboi besiele tabe sipi yo bulumakau namwanamwaliyao me natuliyao sinisinibuli. Ginauli meuloina namwanamwaliyao sikalaili na ginauli meuloina naenaeliyao sisibayanaeli. ");
INSERT INTO tteo_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Yeoba kainana ilaoma Samuela koina iba, ");
INSERT INTO tteo_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","“Nuwagu inae kaiwena Saulo yapei ikin na kabona dagelana iyeyama koliyau kaiwena tawae yagu walo koina nige igiginauli besiele.” Saugana walo bwaite Samuela ibenalan inuwanuwatu lalakina yo iyogayogasae Yeoba koina boniyai meuloina mena. ");
INSERT INTO tteo_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Yanuwa ilayan malala kikiuna Samuela ikeno-tolo yo ilau Saulo kaiwena. Yo tomo siwalolau koina siba, “Saulo ilaoko yanuwa Kameli yo veku kilakilala yabo iyatolo esana kana kawa-namwanamwa kana nuwatu-kalatan kaiwena. Bwaine koina kani ilobi Giligali.” ");
INSERT INTO tteo_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Saugana Samuela Saulo ilobai kabo Saulo iba, “Yeoba iwalo-muloloiwo. Yeoba ana walo meuloina yapaisowai besiele.” ");
INSERT INTO tteo_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Na Samuela iba, “Na gubesi kabo sipi yo bulumakau sivalam kainali tenagu mena yabenabenalagiline, awa?” ");
INSERT INTO tteo_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Mwa Saulo iba, “Tokaleya siya ali paisowa. Sipi yo bulumakau kali koleya namwanamwasosili sinisinibuli siunu-peili mwa sikalaili yakato sipwaoli-yagili Yeoba koina. Na meuloili kakoya-boitaliko.” ");
INSERT INTO tteo_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Kabo Samuela iwalo koina iba, “Kumwanou. Na am wasa yaeyawa boniyai mena tawae Yeoba iwalowen kaiwem.” Saulo iba, “Yagu wasa kuyeyama.” ");
INSERT INTO tteo_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Kabo Samuela iba, “Bwagana tauna kona kowa kuboma ugitaiwo yakato kowa tomo bwagabwaga na iyamo kowa kulaoma kuyamala susu Isileli meuloina ali kin. Besiele, awa? ");
INSERT INTO tteo_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Na laina Yeoba iyawasao kulau na tem paisowa yabo uginauli. Yo iwalo koliwo iba, ‘Kulau ukaleya Amaleki siya tomo naenaeli kolili kanasiga nige tupwa yabo imiyamiya, meuloili kuyemwawasili.’ ");
INSERT INTO tteo_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","Na tawae kaiwena Yeoba ana walo nige kuoobigai? Tawae kaiwena mwayamwayau mena Amaleki ali gogo ukewalili? Mwa pwanoli lalakisosina uginauli Yeoba manna mena.” ");
INSERT INTO tteo_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Saulo kainana iyamaisa iwaloba, “Na iyamo Yeoba kainana yaobigai yo paisowawa iwawalowenwa mwa iyawasayau yalau yaginauli. Yalau Amaleki meuloina yaunu wolili na ali kinmo Eigagi yapan mwa yalawanama. ");
INSERT INTO tteo_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Siya tokaleyayao kaleya mena yakayakan namwanamwaliyao sikwayaili silawagilima Giligali yakato sipwaoli-yagili Yeoba am Yaubada koina.” ");
INSERT INTO tteo_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Samuela iwalo-pileyoi Saulo koina iba, “Ginauli esana koina Yeoba iyaliyaya kaiwena? Pwaoli ugwabu o nuwana kainana kana obiga? Ana walo tabenalan tamuliya taobigai iya inamwanamwasosi muli mena kabo pwaoli. Obiga yo gamwakabi iya inamwanamwasosi kabo sipi tataoliyao katukatutuli tagabuli kana pwaoli kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Tem tagamwa-panapanawa Yeoba koina pwanolina iya besiele kalawe ana paisowa. Tem tanuwatu-sae tagagasa Yeoba koina naena ipagan kani tapwalopwalouya kokotomo kolili. Kaiwena kainana nige ugagamwa-kabiyan mwa koinaele isikotanagiwo kani nige ikakawa-kin-yagiwo yoi.” ");
INSERT INTO tteo_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Kabo Saulo kainana iyamaisa iba, “Walo yawasosi yalopwanoko Yeoba kainana koina yo am walo-yasanapuyau koina. Tokaleya yamatausagili mwa ali nuwatu mena yapaisowa. ");
INSERT INTO tteo_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Na yakawanoi koliwo yagu pwanoli kunuwatu-pwaiki na kowa yo yau tapileyoi tokaleya kolili na yatapwalolo Yeoba koina.” ");
INSERT INTO tteo_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","Mwa tabe Samuela iwaloyoi iba, “Genuwagu. Kani nige yalalaowa koliwo. Kaiwena Yeoba kainana kusikotanan mwa tabe Yeoba isikotanagiwo genuwana kowa kani nige ikakawa-kin-yagiwo yoi Isileli meuloina koina.” ");
INSERT INTO tteo_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Mwa Samuela itagela-keile yakato ilalau na Saulo nimana iyagayan kana kwama yakasisi malamalawena isuna ikabi-kalatan yo imomosi mwa itabe-igali. ");
INSERT INTO tteo_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Samuela iwalolau Saulo koina iba, “Yeoba kaliyate kabona Isileli ana kaba loina ikele-gabaen koliwo na iwolena tomo yabo koina iya inamwanamwasosi kabo kowa. ");
INSERT INTO tteo_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Yo Isileli ana Yaubada wasawasana nige sowana imwakota yo nige sowana ana nuwatu ibui kaiwena iya nige besiele kita tomo na ana nuwatu ibuili.” ");
INSERT INTO tteo_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","Kabo Saulo kainana iyamaisa iba, “Yalopwanoko na kategu kowa. Yakawanoi koliwo tem sowana kuyakasisi-yagau yagu tomo Isileli me ali tobagunao manli mena. Kabo kowa mekaukava tapileyoi na yatapwalolo Yeoba am Yaubada koina.” ");
INSERT INTO tteo_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","Kabo sipileyoi yo Saulo itapwalolo Yeoba koina. ");
INSERT INTO tteo_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Yo Samuela iba, “Eigagi Amaleki ali kin kwayogan ilaoma koliyau.” Yo Eigagi me ana yaliyaya yo me ana katepatu ilaoma nuwana mena iba, “Walo yawasosi boita kana malimali meuloina imwawasiko kani nige tawae yabo.” ");
INSERT INTO tteo_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","Na iyamo Samuela iwalo koina iba, “Am kaleya kelepana koina tomo kuunuili yo sinesineo sibaibaiwa nige natuliyao sipapagan. Kabo besiele yau kani yakoyaboitao na sinam nige natuna.” Kabo Samuela ana kelepa ikalai yo Eigagi ikoyamate yanuwa Giligali koina Yeoba manna mena. ");
INSERT INTO tteo_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Yo Samuela itolo yo ilau ana yanuwa mena Lama. Na Saulo isae ana nume mena Gibeya. ");
INSERT INTO tteo_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Kabo Samuela nige sauga yaboyoi ilau Saulo igigitai yoi kanasiga Samuela ana sauga imwawasi. Na Samuela me ana nuwapolowe Saulo kaiwena. Tabe Yeoba me ana nuwanae Saulo saugana iyamala kin Isileli koina mumugana kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Yeoba iwalolau Samuela koina iba, “Tawae kaiwena sauga imamalawesosi na nagamo kuvalavalam Saulo kaiwena? Yasikotananako nige tabe yakakawa-kin yoi koina. Isileli kaba loina meuloina kalona mena kani nige iloloina yoi. Na am olibe olo ukwalai yo bunama koina kusuwe-yapowon, ukwalai na kulau Bedeliema tomo yabo esana Yese koina. Natunao tatao kolili yabo yagite-sipwaiyako iya kani iyamala kin.” ");
INSERT INTO tteo_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Na Samuela iba, “Gubesi yagu lau kana koleya? Tem Saulo ibenalan kani ikoya-boitayau.” Yeoba iba, “Bulumakau natuna sinena waluwaluna ukwalai mekamkava na kuwalo kuba, ‘Yalaoma yapwaoli Yeoba koina’. ");
INSERT INTO tteo_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Yo kaina kuyawasa Yese koina ilaoma pwaoli mena kabo tawae yawalowen koliwo na kupaisowai. Na natunane yayakenayagiwo toisabo game iya bwaimwana kuyaoloi kulukuluna kutabuwan yau kaiwegu.” ");
INSERT INTO tteo_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Tawae Yeoba iwalowen Samuela koina iginauli besiele ana nuwatune. Saugana Samuela iyawatagili Bedeliema koina tautaubalao meuloili sigitai kateli siwakaka yo sitabubu. Kabo silaoma salina mena sineli koina siba, “Gubesi? Daumwali mena kulaoma?” ");
INSERT INTO tteo_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Samuela kainali iyamaisa iba, “Besiele, daumwali mena yalaoma na yapwaoli Yeoba koina. Kwayakasisi-yagimiu na bwaliga kwalaoma koliyau tapwaoli.” Muli mena Samuela Yese me natunao iwalo-muloloili. Imwawasi iwalo sipileyoi ali nume mena na bwaliga sipileyoima pwaoli kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Saugana Yese me natunao siyawatagili Samuela koina manna ilau Ilaiyabi, iya Yese natuna bagubagunana, imankulakulai mwa Samuela nuwana mena iba, “Walo yawasosi bwaite iya Yeoba ana gitesipwa tomonaele itotolo Yeoba manna mena.” ");
INSERT INTO tteo_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Na Yeoba iwalo Samuela koina iba, “Tabu kana koleya yo saliyana koina kumanmankulakulai bwaimwana nige tawae yabo koliyau. Kaiwena yau yagu gitesipwa nige besiele komiu tomo ami gitesipwa. Komiu yona koina wagitegitelau na yau katena koina yamanman-kulakula.” ");
INSERT INTO tteo_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Tabe Yese Abinadaba iyoganama ilau Samuela manna mena itolo. Na Samuela iba, “Bwaite iya nige Yeoba ana gitesipwa tomona besi.” ");
INSERT INTO tteo_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Tabe Yese iwaloyoi Sama ilau Samuela manna mena itolo. Na tabe Samuela iwaloyoi ana walo kaigedana iba, “Iya tabe bwaite besiele Yeoba nige igigitesipwai.” ");
INSERT INTO tteo_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Yese bwaine besiele iginauli natunao yoli seben kolili silau Samuela manna mena sitolo na iyamo Samuela iba, “Nige yabo natumwaone bwaite kolili Yeoba igigitesipwai.” ");
INSERT INTO tteo_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Mwa Samuela ineli Yese koina iba, “Natumwaone bwaite kali baibaiwa ele?” Yese iba, “Kali tomulimuliye molosi iyaele sipi igitegite-kalatagili.” Mwa Samuela iba, “Walo kuyawasa ilau koina na ilaoma. Kani nige yamimiyasio kanasiga iyawatagilima kabo tamiyasio pwaoli kanna takan.” ");
INSERT INTO tteo_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Yo Yese tomo yabo iyawasa ilau kaiwena yo iyoganama. Saugana siyoganama kana koleya inamwanamwasosi yo manna kana koleya sinamwanamwa. Mwa Yeoba iwalo Samuela koina iba, “Ee gamenaele bwaimwana olo kusuwai kulukuluna mena na kuyaoloi.” ");
INSERT INTO tteo_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Kabo Samuela olone ikalai yo Deibida kulukuluna mena iyaoloi kanakavao manli mena. Kaliyatenane koina na mulina mena Yeoba Yaluyaluwana ana kaiwe ilobi Deibida koina. Yo Samuela ipileyoi ilau Lama. ");
INSERT INTO tteo_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Yeoba Yaluyaluwana Saulo ilogabaen na yaluyaluwa naenaena Yeoba iwolena Saulo koina kabo sauga tupwana iyakamkamna. ");
INSERT INTO tteo_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Kabo ana topaisowa siwalolau koina siba, “Ugitai yaluyaluwa naenaena Yeoba italamwan iyakamkamnao yo tabe iulaula-matamatausagiwo. ");
INSERT INTO tteo_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Koinaele kin kutalamwagimai na kalau tomo yabo kaloyai iya tovenu api namwanamwasosina na mesabana tem yaluyaluwa naenaena ilaoma koliwo iya kani ana api ikoi na kamnam inamwanamwa.” ");
INSERT INTO tteo_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Kabo iwalolau kolili iba, “Inamwanamwa, kwalau kwaloya tem tomo yabo tovenu api namwanamwana kwalobai kwayoganama koliyau.” ");
INSERT INTO tteo_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","Na topaisowa yabo kainana iyamaisa iba, “Game yabo yagitai iya api kana koi ikatai. Iya game katekatepatuna yo kana koleya inamwanamwa yo tabe iya tokaleya namwanamwana. Iya iedeedede me ana katai yo tabe Yeoba mekanakava. Iya Yese tomo Bedeliema natuna yabo.” ");
INSERT INTO tteo_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","Kabo Saulo tosagenawasa iyawasali silau Yese koina kainana siwalowen bwaite besiele, “Natum iya togite-kalatan sipi esana Deibida kuwalo ilaoma koliyau.” ");
INSERT INTO tteo_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Yese Deibida iyawasa ilau Saulo koina me kana nima kabikabi donki kaigeda beledi sitauli pwatana mena oine patu kaigeda yo gouti natuna kaigeda. ");
INSERT INTO tteo_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","Saugana Deibida ilaoma Saulo koina ikalai ana topaisowa. Imulolo lalakisosina koina yo muli mena igitesipwai ana gogo kaleya kana tokayale. ");
INSERT INTO tteo_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Mwa Saulo walo iyawasa ilau Yese koina iba, “Yayaliyaya Deibida kaiwena kabo kutalamwan iyamala yagu topaisowa.” ");
INSERT INTO tteo_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Saugana tem yaluyaluwa naenaenane ilaoma Saulo koina mwayamwayau Deibida ana api ikalaiyama salina mena ikoi kabo mwayamwayau yaluyaluwane ilogabaen yo Saulo kamnana inamwanamwa. ");
INSERT INTO tteo_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Pilistiya tokaleya silogogo kaleya kaiwena yanuwa Soko koina, Yuda dedeina mena. Kabo sigogoya yanuwa Epesi Damimi, Aseka yo Soko luwaluwalili mena. ");
INSERT INTO tteo_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Na Saulo me ana tokaleyayao sigogo Ela kalogawana mena yo tokaleya simiya-lelei na mekalikavao Pilistiya sabi kaleya. ");
INSERT INTO tteo_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","Pilistiya simiya koya yabo mena yo Isileli tabe simiya koya yabo mena luwaluwalili mena kalogawana. ");
INSERT INTO tteo_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Na Pilistiya ali tokaikaiwe esana Golaiyadi yanuwa Gata tomona. Ali kaba gogo mena iyawatagilima saliyana kana mamalawe tili (3) mita. ");
INSERT INTO tteo_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","Kana pwaopwaom kopa siginauli kulukuluna mena yo ilobi gamwagamwalina kana kokaukausi kopa kana polowe besiele pipti seben (57) kilogelam. ");
INSERT INTO tteo_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","Tutulina mena ilobi kaena mena tabe kana suma kopa na dagelana mena ana wamali mamalawena kopa itaketake. ");
INSERT INTO tteo_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","Na nimana mena ana wamali kana lalaki besiele aeyan tuki yo kulukuluna kana polowe seben kilogelam. Ana ebeu kana tokayale manna mena ilolo-bagubaguna. ");
INSERT INTO tteo_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Ilau itolo mayale mena na iyogayoga-panaisi Isileli tokaleya kolili, “Tawae kaiwena kwalaoma kwamiya-lelei bwaite koina kaleya kaiwena? Nige wakakataiyau? Yau Pilistiya ali tokaikaiwe, na komiu Saulo ana topaisowa panpanli, wa? Saugamo yabo kolimiu wagite-sipwai na kwawalo ilobima koliyau. ");
INSERT INTO tteo_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Tem ilaoma ikoya-boitayau kai kani kaemala ami topaisowa panpanli. Na tem yakoyaboita kani komiu kwaemala ama topaisowa panpanli.” ");
INSERT INTO tteo_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Golaiyadi iyaelemo naga iwuiwui-kalatan iba, “Eei Isileli tokaleyayao kwabenali, kaliyate bwaite kani yakawa-naenae-yagimiu yo yasinalimiu. Ami tokaikaiwe yabo wagite-sipwai saugamo kwayawasa ilaoma mekaukava kakaleya.” ");
INSERT INTO tteo_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Saugana tomo bwaine ana wui Saulo me ana tokaleyayao sibenalan simatausi yo sikatewakaka lalakina. ");
INSERT INTO tteo_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","Na Deibida tamana esana Yese. Yese iya Epalati tomona simiyamiyaya Bedeliema siya susu Yuda. Natunao kali baibaiwa eit (8) yo Saulo ana sauga loina mena Yese itautaubala molosi. ");
INSERT INTO tteo_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","Yese natunao yaiyona lalakiliyao Saulo ana tokaleya bodaliyao kolili silusae, tobagubaguna Ilaiyabi, salina mena Abinadaba, yaiyonana Sama. ");
INSERT INTO tteo_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","Deibida iya tomulimuliye molosi. Na lalakiliyao yaiyonane simiyamiya Saulo mekalikava kaleya mena. ");
INSERT INTO tteo_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","Na Deibida nige imimiya-obiga ilau tamana koina sipi igite-kalatagili yo tabe ipileyoi Saulo koina. ");
INSERT INTO tteo_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Kaliyate kana baibaiwa poti (40) kalona mena malala yo lolau Golaiyadi ilaoma itolo yo iwuiwui-panaisi Isileli tokaleya kolili. ");
INSERT INTO tteo_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Kaliyate yabo mena Yese iwalolau natuna Deibida koina iba, “Bali gabugabuna bwaite ukwalai kana lalaki besiele kilogelam sanaulu (10) yo beledi sanaulu ukwalaili kulawagili kamkavao kolili siyaele kaba kaleya mena. ");
INSERT INTO tteo_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","Yo tabe besiele tisi sanaulu ukwalaili kulau kuwolegili kaleya kana tobaguna koina. Na kamkavao ugitaili na kulaoma yagu wasa tawae siginaginauli. ");
INSERT INTO tteo_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Siyaele Saulo me ana tokaleyayao Ela galogalowana mena Pilistiya mekalikavao sikalekaleya.” ");
INSERT INTO tteo_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Malala kikiuna Deibida itolo yo ikatububu na ilau kanakavao iyagaloloili tawae tamana ana walo iginauli besiele. Na sipi ilogabaegili togite-kalatan yabo mekanakavao. Saugana iyawatagili tokaleya ali dedei mena siya sikatububuko yo silalau kaba kaleya mena na siyogayoga kaleya kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Kabo Isileli tokaleya yo Pilistiya tokaleya sitolo-lelei ali kaba kaleya mena sitolo manli yo manli siemankulakula-yagili. ");
INSERT INTO tteo_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Saugana Deibida iyawatagili ginauli meuloina ipei kan kana togite-kalatan koina. Na isagena ilau tokaleya Isileli bodaliyao kolili kanakavao ilobaili yo ikawatoki kolili. ");
INSERT INTO tteo_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Yo mekanakavao siedeedede kabo Golaiyadi Pilistiya ali tokaikaiwe iutu-yawatagilima ali boda luwana mena iwuiwui-lau Isileli kolili besiele ana walo sinasinaliwa sauga meuloina kolili. Mwa Deibida ibenalan. ");
INSERT INTO tteo_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Saugana Isileli Golaiyadi sigitai simatausan mwa siyabubu. ");
INSERT INTO tteo_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","Na Isileli sibomamo siedeedede kolili siba, “Wagitai tomo bwaine sauga meuloina ilaoma isinasinalila. Na kin iwawalo temga yaiya tomo bwaine iunuyamate kani maisa lalakina iwolena yo tabe natuna sinena ikasolanan yo ana susuyao kani nige takesi siyayamaisa.” ");
INSERT INTO tteo_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Yo Deibida ineli tokaleya siya sitotolo salina mena kolili iba, “Na tomone iya Golaiyadi iunui yo kala mwalimwaline ikele-gabaen, tawae kani kin iginauli kaiwena? Yaiya Golaiyadi? Iya nige nigwenigwe tomona besi na iya laolaoma. Na gubesi kabo Yeoba meyawasina ana tomoyao isinalili?” ");
INSERT INTO tteo_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Mwa walona kaigedana siwalowen yoi Deibida koina siba, “Kin iya kainana yakato tem yaiya tomo bwaine iunui maisana kali baibaiwa bwaine besiele.” ");
INSERT INTO tteo_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","Na Deibida kana tobagubaguna esana Ilaiyabi, iyaele tenana iyawali ibenabenali tawae Deibida iwalowalowen. Kana seyala ikin Deibida koina iwalolau iba, “Am laoma bwaite koina yaina tawae? Na yaiya kani sipi igigite-kalatagili kulogabaegili siyaele dedei leleyanna mena? Yawasosi kowa togagasa yo tomwakota kulaoma na yakato kaleya kumanmanbubu.” ");
INSERT INTO tteo_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","Na Deibida iba, “Ginauli esana yasibayanae? Tabu yakato yaedeedede?” ");
INSERT INTO tteo_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Yo iutu-keile ilau tokaleya yabo koina walona kaigedana ineliyoi yo tokaleyayao kainana siyamaisa walona kaigedana besiele. ");
INSERT INTO tteo_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Deibida kainana kabona iwawalowenwa siyadebalala mwa tokaleya tupwaliyao silau Saulo ana wasa siwolena. Mwa Saulo walo iyawasa Deibida koina ilaoma igitai. ");
INSERT INTO tteo_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","Deibida iwalo Saulo koina iba, “Kita Isileli nige sowana Pilistiya yabo tamatausan. Yau am topaisowa kani yalau mekaukava kakaleya.” ");
INSERT INTO tteo_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Kabo Saulo iba, “Kowa nige sowam Pilistiya ali tokaiwe ukwaleyai. Kowa melumelu molosi, na iya ana sauga kilakai koina kaleya iyatubu ilaoma kanasiga kabona ana sauga tau matuwa koina.” ");
INSERT INTO tteo_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Na Deibida isamalulu molosi nige ibibiga iba, “Yau am topaisowa tamagu ana sipi yagitegite-kalatagili na saugana tem tokewali laiyon o beya tem ilaoma luwali mena na yabo ikalai, ");
INSERT INTO tteo_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","kani yasagena yamuli kusuli meyagu ginagina kanasiga yalau gamwana mena yakwayai. Na tem itagela-keile yakato ikanyau kani gwaugwauna mena yakabi-kalatan na galogalona yakiki-kalatan kabo yakoyamate. ");
INSERT INTO tteo_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Yau am topaisowa laiyon yo beya yakoyamateliko. Mwa tabe kaigedana kani yaginauli besiele Pilistiya mena koina kaiwena Yeoba meyawasina ana tomoyao isinasinalili. Iya nige nigwenigwe tomona. ");
INSERT INTO tteo_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Yeoba ileboiyauko laiyon yo beya gamwali mena. Besiele tabe kani ileboiyau tomone bwaine nimana mena.” Kabo Saulo iba, “Inamwanamwasosi kulau Yeoba mekamkava.” ");
INSERT INTO tteo_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Kabo kin Saulo itolo yo kana kwama kaleya ikalai yo Deibida iyalikwa. Gamwagamwalina kana kokaukausi ikalai ipei-yapatu koina yo kulukuluna kana suma ipwaom koina. ");
INSERT INTO tteo_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","Yo ana kaleya kelepana ikalai Deibida kasipuna mena itupa-kalatan itaketake na nuwanuwana tem imwasali nige sowasowana kaiwena sipolowesosi. Iwalolau Saulo koina, “Nige sowasowagu yo nige yamamanasamwagili.” Mwa ikele-gabaegili yo ipeili. ");
INSERT INTO tteo_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","Deibida ana ginagina ikalai yo iutu-lobi yalubwasi mena yo veku paibi (5) sapusapu molosili ikalaili, ana tobwa mena itaulili, ana lopeu ikalai ilau Golaiyadi salina mena. ");
INSERT INTO tteo_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Tabe Golaiyadi ana ebeu kana tokayale ibaguna kabo silau Deibida kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Golaiyadi manna igabaen ilau Deibida igitai iya game kilakai namwanamwana yona isapusapu mwa ikalomagigilan. ");
INSERT INTO tteo_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","Mwa iyogalau koina iba, “Kubatoko yau bwauwa mwa ginagina ukwalai kulaoma yakato kuunuiyau?” Kabo Golaiyadi Deibida ikawa-mananai Pilistiya ali kokotomo esali mena. ");
INSERT INTO tteo_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","Yo iyogalau iba, “Kulaoma saligu mena yakoyamateo na yom meuloina man toeva-keikeile mwayaga mena yo tabe ule yakayakan sokasokali sikekan bulumam mena.” ");
INSERT INTO tteo_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","Deibida kainana iyamaisa iba, “Kowa kulaoma ukwaleya koliyau am kaleya kelepana yo wamali lalakina mena, na yau yalaoma yakaleya koliwo Isileli tokaleyayao meuloili ali Yeoba tokaiwesosi esana mena iya kusinasinali-gwalagwalaiwa. ");
INSERT INTO tteo_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","Kabona bwaite Yeoba kani italamwagiwo nimagu mena yakoya-bekuwo kulobi kutalu bwatano mena na galogalom yakoutusi-gabaen. Muli mena Pilistiya ali tokaleyayao kakoyamateli na boiboitali kani kaolegili man yo yakayakan sokasokali sikekan kolili kabo tomo yanuwa yaulina sikatai Yeoba ama Yaubada imiyamiya Isileli kolimai. ");
INSERT INTO tteo_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Bwaite bodane ali logogone koina kani sikatai Yeoba ana tomoyao nige ileleboili kelepa yo wamali kolili. Na iya Tokaiwesosi kaleya koina mwa kabona kani meuloimiu italamwagimiu nimamai mena.” ");
INSERT INTO tteo_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Saugana Golaiyadi ilalaoma Deibida kaiwena nuwanuwana iunui Deibida isagena ilau Golaiyadi manna mena. ");
INSERT INTO tteo_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","Nimana ilobi ana tobwa kalona mena veku kaigeda ikalai itauli ana lopeu mena yo iloili iliyan kabo igabaen ieva-dudulai ilau Golaiyadi lamwana ikolapan yo ikobusu mwa ibeku bwatano mena iboita. ");
INSERT INTO tteo_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","Bwaite Deibida wasana besiele. Golaiyadi ikaiwe-gabaen mwa ikoyamate. Nige kaleya kelepana mena na lopeu yo veku kolili mwa ikoyamate. ");
INSERT INTO tteo_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","Kabo Deibida isagena ilau itolo yo ipwalou-talu nimana ilobi Golaiyadi ana kaleya kelepana iniwisi koina isakona yo galogalona itom. Saugana Pilistiya sigitai ali tokaiwewa iboita sitagelakeile yo siyabubu. ");
INSERT INTO tteo_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Kabo Isileli yo Yuda tokaleya siwui yo siwowo kainali lalakina yo Pilistiya sisagena yamuli kusulili. Sitawoili silau kanasiga yanuwa Gata yo Ekilon kaba lusalusaena mena. Na Pilistiya boiboitali simiyamiya bwagabwaga Salaima kana kamwasane koina ilalau Gata yo Ekilon. ");
INSERT INTO tteo_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","Saugana Isileli sipileyoima tawo mena silusae Pilistiya ali gogo meuloina sikalaili ali kaba gogo mena. ");
INSERT INTO tteo_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","Deibida itolo yo Golaiyadi kulukuluna ikalai ilawan Yelusalema na ana gogo kaleya ipeili iboma ana palai kalona mena. ");
INSERT INTO tteo_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","Saugana Deibida ilobi yo ilalau Golaiyadi ikakaleyai na Saulo Deibida imanmankulakulai mwa ineli kaleya kana tobaguna koina esana Abina iba, “Abina, kabona kilakaiwa yaiya natuna?” Abina iba, “O kin yawalo yawasosi koliwo nige yakakatai.” ");
INSERT INTO tteo_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","Mwa tabe kin Saulo iwaloyoi iba, “Kulau kuneliyan yaiya natuna kabona kilakaiwa?” ");
INSERT INTO tteo_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","Saugana Deibida Golaiyadi iunuyamate imwawasi ipileyoima kaba kaleya mena. Mwa Abina ilau iyoganama kin Saulo koina. Na Golaiyadi kulukuluna Deibida nimana mena. ");
INSERT INTO tteo_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","Kabo Saulo iba, “Kuwalo koliyau kowa toisabo taubala natuna?” Mwa Deibida Saulo kainana iyamaisa iba, “Yau am topaisowa taubala Yese Bedeliema mena natuna.” ");
INSERT INTO tteo_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","Saugana Deibida yo Saulo ali edeedede siyemwawasi Diyonatan ikawa-elieliyam Deibida koina yo muli mena imulolo lalakina koina besiele iya iboma kana mulolo. ");
INSERT INTO tteo_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","Kaliyatenane koina Saulo Deibida ikabi-kalatan ipaisowa koina, nige itatalamwan na ipileyoi tamana ana nume mena. ");
INSERT INTO tteo_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","Mwa tabe Diyonatan waloyameli kaikaiwena iginauli Deibida koina, kaiwena imulolososi koina besiele iboma kana mulolo. ");
INSERT INTO tteo_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","Yo ana waloyameli kaba kawa-yawasosiyanna kana kwama malamalawena yo kaleya kwamana ilolo iwolena Deibida besiele tabe ana kaleya kelepana, gipoyo yo kana wakisowa. ");
INSERT INTO tteo_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Saugana tem Saulo Deibida iyawasa ilau ikaleya ana paisowa meuloina inamwanamwa. Mwa Saulo ipeiseyan tokaleya ali tomo lalakina yabo. Tabe Saulo ana tokaleyayao nuwanuwasosili yo siyaliyaya Deibida ana paisowa kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Saugana Deibida Golaiyadi iunui imwawasi na tokaleyayao sipileyoi silalaoma kabo Isileli yanuwa kaigeda kaigeda sinesineoliyao me ali tambalin yo api kaba venu sikalaili silau kamwasa mena na Saulo me ana tokaleyayao simuloloili mwa sikoi siselo sanasanaili me ali yaliyaya, ");
INSERT INTO tteo_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","siwali siba, “Saulo wan tausan kali baibaiwa iunuili na Deibida ten tausan kali baibaiwa iunuili.” ");
INSERT INTO tteo_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Waline ana walomasala kaiwena Saulo kana lotonan inae me ana munamunai kaiwena iya wan tausan na Deibida ana ten tausan. Mwa inuwanuwatu me ana munamunai iba, “Deibida kani ipaisowa lalakina nige yaina yabo bwaimwanamo yagu kaba loina ikalai.” ");
INSERT INTO tteo_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Kaliyatenane koina Saulo iyatubu Deibida imanmankulakulai me ana kalomagigili koina. ");
INSERT INTO tteo_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","Yanuwa ilayan yaluyaluwa biki Yeoba koina ilaoma ilau ilusae Saulo koina me ana kaiwe. Mwa ana nume kalona mena imiyamiya iedeedede bwagabwaga ana paisowa meuloina besiele kabo toyauyaule mumugali. Na Deibida nigele bwai ana api ikalai ivenuvenu sauga meuloina ana paisowa besiele. Na Saulo kaleya wamalina yabo iyaele nimana mena ikabikabi-kalatan. ");
INSERT INTO tteo_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","Kabo Saulo iula nuwanuwana tem yakato Deibida me bilibilina ilogogonan. Sauga yaboyoi koina kana iulayoi. Mwa me labui kana iula na Deibida igigili-gabaegili. ");
INSERT INTO tteo_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","Yo Saulo Deibida imatausan kaiwena Deibida Yeoba mekanakava na Yeoba Saulo ilogabaenako. ");
INSERT INTO tteo_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","Kabo Saulo Deibida iyawasa suwalan ilau tokaleya wan tausan kali tobaguna. Ana tokaleyayao ibagunayagili silau sikaleya. ");
INSERT INTO tteo_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","Deibida paisowa namwanamwana meuloina ipaisowaili kaiwena Yeoba mekanakava. ");
INSERT INTO tteo_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","Saulo igite-lobai Deibida koina sanapu yawasosi mumugana imiyamiya mwa Deibida imatausan. ");
INSERT INTO tteo_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","Na Isileli yo Yuda meuloili Deibida simulolo lalakina koina kaiwena ibagunayagili silau kaleya kaigeda kaigeda kolili. ");
INSERT INTO tteo_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","Kabo Saulo iwalo Deibida koina iba, “Bwaite natugu sine tobagubaguna esana Melabi. Tem kulau kaleya koina me am katepatu ukaleya kaiwegu yo Yeoba kaiwena kani yaeyawa ukwasolanan wainem.” Na bwaite Saulo ibomamo ana nuwatu mena iedeedede, “Yau kani nige yauunui, sowana iboita Pilistiya nimali mena.” ");
INSERT INTO tteo_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","Deibida Saulo kainana iyamaisa iba, “Yau yaiya yakato yau bwasiyam? Yagu susu yo tamagu ana susu Isileli kalona mena nige esamai ilalalaki.” ");
INSERT INTO tteo_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","Na saugana yakato Saulo natuna Melabi iwolena Deibida na nigele. Iwolena tomo yabo esana Edilieli iya Meola tomona ikasolanan. ");
INSERT INTO tteo_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","Na Saulo natuna sinena yaboyoi esana Mikali Deibida igadosisiyan lalakina. Mwa Saulo ibenalan italam me ana yaliyaya. ");
INSERT INTO tteo_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","Kabo Saulo nuwana mena iba, “Mikali yatalamwan ikasolanan na iyamala kana sipwasipwa nonowana na mesabana Pilistiya siunuyamate.” Mwa Saulo iwalolau Deibida koina iba, “Kabona am solasola labuina kani kulobai na kuyamala bwasiyagu.” ");
INSERT INTO tteo_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","Kabo Saulo iwalo ana topaisowa lalakiliyao kolili iba, “Kwalau Deibida ibomamo koina kwaedeedede kwaba, ‘Ugitai kin iyaliyaya molosi kaiwem tabe kai besiele nuwanuwamai lalakina kowa iyaele kulaomako bwasiyana kowa.’” ");
INSERT INTO tteo_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","Saugana Saulo kainana siwalowen Deibida koina Deibida kainali iyamaisa iba, “Ami nuwatu mena yakato ginauli kikiuna bwaimwa kaiwena kwaedeededene? Yau nige sowasowagu yaemala tovelam kin koina kaiwena yau tomo bubutuma yo nige yagu katai ipapagan yau tomo bwagabwaga molosi.” ");
INSERT INTO tteo_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","Yo topaisowa silau Saulo koina siwalo-masala tawae Deibida kainana iwalowen kolili. ");
INSERT INTO tteo_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","Saulo iba, “Kwawalolau koina kwaba, ‘Saulo iwawalo nige nuwanuwana maisa yabo uloina koina natuna kuyamaisa na nuwanuwamo temga Pilistiya tomo wan andeledi kuunuili na yoli isuna kwapina kutom-gabaegili ukwalailima igitai kaiwena nuwanuwana kana gum iyai kana tokalomagigiliwone kolili.’” Nuwatu bwaine Saulo ana kalomagigili nuwatuna tem gubesi na Deibida iboita Pilistiya nimali mena. ");
INSERT INTO tteo_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","Topaisowa lalakili silau Deibida koina Saulo ana nuwatuwa siwalo-masalan mwa Deibida iyaliyaya iyamala tovelam Saulo bwasiyana. Muliya kabo kasole kana kaliyate sigolu, ");
INSERT INTO tteo_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","Deibida me ana tokaleyayao mwayamwayau mena silau Pilistiya kali baibaiwa tu andeledi siunuili yo yoli isuna kwapili sikalailima Saulo koina. Bwaine koina kawa yawasosi Deibida ilobai iya Saulo bwasiyana mwa natuna sine Mikali italamwan ikasolanan. ");
INSERT INTO tteo_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","Saugana Deibida ipileyoima meyawasina ikilala Yeoba imiyamiya Deibida koina yo tabe Mikali imulolo lalakina Deibida koina. ");
INSERT INTO tteo_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","Kabo Saulo imatausi lalakina Deibida koina yo ikalomagigilan yawasina kana sauga meuloina koina. ");
INSERT INTO tteo_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","Sauga meuloina Pilistiya ali tobagunao mekalikavao ali tokaleyayao siyawatagili silau Isileli mekalikavao sikalekaleya, na iyamo Deibida ikaiwe-gabaegili. Yo Deibida ikaiwesosi kaleya koina kabo muli mena Isileli tokaleyayao ali tobagunao meuloili. Kabo wasana ilalakisosi kaleya koina Isileli kalona mena. ");
INSERT INTO tteo_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","Saulo iwalo natuna Diyonatan koina yo tabe ana topaisowao kolili yakato Deibida siunuyamate. Na iyamo Diyonatan me ana yaliyaya Deibida koina, ");
INSERT INTO tteo_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","kabo Deibida iyanuwapei iwaloba, “Tamagu Saulo kamwasa iloyaloyai tem gubesi na iunuiwo koinaele ugite-kalatagiwo. Bwaliga malala kuyabubu kulau kaba keno-wadam yabo koina kumiyamiya waya. ");
INSERT INTO tteo_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","Kani yau yo tamagu kalaowa bubu mena katolo yo kaiwem kaedeedede. Na tem tawae iwalowen kaiwem kabo am wasa yaeyawa.” ");
INSERT INTO tteo_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","Kabo Diyonatan me tamana siedeedede Deibida kaiwena iwalo tamana koina iba, “Tabu nae yabo ugiginauli am topaisowa Deibida koina. Iya nige sauga yabo nae yabo igiginauli koliwo. Ginauli meuloina ipaisowaili kowamo kam sagu kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","Iya nige inunuwatui iboma yawasina kaiwena, iyaele tagitaiyako ilau Golaiyadi tomo Pilistiya iunuyamate. Isileli meuloina Yeoba ileboi polowe lalakina koina, mwa kowa kuyaliyaya lalakina. Deibida iya tomo dudulaina mwa am unuinane nige yaina ipapagan.” ");
INSERT INTO tteo_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","Mwa Diyonatan ana edeedede kaiwena Saulo ikawa-yawasosi yo ikawalulu-sae Yeoba Tokaiwesosi esana mena iba, “Kani nige Deibida yauunui.” ");
INSERT INTO tteo_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","Muli mena Diyonatan iyoga Deibida ilaoma koina ana wasa iwolena me tamana ali edeedede meuloina kaiwena. Kabo Diyonatan Deibida iyogan ilawan Saulo koina yo Deibida ipaisowa koina besiele tauna kona. ");
INSERT INTO tteo_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","Sauga yabo mena Isileli yo Pilistiya sikaleya. Deibida me ana tokaleyayao silau yo sikaleyaili. Na Deibida me ana tokaleyayao sikaiwesosi kabo Pilistiya siyabubu. ");
INSERT INTO tteo_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","Muli mena Saulo imiyasio ana nume mena ana kaleya wamalina nimana mena ikabikabi-kalatan. Kabo kana kasiebwawa iyatubuyoi yaluyaluwa naenaena ilaomaya Yeoba koina ilusae Saulo koina me ana kaiwe. Na Deibida iyaele ana api ikalai ikoikoi. ");
INSERT INTO tteo_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","Kabo Saulo wamaliwa ikabikabi-kalatanwa iulan Deibida kaiwena nuwanuwana tem me bilibilina ilogogonan. Na Deibida igigili-gabaen yo wamali ilau italu-tolo bilibili mena. Kabo Deibida boniyai mena iyabubu. ");
INSERT INTO tteo_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","Saulo tomo tupwaliyao iyawasali silau Deibida ana nume mena sisanasana tem ilayan gwaligwali na siunuyamate. Na iyamo Deibida wainena Mikali iwalolau koina iba, “Kuyabubu yawasim kaiwena tem nige kuyayabubu kani bwaliga malala kuboita.” ");
INSERT INTO tteo_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Mwa Mikali maina mena Deibida tomlape mena iyadalolo-yatalu bwatano mena mwa iyabubu. ");
INSERT INTO tteo_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","Na Mikali kokotomo yabo ikalai ipei-yakeno Deibida ana kaba keno mena yo kaleko lalakina ikalai iyakaboboi yo gouti wiyana koina kaleko siginauli ikalai kulukuluna mena isuma besiele yakato itona. ");
INSERT INTO tteo_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","Kabo Saulo tomo iyawasali silau yakato Deibida sikabi-kalatan mwa Mikali iwalolau kolili iba, “Deibida ikasiebwa iyaele ikenokeno ana kaba keno mena.” ");
INSERT INTO tteo_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","Mwa tabe sipileyoi Saulo koina ana wasa siwolena yo tabe Saulo iyawasa-yapileyoili Deibida koina. Iwalolau kolili iba, “Kwalau ana kaba keno mena wakalai yo wakewai kwalawanama koliyau na yakoyamate iboita.” ");
INSERT INTO tteo_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","Saugana silusae nume kalona mena manli ilaowa kokotomo sigitai ikenokeno Deibida ana kaba keno mena na kulukuluna mena gouti wiyana. Mwa tabe sipileyoi Saulo ana wasa siwolena yoi. ");
INSERT INTO tteo_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","Saulo itolo yo Mikali iyoga ilaoma koina ineli iba, “Tawae kaiwena kumwakota-yagau na kagu kaleyane kuyawasa iyabubu ilowasine?” Kabo Mikali tamana kainana iyamaisa iba, “Iula-matamatausagau iba, ‘Tem nige kusasaguiyau kani yakoyamateo.’” ");
INSERT INTO tteo_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","Kabo saugana Deibida iyabubu ilau yanuwa Lama Samuela koina. Kabo ginauli meuloina iwalo-masalan Samuela koina tawae Saulo mumugana iginauli koina. Kabo mekanakava sitolo yo silau yanuwa Naiyodi koina simiyamiya waya. ");
INSERT INTO tteo_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","Saulo wasa ibenalan yakato Deibida iyaele Naiyodi imiyamiya. ");
INSERT INTO tteo_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","Yo tomo tupwaliyao iyawasali silau na yakato sikabi-kalatan. Saugana silau siyawatagili silobai palopita bodaliyao mekalikava Samuela iya ibagunayagili Yeoba yaluyaluwana ana kaiwe ilobi kolili kabo sipalopalopisai. Kabo tabe siya tolaowa kaiwe ilobiyoi kolili sipalopalopisai. ");
INSERT INTO tteo_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","Saulo wasali ibenalan yo tabe boda yabo iyawasali yoi silau, tabe siya besiele sipalopalopisai mwa boda yaiyonana iyawasali yoi silau tabe pagan na kaigedana yoi iyawatagili kolili besiele. ");
INSERT INTO tteo_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","Ana kaba mwawasi Saulo iya iboma itolo yo ilau. Saugana ilalau yanuwa Lama kaiwena kabo iyawatagili waila keli lalakina yabo koina yanuwa Seku koina. Kabo ineli tomonliyao kolili iba, “Samuela yo Deibida to simiyamiyaya?” Siba, “Siyaele Naiyodi, Lama koina.” ");
INSERT INTO tteo_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","Kamwasa mena ilaulau Naiyodi kaiwena kabo Yeoba yaluyaluwana ana kaiwe ilobi koina yo ipalopalopisai kanasiga iyawatagili yanuwa Naiyodi koina. ");
INSERT INTO tteo_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","Yo kana kwama tupwaliyao ilololi na yona me bwagabwagana kabo ipalopalopisai Samuela manna mena. Yo ilobi italu bwatano mena ikenokeno kaliyate yo boniyai meuloina mena. Kabo bwaine kaiwena tomo siwaloba, “Gubesi, Saulo iya palopita yabo luwali mena?” ");
INSERT INTO tteo_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","Yo Deibida Naiyodi ilogabaen yo ilau Diyonatan koina ineli iba, “Tawae yagu pwanoli yo tawae yaginauli-yanae? Ginauli esana kaiwena mwa tamam itonan nuwanuwana tem ikoyamateyau?” ");
INSERT INTO tteo_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","Kabo Diyonatan itolo yo kainana iyamaisa iba, “Nigele. Kani nige kuboboita. Kaiwena tamagu tawae inuwanuwatui yo iginaginauli nuwana lalakina o kikiuna nige sowana iwadam koliyau kani meuloina ipei-yamayale koliyau yakatai.” ");
INSERT INTO tteo_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","Kabo Deibida iwalo Diyonatan koina iba, “Tamam ikatai namwanamwai ala kawa-elieliyam. Koinaele tamam ibomamo iyaele nuwana mena iba, ‘Kani nige yawawalo-masalan Diyonatan koina kisi me ana nuwanae.’ Koinaele yawalo yawasosi koliwo, boita iyaele saligu mena. Yakawalulu Yeoba meyawasina esana mena yakawa-yawasosi koliwo.” ");
INSERT INTO tteo_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","Kabo Diyonatan iwalolau Deibida koina iba, “Tawae nuwanuwam kuwalowen kani yaginauli besiele am nuwatune.” ");
INSERT INTO tteo_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","Mwa Deibida iwaloba, “Ugitai bwaliga waikena waluwaluna soina mwa kani nige kin mekaukava kakekekan. Kutalamwagau yalau bubu mena yakeno-wadam kanasiga kaliyate yaiyona simwawasi lolauna koina kabo yapileyoima. ");
INSERT INTO tteo_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","Tem tamam igite-koli-yagau na ineli koliwo kuba, ‘Deibida ikawanoi samasamalulu koliyau mwa yatalamwan ilomwayamwayau ilau Bedeliema ana yanuwa mena me ana bodao pwaoli sigabu besiele mumugali bolime kaigeda kaigeda koina pwaoli sigabugabu.’ ");
INSERT INTO tteo_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","Tem iba, ‘Inamwanamwa’ ee yau am topaisowa kani yanamwanamwa. Na tem imunamunai kabo ukwatai nuwatu naenaesosina iyaele katena mena nuwanuwana iunuiyau. ");
INSERT INTO tteo_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","Na kowa kaiwem, nuwanuwagu kusaguiyau yo mumugam inamwanamwa yau am topaisowa koliyau. Kaiwena kowa yo yau tawaloyameliko Yeoba manna mena. Na tem ugitaiyau yalopwano sowana kowa kuunuiyau, na tabu kisi kulawagau tamam koina.” ");
INSERT INTO tteo_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","Diyonatan iba, “Nigele, nige yakakatai tamagu ana nuwatu yawasosi kani iunuiwo o nigele. Tem yakatai kani tawae kaiwena yawadam koliwo?” ");
INSERT INTO tteo_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","Kabo Deibida ineli iba, “Kani gubesi yagu katakataina yakato tamam imunamunai koliyau?” ");
INSERT INTO tteo_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","Diyonatan iba, “Kulaoma talau bubu mena.” Yo siyawatagili silolabulabui silau. ");
INSERT INTO tteo_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","Yo Diyonatan Deibida koina iwalo iba, “Yeoba Isileli ana Yaubada manna mena yawaloyameli koliwo, kani tamagu koina yaneli na tawae ana walo yabenalan kabo bolawa am wasa yaeyawa. Tem iyaliyaya kaiwem kani am wasa yaeyawa dudulaina mesabana me am katai. ");
INSERT INTO tteo_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","Na tem tamagu ana nuwatu yakato iunuiwo kani yayanuwapeiwo na daumwali mena kuyabubu kulau. Tem nige yagiginauli besiele kani Yeoba polowe yabo iyeyama koliyau. Kabo kani yakawanoi Yeoba koina iya mekamkava besiele tauna kona tamagu Yeoba mekanakava. ");
INSERT INTO tteo_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","Na saugane bwaite koina iyaele meyawasigu yamiyamiya nuwanuwagu ukate-kamkamna-yagau walo yawasosi mena besiele Yeoba ana katekamkamna. ");
INSERT INTO tteo_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","Na tem yaboita nuwanuwagu am katekamkamnane ilopanaisi ilau yagu susuwo meuloili kolili. Bwagana Yeoba kam tokalomagigiliwo meuloili iunu wolili na yagu susuwo kunuwatu-kalatagili kusaguili.” ");
INSERT INTO tteo_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","Na Diyonatan yo Deibida siwaloyameli bwaine besiele yo Diyonatan iwaloba, “Kani yakawanoi Yeoba koina kam tokalomagigiliwo iyamaisali.” ");
INSERT INTO tteo_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","Yo Diyonatan me ana walo kaiwe Deibida koina nuwanuwana iya iboma kana mulolo ilowalui yoi, kaiwena Diyonatan imulolo Deibida koina besiele iboma kana mulolo. ");
INSERT INTO tteo_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","Na Diyonatan iwalolau Deibida koina iba, “Bwaliga waikena waluwaluna soina kana kaliyate. Mwa kani kowa am kaba miya bwagabwagana. Kabo kani tamagu igitai nigele yo tabe kani ineli kaiwem. ");
INSERT INTO tteo_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","Na bolawa lolau molosi mena kulobi iya tauna kona koina ukeno-wadam veku lalakina Eseli dagelana mena kusanasanaiyau. ");
INSERT INTO tteo_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","Kani wamali yaiyona gipoyo mena yamomosili na yaulaili vekune koina yakato ginauli yabo yaunui. ");
INSERT INTO tteo_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","Na game yabo kani yayawasa yo kani yawalolau koina yaba, ‘Kulau wamaline kuloyaili’. Tem yawaloyoi koina yaba ‘Ugitai wamaliwa siyaelete dedeim mena ukwalaili na kulaoma’ kabo ukwatai nige polowe yabo kani kulolobai. Yeoba esana mena yakawalulu kani yawalo yawasosi koliwo. ");
INSERT INTO tteo_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","Na tem gamene koina yawalo yaba, ‘Ugitai wamaline siyaele manim mena kali mwayaga tupwana iyai koliwo’ sowana kuyabubumo kulau kaiwena bwaimwa Yeoba iyayawasao. ");
INSERT INTO tteo_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","Mwa waloyameline kowa te yau taginauliyako Yaubada igitailako mwa imiyamiya kowa te yau luwaluwalila mena kani nige ilolotom.” ");
INSERT INTO tteo_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","Kabo waikena waluwaluna kana sauga ilaomako na Deibida ilau bubu mena ikeno-wadam, na kin imiyasio ana kaba miyasio mena sabi kekan. ");
INSERT INTO tteo_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","Imiyasio besiele sauga meuloina mumugana salibebe salina mena yo Abina iya Saulo salina mena imiyasio. Diyonatan imiyasio tamana manna mena na Deibida ana kaba miya bwagabwagana. ");
INSERT INTO tteo_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","Saulo igitai Deibida ana kaba miya bwagabwagana mwa nige tawae yabo iwawalowen kaiwena ana nuwatu mena iba, “Nuwana ginauli yabo iyawatagili mwa Deibida ibomayoi iula-bikibiki kabo nige sowana ilaoma kekan kaiwena.” ");
INSERT INTO tteo_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","Waikena waluwaluna kana kaliyate labuina, Saulo igitai Deibida ana kaba miya bwagabwagana yoi. Kabo ineli Diyonatan koina iba, “Gubesi laina yo kabona Yese natuna nige mekalakava takekekan toyawa?” ");
INSERT INTO tteo_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","Diyonatan kainana iyamaisa iba, “Deibida ikawanoi samasamalulu koliyau na tem yatalamwan ilau Bedeliema, ");
INSERT INTO tteo_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","iwaloba, ‘Kutalamwagau yalau yagu yanuwa mena kaiwena yagu susuwo meuloili pwaoli yabo kani siginauli mwa kaukava kagu loina iwalowen tabu toweya yalalau. Tem ukawa-namwanamwa-yan yagu kawanoine kategu kowa kulivasiyau yalau kaukavao yagitaili.’ Bwaine iya nuwatune kaiwena mwa nige ilalaoma mekalakava ala kekanne koina.” ");
INSERT INTO tteo_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","Bwaine koina Saulo imunamunai molosi iwalolau Diyonatan koina iba, “Kowa sine ganaganawalina yo walona kolokololona natuna. Yakatai kowa Deibida ukelabilabin-yan sosi mwa koinaele kani kuboma kam mwalimwaline yaina ukabi-yamayale yo tabe sinam tokabiwo kana mwalimwaline yaina kupei. ");
INSERT INTO tteo_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","Tem Yese natuna meyawasina imiyamiya yanuwa yaulina mena kowa kani nige kuyayamala kin yo kani nige am kaba loina ipapagan. Bwaite saugamo tomo yabo kuyawasa ilau na iyoganama na yaunuyamate, kaiwena ilonamwayan iboita.” ");
INSERT INTO tteo_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","Na Diyonatan ineli iba, “Tawae kaiwena nuwanuwam kuunuyamate? Tawae ana lopwano?” ");
INSERT INTO tteo_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","Mwa Saulo me ana munamunai wamali ikalai Diyonatan kana iula tem isakona-yamate. Kabo Diyonatan ikatai ilobaiyako tamana nuwanuwa molosina tem Deibida ikoyamate. ");
INSERT INTO tteo_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","Yo Diyonatan tabe imunamunai molosi yo ana kaba miya itolo-gabaen. Yo waikena waluwaluna soina kana kaliyate labuina kekanna nige kanna yabo ikakan-tonan, kaiwena tamana ana paisowa mwalimwalinena kaiwena Deibida esana ipei-yatalu. ");
INSERT INTO tteo_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","Malala kikiuna Diyonatan game yabo iyogan mekanakava silau bubu mena Deibida sabi gitaina besiele tauna kona ali edeededewa kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","Kabo Diyonatan iwalolau gamene koina iba, “Kusagena kulau wamali yaulagili silaoko kulau kuloyaili.” Gamene isagesagena na gipoyo imomosi yoi wamali kaigeda iulan ieva ilau italu manna mena. ");
INSERT INTO tteo_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","Saugana gamene ilau iyawatagili Diyonatan ana wamali ali kaba talu tolo mena kabo Diyonatan iyogalau koina iba, “Ugitai wamaliwa siyaele manim mena kali mwayaga tupwana iyai koliwo. ");
INSERT INTO tteo_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","Kulomwayamwayau tabu ukakaiyawasi.” Yo gamene ilau wamaliwa itanoili yo ipileyoi ilau ana taubala koina. ");
INSERT INTO tteo_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","Na gamene nige tawae yabo ikakatai bwaimwanamo Diyonatan yo Deibida sikatai tawae ilaulau. ");
INSERT INTO tteo_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","Kabo Diyonatan ana wamaliwo yo gipoyo iwolena gamene koina iba, “Ukwalaili na kupileyoi yanuwa mena.” ");
INSERT INTO tteo_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","Yo gamene ilaoko mulina mena kabo Deibida dedei tete yavana mena itolo ilu-yawatagilima yo ipwalou-talu bwatano mena me yaiyona ana yakasisi iginauli Diyonatan koina. Kabo sisapwali sinisoi yo sivalam yoli labuine na iyamo Deibida ivalam sosi. ");
INSERT INTO tteo_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","Kabo Diyonatan iwalolau Deibida koina iba, “Daumwali mena kulau kaiwena waloyameline bwaite imiyamiya sauga meuloina kani nige ilolotom. Na waloyameline iyaele kaiwela imiyamiya yo tubumwao yo tubuguwao kaiweli tabe.” Yo Deibida ilau na Diyonatan ipileyoi ana yanuwa mena. ");
INSERT INTO tteo_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Kabo Deibida ilau yanuwa Nobi topwaoli Eimileki koina. Saugana iyawatagili Nobi, Eimileki Deibida igitai me ana tabubu kabo iwalolau Deibida koina iba, “Tawae kaiwena mwa kubomamo na nige yabo mekamkava kam egelugelu?” ");
INSERT INTO tteo_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","Yo Deibida Eimileki kainana iyamaisa iba, “Kin Saulo ginauli yabo kaiwena mwa iyawasayau ana nuwatu yabo kaiwena yo iwalo koliyau iba, ‘Kisi yabo koina kuwalo-masala am laune yaina ikatai.’ Na iyaele yawalo yagu kilakaiwo kolili kani kabo silaoma sigitaiyau dedei yabo mena. ");
INSERT INTO tteo_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Na tawae iyaele koliwo na yakekan? Pwalawa paibi (5) kuyelima o nuwana tem kan yabo iyaele koliwo kuyeyama.” ");
INSERT INTO tteo_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Na topwaoli Deibida kainana iyamaisa iba, “Nige beledi uloina yabo imiyamiya bwaimwanamo pwalawa yakayakasisina. Na tem am kilakaiwo nige silalau vesalao kolili sikekeno laina yo kabona, ee inamwanamwa sowasowamiu wakan.” ");
INSERT INTO tteo_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","Kabo Deibida Eimileki kainana iyamaisa iba, “Laina yo kabona nige kalalau vesalao mekamakavao kakekeno. Meyagu kilakaiwo kayakasisi-yagimai vesalao kolili, yomai sikapwa nuwana tem kalau kaleya koina o nuwana paisowa yabo koina o tawae yabo koina tabe. Mwa kabona bwaite kaliyatene koina yomai kapwakapwali.” ");
INSERT INTO tteo_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Mwa topwaoli beledi yakayakasisina iwolena kaiwena nige pwalawa uloina yabo ipapagan. Beledi yakayakasisinamo sipei teibele mena Yeoba manna mena sikalai mwa miyalaena beledi wedowedolina waluwaluna sipeiyoi. ");
INSERT INTO tteo_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","Sauganane koina Saulo ana sipi togite-kalatan kali tobaguna esana Doegi tomo Idoma imiyamiya bwaine koina na tapwalolo paisowana ipaipaisowai. ");
INSERT INTO tteo_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","Yo Deibida ineli Eimileki koina iba, “Tabu wamali yabo o kaleya kelepana yabo koliwo? Yau gogo kaleya nige yabo yakakalai kaiwena kin Saulo iwalo-tubatubaliyau ana paisowa kaiwena mwa me nima gaibugu yalaoma.” ");
INSERT INTO tteo_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","Eimileki kainana iyamaisa iba, “Golaiyadi tomo Pilistiya iya tauna kona kuunui Ela galogalowana mena ana kaleya kelepana iyaele bwaite kasuma kaleko mena na kapei ipodi dagelana mena. Tem nuwanuwam ukwalai, kaiwena nige gogo kaleya yabo bwai kaigedamo.” Kabo Deibida iba, “Inamwanamwasosi, kuyeyama koliyau kaiwena nige yaboyoi kaleya kelepana namwanamwana imiyamiya.” ");
INSERT INTO tteo_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","Kaliyatenane koina Deibida Saulo iyabubu-gabaen ilau imiyamiya waya Gata ali kin Akisa koina, bwaine Pilistiya ali dedei. ");
INSERT INTO tteo_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","Na kin Akisa ana topaisowao siwalolau koina siba, “Gubesi bwaite tomone nige ukwakatai? Iya Deibida ana yanuwa kana kin, tauna kona siwaliwali yo siseloselo na siba, ‘Saulo tausan iunuili na Deibida ten tausan iunuili.’” ");
INSERT INTO tteo_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","Walo bwaite kaiwena Deibida katena mena inuwatu-kalatan yo imatausi lalakina Gata ali kin Akisa koina. ");
INSERT INTO tteo_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","Kabo Deibida iyatubu iyauyaule mwakomwakota manli mena yakato iya tokabaleya yabo saugana imiyamiya kolili. Kabo ilau yanuwa kana gamwa kaba lusalusaena mena ilelelele bwagabwaga yo gilolona sididi silobi palasana mena. ");
INSERT INTO tteo_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","Kabo Akisa igitagitai yo iwalolau ana topaisowao kolili iba, “Wagitai tomone iya kabakabaleyana. Na tawae kaiwena kwayogan kwalawanama koliyau? ");
INSERT INTO tteo_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","Ami nuwatu yakato nige kabaleya ala yanuwa mena mwa tomone bwaite kabakabaleyanane kwalawanama mangu mena? Ami nuwatu yakato bwaite tomone kani ilaoma yagu nume mena ilusae?” ");
INSERT INTO tteo_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","Kabo Deibida yanuwa Gata ilogabaen mwa iyabubu ilau dupa lalakina esana Adulami. Na tamana ana nume kana tomiyayao yo tabe kanakavao wasana sibenalan mwa silobi sipatu koina mekalikava simiyamiya waya. ");
INSERT INTO tteo_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","Yo meuloili miyapolowe silobai tupwaliyao kali yagayaga nige siyayamaisali mwa meuloili nuwali sinae kabo silogogo silobi Deibida koina iya sipei kali tobaguna mwa tomone kali baibaiwa powa andeledi (400). ");
INSERT INTO tteo_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","Muli mena Deibida ilau Mowabe kana kin yanuwa Mispa koina iba, “Kategu kowa tem kutalam sinagu yo tamagu silaoma koliwo mekamikavao bwaite koina kwamiyamiya kanasiga yakatai kani Yeoba tawae iginauli kaiwegu.” ");
INSERT INTO tteo_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","Kabo ipei-gabaegili Mowabe kana kin nimana mena na iya ilau Adulami dupana yabo koina ikeno-wadam yo imiyamiya waya bwaine koina. ");
INSERT INTO tteo_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","Muli mena palopita yabo esana Gada ilau Deibida koina yo iwaloba, “Tabu bwaite koina kumiyamiya. Kutolo kulau Yuda dedeina koina.” Mwa Deibida itolo yo ilau yanuwa Eledi gunuwalana mena ilusae yo imiyamiya. ");
INSERT INTO tteo_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","Deibida ilau yo ikeno-wadam koya kolili bwaine ule bwagabwaga mena esana Sip koina. Kaliyate kaigeda kaigeda Saulo iloyaloyai. Na Yeoba Deibida nige itatalamwan Saulo nimana mena. ");
INSERT INTO tteo_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","Saulo Pilistiya tokaleya itawoili yo ipileyoima kabo ana wasa siwolena siba, “Deibida iyaele ule bwagabwaga mena Engedi koina.” ");
INSERT INTO tteo_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","Kabo Saulo tomo igite-sipwaili Isileli kalona mena tili tausan (3,000) tokaleya ikalaili. Silau Deibida me ana kilakaiwo siloyaili yanuwa esana Ule Goutiliyao Kali Veku koina. ");
INSERT INTO tteo_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","Kabo silau siyawatagili sipi kali gana tupwaliyao kolili kamwasa papalina mena. Dupa yabo iyaele bwaine koina Saulo ilau ilusae koina sabi lodedei na Deibida me ana kilakaiwo siyaele dupane gamwana papali yabo mena. ");
INSERT INTO tteo_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","Yo kabo Deibida ana kilakaiwo sibalamumu koina siba, “Ugitai kabona kaliyatene bwaite koina am sauga namwanamwana Yeoba iyeyawa koliwo saugana iba, ‘Kam tokalomagigili yatalamwan nimam mena tem tawae nuwanuwam uginauli koina kupaisowai besiele am nuwatu.’” Mwa Deibida kikiuna kikiuna inene isae Saulo dagelana mena kana kwama malamalawena isuna itom-utusi ikalai. Na Saulo nige ikakatai. ");
INSERT INTO tteo_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","Saugana Saulo kana kwama isuna itom-utusi kabo Deibida nuwana inae katena ikamkamna molosi. ");
INSERT INTO tteo_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","Iwalolau ana kilakaiwo kolili iba, “Yeoba isikote tabu bwaine kamwasane yagiginauli yagu taubala koina. Iya Yeoba ana yaoyaolo tomonna, koinaele nige sowana nimagu italu koina.” ");
INSERT INTO tteo_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","Walone bwaite koina Deibida ana kilakaiwo simwanou nige sowana tawae yabo naenaena siginauli Saulo koina mwa Saulo dupane ilogabaen na ilau. ");
INSERT INTO tteo_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","Tabe Deibida dupa mena ilu-yawatagili yo iyogalau Saulo koina iba, “Yagu taubala yo yagu kin.” Saugana Saulo ibenalan kabo itagelakeile na Deibida igitai ipwalou-talu bwatano mena me ana yakasisi. ");
INSERT INTO tteo_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","Yo Deibida iwalolau Saulo koina iba, “Tawae kaiwena tomo kainali kubenalan? Yakato yau Deibida yaloyaloyaiwo na yayaboitao? ");
INSERT INTO tteo_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","Kabona bwaite kaliyatene koina kubomamo manim mena ugitai Yeoba italamwagiwo nimagu mena dupane kalona mena. Tomo tupwaliyao siwalo-tubaliyau yakato yayaboitao na iyamo yawaloba, ‘Nigele, nige sowana nimagu italu koina.’ Yakate-kamkamna-yagiwo kaiwena kowa yagu taubala yo kowa Yeoba ana yaoyaolo tomonna. ");
INSERT INTO tteo_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","Kabo ugitai, tamagu, kam kwama isuna iyaelete nimagu mena. Yatom-utusi na nige yakokoyamateo. Bwaine koina na ukwatai yo nuwam idudulai yau nige togamwa-panapanawa yo nige nae yabo yagiginauli. Nige tawae yabo naenaena yagiginauli koliwo na kowa kuloyaloyaiyau nuwanuwam kuunuyamateyau. ");
INSERT INTO tteo_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","Sowasowana Yeoba iloina dudulai kowa te yau kaiwela yo kani iyamaisao am paisowa naenaena koliyau. Na yau nimagu kani nige ikakabi-tonagiwo. ");
INSERT INTO tteo_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","Besiele tubulao baguna ali walo yabo sauga meuloina siwalowalowen siba, ‘Siya tomumuga naenae kolili mumugana naenaena iyawayawatagilima.’ Mwa yau kani nige tawae yabo naenaena nimagune igiginauli koliwo yom ikakabi-tonan. ");
INSERT INTO tteo_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","Toisabo tomo kaiwena mwa Isileli kana kin iyawatagilima iloyaloyai? Toisabo bwauwa boiboitana kaiwena am sauga kuyaveyavenuwanne? Nuwana ginauli kikiuna yabo? ");
INSERT INTO tteo_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","Yeoba iya kala toyatala iyamo iloina-yagila kowa te yau luwaluwalila mena. Kani yakawanoi koina kagu polowene kaiwena na isaguiyau yo nimam mena ileboiyau.” ");
INSERT INTO tteo_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","Saugana Deibida ana edeedede meuloina iyemwawasi kabo Saulo iyogalau ineli Deibida koina iba, “Deibida, natugu kowa, kuyogayogama koliyau?” Mwa Saulo ivalam kainana lalakina. ");
INSERT INTO tteo_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","Yo iwalolau Deibida koina iba, “Mumugam idudulaisosi na mumugagu inae. Am paisowa koliyau inamwanamwasosi na yau yagu paisowa koliwo inaesosi. ");
INSERT INTO tteo_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","Kabona mumugam namwanamwana meuloina kupei manigu mena yaboma yagitai yo yabenalan. Kabo Yeoba italam-wagauko nimam mena na iyamo nige kuunuiyau. ");
INSERT INTO tteo_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","Tem tomo kana kaleya ilobai, gubesi, italamwan me ana namwanamwana yo me ana yaliyaya ilau? Nigele. Sowana Yaubada iwalo-muloloiwo, kaiwena mumuga dudulaina uginauli koliyau kabona. ");
INSERT INTO tteo_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","Kabo yakatai namwanamwai kowa kani kuyamala kin Isileli koina. Yo Isileli ana kaba loina kani nimam mena ikin me ana kaiwe. ");
INSERT INTO tteo_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","Nuwanuwagu tem Yeoba esana mena am waloyameli uginauli koliyau tubuguwao kagu yaso muliye tabu kuyeyemwawasili yo tabu esagu ikwakwalalele tamagu ana susu kalona mena.” ");
INSERT INTO tteo_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","Kabo Deibida ana waloyameli iginauli Saulo koina. Kabo Saulo ipileyoi ana yanuwa mena na Deibida me ana kilakaiwo tabe sipileyoi ali kaba keno-wadam mena. ");
INSERT INTO tteo_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","Na Samuela iboita kabo Isileli meuloili silogogo yo sivalam ana boita kaiwena. Yona sipului ana yanuwa esana Lama. Imwawasi kabo Deibida ilau yo imiyamiya ule bwagabwaga mena yanuwa Maon salina mena. ");
INSERT INTO tteo_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","Tomo tupwali silaomaya yanuwa Sip silaoma Saulo ana nume Gibeya koina yo siwaloba, “Deibida iyaele ikeno-wadam koya Akila bwaimwa yanuwa Yesimon manna mena.” ");
INSERT INTO tteo_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","Na Abisai iwalo Deibida koina iba, “Walo yawasosi, Yeoba kam tokalomagigili ipei nimam mena. Kuwalo na yatupa-yamate yayapatu bwatano mena ibomamo ana wamali koina. Mekaigedamo kani yasakona na iboita.” ");
INSERT INTO tteo_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","Kabo Saulo iwalo Deibida koina iba, “Natugu Deibida, Yeoba iwalo-muloloiwo. Walo yawasosi, tawae uginauli kani inamwanamwa yo kowa kani kuyamala tomo kaikaiwena.” Imwawasi kabo Deibida ilau yo Saulo ipileyoi ana yanuwa. ");
INSERT INTO tteo_vpl VALUES ("S127_12","010_27_12","1SA","27","12","12","Mwa kin Akisa ana meli ipei Deibida koina na ibomamo ana nuwatu bwaite, “Nuwana tomo Isileli Deibida sikalomagigilan lalakina mwa nige sowana ipileyoi ana yanuwa Isileli na imiyamiya yau kaba loina mena na ipaipaisowa kaiwegu kanasiga iboita.” ");
INSERT INTO tteo_vpl VALUES ("S128_1","010_28_1","1SA","28","1","1","Sauganane koina Pilistiya ali tokaleyayao meuloili silogogo na nuwanuwali Isileli sikaleyaili. Kabo kin Akisa iwalolau Deibida koina iba, “Nuwanuwagu kowa me am tomoyao kwalaoma tayaboda-kaigedaila na Isileli takaleyaili.” ");
INSERT INTO tteo_vpl VALUES ("S128_2","010_28_2","1SA","28","2","2","Na Deibida iwalo koina iba, “Tem bwaimwa besiele kani kabo kuboma ugitaiyau waya bwaine koina gubesi kani yagu kaleya kana koleya?” Kabo Akisa iba, “Inamwanamwa tem bwaimwa besiele kani yapeiwo kowa kagu togite-kalatan sauga meuloina.” ");
INSERT INTO tteo_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","Na tauna kona Samuela ana sauga imwawasi yo Isileli meuloili sivalam koyasili kaiwena yo silawan ana yanuwa mena Lama koina sipei salai mena. Yo tabe Saulo tokalawe yo tokukula meuloili ikele-gabaegiliko Isileli kalona mena. ");
INSERT INTO tteo_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","Na Pilistiya tokaleya meuloili silau yanuwa Sunema koina sigogoya simiyamiya. Na Saulo Isileli ikalaili silau yanuwa Gilibowa koina sigogo. ");
INSERT INTO tteo_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","Saugana Saulo manna ilau Pilistiya tokaleya igitaili kabo imatausi yo katena iwakaka molosi. ");
INSERT INTO tteo_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","Mwa ineli Yeoba koina na Yeoba Saulo kainana nige iyayamaisa nuwana kenona mena o nuwana Ulim yo Tamim kolili o nuwana palopita kolili. ");
INSERT INTO tteo_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","Yo iwalolau ana topaisowa esa lalakiliyao kolili iba, “Kwalau sine yabo kwaloyai iya tokalawe na yalau koina yaneli tawae yaginauli.” Kabo siba, “O, kaigeda iyaele yanuwa Endola koina.” ");
INSERT INTO tteo_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","Kabo Saulo ikwama-yaoyaowa na mesabana tabu sikikilala mwa boniyai mena tomo labui mekanakavao silau sinene koina. Iwalo sinene koina iwaloba, “Nuwanuwagu toboita bwaite esana yakatai koliwo na yaluyaluwana kuyoganama koliyau na yagu wasa iyeyama tawae kani iyayawatagiline sauga ilalaoma koina.” ");
INSERT INTO tteo_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","Na sinene iwalolau koina iba, “Na ukwataiyako Saulo tokalawe yo tobalau meuloili yanuwa bwaite koina ikele-gabaegiliko. Na kowa tawae kaiwena kulaoma kutonagau? Besiele sipwasipwa uginauli koliyau yawasigu kaba tom-utusina.” ");
INSERT INTO tteo_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","Kabo Saulo ikawalulu-sae Yeoba koina iba, “Kagu lulu Yeoba meyawasina koina kani nige naenaena maisana yabo kulolobai.” ");
INSERT INTO tteo_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","Yo sinene ineli, “Yaiya nuwanuwam yaluyaluwana yayogan ilaoma koliwo?” Kabo Saulo iba, “Samuela yaluyaluwana kuyogan isaema koliyau.” ");
INSERT INTO tteo_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","Kabo sinene iginauli besiele Saulo ana walo, kabo saugana Samuela yaluyaluwana igitai kabo iwui kainana lalakina yo iwalolau Saulo koina iba, “Tawae kaiwena kumwakota-yagau? Tomalaele kowa kin Saulo.” ");
INSERT INTO tteo_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","Kin iwalolau koina iba, “Tabu kumamatausi. Na kuwalo koliyau tawae ugitaine?” Yo sinene iba, “Yaluyaluwa yagitai tanoluwa mena isasaema.” ");
INSERT INTO tteo_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","Saulo ineli sinene koina iwaloba, “Na kana koleya tawatawaena?” Sinene iwaloba, “Taubala yabo ito likelikena yo kwama malamalawena iluwui.” Kabo Saulo ikatai nuwana mena iba, “Iya bwaine Samuela.” Kabo Saulo iyakasisi ipwalou-talu bwatano mena. ");
INSERT INTO tteo_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","Samuela iwalolau Saulo koina iba, “Tawae kaiwena yagu miya kusibayanae na kuwalo yasaema?” Kabo Saulo Samuela kainana iyamaisa iba, “Yamatausi lalakisosina kaiwena Pilistiya silaoma sabi kaleya kolimai na tabe Yeoba imiya dagedagela-yagau kana mwayaga iyai koliyau. Nige tabe kainagu iyayamaisa o nuwana palopitao kolili o nuwana kenogu mena. Bwaine iya kaiwena mwa yayoga koliwo kusaema na tawae kuwalowen koliyau kani yaginauli.” ");
INSERT INTO tteo_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","Kabo Samuela iba, “Iyaele kuwaloko Yeoba imiya-dagedagela-yagiwo yo kana mwayaga iyai koliwo yo iyamala kam kaleya. Mwa kani tawae yoi yawawalowen koliwo? ");
INSERT INTO tteo_vpl VALUES ("S128_17","010_28_17","1SA","28","17","18","Kaiwena Yeoba kainana nige kumumuliya mwa koinaele iginauli koliwo besiele. Kaiwena kana munamunai tomonliyao Amaleki nige kuunuyamateli. Bwaimwa iya kaiwena mwa Yeoba iginauliyako tauna kona iwalowen koliyau. Am kaba loina nimam mena ikele-gabaenako yo iwolena kamkava yabo koina, bwaimwana Deibida. ");
INSERT INTO tteo_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","Kani bwaliga yomiu labuine, kowa yo Isileli, Yeoba italamwagimiu Pilistiya nimali mena. Besiele tabe kowa yo natumwao tatao kani kwaboita na tamiyamiya bwaite koina boita dedeina mena. Yeoba tabe Isileli tokaleyayao kani iwolena-gabaegili Pilistiya nimali mena na sisilae.” ");
INSERT INTO tteo_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","Samuela ana walo kaiwena Saulo ibeku italu-kanitu bwatano mena yona isawowoli matausi lalakina iunui. Ikeno yai bwatano mena nige kekan yo nige numa kaliyate meuloina kanasiga ilau iboniyai. ");
INSERT INTO tteo_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","Saugana sinene ilaoma igitai Saulo yona sitabutabubu me ana matausi kabo iwalolau koina iba, “Taubala, yau am topaisowa sinena yawasigu yatalamwan yo am nuwatu yapaisowai besiele tawae kuwalowen koliyau. ");
INSERT INTO tteo_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","Mwa kategu kowa kainagu kubenalan na kan yabo yaeyawa ukwan na yom sikaikaiwe kabo am kaba lau mena kulau.” ");
INSERT INTO tteo_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","Na isikote genuwana kekan mwa iba, “Kani nige yakekekan.” Na ana kilakaiwo yo sinene siwalo samasamalului kabo itolo imiyasio kaba keno mena. ");
INSERT INTO tteo_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","Na sinene ana bulumakau natuna sinisinibuna yabo iyaele imiyamiya mwa ilau iunui pwalawa ikalai yo ginauli meuloina ikatububun ana nume mena bulumakau bulumana iliga yo pwalawa ikava egai. ");
INSERT INTO tteo_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","Yo iloliga imwawasi itanuwaga kabo ilopei Saulo me ana kilakaiwo manli mena. Sikekan imwawasi yo boniyainane koina sitolo yo silau. ");
INSERT INTO tteo_vpl VALUES ("S129_1","010_29_1","1SA","29","1","1","Pilistiya ali tokaleyayao meuloili silau simiya-gogo yanuwa Apeki koina na Isileli tokaleyayao simiya-gogo waila bunubunuwasina Yesileli koina. ");
INSERT INTO tteo_vpl VALUES ("S129_2","010_29_2","1SA","29","2","2","Kabo Pilistiya tokaleyayao sitolo silalau Isileli ali dedei mena boda tupwali kali baibaiwa wan tausan yo boda tupwaliyao wan andeledi. Na Deibida me ana kilakaiwo tabe silaulau dagelali mena mekalikava kin Akisa. ");
INSERT INTO tteo_vpl VALUES ("S129_3","010_29_3","1SA","29","3","3","Pilistiya ali tobagunao Deibida me ana kilakaiwo sigitaili silaulau mulili mena mwa sineli Akisa koina siba, “Na bwaite siya Ibeliu tawae siyayai mulila mena?” Kabo Akisa kainali iyamaisa iba, “Na nige wakakatai Deibida kin Saulo ana topaisowa lalakina yabo iya? Mwa iya mekaukava kamiyamiya bolime kaigeda yo tupwana yo Saulo ilogabaen ilaoma koliyau nige lopwano yabo yalolobai koina.” ");
INSERT INTO tteo_vpl VALUES ("S129_4","010_29_4","1SA","29","4","4","Na iyamo Pilistiya ali tobagunao simunamunai lalakina Akisa koina siba, “Kuyawasa-yapileyoi ilau toweya ana kaba miyawa kuwowolenawa koina imiyamiya, tabu ilalaoma mekalakava kaleya mena. Tem ana solasola ilobai kani itagela-keile yo ikaleyaila kabo ala tokaleyayao iunuyamateli na kamwasane koina ana taubala Saulo ikabi-yaliyayayan. ");
INSERT INTO tteo_vpl VALUES ("S129_5","010_29_5","1SA","29","5","5","Iya tomonane mwa walina tomo siwaliwaliyan yo siseloselowan, ‘Saulo ana wan tausan iunuili na Deibida ana ten tausan iunuili.’” ");
INSERT INTO tteo_vpl VALUES ("S129_6","010_29_6","1SA","29","6","6","Bwaine koina Akisa iyoga Deibida ilaoma koina iwalolau iba, “Yakawa-lulusae Yeoba meyawasina koina iya iyaele imiyamiya igitagitaiwo kowa tomumuga dudulai koliyau iyaele talalau kaleya mena kowa kagu tosagu saugana kulaoma koliyau ilau ee kanasiga kabona. Na siyamo yagu tokaleya kali tobagunao nige siyayaliyaya kaiwem. ");
INSERT INTO tteo_vpl VALUES ("S129_7","010_29_7","1SA","29","7","7","Koinaele bwaite koina kani kupileyoi yo me am daumwali kulau na kisi ginauli yabo polopolowena uginauli kani yagu tobagunao kali lotonan kusibayanae.” ");
INSERT INTO tteo_vpl VALUES ("S129_8","010_29_8","1SA","29","8","8","Na Deibida ineli Akisa koina iba, “Tawae naenaena yapaisowai koliwo? Saugana yayatubu yapaisowa koliwo nige naenaena yabo kulolobai koliyau. Na gubesi kani nige sowasowana kowa te yau talau na kam kaleyayao yakaleyaili? Kaiwena kowa yagu taubala yo yagu kin.” ");
INSERT INTO tteo_vpl VALUES ("S129_9","010_29_9","1SA","29","9","9","Akisa kainana iyamaisa iba, “Yawasosi manigu mena yagite-lobaiwo am paisowa meuloina sidudulaisosi kam koleya besiele kabo Yeoba ana anelose yabo. Na iyamo yagu tokaleya kali tobagunao sisamalulu sosi siba, ‘Nigele, tabu Deibida ilalaoma mekalakava tasasae kaleya mena.’ ");
INSERT INTO tteo_vpl VALUES ("S129_10","010_29_10","1SA","29","10","10","Koinaele bwaliga malala kikiuna mekamkavao am taubala Saulo ana kilakaiwo siya silaoma mekamkavao koliyau yanuwa itomkewa isasae bwaimwa koina wakeno sulubon yo kwalau.” ");
INSERT INTO tteo_vpl VALUES ("S129_11","010_29_11","1SA","29","11","11","Yo Deibida me ana kilakaiwo sikeno malala kikiuna sitolo yo sipileyoi Pilistiya ali dedei mena. Na siya Pilistiya sisae Yesileli dedeina mena. ");
INSERT INTO tteo_vpl VALUES ("S130_6","010_30_6","1SA","30","6","6","Deibida ana kilakaiwo me ali nuwanae lalakina kaiwena waineliyao yo natuliyao nige simiyamiya yanuwane koina kabo simunamunai Deibida koina sibomamo siwaloba, “Deibida taunui veku mena iboita.” Deibida walone ibenalan mwa me ana katewakaka na iyamo ana meli ipei Yeoba koina kabo me ana katepatu. ");
INSERT INTO tteo_vpl VALUES ("S130_7","010_30_7","1SA","30","7","7","Deibida iwalo topwaoli Ebayada koina iba, “Kam ipodi ukwalaiyama na Ulim yo Tamim tayapaisowa na Yeoba ana nuwatu taloyai.” Kabo iginauli besiele. ");
INSERT INTO tteo_vpl VALUES ("S130_8","010_30_8","1SA","30","8","8","Kabo Deibida ineli Yeoba koina iba, “Gubesi, kani Amaleki yayamuli kusulili o nigele? Kani kalobaili o nigele?” Yeoba kainana iyamaisa iba, “O, kuyamuli kusulili, kani kulobaili yo sinesineo me natuliyao kuleboili.” ");
INSERT INTO tteo_vpl VALUES ("S130_9","010_30_9","1SA","30","9","10","Kabo Deibida me ana kilakaiwo kali baibaiwa sikisi andeledi silau. Saugana siyawatagili Besol wailana koina kilakaiwo yoli tu andeledi nige silalauyoi na simiyamiya kaiwena kamnali sinaesosi nige sowana galogalowa mena silopanaisi yo koya sikawaili kabo Deibida me ana boda powa andeledi silauyoi. ");
INSERT INTO tteo_vpl VALUES ("S130_23","010_30_23","1SA","30","23","23","Na Deibida kainali iyamaisali iwaloba, “Kaukavao, tabu mumugamiu besiele. Wagitai tawae Yeoba iyeyama kolila. Tabe igite-kalatagila yo Amaleki siya kala kaleyayao ipeili nimala mena. ");
INSERT INTO tteo_vpl VALUES ("S130_24","010_30_24","1SA","30","24","24","Tabu walone bwaimwa tagiginauli besiele. Kaiwena siya simiyamiya na ala gogo sigitegite-kalatagili na kita talau takaleya Amaleki kolili. Sowasowana gogone tasoiyagili meuloila kolila.” ");
INSERT INTO tteo_vpl VALUES ("S130_25","010_30_25","1SA","30","25","25","Mwa loinane bwaine Deibida ikabi-yakaiwe yo imiyamiya kanasiga kabona. ");
INSERT INTO tteo_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","Na Pilistiya Isileli sikaleyaili koya esana Gilibowa koina. Yo Isileli siyabubu Pilistiya kolili yo sibaibaiwa siboita Pilistiya nimali mena. ");
INSERT INTO tteo_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","Kabo Pilistiya Saulo me natunao sisagena-yamuli kusulili nige kali mwayaga iyayai Diyonatan, Abinadaba yo Malikisuwa kolili kabo bwaine koina yoli yaiyonane sikoyaboitali. ");
INSERT INTO tteo_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Yo Pilistiya kaleyane koina siwedowedoli molosi yo ali toula-gipoyo ali gipoyo simomosi kabo ali wamali sikabi-gabaegili sieva silau Saulo sisakona yo Saulo yona ikoya-polowe kaiwena kamkamna lalakina ilotonan yona mena. ");
INSERT INTO tteo_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","Kabo iwalolau ana gogo kaleya kana tokayale koina iba, “Am kaleya kelepana kuniwisi na koina kusakona-yamateyau kisi siya nige nigwenigwe sikakalai tomonliyao silaoma na sisakona-yamateyau yo sisibayanaeyau.” Na iyamo ana kilakaine isikote yo imatausi lalakina mwa nige igiginauli tawae Saulo ana walo. Mwa Saulo ibomamo ana kaleya kelepana ikalai iyatolo yo ibeku ilobi koina ibomamo isakona-yaboita. ");
INSERT INTO tteo_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Saugana kilakaine manna ilau ana taubala ana boita kana koleya igitai iya tabe iginauli besiele ibomayoi koina. ");
INSERT INTO tteo_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","Kabo Saulo natunao yaiyona yo tabe ana kaleya gogoliyao kana tokayale yo ana tokaleyayao kaliyatenane koina meuloili siboita toyawa. ");
INSERT INTO tteo_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","Yo Isileli simiya galogalowa mena koya Gilibowa yaulina mena waila Yolidan dedei pwatana mena, saugana sigitaili ali tokaleyayao siyabubu yo Saulo menatunao siboita wasali sibenalan, kabo ali yanuwa lalakili siyabubu-gabaegili. Mwa Pilistiya silaoma sikwayaili kolili simiya. ");
INSERT INTO tteo_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","Yanuwa ilayan kabo Pilistiya silau Isileli siya siboitako ali gogo wasawasali sikalaili. Yo silobaili Saulo menatunao yoli yaiyona boiboitali sikenokeno koya Gilibowa koina. ");
INSERT INTO tteo_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","Mwa Saulo galogalona sitom-utusi yo ana gogo kaleya sikalaili. Yo ali tosagenawasao siyawasali silau Pilistiya dedeina meuloina kolili silusae ali yaubada kokotomo ali nume tapwalolo kolili na tomo meuloili ali wasa siwolegili. ");
INSERT INTO tteo_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","Saulo ana gogo kaleya sikalaili sipeili ali yaubada Asitoledi ana nume tapwalolo kalona mena na yona sikoyapatu yanuwa Betisani kana gana mena. ");
INSERT INTO tteo_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","Saugana Yabesi yo Giliyadi tomonliyao wasa sibenalan tawae Pilistiya siginauli Saulo yona koina, ");
INSERT INTO tteo_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","kabo ali tokaleya kaikaiweli boniyai meuloina koina silau siyawatagili Betisani kabo Saulo me natunao yoli sikalaili silawagili Yabesi koina kabo sigabuli. ");
INSERT INTO tteo_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","Tuwatuwali sikalaili sipuluili mayau tamaliski yaulina mena yo guliyam sikalakisiyeyan kaliyate sebeni kali yakasisi kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S21_1","011_1_1","2SA","1","1","1","Saulo iboitako, kabo Deibida mekana kilakaiwo boda Amaleki siyemwawasiliko yo sipileyoi simiyamiya yanuwa Sikilagi, iya Pilistiya yanuwana yabo koina. Saulo iboita yo kaliyate labui mulina mena, ");
INSERT INTO tteo_vpl VALUES ("S21_2","011_1_2","2SA","1","2","2","kabo kaliyate yaiyonana koina kilakai yabo, ilaomaya dedeine Saulo me ana tokaleyayao sikalekaleya koina, ilau Deibida koina. Kana kaleko iigalili yo kau iyasululi kulukuluna mena, toboita kana yakasisi kaiwena. Saugana kilakaine ilau Deibida koina me ana yakasisi ipwalou bwatano mena. ");
INSERT INTO tteo_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","Mwa Deibida ineli koina iwaloba, “Toweya kulaomaya?” Kainana iyamaisa iwaloba, “Yalaomaya Isileli ali kaba kaleya mena.” ");
INSERT INTO tteo_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","Kabo Deibida iwalo koina iwaloba, “Yagu wasa kuyeyama kaleya wasana gubesi?” Kainana iyamaisa iwaloba, “Isileli ali tokaleyayao kaleyane siyabubu-gabaen, na Pilistiya Isileli sibaibaiwa sikoyamateli. Besiele tabe, Saulo me natuna Diyonatan siya tabe siboita.” ");
INSERT INTO tteo_vpl VALUES ("S21_5","011_1_5","2SA","1","5","5","Kabo Deibida iwalo kilakaine koina iwaloba, “Gubesi am katakataina yakato Saulo me natuna siboitako?” ");
INSERT INTO tteo_vpl VALUES ("S21_6","011_1_6","2SA","1","6","6","Mwa kilakaine iedeedede Deibida koina iwaloba, “Yau ele koya Gilibowa saugana Saulo yalobai, ana pwawati iyatolo bwatano mena na koina isabalololau. Kabo Pilistiya ali waga niuniuli yo ali tokaleyayao sisagena mwayamwayau kikiunamo siyawatagili koina. ");
INSERT INTO tteo_vpl VALUES ("S21_7","011_1_7","2SA","1","7","7","Kabo itagelakeile mwa igitaiyau, mwa iyoga kabo yawaloba, ‘Taubala, gubesi?’ ");
INSERT INTO tteo_vpl VALUES ("S21_8","011_1_8","2SA","1","8","8","Mwa ineli-yagau iwaloba, ‘Yaiya kowa?’ Kainana yayamaisa yawaloba, ‘Yau boda Amaleki tomona.’ ");
INSERT INTO tteo_vpl VALUES ("S21_9","011_1_9","2SA","1","9","9","Mwa ikawanoi koliyau iwaloba, ‘Kulaoma bwaite saligu mena na ukoyamateyau, kaiwena bwagana meyawasigu na ipolowesosi koliyau.’ ");
INSERT INTO tteo_vpl VALUES ("S21_10","011_1_10","2SA","1","10","10","Mwa yalau salina mena yakoyamate, kaiwena yakatai iya sisakona namwanamwai yo nige sowana imiya yoi. Kulukuluna kana pwaopwaom yo nimana kana kelima yakalaili siyaele bwaite am kilakilala kowa yagu guyau koliwo.” ");
INSERT INTO tteo_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","Mwa nuwanae kaiwena Deibida kana kaleko iigali yo kana tosaguwo siginauli besiele tabe. ");
INSERT INTO tteo_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","Kabo me ali nuwanae, sivalam koyasili yo me ali guliyam sikalakisiyeyan kanasiga dabwelo isugu, kaiwena Saulo me natuna Diyonatan Yeoba ana tokaleyayao boda Isileli siboitako kaleya kelepana koina. ");
INSERT INTO tteo_vpl VALUES ("S21_13","011_1_13","2SA","1","13","13","Kabo Deibida ineliyan iwaloba, “Toyanuwa tomona kowa?” Kainana iyamaisa iwaloba, “Yau boda Amaleki tomona yo yamiya taumana dedei Isileli koina.” ");
INSERT INTO tteo_vpl VALUES ("S21_14","011_1_14","2SA","1","14","14","Kabo Deibida iwaloba, “Gubesi mwa nige kumamatausi temga Yeoba ana gitesipwa tomona tabu kusisibayanae? ");
INSERT INTO tteo_vpl VALUES ("S21_15","011_1_15","2SA","1","15","16","Am nae maisana kani kuboita kaiwena kuboma kuwalo-masalagiwo kuba, ‘Yeoba ana gitesipwa tomona yaunuiyako.’” Mwa kana tosagu kalikava yabo iyogan yo koina iwaloba, “Kulau ukoyamate.” Kabo kana tosagu bwaine kelepa koina kilakaine ikoyamate. ");
INSERT INTO tteo_vpl VALUES ("S21_17","011_1_17","2SA","1","17","17","Valam walina Deibida iwaliyan Saulo mekanakava natuna Diyonatan kaiweli. ");
INSERT INTO tteo_vpl VALUES ("S21_18","011_1_18","2SA","1","18","18","Kabo iwalo kolili siyakena-yagili susu Yuda tomonliyao kolili. Na waline esana gipoyo walina yo iyaele Yasa ana buki kalona mena. Waline iyatubu bwaite besiele, ");
INSERT INTO tteo_vpl VALUES ("S21_19","011_1_19","2SA","1","19","19","O Isileli, am tokaleyayao namwanamwaliyao siyaele am koya pwatali mena boiboitali sikenokeno. Gubesi mwa ala tokaiweyao kaleya koina siboita? ");
INSERT INTO tteo_vpl VALUES ("S21_20","011_1_20","2SA","1","20","20","Tabu kuwawalowen yanuwa Gata yo Asikelon kaloli mena, kisi Pilistiya, siya Yeoba nige sikakatai, ali sinesineo siyaliyaya. ");
INSERT INTO tteo_vpl VALUES ("S21_21","011_1_21","2SA","1","21","21","O dedei Gilibowa koyana, tabu galewa o nuwana wabumali silalaowa koliwo yo tabu kan yabo imiyamiya tulutuluna koina. Kaiwena ala tokaiwe Saulo iboitako, ana ebeu imiya bwagabwaga bwatano mena, kani nige tabe siyayaoloi yoi. ");
INSERT INTO tteo_vpl VALUES ("S21_22","011_1_22","2SA","1","22","22","Diyonatan ana gipoyo wamalina sauga meuloina isagena dudulai kabo tokaleyayao kaikaiweli yoli mena sitalu-tolo kaiwena Diyonatan iya gipoyo kana toula namwanamwana. Saulo ana kaleya kelepana ipei-yavivila yoi kaba peina mena me kwasikwasinena sauga meuloina kaiwena Saulo iya kelepa kaleyana ikataisosi. Na kali tokalomagigiliwo kwasineli sididi yo siboita. ");
INSERT INTO tteo_vpl VALUES ("S21_23","011_1_23","2SA","1","23","23","Tomo simulolo lalakina Saulo yo Diyonatan kolili kaiwena siya tomo namwanamwasosiliyao. Saugana simiyamiya meyawasili mena simiya toyawa yo ali boita koina siboita toyawa. Saulo yo Diyonatan ali sagena imalaesosi kabo magesubu ana eva kana malae, yo laiyon ana kaiwe sikaiwe-gabaen. ");
INSERT INTO tteo_vpl VALUES ("S21_24","011_1_24","2SA","1","24","24","Isileli sinesineoliyao, Saulo kaiwena kwavalam kaiwena iyakwamamiu kaleko namwanamwali balabalagiyali kolili yo yomiu iyapasali gole kolili. ");
INSERT INTO tteo_vpl VALUES ("S21_25","011_1_25","2SA","1","25","25","Gubesi mwa ala tokaiweyao kaleya koina siboita? Diyonatan kwapina boiboitana iyaele koya pwatana mena ikenokeno. ");
INSERT INTO tteo_vpl VALUES ("S21_26","011_1_26","2SA","1","26","26","Kaukava Diyonatan, nuwagu inae lalakina kaiwem, kaiwena yamulolososi koliwo. Am mulolo koliyau ilalakisosi kabo sine ana mulolo wainena tau koina. ");
INSERT INTO tteo_vpl VALUES ("S21_27","011_1_27","2SA","1","27","27","Gubesi mwa ala tokaiweyao kaleya koina siboita? Ali kaleya gogona silogabaegili nige kali namwanamwa yabo. ");
INSERT INTO tteo_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","Sauga yabo mena Deibida ineli Yeoba koina iwaloba, “Sowasowana yapileyoi yalau dedei Yuda yanuwana yabo koina yamiya?” Kainana iyamaisa iwaloba, “O, kupileyoi.” Mwa Deibida ineliyoi iwaloba, “Toisabo dedei koina kani yamimiyane?” Kainana iyamaisa yoi iwaloba, “Yanuwa Ebiloni.” ");
INSERT INTO tteo_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","Kabo Deibida wainena labui ikalaili mekanakavao, yabo Ainowami iya Diyesili sinena yo labuina Abigaili Nabal kwabukwabulina iya Kameli tomona. ");
INSERT INTO tteo_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","Besiele tabe ana kilakaiwo mewaineliyao yo me natuliyao iyoganli silau simiyamiya Ebiloni yanuwaliyao kolili. ");
INSERT INTO tteo_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","Kabo Yuda dedeina tomoliyao silau Ebiloni, yo bwaine koina Deibida kulukuluna siyaoloi iyamala boda Yuda ali kin. Kabo Deibida wasa ibenalan Yabesi tomonliyao dedei Giliyadi Saulo yona sikalai yo sipei salai mena. ");
INSERT INTO tteo_vpl VALUES ("S22_5","011_2_5","2SA","2","5","5","Kabo tosagenawasa iyawasali silau kolili, siwaloba, “Yeoba iwalo-muloloimiu, kaiwena ami taubala Saulo yona wakalai yo kwapei salai mena, bwaine koina ami mulolo Saulo kaiwena kwayakena-yagimai. ");
INSERT INTO tteo_vpl VALUES ("S22_6","011_2_6","2SA","2","6","6","Koinaele yakawanoi Yeoba ana mulolo yo ana katekamkamna iyeliwa kolimiu. Yau tabe ami paisowa namwanamwana kaiwena kani yayamaisamiu. ");
INSERT INTO tteo_vpl VALUES ("S22_7","011_2_7","2SA","2","7","7","Na ami taubala Saulo iboitako yo Yuda kulukulugu siyaoloi na yaemala ali kin kabo wakaiwe na wakatepatu.” ");
INSERT INTO tteo_vpl VALUES ("S24_4","011_4_4","2SA","4","4","4","Na Diyonatan natuna yabo esana Mepiboseti. Ana bolime paibi (5) koina Saulo yo Diyonatan ali boita wasana ilaomaya dedei Diyesili mwa kana togite-kalatan ikalai iyabubuwan. Na totoya kaiwena kabo ikabi-yabeku mwa kaena isibayanaeli, nige sowasowana ilokeikeile namwanamwa. ");
INSERT INTO tteo_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","Sauga yabo susu Isileli meuloili silau Deibida sigitai Ebiloni koina yo siwalo koina siwaloba, “Walo yawasosi kowa kwasinemai yo bulumamai tupwana. ");
INSERT INTO tteo_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","Beyabeyana Saulo iya ala kin, na kowa ala tokaleyayaone kuyoganli kwalaulau kaleya kolili. Yo Yeoba iwalo koliwo iwaloba, ‘Kowa bwaliga kani kuyamala sipi togite-kalatan yagu tomoyao Isileli kaiweli yo kuyamala ali tobaguna.’” ");
INSERT INTO tteo_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","Kabo Ebiloni koina Deibida mekanakavao Isileli ali tautaubalao siwaloyameli Yeoba manna mena, kabo kulukuluna siyaoloi iyamala ali kin. ");
INSERT INTO tteo_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","Deibida ana bolime teti (30) mwa iyamala kin, kabo iloiloina bolime kana baibaiwa poti (40). ");
INSERT INTO tteo_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","Ebiloni koina Yuda iloinayagili bolime seben yo waikena sikisi mwa kabo Yelusalema koina Isileli yo Yuda meuloina iloinayagili bolime teti tili (33). ");
INSERT INTO tteo_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","Deibida ana tokaleyayao iyoganli silau Yelusalema sikaleya Yebusi kolili, siya dedeine tanuwagaliyao. Siya ali nuwatu mena sibatoko Deibida kani nige sowasowana ilusae ali yanuwa mena mwa me ali gagasa siwaloba, “Kani nige kululusae ama yanuwa mena. Bwagana toman-gibugibu o nuwana siya kaeli youyouli sowasowali siwalo-kausiwo.” ");
INSERT INTO tteo_vpl VALUES ("S25_7","011_5_7","2SA","5","7","7","Bwagana siwalo bwaite besiele na Deibida me ana tokaleyayao silusae ali yanuwa kaikaiwena Saiyoni sikalai kabo muli mena esana siyogayan Deibida ana yanuwa. ");
INSERT INTO tteo_vpl VALUES ("S25_8","011_5_8","2SA","5","8","8","Muliya kabo silusae sikaleya na kaliyatenane koina Deibida iwaloba, “Tem nuwanuwala Yebusi takaiwe-gabaegili, ilonamwayagila gula kelikelinane bwaimwa waila kaba leguna koina kani koina Yebusi siya kaeliyao youyouli yo manliyao gibugibuli mekalakavao taelobelobe na takaleya kolili.” Bwaite iya kaiwena tomo ali edeedede yabo siwalowalowen, ‘Toman-gibugibu yo siya kaeli youyouli tabu silulusae kin ana nume koina.’ ");
INSERT INTO tteo_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","Saugana Deibida ali yanuwa kaikaiwena ikalai kabo ilau koina imiya mwa esana ipei Deibida ana yanuwa. Kabo muli mena yanuwane ikabi-takikilan iyalalaki, iyatubuya gana muli mena vekune koina ikeli ilusaeyoi yanuwa kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","Kabo Deibida ana kaiwe ilalaki isaesae kaiwena Yeoba Tokaiwesosi mekanakava. ");
INSERT INTO tteo_vpl VALUES ("S25_11","011_5_11","2SA","5","11","11","Na yanuwa Taiya ali kin esana Ailami mayau sida yo nume kana tokabikabi yo veku lalakili yo siya veku kana topaisowao iyawasali Deibida koina na mesabana bwaine mayaune yo vekune kolili Deibida ana nume wasawasana sikabi. ");
INSERT INTO tteo_vpl VALUES ("S25_12","011_5_12","2SA","5","12","12","Kabo Deibida ikatai yakato Yeoba ikawa yawasosi iya Isileli ali kin yo ana kaba loina ikaiwe ana tomoyao ali namwanamwa kaiweli. ");
INSERT INTO tteo_vpl VALUES ("S25_13","011_5_13","2SA","5","13","13","Tauna kona saugana Deibida yanuwa Ebiloni ilogabaen ilau imiyamiya Yelusalema kabo sinesineo sibaibaiwa ikasolanagili tupwana wainenao yawasosi yo tupwaliyao nige wainenao yawasosi. Kabo natuliyao tatao yo sinesineo sibaibaiwa sikabili Yelusalema koina. ");
INSERT INTO tteo_vpl VALUES ("S25_14","011_5_14","2SA","5","14","14","Na siya natunao tatao esaliyao bwaite, Samuwa, Sobabi, Neitani, Solomoni, ");
INSERT INTO tteo_vpl VALUES ("S25_15","011_5_15","2SA","5","15","15","Ibali, Elisuwa, Nepegi, Yapiya, ");
INSERT INTO tteo_vpl VALUES ("S25_16","011_5_16","2SA","5","16","16","Elisam, Eliyada yo Elipeleti. ");
INSERT INTO tteo_vpl VALUES ("S25_17","011_5_17","2SA","5","17","17","Saugana Pilistiya wasane sibenalan Isileli olo sikalai Deibida kulukuluna siyaoloi iyamala ali kin, kabo ali tokaleyayao meuloili siyawatagili silau siloyai. Yo wasali Deibida ibenalan, kabo ilau ana nume kaikaiwena koina na bwaine koina imiyamiya. ");
INSERT INTO tteo_vpl VALUES ("S25_18","011_5_18","2SA","5","18","18","Na Pilistiya silaomako yanuwa Lepaim kwabuna siloya-kalapowon na sisanasana. ");
INSERT INTO tteo_vpl VALUES ("S25_19","011_5_19","2SA","5","19","19","Mwa Deibida ineli Yeoba koina iwalo iba, “Yalau yakaleya Pilistiya kolili o besi? Kani kupeili nimagu mena?” Kainana Yeoba iyamaisa iwaloba, “Kulau, walo yawasosi kani yapeili nimam mena.” ");
INSERT INTO tteo_vpl VALUES ("S25_20","011_5_20","2SA","5","20","20","Kabo Deibida me ana tokaleyayao silau yanuwa esana Bal-Pelasim mekalikavao Pilistiya sikaleya mwa sikaiwe-gabaegili. Kabo iwaloba, “Yeoba kagu tokalomagigiliwo meuloili ikele-gwaligwali mangu mena besiele yalubwasi kaikaiwena.” Kabo bwaite iya kaiwena mwa yanuwane esana sipei Bal-Pelasim. ");
INSERT INTO tteo_vpl VALUES ("S25_21","011_5_21","2SA","5","21","21","Na saugana Pilistiya siyabubu ali yaubadao kokotomo siyabubu-gabaegili. Kabo Deibida yo ana tokaleyayao sikewaili silau. ");
INSERT INTO tteo_vpl VALUES ("S25_22","011_5_22","2SA","5","22","22","Kabo sauga yaboyoi koina Pilistiya sipileyoi silogogo silau Lepaim kwabuna siloya-kalapowon. ");
INSERT INTO tteo_vpl VALUES ("S25_23","011_5_23","2SA","5","23","23","Mwa Deibida ineli Yeoba koina tawae kani iginauli. Ana neli iyamaisa iwaloba, “Tabu kulolodudulai kolili, na kutakikili dagelali mena na ukwaleya kolili mayau popla manli mena. ");
INSERT INTO tteo_vpl VALUES ("S25_24","011_5_24","2SA","5","24","24","Saugana tem dagugu yabo kwabenalani mayau popla liguliyao pwatali mena besiele tokaleyayao kaeli daguguna, kani wakatai yau Yeoba kaleya yayatubuyako iyaele yakalekaleya Pilistiya kolili. Kabo mwayamwayau kwalusae wakaleya kolili.” ");
INSERT INTO tteo_vpl VALUES ("S25_25","011_5_25","2SA","5","25","25","Mwa Deibida iginauli besiele Yeoba ana walo. Kabo me ana tokaleyayao Pilistiya sitawoili mwa siunuili, iyatubu Gibiyon ilau kanasiga yanuwa Gesuli. ");
INSERT INTO tteo_vpl VALUES ("S26_1","011_6_1","2SA","6","1","1","Sauga yabo koina Deibida Isileli tokaleyayao siya namwanamwasosili kali baibaiwa teti tausan (30,000) iyoga-gogonagilima. ");
INSERT INTO tteo_vpl VALUES ("S26_2","011_6_2","2SA","6","2","2","Kabo silau yanuwa Bala dedei Yuda yakato Yeoba ana kelabilabin kamwasana kana dedewaga sikalai silawan Yelusalema. Dedewagane esana sipei Yeoba Tokaiwesosi ana kelabilabin kamwasana kana dedewaga. Na ali nuwatu yakato Yeoba imiyamiya dedewagane pwatana mena anelose labui (selubima) luwaluwali mena. ");
INSERT INTO tteo_vpl VALUES ("S26_3","011_6_3","2SA","6","3","3","Mwa dedewagane sikalaiyama Abinadaba ana nume mena, imiyamiya koya yabo koina kabo sitauli waga niuniuli waluwaluna yabo kalona mena. Abinadaba natunao tatao labui Usa yo Aiyo siya waga niuniuli sigite-kalatani na isagena dudulai. ");
INSERT INTO tteo_vpl VALUES ("S26_4","011_6_4","2SA","6","4","4","Dedewagane iyaele waga niuniuli pwatana mena yo Aiyo ibaguna bulumakau manli mena. ");
INSERT INTO tteo_vpl VALUES ("S26_5","011_6_5","2SA","6","5","5","Deibida mekanakavao Isileli meuloili siyaliyaya Yeoba manna mena kabo me ali kaiwe meuloili siseloselo yo siwaliwali, api uloina uloina yo tambalin, labwa yo simbol sivenuvenu-wagili. ");
INSERT INTO tteo_vpl VALUES ("S26_6","011_6_6","2SA","6","6","6","Saugana siyawatagili Nakon ana witi mosomosona kaba peina koina bulumakau ali lau inae kikiunamo sibeku kabo Usa nimana iyagayani Yeoba ana kelabilabin kamwasana kana dedewaga ikabi-kalatan tabu ibebeku. ");
INSERT INTO tteo_vpl VALUES ("S26_7","011_6_7","2SA","6","7","7","Na Usa ilopwanoko kaiwena dedewaga kana loina nige iyayakasisiyan. Bwaine iya kaiwena mwa Yeoba imunamunai kabo Usa iunui mwa iboita Yeoba ana kelabilabin kamwasana kana dedewaga dedeina mena. ");
INSERT INTO tteo_vpl VALUES ("S26_8","011_6_8","2SA","6","8","8","Kabo Deibida imunamunai kaiwena Yeoba imunamunai Usa koina mwa ikoyamate. Kabo yanuwane esana ipei Pelesi Usa, mwa tomo esane siyogayoga-yani kanasiga sauga kabona. ");
INSERT INTO tteo_vpl VALUES ("S26_9","011_6_9","2SA","6","9","9","Na kaliyatenane koina Deibida Yeoba imatausan yo iwaloba, “Gubesi mwa Yeoba ana kelabilabin kamwasana kana dedewaga ilaoma koliyau?” ");
INSERT INTO tteo_vpl VALUES ("S26_10","011_6_10","2SA","6","10","10","Mwa nige nuwanuwana dedewagane ikalai ilawan Yelusalema iya ana yanuwa mena. Kabo ilau ipeiya tomone esana Obed-edom ana nume mena iya Gata tomona. ");
INSERT INTO tteo_vpl VALUES ("S26_11","011_6_11","2SA","6","11","11","Waikena yaiyona imiyamiya bwaine koina mwa Yeoba Obed-edom ana nume kana tomiya meuloili iwalo-muloloili. ");
INSERT INTO tteo_vpl VALUES ("S26_12","011_6_12","2SA","6","12","12","Mwa kin Deibida ana wasa siwolena siba, “Yeoba Obed-edom ana nume kana tomiya meuloili iwalo-muloloili mwa ana gogo wasawasa sinamwanamwa kaiwena Yeoba ana kelabilabin kamwasana kana dedewaga imiyamiya koina.” Mwa Deibida me ana tomoyao silau dedewagane sikalaiyama Yelusalema me ali yaliyaya lalakina. ");
INSERT INTO tteo_vpl VALUES ("S26_13","011_6_13","2SA","6","13","13","Saugana siya tokewaina silau kaeli mena na kaeline ali peina mesikisi (6) mwa Deibida iwalo sitolo kabo bulumakau tauna yabo yo bulumakau natuna sinisinibuna yabo ipwaoli-yagili Yeoba koina. ");
INSERT INTO tteo_vpl VALUES ("S26_14","011_6_14","2SA","6","14","14","Ali lau kamwasa mena Deibida kaleko yabo esana ipodi kasipuna mena ipan yo me ana kaiwe iseloselo Yeoba manna mena, ");
INSERT INTO tteo_vpl VALUES ("S26_15","011_6_15","2SA","6","15","15","mekanakavao Isileli meuloili Yeoba ana kelabilabin kamwasana kana dedewaga sikalaiyama Yelusalema siwuiwui yo bwagigi siyuiyui. ");
INSERT INTO tteo_vpl VALUES ("S26_16","011_6_16","2SA","6","16","16","Saugana sikewa-luseyan Yelusalema, Deibida ana yanuwa mena, Saulo natuna sine Mikali iyaele manna ilobilobi tomlape mena. Igitai Deibida ikapukapusele yo iseloselo Yeoba manna mena kabo katena mena ikawa-yauyaule-yan. ");
INSERT INTO tteo_vpl VALUES ("S26_17","011_6_17","2SA","6","17","17","Mwa silau dedewagane sipei ana kaba miya mena palaine Deibida iyatoloyako koina. Deibida yakayakan ipwaoli-yagili Yeoba manna mena kabo tupwaliyao ipwaoli-yagili lolabin pwaolili. ");
INSERT INTO tteo_vpl VALUES ("S26_18","011_6_18","2SA","6","18","18","Saugana pwaoli iyemwawasili kabo tomo meuloili iwalo-muloloili Yeoba Tokaiwesosi esana mena. ");
INSERT INTO tteo_vpl VALUES ("S26_19","011_6_19","2SA","6","19","19","Mwa beledi kaigeda, miti bulumana gabugabuna kikiuna yo kan yabo esana deit ikalaili kabo isoiyagili boda tatao yo sinesineo meuloili kolili. Kabo meuloili silogwaligwali silau ali nume kaigeda kaigeda kolili. ");
INSERT INTO tteo_vpl VALUES ("S26_20","011_6_20","2SA","6","20","20","Saugana Deibida ipileyoi ana nume mena yakato ikawanoi ana nume kana tomiyayao Yeoba iwalo-muloloili, kabo wainena Mikali, Saulo natuna, iyawatagilima ilau igitai yo iwalo koina iba, “Gubesi kowa, Isileli ali kin, kaliyate kabona kuboma kam mwalimwaline uginauli yo yom kuyakowakowa kamkavao ali topaisowa panpanli sinesineo manli mena besiele toyauyaule ali paisowa.” ");
INSERT INTO tteo_vpl VALUES ("S26_21","011_6_21","2SA","6","21","21","Deibida kainana iyamaisa iwalo iba, “Yeoba manna mena mwa yaseloselo iya igite-sipwaiyau tamam yayamiyalae kaiwena nige tamam ana susu tomona yabo igigitesipwai na iyamiyalae. Na igite-sipwaiyau yaemala tomo Isileli ana tomoyao kali toloina koinaele kani yayaliyaya Yeoba manna mena. ");
INSERT INTO tteo_vpl VALUES ("S26_22","011_6_22","2SA","6","22","22","Yo kani yayaliyaya na esagu yapei-yatalu molosi yo tem yaboma kagu mwalimwaline yaginauli. Na topaisowa sinesineo siya waloli kuwalowalone siya siyakasisi-yagau.” ");
INSERT INTO tteo_vpl VALUES ("S26_23","011_6_23","2SA","6","23","23","Na Saulo natuna Mikali nige sauga yabo ikakabi kanasiga iboita. ");
INSERT INTO tteo_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","Yeoba kin Deibida isagui kana tokalomagigiliwo meuloili siya simiyamiya Isileli salina mena ikaiwe-gabaegiliko kabo Deibida ikaiyawasi kaleya koina yo imiya namwanamwa ana nume mena. ");
INSERT INTO tteo_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","Kabo iwalolau palopita Neitani koina iwaloba, “Yau ele yamiyamiya nume yabo koina mayau sida koina sikabi, na Yeoba ana kelabilabin kamwasana kana dedewaga imiyamiya palai kalona mena.” ");
INSERT INTO tteo_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Kin kainana Neitani iyamaisa iwaloba, “Tawae kunuwatui katem mena kupaisowai, kaiwena Yeoba imiyamiya koliwo.” ");
INSERT INTO tteo_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","Na boniyainane koina Yeoba iwalolau Neitani koina iwaloba, ");
INSERT INTO tteo_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","“Kulau yagu topaisowa Deibida koina kuwalolau kuwaloba, ‘Yeoba iwalo bwaite besiele. Kowa kani nige yagu kaba miya numena ukwakabi. ");
INSERT INTO tteo_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","Saugana Isileli yakele-yawatagilagilima Itipita koina kanasiga sauga kabona nige yamimiya nume yabo kalona mena. Yatakitakikili yanuwa yo yanuwa kolili na yamiyamiya palai kalona mena. ");
INSERT INTO tteo_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","Ali tobagunao yagite-sipwaili na yagu tomo Isileli sigite-kalatagili saugana mekaukavao ama lokeikeile dedei meuloina kolili. Na nige sauga yabo yawawalo tobagunaone kolili, gubesi mwa nige mayau sida koina nume namwanamwana yabo wakakabi kaiwegu?’ ");
INSERT INTO tteo_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","Kabo kuwalolau yagu topaisowa Deibida koina kuwaloba, ‘Yeoba Tokaiwesosi iwalo bwaite besiele, Yau yakalaiwo ule mena kowa sipi kali togite-kalatan yo yagite-sipwaiwo kuyamala yagu tomoyao Isileli kali tobaguna. ");
INSERT INTO tteo_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","Tauna kona tem toisabo dedei koina kulau yau mekamkava yo kam tokalomagigiliwo meuloili yakaiwe-gabaegili manim mena. Kabo esam kani yapei-seyani besiele tomo tupwaliyao yanuwa yaulina mena esaliyao silalaki. ");
INSERT INTO tteo_vpl VALUES ("S27_10","011_7_10","2SA","7","10","10","Besiele tabe yagu tomoyao Isileli ali yanuwa yabo kani yaolegili kolili na yapeili sikaiyawasi kabo sibomamo ali yanuwa na simiya namwanamwa. Kabo tomo naenaeliyao nige sowasowana siyakamkamnali yoi besiele beyabeyana sipaisowai kolili, ");
INSERT INTO tteo_vpl VALUES ("S27_11","011_7_11","2SA","7","11","11","saugana toloinao siya tomo yapeili yagu tomoyao Isileli sibaguna-yagili. Kam tokalomagigiliwo meuloili kani yakaiwe-gabaegili na ukwaiyawasi. Tabe yawalo koliwo yau Yeoba nume yabo kani yakabi kaiwem kabo yawalo kowa yo tubumwao yaso yo yaso am tomoyao Isileli kuloinayagili. ");
INSERT INTO tteo_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Kabo tem am sauga ilobai yo kuboita kulau mekamkavao tubumwao kabo kani natum yabo iya kwasinem yo bulumam tupwana kani yagite-sipwai na iyamiyalaewo na ana kaba loina kani yakabi-yakaiwe. ");
INSERT INTO tteo_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","Na iya bwaite nume yakayakasisina kani ikabi esagu kaiwena kabo ana kaba loina yakeleisinani ikaiwe yo yayapanaisani tubunao kolili imiyayai. ");
INSERT INTO tteo_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Kani yau besiele tamana yo iya besiele natugu. Tem ilopwano kani sige koina yasapi besiele tama yabo natuna iyayadudulai. ");
INSERT INTO tteo_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Na yagu mulolo kani nige yakekele-gabaeni koina nige besiele yagiginauli Saulo koina iya yakele-gabaeni ana kaba miya mena mwa kowa kuyamiyalae. ");
INSERT INTO tteo_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","Am nume yo am kaba loina kani simiyayai mangu mena sauga meuloina, am kaba loina ikaiwe mwa ipanaisi ilau tubumwao kolili nige ana kaba mwawasi.’” ");
INSERT INTO tteo_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Kabo Yeoba ana walo meuloina iyakenayan Neitani koina, kabo ilau iwalowen Deibida koina. ");
INSERT INTO tteo_vpl VALUES ("S27_18","011_7_18","2SA","7","18","18","Kabo kin Deibida ilau ilusae palai kalona mena bwaimwa kelabilabin kamwasana kana dedewaga imiyamiya yo salina mena imiyasio Yeoba manna mena yo ikawanoi iba, “O Yeoba Tokaiwesosi, yaiya yau yo yagu susuwo mwa yakato ukwalaiyau kupeiyau kaba miya saesae molosina koina? ");
INSERT INTO tteo_vpl VALUES ("S27_19","011_7_19","2SA","7","19","19","Na Yeoba Tokaiwesosi, sauga bwaite ginauli kuetulan-yoili bwaite besiele. Am waloyameli koliyau besiele natuguwao yo tubuguwao sauga muli mena kaiweli. O Yeoba, yakato kupapaisowai besiele bwaite tomo meuloili kolili? Nuwana nigele, yabomamo koliyau. ");
INSERT INTO tteo_vpl VALUES ("S27_20","011_7_20","2SA","7","20","20","Nige sowasowana yaedeedede yoi. O Yeoba Tokaiwesosi, yau am topaisowa bwaite kunuwatuiyau kabo ugite-sipwaiyau. ");
INSERT INTO tteo_vpl VALUES ("S27_21","011_7_21","2SA","7","21","21","Kuwaloyameli besiele am nuwatu mwa tawae nuwanuwam uginauli besiele. Kabo paisowa lalakina bwaite kupaisowai kabo kuwalo-masala yau am topaisowa koliyau. ");
INSERT INTO tteo_vpl VALUES ("S27_22","011_7_22","2SA","7","22","22","O Yeoba Tokaiwesosi, kowa esam ilalaki. Nige yabo yaiya wasana kabebenalan besiele kowa, nige yabo yaubada imiyamiya besiele kowa, kubomamo. ");
INSERT INTO tteo_vpl VALUES ("S27_23","011_7_23","2SA","7","23","23","Nige boda yabo yanuwa yaulina mena besiele am tomoyao Isileli. Kowa Yeoba kulivasili ali miyapolowe koina yo kuyavivilayoilima Itipita koina siyamala am tomoyao. Yo esam kuyawasawasa besiele tabe paisowa kaba nuwapwanopwano lalakiliyao uginaulili kaiweli. Kabo boda uloina uloina siya mekalikavao ali yaubadao kutawoili. Imwawasi am tomoyao kuyawasali silau dedei bwaine ugite-sipwai kaiweli. ");
INSERT INTO tteo_vpl VALUES ("S27_24","011_7_24","2SA","7","24","24","Boda Isileli ugite-sipwaili siyamala kowa am tomoyao sauga meuloina nige ana kaba mwawasi yo kowa Yeoba kuyamala ali Yaubada. ");
INSERT INTO tteo_vpl VALUES ("S27_25","011_7_25","2SA","7","25","25","Kabo Yeoba am waloyameli yau am topaisowa yo tubuguwao kaiwemai ukawa-yawasosi-yan na mesabana imiyayai besiele am waloyameli. ");
INSERT INTO tteo_vpl VALUES ("S27_26","011_7_26","2SA","7","26","26","Kabo esam iwasawasa sauga meuloina nige ana kaba mwawasi. Kabo tomo kani siwalo siba, ‘Yeoba Tokaiwesosi iya Isileli ali Yaubada.’ Yau am topaisowa Deibida yagu kaba loina kuyatolo ikaiwe ilopanaisi tubuguwao kolili nige ana kaba mwawasi. ");
INSERT INTO tteo_vpl VALUES ("S27_27","011_7_27","2SA","7","27","27","O Yeoba Tokaiwesosi, kowa Isileli ama Yaubada, kuwalo-masala yau am topaisowa koliyau kuwaloba, ‘Yau nume yabo kani yakabi kaiwem kabo kowa yo tubumwao yaso yo yaso kani kwaemala toloinao.’ Kabo me yagu katepatu yakawanoi koliwo. ");
INSERT INTO tteo_vpl VALUES ("S27_28","011_7_28","2SA","7","28","28","O Yeoba Tokaiwesosi, walo yawasosi kowa ama Yaubada. Kowa sauga meuloina am waloyameli uginaulili yo waloyameli bwaite namwanamwana kuwalowen koliyau. ");
INSERT INTO tteo_vpl VALUES ("S27_29","011_7_29","2SA","7","29","29","Yakawanoi koliwo tubuguwao kuwalo-muloloili na mesabana am namwanamwa imiyayai kolili. Kaiwena kowa Yeoba Tokaiwesosi kuwalo bwaite besiele kabo am walo-mulolo imiyayai tubuguwao kolili.” ");
INSERT INTO tteo_vpl VALUES ("S28_15","011_8_15","2SA","8","15","15","Deibida iyamala kin Isileli yanuwaliyao meuloili kolili yo ana loinao sinamwanamwa yo sidudulai ana tomoyao kaiweli. ");
INSERT INTO tteo_vpl VALUES ("S28_16","011_8_16","2SA","8","16","16","Seluwaiya natuna Yowabi, iya tokaleyayao ali tobaguna. Ailudi natuna Yeosapati iya kin ana loinao kana togite-kalatan. ");
INSERT INTO tteo_vpl VALUES ("S28_17","011_8_17","2SA","8","17","17","Aitubi natuna Seidoki yo Eimileki natuna Ebayada siya topwaoli. Selaiya iya tolelelele. ");
INSERT INTO tteo_vpl VALUES ("S28_18","011_8_18","2SA","8","18","18","Yeoyada natuna Benaiya iya boda Keleti yo boda Peleti ali tobaguna. Yo Deibida natunao siya besiele topwaoli. ");
INSERT INTO tteo_vpl VALUES ("S29_1","011_9_1","2SA","9","1","1","Kaliyate yabo koina Deibida ineli ana topaisowao kolili iba, “Tabu Saulo tubuna yabo imiyamiya? Tem yabo iyaele nuwanuwagu yagu mulolo yayakenayani Diyonatan kana nuwatu-kalatan yo kana yakasisi kaiwena.” ");
INSERT INTO tteo_vpl VALUES ("S29_2","011_9_2","2SA","9","2","2","Na tomo yabo esana Siba iyaele imiyamiya iya tauna kona Saulo ana topaisowa kabo siyogan ilau kin Deibida koina mwa ineliyan iba, “Kowa esam Siba?” Kainana iyamaisa iwaloba, “O, yau am topaisowa esagu bwaimwa.” ");
INSERT INTO tteo_vpl VALUES ("S29_3","011_9_3","2SA","9","3","3","Kabo kin ineli iba, “Tabu Saulo tubuna yabo imiyamiya? Nuwanuwagu yagu mulolo yayakenayani besiele yagu waloyameli Yeoba koina.” Siba kainana iyamaisa iba, “O, Diyonatan natuna tauna yabo iyaele imiyamiya na kaena labui sinae nige sowana ilokeikeile dudulai.” ");
INSERT INTO tteo_vpl VALUES ("S29_4","011_9_4","2SA","9","4","4","Mwa kin ineli iwaloba, “Iya toweya?” Kainana Siba iyamaisa iwaloba, “Iya iyaele Amieli natuna Makili ana nume mena yanuwa Lodeba koina.” ");
INSERT INTO tteo_vpl VALUES ("S29_5","011_9_5","2SA","9","5","5","Kabo Deibida ana topaisowao iyawasali silau Lodeba koina na Diyonatan natuna Mepiboseti sikalaiyama. ");
INSERT INTO tteo_vpl VALUES ("S29_6","011_9_6","2SA","9","6","6","Saugana Mepiboseti ilau Deibida koina mwa ipwalou me ana nuwalobi yo manna ilobi bwatano mena. Kabo Deibida iwalolau koina iba, “Kagutoki kowa Mepiboseti.” Kainana iyamaisa iwaloba, “Yau am topaisowa.” ");
INSERT INTO tteo_vpl VALUES ("S29_7","011_9_7","2SA","9","7","7","Mwa Deibida iwaloba, “Tabu kumamatausi kaiwena kani yakate-kamkamna-yagiwo tamam Diyonatan kana yakasisi kaiwena. Kabo bwatano meuloina beyabeyana tubum Saulo koina kani yaeyawa koliwo yo kowa sauga meuloina ukekakekan yagu teibele mena.” ");
INSERT INTO tteo_vpl VALUES ("S29_8","011_9_8","2SA","9","8","8","Kabo Mepiboseti ipwalou yo iwalo Deibida koina iwaloba, “Yau tomo bwagabwaga bwaite, yau besiele bwauwa boiboitana, mwa gubesi kabo ukate-kamkamna-yagau?” ");
INSERT INTO tteo_vpl VALUES ("S29_9","011_9_9","2SA","9","9","9","Kabo kin Deibida Siba iyoganama yo iwalo koina iwaloba, “Ginauli meuloina beyabeyana simiyamiya Saulo yo ana susuwo kolili mwa yaolena am taubala tubuna Mepiboseti koina. ");
INSERT INTO tteo_vpl VALUES ("S29_10","011_9_10","2SA","9","10","10","Kowa mekamkavao natumwao yo am topaisowao bwatanone kwayapaisowa ami taubala Mepiboseti kaiwena. Na iya sauga meuloina kani ikekakekan yagu teibele mena.” Na Siba natunao tatao kali baibaiwa piptin (15) yo ana topaisowao kali baibaiwa tuwenti (20). ");
INSERT INTO tteo_vpl VALUES ("S29_11","011_9_11","2SA","9","11","11","Kabo Siba iwalo koina iba, “Yagu guyau yo yagu kin, yau am topaisowa, tawae tem kuwalowen kani yaginauli.” Kabo Mepiboseti ikekakekan kin ana teibele mena besiele kin natuna yabo. ");
INSERT INTO tteo_vpl VALUES ("S29_12","011_9_12","2SA","9","12","12","Mepiboseti natuna game yabo esana Mika. Kabo Siba yo ana susu meuloili sipaisowa Mepiboseti kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S29_13","011_9_13","2SA","9","13","13","Kabo Mepiboseti ilau imiyamiya Yelusalema yo sauga meuloina ikekakekan kin ana teibele mena. Na kaena labui sinae nige sowasowana ilokeikeile dudulai. ");
INSERT INTO tteo_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Bolime ana kaba yatubu koina tulutulu kana sauga imwawasiko mwa kin ali sauga siyawatagili yo sikaleya, kabo Deibida Yowabi iyawasa iyawatagili mekanakavao tokaleyayao ali tobagunao yo Isileli ali tokaleyayao meuloili. Kabo Amoni ali tokaleyayao sikaiwe-gabaegili kabo ali yanuwa lalakina Laba kana sigasiga simiya-takikilan yo simiya-kausi. Deibida nige ilalau na imiyamiya Yelusalema. ");
INSERT INTO tteo_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","Kaliyate yabo lolau mena Deibida ikeno-tolo ana kaba kaiyawasi mena mwa ilau imwalisae nume kewana mena yo ilolokeikeile. Kabo manna ilobi mwa sine yabo igitai isugusugu kana koleya inamwanamwasosi. ");
INSERT INTO tteo_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","Mwa tosagenawasa yabo iyawasa ilau yo ineliyan sine bwaine yaiya. Kabo Deibida ana wasa iwolena iba, “Sine esana Batisiba iya Eliam natuna yo wainena esana Ulaiya, boda Iti tomona.” ");
INSERT INTO tteo_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","Kabo tosagenawasa tupwaliyao iyawasali silau yo sinene sikalaiyama koina. Na waikena kasiebwana imwawasiko koina. Bwaine iya kaiwena sinene isugusugu. Na mekanakava sikeno toyawa, muli mena sinene ipileyoi ana nume mena. ");
INSERT INTO tteo_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Na kana igalu kabo Deibida ana wasa iyawasa iba, “Yau yasiuma.” ");
INSERT INTO tteo_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","Kabo Deibida walo iyawasa Yowabi koina iwaloba, “Ulaiya Iti tomona kuyawasa ilaoma koliyau.” Mwa Yowabi iginauli besiele. ");
INSERT INTO tteo_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","Saugana Ulaiya iyawatagili mwa Deibida ineliyan Yowabi yo tokaleyayao ali miyamiya kaiwena na kaleya gubesi. ");
INSERT INTO tteo_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","Ali edeedede imwawasi kabo iwalo Ulaiya koina iba, “Kulau am nume mena kaem kudeulili na ukwaiyawasi.” Kabo kin ana nume ilogabaen kabo kana mulolo kan tupwana Deibida iyawasa ilau ana nume mena. ");
INSERT INTO tteo_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","Na iyamo Ulaiya nige ilalau ana nume mena na ikenowaya kin ana nume kaba lusalusaena togite-kalatanwo ali biliutusi koina mekanakavao gamwa togite-kalatanwo. ");
INSERT INTO tteo_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","Kabo Deibida ana wasa siwolena siba, “Ulaiya nige ilalau ana nume mena.” Mwa Ulaiya iyoganama yo ineliyan iba, “Tawae kaiwena nige kulalau am nume mena? Kupileyoimako dedei kelamamalawe koina.” ");
INSERT INTO tteo_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","Yo Ulaiya iwalo Deibida koina iwaloba, “Na kelabilabin kamwasana kana dedewaga imiyamiyaya palai kalona mena besiele siya Isileli yo Yuda ali tokaleyayao siya siyaele ule mena sikaikaiyawasi kaba kaleya mena kabo nige sowasowagu yalau yagu nume mena yakekan yo yanuma yo mekaukava wainegu kakeno. Na yakawalulu esam mena, kani nige yagiginauli besiele.” ");
INSERT INTO tteo_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","Kabo Deibida iwalo koina iwalo iba, “Kaliyate kaigeda kumiyamiya kabo bwaligamo kani yayawasao kupileyoi.” Na Ulaiya imiyamiya Yelusalema besiele Deibida ana walo. ");
INSERT INTO tteo_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","Kabo Deibida Ulaiya iyogan mekanakava sikekan yo sinuma mwa Deibida Ulaiya iyanuma-yauyaule. Na boniyainane koina nige ipipileyoi ana nume mena na ikenoya ana dam imo pwatana mena mekanakavao gamwa togite-kalatanwo. ");
INSERT INTO tteo_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","Yanuwa ilayan malala mena Deibida Yowabi ana leta ilele mwa iwolena Ulaiya koina yo iyawasa ilau. ");
INSERT INTO tteo_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","Na letane kalona mena Deibida ilele iwaloba, “Ulaiya kupei bagunayan toweya koina kaleya ikaiwesosi na kwamiya-pileyoi kabo sikoyamate.” ");
INSERT INTO tteo_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","Kabo Yowabi yo ana tokaleyayao siya siyaele yanuwa lalakina kana gana simiya-takikilan mwa Ulaiya ipeiliya dedeine siya kali tokalomagigiliwo ali tokaleyayao namwanamwaliyao simiyamiya. ");
INSERT INTO tteo_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","Sauganane yanuwane ali tokaleyayao siyawatagili mekalikavao Yowabi me ana tokaleyayao sikaleya, kabo Deibida ana tokaleyayao tupwaliyao sisakona-yamateli. Kabo Ulaiya Iti tomona tabe sisakona-yamate yoi. ");
INSERT INTO tteo_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","Na Yowabi kaleyane wasana meuloina iyawasa Deibida koina. ");
INSERT INTO tteo_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","Iwalolau tosagenawasane koina iba, “Sauganane tem kaleyane wasana kuwalowen kin koina, ");
INSERT INTO tteo_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","nuwana kani imunamunai yo ineli iba, ‘Tawae kaiwena kulusae yanuwane dedeina yawasosi siya tokaleyayaone kaiwena? Nuwana nige ukakatai sowasowali tem gipoyo wamalina sikele-yawatagilanama ganane koina kani sisakonamiu? ");
INSERT INTO tteo_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","Na edeededena ukwatai dudulai gubesi mwa beyabeyana Gidiyon natuna Abimeleki iboita. Yanuwa Tibesi koina sine yabo veku lalakina witi kaba giligilina igabae-lobiyenama gana mena, mwa italu pwatana mena mwa iboita. Na tawae kaiwena kulusae ganane dedeina mena?’ Tem ineli besiele bwaite kabo kuwalo koina kuwaloba, ‘Am topaisowa Ulaiya Iti tomona iya mwa iboita.’” ");
INSERT INTO tteo_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","Saugana tosagenawasa ilau iyawatagili Yelusalema kabo ginauli meuloina Yowabi iyayawasawa iwalo-masalagili Deibida koina. ");
INSERT INTO tteo_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","Kabo iwalo Deibida koina bwaite besiele iba, “Kama tokalomagigiliwo sikaiwesosi nige sowasowamai kaunuili kabo siyawatagilima ali yanuwa mena mekamakavao kakaleya. Na iyamo kabibinli sipileyoi silau ali yanuwa kana gana kaba lusalusaena mena. ");
INSERT INTO tteo_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","Kabo siya tokabi gipoyo yo tokele wamali siulagilima silaoma kolimai mwa am tokaleyayao tupwaliyao sisakonali siboita. Na Ulaiya Iti tomona iya tabe iboita.” ");
INSERT INTO tteo_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","Mwa Deibida iwalo tosagenawasane koina iwaloba, “Kuwalo Yowabi koina kuwaloba, ‘Tabu kunuwanuwatusosi tomo bwaite ana boita kaiwena. Sauga meuloina tomo siboita kaleya koina yo nige takakatai yaiya kani ilobai. Na ukwaleya kaikaiwe na kuyemwawasili yo ali yanuwa kusibayanayanae’, walone bwaite kuwalowen koina Yowabi ukwabi-yakaiwe.” ");
INSERT INTO tteo_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","Saugana Ulaiya wasana wainena ibenalan ana taubala iboitako kabo ivalam. ");
INSERT INTO tteo_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","Yo saugana ana nuwanae imwawasi kabo Deibida tomo tupwaliyao iyawasali mwa sinene siyogan silawanama ana nume mena mwa ikasolanan. Yo Deibida natuna tauna yabo ikabi. Na mumuga bwaite Deibida ipaisowai Yeoba nige iyayaliyaya kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","Yeoba ana palopita Neitani iyawasa ilau Deibida koina kabo edeedede yabo iwalowen koina iwaloba, “Tatao labui simiyamiya yanuwa kaigeda koina, yabo towasawasa yo yabo tobubutuma. ");
INSERT INTO tteo_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","Towasawasa ana sipi yo bulumakau sibaibaiwasosi. ");
INSERT INTO tteo_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","Na tobubutuma ana wasawasao bwaite besiele, sipi natuna kaigedamo iyamaisa, igite-kalatan namwanamwai mwa menatunao silalaki. Mekanakavao sikekan toyawa yo sinuma komwa kaigeda koina yo ikenokenoya kaena mena. Sipine besiele natuna sinena yabo. ");
INSERT INTO tteo_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","Kaliyate yabo koina taumana yabo ilau towasawasa ana nume mena. Kabo towasawasane nige nuwanuwana iboma ana yakayakan yabo iunui na kana taumanane iyakan. Mwa ilau tobubutuma ana sipi kaigedamo na ikalai iunuyamate mwa iliga kana taumanane kaiwena.” ");
INSERT INTO tteo_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","Deibida imunamunai lalakina tomone ana paisowa kaiwena mwa iwalolau Neitani koina iwaloba, “Yakawalulu Yeoba esana mena, tomone ginauli bwaite ipaisowai ilonamwayan iboita. ");
INSERT INTO tteo_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","Mumuga bwaite iginauli kanakava nige ikakate-kamkamnayani kabo sipi esopali kani ikalaili na iyamaisa-yapileyoi koina.” ");
INSERT INTO tteo_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","Kabo Neitani iwalo Deibida koina iba, “Towasawasane iya mwa kowa. Na Yeoba Isileli ala Yaubada iwalo bwaite besiele, ‘Olo bwaite yasuwai kulukulum mena kuyamala Isileli ali kin yo yaleboiwo Saulo nimana mena. ");
INSERT INTO tteo_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","Na am taubala Saulo ana nume wasawasaliyao meuloina yaeyawa yoi, besiele wainenao yaeliwa nimam mena. Tabe kaba loina Isileli yo Yuda yaeyawa kuloinayani. Temga kunuwatui ginauli bwaite nige ilalalaki sowasowagu tabe yaetulan yoi. ");
INSERT INTO tteo_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","Na tawae kaiwena yau Yeoba yagu loina kusikotanan mwa mumuga naenaena koliyau kupaisowa? Kutalam boda Amoni Ulaiya Iti tomona sikoyamate kaleya koina na wainena ukwayai. ");
INSERT INTO tteo_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","Kabo sauga meuloina kaleya yo boita kani iyawayawatagili am susu kalona mena. Maisam bwaite besiele kaiwena ugamwa-panapanawa koliyau, nige kuyayakasisi-yagau mwa Ulaiya wainena ukwalai wainem.’ ");
INSERT INTO tteo_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","Kabo Yeoba iwalo bwaite besiele, ‘Kabo yawalo kani nae iyawatagili koliwo ilaoma am susu yabo tomona koina. Wainemwao yakalaili koliwo kabo yaolena kamkava yabo koina kabo mekanakavao sikeno toyawa kaliyate mena. ");
INSERT INTO tteo_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","Kowa nae uginauli wadam mena na yau maisam kani yaginauli mayale mena kaliyate koina boda Isileli meuloili manli mena.’” ");
INSERT INTO tteo_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","Kabo Deibida iwalo Neitani koina iwaloba, “Yalopwanoko Yeoba koina.” Kainana Neitani iyamaisa iba, “Yeoba am pwanoli inuwatu-pwaiki mwa kani nige kuboboita. ");
INSERT INTO tteo_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","Kaiwena Yeoba kumiya-dagedagelayan kabo natum tauna iya ukwabi kani iboita.” ");
INSERT INTO tteo_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","Kabo Neitani ilau ana nume mena. Mwa melumelune Deibida yo Batisiba natuli Yeoba iyakasiebwa lalakina. ");
INSERT INTO tteo_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","Kabo Deibida ikawanoi kaikaiwe Yeoba koina melumelune kaiwena. Guliyam ikalakisiyeyan boniyai meuloina ikenokeno bwatano mena. ");
INSERT INTO tteo_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","Mwa ana topaisowao esaliyao lalakiliyao silau koina mwa sisamalului yakato itoloma bwatano mena. Na isikote, nige nuwana itolo na mekanakavao sikekan. ");
INSERT INTO tteo_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","Na kaliyate sebenna koina melumelune iboita mwa ana topaisowao simatausi genuwali ana wasa siwolena mwa sinuwanuwatu siba, “Saugana nige naga melumelune iboboita na tawalowalo koina iyamo nige ibebenali kolila. Na kani gubegubesina na ana wasa taolena yakato natuna iboitako? Tem ana wasa taolena nuwana kani nae yabo iginauli.” ");
INSERT INTO tteo_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","Saugana Deibida igitai ana topaisowao sibalabalamumu kaloli mena kabo inuwatui melumelune iboitako. Mwa ineli iba, “Melumeluwa iboitako?” Kainana siyamaisa siba, “O, iboitako.” ");
INSERT INTO tteo_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","Kabo Deibida itoloma bwatano mena mwa ilau isugu yona iyaoloi yo kaleko waluwaluna ilikwa yo ilau ilusae Yeoba ana nume mena yo ipwalou Yeoba manna mena. Kabo ipileyoima ilau ana nume mena iwalo kan sikatububun mwa ikekan. ");
INSERT INTO tteo_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","Kabo ana topaisowao sineli siba, “Gubesi uginauli besiele? Saugana melumelune nige naga iboboita guliyam ukalakisiyeyan yo kuvalavalam na sauganane iboita kabo kutolo ukekan.” ");
INSERT INTO tteo_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","Kainali iyamaisa iba, “Saugana melumelune nige naga iboboita guliyam yakalakisiye-yan na yavalavalam kaiwena yagu nuwatu tem Yeoba imulolo koliyau na natugu inamwanamwa. ");
INSERT INTO tteo_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","Na sauganane melumelune iboita na tawae kaiwena guliyam yakalakisiye-yan? Kaiwena nige sowasowana yawasina yapei-yavivilayoi. Naga sauga yabo koina kani yau yalau koina na iya nige sowasowana ipileyoima koliyau.” ");
INSERT INTO tteo_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","Kabo Deibida wainena Batisiba ikabi-yaliyayayani yo mekanakava sikenokeno mwa natuna tauna yaboyoi ikabi yo esana ipei Solomoni. Na Yeoba melumelune imulolo lalakina koina. ");
INSERT INTO tteo_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","Kabo walo iyawasa ilau palopita Neitani koina melumelune esana ipei Yedidaiya kaiwena Yeoba imulolo koina. ");
INSERT INTO tteo_vpl VALUES ("S213_1","011_13_1","2SA","13","1","1","Deibida natuna Abisalomi duna tabe esana Tama iya kana koleya inamwanamwasosi. Na sauga yabo Aminoni sinene bwaite igadosisiyan. Aminoni iya Deibida natuna yaboyoi na iya sinana uloi. ");
INSERT INTO tteo_vpl VALUES ("S213_37","011_13_37","2SA","13","37","37","Na Abisalomi iyabubu ilau imiyamiya Talimai iya Amiudi natuna yo yanuwa Gesuli kana kin. Na kaliyate sibaibaiwa Deibida me ana nuwanae natuna kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S213_38","011_13_38","2SA","13","38","38","Saugana Abisalomi iyabubu ilau Gesuli mwa bolime yaiyona imiyamiya. ");
INSERT INTO tteo_vpl VALUES ("S213_39","011_13_39","2SA","13","39","39","Na kin Deibida ana nuwanae imwawasi yo iyaliyaya yoi mwa nuwanuwana lalakina tem Abisalomi igitai. ");
INSERT INTO tteo_vpl VALUES ("S214_1","011_14_1","2SA","14","1","1","Na Yowabi ikatai kin Deibida nuwanuwana lalakina Abisalomi igitai. ");
INSERT INTO tteo_vpl VALUES ("S214_21","011_14_21","2SA","14","21","21","Kabo Deibida iwalolau Yowabi koina iwaloba, “Inamwanamwa yapaisowai besiele am nuwatu. Kulau kilakaine Abisalomi kuyoga-yapileyoiyama.” ");
INSERT INTO tteo_vpl VALUES ("S214_22","011_14_22","2SA","14","22","22","Na kin kana yakasisi kaiwena Yowabi ipwalou-talu bwatano mena manna mena me ana nuwalobi kabo iwaloba, “Yagu guyau yo yagu kin, Yeoba imuloloiwo. Kaliyate kabona yau am topaisowa yakatai kuyaliyaya koliyau kaiwena yagu kawanoi koliwo besiele.” ");
INSERT INTO tteo_vpl VALUES ("S214_23","011_14_23","2SA","14","23","23","Kabo Yowabi ilau yanuwa Gesuli na Abisalomi ikele-yavivilayoiyama Yelusalema. ");
INSERT INTO tteo_vpl VALUES ("S214_24","011_14_24","2SA","14","24","24","Na Deibida iwaloba, “Ilau ana nume mena imiyamiya bwaine koina tabu ilalaoma igigitaiyau.” Mwa ilau ana nume mena yo nige ilalau kin igigitai. ");
INSERT INTO tteo_vpl VALUES ("S214_25","011_14_25","2SA","14","25","25","Isileli meuloili kaloli mena Abisalomi kana tobali ilalaki kaiwena kana koleya inamwanamwasosi. Tabe nige gai simiyamiya yona mena iyatubu kulukuluna mena ilau kaekaena mena. ");
INSERT INTO tteo_vpl VALUES ("S214_26","011_14_26","2SA","14","26","26","Bolime kaigeda kaigeda mekaigeda itona itomtom-gabaen kaiwena ipolowe ibalubalu. Kana polowe iliyei besiele tu kilogelam (2 Kg) yo isaeyoi. ");
INSERT INTO tteo_vpl VALUES ("S214_27","011_14_27","2SA","14","27","27","Abisalomi natunao tatao kali baibaiwa yaiyona yo sine kaigeda. Iya sinene esana Tama yo saugana ilalaki kana koleya inamwanamwasosi. ");
INSERT INTO tteo_vpl VALUES ("S214_28","011_14_28","2SA","14","28","28","Bolime labui Abisalomi imiyamiya Yelusalema na nige ilalau kin igigitai. ");
INSERT INTO tteo_vpl VALUES ("S214_29","011_14_29","2SA","14","29","29","Kabo walo iyawasa Yowabi koina yakato ilaoma na isagui na tem kin igitai, na Yowabi isikote. Walo iyawasayoi na nige ilalaoma. ");
INSERT INTO tteo_vpl VALUES ("S214_30","011_14_30","2SA","14","30","30","Mwa Abisalomi iwalo ana topaisowao kolili iba, “Wakataiyako Yowabi ana bali tanona imiyamiyaya yagu tano salina mena. Na kwalau wagabu.” Mwa siginauli besiele ana walowa. ");
INSERT INTO tteo_vpl VALUES ("S214_31","011_14_31","2SA","14","31","31","Kabo Yowabi ilau Abisalomi ana nume mena yo ineli iwaloba, “Tawae kaiwena am topaisowao yagu bali tanona sigabu?” ");
INSERT INTO tteo_vpl VALUES ("S214_32","011_14_32","2SA","14","32","32","Mwa Abisalomi iwalo koina iwaloba, “Kainagu yayawasa koliwo yakato kulaoma koliyau na iyamo nige kulalaoma. Yakato yayawasao kulau kin kuneliyan tawae kaiwena Gesuli yalogabaen na yalaoma bwaite koina. Ilonamwayagau tem yamiyamiya Gesuli na tabu yalalaoma. Nuwanuwagu yalau kin yagitai. Tem ginauli yabo yalopwano koina kani yatalam ikoyamateyau.” ");
INSERT INTO tteo_vpl VALUES ("S214_33","011_14_33","2SA","14","33","33","Kabo Yowabi ilau Deibida ana wasa iwolena Abisalomi tawae kainana. Mwa Deibida Abisalomi iyoganyama koina. Saugana iyawatagilima kabo ipwalou bwatano mena manna mena me ana nuwalobi. Kabo Deibida natuna Abisalomi inisoi yo iyaliyaya koina. ");
INSERT INTO tteo_vpl VALUES ("S215_1","011_15_1","2SA","15","1","1","Sauga yabo koina Abisalomi waga niuniuli yabo yo osi tupwaliyao ikalaili iya kaiwena mwa iyapaisowali yo iwalo tatao kali baibaiwa pipti (50) sisagena baguna manna mena. ");
INSERT INTO tteo_vpl VALUES ("S215_2","011_15_2","2SA","15","2","2","Besiele tabe malala kikiuna itolo mwa ilau itotolo yanuwa kana gana kaba lusalusaena kana kamwasa dedeina mena. Tem tomo yabo ilaoma na tem kana polowe ikalaiyama kin koina yatala kaiwena kani iyogalau koina iwaloba, “Toisabo yanuwa tomona kowa?” Kabo ana wasa iwolena. ");
INSERT INTO tteo_vpl VALUES ("S215_3","011_15_3","2SA","15","3","3","Tem tomone ilaomaya Isileli susu yabo koina kabo Abisalomi iwalolau koina iba, “Nuwatu bwaite ukakalaiyama kin koina idudulai yo inamwanamwa. Na nige tomo yabo imiyamiya kin yo ana topaisowao luwali mena na am yatala ibenalan.” ");
INSERT INTO tteo_vpl VALUES ("S215_4","011_15_4","2SA","15","4","4","Kabo ana walo ietulan iwalo koina iwaloba, “Temga yau sigitesipwaiyau na yaemala toyatala ala dedei mena na yaiya polowe ilobai ee kabo ilaoma koliyau na kani yayadudulai.” ");
INSERT INTO tteo_vpl VALUES ("S215_5","011_15_5","2SA","15","5","5","Besiele tabe tem tomo yabo ilaoma yakato ipwalou manna mena kani Abisalomi nimana iyagayani isapwali yo inisoi. ");
INSERT INTO tteo_vpl VALUES ("S215_6","011_15_6","2SA","15","6","6","Na ipaipaisowai besiele bwaite Isileli meuloili siya silalau kin koina yatala kaiwena kabo nuwali ibiga mwa silau koina. Kabo tomo Isileli meuloili simulolososi Abisalomi koina kabo muli mena Deibida. ");
INSERT INTO tteo_vpl VALUES ("S215_7","011_15_7","2SA","15","7","7","Bolime esopali ana kaba mwawasi koina kabo Abisalomi iwalo kin koina iba, “Kutalamwagau na yalau Ebiloni kabo yagu waloyameli Yeoba koina yayadudulai. ");
INSERT INTO tteo_vpl VALUES ("S215_8","011_15_8","2SA","15","8","8","Saugana yamiyamiya yanuwa Gesuli bwaine Alam dedeina mena yawaloyameli yawaloba, ‘Tem Yeoba ikele-yavivilayau yoi Yelusalema kani yalau Ebiloni koina yatapwalolo.’” ");
INSERT INTO tteo_vpl VALUES ("S215_9","011_15_9","2SA","15","9","9","Mwa kin iwalo koina iba, “Na kulau me am nuwadaumwali.” Kabo Abisalomi ilau Ebiloni. ");
INSERT INTO tteo_vpl VALUES ("S215_10","011_15_10","2SA","15","10","12","Na tatao kali baibaiwa tu andeledi (200) Yelusalema koina ikalaili kana toegelugeluwo na nige sikakatai kani tawae sipapaisowai. Saugana pwaoli ipaipaisowai Ebiloni koina kabo iwalo Aitopeli game Gilo iya Deibida ana topaisowa lalakina yabo ilaoma isagui. Bwaine kamwasane koina Abisalomi ana boda ilalalalaki yo kalomagigili kin koina ilalaki tabe. Na Abisalomi ana tosagenawasa iyawasali wadam mena silau susu Isileli meuloili kolili siba, “Saugana tem bwagigi kainana kwabenalani kani kwaba, ‘Abisalomiwa iyamala ala kin yanuwa Ebiloni koina.’” ");
INSERT INTO tteo_vpl VALUES ("S215_13","011_15_13","2SA","15","13","13","Yo tosagenawasa yabo ilau iwalo Deibida koina iba, “Isileli meuloili silauko sipatu Abisalomi koina.” ");
INSERT INTO tteo_vpl VALUES ("S215_14","011_15_14","2SA","15","14","14","Kabo Deibida iwalo ana topaisowao esaliyao lalakiliyao siya mekanakavao Yelusalema kolili siba, “Talau tayabubu. Tem nigele, nige yabo ileleboila Abisalomi koina. Mwayamwayau tayabubu tem silobaila kani sikoyamatela yo Yelusalema kana tomiyayao sikoyamateli kaleya kelepana koina.” ");
INSERT INTO tteo_vpl VALUES ("S215_15","011_15_15","2SA","15","15","15","Kabo ana topaisowao kainana siyamaisa siwaloba, “Ama guyau yo ama kin, tawae tem kunuwatui inamwanamwa kuwalo kolimai na kai am topaisowao kani kaginauli besiele.” ");
INSERT INTO tteo_vpl VALUES ("S215_16","011_15_16","2SA","15","16","16","Mwa kin ilau yo ana nume kana tomiyayao meuloili siyamuli kusuli, na wainenao tupwaliyao kali baibaiwa sanaulu (10) ilogabaegili na kin numena sigite-kalatan. ");
INSERT INTO tteo_vpl VALUES ("S215_17","011_15_17","2SA","15","17","17","Na kin ilolokeikeile yo ana tomoyao meuloili siyamuli kusuli silau yanuwa ana kaba mwawasi numena koina mwa kin yo kanakavao tupwali sitolo. ");
INSERT INTO tteo_vpl VALUES ("S215_18","011_15_18","2SA","15","18","18","Kabo ana tokaleya meuloili siloyagiulili silau kana koleya mena kalikavao tabe boda Keleti yo Peleti, siya Deibida ana boda solodiya. Besiele tabe tokaleyayao yanuwa Gata (Pilistiya) tomonliyao kali baibaiwa sikisi andeledi (600) siya Deibida siyamuli kusuli silaoma Gata sigiuli silau. ");
INSERT INTO tteo_vpl VALUES ("S215_19","011_15_19","2SA","15","19","19","Kabo kin iwalo ali tobaguna esana Itai game Gata koina iwaloba, “Gubesi mwa kulaoma kolimai? Kupileyoi kulau mekamkava kin Abisalomi, kaiwena kowa taumana nige kumiyamiya am yanuwa mena. ");
INSERT INTO tteo_vpl VALUES ("S215_20","011_15_20","2SA","15","20","20","Lainamo kabo kuyawatagilima na tem tabu kulalaoma kolimai kaiwena nige yakakatai toweya yalalau. Kupileyoi am tomoyao mekamkavao. Na yau kani yakawanoi Yeoba ana katekamkamna yo ana mulolo imiyamiya koliwo.” ");
INSERT INTO tteo_vpl VALUES ("S215_21","011_15_21","2SA","15","21","21","Na Itai kainana iyamaisa iwaloba, “Yagu guyau yo yagu kin, yakawalulu Yeoba meyawasina esana mena yo kowa esam mena, toisabo dedei koina kulau bwagana tem namwanamwa yo boita kani kowa mekaukava.” ");
INSERT INTO tteo_vpl VALUES ("S215_22","011_15_22","2SA","15","22","22","Kabo Deibida iwalo Itai koina iba, “Inamwanamwa, kulaoma talau.” Kabo Itai me ana tokaleyayao meuloili yo natuliyao mekalikavao silau. ");
INSERT INTO tteo_vpl VALUES ("S215_23","011_15_23","2SA","15","23","23","Tomo simiyamiya yanuwa kikiuli Yelusalema salina mena sivalam kainali ilalaki. Saugana Deibida Yelusalema ilogabaen ilau iyawatagili waila kikiuna esana Kidilon silopanaisi kabo sikawasae gunuwala mena. ");
INSERT INTO tteo_vpl VALUES ("S215_24","011_15_24","2SA","15","24","24","Ebayada isaema yo Seidoki mekanakavao susu Libai tupwali siyaele tabe. Yeoba ana kelabilabin kamwasana kana dedewaga sikewakewai. Saugana sipei-yatalu kabo pwaoli siginauli Yeoba koina kanasiga tomo meuloili Yelusalema silogabaen. ");
INSERT INTO tteo_vpl VALUES ("S215_25","011_15_25","2SA","15","25","25","Kabo kin iwalo Seidoki koina iba, “Yeoba ana kelabilabin kamwasana kana dedewaga kuyapileyoiyama yanuwa mena. Tem Yeoba iyaliyaya koliyau kabo kani iyapileyoiyau kabo ana nume yo ana kelabilabin kamwasana kana dedewaga yagitaili yoi. ");
INSERT INTO tteo_vpl VALUES ("S215_26","011_15_26","2SA","15","26","26","Na tem nige iyayaliyaya koliyau yatalamwagau tawae nuwanuwana iginauli koliyau iginauli.” ");
INSERT INTO tteo_vpl VALUES ("S215_27","011_15_27","2SA","15","27","27","Mwa kin iwaloyoi topwaoli Seidoki koina iba, “Mekamkava natum Aimasi yo Ebayada menatuna Diyonatan kwapileyoi Yelusalema me ami nuwadaumwali. ");
INSERT INTO tteo_vpl VALUES ("S215_28","011_15_28","2SA","15","28","28","Yau kani yasanasana waila Yolidani papalina mena kaba nete-panaisi mena kanasiga tem wasa yabo yabenalan koliwo tawae ilaulau Yelusalema koina.” ");
INSERT INTO tteo_vpl VALUES ("S215_29","011_15_29","2SA","15","29","29","Kabo Seidoki yo Ebayada kelabilabin kamwasana kana dedewaga sikewa-yapileyoi Yelusalema na simiyamiya bwaine koina. ");
INSERT INTO tteo_vpl VALUES ("S215_30","011_15_30","2SA","15","30","30","Deibida kulukuluna isuma na kae bwagabwagana ilaulau ilolovalavalam kabo ikawasae koya Olibe. Yo tomo sibaibaiwa besiele kulukululi sisumali na silolo-valavalam. ");
INSERT INTO tteo_vpl VALUES ("S215_31","011_15_31","2SA","15","31","31","Na kabona Deibida ana wasa siwolena siba, “Aitopeli ipatuko Abisalomi ana boda koina.” Kabo ikawanoi Yeoba koina iba, “O Yeoba, Aitopeli ana walo sagu Abisalomi koina kubui-keile na sikalai besiele nuwatu yauyauleli.” ");
INSERT INTO tteo_vpl VALUES ("S215_32","011_15_32","2SA","15","32","32","Saugana Deibida iyawatagili Koya Olibe pwatana mena, beyabeyana koina sitapwatapwalolo Yeoba koina, na taubala yabo esana Usai iya yanuwa Aliki tomona yo susu Beniyamina, ilobai ilalaoma kana kaleko ilotaitaigali yo bwatano itona mena ipei. ");
INSERT INTO tteo_vpl VALUES ("S215_33","011_15_33","2SA","15","33","33","Kabo Deibida iwalo koina iba, “Na kani polowe kuyeyama tem kowa te yau talau kaiwena kowa kutautaubala. ");
INSERT INTO tteo_vpl VALUES ("S215_34","011_15_34","2SA","15","34","34","Kupileyoi Yelusalema kabo kuwalo Abisalomi koina kuwaloba, ‘O kin, beyabeyana yapaisowa tamam kaiwena na kaliyate kabona kani yapaisowa kaiwem.’ Yo saugana Abisalomi ineli tawae kani ipaisowai sowasowam Aitopeli ana walo sagu Abisalomi koina ukawa-naenaeyan na tabu Abisalomi Aitopeli ana walo imumuliya. Bwaine kamwasane koina kani kusaguiyau. ");
INSERT INTO tteo_vpl VALUES ("S215_35","011_15_35","2SA","15","35","35","Na topwaoli Seidoki yo Ebayada siya tabe kani yanuwa mena simiyamiya. Tem wasa yabo kubenalan Abisalomi ana nume mena, kabo kuwalowen kolili. ");
INSERT INTO tteo_vpl VALUES ("S215_36","011_15_36","2SA","15","36","36","Natuliyao tatao labui Aimasi iya Seidoki natuna yo Diyonatan iya Ebayada natuna, siyaele bwaine mekalikavao. Tem wasa yabo kubenalan kabo kuwalowen kolili na natuliyao siyawasalima koliyau yagu wasa siyeyama.” ");
INSERT INTO tteo_vpl VALUES ("S215_37","011_15_37","2SA","15","37","37","Saugana Usai, Deibida ana eliyam, ilau iyawatagili Yelusalema tabe Abisalomi besiele kabo iyawatagilima ilulusae gamwa mena. ");
INSERT INTO tteo_vpl VALUES ("S216_1","011_16_1","2SA","16","1","1","Deibida Koya Olibe ilogabaen yo kikiunamo ilau na Mepiboseti ana topaisowa Siba iyaele bwaine koina isanasana kaiwena. Donki tupwali ikatububunagiliko mwa beledi kana baibaiwa tu andeledi (200), deit iya oine kanna sikavaegai sumana kana baibaiwa wan andeledi (100) yo venavena kanna wan andeledi (100) yo oine tupwana itaulili donki pwatali mena. ");
INSERT INTO tteo_vpl VALUES ("S216_2","011_16_2","2SA","16","2","2","Kabo kin ineli Siba koina iba, “Tawae kaiwena ginauline bwaite ukwalailima?” Kainana iyamaisa iwaloba, “Na donki bwaite am susuwo kaiwemiu kwamwalisae kolili na beledi yo deit yo venavena bwaite am tomoyao kaiweli, yo oine bwaite ami kaba numa saugana tem yomiu sisawosawowoli ule mena.” ");
INSERT INTO tteo_vpl VALUES ("S216_3","011_16_3","2SA","16","3","3","Kabo kin ineli iba, “Am taubala Saulo tubuna Mepiboseti toweya?” Mwa Siba iwalolau koina iba, “Iya iyaele Yelusalema kaiwena ana nuwatu mena yakato kani tubuna Saulo ana kaba loina Isileli kalona mena kani siwolena koina.” ");
INSERT INTO tteo_vpl VALUES ("S216_4","011_16_4","2SA","16","4","4","Kabo kin iwalo Siba koina iba, “Saugane bwaite Mepiboseti ana gogo meuloina yaeyawa koliwo am gogo.” Na Siba iwaloba, “Yagu guyau yo yagu kin, yapwalou koliwo. Na yakawanoi sauga meuloina kuyaliyaya koliyau.” ");
INSERT INTO tteo_vpl VALUES ("S216_5","011_16_5","2SA","16","5","5","Saugana kin Deibida yanuwa Baulim ilokelakela-kubwai mwa tomo yabo ilaoma, iya Saulo ana susu yabo, iyawatagilima yanuwane koina esana Simei iya Gela natuna. Iyawatagilima na ilolo-edeedede Deibida ikawa-naenaeyani. ");
INSERT INTO tteo_vpl VALUES ("S216_6","011_16_6","2SA","16","6","6","Besiele tabe veku igabagabaegili Deibida me ana topaisowao esaliyao lalakili kolili, bwagana Deibida iyaele imiyamiya tokaleyayao yo tokaiweyao luwali mena. ");
INSERT INTO tteo_vpl VALUES ("S216_7","011_16_7","2SA","16","7","7","Na Simei Deibida ikawa-naenaeyani bwaite besiele, “Kulowasi, kulowasi, topaisowa naenaena kowa yo nimam ikwasine. ");
INSERT INTO tteo_vpl VALUES ("S216_8","011_16_8","2SA","16","8","8","Yeoba iyamayamaisao kaiwena Saulo ana nume tomonliyao ukoyamateli mwa ana kaba miya ukwalai kuloinayani. Na am paisowa kaiwena, Yeoba am kaba loina iwolena natum Abisalomi koina. Na kowa nae kani kulobai kaiwena nimam ikwasine.” ");
INSERT INTO tteo_vpl VALUES ("S216_9","011_16_9","2SA","16","9","9","Kabo Seluwaiya natuna Abisai iwalo kin koina iba, “Tomone bwaite iya tomo bwagabwaga iya besiele bwauwa boiboitana. Gubesi, kowa yagu guyau yo yagu kin, na ikawa-naenae-yagiwo? Yalau galogalona yatom.” ");
INSERT INTO tteo_vpl VALUES ("S216_10","011_16_10","2SA","16","10","10","Mwa kin iwaloba, “Komiu Seluwaiya natunao, nige ami dedei besi, nige ami yai ipapagan na kwawalowalo koliyau kaiwena. Tem Yeoba ana nuwatu besiele na ikawa-naenae-yagau, na kita nige ala dudulai yabo, tamwanoumo.” ");
INSERT INTO tteo_vpl VALUES ("S216_11","011_16_11","2SA","16","11","11","Kabo Deibida iwalo Abisai yo ana tali topaisowa esaliyao lalakili kolili iba, “Natugu Abisalomi itonatonan nuwanuwana tem ikoyamateyau. Na tawae kaiwena katemiu sipitali tomo bwaite iya ana susu Beniyamina ana walo kaiwena? Yeoba iwalo koina ikawa-naenae-yagau mwa wakabi-gabaen na ana nuwatu ipaisowai. ");
INSERT INTO tteo_vpl VALUES ("S216_12","011_16_12","2SA","16","12","12","Na nuwana kani Yeoba yagu nuwapolowe igitai kabo kawa-naenaene ibui-keile iyamala kagu walo-mulolo yo maisana namwanamwana iyeyama koliyau.” ");
INSERT INTO tteo_vpl VALUES ("S216_13","011_16_13","2SA","16","13","13","Kabo Deibida yo ana bodao silau yoi ali kamwasa mena na Simei ilau koya pwatana mena iyamuli kusulili. Kabo ilolo-edeedede Deibida ikawakawa-naenaeyani besiele tabe veku yo bwatano leleyanna igabagabaen kolili. ");
INSERT INTO tteo_vpl VALUES ("S216_14","011_16_14","2SA","16","14","14","Saugana kin me ana bodao siyawatagili waila Yolidani yoli sibelusosi, mwa sikaiyawasi bwaine koina. ");
INSERT INTO tteo_vpl VALUES ("S216_15","011_16_15","2SA","16","15","15","Abisalomi yo Isileli meuloili siyawatagili Yelusalema na Aitopeli iyaele mekalikava. ");
INSERT INTO tteo_vpl VALUES ("S216_16","011_16_16","2SA","16","16","16","Usai, iya tomo Aliki yo Deibida ana eliyam, ilau Abisalomi koina yo iwaloba, “Ama kin, yawasim imamalawe, ama kin, yawasim imamalawe.” ");
INSERT INTO tteo_vpl VALUES ("S216_17","011_16_17","2SA","16","17","17","Yo Abisalomi ineli iwaloba, “Baguna Deibida kuyakasisiyan lalakina yakato am eliyam namwanamwana na sauga bwaite am yakasisi toweya iyaele? Tawae kaiwena nige mekamkava kwalalau?” ");
INSERT INTO tteo_vpl VALUES ("S216_18","011_16_18","2SA","16","18","18","Kabo kainana iyamaisa iba, “Tomo bwaite Yeoba yo tomo Isileli meuloili sigitesipwai mwa nuwanuwagu yasagui. Iya kaiwena mwa yamiyamiya bwaite koina. ");
INSERT INTO tteo_vpl VALUES ("S216_19","011_16_19","2SA","16","19","19","Na nuwatu yaboyoi, ilonamwayagau tem yagu taubala natuna yasagui. Beyabeyana yapaisowa tamam koina, tabe besiele bwaite, kani yapaisowa kaiwem.” ");
INSERT INTO tteo_vpl VALUES ("S216_20","011_16_20","2SA","16","20","20","Kabo Abisalomi itagela-keile yo iwalo Aitopeli koina iba, “Am nuwatu gubesi, tawae kani yaginauli?” ");
INSERT INTO tteo_vpl VALUES ("S216_21","011_16_21","2SA","16","21","21","Aitopeli kainana iyamaisa iwaloba, “Kulau tamam wainenao tupwaliyao mekamkavao wakeno toyawa siya ilogabaegili ana nume sigitegite-kalatan. Kabo Isileli meuloili kani sikatai yakato kowa tamam kana tokalomagigili na mesabana kam tomuliyayao kateli sipatu na siyaliyaya kaiwem.” ");
INSERT INTO tteo_vpl VALUES ("S216_22","011_16_22","2SA","16","22","22","Kabo palai yabo siyatolo nume pwatana mena mwa Abisalomi ilau mekanakavao tamana wainenao tupwaliyao sikenokenoya kalona mena Isileli meuloili manli mena. ");
INSERT INTO tteo_vpl VALUES ("S216_23","011_16_23","2SA","16","23","23","Na sauganane Aitopeli ana walo meuloina bwaite iwalowen tobenali sikalaili yakato walone ilaomaya Yeoba koina. Yo beyabeyana Deibida ana meli ipei koina kabo Abisalomi iginauli besiele tabe. ");
INSERT INTO tteo_vpl VALUES ("S217_1","011_17_1","2SA","17","1","1","Kabo Aitopeli iwalo Abisalomi koina iba, “Yagu nuwatu bwaite, temga tokaleyayao kali baibaiwa tuwelo tausan (12,000) yakalaili kabo boniyai mena kalau Deibida kaloyai. ");
INSERT INTO tteo_vpl VALUES ("S217_2","011_17_2","2SA","17","2","2","Bwaite sauga iya iyaele yona ibelu yo kamnana inae kabo saugana kalobai kani kakaleya koina. Kani imatausi lalakina kabo ana tomoyao meuloili kani siyabubu-gabaeni. Na iya ibomamo kani yaunuyamate, ");
INSERT INTO tteo_vpl VALUES ("S217_3","011_17_3","2SA","17","3","3","na tomo meuloili kani yakalailima koliwo. Nuwanuwala tamammo taunui. Na tomo meuloili me ali namwanamwa kani sipileyoima koliwo.” ");
INSERT INTO tteo_vpl VALUES ("S217_4","011_17_4","2SA","17","4","4","Na nuwatu bwaite Abisalomi mekanakavao Isileli ali tautaubalao meuloili sikawa-namwanamwa-yan. ");
INSERT INTO tteo_vpl VALUES ("S217_5","011_17_5","2SA","17","5","5","Na Abisalomi iwalo iba, “Usai tomo Aliki kuyogan ilaoma na ana nuwatu iwalowen tabenalan tabe.” ");
INSERT INTO tteo_vpl VALUES ("S217_6","011_17_6","2SA","17","6","6","Saugana Usai ilaoma Abisalomi Aitopeli ana nuwatu iwalowen Usai koina yo ineli iba, “Na gubesi, Aitopeli ana nuwatu tamuliya o nigele? Tem nigele, kabo am nuwatu kuwaloweni kabenalan.” ");
INSERT INTO tteo_vpl VALUES ("S217_7","011_17_7","2SA","17","7","7","Kainana Usai iyamaisa iwaloba, “Nuwatu bwaite Aitopeli iwalowen saugane bwaite nige inanamwanamwa. ");
INSERT INTO tteo_vpl VALUES ("S217_8","011_17_8","2SA","17","8","8","Ukwatai tamam mekanakavao ana kilakaiwo siya tokaleya kaikaiweli besiele tem beya imunamunai natunao kaiweli ana kaiwe. Besiele tamam ana katai kaleya kaiwena ilalaki kabo boniyainane nige imiyamiya ana tokaleyayao kolili. ");
INSERT INTO tteo_vpl VALUES ("S217_9","011_17_9","2SA","17","9","9","Na sauga bwaite iya iyaele ikeno-wadam gula kalona mena o yanuwa yabo koina. Temga ikaleya baguna am tokaleyayao kolili yo tupwaliyao ikoyamateli kani siya wasa sibenalan siwaloba, ‘Abisalomi ana tokaleyayao sibeku siboita.’ ");
INSERT INTO tteo_vpl VALUES ("S217_10","011_17_10","2SA","17","10","10","Bwagana am tokaleyayao siya sikaiwe yo sikatepatu besiele laiyon kani simatausi kaiwena me ali tabubu. Kaiwena Isileli meuloili sikatai tamam iya tokaiwe yo ana tokaleyayao sikatepatu. ");
INSERT INTO tteo_vpl VALUES ("S217_11","011_17_11","2SA","17","11","11","Yagu guguye bwaite, Isileli ali tokaiwe meuloili kuyamiya-gogonagili susu Dani siya simiyamiya kaluwabu dedeina mena ilau kanasiga tete yavana yanuwa Biyasiba koina na mesabana am tokaleya ibaibaiwa besiele dekawa. Na kowa kuboma kani kubaguna-yagili kaleyane koina. ");
INSERT INTO tteo_vpl VALUES ("S217_12","011_17_12","2SA","17","12","12","Kabo tem toisabo dedei koina talobai me ana tokaleyayao tamiya-kausili kateli tayapitali kabo iya mekanakavao ana tomoyao meuloili taemwawasili nige yabo tupwa. ");
INSERT INTO tteo_vpl VALUES ("S217_13","011_17_13","2SA","17","13","13","Tem iyabubu ilau yanuwa lalakina yabo koina kabo Isileli meuloili kani maina sikalai yo yanuwa kana gana sitabe-yabeku ilobi kalogawa mena kanasiga meuloina itatagwaligwali imwawasi.” ");
INSERT INTO tteo_vpl VALUES ("S217_14","011_17_14","2SA","17","14","14","Kabo Abisalomi yo Isileli ali tautaubalao meuloili siwaloba, “Usai ana nuwatu inamwanamwasosi kabo Aitopeli ana walone.” Mwa iyawatagili besiele kaiwena Yeoba iloinako Aitopeli ana walo namwanamwana kani iyamala ginauli bwagabwaga, mwa polowe ikalaiyama Abisalomi koina. ");
INSERT INTO tteo_vpl VALUES ("S217_15","011_17_15","2SA","17","15","15","Kabo Usai ilau topwaoli Seidoki yo Ebayada kolili na ali wasa meuloina iwolegili ibomayoi yo Aitopeli ali walo Abisalomi yo Isileli ali tautaubalao kolili. ");
INSERT INTO tteo_vpl VALUES ("S217_16","011_17_16","2SA","17","16","16","Na iwaloba, “Mwayamwayau Deibida ana wasa kuwolena kuwaloba, ‘Tabu ukekeno waila Yolidani kaba nete-panaisi mena. Mwayamwayau kulopanaisi kulau gunuwala mena na mesabana Abisalomi me ana bodao kwayabubu-gabaegili na tabu siunuimiu.’” ");
INSERT INTO tteo_vpl VALUES ("S217_17","011_17_17","2SA","17","17","17","Na Diyonatan yo Aimasi simiyamiyaya waila bunubunuwasina esana Enlogeli koina na topaisowa sine yabo ilau wasa ikalaiyama kolili na siya silau siwalo-masalan Deibida koina. Nuwatune siginauli kaiwena mesabana tabu tomo sigigitaili Yelusalema kalona mena. ");
INSERT INTO tteo_vpl VALUES ("S217_18","011_17_18","2SA","17","18","18","Na saugana topaisowa sinene ilau Diyonatan yo Aimasi kolili game yabo igite-lobaili mwa ilau Abisalomi ana wasa iwolena. Kabo mwayamwayau siyabubu silau yanuwa Baulim taubala yabo ana nume mena. Waila keli yabo iyaele ana bakubaku mena kabo sikaisulu kalona mena sikeno-wadam. ");
INSERT INTO tteo_vpl VALUES ("S217_19","011_17_19","2SA","17","19","19","Kabo taubalane wainena kaleko ikalai ipei waila kana kopwaiki pwatana mena. Kabo witi kanna ipei kalekone pwatana mena na mesabana tabu tomo yabo ikakatai. ");
INSERT INTO tteo_vpl VALUES ("S217_20","011_17_20","2SA","17","20","20","Saugana Abisalomi ana topaisowao silau sinene koina ana nume mena mwa sineli koina siwaloba, “Aimasi yo Diyonatan tosiyaele?” Kainali iyamaisa iba, “Siyaele silolopanaisi wailane koina.” Mwa silau siloyaili na nige silolobaili kabo sipileyoi Yelusalema. ");
INSERT INTO tteo_vpl VALUES ("S217_21","011_17_21","2SA","17","21","21","Saugana silauko mwa Aimasi yo Diyonatan simwalisaema waila keli kalona mena, kabo silau kin Deibida koina siwaloba, “Saugamo bwaite kutolo wailane kulopanaisi kaiwena Aitopeli nuwatune iwolenako Abisalomi koina yakato kansiga boniyai silaoma sikaleya kolimiu na sikoyamatemiu.” ");
INSERT INTO tteo_vpl VALUES ("S217_22","011_17_22","2SA","17","22","22","Kabo boniyainane koina Deibida mekanakavao ana tomoyao meuloili sitolo waila Yolidani silopanaisi. Mwa meuloili silaomako waila dedeina yabo mena kabo muli mena yanuwa ilayan. ");
INSERT INTO tteo_vpl VALUES ("S217_23","011_17_23","2SA","17","23","23","Saugana Aitopeli igitai ana nuwatu nige simumuliya mwa ana donki ikatububunani yo imwalisae pwatana mena ilau ana yanuwa mena Gilo. Ana walo mwawamwawasina iwalowen natunao kolili kabo ilau igadosowa yo iboita. Mwa yona sipeiya tubunao kali salai mena. ");
INSERT INTO tteo_vpl VALUES ("S217_24","011_17_24","2SA","17","24","24","Deibida mekanakavao tomo meuloili silopanaisiko waila Yolidani mwa silau yanuwa esana Manaim. Siyawatagiliko Manaim kabo Abisalomi ana tokaleyayao silaomaya Isileli meuloina koina sikatukatububu silaoma na waila Yolidani silopanaisi. ");
INSERT INTO tteo_vpl VALUES ("S217_25","011_17_25","2SA","17","25","25","Abisalomi iya Amasa ipei ana tokaleya ali tobaguna, Yowabi ana kaba miya iyamiyalaei. (Amasa tamana esana Yeta, game Isileli yo sinana Abigaili. Abigaili kanakava Seluwaiya Yowabi sinana yo tamali esana Nayasi.) ");
INSERT INTO tteo_vpl VALUES ("S217_26","011_17_26","2SA","17","26","26","Kabo Abisalomi mekanakavao Isileli ali tokaleyayao sigogo Giliyadi dedeina mena. ");
INSERT INTO tteo_vpl VALUES ("S217_27","011_17_27","2SA","17","27","27","Na saugana Deibida iyawatagili Manaim koina kabo Sobi, Makili yo Basilai ilobaili. Na Sobi iya Nayasi natuna ilaomaya Laba dedei Amoni koina. Yo Makili iya Amieli natuna iya Lodeba tomona. Na Basilai iya game Logelim dedei Giliyadi koina. ");
INSERT INTO tteo_vpl VALUES ("S217_28","011_17_28","2SA","17","28","28","Na kaba keno, gaeba yo gulewa sikele-gogo-nagilima silawagilima koina. Besiele tabe kan, witi, bali, pwalawa, bali kavakavaegana, bin, lentil, ");
INSERT INTO tteo_vpl VALUES ("S217_29","011_17_29","2SA","17","29","29","kamwakamwa, sipi, gouti yo sisi uloina siginaulili bulumakau miliki koina sikalaiyama Deibida yo ana tomoyao kali siginauli. Bwaite besiele kaiwena sinuwatui siba, “Tomo silolokeikeile ule mena yo siguliyam, galogaloli simagu yo tabe yoli sisawosawowoli.” ");
INSERT INTO tteo_vpl VALUES ("S218_1","011_18_1","2SA","18","1","1","Deibida ana tokaleya meuloili iyamiya-gogonagili kabo ali tobaguna tupwali igite-sipwaili kabo ipeili boda uloi uloi kolili tupwana tausan ali tobagunao yo tupwana andeledi ali tobagunao. ");
INSERT INTO tteo_vpl VALUES ("S218_2","011_18_2","2SA","18","2","2","Mwa iyakasali boda yaiyona yabo Yowabi iyoganli, labuina Abisai iya Yowabi kanakava sinali esana Seluwaiya iyoganli, yo yaiyonana Itai game Gata iyoganli. Kabo iwalo kolili iwaloba, “Yau tabe kani yalaowa mekamikava.” ");
INSERT INTO tteo_vpl VALUES ("S218_3","011_18_3","2SA","18","3","3","Na ana tokaleyayao siwalo koina siba, “Tabu kulalaoma kolimai. Tem sitawoila tayabubu kani nige sinuwanuwatu kaiwemai. Bwagana tem kabaibaiwasosi kaboita bwaine nige tawae yabo. Yawasim iya ginauli lalakisosina kabo kai yomai ten tausanne. Na inamwanamwamo kumiya-pileyoi na kama sagumo kuyawayawasayama kolimai.” ");
INSERT INTO tteo_vpl VALUES ("S218_4","011_18_4","2SA","18","4","4","Kainali kin Deibida iyamaisa iwaloba, “Tawae kwanuwatui kaiwegu inamwanamwasosi.” Mwa iginauli besiele kabo itolo yanuwane kana gamwa mena na ana tokaleyayao kali boda tausan yo andeledi mekalikavao siyawatagili silau. ");
INSERT INTO tteo_vpl VALUES ("S218_5","011_18_5","2SA","18","5","5","Na kin loina iwalowenako Yowabi, Abisai yo Itai kolili iba, “Kwabenali namwanamwa. Kagu yakasisi kaiwegu tabu ginauli yabo wagiginauli Abisalomi koina.” Kabo saugana iedeedede tobagunao kolili Abisalomi kaiwena tokaleyayao meuloili sibenalani. ");
INSERT INTO tteo_vpl VALUES ("S218_6","011_18_6","2SA","18","6","6","Na tokaleyayaone yanuwa silogabaeni silau ule yabo esana Ule Ipeleim, kabo Isileli silobaili mwa sikaleya. ");
INSERT INTO tteo_vpl VALUES ("S218_7","011_18_7","2SA","18","7","7","Deibida ana tokaleyayao Abisalomi ana bodao sikaiwe-gabaegili mwa kaliyatenane koina boita ilalakisosi yo Isileli kali baibaiwa tuwenti tausan (20,000) siboita. ");
INSERT INTO tteo_vpl VALUES ("S218_8","011_18_8","2SA","18","8","8","Na kaleya manna siyaganawali dedei meuloina koina kabo sibaibaiwasosi ule mena sisilae kabo muli mena siya siboita kaleya kelepana koina. ");
INSERT INTO tteo_vpl VALUES ("S218_9","011_18_9","2SA","18","9","9","Siya nagamo siyaele sikalekaleya na Abisalomi imwalisae ana donki pwatana mena kabo Deibida ana tokaleyayao tupwali ilobaili. Nuwanuwana iyabubu na saugane isagena mayau ouki lagalagana yaulina mena mwa galogalona iloka kabo itaketake mwayaga bwagabwaga mena na ana donki iyaele isagesagena. ");
INSERT INTO tteo_vpl VALUES ("S218_10","011_18_10","2SA","18","10","10","Kabo tokaleya yabo igite-lobai mwa ilau iwalo Yowabi koina iba, “Abisalomi yagitai itaketake mayau ouki koina.” ");
INSERT INTO tteo_vpl VALUES ("S218_11","011_18_11","2SA","18","11","11","Yo kainana Yowabi iyamaisa iwaloba, “Yawasosi? Tawae kaiwena ugitai na nige ukokoyamate? Tem ukoyamate kani yayaliyayasosi kabo mane lalakina yo wakisowa yabo yaeyawa koliwo maisam.” ");
INSERT INTO tteo_vpl VALUES ("S218_12","011_18_12","2SA","18","12","12","Yo kainana tomone iyamaisa iba, “Bwagana tem siliba kana baibaiwa tausan kaigeda kuyeyama na nige sowasowagu nimagu italu kin natuna koina na yakoyamate. Kai meuloimai kin ana walo kabenalan iwalo kowa, Abisai yo Itai kolimiu iwaloba, ‘Kagu yakasisi kaiwegu tabu ginauli yabo wagiginauli Abisalomi koina.’ ");
INSERT INTO tteo_vpl VALUES ("S218_13","011_18_13","2SA","18","13","13","Na kabona tem kin natuna yawasina yatom, walo yawasosi wasagu kani kin ibenalani kaiwena nige ginauli yabo ikekeno-wadam koina. Na kowa kani kam mwayaga iyai koliyau yo kani nige kuwawalo-saguiyau.” ");
INSERT INTO tteo_vpl VALUES ("S218_14","011_18_14","2SA","18","14","14","Kabo Yowabi iwaloba, “Nige nuwagu kowa te yau taedeedede.” Mwa wamali yaiyona ikalaili ilau Abisalomi isakona gamwagamwalina mena saugana yawasina iyaele imiyamiya na itaketake mayaune koina. ");
INSERT INTO tteo_vpl VALUES ("S218_15","011_18_15","2SA","18","15","15","Na siya Yowabi ana kaleya gogoliyao kali tokayale yoli sanaulu (10) silau Abisalomi simiya-takikilan kabo sikoyaboita. ");
INSERT INTO tteo_vpl VALUES ("S218_16","011_18_16","2SA","18","16","16","Kabo Yowabi bwagigi iyui tokaleyayao iyamwanouli kabo kaleya silopei. ");
INSERT INTO tteo_vpl VALUES ("S218_17","011_18_17","2SA","18","17","17","Na Abisalomi kwapina sikalai kabo sigabae-lobiyen gula lalakina koina bwatano kalona mena yo veku lalakili sikalaili sikopwaiki koina. Na Abisalomi ana tokaleyayao meuloili siyabubu silau ali yanuwa uloi uloi kolili. ");
INSERT INTO tteo_vpl VALUES ("S218_18","011_18_18","2SA","18","18","18","Na tauna kona saugana Abisalomi meyawasina veku tabatabana yabo iyatolo yanuwa yabo esana Kin Kwabuna iboma esana kana nuwatu-kalatan. Ipaisowai besiele kaiwena inuwatui iba, “Yau nige natuguwao tatao sipapagani mwa kani esagu yayapanaisani vekune koina.” Na tomo meuloili vekune sikilala yo esa bwaite ‘Abisalomi’ siyogayoga-yan kana nuwatu-kalatan kaiwena kanasiga kabona. ");
INSERT INTO tteo_vpl VALUES ("S218_19","011_18_19","2SA","18","19","19","Kabo Aimasi, Seidoki natuna, iwalolau Yowabi koina iba, “Kutalamwagau na yalomwayamwayau wasa namwanamwana yalawani kin koina yakato Isileli tokaleyayao takaiwe-gabaegiliko yo Yeoba ala kin ileboi kana tokalomagigiliwo nimali mena.” ");
INSERT INTO tteo_vpl VALUES ("S218_20","011_18_20","2SA","18","20","20","Na Yowabi iwaloba, “Besi, tabu kulau kuyayawasa. Sauga yaboyoi kani wasa namwanamwana kuwalowen koina na kaliyate kabona tabu, kaiwena kin natuna iboitako.” ");
INSERT INTO tteo_vpl VALUES ("S218_21","011_18_21","2SA","18","21","21","Idiopiya gamena yabo koina iwaloba, “Kulau tawae tem ugitai kaleya koina kin ana wasa kuwolena.” Na Yowabi kana yakasisi kaiwena ipwalou kabo isagena ilau. ");
INSERT INTO tteo_vpl VALUES ("S218_22","011_18_22","2SA","18","22","22","Yo Aimasi iwalo samasamalulu Yowabi koina iwaloba, “Bwagana tawae tem iyawatagili koliyau nige tawae yabo bwai nuwanuwagumo kutalamwagau wasane yaolena kin koina.” Mwa Yowabi iwalo koina iba, “Natugu, tawae kaiwena nuwanuwam kulau? Nige wasa namwanamwana imiyamiya koliwo yo yakato kin maisam iyeyawa wasa bwaite kaiwena.” ");
INSERT INTO tteo_vpl VALUES ("S218_23","011_18_23","2SA","18","23","23","Kabo Aimasi iba, “Bwagana tawae tem iyawatagili na nuwanuwagumo yasagena yalau.” Kabo Yowabi iwaloba, “Kulau.” Mwa Aimasi imwayamwayau ilau ilusae kwabu mena yo game Idiopiya isagena-gabaeni ilau iyawatagili Manaim. ");
INSERT INTO tteo_vpl VALUES ("S218_24","011_18_24","2SA","18","24","24","Na Deibida imiyasio yanuwa kaba lusalusaena mena yo kaba yawayawatagili luwaluwalili mena imiyamiya. Tokabi-kevanai ilau isae gana ana kaba lusalusaena pwatana mena. Manna igabaen kabo tomo yabo igitai ibomamo isagena ilalaoma. ");
INSERT INTO tteo_vpl VALUES ("S218_25","011_18_25","2SA","18","25","25","Kabo iyogalau kin ana wasa iwolena. Mwa kin iba, “Tem ibomamo kani wasa namwanamwana bwaimwa ikakalaiyama.” Kabo tomone isagesagenama kikiunamo iyawatagilima. ");
INSERT INTO tteo_vpl VALUES ("S218_26","011_18_26","2SA","18","26","26","Yo tokabi-kevanai tomo yaboyoi igitai ilomwayamwayau ilalaoma. Yo iyogalau gamwa togite-kalatani koina iba, “Tomo yaboyoi bwaite ibomamo isagena ilalaoma.” Kabo kin iwaloba, “Iya tabe wasa namwanamwana ikakalaiyama.” ");
INSERT INTO tteo_vpl VALUES ("S218_27","011_18_27","2SA","18","27","27","Mwa tokabi-kevanai iwaloba, “Game bwaite ibagunama ana sagena yakilala besiele Aimasi, Seidoki natuna.” Yo kin iba, “Iya game namwanamwana mwa wasa namwanamwana ikakalaiyama.” ");
INSERT INTO tteo_vpl VALUES ("S218_28","011_18_28","2SA","18","28","28","Saugana Aimasi iyawatagili kabo iyoga kin koina iba, “Ginauli meuloina inamwanamwa.” Kabo manna ipei-lobiyeni bwatano mena kin kana koleya mena mwa iwaloba, “Yeoba am Yaubada tatobalan. Siya togamwa-panapanawa yagu guyau yo yagu kin koliwo Yeoba iya ipeili nimala mena yo takaiwe-gabaegili.” ");
INSERT INTO tteo_vpl VALUES ("S218_29","011_18_29","2SA","18","29","29","Kabo kin ineli iwaloba, “Na kilakaine Abisalomi inamwanamwa?” Kainana Aimasi iyamaisa iba, “Taubala, saugana Yowabi iyawasayau yalalaoma na talawauwau lalakina yabenalan na nige yakakatai tawae iyawatagili.” ");
INSERT INTO tteo_vpl VALUES ("S218_30","011_18_30","2SA","18","30","30","Kabo kin iwalo koina iwaloba, “Kutolowaya bwaine koina na kusanasana.” Mwa iginauli besiele ana walo. ");
INSERT INTO tteo_vpl VALUES ("S218_31","011_18_31","2SA","18","31","31","Mwa game Idiopiya iyawatagilima yo iwaloba, “Yagu guyau yo yagu kin, wasa namwanamwana kubenalan. Kabona Yeoba ileboiwo kam tokalomagigiliwo nimali mena.” ");
INSERT INTO tteo_vpl VALUES ("S218_32","011_18_32","2SA","18","32","32","Mwa kin ineli iba, “Na kilakaine Abisalomi inamwanamwa?” Kainana iyamaisa iwaloba, “Yagu guyau yo yagu kin, kilakaine Abisalomi isilae. Na temga kam kaleyayao yo siya sikalomagigi-lagiwo meuloili sisilae besiele kilakaine bwaite inamwanamwa.” ");
INSERT INTO tteo_vpl VALUES ("S218_33","011_18_33","2SA","18","33","33","Mwa kin nuwana inae lalakina mwa me ana valam ilau isae ana biliutusi mena kaba lusalusae pwatana mena ilolovalavalam iba, “O, natugu Abisalomi, natugu, natugu, Abisalomi. Tem kabona yau yaboita kowa tabu tabu. Abisalomi, natugu, natugu.” ");
INSERT INTO tteo_vpl VALUES ("S219_1","011_19_1","2SA","19","1","1","Yowabi ana wasa siwolena siba, “Kin Deibida nuwana inae Abisalomi kaiwena mwa ivalavalam.” ");
INSERT INTO tteo_vpl VALUES ("S219_2","011_19_2","2SA","19","2","2","Tokaleya meuloili wasa sibenalani kin inuwanae natuna kaiwena kabo kaliyatenane koina ali yaliyaya ibui iyamala nuwanae. ");
INSERT INTO tteo_vpl VALUES ("S219_3","011_19_3","2SA","19","3","3","Mwa silomwanoumo silusae yanuwa mena besiele tokaleya siya simwalimwaline kali koleya besiele siyabubu kaleya koina. ");
INSERT INTO tteo_vpl VALUES ("S219_4","011_19_4","2SA","19","4","4","Kabo kin manna ikausi na ivalavalam kainana ilalaki iba, “O, natugu Abisalomi, O Abisalomi, natugu, natugu.” ");
INSERT INTO tteo_vpl VALUES ("S219_5","011_19_5","2SA","19","5","5","Kabo Yowabi ilau kin ana nume mena yo iwalo koina, “Kaliyate kabona am tokaleya meuloili kuyamwalimwalineli siya mwa kowa menatumwao, wainemwao yawasosi yo wainemwao tupwaliyao yawasimiu sileboili. ");
INSERT INTO tteo_vpl VALUES ("S219_6","011_19_6","2SA","19","6","6","Kana koleya yakato siya sikalomagigi-lagiwo na kowa kumulomuloloili na siya simulomuloloiwo kowa ukalomagigi-lagili. Na mumugam kabona kuwalo-masala yakato tokaleyayao mekalikavao ali tobagunao siya besiele ginauli bwagabwaga koliwo. Mwa kani kabo yakatai temga kaliyate kabona Abisalomi nige iboboita yo kai meuloimai kaboita kani kuyaliyaya. ");
INSERT INTO tteo_vpl VALUES ("S219_7","011_19_7","2SA","19","7","7","Sauga bwaite koina kuyawatagili kulau am tokaleyayao kateli ukwabi-yakaiweli. Tem nigele kani boniyai nige tokaleya yabo imiyamiya koliwo, kani meuloili silogabae-giwo. Kabo polowe bwaite kani ilalakisosi koliwo kabo polowe meuloili siya kulobalobaili am sauga kilakai koina kanasiga sauga bwaite.” ");
INSERT INTO tteo_vpl VALUES ("S219_8a","011_19_8a","2SA","19","8a","8a","Kabo kin iyawatagili ilau imiyasio yanuwa ana kaba lusalusaena koina. Saugana ana tokaleyayao wasa sibenalani iya iyaele imiyasio kaba lusalusae koina mwa meuloili silau koina. ");
INSERT INTO tteo_vpl VALUES ("S219_8b","011_19_8b","2SA","19","8b","8b","Isileli ali tokaleya siya nige siboboita kaleya koina siyabubuko silau yanuwa uloina uloina kolili simiya. Na Deibida me ana tomoyao siyaele yanuwa Manaim koina nige naga Yolidani silopanaisi-yoima na silau Yelusalema. ");
INSERT INTO tteo_vpl VALUES ("S219_9","011_19_9","2SA","19","9","9","Na Yuda yo Isileli tomoliyao meuloili sibalabalamumu yo sigamwagamwa-pakiki siwaloba, “Kin Deibida iya mwa ileboila kala tokalomagigiliwo kolili. Tabe iya mwa Pilistiya nimali mena ileboila. Na sauga bwaite nige imiyamiya kolila, iya ilogabaegilako ilauko dedei yabo koina, Abisalomi imatausan mwa iyabubu. ");
INSERT INTO tteo_vpl VALUES ("S219_10","011_19_10","2SA","19","10","10","Tauna kona Abisalomi iya tagitesipwai ala kin iloina-yagila, na iya iboitako kaleya mena. Kabo gubesi na tamiya-mwanou nige taedeedede yo kin Deibida tagitesipwai yoi ipileyoima?” ");
INSERT INTO tteo_vpl VALUES ("S219_11","011_19_11","2SA","19","11","12","Kabo Deibida topwaoli Seidoki yo Ebayada walo iyawasa kolili yakato silau Yuda ali tautaubalao kolili na kainana siwaloweni siwaloba, “Tabu komiu Yuda kwaemala susu mwawamwawasina na kwalaoma kwasaguiyau na kwayoganyau tapileyoi yagu nume mena Yelusalema. Yawalo bwaite besiele kaiwena Isileli dedei meuloina tawae siwaloweni wasane yabenalanako. Kaiwena komiu totouguwao yaboma kwasinegu yo bulumagu yawasosi.” ");
INSERT INTO tteo_vpl VALUES ("S219_13","011_19_13","2SA","19","13","13","Besiele tabe Deibida iwalo silau Amasa koina siba, “Deibida iba kowa kuboma kwasinem yo bulumam tupwana. Kabona kani yapeiwo kuyamala yagu tokaleya ali tobaguna, Yowabi miyalaena. Tem nige yapepeiwo tobaguna yakawanoi Yeoba maisa polopolowe-sosina iginauli koliyau.” ");
INSERT INTO tteo_vpl VALUES ("S219_14","011_19_14","2SA","19","14","14","Mwa Yuda meuloili ali nuwatu kaigedamo besiele Deibida koina. Kabo me ali yaliyaya walo siyawasa siba, “Kupileyoima mekamkavao am tomoyao meuloili.” ");
INSERT INTO tteo_vpl VALUES ("S219_15","011_19_15","2SA","19","15","15","Kabo Deibida yo ana tomoyao sipileyoima kanasiga siyawatagili waila Yolidani. Na tomo Yuda siyawatagiliko Giligali na tem mekalikava kin sielobelobe waila Yolidani koina na sisagui ana lopanaisi kaiwena. ");
INSERT INTO tteo_vpl VALUES ("S219_16","011_19_16","2SA","19","16","16","Gela natuna Simei game Baulim ana susu Beniyamina itotoya mekanakavao tomo Yuda silau waila Yolidani kin Deibida sigitai. ");
INSERT INTO tteo_vpl VALUES ("S219_17","011_19_17","2SA","19","17","17","Kabo mekanakavao susu Beniyamina kali baibaiwa tausan kaigeda besiele tabe Siba, Saulo ana susu ali topaisowa mekanakavao natunao kali baibaiwa piptin (15) yo ana topaisowao kali baibaiwa tuwenti (20). Kabo sitotoya mwa silau siyawatagili waila Yolidani dedeina bwaimwa kin imiyamiya ikaikaiyawasi koina. ");
INSERT INTO tteo_vpl VALUES ("S219_18","011_19_18","2SA","19","18","18","Kabo bodane silopanaisi kaba lopanaisi mena silau sikatububu na tem kin mekanakavao ana nume kana tomoyao sisaguili ali lopanaisine kaiwena na tawae tem kin iwalowen kani siginauli. Saugana Simei Gela natuna ilopanaisi mwa italu-pwalou kin manna mena. ");
INSERT INTO tteo_vpl VALUES ("S219_19","011_19_19","2SA","19","19","19","Yo iwalo koina iba, “Yagu guyau yo yagu kin, kaliyatenane Yelusalema kulogabaen nae yaginauli koliwo. Yakawanoi yagu nae bwaite tabu kununuwatu-kalatani na kunuwatu-pwaiki. ");
INSERT INTO tteo_vpl VALUES ("S219_20","011_19_20","2SA","19","20","20","Yau am topaisowa yakatai yakato yalopwano kabo Isileli ali susu kaloli mena yau bwaite yalaoma baguna kaliyate kabona kowa te yau talolabin.” ");
INSERT INTO tteo_vpl VALUES ("S219_21","011_19_21","2SA","19","21","21","Kabo Seluwaiya natuna Abisai iwalo Deibida koina iba, “Temga Simei takoyamate ana nae maisana kaiwena kowa Yeoba ana gitesipwa tomona ikawa-naenae-yagiwo.” ");
INSERT INTO tteo_vpl VALUES ("S219_22","011_19_22","2SA","19","22","22","Mwa kainana Deibida iyamaisa iba, “Nige am dedei, yo nige am yai ipapagan na kuwalowalo besiele. Yakato ugamwapakiki koliyau? Nuwana nige ukwakatai kabona kani sipei-yapileyoi yau Isileli ali kin? Kabo gubesi? Yakato kaliyate kabona yawalo tomo yabo takoyamate Isileli kalona mena? Nigele.” ");
INSERT INTO tteo_vpl VALUES ("S219_23","011_19_23","2SA","19","23","23","Mwa ikawalulu yo iwaloyameli Simei koina iba, “Kani nige kuboboita.” ");
INSERT INTO tteo_vpl VALUES ("S219_24","011_19_24","2SA","19","24","24","Mepiboseti, Saulo tubuna, iya tabe ilau waila Yolidani kabo mekanakava kin silolabin kabo simulolo. Na saugana kin Yelusalema ilogabaen Mepiboseti ana nuwanae kaiwena mwa nige kaena idedeuli, me palasana yo nige ana kaleko idedeulili. ");
INSERT INTO tteo_vpl VALUES ("S219_25","011_19_25","2SA","19","25","25","Saugana ilaoma Yelusalema yo mekanakava kin simuloloili mwa kin ineli koina iba, “Mepiboseti, gubesi nige kulalaoma mekaukava kowa?” ");
INSERT INTO tteo_vpl VALUES ("S219_26","011_19_26","2SA","19","26","26","Kainana iyamaisa iba, “Yagu guyau yo yagu kin, ukwataiyau yau am topaisowa kaegu sinae nige sowasowagu yalokeikeile dudulai kabo yagu nuwatu yawaloba, ‘Yawalo yagu donki sikatububuni na yamwalisae mekaukava kin kalau’, na yagu topaisowa esana Siba imwakota-yagau. ");
INSERT INTO tteo_vpl VALUES ("S219_27","011_19_27","2SA","19","27","27","Kabo ilaowa yo wasagu ikawa-naenaeyani yagu guyau yo yagu kin koliwo. Na kowa besiele Yaubada ana anelose yabo, dudulai yo mwakota kali uloi ukwatai. Mwa tawae kunuwatui inamwanamwa uginauli. ");
INSERT INTO tteo_vpl VALUES ("S219_28","011_19_28","2SA","19","28","28","Yagu guyau yo yagu kin, kai Saulo tubunao meuloimai nige ama dudulai yabo ipapagan manim mena. Tem tauna kona am nuwatu besiele sowasowana ukoyamatemai, na nige ugiginauli. Na kowa kuwalo yau am topaisowa yakekakekanya am teibele mena. Na nige yagu namwanamwa ipapagan na yakawanoi yoi koliwo.” ");
INSERT INTO tteo_vpl VALUES ("S219_29","011_19_29","2SA","19","29","29","Mwa kin iwalo koina iba, “Besi edeedede. Yau yawaloba mekamkava Siba tubum ana bwatano kwayakasali.” ");
INSERT INTO tteo_vpl VALUES ("S219_30","011_19_30","2SA","19","30","30","Kabo Mepiboseti iba, “Na meuloina kutalamwani ikalai. Yau yayaliyayamo koliwo kaiwena kupileyoima me am namwanamwa.” ");
INSERT INTO tteo_vpl VALUES ("S219_31","011_19_31","2SA","19","31","31","Na Basilai iya dedei Giliyadi tomona ilaomaya yanuwa Logelim ilau waila Yolidani yakato iya tabe kin me ana bodao isaguili ali lopanaisi koina. ");
INSERT INTO tteo_vpl VALUES ("S219_32","011_19_32","2SA","19","32","32","Iya itautaubalako ana bolime kana lalaki eiti (80). Iya towasawasa yawasosi yo tauna kona Deibida me ana boda igite-kalatagili saugana simiyamiya Manaim. ");
INSERT INTO tteo_vpl VALUES ("S219_33","011_19_33","2SA","19","33","33","Kabo kin iwalo Basilai koina iba, “Kowa mekaukava talopanaisi kani kumiyamiya koliyau Yelusalema na yagite-kalatagiwo.” ");
INSERT INTO tteo_vpl VALUES ("S219_34","011_19_34","2SA","19","34","34","Na kainana Basilai iyamaisa iba, “Tabu, kaiwena yatautaubalako kani nige sauga imamamalawe na yaboita. Nige kana dudulai yabo na yalaowa talau Yelusalema. ");
INSERT INTO tteo_vpl VALUES ("S219_35","011_19_35","2SA","19","35","35","Yagu bolime eiti ilobaiyako yo nige sowasowana kamna namwanamwana yo kamna naenaena kali uloi yakatai. Mwa nige sowasowagu tawae yakan yo tawae yanuma kamnali yalotonani. Nige sowana towali kainali yabenalani. Mwa tabu yalalaowa na iyamala polowe yagu guyau yo yagu kin, koliwo. ");
INSERT INTO tteo_vpl VALUES ("S219_36","011_19_36","2SA","19","36","36","Mekaukava kowa waila Yolidani talopanaisani yo kikiuna tabe talokeikeile. Na tabu mulolone ugiginauli besiele tawae kuwaloweni. ");
INSERT INTO tteo_vpl VALUES ("S219_37","011_19_37","2SA","19","37","37","Na kutalamwagau yapileyoi kabo yaboita yagu yanuwa mena yo sipeiyau tamagu yo sinagu kali salai salina mena. Kabo yagu guyau yo yagu kin, natugu Kimam bwaite, mekamkava kwalau kabo tawae kunuwatui idudulai na uginauli koina.” ");
INSERT INTO tteo_vpl VALUES ("S219_38","011_19_38","2SA","19","38","38","Kabo kin iwaloba, “Inamwanamwa Kimam ilaoma mekaukava na namwanamwa bwaite kaginauli koina besiele am nuwatu. Yo tawae tem ukawanoi-yan koliyau yapaisowai kaiwem.” ");
INSERT INTO tteo_vpl VALUES ("S219_39","011_19_39","2SA","19","39","39","Mwa tomo meuloili waila Yolidan silopanaisi yo tabe Deibida ilopanaisi. Muli mena Deibida Basilai inisoi yo ikawanoi Yeoba imuloloi yo Basilai ipileyoi ana yanuwa mena. ");
INSERT INTO tteo_vpl VALUES ("S219_40","011_19_40","2SA","19","40","40","Kabo kin mekanakava Kimam silau yanuwa Giligali. Na susu Yuda meuloili yo Isileli ali susu tupwali mekalikava kin Deibida silopanaisi waila Yolidani yo sigite-kalatani ana kamwasa mena. ");
INSERT INTO tteo_vpl VALUES ("S219_41","011_19_41","2SA","19","41","41","Mwa Isileli tataoliyao meuloili silaulau kin koina yo siwaloba, “Tawae kaiwena kamakavao Yuda tataoliyao nige ama wasa siyeyeyama na kamakavao kayalopanaisagili? Na silowadam yo menatumwao yo am tokaleyayao meuloili siyalopanaisagimiu waila Yolidani.” ");
INSERT INTO tteo_vpl VALUES ("S219_42","011_19_42","2SA","19","42","42","Kabo Yuda tataoliyao Isileli ali balamumu siyamaisa siba, “Kaginauli besiele bwaite kaiwena iya ama susu tomona. Na gubesi mwa walone kaiwena kwamunamunai? Nuwana kin kani kan iyauyauyan kolimai na kakekakekan? Nigele. Nuwana wasawasa tupwana kakalai kaiwemai? Nigele.” ");
INSERT INTO tteo_vpl VALUES ("S219_43","011_19_43","2SA","19","43","43","Mwa kainali Isileli tataoliyao siyamaisa siba, “Yakato komiu mwa ami kin Deibida yo kai nigele? Kai ama susu kali baibaiwa sanaulu (10) na komiu susu kaigedamo. Kabo kai ama dudulai ilalakisosi kabo komiu ami dudulai. Gubesi na wagite-lobi-yegimai yo ginauli bwaite waginauli kolimai? Kai mwa kawalo baguna ala kin tayapileyoi-yama.” Na Yuda me ali walo kaiwe Isileli kainali ikaiwe-gabaen. ");
INSERT INTO tteo_vpl VALUES ("S220_23","011_20_23","2SA","20","23","23","Yowabi iya Isileli ali tokaleya meuloili ali tobaguna. Yeoyada natuna Benaiya iya boda Keleti yo boda Peleti ali tobaguna. ");
INSERT INTO tteo_vpl VALUES ("S220_24","011_20_24","2SA","20","24","24","Adonilam iya topaisowa panpanna iloiloina-yagili. Ailudi natuna Yeosapati iya kin ana loinao kana togite-kalatan. ");
INSERT INTO tteo_vpl VALUES ("S220_25","011_20_25","2SA","20","25","25","Seva iya tolelelele. Seidoki yo Ebayada siya topwaoli. ");
INSERT INTO tteo_vpl VALUES ("S220_26","011_20_26","2SA","20","26","26","Na Ila iya Yaila gamena iya Deibida ana topwaoli yabo. ");
INSERT INTO tteo_vpl VALUES ("S221_1","011_21_1","2SA","21","1","1","Deibida ana sauga kin kalona mena guliyam lalakina iyawatagili imiyamiya bolime yaiyona. Kabo Deibida ikawakawanoi Yeoba koina polowene kaiwena. Mwa Yeoba iwalo koina iba, “Bwaite iyawatagili kaiwena beyabeyana Saulo boda Gibiyon iunuyamateli nuwanuwana iyemwawasili kabo Saulo metubunao nimaliyao sikwasine.” ");
INSERT INTO tteo_vpl VALUES ("S222_1","011_22_1","2SA","22","1","1","Saugana Yeoba Deibida ileboi kana tokalomagigiliwo nimali mena yo Saulo nimana mena kabo wali bwaite iwaliyani Yeoba koina. Iwalo bwaite besiele iba, ");
INSERT INTO tteo_vpl VALUES ("S222_2","011_22_2","2SA","22","2","2","“Yeoba iya besiele yagu veku miyamiya saena, yagu kaba keno-wadam yo iya ileboiyau polowene koina. ");
INSERT INTO tteo_vpl VALUES ("S222_3","011_22_3","2SA","22","3","3","Yagu Yaubada iya besiele yagu veku yo kagu totolo-kaukausi, yagu ebeu yo iya kagu tolebo kaikaiwena. Iya yagu nume kaikaiwena, yagu kaba yabubu yo kagu tolebo, iya ileboiyau kagu kaleyayao kolili. ");
INSERT INTO tteo_vpl VALUES ("S222_4","011_22_4","2SA","22","4","4","Yayogasaeko Yeoba koina iya esana yatobalani kabo ileboiyau kagu tokalomagigiliwo kolili. ");
INSERT INTO tteo_vpl VALUES ("S222_5","011_22_5","2SA","22","5","5","Boita besiele dibwali igolu pwatagu mena yo silae bagoluna iyaluwagau. ");
INSERT INTO tteo_vpl VALUES ("S222_6","011_22_6","2SA","22","6","6","Bwebweso besiele maina ipanyau yo boita besiele sipwasipwa yabo ikabi-kalatagau. ");
INSERT INTO tteo_vpl VALUES ("S222_7","011_22_7","2SA","22","7","7","Yagu miya naenaena koina yayogasae Yeoba koina, yayoga yagu Yaubada koina. Kabo kainagu ibenalani ana nume yakayakasisina koina yo yagu valam sagu kaiwena ibenalanako. ");
INSERT INTO tteo_vpl VALUES ("S222_8","011_22_8","2SA","22","8","8","Kabo yanuwa yaulina itabutabubu yo inukui yo bulibuli kana wauwau itabutabubu kaiwena Yeoba imunamunai. ");
INSERT INTO tteo_vpl VALUES ("S222_9","011_22_9","2SA","22","9","9","Kabo bogau iyawatagilima isuna mena yo mayau memenana iyawatagilima gamwana mena yo gibwala wedowedolina isuwe-lobiyenama. ");
INSERT INTO tteo_vpl VALUES ("S222_10","011_22_10","2SA","22","10","10","Bulibuli iigali kabo ilobima yo yaloyaloi dubadubana kaena yaulina mena. ");
INSERT INTO tteo_vpl VALUES ("S222_11","011_22_11","2SA","22","11","11","Imwalisae anelose yabo koina yo isagenama yo ieva besiele igayagayai sivesiveve koina. ");
INSERT INTO tteo_vpl VALUES ("S222_12","011_22_12","2SA","22","12","12","Kwapina isuma boniboniyai koina yo yaloyaloi balubaluli simiya-takikilani. ");
INSERT INTO tteo_vpl VALUES ("S222_13","011_22_13","2SA","22","13","13","Mayale lalakina itunsae manna mena yo pigabu ipigapigabu-yawatagilima koina. ");
INSERT INTO tteo_vpl VALUES ("S222_14","011_22_14","2SA","22","14","14","Kabo Yeoba Tomiyasaesosi iya mwa iwalowalo yo kainana besiele tutu ilobimaya bulibuli mena. ");
INSERT INTO tteo_vpl VALUES ("S222_15","011_22_15","2SA","22","15","15","Pigabu besiele gipoyo igabaegilima mwa kana tokalomagigiliwo meuloili nuwali iula-pwanopwano na siyabubu. ");
INSERT INTO tteo_vpl VALUES ("S222_16","011_22_16","2SA","22","16","16","Kalita iguma kepakepa yo yanuwa yaulina kana wauwau imayale sowasowana tagitai kaiwena Yeoba iwalo kaleya yo ana munamunai koina kana tokalomagigiliwo iwalo-kausili yo iyokoi-yagili. ");
INSERT INTO tteo_vpl VALUES ("S222_17","011_22_17","2SA","22","17","17","Nimana iyaga-lobiyenama kewa mena yo ikabi-kalatagau kabo itabe-seyagau yalubwasi kaikaiwena koina. ");
INSERT INTO tteo_vpl VALUES ("S222_18","011_22_18","2SA","22","18","18","Ileboiyau tokalomagigiliwo kaikaiweli kolili siya simunamunai koliyau yo sikaiwesosi kabo yau. ");
INSERT INTO tteo_vpl VALUES ("S222_19","011_22_19","2SA","22","19","19","Simiya-kausiyau yamiyamiya nae kalona mena na Yeoba iya isaguiyau. ");
INSERT INTO tteo_vpl VALUES ("S222_20","011_22_20","2SA","22","20","20","Kaba silae mena ileboiyau yo ipeiyau dedei namwanamwana koina kaiwena iyaliyaya kaiwegu. ");
INSERT INTO tteo_vpl VALUES ("S222_21","011_22_21","2SA","22","21","21","Yeoba ana paisowa koliyau inamwanamwasosi kaiwena yagu paisowa idudulai kabo mulolo iyeyama kaiwena nige ginauli yabo naenaena yapapaisowai nimagu mena. ");
INSERT INTO tteo_vpl VALUES ("S222_22","011_22_22","2SA","22","22","22","Na Yeoba ana kamwasa yamuliya yo nige sowana yagu Yaubada yalogabaen. ");
INSERT INTO tteo_vpl VALUES ("S222_23","011_22_23","2SA","22","23","23","Ana loina meuloina yanuwatu-kalatagili yo ana walo nige yalologabaegili. ");
INSERT INTO tteo_vpl VALUES ("S222_24","011_22_24","2SA","22","24","24","Manna mena nige lopwano yabo imiyamiya koliyau yo yagite-kalatagau tabu nae yagiginauli. ");
INSERT INTO tteo_vpl VALUES ("S222_25","011_22_25","2SA","22","25","25","Yeoba iwalo-muloloiyau kaiwena yagu paisowa idudulai yo nige nae yabo yagiginauli manna mena. ");
INSERT INTO tteo_vpl VALUES ("S222_26","011_22_26","2SA","22","26","26","Siya am walo sisanapuwani ukwate-kamkamna-yagili yo siya nige nae kulolobaili kolili, nige nae yabo ugiginauli kolili. ");
INSERT INTO tteo_vpl VALUES ("S222_27","011_22_27","2SA","22","27","27","Siya ali paisowa idudulai kowa mumugam idudulai kolili na siya toyauyaule kowa kupei-suwalagili koliwo. ");
INSERT INTO tteo_vpl VALUES ("S222_28","011_22_28","2SA","22","28","28","Siya sinuwalobi kuleboili na siya sigagasa kupei-yataluli. ");
INSERT INTO tteo_vpl VALUES ("S222_29","011_22_29","2SA","22","29","29","O Yeoba, kowa besiele yagu odam kabo yagu boniboniyai kuyamayale. ");
INSERT INTO tteo_vpl VALUES ("S222_30","011_22_30","2SA","22","30","30","Am sagu koliyau sowasowana kaiwe kuyeyama koliyau na kau kaleya bodaliyao yaunuili. Am kaiwe koina sowasowagu yanuwa kana gana yavinae-likwai. ");
INSERT INTO tteo_vpl VALUES ("S222_31","011_22_31","2SA","22","31","31","Yaubada iya mumugana meuloina inamwanamwa. Yeoba ana walo iyamala yawasosi yo iya besiele ebeu siya siyabubu yo sikeno-wadam koina. ");
INSERT INTO tteo_vpl VALUES ("S222_32","011_22_32","2SA","22","32","32","Nige Yaubada yabo besiele iya Yeoba yo iya ala veku kaikaiwena. ");
INSERT INTO tteo_vpl VALUES ("S222_33","011_22_33","2SA","22","33","33","Yagu Yaubada iya ikabi-yakaiwe-yagau yo yagu kamwasa igite-kalatan. ");
INSERT INTO tteo_vpl VALUES ("S222_34","011_22_34","2SA","22","34","34","Isaguiyau kaegu yapei-yadudulai mala naenaena kolili besiele diya na isaguiyau yavinae yasae yatolo koya pwatana mena. ");
INSERT INTO tteo_vpl VALUES ("S222_35","011_22_35","2SA","22","35","35","Kaleya kana kamwasa iyakenayagau, ikabi-yakaiweyau kabo sowasowagu gipoyo yamomosi yo wamalina yaulani. ");
INSERT INTO tteo_vpl VALUES ("S222_36","011_22_36","2SA","22","36","36","Am leboyau iyamala yagu ebeu yo am sagu koliyau ilalaki kabo me yagu kaiwe. ");
INSERT INTO tteo_vpl VALUES ("S222_37","011_22_37","2SA","22","37","37","Yagu kamwasa kusoke-yalalaki mangu mena na yalodudulai nige sowasowana kaegu yayatupan. ");
INSERT INTO tteo_vpl VALUES ("S222_38","011_22_38","2SA","22","38","38","Kagu tokalomagigili yatawoili yakaiwe-gabaegili yo nige yalolopei kanasiga yaemwawasili. ");
INSERT INTO tteo_vpl VALUES ("S222_39","011_22_39","2SA","22","39","39","Yakoyabekuli nige sowasowali sitolo na simiyamiya kaegu yaulina mena. ");
INSERT INTO tteo_vpl VALUES ("S222_40","011_22_40","2SA","22","40","40","Ukabi-yakaiweyauko kaleya kaiwena yo tokalomagigiliwo kuyoganli sipwalou kaegu mena. ");
INSERT INTO tteo_vpl VALUES ("S222_41","011_22_41","2SA","22","41","41","Kagu tokalomagigiliwo am kaiwe sigitai kabo siyabubu mangu mena yo siya sikalomagigi-lagau yasibayanaeli. ");
INSERT INTO tteo_vpl VALUES ("S222_42","011_22_42","2SA","22","42","42","Sagu kaiwena siyoga na nige yabo sowasowana ileboili. Siyoga Yeoba koliwo na nige kusasaguili. ");
INSERT INTO tteo_vpl VALUES ("S222_43","011_22_43","2SA","22","43","43","Yakaiwe-gabaegili kabo siya besiele bwatano kauna. Yatabe-yataluli besiele bwalabwala kamwasa mena. ");
INSERT INTO tteo_vpl VALUES ("S222_44","011_22_44","2SA","22","44","44","Siya yagu tomoyao sigamwapanapanawa nuwanuwali siunuiyau kuleboiyauko kolili, ugite-kalatagau na yaemala boda meuloili ali tobaguna. Na tomo siya beyabeyana nige yakakataili sauga bwaite simiyamiya yagu loina yaulina mena. ");
INSERT INTO tteo_vpl VALUES ("S222_45","011_22_45","2SA","22","45","45","Tolaolaoma me ali matausi sipwalou koliyau, na tem yaedeedede kolili yagu loina simuliya. ");
INSERT INTO tteo_vpl VALUES ("S222_46","011_22_46","2SA","22","46","46","Ali katepatu imwawasi mwa ali nume kaikaiweli silogabaegili, me ali tabubu silaoma koliyau. ");
INSERT INTO tteo_vpl VALUES ("S222_47","011_22_47","2SA","22","47","47","Yeoba imiyayai kabo iya kagu totolo-kaukausi tatobalani. Yagu Yaubada iya veku kaba lebo esana takeleisinan. ");
INSERT INTO tteo_vpl VALUES ("S222_48","011_22_48","2SA","22","48","48","Siya siginauli naenaena koliyau Yeoba iyamaisali kolili yo boda uloili ipeili yagu loina yaulina mena. ");
INSERT INTO tteo_vpl VALUES ("S222_49","011_22_49","2SA","22","49","49","Yo ileboiyau kagu tokalomagigiliwo kolili. O Yeoba, ukwalaiyau siya sikalekaleya koliyau nimali mena, yo kuleboiyau topaisowa naenaeli kolili. ");
INSERT INTO tteo_vpl VALUES ("S222_50","011_22_50","2SA","22","50","50","Koinaele yatobalanagiwo boda uloili kaloli mena yo esam kana tobali yawaliyani. ");
INSERT INTO tteo_vpl VALUES ("S222_51","011_22_51","2SA","22","51","51","Yau Yeoba ana kin kabo isaguiyau na kagu tokalomagigiliwo yaemwawasili yawasosi. Mwa ana katekamkamna imiyamiya ana gitesipwa tomonna yau Deibida koliyau yo tubuguwao kolili nige ana kaba mwawasi.” ");
INSERT INTO tteo_vpl VALUES ("S223_1","011_23_1","2SA","23","1","1","Tomiyasaesosi kaba miya lalakina iwolena Deibida Yese natuna koina. Yakobo ana Yaubada igitesipwai iyamala kin yo iya Isileli ali wali namwanamwali kali tobuibui. Na ana walo mwawamwawasina iyaele bwaite besiele. ");
INSERT INTO tteo_vpl VALUES ("S223_2","011_23_2","2SA","23","2","2","“Yeoba yaluyaluwana ana walo iwalowen koliyau kabo ana edeedede koliyau kani yawalo-masalan tomo kolili. ");
INSERT INTO tteo_vpl VALUES ("S223_3","011_23_3","2SA","23","3","3","Isileli ala Yaubada iya ala veku iwaloma koliyau iba, ‘Tem toloina yabo iloina me ana paisowa dudulaina, yo tem Yaubada kana matausi imiyamiya koina saugana tomo ibagunayagili, ");
INSERT INTO tteo_vpl VALUES ("S223_4","011_23_4","2SA","23","4","4","kabo iya besiele dabwelo mansinosinona saugana imwalisae malala mena, nige yaloyaloi yabo ipepei kausi. Iya besiele dabwelo ana lala galewa mulina mena lalane kawasi ana kin bwatano mena iyatubu.’ ");
INSERT INTO tteo_vpl VALUES ("S223_5","011_23_5","2SA","23","5","5","Na bwaine besiele yau me tubuguwao kani Yaubada iwalo-muloloimai. Mwa ana kelabilabin kamwasana kolimai imiyayai, iya bwaite ikawa-yawasosiyan. Nige sowasowana ibui yo itautusi imiyayai. Bwaite iya yau kaba yaliyaya yo yakatai kani iyawatagili besiele ana waloyameli. ");
INSERT INTO tteo_vpl VALUES ("S223_6","011_23_6","2SA","23","6","6","Na tomo naenaeli isibayanaeli besiele samasamali sakosakonana tatom-gabaegili, siya nige sowasowana nimala mena takabi-kalatani. ");
INSERT INTO tteo_vpl VALUES ("S223_7","011_23_7","2SA","23","7","7","Nige sowasowana tapei-gogonagili, nigele. Na kaba paisowa aeyan wedowedolina koina sowasowana tagabuli siwedoli ali dedei mena.” ");
INSERT INTO tteo_vpl VALUES ("S224_25","011_24_25","2SA","24","25","25","Kabo Deibida kaba pwaoli ikabi yo bulumakau tupwali ipwaoli-yagili igabu wolili yo tupwali ipwaoli-yagili yakato siya lolabin pwaolina. Mwa tomo ali kawakawanoi ali dedei kaiwena Yeoba ibenalagili kabo kasiebwa naenaena dedei Isileli koina imwawasi. ");
INSERT INTO tteo_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Tomone iya tonaenaeli ali loina isikotanagili yo tolopwanoli ali kamwasa nige imumuliya, yo nige itutubwe Yaubada kana tokalomagigiliwo kolili Yaubada iwalo-muloloi. ");
INSERT INTO tteo_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Na Yeoba ana loina koina imiyamiya me ana yaliyaya, yo ana loina koina inuwanuwatu kaliyate yo boniyai. ");
INSERT INTO tteo_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Iya besiele mayau sikumai yalubwasi dedeina mena, na ana uwene mekana sauga, yo ligunao nige sowasowana siweweka. Na tomone iya tawae nuwanuwana ipaisowai ana paisowa meuloina inamwanamwasosi. ");
INSERT INTO tteo_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Na tonaenaeli nige besiele, siya besiele witi kwapina yaumai iyuiyui-kalakalai. ");
INSERT INTO tteo_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Mwa koina siya tonaenaeli yatala koina kani loina polopolowena silobai, yo siyakasali tonamwanamwali kolili. ");
INSERT INTO tteo_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Kaiwena Yeoba todudulaiwo ali kamwasa iyakenayagili. Na tonaenaeli silalau kamwasa kaba boita koina. ");
INSERT INTO tteo_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Tawae kaiwena dedei uloili tomonliyao simunamunai yo sikalekaleya Yaubada koina? Kani nige sowasowali sikaiwe-gabaen. ");
INSERT INTO tteo_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Yanuwa yaulina kana kinyao simiya-gogo yo siloiloina toyawa yakato sikaleya Yeoba yo ana gitesipwa tomona kolili siwaloba, ");
INSERT INTO tteo_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","“Kala pan tatom-utusi, ali loina kolila takele-gabaen.” ");
INSERT INTO tteo_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Na Yeoba, iya imiyasio bulibuli mena imalumalu yo italatalawasi-yagili. ");
INSERT INTO tteo_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Me ana munamunai lalakina kani iwalolau kolili iyadidigali na iula-matamatausagili iwaloba, ");
INSERT INTO tteo_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","“Yagu kin yapeiyako Saiyon, bwaimwa yagu koya yakayakasisina koina.” ");
INSERT INTO tteo_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Kin iwaloba, “Yeoba ana loina kaiwena kani yawalo-masalan kolimiu. Iwalo koliyau iba, ‘Kabona yau Tamam yo kowa natugu. ");
INSERT INTO tteo_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Ukawanoi koliyau na kaba loina meuloina yaeliwa, na yanuwa yaulina dedeina meuloina yaeliwa iyamala am gogo. ");
INSERT INTO tteo_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Besiele pwawati ukoiyan gulewa koina na itata-gaoli kani kaba loina ukogaogaolili, imwawasi kani uko-mumumumuli besiele gulewa tasapi-mumumumuli.’” ");
INSERT INTO tteo_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Kabo komiu kinyao, yanuwapei bwaite kwabenali-kalatan na me ami nuwa-mayale. ");
INSERT INTO tteo_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Kabo Yeoba koina kwapaisowa me ami matausi, yo me ami tabubu ");
INSERT INTO tteo_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","kaena kwanisoi, kisimo ana munamunai imwayamwayau besiele mayau iwedoli na koina isibayanaemiu. Siya analiyao sisagena koina na sikaiyawasi, iwalo-muloloili. ");
INSERT INTO tteo_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","O Yeoba, siya kagu tokaleyayao sibaibaiwasosi sikalekaleya koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Meuloili siedeedede kaiwegu siba, “Nige sagu yabo Yaubada koina iya kaiwena.” ");
INSERT INTO tteo_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Na kowa Yeoba kagu totolo-kaukausi besiele yagu ebeu, kowa yagu wasawasa, yo kowa kagu tokabi-yakaiwe. ");
INSERT INTO tteo_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Yeoba koina yayoga kainagu lalakina mena na ana koya yakayakasisina koina kainagu iyamaisayama. ");
INSERT INTO tteo_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Me yagu nuwadaumwali yakenomate yo kenokeno mena yatoloma kaiwena yakatai Yeoba igitegite-kalatagau. ");
INSERT INTO tteo_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Kagu tokalomagigiliwo sibaibaiwasosi na bwagana meuloili siyatakikilagau na iyamo nige yamamatausi. ");
INSERT INTO tteo_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Yeoba kowa yagu Yaubada kutolo na kuleboyau kaiwena kowa kagu tokaleyayao meuloili kunuunuili papaliliyao mena yo kowa tonaenaeli mwakali ukokogolugoluli. ");
INSERT INTO tteo_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Lebo kowa Yeoba am gogo, am walo-mulolo imiyamiya am tomoyao meuloili kolili. ");
INSERT INTO tteo_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","O Yaubada, kowa kagu totolo-kaukausi, saugana polowe yalobai kusaguiyau. Kabo sauga bwaite koina ukwate-kamkamna-yagau na yau kawanoi kubenalan yo kuyamaisa. ");
INSERT INTO tteo_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Komiu tomo lalakili, toweya kana mamalawe besiele kani wakalomagigi-lagau yo kwasinasinaliyau. Toweya kana mamalawe besiele kani kwamulolo walo bwagabwaga yo walo gagasa kolili na mwakota mumugana kwaloyaloyai. ");
INSERT INTO tteo_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Na iyamo nuwanuwagu wakatai yakato Yeoba ana tomoyao yakayakasisili ipei-suwalagili ibomamo kaiwena yo saugana yayoga koina kainagu ibenalan. ");
INSERT INTO tteo_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Tem kwamunamunai tabu munamunaine ikakalaimiu naenaena koina. Saugana tem wakaiyawasi ami kaba keno kolili kwamiya-mwanou yo kwanuwanuwatu katemiu mena me ami nuwadaumwali. ");
INSERT INTO tteo_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Pwaoli namwanamwali kwapwaoliyan Yeoba koina yo ami meli kwapei koina. ");
INSERT INTO tteo_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Tomo sibaibaiwa sikawanoi siwaloba, “O Yeoba, am mulolo kolimai ukwabi-yalalaki yoi yo mayalem kuyakenayagimai.” ");
INSERT INTO tteo_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Na bwagana ali kelikeli kanna ikalapowon masumasuwe na iyamo yaliyayane kuyeyama kategu mena ilalakisosi kabo muli mena siya ali kelikeli kanna kana yaliyaya kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","O Yeoba, me yagu nuwadaumwali yaguli-talu na yakeno kaiwena kowa kubomamo ugite-kalatagau mwa yamiya namwanamwa. ");
INSERT INTO tteo_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","O Yeoba, yagu kawanoi yo yagu yaba kubenalagili. ");
INSERT INTO tteo_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Yagu kawanoi ilaowa kowa koliwo, yagu kin yo yagu Yaubada, tenam kuyawali na yagu valam sagu kaiwena kubenalan. ");
INSERT INTO tteo_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Malala kaigeda kaigeda kainagu kubenabenalan yo yau kawanoi iyamala yagu pwaoli koliwo yo yasanasana am yamaisa kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Kaiwena kowa Yaubada nige kuyayaliyaya naenaena kaiwena. Nige kutatalam naenaena imiyamiya salim mena. ");
INSERT INTO tteo_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Togagasa nige sowasowana sitolo manim mena yo tonaenaeli ukalomagigi-lagili. ");
INSERT INTO tteo_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Siya towalo-mwakomwakota kuunuyamateli kaiwena kowa Yeoba tonaenaeli yo tounuyamate kusikotanagili. ");
INSERT INTO tteo_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Na yau, am mulolo miyamiya yaina yo am katekamkamna mena yalaoma am nume mena. Matausim koina yapwalou am nume tabu manna mena. ");
INSERT INTO tteo_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","O Yeoba, mumugam dudulaina koina kuyabaguna-yagau kaiwena yamatausi kau kaleyayao kolili. Am kamwasa kuyasapusapuli mangu mena. ");
INSERT INTO tteo_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Nige yabo walo yawasosi gamwali mena, kateli kaba boita yo galogaloli besiele salai sokesokena yo memenali ali kaba walo momone. ");
INSERT INTO tteo_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","O Yaubada, kuyamaisali kamkamna koina yo tawae naenaena sinuwanuwatuine koina kuyabekuli. Ali loinalikwa kaiwena yo ali gamwapanapanawa koliwo kaiwena kutawoili manim mena. ");
INSERT INTO tteo_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Na siya analiyao koliwo sikeno-wadam na sikaiyawasi kani siyaliyaya yo siwaliwali nige ana kaba mwawasi. Siya simulolo koliwo kutolo-kaukausili na mesabana esam sitobalan. ");
INSERT INTO tteo_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Kaiwena kowa Yeoba todudulai kuwalo-muloloili yo namwanamwa koina kusumali besiele ebeu tomo koina ikokaukausi. ");
INSERT INTO tteo_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","O Yeoba, tabu am munamunai koina kuyoyokoi-yagau yo kuyayamaisayau. ");
INSERT INTO tteo_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Na ukwate-kamkamna-yagau kaiwena yogu ibelubelu. Kuwoisiyau kaiwena tuwatuwagu kamnali sinae. ");
INSERT INTO tteo_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Yaluyaluwagu ana kaiwe imwawasi. Na kowa Yeoba tawanesana kani yagu kawanoi kubenalan na kuwoisiyau? ");
INSERT INTO tteo_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","O Yeoba, am munamunai koina kulopei na yawasigu kulebo kaiwena am mulolo imiyayai. ");
INSERT INTO tteo_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Boita dedeina koina nige yabo ikakataiwo yo nige sowasowana yabo itobalanagiwo. ");
INSERT INTO tteo_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Yagu yaba koina kamnagu inae, boniyai kaigeda kaigeda kolili matalilogu koina yau kaba keno yo kagu kulule sibuta besiele yalubwasi ana didi. ");
INSERT INTO tteo_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Valam koina mangu silolo kaiwena kagu tokalomagigiliwo meuloili siula-matamatausagau. ");
INSERT INTO tteo_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Meuloimiu mumugana naenaena kwapaipaisowai kwalowasi koliyau kaiwena Guyau yagu valam ibenalanako. ");
INSERT INTO tteo_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Yeoba yagu valam sagu kaiwena ibenalanako kabo kainagu kani iyamaisa. ");
INSERT INTO tteo_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Kagu tokalomagigiliwo meuloili kani simwalimwaline yo kateliyao matausi koina sikalapowon kaiwena Yeoba kani itabe-keileli me ali nuwapwanopwano. ");
INSERT INTO tteo_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","O Yeoba yagu Yaubada, koliwo yakeno-wadam yakaiyawasi. Kuleboyau kagu kaleyayaone siya siyamuli-kusuliyau kolili. ");
INSERT INTO tteo_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Kisimo yogu sitabe-igaigali besiele laiyon ana paisowa, na sitabe-niuniuliyau yakwalalele kaiwena nige kagu tosagu yabo. ");
INSERT INTO tteo_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","O Yeoba yagu Yaubada, tem mumugana naenaena yabo yapaisowaiyako nimagu mena, ");
INSERT INTO tteo_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","o tem yagu eliyam nuwana yasibayanae, tem kagu tokalomagigili yabo yaunui na nige yaina ipapagan, ");
INSERT INTO tteo_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","ee kabo ilonamwayagau kau kaleyayao siyamuli-kusuliyau silaoma sikabi-kalatagau siutu-gwalagwalaiyau bwatano mena yo yaluyaluwagu ikenokeno kau mena. ");
INSERT INTO tteo_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","O Yeoba, kutolo me am munamunai na kagu tokalomagigiliwo ukaiwe-gabaegili na ali munamunai kuyamwanou. Kubomayoi kuyanoiwo na kusaguiyau kaiwena kowa yatala kana sauga kuloinayanako. ");
INSERT INTO tteo_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Kuwalo tomo meuloili silogogoma na simiya-takikilagiwo na kumiyasio kewa mena na kuloinayagili. ");
INSERT INTO tteo_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Kabo kowa Yeoba, tomo kali toyatala, me am loina dudulaina mena kuyatalayagau kaiwena mumugagu namwanamwana koliyau imiyamiya ukwataiyako. ");
INSERT INTO tteo_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Toyauyaule ali naenaena kutalam na simwawasi, na todudulai ukwabi-yakaiweli kaiwena kowa Yaubada mumugam idudulaisosi kabo sowasowam tomo kateli kutonagili. ");
INSERT INTO tteo_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Yaubada iya kagu totolo-kaukausi, siya mumugali sidudulai yo siobiga ileboili. ");
INSERT INTO tteo_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Iya toyatala dudulaina yo sauga meuloina tonaenaeli iyamaisali. ");
INSERT INTO tteo_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Tem tomo nige sinunuwabui Yaubada kani ana kaleya kelepana ivakili, ana gipoyo imomosiyako. ");
INSERT INTO tteo_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Kaleya kaba boita gogoliyao ikatububunagiliko yo mayau kala-pulupulululi ipeiliko ana pwawati manli mena. ");
INSERT INTO tteo_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Wagitai, tonaenaena inuwanuwatu mumugana naenaena kana paisowa kaiwena yo naenaenane isiumayan yo walo mwakomwakota ikabiyan. ");
INSERT INTO tteo_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Bwatano ikeli isala na gula ipaisowai tomo namwanamwaliyao kaiweli na iyamo ibomayoi koina ibeku. ");
INSERT INTO tteo_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Ana naenaena ipileyoima ibomayoi iunui yo ibomayoi ana munamunai koina isilae. ");
INSERT INTO tteo_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Kabo yakawatoki Yeoba Tomiyasaesosi koina mumugana dudulaina kaiwena, yo esana koina kani yawali tobali. ");
INSERT INTO tteo_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","O Yeoba ama Guyau, esam inamwanamwasosi yanuwa yaulina meuloina koina. Kam tobali isae bulibuli ikabitonan. ");
INSERT INTO tteo_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Siya melumeluwo lalakili yo kikiuli kam tobali siwaliyan. Kam tokalomagigiliwo kupei-suwalagili koliwo yo kam kaleyayao kuyamwanouli. ");
INSERT INTO tteo_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Saugana bulibuli yagitai, nimam ali paisowa, waikena yo utu, kupeili ali kaba miya mena kabo yawaloba, ");
INSERT INTO tteo_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","“O Yaubada, tawae tomo, mwa kaiweli kunuwanuwatu? Tawae kaiwena tomo molosi ugite-kalatan yo kunuwanuwatu kaiwena? ");
INSERT INTO tteo_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Tomo molosine kupei-yatalu tupwana kana mwayaga iyai anelose yaulili mena yo yakasisi yo wasawasa kuwolena koina. ");
INSERT INTO tteo_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Yo kupei ginauli meuloina iloinayan. ");
INSERT INTO tteo_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Sipi yo bulumakau meuloili, yakayakan sokasokali, ");
INSERT INTO tteo_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","man sievaeva-keikeile yo iye kalita mena yo yamayamayale kalita mena simiyamiya.” ");
INSERT INTO tteo_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","O Yeoba, ama Guyau, esam inamwanamwasosi yanuwa yaulina meuloina koina. ");
INSERT INTO tteo_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Yakawatoki Yeoba koliwo kategu meuloina koina, am paisowa namwanamwasosili meuloili kani yawalo-masalagili. ");
INSERT INTO tteo_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Kam wali-tobali kani yawaliyan kowa Tomiyasaesosi. ");
INSERT INTO tteo_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Am yawatagili koina sitagelakeile siyabubu kaekaeli siyatupanli sibeku na siboita manim mena. ");
INSERT INTO tteo_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Walo yawasosi am loina idudulaisosi yo am loina koina kusaguiyau. ");
INSERT INTO tteo_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Tonaenaeli kuyakoi-yagiliko yo toyauyaule kusibayanaeliko, nige sowana tanuwatu-kalatagili. ");
INSERT INTO tteo_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Tokalomagigili kuyemwawasi molosagiliko, ali yanuwa kusibayanaeyako mwa kali nuwatu-kalatan imwawasi molosi. ");
INSERT INTO tteo_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Na Yeoba iya kin miyamiya yaina, ana kaba miya wasawasana koina ipeiyako loina kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Na yanuwa yaulina iloinayan mumugana dudulaina koina, na loina ipaisowai tomo kolili mumuga dudulai mena. ");
INSERT INTO tteo_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Yeoba iya tokamkamna ali kaba keno-wadam yo ali kaba yabubu sauga naenaena koina. ");
INSERT INTO tteo_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Siya sikataiwo kani simeli-yagiwo na analiyao silaowa koliwo kani nige kusisikotanagili. ");
INSERT INTO tteo_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Yeoba koina kwawali tobali, iya Saiyon koina iloiloina. Ana paisowa kwawalo-masalan tomo meuloili kolili. ");
INSERT INTO tteo_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Siya sikamkamna inuwatu-kalatagili yo siya naenaena siginauli kolili iyamaisali. ");
INSERT INTO tteo_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","O Yeoba ukwate-kamkamna-yagau, ugitai yagu kamkamna siya kagu tokalomagigiliwo siginauli koliyau boita kana gamwa koina ukeleisinagau, ");
INSERT INTO tteo_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","na mesabana kam tobali yawalo-masalan Yelusalema tomonliyao manli mena. Kani yayaliyaya lalakina kaiwena kuleboyau. ");
INSERT INTO tteo_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Kaba loinao sibekuko sibomayoi gulawa sikekeliwa koina, sibomayoi sisipwa ali sipwasipwa koina. ");
INSERT INTO tteo_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Yeoba ibomayoi iyamayale ana loina dudulaili kolili, na tonaenaeli sibomayoi sisipwa ali paisowa koina. ");
INSERT INTO tteo_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Tonaenaeli meuloili siya Yaubada sisikotanan silalau boita dedeina koina. ");
INSERT INTO tteo_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Toeoma kani nige sauga meuloina simiyamiya ali eomane koina yo tobubutuma kani nige sauga meuloina simiyamiya bubutumane koina. ");
INSERT INTO tteo_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","O Yeoba kutolo, tabu kutatalam tomo sigagamwa-panapanawa koliwo. Tonaenaeli ukwalailima manim mena na kali loina kuwolegili. ");
INSERT INTO tteo_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Kuyamatausagili na sikatai yakato siya tomo bwagabwagamo. ");
INSERT INTO tteo_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","O Yeoba, tawae kaiwena kumiya-suwala? Tawae kaiwena kubomayoi ukeno-wadam ama sauga miyapolowe koina? ");
INSERT INTO tteo_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Toyauyaule sigagasa yo tobubutuma siyakamkamnali kusipwaili sipwasipwane siya sibomayoi siginaulili kolili. ");
INSERT INTO tteo_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Kaiwena sibomayoi sigagasa ali nuwatu naenaeli kaiweli, yo toman-kikiwasi Yeoba sisikotanan yo sikawa-gulai. ");
INSERT INTO tteo_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Nige ali nuwatu yabo Yeoba kaiwena, ali gagasa koina Yaubada siuvalayan. ");
INSERT INTO tteo_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Bwagana wasawasa lalakina silobai na iyamo nige sowana Yaubada ana loina sinuwa-mayaleyan yo kali tokalomagigiliwo sisikoko-wagili. ");
INSERT INTO tteo_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Sibomayoi siwalo-saesae siwaloba, “Kani nige sauga yabo yabebeku yo kani nige sauga yabo polowe yalolobai.” ");
INSERT INTO tteo_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Ali edeedede koina kawa-gula, mwakota, walo-kasokaso ikalapowon yo mwayamwayau mena kani walo naenae yo kalomagigili siwalowegili. ");
INSERT INTO tteo_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","9","Sibomayoi sikeno-wadam ali yanuwa mena na sisanasana tem tomo namwanamwali siunuyamateli. Wadam mena sigitegitelau tomo nige kali tosagu kolili sisanasana sikeno-vasili besiele laiyon. Besiele sikeno-wadam tobubutuma sisanaili na tem sisipwaili ali sipwasipwa mena yo siniuli-suwalagili. ");
INSERT INTO tteo_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Siya tosilaene sikenokeno me ali kamkamna kaiwena toyauyaulene sikaiwesosi. ");
INSERT INTO tteo_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Na toyauyaulene ibomayoi iwaloba, “Yagu paisowa naenaena kaiwena Yaubada nige inunuwatui, manna iyagibuli, kani nige sauga yabo igigitai.” ");
INSERT INTO tteo_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","O Yeoba, toyauyaulene kuyamaisali yo siya sikamkamna kunuwatu-kalatagili. ");
INSERT INTO tteo_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Gubesi na toyauyaulene Yaubada ikalomagigilan na ibomayoi iwaloba, “Kani nige sowana iyamaisayau.” ");
INSERT INTO tteo_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Na iyamo kowa ugitaiyako, ukwataiyako polowene yo kamkamnane yo sauga meuloina kusanasana na tem kusaguili. Tosilaene ibomayoi italamwan koliwo kaiwena siya nige kali tosagu kusaguili. ");
INSERT INTO tteo_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Tonaenaeli yo toyauyaule ali kaiwe ukele-gabaen na kuyamaisali ali paisowa naenaena kanasiga silopei ali paisowane. ");
INSERT INTO tteo_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Yeoba iya kin miyamiya yaina. Siya analiyao yaubada uloiliyao kolili sipwalou kani sikwalalele ana kaba loina koina. ");
INSERT INTO tteo_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","O Yeoba, kowa kani kubenali tobubutuma ali kawanoi kolili na ukabi-yakaiweli. ");
INSERT INTO tteo_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Siya tosinasinage yo siya tokamkamna kani ali valam kubenalagili, yo kani am loina koina kusabilau-wagili na mesabana tomo naenaeli kani nige sauga yaboyoi siyayamatausagili. ");
INSERT INTO tteo_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Yakeno-wadam Yeoba koina iya mwa Yeoba yameliyan iya yau kaba keno-wadam. Toyauyaule kowa gubesi mwa kuwaloma koliyau kuwaloba, “Kuyabubu kulau koya kolili besiele man.” ");
INSERT INTO tteo_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Kaiwena tonaenaeli ali gipoyo simomosiliko yo sikeno-wadam silosalosana na tem tomo namwanamwali sigitaili sisakonali ali pwawati kolili. ");
INSERT INTO tteo_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Tem tonaenaeli loinao meuloili sisibayanaeli nige sowasowana tomo namwanamwana tawae yabo iginauli. ");
INSERT INTO tteo_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Yeoba iyaele ana Nume Tabu kalona mena yo imiyasio ana kaba miya wasawasana koina bulibuli mena. Tomo meuloili igitagitaili yo ikatai tawae sipaipaisowai. ");
INSERT INTO tteo_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Todudulai yo tonaenaeli mumugali igitegite-sipwaili yo siya toloinalikwa ikalomagigi-lagili katena meuloina koina. ");
INSERT INTO tteo_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Mayau wedowedolili yo salepa wedowedolina iyawasali silobima tonaenaeli kolili yo iyamaisali yaumai wedowedoli-sosina koina. ");
INSERT INTO tteo_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Yeoba iya todudulai yo paisowa namwanamwali imulolo kolili. Siya analiyao sipaisowaili kani simiyamiya Yeoba salina mena. ");
INSERT INTO tteo_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Yeoba kusaguimai, kaiwena tomo yakayakasisili simwawasiko, tomeliwo sikwalaleleko yanuwa yaulina mena. ");
INSERT INTO tteo_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Tomo meuloili walo luviluvi sopali mena siedeedede yo kalikavao simwakomwakota-yagili. ");
INSERT INTO tteo_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","4","Siya siwalo-gagasa siwaloba, “Tawae nuwanuwala tawalowen kani tawalowen, yo tawae nuwanuwala ala walo koina takalai nige sowasowana yabo ikausila.” Na yakawanoi koliwo togagasane sopaliyao kuyamwanouli yo gamwaliyao ukwausili. ");
INSERT INTO tteo_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Yeoba iwaloba, “Bwaite sauga kani yatolo kaiwena toeoma siyabayaba yo tobubutuma sikamkamna lalakina. Kabo kani ali kaba kobwau yaolena kolili na koina sikaiyawasi.” ");
INSERT INTO tteo_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Yeoba ana waloyameli sowasowana tameliyan kaiwena siya besiele siliba kapwakapwali siyawaluili kaba gabu wedowedolina koina me seben. ");
INSERT INTO tteo_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","8","Tonaenaeli dedei meuloili kolili silaulau, yo tomo meuloili ali paisowa yauyaulena sitobatobalan. O Yeoba, ugite-kalatagimai toyauyaule bodaliyaone bwaite kolili. ");
INSERT INTO tteo_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","O Yeoba, isa sauga kana mamalawe kani kunuwa-mwatainagau? Nuwana kani kunuwa-mwatainagau molosi? Isa sauga kana mamalawe kani ukeno-wadam koliyau? ");
INSERT INTO tteo_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Isa sauga kana mamalawe kani yaluyaluwagu koina yakamkamna? Isa sauga kana mamalawe kani nuwanae kategu iloyapowon kaliyate yo boniyai? Isa sauga kana mamalawe kani kagu tokaleyayao sikaiwesosi kabo muli mena yau? ");
INSERT INTO tteo_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","O Yeoba yagu Yaubada, ugitaiyau na yagu kawanoi kuyamaisa. Yau kaiwe kuyeyamayoi na tabu yaboboita. ");
INSERT INTO tteo_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Tabu kagu tokaleyayaone sigagagasa siwaloba, “Takaiwe-gabaen.” Yo tabu siyayaliyaya yagu belune kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Na yameli am mulolo miyamiya yaina koina, kani yayaliyaya kaiwena kani kuleboyau. ");
INSERT INTO tteo_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Kani wali yawali-yagili koliwo kaiwena kunamwanamwasosi koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Siya toyauyaule kateli mena siwaloba, “Nige Yaubada imiyamiya.” Meuloili sinae ali paisowa sinaenae sosi. Nige yabo yaiya namwanamwana ipapaisowai. ");
INSERT INTO tteo_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Yeoba bulibuli mena igite-lobima tomo meuloili simiyamiya yanuwa yaulina mena kolili na igitai tem analiyao me ali katai na sipwalou koina. ");
INSERT INTO tteo_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Na nige todudulai yabo ipapagan, nige yabo. Meuloili kamwasa dudulaina silogabaenako silosuwala. Nige yabo ana paisowa idududulai, nigele, nige yabo. ");
INSERT INTO tteo_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Kabo Yeoba iwaloba, “Siya analiyao naenaena siginaginauli mumugana namwanamwana nige nuwali imamayaleyan. Yagu tomoyao kolili sikekan besiele pwalawa sikankan. Nige sauga yabo sikakawanoi koliyau.” ");
INSERT INTO tteo_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Na Yeoba tonaenaeline kani iyamatausagili lalakina na siya analiyao siobigai kani imiyamiya kolili. ");
INSERT INTO tteo_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Tonaenaeli tonuwalobi ali nuwatu sisibayanaeli na Yeoba siya tonuwalobine kali totolo-kaukausi. ");
INSERT INTO tteo_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Yakawanoi Yeoba koina, iya imiyamiya Saiyon koina, kaiwe iwolena tomo Isileli kolili na kaleya koina sibaguna. Sauganane koina kani siwasawasayoi yo siyaliyaya. ");
INSERT INTO tteo_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","O Yeoba, yaiya sowasowana ilusae yo ipwalou am Nume Tabu mena? Yaiya sowasowana am koya yakayakasisina koina itapwalolo? ");
INSERT INTO tteo_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Yaiya tem mumugana idudulai sauga meuloina, ana paisowa idudulai, katena mena walo yawasosi koina iedeedede, ");
INSERT INTO tteo_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","isikote sinali, nige sowasowana naenaena iginauli ana eliyamwao kolili, nige sowasowana kanakavao ietalapili-yagili, ");
INSERT INTO tteo_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","yo siya analiyao Yeoba isikotanagili iya tabe besiele isikotanagili, siya analiyao Yeoba siobigai iyakasisi-yagili, yo iya sauga meuloina iginauli besiele tawae iwaloyameliyako bwagana kamkamna ilobai. ");
INSERT INTO tteo_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Tem ana gogo italamwan nige sowasowana ikawanoi etulan kaiwena yo nige sowasowana siyanuwakoi na mwakota iginauli siya nige ali pwanoli ipapagan kolili. Tomone iya tem paisowa namwanamwali bwaite iginaulili kani itolo kaiwe sauga meuloina. ");
INSERT INTO tteo_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","O Yaubada, ugite-kalatagau kaiwena yalaowa koliwo na yakobwau. ");
INSERT INTO tteo_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Yawalo Yeoba koina yawaloba, “Kowa yagu Guyau, ginauli namwanamwali meuloili kowa koliwo yalobaili.” ");
INSERT INTO tteo_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Yeoba ana tomoyao siya tonamwanamwasosi, yau kaba yaliyaya lalakina tem yamiyamiya luwali mena. ");
INSERT INTO tteo_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Siya analiyao yaubadao uloili simuliya kolili kani nuwanae lalakina iloyakalapowonli. Na yau kani ali pwaoli paisowana koina nige yapapatu yo genuwagu ali yaubadao esaliyao sopagu mena yaedeedede-yagili. ");
INSERT INTO tteo_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","O Yeoba, kowa koliwo ginauli meuloina yalobaili yo kagu eoma meuloina kowa kana toyadudulai, yawasigu kowa nimam mena. ");
INSERT INTO tteo_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Mulolo meuloili kuyelima koliyau sinamwanamwasosi kabo yayaliyaya lalakina. ");
INSERT INTO tteo_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Yeoba yatobalan kaiwena yagu kamwasa iyakenayagau yo yagu nuwatu kategu mena iyanuyanuwapeiyau boniyai kaigeda kaigeda kolili. ");
INSERT INTO tteo_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Yakatai Yeoba iya saligu mena sauga meuloina, nige sowasowana ginauli yabo iyamwasaliyau. ");
INSERT INTO tteo_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Mwa koinaele me yagu yaliyaya yo me yagu kawatoki yo yogu kana lotonan inamwanamwasosi. ");
INSERT INTO tteo_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Kaiwena nige sowana kusikotanagau na yamiyamiya salai mena. Tabe kani nige kutatalam am topaisowa yakayakasisina yona ibobowa. ");
INSERT INTO tteo_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Kani yawasi kana kamwasa kuyakenayagau, am miya saligu mena kategu yaliyaya iloyapowon nige ana kaba mwawasi. ");
INSERT INTO tteo_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","O Yeoba, yagu valam loina dudulaina kaiwena kubenalan, tenam kuyawali yagu kawanoi sagu kaiwena, kaiwena sopagu mena walo yawasosi yawalowen. ");
INSERT INTO tteo_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Kuwalo-masala koliyau yau todudulai kaiwena ukwatai siya analiyao namwanamwana sipaipaisowai. ");
INSERT INTO tteo_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Kategu kutonanako yo boniyai mena kuboeyagau yo kulobubunagau yo kulobai nige yabo nuwatu naenaena koliyau. Yagu nuwatu ikaiwe kani nige yamwamwakota. ");
INSERT INTO tteo_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Siya analiyao naenaena siginaginauli yo sikalekaleya yo mwakota koina siedeedede nige yamumuliya kolili besiele am walo koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Sauga meuloina yalokeikeile am kamwasa mena, yo nige sauga yabo yalolosuwala. ");
INSERT INTO tteo_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","O Yaubada, yakawanoi koliwo kaiwena yagu kawanoi kuyamaisa, kabo tenam kuyawali koliyau na yagu walo kubenalan. ");
INSERT INTO tteo_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Am mulolo inamwanamwasosi kuyakenayagau na kuleboyau, kaiwena siya analiyao siyabubu kali kaleyayao kolili kuleboili na sikeno-wadam koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Ugite-kalatagau yakato yabomamo kumulolososi koliyau na kuwadamyau pepem lolonna mena, ");
INSERT INTO tteo_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","kisi toyauyaule simunamunai na siunuiyau. Kagu tounuyamate siutu-takikilagauko, ");
INSERT INTO tteo_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","nige yabo ali katekamkamna yo siedeedede me ali gagasa. ");
INSERT INTO tteo_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Bwaite sauga silobaiyau, sitolo-takikilagau sisanasana na toisabo solasola koina sigabaegau bwatano mena. ");
INSERT INTO tteo_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Siya besiele laiyon guliguliyamli sikeno-vakasiyau nuwanuwali tem sitabe-igaliyau. ");
INSERT INTO tteo_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Yeoba, kutolo ukwaleyaili yo ukwaiwe-gabaegili, am kaleya kelepana koina kuleboyau toyauyaule kolili. ");
INSERT INTO tteo_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Kuleboyau towasawasa kolili siya ali miya koina ginauli meuloina nuwanuwali silobaiyako. Diyaliyao kuyakalapowonli am munamunai kamkamnana koina. Na kamkamnane kuyalalaki molosan na mesabana natuliyao yo tubuliyao tabe silobai. ");
INSERT INTO tteo_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Na yau kani yagitaiwo kaiwena mumugagu idudulaisosi yo saugana yatolo yagu kaba keno mena am miya saligu mena kaiwena kani yaliyaya kategu iloyapowon. ");
INSERT INTO tteo_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Deibida ilele saugana Yeoba ileboi kana kaleyayao kolili O Yeoba, yamulolo koliwo kowa yagu kaiwe yaina. ");
INSERT INTO tteo_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Yeoba iya yagu veku yo iya yagu nume kaikaiwena yo iya kagu tolebolebo, yagu Yaubada, yagu veku kaikaiwena, iya yagu kaba meli, yagu ebeu, yo kagu tolebo yo yagu kaba kaiwe, yagu nume kaba kelolon. ");
INSERT INTO tteo_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Yayoga Yeoba koina kaiwena iya tobali kana lonamwa kabo ileboyau kagu kaleyayao kolili. ");
INSERT INTO tteo_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Boita mainana simiya-takikilagau na sibayanae bagoluna iguli-pwaikiyau. ");
INSERT INTO tteo_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Salai mainana siyepanpan-yagau, boita kana sipwasipwayao silaoma mangu mena. ");
INSERT INTO tteo_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Saugana yagu miyapolowe koina yayoga Yeoba koina sagu kaiwena kabo ana nume tabu koina yagu valam ilau tenana koina kainagu ibenalan. ");
INSERT INTO tteo_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Kabo yanuwa yaulina inuku yo itabubu, yo koya yailiyao simwasali yo siulapwasi, kaiwena Yaubada imunamunai. ");
INSERT INTO tteo_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Kabo isuna gulana mena bogau siyawayawatagili, yo mayau kalakala-pulupululuna yo gibwala wedowedolina gamwana mena siyawatagili. ");
INSERT INTO tteo_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Yaubada bulibuli itabe-igali na ilobima yaloyaloi dubadubana pwatana mena. ");
INSERT INTO tteo_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Kabo imwalisae anelose yabo koina ieva yo mwayamwayau mena ilaoma yaumai pepena mena iyui-tubali. ");
INSERT INTO tteo_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Boniboniyai koina ibomayoi isuma, yaloyaloi balubaluli dubadubali waila sikalapowon siyamala ana kaba kelolon. ");
INSERT INTO tteo_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Galewa patupatuna yo mayau wedowedolili siyawatagilima pigabune bwaimwana Yaubada manna mena kabo yaloyaloi silapanli. ");
INSERT INTO tteo_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Tabe Yaubada tomiyasaesosi bulibuli mena kainana mena iyoga besiele tutu. ");
INSERT INTO tteo_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Ana gipoyo iulagili sisagena kabo kana tokalomagigiliwo itupa-gwaligwalili. Pigabu koina kana kaleyayao itawoili siyabubu. ");
INSERT INTO tteo_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","O Yeoba, am yokoi koina, tomo sigitai kalita gunna ilabwalabwa, na yawasim mena kuyui-kalai kabo yanuwa yaulina kana wauwau sileleyan mayale mena. ");
INSERT INTO tteo_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Yeoba kewa mena nimana iyaga-lobiyenama na ikeleisinagau kalita didididiuna koina. ");
INSERT INTO tteo_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Ileboyau kagu kaleya kaikaiwena koina, yo siya analiyao sikalomagigi-lagau kaiwena siya sikaiwesosi kabo yagu kaiwe. ");
INSERT INTO tteo_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Yagu sauga miya polowe koina silaoma sikaleya koliyau, na iyamo Yeoba itolo-kaukausiyau. ");
INSERT INTO tteo_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Sauga naenaena koina ileboyau, kaiwena iyaliyaya koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Yeoba iya iyamaisayau kaiwena mumugagu idudulai, yo iwalo muloloiyau kaiwena yau tomo dudulaina nige yagu naenaena ipapagan. ");
INSERT INTO tteo_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Nige yalolosuwala Yeoba koina, ana loina yamuliyako. ");
INSERT INTO tteo_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Kaiwena ana loina meuloina simiyamiya mangu mena, nige yapepei-suwalagili. ");
INSERT INTO tteo_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Ikataiyau nige yagu naenaena ipapagan mwa yabomayoi naenaena koina yatabuwagau. ");
INSERT INTO tteo_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Mwa koina Yeoba iyamaisayau besiele mumugagu ana dudulai koina, yo iwalo-muloloiyau kaiwena nige yagu naenaena ipapagan. ");
INSERT INTO tteo_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","O Yeoba, siya analiyao simeli-yagiwo kuyakenayagiwo kolili yakato kowa towalo-yawasosi, yo siya analiyao nige ali naenaena yabo ipapagan kuyakenayagiwo yakato kowa tabe nige am naenaena yabo ipapagan. ");
INSERT INTO tteo_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Siya analiyao mumugali sikapwa koliwo mumugam ikapwa kolili, na siya kateliyao sikololo koliwo tabe katem ikololo kolili. ");
INSERT INTO tteo_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Siya analiyao sinuwalobi kuleboili, na siya tonuwasae kupei-yataluli. ");
INSERT INTO tteo_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Kowa Yeoba yagu Yaubada, yagu mayale ugwabu iwedowedoli na boniboniyaine kubui-keile mayale. ");
INSERT INTO tteo_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Kaiwe kuyeyama na yasagena kagu kaleyayao yatupa-gwaligwalili yo am kaiwe mena sowasowagu gana yakapusele-likwai. ");
INSERT INTO tteo_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Yaubada bwaite ana kamwasa inamwanamwasosi yo ana waloyameli sidudulaisosi. Siya analiyao siloyai iya iyamala ali ebeu yo kali totolo-kaukausi. ");
INSERT INTO tteo_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Na yaiya Yaubada? Yeoba iya ala Yaubada. Yaiya ala veku kaikaiwena? Yeoba iya ala veku kaikaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Iya Yaubadanane ana kaiwe iyeyama na ibagunayagau me yagu namwanamwana. ");
INSERT INTO tteo_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Kaegu iyamwasalili na simalae besiele gouti ana sagena ana malae yo ipei-namwanamwaiyau koya malamalawesosina koina. ");
INSERT INTO tteo_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Nimagu iyakataili kaleya kaiwena, na nimagu sikaiwe na gipoyo matumatuwana yamomosi. ");
INSERT INTO tteo_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Kowa lebo kana ebeu kuyeyamako yo nima ulaulam itupa-kalatagau, na kusaguiyau mwa tomo meuloili sikataiyau. ");
INSERT INTO tteo_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Ugite-kalatagau na tabu sikakabi-kalatagau, mwa nige sauga yabo yabebeku. ");
INSERT INTO tteo_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Kau kaleyayao yayamuli-kusululi na yakalaili na nige sowana yatagela-keile kanasiga yaemwawasi wolili. ");
INSERT INTO tteo_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Yagu kaleya kelepana koina yasakona-lapanli nige sowasowali sitoloyoi, na kaegu yaulina mena sibeku. ");
INSERT INTO tteo_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Kaiwena kaiwe kuyeyama kaleya kaiwena na kau kaleyayao sibeku yauligu mena. ");
INSERT INTO tteo_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Kowa kuyatagelakeileli na siyabubu koliyau na kagu tokalomagigiliwo yasibayanaeli. ");
INSERT INTO tteo_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Sivalam sagu kaiwena na nige kali tosagu yabo ipapagan. Kabo sivalam Yeoba koina na nige kainali iyayamaisa. ");
INSERT INTO tteo_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Yasapi-mutumutuli besiele bwatano kauna na yaumai iyuiyui-kalakalaili yo yasuwe-gabaegili besiele kamwasa bwalabwalana. ");
INSERT INTO tteo_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Kuleboyauko togamwa-panapanawa bodaliyao kolili, na kupeiyau yaemala toloina siya nige Yudiya bodaliyao simiyamiya gana muli mena kolili kabo siyamala yagu topaisowao. ");
INSERT INTO tteo_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Na saugana tomiya-suwalane wasagu sibenalan mwayamwayau siobiga silaoma me ali pwalou sinenemo silaoma koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Ali katepatu meuloina imwawasi mwa ali kaba keno-wadam mena siyawatagilima me ali tabubu. ");
INSERT INTO tteo_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Yeoba Yaubada iya meyawasina yo veku kaikaiwena kani yatobalan kaiwena iya kagu tolebo. ");
INSERT INTO tteo_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Iya Yaubadane kagu gum kana toyai mwa tomo ipei-yataluli yauligu mena. ");
INSERT INTO tteo_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Kau kaleyayao yo tomo naenaeliyao kolili kuleboyau mwa ukeleisinagau yalalaki-gabaegili. ");
INSERT INTO tteo_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","O Yeoba, kani yatobalanagiwo yo yayakasisi-yagiwo siya nige Yudiya tomonliyao luwaluwalili mena yo kani esam kana tobali yawaliyan. ");
INSERT INTO tteo_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Yaubada kaiwe iwolena ana kin gitegite-sipwaina koina na ana mulolo miyamiya yaina iyakenayan yau Deibida yo tubuguwao kolimai kani nige ana kaba mwawasi. ");
INSERT INTO tteo_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Bulibuli iwalowalo-masalan Yaubada ana wasawasa, sowasowaga nimana ana paisowa siyawayawasayan. ");
INSERT INTO tteo_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Kaliyate kaigeda kaigeda yo boniyai kaigeda kaigeda wasanane siwalowalo-masalan kaliyatene yo boniyaine silalaomane kolili. ");
INSERT INTO tteo_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Dagugu yo kaina nige siyayapaisowa, ");
INSERT INTO tteo_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","na iyamo wasanane ilau yanuwa yaulina ana kaba mwawasi meuloina sibenalan. Yaubada dabwelo ana kaba miya ipaisowai bulibuli mena, ");
INSERT INTO tteo_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","yo ana mwalisae malala mena me ana yaliyaya na yaliyayane besiele tokasole tauna ana yaliyaya ana kasole koina yo besiele tosagena kawalakwa kaikaiwena ana yaliyaya sagenane koina. ");
INSERT INTO tteo_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Dabwelo isae ana kaba tunsae mena yo ilobi ana kaba sugu mena. Ana kaiwe nige sowasowana ginauli yabo iwadam koina. ");
INSERT INTO tteo_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Yeoba ana loina inamwanamwasosi yo yaluyaluwala iyawaluwaluili. Sowasowana Yeoba ana walo tameliyagili, katai iwolegili siya nige ali katai sipapagan kolili. ");
INSERT INTO tteo_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Yeoba ana loinao sidudulaisosi yo siya analiyao siobigaili siyaliyaya. Yaubada ana loinao simayale yo nuwamayale talobai kolili. ");
INSERT INTO tteo_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Yeoba kana yakasisi ikapwasosi yo imiyayai. Yeoba ana loinao walo yawasosi yo ana yatala itoyatoyawa sauga meuloina. ");
INSERT INTO tteo_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Ana loinao sinamwanamwasosi kabo gole ana namwanamwa yo siluviluvi sosi kabo kamwakamwa ana luviluvi. ");
INSERT INTO tteo_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Yau, am topaisowa, katai siyeyama koliyau yo yagu muliyane kolili maisa yalobai. ");
INSERT INTO tteo_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Gubesi na tem lopwanone yagitaili kategu mena? Kudeuliyau naenaenane ana keno-wadamne koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Kutolo-kaukausiyau naenaena kana paisowa koina, tabu sikakaiwe-gabaegau. Kabo yanamwanamwa sosi yo nige yakewa yabo naenaena kaiwena koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","O Yeoba, kowa yagu veku yo kagu totolo-kaukausi, sowasowana walo sopagu mena yo yagu nuwatu kategu mena am kaba yaliyaya. ");
INSERT INTO tteo_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Sowasowana Yeoba iya tomo Isileli ala Yaubada, ami kawanoi ibenalan yo iyamaisa ami miyapolowe saugana koina yo itolo-kaukausimiu. ");
INSERT INTO tteo_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Sowasowana sagu iyawasa kolimiu ana Nume Tabu mena bwaimwa koya Saiyon koina. ");
INSERT INTO tteo_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Sowasowana ami olena bwagabwaga meuloili inuwatu-kalatagili, yo ami pwaoli kana gabu meuloili siyamala ana kaba yaliyaya. ");
INSERT INTO tteo_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Sowasowana ami gadosisi iyeyawa yo ami loina siyamala yawasosi. ");
INSERT INTO tteo_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Tem saugana wasa kabenalan ami kaleya koina kwabaguna kai kani kawui me ama yaliyaya kaiwemiu, ama memenawa kakukeili yo ala Yaubada katobalan ami kaiwe kaiwena. Sowasowana Yeoba ami kawanoi meuloili iyamaisali. ");
INSERT INTO tteo_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Bwaite kabo yakatai Yeoba kaiwe iwolena ana gitesipwa kinna koina yo kainana iyamaisa ana bulibuli tabu koina yo ileboi ana kaiwe lalakina koina. ");
INSERT INTO tteo_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Boda tupwali ali meli sipei ali waga niuniuli kolili, yo boda tupwaliyao simeli ali osi kolili na kita tameli Yeoba ala Yaubada ana kaiwe koina. ");
INSERT INTO tteo_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Siya bwaine bodane kani kaeliyao siyetupanli na sibeku na kita kani tatolo kaiwe. ");
INSERT INTO tteo_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","O Yeoba, kaleya kana baguna kuwolena ama kin koina na ama kawanoi sagu kaiwena kuyamaisa. ");
INSERT INTO tteo_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","O Yeoba, kin iyaliyaya kaiwena kaiwe kuwolena, iwui me ana yaliyaya kaiwena sagu kuwolena ana kaleya koina. ");
INSERT INTO tteo_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Tawae katena mena inuwanuwatui kuwolenako, sopana ana kawanoi nige kununuwai. ");
INSERT INTO tteo_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Mulolo lalakina ukwalaiyama koina na pwaopwaom gole kupei kulakulana mena. ");
INSERT INTO tteo_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Ikawanoi yawasina kana gite-kalatan kaiwena kabo ana kawanoiwa kuwolena, yawasina kana sauga imamalawesosi. ");
INSERT INTO tteo_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Ana wasawasa ilalaki am sagune koina yo esana wasana ilalaki kuwolena. ");
INSERT INTO tteo_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Am mulolo koina simiyayai yo am miya salina mena yaliyaya katena iloyapowon. ");
INSERT INTO tteo_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Kin Yeoba Tomiyasaesosi imeliyan kabo ana mulolo miyamiya yaina kaiwena itolo-kaiwe sauga meuloina. ");
INSERT INTO tteo_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Kin kana tokaleyayao meuloili yo besiele siya analiyao sikalomagigilan kani ikabi-kalatagili. ");
INSERT INTO tteo_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Tem saugana iyawatagili kani isibayanaeli besiele mayau kalapulupululuna kalona mena siwedoli. Yeoba kani isinolili ana munamunai koina yo mayaune igabu wolili. ");
INSERT INTO tteo_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Natuliyao yo tubuliyao kani nige yabo meyawasili, kin kani meuloili iyemwawasili. ");
INSERT INTO tteo_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Kani ali loina sipaisowaili na sinuwanuwatu tem siunui na iyamo kani nige iyayawatagili besiele ali nuwatune. ");
INSERT INTO tteo_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Kani ana gipoyo imomosi na iulan kolili kabo sitagelakeile na siyabubu. ");
INSERT INTO tteo_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","O Yeoba, kani katobalanagiwo yo wali kawaliyagili koliwo am kaiwe lalakina kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Yagu Yaubada, yagu Yaubada, tawae kaiwena kumiya-dagedagela-yagau? Tawae kaiwena yagu valam sagu kaiwena nige kubebenalan? ");
INSERT INTO tteo_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Kaliyate koina yagu tasi-yabayaba koliwo na nige kuyayamaisa, yo besiele boniyai koina yavalavalam koliwo na nige sagu yabo yalolobai. ");
INSERT INTO tteo_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Na kowa Yaubada am kaba miya wasawasana koina kumiyamiya kapwakapwana kabo tomo Isileli ali kaba tobali kowa. ");
INSERT INTO tteo_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Tubumayao simeli-yagiwo mwa ali meline koina kuleboili. ");
INSERT INTO tteo_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Saugana tem siyoga sagu kaiwena kuleboili na nige kusisikotanagili. ");
INSERT INTO tteo_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Na yau besiele dimonana yaemala tomo ali kaba malu yo ali kaba sinali. ");
INSERT INTO tteo_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Meuloili sigitaiyau sitalawasi-yagau. Mwa sopaliyao siyagegewalili na kulukululiyao siyakwayakwaleli, ");
INSERT INTO tteo_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","siwaloba, “Am meli kupei Yaubada koina, na tawae kaiwena nige ileleboiwo? Tem Yeoba nuwanuwana kowa, tawae kaiwena nige isasaguiwo?” ");
INSERT INTO tteo_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","O Yeoba, yagu sauga kabi koina kowa am gite-kalatagau koina mwa nige yaboboita. Yo yagu sauga melumelu koina kowa kuyasusu-namwanamwaiyau sinagu susuna koina. ");
INSERT INTO tteo_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Kaliyatenane koina sikabiyau yameliyagiwo, mwa kowa sauga meuloina yagu Yaubada. ");
INSERT INTO tteo_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Tabu kumimiya-suwala koliyau, kaiwena nae iyaele ilalaoma kaiwegu na yau nige kagu tosagu yabo. ");
INSERT INTO tteo_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Kau kaleyayao sibaibaiwa simiya-takikilagau besiele yanuwa Basan bulumakauliyao tataoliyao sokasokali. ");
INSERT INTO tteo_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Na gamwaliyao sisaeli besiele laiyon sokasokali sikalakalagaga nuwanuwali tem sitabe-igaigaliyau. ");
INSERT INTO tteo_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Yagu kaiwe meuloina imwawasi, besiele waila sisuwegabaen bwatano mena ididididi, yo tuwatuwagu kali tubwe meuloili siwakaka yo kategu besiele pwawati siyaweloli mosomosoli. ");
INSERT INTO tteo_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Yagu kaiwe imwawasi besiele gulewa tupwatupwaliyao yo memenagu ipatu kasekasegu mena, kaiwena kulogabaegauko na yaboita bwatano kauna koina. ");
INSERT INTO tteo_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Tomo naenaeli siyatakikilagau besiele bwauwa sokasokali bodaliyao saligu mena na nimagu yo kaegu sikapu-igaigalili. ");
INSERT INTO tteo_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Yapwagege tuwatuwagu mayale mena sowasowana tomo sigitaili. Kau kaleyao sigitagitaiyau yagu pwagege kaiwena sigagasa. ");
INSERT INTO tteo_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Venu yabo sivenuwan kau kalekone kaiwena kabo muli mena siyauyani sibomayoi kolili. ");
INSERT INTO tteo_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","O Yeoba, tabu kumimiya-suwala koliyau, kowa kagu tosagu, kulomwayamwayauma na kusaguiyau. ");
INSERT INTO tteo_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Kuleboyau kisi kaleya kelepana koina siunuiyau, na yawasigu kuleboi bwauwaone kolili. ");
INSERT INTO tteo_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Kusaguiyau bwaite laiyonne yo bulumakaune sokasokaline kolili, kaiwena nige yau kaiwe ipapagan. ");
INSERT INTO tteo_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Kaba logogone kalona mena kani esam yatobalan yo yawalo-masalan kaukavao kolili. ");
INSERT INTO tteo_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Komiu ana topaisowao, Yeoba kwatobalan. Komiu Yakobo tubunao, Yeoba kwayakasisi-yan. Komiu tomo Isileli, kwapwalou koina. ");
INSERT INTO tteo_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Nige sowasowana Yeoba manna ikabi-kaukausi tobubutuma ali kamkamna koina, na saugana siyoga sagu kaiwena kainali iyamaisa. ");
INSERT INTO tteo_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Logogo lalakina koina kani yatobalanagiwo am paisowa kaiwena. Kam topwalopwalouwone manli mena kani yapwaoli besiele tawae yagu waloyameli. ");
INSERT INTO tteo_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Siya tobubutuma kani sikekan diyaliyao sisu yo siya silaoma Yeoba koina kani sitobalan. Sowasowana ikabi kabi-yaliyaya-yagili yawasili meuloina koina. ");
INSERT INTO tteo_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Kaba loinao meuloili kani Yeoba sinuwatu-kalatan, yo tomo dedei meuloili kolili kani sinuwabui yo sipwalou koina. ");
INSERT INTO tteo_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Yeoba iya kin yo tomo meuloili kali toloina. ");
INSERT INTO tteo_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Siya analiyao siwasawasa yo ginauli meuloina sowasowali kani sipwalou koina. Tomo yanuwa yaulina meuloila kani tapwalou manna mena. ");
INSERT INTO tteo_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Yaso mulimuliyeli kani sipaisowa koina, besiele tabe kani wasana siwalo-masalan natuliyao kolili. ");
INSERT INTO tteo_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Tomo siya naga sikakabili kani walo bwaite sibenalan, “Yeoba ana tomoyao ileboiliko.” ");
INSERT INTO tteo_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Yeoba igite-kalatagau besiele sipi togite-kalatan ana sipi igite-kalatagili, nige sowana yaguliyam. ");
INSERT INTO tteo_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Iyakaiyawasiyau kawasi kalakalawana koina yo iyoganyau waila neganegana koina yanuma. ");
INSERT INTO tteo_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Yagu kaiwe iyawaluiyoi yo iyoganyau kamwasa dudulaili kolili besiele ana waloyameli. ");
INSERT INTO tteo_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Yeoba, bwagana yalaulau kalogawa boniboniyaina koina nige sowasowana yamatausi kaiwena kowa mekaukava. Nimam mena am sige yo am ginagina kaba unu sitolo-kaukausiyau. ");
INSERT INTO tteo_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Yau kekan ukwatububunan kau kaleyao manli mena sigitagitaiyau yo kuyoganyau besiele kam taumana yakayakasisina yo kau komwa kusuwe-yapowon. ");
INSERT INTO tteo_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Kabo yakatai am namwanamwa yo am katekamkamna kani siya mekaukavao yawasigu meuloina koina yo am nume iyamala yau kaba miya imiyayai. ");
INSERT INTO tteo_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Ginauli meuloina yanuwa yaulina mena yo siya meuloili meyawasili simiyamiya koina Yeoba ana gogo. ");
INSERT INTO tteo_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Ikabi yalubwasi didididiuli pwatali mena yo kana wauwau ipei kalita gunna mena. ");
INSERT INTO tteo_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Yaiya sowasowana Yeoba ana koya yakayakasisina ikawasae? Yaiya sowasowana ana Nume Tabu koina ilusae? ");
INSERT INTO tteo_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Iya ana nuwatu yo ana paisowa kapwakapwali, yo nige ipwalopwalou kokotomo kolili yo nige waloyameli mwakomwakotali iwalowalo-wegili. ");
INSERT INTO tteo_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Yeoba kani iwalo-muloloili yo ileboili yo ikawa-namwanamwa-yagili, nige kali yakewa yabo ipapagan. ");
INSERT INTO tteo_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Siya bwaite sowasowali silusae Yaubada manna mena na sipwalou Isileli ali Yaubada koina. ");
INSERT INTO tteo_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","10","Nume Tabu kana gulu yo kana gamwa beyabeyali kwasokeli na wasawasa kana kin ilusae. Yaiya wasawasa kana kin? Iya Yeoba Tokaiwesosi, iya kaleya koina ikaiwesosi yo ibaguna. ");
INSERT INTO tteo_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","O Yeoba, yagu kawanoi yaeyawa, ");
INSERT INTO tteo_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","kowa yagu Yaubada koliwo yagu meli yapei. Tabu kupepeiyau mwalimwaline koina yo tabu kagu tokaleyayao sikakawa-ginauli bwagabwaga-yagau. ");
INSERT INTO tteo_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Bwagana nige sikakaiwesosi, siya analiyao simeli-yagiwo kani nige simwamwalimwaline. Na siya sigamwapanapanawa koliwo siya kani mwalimwaline silobai. ");
INSERT INTO tteo_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","O Yeoba, am kamwasa kuyakenayagau na kuyamayale koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Kubaguna-yagau am walo yawasosi koina na kuyakenayagau, kaiwena kowa yagu Yaubada kagu Tolebo. Kaliyate meuloina koina yagu meli yapei koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","O Yeoba, am mulolo miyamiya yaina yo am katekamkamna kunuwatu-kalatagili siya sauga beyabeyana koina yo ilaoma kanasiga kabona kuyakenayagimai. ");
INSERT INTO tteo_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Tabu yagu sauga kilakai koina yagu yauyaule yo yagu lopwano kununuwatu-kalatagili na ugitaiyau am mulolo miyamiya yaina koina yo am namwanamwa koina. ");
INSERT INTO tteo_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Yeoba iya todudulai yo tonamwanamwa mwa tolopwanoli kamwasa dudulaina iyakayakataili na tem simuliya. ");
INSERT INTO tteo_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Tonuwalobi iyoganli kamwasa dudulaina koina yo ana nuwatu iyakataili. ");
INSERT INTO tteo_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Siya meuloili ana kelabilabin kamwasana sinuwatu-kalatan yo ana loinao siobigaili iyoganli me ana mulolo yo me ana walo yawasosi. ");
INSERT INTO tteo_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","O Yeoba, am waloyameli kunuwatu-kalatan na yagu pwanoli kunuwatu-pwaikili kaiwena sibaibaiwasosi. ");
INSERT INTO tteo_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Siya analiyao Yeoba siobigai kani iyakataili kamwasane ilonamwayagili simuliya. ");
INSERT INTO tteo_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Kani sauga meuloina siwasawasa yo natuliyao kani yanuwane sikalai. ");
INSERT INTO tteo_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Siya analiyao siobigai Yeoba kani ikawa-elieliyam-wagili yo ana kelabilabin kamwasana iyakenayagili. ");
INSERT INTO tteo_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Sauga meuloina mangu ilau Yeoba koina sagu kaiwena kabo ileboyau kaba silae kolili. ");
INSERT INTO tteo_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","O Yeoba, kutagelakeile koliyau yo ukwate-kamkamna-yagau kaiwena nige kagu tosagu yabo yo yogu sibelu. ");
INSERT INTO tteo_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Yagu nuwapolowe yo yagu katewakaka ukele-gabaegili yo kuleboyau yagu miyapolowe koina. ");
INSERT INTO tteo_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Yagu valam yo yagu kamkamna kunuwatu-kalatagili, na yagu pwanoli meuloili kunuwatu-pwaikili. ");
INSERT INTO tteo_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Ugitai kau kaleyao sibaibaiwasosi yo ali kalomagigili koliyau kana lalaki ugitai tabe. ");
INSERT INTO tteo_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Yawasigu ugite-kalatan yo kuleboyau, tabu kupepeiyau mwalimwaline koina kaiwena yalaomako koliwo kowa kagu totolo-kaukausi. ");
INSERT INTO tteo_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Sowasowana yagu namwanamwa yo yagu walo yawasosi sisaguiyau kaiwena yagu meli yapei koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","O Yaubada, am tomoyao Isileli kuleboili ali miyapolowe meuloili kolili. ");
INSERT INTO tteo_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","O Yeoba, kuwalo-masala yakato nige nae yabo koliyau kaiwena yagu paisowa idudulai yo yagu meli meuloina yapei koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Kulobubunagau yo kutonagau, nuwatune siyaele kategu mena ugite-yakasali. ");
INSERT INTO tteo_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Am mulolo miyamiya yaina iyaele mangu mena yo am walo yawasosi yagu lau ibagunayan. ");
INSERT INTO tteo_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Yatolo-suwala tolobwagabwaga kolili yo nige yamiyamiya tomwakomwakota luwali mena. ");
INSERT INTO tteo_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Yasikote tonaenaeli ali kelabilabin koliyau yo genuwagu yamiyamiya toyauyaule luwali mena. ");
INSERT INTO tteo_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","O Yeoba, nimagu yadeulili na yawalo-masala nige yagu naenaena ipapagan na am kaba pwaoli yalotakikilan. ");
INSERT INTO tteo_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Yagu wali kawatoki yawaliyan koliwo yo am paisowa namwanamwali meuloili yawalo-masalagili. ");
INSERT INTO tteo_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","O Yeoba, am numene koina kumiyamiyane yamulolo koina iya koina am wasawasa imiyamiya. ");
INSERT INTO tteo_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Saugana tonaenaeli kuunuyamateli tabu ugiginauli besiele koliyau, yau genuwagu tounuyamatene kali maisa yalobai besiele, ");
INSERT INTO tteo_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","siya tomone nimali sibiki naenaena koina yo sauga meuloina sisanasana tem tomo siyamaisali na paisowa naenaena siginauli kaiweli. ");
INSERT INTO tteo_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Na yau kaiwegu, yagu paisowa idudulai kabo ukwate-kamkamna-yagau yo kuleboyau. ");
INSERT INTO tteo_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Yamiya-suwala kaba silae kolili, yo yatolo Yeoba ana tomoyao luwali mena yo esana yatobalan. ");
INSERT INTO tteo_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Yeoba iya yagu mayale yo kagu tolebo, nige sowana yaiya yabo yamatausan. Yeoba iya kagu totolo-kaukausi, nige sowana yakatewakaka. ");
INSERT INTO tteo_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Saugana tonaenaeli silaoma sabi unuiyau yo sitonan tem siunuyamateyau kani kaeli siyetupanli yo sibeku. ");
INSERT INTO tteo_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Bwagana tokaleya bodana siutu-takikilagau kani nige yamamatausagili. Bwagana kau kaleyao silaoma sabi unuiyau kani me yagu meli yatolo kaiwe Yaubada koina. ");
INSERT INTO tteo_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Ginauli kaigedamo yakawanoiyan Yeoba koina, nuwanuwagu yamiyamiya ana nume mena yawasigu meuloina koina, na bwaine koina ana namwanamwa nuwagu iyai yo ana nuwatu yaloyai. ");
INSERT INTO tteo_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Sauga miyapolowe kolili iya koina kani yakelolon, ana Nume Tabu koina kani ipeise-yagau veku malamalawena pwatana mena igite-kalatagau. ");
INSERT INTO tteo_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Bwagana simiya-takikilagau kani yabaguna yo kagu kaleyayao yakaiwe-gabaegili. Me yagu yaliyaya kani yawui yo pwaoli yagabuli Yeoba ana Nume Tabu mena. Kabo yawali yo esana yatobalan. ");
INSERT INTO tteo_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","O Yeoba, yagu valam kubenalagili, Ukwate-kamkamna-yagau na yagu kawanoi kuyamaisa. ");
INSERT INTO tteo_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Saugana kuwaloba, “Kulaoma kupwalou koliyau”, kabo kainam yayamaisa yawaloba, “Yeoba yalalaowa.” ");
INSERT INTO tteo_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Tabu kubomayoi ukekeno-wadam koliyau, tabu kumumunamunai koliyau yo tabu am topaisowa kusisikotanan. O Yeoba, kowa kagu tolebo yo kowa sauga meuloina kagu tosagu, kabo tabu kulologabaegau na yaboma yamiyamiya. ");
INSERT INTO tteo_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Tamagu yo sinagu sisikotanagauko na Yeoba kani igite-kalatagau. ");
INSERT INTO tteo_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","O Yeoba, mumugam kuyakataiyau yo kuyoganyau kamwasa namwanamwana koina kaiwena kagu kaleyayao sibaibaiwa. ");
INSERT INTO tteo_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Tabu kulologabaegau na kau kaleyao silolobaiyau siya simwakota koliyau yo siula-matamatausagau. ");
INSERT INTO tteo_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Yakatai kani meyawasigu kanasiga Yeoba ana namwanamwa yagitai kabo muli mena yaboita. ");
INSERT INTO tteo_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Yeoba kwameliyan, me ami meli yo tabu kwanunuwa-belubelu. Me ami kalakisiye Yeoba kwasanasanai. ");
INSERT INTO tteo_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","O Yeoba, kowa kagu totolo-kaukausi, yayoga koliwo. Tabu tenam ukwakabi-kausili. Tem nige kainagu kuyayamaisa kani yalusae bodane luwali mena siya kani silobi boita dedeina mena. ");
INSERT INTO tteo_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Saugana yavalam koliwo sagu kaiwena yo nimagu yakeleisinagili na yayagayagiliwa am Nume Tabu kaiwena kubenalagau. ");
INSERT INTO tteo_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Tabu kuniniuli-suwalagau siya toyauyaule yo tonaenaeli kali topaisowa mekaukavao. Siya tomone kawa-elieliyam sopali mena siedeedede-yagili na kateli mena kalomagigili sikalapowon. ");
INSERT INTO tteo_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Kuyamaisali ali naenaena meuloina kaiwena, ali yauyaule kana liye koina kuyamaisali na manli kuyabwakina. ");
INSERT INTO tteo_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Yeoba tawae ipaisowai nige sinunuwatui yo tawae iyamayaleli nige ali katai yabo. Mwa kani isapi-golugolululi yo isibayanaeli simwawasi. ");
INSERT INTO tteo_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Yeoba tatobalan kaiwena yagu valam sagu kaiwena ibenalan. ");
INSERT INTO tteo_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Yeoba iya kagu totolo-kaukausi yo yagu ebeu kabo iya yameliyan kategu meuloina koina. Isaguiyau yo ikabi-yaliyaya-yagau. Mwa me yagu yaliyaya yawali-tobali koina. ");
INSERT INTO tteo_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Yeoba ana tomoyao igite-kalatagili yo ana gitesipwa kinna itolo-kaukausi yo ileboi. ");
INSERT INTO tteo_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","O Yeoba, am tomoyao kuleboili yo siya analiyao am bodao kuwalo-muloloili. Kubaguna-yagili besiele sipi togite-kalatan ana sipi igite-kalatagili sauga meuloina. ");
INSERT INTO tteo_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Komiu bulibuli tomonliyao Yeoba kwatobalan ana wasawasa yo ana kaiwe kaiweli. ");
INSERT INTO tteo_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Yeoba Tomiyasaesosi esana tabu yo wasawasana kwatobalan yo kwapwalou manna mena. ");
INSERT INTO tteo_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Yeoba ala Yaubada itutu kainana tabenalan dumwakali mena, daguguna ilalaki yo kainana italu-pitopito bagolu pwatali mena. ");
INSERT INTO tteo_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Yeoba kainana ikaiwesosi yo yakasisi ikalapowon sibenalan. ");
INSERT INTO tteo_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Sowasowana Lebanon ali mayau lalakili kaikaiweli isapi-igalili. ");
INSERT INTO tteo_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Besiele bulumakau natuliyao sikapusele, Lebanon ali koya sikapusule saugana Yeoba kainana daguguna sibenalan. Besiele tabe koya Elimon ikapusele besiele bulumakau tauna natuna. ");
INSERT INTO tteo_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Yeoba kainana kaiwena pigabu siwedoli, ");
INSERT INTO tteo_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","yo ule leleyanli sinuku. Tabe besiele ule leleyanna esana Kadesi inuku lalakina. ");
INSERT INTO tteo_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Yeoba kainana mayau lalakili esali ouki iiliyagili yo inukuili yo liguliyao meuloili sisalulu. Kabo tomo meuloili Nume Tabu mena siyoga siwaloba, “Yaubada towasawasa.” ");
INSERT INTO tteo_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Yeoba yalubwasi dumwadumwakalili iloinayagili yo imiyasio ana kaba miya wasawasana koina kaiwena iya kin miyamiya yaina. ");
INSERT INTO tteo_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Kaiwe iwolegili ana tomoyao kolili yo iwalo-muloloili nuwadaumwali mena. ");
INSERT INTO tteo_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Nume Tabu kana walo-mulolo walina O Yeoba, yatobalanagiwo kaiwena kuleboyau nige kutatalam kagu tokaleyayao sigagagasa-likwaiyau. ");
INSERT INTO tteo_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","O Yeoba yagu Yaubada, yavalam koliwo sagu kaiwena kabo kuwoisiyau, ");
INSERT INTO tteo_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","nige kutatalamwagau yaboboita. Yalolobi boita kaiwena na yawasigu ukele-yavivilayoi. ");
INSERT INTO tteo_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Komiu ana tomoyao yakayakasisili, Yeoba kwatobalan yo wakawatoki esana tabutabuna koina. ");
INSERT INTO tteo_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Ana munamunai imiyamiya sauga kubwakubwana na ana mulolo imiyayai. Boniyai koina matalilo sididi na yaliyaya malala koina ilawanama. ");
INSERT INTO tteo_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Yagu miya namwanamwana koina yawaloba, “Nige sowasowana yabeku.” ");
INSERT INTO tteo_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","O Yeoba, kowa kunamwanamwa koliyau yo kutolo-kaukausiyau besiele nume kaikaiwena koya pwatana mena. Na kabo muli mena kubomayoi ukeno-wadam koliyau kabo yamatausi lalakina. ");
INSERT INTO tteo_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","O Yeoba, yayoga koliwo, yakawanoi koliwo sagu kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","Tawae kana namwanamwa tem yalobi salai mena yo yaboita? Gubesi, toboita sowasowali sitobalanagiwo? Na sowasowana am namwanamwa siwalo-masalan? ");
INSERT INTO tteo_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Yeoba, kubenalagau, ukwate-kamkamna-yagau na kusaguiyau. ");
INSERT INTO tteo_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Yagu nuwanae kubui-keile ilau selo yaliyaliyayana koina yo yagu nuwapolowe ukele-gabaenako na yaliyaya koina kuyatakikilagau. ");
INSERT INTO tteo_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Mwa nige sowasowana yamwanou, kani yawali-tobali koliwo. Yeoba kowa yagu Yaubada, kani yagu kawatoki yaeyawa nige ana kaba mwawasi. ");
INSERT INTO tteo_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","O Yeoba yalaoma koliwo na kutolo-kaukausiyau, tabu kutatalam sikakaiwe-gabaegau na yamwamwalimwaline. Kuleboyau kaiwena kowa mumugam idudulai. ");
INSERT INTO tteo_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","3","Tenam kuyawali koliyau na kuleboyau mwayamwayau. Kuyamala yagu veku totolo-kaukausiyau, kuyamala yagu nume kaikaiwena kaba kelolon yo kaba lebo na kubaguna-yagau besiele am waloyameli. ");
INSERT INTO tteo_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Sipwasipwa sipei wadam kaiwegu koina kuleboyau kaiwena kowa kagu tosagu kaikaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","O Yeoba, nimam mena yaluyaluwagu yapei, kani ukele-yavivilayauma yoi kaiwena kowa walo yawasosi kana Yaubada. ");
INSERT INTO tteo_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Kowa yaubada mwakomwakotali kali topwalouyao ukalomagigi-lagili, na yau yameliyagiwo. ");
INSERT INTO tteo_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Kani yayaliyaya yo yatobalanagiwo am mulolo miyamiya yaina kaiwena. Yagu kamkamna ugitagitai yo yagu miyapolowe ukwatai. ");
INSERT INTO tteo_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Nige kutatalam na kau kaleyayao sikakabi-kalatagau na iyamo kutalamwagau toweya koina nuwanuwagu yalau kani yalau. ");
INSERT INTO tteo_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","O Yeoba, ukwate-kamkamna-yagau kaiwena yagu miya ipolowe, yavalavalam mangu sikamkamna, kamnagu inae yo yogu ibelusosi. ");
INSERT INTO tteo_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Me yagu nuwanae sauga imamalawe kabo yogu isawosawowoli. Yagu valam yawasigu iyakubwa. Yagu polowe meuloili kolili yogu ibelu yo besiele tuwatuwagu sigiligili yo sibelu. ");
INSERT INTO tteo_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Kau kaleyayao meuloili sisinaliyau na lalakisosinaele kaukavao saligu mena tomiya. Siya analiyao sikataiyau simatausagau yo saugana tem sigitaiyau yalaulau kamwasa mena siyabubu. ");
INSERT INTO tteo_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Meuloili sinuwa-mwatainagau besiele yau yaboitako mwa yau besiele ginauli bwagabwaga sigabaen. ");
INSERT INTO tteo_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Kau kaleyao ali balamumu kaiwegu yabenabenalan mwa matausi iyatakikilagau. Siloiloina kagu unuyamate kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Na Yeoba yameliyagiwo, kaiwena kowa yagu Yaubada. ");
INSERT INTO tteo_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Yau sauga meuloina yamiyamiya am gite-kalatan luwana mena, kuleboyau kau kaleyao kolili siya mwa siyakamkamna-yau. ");
INSERT INTO tteo_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Me am katekamkamna manim ilau am topaisowa koina, am mulolo miyamiya yaina koina kuleboyau. ");
INSERT INTO tteo_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","O Yeoba, yayoga koliwo. Tabu kutatalam yamwalimwaline, na siya toyauyaule kuyamwalimwalineli na simwanou na silobi boita dedeina koina. ");
INSERT INTO tteo_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Kuyamwanouli siya tomwakomwakotao yo siya togagasa yo siya toedeedede bwagabwaga todudulai kolili siwalowalo sinasinalili. ");
INSERT INTO tteo_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Ginauli namwanamwasosili kupeili am lakawa koina siya siyakasisi-yagiwo kaiweli. Kaiwena tomo meuloili sikataiyako mumugam inamwanamwasosi yo siya ali meli sipei koliwo kutolo-kaukausili. ");
INSERT INTO tteo_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Manim lolonna koina am tomoyao kuwadamli kisi tomo ali kalomagigili silobai. Ali kaba keno-wadam kuwolegili na sikeno-wadam kisi kali kaleyao sisinalili. ");
INSERT INTO tteo_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Yeoba tatobalan, kaiwena saugana kau kaleyao siyatakikilagau sitonan tem siunuiyau ana mulolo ilalakisosi iyakenayagau. ");
INSERT INTO tteo_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Yamatausi yabatoko ipei-suwalagauko manna mena, na iyamo yagu valam ibenalan saugana yayoga sagu kaiwena koina. ");
INSERT INTO tteo_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Komiu tomeliwo meuloimiu, Yeoba kwamulolo koina. Yeoba tomeline isaguili na siya togagasa maisa polopolowe-sosina iwolegili. ");
INSERT INTO tteo_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Komiu meuloimiu kwasanasana Guyau kaiwena, wakaiwe yo me ami katepatu. ");
INSERT INTO tteo_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Iya tomone ana pwanoli Yeoba inuwatu-pwaikili, ana naenaena isoke-gabaenako, iyaliyaya. ");
INSERT INTO tteo_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Yo tomone iya nige Yeoba ana yakewa yabo ilolobai yo mwakota mumugana nige imiyamiya koina, iya iyaliyaya. ");
INSERT INTO tteo_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Saugana yagu naenaena nige yawawalo-masalagili yogu ikamkamna yagu valam kaliyate meuloina kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Yeoba, kaliyate yo boniyai kuyakamkamna-yau kabo yagu kaiwe meuloina imwawasi besiele wabumali dabwelo ana kaiwe mena igabu-labwalabwa. ");
INSERT INTO tteo_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Kabo yagu naenaena yawalo-masalagili koliwo, nige yabo yawawadam. Mwa yagu naenaena meuloili kunuwatu-pwaikili. ");
INSERT INTO tteo_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Kabo sowasowana am tomoyao yakayakasisili sikawanoi koliwo ali sauga miyapolowe kolili na mesabana tabu sigagalomwasi naenaena yalubwasina koina. ");
INSERT INTO tteo_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Kowa yau kaba keno-wadam, kani kuleboyau yagu sauga miyapolowe koina. Kani kainagu lalakina koina yawali am leboyau kaiwena, kaiwena kowa kutolo-kaukausiyau. ");
INSERT INTO tteo_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Yeoba iwaloba, “Kani am kamwasa namwanamwana yayakenayagiwo na ilonamwa-yagiwo koina kulau, yo sauga meuloina yagite-kalatagiwo yo yayakenayagiwo mangu mena. ");
INSERT INTO tteo_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Tabu kowa besiele osi o donki yauyaulena siya sauga meuloina maina kaba eyaisi koina siloiloina-yagili.” ");
INSERT INTO tteo_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Toyauyaule kani sikamkamna, na siya analiyao ali meli sipei Yeoba koina kani sagu silobai ana tolo-kaukausili ana mulolo miyamiya yaina koina. ");
INSERT INTO tteo_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Komiu analiyao katemiu sikapwa me ami yaliyaya Yeoba ana paisowa kaiwena, me ami yaliyaya kwawui esana mena. ");
INSERT INTO tteo_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Komiu mumugamiu sidudulai, Yeoba ana paisowa kaiwena kwawui me ami yaliyaya. Komiu ana walo meuloina kwaobigaili kwatobalan. ");
INSERT INTO tteo_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Yeoba kwatobalan api koina yo kwawali koina kaba venu mekali maina kolili. ");
INSERT INTO tteo_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Wali waluwaluna kwawaliyan koina, ami sonoga koina api kwavenuwan yo kwawui me ami yaliyaya lalakina. ");
INSERT INTO tteo_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Yeoba ana walo meuloili siya walo yawasosi yo sowasowana ana paisowa meuloina koina tameliyan. ");
INSERT INTO tteo_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Tomo siya dudududulaili yo kateliyao sikapwa Yeoba imuloloili yo ana mulolo nige sowasowana imwawasi yanuwa yaulina iloyapowon. ");
INSERT INTO tteo_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Yeoba ana walo koina bulibuli iyamayale na dabwelo, waikena yo utu meuloili iyamayaleli ana walo koina. ");
INSERT INTO tteo_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Kalita meuloili ikele-gogonanama dedei kaigeda koina igwaui, yo dumwakali ikalaili yo ipeili ana lakawa mena. ");
INSERT INTO tteo_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Komiu tomo yanuwa yaulina me ami matausi Yeoba koina yo kwayakasisi-yan. ");
INSERT INTO tteo_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Ana walo koina yanuwa yaulina iyawatagili, ginauli meuloili iyamayaleli ana loina koina. ");
INSERT INTO tteo_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Kaba loinao uloili, siya nige Yeoba simemeliyan, ali loina iula-wenowenoili, iyamwanouli ali nuwanuwatu kolili. ");
INSERT INTO tteo_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Na iya ana loinao simiyayai, ana nuwanuwatu simiyamiya sauga meuloina. ");
INSERT INTO tteo_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Na siya yanuwane tomonliyao sipwalopwalou Yeoba Yaubada koina siyaliyaya kaiwena igite-sipwaili siyamala iya ana tomoyao. ");
INSERT INTO tteo_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Yeoba bulibuli mena igite-lobima yo tomo meuloili igitagitaili. ");
INSERT INTO tteo_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Ana kaba miya wasawasana koina siya tomiya yanuwa yaulina imanmankulakulaili. ");
INSERT INTO tteo_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Kateliyao iyamayaleli mwa ali paisowa meuloina sipaipaisowaili ikataili. ");
INSERT INTO tteo_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Kaleya ana dedei koina, kin nige ana tokaleyayao ali kaiwe koina mwa ibaguna na Yeoba ana talam kaiwena mwa kinne ibaguna. Besiele tabe, tokaleya yabo nige iboma ana kaiwe koina ibabaguna na Yeoba ana talam koina ibaguna. ");
INSERT INTO tteo_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Tabu ami meli kwapepei kaleya osina kolili, bwagana sikaiwe yo sisagenasosi kani nige sileleboimiu. ");
INSERT INTO tteo_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Siya analiyao Yeoba simatausan yo ali meli sipei ana mulolo miyamiya yaina koina igite-kalatagili, ");
INSERT INTO tteo_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","boita mena ileboili yo sauga guliyam kolili iyakanli. ");
INSERT INTO tteo_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Yaluyaluwala sisanasana Yeoba kaiwena, kaiwena iya kala totolo-kaukausi yo ala ebeu. ");
INSERT INTO tteo_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Tayaliyaya iya kaiwena yo ala meli tapei esana yakayakasisina koina. ");
INSERT INTO tteo_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","O Yeoba, kakawanoi koliwo am mulolo miyamiya yaina imiyamiya kolimai kaiwena me ama katepatu kasanasanaiwo. ");
INSERT INTO tteo_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Deibida ikabaleya mwakomwakota na mesabana Abimeleki Deibida itawoi ilowasi Yeoba koina yakawatoki sauga meuloina, kana tobali gamwagu mena kani nige yalolopei. ");
INSERT INTO tteo_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Ana paisowa meuloina kaiwena kani yatobalan. Sowasowana siya analiyao sikamkamna walo bwaite sibenalan na siyaliyaya. ");
INSERT INTO tteo_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Kwalaoma komiu te yau Yeoba ana kaiwe tatobalan na meuloila esana takeleisinan. ");
INSERT INTO tteo_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Yakawanoi Yeoba koina mwa kainagu iyamaisa yo yagu matausi meuloina koina ilivasiyau. ");
INSERT INTO tteo_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Siya analiyao tokamkamna sigitelau koina sagu kaiwena kani siyaliyaya lalakina, nige sowana simwalimwaline. ");
INSERT INTO tteo_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Yau tobubutuma yavalam koina na kainagu ibenalan yo ileboyau yagu miya polowe kolili. ");
INSERT INTO tteo_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Siya analiyao Yeoba siyakasisi-yan ana anelose ipei na igite-kalatagili yo ileboili kaba silae kolili. ");
INSERT INTO tteo_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Ami meli kwapei Yeoba koina na ana namwanamwa wagitai. Iya ikeno-wadam koina kani iyaliyaya. ");
INSERT INTO tteo_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Kwapwalou Yeoba koina komiu tomo meuloimiu, siya analiyao siobigai kani ginauli meuloina sowasowali. ");
INSERT INTO tteo_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Yakayakan meuloili yo tabe laiyon kaikaiweli guliyam silobai, na siya analiyao Yeoba siobigai nige sowasowana ginauli namwanamwana yabo koina sideva. ");
INSERT INTO tteo_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Natuguwao kwalaoma na kwabenali koliyau na yayakataimiu Yaubada kana matausi kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Nuwanuwamiu miya namwanamwana kwalobai? Nuwanuwamiu yaliyaya wakalapowon yo ami miya imamalawe? ");
INSERT INTO tteo_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Kabo memenamiu kwanuwaili naenaena koina yo sopamiu kwayakasisi-yagili walo mwakomwakota kolili. ");
INSERT INTO tteo_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Naenaena kwalogabaen yo paisowa namwanamwana waginauli, nuwadaumwali kwaloyai katemiu meuloina koina. ");
INSERT INTO tteo_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Siya todudulai Yeoba manna ilaulau kolili yo ali valam ibenalagili, ");
INSERT INTO tteo_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","na siya analiyao paisowa naenaena siginaginauli isikotanagili, mwa tem siboita kani mwayamwayau tomo nuwali imwatainagili. ");
INSERT INTO tteo_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Yeoba todudulai ali valam ibenalan kabo ileboili ali miyapolowe meuloili kolili, ");
INSERT INTO tteo_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","yo imiyamiya tonuwanae salili mena yo siya tomo tonuwa-belubelu yo yaluyaluwaliyao sibelu ileboili. ");
INSERT INTO tteo_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Tomo namwanamwaliyao miyapolowe sibaibaiwa silobaili na Yeoba ileboili ali miyapolowe meuloili kolili, ");
INSERT INTO tteo_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","kaiwena Yeoba igite-kalatagili silae kolili mwa nige sowasowana tuwatuwali kaigeda kani itagolu. ");
INSERT INTO tteo_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Toyauyaule kani sibomayoi sisilae yo siya analiyao todudulai sikalomagigi-lagili kani kali maisa silobai. ");
INSERT INTO tteo_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Na iyamo Yeoba kani ana tomoyao ileboili, siya analiyao silau koina sikobwau yo sikeno-wadam kani nige ana munamunai silolobai. ");
INSERT INTO tteo_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","O Yeoba, siya sikaleya koliyau ukwaleya kolili. ");
INSERT INTO tteo_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Am gogo kaleya kwamana kulikwa yo am ebeu ukwalai na kutolo saligu mena kusaguiyau. ");
INSERT INTO tteo_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Am wamali kuniwisi yo kaleya kilamna ukwalai na siya totawoiyaune kumiya-kausili na kuwaloyameli kani kuleboyau. ");
INSERT INTO tteo_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Sowasowana siya analiyao sitonatonan yakato siunuiyau Yeoba iunuili na simwalimwaline. Sowasowana siya analiyao siloiloina yakato siunuiyau ibui-keileli nuwaliyao sipwanopwano. ");
INSERT INTO tteo_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Sowasowana siya siyamala besiele mosomoso na yaumai iyui-kalaili na Yeoba ana anelose itawoili. ");
INSERT INTO tteo_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Sowasowana ali kamwasa Yeoba iula-boniboniyai yo isanesanene na ana anelose ikoya-bekuli. ");
INSERT INTO tteo_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Nige ali yai ipapagan na sipwasipwa sipei kaiwegu, na gula sikeli na tem silokalatagau. ");
INSERT INTO tteo_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Na sipwasipwa sipepei wadamne kani sibomayoi koina sisipwa na sisilae kabo nuwali simayale. ");
INSERT INTO tteo_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Kabo yau kani yayaliyaya Yeoba koina ana leboyau kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Kategu mena kani yawaloba, “Yeoba nige yabo besiele kowa, kaiwena tobeluwo kusaguili tokaiweyao kolili, yo tobubutumao kutolo-kaukausili kali toyakamkamnao kolili.” ");
INSERT INTO tteo_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Tomo naenaeli sitolo ginauline naenaeline nige yakakataili koina siyakewaiyau. ");
INSERT INTO tteo_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Namwanamwana yapaisowai kolili na siya siyamaisayama naenaena, mwa yau yasalili nuwanae lalakina koina. ");
INSERT INTO tteo_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Na yau saugana ali kasiebwa ipolowe me yagu nuwalubu yo nige yakekekan. Yo saugana yakawanoi kaiweli yapwalou me yagu nuwalubu. ");
INSERT INTO tteo_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Yakawakawanoi kaiweli besiele yakato yagu eliyam o kaukava yabo kaiwena. Yalolokeikeile me yagu lopwalou yayakasisi meyagu nuwanae besiele tem sinagu kaiwena yanuwanae. ");
INSERT INTO tteo_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Na saugana tem naenaena yalobai sitolo-takikilagau na sitalatalawasi-yagau. Yo tomo siya nige yakakataili silaoma na sikawakawa-naenae-yagau nige silolopei. ");
INSERT INTO tteo_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Ali talatalawasi inaesosi na simanman-kulakulaiyau me ali soka. ");
INSERT INTO tteo_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","O Yeoba, kani toweya kana mamalawe besiele am mankulakula? Kulaoma kuleboyau ali munamunai koina kaiwena siya besiele laiyon sokasokali. ");
INSERT INTO tteo_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Kabo kani yatobalanagiwo yo yakawatoki koliwo am tomoyao ali miyagogo koina. ");
INSERT INTO tteo_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Siya kau kaleyayao mwakomwakotali tabu kutatalamwagili sigagasa na siyaliyaya yagu belu kaiwena. Na siya sikalomagigi-lagau nige yaina yabo ipapagan tabu kutatalamwagili simalu me ali nuwasaesae yagu nuwanae kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Ali edeedede meuloina nige yabo daumwali edeededena, bwai sietaetalapili mwakomwakota tokabi-yanuwadaumali tomonliyao kaiweli. ");
INSERT INTO tteo_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Siyakewaiyau na siyoga kainali lalakina koina siba, “Kai kagitai tawae kupaisowai.” ");
INSERT INTO tteo_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Na kowa Yeoba, mumugali ugitaiyako, na tabu kumwamwanou yo tabu kumimiya-suwala koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Kumwasali na kutolo yo kuedeedede kaiwegu kaiwena kowa yagu Yaubada. ");
INSERT INTO tteo_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","O Yeoba, kowa mumugam dudulaina kabo kuwalo-masala nige yagu naenaena ipapagan, na kau kaleyayao tabu kutatalamwagili sigagasa na siyaliyaya yagu belu kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Tabu kutatalamwagili na kateli mena siwawalo siba, “Tasibayanaeyako, ala nuwatuwa talobaiyako.” ");
INSERT INTO tteo_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Sowasowana siya yagu kamkamnane kaiwena siyaliyaya Yeoba ikaiwe-gabaegili yo nuwaliyao iula-pwanopwanoli. Siya siwawalo yakato sinamwanamwasosi kabo yau sowasowana Yeoba iyamwalimwaline yawasosili. ");
INSERT INTO tteo_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Siya kagu tosaguwo nuwanuwali sigitai yabaguna yagu yatala koina sowasowana me ali yaliyaya siwuiwui sauga meuloina siwaloba, “Yeoba iya tolalaki yo iyaliyaya ana topaisowa ana baguna kaiwena.” ");
INSERT INTO tteo_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Kabo mumugam dudulaina kaiwena kani yawalo-masala yo kaliyate meuloina koina yatobatobala-nagiwo. ");
INSERT INTO tteo_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Naenaena ibalamumu toyauyaule katena kalona mena kabo nige ali matausi yabo Yaubada kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Iya nuwana mena ibomayoi ikeleisinan yo ibatoko Yaubada kani nige ana lopwano ilolobai yo kani nige ikakawa-naenaeyan. ");
INSERT INTO tteo_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Ana edeedede meuloina mwakota yo naenaena sikalapowon, nige sowasowana me ana katai yo nige sowasowana paisowa namwanamwana iginauli. ");
INSERT INTO tteo_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Ana kaba keno mena ikenokeno na nuwatu naenaeli meuloili inuwanuwatuili, nige ginauli yabo dudulaina ipapaisowai. Nige sowasowana naenaena yabo isikotanan. ");
INSERT INTO tteo_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","O Yeoba, am mulolo miyamiya yaina isae bulibuli ilobai, am walo yawasosi isae yaloyaloi kolili. ");
INSERT INTO tteo_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Am namwanamwa isae besiele koya lalakili, yo am loina kana dudulai nige sowasowana kaliyei kaiwena iya besiele dumwakali ana lobi kana mamalawe nige sowasowana kaliyei. Tomo yo yakayakan meuloili simiyamiya am gite-kalatan kalona mena. ");
INSERT INTO tteo_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","O Yaubada, am mulolo miyamiya yaina ginauli saesaesosina. Kai pepem lolonna mena kakobwau na ugite-kalatagimai. ");
INSERT INTO tteo_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Kan imasumasuwe kuyelima kolimai kakekan diyamai sisu yo kutalam waila kanuma am namwanamwa yalubwasina koina. ");
INSERT INTO tteo_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Kowa yawasi meuloina yaina na am mayale kaiwena kai mayalene kagitai. ");
INSERT INTO tteo_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Siya analiyao sikataiwo kumuloloili sauga meuloina yo siya todudulaili kusaguili. ");
INSERT INTO tteo_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Tabu kutatalam togagasa silaoma siunuiyau yo tabu kutatalam toyauyaule sitatawoiyau. ");
INSERT INTO tteo_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Wagitaili toyauyaule siyaele sibekuko sikenokeno, nige sowasowali sitoloyoi. ");
INSERT INTO tteo_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Tabu kunuwanuwatu tonaenaeli kaiweli, yo siya mumugana naenaena sipaipaisowai tabu kulalamwa-polowe-yagili. ");
INSERT INTO tteo_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Sauga kikiunamo kani sikwalalele besiele kawasi leleyanna yo siweweka na siboita. ");
INSERT INTO tteo_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Yeoba koina kumeli na kupaisowa namwanamwa na kumiya namwanamwa yanuwane koina. ");
INSERT INTO tteo_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Tabe kowa kuyaliyaya Yeoba koina na katem ana kawanoi iyamaisa. ");
INSERT INTO tteo_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Kuboma kuwolegiwo Yeoba koina, na kumeliyan na kani isaguiwo. ");
INSERT INTO tteo_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Am namwanamwane kani ipaisowai na ilala besiele kala-pwasinasina dabwelona. ");
INSERT INTO tteo_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Me am kalakisiye kusanasana Yeoba ana mwasali kaiwena. Yo tabu kunuwanuwatu siya tonaenaeli mwakota koina siwasawasa yo siya ali nuwatu kanna silobai kamwasa naenaena koina. ");
INSERT INTO tteo_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Munamunai kulopei yo katewakaka kusikotanan kaiwena siya labuine kani silawagimiu naenaena koina. ");
INSERT INTO tteo_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Siya analiyao Yeoba simeliyan yanuwa kani sikalai. Na siya tonaenaeli kani sitawoili. ");
INSERT INTO tteo_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Sauga kubwakubwana koina tonaenaeli kani nige simiyamiya, kani kuloyaili na iyamo kani nige kulolobaili. ");
INSERT INTO tteo_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Siya tonuwalobi kani yanuwa sikalai, na wasawasa, yaliyaya yo daumwali silobai. ");
INSERT INTO tteo_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Tonaenaeli sinuwanuwatu tem todudulai siunuyamateli yo me ali munamunai sikalomagigi-lagili. ");
INSERT INTO tteo_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Na Yeoba tonaenaeli imalumalu-wagili kaiwena ikatai sauga kikiunamo isibayanaeli. ");
INSERT INTO tteo_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Tonaenaeli ali kaleya kelepana siniwisili yo ali gipoyo simomosili na tem tobubutumao yo tomiya-polowe, siya ali paisowa idudulai, yakato siunuili. ");
INSERT INTO tteo_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Na iyamo sibomayoi ali kaleya kelepana koina kani sisakonali yo ali gipoyo Yeoba kani igoluli. ");
INSERT INTO tteo_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Todudulai ana gogo kikiunane inamwanamwasosi kabo tonaenaena ana gogo wasawasa meuloina, ");
INSERT INTO tteo_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","kaiwena Yeoba kani tonaenaeli ali kaiwe ikele-gabaen na todudulai isaguili. ");
INSERT INTO tteo_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Yo siya analiyao Yeoba siobigai kani igite-kalatagili yo yanuwane kani iyamala ali gogo miyamiya yaina. ");
INSERT INTO tteo_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Sauga miyapolowe kolili kani nige sikakamkamna, na sauga guliyam koina kani sowasowali. ");
INSERT INTO tteo_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Na toyauyaule kani siboita, Yeoba kana kaleyayao kani sikwalalele besiele mula ule bwagabwaga mena, yo besiele bogau isae ikwalalele siya tabe kani sikwalalele. ");
INSERT INTO tteo_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Toyauyaulene bwaite mumugali besiele, tawae sikalai nige sowana siyamaisa-yapileyoi, na siya tomo namwanamwali siyauya me kate sokesokeli. ");
INSERT INTO tteo_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Siya analiyao Yeoba iwalo-muloloili kani yanuwa sikalai, na siya analiyao ikawa-gulaili kani itawoili. ");
INSERT INTO tteo_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Yeoba tomo namwanamwana ana kamwasa iyakenayan, yo siya analiyao ali paisowa koina sikabi-yaliyaya-yan igite-kalatagili. ");
INSERT INTO tteo_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Tem sibeku kani nige sibebeku silolobisosi, na Yeoba kani nimana iyagayan ikabi-kalatagili ikeleisinagili. ");
INSERT INTO tteo_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Sauga bwaite yatautaubala, yamiya sauga imamalawe na nige sauga yabo yagitai Yeoba tomo namwanamwana yabo ilologabaen. Yo nige sauga yabo yagitai tomone natunao sibubutuma molosi. ");
INSERT INTO tteo_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Tomo namwanamwana mumugana bwaite besiele, sauga meuloina iyauya bwagabwaga yo ana gogo italamwagili tomo kolili yo natunao ali paisowa siyamala ana kaba yaliyaya. ");
INSERT INTO tteo_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Naenaena kwalogabaen na namwanamwana koina kwapaisowa kabo tubumiyao simiya namwanamwa yo simiyayai yanuwane koina. ");
INSERT INTO tteo_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Kaiwena Yeoba imulolo tawae inamwanamwa yo nige sowasowana ana tomoyao ilogabaegili. Sauga meuloina igite-kalatagili, na siya analiyao susu naenaeli itawoili silowasi. ");
INSERT INTO tteo_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Na siya todudulai kani yanuwa sikalai na koina simiyayai. ");
INSERT INTO tteo_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Na tomo namwanamwana ana edeedede koina me ana katai, yo sauga meuloina ana loinao sidudulai yo sitoyatoyawa. ");
INSERT INTO tteo_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Yaubada ana loina katena mena imiyamiya sauga meuloina yo nige sowasowana loinane ilikwai. ");
INSERT INTO tteo_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Tomo naenaena tomo namwanamwana imanman-kulakulai na kamwasa inuwanuwatui tem iunuyamate. ");
INSERT INTO tteo_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Na Yeoba kani nige tomo namwanamwanane itatalamwan kana kaleya ana kaiwe koina, yo kani nige itatalam sikakawa-naenae-yan ana yatala koina. ");
INSERT INTO tteo_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Kwasanasana Yeoba kaiwena na ana kamwasa koina kwamiyamiya, kabo ikeleisinagimiu na yanuwane iyeyawa yo tonaenaeli wagitaili itawoili. ");
INSERT INTO tteo_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Sauga yabo mena toyauyaule yabo yakatai iya mumugana bwaite besiele, sauga meuloina ana loina sikololo, yo iya tomo saliyana malamalawena na ana mamalawe besiele Lebanon ali mayau kaikaiwena ana mamalawe. ");
INSERT INTO tteo_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Na muli mena yalaoma yalau iya nigele bwaine koina, yaloyai na nige yalolobai. ");
INSERT INTO tteo_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Komiu tomo meuloimiu, tomo namwanamwanane wagitai, mumugana kwamankulakulai. Tomo daudaumwalina kani mumuganane iyapanaisan natunao kolili, ");
INSERT INTO tteo_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","na siya tonaenaeli kani sisilae yawasosi yo natuliyao besiele. ");
INSERT INTO tteo_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Yeoba todudulai ileboili yo igite-kalatagili sauga naenaena kolili. ");
INSERT INTO tteo_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Isaguili yo ikele-yavivilalima, yo ileboili tonaenaeli kolili, kaiwena silau koina na itolo-kaukausili. ");
INSERT INTO tteo_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","O Yeoba, tabu kuyayamaisa-yau am munamunai koina. ");
INSERT INTO tteo_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Am gipoyo yogu sisakona silusae yakamkamna lalakina yo am unuiyau nimam mena koina yabeku. ");
INSERT INTO tteo_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Am munamunai kaiwena kamkamna lalakina yalobai yo yogu meuloina ikasiebwa lalakina yagu pwanoli kaiweli. ");
INSERT INTO tteo_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Yagu pwanoli sipolowesosi koliyau kikiunamo yasalili yagalomwasi yagu pwanoli yalubwasina koina. ");
INSERT INTO tteo_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Yagu yauyaule kaiwena kagu baliyan sibowa yo sipwasa bwalaili sinae. ");
INSERT INTO tteo_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Dagelagu iyou yau kaiwe meuloina imwawasi yo kaliyate meuloina me yagu yaba yalolokeikeile. ");
INSERT INTO tteo_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Yogu iwedowedoli kasiebwa kaiwena kikiunamo yaboita. ");
INSERT INTO tteo_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Kamnagu inae molosi yo nige yagu kaiwe yaboyoi. Yayabayaba kategu ana kamkamna kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","O Yeoba, yagu nuwatu ukwatailiko yo yagu yaba meuloili kubenalagili. ");
INSERT INTO tteo_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Kategu iwakaka yo yau kaiwe imwamwawasi, mangu iganuganu mayalena ikwalaleleko. ");
INSERT INTO tteo_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Yagu eliyamwao yo kaukavao silosuwala koliyau kaiwena kau kasiebwa simatausan yo tabe yagu susuyao genuwali silaoma siboeyagau. ");
INSERT INTO tteo_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Siya analiyao nuwanuwali siunuyamateyau ali sipwasipwa sikatukatububu-nagili kaiwegu, yo siya nuwanuwali siyakamkamna-yau ali walo mena siula-matamatausagau siwalo kani sisibayanaeyau. Yagu silae kaiwena sinuwanuwatu sauga meuloina. ");
INSERT INTO tteo_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Yau besiele totenakola nige sowasowana yabenali, nige sowasowana yaedeedede yau besiele memenagu ipolowe. ");
INSERT INTO tteo_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Yapaisowa besiele totenakola yo gamwagu ipatu genuwagu kainali yayamaisa. ");
INSERT INTO tteo_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Na iyamo yagu meli yapei Yeoba yagu Yaubada koliwo, na kowa kani kuyamaisa koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Tabu kutatalam kagu tokaleyayao sigagagasa-likwaiyau yagu kamkamna yo yagu beku kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Kikiunamo yabeku, yagu kamkamna iyaele imiyamiya koliyau nige ilolopei. ");
INSERT INTO tteo_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Yagu pwanoli yawalo-masalagili, siya siyamala yagu katewakaka. ");
INSERT INTO tteo_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Kagu tokaleyayao siya sinamwanamwa yo sikaiwe, sibaibaiwa sikalomagigi-lagau nige yaina ipapagan. ");
INSERT INTO tteo_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Siya naenaena siyeyama namwanamwana kaiwena sikalomagigi-lagau kaiwena yatotolo mumugana namwanamwana koina. ");
INSERT INTO tteo_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","O Yeoba yagu Yaubada, tabu kulologabaegau yo tabu kutotolo-suwala koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","O Yeoba kagu Tolebo, kulomwayamwayauma na kusaguiyau. ");
INSERT INTO tteo_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Saugana toyauyaulene yamiyamiya luwali mena kabo yabomayoi koliyau yawaloba, “Kani yagu paisowa yagite-kalatan yo tabu yalolopwano yagu edeedede koina. Kani yamwanou saugana toyauyaule saligu mena.” ");
INSERT INTO tteo_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Mwa yapaisowai besiele, nige yaedeedede yo nige walo yabo yawawalowen yo nige ginauli namwanamwana yabo kaiwena yaedeedede. Na iyamo yagu katewakaka ilalaki isaesae. ");
INSERT INTO tteo_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Tawae yanuwatui yau katewakaka mekanakava ilalaki ilaulau. Yagu nuwatu kategu mena iwedowedoli besiele mayau mwa yaedeedede yawaloba, ");
INSERT INTO tteo_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","“Yeoba, toweya yagu miya kana mamalawe besiele? Toisabo sauga kani yaboita? Yawasigu kana mamalawe kuwalo-masalan. ");
INSERT INTO tteo_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Manim mena yawasigu meuloina iyamala ginauli bwagabwaga, ikubwasosi. Walo yawasosi, tomo meyawasina kaigeda kaigeda besiele yawasi kana yui-gabaen. ");
INSERT INTO tteo_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Tomo yawasina besiele lolonna. Ana paisowa meuloina ginauli bwagabwaga, ana gogo wasawasa ikalakalaili na nige ikakatai analiyao kani sikalaili. ");
INSERT INTO tteo_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Kabo Yeoba, tawae yasanasanai me yagu katepatu? Kabo yagitelaowa koliwo me yagu katepatu. ");
INSERT INTO tteo_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Kuleboyau yagu naenaena meuloina koina yo tabu kutatalam totalawasi sitatalawasi-yagau. ");
INSERT INTO tteo_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Kani yamwanoumo, nige sowasowana walo yabo yawalowen, kaiwena kowa mwa uginauliyau yakamkamna besiele bwaite. ");
INSERT INTO tteo_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Besi, tabu kisi kuyakamkamna-yau yoi. Kikiunamo kani yaboita am unu koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Saugana tomo yabo naenaena iginauli baguna kuyokoiyan tabe tem ana gogo namwanamwali imulolo lalakina kolili kani kusibayanaeli besiele naya ali paisowa sipaisowa mwanoumo na ala gogo sisibayanaeli. Walo yawasosi, tomo meyawasina kaigeda kaigeda besiele yawasi kana yui-gabaen. ");
INSERT INTO tteo_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","O Yeoba, yagu kawanoi yo yagu valam kubenalagili, saugana matalilogu sididi kulaoma kusaguiyau. Besiele tubuguwao, yau besiele kam taumana sauga kubwakubwana kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Manim kupei-suwalan koliyau na mesabana yagu katewakaka ilopei na yayaliyaya yoi na yalau yaboita.” ");
INSERT INTO tteo_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Yasanasana meyagu kalakisiye Yeoba ana sagu kaiwena, kabo tenana iyawali yo yagu valam ibenalan. ");
INSERT INTO tteo_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Itabe-isinagau gula kaba silae koina, bwalabwala sopusopuna koina ikeleisinagau. Yo ipeiyau veku pwatana mena yo igite-kalatagau. ");
INSERT INTO tteo_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Iyakataiyau wali waluwaluna yawaliyan, bwaimwa wali-tobali yabo Yaubada koina. Tomo sibaibaiwa ana paisowa kani sigitai yo kateli sipitali na ali meli sipei Yeoba koina. ");
INSERT INTO tteo_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Siya analiyao ali meli sipei Yeoba koina siyaliyaya. Kaiwena kani nige silalau sipwapwalou kokotomo kolili yo kani nige silulusae bodane siya sitapwatapwalolo yaubadao mwakomwakotali kolili. ");
INSERT INTO tteo_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","O Yeoba yagu Yaubada, ginauli sibaibaiwa kupaisowaili kaiwemai, nige yabo yaubada besiele kowa. Am nuwatu kaiwemai sibaibaiwasosi mwa nige sowasowana yayasilili yo nige sowasowana meuloili yawalo-masalagili. ");
INSERT INTO tteo_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Kowa genuwam yakayakan yo witi gabugabuli kapwaoliyagili koliwo, genuwam yakayakan kagabu wolili kaba pwaoli koina yo genuwam yakayakan kapwaoliyagili ama pwanoli kaiweli. Na tenagu kuyelima na kolili am walo yabenalan. ");
INSERT INTO tteo_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Kabo yawaloba, “Yau elete, am loina kaiwegu iyaele am loina bukina koina.” ");
INSERT INTO tteo_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Yagu Yaubada, am nuwatu kana paisowa yau kaba yaliyaya, kaiwena am loina iyaele kategu mena. ");
INSERT INTO tteo_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","10","Am tomoyao ali miyagogo koina am lebo wasana namwanamwana yayawasayan kolili. Ukwataiyako nige yalolopei kana walo-masala. Nige lebo wasana yabo yawawadam koliyau, na am waloyameli kana kabi-kalatan, am sagu yo am mulolo miyamiya yaina sauga meuloina yaedeedede-yagili. ");
INSERT INTO tteo_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","O Yeoba, yakatai am katekamkamna koliyau kani nige kulolopei. Am mulolo yo am walo yawasosi kani sigite-kalatagau sauga meuloina. ");
INSERT INTO tteo_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Miyapolowe sibaibaiwa siyatakikilagau, sibaibaiwasosi nige sowasowana yayasilili. Yagu pwanoli sikabi-kalatagau nige sowasowana yagu kamwasa yagitai. Yagu pwanoli sibaibaiwasosi kabo muli mena itogu kana baibaiwa. Yagu katepatu ikwalaleleko. ");
INSERT INTO tteo_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","O Yeoba kusaguiyau yo kuleboyau. ");
INSERT INTO tteo_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Siya analiyao sitonatonan tem siunuiyau kani isibayanae-molosagili me ali nuwapwanopwano, yo siya analiyao siyaliyaya yagu miyapolowe kaiweli kani ibui-keileli simwalimwaline. ");
INSERT INTO tteo_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Siya analiyao sitalatalawasi-yagau kani sikatewakaka saugana sigitai Yeoba ikaiwe-gabaegiliko. ");
INSERT INTO tteo_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Sowasowana meuloili silaowa koliwo siyaliyaya lalakina, yo siya meuloili sikawa-toki koliwo am lebo kaiwena kani sauga meuloina siwaloba, “Yeoba iya tokaiwesosi.” ");
INSERT INTO tteo_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","O Yeoba, yagu kaiwe imwawasi yo yabubutuma, na iyamo nige nuwam imwamwatainagau. Kowa yagu Yaubada yo kagu Tolebo, kulomwayamwayauma na kusaguiyau. ");
INSERT INTO tteo_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Siya analiyao tobubutuma sisaguili kani siyaliyaya kaiwena Yeoba kani isaguili ali miyapolowe saugana koina, ");
INSERT INTO tteo_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","yo itolo-kaukausili yo ileboili meyawasili simiyamiya. Kani ikabi-yaliyaya-yagili ali yanuwane koina yo kani nige ilologabaegili kana kaleyao nimali mena. ");
INSERT INTO tteo_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Yeoba kani isaguili ali kasiebwa kolili na ali namwanamwa iwolena-yavivilayoili. ");
INSERT INTO tteo_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Yawaloba, “Yeoba, yalopwano koliwo na ukwate-kamkamna-yagau yo kuwoisiyau.” ");
INSERT INTO tteo_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Kau kaleyayao walo naenaeli siwalowegili koliyau, nuwanuwali tem yaboita na sinuwa-mwatainagau. ");
INSERT INTO tteo_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Siya silaoma na tem siboeyagau na yau kasiebwa wasana sibenalan na silau sitalawasawasa-yagau tomo meuloili kolili. ");
INSERT INTO tteo_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Siya meuloili sikalomagigi-lagau sibomamo luwali mena sibalabalamumu kaiwegu. Siboma kateli mena nuwatu naenaeli sikabili na tem kolili yasilae. ");
INSERT INTO tteo_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Siwaloba, “Ikasiebwasosi kani nige sowasowana ana kaba keno ilogabaen.” ");
INSERT INTO tteo_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Yagu eliyamwao meuloili sisikotanagau yo tabe iya yagu eliyam namwanamwana, iya yameliyan yo mekaukava kakekan na iyamo itagelakeile nuwanuwana iunuiyau. ");
INSERT INTO tteo_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","O Yeoba, ukwate-kamkamna-yagau, yagu namwanamwa kuyeyamayoi na kagu kaleyayaone yayamaisa-yapileyoi kolili. ");
INSERT INTO tteo_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Yakatai kuyaliyaya kaiwegu kaiwena nige kutatalam kagu kaleyayao sikakaiwe-gabaegau. ");
INSERT INTO tteo_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Kani kusaguiyau kaiwena mumugagu inamwanamwa, mwa ukwalaiyauma sauga meuloina yamiyamiya manim mena. ");
INSERT INTO tteo_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Yeoba tatobalan kita Isileli ala Yaubada. Tatobalan sauga bwaite yo nige ana kaba mwawasi imiyayai. O, besiele. ");
INSERT INTO tteo_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Yakayakan diya galogalona imagu yalubwasi wailana ididididi kaiwena. Bwaine besiele yaluyaluwagu kana lotonan kowa kaiwem Yaubada. ");
INSERT INTO tteo_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Galogalogu imagu kaiwem kowa Yaubada meyawasim. Toisabo sauga koina sowasowana yalau na yapwalou manim mena? ");
INSERT INTO tteo_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Kaliyate yo boniyai matalilogu siyamala kagu. Yo sauga meuloina kagu kaleyayao sineli-yagau siwaloba, “Am Yaubada toweya?” ");
INSERT INTO tteo_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Kategu ikamkamna saugana tem yanuwatu-pileyoi sauga beyabeyana koina kaiwena beyabeyana boda lalakina yabaguna-yagili kalaulau Yaubada ana Nume Tabu koina me ama yaliyaya kawaliwali yo Yaubada esana katobatobalan. ");
INSERT INTO tteo_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Na tawae kaiwena yanuwa-belubelu na nuwagu inae? Kani me yagu katepatu yasanasana na Yeoba ileboyau, kabo kani yatobalan yoi kaiwena iya yagu Yaubada yo kagu Tolebo. ");
INSERT INTO tteo_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","7","Yagu nuwanae ilalaki kabo yanuwatu-pileyoi Yeoba koina. Nuwanae iyawasalima na sibekuma koliyau besiele dibwali yo yalubwasi daguguli nuwagu siulapwanopwano, besiele galewa iyatubu koya Elimon yo Misa kolili yo siyamala yalubwasi lalakina ikapukapusele daguguna ilalau waila Yolidan kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Sowasowana Yeoba ana mulolo miyamiya yaina iyakenayagau kaliyate mena na tem boniyai yawali koina bwaimwa yagu kawanoi iya koina kaiwena iya yawasigu yaina. ");
INSERT INTO tteo_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Kabo yaneli yagu Yaubada koina iya kagu totolo-kaukausi, yawaloba, “Tawae kaiwena kunuwa-mwatainagau? Tawae kaiwena nagamo yakamkamna kagu kaleyayao ali loina polopolowena koina?” ");
INSERT INTO tteo_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Ali kawa-naenae koina yanuwa-belubelu kaiwena sinelineli-samasamalulu koliyau siwaloba, “Am Yaubada toweya?” ");
INSERT INTO tteo_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Na tawae kaiwena yanuwa-belubelu na nuwagu inae? Kani me yagu katepatu yasanasana na Yeoba ileboyau, kabo kani yatobalan yoi kaiwena iya yagu Yaubada yo kagu Tolebo. ");
INSERT INTO tteo_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","O Yaubada, kuwalo-masala nige yagu nae yabo ipapagan, kutolo-kaukausiyau siya nige kam tomeliwo kolili na kuleboyau tomwakomwakota yo tonaenaeli kolili. ");
INSERT INTO tteo_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Kowa yagu Yaubada yo kagu totolo-kaukausi, tawae kaiwena kulogabaegau? Tawae kaiwena nagamo yakamkamna kagu kaleyayao ali loina polopolowena koina? ");
INSERT INTO tteo_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Am mayale yo am walo yawasosi kuyawasayama na sibaguna-yagau sikele-yapileyoi-yauma am koya yakayakasisina Saiyon koina yo am Nume Tabu bwaimwa am kaba miya. ");
INSERT INTO tteo_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Kabo yalau am kaba pwaoli koina, kowa Yaubada yagu yaliyaya yaina. Kani yagu api koina yavenu yo wali-tobali yabo yawaliyan koliwo. O Yaubada, kowa yagu Yaubada. ");
INSERT INTO tteo_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Na tawae kaiwena yanuwa-belubelu na nuwagu inae? Kani me yagu katepatu yasanasana na Yaubada ileboyau, kabo kani yatobalan yoi kaiwena iya yagu Yaubada yo kagu Tolebo. ");
INSERT INTO tteo_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Kola natunao silele O Yaubada, ginauli kaba nuwapwanopwano kupaisowaili tubumayao tomo Isileli ali sauga mena wasana kabenalanako tamamayao kolili. ");
INSERT INTO tteo_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Ama wasa siyeyama am kaiwe koina boda uloiline kusapili kutawoili siyawatagili na am tomoyao tubumayao kuyamiyali bwaine koina sidebalala. ");
INSERT INTO tteo_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Yanuwane nige sikakalai siboma ali kaiwe koina, nige ali kaleya gogoliyao koina sibabaguna, na kowa Yeoba am kaiwe koina mwa sibaguna. Sikataiyako kumulolo kolili yo kusaguili kabo me ali katepatu sikaleya. ");
INSERT INTO tteo_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Kowa yagu Kin yo yagu Yaubada. Kaiwe kuwolegili am tomoyao kolili kaleya koina, ");
INSERT INTO tteo_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","yo besiele am kaiwe koina kama kaleyayao kakaiwe-gabaegili. ");
INSERT INTO tteo_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Na yagu gipoyo yo yagu kaleya kelepana nige yamemeli-yagili na tem sileboyau. ");
INSERT INTO tteo_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Na kowa kama kaleyayao kolili kuleboimai, na kama tokalomagigiliwo ukaiwe-gabaegili. ");
INSERT INTO tteo_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Koinaele katobalanagiwo yo sauga meuloina kakawakawatoki koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Na bwaite sauga kusikotanagimai yo kuyamwalimwalinemai. Kulogabaegimai mwa nige kulalau ama tokaleyayao bodaliyao luwali mena. ");
INSERT INTO tteo_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Kupaisowaimai kayabubu kama kaleyayao kolili, mwa ama gogoyaowa silaoma sikalaili. ");
INSERT INTO tteo_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Kabo kutalamwagimai siunuyamatemai besiele sipi yo kutalam silawagimai yanuwa uloili kolili kamiya. ");
INSERT INTO tteo_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Am tomoyao ugimwala-yagili maisa kikiuna koina, besiele siya ginauli kikiuli kali maisa. ");
INSERT INTO tteo_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Kabo yanuwa salimai mena sigitai tawae uginauli kolimai mwa sitalatalawasi-yagimai kaemala siya ali kaba malumalu. ");
INSERT INTO tteo_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Kowa uginaulimai kaba talatalawasi boda uloili kolili mwa kulukululi siyakwayakwaleli kolimai. ");
INSERT INTO tteo_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Kaliyate meuloina koina mwalimwaline isumamai. ");
INSERT INTO tteo_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","Sinali yo kawa-naenae kabenabenalagili kama kaleyayaone kolili. Kama tokalomagigiliwo ali walo kaiwena kamwalimwaline. ");
INSERT INTO tteo_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Nige kanunuwa-mwatainagiwo yo am kelabilabin kamwasana uginauli nige kalilikwai, na iyamo polowe bwaite iyawatagili kolimai. ");
INSERT INTO tteo_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Katemai mena nige kapepei-suwalagiwo yo am loinao nige kalilikwaili. ");
INSERT INTO tteo_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Na kulogabaegimai yakayakan sokasokali luwali mena nige ama kaiwe sipapagan, na ugabaegimai boniboniyai gun yawasosina koina. ");
INSERT INTO tteo_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Tem kam pwalou kalopei na kalau yaubada uloina koina kapwalou, ");
INSERT INTO tteo_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","kani kulobaimai kaiwena kowa ama nuwatu wadawadamli ukwatailiko. ");
INSERT INTO tteo_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Na kowa kaiwem na siunuunu-yamatemai kaliyate kaigeda kaigeda besiele sipi silawagili sabi unuyamateli. ");
INSERT INTO tteo_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","O Yeoba, kutolo, tawae kaiwena ukenokeno? Miyawa keno. Tabu kusisikotanagimai molosi. ");
INSERT INTO tteo_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Tawae kaiwena manim kuwadam? Tawae kaiwena ama kamkamna yo ama miya polowe kunuwa-mwatainagili? ");
INSERT INTO tteo_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Ama belu kana koleya besiele yakato kabeku katalu bwatano mena na nige ama kaiwe ipapagan, kakenokeno kau mena. ");
INSERT INTO tteo_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Kulaoma kolimai na kuleboimai kaiwena kowa am mulolo imiyayai. ");
INSERT INTO tteo_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Mulolo walina Kola natunao silele Nuwagu ikalapowon walo namwanamwali kolili kabo wali bwaite yalele kin kaiwena. Besiele tolelelele nimana ikatububunanako lelelele kaiwena, memenagu ikatububuko wali kana walo kali walowen kaiweli. ");
INSERT INTO tteo_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Kowa kilakaim inamwanamwasosi yo kowa toedeedede namwanamwasosina. Yaubada ana walo-mulolo koliwo imiyayai. ");
INSERT INTO tteo_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Am kaleya kelepana kana beleti kuyakapu-kalatan kasipum mena, kowa kin kaikaiwena yo kowa towasawasa yo tomiyasaesosi. ");
INSERT INTO tteo_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Kulaumo na am wasawasa koina kam tokaleyayao ukwaiwe-gabaegili yo ukwaleya walo yawasosi yo loina dudulaina kaiweli. Am kaiwe koina kani kaleya lalakili sibaibaiwa kolili kubaguna. ");
INSERT INTO tteo_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Am gipoyo matamatageli kani kam tokaleyayao kateliyao sisakonali. Yo kaba loinao kani sibeku manim mena na sikenokeno kaem yaulina mena. ");
INSERT INTO tteo_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Am kaba miyasio wasawasana Yaubada iyeyawa kani imiyayai kanasiga yo kanasiga. Am tomoyao kuloinayagili loina dudulaina koina. ");
INSERT INTO tteo_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Kumulolo namwanamwana koina yo naenaena kusikotanan. Bwaite kaiwena Yaubada, iya am Yaubada, igite-sipwaiwo yo yaliyaya isuwai koliwo ilalakisosi kabo kin tupwaliyao kolili. ");
INSERT INTO tteo_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Mula yo olo bwalaili namwanamwali siyaele kam kwama koina kabenalan, tovenu ali kaba venu sivenu kolili manim mena nume wasawasali yo pigapigabuli kolili. ");
INSERT INTO tteo_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Am sinesineo yakayakasisili siya kin uloili natuliyao. Yo ulaulam mena am kwin itotolo mekana pasa gole namwanamwasosina koina. ");
INSERT INTO tteo_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Kowa tokasole sine, yagu walo kubenalan. Am susu yo am tomoyao kunuwa-gabaegili. ");
INSERT INTO tteo_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Kam koleya namwanamwana kaiwena kani kin nuwanuwana lalakina kowa. Iya am guyau kabo kuobigai. ");
INSERT INTO tteo_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Am tomoyao Taiya kani silaoma na mulolo siyeliwa, towasawasao siya yanuwa uloili tomonliyao kani silaoma mulolo siyeliwa na mesabana kunuwa-leleyagili na kusaguili. ");
INSERT INTO tteo_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Tokasole sinene ilalaoma nume wasawasana koina, oo iya kana koleya inamwanamwasosi. Kana kwama wasawasana sikona gole koina. ");
INSERT INTO tteo_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Kana kwama ipigapigabu na siyogan silawan kin koina, kana toegelugeluwo simuliya tabe mulina mena silaoma. ");
INSERT INTO tteo_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Me ali yaliyaya lalakina silaolaoma na silusalusae kin ana nume wasawasana koina. ");
INSERT INTO tteo_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Na kowa yagu kin kani natumwao tatao sibaibaiwa na mesabana kowa, tamam yo tubumwao siyamiyalaemiu. Ali kaiwe kani kuwolegili na siyamala toloinao yanuwa yaulina meuloina koina. ");
INSERT INTO tteo_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Yagu waline bwaite kani iyamala esam kana nuwatu-kalatan yaso yo yaso meuloili kolili, na koina tomo sitobatobali koliwo nige ana kaba mwawasi. ");
INSERT INTO tteo_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Kola natunao silele Yaubada iya ala kaba keno-wadam yo ala kaba kaiwe, iya sauga meuloina inonowa na isanasana tem isaguila sauga miyapolowe koina. ");
INSERT INTO tteo_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","3","Koinaele nige sowasowana tamatausi bwagana mwanikiniki inuku, koya simwasamwasali sitagunai na sibeku kalita gunna mena yo kalita iyokoyoko lalakina bagolu siguliguli daguguna ilalaki. ");
INSERT INTO tteo_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Yalubwasi yabo imiyamiya iya yaliyaya ikalaiyama Yaubada Tomiyasaesosi ana yanuwa lalakina koina, bwaine koina ana nume yakayakasisina imiyamiya. ");
INSERT INTO tteo_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Yaubada iyaele yanuwane koina mwa nige sowasowana itatagwaligwali. Malala kikiuna kani ilaoma na yanuwane isagui. ");
INSERT INTO tteo_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Yaubada iedeedede daguguna besiele tutu kabo kaba loinao simatausi lalakina, boda lalakili nuwali sipwanopwano yo yanuwa yaulina iwelo. ");
INSERT INTO tteo_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Yeoba Tokaiwesosi iyaele mekalakava, iya Yakobo ana Yaubada yo ala kaba keno-wadam. ");
INSERT INTO tteo_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Kwalaoma na Yeoba ana paisowa siya ginauli kaba nuwapwanopwano ipaisowailiko wagitaili. ");
INSERT INTO tteo_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Kaleya meuloina iyamwanouli yanuwa yaulina meuloina koina, gipoyo yo wamali igoluli yo ebeu igabuli mayau mena. ");
INSERT INTO tteo_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Yeoba iwaloba, “Kaleya kwalopei yo wakatai yau Yaubada, kani boda meuloili yanuwa yaulina meuloina koina siyakasisi-yagau na sitobali koliyau.” ");
INSERT INTO tteo_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Yeoba Tokaiwesosi iyaele mekalakava, iya Yakobo ana Yaubada yo ala kaba keno-wadam. ");
INSERT INTO tteo_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Kola natunao silele Komiu tomo meuloimiu, kwayaliyaya yo nimamiu mena wakoya-pweyapwesi, na kwawali-tobali kainamiu lalakina Yaubada koina. ");
INSERT INTO tteo_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Yeoba tomiyasaesosi kwamatausan kaiwena iya yanuwa yaulina meuloina kana kin. ");
INSERT INTO tteo_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Iya ana sagu koina kala kaleyayao meuloili takaiwe-gabaegili na ipeili kaekaela yaulili mena. ");
INSERT INTO tteo_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Bwaite bwatanone koina tamiyamiyane iya igite-sipwai kaiwela, kita Isileli ala kaba gagasa, iyeyama kolila kaiwena imulolo kolila. ");
INSERT INTO tteo_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Saugana Yeoba Yaubada isasae ana kaba miya wasawasana koina tomo meuloili siwuiwui me ali yaliyaya yo bwagigi siyuiyui. ");
INSERT INTO tteo_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Kwawali-tobali ala Kin Yaubada koina. ");
INSERT INTO tteo_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Yaubada iya yanuwa yaulina meuloina kana kin, kwatobalan wali kolili. ");
INSERT INTO tteo_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Yaubada ana kaba miya wasawasana koina imiyasio na kaba loinao iloinayagili. ");
INSERT INTO tteo_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Yanuwa yaulina kana toloinao meuloili silogogoma sipatu kolila na tem Abelamo ana Yaubada tatobalan meuloila, kaiwena iya toloina lalaki-molosina yo ikaiwesosi kabo tokaleyayao bodaliyao meuloili ali kaiwe. ");
INSERT INTO tteo_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Kola natunao silele Yeoba iya ilalaki yo sowasowana kana tobali ilalaki, ala Yaubada ana yanuwa lalakina koina, ana koya yakayakasisina koina tatobalan. ");
INSERT INTO tteo_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Saiyon, bwaimwa Yaubada ana koya, isaesosi yo kana koleya inamwanamwasosi, ala Kin ana yanuwa lalakina yaliyaya ikalaiyama yanuwa yaulina mena. ");
INSERT INTO tteo_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Yaubada iyakenayagila yakato iya kala totolo-kaukausi yo igite-kalatagila yanuwane kana nume kaikaiweli kaloli mena. ");
INSERT INTO tteo_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Kinyao siyaboda kaigeda silaoma na sikaleya koya Saiyon koina, ");
INSERT INTO tteo_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","na saugana sigitai kateli sipitali, simatausi kabo siyabubu. ");
INSERT INTO tteo_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Ali matausi yo ali katewakaka ilalakisosi besiele sine yabo kikiunamo ikabi, ");
INSERT INTO tteo_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","besiele tokalakalau ali matausi saugana waga ikoyageyagela wowoli naenaena luwana mena. ");
INSERT INTO tteo_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Yaubada ana paisowa wasana kabenalanako yo kabo bwaite sauga kaboma kagitai Yeoba ala Yaubada Tomiyasaesosi ana yanuwane koina, bwaimwana kani igite-kalatan nige ana kaba mwawasi. ");
INSERT INTO tteo_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","O Yaubada, am mulolo miyamiya yaina kanuwanuwatui am Nume Tabu kalona mena. ");
INSERT INTO tteo_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Tomo dedei meuloili kolili sitobalanagiwo yo wasam idebalala yanuwa yaulina meuloina koina. Loina dudulaina koina kuloinayagili, ");
INSERT INTO tteo_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","kabo sowasowana Saiyon tomonliyao siyaliyaya. Am loina kuwolegili sidudulai mwa sowasowana Yudiya ali yanuwa tomonliyao yaliyaya kateli ikalapowon. ");
INSERT INTO tteo_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Komiu Yaubada ana tomoyao Saiyon kwalotakikilan, ");
INSERT INTO tteo_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","na yanuwane kana gana, nume malamalaweli, yo bilibili kaikaiweli wagitaili na yanuwane ana kaiwe wasana kwayawasayan yaso ilalaoma kolili. ");
INSERT INTO tteo_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Yaubada bwaite iya ala Yaubada miyamiya yaina yo iya kani sauga meuloina ibagubagunayagila. ");
INSERT INTO tteo_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Kola natunao silele Kwabenali bwaite, komiu tomo meuloimiu yanuwa yaulina mena. ");
INSERT INTO tteo_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Nuwana komiu esamiu silalaki o nuwana esamiu sikikiu, nuwana komiu towasawasa o nuwana tobubutuma sowasowana meuloimiu kwabenali. ");
INSERT INTO tteo_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","4","Yagu nuwanuwatu kani simayale yo kani yaedeedede walo sonosonogali kolili yo saugana yagu kaba venu api koina yavenu kani walo sonosonogaline yakabi-yamayaleli kolimiu. ");
INSERT INTO tteo_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Kani nige yamamatausi sauga miyapolowe kolili yo tem kau kaleyayao siyatakikilagau, ");
INSERT INTO tteo_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","siya tonaenaeli ali meli sipei ali wasawasa koina yo sigagasa yakato ali wasawasa imasumasuwe. ");
INSERT INTO tteo_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Nige sowasowana tomo yabo yawasi miyamiya yaina iyamaisa, yo nige sowana yawasina iyamaisa Yaubada koina. ");
INSERT INTO tteo_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Kaiwena tomo yawasina kana yamaisa ilalakisosi. Bwagana toweya ana yamaisa besiele kani nige sauga yabo maisana yawasosi ilolobai, ");
INSERT INTO tteo_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","na tem yawasina imiyayai na tabu ilalau salai koina. ");
INSERT INTO tteo_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Imayalesosi yakato meuloili kani siboita na ali gogo wasawasa ilau natuliyao kolili, bwagana siya tosonoga yo nuwana siya toyauyaule, meuloili kani siboita. ");
INSERT INTO tteo_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Bwagana meyawasili mena ali bwatano ilalaki na iyamo kali salai kani siyamala ali kaba miya yo kani simiyayai bwaine koina nige ana kaba mwawasi. ");
INSERT INTO tteo_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Bwagana esaliyao silalaki na iyamo boita nige sowana siyabubu-gabaen. Kani ali boita kali koleya besiele yakayakan ali boita. ");
INSERT INTO tteo_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Bwaite besiele kani iyawatagili kolili siya analiyao sibomamo simeli-yagili, kaiwena ali kaba yaliyaya ali gogo wasawasa. ");
INSERT INTO tteo_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Siya besiele sipi, kali togite-kalatan esana Boita kani iyoganli kali salai kolili yo sibeku silobi salai gunna mena na bwaine koina yoli sipwasa boita dedeina koina kali mwayaga iyai ali kaba miya kolili. ");
INSERT INTO tteo_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Na yau, Yaubada kani ileboyau boita ana kaiwe koina. ");
INSERT INTO tteo_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Tem tomo yabo iwasawasa yo ana wasawasa ilalaki-isaesae tabu kulalamwa-poloweyan, ");
INSERT INTO tteo_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","kaiwena nige sowasowana ikalai mekanakava silau tem saugana iboita. Ana wasawasane nige sowasowana mekanakava silau salai mena. ");
INSERT INTO tteo_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Bwagana tomo yabo wasawasa lalakina ilobai ana miyamiya koina mwa iyaliyaya yo tomo meuloili sitobalan, ");
INSERT INTO tteo_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","na iyamo kani ilau iboita besiele tamanao yo tubunao beyabeyana silau boita koina na dedeinane koina boniboniyai imiyayai. ");
INSERT INTO tteo_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Bwagana tomo lalakina na esana isaesosi na iyamo nige sowana boita dedeina iyabubu-gabaen. Kani iboita besiele yakayakan meuloili ali boita. ");
INSERT INTO tteo_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Asapi ilele Yeoba iya Yaubada Tomiyasaesosi iwaloko yo iyogako yanuwa yaulina meuloina koina dabwelo ana kaba tunsae mena yo ilau dabwelo ana kaba sugu mena. ");
INSERT INTO tteo_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Yaubada mayalena ilala besiele dabwelo yo ana mayalene ilala yanuwa namwanamwasosina Saiyon koina ilau dedei meuloina ikalai. ");
INSERT INTO tteo_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Ala Yaubada ilalaoma nige mwanou koina, na mayau kalakala-pulupululuna lalakina manna mena yo wowoli lalakina iyatakikilan. ");
INSERT INTO tteo_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Iwalo bulibuli yo yanuwa yaulina kolili iba, “Kwalaoma na tomo ali yatala wagitai.” ");
INSERT INTO tteo_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Iwaloba, “Yagu tomoyao yakayakasisili wakalailima, siya kelabilabin kamwasana siginauli koliyau pwaoli koina.” ");
INSERT INTO tteo_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Bulibuli siwalo-masala yakato Yaubada iya ibomamo todudulai kaiwena iya toloina yawasosi. ");
INSERT INTO tteo_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Iwaloba, “Kwabenali yagu tomoyao na yaedeedede. Kani komiu tomo Isileli kaiwemiu yawalo-masala. Yau Yaubada ami Yaubada. ");
INSERT INTO tteo_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Nige yakato yayakoi-yagimiu ami pwaoli gabugabuli kaiweli siya wakalakalailima koliyau sauga meuloina. ");
INSERT INTO tteo_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Genuwagu kwalau bulumakau tatao bodaliyao kolili na yabo wagite-sipwai na wakalaiyama kaiwegu. Besiele genuwagu gouti yabo wagite-sipwai bodaliyao kolili. ");
INSERT INTO tteo_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Kaiwena yakayakan meuloili ule mena yo bulumakau siyaele sikekakekan wan tausan koya kolili, meuloili siya yau gogoyao. ");
INSERT INTO tteo_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Besiele, man sievaeva-keikeile yo yakayakan siya meyawasili, meuloili yau gogoyao. ");
INSERT INTO tteo_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Tem yaguliyam kani nige yakakawanoi kolimiu kan kaiwena, kaiwena ginauli meuloina yanuwa yaulina kalona mena yau kaiwegu. ");
INSERT INTO tteo_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Gubesi, yakato bulumakau bulumana yakan? Na gouti kwasinena yanuma? Nigele. ");
INSERT INTO tteo_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Tawae nuwanuwagu ele mwa tem wakawatoki koliyau, yau ami Yaubada, bwaimwana ami pwaoli yawasosi ele koliyau. Tabe nuwanuwagu ami waloyameli meuloili kwaemwawasili kaiwena yau ami Yaubada Tomiyasaesosi. ");
INSERT INTO tteo_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Kwayoga koliyau saugana tem polowe kwalobai kabo yalaowa yaleboimiu. Na yagu saguimiu kaiwena kani kwatobalanagau.” ");
INSERT INTO tteo_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Ali yatala koina, Yaubada kani iwalo toyauyaule kolili iwaloba, “Tabu mwakota mena yagu loinao kwawalowalo-wegili, tabu kwamwakomwakota yakato kwaobigaiyau. ");
INSERT INTO tteo_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Yagu yokoi kwasikotanagili, yagu walo kwamiya-dagedagela-yagili. ");
INSERT INTO tteo_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Tokewali meuloili kwalobaili kwaemala ali eliyamwao, yo toganawali bodaliyao mekamikavao kwayaboda kaigeda na kwalolokeikeile. ");
INSERT INTO tteo_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Sopamiu kwanonowailiko walo naenaeli kali edeedede kaiweli na memenamiu sinuwanuwatu mwakota kaiweli. ");
INSERT INTO tteo_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Kamikavao wakawa-naenae-yagili yo ali lopwano kwaloyaloyaili. ");
INSERT INTO tteo_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Ami paisowa naenaena waginauliyako na yau nige walo yabo yawawalowen kabo kwabatoko nige kaiwena yanuwanuwatu. Na iyamo sauga bwaite kani yayokoi-yagimiu na ami lopwano yayakenayagimiu. ");
INSERT INTO tteo_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Komiu kwamiya-dagedagela-yagau, kwabenali bwaite. Tem nigele, kani yasiba-yanaemiu, yo kani nige yabo isasaguimiu. ");
INSERT INTO tteo_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Pwaoline iya kagu yakasisi bwaimwana kawatoki mumugana, yo siya meuloili siobigaiyau kani yaleboili.” ");
INSERT INTO tteo_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Palopita Neitani Deibida iyokoiyan ana ganawali Batisiba koina kaiwena mwa Deibida same bwaite ilele O Yaubada, ukwate-kamkamna-yagau kaiwena kowa am mulolo imiyayai. Kaiwena am katekamkamna ilalakisosi kabo sowasowana yagu pwanoli kusoke-gabaegili. ");
INSERT INTO tteo_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Yagu naenaena meuloili kudeuli-gabaegili yo yagu pwanoli koina ukwabi-kapwayau. ");
INSERT INTO tteo_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Yagu loinalikwa yakataili yo yagu pwanoline sauga meuloina mangu mena simiyamiya. ");
INSERT INTO tteo_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Kowa kubomamo manim mena yalopwanoko yo tawae naenaena yaginauliyako koliwo ugitaiyako. Mwa idudulai tem ukawa-naenae-yagau yo kuloinayagau. ");
INSERT INTO tteo_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Saugana sinagu isiumayagau yo ikabiyau yau naenaena koina yamiyamiya mwa yagu pwanoline iyaelemo ilaulau. ");
INSERT INTO tteo_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Kowa am kaba yaliyaya tem walo yawasosi imiyamiya kategu mena na nuwagu kuyakalapowon am sonoga koina. ");
INSERT INTO tteo_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Kudeuliyau mayau isopi koina na yawaluwalu, kudeuliyau yoi na yau yamayale besiele dibwali poluna. ");
INSERT INTO tteo_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Kutalamwagau na yaliyaya kana lotonan yalotonan, yo bwagana ukogolugolu-yauko na kani yayaliyaya yoi. ");
INSERT INTO tteo_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Yagu pwanoli ukwele-gabaegili, na mumugagu naenaena meuloina kudeuli-gabaen. ");
INSERT INTO tteo_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","O Yaubada, kate kapwakapwana kuyamayale kalogu mena, yo yaluyaluwa waluwaluna yo dudulaina kupei luwagu mena. ");
INSERT INTO tteo_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Tabu manim mena kutatawoiyau, yo Yaluyaluwa Tabuna tabu ukekele-gabaen koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Am lebo kana yaliyaya kuyeyama yoi koliyau yo kusaguiyau na nuwanuwagu yaobigaiwo. ");
INSERT INTO tteo_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Kabo tonaenaeli am kamwasa yayakenayagili na sipileyoima koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","O Yaubada, kowa kagu Tolebo, ilonamwayagau tem yaboita na yakawanoi koliwo kuleboyau, na kani me yagu yaliyaya am nuwatu-pwaiki yawalo-masalan. ");
INSERT INTO tteo_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","O Guyau, kusaguiyau na gamwagu mena yatobalanagiwo. ");
INSERT INTO tteo_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Tem yau yakayakan yagabu na pwaoliyan koliwo kani nige kuyayaliyaya kaiwena siya kusikotanagili. ");
INSERT INTO tteo_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","O Yaubada, yaluyaluwa nuwanuwalobina am kaba yaliyaya, bwaimwa iya yagu pwaoli koliwo. Kowa kani nige sowasowana kate nuwanuwalobina kusikotanan. ");
INSERT INTO tteo_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Kumulolo koya Saiyon tomonliyao kolili kabo Yelusalema kana gana ukwabiyoi. ");
INSERT INTO tteo_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Kabo am kaba pwaoli koina kani bulumakau yo pwaoli tupwaliyao kagabuli siyamala am kaba yaliyaya kaiwena siya pwaoli dudududulaili. ");
INSERT INTO tteo_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Doegi kin Saulo ana wasa iwolena yakato Deibida ilau Aimeleki ana nume mena kabo Deibida same bwaite ilele Kowa tomo lalakina, tawae kaiwena mwa ugagasa am paisowa naenaena kaiwena Yaubada ana tomoyao kolili? ");
INSERT INTO tteo_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Kaliyate meuloina koina kunuwanuwatu na tem tomo uloili kusibayanaeli. Memenam ana matage besiele naipi matamatagena na sauga meuloina kunuwanuwatu mwakota kaiweli. ");
INSERT INTO tteo_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Mumuga naenaena kumulolo koina na mumuga dudulaina nigele, walo mwakomwakota nuwanuwam na walo namwanamwana nigele. ");
INSERT INTO tteo_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Kowa tomwakomwakota, am kaba yaliyaya tem walo naenaeli kolili tomo kusibayanaeli. ");
INSERT INTO tteo_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Mwa koina Yaubada kani isapi-gaogaoliwo kumwawasi besiele gulewa. Tabe kani ikabi-kalatagiwo na iniuli-yawatagilagiwo am nume mena yo kani isulu-gabaegiwo yawasi ana dedei koina. ");
INSERT INTO tteo_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Kabo todudulai kani sigitai na simatausi, sitalawasi-yagiwo yo siwaloba, ");
INSERT INTO tteo_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Wagitai, tomone bwaite nige iduduigenali Yaubada koina sagu kaiwena, na ibomayoi ana wasawasa koina imeli, na ikeno-wadam ibomayoi ana naenaena koina.” ");
INSERT INTO tteo_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Na yau besiele mayau olibe kalakalawana Yaubada ana nume koina, Yaubada ana mulolo miyamiya yaina yameliyan sauga meuloina kani nige ilolotom. ");
INSERT INTO tteo_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","O Yaubada, yau kani sauga meuloina yakawatoki koliwo am paisowa kaiwena. Am tomoyao manli mena kani am namwanamwa yawalo-masalan. ");
INSERT INTO tteo_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Toyauyaule kateli mena siwawalo, “Nige Yaubada ipapagan.” Siya meuloili mumuga naenaena sikalapowon yo ginauli naenaesosili sipaisowailiko. Nige yabo kaloli mena paisowa namwanamwana ipapaisowai. ");
INSERT INTO tteo_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Yaubada igite-lobima bulibuli mena tomo meuloili kolili na tem yabo igitai Yaubada ikataiyako iyaele koina ipwalopwalou. ");
INSERT INTO tteo_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Na meuloili sibeku yo silosuwalako. Meuloili simiyamiya naenaena koina. Nige yabo ana paisowa idududulai, nigele, nige yabo. ");
INSERT INTO tteo_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Yaubada inelineli, “Gubesi, siya mumugana naenaena kana topaisowao nige ali nuwa-mayale yabo? Kaiwena ali miyamiya meuloina koina sikewakewali yagu tomoyao kolili yo nige sauga yabo sikakawanoi koliyau.” ");
INSERT INTO tteo_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Na kani simatausi lalakina nige besiele ali matausi bagubagunana. Kaiwena Yaubada ana tomoyao kana tokalomagigiliwo tuwatuwaliyao kani iyasulu-gwaligwalili. Yaubada isikotanagiliko mwa Isileli kani sikaiwe-gabaegili na siyamwalimwalineli. ");
INSERT INTO tteo_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Kabo yakawanoi Yaubada koina iya imiyamiya koya Saiyon koina na tomo Isileli ileboili. Saugana Yaubada ana tomoyao ali miya panpanna koina iyapileyoilima kabo Yakobo tubunao bwaimwa siya tomo Isileli meuloili kani siyaliyaya. ");
INSERT INTO tteo_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Tomo Sipiti Saulo ana wasa siwolena yakato Deibida ikeno-wadam luwali mena kabo Deibida same bwaite ilele O Yaubada, kuleboyau esam mena yo kulivasiyau am kaiwe koina. ");
INSERT INTO tteo_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Yagu kawanoi kubenalan yo yagu walo kubenalagili. ");
INSERT INTO tteo_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Tomo gagagagasali sitolo sikalomagigi-lagau, yo tomo sokasokali sitonatonan yakato siunuiyau, siya nige Yaubada sigogolulau koina. ");
INSERT INTO tteo_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Na iyamo Yeoba yagu Yaubada iya kagu tosagu, yo iya kagu totolo kaukausi. ");
INSERT INTO tteo_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","O Yeoba, kagu tokalomagigiliwone ali naenaena kuyamaisa kolili yo kusibayanaeli kaiwena kowa towalo yawasosi. ");
INSERT INTO tteo_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Kani yapwaoli mekate-yawasosigu koliwo yo kani yagu kawatoki yaeyawa kaiwena kowa kunamwanamwa. ");
INSERT INTO tteo_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Kaiwena kagu polowe meuloina koina kuleboyauko yo mangu mena kagu tokaleyayao yagitaili ali kaiwe imwawasi. ");
INSERT INTO tteo_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","O Yaubada, yagu valam kubenalan na yagu kawanoine tabu kumimiya dagedagelayan. ");
INSERT INTO tteo_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Tenam kuyawali koliyau na kainagu kuyamaisa. Yagu polowe kaiweli me yagu katewakaka. ");
INSERT INTO tteo_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Kau kaleyayao ali kaso koliyau siula-matamatausagau. Siya toyauyaulene ali munamunai yo ali kalomagigili kaiwena kategu iwakaka yo me yagu nuwapolowe. ");
INSERT INTO tteo_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Yamatausi lalakina yo boita kana matausi koliyau imiyamiya. ");
INSERT INTO tteo_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Kabo matausi yo tabubu silaoma koliyau, mwa katewakaka iyasana-pwaipwaikiyau. ");
INSERT INTO tteo_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Kabo yawaloba, “Tem mepepegu besiele bunetutu na yaeva yalau kaba kaiyawasi yaloyai.” ");
INSERT INTO tteo_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","O besiele. Sowasowana yayabubu yalau kelamamalawe mena na yamiyamiya paepaeli bwagabwaga mena. ");
INSERT INTO tteo_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Mwa yalomwayamwayau kaba kelolonne koina na yaumaine lalakinane yo wowoline kolili yakeno-wadam. ");
INSERT INTO tteo_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","O Yeoba, kau kaleyayao ali edeedede koina nuwaliyao kuula-pwanopwanolili na ali nuwatune kusibayanaeli. Yagitai kaleya yo munamunai ilalaki taon kalona mena, ");
INSERT INTO tteo_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","kaliyate yo boniyai sitakitakikili gana pwatana mena mumugana naenaena yo tabe loinalikwa ikalapowon. ");
INSERT INTO tteo_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Dedei meuloina koina sibayanae ilalaki yo ali kamwasa yo ali kaba gimwala sikalapowon kewali yo munamunai yo kaleya kolili. ");
INSERT INTO tteo_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Na tem kau kaleya yabo italawasi-yagau bwaimwa nige tawae yabo, sowasowana yakalakisiye-yan. Yo tabe tem ipei-yataluyau bwaimwa nige tawae yabo, sowasowana yayabubu-gabaen na yakeno-wadam. ");
INSERT INTO tteo_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Na kowa kaiwem me yagu nuwapolowe kaiwena kowa yakato kagu egelugelu yo yagu eliyam yawasosi. ");
INSERT INTO tteo_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Bwagana kowa te yau edeedede namwanamwali taedeedede-yagili yo tatapwalolo toyawa Nume Tabu mena na iyamo wadam mena ukalomagigi-lagau. ");
INSERT INTO tteo_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Inamwanamwa tem kau kaleyayaone siboita ali sauga kilakai koina. Sowasowana meyawasili sigabae-lobiyegili salai mena na matausi koina siboita. Kaiwena mumugana naenaena imiyamiya ali nume mena yo kateli mena. ");
INSERT INTO tteo_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Na yau, yayoga Yeoba yagu Yaubada koina sagu kaiwena, iya kani ileboyau. ");
INSERT INTO tteo_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Malala, lolau, boniyai yagu yaba yo nuwapolowe meuloili sisae koina, na kani kainagu ibenalan. ");
INSERT INTO tteo_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Yagu meli bwaite besiele, bwagana yalau kau kaleyayao sibaibaiwa yakaleyaili na iyamo Yaubada kani igite-kalatagau na me yagu namwanamwa yapileyoima. ");
INSERT INTO tteo_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Yaubada ana loina imiyayai, iya kani kainagu ibenalan na ikaiwe-gabaegili kaiwena sisikote nuwabui yo nige simamatausan. ");
INSERT INTO tteo_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Na tomone iya yakato yagu eliyam namwanamwana ikawa-naenae-yagimai mwa ana waloyameli koliyau isibayanaeli. ");
INSERT INTO tteo_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Ana edeedede siluviluvi na katena mena kalomagigili ikalapowon. Ana walo kaba nuwayai na iyamo sowasowana tomo kateli isibayanaeli. ");
INSERT INTO tteo_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Kami polowe kwaolena Yeoba koina, na iya kani itolo-kaukausimiu. Iya kani nige itatalam todudulai kana kaleyayao sikakaiwe-gabaen. ");
INSERT INTO tteo_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Na kowa Yaubada kani tounuyamate yo tomwakotao ugwabae-yataluli kali salai mena ali sauga kilakai koina. Na yau, kani yameli koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Tomo Pilistiya silaoma Deibida sikabi-kalatan kabo Deibida same bwaite ilele O Yaubada, ukwate-kamkamna-yagau, kaiwena tomo kaeli mena siutu-lobilobi-yegau yo sauga meuloina siyakamkamna-yau. ");
INSERT INTO tteo_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Kaliyate meuloina koina kagu tokalomagigiliwo sigamwagamwa-kamkamna koliyau yo sibaibaiwa sikalekaleya koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Na tem yamatausi yagu meli yapei koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Yaubada yatobalan ana waloyameli koliyau kaiwena. Yameliyan yo nige sowasowana yamatausi. Kabo tawae tomo kani siginauli koliyau? ");
INSERT INTO tteo_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Kagu kaleyayao siyapoloweyau kaliyate meuloina koina. Mwa sinuwanuwatu na tem toisabo kamwasa koina na siunuiyau. ");
INSERT INTO tteo_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Kabo silogogo kaba keno-wadam kolili na yagu paisowa meuloina sigitagitai, sinuwanuwatu lalakina tem siunuiyau. ");
INSERT INTO tteo_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","O Yaubada, kuyamaisali ali naenaenane kolili. Na bwaite tomoliyaone ukaiwe-gabaegili am munamunai koina. ");
INSERT INTO tteo_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Na kowa yagu nuwapolowe meuloina yo yagu valam kana lalaki ukwataiyako kaiwena matalilogu meuloili kupeiliko am botolo koina yo kali baibaiwa kuleleyako am buki mena. ");
INSERT INTO tteo_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Kabo kaliyatenane koina yayoga koliwo kani kagu tokaleyayao kuyapileyoili. Bwaite koina yakatai kowa Yaubada kumiyamiya saligu mena kusagusaguiyau. ");
INSERT INTO tteo_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Kabo Yeoba yagu Yaubada ana waloyameli yatobalan. ");
INSERT INTO tteo_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Iya koina yameli, mwa nige yamamatausi. Kabo tawae tomo kani siginauli koliyau? ");
INSERT INTO tteo_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","O Yaubada, tawae yawalo-yameliyako kani yaeyawa koliwo. Na yagu kawatoki pwaoli mena yaeyawa. ");
INSERT INTO tteo_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Kaiwena kuleboyauko boita mena tabu sikakaiwe-gabaegau na mesabana am mayale iya itunsae tomo meyawasili kolili na koina yalokeikeile. ");
INSERT INTO tteo_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Deibida Saulo iyabubu-gabaen kabo same bwaite ilele O Yaubada, ukwate-kamkamna-yagau kaiwena yayabubumako koliwo namwanamwa kaiwena. Na pepemwao lolonli mena yakelolon kanasiga wowoli naenaena imwawasi. ");
INSERT INTO tteo_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Yayoga Yaubada koina iya tomiyasaesosi, kaiwena iya kagu eoma meuloina koina isaguiyau. ");
INSERT INTO tteo_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Na kani kainagu iyamaisa bulibuli mena yo ileboyau, yo kani kagu toyakamkamnao iyamwalimwalineli. Yaubada ana mulolo yo ana kawa-elieliyam miyamiya yaina kani iyakenayagau. ");
INSERT INTO tteo_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Na kau kaleyayao siyatakikilagau besiele laiyon siguliyam tomo bulumana kaiwena, na mwakaliyao besiele pwawati yo gipoyo, na memenaliyao besiele kaleya kelepana matamatageli. ");
INSERT INTO tteo_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","O Yaubada, kuyakenayagili yakato kowa kusaesosi bulibuli mena, yo am wasawasa yanuwa yaulina meuloina koina. ");
INSERT INTO tteo_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Kau kaleyayao yagida sigalayani sabi yakonaiyau, kabo katewakaka iyasana-pwaipwaikiyau. Yagu kamwasa mena gula sikeli na sibomayoi sibeku koina. ");
INSERT INTO tteo_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","O Yaubada, sauga meuloina meyagu katepatu kabo kani yawali yo yatobalanagiwo. ");
INSERT INTO tteo_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Kutolo, Yaluyaluwagu kutolo, kabo yatolo yau kaba venu api yakalaili na dabwelo yayanoi. ");
INSERT INTO tteo_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Kabo Guyau, kani yakawatoki koliwo kaba loinao luwali mena, yo besiele kani yatobalanagiwo tomo luwali mena. ");
INSERT INTO tteo_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Am mulolo ilalakisosi isae bulibuli mena, yo am kawa-elieliyam miyamiya yaina bulibuli ikabitonan. ");
INSERT INTO tteo_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","O Yaubada, kuyakenayagiwo kowa kusaesosi bulibuli mena yo am wasawasa meuloina yanuwa yaulina mena. ");
INSERT INTO tteo_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Komiu toloinao nige sauga yabo loina namwanamwana wagiginauli. Yakato tomo meuloili kuyatalayagili dudulai mena? ");
INSERT INTO tteo_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Nigele. Katemiu mena naenaena kwanuwanuwatuili yo ami kaiwe koina unuyamate kwapaipaisowai yanuwa yaulina mena. ");
INSERT INTO tteo_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Tonaenaena ali miyamiya meuloina koina mumugana naenaena sipaipaisowai. Ali mwakota iyatubu ali sauga kabi koina. ");
INSERT INTO tteo_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Naenaena sikalapowon besiele weso kelakelabasina, tenaliyao sikausili besiele weso tenana kolakolana. ");
INSERT INTO tteo_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","Iya nige sowana igo toyuiyui kainana ibenalan yo nige sowana tokukula sonosonogana ana wali ibenalan. ");
INSERT INTO tteo_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","O Yeoba yagu Yaubada, bwaite laiyon sokasokaline mwakaliyao ugoluli. ");
INSERT INTO tteo_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Ilonamwayagili tem sikwalalele besiele waila tasuwe-gabaen yo besiele kawasi kamwasa mena tautu-yamateli. ");
INSERT INTO tteo_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Yo tabe besiele ilonamwayagili tem siya besiele sise gilolona koina sisanene sikwalalele yo besiele melumelune boiboitana sikabiyan na nige mayale igigitai. ");
INSERT INTO tteo_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Yo siya besiele kawasi sikinkin na kelepa mena tatomli yo kelepa ana laoma nige sikakatai. Yaubada ana munamunai kaikaiwena koina kani iyui-kalaili, na bwagana meyawasili kani sikwalalele molosi. ");
INSERT INTO tteo_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Kabo tonamwanamwali kani siyaliyaya saugana tem sigitai tonaenaeli kali maisa polopolowena silobai, yo kani sigayogayo tonaenaeli kwasineli luwana mena. ");
INSERT INTO tteo_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Kabo tomo kani siwaloba, “Walo yawasosi, Yaubada imiyamiya yo iya yanuwa yaulina kana toyatala dudulaina mwa kani todudulai maisali namwanamwana silobai.” ");
INSERT INTO tteo_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Saulo tomo iyawasali na tem Deibida siunuyamate kabo Deibida same bwaite ilele O yagu Yaubada, kuleboyau kagu kaleyayao kolili, yo kutolo-kaukausiyau siya bwaite sikalekaleya koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Kuleboyau bwaite tomone naenaeline yo tounuyamatene kolili. ");
INSERT INTO tteo_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","4","O Yeoba, ugitai, siya siyaele sisanasana sabi unuiyau, tomo sokasokali silogogoma kaiwegu. Bwagana nige yabo nae o lopwano yagiginauli kolili na iyamo sikatukatububu tem siunuiyau. ");
INSERT INTO tteo_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","O Yeoba, kowa Tokaiwesosi yo kowa Isileli ama Yaubada, kutolo yo kaba loinao naenaeli meuloili kuyamaisali yo ali yauyaule kaiwena kuyemwawasili, tabu ukwakate-kamkamna-yagili. ");
INSERT INTO tteo_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Lolau molosi mena sipileyoima sikalakalagaga besiele bwauwa sokasokali yanuwa kamwasali kolili silolo-bwagabwaga. ");
INSERT INTO tteo_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Ee bwaine siya, walo naenaena yo sinali kolili gamwali sikalapowon yo gamwali mena sikalakalagaga. Sibatoko nige yabo ibebenalagili. ");
INSERT INTO tteo_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Na boda siya nige tomeliwo kowa Yeoba kumalumalu-wagili yo kaba loinao uloili kutalatalawasi-yagili. ");
INSERT INTO tteo_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","O Yaubada, kowa yagu kaiwe yo yau kaba katepatu. Kani yatobalanagiwo kaiwena kowa yau kaba keno-wadam. ");
INSERT INTO tteo_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Yagu Yaubada kagu tomulolo kani ilaoma koliyau, kabo kagu tokaleyayao ikaiwe-gabaegili na ali belu yagitai. ");
INSERT INTO tteo_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","O Yaubada, kowa ama ebeu, tabu kuunuyamate-mwayamwayau-wagili na yagu tomoyao ali kamkamna sigitai yo sinuwatu-kalatan. Na kuyamiya-tata-gwaligwalilimo yo am kaiwe mena ukwaiwe-gabaegili. ");
INSERT INTO tteo_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Naenaena iyaele sopali mena, ali walo meuloili walo naenaeli. Sowasowana sibomayoi ali gagasa koina sisipwa. Ali walo kawa-gula yo mwakota kaiwena, ");
INSERT INTO tteo_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","kuunuili am munamunai koina kanasiga meuloili simwawasi. Kabo tomo meuloili sikatai kowa Yaubada am loina iyatubu Isileli koina na ilau dedei meuloili kolili. ");
INSERT INTO tteo_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","15","Lolau molosi mena sipileyoima sikalakalagaga besiele bwauwa sokasokali yanuwa kamwasali kolili silolo-bwagabwaga siloyaloya kan kaiwena. Na tem kali nige silolobai kani sikalakalagaga. ");
INSERT INTO tteo_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Na yau kani malala kaigeda kaigeda kainagu lalakina mena yawali-tobali am kaiwe yo am mulolo miyamiya yaina kaiweli. Kaiwena kowa yagu kaba keno-wadam yo yagu kaba kobwau sauga miyapolowe koina. ");
INSERT INTO tteo_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","O Yaubada, kowa yagu kaiwe, kani yagu wali-tobali yawaliyan koliwo kaiwena kowa kagu tomulolo yo kagu totolo-kaukausi. ");
INSERT INTO tteo_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Yowabi tomo Idoma kali baibaiwa tuwelo tausan iunuyamateli kabo Deibida same bwaite ilele O Yaubada, kusikotanagimai yo ukwaiwe-gabaegimaiko. Am munamunai kalotonanako na nuwanuwamai kupileyoima kolimai. ");
INSERT INTO tteo_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Kainam koina yanuwa itabubu yo bwatano itaigali itasoke. Bwatanone taigaliline kubwaluyoili kaiwena sisalulu-gwaligwali. ");
INSERT INTO tteo_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Kai am tomoyao kowa kuyakamkamnamai lalakina, kabo ama kamkamna koina ama lokeikeile besiele tonuma-yauyaule ali lokeikeile. ");
INSERT INTO tteo_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Siya me ali yakasisi kaiwem kuyanuwapeiliko na mesabana gipoyo kana wamali siyabubu-gabaegili. ");
INSERT INTO tteo_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Ama kawanoi kuyamaisali yo kuleboimai am kaiwe koina na tem kumulolo kolimai am sagu kalobai. ");
INSERT INTO tteo_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Ana dedei yakayakasisina koina Yaubada iwaloko iwaloba, “Me yagu yaliyaya yawui yo yanuwa Sekemi yayakasa na yasoiyan yagu tomoyao kolili. Besiele kani yaginauli Sakot kalogawana koina. ");
INSERT INTO tteo_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Dedei Giliyadi yo Manase siya yau gogo. Dedei Ipeleim koina kani yagu tokaleyayao yakalaili na dedei Yuda koina kani yagu kin yakalai. ");
INSERT INTO tteo_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Dedei Mowabe koina kani yagu topaisowao nuwanuwalobili yakalaili yo Idoma koina yagu topaisowa panpanli yakalaili. Yo me yagu yaliyaya kani yawui yoi kaiwena tomo Pilistiya yakaiwe-gabaegiliko.” ");
INSERT INTO tteo_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","O Yaubada, na kani yaiya ikalaiyau ilawagau dedei Idoma kana taon lalakina kaikaiwena koina? ");
INSERT INTO tteo_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","O Yaubada, yakato kusikotanagimai? Yakato nige ama tokaleyayao mekamkavao kwalau na wakaleya kama kaleyayaone kolili? ");
INSERT INTO tteo_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Kusaguimai kama kaleyayao kolili kaiwena tomo ana sagu ibelusosi ginauli bwagabwaga. ");
INSERT INTO tteo_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Na tem Yaubada imiyamiya ala dedei koina kani takaiwe yo kala kaleyayaone kani ikaiwe-gabaegili. ");
INSERT INTO tteo_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","O Yaubada, yagu valam yo yagu kawanoi kubenalagili. ");
INSERT INTO tteo_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Kategu nuwanae ikalapowon kaiwena yamiya kelamamalawe yagu yanuwa koina, kabo yayoga koliwo. Ukwalaiyau kaba keno-wadam namwanamwana koina, ");
INSERT INTO tteo_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","kaiwena kowa kagu totolo-kaukausi yo yagu nume kaikaiwena na kagu kaleyayao nige sowasowali siunuiyau. ");
INSERT INTO tteo_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Kutalamwagau na yamiyamiya am Nume Tabu mena yawasigu meuloina koina, na yakelolon pepem yaulina mena. ");
INSERT INTO tteo_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","O Yaubada, yagu waloyameli kubenalagiliko yo tawae ilonamwayagau kuyeyamako kaiwena yamiyamiya siya siyakasisi-yagiwo luwali mena yo kama yauyauya, am walo-mulolo, kalobaiyako. ");
INSERT INTO tteo_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Kin ana bolime kuyamamalawe yawasina koina, na kutalam imiyamiya sauga meuloina. ");
INSERT INTO tteo_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","O Yaubada, sowasowana kin iloina sauga meuloina manim mena. Kutolo-kaukausi na imiyamiya am mulolo miyamiya yaina yo walo yawasosi kolili. ");
INSERT INTO tteo_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Kabo kani yawali-tobali koliwo yo yagu pwaoli yaeyawa kaliyate kaigeda kaigeda besiele yagu waloyameli koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Me yau kalakisiye yasanasana Yaubada ana lebo kaiwena. Iya ibomamo koina lebo ilaoma. ");
INSERT INTO tteo_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Iya iboma kagu totolo-kaukausi yo kagu Tolebo, yagu nume kaikaiwena kabo nige sowasowana yamwasali. ");
INSERT INTO tteo_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Na kau kaleyayaone kolili yawaloba, “Toweya kana mamalawe besiele kani unuiyaune kwalopei kaiwena nige yagu kaiwe. Yau besiele gana yabo itatagwaligwali yo nige ana kaiwe ipapagan. ");
INSERT INTO tteo_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Nuwanuwamiumo wakele-gabaegau yagu kaba miya yakayakasisina koina. Mwakota ami kaba yaliyaya, mwa sopamiu mena kwaedeedede walo-mulolo kaiwena na katemiu mena wakawa-gulaiyau.” ");
INSERT INTO tteo_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Yaubada ibomamo koina yaduigenali, me yagu katepatu ana lebo yasanasanai. ");
INSERT INTO tteo_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Iya iboma kagu totolo-kaukausi yo kagu Tolebo, yagu nume kaikaiwena kabo nige sowasowana yamwasali. ");
INSERT INTO tteo_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Kagu lebo yo kagu yakasisi siyaele Yaubada koina, iya kagu totolo-kaukausi kaikaiwena yo iya yagu kaba kelolon. ");
INSERT INTO tteo_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","O yagu tomoyao, kwameli Yaubada koina sauga meuloina. Kami polowe meuloili kwawalo-masalagili koina, kaiwena iya ala kaba kelolon. ");
INSERT INTO tteo_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Yaubada manna mena tomo siya besiele yawasi kana yui-gabaen, bwagana esaliyao silalaki o nuwana esaliyao sikikiu na iyamo siya meuloili besiele ginauli bwagabwaga. Tem tapeili Yaubada ana kaba liye koina kali polowe simalamalae molosi. Yaubada yawasina kana yui-gabaen ipolowe kabo muli mena tomo kali polowe. ");
INSERT INTO tteo_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Kabo tabu kutonatonan na am wasawasa ugiginauli kewali o tomo kali walo matamatausi koina. Bwagana am wasawasa ilalaki-isaesae tabu am meli kupepei kolili. ");
INSERT INTO tteo_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Yaubada iedeedede koliyau na yabenalan sauga ibaibaiwa yakato kaiwe Yaubada iya ana gogo. ");
INSERT INTO tteo_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Besiele tabe mulolo miyamiya yaina iya ana gogo. O Yeoba, walo yawasosi, tomo meuloili kani kuyamasaili ali paisowa ana lau koina. ");
INSERT INTO tteo_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Deibida imiyamiya ule bwagabwaga mena Yudiya dedeina mena kabo same bwaite ilele O Yaubada, kowa yagu Yaubada, yaluyaluwagu galogalona imagu kaiwem. Yogu meuloina igadosisi-yagiwo. Besiele dedei leleyanna nuwanuwana lalakina galewa bwaine besiele yaluyaluwagu kana lotonan. ");
INSERT INTO tteo_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Kutalam yagitaiwo am dedei tabutabuna koina. Kutalam am kaiwe yo am wasawasa yagitaili. ");
INSERT INTO tteo_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Am mulolo miyamiya yaina inamwanamwasosi kabo muli mena yawasigu kana lotonan, mwa koina kani yatobalanagiwo. ");
INSERT INTO tteo_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Kani yagu kawatoki yaeyawa koliwo yagu miyamiya meuloina koina, kani yagu kawanoi koina nimagu yakeleisinagiliwa koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Yaluyaluwagu ana yaliyaya kaiwem ilalakisosi kabo muli mena kekan lalakina kana yaliyaya kabo kani yawali-tobali koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Saugana yakeno yagu kaba keno mena yanuwatu-kalatagiwo, boniyai meuloina koina yanuwanuwatu kaiwem, ");
INSERT INTO tteo_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","kaiwena kowa sauga meuloina kagu tosagu. Yo pepem lolonna mena yawali me yagu yaliyaya. ");
INSERT INTO tteo_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Yaluyaluwagu ipatu koliwo yo nimam igite-kalatan namwanamwaiyau. ");
INSERT INTO tteo_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Na siya analiyao sitonatonan yakato siunuiyau kani silobi boita dedeina mena. ");
INSERT INTO tteo_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Kani siboita kaleya kelepana koina na bwauwa sokasokali yoli sikanli. ");
INSERT INTO tteo_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Na kin kani iyaliyaya kaiwena ana kaiwe kani ikalai Yaubada koina. Siya analiyao siwaloyameli Yaubada esana mena kani sitobali koina, na tomwakota gamwaliyao kani sikausili. ");
INSERT INTO tteo_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","O Yaubada, yau kawanoi kubenalan kaiwena yau yamiya-polowe. Yawasigu kuleboi, yamatausi kau kaleyayao kolili. ");
INSERT INTO tteo_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Toyauyaule yo tonaenaeli bodaliyao ali nuwatu kagu unuyamate kaiwena kutolo-kaukausiyau. ");
INSERT INTO tteo_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Memenaliyao sivakilili simatage besiele kaleya kelepali, yo walo naenaeli siwalowegili koliyau besiele gipoyo siulagili. ");
INSERT INTO tteo_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Kabo siya mwayamwayau mena walo mwakomwakota siyadebalalali, tomo namwanamwali esaliyao sisibayanaeli ali etalapili koina. ");
INSERT INTO tteo_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Kalikavao nuwaliyao sikoili ali loina naenaeli kolili, siedeedede toweya koina kani ali sipwasipwa sipeili. Na siwalo sibomamo kolili siba, “Kani nige yabo ala paisowa igigitai.” ");
INSERT INTO tteo_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Kabo ali nuwatu naenaeli sipaisowaili yo siwaloba, “Kani nige yabo ala paisowane inunuwatu-lobai.” Siwalo besiele kaiwena tomo katena yo ana nuwatu sisonogasosi mwakota koina. ");
INSERT INTO tteo_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Na Yaubada kani isakonali ana gipoyo mena na mwayamwayau sisilae. ");
INSERT INTO tteo_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Ali walone kaiweli kani isibayanaeli, yo tomo meuloili kani kulukululi siyakwaleli saugana tosilaene sigitaili. ");
INSERT INTO tteo_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Kabo tomo meuloili kani simatausi, yo kani siwalo-masala tawae Yaubada iginauliyako yo sinuwanuwatu lalakina ana paisowane kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Kabo todudulai meuloili kani siyaliyaya Guyau ana paisowa kaiwena yo kani silau sikeno-wadam iya koina. Tomo namwanamwali meuloili kani sitobali koina. ");
INSERT INTO tteo_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","O Yaubada, am kaba miya Saiyon, ilonamwa-yagimai katobalanagiwo yo ama waloyameli koliwo kapaisowaili, ");
INSERT INTO tteo_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","kaiwena ama kawanoi kuyamaisali. Tomo dedei meuloili kolili kani silaoma na sipwalou yo sipwaoli koliwo, ");
INSERT INTO tteo_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","ali pwanoli kaiweli. Ama pwanoli sibaibaiwasosi siyamala ama kaba miyapolowe na iyamo kunuwatu-pwaikili. ");
INSERT INTO tteo_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Siya analiyao ugite-sipwaili kani siyaliyaya kaiwena ukwalailima na simiya am dedei yakayakasisina koina. Na kai ama kaba yaliyaya ginauli namwanamwali siyaele am nume koina, bwaimwa walo mulolo kalobaili am Nume Tabu mena. ");
INSERT INTO tteo_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Am paisowa kaba nuwapwanopwano kolili ama kawanoi maisana lebo kuyeyama. Tomo dedei meuloili kolili yo siya simiya-suwala kalita dedeina yabo mena ali meli sipei koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Am kaiwe koina koya kupeili ali kaba miya mena kaiwena kowa Tokaiwesosi. ");
INSERT INTO tteo_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Kalita ana yokoyoko yo bagolu ali guli daguguna kuyadaumwalili. Bwaine besiele tomo ali gamwapanapanawa kuyamwanouli. ");
INSERT INTO tteo_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Kabo ginauli lalakisosili kupaisowailiko yanuwa yaulina tomonliyao sigitaili simatausagiwo, na tomo siya simiyamiya dabwelo ana kaba tunsae mena yo ana kaba sugu mena ginauli lalakisosiline sigitaili kabo me ali yaliyaya siwui. ");
INSERT INTO tteo_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Am gite-kalatan kuyakenayagimai kaiwena galewa kuyawasayama italu na bwatano iwasawasa yo imasuli. Yalubwasi kikiuli kuloyapowonli waila kolili sididididi kabo kan iyawatagili bwatano koina besiele ana nuwatu. ");
INSERT INTO tteo_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Na galewa lalakina kuyatalu bwatano meuloina koina, yo bwatanone sigiyaliyako kuyabuta waila lalakina koina. Bwatanone kuyabiga na like lamli sipeili na sikin. ");
INSERT INTO tteo_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Am namwanamwa koina kelikeli namwanamwana silobai. Tem toweya koina kulau masuli lalakina imiyamiya. ");
INSERT INTO tteo_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","13","Kawasi ilalaki simiyamiya koya yo tailabe kolili bulumakau yo sipi sikalapowon koina sikekakekan me ali yaliyaya. Kalogawa kolili witi koina sikalapowon. Ginauli meuloina siwaliwali yo siwuiwui me ali yaliyaya. ");
INSERT INTO tteo_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Komiu tomo meuloimiu yanuwa yaulina mena, Yaubada kwatobalan me ami yaliyaya. ");
INSERT INTO tteo_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Esana kwatobalan yo ana wasawasa kwawaliyan. ");
INSERT INTO tteo_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Kwawalo Yaubada koina kwawaloba, “Am paisowa meuloili sinamwanamwasosi. Am kaiwe ilalakisosi kaiwena mwa kam kaleyayao me ali matausi sipwalou koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Tomo meuloili yanuwa yaulina meuloina koina sipwalou koliwo, siwali-tobali koliwo yo wali siwaliyagili esam kaiwena.” ");
INSERT INTO tteo_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Kwalaoma yo wagitai tawae Yaubada ipaisowaiyako, ana paisowa namwanamwali tomo luwali mena. ");
INSERT INTO tteo_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Kalita ibui iyamala bwatano leleyanna kabo tubulao koina silopanaisi kaekaeli mena. Bwaine koina esana sitobalan. ");
INSERT INTO tteo_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Ana loina kaikaiwena imiyayai yo manna ilau kaba loinao meuloili igitagitaili. Tabu togamwa-panapanawa sitotolo na tem sikaleya koina kisi sisilae. ");
INSERT INTO tteo_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Komiu tomo meuloimiu, ala Yaubada kwatobalan kainamiu lalakina mena. ");
INSERT INTO tteo_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Yawasila iya nimana mena yo nige sowasowana italam tabeku boita ana dedei koina. ");
INSERT INTO tteo_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","O Yaubada, kutonagimaiko besiele siliba sigabu mayau wedowedolina koina kabo ikapwa. ");
INSERT INTO tteo_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Kutalam kabeku ali sipwasipwa koina na kayakayale polopoloweli sipeili dagelamai mena. ");
INSERT INTO tteo_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Kutalam kama kaleyayao sisagena pwatamai mena, kalau mayau wedowedolina luwana mena yo yalubwasi kalopanaisi, na sauga bwaite ukwalaimai yoi kalau dedei namwanamwana koina. ");
INSERT INTO tteo_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Mwa kani yagu pwaoli gabugabuna yakalaiyama am nume mena, kani yagu waloyameli kanna yaeyawa. ");
INSERT INTO tteo_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","Tawae yawalo-yameliyako koliwo yagu sauga miyapolowe koina kani yaeyawa. ");
INSERT INTO tteo_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Bulumakau tataoliyao, gouti yo sipi kani yapwaoli-yagili am kaba gabu mena na bogauli kani sisaewa koliwo bulibuli mena. ");
INSERT INTO tteo_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Komiu meuloimiu Yaubada kwayakasisi-yan, kwalaoma na kwabenali, kabo Yaubada ana paisowa koliyau kani yawalo-masalan kwabenalan. ");
INSERT INTO tteo_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Yavalam koina sagu kaiwena yo yatobalan wali kolili. ");
INSERT INTO tteo_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Tem pwanoline siya kategu mena yamulolo kolili, Yeoba kani nige ibebenali koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Na iyamo walo yawasosi Yaubada kainagu ibenalan mwa yagu kawanoi iyamaisa. ");
INSERT INTO tteo_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Kabo Yaubada yatobalan kaiwena yagu kawanoi nige isisikotanan yo ana mulolo miyamiya yaina nige inunuwai koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","O Yaubada, ukwate-kamkamna-yagimai yo kuwalo-muloloimai. Ugite-laoma kolimai me am mulolo, ");
INSERT INTO tteo_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","na mesabana yanuwa yaulina meuloina am nuwatu sikatai yo tomo meuloili sikatai yakato kowa Tolebolebo. ");
INSERT INTO tteo_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","O Yaubada, sowasowana tomo meuloili sitobalanagiwo. ");
INSERT INTO tteo_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Sowasowana kaba loinao meuloili me ali yaliyaya siwaliwali kaiwena kowa tomo kuyatalayagili loina dudulaina koina. Na tomo meuloili yanuwa yaulina mena ali kamwasa kuyakenayagili. ");
INSERT INTO tteo_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","O Yaubada, sowasowana tomo meuloili sitobalanagiwo. ");
INSERT INTO tteo_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Yaubada ala Yaubada iwalo-muloloilako mwa bwatano imasuli kelikeli kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Yaubada iwalo-muloloilako kabo sowasowana tomo simiyamiya dedei meuloili kolili siyakasisi-yan. ");
INSERT INTO tteo_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Yaubada itolo kabo kana kaleyayao itawo-gwaligwalili. Siya analiyao sikalomagigilan ali kaiwe imwawasi yo siyabubu manna mena. ");
INSERT INTO tteo_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Saugana bogau ilaoma manla mena tayui-kalai. Bwaine besiele Yaubada iginauli kana kaleyayao kolili. Besiele tem ginauli welowelona mayau wedowedolina salina mena iwelo, bwaimwa besiele tonaenaeli ali boita Yaubada manna mena. ");
INSERT INTO tteo_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Na todudulai siyaliyaya lalakina Yaubada manna mena kabo me ali yaliyaya siwuiwui. ");
INSERT INTO tteo_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Kwawali Yaubada koina, kwawali-tobali esana koina. Iya tomonane ana kaba mwalisae yaloyaloi, ana kamwasa wakatububunan. Iya esana Yeoba na kwayaliyaya manna mena. ");
INSERT INTO tteo_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Yaubadane iya mwa imiya ana Nume Tabu mena, iya kwabukwabuliwo yo sinasinageyao kali togite-kalatan. ");
INSERT INTO tteo_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Tomo siya nige kali togite-kalatan ali nume iwolegili. Yo siya nume pan koina simiyamiya ilivasili siyaliyaya. Na siya togamwa-panapanawa kani bwatano naenaena koina simiyamiya me kali guliyam. ");
INSERT INTO tteo_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","O Yaubada, saugana am tomoyao kubaguna-yagili na kulawagilima ule mena, ");
INSERT INTO tteo_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","yanuwa yaulina itabubu yo galewa lalakina italuma bulibuli mena yo koya Sainai itabubu manim mena, kowa Isileli ali Yaubada. ");
INSERT INTO tteo_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","O Yaubada, galewa lalakina kuyataluyamako bwatano mena kabo bwatano kuyanamwanamwa yoi. ");
INSERT INTO tteo_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Kabo am tomoyao simiya bwaine koina, na am namwanamwa koina tobubutumao kusaguili. ");
INSERT INTO tteo_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Yeoba walo iyawasa kabo sinesineo sibaibaiwa kaleya wasana sikalaiyama siwaloba, ");
INSERT INTO tteo_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","“Kin me ali tokaleyayao siyabuyabubu.” Mwa sinesineo yanuwa mena gogo kaleya kolili sikalailima sisoi-yagili. ");
INSERT INTO tteo_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Bwagana tem tupwamiyao nige kwalalau kaleya koina na wakenokeno sipi luwali mena na iyamo gogo lalakina kwalobai soine koina besiele bunetutu siginauli siliba yo gole kolili siyamala ami nume kali pasa. ");
INSERT INTO tteo_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Saugana Yaubada Tomiyasaesosi kin me ali tokaleyayao itawo-gwaligwalili koya Salimon koina sinou iyasalulu sibekuma bwaine koina. ");
INSERT INTO tteo_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","16","Kowa koya Basan, tawae kaiwena Yaubada ana koya kulamwa-poloweyan? Bwagana kowa koya malamalawena na iyamo koya Saiyon Yaubada igite-sipwaiyako iya ana kaba miyayai. ");
INSERT INTO tteo_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Yeoba me ana saliyota waga niuniuli tausan yo tausan koya Sainai ikwasa-gabaen ilau imiya yanuwa yakayakasisina koina. ");
INSERT INTO tteo_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Ikawasae koya Saiyon koina mekanakavao ana topaisowa panpanli yo siya kin togamwa-panapanawa ali mulolo sipei koina ilokalaili. Na Yeoba Yaubada kani imiya Saiyon koina. ");
INSERT INTO tteo_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Yeoba tatobalan, iya kala polowe tokalaina kaliyate kaigeda kaigeda kolili, kaiwena Yaubada iya kala tolebo. ");
INSERT INTO tteo_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Na ala Yaubada iya tolebo, yo iya Yeoba ala Guyau iya kala tolebo boita koina. ");
INSERT INTO tteo_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Yaubada walo yawasosi kana kaleyayao kani kulukululiyao ikogaolili, siya analiyao tem mumugana naenaena kana kamwasa sisamasamalului. ");
INSERT INTO tteo_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Yeoba iwaloko iba, “Yau kani kami kaleyayao yakele-yapileyoilima Basan koina, tabe kani yakele-yapileyoilima kalita gunna mena, ");
INSERT INTO tteo_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","na mesabana kaemiu kwayabutali kwasineliyao kolili yo ami bwauwao kami kaleyayaone kwasineliyao kolili sinuma.” ");
INSERT INTO tteo_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","O Yaubada, am kaiwe kaleya koina kana kilakilala tomo meuloili kani sigitai am lau am lusae Nume Tabu koina. ");
INSERT INTO tteo_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Towali sibaguna, tovenu simuliya na luwaluwalili mena sinesineo siya tambalin kana tokoikoi. ");
INSERT INTO tteo_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Towali ali wali bwaite besiele, “Komiu Yakobo tubunao yo Yaubada ana tomoyao, Yeoba kwatobalan ami logogo koina.” ");
INSERT INTO tteo_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Silusaema yakasa koina baguna Beniyamina ana susu, iya susu kikiuna, mulina mena Yuda tobagunao me ali bodao yo mulili mena Sebulon yo Napitalai. ");
INSERT INTO tteo_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","O Yaubada, am kaiwe kuyakenayan am tomoyao kolili kaiwene iya tauna kona kuyapaisowa kaiwemai. ");
INSERT INTO tteo_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Kinyao mulolo sikalailima am Nume Tabu Yelusalema koina kaiwena am kaiwe sikilala. ");
INSERT INTO tteo_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Am kaiwe kuyakenayagimai kabo Itipita kuyokoi-yagili kaiwena siya besiele bulumakau tataoliyao sokasokali me natuliyao sinisoniso-lalaka kawasi malamalaweli luwali mena. Kuyokoyokoi-yagili kanasiga sipwalou na ali siliba siyeliwa koliwo. Siya analiyao nuwanuwali lalakina kaleya kutawo-gwaligwalili. ");
INSERT INTO tteo_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Itipita kuyokoi-yagili kabo ali mulolo kopa sikalailima. Besiele Idiopiya kani nimali siyagayan koliwo me ali yakasisi na sinuwabui. ");
INSERT INTO tteo_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Komiu yanuwa yaulina ana kaba loinao, meuloimiu kwawali-tobali Yeoba koina. ");
INSERT INTO tteo_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Kwawali-tobali iya imwalisae yaloyaloi koina yo isagesagena bulibuli mena, bulibuline iyamayaleyako kaba yatubu koina. Kwabenali koina iyoga kainana kaikaiwena koina. ");
INSERT INTO tteo_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Yaubada ana kaiwe kwawalo-masalan, Isileli meuloina iloiloinayan, yo ana kaiwe iyaele bulibuli mena. ");
INSERT INTO tteo_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Iya Isileli ali Yaubada, yo saugana ana Nume Tabu koina ikaisulu iyamala kaba matamatausi kabo kaiwe lalakina iwolena ana tomoyao kolili. Yaubada tatobalan. ");
INSERT INTO tteo_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","O Yaubada, kuleboyau kaiwena yau besiele tomo yabo kikiunamo igalomwasi kabo yawalo yakato waila isaemako galogalogu mena. ");
INSERT INTO tteo_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Iyaele yasasalili kaiwena nige yau kaba utu kalatan kaekaegu kaiwena. Yau ele didiu mena na kikiunamo yagalomwasi bagolu kolili. ");
INSERT INTO tteo_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Kamnagu inae yagu valam koina, yo galogalogu ikamkamna, mangu sikamkamna kaiwena yasanasana am sagu kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Siya analiyao sikalomagigi-lagau sibaibaiwasosi kabo muli mena itogu kulukulugu mena kali baibaiwa. Ali kalomagigilagaune nige yaina ipapagan. Simwakota kaiwegu, sikaiwesosi yo nuwanuwali siunuiyau. Gogone nige yakekewalili na siwalo tem yayapileyoili kolili. ");
INSERT INTO tteo_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","O Yaubada, yagu yauyaule ukwataiyako, nige sowana imiya-wadam koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","O Yeoba kowa Isileli ali Yaubada Tomiyasaesosi, tabu kutatalam yabeku kaiwena tem yabeku siya analiyao ali meli sipei koliwo kani nuwaliyao sinae yo simwalimwaline. ");
INSERT INTO tteo_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Kaiwem sisinaliyauko mwa mwalimwaline mangu ikausi. ");
INSERT INTO tteo_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Yau yaemala taumana kaukavao kolili yo yagu susu kolili. ");
INSERT INTO tteo_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Yagu yakasisi am Nume Tabu kaiwena kategu mena iwedowedoli besiele mayau. Na walo naenaeliyao kam tosinaliwo siwalowalo-wegili koliwo siwalowalo-wegili koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Tem guliyam yakalakisiye-yan na yanuwalobi tomo sitalawasi-yagau. ");
INSERT INTO tteo_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Tem kwauya kwamana yakwamai simalumalu-wagau. ");
INSERT INTO tteo_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Kamwasa mena sietalapili-yagau yo tonuma yauyaule waligu siwaliwaliyan ali kaba talawasi. ");
INSERT INTO tteo_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Na yau kaiwegu, kani yakawanoi Yeoba koliwo. O Yaubada, am sauga namwanamwana koina kainagu kuyamaisa. Am mulolo miyamiya yaina kaiwena am waloyameli ukabi-kalatan na kuleboyau. ");
INSERT INTO tteo_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Kuleboyau kau kaleyayao kolili kaiwena kagu lotonan besiele yasasalili kalita didididiuna koina. ");
INSERT INTO tteo_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Tabu bagolu sisusuwe pwaikiyau na tabu yasasalili yaboboita. ");
INSERT INTO tteo_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","O Yeoba, kainagu kuyamaisa kaiwena am mulolo miyamiya yaina inamwanamwasosi koliyau. Am katekamkamna koina kutagelakeile manim ilaoma koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Tabu manim kuwawadam am topaisowa koina kaiwena yau naenaena koina yamiyamiya kabo kuwalo mwayamwayau koliyau. ");
INSERT INTO tteo_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Kulaoma koliyau na kuleboyau, na kusaguiyau kau kaleyayaone kolili. ");
INSERT INTO tteo_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Kau kaleyayao meuloili ukwatailiko yo ali kawa-naenae-yagau kubenalanako yo yagu mwalimwaline ugitaiyako. ");
INSERT INTO tteo_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Kawa-naenae kategu sisibayanae mwa polowe yakalapowon. Katekamkamna yaloyaloyai na nige yabo yalolobai. ");
INSERT INTO tteo_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Saugana yaguliyam kan kelakelabasina siyeyama, galogalogu imagu na waila malumaluluna siyeyama. ");
INSERT INTO tteo_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Sowasowana ali kekan kolili Nume Tabu mena sibomayoi sisilae. ");
INSERT INTO tteo_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Manliyao kuyagibuli, yo dagelaliyao kuyabeluli sauga meuloina. ");
INSERT INTO tteo_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Am munamunai kusuwai kolili iunuili siwedoli. ");
INSERT INTO tteo_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Sowasowana meuloili kuyaboitali na ali kaba miya yo ali palai gaibuli. ");
INSERT INTO tteo_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Sowasowana uginauli besiele kaiwena tonaenaeline silaoma na siya sisilae am loina koina ali kamkamna sietulan yoi yo sietalapili-yagili. ");
INSERT INTO tteo_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Ali naenaena kunuwatu-kalatan na tabu am loina polopolowena koina siyayabubu. ");
INSERT INTO tteo_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Yawasi bukina koina esaliyao kusoke-gabaegili na tabu esaliyao kuyayasili-kaigedaili am tomoyao kolili. ");
INSERT INTO tteo_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Na yau yakamkamna yo me yagu nuwapolowe kabo yakawanoi Yaubada koliwo ukele-yatoloyau yagu kamkamnane kolili na kuleboyau. ");
INSERT INTO tteo_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Yaubada esana kani yatobalan wali mena, na yakeleisinan kawatoki koina. ");
INSERT INTO tteo_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Bwaite kani Yeoba ikabi-yaliyaya-yan kabo muli mena ana yaliyaya bulumakau tauna kana pwaoli kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Na saugana tem siya sikamkamna yagu tobali yo yagu kawatoki sibenalan kani siyaliyaya yo siya sipwalou Yaubada koina kani ikabi-yakaiweli. ");
INSERT INTO tteo_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Yeoba tobubutuma kainali ibenalagili yo ana tomo panpanli nige sowana isikotanagili. ");
INSERT INTO tteo_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Komiu bulibuli yo yanuwa yaulina yo komiu yamayamayale kwamiyamiya kalita kalona mena, Yaubada kwatobalan. ");
INSERT INTO tteo_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","36","Iya kani Yelusalema ileboi na yanuwane Yuda dedeina kalona mena ikabiyoili. Ana tomoyao kani yanuwane sikalai yo me natuliyao yo tubuliyao simiya namwanamwa bwaine koina kaiwena esana simulolo koina. ");
INSERT INTO tteo_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","O Yeoba yagu Yaubada, kusaguiyau bwaite saugamo na kuleboyau. ");
INSERT INTO tteo_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Sowasowana siya sitonatonan tem siunuiyau ukwaiwe-gabaegili na nuwaliyao kuula-pwanopwanolili. Yo siya siyaliyaya yagu miyapolowe kaiweli sowasowana kubui-keileli na simwalimwaline. ");
INSERT INTO tteo_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Na siya sitalatalawasi-yagau sowasowana ukwaiwe-gabaegili na simwalimwaline. ");
INSERT INTO tteo_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Sowasowana siya meuloili silaoma koliwo siyaliyaya lalakina. Sowasowana siya sikawa-toki koliwo am lebo kaiwena sauga meuloina siwaloba, “Yaubada iya Tokaiwesosi.” ");
INSERT INTO tteo_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","O Yeoba yagu Yaubada, yau yabelu yo yabubutuma, mwayamwayau kulaoma koliyau. Kowa kagu Tolebolebo kabo mwayamwayau mena kulaoma kusaguiyau. ");
INSERT INTO tteo_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","O Yeoba, yalaoma koliwo na kutolo-kaukausiyau. Tabu sauga yabo kau kaleyayao sikakaiwe-gabaegau. ");
INSERT INTO tteo_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Mumugam dudulaina koina kusaguiyau, tenam kuyawali koliyau na kuleboyau. ");
INSERT INTO tteo_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Kowa yagu veku yau kaba keno-wadam yo yagu nume kaikaiwena koina lebo yalobai. ");
INSERT INTO tteo_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","O Yeoba yagu Yaubada, toyauyaule yo tonaenaeli nimali mena kuleboyau, tabu ali munamunai kaikaiwena iunuiyau. ");
INSERT INTO tteo_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Me yagu katepatu yasanasana am lebo kaiwena. Kowa yagu kaba meli yagu sauga melumelu koina yo kanasiga kabona. ");
INSERT INTO tteo_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Yawasigu meuloina koina yameli koliwo, kowa ugite-kalatagau yagu sauga kabi koina kanasiga kabona, mwa kani sauga meuloina yatobalanagiwo. ");
INSERT INTO tteo_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Yawasigu iyamala kaba gite tomo meuloili kolili kaiwena kowa kagu totolo-kaukausi kaikaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Kaliyateliyao meuloili kolili yatobatobala-nagiwo yo am wasawasa yayawayawasayan. ");
INSERT INTO tteo_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Tabu kisi kusikotanagau kaiwena yatautaubalako yo tabu kulologabaegau iyaele yabeluko. ");
INSERT INTO tteo_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Kau kaleyayao sietaetalapili-yagau yo sinuwanuwatu sabi unuyamateyau kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Sibomayoi siwaloba, “Yaubada tomone isikotananako, tasagena mulina mena na takabi-kalatani kaiwena nige yabo kana tolebo.” ");
INSERT INTO tteo_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","O yagu Yaubada, tabu koliyau kumimiya suwala. Kulomwayamwayauma na kusaguiyau. ");
INSERT INTO tteo_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Sowasowana siya kagu toyakewao kaleya koina sibelu sisilae. Sowasowana siya analiyao nuwanuwali siyakamkamna-yau kuyamwalimwalineli. ");
INSERT INTO tteo_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Na yau kani me yagu katepatu yasanasana am lebo kaiwena, yagu tobali kani ilalalalaki sauga meuloina. ");
INSERT INTO tteo_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Mumugam dudulaina kani yawalo-masalan, am lebo kaliyate meuloina koina yaedeedede-yan, kaiwena am paisowa kaiwegu ilalakisosi, kana liye nige yakakatai. ");
INSERT INTO tteo_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Kani am paisowa kaikaiweli yatobalanagili, yo kani tomo meuloili ali wasa yaolegili kowa kubomamo todudulai yo tonamwanamwa. ");
INSERT INTO tteo_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","O Yaubada, yagu sauga kilakai mena kuyakenayagau, bwaine saugane koina yo kanasiga kabona am paisowa kaba nuwa-pwanopwano iyaelemo yawalowalo-masalagili. ");
INSERT INTO tteo_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","O Yaubada, bwaite saugane yatautaubala yo itogu ilike, tabu kisi kulogabaegau. Kowa mekaukava na am paisowa kaikaiweli yawalo-masalagili yaso silalaoma meuloili kolili. ");
INSERT INTO tteo_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Am dudulai isae bulibuli ilobai. Kowa ginauli lalakili kupaisowailiko kaiwena nige yabo besiele kowa. ");
INSERT INTO tteo_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Kowa naenaena yo kamkamna kuyawasalima koliyau, na iyamo kani yagu kaiwe kuyeyamayoi na tabu yaboboita. ");
INSERT INTO tteo_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Kani yagu kaiwe kuyalalaki yoi, yo kani ukabi-yaliyaya-yagau yoi. ");
INSERT INTO tteo_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","O yagu Yaubada, kani yatobalanagiwo api koina. Tabe am walo yawasosi kani yatobalan. Yagu api koina kani yawali koliwo kowa Isileli ana tabu kaigedamo. ");
INSERT INTO tteo_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Saugana yagu api yavenuvenu kani yogu meuloina koina yawali yo me yagu yaliyaya yawuiwui kaiwena kowa kuleboyau. ");
INSERT INTO tteo_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Kani kaliyate meuloina koina am dudulai kaiwena yaedeedede, kaiwena siya analiyao sitonan tem siyakamkamna-yau ukaiwe-gabaegiliko mwa simwalimwaline. ");
INSERT INTO tteo_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Solomoni ilele O Yaubada, loina namwanamwana yo mumugam dudulaina kuwolena kin koina, ");
INSERT INTO tteo_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","na mesabana am tomoyao mumugana dudulaina koina iloinayagili, yo loina dudulaina koina tomiya-polowe isaguili. ");
INSERT INTO tteo_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Sowasowana loina dudulaina imiyamiya yanuwane koina yo tomo ali tano siuwe namwanamwa siyaliyaya. ");
INSERT INTO tteo_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Sowasowana kin me ana loina dudulaina koina tobubutumao yo toeomao isaguili na kali tokalomagigiliwo iunuili. ");
INSERT INTO tteo_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","O Yeoba, sowasowana am tomoyao ali pwalou koliwo imiyayai besiele dabwelo yo waikena silalalala nige ana kaba mwawasi. ");
INSERT INTO tteo_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Besiele tano siyaliyaya galewa kaiwena sowasowana tomo siyaliyaya kin kaiwena, iya kali tosagu namwanamwana. ");
INSERT INTO tteo_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Sowasowana kin yawasina meuloina koina ana loina idudulaisosi yo tomo meuloili me ali nuwadaumwali yo siyaliyaya na ilaulau besiele waikena ana lalalala. ");
INSERT INTO tteo_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Sowasowana Yaubada kin ana kaba loina iyalalaki, iyatubu kalita sopa yabo mena ilobi ilau kalita sopa yabo mena, isae waila Yupeleitisi koina yo ilobi yavana ana dedei koina. ");
INSERT INTO tteo_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Kabo kin kana kaleyayao meuloili, yo tabe besiele tomo uloili simiyamiya dedei leleyanna koina, meuloili kani sipwalou ala kin manna mena. ");
INSERT INTO tteo_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Kabo dedei kelamamalawe kali kinyao ala kin wasana ilalaki sibenalan kabo ali mulolo sikalaili silaoma siwolena koina, besiele Sipein ali kin yo bwanabwanao ali kin yo Siba yo Seba ali kinyao. ");
INSERT INTO tteo_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Mwa kin meuloili kani sipwalou manna mena. Kaba loinao meuloili kani sipaisowa koina. ");
INSERT INTO tteo_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Kaiwena ala kin kani tobubutumao yo toeomao yo siya nige kali togite-kalatan ipapagan ali valam ibenalan na ileboili kali polowe kolili. ");
INSERT INTO tteo_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Besiele kani siya tobelu yo tobubutuma ikatekamkamna-yagili yo siya toeoma yawasili kani ileboili, ");
INSERT INTO tteo_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","meuloili kani ileboili ali polowe yo kamkamna kolili kaiwena kin manna mena tobubutumao yawasili ginauli lalakina koina. ");
INSERT INTO tteo_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Sowasowana kin ana miya imamalawe. Sowasowana tomo Seba ali mulolo gole sikalaiyama siwolena. Yo sowasowana tomo sauga meuloina sikawakawanoi ala kin kaiwena na tem Yaubada ana walo-mulolo ilobai. ");
INSERT INTO tteo_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Sowasowana ala kin ana loina koina ala yanuwa masuli lalakina yo tabe besiele koya kolili kan imiyamiya besiele Lebanon ali koya. Sowasowana tomo sidebalala na ala yanuwa ikalapowon besiele kawasi. ");
INSERT INTO tteo_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Sowasowana kin esana tabu tanunuwa-gabaen na imiyayai. Sowasowana kin wasana imiyamiya besiele dabwelo ana lalalala, nige ana kaba mwawasi. Sowasowana kaba loinao meuloili walo-mulolo silobai besiele ala kin walo-mulolo ilobai Yaubada koina. ");
INSERT INTO tteo_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Yeoba iya Isileli ala Yaubada, tatobalan. Iya ibomamo ginauli kaba nuwapwanopwano ipaisowaili. ");
INSERT INTO tteo_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Esana wasawasana tatobalan kani nige ilolotom. Sowasowana yanuwa yaulina meuloina ana wasawasa ikalapowon. O besiele, o besiele. ");
INSERT INTO tteo_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Bwaite Deibida iya Yese natuna ana kawanoi mwawamwawasina. ");
INSERT INTO tteo_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Asapi ilele Walo yawasosi, Yaubada inamwanamwa tomo Isileli kolili, tem siya analiyao kateliyao sikapwa. ");
INSERT INTO tteo_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Na yau kaiwegu, yau katepatu yo yagu meli kikiunamo sikwalalele, ");
INSERT INTO tteo_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","kaiwena yagitai togagasa yo toyauyaule siwasawasa mwa yalamwa-polowe-yagili. ");
INSERT INTO tteo_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Nige ali kamkamna yabo, me ali kaiwe yo me ali namwanamwa. ");
INSERT INTO tteo_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Ali polowe yo ali katewakaka kikiuli, nige besiele tomo namwanamwali ali polowe. ");
INSERT INTO tteo_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Ali gagasa sigaloi besiele galogalo wasawasana na kali kaleko bwaimwa kaleya. ");
INSERT INTO tteo_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Kateliyao sisese naenaena koina na simasumasuwe, kulukululi mena nuwatu yauyaulena ikalapowon. ");
INSERT INTO tteo_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Sitalatalawasi tomo kolili yo ali edeedede walo naenaena, me ali gagasa yo nuwanuwali tomo siyakamkamnali. ");
INSERT INTO tteo_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Yaubada sisinali yo me ali nuwasaesae siloina bwagabwaga tomo kolili. ");
INSERT INTO tteo_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Bwagana siyauyaule na iyamo Yaubada ana tomoyao toyauyaulene sitobalanagili yo sikawa-namwanamwa-yagili. ");
INSERT INTO tteo_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Toyauyaulene sigagasa siwaloba, “Yaubada nige ana katai yabo, ala paisowa naenaena Tomiyasaesosi nige inunuwa-mayaleyan.” ");
INSERT INTO tteo_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Siya bwaine toyauyaulene mumugali. Ginauli meuloina sowasowali na nuwanuwali tem yaboyoi. ");
INSERT INTO tteo_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Yakato mumugagu yagite-kalatan namwanamwai yo nige naenaena yagiginauli na maisagu nigele? ");
INSERT INTO tteo_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","O Yaubada, kaliyate meuloina kuyakamkamna-yau, malala kaigeda kaigeda am yokoi iunuunuiyau. ");
INSERT INTO tteo_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Tem toyauyaulene ali nuwatu koina yalau yo yagagasa yo yaedeedede besiele siya kabo kagu lotonan yakato yau nige am tomo. ");
INSERT INTO tteo_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Yanuwanuwatusosi bwaite polowene kaiwena na iyamo nige sowasowagu. ");
INSERT INTO tteo_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Na saugana yalusae am Nume Tabu koina kabo nuwagu imayale kani tawae iyawatagili toyauyaulene kolili. ");
INSERT INTO tteo_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Kani kupeili dedei mala sanesanenena koina na kuyabekuli na sisilae molosi. ");
INSERT INTO tteo_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Ali sibayanae imalaesosi, ali silae imatamatausi molosi. ");
INSERT INTO tteo_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Yawasili ali kwalalele besiele boniyai kenola takenoi na malala tatolo tanuwa-mwatainan mwayamwayau mena. O Yeoba, saugana kowa ukeno-tolo kani yawasili nuwam imwatainagili tabe. ");
INSERT INTO tteo_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Saugana kagu lotonan inae yo kategu ikamkamna, ");
INSERT INTO tteo_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","yagu nuwanuwatu besiele yakayakan ali nuwatu, nige yau katai yabo kaiwem. ");
INSERT INTO tteo_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Na iyamo sauga meuloina yamiya salim mena na nimam mena ukabi-kalatagau. ");
INSERT INTO tteo_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Am loina koina kuyabaguna-yagau, yo ana kaba mwawasi koina kani ukwalaiyau me am yakasisi. ");
INSERT INTO tteo_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Saugana yalusae bulibuli kani nuwanuwagu kowamo. Tem kowa mekaukava, kani tawae yoi yanuwatui yanuwa yaulina mena? ");
INSERT INTO tteo_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Bwagana yogu yo nuwagu sibelu na iyamo Yaubada iya yau kaba kaiwe yo yagu gadosisi meuloina iya kana toeyama. ");
INSERT INTO tteo_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Siya silo-dagedagela-yagiwo kani simwawasi, yo siya silau yaubada uloina koina kani isibayanaeli. ");
INSERT INTO tteo_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Na yau kaiwegu, yau kaba yaliyaya tem Yaubada saligu mena. Tem Yeoba yagu Yaubada itolo-kaukausiyau kani me yagu yaliyaya lalakina ana paisowa meuloina yawalo-masalan. ");
INSERT INTO tteo_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Asapi ilele O Yaubada, tawae kaiwena kusikotanagimai? Gubesi, kani am munamunai ilaulau am tomoyao kolimai nige ana kaba mwawasi? ");
INSERT INTO tteo_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Kunuwatu-kalatagimai kai am tomoyao kaiwena tubumayao ugite-sipwailiko sauga bagubagunana koina yo kubaguna-yagili siyawatagili panpanna koina siyamala am tomoyao. Kabo am kaba miya bwaimwa koya Saiyon kunuwatu-kalatan. ");
INSERT INTO tteo_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Kulokeikeile bwaite yanuwane sisibayanaene koina na ugitai kala kaleyayao ali paisowa, ginauli meuloina Nume Tabu kalona mena sisibayanaeyako. ");
INSERT INTO tteo_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Kam kaleyayao silusae am Nume Tabu kalona mena na me ali yaliyaya siwui ali kaiwe kaiwena. Imwawasi, ali kilakilala siyatololi na ali memenawa sikukeili yakato siya sikaiwesosi kabo kita. ");
INSERT INTO tteo_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Kaba lusalusae sitomli besiele mayau tokoi ule mena mayau sikoyagulili. ");
INSERT INTO tteo_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Nume kana bilibili sikogaogaolili ali kilam kolili. ");
INSERT INTO tteo_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Am kaba pwaoli siula-mosomoso yo Nume sisibayanae kabo sigabu iwedoli. ");
INSERT INTO tteo_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Nuwanuwali siutu-mutumutumai na kamwawasi molosi kabo kaba pwaoli yakayakasisili meuloili sigabu wolili ama yanuwa koina. ");
INSERT INTO tteo_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Ama gogo yakayakasisili meuloili simwawasiko yo nige yaboyoi ama palopita imiyamiya, yo nige yabo ikakatai kani tawanesana kabo bwaite imwawasi. ");
INSERT INTO tteo_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","O Yaubada, toweya kana mamalawe besiele na kani kala kaleyayao sitalawasi-yagiwo? Yakato esamne kani sisinasinali ilaulau nige ana kaba mwawasi? ");
INSERT INTO tteo_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Tawae kaiwena kusikote genuwam kusaguimai? Na tawae kaiwena nimam kupeili dagelam mena? ");
INSERT INTO tteo_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Na kowa Yaubada ama kin sauga bagubagunana koina kanasiga kabona yo sauga ibaibaiwa kuleboimai. ");
INSERT INTO tteo_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Am kaiwe mena kalita kuigali-labuiyan yo siya sisagena kalita pwatana mena kulukululi kusapi-gaolili. ");
INSERT INTO tteo_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Yo yamayamayale kali tobaguna matamatausina kalita mena kulukuluna kusapi-gaogaolili na yona boiboitana kuwolena yakayakan ule mena ali kaba kekan. ");
INSERT INTO tteo_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Waila bunubunuwasili kusokeli, yalubwasi kikiuli sididi, na yalubwasi lalakili kuyagumali. ");
INSERT INTO tteo_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Kaliyate yo boniyai kuyamayaleli, dabwelo yo waikena ali kaba miya kolili kupeili. ");
INSERT INTO tteo_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Yanuwa yaulina kali sigasiga kupeili, sauga wedowedoli yo sauga tulutulu kuyamayaleli. ");
INSERT INTO tteo_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Na Yeoba, kunuwatu-kalatan bwaite, kam kaleyayao nige ali yakasisi mwa sitalatalawasi-yagiwo yo esam sikalomagigilan. ");
INSERT INTO tteo_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Kabo tabu am tomoyao kulologabaegimai kisi kama kaleyayao ali munamunai kalobai kaiwena siya besiele yakayakan sokasokali na kai nige kama tosagu yabo. Tabu nuwam imwamwatainagimai, kai am tomoyao kakamkamna. ");
INSERT INTO tteo_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Kelabilabin kamwasanane uginauli kolimai kunuwatu-kalatan, kaiwena ama yanuwa mena ginauli matamatausili yo boniboniyai yo kaleya sikalapowon. ");
INSERT INTO tteo_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Tabu kutatalam na kai tokamkamna kamwamwalimwaline. Kusaguimai na kai tobubutuma yo toeoma kani esam katobalan. ");
INSERT INTO tteo_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","O Yaubada, toyauyaule sitalatalawasi-yagiwo kaliyate meuloina koina, kabo kunuwatu-kalatan kutolo na ali talawasi-yagiwone kaiwena kuyamaisali. ");
INSERT INTO tteo_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Kam tokaleyayao ali wui munamunai kunuwatu-kalatan iyaele ilaulau. ");
INSERT INTO tteo_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Asapi ilele O Yaubada, kakawatoki koliwo yo kawalo-masala am lalaki kaiwena yo am paisowa ginauli kaba nuwapwanopwano wasali kayawayawasa. ");
INSERT INTO tteo_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Yaubada iwaloba, “Sauga yapeiyako yatala kaiwena yo loina dudulaina koina kani tomo yayatala-yagili. ");
INSERT INTO tteo_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Bwagana yanuwa yaulina inuku yo yamayamayale meuloili simatausi sitabubu na iyamo yanuwa yaulina kana wauwau kani yakabi-kalatagili. ");
INSERT INTO tteo_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Yawalo togagasa kolili tabu nuwasaesae, ");
INSERT INTO tteo_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","yo walo gagasa silopei.” ");
INSERT INTO tteo_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Kaiwena yatala kani nige ilalaoma dabwelo ana kaba tunsae mena yo ana kaba sugu mena, nuwana teya yavana o nuwana teya bwauli, nigele. ");
INSERT INTO tteo_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Na Yaubada iya kani iyatala na iloina. Tupwaliyao kani ipei-yataluli na tupwaliyao kani ikeleisinagili. ");
INSERT INTO tteo_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Yeoba komwa nimana mena ikabi-kalatan ana munamunai koina ikalapowon. Yaubada ana munamunaine isuwai na toyauyaule meuloili sinuma kanasiga meuloina siyemwawasi besiele tomo oine kaikaiwena sinuma. ");
INSERT INTO tteo_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Na yau kani nige yalolopei edeedede Isileli ama Yaubada kaiwena, kani nige yalolopei wali-tobali iya koina. ");
INSERT INTO tteo_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Tonaenaeli ali kaiwe kani itom-gabaen, na todudulai ali kaiwe kani iyalalaki. ");
INSERT INTO tteo_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Asapi ilele Dedei Yuda koina Yaubada meuloili sikatai yo dedei Isileli esana siyakasisi-yan. ");
INSERT INTO tteo_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Ana kaba miya yanuwa Yelusalema koina bwaimwa koya Saiyon. ");
INSERT INTO tteo_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Bwaine koina kana kaleyayao ali gipoyo kana wamali igoluli, ali ebeu yo ali kaleya kelepali meuloili iyouli. ");
INSERT INTO tteo_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","O Yaubada, am wasawasa ilalakisosi kabo muli mena koya lalakili ali wasawasa. ");
INSERT INTO tteo_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Kabo ali tokaleyayao kaikaiweli ali kaleya gogoliyao ukele-gabaegili kolili na sauga bwaite siyaele siboitako sikenokeno, tokaleyayaone meuloili ali kaiwe imwawasi nige sowasowali nimali siyapaisowaili yoi. ");
INSERT INTO tteo_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","O Yaubada, kowa kai Isileli ama Yaubada, am yokoi koina osi yo kana tomwalisaewo sikanitu siboita. ");
INSERT INTO tteo_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Na kowa, Yeoba, tomo meuloili simatausagiwo. Yaiya sowasowana itolo manim mena sauga am munamunai ilalaki isasae? ");
INSERT INTO tteo_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","9","Saugana bulibuli mena kutolo kuwalo-lobima yanuwa yaulina mena am yatala kaiwena kabo yanuwa yaulina imatausi yo imwanou na mesabana siya sikamkamna leboili kaiwena wasana sibenalan. ");
INSERT INTO tteo_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Siya sikamkamna am munamunai maisana sigitai kabo kam tobali siyalalaki. ");
INSERT INTO tteo_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Kabo kuwolena Yeoba am Yaubada koina tawae kuwalo-yameliyako. Na komiu kaba loinao salimai mena, ami mulolo wakalailima koina. Yaubada tomo meuloili iyamatausagili, ");
INSERT INTO tteo_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","mwa kinyao siya esaliyao silalaki iyamatausagili yo natuliyao tataoliyao iwalo sinuwalobi. ");
INSERT INTO tteo_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Asapi ilele Yavalam koyasili Yaubada koina kabo kainagu ibenalan. ");
INSERT INTO tteo_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Sauga miyapolowe kolili yakawanoi Yeoba koina, boniyai meuloina koina nimagu yakeleisin na yakawakawanoi na iyamo nige sagu yalolobai. ");
INSERT INTO tteo_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Yatonan tem Yaubada yanuwatui na iyamo yayabayaba, yatonan tem yanuwa-daumwali na iyamo yanuwa-belubelu. ");
INSERT INTO tteo_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Yaubada nige itatalam na yakeno boniyai meuloina, kategu iwakaka nige sowana yaedeedede. ");
INSERT INTO tteo_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Yanuwatu-vivila sauga simwawasiko kolili yo sauga beyabeyasosili kolili. ");
INSERT INTO tteo_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Boniyai meuloina koina yanuwanuwatu lalakina, yatonan tem yanuwa-daumwali mwa bwaite besiele yagu nuwatu, ");
INSERT INTO tteo_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","“Gubesi, kani Yeoba isikotanagila sauga meuloina? Kani nige sauga yaboyoi iyayaliyaya kolila? ");
INSERT INTO tteo_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Gubesi, ana mulolo kolila ilopei? Yakato ana waloyameli kolila imwawasiko? ");
INSERT INTO tteo_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Gubesi, Yaubada ana katekamkamnawa kolila nuwana imwatainan? Yakato ana munamunai ana katekamkamna ikausi?” ");
INSERT INTO tteo_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Kabo yabomayoi yawaloba, “Yagu nuwapolowe bwaite, Yaubada Tomiyasaesosi nima ulaulana kaikaiwena kani nige iyayapaisowai yoi kaiwela.” ");
INSERT INTO tteo_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","12","O Yeoba, kani am paisowa kaikaiweli yo am paisowa ginauli kaba nuwa-pwanopwano sauga beyabeyana koina yanuwatu-kalatagili, yo am paisowa meuloina kani yanuwanuwatuili. ");
INSERT INTO tteo_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","O Yaubada, mumugam tabutabuna. Am kaiwe ilalakisosi kabo muli mena yaubadao meuloili ali kaiwe. ");
INSERT INTO tteo_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Kowa Yaubadanaele ginauli kaba nuwa-pwanopwano kupaisowaili, am kaiwe kuyakenayagili kaba loinao meuloili kolili. ");
INSERT INTO tteo_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Yo am kaiwe mena am tomoyao, Yakobo yo Yosepa tubuliyao kuleboili. ");
INSERT INTO tteo_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Saugana kalita yo bagolu sigitaiwo simatausi yo kalita gunna sitabubu simwasali. ");
INSERT INTO tteo_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Yaloyaloi galewa sisuwai ilobima, tutu itutu bulibuli mena na pigabu ipigabu ana kaba pigabu mena. ");
INSERT INTO tteo_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Tutu daguguna bwawa kalona mena, na pigabu mayalena koina yanuwa yaulina imayale yo mwanikiniki inuku. ");
INSERT INTO tteo_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Bagolu luwana mena kulau, kalita didididiuna kulopanaisi, na monam nige sowasowali sigitai. ");
INSERT INTO tteo_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Tomo kubaguna-yagili besiele sipi togite-kalatan ana paisowa, tomone siya Mosese yo Eloni ali loina yaulina mena silaulau. ");
INSERT INTO tteo_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Asapi ilele O yagu tomoyao, kwabenali yagu yakayakatai kolili. Tenamiyao kwasokeli na kwabenali tawae yawalowalowen. ");
INSERT INTO tteo_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Kani walo sonosonogali kolili yaedeedede kolimiu na nuwatu wadawadamli sauga beyabeyana kolili yakabi-yamayaleli kolimiu, ");
INSERT INTO tteo_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","siya edeededene tabenalagiliko yo takataili edeededene siya tamalao siwalowegiliko kolila. ");
INSERT INTO tteo_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Nige sowana tawadamli natulao kolili na kani tawalowen yaso waluwaluna kolili Yeoba ana kaiwe yo ana paisowa namwanamwali kaiweli. ");
INSERT INTO tteo_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Ana loinao iwolegili tubulao tomo Isileli kolili yo iwalo kolili loinaone siyakataili natuliyao kolili, ");
INSERT INTO tteo_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","na mesabana yaso ilalaoma sikatai namwanamwaili na siya tabe naga natuliyao siyakataili. ");
INSERT INTO tteo_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Bwaine kamwasane koina na mesabana ali meli sipei Yaubada koina yo sinuwatu-kalatan ana paisowa ginauli kaba nuwapwanopwano na ana loinao siobigaili. ");
INSERT INTO tteo_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Kabo tabu siya besiele tubuliyao siya togamwa-panapanawa, kateliyao sikololo yo ali meli sikikiu yo silau yaubadao uloili kolili. ");
INSERT INTO tteo_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Tabu siya besiele Ipeleim tokaleyayao. Bwagana me ali kaleya gogona na iyamo saugana tem kaleya ilaoma siyabubu. ");
INSERT INTO tteo_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Yaubada ana kelabilabin kamwasana nuwali imwatainan, genuwali ana loinao siobigaili. ");
INSERT INTO tteo_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Yo ana paisowa ginauli kaba nuwapwanopwano sinuwa-mwatainagili. ");
INSERT INTO tteo_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Tubuliyao manli mena Yaubada ginauli kaba nuwapwanopwano ipaisowaili Soan bubuna mena Itipita koina. ");
INSERT INTO tteo_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Kalita igali-labuiyan, yo iwalo waila sitolo besiele salibebe kabo tomo ibagunayagili silau silopanaisi. ");
INSERT INTO tteo_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Kaliyate mena ibagunayagili yaloyaloi koina yo boniyai koina mayau kalapulupululuna koina. ");
INSERT INTO tteo_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Veku lalakili ule mena iigalili sitasoke kabo waila iwolegili bwaimwa ilaomaya bwatano gunna mena. ");
INSERT INTO tteo_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Wailane ididi-yawatagilima veku mena besiele yalubwasi kikiuna imasumasuwema kabo iyamala yalubwasi lalakina. ");
INSERT INTO tteo_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Na iyamo ali yauyaule iyaelemo ilaulau, sigamwagamwa-panapanawa Tomiyasaesosi koina. ");
INSERT INTO tteo_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Sauga meuloina siwalo kaiwe nuwanuwali kali na ali samalulu mumugana koina Yaubada ana kalakisiye sitonan. ");
INSERT INTO tteo_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Siwaloba, “Gubesi, sowasowana Yaubada kala iyeyama kolila bwaite ule bwagabwagane koina? Nuwana nigele. ");
INSERT INTO tteo_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Bwagana vekune isapi na waila ididi-yawatagilima koina besiele yalubwasi na iyamo nige sowasowana ana tomoyao kan iwolegili.” ");
INSERT INTO tteo_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Kabo saugana ali walo ibenalagili Yaubada imunamunai mwa ikaleya kolili mayau wedolina mena. Ana munamunai ilalaki isaesae, ");
INSERT INTO tteo_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","kaiwena nige simemeli koina yo ali nuwatu yakato nige sowasowana ileboili. ");
INSERT INTO tteo_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Kabo iwalo bulibuli kana gamwa itasoke, ");
INSERT INTO tteo_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","kabo mana sibekuma kali besiele galewa italu. ");
INSERT INTO tteo_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Na mana besiele anelose kali kabo iwolegili sikekan na iyamo ilalakisosi. ");
INSERT INTO tteo_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Yaubada ana paisowa koina bolibolime yo yavana silotalu, ");
INSERT INTO tteo_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","kabo man iyawasali silobima, kali baibaiwa besiele dekawa busu galagala mena, ");
INSERT INTO tteo_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","sibekuma ali kaba gogo luwaluwalili mena, ali palai siyatakikilili. ");
INSERT INTO tteo_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Kabo tomo sikekan diyaliyao sisu kaiwena iwolegili besiele tawae ali nuwatu. ");
INSERT INTO tteo_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Na muliya kabo ali kekan imwawasi yo ali gadosisi kekanne kaiwena iyaelemo ilaulau, ");
INSERT INTO tteo_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","Yaubada imunamunai tomo Isileli kolili mwa ali kilakai kaikaiweli iunuili siboita. ");
INSERT INTO tteo_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Bwagana Yaubada ana paisowa ginauli kaba nuwapwanopwano sigitailiko na iyamo nagamo naenaena siginaginauli yo nige simemeli koina. ");
INSERT INTO tteo_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Kabo yawasili iyui-yamateli yo ali boita kana koleya imatamatausi sosi. ");
INSERT INTO tteo_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Saugana tupwali iunuyamateli kabo meuloili sinuwabui sipileyoi koina yo me ali kaiwe sikawakawanoi. ");
INSERT INTO tteo_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Yo sinuwatu-kalatan yakato Yaubada Tomiyasaesosi iya kali totolo-kaukausi yo kali tosagu. ");
INSERT INTO tteo_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Na iyamo mwakota sopali mena siedeedede. ");
INSERT INTO tteo_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Kateli mena nige siyayakasisi-yan yo ana kelabilabin kamwasana nige simumuliya. ");
INSERT INTO tteo_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Na iyamo ikatekamkamna-yagili yo ali naenaena inuwatu-pwaiki kabo nige isisibayanaeli. Na sauga ibaibaiwa ana munamunai ikabi-kalatan yo nige iuunuili. ");
INSERT INTO tteo_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Inuwatu-kalatan yakato siya tomo molosi ali miyamiya sauga kubwakubwanamo besiele yaumai sauga kubwakubwana koina itowa na imwawasi. ");
INSERT INTO tteo_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Na ule bwagabwaga mena sauga ibaibaiwa sigamwapanapanawa mwa kaiwena katena ikamkamna. ");
INSERT INTO tteo_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Yo sauga meuloina ana kalakisiye sitonatonan mwa Isileli ali Yaubada tabutabuna katena siula-munamunai. ");
INSERT INTO tteo_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Ana paisowa meuloili nuwali imwatainagili, saugana ileboili kali kaleyayao kolili, ");
INSERT INTO tteo_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","yo ginauli kaba nuwapwanopwano meuloili ipaisowaili Soan bubuna mena Itipita koina. ");
INSERT INTO tteo_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Kaba gite bwaite, ali yalubwasi siyamala kwasine kabo Itipita nige ali kaba numa waila, ");
INSERT INTO tteo_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","nonowala iyawasali silaoma siyamala tomo Itipita ali kaba okwatakwata, besiele kwekwe ali bwatano sisibayanae, ");
INSERT INTO tteo_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","besiele mwalimwali iyawasali silaoma na kali sisibayanaeli, ");
INSERT INTO tteo_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","48","galewa pokopokoli lalakili sitalu kabo ali oine yo bulumakau isibayanaeli, mayau esana fig siboita wabumali kaiwena yo ali sipi siboita tutu yo pigabu koina, ");
INSERT INTO tteo_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","yo boita kana anelose iyawasali silaoma kabo ali paisowa koina Yaubada ana munamunai lalakina siyakena-yagili mwa Itipita kamkamna lalakina silobai. ");
INSERT INTO tteo_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Na paisowane koina ana munamunai nige ikakabi-kalatan na iunuili muya yabo koina, ");
INSERT INTO tteo_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","kabo Itipita natuliyao tatao tobagubagunao susu kaigeda kaigeda kolili iunuyamateli. ");
INSERT INTO tteo_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Imwawasi ana tomoyao ibagunayagili besiele sipi siyawatagili yo ali kamwasa iyakenayagili ule bwagabwaga mena. ");
INSERT INTO tteo_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Ali lau koina igite-kalatagili mwa nige sowasowana simatausi, na kalita bagoluna igolu kali kaleyayao pwatali mena. ");
INSERT INTO tteo_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Kabo ana tomoyao ikalaili ilawagili ana yanuwa yakayakasisina koina, bwaimwa koya Saiyonne iboma ikalaiyako kaiweli. ");
INSERT INTO tteo_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Kaba loinao uloili itawoili Isileli manli mena, ali bwatano iyakasali iwolegili ana tomoyao kolili simiya. ");
INSERT INTO tteo_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Na bwagana ginauli meuloina ipaisowai kaiweli na iyamo ana kalakisiye iyaelemo sitonatonan, yo ali Yaubada Tomiyasaesosi sigamwapanapanawa koina yo genuwali ana loina simuliya, ");
INSERT INTO tteo_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","simiya-dagedagela-yan besiele tubuliyao ali paisowa. Mumugali inaesosi Yaubada nige sowasowana ana meli ipei kolili. ");
INSERT INTO tteo_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Kaba pwaoli siginaulili yaubadao uloili kolili yo kokotomo kolili sipwalou kabo Yaubada siula-munamunai. ");
INSERT INTO tteo_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Saugana mumugaline igitai kabo ana munamunai ilalaki isaesae kanasiga ana tomoyao Isileli isikote-molosagili. ");
INSERT INTO tteo_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Ana palai yanuwa Sailo koina ilogabaen bwaine koina beyabeyana imiyamiya ana tomoyao mekanakavao. ");
INSERT INTO tteo_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Kabo italam kali kaleyayao kelabilabin kamwasana kana dedewaga, bwaimwa ana kaiwe yo ana wasawasa kana kilakilala, sikwayai kaleya luwana mena silawan ali yanuwa mena. ");
INSERT INTO tteo_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Ana tomoyao siula-munamunai kabo italamwagili kali kaleyayao ali kaleya kelepana koina sietomtom-wagili. ");
INSERT INTO tteo_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Ali kilakaiwo siboita kabo Isileli vesalao nige ali kaba kawalulu. ");
INSERT INTO tteo_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Ali topwaoli siboita kaleyane koina yo ali kwabukwabuliwo nige sowasowali sinuwanae ali toboitao kaiweli. ");
INSERT INTO tteo_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Yeoba itolo, besiele tokeno yabo ikeno-toloma ana kaba keno mena, besiele tomo kaikaiwena me ana kabaleya ikalekaleya me ana munamunai. ");
INSERT INTO tteo_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Kabo kana kaleyayao itubali-yavivilali yo ikaiwe-gabaegili me ali mwalimwaline. ");
INSERT INTO tteo_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Yosepa yo Ipeleim tubuliyao ali bodao isikotanagili. ");
INSERT INTO tteo_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Na Yuda tubunao ali boda igite-sipwaili siyamala ana tomoyao yo koya Saiyon iyamala ana kaba miya iya imulolososi koina. ");
INSERT INTO tteo_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Bwaine koina ana Nume Tabu ikabi, besiele ana nume bulibuli mena, yo ikabi-yakaiwe kabo ikaiwesosi yo imiyayai besiele yanuwa yaulina kana wauwau. ");
INSERT INTO tteo_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","71","Deibida imiyamiya bubu mena ana sipi igitegite-kalatagili na Yaubada igite-sipwai mwa iyogan iyapaisowa iyamala Isileli ali kin na Yaubada ana tomoyao igite-kalatagili besiele sipi. ");
INSERT INTO tteo_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Me kate yawasosina koina igite-kalatagili yo ibagunayagili me ana katai. ");
INSERT INTO tteo_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Asapi ilele O Yaubada, tomo siya nige tomeli silusaemako am yanuwa mena yo am Nume Tabu sisibayanae yo Yelusalema taon sisibayanae molosan itata-gwaligwali. ");
INSERT INTO tteo_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Am tomoyao yoli boiboitali siwolegili magesubu kali ali kaba kekan, yo am topaisowao yakayakasisili kwapiliyao siwolegili yakayakan sokasokali kolili sikekan. ");
INSERT INTO tteo_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Am tomoyao siunuili kwasineliyao sididi besiele waila sisuwai Yelusalema meuloina koina. Nige yaboyoi tupwa tomo imiyamiya na toboita kwapiliyao ipuluili. ");
INSERT INTO tteo_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Kaba loinao meuloili salimai mena sitalatalawasi-yagimai, kaemala ali kaba malu. ");
INSERT INTO tteo_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","O Yeoba, gubesi, kani am munamunai imiyayai kolimai kani nige ilolopei? Yakato am munamunai ilaulaumo na iwedowedoli besiele mayau? ");
INSERT INTO tteo_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Am munamunaine kubui ilau kaba loinaone siya nige sipwapwalou koliwo yo tomo siya nige sikawakawanoi koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Kaiwena am tomoyao siunuyamateliko yo am yanuwa sisibayanae molosan. ");
INSERT INTO tteo_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Tabu kuyayamaisamai tubumayao ali pwanoli kaiweli, na bwaite sauga ukwate-kamkamna-yagimai kaiwena kai kamiyamiya yauli molosi mena. ");
INSERT INTO tteo_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","O Yaubada, kusaguimai yo kuleboimai, ama pwanoli kunuwatu-pwaikili kaiwena kowa esam yakasisi. ");
INSERT INTO tteo_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Tabu kutatalam kaba loinao sineneli-samasamalulu kolimai siwaloba, “Ami Yaubada toweya?” Kam gum kuyai kuyamaisali kaiwena am topaisowao siunuili yo kwasineliyao siyadidili. Am munamunai kuyakenayagili kolili na kagitai. ");
INSERT INTO tteo_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Topaisowa panpanli ali yaba kubenalan, na am kaiwe lalakina mena siya kikiunamo kani siboita kulivasili. ");
INSERT INTO tteo_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","O Yeoba, kaba loinaone kuyamaisali me seben, ali walo sinasinali koliwo kaiwena kuyamaisali. ");
INSERT INTO tteo_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Kabo kai am tomoyao, am sipi bodana, kani kakawatoki koliwo sauga meuloina nige ana kaba mwawasi. ");
INSERT INTO tteo_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Asapi ilele O Yeoba, kai Isileli kama togite-kalatan kowa, kai am sipi bodana yo kowa ama tobaguna, ama walo kubenalan. Kowa kumiyasio am kaba miya wasawasana koina na yaulim mena aneloseyao simiyamiya. ");
INSERT INTO tteo_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Na kubomayoi kuyakenayagiwo boda Ipeleim, Beniyamina, yo Manase kolili na sikataiwo. Am kaiwe kuyakenayagimai yo kulaoma kuleboimai. ");
INSERT INTO tteo_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","4","O Yeoba ama Yaubada Tokaiwesosi, am katekamkamna kuyakenayagimai na lebo kalobai. Isa sauga kana mamalawe kani am tomoyao ali kawanoi koina kumunamunai? ");
INSERT INTO tteo_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Kamkamna kuyeyama koina kakekan, yo matalilo komwana lalakina kanuma. ");
INSERT INTO tteo_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Kutalam kaba loinao uloili silaoma sibomayoi kolili sikalekaleya na tem ama bwatano sikalaili. Kama tokaleyayaone sibomamo kaloli mena sitalatalawasi-yagimai. ");
INSERT INTO tteo_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","O Yaubada Tokaiwesosi, ukwele-yavivilayoimai. Am katekamkamna kuyakenayagimai na lebo kalobai. ");
INSERT INTO tteo_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Itipita koina oine likena ukwalai kulaoma kabo tomo kutawoili na ali yanuwa mena oine likenane ukumai. ");
INSERT INTO tteo_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Yanuwane kusepa kabo oinene ikin lamna ilobi kabo idebalala yanuwa meuloina ikalai. ");
INSERT INTO tteo_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Kabo koya isumali lolonna koina yo lagalaganao silalakisosi kabo muli mena mayau lalakiliyao lagalagaliyao. ");
INSERT INTO tteo_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Tabe lagalaganao iyagayanli silau kalita Mediteleiniya koina yo tabe sisae teya kaluwabu mena Yupeleitisi wailana koina. ");
INSERT INTO tteo_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Na tawae kaiwena Yelusalema kana gana kusibayanae ibeku? Kabo sauga bwaite tomo meuloili kamwasa mena silaulau sowasowali oinene sikewalili. ");
INSERT INTO tteo_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Polo ule oinene siutu-gwalagwalaili kabo oinene iyamala yakayakan sokasokali ali kaba kekan. ");
INSERT INTO tteo_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","O Yaubada Tokaiwesosi, kutagelakeile yoi na bulibuli mena ugite-lobima kolimai na kulaoma am tomoyao kuleboimai. ");
INSERT INTO tteo_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Kulaoma na bwaite oinene ukukumaine kuleboi, iya beyabeyana like waluwaluna na am gite-kalatan koina ilalaki ikin ikaiwe. ");
INSERT INTO tteo_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Kama kaleyayao silaoma na oinene sitom iguli kabo sigabu. Me am munamunai ugitaili na kusibayanaeli. ");
INSERT INTO tteo_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Am tomoyao gitegite-sipwaili kutolo-kaukausili kaiwena beyabeyana am gite-kalatan koina kaemala boda kaikaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Kani nige sauga yaboyoi dagelamai kaeyawa koliwo. Yawasimai kuyeyama na katobalanagiwo. ");
INSERT INTO tteo_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","O Yaubada Tokaiwesosi, ukwele-yavivilayoimai. Am katekamkamna kuyakenayagimai na lebo kalobai. ");
INSERT INTO tteo_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Asapi ilele Kwawuiwui me ami yaliyaya Yaubada kala totolo-kaukausi koina, yo kwawali-tobali Isileli ala Yaubada koina. ");
INSERT INTO tteo_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Venu kwayatubu, tambalin wakoili yo api lalakili yo api kikiuli kwavenu-wagili na daguguna namwanamwali tabenalan. ");
INSERT INTO tteo_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Bwagigi kwayui kekan lalakina kana sauga koina nuwana waikena waluwaluna o nuwana waikena imatuwa kali sauga. ");
INSERT INTO tteo_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Nuwatu-kalatan kekanna bwaite iyamala tomo Isileli kali loina na loinane ilaomaya Isileli ala Yaubada koina. ");
INSERT INTO tteo_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Kabo loinane iwolegili tomo Isileli kolili saugana ikaleya yanuwa Itipita koina. Kaina yabo yabenalan, kainane nige yakakatai, iwalowalo koliyau iba, ");
INSERT INTO tteo_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","“Kami kayakayale dagelamiu mena yakele-gabaegiliko. Tabe yatalam bilikine kwapei-yataluli. ");
INSERT INTO tteo_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Saugana kwamiya-polowe Itipita koina kabo kwayoga koliyau sagu kaiwena mwa yaleboimiu. Kainagu iyamala tutu yaloyaloi luwana mena kabo ami yaba yayamaisa. Muli mena yatonagimiu Meliba wailana koina. ");
INSERT INTO tteo_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","O yagu tomoyao Isileli, yagu yanuwapei kolimiu kwabenalan. ");
INSERT INTO tteo_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Tabu sauga yaboyoi yaubada yabo koina kwapwalou. ");
INSERT INTO tteo_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Yau Yeoba ami Yaubada, yau mwa yakalaimiu Itipita koina kwayawatagili. Gamwamiyao kwasaeili na yayakanmiu. ");
INSERT INTO tteo_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Na iyamo yagu tomoyao Isileli nige sibebenali koliyau, genuwali kainagu sioobigai. ");
INSERT INTO tteo_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Kabo yatalam siboma ali nuwatu mena silau ali gamwapanapanawa kaiwena yo tawae nuwanuwali siginauli yatalamwagili. ");
INSERT INTO tteo_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Nuwanuwagu lalakina yagu tomoyao Isileli sibenali koliyau yo kainagu siobigai. ");
INSERT INTO tteo_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Tem siobigaiyau kani mwayamwayau kali kaleyayaone yakaiwe-gabaegili yo kali tokalomagigili yaunuili. ");
INSERT INTO tteo_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Siya sikalomagigi-lagau kani me ali matausi sipwalou mangu mena, kali maisa kani imiyayai. ");
INSERT INTO tteo_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Na kani yayakanmiu witi namwanamwasosina koina na diyamiyao sisu kamwakamwa koina.” ");
INSERT INTO tteo_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Asapi ilele Yaubada imiyasio ana kaba miya wasawasana koina bulibuli mena na mesabana yaubadao meuloili iyatalayagili yo kali loina iwolegili. ");
INSERT INTO tteo_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Kabo iwaloba, “Loina dudulaina mena kwayatala, tabu sauga yaboyoi ami yatala koina toyauyaulene kwasaguili. ");
INSERT INTO tteo_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Loina dudulaina kwaolena tobubutumao, siya nige tamaliyao sipapagan, siya sikamkamna yo siya nige kali tosagu yabo, kali loina kaigeda. ");
INSERT INTO tteo_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Kwaleboili tonaenaeli ali kaiwe koina. ");
INSERT INTO tteo_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Komiu yaubadao kwabenali. Komiu toyauyaule, nige ami katai yabo. Komiu boniboniyai mena kwalolokeikeile kabo loina dudulaina kwasibayanaeyako. ");
INSERT INTO tteo_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Bwagana komiu yakato yaubadao yo yau Tomiyasaesosi natuguwao, ");
INSERT INTO tteo_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","na iyamo kani kwaboita besiele tomo, yawasimiu kani yatom-gabaen besiele kin natuna yabo yawasina.” ");
INSERT INTO tteo_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Kabo kai kawaloba, “O Yaubada, kutolo na yanuwa yaulina kuloinayan kaiwena kaba loinao meuloili siya am gogo.” ");
INSERT INTO tteo_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Asapi ilele O Yaubada, tabu kumimiya-mwanou. ");
INSERT INTO tteo_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Kam kaleyayao yo kam tokalomagigiliwo ugitaili, siyaele sigamwagamwa-panapanawa koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Siyaele wadam mena ali loina naenaeli sinuwanuwatuili na tem am tomoyao, siya mwa kutolo-kaukausili, sikaleya kolili. ");
INSERT INTO tteo_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Siwaloba, “Kwalaoma na Isileli ali kaba loinane tasibayanae na mesabana Isileli nuwala imwatainan yawasosi.” ");
INSERT INTO tteo_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Kabo sitalam ali nuwatune koina mwa siboda kaigeda na sikaleya koliwo Yaubada. ");
INSERT INTO tteo_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Kam tokaleyayao esaliyao bwaite, tomo Idoma, Isimeli, Mowabe, Agaliniya, ");
INSERT INTO tteo_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","Gibal, Amoni, Amaleki, Pilistiya yo Taiya. ");
INSERT INTO tteo_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Besiele tabe Asiliya silogogoma mekalikavao, yo tabe Amoni yo Mowabe, siya Lota tubunao. ");
INSERT INTO tteo_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","10","Na uginauli kam tokaleyayaone bwaite kolili besiele tawae beyabeyana uginauliyako Midiya, Sisaliya yo Yabini waila Kisoni yo yanuwa Endola kolili. Bwaine koina kusibayanaeli yo yoli meuloili sibowa bwatano mena. ");
INSERT INTO tteo_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Kam tokaleyayaone ali tobagunao ukwaiwe-gabaegili besiele beyabeyana Olebi, Sibi, Seba yo Salimuna ukaiwe-gabaegili, ");
INSERT INTO tteo_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","siya mwa beyabeyana siwaloba, “Yaubada ana bwatano kani takalai iyamala ala gogo.” ");
INSERT INTO tteo_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","O Yaubada, kuyasulu-gwaligwalili besiele bwatano kauna yo besiele lei mosomosona yaumai iyui-kalakalai. ");
INSERT INTO tteo_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Na besiele mayau kalapulupululuna iwedoli koya mena na ilau ule meuloina iwedoli isibayanae, ");
INSERT INTO tteo_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","ee besiele uginauli kolili. Kutawoili am wowoli kaikaiwena koina yo am wediliya koina kuyamatausagili. ");
INSERT INTO tteo_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","17","O Yeoba, mwalimwaline kuyakalapowonli manli mena na am kaiwe sikilala yo sikatai. Ukwaiwe-gabaegili na ali matausi simiyayai na ali mwalimwaline iunuili siboita. ");
INSERT INTO tteo_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Sowasowana sikatai yakato kowa Yeoba kubomamo Tomiyasaesosi yo kuloina yanuwa yaulina meuloina koina. ");
INSERT INTO tteo_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Kola natunao silele O Yaubada Tomiyasaesosi, yamulolo lalakina am Nume Tabu koina. ");
INSERT INTO tteo_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Nuwanuwagu lalakisosina tem yau bwaine koina. Yagu kaba yaliyaya tem yau yamiyamiya kalona mena. Yogu yo yaluyaluwagu meuloina me ali yaliyaya siwali Yaubada meyawasina koina. ");
INSERT INTO tteo_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","O Yeoba Tomiyasaesosi, kowa yau kin yo yagu Yaubada, kai meuloimai nuwanuwamai kamiyamiya salim mena yo tabe besiele man. Ali noi sipaisowaili am Nume koina besiele tabe siya kitekitele yo buyali yo natuliyao sipeili am kaba pwaoli salina mena. ");
INSERT INTO tteo_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Siya analiyao simiya am nume mena siyaliyaya lalakina. Sauga meuloina kam tobali siwaliwali-yagili. ");
INSERT INTO tteo_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Siya analiyao ali kaiwe ilaomaya koliwo siyaliyaya lalakina, siya ali nuwatu sikaiwe tem silau koya Saiyon koina na sipwalou koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Saugana silaulau Baka kalogawana leleyanna koina dedeinane iyamala waila bunubunuwasili sikalapowon simasumasuwe kaiwena galewa naga kana sauga na italu baguna. ");
INSERT INTO tteo_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Mwa ali lau koina yoli sikaiwe yoi, kikiunamo yaubadao ali Yaubada kani sigitai Yelusalema koina. ");
INSERT INTO tteo_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","O Yaubada Tomiyasaesosi, kowa kai Isileli ama Yaubada, yagu kawanoi kubenalan. ");
INSERT INTO tteo_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Ama kin kuwalo-muloloi iya mwa ugite-sipwaiyako. ");
INSERT INTO tteo_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Tem yamiyamiya am Nume Tabu kalona mena kaliyate kaigeda koina kagu lotonan inamwanamwasosi kabo muli mena kaliyate ten tausan yagu yanuwa koina kagu lotonan. Yo tem yatolo Nume Tabu kana gamwa koina kagu lotonan inamwanamwasosi kabo muli mena yamiyasio toyauyaule ali nume wasawasali kaloli mena. ");
INSERT INTO tteo_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Kaiwena Yeoba iya kala totolo-kaukausi yo ala Kin wasawasana, sauga meuloina iwalo-muloloila, ikate-kamkamna-yagila yo isaguila. Nige sowana ginauli namwanamwana yabo inuwai siya analiyao mumugana dudulaina sipaisowai. ");
INSERT INTO tteo_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","O Yeoba Tomiyasaesosi, siya analiyao simeli-yagiwo siyaliyaya. ");
INSERT INTO tteo_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Kola natunao silele O Yeoba, am mulolo ilalakisosi am yanuwa koina. Uginauli tomo Isileli sidebalala yoi yo ali tano sikin namwanamwa. ");
INSERT INTO tteo_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Am tomoyao ali pwanoli meuloili kunuwatu-pwaikili. ");
INSERT INTO tteo_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Am munamunai kolili kulopei, yo am kaleya kuyamwanou. ");
INSERT INTO tteo_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","O Yaubada kama Tolebolebo, ukwele-yavivilamai yoi na am yokoi kupei-suwalan kolimai. ");
INSERT INTO tteo_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Gubesi, kani am munamunaine imiyayai kolimai? Yakato ilaulau yaso yo yaso kolili? ");
INSERT INTO tteo_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Ukwabi-yakaiweyoimai, na kai am tomoyao katobalanagiwo. ");
INSERT INTO tteo_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","O Yeoba, am mulolo miyamiya yaina kuyakenayagimai, na lebo yo sagu kuyeyama kolimai. ");
INSERT INTO tteo_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Mwa yau yabenabenali koina, tawae Yeoba Yaubada iwalowalowen, daumwali iwaloyameli kolila, iboma ana tomoyao, tem nige tapipileyoi ala kamwasa yauyauleli kolili. ");
INSERT INTO tteo_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Walo yawasosi iya inonowako sabi lebo analiyao siya siyakasisi-yan, na ala yanuwa kani iloyapowon ana wasawasa koina. ");
INSERT INTO tteo_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Besiele tomo sielobelobe yo simulolo, Yaubada mumuganao, bwaimwa mulolo, walo yawasosi, mumuga dudulaina yo daumwali kani siginauli besiele. ");
INSERT INTO tteo_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Walo yawasosi kani ibunubunuwasi bwatano koina na isae kewa mena. Mumuga dudulaina bulibuli mena kani igite-lobima yanuwa yaulina mena. ");
INSERT INTO tteo_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Yeoba kani iwalo-muloloila yo ala yanuwa imasuli na ala kelikeli inamwanamwa. ");
INSERT INTO tteo_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Kabo mumuga dudulaina kani ibaguna ilau Yeoba ana kamwasa ikatububun kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","O Yeoba, tenam kuyawali yo kainagu kuyamaisa kaiwena nige yagu kaiwe yabelusosi. ");
INSERT INTO tteo_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Kuleboyau boita koina kaiwena yau tomo yakayakasisina. Yau am topaisowa yo yagu meli yapei koliwo kabo kuleboyau. ");
INSERT INTO tteo_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Kowa yagu Yaubada, ukwate-kamkamna-yagau. Kaliyate meuloina koina yakawanoi koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","O Yeoba, am topaisowa ukwabi-yaliyaya kaiwena yagu kawanoi sisaewako koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Kowa kunamwanamwa kolimai yo ama pwanoli kunuwatu-pwaikili, am mulolo imiyayai siya analiyao sikawanoi koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","O Yeoba, yagu kawanoi yo yagu valam sagu kaiwena kubenalagili. ");
INSERT INTO tteo_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Sauga miya polowe kolili yayoga koliwo kaiwena yagu kawanoi kuyamaisali. ");
INSERT INTO tteo_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","O Yeoba, nige yaubada yabo besiele kowa, ali paisowa nige besiele kowa am paisowa. ");
INSERT INTO tteo_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Kaba loinao meuloili kowa kuyamayaleli kani silaoma sipwalou koliwo yo esam kani sitobalan na sikawa-wasawasa-yan. ");
INSERT INTO tteo_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Kowa tokaiwe yo ginauli kaba nuwapwanopwano kupaisowaili, mwa kowa kubomamo Yaubada. ");
INSERT INTO tteo_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","O Yeoba, kuyakataiyau tawae nuwanuwam yapaisowai na mesabana yaobigaiwo sauga meuloina. Kuyakenayagau na yapaisowa koliwo me yagu talam yawasosi. ");
INSERT INTO tteo_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","O Yeoba yagu Yaubada, kani yatobalanagiwo kategu meuloina mena yo am lalaki yawalo-masalan sauga meuloina. ");
INSERT INTO tteo_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Am mulolo miyamiya yaina koliyau ilalakisosi kaiwena kikiunamo yaboita na kulaoma yo kuleboyau. ");
INSERT INTO tteo_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","O Yaubada, tomo gagagagasali silalaoma sabi unuiyau, tomo naenaesosili bodaliyao sitonatonan tem siunuyamateyau, bodane bwaine genuwali kainam sibenalan. ");
INSERT INTO tteo_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Na Yeoba kowa tokatekamkamna yo tomulolo, sauga meuloina me am kalakisiye kunuwalobi yo kowa towalo yawasosi. ");
INSERT INTO tteo_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Manim ilaoma koliyau na ukwate-kamkamna-yagau, ukwabi-yakaiweyau na kuleboyau kaiwena yau yapaisowa koliwo besiele sinagu ipaisowai koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","O Yeoba, naga am namwanamwa kuyakenayagau na mesabana siya analiyao sikalomagigi-lagau kani simwalimwaline, saugana tem sigitai am miya saligu mena yo am saguiyau. ");
INSERT INTO tteo_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Kola natunao silele Yeoba ana yanuwa lalakina ikabi ana koya yakayakasisina koina. ");
INSERT INTO tteo_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Yanuwa Yelusalema imulolososi koina kabo muli mena yanuwa meuloili kolili ana mulolo. ");
INSERT INTO tteo_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","O Yelusalema, kowa Yaubada ana yanuwa lalakina, ginauli namwanamwali iwalowalo-wegili kaiwem kubenalagili. ");
INSERT INTO tteo_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Yagu tomoyao siobiobigaiyau tupwaliyao siyaele Itipita koina, tupwaliyao Babilon, tupwaliyao Pilistiya, Taiya yo Idiopiya kolili kabo kani yayasilili yakato Yelusalema koina simiyamiya. ");
INSERT INTO tteo_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Na Saiyon kaiwena kani siwalo yakato tomo meuloili sikabili Saiyon koina. Yaubada Tomiyasaesosi ana yanuwa Saiyon kani ikabi-yakaiwe. ");
INSERT INTO tteo_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Na Yeoba kani ana tomoyao iyasilili yo kaigeda kaigeda kaiwena kani iwaloba, “Bwaite sikabiya Yelusalema koina.” ");
INSERT INTO tteo_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Siya kani siselo yo siwali ali wali walona bwaite besiele, “Saiyon iya ala walo-mulolo meuloili yaina.” ");
INSERT INTO tteo_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Kola natunao silele O Yeoba yagu Yaubada, yayoga sagu kaiwena kaliyate meuloina koina, na boniyai yavalam-saewa. ");
INSERT INTO tteo_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Kutalam yagu kawanoi ilaowa manim mena yo tenam kuyawali yagu valam sagu kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Polowe sibaibaiwa sitalu pwatagu mena kabo kikiunamo yaboita. ");
INSERT INTO tteo_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Yau besiele siya tupwaliyao boita dedeina mena silaulau, yau kaiwe meuloina imwawasi. ");
INSERT INTO tteo_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Silogabaegauko toboitao luwali mena, yau besiele siunuiyau yaboita na yakenokeno salai mena. Toboitaone kunuwa-mwatainagiliko, kaiwena am sagu silogabaenako. ");
INSERT INTO tteo_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Ugabaegauko yalobi salai gunna mena, gula malamalawesosina yo boniboniyaina koina. ");
INSERT INTO tteo_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Am munamunai polopolowena kupei pwatagu mena, besiele bagolu igolu pwatagu mena siunuiyau. ");
INSERT INTO tteo_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Kowa am paisowa koina mwa kaukavao silogabaegau, uginauli koliyau besiele boita bwalaina koliyau imiyamiya kabo simiya-suwala koliyau. Yalaomako naenaena polowena kalona mena nige sowasowana yayabubu-gabaen, ");
INSERT INTO tteo_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","yo mangu ibelu kamkamna kaiwena. O Yeoba, kaliyate kaigeda kaigeda yayogayoga koliwo yo nimagu yakeleisinagili koliwo kawakawanoi mena. ");
INSERT INTO tteo_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Gubesi, yakato ginauli kaba nuwapwanopwano kupaisowaili toboita kaiweli? Na sitoloyoi sitobali koliwo? Nigele. ");
INSERT INTO tteo_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Gubesi, yakato am mulolo miyamiya yaina kaiwena siedeededeyan salai mena? Na am walo yawasosi siwalowalo-masalan sibayanae yanuwana koina? Nigele. ");
INSERT INTO tteo_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Gubesi, yakato am paisowa ginauli kaba nuwapwanopwano sigitaili boniboniyai dedeina koina? Na am namwanamwa sigitai nuwanuwa-mwatain yanuwana koina? Nigele, nigele molosi. ");
INSERT INTO tteo_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","O Yeoba, yayoga koliwo sagu kaiwena, malala kaigeda kaigeda yakawanoi koliwo. ");
INSERT INTO tteo_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Tawae kaiwena kusikotanagau? Tawae kaiwena kumiya dagedagela-yagau? ");
INSERT INTO tteo_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Yagu sauga kilakai koina, yakamkamna kikiunamo yaboita, am loina polopolowena koina kamnagu inae. ");
INSERT INTO tteo_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Am munamunai kaikaiwena ikeno-kalatagau yo am kaleya isibayanaeyau. ");
INSERT INTO tteo_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Kaliyate meuloina koina sitakitakiki-lagau besiele yalubwasi idoga na ididi-takikilagau. ");
INSERT INTO tteo_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Am paisowa kaiwena, yagu eliyamwao namwanamwali silogabaegauko kabo boniboniyaimo mekaukava. ");
INSERT INTO tteo_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Itani ilele O Yeoba, kani yawali am mulolo miyamiya yaina kaiwena, yo sauga meuloina am walo yawasosi kani yawalo-masalan. ");
INSERT INTO tteo_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Kaiwena am mulolo kani imiyayai yo am walo yawasosi kani itolo-kaiwe besiele bulibuli ana tolo-kaiwe. ");
INSERT INTO tteo_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Kuwaloba, “Yagu kelabilabin kamwasana yaginauli yagu tomo gitegite-sipwaina koina, yagu kawalulu koina, yawaloyameli yagu topaisowa Deibida koina. ");
INSERT INTO tteo_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","Tubumwao siya kani siyamiyalaewo sauga meuloina yo am kaba miya wasawasana kani yakabi-yakaiwe.” ");
INSERT INTO tteo_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","O Yeoba, bulibuli siwaliwali am paisowa namwanamwali kaiweli, yo bulibuli kana tomiya siwaliwali am walo yawasosi kaiwena. ");
INSERT INTO tteo_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Nige yabo imiyamiya bulibuli mena besiele kowa, nige yabo itotoyatoyawa mekamkava. ");
INSERT INTO tteo_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Toyakayakasisi meuloili simatausagiwo yo ali miyagogo koina kusaesosi kabo me ali yakasisi sitolo-takikilagiwo. ");
INSERT INTO tteo_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","O Yeoba kowa Tomiyasaesosi, nige yabo ana kaiwe besiele am kaiwe, am paisowa meuloina ikalapowon am walo yawasosi koina. ");
INSERT INTO tteo_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Kalita ana yokoyoko kowa kuloiloinayan, ana bagolu munamunaili kuyadaumwalili. ");
INSERT INTO tteo_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Weso lalakina esana Labi ukogaogaoli na iboita, yo kam tokaleyayao am kaiwe mena kutao-gwaligwalili. ");
INSERT INTO tteo_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Bulib