﻿USE sofia;
DROP TABLE IF EXISTS sofia.tte_vpl;
CREATE TABLE tte_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tte_vpl WRITE;
INSERT INTO tte_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yeisu Keliso ana laoma bwaite besiele, Yeisu Keliso iya Deibida tubuna, Deibida iya Abelamo tubuna. ");
INSERT INTO tte_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abelamo natuna Aisake, Aisake natuna iya Yakobo, Yakobo natunao Yuda yo kanakavao, ");
INSERT INTO tte_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda natunao Pelesi yo Sela, (sinali esana Tama), Pelesi natuna Esiloni, Esiloni natuna Lama, ");
INSERT INTO tte_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lama natuna Aminadaba, Aminadaba natuna Nason, Nason natuna Salimoni, ");
INSERT INTO tte_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni natuna Bowasa, (Bowasa sinana iya Leyabi), Bowasa natuna Obedi, (Obedi sinana iya Ludi), Obedi natuna Diyesi, ");
INSERT INTO tte_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Diyesi natuna Kin Deibida. Deibida natuna Solomoni. (Solomoni sinana esana Batisiba iya beyabeyana Ulaiya wainena) ");
INSERT INTO tte_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoni natuna Liyabom, Liyabom natuna Abaidiya, Abaidiya natuna Asa, ");
INSERT INTO tte_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa natuna Yeosipati, Yeosipati natuna Yolama, Yolama natuna Usaiya, ");
INSERT INTO tte_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaiya natuna Yotami, Yotami natuna Easi, Easi natuna Esekaiya, ");
INSERT INTO tte_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekaiya natuna Manase, Manase natuna Eimon, Eimon natuna Yosaiya, ");
INSERT INTO tte_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosaiya natunao Yekonaiya yo kanakavao, saugana Babiloni silaoma sikaleya Yudiya kolili kabo sikalaili silawagili Babiloni koina. ");
INSERT INTO tte_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Saugana Yudiya siyaele Babiloni kabo bwaine koina Yekonaiya ikabi natuna Salatieli, Salatieli natuna Selubabela, ");
INSERT INTO tte_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selubabela natuna Abiuda, Abiuda natuna Elaiyakim, Elaiyakim natuna Esoli, ");
INSERT INTO tte_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Esoli natuna Seidoki, Seidoki natuna Ekimi, Ekimi natuna Eliuda, ");
INSERT INTO tte_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliuda natuna Eliesa, Eliesa natuna Matan, Matan natuna Yakobo, ");
INSERT INTO tte_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","yo Yakobo natuna Yosepa, Meli wainena. Meli ikabi Yeisu, iya esana siyogayan Mesaiya. ");
INSERT INTO tte_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Na kabo Abelamo koina yo ilaoma Deibida koina yaso kali baibaiwa potin (14), tabe Deibida koina ilaoma saugana Yudiya silawagili Babiloni yaso kali baibaiwa potin (14), yo sauganane koina kanasiga Mesaiya Yeisu iyawatagili yaso kali baibaiwa tabe potin (14). ");
INSERT INTO tte_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yeisu Keliso sinana Meli. Mwa bwaite besiele Yeisu ana kabi ana laoma. Meli ikawakawaluluwan Yosepa sabi kasolananna. Na muli mena kabo sikasole, ilotonan iya isiumako Yaluyaluwa Tabuna ana kaiwe mena. ");
INSERT INTO tte_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Meli wainena Yosepa iya tomo namwanamwana. Nige nuwanuwana Meli imwalimwaline tomo manli mena, mwa inuwatui yakato tem ali kawakawalulune isokegabaen wadam mena. ");
INSERT INTO tte_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yosepa iyaelemo bwaite kaiwena inuwanuwatu na Guyau ana anelose ilaoma koina kenona mena. Anelosene iba, “Yosepa, Deibida ana susu, tabu kumamatausi na Meli ukwalai wainem. Melumelune ilaomaya Yaluyaluwa Tabuna koina. ");
INSERT INTO tte_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kani ikabi natuna tau yo esana kupei Yeisu, kaiwena kani ana tomoyao ileboili ali pwanoli kolili.” ");
INSERT INTO tte_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Meuloina bwaite iyawatagili na imayale tawae kana katai baguna Yaubada ana palopita iwalowen, ");
INSERT INTO tte_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","‘Tonuwanuwabola kani isiuma. Yo natuna ikabi tauna, yo esana sipei Imanuwela.’ Imanuwela kana bui ‘Yaubada mekalakava’. ");
INSERT INTO tte_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Saugana Yosepa itolo iginauli besiele Yaubada ana anelose ana walo koina. Yosepa Meli ikasolanan, ");
INSERT INTO tte_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","na iyamo nige Meli kwapina ikakabitonani kanasiga Meli ikabi melumelune. Yo Yosepa esana ipei Yeisu. ");
INSERT INTO tte_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Kabo Yeisu sikabiya Bedeliema koina, Yudiya dedeina mena, Elodi ana sauga kin koina. Saugana Yeisu sikabi tosonoga tupwali silaomaya tete bomatu mena silaoma Yelusalema. ");
INSERT INTO tte_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Yo sineli, “Toweya koina melumelune sikabiya yakato iya Yudiya ali kin? Kagitai ana utu tete bomatu mena mwa kalaoma sabi pwalou koina.” ");
INSERT INTO tte_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Saugana Kin Elodi walone ibenalan yakato Yudiya ali kin waluwaluna kaiwena ikatewakaka. Yo tomo meuloili Yelusalema koina tabe besiele sikatewakaka. ");
INSERT INTO tte_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kabo Elodi miyagogo iyogayan meuloili siya topwaoli lalakili yo loina kana toyakayakataiwo na ineliyagili toweya koina Mesaiya sikabiya. ");
INSERT INTO tte_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yo siwaloba, “Bedeliema koina Yudiya dedeina mena, bwaite kaiwena palopita ilele Buki Tabu mena, ");
INSERT INTO tte_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Komiu Bedeliema, Yudiya dedeina mena, nige sowana tawalo esamiu nige ilalalaki Yudiya kana tobagunao luwali mena, kaiwena tobaguna yabo kani iyawatagili luwamiu mena kabo yagu tomoyao Isileli kani ileboili.’” ");
INSERT INTO tte_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yo Elodi miyagogo yabo wadam mena iginauli tosonogaone mekanakavao tolaomane tete bomatu mena. Ineli kolili toisabo sauga koina utune sigitai. ");
INSERT INTO tte_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kabo Elodi tosonogaone iyawasali silau Bedeliema iba, “Kwalau melumelune kwaloya-namwanamwai. Tem kwalobai, kwalaoma kwawalo koliyau na yau tabe yalau yapwalou koina besiele.” ");
INSERT INTO tte_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tosonogao kin ana walo sibenalan yo silau. Utune kaigedana bwaine tauna kona tete bomatu mena ibagunayagili sigitai yoi yo simuliya kanasiga ilopei yanuwane pwatana mena melumeluwa koina. ");
INSERT INTO tte_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Saugana tosonoga utune sigitai yaliyaya lalakina iloyapowonli. ");
INSERT INTO tte_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Silau numene koina yo sigitai melumelu mesinana Meli. Sipwalou me ali yakasisi melumelune koina. Ali mulolo sisokeli yo siwolena wasawasane gole, olibanuma yo mula. ");
INSERT INTO tte_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na Yaubada tosonogaone iyakenayagili kenoli mena tabu sipipileyoi Elodi koina. Mwa sipileyoi ali dedei mena kamwasa uloina mena. ");
INSERT INTO tte_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tosonoga silogabaegili kabo muli mena Yosepa kenona ikenoi kabo Yaubada ana anelose iyawatagili Yosepa koina yo iba, “Elodi kani melumelu iloyai nuwanuwana iunuyamate. Kutolo, melumelu mesinana ukwalaili yo kwayabubu kwalau Itipita. Bwaine koina kwamiyamiya kanasiga yawalo kabo kwapileyoima.” ");
INSERT INTO tte_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mwa Yosepa itolo, melumelu mesinana ikalaili kabo boniyai mena silau Itipita, ");
INSERT INTO tte_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","kabo simiyamiya bwaine koina kanasiga Elodi iboita. Bwaine besiele iyawatagili na mesabana Yaubada ana walo iyamala yawasosi. Walone palopita yabo iwalo-masalan beyabeyana, iba, “Natugu kani yayawasa na yakato naga muli mena yayoga-yawatagilan Itipita koina.” ");
INSERT INTO tte_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Saugana Elodi ikatai yakato tosonogaone simwakotayan mwa imunamunai lalakina. Kabo ana tokaleyayao iyawasali na melumelu tataoliyao Bedeliema dedeina meuloina koina siya ali bolime labui yaulina mena siunuyamateli. Iwalo besiele kaiwena tosonogao siwalo koina toisabo sauga utune sigitebagunayan. ");
INSERT INTO tte_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Iyawatagili besiele kabo Yelemaiya ana walo iyamala yawasosi, kaiwena beyabeyana iba, ");
INSERT INTO tte_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Kaina yabo sibenalan Lama koina, valam yo koyasili lalakina, Litieli ivalavalam natunao kaiweli yo genuwana sikabi-yanuwadaumwali kaiwena natunao meuloili siboitako.” ");
INSERT INTO tte_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kabo muli mena Elodi iboita, kabo Itipita koina Yaubada ana anelose iyawatagili Yosepa kenona mena, ");
INSERT INTO tte_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","yo iba, “Kutolo, melumelu mesinana ukwalaili yo kwapileyoi yanuwa Isileli, kaiwena Elodi me ana bodao, siya beyabeyana nuwanuwali Yeisu siunuyamate, siboitako.” ");
INSERT INTO tte_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kabo Yosepa itolo, yo melumelu mesinana ikalaili yo sipileyoi yanuwa Isileli. ");
INSERT INTO tte_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Saugana ibenalan Akeleyasi iyamala kin dedei Yudiya koina, tamana Elodi ana kaba miya iyamiyalae, kabo Yosepa genuwana ilau dedeinane koina kaiwena imatausi. Tabe kenona ikeno yoi Yaubada ana wasa iwolena tabu ilalau dedei Yudiya na ilau Galili ana dedei mena. ");
INSERT INTO tte_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ilau yo imiyamiya yanuwa Nasaleta, Galili dedeina mena. Bwaine besiele iyawatagili na mesabana palopitao ali walo Mesaiya kaiwena iyamala yawasosi. Kaiwena beyabeyana siwaloko siwaloba, “Tomo meuloili naga kani siwalo yakato iya Game Nasaleta.” ");
INSERT INTO tte_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","Saugana Yeisu iyaele Nasaleta na Yoni Toyababitaiso ilaoma yo iguguye dedei Yudiya ule bwagabwaga mena iba, “Mumugamiu naenaeli kolili kwanuwabui, kaiwena Yaubada ana kaba loina kana sauga ikubwamako.” ");
INSERT INTO tte_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Beyabeyana palopita Aiseya ilele Yoni Toyababitaiso kaiwena sauganane iwaloba, “Tomo yabo iyogayoga ule bwagabwaga mena, iba, ‘Guyau ana kamwasa kwasepa, wakatububun yo kwayasapusapu.’” ");
INSERT INTO tte_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Na Yoni kana kwama ebaebai kameli wiyana yo kana wakisowa bulumakau kwapina. Yo ana kaba kekan mwalimwali yo kamwakamwa. ");
INSERT INTO tte_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tomo meuloili silaoma koina. Tupwaliyao silaomaya Yelusalema taon, tupwaliyao silaomaya Yudiya dedeina mena yo tabe tupwaliyao silaomaya yanuwa siya Waila Yolidan salina mena. ");
INSERT INTO tte_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ali pwanoli siwalo-masalagili kabo iyababitaisoli Waila Yolidan koina. ");
INSERT INTO tte_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tabe Palisiyao yo Sadusiyao sibaibaiwa silaoma yakato sibabitaiso. Na Yoni igitaili kabo iyokoi-yagili iba, “Komiu besiele weso. Gubesi, yaiya ami wasa iyeyawa mwa nuwanuwamiu Yaubada ana munamunai kwayabubu-gabaen? ");
INSERT INTO tte_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ilonamwayagimiu tem mumugamiu naenaeli kwasikotanagili na uwe namwanamwana iyawatagili yawasimiu koina. ");
INSERT INTO tte_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Tabu kwanunu-watui yakato kwaba, ‘Kai tubumai Abelamo, mwa koina kai Yaubada ana tomoyao gitegite-sipwaimai.’ Na yawalo kolimiu, bwaite mwakota kaiwena Yaubada iya sowasowana veku ikalaili yo kolili Abelamo tubunao iyamayaleli. ");
INSERT INTO tte_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yaubada ana kilam ivakiliyako yakato mayau meuloili siya nige siuweuwe namwanamwa yaili mena ikoili siguli na igabae-luseyagili mayau wedowedolina koina. ");
INSERT INTO tte_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Tem kwanuwabui mumugamiu naenaeli kolili kabo yayababitaisomiu waila mena. Na iya ilalaoma kani iyababitaisomiu Yaluyaluwa Tabuna koina yo ikabiyakaiwemiu besiele mayau wedowedolina ana kaiwe. Iya esana ilalaki na yau esagu nige ilalalaki. Yau nige yagu namwanamwa ipapagan yakato sowasowagu kaena kana suma yakalaili. ");
INSERT INTO tte_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ana sabolo iyaele nimana mena naga iyatubu ana witi kanna yo mosomosona iyakasali kabo tem kanna yawasosi ikelegogon ipei ana lakawa mena yo mosomosona igabu mayau wedowedolina koina, mayaune nige ana kaba boitamo.” ");
INSERT INTO tte_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kabo Yeisu Galili dedeina ilogabaen isaema Waila Yolidan koina yo iwalolau Yoni koina iba, “Kuya-babitaisoyau.” ");
INSERT INTO tte_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Na Yoni nuwa-nuwana Yeisu ana nuwatu ibui, mwa iba, “Inamwanamwamo temga kowa kuyababitaisoyau. Gubesi mwa kulaoma koliyau yakato yayababitaisowo?” ");
INSERT INTO tte_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mwa Yeisu kainana iyamaisa iba, “Yau yagu nuwatu inamwanamwa tem saugamo bwaite taginauli besiele, kaiwena Yaubada ana nuwatu tamuliya.” Kabo Yoni italam. ");
INSERT INTO tte_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yeisu ibabitaiso kabo igayosaema waila mena. Sauganane koina bulibuli itasoke yo Yaubada Yaluyaluwana igitai besiele bunetutu ilolobima koina. ");
INSERT INTO tte_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kabo kaina yabo ilobimaya bulibuli mena iba, “Bwaite natugu yamulolo lalakina koina yo yayaliyaya yawasosi kaiwena.” ");
INSERT INTO tte_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kabo Yaluyaluwa Tabuna Yeisu ilawan ule bwagabwaga mena na Seitani Yeisu itonan. ");
INSERT INTO tte_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kaliyate poti yo boniyai poti Yeisu ikalakisiye nige ikekekan kaiwena mwa iguliyam lalakina. ");
INSERT INTO tte_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kabo Seitani ilaoma yo itonan iba, “Tem yawasosi kowa Yaubada Natuna kuwalo veku kolili na siyamala beledi.” ");
INSERT INTO tte_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yeisu kainana iyamaisa iba, “Buki Tabu ana walo bwaite besiele, ‘Tomo nige sowasowali beledimo sikan na yawasili silobai, bwaimwanamo Yaubada ana walo meuloina koina yawasili silobai.’” ");
INSERT INTO tte_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tabe Seitani Yeisu ilawan yoi Yelusalema yo iseyan Nume Tabu kewa yawasosina mena. ");
INSERT INTO tte_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Iwalo koina, “Tem yawasosi kowa Yaubada Natuna, ukwapusele-lobi, kaiwena Buki Tabu iba, ‘Yaubada kani iwalo aneloseyao kolili sigitekalatagiwo nimali mena sinapuiwo kisi kutalu veku mena na kaem kusibayanae.’” ");
INSERT INTO tte_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yeisu kainana iyamaisa iba, “Buki Tabu ana walo bwaite besiele, ‘Tabu Yeoba am Yaubada kutonatonan.’” ");
INSERT INTO tte_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Seitani ikalai yoi ilawan koya kikinna mena yo kaba loina meuloina yanuwa yaulina mena yo ali wasawasa meuloina iyakenayan. ");
INSERT INTO tte_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Koina iwalolau iba, “Tem tutulim kutalu-sakonayan na kupwalou koliyau, bwaine ginauline meuloina kani yaeliwa koliwo.” ");
INSERT INTO tte_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yeisu kainana iyamaisa iba, “Seitani, kulowasi koliyau. Buki Tabu ana walo bwaite besiele, ‘Kupwalou Yeoba am Yaubada koina yo iya ibomamo koina kupaisowa.’” ");
INSERT INTO tte_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kabo Seitani Yeisu ilogabaen yo aneloseyao silaoma Yeisu sisagui. ");
INSERT INTO tte_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Saugana Yeisu ibenalan Yoni sipeiyako deli mena kabo ipileyoi ilau Galili. ");
INSERT INTO tte_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Sauga kubwakubwana imiyamiya Nasaleta, kabo ilau Kapeneomi, Kalita Galili papalina mena bwaimwa siya susu Sebuloni yo susu Napitalai ali dedei mena. ");
INSERT INTO tte_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iyawatagili bwaite besiele na mesabana palopita Aiseya ana walo iyamala yawasosi. ");
INSERT INTO tte_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Kaiwena beyabeyana iba, “Susu Sebuloni yo susu Napitalai ali dedei koina, dedei bwaine Kalita kana kamwasa imiyamiya koina, bwaine Yolidan salina mena dedei pwatana mena, yo Galili koina siya nige Yudiya tomoliyao sibaibaiwa simiyamiya, ");
INSERT INTO tte_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","yo siya simiyamiya boniboniyai koina naga kani mayale lalakina sigitai, yo siya simiyamiya boita lolonna mena kani mayale imwalisae kolili.” ");
INSERT INTO tte_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sauganane koina Yeisu ana guguye iyatubu iba, “Mumugamiu naenaeli kolili kwanuwabui kaiwena Yaubada ana kaba loina kana sauga ikubwamako.” ");
INSERT INTO tte_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yeisu iyonayona Kalita Galili dekawana mena kabo togomana labui igitaili, yabo Saimoni iya esana Pita yo kanakava Anidulu. Ali yagida sigalagalayan kalita mena kaiwena bwaine ali paisowaele. ");
INSERT INTO tte_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iwalo kolili iba, “Kwamuliya koliyau na yakatububunagimiu komiu tomo kali toyakona.” ");
INSERT INTO tte_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kabo sauganane koina ali yagida silogabaen yo simuliya koina. ");
INSERT INTO tte_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Iutulau yoi kabo tomo labui yoi igitaili, Yemesa mekanakava Yoni, siya Sebedi natunao. Me tamali simiyamiya waga mena, ali yagida sikatukatububu sabi gala. Kabo Yeisu yoli labuine iyoganli. ");
INSERT INTO tte_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Sauganane koina ali waga yo tamali silogabaegili yo Yeisu simuliya. ");
INSERT INTO tte_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yeisu Galili dedeina meuloina ilotakikilan kabo iyakayakatai ali nume tapwalolo kolili, Yaubada ana kaba loina wasana namwanamwana iguguguguyeyan yo tomo ali kasiebwa uloi uloi iwoisili. ");
INSERT INTO tte_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yeisu wasana itakikili Siliya dedeina meuloina koina kabo tomo tokasiebwao meuloili sikalailima, kasiebwa uloi uloi, siya sikamkamna lalakina, siya yaluyaluwa biki kolili, yo siya sikikiwasi, yo tabe siya yoli sitawalololi, meuloili iwoisili. ");
INSERT INTO tte_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Boda lalakina Yeisu siyamuli-kusuli. Silaomaya dedei Galili, dedei Dekapoliya, Yelusalema taon, Yudiya dedeina yo tabe Waila Yolidan dedei pwatana mena. ");
INSERT INTO tte_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yeisu boda lalakina igitaili kabo ilau ikawasae koya mena yo imiyasio. Ana tobenaliyao silaoma simiya-takikilan, ");
INSERT INTO tte_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","kabo iyatubu iyakayakatai kolili yo bwaite besiele iba, ");
INSERT INTO tte_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Siya tonuwalobi sikatai yaluyaluwali sibubutuma, Yaubada iwalo-muloloili yo Yaubada ana kaba loina kani silobai. ");
INSERT INTO tte_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Siya ali toboita kana katekamkamna yo kana nuwanae kateli mena Yaubada iwalo-muloloili yo kani ikabi-yanuwadaumwalili. ");
INSERT INTO tte_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Siya tonuwalobi yo mumugali bigana, Yaubada iwalo-muloloili. Ana waloyameli yanuwana kani silobai. ");
INSERT INTO tte_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Siya nuwanuwasosili tem mumugana namwanamwana sikalai kateli mena, besiele toguliyam yo togalomagu nuwanuwali kan yo waila, Yaubada iwalo-muloloili. Kani mumugana namwanamwana koina yaluyaluwali iloyapowonli. ");
INSERT INTO tte_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Siya kalikavao sikatekamkamna-yagili yo ali naenaena kolili sinuwatu-pwaikili Yaubada iwalo-muloloili. Kani ikatekamkamna-yagili yo inuwatu-pwaikili. ");
INSERT INTO tte_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Siya kateliyao nige sibibiki Yaubada iwalo-muloloili. Kani Yaubada sigitai. ");
INSERT INTO tte_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Siya tokabi-yanuwa-daumwali Yaubada iwalo-muloloili. Kani ikawa-natu-wagili. ");
INSERT INTO tte_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Siya kalomagigili koina kamkamna lalakina silobai mumugana namwanamwana kaiwena Yaubada iwalo-muloloili. Yaubada ana kaba loina kani silobai. ");
INSERT INTO tte_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Tem tomo sisinalimiu yo sikawa-naenae-yagimiu yo siyakamkamnamiu esagu kaiwena Yaubada kani iwalo-muloloimiu. ");
INSERT INTO tte_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kwayaliyaya lalakina kaiwena maisamiu lalakina iyaele bulibuli mena kaiwena palopitao bagubagunali siyakamkamnali besiele komiu. ");
INSERT INTO tte_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Komiu ami paisowa yanuwa yaulina mena besiele kalita ana paisowa. Tem ana kaiwe yo kamnana imwawasi nige sowasowana taula-kalikalita yoi. Takatai nige ana paisowa ipapagan kabo tagabaen yo tomo siutu-gwalagwalai. Kabo wagite-kalatagimiu tabu komiu besiele kalita naenaena, sauga meuloina kwatolo kaiwe me ami meli Yaubada koina. ");
INSERT INTO tte_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Komiu besiele mayale yanuwa yaulina mena. Tem yanuwa yabo imiyamiya koya pwatana mena kani tomo meuloili sigitai, nige sowana ikeno-wadam. ");
INSERT INTO tte_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nige sauga yabo tomo mayale sigabu kabo gulewa sikalai yo mayalene sikopwaiki. Kani sipei teibeli pwatana mena kabo mayalena mena nume kana tomiya meuloili simayale. ");
INSERT INTO tte_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Besiele tabe komiu, ilonamwayagimiu tem ami mayalene, bwaimwana mumugamiu namwanamwana, iwedowedoli tomo manli mena na mesabana ami paisowa namwanamwana sigitai na Tamamiu bulibuli mena esana sitobalan.” ");
INSERT INTO tte_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Tabu kwanunuwatui yakato yalaoma na Mosese ana loina yo palopitao ali yakayakatai yakele-gabaegili. Nigele. Yalaoma yakato ginauli meuloina beyabeyana siwalowegiliko siyamala yawasosi. ");
INSERT INTO tte_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yawalo yawasosi kolimiu, kanasiga bulibuli yo yanuwa yaulina naga kani simwawasi nige sowasowana loina ana walo yabo kikiuna ikwalalele kanasiga loinane meuloina Mosese ilelelene iyamala yawasosi. ");
INSERT INTO tte_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yaiya tem loina kikiuna yabo ilikwai yo tomo tupwaliyao iyakenayagili siginauli besiele, tomone esana Yaubada kani ipeiyatalu ana kaba loina koina. Na yaiya loina meuloina ibenalagili yo tomo iyakataili besiele, kabo esana Yaubada kani ikeleisinan ana kaba loina koina. ");
INSERT INTO tte_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Na yawalo kolimiu tem ami obiga nige Palisi yo loina kana toyakayakatai ali obiga inanamwanamwa-gabaen nige sowasowana kwalusae Yaubada ana kaba loina koina. ");
INSERT INTO tte_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Wakataiyako, tomo bagubagunali ali sauga mena siyakayakatai besiele bwaite, ‘Tabu tomo taunuyamate, yaiya tem tomo iunuyamate kani maisana ilobai.’ ");
INSERT INTO tte_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Na yau yawalo kolimiu, yaiya imunamunai kanakava koina kani maisana ilobai. Yaiya kanakava ikawa-naenae-yani kani Yudiya toloinao siyatalayan, na yau yawalo kolimiu, yaiya iwaloba, ‘Kulukulum gaibuna’ iya ilalau kaba silae koina yo iyaele mayau wedowedolina salina mena. ");
INSERT INTO tte_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Kabo tem kulaoma nume tapwalolo koina nuwanuwam am mulolo kuwolena Yaubada koina, bwaine koina kunuwatu-kalatan yakato kamkava imunamunai koliwo ginauli yabo kaiwena, am mulolo kupei kaba pwaoli salina mena yo kulau naga mekamkava kwalolabin yo wakawa-elieliyam yoi, muli mena kabo kupileyoima na am mulolo kuwolena Yaubada koina. ");
INSERT INTO tte_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Tem tomo yabo iyakewaiwo yo nuwanuwana iyatalayagiwo, mwayamwayau kutonan kaiwe na mekamkava kwayadudulai. Tem nige sowasowana, kutonan yoi kamwasa mena na tem kuyadudulai na mesabana tabu ilalawagiwo kaba yatala koina kisi bwaine koina sipeiwo toyatala koina kabo toyatala ipeiwo pilisiman nimali mena na sipei-luseyagiwo deli mena. ");
INSERT INTO tte_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yawalo yawasosi koliwo, tem sipei-luseyagiwo deli mena, nige sowana kuyawatagili kanasiga kam yaga meuloina kuyamaisaoli. ");
INSERT INTO tte_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Na kwabenalan Mosese ana loina bwaite, ‘Tabu kamkava wainena uganaganawali koina.’ ");
INSERT INTO tte_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Na yau yawalo kolimiu, yaiya tem sine yabo imankulakulai nuwanuwana sikeno iya katena mena iganawaliko sauganane koina. ");
INSERT INTO tte_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Tem manim ulaulam iyalopwanowo ukasigabaen. Inamwanamwa tem yom yabo isibayanaewo kutomgabaen, tabu yom meuloina ugagabaen mayau wedowedolina koina. ");
INSERT INTO tte_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Besiele tabe tem nima ulaulam iyalopwanowo kutomgabaen. Inamwanamwa tem yom yabo isibayanaewo kutomgabaen, tabu yom meuloina ugagabaen mayau wedowedolina koina. ");
INSERT INTO tte_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Mosese ana loina iwalo besiele bwaite, ‘Yaiya tem nuwanuwana wainena iinawaseyan, baguna inawase letana ileleyatalu kabo iwolena sinene koina yakato iinawaseyanako.’ ");
INSERT INTO tte_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Na yau yawalo kolimiu, tem tomo wainena iganawali sowasowana wainena iinawaseyan. Na tem nige igaganawali nige sowana iinawaseyan kaiwena tem wainena isikotanan kani wainenane ikasole-panaisi, na taune ana pwanoli kaiwena wainena iyadidiga ilau yo saugana sinene ikasole-panaisi iya iyamala sine ganaganawalina. Besiele tabe tem tau yabo sinene ikasolanan ee iya tabe tau ganaganawalina. ");
INSERT INTO tte_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Na kwabenalan yoi Mosese ana loina tomo bagubagunali kolili besiele bwaite, ‘Tabu am kawalulu Yaubada manna mena kusosokeli, na uginaulili.’ ");
INSERT INTO tte_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Na yau yawalo kolimiu, tabu sauga yabo ukakawalulu-sae bulibuli mena, tabu kuba, ‘Kagu lulu bulibuli kaiwena Yaubada ana kaba miya bwaine koina.’ ");
INSERT INTO tte_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Tabu kuba, ‘Kagu lulu yanuwa yaulina kaiwena kaena kaba peina bwaite.’ Tabu kuba, ‘Kagu lulu Yelusalema kaiwena kin lalakina ana yanuwa iya.’ ");
INSERT INTO tte_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tabu ukakawalulu kulukulum koina kaiwena nige sowasowana kuboma itom yabo kulukulum mena kana koleya kubui nuwana imayale o iduba. ");
INSERT INTO tte_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Na iyamo tem ginauli yabo walo yawasosi kuba, ‘O.’ Na tem nigele kuba, ‘Nigele.’ Tabu am walo kueetulan kaiwena walo-etulan ilaomaya Seitani koina. ");
INSERT INTO tte_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Kwabenalanako Mosese ana loina bwaite, ‘Tem tomo yabo kanakava manna kaigeda isibayanae maisana iya tabe manna kaigeda isibayanae. Tem kanakava mwakana kaigeda ikoyabeku, maisana tabe mwakana kaigeda ikoyabeku.’ ");
INSERT INTO tte_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Na yau yawalo kolimiu, tem tomo yabo iginauli naenaena koliwo, tabu kuyayamaisa. Tem tomo yabo papalim ulaulam mena ikoi, kabo kutagelakeile papalim gegebam kuwolena iunui yoi. ");
INSERT INTO tte_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Besiele tabe tem tomo yabo ipeiwo yatala mena yo yakato kam kwama ikalai, ee kuwolena yo tabe kam kabobo kuwolena besiele. ");
INSERT INTO tte_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tem tomo yabo iyadidigao na ana gogo ukele-sagui kwalau yanuwa yabo koina ilonamwayagiwo kutalamwagiwo tabe ukele-sagui yoi kwalau yanuwa yaboyoi koina. ");
INSERT INTO tte_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tem tomo yabo ginauli yabo ikawanoiyan koliwo kuwolena koina. Tabe tem tomo yabo am gogo yabo ikawanoiyan yakato naga iyapileyoi koliwo tabu kununuwai. ");
INSERT INTO tte_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Na kwabenalan yakato tomo bagubagunali siba, ‘Ami eliyamwao kwamulolo kolili, na kami tokalomagigiliwo wakalomagigi-lagili.’ ");
INSERT INTO tte_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","45","Na yau yawalo kolimiu, kami tokalomagigiliwo kwamulolo kolili yo siya siyakamkamnamiu wakawanoi kaiweli, na mesabana komiu Tamamiu bulibuli mena natunao. Kaiwena iwalo dabwelo imwalisae yo imayale tomo naenaeli yo tomo namwanamwali kolili, yo tabe galewa iyawasa siya mumugali dudulaina yo siya mumugali naenaeli kolili. Yaubada ana mulolo meuloila takele-toyawai. ");
INSERT INTO tte_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Na tem kamikavaomo kwamulolo kolili nige sowasowana maisamiu Yaubada koina kwalobai, kaiwena tonaenaeli besiele takesi kali totano ali mulolo besiele komiu ami mulolo kamikavaomo, sibomamo simulolo kolili. ");
INSERT INTO tte_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yo tem kamikavaomo wakawatoki kolili, gubesi ana namwanamwa? Nuwana nigele, kaiwena siya nige tomeli siginauli besiele bwaite. Ilonamwayagimiu tem kami tokalomagigiliwo wakawatoki kolili tabe kaiwena komiu Yaubada ana tomoyao. ");
INSERT INTO tte_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Wagite-kalatagimiu yakato tem sauga meuloina komiu mumugamiu meuloina inamwanamwa besiele Tamamiu bulibuli mena mumugana inamwanamwasosi. ");
INSERT INTO tte_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Saugana tem ginauli namwanamwana yabo waginauli, tabu wagiginauli tomo manli mena yakato ginauline namwanamwana sigitai. Tem waginauli besiele yakato tomo sitobalanagimiu Tamamiu bulibuli mena kani nige iyayamaisamiu. ");
INSERT INTO tte_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kabo saugana tem gogo yabo kwaolena tobubutuma kolili, tabu kwayogayoga, besiele tomwakomwakota mumugali siya siginauli besiele nume tapwalolo mena yo kamwasa mena kaiwena nuwanuwali tomo sitobalanagili. Na yawalo yawasosi kolimiu maisaline meuloina sikalaiyako kaiwena tomo sitobalanagiliko. ");
INSERT INTO tte_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Na tem gogo kuwolena tobubutuma kolili, tabu nimam gegebam ikakatai yakato nimam ulaulam gogo iyauyan. Tabu am eliyamwao namwanamwali am paisowa namwanamwana wasana sibebenalan. ");
INSERT INTO tte_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Uginauli wadam mena. Tamam ginauli meuloili wadamwadamli igitailiko, kabo iya kani maisam iyeyawa. ");
INSERT INTO tte_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Saugana tem wakawanoi tabu besiele tomo mwakomwakotali. Siya nuwanuwali sitotolo na sikawakawanoi nume tapwalolo yo kamwasa kolili, na mesabana tomo meuloili sigitaili. Na yawalo yawasosi kolimiu maisali meuloina sikalaiyako. ");
INSERT INTO tte_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Saugana tem ukawanoi, kulusae am biliutusi mena, gamwa ukwausi kabo ukawanoi Tamam koina, iya nige tagigitai. Tamam ginauli meuloili wadamwadamli igitagitaili, kabo iya kani maisam iyeyawa. ");
INSERT INTO tte_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Saugana ukawanoi, tabu walo bwagabwaga koina ukakawanoi besiele siya nige tomeli. Siya sinuwanuwatu yakato Yaubada ali kawanoi ibenalagili kaiwena ali kawanoi simamalawe. ");
INSERT INTO tte_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tabu komiu besiele siya. Nige naga wakakawanoi koina na Tamamiu ikatai-bagunayanako tawae nuwanuwamiu. ");
INSERT INTO tte_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","13","Kabo wakawanoi besiele bwaite, Tamamai kowa bulibuli mena, esam siyakasisiyan, mumugam ilobima, nuwam siyai yanuwa yaulina mena besiele siyai bulibuli mena. Kabona kamai kaliyate bwaitete kuyelima. Ama kabikabi sinae kulabinimai besiele kai kalabinili siya sikabiyanae kolimai. Yo imiyawa kuyakenayagimai woya koina. Kuleboimai yauyaule koina. Kaiwena kuboma am ginauli baibaiwali yo kowa ukaiwesosi yo kowa tubula am mayalena yo kan nige ilolotom. O, besiele. ");
INSERT INTO tte_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Tem kamikavao ali naenaena kolimiu kwanuwatu-pwaikili, kabo Tamamiu bulibuli mena ami naenaena tabe inuwatu-pwaikili. ");
INSERT INTO tte_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tem kamikavao ali naenaena nige kwanunuwatu-pwaikili Tamamiu besiele ami naenaena kani nige inunuwatu-pwaikili. ");
INSERT INTO tte_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Saugana tem guliyam ikanmiu wakalakisiye kawanoi kaiwena, tabu manimiu kali koleya kwaula-yanayanaeli besiele tomwakomwakota siya manli kali koleya siula-yanayanaeli na mesabana tomo meuloili sigitaili yakato sitabu-wagili kekan koina. Na yau yawalo yawasosi kolimiu maisali meuloina sikalaiyako. ");
INSERT INTO tte_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Na saugana komiu tem guliyam ikanmiu wakalakisiye kawanoi kaiwena, manimiu kwadeulili yo itomiyao kwasuwalili, ");
INSERT INTO tte_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","na mesabana tomo tabu sikakatai yakato guliyam wakalakisiyeyan. Tamamiu iya nige tagigitai, iyamo ikatai. Ginauli meuloina wadam mena waginaginaulili ikatailiko, iya kabo maisamiu kani iyeyawa. ");
INSERT INTO tte_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Tabu gogo wasawasa wakekelegogon kaiwemiu yanuwa yaulina mena kaiwena yanuwa yaulina mena ala gogo wasawasa naga wesoweso nuwana kakolosi nuwana naya sisibayanaeli, yo tokewali silusae yo sikewalili. ");
INSERT INTO tte_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Na bulibuli kana gogo wasawasa wakalai kaiwemiu, kaiwena bulibuli mena wesoweso yo kakolosi yo naya nige sowasowana gogo wasawasane sisibayanaeli yo tokewali nige sowasowali silusae yo sikewalili. ");
INSERT INTO tte_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kaiwena toisabo dedei koina am gogo wasawasa imiyamiya kani yaluyaluwam yo katem simiyamiya koina yo sauga meuloina kunuwanuwatu kaiweli. ");
INSERT INTO tte_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Manla besiele yola kana mayale. Tem manim inamwanamwa, kani yom meuloina imayale. ");
INSERT INTO tte_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Na tem manim inae, kani yom meuloina iboniboniyai. Tem yaluyaluwam kana mayale iboita yo iboniboniyai, kani boniboniyainane ilalakisosi koliwo. ");
INSERT INTO tte_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nige sowasowana tomo kaigeda ipaisowa toloina labui kolili. Kani yabo imuloloi, iobigai yo iyakasisiyan, na yabo imunamunai-yani yo ikalomagigilan. Nige sowasowana yoli labuine kolili tapaisowa, Yaubada yo gogo wasawasa. ");
INSERT INTO tte_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Kabo yawalo kolimiu, tabu kwanuwanuwatusosi ami miyamiya kaiwena, tawae wakan yo tawae kwanuma, tabu kwanuwanuwatu yomiu kaiwena toisabo kaleko kwalikwa. Yawasila ginauli lalakina na kan yawasila kali sagumo. Yo tabe yola ginauli lalakina na kaleko yola kali sagumo. Walo yawasosi awa? ");
INSERT INTO tte_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kwanuwatu man kaiweli, siya sievaeva, siya nige sipepelipeli, nige sikekelikeli, nige ali lakawa, na iyamo Tamamiu bulibuli mena iya igitekalatagili. Komiu ginauli lalakina Yaubada manna mena yo man nige ginauli lalakina besiele komiu, awa? Sauga meuloina iya inuwanuwatuila lalakina. ");
INSERT INTO tte_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Gubesi, yaiya luwamiu mena sowasowana yawasina kana sauga ikabi-yamamalawe tem sauga meuloina inuwanuwatusosi me ana kate wakaka? Nigele, awa? Kabo yawalo kolimiu, tabu me ami nuwapolowe. ");
INSERT INTO tte_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Besiele tabe, tawae kaiwena kwanuwanuwatu kaleko kaiwena? Wagitai mula lalali siya, Yaubada ana yamayamayale, sikin bubu mena siya nige sipapaisowa, nige ali kaleko ipapagan. ");
INSERT INTO tte_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Na yau yawalo kolimiu, walo yawasosi Kin Solomon ana kaleko wasawasana inamwanamwasosi. Na iyamo mula lalaline kali koleya sinamwanamwasosi kabo muli mena Kin Solomon ana kaleko wasawasana kana koleya. ");
INSERT INTO tte_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kabo takatai Yaubada kawasi bubu mena kali gite namwanamwali iwolegiliko, kawasine kabona silala na bwaliga siweweka kabo sigabu mayau mena iwedoli, wa? Komiu kawasi lalali kwanamwanamwa-gabaegili. Tem Yaubada isaguili, walo yawasosi sowasowana isaguimiu na iyalikwamiu. Na tabu ami meli Yaubada koina ibebelu. ");
INSERT INTO tte_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kabo tabu kwanuwanuwatu kwaba, ‘Tawae kani kakan?’ o ‘Tawae kani kanuma?’ o ‘Tawae kani kalikwa?’ ");
INSERT INTO tte_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Siya nige simemeli ginauline bwaite besiele siloyaloyai. Tamamiu bulibuli mena ikataiyako ginauline bwaite kaba saguimiu. ");
INSERT INTO tte_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Na kwaloyai baguna Yaubada ana kaba loina yo mumuga dudulaina kabo ginauline bwaite meuloina kani ietulanli kolimiu. ");
INSERT INTO tte_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mwa koina tabu kwanuwanuwatu bwaliga kaiwena, kaiwena tawae iyawatagili bwaliga kolimiu iya iboma kana polowe ikalai yo iyadudulai. Kaliyate kaigeda kaigeda kana polowe imiyamiya, tabu polowene kwaeetulan yoi. ");
INSERT INTO tte_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Tabu kamikavao wakakawa-naenae-yagili kisi Yaubada ikawa-naenae-yagimiu. ");
INSERT INTO tte_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Yaubada ana kawanaenae kolimiu kani besiele ami kawanaenae kamikavao kolili. Tawae kwaolena kamikavao kolili iya kani iyeyawa kolimiu besiele. ");
INSERT INTO tte_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Tawae kaiwena mayau tasilina kumankulakulai kamkava manna koina na nige kunuwanuwatu mayau tuutuna lalakina manim mena? ");
INSERT INTO tte_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tem mayau tuutuna lalakina imiyamiya manim mena na gubesi mwa kuwalone kamkava koina, ‘Mayau tasilina ukwelegabaen manim mena’? ");
INSERT INTO tte_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kowa tomwakota, baguna mayau tuutunane ukwele-gabaen kuboma manim mena kabo manim imayale na sowasowana mayaune tasilinane ukele-gabaen kamkava manna mena. ");
INSERT INTO tte_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Tabu ginauli yakayakasisina yabo kuwowolena bwauwa ikakan, kani itagelakeile iletaiwo. Tabu ginauli yakayakasisina wagagabaen polo manna mena, kani idumuli-kalai yo isibayanae. ");
INSERT INTO tte_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Wakawanoi Yaubada koina kani iyeyawa, kwaloyai kani kwalobai, wakipisi kani gamwa isoke kolimiu. ");
INSERT INTO tte_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kaiwena yaiya ikawanoi kani ikalai, yaiya iloyai kani ilobai, yaiya ikipikipisi gamwa isoke koina. ");
INSERT INTO tte_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Tem yabo natuna ikawanoi kan kaiwena, gubesi, veku iwolena? Nigele. ");
INSERT INTO tte_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O tem ikawanoi iye kaiwena, weso iwolena? Nigele. ");
INSERT INTO tte_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tamala bulibuli mena ana olena inamwanamwasosi yo ilalakisosi tem siya sikawanoi koina kabo muli mena komiu tonaenaeli ami olena natumiyao kolili. ");
INSERT INTO tte_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Besiele tem tawae nuwanuwamiu tomo siginauli kolimiu, baguna waginauli besiele kolili. Walone bwaite Mosese ana loina yo palopitao ali yakayakatai ibwagili-gogon.” ");
INSERT INTO tte_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Gamwa kipakipana koina kwalusae. Tabu Seitani ana gamwa koina kwalulusae, kaiwena iwoyaila kaba silae koina. Walo yawasosi, kaba lusaenane imagaga yo kana lau imalamalae kabo tomo sibaibaiwa silaulau koina. ");
INSERT INTO tte_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Na yawasi kana gamwa ikipa yo kana lau ipolowe yo siya nige sibabaibaiwa silobai.” ");
INSERT INTO tte_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Wagite-kalatagimiu tabu toyakayakatai mwakomwakotali kainali kwabebenalan. Silalaoma kolimiu kali koleya besiele sipi manamanasamli, na yaluyaluwali mena mumugali besiele bwauwa sokasokali. ");
INSERT INTO tte_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tem ali paisowa uwena wagitai kabo wakataili. Oine kanna nige sowasowana takalai samasamali koina. Bosibosi kanna nige sowasowana takalai kedaba koina. ");
INSERT INTO tte_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Besiele tabe mayau namwanamwana kanna kamnana inamwanamwa, na mayau naenaena kanna kamnana inae. ");
INSERT INTO tte_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nige sowasowana mayau namwanamwana iuwe kanna naenaena, yo nige sowasowana mayau naenaena iuwe kanna namwanamwana. ");
INSERT INTO tte_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mayau meuloina siya kanliyao naenaeli sitomli yo sigabaegili mayau mena siwedoli. ");
INSERT INTO tte_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mwa koina toyakayakatai mwakomwakotali ali paisowa uwena wagitai kabo wakataili. ");
INSERT INTO tte_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nige yakato tomo meuloili siya siwalo koliyau, ‘Guyau, Guyau’ na silusae Yaubada ana kaba loina koina. Nigele. Yaiya Tamagu bulibuli mena ana nuwatu ipaisowai, iyamo ilusae. ");
INSERT INTO tte_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Saugana tem kaliyate mwawamwawasina iyawatagili, kani tomo sibaibaiwa siwalo koliyau siba, ‘Guyau, Guyau, esam mena Yaubada ana walo kawalo-masalan, esam mena yaluyaluwa biki katao-yawatagilagili yo tabe esam mena ginauli kaba nuwapwanopwano kapaisowaili.’ ");
INSERT INTO tte_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kabo kani yawalo kolili, ‘Nige yakakataimiu, kwalowasi, komiu tonaenaesosi.’” ");
INSERT INTO tte_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Tem yaiya yagu walone ibenalan yo ipaisowai besiele, iya tomonane ana nuwatu idudulai kaiwena iya besiele tosonosonoga yabo ana wauwau namwanamwana igitesipwai veku yo vekune pwatana mena ana nume ikabi. ");
INSERT INTO tte_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Saugana galewa italu lalakina, yalubwasi ididi yo yaumai kaikaiwena itowa numene iunui na nige iguguli kaiwena tuki ali kaba tolo sikaiwe. ");
INSERT INTO tte_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Na tem yaiya yagu walone ibenalan mowoi yo nige ipapaisowai besiele, iya tomonane ana nuwatu nige idududulai kaiwena iya besiele toyauyaule yabo ana wauwau naenaena igitesipwai dekawa yo dekawane koina ana nume ikabi. ");
INSERT INTO tte_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Saugana galewa italu lalakina, yalubwasi ididi yo yaumai kaikaiwena itowa yo numene iunui kabo iyui-yaguli yo itatagwaligwali kaiwena tuki ali kaba tolo sibelu.” ");
INSERT INTO tte_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Saugana Yeisu ana walo iyemwawasi tomo meuloili kateli sipitali yo nuwali iyai ana yakayakatai kaiwena, kaiwena iyakayakatai me ana kaiwe, nige besiele loina kana toyakayakatai ali yakayakatai. ");
INSERT INTO tte_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Saugana Yeisu koya mena isaluluma boda lalakina siyamuli-kusuli. ");
INSERT INTO tte_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tolepelo yabo ilaoma tutulina italu-sakonayan Yeisu manna mena kabo iba, “Guyau, tem am nuwatu besiele sowasowana ukwabi-namwanamwaiyau.” ");
INSERT INTO tte_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yeisu nimana iyagayan yo tomone ikabitonan kabo iba, “O, nuwanuwagu yom inamwanamwa.” Kabo sauganane koina ana lepelo imwawasi yo inamwanamwa. ");
INSERT INTO tte_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mwa Yeisu iwalo koina, “Tabu tomo yabo ana wasa kuwowolena. Kulau topwaoli koina yo yom kuyakenayan. Na kupwaoli Yaubada koina tawae besiele kala loina Mosese koina mesabana tomo sigitaiwo yakato kunamwanamwako.” ");
INSERT INTO tte_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Saugana Yeisu ilusae Kapeneomi, Loma ali tokaleya kana tobaguna yabo ilaoma Yeisu koina kabo ikawanoi sagu kaiwena. ");
INSERT INTO tte_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Iba, “Guyau, yagu topaisowa iyaele ikenokeno nume mena, yona itawalololi yo ikamkamna lalakina.” ");
INSERT INTO tte_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yeisu iba, “Talau na yakabi-namwanamwai.” ");
INSERT INTO tte_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tobagunane Yeisu kainana iyamaisa iba, “Imiyawa Guyau. Yau nige yagu namwanamwa ipapagan yakato kulaoma yagu nume mena. Na kuwalomo kabo yagu topaisowa inamwanamwa. ");
INSERT INTO tte_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Na yakatai sowasowana uginauli besiele kaiwena yau yamiyamiya yagu tautaubalao lalakili ali loina yaulina mena yo yagu tokaleya simiyamiya yauligu mena. Tem yawalo tokaleya yabo koina, ‘Kulau,’ kani ilau, yo tem yawaloyoi, ‘Kulaoma’ kani ilaoma. Yo tabe tem yawalo yagu topaisowa koina, ‘Bwaite uginauli’ kani ipaisowai besiele.” ");
INSERT INTO tte_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Saugana Yeisu walone bwaite ibenalan kabo katena ipitali yo iyaliyaya kaiwena tobagunane iya nige Yudiya yabo. Kabo Yeisu siya toyamuli-kusulina kolili iwalo iba, “Yawalo yawasosi kolimiu, nige tomo yabo yalolobai Isileli dedeina mena ana meli kana lalaki besiele bwaite. ");
INSERT INTO tte_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Na yawalo kolimiu, siya nige Yudiya kani sibaibaiwa silaoma dabwelo ana kaba tunsae mena yo ana kaba sugu mena silusae bulibuli yo mekalikavao Abelamo, Aisake yo Yakobo simiyasio yo sikekan toyawa. ");
INSERT INTO tte_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Na bwagana Isileli siya Yaubada ana waloyameli tomoliyao kani igabae-yawatagilagili boniboniyai luwana mena, na bwaine koina kani mwakali siyekalasi yo sivalavalam me ali kamkamna.” ");
INSERT INTO tte_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kabo Yeisu iwalo tokaleya kana tobaguna koina, “Kupileyoi. Am meli kaiwena kani yaginauli besiele.” Kabo sauganane koina ana topaisowa inamwanamwa. ");
INSERT INTO tte_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yeisu ilau Pita ana nume mena, yo bwaine koina igitai Pita wainena sinana ikenokeno, ikasiebwa yona iwedowedoli. ");
INSERT INTO tte_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yeisu nimana ilau kedulumane nimana ikabikalatan kabo wedowedoli imwawasi. Yo kedulumane itolo, yo iyatubu Yeisu igite-kalatan yo isagui. ");
INSERT INTO tte_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lolau molosi mena kabo siya yaluyaluwa biki silusae kolili, sibaibaiwa sikalailima Yeisu koina. Kabo iwalolau yaluyaluwa biki kolili iba, “Kwayawatagili”. Kabo sauganane koina yaluyaluwa biki siyawatagili. Yo tabe siya sikasiebwa iwoisili. ");
INSERT INTO tte_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ipaisowai besiele kabo palopita Aiseya ana walo Buki Tabu mena iyamala yawasosi iba, “Iya ala kasiebwa ikelegabaegili yo ala kamkamna ikalaili.” ");
INSERT INTO tte_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yeisu igitai boda lalakina simiya-takikilani kabo iwalo ana tobenaliyao kolili iba, “Talopanaisi dedei yabo mena.” ");
INSERT INTO tte_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Na sauganane koina loina kana toyakayakatai yabo ilaoma koina yo iba, “Toyakayakatai, toisabo dedei koina kulalau kani yamuliya koliwo.” ");
INSERT INTO tte_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yeisu nuwanuwana tomone ikatai yakato kana muliya ipolowe yo ikamkamna kabo iwalo koina iba, “Bwauwa ule kali gula simiyamiya, yo man siya sievaeva-keikeile kali noi simiyamiya na yau Tomo Natuna nige yagu kaba miya ipapagan na koina yakeno.” ");
INSERT INTO tte_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yo tabe tomo yabo, iya Yeisu ana tomuliya yabo iwalo koina iba, “Guyau, tamagu ana sauga imwawasi, tem baguna kutalamwagau na yalau yapei salai mena, kabo muli mena yapileyoima yamuliya koliwo.” ");
INSERT INTO tte_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Na Yeisu iba, “Nigele, kumuliya koliyau, siya toboita kani ali toboita sipeili salai mena.” ");
INSERT INTO tte_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yeisu me ana tobenaliyao simwalisae waga mena, kabo sikuke. ");
INSERT INTO tte_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Sauganane koina yaumai kaikaiwena itowa kalita iyokoyoko kabo bagolu sisuwesuwe-likwa waga kalona mena. Na Yeisu ikenokeno. ");
INSERT INTO tte_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ana tobenaliyao Yeisu siyanoi kabo siba, “Guyau, kusaguila, kikiunamo tasalili yo taboita.” ");
INSERT INTO tte_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kabo iwalo kolili, “Tawae kaiwena kwamatausi? Ami meli nige ilalalaki.” Kabo itolo yo yaumai yo bagolu iyokoi-yagili iba, “Besi, kwamwanou.” Kabo simwanou yo daumwali lalakina. ");
INSERT INTO tte_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tobenali meuloili kateli sipitali, siba, “Gubesi tomone bwaite. Yaumai yo bagolu ana walo tabe sibenalan.” ");
INSERT INTO tte_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yeisu me ana tobenaliyao siulisi Gadala dedeina mena. Na bwaine koina tomo labui yaluyaluwa biki kolili simiyamiya. Sauga meuloina silokeikeile sitakitakikili salai kolili. Mumugali inaesosi. Yanuwa tomoliyao simatausagili, nige sowasowana tomo yabo ilokeikeile salaine kana kamwasa mena. Kabo tomo labuiwa Yeisu sigitai mwa silau koina. ");
INSERT INTO tte_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Na siyogayoga, “Yaubada Natuna kowa, gubesi na kulaoma kolimai? Yakato bwaite sauga kuyakamkamnamai? Naga sauga yatala kana sauga.” ");
INSERT INTO tte_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na tupwana imamalawe kolili polo sibaibaiwa sidumudumuli sikekakekan kawasi koina. ");
INSERT INTO tte_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kabo yaluyaluwa biki sikawanoi Yeisu koina siba, “Tem kutao-yawatagilagimai, kuyawasamai kalau kalusae polone kolili.” ");
INSERT INTO tte_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yeisu iwalo kolili, “Kwalau.” Kabo siyawatagili tomo labuine kolili yo silusae polo kolili. Polo meuloili sisagena silau mala naenaena koina yo sikapusele kalita mena kabo sigalomwasi. ");
INSERT INTO tte_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Siya polo kali togitekalatan tawae iyawatagili sigitai kabo sisagena silau yanuwa mena yo ginauli meuloina sigitai siwalo-masalagili yo tabe tomone siya yaluyaluwa biki simiyamiya kolili wasali siyawasayan. ");
INSERT INTO tte_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kabo tomo meuloili silaomaya yanuwa mena Yeisu sabi gitaina. Saugana silobai sikawanoi tem ali dedei ilogabaen. ");
INSERT INTO tte_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yeisu imwalisae yoi waga mena yo ilopanaisi ipileyoi ana yanuwa mena, Kapeneomi. ");
INSERT INTO tte_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kabo tomo tupwaliyao tobelu yabo, yona itawalololi me ana kaba keno sikalaiyama Yeisu koina. Saugana Yeisu ali meli igitai iwalo tobelune koina, “Natugu me am katepatu, am pwanoli kaiweli nuwatu-pwaiki kulobaiyako.” ");
INSERT INTO tte_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Na loina kana toyakayakatai tupwaliyao sibomamo sibalabalamumu siwaloba, “Tomone ikawasewa Yaubada koina.” ");
INSERT INTO tte_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yeisu ali nuwatu ikatai kabo iwaloba, “Tawae kaiwena nuwatu naenaena kwanuwanuwatui katemiu mena? ");
INSERT INTO tte_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Tem yawaloba, ‘Am pwanoli Yaubada inuwatu-pwaikili,’ walone imalamalae. Na tem yawaloba, ‘Kutolo yo kulau’ walone ipolowe. Kaiwena tem nige itotolo kani wakawa-mwakomwakota-yagau. ");
INSERT INTO tte_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mwa kani yaginauli kabo wakatai yau Tomo Natuna me yagu kaiwe yanuwa yaulina mena yo tabe sowasowagu naenaena yanuwatu-pwaikili.” Kabo iwalo tobelune koina, “Kutolo, am kaba keno ukwalai yo kupileyoi am nume mena.” ");
INSERT INTO tte_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kabo tomone itolo, ana kaba keno imou yo ikalai ipileyoi ana nume mena. ");
INSERT INTO tte_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Sauganane boda sigitai kateli sipitali yo Yaubada sitobalani kaiwena sigitai Yaubada kaiwe lalakisosina iwolena Yeisu koina. ");
INSERT INTO tte_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yeisu yanuwane ilogabaeni ilalau yoi kabo tomo yabo esana Madiu igitai ana kaba paisowa mena imiyasio imiyamiya. Iya ana paisowa takesi kana totano. Kabo iwalolau koina iba, “Kumuliya koliyau.” Kabo Madiu itolo yo imuliya koina yo silau ana nume mena. ");
INSERT INTO tte_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yeisu iyaele ikekakekani Madiu ana nume mena kabo takesi kana totano yo tonaenaeli sibaibaiwa silaoma mekalikavao Yeisu yo ana tobenaliyao sikekani toyawa. ");
INSERT INTO tte_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Palisi tupwaliyao sigite-lobai kabo sineli ana tobenaliyao kolili siba, “Tawae kaiwena ami toyakayakatai mekanakavao takesi kana totano yo tonaenaeli sikekan toyawa?” ");
INSERT INTO tte_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kabo Yeisu walone ibenalan yo iba, “Namwanamwali genuwali towoiwoisi, na siya tokasiebwa ilonamwayagili towoiwoisi. ");
INSERT INTO tte_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Buki Tabu mena Yaubada iwaloba, ‘Yau nuwanuwagu katekamkamna yo mulolo, na genuwagu yakayakan kwapwaopwaoli-yagili.’ Naga kwalau na walone bwaite kana katai kwaloyai. Sibomamo ali nuwatu mena yakato siya sinamwanamwa Yaubada manna mena nige yalalaoma kaiweli sabi yoganli. Na yalaoma siya tolopwanoli Yaubada manna mena sabi yoganli.” ");
INSERT INTO tte_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kabo Yoni Toyababitaiso ana tobenaliyao silaoma Yeisu koina, sineli, “Kai mekamakavao Palisiyao guliyam kakalakisiyeyan, sauga tupwali nige sowasowana kakekan. Mumugamai besiele. Na tawae kaiwena am tobenaliyao nige sigiginauli besiele?” ");
INSERT INTO tte_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yeisu iwaloba, “Kasole soina kana sauga koina, tokasole tauna me ana elieliyamwao sikekan yo siyaliyaya lalakina. Nige sowana tolaoma sisikote kekan kaiwena tokasole tauna imiyamiya luwaluwalili mena. Na saugana tokasole tauna ilogabaegili ilau kabo nuwali sinae yo nige sikekekan, guliyam sikalakisiyeyan. ");
INSERT INTO tte_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nige sowasowana kaleko waluwaluna tupwatupwana takalai yo kwama beyabeyana koina tabwalui. Tem taginauli besiele, kaleko waluwaluna itabe-lulun kaleko beyabeyana yo itaigali lalakina. ");
INSERT INTO tte_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tabe besiele, nige sowasowana wain waluwaluna tasuwai kwapi kaba suwe beyabeyali kolili. Tem taginauli besiele kani wain waluwaluna isese isae na koina wain kwapi kaba suwene iyuigali yo wainne imasuwe, labuine sinae labulabui. Bwaite nigele. Wain waluwaluna tasuwai kwapi kaba suwe waluwaluli kolili kabo yoli labuine sinamwanamwa.” ");
INSERT INTO tte_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Saugana Yeisu iyaele iedeedede kabo yanuwane kana nume tapwalolo kana tobaguna yabo ilaoma tutulina italu-sakonayani manna mena kabo iwaloba, “Natugu sinena bwaite saugane koina iboita. Kulaoma nimam kupei yona mena na yawasina ivivila yoima.” ");
INSERT INTO tte_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kabo Yeisu itolo yo mekanakava silau yo ana tobenaliyao siyamuli-kusulili. ");
INSERT INTO tte_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Silalau kamwasa mena kabo sine kasikasiebwana yabo ilaoma Yeisu dagelana mena yo ana kaleko sopana ikabitonan. Sinene ana kasiebwa bwaite besiele. Bolime tuwelo kalona mena kwasinena ididididi na nagamo ididididi. ");
INSERT INTO tte_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ibomamo ana nuwatu mena iba, “Tem sowasowanamo kana kaleko yakabitonan kani yanamwanamwa.” ");
INSERT INTO tte_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yeisu itagelakeile sinene igitai kabo iwaloba, “Natugu, ukwatepatu. Am meli ikabi-namwanamwaiwo.” Sauganane koina sine bwaimwa inamwanamwa, ana kasiebwa imwawasi. ");
INSERT INTO tte_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","24","Saugana Yeisu ilusae tobagunane ana nume mena igitaili boda lalakina sitalatala-wauwau yo tupwali igo siyuiyui boita kana kilakilala. Kabo iwalolau kolili iba, “Kwalowasi, gamasinene nige iboboita, na ikekenomo.” Na ana walone kaiwena simalumaluwan. ");
INSERT INTO tte_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Siwalo boda sikaisulu kabo Yeisu ilau ilusae biliutusi mena gamasine ana kaba keno koina yo ikabilau nimana mena, kabo gamasinene itolo. ");
INSERT INTO tte_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kabo Yeisu ana paisowa wasana idebalala dedeinane meuloina koina. ");
INSERT INTO tte_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yeisu yanuwane ilogabaeni ilalau yoi kabo tomangibugibu labui siyamulikusuli yo siyogayoga, “Deibida Tubuna, ukwatekamkamna-yagimai.” ");
INSERT INTO tte_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Saugana ilusae nume mena tomangibugibu silaoma koina. Kabo ineli, “Gubesi, ami nuwatu yakato sowasowana manimiyao yayalalali?” Siwaloba, “O, besiele Guyau.” ");
INSERT INTO tte_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kabo manli ikabitonagili yo iba, “Besiele ami meli kani iyawatagili kolimiu.” ");
INSERT INTO tte_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mwa manli siyalalali. Kabo Yeisu iwalo kaiwe kolili, “Tabu tomo yabo ana wasa kwaolena.” ");
INSERT INTO tte_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Na iyamo saugana silau Yeisu wasana siyadebalala dedei meuloina kolili. ");
INSERT INTO tte_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yoli labuine silaoko kabo tomo yabo yaluyaluwa biki koina nige kainana mwa sikalaiyama Yeisu koina. ");
INSERT INTO tte_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kabo yaluyaluwa bikine itao-yawatagilani tomone koina kabo kainana ipei yo iedeedede. Tomo meuloili kateli sipitali yo siba, “Nige sauga yabo ginauli besiele bwaite kagigitai Isileli dedeina kalona mena.” ");
INSERT INTO tte_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Na Palisi siba, “Yaluyaluwa biki ali tobaguna ana kaiwe koina mwa yaluyaluwa bikine itao-yawatagilani.” ");
INSERT INTO tte_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yeisu ilau ilotakikili yanuwa lalakili yo yanuwa kikiuli kolili. Yo iyakayakatai ali nume tapwalolo yo iguguye Yaubada ana kaba loina wasana namwanamwana yo tomo iwoisili kasiebwa uloi uloi kolili. ");
INSERT INTO tte_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yeisu igitai bodane meuloili me ali nuwa-polowe yo tabe katekamkamnali, nige kali tosagu yabo yo bodane kana koleya besiele sipi bodana nige kali togitekalatani, sisanasana wasana namwanamwana kaiwena. Kabo Yeisu ikatekamkamna-yagili, ");
INSERT INTO tte_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","yo iwalo ana tobenaliyao kolili iba, “Tano ilalaki kanna imatuwa na topaisowa nige baibaiwali. ");
INSERT INTO tte_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kabo wakawanoi ala Guyau koina na topaisowa iyawasali silau tanone kanna silomwaui.” ");
INSERT INTO tte_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Kabo ana tobenaliyao yoli tuwelo iyoganli yo kaiwe iwolegili yakato yaluyaluwa biki sitao-yawatagilagili tomo kolili yo tabe siya kali kasiebwa uloi uloi siwoisili. ");
INSERT INTO tte_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yoli tuwelone esaliyao bwaite besiele, Saimoni siwaloba Pita, yo kanakava Anidulu, Yemesa iya Sebedi natuna, yo kanakava Yoni, ");
INSERT INTO tte_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipi yo Batolomiu, Tomasi yo Madiu iya takesi kana totano, Yemesa iya Alipio natuna yo Tadiyasi, ");
INSERT INTO tte_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimoni iya ilaomaya boda Selot kolili yo tabe Yudasa Isikaliota iya naga kani Yeisu ikalomagigilani yo iyauyan toloinao kolili. ");
INSERT INTO tte_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yeisu ana tobenaliyao yoli tuwelone iyawasali yo kali loina iwolegili iba, “Tabu kwalalau siya nige Yudiya ali dedei koina, o tem Sameliya ali yanuwa kolili. ");
INSERT INTO tte_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kwalau siya boda Isileli ali sipi kwalakwalaleleli kolili. ");
INSERT INTO tte_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kwalau kwayakayakatai kwawaloba, ‘Yaubada ana kaba loina kana sauga ikubwamako.’ ");
INSERT INTO tte_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tokasiebwao kwawoisili, toboitao kwawalo sitoloyoi, tolepeloyao wakabi-namwanamwaili, yaluyaluwa biki kwatao-yawatagilagili. Ami kaiwe yaeyawa bwagabwagai, komiu besiele kwaolena bwagabwagai tomo kolili, tabu maisana. ");
INSERT INTO tte_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Tabu mane gole yo siliba yo kopa kwatataulili ami pausi koina yo kwalolokalaili, ");
INSERT INTO tte_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","tabu kaleko kana tobwa kwalolokalaili ami laune kaiwena, tabu kae kana suma o ami sige o nuwana kwama labuina kwalolokalaili. Loina bwaitete yaeliwa kaiwena siya sagu silobai nimamiu mena ilonamwayagili siya tabe sisaguimiu.” ");
INSERT INTO tte_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Saugana tem kwalusae yanuwa yabo koina, nuwana yanuwa lalakina o nuwana yanuwa kikiuna, tomo namwanamwana yabo kwaloyai tomone tem iyaliyaya kaiwemiu iya ana nume mena kani kwamiyamiya kanasiga kwalogabaen. ");
INSERT INTO tte_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Saugana kwalusae nume mena kwawalo kolili kwaba, ‘Miyamiya namwanamwana Yaubada iyeyawa kolimiu.’ ");
INSERT INTO tte_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tem tomo siya numene koina siyaliyaya kaiwemiu ami walo-mulolo imiyayai. Tem nige siyoyoganmiu tabu ami walo-mulolo kwawawalowen kolili. ");
INSERT INTO tte_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tem nige siyayaliyaya kaiwemiu yo nige ami walo sibebenalan, kabo numene o tem yanuwane kwalologabaen kaemiu dekadekawana wakotatai-yani. ");
INSERT INTO tte_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yawalo yawasosi kolimiu, yanuwane kana tomiya kali maisa kani ilalakisosi sauga yatala koina kabo muli mena Sodoma yo Gomola kali maisa.” ");
INSERT INTO tte_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Kwabenali, yayawasamiu besiele sipi silalau bwauwa sokasokali luwali mena. Koinaele ilonamwayagimiu tem me ami katai manimiu itowa besiele weso yo mumugamiu bigana besiele bunetutu. ");
INSERT INTO tte_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Wagite-kalatagimiu kaiwena tomo tupwali kani sikalaimiu sipeimiu yatala koina yo maina kolokololona sikalai koina sisapimiu ali nume tapwalolo kolili. ");
INSERT INTO tte_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Esagu kaiwena kani sikalaimiu yo sipeimiu toloinao yo kin manli mena, na mesabana wasa namwanamwana kwayawasayan kolili yo siya nige Yudiya tomoliyao kolili. ");
INSERT INTO tte_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Saugana sikalaimiu yatala kaiwena tabu kwanuwanuwatu tawae kani kwawalowen. Kaiwena sauganane koina, tawae kani kwawalowen Yaubada kani walone iyeyawa. ");
INSERT INTO tte_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kaiwena walone bwaite kani kwaedeedede-yani, nige besiele kwaboma ami edeedede, na Tamamiu Yaluyaluwana imiya kolimiu yo iya iedeedede.” ");
INSERT INTO tte_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Tomo kanakava kani iwalo-masalan yo iyauyan toloinao kolili sabi unuyamatena. Tamana kani iginauli besiele tabe natunao kolili. Gagagili kani sitolo sinaliyao yo tamaliyao sikalomagigi-lagili sietalapili-yagili kabo siwolegili toloinao kolili sabi unuyamateli. ");
INSERT INTO tte_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Esagu kaiwena kani tomo meuloili sikalomagigi-lagimiu. Na yaiya tem itolo kaikaiwe kanasiga ana kaba mwawasi koina kani lebo ilobai. ");
INSERT INTO tte_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Saugana tem siyakamkamnamiu yanuwa yabo koina yanuwane kwayabubu-gabaen na kwalau yanuwa yaboyoi koina. Yawalo yawasosi kolimiu, ami paisowa kani nige kwaemwawasi Isileli ali yanuwa meuloina kolili kabo Tomo Natuna ilaoma. ");
INSERT INTO tte_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Tosikulu ana toyakayakatai nige sowana ilalaki-gabaen, besiele topaisowa ana taubala nige sowana ilalaki-gabaen. Komiu yagu melumeluwo mwa koinaele komiu tabe kani kamkamna kwalobai. ");
INSERT INTO tte_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ilonamwayan tem tosikulu besiele ana toyakayakatai yo topaisowa besiele ana taubala. Yau nume tanuwagana, na siwalo yakato yau Bielisibubi, kabo komiu yagu nume kana tomiya, kani esa naenaesosili sipeiliwa kolimiu.” ");
INSERT INTO tte_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Siya analiyao sikawa-naenae-yagimiu tabu kwamamatausagili, kaiwena ginauli kaukausili Yaubada kani isokeli yo ginauli wadawadamli kani iyamayaleli. ");
INSERT INTO tte_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tawae kani yawalowen wadam mena kolimiu, kwawalowen mayale mena. Tawae kani yabalamumuwan tenamiu mena, kwayoga kaikaiwe boda manli mena. ");
INSERT INTO tte_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tomo nige sowana yaluyaluwala siunuyamateli, sowasowalimo yola siunuyamateli mwa tabu kwamamatausagili. Na kwamatausiya Yaubada koina iya sowasowana yola yo yaluyaluwala isibayanaeli mayau wedowedolina koina.” ");
INSERT INTO tte_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","30","“Yaubada ginauli meuloina kaiwemiu ikatai yo inuwanuwatuimiu. Kaba gite bwaite kani yawalowen. Kitekitele sibaibaiwasosi yanuwa yaulina mena. Tem tomo nuwanuwali sigimwalaili maisali sikikiusosi nuwana kitekitele labui toeya kaigeda, wa? Siya ginauli kikiuli, na iyamo tem kitekitele yabo ibeku bwatano mena Tamala ikataiyako, kaiwena Yaubada ginauli meuloina ikatai. Na komiu tomeliwo ginauli lalakisosina yo inuwanuwatuimiu. Itomiu kaigeda kaigeda kana baibaiwa iyasili-woliyako. Walo yawasosi, iya sowasowana igite-kalatagimiu. ");
INSERT INTO tte_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Koinaele tabu kwamamatausi, komiu tomeliwo maisamiu ilalakisosi kabo muli mena kitekitele meuloili simiyamiya yanuwa yaulina mena maisali. ");
INSERT INTO tte_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Tem yaiya iwalo-masala tomo manli mena yakato iya yagu tomo, yau tabe kani tomonane esana yakeleisinan Tamagu manna mena bulibuli mena. ");
INSERT INTO tte_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Na yaiya tomo manli mena iuvalayagau yau tabe kani yauvalayan Tamagu bulibuli mena koina.” ");
INSERT INTO tte_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Tabu ami nuwatu yakato yalaoma yanuwa yaulina mena na ami miya daumwali kani yaginauli. Nigele, na kani tomo ali miya kalekaleya iyawatagili. ");
INSERT INTO tte_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yagu laoma mulina mena kani tomo ali miyamiya yayakasali, tau ikalomagigili tamana koina, sine ikalomagigili sinana koina, tau wainena ikalomagigili lawana koina. ");
INSERT INTO tte_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tomo yabo kana tokalomagigiliwo kani silaomaya totounao kolili.” ");
INSERT INTO tte_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Yaiya tamana o nuwana sinana ikatekamkamna-yagilisosi kabo muli mena yau, bwaimwa iya nige yagu boda. Yaiya natuna tem tau o sine, ikatekamkamna-yagilisosi kabo muli mena yau, bwaimwa iya nige yagu boda. ");
INSERT INTO tte_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yaiya tem kana kelose nige ikakalai yo imumuliya koliyau, ee nige sowana tawalo iya yagu boda. ");
INSERT INTO tte_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yaiya tem yawasina inuwai kaiwegu kani yawasina miyamiya yainane igabaen. Yaiya tem yawasina igabaen kaiwegu yawasina miyamiya yaina kani ilobai.” ");
INSERT INTO tte_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Yaiya tem iyoganmiu tabe yau yo kagu toyawasa iyoganmai. ");
INSERT INTO tte_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yaiya Yaubada ana tosagenawasa iyogan kaiwena iya Yaubada ana tosagenawasa, kani maisana ikalai besiele Yaubada ana tosagenawasa maisana. Yo tabe yaiya tomo dudulaina iyogan kaiwena iya tomo dudulaina kani maisana ikalai besiele tomo dudulaina maisana. ");
INSERT INTO tte_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yawalo yawasosi kolimiu, tem tomo yabo kagu tomeli waluwaluna isagui kaiwena iya yagu boda yabo, tomonane iya maisana kani ilobai, bwagana ana sagune ikikiu.” ");
INSERT INTO tte_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yeisu ana tobenaliyao yoli tuwelo ikabiyakaiweli imwawasi yo yanuwane ilogabaen ilau dedei Galili yanuwaliyao kolili na tem iyakayakatai yo iguguye. ");
INSERT INTO tte_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na Yoni Toyababitaiso iyaele deli mena, Keliso ana paisowa wasana ibenalan na inuwalabulabui kabo Yoni ana tomuliyayao tupwali iyawasali Yeisu koina. ");
INSERT INTO tte_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Sineli koina siba, “Kowa Mesaiyawa Yoni iwalowalowegiwowa kowa bwaite o nuwana naga ilalaoma?” ");
INSERT INTO tte_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yeisu kainali iyamaisa iba, “Kwapileyoi Yoni ana wasa kwaolena tawae kwabenalan yo wagitai, ");
INSERT INTO tte_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","tomangibugibu manli iyalalali, siya kaeli naenaeli silokeikeile, tolepelo yoli sinamwanamwako, totenakola sibenaliko, toboita sitoloyoiko yo tobubutuma wasa namwanamwana kana katai sibenaliko. ");
INSERT INTO tte_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yaiya tem nige inunuwa-labulabui kaiwegu Yaubada iwalo-muloloi.” ");
INSERT INTO tte_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yoni ana tobenaliyao sipipileyoi kabo Yeisu iyatubu iedeedede boda kolili Yoni kaiwena. Iwaloba, “Tauna kona Yoni Toyababitaiso ule bwagabwaga mena imiyamiya tomo iyabayababitaisoli yo komiu kwalau koina. Na sauganane koina tawae nuwanuwamiu wagitai? Nige kwalalau yakato tomo dabedabeuna wagitai. Kaiwena tomo dabedabeuna iya besiele lei liguna yaumai iyuiyui-kalakalai. Na Yoni iya nige besiele, wa? ");
INSERT INTO tte_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tem nigele tawae nuwanuwamiu wagitai? Nuwana tomo yabo kaleko namwanamwana ilikwa? Nigele, kaiwena siya kaleko namwanamwali silikwali simiyamiyaya kin ali nume mena. ");
INSERT INTO tte_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Na tawae nuwanuwamiu wagitai? Nuwana palopita yabo? Yawalo kolimiu, walo yawasosi Yoni iya palopitao bagubagunali ilalaki-gabaegili. ");
INSERT INTO tte_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yoni kaiwena mwa Yaubada iwalo-masalan palopita gamwana mena iba, ‘Yagu tosagenawasa kani yayawasa-bagunayan na iya am kamwasane ikatububun kaiwem.’” ");
INSERT INTO tte_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Yawalo yawasosi kolimiu, yanuwa yaulina kana tomiya bagubagunali yo kanasiga kabona meuloili Yoni Toyababitaiso ilalaki-gabaegili. Na yaiya esana ikikiusosi Yaubada ana kaba loina koina, iya Yoni ilalaki-gabaen. ");
INSERT INTO tte_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Iyatubu saugana Yoni iyakayakatai kanasiga kabona, tomo kaikaiweli siya kaleya kali toyatuyatubu sikaleya Yaubada ana kaba loina koina, sitonatonan yakato sikalai. ");
INSERT INTO tte_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","14","Mosese ana loina yo palopitao meuloili Yaubada ana kaba loina ana laoma siyawasayan kanasiga kabona, bwaite Yoni ana sauga mena. Yo sipalopalopisai siwaloba, ‘Ilaitiya kani ipileyoima.’ Tem ali palopisai kwameliyan yau yawalo kolimiu Yoni bwaite iya Ilaitiyanaele. ");
INSERT INTO tte_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tem metenamiu, ilonamwayagimiu yagu walone kwabenali-kalatagili. ");
INSERT INTO tte_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Yaso bwaite nuwanuwali yakato Yudiya mumugali besiele kai kamuliya. Toisabo kaba gite yawalowen ami kaba nuwamayale yaso bwaite kaiwena? Siya besiele gagagili simiyasio kaba gimwala mena siyogayoga kalikavao kolili siba, ");
INSERT INTO tte_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Kasole kana igo kayui na komiu nige kwaseselo, boita walina kawaliyan na komiu nige kwavavalam.’ ");
INSERT INTO tte_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Na yaso bwaite kaliyate kabona besiele gagagili kaiwena Yoni ilaoma yo guliyam ikalakisiyeyan kawanoi kaiwena yo oine nige inunuma, na iyamo yaso bwaite siba, ‘Ikabakabaleya.’ ");
INSERT INTO tte_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yo yau Tomo Natuna yalaoma yakekan yo yanuma kabo yasone bwaite siba, ‘Tomone iya tokan kalakalabili yo tonuma kalakalabili, iya takesi totano yo tonaenaeli ali eliyam.’ Na yau yawalo kolimiu yakato sonoga yawasosi ilaomaya Yaubada koina yo naga uwena tagitai kabo sonogane takawa-yawasosiyan.” ");
INSERT INTO tte_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yeisu iwalowalo yanuwane kaiweli, bwagana siya ginauli kaba nuwapwanopwano sibaibaiwa iginaulili kaloli mena yo sigitaili na iyamo nige sinunuwabui kabo ikawa-naenae-yagili ali kololo kaiwena. ");
INSERT INTO tte_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Iwaloba, “Ee komiu tomo Yudiya kwamiyamiya yanuwa Kolasin koina, katekamkamnamiu, bwaliga kani kwasilae. Ee tabe Betesaida, katekamkamnamiu, bwaliga kani kwasilae. Tauna kona ginauli kaba nuwapwanopwano yaginaulili luwamiu mena, na nige kwanunuwabui. Tem ginauli kaba nuwapwanopwanone yaginaulili siya nige Yudiya tomonliyao manli mena besiele Taiya yo Saidoni luwali mena kani mwayamwayau kwauya kwamana sikwamai yo kau koina simiyasio yo sinuwabui. ");
INSERT INTO tte_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Taiya yo Saidoni Yaubada kani isikotanagili kaiwena siya toyauyaule yawasosi. Na yawalo kolimiu, yatala kana kaliyate koina, komiu maisamiu ipolowesosi kabo muli mena Taiya yo Saidoni kali maisa.” ");
INSERT INTO tte_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Gubesi komiu Kapeneomi? Nuwana ami nuwatu yakato Yaubada esamiu ikeleisinan bulibuli mena? Nigele. Kani ipei-yatalumiu, kwalobi molosi gun mena. Tauna kona ginauli kaba nuwapwanopwano yaginaulili luwamiu mena wagitailiko na nige kwanunuwabui. Kaba gite yabo kani yaeyawa yakato wakatai komiu toyauyaulesosi yo katemiu sikololososi. Tem yau yamiyamiya Abelamo ana sauga mena yo ginauli kaba nuwapwanopwanone, bwaimwa yaginauliliko manimiu mena, yaginaulili yoi Sodoma manli mena kani mwayamwayau sinuwabui yo Yaubada ana munamunai siyabubu-gabaen kabo tubuliyao simiyamiya ilaoma sauga kabona koina. ");
INSERT INTO tte_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Na yawalo kolimiu, yatala kana kaliyate koina, komiu kami maisa ipolowesosi kabo muli mena Sodoma kali maisa.” ");
INSERT INTO tte_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Sauganane koina Yeisu ikawanoi Yaubada koina iba, “Tamagu, kowa bulibuli yo yanuwa yaulina ali Guyau, yatobalanagiwo kaiwena am kaba loina kana katai kuwadam tosonoga yo tokatai kolili na kuyamayaleyako siya nige tosonoga kolili. ");
INSERT INTO tte_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Walo yawasosi Tamagu, kaiwena am nuwatu besiele uginauli.” ");
INSERT INTO tte_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ana kawanoi imwawasi kabo iwaloba, “Katai meuloina Tamagu iyeyamako koliyau yo yayamayaleyako tomo kolili. Nige yabo ikakataiyau iyamo Tamagu, yo nige yabo Tamagu ikakatai yaumo Natuna, yo tabe siya yagitesipwaili. ");
INSERT INTO tte_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Komiu analiyao me kami polowe yo tabe komiu yomiu sibelubelu kwalaoma koliyau kabo yayakaiyawasimiu. ");
INSERT INTO tte_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kayakayale bwaite yaeyawa wakalai yo mumugagu kwamuliya kaiwena yau tonuwalobi yo mumugagu bigana, kabo yaluyaluwamiu kaiyawasi silobai. ");
INSERT INTO tte_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kaiwena kayakayale bwaite yaeyawa imalamalae yo ketauli bwaite yaeyawa nige ipopolowesosi.” ");
INSERT INTO tte_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mulina mena kaliyate sabati yabo koina Yeisu ilusae witi kana tano mena. Ana tobenaliyao siguliyam kabo siyatubu witi kanna sikibwali yo sikekan. ");
INSERT INTO tte_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Saugana Palisi sigitaili kabo siwalo Yeisu koina siba, “Ugitai, am tobenaliyao sabati kana loina silikwai.” ");
INSERT INTO tte_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Yeisu kainali iyamaisa iba, “Saugana Kin Deibida me ana eliyamwao siguliyam silusae Yaubada ana nume mena kabo beledi yakayakasisina sikalai yo sikan. Walo yawasosi Mosese ana loina silikwai kaiwena loinane iwalo yakato topwaolimo sikan. Nuwana Deibida edeededena nige kwanunuwatu-kalatan. ");
INSERT INTO tte_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mosese ana loina Buki Tabu mena iba, ‘Saugana sipaipaisowa Nume Tabu koina topwaoli sabati kaigeda kaigeda sabati kana loina silikwai na Yaubada nige ikakawa-naenae-yagili.’ Nuwana walone nige kwayayasili. ");
INSERT INTO tte_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Na yawalo kolimiu, yabo iyaele bwaite, iya Nume Tabu esana ilalaki-gabaen. ");
INSERT INTO tte_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yaubada iwalo palopita gamwana mena iba, ‘Yau nuwanuwagu katekamkamna yo mulolo, na genuwagu yakayakan kwapwaopwaoli-yagili.’ Tem walone bwaite kana dudulai kwanuwa-mayaleyan, kani nige sowasowana siya nige ali nae ipapagan wakakawa-naenae-yagili. ");
INSERT INTO tte_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kaiwena yau Tomo Natuna sabati kana Guyau.” ");
INSERT INTO tte_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yeisu yanuwane ilogabaen yo ilau yanuwa yaboyoi koina kabo ilusae ali nume tapwalolo mena. ");
INSERT INTO tte_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","13","Palisi nuwanuwali Yeisu kaba yakewaina siginauli kabo sineliyan, “Ala loinane gubesi ana walo? Sowasowana tomo yabo takabi-namwanamwai kaliyate sabati koina o nigele?” Kainali iyamaisa iba, “Tem komiu yabo me ana sipi yo kaliyate sabati koina sipine ibeku-lobi gula mena kani gubesi tomone ana pagapaganna? Kani ilau sipine ikabi-kalatan yo gulane koina itabe-seyan. Sipi ginauli lalakina na iyamo tomo ginauli lalakisosina. Koinaele, sowasowana ginauli namwanamwana taginauli kaliyate sabati koina.” Na nume tapwalolone koina tomo yabo iyaele imiyamiya nimana belubeluna. Kabo Yeisu iwalo tomone koina, “Nimam kutu.” Sauganane koina nimana iutu mwa inamwanamwa besiele nimana labuinane. ");
INSERT INTO tte_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kabo Palisi me ali munamunai siyawatagili sinuwanuwatu toisabo kamwasa koina na Yeisu siunuyamate. ");
INSERT INTO tte_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yeisu Palisi ali nuwatu ikataiyako kabo yanuwane ilogabaen. Tomo sibaibaiwa siyamuli-kusuli yo ali tokasiebwao ikabi-namwanamwaili, ");
INSERT INTO tte_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","yo iwalo-kausili tabu wasana siyayadebalala. ");
INSERT INTO tte_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Iginauli besiele kabo Yaubada ana walo bwaite palopita Aiseya iwalo-masalan iyamala yawasosi. ");
INSERT INTO tte_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘Yagu topaisowa bwaite iya yagitesipwai, yamulolo lalakina yo yayaliyaya, kani Yaluyaluwagu yapei koina yo iya yagu loina dudulaina iyawasayan tomo meuloili kolili. ");
INSERT INTO tte_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kani nige igagamwapakiki yo tabe nige itatalawauwau, nige sowana iedeedede boda kolili kamwasa mena kainana lalakina mena. ");
INSERT INTO tte_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kani nige lei welawelaina itatabe-golu yo kani nige odam kibukibuna itatabe-yamate. Kani ipaisowa mumuga bigana koina kanasiga Yaubada ana loina dudulaina iyawatagili yanuwa yaulina mena. ");
INSERT INTO tte_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Iya esana mena kani tomo sibaibaiwa ali meli sipei.’ ");
INSERT INTO tte_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tomo tupwaliyao tomo yabo siyoganama man gibugibuna yo nige kainana ipapagan, kaiwena yaluyaluwa biki imiyamiya koina. Yeisu iwoisi kabo tomone iedeedede yo manna silala. ");
INSERT INTO tte_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tomo meuloili Yeisu ana paisowa kaiwena kateli sipitali, kabo siwaloba, “Gubesi, nuwana iya Mesaiya bwaimwa Deibida tubuna?” ");
INSERT INTO tte_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Na saugana Palisi walone sibenalan siba, “Dimoni ali tobaguna Bielisibubi ana kaiwe koina mwa yaluyaluwa biki itao-yawatagilagili.” ");
INSERT INTO tte_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yeisu ali nuwatu ikataiyako kabo iwalo Palisi kolili iba, “Tem kaba loina yabo iigali boda labui kolili kabo siboma siekalekaleya-yagili kabo kaba loinane kani itatagwaligwali imwawasi. Tabe besiele tem yanuwa yabo o nuwana susu yabo siwalei boda labui kani nige sikakaiwe. ");
INSERT INTO tte_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Besiele tabe, tem Seitani iboma ana boda itao-yawatagilagili, ee iboma ikaleyaili kabo ana kaba loina kani imwawasi. ");
INSERT INTO tte_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kwawalo yakato Bielisibubi ana kaiwe koina yaluyaluwa bikine yatao-yawatagilagili. Tem kwawalo besielene kabo yaiya ana kaiwe koina na komiu ami tomuliya yaluyaluwa biki sitao-yawatagilagili? Ee, kani ami tomuliya nuwatune bwaite sikawa-naenae-yani na ami lopwano siwalo-masalan kolimiu. ");
INSERT INTO tte_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Na tem Yaubada Yaluyaluwana ana kaiwe koina yaluyaluwa bikine yatao-yawatagilagili kabo Yaubada ana kaba loina ilaomako kolimiu.” ");
INSERT INTO tte_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Seitani iya besiele tomo kaikaiwena. Nige sowasowana tomo yabo ilusae tokaikaiwene ana nume mena yo ana gogo ikalaili, awa? Na tem baguna tokaikaiwene tapan-kalatan kabo sowasowana ana nume mena talusae na gogo takewalili.” ");
INSERT INTO tte_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Yaiya nige yagu boda iya kagu tokalomagigili. Yaiya tem nige mekaukava kapaipaisowa iya boda kana toyakasa yo tosibayanae. ");
INSERT INTO tte_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yawalo kolimiu tem yaiya mumugana naenaena iginauli yo tem iwalo-bwagabwaga yo Yaubada isinali, sowasowana ana naenaena bwaite Yaubada inuwatu-pwaiki. Na tem yaiya iwalo-bwagabwaga yo Yaluyaluwa Tabuna isinali, bwaitete Yaubada kani nige inunuwatu-pwaiki. ");
INSERT INTO tte_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tem yaiya Tomo Natuna ikawa-naenae-yani sowasowana ana naenaenane bwaite Yaubada inuwatu-pwaiki. Na yaiya Yaluyaluwa Tabuna ikawa-naenae-yani ana naenaenane bwaite Yaubada kani nige inunuwatu-pwaiki, bwaite saugane yo sauga ilalaoma koina.” ");
INSERT INTO tte_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Tem mayau namwanamwana, ee kanna inamwanamwa. Tem mayau naenaena, ee kanna naenaena. Tem kanna tagitai kabo mayaune takatai tem namwanamwana o tem naenaena. ");
INSERT INTO tte_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Komiu Palisi besiele weso. Komiu tomo naenaeli kabo nige sowasowamiu edeedede namwanamwana kwaedeedede-yagili, nigele molosi. Tawae katena mena imiyamiya ikalapowon masumasuwe ee kani tomo iedeedede gamwana mena. ");
INSERT INTO tte_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tomo namwanamwana ginauli namwanamwana iwalowen besiele ginauli namwanamwana katena kalona mena ipeigogonan. Tomo naenaena ginauli naenaena iwalowen besiele ginauli naenaena katena kalona mena ipeigogonan. ");
INSERT INTO tte_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Na yawalo kolimiu, yatala kana kaliyate koina kani tomo kaigeda kaigeda yatala ilobai edeedede bwagabwaga meuloina iwalowenako kaiweli. ");
INSERT INTO tte_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tem ami walo, walo namwanamwana kani Yaubada ikawa-namwanamwa-yagimiu. Na tem ami walo, walo naenaena kani Yaubada ikawa-yauyaule-yagimiu.” ");
INSERT INTO tte_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kabo Palisi yo loina kana toyakayakatai tupwaliyao siwalo koina siba, “Toyakayakatai, nuwanuwamai ginauli kaba nuwa-pwanopwano yabo kupaisowai kagitai.” ");
INSERT INTO tte_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yeisu kainali iyamaisa iba, “Yaso naenaena komiu, nige kwamiyamiya Yaubada koina kabo nuwanuwamiu ginauli kaba nuwapwanopwano yapaisowai kaiwemiu. Na kani nige ginauli kaba nuwapwanopwano yabo yaeyawa, bwaimwanamo bwaite iyawatagili palopita Yona koina. ");
INSERT INTO tte_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Besiele kaliyate yaiyona yo boniyai yaiyona Yona imiyamiya iye lalakina diyana kalona mena, besiele tabe kaliyate yaiyona yo boniyai yaiyona yau Tomo Natuna kani yamiyamiya bwatano kalona mena. ");
INSERT INTO tte_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kaliyate yatala koina tomo Ninibe kani sitolo sikawa-naenae-yagimiu, kaiwena sauga beyabeyana koina Yona ana guguye sibenalan kabo mumugali naenaena koina sinuwabui. Na yawalo kolimiu, yabo iyaelete bwaite, iya Yona ana guguye ilalaki-gabaen. ");
INSERT INTO tte_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kaliyate yatala koina Seba ali toloina lalakina sine yabo (kuin) kani itolo yo ikawa-naenae-yagimiu kaiwena sauga beyabeyana koina ilaoma kelamamalawe koina nuwanuwana Kin Solomoni ana sonoga ibenalan. Na yawalo kolimiu, yabo iyaelete bwaite, iya Kin Solomoni ana sonoga ilalaki-gabaen.” ");
INSERT INTO tte_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Saugana yaluyaluwa biki iyawatagilima tomo yabo koina, yaluyaluwane ule bwagabwaga mena itakitakikili ana kaba kaiyawasi iloyaloyai, na nige yabo ilolobai. ");
INSERT INTO tte_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mwa iba, ‘Kani yapileyoi naga tomone koina bwaine yalogabaeniwa.’ Saugana ipileyoi igitai tomone katena besiele nume yabo sikuyayako yo sikatububu-nonowaiyako, nige yabo kalona mena imiyamiya. ");
INSERT INTO tte_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kabo ilau yo ana tali yaluyaluwa naenaeli kolili kali baibaiwa seben tabe ikalaili siya mumugali naenaesosili, kabo mekanakavao silusae yo simiyamiya tomone katena koina. Tomone ana miyamiya bagubagunana inae na muli mena inaesosi. Yo bwaine besiele tabe kani iyawatagili kolimiu komiu yaso naenaena.” ");
INSERT INTO tte_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yeisu iyaelemo iedeedede boda kolili kabo sinana yo kanakavao siyawatagili sitotolo gana muli mena nuwanuwali siedeedede koina. ");
INSERT INTO tte_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kabo tomo yabo ana wasa iwolena iba, “Sinam yo kamkavao siyaele bwaite sitotolo gana muli mena, nuwanuwali siedeedede koliwo.” ");
INSERT INTO tte_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yeisu kainana iyamaisa, iba, “Yaiya sinagu, yo analiyao kaukavao?” ");
INSERT INTO tte_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Mwa Yeisu nimana iyagayan tobenaliyao kolili yo iba, “Siya bwaite sinaguwao yo kaukavao. ");
INSERT INTO tte_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yaiya tem Tamagu bulibuli mena ana nuwatu ipaipaisowai iya kaukava, dugu yo sinagu.” ");
INSERT INTO tte_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kaliyatenane koina Yeisu iyawatagilima nume mena yo ilobi imiyasio dekawa mena. ");
INSERT INTO tte_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Boda lalakisosina silogogo koina kabo igayolobi waga yabo koina imwalisae yo imiyasio na bodane dekawa mena sitotolo ana edeedede sibenabenali. ");
INSERT INTO tte_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ginauli meuloina iwalowen walo kobwaibwaili mena. Kaba gite bwaite besiele iba, “Tomo yabo ilau tano mena patu iyasululi sabi kuma. ");
INSERT INTO tte_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Saugana patune iyasululi, tupwaliyao sitalu-suwala kamwasa mena kabo man sieva-talu yo sikanli. ");
INSERT INTO tte_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tupwaliyao sitalu-suwala mala-vekuveku mena bwaine koina bwatano namwanamwana nige ilalalaki. Mwayamwayau sikin na iyamo bwatanone nige ibabalubalu. ");
INSERT INTO tte_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Na saugana dabwelo itunsae, kinne igabu yo siweweka, kaiwena lamli nige silolobi namwanamwa. ");
INSERT INTO tte_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Patu tupwaliyao sitalu-suwala kawasi naenaeli luwali mena. Na kawasi naenaeli mwayamwayau sikin-saema yo sipanli simomosi-yamateli. ");
INSERT INTO tte_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Patu tupwaliyao sitalu-dudulai bwatano namwanamwana koina kabo siuwe yo sidibubu tupwali kanli wan andeledi (100), tupwali sikisti (60), tupwali teti (30). ");
INSERT INTO tte_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tem metenamiu, ilonamwayagimiu walone bwaite kwabenali-kalatan.” ");
INSERT INTO tte_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ana tobenaliyao silaoma Yeisu koina yo sineli siba, “Tawae kaiwena walo kobwaibwaili mena kuedeedede boda kolili?” ");
INSERT INTO tte_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yeisu kainali iyamaisa iba, “Yaubada ana kaba loina kana nuwatu wadawadamna yalivasiyako kolimiu kabo nuwamiu sidudulai na siya tomo bwagabwaga, siya nige ali meli, nigele. ");
INSERT INTO tte_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yaiya me ana katai, Yaubada kani ietulan kabo Yaubada kana katai ilalakisosi koina. Yaiya Yaubada nige ikakatai, na tawae ana katai kikiuna, Yaubada kani ikelegabaen. ");
INSERT INTO tte_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Bwaite kaiwena walo kobwaibwaili mena yaedeedede kolili, ‘Simanman-kulakulamo na nige sigigitai, sibenabenalimo na nige sikakatai.’ ");
INSERT INTO tte_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Na kolili palopita Aiseya ana lelelele iyamala yawasosi iba, ‘Kwabenalimo na nige wakakatai, Kwamanman-kulakulamo na nige wagigitai. ");
INSERT INTO tte_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kaiwena tomo bwaitete kateli sikololo, tenali sikola yo manli sigibu, manli siyagibuli yo tenali sisibuga-kausili. Tem nige sigiginauli besiele nuwana sigigitai manli mena, nuwana sibebenalan tenali mena yo nuwana sikakatai kateli mena kabo sinuwabui yo yakabi-namwanamwaili.’ Na nige sigiginauli besiele. ");
INSERT INTO tte_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Na komiu Yaubada iwalo-muloloimiu kaiwena manimiu silala yo tenamiu sitamwalapan. ");
INSERT INTO tte_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yawalo yawasosi kolimiu, Yaubada ana palopitao yo todudulai bagubagunali sibaibaiwa nuwanuwasosili Mesaiya sigitai yo ana walo sibenalan, na nige sowasowali. Na komiu Mesaiya wagitai yo ana walo kwabenalan.” ");
INSERT INTO tte_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Kwabenali, na kabo patu toyasulu kana walo kobwaibwaili kana dudulai wakatai. ");
INSERT INTO tte_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Saugana tem tomo yabo Yaubada ana kaba loina wasana ibenalan, na kana dudulai nige ikakatai kani Seitani ilaoma yo tawae siya sikumai katena mena ikwayai. Na bwaite patune siya toyasulu iyasululi na sitalu-suwala kamwasa mena. ");
INSERT INTO tte_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Patune bwaite toyasulu iyasululi na sitalu-suwala mala-vekuveku mena na bwaite tomo siya wasa namwanamwana sibenalan yo mwayamwayau me ali yaliyaya sipeili kateli mena. ");
INSERT INTO tte_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ginauli kaigeda wasa namwanamwana nige sinuwanuwatu dudulai kateli mena, lamli nige ilolobi namwanamwana kabo ali meli nige imamamalawe. Saugana tem polowe silobai o tem siyakamkamnali wasa namwanamwana kaiwena, mwayamwayau yaluyaluwali sibui yo sisikote. ");
INSERT INTO tte_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Patune bwaite toyasulu iyasululi na sitalu-suwala kawasi naenaeli luwali mena, bwaite tomo siya wasa namwanamwana sibenalan, na sinuwanuwatu yanuwa yaulina kana yaliyaya kaiwena yo sinuwa-wasawasa, kabo ginauli bwaite wasa namwanamwana sipan-yamate, nige kanna ipapagan. ");
INSERT INTO tte_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Patune bwaite toyasulu iyasululi na sitalu-dudulai bwatano namwanamwana koina, bwaitete tomo siya wasa namwanamwana sibenalan yo sikatai kana dudulai. Iuwe kanna tupwali wan andeledi, tupwali sikisti, tupwali teti.” ");
INSERT INTO tte_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yeisu walo kobwaibwaili yaboyoi tabe iwalowen iba, “Yaubada ana kaba loina besiele bwaite. Tomo yabo witi patuna namwanamwana iyasulu ana tano mena. ");
INSERT INTO tte_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Boniyai mena tomo meuloili sikenokeno kabo tomone kana tokalomagigili ilaoma, kawasi naenaena patuna iyasululi witi luwana mena yo ilau. ");
INSERT INTO tte_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Saugana witi ikin yo kanna iyatubu kabo kawasi naenaena ikinsae tabe mekanakava sikin-toyawa. ");
INSERT INTO tte_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tomone ana topaisowao silaoma koina siba, ‘Taubala, kai kabatoko witi patuna namwanamwanamo kuyasulu am tano mena? Na kawasi naenaena tabe mekanakava sikin-toyawa sisae. Gubesi, toweya koina kawasine naenaenane ilaomaya?’ ");
INSERT INTO tte_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Iwalo kolili, ‘Tokalomagigili yabo iginauli bwaimwa.’ Topaisowa sineli siba, ‘Tabu nuwanuwam kalau kakawasi-gabaen?’ ");
INSERT INTO tte_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Iba, ‘Imiyawaya, kaiwena tem kawasi naenaena wakawasi-gabaen kani witi tupwana mekanakava kwasulu-kaigedaili. ");
INSERT INTO tte_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yoli labuine sikin toyawa naga kanasiga kelikeli kana sauga mena. Kani yawalo tokelikeli kolili besiele, ‘Kawasi naenaena kwasulu-bagunayan yo kwabwagilili kabo tagabuli na witi wakalailima yo kwapeili yagu lakawa lalakina koina.’” ");
INSERT INTO tte_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yeisu walo kobwaibwaili yaboyoi iwalowen, iba, “Yaubada ana kaba loina besiele mayau esana ketabu patuna, tomo yabo ikalai yo ikumai ana bakubaku mena. ");
INSERT INTO tte_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Na iya patune meuloina ali tokikiusosi, na saugana ikin yo ilalaki, ginauli meuloina bwaite sikin bakubaku mena ilalaki-gabaegili. Iyamala mayau yabo lalakina kabo man siya evaevali silaoma ali noi siginauli lagalagana kolili.” ");
INSERT INTO tte_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yeisu walo kobwaibwaili yaboyoi iwalowen iba, “Yaubada ana kaba loina besiele yisti, sine yabo yisti kikitoitoina ikalai yo ipei pwalawa kana lalaki baiki yaiyona kalona mena kabo yisti ipaisowai kanasiga pwalawa meuloina iyebweli namwanamwaili yo meuloina isese ilalaki.” ");
INSERT INTO tte_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sauga meuloina Yeisu iedeedede tomo kolili walo kobwaibwaili mena. Nige sauga yabo ana edeedede koina walo kobwaibwaili yabo idedeva. ");
INSERT INTO tte_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kabo palopita ana palopisai Yeisu kaiwena iyamala yawasosi iba, “Gamwagu yasoke yo yawalo kobwaibwaili ginauli wadawadamli yaedeedede-yagili simiya-wadam saugana bwaite yanuwa yaulina iyatubu kanasiga sauga bwaite.” ");
INSERT INTO tte_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kabo Yeisu boda ilogabaegili yo ilusae nume mena ana tobenaliyao silaoma koina yo siba, “Kawasi naenaeli sikin tano mena kana kobwaibwaili kulivasi kolimai.” ");
INSERT INTO tte_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kainali iyamaisa iba, “Tomo bwaite witi patuna namwanamwana iyasulu iya Tomo Natuna. ");
INSERT INTO tte_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tano bwaine yanuwa yaulina, yo witi patuna namwanamwana bwaimwa Yaubada ana kaba loina tomoliyao. Kawasi naenaena Seitani ana tomoyao. ");
INSERT INTO tte_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yo tokalomagigili siya kawasi naenaena patuli toyasulu, bwaimwa Seitani. Kelikeli kana sauga bwaimwa sauga ana kaba mwawasi koina, yo tokelikeli bwaimwa aneloseyao. ");
INSERT INTO tte_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kawasi naenaena sikawasi-gabaegili yo sigabuli mayau koina, na kani besiele tabe sauga ana kaba mwawasi koina. ");
INSERT INTO tte_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tabe besiele kani Tomo Natuna ana aneloseyao iyawasali, kabo tolopwanoli yo siya mumuga naenaena siginaginauli, meuloili sikawasi-gabaegili ana kaba loina koina. ");
INSERT INTO tte_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kani sigabae-luseyagili mayau kalapulupululuna lalakina koina kabo bwaine koina sivalam yo mwakali siyekalasi na sikikokiko. ");
INSERT INTO tte_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kabo todudulai kali koleya sibuili besiele dabwelo ana sae mayalena Tamali ana kaba loina koina. Tem metenamiu, yagu walone kwanuwatu-kalatan.” ");
INSERT INTO tte_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Yaubada ana kaba loina besiele gogo wasawasa lalakina iwadam tano yabo koina yo iboita-gabaen. Tomo yabo ilobai kabo ipuluiyoi tanonane koina. Iyaliyaya yawasosi gogone wasawasane kaiwena, kabo ilau ana gogo meuloina igimwala-yagili, manena ikalai yo tanowa iyamaisa.” ");
INSERT INTO tte_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Yaubada ana kaba loina besiele tabe bwaite. Gogo wasawasana kana togimwala yabo sise tumana pigapigabuna iloyaloyai. ");
INSERT INTO tte_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kabo yabo namwanamwasosina ilobai yo ilau ana gogo meuloina igimwala-yagili manene ikalai na sise tumana namwanamwasosinawa iyamaisa.” ");
INSERT INTO tte_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Yaubada ana kaba loina besiele tabe yagida igalayan kalita mena. Kabo iye kali koleya uloina uloina sikona. ");
INSERT INTO tte_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Saugana ikalapowon togomana yagida siniuli-seyan magu mena. Simiyasio yo iye siyakasali, siya namwanamwali sipeili gaeba mena siya naenaeli sigabaegili. ");
INSERT INTO tte_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kani besiele sauga ana kaba mwawasi koina. Aneloseyao silaoma tonaenaeli yo tonamwanamwali siyakasali, siya naenaeli sipei-suwalagili, ");
INSERT INTO tte_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","sigabae-luseyagili mayau kalapulupululuna lalakina koina, kabo bwaine koina sivalam yo mwakali siyekalasi na sikikokiko.” ");
INSERT INTO tte_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yeisu ineli iba, “Nuwamiu sidudulai ginauli bwaite kaiweli?” Siya siba, “O, besiele.” ");
INSERT INTO tte_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kabo iwalo kolili iba, “Tem loina kana toyakayakatai yabo yagu yakayakatai Yaubada ana kaba loina kaiwena ipei katena mena iya besiele nume tanuwagana yabo ilau ana biliutusi mena yo ana gogo wasawasali waluwaluli yo beyabeyali ikele-yawatagilagilima na ileleili.” ");
INSERT INTO tte_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yeisu walo kobwaibwaili bwaite iwalowen imwawasi, kabo yanuwane ilogabaen. ");
INSERT INTO tte_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ilau iboma ana yanuwa mena iyakayakatai nume tapwalolo mena kabo tomo kateli sipitali yo siba, “Ana kataine toweya ikalaiya? Gubesi mwa sowasowana ginauli kaba nuwapwanopwano ipaisowaili? ");
INSERT INTO tte_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Na iya tokabikabi natuna, wa? Iya tomo bwagabwagamo kaiwena sinana esana Meli, kanakavao Yemesa, Yosepa, Saimoni yo Yudasa. ");
INSERT INTO tte_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Dunao meuloili siyaele mekalakavao, besiele wa? Kabo ana katai yo ana sonoga toweya ikalailiya?” ");
INSERT INTO tte_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Koinaele simunamunai koina yo sikalomagigilan. Yeisu iwalo kolili iba, “Tomo meuloili palopita siyakasisiyan, na iyamo totounao yo ana yanuwa tomoliyao nige siyayakasisiyan.” ");
INSERT INTO tte_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nige ginauli kaba nuwapwanopwano sibabaibaiwa igiginaulili yanuwane koina kaiwena nige simemeliyan. ");
INSERT INTO tte_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sauganane koina Elodi, Galili ali tobaguna, Yeisu wasana ibenalan, ");
INSERT INTO tte_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","kabo iwalo ana topaisowao kolili, “Tomone bwaite nuwana iya Yoni Toyababitaiso, nuwana boita mena itoloyoima, bwaite kaiwena sowasowana ginauli kaba nuwapwanopwano iginaulili.” Elodi iwalo besiele kaiwena nuwana mena isae tawae tauna kona iginauli Yoni koina saugana iunuyamate. ");
INSERT INTO tte_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Elodi tauna kona kanakava Pilipi wainena Elodiyasa ikwayai mwa ikasolanan. Mwa Yoni iwalo koina iba, “Nige sowasowana ukwasolanan.” Kabo Elodi imunamunai yo ana topaisowao iyawasali Yoni sikabi-kalatan yo sipan silawan sipei nume pan koina. Iginauli wainena Elodiyasa kaiwena. ");
INSERT INTO tte_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Elodi nuwanuwana Yoni iunuyamate na tomo meuloili imatausagili kaiwena Yoni siya simeliyan yakato iya palopita yabo. ");
INSERT INTO tte_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Elodi ana sauga kabi kana kaliyate kana nuwatu kalatan kekanna koina, Elodiyasa natuna sinena iselo boda manli mena. Ana selo kaiwena Elodi iyaliyaya lalakina. ");
INSERT INTO tte_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nimana ikeleisinan kabo iwalo koina, “Yawaloyameli koliwo, tawae nuwanuwam ukawanoiyan, kani yaeyawa.” ");
INSERT INTO tte_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Elodiyasa nuwanuwana Yoni iboita kabo iwalo natuna koina kabo natuna iwalo Elodi koina, iba, “Yoni Toyababitaiso galogalona kutom, kutauli gaeba mena, ukwalaiyama koliyau yo yagitai.” ");
INSERT INTO tte_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kin nuwana inae, yo nige sowasowana ana kawalulu isoke-gabaen, kaiwena iwaloyameliko boda manli mena. ");
INSERT INTO tte_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Koinaele iwalo Yoni galogalona sitom nume pan koina. ");
INSERT INTO tte_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Sitauli gaeba mena kabo sikalaiyama siwolena gamasinene koina, kabo ikalai ilawan sinana koina. ");
INSERT INTO tte_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yoni ana tomuliyayao silaoma, yona sikalai silawan sipei salai mena. Kabo silau yo Yeisu ana wasa siwolena. ");
INSERT INTO tte_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yeisu Yoni ana boita wasana ibenalan kabo yanuwane ilogabaen. Nuwanuwana ibomamo ilau imiya-suwala kabo waga yabo koina imwalisae yo ilau iulisi paepaeli bwagabwaga mena. Yanuwa tomoliyao Yeisu ana lau wasana sibenalan kabo ali yanuwa silogabaegili na kaeli mena siyamuli-kusuli siyona silau. ");
INSERT INTO tte_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yeisu ikaisulu kabo saugana boda igitaili katena ikamkamnayagili na ali tokasiebwao iwoisili. ");
INSERT INTO tte_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Saugana yanuwa ilolau ana tobenaliyao silaoma koina siba, “Yanuwa kana mwayaga iyai yo tabe kikiunamo boniyai ilaoma. Boda kuyawasali silau yanuwane kolili na kali sigimwala.” ");
INSERT INTO tte_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yeisu iba, “Nige sowasowana tayawasali silau, komiu kan kwaolegili na sikekan.” ");
INSERT INTO tte_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Siwalo koina, “Beledi valigigimo yo iye labuimo kolimai, nabesi.” ");
INSERT INTO tte_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Iba, “Wakalailima koliyau.” ");
INSERT INTO tte_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yo iwalo boda simiyasio kawasi pwatana mena kabo beledi valigigi yo iye labui ikalaili, manna isae bulibuli mena na iwalo-muloloili Yaubada koina. Kabo beledi ikivi. Imwawasi beledi yo iye iwolegili ana tobenaliyao kolili kabo siwolegili boda kolili. ");
INSERT INTO tte_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Boda sikekan yo diyaliyao sisu kaiwena kan ilalakisosi, kabo tobenaliyao kantele sitano-gogonagili, kodo tuwelo. ");
INSERT INTO tte_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Siya tokekan tomo kali baibaiwa paibi tausan yo sinesineo yo melumeluwo kali baibaiwa nige siyayasilili. ");
INSERT INTO tte_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kabo Yeisu iwalo ana tobenaliyao simwalisae waga mena yo sibaguna silopanaisi dedei yabo mena. Na iya boda paibi tausan iyawasali silau. ");
INSERT INTO tte_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Iyawasali silau imwawasi, kabo iutusae koya mena na ikawanoi. Ilolau molosi na ibomamo imiyamiya. ");
INSERT INTO tte_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Na waga iya kana mwayaga iyai yanuwane koina, kalita iyokoyoko yo bagolu ilalaki na waga italutalusugu, kaiwena yaumai ilaolaoma manli mena. ");
INSERT INTO tte_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Malala kikiuna tili koloki yo sikisi koloki luwaluwalili mena, kabo Yeisu ilau kolili, kalita pwatana mena. ");
INSERT INTO tte_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ana tobenaliyao sigitai ilalaoma kalita pwatana mena kabo simatausi lalakina yo siwui siba, “Kalukaluwa bwaine.” ");
INSERT INTO tte_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kabo Yeisu iwalo kolili iba, “Katemiyao sipatu. Koyau, tabu kwamamatausi.” ");
INSERT INTO tte_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita iba, “Guyau, tem yawasosi kowa, kuwalo na yalaowa koliwo kalita pwatana mena.” ");
INSERT INTO tte_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Iba, “Kulaoma.” Kabo Pita iutu-kaisulu yo ilalau kalita pwatana mena Yeisu koina. ");
INSERT INTO tte_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Na saugana yaumai igitai imatausi yo iyatubu isalili, kabo iyoga, “Guyau. Kuleboiyau.” ");
INSERT INTO tte_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sauganane koina Yeisu nimana iyagayani yo ikabikalatan. Iba, “Am meli ikikiu, tawae kaiwena kunuwa-labulabui?” ");
INSERT INTO tte_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Simwalisae waga mena kabo yaumai ilopei yo idaumwali. ");
INSERT INTO tte_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Siya simiyamiya waga mena sipwalou koina siba, “Yawasosi, kowa Yaubada Natuna.” ");
INSERT INTO tte_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Sikalau-panaisi kalitane kabo siulisi yanuwa Genasaleta. ");
INSERT INTO tte_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tomo sigitai kabo sikilala iya Yeisu kabo wasa siyawasa itakikili dedeinane koina. Kabo tokasiebwa meuloili sikalailima. ");
INSERT INTO tte_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Sikawanoi koina siba, “Kutalam na tokasiebwao kam kaleko sopana sikabitonan.” Na siya meuloili Yeisu kana kaleko sopana sikabitonan sinamwanamwa. ");
INSERT INTO tte_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Palisi yo loina kana toyakayakataiyao tupwali silaomaya Yelusalema yo sineli Yeisu koina, ");
INSERT INTO tte_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Siba, “Tawae kaiwena am tobenaliyao loina bwaite tautaubalao bagubagunali siyakenayagimai silikwai? Kaiwena saugana tem sikekan nimali nige sidedeuli. Mumugamai kana lau nige simumuliya.” ");
INSERT INTO tte_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yeisu iba, “Tawae kaiwena mumugamiu koina Yaubada ana loina kwalikwai? ");
INSERT INTO tte_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kaiwena Yaubada iwaloba, ‘Tamam yo sinam kuyakasisiyagili’ yo tabe iba, ‘Yaiya tamana yo sinana ikawa-naenae-yagili kani siunuyamate.’ ");
INSERT INTO tte_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Tem tomo yabo ginauli yabo imiyamiya koina tamana yo sinana kali sagu kaiwena inamwanamwa tem iwolena kolili yo ana olenane koina Buki Tabu ana walo imuliya. Na tem inuwaili yo iwalo nige sowasowana iwolena kolili kaiwena gogone iyakasisi-yanako Yaubada kaiwena komiu tomone ana nuwaine wakawa-namwanamwa-yani. Na bwaite besiele Yaubada ana loina, yakato sinana yo tamana iyakasisi-yagili yo isaguili, komiu kwasoke-gabaen na ami yakayakatai koina wagolugolulau. ");
INSERT INTO tte_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Tomwakomwakota komiu. Sauga beyabeyana koina palopita Aiseya iwalo-masala kaiwemiu iwaloba, ");
INSERT INTO tte_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Yaubada iba, Tomo bwaitete sopali mena siyakasisiyagau na kateli simiya-kelamamalawe koliyau. ");
INSERT INTO tte_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ali tapwalolo koliyau besiele ginauli bwagabwaga, tomo sibomamo ali nuwatu mena siyakayakatai.’” ");
INSERT INTO tte_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yeisu boda iyoga-gogonagili silaoma koina, kabo iwaloba, “Walo bwaite kwabenalan kabo nuwamiu simayale. ");
INSERT INTO tte_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tawae ilusae tomo gamwana mena nige sowasowana ikabiyabiki na tawae gamwana mena iyawatagili sowasowana tomone ikabiyabiki.” ");
INSERT INTO tte_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tobenali silaoma koina na sineli siba, “Tabu ukakatai Palisi nuwaliyao sipolowe am walone kaiwena?” ");
INSERT INTO tte_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yeisu kainali iyamaisa iba, “Kawasi naenaeli meuloili bwaite Tamagu bulibuli mena nige ikukumai kani me lamli isulu-gabaegili. ");
INSERT INTO tte_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Siya nige tawae yabo kaiwena siya tobagunane besiele man gibugibuli. Tem tomangibugibu na tomangibugibu yabo iyogan kani yoli labuine sibeku toyawa gula mena.” ");
INSERT INTO tte_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kabo Pita iwaloba, “Am walo kobwaibwaili kabiyabiki kaiwena ukwabi-yamayale kolimai.” ");
INSERT INTO tte_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yeisu me ana munamunai iwaloba, “Yawasosi ami katai iyoviya. ");
INSERT INTO tte_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Gubesi, nige wakakatai yakato tawae gamwala mena ilusae ilau diyala mena imwawasi ilalau mosomoso koina? ");
INSERT INTO tte_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Na tawae katela mena isaema gamwala mena iyawatagili kani iya ikabiyabikila. ");
INSERT INTO tte_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kaiwena ginauli naenaena silaoma katela mena siya besiele, nuwatu naenaena, tomo kana unuyamate, ganaganawali, kewali, mwakota, kawanaenae. ");
INSERT INTO tte_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Siya bwaite ginauliline kani sikabi-yabikila. Na tem menima bikibikila kan takalai takan nige sowana ikabi-yabikila.” ");
INSERT INTO tte_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yeisu yanuwane ilogabaeni, ilau Taiya yo Saidoni dedeili mena. ");
INSERT INTO tte_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kenani sinena imiyamiyaya dedei bwaine koina, iya nige Isileli sinena besi, kabo ilaoma Yeisu koina, iyogayoga, iwaloba, “Guyau, Deibida tubuna ukwate-kamkamna-yagau. Yaluyaluwa biki imiyamiya natugu sinena koina na sauga meuloina isibasiba-yanae.” ");
INSERT INTO tte_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yeisu kainana nige iyayamaisa, nige walo yabo iwawaloweni. Ana tobenaliyao silaoma sikawanoi koina siwaloba, “Sinene kutawoi kaiwena iyamuli-kusulila yo iyoga-samasamalulu.” ");
INSERT INTO tte_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kabo Yeisu iwalo iba, “Tamagu iyawasayau yalaoma boda Isileli ali sipi kwalakwalaleleli kaiweli.” ");
INSERT INTO tte_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kabo muli mena sinene ilaoma yo tutulina italu-sakonayan manna mena iba, “Guyau, kusaguiyau.” ");
INSERT INTO tte_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kainana iyamaisa iba, “Nuwana nige idududulai tem yasaguiwo, kaiwena kowa nige Isileli sinena besi. Nige sowana melumeluwo kali takalai yo taolena ali bwauwa kolili.” ");
INSERT INTO tte_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Sinene iwaloba, “O, besiele Guyau, na iyamo kan mumuli bwaite ibeku tanuwagana ana teibeli yaulina mena ana bwauwa sikanli.” ");
INSERT INTO tte_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kabo Yeisu iba, “Sine, am meli ilalakisosi. Kani yapaisowai besiele am nuwatu.” Kabo sauganane koina natuna inamwanamwa. ");
INSERT INTO tte_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yeisu yanuwane ilogabaen, iyonayona ilalau kalita Galili dedeina mena. Kabo ilusae ilau yo ikawasae koya mena imiyasio. ");
INSERT INTO tte_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kabo boda lalakina silaoma koina yo tokasiebwa sibaibaiwa sikalailima, tolosigesige, tomangibugibu, siya nima belubeluli, siya memenali sipolowe (nige sowasowana siedeedede), tabe tokasiebwa tupwaliyao yoi, yo sipeili Yeisu manna mena kabo iwoisili. ");
INSERT INTO tte_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tomo meuloili kateli sipitali kaiwena sigitai siya memenali sipolowe siedeedede namwanamwa yo siya nimali naenaeli sinamwanamwa, yo tolosigesige sinamwanamwa silokeikeile yo tabe tomangibugibu manli silala. Kabo tomo meuloili Isileli ali Yaubada sitobalan. ");
INSERT INTO tte_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yeisu ana tobenaliyao iyoganli silaoma koina kabo iwaloba, “Bodane bwaite yakate-kamkamna-yagili kaiwena kaliyate yaiyona mekalakavao tamiyamiya, na siya nige kali ipapagan. Nige nuwanuwagu bwaite meguliyamli na tayawasa-yapileyoili, kisi silalau siwesali kamwasa mena sibeku.” ");
INSERT INTO tte_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ana tobenaliyao siwalo koina, siwaloba, “Bwaite paepaeli bwagabwagaya yanuwa kana mwayaga iyai, toweya koina kani kan lalakina kakalaiya na bodane tayakanli?” ");
INSERT INTO tte_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yeisu ineli iba, “Beledi isa kolimiu?” Siwaloba, “Seben yo tabe iye kikiuli isamo.” ");
INSERT INTO tte_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Iwalo boda simiyasio, ");
INSERT INTO tte_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","kabo beledi seben ikalaili mekanakava iye yo iwalo-muloloili. Imwawasi ikivili yo iwolegili ana tobenaliyao kolili kabo siyauyagili bodane kolili. ");
INSERT INTO tte_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Meuloili sikekan yo diyaliyao sisu kaiwena kali ilalakisosi. Kabo muli mena tobenali kantele sitano-gogonagili kodo seben sipowon. ");
INSERT INTO tte_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Siya sikekan tatao kali baibaiwa powa tausani, na sinesineo yo melumelu kali baibaiwa nige siyayasilili. ");
INSERT INTO tte_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yeisu boda iyawasali silau kabo imwalisae waga mena ilau Magadani dedeina mena. ");
INSERT INTO tte_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Palisi yo Sadusi tupwaliyao silaoma Yeisu koina, nuwanuwali Yeisu sitonan kabo siba, “Ginauli kaba nuwapwanopwano yabo uginauli mesabana kakawa-yawasosi am kaiwe ilaoma Yaubada koina.” ");
INSERT INTO tte_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Na Yeisu kainali iyamaisa iwaloba, “Tem dabwelo ana sauga sugu koina yanuwa ilobalabalagiya kwawalo, kwaba, ‘Bwaliga daumwali yo masa.’ ");
INSERT INTO tte_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na tem malala na yanuwa imalaganu kabo kwawaloba, ‘Kani galewa italu.’ Sowasowamiu tasi namwanamwana yo tasi naenaena kali kilakilala wakilalali na sauga bwaite Yaubada ipeili Mesaiya ana kilakilala na nige sowasowamiu wakilalali. ");
INSERT INTO tte_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yaso naenaeli komiu, nige kwamemeli Yaubada koina, kabo nuwanuwamiu kilakilala yaginauli kaiwemiu, na kani nige kilakilala yabo yayakenayagimiu, bwaimwanamo palopita Yona kana kilakilala kani wagitai.” Kabo Yeisu ilogabaegili yo ilau. ");
INSERT INTO tte_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Saugana kalita silolopanaisi tobenaliyao nuwali imwatain nige beledi yabo sikakalai. ");
INSERT INTO tte_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yeisu iwalo kolili iba, “Manimiyao silala, wagitekalatagimiu Palisi yo Sadusi ali yisti kaiwena.” ");
INSERT INTO tte_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yo sibomamo siedeedede Yeisu ana walo kaiwena siba, “Iwalowalo besiele kaiwena nige beledi yabo takakalaiyama.” ");
INSERT INTO tte_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yeisu ali walo ikatai kabo iwalo kolili, “Ami meli nige ilalalaki yo ami katai kaiwegu iyoviya. Tawae kaiwena kwabomamo beledi kaiwena kwaedeedede? ");
INSERT INTO tte_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Na nige nuwamiu simamayale? Tabu kwanunuwatu-kalatan tauna kona beledi valigigi yakivikivi boda paibi tausani kaiweli? Tabu kwanunuwatu-kalatan sauganane koina tomo diyali sisu yo kantele beledi tupwatupwana kwatano-gogonagili ilalaki? ");
INSERT INTO tte_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tabu kwanunuwatu-kalatan beledi seben na yakivikivi tomo powa tausani kaiweli? Tabu kwanunuwatu-kalatan sauganane koina tomo diyali sisu yo kantele beledi tupwatupwana kwatano-gogonagili ilalaki? Ginauli kaba nuwapwanopwano labuine yaginauli kaiweli sowasowagu yaginauli kaiwemiu tabe, koinaele tabu kwanuwanuwatui beledi kaiwena. ");
INSERT INTO tte_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Tawae kaiwena nuwamiu nige simamayale? Nige yawawalo kolimiu beledi kaiwena. Wagitekalatagimiu Palisi yo Sadusi ali yisti kaiwena.” ");
INSERT INTO tte_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kabo tobenaliyao sikatai nige iwawalo sigitekalatan bwaite beledi kana yisti kaiwena, na iwalo sigitekalatan Palisi yo Sadusi ali yakayakatai kaiwena. ");
INSERT INTO tte_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yeisu ilau Sisaliya Pilipai ana dedei koina kabo ana tobenaliyao ineliyagili ibomayoi kaiwena iba, “Tomo siwalo yakato Tomo Natuna iya yaiya?” ");
INSERT INTO tte_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kainana siyamaisa besiele, “Tupwali siba Yoni Toyababitaiso, tupwali siba Ilaitiya, tupwali Yelemaiya o nuwana palopita yabo.” ");
INSERT INTO tte_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kabo iwalo kolili, “Na komiu, kwawalo yakato yau yaiya?” ");
INSERT INTO tte_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita kainana iyamaisa iba, “Kowa Mesaiya, Yaubada meyawasina Natuna.” ");
INSERT INTO tte_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yeisu iba, “Yaubada imuloloiwo, Saimon Yona natuna. Kaiwena tomo yanuwa yaulina nuwatune nige siyeyeyawa, na Tamagu bulibuli mena iyeyawa. ");
INSERT INTO tte_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na yawalo koliwo, esam Pita yaeyawa, kabo vekune bwaite pwatana mena yagu boda ekalesiya yakabi yo Seitani ana boda nige sowasowali sikaiwe-gabaen. ");
INSERT INTO tte_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kani Yaubada ana kaba loina kana ki yaeyawa koliwo na tawae bwaite ukwausi yanuwa yaulina mena, kani Yaubada ikausi bulibuli mena yo tawae bwaite kusoke yanuwa yaulina mena kani Yaubada isoke bulibuli mena.” ");
INSERT INTO tte_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kabo Yeisu iwalo ana tobenaliyao kolili, “Tabu tomo yabo ana wasa kwaolena yakato yau Mesaiya.” ");
INSERT INTO tte_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Sauganane koina Yeisu iyatubu iedeedede ana tobenaliyao kolili nuwaliyao ikabi-yamayaleli iba, “Naga yalau Yelusalema kabo tobagunao yo topwaoli lalakili yo loina kana toyakayakataiyao kani siyakamkamnayau yo siunuyamateyau kabo kaliyate yaiyonana koina yatoloyoi.” ");
INSERT INTO tte_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yo Pita Yeisu iyoga-suwalan kabo iyatubu iyokoiyan iba, “Guyau, ginauline kani nige siyayawatagili koliwo.” ");
INSERT INTO tte_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yeisu itagelakeile yo iwalo Pita koina, “Kulowasi koliyau, Seitani. Kowa kutonan nuwanuwam ukwabi-yabeku-yau, kaiwena am nuwatu nige ilalau Yaubada ana kamwasa koina, na ilauya tomo ali nuwatu koina.” ");
INSERT INTO tte_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kabo Yeisu iwalo ana tobenaliyao kolili, “Tem yaiya nuwanuwana ilaoma mekaukava, iboma ana namwanamwa isikotanan, kana kelose ikalai ikewai na imuliya koliyau. ");
INSERT INTO tte_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kaiwena yaiya tem nuwanuwana iboma yawasina ileboi, kani igabaen, na yaiya yawasina igabaen yau kaiwegu kani yawasina ilobaiyoi. ");
INSERT INTO tte_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tawae kana namwanamwa tem tomo yabo yanuwa yaulina meuloina ikalai iloinayan, na yawasina yawasosi igabaen? Nige ginauli yabo sowasowana ikalai yo yawasina iyamaisa-yapileyoi. ");
INSERT INTO tte_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kaiwena Tomo Natuna ilalaoma Tamana ana wasawasa koina yo mekanakavao ana aneloseyao kabo kani tomo meuloili iyamaisali besiele ali paisowa. ");
INSERT INTO tte_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Walo yawasosi yawalo kolimiu, kani tomo tupwali luwamiu mena nige siboboita kanasiga Tomo Natuna sigitai iyawatagilima besiele kin.” ");
INSERT INTO tte_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kaliyate sikis (6) imwawasi, kabo Yeisu tobenaliyao yaiyona iyoga-suwalagili Pita, Yemesa yo kanakava Yoni, silau sikawasae koya lalakina koina. ");
INSERT INTO tte_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yeisu sigitagitai kabo yona kana koleya uloina iyawatagili manli mena. Manna kana koleya ibui besiele dabwelo manli isakosakona yo tabe kana kaleko mayamayalena yo ipigapigabu. ");
INSERT INTO tte_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kabo sigitai Mosese yo Ilaitiya sitolo-masala mekalikava Yeisu siedeedede. ");
INSERT INTO tte_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita iwalo Yeisu koina iba, “Guyau, inamwanamwa kitaele bwaite koina. Tem kutalam kabo gwau yaiyona yakabili, yabo kowa kaiwem, yabo Mosese kaiwena yo yabo Ilaitiya kaiwena.” ");
INSERT INTO tte_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita iyaelemo iedeedede kabo yaloyaloi pigapigabuna yabo ilobima iyakaboboili kabo kaina yabo iyawatagili yaloyaloine kalona mena iba, “Bwaite Natugu yamulolo yawasosi koina yo yayaliyaya lalakina iya kaiwena, kwabenali koina.” ");
INSERT INTO tte_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Saugana tobenali yaiyonane kainane sibenalan, kateli sipitali yo simatausi lalakina kabo sitalu-pwaopwaom bwatano mena manli siwadam. ");
INSERT INTO tte_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yeisu ilaoma ikabilau kolili yo iba, “Kwatolo, tabu kwamamatausi.” ");
INSERT INTO tte_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Manli siyalalali nige tomo yabo sigigitai Yeisu ibomamo. ");
INSERT INTO tte_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Sisasalulu-taluma koya mena kabo Yeisu iwalo kolili iba, “Tabu tomo yabo ana wasa kwaolena tawae wagitai koya bwaite koina kanasiga Tomo Natuna itoloyoi boita mena.” ");
INSERT INTO tte_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kabo tobenali sineli Yeisu koina siba, “Tawae kaiwena loina kana toyakayakatai siwalo yakato Ilaitiya ilaoma baguna kabo muli mena kani Mesaiya ilaoma?” ");
INSERT INTO tte_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yeisu kainali iyamaisa iba, “Walo yawasosi Ilaitiya ilaoma baguna kabo ginauli meuloina iyadudulaili, ");
INSERT INTO tte_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","na yawalo kolimiu, Ilaitiya ilaomako, na nige sikikilala, kabo tawae sinuwanuwatui siginauli koina. Besiele tabe yau Tomo Natuna kani siyakamkamnayau.” ");
INSERT INTO tte_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kabo tobenaliyao nuwali imayale yakato Ilaitiya iya mwa Yoni Toyababitaiso bwaite kaiwena Yeisu iedeedede. ");
INSERT INTO tte_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sisalulu-taluma siyawatagili yanuwa mena sipileyoi boda kolili kabo tomo yabo ilaoma Yeisu koina tutulina italu-sakonayan, ");
INSERT INTO tte_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","yo iba, “Guyau, natugu ukwate-kamkamna-yani, sauga meuloina ikikiwasi yo ikamkamna lalakina, mwa koina sauga tupwana ibeku mayau wedowedolina koina o nuwana yalubwasi koina. ");
INSERT INTO tte_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Yalawanama am tobenaliyao kolili na nige sowasowali siwoisi.” ");
INSERT INTO tte_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kabo Yeisu iba, “Komiu nige ami meli ipapagan, toyauyaule komiu. Yogu ikwatakwata-yagimiu. Na isa bolime komiu te yau tamiyamiya na manimiyao nige silalala? Gamene wakalaiyama koliyau.” ");
INSERT INTO tte_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yeisu yaluyaluwa biki gamene koina iyokoiyan kabo iyawatagili yo sauganane koina gamene inamwanamwa. ");
INSERT INTO tte_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kabo tobenaliyao silaoma Yeisu koina siyoga-suwalan yo sineli, siba, “Tawae kaiwena kai nige sowasowamai yaluyaluwa bikine katao-yawatagilan?” ");
INSERT INTO tte_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yeisu iba, “Kaiwena nige ami meli. Yawalo yawasosi kolimiu, tem ami meli imiyamiya, bwagana meline kikitoitoina, sowasowana kwawalo koyane koina ana kaba miya ilogabaen ilau dedei yabo koina, kabo kani iginauli besiele. Tem ami meli imiyamiya nige sowasowana ginauli yabo ipolowe kolimiu. ");
INSERT INTO tte_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Yaluyaluwa bikine besiele bwaite nige sowasowana tatao-yawatagilagili bwaimwanamo tem takawanoi yo guliyam takalakisiye-yan kawanoine kaiwena.” ");
INSERT INTO tte_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Saugana tobenaliyao silaoma simiyagogo Galili koina iwalo kolili iba, “Kikiunamo Tomo Natuna kani sikalomagigilan yo sitalamwan tomo naenaeli nimali mena, ");
INSERT INTO tte_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","kabo kani siunuyamate yo kaliyate yaiyonana koina kabo itoloyoi.” Mwa tobenaliyao nuwali inae lalakina. ");
INSERT INTO tte_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Saugana Yeisu me ana tobenaliyao silaoma Kapeneomi, takesi kana totano Nume Tabu kaiwena silaoma Pita sineliyan, siba, “Am toyakayakatai takesi iyamayamaisa Nume Tabu kaiwena o nigele?” ");
INSERT INTO tte_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita iba, “O, besiele.” Saugana ilusae nume mena baguna Yeisu ineli Pita koina iba, “Saimoni Pita, gubesi am nuwatu? Yanuwa yaulina kali kinyao takesi sikalakalaine ali susuyaomo kolili o nuwana tomo uloili kolili?” ");
INSERT INTO tte_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita iwaloba, “Tomo uloili kolili.” Yeisu iwaloba, “Ee kabo kin natunao nige sowasowana takesi siyamaisa. Besiele tabe yau tem tabu takesi yayamaisa Tamagu ana Nume kaiwena. ");
INSERT INTO tte_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Na tabu siya takesi kana totano Nume Tabu kaiwena taula-munamunaili, kabo kulau kalita mena yo kam yaoyaoni ugabae-lobiyen, iye bwaite kusawin-bagunayan ukwalai, gamwana kutabesae kabo kani mane kulobai, kana lalaki sowasowana ala takesi. Ukwalai kulau ala takesi kuyamaisa, kowa te yau kaiwela.” ");
INSERT INTO tte_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Sauganane koina tobenaliyao silaoma Yeisu koina sineli siba, “Yaiya esana ilalaki Yaubada ana kaba loina koina?” ");
INSERT INTO tte_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kabo Yeisu melumelu kikiuna yabo iyoganyama iyatolo manli mena, ");
INSERT INTO tte_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","yo iba, “Walo yawasosi yawalo kolimiu, tem mumugamiu kwabui yo melumelu kikiuna mumugana wakalai sowasowana kwalusae Yaubada ana kaba loina koina. Tem nigele, nige sowana kwalusae. ");
INSERT INTO tte_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yaiya tem inuwalobi besiele melumelu bwaite, ee iya esana ilalaki Yaubada ana kaba loina koina. ");
INSERT INTO tte_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yo yaiya esagu mena melumelu yabo besiele bwaite iyogan yo isagui, iya iyoganyau yo isaguiyau.” ");
INSERT INTO tte_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yeisu iba, “Tem tomo yabo melumeluwone iwoya-pwanolili, bwaite siya kagu tomeliwo, kana maisa Yaubada koina ipolowesosi kabo tem tomone veku polopolowena galogalona mena sipan yo sigabaen kalita mena ana boita kana polowe. ");
INSERT INTO tte_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Oo, katekamkamnamiu, yanuwa yaulina inae kaiwena ginauli bwaite tomo siwoya-pwanolili sibaibaiwa. Walo yawasosi, ginauliline kani siyawatagili na yaiya toweya pwanoline koina iyawayawatagili naga kani maisana lalakina ilobai. ");
INSERT INTO tte_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Tem nimam o nuwana kaem iyalopwanowo kutom-gabaen. Inamwanamwa tem nima kaikaigedam o nuwana kae kaikaigedam yawasim namwanamwana kulobai. Tabu kulau mayau wedowedolina koina menima labulabuim o nuwana mekae labulabuim. ");
INSERT INTO tte_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tabe tem manim iyalopwanowo ukasigabaen. Inamwanamwa tem man kaikaigedam Yaubada ana kaba loina koina kulusae. Tabu kutatalam sigabaegiwo mayau wedowedolina koina meman labulabuim.” ");
INSERT INTO tte_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yeisu iba, “Wagite-kalatagimiu tabu melumelu kikiuna yabo kwapepei-yatalu. Yawalo kolimiu, melumelu kali togitekalatan, siya aneloseyao, sauga meuloina simiyamiya bulibuli mena yo Yaubada kana koleya sigitagitai. ");
INSERT INTO tte_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yau Tomo Natuna yalaoma na kwalakwalaleleli yaleboili. ");
INSERT INTO tte_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Gubesi ami nuwatu? Tomo yabo ana sipi meuloili kali baibaiwa wan andeledi. Kabo yabo luwali mena ilokwalalele, kani gubesi tomone ana nuwanuwatu ana sipine kaiwena? Kani yoli naenti naen (99) ilogabaegili simiyamiya koya mena na ilau tem sipi kwalakwalalelenane iloyai. ");
INSERT INTO tte_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yawalo yawasosi kolimiu, saugana tem ilobai ana yaliyaya ilalakisosi sipi kaigedane kaiwena. Ana yaliyaya nige ilalalakisosi naenti naen kaiweli, siya nige sikwakwalalele. ");
INSERT INTO tte_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ee besiele tabe, Tamamiu bulibuli mena nige nuwanuwana yakato siya kikiuliyaone yabo ikwalalele.” ");
INSERT INTO tte_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Tem kamkava, iya am tali toekalesiya, mumuga naenaena ipaisowai koliwo, kuboma kulau koina, yo ana pwanoli kuwalo-masalan koina. Tem kainam ibenalan kamkava kuyoga-yavivila-yama, wakawa-elieliyam yoi. ");
INSERT INTO tte_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Na tem kainam nige ibebenalan, tomo kaigeda o labui mekamkavao kwalau koina kabo besiele Mosese ana loina tomo labui o yaiyona siwaloba, ‘O, kagitai.’ Muli mena kabo kani yakewane sikawa-yawasosiyan. ");
INSERT INTO tte_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tem siya kainali nige ibebenalan, kuwalo-masala toekalesiya kolili. Tem toekalesiya kainali nige ibebenalan komiu toekalesiyao kwaloina yakato iya nige ami boda yabo na iya besiele tokewali yabo. ");
INSERT INTO tte_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yawalo yawasosi kolimiu, tawae komiu toekalesiyao kwasikotanan yanuwa yaulina mena, kani Yaubada isikotanan bulibuli mena yo tawae kwanuwatu-pwaiki yanuwa yaulina mena kani Yaubada inuwatu-pwaiki bulibuli mena. ");
INSERT INTO tte_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Yawalo yoi kolimiu, tem komiu yomiu labui ami nuwatu kaigeda yo wakawanoi ginauli yabo kaiwena, kani Tamagu bulibuli mena iginauli besiele kaiwemiu. ");
INSERT INTO tte_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kaiwena tem labui o yaiyona esagu mena kwamiyagogo yau ele mekamikava.” ");
INSERT INTO tte_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kabo Pita ilaoma Yeisu koina yo ineli iba, “Guyau, tem kaukava mumugana naenaena iginauli koliyau ana pwanoli yanuwatu-pwaiki meisa? Nuwana me seben?” ");
INSERT INTO tte_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yeisu iwalo koina iba, “Tabu kununuwatu-pwaiki meseben, na kunuwatu-pwaiki ibaibaiwa yo sauga meuloina. ");
INSERT INTO tte_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Na Yaubada ana kaba loina mumugana besiele bwaite. Kin yabo nuwanuwana ana topaisowa kali yagayaga iloyaili na tem siyamaisa koina. ");
INSERT INTO tte_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Saugana iyatubu topaisowa yabo iyoganama iya kana yagayaga kana lalaki besiele kina kali baibaiwa miliyon kaigeda. ");
INSERT INTO tte_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nige sowasowana iyamaisa kabo kinne iwalo topaisowane ana gogo meuloina yo iya yo wainena menatuliyao sigimwala-yagili siyamala topaisowa panpanili, yakato topaisowane mane ikalai yo kana yagayagane iyamaisa. ");
INSERT INTO tte_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Topaisowane imatausi lalakina kaiwena genuwana siyamala topaisowa panpanli kabo tutulina italu-sakonayan kin manna mena yo ikawanoi-samasamalulu iba, ‘Ukwalakisiye, kunuwatu-pwaikiyau kusanasana naga kabo kani meuloina yayamaisa.’ ");
INSERT INTO tte_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kin ana topaisowa ikatekamkamna-yani yo inuwatu-pwaiki kabo kana yagayaga meuloina isoke-gabaen. ");
INSERT INTO tte_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Topaisowane iyawatagili kin ilogabaen ilau kabo ana eliyam, iya ana tali topaisowa yabo, ilobai yo tomone bwaite koina kana yagayaga imiyamiya koina kana lalaki besiele kina isamo. Topaisowane ana eliyam ikabi-kalatan galogalona mena iba, ‘Kam yagayaga kuyamaisa koliyau.’ ");
INSERT INTO tte_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kabo ana eliyam tutulina italu-sakonayan yo ikawanoi-samasamalulu, iba, ‘Ukwalakisiye, kunuwatu-pwaikiyau kusanasana naga kabo kani yayamaisa.’ ");
INSERT INTO tte_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Na isikote kabo iwalo sipei-luseyan deli mena kanasiga tem kana yagayagane iyamaisa. ");
INSERT INTO tte_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tomo tupwaliyao topaisowane sigitai mumuga naenaena iginauli ana eliyam koina nuwali sinae lalakina kabo silau kinne koina yo ginauli meuloina siwalo-masalan. ");
INSERT INTO tte_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kinne topaisowane iyoganama iba, ‘Topaisowa naenaena kowa, kam yagayaga meuloina koliyau yasoke-gabaenako, besiele am kawanoi koliyau. ");
INSERT INTO tte_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na tem kowa tabe me am katekamkamna kunuwatu-pwaiki am eliyam besiele yau yakatekamkamna-yagiwo yanuwatu-pwaikiwo inamwanamwa. Na nige ugiginauli besiele kaiwena am eliyam nige kununuwatu-pwaiki.’ ");
INSERT INTO tte_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kin imunamunai kabo topaisowane iyawasa ilau deli togitekalatan kolili kabo sipei-luseyan deli mena kanasiga tem kana yagayaga meuloina iyamaisa.” ");
INSERT INTO tte_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yeisu ana walo kobwaibwaili iyemwawasi kabo iba, “Tamagu bulibuli mena kani iginauli bwaite besiele kolimiu tem kamikavao ali pwanoli nige kwanunuwatu-pwaikili katemiu mena.” ");
INSERT INTO tte_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Saugana Yeisu walone iyemwawasi kabo Galili dedeina ilogabaen yo ilau dedei Yudiya waila Yolidan papali yabo mena. ");
INSERT INTO tte_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Boda lalakina siyamuli-kusuli yo bwaine koina iwoisili. ");
INSERT INTO tte_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Palisi tupwali silaoma koina yakato sitonan, kabo sineli, siba, “Gubesi kala loina? Sowasowana tomo wainena iinawaseyan, tem nige yaina ipapagan?” ");
INSERT INTO tte_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Kainali iyamaisa iba, “Nuwana Buki Tabu nige kwayayasili-namwanamwai? Kaiwena iba, ‘Kaba yatubu koina Toyamayale iyamayaleli tau yo sine.’ ");
INSERT INTO tte_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Besiele tabe iba, ‘Bwaite kaiwena tau tamana yo sinana ilogabaegili ilau mewainena simiya-kaigeda, kabo yoli labuine siyamala kwapi kaigeda.’ ");
INSERT INTO tte_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Koinaele siya nige besiele labui, na siya besiele kaigeda. Yaubada itubwe-kaigedailiko, na tabu tomo yabo ipepei-suwalagili.” ");
INSERT INTO tte_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kabo Palisiyao sineli siba, “Gubesina Mosese iloina yakato tau inawase kana pepa iwolena wainena koina kabo muli mena itawoi ilau?” ");
INSERT INTO tte_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yeisu iba, “Tubumiyao mumugali sinae, kateli sikololo yo komiu besiele, kabo bwaite kaiwena Mosese italamwan wainemiyao kwainawase-yagili. Na kaba yatubu koina, Adama ana sauga mena, nige loinane besiele bwaite. ");
INSERT INTO tte_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Na yawalo kolimiu, tem tokasole sine na iganawali, sowasowana wainena tau sinene iinawaseyan. Na tem sinene nige igaganawali nige sowana tau wainena sinene iinawaseyan yo ikasole-panaisi sine uloina koina. Tem iginauli besiele bwaine ganawali.” ");
INSERT INTO tte_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ana tobenaliyao siwalo koina siba, “Tem am loina kasole kaiwena bwaine besiele nuwana ilonamwayan tem kilakai o nuwana vesala simiya kwasikwasiki, tabu sikakasole, awa?” ");
INSERT INTO tte_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yeisu iwalo kolili iba, “Tomo tupwaliyaomo sowasowali nuwatune bwaite simuliya namwanamwai kaiwena siya Yaubada ana nuwatu simulimuliya. ");
INSERT INTO tte_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kaiwena ali yai uloina uloina simiyamiya mwa koina tomo tupwali nige sikakasole. Kaba gite yabo tomo tupwali sinaliyao sikabili naenaeli. Kaba gite labuina tupwaliyao tatao nigwenigwe sikalai mesabana tabu natuliyao sipapagan. Kaba gite yaiyonana tupwali nige sikakasole kaiwena siboma siyakasisiyagili Yaubada ana kaba loina kaiwena. Yaiya tem sowasowana yagu yakayakatai bwaite ikalai, kabo ikalai.” ");
INSERT INTO tte_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tomo tupwaliyao melumeluwo sikalailima Yeisu koina yakato nimana ipeili pwatali mena yo ikawanoi kaiweli. Na ana tobenaliyao tomo siyokoi-yagili. ");
INSERT INTO tte_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yeisu iba, “Melumeluwo kwatalamwagili silaoma koliyau, tabu kwanunuwaili. Kaiwena siya me ali nuwalobi besiele melumeluwone bwaite nige kaba kausi yabo imiyamiya ali lusae Yaubada ana kaba loina koina.” ");
INSERT INTO tte_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kabo nimana ipei pwatali mena yo ikawanoi kaiweli kabo muli mena yanuwane ilogabaen. ");
INSERT INTO tte_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tomo yabo ilaoma Yeisu koina ineli, “Toyakayakatai, tawae namwanamwana yaginauli na yawasigu miyamiya yaina yakalai?” ");
INSERT INTO tte_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yeisu iwalo koina iwaloba, “Tawae kaiwena namwanamwa kuneliyan koliyau? Kaigedamo yakatai iya Tonamwanamwasosi. Tem nuwanuwam yawasim miyamiya yaina kulobai Yaubada ana loina kuobigaili.” ");
INSERT INTO tte_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tomone ineli yoi iwaloba, “Toisabo loina?” Yeisu iwaloba, “Tabu tomo kuunuyamate, tabu ganawali, tabu kewali, tabu mwakota, ");
INSERT INTO tte_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","tamam yo sinam kuobigaili yo tabe tomo meuloili kumuloloili besiele kuboma kam mulolo.” ");
INSERT INTO tte_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tomone iwalo koina, “Loinane meuloili yaobigailiko. Na tawae yoi kani yaginauli?” ");
INSERT INTO tte_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yeisu iwalo yoi iwaloba, “Tem nuwanuwam namwanamwa yawasosi kulobai, kulau am gogo ugimwala-yagili na manene ukwalai kabo manene kuwolena tobubutumao kolili, kabo am gogo wasawasa imiyamiya bulibuli mena. Na kulaoma kumuliya koliyau.” ");
INSERT INTO tte_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Saugana tomone walone ibenalan, me ana nuwanae yo ilau kaiwena iya ana wasawasa ilalakisosi. ");
INSERT INTO tte_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kabo Yeisu iwalolau ana tobenaliyao kolili, “Yawalo yawasosi kolimiu, towasawasa ali lusae Yaubada ana kaba loina koina ikololo. ");
INSERT INTO tte_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tabe yawalo yoi kolimiu, towasawasa ali lusae Yaubada ana kaba loina koina ikololososi kabo kameli sinalom gulana mena ana lusola.” ");
INSERT INTO tte_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Saugana tobenaliyao walone bwaite sibenalan, kateli sipitali yo sisiliyata, kabo sineli, “Na tem bwaine besiele, yaiya kani sowasowana lebo ilobai?” ");
INSERT INTO tte_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yeisu imankulakulaili yo iwaloba, “Bwagana tomo ali nuwatu yakato ginauliline tupwaliyao sikololososi na Yaubada ginauli meuloili sowasowana iginaulili. Tem Yaubada ana nuwatu besiele towasawasa yabo sowasowana bulibuli ilusae.” ");
INSERT INTO tte_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita iwalo yoi iba, “Ginauli meuloili kai kasikotanagiliko sabi muliya koliwo. Na tawae kani kalobai kaiwemai?” ");
INSERT INTO tte_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yeisu iwalo kolili iba, “Yawalo yawasosi kolimiu, yanuwa yaulina waluwaluna koina saugana Tomo Natuna iyamala kin na ana kaba miya wasawasana koina imiyamiya, komiu bwaite kwamuliya koliyau kani kwamiyasio toloinao ali kaba miya kolili yo susu Isileli tuwelo kani kwayatala-yagili. ");
INSERT INTO tte_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yaiya tem ana nume yo kanakavao yo dunao yo tamana yo sinana yo natunao yo ana bwatano ilogabaegili kaiwegu kani kana mulolo lalakisosina ikalai kewa mena tabe kani yawasina miyamiya yaina ilobai. ");
INSERT INTO tte_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Na sauga bwaite siya sibagubaguna meuloili naga kani simuliya na siya simulimuliya naga kani sibaguna.” ");
INSERT INTO tte_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yeisu iwalo yoi iba, “Yaubada ana kaba loina bwaite besiele. Tomo yabo malala kikiuna iyawatagili ilau nuwanuwana tomo tupwali iloyaili na tem ikawanoi-yagili yakato sipaisowa ana oine tanona koina na kani iyamaisali. ");
INSERT INTO tte_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ilobaili kabo iwalolau kolili iba, ‘Kaliyate kabona kani yayamaisamiu tomo kaigeda kaigeda kana maisa kina kaigeda kaigeda.’ Siya siba, ‘O, inamwanamwa.’ Kabo iyawasali silau na oine tanona sipaisowai. ");
INSERT INTO tte_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Naen koloki koina tomone iyawatagili yoi ilau kabo tomo tupwaliyao igitaili sitotolo-bwagabwaga kaba maketi koina nige ali paisowa. ");
INSERT INTO tte_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Yo iwalolau kolili iba, ‘Komiu tabe besiele kwalau yagu oine tanona kwapaisowai na maisa dudulaina koina kani yayamaisamiu.’ ");
INSERT INTO tte_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kabo sitalam mwa silau oine tanona mena. Tabe kala pwasinasina mena yo tili koloki lolau ivivila yoi ilau tomo iloyaiyoili besiele malala kikiuna yo naen koloki koina. Tomo ilobaili yo iyawasali oine tanona koina. ");
INSERT INTO tte_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Masa kikiuna paibi koloki iyawatagili yoi tomo tupwali ilobaili sitotolo-bwagabwaga kabo ineli iba, ‘Tawae kaiwena kwatotolo-bwagabwaga na kaliyate meuloina kwayavenuwan?’ ");
INSERT INTO tte_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Na kainana siyamaisa siba, ‘Kaiwena nige tomo yabo ikakalaimai paisowa kaiwena.’ Iwalolau kolili iba, ‘Komiu tabe besiele kwalau na yagu oine tanona kwapaisowai.’ ");
INSERT INTO tte_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Dabwelo isuguko kabo tomone, iya tano tanuwagana, iwalolau topaisowa kali togitekalatan koina iba, ‘Topaisowa kuyoganili yo kuyamaisali topaisowa mulimuliyeli kolili yo kanasiga ilau imwawasi topaisowa bagubagunali kolili.’ ");
INSERT INTO tte_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Topaisowa mulimuliyeli, siya sipaisowa yatubu paibi koloki lolau mena, silaoma yo maisali sikalai kana lalaki kina kaigeda. ");
INSERT INTO tte_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yo topaisowa bagubagunali saugana silaoma ali nuwatu sibatoko kani tupwana maisali ilalaki sikalai kaiwena wasane sibenalan yakato topaisowa mulimuliyeli maisali kina kaigeda sikalai sauga kubwakubwana kaiwena. Na iyamo meuloili kina kaigeda kaigeda sikalai. ");
INSERT INTO tte_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Saugana maisali sikalai tano tanuwagana sikawa-naenae-yani, ");
INSERT INTO tte_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Siba, ‘Topaisowa mulimuliyeli sipaisowa sauga kubwakubwana koina, na kai kapaisowa malala kikiuna kanasiga lolau yo dabwelo igabu-yamatemai, ama paisowa ilalaki, na kowa kuyamaisamai siya yo kai toyatoyawa.’ ");
INSERT INTO tte_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yo kainali iyamaisa iwalolau kalikava yabo koina, ‘Eliyam, nige loina naenaena yabo yagiginauli koliwo, kabona kutalam kaliyate meuloina koina kupaisowa maisam kina kaigeda kaiwena. ");
INSERT INTO tte_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Maisam ukwalai na kulau. Yagu nuwatu yakato topaisowa mulimuliyeli yo topaisowa bagubagunali maisamiu toyatoyawa yaeliwa. ");
INSERT INTO tte_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yau sowasowana yaboma yagu nuwatu mena yagu mane yakalai na yaginauli besiele. Nuwana me am lamwapolowe na kaiwena yau tosokekeli.’” ");
INSERT INTO tte_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Bwaite Yeisu ana walo kobwaibwaili iyemwawasi kabo kobwaibwailine kana livasi iwalo-masalan kolili iba, “Koinaele, ana kaba loina koina Yaubada kani tonuwabui meuloili iyamaisali toyatoyawa nuwana siya tonuwabui mulimuliyeli o nuwana siya tonuwabui bagubagunali.” ");
INSERT INTO tte_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Saugana Yeisu ilalau Yelusalema kaiwena ana tobenaliyao yoli tuwelo iyoga-suwalagili kabo iedeedede kolili besiele. ");
INSERT INTO tte_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Iba, “Iyaele talalau Yelusalema kaiwena yo Tomo Natuna kani sikalomagigilan yo sitalamwan topwaoli lalakili yo loina kana toyakayakatai kolili na tem siloinayan iboita. ");
INSERT INTO tte_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Muli mena kani siwolena siya nige Yudiya tomoliyao kolili yo sitalamwan sisapi yo sitalatalawasiyan yo siyakelose. Kaliyate yaiyonane koina kani boita mena itoloyoi.” ");
INSERT INTO tte_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedi wainena me natunao Yemesa yo Yoni silaoma Yeisu koina, kabo sinali ilau Yeisu manna mena yo tutulina italu-sakonayan, yo iba, “Yagu nuwatu yabo kaiwena yalaoma koliwo.” ");
INSERT INTO tte_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yeisu iwalolau koina iba, “Tawae nuwanuwam?” Sinali iba, “Kuwaloyameli koliyau, saugana tem am kaba loina ukwalai natuguwao labui bwaite kani yabo imiyasio ulaulam mena yo yabo imiyasio gegebam mena.” ");
INSERT INTO tte_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yeisu iwalolau Yemesa yo Yoni kolili iba, “Nige wakakatai tawae wakawakawanoiyan. Sowasowamiu kamkamna komwana koina kwanuma bwaine iya kani koina yanunumane?” Siba, “O besiele, sowasowamai.” ");
INSERT INTO tte_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Iwalo yoi kolili iba, “Yawasosi, kani kwanuma kagu komwa koina na nige sowasowagu yagitesipwaimiu yakato ulaulagu mena o nuwana gegebagu mena kwamiyasio. Kaiwena kaba miya bwaite Tamagu ikatububunan siya igitesipwaili kaiweli.” ");
INSERT INTO tte_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Saugana tobenaliyao yoli sanaulu wasa bwaite sibenalan, simunamunai Yemesa yo Yoni kolili. ");
INSERT INTO tte_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kabo Yeisu iyoga-gogonagili iwaloba, “Wakataiyako siya Yaubada nige simemeliyan ali toloinao siloinayagili yo ali tobagunao siwalo kaiwe kolili. ");
INSERT INTO tte_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Na komiu tabu besiele wagiginauli. Na yaiya tem kowa nuwanuwam esam ilalaki ilonamwayagiwo kamkavao kaiweli kuyamala topaisowa. ");
INSERT INTO tte_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tabe yaiya tem kowa nuwanuwam kuyamala tobaguna ilonamwayagiwo am eliyamwao meuloili kaiweli kuyamala esimili-gabuna. ");
INSERT INTO tte_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Besiele yau Tomo Natuna nige yalalaoma yakato kwapaisowa kaiwegu, yalaoma na yapaisowa kaiwemiu yo yawasigu yatalamwan mesabana tomo meuloili yayamaisa-yavivilali.” ");
INSERT INTO tte_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Saugana Yeisu me ana tobenaliyao Yeliko silogabaen boda lalakina siyamuli-kusulili. ");
INSERT INTO tte_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tomangibugibu labui simiyasio kamwasa dedeina mena yo saugana sibenalan Yeisu ilalaoma siyoga siba, “Guyau, Deibida tubuna, ukwatekamkamna-yagimai.” ");
INSERT INTO tte_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Boda siwalo-sikosikoko-wagili yakato simwanou na kabo siya siyoga kaikaiwe siba, “Guyau, Deibida tubuna, ukwatekamkamna-yagimai.” ");
INSERT INTO tte_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kabo Yeisu itolo na iyogalau kolili iba, “Tawae nuwanuwamiu yaginauli kaiwemiu?” ");
INSERT INTO tte_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kainana siyamaisa siba, “Guyau, nuwanuwamai manimai kuyalalali.” ");
INSERT INTO tte_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yeisu ikatekamkamna-yagili kabo ilau kolili, nimana iyagayan, manli ikabitonagili kabo sauganane koina manli silala. Muli mena yoli labuine simuliya koina. ");
INSERT INTO tte_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yeisu me ana tobenaliyao silaomako Yelusalema silokelakubwai yanuwa esana Bedipegi koya Olibe koina kabo tobenali labui iyawasa-bagunayagili, ");
INSERT INTO tte_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Iba, “Kwalau yanuwane koina na manimiu mena donki yabo me natuna kani kwalobaili bwaine sipan-kalatagili. Kwalivasili na kwalawagilima koliyau. ");
INSERT INTO tte_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tem tomo yabo ineli kaiweli kolimiu kwaba, ‘Guyau nuwanuwana.’ Saugana ami walo ibenalan kani italam wakalailima.” ");
INSERT INTO tte_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ginauli bwaite iyawatagili na tawae palopita ana walo Buki Tabu mena iyamala yawasosi. ");
INSERT INTO tte_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Kaiwena sauga beyabeyana koina ipalopisai iba, “Saiyoni tomoliyao ali wasa kwaolegili, ‘Wagitai ami kin ilalaoma kolimiu mumugana bigana yo imwalisae imiyasio donki koina bwaimwana donki natuna.’” ");
INSERT INTO tte_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tobenaliyaone siginauli besiele Yeisu ana walo kolili. ");
INSERT INTO tte_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Donki me natuna sikalailima, ali kaleko siyeseli pwatali mena yo Yeisu imwalisae yabo koina. ");
INSERT INTO tte_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Boda lalakina kali kwama siyeseli kamwasa mena na tupwaliyao mayau lagalagali sikoili siyasululi kamwasa kana pasa. ");
INSERT INTO tte_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Boda sibaguna Yeisu manna mena yo tabe boda simuliya meuloili siyogayoga siba, “Osana. Deibida tubuna tatobalan. Yaubada iwalo-muloloi iya ilaoma Guyau esana mena. Osana. Yaubada tatobalan.” ");
INSERT INTO tte_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Saugana Yeisu ilusae Yelusalema, yanuwa tomoliyao meuloili kateli sipitali yo talawauwau lalakina iyawatagili na sinelineli, “Yaiya bwaine?” ");
INSERT INTO tte_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Boda kainali siyamaisa siba, “Bwaine palopita Yeisu ilaomaya Nasaleta Galili ana dedei mena.” ");
INSERT INTO tte_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yeisu ilusae Nume Tabu koina, siya togimwala yo toyamayamaisa itao-yawatagilagili. Mane kana tosensi ali teibeli yo tabe siya bunetutu sigimwagimwala-yagili ali kaba miyasio ibuikeileli. ");
INSERT INTO tte_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Iwalolau kolili iba, “Buki Tabu mena Yaubada ana walo silele iba, ‘Yagu nume esana kani sipei kaba kawanoi.’ Na komiu waginauli besiele tokewali ali gula kaba lowadam.” ");
INSERT INTO tte_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kabo tomangibugibu yo siya kaeli belubeluli silaoma Yeisu koina Nume Tabu kalona mena yo iwoisili. ");
INSERT INTO tte_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kabo gagagiliwo siyaele Nume Tabu mena Yeisu sitobatobalan siwaliwali bwaite besiele siba, “Osana. Deibida tubuna iya Mesaiya tatobalan.” Ginauli namwanamwasosili Yeisu ipaisowaili tomangibugibu yo tobelu kaiweli topwaoli lalakili yo loina kana toyakayakatai sigitaili yo tabe gagagiliwone ali wali sibenalan kabo simunamunai lalakina kaiwena Yeisu yakato iya tomwakomwakota, iya nige Mesaiya. ");
INSERT INTO tte_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Mwa siwalolau Yeisu koina, “Tabu kubebenali gagagiliwo ali walone koina?” Yeisu iwaloba, “Nuwana komiu Buki Tabu ana walo nige kwayayasili iba, ‘Am paisowa kaiwena gagagiliwo kuula-yaliyaliyaya-yagili kabo sitobali-seyagiwo.’” ");
INSERT INTO tte_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yo Yeisu Nume Tabu mena ikaisuluma yo Yelusalema ilogabaen yo ipileyoi yanuwa Bedani koina ikeno. ");
INSERT INTO tte_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yanuwa ilayan malala kikiuna Yeisu yanuwa Bedani ilogabaen ivivila yoi ilalau Yelusalema kaiwena yo iguliyam. ");
INSERT INTO tte_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mayau yabo esana fig, yo kana koleya besiele venavena, igitai itotolo kamwasa dedeina mena yo ilau koina nuwanuwana kanna ikibwa yo ikan. Na nige kanna ipapagan, ligu bwagabwaganamo. Yo iwalolau mayaune koina iba, “Kani nige sauga yabo kuuweyoi.” Kabo sauganane koina mayaune iweweka. ");
INSERT INTO tte_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tobenaliyao sigitai kateli sipitali sisiliyata siba, “Gubesi mwa mayaune iweweka mwayamwayau?” ");
INSERT INTO tte_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yeisu kainali iyamaisa iba, “Yawalo yawasosi kolimiu, tem kwameli yawasosi koliyau yo tabu kwanunuwa-labulabui sowasowamiu waginauli besiele yaginauli mayaune koina. Na nige ginauli kikiunamo iboma kaiwena na tabe sowasowamiu ginauli kaba nuwapwanopwano lalakina waginauli. Kaba gite bwaite, tem me ami meli yo kwawalo koya yabo koina, ‘Kulau kuboma ugabaegiwo kalita mena’ ee kabo kani iginauli besiele. ");
INSERT INTO tte_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tem kwameli, tawae wakawanoiyan kawakawanoi mena, kani kwalobai.” ");
INSERT INTO tte_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yeisu ilusae kaba yakayakatai ana dedei Nume Tabu kalona mena yo tomo iyakayakataili kabo topwaoli lalakili yo toloinao silaoma koina sineliyan siba, “Yaiya ana loina koina na ginauliline bwaite kupaisowaili? Yaiya am kaiwe iyeyawa?” ");
INSERT INTO tte_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yeisu kainali iyamaisa iba, “Baguna bwaite yagu neli kaigeda kani yaeyawa kolimiu. Tem kwayamaisa koliyau kani yawalowen kolimiu yaiya ana loina koina ginauliline bwaite yapaisowaili. ");
INSERT INTO tte_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yagu neli bwaite besiele. Yoni Toyababitaiso tomo iyababitaisoli. Gubesi, ipaisowai besiele Yaubada ana loina koina o nuwana tomo ali loina kolili?” Toloinaone Yeisu ana neli sibenalan kabo siyatubu sigamwagamwa-pakiki sibomamo kolili siba, “Tem tawaloba, ‘Yaubada ana loina koina’ Yeisu kani ineli-yagila, ‘Na tawae kaiwena nige Yoni kwamemeliyan?’ Tem ineliyagila bwaine besiele kani tamwalimwaline. ");
INSERT INTO tte_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","O tem tawaloba, ‘Tomo ali loina kolili’ bwaite kaba matausi kisi boda sikaleya kolila kaiwena ali nuwatu Yoni iya palopita yabo yo ipaisowai besiele Yaubada ana loina koina.” ");
INSERT INTO tte_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mwa koina siba, “Nige kakakatai.” Kabo Yeisu iba, “Tem nige sowana yagu neli kwayamaisa, yau besiele kani nige yawawalowen yaiya ana loina koina ginauliline bwaite yapaipaisowaili.” ");
INSERT INTO tte_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yo Yeisu iwalo yoi toloinao kolili iba, “Na gubesi ami nuwatu walo kobwaibwailine bwaite kaiwena? Tomo yabo natunao labui. Iwalolau tobagubaguna koina iba, ‘Natugu, kabona bwaite kaliyatene kulau yagu oine tanona kupaisowai.’ ");
INSERT INTO tte_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tamana kainana iyamaisa iba, ‘Genuwagu.’ Na muli mena kabo ana nuwatu ibui yo ilau. ");
INSERT INTO tte_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Yo tamali ilau natuna labuina koina iwaloyoi, ‘Natugu, kabona bwaite kaliyatene kulau yagu oine tanona kupaisowai.’ Tamana kainana iyamaisa iba, ‘Tamagu inamwanamwa kabo yalau,’ na iyamo nige ilalau.” ");
INSERT INTO tte_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yeisu ana walo kobwaibwaili bwaite iyemwawasi kabo ineli iba, “Yoli labuine kolili yaiya tamali ana nuwatu ipaisowai?” Kabo siyamaisa siba, “Iya tobagubaguna.” Kabo Yeisu iba, “Yawalo yawasosi kolimiu, tonaenaeli besiele takesi totano yo sinesineo ganaganawalili siya silusalusae Yaubada ana kaba loina koina, na komiu toloinao iyaelemo kwamiyamiya. ");
INSERT INTO tte_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kaiwena Yoni Toyababitaiso ilaoma kolimiu, kamwasa namwanamwana iyakenayagimiu na nige kwamemeli koina. Bwagana komiu wagitaiyako yakato takesi totano yo sinesineo ganaganawalili simeli na iyamo nige kwanunuwabui, Yoni ana guguye kwasikotanan.” ");
INSERT INTO tte_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yeisu iwalo yoi toloinao kolili iba, “Bwaite walo kobwaibwaili yaboyoi yawalowen na kwabenalan. Tomo yabo ana tano isepa yo oine ikumai kabo igana-takikili yo gula yabo ikeli oine kanna masina ana kaba tamtamna yo nume saliyana malamalawena yabo ikabi tano togitekalatan ali kaba miya yo ali kaba gite-takitakikili tanone. Kabo iwolegili tomo tupwaliyao kolili yakato siya togitekalatan tanone siyapaisowa yo oine kanna sigimwala-yani kali sagu kaiwena yo tabe manena tupwana siwolena tanuwaganane koina. Kabo muli mena ilogabaegili ilau yanuwa uloina koina. ");
INSERT INTO tte_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Saugana oine kanna imatuwa yo sigimwala-yani imwawasi kabo tano tanuwagana ana topaisowao iyawasali silau togitekalatan kolili yakato oine kanna manena tupwana sikalai. ");
INSERT INTO tte_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Na togitekalatan tano tanuwagana ana topaisowao sikabi-kalatagili, yabo sisapi, yabo sikoyamate na yaiyonana silovekui. ");
INSERT INTO tte_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mwa tabe tano tanuwagana boda labuina tupwana sibaibaiwa, siya ana topaisowao, iyawasayoili silau kabo togitekalatan mumugaline kaigedana siginauli kolili tabe. ");
INSERT INTO tte_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mwawamwawasina, natu yawasosina iyawasa kolili, iba, ‘Natugu kani sikawa-tomowan siyakasisiyan.’ ");
INSERT INTO tte_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Na saugana natuna sigitai togitekalatan siba, ‘Bwaite tano tanuwagana natu yawasosina. Tem tamanane iboita kani natunane bwaite tanone iya iloinayan. Koinaele talau takoyamate mesabana tanone tabomamo taloinayan iyamala ala gogo.’ ");
INSERT INTO tte_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Yo sikabi-kalatan sigabae-yawatagilan oine kana tano gana mulina mena kabo sikoyamate.” ");
INSERT INTO tte_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Walo kobwaibwaili imwawasi kabo Yeisu ineli iba, “Saugana tem tano tanuwagana ivivilama tawae kani iginauli togitekalatanne kolili?” ");
INSERT INTO tte_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Siya toloinaone ana walo kobwaibwaili sibenabenalan siba, “Tomo naenaeli bwaite kani ikoyamateli na ana tano iwolena togitekalatan uloili kolili. Yo naga oine kanna imatuwa kani oine kanna manena siyakasa namwanamwai na siyamaisa-yadudulai tano tanuwagana koina.” ");
INSERT INTO tte_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yeisu iwalo kolili iba, “Buki Tabu iwaloba, ‘Tokabikabi veku yabo sikalai yakato nume sikabi koina na vekune sikawa-naenaeyan yo sisikotanan. Na Guyau vekune ikalai iyatolo-bagunayan yakato veku meuloili iloinayagili yo sikaiwe. Bwaite Guyau ana paisowa namwanamwasosina manla mena.’ Gubesi, nuwana nige sauga yabo walone bwaite kwayayasili? ");
INSERT INTO tte_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Mwa koinaele, yawalo kolimiu toloinao, Yaubada ana kaba loina kani ikelegabaen kolimiu na iwolena boda uloina, siya meuweli, kolili. ");
INSERT INTO tte_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tem yaiya ibeku veku bwaite pwatana mena kani ikogaogaoli. Na tem veku bwaite ibeku tomo yabo pwatana mena kani ikomutumutu.” ");
INSERT INTO tte_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Saugana topwaoli lalakili yo Palisi walo kobwaibwailine Yeisu iwalowen kolili sibenalani, sikatai iwalowalo siya kaiweli. ");
INSERT INTO tte_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kabo nuwanuwali Yeisu sikabi-kalatan yo sipan na iyamo boda simatausagili kaiwena tomo meuloili ali nuwatu yakato Yeisu iya palopita yabo. ");
INSERT INTO tte_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yeisu iwalo-kobwaibwaili yoi kolili iba, ");
INSERT INTO tte_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Yaubada ana kaba loina bwaite besiele. Kin yabo kekan lalakina iginauli natuna tauna ana kasole kaiwena. ");
INSERT INTO tte_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Baguna tomo lalakili ikawanoi-yagili silaoma kasolene simanmanbubu yo sikekan. Kasole kana sauga koina ana topaisowa iyawasali kolili ali wasa siwolegili tem silaoma kekan koina, na iyamo tomo lalakiliwa sisikote. ");
INSERT INTO tte_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kabo boda labuina tupwana sibaibaiwa, siya ana topaisowao, iyawasali yoi iba, ‘Siya yakawanoi-yagili kasole kekanna kaiwena ali wasa kwaolegili yakato bulumakau tauna yo sinena sinisinibuli yaunuiliko yo kan meuloina kakatububunagiliko kasanasanaimiu kwalaoma kasole kekanna koina.’ ");
INSERT INTO tte_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Na siya sisikote nige ali nuwatu ilalau kolili. Tupwaliyao silau ali tano kolili yo tupwaliyao silau ali bisinisi kolili. ");
INSERT INTO tte_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yo tabe tupwaliyao ana topaisowao sikabi-kalatagili, sisapili yo sikoyamateli. ");
INSERT INTO tte_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kabo kin imunamunai lalakina yo ana tokaleyayao iyawasali, silau tounuyamateyaone sikoyamateli yo ali yanuwa sigabuli. ");
INSERT INTO tte_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Yo iwalo ana topaisowao kolili, ‘Kasole kekanna takatububunanako na tomo lalakiliwa sisikote nige silalaoma, besi, amokisa kaiwena siyauyaule. ");
INSERT INTO tte_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kwalau kamwasa kolili kwatakikili na tem analiyao kwalobaili kwawalo silaoma kasole kekanna koina takekan.’ ");
INSERT INTO tte_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Yo topaisowa silau kamwasa kolili tomo meuloili silobaili, namwanamwali yo naenaeli, yo sikalailima. Ee kabo kasole numena ikalapowon. ");
INSERT INTO tte_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Saugana kin ilusae kasole numena koina na tem tolusae igitaili, kabo tomo yabo igite-lobai kasole kana kaleko nige ililikwa, ");
INSERT INTO tte_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","mwa ineliyan iba, ‘Eliyam, gubesi na kulaoma kulusae na nige kasole kana kaleko kulilikwa?’ Na tomone kin kainana nige iyayamaisa. ");
INSERT INTO tte_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kin iwalo ana topaisowao kolili, iba, ‘Nimana yo kaena kwapanli na wagabae-yawatagilan boniboniyai mena na ivalavalam yo mwakana siyekalasi yo sikikokiko.’” ");
INSERT INTO tte_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yeisu ana walo kobwaibwaili iyemwawasi kabo iba, “Sibaibaiwa Yaubada iyoganili na yoli isamo igitesipwaili silusae.” ");
INSERT INTO tte_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yeisu ana walo imwawasi kabo Palisi Yeisu silogabaen silau sinuwatu-loyaloya na tem gubesina Yeisu kaba yakewaina yabo siginauli. ");
INSERT INTO tte_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kabo Palisi ali tomuliyayao siyawasali Yeisu koina mekalikavao boda yabo esana ‘Elodiyanao.’ Siwalo siba, “Toyakayakatai, kakatai yakato sauga meuloina kuwalo yawasosi yo am yakayakatai Yaubada kaiwena idudulai. Yo tabe nige tomo yabo kumamatausan, bwagana tosonosonoga o nuwana towasawasa na iyamo nige ugogolulau kolili. ");
INSERT INTO tte_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gubesi, sowasowana Sisa kaiwena takesi tapei o nigele? Na tawae am nuwatu? Nuwanuwamai am walo kabenalan.” ");
INSERT INTO tte_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yeisu ikataiyako yakato siya nuwanuwali Sisa kana kawa-naenae sibenalan yo ana walone siwalo-masalan toloinao kolili na tem siyakewai kabo iba, “Tomwakomwakota yawasosi komiu. Tawae kaiwena kwatonatonan tem kwasipwaiyau yagu edeedede koina? ");
INSERT INTO tte_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mane siliba iya koina ami takesi kwapeipeine wakalaiyama kwayakenayagau.” Manene sikalai yo siwolena koina. ");
INSERT INTO tte_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yo ineliyagili iba, “Yaiya makamakayauna yo tabe yaiya esana silele manene koina?” ");
INSERT INTO tte_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Siwalolau koina siba, “Sisa.” Yo Yeisu iwalo kolili iba, “Ginauline siya Sisa ana gogo kwaolena Sisa koina na ginauline siya Yaubada ana gogo kwaolena Yaubada koina.” ");
INSERT INTO tte_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Saugana ana walo sibenalan kateli sipitali. Kabo silogabaen yo silowasi. ");
INSERT INTO tte_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kaliyatenane koina tabe Sadusi silaoma Yeisu koina. Na Sadusi ali nuwatu yakato nige toloyoi yaboyoi mwa koina Yeisu sineliyani, ");
INSERT INTO tte_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","siba, “Toyakayakatai, Mosese iwalo tem tomo yabo ikasole nige natunao na iboita kanakava kwabukwabulina kani ikasolanan na tem natunao ipagan siya melumeluwone siyamala tomone, iya boiboitana, natunao. ");
INSERT INTO tte_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na gubesi kaba gite bwaite. Tomo yabo mekanakavao yoli seben, tobagubaguna ikasole nige natunao na iboita kabo kwabukwabulina kanakava ikasolanan. ");
INSERT INTO tte_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Besiele kaigedana iyawatagili kanakava labuina koina besiele yaiyonana koina yo besiele meuloiline kolili paganne silobai. ");
INSERT INTO tte_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ana kaba mwawasi sinewa iboita. ");
INSERT INTO tte_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tem yawasosi toboita kani sitoloyoi, ali toloyoine koina yoli seben luwali mena yaiya iya wainena yawasosi, kaiwena meuloiliwa sikasolanan?” ");
INSERT INTO tte_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yeisu kainali iyamaisa iwaloba, “Kwalopwano yawasosi, kaiwena Buki Tabu ana walo nige wakakatai yo tabe Yaubada ana kaiwe nige imamayale kolimiu. ");
INSERT INTO tte_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Saugana toboita sitoloyoi kali koleya besiele aneloseyao bulibuli mena, nige kasole yoi. ");
INSERT INTO tte_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na toboita ali toloyoi kaiwena tomala Buki Tabu nige kwayayasili tawae Yaubada iwalowen kolimiu. ");
INSERT INTO tte_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Iwaloba, ‘Sauga bwaite yau Abelamo, Aisake yo Yakobo ali Yaubada.’ Bwagana siboitako na iyamo takatai tubulaone bwaite meyawasili simiyamiya bulibuli mena. Yaubada iya nige toboita molosi ali Yaubada na siya meyawasili ali Yaubada.” ");
INSERT INTO tte_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Saugana boda meuloili Yeisu ana yakayakatai sibenalan kateli sipitali, sisiliyata yo siba, “Iya yawasosimo isonoga.” ");
INSERT INTO tte_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Palisi wasane sibenalan yakato Yeisu Sadusi iwalo-yamwanouli kabo silogogoma. ");
INSERT INTO tte_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kalikava yabo iya loina kana tokatai nuwanuwana Yeisu itonan mwa ineliyan, ");
INSERT INTO tte_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","iwaloba, “Toyakayakatai, toisabo loina ilalakisosi Mosese ana loina kaloli mena?” ");
INSERT INTO tte_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yeisu kainana iyamaisa iwaloba, “Yeoba am Yaubada kumulolo koina katem meuloina mena, yawasim meuloina mena yo am nuwatu meuloina mena. ");
INSERT INTO tte_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Loina bwaite iya loina lalakina yo loina bagubagunana. ");
INSERT INTO tte_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Yo loina labuina bwaite besiele iwaloba, ‘Am tomoyao, kumulolo kolili besiele kowa kuboma kam mulolo.’ ");
INSERT INTO tte_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mosese ana loina meuloina yo palopitao ali yakayakatai meuloina silaomaya loinane bwaite labuine kolili ali wauwau.” ");
INSERT INTO tte_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Yeisu igitai Palisi boda lalakina silogogomako mwa ineliyagili, ");
INSERT INTO tte_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","iba, “Gubesi ami nuwatu Mesaiya kaiwena yo yaiya tubuna iya?” Kainana siyamaisa siwaloba, “Iya Deibida tubuna.” ");
INSERT INTO tte_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Kabo Yeisu ineliyoi iba, “Tem Buki Tabu tayasili talobai yakato beyabeyana Deibida iba, ‘Yaubada iwalolau yagu Guyau koina iwaloba, ulaulagu mena kumiyasio kanasiga kam tokalomagigiliwo yaunuili yo ali kaiwe imwawasi na kaekaem silau galogaloli mena.’ Bwaite kaba kawa yawasosi yakato Deibida Mesaiya ikawa-Guyauwan. Iwalo besiele kaiwena Yaluyaluwa Tabuna iyanuwapei kabo nuwana imayale. ");
INSERT INTO tte_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Na tem Deibida Mesaiya ikawa-Guyauwan gubesi mwa iya Deibida tubuna kaiwena naga Mesaiya iyayawatagilima?” ");
INSERT INTO tte_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nige yabo sowasowana Yeisu kainana iyamaisa, mwa koina kaliyatenane koina kanasiga nige yabo itotonan yoi tem isipwai ana edeedede koina kaiwena sigitai Yeisu toloinao meuloili isonoga-gabaegili yo simwalimwaline. ");
INSERT INTO tte_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yeisu iwalolau boda yo tabe ana tobenaliyao kolili iwaloba, ");
INSERT INTO tte_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Loina kana toyakayakatai yo Palisi siya Mosese ana loina kana tokatai yo kana tokabi-yamayale. ");
INSERT INTO tte_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ilonamwayagimiu tem kainali kwabenalani yo ali yakayakatai meuloina kwamuliya, na tabu komiu wagiginauli besiele tawae siya siginauli, kaiwena sibomamo ali yakayakatai nige simumuliya. ");
INSERT INTO tte_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Loina sibaibaiwa siwalowalowegili tomo kolili mwa koina tomo ali nuwapolowe ilalaki na Palisiyaone nige nuwanuwali nuwapolowene koina sisaguili yo siyamalamalaeli. ");
INSERT INTO tte_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ginauli meuloina siginauli mesabana yakato tomo sigitaili na sitobalanagili. Mumugali bwaite besiele. Buki Tabu lelelelena sitobwai yo tobwane tabatabana lamwali mena sipan-kalatan. Yaboyoi kawanoi kwamana sopali mena kulakulali malamalaweli sikona-yapatuli. Tabe sipasa-yagili yakato siya tomo obiobigali yo yakayakasisili kali kilakilala. ");
INSERT INTO tte_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kekan soina koina nuwanuwali lalakina tem simiyasio kaba miya namwanamwana kolili yakato siya tomo lalakili, yo tabe nume tapwalolo koina nuwanuwali simiya-baguna tomo manli mena. ");
INSERT INTO tte_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Tem silau kaba maketi mena nuwanuwali tomo silaoma yo sikawa-kagutoki kolili. Tabe nuwanuwali lalakina tem tomo meuloili sikawa-guyau-yagili.” ");
INSERT INTO tte_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Na komiu, tabu tomo siwawalo-seyagimiu, kaiwena ami Guyau kaigedamo na meuloimiu kwatoyatoyawa. ");
INSERT INTO tte_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tabu yanuwa yaulina tomona yabo wakakawa-tamayan, kaiwena Tamamiu kaigedamo, iya iyaele bulibuli mena. ");
INSERT INTO tte_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Imiyawa tomo sikakawa-tobaguna-yagimiu, kaiwena ami tobaguna kaigedamo, iya Mesaiya. ");
INSERT INTO tte_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yaiya tem nuwanuwana esana ilalaki kalomiu mena ilonamwayan iyamala ami topaisowa. ");
INSERT INTO tte_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yaiya tem iboma ipeiseyan, Yaubada kani ipei-lobiyen. Na yaiya tem inuwalobi, Yaubada kani ipeiseyan.” ");
INSERT INTO tte_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Kateguwao komiu, loina kana toyakayakataiwo yo Palisiyao tomwakomwakota komiu, Yaubada ana loina kali tolikwailiwo, katekamkamnamiu, bwaliga kani kwasilae. Kaiwena Yaubada ana kaba loina kana gamwa wakausi tomo kolili. Analiyao nuwanuwali silusae na ali kamwasa wakaukausi ami loina koina. Bwaite kaiwena nige sowasowamiu kwalusae. Walo yawasosi kwabukwabuliwo ali nume yo ali gogo wakewalili loina mwakomwakota koina. Tabe ami kawanoi simamalawe tomo tenali mena sibenalan yakato kami tobali kaiwena. Mwa bwaite mumugamiune kaiwena kani maisana naenaena kwalobai. ");
INSERT INTO tte_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Loina kana toyakayakataiwo yo Palisiyao, tomwakomwakota komiu, bwaliga kani kwasilae. Dedei meuloina kolili kwatakikili na mesabana tomo yabo kwayanuwakoi na inuwabui, kabo wakalai na imuliya kolimiu. Komiu Giyena kana tomoyao, na saugana tomone wakalai kwayakenayan iya ana yauyaule ilalakisosi kabo komiu. ");
INSERT INTO tte_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Komiu tobagunao man gibugibumiu, bwaliga kani kwasilae. Kaiwena komiu kwawaloba, ‘Tem tomo yabo ikawalulu Nume Tabu koina sowasowana ana waloyameli isoke-gabaen yakato Nume Tabu ginauli bwagabwaga, na tem tomo yabo ikawalulu Nume Tabu kana gole koina kani nige sowasowana ana waloyameli isoke-gabaen.’ ");
INSERT INTO tte_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Na komiu toyauyaule kaiwena manimiyao sigibu yo nige wakakatai yakato Nume Tabu ilalakisosi kabo muli mena gole ana lalaki. Walo yawasosi Nume Tabu yakayakasisina kaiwena mwa golene tabe iyakasisiyan. ");
INSERT INTO tte_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Na komiu kwawaloyoi, ‘Tem tomo yabo ikawalulu kaba pwaoli koina sowasowana ana waloyameli isoke-gabaen yakato kaba pwaoline ginauli bwagabwaga. Na tem tomo yabo ikawalulu yakayakan iya sipwaoliyan koina, nige sowasowana waloyameline isoke-gabaen.’ ");
INSERT INTO tte_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Na komiu toyauyaule kaiwena manimiyao sigibu yo nige wakakatai yakato kaba pwaoline ilalakisosi kabo muli mena yakayakan ana lalaki. Kaba pwaoli yakayakasisina kaiwena mwa yakayakanne tabe iyakasisiyan. ");
INSERT INTO tte_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Koinaele tem tomo yabo ikawalulu kaba pwaoli koina, ikawalulu kaigedai yakayakanne sipwaopwaoliyanne mekanakava. ");
INSERT INTO tte_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Besiele tem sauga yabo tomo yabo ikawalulu Nume Tabu koina, ikawalulu kaigedai Yaubada mekanakava kaiwena Nume Tabune iya ana kaba miya. ");
INSERT INTO tte_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Yo tem tomo yabo ikawalulu sae bulibuli mena ikawalulu kaigedai Yaubada ana kaba miya wasawasa koina yo tabe iya koina.” ");
INSERT INTO tte_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Loina kana toyakayakataiwo yo Palisiyao, tomwakomwakota komiu. Bwaliga kani kwasilae. Kaiwena Yaubada ana loina lalakili kwanuwa-mwatainagili siya bwaite loinaline paisowa dudulaina, kalakavao takate-kamkamna-yagili yo tawalo yawasosi. Na komiu ami sauga kwayavenuwan loina kikiuli kolili, kaba gite bwaite kaigalu, venavena yo seyala liguna kwayakasa tupwana kikiuna kwaolena Yaubada koina ami mulolo. Na ilonamwa-yagimiu tem kwatonan kaiwe na loina lalakili wakatai-baguna-yagili kabo muli mena loina kikiuli. ");
INSERT INTO tte_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Komiu tobagunao man gibugibumiyao. Loina lalakili kwanuwa-mwatainagili na loina kikiuli kwanuwanuwatu-kalatagili. Kaba gite bwaite. Ginauli kikiuna besiele nonowala wagitai na ginauli lalakina besiele kameli nige wagigitai. ");
INSERT INTO tte_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","26","Loina kana toyakayakataiwo yo Palisiyao tomwakomwakota yo man gibugibumiyao komiu. Bwaliga kani kwasilae. Komiu kwanuwanuwatusosi loina kikiuli kaiweli besiele komwa yo gaeba kali deudeuli, na loina lalakili nigele. Komiu besiele tomo patipatimiu yo tomo kankan-kalakalabilimiu. Baguna katemiu kwadeuli namwanamwai kabo ami patipati yo ami kankalakalabili imwawasi.” ");
INSERT INTO tte_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Loina kana toyakayakataiwo yo Palisiyao, tomwakomwakota komiu. Bwaliga kani kwasilae. Komiu besiele salai sikatububun yo siyapasa, pwatana mena kana koleya inamwanamwa na kalona mena toboita bowali yo tuwatuwali ikalapowon. ");
INSERT INTO tte_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Besiele tomo sigitaimiu mayale mena yakato komiu kwanamwanamwa na iyamo katemiu mena mwakota yo nae sikalapowon. ");
INSERT INTO tte_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","Loina kana toyakayakataiwo yo Palisiyao tomwakomwakota komiu. Bwaliga kani kwasilae. Palopitao ali kilakilala kaba nuwatu-kalatan waginaulili yo tautaubalao beyabeyali siya mumugali idudulai kali salai kwayapasali. Imwawasi kwamwakota yakato tem komiu kwamiyamiya tautaubalao beyabeyali ali sauga koina, kani nige wagiginauli besiele tubumiyao siginauli palopitao kolili, nige kwauunu-yamateli. ");
INSERT INTO tte_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Koinaele ami mwakota koina kwaboma kwawalo-masalagimiu yakato komiu tubumiyao palopitao kali tounuyamate. ");
INSERT INTO tte_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Na tawae naenaena bwaite tubumiyao siyatubu ali sauga koina komiu bwaite sauga kani kwaetulanyoi. ");
INSERT INTO tte_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Komiu mumugamiu besiele weso me natunao. Nige sowasowana Yaubada ana loina kaikaiwena kwayabubu-gabaen, kani iyatalayagimiu yo igabaegimiu Giyena koina. ");
INSERT INTO tte_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Koinaele yawalo kolimiu, palopitao yo tosonoga lalakili yo toyakayakatai kani yayawasali kolimiu. Tupwali kani kwaunuili, tupwali kwayakeloseli, tupwali kwasapili ami nume tapwalolo kaloli mena yo tupwaliyao kani kwatawoili silau dedei yabo yo dedei yabo kolili. ");
INSERT INTO tte_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Na unuyamate meuloina kana maisa komiu kani kwalobai, siya tomo mumugali dudulaina siunuili, iyatubuya Eibeli koina kanasiga Sekalaiya, iya Balakaiya natuna. Palopitane Sekalaiya sauga beyabeyana koina tubumiyao siunui dedei yakayakasisi-molosina yo kaba pwaoli luwaluwalili mena, Nume Tabu kalona mena. ");
INSERT INTO tte_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yawalo yawasosi kolimiu, tounuyamate meuloili kali maisa polowena komiu kani kwalobai.” ");
INSERT INTO tte_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Tabe komiu Yelusalema kana tomiya. Palopitao kwaunuili yo siya Yaubada iyawasali kolimiu kwalovekuili. Sauga meuloina nuwanuwagu ami tomoyao yapei-gogonagili, besiele kamkam sinena natunao ikele-gogonagili pepena yaulina mena, na nige nuwanuwamiu besiele. ");
INSERT INTO tte_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ee kabo ami Nume Tabu Yaubada kani ikwasagabaen na bwagabwagana, ");
INSERT INTO tte_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","kaiwena mwa yawalo kolimiu kani nige wagigitaiyau yoi kanasiga yavivilama yoi yo saugana koina kwatobalanagau kwaba, ‘Yaubada iwalo-muloloi mwa iya ilaoma Guyau esana mena.’” ");
INSERT INTO tte_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Muli mena Yeisu Nume Tabu ilogabaen ilalau kabo ana tobenaliyao silaoma koina siwaloba, “Manim ilau Nume Tabu ali kabikabina kana koleya ugitai.” ");
INSERT INTO tte_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yeisu kainali iyamaisa iba, “Numene bwaine wagitagitailine, veku mena sikabikabiline, yawalo yawasosi kolimiu, naga kani vekune sikele-gwaligwalili, nige yabo imiyamiya ana kaba miya mena.” ");
INSERT INTO tte_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yeisu ilau isae koya Olibe koina, imiyasio yo ana tobenaliyao sibomamo silaoma koina siba, “Ama wasa kuyeyama, toisabo sauga koina kani Nume Tabu sikele-gwaligwali? Na am laoma kana kilakilala yo tabe sauga mwawamwawasina kana kilakilala gubesi?” ");
INSERT INTO tte_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yeisu kainali iyamaisa iwaloba, “Wagite-kalatagimiu kisi tomo tupwaliyao simwakotayagimiu. ");
INSERT INTO tte_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kaiwena tomo sibaibaiwa kani silaoma esagu mena siwaloba, ‘Yau Keliso’ kabo tomo ali walo mwakomwakota kani simeliyani. ");
INSERT INTO tte_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kaleya gogoliyao daguguli kani kwabenalagili salimiu mena yo tabe kaleya dedei uloi uloi kolili wasaliyao kani kwabenalagili. Na tabu katemiu siwawakaka. Ginauline besiele bwaite kani siyawatagili baguna kabo muli molosi mena sauga ana kaba mwawasi kani iyawatagili. ");
INSERT INTO tte_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Boda yo boda kani sikaleya yo besiele kaba loina yo kaba loina sikaleya. Guliyam lalakina yo mwanikiniki kani simayale dedei kaigeda kaigeda kolili. ");
INSERT INTO tte_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Polowe bwaite meuloili kani siyawatagili-baguna kaba gite besiele kabi kana kamkamna mulina mena kabo melumelu iyawatagili. ");
INSERT INTO tte_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tabe muli mena kani sikabi-kalatagimiu yo silawagimiu na siyakamkamnamiu yo sikoyamatemiu. Yau kaiwegu boda meuloili kani sikalomagigi-lagimiu. ");
INSERT INTO tte_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sauganane koina kani tomeli sibaibaiwa ali meli sisikotanan, yo kalikavao kani sikalomagigi-lagili na siwalo-masalagili toloinao kolili. ");
INSERT INTO tte_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Palopitao mwakomwakotali sibaibaiwa kani siyawatagili yo tomo meuloili simwakotayagili. ");
INSERT INTO tte_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kabo mumugana naenaena ilalaki isasae yo totapwalolo kani nige kalikavao kolili simumulolo, ");
INSERT INTO tte_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","na yaiya tem itolo kaikaiwe kanasiga sauga ana kaba mwawasi koina iya kani lebo ilobai. ");
INSERT INTO tte_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Wasa namwanamwana Yaubada ana kaba loina kaiwena kani siguguyeyan yanuwa yaulina mena na tomo meuloili sikatai. Imwawasi kabo yapileyoima.” ");
INSERT INTO tte_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ginauli naenaena yabo kani wagitai siyatolo Nume Tabu kana wauwau dedeina mena. Na ginauline kana koleya besiele Daniela ana Buki kalona mena. Ilonamwayagimiu tem komiu toyasiyasili kwanuwatu namwanamwa walone bwaite kaiwena kabo nuwamiu simayale. ");
INSERT INTO tte_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Bwaite iya yainaele kaiwena mwa yawalo siya simiyamiya Yudiya koina saugana ginauli naenaenane sigitai ilonamwayagili tem mwayamwayau sisagena siyabubu koya mena. ");
INSERT INTO tte_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tem yaiya kowa am nume kewana mena kupaipaisowa, kuyabubu mwayamwayau, tabu sauga ugagabaen am gogo nume mena kaiweli. ");
INSERT INTO tte_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yo tem yaiya kowa am tano mena kupaipaisowa, kuyabubu mwayamwayau, tabu kupipileyoi kam kwama dedei yabo mena kupepeine kaiwena. ");
INSERT INTO tte_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ooo, yawasosi kategu ikamkamna-yagili siya tosiumao yo toyasuyasusuwo kaiweli kaiwena ali yabubu yo ali sagena kani ipolowesosi kolili sauga bwaine koina. ");
INSERT INTO tte_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Koina wakawakawanoi na sauga namwanamwana Yaubada iyeliwa ami sauga yabubu koina. Kaiwena tem kwasagesagena tulutulu kana sauga mena ami lau ikololososi. Tabe tem kwasagesagena Sabati koina kani Mosese ana loina kwalikwai. ");
INSERT INTO tte_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kaiwena miya polowe lalakina kani iyawatagili, nige sauga yabo besiele iyayawatagili yanuwa yaulina ana sauga tubu koina yo kanasiga kabona, yo besiele kani nige iyayawatagili yoi sauga muli mena. ");
INSERT INTO tte_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nae bwaine kana kaliyate tem Yaubada nigele ikakabi-yakubwali tomo meuloili siboita, na iyamo Yaubada kaliyateline kani ikabi-yakubwali bwaimwa siya ana tomo igitesipwaili kaiweli. ");
INSERT INTO tte_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Na sauganane koina tem tomo yabo iwalolaowa kolimiu, iba, ‘Wagitai Keliso iyaelete’ o tem yabo iba, ‘Iyaelene’ tabu kwamemeliyan. ");
INSERT INTO tte_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kaiwena keliso mwakomwakotali yo palopitao mwakomwakotali kani siyawatagili yo ginauli kaba nuwapwanopwano yo kilakilala sipaisowaili yakato tem totapwalolo mwakota mena siwoyaili, na iyamo tomeli yawasosi ali meli kani sikabi-kalatan. ");
INSERT INTO tte_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kwabenali, ami wasa yaeyawa-bagunayan kabo muli mena ginauline siyawatagili.” ");
INSERT INTO tte_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Tem tomo yabo iwalo kolimiu iwaloba, ‘Iyaele ule bwagabwaga mena’ tabu kwalalau. Yo tem yabo iwaloba, ‘Iyaelete nume kalona mena’ tabu kwamemeliyan. ");
INSERT INTO tte_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kaiwena Tomo Natuna ana laoma besiele pigabu ana lau, tem kaluwabu mena ipigabu kani mwayamwayau tabe ilau yalasi mena ipigabu, imwayamwayausosi. ");
INSERT INTO tte_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tem tagitai aoao bodali sitowa niu liguli kolili sivalavalam ee takatai bowa kana kilakilala iyaele yauli mena imiyamiya. Bwaine besiele kilakilalane yawalowegiliko kolimiu tem tagitaili takilalali ee kabo takatai yawasosi Tomo Natuna ilaomako.” ");
INSERT INTO tte_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Nae bwaine kana kaliyate mulina mena kabo dabwelo iboniboniyai, waikena nige iyayalalayoi, yo utu kani sibekumaya bulibuli mena yo tabe ginauli meuloili bulibuli mena Yaubada kani inukuili. ");
INSERT INTO tte_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Na Tomo Natuna ana laoma kana kilakilala kani siyawatagili bulibuli mena, mwa tomiya yanuwa yaulina kani sivalam koyasili. Tomo Natuna kani sigitai ilalaoma yaloyaloi pwatana mena, me ana kaiwe yo me ana wasawasa lalakina. ");
INSERT INTO tte_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Bwagigi kainana lalakina kani siyui kabo ana aneloseyao iyawasali silau yanuwa yaulina dedei esopali kolili yo ana tomoyao gitegitesipwali ipei-gogonagili, iyatubu dabwelo ana kaba mwalisae koina kanasiga ana kaba sugu koina.” ");
INSERT INTO tte_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Kaba gite yabo saido koina saugana tem tagitai yo liguli waluwaluli sikin takatai yaikin kana sauga ikelakubwamako. ");
INSERT INTO tte_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Yo tabe besiele saugana tem ginauli meuloina yawalowegili wagitaili siyawatagili, wakatai Tomo Natuna ana sauga laoma ikelakubwamako. ");
INSERT INTO tte_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yawalo yawasosi kolimiu, ginauli meuloiline yawalowegiliko kani siyawatagili kabo muli mena bwaine yasone kani kilakilalane sigitaili kabo simwawasi. ");
INSERT INTO tte_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Naga bulibuli yo yanuwa yaulina simwawasi na iyamo yagu yakayakatai kani nige sowana imwawasi.” ");
INSERT INTO tte_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nige tomo yabo ikakatai toisabo kaliyate yo toisabo sauga ginauliline siyawatagili. Tabe besiele aneloseyao bulibuli mena nige sikakatai, yau Tomo Natuna nige yakakatai, Tamagu iya ibomamo ikatai. ");
INSERT INTO tte_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tomo Natuna ana pileyoima kani kana koleya besiele tauna kona Nowa ana sauga mena. ");
INSERT INTO tte_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kaiwena sauganane koina naga yalubwasi idodoga-saema yo tomo meuloili sikekakekan yo sinumanuma yo sikasokasole kanasiga kaliyatenane Nowa ilusae waga aki kalona mena. ");
INSERT INTO tte_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nige yabo inuwanuwatui yakato kani tawae iyawatagili kanasiga doga isaema yo meuloili sigalomwasi siboita. Tabe kani besiele Tomo Natuna ana pileyoima koina. ");
INSERT INTO tte_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sauganane koina tomo yoli labui kani sipaipaisowa ali tano koina, yabo aneloseyao kani sikalai silawan, na yabo imiyamiya. ");
INSERT INTO tte_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Sinesineo yoli labui kani sipaipaisowa witi kanna sigiligaogaoli kali kaiwena, yabo kani sikalai silawan na yabo imiyamiya. ");
INSERT INTO tte_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Koinaele wagite-kalatagimiu, kaiwena nige wakakatai toisabo kaliyate koina ami Guyau ilalaoma. ");
INSERT INTO tte_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Na kwanuwatu-kalatan bwaite, tem nume tanuwagana ikatai toisabo sauga boniyaina koina tokewali kani ilaoma ee kabo isilasilawa yo igitagitai kisi tokewali ana nume isoke yo ilusae. ");
INSERT INTO tte_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Besiele komiu ilonamwayagimiu tem wakatububu-nagimiu kaiwena sauganane koina nige wakakatai Tomo Natuna ana pileyoima kani katemiu iyapitali.” ");
INSERT INTO tte_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Gubesi topaisowa sanasanapuna mumugana? Ana nuwatu idudulai yo tem ana taubala ipei topaisowa meuloili igitekalatagili ee kabo kani ipaisowai na kan iwolegili kekan kana sauga yawasosi kolili. ");
INSERT INTO tte_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yo tem ana taubala ilau topaisowane ilonamwayan tem saugana ana taubala ivivila yoima ilobai iyaele ipaipaisowa dudulai ee kabo taubalane ana topaisowa ikawa-namwanamwa-yani. ");
INSERT INTO tte_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yawalo yawasosi kolimiu, taubalane kani ana topaisowane ipei ana gogo meuloina igite-kalatan. ");
INSERT INTO tte_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Na tem topaisowane mumugana inae kani inuwatui katena mena iwaloba, ‘Yagu taubala kani nige ilolomwaya-mwayauma,’ kabo iyatubu taubala ana loina ilikwai topaisowa meuloili isapili yo ilau toyauyaule mekanakavao sinumanuma yo sikekakekan. ");
INSERT INTO tte_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Taubalane ana sauga pileyoima koina kani topaisowane katena ipitali isiliyata, kaiwena ana taubala ana laoma kana sauga nige ikakatai. ");
INSERT INTO tte_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Taubalane ana topaisowa kani iunu-yanayanae yo iyetomtomwan, na ipei toyauyaule yo tomwakomwakota ali dedei koina na ivalavalam yo mwakana iyekalasi yo ikikokiko.” ");
INSERT INTO tte_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yo Yeisu iwalo kolili, iwaloba, “Naga sauga ana kaba mwawasi koina Yaubada ana kaba loina bwaite besiele. Vesalao yoli sanaulu ali mayale sikalaili siyawatagili silau sisanasana kasole tauna ana laoma kaiwena. ");
INSERT INTO tte_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Yoli valigigi yauyauleli yo yoli valigigi sanasanapuli. ");
INSERT INTO tte_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Siya yauyauleli ali mayale sikalaili, na mayalene kana kelesin kana etulan nuwali imwatainan. ");
INSERT INTO tte_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Siya sanasanapuli ali mayale sikalaili yo mayale kana kelesin kana etulan tabe silokalai.” ");
INSERT INTO tte_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Na kasole tauna ana laoma iyoviya yo vesalao meuloili kamnali sinae yo siyagayagata yo manli sikenokeno kabo sikenomate. ");
INSERT INTO tte_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Boniyai luwaluwalina mena kabo tomo yabo ilaoma iyoga kainana lalakina iba, ‘Kwatolo, kwatolo, kasole tauna ilaomako. Kwayawatagilima na tamuloloi.’ ");
INSERT INTO tte_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kabo vesalao meuloili sitolo yo ali mayale sikatububunagili yo ali mayalene siki-yalalakili. ");
INSERT INTO tte_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Siya yauyauleli siwalolau sanasanapuli kolili siba, ‘Kelesin tupwana kwaeyama, ama mayale kikiunamo siboita.’ ");
INSERT INTO tte_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kainali siyamaisa siwaloba, ‘Nigele, nige sowasowana tupwana kaeyawa. Sowasowanamo kwalau togimwala kolili ami mayale kana kelesin tupwana kwayamaisa.’ ");
INSERT INTO tte_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Na saugana silalau kelesin yamaisana kaiwena kasole tauna iyawatagilima. Kabo vesalao siya sikatububu namwanamwa mekanakavao silusae kasole soina kekanna koina yo gamwa sikausi. ");
INSERT INTO tte_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Muli mena kabo vesalao yauyauleli sipileyoima sikipisi yo siwaloba, ‘Taubala, taubala, gamwa kusoke na kalusaewa.’ ");
INSERT INTO tte_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Na taubalane iwaloba, ‘Yawalo yawasosi kolimiu, nige yakakataimiu.’” ");
INSERT INTO tte_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yo Yeisu ana walo kobwaibwaili iyemwawasi kabo iwaloba, “Koinaele wagite-kalatagimiu, kaiwena nige wakakatai toisabo kaliyate o toisabo sauga koina ami Guyau ipileyoima.” ");
INSERT INTO tte_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yo Yeisu iwalo-kobwaibwaili yoi kolili iwaloba, “Yaubada ana kaba loina bwaite besiele. Taubala yabo nuwanuwana ilau dedei yabo koina yo ana topaisowao iyoganlima na ana mane tupwana iwolegili kolili yakato sigitekalatan kanasiga ipileyoima kabo manene siyapileyoi taubalane koina. ");
INSERT INTO tte_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kina kana baibaiwa paibi tausan iwolena topaisowa yabo koina, yo tu tausan iwolena labuina koina yo wan tausan iwolena yaiyonana koina kaiwena kaigeda kaigeda ali katai kana lalaki besiele ana yauya kolili. Imwawasi kabo ilogabaegili ilau dedei yabo mena. ");
INSERT INTO tte_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Topaisowa bwaite iya kina kana baibaiwa paibi tausan ikalai, iya ilomwayamwayau ilau iyapaisowa yo kana etulan paibi tausan ilobaiyoi. ");
INSERT INTO tte_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yo topaisowa yabo tu tausan ikalai ilau iyapaisowa yo kana etulan tu tausan ilobaiyoi. ");
INSERT INTO tte_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Na iya topaisowa yabo wan tausan ikalai ilau, bwatano ikeli yo ana taubala ana mane ipului.” ");
INSERT INTO tte_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Sauga imamalawe kabo ali taubala ivivilama yo ana topaisowao yoli yaiyona iyoganli, nuwanuwana ikatai gubesi ana mane ali yapayapaisowana. ");
INSERT INTO tte_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Topaisowa bwaite kina kana baibaiwa paibi tausan ikalai ilaoma iwolena ana taubala koina mekana etulan paibi tausan, yo iwaloba, ‘Taubala, paibi tausan tauna kona kuyeyama, ugitai tabe kana etulan paibi tausan yalobaiyoi, am mane meuloina ten tausan iyaelete ukwalai.’ ");
INSERT INTO tte_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ana taubala iwalolau koina iba, ‘Kowa topaisowa namwanamwana yo sanasanapuna, kupaisowa namwanamwai, manene bwaite nige mane lalakina na ugitekalatan namwanamwai. Koinaele kani yapeiwo ginauli meuloili ugite-kalatagili, kulaoma kowa te yau tayaliyaya toyawa.’ ");
INSERT INTO tte_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Topaisowa iya tu tausan ikalai, ilaoma yoi iwaloba, ‘Taubala, tu tausan tauna kona kuyeyama, ugitai tabe kana etulan tu tausan yalobaiyoi, am mane meuloina powa tausan iyaelete ukwalai.’ ");
INSERT INTO tte_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ana taubala iwalolau koina iwaloba, ‘Kowa topaisowa namwanamwana yo sanasanapuna, kupaisowa namwanamwai, mane bwaite nige mane lalakina na ugite-kalatan namwanamwai. Koinaele kani yapeiwo ginauli meuloili ugite-kalatagili. Kulaoma kowa te yau tayaliyaya toyawa.’” ");
INSERT INTO tte_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Topaisowa bwaite wan tausan ikalai ilaoma koina yo iwaloba, ‘Taubala, yagu nuwatu kowa tomo kolokololona, kaiwena kowa nige kupepelipeli yo nige ukekelikeli na tomo uloili ali paisowa kanna iyawatagili na koina ukwalai na kuyasae am lakawa mena. ");
INSERT INTO tte_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kabo yamatausagiwo mwa gula yakeli bwatano mena na am mane yapulu-wadam, ugitai am mane wan tausan iyaelete ukwalai.’ ");
INSERT INTO tte_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Yo ana taubala iwalolau koina iba, ‘Kowa topaisowa naenaena yo todagela-kololo. Am nuwatu yau tomo kolokololona kaiwena nige yapepelipeli yo nige yakekelikeli na tomo uloili ali paisowa kanna iyawatagili na koina yakalai na yayasae yagu lakawa mena. ");
INSERT INTO tte_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tem am nuwatu besiele ilonamwayagiwo yagu mane wan tausan kupei benki koina siyapaisowa, na saugana yavivilama na yakele-yavivila me kana etulan siya sipaisowai kanna. Na nige ugiginauli besiele.’ ");
INSERT INTO tte_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Taubalane itagelakeile yo iwalo ana tosaguwo kolili iba, ‘Manene wan tausan wakalai koina yo kwaolena topaisowa iya ana mane mekana etulan paibi tausan koina. ");
INSERT INTO tte_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kaiwena yaiya tem mekana yauyauya kani Yaubada ietulanyoi yo ibaibaiwa. Na tem yaiya nige kana yauyauya ipapagan koina yo iya kana yauyauya kikiuna imiyamiya koina Yaubada kani ikele-gabaen mowoi. ");
INSERT INTO tte_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Topaisowa naenaena bwaite iya tolobwagabwaga, wagabaen gana muli mena boniboniyai koina yo bwaine koina kani ivalam yo mwakana iyekalasi yo ikikokiko.’” ");
INSERT INTO tte_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yeisu iwalo yoi iba, “Sauga ana kaba mwawasi koina Tomo Natuna me ana aneloseyao meuloili silaoma na iya kani iyamala kin kabo imiyasio kaba miya wasawasana koina na iloiloina. ");
INSERT INTO tte_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tomiya yanuwa yaulina meuloili kani ikele-gogonagilima simiya manna mena kabo iyakasali yo ipeili boda labui, kaba gite besiele sipi togitekalatan sipi yo gouti iyakasali na ipei-suwalagili. ");
INSERT INTO tte_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yo sipi ipeili ulaulana mena yo gouti ipeili gegebana mena. ");
INSERT INTO tte_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yo kin kani iwalolau siya simiyamiya ulaulana mena kolili iba, ‘Komiu kwalaoma, Tamagu imulolo kolimiu, kwalusae ana kaba loinane bwaine ikatububunanako kaiwemiu kaba yatubu koina. ");
INSERT INTO tte_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kaiwena yaguliyam mwa kan kwaeyama yakan yo galogalogu imagu mwa waila kwaeyama yanuma, tabe yamiya taumana mwa kwayoganiyau ami nume mena, ");
INSERT INTO tte_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","tabe yakowakowa mwa kaleko kwaeyama yalikwa, tabe yakasiebwa mwa wagite-kalatagau, tabe yamiyamiya deli mena mwa kwalaoma kwaboeyagau.’ ");
INSERT INTO tte_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Kabo todudulai kani kainana siyamaisa siba, ‘Taubala, toisabo sauga koina kagitaiwo uguliyam na kayakanwo, o nuwana galogalom imagu na waila kaeyawa kunuma? ");
INSERT INTO tte_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Toisabo sauga koina kumiya taumana na kayoganiwo, o nuwana ukowakowa na kaleko kaeyawa kulikwa? ");
INSERT INTO tte_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na toisabo sauga koina ukasiebwa kagite-kalatagiwo o kumiyamiya deli mena na kalaowa kaboeyagiwo?’ ");
INSERT INTO tte_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kani kin kainali iyamaisa iba, ‘Yawalo yawasosi kolimiu, tem tawae yabo koina tomiya-polowe yabo kwasagui ee besiele tabe yau kwasaguiyauko.’ ");
INSERT INTO tte_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Muli mena kani iwalolau siya simiyamiya gegebana mena kolili iba, ‘Kwalowasi, komiu naenaesosimiu. Kwalau mayau wedowedolina miyamiya yaina koina, bwaimwana sikatububunanako Seitani me ana aneloseyao kaiweli. ");
INSERT INTO tte_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kaiwena yaguliyam na nige kan kwaeyama, galogalogu imagu na nige waila kwaeyama, ");
INSERT INTO tte_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","yamiya taumana na nige kwayoyogan-yau, yakowakowa na nige kaleko kwaeyama, yakasiebwa na nige wagigite-kalatagau yo yamiyamiya deli mena na nige kwaboboe-yagau.’ ");
INSERT INTO tte_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Boda yauyauleline kani kainana siyamaisa siba, ‘Taubala, toisabo sauga koina kagitaiwo uguliyam o nuwana galogalom imagu yo kumiya taumana o nuwana ukowakowa o nuwana ukasiebwa o nuwana kumiyamiya deli mena na nige kasasaguiwo?’ ");
INSERT INTO tte_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kabo kani kainali iyamaisa, ‘Walo yawasosi yawalo kolimiu, nige sagu yabo kwaeyama koliyau kaiwena besiele tabe nige sagu yabo kwaolena siya tomiya-polowe kolili.’ ");
INSERT INTO tte_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Imwawasi boda yauyauleli kani silau maisa miyamiya yaina kamkamna koina na siya todudulai kani silau yawasi miyamiya yaina sikalai.” ");
INSERT INTO tte_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yeisu walo kobwaibwaili iyemwawasili kabo muli mena iwalo ana tobenaliyao kolili, ");
INSERT INTO tte_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","iwaloba, “Wakatai kaliyate labui simiyamiya kabo mwalelikwa soina kana sauga iyatubu na Tomo Natuna kani sitalamwan na siyakelose.” ");
INSERT INTO tte_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Sauganane koina topwaoli lalakili yo Yudiya ali tobagunao silogogo topwaoli lalakina Kaiyapa ana nume wasawasana koina, ");
INSERT INTO tte_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","na nuwatu siloyai yakato tem wadam mena Yeisu sikabikalatan na siunuyamate. ");
INSERT INTO tte_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Yo siwaloba, “Tabu tapapaisowai soine kana sauga kalona mena kisi boda simunamunai yo sikaleyaila.” ");
INSERT INTO tte_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yeisu iyaele Bedani koina Saimoni Lepelo ana nume mena bwaimwa tauna kona Yeisu Saimoni iwoisi, ");
INSERT INTO tte_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","kabo sine yabo ilaoma yo botolo namwanamwana ikalaiyama, kalona mena olo bwalaina namwanamwana maisana lalakina, kabo saugana Yeisu imiyasio sabi kekan sinene olone isuwai Yeisu kulukuluna mena. ");
INSERT INTO tte_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tobenaliyao sigitai kabo simunamunai, siwaloba, “Tawae kaiwena olone kuyavenuwan? ");
INSERT INTO tte_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tem olone tagimwala-yani kani mane lalakina talobai na takalai yo tobubutumao tasaguili taolegili.” ");
INSERT INTO tte_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yeisu ali edeedede ibenalan kabo iwalolau kolili iba, “Tawae kaiwena sinene kwayokoiyan? Paisowa namwanamwana bwaite ipaisowai koliyau. ");
INSERT INTO tte_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Sauga meuloina tobubutumao simiyamiya luwamiu mena na yau nige sauga meuloina mekamikava tamiyamiya. ");
INSERT INTO tte_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Sauga kikiunamo kani yaboita. Sinene olo bwalaina namwanamwana isuwai kulukulugu mena sabi peiyau salai mena kaiwena. ");
INSERT INTO tte_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yawalo yawasosi kolimiu, yanuwa yaulina meuloina koina toisabo dedei koina tem wasa namwanamwana siyawasayan, ginauline bwaite sinene ipaisowai koliyau kani siedeededeyan bwaimwa kaba nuwatu kalatanna.” ");
INSERT INTO tte_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kabo tobenaliyao yoli tuwelo luwali mena yabo esana Yudasa Isikaliota, iyawatagili ilau topwaoli lalakili kolili, ");
INSERT INTO tte_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","kabo ineli kolili iba, “Tawae kani kwaeyama tem Yeisu yaeyawa kolimiu?” Kabo mane siliba kana lalaki teti siyasili yo siwolena koina. ");
INSERT INTO tte_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Sauganane koina Yudasa iyatubu Yeisu ana lokeikeile igitagitai kaiwena nuwanuwana kamwasa iloyai na italamwan toloinao kolili. ");
INSERT INTO tte_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Beledi Gaibunamo kana kaliyate bagubagunana koina tobenaliyao silaoma Yeisu koina na sineli siba, “Toisabo dedei koina nuwanuwam mwalelikwa soina kanna kakatububunan kaiwela na takekan?” ");
INSERT INTO tte_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kainali iyamaisa iba, “Kwalau Yelusalema na tomo yabo koina kwawalo bwaite besiele, ‘Toyakayakatai iwaloba, yagu sauga ikelakubwamako. Nuwanuwagu mekaukavao yagu tobenaliyao mwalelikwa soina kanna kapaisowai am nume mena.’” ");
INSERT INTO tte_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kabo tobenaliyao sipaisowai besiele ana walo kolili na kan siginauli mwalelikwa soina kaiwena. ");
INSERT INTO tte_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Iboniyai Yeisu me ana tobenaliyao yoli tuwelo simiyasio na sikekakekan. ");
INSERT INTO tte_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kekanne luwana mena Yeisu iwalo kolili iba, “Yawalo yawasosi kolimiu, tomo yabo imiyamiya luwamiu mena kani isikotanagau yo iyauya-yagau toloinao kolili.” ");
INSERT INTO tte_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kateli mena sinuwapwanopwano lalakina kabo kaigeda kaigeda sinelineli Yeisu koina siwaloba, “Guyau, yau nigele, wa?” ");
INSERT INTO tte_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yeisu kainali iyamaisa iba, “Tomonane iya mekaukava gaeba kaigeda koina nimamai kapei iya bwaimwa kani isikotanagau. ");
INSERT INTO tte_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tomo Natuna kani iboita besiele Buki Tabu ana walo, na iya tomo bwaitete ikalomagigilan kani nuwana inae kaiwena bwaliga kani kana maisa ilalaki. Ilonamwayan tem tabu sinana ikakabi, kabo mayaune wedowedolinane lalakina kani nige ilolobai.” ");
INSERT INTO tte_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kabo Yudasa Isikaliota naga Yeisu ikakalomagigilan yo isisikotanan na iba, “Toyakayakatai, yau nigele, wa?” Yeisu iba, “Kowa kagu tokalomagigili.” ");
INSERT INTO tte_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Saugana ali kekanne koina, Yeisu beledi ikalai, ikawatoki Yaubada koina kabo ikivi na iwolena ana tobenaliyao kolili iwaloba, “Wakalai wakan, bwaite iya yogu.” ");
INSERT INTO tte_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tabe wain komwana ikalai, ikawatoki Yaubada koina kabo iwolena kolili iwaloba, “Meuloimiu kwanuma. ");
INSERT INTO tte_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Bwaite kwasinegu iya kamwasa waluwaluna. Kwasinegu kani ididi kabo tomo sibaibaiwa nuwatu-pwaiki silobai ali pwanoli kolili. ");
INSERT INTO tte_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yawalo kolimiu, wain bwaite kani nige yanunuma yoi kanasiga komiu yo yau Tamagu ana kaba loina koina tamiyamiya kabo wain waluwaluna tanuma.” ");
INSERT INTO tte_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Wali yabo siwaliyan kabo siyawatagili silau koya Olibe koina. ");
INSERT INTO tte_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yeisu iwalo kolili iba, “Boniyai bwaite koina meuloimiu kani kwayabubu-gabaegau kaiwena Buki Tabu iba, ‘Sipi kali togitekalatan kani yaunui kabo sipi sitatagwaligwali.’ ");
INSERT INTO tte_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Na yagu toloyoi mulina mena, kani yabaguna yalau Galili, muli mena kabo kwalaoma.” ");
INSERT INTO tte_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita Yeisu kainana iyamaisa iba, “Bwagana kaukavao meuloili siyabubu na yau kani nige yayabubu-gabaegiwo.” ");
INSERT INTO tte_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yeisu iba, “Yawalo yawasosi koliwo, boniyai kabona kamkam tauna kani naga ivavalam na kuuvalayagau meyaiyona.” ");
INSERT INTO tte_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita iwalo yoi koina iba, “Nigele. Nige sowasowana yauvalayagiwo nuwana tem kowa te yau taboita.” Yo tobenaliyao meuloili siwalo besiele. ");
INSERT INTO tte_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kabo Yeisu me ana tobenaliyao silau dedei bwaine esana Getesemani kabo iwalo kolili iba, “Kwamiyamiya bwaite koina na yau yalau yakawanoi bwaine koina.” ");
INSERT INTO tte_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pita yo Sebedi natunao labui iyoganli, silau mekanakavao kabo Yeisu katena ikamkamna lalakina. ");
INSERT INTO tte_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kabo iwalo kolili iba, “Kategu ikamkamna lalakina kabo kamkamnane kikiunamo itabe-yamateyau. Kwamiyamiya bwaite koina na kwasilasilawa.” ");
INSERT INTO tte_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ilogabaegili, iutulau nige kana mwayaga iyayai, kabo italu-pwaopwaom bwatano mena yo ikawanoi iba, “Tamagu, tem sowasowana kamkamna komwana tabu ilalaoma koliyau. Na tabu yau yagu nuwatu mena na kowamo am nuwatu.” ");
INSERT INTO tte_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kabo Yeisu ipileyoi ana tobenaliyao yaiyonane kolili yo igitaili sikenokeno. Iwalo Pita koina, iba, “Gubesi mwa nige sowasowamiu sauga kikiuna koina komiu te yau tasilasilawa? ");
INSERT INTO tte_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kwasilasilawa me ami kawakawanoi na tabu woya koina kwabebeku. Yaluyaluwamiu nuwanuwana, na yomiu sibelu.” ");
INSERT INTO tte_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Labuina yoi ilau ikawanoi, iba, “Tamagu, komwa bwaite genuwagu yanuma koina. Na tem am nuwatu besiele nige yabo kamwasa imiyamiya inamwanamwamo yanuma koina.” ");
INSERT INTO tte_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ipileyoi igitaiyoili nagamo sikenokeno kaiwena manli sikenokenososi. ");
INSERT INTO tte_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kabo ilogabaegili ilau yoi ikawanoi yaiyonana ana walo kaigedanamo. ");
INSERT INTO tte_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kabo ipileyoi tobenaliyao kolili yo iba, “Nagamo iyaele wakenokeno yo wakaikaiyawasi, awa? Wagitai, sauga iyawatagiliko kabo Tomo Natuna kani siyauyan siwolena tomo naenaeli kolili. ");
INSERT INTO tte_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kwatolo talau. Kagu tokalomagigili isasaema.” ");
INSERT INTO tte_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yeisu iyaelemo iedeedede kabo Yudasa Isikaliota iyawatagilima, iya Yeisu ana tobenali yabo, bwaite yoli tuwelone luwali mena. Mekanakavao boda lalakina kaleya kelepana yo kepata silokalaili. Bodane bwaite silaoma kaiwena topwaoli lalakili yo Yudiya ali tobagunao siyawasali silaoma. ");
INSERT INTO tte_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na saugana bodane sisasaema kamwasa mena, Yudasa Isikaliota kilakilala iwalowen kolili, iba, “Tem tomone yasapwali na yanisoi bwaimwa iya wakabi-kalatan.” ");
INSERT INTO tte_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kabo Yudasa idudulaimo ilau Yeisu koina, iba, “Kagu toki toyakayakatai”, yo isapwali inisoi. ");
INSERT INTO tte_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yeisu iwalo koina iba, “Eliyam, am nuwatune kaiwena kulaoma uginauli besiele.” Kabo bodane silau Yeisu koina yo sikabi-kalatan. ");
INSERT INTO tte_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yeisu ana tobenali yabo ana kaleya kelepana iniwisi-yawatagilan kaba peina mena yo topwaoli lalakina ana topaisowa tenana ikoutusi. ");
INSERT INTO tte_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kabo Yeisu, me ana yokoi, iwalo koina iba, “Am kaleya kelepana kupei yoi ana kaba miya mena kaiwena yaiya tem kelepa mena ikaleya kani siunuyamate kelepa mena. ");
INSERT INTO tte_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nuwana nige ukakatai sowasowagu yayoga Tamagu koina sagu kaiwena. Tem yayoga kani aneloseyao baibaiwasosili iyawasali silaoma na sikaleya kaiwegu. ");
INSERT INTO tte_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Na tem yaginauli besiele, nige sowasowana Buki Tabu ana walo iyamala yawasosi. Buki bwaite iwalo yakato kani iyawatagili kamwasa bwaite besiele.” ");
INSERT INTO tte_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kabo Yeisu iwalo bodane kolili iba, “Kaliyate sibaibaiwa yamiyasio Nume Tabu koina yo yayakayakatai, na nige wakakabi-kalatagau. Na sauga bwaite kaleya kelepana yo kepata kwalokalaili yo kwalaoma na wakabi-kalatagau. Yakato yau besiele toloinalikwa yabo? ");
INSERT INTO tte_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Na ginauli meuloina bwaite siyawatagili kabo palopitao ali lelelele Buki Tabu mena iyamala yawasosi.” Sauganane koina ana tobenaliyao meuloili Yeisu siyabubu-gabaen. ");
INSERT INTO tte_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bodane Yeisu sikabikalatan siyoganama Kaiyapa ana nume mena kaiwena bwaine koina loina kana toyakayakatai yo Yudiya ali tobagunao simiyagogoko. Na Kaiyapa iya topwaoli lalakili ali tobaguna. ");
INSERT INTO tte_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita Yeisu iyamuli-kusuli imuliya-molosi kanasiga iyawatagili Kaiyapa ana nume kana gana koina. Pita ilusae gana kalona mena kabo imiyasio mekanakavao topaisowao, nuwanuwana igitai tawae kani siginauli Yeisu koina. ");
INSERT INTO tte_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Yeisu iyaele nume mena yo topwaoli lalakili yo Yudiya kali tobagunao nuwanuwali lalakina tem walo mwakomwakota yabo kaikaiwena silobai na koina siyakewai na tem siwalo iboita. ");
INSERT INTO tte_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Na nige yabo silolobai, bwagana tomo sibaibaiwa silaoma yo ali walo mwakomwakota siwalowen. Muli mena tabe tomo labui yoi silaoma, ");
INSERT INTO tte_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","yo siba, “Tomone bwaite iwawalo yakato iya sowasowana Yaubada ana Nume Tabu isoke-gwaligwali yo kaliyate yaiyona kalona mena iyatoloyoi.” ");
INSERT INTO tte_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kabo topwaoli lalakili ali tobaguna itolo yo iwalo Yeisu koina iba, “Gubesi mwa kainali nige kuyayamaisa? Walo bwaite siwalowen kaiwem kana dudulai gubesi?” ");
INSERT INTO tte_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Na Yeisu itolo-mwanou. Kabo Kaiyapa iwalo koina iba, “Yaubada meyawasina esana mena, kuwalo yawasosi kolimai tem kowa Mesaiya, Yaubada Natuna, o nigele.” ");
INSERT INTO tte_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeisu kainana iyamaisa iba, “O, tawae kuwalowenne besiele. Yawalo kolimiu, sauga ilalaoma kani yau Tomo Natuna wagiteyau yamiyasio Yaubada Tokaiwesosi ulaulana mena na yaloyaloi pwatali mena yalaoma.” ");
INSERT INTO tte_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kabo Kaiyapa imunamunai kabo iboma kana kaleko itabeigali yo iba, “Tomone iboma iwaloseyan na Yaubada esana ipeiyatalu. Mwa besi, kani nige tomo taloloyaiyoili na silaoma siedeedede kaiwena. Tabenalanako ana kawasewa. ");
INSERT INTO tte_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Na ami nuwatu gubesi?” Kainana siyamaisa siba, “Ilonamwayan iboita.” ");
INSERT INTO tte_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kabo Yeisu manna sikaikaisoi yo nimali mena siunui. Tupwali sikopapali, ");
INSERT INTO tte_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","yo siba, “Tomala kowa Mesaiya? Naga kuwalo kolimai yaiya ikopapaliwone?” ");
INSERT INTO tte_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na Pita imiyasio gana kalo mena, kabo topaisowa gamasine yabo ilaoma koina yo iba, “Kowa bwaite Yeisu game Galili ana boda yabo.” ");
INSERT INTO tte_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Na tomo manli mena iuvalayan iwaloba, “Nige yakakatai tawae kuwalowalowen.” ");
INSERT INTO tte_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pita iutu-kaisulu gana kana gamwa salina mena kabo gamasine yaboyoi Pita igitai yo iwalo tomo kolili, siya simiyamiya bwaine koina iwaloba, “Tomone iya Yeisu game Nasaleta ana boda yabo.” ");
INSERT INTO tte_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita gamasinene kainana ibenalan kabo iuvalayoi. Ikawalulu yo iba, “Tomone nige yakakatai.” ");
INSERT INTO tte_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nige sauga mamalawena na tomo siya sitotolo Pita salina mena silaoma koina siwaloba, “Walo yawasosi kowa Yeisu ana boda yabo, kaiwena kainam kana dagugu iwalo-masala kowa game Galili.” ");
INSERT INTO tte_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kabo Pita ikawaluluyoi, iba, “Yawalo yawasosi, tomone nige yakakatai. Tem nige yawawalo yawasosi kani Yaubada iyamaisayau.” Sauganane koina kamkam tauna ivalam. ");
INSERT INTO tte_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kabo Pita Yeisu ana walo nuwana mena isae saugana Yeisu iba, “Boniyai kabona kamkam tauna kani naga ivavalam na kuuvalayagau meyaiyona.” Kabo Pita numene kana gana ilogabaen ikaisulu iyawatagili bakubaku mena yo me ana nuwanae ivalam. ");
INSERT INTO tte_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Malala kikiuna topwaoli lalakili yo Yudiya ali tobagunao meuloili Yeisu kana loina siginauli yakato siunuyamate. ");
INSERT INTO tte_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kabo sipan silawan siwolena Pailato koina, iya Loma tomona yabo na Yudiya ali gavana. ");
INSERT INTO tte_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yudasa, Yeisu kana tokalomagigili, saugana wasana ibenalan yakato Yudiya tobagunao siloina kani Yeisu siunuyamate, me ana nuwapolowe yo nuwana ikuwali kabo mane siliba kana baibaiwa teti (30) iyapileyoi topwaoli lalakili yo tobagunao kolili. ");
INSERT INTO tte_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Iwaloba, “Yawasosi yalopwano, kaiwena Yeisu nige ana nae yabo na yayauyan kolimiu sabi unuyamatena.” Kainana siyamaisa siwaloba, “Nige tawae yabo kolimai. Kumiyawaya, kuboma kam polowe.” ");
INSERT INTO tte_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kabo Yudasa mane igabae-luseyan Nume Tabu kalona mena mwa ilau igadosowa maina koina. ");
INSERT INTO tte_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Topwaoli lalakili mane sikalai yo siwaloba, “Mane bwaite kwasine, Yeisu ana boita maisana, kabo nige sowasowana tapei Nume Tabu manena kaba peina mena kisi Mosese ana loina talikwai.” ");
INSERT INTO tte_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mane bwaite kana loina sipaisowai kabo sikalai yo bwatano yabo siyamaisa tomiya taumana kali salai kaiwena. Mwa siyamaisa tomo yabo koina, iya gulewa kana tokabikabi. ");
INSERT INTO tte_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Iya bwaite kaiwena kanasiga kabona bwatanone esana sipei ‘Kwasine bwatanona.’ ");
INSERT INTO tte_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kabo sauganane koina palopita Yelemaiya ana walo iyamala yawasosi, kaiwena beyabeyana Buki Tabu mena iwaloba, ‘Mane bwaite kani Isileli tomoliyao sitalamwan yo tomone maisana kana lalaki siliba kana baibaiwa teti (30) sikalai, ");
INSERT INTO tte_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","yo gulewa kana tokabikabi ana bwatano siyamaisa, besiele Yaubada ana walo koliyau.’ ");
INSERT INTO tte_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yeisu itotolo Pailato manna mena iya Yudiya ali gavana kabo Pailato ineli iba, “Gubesi, kowa yakato Yudiya ali kin?” Yeisu iba, “O, besiele am walone.” ");
INSERT INTO tte_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Topwaoli lalakili yo Yudiya ali tobagunao Yeisu siyakewai, na bwagana nige ana nae ipapagan, nige yabo kainali iyayamaisa. ");
INSERT INTO tte_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kabo Pailato iwalo koina iwaloba, “Tabu kubebenalan ginauli isa kaiweli siyayakewaiwo?” ");
INSERT INTO tte_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Na Yeisu nige kikiuna kainali iyayamaisa, kabo Pailato katena ipitali mwa inuwapwanopwano. ");
INSERT INTO tte_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pailato mumugana bwaite besiele, bolime kaigeda kaigeda, mwalelikwa soina kana sauga koina, tolusae deli yabo iya tem Yudiya sigitesipwai sikawanoiyan, Pailato ilivasi yo iyawatagili deli mena. ");
INSERT INTO tte_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sauganane koina tomo yabo imiyamiya deli mena esana Balabasi, iya mumugana inaesosi kaiwena mwa wasana ilalaki. ");
INSERT INTO tte_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kabo saugana boda silogogoma, Pailato ineliyagili iba, “Yaiya nuwanuwamiu yalivasi kaiwemiu, Balabasi o nuwana tem Yeisu iya siyogayan Mesaiya?” ");
INSERT INTO tte_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailato iwalo bwaite besiele kaiwena ikatai Yeisu lamwa-polowe mena sikalaiyama koina. ");
INSERT INTO tte_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailato iyaele imiyasio kaba yatala koina kabo wainena walo iyawasa koina bwaite besiele, “Tomone nige ana nae, tabu ginauli yabo kupapaisowai koina kaiwena boniyai mena yakenowa yakenokenoi yo yasilisiliyata mwa iya kaiwena yamatausi lalakina.” ");
INSERT INTO tte_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Na topwaoli lalakili yo Yudiya ali tobagunao boda nuwali sikoi mwa bodane siwalo Pailato koina siba, “Balabasi kulivasi na Yeisu kuunuyamate.” ");
INSERT INTO tte_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pailato tomo ineliyagili iba, “Yoli labuine kolili, yaiya nuwanuwamiu yalivasi.” Kabo siwaloba, “Balabasi.” ");
INSERT INTO tte_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Kabo ineli yoi iba, “Tawae kani yaginauli Yeisu iya siyogayan Mesaiya kaiwena?” Meuloili siwaloba, “Kuyakelose. Kuyakelose.” ");
INSERT INTO tte_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pailato ineli yoi iba, “Tomone tawae ana nae?” Kabo siyoga kaikaiwe siba, “Kuyakelose.” ");
INSERT INTO tte_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailato ikatai nige tabe sowasowana kamwasa yabo iginauli, kikiunamo kaleya siginauli, kabo waila ikalai nimana ideuli boda manli mena yo iba, “Tomone ana boita kaiwena tabu kwayayakewaiyau. Kwabomamo kwaloina.” ");
INSERT INTO tte_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tomo meuloili siwaloba, “Inamwanamwa, ana boita kaiwena yakewainane ilaoma kai kolimai yo natumayao kolili.” ");
INSERT INTO tte_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kabo Pailato Balabasi ilivasi kaiweli na iwalo tokaleya yabo balae matumatuwana ikalai na Yeisu isapi. Imwawasi kabo iwolena tokaleya bodaliyaone kolili na siyakelose. ");
INSERT INTO tte_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pailato ana tokaleyayao Yeisu siyoganama nume lalakina kalona mena bwaine Gavana ana dedei mena, kabo siwalo tokaleya meuloili silogogo yo Yeisu sitolo-takikilan. ");
INSERT INTO tte_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kana kaleko silolo-gabaen kabo kaleko balabalagiyana malamalawena besiele kin kali kaleko sikalai yo siyalikwa. ");
INSERT INTO tte_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pwaopwaom samasamali sipaisowai sikalai yo sipei kulukuluna mena. Ginagina yabo sikalai yo talawasi mena sipei nimana ulaulana mena yakato iya besiele kin yabo, kabo sipwalou manna mena yo sitalatalawasiyan siwaloba, “Kamatoki kowa, Yudiya ali kin.” ");
INSERT INTO tte_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Yeisu yona mena sikaikaisoi yo ginaginane sikalai yo kulukuluna mena sikoikoi. ");
INSERT INTO tte_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Saugana ali talawasi imwawasi kabo kaleko malamalawena silolo-gabaen yo iboma kana kaleko siyalikwa. Muli mena siyoga-yawatagilan silawan sabi yakelosena. ");
INSERT INTO tte_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Saugana Yeisu siyogan ilalau kelose kaiwena, tomo yabo silobai iya Sailini tomona esana Saimon kabo siyadidiga Yeisu kana kelose ikewai. ");
INSERT INTO tte_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Siyawatagili yanuwa esana Goligota. Na Goligota kana katai bwaite, koyane kana koleya besiele tomo kulukuluna. ");
INSERT INTO tte_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bwaine koina ginauli yabo kamnana malumaluluna mekanakava oine siebweli yo siwolena koina. Kikiuna inuma-tonan kabo isikotanan nige nuwanuwana inuma. ");
INSERT INTO tte_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sipeiseyan kelose mena imwawasi, kabo tokaleyayao veku kikiuli sikalaili, venu yabo sivenuwan tem analiyao venune koina sibaguna kani Yeisu kana kwamao siwolegili kolili. ");
INSERT INTO tte_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Imwawasi kabo tokaleyayaone simiyasio na Yeisu sigitagitai. ");
INSERT INTO tte_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kabo walowa kaba yakewainawa silele sikoyapatu kelose kewana mena, lelelelene iba, “Bwaite Yeisu, Yudiya ali kin.” ");
INSERT INTO tte_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tokewali labui mekanakavao siyakeloseli, yabo ulaulana mena yo yabo gegebana mena. ");
INSERT INTO tte_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Yo tomo bodali siya silau Yeisu siloloyagiuli sikawa-naenae-yani yo kulukululi siyakwaleli, ");
INSERT INTO tte_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","yo siwalo-lamwalamwai siba, “Aaa. Beyabeyana kuwalo yakato sowasowam Nume Tabu kusoke-gwaligwali na kaliyate yaiyona kaloli mena ukwabiyoi. Sauga bwaite kubomayoi kuleboiwo. Tem kowa Yaubada Natuna kelose mena ukwaisulu.” ");
INSERT INTO tte_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tabe besiele topwaoli lalakili mekalikavao loina kana toyakayakatai yo Yudiya ali tobagunao siwalo-gagasa yo sitalawasiyan, ");
INSERT INTO tte_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","siba, “Tomo uloili ileboili na nige sowasowana iboma ileboi. Yakato iya Isileli ali kin. Iboma kelose mena ikaisuluma kabo tameliyan. ");
INSERT INTO tte_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yaubada kana meli ipei, yo tauna kona iboma kaiwena iba, ‘Yau Yaubada Natuna.’ Tem besiele tasanasana na tagitai tem Yaubada nuwanuwana ileboi o nigele.” ");
INSERT INTO tte_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tokewali mekanakavao siyakeloseli siya tabe besiele Yeisu sisinali. ");
INSERT INTO tte_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kala pwasinasina mena kanasiga tili koloki lolau yanuwa meuloina iboniboniyai. ");
INSERT INTO tte_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tili koloki ana dedei koina kabo Yeisu kainana lalakina mena iyoga iba, “Eloi eloi lama sabakitani?” Walo bwaite kana katai besiele, ‘Yagu Yaubada, yagu Yaubada, tawae kaiwena kumiya-dagedagela-yagau?’ ");
INSERT INTO tte_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tomo tupwaliyao sitotolo kainana sibenalan na sibenali-pwano kabo siwaloba, “Ilaitiya kaiwena iyogayoga.” ");
INSERT INTO tte_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sauganane koina tomo yabo luwali mena isagena balou ikalai yo iyabuta oine malumaluluna koina kabo ipei ginagina isuna mena yo manna mena iyagaseyan yakato Yeisu inuma. ");
INSERT INTO tte_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Na siya sigitagitai siwaloba, “Besi. Naga tagitai tem Ilaitiya ilaoma na ileboi.” ");
INSERT INTO tte_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yeisu iyoga yoi kainana lalakina, kabo yawasina italamwan imwawasi. ");
INSERT INTO tte_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sauganane koina kaleko tabatabana biliutusi kana gulu Nume Tabu kalona mena itaigali iyatubu kewa mena kanasiga ilobi yauli mena. Mwanikiniki iyawatagili kabo bwatano inukui yo veku lalakili silotaitaigali. ");
INSERT INTO tte_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tomo kali salai sitasoke yo Yaubada ana tomoyao siya boiboitali sibaibaiwa sitolo meyawasili. ");
INSERT INTO tte_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kali salai sitolo-gabaegili kabo Yeisu ana toloyoi mulina mena silau silusae Yelusalema yo tomo sibaibaiwa siyawatagili kolili. ");
INSERT INTO tte_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yeisu kana togitekalatanwo siya tokaleyayao yo tabe kaleya kali tobaguna, mwanikiniki kamnana silotonan yo ginauli meuloina bwaite iyawatagili sigitai, kabo simatausi lalakina yo siwaloba, “Walo yawasosi iya Yaubada Natuna.” ");
INSERT INTO tte_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Sinesineo sibaibaiwa sitolo-suwala yo manlimo ilaulau Yeisu sigitagitai. Sinesineone bwaite siya tauna kona Yeisu siyamuli-kusuli mekalikava silaoma Galili na sisagui. ");
INSERT INTO tte_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Luwali mena Meli Magidala, yo tabe ana waliesa Meli iya Yemesa yo Yosepa sinali, yo yabo tabe Sebedi natunao sinali. ");
INSERT INTO tte_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Saugana yanuwa ilolau towasawasa yabo, iya Alimadiya tomona esana Yosepa, ilaoma, iya tabe Yeisu kana tomeli yabo. ");
INSERT INTO tte_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ilau Pailato koina Yeisu yona ikawanoiyan kabo Pailato iwalo siwolena koina. ");
INSERT INTO tte_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yosepa Yeisu yona ikalai, kaleko waluwaluna koina isuma, ");
INSERT INTO tte_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","kabo ipei iboma kana salai waluwaluna kalona mena, salaine mala vekuvekuna tauna kona ikeliyako. Veku lalakina yabo iyatapipiliyama yo salai gamwana ikokausi, kabo ilogabaen. ");
INSERT INTO tte_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meli Magidala mekanakava ana waliesa simiyasio kali koleya ilaulau salai mena. ");
INSERT INTO tte_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Yanuwa ilayan yoi Satade siya Yudiya ali sabati, kabo topwaoli lalakili yo Palisi silau Pailato koina. ");
INSERT INTO tte_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Siwalolau koina siwaloba, “Taubala, kanuwatu-kalatan tomwakomwakota bwaite esana Yeisu, saugana meyawasina koina iba, ‘Kaliyate yaiyona imwawasi kabo kani yatoloyoi.’ ");
INSERT INTO tte_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mwa nuwanuwamai kuwalo tokaleyayao silau salai sigitekalatan kanasiga kaliyate yaiyona imwawasi, tem nige tagiginauli besiele kisi ana tobenaliyao silau, yona sikalai yo siwalo tomo kolili yakato itoloyoiko. Kabo walo mwakomwakota bwaite kani idebalala yo ilalaki, nige besiele baguna.” ");
INSERT INTO tte_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailato iwalo topwaoli lalakili yo Palisi kolili iba, “Inamwanamwa, yagu tokaleyayao tupwali wakalaili kwalau kwapeili salai mena sigitekalatan namwanamwai.” ");
INSERT INTO tte_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kabo silau maina yabo sikalai vekune sipan-kalatan, ali kilakilala, mwa tokaleyayao sipeili salai mena sigitekalatan namwanamwai. ");
INSERT INTO tte_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yudiya ali sabati imwawasi kabo wiki kana kaliyate bagubagunana koina, malala kikiuna Meli Magidala me ana waliesa sisulubon silau salai sabi gitaina. ");
INSERT INTO tte_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mwanikiniki lalakina inuku kaiwena Yaubada ana anelose yabo ilobima bulibuli mena ilau salai mena vekune iyatapipili-suwalan yo imiyasio pwatana mena. ");
INSERT INTO tte_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kana koleya imayamayale besiele pigabu yo kana kaleko mayamayalesosina. ");
INSERT INTO tte_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tokaleyayao siya salai sigitegite-kalatan simatausisosi mwa sitabubu kabo sibeku bwatano mena sitalu-kanitu besiele boiboitali. ");
INSERT INTO tte_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Anelosene iwalolau sinesineone kolili iba, “Tabu kwamamatausi, yakatai Yeisu kwaloyaloyai, iya siyakelose. ");
INSERT INTO tte_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Iya nige imiyamiya bwaite koina, itoloyoiko, besiele ana walo. Kwalaoma ana kaba miya wagitai bwaite koina ikenokenoya. ");
INSERT INTO tte_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kabo mwayamwayau kwalau yo ana tobenaliyao ali wasa kwaolegili kwaba, ‘Itoloyoiko boita mena, ibagubaguna ilalau Galili. Bwaine koina kani wagitaiya.’ Tawae yawalowenako kolimiu kwanuwatu-kalatan.” ");
INSERT INTO tte_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Mwa sinesineone mwayamwayau salai silogabaen, simatausi yo tabe me ali yaliyaya, kabo sisagena mwayamwayau silau na ana tobenaliyao ali wasa siwolegili. ");
INSERT INTO tte_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Silaulau kamwasa mena kabo Yeisu ilobaili iwaloba, “Kagutoki komiu.” Silaoma sitalupwaopwaom kaena sikabikalatan kabo sipwalou koina. ");
INSERT INTO tte_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yeisu iwalolau kolili iba, “Tabu kwamamatausi. Kwalau kaukavao ali wasa kwaolegili yakato silau Galili na bwaine koina kani sigitaiyau.” ");
INSERT INTO tte_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sinesineo silalau kamwasa mena kabo tokaleyayao tupwali siya salai kana togitekalatanwo sipileyoi silau Yelusalema, mwa ginauli meuloina bwaite iyawatagili siyawasayan topwaoli lalakili kolili. ");
INSERT INTO tte_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Topwaoli lalakili mekalikavao Yudiya ali tobagunao silogogo, ali loina yabo siginauli kabo mane lalakina siwolena tokaleyayaone kolili, ");
INSERT INTO tte_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","mwa siwalolau bwaite besiele siba, “Kwawalolau tomo kolili kwaba, ‘Boniyai mena kakeno-mateko na tobenaliyao silaoma Yeisu yona sikewali.’ ");
INSERT INTO tte_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tem wasane bwaite Pailato ibenalan kani kabo kawalo yakato nige nae yabo imiyamiya ami dedei mena tabu imumunamunai kolimiu.” ");
INSERT INTO tte_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kabo tokaleyayao mane sikalai yo siginauli besiele topwaoli lalakili ali walo-mwakomwakota kolili. Na tomo Yudiya walo mwakomwakota bwaite siyadebalala kanasiga kabona, yakato Yeisu ana tobenaliyao silaoma yona sikewaliyako. ");
INSERT INTO tte_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tobenaliyao yoli ileben silau Galili koya bwaite tauna kona Yeisu iwalowen kolili. ");
INSERT INTO tte_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Saugana sigitai sipwalou koina na tupwali me ali nuwa-labulabui. ");
INSERT INTO tte_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kabo Yeisu ilaoma salili mena kabo iwalo kolili iba, “Loina yo kaiwe meuloina, bulibuli mena yo yanuwa yaulina mena, Tamagu iyeyamako koliyau. ");
INSERT INTO tte_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Koinaele kwalau tomo dedei meuloina kolili kwayanuwabuili simeli na kwayababitaisoli Tamala esana mena yo Natuna yo Yaluyaluwa Tabuna yo, ");
INSERT INTO tte_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","besiele tabe loina meuloina bwaite yawalowen kolimiu kwayakayakataili na simuliya. Walo yawasosi yau mekamikava sauga meuloina kanasiga yanuwa yaulina ana kaba mwawasi.” ");
INSERT INTO tte_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Bwaite wasa namwanamwana Yeisu Keliso Yaubada Natuna wasana ana kaba tubu. ");
INSERT INTO tte_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Baguna palopita Aiseya ilelelele Yaubada ana walo iwalo-masalagili iwaloba, “Bwaite yagu tosagenawasa yayawasa ibagunawa na kaiwem kamwasa isepa.” ");
INSERT INTO tte_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Yo dedeine dekawa ule bwagabwaga mena tomo yabo kainana lalakina koina iyogayoga iwaloba, “Wakatububu Guyau ana laoma kaiwena. Ana kamwasa kwasepa yo kwayadudulai.” ");
INSERT INTO tte_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Mwa koina Yoni Toyababitaiso ilaoma dedeine dekawa ule bwagabwaga mena iguguye tomo kolili iba, “Mumugamiu naenaeli kolili kwanuwabui na yayababitaisomiu na Yaubada ami pwanoli inuwatu-pwaikili.” ");
INSERT INTO tte_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tomo meuloili dedei Yudiya yo yanuwa Yelusalema koina silaoma na tem Yoni ana guguye sibenalan. Mumugali naenaeli siwalo-masalagili na sibabitaiso waila Yolidan koina. ");
INSERT INTO tte_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yoni kana kwama ebaebai kameli wiyana yo kana wakisowa bulumakau kwapina. Yo ana kaba kekan mwalimwali yo kamwakamwa. ");
INSERT INTO tte_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yoni iguguye iba, “Iya muli mena ilalaoma ilalaki-gabaegau nige ilolonamwayagau kaena mena yapwalou yo kaekaena kana suma yalivasi. ");
INSERT INTO tte_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yau waila mena yayababitaisomiu na iya kani Yaluyaluwa Tabuna koina iyababitaisomiu.” ");
INSERT INTO tte_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sauganane koina Yeisu yanuwa Nasaleta ilogabaen, bwaine dedei Galili, na ilaoma yo Yoni Yeisu iyababitaiso waila Yolidan koina. ");
INSERT INTO tte_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yo Yeisu waila mena igayosaema yo igitesae bulibuli mena igitai bulibuli itasoke na Yaluyaluwa Tabuna kana gite besiele bunetutu ilobima koina. ");
INSERT INTO tte_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Yo kaina yabo ilobimaya bulibuli mena iba, “Kowa Natugu yamulolo lalakina koliwo yo kaiwem yayaliyaya lalakina.” ");
INSERT INTO tte_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kabo Yaubada Yaluyaluwana Yeisu iyawasa ilau dedei ule bwagabwaga leleyanna yo wedowedolina koina. ");
INSERT INTO tte_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kaliyate poti (40) kaloli mena Seitani Yeisu iwoyawoyai. Dedeinane koina ebaebai sokasokaliyao simiyamiya na aneloseyao silaoma yo Yeisu sisagui. ");
INSERT INTO tte_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Na Yoni ana lusae deli mulina mena Yeisu ilau Galili dedeina mena yo wasa namwanamwana Yaubada kaiwena iguguyeyan, iba, ");
INSERT INTO tte_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Sauga ilaomako na Yaubada ana kaba loina iyaele salimiu mena. Ami paisowa naenaeli kolili kwanuwabui na wasa namwanamwana kwameliyan.” ");
INSERT INTO tte_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sauganane Yeisu Kalita Galili busu galagalana mena iyonayona togomanao yoli labui mekanakava igitaili, Saimoni yo kanakava Anidulu, ali yagida sigalagalayan kalita mena. ");
INSERT INTO tte_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yo Yeisu iyoganlima, iba, “Kwalaoma kwamuliya koliyau na yayakataimiu na komiu kwaemala tomo kali togomanao.” ");
INSERT INTO tte_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kabo ali yagida silogabaegili yo Yeisu simuliya. ");
INSERT INTO tte_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yo tabe iyonalau yoi tupwana kabo Yemesa te Yoni igitaili, siya Sebedi natunao, waga mena ali yagida sisaisaili. ");
INSERT INTO tte_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kabo sauganane koina iyoganlima, na tamali me ana topaisowao silogabaegili waga mena na Yeisu simuliya. ");
INSERT INTO tte_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yeisu me ana bodao silaoma yanuwa Kapeneomi koina Sabati koina kabo Yeisu ilusae nume tapwalolo mena yo ana yakayakatai iyatubu. ");
INSERT INTO tte_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tomo meuloili kateli sipitali ana yakayakatai kaiwena na siba, “Yakayakatai bwaite idudulai yo kaikaiwena na nige besiele loina kana toyakayakatai ali yakayakatai.” ");
INSERT INTO tte_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na nume tapwalolone kalona mena tomo yabo imiyamiya iya yaluyaluwa biki ilusae koina kabo tomone Yeisu koina iyoga iba, ");
INSERT INTO tte_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yeisu, game Nasaleta, tawae kaiwena kulaoma kolimai? Gubesi, yakato kusiba-yanaemai? Yakataiwo, kowa Tabutabum Yaubada koina kulaoma.” ");
INSERT INTO tte_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Na Yeisu iyokoiyan iba, “Kumwanou na kuyawatagilima tomone koina.” ");
INSERT INTO tte_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kabo yaluyaluwa bikine tomone inukui me ana kaiwe yo iyawatagili me ana wui tomone ilogabaen. ");
INSERT INTO tte_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tomo meuloili kateli sipitali yo siba, “Tawae bwaite? Bwaite yakayakatai waluwaluna, tomone ana loina mena yaluyaluwa biki iloinayagili na siobigai.” ");
INSERT INTO tte_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kabo Yeisu wasana siyadebalala dedei Galili meuloina koina. ");
INSERT INTO tte_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Saugana sikaisuluma nume tapwalolo mena Yeisu me ana tobenaliyao mekalikavao Yemesa te Yoni silodudulai silau Saimoni yo Anidulu ali nume mena. ");
INSERT INTO tte_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimoni bwasiyana ikenokeno yona iwedowedoli me ana kasiebwa, kabo Yeisu nuwana mena sipei tokasiebwane kaiwena. ");
INSERT INTO tte_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yeisu ilusae koina yo nimana mena ikabilau ikeleyatolo yo ana kasiebwa imwawasi kabo sinene itolo yo ilau na kali ipaisowai. ");
INSERT INTO tte_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Dabwelo isuguko kabo tomo ali tokasiebwao yo tabe siya yaluyaluwa biki kolili sikalailima Yeisu koina. ");
INSERT INTO tte_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Na siya yanuwane tomonliyao meuloili silogogoma numene manna mena sitotolo sigitagitai Yeisu ana paisowa. ");
INSERT INTO tte_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yeisu tokasiebwao sibaibaiwa kali kasiebwa uloili uloili iwoisili. Tabe yaluyaluwa biki sibaibaiwa itao-yawatagilagili. Nige itatalam siedeedede kaiwena sikatai yaiya iya. ");
INSERT INTO tte_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Malala boniboniyaina Yeisu itolo numene ilogabaen ilau kwabu mena ibomamo imiyamiya na ikawakawanoi Yaubada koina. ");
INSERT INTO tte_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimoni mekanakavao nume mena sikaisulu silau Yeisu siloyaloyai. ");
INSERT INTO tte_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kabo silobai siwalolau koina siba, “Tomo meuloili siloyaloyaiwo.” ");
INSERT INTO tte_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yeisu iwaloba, “Talau yanuwa tupwaliyao kolili na tem tabe yaguguye bwaine koina. Kaiwena mwa yalaoma yanuwa yaulina mena.” ");
INSERT INTO tte_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kabo Galili dedeina meuloina itakikilan ali nume tapwalolo kolili iguguye yo yaluyaluwa biki tomo kolili simiyamiya itao-yawatagilagili. ");
INSERT INTO tte_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kabo tolepelo yabo ilaoma Yeisu koina tutulina italusakonayan yo ikawanoi iba, “Tem am nuwatu besiele, ukwabi-namwanamwaiyau.” ");
INSERT INTO tte_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yeisu tomone ikatekamkamna-yani yo nimana iyagayan ikabitonan yo iba, “Yagu nuwatu besiele, kunamwanamwa.” ");
INSERT INTO tte_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kabo tomone ana lepelo imwawasi yo inamwanamwa. ");
INSERT INTO tte_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Na Yeisu tomone iyawasa ilau yo iwalokausi iba, ");
INSERT INTO tte_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Tabu yaiya yabo koina kuwawalo-masalagau na kududulaimo kulau topwaoli koina kuyakenayagiwo. Imwawasi am pwaoli ukwalai besiele kala loina Mosese koina ilaoma na ugabu. Am paisowane koina kani tomo sikataiwo yakato kunamwanamwako.” ");
INSERT INTO tte_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Na tolepelone Yeisu ana walo nige imumuliya. Iyawatagili ilau tomo kolili yo tawae Yeisu ipaisowai koina ali wasa iwolegili. Mwa koina Yeisu nige sowasowana ilomayale yanuwane kolili na ilau paepaeli bwagabwaga mena imiyamiya. Na iyamo tomo dedei meuloili kolili silau koina. ");
INSERT INTO tte_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kaliyate tupwaliyao simwawasi kabo Yeisu ipileyoi Kapeneomi. Tomo meuloili wasana sibenalan yakato ipileyoimako. ");
INSERT INTO tte_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mwa boda lalakina ana nume kalona siloyapowon nige kaba miya yabo. Tabe besiele ganamuli mena. Kabo Yeisu iguguye meuloili kolili. ");
INSERT INTO tte_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tomo tupwaliyao silaoma tobelu yabo sikewai-yama, kana tokayale yoli esopali. ");
INSERT INTO tte_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Sitonan yakato tem tobelune siluseyan Yeisu koina na nige sowasowali kaiwena boda ilalakisosi. Mwa sikewai simwalisae nume pwatana mena kabo katoi sisoke-gwaligwali gula siginauli na tobelune me ana kaba keno siyalawe-lobiyen Yeisu manna mena sipei. ");
INSERT INTO tte_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yeisu tomone ali meli igitai kabo tobelune koina iwaloba, “Natugu, am naenaena meuloili yanuwatu-pwaikili.” ");
INSERT INTO tte_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na tupwali loina kana toyakayakatai Yeisu salina mena simiyamiya ana walo sibenalan na sibomamo kateli mena sinuwanuwatu bwaite besiele, ");
INSERT INTO tte_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Tomone ana walo nige inanamwanamwa. Iya nuwanuwana itonatonan tem esana ikeleisinan Yaubada mekanakava. Kaiwena nige yabo yaiya sowasowana tomo ali pwanoli inuwatu-pwaikili, Yaubadamo sowasowana.” ");
INSERT INTO tte_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Na Yeisu ali nuwatu ikatailiko mwa iwalo kolili iba, “Tabu nuwatune naenaeli katemiu mena kwanuwanuwatuili. ");
INSERT INTO tte_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Imalamalae tem tobelune koina yawaloba, ‘Am naenaena meuloili yanuwatu-pwaikili’ kaiwena bwaimwa nige mwalimwaline koliyau tem nige itotolo. Na iyamo tem yawalo koina, ‘Kutolo am kaba keno ukwalai yo kulau’ na nige itotolo kani yamwalimwaline lalakina. ");
INSERT INTO tte_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nuwanuwagu wakatai Tomo Natuna me ana loina yanuwa yaulina mena sowasowana tomo ali pwanoli inuwatu-pwaikili.” Mwa Yeisu iwalo tobelune koina, ");
INSERT INTO tte_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","iba, “Yau bwaitete yawalo koliwo, kutolo yo am kaba keno ukwalai yo kulau am yanuwa mena.” ");
INSERT INTO tte_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kabo itolo, ana kaba keno ikalai na boda manli mena ikaisulu. Boda meuloili kateli sipitali na Yaubada sitobalan siwaloba, “Yawasosi, nige sauga yabo ginauli bwaite besiele tagigitai.” ");
INSERT INTO tte_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yeisu iyawatagiliyoi ilobi Galili dekawana mena imiyamiya. Kabo boda lalakina silogogoma mwa iyakayakatai kolili. ");
INSERT INTO tte_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ana yakayakatai imwawasi kabo ilalau yo takesi totano yabo igitai ana kaba paisowa mena imiyasio imiyamiya. Tomone esana Libai na tamana Alipio. Kabo Yeisu iwalolau koina iba, “Libai, kulaoma kumuliya koliyau.” Kabo Libai itolo yo Yeisu imuliya. ");
INSERT INTO tte_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yeisu me ana tobenaliyao silau Libai ana nume mena yo bwaine koina sikekan mekalikavao takesi kana totanoyao yo tonaenaeli. Ali boda ilalaki kaiwena sibaibaiwa Yeisu simulimuliya. ");
INSERT INTO tte_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Na tupwali loina kana toyakayakatai, siya Palisiyao yawasosi, Yeisu sigitai, tonaenaeli yo takesi totano mekanakavao sikekan toyawa. Siwalo ana tobenaliyao kolili, siba, “Tawae kaiwena takesi totano yo tonaenaeli mekanakavao sikekan toyawa?” ");
INSERT INTO tte_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yeisu walo bwaite ibenalan yo iwalo kolili iba, “Tokasiebwao nuwanuwali towoiwoisi, namwanamwali nige nuwanuwali. Na yau yalaoma yanuwa yaulina mena nige todudulai kaiweli. Yalaoma tonaenaeli sabi yoganli na simuliya koliyau.” ");
INSERT INTO tte_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Na Yoni ana tobenaliyao yo tabe Palisiyao meuloili guliyam sikalakisiyeyan bwaimwa kekan silopei kaliyate isa besiele Yudiya mumugali. Tomo tupwaliyao silaoma Yeisu koina siwaloba, “Ugitai, Yoni ana tobenaliyao yo tabe Palisiyao ali tobenaliyao guliyam sikalakisiyeyan. Na am tobenaliyao nige sigiginauli besiele.” ");
INSERT INTO tte_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Kabo Yeisu kainali iyamaisa walo kobwaibwaili mena iba, “Nige sowasowana kasole kana tomanmanbubu guliyam sikalakisiyeyan tem kasole tauna mekalikava simiyamiya. Kaiwena saugana kasole tauna mekalikava meuloili sikekan yo siyaliyaya. ");
INSERT INTO tte_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Na sauga ilalaoma kasole tauna kani sikele-gabaen kolili, kabo kaliyatenane koina kani guliyam sikalakisiyeyan nuwanae kaiwena. ");
INSERT INTO tte_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yo tabe nige sowasowana tomo yabo kaleko waluwaluna tupwatupwana kwama beyabeyana koina ibwalui. Tem iginauli besiele, kaleko waluwaluna kani itabelulun kaleko beyabeyana koina na itaigali lalakina. ");
INSERT INTO tte_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tabe, nige sowasowana tomo yabo wain waluwaluna isuwai kwapi kaba suwe beyabeyali kolili. Tem iginauli besiele, kani wain waluwaluna isese isae na koina wain kwapi kaba suwene iyuigali yo wainne yo kwapi kaba suwene labuine sisibayanaeli. Bwaite nigele. Wain waluwaluna isuwai kwapi kaba suwe waluwaluli kolili.” ");
INSERT INTO tte_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabati yabo koina Yeisu me ana tobenaliyao silalau yo tano yabo koina siyawatagili kabo tobenaliyao witi kanna sikibwa na silolokekakekan. ");
INSERT INTO tte_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Palisiyao tobenaliyao sigitaili kabo siwalolau Yeisu koina siba, “Ugitai, am tobenaliyao ala Sabati kana loina silikwai.” ");
INSERT INTO tte_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Kabo Yeisu kainali iyamaisa, iwaloba, “Tomala Deibida edeededena nige kwanunuwatu-kalatan saugana me ana eliyamwao siguliyam yo nuwanuwali kan tem sikan. Yo sauganane Ebayada topwaoli lalakina ana sauga mena, Deibida ilau ilusae Yaubada ana Nume Tabu mena, yo beledi yakayakasisina ikalai ikan. Yo tabe Deibida tupwana iwolena ana eliyamwao kolili. Na wagitai. Buki Tabu nige Deibida ikakawa-naenae-yani loinane ana likwaina kaiwena. ");
INSERT INTO tte_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yaubada Sabati iyamayale tomo kaiweli, na nige iyayamayaleli Sabati kaiwena. ");
INSERT INTO tte_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Na Tomo Natuna iya ginauli meuloina kana Guyau yo tabe besiele Sabati kana Guyau.” ");
INSERT INTO tte_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sauga yabo koina Yeisu ilusae nume tapwalolo mena kabo bwaine koina tomo yabo nima belubeluna ilobai. ");
INSERT INTO tte_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tomo tupwaliyao nuwanuwali Yeisu kaba yakewaina yaina yabo silobai na tem Yeisu siyakewai mwa koina sigitegite-namwanamwai tem tomone iwoisi Sabati mena. ");
INSERT INTO tte_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yo Yeisu iwalolau tomone koina iwaloba, “Kutolo kusaema, tomo meuloili manli mena.” ");
INSERT INTO tte_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yo Yeisu ineli kana toyakewaone kolili, iwaloba, “Toisabo paisowa ilonamwayagila Sabati koina, namwanamwa tapaisowai o naenaena tapaisowai? Tomo yawasina talebo o taunuyamate?” Na iyamo nige kainali. ");
INSERT INTO tte_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kabo Yeisu me ana munamunai igitekeikeile kolili igitaili kateli sikololo. Ali yauyaule kaiwena me ana nuwapolowe kabo iwalolau tomone koina iba, “Nimam kutu.” Kabo nimana itu yo inamwanamwa. ");
INSERT INTO tte_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mwa koina Palisiyao me ali mwalimwaline yo tabe me ali munamunai siyawatagili yo Elodi ana bodao mekalikavao siloiloina gubesi na Yeisu siunuyamate. ");
INSERT INTO tte_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yeisu me ana tobenaliyao silobi Kalita Galili yo boda lalakina siyamuli-kusulili. ");
INSERT INTO tte_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tomo meuloili Yeisu ana paisowa wasana sibenalan kabo silaoma koina siya silaomaya Yudiya dedeina mena, Yelusalema taon, yo dedei Idumeya yo Waila Yolidan dedei yabo mena yo dedei Taiya yo Saidoni kolili. ");
INSERT INTO tte_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kaiwena boda ilalakisosi mwa iwalolau ana tobenaliyao kolili, waga yabo sinonowai na koina simwalisae tabu tomo siyetupatupa koina. ");
INSERT INTO tte_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Siya tokasiebwao sitonatonan nuwanuwali tem Yeisu sikabitonan na sinamwanamwa kaiwena wasana sibenalanako tomo sibaibaiwa tauna kona iwoisili. ");
INSERT INTO tte_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Yo siya tomoliyaone yaluyaluwa biki silusae kolili saugana Yeisu sigitai sibeku sitalupwaopwaom manna mena na siyogayoga siba, “Kowa Yaubada Natuna.” ");
INSERT INTO tte_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kabo Yeisu iyokoiyagili iwaloba, “Tabu kwayogayoga mayale yakato yau Yaubada Natuna.” ");
INSERT INTO tte_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yeisu isae koya mena kabo tomo siya igitesipwaili iyoganli silaoma koina. ");
INSERT INTO tte_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Yoli tuwelo igitesipwaili yo iwalo kolili, iba, “Esamiyao apositolo. Nuwanuwagu komiu te yau tamiyamiya na yayawasamiu kwalau waguguye, ");
INSERT INTO tte_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","yo tabe kaiwe mena yaluyaluwa biki tomo kolili kwatao-yawatagilagili. Bwaite kaiwena yagitesipwaimiu.” ");
INSERT INTO tte_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Siya yoli tuwelone esaliyao bwaite, Saimoni iya esana ipei Pita, ");
INSERT INTO tte_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yemesa mekanakava Yoni, siya Sebedi natunao Yeisu esali ipeili Bowanage bwaite kana bui tutu natunao kaiwena siya towalo bagubaguna yo tomunamunai, ");
INSERT INTO tte_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anidulu, yo Pilipi, Batolomiu yo Madiu bwaimwa Libai, yo Tomasi, Yemesa yabo Alipio natuna yo Tadiyasi yo Saimoni iya ilaomaya boda Selot kolili, ");
INSERT INTO tte_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","yo Yudasa Isikaliota iya naga Yeisu iwalo-masalan yo italamwan toloinao nimali mena. ");
INSERT INTO tte_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yo muli mena Yeisu ilau ilusae nume mena yo boda lalakisosina silogogoma kabo nige sowasowana Yeisu me ana tobenaliyao sikaiyawasi na sikekan. ");
INSERT INTO tte_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yeisu ana susuyao sibenalan yakato iya nige ikakaiyawasi mwa silau sabi yoganna kaiwena tomo siwalowalo yakato ikabaleya. ");
INSERT INTO tte_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Loina kana toyakayakatai tupwaliyao silobimaya Yelusalema siba, “Tomo bwaitete Bielisibubi ilusae koina yo ana kaiwe mena yaluyaluwa biki itao-yawatagilagili.” ");
INSERT INTO tte_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kabo Yeisu boda iyoganlima yo walo kobwaibwaili mena iwalo kolili, iwaloba, “Seitani nige sowasowana iya ana bodao itao-yawatagilagili. ");
INSERT INTO tte_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tem kaba loina koina tomo siyakasali na sibomamo siekalekaleya-yagili naga kaba loinane ibeku. ");
INSERT INTO tte_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tabe tem susu yabo na siwalei na sibomamo siekalekaleya-yagili naga kani sibeku. ");
INSERT INTO tte_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Seitani yo ana bodao besiele, tem mekanakavao sibomamo siekalekaleya-yagili naga ali kaba loinane sibeku yo simwawasi. ");
INSERT INTO tte_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Seitani iya besiele tomo kaikaiwena. Nige sowasowana tomo yabo ilusae tokaikaiwene ana nume mena yo ana gogo ikalaili, awa? Na tem baguna tokaikaiwene tapan-kalatan kabo sowasowana ana nume mena talusae na ana gogo takewalili. ");
INSERT INTO tte_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yawalo yawasosi kolimiu, yakato tomo ali pwanoli yo ali walo naenaena meuloina Yaubada kani inuwatu-pwaikili. ");
INSERT INTO tte_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Na iyamo tem tomo yabo Yaluyaluwa Tabuna ikawa-naenae-yani, Yaubada kani nige sowasowana inuwatu-pwaiki kaiwena tomone pwanoli miyamiya yaina iginauli.” ");
INSERT INTO tte_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yeisu walone bwaite iwalowen kolili kaiwena siya ali edeedede koina siwalo yakato yaluyaluwa biki ilusae koina. ");
INSERT INTO tte_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kabo Yeisu sinana yo kanakavao siyawatagilima. Sitolo nume ganamulina mena yo walo siyawasa na yakato Yeisu iyawatagilima kolili. ");
INSERT INTO tte_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yo boda lalakina Yeisu simiya-takikilan siwalolau koina siba, “Sinam yo kamkavao siyaele ganamuli mena nuwanuwali kowa.” ");
INSERT INTO tte_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yeisu iwalolau kolili iwaloba, “Yaiya sinagu yo analiyao kaukavao?” ");
INSERT INTO tte_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Yo siya simiya-takikilan simiyamiya imankulakulaili yo iba, “Bwaite siya sinaguwao yo kaukavao. ");
INSERT INTO tte_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yaiya tem Yaubada ana nuwatu ipaisowai iya kaukava yo dugu yo sinagu.” ");
INSERT INTO tte_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sauga yabo mena Yeisu iyatubu iyakayakatai Kalita Galili papalina mena. Kabo boda lalakisosina sitolo-takikilan mwa waga yabo koina imwalisae yo imiyasio. Na wagane ipoupouli kalita mena yo tomo meuloili siyaele dekawa mena ana yakayakatai sibenabenalan. ");
INSERT INTO tte_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Na Yeisu ginauli meuloina iyakataili walo kobwaibwaili mena iwaloba, ");
INSERT INTO tte_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Kwabenali, tomo yabo ilau tano mena patu iyasululi sabi kuma. ");
INSERT INTO tte_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Saugana patu iyasululi, tupwali sitalu-suwala silau kamwasa mena yo man silobi yo sikanli. ");
INSERT INTO tte_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tupwaliyao sitalu-suwala mala vekuveku koina yo sikin mwayamwayau kaiwena bwatano kikiuna, ");
INSERT INTO tte_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","na iyamo saugana dabwelo itunsae witi kinna igabuli yo siweweka kaiwena lamli nige bwatano tulutuluna silolobai. ");
INSERT INTO tte_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tupwaliyao sitalu-suwala samasamali luwali mena na samasamali sikin yo witi kinna sipanyamateli koina witi nige siuuwe. ");
INSERT INTO tte_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yo tupwaliyao patune sitalu-dudulai bwatano namwanamwana koina yo sikin silalaki na siuwe tupwana teti (30) yo sikisti (60) yo andeledi (100).” ");
INSERT INTO tte_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Saugana Yeisu ana edeedede iyemwawasi iwaloba, “Tem metenamiu walo bwaite kwabenalan.” ");
INSERT INTO tte_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Saugana Yeisu ibomamo imiyamiya kabo yoli tuwelo yo tomo tupwaliyao mekalikavao silaoma yo Yeisu koina sikawanoi tem ana walo kobwaibwailine ilivasi kolili. ");
INSERT INTO tte_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kabo iwalo kolili iwaloba, “Komiu Yaubada ana kaba loina kana nuwatu wadawadamna iyeyawako kolimiu na siya nige ala bodao kalona mena simiyamiya walo kobwaibwaili mena yaedeedede kolili, ");
INSERT INTO tte_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","na bwagana ‘Simanman-kulakula na iyamo nige sigigitai yo sibenabenali na iyamo nige sikakatai. Temga sikatai yo sinuwabui Yaubada koina kani ali pwanoli inuwatu-pwaikili.’” ");
INSERT INTO tte_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yo Yeisu iwaloyoi kolili, iba, “Tawae kaiwena walo kobwaibwaili bwaite kana katai nige wakakatai? Tem walo kobwaibwaili bwaite kana dudulai nige wakakatai gubesi sowasowamiu kani walo kobwaibwaili tupwaliyao wakataili? ");
INSERT INTO tte_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Toyasulu bwaimwana wasana namwanamwana iyasulu. ");
INSERT INTO tte_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tomo tupwaliyao besiele bwatanone kamwasa mena. Saugana siya wasana namwanamwana sibenalan mwayamwayau Seitani ilaoma yo walone kolili ikelegabaen. ");
INSERT INTO tte_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yo tomo tupwaliyao siya besiele patu bwatano mala vekuvekuna koina sitalu, kaiwena wasana namwanamwana sibenalan yo mwayamwayau sikalai sipei kateli mena me ali yaliyaya. ");
INSERT INTO tte_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Na iyamo wasana namwanamwana nige sinunuwatu-kalatan kaiwena lamli nige silolobi namwanamwa kabo sauga kubwakubwana koina simwawasi. Saugana tem kololo yo kamkamna silobai wasana namwanamwana kaiwena mwayamwayau silosuwala. ");
INSERT INTO tte_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tomo tupwaliyao siya besiele patu samasamali kolili sitalu kaiwena wasana namwanamwana sibenalan, ");
INSERT INTO tte_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","na iyamo yanuwa yaulina kana polowe yo wasawasa kana mwakota yo gogo kali nuwanuwatu kaiweli siloyapowonli na wasana namwanamwana sipanyamate na nige sowasowana iuwe. ");
INSERT INTO tte_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Na tomo tupwaliyao besiele patune bwatano namwanamwana koina sitalu kaiwena wasana namwanamwana sibenalan, sipei kateli mena na wasane namwanamwanane iuwe kanna tupwana teti (30), tupwana sikisti (60), tupwana andeledi (100).” ");
INSERT INTO tte_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yeisu iwaloyoi kolili iwaloba, “Tem mayale tagabu takalaiyama, gubesi, tapei gulewa yaulina mena o kaba keno yaulina mena? Nigele, tapei ana kaba take koina. ");
INSERT INTO tte_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Naga ginauli wadawadamna ipei-yawatagilan yo tabe ginauli sumasumana naga isoke-gabaen mayale mena. ");
INSERT INTO tte_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tem metenamiu walo bwaite kwabenalan.” ");
INSERT INTO tte_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yo tabe iwaloyoi kolili iba, “Tawae kwabenalan kwanuwatu namwanamwa kaiwena. Mumugane waginaginauli kamikavao kolili kani Yaubada iginauli kolimiu besiele na iyamo ietulanyoi kolimiu. ");
INSERT INTO tte_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yaiya me ana katai Yaubada kaiwena Yaubada kani ietulan. Yo yaiya nigele koina na tawae kikiunamo koina Yaubada kani ikelegabaen.” ");
INSERT INTO tte_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yo Yeisu iwaloyoi iwaloba, “Yaubada ana kaba loina besiele tomo yabo witi patuna iyasululi ana tano mena. ");
INSERT INTO tte_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Iboniyai tomone ikeno yo kaliyate itolo na patune sikinkin nige ikakatai gubesi ali kinkin. ");
INSERT INTO tte_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Baguna patune iboma ikin bwatano mena kinna itupasae yo muli mena liguna ipei yo iuwe. ");
INSERT INTO tte_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Saugana kanna imatuwa ana kelepa ikalai ilau witi itomli kaiwena kelikeli kana sauga.” ");
INSERT INTO tte_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yeisu iwaloyoi iwaloba, “Tawae tem tawalowen Yaubada ana kaba loina gubesi kana koleya? Toisabo kaba gite tawalo-lawani na koina sikatai? ");
INSERT INTO tte_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Bwaite besiele, mayau ketabu koina yawalo-lawani kaiwena ketabu patuna ikikiusosi, ");
INSERT INTO tte_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","na tem takumai na ikin iyamala mayau lalakisosina yo lagalaganao silalaki mwa lolonna mena man sikabinoi.” ");
INSERT INTO tte_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Walo kobwaibwaili sibaibaiwa bwaite besiele Yeisu iwalowegili yo kolili iedeedede tomo ali katai kana lalaki koina. ");
INSERT INTO tte_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Iya sauga meuloina walo kobwaibwaili mena iedeedede tomo kolili. Na iyamo tem sauganane sibomamo me ana tobenaliyao walo kobwaibwaili kali katai meuloili ilivasili kolili. ");
INSERT INTO tte_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kaliyatenane koina lolau molosi dabwelo isuguko Yeisu iyaele waga mena kabo iwalo ana tobenaliyao kolili iba, “Takuke talopanaisi dedei yabo mena.” ");
INSERT INTO tte_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yo tobenaliyao tomo silogabaegili, yo silobi simwalisae wagane koina, mekalikava sikuke. Mekalikavao waga tupwali sikuke toyawa. ");
INSERT INTO tte_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kabo wowoli lalakina silobai yo tabe bagolu isuwesuwelikwa waga mena masa kikiunamo waga ipowon yo isalili. ");
INSERT INTO tte_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yeisu waga talamuliyena mena kana kulule ipei mwa ikenomateko. Ana tobenaliyao siyanoi siba, “Toyakayakatai, nige kunuwanuwatu tem tasalili?” ");
INSERT INTO tte_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kabo Yeisu itolo yo iwalolau yaumai koina iba, “Kulopei.” Yo iwalolauyoi bagolu koina iba, “Kudaumwali.” Yo yaumai ilopei yo sowasowaga idaumwali. ");
INSERT INTO tte_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yo iwalo ana tobenaliyao kolili iba, “Tawae kaiwena kwamatausi? Tomala iyaelemo naga kwamemeli?” ");
INSERT INTO tte_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yo tobenaliyao simatausi lalakina yo siyenelineli-yagili siba, “Toisabo tomo bwaitete? Ginauli meuloina kainana sibenalan yo tabe besiele yaumai yo bagolu.” ");
INSERT INTO tte_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yeisu me ana tobenaliyao silopanaisi yo siulisi tomo Gelasa ali dedei mena. ");
INSERT INTO tte_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Saugana Yeisu ikaisuluma waga mena tomo yabo yaluyaluwa biki koina igitai. Na tomone bwaite ana kaba miya veku gulana mena, na nige sowana yabo ipan-kalatan bwagana tem seni koina sipan. Sauga meuloina nimana yo kaena sipanli seni mena na iyamo nimana mena iutusili yo seni kaena mena igoluli. Nige tomo yabo kaikaiwena sowasowana ikabikalatan. Kaliyate yo boniyai ilolokeikeile salai mena yo putete mena iyogayoga-keikeile yo veku matamatageli ikalaili ibomayoi yona inigwanigwai. Kabo tomone kelamamalawe mena isagenama Yeisu manna mena tutulina italu-sakonayan yo ipwalou. ");
INSERT INTO tte_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Kabo Yeisu iwalo yaluyaluwa bikine koina iba, “Tomone bwaite koina kuyawatagilima, kowa yaluyaluwa biki.” Mwa koina yaluyaluwa bikine iyoga kaiwe iba, “Yeisu, Yaubada Tomiyasaesosi Natuna, tawae nuwanuwam uginauli koliyau? Ukawalulu Yaubada esana mena na tabu kuyayakamkamnayau.” ");
INSERT INTO tte_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yeisu ineli koina iba, “Kowa esam?” Kabo kainana iyamaisa iba, “Yau esagu Boda kaiwena kabaibaiwa tomo bwaite kalona mena kamiyamiya.” ");
INSERT INTO tte_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ikawanoi samasamalulu Yeisu koina yakato tabu dedei bwaite koina imamalimaliu-wagili. ");
INSERT INTO tte_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na putetene salina mena polo sibaibaiwa sidumudumuli. ");
INSERT INTO tte_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kabo yaluyaluwa bikine sikawanoi Yeisu koina siba, “Kutalamwagimai na kalau kalusae polone kolili.” ");
INSERT INTO tte_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yeisu italam kabo yaluyaluwa bikine siyawatagili tomone koina yo silau silusae polone kolili. Kabo polo gwauli kali baibaiwa tu tausani sisagena silobi mala naenaena mena sibeku na sigalomwasi kalita mena. ");
INSERT INTO tte_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Polo togitekalatan sisagena silau yanuwa lalakili yo yanuwa kikiuli kolili yo ginauli meuloina siwalo-masalagili tomo kolili. Kabo tomo meuloili silaoma na manli mena sigitai tawae iyawatagili. ");
INSERT INTO tte_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Saugana siyawatagilima Yeisu koina tomone sigitai, iya baguna yaluyaluwa biki bodaliyao silusae koina, imiyasio imiyamiya mekana kwama yo kulukuluna idudulaiko kabo meuloili simatausi me ali nuwa pwanopwano. ");
INSERT INTO tte_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Siya Yeisu ana paisowa sigitai siwalo-masala tomo meuloili kolili tawae iyawatagili tokabaleyane koina yo siedeedede gubesina polo siboita. ");
INSERT INTO tte_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kabo tomo meuloili siyatubu sikawanoi-samasamalulu Yeisu koina tem ali dedeine ilogabaen. ");
INSERT INTO tte_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yeisu ana sauga mwalisae tomone iya Yeisu iwoisi ilau koina ikawanoi tem mekanakava silau. ");
INSERT INTO tte_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Na Yeisu nige itatalam yo iba, “Kuvivila kulau am susuwo kolili yo ali wasa kuwolena tawae Yaubada iginauli koliwo yo gubesina ana katekamkamna koina iwoisiwo.” ");
INSERT INTO tte_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kabo tomone ilau Dekapoliya bwaimwa esana labuina Yanuwa Sanaulu na iyatubu iedeedede tawae Yeisu iginauli koina. Yo tomo meuloili sibenalan yo kateli ipitali. ");
INSERT INTO tte_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yeisu me ana tobenaliyao sikuke silopanaisiyoima siulisi. Saugana Yeisu ikaisulu busu galagala mena boda lalakina silaoma yo sitolo-takikilan. ");
INSERT INTO tte_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tomo yabo esana Yailo, iya tapwalolo kana tobaguna yabo, ilaoma. Saugana Yeisu igitai, ilau manna mena tutulina italu-sakonayan, ");
INSERT INTO tte_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","na ikawanoi samasamalulu iba, “Taubala, natugu sinena ana bolime tuwelo ikasiebwa lalakina masa kikiunamo iboita. Nuwanuwagu talau nimam kupei koina na inamwanamwa ana kaiwe ilobai.” ");
INSERT INTO tte_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kabo Yeisu mekanakava silau. Yo boda lalakina simulimuliya na siyetubatubali. ");
INSERT INTO tte_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na bodane luwali mena sine yabo me ana kasiebwa, kwasine ididididi bolime tuwelo na iyamo naga medidina. ");
INSERT INTO tte_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Beyabeyana towoiwoisi meuloili kolili ana mane meuloina iyemwawasi na kasiebwane nige imwamwawasi, na kamkamna ietuetulan. ");
INSERT INTO tte_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Saugana Yeisu wasana ibenalan isaema mulina mena boda luwali mena, inuwanuwatu bwaite besiele, “Tem kana kalekomo yakabitonan kani yanamwanamwa.” Kabo sinene Yeisu kana kaleko ikabitonan. Sauganane koina kwasine ana didi imwawasi yo kamnana ilotonan kana kamkamna yona mena imwawasiko. ");
INSERT INTO tte_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mwayamwayau Yeisu ilotonan ana kaiwe tupwana iyawatagili koina. Itagelakeile yo bodane ineliyagili iba, “Yaiya kau kaleko ikabitonan?” ");
INSERT INTO tte_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ana tobenaliyao siwaloba, “Ugitaiyako boda siutu-takikilagiwo na kowa kuneli, ‘Yaiya ikabitonagau?’” ");
INSERT INTO tte_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Na iyamo Yeisu igitekeikeile na iloyaloyai yaiya kana kaleko ikabitonan. ");
INSERT INTO tte_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Sinene ikatai tawae iyawatagili koina yo me ana matausi yo me ana tabubu ilaoma italumiyasio Yeisu manna mena yo tawae iyawatagili koina yo tawae iginauli meuloina iwalo-masalan Yeisu koina. ");
INSERT INTO tte_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yeisu iwalolau sinene koina iba, “Natugu, am meli iwoisiwo, kulau me am yaliyaya. Kasiebwane kani nige ilalauyoiwa koliwo.” ");
INSERT INTO tte_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yeisu iyaelemo iedeedede sinene koina kabo tomo tupwali Yailo ana nume mena wasa silawanama siba, “Natum iboitako. Nige sowasowana toyakayakatai ana sauga kuyavenuwan.” ");
INSERT INTO tte_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yeisu tomone ali walo ibenalan yo nige ana nuwatu ilalau kolili na iwalolau Yailo koina iba, “Tabu ukakatewakaka na kumelimo koliyau.” ");
INSERT INTO tte_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yo Yeisu bodane ikausili tabu silalau mulili mena bwaimwanamo ana tobenaliyao yoli yaiyona mekanakavao Pita, Yemesa yo kanakava Yoni. ");
INSERT INTO tte_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Saugana silaoma Yailo ana nume mena Yeisu igitai tomo me ali nuwa pwanopwano. Sivalavalam yo sitalatala-wauwau lalakina. ");
INSERT INTO tte_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yeisu ilusae yo iwalo kolili iba, “Gubesi, tawae kaiwena kwavalavalam na kwatalatala-wauwau? Gamasinene nige iboboita ikekenomo.” ");
INSERT INTO tte_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Na Yeisu ana walo kaiwena simalumaluwan. Yo Yeisu bodane itawoili siyawatagili ganamuli mena. Gamasine tamana yo sinana yo tobenaliyao yoli yaiyona iyoganli na Yeisu mekalikava silusae gamasinene ana biliutusi mena. ");
INSERT INTO tte_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yeisu gamasinene nimana mena ikabilau iba, “Talita Kumi.” na kana bui “Gamasine, kutolo.” ");
INSERT INTO tte_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kabo gamasinene boita mena itoloyoi yo ilokeikeile na kateli sipitali me ali nuwapwanopwano. ");
INSERT INTO tte_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yeisu iwalo kolili iba, “Tabu yaiya yabo koina kwawawalo-masala yagu paisowa bwaite kaiwena.” Kabo muli mena iwalo kolili, “Gamasinene kana kwaolena.” ");
INSERT INTO tte_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yeisu yanuwane ilogabaen yo me ana tobenaliyao sipileyoi iya iboma ana yanuwa mena. ");
INSERT INTO tte_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabati mena ilusae nume tapwalolo mena yo iyatubu iyakayakatai yo tomo meuloili kateli sipitali ana katai kaiwena yo siba, “Tomo bwaitete toweya koina ana sonoga ilobaiya na gubesi tabe ginauli kaba nuwapwanopwano nimana mena ipaisowaili? ");
INSERT INTO tte_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tomo bwaite iya tokamda. Iya Meli natuna yo kanakavao Yemesa, Yosesi, Yudasa, Saimoni yo tabe dunao mekalakavao tamiyamiya.” Mwa koina tomo Nasaleta Yeisu sisikotanan. ");
INSERT INTO tte_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Na Yeisu iwalo kolili, iwaloba, “Tomo meuloili palopita siyakasisiyan na ana susuwo yo totounao yo ana yanuwa tomoliyao siya nige siyayakasisiyan.” ");
INSERT INTO tte_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Bwaine koina Yeisu nige sowasowana ginauli kaba nuwapwanopwano ipaisowaili bwaimwanamo tokasiebwa tupwaliyaomo nimana ipei kolili na iwoisili. ");
INSERT INTO tte_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yeisu katena ipitali lalakina kaiwena nige simemeli koina. Kabo Yeisu itakikili yanuwa kolili tomo iyakayakataili. ");
INSERT INTO tte_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tobenaliyao yoli tuwelo iyoganlima yo iyawasali labui labui silau. Yo tabe kaiwe iwolegili mesabana sowasowali yaluyaluwa biki tomo kolili sitao-yawatagilagili. ");
INSERT INTO tte_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kabo kali loina iwolegili iba, “Tabu ginauli yabo wakakalai ami laune koina, tabu kanale nuwana tobwa, nuwana mane poketi mena, bwaimwanamo ami sige nimamiu mena. ");
INSERT INTO tte_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yo kaemiu kana suma kwalikwa na tabu kwama labui wakakalaili. ");
INSERT INTO tte_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tem toisabo nume koina siyoganmiu na kwalusae numene koina kwamiya-taumana kanasiga yanuwane kwalogabaen. ");
INSERT INTO tte_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tem yanuwa yabo tomoliyao nige siyoyoganmiu ali nume mena tabe nige ami guguye sibebenalan yanuwane kauna kaemiu mena wakotata-yagili na kwalogabaegili. Tem bwaite kilakilalane sigitai kani sikatai Yaubada nige iyayaliyaya kolili.” ");
INSERT INTO tte_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yeisu ana walo iyemwawasi kabo tobenaliyao siyawatagili silau na siguguye tomo kolili bwaite besiele siba, “Mumugamiu naenaeli kwasikotanagili na kwanuwabui.” ");
INSERT INTO tte_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yaluyaluwa biki sibaibaiwa tomo kolili sitao-yawatagilagili yo tokasiebwa sibaibaiwa olo koina yoli mena sisauli yo siwoisili na sinamwanamwa. ");
INSERT INTO tte_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","29","Tauna kona Kin Elodi, Yudiya ali kin, kanakava Pilipi wainena Elodiyasa ikwayai mwa ikasolanan. Kabo Yoni Toyababitaiso iwalo Elodi koina iba, “Nige sowasowana kamkava wainena ukwasolanan.” Bwagana Yoni ana walo kaiwena nuwana ipwanopwanowan na Elodi nuwanuwana tem sauga meuloina ana walo meuloina ibenabenalan. Kaiwena ikatai Yoni iya tomo dudulaina yo Yaubada ana topaisowa yabo kabo iyakasisiyan. Na Elodiyasa imunamunai lalakina Yoni ana walo kaiwena mwa nuwanuwana Yoni iunuyamate. Elodi genuwana Elodiyasa Yoni iunuyamate mwa ana topaisowa iyawasali silau Yoni sikabikalatan, sipan yo sipei deli mena yo bwaine koina igite-kalatan. Mwa Elodiyasa nige sowasowana Yoni iunuyamate. Na Elodi ana sauga kabi kaliyatena iyawatagili kabo Elodiyasa kamwasa inuwatu-lobai Yoni unuyamatena kaiwena. Sauga kabi kana nuwatu-kalatan kanna siginauli, yo tupwali taumana siyoganlima kekan kaiwena. Taumanaone siya toloinao lalakili gabeman koina yo tokaleyayao kali tobagunao na tupwali Galili dedeinao ali tautaubalao. Sauganane koina mekana taumanao sikekan, Elodiyasa natuna sinena ilusaema manli mena yo iselo. Ikabi-yaliyaya-yagili yo Elodi gamasinene koina iwalo iba, “Tawae nuwanuwam ukawanoiyan koliyau na yaeyawa.” Yo tabe iwaloyameli kawalulu mena iba, “Yawalo yawasosi koliwo tawae nuwanuwam kani yaeyawa bwagana tem yagu kaba loina tupwana ukawanoiyan.” Yo gamasinene iyawatagili ilau sinana koina ineli iba, “Tawae yakawanoiyan?” Na sinana iba, “Ukwawanoiyan Yoni Toyababitaiso kulukuluna kaiwena.” Yo gamasinene mwayamwayau ipileyoi Kin koina iba, “Nuwanuwagu bwaite sauga Yoni Toyababitaiso kulukuluna kutom, gaeba mena kutauli na kuyeyama.” Elodi inuwa-polowe lalakina, na iyamo nige sowasowana isikote kisi imwalimwaline kaiwena iwaloyameli kawalulu mena taumanao manli mena. Kabo Elodi tounuyamate yabo iyawasa na ilau deli mena Yoni galogalona itom. Yo kulukuluna gaeba mena itauli, ikalaiyama gamasinene iwolena yo ikalai ilawan sinana koina. Yoni ana tobenaliyao ana boita wasana sibenalan kabo silaoma Yoni yona sikalai sipei salai mena. Mulina mena Yeisu ana paisowa wasana idebalala kabo Kini Elodi wasanane ibenalan. Tomo tupwaliyao siwalo yakato Yeisu iya Ilaitiya yo tomo tupwaliyao tabe siwalo yakato iya palopita yabo besiele baguna palopitao. Na tupwaliyao yoi siedeedede siba, “Tomone bwaite nuwana iya Yoni Toyababitaiso, nuwana boita mena itoloyoima, kaiwena Yoni ana kaiwe iyaele koina yo bwaite kaiwena sowasowana ginauli kaba nuwapwanopwano ipaisowaili.” Saugana Elodi walone bwaite ibenalan iba, “Walo yawasosi, tomone bwaimwa iya Yoni Toyababitaiso baguna galogalona yatom na boita mena itoloyoima.” ");
INSERT INTO tte_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yo siya tobenaliyao yoli tuwelo iyawasali tauna koina sabi guguye sipileyoima Yeisu koina ali paisowa yo ali yakayakatai meuloina siwalo-masalagili koina. ");
INSERT INTO tte_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Boda lalakina silaolaoma koina yo tabe sipilepileyoi na nige sowasowali sikaiyawasi yo sikekan. Mwa iwalolau kolili iba, “Talau dedei paepaeli mena na tupwana wakaiyawasi.” ");
INSERT INTO tte_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mwa sibomamo waga yabo koina simwalisae sikuke silau siulisi paepaeli bwagabwaga mena. ");
INSERT INTO tte_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Na saugana sikuke-yawatagili tomo sibaibaiwa sigitaili yo sikatai yakato siya Yeisu me ana tobenaliyao. Kabo siya silaomaya yanuwa mena kaeli mena sisagena silau siyawatagili baguna dedeine Yeisu me ana tobenaliyao silalau koina. ");
INSERT INTO tte_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Saugana siulisi Yeisu ikaisulu dekawa mena yo boda lalakina igitaili yo ikatekamkamna-yagili kaiwena siya besiele sipi nige kali togitekalatan. Mwa koina iyatubu iyakayakatai ginauli sibaibaiwa kolili. ");
INSERT INTO tte_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Yo lolau mena ana tobenaliyao silaoma koina siwalo siba, “Taubala, dedei bwaite paepaeli bwagabwaga na iyaele dabwelo isusugu. ");
INSERT INTO tte_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tem bodane bwaite kuyawasali silau yanuwane salili mena sowasowali kali sigimwala.” ");
INSERT INTO tte_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Na Yeisu iwaloba, “Komiu kan kwaolegili sikekan.” Na ana tobenaliyao siwaloba, “Nige sowasowamai, tem kaginauli besiele kani mane lalakina besiele waikena eit (8) kana maisa kagabaen kaiwena boda ilalakisosi.” ");
INSERT INTO tte_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mwa Yeisu iwalolau ana tobenaliyao kolili iba, “Isa beledi kolimiu? Kwalau kwaloya.” Saugana silobaili siba, “Beledi valigigi yo iye labui kalobaili.” ");
INSERT INTO tte_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yeisu iwalolau ana tobenaliyao kolili iba, “Boda kwayakasali na simiyasio kawasi pwatana mena.” ");
INSERT INTO tte_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kabo bodane simiyasio kali boda kolili boda tupwali andeledi (100) yo tupwali pipti (50). ");
INSERT INTO tte_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Na beledi valigigi yo iye labui ikalaili kabo isakaisae bulibuli mena ikawatoki Yaubada koina kanne kaiweli yo muli mena beledi itabe-kivikivi iwolegili ana tobenaliyao sisoiyagili tomo kolili. Tabe besiele iye itabe-kivikivi yo ana tobenaliyao iwolegili sisoiyagili. ");
INSERT INTO tte_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Meuloili sikekan diyali sisu. ");
INSERT INTO tte_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Yo ali kantele tobenaliyao sitano-gogonagili beledi yo iye tupwatupwali kodo tuwelo. ");
INSERT INTO tte_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Siya tatao tokekan kali baibaiwa besiele paibi tausan. ");
INSERT INTO tte_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kabo muli mena Yeisu ana tobenaliyao iwalo waga mena simwalisae yo sikuke sibaguna Betesaida, na iya bodane iyawasali sipileyoi ali yanuwa mena. ");
INSERT INTO tte_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kabo ilogabaegili ikawasae koya mena sabi kawanoi. ");
INSERT INTO tte_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Saugana dabwelo isugu waga dumwakali luwaluwalina mena ikalakalau na iya ibomamo imiyamiya koya mena. ");
INSERT INTO tte_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Igitaili siwose boita yoli sisawosawowoli kaiwena yaumai manli mena ilaolaoma. Yanuwa sabi layalayanna Yeisu kalita pwatana mena ilalaoma kolili. Iyawatagili salili mena na kikiunamo ilogabaegili. ");
INSERT INTO tte_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Na sauganane Yeisu sigitai kalita pwatana mena ilaulau sibatoko iya kalukaluwa. Kabo siwui, ");
INSERT INTO tte_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kaiwena meuloili sigitai yo simatausi. Kabo Yeisu iwalo kolili iba, “Wakatepatu, yau ami taubala, tabu kwamamatausi.” ");
INSERT INTO tte_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yo waga mena imwalisae mekanakavao yo yaumai ilopei idaumwali. Yo tobenaliyao kateli sipitali lalakina me ali nuwa pwanopwano, ");
INSERT INTO tte_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kaiwena saugana beledine yo iyene ietulanli nige sikakatai gubesi Yeisu ana kaiwe. Ali katai iyoviya. ");
INSERT INTO tte_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Silopanaisi dedei Genasaleta koina siulisi, galowa mena silo. ");
INSERT INTO tte_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Saugana sikaisulu waga mena tomo Yeisu sikilala. ");
INSERT INTO tte_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kabo sisagena silau yanuwa meuloili kolili tokasiebwa kaba keno kolili sikalailima silawagili toisabo dedei koina sibenalan Yeisu imiyamiya. ");
INSERT INTO tte_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yeisu itakikili dedei meuloina kolili, yanuwa lalakili yo yanuwa kikiuli, yo dedei ganamuli mena. Tomo meuloili ali tokasiebwa sikalailima yo kaba gimwala kolili sipeili na Yeisu sisanasanai. Sikawanoiyan yakato tem tokasiebwao kana kwama sopanamo sikabitonan. Yo meuloili tokasiebwa siya kana kwama sikabitonan sinamwanamwa. ");
INSERT INTO tte_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Palisiyao yo loina kana toyakayakatai tupwali mekalikavao silaomaya Yelusalema silau Yeisu koina na simiya-takikilani, ");
INSERT INTO tte_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","sigitagitaili Yeisu ana tobenaliyao sikekakekan nige nimaliyao sidedeulili besiele Yudiya ali tapwalolo kana loina. ");
INSERT INTO tte_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kaiwena Palisiyao, yo besiele Yudiya meuloili, nige sowasowana sikekan kanasiga nimaliyao sideulili besiele mumugali ilaomaya tubuliyao kolili. ");
INSERT INTO tte_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Besiele tabe saugana Yudiya kaba gimwala silogabaen na sipileyoi ali nume mena nige sowasowana sikekan kanasiga sisugu, kabo sikekan. Yaboyoi loina meuloina tubuliyao kolili gaeba yo komwa yo gulewa yo kaba keno kali deuli kaiweli simuliya. ");
INSERT INTO tte_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mwa Palisiyao yo loina kana toyakayakatai Yeisu koina siwalolau siba, “Ugitai, am tobenaliyao tubulao ali loina nige simumuliya nabesimo menima dumdumli sikekan.” ");
INSERT INTO tte_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yeisu kainali iyamaisa iwaloba, “Komiu tomwakomwakota. Baguna Aiseya palopita kaiwemiu iwalo yawasosi saugana Yaubada ana walo ilele bwaite besiele. ‘Tomo bwaitete sopali mena siyakasisiyagau na iyamo kateli imiya kelamamalawe koliyau. ");
INSERT INTO tte_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ali tapwalolo koliyau ginauli bwagabwaga kaiwena ali yakayakatai siya besiele tomo ali loina.’” ");
INSERT INTO tte_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tabe Yeisu iwaloyoi kolili iba, “Walo yawasosi, komiu Yaubada ana loina kwasikotanagili na tubumiyao mumugali wakabi-kalatagili. ");
INSERT INTO tte_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ami sonoga mena Yaubada ana loina kwapei-suwalagili na mesabana tubumiyao mumugali wakabi-kalatagili. ");
INSERT INTO tte_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kaiwena baguna Mosese iwalo iba, ‘Tamam yo sinam kuyakasisiyagili.’ Tabe iwaloyoi iba, ‘Tem yaiya tamana nuwana sinana ikawa-naenae-yagili kani siunuyamate.’ ");
INSERT INTO tte_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Na komiu ami yakayakatai mwakomwakota bwaite besiele. Tem tomo yabo tamana yo sinana nige isasaguili na iwalolau kolili iwaloba, ‘Bwaite gogone yatalamwanako Yaubada koina mwa yakayakasisina na nige sowasowana yasaguimiu,’ kabo tomone ana walo wakawa-namwanamwa-yani. ");
INSERT INTO tte_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mwa kamwasane koina Yaubada ana walo kwasoke-gabaen na tubumiyao mumugali koina kwayamiyalae. Yo ginauli sibaibaiwa waginaulili bwaite besiele.” ");
INSERT INTO tte_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kabo boda iyoganyoilima yo iwalolau kolili, iwaloba, “Meuloimiu kwabenali, na wakatai namwanamwai. ");
INSERT INTO tte_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tawae takan nige sowana tomo ikabi-yabikila. Na tawae katela mena iyawatagilima sowasowana sikabi-yabikila. ");
INSERT INTO tte_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tem yaiya metenana walo bwaite ibenalan namwanamwai.” ");
INSERT INTO tte_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yeisu me ana tobenaliyao boda silogabaegili yo nume mena silusae yo ana tobenaliyao sineli koina siwaloba, “Sowasowana am walo kobwaibwailine kulivasi kolimai?” ");
INSERT INTO tte_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yeisu iwalo kolili iwaloba, “Komiu tonuwapwanopwano. Nuwana nige wakakatai yakato tawae takan yo ilusae diyala mena nige sowana ikabi-yabikila. ");
INSERT INTO tte_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kaiwena nige katela mena ilalau na ilusae diyala mena muli mena ilau mosomoso koina.” Yeisu ana yakayakatai bwaite kana katai besiele yakato kana tomeliwo meuloili sowasowali kan meuloina sikekan na nige sowana kanne ikabiyabikili. ");
INSERT INTO tte_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yo Yeisu iwaloyoi iba, “Tem tawae tomo kateli mena iyawatagilima sowasowana tomone ikabi-yabikili. ");
INSERT INTO tte_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kaiwena bwaite besiele, nuwatu naenaeli, ganawali, kewali, tomo kana unuyamate, ");
INSERT INTO tte_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","mankikiwasi, mwakota, yauyaule mumugana, lamwapolowe, sinali, nuwasaesae yo nuwatu bwagabwaga siya silaomaya tomo kateli mena. ");
INSERT INTO tte_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Bwaite ginauline naenaeline tomo kaloli mena siyawayawatagilima yo sikabi-yabikili.” ");
INSERT INTO tte_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yeisu yanuwane ilogabaen yo ilau Taiya salina mena yo nume yabo koina ilusae, yo nige nuwanuwana tomo sikatai iya bwaine koina, iyamo nige sowasowana ikeno-wadam, ana laune tomo sikataiyako. ");
INSERT INTO tte_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kabo sine yabo, natuna sinena yaluyaluwa biki ilusae koina, saugana Yeisu ana laoma wasana ibenalan mwayamwayau ilaoma Yeisu koina. ");
INSERT INTO tte_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Na bwaite sinene nige sine Yudiya na iya sikabi yanuwa Pinisiya koina Siliya ana dedei mena. Kabo ikawanoi Yeisu koina yakato tem yaluyaluwa bikine natuna koina itao-yawatagilan. ");
INSERT INTO tte_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yeisu iwalolau koina iba, “Baguna gagagili, siya yagu susu Yudiya, yayakanli. Nige sowana kali yakalai yagabaen bwauwa kolili.” ");
INSERT INTO tte_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Na sinene kainana iyamaisa iwaloba, “Taubala, walo yawasosi, na iyamo bwauwa besiele teibeli yaulina mena nuwanuwali gagagili kali mumuli kolili sikekan.” ");
INSERT INTO tte_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yeisu iwaloba, “Am walo-maisana kaiwena kupileyoi am nume mena, yaluyaluwa bikine natum koina ilogabaenako.” ");
INSERT INTO tte_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kabo sinene itolo yo ipileyoi ana nume mena yo natuna ilobai ana kaba keno mena na yaluyaluwa bikine ilogabaenako. ");
INSERT INTO tte_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kabo Yeisu Taiya dedeina ilogabaen ilau Saidoni, ilogabaen ilobi Kalita Galili dedeina yo ilusae Dekapoliya bwaimwa esana labuina Yanuwa Sanaulu. ");
INSERT INTO tte_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Yo bwaine koina tomo yabo silawanama Yeisu koina iya totenakola tabe nige sowasowana iedeedede. Yeisu sikawanoiyan yakato nimana ipei koina. ");
INSERT INTO tte_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yeisu bodane luwali mena tomone iyoga-suwalan kabo gibuna ipeiluseyagili tomone tenana mena. Imwawasi Yeisu nimana gibuna ikaisoi yo tomone memenana ikabitonan. ");
INSERT INTO tte_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yeisu isakaisae bulibuli mena yo yawasina iyasae na iwalo tomone koina, iba, “Epapata”, bwaite kana bui “Kwasoke”. ");
INSERT INTO tte_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kabo sauganane koina tomone tenana sitamwalapan yo tabe memenana imalamalae yo iedeedede dudulai. ");
INSERT INTO tte_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yeisu tomo meuloili iwalo-kausili yakato tabu yaiya koina siwawalo-masala. Na iyamo bwagana iwalowalo-kausili na ana walo yakasisi nige sibebenalan, sisamasamalulu na silau siyawayawasayan tomo kolili. ");
INSERT INTO tte_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tomo kateli sipitali yawasosi siwaloba, “Ana paisowa meuloili ipaisowa namwanamwaili. Totenakola iwalo tenaliyao sitamwalapan walo sibenalan yo siya nige sowasowali siedeedede iwalo memenaliyao simalamalae siedeedede.” ");
INSERT INTO tte_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Saugana imiyamiya dedeinane koina boda yabo uloili silogogoma na nige kali. Yeisu ana tobenaliyao iyoganlima iwalo kolili iwaloba, ");
INSERT INTO tte_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Boda bwaitete yakatekamkamna-yagili kaiwena kaliyate yaiyona mekalakavao tamiyamiya na nige kali. ");
INSERT INTO tte_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tem meguliyamli yayawasali sipileyoi kani kamwasa mena yoli sawosawowoli kaiwena tupwali kelamamalawe mena silaoma.” ");
INSERT INTO tte_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ana tobenaliyao siwalo koina, siwaloba, “Toweya koina kan kani talobaiya na bodane tayakanli? Kaiwena bwaite paepaeli bwagabwaga.” ");
INSERT INTO tte_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yeisu ineliyagili iwaloba, “Isa beledi kolimiu simiyamiya?” Na siwaloba, “Sebenmo.” ");
INSERT INTO tte_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kabo iwalo boda kolili simiyasio bwatano mena yo beledi sebenne ikalaili yo kaiweli ikawa-toki Yaubada koina, yo itabe-kivikivi iwolegili ana tobenaliyao kolili na sisoiyagili tomo kolili. ");
INSERT INTO tte_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tabe tupwaliyao iye kikiuli simiyamiya kaiweli ikawa-toki yo ana tobenaliyao iwalo sisoiyagili tomo kolili tabe. ");
INSERT INTO tte_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Yo meuloili sikekan yo diyali sisu muli mena kan tupwa tobenaliyao sitano-gogonagilima kodo seben siloyapowonli. ");
INSERT INTO tte_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Yo bodaline kali baibaiwa powa tausan (4,000) besiele. Iyawasali sipileyoi, ");
INSERT INTO tte_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","kabo muli mena Yeisu me ana tobenaliyao ali waga mena simwalisae yo Dalimanuta dedeina mena silau. ");
INSERT INTO tte_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Palisiyao tupwali silaoma yo Yeisu koina siyatubu sigamwapakiki yo sitonan yakato kilakilala yabo ipaisowai kaiweli na sikawa-yawasosi yakato ana kaiwe ilaoma Yaubada koina. ");
INSERT INTO tte_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ali walo kaiwena Yeisu yawasina iyasae kaiwena me ana okwatakwata kabo iwaloba, “Tawae kaiwena nuwanuwamiu kilakilala yabo? Yawalo yawasosi kolimiu, kani nige kilakilala yabo wagigitai.” ");
INSERT INTO tte_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kabo ilogabaegili yo waga mena imwalisaeyoi na silopanaisi dedei yabo mena. ");
INSERT INTO tte_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tobenaliyao kali kanale nuwali imwatain nige sitatauli waga mena bwaimwanamo beledi kaigeda silobai waga mena imiyamiya. ");
INSERT INTO tte_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yeisu iyanuwapeili iwaloba, “Wagite-kalatagimiu, Palisiyao yo Elodi kali beledi ana kaba sese koina wagite namwanamwaili.” ");
INSERT INTO tte_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yo tobenaliyaone sibomamo kolili siedeedede siwaloba, “Nuwana Yeisu ana walo yaina bwaite kaiwena nige beledi kolila.” ");
INSERT INTO tte_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yeisu ali nuwatu ikataiyako yo iwalo kolili iba, “Tawae kaiwena kwawalowalo nige beledi kolimiu? Gubesi, iyaelemo naga menuwa-pwanopwanomiu na nuwamiu nige simamayale? Nuwana katemiu sikololo? ");
INSERT INTO tte_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Me manimiu, tawae kaiwena nige wagigitai? Me tenamiu, tawae kaiwena nige kwabebenali? Nige kwanunuwatu-kalatan? ");
INSERT INTO tte_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Sauganane beledi valigigi koina tomo paibi tausani yayakanli na tupwa isa kodo kwatano-gogonagili?” Yo tobenaliyao kainana siyamaisa koina siba, “Kodo tuwelo.” ");
INSERT INTO tte_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yo Yeisu ineliyoi iwaloba, “Sauganane beledi seben koina tomo powa tausani yayakanli na tupwa isa kodo kwatano-gogonagili?” Yo siwaloba, “Kodo seben.” ");
INSERT INTO tte_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kabo Yeisu iwaloba, “Walo yawasosi. Na gubesi, nige naga nuwamiu simamayale yau yaiya?” ");
INSERT INTO tte_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Silau Betesaida kabo tomangibugibu yabo tomo sikalaiyama Yeisu koina yo sikawanoiyan yakato ikabitonan. ");
INSERT INTO tte_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yeisu tomangibugibune nimana mena ikabilau yo iyogan siyawatagili yanuwa gana mulina mena. Kabo Yeisu tomone manna ikaisoili yo nimana ipeili koina yo ineli koina iba, “Sowasowana ginauli ugitaili?” ");
INSERT INTO tte_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yo tomone igitekeikeile yo iwaloba, “Tomo yagitaili na kali koleya besiele mayau silolokeikeile.” ");
INSERT INTO tte_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yeisu tomone manna ikabi-tonagiliyoi kabo iyalala yo manna silala dudulai yo ginauli meuloili igitaili sidudulai. ");
INSERT INTO tte_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yeisu iwalo tomone koina iwaloba, “Tabu kupipileyoi bodane kolili yanuwane koina na kulaumo am nume mena.” ");
INSERT INTO tte_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kabo Yeisu me ana tobenaliyao silalau Sisaliya Pilipai yanuwaliyao kaiweli. Yo kamwasa mena ana tobenaliyao ineliyagili iwaloba, “Gubesi tomo ali walo kaiwegu yakato yau yaiya?” ");
INSERT INTO tte_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Na siwaloba, “Tomo tupwali siwawalo yakato kowa Yoni Toyababitaiso, tupwali siwawalo yakato kowa Ilaitiya yo tupwali siwawalo yakato kowa palopita bagubagunali yabo.” ");
INSERT INTO tte_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Na tabe ineliyagiliyoi iwaloba, “Na komiu? Gubesi ami nuwatu yakato yau yaiya?” Kabo Pita kainana iyamaisa iwaloba, “Kowa Mesaiya” ");
INSERT INTO tte_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kabo Yeisu iwalo-kausili iwaloba, “Tabu yaiya yabo koina kwawawalo-masalagau.” ");
INSERT INTO tte_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kabo iyatubu iyakayakataili bwaite besiele iwaloba, “Tomo Natuna naga kamkamna lalakina kani ilobai kaiwena tautaubalao yo topwaoliyao lalakili yo loina kana toyakayakatai kani sisikotanan. Yo kani siunuyamate na kaliyate yaiyona mulina mena itoloyoi.” ");
INSERT INTO tte_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yeisu iedeedede dudulai mena yo mayale mena ginauliline kaiweli na tem sikatai. Pita imunamunai Yeisu ana walone kaiwena kabo Pita Yeisu iyoga-suwalan yo iyokoiyan. ");
INSERT INTO tte_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pita ana yokoine kaiwena Yeisu itagelakeile yo ana tobenaliyao igitagitaili na Pita iyokoiyan iwaloba, “Kulowasi koliyau kowa Seitani. Am nuwatune besiele tomo ali nuwatu na nige Yaubada ana nuwatu.” ");
INSERT INTO tte_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kabo Yeisu boda meuloili yo ana tobenaliyao mekalikavao iyoganlima yo iwalo kolili, iwaloba, “Yaiya tem nuwanuwana imuliya koliyau kani mumugana isikotanan na ibomayoi kana kelose ikalai bwaite kagu muliya kana kamwasa besiele. ");
INSERT INTO tte_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kaiwena tem yaiya nuwanuwana yawasina ilebo naga yawasinane igabaen. Na tem yaiya kaiwegu wasa namwanamwana kaiwena yawasina igabaen iya kani yawasina namwanamwana ilobai. ");
INSERT INTO tte_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tem tomo yabo iwasawasa yanuwa yaulina mena, gubesi, sowasowana ana wasawasane isagui tem saugana yawasina ilogabaen? Nigele. ");
INSERT INTO tte_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nige ginauli yabo sowasowana koina yawasila tayamaisa na takele-yavivilayoi. ");
INSERT INTO tte_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yau Tomo Natuna tem yaiya kowa kaiwegu kumwalimwaline yo yagu yakayakatai kaiwena kumwalimwaline na kuuvalayagau yaso bwaite naenaeli yo ganaganawalili manli mena, naga kani yauvalayagiwo, saugana Tamagu ana wasawasa pigapigabuna koina yapileyoima me yagu aneloseyao yakayakasisili.” ");
INSERT INTO tte_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yo Yeisu iwaloyoi iba, “Yawalo yawasosi kolimiu yakato tomo tupwamiyao kani nige kwaboboita kanasiga Yaubada ana kaba loina me ana kaiwe iyawatagilima wagitai.” ");
INSERT INTO tte_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kaliyate sikis (6) mulina mena Yeisu yoli yaiyona iyoganli, Pita, Yemesa yo Yoni mekanakavao sisae koya yabo koina sibomamo simiyamiya kabo sigitai Yeisu kana koleya ibui. ");
INSERT INTO tte_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kana kwama kana koleya ibui ipigapigabu. Mayalene ikaiwesosi yo kana gite nige besiele yaiya yanuwa yaulina mena sowasowana kwama ideuli kana mayamayale besiele. ");
INSERT INTO tte_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kabo Ilaitiya yo Mosese sitolo-mayale na yoli yaiyonane sigitaili Yeisu mekalikava siedeedede. ");
INSERT INTO tte_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kabo Pita iwalolau Yeisu koina iwaloba, “Toyakayakatai, ala miya bwaite besiele inamwanamwa, tem ami gwau yaiyona kakabili kaigeda kowa kaiwem, yo kaigeda Mosese kaiwena na kaigeda Ilaitiya kaiwena.” ");
INSERT INTO tte_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Bwaite Pita iwalowalo bwagabwaga kaiwena mekanakavaone me ali matausi. ");
INSERT INTO tte_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kabo yaloyaloi ilobima ipwaikili yo yaloyaloine koina kaina yabo ilobima sibenalan iwaloba, “Bwaite natugu yamulolo lalakina koina, ana walo kwabenalagili.” ");
INSERT INTO tte_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Sauganane koina sigite-keikeile nige yaiya yabo sigigitai, na Yeisu ibomamo mekalikava. ");
INSERT INTO tte_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Saugana koya mena sisasaluluma Yeisu iwalo-yakasisi-yagili iba, “Tawae wagitailiko tabu tomo kolili kwawawalo-masalagili kanasiga Tomo Natuna boita mena itoloyoima.” ");
INSERT INTO tte_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tawae sigitailiko siwadam na ana walo toloyoine kaiwena sibomamo kolili siedeedede gubesi kana katai. ");
INSERT INTO tte_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kabo Yeisu koina sineli siba, “Tawae kaiwena loina kana toyakayakatai siwaloba, ‘Kani Ilaitiya ibagunama muli mena kabo Mesaiya ilaoma’?” ");
INSERT INTO tte_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Na Yeisu kainali iyamaisa iba, “Walo yawasosi, Ilaitiya yakato ibagunama na ginauli meuloina ikatububunan Mesaiya kaiwena. Tem bwaine besiele tawae kaiwena Buki Tabu iwalo-masalan yakato naga Tomo Natuna kamkamna lalakina ilobai yo sisikotanan? ");
INSERT INTO tte_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yawalo kolimiu, Ilaitiya ilaomako na tawae meuloina nuwanuwali siginauli mwa siginauliyako koina, besiele Buki Tabu iwalo-masala kaiwena.” ");
INSERT INTO tte_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Saugana Yeisu me ana tobenaliyao yoli yaiyona koya mena sisasaluluma sigitai boda lalakina kalikavaone sitolo-takikilagili na loina kana toyakayakataiwo tobenaliyao mekalikavao sigamwagamwa-pakiki. ");
INSERT INTO tte_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Bodane Yeisu sigitai kateli sipitali lalakina kabo sisagena silau yo Yeisu silosanasanai. ");
INSERT INTO tte_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Na Yeisu ineli iba, “Tawae wagamwagamwa-pakiki-yani mekamikavao?” ");
INSERT INTO tte_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tomo yabo bodane kolili iwalolau Yeisu koina iwaloba, “Toyakayakatai, natugu yakalaiyama koliwo iya yaluyaluwa biki koina ilusae na gamene nige sowasowana iedeedede. ");
INSERT INTO tte_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Saugana yaluyaluwa biki ana kaiwe koina, gamene ibeku bwatano mena ikikiwasi yo polu gamwana mena siyawatagili yo mwakana ikikokiko yo yona itawalololi. Kabo am tobenaliyao yakawanoi-yagili yakato yaluyaluwa bikine sitao-yawatagilan na iyamo nige sowasowali.” ");
INSERT INTO tte_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yeisu iwalolau kolili iwaloba, “Kaliyate isa komiu te yau mwa tamiyamiya na tawanesana kabo kwameli koliyau? Ami meli ana yoviya kaiwena yogu ikwatakwata-yagimiu. Saugamo gamene wakalaiyama koliyau.” ");
INSERT INTO tte_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kabo gamene sikalaiyama koina. Saugana yaluyaluwa biki Yeisu igitai mwayamwayau gamene ikabiyakikiwasi yo gamene ibeku bwatano mena ikeno-tapitapipili na polupolu gamwana mena siyawatagili. ");
INSERT INTO tte_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kabo Yeisu ineli gamene tamana koina iba, “Sauga esana ana kasiebwane iyatubu?” Yo tamana iwaloba, “Ana sauga melumelu koina. ");
INSERT INTO tte_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Sauga baibaiwana yaluyaluwa bikine gamene igabaen mayau wedowedolina mena yo waila mena sabi unuyamatena. Tem sowasowam, tawae yabo uginauli, ukwate-kamkamna-yagimai na kusaguimai.” ");
INSERT INTO tte_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yo Yeisu iwalo tomone koina iwaloba, “Tawae kaiwena kuwalo ‘tem sowasowam’? Tem tomo me ana meli kani ginauli meuloina simalamalae.” ");
INSERT INTO tte_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kabo gamene tamana iwalolau Yeisu koina iwaloba, “Yameli na iyamo yagu meli ikikiu. Kusaguiyau na yameli yawasosi.” ");
INSERT INTO tte_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yeisu igitai boda meuloili sisagesagenama kabo yaluyaluwa bikine iyokoiyan iwaloba, “Kowa yaluyaluwa naenaena. Kowa tomo tenaliyao yo gamwaliyao ukwausili. Yaloinayagiwo gamene kulogabaen na tabu kululusaeyoi koina.” ");
INSERT INTO tte_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kabo yaluyaluwa bikine iwui yo gamene ikabiyakikiwasi yalalaki na iyawatagili yo ilau. Kabo gamene kana koleya besiele iboita mwa meuloili siwaloba, “Iboita.” ");
INSERT INTO tte_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Na Yeisu gamene nimana mena ikabilau yo ikeleyatolo. ");
INSERT INTO tte_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ginauli meuloina imwawasi kabo silusae nume mena sibomamo na ana tobenaliyao sineli koina siba, “Tawae kaiwena yaluyaluwa bikine nige sowasowamai katao-yawatagilan?” ");
INSERT INTO tte_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Na Yeisu kainali iyamaisa iba, “Kawakawanoimo koina sowasowana yaluyaluwa biki bwaite besiele tatao-yawatagilan.” ");
INSERT INTO tte_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yeisu me ana tobenaliyao yanuwane silogabaen na silalau dedei Galili kaiwena. Yeisu genuwana tomo yabo ikatai toweya siyaele, ");
INSERT INTO tte_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kaiwena ana tobenaliyao iyakayakataili. Iwalo kolili iba, “Naga Tomo Natuna sitalamwan tomo nimali mena yo siunuyamate na kaliyate yaiyona mulina mena kani itoloyoi.” ");
INSERT INTO tte_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Na ana walone kaiwena nige nuwali imamayale na iyamo nige sineneli koina kaiwena simatausi. ");
INSERT INTO tte_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Kamwasa mena tobenaliyao sigamwagamwa-pakiki. Saugana siyawatagilima yanuwa Kapeneomi koina kabo nume mena silusae na bwaine koina Yeisu ineli-yagili iba, “Tawae wagamwagamwa-pakiki-yani kamwasa mena?” Na nige kainana siyayamaisa kaiwena ali gamwapakiki yaina tem yaiya kolili iyamala ali tobaguna. ");
INSERT INTO tte_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yeisu imiyasio na tobenaliyao yoli tuwelo iyoganlima yo iwalo kolili iba, “Tem yaiya kowa nuwanuwam kolimiu kuyamala tobaguna, ilonamwayagiwo kupei-yataluwo na kuyamala topaisowa kamkavao kaiweli.” ");
INSERT INTO tte_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kabo melumelu yabo ikalaiyama yo luwaluwalili mena iyatolo yo isapwali yo iwalo kolili, ");
INSERT INTO tte_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","iba, “Tem yaiya kowa melumelu yabo bwaite besiele esagu mena kuyogan yau kuyoganiyau. Na yaiya kowa kuyoganiyau bwaimwa iya toyawasayaune kuyogan.” ");
INSERT INTO tte_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kabo Yoni iwaloba, “Toyakayakatai, tomo yabo kagitai esam mena yaluyaluwa biki itao-yawatagilagili na kawalo-kausi kaiwena tomone iya nige ala boda yabo.” ");
INSERT INTO tte_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Na Yeisu iwaloba, “Tabu kwawawalo-kausi kaiwena tem yaiya ginauli kaikaiweli esagu mena ipaisowaili nige sowasowana sauga muli mena ikawa-naenae-yagau. ");
INSERT INTO tte_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kaiwena tem analiyao nige kala tokalomagigili siya kalakavao. ");
INSERT INTO tte_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yawalo yawasosi kolimiu, tem galogalomiu simagu na yaiya waila iyanumamiu esagu mena kaiwena komiu Keliso ana bodao, iya maisana namwanamwana naga ilobai.” ");
INSERT INTO tte_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yo tabe iwaloyoi iba, “Tem tomo yabo melumeluwone iwoya-pwanolili, bwaite siya kagu tomeliwo, kana maisa Yaubada koina ipolowesosi kabo tem tomone veku polopolowena galogalona mena sipan yo sigabaen kalita mena ana boita kana polowe. ");
INSERT INTO tte_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Tabe tem nimam iyalopwanowo kutom-gabaen. Inamwanamwa tem nima kaikaigedam yawasim namwanamwana kulobai. Tabu kulau mayau wedowedolina koina menima labulabuim. ");
INSERT INTO tte_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Tabe tem kaekaem iyalopwanowo kutom-gabaen. Inamwanamwa tem kaekae kaikaigedam yawasim namwanamwana kulobai. Tabu kutatalam sigabaegiwo mayau wedowedolina koina mekae labulabuim. ");
INSERT INTO tte_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Tabe tem manim iyalopwanowo ukasigabaen. Inamwanamwa tem man kaikaigedam Yaubada ana kaba loina koina kulusae. Tabu kutatalam sigabaegiwo mayau wedowedolina koina meman labulabuim. ");
INSERT INTO tte_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Dedeinane koina wesoweso tomo kwapina sikankan nige siboboita yo mayau iwedowedoli nige ana kaba boita. ");
INSERT INTO tte_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kabo tomo meuloili mayau kalapulupululuna ikabi-namwanamwaili, besiele kan kalita ikabi-namwanamwai. ");
INSERT INTO tte_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kalita ginauli namwanamwana na iyamo tem ana kaiwe yo kamnana imwawasi nige sowasowana inamwanamwayoi. Kabo ilonamwayagimiu mumugamiu kwaboma kwalotonan kana namwanamwa na kaigeda kaigeda kwaemulomulolo-wagimiu na kwamiya-daumwali.” ");
INSERT INTO tte_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yeisu yanuwane ilogabaen yo ilau ilusae Yudiya ana dedei mena yo ilopanaisi Yolidan dedei yabo mena. Boda lalakina silogogoyoima koina kabo iyakayakataili besiele sauga meuloina. ");
INSERT INTO tte_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Palisiyao tupwali silaoma yo nuwanuwali Yeisu sitonan yo koina sineli siba, “Gubesi, ala loina italamwan inawase kaiwena o nigele?” ");
INSERT INTO tte_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Kabo Yeisu iba, “Loina tawae Mosese iyeyawa kolimiu?” ");
INSERT INTO tte_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Na Palisiyao siba, “Mosese italam tem tau nuwanuwana inawase baguna pepa koina ana sikote ilele kabo pepane iwolena wainena koina na iinawase.” ");
INSERT INTO tte_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yo Yeisu iwaloba, “Katemiu sikololo mwa bwaite kaiwena Mosese loinane ilele kaiwemiu. ");
INSERT INTO tte_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Sauga bagubagunana Yaubada ana yamayamayale koina tomo labui iyamayaleli, tau yo sine. ");
INSERT INTO tte_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Bwaite kaiwena mwa tau tamana yo sinana ilogabaegili na wainena mekanakava simiya toyawa, ");
INSERT INTO tte_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","yoli labuine kwapi kaigeda. Baguna siya tomo labui, sauga bwaite siya besiele tomo kaigeda. ");
INSERT INTO tte_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yaubada ipei-labui-yagiliko, tabu tomo yabo ipepei-suwalagili.” ");
INSERT INTO tte_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yo muli mena Yeisu me ana tobenaliyao sipileyoima nume mena yo tobenaliyao sineliyoi ana walo inawase kaiwena. ");
INSERT INTO tte_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yeisu iwaloba, “Tem tau wainena iinawaseyan na ilopanaisi sine yabo koina tau bwaite iganawali, bwaite lopwano iginauli wainena bagubagunana manna mena. ");
INSERT INTO tte_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Yo tabe tem sine wainena iinawaseyan na ilopanaisi tau yabo koina sine bwaimwa iganawali.” ");
INSERT INTO tte_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tomo melumeluwo sikalailima Yeisu koina na tem ikabitonagili na iyamo ana tobenaliyao tomone siyokoiyagili. ");
INSERT INTO tte_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Saugana Yeisu ali paisowa igitai imunamunai kabo iwaloba, “Tabu melumeluwo wakaukausili. Kwatalamwagili silaoma koliyau kaiwena Yaubada ana kaba loina imiyamiya melumeluwo bwaite besiele kaiweli. ");
INSERT INTO tte_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yawalo yawasosi kolimiu, tem yaiya tomo mumugana nige besiele melumelu, nige sowasowana Yaubada ana kaba loina ilusae.” ");
INSERT INTO tte_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kabo Yeisu melumeluwone ikalaili ipeili kaena mena yo nimana ipeili kolili na iwalo-muloloili. ");
INSERT INTO tte_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Saugana Yeisu ilalau kamwasa mena tomo yabo isagenama, tutulina italusakonayan manna mena na ineli koina iba, “Toyakayakatai namwanamwana, tawae yaginauli na yawasigu miyamiya yaina yalobai?” ");
INSERT INTO tte_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yeisu kainana iyamaisa iba, “Tawae kaiwena ukawa-namwanamwa-yagau? Nige yabo tonamwanamwana, Yaubada ibomamo. ");
INSERT INTO tte_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Na Yaubada ana loinao ukwatailiko bwaimwa yakato ‘Tabu kuunuyamate, tabu uganawali, tabu ukewali, tabu kumwakomwakota, tabu mwakota mena tomo ali gogo ukalakalaili, tabe yaboyoi tamam yo sinam kuyakasisi-yagili.’” ");
INSERT INTO tte_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Na tomone iwaloba, “Toyakayakatai, yagu sauga game koina yo kanasiga kabona loinane bwaitete meuloili yaobigaili.” ");
INSERT INTO tte_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Kabo Yeisu tomone imankulakulai me ana katekamkamna kabo iwalolau koina iba, “Ginauli kaigedamo koliwo ideva. Kupileyoi am yanuwa mena na am gogo meuloili ugimwala-yagili, na maneline kuyauyagili tobubutuma kolili mesabana am wasawasa bulibuli mena kulobai. Na kulaoma kumuliya koliyau.” ");
INSERT INTO tte_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Walo bwaite kaiwena nuwanae kana koleya iyawatagili tomone manna mena kabo ilau me ana nuwanae kaiwena iya towasawasa. ");
INSERT INTO tte_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kabo Yeisu igite-keikeile yo ana tobenaliyao iwalo kolili iba, “Tem analiyao me ali wasawasa lalakina ali lusae Yaubada ana kaba loina koina ikololo.” ");
INSERT INTO tte_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Saugana tobenaliyao ana walo sibenalan kateli sipitali. Tabe iwaloyoi iba, “Natuguwao, Yaubada ana kaba loina kana lusae ikololososi. ");
INSERT INTO tte_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Towasawasao ali lusae Yaubada ana kaba loina koina ikololososi kabo kameli sinalom gulana koina ana lusola.” ");
INSERT INTO tte_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Saugana tobenaliyao walo bwaite sibenalan kateli sipitali lalakina na siwalolau koina siba, “Tem bwaite besiele, yaiya sowasowana lebo ilobai?” ");
INSERT INTO tte_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yeisu imankulakulaili yo iba, “Ginauli bwaite yawasosi ipolowe tomo kolili, na Yaubada koina nige kana polowe yabo kaiwena Yaubada koina ginauli meuloili simalamalae.” ");
INSERT INTO tte_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kabo Pita iwaloba, “Na kai gubesi? Ama gogo meuloili kalogabaegiliko na kamuliya koliwo.” ");
INSERT INTO tte_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yeisu Pita kainana iyamaisa iba, “Yawalo yawasosi kolimiu, yaiya tem ana nume, kanakavao, dunao, sinanao, tamanao, natunao yo ana bwatanoyao ilogabaegili esagu mena yo tabe wasana namwanamwana kaiwena, ");
INSERT INTO tte_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","maisana lalakina naga ilobai sauga ilalaoma koina besiele kani nume baibaiwali, kanakavao, dunao, sinanao, natunao yo bwatanoyao. Yo tabe besiele kamkamna ilobai na iyamo naga sauga muli mena yawasina miyamiya yaina ilobai. ");
INSERT INTO tte_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bwaite saugane koina siya tobagunao meuloili naga kani simuliya na siya tomulimuliya naga sibaguna.” ");
INSERT INTO tte_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yo kamwasa mena sisasae Yelusalema kaiwena, Yeisu ibagubaguna na kana tomuliya bodaliyao meuloili simulimuliya. Ana tobenaliyao sikatewakaka yo tupwaliyao tomo simulimuliye me ali matausi. Kabo yoli tuwelo iyoga-suwalagili yo iyanuwapeiyoili tawae naga kani iyawatagili koina, ");
INSERT INTO tte_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","iba, “Sauga bwaite tasasae Yelusalema. Yo Tomo Natuna naga siyagayan topwaoli lalakili yo loina kana tobagunao kolili. Yo ana boita kaiwena siloina sabi unuyamatena muli mena sitalamwan siya nige Yudiya tomoliyao kolili, ");
INSERT INTO tte_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","yo siya sitalatalawasiyan, sikaikaisoi tabe balae mena sisapi muli mena siunuyamate yo kaliyate yaiyona mulili mena itoloyoi.” ");
INSERT INTO tte_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yemesa te Yoni, Sebedi natunao, Yeisu koina silaoma siwaloba, “Toyakayakatai, kalaoma kaiwena ginauli yabo nuwanuwamai.” ");
INSERT INTO tte_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yeisu iwaloba, “Tawae nuwanuwamiu yapaisowai kaiwemiu?” ");
INSERT INTO tte_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kabo siba, “Saugana am kaba miya wasawasana koina kumiyasio am kaba loina koina nuwanuwamai salim mena kamiyasio kaigeda ulaulam mena yo kaigeda gegebam mena.” ");
INSERT INTO tte_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yeisu iwaloba, “Komiu nige wakakatai tawae wakawakawanoiyan.” Muli mena ineli walo kobwaibwaili mena iba, “Gubesi, kamkamna komwanane koina naga yanuma sowasowana komiu tabe koina kwanuma? Na tabe babitaiso polowenane naga yalobai gubesi sowasowamiu koina kwababitaiso besiele?” ");
INSERT INTO tte_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Siba, “Sowasowamai.” Na Yeisu iba, “Komwane koina naga kani yanuma komiu besiele koina kani kwanuma yo besiele babitaisone koina naga kani yababitaiso komiu besiele kani kwababitaiso, ");
INSERT INTO tte_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","na nige sowasowana analiyao yagitesipwaili yagu kaba loina koina yaiya ulaulagu mena na yaiya gegebagu mena simiyasio. Yaubada bwaite kaba miya ikatububunagiliko kaiwena ibomamo ikatai yaiya naga isaguiyau sauganane yaloina yagu kaba loina koina.” ");
INSERT INTO tte_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Na ana tobenaliyao yoli sanaulu Yemesa te Yoni ali kawanoi kaiwena simunamunai-yagili. ");
INSERT INTO tte_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mwa Yeisu meuloili iyogagogonagilima yo iba, “Komiu wakataiyako siya nige Yaubada simemeliyan ali toloinao siloinayagili yo ali tobagunao siwalo kaiwe kolili. ");
INSERT INTO tte_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Na komiu tabu besiele wagiginauli. Tem yaiya kowa nuwanuwam esam ilalaki ilonamwayagiwo kamkavao kaiweli kuyamala topaisowa. ");
INSERT INTO tte_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na tem yaiya kowa nuwanuwam kuyamala tobaguna ilonamwayagiwo am eliyamwao meuloili kaiweli kuyamala topaisowa. ");
INSERT INTO tte_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tomo Natuna nige ilalaoma yakato kwapaisowa koina na ilaoma sabi paisowa kolimiu yo tabe yawasina italamwan tomo meuloili iyamaisa-yavivila-yoilima.” ");
INSERT INTO tte_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yo silaoma Yeliko. Saugana Yeisu me ana tobenaliyao yanuwane silologabaen boda lalakina siyamuli-kusulili. Kabo tomangibugibu yabo esana Batimeo tamana esana Timeo silobai. Sauga meuloina kamwasa dedeina mena imiyamiya na ikawakawanoi mane yo gogo kaiweli. ");
INSERT INTO tte_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Na Batimeo wasa ibenalan yakato Yeisu game Nasaleta ilalau kabo iyoga iba, “Yeisu, Deibida tubuna, ukwatekamkamna-yagau.” ");
INSERT INTO tte_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tomo meuloili Batimeo siwalo-kausi siba, “Kumwanou.” Na iyoga kaikaiwe iba, “Deibida tubuna, ukwatekamkamna-yagau.” ");
INSERT INTO tte_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kabo Yeisu iba, “Kwayoganama.” Yo tomo siyoga koina, siba, “Kuyaliyaya. Kutolo kulaoma. Yeisu iyogayoga kaiwem.” ");
INSERT INTO tte_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yo kana kabobo isou, mwayamwayau itolo ilaoma Yeisu koina. ");
INSERT INTO tte_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yeisu ineli koina iba, “Tawae nuwanuwam kaiwem yapaisowai?” Yo tomangibugibune iwaloba, “Toyakayakatai, nuwanuwagu mangu silala.” ");
INSERT INTO tte_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yo Yeisu iba, “Inamwanamwa, kulau, am meli ikabi-namwanamwaiwo.” Sauganane koina Batimeo manna silala yo kamwasa mena Yeisu iyamuli-kusuli. ");
INSERT INTO tte_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yo sisasae Yelusalema kaiwena yo tupwana imamalawe. Silaoma yanuwa kikiuli Bedani yo Bedipegi bwaimwa koya Olibe yaulina mena kabo Yeisu ana tobenaliyao labui iyawasa-bagunayagili. ");
INSERT INTO tte_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Iwalo kolili bwaite besiele iba, “Kwalau yanuwa kikiuna bwaimwa manimiu mena. Na saugana kwalulusae yanuwane koina ase natuna yabo wagitai sipan-kalatan. Bwaimwa ase natuna wauwau-bona nige yabo tomo imwamwalisae-tonan. Asene kwalivasi yo kwayoganama. ");
INSERT INTO tte_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Na tem yabo ineli kolimiu iba, ‘Tawae kaiwena bwaimwa ase natuna kwalivalivasi?’, kabo tomone koina kwawaloba, ‘Taubala nuwanuwana sauga kubwakubwanamo iyapaisowa kabo iyavivilayama yoi.’” ");
INSERT INTO tte_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yo yoli labuine silau yo ase natuna silobai kamwasa mena nume gamwana mena sipan-kalatan. ");
INSERT INTO tte_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Saugana silivalivasi tomo tupwaliyao salili mena sitotolo sineli siba, “Tawae kaiwena asene natuna kwalivalivasi?” ");
INSERT INTO tte_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Mwa yoli labuine kainali siyamaisa besiele tawae Yeisu iwalowen kolili. Kabo tomone sitalam. ");
INSERT INTO tte_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Yo tobenaliyao ase natuna silivasi siyoganama Yeisu koina. Tomo kali kwama ase dagelana mena siyeseli kabo Yeisu imwalisae koina. ");
INSERT INTO tte_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yo boda meuloili kali kwama kamwasa mena siyeseli yo tupwali silau kamwasa dedeina mena yo mayau lagalagali meliguli sitomli yo siyeseli kamwasa mena. ");
INSERT INTO tte_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Boda tupwaliyao Yeisu sibagunayan na boda tupwaliyao simuliya yo meuloili sitobatobali siyogayoga siba, “Osana. Yaubada tatobalan. Guyau iwalo-muloloi iya ilaoma Yaubada esana mena. ");
INSERT INTO tte_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Guyau iwalo-muloloi iya ilaoma ala Kini, tubula Deibida ana kaba loina ikalaiyama. Osana. Yaubada tatobalan.” ");
INSERT INTO tte_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yeisu ilau Yelusalema yo Nume Tabu koina ilusae yo ginauli meuloina Nume Tabu kalona mena iman-kulakulailimo na kaiwena dabwelo isusugu mwa me ana tobenaliyao yoli tuwelo sipileyoi Bedani na bwaine koina sikeno. ");
INSERT INTO tte_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Yanuwa ilayan Bedani silogabaen na silalau Yelusalema kaiwena kabo Yeisu iguliyam. ");
INSERT INTO tte_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yo kelamamalawe mena mayau yabo esana fig, kana koleya besiele venavena, meliguna igitai mwa inuwanuwatu tem mayaune me kanna kabo ilau salina mena. Na saugana ilau koina ilobai ligu bwagabwagana nige kanna, kaiwena mayaune nige naga ana sauga uwe. ");
INSERT INTO tte_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mwa Yeisu mayaune iyokoiyan iwaloba, “Nige sowasowana kuuweyoi na tomo koliwo sikekan.” Yo ana walone bwaite ana tobenaliyao sibenalan. ");
INSERT INTO tte_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Saugana silaoma Yelusalema koina Yeisu ilusae Nume Tabu kalona mena. Bwaine koina ilobaili togimwala kalona mena. Kabo iyatubu itawoili yo mane toyakunelae ali teibeli ibuikeileli yo bunetutu kali togimwala ali kaba miya besiele ibuikeileli. ");
INSERT INTO tte_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yo yaboyoi Nume Tabu kalona iyakasisiyan tabu tomo yaboyoi ginauli yabo sikalai silawanama Nume Tabu kalona mena. ");
INSERT INTO tte_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Iyakayakataili, iwaloba, “Buki Tabu koina Yaubada ana walo silele iwaloba, ‘Yagu Nume bwaite esana sipeiyako kaba kawanoi tomo meuloili kaiweli,’ na iyamo komiu kwapaisowai besiele tokewali ali gula.” ");
INSERT INTO tte_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Topwaoli lalakili yo loina kana toyakayakatai Yeisu ana paisowa wasana sibenalan yo siyatubu sinuwanuwatu toisabo kamwasa koina na siunuyamate. Na Yeisu simatausan kaiwena tomo meuloili nuwali iyai ana yakayakatai kaiwena. ");
INSERT INTO tte_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Saugana dabwelo isusugu Yeisu me ana tobenaliyao Yelusalema silogabaen. ");
INSERT INTO tte_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yanuwa ilayan malala mena silalau Yelusalema kaiwena yo Yeisu mayauwa esana fig iyoyokoiyanwa sigitai lamna yo mayauna siboita yo liguna meuloina siweweka. ");
INSERT INTO tte_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita Yeisu ana walo inuwatu-kalatan yo iwaloba, “Toyakayakatai, ugitai mayauwa kuyoyokoiyanwa iboita yo liguna meuloina siweweka.” ");
INSERT INTO tte_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yeisu Pita kainana iyamaisa iba, “Yaubada kumeliyan. ");
INSERT INTO tte_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yawalo yawasosi kolimiu, tem tomo yabo me ana meli na nige me ana nuwa labulabui yo iwalo koyane koina iba, ‘Kulau na kuboma ugabaegiwo kalita mena’ kani iyawatagili besiele ana walo. ");
INSERT INTO tte_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Bwaite kaiwena yawalo kolimiu baguna kwameli na tem tawae wakawanoiyan Yaubada koina kani kwalobai. ");
INSERT INTO tte_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Yaboyoi saugana tem kwatolo na wakakawanoi Yaubada koina baguna tawae kamikavao naenaena siginauli kolimiu kwanuwatu-pwaikili na mesabana Tamamiu bulibuli mena tawae ami naenaena inuwatu-pwaikili. ");
INSERT INTO tte_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tem kamikavao ali naenaena nige kwanunuwatu-pwaikili, tabe besiele komiu ami naenaena Tamamiu bulibuli mena kani nige inunuwatu-pwaikili.” ");
INSERT INTO tte_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Sipileyoima Yelusalema na saugana Yeisu Nume Tabu kalona mena ilolokeikeile topwaoli lalakili yo loina kana toyakayakatai yo yanuwane kana tautaubalao mekalikavao silaoma koina. ");
INSERT INTO tte_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Yo Yeisu ana paisowa laina kaiwena sineliyan siwaloba, “Yaiya ana loina mena yo ana kaiwe mena ginauli bwaite kupaipaisowaili?” ");
INSERT INTO tte_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yeisu kainali iyamaisa iba, “Neli yabo yaneliyan kolimiu. Tem kwayamaisa koliyau kani yawalo kolimiu yaiya ana loina mena ginauli bwaite yapaipaisowaili. ");
INSERT INTO tte_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yagu neli bwaite kwayamaisa. Yoni Toyababitaiso tomo iyababitaisoli. Ana loinane toweya ilaomaya? Yaubada koina o nuwana tomo yanuwa yaulina kolili?” ");
INSERT INTO tte_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kabo sibomamo kolili sigamwapakiki siwaloba, “Ana walo gubesi tem ala yamayamaisana? Kaiwena tem tawaloba, ‘Yaubada koina’ kani iwaloyoi kolila, ‘Tawae kaiwena Yoni nige kwamemeliyan?’ ");
INSERT INTO tte_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Na tem tawaloba, ‘Tomo kolili’ naga boda simunamunai-yagila kaiwena tomo meuloili Yoni simeliyan yakato iya palopita yawasosi.” ");
INSERT INTO tte_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mwa siwaloba, “Nige kakakatai.” Kabo Yeisu iwalolau kolili iwaloba, “Yau tabe kani nige yawawalowen kolimiu yaiya ana loina mena ginauli bwaite yapaipaisowaili.” ");
INSERT INTO tte_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Muli mena Yeisu iwalo-kobwaibwaili kolili iwaloba, “Tomo yabo ana tano isepa yo oine ikumai kabo igana-takikili yo gula yabo ikeli oine kanna masina ana kaba tamtamna yo nume saliyana malamalawena yabo ikabi tano togitekalatan ali kaba miya yo ali kaba gite-takitakikili tanone. Kabo iwolegili tomo tupwaliyao kolili yakato siya togitekalatan tanone siyapaisowa yo oine kanna sigimwala-yani kali sagu kaiwena yo tabe manena tupwana siwolena tanuwaganane koina. Kabo muli mena ilogabaegili ilau yanuwa uloina koina. ");
INSERT INTO tte_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kabo kelikeli kana sauga mena taubala ana topaisowa yabo iyawasa yakato oine kanna tupwana tano togitekalatanwo kolili ikalaiyama. ");
INSERT INTO tte_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Na iyamo tano togitekalatanne topaisowane sikabikalatan yo sisapi mwa siyawasa-yapileyoi menimana. ");
INSERT INTO tte_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kabo taubalawa ana topaisowa labuina iyawasayoi kolili mwa siunui kulukuluna mena yo siunui-yanayanae kabo me ana mwalimwaline ipileyoima. ");
INSERT INTO tte_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yo tabe yaiyonana iyawasayoi kolili na topaisowane siunuyamate. Sauga meuloina besiele, topaisowaone iyawayawasali kolili sauga tupwana sisapili yo sauga tupwana siunuyamateli. ");
INSERT INTO tte_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Topaisowa meuloili iyawasaliko na kaigedamo imiyamiya iya natuna tauna imulolo lalakina koina. Taubalane iwaloba, ‘Iya bwaite natugu kani siyakasisiyan.’ Kabo iya ana kaba mwawasi iyawasa kolili. ");
INSERT INTO tte_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Na saugana togitekalatan natunane sigitai sibomayoi siedeedede kolili siba, ‘Iya tano tanuwagana natu yawasosina. Talau taunuyamate na mesabana kita tanone takalai ala tano.’ ");
INSERT INTO tte_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mwa sikabikalatan yo tano kalona mena siunuyamate, boiboitana sikalai na sigabae-yawatagilan ganamuli mena.” ");
INSERT INTO tte_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yeisu ana edeedede iyemwawasi kabo ineli kolili iwaloba, “Tawae kani taubalane ipaisowai? Walo yawasosi, taubalane kani ilaoma togitekalatanne iunuyamateli yo tanone kani iwolena togitekalatan uloili kolili. ");
INSERT INTO tte_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Gubesi, nuwana nige sauga yabo Buki Tabu ana walone bwaite kwayayasili? ‘Tokabikabi veku yabo sikalai yakato nume sikabi koina na vekune sikawa-naenaeyan yo sisikotanan. Na Guyau vekune ikalai iyatolo-bagunayan yakato veku meuloili iloinayagili yo sikaiwe. ");
INSERT INTO tte_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Bwaite Guyau ana paisowa namwanamwasosina manla mena.’” ");
INSERT INTO tte_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yudiya ali tobagunao Yeisu ana walo kobwaibwaili bwaite sibenalan yo sikatai yakato siya kaiweli iwalowalo, kabo kamwasa siloyaloyai sabi kabikalatanna. Na iyamo nige sikakabikalatan kaiwena boda simatausagili mwa Yeisu silogabaen silau. ");
INSERT INTO tte_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yo muli mena Yudiya ali tobagunao Palisiyao tupwali yo Elodi ana bodao siyawasali Yeisu koina kaiwena nuwanuwali sineli mwakomwakota na tem ana lopwano silobai. ");
INSERT INTO tte_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kabo silaoma Yeisu koina yo siwaloba, “Toyakayakatai, kakatai kowa towalo yawasosi. Tomo ali kaiwe nige kumamatausagili kaiwena tomo lalakili nige ugogolulau kolili. Yo am yakayakatai Yaubada ana kamwasa kaiwena idudulaisosi. Na gubesi, inamwanamwa Kini Sisa kaiwena takesi tapei o nigele? ");
INSERT INTO tte_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Takesi tayamaisa o nigele?” Na Yeisu ali mwakota ikatai yo iwalo kolili iba, “Tawae kaiwena kwatonan tem kwayakonayau ami mwakota koina? Naga manene wakalaiyama yagitai.” ");
INSERT INTO tte_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yo mane kaigeda siwolena yo Yeisu ineli kolili iwaloba, “Kwawalo koliyau, mane bwaite koina yaiya makamakayauna?” Yo kainana siyamaisa siba, “Kin Sisa.” ");
INSERT INTO tte_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kabo Yeisu iwalo kolili iba, “O, besiele. Kin ana gogo kwaolena kin koina, na tem Yaubada ana gogo kwaolena Yaubada koina.” Mwa Yeisu ana walo bwaite kaiwena kateli sipitali. ");
INSERT INTO tte_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kabo Sadusiyao tupwaliyao silaoma Yeisu koina. Na siya ali yakayakatai koina siwalo yakato toboita nige sowana sitoloyoi. ");
INSERT INTO tte_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Siwaloba, “Toyakayakatai, beyabeyana Mosese ilele kaiwela, ‘Tem yaiya tomo ikasole yo nige natuna na iboita kani kanakava ilaoma kwabukwabulina ikasolanan na tem sinene ikabi yakato toboitane iya natuna.’” ");
INSERT INTO tte_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kabo Sadusiyao kaba gite yabo siwalowen Yeisu koina siwaloba, “Tomo yabo mekanakavao simiyamiya yoli seben yo kali tobagubaguna ikasole yo nige natuna na iboita yaboyoi kanakava salina mena kwabukwabuliwa ikasolanan yo tabe nige natuna na iboita. ");
INSERT INTO tte_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Yo tabe kanakava salina mena kwabukwabuliwa ikasolanan yo mekanakava simiyamiya tabe nige natuna na tomowa iboita. Yo besiele yaiyonana. ");
INSERT INTO tte_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Yo besiele kanakavaone meuloili, kwabukwabuline sikasolanan na siboiboita nige natuliyao kwabukwabuline koina kabo muli mena kwabukwabuliwa iboita. ");
INSERT INTO tte_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na toloyoi kana sauga mena sinene yaiya kani wainena yawasosi? Kaiwena yoli sebenne sikasolanan.” ");
INSERT INTO tte_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yo Yeisu neli bwaite iyamaisa iwaloba, “Bwaite ami lopwano kaiwena Buki Tabu nige wakakatai yo yaboyoi Yaubada ana kaiwe nige wakakatai. ");
INSERT INTO tte_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Toboita ali toloyoi mulina mena tomo kani nige sikakasole. Na siya ali miyamiya besiele aneloseyao bulibuli mena. ");
INSERT INTO tte_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Toboita ali toloyoi kana katai bwaite besiele. Tem Mosese edeededena kwayasili Buki Tabu koina kani kwalobai Yaubada mayau kalapulupululuna koina iedeedede Mosese koina iwaloba, ‘Bwagana Abelamo, Aisake yo Yakobo siboitako siyaele bulibuli mena meyawasili, yau ali Yaubada.’ ");
INSERT INTO tte_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mwa koina Yaubada nige tomo boiboitali ali Yaubada, siya tomo meyawasili ali Yaubada. Na komiu Sadusiyao kwalopwano lalakina.” ");
INSERT INTO tte_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yo loina kana toyakayakatai yabo ilaoma yo ali gamwapakiki ibenalan. Ikatai Yeisu ali neline iyamaisa-yadudulai. Kabo ineli Yeisu koina iba, “Loina meuloili kolili toisabo loina ilalakisosi?” ");
INSERT INTO tte_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Kabo Yeisu iwaloba, “Bwaite loina lalakinaele, ‘Kwabenali, komiu Isileli, Yeoba ala Yaubada iya ibomamo. ");
INSERT INTO tte_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yo am Guyau Yaubada kumulolo koina katem meuloina mena yo yaluyaluwam meuloina mena yo nuwam meuloina mena yo am kaiwe meuloina mena.’ ");
INSERT INTO tte_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Loina labuina bwaite, ‘Kamkavao kumulolo kolili besiele kowa kam mulolo.’ Bwaite loina labuine siya loina meuloili silalaki-gabaegili.” ");
INSERT INTO tte_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kabo loina kana toyakayakatai Yeisu ana walo ibenalan yo iwaloba, “Toyakayakatai, am walo bwaite walo yawasosi, iya ibomamo Yaubada yo nige yaubada yaboyoi imiyamiya. ");
INSERT INTO tte_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tomo ilonamwayagila tem Yaubada tamulolo koina katela meuloina mena yo ala katai meuloina mena yo ala kaiwe meuloina mena yo yaboyoi kalakavao tamulolo kolili besiele kita taboma kala mulolo. Loina labui bwaite silalakisosi kabo muli mena yakayakan kolili tapwaopwaoli.” ");
INSERT INTO tte_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yo Yeisu tomone ana walo ibenalan yakato idudulai na iwalolau koina iba, “Kowa kumiyamiya Yaubada ana kaba loina salina mena.” Bwaine koina kalisiga nige sauga yaboyoi silaoma Yeisu sitotonan yoi. ");
INSERT INTO tte_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yo Yeisu Nume Tabu kalona dedeina mena iyakayakataili yo tomo kolili iwalolau iwaloba, “Loina kana toyakayakatai siwawalo yakato Mesaiya iya Deibida tubuna. Tawae kaiwena siwalo besiele? ");
INSERT INTO tte_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yo Yaluyaluwa Tabuna Deibida iyanuwapei na Deibida iwaloba, ‘Yeoba Yaubada iwalo yagu Guyau koina, ulaulagu mena kumiyasio, kanasiga kam tokaleyayao yapeili kaekaem yaulina mena.’ ");
INSERT INTO tte_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deibida ibomamo Mesaiya ikawa-Guyauwan. Tem besiele, gubesi mwa yakato Mesaiya iya Deibida tubuna?” Yo tomo meuloili Yeisu ana yakayakatai kaiwena siyaliyaya. ");
INSERT INTO tte_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Saugana Yeisu tomo iyakayakataili iwaloba, “Wagitekalatagimiu loina kana toyakayakataiyao kaiweli. Kaiwena silaoma kwama malamalawena siluwuili silolokeikeile kaba gimwala kolili na tem tomo sigitaili na sikawatoki kolili. ");
INSERT INTO tte_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yo yaboyoi nuwanuwali kaba miya namwanamwali nume tapwalolo kolili simiyasio yo besiele soi kali sauga koina nuwanuwali simiya-baguna tomo manli mena kali yakasisi kaiwena. ");
INSERT INTO tte_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yo tabe kwabukwabuliwo ali nume sikalaili mwakota mena. Kabo muli mena silau sitapwalolo yo ali kawanoi simamalawe na mesabana tomo ali nuwatu yakato siya todudulai. Na nigele, naga Yaubada maisa polopolowena iwolegili.” ");
INSERT INTO tte_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yeisu imiyasio mulolo kaba peina salina mena yo tomo meuloili ali mulolo mane silopelopei na Yeisu igitagitaili. Towasawasao sibaibaiwa silaoma ali mulolo mane lalakina sipeipeili. ");
INSERT INTO tte_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Na kwabukwabuli yabo ana mulolo pene kikiuli labuimo ipeili. ");
INSERT INTO tte_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kabo Yeisu ana tobenaliyao iyoga-gogonagilima yo iwalo kolili iwaloba, “Yawalo yawasosi kolimiu, kwabukwabuli bwaine ana mulolo, meuloili ali mulolo ilalaki-gabaegili. ");
INSERT INTO tte_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kaiwena meuloili ali tupwa lalakili simiyamiya na bwaite kwabukwabuline iya tobubutuma yo ana mane meuloina ipei yo nige yaboyoi ana tupwa imiyamiya na koina kana igimwala.” ");
INSERT INTO tte_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yeisu me ana tobenaliyao Nume Tabu mena siyayawatagili kabo ana tobenali yabo Nume Tabu kana koleya Yeisu koina iyakenayan iwaloba, “Toyakayakatai, ugitai nume bwaite kali paisowa sinamwanamwasosi veku lalakili kolili sikabili.” ");
INSERT INTO tte_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Na Yeisu iwaloba, “Numeline lalakili ugitagitaili naga meuloili sitatagwaligwali yo nige sowasowana veku yaboyoi itupwa ana kaba miya mena imiyamiya ugitaiyoi.” ");
INSERT INTO tte_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Muli mena sikawasae Olibe koyana mena kabo Yeisu imiyasio. Bwaine koina sowasowana sigite-panaisi Nume Tabu sigitai. Yo Pita, Yemesa, Yoni, Anidulu sibomamo silaoma Yeisu koina sineli, ");
INSERT INTO tte_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","siwaloba, “Kuwaloma kolimai toisabo sauga koina ginauline kuwalowalowegiline kani siyawatagilima? Toisabo kilakilala kani kagitai na kakatai ginauline kani kikiunamo siyawatagili?” ");
INSERT INTO tte_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kabo Yeisu iwalo kolili iwaloba, “Wagitekalatagimiu, kisimo tomo tupwaliyao simwakotayagimiu. ");
INSERT INTO tte_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kaiwena naga kani tomo sibaibaiwa esagu mena silaoma na kaigeda kaigeda kani iwaloba, ‘Yau Mesaiya’ yo walone koina tomo sibaibaiwa simwakotayagili. ");
INSERT INTO tte_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Yaboyoi, naga wasa kwabenalagili kaleya salimiu mena yo kelamamalawe mena. Nige sowana wakatewakaka kaiwena ginauli bwaitete kani siyawatagili baguna, na yanuwa yaulina ana kaba mwawasi kana sauga naga. ");
INSERT INTO tte_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Boda yo boda kani sikaleya. Yaboyoi kaba loina yo kaba loina kani sikaleya. Mwanikiniki kani siyawatagili dedei meuloili kolili. Tabe guliyam lalakili kani siyawatagili. Ginauliline bwaite sauga kolokololona ana kaba tubu. ");
INSERT INTO tte_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Na komiu wagite-kalatagimiu, kaiwena naga tomo sikabi-kalatagimiu yo silawagimiu yatala kaiwena. Tabe sisapimiu nume tapwalolo kolili. Kaiwena komiu kwameliyagau kani kwatolo toloinao yo kinyao manli mena na wasa namwanamwana kwayawasayan kolili. ");
INSERT INTO tte_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Baguna wasane waguguyeyan dedei meuloili kolili, kabo muli mena sauga ana kaba mwawasi iyawatagili. ");
INSERT INTO tte_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Yo tem sikabi-kalatagimiu yo silawagimiu sabi yatala-yagimiu nige sowana wakatewakaka kani gubesi ami edeedede. Na kwaedeededemo tawae Yaluyaluwa Tabuna iyeyawa, kaiwena nige komiu ami walo, na iya ana walo. ");
INSERT INTO tte_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Sauga ilalaoma susu kalona mena kanakava kani kanakava iwalo-masalan sabi unuyamatena. Besiele tama kani iginauli natuna koina. Tabe melumeluwo kani tamaliyao yo sinaliyao sisikotanagili na siwalo-masalagili sabi unuyamateli. ");
INSERT INTO tte_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yo tomo meuloili kani sikalomagigi-lagimiu kaiwena komiu kagu tomeliwo. Na iyamo tem yaiya me ana meli na itolo kaiwe kanasiga sauga ana kaba mwawasi koina kani leboina ilobai.” ");
INSERT INTO tte_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yeisu nagamo iedeedede, “Na kani wagitai ginauli naenaesosina iya tosibayanae siyatolo bwaine dedeinane koina iya nige ana kaba tolo. Tem yaiya buki bwaite iyasili inuwa-mayaleyan. Bwaine saugane koina Yudiya kana tomiya ilonamwayagili meuloili siyabubu koya kolili kaiwena kisi sikamkamna. ");
INSERT INTO tte_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tem yaiya kowa am nume kewana mena kupaipaisowa kuyabubu mwayamwayau, tabu sauga ugagabaen am gogo nume mena kaiweli. ");
INSERT INTO tte_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yo tem yaiya kowa am tano mena kupaipaisowa kuyabubu mwayamwayau, tabu kupipileyoi kam kwama dedei yabo mena kupepei kaiwena. ");
INSERT INTO tte_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ooo, yawasosi kategu ikamkamna-yagili siya tosiumao yo toyasuyasusuwo kaiweli, kaiwena kani ikololososi kolili sauga bwaine koina. ");
INSERT INTO tte_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Koina wakawakawanoi na sauga namwanamwana Yaubada iyeliwa ami sauga yabubu koina na tabu tulutulu kana sauga koina. ");
INSERT INTO tte_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Walo yawasosi, sauga bwaine koina ikololososi kaiwena saugana Yaubada yanuwa yaulina iyamayale koina yo kanasiga kabona, nige yabo nae bwaite besiele yo muli mena naene bwaite nige sowana iyawatagiliyoima. ");
INSERT INTO tte_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nae bwaine kana kaliyate tem Yaubada nige ikakabi-yakubwali tomo meuloili kani siboita, na iyamo Yaubada kaliyateline ikabi-yakubwali siya ana tomoyao gitegitesipwaili kaiweli. ");
INSERT INTO tte_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Yo sauga bwaine koina tem yaiya iwalo kolimiu, ‘Keliso bwaite’ o ‘Keliso bwaine’ tabu kwamemeliyan. ");
INSERT INTO tte_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kaiwena keliso mwakomwakotali yo palopitao mwakomwakotali naga siyawatagili yo kilakilala yo ginauli kaba nuwapwanopwano sipaisowaili yo kolili sowasowali Yaubada ana tomoyao gitegitesipwaili siwoyaili. ");
INSERT INTO tte_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Koina wagite-kalatagimiu kaiwena ginauli meuloina yawalo-baguna-yagili kabo muli mena kani siyawatagili.” ");
INSERT INTO tte_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yo sauga naenaenane kani iyawatagili, imwawasi kabo muli mena dabwelo iboniboniyai yo besiele waikena mayalena iboniboniyai. ");
INSERT INTO tte_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Yo utune bulibuli mena naga sibeku yo ginauli meuloili bulibuli mena Yaubada kani inukuili. ");
INSERT INTO tte_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Sauganane koina tomo meuloili kani Tomo Natuna sigitai yaloyaloi kalona mena ilalaoma me ana kaiwe yo me ana wasawasa pigapigabuna. ");
INSERT INTO tte_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yo ana aneloseyao kani iyawasali yo ana bodao gitegitesipwaili sikele-gogonagilima yanuwa yaulina meuloina dedeiliyao kolili. ");
INSERT INTO tte_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Kaba gite saido koina yayakenayagimiu yakato tem saido liguli waluwaluli sikin wakatai yaikin kana sauga ikelakubwamako. ");
INSERT INTO tte_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Yo yaboyoi kilakilala yawalo-masalagiliko kolimiu tem toisabo sauga wagite-lobaili wakataiyako yakato yagu sauga pileyoima ikelakubwamako. ");
INSERT INTO tte_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yawalo yawasosi kolimiu, bwaite yaso nige sowana kwamwawasi kanasiga ginauliline meuloili siyawatagili. ");
INSERT INTO tte_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Naga bulibuli yo yanuwa yaulina simwawasi na iyamo yagu yakayakatai kolimiu kani nige sowana imwawasi.” ");
INSERT INTO tte_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nige yaiya ikakatai toisabo kaliyate yo toisabo sauga ginauliline kani siyawatagili. Besiele aneloseyao bulibuli mena nige sikakatai, yau besiele nige yakakatai, Tamagu ibomamo ikatai. ");
INSERT INTO tte_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Wagitekalatagimiu. Manimiyao silala. Kaiwena saugane ana laoma nige wakakatai.” ");
INSERT INTO tte_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kaba gite yaboyoi Yeisu iwalowen iwaloba, “Besiele tem tomo yabo kikiunamo ana nume ilogabaen. Ana topaisowao kaigeda kaigeda ali paisowa iwolegili yo iwalo kolili yakato ana nume sigitekalatan. Tabe gamwa togitekalatan iwalolau koina iwaloba, ‘Tabu ukekeno. Manim ilalalala.’ ");
INSERT INTO tte_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Komiu besiele, manimiyao silalalala. Kaiwena nume tanuwagana ana sauga laoma nige wakakatai nuwana lolau, nuwana boniyai luwaluwalina, nuwana yanuwa layalayanna, nuwana malala kikiuna. ");
INSERT INTO tte_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tabu ilaoma na ilobaimiu wakenokeno. ");
INSERT INTO tte_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tawae yawalowen kolimiu besiele yawalowen tomo meuloili kolili. Manimiyao silalalala.” ");
INSERT INTO tte_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kaliyate labuimo simiyamiya na mwalelikwa soina kana nuwatu-kalatan yo besiele soine koina pwalawa gaibumo nige kana ebweli, kani siginauli. Topwaoliyao lalakili yo loina kana toyakayakatai kamwasa siloyaloyai tem gubesi na Yeisu sikabikalatan wadam mena na siunuyamate. ");
INSERT INTO tte_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yo siba, “Tabu soine kalona mena Yeisu takakabi-kalatan kisi tomo simunamunai-yagila yo sikaleya kolila.” ");
INSERT INTO tte_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yeisu imiyamiya yanuwa Bedani koina Saimoni ana nume mena, bwaite Saimoni baguna iya tolepelo. Kekan saugana mena sine yabo ilusaema olo bwalaina namwanamwana botolina maisana lalakina ikalaiyama, isoke yo isuwai Yeisu kulukuluna mena. ");
INSERT INTO tte_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Yo tomo sinene sigitai na tupwaliyao simunamunai na sibomayoi siedeedede kolili siba, “Tawae kaiwena olone iyavenuwan? ");
INSERT INTO tte_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Sowasowana tem tagimwala-yani kaiwena maisana ilalakisosi, na manenane taolegili tobubutuma kolili.” Kabo sinene siyokoiyan. ");
INSERT INTO tte_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Na Yeisu iwalo kolili iba, “Besi. Kwamwanou tabu kwayokoyokoiyan kaiwena ginauli namwanamwasosina koliyau ipaisowai. ");
INSERT INTO tte_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tobubutumao sauga meuloina salimiu mena simiyamiya. Tem nuwanuwamiu kwasaguili kabo kwasaguili. Na yau kani nige mekamikava sauga meuloina. ");
INSERT INTO tte_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ginauli bwaitete ipaisowai koliyau kaiwena iya sowasowana mwa ipaisowai koliyau. Kwapigu iyaoloi-bagunayan sabi katububunagau pei salai kaiwena. ");
INSERT INTO tte_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yawalo yawasosi kolimiu, naga wasagu siguguyeyan tomo sibenalan yanuwa meuloina kolili tabe sine bwaite ana paisowa koliyau wasana siyawasa kana nuwatu-kalatan kaiwena.” ");
INSERT INTO tte_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kabo Yudasa Isikaliota, iya yabo yoli tuwelone kolili, ilau topwaoli lalakili kolili Yeisu sabi walo-masalanna. ");
INSERT INTO tte_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yudasa ana walo sibenalan yo siyaliyaya na siwaloyameli yakato maisana mane siwolena. Mwa Yudasa sauga namwanamwana isanai na Yeisu italamwan kolili na sikabikalatan. ");
INSERT INTO tte_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yudiya mumugali bwaite besiele. Beledi gaibu nige ebwelina kana soi kalona mena, kaliyate bagubagunana koina lamiyao siunuili mwalelikwa kanna kana nuwatu-kalatan kaiwena. Kaliyatenane koina Yeisu ana tobenaliyao sineli koina siba, “Taubala, toweya koina nuwanuwam mwalelikwa soina kanna kaiwem kakatububunan?” ");
INSERT INTO tte_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kabo ana tobenaliyao labui iyawasali yo iwalo kolili iba, “Kwalau Yelusalema yo tomo yabo waila patu ikalakalai kani ilobaimiu. Na tomone kwayamulikusuli. ");
INSERT INTO tte_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Yo mekamikava kwalusae nume mena yo nume tanuwagana koina kwawalo bwaite besiele. ‘Ama toyakayakatai iwawalo toisabo biliutusi kutalamwan na meyagu tobenaliyao mwalelikwa soina kanna kakatububunan na kakekan?’ ");
INSERT INTO tte_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kani iyakenayagimiu biliutusi lalakina kewa mena sikatububunanako. Na bwaine koina mwalelikwa soina kanna wakatububunan kaiwela.” ");
INSERT INTO tte_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yo tobenaliyao silau Yelusalema koina silusae, yo tawae besiele Yeisu iwalo-masalan kolili ginauli meuloili silobaili. Mwa numewa koina mwalelikwa soina kanna sikatububunan kaiweli. ");
INSERT INTO tte_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kabo lolau mena Yeisu me ana tobenaliyao silaoma. ");
INSERT INTO tte_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Saugana simiyasio sikekakekan Yeisu iwalo kolili iba, “Yawalo yawasosi kolimiu, tomo yabo luwala mena naga iwalo-masalagau, iya bwaite mekaukava kakekakekanne.” ");
INSERT INTO tte_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yo Yeisu ana walo bwaite kaiwena ana tobenaliyao sinuwapolowe. Kabo kaigeda kaigeda Yeisu koina sinelineli siba, “Taubala, yau nigele wa?” ");
INSERT INTO tte_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yeisu iba, “Tomonane iya yomiu tuwelo kolimiu yo iya mekaukava beledi kakalai kayabuta gaeba kaigeda kalona mena. ");
INSERT INTO tte_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Na Tomo Natuna kani ilau boita mena, besiele Buki Tabu koina iwalo-masalanako. Na iyamo kana towalo-masalani katekamkamnana. Tem inamwanamwa baguna sinana tabu ikakabiyan kaiwena maisa naenaesosina kani ilobai.” ");
INSERT INTO tte_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kekan luwana mena Yeisu pwalawa ikalai yo iwalo-muloloi yo ikivi yo iwolegili ana tobenaliyao kolili iba, “Bwaitete yogu, wakalai wakan.” ");
INSERT INTO tte_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Muli mena wain mekomwana ikalai yo kaiwena ikawatoki Yaubada koina yo iwolena na meuloili sinuma komwane koina. ");
INSERT INTO tte_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Saugana komwa iwolena kolili iba, “Bwaitete kwasinegu, iya kamwasa waluwaluna, wakalai kwanuma. Kani yaboita na kwasinegu ididi tomo meuloili kaiweli. ");
INSERT INTO tte_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yawalo yawasosi kolimiu, sauga bwaite yo sauga muli mena wain bwaite nige sowana koina yanumayoi yo kanasiga wain waluwaluna yanuma Yaubada ana kaba loina mena.” ");
INSERT INTO tte_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kabo muli mena wali yabo siwaliyan na siyawatagili sisae koya Olibe koina. ");
INSERT INTO tte_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yeisu iwaloyoi ana tobenaliyao kolili iba, “Masa kikiunamo meuloimiu kwayabubu-gabaegau besiele Buki Tabu ana walo-masala iba, ‘Yaubada kani sipi togitekalatan iunuyamate na sipi sitatagwaligwali.’ ");
INSERT INTO tte_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Naga yagu toloyoi mulina mena kani yabaguna Galili kabo komiu muligu mena kwalaowa.” ");
INSERT INTO tte_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita Yeisu kainana iyamaisa iba, “Bwagana tem meuloili siyabubu-gabaegiwo kani yabomamo mekamkava.” ");
INSERT INTO tte_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yeisu iba, “Kunuwatu-kalatan bwaite Pita, kansiga boniyai kamkam tauna nige naga ivavalam melabui na kuuvalayagau meyaiyona, yakato nige ukakataiyau.” ");
INSERT INTO tte_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kabo Pita iwalo kaiwe molosi iba, “Nige sowana yauvalayagiwo. Bwagana tem taboita yola labui.” Tobenaliyao meuloili besiele siwalo. ");
INSERT INTO tte_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Silau dedei esana Getesemani koina yo ana tobenaliyao kolili iwalo iba, “Bwaite koina kwamiyamiya na yau yalau yakawanoi Yaubada koina.” ");
INSERT INTO tte_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kabo Pita, Yemesa, yo Yoni yoli yaiyona iyoganli mekanakavao silau. Yo Yeisu me ana katekamkamna yo me ana nuwa polowe, ");
INSERT INTO tte_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","kabo iwalo kolili iba, “Nuwanae ilalakisosi kategu mena masa kikiunamo itabe-yamateyau. Bwaite koina kwamiyamiya na manimiyao silalalala.” ");
INSERT INTO tte_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yo Yeisu tupwana iutusaeyoi kabo italu-pwaopwaom ikawakawanoi yakato tem sowasowana kamkamnane bwaite Yaubada ikele-gabaen. ");
INSERT INTO tte_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Iwaloba, “Tamagu. Tamagu. Paisowa meuloina sowasowam, nuwanuwagu kamkamna kana komwa koliyau ukele-gabaen. Na tabu yau yagu nuwatu mena na kowa am nuwatu mena besiele kupaisowai.” ");
INSERT INTO tte_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yo ipileyoi yoli yaiyonawa ilobaili sikeno-boita. Pita iyanoi iba, “Saimoni, gubesi ukenokeno? Nige sowasowam sauga kikiunamo kaiwena kusilawa?” ");
INSERT INTO tte_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Iwaloyoi kolili iba, “Manimiyao sikaiwe yo wakawakawanoi na tabu Seitani itotonagimiu. Yaluyaluwamiu nuwanuwana na iyamo yomiu sibelu.” ");
INSERT INTO tte_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yo Yeisu isaeyoi ikawanoi besiele ana kawanoi bagubagunana. ");
INSERT INTO tte_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Yeisu saugana ipileyoima ana tobenaliyao kolili ilobaiyoili sikenokeno, kaiwena manliyao sigibugibu. Iyanoiyoili sitolo me ali mwalimwaline nige ali walo yabo. ");
INSERT INTO tte_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yeisu tabe isaeyoi ikawakawanoi ana pileyoi yaiyonana koina ilobaili sikenomate yoi kabo iwalo kolili iba, “Gubesi, nagamo wakaikaiyawasi, mwa wakenokenone? Besi. Sauga iyawatagiliko. Wagitai, Tomo Natuna kana towalo-masala iyawatagiliko na kani iyauyan tomo naenaeli nimali mena. ");
INSERT INTO tte_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kwatolo na talau. Kagu towalo-masalawa iyaele ilalaoma.” ");
INSERT INTO tte_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yeisu iyaelemo iedeedede kabo Yudasa me ana bodao siyawatagilima. Yudasa iya yabo yoli tuwelone kolili, na bodane bwaite silaoma kaiwena topwaoli lalakili yo loina kana toyakayakatai yo tautaubalao siyawasali silaoma. Bodane kaleya kelepana yo kepata silokalaili. ");
INSERT INTO tte_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ali sauga laoma Yudasa kilakilala yabo iwalowen iba, “Tem yaiya yasapwali bwaimwa iya Yeisu, wakabi-kalatan na kwalawan wagite-kalatan namwanamwai kisi iyabubu.” ");
INSERT INTO tte_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ee kabo Yudasa ilodudulaimo ilau Yeisu koina ikawatoki iba, “Toyakayakatai.” yo isapwali. ");
INSERT INTO tte_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kabo bodaline Yeisu sikabi-kalatan. ");
INSERT INTO tte_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yeisu ana bodaone kolili kaigeda itotolo salina mena ana kaleya kelepana iniwisiyama ana kaba miya mena yo topwaoli lalakina ana topaisowa tenana ikoutusi. ");
INSERT INTO tte_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yo Yeisu iwalo Yudasa me ana bodao kolili iba, “Gubesi, yakato yau toloinalikwa yabo? Mwa me ami kaleya kelepana yo me ami kepata kwalaoma yakato wakabi-kalatagau? ");
INSERT INTO tte_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kaliyate kaigeda kaigeda yau mekamikava yayakayakatai Nume Tabu kalona mena tomo kolili na nige wakakabi-kalatagau. Na besi, waginauli kaiwena palopitao ali walo-masala Buki Tabu kalona mena iyawatagiliko besiele.” ");
INSERT INTO tte_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kabo Yeisu ana tobenaliyao meuloili siyabubu-gabaen. ");
INSERT INTO tte_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Yo kilakai yabo iya Yeisu kana tomuliya kana kwama kaigedamo kabo tokaleyayao sitonan tem sikabikalatan, ");
INSERT INTO tte_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","na iyabubu kana kwama isagena-yabeku mekwapi bwagabwagana iyabubu. ");
INSERT INTO tte_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yo Yeisu siyogan siluseyan topwaoliyao ali taubala ana nume mena. Na numene koina topwaoli lalakili yo tautaubalao yo loina kana toyakayakataiwo silogogoko simiyamiya. ");
INSERT INTO tte_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Yo Pita iyamuli-kusulili iya imuliye-molosi kanasiga topwaoliyao ali taubala ana nume bakubakuna mena. Bwaine koina Pita imiyasio tokaleyayao salili mena na mayau mena imwasimwasiguli. ");
INSERT INTO tte_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Topwaoli lalakili yo tautaubalao meuloili nuwanuwali Yeisu ana pwanoli siloyai na yakato tomo ali yakewane koina yaina silobai na Yeisu siunuyamate na iyamo nige yabo silolobai. ");
INSERT INTO tte_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Toyakewa mwakomwakotao sibaibaiwa siwalo-masala na iyamo ali walo-masala nige sitotoyatoyawa. ");
INSERT INTO tte_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Yo tupwali sitolo Yeisu siyakewa bwagabwagai. ");
INSERT INTO tte_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Siba, “Ana walo yabo kabenalan, yakato Nume Tabu bwaite tomo sikabi naga isoke-gabaen na kaliyate yaiyona koina ikabiyoi na nige tomo nimali mena.” ");
INSERT INTO tte_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Na iyamo ali walo-masala ginauli bwaite kaiwena nige sitotoyatoyawa. ");
INSERT INTO tte_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kabo topwaoliyao ali taubala manli mena itolo yo Yeisu ineliyan iba, “Gubesi, mwa nige kainali kuyayamaisane? Tomo bwaitete ali yakewa koliwo kubenalanako?” ");
INSERT INTO tte_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Na Yeisu imwano-mwanoumo. Bwagana siyakewa bwagabwagai na iyamo nige kainana. Yo topwaoliyao ali taubala Yeisu koina ineliyoi iba, “Walo yawasosi? Kowa Mesaiya, Yaubada Natuna o nigele?” ");
INSERT INTO tte_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yeisu iba, “O, yau. Naga kani wagitai Tomo Natuna Tokaiwesosi ulaulana mena imiyasio tabe bulibuli yaloyaloina pwatali mena kani ilaoma.” ");
INSERT INTO tte_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Topwaoliyao ali taubala imunamunai Yeisu ana walo kaiwena mwa koina ibomayoi kana kwama itabeigali na iwaloba, “Besi. Tabu toyakewa yabo iwawaloyoi. ");
INSERT INTO tte_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ana walo kawasewa kwabenalanako. Na tawae ami nuwatu Yeisu kaiwena?” Yo meuloili sitolo siba, “Sowasowana taunuyamate.” ");
INSERT INTO tte_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tupwali tomo Yeisu sikaikaisoi yo manna kwama mena sisuma yo siunui me ali talawasi siba, “Kuwalo kolimai yaiya iunuunuiwo?” Yo tokaleyayao Yeisu sikabi-kalatan na siunuunui. ");
INSERT INTO tte_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita ganamuli mena imiyamiya yo topwaoli lalakina ana topaisowa vesala yabo ilaoma. ");
INSERT INTO tte_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Yo sinene igitai Pita imwasimwasiguli imankulakulai yo iba, “Kowa Yeisu game Nasaleta mekamkava kwamiyamiya.” ");
INSERT INTO tte_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Na iyamo Pita iuvala iba, “Bwaimwa walone yau nige yakakatai.” Mwa Pita iutu-yawatagili gamwa mena na kamkam tauna ivalam. ");
INSERT INTO tte_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tabe vesalane Pita igitaiyoi nimana iyagayan koina na bodane kolili iwaloba, “Bwaine tomone iya Yeisu ana boda yabo.” ");
INSERT INTO tte_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pita walone ibenalan kabo iuvalayoi. Na sauga kubwakubwana koina tomanmanbubune Pita koina siwaloba, “Kumwakota, kowa Yeisu ana boda yabo, kaiwena kowa tomo Galili.” ");
INSERT INTO tte_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Na Pita iwaloba, “Kagu lulu Yaubada, yawalo yawasosi kolimiu, tomone kaiwena kwawalowalone yau nige yakakatai.” ");
INSERT INTO tte_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sauganane koina kamkam tauna ivalamyoi labuina kabo Pita nuwana mena isae Yeisu ana walo koina, yakato muli mena kamkam tauna ivalam labuina iya kani iuvalayan meyaiyona. Kabo Pita katena ikamkamnasosi yo ivalam. ");
INSERT INTO tte_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Yanuwa ilayan malala kikiuna topwaoli lalakili yo tautaubalao yo loina kana toyakayakatai yo toloinao meuloili silogogoma kabo siloina Yeisu kaiwena. Nimana sipan yo silawan Pailato koina sabi yatala. ");
INSERT INTO tte_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Yo Pailato Yeisu ineliyan iba, “Gubesi, kowa Yudiya ali kini?” Kabo Yeisu iba, “Tawae kuwalowen bwaimwa iyaele.” ");
INSERT INTO tte_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kabo topwaoli lalakili ginauli meuloili kaiweli Yeisu siyakewai. ");
INSERT INTO tte_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Mwa Pailato Yeisu ineliyanyoi iba, “Gubesi, ali yakewaiwone kaiwena kani kainali kuyamaisa? Ugitai ginauli sibaibaiwa kolili siyakewaiwo.” ");
INSERT INTO tte_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Na Pailato ana neli kaiwena Yeisu nige kainana iyayamaisa mwa koina Pailato nuwana ipwanopwano. ");
INSERT INTO tte_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pailato mumugana bwaite besiele. Bolime kaigeda kaigeda mwalelikwa soina kana sauga koina tolusae deli mena Yudiya tomoliyaone bodane sigitesipwai yabo kolili ilivasi na deli mena iyawatagili. ");
INSERT INTO tte_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Sauganane koina tomo esana Balabasi yo me ana bodao deli mena simiyamiya. Na siya simiyamiya deli mena kaiwena kaleya lalakina kalona mena tomo siunuyamateli. ");
INSERT INTO tte_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Yo Yudiya boda silogogoma sikawanoi Pailato koina tem sowasowana tomo yabo deli mena ilivasi kaiweli besiele ali kawanoi bolime kaigeda kaigeda koina. ");
INSERT INTO tte_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Pailato ikataiyako topwaoli lalakili Yeisu sikabikalatan na silawanama kaiwena silamwa-poloweyan, mwa koina Pailato ineliyagili iba, “Nuwanuwamiu yakato komiu Yudiya ami kini yalivasi kaiwemiu?” ");
INSERT INTO tte_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Na iyamo topwaoli lalakili tomo nuwatu naenaena nuwali mena sipeiyako yakato Yeisu sisikotanan na Balabasi esana sikatai yo ilivasi kaiweli. ");
INSERT INTO tte_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kabo Pailato ineliyoi kolili iba, “Na gubesi yagu loiloinayanna iya kwapeiyako ami kini?” ");
INSERT INTO tte_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Siyoga siba, “Kelose mena wakoyapatu.” ");
INSERT INTO tte_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Na Pailato ineli iba, “Tawae kaiwena? Tawae ana pwanoli?” Na siyoga kaiwe siba, “Kwayakelose.” ");
INSERT INTO tte_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kabo Pailato nuwanuwana boda ikabi-yaliyaya-yagili mwa koina Balabasi ilivasi, na ana tokaleyayao iloinayagili Yeisu balae mena sisapi. Muli mena Yeisu iwolena tokaleyayao kolili sabi koyapatuna kelose mena. ");
INSERT INTO tte_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kabo tokaleyayao Yeisu silawan Pailato ana nume mena siluseyan bwaine tokaleyayao ali dedei lalakina numene kalona mena yo tokaleyayao ali bodao siyoga-gogonagilima. ");
INSERT INTO tte_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kini kali kwama balabalagiyana koina Yeisu siyakwama yo kana pwaopwaom samasamali koina sipaisowai na kulukuluna mena sipei. ");
INSERT INTO tte_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kabo sitalawasiyan siba, “Aaa Guyau, Yudiya ali kini.” ");
INSERT INTO tte_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Yo ginagina mena Yeisu kulukuluna sisapisapi sikaikaisoi yo manna mena tutulili sitalu-sakonayan na sitalatalawasiyan. ");
INSERT INTO tte_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ali talawasi imwawasi kabo kini kwamana koina sisou-gabaen na iya kana kwama mena siyakwamai yo silawan sabi koyapatuna kelose mena. ");
INSERT INTO tte_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sailini tomona esana Saimoni iya Alekisana yo Lapuso tamali, iya yanuwa uloina koina ilaomaya, ilalaoma Yelusalema na silobai, kabo siyadidiga mwa Yeisu kana kelose ikewai. ");
INSERT INTO tte_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yeisu silawan yanuwa esana Goligota. Na Goligota kana bui kulukulu yanuwana. ");
INSERT INTO tte_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wain yo mula siebweli na siwolena yakato inuma na tabu kamkamna ilolotonan na iyamo Yeisu isikotanan. ");
INSERT INTO tte_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Yo Yeisu sikoyapatu kelose mena yo siyatolo. Muli mena tokaleyayao veku kikiuli sikalaili, venu yabo sivenuwan tem analiyao venune koina sibaguna kani Yeisu kana kwamao siwolegili kolili. ");
INSERT INTO tte_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Malala naen koloki koina Yeisu sikoyapatu kelose mena. ");
INSERT INTO tte_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Yo kana kelose mena silele ‘Yudiya ali kini’ kaiwena ali yakewaina besiele. ");
INSERT INTO tte_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yo tabe tokewali labui sikoyapatuli, yabo Yeisu ulaulana mena yabo gegebana mena. ");
INSERT INTO tte_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kabo Buki Tabu walone bwaite ‘Iya sipei loina kana toloinalikwa mekanakavao’ iyamala yawasosi. ");
INSERT INTO tte_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Yo siya tomo tologwaligwali ali lau koina Yeisu sitalatalawasi-yani yo sikawa-naenae-yani yo tabe kulukululi siyakwaleli siba, “Aaa, kuwalo yakato sowasowam Nume Tabu kusoke-gwaligwali na kaliyate yaiyona kolili ukwabiyoi. ");
INSERT INTO tte_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kelose kulogabaen na kuboma kuleboiwo.” ");
INSERT INTO tte_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bwaine besiele topwaoli lalakili yo loina kana toyakayakataiwo Yeisu sitalatalawasi-yani siba, “Tomo uloili ileboili na iyamo nige sowasowana iboma ileboi. ");
INSERT INTO tte_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yakato iya Mesaiya yo Isileli kana kini, naga kelosene ilogabaen na tagitai na tameliyani.” Tokewaliwa Yeisu mekanakavao sikoyapatuli kelose mena siya Yeisu tabe sisinali. ");
INSERT INTO tte_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pwasinasina mena dedei meuloina iboniboniyai kanasiga ilolau tili koloki. ");
INSERT INTO tte_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kabo sauganane koina Yeisu kainana lalakina mena iyoga iba, “Eloi, Eloi, Lama Sabakitani?” Kana bui “Yagu Yaubada, yagu Yaubada, tawae kaiwena kusikotanagau na kulogabaegau?” ");
INSERT INTO tte_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tomo tupwali salina mena sitotolo ana yoga sibenalan siba, “Kwabenali. Iyogayoga Ilaitiya kaiwena.” ");
INSERT INTO tte_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kabo tomo yabo isagena balou ikalai iyabuta wain malumaluluna koina yo ginagina mena isakona, iyagaseyan Yeisu sopana mena na iba, “Naga tasanasana nuwana masa kikiunamo Ilaitiya ilaoma na kelose mena ileboi.” ");
INSERT INTO tte_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yeisu kainana lalakina mena iyoga yo yawasina imwawasi iboita. ");
INSERT INTO tte_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Na kaleko tabatabana itaketake Nume Tabu kalona mena itaigali isae kewa yo ilobi yauli. ");
INSERT INTO tte_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kaleya kana tobaguna yabo Yeisu kana kelose manna mena itotolo. Yeisu ana yoga ibenalan yo ana boita kana koleya igitai kabo iba, “O, walo yawasosi bwaitete iya Yaubada Natuna.” ");
INSERT INTO tte_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tupwali sinesineo sitolo-suwala simanman-kulakulai bwaimwa Salome yo Meli Magidala me ana waliesa iya Yosese yo Yemesa sinali, Yemesane esana sipei Yemesa kikiuna. ");
INSERT INTO tte_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Saugana Yeisu itakitakikili Galili dedeina mena siya bwaite sinesineone siyamuli kusuli Yeisu sisagusagui. Tabe sinesineo sibaibaiwa tupwaliyao Yeisu mekanakavao silaoma Yelusalema siyaele bwaine koina kelose simanman-kulakulai. ");
INSERT INTO tte_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Na kaliyatene kabona esana kaliyate kaba katububu. Esana bwaite sipei kaiwena bwaliga Yudiya ali Sabati. ");
INSERT INTO tte_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Mwa lolau mena Yosepa, game Alimadiya, ilaoma, iya tomo esana lalakina yabo Yudiya ali toloinao kaloli mena. Isanasana Yaubada ana kaba loina kaiwena. Me ana katepatu ilusae Pailato manna mena na Yeisu yona ikawanoiyan. ");
INSERT INTO tte_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Saugana Pailato wasa ibenalan yakato Yeisu iboitako katena ipitali. Yo kaleya kana tobaguna iyoganama yo Pailato ineliyan iba, “Gubesi, walo yawasosi Yeisu iboitako?” ");
INSERT INTO tte_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tokaleyane ginauli meuloina iwalo-masalagili Pailato koina kabo Pailato Yeisu yona italamwan Yosepa koina ikalai. ");
INSERT INTO tte_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mwa Yosepa kaleko mayamayalena igimwalai ikalaiyama kabo Yeisu yona kelose mena iyaigabaen yo kalekone koina isuma muli mena ipei salai mena. Salaine sikeli nonowaiyako besiele dupa veku kalona mena yo Yosepa veku lalakina iyatapipiliyama salai gamwana ikausi. ");
INSERT INTO tte_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meli Magidala me ana waliesa iya Yosese sinana sigitagitai toweya koina Yosepa Yeisu yona ipei. ");
INSERT INTO tte_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Yudiya ali sabati bwaimwa ala Satade, imwawasiko Meli Magidala me ana waliesa yo tabe Salome olo bwalaina namwanamwana sigimwalai yakato silau Yeisu yona siyaoloi. ");
INSERT INTO tte_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Wiki kana kaliyate bagubagunana koina malala kikiuna sinesineowa silalau Yeisu kana salai kaiwena. ");
INSERT INTO tte_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Yo silolo-edeedede siba, “Tem yaiya vekune kani iyatapipili-suwalan na salai gamwana isoke kaiwela?” Kaiwena vekune ilalakisosi. Saugana silaoma salai mena manli isae sigitai vekuwa siyatapipili-suwalanako. ");
INSERT INTO tte_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kabo sinesineowa salai kalona mena silusae. Ulaulali mena kilakai yabo kana kwama mayamayalena imiyamiya sigitai kabo kateli sipitali sisiliyata. ");
INSERT INTO tte_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Iwalo kolili iba, “Tabu wakakatewakaka. Yeisu game Nasaleta siyakelose kwaloyaloyai iya bwaite koina nige imiyamiya. Boita mena itoloyoiko. Wagitai bwaite koina sipeiya. ");
INSERT INTO tte_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kwalau ana tobenaliyao kolili kwawalo-masala, tabe Pita besiele koina, kwawaloba, ‘Yeisu ibagunako Galili na komiu kabo kwalaowaya wagitai, besiele ana walo kolimiu.’” ");
INSERT INTO tte_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kabo salai mena siyawatagili mwayamwayau yo siyabubu kaiwena nuwali sipwanopwano yo sitabutabubu me ali matausi. Nige yaiya yabo koina siwawalo-masala kaiwena simatausi. ");
INSERT INTO tte_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Wiki kana kaliyate bagubagunana Sabati malala mena Yeisu itoloyoi, yo itolo-mayale baguna Meli Magidala koina. Bwaite iya baguna yaluyaluwa biki seben silusae koina na Yeisu itao-yawatagilagili. ");
INSERT INTO tte_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kabo Meli ilau Yeisu kana tomeliwo siya tauna kona mekalikava sitakitakikili ali wasa iwolegili na siya nagamo me ali nuwapolowe sivalavalam Yeisu kaiwena. ");
INSERT INTO tte_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Saugana Meli wasa iwolegili iba, “Yeisu itoloyoiko, yagitai.” Na nige ana walo simemeliyan. ");
INSERT INTO tte_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Na tomo labui Yelusalema silogabaenako yo kwabu mena silalau yanuwa yabo kaiwena. Kabo Yeisu itolo-mayale kolili koleya uloina koina. ");
INSERT INTO tte_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Muli mena kabo yoli labuine sipileyoi Yelusalema, kalikavao kolili siwalo-masala, na iyamo ali walo nige simemeliyan. ");
INSERT INTO tte_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Muli mena ana tobenaliyao yoli ilebeni sikekakekan kabo Yeisu manli mena itolo-mayale. Iyokoiyagili ali kololo kaiwena iba, “Kaukavao, siya yagu toloyoi mulina mena sigitaiyau yo kolimiu siwalo-masala na tawae kaiwena ali walo nige kwamemeliyan?” ");
INSERT INTO tte_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yo iwalo kolili iwaloba, “Kwalau dedei meuloina kolili wasana namwanamwana waguguyeyan tomo meuloili kolili. ");
INSERT INTO tte_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tem yaiya imeliyagau na ibabitaiso kani lebo ilobai. Na tem yaiya nige imemeliyagau naga Yaubada ana loina kaikaiwena ilobai. ");
INSERT INTO tte_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Yo kagu tomeline kilakilala kaikaiweli kani sipaisowaili esagu mena, kaba gite besiele, yaluyaluwa biki tomo kolili kani sitao-yawatagilagili yo baguna kaina uloi uloi nige sikakatai na kabona kani kolili siedeedede. ");
INSERT INTO tte_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Tem weso naenaena nimali mena sikalaili, nuwana waila kelakelabasina sinuma nige sowana siboita yo tabe tem nimali sipei tokasiebwao kolili kani sinamwanamwa.” ");
INSERT INTO tte_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Guyau Yeisu ana walo iyemwawasi ana tobenaliyao kolili kabo Yaubada Yeisu ikalai ilawan bulibuli mena. Kabo Yeisu Yaubada ulaulana mena imiyasio. ");
INSERT INTO tte_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yo tobenaliyao silau dedei meuloina kolili Yeisu wasana siluwewasa-yani. Guyau isaguili yo ana kaiwe mena kilakilala sipaisowaili na koina tomo sigitaili yo wasana namwanamwana simeliyan. ");
INSERT INTO tte_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Ae taubala Tiopilo. Saugana Yeisu imiyamiya yanuwa yaulina mena tomeli tupwali luwamai mena ana paisowa meuloina sigitai manli mena. Ana boita mulina mena wasana siyawasayan yo sikawa-yawasosiyan kolimai. Na tomo sibaibaiwa wasanane silele-lobiyenako. ");
INSERT INTO tte_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Na yau Luka tabe wasanane edeededeliyao meuloili yaloyaloyaili na yatano-gogonagilima. Edeededeliyaone iyatubuya ana kabi koina ilau yo kanasiga ana sae bulibuli mena na mesabana kali lau sidudulai yo inamwanamwa. Koinaele yanuwatui inamwanamwa tem yalele-lobi-yegili kowa tomo lalakina Tiopilo kaiwem, na mesabana ukwatai tawae tomeliwo siyakayakatai-yanako koliwo bwaimwana walo yawasosi. Mwa bukine bwaite yalele ilalaowa koliwo. ");
INSERT INTO tte_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Saugana kin Elodi dedei Yudiya iloiloinayan na topwaoli yabo iya esana Sakalaiya iya imiyamiya topwaoline Abaidiya ana boda kalona mena, wainena esana Elisabeti, iya tabe ilaomaya Eloni ana susu koina, na Eloni iya Mosese kanakava yo topwaoli bagubagunana. ");
INSERT INTO tte_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Yoli labuine ali miyamiya inamwanamwasosi Yaubada manna mena na Yaubada ana loina yo ana walo meuloina iyaele Buki Tabu beyabeyana koina simuliya namwanamwai. ");
INSERT INTO tte_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabeti me wainena Sakalaiya silike. Nige natuli ipapagan kaiwena Elisabeti imiyayai. ");
INSERT INTO tte_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sauga yabo Sakalaiya ana bodao ali sauga paisowa na Sakalaiya iya iyaele topwaoli ali paisowa ipaipaisowai Yaubada manna mena. ");
INSERT INTO tte_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kabo veku mena venu yabo sivenuwan besiele topwaoli ali loina na mesabana tomo yabo sigitesipwai na ilusae Yaubada ana Nume Tabu kalona mena ginauli bwalaina namwanamwana inisensi igabu kaba gabugabu pwatana mena. Sakalaiya iya gitesipwa ilobai kabo iya ilusae Nume Tabu kalona mena. ");
INSERT INTO tte_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Na inisensi sauga gabuna koina, totapwalolo boda lalakina siyaele gana muli mena sikawakawanoi. ");
INSERT INTO tte_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sakalaiya iyaele Nume Tabu kalona mena kabo Yaubada ana anelose yabo iyawatagili inisensi kaba gabugabuna dedei ulaulana mena. ");
INSERT INTO tte_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Saugana Sakalaiya anelosene igitai kabo katena ipitali yo imatausi. ");
INSERT INTO tte_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Na anelosene iwalo koina iba, “Sakalaiya, tabu kumamatausi, am kawanoi Yaubada ibenalanako. Koinaele wainem Elisabeti natum tauna kani ikabiyan kabo esana kupei Yoni. ");
INSERT INTO tte_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Iya kani nuwamiu ikabi-namwanamwaili yo kwayaliyaya yo tomo sibaibaiwa naga kani siyaliyaya ana yawatagili kaiwena, ");
INSERT INTO tte_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","kaiwena iya esana kani ilalaki Yaubada manna mena. Tabu wain yo waila kaikaiwena inunuma. Saugana tem sinana ikabi kani Yaluyaluwa Tabuna iloyapowon yo tabe besiele ana lalaki koina Yaluyaluwa Tabuna iloyapowon. ");
INSERT INTO tte_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Siya Yudiya, bwaimwa boda Isileli, sibaibaiwa kani ikele-yapileyoili silaoma Yeoba ali Yaubada koina. ");
INSERT INTO tte_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yoni mumugana yo ana kaiwe besiele palopita Ilaitiya yo iya ibagunama kabo muli mena Guyau iyawatagili. Yo iya kani tomo iyanuwabuili, na tamaliyao yo natuliyao ikele-yapileyoilima siyamala boda kaigeda, yo siya togamwapanapanawa nige Yaubada siyayakasisiyan ikele-yapileyoili nuwatu namwanamwana sikalai besiele siya todudulai ali nuwatu na mesabana tomo ikatububunagili Guyau ana laoma kaiwena.” ");
INSERT INTO tte_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kabo Sakalaiya iwalo anelosene koina iba, “Toisabo kilakilala kani kupaisowai na yakatai am walone iyamala yawasosi? Kaiwena yau yalikeko yo wainegu tabe besiele ilike.” ");
INSERT INTO tte_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anelosene Sakalaiya kainana iyamaisa iba, “Yau Gabeliela, sauga meuloina yatotolo Yaubada manna mena, iya iyawasayau yalaoma yaedeedede koliwo yo wasa namwa-namwana bwaite yayawasayan koliwo. ");
INSERT INTO tte_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Na nige yagu walo kumemeliyan koinaele kani kilakilala bwaite yapaisowai. Kani nige kainam ipapagan kanasiga kaliyatenane koina yagu waloyameli yawalowenako koliwo iyamala yawasosi.” ");
INSERT INTO tte_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Siya totapwalolone siyaele sisanasana Sakalaiya kaiwena, yo sinuwapwanopwano gubesi na imiya-mamalawe Nume Tabu kalona mena. ");
INSERT INTO tte_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Saugana iyawatagilima nige sowana iedeedede, nimanamo iyapaisowa kolili, kabo tomo meuloili sikatai yakato yakenayan yabo iyawatagili koina Nume Tabu kalona mena. ");
INSERT INTO tte_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakalaiya ana sauga pwaoli paisowana imwawasi, kabo ipileyoi ana yanuwa mena. ");
INSERT INTO tte_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kabo wainena Elisabeti isiuma. Sauganane isiuma waikena valigigi kalona mena nige iyayawatagili mayale mena imiyamiyaya nume mena kaiwena siya Yudiya mumugali. ");
INSERT INTO tte_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kabo Elisabeti iba, “Yaubada yagu miyayaine mwalimwalinena ikele-gabaen tomo manli mena. Mwa sauga bwaite koina isaguiyau.” ");
INSERT INTO tte_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Saugana Elisabeti isiuma ana waikena sikisi (6) Yaubada ana anelose Gabeliela iyawasa sine nuwanuwabolana koina esana Meli, iya imiyamiya Nasaleta Galili dedeina mena. Iya ikawakawalulu tomo esana Yosepa koina Deibida ana susu koina. ");
INSERT INTO tte_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anelosene ilaoma koina yo iba, “Daumwali koliwo. Yaubada imulolo lalakina koliwo yo iya mekamkava.” ");
INSERT INTO tte_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Na iyamo Meli me ana katewakaka imatausi anelosene ana walo kaiwena. Meli inuwanuwatu, “Tawae walone bwaite kana katai?” ");
INSERT INTO tte_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kabo anelosene iwalo koina iba, “Meli, tabu kumamatausi, kaiwena Yaubada imulolo koliwo. ");
INSERT INTO tte_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kani kusiuma yo ukabi natum tauna na esana kupei Yeisu. ");
INSERT INTO tte_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Iya kani tokaiwe, yo tomo kani siyogayani Yaubada Tomiyasaesosi Natuna. Yeoba ala Yaubada kani loina kaikaiwena iwolena besiele beyabeyana iwolena tubuna Kin Deibida koina. ");
INSERT INTO tte_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yo Isileli tomoliyao, Yakobo ana bodao, kani iloinayagili, nige ana kaba mwawasi.” ");
INSERT INTO tte_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Meli anelosene kainana iyamaisa iba, “Gubesi kani ana yawa-yawatagili? Yau nuwanuwabolagu.” ");
INSERT INTO tte_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","37","Kabo anelosene iwalo Meli koina iba, “Yaubada ginauli meuloina sowasowana ipaisowaili. Yaluyaluwa Tabuna kani ilobima koliwo yo Tomiyasaesosi ana kaiwe mena kusiuma. Kabo melumelune esana kani sipei Yaubada Natuna kaiwena iya tabutabuna. Kubenali sauga bwaite. Elisabeti, am susu iya ikedukeduluma. Na tabe iya besiele isiuma natuna tauna. Tomo meuloili sibatoko kani nige melumelu ilolobai, na iyamo iya isiuma kabona ana waikena sikisi (6).” ");
INSERT INTO tte_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mwa Meli iba, “Yau Yaubada ana topaisowa. Besimo na tawae kuwaloweni iyawatagilima koliyau.” Kabo anelose Meli ilogabaeni. ");
INSERT INTO tte_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Sauganane koina Meli itolo, ikatububu yo mwayamwayau ilau Yudiya yanuwana yabo, iyaele koya mena koina. ");
INSERT INTO tte_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Saugana iyawatagili mwa ilau ilusae Sakalaiya ana nume mena yo ikawa-toki Elisabeti koina. ");
INSERT INTO tte_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Meli ana kawatoki Elisabeti ibenalani, kabo melumelune Guyau sinana kainana ikilala mwa imwasali diyana mena. Elisabeti Yaluyaluwa Tabuna iloyakalapowoni, ");
INSERT INTO tte_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","kabo kainana lalakina mena iwalo Meli koina iba, “Yaubada imuloloiwo, kam mulolo sine meuloili kali mulolo ilalaki-gabaegili. Yo melumelu bwaimwa kani ukwabiyani Yaubada imuloloi tabe. ");
INSERT INTO tte_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Gubesi kowa yagu Guyau sinana na kuyakasisi-yagau lalakina na kulaoma ugiteyau? ");
INSERT INTO tte_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Saugana am kawatoki yabenalani ilusae tenagu mena, kabo melumelu iyaliyaya yo imwasali diyagu mena. ");
INSERT INTO tte_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Yaubada imuloloiwo, kaiwena kumeli yakato kani iginauli besiele ana walo koliwo.” ");
INSERT INTO tte_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Kabo Meli iba, “Kategu Yeoba itobalani, ");
INSERT INTO tte_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","yo yaluyaluwagu iyaliyaya Yaubada yagu Tolebolebo koina. ");
INSERT INTO tte_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Na yatobalani kaiwena bwagana yau ana topaisowa nige yagu namwanamwa ipapagani iya ikatekamkamna-yagau na sauga bwaite yo sauga ilalaoma yaso yo yaso kani siedeedede kaiwegu siwaloba, ‘Yaubada imuloloi.’ ");
INSERT INTO tte_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Yatobalani kaiwena Yaubada Tokaiwesosi ginauli lalakili ipaisowai kaiwegu. Esanane yakayakasisina. ");
INSERT INTO tte_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yaso yo yaso kolili siya siyakasisiyani ana katekamkamna imiyamiya kolili. ");
INSERT INTO tte_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nimana koina ginauli lalakili ipaisowailiko yo siya siboma sipei-seyagili yo sinuwatui yakato esaline silalaki, na iyamo ali boda itatagwaligwali. ");
INSERT INTO tte_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Toloina lalakili ali kaba miya kolili ikalaili yo ipei-yataluli, na siya esali kikiuli ipei-seyagili. ");
INSERT INTO tte_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ginauli namwanamwali isoiyagiliko toguliyam kolili sikalapowoni, na towasawasa iyawasali silau nima gaibuli. ");
INSERT INTO tte_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ana topaisowao boda Isileli isaguiliko, nige inunuwa-mwatainagili na ikatekamkamna-yagili yo isaguili, ");
INSERT INTO tte_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","besiele ana waloyameli tubulao kolili, besiele ana waloyameli Abelamo yo tubunao yaso yo yaso kolili.” ");
INSERT INTO tte_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Na Meli naga imiyamiya Elisabeti koina sauga kana mamalawe besiele waikena yaiyona, kabo muli mena ipileyoi ana dedei mena. ");
INSERT INTO tte_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabeti ana kabi kana sauga ilobai kabo ikabi natuna tauna. ");
INSERT INTO tte_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ana eliyamwao yo totounao wasa sibenalani yakato Yaubada Elisabeti imulolo lalakina koina, kabo mekalikava siyaliyaya toyawa. ");
INSERT INTO tte_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Melumelu ana kaliyate eit (8) ilobai kabo silaoma na nigwenigwe mumugana siginauli koina. Kabo muli mena yakato tamana Sakalaiya esana sipei-panaisan koina. ");
INSERT INTO tte_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Na sinana iba, “Imiyawa. Esana kwapei Yoni.” ");
INSERT INTO tte_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Na siwalo koina siba, “Am susuwo luwali mena nige yabo esa besiele bwaite.” ");
INSERT INTO tte_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kabo nimali mena siedeedede Sakalaiya koina sineliyan toisabo esa sipei melumelune koina. ");
INSERT INTO tte_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakalaiya kaba lelelele yabo ikawanoiyan kolili, kabo ilele iba, “Iya esana Yoni.” Kabo meuloili kateli ipitali. ");
INSERT INTO tte_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sauganane koina Sakalaiya kainana ipei yo memenana imalamalae yo sowasowana iedeedede, kabo iyatubu iedeedede yo Yaubada itobatobalan. ");
INSERT INTO tte_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Na ali elieliyamwao meuloili ginauli kaba nuwapwanopwano bwaite sigitai kabo simatausi lalakina. Yo wasa bwaite idebalala ilau yanuwa meuloili siya simiyamiya Yudiya dedeina mena yo koya kolili. ");
INSERT INTO tte_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tomo meuloili siya wasana sibenalani sinuwanuwatu yo sineli siba, “Nuwana bwaliga melumelu bwaite kani iyamala tomo lalakina yabo?” Siwalo besiele kaiwena sigitai Yaubada ana kaiwe koina imiyamiya. ");
INSERT INTO tte_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yoni tamana Sakalaiya Yaluyaluwa Tabuna iloyakalapowoni kabo ipalopisai Yaubada ana walo iwaloweni iba, ");
INSERT INTO tte_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Yaubada tatobalani iya Isileli ala Yaubada iya ilaoma kita ana tomoyao isaguila yo ilivasila. ");
INSERT INTO tte_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ana topaisowa Deibida tubunao luwali mena Tolebolebo kaikaiwena yabo iyatolo kaiwela, ");
INSERT INTO tte_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","besiele bagubagunana ana waloyameli palopitao yakayakasisili siwaloweni. ");
INSERT INTO tte_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Tolebolebone iya kani ileboila kala tokalomagigili meuloili kolili. ");
INSERT INTO tte_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kabo tubulao ikatekamkamna-yagili yo ana waloyameli bwaite iya iboma iginauli inuwatu-kalatani. ");
INSERT INTO tte_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Iwaloyameli tubula Abelamo koina, ");
INSERT INTO tte_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","yakato ileboila kala tokalomagigili kolili, kabo tabu tamamatausi, na me ala katepatu tapaisowa koina, yo sauga meuloina mumugala sidudulai yo sinamwanamwa manna mena. ");
INSERT INTO tte_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Na kowa natugu, kani tomo siba, ‘kowa Tomiyasaesosi ana palopita yabo’ kaiwena kubagunama yo kulau kamwasa ukwatububunan Guyau kaiwena, ");
INSERT INTO tte_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","yo ana tomoyao kani kuyanuwapeili mumugali naenaeli kolili sinuwabui. Guyaune mumugana ibiga yo ala Yaubada ana katekamkamna koina iloyakalapowon, nuwanuwana tomo ali pwanoli inuwatu-pwaikili na lebo silobai. Lebo mayalena kani itunsae kolila, ");
INSERT INTO tte_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","kabo siya boniboniyai yo boita dedeina koina simiyamiya mayale silobai. Yo kabo meuloila ibaguna-yagila nuwa-daumwali kana kamwasa koina.” ");
INSERT INTO tte_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Melumelu ilalalaki yo Yaluyaluwa Tabuna iloyakalapowon. Kabo ilau imiya-suwala dedei leleyanna yo wedowedoli koina. Yoni imiyamiya bwaine koina kanasiga iyawatagili tomo Yudiya (Isileli) manli mena kabo iguguye kolili. ");
INSERT INTO tte_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Elisabeti ikabiko kabo Sisa Ogosito loina iyawasa tomo meuloili kolili siya simiyamiya Loma ana kaba loina yaulina mena. Loinane iba tomo meuloili silau na esaliyao sileleli loina bukina koina. ");
INSERT INTO tte_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Bwaite sensisi bagubagunana iyawatagili saugana Kuliniyasi iya Siliya dedeina ali gavana. ");
INSERT INTO tte_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mwa meuloili silau ali yanuwa mena na mesabana esaliyao sileleli. ");
INSERT INTO tte_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kabo Yosepa Nasaleta ilogabaen Galili dedeina mena yo ilau yanuwa Bedeliema bwaimwa dedei Yudiya. Bwaite yanuwane wasana ilalaki kaiwena Deibida ana yanuwa. Na Yosepa Deibida ana susu koina ilaoma mwa ilau Bedeliema. ");
INSERT INTO tte_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yosepa mekanakava Meli silau na esali silele kaiwena iya ikawakawalulu Meli koina yo tabe kikiunamo Meli ikabi. ");
INSERT INTO tte_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Saugana Yosepa te Meli simiyamiya Bedeliema Meli ana sauga ilobai kikiunamo ikabi. Bedeliema kalona mena kaba kaiyawasi siloyaloyai na nige yabo silolobai. Na ebaebai ali kaba keno numena silobai kabo koina Meli ikabi natuna tauna, iya natuna tobagubaguna. Meli melumelune isuma kaleko tupwatupwali kolili yo ibui ebaebai ali kaba kekan koina. ");
INSERT INTO tte_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Boniyainane koina sipi togitekalatan tupwaliyao simiyamiya dedeinane koina, bubu mena ali sipi sigitegite-kalatagili. ");
INSERT INTO tte_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kabo Yaubada ana anelose iyawatagili kolili. Yo ana wasawasa mayalena imayale-takikilagili mwa simatausi lalakina. ");
INSERT INTO tte_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Yo anelosene iwalo kolili iba, “Tabu kwamamatausi, wasa namwanamwana yakalaiyama kolimiu kani tomo meuloili ali kaba yaliyaya. ");
INSERT INTO tte_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kabona kami tolebolebo Mesaiya sikabi Deibida ana yanuwa mena. ");
INSERT INTO tte_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ami kaba kataina bwaite besiele. Ebaebai ali kaba keno numena kalona mena melumelune kani kwalobai sisuma kaleko tupwatupwali kolili na sibui ebaebai ali kaba kekan koina ikenokeno.” ");
INSERT INTO tte_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kabo mwayamwayau mena anelose bodaliyao silobima bulibuli mena yo mekalikava anelose bagubagunana siyaboda kaigeda. Meuloili Yaubada sitobatobalani siwaloba, ");
INSERT INTO tte_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Yaubada bulibuli mena tatobalan. Na yanuwa yaulina mena daumwali ilau siya analiyao Yaubada iyaliyaya kolili.” ");
INSERT INTO tte_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kabo aneloseyao sipi togitekalatani silogabaegili yo sipileyoi bulibuli mena. Na sipi togitekalatan sibomayoi siedeedede, siba, “Talau Bedeliema na tagitai tawae bwaite ginauline iyawatagili, bwaine Yaubada ana walo-masala kolila anelosene gamwana mena.” ");
INSERT INTO tte_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mwa sipi togitekalatan mwayamwayau mena silau yo silobaili Meli te Yosepa ebaebai ali kaba keno numena kalona mena. Tabe sigitai melumelune ebaebai ali kaba kekan koina ikenokeno. ");
INSERT INTO tte_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Imwawasi silau yo wasana siyawasa tomo kolili tawae anelose ana walo melumelune kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tomo meuloili kateli sipitali yo sisiliyata saugana sipi togitekalatan ali walo sibenalan. ");
INSERT INTO tte_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Na Meli nuwatu meuloina iwadamli katena mena, na inuwatu-kalatagili sauga meuloina. ");
INSERT INTO tte_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Yo sipi togitekalatani sipileyoi me ali yaliyaya yo me ali tobali yo Yaubada sikawakawatoki koina tawae sigitaiyako yo sibenalan, tawae anelose ana walo kolili. ");
INSERT INTO tte_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Saugana melumelune ana kaliyate eit (8) ilobai, kabo nigwenigwe mumugana siginauli koina besiele Yudiya mumugali. Imwawasi esana sipei Yeisu, besiele esa bwaite tauna kona anelose iwalowen-bagunayan muli mena kabo sinana isiuma. ");
INSERT INTO tte_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Meli ana sauga mogi imwawasi kabo Meli yo Yosepa nuwanuwali silau Nume Tabu Yelusalema koina na mesabana Meli kana kawa-namwanamwa ikalai yo besiele tabe Yeisu kana walo-mulolo ikalai. Meli kana kawa-namwanamwa kaiwena kani man sikalaili sipwaoli-yagili Yaubada koina besiele Mosese ana loina iba ‘Bunetutu labui o nuwana bunebune labui sikalailima.’ Na Yeisu kana walo-mulolo kaiwena kani silawan Nume Tabu Yelusalema koina sabi olenayanna Yaubada koina besiele Yaubada ana loina silele Buki Tabu kalona mena iba, ‘Tobagubaguna melumelu tataoliyao meuloili kwayakasisi-yagili Yaubada koina.’ Kabo Yosepa yo Meli mekalikava melumelune silau Yelusalema paisowane bwaite kaiweli. ");
INSERT INTO tte_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tomo yabo imiyamiya Yelusalema esana Simioni, mumugana idudulai yo imeli yawasosi Yaubada koina yo Yaluyaluwa Tabuna imiyamiya koina yo isanasana Isileli ali Tolebolebo kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Yaluyaluwa Tabuna ana yawatagili koina iyanuwapei kani nige iboboita kanasiga Mesaiya bwaite Yaubada iwaloyameli igitai manna mena. ");
INSERT INTO tte_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na Yosepa yo Meli siyaele Nume Tabu kalona mena sisanasana topwaoli yabo kaiwena yakato tem ilaoma na melumelune iwalo-yakasisiyan Yaubada koina besiele Mosese ana loina. Kabo sauganane koina Yaluyaluwa Tabuna Simioni iyakenayan ilau ilusae Nume Tabu kalona mena. ");
INSERT INTO tte_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kabo Simioni ilusae ilobaili melumelune ikalai nimana mena isapwali yo Yaubada itobalan, ");
INSERT INTO tte_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","iwaloba, “Yaubada, sauga bwaite ilonamwayan am topaisowa kutalamwagau daumwali koina yaboita, besiele beyabeyana kuwaloyameli koliyau. ");
INSERT INTO tte_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kaiwena yaboma mangu mena am lebo tomona yagitai, ");
INSERT INTO tte_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","bwaimwana ukwatububunan tomo meuloili kaiweli na sigitai. ");
INSERT INTO tte_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iya mayale, kabo siya nige Yudiya tomoliyao imayale kolili na am kamwasa sikatai, yo kai am tomoyao Isileli ikabi-wasawasa-yagimai.” ");
INSERT INTO tte_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Na Meli yo Yosepa kateli ipitali Simioni ana walo-tobali kaiwena bwaite iwaloweni melumelune kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kabo Simioni iwalo-muloloili yo iwalo Meli koina iba, “Kubenali, melumelune bwaite Yaubada igitesipwai boda Isileli sibaibaiwa ikeleyatololi lebo silobai yo sibaibaiwa tabe iya kaiwena sibeku nae silobai. Yaubada ipei iya ana kilakilala, na tomo sibaibaiwa sikawa-naenaeyani, ");
INSERT INTO tte_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","kabo ali nuwatu wadawadamna ipei-yawatagilagili mayale mena. Na kowa kamkamna kamnana besiele kaleya kelepana kani katem isakona.” ");
INSERT INTO tte_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kwabukwabuli yabo iya palopita esana Ana, Penuweli natuna ana susu Aseli na iya ikedukeduluma. Beyabeyana ikasole me wainena simiyamiya bolime kana baibaiwa seben, ");
INSERT INTO tte_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","kabo wainena iboita yo ikatububun. Na sauga bwaite ana bolime kana baibaiwa eiti powa (84). Iya sine yakayakasisina kaiwena sauga ibaibaiwa imiyamiya Nume Tabu koina, boniyai yo kaliyate kawanoi kaiwena me kana guliyam ikalakisiyeyan. Ikawakawanoi yo itapwatapwalolo Yaubada koina. ");
INSERT INTO tte_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Sauganane koina iyawatagilima Nume Tabu kalona mena ilau Meli yo Yosepa kolili kabo melumelune igitai yo ikawatoki Yaubada koina melumelune kaiwena. Imwawasi iedeedede tomo meuloili kolili siya siyaele Nume Tabu kalona mena melumelune kaiwena. Siya meuloili Ana ana edeedede sibenabenalan sisanasana Mesaiyane iya yakato Yelusalema ileboi Loma ali loina koina. ");
INSERT INTO tte_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Melumelune Yeisu kana walo-mulolo sibenalan kabo Yosepa yo Meli pwaoli sigabu Meli ana kawa-namwanamwa kaiwena besiele Yaubada ana loina koina. Imwawasi kabo mekalikava melumelune sipileyoi silau ali yanuwa mena Nasaleta dedei Galili koina. ");
INSERT INTO tte_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yo melumelune me ana kaiwe ilalaki isaesae yo sonoga ikalapowoni yo Yaubada ana katekamkamna imiyamiya koina. ");
INSERT INTO tte_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bolime kaigeda kaigeda Yeisu tamana yo sinana silaulau Yelusalema mwalelikwa soina kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Saugana Yeisu ana bolime kana lalaki tuwelo, kabo me tamana yo sinana silau soine kaiwena besiele tamana yo sinana siginaginauli. ");
INSERT INTO tte_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Soine imwawasi, Meli yo Yosepa yo tomo meuloili sipipileyoi ali yanuwa mena. Na gamene Yeisu silogabaen Yelusalema, na tamana yo sinana nige sikakatai. ");
INSERT INTO tte_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ali nuwatu yakato iya iyaele boda luwali mena mekalikava silolo toyawa, kabo kaliyate meuloina silaulau. Yo tabe siloyaloyai totouliyao yo ali elieliyamwao kaloli mena. ");
INSERT INTO tte_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Na nige silolobai, kabo sipileyoi tabe silau siloyai Yelusalema. ");
INSERT INTO tte_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Na kaliyate yaiyona koina kabo silobai Nume Tabu kalona mena mekanakavao loina kana toyakayakataiwo simiyasio yo siedeedede iya ali edeedede ibenabenalan yo inelineli-yagili. ");
INSERT INTO tte_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Siya analiyao ana walo sibenalani, kateli sipitali kaiwena me ana katai yo toyakayakatai ali neline iyamaisa-yadudulaili. ");
INSERT INTO tte_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Saugana tamana yo sinana sigitai kateli sipitali. Mwa sinana iwalo koina iba, “Natugu, gubesi mumuga bwaite uginauli kolimai? Yau yo tamam kanuwanuwatu lalakina yo kaloyaloya kaiwem.” ");
INSERT INTO tte_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kainana iyamaisa iba, “Gubesi mwa kwaloyaloyaiyau, sowasowana wakatai yau yamiyamiya Tamagu ana nume mena.” ");
INSERT INTO tte_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Na ana walo kana dudulai nige sikakatai. ");
INSERT INTO tte_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kabo mekanakavao tamana yo sinana sipileyoi silau Nasaleta yo ali walo iobigaili. Kabo sinana ginauli bwaite iyawatagili inuwatu-kalatan namwanamwai yo ipei katena mena. ");
INSERT INTO tte_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Na Yeisu ana bolime yo ana katai ilalaki ilaulau, yo besiele tabe Yaubada yo tomo siyaliyaya lalakina kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Saugana bwaite Sisa Taibiliya ana sauga loina kana bolime piptin (15) koina Pontio Pailato igavana dedei Yudiya koina, Elodi iloina dedei Galili koina, kanakava Pilipi iloina dedei Ituliya yo Tilakoniti kolili, yo Lisanias iloina dedei Abilini koina, ");
INSERT INTO tte_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","yo Anasa mekanakava Kaiyapa siya topwaoli lalakili kali tobagunao. Na sauganane Yoni Sakalaiya natuna imiyamiya ule mena dedei leleyanna koina kabo Yaubada kainana iyawatagili koina. ");
INSERT INTO tte_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Mwa ilau Waila Yolidan dedeina mena, yo iguguye tomo kolili iba, “Mumugamiu naenaeli kolili kwanuwabui na kwababitaiso kabo Yaubada ami pwanoli inuwatu-pwaikili.” ");
INSERT INTO tte_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Iyawatagili besiele tabe palopita Aiseya ilelelele ana buki kalona mena, “Tomo yabo iyogayoga ule bwagabwaga mena, iba, ‘Guyau ana kamwasa kwasepa, wakatububun yo kwayasapusapu, ");
INSERT INTO tte_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","kalokaloli meuloili kwayabanasili yo koyakoyali meuloili wakeli-sapusapuli, kamwasa loloyouyouli wakeli-yadudulaili yo mala vekuvekuli kwayasapusapuli. ");
INSERT INTO tte_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kabo tomo meuloili Yaubada ana lebo sigitai.’” ");
INSERT INTO tte_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Boda lalakina silaoma Yoni koina yakato iyababitaisoli kabo iwalo kolili iba, “Komiu besiele weso. Yaiya iwalo kolimiu yakato sowasowamiu Yaubada ana munamunai iya ilalaomane kwayabubu-gabaen? ");
INSERT INTO tte_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ilonamwayagimiu tem mumugamiu naenaeli kwasikotanagili na uwe namwanamwana iyawatagili yawasimiu koina. Tabu kwanunuwatui yakato kwaba, ‘Kai tubumai Abelamo, mwa koina kai Yaubada ana tomoyao gitegite-sipwaimai.’ Na yawalo kolimiu, bwaite mwakota kaiwena Yaubada iya sowasowana veku ikalaili yo kolili Abelamo tubunao iyamayaleli. ");
INSERT INTO tte_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yaubada ana kilam ivakiliyako yakato mayau meuloili siya nige siuweuwe namwanamwa yaili mena ikoili siguli na igabae-luseyagili mayau wedowedolina koina.” ");
INSERT INTO tte_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Na boda sineli Yoni koina siba, “Kabo tawae kani kaginauli?” ");
INSERT INTO tte_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Kainali iyamaisa iba, “Yaiya tem kana kabobo labui, yabo iyauyan iya nige kana kabobo ipapagan koina, yo yaiya tem mekana tabe iginauli besiele bwaite.” ");
INSERT INTO tte_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takesi kana totano tupwaliyao silau yakato iyababitaisoli, kabo sineli koina siba, “Toyakayakatai, temga tawae kaginauli?” ");
INSERT INTO tte_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Mwa ali neli iyamaisa iba, “Tabu takesi kwatatano-likwai tomo kolili, na kana lalaki bwaite loina iwalowen besiele wakalai.” ");
INSERT INTO tte_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tokaleyayao tupwali sineli koina siba, “Na gubesi kai, tem tawae kaginauli?” Mwa ali neli iyamaisa iba, “Tabu tomo kwayayadidigali na ali mane siyeyawa yo tabu kwayayakewa-mwakomwakota na siyayamaisamiu, na besi maisamiu bwaite wakakalaine koina kwamiyamiya.” ");
INSERT INTO tte_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na tomo Yudiya Mesaiya ana laoma kaiwena sisanasana, kabo kateli mena sinuwanuwatu yo sineli siba, “Yoni iya Mesaiya o nigele?” ");
INSERT INTO tte_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kabo Yoni iwalo meuloili kolili iba, “Yau yayababitaisomiu waila koina na yabo iya ilalaoma iya esana ilalakisosi, yau esagu nige ilalalaki, yau nige yagu namwanamwa ipapagan yakato sowasowagu kaena kana suma kana maina yakele-gabaegili. Na iya kani iyababitaisomiu Yaluyaluwa Tabuna yo mayau koina. ");
INSERT INTO tte_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ana sabolo iyaele ikabikabi-kalatan nimana mena, na iyayatubu ana witi kanna mekanakava mosomosona itanoi kabo kanna yawasosi ikelegogon ipeili ana lakawa mena, yo mosomosona igabu mayau koina, bwaite nige sauga yabo iboboita.” ");
INSERT INTO tte_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Na Yoni kabiyakaiwe besiele tabe sibaibaiwa iwalowegili, kabo koina tomo ikabiyakaiweli yo wasa namwanamwana iguguyeyan kolili. ");
INSERT INTO tte_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yoni iguguguguye tomo kolili kanasiga Elodi ipei nume pan mena. Na Elodi dedei Galili kali toloina iya kanakava wainena Elodiyasa ikwayai yo mumuga naenaena sibaibaiwa tabe ipaisowaili mwa kaiwena Yoni iyokoiyan. ");
INSERT INTO tte_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kabo Elodi imunamunai yo mumugana naenaena ietulanyoi yo Yoni ipan ipeiluseyan nume pan mena. ");
INSERT INTO tte_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Saugana Yoni tomo meuloili iyababitaisoli kabo Yeisu tabe iyababitaiso. Na Yeisu iyaele ikawakawanoi kabo bulibuli itasoke, ");
INSERT INTO tte_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","mwa Yaluyaluwa Tabuna kana koleya besiele bunetutu ikaisuluma koina, kabo kaina yabo ilobimaya bulibuli mena iba, “Kowa natugu yamulolo lalakina koliwo yo yayaliyaya lalakina kaiwem.” ");
INSERT INTO tte_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Saugana Yeisu ana bolime nuwana besiele teti (30) kabo ana paisowa iyatubu. Na tomo sibatoko yakato Yeisu tamana Yosepa. Yosepa tamana Eli, ");
INSERT INTO tte_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli tamana Madati, Madati tamana Libai, Libai tamana Meleki, Meleki tamana Yanai, Yanai tamana Yosepa, ");
INSERT INTO tte_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosepa tamana Madatiyasi, Madatiyasi tamana Emosi, Emosi tamana Neyama, Neyama tamana Esili, Esili tamana Nagai, ");
INSERT INTO tte_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai tamana Madi, Madi tamana Madatiyasi, Madatiyasi tamana Semeina, Semeina tamana Yoseki, Yoseki tamana Yoda, ");
INSERT INTO tte_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda tamana Yowanani, Yowanani tamana Lesa, Lesa tamana Selubabela, Selubabela tamana Salatieli, Salatieli tamana Neli, ");
INSERT INTO tte_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli tamana Meleki, Meleki tamana Adi, Adi tamana Kosami, Kosami tamana Elimadami, Elimadami tamana Eli, ");
INSERT INTO tte_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eli tamana Yosuwa, Yosuwa tamana Eliesa, Eliesa tamana Yolima, Yolima tamana Madati, Madati tamana Libai, ");
INSERT INTO tte_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Libai tamana Simioni, Simioni tamana Yuda, Yuda tamana Yosepa, Yosepa tamana Yonami, Yonami tamana Eliyakim, ");
INSERT INTO tte_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim tamana Meliya, Meliya tamana Mena, Mena tamana Matada, Matada tamana Netan, Netan tamana Deibida, ");
INSERT INTO tte_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Deibida tamana Diyese, Diyese tamana Obedi, Obedi tamana Bowasa, Bowasa tamana Salimoni, Salimoni tamana Nason, ");
INSERT INTO tte_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason tamana Aminadaba, Aminadaba tamana Adamina, Adamina tamana Anai, Anai tamana Esiloni, Esiloni tamana Pelesi, Pelesi tamana Yuda, ");
INSERT INTO tte_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda tamana Yakobo, Yakobo tamana Aisake, Aisake tamana Abelamo, Abelamo tamana Tela, Tela tamana Naoli, ");
INSERT INTO tte_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naoli tamana Selugi, Selugi tamana Leu, Leu tamana Pelegi, Pelegi tamana Ebeli, Ebeli tamana Sila, ");
INSERT INTO tte_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sila tamana Kenana, Kenana tamana Apakisadi, Apakisadi tamana Semi, Semi tamana Nowa, Nowa tamana Lemeki, ");
INSERT INTO tte_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemeki tamana Metusela, Metusela tamana Inoke, Inoke tamana Yeledi, Yeledi tamana Malaleli, Malaleli tamana Kenana, ");
INSERT INTO tte_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenana tamana Inosi, Inosi tamana Seti, Seti tamana Adama, Adama tamana Yaubada. ");
INSERT INTO tte_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yeisu waila Yolidan ilogabaen Yaluyaluwa Tabuna iloyakalapowoni, kabo ikalai ilawan ule mena dedei leleyanna koina. ");
INSERT INTO tte_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yo kaliyate poti kaloli mena Seitani Yeisu iwoyawoyai. Kaliyateliyaone kolili Yeisu nige kan yabo ikakan, na kaliyate mwawamwawasina koina kabo iguliyam lalakina. ");
INSERT INTO tte_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kabo Seitani Yeisu itonani iwalo koina iba, “Tem walo yawasosi kowa Yaubada Natuna kuwalo vekune bwaite koina iyamala beledi.” ");
INSERT INTO tte_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yeisu Seitani kainana iyamaisa iba, “Buki Tabu iwaloba, ‘Nige yakato tomo kanmo koina sikekan na yawasili silobai.’” ");
INSERT INTO tte_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kabo Seitani Yeisu iyoganyoi sikawasae koya mamalawena koina yo sauga kubwakubwana koina kaba loina meuloina yanuwa yaulina mena iyakenayan. ");
INSERT INTO tte_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kabo iwalo koina iba, “Kaiwe meuloina yaeyawa koliwo na kaba loina meuloina yo wasawasana meuloina kuloinayagili. Kaiwena Yaubada iyeyama koliyau, yo tem nuwanuwagu sowasowana bwaite yaolena yabo koina. ");
INSERT INTO tte_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Na tem kupwalou koliyau ginauli bwaite meuloina kani yaeyawa.” ");
INSERT INTO tte_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yeisu Seitani kainana iyamaisa iba, “Buki Tabu iwaloba, ‘Kupwalou Yeoba am Yaubada koina, iya kaigedamo koina kupaisowa.’” ");
INSERT INTO tte_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tabe Seitani Yeisu iwoyai yoi silau Yelusalema yo sisae Nume Tabu kewa molosina mena yo iwalo itolo. Kabo iwalo koina iba, “Tem yawasosi kowa Yaubada Natuna, ukwapusele lobi bwaite koina. ");
INSERT INTO tte_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kaiwena Buki Tabu iba, ‘Yaubada kani iwalo aneloseyao kolili sigitekalatan-namwanamwaiwo, ");
INSERT INTO tte_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","yo nimali koina sikabi-kalatagiwo, kabo kani nige kaem yabo kuyayatupan veku koina.’” ");
INSERT INTO tte_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kabo Yeisu Seitani kainana iyamaisa iba, “Buki Tabu iba, ‘Tabu Yeoba ami Yaubada kutonatonan.’” ");
INSERT INTO tte_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Seitani ana woya iyemwawasi Yeisu koina kabo ilogabaen yo isanasana sauga yaboyoi kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yaluyaluwa Tabuna ana kaiwe imiyamiya Yeisu koina kabo ipileyoi ilau Galili yo wasana idebalala dedei meuloina kolili. ");
INSERT INTO tte_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ilau ali nume tapwalolo kolili iyakayakatai, kabo tomo meuloili sitobalan. ");
INSERT INTO tte_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kabo Yeisu ilau Nasaleta, dedeine bwaine koina iya ilalakiya, kabo kaliyate Sabati koina ilau ilusae nume tapwalolo mena besiele mumugana Sabati kaigeda kaigeda iginaginauli. Itolo Buki Tabu sabi yasilina, ");
INSERT INTO tte_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","kabo palopita Aiseya ana buki moumouna siwolena koina. Bukine ikalai ikala yo ana lelelele ilobai yo iwalo bwaite besiele, ");
INSERT INTO tte_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Yaubada Yaluyaluwana imiyamiya koliyau kaiwena igitesipwaiyau yo iyaoloi-yau na wasa namwanamwana yaguguyeyan tobubutuma kolili. Iyawasayau yalau siya panpanli kolili yawalo livasi silobai yo tomangibugibu kolili yawalo manli siyalalali. Iyawasayau yalau siya simiyamiya loina kolokololona yaulina mena kolili yalivasili, ");
INSERT INTO tte_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","yo yawalo tomo kolili yaba, sauga bwaite iyawatagiliko yo Guyau ana tomoyao ileboili.” ");
INSERT INTO tte_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kabo Yeisu ana yasili iyemwawasi bukine imouyoi yo iwolena-yapileyoi buki kana togitekalatan koina kabo imiyasio sabi yakayakatai. Mwa tomo meuloili nume tapwalolo kalona mena manli ilau sigitagitai. ");
INSERT INTO tte_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kabo Yeisu iwalolau kolili iba, “Aiseya ana walo Buki Tabu mena yayasiliyako kwabenabenalanwa kaliyate kabona iyamala walo yawasosi.” ");
INSERT INTO tte_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tomo meuloili Yeisu sitobalan yo nuwali iyai ana edeedede namwanamwali kaiweli. Na iyamo siba, “Na bwaite iya Yosepa natuna, wa?” ");
INSERT INTO tte_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yeisu iwalolau kolili iba, “Yakatai kani kwawalo koliyau kwaba, ‘Doketa, kubomayoi kuwoisiwo.’ Kani walone bwaite kwawalowen koliyau kaiwena yagu paisowa kaikaiwena yapaisowailiko Kapeneomi koina wasali kwabenalagiliko na nuwanuwamiu yapaisowaiyoili tabe bwaite koina yagu yanuwane koina na tem wakawa-yawasosi yakato yau towoiwoisi yabo. ");
INSERT INTO tte_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yawalo yawasosi kolimiu, nige palopita yabo ana yanuwa tomonliyao siyayaliyaya kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kani kaba gite labui yawalowegili kolimiu kabo wakatai yakato komiu tomo Yudiya Yaubada isikotanagimiuko. Palopita Ilaitiya ana sauga koina kwabukwabuliwo sibaibaiwa simiyamiya Isileli kalona mena yo meuloili sikamkamna kaiwena bolime yaiyona yo tupwana nige galewa itatalu mwa guliyam lalakina iyawatagili yanuwane dedeina meuloina koina. ");
INSERT INTO tte_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Na Yaubada nige Isileli kwabukwabuli yabo isasagui. Na Yaubada Ilaitiya iyawasa ilau kwabukwabuli yabo, iya nige Isileli sinena besi, iya imiyamiya dedei Salepati yanuwana Saidoni dedeina mena. ");
INSERT INTO tte_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Yo besiele tabe palopita Ilaisa ana sauga koina, tolepelo sibaibaiwa simiyamiya Isileli kalona mena na Ilaisa nige yabo iwowoisi na Neiman dedei Siliya tomona iya mwa iwoisi.” ");
INSERT INTO tte_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tomo meuloili nume tapwalolo mena saugana walone bwaite sibenalan kabo simunamunai lalakina. ");
INSERT INTO tte_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mwa sitolo yo Yeisu siniuli-yawatagilan yanuwa dedeina mena, yo sikalai silawan koya malanaenaena bwaine yanuwane sikabi pwatana mena. Ali nuwatu yakato situbali-kalai ilobi iboita, ");
INSERT INTO tte_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","na ilosola boda luwali mena mwa ilau. ");
INSERT INTO tte_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kabo Yeisu Nasaleta ilogabaen ilau Kapeneomi bwaimwa Galili ana kaba loina dedeina yabo, yo kaliyate Sabati koina ilau nume tapwalolo mena yo iyakayakatai tomo kolili. ");
INSERT INTO tte_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Meuloili kateli sipitali ana yakayakatai kaiwena, kaiwena iedeedede me ana kaiwe. ");
INSERT INTO tte_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na tomo yabo iyaele nume tapwalolo kalona mena yaluyaluwa biki ilusae koina, kabo yaluyaluwa biki iula-edeedede mwa iyogayoga kainana lalakina mena iba, ");
INSERT INTO tte_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ei. Yeisu game Nasaleta, gubesi mwa kulaoma kolimai? Yakato nuwanuwam me yagu bodao kusibayanaemai? Yakataiwo, kowa Yaubada ana tomo yakayakasisina.” ");
INSERT INTO tte_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yeisu iyokoiyan iba, “Kumwanou yo kuyawatagili koina.” Kabo yaluyaluwa bikine tomone igabae-lobiyen bwatano mena tomo meuloili manli mena, muli mena yaluyaluwa bikine iyawatagili tomone koina na iyamo tomone nige isisilae. ");
INSERT INTO tte_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tomo meuloili kateli sipitali kabo sinelineli kalikavao kolili siba, “Gubesi ana yakayakatai tomone koina me ana kaiwe iedeedede yaluyaluwa biki kolili kabo silu-yawatagili.” ");
INSERT INTO tte_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mwa Yeisu wasana idebalala dedeinane koina. ");
INSERT INTO tte_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yeisu nume tapwalolo ilogabaen ilau Saimon Pita ana nume mena. Saimon bwasiyana keduluma ikasiebwa, yona iwedowedoli lalakina, mwa sikawanoi Yeisu koina tem isagui. ");
INSERT INTO tte_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Kabo ilau itolo salina mena yo me ana walo kaiwe iba, “Kasiebwa kulowasi.” Mwa yona wedowedolina imwawasi, kabo sauganane koina kedulumane itolo yo kan ipaisowai kaiweli. ");
INSERT INTO tte_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Dabwelo isusugu kabo tomo siya analiyao kali kasiebwa uloili uloili meuloili sikalaili silawagilima Yeisu koina na nimana ipeili kaigeda kaigeda yoli mena kabo meuloili kali kasiebwa simwawasi. ");
INSERT INTO tte_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Besiele tabe yaluyaluwa biki itao-yawatagilagili siyawatagilima tomo sibaibaiwa kolili yo siyoga siwaloba, “Kowa Yaubada Natuna.” Na Yeisu yaluyaluwa bikine iyokoiyagili yo nige itatalamwagili siedeedede, kaiwena sikatai yakato iya Mesaiya. ");
INSERT INTO tte_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Malala kikiuna, Yeisu yanuwane ilogabaen ilau dedei yabo koina siya nige tomo simiyamiya. Tomo siloyaloya Yeisu kaiwena, mwa sauganane silobai kabo sitonan tem siwalo-nuwai na imiyamiya kolili na tabu ilologabaegili. ");
INSERT INTO tte_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Na iwalo kolili iba, “Yaubada ana kaba loina wasana namwanamwana kani yayakayakatai-yani yanuwa tupwaliyao tabe kolili, mwa kaiwena Yaubada iyawasayau yalaoma na paisowane yapaisowai.” ");
INSERT INTO tte_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kabo ilau tomo Yudiya siya simiyamiya dedei kaigeda kaigeda kolili iyakayakatai ali nume tapwalolo kolili. ");
INSERT INTO tte_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kaliyate yabo koina Yeisu itotolo kalita Genasaleta busu galagalana mena, kabo tomo meuloili sietubatubali-yagili kaiwena nuwanuwali silau Yeisu salina mena na tem Yaubada ana walo sibenalan. ");
INSERT INTO tte_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Na Yeisu togomana ali waga labui igitaili magu mena silogabaegili yo silau ali yagida sideudeulili. ");
INSERT INTO tte_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kabo ilau imwalisae waga yabo koina bwaite Saimoni Pita ana waga yo iwalo koina iwose-yawatagilan nige kana mwayaga imamamalawe magu mena. Kabo imiyasio waga mena yo iyakayakatai tomo kolili. ");
INSERT INTO tte_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Saugana ana edeedede imwawasi, mwa iwalo Saimoni koina iba, “Waga kuwose-yawatagilan ilau didiu mena ami yagida wagabae-lobiyegili na iye kwayakonali.” ");
INSERT INTO tte_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimoni Yeisu kainana iyamaisa iba, “Taubala, boniyai malamalawena kakaiwe-boita nige iye yabo kayayakona, na am walo kaiwena yagida kani yagabae-lobi-yegili.” ");
INSERT INTO tte_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Saugana siginauli bwaite besiele mwa iye sibaibaiwa sikona masa kikiunamo yagida sitaigali. ");
INSERT INTO tte_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kabo silokaloi kalikavao kolili siya simiyamiya wagane labuinane koina na silaoma sisaguili. Saugana kalikavao siyawatagili kolili mwa waga labui sitauli-yakalapowonli yo kikiunamo sisalili. ");
INSERT INTO tte_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Saimoni mekanakavao kateli sipitali iye bwaite siyakonali kali baibaiwa kaiwena. Besiele Saimoni kanakavao labui, Yemesa yo Yoni, Sebedi natunao, kateli sipitali. Saimoni nuwana imayale bwaite kaba nuwapwanopwanone kaiwena kabo tutulina italu-sakonayani Yeisu manna mena yo iba, “Guyau kulogabaegau kaiwena yau tonaenaena.” Yeisu iwalo Saimoni koina iba, “Tabu matausi. Sauga bwaite yo sauga silalaoma komiu kani kwayamala tomo kali togomana.” ");
INSERT INTO tte_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kabo silau sikosae ali waga siniuli-seyagili yo ginauli meuloina silogabaegili yo Yeisu simuliya. ");
INSERT INTO tte_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Saugana Yeisu iyaele yanuwa yabo koina tomo yabo imiyamiya bwaine koina, iya kasiebwa lepelo yona meuloina isibayanayanae. Saugana tomone Yeisu igitai, kabo ilau tutulina italu-sakonayan yo ipwalou koina yo ikawanoi samasamalulu koina iba, “Guyau, tem nuwanuwam kuwoisiyau.” ");
INSERT INTO tte_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yeisu nimana iyagayan tomone ikabitonan, mwa iba, “O, nuwanuwagu. Yom inamwanamwa.” Kabo sauganane koina kana lepelo imwawasi. ");
INSERT INTO tte_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mwa Yeisu iwalo kaiwe koina iba, “Tabu tomo yabo ana wasa kuwowolena, na kulau topwaoli koina yo yom kuyakenayan. Kulau kupwaoli Yaubada koina am woisi kaiwena besiele Mosese ana loina, kabo tomo sikatai walo yawasosi yom inamwanamwako.” ");
INSERT INTO tte_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Bwagana iwalo yakato tabu tomo yabo ana wasa iwowolena na iyamo Yeisu ana paisowa wasana idebalala, kabo tomo sibaibaiwasosi silaolaoma koina na ana walo sibenabenalan yo iwoisili ali kasiebwa kolili. ");
INSERT INTO tte_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Na sauga ibaibaiwa boda ilogabaegili yo ilau dedei paepaeli bwagabwaga mena ikawakawanoi. ");
INSERT INTO tte_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kaliyate yabo koina Yeisu iyakayakatai tomo kolili. Palisiyao yo loina kana toyakayakataiwo siya siyaele simiyasio, silaomaya Galili dedeina meuloina kolili, yo silaoma Yelusalema taon koina yo Yudiya dedeina meuloina kolili. Kabo Yaubada ana kaiwe imiyamiya Yeisu koina na tokasiebwao iwoiwoisili. ");
INSERT INTO tte_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tomo tupwaliyao totawalololi yabo imiyamiya ana kaba keno mena sikewai sikalaiyama sitonan yakato siluseyan nume kalona mena yo sipei-yatalu Yeisu manna mena. ");
INSERT INTO tte_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Na nige sowasowali sikewa-luseyan, kaiwena tomo sibaibaiwasosi. Kabo simwalisae nume pwatana mena yo nume bwakoina sisoke-lapan. Mwa me ana kaba keno siyadalolo-lobiyenama boda luwaluwalili mena Yeisu manna mena. ");
INSERT INTO tte_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Saugana ali meli Yeisu igitai kabo iwalo totawalololi koina iba, “Yagu eliyam, am pwanoli Yaubada manna mena yanuwatu-pwaikiliko.” ");
INSERT INTO tte_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Loina kana toyakayakataiwo yo Palisiyao sibomamo sinuwanuwatu bwaite besiele, “Gubesi, yaiya tomone bwaite iya iwalo-bwagabwaga mwa Yaubada ilikwai? Nige tomo yabo sowasowana pwanoli inuwatu-pwaikili, Yaubada ibomamo sowasowana.” ");
INSERT INTO tte_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ali nuwatu Yeisu ikataiyako, kabo iwalo kolili iba, “Tawae kaiwena ginauli bwaite kwanuwanuwatuili katemiu mena? ");
INSERT INTO tte_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Imalamalae tem totawalololi koina yawalo, ‘Am pwanoli yanuwatu-pwaikili’ kaiwena bwaimwa nige mwalimwaline koliyau tem nige itotolo. Na iyamo tem yawalo koina, ‘Kutolo am kaba keno ukwalai yo kulau’ na nige itotolo kani yamwalimwaline lalakina. ");
INSERT INTO tte_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nuwanuwagu wakatai Tomo Natuna me ana kaiwe yanuwa yaulina mena sowasowana tomo ali pwanoli inuwatu-pwaikili.” Kabo Yeisu iwalo totawalololi koina iba, “Yawalo koliwo, kutolo am kaba keno ukwalai yo kupileyoi am nume mena.” ");
INSERT INTO tte_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kabo mwayamwayau itolo tomo meuloili manli mena yo ana kaba keno iya koina ikenokenowa ikalai kabo Yaubada itobatobalan ipileyoi ana nume mena. ");
INSERT INTO tte_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tomo meuloili kateli sipitali, kabo Yaubada sitobatobalan yo me ali matausi siba, “Ginauli bwaite kaliyate kabona tagitai iyamala uloi molosina.” ");
INSERT INTO tte_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mulina mena Yeisu ilogabaegili ilalauyoi kabo takesi kana totano yabo esana Madiu, esana labuina Libai, igitai ana kaba paisowa mena imiyasio imiyamiya. Kabo iwalolau koina iba, “Kumuliya koliyau.” ");
INSERT INTO tte_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kabo Madiu itolo yo ginauli meuloina ilogabaegili na imuliya koina. Silau Madiu ana nume mena, ");
INSERT INTO tte_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","kabo Madiu iwalo kan lalakina sikatububunan Yeisu kaiwena. Yeisu iyaele ikekakekani takesi kana totano yo tomo tupwaliyao sibaibaiwa simiyamiya mekalikavao Yeisu me ana tobenaliyao sikekani toyawa. ");
INSERT INTO tte_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Na Palisi tupwaliyao yo loina kana toyakayakatai tupwaliyao, siya tabe simiyamiya boda Palisi luwali mena, sibalabalamumu ana tobenaliyao kolili siwaloba, “Tawae kaiwena mekamikavao takesi kana totano yo ali tali tonaenaeli tupwaliyao wakekan yo kwanuma toyawa?” ");
INSERT INTO tte_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yeisu kainali ibenalan kabo iyamaisa iba, “Tonamwanamwa nige nuwanuwali towoiwoisi, tokasiebwaomo siya nuwanuwali. ");
INSERT INTO tte_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yalaoma nige yakato siya siba ‘kai todudulai’ yayoganli na yalaoma tolopwanoli yayoganili kabo ali naenaena koina sinuwabui.” ");
INSERT INTO tte_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tomo tupwali siwalo Yeisu koina siba, “Yoni ana tobenaliyao sauga sibaibaiwa guliyam sikalakisiyeyan yo sikawakawanoi. Tabe Palisi ali tobenaliyao sipaipaisowai besiele bwaite. Na kowa am tobenaliyao simiyamiya kankan yo simiyamiya numanuma.” ");
INSERT INTO tte_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yeisu kainali iyamaisa iba, “Tem kasole soina sipaisowai kani nige sowana tokasole tauna ana eliyamwao guliyam sikalakisiyeyan, saugana iya iyaele mekalikava. ");
INSERT INTO tte_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Na saugana tokasole taunane sikele-gabaen luwali mena, mwa kaliyatenane koina kani guliyam sikalakisiyeyan.” ");
INSERT INTO tte_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yeisu walo kobwaibwaili mena iwalowen kolili iba, “Nige sowana tomo yabo kaleko waluwaluna tupwatupwana kwama beyabeyana koina ibwalui. Tem iginauli besiele, kaleko waluwaluna itabelulun kaleko beyabeyana koina na taigalina ilalaki. ");
INSERT INTO tte_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tabe, nige sowana tomo yabo wain waluwaluna isuwai kwapi kaba suwe beyabeyali kolili. Tem iginauli besiele, kani wain waluwaluna isese isae na koina wain kwapi kaba suwene iyuigali yo wainne yo kwapi kaba suwene sisibayanaeli. ");
INSERT INTO tte_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Bwaite nigele. Wain waluwaluna sisuwai kwapi kaba suwe waluwaluli kolili. ");
INSERT INTO tte_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na tomo siya simanasam wain beyabeyana kamnana koina, genuwali wain waluwaluna. Kani siwaloba, ‘Wain beyabeyana inamwanamwa.’” ");
INSERT INTO tte_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kaliyate sabati yabo koina Yeisu ilusae witi kana tano mena. Ana tobenaliyao siguliyam kabo witi kanna sikibwali, nimali mena sikopali na silolo-kekakekan. ");
INSERT INTO tte_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Na saugana Palisi sigitaili kabo siwalo Yeisu koina, “Tawae kaiwena sabati kana loina kwalikwai?” ");
INSERT INTO tte_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Yeisu kainali iyamaisa iba, “Saugana Kin Deibida me ana eliyamwao siguliyam silusae Yaubada ana nume mena kabo Deibida beledi yakayakasisina ikalai yo ikan yo siya mekanakavao beledine tupwana iwolegili. Walo yawasosi Mosese ana loina ilikwai kaiwena loinane iwalo yakato topwaolimo kali lonamwa sikan na Yaubada Deibida nige ikakawa-naenae-yani. Nuwana Deibida edeededena nige kwayayasili yo nige kwanunuwatu-kalatan.” ");
INSERT INTO tte_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kabo Yeisu iwalo kolili iba, “Tomo Natuna iya sabati kana Guyau.” ");
INSERT INTO tte_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabati yabo koina Yeisu ilusae nume tapwalolo mena yo tomo iyakayakataili. Na nume tapwalolone koina tomo yabo iyaele imiyamiya nimana belubeluna. ");
INSERT INTO tte_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Palisiyao yo loina kana toyakayakataiwo Yeisu simanman-kulakulai kaiwena nuwanuwali Yeisu kaba yakewaina yaina yabo silobai na koina siyakewai. Mwa koina sigitegite-namwanamwai tem tomone iwoisi Sabati mena. ");
INSERT INTO tte_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Na ali nuwatu ikatailiko kabo iwalo tomo nimana belubelunane koina iba, “Kulaoma kutolo bwaite koina.” Yo iginauli besiele. ");
INSERT INTO tte_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kabo Yeisu iwalo Palisiyao yo loina kana toyakayakataiwo kolili iba, “Toisabo paisowa ilonamwayagila Sabati koina, namwanamwa tapaisowai o nae tapaisowai? Tomo yawasina talebo o taunuyamate?” ");
INSERT INTO tte_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yeisu manna ilau tomo kaigeda kaigeda igitaili kabo tomone koina iwalolau iba, “Nimam kutu.” Kabo nimana iutu yo inamwanamwa. ");
INSERT INTO tte_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Na Palisi bodaliyaone me ali munamunai lalakina mwa sibomamo siedeedede tem tawae siginauli Yeisu koina. ");
INSERT INTO tte_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sauganane koina Yeisu isae koya mena ikawakawanoi Yaubada koina kanasiga yanuwa ilayan. ");
INSERT INTO tte_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Dabwelo imwalisae kabo ana tomuliyayao iyoganli silaoma koina yo yoli tuwelo igitesipwaili yo iwalo kolili, iba, “Esamiyao apositolo.” Na esa bwaite apositolo kana katai tosagenawasa. ");
INSERT INTO tte_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Siya igitesipwailiko yoli tuwelone esaliyao bwaite, Saimoni iya esana ipei Pita, Anidulu iya Saimoni kanakava, Yemesa mekanakava Yoni, yo Pilipi, Batolomiu, ");
INSERT INTO tte_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","yo Madiu yo Tomasi, yo Yemesa yabo Alipio natuna yo Saimoni iya ilaomaya boda Selot ");
INSERT INTO tte_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","yo Yudasa Isikaliota iya naga Yeisu iwalo-masalan yo italamwan toloinao nimali mena yo tabe Yudasa yabo iya tamana esana Yemesa. ");
INSERT INTO tte_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kabo Yeisu me ana tobenaliyao yoli tuwelo silobi yo itolo dedei mala bakubakuna koina yo tomuliyayao sibaibaiwa yo tabe boda lalakina silaoma simiya-takikilan na ana edeedede sibenabenalan. Sibaibaiwa silaoma yanuwa kikiuli Yudiya kalona mena, besiele Yelusalema taon koina, yo tupwaliyao silaomaya Taiya yo Saidoni kolili bwaimwa kalita Mediteleiniya dekawana mena. Meuloili nuwanuwali iwoisili ali kasiebwa kolili. ");
INSERT INTO tte_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tabe siya me ali nuwapolowe kaiwena yaluyaluwa biki imiyamiya kolili, meuloili iwoisili. ");
INSERT INTO tte_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Boda lalakinane nuwanuwali Yeisu sikabitonan kaiwena sigitai kaiwe lalakina iyawatagili koina yo tomo meuloili iwoisili. ");
INSERT INTO tte_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yeisu manna ilau siya simulimuliya koina kabo iwalolau kolili iba, “Komiu tobubutuma, Yaubada imuloloimiu kaiwena ana kaba loina imiya kolimiu. ");
INSERT INTO tte_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Komiu sauga bwaite waguliyam Yaubada imuloloimiu kaiwena kani iloya-kalapowonmiu. Komiu sauga bwaite kwavalam Yaubada imuloloimiu, kaiwena iya kani ikabi-yaliyaya-yagimiu. ");
INSERT INTO tte_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Yaubada imuloloimiu tem tomo sikalomagigi-lagimiu yo sipei-kaisulu-wagimiu ali nume tapwalolo mena yo sikawa-naenae-yagimiu yo sisikotanagimiu ami meli Tomo Natuna koina kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tem polowene bwaite kwalobalobaili, sauganane koina kwayaliyaya yo kwaselo kaiwena maisamiu lalakina iyaele bulibuli mena isanasana. Kwanuwatu-kalatan, beyabeyana Yudiya tubuliyao mumuga naenaenane bwaite siginauli palopitao kolili. ");
INSERT INTO tte_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Na komiu towasawasa kateguwao komiu, bwaliga kwasilae, kaiwena ami miya namwanamwana kwalobaiyako imwawasiko. ");
INSERT INTO tte_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Komiu bwaite sauga wakekan diyasese bwaliga kwasilae, kaiwena kani waguliyam. Komiu sauga bwaite totalatalawasi, bwaliga kwasilae, kaiwena kani kwavalam nuwanuwanae molosi. ");
INSERT INTO tte_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Komiu towalo-sonoga mwakomwakotali sauga meuloina tomo ami mwakota mena sitobatobalanagimiu, bwaliga kani kwasilae. Kwanuwatu-kalatan bwaite, beyabeyana Yudiya tubuliyao palopitao mwakomwakotali sitobatobalanagili.” ");
INSERT INTO tte_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yeisu iwaloyoi iba, “Komiu bwaite kwabenabenali koliyau na yawalo kolimiu, kami tokalomagigiliwo kwamulolo kolili. Siya sikalomagigi-lagimiu mumugamiu inamwanamwa kolili, ");
INSERT INTO tte_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","siya sikawa-naenae-yagimiu kwamulolo kolili yo siya siyakamkamnamiu wakawanoi kaiweli. ");
INSERT INTO tte_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tem tomo yabo papalim gegebam iunui kutagelakeile papalim ulaulam kuwolenayoi na tabe iunuiyoi. Tem tomo yabo kam kwama tulutulu ikalai, tabu kumumunamunai na kutalamwan ikalai yo tabe kuetulan kwama yaboyoi kuwolena. ");
INSERT INTO tte_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Yaiya tem ginauli yabo ikawanoi koliwo kuwolena mowoi, yo tem tomo yabo am gogo yabo ikalai tabu kuwawalo samasamalulu am gogone kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mumuga bwaite nuwanuwamiu tomo siginauli kolimiu, komiu tabe waginauli kolili. ");
INSERT INTO tte_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Tem kumulolo am eliyam koina kaiwena imulolo koliwo na nige kumumulolo kam kaleya koina bwaite nige maisam imiyamiya bulibuli mena. Kaiwena tomo meuloili yo tabe tonaenaeli ali tomomo simulolo kolili, bwaite mumugane nige maisana imiyamiya bulibuli mena. ");
INSERT INTO tte_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tem mumugam inamwanamwa am eliyam koina kaiwena mumugana inamwanamwa koliwo na nige mumugam inanamwanamwa kam kaleya koina bwaite nige maisam imiyamiya bulibuli mena. Kaiwena tomo meuloili yo tabe tonaenaeli mumugali sinamwanamwa ali tomomo kolili, bwaite mumugane nige maisana imiyamiya bulibuli mena. ");
INSERT INTO tte_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tem ginauli yabo kuwolena am eliyam koina kaiwena kani iyamaisa-yavivila koliwo na nige kuwowolena kam kaleya koina bwaite nige maisam imiyamiya bulibuli mena. Kaiwena tomo meuloili yo tabe tonaenaeli siyauya ali tomomo kolili, bwaite mumugane nige maisana imiyamiya bulibuli mena. ");
INSERT INTO tte_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Na komiu ilonamwayagimiu kami tokalomagigiliwo kwamuloloili yo mumugamiu inamwanamwa kolili. Tem ginauli yabo kwaolegili tabu ami nuwatu yakato kani siyamaisa-yavivilayoiyama kolimiu. Tem waginauli besiele bwaite naga kabo maisa lalakina wakalai yo komiu kwaemala Tomiyasaesosi natunao. Kaiwena Yaubada tomo naenaeli yo tabe siya nige sikakawatoki koina imuloloili. ");
INSERT INTO tte_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tomo meuloili wakatekamkamna-yagili, besiele Tamamiu ikatekamkamna-yagili.” ");
INSERT INTO tte_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Iwaloyoi iba, “Tabu kamikavao ali pwanoli kwaloyaloyaili kisi Yaubada ami pwanoli iloyaloyaili. Tabu kwaba, ‘Siya tomo naenaeli’, kisi Yaubada iwalo besiele bwaite kaiwemiu. Kamikavao ali pwanoli kwanuwatu-pwaikili, na Yaubada ami pwanoli inuwatu-pwaikili. ");
INSERT INTO tte_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kwayauya kamikavao kolili, kabo Yaubada iyauya kolimiu. Kaiwena iya bosa itauli meuloina ikalapowon masumasuwe kabo iyeyawa kolimiu. Na liyene bwaite kwaolena kamikavao kolili bwaimwa iya kani liyene wakalai tabe besiele.” ");
INSERT INTO tte_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yeisu walo bwaite iwalowen kolili iwaloba, “Wagite-kalatagimiu yaiya mulina mena kwalalau. Nige sowasowana tomangibugibu yabo ana tali tomangibugibu iyogan. Tem iginauli besiele, kani yoli labuine sibeku gula mena. ");
INSERT INTO tte_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tosikulu nige sowasowana ana toyakayakatai ilalaki-gabaen, na kaigeda kaigeda tem ana sikulu meuloina iyemwawasi, ee iya kani besiele ana toyakayakataine. ");
INSERT INTO tte_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Gubesi tem mayau tasilina kumankulakulai kamkava manna mena na kowa sapalele lalakina iyaele manim mena nige kunuwanuwatu kaiwena? ");
INSERT INTO tte_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tem sapalele lalakinane nige ugigitai iyaele kowa manim mena, gubesi mwa nuwanuwam kuwalo kamkava koina kuba, ‘Kaukava, mayau tasilinane yakele-gabaen manim mena.’ Tomwakomwakota kowa. Baguna naga sapalele lalakinane manim mena ukwele-gabaen kabo manim imayale, ee kani sowasowam mayau tasilinane ukwelegabaen kamkava manna mena.” ");
INSERT INTO tte_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Nige sowasowana mayau namwanamwana iuwe kanna naenaena ipei. Besiele tabe, nige sowasowana mayau naenaena iuwe kanna namwanamwana ipei. ");
INSERT INTO tte_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mayau kaigeda kaigeda kanli tagitaili kabo takatai toweya mayau namwanamwana yo toweya mayau naenaena. Nige sowana bosibosi kanna takibwa samasamali koina, yo nige sowana oine kanna takibwa mayau boiboitana koina. ");
INSERT INTO tte_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tem tomo mumugana namwanamwana ikalapowon katena mena uwena namwanamwana kani iyawatagili. Tem tomo mumugana naenaena ikalapowon katena mena uwena naenaena kani iyawatagili. Tawae tem katela mena ikalapowon iya bwaimwa iyawayawatagilimaya gamwala mena.” ");
INSERT INTO tte_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kabo Yeisu iwaloyoi iba, “Tawae kaiwena kwawalo koliyau, ‘Guyau, Guyau,’ na nige yagu walo wagiginauli? ");
INSERT INTO tte_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Yaiya tem ilaoma koliyau yo yagu walo ibenalan yo isanapuwan, iya besiele tonume-kabi namwanamwana. Iya bwatanone ikeli-lobiyen yauli mena veku kaikaiwena koina kabo ana numene iyatolo vekune koina. Saugana yalubwasi ididi, ilau numene iunui na nige sowasowana numene inukui, kaiwena tomone numene ikabi-namwanamwai imatuwa. ");
INSERT INTO tte_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Na yaiya yagu walo ibenalan mowoi na nige isasanapuwan ee iya besiele tonume-kabi naenaena. Iya ana nume iyatolo bwagabwagai dekawa pwatana mena. Saugana yalubwasi ididi yo nume iunui mwayamwayau numene iguli, yo ana guline daguguna ilalakisosi.” ");
INSERT INTO tte_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Saugana Yeisu ana edeedede boda kolili iyemwawasi kabo ilau yanuwa Kapeneomi. ");
INSERT INTO tte_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na Loma tokaleya ali tobaguna yabo iyaele bwaine koina. Ana topaisowa yabo iya imulolo lalakina koina ikasiebwa kikiunamo iboita. ");
INSERT INTO tte_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Saugana tobagunane Yeisu wasana ibenalan, kabo Yudiya ali tautaubalao lalakili tupwaliyao iyawasali silau koina yakato sikawanoi ilau ana topaisowa ikabi-namwanamwai. ");
INSERT INTO tte_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Saugana tautaubalaone silau siyawatagili Yeisu koina mwa sikawanoi samasamalulu siwaloba, “Tobagunane iya tomo namwanamwana sowasowanamo tem kusagui. ");
INSERT INTO tte_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kita Yudiya imulolo kolila mwa ama nume tapwalolo ikabiyako.” ");
INSERT INTO tte_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kabo Yeisu mekanakavao silau kikiunamo siyawatagili tobagunane ana nume mena, kabo tobagunane ana elieliyamwao iyawasali silau kainana siwalowen siba, “Guyau, imiyawaya tabu kuboma kuyayapoloweo. Yau nige yagu namwanamwa ipapagan na tem yayoganwo kulaoma yagu nume mena. ");
INSERT INTO tte_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Bwaite kaiwena mwa nige sowasowana yalaowa koliwo kaiwena nige yagu namwanamwa ipapagan. Tem kuwalomo na yagu topaisowa inamwanamwa. ");
INSERT INTO tte_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Yakatai sowasowam uginauli besiele, kaiwena yau yamiyamiya yagu tautaubalao lalakili ali loina yaulina mena, yo yauligu mena yagu tokaleyayao simiyamiya. Tem yawalo yabo koina ‘kulau’ kani ilau, yo tem yawalo yaboyoi koina ‘kulaoma,’ kani ilaoma. Na tem yawalo yagu topaisowa koina ‘bwaite uginauli,’ kani iginauli. Mwa kowa sowasowam am walomo koina kasiebwane kumalimaliuwan.” ");
INSERT INTO tte_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Saugana Yeisu walone bwaite ibenalan kabo katena ipitali, mwa itagelakeile iwalolau boda siya simulimuliya koina iba, “Yawalo kolimiu, nige tomo yabo yalolobai Isileli kalona mena ana meli kana lalaki besiele tomone bwaite. Mwa tobagunane ana topaisowa woisi ilobaiyako.” ");
INSERT INTO tte_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kabo ana elieliyamwaowa tobagunane iyawasali silau Yeisu koina, sipileyoi silau ana nume mena, kabo sigitai ana topaisowa inamwanamwako. ");
INSERT INTO tte_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nige sauga mamalawena Yeisu ilau yanuwa yabo esana Neini. Kabo me ana tobenaliyao yo boda lalakina mekalikavao silau. ");
INSERT INTO tte_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Saugana siyawatagili yanuwa kaba lusalusaena dedeina mena, tomo tupwaliyao silobaili, toboita yabo sikewai siyayawatagilanama. Toboitane sinana kwabukwabuli yo natunane tauna kaigedamo. Na boda lalakina mekalikava sinana silotoyawa silaulau. ");
INSERT INTO tte_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Saugana Guyau Yeisu sinene igitai katena ikamkamna mwa iwalolau koina iba, “Tabu valam.” ");
INSERT INTO tte_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kabo ilau toboitane kana nabwanabwau ikabitonan, na siya tokewa silaulau sitolo. Iwalolau toboitane koina iba, “Game, yawalo koliwo kutolo.” ");
INSERT INTO tte_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kabo yawasina ipileyoima itolo imiyasio yo iyatubu iedeedede. Mwa Yeisu gamene iwolena-yapileyoi sinana koina. ");
INSERT INTO tte_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tomo meuloili simatausi yo nuwali ipwanopwano kabo Yaubada sitobatobalan siba, “Palopita esana lalakina yabo bwaite iyawatagili kolila. Yaubada ilaomako kita ana tomoyao isaguila.” ");
INSERT INTO tte_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mwa Yeisu ana paisowa bwaite wasana siyadebalala dedei meuloina kolili yo dedei tupwaliyao tabe kolili. ");
INSERT INTO tte_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yoni Toyababitaiso ana tobenaliyao ana wasa siwolena ginauli meuloina kaiweli bwaite Yeisu ipaipaisowailine. Kabo yoli labui iyoganli, ");
INSERT INTO tte_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","yo iyawasali na tem silau Guyau Yeisu koina sineli siba, “Gubesi, kowa tomonaele Yoni iwalowalowegiwowa iyaele kulaomane, o naga kasanasanai tomo yaboyoi kaiwena?” ");
INSERT INTO tte_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Saugana yoli labuine silau siyawatagili Yeisu koina kabo siwalolau koina siba, “Yoni Toyababitaiso iyawasamai mwa bwaite kalaomane nuwanuwamai kaneli tem kowa tomonaele iwalowalowegiwowa iyaele kulaomane, o naga kasanasanai tomo yaboyoi kaiwena?” ");
INSERT INTO tte_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sauganane koina Yeisu tomo sibaibaiwa kali muya uloili uloili simiyamiya ikabi-namwanamwaili, yaluyaluwa biki itao-yawatagilagili yo manli gibugibuli meuloili manli silala. ");
INSERT INTO tte_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yoli labuine Yoni iyawasali kainali Yeisu ibenalan iba, “Kwapileyoi Yoni ana wasa kwaolena tawae iyawatagili wagitaiyako yo kwabenalanako. Toman gibugibu manli silalako yo kaeli naenaeli silokeikeileko, tolepelo yoli sinamwanamwako, totenakola walo sibenalanako, toboita sitoloyoiko, yo tobubutuma wasa namwanamwana kana yakayakatai sibenalanako. ");
INSERT INTO tte_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Siya nige sinunuwa-labulabui kaiwegu Yaubada imuloloili.” ");
INSERT INTO tte_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yoli labuine sipipileyoi kabo Yeisu iyatubu iedeedede boda kolili Yoni kaiwena. Iwaloba, “Tauna kona Yoni Toyababitaiso ule bwagabwaga mena imiyamiya tomo iyabayababitaisoli yo komiu kwalau koina. Na sauganane koina tawae nuwanuwamiu wagitai? Nige kwalalau yakato tomo dabedabeuna wagitai. Kaiwena tomo dabedabeuna iya besiele lei liguna yaumai iyuiyui-kalakalai. Na Yoni iya nige besiele, wa? ");
INSERT INTO tte_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tem nigele, kabo tawae nuwanuwamiu wagitai? Nuwana tomo yabo kaleko namwanamwana ilikwa? Nigele, kaiwena siya kaleko namwanamwali silikwali simiyamiyaya kin ali nume mena. ");
INSERT INTO tte_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Na tawae nuwanuwamiu wagitai? Nuwana palopita yabo? Yawalo kolimiu, walo yawasosi Yoni iya palopitao bagubagunali ilalaki-gabaegili. ");
INSERT INTO tte_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yoni kaiwena mwa Yaubada iwalo-masalan palopita gamwana mena iba, ‘Yagu tosagenawasa kani yayawasa-bagunayan na iya am kamwasane ikatububun kaiwem.’ ");
INSERT INTO tte_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yawalo yawasosi kolimiu, yanuwa yaulina kana tomiya bagubagunali yo kanasiga kabona meuloili Yoni Toyababitaiso ilalaki-gabaegili. Na iyamo yaiya tem imeli yakato yau Mesaiya iya imiyamiya Yaubada ana kaba loina koina yo Yoni Toyababitaiso ilalaki-gabaen.” ");
INSERT INTO tte_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Boda mekalikavao takesi kali totano Yeisu ana walo bwaite sibenalan kabo siba, “Yaubada ana walo idudulai”, kaiwena siya bwaite beyabeyana Yoni iyababitaisoli. ");
INSERT INTO tte_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Na Palisiyao yo loina kana toyakayakataiwo Yaubada ana nuwatu kaiweli sisikotanan, kabo nige sitatalamwagili yakato Yoni iyababitaisoli. ");
INSERT INTO tte_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yeisu iwalo Yudiya toloinao kolili iwaloba, “Gubesi na komiu mumugamiu yo ami tali Yudiya mumugali? Kaba gite bwaite kani yawalowen ami nuwamayale kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Gagagiliwo simiyasio kaba gimwala mena siyogayoga kalikavao kolili siba, ‘Kasole kana igo kayui na komiu nige kwaseselo, boita walina kawaliyan na komiu nige kwavavalam.’ Mumugamiu besiele gagagili mumugali kaiwena nuwanuwamiu lalakina tem mumugamiu yau me yagu tobenaliyao kamuliya. Na saugana mumugamiu nige kamumuliya wakawa-naenae-yagimai. ");
INSERT INTO tte_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Komiu tomwakomwakota kaiwena Yoni ilaoma yo guliyam ikalakisiyeyan kawanoi kaiwena yo wain nige inunuma. Iya todudulai na komiu wakawa-kabaleya-yani. ");
INSERT INTO tte_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yo yau Tomo Natuna yalaoma yakekan yo yanuma kabo komiu kaiwegu kwaba, ‘Tomone bwaite iya tokan kalakalabili yo tonuma kalakalabili, iya takesi totano yo tonaenaeli ali eliyam.’ ");
INSERT INTO tte_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Na yau yawalo kolimiu yakato sonoga yawasosi ilaomaya Yaubada koina yo naga uwena tagitai kabo sonogane takawa-yawasosiyan.” ");
INSERT INTO tte_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Palisi yabo esana Saimon ikawanoi Yeisu koina tem ilau yo mekanakava sikekan. Kabo ilau Saimon ana nume mena ilusae imiyasio yo ikekan. ");
INSERT INTO tte_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Yo sine ganaganawalina yabo imiyamiya yanuwane koina. Wasa ibenalan yakato Yeisu iyaele ikekakekan Saimon ana nume mena kabo olo bwalaina namwanamwasosina botolina ikalaiyama. ");
INSERT INTO tte_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yeisu iyaele ikekakekan kabo sinene ilau ilusae itolo Yeisu salina mena yo ivalavalam matalilona ididi-lobi kaena mena yo kaena ibuta mwa itona koina kaena isau yo kaena inisoili yo olo bwalaina namwanamwana isuwe-lobiyen kaena mena yo iyaoloi. ");
INSERT INTO tte_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Saugana Saimon sinene ana paisowane igitai, kabo inuwanuwatu bwaite besiele, “Yabatoko tomone bwaite Yeisu iya palopita yabo na nuwana nigele. Tem iya palopita yabo kani ikatai yakato sinene bwaite iya sine ganaganawalina yo itawoi, na nigele, nige ikakatai, kaiwena italam na sinene bwaite yona ikabitonan.” ");
INSERT INTO tte_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yeisu Saimon ana nuwatu ikataiyako kabo iwalo koina iba, “Saimon, edeedede yabo nuwanuwagu yawalowen koliwo.” Mwa Saimon italam iba, “Besiele. Toyakayakatai kuwalowen na yabenalan.” ");
INSERT INTO tte_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Kabo Yeisu edeededene iwalowen koina iba, “Tomo labui mane sibuki taubala yabo koina, yabo kana buki siliba kana baibaiwa paibi andeledi na yabo kana buki siliba kana baibaiwa pipti. ");
INSERT INTO tte_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kabo siya yoli labuine nige sowasowali kali bukine siyamaisa kabo taubalawa kali bukiwa isoke-gabaegili iwaloba, ‘Yanuwatu-pwaikimiu kami bukine kaiweli.’” Yeisu ana edeedede iyemwawasi kabo ineli Saimon koina iba, “Yoli labuine kolili, yaiya kani imulolososi taubalane koina?” ");
INSERT INTO tte_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Kabo Saimon kainana iyamaisa iba, “Yagu nuwatu nuwana tomo bwaite kana buki lalakinane iya imulolososi taubalane koina kabo muli mena kana buki kikiunane, kaiwena ana taubala ana nuwatu-pwaikinane kaiwena mwa iyaliyaya lalakina ana taubalane koina.” Mwa Yeisu iba, “O, walo yawasosi.” ");
INSERT INTO tte_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kabo Yeisu itagelakeile manna ilau sinene koina, kabo iwalo Saimon koina iba, “Tabu sinene ugigitai tawae iginaginauline koliyau? Saugana yalaoma am nume mena nige waila kuleleguyama na kaegu yadeuli na iya matalilona koina kaegu iyabuta yo itona koina isauli. ");
INSERT INTO tte_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kabona nige kuninisoiyau yagu lusaemane koina, na sine bwaite saugana ilusaema iyatubu kaegu inisonisoi yo nige ilolopei. ");
INSERT INTO tte_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nige olo ukwakalaiyama na itogu kuyayaoloi na iya olone bwalaina namwanamwana isuwai kaegu kolili na iyaoloili. ");
INSERT INTO tte_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kabo yawalo koliwo, sinene kana buki lalakinane bwaimwa kana katai ana pwanoli ibaibaiwa ganawali koina Yaubada isoke-gabaegiliko mwa kaiwena sinene ana mulolo koliyau ilalakisosi. Na kowa Saimon kam buki kikiuna Yaubada isoke-gabaenako na bwaimwa nige ginauli lalakina koliwo mwa kaiwena am mulolo koliyau nige ilalalaki.” ");
INSERT INTO tte_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kabo Yeisu iwalolau sinene koina iba, “Am pwanoli Yaubada manna mena inuwatu-pwaikiliko.” ");
INSERT INTO tte_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Siya mekanakavao simiyagogo sikekakekan sibalabalamumu siba, “Toisabo tomo bwaite yakato pwanoli inuwatu-pwaikili?” ");
INSERT INTO tte_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kabo Yeisu iwalo sinene koina iba, “Am meli ikabi-namwanamwaiwo. Kulau me am nuwa-daumwali.” ");
INSERT INTO tte_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mulina mena Yeisu ilotakikili yanuwa lalakili yo kalo kikiuli kolili, Yaubada ana kaba loina wasana namwanamwana iyakayakataiyan tomo kolili. Yeisu me ana tobenaliyao yoli tuwelo, ");
INSERT INTO tte_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","yo sinesineo sibaibaiwa mekalikavao sitakitakikili. Na kaloli mena yoli yaiyonamo siya tauna kona me kali kasiebwa yo yaluyaluwa biki imiyamiya kolili na Yeisu iwoisiliko. Siya esaliyao bwaite. Meli iya siba Magidala, iya tauna kona yaluyaluwa biki kali baibaiwa seben Yeisu itao-yawatagilagili koina, yo Susana yo tabe Yowana, iya wainena Kusa iya bwaimwana Elodi ana nume kana topaisowa lalakina. Sinesineo sibaibaiwa siboma ali mane yo ali gogo sitalamwagili kabo kolili Yeisu me ana tobenaliyao sigitegite-kalatagili. ");
INSERT INTO tte_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tomo sibaibaiwa silaoma dedei uloi uloi kolili yo silogogoma silaoma Yeisu koina kabo iedeedede kolili walo kobwaibwaili mena iba, ");
INSERT INTO tte_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Tomo yabo ilau tano mena patu iyasululi sabi kuma. Saugana patu iyasululi, tupwali sitalu-suwala silau kamwasa mena yo tomo siutuyapatuli kabo man sieva-talu yo sikanli. ");
INSERT INTO tte_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tupwali sitalu-suwala silau malavekuveku mena. Mwayamwayau sikin na iyamo bwatanone nige ibabalubalu, nige waila kabo kinne siweweka. ");
INSERT INTO tte_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tupwali sitalu-suwala silau kawasi naenaeli luwali mena. Na kawasi naenaeli mwayamwayau sikin-saema yo sipanli simomosi-yamateli. ");
INSERT INTO tte_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Na patu tupwali sitalu-dudulai bwatano namwanamwana koina kabo sikin-lalaki yo siuwe yo sidibubu kanli wan andeledi (100).” Yeisu ana walo iyemwawasi yo iyoga kainana lalakina mena iba, “Tem metenamiu, ilonamwayagimiu walone bwaite kwabenalan yo kwanuwatu-kalatan.” ");
INSERT INTO tte_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yo saugana Yeisu ana tobenaliyao sineliyan walo kobwaibwailine kana bui kaiwena, ");
INSERT INTO tte_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","iba, “Yaubada ana kaba loina kana nuwatu wadawadamna yalivasiyako kolimiu kabo nuwamiu sidudulai na siya tomo uloili nigele. Walo kobwaibwaili mena yaedeedede kolili na mesabana simanman-kulakulamo na nige sigigitai, yo sibenabenalimo na nige sikakatai.” ");
INSERT INTO tte_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yeisu iwaloba, “Patu toyasulu ana walo kobwaibwaili kana dudulai bwaite besiele. Patune Yaubada ana walo. ");
INSERT INTO tte_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Patu toyasulu iyasululi na sitalu-suwala kamwasa mena bwaimwa siya tomo Yaubada ana walo sibenalan kabo Seitani ilaoma yo walone kateli mena ikele-gabaen na tabu simemeli yo lebo silolobai. ");
INSERT INTO tte_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Patu toyasulu iyasululi na sitalu-suwala malavekuveku mena bwaimwa tomo siya walone sibenalan yo mwayamwayau me ali yaliyaya sipeili kateli mena. Na ginauli kaigeda walone nige sinuwanuwatu dudulai kateli mena, lamli nige silolobi namwanamwa kabo ali meli nige imamamalawe. Saugana tem woya o polowe silobai mwayamwayau yaluyaluwali sibui yo sisikote. ");
INSERT INTO tte_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Patu toyasulu iyasululi na sitalu-suwala kawasi naenaeli luwali mena, bwaimwa tomo siya walone sibenalan mowoi, na yanuwa yaulina kana yaliyaya yo kana wasawasa kaiwena sinuwanuwatu, kabo walone bwaite sipan-yamate, nige kanna ipapagan. ");
INSERT INTO tte_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Patu toyasulu iyasululi na sitalu-dudulai bwatano namwanamwana koina, bwaimwa tomo siya walone sibenalan yo sikabi-kalatan kateli mena. Kateli sikalapowon nuwatu dudulaina yo namwanamwana yo sikalakisiye kanasiga uwena iyawatagili.” ");
INSERT INTO tte_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yeisu iwaloyoi kolili iwaloba, “Tem mayale tagabu, gubesi, tapei gulewa yaulina mena o kaba keno yaulina mena? Nigele. Tapei kaba peina mena na mesabana tomo meuloili numene koina silusae na mayalene sigitai. ");
INSERT INTO tte_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tawae tomo siwadam kateli mena Yaubada kani iyamayale na tomo meuloili sikatai. ");
INSERT INTO tte_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Tawae kwabenalan kwanuwatu namwanamwa kaiwena. Yaiya me ana katai Yaubada kaiwena Yaubada kani ietulan. Yaiya iboma ana nuwatu mena yo ana katai mena Yaubada kani ikelegabaen.” ");
INSERT INTO tte_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yeisu sinana yo kanakavao silaoma sabi gitaina na nige sowasowali silau salina mena kaiwena boda ilalakisosi. ");
INSERT INTO tte_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kabo tomo yabo ana wasa iwolena iba, “Sinam yo kamkavao siyaele bwaite sitotolo gana muli mena, nuwanuwali siedeedede koliwo.” ");
INSERT INTO tte_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yeisu kainana iyamaisa, iba, “Siya Yaubada ana walo sibenalan yo sipaisowai ali miyamiya koina siya mwa sinaguwao yo kaukavao.” ");
INSERT INTO tte_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kaliyate yabo koina Yeisu me ana tobenaliyao waga yabo koina simwalisae kabo iwalo kolili iba, “Takuke talopanaisi dedei yabo mena.” Kabo sikuke silau. ");
INSERT INTO tte_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sikalakalau na Yeisu ikenokeno. Yo wowoli lalakina silobai yo tabe bagolu isuwesuwe-likwa waga mena masa kikiunamo waga ipowon yo isalili. ");
INSERT INTO tte_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ana tobenaliyao silau koina siyanoi siba, “Taubala, Taubala, kutolo masa kikiunamo tasalili.” Kabo Yeisu itolo yo yaumai yo bagolu iyokoiyagili. Yo yaumai ilopei yo sowasowaga idaumwali. ");
INSERT INTO tte_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yo iwalo kolili iba, “Tomalaele naga kwamemeli.” Kabo kateli sipitali yo simatausi lalakina yo sienelineli-yagili siba, “Toisabo tomo bwaitete? Ginauli meuloina kainana sibenalan yo tabe besiele yaumai yo bagolu.” ");
INSERT INTO tte_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yeisu me ana tobenaliyao silopanaisi siulisi Gelasa. Na dedei Gelasa bwaimwa Galili na iyamo dedei yabo mena. ");
INSERT INTO tte_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Saugana Yeisu ikaisuluma waga mena tomo yabo yaluyaluwa biki imiyamiya koina igitai. Na tomone sauga meuloina mekowakowana nige ana nume ipapagan na imiyamiya salai luwaluwalili mena. ");
INSERT INTO tte_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Saugana yaluyaluwane imiyamiya koina nige sowana yabo ipan-kalatan bwagana tem seni koina sipan. Sauga tupwana nimana yo kaena sipanli seni mena na iyamo nimana mena iutusili yo seni kaena mena igoluli yo yaluyaluwane ana kaiwe koina iyabubu ilau dedei paepaeli bwagabwaga mena. Tomone Yeisu igitai kabo iwui yo ilaoma koina, manna mena tutulina italu-sakonayan yo ipwalou. Yo Yeisu iwalo yaluyaluwa biki koina iba, “Kowa yaluyaluwa biki tomone bwaite koina kuyawatagilima.” Kabo yaluyaluwa bikine iyoga kainana lalakina mena iba, “Yeisu, Yaubada Tomiyasaesosi Natuna, tawae nuwanuwam uginauli koliyau? Tabu kuyayakamkamnayau.” ");
INSERT INTO tte_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yo Yeisu ineli koina iba, “Kowa esam?” Kabo kainana iyamaisa iba, “Yau esagu Boda”. Iwalo besiele kaiwena yaluyaluwa biki sibaibaiwa tomo bwaite kalona mena simiyamiya. ");
INSERT INTO tte_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kabo sikawanoi samasamalulu Yeisu koina tabu igagabae-yataluli gula kaba silae kalona mena bwaimwa Giyena koina. ");
INSERT INTO tte_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na putete salina mena polo baibaiwali sidumudumuli. Kabo yaluyaluwa bikine sikawanoi Yeisu koina tem silusae polone kolili. Yeisu italam, ");
INSERT INTO tte_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","kabo yaluyaluwa bikine siyawatagili tomone koina yo silau silusae polone kolili. Kabo polo gwauli sisagena silobi mala naenaena mena sibeku na sigalomwasi kalita mena. ");
INSERT INTO tte_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Saugana polo togitekalatan sigitai sisagena silau yanuwa lalakili yo yanuwa kikiuli kolili na ginauli meuloina siwalo-masalagili tomo kolili. ");
INSERT INTO tte_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kabo tomo meuloili silaoma na tem manli mena sigitai tawae iyawatagiliko. Saugana siyawatagilima Yeisu koina, tokabaleyane silobai yo sigitai, iya baguna yaluyaluwa biki bodaliyao silusae koina, imiyasio Yeisu kaena mena, imiyamiya mekana kwama yo kulukuluna idudulaiko kabo meuloili simatausi me ali nuwa pwanopwano. ");
INSERT INTO tte_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Siya Yeisu ana paisowa sigitaiyako kalikavao tomuliyama ali wasa siwolegili tokabaleyane gubesi Yeisu ana woiwoisina. ");
INSERT INTO tte_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kabo tomo meuloili Gelasa koina sikawanoi Yeisu koina tem ali dedeine ilogabaen kaiwena meuloili me ali matausi lalakina. Mwa Yeisu ipileyoi wagane koina yakato ikukeyoi ilau. ");
INSERT INTO tte_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ana sauga mwalisae tokabaleyane ilau koina ikawanoi tem mekanakava sikuke silau. Na Yeisu nige itatalam yo iba, ");
INSERT INTO tte_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kuvivila kulau am susuwo ali wasa kuwolegili tawae Yaubada ipaisowai kaiwem.” Na tokabaleyane ilau itakikili yanuwane tomoliyao kolili iedeedede tawae Yeisu ipaisowaiyako koina. ");
INSERT INTO tte_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yeisu me ana tobenaliyao sikuke silopanaisiyoima siulisi. Saugana Yeisu ikaisulu boda lalakina silaoma me ali yaliyaya siyogan kaiwena sisanasanai. ");
INSERT INTO tte_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kabo tomo yabo esana Yailo, iya tapwalolo kana tobaguna yabo, ilaoma. Sauganane Yeisu igitai, manna mena tutulina italu-sakonayan, na ikawanoi samasamalulu tem ilau ana nume mena, ");
INSERT INTO tte_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kaiwena nige natuna yaboyoi, natunane bwaite kaigedamo sinena ana bolime tuwelo ikasiebwa lalakina masa kikiunamo iboita. Kabo Yeisu mekanakava silau. Yo boda lalakina simulimuliya na siyetubatubali. ");
INSERT INTO tte_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na bodane luwali mena sine yabo me ana kasiebwa, kwasine ididididi bolime tuwelo na iyamo naga medidina. Tomo sibaibaiwa sitonan tem siwoisi na nige sowasowali. ");
INSERT INTO tte_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Sinene ilau Yeisu dagelana mena kana kaleko sopana ikabitonan. Mwayamwayau kwasine ana didi ilopei. ");
INSERT INTO tte_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Kabo Yeisu iba, “Yaiya ikabitonagau?” Meuloili siwaloba, “Nigele”. Yo Pita iba, “Taubala, boda lalakina siyatakikilagiwo silaulau yo siyetubatubali mwa situpaiwo.” ");
INSERT INTO tte_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Na Yeisu iba, “Yakatai yabo ikabitonagau kaiwena yalotonan yagu kaiwe tupwana iyawatagili koliyau.” ");
INSERT INTO tte_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Sinene ikatai nige sowasowana ikeno-wadam kabo me ana matausi yo me ana tabubu ilaoma italumiyasio Yeisu manna mena yo iba, “Yau yakabitonagiwo kaiwena nuwanuwagu woisi yalobai. Kam kaleko sopana yakabitonan kabo mwayamwayau woisi yalobai.” Tomo meuloili sinene ana walo sibenalan. ");
INSERT INTO tte_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yeisu iwalolau sinene koina iba, “Natugu, am meli iwoisiwo, kulau me am nuwa-daumwali.” ");
INSERT INTO tte_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yeisu iyaelemo iedeedede kabo tomo yabo Yailo ana nume mena wasa ilawanama iba, “Natum iboitako. Nige sowana toyakayakatai ana sauga kuyavenuwan.” ");
INSERT INTO tte_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yeisu tomone ana walo ibenalan na iwalolau Yailo koina iba, “Tabu ukakatewakaka na kumelimo koliyau na natum inamwanamwa.” ");
INSERT INTO tte_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Saugana silaoma siyawatagili Yailo ana nume mena Yeisu bodane ikausili tabu silulusae bwaimwanamo Pita, Yoni yo Yemesa yo gamasinene tamana yo sinana. ");
INSERT INTO tte_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bodane meuloina sivalavalam koyasili gamasinene kaiwena na iba, “Valam besi. Kaiwena gamasinene nige iboboita ikenokenomo.” ");
INSERT INTO tte_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ali nuwatu iboitako mwa Yeisu ana walo kaiwena simalumaluwan. ");
INSERT INTO tte_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yeisu gamasinene nimana mena ikabilau iba, “Gamasine, kutolo.” ");
INSERT INTO tte_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kabo gamasinene boita mena itoloyoi, yaluyaluwana ipileyoima, manna ilala yo ana kaba keno mena itolo yo imiyasio. Yeisu iwalo kana siwolena yo ikekan. ");
INSERT INTO tte_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Sinana yo tamana kateli sipitali siyaliyaya na iwalo kaiwe kolili iba, “Tabu yaiya yabo koina kwawawalo-masala yagu paisowa bwaite kaiwena.” ");
INSERT INTO tte_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yeisu tobenaliyao yoli tuwelo iyoganlima simiyagogo, kabo kaiwe yo loina iwolegili kolili na yaluyaluwa biki sitao-yawatagilagili yo tomo siya mekali kasiebwa sikabi-namwanamwaili. ");
INSERT INTO tte_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kabo iyawasali siyawatagili silau Yaubada ana kaba loina wasana siyakayakatai-yani yo tokasiebwa sikabi-namwanamwaili. ");
INSERT INTO tte_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Sauga kikiunamo kabo silau na kali loina iwolegili, iwalo kolili iba, “Tabu ginauli yabo kwalolokalai ami laune kaiwena, tem sige, tem kaleko kana tobwa, tem kan o tem mane. Yo tem kami kwama tabu labui. ");
INSERT INTO tte_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tem kwalusae yanuwa yabo koina yo tomo yabo iyoganmiu, kwamiyamiya ana nume mena kanasiga yanuwane kwalogabaen. ");
INSERT INTO tte_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tem yanuwa yabo tomonliyao nige siyayaliyaya kaiwemiu, kaemiu dekadekawana wakotatai-yani, kabo sikatai yakato kali maisa kani silobai. Imwawasi kabo yanuwane kwalogabaen.” ");
INSERT INTO tte_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mwa tobenaliyaone siyawatagili silotakikili silau yanuwa yo yanuwa kolili, kabo yanuwa meuloili kolili wasana namwanamwana siyakayakatai-yani yo tokasiebwao sikabi-namwanamwaili. ");
INSERT INTO tte_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Elodi, iya dedei Galili kana gavana, ginauli meuloili bwaite Yeisu ipaisowaili wasana ibenalan. Kabo nuwana ipwanopwano yo inuwanuwatu lalakina kaiwena tomo tupwaliyao siwaloba, “Tomone bwaite iya Yoni Toyababitaiso boita mena itoloyoima.” ");
INSERT INTO tte_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Tupwaliyao siwaloba, “Bwaimwa Ilaitiya iyawatagilimayoi.” Yo tabe tupwaliyaoyoi siba, “Palopitao bagubagunali yabo itoloyoima boita mena.” ");
INSERT INTO tte_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Na Elodi iba, “Beyabeyana yawalo Yoni galogalona sitomyako, na tomone bwaite yaiya iya na tomo meuloili ana paisowa meuloina kaiweli siedeedede?” Kabo Elodi nuwanuwana lalakina tem Yeisu igitai. ");
INSERT INTO tte_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kabo tobenaliyao yoli tuwelo esali ipeili apositoloyao sipileyoima Yeisu koina yo ali paisowa meuloina wasana siwalowen koina. Kabo siyamo ikalaili mekanakavao silau yanuwa yabo esana Betesaida. ");
INSERT INTO tte_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Na boda lalakina Yeisu ana laune wasana sibenalan kabo siyamuli-kusuli. Yeisu iyaliyaya kolili mwa iyoganlima, kabo iedeedede kolili Yaubada ana kaba loina kaiwena yo siya sikasiebwa yo nuwanuwali namwanamwa silobai iwoisili. ");
INSERT INTO tte_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kabo kikiunamo dabwelo isugu, tobenaliyao yoli tuwelo silau Yeisu koina siwaloba, “Bodane kuyawasali silau kalo lalakili yo kalo kikiuli kolili dedei salili mena, kabo kali yo kaba keno siloya kaiwena dedei bwaite paepaeli bwagabwaga.” ");
INSERT INTO tte_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kabo Yeisu kainali iyamaisa iba, “Komiu kan kwaolegili sikekan.” Kabo tobenaliyao siwalo-talawasi koina siba, “Bwaite tawae kolimai imiyamiyane bwaimwa beledi paibi yo iye labui. Gubesi, nuwanuwam kalau na kan kayamaisa bodane bwaite kaiweli?” ");
INSERT INTO tte_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Na bodane bwaite kaloli mena tatao kali baibaiwa besiele paibi tausan. Yeisu iwalo ana tobenaliyao kolili iba, “Tomo kwayakasali boda kaigeda pipti yo boda kaigeda pipti na kwawalo simiyasio.” ");
INSERT INTO tte_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Mwa tobenaliyao siginauli besiele, kabo tomo meuloili simiyasio. ");
INSERT INTO tte_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yo Yeisu beledi paibi yo iye labui ikalaili isakaisae bulibuli mena yo iwalo-muloloili Yaubada koina kabo itabekivikivili, iwolegili ana tobenaliyao kolili yo siya siyauyan tomo kolili. ");
INSERT INTO tte_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tomo meuloili sikekan diyali sisu, kabo ali kantele tobenaliyao sitano-gogon sitauli kodo mena kodo kana baibaiwa tuwelo. ");
INSERT INTO tte_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kaliyate yabo Yeisu ibomamo ikawakawanoi na ana tobenaliyao siya siyaele mekanakavao kabo ineli kolili iba, “Boda siwaloba yakato yau yaiya?” ");
INSERT INTO tte_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kainana siyamaisa siwaloba, “Tupwaliyao siba kowa Yoni Toyababitaiso, tupwaliyao siba kowa Ilaitiya yo tupwaliyao siba kowa palopitao bagubagunali yabo itoloyoima boita mena.” ");
INSERT INTO tte_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kabo Yeisu iba, “Na komiu, kwawalo yakato yau yaiya?” Pita kainana iyamaisa iba, “Kowa Mesaiya iya Yaubada iwaloyameliyako.” ");
INSERT INTO tte_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kabo Yeisu ana tobenaliyao iyanuwapeili iba, “Tabu tomo yabo ana wasa kwaolena.” ");
INSERT INTO tte_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yo iwaloyoi kolili iba, “Tomo Natuna kani kamkamna meuloina ilobai, kabo Yudiya ali toloinao yo topwaoli lalakili yo loina kana toyakayakataiwo kani sisikotanan yo siunuyamate kabo kaliyate yaiyona koina kani itoloyoi.” ");
INSERT INTO tte_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kabo iwalo meuloili kolili iba, “Tem yabo nuwanuwana imuliya koliyau iboma ana namwanamwa isikotanan, kabo kaliyate kaigeda kaigeda kana kelose ikalai yo ikewai na imuliya koliyau. ");
INSERT INTO tte_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kaiwena yaiya tem nuwanuwana iboma yawasina ileboi kani yawasina igabaen, na yaiya tem yawasina igabaen kaiwegu ee kani yawasinane ileboi. ");
INSERT INTO tte_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tem tomo yabo yanuwa yaulina meuloina ikalai iloinayan na ibomayoi yaluyaluwana igabaen yo maisana naenaena ilobai, tawae kana namwanamwa? Nigele, awa? ");
INSERT INTO tte_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tem tomo yabo imwalimwaline-yagau yo yagu walo imwalimwalineyan ee yau Tomo Natuna kani yamwalimwaline-yani saugana tem yapileyoima me yagu wasawasa yo mekaukava Tamagu ana wasawasa yo mekaukava aneloseyao yakayakasisili ali wasawasa. ");
INSERT INTO tte_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yawalo yawasosi kolimiu, tomo tupwaliyao siyaele bwaite koina Yaubada ana kaba loina sigitai kabo muli mena kani siboita.” ");
INSERT INTO tte_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yeisu walone bwaite iwalowen nuwana kaliyate eit (8) imwawasi kabo tobenaliyao yoli yaiyona ikalaili Pita, Yoni yo Yemesa mekanakavao silau sikawasae koya mena sabi kawanoi. ");
INSERT INTO tte_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Iya iyaele ikawakawanoi na manna kana koleya ibui yo kana kaleko mayamayalesosina yo ipigapigabu. ");
INSERT INTO tte_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kabo tautaubalao labui Mosese yo Ilaitiya, ");
INSERT INTO tte_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","sitolo-mayale Yeisu salina mena mayaleli ipigapigabu yo mekalikava Yeisu siedeedede ana boita kaiwena, naga kani iboita Yelusalema koina besiele Yaubada ana nuwatu. ");
INSERT INTO tte_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita mekanakavao manli ikenokeno mwa sikenomate na saugana sikeno-tolo kabo Yeisu ana wasawasa sigitai yo tabe tautaubalao labui sigitaili mekalikava sitotolo. ");
INSERT INTO tte_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tautaubalao labuine ali sauga logabaenna Yeisu, kabo Pita iwalo koina iba, “Taubala, inamwanamwa tem kita tamiyamiya bwaite koina. Kabo gwau yaiyona takabili, yabo kowa kaiwem, yabo Mosese kaiwena yo yabo Ilaitiya kaiwena.” Iwalo besiele na nige ikakatai tawae kaiwena iwalowalone. ");
INSERT INTO tte_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Saugana Pita iyaelemo iedeedede yaloyaloi ilaoma meuloili iyakaboboili kabo Pita yo kanakavao labui simatausi, kaiwena siya siyaele silusaeko yaloyaloi kalona mena. ");
INSERT INTO tte_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kabo kaina yabo ilaoma yaloyaloine koina iba, “Bwaite natugu iya yagitesipwai, kwabenali koina.” ");
INSERT INTO tte_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Saugana kainane imwawasi mwa Yeisu ibomamo sigitai. Sauganane koina tobenaliyao simwanou yo nige tomo yabo ana wasa siwowolena ginauli bwaite sigigitaine kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Yanuwa ilayan Yeisu me ana tobenaliyao yoli yaiyona silobima koya mena, kabo boda lalakina silaoma Yeisu mekalikava sielobelobe. ");
INSERT INTO tte_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tomo yabo bodane luwali mena iyoga-laoma iba, “Toyakayakatai, yakawanoi koliwo, natugu tauna ukwate-kamkamna-yani kaiwena iya natugune kaigedamo. ");
INSERT INTO tte_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Sauga ibaibaiwa yaluyaluwa biki koina imiyamiya yo iwui yo ikikiwasi yo polu gamwana mena iyawayawatagili. Na yaluyaluwa bikine nige natugu ilologabaen kanasiga yona meuloina isibayanayanae. ");
INSERT INTO tte_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mwa yakawanoiko am tobenaliyao kolili yakato yaluyaluwane sitao-yawatagilan na nige sowasowali.” ");
INSERT INTO tte_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kabo Yeisu iwalo tobenaliyao kolili iba, “Yogu ikwatakwata-yagimiu. Kaiwena komiu te yau tamiyamiya sauga imamalawesosi yo yakalakisiye-yagimiu na nuwana nige ami meli ipapagan na yaluyaluwa bikine kwatao-yawatagilan.” Kabo Yeisu itagelakeile yo iwalo tomone koina iba, “Natum ukwalaiyama koliyau.” ");
INSERT INTO tte_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na saugana gamene ilalaoma kabo yaluyaluwa bikine igabae-yatalu bwatano mena yo ikikiwasi. Yeisu iwalo yaluyaluwa bikine koina iyawatagili, kabo gamene ilogabaen yo inamwanamwa. Mwa Yeisu gamene iwolena-yapileyoi tamana koina. ");
INSERT INTO tte_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Yo tomo meuloili kateli sipitali Yaubada ana kaiwe lalakina kaiwena. Tomo siya siyaele sinuwanuwatu ginauli meuloili bwaite Yeisu ipaipaisowaili kaiweli, mwa iwalo ana tobenaliyao kolili iba, ");
INSERT INTO tte_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Yagu walo bwaite kwabenalan-namwanamwai. Tomo Natuna sauga kubwakubwana koina kani sitalamwan tomo nimali mena.” ");
INSERT INTO tte_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Na tobenaliyao nige nuwali imamayale Yeisu ana walone kaiwena. Matausi kaiwena nige sowasowali sineli koina ana walo kana dudulai kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tobenaliyao ali boda kalona mena siegamwagamwa-pakiki-yagili tem yaiya kaloli mena esana ilalaki. ");
INSERT INTO tte_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yeisu ali nuwatu ikataiyako kabo melumelu kikiuna yabo iyoganama yo iyatolo salina mena. ");
INSERT INTO tte_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kabo iwalo kolili iba, “Yaiya tem esagu mena melumelu kikiuna yabo isagui bwaimwana iya isaguiyau, na yaiya tem isaguiyau ee iya kagu toyawasa tabe isagui. Yaiya tem luwamiu mena esana kwapeiyatalu ee iya esana ilalakisosi.” ");
INSERT INTO tte_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Kabo Yoni iwalo Yeisu koina iba, “Taubala, tomo yabo kagitai esam mena yaluyaluwa biki itao-yawatagilagili kabo kawalo-kausi tabu ipapaisowai yoi, kaiwena iya nige ala boda yabo.” ");
INSERT INTO tte_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yeisu iwaloba, “Tabu kwawawalo-kausi kaiwena yaiya tem nige ikakalomagigi-lagimiu bwaimwa iya kamikava.” ");
INSERT INTO tte_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yeisu ana boita kana sauga ikelakubwamako mwa kani yanuwa yaulina ilogabaen na ipileyoi bulibuli mena kabo ana nuwatu iyakaiwe yakato ilau Yelusalema. ");
INSERT INTO tte_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tomo tupwaliyao iyawasa-bagunayagili silau dedei Sameliya yanuwana yabo koina na kaba miya sikatububunan Yeisu mekanakavao kaiweli. ");
INSERT INTO tte_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Na yanuwane tomonliyao nige Yeisu koina siyayaliyaya tem ilusae ali yanuwa mena, kaiwena sikatai yakato ilalau Yelusalema kaiwena na siya Sameliya Nume Tabu Yelusalema koina sisikotanan. ");
INSERT INTO tte_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Saugana tobenali Yemesa yo Yoni wasane bwaite sibenalan simunamunai mwa sineli Yeisu koina siwaloba, “Taubala, nuwanuwam kalau kawalo mayau ilobima bulibuli mena yo igabuli siwedoli?” ");
INSERT INTO tte_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mwa itagelakeile manna ilau kolili kabo iyokoiyagili, ");
INSERT INTO tte_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","mwa Yeisu me ana tobenaliyao silau yanuwa uloina koina. ");
INSERT INTO tte_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yeisu me ana tobenaliyao silalau kamwasa mena, kabo tomo yabo iwalolau koina iba, “Toisabo yanuwa koina kulalau, kani yamuliya koliwo.” ");
INSERT INTO tte_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yeisu tomone kainana iyamaisa iwaloba, “Bwauwa ule mekali gula simiyamiya yo man sievaeva me kali noi simiyamiya, na yau Tomo Natuna nige yau kaba miya ipapagan na koina yakeno.” ");
INSERT INTO tte_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tabe iwalo tomo yaboyoi koina iba, “Kumuliya koliyau.” Na tomone Yeisu kainana iyamaisa iwaloba, “Guyau, kutalamwagau na kusanasanaiyau tamagu iboita yalau yapei, kabo yamuliya koliwo.” ");
INSERT INTO tte_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Kabo Yeisu iwalo koina iba, “Toboita ali toboita sipei, na kowa kulaoma kulau Yaubada ana kaba loina wasana kuluwewasayani.” ");
INSERT INTO tte_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yo tomo yaboyoi iwaloyoi Yeisu koina iba, “Taubala, nuwanuwagu yamuliya koliwo na baguna kutalamwagau na yalau yakawa-kaiyoni totouguwao kolili.” ");
INSERT INTO tte_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Na Yeisu iwalo koina iwaloba, “Tem yaiya tomo nuwanuwana ipaisowa na sauga meuloina igitegite-pileyoi iya nige sowasowana Yaubada ana kaba loina kaiwena ipaisowa.” ");
INSERT INTO tte_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kabo muli mena Yeisu boda uloili igitesipwaili tomuliyayao kaloli mena yo iyawasali kali baibaiwa sebenti tu sibaguna silau yanuwa yo kalo meuloili iya kani ilau kolili. Ali lau koina yoli labui labui iyawasali. ");
INSERT INTO tte_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kali loina iwolegili iwaloba, “Tano ilalaki kanna simatuwa, na topaisowa nige sibabaibaiwa. Na sowasowana wakawanoi Guyau koina, iya tano tanuwagana, na tem topaisowao tupwaliyaoyoi iyawasali silaowa sisaguimiu ana tano kanna wakeli. ");
INSERT INTO tte_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Na kani yayawasamiu kwalalau besiele sipi silalau bwauwa sokasokali luwali mena. ");
INSERT INTO tte_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tabu ami mane wakakalaili o tem ami gogo kana tobwa, o tem kaemiu kana suma kwalolokalaili. Tabu kwalolo-totolo kamwasa mena na tomo mekamikavao kwaedeedede. ");
INSERT INTO tte_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Saugana tem kwamwalisae nume yabo koina baguna kwawalo kolili kwaba, ‘Nuwadaumwali Yaubada iyeyawa numene kana tomiya kolimiu.’ ");
INSERT INTO tte_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tem tomo me ali nuwadaumwali simiyamiya, ami walo-mulolo nuwadaumwali kani imiyamiya kolili. Tem nigele, ami walo-mulolone kani ipileyoiwa kolimiu. ");
INSERT INTO tte_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kwamiyamiya numene koina, kabo kan yo waila siya siyeliwa wakekan yo kwanuma kaiwena ilonamwayan bwaite topaisowa maisana. Tabu kwatatakikili nume yo nume kolili. ");
INSERT INTO tte_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tem kwalusae yanuwa yabo koina na tomo siyoganmiu yo siyaliyaya kaiwemiu kanne sikakatububunanne kaiwemiu wakekan. ");
INSERT INTO tte_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tokasiebwaone yanuwane koina wakabi-namwanamwaili yo ali wasa kwaolegili kwawaloba, ‘Yaubada ana kaba loina ilaomako salimiu mena.’ ");
INSERT INTO tte_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Na tem kwalusae yanuwa yabo koina na tomo nige siyayaliyaya kaiwemiu, kwalau ali kamwasa mena kwawaloba, ");
INSERT INTO tte_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ami yanuwa kauna yo dekadekawana kaekaemai mena ipatu kakotatai-yani kolimiu na wakatai kani maisana naenaena kwalobai. Tabe kwanuwatu-kalatan yakato Yaubada ana kaba loina ilaomako salimiu mena.’ ");
INSERT INTO tte_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na yawalo kolimiu, yanuwane siya sisikotanagimiu yatala kana sauga koina kali maisa kani ilalakisosi sikalai kabo Sodoma. ");
INSERT INTO tte_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Oo tomo Yudiya kwamiyamiya yanuwa Kolasin yo Betesaida katekamkamnamiu, bwaliga kani kwasilae. Tauna kona ginauli kaba nuwapwanopwano yapaisowailiko luwamiu mena, na nige kwanunuwabui. Ginauli kaba nuwapwanopwanone nige yapapaisowaili Taiya yo Saidoni manli mena. Na tem yapaisowaili Taiya yo Saidoni manli mena kani mwayamwayau kwauya kwamana sikwamai yo kau koina simiyasio yo sinuwabui. ");
INSERT INTO tte_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Na siya Taiya yo Saidoni, Yaubada kani isikotanagili kaiwena siya toyauyaule yawasosi. Na yawalo kolimiu, yatala kana kaliyate koina, komiu Kolasin yo Betesaida, maisamiu ipolowesosi kabo muli mena Taiya yo Saidoni kali maisa. ");
INSERT INTO tte_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Gubesi komiu Kapeneomi? Nuwana ami nuwatu yakato Yaubada esamiu ikeleisinan bulibuli mena? Nigele. Kani ipeiyatalumiu kwalobi molosi toboitao ali yanuwa gunna mena.” ");
INSERT INTO tte_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kabo Yeisu iwaloyoi yoli sebenti tune kolili iba, “Yaiya tem ami walo ibenalan yagu walo ibenalan. Yaiya tem isikotanagimiu, isikotanagau. Na yaiya isikotanagau bwaite iya kagu toyawasa isikotanan.” Yeisu ana walo bwaite sibenalan kabo meuloili silau yo sipaisowai besiele tawae Yeisu iwalowen kolili. ");
INSERT INTO tte_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yoli sebenti tune sipileyoima me ali yaliyaya yo siwaloba, “Guyau, tomo meuloili ama walo sibenalan. Yo tabe besiele yaluyaluwa biki saugana esam mena kawalo kolili ama walo sibenalan simwasali siyawatagili.” ");
INSERT INTO tte_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yeisu iyaliyaya ali paisowa kaiwena kabo kainali iyamaisa iba, “Yamanman-kulakula na Seitani yagitai ana kaiwe ibelu yo bulibuli mena ibekuma besiele pigabu. ");
INSERT INTO tte_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ami kaiwe yaeyawa na sowasowana weso yo gasakilikili pwatali mena kwalau kwautu-yamateli yo kami tokalomagigili Seitani ana kaiwe wakaiwe-gabaen, nige sowasowana kwasilae. ");
INSERT INTO tte_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Na tabu yakato yaluyaluwa biki ami walone sibebenalanne kaiwena kwayaliyaya. Na iyamo kwayaliyaya kaiwena esamiu Yaubada ilele-lobiyenako ana buki koina bulibuli mena.” ");
INSERT INTO tte_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sauganane koina Yaluyaluwa Tabuna yaliyaya koina Yeisu iloyakalapowon kabo iwaloba, “Tamagu, bulibuli yo yanuwa yaulina ali Guyau, yatobalanagiwo kaiwena am kaba loina kana katai kuwadam tosonoga yo tokatai kolili yo kuyamayaleyako siya besiele gagagili kolili. Tamagu, yakawa-toki koliwo kaiwena am nuwatu kupaisowai besiele.” ");
INSERT INTO tte_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Katai meuloina Tamagu iyeyamako na yayamayale tomo kolili. Nige yabo ikakataiyau iyamo Tamagu yo nige yabo Tamagu ikakatai yaumo Natuna yo siya yagitesipwaili Tamagu yayamayale kolili.” ");
INSERT INTO tte_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yeisu itagelakeile manna ilau ana tobenaliyao yoli tuwelo sibomamo kolili iwalolau iba, “Walo yawasosi Yaubada iwalo-muloloimiu kaiwena tawae komiu wagitai tomo tupwaliyao nige sigigitai. ");
INSERT INTO tte_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Na yawalo kolimiu, palopitao yo kin bagubagunali sibaibaiwa nuwanuwali lalakina tawae komiu wagitai siya tabe sigitai, na nige sigigitai, yo nuwanuwali lalakina tawae komiu kwabenalan siya tabe sibenalan, na nige sibebenalan.” ");
INSERT INTO tte_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Sauga yabo koina loina kana toyakayakatai yabo itolo na Yeisu itonan ineliyan iwaloba, “Toyakayakatai, tawae yapaisowai na yawasi miyamiya yaina yalobai?” ");
INSERT INTO tte_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yeisu kainana iyamaisa iba, “Buki Tabu ana walo gubesi am yasiyasilina? Kana dudulai gubesi am kalakalaina?” ");
INSERT INTO tte_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mwa tomone iwaloba, “Yeoba am Yaubada kumulolo koina katem meuloina koina, yaluyaluwam meuloina koina, am kaiwe meuloina koina yo am nuwatu meuloina koina. Yo kamkava kumulolo koina besiele kuboma kumulolo koliwo.” ");
INSERT INTO tte_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yeisu iwalolau koina iwaloba, “Am walo idudulai. Kupaisowai besiele na yawasi miyamiya yaina ukwalai.” ");
INSERT INTO tte_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Na loina kana toyakayakataine nuwanuwana iboma ipeiseyan yakato iya todudulai. Kabo iwalo Yeisu koina iwaloba, “Yaiya kaukava na yamulolo koina?” ");
INSERT INTO tte_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ana walo Yeisu iyamaisa iwaloba, “Tomo yabo ilaomaya Yelusalema ilalau yanuwa Yeliko kaiwena kabo tokewali sikeno-wadam kamwasa mena, sikabikalatan kana kwama silolo yo ana gogo meuloina sikewalili na siunu-gwalagwalai kikiunamo iboita kabo silogabaen. ");
INSERT INTO tte_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Na sauganane koina topwaoli yabo ilalau kamwasane kaigedana koina. Saugana tomone igitai ikenokeno kabo ilogege ilau papali yabo mena. ");
INSERT INTO tte_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Besiele tabe tapwalolo kana topaisowa yabo susu Libai tomona, iyawatagilima dedeinane koina yo tomone igitai kabo ilogegeyoi ilau kamwasa papali yabo mena. ");
INSERT INTO tte_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Na Sameliya tomona yabo imwalisae ana donki pwatana mena ilaulau yo iyawatagili dedeinane koina tomone igitai ikenokeno, kabo katena ikamkamna-yani. ");
INSERT INTO tte_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kabo ikaisulu ilau olibe kanna mekanakava oine ikalaili kana gai kolili ipeili yo kaleko mena ipanli. Ipeiseyan ana donki pwatana mena yo ilawan yanuwa mena, kabo ilawan nume taumana yabo koina yo igitekalatan. ");
INSERT INTO tte_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Yanuwa ilayanyoi, kabo siliba labui iwolena nume taumana tanuwagana koina yo iwalolau koina iwaloba, ‘Tomone bwaite ugitekalatan na saugana tem yapileyoima tawae kusagui koina kani yayamaisa-yapileyoi koliwo.’” ");
INSERT INTO tte_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kabo Yeisu ana edeedede iyemwawasi yo inelilau loina kana toyakayakatai koina iwaloba, “Gubesi am nuwatu? Tomone yoli yaiyonane luwali mena yaiya tosilaene kanakava?” ");
INSERT INTO tte_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Loina kana toyakayakataine neline iyamaisa iwaloba, “Iya ikatekamkamna-yani mwa isagui.” Kabo Yeisu iwalolau koina iwaloba, “Tabe kowa kulau kupaisowai besiele.” ");
INSERT INTO tte_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yeisu me ana tobenaliyao ali laune koina siyawatagili yanuwa yabo koina. Na yanuwane koina sine yabo esana Mata imiyamiya. Yo iya Yeisu iyoga-luseyan ana nume mena. ");
INSERT INTO tte_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Na Mata kanakava imiyamiya esana Meli iya ilau imiyasio Yeisu salina mena na ana edeedede ibenabenalan. ");
INSERT INTO tte_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Na Mata inuwanuwatu lalakina kan kana paisowa yo paisowa tupwaliyao kaiweli kabo ilau Yeisu koina yo iwaloba, “Guyau, gubesi am nuwatu paisowa meuloina yabomamo yaginaginauli na kaukava Meli ilogabaegau iyaele mekamkava am edeedede ibenabenalan na nige isasaguiyau? Kuwalo na ilaoma isaguiyau.” ");
INSERT INTO tte_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Guyau Mata kainana iyamaisa iba, “Mata, Mata, kunuwanuwatusosi ginauli meuloili kaiweli, ");
INSERT INTO tte_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","na ginauli kaigedamo kana nuwatu ilalaki. Bwaite Meli igitesipwai inamwanamwasosi, kabo tabu yaiya yabo ikakausi.” ");
INSERT INTO tte_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sauga yabo Yeisu iyaele ikawakawanoi yanuwa yabo koina. Saugana ana kawanoi iyemwawasi, kabo ana tobenali yabo iwalo koina iba, “Guyau, kuyakataimai na tem kakawanoi besiele Yoni ana tobenaliyao iyakataili.” ");
INSERT INTO tte_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kabo Yeisu iwalo kolili iwaloba, “Saugana wakawanoi kwawalo bwaite besiele. Tamamai, esam siyakasisiyan, mumugam ilobima. ");
INSERT INTO tte_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kaliyate kaigeda kaigeda kamai kuyelima kolimai. ");
INSERT INTO tte_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ama naenaena kunuwatu-pwaikili, kaiwena kamakavao meuloili ali naenaena kolimai kanuwanuwatu-pwaikili. Tabu kulalawagimai woya koina.” ");
INSERT INTO tte_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kabo Yeisu iwaloyoi kolili iwaloba, “Kaba gite yabo bwaite. Tem yabo kolimiu boniyai luwaluwalina ilau ana eliyam ana nume mena yo iba, ‘Kaukava, beledi yaiyona kuyelima, ");
INSERT INTO tte_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kaiwena kagu taumana yabo ilaoma kamwasa mamalawena koina iyaele yagu nume mena, na nige kan yabo imiyamiya koliyau na yaolena koina.’ ");
INSERT INTO tte_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tem ana eliyam kainana iyamaisa iwaloba, ‘Tabu kuyayanoiyau, gamwa yakausiyako yo menatuguwao kakenokeno nige sowasowana yatolo yo ginauli yabo yaeyawa.’ ");
INSERT INTO tte_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Na iyamo tomone ana kipisi-samasamalulu kaiwena kani ana eliyamne itolo na tawae nuwanuwana iwolena. ");
INSERT INTO tte_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Na yawalo kolimiu, wakawanoi kabo Yaubada iyeyawa, yo kwaloya kabo kwalobai, yo wakipisi kabo gamwa isoke kolimiu. ");
INSERT INTO tte_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kaiwena tem yaiya ikawanoi kani ikalai, yaiya iloyai kani ilobai yo yaiya ikipisi kani gamwa isoke koina. ");
INSERT INTO tte_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","13","Kabo takatai tem takawanoi Yaubada koina yakato Yaluyaluwa Tabuna iyeyama kolila kani iginauli besiele, kaiwena iya katena sokesokena yawasosi. Iya ana mulolo kita natunao kolila ilalakisosi kabo tama yanuwa yaulina ali mulolo natuliyao kolili. Komiu tamaliyao, tem natumiyao sikawanoi iye kaiwena, gubesi, kani weso kwaolena? Nigele. O tem sikawanoi pou kaiwena, kani gasakilikili kwaolena? Nigele. Bwaine besiele, tem takawanoi Tamala koina Yaluyaluwa Tabuna kaiwena kani iyeyama kolila.” ");
INSERT INTO tte_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yaluyaluwa biki yabo imiyamiya tomo yabo koina yo nige sowasowana iedeedede. Yeisu ilau tomone koina yo yaluyaluwa bikine itao-yawatagilan. Kabo tomone iyatubu iedeedede kabo sauganane koina boda kateli sipitali. ");
INSERT INTO tte_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Na Palisi tupwaliyao siwaloba, “Yeisu iya imiyamiya Seitani ana boda kalona mena mwa kaiwena sowasowana yaluyaluwa biki itao-yawatagilagili.” ");
INSERT INTO tte_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Boda tupwaliyaoyoi nuwanuwali Yeisu sitonan kabo siwalo koina siwaloba, “Kilakilala yabo uginauli na kakatai walo yawasosi am kaiwe ilaoma Yaubada koina.” ");
INSERT INTO tte_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yeisu bodane ali nuwatu ikataiyako kabo iwalolau kolili iwaloba, “Tem boda kaigeda na siyakasa boda labui sipaisowai kolili na sibomayoi siekalekaleya-yagili kabo bodane kani mwayamwayau itatagwaligwali imwawasi. Tabe besiele tem susu yabo iyakasa kani mwayamwayau itatagwaligwali imwawasi. ");
INSERT INTO tte_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ee besiele tabe Seitani ana boda. Tem sibomayoi siekalekaleya-yagili kolili kabo bodane kani mwayamwayau itatagwaligwali imwawasi. Na iyamo nigele, Seitani ana boda ikaiwe, kaiwena siyesagusagu-wagili, na nige siekalekaleya-yagili. Na komiu kwawawalo yakato yau Seitani ana boda yabo mwa kaiwena yaluyaluwa biki yatao-yawatagilagili. Bwaine mwakota kaiwena tem yau yamiyamiya Seitani ana boda kalona mena kani nige yaluyaluwa biki yabo yatatao-yawatagilan. ");
INSERT INTO tte_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Komiu Palisiyao ami tobenaliyao yaluyaluwa biki sitao-yawatagilagili. Na yau tem Seitani ana kaiwe koina yaluyaluwa biki yatao-yawatagilagili kabo yaiya ana kaiwe koina komiu ami tobenaliyao yaluyaluwa biki sitao-yawatagilagili? Kaiwena ama paisowa kaigedana. Na ami tobenaliyao ami yakewa mwakomwakotana kani siwalo-masalan kolimiu kaiwena siya sikataiyako yakato Yaubadamo ana kaiwe koina sowasowana yaluyaluwa biki tatao-yawatagilagili. ");
INSERT INTO tte_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Na tem Yaubada ana kaiwe koina yaluyaluwa biki yatao-yawatagilagili walo yawasosi Yaubada ana kaba loina ilaomako kolimiu. ");
INSERT INTO tte_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","22","Tem tokaiwe yabo ana nume igitekalatan yo ana kaleya kelepana yo ana ebeu inonowaili, me ana nuwadaumwali kaiwena ana meli ipei ana kaleya kelepana yo ana ebeu kolili. Na saugana tem yabo iya ana kaiwe ilalakisosi ilaoma mekanakava sikaleya yo iunui kani ana kaleya kelepana yo ana ebeu ikele-gabaegili koina. Imwawasi kani ana gogo wasawasa iyauyan. Bwaine besiele yaginauli saugana tomone nige kainana yawoisi, yakaleya Seitani koina, yaunui, ana kaleya kelepana yo ana ebeu yakele-gabaegili yo tomone yawasina yaolena-yavivila. ");
INSERT INTO tte_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Yaiya nige imiyamiya koliyau iya kagu tokalomagigili. Yo tem yaiya yabo nige mekaukava kapapaisowa-gogo iya yagu paisowane kana tosibayanae.” ");
INSERT INTO tte_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yeisu iwaloyoi iba, “Saugana yaluyaluwa biki iyawatagilima tomo yabo koina, yaluyaluwane dedei leleyana ule bwagabwaga mena itakitakikili ana kaba kaiyawasi iloyaloyai, na nige yabo ilolobai. Mwa iba, ‘Naga kani yapileyoi tomone yalologabaenne koina.’ ");
INSERT INTO tte_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Saugana ipileyoi igitai tomone katena besiele nume yabo sikuyayako yo sikatububu-nonowaiyako. ");
INSERT INTO tte_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kabo ilau yo ana tali yaluyaluwa biki kolili kali baibaiwa seben tabe ikalaili siya mumugali naenaesosili, kabo mekanakavao silusae yo simiyamiya tomone katena koina. Tomone ana miyamiya bagubagunana inae na bwaite muli mena inaesosi.” ");
INSERT INTO tte_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Saugana Yeisu iyaele iedeedede kabo sine yabo iyoga-laoma bodane luwali mena iba, “Sinene ikabiwo yo susuna koina kususu tatobalani.” ");
INSERT INTO tte_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yeisu kainana iyamaisa iwaloba, “Siya analiyao Yaubada ana walo sibenalan yo siobigai sinamwanamwasosi kabo muli mena sinene iya ikabiyau kana tobali.” ");
INSERT INTO tte_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tomo bodali ilalaki ilaulau kabo Yeisu iwalolau kolili iwaloba, “Yaso bwaite komiu toyauyaule, nuwanuwamiu kaba gite yabo yaginauli kaiwemiu na kani nige kaba gite yabo yaeyawa, bwaimwanamo iyawatagiliko palopita Yona koina. ");
INSERT INTO tte_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yona iyamala kaba gite tomo Ninibe kaiweli, na besiele tabe yau Tomo Natuna yaemala kaba gite yaso bwaite saugane kaiwemiu. ");
INSERT INTO tte_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kaliyate yatala koina Seba ali toloina lalakina sine yabo (kuin) kani itolo yo ikawa-naenae-yagimiu kaiwena sauga beyabeyana koina ilaoma dedei kelamamalawe koina yavana ana dedei mena nuwanuwana Kin Solomoni ana yakayakatai sonosonogana ibenalan. Na yawalo kolimiu, yabo iyaele bwaite, iya Kin Solomoni esana ilalaki-gabaen. Na ana yakayakatai nige kwabebenalan yo nige kwanunuwabui. ");
INSERT INTO tte_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tabe kaliyate yatala koina tomo Ninibe kani sitolo sikawa-naenae-yagimiu, kaiwena sauga beyabeyana koina Yona ana guguye sibenalan kabo mumugali naenaena koina sinuwabui. Na yawalo kolimiu, yabo iyaele bwaite, iya Yona esana ilalaki-gabaen. Na ana guguye nige kwabebenalan yo nige kwanunuwabui.” ");
INSERT INTO tte_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nige sowasowana tomo yabo mayale igabu kabo iwadam o gulewa ikalai yo mayalene ikopwaiki. Na kani ipei ana kaba miya mena na mesabana siya tolusae numene koina mayalena sigitai. ");
INSERT INTO tte_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Manim iya besiele yom kana mayale. Tem manim sinamwanamwa, kani yom meuloina imayale. Na tem manim sinae, kani yom meuloina iboniboniyai. ");
INSERT INTO tte_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ugitekalatagiwo tabu mayalene katem mena iboboniboniyai. ");
INSERT INTO tte_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kabo tem yom meuloina imayale yo nige dedei yabo iboboniboniyai kani meuloina imayale yawasosi besiele odam mayalena imayamayale koliwo. ");
INSERT INTO tte_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Saugana Yeisu ana walo iyemwawasi Palisi yabo ikawanoiyan tem ilau ana nume mena yo mekanakava sikekan. Kabo Yeisu ilau ana nume mena ilusae yo imiyasio kaba kekan mena. ");
INSERT INTO tte_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Na Palisine igitai Yeisu nige nimana idedeuli kekan kana loina kaiwena kabo katena ipitali. ");
INSERT INTO tte_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kabo Yeisu iwalo koina iwaloba, “Komiu boda Palisi besiele komwa yo gaeba bikibikili, kaiwena dagelamiumo kwadeudeulili, na kalomiu ipowon yawasosi kewali yo mumuga naenaeli kolili. ");
INSERT INTO tte_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Toyauyaule komiu. Iya Yaubada kaigedana dagela yo kalo iboma labuine iyamayaleli. ");
INSERT INTO tte_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Na temga gogo wasawasane kalomiu mena siya kwamankikiwasi-yagili sauga meuloina kwasoiyagili tobubutumao kolili kani yomiu meuloina sikapwa. ");
INSERT INTO tte_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Oo katekamkamnamiu Palisi, bwaliga kwasilae. Kaiwena loina lalakili kwanuwa-mwatainagili na loinamo kikiuli kwanuwanuwatu-kalatagili. Loina lalakili siya Yaubada ana mulolo yo yatala dudulaina. Loina kikiuli siya loina kaigalu yo pam yo venavena kaiweli. Komiu ami sauga wagabagabaen kaigalu yo pam yo venavena kali yakasa koina, kikiuna kwaolena Yaubada koina na meuloina wakalai kaiwemiu. Na ilonamwayagimiu bwaite ginauli lalakiline waginauli-baguna-yagili kabo muli mena ginauli kikiuli. ");
INSERT INTO tte_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Oo katekamkamnamiu Palisi, bwaliga kwasilae. Kaiwena nume tapwalolo koina nuwanuwamiu kwamiyasio baguna tomo manli mena. Tabe tem tomo silobaimiu kaba maketi koina nuwanuwamiu sigitaimiu na me ali yakasisi sikawatoki kolimiu. ");
INSERT INTO tte_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Oo katekamkamnamiu, bwaliga kwasilae. Kaiwena komiu katemiu luwana mena ginauli naenaeli sipowon besiele salai siya nige kilakilala yabo yo tomo nige sikakatai yakato kalona mena bowa ikalapowon, kabo silolokeikeile pwatali mena siutumonamona.” ");
INSERT INTO tte_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Loina kana toyakayakatai yabo Yeisu ana walo ibenalan, kabo iwalolau koina iwaloba, “Toyakayakatai, saugana am walo kuwalowen palisi kaiweli ee kai tabe ukawa-naenae-yagimai.” ");
INSERT INTO tte_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yeisu kainana iyamaisa iwaloba, “Oo katekamkamnamiu loina kana toyakayakataiwo, komiu tabe bwaliga kwasilae. Kaiwena loina polopoloweli kwapeili tomo pwatali mena kabo kali kayakayale ipolowesosi kolili na komiu nige ginauli yabo kwapapaisowai na yakato kwasaguili. ");
INSERT INTO tte_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Oo katekamkamnamiu, bwaliga kwasilae. Kaiwena palopitao salaili mena kali nuwatu-kalatan kwapaisowaili na siya palopitaone tubumiyao siunuyamateli. ");
INSERT INTO tte_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kabo kwawalo-masalagimiu tubumiyao ali paisowa wakawa-namwanamwa-yani, kaiwena siya palopitao siunuyamateli yo komiu salaili mena kilakilala kwapaisowaili. ");
INSERT INTO tte_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Bwaite kaiwena Yaubada ana sonoga mena iwaloba, ‘Palopitao yo apositoloyao kani yayawasali silau kolili, mwa tupwaliyao kani siunuyamateli yo siya tupwaliyao siyakamkamnali.’ ");
INSERT INTO tte_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Mwa koina komiu yaso bwaite kani maisa naenaena meuloina kwalobai palopitaone ali boita kaiweli yanuwa yaulina ana kaba tubu mena yo kanasiga kabona. ");
INSERT INTO tte_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Iyatubuya Eibeli koina kanasiga Sekalaiya. Sekalaiya siunui kaba pwaoli yo Nume Tabu kana dedei yakayakasisina luwaluwalili mena. Na yawalo kolimiu, todudulai ali boita meuloina maisana komiu yaso bwaite kani kwalobai. ");
INSERT INTO tte_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Oo katekamkamnamiu komiu loina kana toyakayakataiwo, bwaliga kwasilae. Kaiwena Yaubada ana katai kana ki iyaele wakele-gabaenako. Nige Yaubada wasana kwayayakatai-yadudulai tomo kolili. Mwa kaiwena kani nige kwaboma kwalulusae. Tabe siya nuwanuwali silusae ali kamwasa wakaukausi.” ");
INSERT INTO tte_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yeisu numene ilogabaenako. Kabo sauganane koina Palisi mekalikavao loina kana toyakayakataiwo me ali munamunai kabo siyatubu Yeisu sikawa-naenae-yani mwa siloina yakato kani neli sibaibaiwa sineliyagili koina na tem sigamwapakiki mekalikava. ");
INSERT INTO tte_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Kaiwena siya nuwanuwali tem Yeisu ana edeedede koina lopwano yabo silobai na mesabana koina sikabikalatan. ");
INSERT INTO tte_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sauganane tomo bodali kali baibaiwa tausan yo tausan silogogoma yo sietubatubali-yagili, kabo Yeisu iedeedede baguna ana tobenaliyao kolili iwaloba, “Wagite-kalatagimiu Palisi ali yisti kaiwena, mumugali mwakomwakotana bwaite kabona yawalowenako kolimiu kisi mumugaline ipanaisiwa kolimiu. ");
INSERT INTO tte_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tawae ginauli wadawadamli waginaulili kani simayale tomo sigitaili sikataili. ");
INSERT INTO tte_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kabo tawae kwawalowalowen boniboniyai mena kani tomo sibenalan imayale, yo tawae kwabalabala-mumuwan kamikavao tenali mena biliutusi kalona mena kani siyoga kaikaiwe ganamuli mena na tomo meuloili sibenalan.” ");
INSERT INTO tte_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Yagu eliyamwao, tabu tomo kwamamatausagili siya tem nuwanuwali siunuyamatemiu kaiwena siya sowasowana kwapimiumo siunuyamate, na nige sowasowali ginauli yaboyoi siginauli boita mulina mena. ");
INSERT INTO tte_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ami wasa yaeyawa, Yaubadamo iya kwamatausan, iya ana kaiwe imiyamiya sowasowana yomiu iunuyamateli yo muli mena tabe sowasowana ikele-luse-yagimiu mayau wedowedolina koina. Besiele yawalo kolimiu, iya bwaite kwamatausan. ");
INSERT INTO tte_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Bwagana kitekitele valigigi sigimwala-yagili maisana toeya labuimo, na Yaubada nige kitekitelene yabo igigite-gabaen. ");
INSERT INTO tte_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Besiele tabe komiu itomiu wiyaliyao kali baibaiwa iyasiliyako. Kabo tabu kwamamatausi kaiwena komiu maisamiu ilalakisosi kabo kitekitele meuloili maisali. ");
INSERT INTO tte_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Na yawalo kolimiu, tem yaiya tomo manli mena iwalo-masala yakato iya yagu tomo, iya esana kani yau Tomo Natuna yawalo-masalan Yaubada ana aneloseyao manli mena. ");
INSERT INTO tte_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Na tem yaiya tomo manli mena siuvalayagau, yau tabe kani yauvalayan Yaubada ana aneloseyao manli mena. ");
INSERT INTO tte_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Yaiya tem Tomo Natuna ikawa-naenaeyan, sowasowana inuwabui na nuwatu-pwaiki ilobai Yaubada koina sauga yatala koina, na yaiya iwalo kawasewa Yaluyaluwa Tabuna koina, Yaubada tomone ana pwanoli kani nige inunuwatu-pwaiki. ");
INSERT INTO tte_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Saugana tem sikalaimiu silawagimiu Yudiya ali nume tapwalolo mena yatala kaiwena, o tem sipeimiu yanuwa kana toloinao manli mena tabu kwanuwanuwatu tawae kani kwawalowen na koina livasi kwalobai. ");
INSERT INTO tte_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kaiwena sauganane koina Yaluyaluwa Tabuna iyakenayagimiu tawae kani kwawalowen.” ");
INSERT INTO tte_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tomo yabo boda luwali mena iwalo Yeisu koina iwaloba, “Toyakayakatai, kuwalo kaukava koina tamamai ana wasawasa bwaite iboita-gabaegili iyakasa tupwana iyeyama koliyau.” ");
INSERT INTO tte_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yeisu kainana iyamaisa iwaloba, “Eliyam, yaiya ipeiyau na yaemala ami toloina na mesabana tamamiu ana wasawasa yayakasa yomiu labui kaiwemiu?” ");
INSERT INTO tte_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kabo Yeisu iwalo bodane kolili iwaloba, “Wagite-kalatagimiu, tabu kwamamankikiwasi ginauli uloi yo uloi kaiweli, kaiwena bwagana tem ami wasawasa ibaibaiwa, nige sowasowamiu yawasimiu kwalobai wasawasane kolili.” ");
INSERT INTO tte_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kabo walo kobwaibwaili mena iedeedede kolili iwaloba, “Towasawasa yabo ana witi kana tano kanna ilalakisosi. ");
INSERT INTO tte_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kabo inuwanuwatu yo iba, ‘Nige yagu kaba lopei ipapagan na yagu tano kanna yatano-gogon na yapeiseyan. Kani gubesi yagu paipaisowaina? ");
INSERT INTO tte_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kani yaginauli bwaite besiele. Yagu lakawa kani yasokeli na lalakili yakabili kabo bwaine koina yagu witi kanna mekanakava yagu wasawasa tupwaliyao tabe yakatububunagili na yapeiseyagili. ");
INSERT INTO tte_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Imwawasi kabo yabomayoi kani yawalo koliyau yaba, Oo yagu gogo wasawasa sibaibaiwasosi mwa yapeiseyagiliko sowasowana bolime sibaibaiwa sisaguiyau. Kabo yakaiyawasi, yakekan, yanuma yo yayaliyaya kanasiga yaboita.’ ");
INSERT INTO tte_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Na Yaubada iwalo koina iba, ‘Yauyaule kowa. Bwaite boniyaine koina yawasim yakelegabaen na kuboita. Ginauline meuloina bwaite kupepeiliwa kaiwem siya kani tomo uloili sikalaili.’” ");
INSERT INTO tte_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ana walo kobwaibwaili iyemwawasi kabo Yeisu iwaloba, “Na besiele tabe tomo meuloili kolili, siya ali wasawasa sikele-gogonagili sibomayoi kaiweli kani sibubutuma Yaubada manna mena.” ");
INSERT INTO tte_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kabo Yeisu iwalo ana tobenaliyao kolili iwaloba, “Yawalo kolimiu, tabu kwanuwanuwatusosi yawasimiu kaiwena yo kwawaloba, ‘Tawae kan kakan o tem tawae kani kalilikwane?’ ");
INSERT INTO tte_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yawasi kana nuwatu ilalakisosi kabo kan kana nuwatu. Yola kana nuwatu ilalakisosi kabo kaleko kana nuwatu. ");
INSERT INTO tte_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kwanuwatui man aoao kaiweli, siya nige sikumakuma yo nige sikekelikeli. Yo bwagana nige ali lakawa ipapagan na iyamo Yaubada iya iyakayakanli. Komiu ginauli lalakisosina Yaubada manna mena kabo man. ");
INSERT INTO tte_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Gubesi, yaiya luwamiu mena sowasowana yawasina kana sauga ikabi-yamamalawe tem sauga meuloina inuwanuwatusosi me ana kate wakaka? Nigele, awa? ");
INSERT INTO tte_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Walo yawasosi katewakaka ginauli bwaite kikiuna kaiwena nige ana sagu kolila. Kabo tawae kaiwena ginauli kikiuli tupwaliyao tabe kaiweli kwanuwanuwatusosi? ");
INSERT INTO tte_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kwanuwatui mula lalali kaiweli. Siya nige sipaipaisowa yo siya nige ali kaleko sikokonakona. Na yau yawalo kolimiu, walo yawasosi Kin Solomon ana kaleko wasawasa inamwanamwasosi. Na iyamo mula lalaline kali koleya sinamwanamwasosi kabo muli mena Kin Solomon ana kaleko wasawasa kana koleya. ");
INSERT INTO tte_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kabo takatai Yaubada kawasi kali kwama iwolegili kawasine kabona tagitaili silala na bwaliga siboita yo sigabuli mayau mena. Komiu kawasi kwanamwanamwa-gabaegili mwa walo yawasosi kami kwamaone kani iyeliwa. Na komiu ami meli nige ilalalaki bwaite yagu walone kwanuwatu-kalatan. ");
INSERT INTO tte_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Tabu me ami katewakaka na kwanuwanuwatu tawae kani wakakan yo tawae kani kwanunuma. ");
INSERT INTO tte_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yanuwa yaulina tomonliyao siya nige tomeli sauga meuloina ginauliline besiele siloyaloyaili. Na Tamamiu iya ikataiyako komiu ami nuwatu ginauline kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Na Yaubada ana kaba loina kwaloya-bagunayan kabo muli mena ginauline kaiweli kwanuwanuwatune kani iyeliwayoi kolimiu. ");
INSERT INTO tte_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Komiu yagu boda kikiuna, tabu kwamamatausi, kaiwena Tamamiu nuwanuwana lalakina tem ana kaba loina iyeyawa kolimiu. ");
INSERT INTO tte_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ami gogo wasawasa wagimwala-yagili na manenane kwaolena tobubutumao kolili. Bwaite kamwasane koina bulibuli kana wasawasa wakalai, iya bwaite Yaubada ana tobwane nige sowasowana sauga yabo inae yo nige sowasowana sauga yabo imwawasi (gaibuna). Dedeinane koina nige tokewali silaulau yo nige sowasowana wesoweso sisibayanaeli. ");
INSERT INTO tte_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Toisabo dedei koina ami wasawasa imiyamiya kani yaluyaluwamiu imiyamiya tabe koina.” ");
INSERT INTO tte_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yeisu iwaloyoi iba, “Wakatububu-nagimiu paisowa kaiwena, kami kaleko kwalikwali, kami beleti kwapanli yo tabe ami odam siwedowedoli. ");
INSERT INTO tte_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kwayamala besiele topaisowa sisanasana ali taubala ipipileyoima kasole kekanna yabo koina. Kabo sauganane iyawatagilima ikipisi gamwa mena mwayamwayau sisoke kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Inamwanamwa topaisowaone kaiweli tem saugana ali taubala ipileyoima na ilobaili siyaele sisilasilawa bwagana boniyai luwaluwalina o tem yanuwa layalayanna koina iyawatagilima. Yawalo yawasosi kolimiu, ali taubala paisowa kalekona kani ilikwa yo kana beleti ipan-kalatan, kabo iwalo simiyasio ali kaba miyasio kolili yo kali ikalailima iwolegili yo sikekan. ");
INSERT INTO tte_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kwanuwatu-kalatan bwaite. Tem nume tanuwagana ikataiyako toisabo sauga tokewali ilalaoma kani ikatububu na isanasanai tabu tokewaline ana nume isosoke yo ilulusae. ");
INSERT INTO tte_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na komiu wakatububunagimiu. Saugana Tomo Natuna iyawatagilima kani iyakate-yapitalimiu kaiwena ana sauga laoma nige wakakatai.” ");
INSERT INTO tte_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita ineli Yeisu koina iwaloba, “Guyau, kaba gite bwaite kuwalowenne kai kaiwemai o tomo meuloili kaiweli?” ");
INSERT INTO tte_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Guyau kainana iyamaisa iba, “Yau yaedeedede iya yaiya topaisowa sanasanapuna yo kalakalakisiyena kaiwena. Iya ana taubala paisowa iwolena ana nume igite-kalatan yo ana susuyao iyakanli kekan kana sauga yawasosi koina. ");
INSERT INTO tte_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tem ana taubala ipileyoima yo igitai paisowane iginaginauli, kani ikawa-namwanamwa-yani. ");
INSERT INTO tte_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yawalo yawasosi kolimiu, ana taubala kani igitesipwai yoi yo ipei ana gogo meuloina igitekalatagili. ");
INSERT INTO tte_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Na tem topaisowane ana nuwatu yakato ana taubala kani nige imwamwaya-mwayauma kabo iyatubu ana tali topaisowao tatao yo sinesineo iunu-gwalagwalaili, yo ikekan, inuma yo tabe inuma kabakabaleya, ");
INSERT INTO tte_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","na saugana ana taubala ipileyoima kani katena ipitali kaiwena ana pileyoima kana kaliyate yo kana sauga nige ikakatai. Kabo taubalane topaisowane kani iunu-gwalagwalai yo igabaen toyauyaule ali dedei koina bwaimwa Giyena. ");
INSERT INTO tte_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tem topaisowa yabo ikataiyako tawae ana taubala nuwanuwana iginauli kaiwena, na tem nige ikakatububu tawae ana taubala ana nuwatu kani ana pileyoima koina unu lalakina ilobai. ");
INSERT INTO tte_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Na tem topaisowa yabo ana taubala ana nuwatu nige ikakatai yo ipaisowa-yanae sowasowana sisapi na kana sapi nige ilalalaki. Tabe besiele tem topaisowane kana yauyauya lalakina ilonamwayan ana taubala kaiwena ipaisowa lalakina na tem kana yauyauya lalakisosina ilonamwayan ipaisowa lalakisosina.” ");
INSERT INTO tte_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Kabo Yeisu iwaloyoi iwaloba, “Yau yalaoma na mayau kalapulupululuna yakalaiyama yanuwa yaulina mena. Ilonamwayan tem baguna mayaune iyatubu iwedowedoli kabo yalaoma. ");
INSERT INTO tte_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Babitaiso yabo polopolowena iyaele manigu mena kani yababitaiso koina na iyamo yaluyaluwagu ipolowesosi kanasiga babitaisone yaemwawasi. ");
INSERT INTO tte_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tabu kwanuwanuwatu yakato yalaoma yanuwa yaulina mena daumwali yakalaiyama. Nigele, na yalaoma kolimiu kani miya-yakasa iyawatagili. ");
INSERT INTO tte_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Bwaite koina yo sauga ilalaoma susu kani miya yakasa silobai yoli yaiyona siya yagu boda na siya yoli labui kagu tokalomagigiliwo o nuwana tabui dedei yabo. ");
INSERT INTO tte_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tama yo natuna tauna koina kani yakasa iyawatagili kolili, yo tabe sina yo natuna sinena koina kani yakasa iyawatagili yo tabe lawana keduluma yo lawana sine koina kani yakasa iyawatagili kolili.” ");
INSERT INTO tte_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yeisu itagelakeile yo iwalolau boda kolili iba, “Saugana tem yaloyaloi dubadubana yabo wagitai ikin-saema bwauli mena, kwawaloba, ‘Kani galewa italu,’ kabo muli mena iyawatagili besiele. ");
INSERT INTO tte_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tem yaumai yavana ilotalu kwawaloba, ‘Kani yanuwa iwedowedoli,’ kabo muli mena iyawatagili besiele. ");
INSERT INTO tte_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Komiu tomwakomwakota. Yanuwa yaulina kali kilakilala wakilalali, na Yaubada ana kilakilalao nige nuwamiyao simamayale-yagili sauga bwaine waluwalunane kaiwena.” ");
INSERT INTO tte_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Tawae kaiwena nige sowasowana kuboma ugitesipwa tawae inamwanamwa yo idudulai? ");
INSERT INTO tte_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tem tomo yabo iyakewaiwo yo nuwanuwana iyatalayagiwo, kutonan kaiwe na tem kamwasa mena kuyadudulai bagunayan na mesabana tabu ilalawagiwo kaba yatala koina kisi bwaine koina sipeiwo toyatala koina kabo toyatala ipeiwo pilisiman nimali mena na sipei-luseyagiwo deli mena. ");
INSERT INTO tte_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Yawalo yawasosi koliwo, tem sipei-luseyagiwo deli mena, nige sowana kuyawatagili kanasiga kam yagayaga meuloina kuyamaisaoli.” ");
INSERT INTO tte_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sauganane koina tomo tupwaliyao silaoma yo Yeisu ana wasa siwolena yakato Pailato Galili tomoliyao tupwaliyao iunuyamateli saugana sipwaopwaoli Yelusalema Nume Tabu mena. ");
INSERT INTO tte_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yeisu kainali iyamaisa iba, “Naga kwanuwatu bodane bwaite Pailato iunuyamateli siya ali pwanoli ilalakisosi Yaubada manna mena kabo tomo Galili meuloili ali pwanoli? Gubesi, bwaite kaiwena mwa sikamkamna? ");
INSERT INTO tte_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nigele. Na yawalo kolimiu tem nige ami pwanoli kolili kwanunuwabui komiu tabe meuloimiu kani kwaboita. ");
INSERT INTO tte_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Beyabeyana nume malamalawesosina Sailoma koina iguli mwa italu tomo kali baibaiwa eitin (18) pwatali mena yo siboita. Gubesi, siya tomone bwaite ali pwanoli ilalakisosi Yaubada manna mena kabo tomo Yelusalema meuloili ali pwanoli? ");
INSERT INTO tte_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nigele. Na yawalo kolimiu, tem nige ami pwanoli kolili kwanunuwabui komiu tabe meuloimiu kani kwaboita.” ");
INSERT INTO tte_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kabo Yeisu walo kobwaibwaili mena iwalolau kolili iba, “Mayau yabo besiele damaya tomo yabo ikumai ana tano mena, ikin kabo ilau kanna iloyaloyai, na nige yabo ilolobai. ");
INSERT INTO tte_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kabo iwalo tano kana togitekalatan koina iba, ‘Ugitai, bolime yaiyona koina yalaoma mayaune kanna yaloyaloyai, na nige yabo yalolobai. Ukogabaen kaiwena bwatano kanna iyaveyavenuwan bwagabwagai.’ ");
INSERT INTO tte_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Togitekalatan kainana iyamaisa iba, ‘Taubala, imiyamiya bolime kaigedayoi naga kabo bwatanone yaina mena yakeli-takikilan yo bwatanone kanna mekanakava yaebweli. ");
INSERT INTO tte_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tem bolime ilalaoma na iuwe, ee inamwanamwasosi. Na tem nigele kani kabo tako-gabaen.’” ");
INSERT INTO tte_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yudiya ali Sabati yabo koina Yeisu ilau nume tapwalolo mena yo iyakayakatai tomo kolili. ");
INSERT INTO tte_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na sine yabo iyaele imiyamiya nume tapwalolo mena yaluyaluwa biki yabo ilusae koina yo ikasiebwa bolime kana baibaiwa eitin (18). Sinene dagelana iyou yo ilolopwalopwalou yo nige sowasowana dagelana iyadudulai. ");
INSERT INTO tte_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Saugana Yeisu sinene igitai iyoga isaema koina kabo iwalo sinene koina iba, “Sine, livasi kulobaiyako kam kasiebwa koina.” ");
INSERT INTO tte_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nimana ipeili sinene koina kabo sauganane koina sinene itolo-dudulai yo Yaubada itobalan. ");
INSERT INTO tte_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kabo nume tapwalolo kana tobaguna imunamunai, kaiwena Yeisu tokasiebwane iwoisi kaliyate sabati koina. Kabo tobagunane iwalo tomo kolili iwaloba, “Kaliyate sikisi sowasowana tapaisowa. Kabo kaliyateliyaone kolili kwalaoma woiwoisi kaiwena na kaliyate sabati koina nigele.” ");
INSERT INTO tte_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yeisu tomone kainana iyamaisa iba, “Tomwakomwakota komiu, meuloimiu kaliyate Sabati koina kwapaisowa saugana ami yakayakan kwalivasili ali nume mena kwaniuli-yawatagilagili na kwayakanli yo kwayanumali. Besiele wa? ");
INSERT INTO tte_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Na sinene iya Abelamo tubuna yabo, yo Seitani ipan bolime eitin. Na sowasowana kana panne talivasi Sabati koina. Kaiwena tomo ginauli lalakina Yaubada manna mena kabo yakayakan.” ");
INSERT INTO tte_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Saugana Yeisu iwalo bwaite besiele kabo kana tokalomagigiliwo simwalimwaline. Na tomo meuloili ginauli namwanamwali meuloina Yeisu iginaulili kaiwena siyaliyaya. ");
INSERT INTO tte_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kabo Yeisu iwaloyoi iwaloba, “Toisabo kaba gite koina na Yaubada ana kaba loina kana koleya yawalo-lawan koina? ");
INSERT INTO tte_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bwaite besiele mayaune esana ketabu patuna, tomo yabo ikalai yo ikumai bwatano mena. Patune kikitoitoinane ikin yo iyamala mayau lalakina yabo, kabo man meuloili silaoma na ali noi siginaulili lagalagana kolili. Bwaite kaba nuwapwanopwano kolila.” ");
INSERT INTO tte_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kabo Yeisu iwaloyoi iba, “Kaba gite labuina bwaite koina na Yaubada ana kaba loina kana koleya kani yawalo-lawan koina. ");
INSERT INTO tte_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Bwaite besiele, sine yabo yisti kikiuna ikalai yo isuwai pwalawa baiki yaiyona kalona mena, kabo mekanakava iyebweli kanasiga yistine pwalawa meuloina ilusae kalona mena kabo pwalawa isese. Bwaite kaba nuwapwanopwano kolila.” ");
INSERT INTO tte_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yeisu ilalau Yelusalema kaiwena na ana laune koina yanuwa lalakili yo yanuwa kikiuli kolili iyakayakatai tomo kolili. ");
INSERT INTO tte_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tomo yabo luwali mena ineli koina iba, “Guyau, nuwana tomo nige sibabaibaiwa kani lebo silobai?” ");
INSERT INTO tte_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Kabo Yeisu iwalo boda kolili iba, “Wakaiwe kwalusae kaba lusae kipakipana koina. Yawalo kolimiu, tomo sibaibaiwa sitonan nuwanuwali silusae na nige sowasowali. ");
INSERT INTO tte_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Saugana tem nume tanuwagana ana gamwa ikausi, komiu Yudiya kani kwatotolo gana muli mena yo wakipikipisi kwawaloba, ‘Guyau, gamwa kusoke kaiwemai,’ na kabo kani kainamiu iyamaisa iwaloba, ‘Sauga imwawasiko, nige yakakataimiu yo tabe toweya kwalaomaya.’ ");
INSERT INTO tte_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kabo kani kwawalo koina kwaba, ‘Na iyamo tauna kona mekamakava kowa takekan yo tanuma. Yo kutolo ama kamwasa kolili, mwa kuyakayakataimai.’ ");
INSERT INTO tte_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Na kainamiu kani iyamaisa iba, ‘Nige yakakataimiu yo tabe toweya kwalaomaya. Meuloimiu kwalowasi, komiu tonaenaena.’ ");
INSERT INTO tte_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Komiu Yudiya kani kwavalavalam yo mwakamiu siyekalasi saugana ami tali Yudiya bwaimwa Abelamo, Aisake, Yakobo yo palopitao wagitaili simiyamiya Yaubada ana kaba loina mena. Na komiu kani sikele-yawatagilagimiu kwamiyamiya gana muli mena. ");
INSERT INTO tte_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tomo uloili kani silaomaya dabwelo ana kaba sae yo ana kaba sugu, dedei pwata yo dedei pae, kabo simiyasio Yaubada ana kaba loina koina na sikekan. ");
INSERT INTO tte_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kabo tomo siya esaliyao kikiuli kani simiya-baguna yo siya esaliyao lalakili kani simiya-muliya.” ");
INSERT INTO tte_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sauganane koina boda Palisi tupwali silau Yeisu koina siwalolau siba, “Yanuwane bwaite kulogabaen na kulau dedei uloina koina kaiwena kin Elodi nuwanuwana iunuiwo.” ");
INSERT INTO tte_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yeisu kainali iyamaisa iba, “Kwalau kwawalo bwaine bwauwane sokasokanane koina kwawaloba, ‘Kabona yo bwaliga yaluyaluwa biki kani yatao-yawatagilagili yo tokasiebwaone yawoisili, na kaliyate yaiyonane koina kani yagu paisowa yaemwawasili.’” ");
INSERT INTO tte_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yo Yeisu iwaloyoi iba, “Na besiele bwaite kabo kaliyatene kabona yo bwaliga yo bolawa yalalauyoi mwa kaiwena nige sowasowana palopita yabo iboita dedei uloina koina bwaimwanamo Yelusalema. ");
INSERT INTO tte_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Oo Yelusalema kana tomiya, komiu tubumiyao baguna palopitao siunuili yo siya Yaubada iyawasali tubumiyao kolili silovekuili. Sauga meuloina nuwanuwagu ami tomo yakele-gogonagilima besiele kamkam sinena natunao ikele-gogonagili pepena yaulina mena, na nige nuwanuwamiu besiele. ");
INSERT INTO tte_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Na kabo ami nume tabu kani imiya-bwagabwaga. Na yawalo kolimiu, nige tabe kani wagigitaiyau yoi kanasiga yapileyoimayoi, kabo sauganane koina kani kwatobalanagau kwawaloba, ‘Yaubada iwalo-muloloi iya ilaoma Guyau esana mena.’” ");
INSERT INTO tte_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yudiya ali Sabati yabo koina, Yeisu ilau Palisi ali boda kali tobaguna yabo ana nume mena ikekan. Na siya tupwaliyao kekanne koina simanman-kulakulai nuwanuwali tem ginauli yabo sigitelobai na tem siyakewai. ");
INSERT INTO tte_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Na tomo yabo iyaele imiyamiya Yeisu manna mena yona silolo. ");
INSERT INTO tte_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kabo Yeisu ineli Palisiyao yo loina kana toyakayakataiwo kolili iwaloba, “Ilonamwayan tem tokasiebwa tawoisi kaliyate Sabati mena o tem nigele?” ");
INSERT INTO tte_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Na simwanoumo nige kainana siyayamaisa. Kabo Yeisu ikabi-lau tomone koina yo iwoisi inamwanamwa yo iyawasa ilau. ");
INSERT INTO tte_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mwa kabo iwalolau kolili iba, “Tem yabo kolimiu natum tauna o tem am bulumakau ibeku waila keli kalona mena kaliyate Sabati koina, kani mwayamwayau kulau kutabeisin, besiele wa?” ");
INSERT INTO tte_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Na simwanoumo. ");
INSERT INTO tte_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yeisu igitai tomo siya kekan kaiwena siyoganlima numene koina sibomamo tomo lalakili ali kaba miya sigitesipwaili yo simiyasio kolili. Saugana mumugali igitelobai kabo walo bwaite iwalowen kolili iwaloba, ");
INSERT INTO tte_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Tem tomo yabo ikawanoi kulau kasole soina koina tabu kumimiyasio tomo lalakili ali kaba miyane koina, kisi kaba miyane sigitesipwaiyako tomo uloina kaiwena, bwaite iya esana esam ilalaki-gabaen. ");
INSERT INTO tte_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kabo soi tanuwagana iya yomiu labui iyoganmiu kani ilaowa yo iwalo koliwo, ‘Bwaite kaba miyane kutolo-gabaen na tomone bwaite imiyasio koina,’ mwa kowa kani kumwalimwaline yo kulau kumiyasio mulisosi mena. ");
INSERT INTO tte_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Na tem siyoganiwo kekan koina kulusae kulau kumiyasio mulisosi mena kabo sauganane tem soi tanuwagana ilaowa, kani iba, ‘Yagu eliyam, kutolo kulau kaba miya namwanamwana koina kumiyasio.’ Kabo tomo meuloili siya mekamkavao wakekan kani sigitaiwo kowa esam ipagan. ");
INSERT INTO tte_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kaiwena tem tomo yabo iboma ipeiseyan Yaubada kani ipei-yatalu, yo tem yabo iboma ipeiyatalu, Yaubada kani ipeiseyan.” ");
INSERT INTO tte_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kabo Yeisu iwalo nume tanuwagana koina iba, “Saugana kala pwasinasina kanna o tem lolau kanna kupaisowai, am eliyamwao tem kamkavao o tem totoumwao, tem towasawasao siya am yanuwa mena, tabu kuyoyoganli. Kaiwena tem uginauli besiele, ee siya kani siyamaisayoi koliwo. Mwa bwaite kani maisam ukwalaiyako. ");
INSERT INTO tte_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sauganane tem soi uginauli kabo tobubutuma siya nima youyouli yo tolosigesige yo tomangibugibu kuyoganli. ");
INSERT INTO tte_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kani mumugamne koina Yaubada ana walo-mulolo kulobai. Siya nige sowasowali siyamaisa-yapileyoi koliwo na sauga ana kaba mwawasi koina tem todudulai sitoloyoima boita mena Yaubada kani maisam iyeyawa.” ");
INSERT INTO tte_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Siya Palisiyao tokekanne simiyasio kekanne koina, kalikava yabo Yeisu ana walone ibenalan, kabo iwalo-gagasa koina iba, “Siya simiyasio soi kanna sikekan Yaubada ana kaba loina koina siya kani siyaliyaya lalakina.” ");
INSERT INTO tte_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kabo Yeisu walo kobwaibwaili yabo iwalowen kolili iba, “Tomo yabo kekan lalakina iginauli kabo tomo sibaibaiwa iyoganli kekanne kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kaliyatenane koina kekanne iginauli kabo ana topaisowa iyawasa ilau iwalo siya beyabeyana kekanne kaiwena ikawanoi-yagili iwalo kolili iba, ‘Kwalaoma ginauli meuloina sikatububunanako.’ ");
INSERT INTO tte_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kabo kaigeda kaigeda siwalo-panaisi. Tomo bagubagunana iwalo topaisowane koina iba, ‘Bwatano yabo yayamaisayako naga yalau yagitai mwa yawalo koliwo kani nige yalalaowa.’ ");
INSERT INTO tte_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yo yaboyoi tabe iwaloba, ‘Bulumakau sanaulu yayamaisaliko, na yalalau yapaisowa-tonagili. Mwa yawalo koliwo kani nige yalalaowa.’ ");
INSERT INTO tte_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yaboyoi tabe iba, ‘Bwaite waluwaluna kabo yakasole mwa kani nige yalalaowa.’ ");
INSERT INTO tte_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kabo topaisowane ipileyoi ilau tomone ali sikote wasana iwalowen ana taubala koina. Taubalane imunamunai lalakina kabo iwalo ana topaisowa koina iba, ‘Mwayamwayau kupileyoi kulau yanuwane kana kamwasa lalakili yo kikiuli kolili na tobubutumao yo siya nimali siyou, tomangibugibu yo siya kaeli sinae kuyoganlima silaoma yagu nume mena.’ ");
INSERT INTO tte_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kabo topaisowa iginauli besiele ana taubala ana walo. Imwawasi kabo ipileyoima yo iwalo koina iba, ‘Taubala, am walo yaginauliyako besiele kuwawalowenwa, na nume kalona ilalaki iyaele imiyamiya nige naga ikakalapowon.’ ");
INSERT INTO tte_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mwa taubala iwaloyoi ana topaisowane koina iba, ‘Kupileyoi kulau kuyawatagili ganamuli molosi mena kamwasa lalakili yo kikiuli kolili, na tomo kuwalo samasamaluluili silaoma na mesabana yagu nume siloyakalapowon. ");
INSERT INTO tte_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Na yawalo kolimiu, siya tomone yayoga-bagunayagili kani nige yagu soi kanna yabo sikakan-tonan.’” ");
INSERT INTO tte_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tomo boda lalakina mekalikava Yeisu silotoyawa silaulau, kabo itagelakeile kali koleya mena iwalo kolili iba, ");
INSERT INTO tte_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Tem tomo yabo nuwanuwana imuliya koliyau baguna tamana, sinana, wainena, natunao, kanakavao, dunao kali nuwanuwatu isikotanagili yo tabe ibomayoi mumugana isikotanagili kabo sowasowana iyamala kagu tomuliya. ");
INSERT INTO tte_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yaiya tem nige kana kelose ikekewai yo imumuliya koliyau ee iya nige sowasowana iyamala kagu tomuliya. ");
INSERT INTO tte_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tem yabo kolimiu nuwanuwana nume lalakina ikabi baguna imiyasio na inuwanuwatu kabikabine maisana kana lalaki isa, kabo ikatai tem ana mane besiele sowasowana numene ikabiwoli o tem nigele. ");
INSERT INTO tte_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Na tem tuki iyatololi yo nige sowasowana numene ikabi woli ee kani tomo meuloili sigitai sitalatalawasiyan. ");
INSERT INTO tte_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Kani siwaloba, ‘Tomone bwaite numene iyatubu ikabi, na nige sowasowana iyemwawasi.’ ");
INSERT INTO tte_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Tem kin yabo ana tokaleyayao kali baibaiwa ten tausan yo nuwanuwana siyawatagili silau mekalikava kin yabo tabe ana tokaleyayao kali baibaiwa tuwenti tausan na sikaleya kani baguna imiyasio na inuwanuwatu gubesi sowasowana situbali-yavivilali siya silalaoma kaleyane kaiwena o tem nigele. ");
INSERT INTO tte_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tem nige sowasowana kana kaleyane mekalikavao sikaleya kani ana tosagenawasao iyawasali silau kana kaleyane koina yo sikawanoi saugana naga silalaoma salili mena siwaloba, ‘Tawae kani kaeyawa na tabu kaleya iyayawatagili?’ ");
INSERT INTO tte_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Besiele tabe bwaite, tem yabo kolimiu nige ana wasawasa meuloina isisikotanan, ee iya nige sowasowana iyamala kagu tomuliya. ");
INSERT INTO tte_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ilonamwayagila tem kita besiele kalita me ana kaiwe. Kalita ginauli namwanamwana na tem ana kaiwe yo kamnana imwawasi, nige sowasowana taula-kalikalitayoi. ");
INSERT INTO tte_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nige ana paisowa ipapagan. Nige ilolonamwayan na bwatano ikabi-namwanamwai, mwa sowasowana tagabaen mowoi. Tem metenamiu, walo bwaite kwabenalan na kwanuwatu-kalatan.” ");
INSERT INTO tte_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tonaenaeli sibaibaiwa silaoma Yeisu koina simiya-takikilan nuwanuwali ana edeedede sibenalan. Yo tonaenaeli bodane kaloli mena takesi kana totano tupwaliyao simiyamiya. ");
INSERT INTO tte_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Na saugana Palisi mekalikavao loina kana toyakayakataiwo sigitai tonaenaeli sibaibaiwa silalaoma Yeisu koina kabo sibalabalamumu yo sietaetalapili siba, “Tomone bwaite tonaenaeli iyoganli, yo mekanakavao sikekan. Tawae kaiwena ana sauga iyavenuwan lolokwalaleleli kolili?” ");
INSERT INTO tte_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kabo Yeisu kainali iyamaisa yo walo kobwaibwaili yaiyona iedeedede-yagili. ");
INSERT INTO tte_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Yeisu ana walo kobwaibwaili bagubagunana iwalowen Palisiyao kolili iba, “Tem yabo kolimiu ana sipi kali baibaiwa wan andeledi na kaigeda ikwalalele kani tawae iginauli? Sowasowana naenti naen (99) ilogabaegili sikekakekan mala bakubakuna mena na iya ilau sipine ikwakwalalelene iloyai kanasiga ilobai. ");
INSERT INTO tte_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Sauganane ilobai, me ana yaliyaya ikalai isapwali yo ipeiseyan leyaleyana mena, ");
INSERT INTO tte_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","kabo ikewai yo ipileyoi yanuwa mena yo ana eliyamwao yo yanuwa tomonliyao iyoga-gogonagilima yo iwalo kolili iba, ‘Kaukavao, tayaliyaya kaiwena yagu sipi yabo ikwalalele na yalobaiyako.’ ");
INSERT INTO tte_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Na yawalo kolimiu, tem tolokwalalele yabo ana naenaena koina inuwabui tomiya bulibuli ali yaliyaya ilalakisosi kabo muli mena ali yaliyaya tonamwanamwa naenti naen kaiweli, kaiwena siya nige silolokwalalele.” ");
INSERT INTO tte_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yeisu ana walo kobwaibwaili labuina iwalowen Palisiyao kolili iba, “Saugana tem sine yabo ana mane siliba kali baibaiwa sanaulu, yo kaigeda ikwalalele tawae kani iginauli? Odam igabu na ana nume kalona ikuya yo iloya-namwanamwai kanasiga ilobai. ");
INSERT INTO tte_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Sauganane ilobai kabo ana eliyamwao yo ana yanuwa tomonliyao iyoga-gogonagilima yo iwalo kolili iwaloba, ‘Kaukavao, tayaliyaya kaiwena yagu siliba kwalakwalalelena yalobaiyako.’ ");
INSERT INTO tte_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yawalo kolimiu, tem tonaenaena yabo ana naenaena koina inuwabui Yaubada ana aneloseyao ali yaliyaya ilalakisosi besiele bwaite.” ");
INSERT INTO tte_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yeisu ana walo kobwaibwaili yaiyonana iwalowen Palisiyao kolili iba, “Taubala yabo natunao tatao labui. ");
INSERT INTO tte_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Tomulimuliye iwalo tamana koina iba, ‘Tamagu, am wasawasa kuyakasa na yau gogo saugamo bwaite kuyeyama.’ Kabo tamali ana wasawasa iyakasali yoli labuine kaiweli. ");
INSERT INTO tte_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nige sauga imamamalawe, kabo tomulimuliye ana wasawasa meuloina ikelegogon ikalaili yo ilau dedei kelamamalawe koina. Kabo ginauli bwagabwaga kolili ana wasawasa iyavenuwagili. ");
INSERT INTO tte_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ana wasawasa meuloina iyemwawasili, kabo guliyam lalakina iyawatagili dedeinane koina yo nige ginauli yabo imiyamiya koina. ");
INSERT INTO tte_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kabo gamene paisowa iloyai. Na yanuwa yabo kana taubala ilobai yo taubalane iyawasa ilau ana polo ali dedei mena igitekalatagili. ");
INSERT INTO tte_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kabo gamene guliyam lalakina ilobai. Nuwanuwana lalakina tem polo kali bembem kwapina tupwana koina ikekan na tem diyana isese. Na nigele, nige tomo yabo kan iwowolena ikakan. ");
INSERT INTO tte_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kabo nuwana imayale iba, ‘Kategu tamagu, ana topaisowa meuloili siya siyaele kan namwanamwali sikekakekan na kan tupwa ilalaki imiyamiya, na yau kabona guliyam kaiwena kani yaboita. ");
INSERT INTO tte_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Saugamo kani yatolo yapileyoi tamagu koina yo kani yawaloba, Tamagu, yalopwanoko Yaubada koina yo kowa koliwo. ");
INSERT INTO tte_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nige yagu namwanamwa yabo imiyamiya na ukwawa-natu-wagau, kupeiyau yau besiele am topaisowa yabo.’ ");
INSERT INTO tte_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kabo itolo yo ilau tamana koina. Gamene iyaele ilalaoma kelamamalawe mena mwa tamana manna ilau igitai yo katena ikamkamna kabo isagena ilau, natuna isapwali yo inisoi. ");
INSERT INTO tte_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Gamene iwalo tamana koina iba, ‘Tamagu, yalopwanoko Yaubada koina yo kowa koliwo, nige yagu namwanamwa yabo imiyamiya na ukwawa-natu-wagau.’ ");
INSERT INTO tte_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kabo tamana iwalo ana topaisowao kolili iba, ‘Mwayamwayau kwama namwanamwasosina malamalawena wakalai kwalawanama yo kwayalikwa. Yo nimana mena pasa kwapeili yo kaena kana suma kwapeili. ");
INSERT INTO tte_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Na kwalau bulumakau natuna sinisinibuna wakalaiyama kwaunuyamate kabo takekan toyawa yo tayaliyaya. ");
INSERT INTO tte_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kaiwena natugu bwaite iboita na sauga bwaite yawasina ilobaiyoi, ilokwalalele na talobaiyoi.’ Kabo kan lalakina siginauli yo siyaliyaya.” ");
INSERT INTO tte_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Yeisu ana walo kobwaibwaili yaiyonana ietulan iba, “Sauganane tobagubaguna ipileyoima iyawatagilima nume salina mena ibenalan dagugu yo talawauwau lalakina nume mena. ");
INSERT INTO tte_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kabo topaisowa yabo iyoganama yo koina ineli iba, ‘Tawae sipaipaisowaine?’ ");
INSERT INTO tte_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kainana iyamaisa iba, ‘Kamkava ipileyoima mwa tamamiu kan lalakina iginauli kaiwena kamkava lolokwalalelena ilobaiyako me ana namwanamwa.’ ");
INSERT INTO tte_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Saugana tobagubagunane walone bwaite ibenalan kabo imunamunai yo isikote nige nuwanuwana ilusae numene kalona mena. Mwa tamana iyawatagili koina ikawanoi samasamalulu yakato ilau ilusae. ");
INSERT INTO tte_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Na tamana kainana iyamaisa iwaloba, ‘Ugitai, bolime ibaibaiwasosi yapaisowa kaiwem yau besiele topaisowa panpanna, yo nige sauga yabo am loinane yalilikwaili. Na nige sauga yabo gouti natuna kuyeyeyama yo meyagu elieliyamwao kayaliyaya. ");
INSERT INTO tte_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Na natum bwaite iya am wasawasa meuloina iyavenuwan sinesineo ganaganawalili kolili na saugana ipileyoima kuwalo bulumakau natuna sinisinibuna siunuyamate iya kaiwena.’ ");
INSERT INTO tte_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tamana iwalo koina iwaloba, ‘Natugu, sauga meuloina kowa te yau tamiyamiya mwa ginauli meuloina koliyau kowa am gogo. ");
INSERT INTO tte_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Na sauga bwaite kamkava inuwabuiko mwa ilonamwayagila takekan yo tayaliyaya. Kaiwena kamkava bwaite iboita na meyawasina, ilokwalalele na talobaiyoi.’” ");
INSERT INTO tte_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yeisu nuwanuwana ana tomuliyayao ikabiyakaiweli yanuwa yaulina kana wasawasa siyapaisowa na mesabana tem wasawasane imwawasi Yaubada iyoganli silusae simiyamiya ana nume miyamiya yaina koina. Mwa walo kobwaibwaili bwaite iwalowen kolili iba, “Taubala yabo iya towasawasa na togitekalatan ipei ana wasawasane igitegite-kalatan. Kabo sauga yabo tomo tupwaliyao silau taubalane koina ana wasa siwolena siwaloba, ‘Togitekalatanne am wasawasa isibasiba-yanae.’ ");
INSERT INTO tte_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kabo taubalane togitekalatanne iyoganama yo iba, ‘Wasam siwalowen yabenalan gubesi? Yagu wasawasa isa kuyapaisowailiko yo isa simiyamiya kuleleli pepa mena yo kuyeyama koliyau, kaiwena kani nige kuyayamala togitekalatan yoi kaiwegu, kani ukwaisulu paisowane koina.’ ");
INSERT INTO tte_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mwa togitekalatanne iboma inuwanuwatu yo iba, ‘Tawae kani iyawatagili koliyau? Toweya kani yamiyaya? Kaiwena kikiunamo yagu taubala yagu kaba paisowane koina kani ikele-gabaegau. Genuwagu yaemala tokawakawanoi kisi yamwalimwaline yo nige yagu kaiwe na paisowa polopolowena yapaisowai besiele siya tokelikeli bwatano. ");
INSERT INTO tte_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","O, kabo nuwagu imayale, yakatai tawae kani yaginauli. Kani toloyagane kali yagayaga yatom-yataluli na tem saugana yagu kaba paisowane yalogabaen siya toloyagane kani siyoganiyau yalusae yamiyamiya ali nume mena.’ ");
INSERT INTO tte_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kabo siya analiyao kali yagayaga simiyamiya ana taubalane koina kaigeda kaigeda iyoganlima koina. Ineli bagubagunana koina iba, ‘Kam yaga kana lalaki isa yagu taubala koina?’ ");
INSERT INTO tte_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Kainana iyamaisa iwaloba, ‘Oo yagane olo olibe kali baibaiwa dalam andeledi.’ Kabo togitekalatan iwalo koina iba, ‘Ee kam yagayaga kana lalaki pepana bwaite, ukwalai kumiyasio mwayamwayau na andeledi kusoke-gabaen na kulele-lobiyen pipti.’ ");
INSERT INTO tte_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kabo togitekalatan ineliyoi labuina koina iba, ‘Kowa kam yagayaga kana lalaki isa?’ Kainana iyamaisa iba, ‘Yagayagane kana lalaki witi kanna baikina andeledi.’ Mwa togitekalatan iwalo koina iwaloba, ‘Ee kam yagayaga kana lalaki pepana bwaite ukwalai na andeledi kusoke-gabaen na kulele-lobiyen eiti.’ Kabo toloyagaone iwalo silau. ");
INSERT INTO tte_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kabo ana taubalane togitekalatanne ana paisowa wasana ibenalan yo iwalo koina iba, ‘Bwagana ukewali koliyau na iyamo yawasosimo kusonoga kaiwena toloyagaone kani siyoganiwo ali nume mena saugana tem yasikotanagiwo am paisowane koina.’” Yeisu ana walo kobwaibwaili iyemwawasi kabo iba, “Bwaite kobwaibwailine iyakenayagila yakato yanuwa yaulina tomoliyao ali bisinisi paisowana koina sisonogasosi kabo muli mena tomeliwo ali sonoga. ");
INSERT INTO tte_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Na yau yawalo kolimiu, yanuwa yaulina kana wasawasa kwasoiyagili tomo tobubutumao kolili na siyaliyaya kolimiu yo siyamala ami elieliyamwao mesabana tem wasawasane imwawasi Yaubada iyoganmiu kwalusae kwamiyamiya ana nume miyamiya yaina koina. ");
INSERT INTO tte_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Yaiya tem ginauli kikiuna koina iobiga tabe ginauli lalakili kolili iobiga. Na tem ginauli kikiuna koina imwakota tabe ginauli lalakina koina imwakota. ");
INSERT INTO tte_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Besiele komiu, tem nige yanuwa yaulina kana wasawasa kwayayapaisowa namwanamwai kani Yaubada nige sowasowana wasawasa yawasosi iyeliwa wagigite-kalatagili. ");
INSERT INTO tte_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yo tem kamikavao ali wasawasa nige kwayayapaisowa namwanamwai kani nige tabe Yaubada ami wasawasa iyeyeliwa. ");
INSERT INTO tte_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nige sowasowana tomo kaigeda ipaisowa tautaubalao labui kolili. Kani yabo imulolo koina na yabo isikotanan. Nige sowana labuine kolili kupaisowa Yaubada yo wasawasa.” ");
INSERT INTO tte_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Boda Palisi siya tonuwa-mane, kabo saugana Yeisu ana edeedede meuloina kabona iwalowen sibenalan mwa ana walone simalumaluwan. ");
INSERT INTO tte_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kabo Yeisu iwalo kolili iba, “Tomo manli mena kwayakenayagimiu yakato komiu todudulai na Yaubada katemiu ikatailiko. Na tawae tomo sigitai yo siwalo inamwanamwasosi, Yaubada manna mena ginauline ikawa-naenaeyan. ");
INSERT INTO tte_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Loinao yo palopita ali palopisai simiyamiya ilaoma kanasiga Yoni Toyababitaiso koina. Mulina mena tomo sibaibaiwa wasana namwanamwana Yaubada ana kaba loina kaiwena sibenabenalan kabo sitonan kaikaiwe na tem silusae. ");
INSERT INTO tte_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mosese ana loina yabo kikiuna kana soke-gabae ikololososi kabo muli mena bulibuli yo yanuwa yaulina ali tatagwaligwali. ");
INSERT INTO tte_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Tem tau wainena isikotanan yo sine uloina ikasolanan kani taune iganawali. Yo tem tau yabo ilaoma na sinene inainawasenane ikasolanan bwaimwa taune iya iganawali.” ");
INSERT INTO tte_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Towasawasa yabo sauga meuloina kwama kali koleya namwanamwasosili maisaliyao lalakili ilikwalikwali yo kaliyate kaigeda kaigeda kan namwanamwana ikankan. ");
INSERT INTO tte_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Tobubutuma yabo esana Lasalo sauga meuloina sikalakalaiyama towasawasane ana nume gamwana manna mena sipeipei, iya nuwanuwana towasawasane ana kantele sigabagabaegili ikalaili kolili ikekakekan. Yona meuloina silobalibaliyan yo bwauwa silau koina kana baliyan sinamonamosili. ");
INSERT INTO tte_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Imiyamiya kabo Lasalo iboita kabo aneloseyao sikalai silawan Abelamo salina mena yo mekanakava simiyamiya. Yo mulina mena towasawasane iboita kabo tomo yona sipei salai mena. ");
INSERT INTO tte_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kabo imiyamiya Edesi yo kamkamna lalakina ilobalobai. Isakaisae igitai Abelamo mekanakava Lasalo siyaele kelamamalawe mena. ");
INSERT INTO tte_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mwa iyoga iba, ‘Tamagu Abelamo, ukwate-kamkamna-yagau na Lasalo kuyawasa ilau nimana gibuna iyabuta waila mena na ilaoma memenagu mena ipei na memenagu iyatulu. Kaiwena yau yakamkamnasosi mayau bwaite kalona mena.’ ");
INSERT INTO tte_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Na Abelamo kainana iyamaisa iba, ‘Natugu, kunuwatu-kalatan tauna kona meyawasim koina yanuwa yaulina mena gogo namwanamwali ukalakalaili, na Lasalo iya gogo naenaeli ikalakalaili. Na sauga bwaite Lasalo iyaliyaya dedei bwaite koina yo kowa kamkamna lalakina kulobai. ");
INSERT INTO tte_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Na ginauli yabo tabe, komiu yo kai luwaluwalila mena sowasowaga lalakina imiyamiya, nige sowasowamai kalopanaisiwa yo komiu tabe besiele nige sowasowamiu kwalopanaisima kolimai.’ ");
INSERT INTO tte_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Towasawasane iwalolau Abelamo koina iba, ‘Tamagu, tem besielene yakawanoi koliwo Lasalo kuyawasa ilobi tamagu ana nume mena. ");
INSERT INTO tte_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kaiwena kaukavao yoli valigigi siyaele simiyamiya. Tem ilau na iyanuwapeili na sinuwabui tabu silalaoma kamkamnane yanuwanane bwaite koina.’ ");
INSERT INTO tte_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abelamo kainana iyamaisa iwaloba, ‘Mosese ana walo yo palopitao ali walo siyaele Buki Tabu mena sowasowali sibenalan.’ ");
INSERT INTO tte_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Na towasawasane iwalo Abelamo koina iba, ‘Tamagu Abelamo, bwaite nigele. Na tem tomo yabo besiele Lasalo itoloyoima boita mena na ilau iwalo kolili kani sinuwabui.’ ");
INSERT INTO tte_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abelamo iwalo koina iba, ‘Tem Mosese yo palopitao ali walo nige sibebenalan tabe besiele tem toboita yabo itoloyoima boita mena nige sowana nuwali ikoi na sinuwabui.’” ");
INSERT INTO tte_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yeisu iwalo ana tobenaliyao kolili iba, “Walo yawasosi, ginauliline siya tomo siwoya-pwanolili kani siyawatagili na yaiya tomo koina woyane iyawatagili kani maisana polopolowesosina ilobai Yaubada koina. ");
INSERT INTO tte_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tem towoyane tomeli kikiuna iwoya-pwanoli kana maisa Yaubada koina kani ipolowesosi. Kaba gite yabo bwaite yawalowen. Tem tomo yabo veku polopolowena galogalona mena sipan yo sigabaen kalita mena igalomwasi iboita maisana tupwana ipolowe kaiwena yona iboita. Na towoyane maisana Yaubada koina ipolowesosi kaiwena Yaubada kani towoyane yaluyaluwana isibayanae. ");
INSERT INTO tte_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mwa wagite-kalatagimiu kisi yabo kwawoya-pwanoli. Tem kamkava ilopwano kuwalo koina kuba, ‘Tabu ugiginauli besiele bwaite’ yo tem iwaloba ‘O, walo yawasosi tomala yalopwano,’ kabo ana lopwano kunuwatu-pwaiki. ");
INSERT INTO tte_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tabu am nuwatu-pwaiki kamkava koina ilolopei. Tem kamkava ilopwano koliwo yo ikawanoi nuwatu-pwaiki kaiwena ee kunuwatu-pwaiki. Tem kaliyate kaigeda kalona mena iginauli besiele meseben kabo sauga kaigeda kaigeda ilaowa yo iba, ‘Yalopwano koliwo tem sowasowana kunuwatu-pwaikiyau’ kabo sauga kaigeda kaigeda ana pwanoli kunuwanuwatu-pwaikili.” ");
INSERT INTO tte_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apositoloyao siwalo Yeisu koina siwaloba, “Ama meli kuyalalakiyoi.” ");
INSERT INTO tte_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kainali iyamaisa iba, “Tem ami meli kikitoitoina imiyamiya, bwagana ana kikiu besiele ketabu patuna, sowasowamiu ginauli kaba nuwapwanopwano kwapaisowaili. Kabo tem kwawalo mayau lalakina yabo koina kwawaloba, ‘Kuboma kutasulu yo kuboma kulau ukumaiwo kalita mena,’ kabo kani iginauli besiele ami walo.” ");
INSERT INTO tte_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Tem yabo kolimiu me ana topaisowa panpanna na topaisowane ilau ipaisowa tano mena, o nuwana sipi igitekalatagili, saugana ipileyoima tano mena, kani nige kuwawalo ilaoma imimiyasio na ikekan baguna kabo muli mena kowa. ");
INSERT INTO tte_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nigele. Kani kuwalo koina mayau ipei na kam iloliga isugu ikatububunan kabo kam ikalaiyama na ukekan yo kunuma. Imwawasi kabo muli mena iya ikekan yo inuma. ");
INSERT INTO tte_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nige kana lonamwa yakato taubalane ikawa-toki ana topaisowane koina kaiwena topaisowane iya ipaisowamo besiele ana taubala ana walo. ");
INSERT INTO tte_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Na besiele tabe bwaite komiu, saugana tem paisowa bwaite yaeyawa kolimiu kwaemwawasi woli, kabo kwaba, ‘Kai topaisowa bwagabwagamo nige ama namwanamwa kolimai imiyamiya, ama paisowa bwaite kuyeyama kolimai kapaisowamo.’” ");
INSERT INTO tte_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Saugana Yeisu ilalau Yelusalema kaiwena, Galili yo Sameliya luwaluwalili mena iyawatagili. ");
INSERT INTO tte_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kikiunamo iyawatagili yanuwa yabo koina kabo tolepelo yoli sanaulu ilobaili. Sitolo tupwana kali mwayaga iyai, ");
INSERT INTO tte_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kabo siyoga kainali lalakina mena siba, “Taubala Yeisu, ukwate-kamkamna-yagimai.” ");
INSERT INTO tte_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Saugana igitaili, mwa iwalolau kolili iba, “Kwalau topwaoli kolili yomiu kwayakenayagili.” Silaulau kamwasa mena kabo kali lepelo imwawasi. ");
INSERT INTO tte_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kalikava yabo saugana yona igitai inamwanamwa kabo ipileyoi ilolotobatobali Yaubada koina kainana lalakina mena. ");
INSERT INTO tte_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ipileyoi ilau Yeisu koina italu-pwaopwaom kaekaena mena mwa ikawatoki koina. Na iyamo iya Sameliya tomona. ");
INSERT INTO tte_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yeisu iba, “Tomo yoli sanaulu (10) yawoisili, na yoli naen (9) toweya siyaele? ");
INSERT INTO tte_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Iya nige Yudiya dedeina tomona na iya ibomamo ipileyoima na Yaubada itobalan.” ");
INSERT INTO tte_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kabo Yeisu iwalo tomone koina iba, “Kutolo yo kulau, am meli kaiwena kunamwanamwa.” ");
INSERT INTO tte_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Boda Palisi sineli Yeisu koina siba, “Sauga esana Yaubada ana kaba loina iyawatagili?” Kainali iyamaisa iwaloba, “Saugana tem Yaubada ana kaba loina iyawatagili, nige besiele yakato tomo manli mena kilakilalane sigitaili, ");
INSERT INTO tte_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","o tem siwaloba, ‘Kagitai iya bwaite’ o ‘iya bwaine,’ nigele, kaiwena Yaubada ana kaba loinane iyaele imiyamiya luwamiu mena.” ");
INSERT INTO tte_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kabo Yeisu iwalo ana tobenaliyao kolili iba, “Sauga ilalaoma nuwanuwamiu lalakina Tomo Natuna ana kaliyate yabo wagitai na iyamo kani nige wagigitai. ");
INSERT INTO tte_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tomo kani siwalo kolimiu siwaloba, ‘Wagitai iya bwaine’ o tem ‘iya bwaite’ na tabu kwamumuliya kolili. ");
INSERT INTO tte_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kaiwena Tomo Natuna ana kaliyate kana kilakilala besiele pigabu tem ipigabu luwaluwali bwagabwaga mena na mayalena mena dedei meuloina imayale kani tomo meuloili sigitai. ");
INSERT INTO tte_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Na baguna Tomo Natuna kani kamkamna lalakina ilobai, yo tabe yaso bwaite kani sisikotanan. ");
INSERT INTO tte_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Besiele beyabeyana Nowa ana sauga koina Tomo Natuna ana sauga besiele. Kani tomo iyakate-yapitalili. ");
INSERT INTO tte_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Sauganane tomo sikekakekan yo sinumanuma sikasokasole kanasiga kaliyatenane koina Nowa ilau ilusae waga kalona mena kabo yalubwasi ididi yo tomo meuloili siboitaoli. ");
INSERT INTO tte_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Na mumuga kaigedana besiele tabe Lota ana sauga koina tomo sikekakekan sinumanuma gogo sigimwagimwala-yagili, sikumakuma yo sinumenume-kabi. ");
INSERT INTO tte_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Na kaliyatenane koina Lota Sodoma iyabubu-gabaen kabo Yaubada veku salepa wedowedolina isuwe-lobiyenama bulibuli mena italu besiele galewa yo tomo meuloili igabuli siboitaoli. ");
INSERT INTO tte_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Na kani bwaite besiele kaliyatene koina Tomo Natuna tomo sikilala. ");
INSERT INTO tte_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kaliyatene koina tem tomo yabo iyaele ana nume kewana mena yo ana gogo iyaele nume kalona mena, tabu ikakaisulu ilulusae ana gogone ikakalaili kaiwena nige sauga imiyamiya. Besiele tem tomo yabo iyaele ipaipaisowa tano mena tabu ipipileyoi ginauli yabo kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kwanuwatu-kalatan Lota wainena tawae iyawatagili koina. ");
INSERT INTO tte_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yaiya tem itonan yawasina ileboi kani igabaen yo yaiya tem yawasina igabaen kani yawasina ileboi. ");
INSERT INTO tte_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Yawalo kolimiu, boniyainane koina tomo labui kaba keno kaigeda koina sikenokeno, yabo kani sikalai na yabo imiyamiya. ");
INSERT INTO tte_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Besiele tabe sinesineo labui sipaisowa toyawa witi kanna sitamtam, yabo kani sikalai na yabo imiyamiya. ");
INSERT INTO tte_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Tatao labui sipaipaisowa tano mena besiele, yabo kani sikalai na yabo imiyamiya.” ");
INSERT INTO tte_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Saugana tobenaliyao walone bwaite sibenalan, mwa sineli Yeisu koina siba, “Guyau, toisabo dedei koina kani ginauli bwaite kuwalowegili siyawatagili?” Kainali iyamaisa iba, “Tem wagitai aoao bodali sitowa niu liguli kolili sivalavalam ee wakatai bowa kana kilakilala iyaele yauli mena imiyamiya.” ");
INSERT INTO tte_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kabo Yeisu walo kobwaibwaili yabo iedeedede-yani ana tobenaliyao kolili na tem iyakenayagili yakato sauga meuloina sikawakawanoi na tabu silolopei. ");
INSERT INTO tte_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Iba, “Yanuwa yabo koina toyatala yabo imiyamiya iya nige Yaubada iyayakasisiyan yo nige tomo kaiweli inuwanuwatu. ");
INSERT INTO tte_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na kwabukwabuli yabo imiyamiya tabe bwaine yanuwane koina ilaolaoma toyatalane koina yo iwalowalo, ‘Kusaguiyau yo kagu tokalomagigili kuyatalayan ana pwanoli koliyau kaiwena.’ ");
INSERT INTO tte_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Sauga imamalawe toyatalane isikote, genuwana isagui. Muli mena kabo ibomayoi iba, ‘Bwagana nige Yaubada yayakasisiyan yo nige yanuwanuwatu tomo kaiweli, ");
INSERT INTO tte_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","na kaiwena kwabukwabuline iyapoloweyau kani yasagui yo ana yatala yaginauli. Tem nigele, kani isamasamalulu ilaolaoma kabo kani yogu ikwatakwata-yani.’” ");
INSERT INTO tte_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yeisu ana walo kobwaibwaili iyemwawasi kabo iba, “Wagitai toyatala naenaenane ana waloyameli sinene koina. Kabo ala toyatala dudulaina ana waloyameli kolila sowasowana tameliyan. ");
INSERT INTO tte_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Yaubada iya bulibuli kana toyatala ana loina idudulaisosi kabo muli mena yanuwa yaulina kana toyatala ali loina. Mwa koina takatai yawasosi Yaubada ana gitesipwa tomonliyao siya kaliyate yo boniyai sivalavalam koina sagu kaiwena kani isaguili. Nige sowana ali kawanoi ipeipei-yavivila na isanasana besiele yanuwa yaulina kana toyatala mumugali. ");
INSERT INTO tte_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yawalo kolimiu Yaubada kani mwayamwayau ana tomoyao isaguili. Na saugana Tomo Natuna ipileyoima, kani isa tomo siya simiyamiya yanuwa yaulina mena sitolo kaiwe me ali meli ilobaili?” ");
INSERT INTO tte_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tomo tupwaliyao sibomayoi siwaloseyagili yo kalikavao meuloili tabe sigite-lobiyegili. Kabo Yeisu iwalo-kobwaibwaili-yagili tonuwasaesaene kaiweli iba, ");
INSERT INTO tte_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Sauga yabo tomo labui silau Nume Tabu koina na sikawanoi. Yabo Palisi yo yabo takesi kana totano. ");
INSERT INTO tte_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Palisi ilusae itolo mwa ibomayoi kaiwena ikawanoi iba, ‘Yaubada, yakawatoki koliwo yau nige besiele tomo tupwaliyao kaiwena siya tokewali, siya mumugali inae yo siya siganaganawali, yo yau nige besiele takesi kana totano bwaite. ");
INSERT INTO tte_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Wiki kaigeda kalona mena kaliyate labui tapwalolo kaiwena guliyam yakalakisiyeyan. Wiki kaigeda kaigeda yaginauli, mumugagu besiele. Yo ginauli meuloina yalobai kabo yayakasali gwau sanaulu, na gwau kaigeda yamulolowan koliwo.’ ");
INSERT INTO tte_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Palisi ana walo iyemwawasi kabo takesi kana totano ilusae na itolo suwala gamwa mena. Nige isasakaisae bulibuli mena kaiwena me ana mwalimwaline yo gamwagamwalina mena ikoikoi iba, ‘Yaubada yau tonaenaena, ukwate-kamkamna-yagau.’” ");
INSERT INTO tte_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yeisu ana walo kobwaibwaili iyemwawasi kabo iba, “Yawalo kolimiu, saugana tomone ipileyoi ana nume mena, iya idudulai Yaubada manna mena na Palisi iya nigele. Kaiwena tomo meuloili siya sibomayoi sipei-seyagili Yaubada ipei-yataluli yo siya sibomayoi sipei-yataluli Yaubada kani ipei-seyagili.” ");
INSERT INTO tte_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tomo tupwaliyao melumeluwo kikiuli sikalailima Yeisu koina na tem nimana ipeili pwatali mena. Tobenaliyao sigitaili kabo ali paisowane kaiwena siyokoiyagili. ");
INSERT INTO tte_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Na Yeisu melumeluwone iyoganli silaoma koina yo iba, “Melumeluwo kwatalamwagili silaoma koliyau, tabu kwanunuwaili kaiwena melumeluwo besiele bwaite Yaubada ana kaba loina ilonamwayagili yawasosi. ");
INSERT INTO tte_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yawalo yawasosi kolimiu, tem tomo yabo Yaubada ana kaba loina nige iyayaliyaya-yani yo nige ikakalai besiele melumeluwo kikiuli ali kalai, iya kani nige ilulusae koina.” ");
INSERT INTO tte_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Toloina yabo ineli Yeisu koina iba, “Toyakayakatai namwanamwana, tawae yaginauli na yawasi miyamiya yaina yalobai?” ");
INSERT INTO tte_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Kabo Yeisu iwalolau koina iba, “Gubesi, ukwatai tawae kuwalowen saugana ukawa-namwanamwa-yagau? Nige tonamwanamwa yabo imiyamiya, Yaubadamo iboma iya tonamwanamwa. ");
INSERT INTO tte_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Na ukwatai bwaite loinane iba, Tabu ganawali, tabu unuyamate, tabu kewali, tabu kamkava kuyakewa bwagabwagai, tamam yo sinam kuyakasisiyagili.” ");
INSERT INTO tte_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Towasawasane iba, “Yagu sauga melumelu koina kanasiga sauga kabona loina bwaite meuloili yaobigaili.” ");
INSERT INTO tte_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yeisu walone ibenalan kabo iwalolau koina iba, “Ginauli kaigeda koina kudeva. Kulau am wasawasa meuloili ugimwala-yagili maneliyao kuwolegili tobubutuma kolili kabo kani am wasawasa kulobai bulibuli mena. Kabo muli mena kulaoma kumuliya koliyau.” ");
INSERT INTO tte_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Saugana tomone walone bwaite ibenalan kabo nuwana inae kaiwena iya iwasawasasosi. ");
INSERT INTO tte_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","25","Yeisu tomone imankulakulai kabo iba, “Towasawasao ali lusae Yaubada ana kaba loina koina ikololososi kabo muli mena kameli sinalom gulana mena ana lusola.” ");
INSERT INTO tte_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Siya ana walo sibenalan sineli siba, “Na kabo yaiya sowasowana lebo ilobai?” ");
INSERT INTO tte_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yeisu kainali iyamaisa iba, “Ginauli tawae tomo nige sowasowali sipaisowai Yaubada iya sowasowana ginauline ipaisowai. Yaubada ibomamo iloina yaiya ilusae bulibuli mena yo yaiya nigele.” ");
INSERT INTO tte_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kabo Pita iwalo koina iba, “Na gubesi kai? Ama gogo meuloina kalogabaegili na kalaoma kamuliya koliwo.” ");
INSERT INTO tte_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yeisu iwalo kolili iwaloba, “Walo yawasosi yawalo kolimiu, yaiya tem ana yanuwa, tem wainena, tem kanakavao, tem sinana yo tamana o tem natunao ilogabaegili Yaubada ana kaba loina kaiwena, ");
INSERT INTO tte_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kani sauga bwaite koina maisana lalakisosina yo sauga muli mena yawasina miyamiya yaina ilobai.” ");
INSERT INTO tte_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yeisu tobenaliyao yoli tuwelo iyoga-suwalagili yo iwalolau kolili iba, “Iyaele talalau Yelusalema kaiwena kabo ginauli meuloina siya palopitao sileleleliwa Tomo Natuna kaiwena kani iyamala yawasosi. ");
INSERT INTO tte_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kani siwolena siya nige Yudiya kolili yo sitalawasiyan, sikawa-naenaeyan, sikaikaisoi, sisapi-gwalagwalai yo siunuyamate, ");
INSERT INTO tte_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","iboita yo kaliyate yaiyonana koina kani itoloyoi boita mena.” ");
INSERT INTO tte_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tobenaliyao Yeisu ana walo nige nuwali imamayaleyan, ana walo kana nuwa-mayale iwadam kolili kabo nige sikakatai tawae walona iwalowalo. ");
INSERT INTO tte_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yeisu kikiunamo iyawatagili yanuwa Yeliko koina kabo tomangibugibu yabo silobai. Iya imiyasio kamwasa dedeina mena yo ikawakawanoi tomo kolili. ");
INSERT INTO tte_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Saugana ibenalan boda silologabaen, kabo ineli tomo kolili iba, “Tawae siginaginauline?” ");
INSERT INTO tte_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kainana siyamaisa siwaloba, “Yeisu game Nasaleta ilalau.” ");
INSERT INTO tte_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kabo iyoga iba, “Yeisu, kowa Deibida tubuna, ukwate-kamkamna-yagau.” ");
INSERT INTO tte_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tomo siya sibagubaguna siyokoiyan yo siwalo koina yakato imwanou, na iyoga samasamalulu yoi iba, “Deibida tubuna, ukwate-kamkamna-yagau.” ");
INSERT INTO tte_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yeisu ilotolo mwa iwalo tomo kolili tomangibugibune sikalaiyama koina. Saugana ilaoma Yeisu koina mwa Yeisu ineli koina iba, ");
INSERT INTO tte_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Tawae nuwanuwam yapaisowai kaiwem?” Kainana iyamaisa iba, “Guyau, nuwanuwagu mangu silala.” ");
INSERT INTO tte_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yeisu iwalo koina iba, “Am meli kaiwena manim silala, kunamwanamwa.” ");
INSERT INTO tte_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Sauganane manna sinamwanamwa kabo Yeisu koina imuliya yo Yaubada itobatobalan. Tomo meuloili ginauline sigitai kabo siya tabe sitobatobali Yaubada koina. ");
INSERT INTO tte_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Kabo Yeisu Yeliko koina ilusae mwa yanuwane kalona mena ilaulau. ");
INSERT INTO tte_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na tomo yabo iyaele esana Sakiusa iya takesi kana totano ali tobaguna yabo, yo iya towasawasa. ");
INSERT INTO tte_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nuwanuwana lalakina tem Yeisu igitai na nige sowasowana kaiwena saliyana ikubwa yo boda ilalaki. ");
INSERT INTO tte_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kabo isagena baguna boda luwali mena ilau mayau esana sikamole ivinaei kaiwena Yeisu ana laomane koina tem igitai. ");
INSERT INTO tte_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Saugana Yeisu ilaoma iyawatagili dedeinane koina kabo isakaisae yo iwalo koina iba, “Sakiusa, mwayamwayau ukwaisuluma, kaiwena nuwanuwagu sauga bwaite koina am nume mena yamiyamiya.” ");
INSERT INTO tte_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kabo saugana Sakiusa isaluluma mayaune koina me ana yaliyaya Yeisu iyogan silau ana nume mena. ");
INSERT INTO tte_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tomo meuloili sigitai kabo sietaetalapili Yeisu kaiwena siba, “Gubesi mwa Yeisu ilusae tonaenaenane ana nume mena.” ");
INSERT INTO tte_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Na numene kalona mena Sakiusa itolo yo iwalolau Yeisu koina iba, “Guyau, kani yagu wasawasa yayakasa gwau labui kabo gwau yabo kani yaolena tobubutumao kolili. Tem tomo yabo yamwakotayanako yo ana gogo yakewaliyako, kani me esopali yayamaisa-yapileyoi.” ");
INSERT INTO tte_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kabo Yeisu iwaloba, “Kabona Yaubada nume bwaite kana tomiyayao ileboili, kaiwena tomone bwaite Sakiusa ana meli ipei Yaubada koina kabo sowasowana tawalo yakato iya tabe Abelamo tubuna yabo. ");
INSERT INTO tte_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kaiwena Tomo Natuna ilaoma lolokwalaleleli iloyaili yo ileboili besiele tomone bwaite.” ");
INSERT INTO tte_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tomo siya siyaele Yeisu ana edeedede sibenabenalan mwa walo kobwaibwaili yabo iedeededeyan kolili kaiwena tomo ali nuwatu yakato kikiunamo Yeisu ilusae Yelusalema na Yaubada ana kaba loina iyatubu. Yelusalema nige imamamalawe Yeliko koina. ");
INSERT INTO tte_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Iba, “Tomo lalakina yabo ilalau yanuwa kelamamalawe koina na tem kana pwaopwaom wasawasana siwolena na ipileyoimayoi iboma ana yanuwa mena iloina. ");
INSERT INTO tte_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ana topaisowao yoli sanaulu iyoganlima, mwa yoli sanaulune mane siliba andeledi kaigeda kaigeda iwolegili kolili yo iwalo kolili iba, ‘Mane bwaite kwayapaisowaili kanasiga yapileyoima.’ Imwawasi kabo ilau. ");
INSERT INTO tte_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Na ana yanuwa tomonliyao sikalomagigilan kabo tomo tosagenawasa siyawasali silau yanuwane ilalaune koina mwa siba, ‘Nige nuwanuwamai tomo lalakinane bwaite iyamala ama kin.’ Na walone bwaite nige sibebenalan.” ");
INSERT INTO tte_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Na iyamo tomo lalakinane sipei iyamala kin kabo ipileyoima iboma ana yanuwa mena na iloina. Saugana ipileyoima, kabo iba, ‘Topaisowa siya beyabeyana mane yaolegili kolili kuyoganli silaoma koliyau nuwanuwagu yakatai mane gubesi ali yapayapaisowaili, nuwana kana etulan isa tabe silobailiko.’ ");
INSERT INTO tte_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Topaisowa bagubagunana ilaoma iba, ‘Taubala, beyabeyana mane siliba andeledi kaigeda kuyeyama, mwa yayapaisowa mwa kana etulan andeledi kaigeda tabe yalobai.’ ");
INSERT INTO tte_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kainana iyamaisa iba, ‘Kowa topaisowa namwanamwana am paisowa idudulai kaiwena bwagana ginauli bwaite nige ginauli lalakina na iyamo ugitekalatan namwanamwai, mwa kani yapeiwo yanuwa kali baibaiwa sanaulu kuloinayagili.’ ");
INSERT INTO tte_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Topaisowa labuina ilaoma koina iba, ‘Taubala, beyabeyana mane siliba andeledi kaigeda kuyeyama mwa bwaite yayapaisowa kana etulan pipti yalobai.’ ");
INSERT INTO tte_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tomo lalakinane iwalo koina iba, ‘Inamwanamwa, kani bwaite maisam yaeyawa yapeiwo yanuwa kali baibaiwa paibi kuloinayagili.’ ");
INSERT INTO tte_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Yo topaisowa yaboyoi ilaoma koina iba, ‘Taubala, beyabeyana siliba andeledi kaigeda kuyeyama ee iyaele bwaite, kaleko tupwatupwana kikiuna yakalai mwa yasuma koina yawadam kisi ikwalalele. ");
INSERT INTO tte_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kowa tomo kolokololona kaiwena am wasawasa ukwalakalai tomo uloili ali paisowa koina. Siya sipelipeli yo sikelikeli na kowa nonowanamo ukwalakalai na kupeipei am lakawa mena. Kabo yamatausagiwo mwa manene nige yayayapaisowa.’ ");
INSERT INTO tte_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tomo lalakinane iwalolau koina iwaloba, ‘Kowa topaisowa naenaena, na kuboma am walo ipileyoi koliwo yo iletaiwo. Ukwataiyako yau tomo kolokololona yo yagu wasawasa yakalakalai tomo uloili ali paisowa koina. ");
INSERT INTO tte_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Na tawae kaiwena nige kulalau yagu mane kupepei benki koina na siyapaisowa? Tem uginauli besiele kani kana etulan yalobai. Na nigele, nige kupaipaisowai.’ ");
INSERT INTO tte_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kabo iwalo siya sitotolo salina mena kolili iba, ‘Manene wakele-gabaen koina yo kwaolena topaisowa bagubagunanane koina iya siliba tu andeledine koina.’ ");
INSERT INTO tte_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Na siwalo koina siba, ‘Na Taubala, iya siliba andeledi ikalaiyako.’ ");
INSERT INTO tte_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kabo tomone lalakinane kainali iyamaisa iba, ‘Yawalo kolimiu, yaiya ipagan koina, kani Yaubada ietulan. Na yaiya nige ipapagan koina bwagana kikiuna imiyamiya koina Yaubada kani ikele-gabaen mowoi. ");
INSERT INTO tte_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na siya sikalomagigili koliyau yo nige nuwanuwali yaemala ali kin, kwalau wakalaili silaoma koliyau, kabo wakoyamateli mangu mena.’” ");
INSERT INTO tte_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yeisu ana walo iyemwawasi kabo ilalauyoi yakato ilau Yelusalema. ");
INSERT INTO tte_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yeisu me ana tobenaliyao silokelakubwamako kalo kikiuli labui kolili bwaimwa Bedipegi yo Bedani koya Olibe salina mena kabo tobenali labui iyawasa-bagunayagili. ");
INSERT INTO tte_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Iwalo yoli labuine kolili iba, “Kwalau kalone koina na manimiu mena ase yabo kani wagitai bwaimwa sipan-kalatan. Asene wauwau-bona nige yabo tomo imwamwalisae-tonan. Kwalivasi yo kwayoganama. ");
INSERT INTO tte_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tem tomo yabo iwalo kolimiu, ‘Tawae kaiwena asene kwalivalivasi?’, kabo kainana kwayamaisa bwaite besiele kwaba, Guyau nuwanuwana.” ");
INSERT INTO tte_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tobenali labuiwa siya iyawasaliwa silau yo silobai besiele Yeisu ana walo kolili. ");
INSERT INTO tte_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Saugana tobenaline asene silivalivasi ase tanuwagaliyao siwalo kolili siba, “Tawae kaiwena asene kwalivalivasi?” ");
INSERT INTO tte_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kabo tobenaliwone kainali siyamaisa siba, “Guyau nuwanuwana.” ");
INSERT INTO tte_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Asene sikalaiyama Yeisu koina, ali kaleko siyeseli pwatana mena kabo Yeisu sisagui sikele-mwaliseyan asene koina. ");
INSERT INTO tte_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ase mena ilaulau yo tomo tupwaliyao kali kwama siyeseli kamwasa mena. ");
INSERT INTO tte_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Saugana iyawatagilima koya Olibe salina mena kabo tomuliyayao siya boda lalakina siyatubu Yaubada sitobalan kainali lalakina mena kaiwena ginauli kaba nuwapwanopwano sibaibaiwa sigitailiko. ");
INSERT INTO tte_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Siba, “Osana. Yaubada iwalo-muloloi kinne iya ilaoma Guyau esana mena. Osana. Daumwali yo wasawasa bulibuli mena.” ");
INSERT INTO tte_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Palisi tupwaliyao siyaele bodane luwali mena nige siyayaliyaya tomuliyayao ali walo-tobali kaiweli kabo siwalolau Yeisu koina siwaloba, “Toyakayakatai, am tomuliyayao kuwalo simwanou.” ");
INSERT INTO tte_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yeisu kainali iyamaisa iba, “Na yawalo kolimiu, tem simiya-mwanou kani vekune meuloili siyoga.” ");
INSERT INTO tte_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yeisu Yelusalema ilokela-kubwai-yamako mwa saugana manna igabaen ilau igitai kabo me ana valam tawae kani iyawatagili Yelusalema tomiyayao kaiweli, ");
INSERT INTO tte_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","iba, “Tem komiu kaliyate kabona wakatai tem tawae waginauli yakato daumwali kwalobai inamwanamwa, na iyamo nige sowasowamiu wakatai kaiwena iwadam kolimiu. ");
INSERT INTO tte_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Na sauga ilalaoma kani kami tokalomagigiliwo silaoma sikaleya kolimiu, kabo simiya-takikilagimiu kani ami kaba lusae yo ami kaba yawatagili meuloina simiya-kausili. ");
INSERT INTO tte_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ami yanuwa kani sikele-gwaligwali yo sisibayanaeli, nige veku tupwa yabo imiyamiya dedeine koina yo kana tomiyayao siunuyamateli. Ginauli bwaite siya kani siyawatagili kaiwena Yaubada ilaoma nuwanuwana ileboimiu, na iyamo nige wakikilala.” ");
INSERT INTO tte_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yeisu ilusae Nume Tabu kalona mena yo togimwala kalona mena iyatubu itawoili siyawatagili. ");
INSERT INTO tte_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Iwalolau kolili iba, “Buki Tabu mena Yaubada ana walo silele iba, ‘Yagu nume esana kani sipei kaba kawanoi.’ Na komiu kwayapaisowa besiele tokewali ali gula kaba lowadam.” ");
INSERT INTO tte_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kaliyate kaigeda kaigeda Yeisu iyakayakatai Nume Tabu mena. Topwaoli lalakili yo loina kana toyakayakataiwo yo Yudiya tautaubalao simunamunai lalakina yo nuwanuwali siunui, ");
INSERT INTO tte_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","na nige sowasowana ginauli yabo siginauli koina, kaiwena tomo meuloili nuwali iyai ana yakayakatai kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Saugana Yeisu tomo iyakayakataili Nume Tabu mena yo tabe wasa namwanamwana iguguguguyeyan, kabo kaliyate yabo koina Yudiya toloinao siya topwaoli lalakili yo loina kana toyakayakataiwo yo tautaubalao silaoma koina sabi yokoiyanna, ");
INSERT INTO tte_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","siwaloba, “Yaiya ana loina mena kulaoma na togimwala kutawoili siyawatagili Nume Tabu mena? Yaiya ana loina mena kupaisowai besiele?” ");
INSERT INTO tte_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yeisu ikataiyako yakato sitonatonan na siyakewai ana edeedede koina kabo kainali iyamaisa iba, “Baguna bwaite yagu neli kaigeda kani yaeyawa kolimiu. ");
INSERT INTO tte_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Kita takataiyako Yoni Toyababitaiso tomo iyababitaisoli. Yagu neline bwaite besiele. Gubesi, yaiya ana loina koina Yoni Toyababitaiso ipaipaisowane, Yaubada ana loina koina o nuwana tomo ali loina kolili?” ");
INSERT INTO tte_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Toloinaone Yeisu ana neli sibenalan kabo siedeedede sibomamo kolili siba, “Tem tawaloba, ‘Yaubada ana loina koina’ kani Yeisu ineliyagilayoi kani iba, ‘Na tawae kaiwena mwa nige Yoni kwamemeliyan?’ Tem neline iwalowen kolila kani tamwalimwaline lalakina boda bwaitete manli mena kaiwena siya sikataiyako yakato Yoni tasikotanan. ");
INSERT INTO tte_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","O tem tawaloba, ‘Tomo ali loina kolili’ kani boda bwaitete silovekuila kaiwena ali nuwatu yakato Yoni iya palopita yabo yo ipaisowai besiele Yaubada ana loina koina.” ");
INSERT INTO tte_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mwa koina siba, “Nige kakakatai.” ");
INSERT INTO tte_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kabo Yeisu iba, “Tem nige sowasowamiu yagu neline kwayamaisa, yau besiele kani nige yawawalowen yaiya ana loina koina ginauliline bwaite yapaisowai.” ");
INSERT INTO tte_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Muli mena Yeisu walo kobwaibwaili bwaite iwalowen Yudiya toloinao yo tabe boda meuloili kolili iwaloba, “Taubala yabo ana tano ikumai wain bwagabwagamo. Kabo iwolegili tomo tupwaliyao kolili na siyapaisowa na wain maisana siwolena koina. Na iya ilau ilokeikeile dedei yabo koina sauga imamamalawe kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Na kelikeli kana sauga koina taubalane iya imiyamiya dedei yabo mena na ana topaisowa yabo iyawasa yakato ilau wain uwena maisana tupwana tano togitekalatanwo kolili ikalai ilawan iwolena koina. Na iyamo tano togitekalatanne topaisowane sikabikalatan yo sisapi mwa siyawasa-yapileyoi menimana. ");
INSERT INTO tte_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kabo taubalawa ana topaisowa labuina iyawasayoi kolili kabo kana kaleko silolo yo siunu-gwalagwalai mwa siyawasa-yapileyoi menimana. ");
INSERT INTO tte_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yo tabe yaiyonana iyawasayoi kolili yo topaisowane siunui kelepa mena yo mekwasikwasinena sitawoi ipileyoi. ");
INSERT INTO tte_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kabo taubalane iwaloba, ‘Kani tawae yaginauli? Natugu tauna yamulolo lalakina kani yayawasa, nuwana iya bwaite natugu kani siyakasisiyan.’ ");
INSERT INTO tte_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Na saugana togitekalatan taubalane natunane sigitai sibomayoi siedeedede kolili siba, ‘Iya tano tanuwagana natu yawasosina. Talau taunuyamate na kita tanone takalai ala tano.’ ");
INSERT INTO tte_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mwa sikabikalatan yo sigabae-yawatagilan ganamuli mena na siunuyamate.” Yo Yeisu ana edeedede iyemwawasi yo iwalo kolili iwaloba, “Tawae kani taubalane ipaisowai? ");
INSERT INTO tte_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Walo yawasosi, taubalane kani ilaoma togitekalatanne iunuyamateli yo tanone kani iwolena togitekalatan uloili kolili.” Saugana tomo walo bwaite sibenalan siba, “Tabu Yaubada igiginauli besiele.” ");
INSERT INTO tte_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yo Yeisu imankulakulaili yo iba, “Buki Tabu ana walo bwaite, ‘Baguna vekune tokabi nume sisikotanan na sauga bwaite Yaubada iyatoloyoi iyamala veku kaikaiwena yo veku meuloili iloinayagili.’ ");
INSERT INTO tte_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tem yaiya ibeku veku bwaite pwatana mena kani ikogaogaoli. Na tem veku bwaite ibeku tomo yabo pwatana mena kani ikomutumutu.” ");
INSERT INTO tte_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Saugana topwaoli lalakili yo loina kana toyakayakataiwo walo kobwaibwailine bwaite sibenalani, sikatai yakato siya kaiweli mwa iwalowalo, kobwaibwailine tano togitekalatan bwaimwa siya. Simunamunai kabo sauganane koina nuwanuwali Yeisu sikabi-kalatan na iyamo boda simatausagili kaiwena boda bwaite meuloili ali nuwatu yakato Yeisu iya palopita yabo. ");
INSERT INTO tte_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Toloinaone Yeisu sigitagitai kabo tomo tupwaliyao siyawasali koina na sineli mwakota mena gubesina Yeisu kaba yakewaina yabo siginauli na siwalo-masalan Pailato koina kaiwena nuwanuwali Yeisu siyatalayan. ");
INSERT INTO tte_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kabo tomone silau Yeisu koina sitobali-mwakomwakota siba, “Toyakayakatai, kakatai yakato sauga meuloina kuwalo yawasosi yo am yakayakatai Yaubada ana kamwasa kaiwena idudulai. Yo tabe nige tomo yabo kumamatausan, bwagana tosonosonoga o nuwana towasawasa na iyamo nige ugogolulau kolili. ");
INSERT INTO tte_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Gubesi, sowasowana Sisa kaiwena takesi tapei o nigele?” ");
INSERT INTO tte_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yeisu ikataiyako yakato siya nuwanuwali Sisa kana kawa-naenae sibenalan na ana walone siwalo-masalan toloinao kolili na tem siyakewai kabo iba, ");
INSERT INTO tte_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mane siliba wakalaiyama kwayakenayagau.” Mwa sikalaiyama yo siyakenayan kabo ineliyagili iba, “Yaiya makamakayauna yo tabe yaiya esana silele manene koina?” Siwalolau koina siba, “Sisa.” ");
INSERT INTO tte_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yo Yeisu iwalo kolili iba, “Ginauline siya Sisa ana gogo kwaolena Sisa koina na ginauline siya Yaubada ana gogo kwaolena Yaubada koina.” ");
INSERT INTO tte_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Saugana ana walo sibenalan kateli sipitali, nige sowasowali ana lopwano silobai tomo manli mena kabo simwanou. ");
INSERT INTO tte_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tabe Sadusi tupwaliyao silaoma Yeisu koina. Na Sadusi ali nuwatu yakato nige toloyoi yaboyoi, ");
INSERT INTO tte_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","mwa Yeisu sineliyani siba, “Toyakayakatai, Mosese iwalo tem tomo yabo ikasole nige natunao na iboita kani kanakava yawasosi ilaoma yo kanakavane kwabukwabulina ikasolanan na tem natunao ipagan siya melumeluwone siyamala kanakavane boiboitanane iya natunao. ");
INSERT INTO tte_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Na bwaite kaba gite yabo. Tomo yabo mekanakavao yoli seben, tobagubaguna ikasole nige natunao na iboita, ");
INSERT INTO tte_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","kabo kwabukwabulina kanakava ikasolanan. Besiele kaigedana iyawatagili kanakava labuina koina besiele yaiyonana koina yo besiele meuloiline kolili paganne silobai. ");
INSERT INTO tte_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ana kaba mwawasi sinewa iboita. ");
INSERT INTO tte_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tem yawasosi toboita kani sitoloyoi, ali toloyoine koina yoli seben luwali mena yaiya iya wainena yawasosi, kaiwena meuloiliwa sikasolanan?” ");
INSERT INTO tte_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yeisu kainali iyamaisa iwaloba, “Sauga bwaite koina tomo sikasole, ");
INSERT INTO tte_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","na siya Yaubada ikawa-namwanamwa-yagili yo sitoloyoi nige kasoleyoi, ");
INSERT INTO tte_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","kaiwena nige sowana siboitayoi. Sitoyatoyawa aneloseyao kolili yo Yaubada natunao kaiwena sitoloyoiko. ");
INSERT INTO tte_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mosese iyakenayagila yakato toloyoi ipagan kaiwena mayau kalapulupululuna edeededena koina Mosese iwalo Yeoba koina iba, ‘Kowa Abelamo, Aisake yo Yakobo ali Yaubada.’ Bwagana siboitako yoli yaiyonane siyaele bulibuli mena meyawasili. ");
INSERT INTO tte_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mwa koina Yaubada nige tomo boiboitali ali Yaubada, siya tomo meyawasili ali Yaubada.” ");
INSERT INTO tte_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kabo loina kana toyakayakatai tupwaliyao siya toloyoi walona sikawa-namwanamwayan siwaloba, “Toyakayakatai am walo idudulai”. ");
INSERT INTO tte_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kabo Sadusiyao yo tabe toloinao meuloili nige nuwanuwali neli yaboyoi sineliyan kisi simwalimwaline. ");
INSERT INTO tte_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yeisu iwalolau bodane sitotolo salina mena kolili iwaloba, “Gubesi na Yudiya toloinao siwalo yakato Mesaiya iya besiele tomo molosi na naga iya kani ilaomaya Deibida kana mumuga kalona mena? ");
INSERT INTO tte_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Na Deibida ana nuwatu nige besiele kaiwena ana Same koina iwaloba, ‘Yeoba Yaubada iwalo yagu Guyau koina, ulaulagu mena kumiyasio, ");
INSERT INTO tte_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kanasiga kam tokaleyayao yapeili kaekaem yaulina mena.’ ");
INSERT INTO tte_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tem toloinao ali nuwatu idudulai Mesaiya kaiwena kani Deibida Mesaiya ikawa-tubu-wan na iyamo nigele. Ikawa-Guyau-wan besiele talobai ana Same Buki Tabu mena.” ");
INSERT INTO tte_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Saugana tomo meuloili ana yakayakatai sibenabenalan Yeisu iwalo ana tomuliyayao kolili iba, ");
INSERT INTO tte_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Wagite-kalatagimiu loina kana toyakayakataiwo kaiweli. Kaiwena gagasa mena silaoma kwama malamalawena siluwuili silolokeikeile kaba gimwala kolili na mesabana tomo sigitaili na sikawatoki kolili. Yo yaboyoi nuwanuwali kaba miya namwanamwali nume tapwalolo kolili yo besiele soi kali sauga koina nuwanuwali simiya-baguna tomo manli mena kali yakasisi kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yo tabe kwabukwabuliwo ali nume sikalaili mwakota mena. Kabo muli mena silau sitapwalolo yo ali kawanoi simamalawe na mesabana tomo ali nuwatu yakato siya todudulai. Na nigele, naga Yaubada maisa polopolowena iwolegili.” ");
INSERT INTO tte_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yeisu igitai towasawasao silaolaoma Nume Tabu koina ali mulolo mane sipeipeili mulolo kaba peina koina. ");
INSERT INTO tte_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Yo tabe igitai kwabukwabuli iya tobubutuma yabo ana mulolo pene kikiuli labuimo ipeili. ");
INSERT INTO tte_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kabo Yeisu iwaloba, “Yawalo yawasosi kolimiu, Yaubada manna mena, kwabukwabuli bwaine ana mulolo, meuloili ali mulolo ilalaki-gabaegili. ");
INSERT INTO tte_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kaiwena meuloili ali tupwa lalakili simiyamiya na bwaite kwabukwabuline iya tobubutuma yo ana mane meuloina ipei yo nige yaboyoi ana tupwa imiyamiya na koina kana igimwala.” ");
INSERT INTO tte_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tobenaliyao tupwali Nume Tabu kana koleya namwanamwana sigitai mwa Yeisu siyakenayan yo siwalo siba, “Taubala, Nume Tabune kana pasao kali koleya sinamwanamwasosi kaiwena veku lalakili kolili sikabili na tabe tomo ali mulolo namwanamwali kolili siyapasali.” ");
INSERT INTO tte_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Kabo Yeisu kainali iyamaisa iwaloba, “Sauga ilalaoma koina ginauline wagitagitailine kani meuloili sitatagwaligwali yo nige sowasowana veku yaboyoi itupwa ana kaba miya mena imiyamiya wagitaiyoi.” ");
INSERT INTO tte_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mwa sineliyani siba, “Toyakayakatai, toisabo sauga koina ginauline kuwalowalowegiline kani siyawatagilima? Toisabo kilakilala kani kagitai na kakatai ginauline kani kikiunamo siyawatagili?” ");
INSERT INTO tte_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Kabo Yeisu iwalo kolili iwaloba, “Sauganane koina kani tomo sibaibaiwa esagu mena silaoma na kaigeda kaigeda iwaloba, ‘Yau Mesaiya’ yo ‘Sauga ilaomako.’ Na wagitekalatagimiu, kisimo tomo simwakota-yagimiu. Tabu kwamumuliya kolili. ");
INSERT INTO tte_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yo sauganane koina tabe kani wasa kwabenalagili kaleya yo talawauwau lalakili. Tabu kwamamatausi yo tabu wakakatewakaka kaiwena ginauli bwaitete kani siyawatagili baguna, kabo muli mena yanuwa yaulina ana kaba mwawasi iyawatagili. ");
INSERT INTO tte_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Boda yo boda kani sikaleya yo tabe yaboyoi kaba loina yo kaba loina kani sikaleya. ");
INSERT INTO tte_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mwanikiniki lalakili yo guliyam lalakili yo muya lalakili kani siyawatagili dedei meuloili kolili. Yo ginauli kaba matamatausi yo kilakilala bulibuli mena kani siyawatagili tabe. ");
INSERT INTO tte_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Na baguna kani tomo sikabi-kalatagimiu yo siyakamkamnamiu yo silawagimiu nume tapwalolo yo nume pan kolili yatala kaiwena. Kaiwena komiu kwameliyagau kani sikalaimiu yo silawagimiu siyatolomiu toloinao yo kinyao manli mena. ");
INSERT INTO tte_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Sauganane koina sowasowana wasa namwanamwana kwayawasayan kolili. ");
INSERT INTO tte_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tabu kwanuwanuwatu ali yakewaimiu kaiwena yo tabe ali walo kolimiu kaiwena, ");
INSERT INTO tte_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kaiwena sonoga yo ami walo kani yaeliwa kabo kami tokalomagigili nige sowana sikawa-mwakomwakota-yagimiu. ");
INSERT INTO tte_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Yo kani ami susuyao, nuwana tamamiyao, sinamiyao, kamikavao yo dumiyao yo ami eliyamwao siwalo-masalagimiu toloinao kolili. Yo tupwamiyao kani siunuyamatemiu. ");
INSERT INTO tte_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yo tomo meuloili kani sikalomagigi-lagimiu kaiwena komiu kagu tomeliwo. ");
INSERT INTO tte_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Na iyamo nige sowasowana itomiu kaigeda ikwalalele. ");
INSERT INTO tte_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Na tem me ami kalakisiye yo kwatolo kaiwe kani yawasimiu kwalobai.” ");
INSERT INTO tte_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yeisu iwaloyoi iba, “Na saugana wagitai tokaleyayao yanuwa Yelusalema siyatakikilan kabo wakatai yanuwane kani kikiunamo sisibayanae. ");
INSERT INTO tte_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Bwaine sauganane koina Yudiya dedeina kana tomiya meuloili ilonamwayagili siyabubu koya kolili. Yo siya simiyamiya Yelusalema taon kalona mena ilonamwayagili silogabaen. Yo siya Yelusalema gana muli mena tabu silulusae. ");
INSERT INTO tte_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kaiwena sauganane koina Yaubada ana sauga gum yai Buki Tabu iwalo-masalanako kani iyamala yawasosi. ");
INSERT INTO tte_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ooo. Yawasosi yakatekamkamna-yagili siya tosiumao yo toyasuyasusuwo kaiweli, kani ikololososi kolili sauganane koina. Kaiwena kamkamna lalakina kani iyawatagili dedeinane koina yo tomo Yudiya bwaitete kani sikamkamna, ");
INSERT INTO tte_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","yo siboita kaleya kelepana mena. Siya nige siboboita kani sipanili yo silawagili dedei uloi uloi kolili me kali pan. Siya nige tomo Yudiya kani silaoma na Yelusalema sisibayanae yo dedeinane siutumutumutu molosan kanasiga ali loinane kana sauga imwawasi.” ");
INSERT INTO tte_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Sauganane koina kani kilakilala siyawatagili dabwelo, waikena yo utu kolili. Yo yanuwa yaulina mena tomo meuloili kani sikatewakaka kaiwena kani kalita iyokoyokososi yo dibwali yo bagolu balamumuliyao kani silalakisosi. ");
INSERT INTO tte_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tomo meuloili kani simatausi yo mankaluwa isaeili yo yoli siwelai yo sisawosawowoli saugana sisanasana tawae kani iyawatagili yanuwa yaulina mena. Yo tabe ginauli meuloili bulibuli mena Yaubada kani inukuili. ");
INSERT INTO tte_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kabo tomo kani sigitai Tomo Natuna ilalaoma yaloyaloi mena, me ana kaiwe yo me ana wasawasa lalakina. ");
INSERT INTO tte_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na saugana ginauliline bwaite siyatubu siyawatagili kwatolo kaiwe yo wakatepatu kaiwena ami lebo kikiunamo kwalobai.” ");
INSERT INTO tte_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kabo kaba gite bwaite iwalowen iba, “Tem saido yo mayau meuloili tagitaili, ");
INSERT INTO tte_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","yo liguli waluwaluli sikin takatai yaikin kana sauga ikelakubwamako. ");
INSERT INTO tte_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yo tabe besiele saugana tem ginauli meuloina yawawalowegiline wagitaili siyawatagili, wakatai Yaubada ana kaba loina ikelakubwa-olimako. ");
INSERT INTO tte_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Yawalo yawasosi kolimiu, ginauli meuloiline yawawalowegiline kani siyawatagili kabo muli mena yasone bwaite imwawasi. ");
INSERT INTO tte_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Naga bulibuli yo yanuwa yaulina simwawasi na iyamo yagu walo kani nige sowana imwawasi. ");
INSERT INTO tte_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Na wagite-kalatagimiu tabu numa yauyaule yo tabu katemiu yanuwa yaulina kana polowe kolili siloloyapowonli kisi yaluyaluwamiyao sikabi-yabeluli. Tem mumugamiu besiele kani Tomo Natuna katemiu iyapitali ana yawatagili kaliyatenane koina besiele yakayakan sokasokali ali beku sipwasipwa kalona mena. ");
INSERT INTO tte_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kaiwena tomo meuloili simiyamiya dedei meuloili kolili yanuwa yaulina mena kani kateliyao sipitali. ");
INSERT INTO tte_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kabo tabu miya bwagabwaga, sauga meuloina wagitekalatagimiu yo wakawakawanoi yakato me ami meli kaikaiwena na tabu ginauli naenaeline siyayawatagili kolimiu. Wakawanoi ami meli ikaiwe na mesabana kwatolo Tomo Natuna manna mena.” ");
INSERT INTO tte_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kaliyate kaigeda kaigeda Yeisu iyakayakatai Nume Tabu mena. Iboniyai kabo ilau ikeno koya Olibe koina. ");
INSERT INTO tte_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Malala kikiuna tomo meuloili silogogoyoima Nume Tabu koina na ana yakayakatai sibenalanyoi. ");
INSERT INTO tte_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na mwalelikwa soina kana nuwatu-kalatan kana sauga iyawatagilimako. Soine esana labuina pwalawa gaibumo nige kana ebweli. ");
INSERT INTO tte_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Topwaoli lalakili yo loina kana toyakayakataiwo kamwasa siloyaloyai tem gubesi na wadam mena Yeisu sikabikalatan na siunuyamate, kaiwena tomo simatausagili. ");
INSERT INTO tte_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kabo Seitani ilusae Yudasa Isikaliota koina, iya yabo yoli tuwelone kolili, ");
INSERT INTO tte_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ilau topwaoli lalakili yo Nume Tabu kana pilisiman ali tobagunao kolili na mekanakavao siedeedede gubesina Yeisu iwalo-masalan kolili. ");
INSERT INTO tte_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yo ana walo kaiwena siyaliyaya na siwaloyameli yakato maisana mane siwolena. ");
INSERT INTO tte_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Mwa Yudasa italam kabo sauga namwanamwana isanai na wadam mena Yeisu italamwan kolili na sikabikalatan. ");
INSERT INTO tte_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Beledi gaibumo nige ebwelina soina kana kaliyate iyawatagilima yo bwaine koina lamiyao siunuili mwalelikwa kanna kana nuwatu-kalatan kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kabo Yeisu iwalo Pita te Yoni kolili iba, “Kwalau yo mwalelikwa soina wakatububun kaiwela na takekan.” ");
INSERT INTO tte_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Siwalo koina siba, “Toweya nuwanuwam kakatububun?” ");
INSERT INTO tte_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kabo iwalo kolili iba, “Kwalusae Yelusalema kabo tomo yabo waila patu ikalakalai kani ilobaimiu. Na tomone kwayamulikusuli yo mekamikava kwalusae nume mena, ");
INSERT INTO tte_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","yo nume tanuwagana koina kwawalo bwaite besiele. ‘Toyakayakatai iwawalo yakato toisabo biliutusi kutalamwan na meyagu tobenaliyao mwalelikwa soina kanna kakatububun na kakekan?’ ");
INSERT INTO tte_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kani iyakenayagimiu biliutusi lalakina kewa mena sikatububunanako. Na bwaine koina mwalelikwa kanna wakatububun kaiwela.” ");
INSERT INTO tte_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kabo yoli labuine silau Yelusalema koina silusae, yo tawae besiele Yeisu iwalo-masalan kolili ginauli meuloili silobaili. Mwa numewa koina mwalelikwa kanna sikatububun kaiweli. ");
INSERT INTO tte_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kekan kana sauga koina Yeisu imiyasio teibeline koina me ana tobenaliyao. ");
INSERT INTO tte_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yo iwalo kolili iba, “Nuwanuwagu lalakina tem kekan bwaite takekan toyawa kabo muli mena yakamkamna. ");
INSERT INTO tte_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yawalo yawasosi kolimiu, kani nige yakekekanyoi kanasiga Yaubada ana kaba loina ilaoma kabo mwalelikwa soina kana dudulai iyawatagili yawasosi.” ");
INSERT INTO tte_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kabo wain mekomwana ikalai yo kaiwena ikawatoki Yaubada koina kabo iba, “Wakalai bwaite yo kwayauyan kolimiu, ");
INSERT INTO tte_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","kaiwena yawalo kolimiu, sauga bwaite yo sauga muli mena wain bwaite nige sowasowana koina yanumayoi kanasiga Yaubada ana kaba loina iyawatagilima.” ");
INSERT INTO tte_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yo pwalawa ikalai yo ikawatoki Yaubada koina. Imwawasi ikivi yo iwolegili ana tobenaliyao kolili iba, “Bwaitete yogu yaeyawa kaiwemiu. Waginauli besiele yakato ami kaba nuwatu-kalatagau.” ");
INSERT INTO tte_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Besiele tabe kekan mulina mena komwane ikalai yo iwolena kolili iba, “Komwane bwaitete kamwasa waluwaluna iya kwasinegu kani ididi kaiwemiu. ");
INSERT INTO tte_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Na kagu tokalomagigili iyaele mekalakava teibeli mena yo nimana iyaele nimagu salina mena. ");
INSERT INTO tte_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tomo Natuna kani ilau boita mena besiele Yaubada ana nuwatu, na iyamo kana tokalomagigiline kani katekamkamnana.” ");
INSERT INTO tte_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kabo tobenaliyao siyatubu sienelineli-yagili sibomayoi kolili yaiya tokalomagigiline. ");
INSERT INTO tte_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tobenaliyao siyatubu sigamwagamwa-pakiki tem gubesi na yaiya esana ilalakisosi kolili. ");
INSERT INTO tte_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kabo Yeisu iwalo kolili iba, “Siya nige Yudiya ali kinyao mumugali bwaite besiele. Me ali nuwasaesae siloina kaiwe yakato tomo meuloili ali walo sibenalagili yo siyakasisiyagili. ");
INSERT INTO tte_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Na komiu tabu mumugane wagiginauli besiele. Na yaiya kowa nuwanuwam esam ilalaki ilonamwayagiwo kuyamala besiele tomulimuliya. Na tem yaiya kowa nuwanuwam kuyamala tobaguna ilonamwayagiwo kuyamala topaisowa. ");
INSERT INTO tte_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yaiya esana ilalakisosi, iya imiyasio teibeli mena o iya topaisowane? Tomiyasione esana ilalakisosi, wa? Na yau yamiyamiya luwamiu mena na yaemala topaisowa kaiwemiu. ");
INSERT INTO tte_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Saugana kamkamna yalobailiko komiu mekaukavao, ");
INSERT INTO tte_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","yo besiele Tamagu iginauliyako kaiwegu, kabo kaba loina yabo kani yaeyawa kolimiu, ");
INSERT INTO tte_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","na mesabana esamiyao silalaki yagu kaba loina koina, bwaine koina kani wakekan yo kwanuma yagu teibeli koina yo kwamiyasio kaba miya wasawasali kolili na Isileli bodaliyao yoli tuwelo kwayatalayagili.” ");
INSERT INTO tte_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yeisu iwaloyoi iba, “Saimon, Saimon, Seitani ilaomako Yaubada ana talam ikalai na tem inukuimiu besiele topaisowa yabo tano witi kanna inukui na tem iyakasali mosomosoliyao ikelegabaegili. ");
INSERT INTO tte_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Na yau yakawanoiko Yaubada koina kaiwem tem tabu am meli ibebelu. Na sauga ilalaoma kani kunuwabui koliyau, na kamkavao ukwabi-yakaiweli.” ");
INSERT INTO tte_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pita Yeisu kainana iyamaisa iba, “Guyau, yatalamwagau mekaukava kowa talau nume pan mena yo mekaukava kowa taboita.” ");
INSERT INTO tte_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yeisu iwalo koina iba, “Pita, yawalo yawasosi koliwo, kansiga boniyai muliya kabo kamkam tauna ivalam kani kuuvalayagau meyaiyona, kani kuba, ‘Tomone bwaite nige yakakatai.’” ");
INSERT INTO tte_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kabo ineli ana tobenaliyao kolili iba, “Sauga beyabeyana koina yayawasamiu kwayawatagili yo nige ami mane kana tobwa, o tem kami kaleko kana tobwa o tem kaemiu kana suma kwalolokalaili. Gubesi, sauganane koina ginauli yabo kwadeva koina?” Kainana siyamaisa siwaloba, “Nigele”. ");
INSERT INTO tte_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mwa iwalo kolili iba, “Na sauga bwaitete tem ami mane kana tobwa o tem kami kaleko kana tobwa imiyamiya, kwalokalaili. Na tem nige ami kaleya kelepana ipapagan, kami kwama tulutulu kaiwena wagimwala-yani na manena wakalai yo kaleya kelepana yabo wagimwalai wakalai kabo kami koleya besiele kaleya lalakina kana toyatubu. ");
INSERT INTO tte_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kwapaisowai besiele yagu walo na mesabana Buki Tabu ana walo iyamala yawasosi iba, ‘Tomo kani siwalo yakato Mesaiya imiyamiya kaleya lalakina kana toyatubu ali boda koina.’ Na yawalo kolimiu kani tomo sipaisowai koliyau yakato yau kaleya lalakina kana toyatubu na mesabana ginauli meuloina bwaite sileleyako kaiwegu Buki Tabu mena kani kikiunamo iyamala walo yawasosi.” ");
INSERT INTO tte_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tobenaliyao siwalo koina siba, “Guyau, ugitai kaleya kelepana labui siyaele kolimai.” Mwa kainali iyamaisa iba, “Sowasowana.” ");
INSERT INTO tte_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yeisu iyawatagili yo ilau koya Olibe koina besiele mumugana. Ana tobenaliyao siyamuli-kusuli. ");
INSERT INTO tte_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Yo saugana iyawatagili dedeinane koina iwalo kolili iba, “Wakawanoi Yaubada koina na tabu kwabebeku woya koina.” ");
INSERT INTO tte_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Yo ilogabaegili ilau tupwana kana mwayaga iyai, yo tutulina italu-sakonayan yo ikawanoi. ");
INSERT INTO tte_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Iba, “Tamagu, tem am nuwatu besiele, kamkamna komwana bwaite ukwele-gabaen koliyau, na tabu yau yagu nuwatu mena, na kowa am nuwatu mena uginauli.” ");
INSERT INTO tte_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kabo anelose yabo ilobimaya bulibuli mena iyawatagili koina yo ikabiyakaiwe. ");
INSERT INTO tte_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yeisu yaluyaluwana ipolowesosi, kabo ikawanoi kaikaiwe, na kamweyaina ididi bwatano mena besiele kwasine ididididi. ");
INSERT INTO tte_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yo saugana itolo kawanoi koina, ipileyoiwa ana tobenaliyao kolili ilobaili nuwanae kaiwena sikenomate. ");
INSERT INTO tte_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kabo iwalo kolili iba, “Tawae kaiwena wakenokeno? Kwatolo yo wakawakawanoi na tabu kwabebeku woya koina.” ");
INSERT INTO tte_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yeisu iyaelemo iedeedede kabo boda yabo siyawatagilima na Yudasa Isikaliota iya yoli tuwelo yabo, kamwasane koina ibagunayagili. Ilaoma Yeisu manna mena yakato Yeisu inisoi, ");
INSERT INTO tte_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","na Yeisu iwalo koina iba, “Yudasa, nuwanuwam kunisoiyau yakato Tomo Natuna kuwalo-masalan?” ");
INSERT INTO tte_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kabo saugana ana tobenaliyao sigitai tawae kani iyawatagili siba, “Guyau, gubesi, takaleya ala kaleya kelepana kolili?” ");
INSERT INTO tte_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yo tobenali yabo topwaoli lalakina ana topaisowa tenana ulaulana ikoutusi. ");
INSERT INTO tte_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Na Yeisu iba, “Besi.” Kabo topaisowane tenana ikabitonan yo iwoisi. ");
INSERT INTO tte_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","53","Na bodane siya silaoma na Yeisu sikabikalatan kaloli mena topwaoli lalakili yo Nume Tabu kana pilisiman ali tobagunao yo Yudiya ali tautaubalao. Kabo Yeisu iwalo kolili iba, “Kaliyate sibaibaiwa mekaukavao komiu Nume Tabu koina yamiyasio yo yayakayakatai, na nige wakakabi-kalatagau. Na bwaite sauga gubesi? Kwalaoma me ami kaleya kelepana yo me ami kule na wakabi-kalatagau yakato yau kaleya lalakina kana toyatubu? Sauga bwaite koina komiu boniboniyai bodaliyao ami sauga loina.” ");
INSERT INTO tte_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kabo sikabikalatan yo silawan siluseyan topwaoli lalakina ana nume mena. Pita iyamuli-kusulili kana mwayaga iyai. ");
INSERT INTO tte_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yo saugana mayau sipei iwedowedoli numene kana gana kalona mena Pita imiyasio mekanakavao. ");
INSERT INTO tte_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kabo topaisowa gamasine yabo Pita igitai imiyasio mayaune koina, imankulakulai yo iba, “Tomone bwaine Yeisu ana boda yabo.” ");
INSERT INTO tte_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Na Pita iuvalayan iwaloba, “Gamasine, tomone bwaimwa nige yakakatai.” ");
INSERT INTO tte_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nige sauga imamamalawe na tomo yabo ilaoma Pita igitai yo iwalo koina iba, “Kowa ali boda yabo.” Na Pita iba, “Taubala, yau nigele.” ");
INSERT INTO tte_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Sauga tupwana imamalawe besiele wan awa mulina mena tomo yaboyoi ilaoma igitai yo iba, “Walo yawasosi tomone bwaite Yeisu mekanakava kaiwena iya game Galili tabe.” ");
INSERT INTO tte_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Na Pita iba, “Taubala, nige yakakatai tawae kuwalowalowen.” Pita iyaele iedeedede kabo sauganane koina kamkam tauna ivalam. ");
INSERT INTO tte_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yo Yeisu itagelakeile yo Pita imankulakulai. Kabo Pita Yeisu ana walo nuwana mena isae saugana Yeisu iba, “Kansiga boniyai muliya kabo kamkam tauna ivalam kani kuuvalayagau meyaiyona.” ");
INSERT INTO tte_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kabo Pita numene kana gana ilogabaen ikaisulu iyawatagili bakubaku mena yo me ana nuwanae ivalam. ");
INSERT INTO tte_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na tomone siya Yeisu sikabikabi-kalatan na sitalatalawasi-yani yo siunuunui, ");
INSERT INTO tte_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","yo kaleko sikalai manna sisuma-kausili siunuiyoi kabo siwalo koina siba, “Tem kowa palopita yabo kuwalo kolimai yaiya iunuiwo.” ");
INSERT INTO tte_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Yo walo polopoloweli sibaibaiwa siwalowegili koina yo sikawa-naenae-yani. ");
INSERT INTO tte_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Yanuwa ilayan kabo Yudiya tautaubalao meuloili bwaimwa topwaoli lalakili yo loina kana toyakayakataiwo silogogoma. Kabo Yeisu silawan ali logogone koina. ");
INSERT INTO tte_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Siwalo koina siba, “Tem kowa Mesaiya ama wasa kuyeyama kolimai.” Na iwalo kolili iba, “Tem ami wasa yaeyawa, kani nige yagu walo kwamemeliyan, ");
INSERT INTO tte_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","yo tem yaneliyagimiu kani nige kainagu kwayayamaisa. ");
INSERT INTO tte_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Na bwaite sauga yo sauga ilalaoma koina kani Tomo Natuna imiyasio Yaubada Tokaiwesosi ulaulana mena.” ");
INSERT INTO tte_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kabo meuloili sineliyan siba, “Yakato kowa Yaubada Natuna?” Yo iwalo kolili iba, “Iyaele bwaimwa komiu kwabomayoi kwawalowenako.” ");
INSERT INTO tte_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mwa siba, “Besi, kani nige tomo taloloyaiyoili na silaoma siedeedede kaiwena. Kawasewane iwalowenako sopana mena na kita tabenalanako.” ");
INSERT INTO tte_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ali logogo imwawasi kabo Yudiya tautaubalao meuloili sitolo yo Yeisu silawan ali gavana Pailato koina, iya Loma tomona Sisa ipei Yudiya dedeina meuloina iloiloinayan. ");
INSERT INTO tte_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Yo siyatubu Yeisu siyakeyakewai Pailato manna mena siba, “Tomone bwaite kalobai tomo meuloili iyakatai-yanaeli. Iwalo tabu Sisa ana takesi siyayamaisa. Yo tabe iwaloyoi yakato iya ibomayoi Mesaiya yo kin yabo.” ");
INSERT INTO tte_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mwa Pailato ineli koina iba, “Gubesi, kowa Yudiya ali kin o nigele?” Yeisu kainana iyamaisa iba, “O, besiele am walo.” ");
INSERT INTO tte_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kabo Pailato itagelakeile topwaoli lalakili yo bodane igitaili yo iwalo kolili iba, “Nige loina yabo ililikwai na tem yakawa-naenae-yani.” ");
INSERT INTO tte_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Na sisamasamalulu siba, “Tomo meuloili Yudiya dedeina mena iula-munamunaili ana yakayakatai koina. Iyatubu Galili dedeina mena kabo muli mena ilaoma bwaite koina.” ");
INSERT INTO tte_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ali edeedede Pailato ibenalagili mwa ineli kolili iba, “Nuwana tomone bwaite Galili tomona?” Kabo kainana siyamaisa siba, “O, besiele.” ");
INSERT INTO tte_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Saugana Pailato ikatai yakato Yeisu ilaomaya Galili bwaimwa Elodi ana kaba loina mena kabo iyawasa ilau Elodi koina. Na sauganane Elodi iya iyaele Yelusalema koina. ");
INSERT INTO tte_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Na Elodi Yeisu igitai kabo iyaliyaya lalakina, kaiwena wasana ibenalanako yo sauga imamalawe nuwanuwana tem igitai. Na nuwanuwana ginauli kaba nuwapwanopwano tupwaliyao Yeisu ipaisowaili na igitaili. ");
INSERT INTO tte_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kabo neli sibaibaiwa ineliyagili Yeisu koina na nige kainana iyayamaisa. ");
INSERT INTO tte_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Topwaoli lalakili yo loina kana toyakayakataiwo sitotolo salina mena kabo siyakewa-tupatupai. ");
INSERT INTO tte_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Elodi mekanakavao tokaleyayao Yeisu sitalawasiyan yo simalumaluwan. Kabo kaleko mamalawena kana saba namwanamwasosina sikalai siyalikwa, kabo siyawasa-yapileyoi ilau Pailato koina. ");
INSERT INTO tte_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na kaliyatenane koina Elodi mekanakava Pailato sikelabilabin toyawa yo sikawa elieliyam tabe, na beyabeyana mekanakava siekalokalo-magigi-lagili. ");
INSERT INTO tte_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailato topwaoli lalakili, toloinao yo tomo meuloili iyoga-gogonagilima, ");
INSERT INTO tte_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","mwa iwalo kolili iba, “Tomone bwaite wakalaiyama koliyau yo kwawalo yakato tomo meuloili iyakatai-yanaeli. Na manimiu mena yaneli namwanamwaiyako na yalobai nige loina yabo ililikwai yakato yakawa-naenae-yani. ");
INSERT INTO tte_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Elodi tabe iya besiele nige yakewane yaina yabo ilolobai, kabo bwaite iya kaiwena mwa iyawasa-yapileyoiyama kolila. Ee na wagitai, nige ginauli yabo igiginauli-yanae na yakato kaiwena iboita. ");
INSERT INTO tte_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Koinaele kani yawalo tokaleyayao sikabi-kalatan siunui balae mena, kabo silivasi ilau.” ");
INSERT INTO tte_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Na Pailato mumugana bwaite besiele, bolime kaigeda kaigeda, mwalelikwa soina kana sauga koina, tolusae deli yabo iya tem Yudiya sigitesipwai sikawanoiyan, Pailato kani ilivasi yo iyawatagili deli mena. ");
INSERT INTO tte_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Na boda lalakina meuloili siyoga kainali lalakina mena siba, “Tomo bwaimwana kuunuyamate na Balabasi kulivasi kaiwemai.” ");
INSERT INTO tte_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Na sauganane koina tomo yabo imiyamiya deli mena esana Balabasi, iya sipei-gabaen kaiwena tauna kona tomo yabo iunuyamate yo iya kaleya lalakina kana toyatubu Yelusalema taon koina. ");
INSERT INTO tte_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailato nuwanuwana Yeisu ilivasi kabo iedeedede yoi bodane kolili. ");
INSERT INTO tte_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Na siyogayoga siba, “Kuyakelose. Kuyakelose.” ");
INSERT INTO tte_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kabo iwaloyoi kolili iba, “Tawae kaiwena? Tomone tawae ana nae? Nige yaina yabo yalolobai na tem iboita, nuwanuwagu tem yasapi mowoi na yalivasi ilau.” ");
INSERT INTO tte_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Na sisikote kaikaiwe yo siyogayoga kainali lalakina mena siba, “Kuyakelose. Kuyakelose.” Kabo bodane ali yoga-samasamalulu kaiwena mwa Pailato nuwana sikoi. ");
INSERT INTO tte_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","25","Kabo iwalo ana tokaleyayao kolili Yeisu siyakelose besiele bodane ali nuwatu. Na iya Balabasi sikawanoiyan, bwaimwa iya tounuyamate tauna kona sipei-gabaen deli mena kaiwena iya kaleya lalakina kana toyatubu, ilivasi-gabaen yo ilau. ");
INSERT INTO tte_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tokaleyayao Yeisu sikabikalatan siyogan silawan sabi yakelosena kaiwena. Kabo tomo yabo silobai game Sailini esana Saimoni ilaomaya gana muli mena ilulusae Yelusalema kaiwena kabo sikabikalatan yo siyadidiga mwa Yeisu kana kelose siwolena Saimoni ikewai leyaleyana mena Yeisu siyabaguna Saimoni mulina mena silau. ");
INSERT INTO tte_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tomo boda lalakina Yeisu siyamuli kusuli, luwali mena sinesineo tupwaliyao siya sivalavalam koyasili Yeisu kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yeisu itagelakeikeile yo iwalo kolili iba, “Yelusalema sinesineoliyao, tabu kaiwegu kwavavalam na kwabomayoi kaiwemiu yo natumiyao kaiweli kwavalam. ");
INSERT INTO tte_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kaiwena sauga ilalaoma kani nae lalakina iyawatagili yo tomo kani siwaloba, ‘Sinesineo siya miyamiya yaili siya sinamwanamwa, kaiwena nige natuliyao sikakabili yo nige siyayasuyasusu.’ ");
INSERT INTO tte_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mwa sauganane koina kani tomo kamkamna lalakina polowena silotonan kabo siwalo koya kolili siwaloba, ‘Wagunaima pwatamai mena yo wakopwaikimai mwayamwayau kaboita.’ ");
INSERT INTO tte_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mayau kilaina tagabu kalapulupululuna nige ikakaiwe na tem mayau leleyanna tagabu kani kalapulupululuna ikaiwesosi. Walo yawasosi yau kani yasilae na komiu naga kwasilae yawasosi kaiwena yau besiele mayau kilakilaina na komiu besiele mayau leleyanna.” ");
INSERT INTO tte_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tomo labui tabe siya nae kana toginauli, tokaleyayao siyoganli yo mekalikava Yeisu na siyakeloseli. ");
INSERT INTO tte_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Saugana silau siyawatagili yanuwa esana siba Kulukulu Yanuwana, kabo Yeisu siyakelose koina, mekanakavao toloinalikwa yoli labuine, yabo kana kelose siyatolo dedei ulaulana mena yo yabo dedei gegebana mena. ");
INSERT INTO tte_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yeisu iba, “Tamagu, ali pwanoli kunuwatu-pwaikili kaiwena tawae sipaipaisowai koliyau nige sikakatai.” Na tokaleyayaone Yeisu kana kwama sikalai yo venu yabo sivenuwan na tem analiyao sibaguna kwamane sikalaili. ");
INSERT INTO tte_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tomo meuloili sitolo Yeisu simankulakulai kabo Yudiya ali toloinao sitalatalawasi-yani yo siwalo-lamwalamwai siba, “Tomo uloili ileboili, na tem iya Mesaiya, Yaubada ana gitesipwa tomona, sowasowana ibomayoi ileboi.” ");
INSERT INTO tte_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Tokaleyayao tabe Yeisu sitalawasi-yani. Silau koina yo oine malumaluluna siwolena yakato inuma, ");
INSERT INTO tte_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","mwa siwalo koina siwaloba, “Tem kowa Yudiya ali kin kubomayoi kuleboiwo.” ");
INSERT INTO tte_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Lelelele yabo silele kabo situtu-yapatu kana kelose koina kulukuluna pwatana mena iba, ‘Bwaite iya Yudiya ali kin.’ ");
INSERT INTO tte_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Toloinalikwa yoli labuiwa sitaketake kali kelose mena, yabo Yeisu ikawa-naenae-yani yo iwaloba, “Tem kowa Mesaiya ee kubomayoi kuleboiwo, na tabe kai kuleboimai.” ");
INSERT INTO tte_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Na yabo ibenabenali mwa kanakavawa iyokoiyan iwaloba, “Nuwana nige Yaubada kumamatausan, wa? Na kubenali, yola yaiyonane kala loina kaigedana. ");
INSERT INTO tte_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kowa yo yau kala maisa idudulaisosi kaiwena kamwasa naenaena tapaisowai mwa maisana bwaite, na tomone bwaite iya nige ginauli yabo ipapaisowa-yanae.” ");
INSERT INTO tte_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kabo tomone iwaloyoi Yeisu koina iba, “Yeisu, saugana tem am kaba loina koina kuyamala kin kunuwatu-kalatagau.” ");
INSERT INTO tte_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yeisu kainana iyamaisa iba, “Yawalo yawasosi koliwo, kaliyate kabona kowa yo yau kani tamiyamiya Paladaisi.” ");
INSERT INTO tte_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kala pwasinasina mena kabo dabwelo mayalena imwawasi yo yanuwa meuloina iboniboniyai kanasiga tili koloki lolau mena. ");
INSERT INTO tte_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kaleko tabatabana bwaimwa siyatake Nume Tabu kalona mena itaigali isae yo ilobi dedei labui. ");
INSERT INTO tte_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kabo Yeisu iyoga kainana lalakina mena iba, “Tamagu, yaluyaluwagu yapei nimam kalona mena.” Saugana iwalo besiele mwa yawasina imwawasi. ");
INSERT INTO tte_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tokaleyayao ali tobaguna igitai tawae iyawatagili, kabo Yaubada itobalan yo iba, “Walo yawasosi tomone bwaite iya todudulai yawasosi.” ");
INSERT INTO tte_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tomo meuloili siya simiyagogo yo simanman-kulakulai saugana sigitai tawae iyawatagiline nuwali sinae kabo gamwagamwalili situtututu yo sipileyoi silau ali nume mena. ");
INSERT INTO tte_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Na Yeisu ana eliyamwao yo sinesineo siya beyabeyana simuliya mekanakavao silaoma Galili sitolo-suwala manli ilau ginauli meuloina sigitagitai. ");
INSERT INTO tte_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Tomo yabo esana Yosepa ilaoma Yudiya dedeina yabo esana Alimadiya mumugana inamwanamwa yo idudulai. Iya isanasanai Yaubada ana kaba loina kaiwena na iya Yudiya ali toloinao kalikava yabo, na iya nige besiele kanakavao ali nuwatu yo ali paisowa koina. ");
INSERT INTO tte_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ilau Pailato koina Yeisu yona ikawanoiyan yakato ikalai, mwa Pailato italam. ");
INSERT INTO tte_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kabo ilau ikelegabaen kelose koina kaleko namwanamwana koina isuma yo ilau ipei salai bwaimwa ikeli-nonowaiyako veku koina, salaine nige toboita yabo sipepei koina. ");
INSERT INTO tte_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kaliyate kabona sabati kana kaliyate katububu na sauga kubwakubwana Yudiya ali sabati kana sauga iyatubu. ");
INSERT INTO tte_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Sinesineone siya beyabeyana mekalikava Yeisu silaoma Galili Yosepa siyamuli-kusuli kabo silau salai sigitai Yeisu yona gubesi ana peipeina. ");
INSERT INTO tte_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Imwawasi sipileyoi silau ali nume mena kabo kwapi kaba sausauli yo olo bwalaina namwanamwasosili sikatububunagili Yeisu yona kaiwena. Na Yudiya ali sabati kana kaliyate ilaoma-oliko kabo sikaiyawasi besiele loina ana walo. ");
INSERT INTO tte_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Wiki kana kaliyate bagubagunana koina malala kikiuna, sinesineone olo bwalaina namwanamwana sikatububunanako sikalai yo silau salai mena. ");
INSERT INTO tte_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Sigitai veku salai gamwana kana kokaukausiwa siyatapipili-suwalanako. ");
INSERT INTO tte_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kabo silau silusae salai kalona mena na iyamo nige Guyau Yeisu yona sigigitai. ");
INSERT INTO tte_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Siya siyaele sinuwanuwatu Yeisu yona kaiwena, kabo sauganane koina tomo labui kali kaleko pigapigabuli sitotolo salili mena. ");
INSERT INTO tte_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Sinesineone simatausi lalakina mwa sipwalou manli ilobi bwatano mena. Na tomo labuiwa siwalolau kolili siba, “Tawae kaiwena iya meyawasina kwaloyaloyai toboita ali kaba miya koina? ");
INSERT INTO tte_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nige imiyamiya bwaite koina, itoloyoiko. Ana walo kwanuwatu-kalatan bwaite iwalowenako kolimiu saugana mekamikava kwamiyamiya dedei Galili koina, ");
INSERT INTO tte_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","iwaloba, ‘Tomo Natuna kani sitalamwan tomo naenaeli nimali mena na siyakelose, kabo muli mena kaliyate yaiyonana koina kani itoloyoi boita mena.’” ");
INSERT INTO tte_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mwa sinesineowa kabo ana walowa nuwali mena isae. ");
INSERT INTO tte_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Saugana sipileyoima salai mena ginauli meuloina wasana siyawasayan apositoloyao yoli ileben kolili, kalikavao mekalikavao tomuliyayao meuloili tabe. ");
INSERT INTO tte_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Sinesineowa wasa bwaite siyawasayan kolili siya Meli Magidala yo Yowana yo Meli iya Yemesa sinana, mekalikavao sinesineo tupwaliyao tabe. ");
INSERT INTO tte_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Na apositoloyao nige sinesineone ali walo simemeliyan, kaiwena ali nuwatune yakato ali edeedede besiele walo bwagabwaga. ");
INSERT INTO tte_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Na Pita itolo yo isagena ilau salai mena. Ipwalou mwa kaleko bwagabwagamo igitai mwa ipileyoi ana nume mena yo inuwanuwatu ginauli bwaite ana yawatagili kaiweli. ");
INSERT INTO tte_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kaliyate kaigedanane koina tomuliya yoli labui silalau dedei esana Emiusa kaiwena, Emiusa yo Yelusalema kali sowasowaga kana mamalawe besiele ileben kilomita. ");
INSERT INTO tte_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yoli labui silolo-edeedede ginauli meuloina iyawatagiliko kaiwena. ");
INSERT INTO tte_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Siya siyaele silolo-edeedede yo sinelineli ginauline kaiwena, kabo Yeisu iyawatagili kolili yo mekalikava silotoyawa. ");
INSERT INTO tte_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Sigitai mowoi na nige sikikilala yo nige sikakatai yaiya iya. ");
INSERT INTO tte_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Mwa kabo ineli kolili iba, “Saugana kwalaulau tawae edeededena kwalolo-edeededene?” Mwa sitalu-tolo kali koleya besiele nuwali sinae. ");
INSERT INTO tte_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yabo esana Kaliyopasa iwalo Yeisu koina iba, “Tolokeikeile sibaibaiwa siyaele Yelusalema, na nuwana kowa kuboma nige ukwakatai tawae iyawatagili saugane bwaite kolili.” ");
INSERT INTO tte_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kabo ineli kolili iba, “Ginauli esana walona?” Kainana siyamaisa siba, “Ginauli bwaite iyawatagili Yeisu game Nasaleta koina. Game bwaite iya palopita yabo, ana edeedede yo ana paisowa kaikaiwena Yaubada manna mena yo tomo meuloili manli mena. ");
INSERT INTO tte_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Topwaoli lalakili mekalikavao ama toloinao sipei gavana nimana mena, kabo italamwan siyakelose na iboita. ");
INSERT INTO tte_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Na kai ama nuwatu yakato Yaubada tomone bwaite igitesipwai na kai tomo Isileli ilivasimai Loma ali loina koina. Na ginauline siyawatagiliko kaliyate yaiyona simwawasiko. ");
INSERT INTO tte_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Na kai sinesineo tupwaliyao katemai siyapitali kaiwena kabona malala kikiuna silau salai mena, ");
INSERT INTO tte_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","na nige yona silolobai. Saugana sipileyoima, kabo siwaloma kolimai yakato aneloseyao sigitaili na siwalo kolili siba, ‘Yeisu itoloyoiko.’ ");
INSERT INTO tte_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kamakavao tupwaliyao silau salai mena yo besiele sinesineo ali walo siya tabe besiele silobai, Yeisu yona nige sigigitai.” ");
INSERT INTO tte_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kabo Yeisu iwaloyoi tabe kolili iba, “Kwayauyaulesosi, yo ami meli ikikiu kaiwena palopitao ali walo Mesaiya kaiwena nige kwamemeliyan. ");
INSERT INTO tte_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Beyabeyana siwaloko yakato Mesaiya kani kamkamna ilobai kabo muli mena ilusae ana wasawasa koina.” ");
INSERT INTO tte_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kabo Yeisu Buki Tabu ana walo iya kaiwena ikabi-yamayale kolili, iyatubuya Mosese ana buki kolili yo palopitao meuloili ali lelelele. ");
INSERT INTO tte_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kikiunamo siyawatagili yanuwane silalau kaiwena, kabo Yeisu iginauli besiele bwaite nuwanuwana yakato ilogabaegili ilauyoi. ");
INSERT INTO tte_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Na sikawanoi samasamalulu koina siwaloba, “Mekamakava kowa tamiyamiya, kaiwena kikiunamo iboniyai yo yanuwa iboniboniyai.” Kabo ilau ilusae nume mena yo mekalikava simiyamiya. ");
INSERT INTO tte_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kekan kana sauga kabo ilau mekalikava simiyasio kaba miya koina. Mwa beledi ikalai yo ikawatoki Yaubada koina kabo itabekivikivi yo iyauyan kolili. ");
INSERT INTO tte_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Iginauli besiele bwaite kabo sikilala yo sikatai yaiya iya, na ikwalalele manli mena. ");
INSERT INTO tte_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Yoli labui sienelineli-yagili siba, “Saugana talaulau kamwasa mena yo iedeedede kolila Buki Tabu ana walo-masala, walo yawasosi katela iwedowedoli, awa?” ");
INSERT INTO tte_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Na sauganane yoli labuine sitolo yo sipileyoi silau Yelusalema, mwa apositoloyao yoli ileben silobaili mekalikavao tupwaliyao simiyagogo. ");
INSERT INTO tte_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Kabo apositoloyao siwalolau yoli labuine kolili siba, “Walo yawasosi, Guyau itoloyoiko mwa iyawatagili Saimon koina.” ");
INSERT INTO tte_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kabo siya yoli labuine ali wasa siwolegili tawae iyawatagili kolili kamwasa mena. Mwa siwaloba, “Saugana beledi ikalai yo itabekivikivi, kabo koina kakilala iya Yeisu.” ");
INSERT INTO tte_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tobenaliyao siyaele siedeedede kalikavao kolili ginauline bwaite kaiwena, kabo Yeisu iyawatagili yoi luwaluwalili mena yo iwalo kolili iba, “Me ami nuwadaumwali.” ");
INSERT INTO tte_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kateli sipitali yo simatausi, ali nuwatu yakato kalukaluwa sigitai. ");
INSERT INTO tte_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mwa iwalo kolili iba, “Gubesi mwa kwanuwa-pwanopwano yo kwanuwa-labulabui? ");
INSERT INTO tte_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nimagu yo kaegu wagitaili. Bwaite yau. Yogu wakabitonan yo wakatai, kalukaluwa nige bulumana yo tuwatuwana ipapagan besiele wagigitaine koliyau.” ");
INSERT INTO tte_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Saugana iwalo besiele bwaite kabo nimana yo kaena iyakenayagili. ");
INSERT INTO tte_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Siya siyaliyaya lalakina yo kateli sipitali na nige naga simemeli mwa ineliyagili iba, “Tabu kan yabo imiyamiya na yakan?” ");
INSERT INTO tte_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kabo iye gabugabuna maimaisana siwolena, ");
INSERT INTO tte_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","mwa ikalai yo ikan manli mena na mesabana sikatai iya nige kalukaluwa besi. ");
INSERT INTO tte_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kabo iwalo kolili iba, “Tauna kona komiu te yau tamiyamiya na yawaloko kolimiu bwaite besiele, ginauli meuloina sileleyako kaiwegu Mosese ana loina koina, palopitao ali lelelele koina yo tabe Same koina siyamala yawasosi.” ");
INSERT INTO tte_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mwa ali nuwatu ikabi-yamayale na mesabana Buki Tabu ana walo kana dudulai sikatai. ");
INSERT INTO tte_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Iwalolau kolili iba, “Buki Tabu iwalo bwaite besiele, Mesaiya kani kamkamna ilobai yo iboita na kaliyate yaiyonana koina itoloyoi boita mena. ");
INSERT INTO tte_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kabo iya esana koina kani siguguguguye na tomo sinuwabui na mesabana Yaubada ali pwanoli inuwatu-pwaikili. Kani siyatubu Yelusalema koina kabo muli mena siyadebalala dedei meuloili kolili. ");
INSERT INTO tte_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Na komiu kani kwaemala toyawasa ginauli meuloili bwaite kaiweli. ");
INSERT INTO tte_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tawae Tamagu iwaloyameliyako kaiwemiu yau kani yayawasayama kolimiu. Na kwamiyamiya naga Yelusalema kanasiga kaiwe ilobima Yaubada koina wakalapowon.” ");
INSERT INTO tte_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yeisu tobenaliyao ibagunayagili yo iyoganli Yelusalema silogabaen silau Bedani dedeina mena, kabo nimana ikeleisinagili yo iwalo-muloloili. ");
INSERT INTO tte_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Iya iyaele iwalowalo-muloloili, na kabo ilogabaegili yo Yaubada ikalai isasae bulibuli mena. ");
INSERT INTO tte_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Siya sipwalou yo sitapwalolo koina, imwawasi kabo me ali yaliyaya lalakina sipileyoi Yelusalema. ");
INSERT INTO tte_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kabo sauga meuloina silaulau Nume Tabu koina Yaubada sitobatobalan. ");
INSERT INTO tte_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sauga ana kaba yatubu koina Walone iyaele imiyamiya. Yo walone iya Yaubada mekanakava, na iya Yaubadanane. ");
INSERT INTO tte_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Sauganane koina walone imiyamiya Yaubada mekanakava. ");
INSERT INTO tte_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Na iya koina Yaubada ginauli meuloili iyamayaleliko. Na tem iya nigele, Yaubada kani nige ginauli yabo iyayamayale. ");
INSERT INTO tte_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Iya koina yawasi, na yawasine iya tomo ali mayale. ");
INSERT INTO tte_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yo boniboniyaine koina mayalene ilala, na boniboniyaine mayalene nige ikakatai. ");
INSERT INTO tte_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mwa Yaubada ana tosagenawasa iyawasayama yanuwa yaulina mena esana Yoni. ");
INSERT INTO tte_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Iya ilaoma towalo-masala mayalene kaiwena. Ilaoma na mesabana iwalo-masala na tomo meuloili simeli. ");
INSERT INTO tte_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yoni iya nige mayalene, na iya mayale kana towalo-masala. ");
INSERT INTO tte_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Na mayalene ilalaomane, iya mayale yawasosi kani tomo iwolegili. ");
INSERT INTO tte_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Kabo ilaoma yo imiyamiya yanuwa yaulina mena. Bwagana iya koina Yaubada yanuwa yaulina iyamayale, na iyamo tomo yanuwa yaulina nige sikakatai iya yaiya. ");
INSERT INTO tte_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ilaoma yo imiyamiya iboma ana yanuwa mena na iyamo ana yanuwa tomoliyao nige siyayaliyaya koina. ");
INSERT INTO tte_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Na siya analiyao siyaliyaya koina yo ali meli sipei koina, italamwagili siyamala Yaubada natunao. ");
INSERT INTO tte_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Siyamala Yaubada natunao nige yanuwa yaulina ana kabi mumugana koina o nuwana tomo ali nuwatu mena na Yaubada kabi waluwaluna koina iwolegili. ");
INSERT INTO tte_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Walone iyamala tomo, kabo imiyamiya mekamakava sauga kubwakubwanamo, iya ikalapowon katekamkamna yo walo yawasosi. Kagitai ana wasawasa besiele Yaubada natuna kaigeda-sosisosimo ana wasawasa, iya ilaomaya tamana koina. ");
INSERT INTO tte_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yoni Toyababitaiso wasane namwanamwanane iyawasa iyogayoga iwaloba, “Iya bwaite tomonane baguna kaiwena yawalo-masala, saugana yawaloba, ‘Iya ilalaoma muligu mena iya ilalakisosi kabo yau, kaiwena iya baguna imiyamiya kabo muli mena yau yayawatagilima.’” Bwaine Yoni Toyababitaiso ana walo Yeisu kaiwena. ");
INSERT INTO tte_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Iya katekamkamna ikalapowon mwa kaiwena sauga ibaibaiwa kai meuloimai tomeli ana mulolo iloyapowonmai. ");
INSERT INTO tte_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yaubada Yudiya kali loinaone iwolegili Mosese koina yo tomo iyakenayagili, na katekamkamna yo walo yawasosi siyawatagilimaya Yeisu Keliso koina. ");
INSERT INTO tte_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nige tomo yabo Yaubada igigitai bwaimwanamo Natuna iboma igitai. Iya besiele Yaubada, yo iya me tamana simiya toyawa, iya koina Yeisu Yaubada kana koleya iyakenayan tomo kolimai. ");
INSERT INTO tte_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yudiya ali tobagunao Yelusalema koina tomo tupwaliyao siyawasali silau Yoni koina. Na tomone tolaune kaloli mena siya topwaoli yo tupwaliyao siya Libai ana susuwo yo tabe tupwaliyaoyoi Palisi. Tolaune sineli Yoni koina siba, “Yaiya kowa?” ");
INSERT INTO tte_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yoni nige imwamwanou na kainali iyamaisa walo dudulai mena iwaloba, “Yau nige Mesaiya.” ");
INSERT INTO tte_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kabo sineliyoi siba, “Na kabo kowa yaiya? Kowa Ilaitiya o nigele?” Yoni iba, “Yau nige Ilaitiya.” Tabe sineliyoi siba, “Nuwana kowa palopitawa lalakinawa ilalaoma o nigele?” Kainali iyamaisa iba, “Nigele.” ");
INSERT INTO tte_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kabo siba, “Kabo kowa yaiya? Tawae kuwalowen kaiwem? Kuwalo dudulai kolimai na mesabana kalau kama toyawasaone ali wasa kaolegili.” ");
INSERT INTO tte_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yoni kainali iyamaisa besiele palopita Aiseya ana walo-masala iba, “Yau bwaite tomonaele yayogayoga ule bwagabwaga mena yawaloba, ‘Guyau ana kamwasa kwayadudulai.’” ");
INSERT INTO tte_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bodane Yudiya tobagunao siyawasali Yoni koina luwali mena Palisi tupwaliyao, ");
INSERT INTO tte_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","sineliyani Yoni siba, “Na tawae kaiwena babitaiso uginauli tem kowa nige Mesaiya o Ilaitiya o palopita yabo lalakina?” ");
INSERT INTO tte_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yoni kainali iyamaisa iba, “Yau waila koina yayababitaiso na iya luwamiu mena itotolo nige wakakatai. ");
INSERT INTO tte_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Iya ilalaoma muligu mena ilalakisosi, nige yagu namwanamwa ipapagan na tem yapwalou yo kaena kana suma kana maina yalivasili.” ");
INSERT INTO tte_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ginauline meuloina bwaite siyawatagili yanuwa Bedani dedei teya kaluwabu mena bwaine Yolidan wailana koina Yoni tomo iyababitaisoli. ");
INSERT INTO tte_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Yanuwa ilayan kabo Yoni manna ilau Yeisu igitai ilalaoma koina kabo iba, “Wagitai, bwaine iya laminane Yaubada iyawasayama na tomo yanuwa yaulina mena ali pwanoli ikele-gabaegili. ");
INSERT INTO tte_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iya bwaine kaiwena baguna yawalowalo, ‘Tomone iya ilalaoma muligu mena ilalakisosi kabo yau, kaiwena iya itubu baguna kabo muli mena yayawatagilima.’ ");
INSERT INTO tte_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Sauganane koina nige yakakatai yaiya kaiwena yaedeedede na iyamo yalaoma tomo yayababitaisoli waila mena, yaina mesabana tomonane yayakenayan tomo Isileli kolili.” ");
INSERT INTO tte_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Yo Yoni iwalo-masala yoi iba, “Baguna nige yakakatai yaiya ilalaoma, na iya iyawasayau na tomo yayababitaisoli waila mena iwalo koliyau iba, ‘Tomone iya naga kani ugitai Yaluyaluwa Tabuna ilobima imiyamiya koina, iya kani tomo iyababitaisoli Yaluyaluwa Tabuna koina.’ Bwaine Yaubada ana walo koliyau. Kabo muli mena yagitai Yaluyaluwa Tabuna ilobima bulibuli mena besiele bunetutu itowa koina.” ");
INSERT INTO tte_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yabomayoi manigu mena yagitai mwa bwaite kaiwena yawaloba, “Tomone bwaite iya Yaubada Natuna.” ");
INSERT INTO tte_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Yanuwa ilayanyoi Yoni yo me ana tobenaliyao labui sitotolo dedeinane koina, ");
INSERT INTO tte_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","yo saugana Yoni Yeisu igitai ilaulau mwa iwaloba, “Wagitai. Iya bwaite laminaele Yaubada iyawasayama.” ");
INSERT INTO tte_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Saugana tobenali labuine Yoni ana walo sibenalan kabo Yeisu mulina mena silau. ");
INSERT INTO tte_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yeisu itagelakeile igitaili mwa ineli kolili iwaloba, “Tawae nuwanuwamiu?” Kainana siyamaisa siba, “Labai, toweya koina kumiyamiya?” (Walone bwaite kaina Ibeliu Labai kana katai toyakayakatai.) ");
INSERT INTO tte_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yeisu kainali iyamaisa iwaloba, “Kwalaoma na wagitai.” Kabo Yeisu mekalikava silau yo sigitai ana kaba miya, mwa kaliyatenane koina simiyamiya mekalikava. Bwaite saugane besiele powa koloki lolau. ");
INSERT INTO tte_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Na siya yoli labuine kabona sitotolo Yoni mekalikava kainana sibenalan kabo Yeisu mulina mena silau yabo iya Anidulu yo yabo ana eliyam. Na Anidulu iya Saimon Pita kanakava, ");
INSERT INTO tte_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","mwa Anidulu ana paisowa bagubagunana bwaimwa ilau kanakava Saimon iloyai yo ana wasa iwolena iwaloba, “Mesaiya kalobai, bwaimwa Keliso.” ");
INSERT INTO tte_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kabo Anidulu Saimoni iyogan ilawan Yeisu koina. Yeisu manna ilau Saimoni koina yo igitai kabo iwaloba, “Kowa Saimoni, Yoni natuna, na esam yaeyawa Sipasa.” (Na esa Sipasa kana bui kaina Giliki koina Pita, bwaimwa kana katai veku.) ");
INSERT INTO tte_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Yanuwa ilayanyoi Yeisu inuwanuwatu tem ilau Galili. Pilipi ilobai kabo iedeedede koina iba, “Kulaoma kumuliya koliyau.” ");
INSERT INTO tte_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipi ana yanuwa Betesaida bwaimwa yanuwane Anidulu te Pita tabe ali yanuwa. ");
INSERT INTO tte_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilipi Nataniela ilobai yo iedeedede koina iwaloba, “Tomo yabo esana Yeisu kalobai. Ilaomaya Nasaleta yo tamana esana Yosepa. Iya kaiwena Mosese ilele loina bukina mena yo tabe palopitao silele.” ");
INSERT INTO tte_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Mwa Nataniela ineli iba, “Tawae namwanamwana yabo kani ilaoma Nasaleta koina? Nuwana nigele.” Kabo Pilipi iba, “Talau na ugitai.” ");
INSERT INTO tte_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Saugana igitai Nataniela ilalaoma koina kabo Yeisu iba, “Bwaite tomone iya Isileli yawasosi, nige sowasowana mwakota yabo talobai koina.” ");
INSERT INTO tte_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Kabo Nataniela Yeisu ineliyan iba, “Gubesi na ukwataiyau?” Yeisu iba, “Yagitaiwo damaya yaulina mena kumiyamiya, muli mena kabo Pilipi iyoganwo.” ");
INSERT INTO tte_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kabo Nataniela katena ipitali mwa iwalo Yeisu koina iba, “Toyakayakatai, kowa Yaubada Natuna yo kowa Isileli ali kin.” ");
INSERT INTO tte_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yeisu iwaloba, “Kumeli kaiwena yawalo koliwo, ‘yagitaiwo damaya yaulina mena.’ Bwaite nige ginauli lalakina, na naga kani ginauli lalakili ugitaili muli mena. ");
INSERT INTO tte_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yawalo yawasosi koliwo, naga kani ugitai bulibuli kana gamwa isoke yo Yaubada ana aneloseyao ugitaili sisaesae yo silobilobima Tomo Natuna koina.” ");
INSERT INTO tte_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yo kaliyate labui simwawasi kabo kasole kekanna siginauli yanuwa Kena koina bwaimwa dedei Galili. Na kekanne kalona mena Yeisu sinana imiyamiya. ");
INSERT INTO tte_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yo Yeisu me ana tobenaliyao tabe siyoganli kekanne koina yo boda tupwaliyao mekalikavao silusae yo sikekan. ");
INSERT INTO tte_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Sauganane ali kekan kalona mena yo kali oine siyemwawasili, mwa Yeisu sinana iwalo koina iba, “Natugu, oine meuloina simwawasi.” ");
INSERT INTO tte_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yeisu sinana kainana iyamaisa iba, “Tawae kaiwena kuwalowalo koliyau besiele? Yagu sauga naga ilalaoma.” ");
INSERT INTO tte_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kabo Yeisu sinana iwalo topaisowao kolili iba, “Tem tawae iwalowen waginauli besiele ana walo.” ");
INSERT INTO tte_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yudiya mumugali muli mena kabo sikekan kani nimali yo kekan gogoliyao sideuli-baguna-yagili ali tapwalolo kana loina besiele. Mwa bwaite kaiwena waila kaba suwe kauli sikisi veku koina siginaulili simiyamiya, kaigeda kaigeda sowasowana waila kana lalaki andeledi lita. ");
INSERT INTO tte_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Kabo Yeisu iwalo topaisowao kolili iba, “Waila kwalegulima na kaba suwe kauline kwayapowonli.” Mwa waila silegulima yo kaba suwe kauliwa siyapowonli. ");
INSERT INTO tte_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kabo Yeisu topaisowaone kolili iwaloba, “Wailane tupwana kaba suwe kauline koina kwalegu na kwalawan kekan tanuwagana kwaolena.” Mwa siginauli tawae ana walo besiele, ");
INSERT INTO tte_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","kabo kekan tanuwaganane wailane ikalai inuma-tonan, katena ipitali kaiwena bwaite oine namwanamwasosina. Na wailane Yeisu ibuiyako iyamala oine. Na kekan tanuwaganane nige ikakatai oinene toweya ilaomaya, na topaisowao siya sikatai. Kabo kekan tanuwaganane kasole tauna iyoganama koina, ");
INSERT INTO tte_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","me ana yaliyaya itobalan iwalo koina iba, “Tomo tupwali mumugali besiele yakato oine kana lotonan namwanamwana sipei-bagunayan kekan mena yo saugana tomo sinuma-towa yo kali lotonan sowasowali kabo oine bwagabwaga sipei. Na komiu bwaine kamwasane naenaenane nige wagiginauli besiele. Kaiwena oine namwanamwana kwapei-baguna-yani yo saugana tomo sinuma-towa yo kali lotonan sowasowali kabo muli mena oine bwaite namwanamwasosina kwapeiyama.” ");
INSERT INTO tte_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ginauli kaba nuwapwanopwanone bwaite Yeisu iginauli yanuwa Kena koina Galili dedeina mena bwaimwa ana paisowa ginauli kaba nuwapwanopwano bagubagunana. Paisowane koina ana wasawasa iyakenayagili tobenaliyao kolili kabo ali meli sipei koina. ");
INSERT INTO tte_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kasole kekanna mulina mena Yeisu mesinana yo kanakavao yo ana tobenaliyao silobi Kapeneomi, bwaine koina kaliyate isa simiyamiya. ");
INSERT INTO tte_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yudiya ali mwalelikwa soina kana sauga ikelakubwamako mwa Yeisu isae Yelusalema. ");
INSERT INTO tte_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Na Yelusalema koina Yeisu ilusae Nume Tabu mena, tomo tupwaliyao ilobaili bulumakau, sipi, yo bunetutu sigimwagimwala-yagili, yo tupwaliyao simiyamiya teibeli mena mane siyakuyakunelae. ");
INSERT INTO tte_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kabo maina giligilili ikalaili yo balae iginauli kabo koina togimwala, bulumakau, sipi, meuloili itao-yawatagilagili Nume Tabu koina yo mane toyakunelaewo ali mane nimana mena ikuya-yabekuli yo ali teibeli ibuili. ");
INSERT INTO tte_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kabo iwalolau bunetutu kana togimwalayao kolili iba, “Ami gogo meuloina bwaite wakalaili kwayawatagili. Tabu sauga yaboyoi Tamagu ana nume waginauli kaba maketi.” ");
INSERT INTO tte_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ana tobenaliyao nuwali mena isae Buki Tabu ana walo iba, “Am nume kana mulolo iwedoli kategu mena besiele mayau.” ");
INSERT INTO tte_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yudiya ali tobagunao tupwaliyao Yeisu ana paisowa sigitai simunamunai kabo siwalolau Yeisu koina siwaloba, “Yaiya ana loina uginauli besiele? Ginauli kaba nuwapwanopwano yabo uginauli na kakatai yakato kowa am loina ilaomaya Yaubada koina, yakato sowasowam ginauli bwaite uginaulili.” ");
INSERT INTO tte_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yeisu kainali iyamaisa iwaloba, “Tem Nume Tabu bwaite wakogwaligwali kani kaliyate yaiyona koina yayatoloyoi.” ");
INSERT INTO tte_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kainana siyamaisa siba, “Bolime poti sikisi nume bwaite sikabikabi, na gubesi kowa kuwawalo yakato kaliyate yaiyona koina kani kuyatoloyoi?” ");
INSERT INTO tte_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","(Na Nume Tabu bwaite Yeisu kaiwena iwalowalo ibomayoi yona kaiwena. ");
INSERT INTO tte_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Saugana boita mena itoloyoi ana tobenaliyao nuwali mena isae tawae tauna kona iwalowen kabo simeli Buki Tabu ana walo yo Yeisu ana walo ana toloyoi kaiwena.) ");
INSERT INTO tte_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Saugana Yeisu iyaelemo Yelusalema imiyamiya mwalelikwa soina kana sauga koina ginauli kaba nuwapwanopwano tupwali ipaisowaili. Tomo sibaibaiwa sigitaili mwa simeli yakato iya Mesaiya. ");
INSERT INTO tte_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Na Yeisu nige igogolulau yo nige imemeli kolili, kaiwena tomo meuloili ali nuwatu ikatailiko. ");
INSERT INTO tte_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nige sowasowana tomo yabo Yeisu ana wasa iwolena tomo mumugali kaiwena. Yeisu tomo meuloina katena yo ana nuwanuwatu mayamayalena koina. Kaiwena kaliyate kaigeda kaigeda tomo mumugaliyao sibuibuili. ");
INSERT INTO tte_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tomo yabo esana Nikodimo, iya Palisi yo tabe Yudiya ali tobaguna yabo. ");
INSERT INTO tte_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Boniyai mena ilau Yeisu koina yo itobalan iwalo koina iba, “Labai, kakatai kowa toyakayakatai kulaomaya Yaubada koina kaiwena ginauli kaba nuwapwanopwano bwaite uginaginauliline nige sowasowana yaiya yabo iginaulili tem Yaubada nige mekanakava.” ");
INSERT INTO tte_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yeisu Nikodimo kainana iyamaisa iba, “Yawalo yawasosi koliwo, tem nige ukwakabi yaboyoi kani nige Yaubada ana kaba loina ugigitai.” ");
INSERT INTO tte_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Na Nikodimo iba, “Tem tomo ilalakiko kani gubesi sikabiyanyoi? Nige sowasowana ilusaeyoi sinana diyana kalona mena na ikabiyoi.” ");
INSERT INTO tte_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yeisu Nikodimo kainana iyamaisa iba, “Yawalo yawasosi koliwo, nige sowasowana tomo yabo ilusae Yaubada ana kaba loina koina bwaimwanamo ikabi yaboyoi waila yo Yaluyaluwa Tabuna kolili. ");
INSERT INTO tte_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tomo tamana yo sinana sikabi kwapi koina meyawasina, na tem Yaluyaluwa Tabuna kabi waluwaluna iwolena tomone koina kani yaluyaluwana meyawasina. ");
INSERT INTO tte_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Tabu katem iwawakaka yagu walone kaiweli saugana yawaloba ukwabi yaboyoi kabo Yaubada ana kaba loina kulusae. ");
INSERT INTO tte_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Toweya koina yaumai itowa ilalau iboma iloina. Kita yaumaimo daguguna tabenalan na iyamo nige takakatai toweya ilaomaya yo toweya ilalau. Besiele tomo meuloina siya ali kabi waluwaluna silobai Yaluyaluwa Tabuna koina, ali meli nige sowasowana tagitai na ali paisowa koina ali meli uwena sowasowana tagitai.” ");
INSERT INTO tte_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Kabo Nikodimo Yeisu ineliyanyoi iba, “Gubesi na kani am walone kanna iyawatagili?” ");
INSERT INTO tte_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yeisu iba, “Kowa yakato Isileli ali toyakayakatai lalakina yabo. Na gubesi mwa nige nuwam imamayale yagu walone kaiwena? ");
INSERT INTO tte_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yawalo yawasosi koliwo, ginauline kakataili kaedeedede kaiweli yo kawalo-masalagili tawae kagitaili, na iyamo komiu nige kwamemeli ama walone kaiweli. ");
INSERT INTO tte_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nige sowana yaedeedede ginauli bulibuli mena kaiweli kaiwena kani nige kwamemeli. Kaiwena ginauli situbu yanuwa yaulina mena kaiweli yaedeededeko na iyamo nige wakakawa-yawasosi. ");
INSERT INTO tte_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nige yabo yaiya isasae bulibuli mena bwaimwanamo Tomo Natuna iya ilobimaya bulibuli mena. ");
INSERT INTO tte_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mosese kopa ikalai yo weso makamakayauna iginauli yo iyatake ginagina koina ule bwagabwaga mena. Ee bwaine besiele naga muli mena Tomo Natuna sikeleisinan kelose mena. ");
INSERT INTO tte_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Mwa tem yaiya imeli koina yawasi miyamiya yaina ilobai. ");
INSERT INTO tte_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yaubada yanuwa yaulina imulolososi koina kabo natuna kaigeda-sosisosimo italamwan mwa tem yaiya imeli koina nige sowasowana iboita na yawasina miyamiya yaina ilobai. ");
INSERT INTO tte_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yaubada natuna iyawasayama yanuwa yaulina mena, nige tomo sabi yatalayanna na iyawasayama sabi leboili. ");
INSERT INTO tte_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nige sowasowana tomo yabo yatala ilobai tem imeli natuna koina. Na tem yaiya nige imemeli koina ana yatala mayamayalena imiyamiya kaiwena iya nige imemeli Yaubada Natuna kaigeda-sosisosimo koina. ");
INSERT INTO tte_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yatala yaina bwaite besiele. Mayale ilaomako ilusae yanuwa yaulina mena na tomo ali nuwatu iyaelemo boniboniyai mena yo nuwanuwali lalakina boniyai, mayalene sisikotanan kaiwena mumugaliyao sinae. ");
INSERT INTO tte_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Siya analiyao mumugana naenaena siginaginauli mayalene sikalomagigilan nige nuwali silau mayalene koina kaiwena genuwali mayalene ali naenaena iyakenayan mayale mena. ");
INSERT INTO tte_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Na siya analiyao mumugali sinamwanamwa yo sidudulai silau mayale mena kaiwena nuwanuwali tomo ali paisowa sigitai yo sikatai yakato ali kaiwe ilaomaya Yaubada koina.” ");
INSERT INTO tte_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Muli mena Yeisu me ana tobenaliyao silau dedei Yudiya yo bwaine koina simiyamiya sauga tupwana na tomo iyabayababitaisoli. ");
INSERT INTO tte_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yoni Toyababitaiso besiele tomo iyabayababitaisoli yanuwa Ainon bwaimwa Salim papalina mena kaiwena bwaine koina waila lalakina imiyamiya mwa tomo meuloili silaulau koina na iyabayababitaisoli. ");
INSERT INTO tte_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Bwaine sauganane koina Yoni naga sipepei deli mena. ");
INSERT INTO tte_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yoni ana tobenaliyao tupwaliyao sigamwapakiki Yudiya yabo mekalikava sugu mumugana kaiwena toisabo simuliya mesabana kani idudulai Yaubada manna mena. ");
INSERT INTO tte_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kabo tobenaliyaone silau Yoni koina siba, “Toyakayakatai, tomowa baguna mekamkava waila Yolidan dedei yabo mena, iya kaiwena kuwalo-masala, iya bwaite sauga iyaele tomo iyabayababitaisoli. Tomo sibaibaiwasosi silaulau koina, na nige silalaoma kolila.” ");
INSERT INTO tte_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yoni kainali iyamaisa iba, “Nige sowasowana ginauli yabo iyawatagili tomo yabo koina bwaimwanamo tem Yaubada kaiwe iwolena koina. ");
INSERT INTO tte_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Na komiu beyabeyana kwaboma kwabenalan yawaloba yau nige Mesaiyanane na Yaubada iyawasa-baguna-yagauma Mesaiyane kaiwena. ");
INSERT INTO tte_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Tokasole tauna iya kani sinene ikalai na kasole taunane ana eliyam isanasana kasole tauna yo sine ali yawatagili kaiweli, mwa iya iyaele ibenabenali. Saugana ibenalan kasole tauna kainana iyaliyaya lalakina. Ee bwaine yagu yaliyaya lalakisosina yalobaiyako. ");
INSERT INTO tte_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Esana kani ilalaki na esagu kani ilobi.” ");
INSERT INTO tte_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yoni iwaloyoi iba, “Tomone iya ilaomaya yanuwa yaulina mena iya yanuwa yaulina tomona yo iedeedede ginauli tawae situbu yanuwa yaulina kaiweli. Na tomone ilobimaya bulibuli mena iya ilalakisosi kabo tomo meuloila. ");
INSERT INTO tte_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ginauli tawae bulibuli mena igitaili yo ibenalagili wasaliyao iwalo-masalagili, na iyamo nige yabo ana walone simemeliyan. ");
INSERT INTO tte_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Na tem yaiya ana walone imeliyan iya ikawa-yawasosi yakato Yaubada iya towalo-yawasosi. ");
INSERT INTO tte_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Iya Yaubada iyawasayama iedeedede Yaubada kainana kaiwena Yaubada Yaluyaluwana iwolena koina yo iya ipowon. ");
INSERT INTO tte_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tamana imulolo Natuna koina mwa ginauli meuloina ipei nimana mena. ");
INSERT INTO tte_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tem yaiya imeli Yaubada Natuna koina iya yawasi miyamiya yaina ilobaiyako. Na tem yaiya Natunane isikotanan nige sowana yawasi miyamiya yaina ilobai, na Yaubada ana munamunai kani imiyayai koina.” ");
INSERT INTO tte_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Palisi wasa sibenalan yakato Yeisu tomo sibaibaiwa ikalaili iyabayababitaisoli siyamala ana tomuliyayao, kabo ana tomuliyayao Yoni ana tomuliyayao sibaibaiwa-gabaegili. ");
INSERT INTO tte_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Na Yeisu nige iboma tomo yabo iyayababitaiso na ana tobenaliyaomo siya siyabayababitaiso. ");
INSERT INTO tte_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Sauganane koina Yeisu ikataiyako yakato iya wasana Palisi sibenalanako, mwa dedei Yudiya ilogabaen na ipileyoi ilau dedei Galili. ");
INSERT INTO tte_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yeisu ana laune Galili kaiwena kani ilau dedei Sameliya kana kamwasa koina iloutusi, ");
INSERT INTO tte_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","kabo ilau iyawatagili yanuwa yabo esana Saika bwaimwa Sameliya dedeina mena. Yanuwane nige kana mwayaga imamamalawe bwatanone beyabeyana Yakobo iwolena natuna Yosepa koina. ");
INSERT INTO tte_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Waila keli yabo iyaele bwaine beyabeyana Yakobo ikeliyako. Laune koina Yeisu kamnana inae, kabo imiyasio waila keline dedeina mena. Sauganane koina besiele kala pwasinasina. ");
INSERT INTO tte_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Sauganane koina Yeisu ana tobenaliyao iyawasali silaoko yanuwa yabo koina na kan sigimwala, kabo Sameliya sinena yabo ilaoma waila legu kaiwena. Mwa Yeisu iwalo sinene koina iba, “Sowasowana waila kuleguyama yanuma?” ");
INSERT INTO tte_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kabo Sameliya sinena iwalo Yeisu koina iba, “Kowa Yudiya tomona yo yau Sameliya sinena. Na gubesi mwa ukawanoi koliyau yakato waila yaleguyawa kunuma?” Sinene walone bwaite iwalowen kaiwena Yudiya yo Sameliya nige sikakawa-elieliyam. ");
INSERT INTO tte_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yeisu sinene kainana iyamaisa iba, “Temga ukwatai tawae Yaubada sowasowana iyeyawa yo temga ukwatai yaiya yau mwa wailane yakawanoiyan koliwo, kabo ukwawanoi koliyau na waila meyawasina yaeyawa.” ");
INSERT INTO tte_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kabo sinene iba, “Taubala, waila keline imamalawesosi, na nige am kaba legu ipapagani na mesabana wailane kulegu. Waila meyawasina toweya kani ukwalaiya? ");
INSERT INTO tte_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Gubesi, am nuwatu yakato kowa kulalakisosi kabo tubumai Yakobo na tem waila namwanamwasosina kuyeyama? Nuwana nigele, kaiwena Yakobo waila keline bwaite iyeyama kolimai, yo iya mekanakava natunao, yo ana sipi yo ana bulumakau, beyabeyana waila keline iya ali kaba numanuma.” ");
INSERT INTO tte_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yeisu sinene kainana iyamaisa iba, “Tem yaiya tomo wailane bwaite koina inuma kani galogalona imaguyoi, ");
INSERT INTO tte_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","na tem yaiya wailane koliyau yaolena inuma nige sowasowana galogalona imaguyoi. Wailane bwaite yaolena koina kani iyamala waila bunubunuwasina (doelu) yo waila miyamiya yaina.” ");
INSERT INTO tte_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Sinene iwaloba, “Taubala, waila bwaite kuyeyama yanuma na tabu galogalogu imamaguyoi na tabu yalalaomayoi waila keline koina yaleleguyoi.” ");
INSERT INTO tte_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yeisu iba, “Kulau wainem kuyogan na mekamkava kwalaoma.” ");
INSERT INTO tte_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Sinene iba, “Nige wainegu ipapagani.” Mwa Yeisu sinene kainana iyamaisa iba, “Na walo yawasosi kuwalowen, nige wainem ipapagani. ");
INSERT INTO tte_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Beyabeyana ukwasole me paibi na taune iya sauga bwaite mekamkava kwamiyamiya nige wainem besi. Mwa kabona am walo iyamala yawasosi.” ");
INSERT INTO tte_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Saugana sinene Yeisu ana walo bwaite ibenalan katena ipitali kabo iwaloba, “Taubala, yakataiwo tomala kowa palopita yabo. ");
INSERT INTO tte_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kai Sameliya tubumayao koyane bwaite koina sipwalopwalou Yaubada koina na komiu Yudiya kwawalo yakato kaba tapwalolo bwaimwanamo iya Yelusalema.” ");
INSERT INTO tte_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Kabo Yeisu iba, “Sine, yagu walone kumeliyan. Sauga ilalaoma tomo meuloili kani sipwalou Tamali koina na nige koyane bwaite koina o tem Yelusalema. ");
INSERT INTO tte_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Komiu Sameliya kwapwalopwalouya iya nige wakakatai koina na kai Yudiya kapwalou Yaubada iya kakatai koina, kaiwena tolebolebo ilaomaya kai Yudiya kolimai. ");
INSERT INTO tte_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Na sauga ilalaoma yo tabe iyawatagilimako, kabo siya Tamala kana topwalou yawasosiwo koina sitapwalolo yo ali tapwalolone yaluyaluwali meuloina mena yo tabe kate yawasosili mena. Siya bwaite besiele totapwalolone Yaubada nuwanuwana. ");
INSERT INTO tte_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yaubada iya yaluyaluwa, mwa koinaele analiyao siya sipwalopwalou koina ilonamwayagili yaluyaluwali meuloina mena yo tabe kate yawasosili mena sipwalou koina.” ");
INSERT INTO tte_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Sinene iwaloba, “Yakatai yakato iya Mesaiyane ilalaoma, mwa saugana tem ilaoma, kabo ginauli meuloina ikabi-yamayale kolimai.” (Na walone Mesaiya bwaimwa kaina Ibeliu na kana bui kaina Giliki koina siba ‘Keliso.’ Kali katai Yaubada ana gitesipwa tomona.) ");
INSERT INTO tte_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yeisu kainana iyamaisa iba, “Na yau Mesaiyanaele mwa koliwo yawalowalo.” ");
INSERT INTO tte_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Saugana tobenaliyao sipileyoima Yeisu koina, yo kateli ipitali kaiwena sigitai Yeisu iedeedede sine yabo koina. Na nige yabo ineneliyan ali edeedede yaina o tawae kaiwena iedeedede sinene koina. ");
INSERT INTO tte_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kabo sinene kana waila patu ilogabaen yo mwayamwayau mena ipileyoi ilau yanuwa mena. Kabo iwalo tomo meuloili kolili iba, ");
INSERT INTO tte_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Kwalaoma tomo yabo wagitai, iya mumugagu meuloina yaginauliliko iwalo-masalagili koliyau. Nuwana iya Mesaiyanane.” ");
INSERT INTO tte_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mwa tomo meuloina yanuwa mena silau Yeisu koina. ");
INSERT INTO tte_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Saugana sinene ipipileyoi yanuwa mena, na naga bodane siyayawatagili Yeisu koina, kabo tobenaliyao siwalo Yeisu koina siwaloba, “Toyakayakatai, kan yabo ukwan.” ");
INSERT INTO tte_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mwa kainali iyamaisa iba, “Kagu imiyamiya komiu nige wakakatai.” ");
INSERT INTO tte_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kabo tobenaliyao sibomayoi siedeedede kolili siwaloba, “Nuwana tomo yabo kan ikalaiyama ikekanko.” ");
INSERT INTO tte_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Kabo Yeisu iba, “Kagu ele bwaite, iya iyawasayaumane ana nuwatu yaginauli yo ana paisowa yaemwawasi. ");
INSERT INTO tte_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Komiu ami edeedede yabo kwawalo bwaite besiele, ‘Waikena esopalimo simiyamiya kabo sepasepa yo kelikeli kali sauga.’ Na yawalo kolimiu, manimiu ilau tanone wagitai. Kanna imatuwako mwa sowasowana takeli. ");
INSERT INTO tte_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Saugana tokelikeli tano kanna sikeli maisana namwanamwana sikalai yo kannane bwaimwa tomo yawasi miyamiya yaina silobalobai. Kabo tokuma yo tokelikeli siyaliyaya toyawa lalakina. ");
INSERT INTO tte_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Walo bwaite iba ‘yabo ikuma yo tabe yabo ikelikeli,’ na iyamala walo yawasosi besiele bwaite. ");
INSERT INTO tte_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Saugana yayawasamiu kwalau tano wakeli bwaimwa beyabeyana komiu nige wakukumai. Tomo uloili tanone sikumai na komiu ali paisowa kanna kana namwanamwa kwalobai.” ");
INSERT INTO tte_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tomo Sameliya sibaibaiwa simiyamiya yanuwa Saika koina simeli Yeisu koina kaiwena sinene ana edeedede sibenalan iba, “Iya mumugagu meuloina yaginauliliko iwalo-masalagili koliyau.” ");
INSERT INTO tte_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kabo saugana silaoma Yeisu koina mwa sikawanoi tem imiyamiya mekalikava. Kabo kaliyate labui Yeisu imiyamiya yanuwane koina yo iyakayakatai. ");
INSERT INTO tte_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mwa tomo sibaibaiwa tabe simeli Yeisu ana yakayakatai kaiwena. ");
INSERT INTO tte_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kabo tomo siwalolau sinene koina siwaloba, “Nige yakato am walone bwaite kaiwena na kameli, na iyamo kabomamo ana edeedede kabenalan mwa kakatai walo yawasosi iya tomo yanuwa yaulina mena kali tolebolebo.” ");
INSERT INTO tte_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kaliyate labuine simwawasi kabo Yeisu dedei Sameliya ilogabaen yo ilau dedei Galili. ");
INSERT INTO tte_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Na tauna kona Yeisu iwaloko ana tobenaliyao kolili iba, “Palopita yabo iboma ana yanuwa tomonliyao nige siyayakasisiyan.” ");
INSERT INTO tte_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Na iyamo saugana ilau iyawatagili Galili dedeina koina Galili tomonliyao Yeisu ana yawatagili kaiwena siyaliyaya. Kaiwena beyabeyana ilau Yelusalema mwalelikwa soina kaiwena yo ana paisowa meuloili ipaipaisowaili Galili tomonliyaone sigitaiyako bwaine koina. ");
INSERT INTO tte_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yeisu ilauyoi Kena, Galili dedeina beyabeyana yanuwane koina waila ibui iyamala oine. Na bwaite koina toloina yabo ilaoma, na natuna tauna ikasiebwa Kapeneomi koina. ");
INSERT INTO tte_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Saugana toloinane wasa ibenalan yakato Yeisu ipileyoimako Yudiya dedeina koina yo iyawatagilimako Galili, kabo ilau koina yo ikawanoi yakato tem mekanakava silau Kapeneomi na natuna iwoisi, kaiwena melumelune ana kasiebwa ipolowesosi. ");
INSERT INTO tte_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yeisu iwalo koina iba, “Nige yabo kolimiu imemeliyagau. Tem ginauli kaba nuwapwanopwano yo kaba nuwayai wagitaili kabo kwameli.” ");
INSERT INTO tte_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kabo toloinane iba, “Taubala, kulaoma talau natugu ugitai kabo muli mena iboita.” ");
INSERT INTO tte_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yeisu iwalo koina iba, “Kupileyoi, natum kani nige iboboita.” Tomone Yeisu ana walo imeliyan kabo ipileyoi ilau. ");
INSERT INTO tte_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Iya iyaele naga ilaulau kamwasa mena, kabo ana topaisowao ilobaili yo ana wasa siwolena siwaloba, “Natum inamwanamwako.” ");
INSERT INTO tte_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kabo ineliyagili toisabo sauga koina natunane yona itulu, mwa siba, “Laina lolau mena wan koloki besiele yona wedowedolina itulu.” ");
INSERT INTO tte_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kabo melumelune tamana nuwana mena isae laina bwaine saugane koina mwa Yeisu iwalo koina iba, “Natum kani nige iboboita”. Kabo toloinane mekanakavao ana nume kana tomiyayao meuloili simeli. ");
INSERT INTO tte_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yeisu saugana ipileyoima Yudiya dedeina mena ginauli kaba nuwapwanopwano labuina bwaite ipaisowai Galili dedeina mena. ");
INSERT INTO tte_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Sauga yabo tabe, Yeisu ilauyoi Yelusalema Yudiya ali tapwalolo kekanna yabo kaiwena. ");
INSERT INTO tte_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yelusalema kaba lusalusaena yabo esana siba Sipi ali Gamwa. Na waila kipukipuna yabo iyaele kaba lusalusaene dedeina mena, esana kaina Ibeliu siba Beteseda. Nume gwau kali baibaiwa paibi sikabi-takikilagili wailane koina. ");
INSERT INTO tte_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Gwaune tokasiebwao sibaibaiwa ali kaba miya, siya tomangibugibu, siya kaeli youyouli, yo siya yoli sitawalololi. ");
INSERT INTO tte_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Bwaine koina tobelu yabo iyaele ikasiebwa bolime kana baibaiwa teti eit (38). ");
INSERT INTO tte_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yeisu tomone igitai ikenokeno yo ikatai sauga imamalawesosi ikasikasiebwa, mwa ineli iba, “Gubesi, nuwanuwam kunamwanamwa?” ");
INSERT INTO tte_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tobelune Yeisu kainana iyamaisa iba, “Taubala, saugana tem wailane imwasali, nige tosagu yabo imiyamiya na isaguiyau na mesabana yalobi wailane kalona mena. Saugana tem yatonan yakato yagayolobi waila mena na tomo yabo igayolobi bagunako.” ");
INSERT INTO tte_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kabo Yeisu iwalo tobelune koina iba, “Kutolo am dam ukwalai na kulau.” ");
INSERT INTO tte_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kabo sauganane koina tobelune inamwanamwa yo itolo, ana dam ikalai yo ilau. Na ginauli bwaite iyawatagili Yudiya ali Sabati koina, ");
INSERT INTO tte_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","mwa Yudiya ali toloinao sigitai tobelune ana dam ikalakalai kabo siwalo koina siba, “Kaliyate Sabati kabona. Loina isikote tabu paisowa Sabati koina. Nige sowana am dam ukwalai na kulau.” ");
INSERT INTO tte_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kabo kainali iyamaisa iba, “Tomo bwaite iwoisiyau iba, ‘Am dam ukwalai na kulau.’” ");
INSERT INTO tte_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Kabo toloinaone sineli siba, “Toisabo tomo iwalo koliwo yakato am dam ukwalai kulau?” ");
INSERT INTO tte_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Na tobelune bwaite nige sowasowana kainali iyamaisa kaiwena kana towoisine esana nige ikakatai, kaiwena boda lalakina siyaele waila dedeina mena yo Yeisu ilusola luwali mena ilau. ");
INSERT INTO tte_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Saugana toloinaone silowasi, nige sauga mamalawena kabo Yeisu tobelune ilobaiyoi Nume Tabu kalona mena, yo iwalo koina iba, “Ugitai, kunamwanamwako. Mumugana naenaena kulopei koina kisi sauga muli mena ginauli naenaesosina kulobai.” ");
INSERT INTO tte_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kabo tobelune ilau Yudiya ali toloinao ali wasa iwolegili iba, “Tomala Yeisu mwa iwoisiyau.” ");
INSERT INTO tte_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yeisu tobelune iwoisi Sabati koina mwa kaiwena Yudiya toloinao siyatubu Yeisu sikalomagigilan yo sauga meuloina sigamwapakiki koina. ");
INSERT INTO tte_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kabo Yeisu iwalo kolili iba, “Tamagu kaliyate kaigeda kaigeda ipaipaisowa bwagana Sabati, yau tabe besiele yapaisowa.” ");
INSERT INTO tte_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Walone bwaite Yudiya toloinao iula-munamunaili kaiwena ali nuwatu yakato Sabati kana loina ilikwai, yo tabe iwawalo iya tamana Yaubada yo iwawalo iya Yaubada mekanakava sitoyatoyawa. Kabo sikepate kaikaiwe nuwanuwali Yeisu siunuyamate. ");
INSERT INTO tte_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kabo Yeisu iwalo kolili iba, “Yawalo yawasosi kolimiu, Yaubada Natuna nige sowasowana ginauli yabo iboma ipaisowai, na ginauline bwaite igitaiya Tamana koina mwa tabe sowasowana ipaisowai. Kaiwena ginauline bwaite Tamana ipaipaisowaili mwa tabe Natuna ipaisowai besiele. ");
INSERT INTO tte_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tamana natuna imulolo koina, yo paisowa bwaite ipaisowaili meuloina iyakenayan natuna koina. Paisowane siya sauga bwaite nige ilalalaki, na tamana paisowa lalakisosina kani iyakenayan na ipaisowaili, ana paisowane koina kani katemiu iyapitali. ");
INSERT INTO tte_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kaiwena tamana toboita ikeleyatololi yo yawasili iwolegili kabo besiele tabe iya natuna yawasina iwolena tomo siya igitesipwaili kolili. ");
INSERT INTO tte_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yaboyoi tabe, tamana nige tomo yabo iyayatalayan, na yatala kana loina meuloina iwolena natuna koina, ");
INSERT INTO tte_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","na mesabana tomo meuloili natuna siyakasisiyani besiele Tamana siyakasisiyan. Yaiya tem natuna nige iyayakasisiyan, iya kana toyawasayamane nige iyayakasisiyan.” ");
INSERT INTO tte_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Yeisu iwaloyoi iba, “Yawalo yawasosi kolimiu, yaiya tem yagu walo ibenalan yo imeli kagu toyawasayaumane koina kani yawasi miyamiya yaina ilobai yo nige sowasowana loina kolokololona ilobai. Kani boita dedeina ilogabaen yo ilau yawasi miyamiya yaina koina. ");
INSERT INTO tte_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Yawalo yawasosi kolimiu, sauga iyaele ilalaoma yo tabe iyawatagilimako, kabo toboita Yaubada Natuna kainana sibenalan, yo siya tem kainana sibenalan yawasi sikalai. ");
INSERT INTO tte_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tamana iya yawasi yaina, kabo besiele tabe italamwan natuna iya yawasi yaina. ");
INSERT INTO tte_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Iya Tomo Natuna kabo tamana ipei iya tomo meuloili ali toyatala. ");
INSERT INTO tte_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tabu katemiu siwawakaka walone bwaite kaiwena. Sauga iyaele ilalaoma yo toboita siya salai mena kainana kani sibenalan, ");
INSERT INTO tte_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","kabo sitoloyoima kali salai mena. Siya ginauli namwanamwana sipaipaisowaili kani sitolo yawasi miyamiya yaina koina, na siya ginauli naenaena sipaipaisowaili kani sitolo loina kolokololona manna mena maisali kaiwena. ");
INSERT INTO tte_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nige sowasowana ginauli yabo yabomamo yapaisowai yagu nuwatu mena. Na yayatala-yagimiu besiele tawae Tamagu iwalowen koliyau, mwa yagu yatala idudulai. Kaiwena nige yakato yaboma yagu nuwatu mena yapaipaisowa, na iya kagu toyawasa ana nuwatu mena yapaisowa.” ");
INSERT INTO tte_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yeisu iwaloyoi Yudiya toloinao kolili iba, “Tem yabomayoi wasagu yayawasayan, kani ami nuwatu yakato yagu walo-masala nige walo yawasosi. ");
INSERT INTO tte_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Na yaboyoi tabe iyaele wasagu iwalo-masalanako yo yakatai walo bwaite iwalowen kaiwegu iyamala yawasosi, kabo ilonamwayagimiu yagu walo-masala wakawa-yawasosiyan. ");
INSERT INTO tte_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kaiwena beyabeyana tomo tupwali, bwaimwa topwaoli yo Palisiyao, kwayawasali silau Yoni Toyababitaiso koina yo saugana Yoni wasagu iwalowen iwalo yawasosi kolili. ");
INSERT INTO tte_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yau nige yanuwanuwatu yakato tomo yabo iyawasa kabo yagu wasa isagui yo iyamala yawasosi, na Yoni ana yawasa kaiwegu yawalowen kolimiu kaiwena nuwanuwagu kwameliyan na lebo kwalobai. ");
INSERT INTO tte_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yoni iya besiele lampa iwedoli tauna kona yo imayale, kabo sauga kubwakubwana koina nuwanuwamiu kwalau mayalenane koina na kwayaliyaya. ");
INSERT INTO tte_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Yagu paisowa kaikaiweli kilakilalali siyakenayagimiu yakato yaiya yau na siya ali walo-masala ilalakisosi kabo Yoni ana walo-masala. Na ginauline kaikaiweline yapaipaisowailine siwalo-masala yakato kagu toyawasa iya Tamagu. Kaiwena ginauline yapaipaisowailine Tamagu kaiwena. ");
INSERT INTO tte_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tabe Tamagu iya iyawasayau iya iboma wasagu iwalowalowen. Na kainana nige sauga yabo kwabebenalan, yo kana koleya nige wagigitai. ");
INSERT INTO tte_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ana walo nige wakakalaili yo kwamemeliyagili kaiwena nige kwamemeliyagau. ");
INSERT INTO tte_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Komiu Buki Tabu kwayasiyasili yo kwanuwanuwatui lalakina kaiwena ami nuwatu iya ana walo koina yakato yawasi miyamiya yaina kwalobai. Na Buki Tabu ana walo bwaite iwalowalo yau kaiwegu, ");
INSERT INTO tte_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","na komiu kwasikotanagau nige kwalalaoma koliyau na yawasi miyamiya yaina wakalai. ");
INSERT INTO tte_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nige yanuwanuwatu tomo ali tobali kaiwena, ");
INSERT INTO tte_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","na yakataimiu, yakatai Yaubada ana mulolo nige imiyamiya katemiu mena. ");
INSERT INTO tte_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Tamagu esana koina yalaoma na komiu kwasikotanagau. Na tem tomo yabo iboma esana koina ilaoma ee kani kwayaliyaya-yan. ");
INSERT INTO tte_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nuwanuwamiu tem kamikavao sitobalanagimiu na nige wakekepate Yaubada kana tobali kaiwena, iya Yaubada kaigeda-sosisosimo. Bwaite mumugamiune kaiwena nige sowasowamiu kwameliyagau. ");
INSERT INTO tte_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Tabu kwanuwanuwatu yakato yau kani yayakewaimiu Tamagu koina. Nigele, Mosese iya mwa kwabatoko yakato iya kami tosagu, kani sauga muli mena iyakewaimiu. ");
INSERT INTO tte_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tem kwameliko Mosese ana walo koina sowasowana kwameli tabe koliyau kaiwena ilelelele kaiwegu. ");
INSERT INTO tte_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Na nige sowasowamiu sauga bwaite yagu walo kwameliyan kaiwena Mosese ana lelelele nige kwamemeliyan.” ");
INSERT INTO tte_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kabo muli mena Yeisu iyaele Galili dedeina mena kabo kalita Galili ilopanaisi. Na kalita Galili esana labuina waila Taibiliya. ");
INSERT INTO tte_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kabo boda lalakina Yeisu siyamuli kusuli kaiwena ana paisowa kaba nuwapwanopwano siya tokasiebwa sibaibaiwa iwoisili sigitaili. ");
INSERT INTO tte_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yeisu ikawasae koya mena yo me ana tobenaliyao simiyasio. ");
INSERT INTO tte_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Sauganane koina, tomo Yudiya ali mwalelikwa soina ikelakubwamako. ");
INSERT INTO tte_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yeisu manna ilau boda lalakina igitaili silalaoma koina, mwa iwalo Pilipi koina iba, “Kani toweya kali tagimwalaiya na bodane bwaite tayakanli?” ");
INSERT INTO tte_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yeisu iwalo besiele bwaite kaiwena nuwanuwana Pilipi itonan. Na Yeisu ikataiyako tawae kani iginauli. ");
INSERT INTO tte_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipi Yeisu kainana iyamaisa iba, “Nuwana mane siliba kana baibaiwa tu andeledi takalai na beledi tagimwalai na nuwana tatabe-kivikivi kikiuna kikiuna tayauyan, na kani nige sowasowana meuloiline silobai.” ");
INSERT INTO tte_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yeisu ana tobenali yabo esana Anidulu, iya Saimon Pita kanakava, iwaloba, ");
INSERT INTO tte_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Bwaite gamene kana beledi esana bali kali baibaiwa paibi yo kana iye kikiuli labui. Na iyamo tomo meuloili bwaite kani nige sowasowali.” ");
INSERT INTO tte_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kabo Yeisu iwalo ana tobenaliyao kolili iba, “Kwawalo tomo meuloili simiyasio bwaine dedeinane koina kawasine ana kaba kin namwanamwane koina.” Siginauli besiele kabo tomo meuloili simiyasio kawasi pwatana mena. Tomo kali baibaiwa nuwana besiele paibi tausan. ");
INSERT INTO tte_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kabo Yeisu beledine ikalaili yo ikawatoki Yaubada koina, yo muli mena iwolegili ana tobenaliyao kolili na siyauyagili tomo siya tomiyasiyone kolili. Iye ikalaili yo tabe iginauliyoi besiele. Kabo tomo sikekan kanasiga kali liye silobai. ");
INSERT INTO tte_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Saugana sikekan yo meuloili diyali sisu, mwa Yeisu iwalo ana tobenaliyao kolili iba, “Kantele meuloina kwatano-gogonan, tabu yabo mosomosona kwalologabaen.” ");
INSERT INTO tte_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kabo kantele meuloina sitano-gogonan yo kodo kali baibaiwa tuwelo sitauli sikalapowon kantelene ilaomaya beledine kali baibaiwa paibi kolili. ");
INSERT INTO tte_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kabo tomo siya Yeisu ana paisowa ginauli kaba nuwapwanopwano sigitai siwaloba, “Walo yawasosi iya palopitawa tasanasanaiwa ilaomako.” ");
INSERT INTO tte_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yeisu ikataiyako tomo nuwanuwali silaoma koina na sisamalului tem iyamala ali kin, mwa ilogabaegili ibomamo ilau ikawasaeyoi koya mena. ");
INSERT INTO tte_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Saugana dabwelo isusugu, Yeisu ana tobenaliyao silobi kalita Galili koina, ");
INSERT INTO tte_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","simwalisae waga mena yo sikuke sipapanaisi Kapeneomi. Saugana iboniyai, Yeisu nige naga ipipileyoi kolili. ");
INSERT INTO tte_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yaumai kaikaiwena ilotalu yo kalita ibagolu. ");
INSERT INTO tte_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kabo siwosewose tupwana kali mwayaga imamalawe besiele paibi o sikisi kilomita kabo Yeisu sigitai ilalaoma kalita pwatana mena wagane kaiwena, kabo simatausi lalakina. ");
INSERT INTO tte_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Na Yeisu iwalo kolili iba, “Tabu kwamamatausi, koyau.” ");
INSERT INTO tte_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kabo me ali yaliyaya Yeisu imwalisae waga mena yo mwayamwayau siulisi dedeinane koina nuwanuwali silalauwa. ");
INSERT INTO tte_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","24","Yanuwa ilayan Yeisu me ana tobenaliyao siyaele Kapeneomi, na bodane paibi tausanwa siyaelemo simiyamiya Galili dedei yabo mena dedeinane koina Guyau iyayakanliwa. Siyaelemo dekawa mena Yeisu sisanasanai, kaiwena sikatai laina waga kaigeda imiyamiya magu mena yo tabe sikatai saugana tobenaliyao waga mena simwalisae yo sikuke Yeisu nige mekalikava. Saugana bodane sikatai Yeisu bwaine koina nigele kabo sitonan tem kamwasa siloyai na silopanaisi Kapeneomi Yeisu kaiwena. Kabo waga tupwali silaoma siulisi. Na wagane silaomaya yanuwa Taibiliya koina. Kabo bodane simwalisae wagane kolili yo silopanaisi Kapeneomi. ");
INSERT INTO tte_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Saugana bodane siulisi Kapeneomi Yeisu bwaine koina silobai. Kabo siwalo koina siba, “Toyakayakatai, tawanesana kulalaoma bwaite koina yo gubesi am laolaoma?” ");
INSERT INTO tte_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yeisu kainali iyamaisa iba, “Yawalo yawasosi kolimiu, nige yakato ginauli kaba nuwapwanopwano yapapaisowaiwa wagitai mwa kaiwena kwaloyaloyaiyau, na beledi bwaite yaeyawa wakan na diyamiu sisu kaiwena mwa kwaloyaloyaiyau. ");
INSERT INTO tte_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tabu kwapapaisowa kaiwesosi beledine naga kani inae kaiwena. Na iyamo kwapaisowa kaiweya beledi miyamiya yainane bwaimwana Tomo Natuna kani iyeyawa kolimiu. Kaiwena Yaubada kawa-namwanamwa ipeiyako Natunane koina.” ");
INSERT INTO tte_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kabo bodane sineli Yeisu koina siba, “Na tawae Yaubada nuwanuwana kapaisowai?” ");
INSERT INTO tte_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Kainali iyamaisa iba, “Paisowane bwaite besiele, Yaubada nuwanuwana iya iyawasayauma kwameliyan.” ");
INSERT INTO tte_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Kabo tomo siwalo Yeisu koina siba, “Ginauli kaba nuwapwanopwano yabo uginauli kabo kagitai na mesabana kameli-yagiwo. Tubumayao beyabeyana beledi bwaite mana sikekan ule mena, besiele Buki Tabu ana walo iba, ‘Beledi ilobimaya bulibuli mena iwolena sikan.’ Na tawae kowa kani uginauli?” ");
INSERT INTO tte_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Mwa Yeisu iwalo kolili iba, “Yawalo yawasosi kolimiu, nige yakato Mosese beledine ilobimaya bulibuli mena iyeyawa kolimiu na Tamagu beledi yawasosi ilobimaya bulibuli mena sauga bwaite iyeyawa kolimiu. ");
INSERT INTO tte_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Na beledi bwaite Yaubada iyeyawa ilobimaya bulibuli mena bwaimwa iya mwa yawasi miyamiya yaina iwolena tomo yanuwa yaulina kolili.” ");
INSERT INTO tte_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Kabo siwaloba, “Taubala, beledine bwaite kuyeyama kolimai kaliyate kaigeda kaigeda.” ");
INSERT INTO tte_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yeisu iwalo kolili iba, “Na yau yawasi miyamiya yaina beledina. Yaiya tem ilaoma koliyau kani nige sowasowana iguliyam yo yaiya tem imeliyagau nige sowasowana galogalona imaguyoi sauga yabo. ");
INSERT INTO tte_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Na besiele tabe yawaloko kolimiu, wagiteyauko na iyaele nagamo nige kwamemeliyagau. ");
INSERT INTO tte_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Analiyao tomo siya Tamagu iyelimako koliyau kani silaoma koliyau, nige sowasowana yasikotanagili. ");
INSERT INTO tte_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kaiwena yau yalobimaya bulibuli mena nige yakato yaboma yagu nuwatu yapaisowai na iya iyawasayauma ana nuwatu yapaisowai. ");
INSERT INTO tte_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Mwa bwaite Tamagu ana nuwatu, yakato tabu yabo yayayakwalalele siya tomone iyelimako koliyau, na kaliyate mwawamwawasina koina yakele-yatololi boita koina. ");
INSERT INTO tte_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kaiwena Tamagu ana nuwatu bwaite besiele, analiyao tem sigitaiyau yo simeliyagau yawasili miyamiya yaina silobai, yo sauga ana kaba mwawasi koina boita mena yakele-yatololi.” ");
INSERT INTO tte_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Saugana Yeisu iwaloba, “Yau beledi bwaite ilobimaya bulibuli mena”, tomo Yudiya walo bwaite kaiwena siyatubu sibalabalamumu. ");
INSERT INTO tte_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Siba, “Tomone iya Yeisu, Yosepa natuna, tamana yo sinana takataili, awa? Na gubesi na iba, ‘Yau yalobimaya bulibuli mena’?” ");
INSERT INTO tte_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yeisu iwalo kolili iba, “Kwamwanou, tabu kwabomayoi kwabalabala-mumu luwamiu mena. ");
INSERT INTO tte_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nige sowasowana yabo ilaoma koliyau bwaimwanamo Tamagu iya iyawasayauma kaiwe iwolena koina na ilaoma koliyau. Na kaliyate ana kaba mwawasi koina kani boita mena yakele-yatoloyoi. ");
INSERT INTO tte_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Palopitao silele siba, ‘Yaubada kani ginauli meuloina iyakenayagili.’ Kabo siya analiyao Tamagu ana walo sibenalan yo ali katai sikalai koina, kani meuloili silaoma koliyau. ");
INSERT INTO tte_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nige tomo yabo Tamagu igigitai, na iyamo iya ilaoma koina iyamo igitai. ");
INSERT INTO tte_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Yawalo yawasosi kolimiu, yaiya tem imeli koliyau, iya yawasi miyamiya yaina ikalaiyako. ");
INSERT INTO tte_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yau yawasi miyamiya yaina beledina. ");
INSERT INTO tte_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tubumiyao beledi bwaite mana sikan ule mena na iyamo siboita. ");
INSERT INTO tte_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Na beledi bwaite ilobimaya bulibuli mena tem tomo sikan kani nige sowasowana siboita. ");
INSERT INTO tte_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yau yawasi miyamiya yaina beledina bulibuli mena yalobimaya. Tem yaiya tomo beledine bwaite ikan, kani yawasina imiyayai sauga meuloina. Bwaite beledine iya bulumagu, iya kani yatalamwan na tomo meuloili yanuwa yaulina mena yawasili miyamiya yaina silobai.” ");
INSERT INTO tte_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tomo Yudiya walone bwaite sibenalan kabo sibomayoi sigamwapakiki lalakina siba, “Tomone gubesi mwa bulumana iyeyama takan?” ");
INSERT INTO tte_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yeisu iwalo kolili iba, “Yawalo yawasosi kolimiu, tem Tomo Natuna bulumana nige wakakan yo kwasinena nige kwanunuma kani nige yawasimiu imiyamiya. ");
INSERT INTO tte_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yaiya tem bulumagu ikan yo kwasinegu inuma iya yawasina miyamiya yaina ilobaiyako yo kaliyate mwawamwawasina koina kani yakele-yatoloyoi boita mena. ");
INSERT INTO tte_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kaiwena bulumagu iya kan yawasosi yo kwasinegu iya waila yawasosi. ");
INSERT INTO tte_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yaiya tem bulumagu ikan yo kwasinegu inuma, iya imiyamiya koliyau yo yau yamiyamiya koina. ");
INSERT INTO tte_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tamagu iya meyawasina iyawasayau yo iya koina yawasigu yakalakalai. Kabo besiele tabe, yaiya tem bulumagu ikan, iya kani yawasina koliyau ikalakalai. ");
INSERT INTO tte_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yawalowalo bwaite beledine ilobimaya bulibuli mena kaiwena. Manane tubumiyao sikan ule mena siboita. Na yaiya tem beledi bwaite ilobimaya bulibuli mena kaiwena yawalowalo ikan kani yawasina imiyayai sauga meuloina.” ");
INSERT INTO tte_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yeisu walo bwaite iwalowen yanuwa Kapeneomi koina saugana iyakayakatai nume tapwalolo mena. ");
INSERT INTO tte_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Sauganane tomuliyayao Yeisu ana walo beledi kaiwena sibenalan, mwa sibaibaiwa sibomamo siwaloba, “Walo bwaite kana benali ipolowesosi, kita genuwala.” ");
INSERT INTO tte_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yeisu ikataiyako tomuliyayaone sibalabalamumu ana walone kaiwena mwa iwalo kolili iba, “Tawae kaiwena yagu walone bwaite kaiwena kwamunamunai? ");
INSERT INTO tte_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Na gubesi, tem ginauli kaba nuwapwanopwano wagitai o nuwana tem Tomo Natuna isaeyoi bulibuli mena, bwaimwa beyabeyana imiyamiya koina, kani yagu walone kwameliyan? ");
INSERT INTO tte_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yaubada yaluyaluwana sowasowana yawasi iwolena tomo kolili, tomo sibomamo nige sowasowali. Yaubada yaluyaluwana yo yawasina siya mwa yagu walone yayapanaisanako kolimiu. ");
INSERT INTO tte_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Na komiu tupwamiyao nige kwamemeli.” Yeisu iwalo besiele kaiwena beyabeyana ikataiyako analiyao siya nige simemeliyan yo yaiya iya bwaite kani iwalo-masalan Yudiya toloinao kolili. ");
INSERT INTO tte_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yo Yeisu iwaloyoi iba, “Yagu walo kana katai bwaite besiele. Nige sowasowana yabo ilaoma koliyau bwaimwanamo Tamagu kaiwe iwolena koina na ilaoma.” ");
INSERT INTO tte_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Sauga bwaite koina Yeisu ana tomuliyayao sibaibaiwa sipileyoi yo nige tabe simumuliya yoi. ");
INSERT INTO tte_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kabo Yeisu itagelakeile yo ana tobenaliyao yoli tuwelo kolili iba, “Na komiu, nuwanuwamiu tabe kwalau?” ");
INSERT INTO tte_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon Pita Yeisu kainana iyamaisa iba, “Guyau, yaiya kani koina kalalaune? Kowa koliwo walo miyamiya yaina. ");
INSERT INTO tte_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kakataiyako mwa kameli yakato kowa Yaubada ana tomo yakayakasisina.” ");
INSERT INTO tte_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Kabo Yeisu iwalo kolili iba, “Na yau yomiu tuwelone yagitesipwaimiuko, awa? Na luwamiu mena kaigeda iya Seitani gamwana kana tokabi.” ");
INSERT INTO tte_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yeisu iedeedede Yudasa iya Saimon Isikaliota natuna kaiwena. Mwa bwagana iya yoli tuwelone kalikava yabo na iyamo kani Yeisu iwalo-masalan Yudiya toloinao kolili. ");
INSERT INTO tte_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kabo muli mena Yeisu itakitakikili dedei Galili kalona mena. Nige nuwanuwana ilau dedei Yudiya kalona mena yaina kaiwena Yudiya ali toloinao nuwanuwali siunuyamate. ");
INSERT INTO tte_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na Yudiya ali soi lalakina yabo esana sipei Gwau Soi kana sauga ikelakubwamako. ");
INSERT INTO tte_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Na Yeisu ana susu bwaimwa kanakavao yawasosi sigitai kana tomuliyayao nige sibabaibaiwa kabo sitalawasiyan siwalo Yeisu koina siba, “Dedei bwaite kulogabaen na kusae Yelusalema Yudiya dedeina kabo am tomuliyayao am paisowa ginauli kaba nuwa pwanopwano kupaipaisowaili na sigitagitaili. ");
INSERT INTO tte_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tem tomo yabo nuwanuwana wasana ilalaki na boda sikatai, nige sowasowana ana paisowa ipaisowa wadam. Ginauli kaba nuwapwanopwano sibaibaiwa kupaisowaili mayale mena na tem tomo meuloili yanuwa yaulina mena sigitaili kabo esam ilalaki.” ");
INSERT INTO tte_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bwagana iya kanakavao, na nige simemeli koina. Ali nuwatu besiele tomo meuloili ali nuwatu. ");
INSERT INTO tte_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Koinaele Yeisu iwalo kanakavao kolili iwaloba, “Yagu sauga yawasosi nige naga ilalaoma. Na komiu bwaite ami sauga saugane meuloina. ");
INSERT INTO tte_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tomo meuloili nige sikakalomagigi-lagimiu, na yau sikalomagigi-lagau kaiwena ali nae yawalo-masalan kolili yo yayakenayagili. ");
INSERT INTO tte_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Komiu kwalau Yelusalema soine kaiwena. Na yau kani nige yalalau bwaite sauga, kaiwena yagu sauga naga ilalaoma.” ");
INSERT INTO tte_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yeisu walo bwaite iwalowen kanakavao kolili, mwa nige ilalau na imiyamiya Galili. ");
INSERT INTO tte_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yeisu kanakavao silau soine kaiwena, iya mulili mena kabo ilau, na nige iuutu-mayale, ilolowadawadam-yagili. ");
INSERT INTO tte_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Soi kalona mena Yudiya ali toloinao Yeisu siloyaloyai yo sinelineliyan siba, “Iya toweya?” ");
INSERT INTO tte_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Boda luwali mena tomo sibaibaiwa siedeedede Yeisu kaiwena. Tupwaliyao siwaloba, “Iya tomo namwanamwana,” na tupwaliyaoyoi siba, “Nigele, iya tomwakota yo tomo iwoyawoya-pwanolili.” ");
INSERT INTO tte_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Na nige yabo nuwanuwana iedeedede tomo manli mena kaiwena tomo meuloili simatausi Yudiya toloinaone kolili. ");
INSERT INTO tte_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Soi bwaite luwaluwalina mena, kabo Yeisu ilau ilusae Nume Tabu mena kabo ilau kaba yakayakatai ana dedei koina yo iyatubu iyakayakatai. ");
INSERT INTO tte_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yudiya ali toloinao kateli sipitali ana yakayakatai kaiwena kabo siba, “Tomo bwaite iya nige isisikulu, na gubesi mwa ana sonoga ilalaki?” ");
INSERT INTO tte_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yeisu kainali iyamaisa iba, “Yagu yakayakatai bwaite nige yaboma yagu nuwatu mena, na ilaomaya kagu toyawasayauma koina. ");
INSERT INTO tte_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tem tomo yabo nuwanuwana Yaubada ana nuwatu ipaisowai kani igite-lobai yagu yakayakataine ilaomaya Yaubada koina na nige ilalaoma yaboma yagu nuwatu mena. ");
INSERT INTO tte_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Walo yawasosi, tem tomo yabo iedeedede iboma ana nuwatu mena, iya nuwanuwana iboma kana tobali ipaisowai na esana ilalaki. Na iya ipaisowai kana toyawasa kana tobali kaiwena iya towalo-yawasosi yo nige mwakota koina. ");
INSERT INTO tte_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosese loinaone iyeliwa kolimiu, wa? Na nuwanuwamiu kwaunuyamateyau mwa kaiwena yawalo yakato nige yabo luwamiu mena Mosese ana loinaone ioobigaili.” ");
INSERT INTO tte_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Toloinao boda Yeisu kainana siyamaisa siwaloba, “Nuwana yaluyaluwa biki ilusae koliwo mwa kuwalowalo bwaite besiele. Yaiya nuwanuwana iunuyamatewo?” ");
INSERT INTO tte_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Kabo Yeisu iba, “Yau tobelu yabo yawoisi Sabati mena kabo meuloimiu katemiu sipitali. ");
INSERT INTO tte_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Komiu kwawalo tabu paisowa Sabati. Na tem natumiyao kali nigwenigwe kana kaliyate iyawatagili Sabati yabo koina kani kwatalam na nigwenigwe sikalai kaiwena nuwanuwamiu lalakina tem Mosese ana loina kwamuliya. Nigwenigwe mumugana Mosese nige iyayatubu, na ilaomaya tubumiyao bagubagunasosili kolili. Na tawae kaiwena kwamunamunai koliyau saugana tobelune yona meuloina yawoisi Sabati mena? ");
INSERT INTO tte_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tabu yagu paisowane kaiwena kwanunuwatu-bwagabwaga yakato kwayakewaiyau. Na ilonamwayagimiu tem kwanuwatu-namwanamwa yo kwaloina dudulai kabo wakatai yakato yagu paisowane idudulai Yaubada manna mena.” ");
INSERT INTO tte_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tomiya Yelusalema tupwaliyao siba, “Tomo bwainene iya toloinao sitonatonan yakato tem siunuyamate, wa? ");
INSERT INTO tte_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Na wagitai. Iedeedede tomo manli mena na toloinaone ana walo nige situtupa-kaukausi. Gubesi, nuwana toloinao ali nuwatu yawasosi yakato iya Mesaiya? ");
INSERT INTO tte_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tem Mesaiya ilaoma nige sowasowana tomo sikatai toweya ilaomaya. Na Yeisu kita takataiyako toweya ilaomaya, mwa iya nige Mesaiya.” ");
INSERT INTO tte_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yeisu iyaelemo iyakayakatai Nume Tabu koina, kabo kainana lalakina mena iwaloba, “Na gubesi, ami nuwatu yakato wakataiyau na tabe wakatai toweya koina yalaomaya? Nuwana nigele. Nige yau yaboma yagu nuwatu mena yalalaoma, na Tamagu iyawasayau kabo yalaoma. Iya mumugana inamwanamwa. Iya nige wakakatai, ");
INSERT INTO tte_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","na yau yakatai, kaiwena iya iyawasayau mwa yalaoma kolimiu.” ");
INSERT INTO tte_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yeisu iwalo besiele, kabo Yudiya toloinao nuwanuwali yakato silokalatan yo sipan, na nige sowasowana tomo yabo nimana ipei yona mena kaiwena ana sauga nige naga iyayawatagilima. ");
INSERT INTO tte_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Yo boda luwali mena tomo sibaibaiwa simeli Yeisu koina, yo siwalo siba, “Na tem tomo uloina iyawatagilima yakato iya Mesaiya, gubesi, sowasowana ana paisowa kaikaiweli Yeisu ana paisowa kaikaiweli silalaki-gabaegili? Nuwana nigele. Mwa koinaele ama nuwatu yakato Yeisu iya Mesaiya.” ");
INSERT INTO tte_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tomo ali walone bwaite kaiwena mwa Palisiyao sibenalan. Kabo Palisiyao yo topwaoli lalakili simiyagogo siedeedede kabo siloina yakato pilisiman, siya Nume Tabu kana togitekalatanwo, silau yakato Yeisu sikabikalatan na sipan. ");
INSERT INTO tte_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kabo Yeisu iwaloba, “Yagu miyamiya mekaukavao komiu sauga kubwakubwana, kabo muli mena kani yalogabaegimiu yo yapileyoi yalau toyawasayaumane koina. ");
INSERT INTO tte_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kani kwaloyaiyau, na kani nige kwalolobaiyau kaiwena dedeine bwaite yalalaune koina nige sowasowana kwalaoma koina.” ");
INSERT INTO tte_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yudiya ali toloinao walone bwaite sibenalan kabo sibomamo sitalatalawasi siba, “Tomone iya toweya ilalauya yakato kani taloyai na nige talolobai? Nuwana kani ala dedei ilogabaen yo ilau Giliki ali dedei kolili toweya siya Yudiya tupwaliyao simiyamiya na tem siya yo Giliki tomoliyao iyakayakataili? ");
INSERT INTO tte_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Iwaloba, ‘Tem kwaloyaiyau kani nige kwalolobaiyau.’ Na gubesi kana katai? Tabe besiele iwaloba, ‘Nige sowasowamiu kwalau dedei bwainene yalalaune koina.’ Walone bwaite kaiwena kaba nuwapwanopwano yawasosi kolila.” ");
INSERT INTO tte_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Gwau soina kana kaliyate mwawamwawasina koina, iya kaliyate lalakisosina, Yeisu itolo yo iwalo kainana lalakina mena iba, “Yaiya kowa tem galogalom imagu ilonamwayagiwo kulaoma koliyau kunuma. ");
INSERT INTO tte_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tem kumeli koliyau kulaoma na kunuma. Kaiwena Buki Tabu iwalo-masala yakato waila yalubwasi meyawasina kani ididi-yawatagilima siya analiyao simeli koliyau.” ");
INSERT INTO tte_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Saugana Yeisu iwalo ‘waila yalubwasi meyawasina’ iedeedede Yaluyaluwa Tabuna kaiwena, analiyao tomo simeli Yeisu koina kani sikalai. Na sauganane koina Yaluyaluwa Tabuna nige naga iwowolegili, kaiwena Yeisu nige naga itotoloyoi boita mena yo naga ana wasawasa ikakalai. ");
INSERT INTO tte_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Boda lalakina meuloina Yeisu ana walo sibenalan mwa sibaibaiwa siba, “Walo yawasosi, tomone bwaite Yeisu iya palopitawa Yaubada iwaloyameli kani ilaoma.” ");
INSERT INTO tte_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","42","Tomo tupwaliyao siba, “Iya Mesaiya.” Na tupwaliyaoyoi siba, “Kita takataiyako Buki Tabu ana walo iwaloba, ‘Mesaiya kani ilaoma Deibida ana susu koina yo sikabi Bedeliema, dedei bwaimwa beyabeyana Deibida imiyamiya koina.’ Na Yeisu iya Galili tomona, nige sikakabiyan Bedeliema, mwa iya nige Mesaiya.” ");
INSERT INTO tte_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kabo Yeisu kaiwena boda labui siyakasa. ");
INSERT INTO tte_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tupwali nuwanuwali sikabi-kalatan yo sipan, na iyamo nige tomo yabo nimana ipepei Yeisu yona mena. ");
INSERT INTO tte_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kabo pilisimanwo siya Nume Tabu kana togitekalatanwo sipileyoi silau topwaoli lalakili mekalikavao Palisi kolili kabo siya siwalo pilisiman kolili siba, “Tawae kaiwena nige wakakalaiyama?” ");
INSERT INTO tte_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mwa kainali siyamaisa siba, “Nige sauga yabo tomo yabo ana walo besiele tomone bwaite ana walo.” ");
INSERT INTO tte_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Kabo Palisi me ali munamunai siwalo pilisimanwo kolili siba, “Imwakota tomo meuloili kolili na sauga bwaite ana mwakota kolili ikalaimiu tabe. ");
INSERT INTO tte_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kai Palisi mekamakavao toloinao nige tomonane kamemeliyan. ");
INSERT INTO tte_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nigele molosi. Na boda bwaite simeliko koina siya Mosese ana loina nige sikakatai, siya Yaubada iwaloko kaiweli kani iyamaisali.” ");
INSERT INTO tte_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimo, iya Palisi ali boda yabo yo iya beyabeyana ilau Yeisu koina boniyai mena, iwalolau kanakavao kolili iba, ");
INSERT INTO tte_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ala loina iba tabu tomo kana loina tagiginauli tem nige naga ana edeedede tabebenalan yatala koina yo talolobai ginauli tawae ipaisowa-yanaeli.” ");
INSERT INTO tte_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Na Palisiyaone Nikodimo siyokoiyan siba, “Na gubesi, nuwana kowa tabe kulaomaya Galili? Kulau naga Buki Tabu ukwalai kuyasili namwanamwai kabo ukwatai yakato kani nige palopita yabo ilalaomaya Galili.” ");
INSERT INTO tte_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tomo meuloili sipileyoi silau ali nume kaigeda kaigeda kolili, na Yeisu ilau ikawasae koya Olibe koina. ");
INSERT INTO tte_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Yanuwa ilayanyoi malala kikiuna, Yeisu ipileyoi ilau Nume Tabu mena kaba yakayakatai dedeina mena, mwa boda silaoma simiya-takikilan, yo iya imiyasio iyakayakatai kolili. ");
INSERT INTO tte_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Loina kana toyakayakataiwo mekalikavao Palisiyao sine yabo siyogan mekalikava silusae. Na sinene bwaite silobai iganaganawali kabo silawanama boda manli mena siyatolo. ");
INSERT INTO tte_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Mwa siwalo Yeisu koina siba, “Toyakayakatai, sine bwaite kalobai tau yabo mekanakava siganawali. ");
INSERT INTO tte_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na Mosese ana loina koina iba sine ganaganawalina besiele bwaite talovekui kanasiga iboita. Na kowa am nuwatu gubesi?” ");
INSERT INTO tte_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Neli bwaite sineliyan yakato Yeisu sitonan na tem siyakewai. Na Yeisu nige kainali iyayamaisa na ipwalou yo nima gibuna mena ilelelele bwatano mena. ");
INSERT INTO tte_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Siya siyaelemo simiyamiya na sinelineli koina, mwa itolo yo iba, “Tem yaiya kolimiu nige sauga yabo nae igiginauli, iya veku ikalai igabae-bagunayan sinene koina.” ");
INSERT INTO tte_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kabo tabe ipwalouyoi yo ileleleleyoi bwatano mena. ");
INSERT INTO tte_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ana edeedede bwaite sibenalan mwa kaigeda kaigeda ilaulau iyatubuya tautaubalao kolili ilau kanasiga meuloili silowasi-woli. Yeisu ibomamo silogabaen mekanakava sinene bwaite itotolo salina mena. ");
INSERT INTO tte_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yeisu itoloma yo ineli sinene koina iba, “Kam toyakewao meuloili toweya siyaele?” ");
INSERT INTO tte_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Sinene Yeisu kainana iyamaisa iba, “Taubala, nige yabo imiyamiya, meuloili silowasiko.” Kabo Yeisu iba, “Yau tabe kani nige yayayakewaiwo. Na kulau, tabu sauga yaboyoi naenaena ugiginauliyoi.” ");
INSERT INTO tte_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Sauga yabo koina Yeisu iwalo tomo kolili iba, “Yau yanuwa yaulina kana mayale. Tem yaiya imuliya koliyau kani yawasi kana mayale ikalai yo nige sowasowana ilokeikeile boniboniyai koina.” ");
INSERT INTO tte_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kabo Palisi siwalo koina siba, “Kuboma yakato wasam kuyawasayan, kani nige sowasowana kameliyagiwo.” ");
INSERT INTO tte_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yeisu Palisi kainali iyamaisa iba, “Bwaite walone yawalowen walo yawasosi, bwagana yaboma kaiwegu yawalo-masala. Kaiwena yakatai toweya koina yalaomaya yo toweya koina yalalau, na komiu nige wakakataiyau. ");
INSERT INTO tte_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Komiu tomo kwayatalayagili besiele tomo yanuwa yaulina ali nuwatu. Na yau nige yagiginauli besiele. ");
INSERT INTO tte_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Na tem tomo yabo yayatalayan yo kana loina yawalowen yagu loina idudulai yo iyamala yawasosi, kaiwena nige yaboma loinane bwaite yagiginauli, na Tamagu iya iyawasayau iya mekaukava. ");
INSERT INTO tte_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Komiu ami loina koina silele-lobiyen yakato tem tomo labui ali walo sitoyatoyawa kabo toyatala kani walone ikawa-yawasosi. ");
INSERT INTO tte_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yau yaboma wasagu yayawasayan, besiele Tamagu iya iyawasayau iya tabe wasagu iyawayawasayan.” ");
INSERT INTO tte_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kabo Yudiya toloinao Yeisu sineliyan siba, “Na tamam toweya?” Kainali iyamaisa iba, “Yau nige wakakataiyau yo Tamagu tabe nige wakakatai. Tem wakataiyau, tabe Tamagu wakatai.” ");
INSERT INTO tte_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yeisu walo bwaite iwalowegili, saugana iya iyaele iyakayakatai Nume Tabu kalona mena, dedei bwaine mulolo kaba peipeina salina mena bwaimwa toloinao ali kaba miyagogo dedeina salina mena. Na nige toloina yabo Yeisu ikakabikalatan na sipan, kaiwena ana sauga nige naga iyayawatagili. ");
INSERT INTO tte_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yeisu iwaloyoi Yudiya toloinao kolili iba, “Yalalau yo kani kwaloyaiyau. Na iyamo kani nige wagigitaiyau kaiwena komiu nige sowasowamiu yagu kaba lau dedeinane koina kwalaoma, na komiu kwalalau naenaena koina mwa kani kwaboita.” ");
INSERT INTO tte_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Kabo Yudiya toloinao sibomamo siedeedede siba, “Iya iba kita nige sowasowala talau dedeine ilalaune koina. Ana walo bwaite kana katai gubesi? Nuwana kani ibomayoi iunuyamate na ilau toboita ali dedei mena.” ");
INSERT INTO tte_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yeisu ali nuwatu ikataiyako kabo iwalo kolili iba, “Komiu kwalaoma yauli mena, na yau yalaoma kewa mena. Komiu yanuwa yaulina bwaite tomonliyao, na yau nige yanuwa yaulina tomona besi. ");
INSERT INTO tte_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Bwaite iya kaiwena yawaloba ami naenaena koina kani kwaboita. Tem yagu walone kaiwegu nige kwamemeliyan kani ami naenaena koina kwaboita.” ");
INSERT INTO tte_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kabo toloinaone siwalo koina siba, “Kuwalo kolimai yaiya kowa.” Kainali Yeisu iyamaisa iba, “Besiele tauna kona yawalowenako kolimiu. ");
INSERT INTO tte_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ginauli sibaibaiwa sowasowagu yawalowen kaiwemiu yo maisamiu yaginauli na nige yawawalowegili. Kaiwena iya iyawasayau iya towalo yawasosi yo ginauli bwaite yabenalagili koina mwa yawalowen yanuwa yaulina tomonliyao kolimiu.” ");
INSERT INTO tte_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Na iyamo nige naga sikakatai tawae Yeisu iwalowalowen kolili tamana kaiwena. ");
INSERT INTO tte_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kabo Yeisu iwaloba, “Saugana Tomo Natuna wakeleisin kelose mena kabo kani wakatai yakato yau yaiya. Yo tabe kani wakatai nige ginauli yabo yaboma yapapaisowai na iya Tamagu iyakenayagau mwa yawalowalowen. ");
INSERT INTO tte_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na iya iyawasayau iya mekaukava. Iya nige ilologabaegau, ginauli meuloina bwaite yapaipaisowailine iyaliyaya kaiweli.” ");
INSERT INTO tte_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Na siya tomo Yudiya Yeisu ana yakayakatai sibenabenalan sibaibaiwa simeliyan. ");
INSERT INTO tte_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kabo Yeisu iwalo siya tomo Yudiya ana yakayakatai simeliyan kolili iba, “Tem kwameli yagu yakayakataine koina yo wakabikalatan, komiu kagu tomuliya yawasosi. ");
INSERT INTO tte_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kabo kani wasa namwanamwana kaiwegu wakatai yakato walo yawasosi yo walo yawasosine iya kani ilivasimiu.” ");
INSERT INTO tte_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mwa Yeisu kainana siyamaisa siba, “Kai Abelamo tubunao, nige sauga yabo kapapaisowa besiele topaisowa panpanli. Gubesi mwa kuwaloba ‘walo yawasosine kani ilivasimiu?’” ");
INSERT INTO tte_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yeisu iwalo kolili iba, “Yawalo yawasosi kolimiu, tomo meuloili siya naenaena siginaginauli siya naenaena kana topaisowa panpanli. ");
INSERT INTO tte_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Topaisowa panpanna nige imimiyasosi ana taubala ana susuyao mekanakavao, na taubalane natuna iya imiyayai susune kolili. ");
INSERT INTO tte_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Na tem Yaubada Natuna ilivasimiu kani kwaemala tomo livalivasili yawasosi. ");
INSERT INTO tte_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yakatai komiu Abelamo tubunao. Na komiu tupwamiyao nuwanuwamiu kwaunuyamateyau kaiwena yagu yakayakatai kwasikotanan. ");
INSERT INTO tte_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Tawae Tamagu iyakenayagau yaginauli na komiu waginauli besiele tamamiu Seitani iyakenayagimiu.” ");
INSERT INTO tte_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Kabo kainana siyamaisa siba, “Kai tamamai Abelamo.” Yeisu iba, “Tem Abelamo natunao komiu sowasowana ami paisowa besiele Abelamo ana paisowa. ");
INSERT INTO tte_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Tawae yabenalan Yaubada koina iya walo yawasosi mwa yawalowen kolimiu. Komiu nuwanuwamiu kwaunuyamateyau, na Abelamo mumugana nige besiele mumugamiu, iya nige tounuyamate, mwa kaiwena komiu nige Abelamo natunao besi. ");
INSERT INTO tte_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Na komiu kwapaipaisowa tamamiu Seitani ana paisowa.” Kabo Yeisu kainana siyamaisa siba, “Tabu kuwawalo yakato kai tamamai uloina. Kaiwena kai tamamai ele mwa Yaubada iboma yo kai natunao yawasosi.” ");
INSERT INTO tte_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Kabo Yeisu iwaloyoi kolili iba, “Tem nuwana Yaubada iya tamamiu kani kwamulolo koliyau, kaiwena yau yamiyamiya koina yo yalaomaya koina. Na yau nige yaboma yagu nuwatu mena yalalaoma, iya iyawasayauma. ");
INSERT INTO tte_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Yagu walo nige nuwamiu idududulai-yan, kaiwena nige nuwanuwamiu yagu walone kwabenalan. ");
INSERT INTO tte_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Komiu tamamiu Seitani, iya natunao komiu mwa sauga meuloina nuwanuwamiu tamamiu ana nuwatu kwamuliya. Ilaoma kaba yatubu koina iya tounuyamate yo nige sauga yabo kamwasa dudulaina koina ilalau, kaiwena walo yawasosi nige imiyamiya koina. Saugana tem imwakota bwaimwa iya mumugana yawasosi, yo bwaite kaiwena iya tomwakomwakota yo mwakota mumugana meuloina iya tamali. ");
INSERT INTO tte_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mwa kaiwena yau walo yawasosi yawalowen na komiu nige kwamemeliyagau. ");
INSERT INTO tte_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Tem wakatai me yagu naenaena kwayakenayagau. Na tem yagu walone walo yawasosi tawae kaiwena nige kwamemeli-yagau? ");
INSERT INTO tte_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yaubada natunao Yaubada ana walo sibenalan. Komiu nige Yaubada ana walo kwabebenalan kaiwena komiu nige natunao besi.” ");
INSERT INTO tte_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Kabo tomo Yudiya Yeisu kainana siyamaisa siba, “Nuwana kawalo dudulai saugana kawalo yakato kowa toyauyaule besiele Sameliya tomonliyao yo yaluyaluwa biki ilusae koliwo.” ");
INSERT INTO tte_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Mwa kainali iyamaisa iba, “Nige yaluyaluwa biki ilulusae koliyau, yau Tamagu yayakasisiyan na komiu nige kwayayakasisi-yagau. ");
INSERT INTO tte_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yau nige yakepakepate yakato esagu yapeiseyan, na yabo iyaele nuwanuwana esagu ipeiseyan yo iya toyatala dudulaisosina. ");
INSERT INTO tte_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yawalo yawasosi kolimiu, yaiya tem yagu walo iobigaili nige sowasowana iboita.” ");
INSERT INTO tte_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tomo Yudiya ali nuwatu yakato Yeisu iwalowalo kwapina ana boita kaiwena mwa siwalo koina siba, “Kabo kakatai yawasosi yakato yaluyaluwa biki ilusae koliwo. Abelamo yo palopitao siboitako na kowa kuba ‘yaiya tem yagu walo iobigaili nige sowasowana iboita.’ ");
INSERT INTO tte_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Tubumai Abelamo iboitako, nuwana kuboma am nuwatu mena yakato kulalaki-gabaen? Yo palopitao siboitako tabe. Na kunuwatui yakato yaiya kowa?” ");
INSERT INTO tte_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yeisu kainali iyamaisa iba, “Tem nuwana yaboma esagu yapeiseyan, na kani esagune nige kanna ipapagan. Na komiu kwawalo yakato Tamagu iya ami Yaubada, iya mwa esagu ipeipeiseyan. ");
INSERT INTO tte_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Komiu nige wakakatai, na yau yakatai. Nuwana tem yawaloba, iya nige yakakatai, kani yau yaemala tomwakomwakota besiele komiu. Na iya yakatai mwa ana walo yabenalan yo yabenali-kalatan. ");
INSERT INTO tte_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Beyabeyana tubumiu Abelamo inuwatui yakato yagu sauga yawatagilima yanuwa yaulina mena igitai, kabo iyaliyaya, yo saugana imiyamiya Yaubada salina mena igitaiyau mwa iyaliyaya.” ");
INSERT INTO tte_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kabo tomo Yudiya siwalo koina siba, “Am bolime nige naga pipti ilolobai kabo gubesi mwa kuwalo yakato Abelamo ugitai?” ");
INSERT INTO tte_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Kainali iyamaisa iba, “Yawalo yawasosi kolimiu, muliya kabo Abelamo iyawatagilima yau yamiyamiya.” ");
INSERT INTO tte_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yeisu ana walone bwaite kaiwena, mwa veku sikalaili yakato silovekui, na ikeno-wadam, kabo Nume Tabu ilogabaen. ");
INSERT INTO tte_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Saugana Yeisu ilalau kamwasa mena kabo tomangibugibu yabo igitai sinana ikabiyan man gibugibuna. ");
INSERT INTO tte_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ana tobenaliyao sineli siba, “Toyakayakatai, yaiya ana pwanoli, iya o sinana yo tamana ali pwanoli mwa kaiwena sikabi man gibugibuna?” ");
INSERT INTO tte_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yeisu iba, “Nige iya ana pwanoli o sinana yo tamana ali pwanoli kaiwena na manna igibu. Bwaite iyawatagili na mesabana tomo sigitai Yaubada ana paisowa yo ana kaiwe iyawatagili yawasina koina. ");
INSERT INTO tte_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kaliyate koina sowasowana kagu toyawasa ana paisowa taginauli na boniyai ilalaoma nige sowasowana paisowa yabo taginauli. ");
INSERT INTO tte_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Saugana yau yamiyamiya yanuwa yaulina mena yau yanuwa yaulina kana mayale.” ");
INSERT INTO tte_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yeisu walone bwaite iwalowen kabo ikaiso bwatano mena, kaisona koina iyebweli, yo ikalai isau tomangibugibu manna mena. ");
INSERT INTO tte_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Kabo iwalo koina iba, “Kulau kipukipu Sailoma koina manim kudeuli.” (Esa Sailoma kana katai yawayawasa.) Kabo tomone ilau kipukipune koina manna ideuli yo ipileyoima inamwanamwa manna silala yo ginauli meuloina igitaili. ");
INSERT INTO tte_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kabo ana elieliyamwao yo tomo siya beyabeyana sigitai ikawakawanoi siba, “Tomangibugibune bwaite beyabeyana imiyasio na ikawakawanoi bwaite iya o nigele?” ");
INSERT INTO tte_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Kabo tupwali siba, “Nuwana tomonaele bwaite.” Na tupwaliyao siba, “Kana koleya besiele iya na iyamo nuwana nigele.” Mwa tomangibugibune iboma iba, “Bwaite yau.” ");
INSERT INTO tte_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Mwa sineli siba, “Na gubesi mwa manim ilalane?” ");
INSERT INTO tte_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Kainali iyamaisa iba, “Tomo bwaite esana siba Yeisu, kaisona iyebweli bwatano mena kabo ikalai isau mangu mena mwa iba, ‘Kulau Sailoma koina manim kudeuli.’ Kabo yalau mangu yadeuli mwa mangu ilala yo ginauli meuloina yagitaili.” ");
INSERT INTO tte_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Kabo sineli siba, “Tomone toweya iyaele?” Kainali iyamaisa iba, “Nige yakakatai.” ");
INSERT INTO tte_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kabo tomangibugibune siyogan silawan Palisi kolili. ");
INSERT INTO tte_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Na bwaite kaliyate Sabati koina Yeisu kaisona iyebweli yo isau tomangibugibune manna mena kabo manna ilala. ");
INSERT INTO tte_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kabo Palisi sineli siba, “Gubesi na manim ilala?” Kainali iyamaisa iba, “Yeisu kaisona iyebweli yo isau mangu mena, kabo mangu yadeuli yo sauganane koina mangu ilala yo ginauli meuloili yagitaili.” ");
INSERT INTO tte_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Palisi tupwaliyao siba, “Tomone bwaite Yeisu iya nige ilalaoma Yaubada koina kaiwena Sabati kana loina ilikwai.” Na tupwaliyaoyoi ali nuwatu uloi kabo siba, “Nuwana ilaomaya Yaubada koina kaiwena nige sowasowana loina kana tolikwai yabo ginauli kaba nuwapwanopwano besiele bwaite ipaisowai, awa?” Kabo boda labui siginaulili yo sigamwapakiki. ");
INSERT INTO tte_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kabo Palisi sineliyoi tomangibugibune koina siba, “Na kowa am nuwatu gubesi tomone kaiwena? Kaiwena kowa mwa manim iyalalali.” Tomangibugibune kainali iyamaisa iba, “Iya palopita yabo.” ");
INSERT INTO tte_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Na Yudiya ali toloinao ali nuwatu tomangibugubune iya tomwakota, nige simemeli yakato beyabeyana iya tomangibugibu yabo. Ali nuwatu besiele kabo tamana yo sinana siyoganlima kolili. ");
INSERT INTO tte_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Mwa sineliyagili siba, “Bwaite komiu natumiu, iya kwawaloba beyabeyana wakabi manna gibugibuna? Gubesi kabo manna inamwanamwa?” ");
INSERT INTO tte_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tamana yo sinana siba, “Kakatai mowoi iya natumai yo kakatai saugana kakabi man gibugibuna. ");
INSERT INTO tte_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Na nige kakakatai gubesi kabo manna inamwanamwa o tem yaiya mannane iwoisili mwa ilalayoi. Kwaneliyan, iya ilalakiko, sowasowana ibomayoi kaiwena iedeedede.” ");
INSERT INTO tte_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tamana yo sinana siwalo bwaite besiele kaiwena Yudiya ali toloinao simatausagili. Na siya loina sipaisowaiyako yakato yaiya tem Yeisu ikawa-Mesaiya-yan kani simalimaliu-wani tabu mekalikava sitatapwalolo yoi ali boda koina. ");
INSERT INTO tte_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Bwaite iya kaiwena mwa tamana yo sinana siba, “Kwaneliyan, iya ilalakiko.” ");
INSERT INTO tte_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kabo Palisi tomangibugibune siyogan ilusaeyoi kolili, yo siwalo koina siba, “Ukwawalulu Yaubada manna mena yo kuwalo yawasosi. Kai kakatai tomone bwaimwa Yeisu iya tomo naenaena.” ");
INSERT INTO tte_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Na iwalo kolili iba, “Nige yakakatai tem iya tonaenaena o nigele. Na bwaimwanamo iya yakatai beyabeyana mangu igibu na sauga kabona inamwanamwako.” ");
INSERT INTO tte_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kabo sineliyan siba, “Na tawae iginauli koliwo? Gubesi ana paipaisowaina manimne mwa ilalayoi?” ");
INSERT INTO tte_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Kainali iyamaisa iba, “Yawaloko kolimiu na komiu nige kwabebenali. Tawae kaiwena nuwanuwamiu yawalowen yoi? Gubesi, komiu tabe nuwanuwamiu kwaemala ana tomuliyayao?” ");
INSERT INTO tte_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kabo me ali munamunai lalakina sikawa-naenaeyan yo siwalolau koina siba, “Kowa ana tomuliya yabo, na kai Mosese ana tomuliyayao. ");
INSERT INTO tte_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kai kakatai Yaubada iedeedede Mosese koina yo loina iwolena, na tomone bwaite iya nige kakakatai toweya ilaomaya.” ");
INSERT INTO tte_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kabo kainali iyamaisa iba, “Nuwagu ipwanopwano-wagimiu kaiwena kwawaloba, ‘Nige kakakatai toweya ilaomaya,’ na iya mwa mangu iyanamwanamwali. ");
INSERT INTO tte_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Takatai Yaubada nige sowasowana ibenali tonaenaeli kolili. Na iya ibenabenali siya siyakasisiyan yo ana nuwatu sipaipaisowai. ");
INSERT INTO tte_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kaba yatubu koina ilaoma kanasiga sauga kabona, nige sauga yabo wasa tabebenalan yakato tomo yabo iya sikabi manna gibugibuna manna sikabi-namwanamwai yo inamwanamwa. ");
INSERT INTO tte_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Temga tomone nige ilalaomaya Yaubada koina kani nige sowasowana ginauli yabo iginauli.” ");
INSERT INTO tte_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tomangibugubune ana walo bwaite kaiwena toloinao simunamunaisosi mwa siyokoiyan siwalolau koina siba, “Kowa naenaena koina kuyawatagili yo kulalaki, gubesi mwa yakato kuyakayakatai kolimai.” Kabo situbali-yawatagilan simalimaliu-wani ilau. ");
INSERT INTO tte_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yeisu tomangibugibune wasana ibenalan yakato situbali-yawatagilan, kabo iloyai yo saugana ilobai mwa Yeisu iwalolau koina iba, “Gubesi, kumeli Tomo Natuna koina o nigele?” ");
INSERT INTO tte_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Kainana iyamaisa iba, “Taubala, yaiya Tomo Natuna? Kuwalowen koliyau na yameli koina.” ");
INSERT INTO tte_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yeisu iba, “Ugitaiyako, iya bwaite saugane mekamkava kwaedeedede.” ");
INSERT INTO tte_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kabo tomangibugibune iwaloba, “Guyau, yameliyagiwo.” Kabo tutulina italusakonayan yo ipwalou Yeisu koina. ");
INSERT INTO tte_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yeisu iba, “Yalaoma yanuwa yaulina mena na tomo mumugali yapei-yawatagilan mayale mena kabo tomangibugibu manli silala yo siya yakato manli namwanamwali manli sigibu.” ");
INSERT INTO tte_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Palisi tupwali Yeisu salina mena ana walo sibenalan mwa sineli siba, “Gubesi, kuwalo yakato kai tabe manimaiyao sigibu?” ");
INSERT INTO tte_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yeisu iwalolau kolili iba, “Tem kwawaloba, ‘kai manimai igibu,’ nige naenaena yabo imiyamiya kolimiu Yaubada manna mena. Na komiu kwawaloba, ‘kai manimai lalalalana’ kabo ami naenaena iyaele imiyamiya, nige imwamwawasi.” ");
INSERT INTO tte_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yeisu iwaloba, “Yawalo yawasosi kolimiu, tem yaiya nige ilulusaema sipi kana gana gamwana mena na ivinae-likwama ganane koina, iya tokewali. ");
INSERT INTO tte_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Na tem yaiya ilusaema gamwa mena, iya sipi kali togitekalatan. ");
INSERT INTO tte_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Saugana sipi togitekalatan ilaoma ganane koina gamwa kana togitekalatan gamwane isoke na sipi togitekalatan ilusae na ana sipiyao esali kolili iyoganlima. Saugana kainana sibenalan kabo silaoma koina simuliya yo siyawatagili yauli mena. ");
INSERT INTO tte_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mwa meuloili siyawatagili, yo kali togitekalatan ibaguna na simulimuliya, kaiwena kainana kana dagugu sikatai mwa simanasamwanako. ");
INSERT INTO tte_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Sipi nige sowasowana tomo uloina koina simuliya, kani siyabubu-gabaen kaiwena kainana kana dagugu uloina.” ");
INSERT INTO tte_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Kobwaibwaili bwaite Yeisu iwalowen Palisiyao kolili na kana katai nige nuwali imamayaleyan. ");
INSERT INTO tte_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yeisu iwaloyoi kolili iba, “Yawalo yawasosi kolimiu, yau sipi kali gamwaele. ");
INSERT INTO tte_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Na sipi togitekalatan uloili silaoma baguna kabo muli mena yau siya tokewali mwa sipine nige kainali sibebenalan. ");
INSERT INTO tte_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yau bwaite gamwaele, tem yaiya koliyau ilusaema kani inamwanamwa yo lebo ilobai. Kaiwena kani sauga meuloina ilusalusaema yo iyawayawatagili na kawasi namwanamwana ilobalobai. ");
INSERT INTO tte_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Na tokewali siya ali paisowa silaoma sikewali sisibayanae yo siunuyamate. Na yau yalaoma na mesabana tomo yawasili namwanamwana yo powopowona koliyau silobai. ");
INSERT INTO tte_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yau sipi kali togitekalatan namwanamwana, togitekalatan namwanamwana kani yawasina italamwan ana sipiyao kaiweli iboita. ");
INSERT INTO tte_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Na tem yaiya iya nige sipi tanuwagana na ipaisowamo maisa kaiwena na tem bwauwa sokasokali igitaili silalaoma kani sipine iyabubu-gabaegili. Na bwauwane sokasokali sipi sitonan tem sikwayaili kabo sipine matausi mena siyabubu-gwaligwali. ");
INSERT INTO tte_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tomone ana yabubu yaina kaiwena iya ipaisowamo maisa kaiwena, mwa sipine nige kaiweli inuwanuwatu kaiwena tomo uloina ana sipi. ");
INSERT INTO tte_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Yau sipi kali togitekalatan namwanamwana kaiwena yagu sipiyao yakataili yo siya sikataiyau. ");
INSERT INTO tte_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Besiele Tamagu ikataiyau yo yau tabe yakatai. Yo tabe yau yawasigu yatalamwan yo yagu sipiyao kaiweli yaboita. ");
INSERT INTO tte_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yagu sipi tupwaliyao nige simiyamiya bwaite ganane kalona mena. Mwa yatonan na yakalailima na mesabana kainagu sibenalan yo silaoma koliyau na mekalikavao siyaboda kaigeda na kali togitekalatan kaigedamo yau. ");
INSERT INTO tte_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tamagu imulolososi koliyau kaiwena yawasigu yatalamwan na yakato yaboita kabo muli mena yawasigu yalobaiyoi. ");
INSERT INTO tte_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nige sowasowana yabo yawasigu koliyau ikalai. Yaumo yaboma yatalam-wagau na yaboita, yo sowasowagu tabe yawasigu yakalai yoi. Kaiwena bwaite besiele Tamagu ana nuwatu yo tabe ana loina koliyau.” ");
INSERT INTO tte_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Walone bwaite kaiweli tomo Yudiya sibomamo kolili sigamwapakiki lalakina, mwa koina yakasa kolili iyawatagili. ");
INSERT INTO tte_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tupwana sibaibaiwa siba, “Iya dimoni koina mwa ikabaleya. Tabu ana walo kwabebenalagili.” ");
INSERT INTO tte_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Na tupwaliyao siwaloba, “Bwaite nige besiele dimoni ana walo. Gubesi kwawawalo yakato iya dimoni? Kaiwena dimoni nige sowasowana tomangibugibu manna iyalala.” ");
INSERT INTO tte_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Saugana tulutulu kana sauga Yudiya ali soi yabo sipaisowai bwaimwa Nume Tabu kana kabiyakapwa kana nuwatu-kalatan kaiwena. ");
INSERT INTO tte_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Sauganane koina Yeisu Nume Tabu kalona mena ilokeikeile dedei yabo koina iya sipei Kin Solomon ana kaba kelolon. ");
INSERT INTO tte_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Kabo bwaine koina Yudiya toloinao Yeisu sitolo-takikilan yo siwalo koina siba, “Tawanesana kani kuwalo dudulai kolimai? Ama wasa kuyeyama, kowa Mesaiya o nigele?” ");
INSERT INTO tte_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yeisu kainali iyamaisa iwaloba, “Yawaloko kolimiu, na nige kwamemeli-yagau. Ginauli kaba nuwapwanopwano yapaisowailiko Tamagu esana mena na kilakilalane siya siwalo-masalagau, ");
INSERT INTO tte_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","na iyamo nige kwamemeli-yagau, kaiwena komiu nige yagu sipiyao. ");
INSERT INTO tte_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yagu sipi kainagu sibenalan, yo tabe yakataili mwa simuliye koliyau. ");
INSERT INTO tte_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yawasili miyamiya yaina yaolegili na mesabana tabu siboboita yo tabu yaiya yabo nimagu mena ikwakwayaili. ");
INSERT INTO tte_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tamagu iya iyelima koliyau mwa iya ilalakisosi kabo ginauli meuloina mwa nige sowasowana yaiya yabo Tamagu nimana mena ikwayaili. ");
INSERT INTO tte_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yau yo Tamagu kaigedamai.” ");
INSERT INTO tte_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yeisu ana walone bwaite kaiwena Yudiya toloinao simunamunai mwa veku sikalaiyoi yakato siunui. ");
INSERT INTO tte_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kabo Yeisu kolili iwaloba, “Ginauli kaba nuwapwanopwano namwanamwali sibaibaiwa yapaisowaili siya Tamagu iyelima wagitailiko. Toisabo paisowa kaikaiwena kaiwena nuwanuwamiu kwaunuyamateyau?” ");
INSERT INTO tte_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Kabo siya toloinaone Yeisu kainana siyamaisa siba, “Nige yakato am paisowane namwanamwali kaiwena kaunuiwo, na iyamo am walo kawasewa kaiwena. Kaiwena kowa tomo molosi na kuwalo yakato kuyamala Yaubada.” ");
INSERT INTO tte_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yeisu kainali iyamaisa iba, “Same koina Yaubada toyatala bagubagunali ikawa-yaubada-yagili. ");
INSERT INTO tte_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Yaubada walone bwaitete iwalowegili tomo kolili yakato siya yaubadao. Komiu wakatai Buki Tabune iya sauga meuloina walo yawasosi. ");
INSERT INTO tte_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Na tawae kaiwena kwawalo yakato yakawasewa saugana yawaloba ‘Yau Yaubada Natuna’? Tamagu iyakasisi-yagau yo iyawasayauma yanuwa yaulina mena na ana paisowa yapaisowai. ");
INSERT INTO tte_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tem nige Tamagu ana paisowa yaginaginauli kabo tabu yagu walone kwamemeli-yagili. ");
INSERT INTO tte_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Na iyamo yau ana paisowa yaginaginauli. Na tem nige kwamemeli yagu walone koina sowasowana yagu paisowane koina kwameli. Kabo nuwamiu imayale na wakatai yakato Tamagu imiyamiya koliyau na yau yamiyamiya koina.” ");
INSERT INTO tte_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bwaine koina siya Yudiya toloinao sitonanyoi yakato sikabikalatan, na iyamo Yeisu nimali mena iyabubu. ");
INSERT INTO tte_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mwa ilau yo Yolidan wailana igayopanaisi yoi, bwaine dedeine koina tauna kona Yoni tomo iyababitaisoli, yo bwaine koina imiyamiya. ");
INSERT INTO tte_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Yo tomo sibaibaiwa silau koina sagu kaiwena. Tomone meuloili siedeedede Yeisu kaiwena siba, “Yoni Toyababitaiso nige ginauli kaba nuwapwanopwano yabo ipapaisowai na iyamo tawae ana walo iwalowegili tomone bwaite kaiwena walo yawasosi.” ");
INSERT INTO tte_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mwa dedei bwaine koina tomo sibaibaiwa Yeisu koina simeli. ");
INSERT INTO tte_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Tomo yabo esana Lasalo ikasiebwa lalakina. Iya Bedani tomona dunao labui Meli yo Mata mekanakavao simiyamiya. ");
INSERT INTO tte_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Bwaite iya Meline iya naga kani Yeisu kaekaena iyaoloi yo itona mena isau, iya tokasiebwane duna. ");
INSERT INTO tte_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Sauganane koina duli Lasalo ikasiebwa kabo walo siyawasa ilau Yeisu koina siba, “Taubala, am eliyam namwanamwanawa ikasiebwa.” ");
INSERT INTO tte_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Saugana Yeisu Lasalo ana kasiebwa wasana ibenalan kabo iwalo tomo kolili iba, “Kasiebwa kana katai yakato Lasalo tabu iboboita, na iyamo kasiebwa bwaite iyawatagili na tomo meuloili Yaubada sitobalan yo tabe Natuna siwaloseyani ana paisowa kaiwena.” ");
INSERT INTO tte_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yeisu Mata yo kanakava yo tabe duli Lasalo ikatekamkamna-yagili lalakina. ");
INSERT INTO tte_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lasalo ana kasiebwa wasana ilau Yeisu koina siwalo-masalan, na Yeisu nige ilalau Bedani, na imiyamiya dedeine bwaine koina kaliyate labui. ");
INSERT INTO tte_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Muli mena kaliyate labui simwawasi kabo ana tobenaliyao kolili iba, “Bwaite koina tapileyoi Bedani Yudiya dedeina mena.” ");
INSERT INTO tte_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Na ana tobenaliyao siwalo koina siba, “Toyakayakatai, tauna kona Yudiya toloinao sitonan tem siunuiwo veku mena, tabu tapipileyoi kaiwena toloinaone nagamo sinuwanuwatu tem siunuiwo.” ");
INSERT INTO tte_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Na Yeisu nuwanuwana iyakenayagili yakato iya ilolokeikeile Yaubada ana mayale koina yo Yaubada iyamo ana boita kana sauga iloiloinayan, nige sowana simatausi, kabo kainali iyamaisa iba, “Kaba gite yabo yaeyawa. Kaliyate meuloina koina bwaine malala mena yo kanasiga ilolau mwa tem yaiya kaliyatene bwaine koina ilokeikeile kani nige itutupa, kaiwena bwaite yanuwa yaulina kana mayale imiyamiya. ");
INSERT INTO tte_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Na tem boniyai koina ilokeikeile naga itupa yo ibeku, kaiwena nige mayale koina imiyamiya.” ");
INSERT INTO tte_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iwalo bwaite besiele kabo ietulanyoi iba, “Ala eliyam Lasalo iya ikenokenomo, mwa yalau na yayanoi.” ");
INSERT INTO tte_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Na tobenaliyaone siwaloba, “Taubala, tabu talalau kaiwena ikenokenomo naga kani kabo inamwanamwa na itoloyoi.” ");
INSERT INTO tte_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yeisu iedeedede Lasalo ana boita kaiwena na ana tobenaliyao sinuwanuwatu yakato ikenokenomo. ");
INSERT INTO tte_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kabo Yeisu ana walo kana katai iwalo-masalan kolili iba, “Lasalo iboitako. ");
INSERT INTO tte_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Na yayaliyaya kaiwena ana kasiebwane koina nige yamiyamiya. Na besi, talau tagitai na bwaine koina yagu paisowane wagitai na kwameli yawasosi.” ");
INSERT INTO tte_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Na Tomasi, iya esana labuina Didiluwaluwa, kanakavao kolili iwaloba, ‘Besimo talau ala toyakayakatai mekalakava na taboita.” ");
INSERT INTO tte_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Saugana Yeisu iyawatagili Bedani, wasa ibenalan yakato Lasalo sipeiyako salai mena kaliyate esopali simwawasiko koina. ");
INSERT INTO tte_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Na Bedani yo Yelusalema nige mamalawena, nuwana tili kilomita, ");
INSERT INTO tte_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","kaiwena mwa Yudiya tovalavalam sibaibaiwa silaoma Bedani koina na yakato Mata yo Meli nuwali tupwana sikabi-namwanamwaili duli kaiwena. ");
INSERT INTO tte_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Na Mata wasa ibenalan yakato Yeisu ilalaoma, mwa iya iyawatagili ilau kamwasa mena na Yeisu isanai, na kanakava Meli nume mena imiyamiya. ");
INSERT INTO tte_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Kabo Mata Yeisu ilobai yo koina iwaloba, “Guyau, tem laina kowa kumiyamiya bwaite koina, kani dugu nige iboboita. ");
INSERT INTO tte_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Na yakatai bwaite saugane koina tem tawae kaiwena ukawanoi Yaubada koina kani iyeyawa besiele.” ");
INSERT INTO tte_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Mwa Yeisu Mata koina iwaloba, “Dum boita mena kani itoloyoima.” ");
INSERT INTO tte_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Na Mata iwaloba, “Yakatai yakato naga sauga ana kaba mwawasi koina toloyoi kana kaliyate koina kani tomo meuloili sitoloyoi.” ");
INSERT INTO tte_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Na Yeisu iwalo koina iba, “Yau toloyoi yo yawasi yaina. Mwa tem yaiya imeliyagau na saugana iboita kani yawasina miyamiya yaina ilobai. ");
INSERT INTO tte_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tem yaiya meyawasina imiyamiya na imeliyagau kani nige iboboita. Mata, gubesi, walone bwaite kaiwena kumeli?” ");
INSERT INTO tte_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mata iwaloba, “Guyau, besiele, yameliyagiwo kowa Mesaiya, Yaubada Natuna, kulaoma yanuwa yaulina mena.” ");
INSERT INTO tte_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata ana walo imwawasi, kabo ipileyoi nume mena yo kanakava Meli iyoga-suwalan iba, “Toyakayakataiwa ilaomako mwa ineliyagiwo.” ");
INSERT INTO tte_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Saugana Meli walone bwaite ibenalan mwayamwayau mena iyawatagili yo ilau Yeisu igitai. ");
INSERT INTO tte_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Na Yeisu naga ilulusaema yanuwane koina na iyaelemo imiyamiya toweya koina Mata ilobai. ");
INSERT INTO tte_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na siya Yudiya tovalavalamne siya Meli mekalikavao nume mena nuwana sikabikabi-namwanamwai sigitai Meli mwayamwayau mena iyawatagili gana muli mena ali nuwatu yakato ilalau salai mena sabi valam, kabo mulina mena silau. ");
INSERT INTO tte_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Saugana Meli iyawatagili dedeinane bwaine koina Yeisu imiyamiya tutulina italusakonayan Yeisu manna mena yo iwaloba, “Guyau, tem laina kowa kumiyamiya bwaite koina kani dugu nige sowasowana iboita.” ");
INSERT INTO tte_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Na bwaine koina Yeisu igitai Meli ana valam yo tabe Yudiya siya mekalikava silaoma ali valam igitaili na katena ikamkamna yo nuwana inae lalakina. ");
INSERT INTO tte_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kabo kolili ineli iba, “Toweya koina kana salai?” Kabo siba, “Taubala, kulaoma na kayakenayagiwo.” ");
INSERT INTO tte_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Kabo bwaine koina Yeisu ivalam. ");
INSERT INTO tte_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Saugana Yudiya tovalavalamne Yeisu ana valam sigitai, mwa siba, “Walo yawasosi, ana eliyamne kaiwena katena ikamkamna lalakina.” ");
INSERT INTO tte_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Na tupwaliyao siba, “Tauna kona toman gibugibu yabo manna iyalala. Na gubesi mwa nige sowasowana laina ilaoma na ana eliyam namwanamwanane iwoisi na ana kasiebwa mena tabu iboboita?” ");
INSERT INTO tte_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Na Yeisu katena ikamkamna lalakina saugana ilau salai mena. Salaine bwainene duluwa na kana kokaukausi veku lalakina koina sikokausi. ");
INSERT INTO tte_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Kabo Yeisu iba, “Vekune kwatubali-suwalan.” Na Mata, Lasalo duna, iwalo iba, “Guyau, kaliyate esopali simwawasiko ikenokeno salai mena mwa ibowako.” ");
INSERT INTO tte_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Kabo Yeisu Mata kainana iyamaisa iba, “Kabona yawaloko koliwo yakato tem kumeliyagau kani Yaubada ana kaiwe ugitai.” ");
INSERT INTO tte_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mwa vekune situbali-suwalan. Kabo Yeisu isakaisae bulibuli mena iba, “Tamagu, kagutoki lalakina kaiwena sauga bwaite koina kubenalagau. ");
INSERT INTO tte_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Bwaite yakataiwo yakato sauga meuloina yagu kawanoi kubenalagili, yo bwaite sauga yakawakawanoi koliwo tomo bwaite saligu mena sitotolo kaiweli na am kaiwe sigitai yakato kowa kuyawasayauma na simeli.” ");
INSERT INTO tte_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yo ana kawanoi mulina mena kainana lalakina mena iyoga iba, “Lasalo, kuyawatagilima.” ");
INSERT INTO tte_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kabo toboitane mekana suma iyawatagilima, nimana yo kaena yo tabe manna kwama mena sisumali. Mwa Yeisu bodane iwalo kolili iba, “Kwalivasi na kwamane wakele-gabaegili.” ");
INSERT INTO tte_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Siya Yudiya tovalavalamne siya silaoma Yelusalema koina na Meli nuwana sikabi namwanamwai Yeisu ana paisowa sigitai yo sibaibaiwa simeli yawasosi. ");
INSERT INTO tte_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Na siya tupwaliyao nige simemeli, sipileyoi Palisiyao kolili, na siwalo-masala besiele sigitai tawae Yeisu ipaisowai. ");
INSERT INTO tte_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mwa Palisiyaone yo topwaoli lalakili siwalo toloinao meuloili simiyagogo. Meuloili simiyagogo kabo siba, “Tawae kani tomone koina taginauli? Kaiwena ginauli kaba nuwapwanopwano sibaibaiwa ipaipaisowaili. ");
INSERT INTO tte_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tem nige ginauli yabo tapapaisowai tomone koina na ipaisowamo ilaulau bwaine besiele, tomo meuloili kani simeli koina na sipei iyamala kin. Tem Sisa ibenalan kani Loma ali tokaleya iyawasalima ala Nume Tabu sisibayanae yo tabe ala boda meuloina siunuili.” ");
INSERT INTO tte_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Na Kaiyapa bolime bwaite koina iyamala topwaoli ali toloina lalakina iwaloba, “Kwamwanou, komiu nige ami katai yabo. ");
INSERT INTO tte_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nige wakakatai yakato ginauli namwanamwanaele tomo kaigeda iboita meuloili kaiweli na tabu tomo Yudiya meuloila taboboita Loma ana loina kaikaiwena koina.” ");
INSERT INTO tte_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Na Kaiyapa walone bwaine iwalowegili toloinao kolili nige iya ana nuwanuwatu mena na Yaubada walone ipei ana nuwatu mena yakato naga walone kani iyamala yawasosi saugana Yeisu iboita tomo Yudiya meuloili kaiweli, ");
INSERT INTO tte_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","na nige yakato siyamo kaiweli, na tabe yakato siya Yaubada ana tomoyao meuloili siya simiyamiya dedei uloi uloi kolili ikele-gogonagilima siyamala boda kaigeda. ");
INSERT INTO tte_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Mwa kaliyate bwaine koina siya Yudiya toloinaone siyatubu sinuwanuwatu gubesi na tem Yeisu siunui. ");
INSERT INTO tte_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Mwa Yeisu ali nuwatu bwaite ikataiyako koinaele nige iuutu-mayale toloinaone manli mena, na me ana tobenaliyao silau yo simiyamiya yanuwa esana Epileimi bwaimwa ule mena dekawa bwagabwaga salina mena. ");
INSERT INTO tte_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Na sauganane koina Yudiya ali mwalelikwa soina kana sauga ikelakubwamako, mwa tomo meuloili ali yanuwa silogabaegili sisae Yelusalema koina sabi kabiyakapwali besiele mumugali kabo muli mena soine kana sauga iyawatagili. ");
INSERT INTO tte_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Topwaoli lalakili yo Palisiyao walo siyawasa itakikili tomo meuloina Yelusalema koina tem toisabo dedei koina Yeisu sigitai mwayamwayau siwalo-masala kolili na Yeisu sikabikalatan. Mwa saugana tomo meuloili sitotolo Nume Tabu mena Yeisu sigitegite-loyaloyai na sibomamo kolili sienelineli-yagili siba, “Gubesi ami nuwatu, tomo bwaite kani ilaoma soine koina o nigele? Nuwana kani nigele.” ");
INSERT INTO tte_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Kaliyate sikisi simiyamiya na mwalelikwa soina sipaisowai Yelusalema koina kabo Yeisu Epileimi ilogabaen yo ilau Bedani, Lasalo ana yanuwa mena iya baguna boita mena Yeisu ikele-yatoloyoi. ");
INSERT INTO tte_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Saugana Yeisu iyawatagili Bedani koina kekan yabo sipaisowai Yeisu kaiwena. Na Mata kan itanuwagai na Lasalo yo Yeisu me ali bodao mekalikavao simiyagogo na sikekan. ");
INSERT INTO tte_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kabo Meli olo yabo esana nadi tupwatupwana maisana lalakina, ikalaiyama yo isuwai Yeisu kaekaena mena. Kabo muli mena ipwalou na itona mena Yeisu kaekaena isauli. Na olone bwalaina namwanamwana numene iloyapowoni. ");
INSERT INTO tte_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yeisu ana tobenali yabo esana Yudasa Isikaliota iya naga iwalomasalan toloinao kolili, me ana munamunai Meli iyokoiyan, ");
INSERT INTO tte_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","iba, “Bwaite olone tem tagimwala-yani kani maisana besiele tili andeledi siliba, na bwaite manene sowasowana taolena tobubutumao kolili.” ");
INSERT INTO tte_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Na Yudasa nige ana nuwatu yabo tobubutuma kaiweli kaiwena tokewali iya yo tabe iya Yeisu me ana tobenaliyao ali mane kana togitekalatan yo manene kolili ikewakewali. ");
INSERT INTO tte_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Kabo Yeisu iwalolau Yudasa koina iba, “Besi, tabu Meli kuyoyokoiyan. Kaiwena tawae iginaginauli koliyau kagu pei salai kaiwena. ");
INSERT INTO tte_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tobubutumao sauga meuloina mekamikavao kwamiyamiya mwa tem nuwanuwamiu kwasaguili inamwanamwa na yau kani nige sauga meuloina mekamikava tamiyamiya.” ");
INSERT INTO tte_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tomo Yudiya meuloili Yeisu wasana sibenalan iya iyaele imiyamiya Bedani mwa Yelusalema koina silaoma. Nige yakato iya iboma kaiwena silau na nuwanuwali tabe tem Lasalo sigitai iya beyabeyana Yeisu boita mena ikeleyatoloyoi. ");
INSERT INTO tte_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Yo bwaine Bedani koina tomo meuloiline Lasalo sigitai nuwali iyai kabo Yeisu koina simeli. Na bodane ali meli Yeisu koina kaiwena toloinaone, siya topwaoli lalakili, simunamunaisosi kabo nuwanuwali Lasalo tabe siunuyamate. ");
INSERT INTO tte_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Yanuwa ilayanyoi boda lalakina siya silaoma mwalelikwa soina kaiwena, Yeisu wasana sibenalan yakato iyaele ilalaoma kamwasa mena Yelusalema kaiwena. ");
INSERT INTO tte_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mwa bodane kasiyala liguliyao sitomli na sikele-gogonagili na silau kamwasa mena Yeisu sigitai, siyogayoga, “Osana, Guyau tatobalani, Yaubada iwalo-muloloi iya ilaoma Guyau esana mena, Yaubada iwalo-muloloi, iya Isileli ali kin.” ");
INSERT INTO tte_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yo Yeisu donki mena imwalisae na ilaulau besiele baguna Buki Tabu koina iwalo-masalan iba, ");
INSERT INTO tte_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Saiyoni tomoliyao, tabu kwamamatausi. Wagitai ami kin iya ilalaoma kolimiu, iya donki natuna koina imwalisae.” ");
INSERT INTO tte_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Sauganane bwaine koina ana tobenaliyao nige nuwali imamayaleyan Buki Tabu ana walo yo tomo ali paisowa Yeisu koina, na ana toloyoi mulina mena kabo sinuwa-mayale Buki Tabu ana walo yo tawae tomo sipaisowai koina. ");
INSERT INTO tte_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bodane siya tovalavalamne baguna manli mena Yeisu Lasalo salai mena iyoganama yo boita mena itoloyoi, bwaite silau kalikavao kolili Yelusalema koina, na wasane siluwewasa-yagili. ");
INSERT INTO tte_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Bwaine koina siya Yudiya meuloili Yeisu ana paisowa kaikaiwena wasana sibenalan, mwa silaoma sabi sanaina sauganane ana lusaema Yelusalema koina. ");
INSERT INTO tte_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kabo Palisiyao sibomamo kolili siba, “Wagitai, ala kaiwe imwawasiko, kaiwena tomo meuloili Yeisu ana boda koina simulimuliya.” ");
INSERT INTO tte_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Bodane sisasae sabi tapwalolo Yelusalema mwalelikwa soina kaiwena luwali mena tomo Gilisi tupwaliyao mekalikavao. ");
INSERT INTO tte_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Silau Pilipi koina iya ilaomaya yanuwa Betesaida koina Galili dedeinane koina siwaloba, “Taubala, nuwanuwamai tem Yeisu kagitai.” ");
INSERT INTO tte_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilipi ilau Anidulu koina kabo yoli labuine silau Yeisu koina na siedeedede Gilisine ali nuwatu kaiwena. ");
INSERT INTO tte_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Mwa Yeisu iwalo kolili iba, “Sauga iyawatagilimako na Yaubada kani Tomo Natuna ana wasawasa iginauli.” ");
INSERT INTO tte_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Yeisu nuwanuwana iyakenayagili yakato kani iboita na mesabana tomo meuloili yawasi miyamiya yaina silobai, mwa kaba gite bwaite iwalowen kolili iba, “Tem witi patuna nige ibebeku bwatano mena kani nige iboboita kani imiya bwagabwagamo. Na tem ibeku bwatano mena kani iboita na ikin kabo iuwe na idebalala. ");
INSERT INTO tte_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Yaiya tem yawasina imulolo koina kani sauga muli mena yawasina igabaen. Na yaiya tem yawasina nige imumulolo koina yanuwa yaulina mena nige sowasowana yawasina igabaen, na kani ikabikalatan kanasiga yawasina miyamiya yaina ilobai. ");
INSERT INTO tte_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tem tomo yaiya nuwanuwana na ipaisowa kaiwegu ilonamwayan imuliya koliyau, na toisabo dedei koina yamiyamiya iya tabe besiele imiyamiya koina. Kabo Tamagu topaisowane esana kani ikeleisin kaiwena iya ipaisowa kaiwegu. ");
INSERT INTO tte_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Sauga bwaite koina nuwagu ipolowe lalakina mwa nige yakakatai tawae kani yawalowen. Gubesi, kani yawalomo Tamagu kamkamna bwaitete tabu ilalaoma koliyau? Na nigele, kamkamna bwaitete iya kaiwena yalaoma.” ");
INSERT INTO tte_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kabo Yeisu ikawanoi Tamana koina iba, “Tamagu, esam wasawasana ukeleisinan.” Kabo kaina bulibuli mena ilobima iwaloba, “Esagu wasawasana yaginauliyako na kani yaginauliyoi.” ");
INSERT INTO tte_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Bodane sitotolone kainane sibenalan kabo tupwaliyao siwaloba, “Bwaine tutu daguguna.” Na tupwaliyao siwaloba, “Nigele, anelose yabo iedeedede koina.” ");
INSERT INTO tte_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yeisu iwalo kolili iba, “Kainane bwaine kwabebenalanne nige ilalaoma yagu namwanamwa kaiwena na ilaoma ami meli ikabiyakaiwe. ");
INSERT INTO tte_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Bwaite saugane koina Yaubada kani iyatala tomo yanuwa yaulina mena mumugali kaiwena. Yo tabe sauga bwaite koina Yaubada kani Seitani iya yanuwa yaulina kana toloina naenaena imalimaliu-wani. ");
INSERT INTO tte_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Na saugana sikeleisinagau kelose mena tomo meuloili kani yatabeili silaoma koliyau.” ");
INSERT INTO tte_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Walone bwaine iwalowen na iyakenayagili gubesi ana boita kana koleya. ");
INSERT INTO tte_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kabo bodane siwaloba, “Kabenalanako loina, bwaimwa iyaele Buki Tabu mena, iwalo-masala yakato Mesaiya kani imiyayai. Na gubesi kuwaloba sauga muli mena kani Tomo Natuna sikeleisinan kelose mena yo iboita? Tomone Natuna kaiwena kuedeededene iya yaiya?” ");
INSERT INTO tte_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yeisu kainali iyamaisa iba, “Mayalene kani imiyamiya kolimiu sauga kubwakubwanamo. Kabo ilonamwayagimiu mayalene koina kwalokeikeile saugana mayalene iya mekamikava, na mesabana boniboniyaine tabu ipwapwaikimiu. Kaiwena tem yaiya ilokeikeile boniboniyai mena nige ikakatai toweya ilalau. ");
INSERT INTO tte_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Saugana mayalene imiyamiya kolimiu kwameli koina na mesabana kwaemala mayale natunao.” Saugana Yeisu ana walo bwaite iyemwawasi ilogabaegili ilau ikeno-wadam. ");
INSERT INTO tte_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Bwagana Yeisu ginauli kaba nuwapwanopwano sibaibaiwa manli mena ipaisowailiko na iyamo tomo Yudiya nige simemeli koina. ");
INSERT INTO tte_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kabo palopita Aiseya ana walo iyamala yawasosi iwaloba, “Guyau, nige tomo yabo ama walo imemeliyan, yo nige tomo yabo am kaiwe ikikilala.” ");
INSERT INTO tte_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nige sowasowali simeli kaiwena Aiseya iwaloyoi iba, ");
INSERT INTO tte_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Yaubada manliyao iyagibuli yo ali nuwanuwatu iyaboniboniyaili mwa nige sowasowali manli mena sigitai yo nige sowasowali sinuwatu dudulai. Yaubada iwaloba, ‘Nige sowasowali sinuwatu-pileyoima koliyau na yawoisili.’” ");
INSERT INTO tte_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aiseya beyabeyana Yeisu ana wasawasa igitai mwa Yeisu kaiwena iedeedede bwaite besiele. ");
INSERT INTO tte_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Yudiya toloinao tupwana sibaibaiwa tabe Yeisu simeliyan, mwa nige sowasowana siwalo-masala Palisiyao kolili kaiwena simatausi kisimo ali nume tapwalolo mena simalimaliu-wagili. ");
INSERT INTO tte_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Siya toloinaone nuwanuwali kali tobali lalakina ilaoma tomo kolili kabo muli mena Yaubada kana tobali. ");
INSERT INTO tte_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yo Yeisu kainana lalakina mena iwalo kolili iba, “Tem yaiya kowa kumeliyagau kagu toyawasa tabe kumeliyani. ");
INSERT INTO tte_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tabe yaiya kowa ugitaiyau kagu toyawasa tabe ugitai. ");
INSERT INTO tte_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yalaoma yanuwa yaulina mena yau besiele mayale. Mwa analiyao simeli koliyau nige sowasowana simiya boniboniyai mena. ");
INSERT INTO tte_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Na yaiya iya kainagu ibenalan na nige ioobigai, nige sowasowana ana nae kaiwena yayatalayan. Kaiwena yau yalaoma nige sabi yatala, na yalaoma tomo sabi leboili. ");
INSERT INTO tte_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kaiwena tem yaiya isikotanagau, yo tabe yagu walo isikotanan, naga sauga ana kaba mwawasi koina kani yatala ilobai. Nige yau yayatalayan na yagu walone iyatalayan. ");
INSERT INTO tte_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kaiwena walone nige yaboma yagu nuwatu mena, na iyamo Tamagu iyawasayau tawae besiele iyanuwapeiyau yawalo-masalagili kolimiu. ");
INSERT INTO tte_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mwa yakatai Tamagu ana walone iedeedede yawasi miyamiya yaina kaiwena. Kabo walone meuloili yawalowalowegiline besiele tawae Tamagu iwalowen koliyau.” ");
INSERT INTO tte_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Kaliyate kaigeda imiyamiya kabo mwalelikwa soina kana sauga. Yeisu ikataiyako ana sauga ikelakubwamako na yanuwa yaulina ilogabaen na ipileyoi Tamana koina. Ana tomoyao imulolososi kolili siya simiyamiya yanuwa yaulina mena kabo bwaite sauga ana mulolone kaiweli kana lalaki iyakenayagili. ");
INSERT INTO tte_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yeisu me ana tobenaliyao sikekakekan lolau kekanna. Seitani ana nuwatu naenaena ipeiyako Yudasa Isikaliota koina, iya Saimoni natuna, naga kani iya Yeisu iwalo-masalan toloinao kolili. ");
INSERT INTO tte_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yeisu ikataiyako Tamana loina meuloina ipeiyako nimana mena yo ikatai iya ilaomaya Yaubada koina na tabe kani ipileyoi koina. ");
INSERT INTO tte_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mwa kekan mena itoloma na kana kwama bwaimwa kaleko mamalawena, ipei-suwalan na tawelo ikalai yo kasipuna mena ipan. ");
INSERT INTO tte_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kabo waila isuwai gaeba mena na iyatubu ana tobenaliyao kaekaeli ideulili yo tawelone kasipuna mena ipapanne ikalai yo kaeliyao isauli. ");
INSERT INTO tte_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yo saugana ilaoma Saimoni Pita koina, Pita iba, “Guyau, gubesi, yakato kaekaegu kudeulili?” ");
INSERT INTO tte_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yeisu Pita kainana iyamaisa iba, “Yagu paisowane nige nuwam imamayaleyan, na kani muli mena kabo nuwam imayaleyan.” ");
INSERT INTO tte_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kabo Pita iwaloba, “Nigele, tabu kisi sauga yabo kaekaegu kudeulili.” Yeisu iba, “Tem nige kaekaem yadedeulili kowa kani nige kagu tomuliya.” ");
INSERT INTO tte_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimon Pita iwaloba, “Guyau, tem bwaimwa besiele, tabu kaekaegumo kudedeulili, na nimagu yo kulukulugu besiele kudeulili.” ");
INSERT INTO tte_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yeisu iwaloba, “Tem yaiya tomo isugu kani dumdum meuloina yona mena imwawasi. Mwa nige sowasowana isuguyoi na sowasowanamo kaenamo ideulili. Komiu meuloimiu kwanamwanamwako na iyamo nige meuloimiune.” ");
INSERT INTO tte_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yeisu ikataiyako yaiya kani iwalo-masalan toloinaone kolili. Bwaite kaiwena mwa iba, “Nige meuloimiune kwananamwanamwa.” ");
INSERT INTO tte_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Saugana ana tobenaliyao kaekaeli ideulili imwawasi, kana kaleko malamalawenawa ilikwayoi kabo ilau imiyasio yoi ana kaba miya mena. Kabo ana tobenaliyao ineliyagili, iwaloba, “Gubesi, nuwamiu simayale tawae yapaisowaine kolimiu? ");
INSERT INTO tte_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kaiwena sauga meuloina kwawalowalo koliyau ‘Toyakayakatai’ yo ‘Guyau.’ Mwa ami walone bwaite idudulai, kaiwena yau bwaimwa besiele. ");
INSERT INTO tte_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Yau, ami guyau yo ami toyakayakatai, yaemala ami topaisowa kabo kaekaemiu yadeuliliko mwa komiu tabe sowasowana kwaemala ami elieliyamwao ali topaisowao na kaekaeliyao kwadeulili. ");
INSERT INTO tte_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yau kaba gite bwaite yapaisowai kaiwemiu na mesabana komiu waginauli besiele tawae yaginauliyako kolimiu. ");
INSERT INTO tte_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Yawalo yawasosi kolimiu, topaisowa nige ilalalaki kabo ana taubala. Tabe besiele tosagenawasa iya nige ilalalaki kabo kana toyawasane. ");
INSERT INTO tte_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Komiu yagu paisowane kana nuwamayale wakataiyako, mwa tem saugana waginaulili Yaubada kani iwalo-muloloimiu.” ");
INSERT INTO tte_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Komiu yagu tomoyao yagitesipwaimiuko yo yakatai-namwanamwaimiu. Nige meuloimiu kaiwemiu walo bwaite yawawalowen. Na iyamo yabo kani isikotanagau besiele Buki Tabu ana walo bwaite iwaloba, ‘Tomo bwaine iya naga gaeba kaigeda koina kakekan iya kani ikalomagigi-lagau.’ Mwa walo bwaite kana yawasosi kani naga iyawatagili. ");
INSERT INTO tte_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mwa walone bwaite kolimiu yawalo-masalan bagunayan kabo muli mena siyawatagili mwa saugana tem siyawatagili kani wakawa-yawasosi yakato yaiya yau. ");
INSERT INTO tte_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Yawalo yawasosi kolimiu, tem yaiya iyogan iya yayayawasane iya iyoganyau. Na yaiya iya iyoganyau kagu toyawasane iyogan.” ");
INSERT INTO tte_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yeisu ana walo iyemwawasi kabo nuwana ipolowe lalakina mwa iwalolau kolili iba, “Yawalo yawasosi kolimiu, kaigeda kolimiu kani iwalo-masalagau.” ");
INSERT INTO tte_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ana tobenaliyao siemankulakula-yagili nuwali ipwanopwano nige sikakatai yaiya Yeisu kaiwena iwalowalo. ");
INSERT INTO tte_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yeisu ana tobenali iya imulolososi koina, imiyasio Yeisu salina mena. ");
INSERT INTO tte_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Kabo Saimon Pita manna ilau tobenaline koina na gamwana iyamwasali yakato Yeisu ineliyan yaiya kaiwena iwalowalo. ");
INSERT INTO tte_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tobenaline itagelakeile Yeisu koina na ineli, “Guyau, yaiya kaiwena kuwalowalo?” ");
INSERT INTO tte_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Kabo Yeisu iba, “Naga beledine tupwatupwanane yayabuta gaeba mena na yaolena koina. Bwaimwana tomonane.” Yeisu ana walo iyemwawasi kabo beledi iyabuta yo iwolena Yudasa iya Saimon Isikaliota natuna. ");
INSERT INTO tte_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Saugana Yudasa beledine ikalai Seitani ilusae koina. Yeisu iwaloba, “Ginauline nuwanuwam uginauli kupaisowa mwayamwayauwan.” ");
INSERT INTO tte_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kabo tobenaliyao simiyamiya teibeli mena nige sikakatai tawae kaiwena Yeisu iwalo bwaite besiele Yudasa koina. ");
INSERT INTO tte_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudasa iya mane tobwana kana togitekalatan mwa tobenaliyao tupwaliyao sibatoko Yeisu iwalolau koina na ilau gogo igimwala kekanne kaiwena o nuwana ilau mane tupwana tobubutuma iwolegili. ");
INSERT INTO tte_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Saugana Yudasa beledine ikalai kabo ikaisulu mwa ilau boniboniyai mena. ");
INSERT INTO tte_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Saugana Yudasa ilaoko Yeisu iwaloba, “Bwaite sauga tomo kani sigitai Tomo Natuna ana wasawasa yo iya tabe koina kani Yaubada ana wasawasa sigitai. ");
INSERT INTO tte_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Iya kani koina Yaubada ana wasawasa sigitai yo Yaubada ibomayoi kani Tomo Natuna ana wasawasa iginauli yo kani iginauli mwayamwayau mena. ");
INSERT INTO tte_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Natuguwao, yau nige yamiyamiya kolimiu sauga mamalawena. Kani kwaloyaiyau bwaite saugane koina na yawaloyoi kolimiu besiele beyabeyana yawaloko Yudiya toloinao kolili, komiu nige sowasowamiu kwalau dedeinane koina yalalaune. ");
INSERT INTO tte_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Bwaite loina waluwaluna yaeyawa kolimiu, kwamulolo kaigeda kaigeda koina. Kwamulolo kaigeda kaigeda koina besiele yamulolo kolimiu. ");
INSERT INTO tte_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tem kwamulolo kaigeda kaigeda koina, iya koina kani tomo meuloina sikatai komiu walo yawasosi kagu tomuliyayao.” ");
INSERT INTO tte_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Mwa Saimon Pita Yeisu ineliyan iba, “Guyau, to kulalau?” Yeisu iba, “Bwaite sauga yalalau dedeinane koina nige sowasowam kulau koina na kani muli mena kabo kulaoma koliyau.” ");
INSERT INTO tte_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Kabo Pita iwalolau koina iba, “Guyau, gubesi na bwaite saugane nige sowasowagu yalau koina, yabomayoi yatalamwagau yaboita kaiwem.” ");
INSERT INTO tte_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Kabo Yeisu kainana iyamaisa iba, “Gubesi, kani yawasosi kuboma kutalamwagiwo na kuboita kaiwegu? Yawalo yawasosi koliwo, muliya kabo kamkam tauna ivalam na kowa kani meyaiyona kuuvalayagau.” ");
INSERT INTO tte_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yeisu iwalolau ana tobenaliyao kolili iba, “Tabu kwamamatausi, yo wakakatewakaka, Yaubada kwameliyani yo yau kwameliyagau. ");
INSERT INTO tte_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tamagu ana nume mena biliutusi sibaibaiwa simiyamiya, kani yalau na yakatububunagili kaiwemiu. Tem walone bwaite mwakota nige sowasowana yawalowen kolimiu besiele. ");
INSERT INTO tte_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tem yalau na yanuwane yakatububunan na imwawasi kabo muli mena kani yapileyoima na yakalaimiu. Na toweya koina yamiyamiya komiu kani besiele koina kwamiyamiya. ");
INSERT INTO tte_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Dedeinane koina yalalaune kana kamwasa wakataiyako.” ");
INSERT INTO tte_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Mwa Tomasi Yeisu ineliyan iba, “Taubala, toisabo kamwasa koina kulalau? Kamwasane kai nige kakakatai.” ");
INSERT INTO tte_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yo Yeisu kainana iyamaisa iba, “Yau kamwasa, walo yawasosi, yo yawasimiu yaina. Nige kamwasa yaboyoi imiyamiya Tamagu koina bwaimwanamo yau koliyau. ");
INSERT INTO tte_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tem ukwataiyau besiele Tamagu ukwatai. Bwaite saugane koina yo sauga ilalaoma Tamagu ukwataiyako yo ugitaiyako.” ");
INSERT INTO tte_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Kabo Pilipi iwaloba, “Guyau, bwaimwanamo nuwanuwamai tem Tamam kuyakenayagimai.” ");
INSERT INTO tte_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yeisu Pilipi iyokoiyan iwaloba, “Sauga imamalawe kowa te yau tamiyamiya. Gubesi na nige ukwakataiyau? Tem yaiya igitaiyau bwaimwana Tamagu igitaiyako. Mwa tawae kaiwena kuwaloba, ‘Tamam kuyakenayagimai.’ ");
INSERT INTO tte_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Tomalaele kumeli yakato yau Tamagu koina yamiyamiya yo tabe Tamagu iya koliyau imiyamiya, bwaite besiele awa? Walone bwaite yawalowalowegiline kolimiu nige yau yagu walo na Tamagu ana walo, kaiwena iya koliyau imiyamiya yo tabe koliyau ana paisowa ipaipaisowaili. ");
INSERT INTO tte_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yagu walone kwameliyagili, yau yamiyamiya Tamagu koina yo Tamagu imiyamiya koliyau. Na tem yagu walone nige kwamemeliyagili besi kwamelimo yagu paisowa kaikaiweline kilakilalali tawae yaginauliliko kolili. ");
INSERT INTO tte_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Yawalo yawasosi kolimiu, yaiya tem imeli koliyau kani sauga muli mena paisowa kaikaiweline yaginaginauliline kani iginaulili. Kani ana paisowane yagu paisowane ilalaki-gabaegili, kaiwena yau yalalau Tamagu koina na Yaluyaluwa Tabuna yayawasayama kolimiu. ");
INSERT INTO tte_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na tawae esagu mena wakawanoiyan kani yaginauli ami kawanoine besiele, na mesabana yagu paisowane kolili Tamagu esana wasawasana yakeleisinan. ");
INSERT INTO tte_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Tem tawae yabo kaiwena wakawanoi esagu mena kani yaginauli besiele.” ");
INSERT INTO tte_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yeisu iwaloyoi iba, “Tem kwamulolo koliyau yagu loinane kwaobigaili. ");
INSERT INTO tte_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Kani yakawanoi Tamagu koina na kami tosagu yabo iyawasayama na mekamikava sauga meuloina. Tosagu bwaine iya Yaluyaluwa Tabuna na iya towalo yawasosi. Na tomo yanuwa yaulina nige sowasowali sikalai kali sagu, kaiwena nige sigigitai yo nige sikakatai. Na komiu wakatai kaiwena iya imiyayai mekamikava yawasimiu koina. ");
INSERT INTO tte_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nige sowasowana yalogabaegimiu komiu sinasinagemiu, na kani muli mena yapileyoima kolimiu. ");
INSERT INTO tte_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sauga kikiunamo na tomo yanuwa yaulina kani nige sigigitaiyau yoi na komiu kani wagitaiyau. Kaiwena meyawasigu mwa komiu besiele kani meyawasimiu. ");
INSERT INTO tte_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Bwaine kaliyatene koina wakatai kani yau yamiyamiya Tamagu koina na komiu kwamiyamiya koliyau na yau yamiyamiya kolimiu. ");
INSERT INTO tte_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Tem yaiya yagu loina ikalaili na iobigaili iya imulolo koliyau. Iya kagu tomulolone Tamagu kani imulolo koina. Yau tabe besiele kani yamulolo koina na yabomayoi yayakenayagau koina.” ");
INSERT INTO tte_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Kabo Yudasa yabo, iya tamana esana Yemesa, iwaloba, “Guyau, gubesi mwa kani kubomayoi kam koleya kuyakenayan kolimai na nige kuyakenayagiwo tomo yanuwa yaulina kolili?” ");
INSERT INTO tte_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yeisu Yudasa kainana iyamaisa iwaloba, “Tem yaiya imulolo koliyau yagu walo iobigaili. Kabo Tamagu kani imulolo tomone koina na Tamagu yo yau kalau koina mekamakava kamiyamiya. ");
INSERT INTO tte_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Na tem yaiya nige imumulolo koliyau yo yagu yakayakatai nige ioobigaili kani nige sowasowana kalau koina. Mwa yakayakatai bwaite kwabebenalagiline nige yaboma yagu nuwatu mena na ilaoma Tamagu koina iya kagu toyawasa. ");
INSERT INTO tte_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Saugana yamiyamiya mekamikava walo bwaite yawalowegili kolimiu, ");
INSERT INTO tte_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","na Tamagu muli mena kani kami tosagu iyawasayama esagu mena iya Yaluyaluwa Tabuna na iya kani ginauli meuloina iyakenayagimiu yo iyanuwapeimiu walo meuloina siya yawalowegiliko kolimiu. ");
INSERT INTO tte_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nuwadaumwali yalogabaen mekamikava, yo yagu nuwadaumwali yaeyawa kolimiu. Tawae yae-eyawane nige besiele yanuwa yaulina iyeyawa. Tabu katemiu siwawakaka yo tabu kwamamatausi. ");
INSERT INTO tte_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Komiu kwabenalagiliko tawae yawalowegili yakato yau yalalau na muli mena kani yapileyoima kolimiu. Tem kwamulolo koliyau kani kwayaliyaya kaiwena yalalau Tamagu koina iya ilalaki kabo yau. ");
INSERT INTO tte_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Bwaite saugane koina ginauli yawalo-masala bagunayagili kolimiu, na sauga silalaoma kolili tem ginauliline siyawatagilima, bwaite yagu walone kani wakawa-yawasosi-yagili. ");
INSERT INTO tte_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nige sowasowana yaedeedede mamalawe kolimiu kaiwena yanuwa yaulina kana toloina naenaena Seitani ilalaoma. Na nige yabo ana kaiwe koliyau. ");
INSERT INTO tte_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yabomayoi yatalamwagau kaiwena nuwanuwagu yanuwa yaulina ikatai yakato yamulolo Tamagu koina yo ana loina meuloina yaginaulili ana walo koliyau besiele. Kwalaoma na dedei bwaite talogabaen.” ");
INSERT INTO tte_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yeisu iwalo kolili iba, “Yau mayau uweuwe yawasosi, na Tamagu iya topaisowa tano. ");
INSERT INTO tte_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Toisabo lagalaga nige iuwe itom-gabaen koliyau. Na toisabo lagalaga iuwe namwanamwa kani itom-yawasi na mesabana iuwe kanna ibaibaiwa. ");
INSERT INTO tte_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Na komiu yatom-yawasimiuko kaiwena tawae yawalowen kolimiu wakataiyako. ");
INSERT INTO tte_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kwamiyamiya koliyau na yau yamiyamiya kolimiu. Nige sowasowana lagalaga yabo iuwe tem nige imiyamiya mayaune koina. Besiele tabe nige sowasowana kwauwe tem nige kwamiyamiya koliyau. ");
INSERT INTO tte_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Yau mayau yaina na komiu lagalagana. Tem yaiya imiyamiya koliyau yo yau yamiyamiya koina kani iuwe lalakina. Na tem koliyau nige kwamiyamiya kani nige sowasowana ginauli yabo kwapaisowai. ");
INSERT INTO tte_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tem yaiya nige koliyau imiyamiya iya besiele mayau lagalagana sigabaen iweweka. Lagalagane wewekali meuloina sitano-gogon na sigabaen mayau mena iwedoli. ");
INSERT INTO tte_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Tem kwamiyamiya koliyau yo yagu walone imiyamiya kolimiu na ginauli tawae wakawanoiyan kani kwalobai. ");
INSERT INTO tte_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Siya siuwe lalakina siya kagu tomuliyayao yawasosi. Ali paisowane uwena koina tomo sigitai na Tamagu sitobalan. ");
INSERT INTO tte_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yamulolo kolimiu besiele Tamagu imulolo koliyau. Kabo kwamiyamiya yagu mulolo kalona mena. ");
INSERT INTO tte_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tem yagu loina kwaobigaili kani yagu mulolo kalona mena kwamiyamiya, besiele Tamagu ana loina yaobigaili mwa yamiyamiya ana mulolo kalona mena. ");
INSERT INTO tte_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Walone bwaite yawalowegili kolimiu na mesabana yagu yaliyaya imiyamiya kolimiu na kwayaliyaya lalakina. ");
INSERT INTO tte_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Bwaite yagu loina, kwaemulomulolo-wagimiu kamikavao kolili besiele yagu mulolo kolimiu. ");
INSERT INTO tte_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mulolo lalakisosinaele tem yaiya yawasina italamwan na iboita kanakavao kaiweli, bwaite mulolo yawasosi. Bwaite mulolone iya mulolo meuloina isae-gabaegili. ");
INSERT INTO tte_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tem yagu loina kwaobigaili komiu kaukavao. ");
INSERT INTO tte_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Baguna yakawa-topaisowa-yagimiu, kaiwena topaisowa nige ilolonamwayan na ana taubala ana nuwatu ikatai. Na sauga bwaite koina yakawa-kava-yagimiu kaiwena ginauli meuloina Tamagu iwalowen koliyau yawalowegiliko kolimiu, mwa kaiwena yakawa-kava-yagimiu. ");
INSERT INTO tte_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Komiu nige wagigite-sipwaiyau, na yau yagite-sipwaimiu na kwalau kwauwe na uwemiyaone kani simiyayai. Mwa tem tawae wakawanoiyan esagu mena kani Tamagu iyeyawa. ");
INSERT INTO tte_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mwa bwaite yagu loina, kwamulolo kaigeda kaigeda koina.” ");
INSERT INTO tte_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yeisu iba, “Tem tomo yanuwa yaulina sikalomagigi-lagimiu kwanuwatu-kalatan yakato yau sikalomagigili-baguna-yagau. ");
INSERT INTO tte_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Na tem komiu kwamiyamiya ali bodane kalona mena tomo yanuwa yaulina mena kani simulolo kolimiu yakato komiu ali bodao. Na iyamo nigele, komiu nige ali boda kaiwena yakele-yawatagilagimiu ali bodane luwana mena. Bwaite kaiwena mwa sikalomagigi-lagimiu. ");
INSERT INTO tte_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tawae yawalowegiliko kolimiu yagu walone kwanuwatu-kalatagili, topaisowa nige ilalalaki kabo ana taubala. Mwa tem siyakamkamnayau kani tabe besiele siyakamkamnamiu. Na tem yagu walo siobigaili kani ami walo siobigaili besiele. ");
INSERT INTO tte_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yau kaiwegu mumugali bwaite kani sipaisowai kolimiu kaiwena komiu yagu bodao, na tabe kaiwena kagu toyawasa nige sikakatai. ");
INSERT INTO tte_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Tem nige yalaoma yawawalo kolili kani nige siyayatala ali pwanoli kaiwena. Na nigele, yalaomako kolili yawalo mwa koina nige sowasowana ali pwanoli kaiwena siwalo-vivila. ");
INSERT INTO tte_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yaiya tem isikotanagau tabe besiele Tamagu isikotanan. ");
INSERT INTO tte_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Baguna nige yakewa yabo imiyamiya tomo ali pwanoli kaiweli kaiwena naga yalalaoma. Muli mena yalaoma yo ginauli kaba nuwapwanopwano tupwali yapaisowaili, paisowane nige sauga yabo tomo yabo ipapaisowai. Yagu paisowane sigitai na iyamo nige simemeli-yagau, yau yo Tamagu sikalomagigi-lagimai. Mwa kaiwena yawalo yakato kani yatala silobai ali pwanoli kaiwena. ");
INSERT INTO tte_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Na iyawatagili koliyau bwaite besiele mesabana ali Buki Tabu ana walo iyamala yawasosi iwaloba, ‘Ali kalomagigi-lagaune nige yaina.’ ");
INSERT INTO tte_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Kami Tosagu kani ilaomaya Tamagu koina. Iya Yaluyaluwa Tabuna yo towalo yawasosi. Kani yayawasayawa kolimiu na iwalo-masala kaiwegu. ");
INSERT INTO tte_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Tabe komiu besiele kani kwawalo-masala kaiwegu, kaiwena saugana paisowa yayatubu komiu mekaukavao.” ");
INSERT INTO tte_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yeisu iwaloyoi iba, “Walone bwaite kabona yawalowegili kolimiu mesabana ikabi-yakaiwemiu na tabu woya ilalaowa kolimiu na kwalolosuwala. ");
INSERT INTO tte_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Sauga muliya kani siwalo kwayawatagili ali nume tapwalolo kolili na nige sowasowana mekamikavao kwatapwalolo. Tabe sauga ilalaoma tem tomo iunuimiu kani ibatoko yakato Yaubada ana paisowa igiginauli. ");
INSERT INTO tte_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Paisowa besiele bwaitete kani siginauli kolimiu kaiwena nige sikakataiyau, besiele Tamagu nige sikakatai. ");
INSERT INTO tte_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Bwaite walone yawalo-baguna-yagili kolimiu kabo muli mena ginauline siyawatagili. Tem siyawatagili yagu walone kwanuwatu-kalatagili kaiwena yayanuwapeimiuko. Baguna walone bwaite nige yawawalowegili kolimiu kaiwena yau mekamikava.” ");
INSERT INTO tte_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yeisu iba, “Sauga bwaitete yalologabaegimiu na yalalauyoi kagu toyawasayauma koina. Na nige yabo kowa bwaite sauga kuneneli koliyau, ‘Toweya kulalau?’ ");
INSERT INTO tte_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Yagu walo kaiweli nuwamiu sipolowe lalakina. ");
INSERT INTO tte_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Yawalo yawasosi kolimiu, ami namwanamwa kaiwena yalologabaegimiu. Kaiwena tem nige yalalau kani kami Tosagu nige ilalaoma, mwa yalau na kami Tosagu yayawasayama kolimiu. ");
INSERT INTO tte_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tem ilaoma kani ginauli yaiyona iyakenayagili tomo meuloili kolili, bwaimwa ali pwanoli, mumugana namwanamwana kana katai, yo ali yatala. ");
INSERT INTO tte_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kani ali pwanoli iyakenayagili, kaiwena nige simemeli koliyau. ");
INSERT INTO tte_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yo kani mumugana namwanamwana kana katai iyakenayagili, kaiwena yau yalalau Tamagu koina na kani nige wagigitaiyau yoi. ");
INSERT INTO tte_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Yo kani iyakenayagili yakato kani sauga muli mena iyatalayagili, kaiwena yanuwa yaulina kana toloina bwaimwa Seitani, iyatalayanako yo kana loina iwalowenako. ");
INSERT INTO tte_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ginauli sibaibaiwa nuwanuwagu yawalowegili kolimiu na komiu nige sowasowamiu. ");
INSERT INTO tte_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Na saugana Yaluyaluwa Tabuna, bwaimwa towalo yawasosi, ilaoma kani ibaguna-yagimiu walo yawasosi koina. Kani nige iboma ana nuwatu mena iedeedede na kani iedeedede tawae ibenalan na ginauliline iyakenayagimiu tawae kani situbu manimiu mena. ");
INSERT INTO tte_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ana nuwatu kani ikalaili koliyau na iyakenayagimiu na bwaine koina kani esagu ikeleisinan. ");
INSERT INTO tte_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nuwatu meuloina Tamagu kaiwena yo yau tabe kaiwegu. Bwaite kaiwena yawaloba Yaluyaluwa Tabuna ana nuwatu kani ikalaili koliyau na iyakenayagimiu.” ");
INSERT INTO tte_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Mwa Yeisu tabe iwalo kolili iba, “Sauga kubwakubwana koina kani nige wagigitaiyau na sauga kubwakubwana mulina mena kabo wagitaiyau.” ");
INSERT INTO tte_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ana tobenaliyao tupwaliyao sibomayoi sienelineli-yagili siwaloba, “Na gubesi ana walone bwaite kana katai? Kaiwena iwalo yakato sauga kubwakubwana kani nige tagigitai na sauga kubwakubwana mulina mena kani tagitai. Tabe iwalo yakato yainane bwaimwa ilalau Tamana koina. ");
INSERT INTO tte_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Na bwaite walone, sauga kubwakubwana, tawae kana bui? Ana walone nige nuwala imamayaleyan.” ");
INSERT INTO tte_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yeisu ikatai ana tobenaliyao nuwanuwali sineliyan kabo iwalo kolili iwaloba, “Kabona yawalo yakato sauga kubwakubwana koina kani nige wagigitaiyau na sauga kubwakubwana mulina mena kabo wagitaiyau. Nuwana bwaite walone kaiwena kwabomayoi kwaenelineli-yagimiu, awa? ");
INSERT INTO tte_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yawalo yawasosi kolimiu, kikiunamo kani nuwamiu sinae yo kwavalam koyasili kaiwegu na iyamo tomo yanuwa yaulina siya kagu tokalomagigili, kani siyaliyaya. Sauga kubwakubwana mulina mena kabo ami valam iyamala ami kaba yaliyaya. ");
INSERT INTO tte_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tem saugana sine ana sauga kabi kani kamkamna lalakina ilobai. Na saugana tem melumelu ikabiyan iyawatagili kani ana kamkamna meuloina imwawasi na iyaliyaya kaiwena melumelu iyawatagilimako mayale mena. ");
INSERT INTO tte_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Besiele bwaite saugane koina kwanuwanae na sauga kubwakubwana koina kani wagitaiyau yoi na kwayaliyaya. Na ami yaliyayane nige sowasowana yabo ikele-gabaen kolimiu. ");
INSERT INTO tte_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Bwaine kaliyateliyaone kolili kani nige sowasowana ginauli yabo kwaneliyan koliyau. Yawalo yawasosi kolimiu, tem tawae wakawanoiyan esagu mena Tamagu kani iyeyawa kolimiu. ");
INSERT INTO tte_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Baguna yo kanasiga kabona nige ginauli yabo wakakawanoiyan esagu mena. Wakawanoi na kwalobai, na koina kwayaliyaya lalakina.” ");
INSERT INTO tte_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yeisu iwaloyoi iba, “Walo kobwaibwaili mena yaedeedede na sauga ilalaoma kani nige sowasowana walo kobwaibwaili mena yaedeedede kolimiu, kani yawalo dudulai kolimiu Tamagu kaiwena. ");
INSERT INTO tte_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Sauganane koina esagu mena kani wakawanoi. Nige yawawaloba yakato yau yakawanoi Tamagu koina kaiwemiu, ");
INSERT INTO tte_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kaiwena Tamagu iboma imulolo kolimiu. Imulolo kolimiu kaiwena kwamulolo koliyau yo kwameli yau yalaomaya koina. ");
INSERT INTO tte_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yau Tamagu koina yalaoma yo yanuwa yaulina mena yamiyamiya, koina bwaite sauga yanuwa yaulina yalologabaeni na yapipileyoi Tamagu koina.” ");
INSERT INTO tte_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ana tobenaliyao walone bwaite sibenalan mwa siwalolau koina, siba, “Guyau, bwaite saugane kabo nuwamai simayale, kaiwena nige kuedeedede walo kobwaibwaili mena. ");
INSERT INTO tte_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Bwaite koina kakatai yawasosi yakato kowa ginauli meuloili ukwataili. Koina tabu kaneneliyagiwo kaiwena ama nuwatu meuloili ukwatailiko. Mwa bwaite saugane kameliyagiwo yakato kowa Yaubada koina kulaoma.” ");
INSERT INTO tte_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yeisu iwalo kolili iba, “Kabo kwameliyagau, wa? ");
INSERT INTO tte_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Sauga iyaele ilalaoma yo iyawatagilimako meuloimiu kani kwasagena-gwaligwali kwalau ami dedei kaigeda kaigeda na yau kani kwalogabaegau yaboma. Na iyamo kani nige yaboma kaiwena yau Tamagu mekaukava. ");
INSERT INTO tte_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nuwanuwagu kwamiya daumwali kaiwena kwamiyamiya koliyau, bwaite kaiwena mwa walone yawalowegili kolimiu. Sauga muli mena kani wakamkamna yanuwa yaulina mena. Na wakatepatu kaiwena yanuwa yaulina ana kaiwe yakaiwe-gabaenako.” ");
INSERT INTO tte_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yeisu ana walo bwaite iyemwawasi kabo manna isae bulibuli mena na iba, “Tamagu, sauga ilaomako na yau natum esagu ukeleisinan na mesabana yau tabe esam kani yakeleisinani. ");
INSERT INTO tte_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kaiwena loina yo kaiwe kuyelima koliyau mwa tomo meuloili yaloinayagili na yau sowasowagu yawasi miyamiya yaina yaolena tomo meuloina siya analiyao kuyelima koliyau. ");
INSERT INTO tte_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na yawasi miyayainane bwaite, mesabana sikatai yakato kowa Yaubada yawasosi, na tabe sikatai yau Yeisu Keliso kuyawasayauma. ");
INSERT INTO tte_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Esam yakeleisinanako yanuwa yaulina mena kaiwena paisowa kuyeyama yaemwawasi-yako. ");
INSERT INTO tte_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tamagu nuwanuwagu yamiyamiya koliwo sauga bwaite. Nuwanuwagu esagu kuyawasawasa besiele ala wasawasa beyabeyana kowa te yau tamiyamiya muliya kabo yanuwa yaulina kuyamayale.” ");
INSERT INTO tte_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Yeisu iwaloyoi iba, “Yayakenayagiwoko tomone kolili siya yanuwa yaulina mena ukwalaili na kuyelima. Siya am tomoyao yo kuyelima koliyau yo am walo siobigaili. ");
INSERT INTO tte_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Mwa sauga bwaite sikatai ginauli meuloina kuyelima koliyau silaomaya koliwo. ");
INSERT INTO tte_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Walone siya kuyelima koliyau yawalowegiliko kolili mwa walone sibenalagiliko yo kaiweli siyaliyaya, mwa sikawa-yawasosi yo sikatai yakato yau yalaomaya koliwo mwa simeli yakato kowa kuyawasayau. ");
INSERT INTO tte_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Yakawanoi kaiweli. Nige yakakawanoi tomo yanuwa yaulina kaiweli na siya kuyeyelimane kaiweli, kaiwena siya am tomoyao. ");
INSERT INTO tte_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yagu tomo meuloina siya am tomoyao yo am tomoyao meuloili siya yagu tomoyao. Na siya mumugali mena esagu sikeleisinan. ");
INSERT INTO tte_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Bwaite sauga yalalaowa koliwo, kani nige yamimiyayoi yanuwa yaulina mena na siya kani simiyamiya yanuwa yaulina mena. Kowa Tamagu esam yakasisi, ugite-kalatagili esam kaikaiwena mena bwaimwana iya esane kuyeyama koliyau na mesabana silaoma siyaboda kaigeda besiele kowa te yau tamiya kaigeda. ");
INSERT INTO tte_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Saugana yamiyamiya mekaukavao yagite-kalatagili esam kaikaiwena koina bwaine esane iya kuyeyama koliyau. Na nige yabo ikwakwalalele bwaimwanamo tomone baguna Buki Tabu koina iya kaiwena iwalowalone na yakato isilae. ");
INSERT INTO tte_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Sauga bwaite yau yanuwa yaulina mena na yalalaowa koliwo. Yagu kawanoi yawalowenako koliwo na mesabana yagu yaliyaya kateli iloyakalapowon. ");
INSERT INTO tte_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","16","Am walone yawalowegiliko kolili mwa tomo yanuwa yaulina sikalomagigi-lagili kaiwena siya nige simiyamiya bodane yanuwa yaulina tomoliyao kolili besiele tabe yau nige yamiyamiya ali bodaone kolili. Nige yakakawanoi kaiweli na yakato yanuwa yaulina mena ukele-gabaegili na iyamo tabu Seitani ikakabitonagili. ");
INSERT INTO tte_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Am walone walo yawasosi, mwa nuwanuwagu walo yawasosine ipaisowa kolili na bwaine koina kuyakasisiyagili am paisowa kaiwena. ");
INSERT INTO tte_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Yayawasali siyawatagili dedei meuloina kolili besiele kuyawasayau yalaoma yanuwa yaulina mena. ");
INSERT INTO tte_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Siya kaiweli yayakasisiyagau koliwo kaiwena nuwanuwagu siya besiele siyakasisiyagili koliwo.” ");
INSERT INTO tte_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Yeisu iwaloyoi iba, “Nige yakakawanoi yagu tobenaliyaomo kaiweli na yakawanoi siya naga tobenaliyao ali guguye simeliyan kaiweli. ");
INSERT INTO tte_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","23","Yakawanoi kaiweli na mesabana siyaboda kaigeda. Tamagu nuwanuwagu simiya kaigeda besiele kowa te yau tamiya kaigeda na simiyamiya kolila na mesabana yanuwa yaulina sikatai yakato kumuloloiyau yo kumuloloili mwa kaiwena kuyawasayauma. Baguna am wasawasa kuyeyamako koliyau. Mwa bwaine wasawasane koina yayawasawasaliko na siyaboda kaigeda besiele kowa te yau. ");
INSERT INTO tte_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tamagu nuwanuwagu siya kuyeyelimane mekaukavao kamiya toyawa toweya koina yamiyamiya na yagu wasawasa sigitai, bwaine wasawasane kuyeyama kaiwena kumulolo koliyau muliya kabo yanuwa yaulina kuyamayale. ");
INSERT INTO tte_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tamagu kowa todudulaisosi kaigedamo. Yanuwa yaulina nige sikakataiwo na yau yakataiwo yo siya kuyelimakone sikataiyako yakato kowa kuyawasayau. ");
INSERT INTO tte_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Yayakenayagiwoko kolili na iyamo kani yapaipaisowa-kalatan kaiwena nuwanuwagu siemulomulolo-wagili besiele kumulolo koliyau na yau yamiyamiya kolili.” ");
INSERT INTO tte_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Kabo Yeisu ana kawanoi iyemwawasi yo ana tobenaliyao mekanakavao silau, yo waila esana Kidilon sigayopanaisi dedei yabo mena. Bwaine koina mayau Olibe yaowana sitotolo kabo mekanakavao dedeinane koina silusae. ");
INSERT INTO tte_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","3","Kabo sauganane koina boda yabo me ali odam yo mayale yo tabe me ali gogo kaleyayao siyawatagilima. Bodane kaloli mena siya tokaleyayao yo Nume Tabu kana pilisiman tupwaliyao yo tabe Yudasa Isikaliota, iya Yeisu kana tokalomagigili. Na Yudasa dedeinane kana kamwasa iyakenayagili kaiwena dedeinane ikatai yo tabe sauga ibaibaiwa Yeisu me ana tobenaliyao silaulau dedeinane koina. Bodane bwaite silaomaya topwaoli lalakili yo Palisiyao siya siyaele simiyamiya Yelusalema koina. ");
INSERT INTO tte_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yeisu ikataiyako tawae kani iyawatagili mwa ilau tokaleyayao bodane kolili ineli iba, “Yaiya kwaloyaloyai?” ");
INSERT INTO tte_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Kainana siyamaisa siwaloba, “Yeisu game Nasaleta.” Kabo Yeisu iba, “Yau bwaite.” Na Yudasa iyaele bodane luwana mena itotolo. ");
INSERT INTO tte_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Saugana Yeisu iba “Yau bwaite” mwa boda meuloili siutu-pileyoi sibeku bwatano mena. ");
INSERT INTO tte_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yeisu ineliyoi iba, “Yaiya kwaloyaloyai?” Kabo siwaloyoi siba, “Yeisu, game Nasaleta.” ");
INSERT INTO tte_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Kabo kainali iyamaisa iba, “Yawaloko kolimiu yawaloba, yau bwaite. Tem kwaloyaloyaiyau kaukavaone bwaite wakabi-gabaegili silau.” ");
INSERT INTO tte_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Iwalo bwaine besiele tawae kabona iwalowen ana kawanoi kalona mena saugana iwaloba, “Tamagu siya kuyeyelimane nige yabo ikwakwalalele”. Na bwaite sauga iyamala yawasosi. ");
INSERT INTO tte_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Pita ana kaleya kelepana iniwisiyama mwa topwaoli lalakina ana topaisowa tenana ulaulana mena ikoutusi. Topaisowane esana Maliko. ");
INSERT INTO tte_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kabo Yeisu iwalolau Pita koina iba, “Am kaleya kelepana kupei-yavivilayoi ana kaba miya mena. Gubesi, am nuwatu yakato kamkamna komwana bwaimwa Tamagu iyeyama kani tabu yanunuma?” ");
INSERT INTO tte_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kabo tokaleya bodane me ali tobaguna yabo yo tabe siya Yudiya Nume Tabu kana pilisiman silaoma Yeisu sikabikalatan yo nimana sipanili. ");
INSERT INTO tte_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Siyogan silawan Anasa koina Yelusalema koina. Na Anasa iya Kaiyapa wainena tamana. Kaiyapa iya topwaoli lalakili ali tobaguna bwaine bolimene koina. ");
INSERT INTO tte_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Na tabe iya Kaiyapane tauna kona iwalolau ana boda Yudiya toloinao kolili ali miyagogo koina iba, “Nige wakakatai yakato ginauli namwanamwanaele tomo kaigeda iboita meuloili kaiweli na tabu tomo Yudiya meuloila taboboita Loma ana loina kaikaiwena koina.” ");
INSERT INTO tte_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","16","Saugana Yeisu silalawan Anasa koina Saimon Pita yo tobenali yabo Yeisu mulina mena silau. Bwaine tobenali yabone Anasa ikatai namwanamwai. Mwa boda meuloina yo tobenali yabone silau numene kana gana kalona mena. Na Pita nige ilulusae na itotoloya ganane kana gamwa mena. Kabo tobenali yabone itagelakeile Pita igitai nige ilulusae kabo ipileyoi yo ilau iedeedede gamwa kana togitekalatan sinene koina kabo Pita iyogan yo silusae. ");
INSERT INTO tte_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kabo togitekalatanne sinene Pita ineliyan iba, “Kowa nuwana Yeisu ana tobenali yabo wa?” Kabo Pita iuvala iba, “Yau nigele.” ");
INSERT INTO tte_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Boniyainane itulutulu mwa topaisowao yo pilisiman mayau sipei ganane kalona mena yo simwasimwasiguli, yo Pita tabe ilusae kolili mekalikava simwasimwasiguli. ");
INSERT INTO tte_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Yo topwaoli lalakina Anasa Yeisu ineliyan kana tomuliyayao kaiweli yo tabe ana yakayakatai kaiwena. ");
INSERT INTO tte_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Kabo Yeisu iwaloba, “Sauga meuloina yaedeedede tomo meuloili kolili mayale mena. Yo tabe yayakayakatai tomo Yudiya ali kaba miyagogo kolili nuwana Nume Tabu koina o ali nume tapwalolo kolili. Nige walo yabo yawawalo-wadam. ");
INSERT INTO tte_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Tawae kaiwena kuneliyagau? Siya analiyao yagu walo sibenalan kuneliyagili, yagu walo meuloina sikatai.” ");
INSERT INTO tte_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Saugana Yeisu iwalo bwaine besiele kabo pilisiman yabo itotolo Yeisu dedeina mena papalina mena ikoi iyokoiyan iba, “Tawae kaiwena topwaoli lalakina kainana kuyamaisa bwaimwa besiele?” ");
INSERT INTO tte_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Kabo Yeisu kainana iyamaisa iba, “Tem walo yabo yawalo-sapuli kuwalowen tomo meuloili kolili na sibenalan. Na tem yagu walo idudulai tawae kaiwena kusapi-papali-yau?” ");
INSERT INTO tte_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kabo Anasa Yeisu iyawasa mekana pani ilau topwaoli lalakina Kaiyapa koina. ");
INSERT INTO tte_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita iyaele itotolo imwasimwasiguli mwa tomo yabo iwalolau koina iwaloba, “Kowa bwaine tomone ana tobenali yabo, awa?” Na Pita iuvalayoi iba, “Yau nigele.” ");
INSERT INTO tte_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Topwaoli lalakina ana topaisowa yabo iya totouna kabona tenana Pita ikoutusi iwalolau Pita koina iba, “Kowa yagitaiwo Yeisu mekamkava Olibe dedeina koina, awa?” ");
INSERT INTO tte_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Na Pita iuvalayoi, yo bwaine sauganane koina kamkam tauna ivalam. ");
INSERT INTO tte_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kaiyapa me ana bodao toloinao Yeisu sineliyan, imwawasi kabo siyawasa Pailato ana nume wasawasana koina. Na Pailato iya Loma tomona yo Sisa ipei Yudiya ali gavana na Yudiya dedeina iloiloinayan. Bwaite saugane koina malala boniboniyaina. Yudiya bodane nige silulusae gavana ana nume mena kisi tubuliyao ali loina yabo silikwai na siuladumdumli na mwalelikwa soina kanna nige sikakan. ");
INSERT INTO tte_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mwa koinaele Pailato iyawatagili yo Yudiya toloinao ineliyagili iba, “Tomo bwaite tawae ana pwanoli mwa koina kwayakewai?” ");
INSERT INTO tte_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kainana siyamaisa siba, “Tem nige naenaena yabo igiginauli nige sowasowana kakalaiyama koliwo.” ");
INSERT INTO tte_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailato iwaloba, “Wakalai kwalawan na kwabomayoi ami loina koina kwayatalayan.” Kabo Yudiya toloinaone siwaloba, “Komiu Loma ami loina nige itatalam-wagimai na tem kai tomo Yudiya ama loina kaginauli na mesabana ana boita kaloinayan.” ");
INSERT INTO tte_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Bwaite besiele ilaoma na Yeisu ana walo iyamala yawasosi. Baguna iwalowenako ana boita kana lau kana koleya. ");
INSERT INTO tte_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pailato ipileyoi ilusae ana nume mena kabo Yeisu iyoganama yo ineliyan iba, “Gubesi, kowa Yudiya ali kin o nigele?” ");
INSERT INTO tte_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yeisu kainana iyamaisa iba, “Walone bwaimwa kuwalowalowegiline kuboma am nuwatu mena o nuwana Yudiya siwalowen koliwo kaiwegu?” ");
INSERT INTO tte_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailato Yeisu kainana iyamaisa iwaloba, “Nigele molosi. Yau nige Yudiya besi. Na kowa am tomoyao yo tabe topwaoli lalakili silawagiwoma koliyau. Nae esana uginauli mwa silawagiwoma koliyau?” ");
INSERT INTO tte_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yeisu iwaloba, “Yanuwa yaulina nige yau kaba loina. Tem besiele kagu tosaguwo sitoloma na sikaleya kaiwegu na tabu Yudiya toloinao sipapanyau. Na nigele, bwaite yanuwane nige yau kaba loina.” ");
INSERT INTO tte_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Kabo Pailato ineliyan iba, “Mwa yakato kowa kin yabo?” Yeisu kainana iyamaisa iba, “Kubomayoi kuwalowenako. Bwaite iya kaiwena mwa yalaoma yanuwa yaulina mena sikabiyau na yawalo-masala tomo kolili walo yawasosi kaiwena. Analiyao siya nuwanuwali walo yawasosi sibenalan nuwanuwali yagu walo sibenalagili.” ");
INSERT INTO tte_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Kabo Pailato iba, “Na walo yawasosine tawae?” Kabo Pailato iyawatagiliyoi Yudiya toloinao kolili iwaloba, “Nige yabo kana yakewa yalolobai koina na mesabana ana yatala yaloinayan. ");
INSERT INTO tte_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Wakatai bolime kaigeda kaigeda mwalelikwa soina kana sauga koina tomo yabo nume pan mena imiyamiya yalivasi kaiwemiu na iyawatagili. Gubesi, nuwanuwamiu komiu tomo Yudiya ami kin yalivasi kaiwemiu?” ");
INSERT INTO tte_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kainana siyamaisa siyogayoga siwaloba, “Nigele, iya nigele. Nuwanuwamai Balabasi kulivasi.” Tomo Yudiya siwalo besiele. Na Balabasi iya toloinalikwa lalakina. ");
INSERT INTO tte_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pailato tokaleya iloinayagili Yeisu siyogan na siunui maina matumatuwana koina. ");
INSERT INTO tte_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kabo samasamali sakosakonana sikalaili yo sipaisowai na sipwaom kulukuluna mena. Yo kaleko malamalawena sikalai besiele kin kana kaleko yo siyalikwa, ");
INSERT INTO tte_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","yo silau koina na siwaloba, “Kagutoki, Yudiya ali kin kowa.” Kabo sikoi papalina mena. ");
INSERT INTO tte_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailato iyawatagiliyoi yo iwalolau Yudiya bodane kolili iba, “Kwabenabenali, kani yayawatagilanama wagitai na wakatai yakato nige yabo ana pwanoli yalolobai kana yakewa kaiwena na mesabana yaloinayan ana yatala.” ");
INSERT INTO tte_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kabo Yeisu iyawatagili samasamali kulukuluna mena yo kana kwama malamalawena ilikwa. Mwa Pailato iwalo kolili iwaloba, “Wagitai, bwaite tomonaele.” ");
INSERT INTO tte_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Saugana topwaoli lalakili yo pilisimanwo Yeisu sigitai siwaloba, “Kwayakelose, kwayakelose.” Na Pailato kainali iyamaisa iwaloba, “Komiu kwaboma wakalai na kwayakelose, nige yabo ana pwanoli yalolobai na koina yayakewai na yawalo-masalan ana yatala kaiwena.” ");
INSERT INTO tte_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Na tomo Yudiya Pailato sisamalului siba, “Ama loina imiyamiya loinane iwawalo yakato iboita, kaiwena iwawalo yakato iya Yaubada Natuna.” ");
INSERT INTO tte_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Bwaite walone Pailato ibenalani mwa imatausi lalakina. ");
INSERT INTO tte_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kabo Pailato Yeisu iyogan iluseyanyoi ana nume mena yo ineliyan yoi iba, “Toweya koina kulaomaya?” Na Yeisu nige Pailato kainana iyayamaisa. ");
INSERT INTO tte_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kabo Pailato iba, “Tawae kaiwena genuwam kuwaloma koliyau? Nige ukwakatai me yagu loina yakato sowasowana yalivasiwo yo sowasowana yaloinayagiwo siyakeloseo?” ");
INSERT INTO tte_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yeisu Pailato kainana iyamaisa iba, “Tem Yaubada nige loinane iyeyeyawa koliwo nige yabo am kaiwe imiyamiya koliyau. Na iya italam-wagau koliwo ana pwanoli ilalakisosi kabo kowa am pwanoli.” ");
INSERT INTO tte_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Bwaine sauganane koina Pailato kamwasa iloyaloyai na tem Yeisu ilivasi. Na iyamo tomo Yudiya siyogayoga siwaloba, “Tem tomo bwaimwa kulivasi kowa nige Sisa ana eliyam. Kaiwena tem yaiya ibomayoi iwaloba ‘yau kin’ iya Sisa isinali.” ");
INSERT INTO tte_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Saugana Pailato Yudiya ali walone ibenalan Yeisu iyogan-iyawatagilima mayale mena tomo Yudiya meuloili manli mena. Kabo Pailato imiyasio toyatala ali kaba miya mena bwaine kaba miyane nume dedeina mena esana veku kamwasa. Na kaina Ibeliu koina siba Gabada. ");
INSERT INTO tte_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Bwaine sauganane koina ilaoko ipwasinasina na sauga katububu mwalelikwa soina kanna kaiwena. Kabo Pailato iwalolau Yudiya kolili iba, “Ami kinwa iyaelete.” ");
INSERT INTO tte_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Na siya Yudiya siyoga siba, “Kulowasiyan kulowasiyan. Kulawan kuyakelose.” Pailato ineliyagili iba, “Nuwanuwamiu ami kin yayakelose?” Na topwaoli lalakili kainana siyamaisa siwaloba, “Nige yaboyoi ama kin bwaimwanamo Sisa iboma.” ");
INSERT INTO tte_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kabo Pailato Yeisu italamwan kolili na siyakelose. Mwa Loma tokaleyayao Yeisu siyogan silawan. ");
INSERT INTO tte_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tokaleyayaone siloinayan ibomayoi kana kelose ikewai yo iyawatagili ilau Yelusalema kana gana dagelana mena dedeine esana kulukulu tuwatuwana yanuwana, kaina Ibeliu siwaloba Goligota. ");
INSERT INTO tte_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Yo bwaine koina siyakelose. Na tomo labui mekanakavao siyakeloseli, yabo ulaulana mena na yabo gegebana mena. ");
INSERT INTO tte_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailato kilakilala yabo ilele na iloinayagili kelosene kewana mena situtu-yapatu, bwaine lelelelene iba, “Bwaite Yeisu game Nasaleta, Yudiya ali kin.” ");
INSERT INTO tte_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yudiya sibaibaiwa lelelele bwainene sowasowali siyasili kaiwena dedeinane Yeisu koina siyakelose nige mamalawena ali taonne Yelusalema koina. Mwa silele kaina yaiyona kolili kaina Ibeliu, kaina Latin yo tabe kaina Giliki koina. ");
INSERT INTO tte_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yudiya topwaoli lalakili silau Pailato koina siwaloba, “Inamwanamwaele tem tabu kulelele ‘Yudiya ali kin’ na kulele ‘Tomo bwaite iwawalo yau Yudiya ali kin’.” ");
INSERT INTO tte_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Na Pailato kainali iyamaisa iwaloba, “Tawae yaleleyako bwaimwa iyaele yaleleyako.” ");
INSERT INTO tte_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Saugana tokaleya Yeisu siyakelose kabo kana kaleko sikalai yo sisoiyagili sibomayoi yoli esopali kolili, kaigeda kaigeda kana kaleko ikalai. Na kana kwama malamalawena tabe imiyamiya. Bwaine kaleko kaigeda koina sikona nige kana tubwe ipapagan, ");
INSERT INTO tte_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","mwa siwaloba, “Tabu taiigali na venu mena taloyai tem yaiya ibaguna kwamane ikalai kana kwama.” Siginauli besiele na Buki Tabu ana walo ilaoma iyamala yawasosi iwaloba, “Kau kaleko sisoiyagili yo venu mena siloyai yaiya kau kwamane kani ikalai.” ");
INSERT INTO tte_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Kelosene salina mena sinesineo esopali sitotolo, Meli iya Yeisu sinana yo Meli kanakava kikiuna yo Meli yabo iya Kaliopasi wainena yo Meli yaboyoi ilaomaya yanuwa Magidala koina. ");
INSERT INTO tte_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yeisu manna ilobi sinana igitai yo tobenaline iya imulolososi koina salina mena itotolo mwa iwalolau sinana koina iba, “Sine, bwaimwa natum.” ");
INSERT INTO tte_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Besiele tobenaline koina iwalolau iwaloba, “Bwaimwa sinam.” Sauganane koina tobenaline Yeisu sinana iyogan ilawan ana nume mena ikawa-sina-yan kabo igite-kalatan. ");
INSERT INTO tte_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yeisu ikatai yakato ana paisowa meuloina imwawasi, kabo iwaloba, “Galogalogu imagu.” Walone bwaite iwalowen na mesabana Buki Tabu ana walo ilaoma iyamala yawasosi. ");
INSERT INTO tte_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na oine malumaluluna mekomwana imiyamiya bwaine koina kabo balou sikalai yo siyalakwa oinene koina yo mayau yabo esana isopi lagalagana koina sisakona yo siyagaseyan Yeisu sopana mena. ");
INSERT INTO tte_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Saugana inuma kabo iwaloba, “Imwawasi.” Mwa Yeisu galogalona itapwai yo yawasina imwawasi. ");
INSERT INTO tte_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Bwaine kaliyatenane Yudiya ali kaliyate katububu kaiwena kikiunamo ali Sabati iyatubu yo kaliyatenane koina kani mwalelikwa soina siginauli. Mwa Yudiya toloinao genuwali Yeisu yo toboitane labuine kwapiliyao sitaketake kelose mena Sabati kana sauga koina. Mwa koina silau yo Pailato koina sikawanoi na tem iwalolau tokaleya kolili na Yeisu yo yoli labuine kaekaeliyao sikogoluli na siboita mwayamwayau, na kwapiliyao sikele-kaisulu-wagili. ");
INSERT INTO tte_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pailato italam kabo tokaleyayao silaoma yoli labuine sitaketake Yeisu mekalikava kelose mena kabo kaigeda kaena sikogoluli yo silau yaboyoine koina besiele tabe. ");
INSERT INTO tte_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Na saugana silau Yeisu koina sigitai Yeisu iboitako mwa nige kaena sikokogoluli. ");
INSERT INTO tte_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kabo tokaleya yabo wamali ikalai yo Yeisu lusulusuna dedeina mena isakona kabo kwasine yo waila sididi-yawatagilima. ");
INSERT INTO tte_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Na tomo yabo ibomayoi ginauliline igitaili manna mena mwa iwaloba walo yawasosi yo ikatai ana walo dudulaina iwalowalo na mesabana komiu tabe kwameli. ");
INSERT INTO tte_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ginauline bwaite siyawatagili na Buki Tabu ana walo-masala iyamala yawasosi iwaloba, “Kani nige tuwatuwana yabo itatagolu.” ");
INSERT INTO tte_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Yo besiele Buki Tabu ana walo-masala yabo iba, “Tomo bwaine sisakona sauga muli mena kani sikilala yakato ali Mesaiya siunuyamate.” ");
INSERT INTO tte_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yo ginauli bwaite meuloina simwawasi, kabo tomo yabo esana Yosepa, iya Alimadiya tomona, ilaoma yo Pailato koina Yeisu yona ikawanoiyan. Na Yosepa bwaite iya Yeisu kana tomuliya yabo yo inuwabui wadam mena kaiwena imatausi Yudiya toloinao kolili. Pailato italam kabo ilau Yeisu yona ikalai. ");
INSERT INTO tte_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimo ilau Yosepa mekanakava, iya Nikodimone baguna ilau Yeisu koina boniyai mena. Nikodimo ana laune koina olo labui bwalaili namwanamwali ikalaili bwaimwa yabo esana mula yo yabo esana aloe siebwelili na kali polowe besiele teti (30) kilogelam. ");
INSERT INTO tte_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yeisu yona sikalai yo olone bwalaina namwanamwana sisau koina yo kaleko malamalawena namwanamwana yona koina sisuma. Siginauli bwaite besiele kaiwena tomo Yudiya mumugali tem ali toboita sipepeili salai mena kani siginauli besiele. ");
INSERT INTO tte_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Dedeine koina Yeisu siyakelosene kawasi kana koleya namwanamwana imiyamiya bwaine dedeine koina salai waluwaluna sikeli imiyamiya nige sauga yabo toboita yabo sipepei koina. ");
INSERT INTO tte_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yeisu yona sipei salaine koina kaiwena salaine nige imamamalawesosi kelosene koina yo tabe kikiunamo Yudiya ali Sabati, bwaimwa kita ala Satade, kani iyatubu, kaiwena sauga ilaomako. ");
INSERT INTO tte_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Yo wiki kana kaliyate bagubagunana bwaimwa kita ala Sabati malala boniboniyaina naga dabwelo imwamwalisae na Meli Magidala ilau salai mena mwa igitai salai kana kokaukausi vekune siyatapipili-suwalanako. ");
INSERT INTO tte_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kabo isagena ipileyoi ilau Yeisu ana tobenaliyao labui Saimoni Pita yo yabo iya Yeisu imulolososi koina kolili iwaloba, “Ala Taubala yona sikele-yawatagilanako salai mena, yo toweya sipeiya nige yakakatai.” ");
INSERT INTO tte_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kabo Pita mekanakava tobenaline silau salai mena. ");
INSERT INTO tte_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Yoli labuine sisagena mwa tobenaline yabo isagena baguna ana eliyam Pita isagena-gabaen mwa iyawatagili baguna salai mena. ");
INSERT INTO tte_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Yo igite-lusae Yeisu yona kana sumamo kaleko igitaili na iyamo nige ilulusae. ");
INSERT INTO tte_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Muli mena Pita iyawatagili idudulaimo ilau ilusae salai mena. Yeisu yona kana sumamo kaleko igitaili bwaine koina, ");
INSERT INTO tte_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","yo tabe igitaiyoi kalekone kulukuluna kana suma. Nige mekanakava yona kana suma na kana koleya besiele tomo simouli na sipei yakasali. ");
INSERT INTO tte_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kabo tobenaline iya toyawatagili bagunane salai mena muli mena tabe besiele ilusae kabo igitai mwa imeli. ");
INSERT INTO tte_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Na iyamo nige naga nuwali imamayale Buki Tabu ana walo-masala yakato Yeisu kani kaliyate yaiyona koina boita mena itoloyoi. ");
INSERT INTO tte_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kabo yoli labuine sipileyoi silau ali nume mena. ");
INSERT INTO tte_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Meli iyaele salai gana mulina mena itotolo na ivalavalam. Me ana valam na iboeboe salai mena, ");
INSERT INTO tte_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","kabo anelose labui igitaili kali kwama mayamayalena simiyamiya Yeisu ana kaba keno mena, yabo kulubwawa mena na yabo kaegigi mena. ");
INSERT INTO tte_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Kabo anelosene Meli sineliyan siba, “Sine, tawae kaiwena kuvalavalam?” Kabo kainali iyamaisa iwaloba, “Yagu Guyau yona sikalaiyako na nige yakakatai toweya koina sipei.” ");
INSERT INTO tte_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Saugana iwalo bwaite besiele kabo itagelakeile igitai Yeisu itotolo na nige ikakatai yakato iya Yeisu. ");
INSERT INTO tte_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Kabo Yeisu ineli iwaloba, “Sine tawae kaiwena kuvalavalam? Yaiya kuloyaloyai?” Meli ibatoko nuwana iya pwalawesi kali togitekalatan yabo kabo iwalo koina iba, “Taubala, tem yagu Guyau yona ukwalaiyako kuwalowen koliyau toweya koina kupei na yalau yakalai.” ");
INSERT INTO tte_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yeisu iwalolau koina iba, “Meli”. Kabo Meli itagelakeile yo kaina Ibeliu mena iwaloba, “Laboni”. Na walo bwaite kana katai toyakayakatai. ");
INSERT INTO tte_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yeisu iwalolau koina iba, “Tabu kisi ukwabitonagau kaiwena nige naga yasasae Tamagu koina. Na kulau kaukavao kolili kuwalo yau yalalau Tamagu koina yo Tamamiu, yagu Yaubada yo ami Yaubada.” ");
INSERT INTO tte_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Yeisu ana walo iyemwawasi kabo Meli Magidala ipileyoi ilau iedeedede tobenaliyao kolili iba, “Guyau yagitai”. Yo tawae Yeisu kainana iwalowen Meli koina iwalowegili kolili. ");
INSERT INTO tte_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kabo wiki kana kaliyate bagubagunana, bwaimwa kita ala Sabati, lolaunane koina, Yeisu ana tobenaliyao nume yabo koina silusae, yo gamwa sikausi, na kalona mena simiyamiya, me ali matausi siya Yudiya toloinao kaiweli. Kabo Yeisu itolo-mayale luwaluwalili mena, mwa kolili iwaloba, “Daumwali kolimiu.” ");
INSERT INTO tte_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yo muli mena nimana yo dedeina iyakenayagili, kabo tobenaliyao siyaliyaya kaiwena ali Guyau sigitai. ");
INSERT INTO tte_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yo Yeisu tabe iwaloyoi kolili iba, “Daumwali kolimiu. Tamagu iya iyawasayau, yo yau tabe kani besiele yayawasamiu.” ");
INSERT INTO tte_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ana walo bwaine iwalowegili kabo yawasina iyui-panaisan ana tobenaliyao kolili iwaloba, “Yaluyaluwa Tabuna wakalai. ");
INSERT INTO tte_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Tem tomo ali pwanoli kwanuwatu-pwaikili, Yaubada kani inuwatu-pwaikili. Na tem tomo ali pwanoli nige kwanunuwatu-pwaikili besiele kani Yaubada nige inunuwatu-pwaikili.” ");
INSERT INTO tte_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Na Yeisu iyawatagiliyoi ana tobenaliyao kolili, kalikava yabo esana Tomasi iya esana yaboyoi Didiluwaluwa iya nige mekalikava. ");
INSERT INTO tte_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Saugana Tomasi ilaoma kanakavao ana wasa siwolena siwaloba, “Ala Guyau kagitai.” Kabo Tomasi iwalolau kolili iwaloba, “Kanasiga mangu mena yagitai yo nimagu yapei nimana gaina kolili yo lusulusuna gaina pwawati mena sisasakona kabo yakawa-yawasosi.” ");
INSERT INTO tte_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wiki kaigeda imwawasi mulina mena tobenaliyao meuloili simiyamiya nume kalona mena Tomasi mekalikava. Gamwa sikausili na iyamo Yeisu itolo-yawatagili luwaluwalili mena iwaloba, “Daumwali kolimiu.” ");
INSERT INTO tte_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kabo Yeisu iwalolau Tomasi koina iwaloba, “Nimagu ugitaili na nimam kupei koina. Yo nimam kuyagayan na kupei wamaline leleyanane gulana mena dedeigu mena. Tabu nuwalabulabui na kumeli.” ");
INSERT INTO tte_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Mwa Tomasi iba, “Kowa yagu Guyau yo yagu Yaubada.” ");
INSERT INTO tte_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kabo Yeisu iwalo koina iba, “Tomasi, kaiwena ugiteyau mwa kumeli. Na siya nige sigigiteyau simeli, Yaubada kani iwalo-muloloili.” ");
INSERT INTO tte_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yeisu ginauli kaba nuwapwanopwano sibaibaiwa iginaulili tobenaliyao manli mena na nige meuloili yaleleleli buki bwaite kalona mena. ");
INSERT INTO tte_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Na walo bwaite yaleleli na mesabana kwameli yakato Yeisu iya Mesaiya, Yaubada Natuna, na ami meline koina kani yawasi yawasosi esana mena kwalobai. ");
INSERT INTO tte_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Muli mena Yeisu iyawatagili yoi ana tobenaliyao kolili kalita Taibiliya dekawana mena. Ana yawatagili kolili bwaite besiele. ");
INSERT INTO tte_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomasi iya esana Didiluwaluwa, Nataniela iya ilaomaya yanuwa Kena koina Galili dedeina mena yo Sebedi natunao labui mekalikavao tobenaliyao labui. ");
INSERT INTO tte_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pita iwalolau kolili iba, “Yau yalalau yagogomana.” Kabo siwaloba, “Kai kalalaowa tabe.” Mwa silobi simwalisae ali waga mena yo silau siyaoyaoni boniyai meuloina na bwaine boniyainane koina nige kikiuna iye yabo siyayakona. ");
INSERT INTO tte_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","8","Malala kikiuna dabwelo itunsae kabo Yeisu ilobi dekawa mena itolo. Tobenaliyaone Yeisu sigitai na nige sikakatai yakato iya Yeisu. Kali mwayaga nige imamamalawe Yeisu koina nuwana besiele andeledi mita. Mwa iyoga kolili iba, “Eliyamwao, tabu iye yabo kwayayakona?” Kainana siyamaisa siwaloba, “Nigele.” Kabo iwalolau kolili iwaloba, “Ami yagidane wagabaen ami wagane dedeina mena ulaulamiu mena na kani iye tupwana kwayakona.” Kabo yagida sigabae-yatalu kalita mena mwa nige sowasowali sitabeisin waga mena kaiwena iye sikona sibaibaiwasosi. Kabo tobenaline, iya Yeisu imulolososi koina, iwalolau Pita koina iwaloba, “Bwaine iya Guyau.” Saugana Pita walone bwaite ibenalan kabo kana kwama ikalai ilikwa mwa ikapusele-kaisulu kalita mena ituba isae dekawa mena. Na tobenaline tupwaliyaone muli mena kabo waga mena siwose-saema yo ali yagida sitabei siseyan dekawa mena kaiwena dekawa nige imamamalawe kolili. Ali yagida iye ipowon. ");
INSERT INTO tte_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Saugana sisaema waga mena sikaisulu sigayosae dekawa mena sigitai mayau yo iye tupwali kau mena simiyamiya yo tabe besiele pwalawa. ");
INSERT INTO tte_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Kabo Yeisu iwalo kolili iwaloba, “Iye tupwana wakalailima na tagabu-lawagili mayau mena.” ");
INSERT INTO tte_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Mwa Pita ilobi imwalisae waga mena na yagida iniuli-seyan magu mena. Yagidane koina iye lalakili sibaibaiwa sikona kali baibaiwa besiele andeledi pipti tili (153) na iyamo yagidane nige itataigali. ");
INSERT INTO tte_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yeisu iwalolau kolili iwaloba, “Kwalaoma wakekan.” Na nige yabo yaiya ineneli ‘yaiya kowa?’ kaiwena sikataiyako iya ali Guyau. ");
INSERT INTO tte_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Kabo Yeisu ilau beledi ikalai yo iwolena kolili yo tabe iginauli besiele iye kolili. ");
INSERT INTO tte_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Bwaite Yeisu ana yawatagili yaiyonana ana tobenaliyao kolili ana toloyoima ana boita mulina mena. ");
INSERT INTO tte_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kabo ali kekan mulina mena, Yeisu Saimon Pita ineliyan iba, “Saimon, kowa Yoni natuna, kumulolo koliyau kabo muli mena siya kamkavao kolili?” Kabo Pita Yeisu kainana iyamaisa iba, “Besiele Guyau, ukwataiyauko yamulolo koliwo.” Kabo Yeisu iwaloba, “Yagu lamiyao ugitekalatagili.” ");
INSERT INTO tte_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yeisu ana neli labuina iwaloba, “Saimon, kowa Yoni natuna, kumulolososi koliyau?” Yo Pita iba, “Besiele Guyau, ukwataiyauko yamulolo koliwo.” Kabo Yeisu iba, “Yagu sipiyao ugitekalatagili.” ");
INSERT INTO tte_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yeisu ana neli yaiyonana iwaloba, “Saimoni, kowa Yoni natuna, kumulolo koliyau?” Pita katena ikamkamna kaiwena Yeisu meyaiyona ineliyan iwaloba, “Kumulolo koliyau?” Pita iba, “Guyau, ginauli meuloina ukwatailiko. Ukwataiyako yamulolo koliwo.” Kabo Yeisu iba, “Yagu sipiyao ugitekalatagili. ");
INSERT INTO tte_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Yo yawalo yawasosi koliwo am sauga kilakai koina kuboma kam kwama kulikwali na toisabo dedei koina nuwanuwam kulau koina kani koina kulau. Na tem am sauga tautaubala kani nimam kuyagayagili na tomo uloili nimam sipanli, na toisabo dedei koina nige nuwanuwam kulau koina bwaine dedeine koina kani silawagiwo.” ");
INSERT INTO tte_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yeisu walo bwaite iwalowen Pita ana boita sabi yakelosena kaiwena na ana boitane koina Yaubada esana ikeleisin. Kabo Yeisu iwaloba, “Pita, kumuliya koliyau.” ");
INSERT INTO tte_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita itagelakeile yo tobenaline Yeisu imulolososi koina igitai, na tobenaline iya kekan kana sauga mena imiyasio Yeisu salina mena yo sauganane koina ineliyan iba, “Guyau, yaiya kani iwalo-masalagiwo?” ");
INSERT INTO tte_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Saugana Pita tobenaline igitai kabo ineli Yeisu koina iba, “Guyau, tomone bwaite iya kani gubesi?” ");
INSERT INTO tte_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yeisu kainana iyamaisa iwaloba, “Tem nuwanuwagu kani imiyamiya kanasiga yapileyoima. Bwaimwa kowa nige am dedei. Bwai kumuliyamo koliyau.” ");
INSERT INTO tte_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kabo wasa mwakomwakota yabo ilau tomeliwo kolili yakato Yeisu iwawalo tobenaline kani nige iboboita. Na iyamo Yeisu nige iwawalo besiele yakato kani nige iboboita. Na iwaloba, “Tem nuwanuwagu kani imiyamiya kanasiga yapileyoima. Bwaimwa kowa nige am dedei.” ");
INSERT INTO tte_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Tobenaline iya ginauliline kaiweli iwalo-masala kolimiu bwaite yau. Yo buki bwaite yau yalele. Yagu walo-masalane siya walo yawasosi. ");
INSERT INTO tte_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yeisu ginauli sibaibaiwa tabe iginaulili besiele. Na nige meuloili yaleleleli bwaite bukine koina. Tem ana paisowa kaigeda kaigeda taleleli buki mena kani yanuwa yaulina buki ikalapowon. ");
INSERT INTO tte_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ae Tiopilo, kagutoki lalakina yagu eliyam. Yau Luka yagu buki bagubagunana kalona mena yalele ginauli meuloina tawae iyawatagili Yeisu koina, ana kabi yo ana paisowa yo ana yakayakatai, ");
INSERT INTO tte_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","yo kanasiga Yaubada ikalai isae bulibuli mena, meuloina yalele. Naga isasae bulibuli mena na Yeisu itolo-mayale ana apositolo manli mena siya igitesipwaili, yo Yaluyaluwa Tabuna ana kaiwe mena kali loina iwolegili. ");
INSERT INTO tte_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ana boita mulina mena itoloyoi kabo muli mena kaliyate poti (40) kalona mena iyawayawatagili kolili, yo kaba gite meuloina koina iyakenayagili kabo ana toloyoine sikawa yawasosiyan yo Yaubada ana kaba loina kaiwena iyakataili. ");
INSERT INTO tte_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Iyaelemo mekalikava simiyamiya yo kali loina iwolegili iwaloba, “Tabu Yelusalema kwalologabaeni, na baguna Tamagu ana waloyameli yawalowegiliko kolimiu kaiwena kwasanasana. ");
INSERT INTO tte_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kwanuwatu-kalatan Yoni waila mena iyababitaisomiu, na kaliyate isamo simiyamiya na Tamagu kani Yaluyaluwa Tabuna koina iyababitaisomiu.” ");
INSERT INTO tte_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Sauga yabo koina Yeisu me ana tobenaliyao simiyagogo yo sineli koina, siba, “Taubala, bwaite sauga kani kaba loina kuyapileyoi Isileli kolili na sibomamo siloinayagili?” ");
INSERT INTO tte_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Kabo Yeisu iwalo kolili iba, “Nige ami katai yabo, Tamagu iya ibomamo sauga ipeiliko yo ikatailiko, na nige sowasowana komiu wakatai tawanesana loinane ipaisowaili. ");
INSERT INTO tte_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Na Yaluyaluwa Tabuna kani ilobima kolimiu yo ana kaiwe mena ikabiyakaiwemiu, na Yelusalema taon koina yo dedei Yudiya yo dedei Sameliya yanuwaliyaone kolili yo yanuwa yaulina dedeiliyao meuloili kolili kani wasana namwanamwana kaiwegu waguguyeyani.” ");
INSERT INTO tte_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kabo ana walo bwaite iyemwawasi yo manli mena Yaubada Yeisu ikalai isasae bulibuli mena yo yaloyaloi ikausi mwa nige sowasowali sigitaiyoi. ");
INSERT INTO tte_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ilogabaegiliko na nagamo sitotolo sisakasakai-sae bulibuli mena, kabo sauganane koina tomo labui mekali kwama mayamayaleli sitolo salili mena, ");
INSERT INTO tte_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","yo siwaloba, “Tomo Galili, tawae kaiwena kwatotolo kwasakasakai-sae bulibuli mena? Yaubada Yeisu ikalai isasae bulibuli mena, na naga kani ilobiyoima, besiele tawae wagitai ana saene koina, besiele kani ana lobiyoima koina.” ");
INSERT INTO tte_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kabo koya esana Olibe silogabaen na sipileyoi Yelusalema bwaimwa nige kelamamalawe, nuwana kilomita kaigeda. ");
INSERT INTO tte_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Yo nume mena simwalisae sisae kewa mena silusae biliutusi yabo koina bwaite ali kaba kaiyawasi saugana simiyamiya Yelusalema kalona mena. Siya bwaite Pita, Yoni, Yemesa, Anidulu, Pilipi, Tomasi, Batolomiu, Madiu yo Yemesa yabo iya Alipio natuna yo Saimoni iya ilaoma boda esana Selot yo Yudasa iya Yemesa yabo natuna. ");
INSERT INTO tte_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Meuloili bwaitete me ali talam siwaloyameli yakato sauga meuloina silogogo na sikawakawanoi Yaubada koina, sinesineo mekalikavao, yo Meli iya Yeisu sinana, yo Yeisu kanakavao yawasosi mekalikavao. ");
INSERT INTO tte_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sauga yabo koina tomeli meuloili silogogoma yo kali baibaiwa wan andeledi tuwenti (120). Pita itolo luwaluwalili mena ");
INSERT INTO tte_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","yo iwaloba, “Kaukavao yo duguwao, beyabeyana Yaluyaluwa Tabuna Deibida gamwana mena iwalo-masala Yudasa kaiwena. Ee walo yawasosi, bwaite sauga ana walo-masalane iyawatagiliko. Kaiwena saugana Yeisu kana tokalomagigili silau na sikabikalatan Yudasa isaguili kaiwena iya kamwasane iyakenayagili yo bodane iyoganli. ");
INSERT INTO tte_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yo tauna kona Yudasa iya Yeisu ana tobenali yabo luwamai mena yo mekamakava kapaisowa toyawa.” ");
INSERT INTO tte_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Na ana paisowa naenaena maisana mane siwolena, kabo ikalai yo bwatano yabo igimwalai yo kabo bwaine koina ibeku yo italuboita, diyana itaigali yo malisina iyawatagili. ");
INSERT INTO tte_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yelusalema kana tomiya meuloili wasane sibenalan kabo siya kainali koina bwatano esana sipei Akelidama, kana bui bwaite Kwasine Bwatanona.) ");
INSERT INTO tte_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kabo Pita iwaloyoi iba, “Walo yawasosi, Deibida ana lelelele Buki Same kalona mena Yudasa kaiwena iyawatagiliko kaiwena iwaloba, ‘Ana nume kani ilaoma gaibuna. Kani nige tomo yabo imimiya ana numene kalona mena.’ Yo tabe Deibida ileleyoi iwaloba, ‘Tomo uloina kani tomone ana paisowa ikalai.’” ");
INSERT INTO tte_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Yo Pita iwaloyoi iba, “Saugana talolokeikeile Guyau Yeisu mekalakava, ana babitaiso Yoni koina kanasiga ana sae bulibuli mena tomeli tupwaliyao mekalakavao simiyamiya mwa ginauli meuloina sigitai. Kaloli mena Yudasa miyalaena taloyai na yabo tagitesipwai na isaguila Yeisu ana toloyoi wasana taluwewasayani.” ");
INSERT INTO tte_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kabo tomo labui esaliyao sikeleisinagili, yabo esana Yosepa iya esana labuina Basabasi yo esana yaiyonana Yusito na tomo labuina esana Matayasi. ");
INSERT INTO tte_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Muli mena sikawanoi Yaubada koina, siwalo “Guyau, kowa tomo meuloimai ama nuwatu ukwataili, kabo am gitesipwa tomo labui bwaite kaiweli kolimai kuyakenayagimai ");
INSERT INTO tte_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","yo Yudasa iyamiyalae yo iyamala am apositolo, kaiwena Yudasa bwaite paisowane ilogabaeni iboita ilau yanuwa wedowedolina koina.” ");
INSERT INTO tte_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mwa koina Yudiya mumugali gitesipwa kaiwena simuliya, na Matayasi esana siyasili kabo iya ilusae Yeisu ana apositolo ali boda koina yoli ilebeni mekanakavao. ");
INSERT INTO tte_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Saugana Yudiya ali soi kana kaliyate yabo esana sipei Pentikos iyawatagili Yeisu kana tomeliwo meuloili silogogoma nume lalakina yabo koina. ");
INSERT INTO tte_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kabo bulibuli mena dagugu yabo sibenalani besiele yaumai kaikaiwena daguguna, yo ali nume kalona meuloina iloyapowon, ");
INSERT INTO tte_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","na ginauli yabo sigitai kana koleya besiele mayau kalapulupululuna memenana, ilobima itatagwaligwali kaigeda kaigeda kulukululi mena sitowa. ");
INSERT INTO tte_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kabo Yaluyaluwa Tabuna iloyakalapowonli yo siyatun kaina uloina uloina kolili siedeedede, besiele Yaluyaluwa Tabuna ana olena. ");
INSERT INTO tte_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na sauganane bwaine koina taumanao simiyamiya Yelusalema koina sabi tapwalolo Nume Tabu koina. Siya tomo Yudiya simeli Yaubada koina silaomaya yanuwa yaulina dedei kaigeda kaigeda kolili. ");
INSERT INTO tte_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Saugana dagugune iyawatagili taumanaone tupwali sibenalani yo silogogoma kabo sigite-lobai Yeisu kana tomeliwo siedeedede taumanaowa kainali mena mwa kaiwena nuwali ipwanopwano lalakina. ");
INSERT INTO tte_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Yo taumanaone siwaloba, “Wagitai. Siya siedeededene meuloili Galili tomoliyao na nige kainali mena siedeedede. ");
INSERT INTO tte_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Gubesi na kita kaigeda kaigeda kainala mena tabenalani siedeedede? Kaiwena kita kainala uloina uloina. ");
INSERT INTO tte_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Na kita Palitiya yo Midi yo Elami yo Mesopotemiya kana tomiyayao, yo Yudiya yo Kapadosiya yo Ponitiyo yo Eisiya yo Piligiya yo Pamipiliya yo Itipita yo Kiliti yo Alibiya yo tabe Libiya dedeinao Sailini salina mena. Tupwalao taumanao Loma koina talaoma. Tupwalao kita Yudiya yawasosi yo tupwalao nige Yudiya na iyamo nigwenigwe mumugana takalai yo Yudiya ali tapwalolo mena talusae. Na boda bwaitete, siya Yeisu kana tomeliwo, siwalowalo Yaubada ana paisowa kaikaiwena kaiwena na siedeedede kita meuloila kainala uloina uloina kolili.” ");
INSERT INTO tte_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kabo meuloili me ali nuwapwanopwano sibomamo kolili siwalowalo, “Ginauli bwaite kana katai gubesi?” ");
INSERT INTO tte_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Na taumanaone tupwaliyao sitalatalawasi tomeliwone kolili siwaloba, “Boda bwaitete waila kaikaiwena sinuma-yalalaki-sosi.” ");
INSERT INTO tte_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Na Pita yoli ilebeni salili mena itolo yo kainana lalakina mena iedeedede boda lalakina kolili iba, “Komiu Yudiya tomoliyao yo Yelusalema kana tomiya meuloimiu yagu walo kwabenalani, yo nuwamiu simayale ");
INSERT INTO tte_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","yakato kai nige kanunuma kabaleya besiele ami nuwatune. Sauga bwaite naen (9) koloki malala. Kita nigele mumugala besiele oine tanuma malamalala. ");
INSERT INTO tte_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tawae wagitagitai sauga bwaite Yaubada iwalo-masalanako baguna palopita Yoeli gamwana mena, iwaloba, ");
INSERT INTO tte_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Naga sauga ana kaba mwawasi koina, Yaluyaluwagu yasuwai tomo meuloili kolili, kabo natumiyao tataoliyao yo sinesineoliyao sipalopisai yo ami kilakaiwo yakenayan sigitaili, yo ami tautaubalao kenoliyao sikenoili. ");
INSERT INTO tte_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Walo yawasosi, sauga bwaine koina kani Yaluyaluwagu yasuwai yagu topaisowao tataoliyao yo sinesineoliyao kolili, yo siwalo-masala kaiwegu. ");
INSERT INTO tte_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Kabo ginauli kaba nuwa pwanopwano yaginaulili bulibuli mena dabwelo iboniboniyai yo waikena ibalagiya kana gite besiele kwasine. Yo ginauli kilakilala kani yaginaulili yanuwa yaulina mena. Kwasine yo mayau yo bogau balubaluna kani siyawatagili kabo muli mena yatala kana sauga mena Guyau ana kaliyate lalakina yo ana wasawasa siyawatagilima. ");
INSERT INTO tte_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Yo analiyao siyoga Yaubada koina sagu kaiwena kani ileboili.’” ");
INSERT INTO tte_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita iwaloyoi iba, “Tomo Isileli, walo bwaite kwabenalagili. Yaubada Yeisu Game Nasaleta ana loina yo ana kaiwe iyakena-yagimiuko, kaiwena ginauli kaba nuwapwanopwano yo ginauli kaikaiweli iginaulili Yeisu nimana mena. Wakataiyako bwaimwa kaiwena mwa ipaisowaili luwaluwalimiu mena. ");
INSERT INTO tte_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Beyabeyana Yaubada Yeisu kaiwena iloina, yo tawae tem ilobai yanuwa yaulina mena Yaubada ikataiyako, na komiu wakalomagigilan yo ami loina mena tomo naenaeli siyakelose yo iboita. ");
INSERT INTO tte_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Na Yaubada boita ana dedei mena Yeisu ileboi yo ikele-yatoloyoi, kaiwena nige sowasowana boita ana kaiwe koina imiyayai. ");
INSERT INTO tte_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Bwaite Yeisu kaiwena beyabeyana Deibida iwaloba, ‘Yeoba yagitai mangu mena imiyayai. Yo sauga meuloina iyaele ulaulagu mena imiyamiya, ikabiyakaiweyau na tabu yabebelu. ");
INSERT INTO tte_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Bwaite iya kaiwena kategu iyaliyaya lalakina yo kainagu mena yatobatobali. Bwagana tem yaboita, Yaubada ana waloyameli yanuwatu-kalatan yo me yagu katepatu. ");
INSERT INTO tte_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kaiwena nige sowana kusikotanagau na yamiyamiya salai mena. Tabe kani nige kutatalam am topaisowa yakayakasisina yona ibobowa. ");
INSERT INTO tte_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Yawasi miyamiya yaina kana kamwasa kuyakenayagauko. Kabo saugana nimam mena yamiyamiya kani yaliyaya kategu iloyapowon.’” ");
INSERT INTO tte_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Muli mena Pita iwaloyoi iba, “Kaukavao, yawalo yawasosi kolimiu, takataiyako tubula Kin Deibida iboitako yo sipului salaina iyaelete imiyamiya sauga kabona. ");
INSERT INTO tte_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Iya palopita yo Yaubada ana waloyameli koina imeli. Yaubada waloyameli kaikaiwena yabo iginauli yakato Deibida tubuna yabo iyamala kin besiele iya. ");
INSERT INTO tte_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Deibida ikatai tawae naga Yaubada kani iginauli saugana Mesaiya ikele-yatoloyoi kabo iwaloba, ‘Yaubada, nige sowana kusikotanagau na yamiyamiya salai mena. Tabe kani nige kutatalam am topaisowa yakayakasisina yona ibobowa.’ ");
INSERT INTO tte_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yaubada iya Yeisu ikele-yatoloyoi boita mena na kai kagitai mwa kakawa-yawasosi. ");
INSERT INTO tte_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kabo ikeleisinan isae bulibuli mena imiyamiya Yaubada ulaulana mena yo Yaluyaluwa Tabuna ikalai Tamana koina besiele ana waloyameli. Yo muli mena isuwai kolimai. Ee bwaimwa wagitagitai saugana kaedeedede kaina uloina uloina kolili na kwabenalan. ");
INSERT INTO tte_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Deibida nige meyona isasae bulibuli mena na iyamo iboma iwaloba, ‘Yaubada iwalolau yagu Guyau koina iba, Kumiyasio ulaulagu mena, ");
INSERT INTO tte_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kanasiga kam tokalomagigiliwo yapei-yataluli kaem yaulina mena.’” ");
INSERT INTO tte_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Yo Pita iwaloyoi iba, “Tomo Isileli meuloimiu, bwaite kaiwena yawalo kolimiu, wakatai namwanamwai Yaubada Yeisu ipeiseyan iya Guyau yo Mesaiya, bwaite Yeisune iya mwa komiu kwayakelose.” ");
INSERT INTO tte_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Saugana bodane bwaite walone sibenalan kateliyao siwakaka kabo siwalo Pita yo apositolo meuloili kolili siba, “Kamakavao, na kani tawae kapaisowai?” ");
INSERT INTO tte_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Yo Pita kainali iyamaisa iwaloba, “Kaigeda kaigeda ami pwanoli kolili kwanuwabui na kayababitaisomiu Yeisu Keliso esana mena kabo ami pwanoli Yaubada inuwatu-pwaikili yo Yaluyaluwa Tabuna wakalai iya Yaubada ana mulolo. ");
INSERT INTO tte_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kaiwena Yaubada ana waloyameli kaiwemiu, tubumiyao kaiweli, yo tomo meuloili kelamamalawe mena kaiweli, meuloili tem ala Yeoba Yaubada igitesipwaili iyoganli silaoma koina.” ");
INSERT INTO tte_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita ana walo meuloina koina iyadidigali yo iwalo kaiwe kolili iba, “Kwanuwabui, kisi yaso yauyauleli ali naene maisana kwalobai.” ");
INSERT INTO tte_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Kabo tomo sibaibaiwa Pita ana walo koina simeli kabo sibabitaiso. Na kaliyatenane koina tomo kali baibaiwa tili tausan (3,000) siyamala Yeisu kana tomeliwo waluwaluli. ");
INSERT INTO tte_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Meuloili sitalamwagili sauga meuloina apositolo ali yakayakatai sibenalan. Siyaboda kaigeda yo sakalameni sikele-toyawai Yeisu ana boita kana nuwatu kalatan kaiwena yo me ali nuwalobi sikawakawanoi Yaubada koina. ");
INSERT INTO tte_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kabo tomo kaigeda kaigeda Yeisu esana siyakasisiyan yawasosi kaiwena apositolo kilakilala yo ginauli kaba nuwa pwanopwano sibaibaiwa siginaulili mwa tomo meuloili nuwali iyai. ");
INSERT INTO tte_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Sauga meuloina tomeliwo siyaboda kaigeda yo ali gogo kaigeda yo sipaisowa toyawa. ");
INSERT INTO tte_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ali gogo wasawasa sigimwala-yagili yo tabe maisana mane sikalai yo siwolena yaiya tem polowe koina. ");
INSERT INTO tte_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kabo kaliyate kaigeda kaigeda kolili Yeisu kana tomeliwone simiyagogo Nume Tabu koina, na ali nume mena kawa-elieliyam kanna koina sikekan toyawa me ali yaliyaya yo tabe me ali nuwalobi. ");
INSERT INTO tte_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Yo Yaubada sitobatobalan yo tabe tomo meuloili ali paisowa sikawa-namwanamwayan. Kaliyate kaigeda kaigeda tomo tupwaliyao sinuwabui yo simeli Yeisu koina yo Yaubada ileboili mwa Yeisu kana tomeliwo ali boda ilalalalaki. ");
INSERT INTO tte_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kaliyate yabo tili koloki lolau mena kawakawanoi kana sauga koina Pita te Yoni silalau Nume Tabu koina sabi kawanoi. ");
INSERT INTO tte_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kaba lusaene bwaite esana Kana Koleya Namwanamwasosina, tomo yabo kaena belubeluna sinana ikabiyan naenaena imiyamiya. Kaliyate kaigeda kaigeda sikalai silawan Nume Tabu gamwanane koina na ikawakawanoi mane kaiwena tomo kolili tem silulusae Nume Tabune koina. ");
INSERT INTO tte_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Saugana Pita te Yoni igitaili silulusae Nume Tabune koina, kabo ikawanoi kolili tem ginauli yabo siwolena koina. ");
INSERT INTO tte_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Kabo Pita te Yoni simankulakulai yo Pita iwaloba, “Manim ilaoma kolimai.” ");
INSERT INTO tte_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Mwa imankulakulaili yo inuwanuwatu yakato kani ginauli yabo siwolena koina. ");
INSERT INTO tte_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kabo muli mena Pita iwalo, “Siliba yo gole nigele koliyau, na tawae bwaite koliyau kani yaeyawa. Yeisu Keliso Game Nasaleta esana mena yawalo koliwo, kutolo yo kulokeikeile.” ");
INSERT INTO tte_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kabo Pita tomone ikabilau nima ulaulana mena yo itabeyatolo. Sauganane koina kaena meuloina tubweliyao sikaikaiwe. ");
INSERT INTO tte_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Isagena-tolo yo ilokeikeile mekanakavao Pita te Yoni silusae Nume Tabu kalona mena ilokapukapusele yo Yaubada itobatobalan. ");
INSERT INTO tte_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tomo meuloili sigitai ilolokeikeile yo ilolokapukapusele yo Yaubada itobatobalan, ");
INSERT INTO tte_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","kabo sikatai iya bwaine tomowa imiyasio ikawakawanoi kaba lusae esana Kana Koleya Namwanamwasosina koina mwa koina kateli sipitali yo nuwali ipwanopwano ana namwanamwa kaiwena. ");
INSERT INTO tte_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tomone Pita te Yoni ikabikalatagili siya siyaele kaba lokeikeile yabo Nume Tabu kalona mena esana siba Solomon Ana Dedei. Sauganane koina tomo sigitai kabo nuwali ipwanopwano ana namwanamwa kaiwena mwa sisagena silau kolili. ");
INSERT INTO tte_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kabo Pita igitaili yo iwalo kolili iba, “Tomo Isileli, tawae kaiwena katemiu sipitali? Tabu kwanuwanuwatu yakato kai kaboma ama kaiwe mena o namwanamwa mena tomo bwaite kakabi-namwanamwai yo ilokeikeile. ");
INSERT INTO tte_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Tubulao Abelamo, Aisake yo Yakobo ali Yaubada ana topaisowa Yeisu ipeiseyan kaba miya wasawasana ikalai. Na komiu tauna kona Yeisu kwatalamwan toloinao kolili sabi unuyamatena. Pailato nuwanuwana ilivasi na iyamo komiu kwasikote. ");
INSERT INTO tte_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yeisu iya tomo namwanamwana yo iya tomo yakayakasisina na iyamo komiu kwasikotanan. Kabo wakawanoi Pailato koina tem tounuyamate yabo ilivasi kolimiu. ");
INSERT INTO tte_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mwa koina Yeisu bwaimwa yawasi yaina kwayakelose yo iboita. Muli mena iya Yaubada ikele-yatoloyoi boita mena. Yo kai kagitaiyako mwa tabe kayawayawasa. ");
INSERT INTO tte_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yeisu esana kameliyan yo tabe esana ana kaiwe koina tomo bwaite namwanamwa yo kaiwe ilobai. Bwaite paisowane wagitai na wakatai tomone bwaite koina meli kana paisowa Yeisu esana mena. Walo yawasosi, Yeisu kameliyan mwa tomone bwaite ikabi-namwanamwai. ");
INSERT INTO tte_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Kaukavao, walo yawasosi, tawae komiu yo ami tautaubalao mekamikavao waginauli Yeisu koina kana dudulai nige wakakatai. ");
INSERT INTO tte_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Na beyabeyana Yaubada iwalo-masala palopitao gamwali mena yakato naga ana Mesaiya kamkamna ilobai kabo kabona ana walo-masalawa iyawatagiliko nimamiu mena. ");
INSERT INTO tte_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Bwaite kaiwena yawalo kolimiu, kwanuwabui mumugamiu naenaeli kolili yo kwalau Yaubada koina na ami naene ideuli-gabaegili. ");
INSERT INTO tte_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tem waginauli besiele kani Yaubada mekamikava yo yaluyaluwamiyao me ali yaliyaya yo kabo Mesaiya iyawasa kolimiu iya igitesipwai kaiwemiu, bwaite Yeisu. ");
INSERT INTO tte_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Iya imiyamiya bulibuli mena kanasiga Yaubada ginauli meuloina iyawaluwaluili besiele ana waloyameli sauga beyabeyana ana palopitao yakayakasisili gamwali mena siwalo-masalan. ");
INSERT INTO tte_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Walo yawasosi Yaubada ana Mesaiya iyawasayamako. Besiele baguna Mosese iba, ‘Yeoba ami Yaubada naga palopita yabo iyawasa kolimiu besiele yau iyawasayau. Palopitane kani iyawatagilimaya ami boda luwana mena. Tawae tem kani meuloili iwalowegili kolimiu, kwabenalagili. ");
INSERT INTO tte_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Analiyao tem palopitane kainana nige sibebenalan Yaubada ikelegabaegili yawasosi ana bodao kolili.’ ");
INSERT INTO tte_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Yo tabe palopitao sibaibaiwa, iyatubu Samuela koina yo mulimuliyali, siya Yaubada ana walo sipalopisai, siwalo-masala tawae iyawatagiliko sauga kabona koina. ");
INSERT INTO tte_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yaubada ana waloyameliwa palopita siwalo-masalagiliko komiu kaiwemiu. Tabe ana walo-mulolo yo namwanamwa kani kwalobai besiele Yaubada iwaloyameli tubumiyao kolili. Kaba gite yabo bwaite, Yaubada iwalo Abelamo koina iba, ‘Tubum ana paisowa kaiwena naga yanuwa yaulina tomoliyao yawalo-muloloili yo namwanamwa silobai.’ ");
INSERT INTO tte_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Walo yawasosi, Yaubada iwalo-muloloimiu kaiwena ana topaisowa namwanamwana igitesipwai bagunayan yo iyawasa kolimiu na tem ikabi-yanuwabuimiu yakato mumugamiu naenaeli kwasikotanagili yo lebo kwalobai.” ");
INSERT INTO tte_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Saugana Pita te Yoni siyaele tomo kolili siedeedede topwaoliyao mekalikavao Nume Tabu kana pilisiman ali tobaguna yo Sadusiyao silaoma kolili. ");
INSERT INTO tte_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Me ali munamunai kaiwena apositolo tomo siyakayakataili siwaloba, “Yeisu itoloyoiko yo tabe takatai toboita naga kani sitoloyoi.” ");
INSERT INTO tte_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kabo sikabikalatagili yo silawagili sipeili deli mena kaiwena iboboniyai na sisanasana bwaliga siyatala. ");
INSERT INTO tte_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Na tomo sibaibaiwa siya Pita ana guguye sibenalan mwa sinuwabui. Sauganane koina tomeli ali boda ilalalalaki yo kali baibaiwa besiele paibi tausan (5,000). ");
INSERT INTO tte_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kaliyate mena kabo Yudiya ali tobaguna yo tautaubalao yo loina kana toyakayakatai, ");
INSERT INTO tte_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","yo tabe topwaoli lalakina Anasa mekalikava ana susu tupwaliyao besiele Kaiyapa, Yoni, Alekesenda yo tabe tupwaliyao silogogoma ali kaba logogo mena Yelusalema koina. ");
INSERT INTO tte_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Siloinayagili Pita te Yoni sitolo manli mena yo sineli siwaloba, “Yaiya ana kaiwe koina yo yaiya esana koina ginauli bwaite waginauli?” ");
INSERT INTO tte_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pita Yaluyaluwa Tabuna iloyakalapowon kabo iwalo kolili iwaloba, “Komiu ama tautaubalao yo tobagunao, ");
INSERT INTO tte_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kaliyate kabona kwanelima kaiwena tomo kaena naenaena kasagui na kwawalo gubesi mwa inamwanamwa. ");
INSERT INTO tte_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kabo nuwanuwamai wakatai yo tomo Isileli sikatai Yeisu Keliso Game Nasaleta iya kwayakelose na Yaubada ikele-yatoloyoi boita mena, esana koina tomo bwaite itolo manimiu mena yo inamwanamwa yawasosi. ");
INSERT INTO tte_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yeisu iya kaiwena mwa Buki Tabu iba, ‘Vekune bwaite wakalai nume waginauli kabo komiu tokabikabi vekune wakawa-naenae-yani yo kwasikotanan kabo Yaubada vekune ikalai ipei veku kaikaiwena ana kaba miya koina.’ ");
INSERT INTO tte_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yo iya ibomamo sowasowana ileboila, nige yabo tomo esana besiele yanuwa yaulina mena na koina lebo talobai.” ");
INSERT INTO tte_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Toloinaone kateli sipitali kaiwena silobai Pita te Yoni siedeedede besiele tomo bwagabwaga na iyamo siedeedede me ali katepatu yo me ali kaiwe. Kabo siwaloba, “Ee, walo yawasosi, tomone labuine tauna kona Yeisu yo ana bodao mekalikavao silolokeikeile.” ");
INSERT INTO tte_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Na nige sowasowali Pita kainana siyamaisa kaiwena sigitai tomone siwoisiyako Pita te Yoni mekanakavao sitotolo. ");
INSERT INTO tte_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Topwaoli lalakili siloina apositoloyao siyawatagili yauli mena na siya sibomamo siedeedede. ");
INSERT INTO tte_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Kabo sineli siwaloba, “Gubesi, tawae kani taginauli tomone kolili? Kaiwena tomo meuloili Yelusalema koina sikatai ginauli kaba nuwapwanopwano lalakina siginauli na nige sowasowana tauvalayani. ");
INSERT INTO tte_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Na tayadidigali tabu sauga yabo esa bwaite siguguguyeyan yoi. Genuwala wasane idebalala tomo meuloili kolili.” ");
INSERT INTO tte_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kabo siyoganyoilima kolili siwaloba, “Tabu sauga yaboyoi Yeisu esana waguguguyeyan yo kwayakayakatai-yani tomo kolili.” ");
INSERT INTO tte_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Na Pita te Yoni kainali siyamaisa siwaloba, “Gubesi, tawae ami nuwatu toisabo nuwatu dudulaina Yaubada manna mena, kainamiu kabenalan o nuwana Yaubada kainana kabenalan? ");
INSERT INTO tte_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ginauli bwaite kagitaili yo kabenalagili kaiwena nige sowasowamai kamwanou edeedede.” ");
INSERT INTO tte_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kabo siyadidigali siwaloba, “Tem wasanane kwaluwewasayani yoi kani nae yabo kaginauli kolimiu.” Mwa siloina silivasili kaiwena nige kamwasa yabo sinunuwatu-lobai na siyakamkamnali, sikatai tomo meuloili Pita te Yoni ali paisowa sigitai yo Yaubada sitobatobalan. ");
INSERT INTO tte_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kaiwena tobelune ana bolime poti (40) ilogabaen na sikabi-namwanamwai Yaubada ana kaiwe mena. ");
INSERT INTO tte_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kabo Pita te Yoni silivasili yo silau kalikavao kolili kabo topwaoli lalakili yo tautaubalao kainali siwalo-masalan kolili. ");
INSERT INTO tte_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Wasa bwaite sibenalan kabo meuloili ali nuwatu kaigeda kabo sikawanoi Yaubada koina siwaloba, “Guyau Tomiyasaesosi, bulibuli yo yanuwa yo kalita yo ginauli meuloili kaloli mena kali toyamayale kowa. ");
INSERT INTO tte_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Yaluyaluwa Tabuna ana kaiwe koina beyabeyana am topaisowa tubumai Deibida ipalopisai iwaloba, ‘Tawae kaiwena dedei uloili tomoliyao simunamunai yo sikalekaleya Yaubada koina? Tawae kaiwena siyaboda kaigeda yo siloina yakato sikaleya? Na nige sowasowali siginauli. ");
INSERT INTO tte_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Yanuwa yaulina ali kinyao yo toloinao siyaboda kaigeda yo sikatububu sabi kaleya Yaubada yo ana Mesaiya kolili.’ ");
INSERT INTO tte_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Walo yawasosi, yanuwa bwaite koina Elodi yo Pontio Pailato mekalikavao dedei uloili tomoliyao yo tabe boda Isileli siyaboda kaigeda siloina na sikaleya am topaisowa yakayakasisina am Mesaiya Yeisu koina. ");
INSERT INTO tte_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ee walo yawasosi, siyaboda kaigeda yo siginauli besiele am loina yo am nuwatu bagubagunanawa koina. ");
INSERT INTO tte_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Guyau, tem sowasowana ugitai ali yadidigane kaiwena siwalowalo kolimai kabo kutalamwagimai am topaisowao me ama katepatu na am walo kaluwewasayani. ");
INSERT INTO tte_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nimam kuyagayan na tokasiebwao kuwoisili yo ginauli kaikaiweli yo kilakilala yo ginauli kaba nuwapwanopwano uginaulili am topaisowa yakayakasisina Yeisu esana mena.” ");
INSERT INTO tte_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Saugana ali kawanoi siyemwawasi nume mena simiyamiya yo nume inuku. Kabo meuloili Yaluyaluwa Tabuna iloyapowonli yo tabe me ali katepatu na Yaubada ana walo siyawasayan. ");
INSERT INTO tte_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tomeliwo meuloili ali nuwatu kaigeda yo ali gogo meuloili sitalamwagili kalikavao kolili, nige yabo yaiya iwawalo, “Bwaite yau gogo.” ");
INSERT INTO tte_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apositoloyao Guyau Yeisu ana toloyoi siyawasa me ali kaiwe yo Yaubada tomeli meuloili iwalo-muloloili. ");
INSERT INTO tte_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kaloli mena nige tobubutuma yawasosi yabo ipapagan, meuloili me ali bwatano yo me ali nume. Sauga tupwana ali gogone sigimwala-yagili yo mane sikalai, ");
INSERT INTO tte_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","yo siwolena apositoloyao kolili kabo siyauyan siwolena yaiya tem polowe koina. ");
INSERT INTO tte_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Mwa tomo yabo esana Yosepa, ana boda Libai, ilaoma yanuwa Saipilosi, esana labuina apositoloyao sipei Banabasi. Na esanane Banabasi kana katai bwaite, tokabiyakaiwe. ");
INSERT INTO tte_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Na tomo bwaite ana bwatano igimwala-yani yo tabe manene ikalai yo ilau iwolena apositoloyao kolili. ");
INSERT INTO tte_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Na tomo yabo esana Ananaiyasi yo wainena esana Sapaila ali bwatano sigimwala-yani yo tabe manena sikalai. ");
INSERT INTO tte_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Siya yoli labuine ali nuwatu kaigeda kabo tomone mane tupwana ikabikalatan yo tupwana ilau iwolena apositoloyao kolili. ");
INSERT INTO tte_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Muli mena Pita iwalo Ananaiyasi koina iba, “Tawae kaiwena Seitani katem iloyakalapowon yo am nuwatu iloinayan kabo Yaluyaluwa Tabuna kumwakotayan? Ugitai am bwatano maisana tupwana ukwalaiyako kuboma kaiwem. ");
INSERT INTO tte_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Saugana bwatano imiyamiya kolimiu yo kowa kuloinayan kabo ugimwala-yani manena ukwalai kowa am mane. Gubesi mwa mwakota uginauli yakato mane meuloina bwaite ukwalaiyama? Kai nige kumwamwakota-yagimai. Bwaite Yaubada kumwakotayan.” ");
INSERT INTO tte_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Ananaiyasi walone ibenalan kabo ibeku yo iboita. Kabo kilakaiwo sitolo kwapina sisuma yo sikalai sikele-yawatagilan silawan sipei salai mena. Saugana yanuwa tomoliyao wasane bwaite sibenalan simatausi lalakina. ");
INSERT INTO tte_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tupwana sauga imamalawe kabo Sapaila ilau ilusae nige ikakatai tawae iyawatagili. ");
INSERT INTO tte_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Kabo Pita ineli koina iba, “Kuwalo yawasosi koliyau. Kowa yo wainem Ananaiyasi ami bwatano maisana meuloina bwaite?” Kabo kainana iyamaisa iba, “O, meuloina bwaite ikalaiyama.” ");
INSERT INTO tte_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pita iwalo koina iba, “Tawae kaiwena kowa yo wainem yakato tem sowasowamiu Guyau Yaluyaluwana kwamwakotayan yo kwabatoko ami naene maisana kani nige kwalolobai? Ugitai, kilakaiwo wainem silawanako sipei salai mena siya siyaele sitotolo gamwa mena na sisanasana tabe sikalaiyoiwo.” ");
INSERT INTO tte_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sauganane koina ibeku-talu Pita kaena mena iboita. Muli mena kilakaiwo silaoma silusae sigitai iboitako kabo sikalai siyawatagilani yo silawan sipei wainena salaina salina mena. ");
INSERT INTO tte_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kabo tomeliwo meuloili yo analiyao wasane sibenalan simatausi lalakina. ");
INSERT INTO tte_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apositoloyao kilakilala yo ginauli kaba nuwapwanopwano sibaibaiwa siginaulili tomo manli mena. Sauga meuloina tomeliwo meuloili simiyagogo Nume Tabu dedeina yabo koina esana sipei Solomon ana dedei. ");
INSERT INTO tte_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Yanuwa tomoliyao simatausi kabo genuwali tomeliwo bodaline luwali mena silusae. Na iyamo siyakasisi-yagili yo sikawa-namwanamwa-yagili. ");
INSERT INTO tte_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Na iyamo tomeliwo ali boda ilalalalaki isaesaeyoi mwa kaiwena tupwaliyao tatao yo sinesineo sibaibaiwa simeli Guyau koina. ");
INSERT INTO tte_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tomo apositoloyao ali paisowa sigitai kabo silau tokasiebwa sikalaili yo silawagilima kamwasa papalina mena yo ali kaba keno pwatali mena sipeili sikenokeno na tem Pita ilalau yo makamakayauna lolonna ilobi kolili na sinamwanamwa. ");
INSERT INTO tte_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yo tomo meuloili silaomaya yanuwa kikiuli Yelusalema salina mena kabo tokasiebwao yo siya yaluyaluwa biki silusae kolili sikalailima apositoloyao kolili na meuloili siwoisili. ");
INSERT INTO tte_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Topwaoli lalakili ali tobaguna me kana tosagu siya boda Sadusi meuloili kalomagigili yo lamwa-polowe kateliyao sipowon. ");
INSERT INTO tte_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Mwa apositoloyao sikabi-kalatagili yo sipeili deli mena. ");
INSERT INTO tte_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Na boniyai mena Guyau ana anelose yabo ilau deli kana gamwa isoke kabo apositoloyao iyoganli siyawatagili. ");
INSERT INTO tte_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Kabo iwalo kolili iba, “Kwalau yo kwatolo Nume Tabu kalona mena yo yawasi waluwaluna wasana kwayawasayan tomo kolili.” ");
INSERT INTO tte_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Malala kikiuna kabo siginauli besiele anelose ana walo kolili. Silau silusae Nume Tabu kalona mena yo siyatubu siyakayakatai tomo kolili. Na topwaoli lalakili ali tobaguna mekana tosaguwo sibatoko apositoloyao siyaele deli mena kabo walo siyawasa toloinao kolili na silaoma apositoloyao sabi yatala-yagili. Yo tabe Nume Tabu kana pilisiman siyawasali silau na tem apositoloyao siyoganlima deli mena. ");
INSERT INTO tte_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Na saugana silau siyawatagili deli mena apositoloyao nige silolobaili kabo sipileyoi yo silau toloinao ali wasa siwolegili siwaloba, ");
INSERT INTO tte_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Saugana kalau kayawatagili deli mena kagitai gamwa sikausi yawasosi togitekalatan kagitaili siyaele sitotolo gamwa mena na saugana gamwa kasokeli yo kalusae tomoliyaowa nigele.” ");
INSERT INTO tte_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Walo bwaite sibenalan kabo topwaoli lalakili yo pilisiman ali tobaguna nuwali ipwanopwano sinuwanuwatu siwaloba, “Gubesi bwaite? Tawae yabo iyawatagili?” ");
INSERT INTO tte_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kabo tomo yabo ilau toloinao kolili yo iwaloba, “Wagitai. Tomoliyaowa kwapepeiliwa deli mena siyaele sitotolo Nume Tabu kalona mena siyakayakatai tomo kolili.” ");
INSERT INTO tte_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mwa koina Nume Tabu kana pilisiman ali tobaguna mekanakavao boda tupwaliyao silau apositoloyao siyoganli kikiuna kikiuna silawagilima toloinao kolili. Nige sowana sitabe-sikosikoko-wagili, kaiwena simatausi kisi tomo simunamunai kolili na siunuili veku mena. ");
INSERT INTO tte_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kabo apositoloyao siyatololi Yudiya ali toloinao manli mena kabo topwaoli lalakili ali tobaguna iwalo kolili iba, ");
INSERT INTO tte_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Kawalo-kausimiuko tabu Yeisu esana kwayayakayakatai-yani yoi. Na ama loina nige kwabebenalani, wasa bwaite kwayadebalala Yelusalema meuloina kalona mena. Yo tabe kwayakewaimai ana boita kaiwena.” ");
INSERT INTO tte_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita mekanakavao kainali siyamaisa siba, “Yaubada iya kainana kabenali-bagunayan kabo muli mena tomo. ");
INSERT INTO tte_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tubulao ali Yaubada Yeisu ikele-yatoloyoiyako boita mena bwaite iya wakoyapatu kelose mena yo iboita. ");
INSERT INTO tte_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yaubada Yeisu ipeiseyan imiya nima ulaulana mena mwa iya kala tobaguna yo kala Tolebo. Kabo Yeisu koina sowasowana Isileli sinuwabui ali pwanoli kolili yo Yaubada ali pwanoli inuwatu-pwaikili. ");
INSERT INTO tte_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yo kai ginauli bwaitete kagitai kayawayawasayan yo tabe iya Yaluyaluwa Tabuna besiele ipaipaisowa. Yaluyaluwane bwaite Yaubada iwolewolena tomo kolili siya analiyao ana walo sibenalan.” ");
INSERT INTO tte_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Yudiya ali toloinao walo bwaite sibenalan kabo simunamunai lalakina mwa nuwanuwali apositoloyao siunuyamateli. ");
INSERT INTO tte_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kabo kalikava yabo esana Gameliela iya Palisi ali boda yo loina kana toyakayakatai yabo tabe tomo meuloili siyakasisiyan kabo itolo iwalo apositoloyao sipeili ganamuli mena sauga kikiunamo. ");
INSERT INTO tte_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Muli mena iwalo kolili iba, “Isileli tomoliyao, kwanuwatu namwanamwa muli mena kabo tomone kali loina waginaulili. ");
INSERT INTO tte_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Beyabeyana Teudas iyawatagili yo iwalo yakato iya tobaguna lalakina yabo. Ana boda ikalaili kali baibaiwa powa andeledi (400) muli mena tomo yabo iunui yo iboita mwa kana tomuliyayao sitatagwaligwali kabo ana boda imwawasi yo nige yaboyoi imiyamiya. ");
INSERT INTO tte_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Muli mena kabo Yudasa iya game Galili iyawatagili Sensisi kana sauga mena. Yo boda yabo ibagunayagili na iyamo tomo yabo iunui yo iboita kabo ana tomuliyayao sitatagwaligwali yoi. ");
INSERT INTO tte_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Mwa yawalo kolimiu tabu tawae yabo kwapapaisowai tomone kolili. Kwalivasili kaiwena tem sibomamo ali nuwatu mena ginauliline siginaulili kani nuwatuline simwawasi. ");
INSERT INTO tte_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Na iyamo tem nuwatune ilaomaya Yaubada koina nige sowasowamiu ali paisowa kwawalokausi. Kwabomamo kwanuwatu namwanamwa kisi wakalekaleya Yaubada koina.” ");
INSERT INTO tte_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gameliela ana walo kanakavao sibenalan kabo apositoloyao siwalo silusaema yo sisapili yo siwalo kolili tabu Yeisu esana siwalowalowen yoi kabo silivasili. ");
INSERT INTO tte_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Apositoloyao toloinao silogabaegili me ali yaliyaya lalakina kaiwena Yaubada ana nuwatu besiele kolili sowasowali Yeisu esana kaiwena kamkamna yo mwalimwaline silobai. ");
INSERT INTO tte_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kaliyate kaigeda kaigeda Nume Tabu kalona mena yo tomo ali nume mena wasa namwanamwana siyakayakatai-yani yo siguguguyeyan siwalo, “Yeisu iya Mesaiya”. ");
INSERT INTO tte_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Sauganane koina tomeliwo ali boda ilalalalaki isaesae. Kaloli mena boda labui simiyamiya, boda yabo siedeedede kaina Giliki koina yo boda yabo siedeedede kaina Ibeliu koina. Na siya tokaina Giliki sietaetalapili siba, “Kaliyate kaigeda kaigeda tem kan sisoiyagili kwabukwabuli kolili kai ama kwabukwabuliwo nige sinunuwatu-kalatagili.” ");
INSERT INTO tte_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Mwa koina apositolo yoli tuwelo tomeliwo siyoganli kolili siedeedede siwaloba, “Kai nige sowana kan kana yauya kaginauli na Yaubada ana walo kana yakayakatai kapei-suwalan. ");
INSERT INTO tte_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kaukavao, luwaluwalimiu mena tomo yoli seben wagitesipwaili siya Yaluyaluwa Tabuna sonoga iloyapowonli yo paisowane taolena kolili na sigitekalatan. ");
INSERT INTO tte_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Mwa kai ama sauga meuloina katalamwan kawanoi kaiwena yo besiele tabe Yaubada ana walo kana yakayakatai kaiwena.” ");
INSERT INTO tte_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tomeli meuloili apositoloyao ali nuwatu siyaliyaya kaiwena. Mwa sigitesipwaili Sitibeni iya tomeli yawasosi yabo yo Yaluyaluwa Tabuna iloyapowon, tabe Pilipi, Polokolasi, Nikano, Timoni, Pamenasi yo Nikolasi iya game Antioki yo tauna kona nigwenigwe ikalai mwa Yudiya ali tapwalolo koina ilusae. ");
INSERT INTO tte_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Siya bwaite siyatololi apositolo manli mena kabo apositoloyao nimali sipei kulukululi mena sikawanoi kaiweli yo siwalo-muloloili yakato ali paisowa siyayatubu kaiwena. ");
INSERT INTO tte_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Mwa koina Yaubada ana walo bwaimwa wasana namwanamwana ikinkin ilalalaki ilaulau Yelusalema koina. Tabe Yudiya topwaoli sibaibaiwa wasana namwanamwana sibenalan yo sinuwabui. ");
INSERT INTO tte_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Kabo Sitibeni iya Yaubada ana mulolo yo ana kaiwe iloyakalapowon, kilakilala yo ginauli kaba nuwa pwanopwano iginaulili tomo manli mena. ");
INSERT INTO tte_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Yo tomo Yudiya ali boda yabo sitolo na Sitibeni sikalomagigilan. Bodane esana sipei Tolivalivasi. Siya silaomaya yanuwa Sailini, Alekesendaliya yo tabe dedei Silisiya yo Eisiya mekalikavao. Siya Sitibeni mekalikava sigamwapakiki. ");
INSERT INTO tte_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Yo nige sowasowali Sitibeni siwalo-yamwanou kaiwena ana walo sonoga ilaomaya Yaluyaluwa Tabuna koina. ");
INSERT INTO tte_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kabo wadam mena bodane silau tomo tupwaliyao kolili siba, “Kwatolo yo mwakota waginauli Sitibeni kaiwena yo kwawalolau tomo kolili yakato Sitibeni Mosese yo Yaubada ipeiyataluli.” Yo siginauli besiele. ");
INSERT INTO tte_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Walone bwaite kaiwena tomo siula-munamunai molosili yo tabe besiele siya tautaubalao yo loina kana toyakayakataiyao. Kabo bodao bwaite silau Sitibeni sikabikalatani yo silawani Yudiya ali toloinao meuloili kolili siya silogogomako. ");
INSERT INTO tte_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Yo bodaone tomo tupwali sikalaili yo walo mwakomwakota siwolegili na saugana toloinao siyoga-luseyagili ali logogo mena tomone siba, “Tomo bwaite Sitibeni sauga meuloina ala Nume Tabu yo Mosese ana loina isinalili. ");
INSERT INTO tte_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kabenalan iwalo yakato Yeisu game Nasaleta Nume Tabu bwaite ikele-gwaligwali, na kala kulutubu mumugaline silaomaya Mosese koina yakato ibuili.” ");
INSERT INTO tte_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Toloinao meuloili simiyagogo simiyamiya Sitibeni simanman-kulakulai yo kana koleya sigitai kana gite besiele anelose yabo kana koleya. ");
INSERT INTO tte_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Yo topwaoli lalakina Sitibeni ineliyan iba, “Gubesi ali yakewa kaiwem, walo yawasosi o nigele?” ");
INSERT INTO tte_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitibeni kainana iyamaisa iba, “Kaukavao yo Tamaguwao, yagu walo bwaite kwabenalani. Sauga beyabeyana koina Yaubada Tomiyasaesosi itolo-mayale tubula Abelamo koina saugana iyaele Mesopotemiya kabo muli mena Abelamo ilau imiya yanuwa esana Elana. ");
INSERT INTO tte_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Yaubada iwalolau koina iba, ‘Am yanuwa yo am susu tomoliyao kulogabaegili, yo kulau dedei bwaine naga kabo yayakenayagiwo. ");
INSERT INTO tte_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Mwa Abelamo dedei Salidiya ilogabaen yo ilau imiya Elana. Tamana ana boita mulina mena kabo Yaubada iyawasa ilaoma ala dedei bwaite koina tamiyamiyane. ");
INSERT INTO tte_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Sauganane koina Yaubada nige bwatano yabo iwowolena Abelamo koina, nigele molosi. Na iyamo iwaloyameli koina yakato iya Abelamo yo tubunao naga bwatano bwaite siloinayan ali bwatano. Bwagana Abelamo nige natuna ipapagan na iyamo Yaubada waloyameline ipei-bagunayanako koina. ");
INSERT INTO tte_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yaubada iwalolau koina iba, ‘Tubumwao naga simiya-taumana dedei uloina koina yo yanuwa tanuwagaliyao paisowa polopolowena siwolena kolili sipaisowai bolime powa andeledi (400) kamkamna koina simiyamiya dedeine koina. ");
INSERT INTO tte_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Tomone siya tubumwao siyakamkamnali kani yayatala-yagili yo tubumwao kani siyawatagilima yanuwane koina yo sipwalou koliyau dedei bwaite koina.’ ");
INSERT INTO tte_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kabo Yaubada waloyameli kaikaiwena iginauli Abelamo koina yo iwalo tatao yoli isuli kwapili sitom-gabaegili waloyameline kana kilakilala. Mwa Abelamo natuna Aisake sikabi kabo kaliyate eit (8) imwawasi yona isuna kwapina sitom-gabaen, bwaimwa tomo Yudiya ali kilakilala nigwenigwe kaiwena. Muli mena Aisake natuna Yakobo yo Yakobo natunao siya kita tubulao yoli tuwelo.” ");
INSERT INTO tte_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Yabo luwali mena esana Yosepa kanakavao yoli ilebeni siya silamwa-poloweyan yo sikalomagigilan mwa sigimwala-yani tomo uloili kolili silawan Itipita. Na iyamo Yaubada mekanakava, ");
INSERT INTO tte_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","mwa ileboi kana polowe meuloina koina. Sonoga namwanamwana iwolena koina yo Itipita ali kini esana Pelo igite-lobai yo Yosepa ikawa-namwanamwa-yani, kabo ipei Itipita ali gavana yo besiele kini ana nume lalakina yo nume dedeina iloinayan. ");
INSERT INTO tte_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Guliyam lalakina Itipita meuloina koina, yo besiele Kenani miya polowe iyawatagili mwa tubulao Kenani koina nige kali ipapagan. ");
INSERT INTO tte_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakobo wasa ibenalan yakato kan iyaele Itipita koina yo natunao tatao kita tubulao iyawasali silau Itipita ali lau bagubagunana. ");
INSERT INTO tte_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Saugana sivivilayoi labuina Itipita koina yo Yosepa iboma iyamayale kanakavao kolili iba, ‘Yau kamikava Yosepa’ yo kabo Kin Pelo Yosepa kanakavao ikataili. ");
INSERT INTO tte_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yo Yosepa walo iyawasa tamana Yakobo yo ana susuwo meuloili silaoma Itipita meuloili kali baibaiwa sebenti paibi (75). ");
INSERT INTO tte_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakobo ilau Itipita yo kabo muli mena iya yo natunao meuloili siya tubulao siboita dedeinane koina. ");
INSERT INTO tte_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Yoli silawagili yanuwa Sikemi koina sipeili salai mena, kaiwena tauna kona Abelamo mane tupwana ikalai yo bwatanone igimwalai susu Emoli kolili.” ");
INSERT INTO tte_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Yaubada ana waloyameli Abelamo koina, yakato ali bwatano iwolena tubulao Isileli kolili, kana sauga ikubwamako kikiunamo iyawatagili yo siya simiyamiya Itipita sikabikabi yo sidebalala sibaibaiwa, ");
INSERT INTO tte_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","muli mena kabo kin naenaena yabo Itipita iloinayan. Kinne bwaite Yosepa ana paisowa wasana nige ibebenalan. ");
INSERT INTO tte_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mumugana inaesosi kabo Isileli iyakamkamnali. Sauga yabo loina ipei yakato Isileli tokabi waluwaluli natuliyao sipeili bakubaku mena na siboita. ");
INSERT INTO tte_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Sauganane koina Mosese sikabi iya Yaubada ana nuwatu melumeluna. Waikena yaiyona tamana yo sinana sigitekalatani nume mena. ");
INSERT INTO tte_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Yo sikalai sipei bakubaku mena kabo muli mena Pelo natuna sine ilobai yo ikalai igitekalatan besiele natuna. ");
INSERT INTO tte_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Itipita ali sonoga meuloina Mosese siyakatai yo iyamala tomo kaikaiwena ana edeedede koina yo ana paisowa koina.” ");
INSERT INTO tte_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Saugana Mosese ana bolime poti (40) ana nuwatu yakato ilau ana tali tomoyao Isileli igitaili kabo ilau. ");
INSERT INTO tte_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Na bwaine koina Mosese Itipita tomona yabo igitai Isileli tomona iunu-gwalagwalai yo ilau ana tali Isileli isagui mwa Itipita mena iunuyamate. ");
INSERT INTO tte_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","26","Kaliyate labuina koina Mosese Isileli labui igitaili sikalekaleya yo itonan iyalotomli iba, ‘Kaukavao, komiu boda kaigeda tawae kaiwena mekamkava wakalekaleya?’ Mosese ibatoko yakato ana tali Isileli sikatai iya Yaubada ana nuwatu melumeluna yo isagusaguili na iyamo nige sikakatai. ");
INSERT INTO tte_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Tomone kanakava iunuunuine Mosese itubali-kalai yo iba, ‘Kowa nige kai kama toloina yo kama toyatala besi kowa. ");
INSERT INTO tte_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Yakato kuunuiyau besiele laina Itipita tomona kuunui?’ ");
INSERT INTO tte_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Saugana Mosese walone bwaite ibenalan kabo iyabubu ilau imiya taumana dedei Midiyan mwa ikasole yo natuliyao labui sikabiliwaya.” ");
INSERT INTO tte_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Bolime poti simwawasi Mosese ule mena imiyamiya Koya Sainai salina mena na mayau saliyana kubwakubwana yabo iwedoli na Mosese igitagitai. Kabo anelose yabo itolo-mayale kalapulupululune kalona mena. ");
INSERT INTO tte_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Saugana anelosene igitai katena iwakaka mwa ilau salina mena nuwanuwana igite-namwanamwai. Yo Yaubada kainana ibenalan iba, ");
INSERT INTO tte_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Yau tubumwao Abelamo, Aisake yo Yakobo ali Yaubada.’ Mosese itabubu me ana matausi yo itagelakeile manna ipei-suwalan tabu manna ilalauyoi koina. ");
INSERT INTO tte_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Yaubada iwalolau koina iba, ‘Kaem kana suma ukwele-gabaegili, kaiwena bwatanone koina kutotolone bwatano tabu. ");
INSERT INTO tte_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yagitaiyako yagu tomoyao sikamkamna Itipita koina yo ali valam yabenalanako na sauga bwaite yalobima sabi leboili. Kulaoma yayawasao kulau Itipita.’ ");
INSERT INTO tte_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Na baguna tomo Isileli Mosese sisikotanan siba, ‘Kowa nige kai kama toloina yo kama toyatala besi.’ Na iyamo saugana anelose itolo-mayale mayau kalapulupululunane pwatana mena Yaubada Mosese igitesipwai yo iyawasa iyamala Isileli kali toloina yo kali tolebo. ");
INSERT INTO tte_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Tomo iyoganili siyawatagilima Itipita koina yo kilakilala yo ginauli kaba nuwapwanopwano ipaisowaili Itipita koina yo Kalita Balabalagiyana koina yo besiele ule mena bolime poti kalona mena. ");
INSERT INTO tte_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Bwaite iya Mosesenane iwalolau tomo Isileli kolili iba, ‘Yaubada palopita yabo naga iyawasa kolimiu ilaoma kamikavao luwali mena besiele yau iyawasayau.’ ");
INSERT INTO tte_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yo tabe bwaite iya Mosesenane mekanakavao tubulao simiyagogo ule mena yo iya mekanakava anelose siedeedede koina Koya Sainai pwatana mena. Iya Yaubada ana walo me yawasina ikalai yo iyawasa kita kolila.” ");
INSERT INTO tte_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Na tubulao Mosese kainana nige sibebenalan, sisikotanan na nuwanuwali sivivilayoi Itipita. ");
INSERT INTO tte_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kabo siwalolau Eloni koina siba, ‘Kokotomo tupwaliyao uginaulili kaiwela na kabo sibaguna-yagila. Tomone Mosese iya ikalaila tayawatagilimaya Itipita gubesi? Nige takakatai tawae iyayai.’ ");
INSERT INTO tte_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Mwa sauganane koina kokotomo yabo siginauli kana koleya besiele bulumakau natuna. Yakayakan tupwali sikalailima sipwaoli-yagili koina yo soi siginauli yo kokotomone nimali mena sigiginauline siyakasisiyani. ");
INSERT INTO tte_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kabo Yaubada isikotanagili ikabi-gabaegili mowoi na tem sipwalouya bulibuli utunao kolili besiele palopitao beyabeyana siwalo-masala ali buki kaloli mena siba, ‘Tomo Isileli, nige yau kaiwegu yakayakan kwaunuili yo kwapwapwaoli-yagili ule mena bolime poti (40). ");
INSERT INTO tte_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kwabatoko yagu palai elobelobe numena wakewakewai. Na iyamo katemiu mena palai uloina wakewakewai. Kaba pwalou esana Moloke makamakayauna yo utu Lepani makamakayauna wakalaili, kokotomone siya ami yaubadao waginaulili yo kwapwalopwalou kolili. Mwa koina kani yatalamwagimiu yo yayawasamiu kwalau Babiloni dedei yabo mena.’” ");
INSERT INTO tte_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Tubulao mekalikava palai elobelobe numena silolokeikeile ule mena. Sikabi besiele Yaubada ana walo Mosese koina, kana koleya besiele Yaubada iyakenayan. ");
INSERT INTO tte_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Muli mena tubulao mekalikava Yosuwa palai elobelobe numena sikalai sikewai silawanama saugana Yaubada Kenani tomoliyao itawoili manili mena. Kabo tubulao yanuwa Kenani sikalai ali yanuwa. Yo palai elobelobe numenane imiyamiya bwaite koina kanasiga Deibida ana sauga mena. ");
INSERT INTO tte_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Yaubada iyaliyaya Deibida kaiwena yo Deibida ikawanoi Yaubada koina iba, ‘Tem kutalam Nume Tabu yakabi am kaba miya yakato kalona mena kai Isileli meuloimai, Yakobo ana boda, kapwalou koliwo.’ ");
INSERT INTO tte_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Na iyamo Solomon iya ikabi Yaubada ana nume. ");
INSERT INTO tte_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Na Yaubada Tomiyasaesosi nige imiyamiya nume tomo sikabikabi koina besiele iwalo palopita gamwana mena iba, ");
INSERT INTO tte_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Bulibuli iya yau kaba miya wasawasana, yo yanuwa yaulina iya kaegu kaba peina. Na gubesi, nume kana koleya tawatawaena wakakabine kaiwegu? Nigele. Yo toisabo dedei koina yakaiyawasi? Nigele. ");
INSERT INTO tte_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kaiwena yau ginauline meuloili yaginaulili nimagu mena, wa?’” ");
INSERT INTO tte_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Yo Sitibeni iwalolau yoi Yudiya ali tobagunao kolili iba, “Komiu togamwapanapanawa molosi. Katemiu imiya kelamamalawe Yaubada koina, Yaubada kainana nige kwabebenalan, tenamiyao sikola. Komiu toyauyaule, mumugamiu besiele tubumiyao mumugali. Sauga meuloina Yaluyaluwa Tabuna kwasikotanan. ");
INSERT INTO tte_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tubumiyao palopitao meuloili siyakamkamnali yo tabe ana tosagenawasao siunuyamateli siya beyabeyana siwalo-masala Tonamwanamwasosi ana laoma kaiwena. Walo yawasosi, iya Yaubada ana topaisowa dudududulaina. Yo komiu tauna kona topaisowane wakalomagigilan yo kwaunuyamate. ");
INSERT INTO tte_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Komiu Yaubada ana loina wakalaiyako loinane aneloseyao siwolena tubumiyao kolili na iyamo nige kwabebenalan.” ");
INSERT INTO tte_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Saugana Yudiya ali toloinao walone bwaite sibenalan kabo mwakali siyekalasi kaiwena simunamunai lalakina koina. ");
INSERT INTO tte_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Na Sitibeni Yaluyaluwa Tabuna iloyapowon yo isakaisae bulibuli mena, Yaubada ana wasawasa pigapigabuna igitai yo Yeisu igitai itotolo Yaubada nimana ulaulana mena. ");
INSERT INTO tte_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Yo iba, “Wagitai, bulibuli yagitai isoke yo Tomo Natuna iya yagitai itotolo Yaubada nimana ulaulana mena.” ");
INSERT INTO tte_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Yudiya ali toloinao tenali sikabi-kausi yo siwui kainali lalakina. Yo meuloili sisagena silau Sitibeni koina sikabikalatani. ");
INSERT INTO tte_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Siniuli-yawatagilani yanuwane kana gana dagelana mena yo veku mena siunuunui. Toyakewa mwakomwakota kali kwama silololi na tem Sitibeni siunui veku mena, kali kwama sipei-gogonagili kilakai yabo esana Saulo kaena mena yo igitegite-kalatagili. ");
INSERT INTO tte_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Siyaele veku siulaulan koina yo Sitibeni ikawakawanoi iba, “Guyau Yeisu yaluyaluwagu ukwalai.” ");
INSERT INTO tte_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Yo tutulina italu-sakonayani yo iyoga kainana lalakina iba, “Guyau, lopwano bwaite siginaginauli koliyau tabu kuyayamaisa kolili.” Walone iwalowen yo yawasina imwawasi. ");
INSERT INTO tte_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Yo Sitibeni ali unuyamatena Saulo ikawa-namwanamwa-yani. Kaliyatenane koina tokalomagigili meuloili siyatubu tomeliwo siyakamkamnali Yelusalema koina. Kabo tomeli meuloili siyabubu-gwaligwali silau Yudiya yo Sameliya dedeina meuloina kolili, apositoloyaomo simiyamiya Yelusalema koina. ");
INSERT INTO tte_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Yo tomo tupwali siya Yaubada simeliyani Sitibeni boiboitana sikalai silau sipei salai mena yo sivalam lalakina kaiwena. ");
INSERT INTO tte_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Na iya Saulo nuwanuwana tomeliwo isibayanaeli yo ilau nume kaigeda kaigeda kolili ilusae yo tomeli tatao yo sinesineo ipanili yo itabe-niuniulili me ana kaiwe ilawagili ipeili deli mena. ");
INSERT INTO tte_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yo tomeliwo siya siyabubu-gwaligwali dedei meuloili kolili silau wasana namwanamwana siguguyeyani. ");
INSERT INTO tte_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilipi ilobi Sameliya yanuwana koina yo Mesaiya wasana iguguyeyani tomone kolili. ");
INSERT INTO tte_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Boda meuloili Pilipi ana guguye sibenalan namwanamwai kaiwena ana walo kaigeda kaigeda sibenalani yo ginauli kaba nuwapwanopwano yo kilakilala kaikaiweli ipaisowaili sigitaili. ");
INSERT INTO tte_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kaba gite bwaite besiele. Pilipi yaluyaluwa biki sibaibaiwa itao-yawatagilagili tomo kolili. Saugana yaluyaluwa bikine siyawatagili siwui. Yo besiele tabe tolosigesige yo tobelu sibaibaiwa iwoisili. ");
INSERT INTO tte_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Mwa yanuwane koina tomo yaliyaya lalakina silobai. ");
INSERT INTO tte_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na tokukula yabo esana Saimoni iyaele yanuwane koina yo sauga imamalawe kukula iyapayapaisowa yo ana sonogane kaiwena Sameliya tomoliyao meuloili nuwali iyai. Sauga meuloina iba yakato iya tomo lalakina yabo. ");
INSERT INTO tte_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Na yanuwane koina tomo meuloili siya esali lalakina yo siya nigele, Saimoni siyakasisiyani yo siba, “Saimoni iya tomo lalakina kaiwena yaubada yabo ana kaiwe koina mwa esana tapei Tokaiwesosi.” ");
INSERT INTO tte_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Sauga imamalawe tomo nuwali iyai ana kukula kaiwena yo simuliya koina. ");
INSERT INTO tte_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Na saugana Pilipi Yaubada ana kaba loina wasana namwanamwana yo Yeisu Keliso esana iguguyeyani kolili tatao yo sinesineo simeliyani mwa iyababitaisoli. ");
INSERT INTO tte_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimoni iya tabe imeli yo ibabitaiso yo tem Pilipi toweya ilau Saimoni mekanakava silau. Kaiwena ginauli kaba nuwapwanopwano yo kilakilala kaikaiweli Pilipi ipaisowaili Saimoni igitaili yo nuwana ipwanopwano lalakina. ");
INSERT INTO tte_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Na apositoloyao siyaele Yelusalema wasa sibenalani yakato Sameliya tomoliyao kateli sitalamwan Yaubada ana walo koina mwa Pita te Yoni siyawasali silau kolili. ");
INSERT INTO tte_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Na Yaluyaluwa Tabuna nige naga ilolobima tomeli yabo koina, bwaine koina Guyau Yeisu esanamo koina sibabitaiso. Mwa saugana Pita te Yoni siyawatagilima sikawanoi tomeli kaiweli tem Yaluyaluwa Tabuna kateli iloyapowonli. ");
INSERT INTO tte_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kabo nimali sipei tomeli kulukululi mena yo Yaluyaluwa Tabuna ilobima tomeline kolili yo ilusae kateli mena. ");
INSERT INTO tte_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Na saugana Saimoni tokukula igitai apositoloyao nimali sipei tomeli kulukululi mena yo tomeli siya Yaluyaluwa Tabuna sikalai kabo mane ikalai yakato iwolena Pita te Yoni kolili yo iba, ");
INSERT INTO tte_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Mane bwaite wakalai kabo kaiwe bwaimwana kwaeyama koliyau na tem yau tabe tem nimagu yapei tomo yabo kulukuluna mena na Yaluyaluwa Tabuna ilusae koina.” ");
INSERT INTO tte_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Na Pita kainana iyamaisa iba, “Kulowasi, bwalubwalu uyawana mena kulouyo yo am mane besiele kaiwena kunuwatui yakato Yaubada ana mulolo kuyamaisa mane koina. ");
INSERT INTO tte_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kowa nige esam ipapagan paisowa bwaite koina kaiwena katem ibikisosi Yaubada manna mena. ");
INSERT INTO tte_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kunuwabui, yauyaule mumugana ugwabaeni na ukawanoi Guyau koina tem am nuwatu naenaena inuwatu-pwaiki. ");
INSERT INTO tte_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ee mwa yagitai kalomagigili yo munamunai kana nuwatu katem siloyapowon yo pwanoli mumugana ipan-kalatagiwo.” ");
INSERT INTO tte_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Yo Saimoni iwalolau Pita te Yoni kolili iba, “Tem ukawanoi Guyau koina kaiwegu na ginauline kuwawalowegiline koliyau tabu yabo iyayawatagili koliyau.” ");
INSERT INTO tte_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Kabo ali katai Yeisu kaiwena siyawasa yo Yaubada ana walo siguguyeyan imwawasi kabo sipileyoi Yelusalema, ali pileyoine koina wasana namwanamwana siguguyeyani Sameliya yanuwana meuloina kolili. ");
INSERT INTO tte_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kabo Guyau ana anelose yabo iwalolau Pilipi koina iba, “Sameliya kulogabaen na kulobi Yelusalema kamwasana ilalau Gasa kaiwena koina.” Na kamwasane koina nige tomo simiyamiya iya paepaeli bwagabwagamo. ");
INSERT INTO tte_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Mwa Pilipi ilalau kamwasa mena kabo waga niuniuli igitai. Waga niuniuline pwatana mena tomo Idiopiya imiyasio. Na tomone iya tomo lalakina yabo yo ana paisowa bwaite besiele, Idiopiya ali toloina sine esana Kanidesi ana gogo wasawasa igitegite-kalatagili. Tauna kona tomone ilau itapwalolo Yelusalema koina, mwa bwaite sauga ipipileyoi ana yanuwa kaiwena, imiyasio ana waga niuniuli pwatana mena yo Buki Tabu iyasiyasili, bwaimwa palopita Aiseya ana lelelele. ");
INSERT INTO tte_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Kabo Yaluyaluwa Tabuna iwalolau Pilipi koina iba, “Kulau waga niuniuline salina mena.” ");
INSERT INTO tte_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Kabo Pilipi isagena ilau waga niuniuline koina yo ibenalan tomone Aiseya ana buki iyasiyasili. Mwa ineli iba, “Bukine kuyasiyasiline bwaimwa kana dudulai imayale koliwo o nigele?” ");
INSERT INTO tte_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tomone iba, “Nigele, tem tomo yabo iyamayale koliyau kabo yakatai.” Mwa iwalo Pilipi imwalisae yo mekanakava simiyasio. ");
INSERT INTO tte_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na bukine iyasiyasiline iwalo bwaite besiele. ‘Iya besiele sipi sikalai silawani sabi unuyamatena. Nige walo yabo iwawalowen, besiele sipi natuna saugana tem wiyana sitomtom nige kainana ipapagan. ");
INSERT INTO tte_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Mwalimwaline lalakina ilobai yo ana yatala koina mwakota mena siyakewai. Nige natuna ipapagan mwa nige yabo sowasowana natunao kaiweli iedeedede kaiwena tomone ana sauga imwawasi.’ ");
INSERT INTO tte_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kabo Tomo Idiopiya iwalolau Pilipi koina iba, “Yagu wasa kuyeyama, toisabo tomo palopita Aiseya iwalowalo kaiwena, iboma o tomo uloina iwalowalo kaiwena?” ");
INSERT INTO tte_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kabo Pilipi Yeisu wasana namwanamwana iyawasayani koina, ana walo bagubagunana Aiseya ana lelelele. ");
INSERT INTO tte_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Waga niuniuli isagesagena kamwasa mena kabo waila yabo sigitai mwa Idiopiya mena iba, “Waila yabo bwaite. Nuwanuwagu lalakina tem sauga bwaite kuyababitaisoyau.” ");
INSERT INTO tte_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilipi iwalolau koina iba, “Sowasowana yayababitaisowo tem kumeli katem meuloina koina.” Tomone Pilipi kainana iyamaisa iba, “O, yameli yakato Yeisu Keliso iya Yaubada Natuna.” ");
INSERT INTO tte_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tomo Idiopiyane iwalo ana waga niuniuli siyalotom yo mekanakava Pilipi yoli labui sikaisulu sigayolobi waila mena kabo Pilipi tomone iyababitaiso. ");
INSERT INTO tte_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Saugana sigayosaema waila mena, kabo Yaubada Yaluyaluwana Pilipi ikalaimowoi ilau yo Idiopiya mena nige Pilipi igigitai yoi. Mwa tomo Idiopiya me ana yaliyaya lalakina ilau ana yanuwa kana kamwasa mena. ");
INSERT INTO tte_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Na Pilipi iyawatagili yanuwa Asota koina yo wasana namwanamwana iguguyeyani yanuwa meuloili kolili kanasiga iyawatagili yanuwa Sisaliya yo bwaine koina imiyamiya. ");
INSERT INTO tte_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sauganane koina Saulo iyaele Yelusalema yo Yeisu kana tomeliwo ikalokalomagigi-lagili. Sauga meuloina iwalowalo, “Tem Yeisu kana tomeliwo yalobaili kani yaunuyamateli.” Mwa ilau topwaoli lalakina koina, ");
INSERT INTO tte_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","yo ikawanoi leta tupwali sileleli kaiweli, kaiwena Saulo nuwanuwana iwolegili Damasiko ali tapwalolo kana tobagunao kolili sabi yanuwapeili na sikatai yo sisagui. Letane kaloli mena iba tem Yeisu ana kamwasa kana tomuliya Saulo ilobaili tatao yo sinesineo sowasowana ipanili yo ilawagili Yelusalema. Saulo letane ikalaili kabo ilau. ");
INSERT INTO tte_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Saugana ilalau Damasiko kaiwena yo masa kikiunamo iyawatagili kabo mayale yabo ilobima bulibuli mena yo Saulo imayale-takikilani. ");
INSERT INTO tte_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Mwa ibeku ilobi bwatano mena yo kaina yabo ibenalani iwalowalo koina iba, “Saulo, Saulo. Tawae kaiwena kuyakamkamnayau?” ");
INSERT INTO tte_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Kabo Saulo ineli iba, “Taubala, yaiya kowa?” Mwa ana neli iyamaisa iba, “Yau Yeisu iya mwa kuyayakamkamnawa. ");
INSERT INTO tte_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sauga bwaite kutolo yo kulau yanuwa Damasiko koina kabo tomo yabo kani kam loina iwalowen koliwo.” ");
INSERT INTO tte_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Tomone siya mekalikava Saulo silaulau sitolo-mwanou, kainana balamumunamo sibenalan na nige tomona sigigitai. ");
INSERT INTO tte_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Kabo Saulo bwatano mena itoloma manna iyalalali na iyamo nige ginauli yabo igigitai mwa sikabi-nimai na silawani Damasiko. ");
INSERT INTO tte_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kaliyate yaiyona manna iboniboniyai yo besiele nige kan ikakan yo nige waila inunuma. ");
INSERT INTO tte_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Na Yeisu kana tomeli yabo esana Ananaiyasi imiyamiya Damasiko. Yo yakenayan yabo imayale koina yo yakenayanne koina Guyau iyogani iba, “Ananaiyasi.” Kainana iyamaisa iba, “Guyau, yau elete.” ");
INSERT INTO tte_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mwa Guyau iwalolau koina iba, “Kulau kamwasane koina esana siba ‘Kamwasa Dudulaina’ yo tomo yabo esana Saulo iya game Tasisi kuloyai Yudasa ana nume mena kaiwena iyaele ikawakawanoi. ");
INSERT INTO tte_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Yo tomone kana yakenayan koina esam ibenalan yo igitaiwo iboma nimam kupeili koina yo ukawanoi yakato manna sinamwanamwa yoi.” ");
INSERT INTO tte_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaiyasi iba, “Guyau, tomo sibaibaiwa wasana siwalowen koliyau yakato iya Saulo kam tomeliwo Yelusalema koina iyakamkamnali. ");
INSERT INTO tte_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Yo ilaoma Damasiko koina Yelusalema topwaoli lalakili esali mena yakato tomone meuloili sipwalou esam mena ipanili.” ");
INSERT INTO tte_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Na iyamo Guyau iwalolau koina iba, “Kulau, kaiwena Saulo yagitesipwaiyako iyamala yagu topaisowa iya esagu iyawasayan siya nige Isileli yo tabe kinyao kolili yo tabe besiele siya tomo Isileli kolili. ");
INSERT INTO tte_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Na naga kabo yayakenayan kamkamna lalakina kani ilobai esagu kaiwena.” ");
INSERT INTO tte_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kabo Ananaiyasi ilau Kamwasa Dudulaina koina na Yudasa ana nume mena ilusae yo nimana ipeili Saulo koina iba, “Kaukava Saulo, Guyau iesimilagau iya Yeisu imayale koliwo saugana kulalaoma kamwasa mena. Iya iyawasayau yalaoma manim sabi yalalali na sinamwanamwa yo tabe Yaluyaluwa Tabuna iloya-kalapowonwo.” ");
INSERT INTO tte_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Sauganane koina ginauli yabo besiele iye kunaili sibeku Saulo manna mena kabo manna sinamwanamwa mwa itolo yo Ananaiyasi Saulo iyababitaiso. ");
INSERT INTO tte_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kabo muli mena ikekani yo yona ikaiweyoi. Kaliyate isamo Saulo imiyamiya Damasiko tomeliwo mekanakavao. ");
INSERT INTO tte_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nige ikakaiyawasi, na ilau Yudiya ali nume tapwalolo kolili yo iyatubu iguguye iba, “Yeisu iya Yaubada Natuna.” ");
INSERT INTO tte_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tomo siya sibenabenali Saulo koina nuwali ipwanopwano yo sineli siba, “Tomone bwaite nuwana iya tauna kona Yelusalema koina Yeisu kana tomeliwo iyakamkamnali, nuwana iya bwaite? Yo iya ilaoma dedei bwaite koina nuwanuwana tupwali ipaniliyoi yo ikalaili ilawagili topwaoli lalakili kolili, wa?” ");
INSERT INTO tte_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Na Saulo ana guguye ikaiwesosi. Yudiya tomoliyao siya simiyamiya Damasiko iyakenayagili yawasosi yakato Yeisu iya Mesaiya kabo nuwali ipwanopwano na nige sowasowali kainana siyamaisa. ");
INSERT INTO tte_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kaliyate sibaibaiwa simwawasi kabo Yudiya tomoliyao siya simiyamiya Damasiko simiyagogo na siloina yakato Saulo siunuyamate. ");
INSERT INTO tte_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Mwa kaliyate yo boniyai Saulo sisanasanai yo yanuwane kana gana kana gamwa sigitegite-kausi yakato tem Saulo iyawatagilima na sikabikalatan yo siunuyamate. Na iyamo Saulo ana eliyam yabo wasane ibenalan mwa iwalo-masalan koina. ");
INSERT INTO tte_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mwa koina boniyai yabo Saulo kana tomuliyayao siyogan silawan Damasiko kana gana koina yo siwalo kodo lalakina kalona mena imwalisae kabo gana pwatana mena maina koina siyalawe-likwa-yani ilobi. Kabo iyawatagili gana muli mena na iyabubu. ");
INSERT INTO tte_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo ilau Yelusalema yo nuwanuwana apositoloyao igitaili na meuloili simatausan kaiwena nige simemeliyan yakato inuwabuiko iyamala tomeli. ");
INSERT INTO tte_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kabo Banabasi Saulo ikalai yo ilawan apositoloyao kolili mwa iwalo-yadudulai kolili iba, “Kamwasa mena Guyau imayale Saulo koina yo iedeedede koina kabo muli mena Damasiko kalona mena me ana katepatu Yeisu esana iguguyeyani.” ");
INSERT INTO tte_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Mwa koina Saulo mekanakavao apositoloyao simiyamiya Yelusalema yo iya ali boda yabo, kabo Yelusalema ilotakikilan yo tomeli meuloili igitagitaili. ");
INSERT INTO tte_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Yo me ana katepatu iguguye Guyau esana mena. Tabe iedeedede Yudiya boda yabo siya sikaikaina Giliki kolili yo mekanakavao sigamwapakiki Mesaiya kaiwena. Kabo siya Saulo sikalomagigilan yo kamwasa siloyaloyai yakato siunuyamate. ");
INSERT INTO tte_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Saugana tomeli wasane sibenalani kabo Saulo sikalai silawani Sisaliya yo siyawasa ilau ana yanuwa mena Tasisi. ");
INSERT INTO tte_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mwa tomeli meuloili Yudiya yo Galili yo Sameliya dedeili meuloina kolili sinuwa-daumwali yo simiyamiya. Ali meli siyakaiwe yo me ali yakasisi Guyau koina Yaluyaluwa Tabuna ana sagu kolili yo kali boda ilalalaki. ");
INSERT INTO tte_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita ilau itakikili Yudiya dedeina koina tomeliwo simiyamiya yanuwa kaigeda kaigeda kaloli mena sabi gitaili tabe sauga yabo ilau siya simiyamiya yanuwa Lida koina. ");
INSERT INTO tte_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Yanuwane koina tobelu yabo ilobai esana Aneyasi nige sowana ana kaba keno mena itolo bolime eit (8). ");
INSERT INTO tte_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Kabo Pita iwalolau koina iba, “Aneyasi, Yeisu Keliso iwoisiwo, kutolo yo am kaba keno ukatububu.” Kabo sauganane koina Aneyasi itolo. ");
INSERT INTO tte_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Yo tomo meuloili siya simiyamiya yanuwa Lida yo dedei Saloni tomone sigitai yo sinuwabui simeli Guyau koina. ");
INSERT INTO tte_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na yanuwa Yopa koina sine yabo esana Tabita iya tomeli, esana kaina Giliki koina siba Dokasa, ana sauga meuloina italamwan paisowa namwanamwali iginaginaulili yo tobubutumao isagusaguili. ");
INSERT INTO tte_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Sauganane koina ikasiebwa yo iboita mwa yona sideuli yo sipei nume kana biliutusi kewana mena. ");
INSERT INTO tte_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yopa nige kelamamalawe Lida koina yo saugana tomeli siya simiyamiya Yopa wasa sibenalan Pita iyaele Lida mwa tomo labui siyawasali silau siwalolau Pita koina siba, “Mwayamwayau kulaoma talau ama yanuwa mena.” ");
INSERT INTO tte_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kabo Pita itolo yo mekanakavao silau. Saugana iyawatagilima siyoga-luseyani nume kana biliutusi kewana mena. Isae kabo kwabukwabuliwo meuloili Pita simiya-takikilan sivalavalam yo kwama yo kaleko siyakenayani siya Dokasa ikonali saugana nige naga iboboita. ");
INSERT INTO tte_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Na Pita iwalo tomo meuloili biliutusi kalona mena siyawatagili kabo tutulina italusakonayan yo ikawanoi Yaubada koina. Imwawasi itolo itagelakeile yo iwalolau toboitane koina iba, “Tabita, kutolo.” Yo Dokasa manna silala yo Pita igitai kabo itolo imiyasio. ");
INSERT INTO tte_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita nimana mena ikabilau yo itabeyatolo. Kabo tomeli yo kwabukwabuliwo iyoganili silusaema na iyakenayagili Dokasa inamwanamwako. ");
INSERT INTO tte_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mwa ana namwanamwa wasana isagena Yopa dedeina meuloina koina yo tomo sibaibaiwa simeli Guyau koina. ");
INSERT INTO tte_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Kaliyate sibaibaiwa Pita imiyamiya Yopa koina tomo yabo esana Saimoni ana nume mena, iya ana paisowa yakayakan kwapili koina ginauli tupwali ipaipaisowaili. ");
INSERT INTO tte_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sisaliya koina Loma tomona yabo imiyamiya esana Konilio. Iya Loma ali tokaleya kali tobaguna yabo, ana tokaleyayao kali baibaiwa wan andeledi (100) iloinayagili. Na ana bodane bwaite ikalailimaya tokaleya bodanane lalakina luwali mena yo esana sipei Itali bodana. Siya tokaleya kaikaiweli. ");
INSERT INTO tte_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Mekanakavao ana nume kana tomiya Yaubada siyakasisiyani yo sitapwatapwalolo koina yo tabe tobubutuma isagusaguili lalakina yo ikawakawanoi Yaubada koina. ");
INSERT INTO tte_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kaliyate yabo tili koloki lolau mena yakenayan yabo imayale koina yo Yaubada ana anelose yabo igitemolosan ilaoma koina yo iba, “Konilio”. ");
INSERT INTO tte_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Konilio anelose imankulakulai me ana matausi yo iba, “Guyau, gubesi?” Mwa anelose iba, “Am kawanoi Yaubada ibenalanako yo am sagu tobubutuma kolili kaiwena iyaliyaya. ");
INSERT INTO tte_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Mwa sauga bwaite tomo tupwali kuyawasali silau Yopa na Saimoni iya esana siba Pita siyoganama. ");
INSERT INTO tte_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Imiyamiyaya ana waliesa Saimoni, iya yakayakan kwapili koina ginauli tupwali ipaipaisowaili, ana nume mena iyaele dekawa mena.” ");
INSERT INTO tte_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Anelose ana edeedede iyemwawasi mwa ikwalalele kabo Konilio topaisowa labui yo tabe tosagu yabo iyoganilima. Na tosagune iya tokaleya yabo yo Yaubada iyakasisiyan. ");
INSERT INTO tte_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ginauline meuloina iwalo-masalan kolili kabo iyawasali silau Yopa. ");
INSERT INTO tte_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kaliyate labuinane koina siyaele kamwasa mena silaulau masa kikiunamo siyawatagili yanuwa Yopa koina. Sauganane koina besiele pwasinasina ana dedei mena, Pita isae nume kewana mena sabi kawanoi. ");
INSERT INTO tte_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pita iguliyam mwa nuwanuwana ikekani. Na saugana siyaele kani sikatukatububu nume mena, yakeyakenayan yabo iyawatagili Pita koina. ");
INSERT INTO tte_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Igitai bulibuli itasoke yo ginauli yabo kana koleya besiele kaleko tabatabana sikabikalatani isuna esopali kolili mwa bulibuli mena siyalawe-lobiyenama ilobima yanuwa yaulina mena. ");
INSERT INTO tte_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Yakayakan uloili uloili yo man uloili uloili yo ginauli neneneneli uloili uloili siyaele ginauline kalona mena. ");
INSERT INTO tte_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Yo kaina yabo ibenalani iba, “Pita kutolo, kuunuili na ukwekan.” ");
INSERT INTO tte_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pita iba, “Imiyawa Guyau. Mosese ana loina iwalo-kausi. Nige sauga yabo yakakanili kisi yadumdum.” ");
INSERT INTO tte_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kaina ibenalani labuina iba, “Ginauline Yaubada ikawa-namwanamwa-yagiliko kekan kaiwena, tabu ukakawa-dumdum-yagili.” ");
INSERT INTO tte_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ginauline iyawatagili meyaiyona Pita koina kabo kaleko tabatabanane isaeyoi bulibuli mena. ");
INSERT INTO tte_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita nuwana ipwanopwano yo iyaele inuwanuwatu kana yakenayanne kana dudulai kaiwena kabo sauganane koina tomone siya Konilio iyawasali Pita kaiwena Saimoni ana nume silobai yo sitotolo kaba lusae koina. ");
INSERT INTO tte_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Yo siyoga sineli, “Saimoni iya esana siba Pita iyaele bwaimwa koina?” ");
INSERT INTO tte_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita iyaele nume kewana mena inuwanuwatu kana yakenayanne kaiwena kabo Yaluyaluwa Tabuna iwalolau koina iba, “Pita, tomo yaiyona siloyaloyaiwo. ");
INSERT INTO tte_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Mwa kutolomo kulau ukwaisulu yauli mena. Tabu nuwam ilalabulabui kulaumo mekamkavao kaiwena yau yayawasali.” ");
INSERT INTO tte_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Mwa Pita ilau ikaisulu yauli mena yo iwalolau tomone kolili iba, “Yau elete. Ami nuwatu gubesi mwa kwalaoma kwaloyaloyaiyau?” ");
INSERT INTO tte_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Kainana siyamaisa siba, “Konilio iyawasamai mwa kalaoma iya tokaleya kali tobaguna yabo. Iya tomo dudulaina ipwalou Yaubada koina yo Yudiya meuloili siyakasisiyan. Yaubada ana anelose yabo iwalolau koina nuwanuwana iyoganiwo yo kulau ana nume mena na tawae kuwalowen ibenalan.” ");
INSERT INTO tte_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Mwa Pita iwalo nume mena silusae sikaiyawasi yo bwaine koina sikeno. Yanuwa ilayan kabo Pita yo tomeli tupwaliyao siya Yopa tomoliyao mekanakavao silau. ");
INSERT INTO tte_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Yanuwa ilayanyoi mwa kabo siyawatagili Sisaliya. Konilio totounao yo ana eliyamwao yawasosi iwalo silogogoma ana nume mena na meuloili sisanasana Pita kaiwena. ");
INSERT INTO tte_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita ilaoma nume kana gana gamwana mena kabo Konilio iyawatagilima koina tutulina italu-sakonayani yo ipwalou koina. ");
INSERT INTO tte_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Mwa Pita Konilio itabeyatolo yo iba, “Kutolo, yau tomomo besiele kowa.” ");
INSERT INTO tte_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Yoli labui silolo-edeedede kabo silusae nume kalona mena yo tomo sibaibaiwa Pita ilobaili simiyagogoko. ");
INSERT INTO tte_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Yo iwalolau kolili iba, “Komiu wakatai namwanamwai kai Yudiya ama tapwalolo kana loina isikotanan yakato kani nige kalalaowa mekamakavao komiu boda uloi tomoliyao na takakawa-elieliyam na iyamo Yaubada iyakenayagauko tabu tomo yabo yakakawa-dumdumyan. ");
INSERT INTO tte_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Mwa saugana am kawanoi ilaoma koliyau nige yasisikote yatalam yalaoma. Na tawae yaina ukawanoi-yagau yalaomane?” ");
INSERT INTO tte_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konilio iba, “Kaliyate esopali simwawasiko yau ele yakawakawanoi yagu nume mena sauganane besiele tili koloki lolau mena kabo tomo yabo kana kwama pigapigabuna yagitai itotolo manigu mena. ");
INSERT INTO tte_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Iwaloma koliyau iba, ‘Konilio, am kawanoi Yaubada ibenalanako yo am sagu tobubutumao kolili kaiwena iyaliyaya. ");
INSERT INTO tte_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Na sauga bwaite tomo tupwali kuyawasali silau Yopa yo Saimoni iya esana siba Pita siyoganama. Iya imiyamiya ana waliesa Saimoni koina, iya yakayakan kwapili koina ginauli tupwali ipaipaisowaili, na ana numene iyaele dekawa mena.’ ");
INSERT INTO tte_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kabo sauganane koina yagu topaisowa yayawasali silaowa. Yayaliyaya lalakina kaiwena kutalam yo kulaomako mwa sauga bwaite meuloimai kamiyagogoko Yaubada manna mena yo ginauline meuloina Guyau iwalowen koliwo kuwalo-masalan kolimai kabenalani.” ");
INSERT INTO tte_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kabo Pita iyatubu iedeedede kolili iba, “Walo yawasosi kabo nuwagu idudulai tomala tomo meuloili sitoyatoyawa Yaubada manna mena nige yakato kai Yudiyamo imulolo kolimai. ");
INSERT INTO tte_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Na dedei meuloina tomoliyao Yaubada iyaliyaya kaiweli analiyao tem siyakasisiyan yo mumugali sidudulai. ");
INSERT INTO tte_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Wasane bwaite Yaubada iyawasa boda Isileli kolili ilaoma Yeisu Keliso koina bwaimwa iya nuwa-daumwali wasana namwanamwana yo iya yanuwa yaulina kana Guyau. ");
INSERT INTO tte_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","38","Yo kwabenalanako tawae Yeisu Game Nasaleta iginauli Yudiya kalona meuloina koina. Ana paisowa iyatubu dedei Galili koina Yoni ana sauga guguye babitaiso kaiwena mulina mena. Besiele nuwana wakataiyako Yaubada Yaluyaluwa Tabuna isuwai koina yo kaiwe ikalai kabo ilotakikili paisowa namwanamwali ipaisowaili yo tomo meuloili Seitani iyakamkamnali Yeisu ikabi-namwanamwaili kaiwena Yaubada mekanakava. ");
INSERT INTO tte_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ginauli meuloina iginaulili Yelusalema yo Yudiya dedeili mena kai kagitailiko mwa kayawasayani. Iya siyakelose yo iboita, ");
INSERT INTO tte_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","yo iya kaliyate yaiyonana koina Yaubada ikele-yatoloyoi boita mena na italamwani itolo-mayale tomo sigitai. ");
INSERT INTO tte_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nige itotolo-mayale tomo meuloili kolili bwaimwanamo kai Yaubada igite-sipwaimai yo kaemala kana toyawasa mwa ana toloyoi mulina mena mekamakava kakekan kanuma toyawa. ");
INSERT INTO tte_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Iloinayagimai wasana namwanamwana kaguguyeyan tomo kolili yo ali wasa kaolena yakato iya Yaubada igitesipwaiyako yo kani tomo meuloili iyatalayagili, siya nige naga siboboita yo siya siboitako. ");
INSERT INTO tte_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Palopitao meuloili sikawa-yawasosi yakato analiyao siya simeli Yeisu koina Yaubada ali pwanoli inuwagabaegili. ");
INSERT INTO tte_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita iyaelemo iedeedede kabo Yaluyaluwa Tabuna ilobi siya wasana namwanamwana sibenabenalan kolili yo kateli iloyapowonli. ");
INSERT INTO tte_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Kabo kaina uloili siwalowalowegili yo Yaubada sitobatobalani. Na tomeli Yudiya tomoliyao siya mekalikava Pita silaomaya Yopa sibenalani mwa nuwali ipwanopwano kaiwena Yaluyaluwa Tabuna, iya Yaubada ana mulolo, isuwaiyako siya nige Yudiya tomoliyao kolili. ");
INSERT INTO tte_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Kabo Pita iba, “Sauga bwaite Konilio yo ana boda Yaluyaluwa Tabuna sikalai besiele tauna kona kita, na nige sowasowana tomo yabo iwalo-nuwaili yakato tabu sibababitaiso waila mena.” ");
INSERT INTO tte_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Mwa Pita iloina siyababitaisoli Yeisu Keliso esana mena. Kabo muli mena Konilio me ana bodao sikawanoi Pita koina tem mekalikava naga simiyamiya kaliyate tupwaliyao yoi. ");
INSERT INTO tte_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apositoloyao yo tomeli meuloili siya simiyamiya Yudiya dedeina mena sibenalan yakato siya nige Yudiya tomoliyao Yaubada ana walo sibenalanako yo sipei kateli mena. ");
INSERT INTO tte_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Saugana Pita iyawatagili Yelusalema koina tomeliwo boda yabo, siya Mosese ana loina simuliya yawasosi, Pita sikawa-naenae-yani siwalolau koina siba, ");
INSERT INTO tte_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Tawae kaiwena kulau kulusae siya nige nigwenigwe mumugana sikakalai tomoliyao ali nume mena na mekamkavao wakekakekani?” ");
INSERT INTO tte_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kabo Pita ginauli meuloina iyawatagili koina iwalo-masala kolili iba, ");
INSERT INTO tte_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Tauna kona yau ele Yopa yakawakawanoi kabo yakenayan yabo iyawatagili koliyau. Ginauli yabo yagitai kana koleya besiele kaleko tabatabana isuna esopali sikabi-kalatan yo siyalawe-yatalu-yamaya bulibuli mena yo ilobima koliyau. ");
INSERT INTO tte_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Manigu ilau kalona mena yo yakayakan, yo tupwali ule tumaliyao, yo ginauli neneneneli yo man evaevali yagitaili. ");
INSERT INTO tte_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kabo kaina yabo yabenalan iwalo koliyau iba, ‘Pita, kutolo, kuunuili na ukwekan.’ ");
INSERT INTO tte_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Na kainana yayamaisa yaba, ‘Imiyawa Guyau. Mosese ana loina iwalo-kausi mwa nige sauga yabo yakakanili kisi yadumdum.’ ");
INSERT INTO tte_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Na melabui kainane yabenalani ilobimaya bulibuli mena iba, ‘Ginauline Yaubada ikawa-namwanamwa-yagiliko kekan kaiwena, tabu ukakawa-dumdum-yagili.’ ");
INSERT INTO tte_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Meyaiyona ginauline iyawatagili koliyau muli mena kabo meuloina isaeyoi bulibuli mena. ");
INSERT INTO tte_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Sauganane koina tomo yaiyona, siyawasali kaiwegu silaomaya Sisaliya, siyawatagili numene koina yamiyamiya. ");
INSERT INTO tte_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Yaluyaluwa Tabuna iwaloma koliyau iba, ‘Tabu nuwam ilalabulabui, kulaumo mekamkavao.’ Kabo Yopa tomoliyao yoli sikis (6) tabe Sisaliya yoli yaiyona mekaukavao kalau Sisaliya yo Konilio ana nume mena kalusae. ");
INSERT INTO tte_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Bwaine koina Konilio ama wasa iyeyama yakato anelose yabo igitai itotolo ana nume mena yo iba, ‘Tomo tupwali kuyawasali silau Yopa yo Saimoni esana siba Pita siyoganiyama. ");
INSERT INTO tte_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Naga wasa yabo iwalowen koliwo wasane koina kowa yo am nume kana tomiyayao lebo kwalobai.’ ");
INSERT INTO tte_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Saugana yayatubu yaedeedede Yaluyaluwa Tabuna ilobi kolili besiele tauna kona ilobima kolimai kaba yatubu koina. ");
INSERT INTO tte_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kabo yanuwatu-kalatan Guyau ana walo iba, ‘Yoni iyababitaisomiu waila mena na Tamagu kani iyababitaisomiu Yaluyaluwa Tabuna koina.’ ");
INSERT INTO tte_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Na imayale koliyau yakato Yaubada imulolo kolili yo Yaluyaluwa Tabuna iwolena kolili besiele tauna kona saugana tameli Guyau Yeisu Keliso koina imulolo kolila yo Yaluyaluwa Tabuna iyeyama kolila. Walo yawasosi, nige sowasowana Yaubada ana nuwatu yakausi.” ");
INSERT INTO tte_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Saugana Pita ana walone sibenalan simwanou nige sikakawa-naenae-yani yoi na Yaubada sitobalan siba, “Yawasosi siya nige Yudiya tomoliyao na Yaubada ipaisowako kateli mena yo ali pwanoli koina sitagelakeile yo yawasi waluwaluna silobai.” ");
INSERT INTO tte_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Na tauna kona Sitibeni siunuyamateyako, kabo muli mena tokalomagigili tomeli siyakamkamnali mwa tomeli Yelusalema silogabaen yo silogwaligwali. Tupwali silobi dedei Ponisiya, tupwali silobi Saipilosi yo tupwali silobi Antioki yo wasana namwanamwana siyawasayani siya Yudiya tomoliyaomo kolili. ");
INSERT INTO tte_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Na tologwaligwali tupwali, siya tomo Saipilosi yo tomo Sailini, Yelusalema silogabaen silobi Antioki yo bwaine koina siedeedede Giliki tomoliyao kolili yo Guyau Yeisu wasana namwanamwana siyawasa kolili. ");
INSERT INTO tte_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Guyau ana kaiwe imiyamiya kolili mwa koina tomo sibaibaiwa sinuwabui yo simeli Guyau koina. ");
INSERT INTO tte_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tomeliwo Yelusalema wasane sibenalani mwa Banabasi siyawasa ilobi Antioki. ");
INSERT INTO tte_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Saugana Banabasi iyawatagilima Antioki koina Yaubada ana mulolo kolili igitai mwa iyaliyaya. Kabo ikabiyakaiweli yakato kateli meuloina sitalamwan yo ali meli ikaiwe Guyau koina. ");
INSERT INTO tte_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Kaiwena iya tomo namwanamwana yo sauga meuloina Yaluyaluwa Tabuna iloyapowon yo ana meli ilalaki mwa koina tomo sibaibaiwa sinuwabui yo simeli Guyau koina. ");
INSERT INTO tte_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kabo Banabasi ilau Tasisi Saulo sabi loyaina. ");
INSERT INTO tte_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Saugana Saulo ilobai yo iyogan mekanakava sivivilayoima Antioki. Saulo yo Banabasi simiyamiya bolime kaigeda yo bwaine koina boda ekalesiya lalakina siyakayakataili. Antioki koina Yeisu kana tomuliya esali waluwaluli sipei Kelisitiyani. ");
INSERT INTO tte_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Sauganane koina palopitao tupwali silaomaya Yelusalema silobi Antioki. ");
INSERT INTO tte_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Kalikava yabo esana Agabusi itolo yo Yaluyaluwa Tabuna ana kaiwe mena tomo ali wasa iwolena ipalopisai iba, “Guliyam lalakina kani iyawatagili yanuwa yaulina mena.” (Na guliyam bwaite naga kani iyawatagili saugana tem Kalodiyasi iya iyamala Loma ali toloina) ");
INSERT INTO tte_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kabo siya tomeli siya simiyamiya Antioki koina ali nuwatu tem sagu mane siyawasa tomeliwo kolili siya simiyamiya dedei Yudiya koina kali sagu kaiwena na kaigeda kaigeda sipei besiele tawae sowasowali. ");
INSERT INTO tte_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Siginauli besiele yo ali mulolone siwolena Banabasi yo Saulo kolili yo silawan Yelusalema ekalesiya kali tobagunao kolili. ");
INSERT INTO tte_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Sauganane koina Kin Elodi iwalo ana tokaleya tomeliwo tupwaliyao silokalatagili sabi yakamkamnali kabo siginauli besiele. ");
INSERT INTO tte_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yo tabe iwalo ana tokaleya yabo koina na Yemesa, iya Yoni kanakava, kaleya kelepana mena iunuyamate kabo tokaleyane iginauli besiele. ");
INSERT INTO tte_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Elodi igitai siya Yudiya siyaliyaya ana paisowane kaiwena kabo iwaloyoi ana tokaleya Pita silokalatan. (Na nuwatunane iyawatagili soi kana wiki kalona mena soine pwalawa nige mekana yisti sieebweli soina.) ");
INSERT INTO tte_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kabo Pita silokalatani yo sipei deli mena. Bwaine dedeine koina Elodi boda esopali kolili Pita ipei nimali mena. Na boda kaigeda kaigeda kolili tokaleya esopali na siya Pita sigite-kalatani kisi iyabubu. Boda yabo sigitekalatan malala, boda yabo pwasinasina, boda yabo lolau yo boda yabo boniyai, sauga uloina uloina kolili. Elodi ana nuwatu yakato tem mwalelikwa soina imwawasi Pita iyatala tomo manli mena. ");
INSERT INTO tte_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Mwa Pita imiyamiya deli mena. Na sauganane koina Yeisu kana tomeliwo sikawanoi samasamalulu Yaubada koina Pita kaiwena. ");
INSERT INTO tte_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Boniyai kaigedamo imiya kabo Elodi Pita iyoga-yawatagilan yo iyatalayan tomo manli mena. Na sen labui sikalaili Pita sipankalatan. Pita ikenokeno tokaleya labui luwaluwalili mena. Tabe tokaleya tupwali deli kana gamwa sigitegite-kalatan. ");
INSERT INTO tte_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sauganane koina Yaubada ana anelose yabo iyawatagili. Kabo mayale yabo iyawatagili deli mena Pita ana biliutusi koina. Anelose nimana ipei Pita leyaleyana mena yo iyanoi iba, “Mwayamwayau kutolo.” Yo sen Pita nimana mena sitalivasi yo sibeku. ");
INSERT INTO tte_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Yo anelose iwalolau koina iba, “Kam kwama kulikwa yo kaem kana suma kupeili.” Mwa Pita iginauli besiele yo anelose iwaloyoi, “Kaleko malamalawena balubaluna ukwalai ukwabobowan yo muligu mena kulaoma.” ");
INSERT INTO tte_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Mwa mulina mena ilau yo siyawatagili na iyamo nige ikakatai nuwana anelose iyoga-yawatagilanama deli mena o nuwana kenonamo. ");
INSERT INTO tte_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Togitekalatan tupwaliyao siloyagiulili yo tabe silaoma togitekalatan tupwaliyao yoi siloyagiulili kabo silau kanasiga siyawatagili deli kana gamwa ana kaba mwawasi koina gamwane kana gulune pwawati mena siginauli. Gulune iboma itasoke kabo siyawatagili yo silalau yanuwane kamwasana yabo koina ee kabo anelose Pita ilogabaeni. ");
INSERT INTO tte_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pita kabo nuwana idudulai yo iba, “Kabo yawasosi yakatai Guyau ana anelose iyawasayama ileboiyau Elodi ana kaiwe mena yo tabu Yudiya ali nuwatu sigiginauli koliyau.” ");
INSERT INTO tte_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nuwana idudulai kabo ilau Meli ana nume mena, iya Yoni Malika sinana. Tomo sibaibaiwa simiyagogo nume mena yo sikawakawanoi. ");
INSERT INTO tte_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita ilaoma yo itolo nume kana gamwa ganamulina mena na ikipisi. Kabo gamasine yabo numene kana topaisowa esana Loda ilau yakato gamwa isoke. ");
INSERT INTO tte_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Na Pita kainana ikilala, yo ana yaliyaya kaiwena gamwa nige isosoke na isagena-vivila ilau kanakavao ali wasa iwolena iba, “Pita iyaele itotolo yauli mena.” ");
INSERT INTO tte_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Siwalolau koina siba, “Nuwana kuyauyaule.” Na iwalo-samasamalulu iba, “Yawasosi, Pita iyaele yauli mena.” Yo kainana siyamaisa siba, “Nuwana ana anelose bwaimwana.” ");
INSERT INTO tte_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pita iyaelemo ikipikipisi kabo silau gamwa sisoke yo sigitai mwa kateli sipitali. ");
INSERT INTO tte_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Yo Pita nimana ikeleisinani kolili yakato simwanou kabo ali wasa iwolena Guyau gubesina na ikele-yawatagilanama deli mena. Imwawasi iba, “Yemesa yo tomeli meuloili ali wasa kwaolegili.” Yo ilogabaegili ilau dedei uloina koina. ");
INSERT INTO tte_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Yanuwa ilayan tokaleyayao sigamwapakiki yo sitalawauwau kaiwena simatausi yo nuwali ipwanopwano molosi siba, “Tawae iyawatagili Pita koina?” ");
INSERT INTO tte_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Elodi iwalo tokaleya kolili Pita siloyai na nige silolobai. Kabo iwalo deli kana gamwa togitekalatan siyoga-luseyagilima, ineliyagili Pita ana yawatagili kaiwena mwa koina iwalo siunuyamateli. Ginauline mulina mena Elodi Yudiya ali dedei ilogabaen ilobi Sisaliya koina imiyamiya. ");
INSERT INTO tte_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Sauga mamalawena Elodi yo tomo Taiya yo Saidoni sigamwagamwa-pakiki. Na bwaite sauga tomo Taiya yo Saidoni nuwanuwali sikawa-elieliyam Elodi mekalikava kisi kan inuwai kolili kaiwena kali sikalakalaiya Elodi ana kaba loina koina. Mwa silau Balasitusi koina, kin Elodi ana topaisowa lalakina yabo na sikawanoi isaguili. Kabo Balasitusi ana sagu mena silaoma Elodi koina yo sikawanoi tem kaliyate yabo igitesipwai na silogogo siedeedede ali gamwapakiki kaiwena yo kaleya silopei na sikawa-elieliyam yoi. ");
INSERT INTO tte_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Mwa kaliyatenane koina Elodi kwama wasawasana iluwui yo imiyasio kaba miya wasawasana koina yo iedeedede tomo kolili. ");
INSERT INTO tte_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Kabo tomo siyoga me ali tobali siba, “Nige tomo kainana besi na yaubada yabo kainana bwaite.” ");
INSERT INTO tte_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Sauganane koina Guyau ana anelose Elodi iunui yo kasiebwa lalakina ilobai kaiwena igagasa ali tobalanna kaiwena yo Elodi genuwana Yaubada itobalan. Kabo muli mena Elodi diyana kalona mena wesoweso sikan yo iboita. ");
INSERT INTO tte_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Na tomeli Guyau ana walo siyalalaki yo siyadebalala dedei meuloina kolili mwa koina tomo sibaibaiwa simeliyan. ");
INSERT INTO tte_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabasi yo Saulo Yelusalema tomeliwo kali sagu siwolena kabo Yoni (esana labuina Malika) siyogani yo mekalikava Yelusalema silogabaeni sivivilayoi silobi Antioki. ");
INSERT INTO tte_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Palopitao yo toyakayakatai tupwali siyaele ekalesiya Antioki koina siya Banabasi, Simioni esana yabo siba kwapi duba, Lusiyasi iya tomo Sailini, Manaeni iya yagiyagigiwasi melumeluna Kin Elodi mekanakava silalaki toyawa yo tomo mwawamwawasina iya Saulo. ");
INSERT INTO tte_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Sauga yabo mekali guliyam sikalakisiye na sitapwatapwalolo Guyau koina. Kabo Yaluyaluwa Tabuna iwalolau kolili iba, “Banabasi yo Saulo yayoganiliko yagu paisowa kaiwena. Kwatalamwagili na silau paisowane kaiwena.” ");
INSERT INTO tte_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Sauga yaboyoi mekali guliyam sikalakisiye yoi yo sikawakawanoi, imwawasi nimali sipei Banabasi yo Saulo kulukululi mena yo siwalo-muloloili paisowane kaiwena kabo siyawasali yo silau. ");
INSERT INTO tte_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Yaluyaluwa Tabuna tomo labuiwa iyawasali kabo silobi Selusiya yo waga mena simwalisae sikuke silau bwanabwana Saipilosi koina. ");
INSERT INTO tte_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Saugana siulisi Salamis koina sikaisulu kabo Yaubada ana walo siguguyeyani Yudiya ali nume tapwalolo kaloli mena na Yoni (esana labuina Malika) mekalikava paisowane isaguili. ");
INSERT INTO tte_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","8","Bwanabwanane meuloina silotakikili kanasiga siyawatagili Pepose taon. Bwaine koina bwanabwana Saipilosi kana gavana esana Segiyasi Paulosi silobai. Iya tosonoga yabo mwa Banabasi yo Saulo iyoganili nuwanuwana Yaubada ana walo siguguyeyani ibenalani. Na iyamo gavana ana eliyam tomo Yudiya yabo esana Elimasi, esana labuina Ba-Yeisu, iwalo-kausili yo ali edeedede ikawa-naenae-yani nuwanuwana gavana yaluyaluwana ikabi-yabelu na tabu imemeli. Na Elimasi iya tokukula yo tomwakomwakota yabo kaiwena sauga meuloina mwakota mena ipalopalopisai. ");
INSERT INTO tte_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Kabo Saulo, esana labuina Paulo, Yaluyaluwa Tabuna iloyapowon yo Elimasi imankulakulai, ");
INSERT INTO tte_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","yo iba, “Kowa Seitani natuna, ginauli meuloili namwanamwali siya kali tokalomagigili kowa. Kuyauyaule yo mwakota kana nuwatu koina ukalapowon. Sauga meuloina kutonatonan tem walo yawasosi Guyau kaiwena ukawa-mwakomwakota-yani, mwa koina tomo kutabe-suwalagili yakato tabu silalau Yaubada ana kamwasa dudulaina koina. ");
INSERT INTO tte_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Sauga bwaite Guyau ana loina kaikaiwena kani kulobai, kabo manim sinae yo nige sowasowam dabwelo mayalena ugitai na sauga kubwakubwana kaiwena.” Sauganane koina manna siboniboniyai mwa ikabikabilalaka nuwanuwana tem tomo yabo nimana mena ikabilau na isagui. ");
INSERT INTO tte_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Saugana gavana igitai tawae iyawatagili tokukulane koina mwa imeli kaiwena Yaubada ana kaiwe igitai. Yo Guyau wasana namwanamwana kaiwena gavanane nuwana iyai. ");
INSERT INTO tte_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo yo kanakavao sikukeya Pepose, sisagena-lau siulisi Peliga bwaine Pamipiliya dedeina mena. Bwaine koina kabo Yoni Malika ilogabaegili na ivivilayoi ilau Yelusalema. ");
INSERT INTO tte_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Paulo yo Banabasi yanuwa Peliga silogabaeni yo silau siyawatagili yanuwa Antioki iya bwaimwa dedei Pisidiya koina. Yudiya ali sabati koina silau silusae yo simiyasio nume tapwalolo kalona mena yo sibenabenali yo sigitagitaili. ");
INSERT INTO tte_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mosese ana loina kana buki yo palopitao ali buki siyasilili imwawasi yo tapwalolo kana tobagunao walo siwolena tomo yabo koina ilau Paulo yo Banabasi ali wasa iwolena iba, “Kamakavao, tem tomone kali kabiyakaiwe yabo kolimiu nuwanuwamai kwawalo-masalan.” ");
INSERT INTO tte_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Mwa Paulo itolo yo nimana ikeleisinan yo iba, “Kaukavao, kagu toki lalakina. Tomo Isileli yo komiu yanuwa uloili tomoliyao iyaele kwatapwaloloko Yaubada koina, kwabenali koliyau. ");
INSERT INTO tte_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Boda Isileli ali Yaubada tubulao igitesipwaili yo ali sauga miya taumana Itipita koina ali boda idebalala yo ilalaki. Kabo Yaubada ana kaiwe mena iyoganli yo Itipita silogabaeni. ");
INSERT INTO tte_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Bolime kana baibaiwa poti (40) silaulau ule mena yo mumugali naenaeli yo ali walo kololo meuloina ikalakisiye-yagili. ");
INSERT INTO tte_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Mwa Yosuwa ana sauga mena Yaubada kaba loina kali baibaiwa seben me tomoliyao iyemwawasili dedei Kenani kalona mena yo bwatanone iwolena ana tomoyao Isileli kolili ali yanuwa besiele ana waloyameli. ");
INSERT INTO tte_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Yakobo ana sauga Itipita koina kanasiga Isileli ali bwatano sikalai Kenani koina kana mamalawe bolime besiele powa andeledi yo pipti (450). Muli mena kabo Yaubada tobagunao tupwaliyao igitesipwaili iwolegili kolili na sibagunayagili kanasiga palopita Samuela ana sauga koina. ");
INSERT INTO tte_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kabo muli mena tomo Isileli siwalo Samuela koina siba, ‘Ama kin yabo kuyeyama kolimai.’ Kabo Yaubada ali kin igitesipwai yo iwolena kolili iya Kisi natuna esana Saulo iya susu Beniyamina na iloinayagili bolime kana baibaiwa poti (40). ");
INSERT INTO tte_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Muli mena Yaubada Saulo ikelegabaen yo Deibida ipeiseyan kabo Saulo ana kaba miya ikalai iyamala kin na iya kaiwena Yaubada iba, ‘Deibida, Yese natuna, yalobai iya tomonane nuwanuwagu kaiwena katena besiele yau kategu yo yagu nuwatu meuloina kani iginaulili.’ ");
INSERT INTO tte_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Deibida tubunao kolili mwa Yaubada boda Isileli kali tolebo iwolena Yeisu, besiele ana waloyameli. ");
INSERT INTO tte_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","25","Masa kikiunamo Yoni Toyababitaiso ana paisowa iyemwawasi kabo Yeisu ana paisowa iyatubu. Tauna kona Yoni Toyababitaiso iguguye tomo Isileli meuloili kolili yo iwalo mumugali naenaeli kolili sinuwabui kabo iyababitaisoli. Sauganane koina iwalolau tomo kolili iba, ‘Nuwana ami nuwatu yakato yau tolebolebowa kwasanasanawa? Yawalo kolimiu, nigele, iya iyaele ilalaoma muligu mena. Na yau nige ilolonamwa-yagau yakato kaena kana suma yalivasi-gabaegili.’” ");
INSERT INTO tte_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Kaukavao, komiu Abelamo tubunao yo komiu yanuwa uloili tomoliyao iyaele kwapwalopwalou Yaubada koina, kita kolila mwa lebo wasana Yaubada iyawasayama. ");
INSERT INTO tte_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","28","Na Yelusalema kana tomiya mekalikavao ali toloinao nige sikakatai yakato Yeisu iya tolebolebo. Bwagana nige ana nae yabo silolobai na iyamo siwalolau Pailato koina iunuyamate mowoi. Saugana Yeisu iunuyamate mwa koina palopitao beyabeyali ali palopisai iyamala yawasosi, walone ali sabati kaigeda kaigeda Yudiya siyasiyasili ali nume tapwalolo mena. ");
INSERT INTO tte_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Saugana naenaena meuloina siginauli koina imwawasi besiele Buki Tabu ana walo iya kaiwena, kabo siyaigabaen kelose mena yo sipei salai mena. ");
INSERT INTO tte_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Na Yaubada ikele-yatoloyoi boita mena. ");
INSERT INTO tte_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Yo kaliyate sibaibaiwa iyawayawatagili ana tomuliyayao kolili siya tauna kona mekanakavao Galili koina sisae Yelusalema. Sauga bwaite koina siya siyamala ana tokawa-yawasosi na wasana namwanamwana siyawayawasa-yani boda Isileli kolili.” ");
INSERT INTO tte_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Wasane namwanamwanane kai kakalaiyama yo kayawasa kolimiu besiele bwaite. Waloyameline tolebolebo kaiwena Yaubada iwaloyameli tubulao kolili, ");
INSERT INTO tte_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ipaisowaiyako kita tubuliyao kaiwela iya Yeisu ikele-yatoloyoi boita mena. Besiele ana walo Same labuina koina, ‘Kowa natugu, kabona yakawa-natu-wagiwo.’ ");
INSERT INTO tte_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yo tabe palopita Aiseya gamwana mena Yaubada iwaloba ‘Walo-mulolo namwanamwali yawaloyamelili Deibida koina kani yaeliwa kolimiu.’ Kabo kaiwela Yaubada Yeisu ikele-yatoloyoi boita mena na yona nige ibobowa. ");
INSERT INTO tte_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Besiele Same 16 kalona mena Deibida iwalo-masala iba, ‘Nige sowana kutalam am topaisowa yakayakasisina yona ipwasa yo ibowa.’ ");
INSERT INTO tte_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Deibida iwalo besiele na nige iedeedede ibomayoi kaiwena. Kaiwena Yaubada ana nuwatu iginauli-wolili mwa iboita yo yona sipei salai mena tubunao mekanakavao mwa koina yona ipwasa yo ibowa. ");
INSERT INTO tte_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Na Yeisu, iya Yaubada ikele-yatoloyoi boita mena, yona nige ipwapwasa yo ibobowa. ");
INSERT INTO tte_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Kaukavao, yawalo yawasosi kolimiu Yeisu koina sowasowana ami pwanoli kali nuwatu-pwaiki kwalobai. ");
INSERT INTO tte_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Na tem yaiya iya imeliyan ana pwanoli kolili ilivasi. Mosese ana loina nige sowasowana ami pwanoline kolili ilivasimiu. ");
INSERT INTO tte_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mwa wagitekalatagimiu yo palopitao ali walo tabu iyayawatagili kolimiu. Siya Yaubada ana walo siwalo-masalagili besiele bwaite. ");
INSERT INTO tte_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Totalatalawasi komiu, yagu paisowa kani wagitai kabo nuwamiu sipwanopwano na iyamo naga kwasawowoli kaiwena ginauli namwanamwali kani yapaipaisowaili ami sauga mena. Na wasanane kani nige kwamemeliyani bwagana tem siyawasa namwanamwai kolimiu.’” ");
INSERT INTO tte_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulo ana edeedede iyemwawasi kabo Paulo yo Banabasi nume tapwalolo silogabaeni mwa bodane sikawanoi kaiwe kolili nuwanuwali tem sivivilayoima sabati ilalaoma na siedeedede yoi kolili. ");
INSERT INTO tte_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Logogo imwawasi mwa yanuwa uloili tomoliyao siya simeliko Yaubada koina yo tomo Yudiya sibaibaiwa siyamulikusuli Paulo yo Banabasi. Mwa Paulo yo Banabasi siedeedede kolili yo sikabiyakaiweli yakato Yaubada iya tomulolo sauga meuloina simeliyani, tabu ali meli ibebelu. ");
INSERT INTO tte_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabati muli mena koina yanuwane tomoliyao sibaibaiwasosi silogogo na tem Yaubada ana walo sibenabenalan. ");
INSERT INTO tte_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Saugana Yudiya tomoliyao boda lalakina sigitaili kabo lamwa-polowe kateliyao sipowon mwa Paulo sikalomagigilan siwalo-yanayanae molosi yo ana walo sikawa-mwakomwakota-yani. ");
INSERT INTO tte_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Mwa Paulo yo Banabasi me ali katepatu kainali siyamaisali siba, “Idudulai tem Yaubada ana walo kayawasa bagunayani kolimiu na iyamo komiu Yaubada ana walo kwasikotanani. Imiyawa. Kwaboma kwayatala-yagimiu yakato tabu yawasimiu miyamiya yaina wakakalai. Mwa kani kalogabaegimiu yo kalau siya nige Yudiya tomoliyao kolili. ");
INSERT INTO tte_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kaiwena Guyau loina iyeyama kolimai iwalo besiele bwaite. ‘Yapeimiu komiu besiele mayale siya nige Yudiya tomoliyao kaiweli yo wasa namwanamwana kani kwayawasayan na tem tomo silaoma dedei meuloina kolili lebo silobai.’” ");
INSERT INTO tte_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Saugana boda siya nige Yudiya tomoliyao wasa bwaite sibenalan siyaliyaya yo Guyau ana walo sikawa-namwanamwa-yani mwa siya Yaubada igitesipwaili yawasi miyamiya yaina kaiwena meuloili simeliyani. ");
INSERT INTO tte_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Yaubada ana walo bwaimwa wasana namwanamwana idebalala yanuwanane dedeina meuloina koina. ");
INSERT INTO tte_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Na Yudiya tomoliyao siya Paulo yo Banabasi sikalomagigi-lagili silau yanuwane kana tobagunao kolili mekalikavao sinesineo siya esali lalakili sipwalou Yaubada koina na siulamunamunaili. Kabo boda bwaite sitolo yo Paulo yo Banabasi sikalomagigi-lagili yo sitawoili dedeine koina. ");
INSERT INTO tte_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Mwa Paulo yo Banabasi kilakilala naenaena yabo siginauli bwaite kaeli dekadekawana sikotatai-yani kaiwena tomone wasana namwanamwana sisikotanani. Kabo Paulo yo Banabasi silogabaegili silau Ikoniyami. ");
INSERT INTO tte_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Na tomeli siya simiyamiya Antioki dedei Pisidiya yaliyaya kateliyao sipowon yo tabe Yaluyaluwa Tabuna iloyapowonli. ");
INSERT INTO tte_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Paulo yo Banabasi silau Ikoniyami yo silusae Yudiya ali nume tapwalolo koina. Yo besiele mumugali, siguguye me ali kaiwe mwa tomo sibaibaiwasosi simeli, tupwali Yudiya tomoliyao yo tupwali siya nige tomo Yudiya tabe. ");
INSERT INTO tte_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Na tomo Yudiya siya Paulo ana walo nige simemeliyan silau siya nige Yudiya tomoliyao kolili yo siyetalapili tomeliwo kaiweli kabo siya nige Yudiya simunamunai mwa koina Paulo yo Banabasi yo tomeliwo sikalomagigi-lagili. ");
INSERT INTO tte_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Sauga imamalawe Paulo yo Banabasi simiyamiya yanuwane koina me ali katepatu siguguguguye Guyau kaiwena na Guyau kaiwe iwolena Paulo yo Banabasi kolili. Ginauli kaba nuwapwanopwano sibaibaiwa sipaisowaili mwa koina tomo meuloili siwaloba, “Yaubada ana mulolo wasana Paulo yo Banabasi siwalowalowen bwaimwana walo yawasosi.” ");
INSERT INTO tte_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Na tomone yanuwa mena kali boda siyakasa, tupwali silau Yudiya tomoliyao kolili na tupwali silau apositolo siya Paulo yo Banabasi kolili. ");
INSERT INTO tte_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kabo Yudiya yo siya nige Yudiya tomoliyao mekalikavao ali tobagunao siloina toyawa yakato apositolo labuine siyakamkamnali yo tabe siunuili veku mena. ");
INSERT INTO tte_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Na apositolo labuine wasane sibenalani kabo Pisidiya dedeina silogabaen yo siyabubu silau Laikoniya dedeina mena yanuwa Lisitila yo Dabi yo yanuwa siya simiyamiya salili mena. ");
INSERT INTO tte_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Yo wasana namwanamwana siguguyeyani kolili. ");
INSERT INTO tte_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Yanuwa Lisitila koina tomo yabo sinana ikabiyan kaena naenaeli iyaele yo nige sauga yabo ilolokeikeile. ");
INSERT INTO tte_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Tomone imiyasio yo Paulo ana edeedede ibenabenalani. Paulo manna ilau tomone koina yo igitai imeli yo sowasowana inamwanamwa. ");
INSERT INTO tte_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Kabo Paulo iyoga iba, “Kutolo kaem mena.” Sauganane koina tomone isagena-tolo yo ilokeikeile. ");
INSERT INTO tte_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tomo meuloili Paulo ana paisowa sigitai tobelune iwoisi mwa siyoga kaina Laikoniya koina siba, “Yaubadao sikaisulu silobimako kolila, kali koleya besiele tomo.” ");
INSERT INTO tte_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Tomone siba Paulo iya yaubada ‘Emisi’ kaiwena iya toedeedede yo siba Banabasi iya yaubada ‘Susi’. ");
INSERT INTO tte_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Na yaubada esana Susi ana nume tapwalolo imiyamiya yanuwa kana gana dagelana mena. Susi ana topwaoli bulumakau tataoliyao tupwali yo mayau lalali siyelanli ikalaili ilawagilima yanuwa kana gamwa kaba lusae mena kaiwena iya yo yanuwane tomoliyao nuwanuwali sipwaoli apositoloyao kolili. ");
INSERT INTO tte_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Na saugana Paulo yo Banabasi wasane sibenalani mwa kali kwama sitabeigalili kaiwena nige nuwanuwali mumugane bwaine yo sisagena silau silusae boda luwali mena yo siyogayoga siba, ");
INSERT INTO tte_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Tautaubalao, tawae kaiwena mumugane bwaite waginaginauli? Kai tomo besiele komiu, kalaoma wasana namwanamwana kayawasa kolimiu na yaubada mwakomwakotali siya kwasikotanagili yo kwanuwabui yo kwameli Yaubada meyawasina koina iya bulibuli, yanuwa yaulina, dumwakali yo ginauli meuloili kali toyamayale. ");
INSERT INTO tte_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Beyabeyana Yaubada tomo meuloili italamwagili sibomamo ali nuwatu mena siloinayagili. ");
INSERT INTO tte_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Na tomo meuloili sowasowali Yaubada ana paisowa sigitai. Ginauli namwanamwali iyamayaleliko kaba gite bwaimwa galewa iyeyawa ilobimaya bulibuli mena yo kan iyeyawa kwamasuli lalakina na katemiu yaliyaya sikalapowon.” ");
INSERT INTO tte_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Bwagana tomo meuloili walone bwaite sibenalanako, na iyamo nige simemeliyani, nuwanuwalimo sipwaoli apositoloyao kolili. ");
INSERT INTO tte_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kabo muli mena Yudiya tomoliyao tupwali silaomaya Antioki yo Ikoniyami kolili kabo boda nuwali sikoi. Yo siyoganli mekalikavao kabo Paulo veku mena siunui yo siniuli-yawatagilan yanuwane kana gana dagelana mena, sibatoko yakato iboitako. ");
INSERT INTO tte_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Na tomeliwo wasa sibenalan kabo silau Paulo simiya-takikilani, kabo itolo yo ipileyoi yanuwa mena mekanakavao. Sikeno yanuwa ilayani kabo Paulo yo Banabasi silogabaegili silau Dabi. ");
INSERT INTO tte_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulo yo Banabasi wasana namwanamwana siguguyeyani Dabi koina yo tomo sibaibaiwa simeli yo simuliya. Imwawasi kabo sipileyoi silau Lisitila, Ikoniyami yo Antioki dedei Pisidiya koina. ");
INSERT INTO tte_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Yo tomeliwo waluwaluli sikabiyakaiweli yo siwalo-kalatagili ali meli Yeisu kaiwena tabu ibebelu yo siwalolau kolili siba, “Polowe sibaibaiwa kani talobaili muli mena kabo talusae Yaubada ana kaba loina koina.” ");
INSERT INTO tte_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Yanuwa kaigeda kaigeda kolili Paulo yo Banabasi tomeliwo kali tobagunao sigitesipwaili. Guliyam sikalakisiyeyan yo sikawakawanoi kaiweli siba, “Yaubada, tobagunao bwaite siya simeliyagiwoko kapei-suwalagili, kuwalo-muloloili yo ugitekalatagili.” ");
INSERT INTO tte_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Dedei Pisidiya silogabaen silau siyawatagili yanuwa Peliga dedei Pamipiliya koina. ");
INSERT INTO tte_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","26","Yo wasana namwanamwana siguguyeyani Peliga tomoliyao kolili kabo silogabaegili yo siyawatagili silobi Atalaiya, waga yabo koina simwalisae yo sikuke sipileyoi silau Antioki iya dedei Siliya. Na beyabeyana bwaine Antioki koina toekalesiyayao sikawanoi Paulo yo Banabasi kaiweli yo nimali sipeili kulukululi mena yo siwalo-muloloili yo siyawasali Yaubada ana paisowa kaiwena. ");
INSERT INTO tte_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ali takikili yo ali paisowa imwawasi Paulo yo Banabasi siyawatagilima Antioki koina kabo toekalesiyayao siyoga-gogonagili yo ginauli meuloina siwalo-masalan kolili. Tawae Yaubada iginauli kolili siedeedede-yani kolili yo siba, “Yaubada meli kana gamwa isokeyako siya nige Yudiya tomoliyao kaiweli.” ");
INSERT INTO tte_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Kabo Paulo yo Banabasi simiyamiya Antioki sauga imamalawe tomeliwo mekalikavao. ");
INSERT INTO tte_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tomo tupwali silaomaya Yudiya silobi Antioki siyakayakatai tomeliwo kolili siba, “Nige sowasowamiu lebo kwalobai kanasiga tem tatao nigwenigwe mumugana sikalai besiele Mosese ana loina.” ");
INSERT INTO tte_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Saugana ali yakayakatai sibenalan Paulo yo Banabasi simunamunai yo mekalikavao sigamwapakiki lalakina. Kabo tomeliwo Paulo yo Banabasi yo tupwaliyoi sigitesipwaili yakato sisae Yelusalema apositoloyao yo ekalesiya kana tobagunao sigitaili nigwenigwe nuwatuna kaiwena. ");
INSERT INTO tte_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Mwa Antioki ekalesiyao siyawasali sisasae yo dedei Ponisiya yo Sameliya silulikwa. Bwaine koina Paulo yo Banabasi tomeli silobaili yo ali wasa siwolena yakato tomo sibaibaiwa siya nige Yudiya simiyamiya Antioki dedei Pisidiya, Ikoniyami, Lisitila yo Dabi sinuwabui yo simeli Yeisu koina. Kabo Ponisiya yo Sameliya tomeliwone wasane sibenalani yo siyaliyaya lalakina. ");
INSERT INTO tte_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Saugana siyawatagili Yelusalema mwa toekalesiya mekalikavao apositoloyao yo tobagunao Paulo yo Banabasi siyoganli kabo ginauli meuloina tawae Yaubada italamwan Paulo yo Banabasi nimali mena sipaisowai ali wasa siwolena kolili. ");
INSERT INTO tte_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Na tomeli tupwali, siya simiyamiya Palisi ali boda koina, sitolo yo siwalo siba, “Temga tomeli siya nige Yudiya tomoliyao siwaloyameli yakato Mosese ana loina siobigai yo nigwenigwe mumugana sikalai kabo tatalam siyamala toekalesiya.” ");
INSERT INTO tte_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Mwa apositoloyao mekalikavao tobagunao simiyagogo yo siedeedede nuwatune kaiwena. ");
INSERT INTO tte_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Siedeedede tupwana imamalawe mulina mena kabo Pita itolo yo iwaloba, “Kaukavao, wakataiyako tauna kona ala boda luwana mena Yaubada igitesipwaiyau wasana namwanamwana yaguguyeyani bodane siya nige Yudiya tomoliyao kolili yakato sibenalani yo simeli. ");
INSERT INTO tte_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Yaubada iya tomo meuloili kateli ikataili, Yaluyaluwa Tabuna iwolena kolili besiele iyeyamako kolila, na koina takatai Yaubada iyaliyaya kaiweli yo ikatailiko. ");
INSERT INTO tte_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nige kaba yakasa yabo igiginauli siya yo kita ala boda koina kaiwena kateli ikabiyakapwali ali meli mena. ");
INSERT INTO tte_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Tawae kaiwena tem polowe meuloina tagwaui pwatali mena na Mosese ana loina simuliya? Tem taginauli besiele kani Yaubada taulamunamunai. Wagitai, polowene tubulao tauna kona nige sowasowali sikalai yo bwaite sauga kita besiele. ");
INSERT INTO tte_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nige sowana. Kaiwena ala meli besiele bwaite, Guyau Yeisu Keliso ana mulolo mena siya yo kita lebo talobai.” ");
INSERT INTO tte_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kabo muli mena Paulo yo Banabasi sitolo yo siedeedede ali takikili kaiwena. Ginauli kaba nuwapwanopwano Yaubada ipaisowaili siya nige Yudiya tomoliyao luwali mena siwalo-masala kolili. Saugana siedeedede tologogo meuloili simiya-mwanou. ");
INSERT INTO tte_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ali edeedede imwawasi kabo Yemesa itolo yo iba, “Kaukavao, kwabenali koliyau. ");
INSERT INTO tte_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimoni Pita iyaele iwalo-masala namwanamwai kolila yakato Yaubada ana nuwatu iyakenayagila saugana tupwali igitesipwaili siya boda nige Yudiya tomoliyao kolili na siya siyamala ana tomoyao. ");
INSERT INTO tte_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Beyabeyana palopita silele Buki Tabu mena ginauline bwaite kaiweli siba, ");
INSERT INTO tte_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Muli mena kani yapileyoima yo Deibida ana nume iguguliwa yayatoloyoi. Ana kaba tatagwaligwali kani yakatububunan na yakabiyoi. ");
INSERT INTO tte_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","Mwa koina tomo yanuwa yaulina mena sinuwabui yo Yaubada simeliyan. Yo besiele siya nige Yudiya tomoliyao yagitesipwaili na siyamala yagu tomoyao. Yaubada ana walo bwaite, yo beyabeyana ginauline iyawatagiliko.’” ");
INSERT INTO tte_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yo Yemesa iwaloyoi, “Mwa yagu nuwatu bwaite besiele. Boda siya nige Yudiya tomoliyao sinuwabuiko yo simeli Yeisu koina, tabu kali polowe tapeipei yakato Mosese ana loina meuloina simuliya. ");
INSERT INTO tte_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ali leta talele yo ali wasa taolena yakato kanne kokotomo kolili sipwaopwaoliyanne tabu koina sikekekan, tabu sigaganawali yo tabe tabu kwasine sinunuma. Yaboyoi na tem ebaebai galogalona sikikimoi na iboita tabu sikakan. ");
INSERT INTO tte_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Walo yawasosi nige sowana Mosese ana loina tatom-gabaen kaiwena bagubagunana kanasiga sauga kabona, Mosese ana loina siguguyeyan yanuwa kaigeda kaigeda koina yo besiele sauga bwaite sabati kaigeda kaigeda siyasiyasili Yudiya ali nume tapwalolo mena.” ");
INSERT INTO tte_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kabo apositoloyao mekalikavao tobagunao yo toekalesiya meuloili siloina yakato tomo tupwali sigitesipwaili ali bodane luwali mena na siyawasali, mekalikavao Paulo yo Banabasi silau yanuwa Antioki. Mwa tomo labui sigitesipwaili Yudasa, iya esana sipei Basabasi yo tabe Sailasa, siya yoli labuine tomeliwo siyakasisi-yagili. ");
INSERT INTO tte_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Letane siwolena kolili yo silokalai. Letane ana walo bwaite besiele. “Kamatoki komiu kamakavao. Kai apositoloyao yo toekalesiya kali tobagunao leta bwaite kalele tomeliwo kolimiu, komiu nige Yudiya tomoliyao kwamiyamiya nuwana yanuwa Antioki dedei Siliya o nuwana dedei Silisiya kolili. ");
INSERT INTO tte_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Wasa kabenalanako yakato tomo tupwali ama boda mena silaowa, yo ali edeedede kaiwena yaluyaluwamiu sikabi-yabeluli yo nuwamiu sitomatoma na kai nige ama walo besiele na silaowa siya siboma ali nuwatu. ");
INSERT INTO tte_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Mwa koina meuloimai katalam na tomo tupwali kagitesipwaili yo kayawasaliwa kolimiu mekalikavao ala eliyamwao namwanamwali Paulo yo Banabasi. ");
INSERT INTO tte_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Walo yawasosi, Paulo yo Banabasi yawasili sitalamwan ala Guyau Yeisu Keliso ana paisowa kaiwena. Siya tauna kona wasana namwanamwana siluwewasa-yani na tomo sitonan tem siunuyamateli. ");
INSERT INTO tte_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Tabe Yudasa yo Sailasa kayawasaliwa kabo kani siwalo-masala kolimiu tawae letane kalele kalona mena. ");
INSERT INTO tte_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Yaluyaluwa Tabuna iloina yo kai kaloina tabu polowe sibabaibaiwa kapepeili kolimiu. Inamwanamwa tem Mosese ana loina lalakili kwamuliya na siya bwaite besiele. ");
INSERT INTO tte_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kanne kokotomo kolili sipwaopwaoliyanne tabu wakakanli, tabu wagaganawali yo tabe tabu kwasine kwanunuma. Yaboyoi na tem ebaebai galogalona sikikimoi na iboita tabu wakakan. Tem bwaite loinane kwayakasisi-yagili inamwanamwa. Kaiyoni.” ");
INSERT INTO tte_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Mwa tomone siyawasali yo silobi Antioki kabo toekalesiyayao siyoga-gogonagili yo ali leta siwolegili. ");
INSERT INTO tte_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Saugana toekalesiyayao letane siyasili siyaliyaya lalakina kabiyakaiwene kaiwena. ");
INSERT INTO tte_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yudasa yo Sailasa, siya palopitao, siedeedede lalakina toekalesiyayao kolili kabo toekalesiyayao kateli sipatu yo ali meli ikaiwe. ");
INSERT INTO tte_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Simiyamiya sauga tupwana imamalawe kabo Antioki toekalesiyayao Yudasa yo Sailasa siwalo-muloloili yo siyawasali sipileyoi Yelusalema na bwaine koina Yudasa yo Sailasa ali paisowa siwalo-masalan Yelusalema ekalesiyao kolili siya tauna kona yoli labuine siyawasali silau Antioki. ");
INSERT INTO tte_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Na Paulo yo Banabasi simiyamiya Antioki yo mekalikavao tomo tupwaliyoi Guyau kainana siyakayakatai yo siguguyeyan. ");
INSERT INTO tte_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kaliyate tupwaliyoi imwawasi Paulo iwalolau Banabasi koina iba, “Tapileyoi talau yanuwane siya tauna kona tatakikiliwa kolili Guyau wasana taguguyeyanwa kolili, na tomeliwo waluwaluli tagitaili gubesi ali miyamiya.” ");
INSERT INTO tte_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","38","Banabasi nuwanuwana Yoni iya esana labuina Malika siyogan mekalikava, na Paulo nige ana nuwatu besiele kaiwena tauna kona Yoni Malika ilogabaegili Peliga koina (dedei Pamipiliya), nige mekalikava sipapaisowa. ");
INSERT INTO tte_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Yoli labuine sigamwapakiki lalakina Malika kaiwena mwa silogwaligwali, yabo ilosuwala yo yabo ilosuwala. Banabasi Malika ikalai mekanakava sikuke silau Saipilosi. ");
INSERT INTO tte_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Na Paulo Sailasa igitesipwai yo iyogan mekanakava. Toekalesiyayao Antioki koina sikawanoi Yaubada koina igitekalatagili yo iwalo-muloloili, kabo silogabaegili. ");
INSERT INTO tte_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Silau dedei Siliya yo Silisiya sitakikili na tomeli bodaliyao sikabiyakaiweli. ");
INSERT INTO tte_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Silau yanuwa Dabi kabo muli mena silau Lisitila. Paulo tomeli yabo ilobai esana Timoti, sinana Yudiya sinena iya Yeisu kana tomeli yabo, na tamana tomo Giliki. ");
INSERT INTO tte_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tomeli siya simiyamiya yanuwa Lisitila yo Ikoniyami Timoti sikawa-namwanamwa-yani. ");
INSERT INTO tte_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo nuwanuwana siyogani mekalikava silotakikili mwa Paulo iwalo Timoti nigwenigwe ikalai besiele Mosese ana loina mesabana Yudiya tomoliyao dedeine koina tabu Timoti sikakalomagigilan kaiwena meuloili sikatai iya tamana tomo Giliki. Mwa Timoti iginauli besiele. ");
INSERT INTO tte_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Saugana silau yanuwa kaigeda kaigeda kolili apositoloyao yo tobagunao siya Yelusalema ali nuwatu siwaloweni tomeliwo kolili yakato loinane esopaline siobigaili. ");
INSERT INTO tte_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kabo tomeliwo ali meli ikaiwe yo ali boda ilalalalaki kaliyate kaigeda kaigeda. ");
INSERT INTO tte_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Dedei Piligiya yo Galetiya silusae sitakikili yo wasana namwanamwana siguguyeyani bwaine koina kaiwena Yaluyaluwa Tabuna Paulo yo ana eliyamwao ikausili tabu dedei Eisiya koina silulusae. ");
INSERT INTO tte_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Saugana silusae dedei Misiya ali nuwatu yakato silauyoi silusae dedei Bidiniya na Yeisu Yaluyaluwana ikausili. ");
INSERT INTO tte_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mwa dedei Misiya siloluwaluwali silau kabo silobi Tilowasi. ");
INSERT INTO tte_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Boniyai mena Paulo kenona mena tomo yabo iya tomo Masidoniya igitai itotolo ikawakawanoi Paulo koina iba, “Kulaoma Masidoniya dedeina mena na kusaguimai.” ");
INSERT INTO tte_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kenonane mulina mena kabo kai kakatububu yo kalauyoi dedei Masidoniya kaiwena ama nuwatu Yaluyaluwa Tabuna nuwamai ikoi mwa koina kakatai Yaubada iyoganimaiko na wasana namwanamwana kaguguyeyani tomone kolili. ");
INSERT INTO tte_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Yo kamwalisae waga mena yo Tilowasi kalogabaen kasagena dudulaimo kalau Samotilesi. Koina kakeno, yanuwa ilayani mwa kabo kakukeyoi kalau Niyapolis. ");
INSERT INTO tte_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kabo kaemai mena kalau Pilipai iya yanuwa lalakina Masidoniya ana dedei mena. Beyabeyana dedeine bwaite lugulugumna kabo Loma silaoma yo sisepa, nume baibaiwali sikabili iyamala Loma ali taon yabo. Kamiyamiya kaliyate tupwana ibaibaiwa. ");
INSERT INTO tte_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Kaliyate sabati mena kalau kayawatagili yanuwane kana gana dagelana mena waila salina mena, kaiwena kakataiyako siya Yudiya ali kaba kawakawanoi wailane salina mena. Kabo kamiyasio yo kaedeedede sinesineo kolili siya silaoma simiyagogo. ");
INSERT INTO tte_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Siya sibenabenali kalikava yabo esana Lidiya, yanuwa Taiyatila sinena, iya kaleko wasawasa pepolo igimwagimwala-yagili, yo iya itapwalolo Yaubada koina. Kabo katena Yaubada isoke yo Paulo ana walo Yeisu kaiwena imeliyan. ");
INSERT INTO tte_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Lidiya yo ana nume kana tomiya kayababitaisoli kabo ikawanoi kolimai iba, “Tem ami nuwatu yameli yawasosi Guyau koina, kwalaoma kwamiyamiya yagu nume mena.” Kabo katalam na kalau ana nume mena. ");
INSERT INTO tte_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Kaliyate yabo kalalau kaba kawakawanoi wailane salina mena na gamasine yabo kalobai, iya topaisowa yabo na ana tautaubalao tauna kona sigimwalai. Yo iya yaluyaluwa biki imiyamiya koina mwa sowasowana iwalo tawae naga iyawatagili sauga muli mena. Ana paisowane koina mane lalakina ikalakalai ana tautaubalao kaiweli. ");
INSERT INTO tte_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Gamasinene iyamuli-kusuli mulimai mena mekamakava Paulo na iyogayoga iba, “Tomone bwaite Yaubada Tomiyasaesosi ana topaisowao, silaoma yo lebo kana kamwasa wasana siyawasayani kolimiu.” ");
INSERT INTO tte_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kaliyate ibaibaiwa iyogayoga-samasamalulu kabo Paulo yona ikwatakwata mwa itagelakeile yo yaluyaluwa biki koina iwalolau iba, “Yeisu Keliso esana mena yawalo koliwo kuyawatagili gamasinene kulogabaeni.” Sauganane koina yaluyaluwa bikine iyawatagili gamasinene koina yo ilowasi. ");
INSERT INTO tte_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Saugana ana tautaubalao gamasinene sigitai na sikatai yakato ali mane ana kaba laoma inaeko, mwa silau Paulo yo Sailasa sikabi-kalatagili yo sitabe-niuniulili silawagili toloinao kolili maketi ana dedei mena sabi yatala-yagili. ");
INSERT INTO tte_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Mwa sipeili toloinao manli mena yo siba, “Tomo bwaite siya Yudiya tomoliyao, silaoma na ala yanuwa tomoliyao siula-munamunaili yo talawauwau lalakina iyawatagili. ");
INSERT INTO tte_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Kaiwena mumuga uloina siyakayakatai-yani, mumugane siya nige ala loina itatalam yakato kita Loma ana kaba loina tomoliyao takalai yo tapaisowai.” ");
INSERT INTO tte_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Yo boda lalakina sitolo yo kalikavao sisaguili Paulo yo Sailasa siyokoi-yagili, mwa toloinao siwalo tomo tupwali Paulo yo Sailasa kali kwama silololi yo balae sikalai dagelali mena sisapili. ");
INSERT INTO tte_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Sisapili lalakina imwawasi sitabe-sikosikoko-wagili siniulili silawagili deli mena sipei-luseyagili, togitekalatani kana loina siwolena iya igitekalatan namwanamwaili tabu siyayabubu. ");
INSERT INTO tte_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Togitekalatani kana loina ibenalani mwa tomone labui ikalaili yo ilau ipeili biliutusi kikiuna koina deli kalona mena yo mayau polopoloweli yabo kewa mena yo yabo yauli mena na luwaluwalili mena kaekaeli siyasolali silusae yo sikokalatagili. ");
INSERT INTO tte_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Boniyai luwaluwalina mena Paulo yo Sailasa sikawakawanoi yo siwaliwali Yaubada koina. Ali tali pilisin siyaele sibenabenali kolili. ");
INSERT INTO tte_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kabo mwanikiniki lalakina inuku yo deli kana wauwau inukui yo imwasali. Sauganane koina gulu meuloili sitasoke yo siya simiyamiya deli kalona mena kali pani sitalivasi. ");
INSERT INTO tte_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Saugana deli kana togitekalatan ikeno-tolo yo igitai gulu meuloili sitasokeko, ibatoko yakato deli kana tomiya meuloili siyabubuko, mwa ana kelepa kaleya iniwisiyama yakato iboma isakonayamate. ");
INSERT INTO tte_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Na Paulo manna ilau igitai mwa iyoga kainana lalakina mena iba, “Eliyam, tabu kubomayoi kusasakona-yamatewo, kai ele meuloimai kamiyamiya.” ");
INSERT INTO tte_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Kabo togitekalatani iyoga ana topaisowao kolili yo odam sikalaiyama koina. Yo ikalai isagena-lusae, me ana tabubu ilau tutulina italu-sakonayani Paulo yo Sailasa kaeli mena. ");
INSERT INTO tte_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Kabo muli mena itolo yo iyoga-yawatagilagili yauli mena yo iwalolau kolili iba, “Tautaubalao, tawae yaginauli na lebo yalobai?” ");
INSERT INTO tte_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Mwa kainana siyamaisa siba, “Guyau Yeisu kumeliyani na lebo kulobai, kowa yo am nume kana tomiyayao.” ");
INSERT INTO tte_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Yo Yaubada ana walo siguguyeyani iya yo ana nume kana tomiya kolili. ");
INSERT INTO tte_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Boniyainane koina, deli kana togitekalatani Paulo yo Sailasa ikalaili kali sapi gailiyao ideulili, mwa sauganane koina iya yo ana nume kana tomiya meuloili sibabitaiso. ");
INSERT INTO tte_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Kabo iyoganli silau ana nume mena kani ipaisowai yo sikekan, yo mekanakavao ana nume kana tomiya meuloili yaliyaya sikalapowon kaiwena simeliko Guyau koina. ");
INSERT INTO tte_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Yanuwa ilayani toloinao siwalo pilisiman kolili silau deli kana togitekalatan koina siba, “Tomone labuine kulivasili.” ");
INSERT INTO tte_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mwa deli kana togitekalatani iwalolau Paulo koina iba, “Toloinao walo siyawasa kaiwemiu kowa yo Sailasa kalivasimiu yo me ami yaliyaya kwalau.” ");
INSERT INTO tte_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Na Paulo iwalolau pilisiman kolili iba, “Kai Loma ana kaba loina tomoliyao. Toloinao nige siyayatala-baguna-yagimai na iyamo siloina sisapi-bwagabwagaimai boda manli mena yo sipei-luse-yagimai deli mena. Kabo nige sowana siwalo yo kaboma kalowasi-wadam. Siboma silaoma yo siyoga-yawatagilagimai.” ");
INSERT INTO tte_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Mwa pilisiman sipileyoi silau toloinao kolili yo Paulo kainana siwaloweni. Saugana toloinao kainanane sibenalani yakato Paulo yo Sailasa siya Loma ana kaba loina tomoliyao mwa simatausi. ");
INSERT INTO tte_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Yo silau deli mena sikawa-soli Paulo yo Sailasa kolili. Kabo siyoga-yawatagilagili deli mena yo sikawanoi kolili yanuwane silogabaeni. ");
INSERT INTO tte_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kabo deli mena siyawatagili silau Lidiya ana nume mena na tomeli sigitaili yo sikabiyakaiweli kabo muli mena yanuwane silogabaen. ");
INSERT INTO tte_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Kabo silau dedei Amipipoli yo dedei Apoloniya siloluwaluwali silau siyawatagili Tesalonaika. Yanuwane koina Yudiya ali nume tapwalolo yabo imiyamiya. ");
INSERT INTO tte_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Yo Paulo ilau ilusae ali nume tapwalolo mena, besiele ana paisowa dedei meuloina kolili. Imiyamiya wiki yaiyona na sabati kaigeda kaigeda Buki Tabu iyasili yo iyakayakatai tomo kolili. ");
INSERT INTO tte_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ana yakayakataine kolili ikabi-yamayale yakato Buki Tabu ana walo tomala Mesaiya kamkamna ilobai yo iboita yo kabo muli mena itoloyoi. Tabe iwaloyoi iba, “Yeisu iya wasana yayawayawasayani kolimiu, iya Mesaiya.” ");
INSERT INTO tte_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Tomo Yudiya tupwali yo Giliki tomoliyao siya Yaubada simeliyani sibaibaiwa yo tabe sinesineo esali lalakili sibaibaiwa mekalikavao meuloili Paulo ana walo sikawa-yawasosi-yani mwa sitalamwagili Paulo yo Sailasa kolili. ");
INSERT INTO tte_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Na tupwaliyao Yudiya tomoliyao Paulo ana walo sisikotanan silamwa-polowe kabo silau kamwasa mena tolobwagabwaga tupwali siya mumugali naenaeli sikalaili yo siyaboda kaigedai kabo yanuwa tomoliyao siula-munamunaili yo talawauwau lalakina iyawatagili. Kabo boda lalakina sisagena silau Yesoni ana nume mena, sibatoko Paulo yo Sailasa siyaele, ali nuwatu yakato silokalatagili yo numene koina sitabe-niuniulili silawagili tomo manli mena. ");
INSERT INTO tte_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Na iyamo nige silolobaili, mwa Yesoni mekanakavao tomeli tupwali silokalatagili yo silawagili yanuwa kana toloinao kolili. Yo siyogayoga siba, “Paulo me ana bodao tomo ali miyamiya sisibayanae dedei meuloili kolili na sauga bwaite silaomako ala dedei mena. ");
INSERT INTO tte_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Iyaele Yesoni iyoga-mwaliseyagili ana nume mena. Siya meuloili Sisa ana loina silikwai kaiwena siwalowalo yakato kin uloina yabo iyawatagiliko iya esana Yeisu.” ");
INSERT INTO tte_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Saugana boda lalakina yo yanuwa kana toloinao walone sibenalani kabo simunamunai molosi yo sitalawauwau lalakina. ");
INSERT INTO tte_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Mwa toloinao siwalo Yesoni me ana bodao kolili siba, “Mane tupwana kwaeyama kolimai na mesabana kalivasimiu kwalau.” Mwa koina Yesoni me ana bodao manene siwolena kolili kabo silivasili yo silogwaligwali. ");
INSERT INTO tte_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Iboniyai kabo tomeli Paulo yo Sailasa siyawasali silau Beliya. Saugana siyawatagili Beliya silau Yudiya ali nume tapwalolo mena. ");
INSERT INTO tte_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Na Yudiya tomoliyao siya simiyamiya Beliya koina mumugali nige besiele siya simiyamiya Tesalonaika koina, siya tomo namwanamwali kaiwena kateli sisoke yo sibenali namwanamwa nuwanuwasosili wasana namwanamwana sibenalani. Mwa kaliyate kaigeda kaigeda Buki Tabu siyasiyasili kaiwena nuwanuwali Paulo ana walo kana yawasosi silobai. ");
INSERT INTO tte_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Yudiya tomoliyao sibaibaiwa simeli tabe Giliki sinesineo siya esali lalakili yo Giliki tatao sibaibaiwa molosi mekalikavao. ");
INSERT INTO tte_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Na siya Yudiya tomoliyao simiyamiya Tesalonaika koina wasane sibenalani yakato Paulo ilau Beliya na Yaubada ana walo iguguyeyani. Kabo sitolo yo silau Beliya tomone siula-munamunaili yo sikasokaso-keikeile. ");
INSERT INTO tte_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Sauganane koina kabo tomeliwo Paulo siyawasa ilobi dekawa mena sabi kuke Akaya dedeina kaiwena na Sailasa yo Timoti simiyamiya Masidoniya dedeina mena. ");
INSERT INTO tte_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Tomeliwo tupwaliyao mekalikava Paulo waga mena simwalisae kabo sikuke Ateni kaiwena kabo muli mena sivivilayoima na Paulo kainana siwaloweni Sailasa yo Timoti kolili yakato tem ali paisowa imwawasi silomwayamwayau silau Ateni na Paulo sisagui. ");
INSERT INTO tte_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Saugana Paulo iyaele Ateni Sailasa yo Timoti isanasanaili, nuwana inae me ana nuwapolowe kaiwena igitai kokotomo sibaibaiwa siginaulili, tomo siyatololi yanuwa kalona mena yo simeliyagili yo sikukula esali mena. ");
INSERT INTO tte_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Mwa ilau Yudiya ali nume tapwalolo mena yo mekanakavao Yudiya yo siya nige Yudiya tomoliyao na iyamo Yaubada siyakasisiyan, siedeedede besiele kaliyate kaigeda kaigeda. Tabe ilau kaba maketi koina tomo ilobaili yo mekanakavao siedeedede. ");
INSERT INTO tte_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Tonuwatu sonosonoga tupwali, siya bodaline esali siba Epikulio yo Sitoiki silau Paulo mekalikava sigamwapakiki. Tupwali siba, “Toyauyaule bwaite, tawae nuwanuwana iwalowen?” Na tupwaliyao kainali siyamaisa siba, “Kai ama nuwatu iguguguguye dedei uloi ali yaubadao kaiweli.” Siwalo besiele bwaite kaiwena Paulo iguguye Yeisu yo toboita ali toloyoi kaiwena. ");
INSERT INTO tte_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Mwa Paulo siyogan yo silawan tautaubalao lalakili kolili bodane esana sipei Aliopegasi. Kabo siwalolau koina siba, “Tem sowasowana yakayakatai waluwaluna iya uguguguyeyanwa kuyamayale kolimai. ");
INSERT INTO tte_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kaiwena ginauli siya kali benali uloili kolimai yo nuwanuwamai kana dudulai kakatai.” ");
INSERT INTO tte_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Sauga meuloina Ateni tomoliyao yo siya laolaoma meuloili ali sauga siyavenuwan yo sibenabenali yo siedeedede ginauli waluwaluli kaiweli. ");
INSERT INTO tte_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Kabo Paulo itolo kaba logogo mena yo iwalolau tautaubalao kolili iba, “Kagutoki komiu Ateni tomoliyao. Yagitaimiu komiu sauga meuloina yaubadao meuloili kwayakasisi-yagili, ");
INSERT INTO tte_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","kaiwena yalokeikeile ami yanuwa kalona mena yo ami kaba pwalou yagitaili sibaibaiwa. Yagu lokeikeilene koina kaba pwaoli yabo yagitai kana lelelele yayasili iwalo, ‘Yaubada bwaite nige tokataina kana nuwatu-kalatan.’ Na Yaubadane iya koina kwapwalopwalou, iya nige wakakatai, bwaimwana iya kani yayawasa kolimiu. ");
INSERT INTO tte_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Yaubada iya yanuwa yaulina yo ginauline meuloina iyamayaleli, iya bulibuli yo yanuwa yaulina kali Guyau, nige imiyamiya nume kaba tapwalolo tomo sikabi koina. ");
INSERT INTO tte_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nige ginauli yabo ibwabwaga koina yakato kita tomo nimala mena tasagui kaiwena iya tomo meuloila yawasila, yaluyaluwala yo ginauli meuloili iyelima kolila. ");
INSERT INTO tte_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Tomo kaigeda iyamayale, yo iya koina tomo boda uloina uloina sidebalala yo sitatagwaligwali yanuwa yaulina dedei meuloina kolili simiyamiya. Tabe bodane kaigeda kaigeda ali sauga yo ali dedei iloinayan. ");
INSERT INTO tte_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Yaubada iginauli besiele, kaiwena nuwanuwana tomo siloyai yo ali loyane kalona mena iya silobai. Tomala iya nige imimiya-suwala tomo kaigeda kaigeda kolila. ");
INSERT INTO tte_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kaiwena yawasila yaina iya, mekalakava talolokeikeile yo mekalakava tamiyamiya. Besiele kwaboma kami wali kana tobuibui siba, ‘Yawasosi kita meuloila natunao.’ ");
INSERT INTO tte_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Mwa kita natunao, nige sowana ala nuwatu yakato Yaubada kana koleya besiele yamayamayale kokotomo tomo ali katai mena yo ali sonoga mena gole nuwana siliba nuwana veku koina siginaulili. ");
INSERT INTO tte_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Beyabeyana tomo nige ali katai yabo Mesaiya kaiwena mwa koina tomo ali naenaena koina igite-gabaegili. Na sauga bwaite iloina-yagili tomo dedei meuloina ali naenaena koina sinuwabui. ");
INSERT INTO tte_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kaiwena kaliyate yabo ipeiyako yanuwa yaulina kana tomiya meuloili naga iyatala namwanamwaili, yo tomo yabo igitesipwai-yako iya yatalane kani iginauli, kana yawasosi iyakenayagila meuloila kolila, kaiwena tomonane ikele-yatoloyoi-yako boita mena.” ");
INSERT INTO tte_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Saugana sibenalani Paulo iedeedede toloyoi kaiwena kabo boda tupwali sikawa-mwakomwakota-yani yo sitalatalawasi-yani. Na boda tupwaliyao siba, “Nuwanuwamai kuedeedede yoi nuwatu bwaite kaiwena na kabenalani.” ");
INSERT INTO tte_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Logogone imwawasi kabo Paulo ilogabaegili ilau. ");
INSERT INTO tte_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Tomo tupwali Paulo ana walo simeliyani mwa silusae ana boda koina. Luwali mena tomo yabo esana Dionisiya iya boda Aliopegasi kana tautaubalao kalikava yabo, sine yabo esana Damali yo tupwaliyao tabe. ");
INSERT INTO tte_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Kabo muli mena Paulo Ateni ilogabaeni yo ilau Kolinita. ");
INSERT INTO tte_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Yanuwane koina tomo Yudiya yabo iyaele esana Akuila sikabiya Ponitiyo polovinsi koina. Akuila mewainena Pilisila siya silaomaya Loma, Itali ana dedei mena, na sauga bwaite simiyamiya Kolinita kaiwena tauna kona Loma ali kin esana Sisa Kolodiyasi iwalo Yudiya meuloili yanuwa Loma silogabaen. Paulo wasali ibenalan yakato siyaele Kolinita koina na nuwanuwana ilau igitaili. Kabo ilau Kolinita koina ilobaili. ");
INSERT INTO tte_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Mwa imiyamiya kolili yo mekalikava sipaipaisowa, kaiwena iya yo siya ali paisowa kaigeda bwaimwa palai sikonakona besiele nume. ");
INSERT INTO tte_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sabati kaigeda kaigeda Paulo iedeedede Yudiya ali nume tapwalolo mena. Yo siya Yudiya yo Giliki mekalikava sigamwagamwa-pakiki na Paulo itonatonan nuwanuwana lalakina tem simeli. ");
INSERT INTO tte_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sailasa yo Timoti Masidoniya dedeina silogabaen silobima Kolinita kabo Paulo ana paisowa palai konakona ilopei na ana sauga meuloina italamwani guguye koina yo ikabiyamayale Yudiya tomoliyao kolili iba, “Yeisu iya Mesaiya.” ");
INSERT INTO tte_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Na saugana Yudiya siwalo-yavivilayoi Paulo koina yo sikawa-naenaeyani mwa kana kwama ikotataiyani kolili, kaiwena wasana namwanamwana sisikotanani mwa iwalolau kolili iba, “Tem kwasawowoli amokisa, kwaboma ami pwanoli. Nige sowana kwayakewaiyau. Sauga bwaite yalau siya nige Yudiya tomoliyao na wasana namwanamwana yaguguyeyani kolili.” ");
INSERT INTO tte_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kabo Paulo Yudiya ali nume tapwalolo ilogabaeni yo ilau Taita Yusito ana nume mena, iyaele nume tapwalolo salina mena. Tomone iya nige Yudiya tomona, na iyamo iya itapwatapwalolo Yaubada koina. ");
INSERT INTO tte_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Yudiya ali nume tapwalolo kana tobaguna esana Kilisipasi, iya yo ana nume kana tomiya meuloili sinuwabui na Guyau Yeisu simeliyani. Tabe Kolinita tomoliyao sibaibaiwa besiele, Paulo ana walo sibenalani, sinuwabui, simeli yo sibabitaiso. ");
INSERT INTO tte_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Boniyai yabo Paulo kenona ikenoi yo Guyau iwalo koina iba, “Tabu kumamatausi, wasana namwanamwana kuyawasa-kalatan tomo kolili, tabu kulolopei. ");
INSERT INTO tte_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Yau mekamkava mwa nige sowana tomo yabo ikaleya koliwo na isibayanaewo, kaiwena yanuwa bwaite koina tomo sibaibaiwa naga siyamala yagu tomoyao.” ");
INSERT INTO tte_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Mwa Paulo imiyamiya sauga tupwanayoi yo ana miyamiya Kolinita koina kana mamalawe bolime kaigeda yo tupwana. Sauganane koina Yaubada ana walo iguguguguyeyani tomo kolili. ");
INSERT INTO tte_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galio ana sauga gavana dedei Akaya bwaimwa Gilisi koina mwa Yudiya tomoliyao ali nuwatu kaigeda kabo silau Paulo sikabikalatani yo silawani gavanane koina yakato iyatalayan. ");
INSERT INTO tte_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Siba, “Tomone bwaite tomo nuwaliyao ikoikoili, nuwanuwana kamwasa waluwaluna koina sitapwalolo Yaubada koina, kamwasane ama loina nige itatalamwani.” ");
INSERT INTO tte_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Saugana Paulo gamwana isaei yakato iedeedede, mwa Galio iwalolau Yudiya tomoliyao kolili iba, “Temga tomo bwaite ilopwano na nae yabo iginauli kabo sowasowagu ami walo yabenalani. ");
INSERT INTO tte_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Na ami gamwapakikine bwaimwa ami edeedede yo esa yo ami loina kaiweli bwaimwana siya ginauli kikiuli kwaboma kwayadudulaili, genuwagu bwaite ginauline yayatalayagili.” ");
INSERT INTO tte_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Mwa itawoili siyawatagili kaba yatala mena. ");
INSERT INTO tte_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Kabo bodane sigitai Sositeni, iya Yudiya ali nume tapwalolo kana tobaguna, silokalatani yo siunu-gwalagwalai kaba yatala salina mena na Galio nige inunuwatui ali paisowane kaiwena. ");
INSERT INTO tte_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo imiyamiya Kolinita sauga tupwana imamalawe, kabo muli mena tomeliwo ilogabaegili yo Pilisila mewainena Akuila mekanakavao silobi silau galowa Sensiliya. Bwaine koina itona itom-gabaeni kaiwena tauna kona ana waloyameli iginauli Yaubada manna mena. Imwawasi waga mena simwalisae kaiwena Paulo nuwanuwana ivivilayoi dedei Siliya. ");
INSERT INTO tte_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Sikuke silau siulisi Epeso bwaine koina sikaisulu. Paulo Pilisila yo Akuila ilogabaegili, na iboma ilau Yudiya ali nume tapwalolo mena, yo mekanakavao Yudiya tomoliyao siedeedede yo sigamwapakiki. ");
INSERT INTO tte_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Sikawanoi koina yakato tem mekalikava simiyamiya naga sauga tupwana imamalawe na iyamo nige ana nuwatu besiele. ");
INSERT INTO tte_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ana sauga lowasi koina 