﻿USE sofia;
DROP TABLE IF EXISTS sofia.tsw_vpl;
CREATE TABLE tsw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tsw_vpl WRITE;
INSERT INTO tsw_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","A̱sulazuva e ɗe ta̱ Musa reve u yuwan adanshi na̱ a̱yi diga o Oogodo o Uga'asusan. Reve u damma yi, ");
INSERT INTO tsw_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","<<Yuwan adanshi na ama a Isra'ila vu damma le: Mantsa ma na za ro ɗu a̱a̱ ta̱wa̱a̱ A̱sulazuva na̱ kucci, u ta̱wa̱a̱ na̱ kucci vi iliyamunga ko vo oɓolo e inan ko vu mgbele ko vi ikyon. ");
INSERT INTO tsw_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","<<Na̱ kucci'i za vu ukula̱tosu u ɗa wi inan, u ta ca ogono a nan na ri usa̱du shi. U ta̱wa̱ na̱ a̱yi o una̱ntsu wo Oogodo o Uga'asusa'an adama wo o'wo kucci na A̱sulazuva a̱a̱ usu. ");
INSERT INTO tsw_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","U ta̱ kuru ukere wa̱ yi a aaci a̱ kucci vu ukula̱tosu'u, reve a̱ usuwa̱ yi a̱yi wo o'wo kucci matara mo ume mo unusu wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Vuma'a u ta paɗa moggono'o a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. Reve olobo a Haruna nan ganu a̱ ta̱wa̱ na̱ mpasa'a, reve o kyo'onu yi e eɓele a masa'a'a suru ma na ma̱ ri o una̱ntsu wo Oogodo o Uga'asusan. ");
INSERT INTO tsw_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","U ta muna kucci vu ukula̱tosu'u, reve wu paɗa yi mupaɗi mupaɗi. ");
INSERT INTO tsw_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Reve olobo a Haruna ganu a zuwa akina a masa'a reve e gere ɗanga a akina'a. ");
INSERT INTO tsw_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Reve e gere mupaɗi'i oɓolo na aaci na abaji a mani'in a ɗanga madala na ri a masa'a'a. ");
INSERT INTO tsw_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Amma wu za̱'wa̱ iliya̱tsuma̱ no okotsu a̱ yi na̱ mini. Reve ganu kula̱to yi suru a masa'a. Kucci vu ukula̱tosu ɗa, kucci na a yuwain na akina, ili i ma̱guru ma na A̱sulazuva aa uwwusa uyo'o wa yi. ");
INSERT INTO tsw_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","<<Nna̱ kucci vu ukula̱tosu va̱ yi za vi ikyon i ɗa ko mgbele, reve u ca ogono a na a̱ ri usa̱du shi. ");
INSERT INTO tsw_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","U ta paɗa yi upasu wu ugana u masa'a'a a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. Reve olobo a Haruna nan ganu o kyo'onu mpasa ma̱ yi e eɓele a masa'a'a suru a̱ ka̱nda̱ruwa̱. ");
INSERT INTO tsw_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Wu paɗa yi mupaɗi mupaɗi, reve ganu gere le, oɓolo na aaci na abaji a mani'in a ɗanga madala na ri a masa'a'a. ");
INSERT INTO tsw_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Wu za̱'wa̱ iliya̱tsuma̱ no okotsu na̱ mini, reve ganu ta̱wa̱ na̱ a̱yi suru, a̱vu u kula̱to yi a masa'a'a. Kucci vu ukula̱tosu ɗa, kucci na a yuwain na akina, ili i ma̱guru ma na A̱sulazuva aa uwwusa uyo'o wa yi. ");
INSERT INTO tsw_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","<<Na̱ kucci vu ukula̱tosu a̱ tyo ya̱ A̱sulazuva'a za vu nnunu n ɗa, u ta ca muɗa ko ma̱ma̱rukuku. ");
INSERT INTO tsw_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Ganu ta̱ ta̱wa̱ na̱ a̱yi a masa'a reve u punda̱ra̱ yi yinlu u mula̱ aaci'i. Reve u kula̱to yi a masa'a'a. Reve a lyawa mpasa ma̱ yi mo ocusho a̱ nge'en m masa'a'a. ");
INSERT INTO tsw_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","U to foɗo owofun ni ili i na i ri pe suru, reve u vari yi e eeɓele a asana a masa'a'a, uba̱ta̱ wo okomo. ");
INSERT INTO tsw_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","U te reme evelu a̱ yi reve u ɗa̱ra̱la̱ niyi, amma waa karala niyi shi. Reve ganu'u u kula̱to yi a masa'a'a a ɗanga na ri a madala. Kucci vu ukula̱tosu ɗa, kucci na a yuwain na akina, ili i ma̱guru ma na A̱sulazuva aa uwwusa uyo'o wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","<<Na̱ vuma ta̱wa̱a̱ A̱sulazuva na̱ kucci vi ishina, u ta̱ ta̱wa̱ na̱ yira i lashi. U ta̱ tsun yi mani'in ni ili i ma̱guru i na a̱ tsu ɗe furenkisen. ");
INSERT INTO tsw_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Reve u ta̱wa̱ na̱ a̱yi uba̱ta̱ wo olobo a Haruna nan ganu. Ganu to shiton ukere na̱ yira i lashi'i na̱ mani'in oɓolo na̱ furenkisen suru. Reve u kula̱to yi ili yu ucuwusan zuva masa'a'a, kucci na a yuwain na akina, ili i ma̱guru ma na A̱sulazuva aa uwwusa uyo'o wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Akapi a̱ kucci vi ishina na buwai, u to o'wo za va Haruna no olobo a̱ yi, a̱yi ɗa u la'ai akiza u kucci na a cayi A̱sulazuva va akina. ");
INSERT INTO tsw_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","<<A mantsa ma na i ta̱wa̱i na̱ kucci vi ishina i na a zatsuyi a wuwan, wo o'wo za yira i lashi, opopofu a na a̱ ri na̱ wolilo shi na a̱ ja̱mba̱ra̱i na̱ mani'in, ko emeshen a na a yuwain babu wolilo na a putalai na̱ mani'in ma ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Na̱ kucci yira vi ishina va̱ wu yi za na a kangalai a ataɗa a ɗa, a yuwan yi na̱ yira i lashi i na a̱ ja̱mba̱ra̱i na̱ mani'in babu wolilo. ");
INSERT INTO tsw_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Vu busa yi mubushi mubushi, reve vu tsun yi mani'in, kucci vi ishina ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Nna̱ kucci yira vi ishina va̱ wu vi ili i na a raluyi a ataɗa a ɗa, a yuwan yi na̱ yira i lashi na̱ mani'in. ");
INSERT INTO tsw_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","I ta̱wa̱a̱ A̱sulazuva kucci vi ishina vi ili i na a yuwain ni ili i nda. I ca ganu ele, a̱yi ɗa wa̱a̱ ta̱wa̱ ne ele a masa'a. ");
INSERT INTO tsw_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","U te kene pe ili yu ucuwusan a̱tsuma̱ a̱ kucci vi ishina'a, reve u kula̱to yi a masa'a'a. Kucci na a yuwain na akina, ili i ma̱guru ma na A̱sulazuva aa uwwusa uyo'o wa yi. ");
INSERT INTO tsw_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Akapi a̱ kucci vi ishina na buwai u to o'wo za va Haruna no olobo a̱ yi, a̱yi ɗa u la'ai akiza u kucci na a cayi A̱sulazuva va akina. ");
INSERT INTO tsw_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","<<Babu kucci vi ishina na a̱a̱ ta̱wa̱a̱ A̱sulazuva i na aa yuwan na̱ wolilo, adama a na ya̱a̱ kula̱to wolilo ko ishiki a̱tsuma̱ a̱ kucci na a cayi A̱sulazuva na akina shi. ");
INSERT INTO tsw_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","I ta gura ta̱wa̱ ne ele tsa̱ kucci vu umatsun wu ufaru ya̱ A̱sulazuva, agba aa yuwan kucci ne ele a masa'a kucci ma̱guru mo uyo'o shi. ");
INSERT INTO tsw_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","I ta̱ tsun kucci vi ishina i ɗu suru akpaɗi. She i kuɗa̱ a̱ tsun akpaɗi a akucunu a̱ A̱sula̱ a̱ ɗu a̱ kucci vi ishina ɗu wan. I tsun akpaɗi a̱ kucci ɗu suru. ");
INSERT INTO tsw_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","<<Nni i ta̱wa̱a̱ A̱sulazuva na̱ kucci vi ishina vu umatsun wu ufaru, i ca a̱ga̱za̱ e ishina i sa'avu o uzuwun i na a kparai. ");
INSERT INTO tsw_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Reve i tsun yi mani'in na̱ furenkisen, kucci vi ishina ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Ganu ta̱ kula̱to ili yu ucuwusan diga pe e ishina i na a kparai'i na̱ mani'in oɓolo ni ili i furenkise'en suru, kucci na a cayi A̱sulazuva va akina. ");
INSERT INTO tsw_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","<<Nna̱ kucci na vuma a̱a̱ ta̱wa̱a̱ za muwwulai ɗa, u ta ca diga a̱tsuma̱ o oɓolo e inan ogono ko a̱na̱wu. U ta ca za na ri usa̱du shi e ekere a̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","U ta̱ kuru ukere wa̱ yi a aaci e ili i na u cayi, reve u paɗa yi o u'uwata wo Oogodo o Uga'asusan. Reve olobo a Haruna nan ganu o kyo'onu mpasa'a e eɓele a masa'a'a suru a̱ ka̱nda̱ruwa̱. ");
INSERT INTO tsw_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Diga pe a̱ kucci muwwulai'i u ta̱ ta̱wa̱a̱ A̱sulazuva na̱ kucci vi ili i nda na a yuwain na akina: abaji a mani'in ma na ma palai iliya̱tsuma̱ suru na̱ za na ri uɓoluloi ni iliya̱tsuma̱'a̱, ");
INSERT INTO tsw_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","oɓolo na a'ilu e re na abaji a mani'in ma na ma̱ ri uɓoluloi ne ele ma na ma̱ ri zuzu ne eetele e ikyun, nu upasu wa assuvu u na u la'ai ulobonu, za na woo foɗo oɓolo na a'ilu'u. ");
INSERT INTO tsw_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Reve olobo a Haruna a̱ kula̱to le a masa'a'a oɓolo na̱ kucci vu ukula̱tosu u na u ri a ɗanga madala, kucci na a yuwain na akina, ili i ma̱guru ma na A̱sulazuva aa uwwusa uyo'o wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","<<Nnu u ca diga e ikyon ko e mgbele kucci muwwulai e ekere a̱ A̱sulazuva, u ta ca ogono ko a̱na̱wu a na a̱ ri usa̱du shi. ");
INSERT INTO tsw_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Nnu u ca ma̱giri'i, u ta̱ ta̱wa̱ na̱ a̱yi a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","U ta̱ kuru ukere wa̱ yi a aaci e ili i na u cayi, reve u paɗa yi elime o Oogodo o Uga'asusan. Reve olobo a Haruna o kyo'onu mpasa ma̱ yi e eɓele a masa'a'a suru a̱ ka̱nda̱ruwa̱. ");
INSERT INTO tsw_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Diga pe a̱ kucci muwwulai'i u ta ca kucci vi ili i nda na a yuwain na akina uba̱ta̱ wa̱ A̱sulazuva: mani'in ma̱ yi na̱ wizan u na u ri na̱ mani'in suru za na aa paɗa zuzu ne eetele e ikyun, oɓolo na̱ mani'in ma na ma palai iliya̱tsuma̱ suru ko za na ri uɓoluloi ni iliya̱tsuma̱'a̱, ");
INSERT INTO tsw_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","na a'ilu e re na̱ mani'in ma na ma̱ ri uɓoluloi ne ele ma na ma̱ ri zuzu ne eetele e ikyun, nu upasu wa assuvu u na u la'ai ulobonu, za na woo foɗo oɓolo na a'ilu'u. ");
INSERT INTO tsw_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Ganu ta̱ kula̱to le a masa'a, tsi ilyalya kucci na a cayi A̱sulazuva na akina. ");
INSERT INTO tsw_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","<<Na̱ kucci va̱ yi za megbele ma ɗa, u ta̱ ta̱wa̱ na̱ a̱yi a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","U ta̱ kuru ukere wa̱ yi a aaci a̱ yi, reve u paɗa yi elime o una̱ntsu wo Oogodo o Uga'asusan. Reve olobo a Haruna o kyo'onu mpasa ma̱ yi e eɓele a masa'a'a suru a̱ ka̱nda̱ruwa̱. ");
INSERT INTO tsw_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Diga e ili i na u cayi'i u ta ca A̱sulazuva ili i nda kucci va akina: abaji a mani'in ma na ma palai iliya̱tsuma̱ suru na̱ za na ri uɓoluloi ne ele, ");
INSERT INTO tsw_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","na a'ilu e re na̱ mani'in ma na ma̱ ri uɓoluloi ne ele ma na ma̱ ri zuzu ne eetele e ikyun, nu upasu wa assuvu u na u la'ai ulobonu, za na woo foɗo oɓolo na a'ilu'u. ");
INSERT INTO tsw_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Ganu ta̱ kula̱to le a masa'a tsi ilyalya, kucci na a yuwain va akina ili i ma̱guru mo uyo'o. Abaji a mani'in suru za va A̱sulazuva a ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","<<A̱yi nda u to o'wo ili i mayan kuci hali a̱ tyo mantsa suru, uba̱ta̱ u na i da̱nuyi suru. She i tama abaji a mani'in ko mpasa wan.>> ");
INSERT INTO tsw_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Reve A̱sulazuva a damma Musa, ");
INSERT INTO tsw_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","<<Damma aza a Isra'ila, na̱ vuma yuwan unusu o ucigu wa̱ yi shi a̱vu u yuwan ili i ta̱ e ili i na A̱sulazuva a zuwai she a yuwan wan, ");
INSERT INTO tsw_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","nna̱ ganu na a̱ tsuwa̱yin mani'in yuwan unusu, reve u ta̱wa̱a̱ ama nu unusu, u ta̱ ta̱wa̱a̱ A̱sulazuva na̱ moggono ma nan ma na ma̱ ri usa̱du shi kucci adama o unusu u na u yuwain. ");
INSERT INTO tsw_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","U ta̱ ta̱wa̱a̱ na̱ moggono'o o u'uwata wo Oogodo o Uga'asusan a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. U ta̱ kuru ukere wa̱ yi a aaci a̱ yi, reve u paɗa yi a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Reve ganu na a̱ tsuwa̱yin mani'i'in u kene mpasa m moggono'o reve u tara yi a uwa o Oogodo o Uga'asusan. ");
INSERT INTO tsw_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Waru u tsupu aakatsu a̱ yi a mpasa'a, reve wu kyo'onu yi toto ucindere a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva elime o umuna wa̱ A̱a̱'isa̱. ");
INSERT INTO tsw_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Reve ganu putala mpasa n ro a avana a masa'a e ili i ma̱guru mo uyo'o ma na ma̱ ri a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva o Oogodo o Uga'asusan. Reve u tsun akapi a mpasa m moggono'o e ikyun i masa'a ma̱ kucci vu ukula̱tosu o u'uwata wo Oogodo o Uga'asusan. ");
INSERT INTO tsw_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Reve u foɗo abaji a mani'in o moggono ma na a cayi kucci adama o unusu'u suru, na̱ mani'in ma na ma palai iliya̱tsuma̱ na̱ za na ri uɓoluloi ni iliya̱tsuma̱ suru, ");
INSERT INTO tsw_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","na a'ilu e re na̱ mani'in ma na ma̱ ri uɓoluloi ne ele ma na ma̱ ri zuzu ne eetele e ikyun, nu upasu wa assuvu u na u la'ai ulobonu, za na woo foɗo oɓolo na a'ilu'u. ");
INSERT INTO tsw_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","U to foɗo mani'i'in cine o tsu foɗo za vo ogono a na a cayi adama a muwwulai. Reve ganu kula̱to le a masa'a mo ukula̱tosu u kucci. ");
INSERT INTO tsw_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Amma ukwan u moggono'o ni inama ya̱ yi suru na aaci a̱ yi na ana a̱ yi ni iliya̱tsuma̱ ya̱ yi na̱ a̱ya̱n a̱ yi, ");
INSERT INTO tsw_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","na akapi o moggono'o suru, u ta tara le o uta̱ o ucina̱ wu uva̱la̱ta̱ a̱ tyo uba̱ta̱ u na u ri cece, uba̱ta̱ u na oo ocosu okomo. Reve u kula̱to le ɗe na̱ ɗanga madala e edemu o okomo'o. ");
INSERT INTO tsw_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","<<Nna ama a Isra'ila suru a yuwan unusu o ucigu u le shi a̱vu a yuwan ili i ta̱ e ili i na A̱sulazuva a zuwai she a yuwan wan, ko na̱ a̱ shi e reve ni ili'i shi, a̱ ta̱ nu unusu. ");
INSERT INTO tsw_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Nna̱ a̱ ta̱wa̱ e reve nu unusu u na a yuwain, a ta ca kucci moggono ma nan adama a̱ kucci vu unusu o una̱ntsu wo Oogodo o Uga'asusan. ");
INSERT INTO tsw_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Mbara ma ama a Isra'ila'a n ta̱ kuru ekere e le a aaci o moggono ma na'an a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva, reve a paɗa yi lo. ");
INSERT INTO tsw_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Reve ganu na a̱ tsuwa̱yin mani'in u kene mpasa m moggono'o a uwa pe o Oogodo o Uga'asusa'an. ");
INSERT INTO tsw_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","U ta̱ tsupu aakatsu a̱ yi a̱tsuma̱ a mpasa'a reve wu kyo'onu yi a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva toto ucindere elime o umuna'a. ");
INSERT INTO tsw_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Reve ganu'u u putala mpasa n ro a avana a masa'a'a ma na ma̱ ri a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva o Oogodo o Uga'asusan. Akapi a mpasa n na m buwai reve u tsun yi e ikyun i masa'a ma̱ kucci vu ukula̱tosu o u'uwata wo Oogodo o Uga'asusan. ");
INSERT INTO tsw_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","U to foɗo abaji a mani'in ma̱ yi suru, reve u kula̱to yi a masa'a'a. ");
INSERT INTO tsw_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","U ta yuwan na̱ moggono ma na'an cine u yuwain na̱ moggono ma na a cayi kucci adama o unusu. Ne tsunda tsa ɗa ganu a yuwaan le kucci matara mo ume mo unusu, reve gba a yuwaan le gafura. ");
INSERT INTO tsw_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Reve u tara na'an o uta̱ o ucina̱ wu uva̱la̱ta̱ a̱vu u kula̱to yi cine u kula̱toi nan vu ufaru. A̱yi nda a̱yi ɗa kucci vu unusu adama a ama a Isra'ila. ");
INSERT INTO tsw_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","<<Nna̱ zagbain yuwan unusu o ucigu wa̱ yi shi, a̱vu u yuwan ili i ta̱ e ili i na A̱sulazuva A̱sula̱ a̱ yi a zuwai, u ta̱ nu unusu. ");
INSERT INTO tsw_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Nno o roco yi unusu u na u yuwain, u ta ca kucci ma̱ga̱ji ma na ma̱ ri usa̱du shi. ");
INSERT INTO tsw_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","U ta̱ kuru ukere wa̱ yi a aaci a̱ ma̱ga̱ji'i, reve u paɗa yi uba̱ta̱ u na a tsu paɗasa kucci na a̱ kula̱tosu a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. Kucci adama o unusu u ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Reve ganu shepe mpasa n kucci adama o unusu'u na aakatsu a̱ yi, reve u putala a avana a masa'a ma̱ kucci vu ukula̱tosu, a̱vu u tsun akapi a mpasa'a e ikyun i masa'a'a. ");
INSERT INTO tsw_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","U ta̱ kula̱to abaji a mani'i'in suru a masa'a cine u kula̱toi mani'in ma̱ kucci muwwulai. Ne ɗa ganu aa ca kucci adama a matara mo ume mo unusu adama a zagbai'in, reve a yuwaan yi gafura. ");
INSERT INTO tsw_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","<<Na̱ vuma ro a̱tsuma̱ a ama yuwan unusu nu ucigu wa̱ yi shi, a̱vu u yuwan ili i ta̱ e ili i na A̱sulazuva a zuwai, u ta̱ nu unusu. ");
INSERT INTO tsw_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Nno o roco yi unusu u na u yuwain, u ta̱ ta̱wa̱a̱ na̱ a̱na̱wu e megbele a na a̱ ri usa̱du shi kucci o una̱ wu unusu u na u yuwain. ");
INSERT INTO tsw_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","U ta̱ kuru ukere wa̱ yi a aaci a̱ kucci vu unusu'u reve u paɗa yi uba̱ta̱ u kucci vu ukula̱tosu. ");
INSERT INTO tsw_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Reve ganu shepe mpasa'a na aakatsu a̱ yi, reve u putala a avana a masa'a ma̱ kucci vu ukula̱tosu. Reve u tsun akapi a na a buwai e ikyun i masa'a'a. ");
INSERT INTO tsw_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","U to foɗo abaji a mani'in suru cine o tsu foɗo mani'in ma̱ kucci muwwulai. Reve ganu kula̱to yi a masa'a ili i ma̱guru mo uyo'o e ekere a̱ A̱sulazuva. Ne ɗa ganu a yuwaan yi kucci matara mo ume mo unusu, a̱ ta̱ gba a yuwaan yi gafura. ");
INSERT INTO tsw_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","<<Nna̱ mokyokyon ma ɗa wa̱a̱ ta̱wa̱a̱ kucci vu unusu va̱ yi, a̱na̱wu a ɗa wa̱a̱ ta̱wa̱a̱ za na ri usa̱du shi. ");
INSERT INTO tsw_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","U ta̱ kuru ukere wa̱ yi a aaci a̱ yi, reve u paɗa yi adama a̱ kucci vu unusu uba̱ta̱ u na a tsu paɗasa kucci vu ukula̱tosu. ");
INSERT INTO tsw_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Ganu ta̱ shepe mpasa n kucci vu unusu'u na aakatsu a̱ yi reve u putala a avana a masa'a ma̱ kucci vu ukula̱tosu. Reve u tsun akapi a mpasa'a e ikyun i masa'a'a. ");
INSERT INTO tsw_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","U to foɗo abaji a mani'in suru cine o tsu foɗo mani'in mo kyon kucci muwwulai. Reve ganu kula̱to yi a masa'a'a zuva kucci na a cayi A̱sulazuva va akina. Ne ɗa ganu aa yuwaan vuma'a kucci matara mo ume mo unusu u na u yuwain, a̱ ta̱ gba a yuwaan yi gafura. ");
INSERT INTO tsw_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","<<Nna̱ vuma kuɗa̱ a yuwan adanshi a mantsa ma na e ɗe niyi adama u damma ili i na we enei ko u revei, u yuwan ta̱ unusu, waru ume wu unusu u ndolo u ta̱ a aci a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Ko gba na̱ vuma ju'wa̱n ili i na a tarai ili yi idaba i ɗa nu urevu wa̱ yi shi, ko a̱kwa̱kwa̱ a nama vu una ɗa, ko a̱kwa̱kwa̱ a nama vu u'wa ko a̱kwa̱kwa̱ e ili i na i ri e ika̱ta̱pu, wo o'wo ta̱ idaba. Waru u ta̱ nu unusu ko na wo o'woi u ri nu urevu shi. ");
INSERT INTO tsw_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ko gba nu u ju'wa̱n cu'un vi ili yi idaba i na i tsu uta̱ uba̱ta̱ u vuma i na i tsu zuwa vuma o o'wo idaba biti, ko nu u ri nu urevu shi, nnu u ta̱wa̱ u reve wo o'wo ta̱ za vu unusu. ");
INSERT INTO tsw_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Ko gba na̱ vuma yuwan akucunu nu una̱ wa̱ yi iwa̱u a na waa yuwan ili i ro, ko ni iwuya i ɗa ko isa'ani, a̱tsuma̱ e ili i na suru vuma yuwain akucunu na̱ majiyan shi, ko nu u reve na̱ a̱yi shi, nnu u ta̱wa̱ u reve wo o'wo ta̱ za vu unusu. ");
INSERT INTO tsw_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Nna̱ vuma yuwan ta̱ unusu u ta̱ a̱tsuma̱ a̱ nusu nda, u damma unusu u na u yuwain. ");
INSERT INTO tsw_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","U ta̱ ta̱wa̱a̱ na̱ mokyokyon ko megbele kucci vu unusu va̱ yi uba̱ta̱ wa̱ A̱sulazuva adama o unusu u na u yuwain. Reve ganu ca kucci matara mo ume mo unusu adama o unusu wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","<<Agba nna̱ wa̱a̱ tsura̱ mokyokyon shi, reve u ta̱wa̱a̱ A̱sulazuva na̱ muɗa n re ko murukuku n re adama a atsupu o unusu u na u yuwain, za ta̱ ta̱ adama a̱ kucci vu unusu za ta̱ ta̱ waru adama a̱ kucci vu ukula̱tosu. ");
INSERT INTO tsw_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","U ta̱ ta̱wa̱ ne ele uba̱ta̱ wa ganu, za na aa fara ca za vu unusu. U ta̱ punda̱ra̱ yi yinlu amma wa̱a̱ mula̱ aaci'i shi. ");
INSERT INTO tsw_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","U to kyo'onu mpasa n kucci vu unusu e eɓele a masa'a'a, reve u koso kpoko akapi a mpasa n na m buwai e ikyun i masa'a'a, kucci adama o unusu u ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Reve u ca za ire kucci vu ukula̱tosu cine a zuwai a yuwan. Ne ɗa ganu aa yuwan kucci matara mo ume mo unusu adama o unusu u na vuma'a u yuwain, reve gba a yuwaan yi gafura. ");
INSERT INTO tsw_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","<<Agba na̱ waa gura tsura̱ muɗa n re ko murukuku n re shi, to u ta̱ ta̱wa̱a̱ nu ukunzuwu u ta̱ u efa u yira i lashi kucci adama o unusu wa̱ yi. She u tsun yi mani'in wan waru she u tsun yi ili i ma̱guru wan, adama a na kucci adama o unusu u ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Vuma'a u ta tara yira'a a̱ tyo ya ganu, reve ganu'u u kene ukere u ta̱ tapu ili yu ucuwusan. Reve u kula̱to yi a masa'a zuva vi ilyalya i na a cayi A̱sulazuva va akina. Kucci adama o unusu u ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ne tsunda tsa ɗa ganu aa yuwan kucci matara mo ume mo unusu adama o unusu u na vuma'a u yuwain, reve gba a yuwaan yi gafura. Ili i na i buwai u to o'wo za va ganu, cine u ri a̱ kucci vi ishina.>> ");
INSERT INTO tsw_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Reve A̱sulazuva a damma Musa, ");
INSERT INTO tsw_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","<<Nna̱ za ro a̱tsuma̱ a̱ ɗu yuwan ulambu wa̱ a̱ɓula̱, reve u yuwan unusu nu ucigu wa̱ yi shi e ekere e ili i na a tarai na akiza ya̱ A̱sulazuva, u ta̱ ta̱wa̱a̱ A̱sulazuva kucci vu unusu a̱a̱giri'i a̱tsuma̱ o oɓolo a̱ yi za na ri usa̱du shi. Ikebe ya̱ a̱a̱giri'i'i u te reme azurufa vi ili i na aa yuwusaan ulinga na̱ a̱yi a̱ a̱a̱'isa̱. Kucci makuɗa ma̱ wila̱ ma ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Vuma'a u ta tsupa adama e ili i na u yuwain unusu e ili ya akiza'a. Reve u da̱shi za ta̱ a̱tsuma̱ o ozo o ton, reve u ca ganu. Ganu ta yuwan kucci matara mo ume mo unusu adama a̱ yi oɓolo na̱ a̱a̱giri'i a̱ kucci makuɗa ma̱ wila̱, reve gba a yuwaan yi gafura. ");
INSERT INTO tsw_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","<<Nna̱ vuma yuwan unusu a̱vu u yuwan ili i ta̱ a̱tsuma̱ e ili i na A̱sulazuva a zuwai she a yuwan wan, ko nu u shi u reve na̱ a̱yi shi, u kuɗa ta̱ wila̱ waru ume wu unusu u ndolo u ta̱ a aci a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","U ta̱ ta̱wa̱a̱ ganu na̱ a̱a̱giri'i a na a̱ ri usa̱du shi kucci makuɗa ma̱ wila̱ diga o oɓolo e ikyon ya̱ yi, ikebe ya̱ yi i yuwan una̱ta̱ nu ukunzuwu u na a zuwai. Ne ɗa ganu aa yuwan kucci matara mo ume mo unusu u vuma'a adama o unusu u na u yuwain nu ucigu shi. Reve gba a yuwaan yi gafura. ");
INSERT INTO tsw_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Kucci vu unusu u ɗa, u yuwaan ta̱ A̱sulazuva unusu na amayun.>> ");
INSERT INTO tsw_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Reve A̱sulazuva a damma Musa, ");
INSERT INTO tsw_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","<<Nna̱ vuma yuwan unusu wu ulambu wa̱ a̱ɓula̱ e ekere a̱ A̱sulazuva wu luma̱ moron ma̱ nden ma̱ yi, ni ili i na a ca niyi izuwa ko u yuwan yi wivu ko gba shi u paala moron ma̱ nden ma̱ yi, ");
INSERT INTO tsw_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ko gba u tsura̱ ili i na i puwa̱yin, reve u yuwan epen adama a̱ yi ko u kucina ne epen, ko u yuwan unusu u ro u na ama aa gura yuwan, ");
INSERT INTO tsw_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","nu u nusan a̱vu u ta̱wa̱ u reve nu unusu wa̱ yi, u ta̱ ka̱mbuwa̱ ili i na wi iva̱i ko ili i na u tsura̱i na a'usa ko ni ili i na a ca niyi izuwa ko ili i na u tsura̱i i na i puwa̱yin, ");
INSERT INTO tsw_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ko e ili i na u yuwain akucunu e epen adama a̱ yi. U ta̱ ka̱mbuwa̱ yi suru hali u da̱shi za ta̱ a̱tsuma̱ o ozo o ton. Reve u ca za vi ili o urana u na waa ca kucci vu unusu va̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Reve u ta̱wa̱a̱ ganu atsupu o unusu a̱a̱giri'i a na a̱ ri usa̱du shi diga o oɓolo e ikyon kucci makuɗa ma̱ wila̱ e ekere a̱ A̱sulazuva, ikebe ya̱ yi i yuwan una̱ta̱ nu ukunzuwu u na a zuwai. ");
INSERT INTO tsw_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Ne ɗa ganu aa yuwan kucci matara mo ume mo unusu u vuma'a a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. Reve a yuwaan yi gafura vu unusu u na u yuwain e ili i nda i na i zuwa niyi wo o'woi za vu unusu.>> ");
INSERT INTO tsw_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","A̱sulazuva waru a damma ta̱ Musa, ");
INSERT INTO tsw_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","<<Vu damma Haruna no olobo a̱ yi a na, apa nda wila̱ u kucci vu ukula̱tosu: Kucci vu ukula̱tosu u ta̱ asa a akinkina zuva masa'a hali usana, waru akina'a a̱ ta̱ da̱na̱ a madala. ");
INSERT INTO tsw_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Reve ganu oto a̱tugu o okoro na̱ mokoɗi ma aacaka ma̱ yi. Reve u pura̱ okomo a̱ kucci vu ukula̱tosu u tsun a̱ nge'en m masa'a. ");
INSERT INTO tsw_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Reve u foɗo itana i nda a̱vu wo oto ozo o ro. Reve u tanu okomo'o a̱ tyo o ucina̱ wu uva̱la̱ta̱ uba̱ta̱ u cece. ");
INSERT INTO tsw_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Akina a na a̱ ri a masa'a'a u ta̱ da̱na̱ a madala, she u kima̱ wan. Ganu ta̱ ri n da̱shishi ɗanga a akina'a usana suru. Reve u gere ɗe kucci vu ukula̱tosu a akina'a u kula̱to abaji a mani'in kucci muwwulai ɗe. ");
INSERT INTO tsw_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Akina'a u da̱na̱ a̱ madala a masa'a'a, she u kima̱ wan. ");
INSERT INTO tsw_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","<<Apa nda cine a̱ ri n yuwusan kucci vi ishina: Olobo a Haruna a̱ ta̱ ta̱wa̱ na̱ a̱yi uba̱ta̱ wa̱ A̱sulazuva elime a masa'a'a. ");
INSERT INTO tsw_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Ganu te kene ukere u ta̱ tapu pe a yira i lashi'i na̱ mani'in oɓolo ni ili i ma̱guru suru, reve u kula̱to le ili yu ucuwusan a masa'a'a, ili i ma̱guru mo uyo'o e ekere a̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Haruna no olobo a̱ yi a ta tama akapi a na a buwai. A ta tama yi babu wolilo uba̱ta̱ wa akiza o ukowo wo Oogodo o Uga'asusan. ");
INSERT INTO tsw_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","A̱a̱ zun yi na̱ wolilo shi, n ca ta̱ nan ganu a̱yi wo o'wo akunda e le e ili i na a ca numu va akina. A̱yi ɗa ili i na i la'ai akiza, tsa̱ kucci vu unusu na̱ kucci makuɗa ma̱ wila̱. ");
INSERT INTO tsw_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Ulobo suru a̱tsuma̱ o olobo a Haruna u ta tama yi, cine a zuwai hali a̱ tyo a mantsa me elime, ili i na a cayi A̱sulazuva va akina. Ili i na suru i ju'wa̱in nle, u to o'wo na akiza.>> ");
INSERT INTO tsw_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","A̱sulazuva a yuwan ta̱ adanshi na̱ Musa u damma, ");
INSERT INTO tsw_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","<<Apa nda kucci na Haruna no olobo a̱ yi aa ca A̱sulazuva urana u na a̱ tsun niyi mani'in: ukunzuwu u ta̱ u efa u yira i lashi a̱tsuma̱ a kupa, cine a̱ tsu ta̱wa̱a̱ na̱ kucci vi ishina. A̱ ta̱ ta̱wa̱a̱ na akapi nu usana akapi waru nu ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","A̱ ta̱ ja̱mba̱ra̱ yi na̱ mani'in a̱vu a kangala yi a ataɗa o ukangalu. A̱ ta̱ ta̱wa̱ na̱ a̱yi uja̱mba̱ru ulobonu, ukangalu mukutsu mukutsu tsa̱ kucci vi ishina, ili i ma̱guru mo uyo'o e ekere a̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ulobo u na waa tara e ekere a̱ yi tsa ganu na a̱ tsuyin mani'in, a̱yi ɗa woo foɓo yi. Akunda a̱ A̱sulazuva a ɗa kuci, a̱ ta̱ kula̱to yi suru. ");
INSERT INTO tsw_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Kucci vi ishina va ganu suru a̱ ta̱ kula̱to yi suru, aa lyuwa yi shi.>> ");
INSERT INTO tsw_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Reve A̱sulazuva a damma Musa, ");
INSERT INTO tsw_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","<<Yuwan adanshi na̱ Haruna no olobo a̱ yi: Apa nda ure u mayan ma̱ kucci vu unusu: uba̱ta̱ u na a tsu paɗa kucci vu ukula̱tosu lo ɗa aa paɗa kucci vu unusu a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. A̱yi ɗa kucci na la'ai akiza. ");
INSERT INTO tsw_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Ganu na cayi kucci'i u ta tama inama'a. U ta tama yi uba̱ta̱ wa akiza, o ukowo wo Oogodo o Uga'asusan. ");
INSERT INTO tsw_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Ili i na biti i ju'wa̱in inama ya̱ yi u to o'wo na akiza, waru na̱ mpasa ma̱ yi n daɓa utugu, a̱ ta̱ za̱'wa̱ utugu'u uba̱ta̱ wa akiza. ");
INSERT INTO tsw_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Reve o ɓoso upondo u ci'in u na a su'wain inama'a. Amma na a su'wan yi ta̱ o upondo wu rumushili o to kongoro yi reve e lece yi na̱ mini. ");
INSERT INTO tsw_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Ulobo suru a̱tsuma̱ o umatsun wa ganu u ta gura tama inama'a, a̱yi ɗa u la'ai akiza. ");
INSERT INTO tsw_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Amma kucci vu unusu u na suru a̱ ta̱wa̱yi na̱ mpasa ma̱ yi o Oogodo o Uga'asusan adama a matara mo ume mo unusu Uba̱ta̱ wa Akiza, a̱ ta̱ kula̱to yi na akina. ");
INSERT INTO tsw_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","<<Apa nda re mayan ma̱ kucci adama a makuɗa ma̱ wila̱. Kucci na la'ai akiza a ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","A ta paɗa ili i na a̱ ta̱wa̱yi kucci adama o unusu'u uba̱ta̱ u na a tsu paɗa kucci vu ukula̱tosu. Reve o kyo'onu mpasa ma̱ yi e eɓele a masa'a'a suru a̱ ka̱nda̱ruwa̱. ");
INSERT INTO tsw_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","A ta ca abaji a mani'in ma̱ yi suru, abaji a mani'in ma wizan na̱ mani'in ma na ma̱ ri uɓoluloi ni iliya̱tsuma̱, ");
INSERT INTO tsw_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","oɓolo na a'ilu e re na abaji a mani'in me ele ma na ma̱ ri zuzu ne eetele e ikyun, nu upasu wa assuvu u na u la'ai ulobonu, za na oo foɗo oɓolo na a'ilu'u. ");
INSERT INTO tsw_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Ganu ta̱ kula̱to le a masa'a'a kucci na a cayi A̱sulazuva va akina, a̱yi ɗa kucci makuɗa ma̱ wila̱. ");
INSERT INTO tsw_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ulobo suru o u'wa wa ganu u ta gura tama yi. A ta tama yi uba̱ta̱ wa akiza. Kucci na la'ai akiza a ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","<<Ure u mayan ma̱ kucci makuɗa ma̱ wila̱ una̱ta̱ u ɗa u ri na̱ za kucci vu unusu. Ganu na yuwain kucci matara mo ume mo unusu u to o'wo ni ili i na i buwai. ");
INSERT INTO tsw_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Waru ganu na yuwain kucci vu ukula̱tosu o una̱ u vuma suru, u to o'wo nu ukwan u kucci vu ukula̱tosu u na u cayi'i. ");
INSERT INTO tsw_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Waru kucci vi ishina na a̱ zatsuyi suru a wuwan oɓolo ni ili i na o raluyi e ebelu o ukangalu ko a ataɗa o ukangalu, u to o'wo za va ganu na yuwan niyi. ");
INSERT INTO tsw_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Amma kucci vi ishina na a̱ ja̱mba̱ra̱i na̱ mani'in ko babu mani'in e te ne'esheen olobo a Haruna una̱ta̱. ");
INSERT INTO tsw_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","<<Apa nda re mayan ma̱ kucci muwwulai na vuma aa gura ta̱wa̱a̱ A̱sulazuva: ");
INSERT INTO tsw_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Nnu u ca yi o una̱ wu ugodyusho, u ta ca emeshen a na a̱ ja̱mba̱ra̱i na̱ mani'in oɓolo no opopofu a na a̱ ri na̱ wolilo shi a na a̱ ja̱mba̱ra̱i na̱ mani'in, no opopofu a yira i lashi i na i ri na̱ wolilo shi i na a̱ ja̱mba̱ra̱i na̱ mani'in ulobonu. ");
INSERT INTO tsw_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Reve u ca akpatali o opopofu a na a̱ ri na̱ wolilo oɓolo na̱ kucci muwwulai. ");
INSERT INTO tsw_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","A̱ kucci'i suru u ta ca aakpatali o opopofu a̱ ta̱ uneꞌe la̱nga̱ e ekere a̱ A̱sulazuva. Opopofu'u o to o'wo za va ganu na kyo'onuyi mpasa n kucci muwwulai'i. ");
INSERT INTO tsw_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Waru a ta tama inama i kucci muwwulai vu ugodyusho'o urana u na a yuwan niyi. Waa lyawa akapi a asa shi. ");
INSERT INTO tsw_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","<<Amma nna̱ kucci na u cayi za vu ushitosun wa akucunu a ɗa ko gba kucci vu ucigu wo okolo a ɗa, a ta tama yi o urana u na a yuwan niyi. Agba akapi a na a buwai a ta gura tama yi nu usana u tawa. ");
INSERT INTO tsw_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Amma nnu u pasa hali o urana wa ta'atsu a̱ ta̱ kula̱to yi. ");
INSERT INTO tsw_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Nna a tama nama kucci muwwulai o urana wa ta'atsu, a̱a̱ ushi kucci va̱ yi shi. Waru aa tara kucci va̱ yi ili i ro shi, adama a na ili yi idaba i ɗa. Za na waru tamai inama'a ume wu unusu u ndolo u ta̱ a aci a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","<<Nama na ju'wa̱in ili yi idaba suru aa tama yi shi. A̱ ta̱ kula̱to yi. Adama e inama gba, za na suru ri cece ta gura tama inama'a. ");
INSERT INTO tsw_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Amma za na suru tamai inama i kucci muwwulai ya̱ A̱sulazuva a̱yi gba u ta̱ idaba, a ta tawa yi a̱tsuma̱ a ama a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Nna̱ vuma ju'wa̱n ili yi idaba, ko za vuma ko za vu nama ko ili yi idaba i ro, reve waru u tama nama na a cayi A̱sulazuva kucci muwwulai, a ta tawa vuma ndolo a̱tsuma̱ a ama a̱ yi.>> ");
INSERT INTO tsw_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","A̱sulazuva a damma ta̱ Musa, ");
INSERT INTO tsw_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","<<Damma aza a Isra'ila, she i tama abaji a mani'in ma nan ko mo kyon ko me megbele wan. ");
INSERT INTO tsw_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Waru she i tama mani'in ma nama na kuwa̱i na aciya̱yi wan, ko gba nama na nama vu una vu unai wan. Amma i ta gura yuwan ili i ro na̱ a̱yi. ");
INSERT INTO tsw_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Za na suru tamai abaji a mani'in ma nama na a cayi A̱sulazuva kucci va akina, a ta tawa yi a̱tsuma̱ a ama a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Waru uba̱ta̱ u na i da̱nuyi suru she i tama mpasa wan, ko za manunu ko za vu nama. ");
INSERT INTO tsw_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Za na suru tamai mpasa, a ta tawa yi a̱tsuma̱ a ama a̱ yi.>> ");
INSERT INTO tsw_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Reve A̱sulazuva a damma Musa, ");
INSERT INTO tsw_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","<<Yuwan adanshi na aza a Isra'ila a na, za na suru ta̱wa̱i na̱ kucci muwwulai e ekere a̱ A̱sulazuva, u ta ca A̱sulazuva upasu u ro u kucci va̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ne ekere a̱ yi a ɗa wa̱a̱ ta̱wa̱a̱ A̱sulazuva na̱ kucci na a yuwain na akina. U ta̱ ta̱wa̱a̱ na abaji a mani'in oɓolo na̱ ma̱ka̱ka̱n, reve u 'ya̱sa̱n ma̱ka̱ka̱'a̱n kucci vu u'ya̱susa̱n a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Ganu ta̱ kula̱to mani'i'in a masa'a, amma ma̱ka̱ka̱'a̱n u to o'wo akunda a Haruna no olobo a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","A ta ca ganu uneꞌe wa aagutsu o usa'ani wa̱ kucci muwwulai'i. ");
INSERT INTO tsw_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","A̱tsuma̱ o olobo a Haruna za na suru cayi mpasa na abaji a mani'in vu kucci muwwulai'i u ta tara aagutsu o usa'ani'i woo o'wo akunda a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Diga a̱ kucci muwwulai va aza a Isra'ila, ma̱ka̱ka̱n ma na suru a̱ 'ya̱sa̱in na aagutsu a na a cayi n tara le ta̱, reve n ca Haruna ganu no olobo a̱ yi wo o'wo akunda e le kuci. ");
INSERT INTO tsw_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","A̱yi nda a̱yi ɗa akunda a̱ kucci va akina na a cayi A̱sulazuva a na a tawayi Haruna no olobo a̱ yi diga o urana u na a tawa nle a yuwan ulinga u tsuganu wa̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Diga o urana u na a̱ tsun nle mani'in, A̱sulazuva a zuwa ta̱ a casu le akunda kuci hali a̱ tyo mantsa me elime.>> ");
INSERT INTO tsw_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ele nda ele ɗa re mayan ma̱ kucci vu ukula̱tosu, na̱ kucci vi ishina na̱ za vu unusu na̱ za makuɗa ma̱ wila̱ na̱ za vu ukatalasa wa ganu, na̱ za muwwulai, ");
INSERT INTO tsw_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","aza a na A̱sulazuva a dammai Musa a Masasan ma Sinai, o urana u na u zuwai aza a Isra'ila a̱ ta̱wa̱a̱ na̱ kucci le a̱ A̱tsumona a Sinai. ");
INSERT INTO tsw_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Reve A̱sulazuva a yuwan adanshi na̱ Musa u damma, ");
INSERT INTO tsw_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","<<Tara Haruna oɓolo no olobo a̱ yi na̱ a̱tugu a tsuganu tse le, na̱ mani'in mo utsusun no oogono a nan a̱ kucci vu unusu na̱ a̱giri'i e re na aasaka o opopofu a na a̱ ri na̱ wolilo shi. ");
INSERT INTO tsw_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Reve vu ɓoloto ama suru o una̱ntsu wo Oogodo o Uga'asusan.>> ");
INSERT INTO tsw_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Reve Musa yuwan cine A̱sulazuva a zuwa niyi u yuwan. Reve ama o ɓoloto o una̱ntsu wo Oogodo o Uga'asusa'an. ");
INSERT INTO tsw_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Ɗaɗa Musa dammai ama'a, <<A̱yi nda a̱yi ɗa ili i na A̱sulazuva a zuwai a yuwan.>> ");
INSERT INTO tsw_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Reve wu uta̱a̱ Haruna no olobo a̱ yi elime, a̱vu u sumba̱ le na̱ mini. ");
INSERT INTO tsw_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Reve wo oto Haruna utugu wu uga'an, reve wu nla̱a̱ yi gbakala e ikyun. A̱vu wo oto yi utugu, na̱ ma̱tugu ma̱ epo. Reve wu nla̱a̱ yi gbakala vu uɗavu wu ukere ulinga wu ɗavi adama u guza̱ yi ulobonu. ");
INSERT INTO tsw_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Reve u sa̱ga̱da̱wa̱ yi oosonu a̱ ma̱ka̱ka̱n, reve u zuwa Urim na̱ Tumim pe. ");
INSERT INTO tsw_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Reve u katala yi ookokolo a tsuganu a aaci. Reve u zuwa ɗe ma̱pa̱ta̱ta̱ ma zinariya ma̱ cin o ookokolo'o, ookokolo a akiza, cine A̱sulazuva a zuwai. ");
INSERT INTO tsw_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Reve Musa tara mani'in mo utsusun reve u tsun a̱a̱'isa̱ ni ili i na i ri pe suru, a̱vu u tawa le oo o'wo na akiza. ");
INSERT INTO tsw_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Reve wu kyo'onu masa'a mani'in toto ucindere. A̱vu u tsuwa̱n masa'a ni itana i na i ri pe suru na aasa'atsu nu ukuruwa̱ta̱ wa̱ yi adama u tawa le oo o'wo na akiza. ");
INSERT INTO tsw_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Reve u tsuwa̱n Haruna mani'in a aaci adama a tawa yi na akiza. ");
INSERT INTO tsw_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Reve Musa ta̱wa̱ no olobo a Haruna a̱vu wo oto le a̱tugu, reve wu nla̱a̱ le igbakala a̱ nkyun n le. Reve wo oto le okokolo a tsuganu, cine A̱sulazuva a zuwai Musa. ");
INSERT INTO tsw_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Reve u ta̱wa̱ no oogono a nan a̱ kucci vu unusu. Reve Haruna no olobo a̱ yi a̱ kuru ekere e le a aaci a na'an. ");
INSERT INTO tsw_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","A̱vu Musa paɗa yi, a̱vu kene mpasa, reve u daɓa mpasa'a na aakatsu a̱ yi u putala yi a avana a masa'a'a adama wo o'woto yi na akiza. Reve u tsun akapi a mpasa'a e ikyun i masa'a'a, a̱vu u tawa yi na akiza adama a matara mo ume mo unusu. ");
INSERT INTO tsw_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","A̱vu Musa foɗo abaji a mani'in ma na ma palai iliya̱tsuma̱ suru nu upasu wa assuvu u na u la'ai ulobonu na a'ilu e re na̱ mani'in me ele, reve u kula̱to le a masa'a'a. ");
INSERT INTO tsw_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Amma a̱vu u kula̱to oogono a na'an nu ukwan wa̱ yi ni inama ya̱ yi na̱ a̱ya̱n a̱ yi o ucina̱ wu uva̱la̱ta̱'a̱, cine A̱sulazuva a zuwa niyi u yuwan. ");
INSERT INTO tsw_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Reve u ta̱wa̱a̱ na̱ a̱a̱giri'i a̱ kucci vu ukula̱tosu. A̱vu Haruna no olobo a̱ yi a̱ kuru ekere e le a aaci a̱ a̱a̱giri'i'i. ");
INSERT INTO tsw_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Ɗaɗa Musa paɗa niyi, reve u kyo'onu mpasa'a e eɓele a masa'a'a suru a̱ ka̱nda̱ruwa̱. ");
INSERT INTO tsw_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Reve wu paɗa a̱a̱giri'i'i mupaɗi mupaɗi, a̱vu u kula̱to aaci oɓolo na̱ mupaɗi'i na̱ mani'in. ");
INSERT INTO tsw_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Reve wu za̱'wa̱ iliya̱tsuma̱ na ana na̱ mini. Reve u kula̱to a̱a̱giri'i'i suru a masa'a'a, kucci vu ukula̱tosu, ili i ma̱guru mo uyo'o, kucci na a yuwayin A̱sulazuva va akina, cine A̱sulazuva a zuwai Musa. ");
INSERT INTO tsw_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Reve u ta̱wa̱ na̱ a̱a̱giri'i e ire, za vu ukatalasa u tsuganu. Reve Haruna no olobo a̱ yi a̱ kuru ekere e le a aaci a̱ a̱a̱giri'i'i. ");
INSERT INTO tsw_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Reve Musa paɗa yi. A̱vu u kene mpasa'a a̱vu u daɓa e lege vu utsuvu vu usa'ani wa Haruna na a aakatsu a gbain o ukere u sa'ani wa̱ yi na a aakatsu a gbain a anana o usa'ani wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Reve u ta̱wa̱ no olobo a Haruna, reve u daɓa mpasa e nlege ma atsuvu o usa'ani e le na a akatsu a gbagbain e ekere a sa'ani e le na a akatsu a gbagbain a ana a sa'ani e le. A̱vu Musa kyo'onu mpasa n na m buwai e eɓele a masa'a'a suru a̱ ka̱nda̱ruwa̱. ");
INSERT INTO tsw_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Reve u tara mani'i'in na̱ wizan u mani'in na abaji a mani'in ma na ma palai iliya̱tsuma̱ suru, nu upasu wa assuvu u na u la'ai ulobonu, na a'ilu e re'e oɓolo na̱ mani'in me le, oɓolo na aagutsu o usa'ani. ");
INSERT INTO tsw_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Diga pe a aasaka o opopofu a na a̱ ri na̱ wolilo shi za na ri a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva, u tara ta̱ oopopofu a̱ ta̱ na̱ za na a yuwain na̱ mani'in ne emeshen. Reve u kuru le a mani'i'in na a aagutsu o usa'ani'i. ");
INSERT INTO tsw_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Reve u zuwa le suru e ekere a Haruna no olobo a̱ yi. Reve a̱ 'ya̱sa̱n le a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva kucci vu u'ya̱susa̱n. ");
INSERT INTO tsw_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Reve Musa tawa le e ekere e le, reve u kula̱to le a masa'a zuva kucci vu ukula̱tosu vu ukatalasa wa tsuganu, ili i ma̱guru mo uyo'o, kucci na a yuwayin A̱sulazuva va akina. ");
INSERT INTO tsw_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Reve Musa tara ma̱ka̱ka̱'a̱n reve u 'ya̱sa̱n yi kucci vu u'ya̱susa̱n e ekere a̱ A̱sulazuva. A̱yi ɗa akunda a Musa a̱ a̱a̱giri'i o ukatalasa wa ganu cine A̱sulazuva a zuwai Musa yuwan. ");
INSERT INTO tsw_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Reve Musa kene mani'in mo utsusun na̱ mpasa n na n ri a masa'a, reve wu kyo'onuwo Haruna na̱ a̱tugu a̱ yi, no olobo a̱ yi waru na̱ a̱ a̱tugu e le. Ne ɗa u tawai Haruna na̱ a̱tugu a̱ yi na akiza oɓolo no olobo a̱ yi na̱ a̱tugu e le. ");
INSERT INTO tsw_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Reve Musa damma Haruna no olobo a̱ yi, <<Su'wain inama'a o una̱ntsu wo Oogodo o Uga'asusan, reve i tama le lo oɓolo no opopofu a na a̱ ri a aasaka a̱ kucci vu ukatalasa cine a̱mu A̱sulazuva n zuwai, a na,<Haruna no olobo a̱ yi a ɗa aa tama le.> ");
INSERT INTO tsw_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Agba ili i na i pasai yi inama no opopofu'u, i kula̱to le. ");
INSERT INTO tsw_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Agba she yu uta̱ o una̱ntsu wo Oogodo o Uga'asusa'an wan rana cindere, hali she na̱ rana vu ukatalasa ɗu koto adama a na rana vu ukatalasa ɗu ta yuwan rana cindere. ");
INSERT INTO tsw_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ili i na a yuwain ana'an, A̱sulazuva a zuwa yi ta̱ adama a matara mo ume mo unusu ma̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","I ta̱ da̱na̱ o una̱ntsu wo Oogodo o Uga'asusan ayin nu usana hali ayin e cindere, a yuwusan ili i na A̱sulazuva a zuwai, adama i kuwa̱ wan. A̱yi ɗa ili i na A̱sulazuva a zuwai.>> ");
INSERT INTO tsw_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Reve Haruna no olobo a̱ yi a yuwan ili i na A̱sulazuva a zuwa nle a yuwan suru cine a uwwai o una̱ wa Musa. ");
INSERT INTO tsw_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","O urana wa̱ kunla̱ u na u kuruyi rana cindere va̱ a̱buki o ukatalasa u tsuganu, reve Musa ɗe Haruna no olobo a̱ yi, na̱ mbara ma aza a Isra'ila. ");
INSERT INTO tsw_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","A̱vu u damma Haruna, <<Taraa aciya̱wu oogono a nan adama a̱ kucci vu unusu, na̱ a̱a̱giri'i adama a̱ kucci vu ukula̱tosu. Suru nle a̱ da̱na̱ usa̱du wan, a̱vu vu ta̱wa̱ ne ele a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Reve vu damma aza a Isra'ila, <Tarai ma̱ga̱ji adama a̱ kucci vu unusu, na̱ ma̱dindim na̱ kyon, suru nle aa'wan a̱ ta̱ ta̱ nu umatsun aza a na a̱ ri usa̱du shi adama a̱ kucci vu ukula̱tosu. ");
INSERT INTO tsw_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Reve waru a̱ ta̱wa̱a̱ no oogono a nan na̱ a̱a̱giri'i adama a̱ kucci muwwulai a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva, na̱ kucci vi ishina i na a̱ ja̱mba̱ra̱i na̱ mani'in, adama a na A̱sulazuva a̱ ta̱ ta̱wa̱ ya̱'a̱ ɗu ana'an.> >> ");
INSERT INTO tsw_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Reve a̱ ta̱wa̱a̱ ni ili i na Musa zuwai elime o Oogodo o Uga'asusan. Reve ama suru a rawa zuzu e isawan a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Reve Musa damma, <<Apa nda ili i na A̱sulazuva a zuwa nɗu i yuwan, adama tsugbain tsa̱ A̱sulazuva tsa̱ ta̱wa̱ ya̱'a̱ ɗu.>> ");
INSERT INTO tsw_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Reve Musa damma Haruna, <<Ta̱wa̱ zuzu na̱ masa'a vu ca kucci vu unusu na̱ kucci vu ukula̱tosu va̱ wu. Vu yuwan kucci matara mo ume mo unusu va aciya̱wu na adama a ama. Reve vu ta̱wa̱a̱ na̱ kucci va ama, vu ca adama a matara mo ume mo unusu me le, cine A̱sulazuva a zuwai.>> ");
INSERT INTO tsw_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Ɗaɗa Haruna rawai zuzu na̱ masa'a'a a̱vu u paɗa ma̱dindim ma̱ kucci vu unusu adama a aciya̱yi. ");
INSERT INTO tsw_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Reve olobo a Haruna a ca yi mpasa'a. Reve u daɓa aakatsu a̱ yi a mpasa, a̱vu u putala yi a avana a masa'a'a. Reve u tsun akapi a mpasa'a e ikyun i masa'a. ");
INSERT INTO tsw_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Amma mani'in na a'ilu nu upasu wa assuvu u kucci vu unusu u kula̱to le ta̱ a masa'a, cine A̱sulazuva a zuwai Musa. ");
INSERT INTO tsw_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Reve u kula̱to inama nu ukwa'an o ucina̱ wu uva̱la̱ta̱. ");
INSERT INTO tsw_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Reve Haruna paɗa kucci vu ukula̱tosu'u. Reve olobo a̱ yi a ca yi mpasa'a, reve wu kyo'onu le e eɓele a masa'a'a suru a̱ ka̱nda̱ruwa̱. ");
INSERT INTO tsw_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Reve a ca yi kucci vu ukula̱tosu mupaɗi mupaɗi oɓolo na aaci, reve u kula̱to le a masa'a'a. ");
INSERT INTO tsw_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Reve wu za̱'wa̱ iliya̱tsuma̱ no okotsu a̱vu u kula̱to le oɓolo na̱ kucci vu ukula̱tosu zuva masa'a'a. ");
INSERT INTO tsw_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Reve Haruna ca kucci va ama, a̱vu u tara megbele adama a̱ kucci vu unusu adama a ama reve u paɗa yi. Reve u yuwan kucci vu unusu na̱ a̱yi tsu za vu ufaru. ");
INSERT INTO tsw_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Reve u ta̱wa̱a̱ na̱ kucci vu ukula̱tosu, reve u yuwan na̱ a̱yi o ure u na a zuwai. ");
INSERT INTO tsw_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Reve u ta̱wa̱a̱ na̱ kucci vi ishina, a̱vu u kene ukere u ta̱, reve u kula̱to yi a masa'a oɓolo na̱ kucci vu ukula̱tosu vu usana. ");
INSERT INTO tsw_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Reve waru Haruna paɗa oogono a nan na̱ a̱a̱giri'i adama a̱ kucci muwwulai adama a ama. Reve olobo a̱ yi a ca yi mpasa, reve wu kyo'onu le e eɓele a masa'a'a suru a̱ ka̱nda̱ruwa̱. ");
INSERT INTO tsw_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Agba mupaɗi ma abaji a mani'in mo oogono ma nan na̱ a̱a̱giri'i na̱ wizan u mani'in na̱ mani'in ma na ma palai iliya̱tsuma̱ na a'ilu nu upasu wa assuvu, ");
INSERT INTO tsw_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","u kuru le ta̱ a̱ nka̱ka̱n mi inama'a, reve u kula̱to mupaɗi m mani'i'in a masa'a'a. ");
INSERT INTO tsw_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Amma reve Haruna ca kucci vu u'ya̱susa̱n vu nka̱ka̱n na agutsu o usa'ani'i a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva, cine Musa zuwai a yuwan. ");
INSERT INTO tsw_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Reve Haruna 'ya̱sa̱n ekere a̱ yi a̱ tyo uba̱ta̱ wa ama, a̱vu u zuwaa le aba'un. Reve ana u kotoi ucasu u kucci vu unusu na̱ kucci vu ukula̱tosu, na̱ kucci muwwulai, reve u cipa̱ diga uba̱ta̱ u masa'a'a. ");
INSERT INTO tsw_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","A̱vu Musa na̱ Haruna a uwa a̱tsuma̱ o Oogodo o Uga'asusan. Ana o uta̱i reve a zuwaa ama aba'un. Ɗaɗa tsugbain tsa̱ A̱sulazuva tsa̱ ta̱wa̱i uba̱ta̱ wa ama suru. ");
INSERT INTO tsw_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Reve akina o uta̱ uba̱ta̱ wa̱ A̱sulazuva, reve u tama kucci vu ukula̱tosu na abaji a mani'in a na a̱ ri a masa'a'a. Ana ama suru e ene niyi, reve o oruwo na̱ ma̱za̱nga̱. A̱vu a̱ riya̱ ma̱kpa̱ɓa̱. ");
INSERT INTO tsw_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadab na̱ Abihu olobo a Haruna, za suru tara ta̱ aayimba a akina a̱ yi, u tsun akina pe a̱vu u kula̱to a̱tsuka̱ pe. Reve a ca A̱sulazuva akina a na o lobonoi shi, cu'un na u zuwa nle a̱ ta̱wa̱a̱ shi. ");
INSERT INTO tsw_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Ɗaɗa akina o uta̱i uba̱ta̱ wa̱ A̱sulazuva, a̱vu u kula̱to le. A̱vu a̱ kuwa̱ a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Reve Musa damma Haruna, <<Apa nda ili i na A̱sulazuva a dammai, <Uba̱ta̱ wa aza a na a̱ ri zuzu na̱ a̱mu a ta tara mu na akiza, waru a ta ca mu tsugbain e esu a ama suru.> >> Haruna gba isawan ta̱ kuci kuci. ");
INSERT INTO tsw_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Reve Musa ɗe Mishe na̱ Elizafan olobo a Uziye dada ke'en va Haruna, a̱vu u damma le, <<Rawai zuzu i pura̱ a̱za̱ a̱ ɗu o uta̱ a alanga a̱ a̱a̱'isa̱ a̱ tyo o ucina̱ wu uva̱la̱ta̱.>> ");
INSERT INTO tsw_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Reve a rawa zuzu a tanu le a̱tsuma̱ a̱ a̱tugu e le o uta̱ a̱ tyo o ucina̱ o uva̱la̱ta̱, cine Musa zuwai. ");
INSERT INTO tsw_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Reve Musa damma Haruna no olobo a̱ yi Eliyaza na̱ Itama, <<She i lyawa a̱nji a̱ ɗu ukacaru wan, waru she yi kara a̱tugu a̱ ɗu wan ta̱wa̱ i kuwa̱ wan, reve i ronoo ama upan wa̱ A̱sula̱. Amma i lyawa a̱za̱ a̱ ɗu, u'wa wa Isra'ila suru e showen aza a na A̱sulazuva a̱ kula̱toi. ");
INSERT INTO tsw_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Waru she yu uta̱ o una̱ntsu wo Oogodo o Uga'asusan wan, ta̱wa̱ i kuwa̱ wan, adama a na mani'in mo utsusun ma̱ A̱sulazuva ma̱ ta aci a̱ ɗu.>> Reve gba a yuwan cine Musa dammai. ");
INSERT INTO tsw_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","A̱vu A̱sulazuva a damma Haruna, ");
INSERT INTO tsw_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","<<Na̱ a̱vu no olobo a̱ wu she i sowo masayan ma̱ ina̱bi ko ili yo oso i na i tsu tsura̱to wan, a mantsa ma na suru yaa uwa o Oogodo o Uga'asusan, adama i kuwa̱ wan. A̱yi nda u to o'wo ili i mayan kuci hali a̱ tyo mantsa suru. ");
INSERT INTO tsw_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Ni i ciga i 'yuwan yi kasa ili i na a tawai na akiza ni ili ya ndana, ni ili yi idaba ni ili i cece. ");
INSERT INTO tsw_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Waru ni i ciga i 'yuwan i rito ama a Isra'ila suru wila̱ u na A̱sulazuva a cayi e ekere a Musa.>> ");
INSERT INTO tsw_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa gba yuwan ta̱ adanshi na̱ Haruna na akapi o olobo a̱ yi, Eliyaza na̱ Itama u damma, <<Tarai kucci vi ishina i na i pasai a̱ kucci na a cayi A̱sulazuva va akina, reve i lyuwa yi a̱ nge'en m masa'a babu wolilo, adama a na u ta̱ na akiza lon. ");
INSERT INTO tsw_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","I lyuwa yi uba̱ta̱ wa akiza, adama a na akunda a̱ wu a ɗa na̱ za vo olobo a̱ wu a̱ kucci na cayi A̱sulazuva va akina, adama a na ne ɗa a zuwa numu n yuwan. ");
INSERT INTO tsw_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Agba na̱ a̱vu no olobo a̱ wu oɓolo ne esheli a̱ wu i ta tama ma̱ka̱ka̱n ma̱ kucci ma na a̱ 'ya̱sa̱in na aagutsu a na a cayi, i tama le uba̱ta̱ u na u ri cece. A ca wu ele ta̱ akunda a̱ wu a ɗa na̱ a̱vu no olobo a̱ wu ne esheli a̱ wu diga a̱ kucci muwwulai va aza a Isra'ila. ");
INSERT INTO tsw_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Aagutsu a na a cayi na̱ ma̱ka̱ka̱n ma na a̱ 'ya̱sa̱i'in a̱ ta̱ ta̱wa̱ ne ele oɓolo na abaji a mani'in ma na a cayi va akina, a̱a̱ 'ya̱sa̱n yi a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva tsa̱ kucci vu u'ya̱susa̱n. O to o'wo akunda a̱ wu na̱ a̱vu no olobo a̱ wu kuci, cine A̱sulazuva a zuwai.>> ");
INSERT INTO tsw_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Ana Musa ecei adama e megbele ma na a cayi adama a̱ kucci vu unusu, a̱vu u cina a̱ kula̱to yi ta̱ ɗe. Reve u yuwan upan na̱ Eliyaza na̱ Itama olobo a Haruna a na a buwai, a̱vu we ece, ");
INSERT INTO tsw_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","<<Adama a̱ nye i tamai kucci vu unusu'u a̱ a̱a̱'isa̱ shi? Kucci va akiza lon ɗa, waru a ca ɗu ta̱ ele adama a tawa unusu wa ama a tara ume wu unusu u le a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ana wo o'woi aa tara mpasa ma̱ yi a uwa Uba̱ta̱ wa Akiza shi, u shi to o lobono i tama inama'a a̱tsuma̱ a̱ a̱a̱'isa̱ cine n zuwai.>> ");
INSERT INTO tsw_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Reve Haruna usu Musa, <<Uwwa nda, ana'an ɗa a cayi kucci le adama o unusu na̱ kucci le vu ukula̱tosu a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva, agba suru na̱ ne a̱vu ili i nda i fara na̱ a̱mu! Nna̱ n shi n tama kucci vu unusu ana'an, A̱sulazuva a̱ shi ta̱ a uwwa uyo'o va̱?>> ");
INSERT INTO tsw_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Ana Musa uwwai ili i nda, wu uwwa ta̱ uyo'o wi ili'i. ");
INSERT INTO tsw_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Reve A̱sulazuva a yuwan adanshi na̱ Musa na̱ Haruna u damma le, ");
INSERT INTO tsw_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","<<Yuwain adanshi na ama a Isra'ila a na, a̱tsuma̱ e inama i na i ri o uvaɗi suru, apa nda aza a na yaa gura tama: ");
INSERT INTO tsw_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Nama na suru ookotsu a̱ yi a ɓatsalai, waru u tsu ka̱mbuwisa̱ ta̱ utamu, i ta gura tama yi. ");
INSERT INTO tsw_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Suru na̱ ne a̱tsuma̱ a aza a na a̱ tsu ka̱mbuwisa̱ utamu, ko a̱ ri no okotsu e le uɓatsulai ya tama ele nda shi: Yaa tama arakumi shi ko a na u tsu ka̱mbuwisa̱ utamu, okotsu a̱ yi a̱ ri uɓatsulai shi. Ili yi idaba i ɗa e ekere a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Magima, ko a na u tsu ka̱mbuwisa̱ utamu, okotsu a̱ yi a̱ ri uɓatsulai shi. Ili yi idaba i ɗa e ekere a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Mozomu waru, ko a na u tsu ka̱mbuwisa̱ utamu, okotsu a̱ yi a̱ ri uɓatsulai shi. Ili yi idaba i ɗa e ekere a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ma̱gurusumu waru, ko a na u ri no okotsu uɓatsulai u tsu ka̱mbuwisa̱ utamu shi, ili yi idaba i ɗa e ekere a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","She i tama inama i le wan, agba she i ju'wa̱in a̱kwa̱kwa̱ e le wan, ili yi idaba i ɗa e ekere a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","<<A̱tsuma̱ e ili i na i ri a̱ mini suru ko a mala ko o ɗolu, i ta gura tama ili i na i ri na̱ a̱ka̱ɓa̱ na̱ a̱fa̱ɓa̱ a̱ lipu. ");
INSERT INTO tsw_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Amma ili i wuma i na i ri a mala ko o ɗolu suru, agba u ri na̱ a̱ka̱ɓa̱ ko a̱fa̱ɓa̱ a̱ lipu shi, ili yi idaba i ɗa e ekere a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","I tara le ili yi idaba, she i tama inama i le wan. A̱kwa̱kwa̱ e le waru o o'wo ili yi idaba e ekere a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Ili i na suru i ri a̱ mini agba u ri na̱ a̱ka̱ɓa̱ ko a̱fa̱ɓa̱ shi, ili yi idaba i ɗa e ekere a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","<<Apa nda icu'un yi nnunu n na yaa tara ili yi idaba, yaa tama le shi, ili yi idaba i ɗa: a̱a̱kuru na aasala na amikiya ");
INSERT INTO tsw_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","na aajimba na̱ cu'un va aajimba suru, ");
INSERT INTO tsw_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","na̱ cu'un va aakakan suru, ");
INSERT INTO tsw_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","na azamina, na̱ vori na̱ papagula ni icu'un i le suru, ");
INSERT INTO tsw_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","na̱ vori ke'en na̱ mecivecive na̱ a̱a̱pa̱mu, ");
INSERT INTO tsw_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","na̱ mototon na̱ ma̱gba̱shimo na aasala e ke'en, ");
INSERT INTO tsw_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","na aashamuwa na̱ cu'un va atakuba suru, na̱ a̱a̱burutu no oogyon. ");
INSERT INTO tsw_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","<<Mubumbu n na ri ne evelu aza a na a tsu wala na ana a̱ na̱shi suru, ili yi idaba i ɗa e ekere a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Amma i ta gura tama mubumbu n na n ri ne evelu aza a na a tsu wala na ana a̱ na̱shi aza a na a̱ ri na agutsu a na a tsu zuwa le a gura 'yawan. ");
INSERT INTO tsw_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","I ta gura tama cu'un va aapapari biti, na̱ cu'un vu jon suru na̱ cu'un va akyun suru. ");
INSERT INTO tsw_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Amma akapi a̱ mubumbu n na n ri ne evelu na ana a̱ na̱shi suru ili yi idaba i ɗa e ekere a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","<<Ili i nda i ta zuwa ɗu yoo o'wo idaba. Za na suru ju'wa̱in a̱kwa̱kwa̱ e le u to o'wo idaba hali she ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Waru za na suru tarai a̱kwa̱kwa̱ a za ta̱ a̱tsuma̱ e le, u ta̱ za̱'wa̱ a̱tugu a̱ yi, agba u to o'wo idaba hali she ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","<<Nama na suru ookotsu a̱ yi a ɓatsalai shi, waru u tsu ka̱mbuwisa̱ utamu shi ili yi idaba i ɗa e ekere a̱ ɗu. Za na suru ju'wa̱in a̱kwa̱kwa̱ a za ta̱ le u to o'wo idaba. ");
INSERT INTO tsw_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","A̱tsuma̱ e inama i na i ri na ana a̱ na̱shi suru, aza a na a tsu wala na apata a ana, ili yi idaba i ɗa e ekere a̱ ɗu. Za na suru ju'wa̱in a̱kwa̱kwa̱ e le u to o'wo idaba hali ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Waru za na suru sheɗei a̱kwa̱kwa̱ e le u ta̱ za̱'wa̱ a̱tugu a̱ yi, agba u to o'wo idaba hali ulivu. Ili yi idaba i ɗa a̱ ri e ekere a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","<<A̱tsuma̱ e inama i na i tsu ka̱ta̱pa̱ e iɗa, apa nda aza a na oo o'wo idaba e ekere a̱ ɗu: ashan na̱ a̱a̱ga̱ɗa̱ na̱ cu'un va aagada a gbain suru, ");
INSERT INTO tsw_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","na̱ mopolyo'o na̱ kuna̱ na̱ ga̱ngu na̱ meruweruwen na aakanla. ");
INSERT INTO tsw_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ele nda ili yi idaba i ɗa e ekere a̱ ɗu a̱tsuma̱ e ili i na i tsu ka̱ta̱pa̱ e iɗa. Za na suru ju'wa̱in a̱kwa̱kwa̱ e le u to o'wo idaba hali she ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Waru ili i na a̱kwa̱kwa̱ e le a̱ riya̱yi suru u to o'wo idaba, ko ni ili i na a yuwain na akpata a ɗa, ko umuna ko ukwan ko a̱buhu, cu'un vi ili i na aa yuwusan ulinga na̱ a̱yi, a̱ ta̱ tsupu yi a̱ mini. Waru u ta̱ da̱na̱ idaba hali she ulivu, reve wo o'wo cece. ");
INSERT INTO tsw_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Na̱ za ro a̱tsuma̱ e le riya̱ o upondo u ci'in, ili i na i ri pe suru u to o'wo idaba. I ta̱ gba o ɓoso upondo'o. ");
INSERT INTO tsw_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ilyalya ya alya suru, i na mini mo upondo'o ma̱ ju'wa̱in, u to o'wo idaba. Ili yo oso suru yu upondo u ndolo u to o'wo idaba. ");
INSERT INTO tsw_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Ili i na suru a̱kwa̱kwa̱'a̱ a̱ riya̱yi u to o'wo idaba. Ko na̱ shi elele a ɗa ko uba̱ta̱ wu uzusun wo opopofu u ɗa i to ɓoso yi. Ili yi idaba i ɗa, waru o to o'wo ili yi idaba e ekere a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Agba suru na̱ ne, na̱ a̱kwa̱kwa̱ a̱ cu'un vu nama ndolo riya̱ a̱ lyusu mini ko o ooko'o, a̱ ta̱ da̱na̱ cece. Amma za na suru ju'wa̱in a̱kwa̱kwa̱'a̱ a̱tsuma̱ e le u to o'wo idaba. ");
INSERT INTO tsw_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Agba ko na̱ a̱kwa̱kwa̱'a̱ u riya̱a̱ icu'un, icu'u'un a ta buwa cece. ");
INSERT INTO tsw_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Agba n ne e re'weto ta̱ icuꞌuꞌun reve a̱kwa̱kwa̱'a̱ a̱ riya̱a̱ le, ili yi idaba i ɗa e ekere a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","<<Nna̱ nama na a lyawa nɗu i tama kuwa̱, za na suru ju'wa̱in a̱kwa̱kwa̱'a̱ u to o'wo idaba hali she ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Za na suru tamai a̱kwa̱kwa̱'a̱ u ta̱ za̱'wa̱ a̱tugu a̱ yi, waru u to o'wo idaba hali she ulivu. Waru za na suru tanuyi a̱kwa̱kwa̱'a̱ u ta̱ za̱'wa̱ a̱tugu a̱ yi, reve waru wo o'wo idaba hali she ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","<<Ili i wuma i kekeꞌen i na suru i ri e ika̱ta̱pu e iɗa biti ili yi idaba i ɗa, yaa tama le shi. ");
INSERT INTO tsw_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Ili i na biti i tsu sa̱ɓa̱ru a̱tsuma̱ ko ili i na i tsu wala na ana a̱ na̱shi, ko ili i na i ri na ana a̱ a̱bunda̱, ili i na i tsu sa̱ɓa̱ru e iɗa suru yaa tama yi shi adama a na ili yi idaba i ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","She yoo o'woto aciya̱ɗu ili i tsugya ni ili i na ya̱a̱ sa̱ɓa̱rusu wan. Waru she i ka̱mba̱to aciya̱ɗu ili yi idaba adama e le wan, ko a zuwa ɗu yo o'wo idaba wan. ");
INSERT INTO tsw_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","A̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu. Adama o ndolo i tawa aciya̱ɗu yo o'wo na akiza, adama a na a̱mu za va akiza ɗa. She yo o'woto aciya̱ɗu idaba ni ili i na i tsu sa̱ɓa̱ra̱ e iɗa wan. ");
INSERT INTO tsw_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","A̱mu ɗa A̱sulazuva za na uta̱a̱ nɗu diga e iɗa ya Masar adama mo o'wo A̱sula̱ a̱ ɗu. Adama o ndolo, yo o'wo na akiza, adama a na a̱mu za va akiza ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","<<A̱yi nda wila̱ u ɗa adama e inama suru na̱ nnunu ni ili i wuma i na i ri a̱ mini suru na̱ cu'un vi ili i wuma i na i tsu sa̱ɓa̱ra̱ e iɗa. ");
INSERT INTO tsw_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Yi kasa ili yi idaba ni ili i na i ri cece, ni ili i wuma i na waru aa tama ni ili i wuma i na aa tama shi.>> ");
INSERT INTO tsw_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Reve A̱sulazuva a yuwan adanshi na̱ Musa u damma, ");
INSERT INTO tsw_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","<<Yuwan adanshi na ama a Isra'ila a na: nna̱ ka yuwan a̱a̱tsuma̱ reve u matsan ulobo, u to o'wo idaba rana cindere, tsa mantsa ma̱ a̱shinda̱ ma̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Reve o urana wa̱ kunla̱ a paɗa ulobo'o uryumbu. ");
INSERT INTO tsw_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","U ta lyuwa elime a̱tsuma̱ a̱ a̱shinda̱ a limatan hali rana mata'atsu na aza a ta'atsu rana vu usumbu va̱ yi. A̱tsuma̱ a mantsa ma nda wa̱a̱ ju'wa̱n ili ya akiza shi, ko u ta̱wa̱ a̱ a̱a̱'isa̱ shi, she na̱ rana vu usumbu va̱ yi koto. ");
INSERT INTO tsw_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Agba nu u mantsa usheli, u to o'wo idaba hali ajuma e re, tsa mantsa ma̱ a̱shinda̱ ma̱ yi. U ta lyuwa elime a̱tsuma̱ a̱ a̱shinda̱'a̱ hali rana kupota̱li na̱ a̱za̱ a̱ ta̱li, she na̱ rana vu usumbu va̱ yi koto. ");
INSERT INTO tsw_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","<<A mantsa ma na rana vu usumbu va̱ yi kotoi, ko vu umatsun wu ulobo ko usheli, reve u ta̱wa̱a̱ ganu na̱ ma̱giri'i ma aa'wan a̱ ta̱ o una̱ntsu wo Oogodo o Uga'asusan adama a̱ kucci vu ukula̱tosu, na̱ ma̱ma̱rukuku ko muɗa adama a̱ kucci vu unusu. ");
INSERT INTO tsw_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Reve ganu'u ca A̱sulazuva ele adama a̱ kucci matara mo ume mo unusu ma ka'a. Reve wo o'wo cece diga a mpasa n na mo oco niyi. A̱yi ɗa wila̱ wu ka na matsain mawun, ko ulobo ko usheli. ");
INSERT INTO tsw_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Agba na̱ wa̱a̱ tsura̱ ma̱giri'i shi, u ta̱wa̱ na̱ muɗa n re ko murukuku n re za ta̱ adama a̱ kucci vu ukula̱tosu za ta̱ waru adama a̱ kucci vu unusu. Ne ɗa ganu aa ca kucci matara mo ume mo unusu wa̱ yi, u ta̱ gba o'wo cece.>> ");
INSERT INTO tsw_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","A̱sulazuva a yuwan ta̱ adanshi na̱ Musa na̱ Haruna u damma, ");
INSERT INTO tsw_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","<<Na̱ vuma ri na atsutsu o ukwan u lipu va̱ yi, ko ikavuru ko mɓa̱la̱ ma abasa, reve u ka̱mba̱ mɓa̱la̱ n wuya mu ukwan u lipu, a̱ ta̱ ta̱wa̱ na̱ a̱yi uba̱ta̱ wa ganu Haruna ko uba̱ta̱ wu ulobo u ta̱ a̱tsuma̱ o olobo a Haruna ganu. ");
INSERT INTO tsw_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Ganu'u u ta̱ ka̱lyuwa̱ mɓa̱la̱ mu ukwan u lipu va̱ yi. Reve ne eleme a na a̱ ri uba̱ta̱ a̱ mɓa̱la̱'a̱ a̱ ka̱mba̱ u'uri, a̱vu mɓa̱la̱'a̱ n yuwan a̱ru'un u la'a a̱ru'un o ukwan u lipu va̱ yi, mɓa̱la̱ n vama n ɗa. Na̱ ganu ka̱lyuwa̱ yi u ta damma u ta̱ idaba. ");
INSERT INTO tsw_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Agba nna abasa a na a̱ ri a̱ lipu va̱ yi'i u ta̱ u'uri reve wo o'wo u ka̱ra̱ ukwan u lipu shi, waru eleme a na a̱ ri pe a̱ ka̱mba̱ u'uri shi, ganu ta̱ ɓa̱ru vuma vu mɓa̱la̱'a̱ ayin e cindere a̱yi a̱ nde'en. ");
INSERT INTO tsw_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","O urana we cindere ganu ta̱ ka̱lyuwisa̱ yi, reve ne e yeni ya̱ yi mɓa̱la̱'a̱ koto u bala o ukwan u lipuꞌu shi, reve u da̱shi ɓa̱ru yi ayin e cindere o ro a̱yi a̱ nde'en. ");
INSERT INTO tsw_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","O urana we cindere reve ganu ka̱lyuwisa̱ yi waru. Reve nnu upasu u na mɓa̱la̱'a̱ n ri u teme a̱ fa̱ɓusa̱ agba mɓa̱la̱'a̱ m bala o ukwa'an shi, reve ganu'u u damma u ta̱ cece, ikavuru i ɗa goon. Reve vuma'a wu za̱'wa̱ a̱tugu a̱ yi wo o'wo cece. ");
INSERT INTO tsw_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Agba nni ikavuru'u i bala o ukwan u lipu cina ɗe u roco aciya̱yi ya ganu adama ganu damma u ta̱ cece, u ta̱ ta̱wisa̱ ya ganu waru. ");
INSERT INTO tsw_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Ganu ta̱ ka̱lyuwa̱ yi, reve ni ikavuru'u i bala o ukwan, u ta damma u ta̱ idaba, mɓa̱la̱ mu ukutu n ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","<<A mantsa ma na nanza ri na̱ mɓa̱la̱ n vama mu ukwan u lipu, a̱ ta̱ ta̱wa̱ na̱ a̱yi uba̱ta̱ wa ganu. ");
INSERT INTO tsw_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Ganu ta̱ ka̱lyuwa̱ yi. Nna̱ we ene utsutsu u u'uri o ukwan u na u ka̱mba̱toi eleme o uba̱ta̱'a̱ u'uri, waru nna̱ wuntsu wu lo o utsutsu'u, ");
INSERT INTO tsw_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","mɓa̱la̱ mu ukutu n ɗa. Ganu ta damma u ta̱ idaba. Wa̱a̱ ɓa̱ru yi shi adama a na wo o'wo ta̱ ɗe idaba. ");
INSERT INTO tsw_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Agba nna̱ mɓa̱la̱'a̱ m ɓa̱ru lipu va̱ yi suru diga a aaci a̱ tyo a ana cine ganu aa gura ene, ");
INSERT INTO tsw_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ganu'u u ta̱ ka̱lyuwa̱ yi. Reve nna̱ mɓa̱la̱'a̱ n ta̱ɓa̱luwa̱ a̱ lipu hali u ɓa̱ru lipu va̱ yi suru, ganu'u u ta damma u ta̱ cece, a na wo o'woi u'uri suru, u ta̱ cece. ");
INSERT INTO tsw_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Amma a mantsa ma na wuntsu u sa'avu wu uta̱i a̱ lipu va̱ yi, u to o'wo idaba. ");
INSERT INTO tsw_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Ganu'u u ta̱ ka̱lyuwa̱ wuntsu'u, reve u damma u ta̱ idaba. Wuntsu ili yi idaba i ɗa, adama a na mɓa̱la̱ mu ukutu n ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Amma nna̱ wuntsu'u u ka̱mbisa̱ u'uri, za vu mɓa̱la̱'a̱ u ta̱ ka̱mba̱ ya ganu. ");
INSERT INTO tsw_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Reve ganu'u u ka̱lyuwa̱ yi. Reve nna̱ wuntsu'u u ka̱mba̱ u'uri, reve u damma za vu mɓa̱la̱'a̱ u ta̱ cece, reve wo o'wo cece. ");
INSERT INTO tsw_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","<<Nna̱ vuma ri na aamicin a̱ lipu va̱ yi, reve wi ina, ");
INSERT INTO tsw_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","nu uba̱ta̱ u na aamici'in u shi, utsutsu wa abasa a̱ u'uri o uta̱ lo ko abasa a sawun sawun, reve u roco ganu. ");
INSERT INTO tsw_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Ganu ta̱ ka̱lyuwa̱ uba̱ta̱'a̱ nnu u yuwan a̱ru'un za̱la̱ vu ukwan u lipu, reve waru eleme o uba̱ta̱'a̱ a̱ ka̱mba̱ u'uri, ganu'u u ta damma u ta̱ idaba. Mɓa̱la̱ mu ukutu n ɗa m ɓosoi aamicin. ");
INSERT INTO tsw_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Agba nna̱ ganu ka̱lyuwa̱ yi agba u ri ne eleme a̱ u'uri shi, waru u la'a ukwan u lipu a̱ru'un shi, waru u kporo ta̱, ganu ta̱ ɓa̱ru yi hali rana cindere. ");
INSERT INTO tsw_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Amma nnu u bala o ukwan, ganu ta damma u ta̱ idaba. Ukutu u ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Amma nna abasa'a e isawan uba̱ta̱ u ta̱ agba u baza shi, alana a amicin a ɗaɗa, ganu ta damma u ta̱ cece. ");
INSERT INTO tsw_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","<<Ko gba nna̱ vuma ri na̱ wukulu a̱ lipu va̱ yi, reve inama i wukulu'u yo o'wo u'uri sawun sawun ko abasa a̱ u'uri, ");
INSERT INTO tsw_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ganu ta̱ ka̱lyuwa̱ yi. Reve nne eleme a abasa'a a̱ ka̱mba̱ u'uri a̱vu u la'a ukwan u lipu a̱ru'un, to, mɓa̱la̱ mu ukutu n ɗa n na m ɓosoi uba̱ta̱ u wukulu. Reve ganu damma u ta̱ idaba, adanshi a̱ mɓa̱la̱ mu ukutu n ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Amma nna̱ ganu ka̱lyuwa̱ yi agba eleme a̱ u'uri o lo a abasa'a shi waru u la'a ukwan u lipu a̱ru'un shi, amma u fa̱ɓa̱ ta̱, ganu ta̱ ɓa̱ru yi hali rana cindere. ");
INSERT INTO tsw_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Reve ganu ka̱lyuwisa̱ yi o urana we cindere. Na̱ waa balasa o ukwan, reve ganu damma u ta̱ idaba. Adanshi a̱ mɓa̱la̱ mu ukutu n ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Agba nna abasa'a e isawan uba̱ta̱ u ta̱ u bala o ukwan shi agba u fa̱ɓa̱ ta̱, utsutsu u ɗa a̱ wukulu. Ganu ta damma u ta̱ cece, aalana a̱ wukulu a ɗa goon. ");
INSERT INTO tsw_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","<<Na̱ vali ko ka ri na̱ mɓa̱la̱ a aaci ko e ilegu, ");
INSERT INTO tsw_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ganu ta̱ ka̱lyuwa̱ mɓa̱la̱'a̱. Reve nnu u la'a ukwan u lipu a̱ru'un, eleme o uba̱ta̱'a̱ waru a̱ ta̱ mini ma tsusumba waru babu ugba̱mu, reve ganu damma u ta̱ idaba. Ikavuru i ɗa, mɓa̱la̱ n vama mu ukwan n ɗa va aaci ni ilegu. ");
INSERT INTO tsw_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Amma nna̱ ganu ka̱lyuwa̱ mɓa̱la̱ mi ikavuru'u agba u ka̱ra̱ a̱ru'un o ukwan shi, waru u ri ne eleme a̱ lima̱ shi, ganu ta̱ ɓa̱ru za vu mɓa̱la̱'a̱ hali ayin e cindere. ");
INSERT INTO tsw_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Reve o urana we cindere ganu ka̱lyuwisa̱ mɓa̱la̱'a̱. Nna̱ mɓa̱la̱'a̱ m bala shi, waru u ri ne eleme a̱ mini ma tsusumba shi, waru ikavuru'u u ka̱ra̱ a̱ru'un o ukwan shi, ");
INSERT INTO tsw_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","to, u ta puna aaci'i, agba waa puna uba̱ta̱ e ikavuru'u shi. Reve ganu da̱shi ɓa̱ru yi ayin e cindere o ro. ");
INSERT INTO tsw_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Reve o urana we cindere ganu ka̱lyuwisa̱ ikavuru'u, reve nnu u bala o ukwan u lipu shi waru u ka̱ra̱ a̱ru'un o ukwan shi, ganu'u u ta damma u ta̱ cece. Reve wu za̱'wa̱ a̱tugu a̱ yi wo o'wo cece. ");
INSERT INTO tsw_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Agba ni ikavuru'u i bala o ukwan u lipuꞌu cina a damma u ta̱ cece, ");
INSERT INTO tsw_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","reve ganu ka̱lyuwisa̱ yi, a̱vu ni ikavuru'u i bala o ukwan, ganu'u waa zami eleme a̱ mini ma tsusumba waru shi, u ta̱ idaba. ");
INSERT INTO tsw_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Agba nne e yeni ya̱ yi ikavuru'u i vadala shi, waru eleme a̱ lima̱ o uta̱ ta̱ pe, ikavuru'u i koto ta̱, waru wo o'wo ta̱ cece. Ganu ta damma u ta̱ cece. ");
INSERT INTO tsw_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","<<Na̱ vali ko ka ri na abasa a̱ u'uri a̱ lipu va̱ yi, ");
INSERT INTO tsw_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ganu ta̱ ka̱lyuwa̱ yi. Reve na abasa'a a̱ ri uryoryo, muboto n ɗa mu uta̱i o ukwan, u ta̱ cece. ");
INSERT INTO tsw_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","<<Na̱ a̱nji a aaci a vuma o oco, reve wo o'wo nu ukparu, u ta̱ cece. ");
INSERT INTO tsw_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Na̱ a̱nji a̱ cin vuma ɗa o ocoi reve wo o'wo nu ukparu wu cin, u ta̱ cece. ");
INSERT INTO tsw_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Agba nna̱ mɓa̱la̱ n shili uryoryo mu ɗe o ukparu wa aaci'i ko a̱ cin, mɓa̱la̱ n vama mu ukwan n ɗa mu uta̱i a aaci ko a̱ cin va̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Reve ganu ka̱lyuwa̱ yi, nna̱ utsutsu wu mɓa̱la̱'a̱ u tu ushili uryoryo o ukparu wa aaci a̱ yi ko a̱ cin, tsu mɓa̱la̱ mu ukutu, ");
INSERT INTO tsw_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","to, vuma'a u ta̱ nu ukutu, waru u ta̱ idaba. Na a ciga a 'yuwan ganu damma u ta̱ idaba, adama a na u ri nu ukutu a aaci. ");
INSERT INTO tsw_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","<<Za vu cu'un vu mɓa̱la̱ n ndolo, to oto akari a̱ a̱tugu, reve u lyawa a̱nji a̱ yi za̱kpa̱kpa̱. Reve u ɓa̱ru urewesu wa̱ yi za̱la̱ vunu reve u saala, <N ta̱ idaba, N ta̱ idaba!> ");
INSERT INTO tsw_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Mantsa ma na u ri na̱ mɓa̱la̱'a̱ suru, u ta̱ da̱na̱ idaba. U ta̱ da̱nu a̱ nde'en. Uba̱ta̱ a̱ nden ma̱ yi u to o'wo o ucina̱ wu uba̱ta̱ o uva̱la̱ta̱. ");
INSERT INTO tsw_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","<<Na̱ a̱ tsura̱ mɓa̱la̱ mu upa̱luwusa̱ o utugu, ko utugu wu uɗavu ko okoro, ");
INSERT INTO tsw_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ko ili yu uɗavu ko o okoro ko o ukwan ko a̱ cu'un vi ili i na biti a yuwain nu ukwan, ");
INSERT INTO tsw_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","na̱ mɓa̱la̱'a̱ n ta̱ mini ma̱ a̱vu'un ko ushili o utugu'u, ko o ukwa'an ko o uɗavu ko o okoro, ko a̱ cu'un vi ili i na a yuwain nu ukwa'an biti, adanshi a̱ mɓa̱la̱ mu upa̱luwusa̱ u ɗa, o to roco ganu a̱yi. ");
INSERT INTO tsw_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Ganu ta̱ ka̱lyuwa̱ mɓa̱la̱'a̱, reve u ɓa̱ru ili i na i ri na̱ mɓa̱la̱'a̱ hali rana cindere. ");
INSERT INTO tsw_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Reve u ka̱lyuwisa̱ mɓa̱la̱'a̱ o urana we cindere. Na̱ mɓa̱la̱'a̱ n bala o utugu ko o uɗavu ko o ukwan ko a̱ cu'un vi ili i na a yuwain nu ukwan biti, mɓa̱la̱'a̱ mɓa̱la̱ m mona ma ɗa, ili'i wo o'wo ta̱ idaba. ");
INSERT INTO tsw_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","U ta̱ kula̱to utugu'u, ko za vu uɗavu ko ukwan ko cu'un vi ili i na a yuwain nu ukwan biti, i na i la̱nga̱i na̱ a̱yi, adama a na mɓa̱la̱ m mona ma ɗa. A̱ ta̱ kula̱to le a akina. ");
INSERT INTO tsw_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","<<Agba na̱ ganu ka̱lyuwa̱ a̱vu mɓa̱la̱'a̱ n bala o utugu'u shi, ko a za vu uɗavu ko o ukwan ko a̱ cu'un vi ili i na a yuwain nu ukwan biti, ");
INSERT INTO tsw_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","reve u zuwa a̱ za̱'wa̱ ili i na mɓa̱la̱'a̱ n ri ɗe. Reve u ɓa̱ru ili'i hali rana cindere waru. ");
INSERT INTO tsw_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Na̱ a̱ za̱'wa̱ uba̱ta̱ u na ri na̱ mɓa̱la̱'a̱, reve ganu ka̱lyuwa̱ yi. No oroci a̱ mɓa̱la̱'a̱ a vadala shi, ko ana mɓa̱la̱'a̱ m balai shi, u ta̱ idaba. A̱ ta̱ kula̱to yi na akina, ko na̱ shi upa̱luwu'u u ta̱ pe a̱ a̱tsuma̱ ko na alanga. ");
INSERT INTO tsw_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","<<Waru na̱ ganu'u u ka̱lyuwa̱, reve upa̱luwu'u u kporo cina a̱ za̱'wa̱ yi ɗe, u ta paɗa uba̱ta̱'a̱ o utugu'u, ko o uɗavu ko o ukwan ko e ili i na a yuwain nu ukwa'an. ");
INSERT INTO tsw_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Reve na̱ wu utisa̱ o utugu'u ko o uɗavu ko o ukwan ko a̱ cu'un vi ili i na a yuwain nu ukwan biti, u ta balasa. A̱ ta̱ kula̱to ili i na suru i ri na̱ mɓa̱la̱'a̱. ");
INSERT INTO tsw_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Agba utugu'u ko za vu uɗavu ko ukwan ko cu'un vi ili i na a yuwain nu ukwan biti, za na mɓa̱la̱'a̱ m puwa̱yin ana a̱ za̱'wa̱ niyi, a̱ ta̱ za̱'wisa̱ yi ire, reve u ka̱mba̱ cece.>> ");
INSERT INTO tsw_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","A̱yi nda a̱yi ɗa wila̱ adama a̱ mɓa̱la̱ mu upa̱luwusa̱ n na n ri o utugu ko za vu uɗavu ko o okoro ko o ukwan ko a̱ cu'un vi ili i na a yuwain nu ukwan biti, adama u roco ko u ta̱ cece ko idaba. ");
INSERT INTO tsw_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","A̱sulazuva a yuwan ta̱ adanshi na̱ Musa u damma, ");
INSERT INTO tsw_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","<<Apa nda wila̱ adama a za na ri na̱ mɓa̱la̱ mu ukwan u lipu adama o urana u na wa̱a̱ ka̱mba̱ cece, na̱ a̱ ta̱wa̱ na̱ a̱yi uba̱ta̱ wa ganu: ");
INSERT INTO tsw_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ganu to uta̱ o ucina̱ wu uba̱ta̱ o uva̱la̱ta̱, reve u ka̱lyuwa̱ yi. Na̱ mɓa̱la̱'a̱ n koto ta̱ a vuma vu mɓa̱la̱ mu ukwa'an, ");
INSERT INTO tsw_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","u ta zuwa a̱ ta̱wa̱a̱ na̱ nnunu n cece n re n wuma adama a za na a̱a̱ ka̱mba̱to cece'e, na̱ ɗanga seda na̱ a̱punda̱ a̱ shili o uɗavu no oroci o osondori. ");
INSERT INTO tsw_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Reve ganu zuwa le a paɗa manunu ma̱ ta̱ a̱ nnunu n re'e zuva vu upondo u ci'in u na u ri na̱ mini ma sa'ani. ");
INSERT INTO tsw_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Reve u tara manunu ma wuma ma na ma buwai oɓolo na̱ ɗanga seda na̱ a̱punda̱ a̱ shili o uɗavu no oroci o osondori. A̱vu u tsupu le a mpasa m manunu ma na a paɗai zuva mini ma sa'ani'i. ");
INSERT INTO tsw_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Reve wu kyo'onuwo za na a̱a̱ ka̱mba̱to cece diga a̱ mɓa̱la̱ mu ukwan toto ucindere. Reve u damma u ta̱ cece, a̱vu u lyawa manunu ma wuma'a u ka̱ra̱ a̱tsumona. ");
INSERT INTO tsw_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Reve a̱yi za na a̱a̱ ka̱mba̱to cece'e wu za̱'wa̱ a̱tugu a̱ yi, u puna a̱nji a̱ yi, a̱vu u sumba̱ na̱ mini. U ta̱ gba o o'wo cece. Reve no o koto za ndolo u ka̱mba̱ o uva̱la̱ta̱, amma wa̱a̱ da̱nu o oogodo a̱ yi shi hali rana cindere. ");
INSERT INTO tsw_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","O urana we cindere, reve u puna a̱nji a aaci a̱ yi suru, na̱ ntsuka̱ ma̱ yi na̱ a̱ga̱pa̱na̱ a̱ yi. U ta puna eleme a̱ lipu va̱ yi suru. Reve wu za̱'wa̱ a̱tugu a̱ yi, a̱vu u sumba̱ na̱ mini, a̱vu wo o'wo cece. ");
INSERT INTO tsw_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","<<Agba o urana wa̱ kunla̱ u ta tara mugiri'i n re n na n ri usa̱du shi na̱ mokyokyon ma̱ ta̱ ma aa'wan a̱ ta̱ nu umatsun za na ri usa̱du shi, na̱ makundatsu uta'atsu u yira i lashi a̱tsuma̱ a kupa u efa u na a̱ ja̱mba̱ra̱i nu uɓatsulai u ta̱ wu ta'atsu u mata'an ma mani'in. ");
INSERT INTO tsw_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Reve ganu na a̱a̱ ka̱mba̱to yi cece'e u ta̱ ta̱wa̱ na̱ za na a̱a̱ ka̱mba̱to cece'e oɓolo na̱ kucci va̱ yi a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva o una̱ntsu wo Oogodo o Uga'asusan. ");
INSERT INTO tsw_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Reve ganu tara ma̱giri'i ma̱ ta̱, a̱vu u yuwaan kucci makuɗa ma̱ wila̱ oɓolo nu uɓatsulai u ta̱ wu ta'atsu u mata'an ma mani'in. A̱vu u 'ya̱sa̱n le kucci vu u'ya̱susa̱n e ekere a̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Reve u paɗa a̱a̱giri'i'i uba̱ta̱ u na a tsu paɗa kucci vu unusu na̱ kucci vu ukula̱tosu Upasu wa Akiza. Tsa̱ kucci vu unusu, kucci makuɗa ma̱ wila̱ fo akunda a ganu a ɗa, a̱yi ɗa u la'ai akiza. ");
INSERT INTO tsw_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Ganu te kene mpasa n kucci vu unusu'u, reve u daɓa yi e lege vu utsuvu wu za na a̱a̱ ka̱mba̱to cece'e, na a aakatsu a gbain o ukere u sa'ani wa̱ yi na a aakatsu a gbain a anana o ukere u sa'ani wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Reve ganu kene mani'in, reve u tsun yi a apata o ukere wu ugula̱ wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Reve u tsupu aakatsu e ire o usa'ani wa̱ yi a mani'in ma na ma̱ ri a apata o ukere wu ugula̱ wa̱ yi'i, reve wu kyo'onu toto ucindere a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Reve akapi a na a buwai o ukere wa̱ yi'i, u daɓa e lege vu utsuvu vu ukere u sa'ani wu za na a̱a̱ ka̱mbuwa̱ cece'e na a aakatsu a gbain o ukere u sa'ani na a aakatsu a gbain a anana o usa'ani wa̱ yi zuva vu mpasa m makuɗa ma̱ wila̱. ");
INSERT INTO tsw_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Reve akapi a mani'in ma na ma buwai o ukere wa ganu'u u tsun le a aaci a za na a̱a̱ ka̱mba̱to cece'e u yuwaan yi kucci matara mo ume mo unusu a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","<<Ganu ta ca kucci vu unusu u yuwaan za na a̱a̱ ka̱mba̱to cece'e kucci matara mo ume mo unusu diga e idaba ya̱ yi. Reve na̱ a̱yi ndolo koto u paɗa kucci vu ukula̱tosu'u. ");
INSERT INTO tsw_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Reve ganu'u u yuwan kucci'i a masa'a oɓolo na̱ kucci vi ishina, u yuwaan yi kucci matara mo ume mo unusu. Reve gba u ka̱mba̱ cece. ");
INSERT INTO tsw_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","<<Amma na̱ za vu ulambu ɗa, agba waa gura tsura̱ ili i nda shi, reve u tara ma̱giri'i ma̱ ta̱ adama a̱ kucci makuɗa ma̱ wila̱ za na a̱a̱ 'ya̱sa̱n, adama a matara mo ume mo unusu wa̱ yi na̱ makundatsu ma̱ ta̱ ma yira i lashi a̱tsuma̱ a kupa u efa uja̱mba̱ru nu uɓatsulai u ta̱ wu ta'atsu u mata'an ma mani'in adama a̱ kucci vi ishina na̱ mani'in, ");
INSERT INTO tsw_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","na̱ muɗa n re ko murukuku n re, za na suru waa gura tsura̱. Za ta̱ to o'wo kucci vu unusu za ta̱ waru adama kucci vu ukula̱tosu. ");
INSERT INTO tsw_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Reve o urana wa̱ kunla̱ u ta̱wa̱ ne ele ya ganu o una̱ntsu wo Oogodo o Uga'asusan a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva adama o uka̱mba̱tosu wa̱ yi cece. ");
INSERT INTO tsw_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Reve ganu tara ma̱giri'i ma̱ kucci makuɗa ma̱ wila̱ oɓolo nu uɓatsulai u ta̱ wu ta'atsu u mata'an u mani'in. Reve ganu 'ya̱sa̱n le kucci vu u'ya̱susa̱n a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Reve u paɗa ma̱giri'i'i ma̱ kucci makuɗa ma̱ wila̱ꞌa̱. Reve u kene mpasa n kucci m makuɗa ma̱ wila̱ꞌa̱, reve u daɓa e lege vu utsuvu vu ukere wu usa'ani wu za na a̱a̱ ka̱mba̱to cece'e, na a aakatsu a gbain o ukere u sa'ani wa̱ yi na a aakatsu a gbain a anana o usa'ani wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Reve ganu tsun akapi a mani'in a apata o ukere wu ugula̱ wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Reve wu kyo'onu akapi a mani'in ma na ma̱ ri o ukere wu ugula̱ wa̱ yi'i na aakatsu e ire o usa'ani toto ucindere a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Reve akapi a mani'in ma na ma buwai o ukere wa̱ yi u daɓa yi e lege vu utsuvu wu usa'ani wu za na a̱a̱ ka̱mba̱to cece'e, na a aakatsu a gbain o ukere wu sa'ani na a aakatsu a gbain a anana o usa'ani, uba̱ta̱ u na a̱ tsuyin mpasa n kucci makuɗa ma̱ wila̱. ");
INSERT INTO tsw_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Reve akapi a mani'in ma na ma buwai o ukere wa ganu'u u tsun yi a aaci a za na a̱a̱ ka̱mba̱to cece'e, adama a yuwaan yi kucci matara mo ume mo unusu a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Reve u ca muɗa n re ko murukuku n re, ili i na waa gura tsura̱ suru. ");
INSERT INTO tsw_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Za ta̱ adama a kucci vu unusu za ve ire waru adama a̱ kucci vu ukula̱tosu, oɓolo na̱ kucci vi ishina. Reve ganu ca kucci matara mo ume mo unusu'u a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva o una̱ wu za na a̱a̱ ka̱mba̱to cece'e. ");
INSERT INTO tsw_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","<<A̱yi nda a̱yi ɗa wila̱ adama a za na ri na̱ mɓa̱la̱ mu ukwan u lipu n vama, za na aa gura ta̱wa̱a̱ na̱ kucci na a zuwai adama o uka̱mba̱tosu wa̱ yi cece shi.>> ");
INSERT INTO tsw_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","A̱sulazuva a yuwan ta̱ adanshi na̱ Musa na̱ Haruna u damma, ");
INSERT INTO tsw_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","<<Ni i uwa e iɗa ya Ka'ana za na maa ca ɗu wo o'wo za ɗu, na̱ n zuwa mɓa̱la̱ n vama n uwa o u'wa u ro e iɗa'a, ");
INSERT INTO tsw_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","za vu u'wa'a u ta̱ ta̱wa̱ u damma ganu, <Me ene ta̱ gashi mɓa̱la̱ n uwa ta̱ o u'wa u va̱.> ");
INSERT INTO tsw_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Reve ganu zuwa a̱ pura̱ itana yu u'wa'a kafu ganu 'ya̱wa̱ u ka̱lyuwa̱ mɓa̱la̱'a̱, adama a damma ili i na i ri pe o u'wa'a suru a̱ ta̱ idaba wan. No o koto, reve ganu uwa u ka̱lyuwa̱ u'wa'a. ");
INSERT INTO tsw_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Reve u ka̱lyuwa̱ mɓa̱la̱'a̱. Na̱ mɓa̱la̱'a̱ u ri o uɓaɓu wu u'wa'a na abasa a̱ mini ma̱ a̱vu'un ko sawun, nu u uwa pe o uɓaɓu'u, ");
INSERT INTO tsw_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","reve ganu uta̱ o u'wa'a a̱ tyo o una̱ntsu, reve u ɓa̱ru u'wa'a rana cindere. ");
INSERT INTO tsw_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Reve ganu ta̱wisa̱ o urana we cindere u ka̱lyuwa̱. Na̱ mɓa̱la̱'a̱ m bala o uɓaɓu wu u'wa'a, ");
INSERT INTO tsw_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","reve ganu'u u zuwa a ta tawa atali a na a̱ ri na̱ mɓa̱la̱'a̱ reve a vari le uba̱ta̱ wi idaba o ugyuru u lyuci. ");
INSERT INTO tsw_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Reve a̱ ra̱ɓuwa̱ uɓaɓu wa̱ a̱tsuma̱ o u'wa'a suru. Reve o oco ili i na a̱ ra̱ɓuwa̱i'i uba̱ta̱ wi idaba o ugyuru u lyuci. ");
INSERT INTO tsw_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Reve a tara atali o ro a zuwa uba̱ta̱ u na o foɗoi ozo o ndolo. Reve a̱ zura̱ ci'in tso ro reve a sura u'wa'a. ");
INSERT INTO tsw_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","<<Na̱ mɓa̱la̱'a̱ mu utisa̱ o u'wa'a, cina wu uta̱a̱ atali'i, reve vuma'a u ra̱ɓuwa̱ u'wa'a a̱vu u sura yi. ");
INSERT INTO tsw_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Reve ganu'u u 'ya̱wa̱ u ka̱lyuwa̱. Reve nna̱ mɓa̱la̱'a̱ m bala pe o u'wa'a, mɓa̱la̱ n vama mu upa̱luwusa̱ n ɗa o uwa'a'a. U'wa'a wo o'wo ta̱ idaba. ");
INSERT INTO tsw_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Reve o ɓoso u'wa'a, na atali a̱ yi na akpata nu usura wu u'wa'a suru. Reve a̱ pura̱ le a̱ tyo o uba̱ta̱ wi idaba o ugyuru u lyuci'i. ");
INSERT INTO tsw_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Za na suru uwai o u'wa'a a̱yi uɓa̱ruwu u to o'wo idaba hali she ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Waru za na asai pe o u'wa'a, ko u lyuwai pe o u'wa'a u ta̱ za̱'wa̱ a̱tugu a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","<<Agba na̱ ganu ta̱wa̱ u ka̱lyuwa̱, na̱ mɓa̱la̱'a̱ koto m bala o u'wa'a shi cina a sura yi, u ta damma u'wa'a u ta̱ cece, adama a na mɓa̱la̱'a̱ n koto ta̱. ");
INSERT INTO tsw_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Adama a̱ ka̱mba̱to u'wa'a cece, vuma'a u ta tara nnunu n re na̱ ɗanga seda na̱ a̱punda̱ o uɗavu a̱ shili no oroci o osondori. ");
INSERT INTO tsw_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Reve u paɗa manunu ma̱ ta̱ o upondo u ci'in u na u ri na̱ mini ma sa'ani. ");
INSERT INTO tsw_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Reve u tara ɗanga seda no oroci o osondori na̱ a̱punda̱ a̱ shili o uɗavu oɓolo na̱ manunu ma wuma. Reve u tsupu le a mpasa m manunu ma na a paɗai na̱ mini'i, reve wu kyo'onu u'wa'a toto ucindere. ");
INSERT INTO tsw_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ne ɗa wa̱a̱ ka̱mba̱to u'wa'a cece na̱ mpasa m manunu'u na̱ mini ma sa'ani na̱ manunu ma wuma na̱ ɗanga seda no oroci o osondori na̱ a̱punda̱ o uɗavu a̱ shili. ");
INSERT INTO tsw_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Reve u lyawa manunu ma wuma'a o ugyuru u lyuci wu 'yawan a̱ tyo o ogozo. Ne ɗa waa yuwan kucci matara mo ume mo unusu adama o u'wa'a, reve gba wo o'wo cece.>> ");
INSERT INTO tsw_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","A̱yi nda a̱yi ɗa wila̱ adama a̱ mɓa̱la̱ mu ukwan u lipu: adama e ikavuru, ");
INSERT INTO tsw_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","na adama a̱ mɓa̱la̱ mu upa̱luwusa̱ o utugu ko o u'wa, ");
INSERT INTO tsw_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","na adama o utsutsu ko adama e ikavuru ko abasa o uryoryo, ");
INSERT INTO tsw_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","adama u roco a mantsa ma na u ri idaba na̱ mantsa ma na u ri cece. A̱yi ɗa wila̱ adama a̱ mɓa̱la̱ mu ukwan n lipu. ");
INSERT INTO tsw_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","A̱sulazuva a yuwan ta̱ adanshi na̱ Musa na̱ Haruna u damma, ");
INSERT INTO tsw_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","<<Yuwain adanshi na aza a Isra'ila i damma le, na̱ vali ri a̱ ɗa̱wusa̱ a̱ lipu tsali tsa̱ yi, wuɗa̱wusa̱'a̱ ili yi idaba i ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ko na̱ ma̱ɗa̱wa̱'a̱ u lyuwa elime ko u gulu, u ta zuwa yi wo o'wo idaba. Apa nda cine ma̱ɗa̱wa̱ ma̱ yi maa zuwa idaba: ");
INSERT INTO tsw_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Uba̱ta̱ wu nven n na vuma na a̱a̱ ɗa̱wusa̱ voyin suru u to o'wo idaba. Waru e ili i na u da̱nuyi suru u to o'wo idaba. ");
INSERT INTO tsw_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Za na suru ju'wa̱in uba̱ta̱ wu nven wa̱ yi u ta̱ za̱'wa̱ a̱tugu a̱ yi, reve u sumba̱ na̱ mini, a̱vu wo o'wo idaba hali ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Waru za na suru da̱nuyi e ili i na za na a̱a̱ ɗa̱wusa̱ da̱nuyi, u ta̱ za̱'wa̱ a̱tugu a̱ yi. Reve u sumba̱ na̱ mini, reve u buwa idaba hali she ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Za na suru ju'wa̱in lipu vu za na a̱ ɗa̱wusa̱, u ta̱ za̱'wa̱ a̱tugu a̱ yi, reve u sumba̱ na̱ mini, reve wo o'wo idaba she ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","<<Na̱ za na a̱a̱ ɗa̱wusa̱ tsuwa̱a̱n za na ri cece ma̱tsa̱n, za na a̱ tsuwa̱yin ma̱tsa̱'a̱n u ta̱ za̱'wa̱ a̱tugu a̱ yi, reve u sumba̱ na̱ mini, reve wo o'wo idaba she ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Urutsu u na za ma̱ɗa̱wa̱'a̱ u da̱nuyi suru u to o'wo idaba. ");
INSERT INTO tsw_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Waru za na suru ju'wa̱in ili i na biti i ri za̱la̱ vu urutsu'u u to o'wo idaba hali ulivu. Waru za na suru tanuyi ili i ndolo u ta̱ za̱'wa̱ a̱tugu a̱ yi, reve u sumba̱ na̱ mini. Reve wo o'wo idaba she ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Za na suru za ma̱ɗa̱wa̱ ju'wa̱in agba u sa'a ekere a̱ yi na̱ mini shi, u ta̱ za̱'wa̱ a̱tugu a̱ yi reve u sumba̱ na̱ mini, a̱vu wo o'wo idaba she ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Upondo u ci'in u na za ma̱ɗa̱wa̱ ndolo ju'wa̱in suru o to ɓoso yi, agba ili i na suru u ju'wa̱in i na a yuwain nu uɗanga a̱ ta̱ za̱'wa̱ yi na̱ mini. ");
INSERT INTO tsw_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","<<Na̱ a̱ ka̱mba̱to vuma cece diga a̱ ma̱ɗa̱wa̱ ma̱ yi, reve u kecee aciya̱yi rana cindere vu uka̱mba̱tosu cece va̱ yi, reve wu za̱'wa̱ a̱tugu a̱ yi. A̱vu u sumba̱ aciya̱yi na̱ mini ma sa'ani a̱vu wo o'wo cece. ");
INSERT INTO tsw_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Reve o urana wa̱ kunla̱ u tara muɗa n re ko murukuku n re, a̱vu u ta̱wa̱ a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva o una̱ntsu wo Oogodo o Uga'asusan, a̱vu u ca ganu ele. ");
INSERT INTO tsw_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Reve ganu ca kucci le, za ta̱ kucci adama o unusu za ta̱ kucci vu ukula̱tosu. Ne ɗa ganu aa yuwan kucci matara mo ume mo unusu o una̱ wa̱ yi a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva adama a̱ ma̱ɗa̱wa̱ ma̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","<<Na̱ tsali tsa vuma tso oco, u ta̱ sumba̱ lipu va̱ yi suru na̱ mini a̱vu wo o'wo idaba hali she ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Utugu ko ukwan u na tsali'i tsa̱ ju'wa̱in biti a̱ ta̱ za̱'wa̱ yi na̱ mini reve wo o'wo idaba hali she ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Na̱ vuma von na̱ ka hali tsali tso uta̱, ele ra a̱ ta̱ sumba̱ na̱ mini, reve o o'wo idaba hali she ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","<<Na̱ ka e eneshe a̱shinda̱ o usumbu a̱ yi, u ta̱ da̱na̱ a̱tsuma̱ e idaba yu usumbu wa̱ yi hali rana cindere. Za na suru ju'wa̱n niyi u to o'wo idaba hali she ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","E ili i na ka'a u voyin suru a mantsa mo usumbu ma̱ yi u to o'wo idaba. Waru e ili i na u da̱nuyi suru u to o'wo idaba. ");
INSERT INTO tsw_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Za na suru ju'wa̱in ili yi nven ya̱ yi u ta̱ za̱'wa̱ a̱tugu a̱ yi a̱vu u sumba̱ na̱ mini, reve wo o'wo idaba hali she ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Za na waru ju'wa̱in ili i na wa̱a̱ da̱nusu, u ta̱ za̱'wa̱ a̱tugu a̱ yi reve u sumba̱ na̱ mini, reve wo o'wo idaba hali she ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ko ili yi nven i ɗa ko ili i na u shi nden, na̱ vuma ro ju'wa̱n yi u to o'wo idaba hali she ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Waru na̱ vuma von na̱ a̱yi reve mpasa mu usumbu ma̱ yi n ju'wa̱n yi, u to o'wo idaba rana cindere. Ili yi nven i na suru vali'i u voyin u to o'wo idaba. ");
INSERT INTO tsw_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","<<Na̱ ka ri ocosu mpasa hali rana a̱bunda̱ agba mpasa mu usumbu ma̱ yi n ɗa shi, ko gba moco ma mpasa'a ma̱ ka̱ra̱ mantsa mo usumbu ma̱ yi, rana moco ma mpasa'a suru u ta̱ da̱na̱ a̱tsuma̱ e idaba. U ta̱ da̱na̱ a̱tsuma̱ e idaba tsa rana vu usumbu va̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ili yi nven i na u voyin suru a rana moco ma mpasa ma̱ yi u to o'wo idaba tsa mantsa mo usumbu wa̱ yi. Waru e ili i na suru u da̱nuyi u to o'wo idaba, tsa rana vu usumbu va̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Za na suru ju'wa̱in ili i nda u to o'wo idaba. U ta̱ za̱'wa̱ a̱tugu a̱ yi reve u sumba̱, reve wo o'wo idaba hali she ulivu. ");
INSERT INTO tsw_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Amma na̱ wo o'wo cece diga o moco ma mpasa'a, u te kecee aciya̱yi rana cindere, na a yuwan ne, u to o'wo cece. ");
INSERT INTO tsw_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","O urana wa̱ kunla̱ reve u tara muɗa n re ko murukuku n re. Reve u ta̱wa̱ ne ele ya ganu o una̱ntsu wo Oogodo o Uga'asusan. ");
INSERT INTO tsw_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Reve ganu ca za ta̱ kucci adama o unusu za ve ire waru kucci vu ukula̱tosu. Ne tsunda tsa ɗa ganu a yuwan kucci ma matara mo ume mo unusu o una̱ wa̱ yi a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva adama e idaba i wocosu wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","<<Ne ɗa vaa kasa aza a Isra'ila ni ili i na yoo o'woto le idaba, adama a̱ kuwa̱ a̱tsuma̱ e idaba i le wan na̱ a̱ lungusa̱ uba̱ta̱ wu nden n va̱ n na n ri e memere me le.>> ");
INSERT INTO tsw_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","A̱yi nda a̱yi ɗa ili i na aa yuwan adama a za na o o'woi idaba adama a̱ ma̱ɗa̱wa̱ ko za na tsali tsa̱ yi tsoo ocusho. ");
INSERT INTO tsw_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Na adama a ka na ri na̱ a̱shinda̱ o usumbu wa̱ yi, adama a vali ko ka na suru ri o ocosu, waru na adama a vali na voyin na̱ ka na ri idaba. ");
INSERT INTO tsw_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","A̱sulazuva a yuwan ta̱ adanshi na̱ Musa cina olobo e re a Haruna a̱ kuwa̱ ɗe, ana a̱ ta̱wa̱i a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva na akina a na a ntsayi shi, a̱vu gba a̱ kuwa̱. ");
INSERT INTO tsw_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Reve A̱sulazuva a damma Musa, <<Damma mawun ma̱ a̱na̱wu ma̱ wu Haruna, she u uwa Upasu wa Akiza o ucina̱ wu umuna elime e ikpa̱ta̱tsu ya Akpati mantsa ma na u cigai biti wan, ta̱wa̱ u kuwa̱ wan. Adama a na n ta̱ ta̱wa̱ e eleshe e ikpa̱ta̱tsu ya Akpati'i. ");
INSERT INTO tsw_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Apa nda cine Haruna aa uwa Upasu wa Akiza: u ta uwa na̱ moggono ma nan ma̱ kucci vu unusu na̱ a̱a̱giri'i a̱ kucci vu ukula̱tosu. ");
INSERT INTO tsw_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","U to oto a̱tugu a akiza o okoro na̱ mokoɗi ma aacaka a̱ lipu va̱ yi. Reve wu nla̱ gbakala vu umuna e ikyun ya̱ yi, a̱vu wo oto ookokolo o okoro. A̱tugu a akiza a ɗa adama o ndolo u ta̱ sumba̱ kafu wo oto le. ");
INSERT INTO tsw_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","U ta̱ ushi nga̱ji n re e ekere a ama a Isra'ila adama a̱ kucci vu unusu, na̱ a̱a̱giri'i a̱ ta̱ adama a̱ kucci vu ukula̱tosu. ");
INSERT INTO tsw_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","<<Haruna ta ca nan kucci vu unusu adama a aciya̱yi, u yuwan kucci matara mo ume mo unusu wa̱ yi na adama o u'wa wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Reve u tara nga̱ji n re'e, a̱vu u ta̱wa̱ ne ele a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva o una̱ntsu wo Oogodo o Uga'asusan. ");
INSERT INTO tsw_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Reve u zuwa agita e mgbele n re'e, za ta̱ adama a̱ A̱sulazuva za ta̱ adama a Azaze. ");
INSERT INTO tsw_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Reve Haruna ta̱wa̱ na̱ za na agita a̱ riya̱yi adama a̱ A̱sulazuva u yuwan kucci vu unusu na̱ a̱yi. ");
INSERT INTO tsw_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Amma za na agita a̱ riya̱yi adama a Azaze a̱ ta̱ ta̱wa̱ na̱ a̱yi wuma a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva a yuwan ili i na a tsu yuwan i matara mo ume mo unusu. A̱ gba̱ra̱ yi a̱ tyo a̱tsumona tsa̱ a̱gba̱ri a Azaze. ");
INSERT INTO tsw_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","<<Haruna ta̱ ta̱wa̱a̱ no ogono a nan kucci vu unusu wa̱ yi. Reve u yuwan kucci matara mo ume mo unusu adama a aciya̱yi na adama o u'wa wa̱ yi. U ta paɗa na'an kucci vu unusu va aciya̱yi. ");
INSERT INTO tsw_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Reve u tara aayimba tapu na akinkina a na a̱ ri na akina diga a masa'a a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. Reve u shiton ukere u re ni ili i ma̱guru u uwa ne ele a̱tsuma̱ o umuna. ");
INSERT INTO tsw_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Reve u tsun ili i ma̱guru'u a akina'a a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva adama mikyon ma a̱tsuka̱'a̱ m ɓa̱ru ikpa̱ta̱tsu ya akpati'i, uba̱ta̱ u matara mo ume mo unusu, ta̱wa̱ u kuwa̱ wan. ");
INSERT INTO tsw_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Reve u kene mpasa mo ogono a na'an reve wu kyo'onu yi na aakatsu a̱ yi elime e ikpa̱ta̱tsu ya akpati a matara mu ume mo unusu upasu wa asana. Reve waru wu kyo'onu akapi na aakatsu a̱ yi toto ucindere elime e ikpa̱ta̱tsu ya akpati'i. ");
INSERT INTO tsw_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","<<Reve u paɗa megbele ma̱ kucci vu unusu'u adama a ama. Reve u ta̱wa̱ na̱ mpasa'a o ucina̱ wu umuna'a, a̱vu u yuwan na̱ a̱yi cine u yuwain na̱ mpasa mu na'an. Wu kyo'onu yi zuva vi ikpa̱ta̱tsu va akpati'i na̱ a̱ ma̱ka̱ka̱n ma̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Ne ɗa waa yuwan kucci matara mo ume mo unusu adama o Upasu u na u La'ai Akiza, adama e idaba ya aza a Isra'ila na adama a aciyogbamu u le, ko cu'un vu unusu ne a yuwain. Ne ɗa waa yuwaan fo Oogodo o Uga'asusan a na a̱ ri uba̱ta̱ u le, e memere me idaba i le. ");
INSERT INTO tsw_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Ko za da̱na̱ pe o Oogodo o Uga'asusan wan a̱ mantsa ma na Haruna ganu aa uwa u yuwan kucci matara mo ume mo unusu Upasu u na u La'ai Akiza, hali she na̱ wu uta̱ nu u koto mayan ma̱ kucci matara mo ume mo unusu adama a aciya̱yi nu u'wa wa̱ yi na adama a ama a Isra'ila suru. ");
INSERT INTO tsw_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Reve wu uta̱ a̱ 'ya̱wa̱ uba̱ta̱ u masa'a ma na ma̱ ri a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva u yuwan kucci matara mo ume mo unusu adama a̱ yi. Reve u kene mpasa mo ogono a na'an na̱ mpasa m megbele'e u putala yi a avana a masa'a'a. ");
INSERT INTO tsw_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","U to kyo'onuwo yi mpasa'a na aakatsu a̱ yi toto ucindere, adama wo o'woto yi cece, waru u lapula yi e ekere e idaba ya aza a Isra'ila. ");
INSERT INTO tsw_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","<<Nu u koto mayan ma̱ kucci matara mo ume mo unusu adama o Upasu u na u La'ai Akiza'a no Oogodo o Uga'asusan na̱ masa'a, reve u ta̱wa̱a̱ na̱ megbele ma wuma'a. ");
INSERT INTO tsw_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Reve Haruna kuru ekere a̱ yi ra a aaci a megbele ma wuma'a reve u damma iwuya na aciyogbamu nu unusu wa aza a Isra'ila suru. U zuwa le suru a aaci e megbele'e reve u gba̱ra̱ yi a̱ tyo a̱tsumona e ekere a vuma na a zuwai ulinga u ndolo. ");
INSERT INTO tsw_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Megbele'e ma ta tanu unusu wa ama'a suru a̱ tyo uba̱ta̱ u na za ri shi, reve vuma'a u lyawa yi a̱ a̱tsumona. ");
INSERT INTO tsw_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","<<Reve Haruna uwa a̱tsuma̱ o Oogodo o Uga'asusa'an, reve u foɗo a̱tugu o okoro a na u shi wo otoi kafu u uwa Upasu u na u La'ai Akiza'a reve u lyawa le pe. ");
INSERT INTO tsw_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Reve u sumba̱ lipu va̱ yi na̱ mini uba̱ta̱ wa akiza, a̱vu wo oto a̱tugu a̱ yi. A̱vu wu uta̱ u ca kucci vu ukula̱tosu va̱ yi na̱ kucci vu ukula̱tosu va ama, u yuwan kucci matara mo ume mo unusu wa̱ yi na̱ za va ama'a. ");
INSERT INTO tsw_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Agba u ta̱ kula̱to abaji a mani'in ma̱ kucci vu unusu a masa'a. ");
INSERT INTO tsw_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Vuma na lyawai megbele Azaze ma̱ ka̱ra̱ a̱gba̱ri, u ta̱ za̱'wa̱ a̱tugu a̱ yi, reve u sumba̱ na̱ mini. Na a yuwan u ta gura uwa o uva̱la̱ta̱. ");
INSERT INTO tsw_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Agba nan na̱ megbele ma na a yuwayin kucci vu unusu'u aza a na a̱ ta̱wa̱i na̱ mpasa n le Upasu u na u La'ai Akiza adama a̱ kucci matara mo ume mo unusu a ta tara le a̱ tyo o ucina̱ wu uva̱la̱ta̱ a̱ kula̱to le. A̱vu a̱ kula̱to kwan le ni iliya̱tsuma̱ i le na̱ a̱ya̱n e le. ");
INSERT INTO tsw_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Vuma na kula̱to nle'e u ta̱ za̱'wa̱ a̱tugu a̱ yi, reve u sumba̱ na̱ mini. Na a yuwan ne u ta gura uwa o uva̱la̱ta̱. ");
INSERT INTO tsw_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","<<A̱yi nda u to o'wo ili i na i ri n yuwusan kukuci: o urana wa kupa u woto we cindere, yaa lyuwa shi waru yaa yuwan ulinga shi, umatsun u lyuci ko omocin a na ri o limocin a̱tsuma̱ a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Adama a na o urana u nda u ɗa aa yuwan kucci matara mo ume mo unusu adama a̱ ɗu, adama a̱ ka̱mba̱to ɗu cece. I to o'wo cece a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva diga a̱ nusu ɗu suru. ");
INSERT INTO tsw_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ashibi a̱ wivuwun a ɗa la̱nga̱ e ekere a̱ ɗu, yaa lyuwa gba ili shi. A̱yi nda ili i na ya̱a̱ da̱na̱ a yuwusan ɗa kukuci. ");
INSERT INTO tsw_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ganu na a̱ tsuyin mani'in a tawa niyi wo o'wo ganu o una̱ wa dada va̱ yi ɗa aa ca kucci matara mo ume mo unusu, wotowu na̱ a̱tugu a akiza o okoro. ");
INSERT INTO tsw_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Reve u yuwan kucci matara mo ume mo unusu adama o Upasu u na u La'ai Akiza. Reve u ca kucci matara mo ume mo unusu adama o Oogodo o Uga'asusa'an na adama a masa'a na adama a nan ganu na adama o oɓolo a ama'a suru. ");
INSERT INTO tsw_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","<<A̱yi nda u to o'wo ili i na i ri n yuwusan kukuci. A̱ ta̱ a̱ ri n yuwusan kucci matara mo ume mo unusu adama o unusu wa ama a Isra'ila suru u ta̱ a aa'wan.>> Reve Musa yuwan cine A̱sulazuva a damma niyi. ");
INSERT INTO tsw_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","A̱sulazuva a yuwan ta̱ adanshi na̱ Musa u damma, ");
INSERT INTO tsw_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","<<Yuwan adanshi na̱ Haruna no olobo a̱ yi na ama a Isra'ila suru vu damma le, <Apa nda ili i na A̱sulazuva a zuwai: ");
INSERT INTO tsw_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","na̱ vuma na a̱tsuma̱ a aza a Isra'ila paɗa ogono a nan ko mokyokyon ko megbele pe o uva̱la̱ta̱ ko ucina̱ wu uva̱la̱ta̱, ");
INSERT INTO tsw_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","agba u ta̱wa̱ na̱ a̱yi o una̱ntsu wo Oogodo o Uga'asusan u ca kucci vu uneꞌe wa̱ yi e ekere a̱ A̱sulazuva elime a̱ a̱a̱'isa̱ a̱ A̱sulazuva shi, ume wu unusu wu mpasa u ta a aci a̱ yi. Wo oco ta̱ mpasa, a ta tawa vuma ndolo a̱tsuma̱ a ama a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","A̱yi nda u ta dansa ama a Isra'ila a̱ ta̱ a̱ ri n ta̱wusa̱a̱ na̱ kucci na aa casu a atsusa uba̱ta̱ wa̱ A̱sulazuva e ekere a ganu o una̱ntsu wo Oogodo o Uga'asusan. Reve a ca kucci le vu muwwulai e ekere a̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Reve ganu kyo'onu mpasa'a a masa'a ma̱ A̱sulazuva o una̱ntsu wo Oogodo o Uga'asusan. Reve u kula̱to abaji a mani'i'in ili i ma̱guru mo uyo'o a̱ tyo e ekere a̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","A̱a̱ da̱shi ca otoni a̱ lima̱ a na a̱ ri no oroci e mgbele kucci shi, aza a na aa yuwusan tsushakala ne ele. A̱yi nda u to o'wo ili i na a̱a̱ da̱na̱ a yuwusan kukuci hali a̱ tyo a mantsa me elime.> ");
INSERT INTO tsw_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","<<Vu damma le, za va Isra'ila ko mocin na suru cayi kucci vu ukula̱tosu ko cu'un kucci ro, ");
INSERT INTO tsw_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","agba u ta̱wa̱ na̱ a̱yi o una̱ntsu wo Oogodo o Uga'asusan u ca A̱sulazuva shi, a ta tawa vuma ndolo a̱tsuma̱ a ama a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","<<Za va Isra'ila ko mocin na ri nden ne ele suru na tamai a̱kutsu a mpasa, n ta yuwan tsurala na̱ a̱yi, reve n tawa yi a̱tsuma̱ a ama a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Adama a na wuma wi ili i wuma i ta̱ a̱tsuma̱ a mpasa ma̱ yi. N ca ɗu ta̱ a̱yi adama i yuwan a̱ga̱nda̱ a matara mo ume mo unusu adama a aciya̱ɗu a masa'a, adama a na mpasa n ɗa n tsu tara ume wu unusu u vuma. ");
INSERT INTO tsw_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Adama o ndolo a ɗa n dammai aza a Isra'ila: ko za a̱tsuma̱ a̱ ɗu ko mocin na ri na̱ nden na̱ a̱ɗu aa tama mpasa shi. ");
INSERT INTO tsw_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","<<Za va Isra'ila na suru, ko mocin na ri na̱ nden a̱tsuma̱ a̱ ɗu na vu unai nama o ugenge ko manunu ma na a tsu tama u to oco mpasa ma̱ yi reve u ciɗo yi na̱ ma̱bula̱. ");
INSERT INTO tsw_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Adama a na wuma wi ili i wuma i ta̱ a̱tsuma̱ a mpasa ma̱ yi. Adama o ndolo a ɗa n dammai aza a Isra'ila: she i tama mpasa mi ili i wuma wan, adama a na wuma wi ili i wuma suru i ta̱ a̱tsuma̱ a mpasa ma̱ yi. Za na suru tama niyi a ta tawa yi. ");
INSERT INTO tsw_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","<<Za na suru tamai a̱kwa̱kwa̱ ko ili i na nama vu una kakarai, ko umatsun u lyuci ko mocin, u ta̱ za̱'wa̱ a̱tugu a̱ yi reve u sumba̱ na̱ mini. Reve u da̱na̱ idaba hali she ulivu, reve wo o'wo cece. ");
INSERT INTO tsw_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Agba na̱ vuma'a wu za̱'wa̱ a̱tugu ko u sumba̱ shi, ume wu unusu u ndolo u ta̱ a aci a̱ yi.>> ");
INSERT INTO tsw_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Reve A̱sulazuva a damma Musa, ");
INSERT INTO tsw_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","<<Yuwan adanshi na aza a Isra'ila vu damma le: a̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","She i yuwan cine aa yuwusan a̱tsuma̱ a Masar wan, uba̱ta̱ u na i da̱na̱i na̱ nden. Waru she i yuwan cine aa yuwusan a̱tsuma̱ e iɗa ya Ka'ana wan, uba̱ta̱ u na ma̱a̱ ta̱wa̱to ɗu. She i yuwan cine ele aa yuwusan wan. ");
INSERT INTO tsw_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","I toni wila̱ u va̱ reve i kuru ili i na n dammai ulobonu. A̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","I toni ili i na n dammai na̱ wila̱ u va̱, adama a na vuma na toniyi nle u ta̱ tsura̱ wuma e ekere e le. A̱mu ɗa A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","<<She i yuwan zuzu ni imaci i na i ri zuzu na̱ a̱ɗu na yoo von ne ele wan. A̱mu ɗa A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","She vu von na̱ mma va̱ wu vu zuwa dada va̱ wu o'wo ili yi izo'oshi wan. Mma va̱ wu ɗa. She vu von na̱ a̱yi wan. ");
INSERT INTO tsw_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","She vu von na̱ ka va dada va̱ wu wan, ili i ndolo i ta zuwa dada va̱ wu o'wo ili yi izo'oshi. ");
INSERT INTO tsw_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","She vu von na̱ mawun ma̱ a̱na̱wu ma̱ wu mo usheli wan, ko mawun ma̱ a̱sha̱wu ma̱ wu mo usheli wan, ko mawun mo usheli ma mma va̱ wu wan, ko o u'wa u ta̱ u ɗa a matsan nɗu ko a matsan yi ta̱ uba̱ta̱ u ro. ");
INSERT INTO tsw_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","She vu von na̱ mawun ma tsukaya ma̱ wu usheli wu ulobo wa̱ wu wan, ko usheli wu usheli wa̱ wu wan, ili i ndolo i to o'wo wu ili yi izo'oshi. ");
INSERT INTO tsw_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","She vu von nu usheli wu ka va dada va̱ wu za na a matsaan niyi wan, mawun ma̱ a̱sha̱wu ma̱ wu ma ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","She vu von na̱ mawun ma̱ a̱na̱wu ma dada va̱ wu mo usheli wan, adama a na maci zuzu va dada va̱ wu ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","She vu von na̱ mawun ma̱ a̱na̱wu ma mma va̱ wu mo usheli wan, adama a na maci zuzu va mma va̱ wu ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","She vu von na̱ ka mawun ma̱ a̱na̱wu ma dada va̱ wu wan, adama a na a̱yi mma va̱ wu ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","She vu von na̱ jene va̱ wu wan, ka mawun ma̱ wu ma ɗa. She vu von na̱ a̱yi wan. ");
INSERT INTO tsw_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","She vu von na̱ ka mawun ma̱ a̱na̱wu ma̱ wu wan, adama a na ili i nda i to o'wo yi ili yi izo'oshi. ");
INSERT INTO tsw_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","She vu von na̱ mma oɓolo nu usheli wa̱ yi wan. Waru she vu von na̱ mawun ma tsukaya ma̱ yi usheli wu ulobo wa̱ yi ko mo usheli wa̱ yi wan, adama a na imaci i zuzu ya̱ yi i ɗa. Iwuya i ɗa ndolo'o. ");
INSERT INTO tsw_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","She vu zuwa zawa'a vu ka va̱ wu wo o'wo shewun va̱ yi ka va̱ wu gba ubuwu wuma, a̱vu vu von na̱ a̱yi wan. ");
INSERT INTO tsw_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","<<She vu von na̱ ka a̱yi a mantsa mo usumbu ma̱ yi wan. ");
INSERT INTO tsw_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","She vu von na̱ ka moron ma̱ nden ma̱ wu, a̱vu vu lungusa̱ aciya̱wu na̱ a̱yi wan. ");
INSERT INTO tsw_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","She vu yuwan kucci na̱ ko mawun ma̱ ta̱ a̱tsuma̱ a̱ muwun ma̱ wu e ekere a̱ a̱a̱ma̱li Mole wan, adama vu ta̱wa̱a̱ na̱ wono e ekere a̱ A̱sulazuva wan. A̱mu ɗa A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","She vu von na̱ vali na̱ vali cine a tsu yuwan na̱ ka wan. Ili yi idaba i ɗa e ekere a̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","She vu von na̱ nama wan a̱vu vu lungusa̱ aciya̱wu. She ka ca lipu va̱ yi nama von na̱ a̱yi wan, ili yi idaba i ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","<<A̱tsuma̱ e re nda suru she i lungusa̱ aciya̱ɗu wan, adama a na tsundolo tsa ɗa ama a na moo lo a̱ ma̱ka̱ka̱n ma̱ ɗu o o'woi ili yi idaba. ");
INSERT INTO tsw_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Tsundolo tsa ɗa iɗa'a yo o'woi idaba. Reve n ca yi oforo adama o unusu wa̱ yi, adama o ndolo a ɗaɗa iɗa'a i shaamai aza a na a̱ ri pe nden. ");
INSERT INTO tsw_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Amma i to toni ili i na n dammai na̱ wila̱ u va̱ agba she i yuwan ili yi idaba i nda wan, ko umatsun wi iɗa i ɗa vu ri ko mocin na ri nden na̱ a̱ɗu, ");
INSERT INTO tsw_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","adama a na ili i nda i ɗa suru ama'a a yuwain aza a na a̱ da̱na̱i elime a̱ ɗu, reve iɗa'a yo o'wo idaba. ");
INSERT INTO tsw_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Na̱ yo o'woto iɗa'a ili yi idaba, u ta shaama ɗu cine u shaamai ama a na a̱ shi elime a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Vuma na yuwain cu'un vi ili yi idaba i nda suru, cu'un vuma ndolo a tawa yi a̱tsuma̱ a ama yi. ");
INSERT INTO tsw_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","I toni ili i na n dammai, she i yuwan ili yi idaba ya agadu ya ama a na a yuwusain kafu i ta̱wa̱ pa wan. Waru she i lungusa̱ aciya̱ɗu ne ele wan. A̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu.>> ");
INSERT INTO tsw_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Reve A̱sulazuva a damma Musa, ");
INSERT INTO tsw_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","<<Vu yuwan adanshi na aza a Isra'ila suru vu damma le, i da̱na̱ na akiza adama a na a̱mu A̱sulazuva A̱sula̱ a̱ ɗu za va akiza ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Vuma suru a̱tsuma̱ a̱ ɗu u ca dada na̱ mma ɗu tsugbain. Reve i yuwan tsutoni nu urana wa Ashibi a̱ va̱. A̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","She i zuwa okolo a̱ ɗu a̱ musula̱ wan ko i zuɗa̱a̱ aciya̱ɗu ruma musula̱ mi irumu wan. A̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","<<Ni i ca kucci muwwulai a̱ tyo uba̱ta̱ wa̱ A̱sulazuva, i ca yi cine wu ntsayi a̱ usu yi o una̱ u ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","I ta tama kucci'i o urana u ndolo ko nu usana u tawa, ili i na gba i buwai hali urana wa ta'atsu i ta̱ kula̱to yi. ");
INSERT INTO tsw_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Na a tama akapi o urana wa ta'atsu wo o'wo ta̱ ili yi idaba, waru a̱ usu yi shi. ");
INSERT INTO tsw_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Vuma na tama niyi o urana wa ta'atsu biti, imini ya̱ yi i ɗa, adama a na u ka̱mba̱to ta̱ ili ya akiza ya̱ A̱sulazuva wo o'wo ili yi idaba, a ta tawa cu'un vuma ndolo a̱tsuma̱ a ama a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","<<A mantsa ma na i gasai itana ya̱ a̱ɗuma̱ a̱ ɗu, she i gasa a̱ tyo a̱ nge'en ma̱ a̱ɗuma̱'a̱ wan ko i toni nu u'yanlu uba̱ta̱ u na i gasai wan. ");
INSERT INTO tsw_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","She i ka̱mba̱ u'yanlu o uɗuma̱ wa ataci a̱ ina̱bi wan ko yi ta̱ɗa̱ aza a na o ocoi e iɗa wan. I lyawa le adama a alambi no omocin. A̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","<<She i yuwan wivu wan. She i yuwan epen wan. She i luluma̱ nanza wan. ");
INSERT INTO tsw_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","She i kucina na ala a̱ va̱ ne epen wan. Mayuwan ne u to rono ala a̱ A̱sula̱ a̱ wu e iɗa. A̱mu ɗa A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","<<She i paala moron ma̱ nden ma̱ ɗu wan, waru she i usa itana ya̱ yi wan. She i lyawa ikebe ya aza a azamalinga ya asa o ukere u ɗu wan. ");
INSERT INTO tsw_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","She yi isula agulani wan ko i zuwa ili i na irumba̱ ya̱a̱ ta̱ɗa̱tsa̱ wan, amma yu uwwa wovon wa̱ A̱sula̱ a̱ ɗu. A̱mu ɗa A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","<<She i yuwan uge'etosu wu ulambu u mejege wan. She i roco aɗangulu e ekere a alambi wan ko icigi ba̱ta̱ wu zagbain wan, amma i yuwan uge'etosu wa amayun a̱tsuma̱ o nron mu nden n ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","She i baza adanshi e epen a̱tsuma̱ a ama a̱ ɗu wan. She i yuwan ili i na yaa zuwa wuma wu nanza a̱tsuma̱ e meleshe wan. A̱mu ɗa A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","<<She vu 'yuwan za va̱ wu o okolo a̱ wu wan. Vu ɓara moron ma̱ nden ma̱ wu a alanga e eteshe adama vu tsura̱ akunda o unusu wa̱ yi wan. ");
INSERT INTO tsw_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","She i zami ure u na yaa tsupa ko i zuwa nanza o okolo a̱ ɗu wan, amma i ciga moron ma̱ nden ma̱ ɗu tsa aciya̱ɗu. A̱mu ɗa A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","<<I toni ili i na n dammai. She i ɓolo cu'un vi iliyamunga i ro na̱ cu'un ro adama a yuwan tsukumbi wan. She i cu'wa̱n uɗuma̱ u ɗu ni icu'un, yi icu'un i re wan. She yo oto itana i na a ɗavai na̱ a̱punda̱ e re koko'o wan. ");
INSERT INTO tsw_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","<<Na̱ vuma von na̱ ka na ri aagbashi, za na waru a yuwayin ɗe nanza nzuwulai n na waa zuwa, agba koto a tsupaa yi shi ko wo o'wo fa̱a̱n shi, a ca le oforo a na a ntsayi. O una le wan, adama a na koto wo o'wo fa̱a̱n shi. ");
INSERT INTO tsw_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Amma vuma'a u ta̱ ta̱wa̱ na̱ a̱a̱giri'i o una̱ntsu wo Oogodo o Uga'asusan adama a̱ kucci vu unusu uba̱ta̱ wa̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Ganu ta yuwaan yi kucci matara mo ume mo unusu na̱ a̱a̱giri'i'i na̱ kucci makuɗa ma̱ wila̱ a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva adama o unusu u na u yuwain, a̱vu a yuwaan yi gafura vu unusu wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","<<Mantsa ma na i uwai a̱tsuma̱ e iɗa'a reve i cu'wa̱n cu'un vu uɗanga na suru tsu matsan muwun ma alya, i tara muwu'un o o'wo ɗu ili yi idaba hali a'wan a ta'atsu, she i lyuwa le wan. ");
INSERT INTO tsw_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","A aa'wan a̱ na̱shi umatsun wu ɗanga suru to o'wo ili ya akiza, kucci vi ica uba̱ta̱ wa̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Amma gba a aa'wan a tawun i ta lyuwa umatsun wu ɗanga'a. Ne ɗa ugasa u ɗu wa̱a̱ da̱shi a̱bunda̱ a̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","<<She i tama nama a̱yi ubuwu na̱ mpasa ma̱ yi wan. She i yuwan yindi ko tsuboci wan. ");
INSERT INTO tsw_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","She i ye'we cin ɗu, ko i ye'we ntsuka̱ n ɗu wan. ");
INSERT INTO tsw_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","She yi paɗa lipu ɗu adama a na i ri e mesun mo ukwa̱ wan, ko i yuwan iɗana a̱ lipu ɗu wan. A̱mu ɗa A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","<<She vu lungusa̱ usheli wa̱ wu o ure u tsipere wan a̱vu ka̱mba̱to yi aashakala, na̱ ne ɗa shi iɗa'a i ta̱ ka̱mba̱ a tsushakala, a̱vu wo o'wo tapu ni iwuya. ");
INSERT INTO tsw_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","I toni urana wa Ashibi u va̱, waru i ca a̱a̱'isa̱ a̱ va̱ tsugbain. A̱mu ɗa A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","<<She i 'ya̱wa̱ uba̱ta̱ wa aza a na o ɓoloso aci na̱ ruhu va̱ a̱kwa̱kwa̱ ko yindi tsa̱ra̱ i zami a̱sa̱la̱ ko ikambishi ya̱'a̱ le wan. She i zami le wan ta̱wa̱ a̱ lungusa̱ ɗu wan. A̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","<<I ca za na ri na̱ yono na abara tsugbain adama a na yaa uwwusa wovon wa̱ A̱sula̱ a̱ ɗu. A̱mu ɗa A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","<<Na̱ mocin ri nden na̱ a̱ɗu e iɗa i ɗu, she i ɓongi yi wan. ");
INSERT INTO tsw_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","I ta yuwaan mocin na ri oɓolo na̱ a̱ɗu cine yaa yuwaan umatsun wi iɗa i ɗu. I ciga yi cine i cigai aciya̱ɗu, adama a na a̱ɗu fo omocin a ɗa i da̱na̱i a̱tsuma̱ a Masar. A̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","<<She i paala nanza ba̱ta̱ o uritosu wu uga'an e iɗa ko ume ko e ili ya̱ a̱bunda̱ wan. ");
INSERT INTO tsw_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","I yuwan ulinga ni ili yu uritosu u mejege, ni ili yu ume i mejege. Makundatsu ma na yoo rito ili yu u'yewu u da̱na̱ mejege. A̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu za na uta̱a̱ nɗu a̱tsuma̱ a Masar. ");
INSERT INTO tsw_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","I reve i toni ta̱ ili i na n dammai suru oɓolo na̱ wila̱ u va̱ suru, i toni le. A̱mu ɗa A̱sulazuva.>> ");
INSERT INTO tsw_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","A̱vu A̱sulazuva a yuwan adanshi na̱ Musa u damma, ");
INSERT INTO tsw_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","<<Damma aza a Isra'ila, suru za va Isra'ila ko mocin na ri na̱ nden a̱tsuma̱ e le za na cayi ko mawun ma̱ ta̱ a̱tsuma̱ a̱ muwun ma̱ yi a̱ tyo ya̱ a̱a̱ma̱li Mole, a ciga a 'yuwan o una yi. Ama a̱ lyuci'i a ta vuvara yi na atali. ");
INSERT INTO tsw_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","N ta yuwan tsurala na̱ vuma ndolo, waru n ta tawa yi a̱tsuma̱ ama a̱ yi. Adama a na u ca ta̱ mawun ma̱ ta̱ a̱tsuma̱ a̱ muwun ma̱ yi a̱ tyo ya̱ Mole. U ka̱mbuwa̱ ta̱ uba̱ta̱ wa akiza a̱ va̱ idaba, waru u tara ala a akiza a̱ va̱ ili ya̱ a̱ɓula̱ shi. ");
INSERT INTO tsw_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Na ama a̱ lyuci'i ene ta̱ ana u cayi mawun ma̱ ta̱ a̱tsuma̱ a̱ muwun ma̱ yi a̱ tyo ya̱ Mole reve a̱ rungwa̱, agba o una yi shi, ");
INSERT INTO tsw_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","to n ta yuwan tsurala na̱ vuma'a nu u'wa wa̱ yi. Waru n ta tawa u'wa̱ wa̱ yi nu ugundo wa̱ yi a̱tsuma̱ a ama e le, na̱ suru aza a na a yuwusan tsushakala oɓolo na̱ a̱yi a̱ tyo ya̱ Mole. ");
INSERT INTO tsw_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","<<N ta yuwan tsurala na̱ za na vadalai uba̱ta̱ u moɓolo ma aci no ozo o otoni, no oboci a yuwusan tsushakala uba̱ta̱ e itoni i le. Waru n ta tawa yi a̱tsuma̱ a ama a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","I tawa aciya̱ɗu waru yo o'wo aza a akiza, adama a na a̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","I guza̱ wila̱ u va̱ reve i kuru le. A̱mu ɗa A̱sulazuva, za na tawa nɗu na akiza. ");
INSERT INTO tsw_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","<<Suru za na isulai dada va̱ yi ko mma va̱ yi a ciga a 'yuwan o una yi, adama a na wi isula ta̱ dada va̱ yi ko mma va̱ yi. Ume wu mpasa ma̱ yi n ta̱ da̱na̱ a aci a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","<<Na̱ vuma yuwan tsipere na̱ ka moron ma̱ nden ma̱ yi, ele ra na a yuwain tsipere'e a ciga a 'yuwan o una le. ");
INSERT INTO tsw_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Na̱ vuma von na̱ ka va dada va̱ yi, u zuwa ta̱ dada va̱ yi o'wo ili i wono. Ele ra na a ciga a 'yuwan o una le, ume wu mpasa n le n ta̱ da̱na̱ a aci e le. ");
INSERT INTO tsw_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Na̱ vuma von na̱ jene va̱ yi, ele ra a ciga a 'yuwan o una le, adama a na a yuwan ta̱ ili yu uwuyanu, ume wu mpasa n le n ta̱ da̱na̱ a aci e le. ");
INSERT INTO tsw_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Na̱ vuma von na̱ za va̱ yi vali cine a̱ tsu von na̱ ka, ele ra a yuwan ta̱ ili yi idaba. Na a ciga a 'yuwan o una le, ume wu mpasa n le n ta̱ da̱na̱ a aci e le. ");
INSERT INTO tsw_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","<<Na̱ vuma zuwa usheli na̱ mma va̱ yi, a̱yi ndolo iwuya i ɗa. A̱yi ne ele ra a ciga a 'yuwan a̱ kuloto le a̱tsuma̱ akina, ta̱wa̱ she iwuya i da̱na̱ a̱tsuma̱ a̱ ɗu wan. ");
INSERT INTO tsw_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","<<Na̱ vuma yuwan tsipere na̱ nama a ciga a 'yuwan o una yi, reve fo o una nama'a. ");
INSERT INTO tsw_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Na̱ ka rawa zuzu na̱ nama adama u von na̱ a̱yi, a̱ to una ka'a oɓolo na̱ nama'a. A ciga a 'yuwan o una le, ume wu mpasa n le n ta̱ da̱na̱ a aci e le. ");
INSERT INTO tsw_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","<<Na̱ vuma tara mawun ma̱ a̱na̱wu ma̱ yi, mawun mo usheli ma dada va̱ yi ko mawun mo usheli ma mma va̱ yi, reve a yuwan tsipere, wo o'wo ta̱ ili yi izo'oshi. Na a ciga a 'yuwan a tawa le a̱ ma̱ka̱ka̱n ma ama e le. Adama a na u ca ta̱ zawa'a wono, waru ume wu mpasa ma̱ yi n ta a aci a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","<<Nna̱ vali von na̱ ka mantsa ma na we inda a̱shinda̱, u kpa̱tu'wa̱ ataɓu a̱ yi, waru a̱yi ka'a u kpa̱tu'wa̱ ta̱ ataɓu a mpasa ma̱ yi a alanga. Ele ra na a ciga a 'yuwan a tawa le a̱tsuma̱ a ama e le. ");
INSERT INTO tsw_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","<<She vu yuwan tsipere na̱ mawun ma̱ a̱na̱wu ma mma ko za va dada va̱ wu wan, adama a na a̱yi ndolo u ta zuwa yi wo o'wo ili yi izo'oshi, ele ra ume wu mpasa n le n ta̱ da̱na̱ a aci e le. ");
INSERT INTO tsw_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Nna̱ vuma von na̱ ka va dada ke'en va̱ yi, u ta̱wa̱a̱ ta̱ dada ke'en va̱ yi na̱ wono. Ume wu mpasa n le n ta̱ da̱na̱ a aci e le, ele ra a̱ ta̱ kuwa̱ babu mawun. ");
INSERT INTO tsw_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Nna̱ vuma zuwa ka mawun ma̱ a̱na̱wu ma̱ yi, a̱yi ndolo ili yi idaba i ɗa, u ta̱wa̱a̱ ta̱ mawun ma̱ a̱na̱wu ma̱ yi na̱ wono. A̱ ta̱ da̱na̱ babu mawun. ");
INSERT INTO tsw_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","<<I toni adanshi a̱ va̱ na̱ wila̱ u va̱ suru reve i kuru le, adama ta̱wa̱ iɗa i na ma̱a̱ tyowetyo ɗu i shaama ɗu wan. ");
INSERT INTO tsw_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","She i yuwan mmalu cine agadu e iɗa i na ma̱a̱ gba̱ra̱ a̱ ma̱ka̱ka̱n ma̱ ɗu a̱ ri wan, adama a na a yuwan ta̱ suru ili i nda, a̱yi ɗa i zuwai me inda idaba i le. ");
INSERT INTO tsw_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Amma n damma ɗu ta̱, i to o'wo na agadu e iɗa i le. N ta ca ɗu a̱yi agadu, iɗa i na yee yeneshe na̱ maani ni ishiki. A̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu za na tawa nɗu diga a akapi e elentsu. ");
INSERT INTO tsw_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","<<I ta kakasa inama i na i ri idaba na aza na a̱ ri idaba shi, na̱ nnunu n na n ri idaba na aza a na a̱ ri idaba shi. She yo o'woto aciya̱ɗu idaba o una̱ wu nama ko manunu wan, ko ili i ro i na i ri e ika̱ta̱pu e iɗa, aza a na n tawai a̱ ri idaba uba̱ta̱ u ɗu wan. ");
INSERT INTO tsw_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","I to o'wo aza a akiza ya̱'a̱ va̱, adama a na a̱mu A̱sulazuva, za va akiza ɗa. Waru n tawa ɗu ta̱ a̱tsuma̱ a akapi e elentsu adama yo o'wo a̱za̱ a̱ va̱. ");
INSERT INTO tsw_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","<<Vali ko ka na ri o ɓoloso aci na̱ ruhu va̱ a̱kwa̱kwa̱ ko yindi na a ciga a 'yuwan o una yi. A ta vuvara yi na atali, waru ume wu mpasa ma̱ yi n ta̱ da̱na̱ a aci a̱ yi.>> ");
INSERT INTO tsw_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Reve A̱sulazuva a damma Musa, <<Yuwan adanshi na̱ nan ganu, olobo a Haruna, vu damma le: She za ta̱ a̱tsuma̱ e le u ju'wa̱n a̱kwa̱kwa̱ a̱tsuma̱ a ama a̱ yi wan u ka̱mba̱to aciya̱yi ili i idaba. ");
INSERT INTO tsw_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","She maci va̱ yi i zuzu i ɗa goon wa̱a̱ ju'wa̱n, tsa mma va̱ yi, na̱ dada va̱ yi, nu ulobo wa̱ yi, ko usheli wa̱ yi na̱ mawun ma̱ a̱na̱wu ma̱ yi, ");
INSERT INTO tsw_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ko zakpara ko zawa'a va̱ yi vu ka za na koto revei vali shi, waru koto wo oloi shi za na ri e ekere a̱ yi, adama a̱ yi u ta gura ka̱mba̱to aciya̱yi ili yi idaba. ");
INSERT INTO tsw_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Waru she u ka̱mba̱to aciya̱yi ili yi idaba o una̱ u tsumaci tso lolo va̱ yi wan. ");
INSERT INTO tsw_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Nan ganu'u waru aa puna ogbondo shi, waru she e ye'we cin le, ko e ye'we ntsuka̱ n le wan, waru she a paɗa lipu le wan. ");
INSERT INTO tsw_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","A̱ ta̱ da̱na̱ aza a akiza e ekere a̱ A̱sula̱ e le waru a̱ ka̱mba̱to ala A̱sula̱ e le ili ye pere shi, adama a na ele ɗa aa casu A̱sulazuva kucci va akina, ilyalya ya̱ A̱sula̱ e le, adama o ndolo a 'yuwan a ciga a̱ da̱na̱ na akiza. ");
INSERT INTO tsw_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","She a zuwa ka na lungusa̱i aciya̱yi na̱ tsushakala wan. Ne ɗa waru a zuwa ka na kakasai na̱ vali va̱ yi wan, adama a nan ganu ama a akiza a ɗa e ekere a̱ A̱sula̱ e le. ");
INSERT INTO tsw_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","I tara nan ganu na akiza adama a na ele ɗa a tsu tara kucci vi ilyalya ɗu a ca A̱sula̱ a̱ ɗu. A̱ ta̱ da̱na̱ na akiza e ekere a̱ ɗu, adama a na a̱mu A̱sulazuva a̱ ɗu za na tsu zuwa ɗu aza a akiza, a̱mu akiza a ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Waru usheli wa ganu u na suru u lungusa̱i aciya̱yi wo o'woi ashakala, u ca ta̱ dada va̱ yi wono, a̱ ta̱ kula̱to yi na akina. ");
INSERT INTO tsw_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","<<Ganu gbain na ri zagbain a̱tsuma̱ a̱ a̱za̱ a̱ yi, za na a̱ tsuwa̱yin mani'in a aaci a̱ yi, waru za na a cayi ucira wo oto utugu u tsuganu waa lyawa a̱nji a̱ yi iwa̱u shi ko wu kara a̱tugu a̱ yi shi. ");
INSERT INTO tsw_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Waa rawa uba̱ta̱ u na a̱kwa̱kwa̱ a̱ ri shi tsa̱ra̱ u ka̱mba̱to aciya̱yi ili yi idaba wan, ko adama a mma va̱ yi ɗa ko dada va̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Woo uta̱ u lyawa uba̱ta̱ wa akiza shi. Adama u ka̱mba̱to a̱a̱'isa̱ a̱ A̱sula̱ a̱ yi idaba wan, adama a na a tawa yi ta̱ o ure wu utsusun u mani'in wa̱ A̱sula̱ a̱ yi. A̱mu ɗa A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","U zuwa ka na koto revei vali shi. ");
INSERT INTO tsw_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Waa zuwa ka na vali va̱ yi kuwa̱i ko ka na kakasai na̱ vali va̱ yi ko ka na lungusa̱i aciya̱yi a tsushakala shi. Agba u zuwa ka diga a̱tsuma̱ a ama a̱ yi za na koto revei vali shi, ");
INSERT INTO tsw_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","tsa̱ra̱ u lungusa̱ muwun mu ugundo ma̱ yi a̱tsuma̱ a ama a̱ yi wan. A̱mu ɗa A̱sulazuva za na ka̱mbuwa̱ niyi za va akiza.>> ");
INSERT INTO tsw_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Reve A̱sulazuva a damma Musa, ");
INSERT INTO tsw_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","<<Vu yuwan adanshi na̱ Haruna, vu damma yi, diga gogo hali a̱ tyo mantsa me elime ko za a̱tsuma̱ o ugundo wa̱ wu za na ri na̱ mɓa̱la̱ aa lyawa yi u rawa zuzu u ca kucci vi ilyalya ya̱ A̱sula̱ a̱ yi shi. ");
INSERT INTO tsw_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Adama a na vuma na ri na̱ mɓa̱la̱ suru wu ntsaa u rawa zuzu shi: irumba̱ ko a̱a̱kutsuma̱, ko za na utsuvu ko vunu ko urewesu wa̱ yi u ri dere shi ko za na ri danguɗu danguɗu, ");
INSERT INTO tsw_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ko vuma na ri nu ukuɗu a anana ko o ukere, ");
INSERT INTO tsw_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ko vuma na ri no oboto o ucina̱ ko mokoɗi ma vuma ko vuma na ri na̱ da'un a̱ lyusu ko za na ri na̱ mɓa̱la̱ mi ikavuru ko za na ri na ajakata ko za na o foɗoi arawa. ");
INSERT INTO tsw_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","She za diga o ugundo wa Haruna ganu na ri na̱ mɓa̱la̱ u ta̱wa̱ zuzu na waa ca A̱sulazuva kucci va akina wan, adama a na u ri usa̱du. She u rawa zuzu na waa ca kucci vi ilyalya ya̱ A̱sula̱ a̱ yi wan. ");
INSERT INTO tsw_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","U ta gura tama opopofu a̱ A̱sula̱ a̱ yi, a na a la'ai akiza ni ilyalya ya akiza waru. ");
INSERT INTO tsw_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Agba she u rawa zuzu nu umuna ko masa'a wan, adama a na u ri usa̱du, adama u lungusa̱ uba̱ta̱ wa akiza a̱ va̱ wan. Adama a na a̱mu ɗa A̱sulazuva a na a̱ ka̱mba̱to niyi za va akiza.>> ");
INSERT INTO tsw_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Ne ɗaɗa gba Musa yuwain adanshi na̱ Haruna no olobo a̱ yi, na ama a Isra'ila suru. ");
INSERT INTO tsw_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Reve A̱sulazuva a yuwan adanshi na̱ Musa, ");
INSERT INTO tsw_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","<<Vu damma Haruna no olobo a̱ yi a̱ guza̱ ili ya akiza ya ama a Isra'ila i na a ca numu ulobonu tsa̱ra̱ a̱ lungusa̱ ala a̱ va̱ wan. A̱mu ɗa A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Vu damma le, <Nna̱ za ta̱ a̱tsuma̱ a̱ muwun mu ugundo n ɗu diga gogo hali a̱ tyo mantsa me elime u rawa zuzu ni ili ya akiza i na ama a Isra'ila a cayi A̱sulazuva a̱yi na̱ nshinda̱, a ta tawa vuma ndolo a̱ ma̱ka̱ka̱n ma̱ va̱. A̱mu ɗa A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Nna̱ a̱tsuma̱ o ugundo wa Haruna vuma ro ri na̱ mɓa̱la̱ mu ukwan u lipu ko u ri a̱ ma̱ɗa̱wa̱ waa lyuwa ili ya akiza shi, she na̱ wo o'wo cece. Ne ɗa fo nu u ju'wa̱n ili suru i na i ri idaba ya̱ a̱a̱kwa̱kwa̱ ko vuma na tsali tso ocoi u to o'wo idaba. ");
INSERT INTO tsw_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Waru ne ɗa, za na ju'wa̱in ili i na i ri e ika̱ta̱pu suru i na yaa zuwa yi wo o'wo ili yi idaba. Ko vuma na zuwa niyi wo o'woi idaba, a̱yi fo u to o'wo ili yi idaba. ");
INSERT INTO tsw_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Za na ju'wa̱in cu'un vi ili i ndolo suru u to o'wo idaba hali ulivu, waru waa lyuwa ilyalya ya akiza shi she nu u sumba̱. ");
INSERT INTO tsw_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Nu urana u riya̱ ɗaɗa woo o'wo cece, diga lo u ta gura lyuwa ilyalya ya akiza, adama a na ilyalya ya̱ yi i ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Waa tama ili i na i kuwa̱yi aciya̱yi shi, ko ili i na inama yu una yi karai shi. Ele nda a ta zuwa yi wo o'wo idaba. A̱mu ɗa A̱sulazuva.> ");
INSERT INTO tsw_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","<<A yuwan tsutoni ni ili i na n damma nle adama o ronoo aciyele unusu ta̱wa̱ a̱ kuwa̱ o una̱ u na a 'yuwain a yuwan tsutoni wan. A̱mu ɗa A̱sulazuva za na o'woto nle na akiza. ");
INSERT INTO tsw_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","<<Vuma na ri a̱tsuma̱ o ugundo wa ganu shi, waa lyuwa ilyalya ya akiza shi. Waru mocin va ganu ko za zamalinga waa lyuwa ilyalya ya akiza shi. ");
INSERT INTO tsw_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Amma nna̱ ganu tsula ta̱ aagbashi ni ikebe, aagbashi'i u ta gura lyuwa ilyalya'a. Waru za na a matsain a̱tsuma̱ o u'wa wa̱ yi u ta gura lyuwa ilyalya'a. ");
INSERT INTO tsw_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Nnu usheli wa ganu wo olo vuma na ri ganu shi, waa lyuwa a̱tsuma̱ e ili ya akiza i na a̱ tafai shi. ");
INSERT INTO tsw_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Amma nnu usheli wa ganu za na o'woi ma̱runa̱ ko wu uta̱i lolo waru u ri na̱ mawun shi, reve u ka̱mba̱ o u'wa wa dada va̱ yi, a̱yi ubuwu yawa, u ta gura lyuwa ilyalya ya dada va̱ yi. Vuma na ri ganu shi, ko cine a yuwain waa lyuwa ilyalya'a shi. ");
INSERT INTO tsw_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Waru na̱ za lyuwa ilyalya ya akiza a̱tsuma̱ o unusu, u ta̱ ka̱mbuwa̱a̱ ganu ili i na u lyuwai'i reve u da̱shi za ta̱ a̱tsuma̱ o ozo o ton wa̱ a̱bunda̱ e ili'i. ");
INSERT INTO tsw_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","She nan ganu aa tara ilyalya ya akiza i na ama a Isra'ila a̱ ta̱wa̱yi A̱sulazuva ili yi idaba wan. ");
INSERT INTO tsw_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Na a lyawa vuma na ntsayi shi u lyuwa ilyalya ya akiza u ta̱ ta̱wa̱a̱ le nu unusu u na woo ronoo le uge'etosu, adama a na a̱mu ɗa A̱sulazuva za na ka̱mba̱to nle na akiza.>> ");
INSERT INTO tsw_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Reve A̱sulazuva a yuwan adanshi na̱ Musa, ");
INSERT INTO tsw_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","<<Vu yuwan adanshi na̱ Haruna no olobo a̱ yi na ama a Isra'ila suru, vu damma le, na̱ za suru a̱tsuma̱ o u'wa wa ama a Isra'ila ko mocin na ri nden a̱tsuma̱ a ama a Isra'ila ta̱wa̱a̱ na̱ kucci vu ukula̱tosu e ekere a̱ A̱sulazuva, ko o shiton akucunu ko kucci vu ucigu wo okolo, ");
INSERT INTO tsw_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","nnu u ciga a̱ ushi kucci va̱ yi, u ta̱wa̱a̱ na̱ no oogono a nan ko kyon ko megbele ma na ma̱ ri usa̱du shi. ");
INSERT INTO tsw_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","She i ca kucci na ri na̱ usa̱du wan, adama a na a̱a̱ ushiya̱ ɗu a̱yi shi. ");
INSERT INTO tsw_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Na̱ vuma ta̱wa̱a̱ A̱sulazuva kucci muwwulai adama u shiton nzuwulai ko kucci vu ucigu wo okolo diga o oɓolo e inan ko oɓolo e ikyon ko o oɓolo e mgbele, na a 'yuwan a ciga u ca nama na ri gbaga, za na ri usa̱du shi. ");
INSERT INTO tsw_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","She a ca A̱sulazuva kucci vu nama na ri ne esu shi wan, ko za na ri ukuɗu wan, ko za vu usa̱du wan, ko za na ri na̱ wuntsu a̱ lipu wan ko za na ri nu ukparu wan. She a yuwan kucci vu ukula̱tosu na̱ cu'un vi iliyamunga i ndolo a masa'a wan. ");
INSERT INTO tsw_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","A ta gura ca oogono a nan ko kyon aza a na pasu lipu le a̱ ri usa̱du kucci vu ucigu wo okolo. Agba aa ca le adama a̱ kucci vu ushitosun wa akucunu shi. ");
INSERT INTO tsw_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Yaa ca A̱sulazuva nama na a̱ kula̱i ko o ɓosoi, ko a ɓatsai, ko o foɗoi arawa shi. Yaa yuwan ne e iɗa i ɗu shi. ");
INSERT INTO tsw_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ne ɗa gba waru ya̱a̱ ushi icu'un yi iliyamunga i ndolo e ekere o mocin, reve i ca A̱sula̱ a̱ ɗu kucci vi ilyalya shi. A̱a̱ ushiya̱ ɗu ele shi adama a na a ntsaa a yuwan kucci ne ele shi, adama a na a̱ ri usa̱du waru a̱ ta̱ na̱ mɓa̱la̱ a̱ lipu le.>> ");
INSERT INTO tsw_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Reve A̱sulazuva a damma Musa a na, ");
INSERT INTO tsw_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","<<Nna a matsan moggono ma nan ko mo kyon ko me megbele, u ta̱ da̱na̱ oɓolo na̱ mma va̱ yi hali rana cindere, o urana wa̱ kunla̱ a̱ tyo elime a̱ ta̱ ushi yi kucci na aa yuwaan A̱sulazuva va akina. ");
INSERT INTO tsw_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Agba yaa paɗa nan ko kyon urana u ta̱ na̱ mawun ma̱ yi shi. ");
INSERT INTO tsw_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Waru na̱ yaa casu kucci vu ugodyusho e ekere a̱ A̱sulazuva, i ca yi cine a̱ ushiya̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","A ta tama yi a̱ a̱tsuma̱ o urana u ta̱, yaa lyawa ili i pasa a̱ tyo usana u ro shi. A̱mu ɗa A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","<<Adama o ndolo i guza̱ ili i na n damma nɗu waru i yuwan le. A̱mu ɗa A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Waru she i ka̱mba̱to ala a akiza a̱ va̱ ili ye pere wan, agba a̱ɗu ama a Isra'ila i zuwa ala a̱ va̱ a̱ da̱na̱ na akiza. A̱mu ɗa A̱sulazuva za na ka̱mba̱to nɗu aza a akiza. ");
INSERT INTO tsw_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","A̱mu ɗa mu uta̱a̱ nɗu diga a̱tsuma̱ e iɗa ya Masar adama mo o'wo A̱sula̱ a̱ ɗu. A̱mu ɗa A̱sulazuva.>> ");
INSERT INTO tsw_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Reve A̱sulazuva a yuwan adanshi na̱ Musa, ");
INSERT INTO tsw_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","<<Vu yuwan adanshi na ama a Isra'ila, vu damma le: Ele nda ele ɗa a̱buki a na n zuwai, a̱buki a na A̱sulazuva a zuwai a na a cuɗuwa a mantsa me iɓolo ya akiza ya aza a Isra'ila. ");
INSERT INTO tsw_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","<<A ta yuwan ulinga a̱tsuma̱ a rana ta̱li, agba urana wa̱ cindere, urana u wivuwun la̱nga̱ ɗa. Urana u ɗa a na aa yuwan iɓolo ya akiza. Uba̱ta̱ u na i ri suru yaa yuwan ulinga a̱tsuma̱ o urana u ndolo shi ko ke'en, adama a na urana wa Ashibi u ɗa e ekere a̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","<<Ele nda ele ɗa a̱buki a na A̱sulazuva a zuwai iɓolo ya akiza. A ta saala ama a Isra'ila ele a mantsa ma na a zuwa nle: ");
INSERT INTO tsw_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","O urana wa kupa na̱ a̱za̱ a̱ na̱shi a̱tsuma̱ o woto wu ufaru nu ulivu ɗaɗa ee teme mayan ma̱ A̱buki a Mapasa ma̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Reve o urana u kupa no ozo ton o woto'o i yuwaan A̱sulazuva a̱buki o Opopofu a na a̱ ri na̱ Wolilo shi. I ta yuwan rana cindere a tamusa Opopofu a na a̱ ri na̱ Wolilo'o shi. ");
INSERT INTO tsw_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","O urana wu ufaru wa̱ a̱buki'i i ta yuwan iɓolo ya̱ a̱ga̱nda̱ ya akiza. Yaa yuwan linga va ana'an na̱ nfa'an shi. ");
INSERT INTO tsw_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Agba i ca A̱sulazuva kucci vu ukula̱tosu hali rana cindere. O urana wa̱ cindere u ɗa yaa yuwan iɓolo ya akiza. A̱tsuma̱ o urana u nda yaa yuwan linga ɗu va ana'an na̱ nfa'an shi.>> ");
INSERT INTO tsw_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Reve A̱sulazuva a yuwan adanshi na̱ Musa, ");
INSERT INTO tsw_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","<<Vu yuwan adanshi na ama a Isra'ila vu damma le: Nni i ta̱wa̱ a̱tsuma̱ e iɗa i na maa ca ɗu, waru ni i yuwan ugasa, i tara aakatalu a̱tsuma̱ e itana yu una i na i fara inai i 'ya̱wa̱a̱ ganu. ");
INSERT INTO tsw_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Ganu'u u ta ca A̱sulazuva aakatalu'u kucci vu u'ya̱susa̱n o una̱ u ɗu tsa̱ra̱ a̱ usu ɗu. Ganu'u u ta̱ 'ya̱sa̱n yi nu usana u tawa o urana u na u kuruyi urana wa Ashibi. ");
INSERT INTO tsw_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Waru o urana u na a cayi kucci vu u'ya̱susa̱'a̱n i ta ca ma̱giri'i ma na ma̱ ri na aa'wan a̱ ta̱, za na ri usa̱du shi adama a ca A̱sulazuva kucci vu ukula̱tosu. ");
INSERT INTO tsw_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Oɓolo na̱ ma̱giri'i'i, i ta ca kucci vi ishina makundatsu ure u efa u yira i lashi a̱tsuma̱ a kupa i na a̱ ja̱mba̱ra̱i na̱ mani'in ma̱ zetun, a ca A̱sulazuva kucci vi ilyalya i ma̱guru, agba kucci vi ili yo oso u da̱na̱ magasutsu ma̱ ta̱ ma masayan ma̱ ina̱bi. ");
INSERT INTO tsw_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Waru yaa tama opopofu ko ishina i na a̱ zuyin ko ishina i sa'avu shi. She urana u na i ta̱wa̱yi A̱sula̱ a̱ ɗu na̱ kucci nda. A̱yi nda wila̱ u ɗa u na ya̱a̱ guza̱ hali a̱ tyo a̱ muwun mu gundo ɗu uba̱ta̱ u na i da̱nuyi biti. ");
INSERT INTO tsw_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","<<I kece ajuma e cindere cip cip cip diga o urana u na u kuruyi Ashibi, urana u na i ta̱wa̱i na aakatalu a̱ kucci vu u'ya̱susa̱n. ");
INSERT INTO tsw_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","I kece rana kupoton a̱ca̱pa̱ a Ashibi a ajuma e cindere'e, reve i ca A̱sulazuva kucci vi ishina i sa'avu. ");
INSERT INTO tsw_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Uba̱ta̱ u na i ri nden suru i ta̱wa̱a̱ no opopofu e re a na aa ca A̱sulazuva kucci vu u'ya̱susa̱n. A yuwan opopofu suru na̱ makundatsu ure u efa ma yira i lashi a̱tsuma̱ a kupa na̱ wolilo, reve a ca A̱sulazuva kucci vu umatsun wu ufaru. ");
INSERT INTO tsw_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","I ta ca mugiri'i n cindere oɓolo no opopofu'u, aza a na a̱ ri na aa'wan a̱ ta̱ ta̱ waru a̱ ri usa̱du shi oɓolo na̱ moggono ma nan na̱ a̱giri'i e re. A ta ca A̱sulazuva ele kucci vu ukula̱tosu oɓolo na̱ kucci vi ishina na̱ kucci vi ili yo oso, kucci na a yuwain na akina ili i ma̱guru mo uyo'o e ekere a̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Waru i ta ca ma̱ga̱ji adama a̱ kucci vu unusu na̱ mugiri'i n re aza a na a̱ ri na aa'wan a̱ ta̱ ta̱ kucci muwwulai. ");
INSERT INTO tsw_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Ganu ta̱ 'ya̱sa̱n mugiri'i n re'e a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva kucci vu u'ya̱susa̱n oɓolo no opopofu o umatsun wu ufaru. O to o'wo ili ya akiza e ekere a̱ A̱sulazuva, reve o o'wo aza a ganu. ");
INSERT INTO tsw_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","O urana u ndolo a ta saala iɓolo ya akiza i ɗa. Yaa yuwan linga ɗu va na'an na̱ nfa'an shi. A̱yi nda u to o'wo ɗu wila̱ uba̱ta̱ u na i da̱nuyi suru hali a̱ tyo a̱ muwun mu gundo n ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","<<Waru mantsa ma na i ri o ugasa, she i yuwan ugasa hali a̱ tyo a̱ nge'en ma̱ a̱ɗuma̱'a̱ wan. Waru yaa yuwan u'yanlu shi. I lyawa u'yanlu adama a alambi no omocin. A̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu.>> ");
INSERT INTO tsw_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Reve A̱sulazuva a yuwan adanshi na̱ Musa, ");
INSERT INTO tsw_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","<<Vu damma ama a Isra'ila: O urana wu ufaru u woto we cindere, i yuwan wivuwun wu urana la̱nga̱ adama a na urana u ɗa wu ucuwusan na̱ wivulu wa avana iɓolo ya akiza. ");
INSERT INTO tsw_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Yaa yuwan ulinga u ɗu wa ana'an na̱ nfa'an shi, agba i ca A̱sulazuva kucci na a yuwain na akina.>> ");
INSERT INTO tsw_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Reve A̱sulazuva a yuwan adanshi na̱ Musa, ");
INSERT INTO tsw_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","<<Urana wa kupa u woto we cindere, Urana u Matara mo ume mo Unusu ma ɗa. U to o o'wo ɗu urana wi iɓolo wa akiza. She i lyuwa ilyalya o urana'a wan, reve i ca A̱sulazuva kucci na a yuwain na akina. ");
INSERT INTO tsw_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Waru yaa yuwan ulinga a̱tsuma̱ o urana u ndolo shi, adama a na Urana u ɗa u Matara mo ume mo Unusu, na aa ca kucci adama a matara mo ume mo unusu u ɗu a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva A̱sula̱ a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Za na suru lyuwai ilyalya o urana u ndolo a ta tawa yi a̱tsuma̱ a ama a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Waru za na suru yuwain ulinga o urana u ndolo, n to kototo vuma ndolo a̱tsuma̱ a ama a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Yaa yuwan ulinga shi suru suru. Wila̱ u ɗa u na ya̱a̱ guza̱ hali a̱ tyo a̱ muwun mu gundo n ɗu uba̱ta̱ u na i da̱nu yi suru. ");
INSERT INTO tsw_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","U to o o'wo ɗu Urana wa Ashibi u na yee ivuwan waru yaa lyuwa ilyalya shi. Diga o ulivu wu urana wa̱ kucci u woto'o hali a̱ tyo o ulivu wu urana wa kupa i cuwan a na Ashibi a ɗa.>> ");
INSERT INTO tsw_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Reve A̱sulazuva a yuwan adanshi na̱ Musa, ");
INSERT INTO tsw_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","<<Vu yuwan adanshi na ama a Isra'ila vu damma, o urana u kupa no ozo o ton u woto we cindere u nda u ɗa A̱buki o Ogodo o Ucuwusan a̱ A̱sulazuva ee teme. Waru u ta tara rana cindere ");
INSERT INTO tsw_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Urana wu ufaru u to o o'wo iɓolo ya akiza. She i yuwan ulinga wa ana'an na̱ nfa'an wan. ");
INSERT INTO tsw_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","I ta ca A̱sulazuva kucci na a yuwain na akina rana cindere. Reve o urana wa̱ kunla̱ i yuwan a̱buki a akiza waru i ca A̱sulazuva kucci na a yuwain na akina. A̱yi nda u to o o'wo ɗu iɓolo ya akiza, she i yuwan ulinga wa ana'an na̱ nfa'an wan. ");
INSERT INTO tsw_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","<<Ele nda ele ɗa a̱buki a̱ A̱sulazuva aza a na a zuwaa nɗu ana ya̱a̱ da̱na̱ a yuwusan, aza a na ya̱a̱ da̱na̱ a yuwusan mantsa me iɓolo ya akiza na ya̱a̱ da̱na̱ a casu A̱sulazuva kucci va akina, kucci vu ukula̱tosu, na̱ kucci vi ishina na̱ nan kucci waru i ta ca kucci vo oso vu urana suru. ");
INSERT INTO tsw_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","A̱buki a nda a̱ ta̱ a̱tsuma̱ o uda̱shiyi wa̱ a̱buki o urana wa Ashibi na̱ a̱buki a̱ ne'e na̱ a̱buki a̱ kucci va akucunu na̱ a̱buki a̱ kucci vu ucigu wo okolo na yaa ca A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","<<Adama o ndolo urana wa kupa no ozo o ton u woto we cindere, a mantsa ma na i ɓolotoi itana ya̱ a̱ɗuma̱ a̱ ɗu, reve i yuwan a̱buki o urana we cindere wa̱ A̱sulazuva. Urana wu ufaru urana u wivuwun u ɗa, waru urana wa̱ kunla̱ fo urana u wivuwun u ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","O urana wu ufaru u ɗa yaa lyuwa umatsun vu ɗanga sa'ani, reve i gasa ashiwashiwa oɓolo ne eten a ɗanga na ri na̱ a̱vu'un lon, reve i yuwan ma̱za̱nga̱ a̱ ma̱ka̱ka̱n ma A̱sulazuva A̱sula̱ a̱ ɗu hali rana cindere. ");
INSERT INTO tsw_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","I ta yuwaan A̱sulazuva a̱buki a nda hali rana cindere a̱tsuma̱ a aa'wan suru. Wila̱ u ɗa u na ya̱a̱ guza̱ hali a̱ tyo a̱ muwun mu gundo ɗu. O woto wa̱ cindere u ɗa yaa yuwan a̱buki'i. ");
INSERT INTO tsw_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","I da̱nu a̱tsuma̱ o ogodo a̱ ɗu hali rana cindere. Ne ɗa fo umatsun wa Isra'ila suru a̱a̱ da̱nu o ogodo e le. ");
INSERT INTO tsw_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Ne ɗa muwun mu ugundo n ɗu mee reve a na a̱mu ɗa n zuwai ama a Isra'ila a̱ da̱nu a̱tsuma̱ o ogodo e le a mantsa ma na mu uta̱a̱ nle a̱tsuma̱ e iɗa ya Masar. A̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu.>> ");
INSERT INTO tsw_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ne ɗa Musa cuɗuwai ama a Isra'ila a̱buki a nda a na A̱sulazuva a zuwayi ama a Isra'ila. ");
INSERT INTO tsw_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Reve A̱sulazuva a yuwan adanshi na̱ Musa, ");
INSERT INTO tsw_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","<<Vu zuwa ama a Isra'ila a̱ ta̱wa̱a̱ wu na̱ mani'in ma̱ Zetun can adama a fitila tsa̱ra̱ a zuwa fitila'a u da̱na̱ a madala. ");
INSERT INTO tsw_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Haruna ta zuwa fitila'a elime o umuna u gbain u na u palai Oogodo o Uga'asusan. U ta̱ da̱na̱ a lapulusa ifitila'a diga ulivu a̱ tyo usana a̱ 'ya̱wa̱. Wila̱ u ɗa u na woo koto shi diga gogo hali a̱ tyo a̱ muwun mu ugundo n ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","A̱yi ɗa wa̱a̱ da̱na̱ a̱ ka̱lyuwusa̱ ifitila'a a wisawatan u zinariya can a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva kuci. ");
INSERT INTO tsw_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","<<I kene yira i lashi reve i yuwaan opopofu kupa ne ejere na̱ a̱yi. Opopofu suru u lyuwa yira i na i ri ume u makundatsu u re u efa u yira i lashi a̱tsuma̱ a kupa. ");
INSERT INTO tsw_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Reve vu gere le udaru u re, o udaru suru vu zuwa a̱kutsu a̱ ta̱li zuva va apada a zinariya can na ri a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Reve vu tsun ili i ma̱guru o udaru suru adama wo o'wo kucci vu ucuwusan o una̱ wo opopofu'u, waru wo o'wo kucci na a cayi A̱sulazuva va akina. ");
INSERT INTO tsw_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","O urana wa Ashibi suru Haruna gere le a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva o una̱ wa aza a Isra'ila, akucunu a aza a Isra'ila a na a̱ ri n koto shi. ");
INSERT INTO tsw_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Opopofu'u o to o'wo aza a Haruna no olobo a̱ yi, waru a ta tama le pe uba̱ta̱ wa akiza adama a na akunda e le ɗa a na a la'ai akiza a̱tsuma̱ a̱ kucci va akina a na a cayi A̱sulazuva.>> ");
INSERT INTO tsw_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Urana u ro a̱vu ulobo wu ka va Isra'ila za na dada va̱ yi za vi iɗa va Masar ɗa, u ka̱ra̱ o uta̱ oɓolo na ama a Isra'ila. Reve ulobo'o na̱ vuma va Isra'ila'a a yuwan nla̱ngi o uva̱la̱ta̱ wa ama a Isra'ila. ");
INSERT INTO tsw_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","A̱vu ulobo wu ka va Isra'ila'a u yuwan unusu u gbain na Ala a̱ A̱sulazuva. Reve a̱ ta̱wa̱to yi uba̱ta̱ wa Musa. (Aala a mma va̱ yi a ɗa Shelomi usheli wa Dibiri o ugundo wa Dan.) ");
INSERT INTO tsw_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Reve a̱ ɓa̱ru yi uba̱ta̱ u ro, hali she ne ee reve ili i na A̱sulazuva aa damma a alanga eteshe. ");
INSERT INTO tsw_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Reve A̱sulazuva a yuwan adanshi na̱ Musa u damma: ");
INSERT INTO tsw_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","<<Vu uta̱a̱ na̱ vuma na yuwain unusu u gbai'in diga o uva̱la̱ta̱ u ɗu. Reve vu zuwa ama suru a na a uwwai ili i na u dammai a̱ kuruwa̱ yi ekere a aaci. Reve a zuwa ama'a suru a vara yi na atali. ");
INSERT INTO tsw_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Reve vu damma ama a Isra'ila a na: Vuma na suru yuwain adanshi isulai A̱sula̱ a̱ yi, u ta tara ume wu unusu wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Vuma na yuwain unusu u gbain na ala A̱sulazuva suru amayun a̱ to una yi. Oɓolo a ama a ta vuvara yi na atali ko na̱ mocin ɗa ko umatsun wi iɗa nu u yuwaan Ala'a unusu u gbain na amayun a̱ to una yi. ");
INSERT INTO tsw_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","<<Waru za na unai vuma suru, na amayun a̱yi fo a̱ to una yi. ");
INSERT INTO tsw_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Za na waru suru unai iliyamunga yi za ro, u ta̱ ka̱mbuwa̱ iliyamunga, wuma o una̱ u wuma. ");
INSERT INTO tsw_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Vuma na waru amaton yi moron ma̱ nden ma̱ yi suru, cine u yuwaan niyi ne ɗa fo a yuwaan yi. ");
INSERT INTO tsw_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Nu u kuɗa yi ta̱ eetele, a̱yi fo a ta kuɗa yi eetele. Nnu u foɗo yi lyusu, a̱yi fo o to foɗo yi lyusu. Nnu u mula̱ yi anga, a̱yi fo a̱ ta̱ mula̱ yi anga. Cine wa amaton niyi, ne ɗa fo aa amaton yi. ");
INSERT INTO tsw_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Za na unai iliyamunga suru, u ta̱ ka̱mbuwa̱ za ro. Waru za na unai vuma suru, a̱yi fo a̱ to una yi. ");
INSERT INTO tsw_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Wila̱ꞌa̱ u te reme mocin nu umatsun wi iɗa'a, a̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu.>> ");
INSERT INTO tsw_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Reve Musa yuwan adanshi na ama a Isra'ila. A̱vu o uta̱a̱ vuma na yuwain adanshi o unusu u gbain o uva̱la̱ta̱'a̱, reve a vara yi na atali. Ama a Isra'ila a yuwan ta̱ cine A̱sulazuva a dammai Musa. ");
INSERT INTO tsw_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Reve A̱sulazuva a yuwan adanshi na̱ Musa a Masasan ma Sinai, u damma, ");
INSERT INTO tsw_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","<<Vu yuwan adanshi na ama a Isra'ila, vu damma le, nni i uwa a̱tsuma̱ e iɗa i na maa ca ɗu, iɗa'a na aciya̱yi u toni wila̱ u wivuwun wa̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","I cu'wa̱n a̱ɗuma̱ a̱ ɗu a'wan a̱ ta̱li, waru i lapula a̱ɗuma̱ a̱ ina̱bi a̱ ɗu a'wan a̱ ta̱li'i, reve i ɓoloto matsun le. ");
INSERT INTO tsw_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Agba aa'wan e cindere u to o'wo aa'wan a̱ wivuwun e iɗa'a, wivuwun wa̱ A̱sulazuva. Ya̱a̱ cu'wa̱n a̱ɗuma̱ ɗu shi waru yaa lapula ɗanga ina̱bi ɗu shi. ");
INSERT INTO tsw_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Waru yaa gasa a̱ta̱pa̱shi shi, waru yaa ta'an umatsun wa̱ a̱ɗuma̱ a̱ ina̱bi a̱ ɗu a na i lapulai shi. Aa'wan o ndolo u to o'wo aa'wan a̱ wivuwun wi iɗa. ");
INSERT INTO tsw_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ili i na iɗa'a yaa matsan a aa'wan a̱ wivuwun u to o'wo ɗu ilyalya, a̱ɗu na agbashi a̱ ɗu a̱ma̱ci na ali, hali fo na aza a zamalinga a̱ ɗu no omocin a na a̱ ri nden oɓolo na̱ a̱ɗu, ");
INSERT INTO tsw_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","hali fo ni inan i ɗu hali na̱ inama yu una i na i ri a̱tsuma̱ e iɗa i ɗu. Ili i na i kungwai e iɗa'a suru o to o'wo ilyalya. ");
INSERT INTO tsw_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","<<I kece a'wan e cindere a̱ wivuwun, a'wan e cindere udoɓonu toto ucindere'e, u to o'wo a'wan a̱ wivuwun amunga na̱ kucci. ");
INSERT INTO tsw_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Reve o urana wa kupa u woto we cindere yi ivula̱ aavana. O urana u kucci matara mo ume mo unusu yi ivula̱ aavana a̱tsuma̱ e iɗa i ɗu ma̱ɓula̱. ");
INSERT INTO tsw_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Reve i tawa aa'wan a kupoton na akiza, reve a lapa ulingi u na woo roco a na ama o o'woi fa̱a̱n a̱tsuma̱ e iɗa i ɗu nu uba̱ta̱ a̱ nden n ɗu suru. U to o'wo ɗu aa'wan a na ama o o'wo fa̱a̱n. Vuma suru ta̱ ka̱mba̱ e itana ya agadu yu umatsun wa̱ yi. Waru vuma suru ta̱ ka̱mba̱ a̱tsuma̱ o umatsun wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Aa'wan a kupoto'on u to o'wo ɗu aa'wan a̱ a̱buki o uka̱mbusa̱ fa̱a̱n. A̱tsuma̱ a aa'wan o ndolo, ya̱a̱ cu'wa̱n shi waru yaa gasa a̱ta̱pa̱shi shi waru yoo ɓoloto umatsun wa̱ ina̱bi u na a̱ kuɗa̱i a lapula shi. ");
INSERT INTO tsw_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Adama a na aa'wan a̱ a̱buki o uka̱mbusa̱ fa̱a̱n ɗa waru i tara yi na akiza. A̱ta̱pa̱shi a ɗa goon yaa lyuwa. ");
INSERT INTO tsw_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","<<A̱tsuma̱ a Aa'wan a̱ A̱buki a nda, za suru a̱tsuma̱ a̱ ɗu u ka̱mba̱ uba̱ta̱ e itana ya̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Waru na̱ vu winaa za va̱ wu iɗa yi cimba, ko vu tsula e ekere a̱ yi, she i paalulai wan. ");
INSERT INTO tsw_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Na̱ vaa tsula iɗa e ekere a za va̱ wu, vu ta tsupa o una̱ wa̱ a̱bunda̱ a a'wan a na a̱ ri a̱ca̱pa̱ kafu a̱buki'i, waru u ta winaa wu o una̱ wa̱ a̱bunda̱ a a'wan a na a buwai a̱ tyo o ugasa. ");
INSERT INTO tsw_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Nna̱ a'wan a buwa a̱bunda̱, vu da̱shi a̱bunda̱ e ikebeꞌe. Agba nna̱ a'wan a buwa a̱bunda̱ shi, vu jebe ikebeꞌe. Adama a na ili i na waa winasa wu o una̱ wa̱ a̱bunda̱ e itana yu uɗuma̱ i ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","She i paalulai wan, amma yu uwwa wovon wa A̱sula̱ a̱ ɗu, adama a na a̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","<<Adama o ndolo i yuwan ili i na n damma nɗu waru i kuru wila̱ u na n zuwaa nɗu adama i yuwan nden n lafiya a̱tsuma̱ e iɗa'a. ");
INSERT INTO tsw_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Iɗa'a i ta matsan ulobonu, i ta lyuwa i cuwa̱n, waru i ta̱ da̱nu gbaga. ");
INSERT INTO tsw_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Agba nni i damma, <Nye tsaa lyuwa a̱tsuma̱ a aa'wan e cindere'e na̱ tsu cu'wa̱n shi waru tsaa gasa itana yu uɗuma̱ shi?> ");
INSERT INTO tsw_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","I reve gba, n ta zuwaa ɗu aba'un a̱ va̱ a̱tsuma̱ a aa'wan a̱ ta̱li, adama iɗa'a i matsan ulobonu i na yaa lyuwa hali a'wan a ta'atsu. ");
INSERT INTO tsw_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Nni i yuwan ca̱'a̱n a aa'wan a̱ kunla̱, i ta̱ da̱na̱ a lyuwusa akuci e itana yu uɗuma̱, waru i ta lyuwa le hali a aa'wan a̱ kuci, a mantsa ma na ilyalya ya̱ yi i kutsai. ");
INSERT INTO tsw_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","<<Yaa wina iɗa'a suru suru shi, adama a na iɗa'a za va̱ ɗa. Waru a̱ɗu omocin a ɗa tsa̱ a̱za̱ a̱ nden ma atsupu. ");
INSERT INTO tsw_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Waru iɗa i na yo o'woi za ɗu suru, nna̱ yaa wina yi, i ca ure u na aa gura tsupisa yi. ");
INSERT INTO tsw_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","<<Nnu ulambu u reme za ta̱ a̱tsuma̱ a̱ ɗu, hali u kene pe a̱tsuma̱ e iɗa ya̱ yi u wina, vuma ta̱ a̱tsuma̱ e imaci i zuzu ya̱ yi u ka̱mba̱ u tsupisa iɗa'a. ");
INSERT INTO tsw_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Nna̱ gba za na winai uba̱ta̱'a̱ u ri ni imaci i na yaa gura tsupisa uba̱ta̱'a̱ shi, agba a̱ tyo ɗe elime a̱vu u tsura̱ ikebe i na waa gura tsupisa uba̱ta̱'a̱, ");
INSERT INTO tsw_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","to, u kece a̱bunda̱ a a'wan a na u yuwain a na u winai uba̱ta̱'a̱. Reve u ka̱mbuwa̱ ili i na i buwai e ekere a vuma na u winayi, ne ɗa uɗuma̱'a̱ wa̱a̱ ka̱mbisa̱ za va̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Agba nnu u ri ni ikebe i na waa gura tsupisa uba̱ta̱'a̱ shi, to, uba̱ta̱ u na a winai u ta̱ da̱na̱ e ekere a vuma na tsulai uba̱ta̱'a̱, hali a̱ tyo a Aa'wan a̱ A̱buki o uka̱mbusa̱ fa̱a̱n. A Aa'wan a̱ A̱buki'i a̱ ta̱ ka̱mbuwa̱a̱ yi, reve u ka̱mbisa̱ a̱ nden ma̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","<<Nna̱ vuma wina u'wa wu nden a̱tsuma̱ a̱ lyuci na ri nu ukari, u ta gura tsupisa u'wa'a a̱tsuma̱ a aa'wan a̱ ta̱. Aa'wan a̱ ta̱ ma̱ɓula̱ u ta̱ nu ucira u na waa gura tsupisa yi. ");
INSERT INTO tsw_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Agba nnu u gura tsupisa u'wa'a a̱tsuma̱ a aa'wan a̱ ta̱ o ndolo shi, to, u'wa'a wo o'wo ta̱ u'wa u vuma na tsula niyi, hali a̱ tyo a̱ muwun n tsukaya ma̱ yi. A̱a̱ ka̱mbuwa̱a̱ za vi ili shi a Aa'wan a̱ A̱buki'i. ");
INSERT INTO tsw_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Agba 'wa na ri a̱ mulyuci n na n ri uka̱nda̱ruwu nu ukari shi, a ta tara le tsi iɗa yi cimba, a ta gura tsupisa ikebe o una̱ u le. A ta gura waru ka̱mbuwa̱a̱ aza a 'wa na̱ 'wa le a̱tsuma̱ a Aa'wan a̱ A̱buki'i. ");
INSERT INTO tsw_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","<<Agba aɗa a nan Levi na̱ 'wa le na ri a̱tsuma̱ e ilyuci i le, a̱ ta̱ na aa gura tsupisa ili i le a mantsa suru. ");
INSERT INTO tsw_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Agba na̱ vuma va̱ Levi wina u'wa a̱tsuma̱ e ilyuci ya ama a̱ Levi, agba u gura tsupisa u'wa'a shi, a̱ ta̱ ka̱mbuwa̱a̱ yi nu u'wa wa̱ yi a̱tsuma̱ a Aa'wan a̱ A̱buki'i, adama a na 'wa a̱tsuma̱ e ilyuci i nan Levi ili ya agadu i ɗa le a̱tsuma̱ aza a Isra'ila . ");
INSERT INTO tsw_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Agba aa wina atsusa a alyuna a na a̱ ri uka̱nda̱ruwu na̱ 'wa le shi adama a na ili ya agadu i ɗa le hali hali hali. ");
INSERT INTO tsw_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","<<Nnu ulambu u reme za va̱ wu, agba waa gura kamba aciya̱yi shi, vu kamba yi cine vu revei vaa kamba mocin ko za vu mmalu a̱tsuma̱ a̱ ɗu. Adama u lyuwa elime na̱ nden oɓolo na̱ a̱ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Vu ca yi okopu agba vu ushi nu uda̱shiyi wan, amma vu uwwa wovon wa̱ A̱sula̱ a̱ wu. Vu lyawa yi u da̱nu oɓolo na̱ a̱vu. ");
INSERT INTO tsw_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Vu ca yi okopu agba vu ushi nu uda̱shiyi wan, ko vu winaa yi ilyalya nu uda̱shiyi wan. ");
INSERT INTO tsw_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","A̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu za na uta̱a̱ nɗu a̱tsuma̱ e iɗa ya Masar, adama n ca ɗu iɗa ya Ka'ana, tsa̱ra̱ mo o'wo A̱sula̱ a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","<<Nna̱ za va̱ wu o'wo alambi hali u rawa a na u winai aciya̱yi uba̱ta̱ wa̱ wu, she vu zuwa yi ulinga tsa aagbashi wan. ");
INSERT INTO tsw_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","U ta̱ da̱nu oɓolo na̱ a̱vu tsu za zamalinga ko za vu mmalu, waru u ta yuwaan wu ulinga hali she na Aa'wan a̱ A̱buki'i a rawa. ");
INSERT INTO tsw_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","A mantsa mo ndolo ma ɗa a̱yi na̱ muwun ma̱ yi aa lyawa le, reve u ka̱mba̱ o ugundo nu uba̱ta̱ wu nkaya ma̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Adama a na ama a Isra'ila agbashi a̱ va̱ a ɗa aza a na mu uta̱yi a̱tsuma̱ e iɗa ya Masar. Waru aa wina le tsa agbashi shi. ");
INSERT INTO tsw_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Waru vaa yuwan tsugono a aci e le ni iɓongi shi, amma vu uwwa wovon wa A̱sula̱ a̱ wu. ");
INSERT INTO tsw_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Agba agbashi e esheli no olobo a na vu cigai vu tsula o o'wo diga a nɗa n na n ri uka̱nda̱ruwu na̱ a̱vu, ele ɗa goon vaa gura tsula. ");
INSERT INTO tsw_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","I ta gura tsula agbashi diga o omocin a na a̱ ri a̱ nden na̱ a̱ɗu na̱ muwun mu ugundo n le n na a matsain e iɗa i ɗu. Ele nda o to o'wo itana i ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","I ta gura ca muwun n ɗu ele adama wo o'wo le agadu. O to o'wo ɗu agbashi hali hali. Agba a̱za̱ a̱ ɗu ama a Isra'ila, yaa yuwan tsugono a aci e le ni iɓongi shi. ");
INSERT INTO tsw_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","<<Nna̱ mocin na ri nden a̱tsuma̱ a̱ ɗu za vu mmalu o o'wo za vu utsuru, reve za ta̱ a̱tsuma̱ a̱ ɗu wo o'wo alambi hali u wina aciya̱yi e ekere o moci'in, ko e ekere o umatsun wu mocin ro, ");
INSERT INTO tsw_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","a ta gura tsupisa vuma va Isra'ila'a cina u wina ɗe aciya̱yi. Vuma ta̱ a̱tsuma̱ a mmaci ma̱ yi u ta gura tsupisa yi. ");
INSERT INTO tsw_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","U ta gura o o'wo mawun ma̱ a̱na̱wu ma dada va̱ yi, ko mawun ma mawun ma̱ a̱na̱wu ma dada va̱ yi, ko imaci i lipu va̱ yi i ta gura tsupaa yi. Ko a̱yi a aciya̱yi u ta gura tsupisa aciya̱yi nnu u ri ni ikebe. ");
INSERT INTO tsw_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","A̱yi na̱ za na tsula niyi, e te kece a̱bunda̱ e ikebe'e. A̱bunda̱ e ikebe i na aa tsupa adama a lyawa yi fa̱a̱n e te kece le o una̱ wa̱ a̱bunda̱ a a'wan a na a buwai kafu Aa'wan a̱ A̱buki'i a rawa. E te kece o una̱ wi ikebe i na a tsu tsupa za zamalinga. ");
INSERT INTO tsw_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Nna a'wan a na a buwai a̱ ri a̱bunda̱, u ta tsupa ili i na i la'ai a̱bunda̱ a̱tsuma̱ e ikebe i na u ushiyi a mantsa ma na u winai aciya̱yi. ");
INSERT INTO tsw_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Amma nna a'wa'an a buwa wa'a a rawa Aa'wan a̱ A̱buki'i, u te kece reve u tsupaa aciya̱yi cine wu ntsayi. ");
INSERT INTO tsw_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Moci'in u ta tara vuma va Isra'ila'a tsu za zamalinga va aa'wan suru. She i lyawa za na tsula niyi'i u yuwan tsugbain a aci a̱ yi ni iɓongi wan. ");
INSERT INTO tsw_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Nna̱ gba a gura tsupaa yi a̱tsuma̱ e re nda shi, a̱yi na̱ muwun ma̱ yi a ta lyawa le a̱tsuma̱ a Aa'wan a̱ A̱buki'i. ");
INSERT INTO tsw_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Adama a na ama a Isra'ila agbashi a̱ va̱ ɗa. Ele agbashi a̱ va̱ a ɗa aza a na mu uta̱yi a̱tsuma̱ e iɗa ya Masar. A̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","<<I yuwaan aciya̱ɗu a̱ma̱li wan ko i shuwa̱ uruma ko ijigo wan waru she i she'en aatali e iɗa i ɗu a na ya̱a̱ ka̱ɗa̱ta̱wa̱ yi wan adama a na a̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","I tara Ashibi a̱ va̱ na akiza waru i ca a̱a̱'isa̱ a̱ va̱ tsugbain. A̱mu ɗa A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","<<Nni i kuru ili i na n zuwaa nɗu reve waru i toni wila̱ u va̱ ulobonu, ");
INSERT INTO tsw_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","n ta̱ lyunguwa̱a̱ ɗu ni iro'i a̱tsuma̱ a mantsa, iɗa i ta ca limatan va̱ yi waru ɗanga ta ca limatan le. ");
INSERT INTO tsw_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Itana ya̱ a̱ɗuma̱ a̱ ɗu a ta yuwan a̱bunda̱ reve i da̱na̱ o ugasa hali a̱ tyo a mantsa mo uta'an wa̱ inabi, waru i ta̱ da̱na̱ a ta'asan umatsun wa̱ ina̱bi u ɗu hali mantsa ma̱ ca̱'a̱n mo ro ma̱ ka̱nda̱ruwisa̱. I ta lyuwa ilyalya i cuwa̱n waru i yuwan nden n ɗu a̱tsuma̱ a asuvu nden a̱tsuma̱ e iɗa i ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","<<N ta ca ɗu asuvu nden e iɗa'a. I to von i lantsa babu wovon wu za. N to loso inama yu una i na i ri na̱ meleshe a̱tsuma̱ e iɗa'a, waru a̱a̱ da̱shi yuwan uvon a̱tsuma̱ e iɗa i ɗu shi. ");
INSERT INTO tsw_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","I ta saɓa n'yuwatan n ɗu. Waru i to una le na̱ matsun me pe'eni. ");
INSERT INTO tsw_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Ama o ton a̱ ɗu, o to loso ama ukpaku (100,) ama ukpaku u ɗu gba o to loso ama ukpakukupa kupa (10,000.) I to una n'yuwatan n ɗu na̱ matsun mepe'eni reve a̱ riya̱ elime a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","<<N ta̱ ka̱lyuwa̱ ɗu nu urewesu wi isa'ani, waru n ta zuwa ɗu i matsan lon i bala. Waru n to shiton akucunu a na n yuwain na̱ a̱ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","I ta̱ da̱na̱ a lyuwusa itana ya̱ a̱ɗuma̱ a̱ ɗu ya aa'wan a na a̱ ka̱ra̱i hali a̱ tyo a mantsa ma na yoo uta̱a̱ le adama i ca aza a sa'avu ure. ");
INSERT INTO tsw_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","N ta zuwa uba̱ta̱ wu nden n va̱ a̱tsuma̱ a̱ ɗu, waru mee ene ɗu ili yi idaba shi. ");
INSERT INTO tsw_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","N ta̱ da̱na̱ oɓolo na̱ a̱ɗu, moo o'wo A̱sula̱ a̱ ɗu. A̱ɗu waru yo o'wo ama a̱ va̱. ");
INSERT INTO tsw_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","A̱mu ɗa A̱sulazuva A̱sula̱ a̱ ɗu za na uta̱a̱ nɗu a̱tsuma̱ e iɗa ya Masar, adama i da̱na̱ agbashi e le wan. Reve mu kuɗa a̱a̱gba̱la̱ a na a tsugba nɗu, reve n zuwa ɗu i yuwan mmalu mejege. ");
INSERT INTO tsw_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","<<Agba nni i 'yuwan a uwwa mu, waru i 'yuwan a yuwan ili i na n damma nɗu suru, ");
INSERT INTO tsw_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","waru nni i kuɗa wila̱ u va̱, hali i tara le ili yi idaba, reve i kuɗa̱ o toni ili i na n dammai, reve waru i kuɗa akucunu a̱ va̱, ");
INSERT INTO tsw_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","to, n ta gba a yuwaan ɗu ili i nda: N ta̱ lyunguwa̱ ɗu upepu u cingi wi iwuya lon, oɓolo na̱ mɓa̱la̱ icu'un icu'un, hali na̱ mɓa̱la̱ n na ma̱a̱ lungusa̱ ɗu esu. Reve i ka̱ra̱ a rumba̱na̱sa̱ a̱vu u zuwa mɓa̱la̱ mo okolo. I ta yuwan ca̱'a̱n ve pere, adama a na n'yuwatan n ɗu n ɗa maa lyuwa le. ");
INSERT INTO tsw_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","N ta yuwan tsurala na̱ a̱ɗu adama n'yuwatan n ɗu n lyuwa ɗu nu uvon. Aza a na a 'yuwan nɗu ele ɗa aa yuwan tsugono tsa̱ ɗu, waru i ta̱ ka̱ra̱ e ilaɗi ko na̱ za lo a saɓusa ɗu shi. ");
INSERT INTO tsw_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","<<Agba suru na̱ ne, ni i 'yuwan a zuwaa mu atsuvu, to n ta̱ gba o doɓonuwo ɗu a̱tsuma̱lima̱ a̱ ɗu toto ucindere. ");
INSERT INTO tsw_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","N ta kuɗa ucira wu uvaɗu wa aciyogbamu u ɗu. N ta zuwa eleshe a na a̱ ri zuva ɗu o o'wo tsu rumu, iɗa i na i ri za̱la̱ ɗu waru tsu rumushili. ");
INSERT INTO tsw_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","I to una ucira u ɗu pere adama a na iɗa i ɗu yaa matsan ili shi, waru ɗanga vi iɗa i ɗu aa matsan ili shi. ");
INSERT INTO tsw_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","<<Agba hali n gogo ni i yuwaan mu aciyogbamu, waru ni i 'yuwan a zuwaa mu atsuvu, n ta̱ gba a̱ da̱shi ɗu a̱tsuma̱lima̱ udoɓonuwu toto ucindere adama o unusu u ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","N ta̱ waru a̱ lyungu inama yu una a aci a̱ ɗu aza a na oo una muwun n ɗu ni iliyamunga i ɗu. Waru a ta jiba a̱bunda̱ a̱ ɗu hali re ɗu vo o'wo babu ama. ");
INSERT INTO tsw_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","<<Agba suru ni ili i nda, ni i 'yuwan a̱ usu tsuɓari tsa̱ va̱, reve i lyuwa elime a yuwusaan mu aciyogbamu, ");
INSERT INTO tsw_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","a̱mu fo, n to ronu na̱ a̱ɗu. A̱mu na aciya̱va̱ a ɗa maa yuwan nla̱ngi na̱ a̱ɗu. A̱vu n ca ɗu a̱tsuma̱lima̱ toto ucindere adama a̱ nusu ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","N ta̱ ta̱wa̱a̱ ɗu nu uvon u na waa tsupaa mu adama a na i kuɗai akucunu a̱ va̱. Nni i rono a̱ ka̱mba̱ na̱ a̱ca̱pa̱ a̱ tyo a̱tsuma̱ e ilyuci i ɗu, n ta̱ lyunguwa̱ ɗu na̱ mɓa̱la̱, reve i riya̱ e ekere a n'yuwatan n ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","N te geshe ure u ma̱tsura̱ me ilyalya i ɗu hali she na̱ a̱ma̱ci kupa a̱ zun opopofu e eelele a̱ ta̱, reve a ca ɗu uritowu. I ta lyuwa agba ya̱a̱ cuwa̱n shi. ");
INSERT INTO tsw_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","<<Agba suru na̱ ne, nna̱ yu uwwa mu shi, reve i ka̱ra̱ a mmalu n ɗu a̱ 'ya̱susa̱a̱n mu aci, ");
INSERT INTO tsw_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","a̱mu gba n ta̱ 'ya̱sa̱a̱n ɗu nu upan lon. Reve a̱mu na aciya̱va̱ n doɓonuwo ɗu a̱tsuma̱lima̱ toto ucindere adama a̱ nusu ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","I ta tama inama i muwun n ɗu mo olobo ne esheli. ");
INSERT INTO tsw_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","N ta̱ lungusa̱ a̱'isa̱ a̱ a̱ma̱li a̱ ɗu a agaɗi. Waru n ta̱ lungusa̱ musa'a ma̱ a̱tsuka̱ a̱ ma̱guru n ɗu. N ta̱ waru gba a̱ kunguru a̱kwa̱kwa̱ a̱ ɗu zuva va̱ a̱kwa̱kwa̱ va̱ a̱ma̱li a̱ ɗu. I to o'wo ili yi idaba e ekere a̱ va̱. ");
INSERT INTO tsw_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","N ta̱ ka̱mba̱to ilyuci i ɗu asa'a. Waru n ta̱ lungusa̱ a̱'isa̱ a̱ ɗu. Ma̱a̱ da̱shi ciga ma̱guru ma̱ kucci ɗu shi. ");
INSERT INTO tsw_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","N ta̱ lungusa̱ iɗa i ɗu hali wo o'wo cine n'yuwatan n na n ri na̱ nden pe aa lamba ili i na aa damma. ");
INSERT INTO tsw_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","N te bete'we ɗu a̱ tyo a̱tsuma̱ a nɗa n ro, reve n tala matsun me pe'eni ma̱ va̱ n saɓa ɗu. A̱vu n zuwa iɗa i ɗu yo o'wo asa'a waru a̱ lungusa̱ ilyuci i ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Ɗaɗa iɗa i ɗu ya̱a̱ tsura̱ yu uwwa uyo'o wa Aa'wan a̱ wivuwun wa̱ yi a mantsa ma na u ri okongo. Ni i ri e iɗa yi n'yuwatan n ɗu, iɗa'a i ta̱ tsura̱ wivuwun wa̱ yi waru wu uwwa uyo'o u wivuwun. ");
INSERT INTO tsw_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Mantsa ma na u ri okongo suru, iɗa'a i ta̱ tsura̱ wivuwun u na u shi tsura̱i shi a mantsa ma̱ wivuwun wa Ashibi ma na na i da̱na̱i pe nden. ");
INSERT INTO tsw_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","<<Amma o una̱ u ɗu gba aza a na a buwai, n ta zuwa wovon wa̱ a̱bunda̱ o okolo a̱ ɗu a̱tsuma̱ e iɗa yi n'yuwatan n ɗu. Hali ni ilama ya̱ a̱vu'un yaa saɓa ɗu. I ta suma she damma aza a na aa sumusa matsun mepe'eni, reve i riya̱, ko na wo o'woi za lo aa saɓusa ɗu shi. ");
INSERT INTO tsw_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","I ta̱ da̱na̱ a ngamulai va̱ni ɗu tsa ama a na a sumusaa una̱ u matsun me pe'eni ko na wo o'woi za lo aa saɓusa le shi. Adama o ndolo yaa gura isawan a̱ ma̱ka̱ka̱n ma n'yuwatan n ɗu shi. ");
INSERT INTO tsw_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","I ta̱ kuwa̱ a̱tsuma̱ a nɗa n ro. Iɗa yi n'yuwatan n ɗu i ta lyuwa ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Amma o una̱ u ɗu gba aza a na a buwai, i ta̱ kuwa̱ a̱tsuma̱ e iɗa yi n'yuwatan n ɗu adama a̱ nusu ɗu na̱ wa aza a nkaya n ɗu. ");
INSERT INTO tsw_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","<<Agba nna a pati gafura vu nusu le na̱ nusu vu nkaya n le nu ulambu wa amayun e le e ekere a̱ va̱ waru nna̱ a̱ usu a yuwaan mu ta̱ aciyogbamu, ");
INSERT INTO tsw_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ili i na i zuwai n 'yuwan nle hali n keɓe nle a̱ tyo e iɗa yi n'yuwatan nle, nna̱ a̱ ka̱ɗa̱to okolo a aciyogbamu e le reve a̱ usu unusu u le, ");
INSERT INTO tsw_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","n ta cuwan na akucunu a na n yuwain na̱ Yakubu, na̱ Ishaku na̱ Ibrahim. N ta gba a cuwan ni iɗa'a. ");
INSERT INTO tsw_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Amma a ta lyawa iɗa'a i tsura̱ wivuwun a mantsa ma na u ri okongo. A ta̱ gba a tsupa o una̱ wu nusu le adama a na a 'yuwain wila̱ u va̱ waru e enei wila̱ u va̱ idaba. ");
INSERT INTO tsw_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Agba suru na̱ ne, a mantsa ma na a̱ ri e iɗa yi n'yuwatan n le, maa lyawa le shi, ko me ene le idaba shi hali na moo kototo le suru suru shi ko n kuɗa akucunu a na n yuwaan n le. A̱mu ɗa A̱sulazuva A̱sula̱ e le. ");
INSERT INTO tsw_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Amma adama a̱ ɗu n ta cuwan na̱ akucunu a na n yuwain na̱ nkaya n ɗu aza a na mu uta̱yi a̱tsuma̱ e iɗa ya Masar e esu a ama a nɗa n ro adama moo o'wo A̱sula̱ e le. A̱mu ɗa A̱sulazuva.>> ");
INSERT INTO tsw_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ele nda e le ɗa ili i na a zuwai na̱ wila̱ nu uritosu u na A̱sulazuva a yuwain na ama a Isra'ila e ekere a Musa a Masasan ma Sinai. ");
INSERT INTO tsw_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Reve A̱sulazuva a yuwan adanshi na̱ Musa, u damma, ");
INSERT INTO tsw_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","<<Vu yuwan adanshi na ama a Isra'ila vu damma le, nna̱ vuma yuwan akucunu la̱nga̱ a na waa ca A̱sulazuva vuma u ta gura tsupaa vuma'a ni ikebe o una̱ u vuma'a, ");
INSERT INTO tsw_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","apa cine o rito ikebe i vuma'a o una̱ u makundatsu ma̱ a̱a̱'isa̱ a akiza. Vali na ri na a'wan ushin a̱ tyo kupota̱li, a ta tsupa azurufa kupoton. ");
INSERT INTO tsw_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Agba na̱ ka ɗa, a ta tsupa azurufa mata'atsu. ");
INSERT INTO tsw_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Ulobo u na u ri a'wan o ton a̱ tyo a'wan ushin, a ta tsupa azurufa ushin. Usheli u na u ri na a'wan o ndolo a ta tsupa azurufa kupa. ");
INSERT INTO tsw_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Mawun mo ulobo ma na ma̱ ri na̱ woto u ta̱ a̱ tyo a'wan o ton, a ta tsupa azurufa ton. Usheli gba na u ri na a'wa'an, a ta tsupa azurufa ta'atsu. ");
INSERT INTO tsw_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Vuma na gba ri na a'wan kupota̱li a gawan, a ta tsupa azurufa kupa no ozo o ton o una̱ u vali. O una̱ wu ka gba, a ta tsupa azurufa kupa. ");
INSERT INTO tsw_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Nna̱ vuma ciga yuwan cu'un va akucunu a nda agba alambi a ɗa na waa gura tsupa ili i na a paɗaa niyi shi, to, u 'ya̱wa̱ na̱ vuma'a uba̱ta̱ wa ganu, adama ganu paɗa ili i na i lobonoi na vuma'a waa gura tsupa. ");
INSERT INTO tsw_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","<<Nna̱ akucunu'u e reme ta̱ a na waa ca iliyamunga i na yi ntsayi a ca A̱sulazuva a ɗa, to iliyamunga i ndolo wo o'wo ta̱ ili ya akiza. ");
INSERT INTO tsw_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Nu u 'yuwan u ciga u kita'wan iliyamunga'a wan, waru she u vadala za vu ulobonu na̱ za babu ulobonu wan, ko za babu ulobonu na̱ za vu ulobonu wan. Na̱ waa kita'wan iliyamunga ni iliyamunga, a̱yi na̱ za na a kita'wai'in ele ra o to o'wo ili ya akiza. ");
INSERT INTO tsw_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Agba nni ili i na a yuwain nzuwulai iliyamunga yi idaba i ɗa i na yi ntsayi a ca A̱sulazuva shi, to, vuma'a u 'ya̱wa̱a̱ ni iliyamunga'a ya ganu. ");
INSERT INTO tsw_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Ganu gba u ta̱ ka̱lyuwa̱ ulobonu wi iliyamunga'a ko u tu ulobonu ko u ri ulobonu shi, cine ganu paɗaa niyi ne ɗaɗa wa̱a̱ da̱na̱. ");
INSERT INTO tsw_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Amma nna̱ za vi ili'i u ciga ta̱ u ka̱mba̱ u tsupisa iliyamunga'a, to, u ta̱ da̱shi za ta̱ a̱tsuma̱ o ozo o ton a aci e ili i na a paɗai. ");
INSERT INTO tsw_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","<<Nna̱ vuma ca u'wa wa̱ yi wo o'wo ili ya akiza e ekere a̱ A̱sulazuva, to ganu ka̱lyuwa̱ ulobonu wu u'wa'a. U ka̱lyuwa̱ ko u'wa'a u tu ulobonu ko u ri ulobonu shi. Ili i na ganu paɗai suru, ne ɗaɗa wa̱a̱ da̱na̱. ");
INSERT INTO tsw_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Nna̱ za na cayi u'wa'a u ciga u ka̱mba̱ u tsupisa u'wa'a, to u ta̱ da̱shi za ta̱ a̱tsuma̱ o ozo o ton a aci e ili i na a paɗayi u'wa'a, reve u'wa'a wo o'wiso za va̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","<<Na̱ vuma ca A̱sulazuva upasu u na wi iɗa wa agadu a̱ yi, to, a paɗaa iɗa'a ikebe a̱bunda̱ o una̱ wi icu'un i na a̱a̱ cu'wa̱n pe. Shekel azurufa kupoton o una̱ u makundatsu ushin vi icu'un. ");
INSERT INTO tsw_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Nu u ca ta̱ uɗuma̱ wa̱ yi a̱tsuma̱ a Aa'wan a̱ A̱buki o uka̱mbusa̱ fa̱a̱n, ikebe i na a paɗayi uɗuma̱'a̱ ya aa'wan i ɗaɗa wee reme. ");
INSERT INTO tsw_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Amma nnu u ca ta̱ uɗuma̱'a̱ cina Aa'wan a̱ A̱buki'i a̱ ka̱ra̱, to, ganu paɗaa uɗuma̱'a̱ ikebe o una̱ wa a'wan a na a buwai Aa'wan a̱ A̱buki'i a̱a̱ ka̱nda̱ruwisa̱. Waru a ta jiba a̱bunda̱ e ikebe i na a paɗai. ");
INSERT INTO tsw_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Agba na̱ vuma na cayi uɗuma̱'a̱ u ciga u ka̱mba̱ u tsupisa yi, to u ta̱ da̱shi za ta̱ a̱tsuma̱ o ozo o ton e ikebe yu uɗuma̱'a̱. Reve uɗuma̱'a̱ wo o'wiso za va̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Agba nu u ciga u tsupisa uɗuma̱'a̱ shi, ko u shi ta̱ ɗe u winaa za ro uɗuma̱'a̱, to u ri n yuwan u ka̱mba̱ u tsupisa uɗuma̱'a̱ shi. ");
INSERT INTO tsw_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Na a ca uɗuma̱ a̱tsuma̱ a aa'wan a̱ A̱buki'i, uɗuma̱'a̱ u to o'wo ili ya akiza tsu uɗuma̱ u na a tawayi A̱sulazuva. U to o'wo uɗuma̱ u nan ganu. ");
INSERT INTO tsw_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","<<Na̱ vuma ca uɗuma̱ u na u tsulai, uɗuma̱ u na u ri pe a̱tsuma̱ e iɗa ya agadu shi, ");
INSERT INTO tsw_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ganu ta paɗaa uɗuma̱'a̱ ikebe i na wu ntsayi hali a̱ tyo a a'wan a na a buwai a cina Aa'wan a̱ A̱buki'i. Vuma'a u ta tsupa ikebeꞌe o una̱ wi ikebe i na a paɗai o urana'a, ili ya akiza i ɗa e ekere a̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","A Aa'wan a̱ A̱buki'i uɗuma̱'a̱ u ta̱ ka̱mba̱ e ekere a za na tsula niyi, za na uɗuma̱'a̱ u shi za va̱ yi. ");
INSERT INTO tsw_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","A ta paɗa ili i na yi ntsayi a tsupa suru o una̱ u makundatsu ma̱ a̱a̱'isa̱ a akiza. ");
INSERT INTO tsw_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","<<Agba ko za aa ca umatsun wu ufaru wi iliyamunga shi, a na wo o'woi umatsun wu ufaru wi iliyamunga suru za va̱ A̱sulazuva ɗa, ko nan ko kyon, za va̱ A̱sulazuva ɗa. ");
INSERT INTO tsw_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Amma ni iliyamunga'a za vi idaba ɗa, a ta gura ka̱mba̱ a tsupisa yi o una̱ wi ikebe i na ganu paɗaa niyi oɓolo na̱ za ta̱ a̱tsuma̱ o ozo o ton. Nna̱ gba aa tsupisa yi shi, a wina yi o una̱ wi ikebe i na a paɗa niyi. ");
INSERT INTO tsw_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","<<Agba ili yi lo a̱tsuma̱ e ili i na vuma ri na̱ a̱yi, na a cayi A̱sulazuva, ko vuma, ko iliyamunga, ko iɗa ya agadu, na aa gura wina ko a tsupa shi. Ili i na a tawai suru ili ya akiza i ɗa e ekere a̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Babu vuma na a cayi adama o ukototosu na a tsupisa adama a̱ yi. Na a 'yuwan a ciga o una yi. ");
INSERT INTO tsw_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","<<Za ta̱ a̱tsuma̱ a kupa suru vi ili yi iɗa'a, ko vi ishina, ko vu matsun vu ɗanga, a̱za̱ a̱ A̱sulazuva a ɗa. Ili ya akiza i ɗa e ekere a̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Na̱ vuma ciga u tsupisa za ta̱ a̱tsuma̱ a kupa suru na u cayi, u da̱shi za ta̱ a̱tsuma̱ o ozo o ton a aci e ili'i. ");
INSERT INTO tsw_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Za ta̱ a̱tsuma̱ a kupa vi iliyamunga suru, ko vi inan, ko vi ikyon, ko vu mgbele, za va kupa suru na va̱a̱ ka̱ra̱ za̱la̱ va aaɗanga a za va aaguɓa, u to o'wo ili ya akiza e ekere a̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Waa ɗangula iliyamunga i kupa o una̱ wu ulobonu wa̱ yi shi ko o ulambu wu ulobonu wa̱ yi shi. Agba waru waa kita'wa yi shi. Na a kita'wa yi, iliyamunga'a na̱ za na a kita'wai o to o'wo na akiza. A̱ ri na aa gura tsupisa le shi.>> ");
INSERT INTO tsw_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ele nda, ele ɗa wila̱ u na A̱sulazuva a cayi Musa a Masasan ma Sinai adama a ama a Isra'ila.");
INSERT INTO tsw_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","A yuwan ta̱ vuma ro aala a̱ yi Elikana, vuma va Zuf za vu ugundo wa Ifiramu u ta̱ nden a̱ lyuci va Rama, e iɗa ya agaɗi ya Ifiramu. A̱yi ulobo wa Yeroham u ɗa ulobo wa Elihu ulobo wa Tohu ulobo wa Zuf vuma va Ifiramu. ");
INSERT INTO tsw_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","U da̱na̱ ta̱ na̱ a̱ma̱ci e re, za ta̱ aala a̱ yi Hanatu za ve ire waru aala a̱ yi a ɗa Penina. Penina ta̱ na̱ muwun, agba Hanatu ri ni i ɗa shi. ");
INSERT INTO tsw_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Aa'wan suru Elikana tsu lyawa ta̱ lyuci va̱ yi Rama, reve u gawan a̱ 'ya̱wa̱ lyuci va̱ Shilo tsa̱ra̱ u yuwaan A̱sulazuva o oɓolo a̱ a̱soja a zuva a̱ga̱nda̱, waru u yuwaan yi kucci. Olobo e Eli e re Hofini na̱ Finiha ele ɗa a̱ da̱na̱i nan ganu va̱ A̱sulazuva ɗe. ");
INSERT INTO tsw_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","A mantsa ma na suru Elikana cayi kucci va̱ yi, u tsu ca ta̱ ka va̱ yi Penina na̱ muwun mo olobo ma̱ yi suru ne esheli akunda e inama i le. ");
INSERT INTO tsw_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Amma u tsu ca ta̱ Hanatu akunda a gbain adama a na u ciga yi ta̱ lon, adama a na a̱ A̱sulazuva a̱ ɓa̱ru ta̱ umatsutsun wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Shewun va̱ yi Penina tsu cukurusa̱ yi ta̱ adama u yuwaan yi ulamu waru u ca yi upan, adama a na A̱sulazuva a̱ ɓa̱ru ta̱ umatsutsun wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Ucukurusa̱'a̱ u lyuwa ta̱ elime aa'wan suru. Mantsa ma na Hanatu 'ya̱wa̱i o u'wa wa̱ A̱sulazuva suru, shewun va̱ yi tsu cukurusa̱ yi ta̱ adama u ca yi upan, hali u shon reve u 'yuwan a lyuwa ilyalya. ");
INSERT INTO tsw_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Elikana vali va̱ yi tsu damma yi ta̱, <<Hanatu nye i zuwai vu ri e mesun? Nye i zuwa vu lyuwai ilyalya shi? Waru nye i zuwai vu ri ya̱ a̱tsuma̱la̱ngu? A̱mu n la'aa wu muwun mo olobo kupa shi?>> ");
INSERT INTO tsw_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","Urana u ro ɗe Shilo ana a lyuwai ilyalya o sowoi, reve Hanatu 'yon u yuwan avasa. Eli ganu gba da̱na̱ ta̱ lo nden o ootogu o una̱ntsutsu wu u'wa wa̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","Hanatu da̱na̱ ta̱ na̱ a̱tsumola̱ngu lon, a̱vu u yuwan avasa a̱ tyo uba̱ta̱ wa̱ A̱sulazuva na̱ mesun lon. ");
INSERT INTO tsw_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Reve u yuwan akucunu u damma, <<A̱sulazuva o oɓolo a̱ a̱soja a zuva, na̱ vu ka̱lyuwa̱ a̱tsuma̱lima̱ a aagbashi a̱ wu reve vu cuwan na̱ a̱mu, agba vi icina na aa aagbashi a̱ wu shi, a̱vu vu ca yi ulobo, n ta̱ gba a ca A̱sulazuva a̱yi hali ukwa̱ wa̱ yi. Agba ko utanu wa̱a̱ ju'wa̱n aaci a̱ yi shi.>> ");
INSERT INTO tsw_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Ana u lyuwai elime na avasa a̱ tyo uba̱ta̱ wa̱ A̱sulazuva, Eli gba e idanasa una̱ wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Hanatu yuwusan ta̱ avasa a̱tsuma̱ o okolo a̱ yi, una̱ wa̱ yi u ɗa goon u da̱na̱i a̱ ma̱zungwa̱, agba uɗyo wa̱ yi wu uta̱ shi. A̱vu Eli ene ngashi usowu u ɗa u ri. ");
INSERT INTO tsw_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","Reve u damma yi, <<Hali a̱ tyo mantsa ma̱ ne va̱a̱ da̱na̱ usowu? Vu lyawa ne oso a masayan ma̱ inabi.>> ");
INSERT INTO tsw_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","A̱vu Hanatu usu u damma, <<Ne ɗa shi zagbain va̱. A̱mu ka ɗa za na ri na̱ a̱tsumola̱ngu lon. N sowo masayan ma̱ ina̱bi ko ili i ro i na i tsu tsura̱to vuma shi. Amma n ta dansaa A̱sulazuva okolo a̱ va̱. ");
INSERT INTO tsw_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","She vu tara aagbashi a̱ wu tsu ka ve pere wan. N ta avasa mantsa ma nda suru adama a̱ a̱bunda̱ o usa̱n na̱ a̱tsumola̱ngu a na n ri pe.>> ");
INSERT INTO tsw_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Reve Eli usu yi, <<Ka̱ra̱ na asuvu nden, lyawa A̱sula̱ a aza a Isra'ila a ca wu ili i na vu pati niyi.>> ");
INSERT INTO tsw_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Reve u damma, <<Lyawa aagbashi a̱ wu a̱ tsura̱ isa'ani e ekere a̱ wu.>> A̱vu ka'a u reme ure wa̱ yi u 'ya̱wa̱ u lyuwa ilyalya. Agba u da̱shi lukuta̱ urewesu wa̱ yi shi. ");
INSERT INTO tsw_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Ana usana u tawai, reve Elikana na̱ a̱ma̱ci a̱ yi na̱ muwun ma̱ yi a yuwaan A̱sulazuva a̱ga̱nda̱. A̱vu a̱ ka̱mba̱ o u'wa u le a Rama. Ana Elikana voyin na̱ ka va̱ yi Hanatu, reve gba A̱sulazuva a cuwain na̱ a̱yi. ");
INSERT INTO tsw_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Ana mantsa ma yuwain, reve Hanatu tsura̱ a̱a̱tsuma̱ reve u matsan mawun mo ulobo. Ɗaɗa u ca niyi aala Sama'ila, a dansa, <<M pati ta̱ A̱sulazuva a̱yi.>> ");
INSERT INTO tsw_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Ana Elikana nu u'wa wa̱ yi suru a̱a̱ 'ya̱wa̱ tsa̱ra̱ a ca A̱sulazuva kucci va aaꞌwan suru, reve waru u shiton akucunu a̱ yi, ");
INSERT INTO tsw_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Hanatu 'ya̱wa̱ shi. U damma ta̱ vali va̱ yi, <<Na̱ n kasa mawu'un maani, n ta tara yi a̱ ꞌya̱wa̱ n ca A̱sulazuva a̱yi, waru ɗe ɗa wa̱a̱ da̱na̱ kuci.>> ");
INSERT INTO tsw_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Reve Elikana usu ka va̱ yi u damma, <<Yuwan ili i na i lobono nuwu. Isawan pa hali she mantsa ma na vu kasa niyi maani. A̱yi de lyawa A̱sulazuva o shiton adanshi a̱ yi goon.>> Ɗaɗa Hanatu da̱nuyi o u'wa u co'o mawu'un hali mantsa ma na u kasa niyi maani. ");
INSERT INTO tsw_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Ana u kasa niyi maani, reve u tara yi a̱ 'ya̱wa̱ o u'wa wa̱ A̱sulazuva a̱ Shilo, oɓolo na̱ ogono a nan va aꞌwan a taꞌatsu, na̱ makundatsu ma yira kupa ne ejere, na̱ tsa̱n vu ukwan masayan ma̱ ina̱bi, ulobo'o gba a̱yi ubuwu mawun. ");
INSERT INTO tsw_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Ana a paɗai ogono a na'an, reve Hanatu na̱ Elikana a tara ulobo'o a̱ tyo ye Eli. ");
INSERT INTO tsw_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Reve Hanatu damma Eli, <<Wuma wa̱ wu ujima zagbain va̱! N kucina ta̱ na̱ a̱vu, a̱mu ɗa ka na da̱na̱i pa nda mishin zuzu na̱ a̱vu a yuwusan avasa a̱ tyo uba̱ta̱ wa̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","M pati ta̱ mawun ma nda, waru A̱sulazuva a ca mu ta̱ ili i na m pati niyi. ");
INSERT INTO tsw_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Adama o ndolo gogo n ca ta̱ A̱sulazuva a̱yi, waru u to o'wo e ekere a̱ yi a mantsa ma a wuma wa̱ yi suru.>> Reve a yuwaan A̱sulazuva a̱ga̱nda̱ ɗe. ");
INSERT INTO tsw_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Reve Hanatu yuwan avasa u damma, <<Okolo a̱ va̱ a shiwan ta̱ na̱ ma̱za̱nga̱ a̱ tyo e ekere a̱ A̱sulazuva! A̱sulazuva aa zuwa mu ta̱ mo o'wo nu ukadu lon. Reve m kpa̱tu'wa̱ una̱ u va̱ n zo'oso n'yuwatan n va̱, adama a na u wawa numu. ");
INSERT INTO tsw_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","<<Babu za na ri na akiza tsa̱ A̱sulazuva, babu za na ri lo tsa̱ wu, babu lo aatali tsa̱ A̱sula̱ a̱ tsu. ");
INSERT INTO tsw_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","<<She i lyuwa elime na adanshi o ugbawu wan, ko adanshi o uvaɗu o utusa̱ o una̱ u ɗu wan, adama a na A̱sulazuva a̱yi ɗa A̱sula̱ za na revei ili biti, a̱yi ɗa u tsu ge'eto linga vuma biti. ");
INSERT INTO tsw_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","<<A kuɗa ta̱ tan va aza a na a gurai uvon, amma aza a na a̱ ri nu ucira shi a̱ tsura̱ ta̱ ugbamu wo ookolo. ");
INSERT INTO tsw_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Aza a na a̱ da̱na̱i nu ucuwun, gogo a ta yuwusan ulinga wi izami yi ilyalya. Amma aza a na a̱ da̱na̱i na ambulu, gogo a̱ ta̱ ucuwun. Ka na da̱na̱i na̱ muwun shi, gogo u ta̱ na̱ muwun n cindere. Amma a̱yi na u da̱na̱i na̱ muwun ma̱ a̱bunda̱, wo o'wo ta̱ a̱ nde'en. ");
INSERT INTO tsw_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","A̱sulazuva a̱ tsu ta̱wa̱a̱ ta̱ nu ukwisa̱, waru u tsu ca ta̱ wuma. U tsu 'ya̱wa̱to ta̱ ama uba̱ta̱ wu nden wa̱ a̱kwa̱kwa̱, a̱vu waru u 'ya̱sa̱n le. ");
INSERT INTO tsw_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","A̱sulazuva a tsu zuwa ta̱ ulambu, reve waru u ca utsuru. U tsu ka̱ɗa̱to ta̱ vuma, reve waru u 'ya̱sa̱n zuva. ");
INSERT INTO tsw_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","U tsu 'ya̱sa̱n ta̱ alambi diga a̱ ma̱buta̱, aza a na a cigai ikambishi waru diga e edemu. U tsu da̱na̱to le ta̱ oɓolo na̱ azagbain, waru u tsu ca le ta̱ agadu o ootogu o tsugbain. Adama a na ikyun yu usa wu uvaɗi za va̱ A̱sulazuva a ɗa, a aci a̱yi a ɗa u yuwain uvaɗi. ");
INSERT INTO tsw_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","<<U tsu wawa ta̱ ana a ama a̱ a̱ɓula̱ a̱yi, amma a̱za̱ e iwuya a̱ tsu puwa̱n ta̱ a̱tsuma̱ e irumbu. Adama a na nu ucira u ɗa vuma aa lyuwa aci shi. ");
INSERT INTO tsw_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","A̱sulazuva a tsu kukuɗa ta̱ a̱za̱ a̱ nla̱ngi na̱ a̱yi, u tsu lapa ta̱ tsata a̱ tyo ya̱'a̱ le diga zuva. A̱sulazuva e ge'eto ta̱ uvaɗi ma̱ɓula̱. U ta ca mogono ma̱ yi ucira, u tsu zuwa ta̱ za na u tsuwa̱n yi mani'in u tsura̱ ukadu lon.>> ");
INSERT INTO tsw_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Reve Elikana na̱ Hanatu a̱ ka̱mba̱ o u'wa a Rama, agba ulobo Sama'ila wi isawan ta̱ ɗe, tsa̱ra̱ u kambusa Eli ganu a yuwusaan A̱sulazuva ulinga. ");
INSERT INTO tsw_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","Muwun mo olobo ma̱ Eli gba ama a vama a ɗa. E reve A̱sulazuva shi. ");
INSERT INTO tsw_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","Agadu a nan ganu a ɗa oɓolo na ama, na a mantsa ma na za ro cayi kucci, inama'a a̱ ma̱puna̱, aagbashi a ganu a̱ tsu ta̱wa̱ ta̱ na̱ kune gbain va akatsu a ta'atsu o ukere wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","Reve u sapa pe kune'e a̱tsuma̱ a̱ cu'un vu upondo'o suru, ili i na kune'e u gura sapai o uta̱ suru za va ganu ɗa. Ne ɗa a yuwusain na ama a Isra'ila aza a na a̱ ta̱wusa̱i a yuwan a̱ga̱nda̱ a Shilo. ");
INSERT INTO tsw_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","Amma kafu a cina mantsa ma na a̱a̱ kula̱to mani'in, reve aagbashi a ganu a̱ ta̱wa̱ u damma za na aa casu kucci'i, <<Vu ca ganu inama yu uta̱nu adama u zun. Waa ciga aza a na a̱ suwa̱in shi, she de a̱za̱ o uta̱nu.>> ");
INSERT INTO tsw_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","Na̱ vuma'a u damma yi, <<Lyawa a̱ kula̱to mani'i'in ne'e, reve vu tara cine vu cigai.>> Aagbashi'i u tsu usu ta̱, <<O'o, vu ca mu gogo! Na̱ vu 'yuwan n ta̱ tara nu ucira.>> ");
INSERT INTO tsw_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","Unusu wo olobo a̱ Eli u wuyana ta̱ na̱ a̱bunda̱ lon a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva, adama a na a tara kucci va̱ A̱sulazuva ili i ro shi. ");
INSERT INTO tsw_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","Amma Sama'ila molobo ma lyuwa ta̱ elime a yuwusaan A̱sulazuva ulinga. U da̱na̱ ta̱ wotowu na̱ ma̱tugu ma̱ epo vo okoro. ");
INSERT INTO tsw_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Aa'wan suru, mma va̱ yi tsu zula̱a̱ yi ta̱ ma̱tugu, reve u 'ya̱wa̱a̱ yi a mantsa ma na vali va̱ yi na̱ a̱yi a̱a̱ 'ya̱wa̱ a ca kucci va aa'wan aa'wan. ");
INSERT INTO tsw_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Eli waru tsu zuwaa ta̱ Elikana na̱ ka va̱ yi Hanatu abaꞌun, a̱vu u damma, <<Lyawa A̱sulazuva a ca wu muwun n ro e ekere a Hanatu, tsa̱ra̱ wo o'wo o una̱ wu ulobo u na Hanatu patiyi, reve u ca A̱sulazuva a̱yi.>> Reve Elikana na̱ Hanatu ka va̱ yi a̱ ka̱mba̱ o u'wa. ");
INSERT INTO tsw_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Reve A̱sulazuva a cuwan na̱ Hanatu, reve u matsisan olobo a taꞌatsu ne esheli e re. A̱yi gba ulobo Sama'ila u kungwa ta̱ a yuwusaan A̱sulazuva ulinga. ");
INSERT INTO tsw_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","Eli gba kutsa ta̱ lon. Waru u ta uwwusa suru ili i na olobo a̱ yi aa yuwusan na aza a Isra'ila suru na̱ cine o vosun na̱ a̱ma̱ci aza a na a yuwusan ulinga uba̱ta̱ o una̱ntsu wo Oogodo o Uga'asusan. ");
INSERT INTO tsw_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","Ɗaɗa u damma nle, <<Nye i zuwai yaa yuwusan cu'un vi ili i nda? N ta uwwusa adanshi diga uba̱ta̱ wa ama suru adama o ulinga wu uwuyanu u na yaa yuwusan. ");
INSERT INTO tsw_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","Lyawai, olobo a̱ va̱, adanshi a sa'ani a ɗa maa uwwusa diga e ekere a ama a̱ A̱sulazuva shi. ");
INSERT INTO tsw_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","Na̱ vuma yuwaan vuma ro unusu, A̱sula̱ a ta gura isawaan yi, amma na̱ vuma yuwaan A̱sulazuva unusu, zane ɗa e isawaan yi?>> Agba olobo a̱ Eli a uwwa adanshi a dada le shi, adama a na A̱sulazuva o foɓo ta̱ ɗe a na woo una le. ");
INSERT INTO tsw_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","Reve Sama'ila lyuwa elime na akungu nu utsuru wi isa'ani e ekere a̱ A̱sulazuva ne e ekere a ama. ");
INSERT INTO tsw_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","Uranu u ro vuma va̱ A̱sula̱ ta̱wa̱ ta̱ uba̱ta̱ wa̱ Eli, a̱vu u damma yi, <<Nda ili i na A̱sulazuva a dammai: <N roco ta̱ aciya̱va̱ a alanga eteshe uba̱ta̱ wa a akaya a̱ ɗu Haruna nu u'wa wa̱ yi mantsa ma na a̱ da̱na̱i e iɗa ya Masar a yuwusaan mogono Firi'awuna tsugbashi. ");
INSERT INTO tsw_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","Agba n ɗangula a̱ yi ta̱ diga a̱tsuma̱ o gundo va aza a Isra'ila suru o'wo nan ganu a̱ va̱, waru a yuwan a̱ga̱nda̱ a masa'a, a̱ kula̱to a̱tsuka̱ a̱ ma̱guru, a̱vu oto epo adama a zami majiyan ma̱ va̱. Waru n ca ta̱ akaya a̱ wu nu u'wa wa̱ yi akunda e le diga a̱ kucci na aa yuwain na akina wa aza a Isra'ila suru. ");
INSERT INTO tsw_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","Nye i zuwai yaa tarasa kucci nu ucasu u na n dammai a̱ ta̱wa̱a̱ uba̱ta̱ wu nden n va̱ ili i ro shi? Nye i zuwai vaa casu muwun ma̱ wu tsugbain ula'awu na̱ a̱mu, na ya aa lyuwusa upasu u na u la'ai ulobonu u kucci va ama a̱ va̱ aza a Isra'ila?> ");
INSERT INTO tsw_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","<<Adama o ndolo A̱sulazuva A̱sula̱ a aza a Isra'ila a ɗa a dammai, <N yuwan ta̱ nzuwulai na amayun ana, u'wa wa̱ wu nu u'wa wa dada va̱ wu ele ɗa a̱ ri n yuwusan a̱ga̱nda̱ a̱ ma̱ka̱ka̱n ma̱ va̱ babu ukotu.> Amma gogo A̱sulazuva a damma ta̱, <Ili i ndolo i ri n yuwan shi! Aza a na a ca numu tsugbain, ele ɗa maa ca tsugbain, amma aza a na o goro numu n ta tara le ili ye pere. ");
INSERT INTO tsw_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","Mantsa ma̱ ta̱ lo a̱ ta̱wa̱ a na moo kototo wu na̱ olobo o u'wa wa dada va̱ wu, hali a̱a̱ tsura̱ za na aa kutsa a̱tsuma̱ o u'wa wa̱ wu shi. ");
INSERT INTO tsw_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","Vu te e ene meleshe ma̱ a̱bunda̱ uba̱ta̱ wu nde n va̱. Amma n ta̱ roco wi isa'ani ekere a Isra'ila, amma za suru o u'wa wa̱ wu u ta̱ kuwa̱ babu u kutsa. ");
INSERT INTO tsw_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","Na̱ n lyawa za a̱tsuma̱ o u'wa wa̱ wu suru a na wa yuwaan mu ulinga u tsuganu a masa'a ma̱ a̱ va̱ wee ene ure shi adama a̱bunda̱ a aɓara na̱ a̱tsuma̱la̱ngu, waru limatan vu u'wa wa̱ wu suru a̱ ta̱ kuwa̱ e ekere matsun me pe'eni. ");
INSERT INTO tsw_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","<< <Nda ili i na yoo o'wo wu iroci, Olobo e re a̱ wu Hofini na̱ Finiha a̱ ta̱ kuwa̱ urana u ta̱. ");
INSERT INTO tsw_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","N ta̱ 'ya̱sa̱a̱n aciya̱va̱ ganu va̱ a̱ɓula̱ za na aa yuwaan mu a̱ga̱nda̱ reve u yuwan ili i na n cigai waru. N ta ca yi limatan va̱ a̱bunda̱ o u'wa wa̱ yi naa n ri koto shi, reve u yuwan a̱ga̱nda̱ elime mogono ma na a na n tsuwa̱n yi mani'in kuci. ");
INSERT INTO tsw_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","Suru za na buwai a̱tsuma̱ a limatan va̱ wu u ta̱ ta̱wa̱ u kingyo wa̱ yi u pati azurufa na̱ ma̱kutsu mo opopofu u damma, <<Zuwa mu ulinga u tsuganu adama n tsa̱ra̱ ilyalya ya alya.>> > >> ");
INSERT INTO tsw_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Molobo Sama'ila u yuwusaan ta̱ A̱sulazuva ulinga e ekere a Eli. A mantsa mo ndolo A̱sulazuva aa yuwusan adanshi na ama kuci shi. Babu a̱bunda̱ a alavu alavu. ");
INSERT INTO tsw_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Urana u ro na ayin Eli za na esu a̱ yi o o'woi ga̱nda̱ ga̱nda̱ na u tse ene mejege shi, u da̱na̱ ta̱ nven asula a̱yi. ");
INSERT INTO tsw_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Babu fitila va̱ A̱sula̱ kima̱, Sama'ila pe nven o u'wa wa̱ a̱ A̱sulazuva, uba̱ta̱ u na Akpati a Nzuwulai a̱ A̱sula̱ a̱ da̱na̱i, ");
INSERT INTO tsw_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","reve A̱sulazuva e ɗe Sama'ila, a̱vu Sama'ila usu, <<Mpa mu nda.>> ");
INSERT INTO tsw_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Reve u suma a̱ tyo uba̱ta̱ wa̱ Eli, a̱vu u damma, <<Mpa mu nda vu ɗe mu ta̱.>> A̱vu Eli usu yi, <<N ɗe wu shi, ka̱ra̱ a̱ ka̱mba̱ vu von.>> Reve u ka̱mba̱ u von. ");
INSERT INTO tsw_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","A̱vu A̱sulazuva a̱ da̱shi ɗe Sama'ila. A̱vu Sama'ila 'yon u 'ya̱wa̱ ya̱ Eli reve u damma, <<Mpa mu nda vu ɗe mu ta̱.>> A̱vu Eli damma, <<Ulobo u va̱, n ɗe wu shi, ka̱ra̱ a̱ ka̱mba̱ vu von.>> ");
INSERT INTO tsw_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Sama'ila gba koto u shi u reve A̱sulazuva shi. Koto A̱sulazuva o roco aciya ya̱ yi uba̱ta̱ wa̱ yi a̱tsuma̱ a adanshi a̱ yi shi. ");
INSERT INTO tsw_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Reve A̱sulazuva e ɗewishe Sama'ila u ɗewu wa ta'atsu, a̱vu Sama'ila 'yon u 'ya̱wa̱ uba̱ta̱ wa̱ Eli a̱vu u damma, <<Mpa mu nda vu ɗe mu ta̱.>> Lo ɗa Eli revei a na A̱sulazuva a ɗa e ɗesu ulobo'o. ");
INSERT INTO tsw_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Ɗaɗa Eli dammai Sama'ila, <<Ka̱ra̱ vu 'ya̱wa̱ vu von, nu u da̱shi ɗe wu a̱vu vu damma, <Yuwan adanshi, A̱sulazuva, adama a na aagbashi a̱ wu a ta uwwusa.> >> Ɗaɗa Sama'ila 'ya̱wa̱ u voyin uba̱ta̱ wu nven ma̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Reve A̱sulazuva a̱ ta̱wa̱ wi isawan uba̱ta̱'a̱, a̱vu u ɗewishe tsu ufaru, <<Sama'ila! Sama'ila!>> A̱vu Sama'ila usu, <<Yuwan adanshi, adama a na aagbashi a̱ wu a ta uwwusa.>> ");
INSERT INTO tsw_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","A̱vu A̱sulazuva a damma yi, <<Gogo, n ciga ta̱ n yuwan ili i ro a̱tsuma̱ a Isra'ila i na vuma na suru uwwa niyi na atsuvu a̱ yi u ta da'wan. ");
INSERT INTO tsw_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","O urana u ndolo n to shiton adanshi a na n yuwain ekere a̱ Eli nu u'wa wa̱ yi, diga o ufaru hali o ukosu suru. ");
INSERT INTO tsw_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Adama a na n damma yi ta̱ n ta paɗaa u'wa wa̱ yi ugana u babu ukotu, adama o unusu u na u revei na̱ a̱yi. Olobo a̱ yi a yuwan ta̱ adanshi a avama e ekere A̱sula̱, agba u ɓara le shi. ");
INSERT INTO tsw_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Adama o ndolo n kucinaa ta̱ u'wa wa̱ Eli, babu kucci ko ucasu u na waa gura tara ume wu unusu wu u'wa wa̱ Eli ko ke'en.>> ");
INSERT INTO tsw_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Reve Sama'ila von hali she usana. Ana u 'yoyin a̱vu u kpa̱tu'wa̱ na̱ntsutsu vu u'wa wa̱ A̱sulazuva. A̱vu wu uwwa wovon u na waa damma Eli alavu alavu'u. ");
INSERT INTO tsw_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Amma Eli ɗe yi ta̱ u damma, <<Sama'ila mawun ma̱ a̱ va̱.>> A̱vu Sama'ila usu, <<Mpa mu nda.>> ");
INSERT INTO tsw_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","A̱vu Eli ece yi, <<Nye i ɗa u damma nuwu? She vu soko mu wan. Lyawa A̱sula̱ a ca wu a̱tsuma̱lima̱ lon na̱ vu damma mu suru ili i na u damma nuwu shi.>> ");
INSERT INTO tsw_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Ɗaɗa Sama'ila damma niyi ili suru, u soko yi ko ili i ta̱ shi. A̱vu Eli damma, <<A̱yi ɗa A̱sulazuva, lyawa u yuwan ili i na i lobono niyi.>> ");
INSERT INTO tsw_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Sama'ila kungwa ta̱, A̱sulazuva gba a̱ da̱na̱ ta̱ oɓolo na̱ a̱yi. Waru u zuwa ta̱ ili i na Sama'ila dammai suru u shiwan. ");
INSERT INTO tsw_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","A̱tsuma̱ a Isra'ila suru diga upasu wu ugana u lyuci wa Dan a̱ tyo upasu wu uyagi u lyuci wa Biyasheba, vuma suru a̱tsuma̱ e iɗa'a u reve ta̱ a na Sama'ila vumava̱sula̱ va̱ A̱sulazuva amayun a ɗa. ");
INSERT INTO tsw_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Reve A̱sulazuva a̱ ka̱ra̱ o rocosu aciya̱yi a̱ Shilo. Ɗe ɗa u rocoi aciya̱yi ya Sama'ila a̱tsuma̱ a adanshi a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","Reve adanshi a Sama'ila a̱ ta̱wa̱ e ekere a aza a Isra'ila suru. A mantsa mo ndolo, aza a Isra'ila o foɓo o uta̱ tsa̱ra̱ a̱ ꞌya̱wa̱a̱ aza a Filistiya nu uvon. Reve aza a Isra'ila a̱ va̱la̱ Ebeniza, reve aza a Filistiya a̱ va̱la̱ a Afe. ");
INSERT INTO tsw_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","Reve aza a Filistiya e gere adama o uvon. Ana a yuwain uvon wu usuɗuwu, reve a lyuwa aza a Isra'ila nu uvon, reve o una ama ukpakukupa una̱shi (4,000) uba̱ta̱ wu uvon. ");
INSERT INTO tsw_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","Ana a̱soja a Isra'ila a̱ ka̱mba̱i o uva̱la̱ta̱, reve mbara ma aza a Isra'ila e ece, <<Nye i zuwai A̱sulazuva a lyawai aza a Filistiya a lyuwa ntsu ana'an? Lyawai tsu ta̱wa̱ na Akpati a Nzuwulai a̱ A̱sulazuva pa nda za na ri Shilo, adama u 'ya̱wa̱ oɓolo na̱ a̱ tsu waru u wawa tsu e ekere a n'yuwatan n tsu.>> ");
INSERT INTO tsw_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","Reve a̱ lyungu ama a̱ 'ya̱wa̱ Shilo, a̱vu a̱ ta̱wa̱ na̱ Akpati a Nzuwulai a̱ A̱sulazuva o oɓolo a̱ a̱soja a̱ zuva, za na ri nden a̱ memere me ikerobobi. Olobo e re a Eli, Hofini na̱ Finiha, a̱ shi ta̱ oɓolo na Akpati a Nzuwulai a̱ A̱sula̱'a̱. ");
INSERT INTO tsw_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","Ana Akpati a Nzuwulai a̱ A̱sulazuva a̱ ta̱wa̱i a̱tsuma̱ o uva̱la̱ta̱, reve aza a Isra'ila suru o oruwo lon adama a̱ ma̱za̱nga̱ hali iɗa i jinga̱ɗa̱. ");
INSERT INTO tsw_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","Ana aza a Filistiya a uwwai yorori a̱vu a damma, <<Nye i ɗa i ta̱wa̱i na̱ yorori i nda lon o uva̱la̱ta̱ wu mmaci ma Ibrahim?>> Ana a uwwai a na Akpati a̱ A̱sulazuva a ɗa a̱ ta̱wa̱i a̱tsuma̱ o uva̱la̱ta̱, ");
INSERT INTO tsw_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","reve wovon u reme aza a Filistiya'a. Reve a damma, <<Musula̱ a̱ ta̱wa̱ ta̱ a̱tsuma̱ o uva̱la̱ta̱'a̱.>> A̱vu a damma, <<Addama a cina tsu ta̱, adama a na koto a yuwan cu'un vi ili tsunda shi. ");
INSERT INTO tsw_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","A̱tsuma̱lima̱ a cina tsu ta̱, zane ɗa aa wawa tsu e ekere a̱ musula̱ mu ucira n nda? Ele ɗa musula̱ n na n lapai aza a Masar na̱ cu'un vu mɓa̱la̱ suru a̱tsumona. ");
INSERT INTO tsw_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","A̱ɗu aza a Filistiya, gbamai okolo yo o ali adama yo o'wo agbashi a mmaci ma Ibrahim a nda cine a̱ shi agbashi a̱ ɗu wan. Yuwain ali, i yuwan uvon!>> ");
INSERT INTO tsw_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","Reve gba aza a Filistiya a yuwan uvon lon, reve a lyuwa aza a Isra'ila. A̱vu vuma suru suma a̱ ka̱mba̱ o oogodo a̱ yi. O una ta̱ ama a̱bunda̱ lon. Aza a Isra'ila a lamba ta̱ a̱soja a ana a na a̱ da̱na̱i a ana ukpakukupa mataꞌatsu (30,000) o urana u ndolo. ");
INSERT INTO tsw_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","A usa ta̱ Akpati a Nzuwulai a̱ A̱sula̱. Reve waru o una olobo e re a̱ Eli, Hofini na̱ Finiha. ");
INSERT INTO tsw_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","A̱vu vuma ro o ugundo wa Banyami suma diga uba̱ta̱ wu uvon, a̱vu u ta̱wa̱ Shilo o urana u ndolo'o na̱ a̱tugu a̱ yi wu karu na̱ ma̱buta̱ aaci a̱ yi, adama u roco wo a̱tsuma̱la̱ngu. ");
INSERT INTO tsw_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","Ana u rawai, Eli da̱na̱ ta̱ lo nden o ootogu a̱ yi a̱ nge'en mu ure a̱ ka̱lyuwusa̱, adama a na okolo a̱ yi a̱ da̱na̱ ta̱ e meje'en adama a gbaga va Akpati a Nzuwulai a̱ A̱sula̱. Ana vuma'a u uwai a̱ lyuci'i, a̱vu u ca aalabari'i. A̱vu lyuci'i suru gidu'wa̱ na̱ mesun. ");
INSERT INTO tsw_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","Ana Eli uwwai uɗyo u mesun, a̱vu we ece, <<Nye i ɗa i zuwai mesun ma̱ 'yoyin ne tsunda?>> Reve vuma'a u jika̱ u 'ya̱wa̱ ya̱ Eli, ");
INSERT INTO tsw_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","za na da̱na̱i na a'wan kupakucci na̱ kunla̱, waru esu a̱ yi o o'woi ga̱nda̱ ga̱nda̱ u tse ene shi. ");
INSERT INTO tsw_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","A̱vu vuma'a u damma Eli, <<Gogo nda ɗa n ka̱mba̱i diga uba̱ta̱ wu uvon, waru ana'an n suma ta̱ diga ɗe.>> Reve Eli ece yi, <<Nye i ɗa i farai, ulobo u va̱?>> ");
INSERT INTO tsw_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","Reve malingata'a ma̱ usu, <<Aza a Isra'ila a sumaa ta̱ aza a Filistiya, o una ta̱ a̱za̱ o uvon na̱ a̱bunda̱. Waru olobo e re a̱ wu Hofini na̱ Finiha a̱ kuwa̱ ta̱. Waru a usa ta̱ Akpati a Nzuwulai a̱ A̱sula̱.>> ");
INSERT INTO tsw_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","Ana wu uwwai a̱ ɗeyi aala a Akpati a Nzuwulai a̱ A̱sula̱, a̱vu Eli riya̱ melene diga o ootogu a̱ yi uba̱ta̱ u na u da̱na̱i nden e nge'en mo una̱ntsutsu u lyuci. A̱vu yinlu ya̱ yi i kuɗa reve u kuwa̱, adama a na u kutsa ta̱ waru u ta̱ mgbain. U yuwan ta̱ tsugbain tsa aza a Isra'ila a'wan amunga. ");
INSERT INTO tsw_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","Jene va̱ yi, ka va Finiha da̱na̱ ta̱ na̱ a̱tsuma̱ ukotu azama limatan. Ana wu uwwai alabari a na a usa ta̱ Akpati a Nzuwulai a̱ A̱sula̱ na alabari a̱ a̱sha̱wa̱le na̱ vali va̱ yi a̱ kuwa̱ ta̱, ɗaɗa mɓa̱la̱ m limatan n reme niyi, reve u da̱nu teri a̱vu u matsan. ");
INSERT INTO tsw_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","A̱yi azama u kuwa̱, a̱vu a̱ma̱ci a na a̱ ri uɓa̱nu na̱ a̱yi a damma yi, <<She vu uwwa wovon wan, vu matsan ta̱ ulobo.>> Agba u usu ko u ka̱mbuwa̱ ugbozu shi. ");
INSERT INTO tsw_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","Reve u ca ulobo'o aala Ikabo, a dansa, <<Tsugbain tsa kasa ta̱ na̱ Isra'ila.>> Adama a na a usa ta̱ Akpati a Nzuwulai a̱ A̱sula̱ a̱ tyo we e iɗa yo omocin nu ukwa̱ wa̱ a̱sha̱wa̱le na̱ vali va̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","A̱vu u damma, <<Tsugbain tsa kasa ta̱ na̱ Isra'ila, adama a na a usa ta̱ Akpati a Nzuwulai a̱ A̱sula̱ a̱ tyo we e iɗa yo omocin.>> ");
INSERT INTO tsw_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","Ana aza a Filistiya a usai Akpati a Nzuwulai a̱ A̱sula̱'a̱, a̱vu a tara yi diga Ebeniza a̱ tyo Ashido. ");
INSERT INTO tsw_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","A̱vu a uwa to Akpati a Nzuwulai a̱ A̱sula̱'a̱, o u'wa u ma̱sula̱ ma Dagon, a̱vu a zuwa yi zuzu na̱ Dagon. ");
INSERT INTO tsw_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","Ana aza a Ashido a̱ 'yoyin na̱ wasasa usana a matawaa a̱vu a cina Dagon riya̱ ma̱kpa̱ɓa̱ e iɗa elime a Akpati a Nzuwulai a̱ A̱sulazuva. A̱vu a̱ 'ya̱sa̱n Dagon a̱ ka̱mbuwa̱ yi uba̱ta̱ u na u shi. ");
INSERT INTO tsw_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","Amma ana usana u tawisai na̱ wasasa ana a̱ 'yoyin, reve a cina Dagon riya̱ ma̱kpa̱ɓa̱ e iɗa elime a Akpati a Nzuwulai a̱ A̱sulazuva. A̱vu aaci a̱ yi ne ekere a̱ yi suru o koɗuloi reve u da̱na̱ nven o una̱ wu una̱ntsutsu, lipu va̱ yi ɗa goon shi buwai. ");
INSERT INTO tsw_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","A̱yi ɗa i zuwai hali na ana'an babu ganu va Dagon ko aza a na a uwusa o u'wa ma̱sula̱ ma Dagon a̱tsuma̱ a Ashido a na u tsu dasa una̱ wu una̱ntsutsu wa Dagon. ");
INSERT INTO tsw_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","A̱vu ukere wu ume wa̱ A̱sulazuva u ga̱la̱ aza a Ashido, oɓolo na̱ mulyuci n na a̱ ri uka̱nda̱ruwu ne ele na̱ meleshe ma̱ a̱bunda̱ ma amicin. ");
INSERT INTO tsw_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","Ana ama a Ashido enei ne, ɗaɗa a dammai, <<She tsu lyawai Akpati a Nzuwulai a̱ ma̱sula̱ a aza a Isra'ila ma̱ da̱na̱ pa oɓolo na̱ a̱tsu wan! Adama a na ukere wu ume wa̱ A̱sulazuva u ta̱ a̱ nla̱ngi na̱ tsu lon, oɓolo na̱ Dagon ma̱sula̱ ma̱ a̱ tsu.>> ");
INSERT INTO tsw_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","A̱vu ama a Ashido a̱ lyunguwa̱ a azagbain a Filistiya suru na̱ nlingata o ɓoloto, reve e ece le, <<Nye i ɗa tsaa yuwain na Akpati a Nzuwulai a̱ ma̱sula̱ ma aza a Isra'ila?>> Reve a̱ usu, <<Tarai Akpati a Nzuwulai a̱ ma̱sula̱ ma a aza a Isra'ila a̱ tyo a̱ lyuci va Gat.>> Ɗaɗa a tarai Akpati a Nzuwulai a̱ ma̱sula̱ ma a aza a Isra'ila a̱ tyo Gat. ");
INSERT INTO tsw_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","Agba ana a tara niyi a̱ tyo ɗe, a̱vu ukere wu ume wa̱ A̱sulazuva u ga̱la̱ lyuci'i, a̱vu wu da'waton le lon. A̱vu u lyunguwa̱ ama a̱ lyuci'i na̱ mɓa̱la̱ ma amici. Zagbain na̱ mawun suru e reme ta̱ amici'in. ");
INSERT INTO tsw_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","Ɗaɗa a tarai Akpati a Nzuwulai a̱ A̱sula̱ a̱ tyo Ekuron. Ana Akpati a Nzuwulai a̱ A̱sula̱'a̱ a uwai pe, a̱vu a aza a Ekuron o ɓosho na̱ yisali, a damma, <<A̱ ta̱wa̱ ta̱ na Akpati a Nzuwulai a̱ ma̱sula̱ ma a aza a Isra'ila pa ya̱'a̱ tsu adama wu una tsu oɓolo na ama a̱ tsu.>> ");
INSERT INTO tsw_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","A̱vu a̱ lyunguwa̱ azagbain a aza a Filistiya suru na̱ nlingata reve o ɓoloto le, reve a damma, <<Tarai Akpati a Nzuwulai a̱ ma̱sula̱ ma a aza Isra'ila a̱ ka̱mba̱ uba̱ta̱ u na wu uta̱i, ta̱wa̱ wu una tsu na ama a̱ tsu suru wan.>> Adama a na lyuci'i u shiwan ta̱ na̱ wovon wu ukwa̱ lon, adama a na ukere wu ume wa̱ A̱sulazuva u ga̱la̱ le ta̱ uga̱lu lon. ");
INSERT INTO tsw_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","Ozo o ro a̱tsuma̱ lyuci'i a̱ kuwa̱ ta̱ ɗe, waru akapi a na a buwai a̱ ta̱ pe a̱tsuma̱lima̱ adama a amicin a na a̱ ri nle a̱ lipu. A̱vu suru nle e showen ma̱sula̱ ma̱ le adama u kamba le. ");
INSERT INTO tsw_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","Akpati a Nzuwulai a̱ A̱sulazuva a yuwan ta̱ woto cindere e iɗa ya Filistiya. ");
INSERT INTO tsw_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","Reve aza a Filistiya e ɗe nan ganu na̱ a̱za̱ a̱ yindi a̱vu a damma le, <<Nye i ɗa tsaa yuwan na Akpati a Nzuwulai a̱ A̱sulazuva? Damma ntsu cine tsa̱a̱ ka̱mbuwa̱ yi uba̱ta̱ u na wu uta̱i.>> ");
INSERT INTO tsw_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","Reve a̱ usu, <<Na̱ ya̱a̱ ka̱mbuwa̱ Akpati a Nzuwulai a̱ ma̱sula̱ ma aza a Isra'ila, she i ka̱mbuwa̱ yi lya̱nga̱ wan, amma i ta lyungu yi oɓolo na̱ kucci makuɗa ma̱ wila̱. Ne ɗa ya̱a̱ ka̱mba̱ gbaga, waru i te reve ili i na i zuwai ukere wa̱ A̱sulazuva a̱a̱ ga̱ga̱la̱ nɗu.>> ");
INSERT INTO tsw_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","A̱vu aza a Filistiya a yuwan yeci, <<Cu'un kucci makuɗa ma̱ wila̱ u ne ɗa tsa̱a̱ lyunguwa̱ yi?>> Reve a̱ usu, <<Yuwayin uma'an wa amicin a zinariya o ton na̱ a̱ga̱ɗa̱ o ton a zinariya, o una̱ wa̱ a̱bunda̱ azagbain wa aza a Filistiya, adama a na cu'un vu mɓa̱la̱ n ta̱ n ɗa n reme nɗu na̱ azagbain a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","Yuwain amicin na̱ a̱ga̱ɗa̱ a na a̱ tsu lyungususa̱ iɗa i ɗu. Na̱ ne ɗa yaa ca ma̱sula̱ ma aza a Isra'ila tsugbain. U ta gura yuwan u tawa oforo a aci a̱ ɗu na̱ musula̱ n ɗu ni iɗa i ɗu. ");
INSERT INTO tsw_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","Nye i zuwai yaa yuwusan aciyogbamu cine aza a Masar na̱ Firi'awuna yuwain? She na A̱sula̱ ma aza a Isra'ila mo o'wo to nle ili yu ulamu ɗaɗa u lyawa nle a̱ ka̱ra̱i shi? ");
INSERT INTO tsw_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","<<Gogo she i yuwan keke vi inan sa'avu, na̱ a̱na̱wun e inan e re aza a na a matsain usa'avu, waru aza a na koto a̱ nla̱ le a̱gba̱la̱ e keke vi inan shi. Yi nla̱ ina'an e keke sa'avu'u, amma i takatsuwa na̱ muwu'un a̱vu i gutsu le o u'wa. ");
INSERT INTO tsw_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","I tara Akpati a Nzuwulai a̱ A̱sulazuva a̱vu i zuwa yi e keke, na akpati o ro vu uma'a wa̱ a̱ga̱ɗa̱ na̱ aza a amicin a zinariya zuzu na̱ a̱ yi, za na ya̱a̱ lyungu wa̱ yi o una̱ u kucci makuɗa ma̱ wila̱. A̱vu i lyawa le a̱ ka̱ra̱. ");
INSERT INTO tsw_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","Amma yi idana uba̱ta̱ u na a saɓa. Na̱ a̱ kuru agawan a̱ tyo o upasu wa̱ yi a̱ tyo Bet Shemesh, wo o'wo ta̱ A̱sula̱ a aza a Isra'ila a ɗa ma̱ lyunguwa̱a̱ ntsu a̱tsuma̱lima̱ a gbain a nda. Amma na a yuwan ne shi, tsu ta̱ reve a na ukere wa̱ yi u ɗa u lapa ntsu shi, mɓa̱la̱ n ɗa goon n ta̱wa̱ ntsu.>> ");
INSERT INTO tsw_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","Reve ama'a a yuwan cine a damma nle. A̱vu a zami inan i re a̱vu a̱ nla̱a̱ le keke vi inan, reve e reme muwu'un a̱ gutsu le o u'wa. ");
INSERT INTO tsw_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","Reve a zuwa Akpati a Nzuwulai a̱ A̱sulazuva e keke'e oɓolo na akpati o ro o uma'an u zinariya va̱ a̱ga̱ɗa̱ nu uma'an wa amicin oɓolo na̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","A̱vu ina'an i kuru ure mejege a̱ tyo ugawun wu upasu wu utyo wa Bet Shemesh, a̱vu e reme ure na a sali o ure, agba a vadaluwa usa'ani ko ugula̱ shi. A̱vu azagbain a aza a Filistiya a̱ kuru le hali a̱ tyo wu upasu wu utyo wa Bet Shemesh. ");
INSERT INTO tsw_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","A mantsa'a ama a Bet Shemesh a̱ da̱na̱ ta̱ o ugasa wo oroci a yitabo o uka̱ri. Ana a̱ 'ya̱sa̱in aaci e le reve e ene Akpati'i, a̱vu a uwa ma̱za̱nga̱ ma na e ene niyi. ");
INSERT INTO tsw_vpl VALUES ("S16_14","010_6_14","1SA","6","14","14","Ana keke'e u rawai o uɗuma̱ wa̱ Josuwa va Bet Shemesh a̱vu wi isawan lo zuzu na aatali a gbain o ro. A̱vu ama'a a ɓatsa a̱gba̱la̱ a̱ keke'e reve a paɗa ina'an, a̱vu a yuwaan A̱sulazuva kucci vu ukula̱tosu na̱ le. ");
INSERT INTO tsw_vpl VALUES ("S16_15","010_6_15","1SA","6","15","15","Ama o ugundo wa̱ Levi a̱ shi ta̱ ɗe a̱ cipa̱to Akpati a Nzuwulai a̱ A̱sulazuva'a zuva keke'e, oɓolo na akpati a na a̱ ri nu uma'an u zinariya. A̱vu a zuwa le a aatali a gbai'in. O urana u ndolo ama a Bet Shemesh a ca ta̱ kucci vu ukula̱tosu na̱ kucci ro uba̱ta̱ wa̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","Ana azagbain o ton ma aza a Filistiya me enei ili i na suru i farai reve a gitsa o urana u ndolo'o a̱ ka̱mba̱ Ekuron. ");
INSERT INTO tsw_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","Apa nda uma'an u zinariya wa amicin na aza a Filistiya a̱ lyunguyi adama wo o'wo kucci makuɗa ma̱ wila̱ uba̱ta̱ wa̱ A̱sulazuva. Za ta̱ adama e ilyuci ya Ashido, za ta̱ adama a Gaza, za ta̱ adama a Ashikelon, za ta̱ adama a Gat, za ta̱ waru adama a Ekuron. ");
INSERT INTO tsw_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","A̱bunda̱ a̱ a̱ga̱ɗa̱ o uma'an u zinariya'a u da̱na̱ ta̱ una̱ta̱ na̱ a̱bunda̱ e ilyuci ya azagbain o ton ndolo ma Filistiya. Ilyuci'i o ɓolo ta̱ ni ilyuci i na a suwayi kari vu ucira oɓolo na̱ mulyuci ma̱ a̱bunda̱ n na n ri na̱ kari shi. Aatali a gbain a na a zuwai Akpati a Nzuwulai ma̱ A̱sulazuva ɗe, za na ri uba̱ta̱ o uɗuma̱ wa̱ Josuwa vuma va Bet Shemesh u ta̱ lo o una̱ wu urotsu hali na ana'an. ");
INSERT INTO tsw_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","A̱vu A̱sula̱ o una ama kupocindere aza a Bet Shemesh adama a na a̱ ka̱lyuwa̱ ta̱ a̱tsuma̱ Akpati a Nzuwulai a̱ A̱sulazuva'a. Reve ama a yuwan nden n wiruta̱ lon adama a ama a̱ a̱bunda̱ a na A̱sulazuva a lapa nle i ɗa. ");
INSERT INTO tsw_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","A̱vu aza a Bet Shemesh a damma, <<Zane ɗa a gura isawan elime a̱ A̱sulazuva, A̱sula̱ a akiza a nda? Uba̱ta̱ wa̱ zane u ɗa tsa̱a̱ lyunguwa̱ Akpati a Nzuwulai a̱ A̱sulazuva tsa̱ra̱ wu kasa na̱ a̱tsu?>> ");
INSERT INTO tsw_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","A̱vu a̱ lyungu nlingata a̱ tyo uba̱ta̱ wa ama a Kiriyat Jeyarim ana, <<Aza a Filistiya a̱ ka̱mbuwa̱ ta̱ Akpati a Nzuwulai a̱ A̱sulazuva. Cipa̱i i tara yi a̱ tyo uba̱ta̱ u ɗu.>> ");
INSERT INTO tsw_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","Reve ama a Kiriyat Jeyarim a̱ cipa̱ a tara a gawan Akpati a Nzuwulai a̱ A̱sulazuva a̱ tyo o u'wa wa Abinada za na ri a aagaɗi. A̱vu a tawa Eliyaza ulobo wa̱ yi u yuwan ipiri ya Akpati a Nzuwulai a̱ A̱sulazuva'a. ");
INSERT INTO tsw_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","Akpati a Nzuwulai'i a jima ta̱ a̱ lyuci va Kiriyat Jeyarim hali a'wan ushin. A̱tsuma̱ a mantsa mo ndolo, reve aza a Isra'ila suru e showen A̱sulazuva adama u kamba le. ");
INSERT INTO tsw_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","Reve Sama'ila damma suru u'wa wa Isra'ila, <<Na̱ ya̱a̱ ka̱mba̱ uba̱ta̱ wa̱ A̱sulazuva no okolo a̱ ɗu suru, to, yoo oco musula̱ mo omocin a na a̱ ri a̱tsuma̱ a̱ ɗu na̱ a̱ma̱li a Ashitore. Reve i ca aciya̱ɗu suru e ekere a̱ A̱sulazuva, reve waru i yuwaan yi a̱ga̱nda̱ goon. Ne ɗa waa wawa ɗu e ekere a aza a Filistiya.>> ");
INSERT INTO tsw_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","Reve aza a Isra'ila o oco a̱ma̱li a Ba'al na̱ a Ashitore, reve a yuwaan A̱sulazuva goon a̱ga̱nda̱. ");
INSERT INTO tsw_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","Reve Sama'ila damma, <<Ɓolotoi aza a Isra'ila suru ɗe Mizfa, n ta pati A̱sulazuva adama a̱ ɗu ɗe.>> ");
INSERT INTO tsw_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","Ana o ɓolotoi ɗe Mizfa, reve e kene mini a̱vu o oco yi e iɗa a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. Reve a yuwan akuli o urana u ndolo ma̱ɓula̱ reve a damma, <<Tsu yuwaan ta̱ A̱sulazuva unusu.>> Reve Sama'ila yuwan tsugbain tsa a aza a Isra'ila a Mizfa. ");
INSERT INTO tsw_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","Ana azagbain aza a Filistiya a uwwai a na aza a Isra'ila o ɓoloto ta̱ a Mizfa, reve azagbain aza a Filistiya o uta̱ a gawan tsa̱ra̱ a̱ riya̱a̱ le nu uvon. Reve ana aza a Isra'ila a uwwai a̱ ta̱ lo a̱ ta̱wa̱, a uwwa ta̱ wovon wa aza a Filistiya. ");
INSERT INTO tsw_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","Reve aza a Isra'ila a damma Sama'ila, <<Lyuwa elime na̱ mesun a̱ tyo e ekere a̱ A̱sulazuva A̱sula̱ a̱ tsu, tsa̱ra̱ u wawa tsu e ekere aza a Filistiya.>> ");
INSERT INTO tsw_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Reve Sama'ila paɗa mokyokyon, reve u ca kucci vu ukula̱tosu suru a̱ tyo ekere a̱ A̱sulazuva. Reve u pati A̱sulazuva a kamba aza a Isra'ila, reve gba u usu avasa a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","A̱yi a̱tsuma̱ o casu kucci vu ukula̱tosu'u, reve aza a Filistiya a rawa adama a yuwan uvon na aza a Isra'ila. Amma o urana u ndolo gba reve A̱sulazuva a yuwan tsata tsu ucira a aci aza a Filistiya, reve u zuwa le a̱ ra̱pula̱. Ɗaɗa u lyuwa nle nu uvon, elime aza a Isra'ila. ");
INSERT INTO tsw_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","Reve aza a Isra'ila o uta̱ ni ilaɗi diga Mizfa, reve o lo le o unusa le o ure hali a rawa uba̱ta̱ u ro zuzu na̱ Bet Ka. ");
INSERT INTO tsw_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","Reve Sama'ila shuwa̱ aatali a gbain e memere ma Mizfa na̱ Shen. Reve u ca aataliꞌi aala Ebeniza, adansa, <<A̱sulazuva a ɗa a kamba n tsu hali acina gogo.>> ");
INSERT INTO tsw_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","Ne ɗa a lyuwai aci a aza a Filistiya, waru a̱ da̱shi uwa upasu wi iɗa wa aza a Isra'ila shi. Suru a mantsa ma wuma wa Sama'ila, ukere wa̱ A̱sulazuva u da̱na̱ ta̱ a̱ nla̱ngi na aza a Filistiya. ");
INSERT INTO tsw_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","Reve a̱ ka̱mbuwa̱a̱ aza a Isra'ila ilyuci i le aza a na aza a Filistiya a usa nle i ɗa, diga Ekuron a̱ tyo Gat. Aza a Isra'ila gba a wawa ta̱ pasu vi ilyuci i le suru diga e ekere a aza a Filistiya. Waru a̱tsura̱ ta̱ asuvu nden ekere aza a Isra'ila na̱ aza a Amoriya. ");
INSERT INTO tsw_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","Ne ɗa Sama'ila lyuwai elime na̱ tsugbain tsa aza a Isra'ila hali ukosu u wuma wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","A aa'wan suru, u tsu 'ya̱wa̱ ta̱ a̱ka̱nda̱riya̱ diga Betel a̱ tyo Gilga na̱ Mizfa ba̱ta̱ na u da̱na̱i za vu uge'etosu wa a aza a Isra'ila. ");
INSERT INTO tsw_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","Amma u tsu ka̱mbisa̱ ta̱ Rama a̱ lyuci va̱ yi, uba̱ta̱ u na u tsu yuwusaan fo aza a Isra'ila uge'etosu. Waru u suwaa ta̱ A̱sulazuva masa'a ɗe a Rama. ");
INSERT INTO tsw_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Ana Sama'ila kutsai, reve wo o'woto olobo a̱ yi a̱za̱ o uge'etosu aciya a aza a Isra'ila. ");
INSERT INTO tsw_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","Aala o ulobo wu ufaru wa̱ yi u ɗa Juwe, aala aza ire waru Abija. A̱da̱na̱ ta̱ o ulinga wu uge'etosu a̱ lyuci va Biyasheba. ");
INSERT INTO tsw_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Agba ele a̱ da̱na̱ cine dada le da̱na̱i shi, a̱ shi ta̱ a̱ ka̱mbuwa̱ ugbozu u le e icigi yi ikebe lon. A̱ ushishi ta̱ utowusu wu una̱, a yuwusan uge'etosu u sa'ani shi. ");
INSERT INTO tsw_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Reve mbara ma aza a Isra'ila o ɓoloto, a̱vu a̱ 'ya̱wa̱ uba̱ta̱ wa Sama'ila ɗe Rama. ");
INSERT INTO tsw_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","Reve a damma yi, <<Gogo vu kutsa ta̱, waru olobo a̱ wu a̱ ri cine vu ri shi. Adama o ndolo vu ca tsu mogono za na e ge'eto tsu waru u rono tsu aɗanga cine akapi a nɗa a̱ ri.>> ");
INSERT INTO tsw_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Ana a damma niyi, <<Ca tsu mogono za na e ge'eto tsu waru u rono tsu aɗanga,>> Sama'ila uwwa uyoꞌo shi ko ke'en. Reve u yuwan avasa a̱ tyo uba̱ta̱ wa̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Reve A̱sulazuva a damma Sama'ila, <<Zuwa atsuvu e ili i na aa dansa wu suru. Adama a na a̱vu ɗa a̱ 'yuwain shi amma a̱mu ɗa a 'yuwain mo o'wo mogono me ele. ");
INSERT INTO tsw_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Cine a yuwain diga urana u na mu uta̱a̱ nle diga Masar hali a̱ tyo ana'an a lyawa numu ta̱ reve a yuwaan musula̱ n ro a̱ga̱nda̱. Waru ne ɗa aa yuwusaan wu. ");
INSERT INTO tsw_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","To, gogo vu zuwaa le atsuvu, amma gba vu rono le atsuvu lon e ili i na mogono ma na maa yuwan tsugbain a aci e le waa yuwan ne ele.>> ");
INSERT INTO tsw_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Reve Sama'ila ka̱mbuwa̱ ama a na a patishi niyi mogono ili i na A̱sulazuva a dammai suru. ");
INSERT INTO tsw_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","A̱vu u damma le, <<Nda ili i na mogono ma na maa yuwan tsugbain a aci a̱ ɗu waa yuwan na̱ a̱ɗu. U ta tara o olobo a̱ ɗu u zuwa le o'wo a̱soja a̱ yi, o ozo o ro o to o'wo a̱za̱ o ulinga ni ikeke yi ido yu uvon ya̱ yi, ozo o ro waru a ta kumba ido ya̱ yi, ozo o ro waru o to o'wo aza a na aa suma elime e ikeke yi ido yu uvon. ");
INSERT INTO tsw_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Ozo o ro waru u ta zuwa le o'wo yali a̱ a̱soja ukpakukupa (1000) na̱ a̱soja kupoton, ozo o ro waru a ta yuwan iluma yu uɗuma̱ wa̱ yi, a̱vu a gasa ishina ya̱ yi, a̱vu a rumaa yi itana yu uvon oɓolo ni itana yu ulinga adama e ikeke yi ido ya̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","U ta tara esheli a̱ ɗu u zuwa le mayan ma mani'in ma̱ ma̱guru, na̱ mpondo, nu ukangalu. ");
INSERT INTO tsw_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","U ta usa pasu va̱ a̱ɗuma̱ a̱ ɗu a na a la'ai ulobonu, na̱ a̱ɗuma̱ a̱ ina̱bi a̱ ɗu, na̱ za vu ɗanga zetun u ca azagbain a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","U ta usa za ta̱ a̱tsuma̱ a kupa vi itana yu una i ɗu, na̱ a̱za̱ a̱ ina̱bi a̱ ɗu, reve u ca azagbain o ukobu wa̱ yi oɓolo na akapi azagbain a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","U ta usa agbashi a̱ ɗu aza a ali na̱ a̱za̱ a̱ a̱ma̱ci, ni inan i ɗu aza a na a la'ai u ulobonu, na̱ nloli n nɗu, adama a yuwusaan yi ulinga. ");
INSERT INTO tsw_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","U ta usa za ta̱ a̱tsuma̱ a kupa vo oɓolo e ikyon i ɗu. Waru a̱ɗu na aciya̱ɗu i to o'wo agbashi a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Nu uranu u ndolo u ta̱wa̱, i ta̱ shon adama o mogono ma na i ɗangulayi aciya̱ɗu, agba A̱sulazuva a̱ usu ɗu shi.>> ");
INSERT INTO tsw_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Agba ama'a a zuwaa Sama'ila atsuvu e ili i na u damma nle shi. Reve a damma, <<Ko na̱ ne, tsu ciga ta̱ mogono ma na moo rono tsu aɗanga. ");
INSERT INTO tsw_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Ne ɗa tsoo o'wo cine akapi a nɗa a̱ ri. A̱yi ɗa woo o'wo tsu zagbain zana e ge'eto tsu waru a̱yi ɗa woo rono a̱ tsu aɗanga a̱ tyo uba̱ta̱ o uvon.>> ");
INSERT INTO tsw_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Ana Sama'ila uwwai ili i na ama'a a dammai suru, reve u cuɗuwa A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","A̱vu A̱sulazuva a damma, <<Vu zuwaa le atsuvu a̱vu vu ca le mogono.>> A̱vu Sama'ila damma aza a Isra'ila, <<Vuma suru ka̱mba̱ a̱ lyuci va̱ yi.>> ");
INSERT INTO tsw_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","A yuwan ta̱ vuma gbain vu utsuru u ro diga o ugundo wa Banyami, za na da̱na̱i na aala Kish ulobo wa Abiyel ulobo wa Zero ulobo wa Bekora, ulobo wa Afiya za vu ugundo wa Banyami. ");
INSERT INTO tsw_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","U ta̱ nu ulobo u na a̱ tsu ɗe Shawulu, babu za va Isra'ila na la'a niyi ulobonu. U la'a ta̱ ama a Isra'ila suru uga'an. ");
INSERT INTO tsw_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Urana u ro, reve a̱na̱wu o nloli ma̱ Kish dada va Shawulu m puwa̱n, reve u damma Shawulu, <<Tara aagbashi a̱ ta̱ oɓolo na̱ a̱vu, tsa̱ra̱ i 'ya̱wa̱ i zami i le.>> ");
INSERT INTO tsw_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","Reve a̱ kuru a̱ tyo e iɗa ya agaɗi ya Ifiramu ni iɗa ya Shalisha, agba a̱ tsura̱ e ene nloli'i shi. Reve a̱ ka̱ra̱ a̱ 'ya̱wa̱ e iɗa ya Sha'alim, agba nloli'i mu ɗe shi. Reve fo a̱ ka̱ra̱ a̱ tyo e iɗa ya Banyami, agba suru a̱ tsura̱ e ene le shi. ");
INSERT INTO tsw_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Ana a rawai e iɗa ya Zuf reve Shawulu damma aagbashi a na a̱ ri oɓolo na̱ a̱yi, <<Tsu ka̱mba̱ o u'wa fa. Na̱ ne ɗa shi, dada va̱ ta lyawa udamu wa̱ a̱na̱wu o nloli reve u reme udamu adama a̱ tsu.>> ");
INSERT INTO tsw_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Amma a̱vu aagbashi'i a̱ usu yi u damma, <<Ka̱lyuwa̱ a̱ ta̱ pa na̱ vuma va̱ A̱sula̱ o ro a̱tsuma̱ a̱ lyuci nda za na a casu tsugbain lon, adama a na suru ili i na u dammai u tsu shiwan ta̱. Tsu ka̱ra̱ a̱ tyo uba̱ta̱ wa̱ yi gogo, u ta gura wo o'wo u damma tsu uba̱ta̱ u na tsoo toni.>> ");
INSERT INTO tsw_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","Reve Shawulu ece aagbashi a̱ yi, <<To, na̱ tsu 'ya̱wa̱ uba̱ta̱ wa̱ yi nye i ɗa tsaa ca yi? Ilyalya i na tsu ri na̱ a̱yi a̱tsuma̱ e itsa̱n o koto ta̱, agba tsu ri ni ili i na tsaa ca yi shi. Ko tsu ta̱ na̱ i ili i ro i na tsa ca yi?>> ");
INSERT INTO tsw_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","Reve aagbashi'i a̱ usuwisa̱ Shawulu u damma, <<Ka̱lyuwa̱, n ta̱ pa ni ikebe i azurufa ke'en. N ta ca vuma va̱ A̱sula̱'a̱ adama u damma tsu uba̱ta̱ u na tsoo toni.>> ");
INSERT INTO tsw_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","Cine u shi a̱tsuma̱ a Isra'ila na̱ vuma ciga we ece A̱sula̱, u tsu damma ta̱, <<Ta̱wa̱ tsu 'ya̱wa̱ uba̱ta̱ wu za yindi,>> adama a na za na a̱ tsu ɗe vumava̱sula̱ ana'an, a̱ shi ta̱ a̱ tsu ɗe yi za yindi. ");
INSERT INTO tsw_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","Reve Shawulu damma aagbashi a̱ yi, <<U lobono ta̱, ta̱wa̱ tsu ka̱ra̱.>> A̱vu e reme ure a̱ tyo a̱ lyuci na vuma va̱ A̱sula̱ da̱na̱i. ");
INSERT INTO tsw_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","A mantsa ma na a̱ da̱na̱i a kumbusa aagaɗi a̱ tyo a̱ lyuci'i, reve a ga'an ne esheli a na a̱a̱ 'ya̱wa̱ o ooko'o adama e kene mini, reve e ece e le, <<Za yindi ta̱ pa nda'a?>> ");
INSERT INTO tsw_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","Reve a̱ usu a damma, <<U ta̱ pa, u ta̱ ɗe elime a̱ ɗu. Jika̱i adama a na gogo ɗa u uwai a̱tsuma̱ a̱ lyuci'i, adama a na ana'an ama a̱ ta̱ na̱ kucci uba̱ta̱ wa̱ a̱ga̱nda̱. ");
INSERT INTO tsw_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","A̱ɗu a ma'uwaa a̱ lyuci'i i ta cina yi babu u ka̱ra̱ a̱ tyo uba̱ta̱ wa̱ a̱ga̱nda̱ a na wa lyuwa ilyalya. Adama a na ama aa lyuwa ilyalya shi she nu u ta̱wa̱, adama a na she nu u zuwaa kucci'i aba'un. Na̱ a̱yi ndolo koto, a̱vu aza a na a banuyi a lyuwa ilyalya. Ka̱ra̱i a gawan gogo, adama a na gogo ɗa mantsa ma na ya̱ tsura̱ ye enei.>> ");
INSERT INTO tsw_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","A̱vu a̱ ka̱ra̱ a̱ tyo a̱ lyuci. Ele a ma'uwaa ma̱ lyuci'i, reve e ene Sama'ila a̱ mota̱a̱ ana a ga'ansa na̱ a̱yi a̱ 'ya̱wa̱ a gawan uba̱ta̱ wa̱ a̱ga̱nda̱. ");
INSERT INTO tsw_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Urana u ta̱ kafu urana u na Shawulu a̱ 'ya̱wa̱, A̱sulazuva o roco ta̱ ɗe Sama'ila ili i nda u damma, ");
INSERT INTO tsw_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","<<Nfa'an a mantsa ma nda n ta̱ lyungu wa̱ wu vuma diga o ugundo wa Banyami. Vu tsuwa̱n yi mani'in wo o'wo zagbain va ama a̱ va̱, aza a Isra'ila. U ta wawa ama a̱ va̱ e ekere a aza a Filistiya. Me ene ta̱ a̱tsuma̱lima̱ a na ama a̱ va̱ aa uwwusa, adama a na mu uwwa ta̱ mesun me le.>> ");
INSERT INTO tsw_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Ana Sama'ila enei Shawulu, ɗaɗa A̱sulazuva a damma niyi, <<Apa vuma na ma̱a̱ ka̱mbuwusa̱ a̱ wu'u. A̱yi ɗa waa yuwan tsugono tsa a ama a̱ va̱, aza a Isra'ila.>> ");
INSERT INTO tsw_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Reve Shawulu rawa ya Sama'ila o una̱ntsu u lyuci, a̱vu we ece, <<Vu ta̱ yuwan ankuri vu damma mu uba̱ta̱ u na u'wa wu za yindi u ri?>> ");
INSERT INTO tsw_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Reve Sama'ila usu Shawulu, <<A̱mu ɗaɗa za yindi'i! Walai elime a̱ va̱ a̱ tyo uba̱ta̱ wa̱ a̱ga̱nda̱. Ana'an i ta lyuwa oɓolo na̱ a̱mu. Nfa'an nu usana n ta̱ usu yeci ya̱ wu suru, a̱vu n lyawa ɗu i ka̱ra̱ a̱ ka̱mba̱. ");
INSERT INTO tsw_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","She u ɓa̱la̱ wu adama a̱na̱wu o nloli n na puwa̱yin rana ta'atsu na ka̱ra̱i wan, adama a na a̱ tsura̱ le ta̱ ɗe. Suru ili i na okolo aza a Isra'ila a cigai a̱vu ɗa nu umatsun wa dada va̱ wu.>> ");
INSERT INTO tsw_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","Reve Shawulu usu, <<Amma a̱mu za vu ugundo wa Banyami u ɗa, za na la'ai uka̱la̱mu suru suru a̱tsuma̱ o gundo wa aza a Isra'ila! Waru umatsun u tsu u ɗa u la'ai uka̱la̱mu a̱tsuma̱ o ugundo tsu! Cine vu yuwaan numu cu'un va adanshi a nda?>> ");
INSERT INTO tsw_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","Reve Sama'ila uwa na̱ Shawulu na aagbashi a̱ yi a aasula a gbain, a̱vu u zuwa le a̱ da̱nu elime uba̱ta̱ u na aza a na a banuyi a̱ ri, a ta rawa ama mata'atsu. ");
INSERT INTO tsw_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","Reve Sama'ila damma za na a yuwusan ilyalya, <<Ta̱wa̱a̱ mu na apaɗi a nama a na n ca nuwu, za na n damma nuwu, <Zuwa yi ko'o.> >> ");
INSERT INTO tsw_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","Reve za na a yuwusan ilyalya'a ta̱wa̱a̱ na aagutsu a mani'in u zuwa yi a̱ ma̱ka̱ka̱n ma Shawulu. A̱vu Sama'ila damma yi, <<A̱yi nda a̱yi ɗa inama i na a zuwai adama a̱ wu. Vu tama, adama a na a tawa yi ta̱ la̱nga̱ adama a̱ wu a̱buki a nda, a mantsa ma na n dammai n ta̱ na̱ aza a na n banuyi.>> A̱tsuma̱ o uranu u ndolo Shawulu lyuwa ta̱ oɓolo na̱ Sama'ila. ");
INSERT INTO tsw_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","A mantsa ma na a̱ cipa̱i diga uba̱ta̱ wa̱ a̱ga̱nda̱ a̱ tyo a̱ lyuci, a̱vu Sama'ila yuwan adanshi na̱ Shawulu ɗe zuva va aasula a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Reve a̱ 'yon na̱ wasasa, a̱vu Sama'ila ɗe Shawulu ɗe a aasula, <<Foɓo, n ta lyawa wu vu ka̱ra̱.>> Ana Shawulu foɓoi, ɗaɗa a̱yi na̱ Sama'ila a̱ ka̱ra̱i oɓolo. ");
INSERT INTO tsw_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","A mantsa ma na a̱ da̱na̱i a cina ukosu u lyuci, a̱vu Sama'ila damma Shawulu, <<Vu damma aagbashi a̱ wu u ka̱ra̱ elime a̱ tsu.>> Ana a aagbashi'i u ka̱ra̱i elime'e, reve Sama'ila damma yi, <<Vu puro pa ne'e adama n ca wu ikaka diga uba̱ta̱ wa̱ A̱sula̱.>> ");
INSERT INTO tsw_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Reve Sama'ila tara meden ma mani'in, a̱vu u tsuwa̱n Shawulu a aaci. Reve u katala yi ɗaɗa u dammai, <<A̱sulazuva a̱ tsuwa̱a̱n wu ta̱ mani'in tsa̱ra̱ voo oꞌwo zagbain va a ama agadu a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","Mantsa ma na vu kasai na̱ a̱mu ana'an, vu ta ga'asan na ali e re zuzu na ason a Rahila a Zeliza upasu wu utyo wa Banyami. A ta damma wu, <A̱ tsura̱ ta̱ a̱na̱wu o nloli'i na vu uta̱i izami'i. Gogo dada ɗu lyawa ta̱ udamu adama e le, u fara ta̱ udamu adama a̱ ɗu. U da̱na̱ ta̱ a̱ yeci, <<Cine maa yuwan adama n bunga̱ o ulobo u va̱?>> > ");
INSERT INTO tsw_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","<<A̱vu vu lyuwa elime na̱ mmalu diga lo hali she na̱ vu rawa o uɗanga wo oku wa Tabo. Ama a ta'atsu a ta ga'asan na̱ a̱vu lo a gawan a̱ tyo uba̱ta̱ wa̱ a̱ga̱nda̱ wa̱ A̱sula̱ a̱tsuma̱ e Betel. Za ta̱ ta̱ da̱na̱ utanuwu na̱ mugbgbele n ta'atsu, za ta̱ waru ta̱ da̱na̱ na akpatali a ta'atsu o opopofu, za ta̱ waru na̱ itsa̱n vu kwan masayan ma̱ ina̱bi. ");
INSERT INTO tsw_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","A̱ ta̱ ca̱sa̱ wu, a̱vu a cawu akpatali o opopofu ejere, a̱vu vu ushi le o ukere u le. ");
INSERT INTO tsw_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","<<Reve vu ka̱ra̱ a̱ tyo aagaɗi a̱ A̱sula̱ a Gibiya uba̱ta̱ u na aza a Filistiya a̱ ri nu uva̱la̱ta̱ wo oɓolo a̱ a̱soja. A̱vu a marawaa a̱ lyuci'i, vu ta cina iɓolo ya ama̱sula̱ a̱ cipusa̱ diga uba̱ta̱ wa̱ a̱ga̱nda̱ a wa'asa igaraya na̱ muganga ni igbala ni ikumburu. Waru a̱ ta̱ da̱na̱ a yuwusan adanshi e ikaka ya̱ A̱sula̱. ");
INSERT INTO tsw_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Ruhu va̱ A̱sulazuva ta̱ cipa̱a̱ wu nu ucira, a̱vu vu yuwan adanshi e ikaka ya̱ A̱sula̱ oɓolo ne ele, vu ta vadala vo o'wo vuma ro ko'o. ");
INSERT INTO tsw_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Ni iroci i ndolo i shiwan, a̱vu vu yuwan ili i na ve enei i lobonoi. Adama a na A̱sula̱ a̱ ta̱ oɓolo na̱ a̱vu. ");
INSERT INTO tsw_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","<<Reve vu zura̱ a̱ tyo Gilga elime a̱ va̱ vu puro mu. Na amayun n ta̱ ta̱wa̱ ya̱'a̱ wu n yuwan kucci vu ukula̱tosu na̱ kucci muwwulai, amma ko vu ciga ko vu 'yuwan vu ta̱ puro mu lo hali rana cindere hali n ta̱wa̱ n damma wu ili i na vaa yuwan.>> ");
INSERT INTO tsw_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Mantsa ma na Shawulu vadalai a na wa̱a̱ ka̱ra̱ u lyawa Sama'ila, a̱vu A̱sula̱ a vadala okolo a Shawulu, a̱vu iroci i na suru Sama'ila dammai a shiwan o urana u ndolo. ");
INSERT INTO tsw_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Ana Shawulu oɓolo na a aagbashi a̱ yi a rawai Gibiya, a̱vu iɓolo ya ama̱sula̱ a cina yi, a̱vu Ruhu va̱ A̱sula̱ cipa̱a̱ yi nu ucira, a̱vu u uwa a yuwusan adanshi e ikaka ya̱ A̱sula̱ oɓolo ne ele. ");
INSERT INTO tsw_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Ana suru aza a na e reve niyi nu ujumu a cina ana'an e ene niyi a yuwusan adanshi e ikaka ya̱ A̱sula̱ oɓolo na ama̱sula̱, reve e ecelei, <<Nye i ɗa i tsura̱i ulobo wa̱ Kish? Shawulu fo u ta̱ a̱tsuma̱ a ama̱sula̱?>> ");
INSERT INTO tsw_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","A̱vu vuma na ri lo na̱ nden usu, <<Akapi i gba nan dada le fo ama̱sula̱ a ɗa?>> A̱yi nda wo o'wo ta̱ avandaru a adanshi, <<Shawulu fo u ta̱ pe a̱tsuma̱ a ama̱sula̱?>> ");
INSERT INTO tsw_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Ana Shawulu kotoi a yuwusan adanshi e ikaka ya̱ A̱sula̱'a̱, a̱vu u ka̱ra̱ a̱ tyo uba̱ta̱ wa̱ a̱ga̱nda̱. ");
INSERT INTO tsw_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","A̱vu dada ke'en va̱ yi ece yi na̱ aagbashi a̱ yi, <<A̱ te ɗa i 'ya̱wa̱i?>> Reve u usu, <<Tsu 'ya̱wa̱ ta̱ izami ya̱ a̱na̱wun o nloli. Ana tse ene nle shi, ɗaɗa tsu 'ya̱wa̱i ya Sama'ila.>> ");
INSERT INTO tsw_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","A̱vu dada ke'en va Shawulu damma, <<Damma numu ili i na Sama'ila damma nɗu.>> ");
INSERT INTO tsw_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Reve Shawulu usu yi, <<U damma tsu ta̱ na amayun a na a̱ tsura̱ ta̱ ɗe a̱na̱wun o nloli'i.>> Agba u damma dada ke'en va̱ yi ili i na Sama'ila damma niyi adama o tsugono shi. ");
INSERT INTO tsw_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Reve Sama'ila ɗe ama a Isra'ila suru, tsa̱ra̱ a ga'asan a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva a Mizfa. ");
INSERT INTO tsw_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Ana a ta̱wa̱i a̱vu Sama'ila damma le, <<Apa ili i na A̱sulazuva, A̱sula̱ a aza a Isra'ila a dammai, <Mu uta̱a̱ ta̱ aza a Isra'ila diga e iɗa ya Masar, reve n wawa ɗu e ekere a aza a Masar na̱ tsugono tsa na tso ɓongishi nɗu suru.> ");
INSERT INTO tsw_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Amma gogo i 'yuwan ta̱ A̱sula̱ a̱ ɗu za na wawa nɗu a̱tsuma̱ e meleshe na addama suru. Reve i damma, <Ko na̱ ne, vu ca tsu mogono.> Gogo ta̱wa̱i, ɓolotoi aciya̱ɗu a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva o una̱ wu gundo na̱ matsun ɗu.>> ");
INSERT INTO tsw_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Reve Sama'ila ta̱wa̱to aza a Isra'ila suru zuzu a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva gundo gundo, reve a ɗangwa ugundo wa Banyami na̱ mazuwa ma agita. ");
INSERT INTO tsw_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Waru, a̱vu Sama'ila ta̱wa̱a̱ nu ugundo wa̱ Banyami, umatsun umatsun, a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva, reve a ɗangwa umatsun wa Matiri. O ukosu reve a ɗangwa Shawulu ulobo wa̱ Kish. Agba ana a zami niyi a̱ tsura̱ ene yi shi. ");
INSERT INTO tsw_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Reve e ece A̱sulazuva, <<Koto vuma'a u rawa pa shi?>> Reve A̱sulazuva a damma, <<U ta̱ ɗe upa'awun e itana ya̱ a̱soja.>> ");
INSERT INTO tsw_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Reve ama a suma a̱ 'ya̱wa̱ a̱ ta̱wa̱ na̱ a̱yi, reve ana wi isawain e memere ma ama u la'a za suru uga'an. ");
INSERT INTO tsw_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Reve Sama'ila damma ama'a, <<Apa vuma na A̱sulazuva a ɗangwai. Babu tsa̱ yi a̱tsuma̱ a ama suru.>> Reve ama'a a saala, <<Wuma wa̱ wu u jima, mogono!>> ");
INSERT INTO tsw_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","Reve Sama'ila cuɗuwa ama ili i na mogono ma na maa yuwan tsugbain a aci e le waa yuwan ne ele. Reve u ɗana le suru a̱tsuma̱ a aatagada o ukutsulusu, a̱vu u zuwa yi a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. Reve Sama'ila bete'we ama suru a̱ ka̱mba̱ a 'wa le. ");
INSERT INTO tsw_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","Shawulu fo u ka̱mba̱ ta̱ o u'wa wa̱ yi a Gibiya, oɓolo na ali o ukadu aza a na A̱sula̱ a̱ ju'wa̱in okolo e le e shewun yi ta̱. ");
INSERT INTO tsw_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","Amma ama a vama a damma ta̱, <<Cine tsa ɗa vuma nda aa gura wawa tsu?>> A̱vu o goro yi a 'yuwan a̱ ta̱wa̱a̱ yi nu une'e. Amma a̱yi gba u rungwa̱ ta̱ kpen. ");
INSERT INTO tsw_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","Ana a jimanuyi, reve Nahash mogono ma aza a Amon ma̱ ka̱nda̱ruwa̱ lyuci va Jabe Giliyadu adama uriya̱ yi nu uvon. A̱vu suru ali a Jabe a damma yi, <<Yuwan nzuwulai na̱ a̱tsu, tsu ta yuwaan wu a̱ga̱nda̱.>> ");
INSERT INTO tsw_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","Amma Nahash va Amon usu le ta̱, <<N ta yuwan nzuwulai na̱ a̱ɗu adama e ili i ta̱, a̱yi ɗa n kongoro esu o usa'ani a̱ ɗu suru adama yo o'wo ili yi izo'oshi uba̱ta̱ wa aza a Isra'ila suru.>> ");
INSERT INTO tsw_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","A̱vu mbara ma Jabe n damma yi, <<Ca tsu rana cindere tsa̱ra̱ tsu lyungu nlingata a̱ tyo upasu wa aza a Isra'ila suru. Na̱ babu za na aa wawa tsu, reve tsu caa aciya̱tsu ya̱'a̱ wu.>> ");
INSERT INTO tsw_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","Ana nlingata'a n rawai Gibiya lyuci na Shawulu ri, a̱vu a cuɗuwa ama adanshi a nda. Reve ama'a suru a shon na̱ yisali lon. ");
INSERT INTO tsw_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","A mantsa'a a gba wuntsa ta̱ Shawulu a̱ ka̱mba̱ diga o uɗuma̱ ni inan yi iluma ya̱ yi elime. A̱vu we ece, <<Nye i ɗa i tsura̱i ama a na a̱ ri e mesun?>> A̱vu a̱ ka̱mbuwa̱ yi ili i na ama a Jabe a dammai. ");
INSERT INTO tsw_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","Ana Shawulu uwwai adanshi e le, a̱vu Ruhu va̱ A̱sula̱ cipa̱a̱ yi nu ucira, a̱vu wu uwwa upan lon. ");
INSERT INTO tsw_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","A̱vu wu paɗa inan i re apaɗi apaɗi, ɗaɗa u cayi nlingata a̱ 'ya̱wa̱ ne ele uba̱ta̱ suru a̱tsuma̱ a Isra'ila, a dansa, <<Suru za na uta̱i u kuruyi Shawulu na̱ Sama'ila shi, ne ɗa a yuwan ni inan ya̱ yi.>> Ɗaɗa wovon wa̱ A̱sulazuva u remei ama a Isra'ila lon. Reve ali o uta̱ nu uta̱. ");
INSERT INTO tsw_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","Ana Shawulu ɓoloto nle ɗe Beze, ama ukpakukupa ukpakuta'atsu (300,000) diga Isra'ila, ama ukpakukupa mata'atsu (30,000) waru diga Yahuda. ");
INSERT INTO tsw_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","Reve a damma nlingata n na n ta̱wa̱i'i, <<Dammayi ama a Jabe Giliyadu, <Kafu urana u suɗuwa nfa'an, i ta̱ tsura̱ iwawi.> >> Ana nlingata'a n 'ya̱wa̱i nu udammu uba̱ta̱ wa ama a Jabe a̱vu a yuwan ma̱za̱nga̱. ");
INSERT INTO tsw_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","A̱vu a damma aza a Amon, <<Nfa'an tsu ta ca aciya̱tsu e ekere a̱ ɗu, reve i yuwan na̱ a̱tsu ili i na ye enei u lobono nɗu.>> ");
INSERT INTO tsw_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","Na ayin o ndolo reve Shawulu ne'eshen ama a̱ yi oɓolo a ta'atsu. A̱vu a̱ 'ya̱wa̱ va̱la̱ta̱ va aza a Amon nu uvon diga ili ya ayin a̱ tyo wasasa. Reve a uwa mona me le hali urana u rawa a aci. A̱vu e bete'we aza a na a la'ai, babu aza a na e gerei ama e re re. ");
INSERT INTO tsw_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","A̱vu ama a Isra'ila a damma Sama'ila, <<A̱ te ɗa aza a na a dammai, <Cine aa yuwan Shawulu yuwan tsugono tsa̱ tsu?> Ta̱wa̱a̱ ntsu na ama'a tsu una le.>> ");
INSERT INTO tsw_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","Amma Shawulu damma ta̱, <<Babu ko vuma ta̱ na o una ana'an. Adama a na urana wa ana'an u ɗa A̱sulazuva a yuwayin aza Isra'ila iwawi.>> ");
INSERT INTO tsw_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","A̱vu Sama'ila damma ama'a, <<Ta̱wa̱i tsu 'ya̱wa̱i Gilga adama tsu da̱shi usu Shawulu mogono ma̱ tsu ɗe.>> ");
INSERT INTO tsw_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Ɗaɗa ama'a suru a̱ 'ya̱wa̱i ɗe Gilga a̱vu a kucinato Shawulu mogono a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. Ɗe ɗa a cayi kucci muwwulai a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. Reve Shawulu na ama a Isra'ila suru a yuwan ma̱za̱nga̱ ma̱ a̱bunda̱. ");
INSERT INTO tsw_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","A̱vu Sama'ila damma ama a Isra'ila suru, <<To, mu uwwa ta̱ suru ili i na i damma numu, a̱vu n ca ɗu mogono. ");
INSERT INTO tsw_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","Gogo i ta̱ na̱ mogono zagbain ɗu. A̱mu gba, n kutsa ta̱ na̱ yono, waru olobo a̱ va̱ a̱ ta̱ lo oɓolo na̱ a̱ɗu. Mo o'wo ta̱ zagbain ɗu diga a̱mu o ulobo hali a cina ana'an. ");
INSERT INTO tsw_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","A̱mu ɗa nda elime a̱ ɗu. Damma numu a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva, oɓolo na̱ zana u tsuwa̱n yi mani'in. Zane ɗa n usai nan ko mololi? Zane ɗa n paalai ko n ɓongi yi? Zane ɗa n kuɗa̱i a yuwaan mejege? O ukere wa zane ɗa n ushiyi utowusu wu una̱ adama m ɓa̱ru esu a̱ va̱? Na̱ n yuwan ta̱ za ta̱ a̱tsuma̱ e le, i damma mu tsura̱ n ka̱mbuwa̱a̱ yi.>> ");
INSERT INTO tsw_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","A̱vu a̱ usu, <<Vu paala tsu shi waru vu ɓongi tsu shi. Vu ushi ko ili i ta̱ o ukere u vuma shi.>> ");
INSERT INTO tsw_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","Reve Sama'ila damma le, <<A̱sulazuva oɓolo na̱ mogono ma na u tsuwa̱yin mani'in ana'an, ele ɗa lyusu va̱ ekere a̱ ɗu, a na i tsura̱i ili i ro o ukere u va̱ shi.>> A̱vu a̱ usu, <<A̱sulazuva a ɗa lyusu tsu.>> ");
INSERT INTO tsw_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","Reve Sama'ila yuwan adanshi na ama'a u damma, <<A̱sulazuva a ɗa a ɗangulai Musa na̱ Haruna, za a na o uta̱yi nkaya n ɗu e iɗa ya Masar. ");
INSERT INTO tsw_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","Gogo she yi isawan pa a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva, adama n cuwaan ɗu na̱ linga va̱ a̱ɓula̱ na A̱sula̱zuva a yuwaan nɗu na̱ nkaya n ɗu. ");
INSERT INTO tsw_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","<<Mantsa ma na Yakubu ka̱ra̱i a̱ tyo Masar, nkaya n ɗu n showen ta̱ A̱sulazuva. A̱vu A̱sulazuva a̱ lyungu Musa na̱ Haruna aza a na o uta̱yi nkaya n ɗu diga e iɗa ya Masar a̱vu a̱ ta̱wa̱to le uba̱ta̱ u nda a̱ da̱nu. ");
INSERT INTO tsw_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","<<Amma gba a̱vu e icina na̱ A̱sulazuva A̱sula̱ e le. Ɗaɗa u zuwa nle e ekere a Sisera, yali a̱ a̱soja ya Hazo, ne ekere a aza a Filistiya, na̱ mogono ma Mowa, aza a na a yuwain uvon ne ele. ");
INSERT INTO tsw_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","Reve a̱ showen A̱sulazuva a̱vu a damma, <Tsu yuwan ta̱ unusu, tsu lyawa ta̱ A̱sulazuva, reve tsu ka̱ra̱ a yuwusaan a̱ma̱li a Ba'al na̱ Ashitore a̱ga̱nda̱. Amma gogo wawa tsu e ekere a n'yuwatan n tsu, tsu ta yuwaan wu a̱ga̱nda̱.> ");
INSERT INTO tsw_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","Ɗaɗa A̱sulazuva a̱ lyungu Jeruba'al za na a̱yi ɗa Gidiyon, na̱ Barak na̱ Japuta na̱ a̱mu Sama'ila. A̱vu u wawa ɗu e ekere a n'yuwatan n ɗu upasu suru, adama i yuwan nden gbaga. ");
INSERT INTO tsw_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","<<Amma a na ye enei Nahash mogono ma Amon ma̱ ta̱ ta̱wa̱a̱ ɗu nu uvon, reve i damma mu, <Ko na̱ ne, tsu ciga ta̱ mogono ma na ma yuwan tsugono tsa̱ tsu,> ko na wo o'woi A̱sulazuva A̱sula̱ a̱ ɗu a ɗa a̱ shi mogono ma̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","Gogo nda mogono ma na i ɗangulai, zana i pati ta̱ adama a̱ yi, gogo a̱yi ɗa nda A̱sulazuva a ca nɗu a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","Na̱ yu uwwa wovon wa̱ A̱sulazuva, a̱vu i yuwaan yi a̱ga̱nda̱, na̱ tsutoni, agba i yuwan aciyogbamu e ekere a̱ wila̱ wa̱ yi shi, waru na̱ a̱ɗu na̱ mogono ma na maa yuwusan tsugono tsa̱ ɗu i kuru A̱sulazuva A̱sula̱ a̱ ɗu, u to lobono ɗu. ");
INSERT INTO tsw_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","Amma ni i 'yuwan a na yaa yuwan tsutoni na̱ A̱sulazuva reve i yuwan aciyogbamu e ekere a̱ wila̱ wa̱ yi, ukere wa̱ A̱sulazuva a ta yuwan nla̱ngi na̱ a̱ɗu, cine u da̱na̱i ɗe na̱ nkaya nɗu. ");
INSERT INTO tsw_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","<<Gogo isawain ye ene ili i gbain ya asalama i na A̱sulazuva a yuwan e esu a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","Gogo mantsa me e ikani yo oroci a yitabo i ɗa shi? Waru mantsa me iro'i i ɗa shi. N ta pati A̱sulazuva u lyungu na̱ tsata ni iro'i. Waru i reve ili yu uwuyanu i gbain i na i yuwain e esu a̱ A̱sulazuva a na i pati niyi u ca ɗu mogono.>> ");
INSERT INTO tsw_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","A̱vu Sama'ila pati A̱sulazuva, o urana u ndolo a̱vu A̱sulazuva a̱ lyungu na̱ tsata ni iro'i. Ɗaɗa ama suru a uwwai wovon wa̱ A̱sulazuva na̱ Sama'ila. ");
INSERT INTO tsw_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","Reve ama suru a damma Sama'ila, <<Yuwan ipati adama a̱ tsu a agbashi a̱ wu uba̱ta̱ wa̱ A̱sulazuva A̱sula̱ a̱ wu, adama tsu kuwa̱ wan. Adama a na tsu da̱shi ta̱ unusu u tsu suru iwuya, uba̱ta̱ e ipati i na aa ca tsu mogono.>> ");
INSERT INTO tsw_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","Reve Sama'ila damma, <<She yu uwwa wovon wan, ko na wo o'woi i yuwan ta̱ iwuya i nda suru. Suru na̱ ne she i vadala ucina̱ i lyawa itoni ya̱ A̱sulazuva wan, amma i yuwaan yi a̱ga̱nda̱ no okolo a̱ ta̱. ");
INSERT INTO tsw_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","She i vadala a̱ tyo uba̱ta̱ u musula̱ me pere wan. Adama a na aa yuwaan ɗu isa'ani shi, ko a wawa ɗu shi, adama a na a̱ ri nu urana shi. ");
INSERT INTO tsw_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","Adama a ala a gbain a̱ yi, A̱sulazuva aa vari ama a̱ yi shi. Adama a na u yo'ono ta̱ A̱sulazuva wo o'wo to ɗu ama a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","A̱mu na aciya̱va̱ gba, A̱sulazuva aa para n yuwaan yi unusu uba̱ta̱ o ulambu u mayan ma avasa adama a̱ ɗu. Waru n to roco ɗu ure u na u ri mejege nu ulobonu. ");
INSERT INTO tsw_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","Agba i reve yu uwwa ta̱ wovon wa̱ A̱sulazuva, a̱vu i yuwaan yi a̱ga̱nda̱ na amayun no okolo a̱ ta̱. I cuwan na̱ ili i gbain ya asalama i na u yuwaan nɗu. ");
INSERT INTO tsw_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","Amma ni i lyuwa elime nu unusu, a̱ɗu na̱ mogono ma̱ ɗu a̱ ta̱ e iza̱ a̱ ɗu.>> ");
INSERT INTO tsw_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","Shawulu na a'wan mata'atsu ɗaɗa wo o'woi mogono, waru u yuwan ta̱ tsugono tsa Isra'ila a'wan amunga ne ejere. ");
INSERT INTO tsw_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","Reve Shawulu ɗangulaa aciya̱yi ama ukpakukupa uta'atsu (3,000) a̱tsuma̱ a ama a Isra'ila. Ama ukpakukupa ure (2,000) a̱ da̱nu ta̱ na̱ yi ɗe Mikimash, oɓolo na̱ iɗa ya agaɗi ya Betel. Waru ukpakukupa (1,000) u da̱na̱ ta̱ na̱ Jonata ɗe Gibiya upasu wa Banyami. Akapi a ama gba Shawulu lyawa le ta̱ a̱ ka̱mba̱ a 'wa le. ");
INSERT INTO tsw_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","Jonata riya̱a̱ ta̱ va̱la̱ta̱ va aza a Filistiya nu uvon ɗe Geba, waru aza a Filistiya a uwwa ta̱ a ɗa e ili i na i farai. A̱vu Shawulu lyungu ee ivula̱ aavana e iɗa suru a̱vu a damma, <<Lyawa Mmaci ma Ibrahim mu uwwa!>> ");
INSERT INTO tsw_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","A̱vu aza a Isra'ila suru a uwwa alabari a na Shawulu riya̱a̱ ta̱ va̱la̱ta̱ vo oɓolo a̱soja a Filistiya nu uvon, a̱vu gba aza a Isra'ila o o'wo ili yi idaba uba̱ta̱ wa aza a Filistiya. A̱vu e ɗe ama o uta̱, reve a ga'an na̱ Shawulu ɗe Gilga. ");
INSERT INTO tsw_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","Reve aza a Filistiya o ɓoloto tsa̱ra̱ a yuwan uvon na aza a Isra'ila. A̱vu o uta̱ ni ikeke yi ido yu uvon ukpakukupa o uta'atsu (3,000) na akumbi e ido ukpakukupa uta̱li (6,000) na̱ oɓolo a̱ a̱soja a̱ a̱bunda̱ lon tsa̱ wuyun e ikyun i mala. A̱vu a gawan a̱ ya̱wa̱ a̱ va̱la̱ a Mikimash asana a Bet Aven. ");
INSERT INTO tsw_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","Ana a̱soja a Isra'ila enei a̱ ta̱ pe a̱tsuma̱lima̱, waru a̱soja a Filistiya a̱ ga̱la̱ le ta̱ uga̱lu, reve a̱soja'a a pa'aton aciya̱le, ozo o ro a̱ da̱na̱ ta̱ pe a̱ba̱nu, ozo o ro awanda, ozo o ro a atali, waru ozo o ro a̱nci, ozo o ro o oko'o. ");
INSERT INTO tsw_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Reve Mmaci ma Ibrahim n ro n pasalai mavada ma̱ o Uɗolu wa̱ Urudu a̱ tyo upasu wi iɗa ya Gadu nu upasu wa Giliyadu. Shawulu gba u da̱na̱ ta̱ pe Gilga, waru suru aza a na a̱ ri oɓolo na̱ a̱yi e teme ta̱ meje'en ma̱ lipu adama o wovon. ");
INSERT INTO tsw_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","Wi isawan ta̱ hali a cina rana cindere, mantsa ma na Sama'ila zuwaa niyi. Amma Sama'ila ta̱wa̱ Gilga shi. A̱vu ama a Shawulu a̱ ka̱ra̱ e bete'wishe. ");
INSERT INTO tsw_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","Ɗaɗa Shawulu dammai, <<Ta̱wa̱a̱ numu na̱ kucci vu ukula̱tosu na̱ kucci muwwulai.>> A̱vu Shawulu yuwan kucci vu ukula̱tosu. ");
INSERT INTO tsw_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","A̱yi u koto ucasu u kucci vu ukula̱tosu she gba Sama'ila a marawaa. Reve Shawulu 'ya̱wa̱ u cina yi u ca̱sa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","A̱vu Sama'ila ece, <<Nye i ɗa vu yuwain?>> Reve Shawulu usu u damma, <<Ana me enei ama e bete'wishe agba vu ta̱wa̱ a mantsa'a shi, waru aza a Filistiya o to ɓolotosu ɗe Mikimash, ");
INSERT INTO tsw_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","a̱vu n yuwan majiyan, <Gogo aza a Filistiya a̱ ta̱ ta̱wa̱a̱ mu nu uvon pa nda Gilga waru koto m pati isa'ani ya̱ A̱sulazuva shi.> Ɗaɗa n zuwai aciya̱va̱ nu ucira n yuwan kucci vu ukula̱tosu.>> ");
INSERT INTO tsw_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Reve Sama'ila damma Shawulu, <<Vu yuwan ta̱ tsulo lon. Vu kuru wila̱ wa̱ A̱sulazuva A̱sula̱ a̱ wu shi za na u damma nuwu vu yuwan shi. Na̱ vu shi vu kuru wila̱'a̱, u shi ta̱ a zuwa tsugono tsa̱ wu tsa lyuwa elime e ekere a aza a Isra'ila babu ukosu. ");
INSERT INTO tsw_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Amma gogo tsugono tsa̱ wu tsaa lyuwa elime shi. A̱sulazuva a̱ bunga̱ ta̱ vuma na okolo a̱ yi a cigai a̱vu u zuwa yi zagbain va ama a̱ yi, adama a na vu kuru wila̱ wa̱ A̱sulazuva shi.>> ");
INSERT INTO tsw_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","Ɗaɗa Sama'ila lyawai Gilga a̱vu u ka̱ra̱ a̱ tyo Gibiya va Banyami. A̱vu Shawulu kece akapi a ama a na a buwai oɓolo na̱ a̱yi. A̱vu a̱ tsura̱ a̱bunda̱ a ama ukpakuta̱li (600). ");
INSERT INTO tsw_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","Shawulu na̱ ulobo wa̱ yi Jonata na ama a na a̱ ri oɓolo ne ele a̱ da̱nu ta̱ Geba va Banyami. Reve aza a Filistiya a yuwan uva̱la̱ta̱ u le a Mikimash. ");
INSERT INTO tsw_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","A̱vu oɓolo a ta'atsu a̱ a̱soja a Filistiya o uta̱ diga o uva̱la̱ta̱ u le adama o uvon. Reve oɓolo a̱ ta̱ a̱ 'ya̱wa̱ Ofura, a̱tsuma̱ o upasu wa Shuwal, ");
INSERT INTO tsw_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","oɓolo o ro a̱ tyo ta̱ Bet Horon oɓolo o ro waru a̱ tyo o ta̱ ukosu wi iɗa i na ya̱a̱ ka̱lyuwusa̱ uka̱ri wa Zeboyim a̱ nka̱la̱la̱i zuzu na̱ a̱tsumona. ");
INSERT INTO tsw_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","A mantsa ma nda babu maruma ma na a̱ tsura̱i a̱tsuma̱ e iɗa ya Isra'ila suru, adama a na aza a Filistiya a damma ta̱, <<Na̱ shi tsu lyawa le, Mmaci ma Ibrahim a̱ shi ta̱ aa yuwaan aciya̱le mutsun mu pe'eni ni ibata!>> ");
INSERT INTO tsw_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","Ɗaɗa aza a Isra'ila suru a saɓai a̱cipa̱ a̱ tyo uba̱ta̱ wa aza a Filistiya adama e tewe elentsu a̱ a̱ba̱ri e le, na agalatsu e le, na aɓau na̱ ogonu le. ");
INSERT INTO tsw_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","Waru atsupu'u ikebe i azurufa re ɗa a̱tsuma̱ a aza a ta'atsu vu utewishe wa̱ a̱ba̱ri e le na agalatsu e le. Atsupu o utewishe wa aɓau e le na̱ kune gbain va akatsu a ta'atsu e le na̱ aaɗanga a̱ ma̱gba̱ra̱ me inan i le, ikebe i azurufa ta̱ ɗa a̱tsuma̱ a aza a ta'atsu. ");
INSERT INTO tsw_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","Ne ɗa o urana wu uvon u ndolo babu soja va Shawulu na̱ Jonata a na a̱ shi na̱ matsun me pe'eni ko ibata o ukere wa̱ yi, Shawulu na̱ Jonata ulobo wa̱ yi u ɗa goon a̱ shi ne ele. ");
INSERT INTO tsw_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","Reve oɓolo a̱ a̱soja a aza a Filistiya o uta̱ a̱ tyo o upasata wa Mikimash. ");
INSERT INTO tsw_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","Urana u ro reve Jonata ulobo wa Shawulu u damma ulobo u na wa̱a̱ guzusa̱a̱ yi itana yu uvon, <<Ta̱wa̱, tsu 'ya̱wa̱ upasalai wa̱ oɓolo a̱ a̱soja a Filistiya, upasu u ndeɗe.>> Agba u damma dada va̱ yi shi. ");
INSERT INTO tsw_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","Shawulu da̱na̱ ta̱ nden o ukosu wa Gibiya za̱la̱ vu uɗanga muwun m peme a̱tsuma̱ a Migiron. Ama a na a̱ da̱na̱i oɓolo na̱ a̱yi a rawa ta̱ ama ukpaku uta̱li (600), ");
INSERT INTO tsw_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","oɓolo na̱ Ahija ganu zana da̱na̱i wotowu na̱ epo. A̱yi ulobo wa Ahitub ɗa mawun ma a̱na̱wu ma Ikabo olobo a Finiha, ulobo wa̱ Eli, ganu va̱ A̱sulazuva a̱tsuma̱ a Shilo. Agba ko za reve a na Jonata ka̱ra̱i shi. ");
INSERT INTO tsw_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","O upasata u masasan ma na Jonata cigai u kuruwa̱a̱ a̱ tyo o oɓolo a̱ a̱soja a Filistiya atali o uga'an a̱ shi ta̱ lo a̱ mɓa̱nga̱ suru. Aala a za ta̱ Boze, za va ire waru Sene. ");
INSERT INTO tsw_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","Aatali a̱ ta̱ e isawan ta̱ ugana a̱ ka̱lyuwusa̱ eleme a Mikimash, za ta̱ waru uyagi elime a Geba. ");
INSERT INTO tsw_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","Reve Jonata damma ulobo u na wa̱a̱ guzusa̱a̱ yi itana yu uvon, <<Ta̱wa̱ tsu 'ya̱wa̱ o uva̱la̱ta̱ wa̱ a̱ a̱soja a Filistiya a aza a na a paɗai uryumbu shi. U ta gura o'wo A̱sulazuva a yuwan ulinga adama a̱ tsu. Babu ili i na yaa putsa A̱sulazuva ni iwawi, u ta̱ tsura̱ u lyuwu wa aci ko na ali o uvon a̱bunda̱ ko na̱ ri uka̱la̱mu.>> ");
INSERT INTO tsw_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","Reve za na a̱a̱ guzusa̱a̱ yi itana yu uvo'on u damma yi, <<Yuwan ili i na i ri o okolo a̱ wu suru. Yuwan cine vu cigai, o okolo a̱ va̱ o to oɓolo na̱ a̱vu.>> ");
INSERT INTO tsw_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","Reve Jonata damma, <<Lyawa tsu pasa a̱ 'ya̱wa̱ uba̱ta̱ wa ama'a adama tsu roco aciya̱tsu uba̱ta̱ u le. ");
INSERT INTO tsw_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","Na a damma tsu, <Puroyi hali she na̱ tsu ta̱wa̱ ya̱'a̱ ɗu,> tsu te isawan uba̱ta̱ u na tsu ri, tsa̱a̱ 'ya̱wa̱ gawan le shi. ");
INSERT INTO tsw_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","Amma na a damma, <Ta̱wa̱i gawan tsu,> tsu ta kumba a gawan, adama a na a̱yi nda u to o'wo tsu iroci i na A̱sulazuva a ca le ta̱ e ekere a̱ tsu.>> ");
INSERT INTO tsw_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","Ɗaɗa ele ra o rocoi aciyele uba̱ta̱ wa̱ o oɓolo a̱soja a Filistiya. Reve aza a Filistiya a damma, <<Ka̱lyuwa̱i! Mmaci ma Ibrahim n te e ika̱ta̱pu o uta̱sa̱ a̱ a̱nci uba̱ta̱ u na a pa'aton yi aciya̱le.>> ");
INSERT INTO tsw_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","Reve o oɓolo a̱ a̱soja a aza a Filistiya a salaa Jonata na̱ ulobo u na wa̱a̱ guzusa̱a̱ yi itana yu uvo'on, <<Gawain a̱ ta̱wa̱ uba̱ta̱ u tsu, tsu ta yuwan a̱guma̱ a̱ ɗu.>> Ɗaɗa Jonata dammai ulobo u na wa̱a̱ guzusa̱a̱ yi itana yu uvo'on, <<Gawan o oɓolo na̱ a̱mu, A̱sulazuva a ca le ta̱ o ukere wa aza a Isra'ila.>> ");
INSERT INTO tsw_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","Reve Jonata kumba ne ekere a̱ yi na ana, waru ulobo u na wa̱a̱ guzusa̱a̱ yi itana yu uvon a̱ca̱pa̱ a̱ yi. Jonata una ta̱ ozo o ro ne ekere a̱ yi, reve za na aa guzusa̱a̱ yi itana yu uvon una ozo ro e le a̱ca̱pa̱ a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","O uvon wu ufaru reve Jonata na̱ ulobo u na wa̱a̱ guzusa̱a̱ yi itana yu uvon o una ama ushin a agalaci a washin a na a rawai uɓatsulai wu uɗuma̱ u na inan yi iluma yaa luma urana u ta̱. ");
INSERT INTO tsw_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","Reve wovon u reme a̱ a̱soja a Filistiya a na a̱ ri o uva̱la̱ta̱ suru, na a aza a na a̱ ri ya aa alanga, hali fo na̱ o oɓolo a̱ a̱soja, na a aza a na a̱ tsu 'ya̱wa̱a̱ nu uvon. Reve suru n le a uwwa wovon lon. Reve iɗa i jinga̱ɗa̱. A̱sula̱ a ɗa a̱ lyunguyi na̱ wovon u ndolo. ");
INSERT INTO tsw_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","Ana a̱za̱ e ipiri ya Shawulu a̱tsuma̱ a Gibiya va Banyami a̱ ka̱lyuwa̱i, reve e ene o oɓolo a̱soja a aza a Filistiya e bete'we za suru saɓa ure wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","Reve Shawulu damma ama a na a̱ ri oɓolo na̱ a̱yi, <<Kecei a̱soja tsura̱ i reve a aza a na a̱ ri pa oɓolo na̱ a̱tsu shi.>> Ana e kecei, Jonata na̱ ulobo u na wa̱a̱ guzusa̱a̱ yi itana yu uvon ɗa a̱ ri lo shi. ");
INSERT INTO tsw_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","Ɗaɗa Shawulu dammai Ahija, <<Ta̱wa̱ na Akpati a Nzuwulai a̱ A̱sula̱ pa nda.>> Adama a na a mantsa mo ndolo u da̱na̱ ta̱ ekere a aza a Isra'ila. ");
INSERT INTO tsw_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","Shawulu a yuwusaan adanshi na̱ ganu'u, reve utogbolyuwu a̱tsuma̱ o uva̱la̱ta̱ wa aza a Filistiya u ka̱ra̱ a̱ da̱shishi. Ɗaɗa Shawulu dammai ganu, <<She u damaton wu wan.>> ");
INSERT INTO tsw_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","Ɗaɗa Shawulu na ama a̱ yi suru o ɓolotoi reve a̱ ka̱ra̱ a̱ tyo uba̱ta̱ o uvon. A cina ta̱ aza a Filistiya utogbolyuwu lon, a munulai can le na̱ mutsun mu pe'eni. ");
INSERT INTO tsw_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","Mmaci ma Ibrahim n na n ri oɓolo na aza a Filistiya, waru a̱ ka̱ra̱i a gawan oɓolo ne ele o uva̱la̱ta̱, a̱ ka̱mba̱ ta̱ a̱ tyo uba̱ta̱ wa aza a Isra'ila aza a na a̱ ri oɓolo na̱ Shawulu na̱ Jonata. ");
INSERT INTO tsw_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","Ana aza a Isra'ila suru a na a̱ shi a pa'ain a̱tsuma̱ e iɗa ya agaɗi ya Ifiramu a uwwai a na aza a Filistiya e te ilaɗi, ele fo a saɓa le ta̱ a̱ca̱pa̱ nu uvon. ");
INSERT INTO tsw_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","Ne ɗa A̱sulazuva a wawai aza a Isra'ila o urana u ndolo, waru uvon u lyuwa ta̱ elime hali u ka̱ra̱ Bet Aven. ");
INSERT INTO tsw_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","O urana u ndolo a̱ a̱soja a Isra'ila a uwa ta̱ a̱tsuma̱lima̱, adama a na Shawulu tara ta̱ akucunu na ama a dansa, <<Una̱ u ta̱ reme vuma na suru lyuwai ilyalya babu na ulivu u yuwain, babu na n tsupayi aciya̱va̱ e ekere a n'yuwatan n va̱!>> Ne ɗa gba babu vuma na peɗei ilyalya. ");
INSERT INTO tsw_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","Ana a̱ a̱soja'a suru a uwai a̱ a̱a̱rumbu, a̱vu a cina ishiki e iɗa. ");
INSERT INTO tsw_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","Waru ana a uwai a̱ a̱a̱rumbu'u, a̱vu a cina pe ishiki a̱ ɗa̱wusa̱, agba babu za na zuwai aakatsu u peɗei, adama a na ama a ta uwwusa wovon wa akucunu'u. ");
INSERT INTO tsw_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","Agba Jonata reve a na dada va̱ yi yuwain akucunu na ama'a shi, ɗaɗa u sapiyi combo va a aaɗanga a na a̱ ri o ukere wa̱ yi reve u tsupu yi a abaji e ishiki'i. Reve u 'ya̱sa̱n ukere wa̱ yi a̱ tyo o una̱ wa yi, a̱vu esu a̱ yi a̱ kpa̱tu'wa̱. ");
INSERT INTO tsw_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","Reve za ta̱ a̱tsuma̱ a ama'a u damma yi, <<Dada va̱ wu yuwaan ta̱ ama akucunu o usa̱n, u damma, <Una̱ u ta̱ reme vuma na suru lyuwai ilyalya ana'an!> A̱yi ɗa i zuwai ama a̱ ri uta̱ka̱lyuwu.>> ");
INSERT INTO tsw_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","Ɗaɗa Jonata dammai, <<Dada va̱ ta̱wa̱a̱ ta̱ iɗa na addama. Ka̱lyuwa̱ cine esu a̱ va̱ a̱ kpa̱tu'wa̱i a na m peɗei ishiki i nda ke'en. ");
INSERT INTO tsw_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","U shi a la'a na̱ a̱ shi a damma a lyawa ta̱ ama a lyuwa ilyalya fa̱a̱n ana'an diga a̱tsuma̱ e ilyalya i na a̱ pura̱i uba̱ta̱ wu n'yuwatan n le. Aza a Filistiya a na tsu shi o una a̱ shi a la'a nda shi?>> ");
INSERT INTO tsw_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","O urana u ndolo o una ta̱ aza a Filistiya diga Mikimash a̱ tyo Ayalon, waru ama a̱ta̱ka̱lyuwu ta̱ lon. ");
INSERT INTO tsw_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","Reve a ama a̱ ga̱da̱ra̱ azaza e itana yu uvon i na a̱ pura̱i. A̱vu a̱ pura̱ ikyon ni inan, na̱ mudindim a̱vu a paɗa le e iɗa, reve a tama le oɓolo na̱ mpasa n le. ");
INSERT INTO tsw_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","Reve ama a damma Shawulu, <<Ka̱lyuwa̱i, a̱yi ɗa nda ama a yuwusan unusu e ekere a̱ A̱sulazuva a tamusa inama na̱ mpasa.>> Reve u damma, <<I kuɗa ta̱ wila̱. Bunda̱la̱i aatali a gbain a̱ ta̱wa̱ pa nda gogo.>> ");
INSERT INTO tsw_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","Reve u dammisa, <<Ka̱ra̱i o uta̱ uba̱ta̱ wa ama a̱vu i damma le, <Lyawa vuma suru ta̱wa̱ na̱ nan va̱ yi ko kyon va̱ yi, a̱vu a paɗa le pa a tama le. She i yuwusan unusu uba̱ta̱ wa̱ A̱sulazuva i tama inama na̱ mpasa n le wan.> >> Ne ɗa za suru ta̱wa̱i na̱ nan va̱ yi ayin o ndolo reve a paɗa le ɗe aatali'i. ");
INSERT INTO tsw_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","Ɗaɗa Shawulu suwayi A̱sulazuva masa'a, a̱yi ɗa masa'a mo ufaru ma na u suwayi A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","Reve Shawulu damma, <<Lyawa tsu cipa̱i za̱la̱ tsu 'ya̱wa̱a̱ aza a Filistiya nu uvon na ayin a̱vu waru tsu pura̱ le itana hali she usana, waru tsaa lyawa za ro le wuma shi.>> Reve a̱ usu, <<Yuwan ili i na ve enei u lobono wu ta̱ suru.>> Amma ganu damma ta̱, <<Lyawa tse ecei A̱sula̱ pa nda.>> ");
INSERT INTO tsw_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","A̱vu Shawulu ece A̱sula̱, <<N ka̱ra̱ a̱cipa̱ a na ma̱ 'ya̱wa̱a̱ aza a Filistiya nu uvon? Vu ta ca le e ekere a aza a Isra'ila?>> Agba A̱sula̱ a̱ usu yi o urana u ndolo shi. ");
INSERT INTO tsw_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","Reve Shawulu damma, <<Ta̱wa̱yi pa nda, suru nɗu azagbain a̱ a̱soja, reve tsu zamiyi cu'un vu unusu u na a yuwain ana'an. ");
INSERT INTO tsw_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","N kucuna ta̱ na̱ A̱sulazuva a na a̱ ri wuma za na wawai Isra'ila, ko na̱ u shi u bura ta̱ ulobo u va̱ Jonata, she nu u kuwa̱.>> Amma babu za na yuwain adanshi a̱tsuma̱ a ama a na a̱ da̱na̱i lo. ");
INSERT INTO tsw_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","Reve Shawulu damma aza a Isra'ila suru, <<Yi isawan ndeɗe, waru a̱mu na̱ Jonata ulobo u va̱ tsu te isawan pa nda.>> A̱vu ama'a a̱ usu Shawulu, <<Yuwan ili i na ve enei u lobono nuwu.>> ");
INSERT INTO tsw_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","Reve Shawulu yuwan avasa a̱ tyo uba̱ta̱ wa̱ A̱sulazuva A̱sula̱ a Isra'ila, <<Nye i zuwai vu usu yi aagbashi a̱ wu ana'an shi? Na̱ unusu u va̱ u ɗa, ko za vu ulobo u va̱ Jonata, vu usu na̱ Urim, amma nu unusu wa ama a Isra'ila ɗa, vu usu na̱ Tumim.>> Reve mazuwa ma agita mo roco Jonata na̱ Shawulu ɗa, reve ama'a o o'wo babu unusu. ");
INSERT INTO tsw_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","Reve Shawulu damma, <<Zuwayi agita e ekere va̱ na̱ Jonata ulobo u va̱.>> A̱vu a tawa Jonata. ");
INSERT INTO tsw_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","Ɗaɗa Shawulu dammai Jonata, <<Damma mu ili i na vu yuwain.>> Ɗaɗa Jonata damma niyi, <<M peɗe ta̱ ishiki wa'a nu combo va aaɗanga a na a̱ ri o ukere u va̱. Gogo n ta gura kuwa̱.>> ");
INSERT INTO tsw_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","A̱vu Shawulu damma Jonata, <<Lyawa A̱sula̱ a ca a̱mu a̱tsuma̱lima̱ lon, na̱ o una wu shi.>> ");
INSERT INTO tsw_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","Reve ama a damma Shawulu, <<Cine Jonata a̱a̱ kuwa̱, za na yuwain a̱ba̱jini o ulinga wi iwawi a̱tsuma̱ a Isra'ila? A̱sulazuva a para! Tsu kucuna ta̱ na̱ a̱ A̱sulazuva a na a̱ ri wuma, babu ko a̱nji a aaci a̱ yi za ta̱ na a̱ riya̱ e iɗa, adama a na u yuwan ta̱ ili i nda ana'an ni ikambi ya̱ A̱sula̱.>> Ne ɗa ama'a a papai Jonata, agba o una yi shi. ");
INSERT INTO tsw_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","Ɗaɗa Shawulu lyawai magbagba ma aza a Filistiya, a̱vu aza a Filistiya a̱ ka̱mba̱ a̱ tyo e iɗa i le. ");
INSERT INTO tsw_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","Ana Shawulu tarai tsugono ekere aza a Isra'ila u yuwan ta̱ uvon na̱ n'yuwatan n le uba̱ta̱ suru: A̱za̱ a̱ Mowa, na aza a Amon na̱ a̱za̱ a̱ Edom, na̱ ngono n Zoba na aza a Filistiya. Uba̱ta̱ u na u yuwain uvon suru u tsu lyuwa ta̱ aci. ");
INSERT INTO tsw_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","U yuwan ta̱ uvon nu ukadu lon, reve u lyuwa aza a Amaleka nu uvon. Waru u wawa ta̱ aza a Isra'ila e ekere a aza a na a̱ pura̱ nle itana. ");
INSERT INTO tsw_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","Olobo a Shawulu ele ɗa Jonata, na̱ Ishvi na̱ Malkishuwa. Waru e esheli e re a̱ yi ele ɗa, Mera zakpara, Mikal zawa'a. ");
INSERT INTO tsw_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","Ala a ka va̱ yi ɗa Ahinowam usheli wa Ahima'az. Ala a yali ya̱ a̱soja a̱ yi a̱yi ɗa Abna ulobo wa Ner, waru Ner dada ke'en va Shawulu ɗa. ");
INSERT INTO tsw_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","Kish ɗa dada va Shawulu, waru Ner dada va Abna, Kish na̱ Ner olobo a Abiyel a ɗa. ");
INSERT INTO tsw_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","A̱tsuma̱ a wuma wa Shawulu suru, u yuwan ta̱ uvon wu usuɗuwu na aza a Filistiya. Na̱ we ene za vu ucira ko zana ri na̱ ukadu lon, reve wo o'woto yi soja va̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Sama'ila damma ta̱ Shawulu, <<A̱mu ɗa A̱sulazuva a̱ lyungu yi a na ma̱ tsuwa̱n wu mani'in vo o mogono ekere ama a̱yi a aza a Isra'ila. Gogo vu polo atsuvu vu uwwa ikaka i na yu uta̱i uba̱ta̱ wa̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Apa ili na A̱sulazuva o oɓolo a̱ a̱soja a zuva a dammai: <N ta tawa aza a Amaleka adama e ili i na a yuwayin aza a Isra'ila, ana a̱ riya̱a̱ n le nu uvon a mantsa ma na o uta̱i e iɗa ya Masar. ");
INSERT INTO tsw_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Gogo i ka̱ra̱ a̱ ꞌya̱wa̱ i riya̱a̱ aza a Amaleka, a̱vu i kototo ili i na a̱ ri na̱ a̱yi suru suru. Ko ili i ta̱ she i lyawa wuma wan. Yu una ali na̱ a̱ma̱ci na̱ muwun, na̱ nreɓu ni inan ni ikyon na arakumi, na̱ nloli.> >> ");
INSERT INTO tsw_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Avu Shawulu ɗe ama a na u ɓolotoi ɗe Telem, a̱soja a ana a na a̱ da̱na̱i a ana ukpakukupa ukpakure (200,000), nu ukpakukupa kupa (10,000) diga Yahuza. ");
INSERT INTO tsw_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Reve Shawulu 'ya̱wa̱ a̱ lyuci va Amaleka a̱vu u vawan a̱ a̱tsuma̱ o uka̱ri. ");
INSERT INTO tsw_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","Reve u damma aza a Kena, <<Walai, i jika̱ yu uta̱ i lyawa aza a Amaleka ta̱wa̱ n kototo ɗu oɓolo ne ele wan, adama a na i roco ta̱ aza a Isra'ila suru isa'ani ya amayun a mantsa ma na a gawain o uta̱ diga Masar.>> Ɗaɗa aza a Kena o uta̱i diga a̱tsuma̱ a aza a Amaleka. ");
INSERT INTO tsw_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","A̱vu Shawulu lyuwa aza a Amaleka nu uvon, diga Havila a̱ tyo Shur za na a̱ ri asana a Masar. ");
INSERT INTO tsw_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Reve u reme Aga mogono ma Amaleka wuma wa̱ yi, reve gba u kototo ama a̱ yi suru suru na̱ matsun me pe'eni. ");
INSERT INTO tsw_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Amma a̱yi na ama a̱ yi a lyawa ta̱ Aga wuma, na̱ mgbele ni inan na̱ mudindim na̱ mukyokyon, i na suru i la'ai ulobonu. Ele nda suru a ciga o kototo le suru suru shi. Amma ili i na suru a tarai ili ya̱ a̱ɓula̱ shi ko babu ucira ele ɗa o kototoi suru suru. ");
INSERT INTO tsw_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","A̱vu A̱sulazuva a yuwan adanshi na̱ Sama'ila ana, ");
INSERT INTO tsw_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","<<N yuwan ta̱ a̱tsumola̱ngu a na n ɗangwai Shawulu wo o'wo mogono, adama a na u vadalaa mu ta̱ ucina̱, waru u 'yuwan ta̱ a na wa yuwan tsutoni na̱ udammu u na n ca niyi.>> Sama'ila yuwan ta̱ upan, reve u showen A̱sulazuva ayin ma̱ɓula̱. ");
INSERT INTO tsw_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Na̱ wasasa, reve u 'ya̱wa̱ uba̱ta̱ wa Shawulu. Reve a damma yi, <<Shawulu 'ya̱wa̱ ta̱ a̱ lyuci va Kame, reve u shuwa̱ aciya̱yi aatsura a na a̱ ri n cuwusan na̱ a̱yi ɗe. Reve u vadala u ka̱ra̱ a̱ cipa̱ a̱ tyo Gilga.>> ");
INSERT INTO tsw_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Ana Sama'ila cina niyi, reve Shawulu damma, <<Lyawa A̱sulazuva a zuwaa wu abaꞌun! N yuwan ta̱ tsutoni nu udammu wa̱ A̱sulazuva!>> ");
INSERT INTO tsw_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","A̱vu Sama'ila ece yi, <<N na amayun ɗa wu, ili i ne i ɗa maa uwwusa tsa mesun me mgbele oɓolo ni inan?>> ");
INSERT INTO tsw_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","A̱vu u usu, <<Ama a̱ ta̱wa̱ ta̱ ne ele diga uba̱ta̱ wa aza a Amaleka, a lyawa ta̱ mgbele ni inan i na i la'ai ulobonu wuma adama a yuwaan A̱sulazuva A̱sula̱ a̱ wu kucci. Amma tsu kototo ta̱ suru suru akapi e ili i na i buwai.>> ");
INSERT INTO tsw_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","A̱vu Sama'ila damma Shawulu, <<Isawan! N ta damma wu ili i na A̱sulazuva a dammai na ayin o yon.>> Reve Shawulu usu, <<Damma mu.>> ");
INSERT INTO tsw_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Reve Sama'ila usu yi, <<Ko na wo o'woi ɗe a̱ca̱pa̱ vu shi tara aciya̱wu ili i ro shi, a̱vu ɗa zagbain vu gundo va a aza a Isra'ila gogo shi? Waru A̱sulazuva a̱ tsuwa̱n wu ta̱ mani'in vo oꞌwo mogono ma aza a Israꞌila. ");
INSERT INTO tsw_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Waru u lyungu wu ta̱ adansa, <'Ya̱wa̱ vu kototo ama a avama o ndolo suru suru, aza a Amaleka. Vu yuwan uvon ne ele hali she na̱ vu kototo le.> ");
INSERT INTO tsw_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","Adama a̱ nye i ꞌyuwain a na ya yuwan tsutoni na̱ A̱sulazuva? Adama a̱ nye i ga̱da̱ra̱i azaza e itana yu uvon i na i pura̱i? Nye i zuwai i yuwain ili i wuya a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva?>> ");
INSERT INTO tsw_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","A̱vu Shawulu usu u damma Sama'ila, <<Amma n yuwan ta̱ tsutoni na̱ A̱sulazuva. Adama a na n ka̱ra̱ ta̱ n 'ya̱wa̱ yuwan ulinga u na u lyungu numu n yuwan. N ta̱wa̱ ta̱ na̱ Aga mogono ma aza a Amaleka, reve waru n kototo akapi a aza a Amaleka suru suru. ");
INSERT INTO tsw_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Ama a tara ta̱ mgbele ni inan i na i la'ai ulobonu i na a̱ pura̱i uba̱ta̱ wu uvon na a tawai adama o ukototosu, adama a yuwaan A̱sulazuva A̱sula̱ a̱ wu kucci ne ele a̱tsuma̱ a Gilga.>> ");
INSERT INTO tsw_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Reve Sama'ila usu u damma, <<Nye i la'a yo'onotoi A̱sulazuva okolo, kucci vu ukula̱tosu na̱ kucci, ko tsutoni ni ili i na u dammai? A yuwaan yi tsutoni u la'a ta̱ kucci, waru o polo atsuvu u la'a ta̱ abaji a mani'in ma̱ a̱giri'i. ");
INSERT INTO tsw_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Aciyogbamu u ta̱ va damma unusu u yindi. Ulambu u ma uwwa ma adanshi u ta̱ va damma iwuya ya̱ a̱ga̱nda̱ a̱ tyo a̱ a̱ma̱li. Adama a na vu 'yuwain a yuwaan tsutoni na adanshi a̱ A̱sulazuva, u 'yuwan wu ta̱ a na vaa lyuwa elime na̱ tsugono.>> ");
INSERT INTO tsw_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Reve Shawulu damma Sama'ila, <<N yuwan ta̱ unusu n ka̱ra̱ ta̱ uɗuma̱ ni icu'un. N yuwan tsutoni ni ili i na A̱sulazuva a zuwai n yuwan nu udammu wa̱ yi oɓolo ni ili i na vu dammai shi. N da̱na̱ ta̱ a uwwusa wovon wa ama, ɗaɗa i zuwai n yuwain tsutoni ni ili i na a dammai. ");
INSERT INTO tsw_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Gogo gba n te ipati ya̱ wu, vu yuwaan mu gafura vu unusu u va̱. A̱vu vu ka̱mba̱ na̱ a̱mu, adama n yuwaan A̱sulazuva a̱ga̱nda̱.>> ");
INSERT INTO tsw_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","A̱vu Sama'ila damma Shawulu, <<Ma̱a̱ ka̱mba̱ na̱ a̱vu shi. A̱vu ɗa vu ꞌyuwain adanshi a̱ A̱sulazuva, ɗaɗa gba u 'yuwan nuwu a na vaa lyuwa elime na̱ tsugono tsa a ama a Isra'ila!>> ");
INSERT INTO tsw_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Ana Sama'ila vadalai a na wa̱a̱ ka̱ra̱, reve Shawulu reme iwa̱sa̱ ye elentsu o utugu wa̱ yi a̱vu u kara yi. ");
INSERT INTO tsw_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","A̱vu Sama'ila damma yi, <<A̱sulazuva a kara ta̱ tsugono tsa ama a Isra'ila ekere a̱ wu anaꞌan. A̱vu u ca moron ma̱ wu za na laꞌa nuwu. ");
INSERT INTO tsw_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","A̱yi za na a̱yi ɗa Tsugbain tsa aza a Isra'ila u tsu yuwan epen shi, waru u tsu vadala okolo a̱ yi shi. Adama a na a̱yi vuma ɗa shi, na waa vadala okolo a̱yi.>> ");
INSERT INTO tsw_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","Reve Shawulu damma, <<N yuwan ta̱ unusu. Amma yuwan ankuri ca mu tsugbain elime a mbara ma ama a̱ va̱ ne elime aza a Isra'ila. Vu ka̱mba̱ oɓolo na̱ a̱mu adama n yuwaan A̱sulazuva A̱sula̱ a̱ wu a̱ga̱nda̱.>> ");
INSERT INTO tsw_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","Reve Sama'ila ka̱mba̱ oɓolo na̱ Shawulu, a̱vu Shawulu yuwaan A̱sulazuva a̱ga̱nda̱. ");
INSERT INTO tsw_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Reve Sama'ila damma, <<Ta̱wa̱a̱ numu na̱ Aga mogono ma aza a Amaleka pa nda.>> A̱vu Aga ta̱wa̱ ya̱'a̱ yi na asuvu nden a majiyan, <<Amayun ili i ro yi lo shi, meleshe mo ukwa̱ ma̱ ka̱ra̱ ta̱.>> ");
INSERT INTO tsw_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","Amma a̱vu Sama'ila damma, <<Cine matsun me pe'eni ma̱ wu ma̱ ka̱mbuwa̱i a̱ma̱ci babu muwun, ne ɗa fo mma va̱ wu o'wo babu muwun a̱ a̱tsuma̱ a̱ a̱ma̱ci.>> A̱vu Sama'ila yuwan Aga mukoɗi mukoɗi a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva a Gilga. ");
INSERT INTO tsw_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","A̱vu Sama'ila ka̱ra̱ a̱ ka̱mba̱ a̱ wa̱ta̱ wa̱ yi lyuci va Rama, amma Shawulu ka̱ra̱ ta̱ a̱ ka̱mba̱ o u'wa wa̱ yi a̱ lyuci va Gibiya. ");
INSERT INTO tsw_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Sama'ila da̱shi ga'asan na̱ Shawulu waru shi a rana wuma wa̱ yi suru, amma Sama'ila yuwan ta̱ a̱tsumola̱ngu lon adama a Shawulu. Waru A̱sulazuva a yuwan ta̱ a̱tsumola̱ngu a na u zuwai Shawulu mogono ma aza a Isra'ila. ");
INSERT INTO tsw_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","A̱vu A̱sulazuva a damma Sama'ila, <<Hali mantsa ma̱ ne va̱a̱ da̱na̱ a̱tsumola̱ngu adama a Shawulu? N 'yuwain ta̱ a na wa̱a̱ da̱na̱ mogono ma aza a Isra'ila. Gogo vu shito aavana a̱ wu na̱ mani'in, reve vu reme ure a̱ tyo Batalami. Vu zami ɗe vuma n na a̱ tsu ɗe Yese, n ɗangula ta̱ vuma ta̱ a̱tsuma̱ a̱ olobo a̱yi za na oo o'wo mogono.>> ");
INSERT INTO tsw_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Amma a̱vu Sama'ila damma, <<Adama a̱ nye maa yuwan ne? Shawulu ta uwwa alabari, reve wu una mu.>> Reve A̱sulazuva a̱ usu yi, <<Vu tara a̱na̱wu a manan a̱ 'ya̱wa̱, reve vu damma, <N ta̱wa̱ ta̱ tsa̱ra̱ n ca A̱sulazuva kucci.> ");
INSERT INTO tsw_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","A̱vu vu banu Yese uba̱ta̱ u na vaa yuwan kucci. Waru n ta lyawa wu vu reve ili i na vaa yuwan. Vu ta̱ tsuwa̱a̱n mu ulobo u na waru n damma nu wu mani'in.>> ");
INSERT INTO tsw_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","A̱vu Sama'ila yuwan cine A̱sulazuva a damma niyi u yuwan. Ana u rawai Batalami, a̱vu mbara n lyuci n ga'an toyi na̱ meje'en ma̱ lipu adama o wovon. Reve e ece yi a damma, <<Lafiya ɗa ta̱wa̱to nuwu pa ko?>> ");
INSERT INTO tsw_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Reve Sama'ila usu, <<Ee, lafiya ɗa uta̱wu u va̱. N ta̱wa̱ ta̱ tsa̱ra̱ n yuwaan A̱sulazuva kucci. I tawa aciya̱ɗu yo o'wo na akiza, reve i ta̱wa̱ uba̱ta̱ u kucci'i oɓolo na̱ a̱mu.>> A̱vu u zuwa Yese no olobo a̱ yi a tawa aciyele na akiza. A̱vu u banu le fo a̱ tyo uba̱ta̱ u na a yuwan kucci. ");
INSERT INTO tsw_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Ana a rawai, ana Sama'ila enei Eliyabu ulobo wa Yese, a̱vu u jiyan, <<Adanshi o ro o lo shi, vuma na ri nda mishin a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva a̱yi ɗa u tsuwa̱a̱n yi mani'in.>> ");
INSERT INTO tsw_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Amma gba A̱sulazuva a damma yi ta̱, <<Sama'ila, she vi indana uruma wa̱ yi, ko uga'an wa̱ yi wan, adama a na n 'yuwan yi ta̱. Waru a̱mu A̱sulazuva n tsu indana ili i na vuma tsi indana shi. Vuma tsu ka̱lyuwa̱ ta̱ uruma u vuma goon, amma a̱mu n tsu ka̱lyuwa̱ ta̱ okolo.>> ");
INSERT INTO tsw_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Reve Yese ɗe Abinada ulobo wa̱ yi, a̱vu u zuwa yi u ka̱ra̱la̱i elime a Sama'ila. Amma a̱vu Sama'ila damma, <<A̱sulazuva a ɗangwa yi fo shi.>> ");
INSERT INTO tsw_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","A̱vu Yese zuwa Shama ka̱ra̱la̱i. Reve Sama'ila damma, <<A̱sulazuva a ɗangula a̱yi nda fo shi.>> ");
INSERT INTO tsw_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Yese zuwa ta̱ olobo e cindere a̱tsuma̱ olobo a̱ yi a̱ ka̱ra̱la̱i a̱ ma̱ka̱ka̱n ma Sama'ila. Amma Sama'ila damma yi ta̱, <<A̱sulazuva a ɗangula aza a nda shi.>> ");
INSERT INTO tsw_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Reve Sama'ila ece yi, <<Vu buwa na̱ olobo o ro shi?>> A̱vu Yese usu, <<Mokosoto ma ɗa ma buwai, agba u ta̱ ɗe a aguɓa e mgbele.>> Ɗaɗa Sama'ila dammai, <<Lyungu e ɗe yi u ta̱wa̱, adama a na tse ene nden n na tsa̱ da̱nu tsu lyuwa shi she nu u ta̱wa̱.>> ");
INSERT INTO tsw_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","A̱vu Yese lyungu a̱ 'ya̱wa̱ a̱ ta̱wa̱a̱ na̱ a̱yi. U da̱na̱ ta̱ nu uruma u sa'ani, na̱ gbaga lipu, waru muwun me e esu ma̱ yi n ta̱ ulobonu wa̱ a̱ka̱nla̱. Ɗaɗa A̱sulazuva a dammai, <<Vuma ɗaɗa nda'a! 'Yon vu tsuwa̱n yi mani'in a aaci.>> ");
INSERT INTO tsw_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Ɗaɗa Sama'ila tarai aavana a mani'in a̱vu u tsuwa̱n Da̱wuda a aaci e esu a azakpakpara a̱ yi. Diga o urana u ndolo a̱ 'ya̱wa̱, reve Ruhu va̱ A̱sulazuva a̱ cipa̱a̱ Da̱wuda nu ucira. Reve Sama'ila ka̱ra̱ a̱ ka̱mba̱ o u'wa a Rama. ");
INSERT INTO tsw_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Gogo Ruhu va̱ A̱sulazuva lyawa ta̱ Shawulu, a̱vu ruhu vama diga uba̱ta̱ wa̱ A̱sulazuva u casu yi a̱tsuma̱lima̱ na̱ wovon lon. ");
INSERT INTO tsw_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Reve agbashi a Shawulu a damma yi, <<A̱yi ɗa nda ruhu vama diga uba̱ta̱ wa̱ A̱sula̱ u ta casu wu a̱tsuma̱lima̱ na̱ wovon lon. ");
INSERT INTO tsw_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Lyawa zagbain tsu zuwa agbashi a̱ yi a̱ 'ya̱wa̱ a zami vuma na gurai tsuwe'e tsa kumburu. U ta̱ wa'a a mantsa ma na ruhu vama diga uba̱ta̱ wa̱ A̱sula̱ cipa̱a̱ nuwu, reve gba u ugbozu wa̱ wu u von.>> ");
INSERT INTO tsw_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Reve Shawulu damma agbashi a̱ yi, <<'Ya̱wa̱i i zami za na gurai tsuwe'e i ta̱wa̱a̱ mu.>> ");
INSERT INTO tsw_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","A̱vu za ta̱ a̱tsuma̱ a agbashi'i u damma, <<N reve ta̱ ulobo wa̱ Yese va Batalami za na revei cine a tsu waꞌa kumburu. Vuma ɗa na ri nu ukadu lon, za na gurai uvon, u tsu yuwan ta̱ adanshi nu ugbozu, waru u ta̱ ulobonu lon, A̱sulazuva o to oɓolo na̱ a̱yi.>> ");
INSERT INTO tsw_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","Reve Shawulu lyungu nlingata a̱ 'ya̱wa̱ ya̱ Yese, a̱vu a damma, <<Vu lyunguwa̱ mu nu ulobo wa̱ wu Da̱wuda, za na aa guɓusaa wu mgbele.>> ");
INSERT INTO tsw_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Ɗaɗa Yese tarai mololi utanuwu no opopofu, na̱ tsa̱n vu ukwan masayan ma̱ ina̱bi na̱ megbgbele, a̱vu u lyungu le oɓolo nu ulobo wa̱ yi Da̱wuda a̱ tyo ya Shawulu. ");
INSERT INTO tsw_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","Reve Da̱wuda ta̱wa̱ uba̱ta̱ wa Shawulu reve u teme a yuwusaan yi a̱ga̱nda̱. Shawulu ciga yi ta̱ lon, a̱vu u zuwai za na a̱a̱ da̱na̱ a̱ guzusa̱a̱ yi itana yu uvon. ");
INSERT INTO tsw_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Reve Shawulu lyunguwa̱ Yese na adanshi, adansa, <<Lyawa Da̱wuda da̱nu u lyuwa elime u yuwusan mu a̱ a̱ga̱nda̱, adama a na u tsura̱ ta̱ isa'ani e ekere a̱ va̱.>> ");
INSERT INTO tsw_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Ne ɗa na̱ ruhu vama diga uba̱ta̱ wa̱ A̱sula̱ cipa̱a̱ Shawulu biti, Da̱wuda tsu tara ta̱ kumburu va̱ yi reve u reme tsuwe'e. A̱vu ruhu vama'a u lyawai, reve ugbozu wa Shawulu u von. ");
INSERT INTO tsw_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","A̱soja a Filistiya o foɓo ta̱ adama o uvon, a̱vu o ɓoloto a̱ lyuci va Soko a̱tsuma̱ e iɗa ya Yahuda. A̱ shuwa̱ ta̱ uva̱la̱ta̱ a Efes Damim, e memere mo Soko na̱ Azeka. ");
INSERT INTO tsw_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","A̱vu Shawulu na̱ ali o uvon a Isra'ila oɓoloto a̱ va̱la̱ o uka̱ri wa Ela, reve e gere adama a na aa yuwan uvon na̱ a̱soja a aza a Filistiya. ");
INSERT INTO tsw_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","Aza a Filistiya a̱ da̱na̱ ta̱ a masasan ma̱ ta̱ ugeru, aza a Isra'ila waru a za ire, nu uka̱ri e memere me ele. ");
INSERT INTO tsw_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","A yuwan ta̱ vuma ro na la'a gurai uvon na a̱ tsu ɗe Goliya, diga a̱ lyuci va Gat, wu uta̱ ta̱ o uva̱la̱ta̱ wa aza a Filistiya. Uga'an wa̱ yi u la'a ta̱ ana kucci. ");
INSERT INTO tsw_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","U da̱na̱ ta̱ na̱ melezu mo uvon ma̱ rumushili a aaci a̱ yi reve waru wo oto utugu wu uɗavu wu rumushili wu uvon a na ume wa̱ yi u dembe ta̱ ume u kilo kupoton na̱ a̱za̱ cindere. ");
INSERT INTO tsw_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","Reve wo oto waru a̱a̱ra̱ga̱ a̱ rumushili a ana a̱ yi a na a tsu pala ana, reve u wo'o mabata ma̱ rumushili o ucina̱ wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","Ugba̱mu wi ibata ya̱ yi u ta̱ tsu ushin, waru ume wa aaci a̱ rumu wi ibata'a u rawa ta̱ uritowu kilo cindere wu rumu. Soja da̱na̱ ta̱ elime a̱ yi uguzu na̱ a̱a̱ra̱ga̱ a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","A̱vu Goliya isawan mishin, reve wo oruwoo ali o uvon o ugeru a Isra'ila, <<Nye i ɗa i zuwai i ta̱wa̱i, reve i gere tsa̱ra̱ i yuwan uvon na̱ a̱tsu? A̱mu za va Filistiya ɗa shi, waru a̱ɗu agbashi a Shawulu a ɗa shi? Ɗangulai vuma ta̱ a̱tsuma̱ a̱ ɗu adama u cipa̱ u yuwan nla̱ngi na̱ mu! ");
INSERT INTO tsw_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Nu u gura yuwan nla̱ngi na̱ mu reve wu una mu, tsu to o'wo agbashi a̱ ɗu, agba na̱ n la'a yi ucira reve mu una yi, i to o'wo agbashi a̱ tsu a̱vu i yuwaan tsu tsugbashi.>> ");
INSERT INTO tsw_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Reve za va Filistiya'a u damma, <<Ana'an n ta yuwusan oɓolo ali o uvon a Isra'ila ulamu! Ɗangulaa numu vuma ta̱ tsu yuwan nla̱ngi.>> ");
INSERT INTO tsw_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Ana Shawulu na aza a Isra'ila suru a uwwai ili i na za va Filistiya dammai, reve a kuɗa okolo a uwwa wovon lon. ");
INSERT INTO tsw_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","Da̱wuda gba ulobo wa̱ Yese ɗa, vuma va Efarata, diga a̱ lyuci va̱ Batalami a̱tsuma̱ a Yahuda. Yese da̱na̱ ta̱ no olobo kunla̱. Waru a mantsa ma na Shawulu da̱na̱i o tsugono, Yese kutsa ta̱ ɗe, waru u da̱na̱ ta̱ na a'wan lon. ");
INSERT INTO tsw_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","Olobo a ta'atsu a kpakpara a̱ Yese, ele ɗa Eliyabu na̱ Abinada na̱ Shama, a̱ shi ta̱ oɓolo ukere na̱ ali o uvon a Shawulu adama a yuwan uvon na aza a Filistiya. ");
INSERT INTO tsw_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","Da̱wuda ɗa le mokosoto. Azakpakpara a ta'atsu'u a̱da̱na̱ ta̱ oɓolo na ali o uvon a Shawulu. ");
INSERT INTO tsw_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","Amma Da̱wuda 'ya̱wusa̱ ta̱ nu u ka̱mbi uba̱ta̱ wa Shawulu adama u guɓusa mgbele ma dada va̱ yi a Batalami. ");
INSERT INTO tsw_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","A̱vu Goliya za va Filistiya ka̱ra̱ o uta̱ wi isawan o ronuso una̱ wa ali o uvon a Isra'ila usana nu ulivu suru hali rana amunga. ");
INSERT INTO tsw_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Urana u ro reve Yese damma ulobo wa̱ yi Da̱wuda, <<Taraa azakpakpara a̱ wu makundatsu kupa ne ejere vi ishina yu uzuwun i nda na akpatali kupa o opopofu, vu jika̱, vu 'ya̱wa̱a̱ le o uva̱la̱ta̱. ");
INSERT INTO tsw_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","Waru vu taraa yali ya̱ a̱soja e le wara vi inan kupa. Vu reve cine a̱za̱ a̱ wu a̱ ri a̱vu vu ta̱wa̱a̱ mu ni ili i ro i na yoo roco cine a̱ ri ɗe.>> ");
INSERT INTO tsw_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Azakpakpara a̱ Da̱wuda a̱da̱na̱ ta̱ ɗe oɓolo na̱ Shawulu na ali o uvon a Isra'ila suru o uka̱ri wa Ela a yuwusan uvon na aza a Filistiya. ");
INSERT INTO tsw_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Na̱ wasasa a̱vu Da̱wuda lyawa oɓolo e mgbele ekere a za va aguɓa o ro, reve u tara itana u ka̱ra̱ cine dada va̱ yi Yese damma niyi. U rawa ta̱ o uva̱la̱ta̱'a̱ a mantsa ma na ali o uvon a Isra'ila a̱ ri a̱ mota̱a̱ a̱ 'ya̱wa̱ e gere, a yisali yu uvon. ");
INSERT INTO tsw_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Aza a Isra'ila na aza a Filistiya e isawan ta̱ ugeru adama o uvon, waru a̱da̱na̱ ta̱ a̱ nka̱la̱la̱i. ");
INSERT INTO tsw_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","A̱vu Da̱wuda lyawa itana'a e ekere a soja na aa ka̱lyuwusa̱ itana, reve u suma a̱ tyo uba̱ta̱ u na e gerei adama o uvon tsa̱ra̱ u ca̱sa̱ azakpakpara a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","A̱yi a̱tsuma̱ a adanshi ne ele, reve Goliya za na la'a gurai uvon va aza a Filistiya'a vuma va Gat, u ka̱ra̱ uta̱ diga o uva̱la̱ta̱ wa aza a Filistiya a̱vu u yuwan adanshi tsu ufaru. Da̱wuda gba a uwusai. ");
INSERT INTO tsw_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Ana ali o uvon a Isra'ila enei Goliya, a̱vu a sumaa yi adama o wovon lon. ");
INSERT INTO tsw_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","Aza a Isra'ila a̱ shi ta̱ a dansa va̱ni le, <<Ye ene ta̱ cine vuma nda o utusa̱? Suru urana u ta̱ utusa̱ adama u yuwan aza a Isra'ila ulamu. Mogono ma damma ta̱ u ta ca vuma na suru unai vuma nda utsuru wa̱ a̱bunda̱. Waru u ta ca yi usheli wa̱ yi lolo, waru u'wa wa dada va̱ yi wa tsupa utafa a̱tsuma̱ a Isra'ila shi.>> ");
INSERT INTO tsw_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Ɗaɗa Da̱wuda ecei ali o uvon a na a̱ da̱na̱i mishin zuzu na̱ a̱yi, <<Nye i ɗa aa yuwaan vuma na unai vuma va Filistiya nda, nu u tawa wono u nda uba̱ta̱ wa aza a Isra'ila? Zane ɗa za babu upaɗu wu uryumbu va Filistiya nda, na waa yuwusaan ali o uvon A̱sula̱ a wuma ulamu?>> ");
INSERT INTO tsw_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Reve a̱ ka̱mbuwa̱ yi ili i na a̱ ri a dansa va̱ni le, a damma yi, <<Ne ɗa aa yuwaan vuma na una niyi.>> ");
INSERT INTO tsw_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","Ana Eliyabu zakpara nan Da̱wuda suru suru uwwa niyi a adanshi na ama'a, reve u yuwan upan na̱ a̱yi lon, a̱vu we ece, <<Adama a̱ nye vu ta̱wa̱i pa? Waru zane vu lyawayi mgbele n wa'a i ndolo a̱tsumona? N reve ta̱ cine vu ri nu uvaɗu na akpaka, vu ta̱wa̱ ta̱ adama vu ka̱lyuwa̱ uvon.>> ");
INSERT INTO tsw_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","A̱vu Da̱wuda damma, <<To, nye n yuwain? Yeci ɗa goon ma yuwusan!>> ");
INSERT INTO tsw_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Ɗaɗa u lyawa niyi reve u vadala ya nanza, a̱vu u yuwisan yi cu'un yeci'i, a̱vu u usu yi tsu ufaru. Suru ali o uvo'on za na we ecei biti, a̱vu usu yi tsu ufaru. ");
INSERT INTO tsw_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Ali o uvon o ro a uwwa ta̱ ili i na Da̱wuda dammai, reve a damma Shawulu, a̱vu u zuwa e ɗe yi. ");
INSERT INTO tsw_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","A̱vu Da̱wuda damma Shawulu, <<She nanza dada'wan adama a vuma va Filistiya nda wan. Aagbashi a̱ wu a̱ ta̱ 'ya̱wa̱ u yuwan nla̱ngi na̱ a̱yi.>> ");
INSERT INTO tsw_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Reve Shawulu usu Da̱wuda, <<Vaa gura yuwan uvon na̱ za va Filistiya nda hali vu lyuwa aciya̱yi shi! A̱vu ulobo u ɗa vu buwai. Agba Goliya gura ta̱ uvon a̱yi o ulobo.>> ");
INSERT INTO tsw_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Amma Da̱wuda damma ta̱ Shawulu, <<N ta guɓusaa dada va̱ mgbele. A mantsa ma na kamu ko a̱ba̱jini a nama vu una na a̱ tsu ɗe biya remei kyon diga o oɓolo, ");
INSERT INTO tsw_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","n tsu saɓa yi ta̱ n faba yi, reve n wawa kyon va̱ diga o una̱ wa̱ yi. Waru nna̱ kamu'u ko biya'a u piri, n tsu gbagbala ta̱ eleme a̱ yinlu yi, reve n faba yi e iɗa mu una yi. ");
INSERT INTO tsw_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Aagbashi a̱ wu o una ta̱ ikamu na̱ nan biya. Vuma babu upaɗu wu uryumbu nda fo u ta̱ o'wo tsa za ta̱ le, adama a na u yuwaan ta̱ ali o uvon A̱sula̱ a wuma ulamu. ");
INSERT INTO tsw_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","A̱sulazuva a na wawa numu diga a̱ a̱kpa̱ta̱ e ikamu na̱ nan biya, a̱yi ɗa waru waa wawa mu e ekere a vuma va Filistiya nda.>> A̱vu Shawulu damma Da̱wuda, <<Wala, lyawa A̱sulazuva a̱ da̱na̱ oɓolo na̱ a̱vu.>> ");
INSERT INTO tsw_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Reve Shawulu oto yi itana yu uvon ya̱ yi. A̱vu wo oto yi melezu mo uvon ma̱ rumushili a aaci, reve wo oto yi utugu wu uɗavu wu rumushili. ");
INSERT INTO tsw_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","A̱vu Da̱wuda nla̱ matsun me pe'eni o utugu'u, a̱vu u rito dasu adama a na koto u yuwan ulinga ne ele shi. A̱vu u damma Shawulu, <<Maa gura dasu na̱ nda shi, adama a na koto n yuwan ulinga ne ele shi.>> Reve wu foɗo itana yu uvo'on. ");
INSERT INTO tsw_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","A̱vu u tara aaɗanga a aguɓa a̱ yi, reve wu ta̱ɗa̱ mugbodolu ma atali n ton a̱tsuma̱ o moɗolu, a̱vu u zuwa le a̱ tsa̱n va aguɓa va̱ yi oɓolo na̱ a̱bitsutsu a̱ yi ufoɓu o ukere, reve u ka̱ra̱ o uta̱ u ga'an na̱ Goliya. ");
INSERT INTO tsw_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","A mantsa'a fo za va Filistiya'a u zurusa̱ ta̱ Da̱wuda. Vuma na ri uguzu na̱ a̱a̱ra̱ga̱ a̱ yi u da̱na̱ ta̱ elime a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Ana za va Filistiya ndolo petelyuwei Da̱wuda ulobonu, reve we ene ulobo u ɗa nu uruma u sa'ani, na̱ gbaga lipu, reve u goro yi. ");
INSERT INTO tsw_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","A̱vu Goliya ece yi, <<Vu ta a majiyan a̱mu musa̱n ma ɗa? A̱yi ɗa i zuwai vu ta̱wa̱i ya̱'a̱ va̱ na aaɗanga?>> Reve wi isululai Da̱wuda na aala a̱ musula̱ ma a aza a Filistiya. ");
INSERT INTO tsw_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","Ɗaɗa za va Filistiya'a wa saala Da̱wuda, <<Ta̱wa̱ pa nda, n ta ca asala ni inama yu una inama ya̱ wu!>> ");
INSERT INTO tsw_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","A̱vu Da̱wuda damma yi, <<Vu ta̱wa̱ ta̱ tsa̱ra̱ vu yuwan nla̱ngi na̱ a̱mu na̱ matsun me pe'eni oɓolo ni ibata na̱ mabata. A̱mu gba shi, n ta̱wa̱ ta̱ n yuwan nla̱ngi na̱ a̱vu a̱tsuma̱ a ala a̱ A̱sulazuva o oɓolo a̱ a̱soja a zuva. A̱yi ɗa A̱sula̱ a̱ a̱soja a Isra'ila, za na vu yuwan yi ulamu. ");
INSERT INTO tsw_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","Ana'an A̱sulazuva a ta ca mu a̱vu e ekere a̱ va̱. N ta o una wu, waru n to koɗo aaci a̱ wu. Ana'an n ta ca asala ni inama yu una a̱kwa̱kwa̱ ali o uvon a Filistiya, reve uvaɗi ma̱ɓula̱ u reve a na A̱sula̱ a̱ ta̱ a̱tsuma̱ a Isra'ila na amayun! ");
INSERT INTO tsw_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Aza a na a̱ ri uɓolotowu pa suru e te reve a na na̱ matsun me pe'eni ma ɗa ko ni ibata i ɗa A̱sulazuva a tsu wawa shi, adama a na uvon za va̱ A̱sulazuva a ɗa, waru u ta ca suru nɗu e ekere a̱ tsu.>> ");
INSERT INTO tsw_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Ana Goliya da̱shi zura̱ niyi zuzu, a̱vu Da̱wuda zarana a rawa uba̱ta̱ u na a̱soja a Filistiya a̱ ri yu ugeru adama u ga'asan na̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","A̱vu Da̱wuda tara aatali a̱ ta̱ a̱tsuma̱ a̱ tsa̱n va̱ yi, reve u zuwa yi a̱ a̱bitsutsu a̱ yi a̱vu u vuta̱la̱ yi. Reve aatali'i a vara Goliya a̱ cin, reve u ka̱ra̱ a uwa pe a̱ cin va̱ yi, a̱vu u riya̱ ma̱kpa̱ɓa̱. ");
INSERT INTO tsw_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","Ne ɗa Da̱wuda lyuwai aci a za va Filistiya na̱ a̱bitsutsu na aatali a̱ ta̱, a na u vara niyi u riya̱i. Waru u da̱na̱ na̱ matsun me pe'eni o ukere wa̱ yi shi. ");
INSERT INTO tsw_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","A̱vu Da̱wuda suma u rawa uba̱ta̱ wa̱ yi. Reve u tala matsun me pe'eni ma Goliya a̱tsuma̱ e ibici ya̱ yi, reve wu unai u koɗo aaci a̱ yi na̱ matsun me pe'eni'i. Ana aza a Filistiya e enei za vu uvon vu ucira le kuwa̱ ta̱, reve a vadala a suma. ");
INSERT INTO tsw_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Reve ali o uvon a Isra'ila na aza a Yahuda a̱ 'yon na̱ yorori reve a gbagba aza a Filistiya a̱ tyo o una̱ntsu wa Gat nu una̱ntsu wa Ekuron. Aza a Filistiya a na amatoyin na̱ a̱kwa̱kwa̱ e le ocusho ta̱ o ure diga Sha'arayim hali a̱ tyo Gat na̱ Ekuron. ");
INSERT INTO tsw_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","Ana ali o uvon a Isra'ila a̱ ka̱mba̱i diga uba̱ta̱ u magbagba ma aza a Filistiya, a̱vu a̱ pura̱ uva̱la̱ta̱ u le. ");
INSERT INTO tsw_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","Reve Da̱wuda tara aaci a Goliya a̱vu u tyewoto yi Urishelima, a̱vu u zuwa itana yu uvon ya Goliya o oogodo a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","A mantsa ma na Shawulu enei Da̱wuda a̱ 'ya̱wa̱ uba̱ta̱ wa Goliya, reve we ece Abna, yali ya a̱soja, <<Abna, ulobo wa̱ zane u ɗa ulobo u nda'a?>> A̱vu Abna damma, <<N kucina ta̱ na̱ a̱vu, mogono, n reve shi.>> ");
INSERT INTO tsw_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","Reve mogono ma damma, <<E ece ko ulobo wa̱ zane ɗa ulobo u nda'a.>> ");
INSERT INTO tsw_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","Ana Da̱wuda ka̱mba̱i diga uba̱ta̱ u mona ma Goliya, a̱vu Abna tara yi, reve u tyewoto yi a̱ ma̱ka̱ka̱n ma Shawulu a̱yi uguzu na aaci a Goliya o ukere wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","Reve Shawulu ece yi, <<A̱vu ulobo wa̱ zane ɗa, ulobo?>> A̱vu Da̱wuda damma, <<A̱mu ulobo wa aagbashi a̱ wu Yese va Batalami ɗa.>> ");
INSERT INTO tsw_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","Ana Da̱wuda kotoi adanshi na̱ Shawulu, a̱vu Jonata ulobo wa Shawulu uwwa ookolo a̱ yi e icigi ya̱ Da̱wuda lon. A̱vu u ciga yi tsa wuma wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","Diga o uranu u ndolo Shawulu ɓana ta̱ Da̱wuda, waru u lyawa yi u ka̱mba̱ o u'wa wa dada va̱ yi shi. ");
INSERT INTO tsw_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","Reve Jonata yuwan nzuwulai na̱ Da̱wuda, adama a na u ciga yi ta̱ tsa wuma wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","Reve Jonata foɗo utugu u na u ri na̱ a̱yi wotowu, a̱vu u ca Da̱wuda, ni itana yu uvon ya̱ yi, na̱ matsun me pe'eni ma̱ yi, nu utan nu ujin wa̱ yi, na̱ gbakala va̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Waru Da̱wuda tsu 'ya̱wa̱ ta̱ u lyuwa aci uba̱ta̱ u na Shawulu lyungu niyi uvon biti, reve Shawulu zuwa yi yali ya̱ a̱soja o uvon a̱ yi. Waru ili'i u yo'ono ta̱ ali o uvon suru, oɓolo na̱ nan yali yu uvon a Shawulu. ");
INSERT INTO tsw_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Ana ali o uvon a Isra'ila a̱ ri a̱ ma̱ ka̱mba̱ o u'wa, mantsa ma na Da̱wuda ka̱mba̱i diga uba̱ta̱ u na wu unai Goliya, a̱vu a̱ma̱ci o uta̱ e ilyuci ya Isra'ila suru, adama a ga'asan na̱ Shawulu mogono, na̱ muganga ni ikumburu a̱ ma̱za̱nga̱ e ishipa nu uje'en. ");
INSERT INTO tsw_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Ele o uje'en a̱vu a cana, <<Shawulu una ta̱ kpaku kupa va̱ yi, waru Da̱wuda una ta̱ ukpakukupa kupa va̱ yi va̱ a̱bunda̱.>> ");
INSERT INTO tsw_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Reve Shawulu yuwan upan lon, a̱vu udammu u ndolo u damaton yi. A̱vu u damma, <<A cuwa ta̱ Da̱wuda na̱ ukpakukupa kupa va̱ a̱bunda̱ a̱mu gba shi kpaku kupa goon. Nye i ɗa i buwa niyi a na wa̱a̱ tsura̱ she tsugono goon ko?>> ");
INSERT INTO tsw_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Waru diga a mantsa mo ndolo a̱ ka̱ra̱ a̱vu Shawulu reme tsushu'un na̱ Da̱wuda. ");
INSERT INTO tsw_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","O urana we ire a̱vu ruhu vama diga uba̱ta̱ wa̱ A̱sula̱ cipa̱a̱ Shawulu nu ucira, a̱vu wo o'wo a yuwusan adanshi e ikaka ya̱ A̱sula̱ a̱tsuma̱ o u'wa wa̱ yi tsa vuma vu ujaru, a mantsa mo ndolo gba Da̱wuda wa'asaa yi ta̱ kumburu, cine u tsu yuwusan. Shawulu gba da̱na̱ ta̱ ni ibata o ukere wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","A̱vu u sari yi, a majiyan okolo a̱yi, <<N ta sapalai Da̱wuda nu uɓaɓu.>> Amma Da̱wuda kanzu'usa ta̱ toto ure. ");
INSERT INTO tsw_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","Shawulu uwwa ta̱ wovon wa̱ Da̱wuda adama a na A̱sulazuva o to oɓolo na̱ yi, amma A̱sulazuva a vadalaa ta̱ Shawulu ucina̱. ");
INSERT INTO tsw_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","Ɗaɗa Shawulu tawa niyi a̱ ma̱ka̱ka̱n ma̱ yi reve u zuwa yi yali ya̱ a̱soja ukpakukupa (1,000) adama u walaa le elime uba̱ta̱ o uvon. ");
INSERT INTO tsw_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","A̱tsuma̱ e ili i na Da̱wuda yuwain suru u tsa̱ra̱ ta̱ ulyuwu wa aci, adama a na A̱sulazuva o to oɓolo na̱ a̱yi. ");
INSERT INTO tsw_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","Waru ana Shawulu enei Da̱wuda ta̱ tsura̱sa̱ ulyuwu wa aci lon, a̱vu wu uwwa wovon wa̱ yi lon. ");
INSERT INTO tsw_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","Amma aza a Isra'ila na aza a Yahuda suru a ciga ta̱ Da̱wuda, adama a na u ta̱ ronuso le aɗanga ulobonu uba̱ta̱ o uvon. ");
INSERT INTO tsw_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","Ele lo reve Shawulu damma Da̱wuda, <<Apa usheli u kpara u va̱ Mera, n ta ca wu a̱yi lolo, vu yuwaan mu a̱ga̱nda̱ na̱ ukadu goon, waru vu yuwan uvon wa̱ A̱sulazuva.>> Adama a na Shawulu jiyan ta̱ a asuvu a̱ yi, <<Ma̱a̱ ya̱sa̱n ukere u va̱ ju'wa̱in shi, amma lyawa aza a Filistiya o una yi!>> ");
INSERT INTO tsw_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","Da̱wuda damma ta̱ Shawulu, <<Zane ɗa n ri waru zane ɗa mmaci n va̱ ko umatsun wa dada va̱ a̱tsuma̱ a Isra'ila, hali a na mo o'wo toto mogono?>> ");
INSERT INTO tsw_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","Amma a na mantsa ma rawai a na Shawulu a ca usheli wa̱ yi Mera lolo ekere Da̱wuda, reve u ca Adriye vuma va Mehola. ");
INSERT INTO tsw_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","Mikal gba usheli wa Shawulu u ta̱ e icigi ya̱ Da̱wuda. Ana a dammai Shawulu aɗa a̱ yi, reve wu uwwa uyo'o lon. ");
INSERT INTO tsw_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","Reve u jiyan o okolo a̱ yi, <<N ta ca yi a̱yi adama wo o'wo yi maza waru adama aza a Filistiya a̱tsura̱ o una yi.>> Ɗaɗa Shawulu dammai Da̱wuda we ire, <<Gogo vu to o'wo toto va̱.>> ");
INSERT INTO tsw_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","A̱vu Shawulu damma agbashi a̱yi, <<Yuwain adanshi na̱ Da̱wuda usokowu i damma, <A̱yi ɗa nda mogono ma ta uwwusa na̱ a̱vu, waru suru agbashi a̱yi a ciga wu ta̱. Gogo nye yaa putsa a̱ wu a na va̱ usu a na voo o'wo toto va̱ yi?> >> ");
INSERT INTO tsw_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","Reve agbashi a Shawulu a̱ ka̱mbuwa̱ Da̱wuda adanshi a nda usokowu. A̱vu Da̱wuda damma, <<I ta majiyan ili yu uro i ɗa a na moo o'wo toto mogono? A̱mu za vu ulambu ɗa waru ili i ro ɗa shi.>> ");
INSERT INTO tsw_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","Ana agbashi a Shawulu a̱ ka̱mbuwa̱ niyi ili i na Da̱wuda dammai, ");
INSERT INTO tsw_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","reve Shawulu damma, <<Dammai Da̱wuda, <Mogono ma ciga atsupu e ili i tsutoto i ro shi na a̱ ka̱ra̱i kwan vu ryumbu ukpaku (100) wa aza a Filistiya shi, adama u tsupa n'yuwatan ma̱ yi.> >> Majiyan ma Shawulu a̱yi ɗa adama Da̱wuda kuwa̱ e ekere aza a Filistiya. ");
INSERT INTO tsw_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","Ana agbashi'i a dammai Da̱wuda adanshi a nda a̱vu Da̱wuda uwwa uyo'o lon a na wo o'wo toto mogono. Kafu mantsa ma atsupu e ikebe i lolo'o i rawa, ");
INSERT INTO tsw_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","reve Da̱wuda 'yon oɓolo na̱ a̱soja a̱ yi, reve o una aza a Filistiya ukpakure (200). A̱vu Da̱wuda ta̱wa̱ na̱ kwan vu ryumbu le, a̱vu u ca mogono ele suru, adama wo o'wo toto mogono. Reve Shawulu ca yi usheli wa̱ yi Mikal lolo. ");
INSERT INTO tsw_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","Ana Shawulu enei A̱sulazuva o to oɓolo na̱ Da̱wuda, waru usheli wa̱ yi Mikal ciga ta̱ Da̱wuda, ");
INSERT INTO tsw_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","reve Shawulu da̱shi uwwa wovon wa̱ Da̱wuda, a̱vu wo o'wo ma'yuwatan ma̱ yi a akapi arana wuma wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","Mantsa ma na suru nan yali yu uvon a Filistiya o uta̱i adama a yuwan uvon na aza a Isra'ila, Da̱wuda tsu lyuwa ta̱ aci e le, u la'a akapi a yali yu uvon ya Shawulu, reve aala a̱ yi a̱ uta̱ lon. ");
INSERT INTO tsw_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","Shawulu damma ta̱ Jonata ulobo wa̱ yi na agbashi a̱ yi suru o una Da̱wuda. Agba Jonata te icigi ya̱ Da̱wuda lon. ");
INSERT INTO tsw_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","Reve Jonata damma Da̱wuda, <<Dada va̱ ta zamishi ure u na wa una wu. Vu yuwan ugbozu nfa'an nu usana, vu 'ya̱wa̱ o upa'atan vi isawan ɗe. ");
INSERT INTO tsw_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","Waru n to uta̱ mi isawan zuzu na̱ dada va̱ a atsusa uba̱ta̱ u na vu ri upa'awun. N ta̱ a yuwan adanshi na̱ dada va̱ adama a̱ wu, a̱vu n damma wu suru ili i na u dammai.>> ");
INSERT INTO tsw_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","A̱vu Jonata yuwan adanshi adama a ɗa Da̱wuda ulobonu uba̱ta̱ wa dada va̱ yi Shawulu, a̱vu u damma yi, <<She mogono ma yuwan unusu uba̱ta̱ aagbashi a̱ yi Da̱wuda wan, adama a na u yuwaan wu unusu shi, waru adama a na ili i na u yuwain u ta̱wa̱a̱ wu ta̱ ni i kambi shi na̱ a̱bunda̱. ");
INSERT INTO tsw_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","Adama a na u ca ta̱ wuma wa̱ yi, reve wu una za va a Filistiya. Waru A̱sulazuva a ca ta̱ ulyuwu wa aci wa̱ a̱bunda̱ uba̱ta̱ wa̱ aza a Isra'ila suru, waru ve ene ta̱ reve vu yuwan ma̱za̱nga̱. Nye i zuwai vaa yuwan unusu uba̱ta̱ u vuma na ri nu unusu shi? She vu una Da̱wuda babu unusu u ro wan!>> ");
INSERT INTO tsw_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","A̱vu Shawulu uwwa adanshi a Jonata a̱vu u yuwan akucunu, <<N kucuna ta̱ na̱ A̱sulazuva a na a̱ ri wuma, moo una yi shi.>> ");
INSERT INTO tsw_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","A̱vu Jonata ɗe Da̱wuda reve u damma yi adanshi a nda suru. A̱vu Jonata ta̱wa̱ na̱ Da̱wuda uba̱ta̱ wa Shawulu, a̱vu u da̱nu oɓolo na̱ yi tsu ufaru. ");
INSERT INTO tsw_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","A̱vu waru uvon u 'yowisa̱n, reve Da̱wuda uta̱ a na waa yuwan uvon na aza a Filistiya, waru u kototo le ta̱ wa'a shi, ɗaɗa a sumai a̱ ma̱ka̱ka̱n ma̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","Uranu u ro Shawulu da̱na̱ ta̱ nde o u'wa wa̱ yi, uguzu ni ibata o ukere wa̱ yi. A̱vu ruhu vama diga uba̱ta̱ wa̱ A̱sulazuva cipa̱ yi, Da̱wuda a wa'asa yi kumburu, ");
INSERT INTO tsw_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","reve Shawulu zami ure u na̱ waa sapalai Da̱wuda ni ibata u ɓoloi nu uɓaɓu, amma a̱vu Da̱wuda kanzu'wa, ɗaɗa ibata i sapai uɓaɓu. A̱tsuma̱ a ayin o ndolo a̱vu Da̱wuda suma adama u la'a na̱ wuma wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","Shawulu lyungu ta̱ aza a matawa mo utyo adama a yuwan ipiri yu u'wa wa Da̱wuda, adama o una yi nu usana. Amma Mikal ka va̱ Da̱wuda, rono yi ta̱ atsuvu, <<Na̱ vu suma adama a wuma wa̱ wu na ayin a nda shi, nfa'an nda a̱ to una wu.>> ");
INSERT INTO tsw_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Ɗaɗa Mikal ta̱telyuwetyoi Da̱wuda nu usowoto wu upepu wa asula, a̱vu u suma ɗaɗa u la'ai. ");
INSERT INTO tsw_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","Reve Mikal tara a̱a̱ma̱li reve u voton yi a̱ a̱a̱ga̱da̱, a̱vu wu pala yi nu umuna a̱vu wo oto yi eleme e megbele a aaci. ");
INSERT INTO tsw_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","Ana Shawulu lyunguwisa̱i aza a matawa mo utyo e reme Da̱wuda, reve Mikal damma le, <<Wu uwwa uyo'o shi.>> ");
INSERT INTO tsw_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","Reve Shawulu da̱shi lyunguwisa̱ aza a matawa mo utyo'o a̱ ka̱mba̱ e ene Da̱wuda ne esu le, reve u damma le, <<Ta̱wa̱a̱ numu na̱ a̱yi a̱ a̱a̱ga̱da̱'a̱ tsura̱ mu una yi.>> ");
INSERT INTO tsw_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","Amma a na aza a matawa mo utyo'o a uwai o u'wa wa̱ Da̱wuda, reve a cina a̱a̱ma̱li a ɗa a̱a̱ga̱da̱'a̱, waru wo oto wu ne eleme e megbele a aaci. ");
INSERT INTO tsw_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","Shawulu damma ta̱ Mikal, <<Nye i zuwai vu luluma̱ numu tsunda vu lyawai ma'yuwatan ma̱ va̱ ma̱ la'ai?>> A̱vu Mikal usu Shawulu, <<Da̱wuda damma mu ta̱ ana, na̱ n lyawai u ka̱ra̱ shi, u to una mu.>> ");
INSERT INTO tsw_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","Ana Da̱wuda sumai u la'ai, reve u tyo ya Sama'ila ɗe Rama, reve u damma yi suru ili i na Shawulu yuwaan niyi. A̱vu a̱yi na̱ Sama'ila a̱ 'ya̱wa̱ a̱ da̱nu uba̱ta̱ u na a̱tsu ɗe Nayo. ");
INSERT INTO tsw_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","Reve udammu u ta̱wa̱ Shawulu, <<Da̱wuda ta̱ Nayo a̱tsuma̱ a Rama.>> ");
INSERT INTO tsw_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","Ɗaɗa u lyunguyi aza a matawa mo utyo a̱ 'ya̱wa̱ e reme Da̱wuda. Amma a na e enei oɓolo a ama̱sula̱ a yuwusan adanshi e ikaka ya̱ A̱sula̱, oɓolo na̱ Sama'ila ɗe mishin elime e le o una̱ wu zagbain, reve Ruhu va̱ A̱sula̱ cipa̱a̱ aza a matawa mo utyo a Shawulu. Reve fo e teme adanshi e ikaka ya̱ A̱sula̱. ");
INSERT INTO tsw_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","Ana a dammai Shawulu, a̱vu u da̱shi lyunguwisa̱ aza a matawa mo utyo o ro, a̱vu a̱ le fo e teme adanshi e ikaka ya̱ A̱sula̱. Reve Shawulu lyunguwisa̱ aza a matawa mo utyo wa ta'atsu, a̱vu e le fo a uwa adanshi e ikaka ya̱ A̱sula̱. ");
INSERT INTO tsw_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","Ɗaɗa a̱yi na aciya̱yi u lapai a̱ tyo Rama. Ana u rawai o ooko'o a gbain a na a̱ ri Seku, reve we ece, <<Te ɗa Sama'ila na̱ Da̱wuda ri?>> Reve a damma yi, <<A̱ ta̱ ɗe Nayo a̱tsuma̱ a Rama.>> ");
INSERT INTO tsw_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","Ɗaɗa Shawulu ka̱ra̱i a̱ tyo Nayo a̱tsuma̱ a Rama. Amma a̱vu fo Ruhu va̱ A̱sula̱ cipa̱a̱ yi, reve u yuwan adanshi e ikaka ya̱ A̱sula̱ a̱tsuma̱ o ure hali u rawa Nayo. ");
INSERT INTO tsw_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","A̱vu wu foɗo a̱tugu a̱ yi u uwa fo adanshi e ikaka ya̱ A̱sula̱ a̱ ma̱ka̱ka̱n ma Sama'ila. A̱vu u von ataɓu urana suru na ayin. A̱yi ɗa i zuwai ama a dammai, <<Shawulu fo ta̱ pe a̱tsuma̱ a ama̱sula̱?>> ");
INSERT INTO tsw_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","Reve Da̱wuda suma diga Nayo a̱tsuma̱ a Rama a̱vu u 'ya̱wa̱ ya Jonata we ece yi, <<Nye i ɗa n yuwain? Iwuya i ne ɗa n yuwain? Unusu ne ɗa n yuwaan yi dada va̱ a̱ wu, a na waa zama wu una a̱ mu?>> ");
INSERT INTO tsw_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","A̱vu Jonata usu yi, <<A̱sulazuva aa para, va̱a̱ kuwa̱ shi! Ka̱lyuwa̱! Dada va̱ tsu yuwan ili i gbain ko ili i ke'en na u tsu kuɗa̱ a damma mu shi. Nye i zuwai wo soko mu za nda? Ne ɗa u ri shi!>> ");
INSERT INTO tsw_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","Amma a̱vu Da̱wuda yuwan akucunu, u damma, <<Dada va̱ wu reve ta̱ lon a na n tsura̱i isa'ani e ekere a̱ wu, reve u jiyan okolo a̱ yi, <Na̱ Jonata reve ili ya nda u ta yuwan a̱tsumola̱ngu lon.> Ko na̱ ne n kucuna ta̱ na̱ A̱sulazuva a na a̱ ri wuma na̱ wuma wa̱ wu, udasuwu u ta̱ ɗa goon u ri e memere ma̱ va̱ nu ukwa̱.>> ");
INSERT INTO tsw_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","Ɗaɗa Jonata dammai Da̱wuda, <<Suru ili i na vu cigai n yuwaan a̱ wu, n ta yuwaan a̱ wu.>> ");
INSERT INTO tsw_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","Reve Da̱wuda damma Jonata, <<A̱yi ɗa nda nfa'an urana wa̱ a̱buki o woto u sa'avu a ɗa, u lobono ta̱ n lyuwa oɓolo na̱ mogono, amma lyawa mu n 'ya̱wa̱ m pa'an a atsusa hali a cina santawa nu ulivu. ");
INSERT INTO tsw_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","Na̱ dada va̱ wu lamba mu biti, reve vu damma, <Da̱wuda pati mu ta̱ lon n lyawa yi u jika̱ u 'ya̱wa̱ a̱ lyuci vu umatsun wa̱ yi Batalami, adama a na a fara ta̱ kucci va aa'wan vu umatsun wa̱ yi suru.> ");
INSERT INTO tsw_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","Nu u damma, <U lobono ta̱,> aagbashi a̱ wu a ta la'a. Amma nu u la̱nga̱ a̱tsuma̱ lon, vu te reve a na u cigai wu una mu. ");
INSERT INTO tsw_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","A̱vu gba shi, vu roco aagbashi a̱ wu icigi i na i tsu vadala shi, adama a na vu zuwa yi ta̱ u yuwain nzuwulai na̱ A̱sulazuva a̱ wu. Na̱ n yuwan ta̱ unusu, vu una mu na aciya̱wu! Nye i zuwai vaa ca mu ya dada va̱ wu adama wu una mu?>> ");
INSERT INTO tsw_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","Reve Jonata usu, <<A̱sulazuva aa para! She vu yuwan adanshi ne wan, na̱ n reve ta̱ ko ke'en a na dada va̱ cigai wu una wu, maa damma wu shi?>> ");
INSERT INTO tsw_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","Ɗaɗa Da̱wuda ecei Jonata, <<Zane ɗa a damma mu, na̱ dada va̱ wu usu wu nu upan?>> ");
INSERT INTO tsw_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","Reve Jonata damma Da̱wuda, <<Ta̱wa̱, lyawa tsu lapa a̱ tyo a atsusa.>> Ɗaɗa ele ra a̱ ka̱ra̱i. ");
INSERT INTO tsw_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","Reve Jonata damma Da̱wuda, <<N kucuna ta̱ na̱ A̱sulazuva A̱sula̱ a Isra'ila, na̱ mantsa ma nda nfa'an ko santawa n ta yuwan adanshi'i na̱ dada va̱. Nu u ta̱ ni ifoɓi i sa'ani a̱ tyo ya̱'a̱ wu, n ta̱ lyungu a damma wu. ");
INSERT INTO tsw_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","Amma na̱ dada va̱ ciga ta̱ na woo una wu, n ta̱ lyungu wa̱ wu adama a na va a la'a. Amma lyawa A̱sulazuva a ca mu a̱tsuma̱lima̱ lon na̱ n yuwan ne shi. Lyawa A̱sulazuva a̱ da̱na̱ oɓolo na̱ a̱vu cine u da̱na̱i na̱ dada va̱. ");
INSERT INTO tsw_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","Na̱ m buwa ta̱ wuma, vu roco mu icigi i na i tsu vadala shi tsa̱ A̱sulazuva. Amma mantsa ma na n kuwa̱i, ");
INSERT INTO tsw_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","she vu koɗo icigi i na i tsu vadala shi nu u'wa u va̱ wan hali hali, ko n na̱ A̱sulazuva o kototo n'yuwatan ma̱ wu Da̱wuda diga o uvaɗi.>> ");
INSERT INTO tsw_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","Reve Jonata yuwan nzuwulai nu u'wa wa̱ Da̱wuda, u damma, <<Lyawa A̱sulazuva a ca wu oforo n na̱ vu kuɗa̱ o shiton nzuwulai n na tsu yuwain.>> ");
INSERT INTO tsw_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","Adama e icigi i na Jonata a yuwusan Da̱wuda reve u zuwa yi u kucunisa, adama a na u ciga ta̱ Da̱wuda cine u cigai wuma wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","Ɗaɗa Jonata damma niyi, <<A̱yi ɗa nda nfa'an urana wa̱ a̱buki o woto u sa'avu a ɗa, waru e ene a̱ wu lo shi adama a na ootogu a̱ wu a̱ ta̱ da̱na̱ lya̱nga̱. ");
INSERT INTO tsw_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","Santawa a cina ulivu, a̱vu vu 'ya̱wa̱ uba̱ta̱ u na vu shi vu pa'ain a mantsa ma na addama a nda a farai, waru vi isawan pe zuzu nu uba̱ta̱ o oɓolo atali. ");
INSERT INTO tsw_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","Waru n ta̱ tewin iliya i ta'atsu a̱ nge'en ma̱ yi, she damma n te tewishin ili i ro. ");
INSERT INTO tsw_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","Waru n ta̱ lyungu ulobo u na tsa̱ ta̱wa̱i ra reve n damma yi, <'Ya̱wa̱ vu zami iliya i na n tewiyin.> Na̱ n damma yi, <Ka̱lyuwa̱, iliya i ta̱ lo a̱ nge'en nda ma̱ wu, ta̱wa̱ ne ele pa nda,> reve vu ta̱wa̱, vu la'a ta̱, adama a na n kucuna ta̱ na̱ A̱sulazuva a na a̱ ri wuma, babu addama o ro. ");
INSERT INTO tsw_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","Amma na̱ n damma ulobo'o, <Ka̱lyuwa̱, iliya'a a̱ ta̱ ɗe elime a̱ wu ke'en,> reve vu ka̱ra̱, adama a na A̱sulazuva a ciga wu ta̱ vu ka̱ra̱. ");
INSERT INTO tsw_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","Waru adama aɗa a na tsu yuwain a̱mu na̱ a̱vu, a̱yi ɗa nda A̱sulazuva a ɗa esu a̱ tsu a̱mu na̱ a̱ vu hali hali.>> ");
INSERT INTO tsw_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","Ɗaɗa Da̱wuda pa'ain a atsusa. Ana urana wa̱ a̱buki o woto u sa'avu a rawai, reve Shawulu Mogono ma̱ da̱nu adama u lyuwa ilyalya. ");
INSERT INTO tsw_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","Reve mogono ma̱ da̱nu uba̱ta̱ u na u tsu da̱nusu nu uɓaɓu, a̱ nka̱la̱la̱i na̱ Jonata, reve Abna da̱nu o tono Shawulu, amma uba̱ta̱ wa̱ Da̱wuda u da̱na̱ ta̱ lya̱nga̱. ");
INSERT INTO tsw_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","Shawulu damma ili i ro shi o urana u ndolo, adama a na u ta̱ majiyan, <<Ili i ro i cina ta̱ Da̱wuda a na u ka̱mbuwa̱ niyi za vi idaba, amayun za vi idaba ɗa.>> ");
INSERT INTO tsw_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","O urana we ire, wu urana u na u toni yi u urana wa̱ a̱buki o woto u sa'avu, uba̱ta̱ wa̱ Da̱wuda u da̱nisa̱ ta̱ lya̱nga̱. Reve Shawulu ece ulobo wa̱ yi Jonata, <<Nye i zuwai ulobo wa̱ Yese u ta̱wa̱i uba̱ta̱ wa alya e ilyalya yon na ana'an shi?>> ");
INSERT INTO tsw_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","Reve Jonata usu Shawulu, <<Da̱wuda pati mu ta̱ lon n lyawa yi u 'ya̱wa̱ Batalami. ");
INSERT INTO tsw_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","U damma ta̱, <Lyawa mu n ka̱ra̱, adama a na umatsun u tsu u ta casu kucci a̱ lyuci, waru zakpara va̱ damma mu ta̱ n da̱na̱ ɗe. Na̱ n tsura̱ isa'ani e ekere a̱ wu, vu lyawa mu n 'ya̱wa̱ me ene a̱za̱ va̱.> Adama a adanshi a nda ɗa u ta̱wa̱i a alya ilyalya oɓolo na̱ mogono shi.>> ");
INSERT INTO tsw_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","Reve Shawulu yuwan upan na̱ Jonata lon, a̱vu u damma yi, <<A̱vu mawun me pere na aciyogbamu u ɗa tsa mma va̱ wu! N reve ta̱ vu ta a kambusa ulobo wa̱ Yese, adama vu ca aciya̱wu wono na̱ mma na matsan nu wu. ");
INSERT INTO tsw_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","Nna̱ ulobo wa̱ Yese u ta̱ wuma o uvaɗi, wa lyawa tsugono tsa̱ wu tsa lyuwa elime a̱tsuma̱ e iɗa i nda shi. Gogo lyungu a̱ ta̱wa̱a̱ mu na̱ a̱yi, adama a na na a ciga a 'yuwan mu unai!>> ");
INSERT INTO tsw_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","Reve Jonata usu dada va̱ yi Shawulu, <<Nye i zuwai oo una yi? Nye i ɗa u yuwain?>> ");
INSERT INTO tsw_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","Reve Shawulu sari ibata ya̱ yi adama wu una yi. Ɗaɗa Jonata revei dada va̱ yi ciga ta̱ a na woo una Da̱wuda. ");
INSERT INTO tsw_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","Reve Jonata 'yon nu upan lon diga a apada agba u lyuwa ilyalya o urana we ire, wu urana u na u toni u urana wa̱ a̱buki'i o woto u sa'avu shi, adama a na u ta̱ na̱ a̱tsumola̱ngu cine dada va̱ yi yuwain na̱ Da̱wuda a̱tsuma̱ o ulambu u wono. ");
INSERT INTO tsw_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","Nu usana a̱vu Jonata 'ya̱wa̱ a atsusa uba̱ta̱ u na aa zuwai a na a ga'asan na̱ Da̱wuda. U da̱na̱ ta̱ na̱ molobo oɓolo na̱ a̱yi. ");
INSERT INTO tsw_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","Reve u damma molobo'o, <<Suma vu zami iliya i na me tewin.>> Ana molobo'o u sumai, a̱vu u tewin liya elime a̱ yi ke'en. ");
INSERT INTO tsw_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","Ana molobo'o u rawai uba̱ta̱ wu liya n na Jonata teweyin, a̱vu Jonata ɗe yi reve u damma, <<Liya'a wu ɗe elime a̱ wu ke'en shi?>> ");
INSERT INTO tsw_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","Reve Jonata ɗe molobo'o, <<Jika̱! 'Ya̱wa̱ gogogo! She vi isawan wan!>> Ɗaɗa molobo'o u tarai liya'a a̱vu u ka̱mba̱ uba̱ta̱ wu zagbain va̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","Amma molobo'o u reve ko nye i ɗa suru ili i nda'a shi, Jonata na̱ Da̱wuda ɗa goon revei. ");
INSERT INTO tsw_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","A̱vu Jonata ca molobo'o utan ni iliya ya̱ yi, a̱vu u damma yi, <<Wala, tara le a̱ tyo a̱ lyuci.>> ");
INSERT INTO tsw_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","Mantsa ma na molobo'o u ka̱ra̱i, a̱vu Da̱wuda 'yon diga upasu wu uyagi uba̱ta̱ wo o oɓolo atali'i, reve u kingyo u ka̱ɗa̱to urewesu wa̱ yi e iɗa a̱ ma̱ka̱ka̱n ma Jonata toto uta'atsu. A̱vu a katalalai ra reve a̱ shon, amma Da̱wuda la'a ta̱ shon. ");
INSERT INTO tsw_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","Reve Jonata damma Da̱wuda, <<Ka̱ra̱ na asuvu nden, adama a na tsu yuwan ta̱ akucunu a̱ n'utsa̱ na ala a̱ A̱sulazuva, tsu damma, <A̱sulazuva a ɗa esu a̱ va̱ na̱ a̱vu, waru esu a limatan va̱ wu na a limatan va̱ hali hali.> >> Reve Da̱wuda 'yon u ka̱ra̱, a̱vu Jonata ka̱ra̱ a̱ ka̱mba̱ a̱ lyuci. ");
INSERT INTO tsw_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Da̱wuda ka̱ra̱ ta̱ a̱ tyo Nob, uba̱ta̱ wa Ahimele ganu. A̱vu Ahimele ta̱wa̱ u ga'asan na̱ Da̱wuda e meje'en a̱vu we ece yi, <<Nye i zuwai vu ta̱wa̱i a̱ nde'en goon?>> ");
INSERT INTO tsw_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","Reve Da̱wuda usu Ahimele ganu, <<Mogono ma ɗa ma̱ lyungu numu na aɗa o ro waru u damma mu ta̱, <She vu lyawa za reve ili i ro adama aɗa a na n lyungu nuwu wan, waru ni ili i na n damma nuwu wan.> Waru ali o uvon a̱ va̱, n damma le ta̱ uba̱ta̱ u na tsu zuwulai a na a ga'asan na̱ a̱mu. ");
INSERT INTO tsw_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Gogo, ilyalya i ne i ɗa vu ri na̱ a̱yi? Ca mu akpatali o opopofu ozo o ton, ko ili i ro i na vu ri na̱ a̱yi suru.>> ");
INSERT INTO tsw_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Reve ganu usu Da̱wuda, <<N ri pa no opopofu a ndana o ukere u va̱ shi, amma opopofu a akiza a ɗa a̱ ri pa, vu ta gura tama na ali o uvon a̱ wu a na asai na̱ a̱ma̱ci yon shi.>> ");
INSERT INTO tsw_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","Reve Da̱wuda usu ganu, <<Amayun a kasa tsu ta̱ na̱ a̱ma̱ci cine a tsu yuwusan nu ufaru suru mantsa ma na n 'ya̱wa̱i mmalu na ali o uvon a̱ va̱. Lipu va ali a̱ va̱ a aza a akiza a ɗa ko na̱ shi gba n mmalu ma ndana n ɗa. Te gba ana'an a na tsu uta̱i mmalu ma akiza!>> ");
INSERT INTO tsw_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Ɗaɗa ganu ca niyi opopofu a akiza adama a na babu lo opopofu o ro ko'o, she za na a tawai na ri a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva, a̱vu a kita'wan na̱ za vu usuɗuwu o urana u na a tawa niyi. ");
INSERT INTO tsw_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","Waru o urana u ndolo aagbashi a Shawulu o ro da̱na̱ ta̱ lo, adama a na u ta̱ ni ili i na waa yuwan a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. Ala a̱ yi a ɗa Dowe vuma va Edom, zagbain va aza a aguɓa a Shawulu. ");
INSERT INTO tsw_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","Reve Da̱wuda ece Ahimele, <<Vu ri ni ibata ko matsun me pe'eni mo ro pa shi? Adama a na n ta̱wa̱ na̱ matsun me pe'eni ma̱ va̱ ko itana yu uvon i ro shi, adama a na udammu u mogono u ta̱wa̱ mu ta̱ uragazu.>> ");
INSERT INTO tsw_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","Reve ganu usu yi, <<Matsun me pe'eni ma Goliya vuma va Filistiya, na vu unai o uka̱ri wa Ela, u ta̱ pa u tu ukatalu na aakashi o cina̱ wa̱ epo. Na̱ vu ciga yi vu tara, matsun me pe'eni mo ro ma pa shi she a̱yi.>> A̱vu Da̱wuda damma, <<Babu za ro tsa̱ yi, ca mu a̱yi.>> ");
INSERT INTO tsw_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","A̱vu Da̱wuda 'yon u sumaa Shawulu o urana u ndolo, a̱vu u ka̱ra̱ a̱ tyo ya Akish mogono ma Gat e iɗa ya Filistiya. ");
INSERT INTO tsw_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","A̱vu agbashi a Akish a damma yi, <<A̱yi nda a̱yi ɗaɗa Da̱wuda'a mogono me iɗa'a? A̱yi nda a̱ yi ɗa vuma'a na amayun na a canaa yi ishipa nu uje'en, a̱vu a cana, <Shawulu una ta̱ kpaku kupa va̱ yi, waru Da̱wuda una ta̱ ukpakukupa kupa va̱ yi va̱ a̱bunda̱.> >> ");
INSERT INTO tsw_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","A̱vu Da̱wuda zuwa adanshi'i o okolo a̱vu u ka̱ra̱ a uwwusa wovon wa Akish mogono ma Gat lon. ");
INSERT INTO tsw_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","Reve u vadala ugbozu wa̱ yi a yuwusan ili iwa̱u a̱ ma̱ka̱ka̱n me le, waru suru mantsa ma na a̱ ri u uguzu na̱ yi, reve u yuwan she damma u ri nu ugbozu wa̱ yi shi, u reme yironishi a̱ na̱ntsu vu u'uwata u lyuci waru ma̱tsa̱n a̱ ma̱la̱la̱ a̱ ntsuka̱ ma̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","Ɗaɗa Akish dammai agbashi a̱ yi, <<Ka̱lyuwa̱i vuma'a aajarata a ɗa! Nye i zuwai i ta̱wa̱a̱ numu na̱ a̱yi? ");
INSERT INTO tsw_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","N lamba ta̱ ajarata a na i ta̱wa̱a̱ numu na̱ cu'un vuma nda, u yuwusaan mu tsulo a̱ ma̱ka̱ka̱n ma̱ va̱? N cigai u ta̱wa̱ o u'wa u va̱ shi!>> ");
INSERT INTO tsw_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","Da̱wuda lyawa ta̱ Gat a̱vu u suma a̱ tyo a̱ a̱a̱ba̱nu a Adulam. Ana a̱za̱ a̱ yi nu u'wa wa dada va̱ yi a uwwai ne suru, reve a lapa a̱ cipa̱ pe ya̱'a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","Waru aza a na a̱ ri a̱tsuma̱lima̱ suru na aza a na o tono utan, na aza a na a̱ ri na adanshi o okolo, a̱vu oɓoloto uba̱ta̱ wa̱ yi, a̱vu wo o'wo zagbain le. Waru ama a na a̱ da̱na̱i oɓolo na̱ a̱yi a ta rawa ukpakuna̱shi (400). ");
INSERT INTO tsw_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","Waru diga lo a̱vu Da̱wuda ka̱ra̱ a̱ tyo Mizfa a̱tsuma̱ a̱ Mowa a̱vu u damma mogono ma̱ Mowa, <<Vu ta yuwan ankuri vu lyawa dada va̱ na̱ mma va̱ a̱ ta̱wa̱ a̱ da̱nu oɓolo na̱ a̱vu hali she na̱ me ene ili i na A̱sula̱ aa yuwaan mu?>> ");
INSERT INTO tsw_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","Ɗaɗa u lyawa nle oɓolo na̱ mogono ma̱ Mowa, reve a̱ da̱nu oɓolo na̱ a̱yi mantsa ma na suru Da̱wuda yuwain o upa'atan a masasan. ");
INSERT INTO tsw_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","Amma Gadu vumava̱sula̱ damma ta̱ Da̱wuda, <<She vu da̱nu pe o upa'ata'an wan. Ka̱ra̱ a̱ tyo e iɗa ya Yahuda.>> Ɗaɗa Da̱wuda ka̱ra̱i a̱ tyo a̱ a̱a̱rumbu a Heret. ");
INSERT INTO tsw_vpl VALUES ("S122_6","010_22_6","1SA","22","6","6","Shawulu uwwa ta̱ a na ene ta̱ Da̱wuda, oɓolo na ama a na a̱ ri oɓolo na̱ a̱yi. Shawulu da̱na̱ ta̱ nden ɗe Gibiya e ikyun yu uɗanga u na a̱ tsu ɗe tamari zuva va aagaɗi uɓa̱nu ni ibata ya̱ yi o ukere, waru azagbain a̱ yi suru a̱ da̱na̱ ta̱ mishin u ka̱nda̱ruwu na̱ a̱yi. ");
INSERT INTO tsw_vpl VALUES ("S122_7","010_22_7","1SA","22","7","7","A̱vu Shawulu damma agbashi a̱ yi, <<Poloi atsuvu, ama a Banyami! Ulobo wa̱ Yese u ta ca ɗu atsusa oɓolo na̱ a̱ɗuma̱ a̱ ina̱bi suru? U ta zuwa ɗu yo o'wo yali vu ukpakukupa ko yali vu ukpaku ukpaku? ");
INSERT INTO tsw_vpl VALUES ("S122_8","010_22_8","1SA","22","8","8","A̱yi ɗa i zuwai yoo foɓuso iwuya a aciya̱va̱ suru? Babu za na damma numu a na ulobo u va̱ u yuwan ta̱ nzuwulai nu ulobo wa̱ Yese. Ko za a̱tsuma̱ a̱ ɗu a yuwusan aɗa a̱ va̱ shi, ko u damma mu a na ulobo u va̱ u zuwai aagbashi a̱ va̱ adama u vawan mu, cine u yuwain ana'an shi.>> ");
INSERT INTO tsw_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","Reve Dowe vuma va Edom, za na da̱na̱i lo mishin oɓolo na azagbain a Shawulu u usu, <<Me ene ta̱ ulobo wa̱ Yese a̱ ta̱wa̱ Nob, uba̱ta̱ wa Ahimele ulobo wa Ahitu. ");
INSERT INTO tsw_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","Ahimele ece yi ta̱ A̱sulazuva waru u ca yi ta̱ ilyalya na̱ matsun me pe'eni ma Goliya vuma va Filistiya.>> ");
INSERT INTO tsw_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","Ɗaɗa mogono ma̱ lyunguyi a̱ ta̱wa̱a̱ yi na̱ Ahimele ganu, ulobo wa Ahitu nu u'wa wa dada va̱ yi suru, aza a na da̱na̱i nan ganu a Nob, a̱vu suru a̱ ta̱wa̱ uba̱ta̱ u mogono. ");
INSERT INTO tsw_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","A̱vu Shawulu damma, <<Polo atsuvu, ulobo wa Ahitu.>> A̱vu u usu, <<Mpa mu nda zagbain va̱.>> ");
INSERT INTO tsw_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","Reve Shawulu damma yi, <<Nye i zuwai i foɓoi iwuya adama a̱ va̱? A̱vu nu ulobo wa̱ Yese, vu ca niyi opopofu na̱ matsun me pe'eni, waru vu patiya niyi A̱sula̱, adama u yuwan nla̱ngi na̱ a̱mu, waru u vawan mu, cine u yuwain ana'an!>> ");
INSERT INTO tsw_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","Reve Ahimele usu mogono'o, <<Zane ɗa a̱tsuma̱ a agbashi a̱ wu ri na̱ a̱ɓula̱ tsa̱ Da̱wuda, toto mogono, yali ya̱ a̱za̱ e ipiri ya̱ a̱ wu suru, za na aa casu tsugbain o u'wa wa̱ wu suru? ");
INSERT INTO tsw_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","Na amayun n patiya yi ta̱ A̱sula̱, agba a̱ yi nda a̱ yi ɗa mu ufaru shi. Amma n ta̱ e pati ya̱ wu she vu ca mu unusu ko vu tawaa za ro a̱tsuma̱ o u'wa wa dada va̱ wan. Adama a na n reve na aɗa a nda shi!>> ");
INSERT INTO tsw_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","Reve mogono ma damma, <<Vu ciga vu 'yuwan o una wu, Ahimele, a̱vu nu u'wa wa dada va̱ wu suru.>> ");
INSERT INTO tsw_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","A̱vu mogono ma damma a̱za̱ e ipiri ya̱ yi a na a̱ ri mishin u ka̱nda̱ruwu na̱ a̱yi, <<Vadalai yu una nan ganu va̱ A̱sulazuva, adama a na ele fo o ɓolo ta̱ aci na̱ Da̱wuda. E reve ta̱ ni ilaɗi ya̱ yi agba a damma mu shi.>> Amma a̱soja o mogono'o a ciga a̱ 'ya̱sa̱n ukere u le o una nan ganu va̱ A̱sulazuva'a shi. ");
INSERT INTO tsw_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","Reve mogono ma damma Dowe, <<A̱vu vadaluwa vu una nan ganu.>> Ɗaɗa Dowe vuma va Edom vadaluwai wu una nle. O urana u ndolo wu una ta̱ ama kupakunla̱ no ozo o ton aza a na a̱ da̱na̱i wotowu na̱ mutugu ma̱ epo vo okoro. ");
INSERT INTO tsw_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","Waru wu una ta̱ fo a̱za̱ a̱ lyuci va Nob na̱ matsun me pe'eni, lyuci nan ganu, na ali e le na̱ a̱ma̱ci na̱ muwun na̱ nreɓu, ni inan na̱ nloli ni ikyon. ");
INSERT INTO tsw_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","Amma a̱tsuma̱ olobo a Ahimele ulobo wa Ahitu za na a̱ tsu ɗe Abiyata, u la'a ta̱, a̱vu u suma u kuru Da̱wuda. ");
INSERT INTO tsw_vpl VALUES ("S122_21","010_22_21","1SA","22","21","21","A̱vu u damma Da̱wuda, Shawulu una ta̱ nan ganu a̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("S122_22","010_22_22","1SA","22","22","22","Ɗaɗa Da̱wuda dammai Abiyata, <<Urana u ndolo a na Dowe vuma va Edom da̱na̱i lo, n reve ta̱ na amayun a na waa damma Shawulu. Adama a̱ va̱ a ɗa o unai u'wa wa dada va̱ wu suru. ");
INSERT INTO tsw_vpl VALUES ("S122_23","010_22_23","1SA","22","23","23","Isawan oɓolo na̱ a̱mu, she vu uwwa wovon wan, adama a na za na a zamishi wuma wa̱ wu u ta zami shi fo za va̱. Vu ta̱ da̱na̱ gbaga oɓolo na̱ a̱mu.>> ");
INSERT INTO tsw_vpl VALUES ("S123_1","010_23_1","1SA","23","1","1","Ana a dammai Da̱wuda, <<A̱yi ɗa nda aza a Filistiya a ta yuwusan uvon na aza a Kayila a̱tsuma̱ e iɗa ya Yahuda, waru a̱ ta̱ purusa̱ le ishina o osoroto,>> ");
INSERT INTO tsw_vpl VALUES ("S123_2","010_23_2","1SA","23","2","2","a̱vu Da̱wuda pati ya̱ A̱sulazuva, u damma, <<N 'ya̱wa̱ n riya̱a̱ aza a Filistiya nu uvon?>> A̱vu A̱sulazuva a damma yi, <<'Ya̱wa̱ vu riya̱a̱ le tsura̱ vu wawa aza a Kayila.>> ");
INSERT INTO tsw_vpl VALUES ("S123_3","010_23_3","1SA","23","3","3","Amma a̱vu ama a̱ Da̱wuda a damma yi, <<Ka̱lyuwa̱, a̱yi ɗa nda pa a̱tsuma̱ a Yahuda tsu ta uwwusa wovon. Cine tsa ɗa wo o'wo na̱ tsu 'ya̱wa̱ Kayila tsu riya̱a̱ aza a Filistiya nu uvon?>> ");
INSERT INTO tsw_vpl VALUES ("S123_4","010_23_4","1SA","23","4","4","A̱vu Da̱wuda da̱shi pati ya̱ A̱sulazuva, a̱vu A̱sulazuva a̱ usu yi, <<Lapa a̱ cipa̱ Kayila, adama a na n ta ca aza a Filistiya e ekere a̱ wu.>> ");
INSERT INTO tsw_vpl VALUES ("S123_5","010_23_5","1SA","23","5","5","Ɗaɗa Da̱wuda na̱ ama a̱ yi a̱ ka̱ra̱i a̱ tyo Kayila, a̱vu a yuwan uvon na aza a Filistiya, waru o una le ta̱ na̱ a̱bunda̱ wa'a shi. A̱vu a̱ pura̱ iliyamunga i le. Reve u wawa ama a Kayila. ");
INSERT INTO tsw_vpl VALUES ("S123_6","010_23_6","1SA","23","6","6","Waru a mantsa ma na Abiyata ulobo wa Ahimele sumai a̱ tyo ya̱ Da̱wuda'a ɗe Kayila, u ta̱wa̱ ta̱ na̱ epo o ukere wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S123_7","010_23_7","1SA","23","7","7","A damma ta̱ Shawulu a na Da̱wuda ta̱ ɗe Kayila, a̱vu Shawulu damma, <<A̱sula̱ a ta ca yi e ekere a̱ va̱, adama a na u ɓa̱ru ta̱ aciya̱yi, a na wo'woi uwa ta̱ a̱ lyuci na ri na̱ na̱ntsu na a̱ɓa̱ru yi na̱ aɗanga e rumu.>> ");
INSERT INTO tsw_vpl VALUES ("S123_8","010_23_8","1SA","23","8","8","A̱vu Shawulu ɗe a̱soja a̱ yi suru a lapa a̱ cipa̱ a̱ tyo Kayila, adama a̱ ka̱nda̱ruwa̱ Da̱wuda na̱ ama a̱ yi nu uvon. ");
INSERT INTO tsw_vpl VALUES ("S123_9","010_23_9","1SA","23","9","9","Ana Da̱wuda uwwai Shawulu ta yuwusan ifoɓi i na wa̱ ta̱wa̱ yi nu uvon, a̱vu u damma Abiyata ganu, <<Ta̱wa̱ na̱ epo.>> ");
INSERT INTO tsw_vpl VALUES ("S123_10","010_23_10","1SA","23","10","10","Reve Da̱wuda yuwan avasa u damma, <<A̱sulazuva A̱sula̱ a Isra'ila, aagbashi a̱ wu a uwwa ta̱ a na na amayun Shawulu ta zama u ta̱wa̱ Kayila, tsa̱ra̱ u kototo lyuci adama a̱ va̱. ");
INSERT INTO tsw_vpl VALUES ("S123_11","010_23_11","1SA","23","11","11","Amma Shawulu ta̱ zura̱ a̱ tyo Kayila cine aagbashi a̱ wu uwwai? Waru azagbain a Kayila a ta reme mu reve a ca mu ekere a̱yi? A̱sulazuva A̱sula̱ a Isra'ila, n te e ipati ya̱ wu vu damma aagbashi a̱ wu.>> Reve A̱sulazuva a damma, <<U ta̱ ta̱wa̱.>> ");
INSERT INTO tsw_vpl VALUES ("S123_12","010_23_12","1SA","23","12","12","Reve Da̱wuda yuwisan yeci, <<Azagbain a Kayila a ta ca mu na̱ ama a̱ va̱ a̱ tyo e ekere a Shawulu?>> A̱vu A̱sulazuva a̱ usu, <<A ta ca ɗu.>> ");
INSERT INTO tsw_vpl VALUES ("S123_13","010_23_13","1SA","23","13","13","Ɗaɗa Da̱wuda na̱ ama a̱ yi ele ama ukpakuta̱li (600), a̱ 'yon yi a lyawai Kayila, a̱vu a̱ ka̱ra̱ a̱ tyo uba̱ta̱ u na aa gura 'ya̱wa̱ suru adama e reme le wan. Ana a dammai Shawulu Da̱wuda suma ta̱ diga Kayila, a̱vu u bula̱ mmalu a̱ 'ya̱wa̱ ɗe. ");
INSERT INTO tsw_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","A̱vu Da̱wuda isawan pe uba̱ta̱ o upa'atan a̱tsumona, ne e iɗa ya agaɗi wa̱ A̱tsumona a Zif. Waru Shawulu zamishi yi ta̱ urana suru, amma A̱sula̱ a ca Da̱wuda e ekere a̱ yi shi. ");
INSERT INTO tsw_vpl VALUES ("S123_15","010_23_15","1SA","23","15","15","Ana Da̱wuda da̱na̱i Horesh a̱tsuma̱ A̱tsumona a Zif, reve wu uwwa Shawulu ta̱wa̱ ta̱ uba̱ta̱'a̱ izami ya̱ yi adama wu una yi. ");
INSERT INTO tsw_vpl VALUES ("S123_16","010_23_16","1SA","23","16","16","Reve Jonata ulobo wa Shawulu u 'ya̱wa̱ uba̱ta̱ wa̱ Da̱wuda ɗe Horesh, a̱vu u ca yi adanshi wi isawan no okolo a̱ yi uba̱ta̱ wa̱ a̱ A̱sula̱ ulobonu. ");
INSERT INTO tsw_vpl VALUES ("S123_17","010_23_17","1SA","23","17","17","A̱vu u damma yi, <<She vu uwwa wovon wan, ukere wa dada va̱ Shawulu wa̱a̱ ju'wa̱n wu shi. Vu to o'wo mogono a aci a aza a Isra'ila suru a̱mu gba n to o'wo dodu va̱ wu. Ko Shawulu dada va̱ reve ta̱ ne.>> ");
INSERT INTO tsw_vpl VALUES ("S123_18","010_23_18","1SA","23","18","18","A̱vu ele ra a yuwan nzuwulai a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. Reve Jonata ka̱mba̱ o u'wa, a̱vu Da̱wuda isawan pe Horesh. ");
INSERT INTO tsw_vpl VALUES ("S123_19","010_23_19","1SA","23","19","19","Ɗaɗa aza a Zif a̱ 'ya̱wa̱i uba̱ta̱ wa Shawulu ɗe Gibiya a̱vu a damma, <<Da̱wuda ta̱ pe a̱tsuma̱ a̱ tsu uba̱ta̱ o upa'atan ɗe Horesh zuva va aagaɗi a Hakila upasu wu uyagi wa Jeshimon. ");
INSERT INTO tsw_vpl VALUES ("S123_20","010_23_20","1SA","23","20","20","Gogo, mogono, she vu ta̱wa̱ mantsa ma na u lobono nuwu vu yuwan ne, waru tsu ta tara ume adama tsu ca yi e ekere a̱ wu.>> ");
INSERT INTO tsw_vpl VALUES ("S123_21","010_23_21","1SA","23","21","21","Reve Shawulu damma, <<A̱sulazuva a zuwaa ɗu aba'un, adama a na i roco mu ta̱ isa'ani. ");
INSERT INTO tsw_vpl VALUES ("S123_22","010_23_22","1SA","23","22","22","'Ya̱wa̱yi i yuwisan ifoɓi i ro. I gura reve uba̱ta̱ u na Da̱wuda tsu 'ya̱wusa̱ na za na ene niyi ɗe. Adama a na a damma mu ta̱ u tu nu ugbozu lon. ");
INSERT INTO tsw_vpl VALUES ("S123_23","010_23_23","1SA","23","23","23","I gura reve ba̱ta̱ na waa pa'asan suru reve i ka̱mba̱ i damma mu urevu wa amayun. Reve tsu gereyi. Na̱ u ta̱ lo upasu'u, n ta̱ bunga̱ yi ko te ɗa u ri, a̱tsuma̱ o umatsun wa a aza a Yahuda suru.>> ");
INSERT INTO tsw_vpl VALUES ("S123_24","010_23_24","1SA","23","24","24","A̱vu a̱ 'yon a̱ ka̱ra̱ a̱ tyo Zif babu Shawulu rawa. Da̱wuda gba na̱ ama a̱ yi a̱ da̱na̱ ta̱ A̱tsumona a̱ Mawon, upasu wu uyagi wa̱ Jeshimon a̱tsuma̱ o Uka̱ri wa Araba. ");
INSERT INTO tsw_vpl VALUES ("S123_25","010_23_25","1SA","23","25","25","A̱vu Shawulu na ali o uvon a̱ yi a̱ 'ya̱wa̱ izami ya̱ yi, reve a damma Da̱wuda, ɗaɗa u ka̱ra̱i a̱ cipa̱ tyo a aatali a gbain o ro a̱vu wi isawan A̱tsumona a̱ Mawon. Ana Shawulu uwwai ne, a̱vu u lapa a̱ tyo a̱tsumona a̱ Mawon izami ya̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S123_26","010_23_26","1SA","23","26","26","Shawulu kuru ta̱ upasu u ta̱ wa a aatali a gbai'in Da̱wuda waru na ali o uvon a̱ yi o upasu we ire, a̱vu nan Da̱wuda a̱ jika̱ adama a la'a ya Shawulu. Ana Shawulu na ali o uvon a̱ yi a̱ da̱na̱i a rawusa zuzu na̱ le adama e reme le, ");
INSERT INTO tsw_vpl VALUES ("S123_27","010_23_27","1SA","23","27","27","a̱vu malingata ma̱ ta̱wa̱ ya Shawulu u damma, <<Jika̱ vu ta̱wa̱, adama a na aza a Filistiya a̱ riya̱a̱ ta̱ iɗa i tsu nu uvon!>> ");
INSERT INTO tsw_vpl VALUES ("S123_28","010_23_28","1SA","23","28","28","Ɗaɗa Shawulu lyawai izami ya̱ Da̱wuda a̱vu u 'ya̱wa̱ u riya̱a̱ aza a Filistiya nu uvon. Adama a ndolo a ɗa e ɗeyi uba̱ta̱'a̱ Aatali a Mala'a. ");
INSERT INTO tsw_vpl VALUES ("S123_29","010_23_29","1SA","23","29","29","A̱vu Da̱wuda lapa a gawan diga lo, a̱vu u da̱nu uba̱ta̱ o upa'atan A̱tsumona a En Gedi. ");
INSERT INTO tsw_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","Ana Shawulu ka̱mba̱i diga uba̱ta̱ e itoni ya aza a Filistiya, a̱vu a damma yi, <<Da̱wuda ta̱ ɗe A̱tsumona a En Gedi.>> ");
INSERT INTO tsw_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","Ɗaɗa Shawulu ɗangulai ama ukpakukupa uta'atsu (3,000) a̱tsuma̱ a Isra'ila suru, a̱vu o uta̱ izami ya̱ Da̱wuda na ama a̱ yi zuzu na̱ Aatali a̱ Mgbele n Masasan mu Una. ");
INSERT INTO tsw_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","Ana u rawai uba̱ta̱ u na a̱ gutsu su mgbele a̱ nge'en mu ure, uba̱ta̱ u na a̱a̱ba̱nu a̱ ri, a̱vu Shawulu ɓatsa adama u yuwan rulu. Da̱wuda na ali a̱ yi, a̱ shi ta̱ pe alanga pe a̱ba̱nu'u. ");
INSERT INTO tsw_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","A̱vu ama a̱ yi a damma, <<A̱yi nda a̱yi ɗa urana u na A̱sulazuva a damma nuwu, <Ka̱lyuwa̱, n ta ca ma'yuwatan ma̱ wu e ekere a̱ wu, adama vu yuwan na̱ a̱yi cine vu cigai.> >> Reve Da̱wuda 'yon u puta̱ yi, a̱vu u koɗo iwa̱sa̱ ye elentsu yu utugu wa Shawulu babu a̱yi urevu. ");
INSERT INTO tsw_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","Na̱ a̱ca̱pa̱ a̱vu Da̱wuda dama na̱ cine u koɗo niyi iwa̱sa̱ ye elentsu yu utugu'u. ");
INSERT INTO tsw_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","A̱vu u damma ama a̱ yi, <<A̱sulazuva a para mu n yuwan na̱ zagbain va̱ ili ya nda, za na A̱sulazuva a tawai, ko n 'ya̱sa̱n ukere u va̱ n ju'wa̱in yi, adama a na a̱yi ɗa A̱sulazuva a̱ tsuwa̱n yi mani'in.>> ");
INSERT INTO tsw_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","Na adanshi a nda a ɗa Da̱wuda ɓarai ama a̱ yi, waru u lyawa le o una Shawulu shi. A̱vu Shawulu lyawa a̱a̱ba̱nu'u u reme mmalu ma̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","Na̱ a̱ca̱pa̱ a̱vu Da̱wuda uta̱ diga a̱ a̱a̱ba̱nu'u, reve u ɗe Shawulu, <<Zagbain va̱ mogono!>> Ana Shawulu vadalai, a̱vu Da̱wuda kingyo u ka̱ɗa̱to urewesu wa̱ yi e iɗa. ");
INSERT INTO tsw_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","A̱vu Da̱wuda damma yi, <<Nye i zuwai va uwwusa adanshi a na ama a dammai, <A̱yi ɗa nda Da̱wuda ciga ta̱ waa amaton wu>? ");
INSERT INTO tsw_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","Ka̱lyuwa̱, ana'an nda ve ene ta̱ ne esu a̱ wu, cine A̱sulazuva a ca nuwu e ekere a̱ va̱ a̱tsuma̱ a̱ a̱a̱ba̱nu. A damma mu ta̱ mu una wu, amma n lyawa wu ta̱ wuma, n damma ta̱, <Ma̱a̱ 'ya̱sa̱n ukere u va̱ n ju'wa̱n zagbain va̱ shi, adama a na a̱ yi ɗa za na A̱sulazuva a̱ tsuwa̱yin mani'in.> ");
INSERT INTO tsw_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","Ka̱lyuwa̱, dada va̱, nda iwa̱sa̱ ya̱ elentsu o utugu wa̱ wu o ukere u va̱! Ko na wo o'woi n koɗoi iwa̱sa̱ ya̱ elentsu o utugu wa̱ wu agba mu una wu shi. Gogo vu jiyan waru vu reve a na n ri ni ifoɓi yu uwuyanu ko aciyogbamu a̱ tyo e ekere a̱ wu shi, n yuwaan wu unusu shi, amma vu ta zamishi mu adama vu una mu. ");
INSERT INTO tsw_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","Lyawa A̱sulazuva e ge'eto tsu ra. Waru lyawa A̱sulazuva a tsupaa mu iwuya i na vu yuwain a̱ tyo ya̱'a̱ va̱, amma ukere u va̱ wa̱a̱ ju'wa̱n wu shi. ");
INSERT INTO tsw_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","Cine udammu wu nkaya mu ufaru n dammai, <Iwuya i tsu uta̱ ta̱ uba̱ta̱ wa̱ a̱za̱ e iwuya.> Ne ɗa ukere u va̱ wa̱a̱ ju'wa̱n wu shi. ");
INSERT INTO tsw_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","<<A̱vu na vu ri mogono ma Isra'ila zane ɗa vu uta̱i uvon na̱ a̱yi? Zane ɗa vaa gbagbusa? A̱kwa̱kwa̱ a̱ musa̱n? Ko aakupa? ");
INSERT INTO tsw_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","Lyawa A̱sulazuva o o'wo za vu uge'etosu u tsu waru u kurato tsu. Lyawa wi idana mu, waru wi isawaan mu u roco a na n ri nu unusu shi, a̱vu u wawa mu e ekere a̱ wu.>> ");
INSERT INTO tsw_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","Ana Da̱wuda kotoi adansa ne, a̱vu Shawulu ece, <<Uɗyo wa̱ wu u ɗa nda'a, ulobo u va̱ Da̱wuda?>> Reve u shon na̱ yisali lon. ");
INSERT INTO tsw_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","Reve u damma, <<Vu la'a mu ta̱ a̱ɓula̱ adama a na vu ɓana mu ta̱ ulobonu, amma a̱mu n yuwaan wu ta̱ iwuya. ");
INSERT INTO tsw_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","Vu damma mu ta̱ gogo isa'ani i na vu yuwaan numu, A̱sulazuva a ca mu ta̱ e ekere a̱ wu, agba vu una mu shi. ");
INSERT INTO tsw_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","Na̱ vuma ene ma'yuwatan ma̱ yi u ta lyawa yi u ka̱ra̱ fa̱a̱n? Adama o ndolo lyawa A̱sulazuva a tsupaa wu ni isa'ani, adama e ili i na vu roco numu ana'an. ");
INSERT INTO tsw_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","N reve ta̱ na amayun vu to o'wo mogono, waru tsugono tsa Isra'ila tsa ta lyuwa elime o ukere wa̱ wu. ");
INSERT INTO tsw_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","Gogo kucinaa mu na̱ A̱sulazuva voo kototo limatan ta̱ va̱ a̱ca̱pa̱ va̱ shi, ko vu kimusa̱ ala a̱ va̱ diga o u'wa wa dada va̱ shi.>> ");
INSERT INTO tsw_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","A̱vu Da̱wuda kucinaa ne Shawulu. Reve Shawulu ka̱mba̱ o u'wa, amma Da̱wuda na̱ ama a̱ yi a̱ ka̱ra̱ ta̱ a̱ ka̱mba̱ o upa'ata'an. ");
INSERT INTO tsw_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","Ana a yuwain ne Sama'ila kuwa̱ ta̱, a̱vu aza a Isra'ila suru o ɓoloto a yuwan nde n wiruta̱ adama a̱ yi, reve a̱ ciɗo yi a̱tsuma̱ a̱ lyuci va̱ yi a Rama. Reve Da̱wuda ka̱ra̱ a̱cipa̱ a̱ tyo A̱tsumona a Faran. ");
INSERT INTO tsw_vpl VALUES ("S125_2","010_25_2","1SA","25","2","3","A yuwan ta̱ vuma ro diga a̱tsuma̱ a limatan va Keleb za na a̱ tsu ɗe Nabal, diga a̱ a̱tsuma̱ a̱ lyuci va Mawon, za na ri nu uba̱ta̱ zuzu na̱ lyuci va Kame. Za vu utsuru ɗa da̱na̱i lon, u ta̱ na̱ ni ikyon ukpakukupa uta'atsu (3,000) na̱ mgbele ukpakukupa (1,000). Ka va̱ yi Abigel da̱na̱ ta̱ ulobonu nu urevu, amma vuma ɗa na da̱na̱i na asuvu usuɗuwu ni iwuya. Waru Nabal da̱na̱ ta̱ apunusa ikyon ya̱ yi a̱tsuma̱ a Kame. ");
INSERT INTO tsw_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","Mantsa ma na Da̱wuda da̱na̱i a̱tsumona, wu uwwa ta̱ a na Nabal ta apunusa ikyon ya̱ a̱ yi, ");
INSERT INTO tsw_vpl VALUES ("S125_5","010_25_5","1SA","25","5","5","ɗaɗa u lyunguyi ali o uvon kupa a̱vu u damma le, <<'Ya̱wa̱i uba̱ta̱ wa Nabal ɗe Kame reve i ca̱sa̱ yi na aala a̱ va̱. ");
INSERT INTO tsw_vpl VALUES ("S125_6","010_25_6","1SA","25","6","6","I damma yi, <Wuma wa̱ wu ujima! Asuvu nden a̱ da̱na̱ oɓolo na̱ a̱vu, waru ɓolo nu u'wa wa̱ wu, waru asuvu nden a̱ da̱na̱ oɓolo ni ili i na vu ri na̱ yi suru! ");
INSERT INTO tsw_vpl VALUES ("S125_7","010_25_7","1SA","25","7","7","<< <Mu uwwa ta̱ mantsa me ipuna me ikyon ma ɗa. Mantsa ma na azaguɓa a̱ wu a̱ da̱na̱i oɓolo na̱ a̱tsu, tsu yuwaan le iwuya shi, waru suru mantsa ma na a̱ da̱na̱i ɗe Kame babu ili i le i na i puwa̱yin. ");
INSERT INTO tsw_vpl VALUES ("S125_8","010_25_8","1SA","25","8","8","Ece agbashi a̱ wu waru a ta damma wu. Adama o ndolo lyawa olobo a̱ va̱ a̱ tsura̱ isa'ani e esu a̱ wu, adama a na tsu rawa ta̱ urana wa̱ a̱buki. Vu yuwan ankuri vu ca a̱ tsu agbashi a̱ wu, nu ulobo wa̱ wu Da̱wuda, ilyalya i na va̱a̱ tsura̱a̱ a̱ tsu suru.> >> ");
INSERT INTO tsw_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","Ana olobo a̱ Da̱wuda a rawai, a̱vu a damma Nabal ili i nda suru na ala a̱ Da̱wuda, reve o puro u usuwu wa̱ a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","A̱vu Nabal usu le, <<Zane ɗa Da̱wuda nda'a? Zane ɗa ulobo wa̱ Yese nda? Agbashi na̱ a̱bunda̱ a suma ta̱ diga uba̱ta̱ wa azagbain e le a rana nda. ");
INSERT INTO tsw_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","Nye i zuwai maa tara opopofu a̱ va̱ na̱ mini, ni inama i na m paɗai adama a̱za̱ e ipuna i va̱, reve n ca ama a na o uta̱i diga uba̱ta̱ u na n revei shi?>> ");
INSERT INTO tsw_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","Ɗaɗa olobo a̱ Da̱wuda'a a vadalai a̱ ka̱mba̱. Ana a rawai a̱vu a damma yi ili ya nda suru. ");
INSERT INTO tsw_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","A̱vu Da̱wuda damma ama a̱ yi, <<Za suru wu nla̱ matsun me pe'eni ma̱ yi!>> Ɗaɗa a̱ nla̱i mutsun mu pe'eni n le, a̱vu Da̱wuda fo nla̱ matsun me pe'eni ma̱ yi. A̱vu ali ukpakuna̱shi (400) a̱ ka̱ra̱ oɓolo na̱ Da̱wuda, reve ali ukpakure (200) e isawan ipiri yi itana i le. ");
INSERT INTO tsw_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","A̱vu aagbashi a̱ ta̱ a Nabal a damma Abigel ka va Nabal, <<Da̱wuda lyungu ta̱ nlingata diga a̱tsumona a̱ ta̱wa̱ adama a na a̱ ca̱sa̱ zagbain tsu, amma a̱vu u gbarana le. ");
INSERT INTO tsw_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","A̱yi ɗa nda ama a nda a̱ da̱na̱ ta̱ na̱ a̱ɓula̱ e ekere a̱ tsu lon. A yuwaan tsu iwuya shi, mantsa ma na tsu da̱na̱i alyuna a atsusa zuzu ne ele, ko ili ta̱ i tsu i puwa̱n shi. ");
INSERT INTO tsw_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","Ayin nu urana o o'wo ta̱ ukari u na u gesheshe n tsu, mantsa ma na tsu uta̱i alyuna e mgbele i tsu zuzu ne ele. ");
INSERT INTO tsw_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","Gogo she vu yuwan majiyan ve ene ili i na va yuwan, adama a na addama a̱ shiton ta̱ zagbain tsu nu u'wa wa̱ yi suru. A̱yi vuma vama ɗa, na ko za aa gura yuwaan yi adanshi shi.>> ");
INSERT INTO tsw_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","Agba Abigel jika̱ ta̱, a̱vu u tara akpatali o opopofu ukpakure (200) na̱ tsa̱n vu kwan masayan ma̱ ina̱bi ejere, ni ikyon i ton i na a lapulai ɗe, na̱ ishina yu uzuwun u makundatsu ushin, na̱ ogbodolu o u'yewu ukpaku (100) u muwun n ina̱bi, na akala o u'yewu u muwun mu ubiri ukpakure (200), a̱vu u zuwa le o nloli. ");
INSERT INTO tsw_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","Reve u damma agbashi a̱ yi, <<Walai elime n ta̱ kuru ɗu.>> Agba u damma vali va̱ yi Nabal shi. ");
INSERT INTO tsw_vpl VALUES ("S125_20","010_25_20","1SA","25","20","20","A̱yi a mmalu zuva mololi, a na u rawai e ikyun i masasan, a̱vu we ne Da̱wuda na ama a̱ yi a̱ za̱luwusa̱ a̱ tyo ya̱'a̱ yi, reve u ga'an ne ele. ");
INSERT INTO tsw_vpl VALUES ("S125_21","010_25_21","1SA","25","21","21","Da̱wuda damma ta̱ ɗe, <<Ulinga we pere u ɗa n yuwain a na n pirishi yi itana i vuma nda Nabal a̱tsumona suru, adama she ili i ta̱ ya̱ yi i puwa̱n wan. A̱vu u tsupa mu ni iwuya o una̱ wi isa'ani. ");
INSERT INTO tsw_vpl VALUES ("S125_22","010_25_22","1SA","25","22","22","Lyawa A̱sulazuva a ca mu a̱tsuma̱lima̱ lon a̱mu Da̱wuda, na̱ lyawa vali ta̱ wuma kafu usana u tawa!>> ");
INSERT INTO tsw_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","Ana Abigel enei Da̱wuda a̱vu u jika̱ u cipa̱ o mololi a̱vu u kingyo u ka̱ɗa̱to urewesu wa̱ yi e iɗa a̱ ma̱ka̱ka̱n ma̱ a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","A̱vu u riya̱ a ana a̱ yi reve u damma, <<Zagbain va̱ lyawa unusu'u wo o'wo za va̱ goon, yuwan ankuri vu lyawa aagbashi a̱ wu a yuwan adanshi na̱ a̱vu, uwwa ili i na maa damma wu. ");
INSERT INTO tsw_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","Yuwan ankuri zagbain va̱ she poloo adanshi a vuma vama nda Nabal atsuvu wan. U ta̱ tsa aala a̱yi. Aala a̱ yi ulo u ɗa, waru tsulo tsa̱ ta̱ oɓolo na̱ a̱ yi. Amma adama a̱ va̱, aagbashi a̱ wu, me ene o olobo a na zagbain va̱ lyungu yi shi. ");
INSERT INTO tsw_vpl VALUES ("S125_26","010_25_26","1SA","25","26","26","<<Gogo zagbain va̱, n kucuna ta̱ na̱ A̱sulazuva a na a̱ ri wuma na̱ wuma wa̱ wu, a na wo o'woi A̱sulazuva a putsa nuwu na voo oco mpasa, ko vu tsupaa aciya̱wu ne ekere a̱ wu, lyawa n'yuwatan ma̱ wu na aza a na a zama a amaton wu zagbain va̱ o o'wo tsa Nabal. ");
INSERT INTO tsw_vpl VALUES ("S125_27","010_25_27","1SA","25","27","27","Waru lyawa une'e u nda, za na aagbashi a̱ wu a̱ ta̱wa̱yi zagbain va̱, a ca ama a na a̱ kuru nuwu. ");
INSERT INTO tsw_vpl VALUES ("S125_28","010_25_28","1SA","25","28","28","M pati wu ta̱ vu yuwaan aagbashi a̱ wu gafura n na̱ n yuwaan ta̱ unusu biti, adama a na A̱sulazuva a ta zuwa u'wa wa̱ wu u shuwa̱ na amayun hali hali, adama a na zagbain va̱ ta yuwusan nla̱ngi mu uvon wa̱ A̱sulazuva, waru a̱a̱ tsura̱ iwuya ya̱'a̱ wu shi, suru a mantsa ma wuma ma̱ wu. ");
INSERT INTO tsw_vpl VALUES ("S125_29","010_25_29","1SA","25","29","29","Ko na wo o'woi za ro ta gbagbusa wu e izami i wuma wa̱ wu adama wu una wu, wuma wu zagbain va̱ ta̱ da̱na̱ gbaga ukatalu a̱tsuma̱ o oɓolo a aza a wuma a̱ A̱sulazuva A̱sula̱ a̱ wu. Amma wuma wu n'yuwatan ma̱ wu a̱ ta̱ vuta̱la̱ le cine a̱ tsu vuta̱la̱ aatali a̱ a̱bitsutsu. ");
INSERT INTO tsw_vpl VALUES ("S125_30","010_25_30","1SA","25","30","30","Mantsa ma na A̱sulazuva a shitowoyi zagbain va̱ nzuwulai mi ili isa'ani i na u yuwain suru adama a̱ yi waru a̱vu u zuwa yi zagbain a aci ya aza a Isra'ila, ");
INSERT INTO tsw_vpl VALUES ("S125_31","010_25_31","1SA","25","31","31","zagbain va̱ a̱ da̱na̱ na̱ a̱tsuma̱la̱ngu ko udamotowu o okolo adama o wocosu wu mpasa shi, she vu tsupaa aciya̱wu wan. Waru na̱ A̱sulazuva o roco zagbain va̱ isa'ani, vu cuwan na̱ a̱mu aagbashi a̱ wu.>> ");
INSERT INTO tsw_vpl VALUES ("S125_32","010_25_32","1SA","25","32","32","A̱vu Da̱wuda damma Abigel, <<Za va aba'un ɗa A̱sulazuva A̱sula̱ a Isra'ila, za na lyungu nuwu ana'an vu ga'asan na̱ a̱mu. ");
INSERT INTO tsw_vpl VALUES ("S125_33","010_25_33","1SA","25","33","33","Lyawa vu da̱na̱ na aba'un adama o uge'etosu u sa'ani wa̱ wu, waru a na vu 'yasan numu na̱ wocosu wu mpasa, waru she n tsupaa aciya̱va̱ ne ekere a̱ va̱ wan. ");
INSERT INTO tsw_vpl VALUES ("S125_34","010_25_34","1SA","25","34","34","Na̱ ne shi, n kucuna ta̱ na̱ A̱sulazuva A̱sula̱ a Isra'ila a na a̱ ri wuma, za na putsa numu na ma amaton wu, na̱ shi a damma vu jika̱ vu ta̱wa̱ vu ga'asan na̱ a̱mu shi, babu ko vali ta̱ o u'wa wa Nabal na asa wuma kafu usana.>> ");
INSERT INTO tsw_vpl VALUES ("S125_35","010_25_35","1SA","25","35","35","A̱vu Da̱wuda ushi ili i na u ta̱wa̱a̱ niyi, a̱vu u damma, <<Ka̱mba̱ o u'wa na̱ nden ma asuvu. Mu uwwa ta̱ adanshi a̱ wu waru n usu ta̱ ipati ya̱ wu.>> ");
INSERT INTO tsw_vpl VALUES ("S125_36","010_25_36","1SA","25","36","36","Ana Abigel ka̱mba̱i ya Nabal, a̱yi pe a̱tsuma̱ o u'wa a yuwusan a̱buki, tsa̱ a̱buki o tsugono, u da̱na̱ ta̱ a uwwusa uyo'o, waru usowu lon. Agba u damma yi adama shi hali she nu usana. ");
INSERT INTO tsw_vpl VALUES ("S125_37","010_25_37","1SA","25","37","37","Nu usana, ana usowu'u wu uta̱i Nabal, a̱vu ka va̱ yi damma yi ili ya nda suru, reve okolo a̱ yi a kuɗa nu uta̱, a̱vu u von kpa̱ka̱ tsa aatali. ");
INSERT INTO tsw_vpl VALUES ("S125_38","010_25_38","1SA","25","38","38","Ana a yuwain rana kupa a̱vu A̱sulazuva a faba Nabal, a̱vu u kuwa̱. ");
INSERT INTO tsw_vpl VALUES ("S125_39","010_25_39","1SA","25","39","39","Ana Da̱wuda uwwai a na Nabal kuwa̱ ta̱, a̱vu u damma, <<Za va aba'un ɗa A̱sulazuva a na a tsupaa numu wisulusa u na n tsura̱i o ukere wa Nabal waru u putsa ta̱ aagbashi a̱ yi a yuwan iwuya. A̱sulazuva a̱ ka̱mbuwa̱a̱ ta̱ Nabal ni iwuya ya̱ yi a aci a̱ yi.>> A̱vu Da̱wuda lyungu adanshi a̱ tyo ya Abigel, a damma yi u ciga ta̱ wo o'wo ka va̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S125_40","010_25_40","1SA","25","40","40","Ana agbashi a̱ Da̱wuda a̱ 'ya̱wa̱i uba̱ta̱ wa Abigel ɗe Kame reve a damma yi, <<Da̱wuda ɗa lyungu ntsu tsu tara wu vo o'wo ka va̱ yi.>> ");
INSERT INTO tsw_vpl VALUES ("S125_41","010_25_41","1SA","25","41","41","A̱vu u ka̱ɗa̱to urewesu wa̱ yi a̱ tyo e iɗa reve u damma, <<Apa a̱mu aagbashi a̱ wu ufoɓu u na maa yuwaan wu a̱ga̱nda̱, reve n sa'a ana a agbashi a zagbain va̱.>> ");
INSERT INTO tsw_vpl VALUES ("S125_42","010_25_42","1SA","25","42","42","A̱vu Abigel jika̱ u 'yon u kumba mololi na agbashi e esheli o ton aza a na a yuwusaan yi ulinga a mmalu ana. A̱vu u toni nlingata ma̱ Da̱wuda reve wo o'wo ka va̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S125_43","010_25_43","1SA","25","43","43","A̱vu Da̱wuda zuwisa ka na a̱ tsu ɗe Ahinowam diga Yezireyel, a̱vu ele ra o o'wo a̱ma̱ci a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S125_44","010_25_44","1SA","25","44","44","Amma Shawulu ca ta̱ usheli wa̱ yi Mikal, ka va̱ Da̱wuda ya Palti ulobo wa Layish vuma va Galim, wo'o ka va̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","A̱vu a ama a Zif a̱ 'ya̱wa̱ uba̱ta̱ wa Shawulu ɗe Gibiya a̱vu a damma yi, <<Da̱wuda ta̱ ɗe uva̱pu agaɗi a Hakila, za na a̱ ka̱lyuwusa̱ Jeshimon.>> ");
INSERT INTO tsw_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","Ɗaɗa Shawulu ka̱ra̱i a̱cipa̱ a̱ tyo A̱tsumona a Zif oɓolo na ali o uvon ukpakukupa uta'atsu (3,000) aza a Isra'ila a na u ɗangulai, adama a zami ɗe Da̱wuda. ");
INSERT INTO tsw_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","A̱vu Shawulu yuwan uva̱la̱ta̱ wa̱ yi zuzu nu ure zuva va aagaɗi a Hakila a̱ ka̱lyuwusa̱ Jeshimon, amma Da̱wuda da̱na̱ ta̱ nden a̱tsumona'a. Ana wu uwwai ana Shawulu ta̱wa̱ ta̱ izami ya̱ yi, ");
INSERT INTO tsw_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","a̱vu u lyungu aza a na aa tawa utyo, a̱vu gba e ene amayun a ɗa Shawulu ta̱ lo oɓolo na ali o uvon yi. ");
INSERT INTO tsw_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","Reve Da̱wuda 'yon u 'ya̱wa̱ uba̱ta̱ u na Shawulu va̱la̱i, a̱vu we ene uba̱ta̱ u na Shawulu na̱ Abna ulobo wa Ner, yali ya̱ a̱soja a̱ yi, o voyin. Shawulu da̱na̱ ta̱ pe nven e memere mo uva̱la̱ta̱, reve ali o uvo'on o von uka̱nda̱ruwu na̱ a̱yi a nlavu. ");
INSERT INTO tsw_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","Reve Da̱wuda damma Ahimele za va Hitiya, na̱ Abishai mawun ma̱ a̱na̱wu ma Yowab za na mma le ɗa Zeruya, <<Zane ɗa a̱ kuru mu a̱ 'ya̱wa̱ o uva̱la̱ta̱ uba̱ta̱ wa Shawulu?>> A̱vu Abishai usu, <<N ta̱ 'ya̱wa̱ oɓolo na̱ a̱vu.>> ");
INSERT INTO tsw_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","Ɗaɗa Da̱wuda na̱ Abishai a̱ 'ya̱wa̱i o uva̱la̱ta̱ wa Shawulu na ayin, a̱vu a cina yi a nlavu, ni ibata ya̱ yi usapu e iɗa zuzu na aaci a̱ yi. Abna gba oɓolo na akapi ali o uvo'on a̱ da̱na̱ ta̱ nven uka̱nda̱ruwa̱ na̱ a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","Reve Abishai damma Da̱wuda, <<Ana'an A̱sula̱ a ca ta̱ ma'yuwatan ma̱ wu o ukere wa̱ wu. Gogo lyawa mu n ya̱wa̱ n sapa yi usapu u ta̱ ni ibata ya̱ yi n ɓolo yi ni iɗa, n ciga n sapa yi ure shi.>> ");
INSERT INTO tsw_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","Amma a̱vu Da̱wuda damma Abishai, <<She vu una yi wan! Zane ɗa a̱a̱ 'ya̱sa̱n ukere u ju'wa̱n vuma na A̱sulazuva a tawai a̱vu u da̱na̱ babu unusu?>> ");
INSERT INTO tsw_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","A̱vu Da̱wuda damma, <<N kucuna ta̱ na̱ A̱sulazuva a na a̱ ri wuma, A̱sulazuva na aciya̱yi a̱yi ɗa woo kototo yi, ko urana wa̱ yi u ta̱wa̱ a na wa̱a̱ kuwa̱, ko u 'ya̱wa̱ uba̱ta̱ o uvon a̱vu u kuwa̱ ɗe. ");
INSERT INTO tsw_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","Amma A̱sulazuva a paraa mu n 'ya̱sa̱n ukere u va̱ n ju'wa̱n za na A̱sulazuva a̱ tsuwa̱yin mani'in. Gogo vu tara ibata i na i ri uba̱ta̱ a aaci a̱ yi na̱ medele ma̱ mini a̱vu vu ta̱wa̱ tsu wala.>> ");
INSERT INTO tsw_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","Ɗaɗa Da̱wuda tarai ibata na̱ medele ma̱ mini ma na ma̱ ri zuzu na aaci a Shawulu, reve a̱ ka̱ra̱. Babu za na ene nle ko revei ili i na i farai, ko za ro juwan, adama a na suru nle nlavu ma̱ a̱ru'un diga uba̱ta̱ wa̱ A̱sulazuva ma̱pura̱ le ta̱. ");
INSERT INTO tsw_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","Reve Da̱wuda ka̱ra̱ a̱ tyo mavada mo uka̱ri ma̱ ndeɗe, a̱vu u kumba aagaɗi o ro za na ri akasu nu uba̱ta̱ u na Shawulu no oɓolo ali o uvon a̱ yi ri. A̱ba̱jini agalaci a̱ da̱na̱ ta̱ e memere me ele. ");
INSERT INTO tsw_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","A̱vu Da̱wuda salaa ali o uvon na̱ Abna ulobo wa Ner, a̱vu u damma, <<Vu ta uwusa mu Abna?>> Reve Abna usu, <<Zane ɗa a̱vu za na e ɗesu a damatosun mogono tsun nda?>> ");
INSERT INTO tsw_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","Reve Da̱wuda damma Abna, <<A̱vu vali ɗa, ko ne ɗa shi? Zane ɗa ri tsa̱ wu a̱tsuma̱ ali o uvon a Isra'ila? Nye i zuwai vu piriyi zagbain va̱ wu mogono ulobonu shi? Adama a na za ro ta̱wa̱ ta̱ adama wu una mogono zagbain va̱ wu. ");
INSERT INTO tsw_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","Ili i na vu yuwain u lobono shi. N kucuna ta̱ na̱ A̱sulazuva a na a̱ ri wuma, a̱vu na ali o uvon a̱ wu i 'yuwan i kuwa̱, adama a na i piriyi zagbain ɗu ulobonu shi, za na A̱sulazuva a̱ tsuwa̱yin mani'in. Ka̱lyuwa̱i a̱ te ɗa ibata i mogono na̱ medele ma̱ mini ma na ma̱ ri zuzu na aaci a̱ yi?>> ");
INSERT INTO tsw_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","Shawulu reve ta̱ uɗyo wa̱ Da̱wuda a̱vu u damma, <<Uɗyo wa̱ wu u ɗa nda'a ulobo u va̱ Da̱wuda?>> A̱vu Da̱wuda usu, <<Ee a̱mu ɗa zagbain va̱ mogono.>> ");
INSERT INTO tsw_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","A̱vu Da̱wuda lyuwa elime na adanshi u damma, <<Nye i zuwai zagbain va̱ a gbagbusa aagbashi a̱ yi? Nye i ɗa n yuwain, waru iwuya i ne ɗa i ri e ekere a̱ va̱? ");
INSERT INTO tsw_vpl VALUES ("S126_19","010_26_19","1SA","26","19","19","Gogo lyawa zagbain va̱ mogono ma uwwa adanshi a aagbashi a̱ yi. Ko na̱ shi A̱sulazuva a ɗa a zuwa nuwu vu yuwan upan adama a̱ va̱, to lyawa u ushi kucci. Amma na ama ɗa a zuwai, lyawa a yuwaan le una̱ a̱ ma̱ka̱ka̱n ma̱ a̱ A̱sulazuva! Adama a na a̱ gba̱ra̱ mu ta̱ ana'an adama a na ma̱ tsura̱ akunda a̱tsuma̱ agadu A̱sulazuva, a dansaa, <Ya̱wa̱ vu yuwaan musula̱ n ro a̱ga̱nda̱.> ");
INSERT INTO tsw_vpl VALUES ("S126_20","010_26_20","1SA","26","20","20","Gogo she vu lyawa mpasa n va̱ mo oco e iɗa alanga na̱ ma̱ka̱ka̱n ma̱ A̱sulazuva wan. Nye i zuwai mogono ma Isra'ila ma̱ ri ya̱ izami i na wo una aakupa tsa a̱ va̱? Cine tsu ɗa va yuwan ugenge u va̱ tsa matsulu a nsasan?>> ");
INSERT INTO tsw_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","Ɗaɗa Shawulu dammai, <<N yuwan ta̱ unusu, ka̱mba̱ Da̱wuda ulobo u va̱, ma yuwan wu iwiya waru shi, adama a na vu tara ta̱ wuma u va̱ na̱ a̱ɓula̱ ana'an. Amayun n yuwan ta̱ tsulo, waru ni ili yu uwuyanu lon!>> ");
INSERT INTO tsw_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","A̱vu Da̱wuda usu, <<Apa nda ibata i mogono, lyawa za ta̱ a̱tsuma̱ ali o uvon a̱ wu u ta̱wa̱ u ushi yi. ");
INSERT INTO tsw_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","A̱sulazuva a tsu zuwaa ta̱ koyan aba'un o una̱ wa̱ a̱ɓula̱ a̱ yi na amayun a̱ yi. A̱sulazuva a ca wu ta̱ e ekere a̱ va̱ ana'an, amma ma̱a̱ 'ya̱sa̱n ukere n ju'wa̱n za na A̱sulazuva a̱ tsuwa̱yin mani'in shi. ");
INSERT INTO tsw_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","A̱yi ɗa nda, cine wuma wa̱ wu u ri ulobonu ana'an e esu a̱ va̱, ne ɗa lyawa wuma u va̱ u da̱na̱ ulobonu o urewesu wa̱ A̱sulazuva, waru lyawa u wawa mu a̱tsuma̱ a addama suru!>> ");
INSERT INTO tsw_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","Ɗaɗa Shawulu dammai Da̱wuda, <<Lyawa vu da̱na̱ na aba'un ulobo u va̱ Da̱wuda, vu ta yuwan ili na̱ a̱bunda̱ waru na amayun vu ta lyuwa aci e le.>> Ɗaɗa Da̱wuda remei ure wa̱ yi, a̱vu Shawulu ka̱mba̱ o u'wa. ");
INSERT INTO tsw_vpl VALUES ("S127_1","010_27_1","1SA","27","1","1","Reve Da̱wuda yuwan majiyan o okolo a̱ yi, <<Urana u ro n ta̱ kuwa̱ o ukere wa Shawulu. Ili i na i la'aa numu a na ma yuwan a̱yi ɗa n suma a̱ tyo e iɗa ya aza a Filistiya. Shawulu ta lyawa izami i va̱ uba̱ta̱ suru a̱tsuma̱ a pasu vi iɗa ya Isra'ila, waru n ta la'a o ukere wa̱ yi.>> ");
INSERT INTO tsw_vpl VALUES ("S127_2","010_27_2","1SA","27","2","2","Ɗaɗa Da̱wuda na ali o uvon a̱ yi ukpakuta̱li (600) a na a̱ ri oɓolo na̱ a̱yi a̱ ka̱ra̱i, a̱vu a̱ tyo mavada uba̱ta̱ wa Akish ulobo wa Mawok, mogono ma Gat. ");
INSERT INTO tsw_vpl VALUES ("S127_3","010_27_3","1SA","27","3","3","A̱vu Da̱wuda na ali o uvon a̱ yi a̱ da̱nu a̱tsuma̱ a Gat oɓolo na̱ Akish. Za suru da̱na̱ ta̱ oɓolo nu u'wa wa̱ yi, waru Da̱wuda da̱na̱ ta̱ oɓolo na̱ a̱ma̱ci e re a̱ yi Ahinowam za va Yezireyel na̱ Abigel za va Kame, ma̱runa̱ ma Nabal. ");
INSERT INTO tsw_vpl VALUES ("S127_4","010_27_4","1SA","27","4","4","Agba ana a dammai Shawulu Da̱wuda suma ta̱ a̱ tyo Gat, u da̱shi zami yi shi. ");
INSERT INTO tsw_vpl VALUES ("S127_5","010_27_5","1SA","27","5","5","Uranu u ro reve Da̱wuda damma Akish, <<Na̱ n tsura̱ isa'ani e esu a̱ wu, lyawa vu ca mu uba̱ta̱ u ro a̱tsuma̱ a̱ mulyuci vi iɗa'a, adama n da̱nu ɗe. Adama a̱ nye a ɗa aagbashi a̱ wu a̱ da̱nu a̱ lyuci tsugono oɓolo na̱ vu?>> ");
INSERT INTO tsw_vpl VALUES ("S127_6","010_27_6","1SA","27","6","6","Ne ɗa o urana u ndolo Akish ca niyi Ziklag, a̱yi ɗa i zuwai Ziklag wo o'woi za vu ngono ma Yahuda hali na ana'an. ");
INSERT INTO tsw_vpl VALUES ("S127_7","010_27_7","1SA","27","7","7","Da̱wuda da̱nu ta̱ e iɗa ya Filistiya aa'wan a̱ ta̱ na̱ woto na̱shi. ");
INSERT INTO tsw_vpl VALUES ("S127_8","010_27_8","1SA","27","8","8","A̱tsuma̱ a rana vu nde ma̱ a̱ yi a̱tsuma̱ a Ziklag, Da̱wuda tsu u ta̱ ta̱ na ali o uvon a̱ yi adama a̱ riya̱a̱ aza a Geshura nu uvon, na aza a Girzi na aza a Amaleka. Ɗe nu ufaru ama a nda a ɗa a fara da̱nuyi e iɗa'a, diga upasu wa̱ Shur, hali a cina Masar. ");
INSERT INTO tsw_vpl VALUES ("S127_9","010_27_9","1SA","27","9","9","Mantsa ma na suru Da̱wuda riya̱a̱ nle nu uvon, u tsu lyawa vali ko ka wuma shi, amma u tsu pura̱ ta̱ mgbele ni inan, na̱ nloli, na arakumi, ni itana yu otosu. Reve u ka̱mba̱ ya Akish. ");
INSERT INTO tsw_vpl VALUES ("S127_10","010_27_10","1SA","27","10","10","Na̱ Akish ece yi, <<Te ɗa vu 'ya̱wa̱i uvon ana'an?>> Da̱wuda tsu damma yi ta̱, <<Uba̱ta̱ wa Nege wu upasu wa Yahuda,>> ko, <<Uba̱ta̱ wa Nege wu upasu wa aza a Yerameyel,>> ko, <<Uba̱ta̱ wa Nege wu upasu wa̱ a̱za̱ a̱ Keni.>> ");
INSERT INTO tsw_vpl VALUES ("S127_11","010_27_11","1SA","27","11","11","Da̱wuda tsu lyawa vali ko ka wuma shi, adama a na she ta̱wa̱ a̱ 'ya̱wa̱ nu dammu a̱tsuma̱ a Gat a damma, <<Apa ili i na Da̱wuda yuwain>> wan. A̱yi ɗa ili i na u yuwusain mantsa ma na u da̱na̱i nden e iɗa ya aza a Filistiya suru. ");
INSERT INTO tsw_vpl VALUES ("S127_12","010_27_12","1SA","27","12","12","A̱vu Akish lyawaa Da̱wuda okolo, a̱vu u damma aciya̱yi, <<Wo o'wo ta̱ ili yi idaba lon uba̱ta̱ wa ama a̱ yi, aza a Isra'ila, adama wo o'wo aagbashi a̱ va̱ hali hali.>> ");
INSERT INTO tsw_vpl VALUES ("S128_1","010_28_1","1SA","28","1","1","A rana ndolo aza a Filistiya o ɓoloto ta̱ ali o uvon e le adama o uvon, adama a yuwan uvon na aza a Isra'ila. A̱vu mogono Akish damma Da̱wuda, <<Vu reve a na a̱vu na ali o uvon a̱ wu i to uta̱ oɓolo na̱ a̱mu, na ali o uvon a̱ va̱ adama o uvon.>> ");
INSERT INTO tsw_vpl VALUES ("S128_2","010_28_2","1SA","28","2","2","Reve Da̱wuda damma, <<U lobono ta̱, vu te ene ili i na aagbashi a̱ wu aa gura.>> Reve Akish damma Da̱wuda, <<U lobono ta̱, n ta̱ ka̱mbuwa̱ wu za vi ipiri va̱ a mantsa ma wuma u va̱.>> ");
INSERT INTO tsw_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","Gogo Sama'ila kuwa̱ ta̱ ɗe, a̱vu aza a Isra'ila suru a yuwan nden n wiruta̱ adama a̱ yi, a̱vu a̱ ciɗo yi a̱ lyuci va̱ yi ɗe Rama. Shawulu gba̱ra̱ ta̱ ɗe aza a na o ɓoloso aci na̱ ruhu va̱ a̱kwa̱kwa̱ na̱ a̱za̱ a̱ yindi e iɗa'a. ");
INSERT INTO tsw_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","Reve aza a Filistiya o ɓoloto aciya̱le reve a yuwan uva̱la̱ta̱ zuzu na̱ lyuci va Shunem, Shawulu gba shi u ɓoloto ta̱ suru ali o uvon a Isra'ila, a̱vu a yuwan uva̱la̱ta̱ u le a Masasan ma Gilbowa. ");
INSERT INTO tsw_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","Ana Shawulu enei ali o uvon a Filistiya, reve okolo a̱ yi e je'en na̱ wovon lon. ");
INSERT INTO tsw_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","Waru a na Shawulu patiyi A̱sulazuva, A̱sulazuva a̱ usu yi shi, ko uba̱ta̱ wa alavu, ko na̱ Urim, ko uba̱ta̱ wa ama̱sula̱. ");
INSERT INTO tsw_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","Reve Shawulu damma agbashi a̱ yi, <<Zamiya numu ka na o ɓoloso aci na̱ ruhu va̱ a̱kwa̱kwa̱, adama n 'ya̱wa̱ ya̱'a̱ yi me ece yi ili i na maa yuwan.>> A̱vu agbashi a̱ yi a damma yi, <<Za ro ta̱ ɗe En Do.>> ");
INSERT INTO tsw_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","Ɗaɗa Shawulu pusa̱n yi iroci ya̱ yi a̱vu wo oto itana i ro, reve na ayin a̱yi na ama e re a̱ ka̱ra̱ a̱ 'ya̱wa̱ uba̱ta̱ a ka'a a̱vu u damma yi, <<Ece we mu ruhu vu za na kuwa̱i vu ta̱wa̱a̱ mu na̱ za na suru mee ɗe aala a̱ yi.>> ");
INSERT INTO tsw_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","Amma ka'a u damma yi ta̱, <<Amayun vu reve ta̱ ili i na Shawulu yuwain. U gba̱ra̱ ta̱ aza a na o ɓoloso aci na̱ ruhu va̱ a̱kwa̱kwa̱ na̱ a̱za̱ a̱ yindi a̱tsuma̱ e iɗa'a. Adama a̱ nye vaa azuwayi wuma u va̱ maza, adama vu zuwa o una mu?>> ");
INSERT INTO tsw_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","Shawulu kucinaa yi ta̱ na̱ A̱sulazuva, <<N kucina ta̱ na̱ A̱sulazuva a na a̱ ri wuma, aa ca wu a̱tsuma̱lima̱ adama a nda shi.>> ");
INSERT INTO tsw_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","Reve ka'a u damma, <<Zane ɗa ma̱a̱ ta̱wa̱a̱ wu?>> A̱vu u damma, <<Ta̱wa̱a̱ mu na̱ Sama'ila.>> ");
INSERT INTO tsw_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","Ana ka'a we enei Sama'ila a̱vu wo oruwo lon a̱vu u damma Shawulu, <<Nye i zuwai vu luluma̱ numu? Ashe a̱vu ɗa mogono Shawulu!>> ");
INSERT INTO tsw_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","Reve mogono'o u damma yi, <<She vu uwwa wovon wan. Nye i ɗa ve enei?>> A̱vu ka'a u damma, <<Me ene ta̱ za ro tsa ma̱sula̱ o uta̱sa̱ diga e iɗa.>> ");
INSERT INTO tsw_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","A̱vu we ece yi, <<Nye i ɗa oroci a̱ yi?>> Reve u usu, <<Abara a ɗa me enei a̱ ta̱wa̱ woto wu nu utugu.>> Ɗaɗa Shawulu revei a na Sama'ila ɗa, a̱vu u kingyo u ka̱ɗa̱to urewesu wa̱ yi a̱ tyo we iɗa. ");
INSERT INTO tsw_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","Reve Sama'ila damma Shawulu, <<Nye i zuwai vu damaton numu a na vu ta̱wa̱to numu?>> A̱vu Shawulu usu, <<N ta̱ pe a̱tsuma̱ a̱tsuma̱lima̱ lon, aza a Filistiya a ta yuwusan uvon na̱ a̱mu waru A̱sula̱ a vadalaa mu ta̱ ucina̱. U da̱shi usu mu shi, ko uba̱ta̱ wa ama̱sula̱ ko uba̱ta̱ wa alavu shi. Adama o ndolo n ɗe wu ta̱ vu damma mu ili i na maa yuwan.>> ");
INSERT INTO tsw_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","Reve Sama'ila damma, <<Nye i zuwai ve ece numu, a na wo o'woi A̱sulazuva a vadalaa nuwu ucina̱, a̱vu wo o'wo ma'yuwatan ma̱ wu? ");
INSERT INTO tsw_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","A̱sulazuva a yuwan ta̱ na̱ a̱vu cine u dammai o una̱ u va̱. A̱sulazuva a kara ta̱ tsugono diga e ekere a̱ wu a̱vu u ca moron ma̱ wu Da̱wuda. ");
INSERT INTO tsw_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","Adama a na vu yuwan tsutoni nu uɗyo wa̱ A̱sulazuva shi, a na vu kuɗa̱i o kototo aza a Amaleka aza a na u da̱na̱i a uwwusa upan u le lon, a̱yi ɗa i zuwai A̱sulazuva a yuwaan nuwu ili ya nda ana'an. ");
INSERT INTO tsw_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","Babu na̱ ne, A̱sulazuva a ta ca ali o uvon a Isra'ila oɓolo na̱ a̱vu e ekere a aza a Filistiya, waru nfa'an a̱vu no olobo a̱ wu i ta̱ da̱na̱ oɓolo na̱ a̱mu. A̱sulazuva a ta ca ali o uvon a Isra'ila suru e ekere a aza a Filistiya.>> ");
INSERT INTO tsw_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","Ɗaɗa Shawulu rishiyi nu uta̱ wudaruwu e iɗa, tapu nu wovon adama a adanshi a Sama'ila. Waru u da̱na̱ nu ucira shi, adama a na u lyuwai ili i ro shi urana na ayin o ndolo suru. ");
INSERT INTO tsw_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","Ana ka'a ta̱wa̱i ya Shawulu, waru ana we enei u ta̱ e meje'en lon, reve u damma yi, <<A̱yi ɗa nda aagbashi a̱ wu a yuwaan wu ta̱ tsutoni. N ca ta̱ wuma u va̱ adama n yuwan ili i na vu damma numu. ");
INSERT INTO tsw_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","Gogo yuwan ankuri vu uwwa aagbashi a̱ wu. Waru vu lyawa n ca wu ilyalya tsura̱ vu lyuwa adama vu tsura̱ ucira u na va̱a̱ ka̱mba̱.>> ");
INSERT INTO tsw_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","A̱vu u 'yuwan u damma, <<Maa lyuwa ili i ro shi.>> Amma agbashi a̱ yi a kamba ta̱ ka'a a patishi yi, reve wu uwwa adanshi e le. Ɗaɗa u yoyin diga e iɗa a̱vu u da̱nu a̱ a̱ga̱da̱. ");
INSERT INTO tsw_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","Ka'a u shi ta̱ na̱ ma̱dindim ma̱ lipu o u'wa, ɗaɗa u jika̱ tara u paɗa yi, a̱vu u tara yira u lapa, reve u yuwaan yi opopofu a na a̱ ri na̱ wolilo shi. ");
INSERT INTO tsw_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","Ɗaɗa u delyo wa̱ yi Shawulu na̱ agbashi a̱ yi, a̱vu a tama. Ɗaɗa a̱ 'yoyin a̱ ka̱ra̱i na ayin o ndolo. ");
INSERT INTO tsw_vpl VALUES ("S129_1","010_29_1","1SA","29","1","1","Aza a Filistiya o ɓoloto ta̱ ali o uvon e le suru ɗe Afe, a̱vu aza a Isra'ila a̱ va̱la̱ a̱ lyusu mini a̱tsuma̱ a Yezireyel. ");
INSERT INTO tsw_vpl VALUES ("S129_2","010_29_2","1SA","29","2","2","Mantsa ma na azagbain a aza a Filistiya a̱ ri a mmalu no oɓolo ali o uvon ukpaku na̱ ukpakukupa, Da̱wuda na ali o uvon a̱ yi a̱ da̱na̱ ta̱ o tono ele a mmalu a̱ca̱pa̱ oɓolo na̱ mogono Akish. ");
INSERT INTO tsw_vpl VALUES ("S129_3","010_29_3","1SA","29","3","3","Nan yali o uvon a Filistiya a yuwan ta̱ yeci, <<Nye i ɗa Mmaci ma Ibrahim nda maa yuwusan pa?>> Reve Akish usu, <<Da̱wuda ɗa zana da̱na̱i aagbashi a Shawulu mogono ma Isra'ila. U ta̱ pa oɓolo na̱ a̱mu aa'wan aa'wan, waru diga urana u na wu kasai na̱ Shawulu a cina ana'an n tsura̱ yi nu unusu shi.>> ");
INSERT INTO tsw_vpl VALUES ("S129_4","010_29_4","1SA","29","4","4","Amma nan yali o uvon a Filistiya a yuwan ta̱ upan na̱ a̱yi a̱vu a damma yi, <<Ka̱mba̱to ɗe vuma nda, adama u ka̱mba̱ ɗe uba̱ta̱ u na vu ca niyi nda̱na̱ta̱. Wa̱a̱ 'ya̱wa̱ oɓolo na̱ a̱tsu uba̱ta̱ o uvon shi, ta̱wa̱ u ta̱wa̱ u vadalaa tsu mantsa mo uvon wan. U ta gura yuwan ulinga na̱ mantsa ma nda wu koɗo aci a̱tsu adama u yo'onoto Shawulu zagbain va̱ yi okolo. ");
INSERT INTO tsw_vpl VALUES ("S129_5","010_29_5","1SA","29","5","5","Ashe Da̱wuda ɗa na a canaa yi ishipa nu uje'en a̱vu a cana, <Shawulu una ta̱ ukpakukupa va̱ yi, waru Da̱wuda una ta̱ ukpakukupa kupa va̱ yi.> >> ");
INSERT INTO tsw_vpl VALUES ("S129_6","010_29_6","1SA","29","6","6","Ɗaɗa Akish ɗeyi Da̱wuda reve u damma yi, <<N kucina ta̱ na̱ A̱sulazuva a na a̱ ri wuma, a̱vu za va̱ a̱ɓula̱ ɗa, waru shi ta̱ n ciga vu 'ya̱wa̱ uvon oɓolo na ali o uvon a̱ va̱. Adama a na diga urana u na vu ta̱wa̱i ya̱'a̱ va̱ a cina ana'an, n tsura̱ wu nu unusu shi, amma akapi azagbain a Filistiya a̱ usu wu shi. ");
INSERT INTO tsw_vpl VALUES ("S129_7","010_29_7","1SA","29","7","7","To, gogo she vu vadala vu ka̱mba̱ na asuvu nden, she vu yuwan ili i na ya̱a̱ lungusa̱ okolo akapi azagbain a Filistiya wan.>> ");
INSERT INTO tsw_vpl VALUES ("S129_8","010_29_8","1SA","29","8","8","A̱vu Da̱wuda ece yi, <<Amma nye i ɗa n yuwain? Unusu u ne u ɗa vu tsura̱i uba̱ta̱ wa aagbashi a̱ wu diga o urana u na n ta̱wa̱i ya̱'a̱ wu hali a cina ana'an? Nye i zuwai ma̱a̱ 'ya̱wa̱ n yuwan uvon na̱ n'yuwatan mu zagbain va̱ mogono shi?>> ");
INSERT INTO tsw_vpl VALUES ("S129_9","010_29_9","1SA","29","9","9","A̱vu Akish usu yi reve u damma, <<N reve ta̱ vu ta̱ babu unusu na amayun a̱ wenu u va̱ tsa malingata ma̱ A̱sula̱, suru na̱ ne nan yali o uvon a Filistiya a damma ta̱, <Wa̱a̱ 'ya̱wa̱ oɓolo na̱ a̱tsu uba̱ta̱ o uvon shi.> ");
INSERT INTO tsw_vpl VALUES ("S129_10","010_29_10","1SA","29","10","10","Gogo she vu 'yon nu usana, oɓolo na̱ agbashi a zagbain va̱ wu Shawulu aza a na a̱ ta̱wa̱i oɓolo na̱ a̱vu, a̱vu i ka̱ra̱ nu usana urana a̱ ma̱ɓa̱tsa̱a̱.>> ");
INSERT INTO tsw_vpl VALUES ("S129_11","010_29_11","1SA","29","11","11","Ɗaɗa Da̱wuda na ali o uvon a̱ yi o uta̱i nu usana adama a̱ ka̱mba̱ e iɗa ya aza a Filistiya, reve aza a Filistiya a̱ ka̱ra̱ a̱ tyo Yezireyel. ");
INSERT INTO tsw_vpl VALUES ("S130_1","010_30_1","1SA","30","1","1","Ana a yuwain rana ta'atsu, a mantsa ma na Da̱wuda oɓolo na ali o uvon a̱ yi a rawai a 'wa le a̱ lyuci va Ziklag, reve a cina oɓolo ali o uvon a Amaleka cina a̱ ta̱wa̱a̱ ozo o upasu we Nege na̱ Ziklag nu uvon hali a̱ kula̱to yi. ");
INSERT INTO tsw_vpl VALUES ("S130_2","010_30_2","1SA","30","2","2","A̱vu e reme a̱ma̱ci na aza a na a̱ ri pe suru, mawun na̱ zagbain suru. Agba o una ko za shi, amma a̱ pura̱ le ta̱ a̱ ka̱ra̱. ");
INSERT INTO tsw_vpl VALUES ("S130_3","010_30_3","1SA","30","3","3","Ana Da̱wuda na ali o uvon a̱ yi a rawai Ziklag, a̱vu a cina a̱ kula̱to yi ta̱ na akina waru a̱ma̱ci e le no olobo ne esheli e le a̱ pura̱ le ta̱. ");
INSERT INTO tsw_vpl VALUES ("S130_4","010_30_4","1SA","30","4","4","Ɗaɗa Da̱wuda na ali o uvon a na a̱ ri oɓolo na̱ a̱yi a̱ shosuyin na̱ yisali lon hali a lamba ucira u na a̱a̱ shon. ");
INSERT INTO tsw_vpl VALUES ("S130_5","010_30_5","1SA","30","5","5","A̱ pura̱ ta̱ fo a̱ma̱ci e re a̱ Da̱wuda, Ahinowam za va Yezireyel na̱ Abigel ma̱runa̱ ma Nabal va Kame. ");
INSERT INTO tsw_vpl VALUES ("S130_6","010_30_6","1SA","30","6","6","Waru Da̱wuda da̱na̱ ta̱ pe e meleshe lon, adama a na ali o uvon a̱ yi a yuwan ta̱ adanshi a na a vuvara yi na atali hali u kuwa̱, adama a na koyan da̱na̱ ta̱ o upan lon u na waa lamba o olobo ne esheli a̱ yi. Amma Da̱wuda ca ta̱ aciya̱yi adanshi adama a na u zuwa ta̱ ucira wa̱ yi e ekere a̱ A̱sulazuva A̱sula̱ a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S130_7","010_30_7","1SA","30","7","7","Reve Da̱wuda damma Abiyata ganu, ulobo wa Ahimele, <<Ta̱wa̱a̱ mu na̱ epo.>> Ɗaɗa Abiyata ta̱wa̱yi Da̱wuda na̱ epo. ");
INSERT INTO tsw_vpl VALUES ("S130_8","010_30_8","1SA","30","8","8","Reve Da̱wuda ece A̱sulazuva, <<N saɓa oɓolo ali o uvon a na a̱ ta̱wa̱a̱ ntsu nu uvon u nda? N ta cina le?>> A̱vu u usu yi, <<Saɓa le adama a na na amayun vu ta cina le, reve vu usa suru ili i na a̱ pura̱ nuwu wi i ɗa.>> ");
INSERT INTO tsw_vpl VALUES ("S130_9","010_30_9","1SA","30","9","9","Ɗaɗa Da̱wuda uta̱i, na ali o uvon ukpakuta̱li (600) a na a̱ ri oɓolo na̱ a̱yi. Ana a rawai o Uka̱ri wa Beso, reve ozo o ro e le e isawan lo. ");
INSERT INTO tsw_vpl VALUES ("S130_10","010_30_10","1SA","30","10","10","Amma Da̱wuda na ali o uvon ukpakuna̱shi (400) a lyuwa ta̱ elime na̱ masaɓa me le goon, adama a na ali o uvon ukpakure (200) a̱ kuna̱ ta̱ hali a gura pasa uka̱ri'i shi. ");
INSERT INTO tsw_vpl VALUES ("S130_11","010_30_11","1SA","30","11","11","Ali a na a̱ da̱na̱i oɓolo na̱ Da̱wuda a̱ tsura̱ ta̱ vuma va Masar a atsusa reve a tara yi a̱ tyo ya̱ Da̱wuda. A̱vu a ca yi ilyalya u lyuwa, na̱ mini reve u sowo. ");
INSERT INTO tsw_vpl VALUES ("S130_12","010_30_12","1SA","30","12","12","A̱vu a cayi abishi akala a̱ muwun mu ubiri o u'yewu, na̱ ogbodolu a̱ muwun n ina̱bi o u'yewu ejere. Waru a na u tamai reve ugbozu u ka̱mba̱ yi, adama a na u shi u lyuwa ilyalya ko u sowo mini shi a̱tsuma̱ arana ta'atsu na ayin a ta'atsu. ");
INSERT INTO tsw_vpl VALUES ("S130_13","010_30_13","1SA","30","13","13","Reve Da̱wuda damma yi, <<Zane ɗa zagbain va̱ wu waru te ɗa vu uta̱i?>> Reve u usu, <<A̱mu vuma va Masar ɗa aagbashi a za va Amaleka. Zagbain va̱ lyawa mu ta̱ rana ta'atsu na ka̱ra̱i a na m banakain. ");
INSERT INTO tsw_vpl VALUES ("S130_14","010_30_14","1SA","30","14","14","Tsu 'ya̱wa̱ ta̱ nu uvon upasu wa̱ Nege va aza a Keretiya na̱ upasu wa aza a Yahuda na̱ upasu wa̱ Nege va Keleb, a̱vu waru tsu kula̱to Ziklag.>> ");
INSERT INTO tsw_vpl VALUES ("S130_15","010_30_15","1SA","30","15","15","A̱vu Da̱wuda damma yi, <<Vu ta gura tara mu a̱ cipa̱ uba̱ta̱ o oɓolo ali o uvon o ndolo?>> Reve u usu, <<Kucinaa mu na̱ A̱sula̱ a na voo una mu ko vu cawisan mu waru e ekere a zagbain va̱ shi, n ta tara wu a̱ tyo uba̱ta̱ u le.>> ");
INSERT INTO tsw_vpl VALUES ("S130_16","010_30_16","1SA","30","16","16","A̱vu u tara yi a̱ 'ya̱wa̱, a̱vu a cina le ɗe ubetu'wu o upasu wi iɗa'a suru, a lyuwusa no osowi a uwusa uyo'o, adama a̱ a̱bunda̱ e itana i na a̱ pura̱i diga e iɗa ya aza a Filistiya na̱ diga e iɗa ya Yahuda. ");
INSERT INTO tsw_vpl VALUES ("S130_17","010_30_17","1SA","30","17","17","Reve Da̱wuda riya̱a̱ le nu uvon diga urana a̱ ma̱riya̱ hali a cina nfa'an nu ulivu, waru babu vuma a̱tsuma̱ e le za na la'ai, she olobo ukpakuna̱shi (400) a na a kumbai arakumi a̱vu a suma. ");
INSERT INTO tsw_vpl VALUES ("S130_18","010_30_18","1SA","30","18","18","Da̱wuda usa ta̱ ili i na suru aza a Amaleka a̱ shi a̱ pura̱i, oɓolo na̱ a̱ma̱ci e re a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S130_19","010_30_19","1SA","30","19","19","Babu ili i na i puwa̱yin, ko mawun ko zagbain ko ulobo ko usheli, ko itana ko ili i ro i na a̱ shi a̱ pura̱i. Da̱wuda ka̱mbuwa̱ ta̱ ili'i suru. ");
INSERT INTO tsw_vpl VALUES ("S130_20","010_30_20","1SA","30","20","20","U pura̱ ta̱ geru vu mgbele ni inan suru, a̱vu ali o uvon a̱ yi a guɓa le elime iliyamunga i le, a dansa, <<Ele ɗa ili i na Da̱wuda pura̱i uba̱ta̱ wu uvon.>> ");
INSERT INTO tsw_vpl VALUES ("S130_21","010_30_21","1SA","30","21","21","Reve Da̱wuda ka̱mba̱ o Uka̱ri wa Beso a̱vu u cina ali o uvon ukpakure (200) a na a gura kuru niyi shi adama o ukunu, a̱vu a̱ ta̱wa̱ a ga'asan na̱ Da̱wuda oɓolo na ali o uvon a na a̱ ri oɓolo na̱ a̱yi. A mantsa ma na Da̱wuda na ali o uvon a rawai zuzu na̱ le a̱vu u ca̱sa̱ le. ");
INSERT INTO tsw_vpl VALUES ("S130_22","010_30_22","1SA","30","22","22","Amma a̱vu suru a̱za̱ e iwuya na̱ ama a vama a̱tsuma̱ aza a na a̱ kuruyi Da̱wuda a damma, <<Adama a na a̱ 'ya̱wa̱i oɓolo na̱ a̱tsu shi, tsaa ca le ili i na tsu tsura̱i uba̱ta̱ wu uvon shi. She de a tara a̱ma̱ci e le na̱ muwun n le a̱ ka̱ra̱.>> ");
INSERT INTO tsw_vpl VALUES ("S130_23","010_30_23","1SA","30","23","23","Amma Da̱wuda damma ta̱, <<Waa yuwan ne shi, a̱za̱ a̱ va̱! She i ciga aciya a̱ ɗu ekere e ili i na A̱sulazuva a ca n tsu wan. U geshe tsu ta̱, a̱vu u ca tsu oɓolo ali o uvon a na a̱ ta̱wa̱i a yuwain uvon na̱ a̱tsu. ");
INSERT INTO tsw_vpl VALUES ("S130_24","010_30_24","1SA","30","24","24","Babu za na a̱ usu ili i na i dammai! Akunda a za na isawain ni itana u ta̱ da̱na̱ una̱ta̱ na̱ za na 'ya̱wa̱i uba̱ta̱ o uvon. Suru tsu ta̱ ne'eshen le una̱ta̱.>> ");
INSERT INTO tsw_vpl VALUES ("S130_25","010_30_25","1SA","30","25","25","Da̱wuda zuwa yi ta̱ wo o'wo wila̱ ni ili i na a̱ kuru uba̱ta̱ wa aza a Isra'ila diga urana u ndolo hali a cina ana'an. ");
INSERT INTO tsw_vpl VALUES ("S130_26","010_30_26","1SA","30","26","26","Ana Da̱wuda rawai Ziklag, u lyungu ta̱ akapi a̱tsuma̱ e ili i na a̱ pura̱i a̱ tyo uba̱ta̱ a̱ n'utsa̱ ma̱ yi, mbara ma Yahuda, u damma, <<Nda une'e u ɗu diga e itana i na tsu pura̱i uba̱ta̱ wu uvon uba̱ta̱ wu n'yuwatan ma̱ A̱sulazuva.>> ");
INSERT INTO tsw_vpl VALUES ("S130_27","010_30_27","1SA","30","27","27","Nda ala e ilyuci i na Da̱wuda lyunguwa̱ yi une'e, Betel na̱ Ramot a̱tsuma̱ e Nege na̱ Yati ");
INSERT INTO tsw_vpl VALUES ("S130_28","010_30_28","1SA","30","28","28","na̱ Arowa na̱ Sifamo na̱ Eshitemowa ");
INSERT INTO tsw_vpl VALUES ("S130_29","010_30_29","1SA","30","29","29","na̱ Rakal ni ilyuci ya aza a Yerameyel ni ilyuci ya̱ a̱za̱ a̱ Keni ");
INSERT INTO tsw_vpl VALUES ("S130_30","010_30_30","1SA","30","30","30","na̱ Homa na̱ Bor Ashan na̱ Atak ");
INSERT INTO tsw_vpl VALUES ("S130_31","010_30_31","1SA","30","31","31","na̱ Heburon na̱ suru uba̱ta̱ u na Da̱wuda na ali o uvon a̱ yi a garusai. ");
INSERT INTO tsw_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","Ele lo reve aza a Filistiya a yuwisan uvon na aza a Isra'ila, hali she na aza a Isra'ila a sumai. Amma o una ta̱ ali o uvon a Isra'ila na̱ a̱bunda̱ a Masasan ma Gilbowa. ");
INSERT INTO tsw_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","A̱vu aza a Filistiya a saɓusa Shawulu na̱ olobo yi, reve o una olobo a ta'atsu yi Jonata na̱ Abinada na̱ Malkishuwa. ");
INSERT INTO tsw_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Uvo'on u suɗuwa ta̱ Shawulu. Ali o uvon a na a̱ da̱na̱i na̱ tan na aya a̱ tsura̱ ta̱ a tawan yi waru a amaton yi ta̱ lon. ");
INSERT INTO tsw_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","A̱vu Shawulu damma vuma na a̱a̱ guzusa̱a̱ yi itana yu uvon, <<Vu tala matsun me pe'eni ma̱ wu reve vu una mu, ta̱wa̱ a̱za̱ o ulambu wu upaɗu wu uryumbu a nda a yuwan mu ulamu o una mu wan.>> Vuma na gba guzusa̱a̱ niyi itana yu uvoꞌon u 'yuwan ta̱ adama a na wu uwwa ta̱ wovon lon. Ɗaɗa gba Shawulu tala yi matsun me pe'eni ma̱ yi, reve u riya̱a̱ yi wu una aciya ya̱ yi. ");
INSERT INTO tsw_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Ana za na a̱ guzusa̱a̱ yi itana yu uvon enei Shawulu kuwa̱ ta̱, a̱vu a̱yi fo u riya̱a̱ matsun me pe'eni ma̱ yi a̱vu u kuwa̱ oɓolo na̱ a̱yi. ");
INSERT INTO tsw_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","Ne ɗa Shawulu kuwa̱i, no olobo a ta'atsu a̱ yi, na̱ za na tsu guzusa̱a̱ yi itana yu uvon, na̱ ali o uvon a̱ yi suru a̱ kuwa̱ ta̱ urana u ta̱ oɓolo. ");
INSERT INTO tsw_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","Mantsa ma na aza a Isra'ila aza a na a̱ ri mavada mo o upasu wu Uka̱ri wa Yezireyel na̱ mavada mo Uɗolu wa̱ Urudu a uwwai, na a ɗa a na Shawulu no olobo a ta'atsu a̱ yi a̱ kuwa̱ ta̱, waru a uwwai a na a̱soja a Isra'ila a sumai, reve e le fo a suma a lyawa ilyuci i le. A̱vu aza Filistiya a̱ ta̱wa̱ a̱ da̱nu pe. ");
INSERT INTO tsw_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","Ana usana u tawai, a na aza a Filistiya a̱ ta̱wa̱i a̱ pura̱ itana ya̱ a̱kwa̱kwa̱'a̱, a̱vu a cina Shawulu no olobo a ta'atsu a̱ yi nven ukwa̱ zuva Masasan ma Gilbowa. ");
INSERT INTO tsw_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","Ɗaɗa o koɗoi aci a Shawulu a̱vu a̱ pura̱ itana yu uvon ya̱ yi, reve a̱ lyungu nlingata e iɗa ya Filistiya ma̱ɓula̱ a damma alabari a̱tsuma̱ o u'wa wa̱ a̱ma̱li e le nu uba̱ta̱ wa ama e le suru. ");
INSERT INTO tsw_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","A̱vu a zuwa itana yu uvon ya̱ yi a̱tsuma̱ o u'wa wa̱ a̱ma̱li a Ashitore, reve a̱ sa̱ga̱do lipu va̱ yi o uɓaɓu u lyuci wa Bet Shan. ");
INSERT INTO tsw_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","Ana aza a na a̱ ri na̱ nden Jabe Giliyadu a uwwai ili i na aza a Filistiya a yuwain na̱ Shawulu, ");
INSERT INTO tsw_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","suru ali o uvon o ukadu le a̱ 'yon ta̱ a̱vu a̱ 'ya̱wa̱ na ayin a tara lipu va Shawulu na̱ lipu vo olobo a̱ yi diga o uɓaɓu wa Bet Shan, a̱vu a̱ tyowetyo le Jabe a̱vu a̱ kula̱to le ɗe. ");
INSERT INTO tsw_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","Reve a̱ pura̱ etele e le reve a̱ ciɗo le e ikyun yu uɗanga u na a̱ tsu ɗe tamari ɗe Jabe, avu a yuwan akuli rana cindere adama o a̱tsuma̱la̱ngu.");
INSERT INTO tsw_vpl VALUES ("MC1_1","034_1_1","MIC","1","1","1","A̱sulazuva a ca ta̱ Mika vuma va Moreshete adanshi e ikaka i nda a̱tsuma̱ alavu alavu adama a Samariya na̱ Urishelima a mantsa ma̱ tsugono ma Yotam na̱ Ahaz na̱ Hezekiya ngono ma Yahuda. ");
INSERT INTO tsw_vpl VALUES ("MC1_2","034_1_2","MIC","1","2","2","Uwwai, a̱ɗu ama o uvaɗi suru, polo atsuvu vu uwwa, a̱vu uvaɗi ni ili i na i ri pe a̱tsuma̱ wu suru. Lyawa A̱sulazuva Zagbain A̱sula̱ diga A̱a̱'isamapaɗa a akiza a̱yi wo o'wo, iroci a aci a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("MC1_3","034_1_3","MIC","1","3","3","I reve, A̱sulazuva a̱ ta̱ ta̱wa̱ diga o uba̱ta̱ a̱ nden ma akiza a̱ yi. U ta̱ cipa̱ reve u dadasa ba̱ta̱ va̱ a̱ga̱nda̱ o uvaɗi. ");
INSERT INTO tsw_vpl VALUES ("MC1_4","034_1_4","MIC","1","4","4","Nsasan n ta̱ jeruwe za̱la̱ va apata ana a̱ yi waru ka̱ri ta ɓatsa cine abaji e ishiki a tsu jejeruwe o una̱ wa akina, reve u ka̱ra̱ e ilaɗi a̱ cipa̱ cine o tsu oco mini diga a agaɗi. ");
INSERT INTO tsw_vpl VALUES ("MC1_5","034_1_5","MIC","1","5","5","Ili i nda suru adama o unusu wa Yakubu u ɗa na̱ nusu va Isra'ila. Nyen ɗa unusu wu ugundo wa Yakubu? Ashe mayan ma̱ a̱ga̱nda̱ ma̱ a̱ma̱li a Samariya ɗa shi? A te ɗa gba ba̱ta̱ va̱ a̱ga̱nda̱ va Yahuda ri? Ashe a̱tsuma̱ a Urishelima ɗa a̱ ri shi? ");
INSERT INTO tsw_vpl VALUES ("MC1_6","034_1_6","MIC","1","6","6","<<Adama o ndolo n ta̱ ka̱mba̱to Samariya oɓolo e edemu a̱ rulu, wo'o tsu uba̱ta̱ u na a̱ tsu cu'wa̱n a̱ɗuma̱ a̱ ina̱bi. Waru n ta gandalato atali a̱ yi a̱ tyo o uka̱ri reve waru n za̱ɓa̱luwa̱ atali e ikyun a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("MC1_7","034_1_7","MIC","1","7","7","N to ɓoɓoso a̱ma̱li a̱ yi a na a̱ zuɗa̱i, a̱ ta̱ kula̱to utsuru wa̱ yi na akina, n ta̱ kototo a̱ma̱li a̱ yi suru, adama a na a̱ tsura̱ le ta̱ diga o ure u tsushakala, waru a̱ ta̱ a̱ ka̱mba̱ o ure u tsu tsushakala'a.>> ");
INSERT INTO tsw_vpl VALUES ("MC1_8","034_1_8","MIC","1","8","8","A̱vu Mika damma, <<Adama e ili i nda, n ta yuwan a̱tsumola̱ngu reve n shon, n foɗo itana n wala ataɓu. N ta̱ shon tsa̱ musa̱n mu una, waru n yuwan a̱tsumola̱ngu tsa azamina, ");
INSERT INTO tsw_vpl VALUES ("MC1_9","034_1_9","MIC","1","9","9","Adama a na antsu a Samariya aza a na e ina ɗa shi, hali fo u ju'wa̱n Yahuda, waru u rawa ta̱ a̱ na̱ntsu va ama a̱ va̱, hali a uwa Urishelima.>> ");
INSERT INTO tsw_vpl VALUES ("MC1_10","034_1_10","MIC","1","10","10","She a yuwan adanshi a̱ yi a̱tsuma̱ a Gat wan, ko ke'en she a̱ shon wan. Amma a̱ɗu a̱za̱ Bet Leyafara i gandala a̱ ma̱buta̱ goon. ");
INSERT INTO tsw_vpl VALUES ("MC1_11","034_1_11","MIC","1","11","11","A̱ɗu ama a Shafiri, i yuwan n manlu ataɓu na̱ a̱tsuma̱ o wono. Ama a Za'anan gba she yu uta̱ wan. Bet Eze na ama a̱ yi a̱ te e mesun ya̱ tsura̱ ikambi e ekere a̱ yi shi. ");
INSERT INTO tsw_vpl VALUES ("MC1_12","034_1_12","MIC","1","12","12","Adama a na ama a Maroto a ta pura isa'ani na̱ meje'en. Agba iwuya diga uba̱ta̱ wa̱ A̱sulazuva a̱ cipa̱ ta̱ o una̱ntsu wa Urishelima. ");
INSERT INTO tsw_vpl VALUES ("MC1_13","034_1_13","MIC","1","13","13","A̱ɗu ama a Lakish, i foɓo ikeke yi ido i ɗu, adama a na a̱ a̱tsura̱ ta̱ unusu wa Isra'ila a̱tsuma̱ a̱ ɗu. Hali na u zuwai Sihiyona mayan mo unusu gayin. ");
INSERT INTO tsw_vpl VALUES ("MC1_14","034_1_14","MIC","1","14","14","Adama o ndolo, i ca ama Moreshete Gat ne'en vu ukosu. Waru lyuci va Akizibi ta̱ pura̱ ugbozu wu ngono ma Isra'ila. ");
INSERT INTO tsw_vpl VALUES ("MC1_15","034_1_15","MIC","1","15","15","Reve A̱sulazuva a damma, n ta̱ ta̱wisa̱ na̱ za na a lyuwa ɗu nu uvon, aza a na a̱ ri na̱ nden a̱tsuma̱ a Maresha. Tsugbain tsa Isra'ila tsa̱ ta̱ ka̱mba̱ e ekere a Adulam. ");
INSERT INTO tsw_vpl VALUES ("MC1_16","034_1_16","MIC","1","16","16","A̱vu Yahuda, vu puna aciya̱wu ogbondo adama a̱tsuma̱la̱ngu a̱ muwun ma̱ wu n na vu cigai. Vu puna aciya̱wu ogbondo vo o'wo tsa̱ a̱a̱kuru, adama a na muwun ma̱ wu n ta̱ 'ya̱wa̱ tsugbashi e iɗa i ro. ");
INSERT INTO tsw_vpl VALUES ("MC2_1","034_2_1","MIC","2","1","1","A̱tsuma̱lima̱ a ta cina aza a na o foɓuso iwuya, e le na o foɓuso iwuya na ayin! Nu usana u tawa, a̱ tsu uta̱ ta̱ a yuwan iwuya'a, adama a na ucira u mayan me iwuya'a u ta̱ e ekere e le. ");
INSERT INTO tsw_vpl VALUES ("MC2_2","034_2_2","MIC","2","2","2","A tsu yuwan ta̱ tsushu'un vu ɗuma̱ reve a usa le, na̱ tsushu'un vu 'wa reve fo a usa le. A tsu tsugba ta̱ vuma, reve a usa u'wa wa̱ yi ni ili ya agadu a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("MC2_3","034_2_3","MIC","2","3","3","Adama o ndolo ɗa A̱sulazuva a dammai, <<Gogo n to foɓuso addama a aci a̱ cu'un va ama a nda, za na aa gura uta̱a̱ aciyele a̱tsuma̱ a̱ yi shi. Waru aa gura yuwan mmalu na afalu shi, adama a na mantsa mo uyo'o u ɗa shi. ");
INSERT INTO tsw_vpl VALUES ("MC2_4","034_2_4","MIC","2","4","4","O urana u ndolo a ta cana ishipa ya avandaru a aci a̱ ɗu, reve a yuwan mesun ma̱ a̱tsumola̱ngu lon adansa, <Za tsu koto ta̱! U kita'wa ta̱ akunda a ama a̱ va̱, u tawa le ta̱ e ekere a̱ va̱. A̱sulazuva e ne'eshen ta̱ ɗuma̱ tsu, e ekere a ama a na a lyuwa n tsu nu uvon.> >> ");
INSERT INTO tsw_vpl VALUES ("MC2_5","034_2_5","MIC","2","5","5","Adama o ndolo ya̱ tsura̱ za, diga a̱tsuma̱ oɓolo a ama A̱sulazuva na eneshe iɗa'a o ure u mazuwa ma agita shi. ");
INSERT INTO tsw_vpl VALUES ("MC2_6","034_2_6","MIC","2","6","6","Reve ama̱sula̱ e le a damma, <<She vu yuwan adanshi e ikaka i nda wan.>> <<She vu yuwan adanshi e ikaka i nda wan, Ili i wono yi lo na ya cina tsu shi!>> ");
INSERT INTO tsw_vpl VALUES ("MC2_7","034_2_7","MIC","2","7","7","<<U ta̱ ulobono ama a Yakubu a damma, <Ruhu va̱ A̱sulazuva lamba ta̱ ankuri? Linga va̱ yi ɗa nda'a?> >> <<Ashe adanshi a̱ va̱ a tsu yuwan urana e ekere aza na o toni niyi mejege shi?>> ");
INSERT INTO tsw_vpl VALUES ("MC2_8","034_2_8","MIC","2","8","8","Reve A̱sulazuva a̱ usu le u damma, <<Babu usa̱n ama a̱ va̱ a̱ tsu 'yon ta̱ tsa n'yuwatan, tsa aza a na a̱ ri a̱ ma̱ka̱mba̱a̱ diga uba̱ta̱ wu uvon, o foɗoso a̱tugu aza na ili i burai shi. ");
INSERT INTO tsw_vpl VALUES ("MC2_9","034_2_9","MIC","2","9","9","I loso ta̱ a̱ma̱ci a ama a̱ va̱ diga a 'wa sa'ani le. Reve i tara tsugbain tsa̱ va̱, diga a̱ muwun n le suru hali hali. ");
INSERT INTO tsw_vpl VALUES ("MC2_10","034_2_10","MIC","2","10","10","Gogo a̱ɗu a̱za̱ a̱ɓula̱, 'yoyin, i ka̱ra̱, adama a na uba̱ta̱ u nda uba̱ta̱ u wivuwun u ɗa shi. Adama a na iɗa'a wo o'wo ta̱ idaba. ");
INSERT INTO tsw_vpl VALUES ("MC2_11","034_2_11","MIC","2","11","11","Na̱ vuma 'yon reve u reme epen a dansa, <N ta yuwan ɗu alajiya adama a masayan ma̱ ina̱bi ni ili i na i tsu tsura̱to.> To, a̱ yi ɗa wo o'wo za va alajiya a ama a nda'a.>> ");
INSERT INTO tsw_vpl VALUES ("MC2_12","034_2_12","MIC","2","12","12","<<Adanshi o ro o lo shi, n to ɓoloto ɗu a̱za̱ o ugundo wa Yakubu, waru n to ɓoloto akapi ama a Isra'ila a na a buwai. N to ɓolo ɗu tso oɓolo e ikyon uba̱ta̱ wa aguta, tso oɓolo e ikyon uba̱ta̱ wa alyuna. I to o'wo a̱ba̱jini oɓolo a ama a na a uwwa elemu e le.>> ");
INSERT INTO tsw_vpl VALUES ("MC2_13","034_2_13","MIC","2","13","13","A̱yi za na a̱ ba̱ma̱ ukari, u to rono le a aaɗanga reve a̱ uta̱la̱i nu uba̱ta̱'a̱. U to o'wo le una̱ntsu u mo uta̱. Mogono me le ma̱ ta̱ ka̱ra̱ elime e le. A̱sulazuva na aciya̱yi a ɗa wo rono le a aaɗanga. ");
INSERT INTO tsw_vpl VALUES ("MC3_1","034_3_1","MIC","3","1","1","Poloi atsuvu yu uwwa, a̱ɗu azagbain o ugundo a Yakubu, a̱ɗu a̱za̱ o tsugono tsu u'wa wa Isra'ila! Ashe wuntsaa i reve uge'etosu wa amayun shi? ");
INSERT INTO tsw_vpl VALUES ("MC3_2","034_3_2","MIC","3","2","2","A̱ɗu na i 'yuwain ili i na i ri ulobonu, reve i ciga iwuya. a̱ɗu na ya munusa ukwan u lipu wa ama a̱ va̱, a̱ɗu na ya tawusa inama i lipu i le diga etele e le. ");
INSERT INTO tsw_vpl VALUES ("MC3_3","034_3_3","MIC","3","3","3","A̱ɗu na ya tamusa inama ya ama a̱ va̱, reve i ka̱ra̱ a munusa kwan lipu le, a kukuɗusa etele e le, ni paɗasai inama i lipu i le vadama a̱ ta̱ tsun le o upondo na a su'wan. ");
INSERT INTO tsw_vpl VALUES ("MC3_4","034_3_4","MIC","3","4","4","A̱vu nda gogo i ciga i showen A̱sulazuva, i reve gba wa̱ usu ɗu shi. A mantsa'a, u to sokowo ɗu urewesu wa̱ a̱ yi adama a na i yuwain iwuya. ");
INSERT INTO tsw_vpl VALUES ("MC3_5","034_3_5","MIC","3","5","5","Apa ili i na A̱sulazuva a dammai e ekere ama̱sula̱ a na a zuwai ama a̱ va̱ a̱ puwa̱yin, aza a na a̱ 'ya̱sa̱sa̱n ɗyo a dansa, <<<Nden ma asuvu> a mantsa ma na a ca nle ilyalya. Agba a dansa, <uvon> e ekere aza a na ca nle ili shi. ");
INSERT INTO tsw_vpl VALUES ("MC3_6","034_3_6","MIC","3","6","6","Adama o ndolo, a̱ɗu ama̱sula̱, ili suru i to o'wo ɗu ayin, alavu alavu a̱ da̱na̱ lo shi, Irumbu i ɗa yo o'wo ɗu, i buwa a yuwan walu shi. Urana u ta̱ riya̱ ɗu a aci a̱ ɗu ama̱sula̱ a nda, ulivu u to o'wo ɗu irumbu picim. ");
INSERT INTO tsw_vpl VALUES ("MC3_7","034_3_7","MIC","3","7","7","A̱ɗu a̱za̱ a̱ yindi, i ta uwwa wono, aza a walu a̱ ta̱ ra̱pula̱. Suru n ɗu i ta̱ ɓa̱ru na̱ ɗu, adama a na A̱sula̱ a uwwa ɗu shi. >> ");
INSERT INTO tsw_vpl VALUES ("MC3_8","034_3_8","MIC","3","8","8","A̱mu gba shi, n ta̱ tapu nu ucira nu Ruhu va A̱sulazuva. N ta̱ tapu nu ugbamu wa asuvu u na ma yuwan uge'etosu wa amayun. Babu wovon n ta damma Yakubu ulinga wu ulambu wa̱ a̱ɓula̱ a̱ yi alanga eteshe. Isra'ila waru n damma yi unusu wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("MC3_9","034_3_9","MIC","3","9","9","Uwwai ili i nda, azagbain o ugundo wa Yakubu, na̱ a̱za̱ o tsugono tsu u'wa wa Isra'ila, a̱ɗu na ya 'yuwusan uge'etosu wa amayun reve i vadala amayun suru. ");
INSERT INTO tsw_vpl VALUES ("MC3_10","034_3_10","MIC","3","10","10","A̱ɗu na i suwai Sihiyona na̱ mpasa, Urishelima gba nu unusu. ");
INSERT INTO tsw_vpl VALUES ("MC3_11","034_3_11","MIC","3","11","11","Azagbain o u'wa wa Yakubu a̱ ta̱ ushishi utowusu wu una̱ na paɗa ugana o uge'etosu. Nan ganu a ta yuwusan uritosu adama a̱ tsura̱ ili i na ya uwa le, waru ama̱sula̱ a̱ yi a ta yuwusan adanshi adama a̱ tsura̱ ikebe. Agba suru na̱ ne a ta majiyan A̱sulazuva a̱ ta̱ ɓolo na̱ e le a dansa, <<Ee, A̱sulazuva a̱ te e memere ma̱ tsu, upepu ucingi wu lo na wa faba tsu shi. ");
INSERT INTO tsw_vpl VALUES ("MC3_12","034_3_12","MIC","3","12","12","Adama a̱ ɗu, aa ta cimba Sihiyona tsu uɗuma̱, Urishelima gba to o'wo oɓolo o okongo. Aagaɗi a na A̱a̱'isamapaɗa a̱ ri u to o'wo olopu.>> ");
INSERT INTO tsw_vpl VALUES ("MC4_1","034_4_1","MIC","4","1","1","A mantsa mo ukosu, masasan ma na u'wa wa̱ A̱sulazuva a̱ ri u to o'wo masasan ma na ma la'ai a̱ɓula̱ suru suru. A ta cuwa yi ulawu na̱ nsasan na agaɗi suru. Nɗa n ta̱ da̱na̱ a sumusa a̱ 'ya̱wusa̱ ɗe. ");
INSERT INTO tsw_vpl VALUES ("MC4_2","034_4_2","MIC","4","2","2","Nɗa na̱ a̱bunda̱ a̱ ta̱ ta̱wa̱ a damma, <<Ta̱wa̱ yi, tsu kumbai masasan ma A̱sulazuva, a̱ 'ya̱wa̱ o u'wa wa̱ A̱sula̱ a Yakubu, adama u roco tsu re va̱ yi, tsura̱ a̱tsu fo tsu yuwan mmalu o ure wa̱ yi. >> Adama a na uritosu wa̱ A̱sulazuva u ta̱ o uta̱ diga Sihiyona, waru adanshi A̱sula̱ a̱ ta̱ ta̱wa̱ diga Urishelima. ");
INSERT INTO tsw_vpl VALUES ("MC4_3","034_4_3","MIC","4","3","3","A̱sulazuva a̱ ta̱ ge'eto ama o uvaɗi a̱bunda̱. Waru u ta̱ ge'eto nɗa m gbain gbain. A ta ruma mutsun mu pe'eni n le a̱ ka̱mba̱to le a̱ba̱ri e iluma, ibata i le waru a ta ruma le a̱ ka̱mba̱to le mutsun n wukoɗu wu ɗanga. Nɗa n buwa o uta̱ a̱ 'ya̱wa̱ uvon shi, waru a̱ da̱shi rito uvon shi. ");
INSERT INTO tsw_vpl VALUES ("MC4_4","034_4_4","MIC","4","4","4","Vuma suru ta̱ da̱nu e ikyun ya ataci a ina̱bi a̱ yi, na̱ e ikyun yu uɗanga vu biri va̱ yi na asuvu nden. Za lo na da'waton yi shi, adama a na A̱sulazuva oɓolo a̱ a̱soja a zuva a ɗa a dammai ne. ");
INSERT INTO tsw_vpl VALUES ("MC4_5","034_4_5","MIC","4","5","5","Ko na wo o'woi nɗa suru n ta̱ kurusu musula̱ n le, amma a̱tsu tsu ta̱ toni A̱sulazuva A̱sula̱ a̱ tsu. ");
INSERT INTO tsw_vpl VALUES ("MC4_6","034_4_6","MIC","4","6","6","Reve A̱sulazuva a damma, <<O urana u ndolo, n to oɓoloto aza a na a̱ pura̱i a̱ tyo tsugbashi waru n to ɓoloto aza a na o losoi, na aza a na n cayi a̱tsuma̱lima̱. ");
INSERT INTO tsw_vpl VALUES ("MC4_7","034_4_7","MIC","4","7","7","N ta̱ ka̱mba̱to aza a na a̱ pura̱i a̱ tyo tsugbashi na la'ai ama a̱ va̱, aza a na o losoi o'wo iɗa yu ucira. A̱mu A̱sulazuva n ta yuwan tsugono a aci e le a masasan ma Sihiyona diga gogo hali hali. ");
INSERT INTO tsw_vpl VALUES ("MC4_8","034_4_8","MIC","4","8","8","A̱vu usa wu uga'an wu uba̱ta̱ e ipiri yi ikyon, uba̱ta̱ wu upa'anta wu ucira wa Sihiyona a aci a̱ wu a ɗa tsugono tsu ufaru tsa̱ a̱ ka̱mba̱, tsugono'o u ta̱ ka̱mba̱ Urishelima.>> ");
INSERT INTO tsw_vpl VALUES ("MC4_9","034_4_9","MIC","4","9","9","Gogo nye i zuwai vu ri a yisali nu ucira? Mogono me pe a̱tsuma̱ a̱ wu gogo shi? Za na a casu wu a̱sa̱la̱ a̱ kuwa̱ ta̱ ɗa? A̱yi ɗa ili i na i zuwai a̱tsuma̱lima̱ a̱ riya̱ nuwu tsa ka na ri a uwwusa mɓa̱la̱ n limatan? ");
INSERT INTO tsw_vpl VALUES ("MC4_10","034_4_10","MIC","4","10","10","Vu yuwan ma̱nga̱ vu sala a̱vu Sihiyona, tsa ka na ri a̱ a̱tsuma̱lima̱ a̱ mɓa̱la̱ n limatan. Adama a na gogo vu ta̱ o uta̱ pe a̱tsuma̱ a̱ lyuci'i reve vu da̱nu oogodo aagalaci o ugyuru. Vu ta̱ ka̱ra̱ a̱ tyo Babila. Diga ɗe ɗa A̱sulazuva a wawa wu diga e ekere a n'yuwatan ma̱ wu. ");
INSERT INTO tsw_vpl VALUES ("MC4_11","034_4_11","MIC","4","11","11","Gogo, nɗa na̱ a̱bunda̱ o ɓoloto ta̱ e reme tsushu'un na̱ a̱ vu a dansa, <<Lyawa a̱ lungusa̱ yi, lyawa tsu zuwa esu a aci a Sihiyona.>> ");
INSERT INTO tsw_vpl VALUES ("MC4_12","034_4_12","MIC","4","12","12","Agba a̱ reve majiyan ma A̱sulazuva shi, waru e reve ifoɓi ya̱ yi shi, na wo ɓoloto le tsa aakatalu e ishina shi, tsi ishina i na o ɓolotoi o osoroto a na a faba. ");
INSERT INTO tsw_vpl VALUES ("MC4_13","034_4_13","MIC","4","13","13","Reve A̱sulazuva a damma, <<A̱vu Sihiyona aaɗanga o usuɗa 'yon vu yuwan usuɗa. Adama a na n ta ca wu ucira tsa̱ rumu no ookotsu e irumushili. Vu ta̱ lungusa̱ nɗa na̱ a̱bunda̱, a̱vu vu ca utsuru u le uba̱ta̱ wa̱ A̱sulazuva o uvaɗi suru.>> ");
INSERT INTO tsw_vpl VALUES ("MC5_1","034_5_1","MIC","5","1","1","Gogo, vu ɓoloto a̱ a̱soja a̱ wu adama a na a̱ ka̱nda̱ruwa̱ tsu ta̱ nu uvon. Waru a ta faba mogono ma Isra'ila na aaɗanga o ugbaguzu. ");
INSERT INTO tsw_vpl VALUES ("MC5_2","034_5_2","MIC","5","2","2","A̱vu A̱sulazuva a damma, <<A̱vu lyuci va Batalami va Efarata, a̱tsuma̱ o ugundo wa Yahuda wa'a ɗa vu ri, agba a̱tsuma̱ a̱ wu n ta̱ o uta̱a̱ vuma na a yuwan tsugono tsa Isra'ila, za na ri nu ugundo ɗe ɗe, za na ri ɗe ɗe a̱ ta̱wa̱.>> ");
INSERT INTO tsw_vpl VALUES ("MC5_3","034_5_3","MIC","5","3","3","Adama o ndolo A̱sulazuva a̱ ta̱ uta̱ aɗa a ama a̱ yi, hali she na a matsan za tsugono'o, waru she na ama a 'wa va̱ yi a̱ ka̱mba̱ a̱tsuma̱ a Isra'ila. ");
INSERT INTO tsw_vpl VALUES ("MC5_4","034_5_4","MIC","5","4","4","Tsa za va aguɓa, u ta̱ e idana ama a̱ yi, nu ucira u na wu uta̱i diga uba̱ta̱ wa̱ A̱sulazuva, a̱tsuma̱ a tsugbain tsa̱ aala A̱sulazuva A̱sula̱ a̱ yi. Ama a̱ yi a̱ ta̱ da̱nu gbaga, adama a na a̱ ta̱ reve nu ucira wa aala a̱ yi a̱tsuma̱ o uvaɗi suru. ");
INSERT INTO tsw_vpl VALUES ("MC5_5","034_5_5","MIC","5","5","5","Waru u to o'wo asuvu nden n tsu, a mantsa ma na ama a Asuriya a̱ riya̱a̱ iɗa i tsu nu uvon, hali a̱ ba̱ma̱ kari tsu, tsu ta zuwa a̱za̱ o uka̱lyusa̱ e cindere, oɓolo na azagbain kunla̱ a yuwan uvon ne le, ");
INSERT INTO tsw_vpl VALUES ("MC5_6","034_5_6","MIC","5","6","6","na a yuwan tsugono tsa Asuriya na̱ matsun me pe'eni. Nimro waru na̱ matsun mepe'eni ma na a talai. Waru u ta wawa tsu diga e ekere aza a Asuriya, a mantsa ma na a̱ ta̱wa̱yi iɗa i tsu nu uvon, ko na̱ shi a uwa o tyo wi iɗa i tsu. ");
INSERT INTO tsw_vpl VALUES ("MC5_7","034_5_7","MIC","5","7","7","Akapi o ugundo wa Yakubu na la'ai o to o'wo a̱tsuma̱ a ama na̱ a̱bunda̱, tsa a'iza na a̱ ta̱wusa̱ diga uba̱ta̱ wa̱ A̱sulazuva, tsa̱ yiji'in a anlya, za na tsu puro za shi ko u zuwa ucira uba̱ta̱ wu vaɗilima̱ shi. ");
INSERT INTO tsw_vpl VALUES ("MC5_8","034_5_8","MIC","5","8","8","Akapi o ugundo wa Yakubu na la'ai o to o'wo a̱tsuma̱ a ama na̱ a̱bunda̱, tsa a kamu e memere me inama yu una yo ogozo, tsa kamu vu ucira e memere mo oɓolo e ikyon, za na nu wu 'yawan a̱vu u riya̱a̱ le, waru za lo na wawa le shi. ");
INSERT INTO tsw_vpl VALUES ("MC5_9","034_5_9","MIC","5","9","9","Ukere wa̱ wu u ta la'a ucira wu n'yuwatan ma̱ wu, waru a̱ ta̱ kototo n'yuwatan ma̱ wu! ");
INSERT INTO tsw_vpl VALUES ("MC5_10","034_5_10","MIC","5","10","10","Reve A̱sulazuva a damma, <<O urana u ndolo u ɗa mo una ido i ɗu waru n kototo ikeke yi ido i ɗu. ");
INSERT INTO tsw_vpl VALUES ("MC5_11","034_5_11","MIC","5","11","11","N ta̱ kototo ilyuci yi iɗa i ɗu waru mu ɓoso pa'atan vu ucira ɗu. ");
INSERT INTO tsw_vpl VALUES ("MC5_12","034_5_12","MIC","5","12","12","N ta̱ gba o kototo a̱za̱ a̱ nkunu a̱ ɗu, waru ya̱ da̱shi tsura̱ boci shi. ");
INSERT INTO tsw_vpl VALUES ("MC5_13","034_5_13","MIC","5","13","13","N ta̱ fo o kototo a̱ma̱li a̱ ɗu na atali a̱ga̱nda̱ a na a̱ ri a̱tsuma̱ a̱ ɗu. Ya̱ da̱shi ka̱ɗa̱towa̱a̱ ili i na i yuwain ne e ekere a̱ ɗu shi. ");
INSERT INTO tsw_vpl VALUES ("MC5_14","034_5_14","MIC","5","14","14","N ta̱ mumula̱ a̱ma̱li a ka Ashera na a̱ ri a̱tsuma̱ a̱ ɗu a mantsa ma na n kototoi ilyuci i ɗu. ");
INSERT INTO tsw_vpl VALUES ("MC5_15","034_5_15","MIC","5","15","15","Na asuvu usuɗu u ɗa ma tsupa nɗa n na n 'yuwain a yuwan tsutoni na̱ a̱mu.>> ");
INSERT INTO tsw_vpl VALUES ("MC6_1","034_6_1","MIC","6","1","1","Uwwai ili i na A̱sulazuva a dammai Isra'ila: << 'Yon vu 'ya̱wa̱ na adanshi a̱ va̱ eleme a nsasan, lyawa agaɗi a uwwa ili i na vaa damma.>> ");
INSERT INTO tsw_vpl VALUES ("MC6_2","034_6_2","MIC","6","2","2","Uwwai a̱ ɗu nsasan ili i na A̱sulazuva a yuwusan adanshi a aci a̱ ɗu, poloi atsuvu a̱ ɗu nkyun mu uvaɗi. Adama a na A̱sulazuva a̱ ta̱ na adanshi a aci a ama a̱ yi, u ta karishi Isra'ila ana. ");
INSERT INTO tsw_vpl VALUES ("MC6_3","034_6_3","MIC","6","3","3","<<Ama a̱ va̱, nye i ɗa n yuwaan nɗu? Cine tsa ɗa n damaton nɗu? Usu numu! ");
INSERT INTO tsw_vpl VALUES ("MC6_4","034_6_4","MIC","6","4","4","A̱mu ɗa mu uta̱a̱ nɗu a̱tsuma̱ e iɗa ya Masar reve n wawa ɗu diga e iɗa i tsugbashi. A̱mu ɗa n lyunguyi Musa na̱ Haruna na̱ Maryamu o rono ɗu aaɗanga. ");
INSERT INTO tsw_vpl VALUES ("MC6_5","034_6_5","MIC","6","5","5","Ama a̱ va̱, cuwain ili i na Mogono Balak ma Mowa mo foɓoi ni ili i na Balam mawun ma Beyo ma̱ usu niyi. Cuwain na̱ mmalu n ɗu diga Shitim a̱ tyo Gilga, adama i reve nu ulinga wa̱ a̱ɓula̱ wa̱ A̱sulazuva.>> ");
INSERT INTO tsw_vpl VALUES ("MC6_6","034_6_6","MIC","6","6","6","Na̱ nye ma̱ ta̱wa̱ a̱ ma̱ka̱ka̱n ma A̱sulazuva n yuwan a̱ga̱nda̱ a̱ ma̱ka̱ka̱n ma̱ A̱sula̱ a gbain? N ta̱ ta̱wa̱ a̱ ma̱ka̱ka̱n ma̱ yi na̱ kucci vu ukula̱tosu u ma̱dindim ma aa'wan a̱ ta̱? ");
INSERT INTO tsw_vpl VALUES ("MC6_7","034_6_7","MIC","6","7","7","Ko A̱sulazuva a ta uwwa uyo'o wa̱ a̱giri'i ukpakukupa kupa va̱ a̱bunda̱, na̱ ɗolu mani'in ma̱ zetun ɗa? Ko n ta ca mawun mo ufaru ma̱ va̱ kucci vu unusu u va̱, ko mpasa n va̱ adama o unusu u wuma u va̱? ");
INSERT INTO tsw_vpl VALUES ("MC6_8","034_6_8","MIC","6","8","8","O'o vaɗilima̱, A̱sulazuva o roco wu ta̱ ɗe ili i na i ri ulobonu. Gogo ili i na A̱sulazuva a cigai ya̱'a̱ wu, a̱yi ɗa vu yuwan mejege, a̱vu vu ciga mayan me iliyali, vu ka̱ɗa̱to vu yuwan mmalu na̱ A̱sula̱ a̱ wu. ");
INSERT INTO tsw_vpl VALUES ("MC6_9","034_6_9","MIC","6","9","9","Poloi atsuvu! A̱sulazuva a̱ ta̱ ɗewu va ama a̱ Urishelima. Ugbozu ɗa lon a uwwa wovon wa̱ A̱sulazuva! Uwwai a̱ ɗu ugundo oɓolo ni iɓolo ilyuci'i! ");
INSERT INTO tsw_vpl VALUES ("MC6_10","034_6_10","MIC","6","10","10","Ko n ta̱ e icina nu utsuru u na a̱ tsura̱i o ure wi iwuya o u'wa u vuma vi iwuya? Ko n ta̱ e icina na̱ makundatsu ma na a da̱da̱'wain? ");
INSERT INTO tsw_vpl VALUES ("MC6_11","034_6_11","MIC","6","11","11","Ko me ge'eto vuma na ri na̱ makundatsu me epen, na̱ buhu yipalishi shi? ");
INSERT INTO tsw_vpl VALUES ("MC6_12","034_6_12","MIC","6","12","12","A̱za̱ o utsuru a̱ lyuci ɗu, aza a na e le'eshe alambi a ɗa. Aza a na a̱ ri pe na̱ nden a̱ lyuci'i a̱za̱ epen a ɗa suru. ");
INSERT INTO tsw_vpl VALUES ("MC6_13","034_6_13","MIC","6","13","13","Adama o ndolo, n ta amaton ɗu, n ta̱ ka̱mba̱to ɗu okongo adama a̱ nusu ɗu. ");
INSERT INTO tsw_vpl VALUES ("MC6_14","034_6_14","MIC","6","14","14","I ta lyuwa, agba ya̱ cuwa̱n shi, a̱a̱tsuma̱ a̱ ɗu a̱ ta̱ da̱na̱ o upunda̱ra̱sa̱ adama a ambulu. I to ɓoloto wi ili, agba ya gura zuwa ili shi, ili i ke'en i na i zuwai waru, n ta̱ lungusa̱ le a̱tsuma̱ o uvon. ");
INSERT INTO tsw_vpl VALUES ("MC6_15","034_6_15","MIC","6","15","15","I ta̱ cu'wa̱n, agba ya yuwan ugasa shi. I ta pisha mani'in ma̱ zetun, agba ya yuwan ulinga na̱ mani'in ma̱ yi shi. I ta pisha matsun ina̱bi, agba yo sowo masayan ma̱ yi shi. ");
INSERT INTO tsw_vpl VALUES ("MC6_16","034_6_16","MIC","6","16","16","Adama a na i toni ta̱ re vama va Omri, na̱ linga vu u'wa wa Ahabu suru, reve i yuwan ulinga na̱ a̱sa̱la̱ e iwuya i le. Adama o ndolo, n ta̱ ka̱mba̱to ɗu okongo, waru a ama a̱ wu o'wo ili macuru. Ne ɗa, a̱ ɗu ama a̱ va̱, a 'yuwan na a cuwa ɗu uba̱ta̱ suru.>> ");
INSERT INTO tsw_vpl VALUES ("MC7_1","034_7_1","MIC","7","1","1","U yo'ono mu shi! Adama a na mo o'wo ta̱ tsa za vu u'yanlu, a mantsa ma na o kotoi ugasa, u muwun ma̱ ina̱bi. Maani ma̱ ina̱bi ma lo na a ta'an a lyuwa shi. Waru umatsun wu ufaru wu biri lo na okolo a̱ va̱ a cigai shi. ");
INSERT INTO tsw_vpl VALUES ("MC7_2","034_7_2","MIC","7","2","2","Ama a̱ a̱ɓula̱ o koto ta̱ a̱tsuma̱ o uvaɗi, za lo na buwai na ri no okolo asa'ani shi, za suru ta zama ure u na wo una za ro, za suru ta azusu moron ma̱ nden ma̱ yi ni igolo. ");
INSERT INTO tsw_vpl VALUES ("MC7_3","034_7_3","MIC","7","3","3","E veɗece ta̱ a yuwan iwuya ne ekere e le. Ngono n ta zama ne'en, a̱za̱ o uge'etosu a̱ ta̱ ushishi utowusu wu una̱, azagbain a tsu zuwa ta̱ a yuwan ili i na a cigai. Ne ɗa o ɓoloi una̱ suru. ");
INSERT INTO tsw_vpl VALUES ("MC7_4","034_7_4","MIC","7","4","4","Vuma va̱ a̱ɓula̱ le tsa awanda ɗa u ri, za va amayun a̱tsuma̱ e le u ta̱ tsu ubara u na a yuwain na awanda. Urana u na A̱sula̱ e ge'eto le yuwan ta̱, u rana u na a damma n le o una̱ wa ama̱sula̱ aza a na a yuwusan ipiri i le, gogo za suru wo o'wo ta̱ utogbolyuwu. ");
INSERT INTO tsw_vpl VALUES ("MC7_5","034_7_5","MIC","7","5","5","She vu zuwaa moron me nden ma̱ wu okolo wan waru vu soɗuwo i'utsa̱ ya̱ wu ma̱tsa̱n wan, vu goloɓo una̱ wa̱ wu a̱ tyo a ka va̱ wu na vu ri e icigi za na ri nven na̱ a̱vu. ");
INSERT INTO tsw_vpl VALUES ("MC7_6","034_7_6","MIC","7","6","6","Ama o u'wa u vuma, ele ɗa n'yuwatan ma̱ yi, adama a na ulobo u ta yuwaan dada va̱ yi ulamu, mawun mo usheli waru u ta̱ 'ya̱sa̱a̱n mma va̱ yi aci, jene ta yuwan tsushu'un na̱ a̱na̱wa̱ le fo. ");
INSERT INTO tsw_vpl VALUES ("MC7_7","034_7_7","MIC","7","7","7","A̱mu gba n ta zuwaa A̱sulazuva esu, n puro A̱sula̱ e iwawi i va̱, A̱sula̱ a̱ va̱ u ta uwwa mu. ");
INSERT INTO tsw_vpl VALUES ("MC7_8","034_7_8","MIC","7","8","8","A̱vu ma'yuwatan ma̱ va̱, she vu yuwan ma̱za̱nga̱ a aci a̱ va̱ wan, ko na wo o'woi n riya̱i n ta̱ 'yowisa̱n. A mantsa ma na n da̱nuyi a̱tsuma̱ e irumbu, A̱sulazuva oto o'wo ekan a̱ va̱. ");
INSERT INTO tsw_vpl VALUES ("MC7_9","034_7_9","MIC","7","9","9","N yuwaan ta̱ A̱sulazuva unusu, n ta kaɓa asuvu a̱tsuma̱ o upan wa̱ yi. Hali she nu u ge'eto iwuya i na a yuwaan numu a̱vu u zuwa mu mo o'wo fa̱a̱n. U ta̱ ta̱wa̱to mu uba̱ta̱ e ekan, waru n ta̱ ene a̱ɓula̱ a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("MC7_10","034_7_10","MIC","7","10","10","A mantsa'a n'yuwatan n va̱ n te ene, waru wono u ta̱ kpoto le ele na a damma numu, <<A̱ te ɗa A̱sulazuva A̱sula̱ a̱ wu?>> Esu a̱ va̱ e te ene uriyu u le, gogo a ta dadasa le tso yilyo'o a̱ re. ");
INSERT INTO tsw_vpl VALUES ("MC7_11","034_7_11","MIC","7","11","11","Urana u na a suwisa kari ɗu ta̱ lo a̱ ta̱wa̱, o urana u ndolo a̱ ta̱ da̱shi washin wu utyo wi iɗa i ɗu. ");
INSERT INTO tsw_vpl VALUES ("MC7_12","034_7_12","MIC","7","12","12","O urana u ndolo ama a̱ ɗu a̱ ta̱ ka̱mba̱ uba̱ta̱ u ɗu, diga Asuriya oɓolo ni ilyuci ya Masar, hali diga Masar a̱ tyo Yufiriti, na̱ diga a mala a̱ tyo a mala, na̱ diga a masasan a̱ tyo a masasan. ");
INSERT INTO tsw_vpl VALUES ("MC7_13","034_7_13","MIC","7","13","13","Uvaɗi gba u to o'wo okongo, adama a ama a na a̱ ri pe nden, adama e iwuya ya ama a na a̱ ri pe. ");
INSERT INTO tsw_vpl VALUES ("MC7_14","034_7_14","MIC","7","14","14","Vu guɓa ama a̱ wu na aaɗanga aguɓa a̱ wu, oɓolo e ikyon ya̱ wu ya agadu, za na a yuwusan nden ma aciyele a̱tsumona, a̱tsuma̱ o uba̱ta̱ wa alyuna u sa'ani. Lyawa a yuwan aguɓa a̱tsuma̱ Bashan na̱ Giliyadu, cine a yuwain ɗe nu ujimu. ");
INSERT INTO tsw_vpl VALUES ("MC7_15","034_7_15","MIC","7","15","15","Reve A̱sulazuva a damma, <<Tsu rana na yu uta̱i a̱tsuma̱ e iɗa ya Masar, n ta̱ roco le ili ya asalama a̱ va̱.>> ");
INSERT INTO tsw_vpl VALUES ("MC7_16","034_7_16","MIC","7","16","16","Nɗa n ta̱ e ene reve o sowo wono o una̱ wu ucira u le suru. A̱ ta̱ ɓa̱ru na̱ le ne ekere waru atsuvu e le a ta ula. ");
INSERT INTO tsw_vpl VALUES ("MC7_17","034_7_17","MIC","7","17","17","E te peɗe ma̱buta̱ tsi iyo, tsi inama i na yo ronoso a̱a̱tsuma̱ e iɗa. A̱ ta̱ o uta̱ na̱ meje'en diga a pa'atan n le, a ta vadala na̱ wovon uba̱ta̱ wa̱ A̱sulazuva A̱sula̱ a̱ tsu. waru a uwwa wovon wa̱ wu.>> ");
INSERT INTO tsw_vpl VALUES ("MC7_18","034_7_18","MIC","7","18","18","Zane ɗa A̱sula̱ tsa̱ wu, na tsu yuwan gafura vu unusu na̱ matawa mo unusu va akapi a ama agadu a̱ yi? Vu tsu guza̱ upan wa̱ wu hali hali shi, adama a na vu ta uwwusa uyo'o vu roco icigi i na i tsu vadala shi. ");
INSERT INTO tsw_vpl VALUES ("MC7_19","034_7_19","MIC","7","19","19","Vu ta da̱shi ene iliyali i tsu, vu ta dadasa nusu tsu za̱la̱ va apata ana a̱ wu. Vu ta vari nusu tsu suru a̱tsuma̱ a mala ma̱ a̱ru'un. ");
INSERT INTO tsw_vpl VALUES ("MC7_20","034_7_20","MIC","7","20","20","Vu to roco Yakubu amayun a̱ wu, Ibrahim waru icigi i na i tsu vadala shi. Cine vu kucinayi nkaya ntsu ɗe nu ujimu.");
INSERT INTO tsw_vpl VALUES ("NM1_1","035_1_1","NAM","1","1","1","Adanshi e ikaka ya̱ A̱sula̱ a̱ tyo Niniva. Aatagada a alavu alavu a na Nahum vuma va Elikoshi enei. ");
INSERT INTO tsw_vpl VALUES ("NM1_2","035_1_2","NAM","1","2","2","A̱sulazuva A̱sula̱ a̱ tsushu'un a ɗa, waru za va atsupu a ɗa. A̱sulazuva za va atsupu a ɗa, waru za vu upan wu usuɗuwu. U tsu tsupa ta̱ e ekere a n'yuwatan ma̱ yi. A̱ ta̱wusa̱a̱ n'yuwatan ma̱ yi nu upan. ");
INSERT INTO tsw_vpl VALUES ("NM1_3","035_1_3","NAM","1","3","3","A̱sulazuva a tsu yuwan upan go'o shi, waru za vu ucira u ɗa lon, u tsu lyawa za vu unusu ka̱ra̱ fa̱a̱n shi. Ure wa̱ yi u ta̱ pe a̱tsuma̱ a̱ lipa̱ na̱ wunla̱, eleshe waru ma̱buta̱ ma apata ana a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("NM1_4","035_1_4","NAM","1","4","4","U tsu ɓara ta̱ mala hali u 'yewe, waru u tsu 'yeweto ta̱ ɗolu suru. Bashan na̱ Kame a̱ tsu 'yewe ta̱, yipa̱lu ya Lebanon fo a tsu kpanla ta̱. ");
INSERT INTO tsw_vpl VALUES ("NM1_5","035_1_5","NAM","1","5","5","Nsasan n tsu jinga̱ɗa̱ ta̱ elime a̱ yi, agaɗi waru e jeruwe. Uvaɗi u jinga̱ɗa̱ ta̱ elime a̱ yi na aza a na a̱ ri pe a̱tsuma̱ a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("NM1_6","035_1_6","NAM","1","6","6","Zane ɗa aa gura isawan a̱ ma̱ka̱ka̱n ma̱ yi nu u yuwan upan? Zane ɗa aa gura isawaan usuɗuwu wu upan wa̱ yi? Upan wa̱ yi u to ocusho tsa a akina, atali a̱ ta̱ ɓosuso a̱ ma̱ka̱ka̱n ma̱ yi. ");
INSERT INTO tsw_vpl VALUES ("NM1_7","035_1_7","NAM","1","7","7","A̱sulazuva za vi isa'ani i ɗa, uba̱ta̱ wu upa'atan wu ucira a mantsa ma addama. Waru u ta aɗa aza a na a zuwai ucira u le ya̱'a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("NM1_8","035_1_8","NAM","1","8","8","Agba na̱ mini ma gbain ma ɗa A̱sulazuva o kototo Niniva, u ta̱ lo n'yuwatan ma̱ yi a̱ tyo e irumbu. ");
INSERT INTO tsw_vpl VALUES ("NM1_9","035_1_9","NAM","1","9","9","Ili i na o foɓoi aci A̱sulazuva biti u ta rawa utyo. Addama a̱ da̱shi ta̱wa̱ wa̱ ire shi. ");
INSERT INTO tsw_vpl VALUES ("NM1_10","035_1_10","NAM","1","10","10","O to o'wo tsi ili i na awanda a̱ guza̱i reve o'wo gashi aza a na ma̱ra̱ ma̱ tsura̱to yi, a̱ ta̱ kuloto le tsa anlya o u'yewu. ");
INSERT INTO tsw_vpl VALUES ("NM1_11","035_1_11","NAM","1","11","11","A̱tsuma̱ Niniva a ɗa vuma ro uta̱i, za na foɓoyi A̱sulazuva iwuya, reve u ca a̱sa̱la̱ e pere. ");
INSERT INTO tsw_vpl VALUES ("NM1_12","035_1_12","NAM","1","12","12","Apa ili i na A̱sulazuva a dammai, <<Ko na wo o'woi a̱ ta̱ na aza a na o ɓoloi aci na̱ a̱bunda̱, o to koɗo ɗu reve a̱ tsun ɗu a̱ nge'en. A̱ɗu aza a Yahuda ko na wo o'woi n ca ɗu ta̱ a̱tsuma̱lima̱, ma̱a̱ da̱shi yuwan ne shi. ");
INSERT INTO tsw_vpl VALUES ("NM1_13","035_1_13","NAM","1","13","13","Gogo n ta kuɗa a̱a̱gba̱la̱ e inan yi iluma i na u zuwaa nɗu a̱ yinlu, reve n kakasa akani a na a̱ nla̱ ɗu na̱ yi.>> ");
INSERT INTO tsw_vpl VALUES ("NM1_14","035_1_14","NAM","1","14","14","A̱sulazuva a yuwan ta̱ adanshi a aci a̱ wu Nineva a na, <<Vu buwa a̱ tsura̱ muwun mu ugundo n na e ɗe na aala a̱ wu shi. Waru n ta̱ kototo musula̱ n na i she'ein na̱ a̱ma̱li a na a̱ zuɗa̱i, aza musa'a n ɗu. N ta̱ foɓoo ɗu aason, adama a na i ri nu urana shi.>> ");
INSERT INTO tsw_vpl VALUES ("NM1_15","035_1_15","NAM","1","15","15","Ka̱lyuwa̱! Zuva vu nsasan m gbagbain ana aza a na a̱ ta̱wusa̱a̱ na alabari asa'ani, za na a cuɗuwusa asuvu nden! A̱vu Yahuda vu yuwan a̱buki a̱ wu, vu shiton akucunu a̱ wu. Adama a na n'yuwatan n buwa a̱ ka̱nda̱ruwa̱ wu shi o to kototo le suru suru. ");
INSERT INTO tsw_vpl VALUES ("NM2_1","035_2_1","NAM","2","1","1","Za vu ulungusu ta̱wa̱ ta̱ aci a̱ wu Niniva, vu geshe ba̱ta̱ vu upa'atan vi idana re vi isawan nu ucira, vu ɓoloto a̱za̱ e ipiri ya̱ wu suru! ");
INSERT INTO tsw_vpl VALUES ("NM2_2","035_2_2","NAM","2","2","2","Ko na̱ shi a damma a̱za̱ o ulungusu wu utsuru a̱ shi a̱ ta̱ a̱ lungusa̱ utsuru wi iɗa i le, ko shi gba a damma a̱ lungusa̱ ta̱ eten a ataci a ina̱bi i le, A̱sulazuva gba ta̱ ka̱mbuwa̱a̱ Isra'ila na̱ tsugbain tsa a̱ yi suru. ");
INSERT INTO tsw_vpl VALUES ("NM2_3","035_2_3","NAM","2","3","3","A̱ra̱ga̱ ali o uvon a Niniva a̱za̱ a̱ shili a ɗa, a̱soja a̱ yi a̱ ta̱ wotowu na̱ a̱tugu a̱ shili a̱ ma̱ɗiya̱. Irumu yi ikeke yi ido i le i da̱na̱ ta̱ e ikanasa urana u na o foɓo n le a fabusa ibata nu ucasu u wovon. ");
INSERT INTO tsw_vpl VALUES ("NM2_4","035_2_4","NAM","2","4","4","Ikeke yi ido'o a̱ da̱na̱ ta̱ e ilaɗi ujaru a̱tsuma̱ e re, reve a sumusa na̱ a̱ 'ya̱wi na̱ a̱ ka̱mbi a̱tsuma̱ agalaci a̱ lyuci'i. a̱ ta̱ tsi fitila, a̱ ka̱ra̱sa̱ tsi imaɗatsu. ");
INSERT INTO tsw_vpl VALUES ("NM2_5","035_2_5","NAM","2","5","5","Reve mogono ma Niniva mo ɓoloto ali o uvon a̱ yi, a̱vu a̱ ka̱ra̱ a̱ ta̱ɗa̱tsa̱sa̱ a̱ 'ya̱wa̱, a̱ jika̱ a̱ tyo o ukari u lyuci, a̱ shuwa̱ ili i na a yuwaan aciyele mapari. ");
INSERT INTO tsw_vpl VALUES ("NM2_6","035_2_6","NAM","2","6","6","A̱ kpa̱tu'wa̱ ta̱ agula o ɗolu, reve ukobu u mogono wo oco. ");
INSERT INTO tsw_vpl VALUES ("NM2_7","035_2_7","NAM","2","7","7","Adanshi ma̱ 'ya̱wa̱a̱ ma tsugbashi me e iɗa ya Niniva ma̱ ta̱ lo. Agbashi e esheli a̱ ta̱ da̱na̱ e mesun tsa muɗa no o korosoyi ekere aci. ");
INSERT INTO tsw_vpl VALUES ("NM2_8","035_2_8","NAM","2","8","8","Niniva ta̱ tsa aagula a na o ɓosoi, Waru a ta yisali a dansa, <<Isawain! Isawain!>> Agba babu za na vadalai. ");
INSERT INTO tsw_vpl VALUES ("NM2_9","035_2_9","NAM","2","9","9","I pura̱ azurufa! I pura̱ zinariya! Utsuru wa̱ yi u ri na̱ utyo shi, na̱ cu'un vu utsuru va̱ yi biti diga uba̱ta̱ wi izuwa ya̱ yi! ");
INSERT INTO tsw_vpl VALUES ("NM2_10","035_2_10","NAM","2","10","10","Niniva la̱nga̱ ta̱, waru u kuwa̱ ta̱, reve wo o'wo okongo! Okolo ama a̱ yi a kuɗa ta̱, a̱lu e le a̱ ka̱ra̱ ta̱ e meje'en, waru rewesu le rakpatsa ta̱. ");
INSERT INTO tsw_vpl VALUES ("NM2_11","035_2_11","NAM","2","11","11","Nye ɗa i shi i cinai lyuci ndolo Niniva za na shi vadama a̱ba̱nu e ikamu? A̱ba̱nu a na a tsu lyuwato muwun mi ikamu, uba̱ta̱ u na kamu na̱ ka vu kamu tsu yuwusan alyuna, oɓolo na̱ muwun mi ikamu babu wovon? ");
INSERT INTO tsw_vpl VALUES ("NM2_12","035_2_12","NAM","2","12","12","Kamu kakara ta̱ ili na̱ a̱bunda̱ adama a̱ muwun ma̱ yi, waru wu una ta̱ fo ka vu kamu va̱ yi nama. A̱vu u shiton a̱ba̱nu a̱ yi ni ili i na wu unai, a̱ba̱nu a̱ yi fo ni inama'a. ");
INSERT INTO tsw_vpl VALUES ("NM2_13","035_2_13","NAM","2","13","13","Reve A̱sulazuva oɓolo a̱ a̱soja a zuva damma, <<A̱yi ɗa nda, n ta̱ riya̱a̱ Niniva! A̱vu n kuloto ikeke yi ido ya̱ yi na akina. Matsun me pe'eni ma ta lyuwa a̱ a̱soja a̱ yi. Aza a na a̱ ri tsi ikamu yu ucira. N ta putsa yi na woo kototo nɗa mu uvaɗi, reve n putsaa nlingata ma̱ yi na 'ya̱wa̱a̱ ni ikaka i wovon.>> ");
INSERT INTO tsw_vpl VALUES ("NM3_1","035_3_1","NAM","3","1","1","Woo yo'ono wu shi! A̱vu lyuci na ocosu mpasa, zana ri tapu ne epen za na ri tapu ni itana i na a̱ pura̱i, u lamba itana i na a usai shi! ");
INSERT INTO tsw_vpl VALUES ("NM3_2","035_3_2","NAM","3","2","2","Uwwa! Mesun ma asuɗu na̱ mesun ma̱ a̱ga̱nda̱mu e ikeke, na̱ mesun me ilaɗi yi ido kirib kirib na̱ cine ikeke'e a̱ jinga̱ɗa̱sa̱ iɗa! ");
INSERT INTO tsw_vpl VALUES ("NM3_3","035_3_3","NAM","3","3","3","Ka̱lyuwa̱! Aza a na a kumbusa ido a̱ ta̱ a̱tsuma̱ o uvon, mutsun m pe'eni n ta a madala ɓolo ni ibata, waru apa a̱bunda̱ ama a na o unai. Apa oɓolo a̱kwa̱kwa̱, a na a̱ ri n kece shi, ama a̱ ka̱ra̱ ta̱ a̱ ta̱ɗa̱tsa̱sa̱ zuva va̱ a̱kwa̱kwa̱. ");
INSERT INTO tsw_vpl VALUES ("NM3_4","035_3_4","NAM","3","4","4","Ili i nda i fara ta̱ suru adama a̱bunda̱ a tsushakala a Niniva, aashakala o una̱ wu uyo'o u ndolo, mma va̱ a̱za̱ nkunu, za na pusa̱yin nɗa a̱tsuma̱ o ure u tsu shakala tsa̱ a̱ yi, ne elentsu a̱tsuma̱ o ure u tsuboci tsa̱ a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("NM3_5","035_3_5","NAM","3","5","5","A̱sulazuva o oɓolo a̱ a̱soja a damma ta̱, <<A̱yi ɗa nda, n ri tsushu'un na̱ Niniva, n ta̱ 'ya̱sa̱n ma̱kuru ma̱ wu n roco nɗa ataɓu a̱ wu, reve vo o'wo ili i wono e ekere o tsugono tsu uvaɗi suru. ");
INSERT INTO tsw_vpl VALUES ("NM3_6","035_3_6","NAM","3","6","6","N ta kusha'wa wu ili yi idaba, a̱vu n ca wu wono mo o'woto wu ili i na o goro. ");
INSERT INTO tsw_vpl VALUES ("NM3_7","035_3_7","NAM","3","7","7","Aza a na a̱ ka̱lyuwa̱ nuwu suru o to rono na̱ a̱ca̱pa̱ a damma, <Ili ya asalama! Niniva wo o'wo ta̱ okongo, zane ɗa a̱ shon adama a̱ yi? A te ɗa ma̱a̱ tsura̱a̱ wu aza a na a ca wu adanshi?> >> ");
INSERT INTO tsw_vpl VALUES ("NM3_8","035_3_8","NAM","3","8","8","Niniva, vu la'a ta̱ lyuci va̱ Tebe, zana ri o una̱ wu Uɗolu wa̱ Nilu ɗa? A̱yi fo mini ma ɗa ma̱ ka̱nda̱ruwa̱ niyi, mala ma ɗa uba̱ta̱ wu upa'atan wa̱ a̱ yi, mini ma ɗa ukari wa̱ yi. ");
INSERT INTO tsw_vpl VALUES ("NM3_9","035_3_9","NAM","3","9","9","Kush na̱ Masar ɗa ucira wa̱ yi, waru ucira wa̱ yi u ri nu utyo shi. Put na̱ Libiya e le ɗa aza a na o ɓoloso una̱ na̱ yi. ");
INSERT INTO tsw_vpl VALUES ("NM3_10","035_3_10","NAM","3","10","10","Nu ucira wa̱ yi suru a̱ pura̱i ta̱ a̱ 'ya̱wa̱ e iɗa i tsugbashi, a̱ ka̱ra̱ ta̱ na̱ yi a̱ tyo e iɗa i ro. O ɓuɓosuso ta̱ aci a̱ nreɓu ma̱ yi, oboguzu e re suru. E ne'eshen ta̱ mbara ma̱ yi a̱tsuma̱ o ure u matawa ma agita, a̱ nla̱ ta̱ azagbain a̱ yi na akani suru. ");
INSERT INTO tsw_vpl VALUES ("NM3_11","035_3_11","NAM","3","11","11","Niniva vu to o'wo usowu tim, waru vu to sowo a̱tsuma̱lima̱ lon. Vu ta zami uba̱ta̱ wu upa'atan, diga e ekere a n'yuwatan ma̱ wu. ");
INSERT INTO tsw_vpl VALUES ("NM3_12","035_3_12","NAM","3","12","12","Ba̱ta̱ vu ɓaɓu va̱ wu ri nu ucira shi, a ta lyuwa le tsu umatsun wu ubiri na e inai. A mantsa ma na a̱ jinga̱ɗa̱i ɗanga'a, a̱vu muwu'un a̱ riya̱ o una̱ wu za va alya. ");
INSERT INTO tsw_vpl VALUES ("NM3_13","035_3_13","NAM","3","13","13","Ka̱lyuwa̱ a̱soja o uvon a̱ wu, a̱ ta̱ tsa̱ a̱ma̱ci. Na̱ntsu lyuci va̱ wu ukpa̱tu'u ɗa a̱ ri e ekere a n'yuwatan ma̱ wu. Akina a lyuwa ta̱ ɗanga vu ukatsusu vu na̱ntsu va̱ wu. ");
INSERT INTO tsw_vpl VALUES ("NM3_14","035_3_14","NAM","3","14","14","Rono mini adama a na a̱ ta̱ ka̱nda̱ruwa̱ wu, vu tsura̱ mini ma̱ a̱bunda̱ kafu uvo'on u teme. Vu da̱shi ugbamu wu uɓaɓu wa̱ wu! Vu ka̱ra̱ a̱ 'ya̱wa̱ o uɓaa vu dadasa ci'in, reve vu tara ili i ma̱zuɗa̱ me ikunku! ");
INSERT INTO tsw_vpl VALUES ("NM3_15","035_3_15","NAM","3","15","15","Ni ifoɓi i nda suru, akina a ta lyuwa wu, matsun mepe'eni ma̱ ta̱ kototo wu, waru u ta tama wu tsa apapari. Vu da̱shi ta̱ a̱bunda̱ tsa apapari, reve vu da̱shi a̱bunda̱ tso oɓolo akyun! ");
INSERT INTO tsw_vpl VALUES ("NM3_16","035_3_16","NAM","3","16","16","Vu da̱shi ta̱ a̱bunda̱ aza atsulu na wina a̱ wu hali a la'a oɓolo a̱ yitele'o ya zuva. A̱ ta̱ tsa akyun a na a tsu yuwan ulungusu reve a̱ kpa̱tu'wa̱ evelu e le a 'yawan. ");
INSERT INTO tsw_vpl VALUES ("NM3_17","035_3_17","NAM","3","17","17","Aza e ipiri ya̱ wu a̱ ta̱ a̱bunda̱ va damma akyun a na a̱ ri a̱ ma̱ka̱ra̱ azagbain a̱ wu a̱ ta̱ tso o oɓolo apapari, nden zuva va alya a mantsa mo uta̱nu. Mantsa ma na urana u suɗuwai, a̱vu a 'yawan, waru babu za na tsu reve uba̱ta̱ u na a̱ tyo yi. ");
INSERT INTO tsw_vpl VALUES ("NM3_18","035_3_18","NAM","3","18","18","<<A̱vu mogono ma Asuriya aza a na e idanasa ama a̱ wu a̱ ta̱ nlavu, mbara ma̱ wu fo n ta nlavu. Akapi a ama a̱ wu a̱ ta̱ ubetu'wu tsi ikyon zuva vu nsasan, a̱ ri na̱ za va aguɓa a na oɓoloto le shi. ");
INSERT INTO tsw_vpl VALUES ("NM3_19","035_3_19","NAM","3","19","19","Babu ili i na ya inato wuntsu a̱ wu, adama a na wuntsu wa̱ wu za a na a̱ tsu ta̱wa̱ nu ukwisa̱ u ɗa. Zana uwwai adama a ɗa wu u ta ɓasa ekere a̱ yi u damma, <Ulobono ta̱!> Adama a na za lo na kuɗa̱i o sowo a̱tsuma̱lima̱ diga e ekere a̱ wu shi?>>");
INSERT INTO tsw_vpl VALUES ("HK1_1","036_1_1","HAB","1","1","1","Apa ikaka i na Haba̱ku vumava̱sula̱ e enei a̱tsuma̱ alavu alavu. ");
INSERT INTO tsw_vpl VALUES ("HK1_2","036_1_2","HAB","1","2","2","A̱sulazuva, hali mantsa ma̱ ne ma ɗa, mee showen wu adama e ikambishi, agba vaa zuwaa mu atsuvu shi? N yuwusan ta̱ mesun kuci adama o u'ya̱susa̱n wu ugbozu, agba vu wawa shi? ");
INSERT INTO tsw_vpl VALUES ("HK1_3","036_1_3","HAB","1","3","3","Nye i zuwai vu lyawa numu eneshe ulambu wa̱ a̱ɓula̱? Nye i zuwai vu ri a̱ a̱ka̱nla̱ e iwuya? Ukototosu nu u'ya̱susa̱n wu ugbozu n ta̱ elime a̱ va̱. Mawasan na̱ nronuloi n 'yon ta̱. ");
INSERT INTO tsw_vpl VALUES ("HK1_4","036_1_4","HAB","1","4","4","Adama o ndolo wila̱ u ri nu ucira shi, waru amayun a buwa o ulinga shi. A̱za̱ e iwuya a̱ ka̱nda̱ruwa̱ ta̱ a̱za̱ a̱ a̱ɓula̱, adama a vadala amayun. ");
INSERT INTO tsw_vpl VALUES ("HK1_5","036_1_5","HAB","1","5","5","Reve A̱sulazuva a damma,<<Ka̱lyuwa̱ nɗa vee e ene, vu ta yuwan asalama lon, adama a na n ta yuwan ili i ro a rana wuma wa̱ wu, zana ko na̱ shi a damma wu va̱a̱ usu shi. ");
INSERT INTO tsw_vpl VALUES ("HK1_6","036_1_6","HAB","1","6","6","N ta̱ 'ya̱susa̱n aza a Babila, iɗa yu usuɗuwu nu ujaru fo, aza a na a̱ ri a mmalu uba̱ta̱ suru a̱tsuma̱ o uvaɗi a ususa ba̱ta̱ vu nden n na ri a̱za̱ e le shi. ");
INSERT INTO tsw_vpl VALUES ("HK1_7","036_1_7","HAB","1","7","7","Ele ili i wovon i ɗa ni ili yi ilaɗi, a ta yuwusaan aciyele uge'etosu cine a cigai. ");
INSERT INTO tsw_vpl VALUES ("HK1_8","036_1_8","HAB","1","8","8","Ido i le i la'a ta̱ ta̱su ilaɗi, asuvu usuɗuwu u le u la'a ta̱ nkerenkesu n na n ri na ambulu, akumbi e ido e le a̱ tsu ta̱wa̱ ta̱ na afalu. Akumbi e ido e le a̱ tsu ta̱wa̱ ta̱ diga uba̱ta̱ wa alanga, a̱ tsu zura̱ ta̱ tsa̱ a̱a̱kuru a na a cigai a̱ ka̱ɗa̱. ");
INSERT INTO tsw_vpl VALUES ("HK1_9","036_1_9","HAB","1","9","9","Suru nle a̱ tsu ta̱wa̱ ta̱ adama o u'ya̱susa̱n wu ugbozu. A ta uwwusa wovon u le babu na a rawai. O tsu ɓoloto ta̱ agbashi cine vu revei wuyun. ");
INSERT INTO tsw_vpl VALUES ("HK1_10","036_1_10","HAB","1","10","10","A tsu lamaa ta̱ ngono, reve o zo'oso azagbain. O tsu zo'oso ta̱ fo ilyuci i na i ri nu ukari wu ucira suru, a tsu ɓoloto ta̱ ma̱bula̱ reve a kumba a lyuwa yi. ");
INSERT INTO tsw_vpl VALUES ("HK1_11","036_1_11","HAB","1","11","11","A̱ tsu ka̱ra̱ ta̱ tsu upepu, a lyuwa elime, ozo o unusu a ɗa, aza a na ma̱sula̱ ma̱ le a̱yi ɗa ucira u le.>> ");
INSERT INTO tsw_vpl VALUES ("HK1_12","036_1_12","HAB","1","12","12","A̱sulazuva, a̱vu ɗaɗa vu ri hali hali! A̱sula̱ a̱ va̱, za va akiza, tsa̱ kuwa̱ shi. A̱sulazuva, a̱vu ɗa vu zuwa nle e ge'etosu. A̱vu Aatali, a̱vu ɗa vu zuwa nle a ca tsu a̱tsuma̱lima̱. ");
INSERT INTO tsw_vpl VALUES ("HK1_13","036_1_13","HAB","1","13","13","Esu a̱ wu a̱ ta̱ na akiza lon vaa gura ka̱lyuwa̱ iwuya shi, vu tsu ciga vu ka̱lyuwa̱ unusu shi. Cine tsa ɗa va̱a̱ ka̱lyuwusa̱ aza a na aa yuwusan iwuya? Cine tsa ɗa vu rungwa̱i a̱za̱ e iwuya kpaku o soɗusu aza a na a la'a nle a̱ɓula̱? ");
INSERT INTO tsw_vpl VALUES ("HK1_14","036_1_14","HAB","1","14","14","Vu yuwan ta̱ ama tsa mugula a̱tsuma̱ a mala, tsi ili i wuma i mala i na i ri na̱ zagbain shi. ");
INSERT INTO tsw_vpl VALUES ("HK1_15","036_1_15","HAB","1","15","15","N'yuwatan n tsu reme le ta̱ na̱ gon, reve o uta̱a̱ le alanga ni igolo, o tsu ɓoloto le ta̱ a̱ agaso e le, a̱vu a yuwan mere na̱ ma̱za̱nga̱. ");
INSERT INTO tsw_vpl VALUES ("HK1_16","036_1_16","HAB","1","16","16","Adama o ndolo a tsu yuwaan ta̱ igolo i le kucci, reve a yuwaan agaso e le a̱tsuka̱ a̱ ma̱guru. Adama a na e le ɗa a̱ ta̱wa̱a̱ nle nu utsuru ni ilyalya ya̱ a̱bunda̱. ");
INSERT INTO tsw_vpl VALUES ("HK1_17","036_1_17","HAB","1","17","17","A ta lyuwa elime a̱ za̱la̱sa̱ igolo i le? O kototosu nɗa babu ene iliyali hali hali? ");
INSERT INTO tsw_vpl VALUES ("HK2_1","036_2_1","HAB","2","1","1","N ta kumba atsura a̱ va̱ mi isawan tsa za vi ipiri, n puro mu uwwa ili i na waa damma mu, nu usuwu u na wa ca adama e mesun ma̱ va̱. ");
INSERT INTO tsw_vpl VALUES ("HK2_2","036_2_2","HAB","2","2","2","Reve A̱sulazuva a damma mu, <<Vu ɗana alavu alavu'u vu ɗana yi a alanga e eteshe aɓaci a atali, tsa̱ra̱ za vu ɗesununa̱ u ɗe yi babu usa̱n. ");
INSERT INTO tsw_vpl VALUES ("HK2_3","036_2_3","HAB","2","3","3","Adama a na alavu alavu'u u ta pura mantsa ma na a zuwai, u ta yuwusan adanshi o ukosu waru wo o'wo epen shi. vu puro yi, ko nu jima, na amayun u ta̱ ta̱wa̱, waa tara mantsa shi. ");
INSERT INTO tsw_vpl VALUES ("HK2_4","036_2_4","HAB","2","4","4","Uwwai, za na okolo a̱ yi a̱ ri mejege shi u ta̱ riya̱, amma za va̱ a̱ɓula̱ ta yuwan wuma, adama o ucawu wo okolo a̱yi.>> ");
INSERT INTO tsw_vpl VALUES ("HK2_5","036_2_5","HAB","2","5","5","Na̱ ne suru, masayan ma̱ ina̱bi ma̱ tsu pusa̱n ta̱ za vu uvaɗu ugbozu, adama o ndolo u tsu da̱nu o u'wa shi. Utsa̱n wa̱ yi u ta̱ a̱bunda̱ tso ason, waru u ta̱ tsu ukwa̱, u tsu cuwa̱n shi. U tsu ɓolotowo ta̱ aciya̱yi nɗa suru, a̱vu u pura̱a̱ aciya̱yi ama suru. ");
INSERT INTO tsw_vpl VALUES ("HK2_6","036_2_6","HAB","2","6","6","Ama'a suru a ta yuwan tsushu'un na̱ a̱yi, o zo'osuso yi a yuwusan yi ulamu a dansa, <<A̱tsuma̱lima̱ a ta cina za na o ɓolotosoo aciya̱yi itana i wivu! Hali a̱ tyo a mantsa ma̱ ne voo ɓolotowo aciya̱wu utsuru a̱tsuma̱ o ure wu ule'e?>> ");
INSERT INTO tsw_vpl VALUES ("HK2_7","036_2_7","HAB","2","7","7","Babu usa̱n, aza a na o tono wu utan a ta zuwa wu elime, a̱ ta̱ ta̱wa̱ a zuwa wu meje'en ma̱ lipu. Vu to o'wo le itana i na a̱ pura̱i uba̱ta̱ o uvon. ");
INSERT INTO tsw_vpl VALUES ("HK2_8","036_2_8","HAB","2","8","8","Ana wo o'woi vu usa ta̱ nɗa na̱ a̱bunda̱, akapi a ama a nɗa nna n buwai a ta usa a̱za̱ a̱ wu. Adama a na vo oco ta̱ mpasa ma ama, vu lungusa̱ nɗa ni ilyuci, na ama a na a̱ ri a̱tsuma̱ e le suru. ");
INSERT INTO tsw_vpl VALUES ("HK2_9","036_2_9","HAB","2","9","9","<<A̱tsuma̱lima̱ a ta cina za na a lyuwusa melen ma̱ yi shi adama o u'wa wa̱ yi! A̱vu na vu suwai u'wa zuva va aagaɗi adama vu la'a a addama! ");
INSERT INTO tsw_vpl VALUES ("HK2_10","036_2_10","HAB","2","10","10","Vu ronoo ta̱ u'wa wa̱ wu wono. Adama a na vu una ta̱ ama na̱ a̱bunda̱, vu kototo ta̱ aciya̱wu. ");
INSERT INTO tsw_vpl VALUES ("HK2_11","036_2_11","HAB","2","11","11","Atali o ukari a̱ ta̱ shon, atsura akpata a̱ ta̱ usu. ");
INSERT INTO tsw_vpl VALUES ("HK2_12","036_2_12","HAB","2","12","12","A̱tsuma̱lima̱ a ta cina, za na suwai lyuci na̱ mpasa, za na suwai lyuci gbain ni iwuya! ");
INSERT INTO tsw_vpl VALUES ("HK2_13","036_2_13","HAB","2","13","13","Ashe A̱sulazuva o oɓolo a̱ a̱soja a zuva ɗa zuwai ama o uvaɗi a yuwan a̱tsuma̱lima̱ reve akina o soɗu le shi? Waru a yuwan ulinga we pere shi? ");
INSERT INTO tsw_vpl VALUES ("HK2_14","036_2_14","HAB","2","14","14","Adama a na uvaɗi u ta̱ da̱na̱ tapu nu urevu u tsugbain tsa̱ A̱sulazuva, cine vu revei mini mo tsu shiton mala. ");
INSERT INTO tsw_vpl VALUES ("HK2_15","036_2_15","HAB","2","15","15","A̱tsuma̱lima̱ a ta cina za na tsura̱to yi nron mu nden ma̱ yi, a̱ zuɗa̱sa̱ yi diga a̱ tsa̱n vu ukwan hali she no o'wo usowu, tsa̱ra̱ we ene e le aataɓu! ");
INSERT INTO tsw_vpl VALUES ("HK2_16","036_2_16","HAB","2","16","16","Wono u ta̱ kpa̱to wu o una̱ u tsugbain. Gogo mantsa ma̱ wu ma ɗa! Vu to sowo vo o'wo ataɓu! Mokkoto ma na ma̱ ri o ukere u sa'ani wa̱ A̱sulazuva ma̱ ta̱ riya̱ wu, ili i wono i kpa̱to tsugbain tsa̱ wu. ");
INSERT INTO tsw_vpl VALUES ("HK2_17","036_2_17","HAB","2","17","17","Ulungusu u na vu yuwain a aci a Lebanon u ta̱ ka̱mba̱ a aci ya̱ wu, mona me inama ya̱ yi i na vu yuwain u ta ca wu wovon. Adama a na vo oco ta̱ mpasa ma ama, a̱vu vu lungusa̱ nɗa ni ilyuci, na ama a na a̱ ri suru a̱tsuma̱ e le na̱ nden. ");
INSERT INTO tsw_vpl VALUES ("HK2_18","036_2_18","HAB","2","18","18","Ucira u ne u ɗa a̱a̱ma̱li a̱ ri na̱ a̱yi ana wo o'woi vuma ɗa she'en niyi? Uruma u ɗa u na woo ritosu epen. Adama a na vuma na yuwan niyi u ta zuwusa ucira e ili i na u yuwain, u yuwan ta̱ a̱ma̱li a na a tsu yuwan adanshi shi. ");
INSERT INTO tsw_vpl VALUES ("HK2_19","036_2_19","HAB","2","19","19","A̱tsuma̱lima̱ a ta cina za na dammai akpata, <Ka̱mba̱ wuma> Ko aatali a na a̱ ri ukwa̱, <'Yon!> U ta gura yuwan uritosu? Agba a̱yi ɗa nda a pala yi ta̱ na̱ zinariya oɓolo na̱ azurufa, agba u ri wuma shi. ");
INSERT INTO tsw_vpl VALUES ("HK2_20","036_2_20","HAB","2","20","20","Amma A̱sulazuva a̱ ta̱ pe a̱tsuma̱ a̱ A̱a̱'isa̱ a Akiza a̱ yi, lyawa uvaɗi ma̱ɓula̱ u rungwa̱ kpen a̱ ma̱ka̱ka̱n ma̱ yi.>> ");
INSERT INTO tsw_vpl VALUES ("HK3_1","036_3_1","HAB","3","1","1","Avasa a Haba̱ku vumava̱sula̱, aci a Shigiyonotu. ");
INSERT INTO tsw_vpl VALUES ("HK3_2","036_3_2","HAB","3","2","2","A̱sulazuva, mu uwwa ta̱ aɗa o ulinga wa̱ wu, reve wovon u guza̱ mu. Vu yuwisan a̱ba̱jini a linga va̱ wu a mantsa ma̱ tsu, vu lyawa e reve le. A̱tsuma̱ o upan wa̱ wu vee ene iliyali i tsu. ");
INSERT INTO tsw_vpl VALUES ("HK3_3","036_3_3","HAB","3","3","3","A̱sula̱ a̱ ta̱wa̱ ta̱ diga Teman, Za va Akiza ta̱ ta̱wa̱ diga a Masasan ma Faran. Zuva va zuva ta shiwan na̱ tsugbain tsa̱ yi, uvaɗi ma̱ɓula̱ u ta shiwan ni ica ya̱ yi. ");
INSERT INTO tsw_vpl VALUES ("HK3_4","036_3_4","HAB","3","4","4","Imaɗatsu ya̱ yi i ta̱ tse ekan yu urana, eka'an u ta̱ e ikanasa diga o ukere wa̱ yi, uba̱ta̱ u na ucira wa̱ yi u ri usokowu. ");
INSERT INTO tsw_vpl VALUES ("HK3_5","036_3_5","HAB","3","5","5","U lyungu ta̱ mɓa̱la̱ elime a̱ yi, waru u zuwa ta̱ ukwa̱ wu usuɗuwu u kuru a̱ca̱pa̱ a̱ yi. ");
INSERT INTO tsw_vpl VALUES ("HK3_6","036_3_6","HAB","3","6","6","Wi isawan ta̱, reve u jinga̱ɗa̱ uvaɗi. A̱vu u ka̱lyuwa̱, reve u zuwa nɗa n je'en. Akuci a nsasan a̱ ra̱mo ta̱, a̱vu akuci a agaɗi o oco. Re va̱ yi a̱ ta̱ lo hali hali. ");
INSERT INTO tsw_vpl VALUES ("HK3_7","036_3_7","HAB","3","7","7","Me ene ta̱ ogodo a̱ Kushan a̱tsuma̱lima̱, ama e iɗa ya Midiya e meje'en ma̱ lipu. ");
INSERT INTO tsw_vpl VALUES ("HK3_8","036_3_8","HAB","3","8","8","A̱sulazuva, vu yuwan ta̱ upan na̱ ɗolu? A̱tsumola̱ngu a̱ wu a̱ ta̱ aci o ɗolu? Upan wu usuɗuwu wa̱ wu u ta aci a mala? A mantsa ma na vu kumbai ido ya̱ wu, ni ikeke yi ido yu ulyuwu wa aci ya̱ wu? ");
INSERT INTO tsw_vpl VALUES ("HK3_9","036_3_9","HAB","3","9","9","Vu uta̱ ta̱ utan wa̱ wu alanga e eteshe, vu zuwa ta̱ aya a̱ wu a'yin. Wivuwun A̱vu vu ne'eshen uvaɗi na̱ mini. ");
INSERT INTO tsw_vpl VALUES ("HK3_10","036_3_10","HAB","3","10","10","Nsasan me ene wu ta̱, a̱vu o oɓoro. A jara ta̱ mini ma̱ a̱bunda̱, hali mala ma̱ a̱ru'un ma̱gugwa̱, hali ikeɗu i mala'a i 'yon zuva. ");
INSERT INTO tsw_vpl VALUES ("HK3_11","036_3_11","HAB","3","11","11","A̱vu urana na̱ woto e isawan kpen uba̱ta̱ u na a̱ ri na̱ nde, adama e ekan ya aya a̱ wu na a̱ ka̱ra̱i, oɓolo ne ekan e ibata ya̱ wu. ");
INSERT INTO tsw_vpl VALUES ("HK3_12","036_3_12","HAB","3","12","12","A̱tsuma̱ asuvu usuɗuwu a̱ wu a ɗa vu dasai uvaɗi, a̱tsuma̱ o upan u ɗa vu dasai nɗa. ");
INSERT INTO tsw_vpl VALUES ("HK3_13","036_3_13","HAB","3","13","13","Vu uta̱ ta̱ tsa̱ra̱ vu wawa ama a̱ wu, adama vu wawa aza a na vu tawai. Vu kototo ta̱ za vi iwuya, reve vu voton yi ataɓu. ");
INSERT INTO tsw_vpl VALUES ("HK3_14","036_3_14","HAB","3","14","14","Vu sapa yi ta̱ aaci ni ibata ya̱ yi, ana a̱soja a̱yi na a gurai uvon a̱ ta̱wa̱i tsa̱ lipa̱ tsa̱ra̱ e bete'we tsu, ma̱za̱nga̱ ma̱ le a̱ yi ɗa o soɗu alambi a na a̱ ri usokowu. ");
INSERT INTO tsw_vpl VALUES ("HK3_15","036_3_15","HAB","3","15","15","Vu dasa ta̱ mala ni ido ya̱ wu, vu ta̱ lukuta̱sa̱ mini mo ucira. ");
INSERT INTO tsw_vpl VALUES ("HK3_16","036_3_16","HAB","3","16","16","Na mu uwwai ne, a̱vu okolo a̱ va̱ a̱ riya̱, a̱vu una̱ u va̱ u je'en adama e ilama, etele a̱ va̱ a̱ kuwa̱ ta̱, a̱mu a mmalu ana a̱ va̱ e meje'en. Suru na̱ ne n ta kaɓa asuvu, n puro urana wa̱ a̱tsuma̱lima̱ u ta̱wa̱ a aci e iɗa i na ya̱a̱ ta̱wusa̱a̱ tsu nu uvon. ");
INSERT INTO tsw_vpl VALUES ("HK3_17","036_3_17","HAB","3","17","17","Ko na̱ shi uɗanga wu ubiri u ɓoso yipa̱lu shi, ko na̱ shi a̱ tsura̱ muwun n ina̱bi a ataci shi, ko na̱ shi ɗanga zetun matsan shi, ko iɗa i kuɗa̱ a̱ ta̱wa̱a̱ ni ilyalya, ko na̱ shi babu ikyon o uva̱la̱ta̱ ko na̱ shi babu inan uba̱ta̱ u na a̱a̱ gutsusu le, ");
INSERT INTO tsw_vpl VALUES ("HK3_18","036_3_18","HAB","3","18","18","suru na̱ ne n ta yuwan ma̱za̱nga̱ a̱ ma̱ka̱ka̱n ma̱ A̱sulazuva. N ta yuwan mere e ekere a̱ A̱sula̱ za vi iwawi i va̱. ");
INSERT INTO tsw_vpl VALUES ("HK3_19","036_3_19","HAB","3","19","19","A̱sulazuva zagbain ɗa ucira u va̱, u zuwa ta̱ ana a̱ va̱ e reme iɗa tsa mere'on, n yuwan mmalu zuva va atali. Udammu a̱ tyo a̱ ma̱dobiya. Za vi itana i tsuwe'e i na i ri na a'yin.");
INSERT INTO tsw_vpl VALUES ("ZP1_1","037_1_1","ZEP","1","1","1","A mantsa ma na Josiya ulobo wa Amon da̱na̱i o tsugono tsa Yahuda, vumava̱sula̱ Zafaniya ulobo wa Kush, ulobo wa Gedaliya, mawun ma tsukaya ma Amariya wu u'wa wa Hezekiya, damma ta̱ ili i na A̱sulazuva a damma niyi. ");
INSERT INTO tsw_vpl VALUES ("ZP1_2","037_1_2","ZEP","1","2","2","Reve A̱sulazuva a damma, <<N ta̱ kototo ili biti a̱tsuma̱ o uvaɗi.>> ");
INSERT INTO tsw_vpl VALUES ("ZP1_3","037_1_3","ZEP","1","3","3","<<N ta̱ kototo vaɗilima̱ ni inama yu uvaɗi suru, n ta̱ kototo nnunu na̱ mugula m mala, n ta̱ kototo a̱za̱ e iwuya, a̱vu n tawa vaɗilima̱ diga o uvaɗi.>> ");
INSERT INTO tsw_vpl VALUES ("ZP1_4","037_1_4","ZEP","1","4","4","<<N ta̱ ba̱ruwa̱ ukere u va̱ n yuwan nla̱ngi na̱ Yahuda na aza a na a̱ ri nden a̱tsuma̱ a̱ Urishelima suru. Waru n to kototo akapi ama a na a yuwusaan Ba'al a̱ga̱nda̱ na ala a nan ganu a na a yuwusan yi ulinga. ");
INSERT INTO tsw_vpl VALUES ("ZP1_5","037_1_5","ZEP","1","5","5","N ta̱ kototo aza a na a tsu kumba ukwa̱'a̱ a yuwaan urana na̱ woto na̱ italyo'o a̱ga̱nda̱. N ta̱ kototo aza a na a̱ ka̱ɗa̱tosu a kucinasa na̱ A̱sulazuva, waru a yuwusan akucunu na̱ ma̱sula̱ Mole. ");
INSERT INTO tsw_vpl VALUES ("ZP1_6","037_1_6","ZEP","1","6","6","N ta̱ kototo aza a na a vadalai ucina a lyawai itoni ya̱ A̱sulazuva, na aza a na a zamiyi A̱sulazuva ko a pati niyi ikambishi shi.>> ");
INSERT INTO tsw_vpl VALUES ("ZP1_7","037_1_7","ZEP","1","7","7","Vu rungwa̱ kpen a̱ ma̱ka̱nka̱ ma̱ A̱sulazuva! Adama a na urana wa̱ yi u yuwan ta̱ zuzu. A̱sulazuva o foɓo ta̱ na wa ca a ama a̱ yi kucci, waru u ɗangula ta̱ aza a yuwan ili i na u foɓoi. ");
INSERT INTO tsw_vpl VALUES ("ZP1_8","037_1_8","ZEP","1","8","8","<<Urana u na a̱mu A̱sulazuva maa ca ama a̱ va̱ kucci, n ta̱ ge'eto azagbain o mogono na̱ muwun n mogono, na aza a na oo otosu a̱tugu a̱ga̱nda̱ a̱ musula̱ mi iɗa i ro. ");
INSERT INTO tsw_vpl VALUES ("ZP1_9","037_1_9","ZEP","1","9","9","O urana u ndolo n ta̱ ge'eto za na suru a yuwusan a̱ga̱nda̱ tsa za na revei A̱sula̱ shi, na aza a na o shitoyin u'wa wu zagbain le ni ili ya usa na̱ yipalishi.>> ");
INSERT INTO tsw_vpl VALUES ("ZP1_10","037_1_10","ZEP","1","10","10","A̱vu A̱sulazuva a damma, <<O urana u ndolo, a ta uwwa mesun diga o Una̱ntsu u Magula, yorori diga o Upasu u ire, ni ilama yu ucira i ma̱riya̱ ma agaɗi. ");
INSERT INTO tsw_vpl VALUES ("ZP1_11","037_1_11","ZEP","1","11","11","Oruwoi, a̱ɗu aza a na i ri nden upasu we eden! Adama a na o kototo ta̱ suru aza a atsulu na awina, aza a na a tsulusa azurufa suru o una le ta̱. ");
INSERT INTO tsw_vpl VALUES ("ZP1_12","037_1_12","ZEP","1","12","12","A mantsa mo ndolo n ta gbangaɗa Urishelima ni ifitila, a̱vu n ca a̱za̱ nden n vama oforo, aza a na aa yuwusan majiyan, <A̱sulazuva a yuwan tsu isa'ani ko iwuya shi.> ");
INSERT INTO tsw_vpl VALUES ("ZP1_13","037_1_13","ZEP","1","13","13","A̱ ta̱ pura̱ utsuru u le, 'wa le waru o kototo le, a ta suwa 'wa agba a̱ da̱nu pe shi. A̱ ta̱ cu'wa̱n a̱ɗuma̱ a̱ ina̱bi agba oo sowo masayan me le shi.>> ");
INSERT INTO tsw_vpl VALUES ("ZP1_14","037_1_14","ZEP","1","14","14","Urana u gbain wa̱ A̱sulazuva a yuwan ta̱ zuzu a̱ zura̱sa̱ ni ilaɗi. Uwwai! Uɗyo u mesun ma̱ A̱sulazuva ma̱ ta̱ da̱na̱ okono, o urana'a za a na gurai uvon u ta yuwan yisali lon. ");
INSERT INTO tsw_vpl VALUES ("ZP1_15","037_1_15","ZEP","1","15","15","Urana u ndolo u to o'wo urana wu upan, urana u ɗa wa̱ a̱tsumola̱ngu na̱ a̱tsuma̱lima̱, urana u ɗa wa̱ a̱tsuma̱lima̱ nu ukototosu, urana u ɗa wi irumbu picim, urana u ɗa we eleshe ni irumbu da̱n. ");
INSERT INTO tsw_vpl VALUES ("ZP1_16","037_1_16","ZEP","1","16","16","Urana u ɗa u mesun ma avana na̱ yorori yu uvon a aci e ilyuci i na i ri na̱ kari vu ucira na atsura o uga'an. ");
INSERT INTO tsw_vpl VALUES ("ZP1_17","037_1_17","ZEP","1","17","17","<<N ta̱ ta̱wa̱a̱ ama na̱ a̱tsuma̱lima̱ hali e reme mmalu tsa̱ nrumba̱, adama a na a yuwaan ta̱ A̱sulazuva unusu. O to oco mpasa n le tsa̱ mini, inama i le waru tse everi.>> ");
INSERT INTO tsw_vpl VALUES ("ZP1_18","037_1_18","ZEP","1","18","18","O urana wu upan wa̱ A̱sulazuva azurufa na̱ zinariya le aa gura wawa le shi. A̱tsuma̱ o upan wu usuɗu wa̱ yi, u to kototo uvaɗi ma̱ɓula̱. Na amayun u ta̱ kototo aza a na a̱ ri nden o uvaɗi suru. ");
INSERT INTO tsw_vpl VALUES ("ZP2_1","037_2_1","ZEP","2","1","1","Ɓolotoi, ɓolotoi, a̱ɗu iɗa yu ulambu u wono, ");
INSERT INTO tsw_vpl VALUES ("ZP2_2","037_2_2","ZEP","2","2","2","kafu e bete'we ɗu tso owopo, kafu upan wu usuɗuwu wa̱ A̱sulazuva u cipa̱a̱ ɗu, kafu urana wu upan wa̱ A̱sulazuva u ta̱wa̱ aci a̱ ɗu. ");
INSERT INTO tsw_vpl VALUES ("ZP2_3","037_2_3","ZEP","2","3","3","I zami A̱sulazuva suru nɗu, a̱ɗu na i tarai aciya̱ɗu ili i ro shi e iɗa'a, a̱ɗu na yaa yuwusan ili i na u dammai. I zami ya̱ a̱ɓula̱, i tara aciya̱ɗu ili i ro wan. U ta gura o'wo a pa'aton ɗu o urana wu upan wa̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("ZP2_4","037_2_4","ZEP","2","4","4","O to kototo Gaza Ashikelon to o'wo okongo. A̱ ta̱ gba̱ra̱ Ashido nu urana a aci, reve fo a̱ gba̱ra̱ Ekuron. ");
INSERT INTO tsw_vpl VALUES ("ZP2_5","037_2_5","ZEP","2","5","5","A̱tsuma̱lima̱ a ta cina a̱ɗu, a̱ɗu na i ri e ikyun i mala, a̱ɗu aza a Keretiya, adanshi a̱ A̱sulazuva a̱ ta̱ a̱ nla̱ngi na̱ ɗu, a̱vu Ka'ana iɗa ya aza a Filistiya, <<N ta̱ kototo wu, hali na za a la'a shi.>> ");
INSERT INTO tsw_vpl VALUES ("ZP2_6","037_2_6","ZEP","2","6","6","Iɗa i na i ri e ikyun i mala, uba̱ta̱ u na aza a Keretiya a̱ ri na̱ nden, u to o'wo uba̱ta̱ wa alyuna, nu uva̱la̱ta̱ wa aza a aguɓa nu uba̱ta̱ wa aguta e ikyon. ");
INSERT INTO tsw_vpl VALUES ("ZP2_7","037_2_7","ZEP","2","7","7","Uba̱ta̱'a̱ u to o'wo, uba̱ta̱ wa aza a na a buwai wuma o u'wa wa Yahuda, lo ɗa a yuwan alyuna. Nu ulivu a̱vu o von a 'wa va aza a Ashikelon. Adama a na A̱sulazuva A̱sula̱ e le a̱ ta̱ da̱na̱ a ɗa e le, waru u ta̱ ka̱mbuwa̱a̱ le na aba'un e le. ");
INSERT INTO tsw_vpl VALUES ("ZP2_8","037_2_8","ZEP","2","8","8","<<Mu uwwa ta̱ ulamu u na aza Mowa a yuwusan, na̱ wisulusa u na aza a Amon a yuwusan, aza a na ee isulusa ama a̱ va̱ a lapusa ma̱ka̱nka̱ a dansa, a ta lyuwa iɗa ya ama a̱ va̱. ");
INSERT INTO tsw_vpl VALUES ("ZP2_9","037_2_9","ZEP","2","9","9","A̱vu A̱sulazuva o oɓolo a̱ a̱soja a zuva A̱sula̱ a Isra'ila a damma, n kucina ta̱ na̱ wuma u va̱, Mowa to o'wo tso Sodom, aza a Amon waru tsa Gomora iɗa'a u ta shiwan na awanda na̱ a̱nci a akpaɗi, iɗa i na i kuwa̱i hali hali. Ama a̱ va̱ a na a la'ai a̱ ta̱ pura̱ itana i le, wo o'wo agadu le.>> ");
INSERT INTO tsw_vpl VALUES ("ZP2_10","037_2_10","ZEP","2","10","10","A̱yi nda a̱yi ɗa ili i iliyinkapa ya aciyogbamu u le, adama a na a tarai ama'a ili i ro shi, reve a yuwan tsushu'un na ama a̱ A̱sulazuva o oɓolo a̱ a̱soja a zuva. ");
INSERT INTO tsw_vpl VALUES ("ZP2_11","037_2_11","ZEP","2","11","11","A̱sulazuva o to o'wo ili i wovon e ekere e le, na amayun u kototo musula̱ mu uvaɗi suru. Reve nɗa n na n ri e ikyun i mala a̱ ka̱ɗa̱to wa̱ yi, za suru diga e iɗa ya̱ yi. ");
INSERT INTO tsw_vpl VALUES ("ZP2_12","037_2_12","ZEP","2","12","12","<<Hali na̱ a̱ɗu fo a̱za̱ a̱ Kush, o to o una ɗu na̱ matsun me pe'eni ma̱ va̱.>> ");
INSERT INTO tsw_vpl VALUES ("ZP2_13","037_2_13","ZEP","2","13","13","A̱sulazuva a̱ ta̱ ba̱ruwa̱ ukere wa̱ yi a̱ tyo wu ugana u kototo Asuriya, u ta̱ ka̱mba̱to Niniva okongo, u'yewu tsa̱ a̱tsumona. ");
INSERT INTO tsw_vpl VALUES ("ZP2_14","037_2_14","ZEP","2","14","14","Iliyamunga o to von e memere ma̱ yi, na̱ cu'un vu nama biti. Vori na̱ papagula a̱ ta̱ da̱na̱ zuva va atsura a̱ lyuci'i, yisali i le i ta̱ da̱na̱ o uta̱sa̱ a angu a asula na̱ na̱ntsu, n'yuwatan n ta palu'wa ɗanga seda vu kwa̱'a̱ va̱ yi. ");
INSERT INTO tsw_vpl VALUES ("ZP2_15","037_2_15","ZEP","2","15","15","A̱yi nda a̱yi ɗa lyuci va afalu na shi nden gbaga, za na dammai aciya̱yi, <<A̱mu ɗa goon, waru za ro lo shi!>> A̱yi ɗa nda wo o'woi okongo, uba̱ta̱ wu nven wi inama yu una! Za na ka̱ra̱i lo suru, u ta cira a̱vu u gbaɗatsa aaci. ");
INSERT INTO tsw_vpl VALUES ("ZP3_1","037_3_1","ZEP","3","1","1","A̱tsuma̱lima̱ a ta cina lyuci va aciyogbamu, lyuci vi idaba ni iɓongishi! ");
INSERT INTO tsw_vpl VALUES ("ZP3_2","037_3_2","ZEP","3","2","2","U tsu poloo za atsuvu shi, waru u tsu usu ulapulu shi. U tsu zuwaa A̱sulazuva okolo a̱ yi shi, waru u tsu rawa zuzu na̱ A̱sula̱ shi. ");
INSERT INTO tsw_vpl VALUES ("ZP3_3","037_3_3","ZEP","3","3","3","Azagbain a̱ yi a̱ ta̱ tsi ikamu i ma̱gugwa̱, a̱za̱ o uge'etosu a̱ yi a̱ ta̱ tsa̱ nkerenkesu n na n liva̱i na ambulu, aza a na a tsu buwaa ili adama a nfa'an shi. ");
INSERT INTO tsw_vpl VALUES ("ZP3_4","037_3_4","ZEP","3","4","4","Ama̱sula̱ a̱ yi ama a vama a ɗa, a̱za̱ e ikpa'a, nan ganu a̱ yi a tara ili ya akiza ili i ro shi. Waru a kuɗa ta̱ wila̱. ");
INSERT INTO tsw_vpl VALUES ("ZP3_5","037_3_5","ZEP","3","5","5","A̱sulazuva a na a̱ ri a̱tsuma̱ a̱ lyuci'i za va̱ a̱ɓula̱ a ɗa, u tsu yuwan unusu shi. Usana biti u tsu roco ta̱ a̱ɓula̱ a̱ yi, usana wa̱ A̱sula̱ suru u tsu ka̱la̱ma̱ shi, suru na̱ ne za vu ulambu wa̱ a̱ɓula̱ ri na̱ wono shi. ");
INSERT INTO tsw_vpl VALUES ("ZP3_6","037_3_6","ZEP","3","6","6","Reve A̱sulazuva a damma, <<N kototo ta̱ ɗe nɗa mu uvaɗi, ba̱ta̱ vu pa'atan vu ucira le la̱nga̱ ta̱. Waru n lungusa̱ ta̱ re le, babu za na a̱ kurusu le. O kototo ta̱ ilyuci i le suru suru ko za la'a shi waru ko za ri pe shi. ");
INSERT INTO tsw_vpl VALUES ("ZP3_7","037_3_7","ZEP","3","7","7","Shi ta̱ n tara na amayun, a ama a̱ va̱ a ta uwwa wovon u va̱, waru a̱ usu tsuɓari, agba a̱a̱ da̱shi yuwan ulambu wu ugbozu shi, diga e ili i na n rono nle atsuvu. Amma suru na̱ ne reve a lyuwa elime nu ulambu wa̱ a̱ɓula̱ e ili i na aa yuwusan suru. ");
INSERT INTO tsw_vpl VALUES ("ZP3_8","037_3_8","ZEP","3","8","8","Adama o ndolo a̱mu A̱sulazuva n damma ta̱, <Puroyi urana u na ma̱ 'yon n yuwan adanshi a aci a nɗa, adama a na n zuwa ta̱ okolo a na mo ɓoloto wu nɗa, no ozo o tsugono uba̱ta̱ u ta̱, reve n tsun wa̱ le upan u va̱, upan wu usuɗu u va̱ a aci e le. Uvaɗi ma̱ɓula̱ u ta̱ koto adama o upan wu usuɗuwu u va̱.> >> ");
INSERT INTO tsw_vpl VALUES ("ZP3_9","037_3_9","ZEP","3","9","9","<<Na amayun, a mantsa ma ɗaɗa ma̱a̱ ka̱mba̱to nɗa a̱a̱ da̱na̱ a dansa amayun, suru nle a̱ ta̱ ɗe Aala A̱sulazuva, waru a yuwayin a̱ga̱nda̱ no okolo a̱ ta̱. ");
INSERT INTO tsw_vpl VALUES ("ZP3_10","037_3_10","ZEP","3","10","10","Diga a alanga o upasu wu uɗolu wa̱ Kush aza a na aa yuwusaan mu a̱ga̱nda̱, ama a̱ va̱ a na a̱ ri ubete'u, a̱ ta̱ ta̱wa̱a̱ mu na̱ kucci.>> ");
INSERT INTO tsw_vpl VALUES ("ZP3_11","037_3_11","ZEP","3","11","11","<<O urana u ndolo yaa uwwa wono shi adama a̱ nusu na i yuwaan numu shi. Adama a na n ta̱ o uta̱a̱ aza a aciyogbamu no ozo o uvaɗu a̱tsuma̱ a̱ ɗu. Waru ya̱a̱ da̱shi yuwan aciyogbamu a Masasan ma Akiza ma̱ va̱ shi. ");
INSERT INTO tsw_vpl VALUES ("ZP3_12","037_3_12","ZEP","3","12","12","Agba n ta lyawa aza a na a tarai aciyele ili i ro shi, na aza a na a̱ ka̱ɗa̱toi aciyele a̱tsuma̱ a̱ ɗu, a ta zami upa'anta uba̱ta̱ wa̱ A̱sulazuva. ");
INSERT INTO tsw_vpl VALUES ("ZP3_13","037_3_13","ZEP","3","13","13","Aza a Isra'ila a na a buwai a̱a̱ da̱shi yuwan unusu shi, waru a̱a̱ da̱shi yuwan epen shi, agba a̱a̱ da̱shi tsura̱ epen a̱ na̱ le shi. A ta yuwan aguɓa, reve o von, agba za lo na a da'waton le shi.>> ");
INSERT INTO tsw_vpl VALUES ("ZP3_14","037_3_14","ZEP","3","14","14","Cana ishipa nu ucira, a̱vu Sihiyona! Vu 'ya̱sa̱n uɗyo, a̱vu Isra'ila! Vu yuwan ma̱za̱nga̱ waru vu yuwan mere no okolo a̱ wu suru, a̱vu Urishelima! ");
INSERT INTO tsw_vpl VALUES ("ZP3_15","037_3_15","ZEP","3","15","15","A̱sulazuva a tawa ta̱ oforo a aci a̱ wu, waru u loso ta̱ n'yuwatan ma̱ wu. A̱sulazuva mogono ma Isra'ila ma̱ ta̱ oɓolo na̱ a̱vu, va̱a̱ da̱shi uwwa wovon u meleshe shi. ");
INSERT INTO tsw_vpl VALUES ("ZP3_16","037_3_16","ZEP","3","16","16","O urana u ndolo a ta damma Urishelima, <<She vu uwwa wovon wan, a̱vu Sihiyona, she vu lyawa ekere a̱ wu a̱ ɗa̱mba̱ wan. ");
INSERT INTO tsw_vpl VALUES ("ZP3_17","037_3_17","ZEP","3","17","17","A̱sulazuva A̱sula̱ a̱ wu a̱ ta̱ oɓolo na̱ a̱vu, za vu uvon ɗa, waru u tsu ulyuwu ta̱ aci. U ta yuwan ma̱za̱nga̱ a̱vu yuwan mere adama a̱ wu, u ta̱ ka̱mba̱to wu usa'avu adama e icigi ya̱ yi. U ta cana ishipa i ma̱za̱nga̱ nu ucira adama a̱ wu, ");
INSERT INTO tsw_vpl VALUES ("ZP3_18","037_3_18","ZEP","3","18","18","ununa a tsu yuwan urana wa̱ a̱buki. N ta tawa ɗu a̱tsumola̱ngu waru ya̱a̱ da̱shi uwwa wono shi. ");
INSERT INTO tsw_vpl VALUES ("ZP3_19","037_3_19","ZEP","3","19","19","Agba a mantsa'a n ta̱ ge'eto aza a na suru oo ɓongishi nɗu. N ta wawa a̱kutsuma̱ reve m ɓoloto aza a na e bete'wei. Oto o'wo ili yi ica waru a ca le tsugbain, a̱ ba̱ta̱ na suru a ca nle wono. ");
INSERT INTO tsw_vpl VALUES ("ZP3_20","037_3_20","ZEP","3","20","20","A mantsa mo ndolo n to ɓoloto ɗu, n ka̱mba̱to ɗu o u'wa. N ta zuwa a ca ɗu tsugbain a̱vu i tsura̱ ica a̱tsuma̱ a ama o uvaɗi suru, a mantsa ma na n ka̱mbuwa̱a̱ nɗu nu utsuru u ɗu e esu a̱ ɗu. A̱mu A̱sulazuva a ɗa n dammai ne.>>");
ALTER TABLE tsw_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
