﻿USE sofia;
DROP TABLE IF EXISTS sofia.tswNT_vpl;
CREATE TABLE tswNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tswNT_vpl WRITE;
INSERT INTO tswNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kristi† Zamawawa† uta̱ ta̱ o uꞌwa u Mogono Da̱wuda diga o ugundo wa Ibrahim.† Apa nda ugeru u tsukaya tsa na wu uta̱i. ");
INSERT INTO tswNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahim ɗa matsain Ishiyaku. Ishiyaku† ɗa matsain Yakubu. Yakubu† ɗa matsain Yahuza na akapi a̱ muwun ma̱ a̱na̱wu ma̱ yi olobo. ");
INSERT INTO tswNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuza† ɗa matsain mpishe Farisa na̱ Zera (Tamar ɗa makuci me le). Farisa ɗa matsain Hesuruna. Hesuruna ɗa matsain Aram. ");
INSERT INTO tswNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ɗa matsain Aminadabu. Aminadabu ɗa matsain Nashon. Nashon ɗa matsain Salumuna. ");
INSERT INTO tswNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salumuna ɗa matsain Buwaza. (Rahapu† ɗa makuci ma Buwaza.) Buwaza ɗa matsain Obe. (Rutu ɗa makuci ma̱ Obe.) Obe ɗa matsain Yese. ");
INSERT INTO tswNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese† ɗa matsain Da̱wuda Mogono. Da̱wuda† ɗa matsain Sulemanu. (Bashaba ɗa makuci ma̱ Sulemanu, a̱yi ɗa ka na Da̱wuda usai e ekere a Uriya.) ");
INSERT INTO tswNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulemanu† ɗa matsain Rihobuwa. Rihobuwa ɗa matsain Abija. Abija ɗa matsain Asa. ");
INSERT INTO tswNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ɗa matsain Jehoshafa. Jehoshafa ɗa matsain Jehora. Jehora ɗa matsain Azariya. ");
INSERT INTO tswNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Azariya ɗa matsain Jotam. Jotam ɗa matsain Ahazu. Ahazu ɗa matsain Hezekiya. ");
INSERT INTO tswNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiya ɗa matsain Manasa. Manasa ɗa matsain Amon. Amon ɗa matsain Josaya. ");
INSERT INTO tswNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaya ɗa matsain Jekoniya na̱ muwun ma̱ a̱na̱wu ma̱ yi olobo. (A mantsa ma ɗaɗa a̱ pura̱i ama a̱ tyo e iɗa ya Babila† tsugbashi.) ");
INSERT INTO tswNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ana a̱ pura̱ nle a̱ tyo Babila, a̱vu Jekoniya matsan Shayatiya. Shayatiya ɗa matsain Zerubabe. ");
INSERT INTO tswNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabe ɗa matsain Abihudu. Abihudu ɗa matsain Eliyaki. A̱vu Eliyaki matsan Azoro. ");
INSERT INTO tswNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoro ɗa matsain Saduku. Saduku ɗa matsain Akimu. Akimu ɗa matsain Aliyadu. ");
INSERT INTO tswNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Aliyadu ɗa matsain Eliza. A̱vu Eliza matsan Mata. Reve Mata matsan Yakubu. ");
INSERT INTO tswNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakubu ɗa matsain Isuhu. Isuhu ɗa vali va̱ Meri, Meri† ɗa mma va̱ Yesu za na e ɗeyi Kristi Zamawawa. ");
INSERT INTO tswNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ala o ugeru wa zuva e reme ta̱ tsukaya kupa na̱ a̱za̱ a̱ na̱shi diga ya Ibrahim a̱ tyo ya̱ Da̱wuda, na̱ tsukaya kupa na̱ a̱za̱ a̱ na̱shi diga a mantsa ma̱ Da̱wuda a̱ tyo mantsa ma na a̱ pura̱ nle a̱ tyo Babila, waru na̱ tsukaya kupa na̱ a̱za̱ a̱ na̱shi diga a mantsa ma na a̱ pura̱ nle a̱ tyo Babila a̱ tyo mantsa ma Zamawawa. ");
INSERT INTO tswNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Apa nda ununa a matsain Kristi Zamawawa. Mma va̱ yi eegeɓe a vuma ro ɗa na a̱ tsu ɗe Isuhu. Babu u reve vali, a̱vu u tsura̱ a̱a̱tsuma̱ o ure wa̱ Ruhu va Akiza.† ");
INSERT INTO tswNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Isuhu gba vuma va̱ a̱ɓula̱ ɗa za na shi a yuwusan ili i na i ri mejege; agba u ciga u ca Meri wono a alanga e eteshe shi, ɗaɗa u foɓoi wu kasa na̱ a̱yi usokowu. ");
INSERT INTO tswNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","A̱yi a̱tsuma̱ a majiyan mo ndolo, a̱vu malingata ma̱ A̱sulazuva ma̱ ta̱wa̱ ya̱ꞌa̱ yi a̱tsuma̱ a alavu, reve u damma, “Isuhu, mawun ma tsukaya ma̱ Da̱wuda, she vu uwwa wovon na vaa zuwa Meri wan, adama a na Ruhu va Akiza ɗa zuwa niyi u yuwain a̱a̱tsuma̱ a mawuꞌun. ");
INSERT INTO tswNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","U ta matsan ulobo, a̱vu vu ca yi aala Yesu,† adama a na u ta wawa ama a̱ yi o unusu u le.” ");
INSERT INTO tswNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ne ɗa nzuwulai ma̱ A̱sulazuva n shiwain, ununa Ishaya vumava̱sula̱† dammai ɗe nu ujimu, ");
INSERT INTO tswNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","a na, “Usheli u na koto u revei vali shi u ta yuwan a̱a̱tsuma̱, u ta matsan ulobo, reve a ca yi aala Imanuwe.” Urevu wa̱ yi a̱yi ɗa, “A̱sula̱ oɓolo na̱ a̱tsu.” ");
INSERT INTO tswNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ana Isuhu jiwain, reve u yuwan ili i na malingata ma̱ A̱sulazuva ma damma niyi u yuwan. A̱vu u tara Meri a̱ tyo o uꞌwa wo oꞌwo ka va̱ yi, ");
INSERT INTO tswNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","agba e revelei shi hali u matsan uloboꞌo. Reve Isuhu ca yi aala Yesu. ");
INSERT INTO tswNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","A matsan ta̱ Yesu a̱ lyuci va Batalami e iɗa ya Yahuda, a mantsa ma na Hiridu da̱na̱i mogono. A mantsa mo ndolo, reve ama o ro aza a na a̱ ri nu urevu wi italyoꞌo o uta̱ asana reve a̱ ta̱wa̱ Urishelima.† ");
INSERT INTO tswNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","A̱vu e ece, “Te ɗa mawun ma na a matsaiꞌin, za na ri mogono ma aza a Israꞌila?† Tse ene ta̱ talyoꞌo asana za na rocoi limatan va̱ yi ɗaɗa tsu ta̱wa̱i adama tsu yuwaan yi a̱ga̱nda̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ana Hiridu Mogono ma uwwai ne, reve ugbozu wa̱ yi u ꞌyon, ne ɗa waru akapi a ama a̱tsuma̱ a̱ Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Reve u ɓoloto nan ganu a gbagbain na̱ munlu n Wila̱† suru, a̱vu we ece le, “Te ɗa aa matsan Kristi Zamawawa?” ");
INSERT INTO tswNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Reve a̱ usu, “A̱ lyuci va Batalami a̱tsuma̱ a Yahuda. Mika vumava̱sula̱ ɗana ta̱ adama a nda a Adanshi a̱ A̱sula̱:† ");
INSERT INTO tswNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘A̱vu gba Batalami, vi iɗa ya Yahuda, ili i ro i ɗa shi a̱tsuma̱ e ilyuci ya Yahuda. Mogono ma̱ to uta̱ ya̱ꞌa̱ wu. Za na oo oꞌwo ana za va aguɓa va aza a Israꞌila, ama a̱ va̱.’ ” ");
INSERT INTO tswNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","A̱vu Hiridu ɗe omocin a na a̱ ta̱wa̱i diga asanaꞌa usokowu, reve a damma yi mantsa ma na talyoꞌoꞌo vu uta̱i. ");
INSERT INTO tswNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Reve u damma le, “Walai i ꞌya̱wa̱ Batalami i bunga̱ mawuꞌun ulobonu. Na̱ ye ene yi, a̱vu i ta̱wa̱ i damma mu adama a̱mu fo n ꞌya̱wa̱ n yuwaan yi a̱ga̱nda̱!” ");
INSERT INTO tswNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ana a̱za̱ o urevuꞌu a uwwai ili i na mogono ma dammai, reve a̱ ka̱ra̱. A̱vu talyoꞌo na e enei a asanaꞌa u wala elime e le, she na u rawai uba̱ta̱ꞌa̱, a̱vu wi isawan uba̱ta̱ u na mawuꞌun u ri. ");
INSERT INTO tswNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ana e enei talyoꞌoꞌo, reve a yuwan ma̱za̱nga̱ lon! ");
INSERT INTO tswNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ana amaꞌa a uwai o uꞌwaꞌa, a̱vu e ene mawuꞌun na̱ Meri† mma va̱ yi, a̱vu a̱ kingyo a̱ ka̱ɗa̱to a yuwaan mawuꞌun a̱ga̱nda̱. Reve o uta̱a̱ nu uneꞌe u le u zinariya, ne erepu e re a̱ ma̱guru na ri ni ikebe na a̱ tsu ɗe furenkisen† na̱ mur.† ");
INSERT INTO tswNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","A̱vu A̱sula̱ o rono atsuvu a̱za̱ o urevuꞌu a̱tsuma̱ a alavu, she a̱ ka̱mba̱ ya̱ Hiridu wan, ɗaɗa a̱ ka̱mba̱i e iɗa i le nu ure u ro. ");
INSERT INTO tswNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ana a̱ ka̱ra̱i, reve malingata ma̱ A̱sula̱† ma̱ ta̱wa̱ ya̱ Isuhu a̱tsuma̱ a alavu, a̱vu u damma, “ꞌYon! Jika̱ vu tara mawuꞌun na̱ mma va̱ yi a̱ tyo Masar! Vi isawan ɗe she urana u na n damma nuwu vu ka̱mba̱, adama a na Hiridu ri a zama mawuꞌun tsa̱ra̱ wu una yi.” ");
INSERT INTO tswNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Reve u ꞌyon, u tara mawuꞌun na̱ mma va̱ yi, a̱vu u reme ure na ayin a̱ tyo Masar. ");
INSERT INTO tswNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Reve a̱ da̱nu ɗe she na Hiridu kuwa̱i. A yuwan ta̱ ne adama o shiton ili i na A̱sulazuva a dammai o una̱ wa Hosiya vumava̱sula̱: “N ɗe ta̱ mawun ma̱ va̱ mo uta̱ Masar.” ");
INSERT INTO tswNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","A mantsaꞌa ana Hiridu enei a̱za̱ o urevuꞌu a̱ ka̱nda̱ruwa̱ yi tu ucina̱, reve u yuwan upan lon. Ɗaɗa u zuwai o una muwun mo olobo suru n na n ri na aꞌwan e re a̱ cipa̱ a̱tsuma̱ a Batalami ni ilyuci i ro i na i ri lo uka̱nda̱ruwu. U reve ta̱ mantsa ma na a matsain mawuꞌun adama e ili i na a̱za̱ o urevuꞌu a dammai. ");
INSERT INTO tswNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Reve ili i na A̱sula̱ a dammai o una̱ wa Irimiya† vumava̱sula̱ wo oꞌwo amayun: ");
INSERT INTO tswNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Reve a uwwa uɗyo a̱tsuma̱ a Rama, vuma ro a yisaali a adama a̱ a̱tsumola̱ngu. Rahila† ɗa ri a yisaali adama a̱ muwun ma̱ yi, reve u ꞌyuwan adanshi a na aa casu yi, adama a na muwun ma̱ yi n kuwa̱i suru.” ");
INSERT INTO tswNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ana Hiridu kuwa̱i, reve malingata ma̱ A̱sula̱ ma̱ ta̱wa̱ ya̱ Isuhu e iɗa ya Masar a̱tsuma̱ a alavu. ");
INSERT INTO tswNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","A̱vu u damma yi, “ꞌYon, vu tara mawuꞌun na̱ mma va̱ yi vu ka̱mba̱ e iɗa ya Israꞌila,† adama a na aza a̱ ri e izami i na oo una mawuꞌun a̱ kuwa̱ ta̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Reve Isuhu ꞌyon, a̱vu u tara mawuꞌun na̱ mma va̱ yi, reve a̱ ka̱mba̱ e iɗa ya Israꞌila. ");
INSERT INTO tswNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Amma ana u ta̱wa̱ u revei mogono ma saꞌavu Akilayu mawun ma̱ Hiridu ma ɗa, reve wu uwwa wovon. Ɗaɗa a̱tsuma̱ a alavu o ro, A̱sula̱ a damma niyi u tyo e iɗa ya̱ Ga̱lili. ");
INSERT INTO tswNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Reve a̱ ka̱ra̱ a̱ ꞌya̱wa̱ a̱ da̱nu a̱ lyuci na a̱ tsu ɗe Nazara. Adama o ndolo a ɗa ili i na A̱sula̱ a dammai o una̱ wa ama̱sula̱ wo oꞌwoi amayun, a na: “E te ɗe yi za va Nazara.” ");
INSERT INTO tswNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ana a yuwain aꞌwan o ro, reve Yahaya† za vu Urumbusu teme alajiya a̱tsuma̱ o una upasu wa Yahuda, ");
INSERT INTO tswNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","adansa, “Vadalai i lyawa unusu† u ɗu i ka̱mba̱ uba̱ta̱ wa̱ A̱sula̱, adama a na tsugono tsa zuva† tsa yuwan ta̱ zuzu.” ");
INSERT INTO tswNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ishaya† vumava̱sula̱ yuwan ta̱ ɗe adanshi a Yahaya ana u dammai: “Nanza te ɗewu a̱tsuma̱ o una, ‘Foɓoyi Zagbain ure, i yuwan ure u na wa̱a̱ kuru mejege!’ ” ");
INSERT INTO tswNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yahaya shi ta̱ wotowu ni itana i na a ɗavai ne eleme a arakumi. Reve wu nla̱ gbakala vu ukwan. Apapari ni ishiki i ɗa i da̱na̱i ilyalya ya̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ama na̱ a̱bunda̱ diga Urishelima na̱ Yahuda na̱ ba̱ta̱ na ri lo zuzu nu Uɗolu wa̱ Urdu a̱ ta̱wa̱ ta̱ adama a uwwa Yahaya. ");
INSERT INTO tswNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ana a dammai nusu le a alanga e eteshe, a̱vu u rumbu† le o uɗoluꞌu. ");
INSERT INTO tswNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Afarishi† na aza a Sadukiya na̱ a̱bunda̱ a̱ ta̱wa̱ ta̱ uba̱ta̱ u na Yahaya shi a̱ rumbusu ama tsa̱ra̱ u rumbu le. Ana Yahaya ene nle, reve u damma, “Suru nɗu apili a ɗa! Zane ɗa damma nɗu i suma a̱tsuma̱lima̱ a na A̱sula̱ a̱ ri lo a̱ ta̱wa̱a̱? ");
INSERT INTO tswNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","I yuwan ili i na yoo roco i lyawa ta̱ nusu ɗu. ");
INSERT INTO tswNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","She i jiyan yoo sowo a̱tsuma̱lima̱ shi, adama a na yaa dansa Ibrahim akaya a̱ ɗu a ɗa. N ta dansaa ɗu A̱sula̱ a ta gura tara atali a nda, reve u vazatowo Ibrahim muwun n tsukaya! ");
INSERT INTO tswNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ko gogo tsunda, aaɓau a̱ ta̱ lo ufoɓu adama wu koɗo ɗanga a aralu e le. Uɗanga u na u matsain muwun n saꞌani shi, suru o to koɗo yi reve a vari yi akina. ");
INSERT INTO tswNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“N ta̱ rumbusu ɗu na̱ mini adama u roco i vadala† ta̱, amma za na ri lo a̱ ta̱wa̱ a̱ca̱pa̱ a̱ va̱ u ta̱ rumbu ɗu na̱ Ruhu va Akiza na akina. U laꞌa mu ta̱ tsugbain lon, agba n rawa n guza̱a̱ yi atan shi. ");
INSERT INTO tswNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","U tu ufoɓu na aaɗanga a faba na aakpatalutsu o uyeluwu adama u zangaɗa ishina. U ta kakasa ishina no owopo. Reve u tsun ishina i saꞌani o mopon ma̱ yi, owopo gba shi a̱vu u kula̱to le na akina a na a̱ ri n kima̱ shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","A mantsa mo ndolo ma ɗa Yesu uta̱i Ga̱lili, reve u ꞌya̱wa̱ o Uɗolu wa̱ Urdu adama Yahaya rumbu yi. ");
INSERT INTO tswNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Agba a̱vu Yahaya shi ciga u ꞌyuwan a yuwan yi, a̱vu u damma, “A̱vu ɗa za na a̱a̱ rumbu mu. Cine tsa ɗa va̱a̱ ta̱wa̱ ya̱ꞌa̱ va̱?” ");
INSERT INTO tswNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Reve Yesu usu, “Ne ɗa u lobonoi wo oꞌwo gogo, adama tsu yuwan ili i na A̱sula̱ a cigai tsu yuwan.” Ɗaɗa Yahaya usuyi u rumbu yi. ");
INSERT INTO tswNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ɗaɗa u rumbuyi† Yesu. Yesu o utushi a̱ miniꞌi, ɗaɗa zuva kpa̱tuꞌwa̱i, a̱vu we ene Ruhu va̱ A̱sula̱ e telee yi ana muɗa. ");
INSERT INTO tswNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ɗaɗa uɗyo diga zuva wa damma, “A̱yi nda Mawun ma̱ va̱ ma ɗa, za na n cigai, waru n ta yuwusan ma̱za̱nga̱ na̱ a̱yi lon.” ");
INSERT INTO tswNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Reve Ruhu va Akiza† tara Yesu a̱ tyo a̱tsuma̱ o una, adama Mekerenkesu† ma̱ lyungwa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Agba Yesu lyuwa ili shi, hali rana na ayin amunga. Adama o ndolo, wu uwwa ta̱ ambulu lon. ");
INSERT INTO tswNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Reve Mekerenkesu ma̱ ta̱wa̱ a̱vu u damma yi, “Na̱ a̱vu Mawun ma̱ A̱sula̱ ma ɗa, ka̱mba̱to atali a nda o oꞌwo opopofu.” ");
INSERT INTO tswNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","A̱vu u usu, “A ɗana ta̱ a Adanshi a̱ A̱sula̱,† ‘Na alya e ilyalya i ɗa goon vuma a̱a̱ da̱na̱ wuma shi, amma she ni ili i na A̱sula̱ a dammai biti.’ ” ");
INSERT INTO tswNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Reve Mekerenkesu ma tara yi a̱ tyo Urishelima lyuci va akiza, reve u zuwa yi ɗe e ncilecile ma̱ A̱a̱ꞌisamapaɗa.† ");
INSERT INTO tswNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","A̱vu u damma yi, “Na̱ a̱vu Mawun ma̱ A̱sula̱ ma ɗa, teteruwe e iɗa, adama a na a ɗana ta̱ a̱tsuma̱ a Adanshi a̱ A̱sula̱: ‘A̱sula̱ a ta zuwa nlingata ma̱ yi n tiga̱ wu, e te keɗe wu ne ekere e le, adama vu ta̱ɗa̱tsa̱ a aatali vu uwwa usa̱n wan.’ ” ");
INSERT INTO tswNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Reve Yesu usu, “Amma Adanshi a̱ A̱sula̱ fo a damma ta̱, ‘She vu lyungwa̱ Zagbain A̱sula̱ a̱ wu wan.’ ” ");
INSERT INTO tswNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Reve Mekerenkesu ma tara Yesu a̱ tyo zuva masasan mo ugaꞌan, a̱vu u roco yi tsugono tsu uvaɗi suru na̱ tsugbain tse ele. ");
INSERT INTO tswNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Reve u damma, “Na̱ va̱a̱ ka̱ɗa̱to vu yuwaan mu a̱ga̱nda̱, n ta ca wu ili i nda suru.” ");
INSERT INTO tswNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","A̱vu Yesu usu, “Buwaa mu ure Male!† Adanshi a̱ A̱sula̱ a damma ta̱, ‘Vu yuwaan Zagbain A̱sula̱ a̱ wu a̱ga̱nda̱, a̱yi a̱ ndeꞌen ɗa vaa yuwaan tsugbashi!’ ” ");
INSERT INTO tswNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ɗaɗa Mekerenkesu ma lyawai Yesu, a̱vu nlingata ma̱ A̱sula̱ n ta̱wa̱ n kamba yi. ");
INSERT INTO tswNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ana Yesu uwwai a zuwa ta̱ Yahaya o uꞌwa wa ali, a̱vu u ka̱mba̱ e iɗa ya̱ Ga̱lili. ");
INSERT INTO tswNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","U fara ta̱ ꞌya̱wa̱ a̱ lyuci va Nazara, a̱vu u ꞌyon u ka̱ra̱ a̱ tyo Kafarnahum na̱ nden, a̱ mɓa̱nga̱ m Mala ma̱ Ga̱lili, upasu wi iɗa ya Zebelun na̱ Nafutali. ");
INSERT INTO tswNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ne ɗa nzuwulai ma̱ A̱sula̱ n shiwain ununa Ishaya vumava̱sula̱ dammai: ");
INSERT INTO tswNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“A̱tsuma̱ e iɗa ya Zebelun na̱ Nafutali, o ure a̱ tyo a mala, upasalai wu Uɗolu wa̱ Urdu, a̱tsuma̱ a̱ Ga̱lili uba̱ta̱ u na Atakpaci† na̱ a̱bunda̱ a̱ ri nden. ");
INSERT INTO tswNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ama a nda a na a̱ ri nden a̱tsuma̱ e irumbu e te ene ekan a gbain. A̱ ta̱ nden uba̱ta̱ u na u ri ukpa̱towu na̱ lulu vu ukwa̱, amma ekan e te ikana le.” ");
INSERT INTO tswNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Diga lo ɗa Yesu temei alajiya adansa, “Vadalai a̱ nusu ɗu i ka̱mba̱ uba̱ta̱ wa̱ A̱sula̱, adama a na tsugono tsa zuva tsa yuwan ta̱ zuzu.” ");
INSERT INTO tswNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Urana u ro, Yesu a mmalu a̱ ngeꞌen m Mala ma̱ Ga̱lili, a̱vu we ene ama e re muwun ma̱ a̱na̱wu. Za ta̱ aala a̱ yi a ɗa Simo za na waru e revei na aala Bituru, za ve ire gba a̱yi ɗa Andarawu. A̱za̱ e mereme ma mugula n ɗa, a̱ shi ta̱ a varishi igolo i le a mala. ");
INSERT INTO tswNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","A̱vu u damma le, “Ta̱wa̱i i kuru mu! N to roco ɗu ununa ya̱a̱ ta̱wa̱a̱ na ama o una̱ u mugula.” ");
INSERT INTO tswNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Lo ɗa a̱ ꞌyoshin a lyawai igolo i le, reve a̱ kuru yi. ");
INSERT INTO tswNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ana u lyuwai elime, reve u cina ama e re muwun ma̱ a̱na̱wu waru, Yakubu na̱ Yahaya, olobo a̱ Za̱ba̱di. A̱ shi ta̱ a wantsun u le oɓolo na̱ dada le, o foɓuso igolo i le. A̱vu u damma le a̱ kuru yi. ");
INSERT INTO tswNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ɗaɗa a lyawushi wantsun u le na aabara e le, reve a̱ kuru yi. ");
INSERT INTO tswNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu ꞌya̱wa̱ ta̱ uba̱ta̱ suru a̱tsuma̱ a̱ Ga̱lili. U ritosu ta̱ a̱tsuma̱ a̱ a̱ꞌisa̱. Waru u yuwusan ta̱ alajiya a Alabari a Saꞌani† o tsugono tsa zuva. A̱vu waru u ka̱mba̱tosu a̱za̱ o ubanakun na̱ a̱za̱ a̱ mɓa̱la̱ gbaga. ");
INSERT INTO tswNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","A̱vu alabari a̱ yi o uta̱ a alanga a̱tsuma̱ e iɗa ya̱ Ga̱lili, adama o ndolo a ɗa a̱za̱ o ubanakun, hali na aza a na a̱ ri e iɗa ya Suriya, a̱ ta̱wusa̱i adama a̱ ka̱mba̱to le gbaga a banakun icuꞌun icuꞌun na̱ mɓa̱la̱ n lipu. Ozo o ro e le a̱ shi ta̱ no otoni a̱ lima̱ na̱ a̱bunda̱, ozo o ro gba shi a̱ shi ta̱ a̱tsuma̱lima̱ na̱ tsudaꞌun, ozo o ro waru gba a̱kutsuma̱ a ɗa a̱ shi. A̱vu gba Yesu ka̱mba̱to le gbaga suru. ");
INSERT INTO tswNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","A̱vu oɓolo a amaꞌa na̱ a̱bunda̱ a̱ kuru yi uba̱ta̱ u na u ꞌya̱wa̱i suru: ama diga Ga̱lili, na̱ Dikafoli, na̱ Urishelima, na̱ Yahuda suru, na̱ diga asana o Uɗolu wa̱ Urdu. ");
INSERT INTO tswNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ana Yesu enei oɓoloꞌo, reve u kumba a aagaɗi a masasan a̱vu u da̱nu. A̱vu aza a na oo tono yi a rawa zuzu, ");
INSERT INTO tswNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ɗaɗa u uwai o ritosu le. ");
INSERT INTO tswNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Aza a abaꞌun a ɗa aza a na e revei aa gura yuwan ili i ro na aciyele shi, ɗaɗa e isawain uba̱ta̱ wa̱ A̱sula̱ goon. Tsugono tsa zuva za le ɗa! ");
INSERT INTO tswNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Aza a abaꞌun a ɗa aza a na a̱ ri a̱ a̱tsumola̱ngu, adama a na A̱sula̱ a̱ ta̱ ta̱na̱to okolo e le. ");
INSERT INTO tswNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Aza a abaꞌun a ɗa aza a na a tarai aciyele ili i ro shi, adama a na uvaɗi u to oꞌwo za le. ");
INSERT INTO tswNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Aza a abaꞌun a ɗa aza a na a̱ ri na akuli na ambulu adama e ili i na A̱sula̱ a cigai o una̱ wi ili ya alya ni ili yo oso, adama a na A̱sula̱ a̱ ta̱ cuwa̱ton le. ");
INSERT INTO tswNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Aza a abaꞌun a ɗa aza a na oo rocosu ozo o ro isaꞌani, adama a na A̱sula̱ o to roco le isaꞌani fo. ");
INSERT INTO tswNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Aza a abaꞌun a ɗa aza a na okolo e le a̱ ri cece, adama a na a̱ ta̱ da̱nu oɓolo na̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Aza a abaꞌun a ɗa aza a na aa yuwusan ulinga adama a̱ nden n saꞌani, adama a na A̱sula̱ a̱ ta̱ ɗe le muwun ma̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Aza a abaꞌun a ɗa aza a na o sowoi a̱tsuma̱lima̱ a̱ ma̱lyungwa̱, adama a na aa yuwusan ili i na A̱sula̱ a cigai, adama a na tsugono tsa zuva za le ɗa. ");
INSERT INTO tswNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“A̱sula̱ a ta zuwaa ɗu abaꞌun a mantsa ma na ama e isula nɗu. A̱sula̱ a ta zuwaa ɗu abaꞌun nna ama a̱ lyungwa̱ ɗu. A̱sula̱ a ta zuwaa ɗu abaꞌun nna ama a yuwaan ɗu cuꞌun ve epen suru adama a̱ va̱. ");
INSERT INTO tswNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ama a̱ ta̱ lyungwa̱ ɗu cine a̱ lyungwa̱i ama̱sula̱ a na a yuwain wuma ɗe nu ujimu. I yuwan ma̱za̱nga̱, reve waru asuvu a̱ ɗu o yoꞌono, adama a na i ta̱ ni iliyinkapa ya̱ a̱bunda̱ a pura ɗu ɗe zuva.” ");
INSERT INTO tswNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","A̱vu Yesu lyuwa elime na adanshi, “A̱ɗu ɗa akpaɗi o uvaɗi. Agba ulobonu u ne u ɗa akpaɗi a̱ ri nna a buwa peme shi? I ta gura zuwa le u yoꞌoniso? O to oco le reve a dasa le na ana, cine vu revei ili ye pere. ");
INSERT INTO tswNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“A̱ɗu ɗa aza a na aa casu uvaɗi ekan. Yaa gura paꞌaton lyuci na ri usuwu a masasan shi. ");
INSERT INTO tswNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Waru a tsu kaɓato fitila reve a̱ kpa̱to yi na aasaꞌatsu shi. E eelele a ɗa a̱ tsu zuwa yi adama ekan e ikana, tsa̱ra̱ ama a na a̱ ri pe o uꞌwaꞌa suru e ene ure. ");
INSERT INTO tswNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ne ɗa fo, yo oꞌwo ekan e ekere a ama o ro. I yuwan ili i saꞌani i na ee ene adama a ciɓala Dada ɗu na ri zuva.” ");
INSERT INTO tswNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Reve Yesu lyuwa elime u damma, “She i jiyan n ta̱wa̱ ta̱ adama n lungusa̱ Wila̱† wa Musa ko ili i na ama̱sula̱ o ritoi wan. N ta̱wa̱ adama n lungusa̱ le shi, amma adama n shiton uritosu u le. ");
INSERT INTO tswNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Amayun a ɗa maa dansaa ɗu, ko ili i ta̱ ya̱a̱ pusa̱n a̱tsuma̱ a̱ Wila̱ꞌa̱ shi, she ni iɗa na̱ zuva o koto. Ko ɗani a̱a̱ puwa̱n shi waru ko madaɓi me iɗani ma̱a̱ puwa̱n shi, she ni ili biti i shiwan. ");
INSERT INTO tswNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ni i ꞌyuwan ko Wila̱ u keꞌen u na u laꞌai uka̱la̱mu wi ili i na aa yuwan, a̱vu waru i roco ozo o ro a yuwan ne, a̱ɗu ɗa yoo oꞌwo nkosoto a̱tsuma̱ o tsugono tsa zuva. Amma ni i kuru a̱vu waru i roco ozo o ro ili i na u dammai, i ta̱ tsura̱ uba̱ta̱ u saꞌani a̱tsuma̱ o tsugonoꞌo. ");
INSERT INTO tswNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Munlu n Wila̱ na Afarishi a ta yuwusan a̱tyo a na aa yuwan adama a̱ kuru Wila̱ wa̱ A̱sula̱ mejege. I ciga i ꞌyuwan i laꞌa le a̱tsuma̱ e itoni ya̱ A̱sula̱. Ni i yuwan ne shi, n ta dansaa ɗu amayun, yaa uwa o tsugono tsa zuva shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Reve Yesu lyuwa elime na adanshi u damma, “Yu uwwa ta̱ a na Wila̱ wa Musa u dammai, ‘She vu una vuma nu ucigu wa̱ wu wan.’ Waru, ‘Za na unai suru a ciga a ꞌyuwan e geꞌeto yi.’ ");
INSERT INTO tswNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Gogo gba n ta dansaa ɗu: na̱ vu yuwan upan na̱ za va̱ wu, a̱ ta̱ geꞌeto wu. Na̱ vu ɗe za va̱ wu, ‘A̱a̱ta̱mu,’ a ta tara wu a̱ tyo uba̱ta̱ wa Azagbain a Mbara.† Na̱ vu ɗe za va̱ wu, ‘A̱vu a̱a̱ta̱mu za na ri na̱ a̱ɓula̱ shi,’ vu ta̱ zuzu na vaa uwa a akina a na a̱ ri n kima̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Adama o ndolo, na̱ vu ri mishin uba̱ta̱ u masaꞌa† a̱ A̱a̱ꞌisamapaɗa a casu uneꞌe uba̱ta̱ wa̱ A̱sula̱, reve vu cuwushin vuma ro damma ta̱ vu nusaan yi ta̱, ");
INSERT INTO tswNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","vu lyawa ɗe ili i na vu ta̱wa̱yi uba̱ta̱ u masaꞌaꞌa. A̱vu vu ꞌya̱wa̱ i sa̱la̱la̱i na̱ vumaꞌa, reve ka̱mba̱ vu ca uneꞌe wa̱ wu. ");
INSERT INTO tswNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Na̱ vuma ri na adanshi na̱ a̱vu, a̱vu u ciga u tara wu a̱ tyo uba̱ta̱ o ugeꞌetosu, i lapula adanshi a̱tsuma̱ a mantsa, kafu i rawa o ukobu wu ugeꞌetosu. Na̱ vu yuwan ne shi, na̱ vu rawa ɗe, a ta tara wu a̱ tyo uba̱ta̱ wu za vu ugeꞌetosu. Reve u zuwa wu e ekere a̱ mumaɗanga, aza a na a zuwa wu o uꞌwa wa ali. ");
INSERT INTO tswNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","N ta dansaa wu amayun, voo uta̱ pe shi, she na̱ vu tsupa ili i na oo tono wu.” ");
INSERT INTO tswNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Reve Yesu lyuwa elime, “Yu uwwa ta̱ a na Wila̱† wa Musa u dammai, ‘She vu yuwan tsipere wan.’ ");
INSERT INTO tswNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","A̱mu gba n ta dansaa ɗu, na̱ vu ka̱lyuwa̱ ka, reve asuvu a̱ wu a̱ ꞌya̱wa̱ ya̱ꞌa̱ yi, vu yuwan ta̱ ɗe tsipere na̱ a̱yi o okolo a̱ wu. ");
INSERT INTO tswNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Na̱ lyusu vu usaꞌani va̱ wu waa zuwusa wu vu yuwan unusu, vu foɗo yi vu vari yi. U ta laꞌaa wu vu lamba upasu u ta̱ u lipu va̱ wu, a na lipu va̱ wu suru aa uwa a akina. ");
INSERT INTO tswNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nu ukere usaꞌani wa̱ wu waa zuwusa wu vu nusan, vu koɗo yi vu vari! U ta laꞌaa wu vu lamba upasu u ta̱ u lipu va̱ wu a na lipu va̱ wu suru aa uwa a akina.” ");
INSERT INTO tswNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Reve u lyuwa elime u damma, “Yu uwwa ta̱ a na Wila̱ wa Musa u dammai, ‘Vuma ta gura kakasa na̱ ka va̱ yi nu u ca yi aatagada a wukasu u lolo.’ ");
INSERT INTO tswNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","A̱mu gba n ta dansaa ɗu, she vuma kakasa na̱ ka va̱ yi wan, she nu u yuwan tsipere na̱ vali ro. Na̱ wu kasa na̱ a̱yi u ta zuwa yi wo oꞌwo aashakala, ununa za na tara niyi suru ri nu unusu u tsipere adama a na u zuwa niyi.” ");
INSERT INTO tswNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Reve waru Yesu lyuwa elime na adanshi u damma, “Yu uwwa ta̱ a na Wila̱ wa Musa u dammai, ‘She vu kuɗa akucunu a̱ wu wan. Ciga ꞌyuwan vu shiton akucunu a na vu yuwayin A̱sulazuva.’ ");
INSERT INTO tswNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","A̱mu gba n ta dansaa ɗu, i kucina ko ni ili i ro wan, a mantsa ma na yaa yuwusan akucunu! Zuva uba̱ta̱ u na A̱sula̱ a̱ ri na̱ nden ɗa, adama o ndolo she i yuwan akucunu na̱ zuva wan. ");
INSERT INTO tswNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Iɗa udasata wa̱ A̱sula̱ u ɗa, adama o ndolo she i kucina ni iɗa wan. Urishelima lyuci Mogono ma Gbain ma ɗa, adama o ndolo she i kucina na̱ a̱yi wan. ");
INSERT INTO tswNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","She i kucina na aci a̱ ɗu wan. Yaa gura zuwa a̱nji a̱ ta̱ a̱ ɗu wo oꞌwo uꞌuri ko ulima̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","A mantsa ma na vaa yuwusan akucunu, vu damma ‘Ee’ ko ‘Oꞌo.’ Na̱ vu damma ili i na i laꞌai ‘Ee’ ko ‘Oꞌo,’ wu uta̱ ta̱ uba̱ta̱ wu za wuya.” ");
INSERT INTO tswNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","A̱vu Yesu lyuwa elime na adanshi, reve u damma, “Yu uwwa ta̱ a na Wila̱ wa Musa u dammai, ‘Nna̱ za amaton nanza a̱ lyusu ko a aanga, nu u ciga u ꞌyuwan u tsupa vumaꞌa lyusu ko aanga o ro na̱ za va̱ yi.’ ");
INSERT INTO tswNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Gogo gba n ta dansaa ɗu: na̱ za ro nusaan wu, she vu tsupa wan. Nna̱ za ro ɓasa wu o ugbaguzu wu ukere usaꞌani vu lyawa yi u koso ɓasa wu o ugbaguzu wu ukere wu ugula̱. ");
INSERT INTO tswNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Na̱ wo oꞌwo za ro damma vu nusaan yi ta̱, reve u damma za vu ugeꞌetosu u zuwa wu vu ca yi utugu wa̱ wu, vu ca yi aapalutsu a̱ wu fo. ");
INSERT INTO tswNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Na̱ soja zuwa wu vu tanu itana ya̱ yi mili ta̱, tanu le a̱ tyo imili i re. ");
INSERT INTO tswNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Na̱ vuma ro pati wu ili i ro, vu ca yi. Na̱ vuma ro ece wu okopu, vu ca yi.” ");
INSERT INTO tswNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","A̱vu Yesu lyuwa elime reve u damma, “Yu uwwa ta̱ a dammai, ‘Vu ciga moron ma̱ nden ma̱ wu, reve vu ꞌyuwan nꞌyuwatan ma̱ wu.’ ");
INSERT INTO tswNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","A̱mu gba n ta dansaa ɗu, i ciga nꞌyuwatan n ɗu, reve i yuwaan aza a na oo ɓongishi ɗu avasa. ");
INSERT INTO tswNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ni i yuwan ne, i to oꞌwo muwun ma amayun ma Dada ɗu na ri zuva. U tsu zuwa ta̱ urana wu uta̱ uba̱ta̱ wa ama a̱ a̱ɓula̱ nu uba̱ta̱ wa ama a vama. Waru u tsu yuwan ta̱ iroꞌi uba̱ta̱ wa aza a na aa yuwusan ili i na i ri mejege nu uba̱ta̱ wa aza a na aa yuwusan ili i babu ulobonu. ");
INSERT INTO tswNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Cine A̱sula̱ aa zuwaa ɗu abaꞌun, ni i ciga aza a na a ciga nɗu goon? Ko munlu mu utafa fo a ta yuwusan ne! ");
INSERT INTO tswNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Waru nni i lobonoto aciya̱ɗu e ekere a̱ nꞌutsa̱ n ɗu goon, i laꞌa akapi a ama shi. Ko aza a na e revei A̱sula̱ shi, o tsu lobonoto ta̱ aciyele e ekere a̱ nꞌutsa̱ n le. ");
INSERT INTO tswNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Adama o ndolo, yo oꞌwo a̱za̱ a̱ a̱ɓula̱, ununa Dada ɗu za na ri zuva ri na̱ a̱ɓula̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","A̱vu Yesu lyuwa elime o ritosu aza a na oo tono yi a̱vu u damma, “I yuwan ugbozu! A mantsa ma na yaa yuwusan ili i saꞌani, she i yuwan adama ama e ene a cuwa ɗu wan. Ni i yuwan ne, ya̱a̱ tsura̱ iliyinkapa uba̱ta̱ wa Dada ɗu za na ri zuva shi. ");
INSERT INTO tswNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“A mantsa ma na yaa casu alambi, she i ca le ununa a̱za̱ e ikpaꞌa a tsu yuwan wan. A̱ tsi ivula̱ ta̱ avana a̱tsuma̱ a̱ a̱ꞌisa̱ ne e re adama ama e ene le a cuwa le. Amayun a ɗa maa dansaa ɗu, a̱za̱ e ikpaꞌa o ndolo a̱ ushi ta̱ ɗe iliyinkapa i le. ");
INSERT INTO tswNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Adama o ndolo a mantsa ma na yaa yuwusaan alambi uneꞌe, i yuwan yi usokowu ununa ukere ugula̱ wa̱ wu wee reve ili i na ukere usaꞌani wa̱ wu waa yuwusan shi. ");
INSERT INTO tswNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","I ca uneꞌe u ɗu usokowu, ne ɗa Dada ɗu na revei ili i na i ri usokowu suru, waa ca ɗu iliyinkapa.” ");
INSERT INTO tswNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Reve Yesu lyuwa elime na adanshi u damma, “A mantsa ma na i ri a avasa, she yo oꞌwo ana a̱za̱ e ikpaꞌa wan! A tsu laꞌa ta̱ ciga e isawan a̱ a̱ꞌisa̱ na̱ a̱ ngeꞌen mu re a yuwusan avasa adama ama e ene le. Amayun a ɗa maa dansaa ɗu, a̱ ushi ta̱ ɗe iliyinkapa i le suru suru. ");
INSERT INTO tswNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","A mantsa ma na yaa yuwan avasa, i uwa a aasula reve i ɓa̱ru una̱ntsu. Reve i yuwan avasa a̱ tyo ya Dada ɗu na ri uba̱ta̱ o usokowuꞌu. Ne ɗa Dada ɗu za na tse ene ili i na yaa yuwusan usokowu, waa ca ɗu iliyinkapa i ɗu. ");
INSERT INTO tswNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Waru a mantsa ma na i ri avasa, she yoo oꞌwo ana aza a na e revei A̱sula̱ shi wan. Adama a na a̱ tsu ka̱mbuwusa̱ ta̱ ili i na i ri na aci shi. A ta zuwusa A̱sula̱ a ta uwwa le adama a̱ a̱bunda̱ a adanshi e le. ");
INSERT INTO tswNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","She yo oꞌwo ana ele wan. Adama a na Dada ɗu reve ta̱ ɗe ili i na i cigai kafu i pati yi. ");
INSERT INTO tswNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Adama o ndolo, na̱ yaa yuwan avasa, i vasa tsunda: ‘Dada tsu na ri zuva,† kamba tsu tsu ca aala a̱ wu tsugbain. ");
INSERT INTO tswNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tsugono tsa̱ wu tsa̱ ta̱wa̱, adama vuma biti o uvaɗi u yuwan tsutoni na̱ a̱vu, Ununa aa yuwusan tsutoni na̱ a̱vu zuva. ");
INSERT INTO tswNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","O urana wa anaꞌan vu ca tsu ilyalya i malya. ");
INSERT INTO tswNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Vu yuwaan tsu gafura vu nusu u tsu, adama a na a̱tsu tsaa yuwusaan aza a na aa yuwusan tsu unusu gafura. ");
INSERT INTO tswNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","She vu lyawa tsu tsu uwa a̱ ma̱lyungwa̱ wan, agba vu wawa tsu e ekere a za wuya.’ ");
INSERT INTO tswNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Amayun nni i yuwaan ozo o ro gafura vu nusu le, Dada ɗu na ri zuva u ta yuwaan ɗu fo gafura vu nusu ɗu. ");
INSERT INTO tswNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Amma ni i yuwaan ozo o ro gafura shi, Dada ɗu na ri zuva waa yuwaan ɗu gafura vu unusu u ɗu shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Reve Yesu lyuwa elime na adanshi u damma, “A mantsa ma na yaa yuwusan akuli, she i lukuta̱ urewesu u ɗu ununa a̱za̱ e ikpaꞌa a yuwusan wan. A tsu vadala ta̱ o oꞌwo ili i ro koꞌo adama ama e reve a na a̱ ri a akuli. Amayun n ta dansaa ɗu, a̱za̱ e ikpaꞌa o ndolo a̱ tsura̱ ta̱ ɗe iliyinkapa i le suru suru. ");
INSERT INTO tswNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Amma a mantsa ma na i ri a akuli, i saꞌa urewesu u ɗu a̱vu yi sara a̱nji a̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ne ɗa za ee reve a na i ri a akuli shi, she de Dada ɗu, za na ri uba̱ta̱ o usokowu suru. Waru a na u revei ili yu usokowu suru, u ta ca ɗu iliyinkapa.” ");
INSERT INTO tswNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yesu lyuwa ta̱ elime adansa, “She i ɓolotowo aciya̱ɗu uzuwa pa o uvaɗi wan! Ikupu na̱ matsafi ma̱ ta̱ lungusa̱ le, waru evu a ta gura ɓoso a uwa pe e iva̱ le. ");
INSERT INTO tswNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Amma, i yuwan izuwa i ɗu zuva, uba̱ta̱ u na ikupu na̱ matsafi ma̱a̱ lungusa̱ le shi, waru evu aa gura ɓoso a uwa pe e iva̱ le shi. ");
INSERT INTO tswNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Okolo a̱ ɗu a̱ ta̱ da̱na̱ uba̱ta̱ u na uzuwa u ɗu u ri kuci. ");
INSERT INTO tswNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Esu ele ɗa o oꞌwoi ana fitila lipu. Ne esu a̱ wu a̱ ri ulobonu, lipu va̱ wu suru u to oꞌwo ne ekan ma̱ɓula̱. ");
INSERT INTO tswNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Amma ne esu a̱ wu a̱ ri ulobonu shi, lipu va̱ wu ma̱ɓula̱ u ta̱ da̱na̱ a̱tsuma̱ e irumbu. Ne ekan a na a̱ ri pe ya̱ꞌa̱ wu wo oꞌwo irumbu, to, amayun vu ta̱ a̱tsuma̱ e irumbu i gbain. ");
INSERT INTO tswNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ko za lo aa gura yuwaan azagbain e re tsugbashi shi. Vu ta ꞌyuwan za ta̱, reve vu ciga za ta̱. Ko vu kuru za ta̱, reve vu ꞌyuwan a̱ kuru za ta̱. Vaa gura yuwaan A̱sula̱ nu utsuru a̱ga̱nda̱ shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Reve Yesu lyuwa elime na adanshi, “N ta dansaa ɗu, she i dama adama e ilyalya ni ili yo oso i na i cigai adama yo oꞌwo wuma wan. She i dama adama e itana yu uꞌotosu i lipu i ɗu wan. Wuma u laꞌa ta̱ ilyalya, waru lipu laꞌa ta̱ itana i lipu. ");
INSERT INTO tswNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ka̱lyuwa̱i nnunu! A̱ tsu cuꞌwa̱n shi, agba aa gasa shi. A tsu zuwa ilyalya o mpon shi. Agba suru na̱ ne Dada ɗu na ri zuva u ta̱ ka̱lyuwusa̱ le. Agba i reve ta̱ na i laꞌai nnunu pepere. ");
INSERT INTO tswNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yaa gura da̱shi ko mini ma̱ ta̱ a wuma u ɗu shi ni i dama adama a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Adama a̱ nye vu damai adama e itana yu uꞌotosu? Ka̱lyuwa̱i ununa yipa̱lu yu una i tsu kungwa. A tsu yuwan ulinga adama a yuwan itana i le shi. ");
INSERT INTO tswNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Amma n ta dansaa ɗu, ko Sulemanu† nu utsuru wa̱ yi suru, wo oto itana i saꞌani reve u lobono vadamma za ta̱ le shi. ");
INSERT INTO tswNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","A̱sula̱ o to foɓuso anlya o ogozo, aza a na a̱ ri wuma anaꞌan, nfaꞌan gba shi a̱ kula̱to. U lobono ta̱ i gura reve A̱sula̱ a ta ca ɗu itana yu uꞌotosu. She i da̱na̱ nu ucawu wo okolo waꞌa wan! ");
INSERT INTO tswNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","She i dama wan hali i damma, ‘Nye tsaa lyuwa?’ ko ‘Nye tsoo sowo?’ ko ‘Nye tsoo oto?’ ");
INSERT INTO tswNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ama a na e revei A̱sula̱ ɗa shi goon a tsu dama adama e ili i ndolo. Dada ɗu na ri zuva reve ta̱ na i cigai ili i ndolo suru. ");
INSERT INTO tswNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ili i na yaa laꞌa ciga a̱yi ɗa tsugono tsa̱ A̱sula̱, reve waru i yuwan ili i na A̱sula̱ a cigai. Reve a ca ɗu akapi e ili i na i cigai suru. ");
INSERT INTO tswNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Adama o ndolo, she i dama adama a nfaꞌan wan, adama a na nfaꞌan ta dama adama a aciya̱yi. Adama o ndolo she i da̱shi addama a aci a addama na urana suru wa̱a̱ ta̱wa̱a̱ wan.” ");
INSERT INTO tswNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","A̱vu Yesu lyuwa elime o ritosu aza a na oo tono yi, reve u damma, “She i geꞌeto za ro wan, adama A̱sula̱ e geꞌeto ɗu wan. ");
INSERT INTO tswNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Na̱ makundatsu ma na i geꞌetoi ozo o ro, na̱ a̱yi ɗa aa yuwaan ulinga e geꞌeto ɗu. ");
INSERT INTO tswNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Nye i zuwai va̱a̱ ka̱nla̱sa̱ macaka ma na ma̱ ri pe a̱ lyusu vu za va̱ wu, reve vi icina na̱ a̱a̱gba̱la̱ a na a̱ ri pe a̱ lyusu va̱ wu? ");
INSERT INTO tswNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Cine vaa gura damma za va̱ wu, ‘Lyawa mu uta̱a̱ macaka ma na ma̱ ri a̱ lyusu va̱ wu?’ Vu ka̱lyuwa̱ aciya̱wu! A̱vu gba vu buwa ta̱ na̱ a̱a̱gba̱la̱ o ndolo a̱ lyusu va̱ wu. ");
INSERT INTO tswNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","A̱vu za vi ikpaꞌa! Uta̱a̱ neꞌen a̱a̱gba̱la̱ a na a̱ ri a̱ lyusu va̱ wu, reve ve ene ulobonu ununa voo uta̱a̱ macaka ma na ma̱ ri a̱ lyusu va̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“She i ca musa̱n ili i na i ri za va̱ A̱sula̱ wan. A ta vadala aa amaton wu. She i variya ngurusumu iyeɗi yi ikebe† wan. A ta dadasa le.” ");
INSERT INTO tswNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Reve waru Yesu dammisa, “I lyuwa elime ni ipati, a ta ca ɗu ili i na ya patishi. I zamishi, i ta̱ tsura̱. Yi gulusa a yuwusan ‘A̱zoꞌwa,’ A̱sula̱ a ta zuwa a̱ kpa̱tuꞌwa̱a̱ ɗu una̱ntsu. ");
INSERT INTO tswNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Adama a na za vi ipati suru a tsu ca yi ta̱. Waru za vi izami suru, u ta̱ tsura̱. Waru nna ama a lyuwa elime na̱ wugulusa, A̱sula̱ a̱ ta̱ kpa̱tuꞌwa̱a̱ le. ");
INSERT INTO tswNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“A̱tsuma̱ a̱ ɗu zane ɗa aa ca mawun ma̱ yi aatali, nna̱ mawuꞌun u pati yi ilyalya? ");
INSERT INTO tswNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Vu ta ca yi aagbaji, nna̱ u pati wu magula? ");
INSERT INTO tswNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","A̱ɗu na i ri a̱za̱ o unusu, i reve ta̱ cine yaa ca muwun n ɗu ili i saꞌani. Dada ɗu gba na ri zuva, za na ri na̱ a̱ɓula̱, u tu ufoɓu u na waa ca aza a na a pati niyi ili i saꞌani! ");
INSERT INTO tswNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ununa i cigai ama a yuwaan ɗu, i yuwaan le fo ne. A̱yi nda a̱yi ɗa urevu u Wila̱ wa Musa nu uritosu wa Ama̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Reve Yesu damma, “I uwa o tsugono tsa̱ A̱sula̱ nu una̱ntsu wu uɓoru. Adama a na ure nu una̱ntsu u na wa̱a̱ ꞌya̱wa̱ o uꞌwa wa akina a̱ ta̱ washin waru a̱ ri usa̱n wu mmalu shi, waru ama na̱ a̱bunda̱ oo tono ureꞌe. ");
INSERT INTO tswNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Amma una̱ntsu u na u ri a̱ tyo uba̱ta̱ u wuma u na woo koto shi, u tu uɓoru waru ureꞌe u tu usa̱n wu mmalu, waru ama waꞌa ɗa oo tono ureꞌe.” ");
INSERT INTO tswNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","A̱vu Yesu lyuwa elime na adanshi, “I da̱nu nu ugbozu adama a ama̱sula̱ e epen. A̱ ta̱ ta̱wa̱ ɗu vadamma ikyon i ɗa, agba a̱tsuma̱ e le a̱ ta̱ ni iwuya vadamma nkerenkesu. ");
INSERT INTO tswNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","I te reve le e ili i na aa yuwusan, ununa vee reve uɗanga nna̱ ve ene umatsun wa̱ yi. A̱ tsu taɓa ubiri o uɗanga wa awanda shi, ko a̱ɗyumbu a ataci† shi. ");
INSERT INTO tswNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Uɗanga u saꞌani u tsu matsan ta̱ muwun n saꞌani ma̱ a̱ɓula̱, agba uɗanga u babu a̱ɓula̱ u tsu matsan muwun n saꞌani shi. ");
INSERT INTO tswNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Uɗanga u saꞌani u tsu matsan muwun m babu ulobonu shi, waru uɗanga u babu a̱ɓula̱ u tsu matsan muwun n saꞌani shi. ");
INSERT INTO tswNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ama o tsu koɗo ta̱ uɗanga suru u na u tsu matsan muwun ma̱ a̱ɓula̱ shi, reve a̱ kula̱to yi. ");
INSERT INTO tswNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ne ɗa fo, i te reve ama e ili i na aa yuwusan.” ");
INSERT INTO tswNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Reve Yesu damma, “Za na ee ɗesu mu Zagbain Zagbain suru ɗa aa uwa o uꞌwa u tsugono tsa zuva shi. Ama a na aa uwa o tsugono tsa zuva goon, ele ɗa aza a na aa yuwusan ili i na Dada va̱ va zuva cigai. ");
INSERT INTO tswNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","O urana wu ugeꞌetosu ama na̱ a̱bunda̱ e te ɗe mu Zagbain le. A ta damma, ‘Tsu yuwan ta̱ alajiya a̱tsuma̱ a aala a̱ wu, waru a̱tsuma̱ a aala a̱ wu tsu uta̱a̱ ta̱ otoni a̱ lima̱, waru tsu yuwan ta̱ linga va asalama a̱ a̱bunda̱.’ ");
INSERT INTO tswNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Reve gba n damma le, ‘N reve ɗu shi. I neꞌe mu ure, a̱ɗu aza a aciyogbamu!’ ” ");
INSERT INTO tswNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","A̱vu Yesu damma, “Adama o ndolo, za na aa uwwusa ili i na maa dansa, reve u yuwan tsutoni ne ele, u ta̱ vadamma suwi va̱ a̱ɓula̱ na suwai uꞌwa wa̱ yi a aatali. ");
INSERT INTO tswNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ko na̱ mini ma gbain ma̱ ta̱wa̱, ko na̱ ɗolu ta̱wa̱, waru nu upepu u keɓe yi usaaꞌa, wa̱a̱ riya̱ shi, adama a na a suwa yi ta̱ a aatali. ");
INSERT INTO tswNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Amma za na uwwai adanshi, agba u yuwan tsutoni ne ele shi, u ta̱ vadamma ulo u vuma u na u suwai uꞌwa wa̱ yi a̱ wuyun. ");
INSERT INTO tswNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nna̱ mini ma gbain ma̱ ta̱wa̱, ko ɗolu ta̱wa̱, waru nu upepu u keɓe yi she u ra̱mo, reve wu ɓoso suru suru.” ");
INSERT INTO tswNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ana Yesu kotoi a yuwusan adanshi a nda, reve oɓolo a amaꞌa a uwa asalama nu cuꞌun vu uritosu wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Adama a na u da̱na̱ vadamma munlu n Wila̱ shi, agba u yuwan ta̱ uritosu tsu za vu ucira. ");
INSERT INTO tswNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ana Yesu cipa̱i zuva masasaꞌan, reve a̱ba̱jini o oɓolo a ama o toni yi. ");
INSERT INTO tswNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Reve ma̱kutu ma cina yi. A̱vu u ka̱ɗa̱to a̱ ma̱ka̱ka̱n ma̱ yi reve u damma, “Zagbain, na̱ vu usu vu ka̱mba̱to mu gbaga, vu ta gura ka̱mba̱to mu.” ");
INSERT INTO tswNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Reve Yesu canana ukere wa̱ yi, a̱vu u juꞌwa̱n yi a̱vu u damma, “N usu ta̱. Ka̱mba̱ gbaga!” Babu usa̱n ɗaɗa ukutuꞌu u lyawa niyi, a̱vu wo oꞌwo gbaga! ");
INSERT INTO tswNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Reve u damma yi, “She vu damma za ro ili i na i farai wan. Amma vu ꞌya̱wa̱ vu roco aciya̱wu uba̱ta̱ wa ganu,† reve vu ca kucci† cine Musa dammai aza a na a̱ ka̱mba̱i gbaga a ca. A̱yi nda u to roco ama a na vu ka̱mba̱i gbaga.” ");
INSERT INTO tswNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Reve Yesu ka̱ra̱ a̱ tyo Kafarnahum. Ana u uwai a̱tsuma̱ a̱ lyuci gbain, yali† ya̱ Roma i ro i cina yi ta̱, reve u pati yi u kamba yi. ");
INSERT INTO tswNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Reve u damma, “Zagbain, n ta̱ na aagbashi a na a̱ ri ubanakun lon. U ta̱ ɗe o uꞌwa nven, u tsu gura jinga̱ɗa̱ lipu va̱ yi shi. U ta uwwusa lipu lon.” ");
INSERT INTO tswNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Reve u damma, “N ta̱ ꞌya̱wa̱ n ka̱mba̱to yi gbaga.” ");
INSERT INTO tswNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Reve yaliꞌi u usu, “Zagbain, n rawa vu ta̱wa̱ o uꞌwa u va̱ shi. Yuwan adanshi goon, aagbashi a̱ va̱ a̱ ta̱ ka̱mba̱ gbaga. ");
INSERT INTO tswNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","N ta̱ na̱ nan yali a gbagbain a na a tsu damma mu n yuwan ulinga, a̱mu fo n tsu damma ta̱ a̱soja a̱ va̱ ili i na aa yuwan. N tsu damma ta̱ soja, ‘Wala,’ reve u wala. Reve waru n damma soja ro, ‘Ta̱wa̱,’ reve u ta̱wa̱. Waru n tsu damma ta̱ aagbashi a̱ va̱, ‘Yuwan nda,’ reve u yuwan. N reve ta̱ a na adanshi a̱ wu a̱ ri nu ucira.” ");
INSERT INTO tswNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ana wu uwwai adanshi o ndolo, u yuwan ta̱ asalama. Reve u damma aza a na oo tono yi, “Amayun a ɗa maa dansaa ɗu, ucawu wo okolo a vuma nda u laꞌa ta̱ ucawu wo okolo a na me enei a̱tsuma̱ e iɗa ya Israꞌila suru. ");
INSERT INTO tswNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ama na̱ a̱bunda̱ a̱ to uta̱ asana na̱ a̱livu, a̱ ta̱ da̱nu, reve a lyuwa oɓolo na̱ Ibrahim, na̱ Ishiyaku, na̱ Yakubu a̱tsuma̱ o tsugono tsa zuva. ");
INSERT INTO tswNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Amma a ta vari aza a na a̱ shi a ntsayi a uwa o tsugonoꞌo a̱tsuma̱ e irumbu picim. A̱ ta̱ shon na a lumi anga adama a̱ a̱tsuma̱lima̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Reve Yesu damma yaliꞌi, “Wala a̱ tyo o uꞌwa. Aagbashi a̱ wu a̱ ta̱ ka̱mba̱ gbaga cine vu cayi okolo.” A mantsa mo ndolo ma ɗaɗa gan aagbashi a̱ yi a̱ ka̱mba̱i gbaga. ");
INSERT INTO tswNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ana a̱yi ndolo kotoi, a̱vu Yesu ꞌya̱wa̱ o uꞌwa wa̱ Bituru, reve u cina a̱na̱wa̱le Bituru nven ni ivuna̱. ");
INSERT INTO tswNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Reve u juꞌwa̱n ukere wa̱ yi, reve ivuna̱ꞌa̱ i lyawa yi, reve u ꞌyon ɗaɗa u cayi Yesu ilyalya. ");
INSERT INTO tswNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nu ulivu u ndolo ama a̱ ta̱wa̱a̱ yi ta̱ na ama a̱ a̱bunda̱ a na a̱ ri no otoni a̱ lima̱.† Reve u ɓara otoni a̱ lima̱ꞌa̱ ɗaɗa a lyawai amaꞌa, reve u ka̱mba̱to a̱za̱ o ubanakuꞌun suru gbaga. ");
INSERT INTO tswNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","U yuwan ta̱ ili i nda tsa̱ra̱ u shiton ili i na Ishaya vumava̱sula̱ dammai: “U tara ta̱ banakun tsu, reve waru u tawa mɓa̱la̱ n tsu.” ");
INSERT INTO tswNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ana Yesu enei a̱ba̱jini o oɓolo a ama zuzu na̱ a̱yi, reve u damma a̱ ꞌya̱wa̱ upasalai u mala u ndeɗe. ");
INSERT INTO tswNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Reve manlu ma̱ Wila̱ mo ro ma̱ ta̱wa̱ uba̱ta̱ wa̱ yi a̱vu u damma, “Manlu, n ta̱ kuru wu uba̱ta̱ u na va̱a̱ ꞌya̱wa̱ suru.” ");
INSERT INTO tswNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Reve u damma yi, “Nranji n ta̱ na angu a̱ nden, nnunu n ta̱ ni ikinda, a̱mu agba, Mawun ma Vuma† n ri nu uba̱ta̱ u na maa gbasato shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","A̱vu vuma ro za na da̱na̱i toni va̱ Yesu, damma yi, “Zagbain, lyawa mu neꞌen n ꞌya̱wa̱ n ciɗo aabara a̱ va̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Reve u damma yi, “Toni mu, a̱vu vu lyawa a̱kwa̱kwa̱ a̱ ciɗo a̱kwa̱kwa̱ e le.” ");
INSERT INTO tswNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","A̱vu Yesu uwa a̱tsuma̱ a wantsun, tsa̱ra̱ u ꞌya̱wa̱ upasu u mala u ndeɗe oɓolo no ojoro a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Reve a̱ba̱jini o upepu u mala u ꞌyon, a̱vu u jinga̱ɗa̱sa̱ wantsuꞌun, hali mini ma̱ ka̱ra̱ a uwusa yi, agba Yesu da̱na̱ ta̱ pe a nlavu. ");
INSERT INTO tswNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Reve ojoro a̱ yi a̱ ꞌya̱wa̱ uba̱ta̱ wa̱ yi, a̱vu a̱ ꞌya̱sa̱n yi na̱ yisaali, “Zagbain, wawa tsu! Tsu ciga ta̱ maliɓaa!” ");
INSERT INTO tswNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","A̱vu u usu le, “Adama a̱ nye yu uwwai wovon? I ri nu ucawu wo okolo a̱bunda̱ shi.” Reve u ꞌyon a̱vu u ɓara upepuꞌu ni ikeɗu i miniꞌi, a̱vu upepuꞌu u von kwin. ");
INSERT INTO tswNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ojoroꞌo a yuwan ta̱ asalama lon reve a damma, “Cuꞌun vuma ne ɗa tsunda? Hali upepu ni ikeɗu i mini a yuwan tsutoni na̱ a̱yi!” ");
INSERT INTO tswNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ana Yesu rawai upasalai wu ngeꞌen u mala zuzu na̱ lyuci va Gadara, reve ama e re a na a̱ ri no otoni a̱ lima̱ a gaꞌan na̱ a̱yi. Uba̱ta̱ wa ason a ɗa ama a nda a̱ tsu da̱na̱, waru a̱ da̱na̱ nu uyoꞌo shi, babu za na tsu gura toni lo. ");
INSERT INTO tswNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","A̱vu e teme a saalasaa yi, “Cine vaa damatosun tsu, Mawun ma̱ A̱sula̱? Vu ta̱wa̱a̱ tsu ta̱ na̱ a̱tsuma̱lima̱ kafu mantsa ma na A̱sula̱ a zuwai!” ");
INSERT INTO tswNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Zuzu nu uba̱ta̱ꞌa̱, oɓolo a̱ ngurusumu a̱ da̱na̱ ta̱ lo a alyuna. ");
INSERT INTO tswNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","A̱vu otoni a̱ lima̱ꞌa̱ a pati yi, “Na̱ vu uta̱a̱ tsu a̱tsuma̱ a ama a nda, vu yuwan ankuri vu ca̱co tsu a̱tsuma̱ o oɓolo a̱ ngurusumu a̱ ndeɗe.” ");
INSERT INTO tswNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Reve Yesu damma le, “Walai!” A̱vu otoni a̱ lima̱ꞌa̱ a lyawa amaꞌa, a̱vu a uwa a̱tsuma̱ a̱ ngurusumuꞌu. Reve ngurusumuꞌu suru a suma a̱ tyo za̱la̱ va agaɗi a̱ tyo a̱tsuma̱ a mala, a̱vu a̱ kuwa̱ pe. ");
INSERT INTO tswNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Reve ama a na a̱ da̱na̱i a aguɓa a̱ ngurusumuꞌu, a suma a̱ tyo a̱ lyuci, reve a damma ili i na i farai suru, hali ni ili i na i farai na ama e reꞌe. ");
INSERT INTO tswNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Reve ama suru a̱tsuma̱ a̱ lyuciꞌi o uta̱ tsa̱ra̱ e ene Yesu. Ana e ene niyi, a̱vu a pati yi u ka̱ra̱ u lyawaa le iɗa i le. ");
INSERT INTO tswNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","A̱vu Yesu uwa a wantsun a̱ ka̱mba̱ a̱ tyo upasalai u mala a̱ tyo a̱ lyuci na u shi na̱ nden. ");
INSERT INTO tswNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ana u rawai ɗe, reve ama o ro a̱ ta̱wa̱a̱ yi na̱ vuma na ri no osowi a̱ lipu a aavalu. Ana Yesu enei ucawu wo okolo wa ama a nda, reve u damma yi, “Ulobo, she vu uwwa wovon wan. A yuwaan wu ta̱ gafura wu unusu wa̱ wu.” ");
INSERT INTO tswNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","A̱vu munlu n Wila̱ n ro n dammulai va̱ni le, “Vuma nda u ta yuwusan adanshi a tarasa aciya̱yi A̱sula̱ a ɗa!” ");
INSERT INTO tswNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ana u revei cuꞌun majiyan ma na aa yuwusan, ɗaɗa we ece nle, “Nye i zuwai yaa yuwusan majiyan me iwuya i nda? ");
INSERT INTO tswNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Zane ɗa laꞌai babu usa̱n a na a damma, ‘A yuwaan wu ta̱ gafura wu unusu wa̱ wu,’ ko ‘ꞌYon vu wala?’ ");
INSERT INTO tswNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Agba a̱mu n to roco ɗu a na a̱mu, Mawun ma Vuma, n ta̱ nu ucira a̱tsuma̱ o uvaɗi u nda n yuwan gafura vu unusu.” Ɗaɗa u dammai a̱a̱kutsuma̱ꞌa̱, “ꞌYon, vu tara aavalu a̱ wu, a̱vu vu ka̱ra̱ a̱ ka̱mba̱ o uꞌwa.” ");
INSERT INTO tswNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Reve u ꞌyon u ka̱ra̱ a̱ tyo o uꞌwa. ");
INSERT INTO tswNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ana ama e enei ili i ndolo, a yuwan ta̱ asalama, reve a yuwaan A̱sula̱ ica a na u cayi vuma cuꞌun vu ucira u nda. ");
INSERT INTO tswNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Reve Yesu lyawa uba̱ta̱ u ndolo, u lyuwa elime na̱ mmalu, ɗaɗa we enei vuma ro na a̱ tsu ɗe Matta, za na shi nden uba̱ta̱ u na u tsu ushishi utafa. Ɗaɗa u damma niyi, “Toni mu.” A̱vu u ꞌyon u toni yi. ");
INSERT INTO tswNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","A̱ tyo ɗe, a̱vu Yesu no ojoro a̱ yi a̱ da̱nu alya e ilyalya o uꞌwa wa Matta. A̱za̱ o uꞌushishi wu utafa na̱ a̱bunda̱ na̱ a̱za̱ o unusu o ro a̱ da̱na̱ ta̱ lo. ");
INSERT INTO tswNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ana Afarishi enei ili i ndolo, a̱vu e ece ojoro a̱ yi, “Cine manlu ma̱ ɗu maa lyuwusa ilyalya ni icuꞌun ya ama o ndolo?” ");
INSERT INTO tswNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu uwwa le ta̱ a̱vu u usu le, “Aza a na a̱ ri gbaga a ciga za va̱ a̱guma̱ shi, amma a̱za̱ o ubanakun a ciga ta̱. ");
INSERT INTO tswNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ꞌYa̱wa̱i i rito ili i nda i na Adanshi a̱ A̱sula̱ aa dansa, ‘Ana yaa yuwaan mu kucci, u laꞌaa ɗu ta̱ ye ene iliyali yo ozo o ro.’ N ta̱wa̱ adama m banu ama a̱ a̱ɓula̱ tsa̱ra̱ o oꞌwo a̱za̱ e itoni a̱ va̱ shi. Amma n ta̱wa̱ ta̱ m banu a̱za̱ o unusu.” ");
INSERT INTO tswNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Urana u ro, ojoro a Yahaya za vu Urumbusu a̱ ta̱wa̱ ta̱ uba̱ta̱ wa̱ Yesu, reve a yuwan yi yeci, “Nye i zuwai a̱tsu na Afarishi tsaa yuwusan akuli, agba ojoro a̱ wu aa yuwusan shi?” ");
INSERT INTO tswNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","A̱vu Yesu usu, “Ama a vali vu kasaꞌavu a tsu yuwan a̱tsumola̱ngu shi, nu u ri oɓolo ne ele. Amma mantsa ma̱ ta̱ ta̱wa̱ a na aa tara valiꞌi e memere me le, a mantsa ma ɗaɗa aa yuwan akuli. ");
INSERT INTO tswNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Babu za na a paɗa umuna u saꞌavu u lapulaa uba̱mu wa akuci o utugu wa̱ yi. Nu u yuwan ne, umuna u saꞌavu u ta̱ vura̱nu a̱vu u kara akuci o utuguꞌu, agba apaɗi o umuna u saꞌavuꞌu waa ntsaa a akuci o utuguꞌu shi. Ne ɗa uba̱muꞌu wa̱a̱ da̱shi washin. ");
INSERT INTO tswNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Waru, a̱a̱ tsun ribina saꞌavu a akuci e itsa̱n yu kwan shi, adama a na ribinaꞌa nu u kutsa, u to ɓoso itsa̱ꞌa̱n, reve woo oco waru itsa̱ꞌa̱n a̱ la̱nga̱. Amma ama a̱ tsu tsun ta̱ ribina saꞌavu kuci e itsa̱n i saꞌavu. A̱vu suru nle a̱ da̱na̱ gbaga.” ");
INSERT INTO tswNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu a̱tsuma̱ a adanshi, a̱vu zagbain va̱ a̱a̱ꞌisa̱ ro ta̱wa̱ ya̱ꞌa̱ yi. Reve u kingyo a̱ ma̱ka̱ka̱n ma̱ yi a̱vu u damma, “Usheli u va̱ u kuwa̱ ta̱ gogo. Agba na̱ vu ta̱wa̱ vu kuruwa̱ yi ukere, u ta̱ ka̱mbisa̱ wuma.” ");
INSERT INTO tswNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Reve Yesu na aza a na oo tono yi a̱ ꞌyon a̱vu o toni zagbaiꞌin. ");
INSERT INTO tswNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","A̱vu ka na da̱na̱i o ocosu mpasa hali aꞌwan kupa ne ejere ta̱wa̱ a̱ca̱pa̱ e Yesu, a̱vu u juꞌwa̱n yi ngeꞌen mu utugu. ");
INSERT INTO tswNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","U da̱na̱ ta̱ a majiyan, “Na̱ n juꞌwa̱n utugu wa̱ yi goon, n ta̱ ka̱mba̱ gbaga.” ");
INSERT INTO tswNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Reve Yesu vadala ɗaɗa we ene niyi, a̱vu u damma, “Usheli, she vu uwwa wovon wan! Ucawu wo okolo a̱ wu u ka̱mba̱to wu ta̱ gbaga.” A̱vu kaꞌa wo oꞌushi gbaga. ");
INSERT INTO tswNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Reve Yesu lyuwa elime na̱ mmalu oɓolo na̱ zagbaiꞌin a̱ tyo o uꞌwa wa̱ yi, a̱vu we ene a̱za̱ e ishipa ya̱ a̱ciɗa̱ na ama a̱ a̱bunda̱ e mesun. ");
INSERT INTO tswNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","A̱vu u damma, “Uta̱i suru nɗu! Usheliꞌi u kuwa̱ shi. Nlavu n ɗa waa yuwusan.” A̱vu amaꞌa a yuwaan yi izoꞌoshi yu ulamu. ");
INSERT INTO tswNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Amma ana o lo nle o uta̱ a alanga, a̱vu u ka̱ra̱ a̱ tyo uba̱ta̱ u na usheliꞌi u ri nven. Reve u reme yi ukere, ɗaɗa usheliꞌi u ꞌyoyin. ");
INSERT INTO tswNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Alabariꞌi a baza ta̱ uba̱ta̱ suru a̱tsuma̱ e iɗaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ana Yesu lyawai uba̱ta̱ꞌa̱, a̱yi a̱tsuma̱ a mmalu, a̱vu nrumba̱ n re n toni yi. A̱vu a saala, “Mawun ma̱ Da̱wuda, ka̱lyuwa̱ iliyali i tsu!” ");
INSERT INTO tswNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ana Yesu uwai o uꞌwa u ro, a̱vu nrumba̱ n reꞌe n ta̱wa̱ uba̱ta̱ wa̱ yi. Reve we ece le, “I usu ta̱ n ta gura zuwa ɗu ye ene ure?” A̱vu a̱ usu, “Ee, Zagbain.” ");
INSERT INTO tswNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","A̱vu u juꞌwa̱n esu e le reve u damma, “Adama o ucawu wo okolo a̱ ɗu, ne ɗa woo oꞌwo.” ");
INSERT INTO tswNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Reve amaꞌa a gura ene. Agba u rono le ta̱ atsuvu lon, adansa, “She i damma vuma ro adama a nda wan.” ");
INSERT INTO tswNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Agba ana o uta̱i a̱vu a̱ ka̱ra̱ a bazasa alabariꞌi uba̱ta̱ suru a̱tsuma̱ e iɗaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ele a̱ ma̱ka̱ra̱a̱, a̱vu ama a̱ ta̱wa̱a̱ na̱ vuma ro uba̱ta̱ wa̱ Yesu. Otoni a̱ lima̱† a na a̱ da̱na̱i pe a̱tsuma̱ a vumaꞌa a putsaa yi ta̱ a na waa yuwan adanshi. ");
INSERT INTO tswNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ana Yesu loyi otoni a̱ lima̱ꞌa̱, a̱yi za na shi tsu gura yuwan adanshi shi, a̱vu u fara adanshi. A̱vu oɓolo a amaꞌa a uwa asalama reve a damma, “Koto tse ene cuꞌun vi ili i nda a̱tsuma̱ a Israꞌila shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Reve Afarishi a damma, “Mogono mo otoni a̱ lima̱ ma ɗa ma ca niyi ucira u na u loyi otoni a̱ lima̱ꞌa̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu tonishi ta̱ a burusa ilyuci na̱ mulyuci suru. U ritosu ta̱ a̱ a̱ꞌisa̱, u yuwan ta̱ alajiya a Alabari a Saꞌani adama o tsugono tsa̱ A̱sula̱, a̱vu u ca ama a na a̱ ri ubanakun na̱ mɓa̱la̱ icuꞌun icuꞌun lafiya. ");
INSERT INTO tswNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ana we enei oɓolo a amaꞌa, reve we ene le iliyali lon, adama a na a̱ da̱na̱ ta̱ udamu waru babu ikambi, gashi ikyon i na i ri babu za va aguɓa. ");
INSERT INTO tswNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","A̱vu u damma ojoro a̱ yi, “Ugasa u ta̱ a̱bunda̱, agba a̱za̱ o ugasaꞌa waꞌa ɗa a̱ ri. ");
INSERT INTO tswNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Adama o ndolo i pati za vu uɗuma̱ꞌa̱ u lyungu a̱za̱ o ulinga adama tsa̱ra̱ a yuwaan yi ulinga.” ");
INSERT INTO tswNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","A̱vu Yesu ɗe ojoro† a̱ yi uba̱ta̱ u ta̱, a̱vu u ca le ucira o lo otoni a̱ lima̱, a̱vu a̱ ka̱mba̱to a̱za̱ o ubanakun na̱ mɓa̱la̱ suru gbaga. ");
INSERT INTO tswNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aajiya† o ufaru a̱tsuma̱ a kupa ne ejereꞌe a̱yi ɗa Simo, za na a laꞌa ta̱ reve yi na aala Bituru. Mawun ma̱ a̱na̱wu ma̱ yi Andarawu aajiya ɗa fo, ne ɗa fo Yakubu na̱ Yahaya, olobo e re a̱ Za̱ba̱di. ");
INSERT INTO tswNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filibu fo, oɓolo na̱ Batalamawu, ne ɗa fo Toma, ozo o ro waru ele ɗa Matta za vu uꞌushishi wu utafa,† na̱ Yakubu ulobo wa Alfa, na̱ Tadawu ele fo ajiya ɗa a̱ da̱na̱i. ");
INSERT INTO tswNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Akapi gba ele ɗa Simo, za na a̱ tsu ɗe Bakanani, na̱ Yahuza Iskariyoti, za na winai Yesu. ");
INSERT INTO tswNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ana Yesu lyunguyi Kupanejereꞌe,† apa ili i na u damma nle, “She i uwa uba̱ta̱ wa Atakpaci† wan, waru she i uwa a̱tsuma̱ e ilyuci ya aza a Samariya wan. ");
INSERT INTO tswNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Uba̱ta̱ wa aza a Israꞌila ɗa goon ya̱a̱ ꞌya̱wa̱, adama a na a̱ ta̱ gashi ikyon i na i puwa̱yin. ");
INSERT INTO tswNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ni i ꞌya̱wa̱, i damma a na tsugono tsa zuva tsa̱a̱ la̱pa̱ ta̱wa̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","A̱za̱ o ubanakun i ka̱mba̱to le gbaga, i ꞌya̱sa̱n aza a na a̱ kuwa̱i, nkutu waru i ka̱mba̱to le cece, yu uta̱a̱ otoni a̱ lima̱. Uneꞌe u ɗa i ushiyi, waru i ca pere. ");
INSERT INTO tswNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","She i ɓa̱na̱ ikebe,† ko zinariya, ko azurufa, ko ikebe vu rumushili wan. ");
INSERT INTO tswNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","She i tara tsa̱n ko utugu u ro ko aatan ko aaɗanga wan. Ama a na yaa kambusa, ele fo a kamba ɗu e ili i na i cigai. ");
INSERT INTO tswNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ni i uwa a̱ lyuci ko a̱ ma̱lyuci, i zami vuma va̱ a̱ɓula̱ i da̱nu oɓolo na̱ a̱yi hali i lyawa uba̱ta̱ꞌa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ni i uwa o uꞌwaꞌa, i ca̱sa̱ le a̱vu i damma, ‘A̱zoꞌwa, i da̱na̱ na asuvu nden.’ ");
INSERT INTO tswNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Na ama a na a̱ ri nden pe a̱ usu ɗu, i lyawa asuvu nden a̱ ɗu a̱ da̱na̱ ne ele. Agba na̱ a̱ usu ɗu shi, asuvu nden a̱ ɗu o oꞌwo ya̱ꞌa̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Waru nu uꞌwa ko lyuci a ꞌyuwan a̱ ushi ɗu ko o poloo ɗu atsuvu, i lyawa uba̱ta̱ꞌa̱, a̱vu yi ka̱ka̱la̱ ma̱buta̱ ma ana ma̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Amayun a ɗa maa dansaa ɗu, o urana wu ugeꞌetosu, A̱sula̱ a ta laꞌa roco isaꞌani a̱ tyo a ama o Sodom† na̱ Gomora na ama a̱ lyuciꞌi!” ");
INSERT INTO tswNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Reve Yesu lyuwa elime na adanshi, “N ta̱ lyungusu ɗu ana ikyon a̱tsuma̱ a̱ nkerenkesu. I da̱na̱ nu ugbozu tse iyo, agba i da̱na̱ babu iwuya tsa muɗa. ");
INSERT INTO tswNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","I yuwan ugbozu, adama a na aza a na e reme ɗu a̱ ta̱ lo, a̱vu a̱ ꞌya̱wa̱to ɗu uba̱ta̱ wa̱ a̱za̱ o ugeꞌetosu, reve a zuwa a fufaba ɗu a̱tsuma̱ a̱ a̱ꞌisa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","A̱ ta̱ ꞌya̱wa̱to ɗu a̱ ma̱ka̱ka̱n me igwamna na̱ ngono, adama a na yoo tono mu. U to oꞌwo ɗu ure u na yaa damma le adama a̱ va̱, waru i yuwan alajiya a̱tsuma̱ o uvaɗi. ");
INSERT INTO tswNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mantsa ma na nanza reme nɗu, she i dama adama e ili i na yaa damma ko cine yaa damma wan. A mantsa mo ndolo, A̱sula̱ a ta ca ɗu ili i na yaa damma. ");
INSERT INTO tswNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Adanshi a na oo uta̱ o una̱ u ɗu za ɗu ɗa shi, uba̱ta̱ wa̱ Ruhu va Dada ɗu ɗa woo uta̱ a̱ tyo ya̱ꞌa̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ama a ta wina muwun ma̱ a̱na̱wu n le, tsa̱ra̱ o una le. Ne ɗa fo nsha̱wu maa yuwaan muwun n le. Waru muwun n ꞌya̱sa̱a̱n nsha̱wu n le aci, adama a zuwa o una le. ");
INSERT INTO tswNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ama suru a ta ꞌyuwan ɗu adama a̱ va̱. Amma aza a na a kaɓai asuvu a̱tsuma̱ o ucawu wo okolo e le a̱ tyo o ukosu, A̱sula̱ a ta wawa le. Na ama o ɓongi ɗu a̱ lyuci ro, i lyawa yi i tyo a̱ lyuci ro. ");
INSERT INTO tswNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Amayun a ɗa maa dansaa ɗu, a̱mu Mawun ma Vuma, n ta̱ ta̱wa̱ kafu i ka̱nda̱ruwa̱ ilyuci ya Israꞌila suru. ");
INSERT INTO tswNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mawun ma makaranta ma laꞌa manlu ma̱ yi shi. Waru aagbashi a laꞌa zavuꞌwa va̱ yi shi. ");
INSERT INTO tswNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","U lobono ta̱ mawun ma makaranta mo oꞌwo gashi manlu ma̱ yi, aagbashi waru gashi zavuꞌwa va̱ yi. Ana wo oꞌwoi a̱mu zagbain vu uꞌwa, e ɗe mu ta̱ Baꞌalzabu,† mogono mo otoni a̱ lima̱, ele a̱za̱ o uꞌwa a na a buwai e te ɗe le na ala a na a laꞌai ndolo uwuyanu!” ");
INSERT INTO tswNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","A̱vu waru Yesu dammisa, “She yu uwwa wovon wa ama o ndolo wan, adama a na ili i na i ri usokowu suru gogo, a̱ ta̱ uta̱a̱ yi a alanga e eteshe. ");
INSERT INTO tswNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","A̱tsuma̱ e irumbu a ɗa maa yuwusan ɗu adanshi, a̱ɗu gba i damma yi a̱tsuma̱ e ekan. Ili i na a dammai na̱ yemenu usokowu, i damma yi alanga e eteshe nu uɗyo zuva. ");
INSERT INTO tswNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“She yu uwwa wovon wa aza a na a cigai o una ɗu wan. A ta gura una lipu ɗu goon, agba aa gura una wuma u ɗu shi. Amma yu uwwa wovon wa̱ A̱sula̱, za na aa gura una lipu na̱ wuma a akina. ");
INSERT INTO tswNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ashe a tsu wina nnunu mutali n re kobo ta̱ shi? Agba ko za ta̱ le a̱a̱ kuwa̱ babu urevu wa Dada ɗu shi. ");
INSERT INTO tswNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","A̱sula̱ e reve ta̱ a̱bunda̱ a̱ a̱nji a na a̱ ri a aci a̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Adama o ndolo she yu uwwa wovon wan. I laꞌa ta̱ mutali tsugbain na̱ a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ni i roco ozo o ro a̱ɗu a̱za̱ a̱ va̱ a ɗa, n ta damma Dada va̱ na ri zuva a̱ɗu otoni a̱ va̱ a ɗa. ");
INSERT INTO tswNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Amma ni i wasan mu, n ta damma Dada va̱ za na ri zuva a̱ɗu a̱za̱ a̱ va̱ a ɗa shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","A̱vu Yesu lyuwa elime adansa, “She i yuwan majiyan n ta̱wa̱a̱ ta̱ na asuvu nden a̱tsuma̱ o uvaɗi wan. N ta̱wa̱a̱ na asuvu nden shi, agba matsun me peꞌeni. ");
INSERT INTO tswNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","N ta̱wa̱ ta̱ ‘m ɓolo dada na̱ mawun ma̱ yi nla̱ngi, usheli waru na̱ mma va̱ yi, jene na̱ a̱na̱wa̱le. ");
INSERT INTO tswNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nꞌyuwatan ma̱ wu o uꞌwa wa̱ wu u ɗa oo uta̱!’ ");
INSERT INTO tswNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Aza a na a laꞌa cigai mbara n le, ko mukuci n le na̱ a̱mu, a rawa o toni mu shi. Aza a na a laꞌa cigai olobo ne esheli e le na̱ a̱mu a rawa o toni mu shi. ");
INSERT INTO tswNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ni i ꞌyuwan a tara akpata a̱ a̱tsuma̱lima̱ reve i toni mu, yi ntsaa yoo oꞌwo ojoro a̱ va̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Za na aa yuwusan adama a wuma wa̱ yi, u ta lamba yi. Za na waru ꞌyuwain aciya̱yi adama a̱ va̱ u ta̱ tsura̱ wumaꞌa.” ");
INSERT INTO tswNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Reve Yesu dammisa, “Za na ushi nɗu, u ushi mu ta̱. Waru za na usu numu, u usu ta̱ za na lyungu numu. ");
INSERT INTO tswNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Za na ushiyi vumava̱sula̱ adama a na waa yuwusan adanshi a̱ A̱sula̱, A̱sula̱ a ta ca yi cuꞌun vi iliyinkapa i na waa ca vumava̱sula̱ꞌa̱. Waru vuma na ushiyi vuma va̱ a̱ɓula̱ adama a̱ a̱ɓula̱† a na u ri na̱ a̱yi, u ta̱ tsura̱ cuꞌun vi iliyinkapa yi za va̱ a̱ɓula̱. ");
INSERT INTO tswNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Vuma na cayi vuma ta̱ na laꞌai uka̱la̱mu a̱tsuma̱ a aza a na oo tono mu mini mo oso, adama a na vumaꞌa za na oo tono mu ɗa, amayun vuma ndolo ta̱ tsura̱ iliyinkapa.” ");
INSERT INTO tswNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ana Yesu kotoi a dansaa ojoro kupa ne ejere a̱ yi ili i ndolo suru, a̱vu u lyawa uba̱ta̱ꞌa̱, u ka̱ra̱ a̱ tyo e ilyuci ya̱ Ga̱lili adama u yuwan uritosu na alajiya. ");
INSERT INTO tswNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yahaya za vu Urumbusu da̱na̱ ta̱ pe a̱tsuma̱ o uꞌwa wa ali, a̱vu wu uwwa ili i na Kristi Zamawawa aa yuwusan. A̱vu u lyungu ojoro o ro a̱ yi uba̱ta̱ wa̱ Yesu. ");
INSERT INTO tswNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Reve e ece yi, “A̱vu ɗaɗa za na tsoo purosuꞌu, ko tsu puro vuma ro?” ");
INSERT INTO tswNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","A̱vu u usu le, “ꞌYa̱wa̱i i damma Yahaya ili i na ye enei ni ili i na yu uwwai. ");
INSERT INTO tswNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nrumba̱ me ene ta̱, a̱kutsuma̱ waru a ta mmalu, nkutu n ka̱mba̱ ta̱ gbaga. Agulani a ta uwwusa adanshi, a̱kwa̱kwa̱ waru a̱ ka̱mba̱ ta̱ wuma, alambi fo a ta uwwusa Alabari a Saꞌani. ");
INSERT INTO tswNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","A̱sula̱ a ta zuwaa aza a na a ꞌyuwan numu shi abaꞌun, adama e ili i na maa yuwusan.” ");
INSERT INTO tswNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ana ojoro a Yahaya a̱ ka̱ra̱i, a̱vu Yesu ka̱ra̱ a adanshi a̱ yi uba̱ta̱ wo oɓolo a ama. U damma, “Cuꞌun vuma ne ɗa i ꞌya̱wa̱i ye ene a̱tsuma̱ o ogozo? U rotso ta̱ apumpu a na upepu wa̱a̱ jinga̱ɗa̱sa̱? ");
INSERT INTO tswNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Cuꞌun vuma ne ɗa yu uta̱i ye ene? Vuma na otoyi itana i saꞌani i ɗa? Icuꞌun ya ama o ndolo o ukobu u mogono u ɗa a̱ tsu da̱na̱. ");
INSERT INTO tswNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ili i ne yu uta̱i ye ene? A̱yi vumava̱sula̱ ɗa? Amayun ne ɗaɗa, n ta dansaa ɗu u laꞌa ta̱ vumava̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","A̱sula̱ a yuwan ta̱ adanshi a̱ yi a̱tsuma̱ a Adanshi a̱ A̱sula̱: ‘N ta̱ lyungu malingata ma̱ va̱ elime a̱ wu, tsa̱ra̱ u foɓoo wu ure.’ ");
INSERT INTO tswNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“N ta dansaa ɗu, Yahaya za vu Urumbusu laꞌa ta̱ ama a na a yuwain ɗe wuma. Amma za na laꞌai uka̱la̱mu a̱tsuma̱ o tsugono tsa zuva u laꞌa yi ta̱. ");
INSERT INTO tswNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Diga a mantsa ma na Yahaya ta̱wa̱i hali a̱ tyo anaꞌan, tsugono tsa zuva tsu ta lyuwusa elime nu ucira, waru ama a ta yuwusan ukadu lon tsa̱ra̱ a uwa ɗe. ");
INSERT INTO tswNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ama̱sula̱ suru na̱ Wila̱ a yuwan ta̱ ɗe adanshi o tsugono tsa̱ A̱sula̱ hali a̱ tyo a mantsa ma Yahaya. ");
INSERT INTO tswNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ni i usu adanshi e le, Yahaya a̱yi ɗaɗa Iliya, vumava̱sula̱† na yaa puraꞌa. ");
INSERT INTO tswNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Za na ri na atsuvu, wu uwwa! ");
INSERT INTO tswNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Nye maa damma adama a ama o gogo? Nye i ɗa o rotsoi? O rotso ta̱ muwun n na n ri nden e eden, aza a na a̱ tsu ɗelei: ");
INSERT INTO tswNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tsi ivula̱a̱ ɗu ta̱ aabulu, agba i jeꞌen shi! Tsu cana ta̱ ishipa yu ukwa̱, agba i shon shi!’ ");
INSERT INTO tswNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Ana Yahaya ta̱wa̱i, u yuwan ta̱ akuli, waru u sowo ribina shi, reve a damma, ‘U ta̱ no otoni a̱ lima̱!’ ");
INSERT INTO tswNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Agba Mawun ma Vuma ma̱ ka̱nda̱ruwa̱ ta̱ a lyuwusa nu u sowi, reve waru i damma, ‘Vuma nda liwi ɗa na̱ sowi! Waru a̱yi iꞌutsa̱ ya̱ a̱za̱ o uꞌushishi wu utafa na̱ a̱za̱ o unusu a ɗa.’ Na̱ ne suru a̱ tsu reve ta̱ ugbozu u ta̱ mejege a linga va̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","A̱tsuma̱ e ilyuci i na Yesu yuwain linga va asalama va̱ a̱bunda̱ a̱ yi, ama a ꞌyuwan ta̱ a̱ ka̱mba̱ uba̱ta̱ wa̱ A̱sula̱. Wu uwwa uyoꞌo u le shi, reve u damma, ");
INSERT INTO tswNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Woo yoꞌono ɗu shi, aza a Korasinu! Woo yoꞌono aza a Besaida fo shi! Ni ili ya asalama i na n yuwaan ɗu a̱ shi a yuwan le a̱tsuma̱ a Taya na̱ Sida, a na ama e ilyuciꞌi a̱ shi ta̱ da̱nu na akashi usukutu, tsa̱ra̱ o roco a lyawa ta̱ nusu le! ");
INSERT INTO tswNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","N ta dansaa ɗu, o urana wu ugeꞌetosu A̱sula̱ a ta laꞌa roco ama a Taya na̱ Sida isaꞌani a na woo roco ɗu. ");
INSERT INTO tswNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Agba a̱ɗu, aza a Kafarnahum! I ciga ta̱ a̱ ꞌya̱sa̱n ɗu a̱ tyo zuva? Oꞌo! A ta vari ɗu a̱tsuma̱ a akina! Na̱ a̱ shi a yuwan ili ya asalama i na n yuwain a̱tsuma̱ a̱ ɗu a̱tsuma̱ o Sodom,† hali n gogo u shi ta̱ a̱ da̱na̱ lo! ");
INSERT INTO tswNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Agba n ta dansaa ɗu, o urana wu ugeꞌetosu, i ta laꞌa oꞌwo iliyali na ama o Sodom.” ");
INSERT INTO tswNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","A mantsa mo ndolo Yesu damma ta̱, “Dada, A̱sulazuva a zuva† ni iɗa! N godyoo wu ta̱, adama a na vu rocoi aza a na koto e revei ili shi, ili i na vu sokoyi a̱za̱ o uguru na̱ a̱za̱ o urevu. ");
INSERT INTO tswNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ee, Dada, ne ɗa wu ntsaa nuwu vu yuwan! ");
INSERT INTO tswNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Dada va̱ ca mu ta̱ ili suru. Ko za reve Mawuꞌun shi, she Dada goon. Waru ko za lo revei Dadaꞌa shi, she Mawuꞌun goon, waru na aza a na Mawuꞌun u ɗangwai u damma. ");
INSERT INTO tswNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ta̱wa̱i ya̱ꞌa̱ va̱, suru nɗu aza a na a̱ kuna̱i ni itana yu ume, n ta ca ɗu wivuwun. ");
INSERT INTO tswNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","I tara a̱a̱gba̱la̱ e inan yi iluma a̱ va̱, i rito e ekere a̱ va̱, adama a na a̱mu vuma kpaku ɗa, za na tarai aciya̱yi ili i ro shi, i ta̱ tsura̱ wivuwun o okolo a̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","A̱yi a̱a̱gba̱la̱ꞌa̱ u ta̱ va̱a̱n, itana i va̱ waru a̱ ri ume shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Urana wa Ashibi,† Yesu oɓolo no ojoro a̱ yi a ɓatsasa ta̱ a̱tsuma̱ a̱ a̱ɗuma̱ e ishina. Ojoroꞌo a̱ da̱na̱ ta̱ a uwwusa ambulu, reve e teme a picirasa ishina na a tami. ");
INSERT INTO tswNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ana Afarishi† e enei ne, a̱vu a damma yi, “She ojoro a̱ wu a yuwusan cuꞌun vi ili i nda wan! Wila̱ u putsaa ta̱ a̱ da̱na̱ a kuɗusa ishina o urana wa Ashibi.” ");
INSERT INTO tswNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Reve u usu le, “I reve ili i na Da̱wuda na̱ nꞌutsa̱ ma̱ yi n yuwain, a mantsa ma na a uwwai ambulu shi? ");
INSERT INTO tswNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ana u uwai o uꞌwa wa̱ A̱sula̱, reve a tama opopofu a̱ Wila̱, ko na wo oꞌwoi Wila̱ u putsaa le ta̱ na aa tama.† Nan ganu† ɗa goon a lyawai a tama opopofuꞌu. ");
INSERT INTO tswNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Koto i ɗenuna̱ a̱tsuma̱ a̱ Wila̱ wa Musa a na nan ganu a ɗa a lyawai a linga a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗa urana wa Ashibi shi? Agba ko za damma a nusan ta̱ a kuɗa ta̱ wila̱ wa Ashibi shi. ");
INSERT INTO tswNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Amayun a ɗa maa dansaa ɗu, za ro ta̱ pa za na laꞌai A̱a̱ꞌisamapaɗaꞌa! ");
INSERT INTO tswNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Agba i shi e geꞌeto aza a na a̱ ri nu unusu shi, ni i shi i reve ucuɗuwu wa Adanshi a̱ A̱sula̱ a nda, ‘A na yaa yuwaan mu kucci, u laꞌaa ɗu ta̱ ye ene iliyali yo ozo o ro.’ ");
INSERT INTO tswNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Adama a na a̱mu, Mawun ma Vuma, Zagbain va Ashibi ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","A̱vu Yesu ꞌyon, reve u uwa a̱tsuma̱ a̱ a̱a̱ꞌisa̱† a na a̱ ri lo zuzu. ");
INSERT INTO tswNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ana u uwai, a̱vu u cina pe vuma no osowi o ukere. Afarishi a zuwusa ta̱ esu tsa̱ra̱ e reme Yesu nu unusu, a̱vu e ece yi, “U lobono ta̱ a yuwan ulinga wo opocino o urana wa Ashibi?” ");
INSERT INTO tswNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Reve u usu le, “Na̱ vu ri na̱ kyon, a̱vu u riya̱ a̱tsuma̱ o ookoꞌo o urana wa Ashibi, vee reme vu uta̱a̱ yi shi? Vu to uta̱a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ama a laꞌa ta̱ ikyon, adama o ndolo wu ntsaa ta̱ a yuwan ulinga u saꞌani o urana wa Ashibi.” ");
INSERT INTO tswNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Reve u damma vumaꞌa, “Canana ukere wa̱ wu.” A̱vu u canana, reve ukereꞌe u ka̱mba̱ gbaga gashi za ve ire. ");
INSERT INTO tswNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","A̱vu Afarishiꞌi a̱ ka̱ra̱, reve a dammulai cine aa yuwan tsa̱ra̱ o una yi. ");
INSERT INTO tswNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu reve ta̱ ifoɓi i na Afarishi aa yuwusan, ɗaɗa u lyawai uba̱ta̱ꞌa̱. Ama na̱ a̱bunda̱ o toni yi ta̱, reve u ka̱mba̱to ama a na a̱ da̱na̱i na̱ banakun suru gbaga. ");
INSERT INTO tswNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Agba u rono le ta̱ atsuvu she a damma vuma ko zane ɗa u ri wan. ");
INSERT INTO tswNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","U yuwan ta̱ ne tsa̱ra̱ u shiton ili i na A̱sula̱ a dammai o una̱ wa Ishaya vumava̱sula̱: ");
INSERT INTO tswNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Apa aagbashi a̱ va̱, za na n ɗangwai. N ciga yi ta̱, waru u tsu yuwan ta̱ ili i na yoo yoꞌonotosu mu okolo. N ta zuwaa yi Ruhu va̱, waru u ta damma ama suru adama a̱ a̱ɓula̱ a̱ va̱. ");
INSERT INTO tswNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Waa yuwan mawasan shi, waru waa yuwan adanshi ni yisaali shi, ko u yuwan adanshi nu ucira e re shi. ");
INSERT INTO tswNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Waa kuɗa aapumpu a na a̱ ri uka̱nzu shi, waru wa̱a̱ kimusa̱ fitila na cigai ma̱kima̱a̱ shi. Ne ɗa waa lyuwa elime she ni isaꞌani i lyuwa aci e iwuya. ");
INSERT INTO tswNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Waru ama biti a ta zuwa okolo a ala a̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","A̱vu ama o ro a̱ ta̱wa̱a̱ Yesu na̱ vuma na da̱na̱i irumba̱, waru u tsu gura yuwan adanshi shi, adama a na u ta̱ no otoni a̱ lima̱. U ka̱mba̱to ta̱ vumaꞌa gbaga, hali u gura yuwan adanshi reve waru u gura ene. ");
INSERT INTO tswNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ama suru o oꞌwo ta̱ a asalama a̱vu a damma, “Vumaꞌa Mawun ma̱ Da̱wuda ma ɗa? A̱yi ɗaɗa Zamawawaꞌa?” ");
INSERT INTO tswNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ana Afarishi a uwwai ne, reve a damma, “U lo ta̱ otoni a̱ lima̱ nu ucira u na Baꞌalzabu,† mogono mo otoni a̱ lima̱ ma ca niyi.” ");
INSERT INTO tswNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu reve ta̱ majiyan me le, ɗaɗa u damma nle, “Iɗa i na i neꞌeshenlei aciya̱yi, reve o oꞌwo a̱ la̱ngi va̱ni le u ta̱ riya̱. Waru lyuci ko ama o uꞌwa a na e neꞌeshenlei aciyele, reve o oꞌwo a̱ la̱ngi va̱ni le a̱ ta̱ riya̱. ");
INSERT INTO tswNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Waru na̱ Male† ma ɗa moo uta̱sa̱a̱ Male, a ta dansa tsugono tsa̱ yi tse neꞌeshen ta̱ ure, waru wa̱a̱ la̱pa̱ riya̱ shi! ");
INSERT INTO tswNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","I damma ta̱ a na n lo ta̱ otoni a̱ lima̱ adama a na Baꞌalzabu ca numu ucira n yuwan ne. To, zane cayi ojoro a̱ ɗu ucira o lo le? Ili i na ojoro a̱ ɗu aa yuwusan u roco ta̱ amayun a ɗa ɗu shi! ");
INSERT INTO tswNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Amma gba na̱ moo losu otoni a̱ lima̱ nu ucira u Ruhu va̱ A̱sula̱, to, tsugono tsa̱ A̱sula̱ tsa̱ ta̱ pa a̱tsuma̱ a̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Na̱ vuma ciga u uwa a̱tsuma̱ o uꞌwa wu za vu ucira u yuwan wivu, u ciga u ꞌyuwan wu nla̱ neꞌen za vu uciraꞌa. Ne ɗa waa yuwan a̱vu u tsura̱ u yuwan wivu a̱tsuma̱ o uꞌwaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Za na aa kambusa mu shi, u ta tsurala na̱ a̱mu. Za na waru aa yuwusan ulinga oɓolo na̱ a̱mu shi, amayun u ta̱ tsushuꞌun na̱ a̱mu. ");
INSERT INTO tswNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","N ta dansaa ɗu, A̱sula̱ a ta yuwaan ama a na a yuwayin ama unusu gafura, hali na aza a na aa yuwusaan A̱sula̱ adanshi a vama.† Amma amayun A̱sula̱ aa yuwaan aza a na a yuwayin Ruhu va Akiza adanshi a vama gafura shi. ");
INSERT INTO tswNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Za na yuwain adanshi a vama adama a Mawun ma Vuma† a ta yuwaan yi gafura, amma za na yuwayin Ruhu va Akiza adanshi a vama, aa yuwaan yi gafura shi, ko gogo, ko a mantsa ma na ma̱a̱ ta̱wa̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","A̱vu Yesu lyuwa elime na adanshi, “I ta gura damma ko cuꞌun vu uɗanga u ne u ɗa, na̱ cuꞌun muwun n na u matsain. Uɗanga u saꞌani, muwun n saꞌani n ɗa u tsu matsan kuci, uɗanga u babu ulobonu gba shi, she muwun m babu ulobonu. ");
INSERT INTO tswNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","A̱ɗu apili! I ri ama a saꞌani shi, adama o ndolo cine yaa gura yuwan adanshi e ili i saꞌani? Vuma suru u tsu damma ta̱ ili i na i ri pe a̱tsuma̱ o ookolo a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Vuma va̱ a̱ɓula̱ u tsu uta̱a̱ ta̱ ni ili i saꞌani i na u zuwai o ookolo, za vu ulambu wa̱ a̱ɓula̱ waru e ili yu ulambu wa̱ a̱ɓula̱ a na u zuwai o ookolo pe ɗa a̱ tsu uta̱. ");
INSERT INTO tswNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","N damma ɗu, o urana wu ugeꞌetosu i ta damma idanshi i vanvama i na i dammai suru. ");
INSERT INTO tswNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Adama a na ni i damma ili i saꞌani, A̱sula̱ a ta damma i ri nu unusu shi. Amma ni i damma idanshi i vanvama, u ta damma i ta̱ nu unusu.” ");
INSERT INTO tswNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Reve, munlu n Wila̱ na Afarishi a̱ ta̱wa̱ uba̱ta̱ wa̱ Yesu, reve a damma, “Manlu, tsu ciga ta̱ vu yuwan ulinga wa asalama† tse ene, tsa̱ra̱ u ca tsu iroci i na uba̱ta̱ wa̱ A̱sula̱ ɗa vu uta̱i.” ");
INSERT INTO tswNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Reve u usu le, “I ciga ta̱ iroci adama a na a̱ɗu ama e iwuya na̱ a̱za̱ o ulambu wa̱ a̱ɓula̱ a ɗa, agba yaa ca okolo shi! Amma iroci i na ya̱a̱ tsura̱ a̱yi ɗa iroci ya Yunana† vumava̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yunana da̱na̱ ta̱ a̱tsuma̱ a̱ a̱a̱tsuma̱ a magula ma gbain hali ayin a taꞌatsu. Ne ɗa fo a̱mu Mawun ma Vuma ma̱a̱ da̱na̱ a aason hali ayin a taꞌatsu. ");
INSERT INTO tswNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","O urana wu ugeꞌetosu, ama a̱ Niniva† e te isawan oɓolo na̱ a̱ɗu a̱vu e geꞌeto ɗu. Ana Yunana yuwain alajiya, a vadala† ta̱ a̱ ka̱mba̱ uba̱ta̱ wa̱ A̱sula̱. Gogo vuma na laꞌai Yunana ta̱ pa. ");
INSERT INTO tswNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Waru Egbere va Sheba fo u te isawan u geꞌeto ɗu. U yuwan ta̱ mmalu ma alanga, tsa̱ra̱ wu uwwa ugbozu wa̱ Sulemanu.† Gogo gba za na laꞌai Sulemanu ta̱ pa.” ");
INSERT INTO tswNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yesu lyuwa ta̱ elime na adanshi, “A damma vuma ro da̱na̱ ta̱ no otoni a̱ lima̱† a̱ ta̱ goon. Reve otoni a̱ lima̱ꞌa̱ wu uta̱ a̱tsuma̱ a vumaꞌa, u tsu gara ta̱ a̱tsuma̱ e iɗa ba̱ta̱ o uꞌyewu e izami yu uba̱ta̱ u na wee ivuwan, agba wa̱a̱ tsura̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Otoni a̱ lima̱ꞌa̱ u ta damma, ‘N ta̱ ka̱mba̱ o uꞌwa u na n lyawai.’ Nu u ka̱mba̱, a̱vu u cina uꞌwaꞌa babu ili. A raɗa yi ta̱, reve o oꞌwoto yi cece. ");
INSERT INTO tswNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","A̱vu wu uta̱ reve u ta̱wa̱to otoni a̱ lima̱ e cindere o ro aza a na a laꞌa niyi ucira, a̱vu a uwa pe a̱ da̱nu. Vumaꞌa u ta̱ da̱na̱ a̱tsuma̱ a addama a na a laꞌai cine u da̱na̱i nu ufaru. Ili i na yaa cina ama e iwuya o gogo ɗa nda.” ");
INSERT INTO tswNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu a yuwusaan ama adanshi, a̱vu mma va̱ yi na̱ muwun ma̱ a̱na̱wu ma̱ yi n rawa. Reve e isawan a alanga a̱vu a damma a yuwaan yi adanshi. ");
INSERT INTO tswNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Reve vuma ro yuwaan yi adanshi, “Mma va̱ wu na̱ muwun ma̱ a̱na̱wu ma̱ wu a̱ ta̱ ɗe a alanga a pura wu, a ciga ta̱ a yuwan adanshi na̱ a̱vu.” ");
INSERT INTO tswNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","A̱vu u usu, “Zane ɗa mma va̱? Nan zane ɗa waru muwun ma̱ a̱na̱wu n va̱?” ");
INSERT INTO tswNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","A̱vu u sapi a̱ tyo uba̱ta̱ wa aza a na oo tono yi reve u damma, “Apa nan mma va̱ na̱ muwun ma̱ a̱na̱wu n va̱. ");
INSERT INTO tswNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Aza a na a yuwain tsutoni na̱ Dada va̱ za na ri zuva, ele ɗa mma va̱ na̱ muwun ma̱ a̱na̱wu n va̱ mo olobo ne esheli.” ");
INSERT INTO tswNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","A̱tsuma̱ o urana u ndolo, a̱vu Yesu lyawa uꞌwaꞌa, a̱vu u ka̱ra̱ a̱ tyo a̱ ngeꞌen m mala, uba̱ta̱ u na u da̱nuyi adama u yuwan uritosu. ");
INSERT INTO tswNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Oɓolo a ama a na o ɓolotoi a̱ da̱na̱ ta̱ a̱bunda̱ lon, hali u zuwa yi u uwa a wantsun, a̱vu u da̱nu pe, ama ɗe a aagaɗi. ");
INSERT INTO tswNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","A̱vu u roco le ili na̱ a̱bunda̱ a̱tsuma̱ e iroci. Reve u damma, “A yuwan ta̱ cimbi ro za na ꞌya̱wa̱i mazaza me icuꞌun a̱tsuma̱ o uɗuma̱ wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","A̱yi a̱tsuma̱ a mazaza, a̱vu ozo o ro o oco yi o ure, reve nnunu n ta̱wa̱ n ka̱ka̱ɗa̱ le. ");
INSERT INTO tswNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Reve ozo o ro o oco ba̱ta̱ a atali, uba̱ta̱ u na u ri na̱ ma̱bula̱ waꞌa. A̱vu o uta̱ babu usa̱n, adama a na ma̱bula̱ꞌa̱ ma̱ ri waꞌa. ");
INSERT INTO tswNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ana urana u yuwain, reve u kpanlato le, adama a na aralu e le a̱ ri a̱ruꞌun shi, a̱vu e ꞌyewushi. ");
INSERT INTO tswNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ozo o ro gba o oco a awanda, a̱vu awanda a̱ ꞌyon, reve a gbagbala le. ");
INSERT INTO tswNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ozo o ro gba o oco a̱ ma̱bula̱ ma saꞌani, a̱vu a kungwa a matsan ulobonu. Cuꞌun na cimbiꞌi u cuꞌwa̱in suru, ozo o ro a matsan ta̱ mataꞌatsu mataꞌatsu, ozo o ro kupota̱li-uta̱li, ozo o ro ukpaku ukpaku. ");
INSERT INTO tswNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Za na ri na atsuvu, wu uwwa!” ");
INSERT INTO tswNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Reve ojoro a̱ yi e ece yi, “Nye i zuwai vaa yuwusaan ama adanshi ni iroci?” ");
INSERT INTO tswNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A̱vu u usu le, “A̱ɗu ɗa a ɗangwai tsa̱ra̱ i reve ili yu usokowu i tsugono tsa zuva, agba ozo o ro e reve ili yu usokowu i nda shi. ");
INSERT INTO tswNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Za na ri ni ili, a̱yi ɗa a̱a̱ da̱shi yi lon, waru za na ri ni ili shi, waꞌa na u ri na̱ a̱yi, a̱ ta̱ ushi yi i ɗa. ");
INSERT INTO tswNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ili i na i zuwai n tsu yuwusaan le adanshi ni iroci a̱yi ɗa: ‘A̱ ta̱ ka̱lyuwa̱, agba ee ene shi, a ta zuwa atsuvu, agba aa uwwa ko a̱ tsura̱ urevu shi.’ ");
INSERT INTO tswNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Adanshi a̱ A̱sula̱ a shiwan ta̱, cine Ishaya vumava̱sula̱ dammai: ‘Ama a ta uwwa adanshi a̱ va̱, agba ee reve ili i na maa dansa shi. E te eneshe ili i na maa yuwusan, agba urevu wa̱ yi u ta̱ puwa̱n le. ");
INSERT INTO tswNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Adama a na ama a nda a gbama ta̱ okolo, waru atsuvu e le a ula ta̱, waru a̱ kpa̱to ta̱ esu, adama o ndolo ee ene shi, waru atsuvu e le aa uwwa shi, okolo e le a̱a̱ tsura̱ urevu shi, waru a̱a̱ ka̱mba̱ uba̱ta̱ u va̱, tsa̱ra̱ n ka̱mba̱to le gbaga shi.’ ");
INSERT INTO tswNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Amma A̱sula̱ a zuwaa ɗu ta̱ abaꞌun, adama a na esu a̱ ɗu e te ene waru atsuvu a̱ ɗu a ta uwwa! ");
INSERT INTO tswNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ama̱sula̱ na̱ a̱bunda̱ na ama a saꞌani a̱ da̱na̱ ta̱ a maluwa tsa̱ra̱ e ene ili i na yee inda, tsa̱ra̱ waru a uwwa ili i na yaa uwwusa. Amma n damma ɗu e ene shi, waru a uwwa shi. ");
INSERT INTO tswNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Zuwai atsuvu, adama i tsura̱ ucuɗuwu wi iroci yi cimbiꞌi. ");
INSERT INTO tswNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Icuꞌun i na yo ocoi a̱ ngeꞌen mu ure, ele ɗa ama a na a uwwai adanshi o tsugono tsa̱ A̱sula̱, agba a̱ tsura̱ urevu wa̱ yi shi. A̱vu za wuya ta̱wa̱, reve u usa adanshiꞌi a̱tsuma̱ o okolo e le. ");
INSERT INTO tswNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Icuꞌun i na yo ocoi ba̱ta̱ a atali, ele ɗa aza a na a̱ ushiyi adanshiꞌi na̱ ma̱za̱nga̱ babu usa̱n. ");
INSERT INTO tswNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Agba a̱ ri na aralu a̱ a̱ruꞌun shi, adama o ndolo a jima shi. Ana nden mu uvaɗi n suɗuwai, ko adanshiꞌi a zuwa nle a addama, a̱vu a̱ riya̱. ");
INSERT INTO tswNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Aza a na o ocoi a awanda, ele ɗa ama a na a uwwai adanshiꞌi, reve a uwa a̱tsuma̱ a̱tsuma̱lima̱ o uvaɗi u nda, reve waru icigi i na oo oꞌwo nu utsuru wu luma̱ le. Reve a gbagbala adanshiꞌi a putsaa le a bala. ");
INSERT INTO tswNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Aza a na o ocoi a̱ ma̱bula̱ ma saꞌani, ele ɗa ama a na a uwwai adanshiꞌi, a̱vu a̱ tsura̱ urevu wa adanshiꞌi. Cuꞌun vuma ndolo tsu matsan ta̱ ulobonu, mantsa mo ro gba shi, mataꞌatsu mataꞌatsu, mantsa mo ro gba kupota̱li-uta̱li, mantsa mo ro ukpaku ukpaku.” ");
INSERT INTO tswNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","A̱vu Yesu yuwaan le iroci i ro: “Tsugono tsa zuva tsu ta̱ ne tsunda: Cimbi ro zaza ta̱ icuꞌun i saꞌani a̱tsuma̱ o uɗuma̱ wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Na ayin, mantsa ma na ama a lantsai suru, a̱vu maꞌyuwatan ma̱ yi ma̱ ꞌya̱wa̱ u cuꞌwa̱a̱n yi ewenwele a̱tsuma̱ e iwele reve u ka̱ra̱. ");
INSERT INTO tswNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ana iweleꞌe i farai a kungusa tsa̱ra̱ a matsan, reve fo ewenweleꞌe a kungwa oɓolo ne ele. ");
INSERT INTO tswNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Reve agbashi a vumaꞌa a̱ ta̱wa̱ uba̱ta̱ wa̱ yi a̱vu a damma yi, ‘Vu cuꞌwa̱n ta̱ icuꞌun i saꞌani o uɗuma̱ wa̱ wu. Te ɗa ewenwele o uta̱i?’ ");
INSERT INTO tswNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Reve u usu, ‘Maꞌyuwatan ma ɗa ma̱ cuꞌwa̱in ewenweleꞌe.’ “Reve e ece yi, ‘Vu ciga tsu ta̱ tsu mula̱ ewenweleꞌe?’ ");
INSERT INTO tswNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“A̱vu u usu, ‘Oꞌo, adama a na na̱ yi mula̱ ewenweleꞌe gogo, i ta̱ mula̱ iwele fo. ");
INSERT INTO tswNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Lyawai iweleꞌe a kungwa oɓolo, hali a̱ tyo a mantsa me ikani. Reve n damma aza a zamalinga: Ɓolotoi ewenweleꞌe uba̱ta̱ u ta̱ neꞌen, a̱vu yi nla̱ le tsa̱ra̱ i kula̱to le. A̱vu i ɓoloto iweleꞌe i ta̱wa̱to le o mopon ma̱ va̱.’ ” ");
INSERT INTO tswNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","A̱vu Yesu dammisa le iroci i ro, u damma, “Apa cine tsugono tsa zuva tsa̱ ri: Vuma ro tara ta̱ oroci a suꞌwanꞌuri, reve u cuꞌwa̱n yi a̱tsuma̱ o uɗuma̱ wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","A̱yi ɗa cuꞌun na laꞌai uka̱la̱mu a̱tsuma̱ e icuꞌun, agba nu u kungwa, u tsu laꞌa ta̱ olopu biti mgbain. U tso oꞌwo ta̱ a̱ba̱jini o uɗanga, hali nnunu n ta̱wa̱ n yuwan ɗe nkinda e eten a̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","A̱vu Yesu yuwusaan le iroci i ro, “Apa a nda cine tsugono tsa zuva tsa̱ ri: Ka tsu tara ta̱ wolilo† a̱vu u ja̱mba̱ra̱ yi a yira a̱tsuma̱ e meretsu, she nu u ja̱mba̱ra̱ yi suru suru, a̱vu u tsutsa.” ");
INSERT INTO tswNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu yuwusan ta̱ adanshi ni iroci adama u damma oɓolo a ama ili i nda suru. U tsu damma le ili i ro babu na u yuwain adanshi ni iroci shi. ");
INSERT INTO tswNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","U yuwan ta̱ ne tsa̱ra̱ u shiton ili i na vumava̱sula̱ dammai, “N ta yuwaan ɗu adanshi ni iroci. N ta damma ili i na i ri usokowu diga a mantsa ma na A̱sula̱ a yuwain uvaɗi.” ");
INSERT INTO tswNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ana Yesu lyawai oɓolo a amaꞌa, a̱vu u uwa a̱tsuma̱ o uꞌwa, reve ojoro a̱ yi a̱ ta̱wa̱ uba̱ta̱ wa̱ yi a̱vu a damma, “Damma tsu urevu wi iroci ye ewenwele a̱tsuma̱ o uɗuma̱ꞌa̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Reve u usu le, “Za na zazai icuꞌun i saꞌaniꞌi a̱yi ɗa Mawun ma Vuma. ");
INSERT INTO tswNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Uɗuma̱ waru gba a̱yi ɗa uvaɗi. Ele icuꞌun i saꞌani ele ɗa ama a na a̱ ri ozo o tsugonoꞌo. Ele gba icuꞌun ye ewenwele ele ɗa aza a na o uta̱i uba̱ta̱ wu za wuya. ");
INSERT INTO tswNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Maꞌyuwatan ma na ma zaza nle a̱yi ɗa Mekerenkesu. Mantsa me ikani a̱yi ukosu wu uvaɗi. Aza a zamalinga a na oo ɓoloto le, ele ɗa nlingata ma̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“O tsu ɓoloto ta̱ ewenwele a̱vu a̱ kula̱to. Ne ɗa woo oꞌwo a mantsa mo ukosu. ");
INSERT INTO tswNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","A̱mu Mawun ma Vuma, n ta̱ lyungu nlingata n va̱, a ta tawa ili i na i tsu zuwa unusu suru a̱tsuma̱ o tsugono tsa̱ va, waru na aza a na aa yuwusan iwuya suru. ");
INSERT INTO tswNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","A ta vari le a̱tsuma̱ a̱ a̱a̱ka̱ri a na a̱ ri tapu na akina a na a̱ ri usuɗuwu lon, uba̱ta̱ u na ama a̱ da̱na̱ a̱ shosun na a lumi anga e le na̱ mɓa̱la̱. ");
INSERT INTO tswNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ele gba ama a̱ a̱ɓula̱ a̱ te ikana gashi urana o tsugono tsa Dada le. Za na ri na atsuvu, wu uwwa!” ");
INSERT INTO tswNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","A̱vu Yesu lyuwa elime na adanshi, “Apa cine tsugono tsa zuva tsa̱ ri: Vuma ro tsura̱ ta̱ uzuwa u na vuma ro sokoi a̱tsuma̱ o uɗuma̱. A̱vu wu palisa yi. U yuwan ta̱ ma̱za̱nga̱ a̱vu u ꞌya̱wa̱ u wina ili i na u ri na̱ a̱yi suru, a̱vu u ka̱mba̱ u tsula uɗuma̱ꞌa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Waru, apa cine tsugono tsa zuva tsa̱ ri: Za va atsulu na awina ro te izami yi iyeɗi yi ikebe.† ");
INSERT INTO tswNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nu u tsura̱ za na laꞌai ulobonu, reve u ꞌya̱wa̱ u wina ili i na u ri na̱ a̱yi suru tsa̱ra̱ u tsula yi. ");
INSERT INTO tswNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Waru, apa cine tsugono tsa zuva tsa̱ ri: A̱za̱ e mereme ma mugula n ro a vari ta̱ igolo i le a̱tsuma̱ a mala, a̱vu e reme mugula icuꞌun icuꞌun. ");
INSERT INTO tswNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ana igoloꞌo i shiwain, a̱vu o rono yi o uta̱ a alanga, reve a̱ da̱nu tsa̱ra̱ a kakasa mugulaꞌa. Mugula n saꞌani a̱vu a zuwa le a̱tsuma̱ a aasaꞌatsu, aza a na a̱ ri ulobonu shi gba, o oco le. ");
INSERT INTO tswNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ne ɗa woo oꞌwo mantsa mo ukosu. Nlingata n ta̱ ta̱wa̱ a kakasa a̱za̱ e iwuya a̱tsuma̱ a ama a̱ a̱ɓula̱. ");
INSERT INTO tswNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nlingataꞌa n ta vari a̱za̱ e iwuya a̱tsuma̱ a̱ a̱a̱ka̱ri a na a̱ ri tapu na akina a na a̱ ri usuɗuwu lon, uba̱ta̱ u na ama a̱a̱ da̱na̱ a̱ shosun na a lumi anga na̱ mɓa̱la̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","A̱vu Yesu ece le, “I gura ta̱ reve ili i nda suru?” Reve a̱ usu, “Ee, tsu tsura̱ ta̱ urevu wa̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Reve u damma le, “Manlu ma̱ wila̱ ma na suru ma̱ tsura̱i urevu u tsugono tsa zuva u rotso ta̱ vuma na oo uta̱su akuci nu uzuwa u saꞌavu a alanga a̱tsuma̱ o mopon.” ");
INSERT INTO tswNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ana Yesu kotoi adansa iroci i nda, a̱vu u lyawa uba̱ta̱ꞌa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Reve u ka̱mba̱ Nazara, lyuci na u kungwai. Ana u yuwain uritosu ɗe a̱tsuma̱ a̱ a̱a̱ꞌisa̱,† ama suru a yuwan ta̱ asalama a̱vu a damma, “Te ɗa u tsura̱i ugbozu nu ucira u na waa yuwusan ili ya asalama i nda? ");
INSERT INTO tswNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","A̱yi mawun ma za vu usheꞌen ma ɗa. Meri† ɗa mma va̱ yi, waru muwun ma̱ a̱na̱wu ma̱ yi ele ɗa, Yakubu, na̱ Isuhu, na̱ Simo na̱ Yahuza. ");
INSERT INTO tswNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Muwun ma̱ a̱na̱wu me esheli ma̱ yi suru a̱ ta̱ pa oɓolo na̱ a̱tsu. Cine tsa ɗa waa gura yuwan ulinga u nda suru?” ");
INSERT INTO tswNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Adama o ndolo ugbozu u le u da̱nu na̱ a̱yi shi, a̱vu a ꞌyuwan yi. Reve gba u damma le, “Vumava̱sula̱ ri na̱ tsugbain a̱ lyuci no o uꞌwa wa̱ yi shi, she a̱ lyuci ro.” ");
INSERT INTO tswNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Adama o ndolo, u gura yuwan ili ya asalama ya̱ a̱bunda̱ a̱ lyuci va̱ yi shi, adama a na a̱ ri nu ucawu wo okolo shi. ");
INSERT INTO tswNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","A mantsa mo ndolo, Hiridu Antiba, mogono ma̱ Ga̱lili, ma uwwa ta̱ adama e Yesu. ");
INSERT INTO tswNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","A̱vu u damma agbashi a̱ yi, “Yesu Yahaya za vu Urumbusu ɗa, za na a̱ ꞌya̱sa̱in a̱tsuma̱ a̱ a̱kwa̱kwa̱. A̱yi ɗa i zuwai waa yuwusan cuꞌun vi ili ya asalama a nda.” ");
INSERT INTO tswNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Kafu mantsa ma nda, Hiridu usa ta̱ Hiridiya a̱yi ubuwu ka mawun ma̱ a̱na̱wu ma̱ yi Filibu. Yahaya† dansaa yi ta̱, “U ri ulobonu vu zuwa Hiridiya shi!” Reve u zuwa e reme Yahaya a̱ nla̱ yi, a̱vu a zuwa yi a̱tsuma̱ o uꞌwa wa ali. ");
INSERT INTO tswNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","U shi ta̱ u ciga wu una yi, agba wu uwwusa ta̱ wovon wa ama, adama a na a̱ usu ta̱ Yahaya vumava̱sula̱ ɗa. ");
INSERT INTO tswNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ana a cuwusan nu urana u na a matsain Hiridu, a̱vu usheli wa Hiridiya u jeꞌeen Hiridu oɓolo no omocin a̱ yi, a̱vu u zuwa okolo a̱ yi o yoꞌono. ");
INSERT INTO tswNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Reve u kucina na waa ca yi ili i na u cigai biti. ");
INSERT INTO tswNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","A̱vu mma vu usheliꞌi u damma yi u damma, “N ciga ta̱ aaci a Yahaya za vu Urumbusu a mapara ma nda!” ");
INSERT INTO tswNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","A̱vu mogonoꞌo u yuwan shinreve vi ili i na u dammai. Agba u ciga u ꞌya̱sa̱n nzuwulai n na u yuwain a̱ ma̱ka̱ka̱n mo omocin a̱ yi shi. A̱vu u damma a̱soja a̱ yi, ");
INSERT INTO tswNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","a̱ ꞌya̱wa̱ o uꞌwa wa ali o koɗo aaci a Yahaya za vu Urumbusu. ");
INSERT INTO tswNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A̱vu a̱ ta̱wa̱a̱ na aaciꞌi a mapara a̱vu a ca usheliꞌi, a̱vu usheliꞌi u ꞌya̱wa̱a̱ mma va̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Reve ojoro a Yahaya a̱ ta̱wa̱ a tara lipu va̱ yi a̱ ciɗo. A̱vu a̱ ꞌya̱wa̱ a̱ ka̱mbuwa̱ Yesu ili i na i farai. ");
INSERT INTO tswNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ana Yesu uwwai alabari o ndolo, reve u uwa a wantsun, a̱vu u ka̱ra̱ a̱ tyo o una tsa̱ra̱ u da̱na̱ a̱yi a̱ ndeꞌen. Agba ana oɓolo a amaꞌa a uwwai ne, reve o toni yi na̱ mmalu o tono ngeꞌen m mala. ");
INSERT INTO tswNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ana u rawai, a̱vu u cina a̱ba̱jini o oɓolo a ama a pura yi. Reve we ene le iliyali, a̱vu u ka̱mba̱to aza a na a̱ da̱na̱i ubanakun suru gbaga. ");
INSERT INTO tswNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Urana a zama ma̱riya̱a̱, a̱vu ojoro a̱ yi a̱ ta̱wa̱ uba̱ta̱ wa̱ yi a̱vu a damma, “Urana u koto ta̱, uba̱ta̱ u nda gba ogozo a ɗa. Damma amaꞌa e beteꞌwe, tsa̱ra̱ a̱ ꞌya̱wa̱ a̱ mulyuci a tsulaa aciyele ilyalya a lyuwa.” ");
INSERT INTO tswNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Reve u usu le, “Ili yi lo i na yaa zuwa le a̱ ka̱ra̱ shi. I ꞌya̱wa̱ i ca le ilyalya a lyuwa.” ");
INSERT INTO tswNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","A̱vu a damma yi, “Opopofu o ton a ɗa tsu ri ne ele na̱ mugula n re goon.” ");
INSERT INTO tswNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Reve u damma le, “Ta̱wa̱a̱ numu no opopofuꞌu na̱ mugulaꞌa.” ");
INSERT INTO tswNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","A̱vu u damma amaꞌa a̱ da̱nu a anlya. A̱vu u tara opopofu o toꞌon na̱ mugula n reꞌe, a̱vu u ka̱lyuwa̱ zuva, reve u godyoo A̱sula̱ adama e ilyalya. Reve u neꞌeshen opopofuꞌu, a̱vu u ca ojoro a̱ yi, reve ele a ca ama. ");
INSERT INTO tswNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ama suru a lyuwa ta̱ hali a̱ cuwa̱n. Reve ojoroꞌo o shiton asaka kupa ne ejere na akapi e ilyalya i na i buwai. ");
INSERT INTO tswNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ali a na a lyuwai ilyalya i ndolo a ta rawa ali ukpakukupa uton (5,000), e kece a̱ma̱ci na̱ muwun shi. ");
INSERT INTO tswNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","A̱vu Yesu dammushi ojoro a̱ yi a uwa a wantsun tsa̱ra̱ a̱ ka̱ra̱ elime a̱ yi upasalai u mala. U da̱na̱ ta̱ lo tsa̱ra̱ u lyawa ama a̱ ka̱mba̱ a ꞌwa le. ");
INSERT INTO tswNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ana u lyawa nle a̱ ka̱ra̱i a ꞌwa, reve u ka̱ra̱ a̱ ꞌya̱wa̱ a agaɗi na aciya̱yi tsa̱ra̱ u yuwan avasa. Ayin a ɗa a̱ da̱na̱i, a̱vu gba u da̱na̱ ɗe a̱yi a̱ ndeꞌen. ");
INSERT INTO tswNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A matsan mo ndolo, wantsun wo ojoro a̱ yi u da̱na̱ ta̱ e memere ma malaꞌa, waru upepu wu ucira u ꞌyon ta̱. A̱ da̱na̱ ta̱ o mpolo ni ikeɗu i mala i gbain. ");
INSERT INTO tswNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Na̱ wasasa, a̱vu u ta̱wa̱ uba̱ta̱ u le a mmalu zuva mini. ");
INSERT INTO tswNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ana e ene niyi a mmalu zuva mini tsundolo, a uwwa ta̱ wovon. A̱vu a saala na̱ wovon, “Yimoɗi i ɗa!” ");
INSERT INTO tswNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Reve u yuwushin nle adanshi, u damma, “U rawa ta̱ ne, n ta̱ pa! She yu uwwa wovon wan.” ");
INSERT INTO tswNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","A̱vu Bituru damma, “Zagbain, na̱ a̱vu ɗa mayun, damma mu n ta̱wa̱ ya̱ꞌa̱ wu zuva mini ma nda.” ");
INSERT INTO tswNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Reve u damma yi, “Ta̱wa̱.” A̱vu Bituru lyawa wantsun, a̱vu u ka̱ra̱ a mmalu zuva mini a̱ tyo uba̱ta̱ wa̱ Yesu. ");
INSERT INTO tswNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Amma ana Bituru enei upepu ni ikeɗu i mala, a̱vu wu uwwa wovon ɗaɗa u temei maliɓaa. Ɗaɗa u saalai, “Zagbain, wawa mu!” ");
INSERT INTO tswNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","A̱vu Yesu cananashi ukere wa̱ yi a̱vu u reme yi. A̱vu u damma yi, “Vu ta̱ nu ucawu wo okolo keꞌen. Nye i zuwai okolo a̱ wu a kuɗai?” ");
INSERT INTO tswNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ana a uwai a̱tsuma̱ a wantsuꞌun, reve upepuꞌu u von kwin. ");
INSERT INTO tswNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ɗaɗa aza a na a̱ da̱na̱i pe a wantsuꞌun a yuwayin Yesu a̱ga̱nda̱ adansa, “Amayun a̱vu ɗa Mawun ma̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","A pasalai ta̱ malaꞌa a̱vu a̱ tyo e iɗa ya Janisara. ");
INSERT INTO tswNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ana ama a na a̱ ri pe e revei Yesu ɗa, a̱vu a damma ama suru a na Yesu ta̱wa̱ ta̱. A̱vu a̱ ta̱wa̱a̱ yi na aza a na a̱ ri nu ubanakun icuꞌun icuꞌun. ");
INSERT INTO tswNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Reve a pati yi tsa̱ra̱ u lyawa aza a na a̱ ri nu ubanakun a̱ juꞌwa̱n ngeꞌen mu utugu ma̱ yi. Reve aza a na a̱ juꞌwa̱in suru a̱ ka̱mba̱ gbaga. ");
INSERT INTO tswNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Reve Afarishi o ro na̱ munlu n Wila̱ mu uta̱ ɗe Urishelima, a̱vu a̱ ta̱wa̱ uba̱ta̱ wa̱ Yesu reve e ece yi, ");
INSERT INTO tswNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nye i zuwai ojoro a̱ wu oo tono ili i na nkaya n tsu n roco ntsu tsu yuwan shi? Ko ekere e le a tsu saꞌa kafu a lyuwa ilyalya o ure u na wu ntsayi shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Reve u usu le, “Nye i zuwai yoo tonishi ili i na A̱sula̱ a dammai shi, reve i uwa o tono uritosu wa aciya̱ɗu? ");
INSERT INTO tswNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","A̱sula̱ a damma ta̱, ‘Vu yuwaan dada va̱ wu na̱ mma va̱ wu tsutoni,’ waru, ‘Za na isulai dada va̱ yi ko mma va̱ yi, a̱ to una yi.’ ");
INSERT INTO tswNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","A̱ɗu gba i to ritosu a na na̱ vuma ri ni ili i na waa kambaa dada va̱ yi ko mma va̱ yi, reve u damma ‘A̱yi nda za va̱ A̱sula̱ ɗa,’ ");
INSERT INTO tswNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","to, a̱ ri na a ca dada le iliꞌi shi. I ꞌyuwan ta̱ ili i na A̱sula̱ a dammai adama a agadu a̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","A̱ɗu a̱za̱ e ikpaꞌa! Ishaya vumava̱sula̱ yuwan ta̱ mejege ana u ɗanai A̱sula̱ a damma ta̱: ");
INSERT INTO tswNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ama a nda a ta casu mu tsugbain a̱ na̱ le goon, okolo e le gba alanga a ɗa a̱ ri na̱ a̱mu. ");
INSERT INTO tswNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","A̱ga̱nda̱ a na aa yuwusaan mu ili ya̱ a̱ɓula̱ i ɗa shi. Ili i na oo ritosu ili i ro i ɗa shi, agba uritosu wa ama u ɗa.’ ” ");
INSERT INTO tswNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Reve Yesu ɗewishe oɓolo a amaꞌa, a̱vu u damma le, “I polo atsuvu yu uwwa, a̱vu i reve ili i maa dansa. ");
INSERT INTO tswNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ili i na i tsu uwa a̱tsuma̱ a vuma, a̱yi ɗa u tsu lungusa̱ yi shi. Amma ili i na i tsu uta̱ o una̱ wa̱ yi, a̱yi ɗa u tsu lungusa̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ɗaɗa ojoro a̱ yi a̱ ta̱wa̱i uba̱ta̱ wa̱ yi, a̱vu a damma, “Vu reve ta̱ a na vi isulai Afarishi na adanshi a na vu yuwain?” ");
INSERT INTO tswNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","A̱vu u usu, “Ili i na Dada va̱ va zuva cuꞌwa̱in shi, suru a̱ ta̱ mula̱ yi diga a aralu a̱ yi suru. ");
INSERT INTO tswNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","I tonoo Afarishi o ndolo wan! Ele a̱ ta̱ ana nrumba̱ n na moo ronuso nrumba̱ n ro, waru suru nle a̱ ta̱ riya̱ a̱ a̱a̱ka̱ri.” ");
INSERT INTO tswNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","A̱vu Bituru usu, “Nye ɗa vaa dansa ana vu yuwain adanshi adama e ili i na i tsu lungusa̱ vuma?” ");
INSERT INTO tswNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Reve Yesu usu, “Hali n gogo koto vu reve ili i maa dansa shi? ");
INSERT INTO tswNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Amayun a ɗa, suru ilyalya i na i tsu uwa o una̱, u tsu ka̱ra̱ ta̱ a̱ tyo a̱ a̱a̱tsuma̱, reve wu uta̱. ");
INSERT INTO tswNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amma adanshi a vama a na a̱ tsu uta̱ o una̱ u tsu uta̱ ta̱ diga o okolo. Waru ele ɗaɗa ili i na i tsu lungusa̱ vuma. ");
INSERT INTO tswNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","A̱tsuma̱ o okolo a ɗa majiyan me iwuya na̱ mona ma̱ tsu uta̱, pe ɗa waru tsipere ne epen a̱ tsu uta̱, na̱ wivu na adanshi a vama a aci a ama o ro. ");
INSERT INTO tswNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ele nda ele ɗa a̱ tsu lungusa̱ za. Alya babu saꞌa ekere, u tsu lungusa̱ vuma shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","A̱vu Yesu lyawa uba̱ta̱ꞌa̱ u ka̱mba̱ a̱ mɓa̱nga̱ ma Taya na̱ Sida. ");
INSERT INTO tswNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ana u rawai, a̱vu ka ro Takpaci za na ri na̱ nden pe, u ta̱wa̱ ya̱ꞌa̱ yi, a̱vu u saala, “Zagbain, Mawun ma̱ Da̱wuda, ka̱lyuwa̱ iliyali i va̱! Usheli u va̱ u to sowuso a̱tsuma̱lima̱ no otoni a̱ lima̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Agba Yesu damma yi ili i ro shi. Ɗaɗa ojoro a̱ yi a̱ ta̱wa̱i ya̱ꞌa̱ yi, reve a pati yi, “Damma ka ndolo u ka̱ra̱. U to tono tsu na̱ yisaali.” ");
INSERT INTO tswNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Reve u usu u damma, “A̱ lyungu mu ta̱ uba̱ta̱ wa aza a Israꞌila goon! A̱ ta̱ gashi oɓolo e ikyon a na a̱ puwa̱in.” ");
INSERT INTO tswNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Reve kaꞌa u rawa uba̱ta̱ wa̱ Yesu, a̱vu u ka̱ɗa̱to u damma, “Zagbain, vu kamba mu!” ");
INSERT INTO tswNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","A̱vu u usu, “U lobono a tara ilyalya i muwun, reve a ca musa̱n shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","A̱vu kaꞌa u damma, “Ne ɗa, Zagbain, agba ko musa̱n n tsu lyuwa ta̱ mubishi n na ma̱a̱ riyisa̱ diga a mapara ma za na zuwa niyi.” ");
INSERT INTO tswNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ɗaɗa Yesu usu niyi, “A̱vu ka na cayi okolo lon ɗa! N ta yuwaan wu ili i na vu patiyi.” A mantsaꞌa gan, reve usheli wa̱ yi wo oꞌwo gbaga. ");
INSERT INTO tswNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Reve Yesu lyawa ɗe, reve u ka̱mba̱ a̱ ngeꞌen m Mala ma̱ Ga̱lili. Reve u kumba a aagaɗi u da̱nu. ");
INSERT INTO tswNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ɗaɗa oɓolo a ama a̱ a̱bunda̱ a̱ ta̱wa̱i, a̱vu a̱ ta̱wa̱a̱ na̱ a̱kutsuma̱ na̱ nrumba̱, a̱ ta̱wa̱ ta̱ waru na aza a na a̱ ri no osowi a̱ lipu, oɓolo na aza a na a tsu gura yuwan adanshi shi, na ama a na a̱ ri na̱ banakun icuꞌun icuꞌun. A̱vu a zuwa le a̱ ma̱ka̱ka̱n ma̱ yi, reve u ka̱mba̱to le gbaga suru. ");
INSERT INTO tswNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ama suru a yuwan ta̱ asalama ni ili i na e enei a uwai waru. Ama a na a̱ shi a tsu yuwan adanshi shi, reve a uwa adanshi gogo. Osowi a̱ lipu o oꞌwo ta̱ gbaga, a̱kutsuma̱ waru a wala, nrumba̱ waru me ene ure. Ama suru a uwa ta̱ a ciɓalasa A̱sula̱ a aza a Israꞌila. ");
INSERT INTO tswNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","A̱vu Yesu ɗe ojoro a̱ yi, reve u damma le, “Me ene ta̱ iliyali ya ama a nda. O to oɓolo na̱ a̱mu hali rana taꞌatsu, agba a̱ ri ni ili i na aa lyuwa shi. Agba n ciga n zuwa a̱ ka̱ra̱ na ambulu shi. A̱ ta̱ ta̱ka̱lyuwa̱ o ure a̱ tyo o uꞌwa.” ");
INSERT INTO tswNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","A̱vu ojoro a̱ yi a̱ usu, “Uba̱ta̱ u nda u rotso ta̱ ogozo. Te ɗa tsa̱a̱ tsura̱ ilyalya i na yaa rawa lyuwato cuꞌun vo oɓolo a nda?” ");
INSERT INTO tswNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","A̱vu we ece le, “Opopofu a yan a ɗa i ri ne ele?” A̱vu a̱ usu, “A̱za̱ e cindere, na̱ mugula meketeci.” ");
INSERT INTO tswNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","A̱vu Yesu damma amaꞌa a̱ da̱nu e iɗa. ");
INSERT INTO tswNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Reve u tara opopofu e cindereꞌe na̱ mugulaꞌa a̱vu u godyoo A̱sula̱. Reve u neꞌeshen ilyalyaꞌa u ca ojoro a̱ yi, reve a ca amaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Amaꞌa suru a lyuwa ta̱ hali a̱ cuwa̱n. Reve ojoro a̱ yi o shiton asaka a gbagbain e cindere na akapi a na a buwai. ");
INSERT INTO tswNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ali goon aza a na a lyuwai ilyalyaꞌa, babu na̱ a̱ma̱ci na̱ muwun, a ta rawa ama ukpakukupa una̱shi (4,000). ");
INSERT INTO tswNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ana Yesu dammai amaꞌa a̱ ka̱ra̱, ɗaɗa u uwai a wantsun reve u pasalai malaꞌa. Reve a rawa e iɗa zuzu na̱ Magada. ");
INSERT INTO tswNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","A̱vu Afarishi na aza a Sadukiya a̱ ta̱wa̱ uba̱ta̱ wa̱ Yesu a̱ lyungwa̱ yi adama e reme yi nu unusu, ɗaɗa a damma niyi u yuwaan le ili ya asalama, adama u roco A̱sula̱ a̱ usu ta̱ ili i na waa yuwusan. ");
INSERT INTO tswNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Reve gba Yesu usu, “Nu urana u ri a̱ ma̱riya̱a̱, i tsu damma ta̱ ‘Alanzu o to lobono adama a na zuva ri saan.’ ");
INSERT INTO tswNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nu usana adama a na zuva ri saan na̱ wunla̱, reve i damma, ‘O to roꞌo.’ I tse ene ta̱ iroci i nda zuva, reve i reve ili i na oo rocosu. Agba ne ɗa fo, i te inda ili i na maa yuwusan gogo, waru i reve ili i na oo rocosu shi. ");
INSERT INTO tswNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ama e iwuya na̱ a̱za̱ o ulambu wa̱ a̱ɓula̱ a zami ta̱ a yuwaan le iroci ya asalama, agba moo roco le shi, she iroci ya Yunana† vumava̱sula̱.” Reve Yesu lyawa le lo a̱vu u ka̱ra̱. ");
INSERT INTO tswNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ana ojoro e Yesu a pasai malaꞌa a̱ tyo a̱ mɓa̱nga̱ n ndeɗe, reve e icina a na aa tara opopofu. ");
INSERT INTO tswNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Reve Yesu damma le, “I yuwan ugbozu! I da̱na̱ ufoɓu adama o wolilo wa Afarishi na aza a Sadukiya.” ");
INSERT INTO tswNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","A̱vu ojoroꞌo a yuwan adanshi va̱ni le, a̱vu a damma, “U ta dansa ne adama a na tsu ta̱wa̱yi na̱ ko oopopofu shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ana Yesu revei ili i na aa dansa, ɗaɗa we ece nle, “Nye i zuwai i ri a ndammulai adama a na i ri no opopofu shi? Ucawu wo okolo a̱ ɗu waꞌa ɗa. ");
INSERT INTO tswNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Hali n gogo koto i reve shi? I cuwan no opopofu o ton a na a lyuwatoi ali ukpakukupa utoꞌon (5,000) shi? Waru i cuwan i shiton ta̱ asaka a̱ a̱bunda̱ na akapi a na a pasai shi? ");
INSERT INTO tswNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Waru opopofu e cindere a na a lyuwatoi ali ukpakukupa una̱shi (4,000) gba? Asaka a gbagbain a yan ɗa i shitoyin? ");
INSERT INTO tswNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Adama a̱ nye i gura revei a na maa yuwusaan ɗu adanshi adama o opopofu shi? N ta dansaa ɗu i yuwan ugbozu na̱ wolilo wa Afarishi na aza a Sadukiya.” ");
INSERT INTO tswNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ɗaɗa e revei waa yuwusaan le adanshi a̱ yuwan ugbozu na̱ wolilo† ko opopofu shi, amma adama o uritosu we epen wa Afarishi na aza a Sadukiya. ");
INSERT INTO tswNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu no ojoro a̱ yi a̱tsuma̱ a mmalu, ana a rawai zuzu na̱ mɓa̱nga̱ ma Kasariya Filibi, a̱vu we ece le, “Zane ɗa ama a tarasa Mawun ma Vuma?” ");
INSERT INTO tswNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","A̱vu a̱ usu, “Ozo o ro a damma, a̱vu Yahaya za vu Urumbusu ɗa, ozo o ro gba a damma a̱vu Iliya ɗa, ozo o ro waru a damma a̱vu Irimiya† ɗa, ko gba shi vuma ta̱ a̱tsuma̱ a ama̱sula̱ a ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Reve we ece le, “A̱ɗu gba, zane ɗa yaa tarasa mu?” ");
INSERT INTO tswNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Reve Simo za na a̱ tsu ɗe Bituru usu, “A̱vu ɗa Zamawawa,† Mawun ma̱ A̱sula̱ za na tsu ca wuma.” ");
INSERT INTO tswNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Reve Yesu usu, “A̱vu za va abaꞌun ɗa, Bituru mawun ma Yahaya,† adama a na ko vuma roco wu ili i nda shi. Dada va̱ na ri zuva ɗa roco nuwu ko zane ɗa n ri. ");
INSERT INTO tswNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Adama o ndolo n ta̱ ɗe wu Bituru, za na urevu wa̱ yi u ɗa ‘Aatali.’ Waru a aatali a nda a ɗa maa suwa a̱a̱ꞌisa̱ a̱ a̱za̱ e Itoni† a̱ va̱, agba ucira wu ukwa̱ waa laꞌa ucira wa̱ yi shi. ");
INSERT INTO tswNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","N ta ca wu mkpa̱tuꞌutsu n tsugono tsa zuva. Ili i na biti vu kpa̱tuꞌwa̱i pa o uvaɗi shi, A̱sula̱ fo wa̱a̱ usu u kpa̱tuꞌwa̱ le shi. Waru ili i na vu kpa̱tuꞌwa̱i pa o uvaɗi u nda, ele fo A̱sula̱ a̱ ta̱ kpa̱tuꞌwa̱ le.” ");
INSERT INTO tswNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Reve Yesu rono ojoro a̱ yi atsuvu she a damma nanza a na a̱yi ɗaɗa Zamawawaꞌa wan. ");
INSERT INTO tswNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Diga a mantsaꞌa a̱ ꞌya̱wa̱, reve Yesu teme a dansaa ojoro a̱ yi ili i na yaa cina yi. A̱vu u damma, “Na̱ n ciga na̱ n ꞌyuwan n ꞌya̱wa̱ Urishelima uba̱ta̱ u na azagbain e iɗa, nan ganu a gbagbain na̱ munlu n Wila̱ n ri. A ta ca mu a̱tsuma̱lima̱ lon. A̱ to una mu, agba na a yuwan rana taꞌatsu, A̱sula̱ a̱ ta̱ ꞌya̱sa̱n mu.” ");
INSERT INTO tswNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Reve Bituru ɗe yi a̱ tyo a̱ ngeꞌen, a̱vu u damma yi u lyawa a dansa ne. U damma, “A̱sula̱ aa lyawa ili i ndolo i fara na̱ a̱vu shi, Zagbain!” ");
INSERT INTO tswNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Reve Yesu† vadala uba̱ta̱ wa̱ yi reve u damma yi, “Male, vu buwa mu ure! Vu ta̱ gesheshe ili i na A̱sula̱ a zuwaa numu n yuwan, adama a na majiyan ma̱ wu za vuma ɗa, agba u ri ununa A̱sula̱ aa yuwusan shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Reve u damma ojoro a̱ yi, “Za na suru cigai u kuru mu, she nu u ꞌyuwan aciya̱yi suru suru. Nu u ciga u ꞌyuwan u tara akpata a̱ a̱tsuma̱lima̱ a̱ yi reve u kuru mu. ");
INSERT INTO tswNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Adama a na za na cigai u wawa wuma wa̱ yi, u ta lamba yi, amma za na lambai wuma wa̱ yi adama a̱ va̱, u ta̱ tsura̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nye i ɗa vuma aa muna nu u tsura̱ uvaɗi u nda suru, reve u lamba wuma wa̱ yi? Vuma aa gura tsupa† adama u tsurisa̱ wuma wa̱ yi shi, ko keꞌen. ");
INSERT INTO tswNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Adama a na a̱mu, Mawun ma Vuma, n ta̱ ta̱wa̱ na̱ tsugbain tsa Dada va̱ oɓolo na̱ nlingata ma̱ yi, a̱vu n geꞌeto ama suru ununa a yuwain ili biti. ");
INSERT INTO tswNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Amayun a ɗa maa dansaa ɗu, ozo o ro a̱tsuma̱ a̱ ɗu a na i ri pa nda mishin gogo, ya̱a̱ kuwa̱ shi, she na̱ ye ene mu, Mawun ma Vuma, a̱ ta̱wa̱ a̱tsuma̱ o tsugono tsa̱ va̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ana a yuwain ayin a̱ ta̱li, reve Yesu ɗangwa Bituru na̱ Yakubu na̱ mawun ma̱ a̱na̱wu ma̱ yi Yahaya. Reve a̱ ꞌya̱wa̱ a kumba masasan mo ugaꞌan uba̱ta̱ u na a̱ da̱na̱i goon le. ");
INSERT INTO tswNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ele a̱ ka̱nla̱, ɗaɗa oroci e Yesu a vadalai suru suru. Urewesu wa̱ yi e ikanasa ana urana, a̱tugu a̱ yi waru a̱ ka̱mba̱ uꞌuri puwu ana ekan. ");
INSERT INTO tswNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Reve Musa† na̱ Iliya o utushi, reve a uwa adanshi na̱ Yesu. ");
INSERT INTO tswNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Reve Bituru damma yi, “Zagbain, u lobono ta̱ a na tsu ri pa! Lyawa tsu yuwan ogodo a taꞌatsu pa, za ta̱ za va̱ wu, za ta̱ za va Musa, za ta̱ za va Iliya.” ");
INSERT INTO tswNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","A̱yi ubuwu a adanshi, reve eleshe e ekan a̱ ta̱wa̱ u pupala le. A̱vu uɗyo wu uta̱ pe e elesheꞌe u damma, “A̱yi nda Mawun ma̱ va̱ ɗa, za na n cigai, n ta uwwusa uyoꞌo wa̱ yi lon. Yu uwwa yi!” ");
INSERT INTO tswNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ana ojoroꞌo a uwwai uɗyoꞌo, reve a uwwa wovon lon hali a̱ riya̱ ma̱kpa̱ɓa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ɗaɗa Yesu rawai reve u juꞌwa̱n le. A̱vu u damma, “ꞌYoyin, she yu uwwa wovon wan!” ");
INSERT INTO tswNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ɗaɗa a̱ ꞌya̱sa̱in aci a̱ ka̱lyuwa̱i, agba e ene za ro shi, she Yesu. ");
INSERT INTO tswNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ele a̱ ma̱cipa̱a̱ a masasaꞌan, reve u damma le, “She i damma nanza ili i na ye enei wan, she na̱ a̱ ꞌya̱sa̱n mu, a̱mu Mawun ma Vuma a̱tsuma̱ a̱ a̱kwa̱kwa̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Reve ojoroꞌo e ece yi, “O una̱ wu nye munlu n Wila̱ n dammai a na Iliya ɗa a fara ta̱wa̱ kafu Zamawawa ta̱wa̱?” ");
INSERT INTO tswNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Reve u damma le, “Amayun a ɗa Iliya ta̱ ta̱wa̱ u foɓo ili biti. ");
INSERT INTO tswNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Agba amayun, Iliya ta̱wa̱ ta̱ ɗe. Agba ama e reve a na a̱yi ɗa shi, reve a yuwaan yi ununa a cigai. Aa jima shi, ne ɗa fo aa zuwa Mawun ma Vuma mo sowo a̱tsuma̱lima̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ɗaɗa ojoroꞌo e revei u ta yuwusaan le adanshi a Yahaya za vu Urumbusu. ");
INSERT INTO tswNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ana Yesu no ojoro a̱ yi a̱ cipa̱i zuva masasaꞌan, oɓolo a ama a̱ a̱bunda̱ a̱ shi ta̱ lo a pura le. A̱vu vuma ro ta̱wa̱ u kingyo a̱ ma̱ka̱ka̱n ma̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Reve u damma, “Zagbain, ve ene iliyali i mawun ma̱ va̱! U ta̱ na̱ tsudaꞌun tsu ucira, hali u tsu riya̱ ta̱ a akina ko a̱ mini kuci. ");
INSERT INTO tswNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","N ta̱wa̱ ta̱ na̱ a̱yi uba̱ta̱ wo ojoro a̱ wu, agba ko vuma ta̱ gura ka̱mba̱to yi gbaga shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Reve Yesu usu, “A̱ɗu ama o okolo o ugbamu, a̱za̱ o ulambu wu ucawu wo okolo. Hali mantsa ma ne ma ɗa ma̱a̱ da̱na̱ na̱ a̱ɗu? Waru hali mantsa ma̱ ne ma ɗa maa gura da̱nu na̱ a̱ɗu na ankuri? Ta̱wa̱i nu uloboꞌo pa nda!” ");
INSERT INTO tswNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Reve u ɓara otoni a̱ lima̱ a na a̱ ri pe o uloboꞌo, a̱vu otoni a̱ lima̱ꞌa̱ o uta̱. Diga a mantsa mo ndolo, reve u ka̱mba̱ gbaga suru suru. ");
INSERT INTO tswNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ana alanga a jimai, a̱yi a̱ ndeꞌen, reve ojoro a̱ yi a̱ ta̱wa̱ uba̱ta̱ wa̱ yi a̱vu e ece yi, “Adama a̱ nye tsu kuɗa̱i o uta̱a̱ otoni a̱ lima̱ꞌa̱?” ");
INSERT INTO tswNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Reve u usu le, “Adama a na i ri nu ucawu wo okolo waꞌa ɗa. Amayun a ɗa maa dansaa ɗu, ni i ri nu ucawu wo okolo keꞌen cine i revei cuꞌun vu suꞌwanꞌuri, i ta damma masasan ma nda, ‘Lyawa uba̱ta̱ u nda a̱ tyo ndeɗe,’ a̱vu gba u lyawa. I ta gura yuwan ili suru.” ");
INSERT INTO tswNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Urana u ro cina a̱ ka̱mba̱ Ga̱lili, a̱vu Yesu damma le, “Za ro ta wina Mawun ma Vuma. ");
INSERT INTO tswNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","A̱ to una yi, agba na a yuwan ayin a taꞌatsu a̱ ta̱ ꞌya̱sa̱n yi.” Reve a̱tsuma̱ a̱ la̱nga̱ ojoroꞌo lon. ");
INSERT INTO tswNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ana Yesu no ojoro a̱ yi a rawai Kafarnahum, reve a̱za̱ o ushishi wu utafa wa̱ A̱a̱ꞌisamapaɗa e ece Bituru, “Manlu ma̱ ɗu ma tsu tsupa utafa wa̱ A̱a̱ꞌisamapaɗa shi?” ");
INSERT INTO tswNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","A̱vu Bituru usu, “U tsu tsupa ta̱.” Reve Bituru uwa o uꞌwaꞌa, a̱vu kafu u yuwan adanshi, ɗaɗa Yesu ece niyi, “Ngono n tsu zuwaa ta̱ ama e le utafa, ko omocin?” ");
INSERT INTO tswNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Reve u usu, “Omocin a ɗa a tsu zuwaa utafa.” A̱vu Yesu usu, “To, wo oꞌwo ta̱ ama e le aa tsupa shi. ");
INSERT INTO tswNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Amma woo lobono tsu ꞌya̱sa̱n okolo a ama shi. Adama o ndolo, ꞌya̱wa̱i mavusa a mala. Magula ma na i fara remei, i kpa̱tuꞌwa̱ una̱ wa̱ yi, i ta̱ tsura̱ ikebe† i azurufa i na i rawai atsupu o utafa wa̱ A̱a̱ꞌisamapaɗa za va̱ na̱ za ɗu. I tara i tsupa le utafa u tsu.” ");
INSERT INTO tswNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","A mantsaꞌa, reve ojoro e Yesu a̱ ta̱wa̱ uba̱ta̱ wa̱ yi, reve e ece yi, “Zane ɗa oo oꞌwo zagbain suru suru a̱tsuma̱ o tsugono tsa zuva?” ");
INSERT INTO tswNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ɗaɗa Yesu ɗeyi mawun mo ro, reve wi isawaton yi a̱ ma̱ka̱ka̱n me le. ");
INSERT INTO tswNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","A̱vu u damma, “Amayun a ɗa maa dansaa ɗu, ni i ciga i ꞌyuwan yoo oꞌwo ununa muwun n kekeꞌen n ri. Na̱ ne ɗa shi, yaa uwa o tsugono tsa zuva shi. ");
INSERT INTO tswNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Adama o ndolo za na tarai aciya̱yi ili i ro shi, ana mawun me keꞌen ma nda, a̱yi ɗa za na laꞌai tsugbain o tsugono tsa zuva. ");
INSERT INTO tswNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Waru za na ushiyi mawun me keꞌen ma nda a aala a̱ va̱, a̱mu ɗa u ushiyi.” ");
INSERT INTO tswNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","A̱vu Yesu lyuwa elime u damma, “Woo yoꞌono aza a na aa zuwa ko vuma ta̱ a̱tsuma̱ a aza a na oo tono mu yuwan unusu shi. U ta laꞌaa le a̱ nla̱a̱ le aatali a yira a̱ yinlu a vari le a̱tsuma̱ a mala upasu u na u laꞌai a̱ruꞌun! ");
INSERT INTO tswNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Woo yoꞌono ama shi, adama e ili i na yaa zuwusa ama ma̱riya̱ o unusu. A̱ ri ni ili i na aa yuwan shi, ili i ndolo i ta fara, agba woo yoꞌono aza a na a̱ ta̱wa̱i ne ele shi! ");
INSERT INTO tswNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nu ukere wa̱ wu ko anana a̱ wu aa zuwusa wu mayan mo unusu, vu koɗo yi vu vari yi. U ta laꞌaa wu vu lamba upasu u lipu u ro wa̱ wu, reve vo oꞌwo na̱ wuma u na va̱a̱ kuwa̱ shi a na va̱a̱ da̱na̱ ne ekere e re na ana e re a̱vu a vari wu a akina a na a̱ ri n kima̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na̱ lyusu va̱ wu aa zuwusa wu mayan mo unusu, vu foɗo yi vu vari yi. U laꞌaa wu ta̱ vu da̱na̱ na̱ lyusu ta̱ goon a̱vu vu da̱na̱ wuma, a na va̱a̱ da̱na̱ ne esu e re reve a vari wu a akina a na a̱ ri kima̱ shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","A̱vu waru Yesu damma, “I yuwan ugbozu. She i tara a̱za̱ e kekeꞌen a nda ili ye pere wan. N ta dansaa ɗu, a̱ ta̱ na̱ nlingata zuva n na n ri oɓolo na̱ Dada va̱ zuva. ");
INSERT INTO tswNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Na̱ za va aguɓa ri ni ikyon ukpaku, reve za ta̱ uta̱ reve u puwa̱n, nye i ɗa waa yuwan? U ta lyawa kupakucci na̱ kucci na buwai a alyuna a̱ ngeꞌen m masasan, reve u ꞌya̱wa̱ izami yi kyon ta̱ na puwa̱yiꞌin. ");
INSERT INTO tswNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nu u tsura̱ yi, amayun a ɗa maa dansaa ɗu, u ta laꞌa yuwan ma̱za̱nga̱ a aci a̱ za ta̱ o ndolo, a na waa yuwan a aci a kupakucci na̱ kucci na buwai. ");
INSERT INTO tswNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ne ɗa u ri ya Dada ɗu za na ri zuva. U ciga ko za ta̱ a̱tsuma̱ a̱ a̱za̱ e kekeꞌen a nda u puwa̱n shi, suru suru.” ");
INSERT INTO tswNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Reve Yesu lyuwa elime u damma, “Nna̱ za va̱ wu yuwaan wu unusu, ꞌya̱wa̱ ya̱ꞌa̱ yi, a̱vu vu roco yi unusu wa̱ yi. Agba vu yuwan yi usokowu, a̱vu na̱ a̱yi goon. Na̱ vumaꞌa wu uwwa wu, vu lyuwa ta̱ aci a za va̱ wu waru vu ka̱mba̱to ta̱ za va̱ wu. ");
INSERT INTO tswNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nu u ꞌyuwan gba a uwwa wu, vu tara vuma ta̱, ko ama e re i ꞌya̱wa̱ oɓolo. Vu yuwan ne adama a na Adanshi a̱ A̱sula̱ a damma ta̱ adanshi o una̱ wa ama e re ko ama a taꞌatsu a aci a za ro u laꞌa ta̱ ume. ");
INSERT INTO tswNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nu u ꞌyuwan a uwwa le fo, vu damma a̱za̱ e Itoni. Nu u ꞌyuwan waru a uwwa a̱za̱ e Itoni, to, vu yuwan na̱ a̱yi ununa vaa yuwan na̱ za na revei A̱sula̱ shi, ko ana manlu mo uꞌushishi mo utafa.” ");
INSERT INTO tswNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","A̱vu waru Yesu damma, “Amayun a ɗa maa dansaa ɗu, Ili i na suru yi nla̱i pa o uvaɗi u nda, A̱sula̱ za na ri zuva ta̱ a̱ nla̱ yi fo. Agba ili i na suru i ba̱ɗa̱i, u ta̱ ba̱ɗa̱ yi fo. ");
INSERT INTO tswNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Waru, n ta dansaa ɗu, na ama e re a̱tsuma̱ a̱ ɗu a yuwan a̱sa̱la̱ e ili i na a cigai, reve a vasa adama a̱ yi, Dada va̱ za na ri zuva ta yuwaan ɗu a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Adama a na uba̱ta̱ u na ama e re ko ama a taꞌatsu o ɓolotoi a aala a̱ va̱, n ta̱ lo oɓolo ne ele.” ");
INSERT INTO tswNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Reve Bituru ta̱wa̱ ya̱ Yesu we ece, “Zagbain, na̱ za va̱ aa nususaan mu, hali uyan u ɗa maa yuwaan yi gafura? Toto ucindere?” ");
INSERT INTO tswNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","A̱vu u usu, “Oꞌo, toto ucindere shi, amma kupocindere toto ucindere. ");
INSERT INTO tswNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Nda cine tsugono tsa zuva tsa̱ ri: A yuwan ta̱ mogono mo ro za na cigai u ushi ikebe i na woo tono agbashi a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","A̱yi a̱tsuma̱ o uꞌushishi, reve a̱ ta̱wa̱ na̱ vuma ro za na woo tono ikebe i gbain i azurufa ukpakukupa kupa (10,000). ");
INSERT INTO tswNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Aagbashiꞌi gba u shi ni ikebe i na waa gura tsupa yi shi. Ɗaɗa mogonoꞌo u zuwai a wina vumaꞌa ni ili i na u ri na̱ a̱yi suru, hali na̱ ka va̱ yi na̱ muwun ma̱ yi. Reve a tara ikebeꞌe a tsupa mogonoꞌo utan u na woo tono aagbashiꞌi. ");
INSERT INTO tswNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Amma a̱vu aagbashiꞌi u kingyo, reve u pati u damma, ‘Vu yuwan ankuri na̱ a̱mu, n ta tsupa ili i na n kopoi suru.’ ");
INSERT INTO tswNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Reve mogonoꞌo we ene yi iliyali lon, reve u lyawa yi, a̱vu u damma yi she u tsupa ikebeꞌe waru wan. ");
INSERT INTO tswNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Aagbashiꞌi a̱ mota̱a̱, a̱vu u gaꞌan na aagbashi o ro za na woo tono ikebe i keꞌen i azurufa ukpaku. Ɗaɗa u gaga niyi oogorovili. Reve u uwa a̱ cukuɗusa̱ yi nu u dansai, ‘Vu tsupa mu utan u va̱!’ ");
INSERT INTO tswNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Reve aagbashiꞌi u kingyo, reve u pati yi u damma, ‘Yuwan ankuri na̱ a̱mu, n ta tsupa wu ili i na voo tono mu suru.’ ");
INSERT INTO tswNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Agba a̱vu aagbashi o ufaruꞌu u ꞌyuwan e ene iliyali ya̱ yi. Reve u zuwa a̱ ɓa̱ru yi o uꞌwa wa ali, hali she nu u tsupa ili i na oo tono yi. ");
INSERT INTO tswNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ana akapi a agbashi e enei ili i na u yuwain, reve a uwwa upan lon. Ɗaɗa a̱ ꞌya̱wa̱i uba̱ta̱ u mogonoꞌo, reve a damma yi ili i na i yuwain suru. ");
INSERT INTO tswNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ɗaɗa mogonoꞌo u ɗeyi aagbashiꞌi reve u damma, ‘A̱vu aagbashi a vama! Ana vu pati numu, n lyawaa wu ta̱ utaꞌan, reve n damma she vu tsupa ili wan. ");
INSERT INTO tswNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Vu shi ta̱ fo ee ene iliyali ya aagbashi o ndolo ununa me ene nuwu iliyali.’ ");
INSERT INTO tswNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Reve mogono ma uwwa upan lon, a̱vu u zuwa a zuwa yi o uꞌwa wa ali, u sowo a̱tsuma̱lima̱ hali u tsupa ili i na oo tono yi suru. ");
INSERT INTO tswNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ne ɗa Dada va̱ za na ri zuva aa yuwan na̱ a̱ɗu nni i ꞌyuwan a yuwaan a̱za̱ a̱ ɗu gafura o okolo a̱ ɗu.” ");
INSERT INTO tswNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ana Yesu kotoi adanshi o ndolo, reve u lyawa Ga̱lili a̱vu u ka̱ra̱ a̱ tyo e iɗa ya Yahuda upasalai wu Uɗolu wa̱ Urdu. ");
INSERT INTO tswNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Reve oɓolo a ama o toni yi, a̱vu u ka̱mba̱to a̱za̱ o ubanakun gbaga. ");
INSERT INTO tswNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","A̱vu Afarishi o ro a ciga a lyungwa̱ yi na̱ yeci, reve a damma, “Wila̱ u tsu u lyawa ta̱ vuma kakasa na̱ ka va̱ yi ko adama e ili i ro i na we enei suru?” ");
INSERT INTO tswNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Reve Yesu usu, “Koto i ɗenuna̱ a̱tsuma̱ a Adanshi a̱ A̱sula̱ shi? A ɗana ta̱ ana A̱sula̱ a yuwain uvaɗi, ‘U yuwan le ta̱ vali na̱ ka. ");
INSERT INTO tswNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","A̱yi ɗa i zuwai vali aa lyawa dada va̱ yi na̱ mma va̱ yi reve e remulei na̱ ka va̱ yi, a̱vu ele ra o oꞌwo ili i ta̱.’ ");
INSERT INTO tswNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ana wo oꞌwoi a buwa ili i re shi, agba ili i ta̱, adama o ndolo ili i na A̱sula̱ o ɓoloi she nanza kakasa wan.” ");
INSERT INTO tswNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","A̱vu Afarishi e ece yi, “To, adama a̱ nye i ɗa Musa lyawai vuma ca ka va̱ yi aatagada a wukasu u lolo reve u gba̱ra̱ yi?” ");
INSERT INTO tswNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","A̱vu Yesu usu, “Musa lyawa ɗu ta̱ i kakasa na̱ a̱ma̱ci a̱ ɗu, adama a na i ꞌyuwain a̱ kuru ili i na A̱sula̱ a dammai, amma ɗe o ufaru ne ɗa u shi shi. ");
INSERT INTO tswNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Waru lyawa n damma ɗu nda, za na suru lyawai ka va̱ yi reve u yuwisan lolo ro, tsipere tsa ɗa waa yuwusan, shede na̱ kaꞌa u ri e tsipere na ali o ro.” ");
INSERT INTO tswNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Reve ojoro a̱ yi a damma yi, “Na̱ ne ɗa iliꞌi i ri e ekere a vali na̱ ka va̱ yi, u laꞌa ta̱ ulobonu she vuma yuwan lolo wan.” ");
INSERT INTO tswNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","A̱vu Yesu usu, “Vuma suru ɗa aa gura usu uritosu u nda shi, amma she aza a na A̱sula̱ a cayi. ");
INSERT INTO tswNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ili i na i zuwai ozo o ro aa yuwan lolo shi a̱yi ɗa, ozo o ro a matsan le ta̱ ali agba a̱ ri gbaga shi. Ozo o ro waru ama a ɗa a̱ ka̱mba̱to nle ne. Ozo o ro waru a ꞌyuwan ta̱ lolo adama o tsugono tsa zuva. Za na aa gura tara uritosu u nda u tara.” ");
INSERT INTO tswNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Reve ama o ro a̱ ta̱wa̱a̱ Yesu na̱ muwun n le, adama u juꞌwa̱n le u yuwaan le avasa. A̱vu ojoro a̱ yi a putsaa aza a na a̱ ta̱wusa̱a̱ na̱ muwuꞌun, a lyawa a damatosun yi. ");
INSERT INTO tswNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Reve gba Yesu damma le, “Lyawai muwun n kekeꞌen n ta̱wa̱ ya̱ꞌa̱ va̱, she i putsaa le wan. Icuꞌun ya ama a na a̱ ri tsa̱ muwun n nda, tsugono tsa zuva za le ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ana Yesu juꞌwa̱in muwuꞌun, reve u zuwaa le abaꞌun ɗaɗa u ka̱ra̱i. ");
INSERT INTO tswNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ana a yuwain ne, reve vuma ro ta̱wa̱ ya̱ Yesu reve we ece yi, “Manlu, ili ya̱ a̱ɓula̱ i ne i ɗa maa yuwan tsa̱ra̱ n tsura̱ wuma u na woo koto shi?” ");
INSERT INTO tswNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Reve Yesu damma yi, “Adama a̱ nye vee eceshe mu ili ya̱ a̱ɓula̱? A̱sula̱ ɗa goon za va̱ a̱ɓula̱. Na̱ vu ciga vu tsura̱ wuma u babu ukotu, ciga ꞌyuwan vu kuru Wila̱ wa̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","A̱vu vumaꞌa we ece, “Wila̱ u ne u ɗa?” Reve Yesu usu, “She vu una za nu ucigu wa̱ wu wan. She vu yuwan tsipere wan. She vu yuwan wivu wan. She vu yuwan epen a aci o ozo ro wan. ");
INSERT INTO tswNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Vu ca aabara na̱ makuci ma̱ wu tsugbain. Vu ciga ozo o ro ununa vu cigai aciya̱wu.” ");
INSERT INTO tswNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Reve vumaꞌa u usu, “Ele nda suru n yuwan le ta̱ ɗe. Nye i buwai na maa yuwan waru?” ");
INSERT INTO tswNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","A̱vu Yesu usu, “Na̱ vu ciga vu shiwan vuma, ꞌya̱wa̱ vu wina ili i na vu ri na̱ a̱yi suru, reve vu neꞌeshen alambi ikebeꞌe, vu ta̱ tsura̱ uzuwa zuva. Reve vu ta̱wa̱ vu kuru mu.” ");
INSERT INTO tswNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ana vumaꞌa wu uwwai ne reve a̱tsuma̱ a̱ la̱nga̱ yi, adama a na u ta̱ nu utsuru lon. Reve u ka̱ra̱ ili ya̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ɗaɗa Yesu dammai ojoro a̱ yi, “Amayun a ɗa maa dansaa ɗu, ili yu usa̱n i ɗa za vu utsuru uwa o tsugono tsa zuva. ");
INSERT INTO tswNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Amayun n ta dansaa ɗu, u ta laꞌa babu usa̱n aarakumi a̱ pusula̱i na̱ vunu vu bele, a na za vu utsuru aa uwa o tsugono tsa̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ana ojoro a̱ yi a uwwai ne, reve a uwa asalama lon, reve e ece, “To, zane gba aa laꞌa?” ");
INSERT INTO tswNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","A̱vu Yesu ka̱lyuwa̱ le u damma, “E ekere a vaɗilima̱ iliꞌi i ri n yuwan shi, amma uba̱ta̱ wa̱ A̱sula̱ ili biti u ta gura yuwan.” ");
INSERT INTO tswNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ɗaɗa Bituru damma niyi, “A̱tsu ɗa nda tsu lyawai ili suru, reve tsu kuru wu. Nye ɗa gba tsa̱a̱ tsura̱ adama o ndolo?” ");
INSERT INTO tswNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Reve Yesu damma le, “Amayun a ɗa maa dansaa ɗu, a mantsa ma na a̱mu Mawun ma Vuma, ma̱a̱ da̱nu o ootogu o tsugbain a mantsa ma na ma̱a̱ ta̱wa̱, a̱ɗu aza a na oo tono mu i ta̱ da̱nu o otogu kupa ne ejere, waru i ta̱ geꞌeto gundo kupa ne ejere va Israꞌila. ");
INSERT INTO tswNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aza a na a lyawai ili suru suru adama a̱ va̱, a lyawai ꞌwa le ko a̱ɗuma̱ e le, a̱ ta̱ tsura̱ atsupu. Ne ɗa waru na a lyawa a̱za̱ e le ali ne esheli, ko a lyawa nan dada na̱ nan mma le, ko gba a lyawa muwun, a̱ ta̱ tsura̱ atsupu hali a̱ tyo toto ukpaku, waru a̱ ta̱ tsura̱ wuma u na woo koto shi. ");
INSERT INTO tswNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Agba na̱ a̱bunda̱ aza a na a̱ ri elime gogo a̱ ta̱ ka̱mba̱ a̱ca̱pa̱, waru aza a na a̱ ri a̱ca̱pa̱ gogo a̱ ta̱ tyo elime.” ");
INSERT INTO tswNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ana Yesu uwai o rocosu ama ununa tsugono tsa zuva tsa̱a̱ da̱na̱, a̱vu u damma, “A yuwan ta̱ vuma ro za na da̱na̱i nu uɗuma̱ wa inabi. Urana u ro, reve wu uta̱ na̱ wasasa adama u zami aza a zamalinga adama a lingaa yi uɗuma̱ wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","A̱vu u damma u ta tsupa le ununa a tsu tsupa ikebe i azurufa yu ulivu irumu i ta̱ ta̱. Reve u tara le a̱ tyo o uɗuma̱ꞌa̱ a linga yi. ");
INSERT INTO tswNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ana alanzu a gaɗuwai, a̱yi o utula̱i e eden reve u cina ozo o ro lo a̱ mishin me pere. ");
INSERT INTO tswNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Reve u banu le fo a̱ tyo o uɗuma̱ wa̱ yi, a̱vu u damma le u ta tsupa le ili i na i lobonoi nu urana u riya̱. ");
INSERT INTO tswNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","A̱vu a̱ ka̱ra̱ e reme ulinga o uɗuma̱ꞌa̱. “Nu urana a aci na̱ rumu taꞌatsu vu urana reve u yuwisan ne. ");
INSERT INTO tswNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Waru ana u buwai rumu ta̱ na aa lyawa ulinga, reve wu utisa̱ a̱ lyuci, a̱vu waru u cina ama o ro mishin lo. Reve we ece le, ‘Adama a̱ nye yaa yuwusan ulinga anaꞌan shi?’ ");
INSERT INTO tswNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Reve a̱ usu, ‘Adama a na ko za tara tsu shi!’ “A̱vu u damma le, ‘To, ꞌya̱wa̱i i linga o uɗuma̱ u va̱.’ ");
INSERT INTO tswNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ana urana u kotoi, reve za vu uɗuma̱ꞌa̱ u ɗe za ve elime u damma yi, ‘Ɗe aza a zamalingaꞌa vu tsupa le. Vu teme na aza a na n tarai nu ukosu, reve vu koso na aza a na n fara tarai.’ ");
INSERT INTO tswNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Reve aza a na o koso tarai a yuwan ulinga wu rumu ta̱ goon a̱ ta̱wa̱ a̱ ushi atsupu e le, za suru ushi ta̱ rumu ta̱ azurufa. ");
INSERT INTO tswNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ana aza a na e temei ulinga ili yu usana a̱ ta̱wa̱i tsa̱ra̱ a̱ ushi atsupu e le, a ta dansa a̱ ta̱ ushi ili i na i laꞌai a̱za̱ a̱ a̱za̱ e le. A̱vu wo oꞌwo ele fo irumu i ta̱ ta̱ i azurufa i ɗa a tsupa nle. ");
INSERT INTO tswNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ana a̱ ushiyi ikebe i le, reve a̱ ꞌya̱wa̱ na adanshawuya uba̱ta̱ wu za vu uɗuma̱ꞌa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Reve a damma, ‘Aza a na a tarai na̱ a̱ca̱pa̱ rumu ta̱ ɗa goon a lingai. A̱vu vu tsupa le una̱ta̱ na̱ a̱tsu. A̱tsu gba tsu linga ta̱ a̱tsuma̱ o usuɗuwu wu urana hali a̱ tyo ulivu!’ ");
INSERT INTO tswNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Reve za vu uɗuma̱ꞌa̱ u usu za ta̱ a̱tsuma̱ e le, ‘Iꞌutsa̱ i va̱, m paala wu shi. N tsupa wu ta̱ ili i na tsu yuwain adanshi. ");
INSERT INTO tswNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tara ikebe ya̱ wu vu ka̱ra̱! N tara ta̱ n tsupa za na a tarai o ukosu una̱ta̱ na̱ a̱vu. ");
INSERT INTO tswNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","N ta gura yuwan ununa n cigai ni ikebe i va̱. Vu ta̱ a̱ tsushuꞌun o una̱ u na n yuwayin ama a̱ ndeɗe isaꞌani?’ ” ");
INSERT INTO tswNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ɗaɗa Yesu tsu damma, “Ne ɗa u ri. Za ve elime gogo u ta̱ ka̱mba̱ a̱ca̱pa̱, waru za va̱ a̱ca̱pa̱ ta̱ ka̱mba̱ elime.” ");
INSERT INTO tswNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu a̱tsuma̱ a mmalu a̱ tyo Urishelima, reve u ɗe ojoro a̱ yi kupa ne ejere a̱ ngeꞌen a̱vu u damma le, ");
INSERT INTO tswNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Na̱ tsu rawa Urishelima a ta wina Mawun ma Vuma e ekere a nan ganu a gbagbain na̱ munlu n Wila̱. A ta yuwaan yi ugeꞌetosu u na oo una yi. ");
INSERT INTO tswNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Reve a zuwa yi e ekere a Atakpaci aza a na aa yuwaan yi ulamu, a fufaba yi, reve a vara yi a akpata. Agba o urana wa taꞌatsu A̱sula̱ a̱ ta̱ ꞌya̱sa̱n yi a̱tsuma̱ a̱ a̱kwa̱kwa̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","A̱vu ka va̱ Za̱ba̱di rawa no olobo a̱ yi e re, Yakubu na̱ Yahaya. Reve u kingyo u uwa ipati ya̱ Yesu yuwaan yi ili i ro. ");
INSERT INTO tswNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","A̱vu Yesu ece, “Nye i ɗa vu cigai?” A̱vu u damma, “A mantsa ma na vu da̱nuyi o tsugono tsa̱ wu, vu ta lyawa muwun n va̱ n nda a̱ da̱nu uba̱ta̱ u tsugbain zuzu na̱ a̱vu, za ta̱ o ukere usaꞌani za ta̱ waru o ukere ugula̱ wa̱ wu?” ");
INSERT INTO tswNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","A̱vu Yesu damma, “I reve ili i na yaa patishi shi. I ta gura sowo mokoto ma̱ a̱tsuma̱lima̱ ma na maa zama n sowo?” Reve oloboꞌo a̱ usu, “Ee, tsu ta gura.” ");
INSERT INTO tswNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Reve Yesu usu, “Amayun a ɗa i to sowo a̱tsuma̱lima̱ꞌa̱! Agba maa gura ɗangwa za na a̱a̱ da̱nu o usaꞌani ko o ugula̱ u va̱ shi. Ele ba̱ta̱ ndolo uba̱ta̱ wa aza a na Dada va̱ foɓoyi ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ana akapi o ojoro kupa a uwwai ne, reve a uwa upan na̱ muwun ma̱ a̱na̱wu n reꞌe. ");
INSERT INTO tswNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","A̱vu Yesu ɗe aza a na oo tono yi suru reve u damma, “I reve ta̱ a̱za̱ o tsugono tsa Atakpaci a ciga ta̱ o roco tsugbain tse le e ekere a ama. Waru aza a tsugbain tse le a tsu ciga ta̱ o roco a na a̱ ri nu ucira. ");
INSERT INTO tswNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Agba e ekere a̱ ɗu, she wo oꞌwo ne wan. Za na biti cigai wo oꞌwo zagbain a̱tsuma̱ a̱ ɗu, she nu u ka̱mba̱ aagbashi a akapi a na a buwai. ");
INSERT INTO tswNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Waru za na cigai wo oꞌwo za ve elime, she nu u yuwan ulinga u tsugbashi a̱ tyo a akapi suru. ");
INSERT INTO tswNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Adama a na ko a̱mu, Mawun ma Vuma n ta̱wa̱ tsa̱ra̱ a yuwaan mu tsugbashi shi, amma n yuwaan ama, waru n ca aciya̱va̱ adama a wawa ama na̱ a̱bunda̱ a̱tsuma̱ a̱ nusu le.” ");
INSERT INTO tswNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu no ojoro a̱ yi a lyawa ta̱ Jeriko, reve oɓolo a ama a̱ a̱bunda̱ a̱ kuru yi. ");
INSERT INTO tswNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nrumba̱ n re n da̱na̱ ta̱ lo nden a̱ ngeꞌen mu ure. Ana a uwwai Yesu ɗa ri lo a̱ ka̱ra̱, ɗaɗa a uwai yisaali adansa, “Zagbain, Mawun ma̱ Da̱wuda! Ka̱lyuwa̱ iliyali i tsu!” ");
INSERT INTO tswNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Reve oɓolo a amaꞌa a ɓara le a̱ ɓa̱ru na̱ le, a̱vu gba a̱ da̱shi ꞌya̱sa̱n uɗyo lon, “Zagbain, Mawun ma̱ Da̱wuda! Ka̱lyuwa̱ iliyali i tsu!” ");
INSERT INTO tswNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ana Yesu uwwa nle, reve wi isawan we ece, “Nye i cigai n yuwaan ɗu?” ");
INSERT INTO tswNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ɗaɗa a̱ usuyi, “Zagbain, tsu ciga ta̱ tse ene!” ");
INSERT INTO tswNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","A̱vu Yesu ene iliyali i le, reve u juꞌwa̱n esu e le. Ɗaɗa esu e le a̱ kpa̱tuꞌushi, reve e ene ure, ɗaɗa a̱ kuru niyi. ");
INSERT INTO tswNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu no ojoro a̱ yi a marawaa zuzu na̱ Urishelima, reve a rawa a̱ lyuci va Batafaji zuzu na̱ Masasan ma̱ Zetun.† A̱vu u lyungu ojoro e re elime a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","A̱vu u damma le, “ꞌYa̱wa̱i a̱ ma̱lyuci ma na ma̱ ri elime. Nni i rawa, i te eneshi molloli na̱ mma va̱ yi ugutsuwu. I ba̱ɗa̱ le, reve i ta̱wa̱a̱ mu ne ele. ");
INSERT INTO tswNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Na̱ za ro ece ɗu, adama a̱ nye ya̱a̱ ba̱ɗa̱sa̱ le, i damma, ‘Zagbain ciga le ta̱!’ U ta lyawaa ɗu nloliꞌi babu addama o ro.” ");
INSERT INTO tswNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ili i nda i fara ta̱ adama o shiton ili i na Zakariya vumava̱sula̱ dammai: ");
INSERT INTO tswNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Dammai a̱za̱ a̱ Urishelima: ‘Mogono ma̱ ɗu moo ta̱ lo a̱ ta̱wa̱! U tara aciya̱yi ili i ro shi, reve u kumba mololi. U ta̱ lo a̱ ta̱wa̱ ukumbu o molloli.’ ” ");
INSERT INTO tswNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Reve ojoroꞌo a̱ ka̱ra̱ a yuwan ili i na Yesu damma nle a yuwan. ");
INSERT INTO tswNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","A̱vu a̱ ta̱wa̱a̱ na̱ mololi na̱ molloliꞌi, reve ojoroꞌo fo o polo ɗe o nloliꞌi itana i le. Reve Yesu kumba. ");
INSERT INTO tswNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ama na̱ a̱bunda̱ o poluso ta̱ amuna e le o ure. Ozo o ro gba shi a kuɗusa a̱vuꞌun no o poluso nle o ure. ");
INSERT INTO tswNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","A̱vu ozo o ro a uwa elime e Yesu, ozo o ro gba shi a̱ da̱na̱ oo tono yi a̱ca̱pa̱. Reve a saalasa, “Husana!† Ica a̱ tyo a Mawun ma̱ Da̱wuda!” “A̱sula̱ a zuwaa za na a̱a̱ ta̱wa̱ a̱tsuma̱ a ala a̱ A̱sulazuva abaꞌun!” “Ica a̱ tyo e ekere a̱ A̱sula̱!” ");
INSERT INTO tswNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ana Yesu uwai a̱tsuma̱ a̱ Urishelima,† lyuciꞌi ma̱ɓula̱ u shiwan ta̱ na̱ a̱gidiꞌya̱. Hali ama e ece, “Vuma ne ɗa gba ndaꞌa?” ");
INSERT INTO tswNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Reve oɓolo amaꞌa a̱ usu, “Vuma nda a̱yi ɗaɗa Yesu, vumava̱sula̱ diga a̱ lyuci va Nazara va̱ Ga̱lili.” ");
INSERT INTO tswNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","A̱vu Yesu uwa a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗa,† reve u lo aza a na a̱ da̱na̱i a atsulu na a wini a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗaꞌa. Reve waru wu keɓe apada a na a̱ da̱na̱i a kitaꞌusa ɗe ikebe icuꞌun icuꞌun, reve fo u kekeɓe ili yu uba̱ta̱ u na a̱ da̱na̱i a winisa nrukuku. ");
INSERT INTO tswNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Reve u damma le, “Adanshi a̱ A̱sula̱ a damma ta̱, ‘E te ɗe uꞌwa u va̱ uba̱ta̱ u mayan ma avasa.’ Amma, a̱ɗu ɗa nda i ka̱mba̱to niyi upaꞌatan we evu.” ");
INSERT INTO tswNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","A̱vu nrumba̱ na̱ a̱kutsuma̱ a̱ ta̱wusa̱ uba̱ta̱ wa̱ Yesu a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗa, reve u ka̱mba̱tosu le gbaga. ");
INSERT INTO tswNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ana nan ganu a gbagbain na̱ munlu n Wila̱ me ene niyi a yuwusan ili ya asalama, reve waru e ene muwun a cuwusa yi a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗaꞌa, waru a ta dansa, “Husana!† Ica a̱ tyo a Mawun ma̱ Da̱wuda.” Reve ili i ndolo suru i zuwa nan ganu a gbagbaiꞌin na̱ munlu n Wila̱ꞌa̱ a uwwa upan lon. ");
INSERT INTO tswNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","A̱vu e ece Yesu, “Vu ta uwwusa ili i na muwun n nda maa dansa?” Reve u usu le, “Ee, koto i ɗenuna̱ a̱tsuma̱ a Adanshi a̱ A̱sula̱ shi? ‘A̱vu A̱sula̱ vu rito ta̱ muwun na̱ nreɓu a canaa wu ishipa yi ica.’ ” ");
INSERT INTO tswNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Reve Yesu lyawa le, a̱vu u ka̱ra̱ o uta̱ a̱tsuma̱ a̱ lyuciꞌi a̱ tyo Batanya, ɗe ɗa wa asai. ");
INSERT INTO tswNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na̱ wasasa, Yesu a̱ ma̱ka̱mba̱a̱ a̱tsuma̱ a̱ lyuciꞌi, reve ambulu a̱ guza̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","A̱vu we ene ubiri a̱ ngeꞌen mu ure, reve u ka̱ra̱ a̱ ꞌya̱wa̱ e ikyun ya̱ yi, agba u tsura̱ ɗe umatsun wa̱ yi shi, she a̱vuꞌun. Adama o ndolo reve u damma uɗangaꞌa, “Va̱a̱ da̱shi matsan shi!” Babu usa̱n reve uɗangaꞌa u ꞌyewushi. ");
INSERT INTO tswNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ana ojoro a̱ yi e enei ili i na i farai, a yuwan ta̱ asalama lon. Reve e ece, “Cine ubiri u nda u ꞌyewushi gogogo?” ");
INSERT INTO tswNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","A̱vu u usu le, “Amayun a ɗa maa dansaa ɗu, nni i ri nu ucawu wo okolo agba okolo a̱ ɗu a kuɗa shi, i ta gura yuwan ili i na n yuwain nu uɗanga u nda, hali u laꞌa. I ta gura damma masasan ma nda, ‘Ka̱ra̱, vu riya̱ a mala!’ Nni i ri nu ucawu wo okolo, ili i ndolo i ta fara. ");
INSERT INTO tswNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ili i na i patiyi suru a̱tsuma̱ a avasa, nni i ri nu ucawu wo okolo, i ta̱ tsura̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ana Yesu ka̱mba̱i a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗaꞌa, reve u reme uritosu. A̱vu nan ganu a gbagbain na azagbain a̱ ta̱wa̱ uba̱ta̱ wa̱ yi, reve e ece yi, “Nu ucira u ne vaa yuwusan cuꞌun vu ulinga u nda? Zane ɗa ca nuwu cuꞌun vu ucira u nda?” ");
INSERT INTO tswNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Reve u usu le, “A̱mu fo n ta̱ na̱ yeci i ta̱ i na maa yuwan ɗu. Nni i usu mu, a̱mu waru n ta damma ɗu uba̱ta̱ u na n tsura̱i ucira u na maa yuwusan linga nda. ");
INSERT INTO tswNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Zane cayi Yahaya ucira u yuwan urumbusu? A̱sula̱ a na a̱ ri zuva ɗa, ko vaɗilima̱?” Reve a̱ ka̱ra̱ a ndammulai va̱ni le. “Nna̱ tsu damma, ‘Diga zuva ɗa,’ u te ece tsu, nye i zuwai tsu ushi niyi shi. ");
INSERT INTO tswNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Agba waru n tsu damma, ‘Diga uba̱ta̱ u vuma u ɗa,’ tsu ta uwwusa wovon wi ili i na ama aa yuwan na̱ a̱tsu, adama a na ama suru a̱ usu ta̱ a na Yahaya vumava̱sula̱ ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Adama o ndolo reve a̱ usu yi, “Tsu reve shi.” Reve u usu le, “Maa damma ɗu fo za na ca numu ucira u na maa yuwan ili i na maa yuwusan shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Reve Yesu damma waru nan ganu a gbagbain na azagbain, “N ta damma ɗu iroci i vuma ro na da̱na̱i na̱ muwun n re. A̱vu i damma mu ili i na i jiyain. Urana u ro, reve dadaꞌa u ꞌya̱wa̱ uba̱ta̱ a zakpara a̱vu u damma, ‘ꞌYa̱wa̱ vu yuwan ulinga o uɗuma̱ wa inabi anaꞌan!’ ");
INSERT INTO tswNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“A̱vu mawuꞌun u usu, ‘Ma̱a̱ ꞌya̱wa̱ shi!’ Amma a̱ tyo ɗe, reve u vadala majiyan ma̱ yi, reve u ꞌya̱wa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Reve waru dadaꞌa u ꞌya̱wa̱ uba̱ta̱ wu zawaꞌa a̱vu u damma, ‘ꞌYa̱wa̱ vu yuwan ulinga o uɗuma̱ u va̱ anaꞌan!’ Reve zawaꞌaꞌa u usu, ‘Ee, dada, n ta̱ ꞌya̱wa̱ n yuwan ulingaꞌa!’ Agba u ꞌya̱wa̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Zane ɗa a̱tsuma̱ a̱ muwun n nda u yuwayin dadaꞌa tsutoni?” Reve a̱ usu, “Mawun mo ufaru.” A̱vu u damma le, “N ta dansaa ɗu amayun, a̱za̱ o uꞌushishi wu utafa na ashakala a ta uwa o tsugono tsa̱ A̱sula̱ kafu a̱ɗu. ");
INSERT INTO tswNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yahaya za vu Urumbusu ta̱wa̱ ta̱ u roco ɗu ure u mejege u na ya̱a̱ da̱nu. Agba i usu yi shi, reve gba a̱za̱ o uꞌushishi wu utafa na ashakala a̱ usu yi. Ko na ye enei ili i nda, i ꞌyuwan ta̱ a vadala i lyawa akuci e re ɗu, reve i ꞌyuwan a̱ usu yi.” ");
INSERT INTO tswNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Reve Yesu damma waru nan ganu a gbagbain na azagbain, “Poloi atsuvu a̱ ɗu yu uwwa iroci i nda: A yuwan ta̱ vuma ro na da̱na̱i nu uɗuma̱ wa inabi. A̱vu u suwa isula a̱ka̱nda̱ruwa̱ yi. Reve u ka̱pa̱ a̱a̱ka̱ri, tsa̱ra̱ u tsura̱ uba̱ta̱ u na wa̱a̱ da̱na̱ o sovuso masayan ma inabi,† a̱vu u suwa atsura adama a za vi ipiri. Reve u ca aza a zamalinga uɗuma̱ꞌa̱ tsa̱ra̱ a linga yi, a̱vu a̱yi u ka̱ra̱ mmalu. ");
INSERT INTO tswNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ana mantsa mo utaꞌan wu umatsun wa inabiꞌi ma rawai, a̱vu u lyungu agbashi a̱ yi a̱ ꞌya̱wa̱ a̱ ushi akunda e ili i na o ɓolotoi. ");
INSERT INTO tswNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Amma a̱vu aza a zamalingaꞌa e reme agbashiꞌi. Reve a lalapa za ta̱ le, a̱vu o una za ro, reve a vuvara za va taꞌatsu hali u kuwa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","A̱vu za vu uɗuma̱ꞌa̱ u lyunguwisa̱ agbashi a̱ a̱bunda̱ a̱ yi a̱ ꞌya̱wa̱ a̱ ta̱wa̱a̱ yi ni inabiꞌi. Reve waru aza a zamalingaꞌa a yuwaan agbashiꞌi cine a yuwain na agbashi a na u fara lyunguyi. ");
INSERT INTO tswNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","A̱ tyo o ukosu, reve za vu uɗuma̱ꞌa̱ u lyungu mawun ma̱ yi a̱ tyo uba̱ta̱ wa aza a zamalingaꞌa, a majiyan ma̱ yi a ta yuwan tsutoni na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Amma ana aza a zamalingaꞌa e enei mawuꞌun a̱ ta̱wa̱, a̱vu a dammulai va̱ni le, ‘Mawun ma nda a̱yi ɗa woo oꞌwo na agadu o uɗuma̱ u nda. Nna̱ tsu una yi, tsu to oꞌwo nu uɗuma̱ꞌa̱!’ ");
INSERT INTO tswNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","A̱vu e reme yi, reve a tara yi o uta̱a̱ yi a̱tsuma̱ o uɗuma̱ꞌa̱ nu ucira, reve o una yi.” ");
INSERT INTO tswNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Reve u yuwan yeci, “Nna̱ za vu uɗuma̱ꞌa̱ u ta̱wa̱, nye i zuwai waa yuwan na aza a zamalingaꞌa?” ");
INSERT INTO tswNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","A̱vu a̱ usu, “Babu ili i ro, u to una ama e iwuya o ndolo, reve u ca aza a zamalinga o ro uɗuma̱ꞌa̱, aza a na aa ca yi akunda e ili i na o ɓolotoi a mantsa ma saꞌani.” ");
INSERT INTO tswNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","A̱vu u damma le, “Koto i ɗenuna̱ a̱tsuma̱ a Adanshi a̱ A̱sula̱ shi? ‘Aatali a na asuwi a ꞌyuwain, a̱yi ɗa wo oꞌwoi ikyun yu ucira a̱tsuma̱ o usaa. Zagbain ɗa yuwain ili i nda, Waru u lobono ta̱ e esu a̱ tsu!’ ");
INSERT INTO tswNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Adama o ndolo n ta dansaa ɗu, a ta usa tsugono tsa̱ A̱sula̱ e ekere a̱ ɗu, reve a ca ama a na aa yuwusan ili i na A̱sula̱ a cigai o tsugono tsa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Vuma na riya̱i zuva va aatali o ndolo suru u ta kukuɗa, waru za na aatali o ndolo a̱ riya̱yi, u ta̱ yukuma̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ana nan ganu a gbagbain na Afarishi a uwwai iroci i nda, a gura ta̱ reve a na a aci e le a ɗa Yesu aa yuwusan adanshi. ");
INSERT INTO tswNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","A̱vu a̱ shi a ciga e reme yi, amma reve a̱ ka̱ra̱ a uwwusa wovon wa ama, adama a na ama a ca ta̱ okolo a na Yesu vumava̱sula̱ ɗa. ");
INSERT INTO tswNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu yuwisan ta̱ iroci tsa̱ra̱ u rito ama. Ɗaɗa u dammai, ");
INSERT INTO tswNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Apa cine tsugono tsa zuva tsa̱ ri: A yuwan ta̱ mogono mo ro za na foɓoi a̱ba̱jini a̱ a̱buki o lolo adama a mawun ma̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mogonoꞌo u banu ta̱ ama o ro a̱ ta̱wa̱ a̱bukiꞌi. Ana urana wa̱ a̱bukiꞌi u rawai, a̱vu u lyungu agbashi a̱ yi tsa̱ra̱ e ɗe amaꞌa, reve a ꞌyuwan a̱ ta̱wa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Reve u lyunguwisa̱ agbashi o ro, adansa, ‘Dammai aza a na m banuyi a na o koto ta̱ ifoɓi ya̱ a̱buki. M paɗa ta̱ inan i va̱ i na i laꞌai ulobonu, a̱vu n foɓo inama. O foɓo ta̱ ɗe ili suru. Ta̱wa̱i uba̱ta̱ wa̱ a̱buki o lolo.’ ");
INSERT INTO tswNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Amma aza a na a banuyiꞌi a zuwa atsuvu e le shi. Ozo o ro e le a̱ ka̱ra̱ ta̱ a̱ tyo a̱ a̱ɗuma̱ e le, ozo o ro gba a̱ ꞌya̱wa̱ ta̱ alya e eden. ");
INSERT INTO tswNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ozo o ro gba shi e reme ta̱ agbashiꞌi, a̱vu a̱ ga̱ga̱la̱ le, hali o una le. ");
INSERT INTO tswNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ana mogonoꞌo wu uwwai ne, u yuwan ta̱ upan lon. Ɗaɗa u lyunguyi a̱soja a̱ yi o una aza a na o unai agbashiꞌi, a̱vu a̱ kula̱to lyuci gbain le. ");
INSERT INTO tswNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ɗaɗa u dammai agbashi a̱ yi, ‘O koto ta̱ ifoɓi ya̱ a̱buki o lolo. M banu ta̱ ama a nda, agba a ntsaa a̱ ta̱wa̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Adama o ndolo, ꞌya̱wa̱i e re lyuci gbaiꞌin tsa̱ra̱ i banu vuma na i tsura̱i biti u ta̱wa̱ uba̱ta̱ wa̱ a̱buki a̱ va̱.’ ");
INSERT INTO tswNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","A̱vu a̱ ꞌya̱wa̱ e re, a̱vu o ɓoloto ama a na a gura tsura̱i suru, ama a̱ a̱ɓula̱ na ama o ulambu wa̱ a̱ɓula̱ suru. Ne ɗa uba̱ta̱ wa̱ a̱bukiꞌi u shiwain na ama. ");
INSERT INTO tswNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ana mogonoꞌo u uwai we ene omociꞌin, reve we ene pe vuma ni itana i na wu ntsayi u ta̱wa̱a̱ uba̱ta̱ u lolo shi. ");
INSERT INTO tswNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ɗaɗa we ece niyi, ‘A̱vu, nye i zuwai vo otoi itana i na i ri ulobonu shi, reve vu ta̱wa̱ uba̱ta̱ wa̱ a̱buki?’ A̱yi gba mociꞌin u tsura̱ ili i na waa damma shi. ");
INSERT INTO tswNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“A̱vu mogonoꞌo u damma agbashi o ro, ‘Nla̱i ana ne ekere a vumaꞌa. Reve i vari yi a̱tsuma̱ e irumbu, uba̱ta̱ u na ama a̱a̱ shon na a lumi anga adama a̱ a̱tsuma̱lima̱.’ ");
INSERT INTO tswNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Amayun, a banu ta̱ ama na̱ a̱bunda̱, agba ama keꞌen ɗa a ɗangwai.” ");
INSERT INTO tswNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Reve Afarishi† o foɓo cine aa yuwan e reme Yesu nu unusu a̱tsuma̱ a adanshi. ");
INSERT INTO tswNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","A̱vu a̱ lyunguwa̱ yi ama o ro a̱tsuma̱ o ojoro e le oɓolo no ozo o ro a na oo tono Hiridu. Reve a damma, “Manlu tsu reve ta̱ vu ta dansa amayun kuci, waru vu to rocosu ama ure wa̱ A̱sula̱ mejege. Vu tara ta̱ ama suru una̱ta̱, ko cine tsa ɗa a̱ ri. ");
INSERT INTO tswNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Damma tsu majiyan ma̱ wu, u lobono ta̱ tsu tsupa utafa a̱ tyo ya Kaisa† mogono, ko she tsu tsupa wan?” ");
INSERT INTO tswNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu gba u reve ta̱ majiyan me iwuya me le, ɗaɗa u dammai, “A̱ɗu a̱za̱ e ikpaꞌa! Nye i zuwai ya̱a̱ lyungusa̱ mu? ");
INSERT INTO tswNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Roco numu ikebe yi rumu i na yaa tsupusaa utafaꞌa.” A̱vu amaꞌa o roco yi ikebeꞌe. ");
INSERT INTO tswNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Reve we ece le, “Ululu na aala a zane a ɗa a̱ ri ɗe uɗanu?” ");
INSERT INTO tswNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","A̱vu a̱ usu, “Mogono ma gbain Kaisa.” Reve u damma le, “Cayi Kaisa ili i na i ri za va̱ yi, A̱sula̱ waru i ca yi ili i na i ri za va̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ana a uwwai ne, a yuwan ta̱ asalama, ɗaɗa a lyawa niyi a̱vu a̱ ka̱ra̱. ");
INSERT INTO tswNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Aza a Sadukiya† a̱ usu a na ama a̱a̱ ꞌyon a̱tsuma̱ a̱ a̱kwa̱kwa̱ shi. O urana u ndolo gan, a̱vu a̱ ta̱wa̱ uba̱ta̱ wa̱ Yesu. Reve a damma, ");
INSERT INTO tswNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Manlu, Musa damma ta̱, ‘Na̱ vuma kuwa̱ babu mawun, a̱vu za va̱ yi sotso ma̱runa̱ꞌa̱ tsa̱ra̱ u tsura̱a̱ yi mawun.’ ");
INSERT INTO tswNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ɗe nu ufaru, a yuwan ta̱ ama e cindere muwun ma̱ a̱na̱wu n na n da̱na̱i pa. Za vu ufaru zuwa ta̱ ka, a̱vu u kuwa̱ babu mawun. Reve za ve ire sotso yi. ");
INSERT INTO tswNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","A̱vu a̱yi fo u kuwa̱ babu mawun, reve za ro sotso yi waru, ne ɗa a yuwain hali wo olo le suru. ");
INSERT INTO tswNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","A̱ tyo o ukosu, a̱vu kaꞌa fo u kuwa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na̱ A̱sula̱ a̱ ta̱wa̱ a̱ ꞌya̱sa̱n ama o ukwisa̱, ka va zane ɗa woo oꞌwo? Adama a na wo olo ta̱ ali e cindereꞌe suru.” ");
INSERT INTO tswNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ɗaɗa u usu nle, “I ri nu urevu shi, adama a na i reve ili i na Adanshi a̱ A̱sula̱ a dammai shi, waru i reve adama o ucira wa̱ A̱sula̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Na̱ a̱ ꞌya̱sa̱n ama a̱tsuma̱ a̱ a̱kwa̱kwa̱, aa yuwan lolo shi, waru aa ca lolo shi. O to oꞌwo gashi nlingata ma̱ A̱sula̱ ɗe zuva. ");
INSERT INTO tswNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Koto i ɗenuna̱ ili i na A̱sula̱ a dammai adama o uꞌyosun a̱tsuma̱ a̱ a̱kwa̱kwa̱ shi? ");
INSERT INTO tswNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","A̱sula̱ a damma, ‘A̱mu ɗa A̱sula̱ a Ibrahim, na̱ A̱sula̱ a Ishiyaku, oɓolo na̱ A̱sula̱ a Yakubu.’ A̱sula̱ waru A̱sula̱ a aza a wuma a ɗa, agba A̱sula̱ a̱ a̱kwa̱kwa̱ a ɗa shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ana oɓolo a amaꞌa a uwwai tsundolo, a yuwan ta̱ asalama nu uritosu wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ana Afarishi a uwwai a na aza a Sadukiya a gura usu ili shi, ɗaɗa o ɓolotoi uba̱ta̱ u ta̱. ");
INSERT INTO tswNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","A̱tsuma̱ e le, manlu ma̱ Wila̱ mo ro mo foɓo ta̱ cine wee reme Yesu ɗaɗa u yuwan niyi yeci: ");
INSERT INTO tswNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Manlu, a̱tsuma̱ a̱ Wila̱ wa Musa, zane ɗa laꞌai mgbain?” ");
INSERT INTO tswNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Reve Yesu usu yi, “ ‘Vu ciga Zagbain A̱sula̱ a̱ wu no okolo a̱ wu suru, na asuvu a̱ wu suru, waru na̱ majiyan ma̱ wu suru.’ ");
INSERT INTO tswNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","A̱yi nda a̱yi ɗa Wila̱ u gbain wu ufaru za na laꞌai ulobonu. ");
INSERT INTO tswNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Wila̱ we ire fo u tu ulobonu, ‘Vu ciga moron ma̱ nden ma̱ wu cine vu cigai aciya̱wu.’ ");
INSERT INTO tswNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Wila̱ wa Musa oɓolo na Atagada a Ama̱sula̱ suru za̱la̱ wila̱ re nda ɗa a̱ ri.” ");
INSERT INTO tswNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Afarishiꞌi lo ubuwu uɓolotowu, ɗaɗa Yesu yuwan nle yeci, ");
INSERT INTO tswNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nye yaa yuwusan majiyan adama a̱ Kristi Zamawawa? O ugundo wa̱ zane ɗa wu uta̱i?” Reve a̱ usu, “Kristi Zamawawa Mawun ma̱ Da̱wuda ma ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ɗaɗa u damma nle, “To, adama a̱ nye Da̱wuda ɗe niyi ‘Zagbain?’ Ruhu va Akiza ɗa zuwai Da̱wuda dammai, ");
INSERT INTO tswNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘A̱sulazuva a damma ta̱ Zagbain va̱. Da̱nu o ukere usaꞌani u va̱, she na̱ n zuwa nꞌyuwatan ma̱ wu a apata a ana a̱ wu.’ ");
INSERT INTO tswNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Ana Da̱wuda ɗe niyi Zagbain, cine woo oꞌwiso mawun ma̱ yi a mantsa ma̱ ta̱?” ");
INSERT INTO tswNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ko za gura usu yi shi. Diga lo ko za kawan da̱shi yuwan yi yeci waru shi. ");
INSERT INTO tswNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Reve Yesu yuwaan oɓoloꞌo no ojoro a̱ yi adanshi, ");
INSERT INTO tswNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Munlu n Wila̱† na Afarishi a̱ ta̱ nu ucira a damma ɗu ili i na Wila̱ wa Musa waa dansa. ");
INSERT INTO tswNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","I yuwan tsutoni ni ili i na o rito nɗu suru, amma she i yuwan ununa aa yuwusan wan. Adama a na a tsu damma ta̱ ili i ro, reve a yuwan ili i ro koꞌo. ");
INSERT INTO tswNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","A̱ tsu nla̱a̱ ta̱ ama itana yu ume i na aa gura tanu shi, agba ele a ciga a zuwa ukere a kamba tanu le shi. ");
INSERT INTO tswNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“A ta yuwusan ili i saꞌani tsa̱ra̱ ama e ene le, za suru ta̱ nla̱sa̱ ilawo ya Adanshi a̱ A̱sula̱, amma ilawo ya Afarishi i laꞌa ta̱ mgbain. Waru alagba e elentsu a̱ a̱tugu e le a̱ ta̱ mgbain. ");
INSERT INTO tswNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","A laꞌa ta ciga nda̱na̱ta̱ n saꞌani uba̱ta̱ a̱ a̱buki, waru na̱ nda̱na̱ta̱ me elime uba̱ta̱ e iɓolo. ");
INSERT INTO tswNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Na̱ a̱ ri a̱tsuma̱ e eden, a tsu laꞌa ta̱ ciga ama a̱ ca̱sa̱ le na aala a tsugbain, ‘Manlu.’ ");
INSERT INTO tswNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“She i lyawa vuma ro ɗe ɗu ‘Manlu’ wan, adama a na Manlu ma̱ ta̱ ma ɗa i ri na̱ a̱yi goon, suru nɗu waru muwun ma̱ a̱na̱wu n ɗa i ri. ");
INSERT INTO tswNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","A̱tsuma̱ o uvaɗi she i ɗe vuma na aala a tsugbain ‘Dada’ wan, adama a na i ta̱ na̱ Dada ta̱ goon, za na ri zuva. ");
INSERT INTO tswNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Waru she i lyawa vuma ro ɗe ɗu ‘Zagbain’ wan, adama a na Zagbain ta̱ ɗa i ri na̱ a̱yi goon, a̱yi ɗa Zamawawa. ");
INSERT INTO tswNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Za na laꞌai mgbain, wo oꞌwo aagbashi a̱ ɗu suru. ");
INSERT INTO tswNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Za na ka̱mba̱toi aciya̱yi zagbain a̱ ta̱ ka̱ɗa̱to yi, za na gba ka̱ɗa̱toi aciya̱yi a̱ ta̱ ꞌya̱sa̱n yi. ");
INSERT INTO tswNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Woo yoꞌono ɗu shi, a̱ɗu munlu n Wila̱ na Afarishi. A̱ɗu a̱za̱ e ikpaꞌa! I ta̱ kpa̱tosu una̱ntsu u tsugono tsa zuva, agba a̱ɗu na aciya̱ɗu yaa uwa pe shi. Waru i ta putsusaa aza a na a cigai a uwa.  ");
INSERT INTO tswNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Woo yoꞌono ɗu shi a̱ɗu munlu n Wila̱ na Afarishi. A̱ɗu a̱za̱ e ikpaꞌa! I ta paalasa nruna̱ a ususa ꞌwa le, waru i ta yuwusan avasa o ugaꞌan tsa̱ra̱ ama e ene ɗu. I ta laꞌa sowo a̱tsuma̱lima̱ lon. ");
INSERT INTO tswNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Woo yoꞌono ɗu shi, a̱ɗu munlu n Wila̱ na Afarishi. A̱ɗu a̱za̱ e ikpaꞌa! I tsu pasa ta̱ mala, hali i tyo e iɗa ya alanga, tsa̱ra̱ i tsura̱ za vi itoni ta̱. Ni i yuwan ne, a̱vu i zuwa yi u laꞌa ɗu ntsaa na waa uwa a̱tsuma̱ a akina. ");
INSERT INTO tswNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Woo yoꞌono ɗu shi, a̱ɗu azagbain a na ri nrumba̱! I tsu damma ta̱, ‘Na̱ vuma kucina na̱ A̱a̱ꞌisamapaɗa a mantsa ma na waa yuwusan nzuwulai, a̱yi ndolo wo oꞌwo ili shi. Agba nu u kucina na̱ zinariya na ri pe a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗaꞌa, u ciga u ꞌyuwan u shiton nzuwulai ndolo.’ ");
INSERT INTO tswNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","A̱ɗu olo a̱ nrumba̱! Zane ɗa laꞌai: zinariya ko A̱a̱ꞌisamapaɗa a na o oꞌwotoi zinariyaꞌa na akiza? ");
INSERT INTO tswNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","A̱vu waru i damma, ‘Na̱ vuma kucina na̱ masaꞌa† a mantsa ma na waa yuwusan nzuwulai, wo oꞌwo ili i ro shi. Amma nu u kucina nu uneꞌe u na u ri a masaꞌa, u ciga u ꞌyuwan u shiton nzuwulaiꞌi.’ ");
INSERT INTO tswNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","A̱ɗu nrumba̱ ma ama! Zane ɗa laꞌai: a̱yi uneꞌe ko a̱yi masaꞌa ma na ma zuwai uneꞌe wo oꞌwoi na akiza? ");
INSERT INTO tswNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Na̱ ne ɗa, na̱ vuma kucina na̱ masaꞌa, u ta kucinasa na̱ a̱yi ni ili i na i ri zuva va̱ yi suru. ");
INSERT INTO tswNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Waru nu u kucina na̱ A̱a̱ꞌisamapaɗa, u ta kucinasa na̱ a̱yi oɓolo na̱ A̱sula̱, za na ri pe nden. ");
INSERT INTO tswNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Waru na̱ vuma kucina na̱ zuva, u ta kucinasa no ootogu o tsugono tsa̱ A̱sula̱ na̱ a̱yi za na ri ɗe nden. ");
INSERT INTO tswNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Woo yoꞌono ɗu shi, a̱ɗu munlu n Wila̱ na Afarishi. A̱ɗu a̱za̱ e ikpaꞌa! I tsu ca ta̱ A̱sula̱ maɓaci ma̱ ta̱ a̱tsuma̱ a kupa e ili i na i ri ne ele suru, hali na̱ a̱vuꞌun e isuꞌwan e kekeꞌen ni icuꞌun i kekeꞌen suru. Agba i tsu yuwan tsutoni tsa̱ a̱ɓula̱ nu uritosu u Wila̱ shi, za na ele ɗa o roco ozo o ro isaꞌani na amayun na̱ a̱ɓula̱. Ele ɗa wu ntsayi i yuwan suru, agba she i vari ko ili i keꞌen i ta̱ a̱tsuma̱ e ili i na yaa yuwusan wan. ");
INSERT INTO tswNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","A̱ɗu nrumba̱ n na moo ronuso ama! I ta̱ gashi vuma na tsu shere mofiyon a̱tsuma̱ a̱ mini mo oso, a̱vu u soɗu aarakumi! ");
INSERT INTO tswNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Woo yoꞌono ɗu shi, a̱ɗu munlu n Wila̱ na Afarishi. A̱ɗu a̱za̱ e ikpaꞌa! I tsu za̱za̱ꞌwa̱ ta̱ alanga a munda na̱ ntaɗa, agba a̱tsuma̱ e le a̱ ta̱ tapu ni ili i na i usai nu ucira e ekere a ama, tsa̱ra̱ yu uwwaa aciya̱ɗu uyoꞌo. ");
INSERT INTO tswNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Afarishi, a̱ɗu nrumba̱ n ɗa! I fara ka̱mba̱to a̱tsuma̱ a munda cece, reve ucina̱ꞌa̱ fo wo oꞌwo cece! ");
INSERT INTO tswNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Woo yoꞌono ɗu shi, a̱ɗu munlu n Wila̱ na Afarishi. A̱ɗu a̱za̱ e ikpaꞌa! I rotso ta̱ ason a na a putalai mini ma̱ uꞌuri. Alanga a ason o ndolo a̱ ta̱ gashi ulobonu, agba a̱tsuma̱, a̱ ta̱ tapu ne etele a̱ a̱kwa̱kwa̱ ni ili yi idaba icuꞌun icuꞌun. ");
INSERT INTO tswNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ne ɗa waru, a alanga i rotso ta̱ gashi ama a̱ a̱ɓula̱ a ɗa i ri e ekere a ama, agba a̱tsuma̱ a̱ ɗu a̱ ta̱ tapu ni ikpaꞌa na̱ nusu. ");
INSERT INTO tswNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Woo yoꞌono ɗu shi, a̱ɗu munlu n Wila̱ na Afarishi. A̱ɗu a̱za̱ e ikpaꞌa! I tsu foɓo ta̱ uba̱ta̱ wa̱ a̱ciɗa̱ ulobonu adama a ama̱sula̱, a̱vu waru i kakala ason a aza a na a yuwain wuma u saꞌani. ");
INSERT INTO tswNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","A̱vu i damma, ‘Na̱ tsu shi tsu yuwan wuma u tsu a mantsa ma nkaya n tsu, tsu shi a kamba le mona ma ama̱sula̱ shi.’ ");
INSERT INTO tswNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ne ɗa i poloi aciya̱ɗu a na i paluꞌwai aciya̱ɗu adansa a̱ɗu muwun n tsukaya ma aza a na o unai ama̱sula̱ a ɗa! ");
INSERT INTO tswNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Lyuwai elime tsa̱ra̱ i koso ili i na nkaya n ɗu n farai! ");
INSERT INTO tswNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“A̱ɗu apili na̱ muwun ma apili! Cine i jiyain i laꞌa a na ee geꞌeto ɗu a̱tsuma̱ a akina a na a̱ ri n kima̱ shi? ");
INSERT INTO tswNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Adama o ndolo n ta̱ lyunguwa̱ ɗu na ama̱sula̱ na̱ a̱za̱ o urevu na̱ munlu. Ozo o ro e le i to una le, ozo o ro gba shi i ta vara le a akpata. Ozo o ro waru gba i ta ruruꞌwa̱ le a̱tsuma̱ a̱ a̱ꞌisa̱ a̱ ɗu, reve i lo le diga a̱ lyuci a̱ tyo a̱ lyuci. ");
INSERT INTO tswNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Adama o ndolo, A̱sula̱ e te ece ɗu adama a aza a na o unai babu unusu, aza a na a yuwain ɗe wuma. O ufaru a̱ɗu aza a Yahuda, yu una ta̱ Habila† vuma va̱ a̱ɓula̱, ne ɗa i lyuwai elime na̱ mona hali a̱ tyo ya Zakariya mawun ma Berekiya. A̱yi ɗa yu unai e memere mo Upasu wa Akiza na̱ masaꞌa mo ukula̱tosu a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗa. ");
INSERT INTO tswNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","N ta dansaa ɗu amayun, ili i nda suru i ta cina ɗu, a̱ɗu na i ri wuma gogo.” ");
INSERT INTO tswNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ɗaɗa Yesu lyuwai elime na adanshi, “A̱ɗu ama a̱ Urishelima! Ama a̱ ɗu o una ta̱ ama̱sula̱ waru a vuvara ta̱ nlingata n na a̱ lyunguyi a̱ tyo ya̱ꞌa̱ ɗu. N tsu ciga ta̱ m ɓoloto ɗu uba̱ta̱ u ta̱, cine moton mo tsu va̱pa̱ muwun ma̱ yi ne evelu. Agba i lyawa mu n yuwan ne shi. ");
INSERT INTO tswNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Adama o ndolo A̱sula̱ a ta lyawa A̱a̱ꞌisamapaɗa a̱ ɗu, reve wo oꞌwo lya̱nga̱. ");
INSERT INTO tswNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","N damma ɗu, ya̱a̱ da̱shi ene mu waru shi, she mantsa ma na yaa damma, ‘A̱sula̱ a zuwaa za na a̱a̱ ta̱wa̱ a̱tsuma̱ a ala a̱ A̱sulazuva abaꞌun.’ ” ");
INSERT INTO tswNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ana Yesu uta̱i a̱ A̱a̱ꞌisamapaɗa, a̱yi a̱ ma̱ka̱ra̱a̱, a̱vu ojoro a̱ yi a̱ ta̱wa̱ uba̱ta̱ wa̱ yi, tsa̱ra̱ o roco yi saa va̱ A̱a̱ꞌisamapaɗaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ɗaɗa gba u damma nle, “Ye ene ta̱ saa nda suru? Amayun a ɗa maa dansaa ɗu, ko aatali a̱ ta̱ aa lyawa zuva vu za va̱ yi shi. Suru nle o to oco le e iɗa.” ");
INSERT INTO tswNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu ɗe nden a Masasan ma̱ Zetun, reve ojoro a̱ yi a̱ ta̱wa̱ uba̱ta̱ wa̱ yi a̱ da̱na̱ oɓolo na̱ a̱yi goon. A̱vu a damma, “Damma tsu mantsa ma na ili i ndolo yaa fara? Waru nye ya̱a̱ da̱na̱ iroci i na yoo roco tsu mantsa ma na va̱a̱ ta̱wa̱ ma rawa ta̱, waru mantsa ma na uvaɗi u nda woo koto?” ");
INSERT INTO tswNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ɗaɗa Yesu tsu usu le, “I lyawa nanza pusa̱n ɗu ugbozu wan. ");
INSERT INTO tswNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ama na̱ a̱bunda̱ a̱ ta̱ ta̱wa̱ na aala a̱ va̱, a ta damma, ‘A̱mu ɗa Zamawawaꞌa.’ Waru a̱ ta̱ pusa̱n ugbozu wa ama na̱ a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","I ta uwwa adama o uvon na alabari o uvon a na a̱ ri lo a̱ ta̱wa̱, amma she yu uwwa wovon wan. Ili i nda suru a ciga a ꞌyuwan a fara, kafu ukosu u ta̱wa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Iɗa i ta yuwan nla̱ngi ni iɗa, tsugono waru tsu yuwan nla̱ngi na̱ tsugono. A ta yuwan mantsa ma ambulu na̱ a̱bunda̱. A ta yuwan ura̱mosu wi iɗa ba̱ta̱ ba̱ta̱. ");
INSERT INTO tswNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ili nda suru a̱ ta̱ gashi ufaru wu mɓa̱la̱ n limatan. ");
INSERT INTO tswNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ama e te reme ɗu, a zuwa ɗu a̱tsuma̱lima̱, a̱vu o una ɗu. Ama suru a ta ꞌyuwan ɗu adama a na i usu numu. ");
INSERT INTO tswNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Adama o ndolo ama na̱ a̱bunda̱ a ta lyawa itoni i va̱. A ta yuwan nla̱ngi va̱ni le, reve a ꞌyuwunlai. ");
INSERT INTO tswNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ama̱sula̱ e epen a̱ ta̱ ta̱wa̱, reve a zuwa ama na̱ a̱bunda̱ a̱ usu epen. ");
INSERT INTO tswNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Adama o ndolo, iwuya i ta baza ba̱ta̱ suru, a̱vu icigi ya ama na̱ a̱bunda̱ i ta̱na̱ lon. ");
INSERT INTO tswNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Amma aza a na a kaɓai asuvu hali a̱ tyo o ukosu, A̱sula̱ a ta wawa le. ");
INSERT INTO tswNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","She na a yuwan alajiya a Alabari a Saꞌani† adama o tsugono tsa̱ A̱sula̱ uba̱ta̱ suru a̱tsuma̱ o uvaɗi, ɗaɗa ukosu wa̱a̱ ta̱wa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Mantsa ma̱ ta̱ ta̱wa̱ a na ye ene ili i na Daniya vumava̱sula̱ yuwain adanshi adama a̱ yi ‘Ili yi idaba i na i tsu lungusa̱ A̱a̱ꞌisamapaɗa,’ mishin Upasu wa Akiza. (A̱ɗu na yee ɗesununa̱ ili i nda, i reve ili i na waa dansa.) ");
INSERT INTO tswNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","A mantsa mo ndolo, ama a Yahuda a ꞌyuwan a ciga a suma a̱ tyo a nsasan tsa̱ra̱ a laꞌa. ");
INSERT INTO tswNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Za na ri a alanga, she u ka̱mbisa̱ o uꞌwa adama u tara ili i ro wan. ");
INSERT INTO tswNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Za na ri ɗe o uɗuma̱, u ka̱mba̱ o uꞌwa tsa̱ra̱ u tara aapalutsu wan. ");
INSERT INTO tswNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","A mantsa mo ndolo, u ta suɗuwa a̱ma̱ci a na a̱ ri na̱ a̱tsuma̱ oɓolo na̱ a̱ma̱ci a na a̱ ri na̱ muwun n na ma apasa maani! ");
INSERT INTO tswNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“I yuwan avasa tsa̱ra̱ ilaɗi i ɗu yoo oꞌwo a̱tsuma̱ a̱ lyushi ko urana wa Ashibi wan! ");
INSERT INTO tswNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","A̱yi nda u to oꞌwo a̱tsuma̱lima̱ a na koto a yuwain shi, diga na a yuwain uvaɗi u nda. Waru cuꞌun va̱ a̱tsuma̱lima̱ o ndolo a̱a̱ da̱shi fara shi. ");
INSERT INTO tswNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Amma A̱sula̱ e jebe ta̱ ɗe rana ndolo, na̱ koto u yuwan ne shi, babu vuma na aa laꞌa. Amma A̱sula̱ e te jebe le adama a aza a na u ɗangwai. ");
INSERT INTO tswNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“A mantsa mo ndolo, ozo o ro a ta damma ɗu, ‘Ka̱lyuwa̱i, ndeɗe Zamawawaꞌa!’ Ko za ro damma, ‘Apa yi’, agba she i usu wan. ");
INSERT INTO tswNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Azamawawa e epen na ama̱sula̱ e epen a̱ ta̱ ta̱wa̱ a yuwan ili ya asalama ya̱ a̱bunda̱. A ta yuwan a̱tyo a na aa yuwan tsa̱ra̱ ama o toni le, hali na ama a na A̱sula̱ a ɗangwai, na aa gura. ");
INSERT INTO tswNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Gogo n to ronuso ɗu atsuvu adama a nda, kafu ili i nda i fara. ");
INSERT INTO tswNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Adama o ndolo, na̱ za ro damma ɗu, ‘Ka̱lyuwa̱i, Zamawawa ta̱ ɗe o ogozo,’ she i ꞌya̱wa̱ i ka̱lyuwa̱ wan. Ko a damma ɗu, ‘Apa uba̱ta̱ u na u ri upaꞌun,’ she i usu wan! ");
INSERT INTO tswNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Na̱ Mawun ma Vuma ma̱ ta̱wa̱, ama suru e te ene yi, cine i revei imaɗatsu i tsu maɗatsa zuva suru. ");
INSERT INTO tswNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Uba̱ta̱ u na a̱kwa̱kwa̱ a̱ ri, lo ɗa asala o tsu ɓoloto, adama o ndolo iroci i nda u to rocosu ukosu u rawa ta̱ zuzu. ");
INSERT INTO tswNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Babu usa̱n na̱ rana va̱ a̱tsuma̱lima̱ ndolo koto, ‘Urana u ta̱ rumba̱na̱ Woto waru wa̱a̱ da̱shi ikana shi. Italyoꞌo i ta̱ riya̱, Waru A̱sula̱ a̱ ta̱ jinga̱ɗa̱ cira na ri zuva.’ ");
INSERT INTO tswNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“A mantsa mo ndolo, e te ene iroci i Mawun ma Vuma ɗe zuva.† Ama o uvaɗi suru a̱ ta̱ shon adama o wovon. E te ene Mawun ma Vuma a̱ ta̱wa̱ ɗe zuva nu ucira na̱ tsugbain. ");
INSERT INTO tswNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Waru u ta̱ lyungu nlingata ma̱ yi na̱ mesun ma aavana a gbain, o to ɓoloto aza a na A̱sula̱ a ɗangwai diga o ufaru wu uvaɗi a̱ tyo o ukosu wu uvaɗi uba̱ta̱ u ta̱. ");
INSERT INTO tswNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Gogo i rito urevu u nda e ekere o uɗanga wu ubiri: Nna̱ ye ene eten na̱ a̱vuꞌun e le a̱ lima̱na̱ da̱a̱n, waru na ayawa no ototopi, i reve mantsa ma̱ lyushi ma rawa ta̱ zuzu. ");
INSERT INTO tswNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Na̱ ye ene ili i ndolo suru a farasa, i te reve mantsa ma rawa ta̱ zuzu. ");
INSERT INTO tswNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","I cuwan ili i nda suru i ta fara kafu ama a na a̱ ri nda wuma suru a̱ kuwa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Zuva ni iɗa a̱ ta̱ ka̱ra̱, agba adanshi a̱ va̱ a̱a̱ ka̱ra̱ shi ko keꞌen. ");
INSERT INTO tswNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ko za reve uranaꞌa shi, ko mantsaꞌa, hali na̱ nlingata ma̱ A̱sula̱ n na n ri ɗe zuva hali na̱ Mawun ma Vuma. She Dada ɗa goon revei. ");
INSERT INTO tswNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Na̱ Mawun ma Vuma ma̱a̱ ta̱wa̱, ili i ta̱ da̱na̱ vadamma a mantsa ma na Nuhu† yuwain wuma. ");
INSERT INTO tswNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","A̱tsuma̱ a rana ndolo kafu u ulungusu u mini, ama a lyuwusa ta̱ no o sowi, na a yuwin lolo cine a tsu yuwusan hali urana u na Nuhu uwai a̱tsuma̱ a wantsun. ");
INSERT INTO tswNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Agba a gura reve ili i na i ri a mmalu shi, hali mini ma̱ ta̱wa̱ ma lyuwa le suru. Ne ɗa woo oꞌwo na̱ Mawun ma Vuma ma̱ ta̱wa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ali e re a̱ ta̱ da̱na̱ o uɗuma̱. A ta tara vuma ta̱ reve a lyawa vuma ta̱. ");
INSERT INTO tswNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","A̱ma̱ci e re a̱ ta̱ da̱na̱ a yira a aatali a yira. A ta tara ka ta̱ reve a lyawa ka ta̱. ");
INSERT INTO tswNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Adama o ndolo, i da̱na̱ ufoɓu, i reve urana u na Zagbain ɗu ri lo a̱ ta̱wa̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Na̱ za vu uꞌwa reve yashi i na vivu a̱a̱ ta̱wa̱, i reve waa lantsa shi, waru waa lyawa vivu ndolo uwa o uꞌwa wa̱ yi shi. ");
INSERT INTO tswNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","A̱ɗu i ꞌyuwan i ciga i da̱na̱ ufoɓu a mantsa suru. Adama a na Mawun ma Vuma ma̱ ta̱ ta̱wa̱ a mantsa ma na i zuwai shi. ");
INSERT INTO tswNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Aagbashi a̱ ne a ɗa a̱ ri na̱ a̱ɓula̱ nu ugbozu? A̱yi ɗa za na zavuꞌwa va̱ yi zuwa niyi u ka̱lyuwusa̱ akapi a̱ a̱za̱ a̱ yi a agbashi, nu u casu nle ilyalya a mantsa ma saꞌani. ");
INSERT INTO tswNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Na̱ zavuꞌwa va̱ yi ka̱mba̱, a̱vu u cina yi u yuwan ulinga u saꞌani, u ta ca yi iliyinkapa. ");
INSERT INTO tswNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Amayun a ɗa maa dansaa ɗu, zavuꞌwa ndolo ta ɗangwa aagbashi o ndolo wo oꞌwo za na a̱ da̱na̱ a̱ ka̱lyuwusa̱a̱ yi itana ya̱ yi suru. ");
INSERT INTO tswNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Agba nna aagbashiꞌi u ri na̱ a̱ɓula̱ shi, u ta damma aciya̱yi a na zavuꞌwa va̱ yi a̱a̱ ka̱mba̱ goꞌo shi. ");
INSERT INTO tswNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Reve u reme malapa ma agbashiꞌi suru. A̱vu u uwa alya nu u sowi hali wo oꞌwo usowu oɓolo na̱ a̱za̱ a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Zavuꞌwaꞌa u ta̱ ka̱mba̱ a mantsa ma na u zuwai shi, ko a mantsa ma na u ri ufoɓu shi. ");
INSERT INTO tswNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Zavuꞌwa u ta ɓuɓatsa yi lipu, a̱vu u ka̱mba̱to yi wo oꞌwo na̱ a̱za̱ e ikpaꞌa, uba̱ta̱ u na ama a̱a̱ shon na lumi anga adama a̱ a̱tsuma̱lima̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Reve Yesu lyuwa elime na adanshi, “A mantsa mo ndolo, apa cine tsugono tsa zuva tsa̱a̱ da̱na̱: A yuwan ta̱ esheli kupa a na a tarai ifitila i le, a̱vu a̱ ka̱ra̱ a̱ ꞌya̱wa̱ a gaꞌaton vali vu kasaꞌavu. ");
INSERT INTO tswNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ama o ton a̱tsuma̱ e le olo a ɗa, akapi a ama o ton gba a̱za̱ o ugbozu a ɗa. ");
INSERT INTO tswNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Olo o ndolo a na a̱a̱ ka̱ra̱ a tara ta̱ ifitila i le, agba a̱ guza̱ maniꞌin mo ro shi. ");
INSERT INTO tswNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","A̱za̱ o ugbozu gba, a̱vu a̱ ɓa̱na̱ maniꞌin mo ro o mupondo n ro. ");
INSERT INTO tswNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ana gba vali vu kasaꞌavu rawai goꞌo shi, a̱vu a fara mgba̱ɗa̱ hali a lantsa. ");
INSERT INTO tswNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Na ayin uta̱nu a̱vu vuma ro saala, ‘Vali vu kasaꞌavu ta̱ lo a̱ ta̱wa̱! Ta̱wa̱i i gaꞌaton yi!’ ");
INSERT INTO tswNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“A̱vu esheliꞌi suru a̱ ꞌyon a lapula ifitila i le. ");
INSERT INTO tswNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","A̱vu oloꞌo a damma a̱za̱ o ugbozu, ‘Neꞌe ntsu maniꞌin ma̱ ɗu waꞌa, adama a na a̱za̱ a̱ tsu a ciga ta̱ ma̱kima̱a̱.’ ");
INSERT INTO tswNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ɗaɗa ele gba a̱ usu nle, ‘Tsu ri na̱ maniꞌin ma na maa rawa tsu na̱ a̱ɗu shi. ꞌYa̱wa̱i uba̱ta̱ wa aza a na a winisa, tsa̱ra̱ i tsura̱ i tsulaa aciya̱ɗu.’ ");
INSERT INTO tswNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ana olo e esheli o ndolo a̱ ꞌya̱wa̱i atsulu a maniꞌin, ɗaɗa gba vali vu kasaꞌavuꞌu u rawai. Esheli a na gba a̱ ri ufoɓu, reve a uwa o uꞌwa na̱ vali vu kasaꞌavuꞌu uba̱ta̱ wa̱ a̱buki. Ɗaɗa a̱ kpa̱toi una̱ntsu wu uꞌwaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“A̱ tyo ɗe, a̱vu esheli a na a buwai a rawa, ɗaɗa a uwai yisaali, ‘Zavuꞌwa! Kpa̱tuꞌwa̱a̱ tsu una̱ntsu.’ ");
INSERT INTO tswNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“A̱vu gba vali vu kasaꞌavuꞌu u usu, ‘Amayun a ɗa maa dansaa ɗu, n reve ɗu shi.’ ” ");
INSERT INTO tswNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Reve Yesu damma, “Adama o ndolo i da̱na̱ ufoɓu kuci, i reve urana ko mantsa ma na ili i nda yaa fara shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","A̱vu waru Yesu yuwisan adanshi ni iroci i nda, “A mantsa mo ndolo, apa cine tsugono tsa zuva tsa̱a̱ da̱na̱: Vuma ro shi ta̱ ciga u ꞌya̱wa̱ mmalu uba̱ta̱ u ro. Kafu u ka̱ra̱, reve u ɗe agbashi a̱ yi, a̱vu u damma le a̱ ka̱lyuwa̱ itana ya̱ yi ulobonu kafu u ta̱wa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Vumaꞌa u reve ta̱ ulinga u na za suru aa yuwan. Reve u ca za vu ufaru ikebe i gbain i azurufa i ton. Waru u ca ta̱ za ve ire ikebe i gbain i azurufa i re. A̱vu u ca za va taꞌatsu ikebe i gbain i azurufa i ta̱. Reve u ka̱ra̱ mmalu ma̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ana vumaꞌa u ka̱ra̱i, a̱vu aagbashi a na u cayi ozo o toꞌon u yuwan ulinga ne ele, u zamiyisa ozo o ton waru. ");
INSERT INTO tswNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Reve waru aagbashi a na a cayi ejere ne ɗa fo u yuwain ulinga ni ikebeꞌe, a̱vu u tsurisa̱ ejere waru. ");
INSERT INTO tswNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Amma aagbashi a na a cayi za ta̱, a̱vu u ka̱pa̱ a̱a̱ka̱ri reve u soko ikebe yi zagbain va̱ yi e iɗa. ");
INSERT INTO tswNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ana a jimai, a̱vu zagbaiꞌin ka̱mba̱, ɗaɗa we ecei agbashiꞌi ili i na a yuwain ni ikebeꞌe. ");
INSERT INTO tswNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","A̱vu aagbashi a na a cayi ozo o toꞌon u ta̱wisa̱ yi no ozo o ton a na u tsura̱i a̱tsuma̱ e ikebeꞌe. Reve u damma, ‘Zagbain, vu ca mu ta̱ ikebe i gbain i azurufa i ton, n tsurisa̱ ta̱ ozo o ton.’ ");
INSERT INTO tswNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“A̱vu u usu, ‘Vu yuwan ta̱ ulinga u saꞌani. Aagbashi a̱ a̱ɓula̱ a ɗa vu ri, waru vu tsu uwwa ta̱ adanshi. Ana vu yuwain a̱ɓula̱ ni ili i keꞌen i nda, n ta zuwa wu vu ka̱lyuwusa̱ ili i na i laꞌai mgbain. Ta̱wa̱ vu uwwa uyoꞌo oɓolo na̱ a̱mu.’ ");
INSERT INTO tswNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“A̱vu za ve ire, za na a cayi ejere, ta̱wa̱ reve u damma, ‘Zagbain, vu ca mu ta̱ ikebe i gbain i azurufa i re, n tsurisa̱ ta̱ ejere.’ ");
INSERT INTO tswNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Reve u usu, ‘Vu yuwan ta̱ ulinga u saꞌani. Aagbashi a̱ a̱ɓula̱ a ɗa vu ri waru vu tsu uwwa ta̱ adanshi. Ana vu yuwain a̱ɓula̱ ni ili i keꞌen i nda, n ta zuwa wu vu ka̱lyuwusa̱ ili i n na i laꞌai mgbain. Ta̱wa̱ vu uwwa uyoꞌo oɓolo na̱ a̱mu.’ ");
INSERT INTO tswNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ɗaɗa aagbashi a na a cayi za ta̱, u ta̱wa̱ u dammai, ‘Zagbain, n reve ta̱ vu tu usa̱n. Vu rotso ta̱ cuꞌun vuma na tsu ciga u gasa uba̱ta̱ u na u cuꞌwa̱in shi, vu ciga ta̱ ili ye pere. ");
INSERT INTO tswNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Adama o ndolo mu uwwa ta̱ wovon, ɗaɗa gba n ꞌya̱wa̱i n sokoi ikebe ya̱ wu e iɗa. Apa wu ikebe ya̱ wu.’ ");
INSERT INTO tswNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Reve u usu, ‘A̱vu aagbashi a̱ a̱ɓula̱ ɗa shi, waru orogo a ɗa vu ri! Vu damma vu reve ta̱ a na n tsu ciga n gasa uba̱ta̱ u na n cuꞌwa̱in shi. ");
INSERT INTO tswNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Vu shi ta zuwa ikebe i va̱ o uꞌwa wi ikebe e ekere a̱ a̱za̱ o uvadalasa, tsa̱ra̱ n tsura̱ pe ili i ro waꞌa a̱tsuma̱ a̱ yi.’ ");
INSERT INTO tswNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Ɗaɗa zagbaiꞌin u dammai akapi a agbashiꞌi, ‘Ushiyi ikebeꞌe e ekere a̱ yi, a̱vu i ca aagbashi a na a̱ ri ni ikebe i gbain i azurufa kupa. ");
INSERT INTO tswNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Na̱ nanza yuwan a̱ɓula̱ ni ili i na u ri na̱ a̱yi, A̱sula̱ a̱ ta̱ da̱shi ca yi ili ya̱ a̱bunda̱, waru u ta̱ tsura̱ ili hali a̱ ka̱ra̱la̱i wira̱. Za na gba ri na̱ a̱yi shi, A̱sula̱ a̱ ta̱ ushi keꞌen na u ri na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Gogo variyi aagbashi o ulambu wa̱ a̱ɓula̱ o ndolo a alanga, a̱tsuma̱ e irumbu i na ama a̱a̱ shon na a lumi anga e le na̱ a̱tsuma̱lima̱.’ ” ");
INSERT INTO tswNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Reve Yesu lyuwa elime nu uritosu, “Mawun ma Vuma ma̱ ta̱ ta̱wa̱ na̱ tsugbain tsa gbain, na̱ nlingata ma̱ yi suru. U to oꞌwo Mogono, a̱vu u da̱nu o ootogu o ugeꞌetosu a gbain a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Iɗa yu uvaɗi suru o to ɓoloto a̱ ma̱ka̱ka̱n ma̱ yi, waru u ta kasa le ure, cine za va aguɓa tsu kakasa ikyon na̱ mgbele. ");
INSERT INTO tswNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","U ta zuwa ikyon o ukere usaꞌani, mgbele waru gba u zuwa le o ukere ugula̱ wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“A̱vu Mogonoꞌo u damma aza a na a̱ ri o ukere usaꞌani wa̱ yi, ‘Ta̱wa̱i, Dada va̱ ca ɗu ta̱ abaꞌun a̱ yi. Ushiyi tsugono tsa na A̱sula̱ o foɓoo nɗu kafu u yuwan uvaɗi. ");
INSERT INTO tswNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ana n da̱na̱i na ambulu, i neꞌe mu ta̱ ilyalya n lyuwa. Ana n da̱na̱i na akuli, i neꞌe mu ta̱ mini n sowo. Ana n yuwain limocin i ushi mu ta̱ a ꞌwa ɗu. ");
INSERT INTO tswNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ana n da̱na̱i ataɓu, i neꞌe mu ta̱ itana n oto. Ana n da̱na̱i ubanakun, i coꞌwo mu ta̱. Ana n da̱na̱i o uꞌwa wa ali, i ka̱lyuwa̱ mu ta̱.’ ");
INSERT INTO tswNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Reve ama a̱ a̱ɓula̱ꞌa̱ a̱ usu, ‘Zagbain, te ɗa tse ene nuwu na ambulu, a̱vu tsu neꞌe wu ilyalya? Waru te ɗe tse ene nuwu na akuli, a̱vu tsu neꞌe wu mini mo oso? ");
INSERT INTO tswNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Te ɗa tse ene nuwu a̱ ndeꞌen, waru danga na̱ ꞌwa tsu, reve tsu banu wu a ꞌwa tsu? Te ɗa tse ene nuwu ataɓu, reve tsu ca wu itana? ");
INSERT INTO tswNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Te ɗa tse ene nuwu ubanakun ko o uꞌwa wa ali, a̱vu tsu ka̱lyuwa̱ wu?’ ");
INSERT INTO tswNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Mogonoꞌo u ta̱ usu, ‘Ni i yuwaan ama a̱ va̱, ko cine a̱ ri ana ili i ro shi, a̱mu ɗa i yuwayin.’ ");
INSERT INTO tswNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Reve waru u damma aza a na a̱ ri o ukere ugula̱, ‘Lyawa numu, a̱ɗu na A̱sula̱ a yuwayin una̱. ꞌYa̱wa̱i i uwa a akina a na a̱ ri n kima̱ shi, za na o foɓoyi Mekerenkesu na̱ nlingata ma̱ yi! ");
INSERT INTO tswNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","N da̱na̱ ta̱ na ambulu, agba i ca mu ilyalya n lyuwa shi. N da̱na̱ ta̱ na akuli, agba i ca mu mini n sowo shi. ");
INSERT INTO tswNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","N da̱na̱ ta̱ o limocin, agba i ushi mu shi, waru n da̱na̱ ta̱ ataɓu, agba i neꞌe mu itana n oto shi. N da̱na̱ ta̱ ubanakun waru a̱tsuma̱ o uꞌwa wa ali, agba i ka̱lyuwa̱ mu shi.’ ");
INSERT INTO tswNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ama o ndolo a̱ ta̱ usu, ‘Zagbain, urana u ne u ɗa tse ene nuwu na ambulu ko na akuli a̱vu tsu kuɗa̱ a kamba wu? Ko vu da̱na̱i o limocin a̱vu tsu kuɗa̱ a̱ ushi wu? Waru urana u ne u ɗa tse ene nuwu ataɓu reve tsu kuɗa̱ a ca wu itana? Ko gba urana u ne u ɗa vu da̱na̱i ubanakun ko vu da̱na̱i o uꞌwa wa ali reve tsu kuɗa̱ a̱ ka̱lyuwa̱ wu?’ ");
INSERT INTO tswNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Mogonoꞌo u ta damma le, ‘A mantsa ma na i ꞌyuwain a kamba ko vuma ta̱ a̱tsuma̱ a ama a̱ va̱, ko cine o rotsoi ili i ro shi, a̱mu ɗa i ꞌyuwain a yuwaan.’ ");
INSERT INTO tswNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ama o ndolo a ta uwa a̱tsuma̱ a̱ a̱tsuma̱lima̱ a na a̱ ri n koto shi, amma ama a̱ a̱ɓula̱ a ta yuwan wuma u babu ukotu.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ana Yesu kotoi a yuwusan adanshi e ili i nda, ɗaɗa u dammai ojoro a̱ yi, ");
INSERT INTO tswNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“I reve ta̱, rana re ɗa buwai a fara A̱buki a Mapasa,† waru a̱mu, Mawun ma Vuma, a̱mu ɗa ee reme, a̱vu a vara mu a akpata.”† ");
INSERT INTO tswNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Reve nan ganu a gbagbain na azagbain o ɓoloto o uꞌwa wa aabara a nan ganu na a̱ tsu ɗe Kayafa. ");
INSERT INTO tswNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","A̱vu a yuwan ifoɓi tsa̱ra̱ e reme Yesu usokowu, reve o una yi. ");
INSERT INTO tswNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Reve a damma, “Woo lobono tsu yuwan yi a mantsa ma̱ A̱buki a Mapasa shi, adama a na ama a̱ ta̱ ꞌya̱sa̱n nla̱ngi.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ele pe a̱tsuma̱ e ifoɓi i na ee reme Yesu, a̱yi gba u da̱na̱ ta̱ ɗe Batanya o uꞌwa wa̱ Simo ma̱kutu. ");
INSERT INTO tswNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","A̱yi a alya e ilyalya ɗaɗa ka ro ta̱wa̱i uba̱ta̱ wa̱ yi na̱ meden ma aatali ma saꞌani. A̱tsuma̱ a̱ yi maniꞌin ma̱ ma̱guru me ikebe lon ma̱ da̱na̱ ta̱ pe. Reve u tsuwa̱n Yesu a aaci. ");
INSERT INTO tswNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ana o ojoro a̱ yi e enei ili i ndolo, a̱vu a uwwa upan hali a damma, “Cine tsa ɗa wa̱a̱ lungususa̱ ikebe? ");
INSERT INTO tswNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Na̱ a̱ shi a wina yi, a̱ shi ta̱ tsura̱ ikebe ya̱ a̱bunda̱, reve a ca alambi.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Agba Yesu reve ta̱ ili i na aa dansa, ɗaɗa u damma nle, “Cine tsa ɗa yaa damatosun ka nda? U yuwaan mu ta̱ isaꞌani. ");
INSERT INTO tswNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","I ta̱ na alambi a̱tsuma̱ a̱ ɗu kuci, a̱mu agba maa jima pa oɓolo na̱ a̱ɗu shi. ");
INSERT INTO tswNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","U tsuwa̱n mu ta̱ maniꞌin ma nda, tsa̱ra̱ u foɓo lipu va̱ adama a̱ a̱ciɗa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Amayun a ɗa maa dansaa ɗu, uba̱ta̱ u na aa yuwan alajiya a Alabari a Saꞌani a nda a̱tsuma̱ o uvaɗi suru, a ta damma ili i na ka nda yuwain a cuwusan na̱ a̱yi.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","A̱vu za ta̱ a̱tsuma̱ a Kupanejere, za na a̱ tsu ɗe Yahuza Iskariyoti, ꞌya̱wa̱ u yuwan adanshi na̱ nan ganu a gbagbain. ");
INSERT INTO tswNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Reve u damma, “Nye i ɗa yaa tsupa mu nna̱ n ca ɗu Yesu?” A̱vu a ca yi ikebe† i azurufa mataꞌatsu. ");
INSERT INTO tswNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Diga a mantsaꞌa reve u reme izami ure u na waa winaa le Yesu. ");
INSERT INTO tswNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","O urana wu ufaru u na aa yuwusan A̱buki o Opopofu,† a̱vu ojoro a̱ ta̱wa̱ a yuwan Yesu yeci, “Te ɗa vu cigai tsu foɓo alya e ilyalya adama A̱buki a Mapasa?” ");
INSERT INTO tswNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","A̱vu u usu, “ꞌYa̱wa̱i a̱ lyuci uba̱ta̱ u vuma ro, a̱vu i damma yi, Manlu ma damma: ‘Mantsa ma na a ɗangwaa numu ma ta yuwusan. N ta yuwan A̱buki a Mapasa no ojoro a̱ va̱ o uꞌwa wa̱ wu.’ ” ");
INSERT INTO tswNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","A̱vu a yuwan cine u damma nle, reve o foɓo ilyalya ya̱ A̱bukiꞌi ɗe. ");
INSERT INTO tswNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ana urana u kotoi, reve Yesu na̱ Kupanejere† a̱ da̱nu alya. ");
INSERT INTO tswNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ele pe a̱tsuma̱ a alya, a̱vu u damma, “N ta dansaa ɗu amayun, za ta̱ a̱tsuma̱ a̱ ɗu u ta wina mu.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ojoroꞌo a uwwa uyoꞌo shi, reve a̱ ka̱ra̱ e eceshe yi a̱za̱ a̱ ta̱ ta̱, “Amayun, Zagbain, a̱mu ɗa maa wina wu shi. Ko a̱mu ɗa?” ");
INSERT INTO tswNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Reve Yesu usu, “Vuma na otoyi ukere wa̱ yi a mataɗa ma̱ ta̱ na̱ a̱mu, a̱yi ɗa za na aa wina mu. ");
INSERT INTO tswNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","A̱mu Mawun ma Vuma, n ciga n ꞌyuwan n kuwa̱, cine a ɗanai adama a̱ va̱ ɗe nu ujimu. Amma woo yoꞌono vuma na wina numu shi. U shi ta laꞌaa yi nna̱ a̱ shi a matsan yi shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","A̱vu Yahuza za na aa wina yi, damma, “Manlu, amayun a̱mu ɗa shi, ko a̱mu ɗa?” A̱vu Yesu usu, “Ee, a̱vu ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ele pe a̱tsuma̱ a alya, reve Yesu tara oopopofu. A̱vu u godyoo A̱sula̱ reve wu busa yi. Ɗaɗa waa ca ojoroꞌo a̱vu u damma, “Ushiyi oopopofu a ndaꞌa i tama yi, lipu va̱ ɗa ndaꞌa.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","A̱vu Yesu tara mokoto a̱vu u godyoo A̱sula̱ adama a̱ yi, reve u ca ojoroꞌo a̱vu u damma, “Suru nɗu sowoi. ");
INSERT INTO tswNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Adama a na mpasa n va̱ n ɗa za na o oꞌwoi iroci ya akucunu† a na A̱sula̱ a yuwain na ama a̱ yi, adama a yuwaan le gafura vu nusu le. ");
INSERT INTO tswNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","N damma ɗu nda, ma̱a̱ da̱shi sowo masayan ma inabi† shi, she na̱ n sowo yi o ure u saꞌavu o tsugono tsa Dada va̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ana a canai ishipa, reve o uta̱ a̱ tyo a Masasan ma̱ Zetun.† ");
INSERT INTO tswNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Reve Yesu damma ojoro a̱ yi, “Na ayin a nda, suru nɗu i ta suma a̱vu i lyawa mu, cine vumava̱sula̱ dammai, ‘A̱sula̱ a̱ ta̱ ga̱la̱ za va aguɓa, waru ikyon ya̱ yi i te beteꞌwe.’ ");
INSERT INTO tswNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“A mantsa ma na n ꞌyoyin a̱tsuma̱ a̱ a̱kwa̱kwa̱, n ta ꞌya̱wa̱ a̱tsuma̱ a̱ Ga̱lili, n ta fara rawaa ɗu ɗe.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Reve Bituru damma, “Ko na akapi aa wasan wu, a̱mu maa wasan wu shi!” ");
INSERT INTO tswNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","A̱vu Yesu damma, “Amayun a ɗa maa dansaa wu, na ayin a nda, kafu moton ma saala vu ta damma vu reve mu shi, toto utaꞌatsu.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Amma reve gba Bituru damma, “Maa damma n kuɗa̱ ta̱ e reve wu shi! N ta̱ kuwa̱ oɓolo na̱ a̱vu!” Ne ɗa fo akapi o ojoroꞌo a dammai. ");
INSERT INTO tswNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","A̱vu Yesu ka̱ra̱ a̱ ꞌya̱wa̱ uba̱ta̱ u na a̱ tsu ɗe Getisemeni oɓolo no ojoro a̱ yi, a̱vu u damma le, “Isawain pa nda, a̱mu n ta̱ ꞌya̱wa̱ ndeɗe n yuwan avasa.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Reve u tara Bituru no olobo e re a̱ Za̱ba̱di, Yakubu na̱ Yahaya. U da̱na̱ ta̱ na̱ a̱tsumola̱ngu waru lon. ");
INSERT INTO tswNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ɗaɗa u damma nle, “N ta̱ na̱ a̱tsumola̱ngu gashi u to una mu. I da̱nu pa nda, i da̱na̱ e ipiri oɓolo na̱ a̱mu.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A̱vu u ꞌya̱wa̱ makasu, reve u kingyo a̱vu u ka̱ɗa̱to urewesu wa̱ yi a̱ tyo e iɗa. A̱vu u yuwan avasa, “Dada va̱, nu u n ri yuwan, she vu ca mu mokoto ma̱ a̱tsuma̱lima̱ a nda wan. Amma vu yuwan ili i na n cigai wan, she ili i na vu cigai.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","A̱vu u ka̱mba̱ uba̱ta̱ wo ojoro a taꞌatsuꞌu, reve u cina le a nlavu. A̱vu u damma Bituru, “Cine tsa ɗa mataꞌatsu ma̱ ɗu i ri a nlavu, agba i gura yuwan ipiri na̱ a̱mu hali rumu ta̱ shi? ");
INSERT INTO tswNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","I da̱na̱ wuma tsa̱ra̱ i yuwan avasa i tsura̱ ucira u na yaa gura isawan mantsa ma̱ ma̱lyungwa̱. Asuvu a̱ ɗu a ciga ta̱ a yuwan ili i na i ri mejege, amma lipu ri nu ucira shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Reve waru u lyawa le tsa̱ra̱ u yuwan avasa, a̱vu u damma, “Dada va̱! Na aa tawa mokoto ma nda shi, reve wo oꞌwo she na̱ n sowo yi, n ta yuwan ili i na vu ciga numu n yuwan.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ana u ka̱mbisa̱i a̱vu u cinisa le a nlavu adama a na a gura kpa̱tuꞌwa̱ esu e le shi. ");
INSERT INTO tswNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ɗaɗa u lyawa nle a nlavu, a̱vu u ꞌya̱wa̱ u yuwan avasa wa taꞌatsu, a̱vu u vasa adansa ili i ta̱. ");
INSERT INTO tswNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Reve u ka̱mbisa̱ uba̱ta̱ wo ojoroꞌo, a̱vu u damma le, “Cine i buwai a nlavu e ivuwusan? Gogo mantsa ma yuwan ta̱. A̱mu ɗa, Mawun ma Vuma, ma na aa ca e ekere o ucira wa ama a vama. ");
INSERT INTO tswNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ꞌYoyin tsu ka̱ra̱i. Ka̱lyuwa̱i, apa vuma na aa wina mu rawai.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu a̱tsuma̱ a adanshi, a̱vu Yahuza a̱tsuma̱ a Kupanejere, u rawa ugeru no oɓolo a ama. Nan ganu a gbagbain na azagbain a̱ lyungu ta̱ amaꞌa no oloko na̱ mutsun m peꞌeni adama a̱ nla̱ngi. ");
INSERT INTO tswNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yahuza damma le ta̱ ɗe, “I te reve vuma na yee reme, na̱ n ꞌya̱wa̱ n ca̱sa̱ yi ni ikatalu.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","A̱vu Yahuza ka̱ra̱ a̱ ꞌya̱wa̱ ya̱ Yesu mejege, reve u damma, “A̱ku, Manlu!” a̱vu u katala yi. ");
INSERT INTO tswNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ɗaɗa u usuyi, “Iꞌutsa̱, yuwan ili i na vu ta̱wa̱i vu yuwan.” Ɗaɗa amaꞌa a̱ ta̱wa̱i a̱vu e reme yi ugbamu. ");
INSERT INTO tswNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","A̱vu za ta̱ a̱tsuma̱ o ojoro e Yesu u tala matsun me peꞌeni, reve u koɗo utsuvu wa aagbashi wa aabara a nan ganu. ");
INSERT INTO tswNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","A̱vu Yesu damma yi, “Ka̱mbuwa̱ matsun me peꞌeni ma̱ wu. Za na yuwain nla̱ngi na̱ matsun me peꞌeni, na̱ matsun me peꞌeni ma ɗa fo wa̱a̱ kuwa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","I reve ta̱ amayun n ta gura pati Dada va̱, a̱vu u ca mu oɓolo oɓolo a nlingata ma̱ A̱sula̱ kupa ne ejere a na a laꞌai oɓolo suru adama a̱ nla̱ngi. ");
INSERT INTO tswNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Amma i ciga i ꞌyuwan wo oꞌwo tsunda, tsa̱ra̱ o shiton ili i na Adanshi a̱ A̱sula̱ a dammai.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ɗaɗa Yesu dammai oɓoloꞌo, “I ta̱wa̱ ta̱ tsa̱ra̱ i reme mu no oloko na̱ mutsun m peꞌeni gashi a̱mu za vu nga̱la̱la̱i ɗa. Usana suru n da̱na̱ ta̱ o ritosu a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗa, agba i reme mu pe shi. ");
INSERT INTO tswNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Amma ili i nda i fara ta̱ suru, tsa̱ra̱ ili i na ama̱sula̱ a ɗanai i shiwan.” Ɗaɗa ojoroꞌo suru a sumai a̱vu a lyawa yi. ");
INSERT INTO tswNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Aza a na e remei Yesu a tara yi ta̱ a̱ tyo o uꞌwa wa Kayafa, aabara a nan ganu, uba̱ta̱ u na munlu n Wila̱ na azagbain o ɓolotoi wira̱ u ta̱. ");
INSERT INTO tswNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","A̱vu Bituru tonishi le makasu, hali a rawa a̱ a̱a̱ra̱ra̱ o uꞌwa wa aabara a nan ganu. Reve u da̱nu zuzu na̱ a̱duga̱ri a̱ A̱a̱ꞌisamapaɗa, tsa̱ra̱ we ene ili i na yaa fara na̱ Yesu. ");
INSERT INTO tswNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nan ganu a gbagbain na Azagbain a Mbara† suru a̱ shi ta̱ a ciga o una Yesu. Reve a zamishi ama a na aa yuwan epen gayin a aci a̱ yi o ukobu wu ugeꞌetosu. ");
INSERT INTO tswNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ama na̱ a̱bunda̱ a̱ ta̱wa̱ ta̱ a yuwan epen gayin a aci a̱ yi, amma azagbain a̱ tsura̱ ili ya amayun i na yaa zuwa o una yi shi. Reve ama e re a̱ ta̱wa̱ a damma, ");
INSERT INTO tswNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Vuma nda damma ta̱, ‘N ta̱ lungusa̱ A̱a̱ꞌisamapaɗa a nda, a̱vu n suwisa yi a̱tsuma̱ a rana taꞌatsu.’ ” ");
INSERT INTO tswNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","A̱vu aabara a nan ganu a̱ ꞌyon mishin, reve we ece Yesu, “Vu ri ni ili i na vaa damma adama e ili i na ama a nda a dammai shi?” ");
INSERT INTO tswNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Agba u damma ili i ro shi. A̱vu aabara a nan ganu a dammisa yi, “A̱tsuma̱ a aala a̱ A̱sula̱ a wuma n zuwa wu ta̱ vu kucina: Damma tsu na̱ a̱vu ɗa Zamawawa, Mawun ma̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Reve Yesu usu, “Ee, ne ɗaɗa cine vu dammai. Amayun a ɗa maa dansaa ɗu suru: a̱ ꞌya̱wa̱ elime i te ene Mawun ma Vuma nden o ukere usaꞌani u Mogono ma̱ A̱sulazuva, waru i te ene yi a̱ ta̱wa̱ e eleshe a zuva!” ");
INSERT INTO tswNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ana aabara a nan ganu a uwwai ili i ndolo, a̱vu wu kara itana ya̱ yi adama a̱ a̱tsumola̱ngu, reve u damma, “Kai! Vuma nda yuwan ta̱ adanshi a vama e ekere a̱ A̱sula̱! Tsu ciga za da̱shi yuwan adanshi o ro adama a̱ yi shi. Suru nɗu yu uwwa ta̱ a na u yuwain adanshi a vama e ekere a̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nye i cigai a yuwan na̱ a̱yi?” A̱vu a̱ usu, “U yuwan ta̱ unusu u na u rawai o una yi.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","A̱vu a caraa Yesu ma̱tsa̱n o urewesu, reve a̱ kukumu ekere a̱vu a̱ cikwa̱ yi. Reve ozo o ro a ɓasa yi. ");
INSERT INTO tswNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Reve a damma, “Vu damma a̱vu ɗaɗa Zamawawaꞌa! Adama o ndolo damma tsu za na cikwa̱ nuwu!” ");
INSERT INTO tswNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","A mantsa mo ndolo, Bituru lo ubuwu nden a̱ a̱a̱ra̱ra̱, a̱vu aagbashi o usheli a rawa ya̱ꞌa̱ yi, reve u damma, “A̱vu fo vu to oɓolo na̱ Yesu za va̱ Ga̱lili.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Reve Bituru damma a̱ ma̱ka̱ka̱n ma ama, “Ne ɗa u ri shi! N reve ili i na vaa dansa shi!” ");
INSERT INTO tswNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ana u lyawai uba̱ta̱ u na u shi, reve u ka̱mba̱ o una̱ntsu, a̱vu usheli u ro we ene yi. Reve u damma ama a na a̱ da̱na̱i lo, “Vuma nda fo u to oɓolo na̱ Yesu za va Nazara.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","A̱vu waru Bituru wasisan u damma, “N kucina ta̱ n reve vuma nda shi!” ");
INSERT INTO tswNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","A jima shi, a̱vu ama o ro a na a̱ da̱na̱i lo mishin a̱ ka̱ra̱ a̱ ꞌya̱wa̱ uba̱ta̱ wa̱ Bituru a̱vu a damma, “Amayun, a̱vu vu ta̱ pe a̱tsuma̱ a aza a na o tonishiyi Yesu. Tsu reve ta̱ ne, o una̱ u na vaa yuwusan adanshi tsa ama a̱ Ga̱lili.” ");
INSERT INTO tswNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ɗaɗa Bituru dammai, “N kucina ta̱ amayun a ɗa maa dansa! A̱sula̱ a ca mu a̱tsuma̱lima̱ na amayun a ɗa mu shi! N reve vuma ndolo shi!” Ɗaɗa moton ma saalashi. ");
INSERT INTO tswNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ɗaɗa Bituru cuwain ni ili i na Yesu damma niyi: “Kafu moton ma saala, vu ta wasan a na vu reve numu utaꞌatsu!” A̱vu wu uta̱ u shon na̱ a̱tsumola̱ngu a̱ a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Na̱ wasasa, a̱vu nan ganu a gbagbain suru na azagbain a yuwan ifoɓi i le a aci e Yesu tsa̱ra̱ o una yi. ");
INSERT INTO tswNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Reve a̱ nla̱ yi a̱vu a tara yi a̱ tyo ya Bilatu† Gwamna. ");
INSERT INTO tswNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ana Yahuza, za na cayi Yesu e ekere a nꞌyuwatan ma̱ yi, we enei a paɗaa ta̱ Yesu ugana wu ukwa̱, reve u yuwan shinreve nu ulinga u na u yuwain. Ɗaɗa u tarai ikebe i azurufa mataꞌatsuꞌu u ka̱mbuwa̱a̱ nan ganuꞌu oɓolo na azagbaiꞌin. ");
INSERT INTO tswNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Reve u damma, “Unusu† u na n yuwain a̱yi ɗa: N ca ɗu ta̱ vuma na ri nu unusu shi tsa̱ra̱ yu una yi.” A̱vu a̱ usu, “To, te imini i tsu na̱ za ndolo? Addama a̱ wu a ɗa ndoloꞌo, babu imini i tsu.” ");
INSERT INTO tswNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ɗaɗa Yahuza ocoi ikebeꞌe pe a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗa. Reve u ꞌya̱wa̱ wu nla̱ aciya̱yi zuva hali u kuwa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","A̱vu nan ganu a gbagbain a tara ikebeꞌe reve a damma, “U ushi ta̱ ikebe i nda adama a wuma u vuma. Wila̱ u damma ta̱ tsaa zuwa le oɓolo ni ikebe ya̱ A̱a̱ꞌisamapaɗa shi.” ");
INSERT INTO tswNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","A̱vu a tara ikebeꞌe reve a tsula uɗuma̱ wu za na a maꞌasa mpondo, tsa̱ra̱ a̱ tsura̱ uba̱ta̱ u na a̱a̱ ciɗo omocin na̱ a̱ kuwa̱ a̱tsuma̱ a̱ Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","A̱yi ɗa i zuwai e ɗeyi uba̱ta̱ꞌa̱, “Uɗuma̱ wu Mpasa” hali a̱ tyo a mantsa ma na a ɗanai aatagada a nda. ");
INSERT INTO tswNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Adama o ndolo a ɗa ili i na Irimiya† vumava̱sula̱ dammai i shiwain: “A tara ta̱ ikebe i azurufa mataꞌatsu, ikebe i na aza a Israꞌila a̱ usuyi a na aa tsupa adama a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","A tsula ta̱ uɗuma̱ wu za na a maꞌasa mpondo cine A̱sulazuva a damma numu.” ");
INSERT INTO tswNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","A mantsa mo ndolo, Yesu shi ta̱ mishin a̱ ma̱ka̱ka̱n ma Bilatu Gwamna, a̱vu Bilatu ece yi, “A̱vu mogono ma aza a Israꞌila ma ɗa?” Reve Yesu usu, “Ee, cine vu dammai ne ɗa u ri.” ");
INSERT INTO tswNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Amma ana nan ganu a gbagbain na azagbain a yuwain epen a aci a̱ yi, u yuwan adanshi shi. ");
INSERT INTO tswNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ɗaɗa Bilatu damma niyi, “Vu uwwa adanshi a na aa yuwusaan a aci a̱ wu shi?” ");
INSERT INTO tswNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Agba Yesu damma ili i ro shi, ɗaɗa gwamnaꞌa wo oꞌwoi a asalama lon. ");
INSERT INTO tswNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Aaꞌwan suru a mantsa ma̱ A̱buki a Mapasa, gwamna tsu lyawa ta̱ za ro na ri o uꞌwa wa ali, za na ama a ɗangwai. ");
INSERT INTO tswNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A mantsa mo ndolo, vuma na a̱ tsu ɗe Baraba da̱na̱ ta̱ pe a̱tsuma̱ o uꞌwa wa ali. Ama suru e reve ta̱ a na vuma va̱ a̱ɓula̱ ɗa shi, ko keꞌen. ");
INSERT INTO tswNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Adama o ndolo ana ama o ɓolotoi uba̱ta̱ u ta̱, ɗaɗa Bilatu ece nle, “A̱tsuma̱ aza a na a̱ ri pe a̱tsuma̱ o uꞌwa wa ali, zane ɗa i laꞌa cigai n lyawa? I ciga ta̱ n lyawa Baraba ko Yesu za na ee ɗesu Zamawawa?” ");
INSERT INTO tswNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Bilatu reve ta̱ a na azagbain a̱ ta̱wa̱i na̱ Yesu uba̱ta̱ wa̱ yi adama a̱ tsushuꞌun tsa ɗa. ");
INSERT INTO tswNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Bilatu† ubuwu lo nden o ootogu o ugeꞌetosu, ɗaɗa ka va̱ yi lyunguwa̱ niyi ikaka i nda: “She vu yuwan ili i ro na̱ vuma nda wan, adama a na ko iwuya i ta̱ u yuwan shi. Anaꞌan n yuwan ta̱ alavu a aci a̱ yi, waru u ta̱ ɓa̱li mu lon.” ");
INSERT INTO tswNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Agba nan ganu a gbagbain na azagbain a zuwa ta̱ okolo a ama o oɓoloꞌo a pati a lyawa Baraba, agba o una Yesu. ");
INSERT INTO tswNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","A̱vu Bilatu ecishe oɓoloꞌo, “A̱tsuma̱ a ama e re a nda, zane ɗa i cigai n lyawaa ɗu?” Reve a̱ usu, “Baraba.” ");
INSERT INTO tswNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Reve Bilatu ece le, “To, cine i cigai n yuwan na̱ Yesu, za na ee ɗesu Zamawawa?” A̱vu suru nle a̱ usu, “Vara niyi a akpata.” ");
INSERT INTO tswNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Reve Bilatu ece le, “Nye i zuwai? Unusu u ne u ɗa u yuwain?” A̱vu a̱ da̱shi saala lon, “Vara niyi akpata!” ");
INSERT INTO tswNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ana Bilatu enei babu ili i na waa gura yuwan waru, waru ama a ɗa nda e temei nla̱ngi. Ɗaɗa u kenei mini a̱vu u saꞌa ekere a̱ yi a̱ ma̱ka̱ka̱n me le reve u damma, “Babu imini i va̱ na̱ mona ma vuma nda, a̱ɗu ɗa yoo una yi.” ");
INSERT INTO tswNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Reve suru nle a̱ usu, “E reme tsu nu unusu a̱tsu na̱ muwun n tsu adama a na o una niyi.” ");
INSERT INTO tswNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","A̱vu Bilatu lyawaa le Baraba. Reve u damma a̱soja a fufaba Yesu na asuɗu, a̱vu a̱ ꞌya̱wa̱ a vara yi a akpata.† ");
INSERT INTO tswNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","A̱vu a̱soja a gwamna a tara Yesu a uwa pe o ukobu, reve a̱ ka̱nda̱ruwa̱ yi suru. ");
INSERT INTO tswNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Reve o foɗo yi itana, a̱vu o oto yi aayala a saan lon. ");
INSERT INTO tswNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","A̱vu a tara awanda a̱ ka̱nda̱ruwa̱a̱ yi a aaci gashi ookokolo. Reve a zuwa aaɗanga o ukere usaꞌani wa̱ yi, a̱vu a̱ kingyo a̱ ma̱ka̱ka̱n ma̱ yi reve a yuwaan yi ulamu, “Tsu ca wu ta̱ tsugbain, mogono ma aza a Israꞌila.” ");
INSERT INTO tswNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","A̱vu a tsuwa̱a̱n yi ma̱tsa̱n. A̱vu a̱ ushi aaɗanga o ukere wa̱ yiꞌi, a̱vu a fufaba yi a aaci na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ana a̱ kuna̱i a yuwusaan yi ulamu a̱ tyo o ukosu, a̱vu o foɗo yi aayalaꞌa, reve otowiso yi itana ya̱ yi. A̱vu o uta̱a̱ yi tsa̱ra̱ a̱ ꞌya̱wa̱ uba̱ta̱ u na oo una yi. ");
INSERT INTO tswNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ele a̱ mota̱a̱, a̱vu a gaꞌan na̱ vuma va Kurani, vuma na a̱ tsu ɗe Simo. A̱vu a̱sojaꞌa a zuwa yi u tanu akpataꞌa nu ucira. ");
INSERT INTO tswNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Reve suru nle a̱ ta̱wa̱ uba̱ta̱ u na a̱ tsu ɗe Gologota† (urevu wa̱ yi u ɗa Uba̱ta̱ wo Ookoluwo.) ");
INSERT INTO tswNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","A̱vu a̱sojaꞌa a ca Yesu masayan ma na a̱ ja̱mba̱ra̱i na̱ a̱guma̱ o okono tsa̱ra̱ u sowo. U peɗe yi ta̱ reve u ꞌyuwan o sowo. ");
INSERT INTO tswNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ana a vara niyi a akpataꞌa,† reve a̱soja a yuwan ancaꞌwa ɗaɗa e neꞌeshein itana ya̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Reve a̱sojaꞌa e isawan lo e ipiri ya̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","A ɗana ta̱ ili i na i zuwai a vara niyi akpataꞌa, reve a vara yi zuva va aaci a̱ yi a akpata. Apa ili i na a ɗanai: A̱yi nda, a̱yi ɗa Yesu mogono ma aza a Israꞌila. ");
INSERT INTO tswNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Waru a̱sojaꞌa a vara ta̱ evu e re a akpata, za ta̱ o ukere usaꞌani, za ta̱ gba o ukere ugula̱. ");
INSERT INTO tswNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Aza a na a̱ ka̱ra̱sa̱ lo, reve a lumgbatsasa aci e le a̱vu e isula yi. ");
INSERT INTO tswNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Reve a damma, “Vu damma ta̱ vu ta gura ɓuɓoso A̱a̱ꞌisamapaɗa, a̱vu vu suwisa yi a̱tsuma̱ a rana taꞌatsu. Adama o ndolo wawa aciya̱wu! Na̱ a̱vu Mawun ma̱ A̱sula̱ ma ɗa vu ri na amayun, cipa̱ ɗe a akpataꞌa!” ");
INSERT INTO tswNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ne ɗa waru nan ganu a gbagbain na̱ munlu n Wila̱ n yuwaan niyi ulamu. ");
INSERT INTO tswNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Reve a damma, “U wawa ta̱ ozo o ro, agba u gura wawa aciya̱yi shi! U damma ta̱ a na a̱yi ɗa mogono ma aza a Israꞌila. To, lyawa niyi tse ene u cipa̱ e iɗa diga ɗe a akpataꞌa. Nnu u yuwan ne tsu ta̱ usu yi. ");
INSERT INTO tswNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","U zuwaa ta̱ A̱sula̱ ucira, lyawa A̱sula̱ a wawa yi, nu u ciga. Hali gba u damma ta̱, ‘A̱mu ɗa Mawun ma̱ A̱sula̱.’ ” ");
INSERT INTO tswNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Evu a na a varai a akpata oɓolo na̱ a̱yi e isula yi ta̱ fo. ");
INSERT INTO tswNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ana urana u rawai aci, a̱vu irumbu i ɓa̱ru iɗa ma̱ɓula̱ a̱ tyo rumu taꞌatsu vu ulivu. ");
INSERT INTO tswNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","A mantsa mo ndolo, reve Yesu saala, “Eloi, Eloi, lama sabaktani,” nga, “A̱sula̱ a̱ va̱, A̱sula̱ a̱ va̱, nye i zuwai vu vari numu?” ");
INSERT INTO tswNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ozo o ro a na a̱ da̱na̱i lo mishin uba̱ta̱ꞌa̱, ana a uwwai ne, a̱vu a damma, “Iliya ɗa wee ɗesu!” ");
INSERT INTO tswNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","A̱vu za ro suma u tsupu ashiɗi a̱ mini ma alamu, reve wu nla̱ yi a aaɗanga reve u cayi tsa̱ra̱ u sowo. ");
INSERT INTO tswNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Reve ozo o ro a damma, “Isawain, tse enei ko Iliya ta̱ ta̱wa̱ u wawa yi!” ");
INSERT INTO tswNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","A̱vu Yesu saalisa, ɗaɗa u kuwa̱i. ");
INSERT INTO tswNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","A mantsa mo ndolo, reve A̱sula̱ a zuwa umuna u na u da̱na̱i Upasu wa Akiza a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗa u karalai ure, diga zuva a̱ tyo e iɗa. A̱vu iɗa i ra̱mo, a̱vu atali a ɓatsa. ");
INSERT INTO tswNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Reve ason a̱ kpa̱tuꞌwa̱, a̱vu a̱ ꞌya̱sa̱n ama a̱ a̱ɓula̱ na̱ a̱bunda̱ a na a̱ kuwa̱i ɗe. ");
INSERT INTO tswNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","O uta̱ ta̱ a̱tsuma̱ a ason, waru ana a̱ ꞌya̱sa̱in Yesu a̱tsuma̱ a̱ a̱kwa̱kwa̱, a uwa ta̱ a̱tsuma̱ a̱ lyuci va akiza, Urishelima, uba̱ta̱ u na ama a̱ a̱bunda̱ e ene nle. ");
INSERT INTO tswNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ana yali na̱ a̱soja a na a̱ ri oɓolo na̱ a̱yi a̱ pirishi Yesu e enei cine iɗa i ra̱moi, oɓolo ni ili i na i farai suru, a uwwa ta̱ wovon lon. Ɗaɗa a dammai, “Mawun ma̱ A̱sula̱ ma ɗa u ri mayun!” ");
INSERT INTO tswNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","A̱ma̱ci na̱ a̱bunda̱ a na o uta̱i Ga̱lili a na o toniyi Yesu tsa̱ra̱ a kamba yi, a̱ da̱na̱ ta̱ lo mishin makasu a̱ a̱ka̱nla̱. ");
INSERT INTO tswNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Meri† Magadaliya da̱na̱ ta̱ pe a̱tsuma̱ e le, na̱ Meri mma va Yakubu na̱ Isuhu, na̱ ka va Za̱ba̱di za na a̱yi ɗa mma va Yakubu na̱ Yahaya. ");
INSERT INTO tswNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","A yuwan ta̱ vuma vi ikebe ro na a̱ tsu ɗe Isuhu, vuma lyuci va Arimatiya. Toni va̱ Yesu ɗa. Nu ulivu u ndolo a̱vu u ta̱wa̱ Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A̱vu u ꞌya̱wa̱ uba̱ta̱ wa Bilatu, tsa̱ra̱ u lyawa yi u tara lipu va̱ Yesu. Ɗaɗa Bilatu dammai a̱soja a̱ yi a ca yi. ");
INSERT INTO tswNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ɗaɗa u tarai lipuꞌu, reve u katala yi no okoro. ");
INSERT INTO tswNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","A̱vu u zuwa yi a̱tsuma̱ a aason a saꞌavu za na u ka̱pa̱i a̱tsuma̱ a aatali. Reve u keɓe aatali a gbain tsa̱ra̱ u ula una̱ wa aasoꞌon. Ana u yuwain ne ɗaɗa u ka̱ra̱i. ");
INSERT INTO tswNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","A̱vu Meri Magadaliya na̱ Meri ro a̱ da̱nu lo zuzu na aasoꞌon. ");
INSERT INTO tswNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","O urana we ire, Ashibi, a̱vu nan ganu a gbagbain na Afarishi o ɓoloto uba̱ta̱ wa Bilatu. ");
INSERT INTO tswNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Reve a damma, “Zagbain, tsu cuwan ta̱ ana za ve epen o ndolo da̱na̱i wuma u damma ta̱, ‘Na a yuwan rana taꞌatsu n ta̱ ꞌyon a̱tsuma̱ a̱ a̱kwa̱kwa̱.’ ");
INSERT INTO tswNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","A zuwa ama a̱ piri aason o ndolo ulobonu hali rana taꞌatsu ndolo. Na̱ ne ɗa a yuwain shi, ojoro a̱ yi a̱ ta̱ ta̱wa̱ e iva̱ lipu va̱ yi, reve a damma ama a na A̱sula̱ a̱ ꞌya̱sa̱n yi ta̱ a̱tsuma̱ a̱ a̱kwa̱kwa̱. Epen o gogo a ta laꞌa za vu ufaru uwuyanu.” ");
INSERT INTO tswNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ɗaɗa Bilatu† dammai, “Tarai a̱soja o ro tsa̱ra̱ a̱ ꞌya̱wa̱ a̱ piri aason o ndolo cine yaa gura yuwan ulobonu.” ");
INSERT INTO tswNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Reve a̱ ka̱ra̱ o foɓo aasoꞌon ulobonu lon, waru a̱vu a zuwa eerepu o urotsu† wa gwamna, reve a lyawa lo a̱soja a̱ da̱na̱ e ipiri. ");
INSERT INTO tswNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Na̱ wasasa wa Aladi, reve Meri Magadaliya na̱ Meri ro a̱ ꞌya̱wa̱ tsa̱ra̱ a̱ ka̱lyuwa̱ aasoꞌon. ");
INSERT INTO tswNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","A mantsa mo ndolo, iɗa i ra̱mo ta̱ nu ucira. Reve malingata ma̱ A̱sulazuva ma̱ cipa̱ diga zuva, a̱vu u ꞌya̱wa̱ uba̱ta̱ u na aasoꞌon a̱ ri, a̱vu u gandaluwa aatali a na a ulayi una̱ wa aasoꞌon. Reve u da̱nu zuva va̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","U da̱na̱ ta̱ e ikanasa tsi imaɗatsu, itana ya̱ yi i da̱na̱ ta̱ uꞌuri puwu. ");
INSERT INTO tswNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","A̱soja a na a̱ da̱na̱i e ipiri ya aasoꞌon, reve wovon u reme le lon adama a malingata ma̱ A̱sula̱, a̱vu a uwa mejeꞌen ma̱ lipu, a̱vu a̱ riya̱ e iɗa gashi a̱kwa̱kwa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Reve malingataꞌa ma damma a̱ma̱ciꞌi, “She yu uwwa wovon wan. N reve ta̱ i te izami ya̱ Yesu, za na a varai a akpata. ");
INSERT INTO tswNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wu pa shi. U ꞌyon ta̱ a̱tsuma̱ a̱ a̱kwa̱kwa̱ cine u damma nɗu waa yuwan. Ta̱wa̱i ye ene uba̱ta̱ u na lipu va̱ yi da̱na̱i. ");
INSERT INTO tswNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ꞌYa̱wa̱i i damma ojoro a̱ yi gogogo, ‘Yesu ꞌyon ta̱ a̱tsuma̱ a̱ a̱kwa̱kwa̱. U ta̱ ɗe elime a̱ ɗu a̱ ꞌya̱wa̱ Ga̱lili, i te ene yi ɗe.’ A̱yi ɗa n ta̱wa̱i n damma ɗu.” ");
INSERT INTO tswNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ɗaɗa a̱ma̱ciꞌi a lyawushi aasoꞌon. A̱ da̱na̱ ta̱ a uwwusa wovon, waru a̱ da̱na̱ ta̱ a yuwusan ma̱za̱nga̱ lon fo. A suma ta̱ tsa̱ra̱ a damma ojoroꞌo ili i na i farai. ");
INSERT INTO tswNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Babu usa̱n reve Yesu† cina le, a̱vu u ca̱sa̱ le. Reve a rawa zuzu na̱ a̱yi e reme ana a̱ yi, a̱vu a yuwaan yi a̱ga̱nda̱. ");
INSERT INTO tswNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","A̱vu u damma, “She yu uwwa wovon wan! ꞌYa̱wa̱i i damma ojoro a̱ va̱ a̱ ꞌya̱wa̱ Ga̱lili. A ta cina mu ɗe.” ");
INSERT INTO tswNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ana a̱ma̱ciꞌi a̱ yuwain uka̱ru u le, reve a̱soja a na a̱ da̱na̱i e ipiri ya aasoꞌon a̱ ka̱mba̱ a̱tsuma̱ a̱ lyuci, a̱vu a damma nan ganu a gbagbain ili i na i farai suru. ");
INSERT INTO tswNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Reve nan ganu a gbagbaiꞌin o ɓoloto uba̱ta̱ u ta̱ na azagbain a̱ lyuci a̱vu a yuwan a̱sa̱la̱. Reve a ca a̱sojaꞌa ikebe ya̱ a̱bunda̱, ");
INSERT INTO tswNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","reve a damma le, “Dammai ama a na ojoro e Yesu a̱ ta̱wa̱ ta̱ na ayin, ɗaɗa e iva̱i lipu va̱ yi a̱ɗu pe a̱tsuma̱ a nlavu. ");
INSERT INTO tswNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nna adanshi a nda a rawa a atsuvu a gwamna, tsu ta yuwaan yi adanshi tsa̱ra̱ tsu wawa ɗu a̱tsuma̱ a addama.” ");
INSERT INTO tswNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","A̱vu a̱sojaꞌa a̱ ushi ikebeꞌe, reve a yuwan cine a damma nle a yuwan. Ne ɗa adanshiꞌi a bazai a̱tsuma̱ a Yahuda hali a̱ tyo anaꞌan. ");
INSERT INTO tswNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","A̱vu ojoro kupa na̱ za ta̱ꞌa̱ a̱ ka̱ra̱ a̱ ꞌya̱wa̱ a masasan mo ro a̱tsuma̱ a̱ Ga̱lili uba̱ta̱ u na Yesu damma nle a̱ ꞌya̱wa̱. ");
INSERT INTO tswNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ana a rawa e ene niyi, a̱vu a yuwaan yi a̱ga̱nda̱, agba ozo o ro e le a̱ usu shi. ");
INSERT INTO tswNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ɗaɗa Yesu ta̱wa̱i uba̱ta̱ u le reve u damma, “A̱sula̱ a ca mu ta̱ ucira a̱tsuma̱ a zuva ni iɗa suru. ");
INSERT INTO tswNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ꞌYa̱wa̱i i tsura̱ otoni a̱tsuma̱ o uvaɗi suru. I rumbu le a̱tsuma̱ a ala† a Dada, na ala a Mawun na ala a̱ Ruhu va Akiza.† ");
INSERT INTO tswNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","I rito le a yuwan ili i na n damma nɗu. N ta̱ da̱na̱ oɓolo na̱ a̱ɗu kuci, hali a̱ tyo o ukosu wu uvaɗi.”");
INSERT INTO tswNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Apa nda Alabari a Saꞌani e Yesu† Kristi Zamawawa,† Mawun ma̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","U fara ta̱ ununa A̱sula̱ a dammai ana Ishaya vumava̱sula̱† ɗanai ili i na A̱sula̱ a damma niyi waa fara: “N ta̱ lyungu malingata ma̱ va̱, elime a̱ wu, za na aa lapulaa wu ure. ");
INSERT INTO tswNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Uɗyo wu nanza e ɗewu a̱tsuma̱ o una, ‘Foɓoyi Zagbain ure, yuwain ure wa̱ yi mejege.’ ” ");
INSERT INTO tswNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yahaya† za vu Urumbusu ɗa da̱na̱i malingata ma na ma yuwusain alajiya o una. Alajiya a na u yuwusain adama a na ama aa vadala† o unusu u le a̱ ka̱mba̱ uba̱ta̱ wa̱ A̱sula̱ u ɗa. A̱ ta̱wa̱ ta̱ tsa̱ra̱ u rumbu le tsa̱ra̱ A̱sula̱ a yuwaan le gafura vu nusu le. ");
INSERT INTO tswNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","A̱vu ama e iɗa ya Yahuda suru, hali na ama a̱ Urishelima suru a̱ ta̱wusa̱ uba̱ta̱ wa̱ yi tsa̱ra̱ a uwwa yi. Aza a na a dansaa niyi nusu le, u rumbusu le ta̱ o Uɗolu wa̱ Urdu. ");
INSERT INTO tswNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Wo otosu ta̱ itana ye eleme a arakumi, waru wu nla̱sa̱ ta̱ gbakala vu ukwan. U lyuwusa ta̱ apapari ni ishiki. ");
INSERT INTO tswNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","U da̱na̱ ta̱ a dansaa ama, “Nanza ta̱ lo a̱ ta̱wa̱ a̱ca̱pa̱ a̱ va̱ za na laꞌa numu tsugbain, n rawa n ka̱nza̱ m ba̱ɗa̱ vunu va aatan va̱ yi shi. ");
INSERT INTO tswNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","A̱mu na̱ mini ma ɗa ma̱a̱ rumbusu ɗu, amma a̱yi u ta̱ rumbu ɗu na̱ Ruhu va Akiza.”† ");
INSERT INTO tswNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","A̱vu wo oꞌwo a mantsa mo ndolo Yesu uta̱ ta̱ ɗe Nazara e iɗa ya̱ Ga̱lili. Ana u rawai o Uɗolu wa̱ Urdu, a̱vu Yahaya rumbu yi. ");
INSERT INTO tswNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","A̱yi a̱ mota̱a̱ a̱ miniꞌi, a̱vu we ene zuva† kpa̱tuꞌwa̱, a̱vu Ruhu cipa̱a̱ yi oroci a muɗa. ");
INSERT INTO tswNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","A̱vu a uwwa uɗyo u ro ɗe zuva, u damma, “A̱vu ɗa Mawun ma na n cigai, n ta yuwusan ma̱za̱nga̱ na̱ a̱vu lon.” ");
INSERT INTO tswNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Babu usa̱n, a̱vu Ruhu tara yi a̱ ꞌya̱wa̱ o una. ");
INSERT INTO tswNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","A̱vu u da̱na̱ pe o una rana amunga, Male† a̱ lyungusa̱ yi. U da̱nu ta̱ ni inama yu una, agba waru nlingata ma̱ A̱sula̱ n da̱na̱ ta̱ a kambusa yi. ");
INSERT INTO tswNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ana Hiridu Antiba ɓa̱ruyi Yahaya, a̱vu Yesu uwa pe e iɗa ya̱ Ga̱lili a casu Alabari a Saꞌani a̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","U da̱na̱ ta̱ a dansa, “Mantsa ma yuwan ta̱, tsugono tsa̱ A̱sula̱† tsa yuwan ta̱ zuzu. Vadalai, i usu Alabari a Saꞌani.” ");
INSERT INTO tswNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","A̱yi a mmalu a̱ ngeꞌen m Mala ma̱ Ga̱lili, a̱vu we ene Simo na̱ Andarawu mawun ma̱ a̱na̱wu ma̱ yi a̱za̱ e mereme ma mugula, a varishi igolo a malaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","A̱vu u damma le, “Toni numu, n ta̱ ka̱mba̱to ɗu aza a na a̱ ta̱wa̱a̱ na ama.” ");
INSERT INTO tswNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","A̱vu a lyawushi igolo i le, a̱vu o toni yi. ");
INSERT INTO tswNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ana u lyuwai elime na̱ mmalu waꞌa, a̱vu we ene muwun ma̱ Za̱ba̱di, Yakubu na̱ vawun va̱ yi Yahaya, ele pe a wantsun a lapulusa igolo i le. ");
INSERT INTO tswNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","A̱vu u ɗeshi nle, a̱vu a lyawa Za̱ba̱di dada le a wantsuꞌun na aza a zamalinga. A̱vu o toni yi. ");
INSERT INTO tswNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","A̱vu Yesu no ojoro a̱ yi a uwa pe a̱ lyuci va Kafarnahum. O urana wa Ashibi a̱vu u uwa a̱ a̱a̱ꞌisa̱,† u reme uritosu. ");
INSERT INTO tswNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","A̱vu o oꞌwo asalama lon na̱ cuꞌun vu uritosu wa̱ yi, adama a na u to ritosu le ununa vuma na ri nu ucira, agba tsu munlu n Wila̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pe a̱ a̱a̱ꞌisa̱ꞌa̱ za na ri no otoni a̱ lima̱ shi ta̱ pe reve u remushi yisaali, ");
INSERT INTO tswNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","a dansa, “Yesu za va Nazara, te imini tsu na̱ a̱vu? A̱vu vu ta̱wa̱ ta̱ vu una tsu? Tsu reve ta̱ ko zane ɗa vu ri, a̱vu ɗa za va akiza a̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","A̱vu u damma le nu ucira, “Rungwa̱i, a̱vu yu uta̱ i lyawa yi!” ");
INSERT INTO tswNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","A̱vu otoni a̱ lima̱ꞌa̱ a̱ jinga̱ɗa̱ vumaꞌa lipu e mejeꞌen, a̱vu u saala, ɗaɗa a kasai na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ama suru a yuwan ta̱ asalama a̱bunda̱, hali e ecelei aciyele, “Nye ɗa tsunda? Uritosu u saꞌavu u ɗa ndaꞌa. U ta̱ nu ucira lon. Hali no otoni a̱ lima̱ a ɗa u tsu ɓarasa le babu wovon, a̱vu a yuwan ili i na u damma nle a yuwan.” ");
INSERT INTO tswNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Babu usa̱n alabari a̱ yi a rawai ko te ɗa ejege e iɗa ya̱ Ga̱lili. ");
INSERT INTO tswNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mota̱a̱ ma̱ yi a̱ a̱a̱ꞌisa̱ oɓolo no ojoro a̱ yi oɓolo na̱ Yakubu na̱ Yahaya, a̱vu a uwa o uꞌwa wa̱ Simo na̱ Andarawu. ");
INSERT INTO tswNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","A̱na̱wa̱le Simo a̱ da̱na̱ ta̱ ubanakun, a̱vu a damma Yesu adama a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","A̱vu u ꞌya̱wa̱ ya̱ꞌa̱ yi, u reme yi ukere, a̱vu u kamba ꞌya̱sa̱n yi, ɗaɗa ubanakuꞌun u lyawushi niyi. Reve u yuwaan le a̱ga̱nda̱. ");
INSERT INTO tswNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ana ulivu u yuwain, a̱vu a̱ ta̱wa̱a̱ yi na ama a̱bunda̱, aza a na a̱ ri nu ubanakun, na aza a na a̱ ri no otoni a̱ lima̱. ");
INSERT INTO tswNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","A̱vu ama a̱ lyuciꞌi o ɓoloto o una̱ntsu wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","U ka̱mba̱to ta̱ aza a na a̱ da̱na̱i nu ubanakun icuꞌun icuꞌun gbaga, a̱vu waru u lo otoni a̱ lima̱ na̱ a̱bunda̱. U lyawa le a yuwan adanshi shi, adama a na e reve niyi. ");
INSERT INTO tswNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Uba̱ta̱ haɓa, a̱vu u ꞌyon wu uta̱ u ꞌya̱wa̱ uba̱ta̱ u na vuma ri shi. U ꞌya̱wa̱ u yuwan ɗe avasa. ");
INSERT INTO tswNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","A̱vu Simo na aza a na a̱ ri na̱ a̱yi a zami yi. ");
INSERT INTO tswNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ana e ene niyi, a̱vu a damma yi, “Ama suru a̱ te izami ya̱ wu.” ");
INSERT INTO tswNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","A̱vu u damma le, “Tsu walai a̱ ꞌya̱wa̱ a̱ mulyuci n na n ri elime, tsu yuwain alajiya. Ili i na n ta̱wa̱i n yuwan ɗa ndolo.” ");
INSERT INTO tswNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","She na u kotoi maꞌuwa ma̱ a̱ꞌisa̱ e iɗa ya̱ Ga̱lili suru a yuwusan alajiya, waru o utusa̱a̱ ama otoni a̱ lima̱. ");
INSERT INTO tswNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","A̱vu ma̱kutu ma̱ ta̱wa̱ u kingyowa̱ yi, a̱vu u pati yi, “Na̱ vu usu, vu ka̱mba̱to mu gbaga.” ");
INSERT INTO tswNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","A̱vu Yesu ene yi iliyali, a̱vu u ꞌya̱sa̱n ukere wa̱ yi, a̱vu u juꞌwa̱n yi, u damma, “N usu ta̱, ka̱mba̱ gbaga.” ");
INSERT INTO tswNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","A̱vu ukutuꞌu u lyawushi niyi, a̱vu u tsura̱ lafiya va̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","A̱vu u rono yi atsuvu u damma, “She vu damma vuma wan. A̱vu vu wala vu ꞌya̱wa̱ vu roco aciya̱wu uba̱ta̱ wa ganu. A̱vu vu ca ili i ro, ununa a yuwusain a mantsa ma Musa, adama a̱ da̱na̱ nu urevu wi ili i na i farai.” A̱vu u damma yi u ka̱ra̱. ");
INSERT INTO tswNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ana wu uta̱i, u yuwan ne shi, a̱vu u teme a bazasa alabariꞌi. A̱vu ama na̱ a̱bunda̱ a uwwa, hali uba̱ta̱ u na a zuwai Yesu kuɗa̱i a uwa a̱ lyuciꞌi. A̱vu wi isawan ɗe alanga na̱ lyuci uba̱ta̱ u na ama a̱ ri shi. A̱vu ama ko te ɗa a̱ ka̱ra̱ a̱ ta̱wusa̱ ya̱ꞌa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ana a yuwain rana meketeci, a̱vu Yesu ka̱mbisa̱ Kafarnahum. A̱vu alabari a̱ yi a rawa a atsuvu a ama, na adanshi nga u ta̱wa̱ ta̱ o uꞌwa. ");
INSERT INTO tswNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","A̱vu ama a̱ a̱bunda̱ o ɓoloto uba̱ta̱ u ta̱, a̱vu uba̱ta̱ꞌa̱ u ka̱la̱ma̱ le, ko lo o una̱ntsu babu ure, ɗaɗa u da̱na̱i o rocosu ama Adanshi a̱ A̱sula̱.† ");
INSERT INTO tswNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","A̱vu a̱ ta̱wa̱a̱ yi na̱ vuma na ri no osowi a̱ lipu a na ama a̱ na̱shi e sheɗei. ");
INSERT INTO tswNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Adama o oɓolo a amaꞌa, a gura rawa uba̱ta̱ u na Yesu ri shi, a̱vu a̱ ka̱tsuꞌwa̱ ukwa̱ꞌa̱. Ana a̱ tsura̱i ure, a̱vu a̱ telyuwetyo yi a̱ tyo e iɗa a aavalu a na u da̱na̱i. ");
INSERT INTO tswNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ana we enei ununa a ca niyi okolo, a̱vu u damma za vo osowi a̱ lipuꞌu, “Mawun ma̱ va̱, a yuwaan wu ta̱ gafura vu unusu wa̱ wu.” ");
INSERT INTO tswNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Amma munlu n Wila̱† n ro n da̱na̱ ta̱ lo nden, a̱vu a yuwan majiyan, ");
INSERT INTO tswNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nye i zuwai vuma nda yuwain adanshi tsundolo? U tara ta̱ aciya̱yi una̱ta̱ na̱ A̱sula̱.† Zane ɗa aa gura yuwaan vuma gafura vu unusu, she A̱sula̱ goon shi?” ");
INSERT INTO tswNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Agba u reve ta̱ okolo e le, ɗaɗa we ece nle, “Nye i zuwai yaa yuwusan majiyan ne? ");
INSERT INTO tswNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Zane ɗa laꞌai babu usa̱n: a damma za vo osowi a̱ lipuꞌu, ‘A yuwaan wu ta̱ gafura wu unusu wa̱ wu,’ ko a damma, ‘ꞌYon, vu tara aavalu a̱ wu, a̱vu vu wala’? ");
INSERT INTO tswNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Amma adama n roco ɗu Mawun ma Vuma† ma̱ ta̱ nu ucira o uvaɗi nda u yuwaan ama gafura vu unusu u le,” a̱vu u ka̱lyuwa̱ yi u damma, ");
INSERT INTO tswNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“N damma wu ta̱, ꞌyon, tara aavalu a̱ wu, vu wala a̱ tyo o uꞌwa.” ");
INSERT INTO tswNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","A̱vu u ꞌyon u tara aavalu a̱ yi babu usa̱n. Reve u ka̱ra̱ a̱ ma̱ka̱ka̱n me le suru. A̱vu amaꞌa suru a̱ ka̱ra̱ a yuwusan asalama. A̱vu a ciɓala A̱sula̱ a̱ uri a dansa koto ele e ene cuꞌun vi ili i nda shi. ");
INSERT INTO tswNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","A̱vu Yesu utisa̱ a̱ ꞌya̱wa̱ a̱ ngeꞌen m mala, a̱vu oɓolo a ama o toni yi, ɗaɗa u da̱na̱i o rocosu le. ");
INSERT INTO tswNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","A̱yi a̱ ka̱ra̱, a̱vu we ene Levi, mawun ma Alfa nden uba̱ta̱ u na a̱a̱ ushishi utafa, a̱vu u damma yi, “Toni mu.” A̱vu u ꞌyon u toni yi. ");
INSERT INTO tswNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mantsa mo ro a̱vu u da̱nu a lyuwusa ilyalya o uꞌwa wa̱ Levi na aza a na a̱a̱ ushishi utafa na̱ a̱bunda̱ na̱ a̱za̱ o unusu a na a̱ da̱na̱i lo nden oɓolo na̱ Yesu no ojoro a̱ yi, adama a na icuꞌun ya ama o ndolo o toni yi ta̱. ");
INSERT INTO tswNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","A̱vu ana munlu n Wila̱ na Afarishi e ene niyi a alya e ilyalya na̱ a̱za̱ o unusu na̱ a̱za̱ o ushishi wu utafa, a̱vu a damma ojoro a̱ yi, “Cine waa lyuwusa woo sowuso ni icuꞌun ya ama o ndolo?” ");
INSERT INTO tswNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ana wu uwwai ne, a̱vu u damma le, “Aza a na a̱ ri nu ubanakun shi, a ciga za va̱ a̱guma̱ shi, she a̱za̱ o ubanakun. N ta̱wa̱ n ɗe a̱za̱ a̱ a̱ɓula̱ shi, amma aza a na a̱ ri nu unusu.” ");
INSERT INTO tswNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yashi i ndolo ojoro a Yahaya oɓolo na Afarishi a̱ da̱na̱ ta̱ na akuli, a̱vu a̱ ta̱wa̱ ya̱ Yesu a damma, “Nye i zuwai ojoro a Yahaya no ojoro a Afarishi aa yuwusan akuli, amma ojoro a̱ wu aa yuwusan shi?” ");
INSERT INTO tswNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","A̱vu u usu le, “Cine omocin a vali vu kasaꞌavu aa yuwan akuli a̱yi oɓolo ne ele? Aa yuwan shi, nu u ri lo oɓolo ne ele. ");
INSERT INTO tswNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Amma mantsa mo ta̱ lo a̱ ta̱wa̱ ana aa tara yi pe uba̱ta̱ u le. O urana u ndolo, a ta yuwan akuli. ");
INSERT INTO tswNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Babu za na a̱ zula̱ apaɗi o umuna u saꞌavu a akuci o utugu. Nu u ɓolo le, apaɗi o umuna u saꞌavuꞌu u ta̱ vura̱nu akuci o utuguꞌu, a̱vu ukaruꞌu u da̱shi mgbain. ");
INSERT INTO tswNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Babu za na tsu tsun ribina na kutsai a akuci a̱ tsa̱n o ukwan adama a na ribinaꞌa u to ɓoso tsa̱n vu ukwaꞌan, na̱ a̱ tsun yi pe u ta̱ lungusa̱ ribinaꞌa oɓolo na̱ tsa̱ꞌa̱n. Amma a̱ tsu tsun ta̱ ribina a̱ tsa̱n saꞌavu.” ");
INSERT INTO tswNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","O urana wa Ashibi† u ro, Yesu da̱na̱ ta̱ a mmalu a ɓatsasa a̱ a̱ɗuma̱ e ishina, a̱vu ojoro a̱ yi e teme makuɗa ma̱ a̱ga̱za̱ me ishina ele pe a mmalu. ");
INSERT INTO tswNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","A̱vu Afarishi† a damma yi, “Ka̱lyuwa̱, anaꞌan urana wa Ashibi u ɗa. Nye i ɗa i zuwai ojoro a̱ wu a kuɗusa a̱ga̱za̱ e ishina a yuwusan ili i na Wila̱ u putsayi?” ");
INSERT INTO tswNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","A̱vu u usu le, “I reve ili i na Da̱wuda na aza a na a̱ da̱na̱i na̱ a̱yi a yuwain mantsa ma na a uwwai ambulu shi? ");
INSERT INTO tswNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","A rana na Abiyata da̱na̱i aabara a nan ganu, Da̱wuda uwa ta̱ o uꞌwa wa̱ A̱sula̱, a̱vu u tama opopofu za na ganu ɗa goon aa tama. A̱vu fo u ca nꞌutsa̱ ma̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","A̱vu u damma le, “A yuwan ta̱ Ashibi adama a vuma, amma a yuwan vuma adama a Ashibi shi. ");
INSERT INTO tswNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Adama o ndolo, a̱mu Mawun ma Vuma, Zagbain vu urana wa Ashibi a ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Urana u ro a̱vu Yesu uwisa a̱ a̱a̱ꞌisa̱, a̱vu u cina pe vuma na ri nu ukere u ta̱ usowu. ");
INSERT INTO tswNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Urana wa Ashibi u ɗa u da̱na̱i, a̱vu Afarishi a̱ ka̱lyuwusa̱ yi ko e te ene ko u ta̱ ka̱mba̱to za vu ubanakun gbaga, adama e reme yi nu unusu. ");
INSERT INTO tswNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","A̱vu u damma yi, “Uta̱ vu ta̱wa̱ a alanga eteshe.” ");
INSERT INTO tswNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","A̱vu we ece le, “Nye i ɗa Wila̱ u dammai wu ntsayi a yuwan urana wa Ashibi, a yuwan isaꞌani ko iwuya, a wawa wuma ko o una?” Agba a damma ili i ro shi. ");
INSERT INTO tswNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","A̱vu u ka̱lyuwa̱ le nu upan, a̱vu waru we ene le iliyali adama a na a̱ ta̱ na aciyogbamu. A̱vu u damma vumaꞌa, “Canana ukere wa̱ wu.” Ana u cananai, a̱vu u ka̱mba̱ gbaga. ");
INSERT INTO tswNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","A̱vu Afarishi o uta̱ na ama a̱ Hiridu, a̱vu a yuwan a̱sa̱la̱ cine aa yuwan oo una yi. ");
INSERT INTO tswNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","A̱vu Yesu no ojoro a̱ yi a̱ ka̱ra̱ a̱ ꞌya̱wa̱ a̱ ngeꞌen m Mala ma̱ Ga̱lili. Ana ama a uwwai ili i na u da̱na̱i a yuwusan, a̱vu oɓolo a ama a̱ a̱bunda̱ o toni yi. Amaꞌa o uta̱ ta̱ ɗe Yahuda, na̱ Urishelima, na̱ Idumiya. Ozo o ro waru o uta̱ ta̱ upasalai wu Uɗolu wa̱ Urdu, na aza a na a̱ ta̱wa̱i uba̱ta̱ wa̱ yi ɗe e iɗa ya Taya na̱ Sida. ");
INSERT INTO tswNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","U damma ta̱ ojoro a̱ yi a lapulaa yi wantsun u waꞌa, adama a na oɓolo a ama a yuwan ta̱ a̱bunda̱, tsa̱ra̱ a gbagbala yi wan. ");
INSERT INTO tswNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","A̱za̱ o ubanakun na̱ a̱bunda̱, a̱ ka̱mba̱to le ta̱ gbaga, hali wo oꞌwo aza a na a̱ ri nu ubanakun e keɓushe adama a̱ juꞌwa̱n yi. ");
INSERT INTO tswNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Uba̱ta̱ u na otoni a̱ lima̱ e ene niyi suru, a̱vu a̱ kingyo e reme yisaali, adansa, “A̱vu ɗa Mawun ma̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Amma u ɓara le ta̱ she a damma ama ko zane ɗa u ri wan. ");
INSERT INTO tswNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","A̱vu Yesu ka̱ra̱ a̱ ꞌya̱wa̱ a masasan uba̱ta̱ u na u ɗeyi ama a na a̱ ꞌya̱wa̱ oɓolo na̱ a̱yi, a̱vu a̱ ꞌya̱wa̱ uba̱ta̱ wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","A̱tsuma̱ e le a̱vu u ɗangwa ama kupa ne ejere aza a na u cayi ala ajiya. A̱vu u damma le, “N ɗangwa ɗu ta̱ i da̱nu na̱ a̱mu. N ta̱ lyungu ɗu i ꞌya̱wa̱ i damma Alabari a Saꞌani a̱ va̱. ");
INSERT INTO tswNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Waru i ta̱ tsura̱ ucira i lo otoni a̱ lima̱.” ");
INSERT INTO tswNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mpa nda Kupanejere† a na u zagwai: Simo za na u cayi aala Bituru, ");
INSERT INTO tswNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakubu mawun ma̱ Za̱ba̱di fo u ɗe yi ta̱, na̱ Yahaya vawun va̱ yi, aza a na u cayi ala Buwanaji, ana muwun n tsata; ");
INSERT INTO tswNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","u ɗe ta̱ fo Andarawu, ne ɗa fo Filibu, na̱ Batalamawu waru, Matta fo ta̱ pe, Toma fo aajiya a ɗa a̱ da̱na̱i. Akapi e le ele ɗa Yakubu mawun ma Alfa, na̱ Tadawu, oɓolo na̱ Simo za na waru a̱ tsu ɗe Bakanani, ");
INSERT INTO tswNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na̱ Yahuza Iskariyoti, za na wina niyi. ");
INSERT INTO tswNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","A̱vu urana u ro Yesu uwisa o uꞌwa, a̱vu oɓolo a ama o ɓolo waru, hali a putsa yi no ojoro a̱ yi na aa lyuwa ilyalya. ");
INSERT INTO tswNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ana a̱za̱ a̱ yi a uwwai ne, a̱vu o uta̱ ɗe adama e reme yi, a jiyan ta̱ u jaara ta̱. ");
INSERT INTO tswNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Munlu n Wila̱ na aza a na a̱ ta̱wa̱i ɗe Urishelima a̱ ka̱ra̱ ta̱ a dansa, “U ta̱ na̱ Baꞌalzabu† mogono mo otoni a̱ lima̱, waru nu ucira wa̱ yi u ɗa woo uta̱sa̱a̱ otoni a̱ lima̱ꞌa̱.” ");
INSERT INTO tswNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","A̱vu u ɗe le, u yuwaan le adanshi ni iroci u damma le, “Cine Male moo lo Male? ");
INSERT INTO tswNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ni iɗa i neꞌeshen aciya̱yi ure a yuwusan nla̱ngi na aciyele, iɗa i ndolo i ta̱ riya̱. ");
INSERT INTO tswNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nu u uꞌwa u neꞌeshen ure, a yuwusan tsurala, uꞌwa u ndolo wee isawan shi. ");
INSERT INTO tswNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Adama o ndolo na̱ tsugono tsa Male tse neꞌeshen waa jima shi, amma u ta̱ riya̱. ");
INSERT INTO tswNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Babu za na aa gura uwa o uꞌwa wu za vu ucira u tara itana ya̱ yi, she na̱ wu nla̱ yi. A̱vu u gura uwa o uꞌwa wa̱ yi u tara yi itana. ");
INSERT INTO tswNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Amayun a ɗa maa dansaa ɗu, a ta gura yuwaan ama gafura vu nusu le na adanshi a vama e ekere a̱ A̱sula̱.† ");
INSERT INTO tswNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Amma za na yuwayin Ruhu va Akiza adanshi a vama, aa yuwaan yi gafura shi, adama a na unusu wa̱ yi u ri nu ukotu shi.” ");
INSERT INTO tswNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","U damma le ta̱ ne, adama a na a damma ta̱, “U ta̱ no otoni a̱ lima̱.” ");
INSERT INTO tswNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","A̱vu mma va̱ Yesu rawa na̱ a̱za̱ a̱ yi. A̱vu a̱ lyungu za ro ɗe yi. A̱vu e isawan a alanga. ");
INSERT INTO tswNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A cina ta̱ oɓolo a ama nden uka̱nda̱ruwu na̱ a̱yi, a̱vu a damma yi, “Mma va̱ wu, na̱ a̱za̱ a̱ wu, a̱ ta̱ ɗe a alanga a pura wu.” ");
INSERT INTO tswNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","A̱vu u usu le, “Zane ɗa mma va̱ na̱ a̱za̱ a̱ va̱?” ");
INSERT INTO tswNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","A̱vu u ka̱lyuwa̱ ama a na a̱ ri nden uka̱nda̱ruwu na̱ a̱yi, a̱vu u damma, “Ka̱lyuwa̱i, ele nda ele ɗa mma va̱ na̱ a̱za̱ a̱ va̱. ");
INSERT INTO tswNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aza a na a yuwusan ili i na A̱sula̱ a cigai, ele ɗa muwun ma̱ a̱na̱wu n va̱ olobo ne esheli na̱ mma va̱.” ");
INSERT INTO tswNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yashi i ro waru a̱vu Yesu teme uritosu a̱ ngeꞌen m mala. Oɓolo a ama a na o ɓolotoi a̱ da̱na̱ ta̱ a̱bunda̱ lon, hali a zuwa yi u uwa a wantsun, a̱vu u da̱nu pe. Ama ɗe a aagaɗi a̱ ka̱lyuwusa̱ malaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","A̱vu u roco le ili na̱ a̱bunda̱ aa yuwusan iroci. A̱tsuma̱ o uritosu wa̱ yi, a̱vu u damma le, ");
INSERT INTO tswNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Poloi atsuvu, yu uwwa, cimbi ro ꞌya̱wa̱ ta̱ mazaza me icuꞌun. ");
INSERT INTO tswNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","A̱yi lo a mantsa ma na u temei mazaza me icuꞌun, a̱vu icuꞌun i ro yo oco yi o ure, a̱vu nnunu n ta̱wa̱ n ka̱ka̱ɗa̱ icuꞌuꞌun. ");
INSERT INTO tswNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","A̱vu ozo o ro o oco ba̱ta̱ a atali, uba̱ta̱ u na u ri na̱ ma̱bula̱ lon shi. A̱vu o uta̱ babu usa̱n, adama a na a̱ tsura̱i wa̱cin a̱lungu shi. ");
INSERT INTO tswNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ana urana u yuwain, a̱vu a kpanla, adama a na a̱ ri na̱ ma̱bula̱ lon shi, a̱ tsura̱ aralu shi, a̱vu e ꞌyewe. ");
INSERT INTO tswNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","A̱vu ozo o ro waru o oco a awanda, a̱vu awanda a̱ ꞌyon, a̱vu a gbagbala le, a matsan ulobonu shi. ");
INSERT INTO tswNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ozo o ro gba shi o oco a̱ ma̱bula̱ ma saꞌani, a̱vu a matsan ulobonu, ozo o ro a matsan mataꞌatsu mataꞌatsu, ozo o ro kupota̱li-uta̱li, ozo o ro ukpaku ukpaku.” ");
INSERT INTO tswNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","A̱vu u damma le, “Za na ri na atsuvu, wu uwwa.” ");
INSERT INTO tswNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mantsa ma na Yesu da̱na̱i a̱ ndeꞌen, aza a na a̱ da̱na̱i lo oɓolo na̱ Kupanejere, a̱vu ee ece yi iroci i na u yuwaan nle. ");
INSERT INTO tswNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","A̱vu u damma le, “A̱ɗu ɗa a lyawai i reve ili yu usokowu ya̱ A̱sula̱, amma aza a na a̱ ri pe shi, ili suru she ni iroci i ɗa a tsu damma le. Adama a na ");
INSERT INTO tswNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘A ta gura e ene ne esu, amma ee reve no okolo shi. A mawwa, a ta gura uwwa, amma aa gura reve shi. Adama a na a̱a̱ ka̱mba̱ a yuwaan le gafura wan.’ ” ");
INSERT INTO tswNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","A̱vu u damma le, “A̱ɗu i reve iroci i nda shi? To, cine yaa gura i reve iroci i ro? ");
INSERT INTO tswNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Za vu ca̱ꞌa̱n ndolo adanshi a̱ A̱sula̱ ɗa wa̱a̱ cuꞌusa̱n. ");
INSERT INTO tswNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Icuꞌun i na yo ocoi o ure, ele ɗa iroci ya aza a na a̱ cuꞌwa̱in adanshi a̱ A̱sula̱ o okolo e le. Mantsa ma na a uwwai, babu usa̱n, Male† ma̱ ta̱wa̱ ma usa adanshi a na a̱ cuꞌwa̱in o okolo e leꞌe. ");
INSERT INTO tswNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ne ɗa waru aza a na o ocoi ba̱ta̱ a atali. Ele ɗa aza a na a̱ tsu ushi adanshi babu usa̱n na̱ ma̱za̱nga̱. ");
INSERT INTO tswNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Amma ana a̱ ri na aralu shi, a tsu jima shi. Na awuya ko a̱tsuma̱lima̱ a̱ ta̱wa̱ adama a adanshi a̱ A̱sula̱, babu usa̱n a̱a̱ ta̱ɗa̱tsa̱. ");
INSERT INTO tswNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ozo o ro a̱ ta̱ tsi icuꞌun i na yo ocoi ba̱ta̱ a awanda. A uwwa ta̱ adanshi, ");
INSERT INTO tswNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","amma addama o uvaɗi u nda, nu uyoꞌo wi ikebe, na maluwa me ili ma na aa uwwusa, a tsu gbagbala ta̱ adanshiꞌi. Reve wo oꞌwo le babu ulinga. ");
INSERT INTO tswNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Amma aza a na o ocoi a̱ ma̱bula̱ ma saꞌani, ele ɗa aza a na a tsu uwwa adanshi, a̱ usu yi, a̱vu a yuwan ulinga na̱ a̱yi. Za ro tsu matsan ta̱ mataꞌatsu mataꞌatsu, za ro kupota̱li-uta̱li, za ro gba ukpaku ukpaku.” ");
INSERT INTO tswNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","A̱vu Yesu ece le, “A̱ tsu ta̱wa̱a̱ ta̱ na̱ fitila adama a na a̱a̱ kpa̱to yi na aasaꞌatsu, ko a zuwa yi a̱ mbungulu? E eelele a ɗa a tsu zuwa yi, adama u ca ekan shi? ");
INSERT INTO tswNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ili i na i ri usokowu suru a̱ ta̱ kpa̱tuꞌwa̱ yi, waru babu ili i na ya̱a̱ da̱na̱ upaꞌun u na o uta̱a̱ yi a alanga shi. ");
INSERT INTO tswNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Za na ri na atsuvu, wu uwwa.” ");
INSERT INTO tswNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","A̱vu u damma le, “I yuwan ugbozu ni ili i na yaa uwwusa. Na̱ makundatsu ma na i kunzuyi na̱ a̱yi ɗa a̱a̱ kunzuwa̱ ɗu, waru a̱ ta̱ da̱shi ɗu. ");
INSERT INTO tswNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Za na ri ni ili, a̱yi ɗa a̱a̱ da̱shi, waru za na ri ni ili shi, waꞌa na u ri na̱ a̱yi a̱ ta̱ ushi yi i ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","A̱vu Yesu damma le, “Apa nda cine tsugono tsa̱ A̱sula̱ tsa̱ ri: tsa vuma na ꞌya̱wa̱i mazaza me icuꞌun. ");
INSERT INTO tswNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nu u lantsa na ayin ko u yuwan ulinga nu urana, mantsa suru icuꞌun oo utusa̱ a yuwusan mgbain, ko na wo oꞌwoi u reve cine aa yuwusan mgbain shi. ");
INSERT INTO tswNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Iɗa i tsu zuwa ta̱ ili i na a̱ cuꞌwa̱in i ꞌyon mgbain, akunku a ɗa a tsu fara kungwa, a̱vu a̱ ta̱wa̱ a yuwan a̱ga̱za̱ a ca icuꞌun i saꞌani. ");
INSERT INTO tswNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mantsa ma na ishina i kutsai, a̱vu u gasa le.” ");
INSERT INTO tswNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","A̱vu Yesu reme a dansa, “Na̱ nye tsaa gura kurato tsugono tsa̱ A̱sula̱? Ko ni iroci yi ili i ne a gura cuɗuwa yi? ");
INSERT INTO tswNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Oroci e isuꞌwan i uri, a̱yi ɗa cuꞌun na laꞌai uka̱la̱mu na a̱ tsu cuꞌwa̱n e iɗa. ");
INSERT INTO tswNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ko tsundolo, na̱ a̱ cuꞌwa̱n yi, nu u yuwan mgbain, u tsu laꞌa ta̱ olopu a na a buwai, u tsu yuwan ta̱ eten a gbagbain na nnunu n tsu ta̱wa̱ n tele ɗe.” ");
INSERT INTO tswNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iroci ya̱ a̱bunda̱ oroci o ndolo a ɗa u yuwaan le adanshi a̱ A̱sula̱, ununa aa gura reve. ");
INSERT INTO tswNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","U damma le ili i ro shi, she oɓolo ni iroci, amma a̱ mɓa̱nga̱, a̱vu u cuɗuwa ojoro a̱ yi ili i na u dansaa nle suru. ");
INSERT INTO tswNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","36","O urana u ndolo nu ulivu, Yesu no ojoro a̱ yi shi ta̱ a wantsun a̱ ngeꞌen m Mala ma̱ Ga̱lili. Reve u damma le, “Ta̱wa̱i tsu ꞌya̱wa̱i ne upasu u ndeɗe.” A̱vu antsun o ro o toni yi. Reve Yesu ka̱ra̱ a̱ tyo o ukosu u wantsun reve u reme nlavu. U da̱na̱ ta̱ ni ili i na u zuwai aaci. ");
INSERT INTO tswNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","A jima lon shi, a̱vu upepu u keɓe ɗe a̱ ta̱wa̱. A̱vu upepuꞌu u yuwusan mini ikeɗu ikeɗu, hali wantsuꞌun u ciga u shiwan na̱ mini. A̱vu ojoro a̱ yi a uwwa wovon lon, reve a̱ ꞌya̱wa̱ a jisan yi. Reve a damma, “Manlu, u ɓa̱la̱ wu a na tsaa liɓa shi?” ");
INSERT INTO tswNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","A̱vu u ꞌyon, u ɓara upepuꞌu, u damma malaꞌa, “Von ne.” A̱vu upepuꞌu u von uba̱ta̱ wo oꞌwo kwin. ");
INSERT INTO tswNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","A̱vu u damma le, “Nye i zuwai yi daꞌwain tsunda, hali n gogo koto i ca mu okolo a̱ ɗu shi?” ");
INSERT INTO tswNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","A̱vu wovon u tsura̱ le lon, a̱vu a dammulai, “Cuꞌun vuma ne ɗa tsundaꞌa, hali nu upepu fo u tsu yuwan ta̱ ili i na u dammai?” ");
INSERT INTO tswNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","A̱vu Yesu no ojoro a̱ yi a pasa a̱ ꞌya̱wa̱ upasu u mala u ndeɗe, ejege a̱ lyuci na a̱ tsu ɗe Garasa. ");
INSERT INTO tswNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","A̱yi a̱ mota̱a̱ pe a̱tsuma̱ a wantsuꞌun, a̱vu vuma za na ri no otoni a̱ lima̱ u gaꞌashin na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ason a ɗa ba̱ta̱ a̱ nden ma̱ yi. Babu za na ri nu ucira u na waa gura nla̱ yi, ko na akani. ");
INSERT INTO tswNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","A̱ tsu nla̱ yi ta̱ ana ne ekere na akani, amma u tsu kakasa le ta̱. Babu za na ri nu ucira u na waa gura goloɓo yi. ");
INSERT INTO tswNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Usana nu ulivu u tsu da̱na̱ ta̱ a agaɗi a̱tsuma̱ a ason a na a yuwain a atali. Reve u da̱na̱ a yisaali, na̱ wu paɗi aciya̱yi. ");
INSERT INTO tswNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ana u cinkayai Yesu alanga, a̱vu u suma ni ilaɗi a̱ ta̱wa̱, a̱vu u kingyo a̱ ma̱ka̱ka̱n ma̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","A̱vu Yesu damma otoni a̱ lima̱ꞌa̱, “Lyawa vuma ndolo.” Ɗaɗa u ɓoshoi na̱ yisaali a dansa, “Te ɗa imini ya̱ wu na̱ a̱mu, Yesu Mawun ma̱ A̱sula̱? Kucina na̱ A̱sula̱, vaa ca mu a̱tsuma̱lima̱ shi.” ");
INSERT INTO tswNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","A̱vu we ece yi, “Cine tsa ɗa aala a̱ wu?” A̱vu u usu, “Aala a̱ va̱ a ɗa Oɓolo adama a na tsu ta̱ a̱bunda̱.” ");
INSERT INTO tswNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","A̱vu u pati Yesu lon adama u lyawa le e iɗaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Uba̱ta̱ u na a̱ da̱na̱i, ngurusumu n da̱na̱ ta̱ lo na̱ a̱bunda̱, a zamishi ilyalya za̱la̱ va agaɗi. ");
INSERT INTO tswNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","A̱vu otoni a̱ lima̱ꞌa̱ a pati yi, a damma, “Gba̱ra̱ tsu a̱ ꞌya̱wa̱ a̱tsuma̱ a̱ ngurusumu, adama tsu uwa pe a̱tsuma̱ e le.” ");
INSERT INTO tswNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","A̱vu gba u usu le. A̱vu otoni a̱ lima̱ o uta̱ a uwa a̱tsuma̱ a̱ ngurusumu. Aza a̱ da̱na̱i lo suru, a̱vu a suma a̱ ꞌya̱wa̱ a mala. A̱vu a̱ riya̱ pe, a̱vu a̱ kuwa̱ pe. A̱bunda̱ e le a ta rawa ukpakukupa ure (2,000). ");
INSERT INTO tswNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Reve aza a na a̱ da̱na̱i a aguɓa a̱ ngurusumuꞌu, a̱vu a suma, a̱vu a̱ ꞌya̱wa̱ a ca alabari a̱ lyuci na̱ mulyuci. A̱vu ama a̱ ta̱wa̱ e ene ili i na i farai. ");
INSERT INTO tswNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ana a̱ ta̱wa̱i uba̱ta̱ wa̱ Yesu, a̱vu a cina lo vuma na da̱na̱i no otoni a̱ lima̱ nden uba̱ta̱ wa̱ yi, uꞌotowu ni itana nu ugbozu wa̱ yi. Reve a uwwa wovon. ");
INSERT INTO tswNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Aza a na e enei ne esu e le, a̱vu a damma ili i na i cinai za vo otoni a̱ lima̱ꞌa̱ na̱ ngurusumu. ");
INSERT INTO tswNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","A̱vu e teme a patishi Yesu u lyawaa le iɗa i le. ");
INSERT INTO tswNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mantsa ma na Yesu da̱na̱i a uwusa a wantsun, a̱vu za na da̱na̱i no otoni a̱ lima̱ꞌa̱ u pati yi ankuri, u lyawa yi u ꞌya̱wa̱ oɓolo na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Amma u ꞌyuwan ta̱, a̱vu u damma yi, “ꞌYa̱wa̱ o uꞌwa u ɗu, vu ꞌya̱wa̱ ba̱ta̱ a̱ nꞌutsa̱ ma̱ wu waru, vu ca le alabari e ili i na a̱ A̱sula̱ a yuwaan nuwu.” ");
INSERT INTO tswNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","A̱vu u ka̱ra̱ a casu alabari upasu wi iɗa wa Dikafoli, ili i saꞌani i na Yesu yuwaan niyi. Ama suru a yuwan ta̱ asalama ni ili i ndolo. ");
INSERT INTO tswNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mantsa ma na Yesu ka̱mba̱i a̱ ꞌya̱wa̱ upasu u ndeɗe, a̱vu ama o ɓoloto a̱bunda̱ uba̱ta̱ wa̱ yi, a̱yi lo zuzu na̱ malaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","A̱tsuma̱ a azagbagbain a̱ a̱a̱ꞌisa̱ꞌa̱, za na a̱ tsu ɗe Jayiru, u ta̱wa̱ ta̱ we ene yi. A̱vu u kingyo a̱ ma̱ka̱ka̱n ma̱ yi, ");
INSERT INTO tswNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","a patishi yi lon, adansa, “Usheli u keꞌen u va̱ u ciga ma̱kuwa̱a̱. N ciga ta̱ vu ta̱wa̱ vu kuruwa̱ yi ukere, adama u ka̱mba̱ gbaga.” ");
INSERT INTO tswNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Reve u ꞌya̱wa̱ oɓolo na̱ a̱yi, reve ama a̱ a̱bunda̱ o toni yi a gbagbalasa yi. ");
INSERT INTO tswNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","A̱tsuma̱ o oɓoloꞌo, ka ro na yuwain aꞌwan kupa ne ejere o ocosu mpasa shi ta̱ pe. ");
INSERT INTO tswNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wu uwwa ta̱ awuya lon e ekere a̱ a̱za̱ a̱ a̱guma̱, waru wu una ta̱ ili i na u ri na̱ a̱yi suru, amma u jebe yi shi, she ili i na i ꞌya̱wa̱i elime. ");
INSERT INTO tswNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ana wu uwwai adama e Yesu, a̱vu u ta̱wa̱ nu ucina̱ wa̱ yi a̱tsuma̱ o oɓoloꞌo, a̱vu u juꞌwa̱n utugu wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","U jiyan ta̱ o ookolo a̱ yi, “Na̱ n juꞌwa̱n utugu wa̱ yi goon, n ta̱ ka̱mba̱ gbaga.” ");
INSERT INTO tswNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Babu usa̱n wocosu wu mpasa ma̱ yi n lyawai, a̱vu u reve u tsura̱ ta̱ lafiya lipu va̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","A̱vu Yesu reveshi ucira wu uta̱ ta̱ a̱ lipu va̱ yi. Ɗaɗa u vadalai a̱tsuma̱ o oɓoloꞌo, a̱vu we ece, “Zane ɗa juꞌwa̱n numu utugu?” ");
INSERT INTO tswNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Reve ojoro a̱ yi a̱ usu yi, “Ve ene oɓolo a gbagbalasa wu, a̱vu ve ece, ‘Zane ɗa juꞌwa̱n nuwu utugu?’ ” ");
INSERT INTO tswNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","A̱vu u ka̱ra̱ a vadalasa adama we ene za na yuwain ulinga u ndolo. ");
INSERT INTO tswNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A̱vu kaꞌa, ana u revei ili i na i yuwan niyi, a̱vu u ta̱wa̱ u kingyo a̱ ma̱ka̱ka̱n ma̱ yi na̱ wovon na̱ mejeꞌen ma̱ lipu. A̱vu u damma yi amayun suru. ");
INSERT INTO tswNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","A̱vu u damma yi, “Usheli, ucawu wo okolo a̱ wu u ka̱mba̱to wu ta̱ gbaga. Wala na̱ ma̱za̱nga̱, babu ubanakun.” ");
INSERT INTO tswNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","A̱yi pe a̱tsuma̱ a adanshi, a̱vu ozo o ro a̱ ta̱wa̱ ɗe o uꞌwa wu zagbain va̱ a̱a̱ꞌisa̱ a damma, “Usheli wa̱ wu u kuwa̱ ta̱. Cine vaa damaton yi waru?” ");
INSERT INTO tswNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Agba Yesu polo atsuvu e ili i na aa dansa shi. A̱vu u damma zagbaiꞌin, “She vu uwwa wovon wan, vu ca okolo goon.” ");
INSERT INTO tswNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","U lyawa nanza toni yi shi, she Bituru, na̱ Yakubu, na̱ Yahaya mawun ma̱ a̱na̱wu ma Yakubu. ");
INSERT INTO tswNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ana a rawai o uꞌwaꞌa, a̱vu wu uwwa a yuwusan elemu, e mesun, a yisaali babu ukotu. ");
INSERT INTO tswNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ana u uwai, a̱vu u damma le, “Nye i zuwai i ri a yisaali babu ukotu? Usheliꞌi u ri ukwa̱ shi, nlavu n ɗa waa yuwusan.” ");
INSERT INTO tswNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","A̱vu a yuwaan yi izoꞌoshi yu ulamu. Ana wu uta̱a̱ nle a alanga suru, a̱vu u tara nsha̱wu mu usheliꞌi oɓolo no ojoro a̱ yi, aza a na a̱ da̱na̱i oɓolo na̱ a̱yi, a uwa uba̱ta̱ u na mawuꞌun u da̱na̱i. ");
INSERT INTO tswNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","A̱vu u reme ukere wa̱ yi, u damma yi, “Talita kumi.” Ili i na waa dansa ɗa nda, “Mesheli, n ta dansaa wu, ꞌyon.” ");
INSERT INTO tswNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Babu usa̱n a̱vu usheliꞌi u ꞌyoshin, u fara mmalu. Aꞌwan a̱ yi kupa ne ejere a ɗa a̱ da̱na̱i. A̱vu a uwa asalama a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","A̱vu u rono le atsuvu lon, she a damma nanza wan. A̱vu u damma le waru a ca usheliꞌi ilyalya. ");
INSERT INTO tswNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu lyawa ta̱ ɗe, a̱vu u ka̱mba̱ Nazara lyuci le. A̱vu ojoro a̱ yi o toni yi. ");
INSERT INTO tswNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ana urana wa Ashibi u rawai, a̱vu u teme uritosu a̱ a̱a̱ꞌisa̱.† Ama a na a uwwa niyi o uritosu, a̱vu a yuwan asalama, adansa, “Te ɗa vuma nda tsura̱i ili i nda suru? Cuꞌun vu urevu ne ɗa a ca niyi tsunda? Ka̱lyuwa̱ cuꞌun vu ulinga wa asalama u na waa yuwusan. ");
INSERT INTO tswNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","A̱yi nda, a̱yi ɗa za vu usheꞌen ndolo shi, mawun ma Meri,† zakpara va Yakubu, oɓolo na̱ Isuhu, na̱ Yahuza na̱ Simo shi? A̱za̱ a̱ yi e esheli pa ɗa a̱ ri oɓolo na̱ tsu shi?” Ɗaɗa a ꞌyuwan niyi. ");
INSERT INTO tswNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","A̱vu u damma le, “A tsu ꞌyuwan vumava̱sula̱ uba̱ta̱ u ro shi, she a̱ lyuci le oɓolo na̱ a̱za̱ a̱ yi, nu uꞌwa u le.” ");
INSERT INTO tswNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","U gura yuwan ulinga wa asalama a̱ lyuci le shi. Keꞌen ɗa u kuruwa̱yi a̱za̱ o ubanakun ukere, a̱vu u ka̱mba̱to le gbaga. ");
INSERT INTO tswNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","U yuwan ta̱ asalama lon, ana a̱ kuɗa̱i a ca okolo. A̱vu u ka̱nda̱ruwa̱ a̱ ꞌya̱wa̱ a̱ mulyuci a yuwusan urocosu. ");
INSERT INTO tswNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","A̱vu u ɗe Kupanejere† u lyungu le ama e re re. U ca le ta̱ ucira e ekere o otoni a̱ lima̱. ");
INSERT INTO tswNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","A̱vu u damma le, “She i tara ili i ro a mmalu n ɗu wan, she aɗanga. She i tara opopofu wan, ko tsa̱n, ko ikebe o osonu a̱ ɗu wan. ");
INSERT INTO tswNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","I oto atan, amma she i tara a̱tugu o ro wan.” ");
INSERT INTO tswNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","A̱vu u dammisa le, “Ni i rawa uba̱ta̱ u na a̱ ushi nɗu, yi isawan pe o uꞌwaꞌa she mantsa ma na yaa lyawa lyuci ndolo. ");
INSERT INTO tswNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Agba ni i rawa a̱ lyuci na a̱ usu nɗu shi, ko a uwwa ɗu shi, i lyawa yi, a̱vu i ka̱ka̱la̱ ma̱buta̱ ma ana ma̱ ɗu. U to oꞌwo iroci i na yoo roco ama a̱ lyuciꞌi a yuwan mejege shi.” ");
INSERT INTO tswNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","A̱vu a̱ ka̱ra̱ a yuwusan alajiya, a dansaa ama a vadala† uba̱ta̱ wa̱ A̱sula̱, a lyawa unusu u le. ");
INSERT INTO tswNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","O uta̱a̱ ta̱ otoni a̱ lima̱ na̱ a̱bunda̱, a̱vu a putala a̱za̱ o ubanakun maniꞌin, a̱vu a̱ tsura̱ lafiya. ");
INSERT INTO tswNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ana Mogono Hiridu† uwwai alabari e Yesu, adama a na aala e Yesu oꞌwo ta̱ urevu ba̱ta̱ suru. A̱vu ozo o ro a damma, “A̱ ꞌya̱sa̱n ta̱ Yahaya za vu Urumbusu. Ɗaɗa u tsura̱i ucira u na waa yuwusan ulinga wa asalama.”† ");
INSERT INTO tswNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ozo o ro gba a damma, “Iliya ɗa.” Ozo o ro a damma, “A̱yi vumava̱sula̱ ro ɗa, oroci a ama̱sula̱ o ufaru.” ");
INSERT INTO tswNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ana Hiridu uwwai ne, a̱vu u damma, “Yahaya za vu Urumbusu ɗa, za na n zuwai o koɗoi aaci a̱ yi, amma a̱ ꞌya̱sa̱n yi ta̱.” ");
INSERT INTO tswNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","U damma ta̱ ne adama a na a̱yi na aciya̱yi u lyungu ta̱ ɗe e reme yi. A̱vu waru u zuwa a̱ nla̱ yi, adama a ka na a̱ tsu ɗe Hiridiya ka vawun va̱ yi Filibu, za na u usai. ");
INSERT INTO tswNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Adama a na Yahaya da̱na̱ ta̱ a dansaa yi, “U ri ulobonu vu zuwa ka vawun va̱ wu shi.” ");
INSERT INTO tswNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","A̱vu Hiridiya zuwa yi o ookolo a̱ yi, hali u shi u ciga woo una yi. Agba u tsura̱ ure u na wu una yi shi. ");
INSERT INTO tswNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Adama a na mogonoꞌo wu uwwusa ta̱ wovon wa Yahaya, adama a na u reve ta̱ vuma va akiza ɗa. Mantsa ma na wu uwwa niyi, ookolo a̱ yi a̱ tsu da̱na̱ nden shi, suru na̱ ne u tsu ciga ta̱ wu uwwa yi. ");
INSERT INTO tswNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Amma o ukosu, Hiridiya tsura̱ ta̱ ure u ro. Ana urana u na a matsain mogonoꞌo u ka̱nda̱ruwa̱i, u banu ta̱ ngono, na̱ nan yali a gbagbain, na azagbain o upasu wa̱ Ga̱lili a̱buki. ");
INSERT INTO tswNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ana usheli wa̱ Hiridiya u uwa u jeꞌein, a̱vu mogonoꞌo na aza a na u banuyi a yuwan ma̱za̱nga̱. A̱vu u damma usheliꞌi, “Pati ili i na vu cigai suru, n ta ca wu.” ");
INSERT INTO tswNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","U kucinaa yi ta̱, u damma, “Ili i na vu pati numu suru, n ta ca wu. Ko uɓatsalai u tsugono tsa̱ va̱ tsa ɗa vu cigai, n ta ca wu.” ");
INSERT INTO tswNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","A̱vu wu uta̱ we ece mma va̱ yi, “Nye maa pati?” A̱vu u usu yi, “Pati aaci a Yahaya za vu Urumbusu.” ");
INSERT INTO tswNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Babu usa̱n, a̱vu u ka̱mba̱ o ukobu u mogono, u pati yi u damma, “Gogogo, n ciga ta̱ vu ca mu aaci a Yahaya za vu Urumbusu a mapara.” ");
INSERT INTO tswNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","A̱vu a̱tsuma̱ o mogono a̱ la̱nga̱ lon, amma adama a akucunu a na u yuwain elime a ama, u ri n cine waa yuwan u putsa yi shi. ");
INSERT INTO tswNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Lo ɗa u lyunguyi agbashi a̱ yi, u damma o koɗoo yi aaci a Yahaya a̱ ta̱wa̱a̱. A̱ ka̱ra̱ ta̱ o koɗo aaci a̱ yi o uꞌwa wa ali. ");
INSERT INTO tswNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Reve u ta̱wa̱a̱ na aaciꞌi a mapara, u ca usheliꞌi. Mawun ma ka gba, u ca mma va̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mantsa ma na ojoro a Yahaya a uwwai alabari o ndolo, a̱vu a̱ ta̱wa̱ a tara lipu va̱ yi, a̱ ꞌya̱wa̱ a̱ ciɗo yi. ");
INSERT INTO tswNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ana ojoro e Yesu a̱ ka̱mba̱i uba̱ta̱ wa̱ yi, reve a damma yi ili i na a yuwain suru, ni ili i na o ritoi. ");
INSERT INTO tswNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ama na̱ a̱bunda̱ a̱ ta̱wusa̱ na̱ a̱ ka̱mbi, a̱yi no ojoro a̱ yi a̱ tsura̱ mantsa ma na aa lyuwa ilyalya shi. A̱vu u damma le, “Ta̱wa̱i, tsu ꞌya̱wa̱i uba̱ta̱ u na ama a̱ ri shi, yi ivuwan.” ");
INSERT INTO tswNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","A̱vu a̱ ka̱ra̱ a uwa a wantsun a̱ ꞌya̱wa̱ uba̱ta̱ u na ama a̱ ri shi, ele goon. ");
INSERT INTO tswNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ana oɓolo a ama a na a̱ ta̱wa̱i ba̱ta̱ ba̱ta̱ e ene nle a̱ ma̱ka̱ra̱a̱ e reve le ta̱, a̱vu a suma a̱ ꞌya̱wa̱ upasu u ndeɗe kafu ele a rawa ɗe. ");
INSERT INTO tswNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ana u rawai ɗe, a̱vu we ene oɓolo a ama lon. A̱vu we ene le iliyali, adama a na a̱ da̱na̱ ta̱ she damma ikyon i na i ri na̱ za va aguɓa shi. A̱vu u teme o rocosu ili na̱ a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ana urana u kotoi, a̱vu ojoro a̱ yi a̱ ta̱wa̱ uba̱ta̱ wa̱ yi. A̱vu a damma yi, “Uba̱ta̱ u nda gba ama pa shi, waru urana u ɗa nda u kotoi. ");
INSERT INTO tswNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Damma le a̱ ka̱ra̱ a̱ ꞌya̱wa̱ a̱ mulyuci n wawaꞌa n na n ri lo zuzu, a tsulaa aciyele ilyalya i na aa lyuwa.” ");
INSERT INTO tswNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","A̱vu u usu le, “ꞌYa̱wa̱i i ca le ilyalya i na aa lyuwa.” A̱vu a̱ usu yi, “Tsu ꞌya̱wa̱ tsu una ikebe i na i rawai ikebe yu ulivu ukpakure (200) e ilyalya, a̱vu tsu ca le a lyuwa?” ");
INSERT INTO tswNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","A̱vu we ece le, “Opopofu a yan a ɗa ɗu? ꞌYa̱wa̱i i ka̱lyuwa̱.” Ana a̱ ꞌya̱wa̱i a̱ ka̱lyuwa̱i, a̱vu a damma, “Ozo o ton a ɗa, na̱ mugula n re.” ");
INSERT INTO tswNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","A̱vu u damma le suru ko zane ɗa da̱nu a anlya o uta̱nu oɓolo oɓolo. ");
INSERT INTO tswNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ne ɗa a̱ da̱na̱i ozo o ro kupoton-uton, ozo o ro ukpaku ukpaku. ");
INSERT INTO tswNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ana u tarai opopofu o toꞌon na̱ mugula n reꞌe, a̱vu u ꞌya̱sa̱n aaci zuva, a̱vu u godyoo A̱sula̱. Ana u bubusai opopofu na̱ mugulaꞌa, reve u ca ojoro a̱ yi, e neꞌeshen ama. E neꞌeshen le ta̱ opopofu na̱ mugula n ndolo suru. ");
INSERT INTO tswNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Suru nle a lyuwa ta̱ a̱ cuwa̱n. ");
INSERT INTO tswNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","A̱vu ojoro a̱ yi o ɓoloto asaka kupa ne ejere, asaka o opopofu na̱ mugula n na m buwai. ");
INSERT INTO tswNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ama a na a lyuwai ilyalya i ndolo ali ukpakukupa uton (5,000) u ɗa. ");
INSERT INTO tswNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","A̱vu u zuwushi ojoro a̱ yi a uwa a wantsun a fara pasaa yi a̱ ꞌya̱wa̱ a̱ lyuci va Besaida, kafu u lyawa oɓoloꞌo. ");
INSERT INTO tswNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ana u lyawa nle, a̱vu u kumba a aagaɗi, adama u ꞌya̱wa̱ u yuwan avasa. ");
INSERT INTO tswNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ana ulivu u yuwain, wantsun gba e memere ma mala, Yesu gba a̱yi ɗe a aagaɗi a̱yi a̱ ndeꞌen. ");
INSERT INTO tswNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Reve we ene le e melen na̱ wantsuꞌun a mala, adama a na upepu u ta damatosun le. Mantsa ma na nton n tsu saala na̱ wasasa, a̱vu u ka̱ra̱ a̱ ꞌya̱wa̱ yeꞌe le a mmalu a mala. U yuwan ta̱ she damma u ta̱ ka̱ra̱ le, ");
INSERT INTO tswNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","amma ana e ene niyi a mmalu a̱ mini, a̱vu a jiyan she damma yimoɗi i ɗa. A̱vu o oruwo, ");
INSERT INTO tswNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","adama a na wo oꞌwoi suru nle e ene yi ta̱, a̱vu a daꞌwan. Lo ɗa u yuwaan nle adanshi, “Guza̱i okolo a̱ ɗu, a̱mu ɗa. She yu uwwa wovon wan.” ");
INSERT INTO tswNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","A̱vu u uwa a wantsun ne ele, ɗaɗa upepu u voyin. A̱vu e reme asalama lon, ");
INSERT INTO tswNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","adama a na hali n gogo koto a̱ ri nu urevu wu ulyuwatosu wu ukpakukupa utoꞌon (5,000) shi. Adama a na okolo e le a̱ da̱na̱ ta̱ ugbawu. ");
INSERT INTO tswNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ana a pasai, a rawai e iɗa ya Janisara, a̱vu a̱ nla̱ wantsuꞌun. ");
INSERT INTO tswNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Na̱ mota̱a̱ me le a wantsun, a̱vu ama e reve yi. ");
INSERT INTO tswNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","A̱vu a suma ba̱ta̱ suru a tarasa a̱za̱ o ubanakun a avalu a̱ ta̱wusa̱a̱ yi ko te ɗa a uwwai u ri. ");
INSERT INTO tswNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Uba̱ta̱ u na u uwai suru, a̱ lyuci gbain na̱ mulyuciꞌi na akapi a̱ ba̱ta̱, a tsu zuwaa yi ta̱ a̱za̱ o ubanakun o uꞌuwata we eden. A̱vu, a pati yi u lyawa le a̱ juꞌwa̱n ngeꞌen mu utugu ma̱ yi. Aza a na a̱ juꞌwa̱n niyi suru a̱ tsura̱ ta̱ lafiya. ");
INSERT INTO tswNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Afarishi o ro oɓolo na̱ munlu n Wila̱ n ro o uta̱ ta̱ Urishelima reve o ɓoloto uba̱ta̱ wa̱ Yesu. ");
INSERT INTO tswNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","E ene ta̱ ojoro a̱ yi a alya e ilyalya ne ekere babu saꞌa o ure u na wu ntsayi shi. ");
INSERT INTO tswNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Afarishi na akapi a aza a Israꞌila a ta yuwusan cine nkaya n dammai wu ntsaa ta̱ a yuwan. A tsu saꞌa ta̱ ekere e le ulobonu. ");
INSERT INTO tswNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","A tsu ꞌyuwan ta̱ a lyuwa ilyalya e eden she na a saꞌa ekere. Ili na̱ a̱bunda̱ i ta̱ lo, tsa̱ wuza̱ꞌu wu nden, na̱ munda oɓolo na asaꞌatsu. ");
INSERT INTO tswNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Adama a na a tsu saꞌa ta̱ ulobonu, ana e enei ojoro a̱ yi a alya tsundolo, reve e ece yi, “Nye i zuwai ojoro a̱ wu a̱ kurusu ili i na yi ntsayi shi? Tsu cina le ta̱ a alya babu a saꞌa ekere.” ");
INSERT INTO tswNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","A̱vu u damma le, “A̱za̱ e ikpaꞌa! Wo oꞌwo ta̱ una̱ta̱ na Ishaya yuwain adanshi a̱ A̱sula̱ a aci a̱ ɗu. Ununa a ɗanai, ‘Ama a nda a ta casu mu tsugbain a̱ na̱ le goon, okolo e le gba alanga a ɗa a̱ ri na̱ a̱mu. ");
INSERT INTO tswNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","A̱ga̱nda̱ a na aa yuwusaan mu ili ya̱ a̱ɓula̱ i ɗa shi. Ili i na oo ritosu ili i ro i ɗa shi, agba uritosu wa ama u ɗa.’ ");
INSERT INTO tswNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Yi icina ta̱ na̱ wila̱ wa̱ A̱sula̱, a̱vu i toni uritosu wa ama.” ");
INSERT INTO tswNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","A̱vu u damma le, “Yi icina ta̱ ni ili i na A̱sula̱ a dammai, a̱vu i toni uritosu u ɗu. ");
INSERT INTO tswNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Adama a na Musa† dammai, ‘Vu ca dada na̱ mma va̱ wu tsugbain. Waru za na isulai dada ko mma va̱ yi, a ciga a ꞌyuwan o una yi.’ ");
INSERT INTO tswNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Amma uritosu u ɗu u damma ta̱ ili i saꞌani i ɗa vuma damma dada ko mma va̱ yi, ili i na n shi a ca ɗu n ca ta̱ ɗe A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","I putsa yi ta̱ na waa kamba dada ko mma va̱ yi ni ili i ro. ");
INSERT INTO tswNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ne ɗa i tsu yuwan, a̱vu i ka̱mba̱to adanshi a̱ A̱sula̱ pere, adama o uritosu u ɗu, ili i na̱ a̱bunda̱ icuꞌun i ndolo i ɗa i tsu yuwan.” ");
INSERT INTO tswNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","A̱vu u ɗewishe oɓoloꞌo, a̱vu u dammisa le, “I zuwa atsuvu suru nɗu yu uwwa ili i na maa damma. ");
INSERT INTO tswNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ili i na i tsu uwa a̱tsuma̱ a vuma a̱yi ɗa u tsu lungusa̱ wuma wa̱ yi shi, she ili i na i tsu uta̱ o okolo, a̱yi ɗa u tsu lungusa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Za na ri na atsuvu, wu uwwa.” ");
INSERT INTO tswNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ana wu kasai no oɓoloꞌo, a̱vu u uwa o uꞌwa. A̱vu ojoro e ece yi ili i na irociꞌi waa dansa. ");
INSERT INTO tswNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","A̱vu u usu le, “A̱ɗu fo i reve ili i na irociꞌi waa dansa shi? A̱ɗu fo i reve shi, ko nye ɗa i uwai a̱ a̱a̱tsuma̱ a vuma, u tsu lungusa̱ yi shi? ");
INSERT INTO tswNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Adama a na u uwa o okolo a̱ yi shi, amma u uwa ta̱ a̱ a̱a̱tsuma̱ a̱ yi, ne ɗa waru woo uta̱?” Ne ɗa Yesu yuwain u ka̱mba̱toi ilyalya suru ulobonu adama a alya. ");
INSERT INTO tswNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","A̱vu waru u damma, “Ili i na yoo utusa̱ uba̱ta̱ u vuma, a̱yi ɗa u tsu lungusa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Adama a na pe ɗa, pe o okolo a vuma ɗa icuꞌun i nda yo utusa̱: majiyan me iwuya, tsipere, na̱ wivu, na̱ mona ma ama, ");
INSERT INTO tswNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nu uforondo, ni iwuya, na̱ wulumu, nu unusu icuꞌun icuꞌun, na̱ tsurala, ne epen, na aci o ugbamu na̱ tsulo. ");
INSERT INTO tswNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iwuya i pe o okolo a vuma a ɗa a̱ tsu uta̱, a̱vu a zuwa yi wo oꞌwo ili yi idaba e ekere a̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Diga lo a̱vu u ka̱mba̱ a̱ ꞌya̱wa̱ a̱ mɓa̱nga̱ ma Taya na̱ Sida. A̱vu u uwa o uꞌwa u ro, u ciga nanza reve shi, amma u ri n soko aciya̱yi shi. ");
INSERT INTO tswNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ka na mawun ma̱ yi, usheli u waꞌa u da̱na̱i no otoni a̱ lima̱, ana wu uwwai alabari e Yesu, a̱vu u ta̱wa̱ u kingyo a̱ ma̱ka̱ka̱n ma̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Kaꞌa gba Meheleni ma ɗa, uba̱ta̱ u na wu uta̱i gba Basurofiniki ɗa. A̱vu u pati Yesu uta̱a̱ otoni a̱ lima̱ a na a uwai a̱tsuma̱ a mawun ma̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","A̱vu u usu kaꞌa, “Lyawa tsu fara lyuwato muwun mu uꞌwa. U ri ulobonu a tara ilyalya i muwun a̱vu a variya musa̱n shi.” ");
INSERT INTO tswNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Amma u usu yi ta̱, u damma, “Ne ɗa u ri Zagbain, agba ko musa̱n n tsu lyuwa ta̱ akapi e ilyalya i muwun.” ");
INSERT INTO tswNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","A̱vu u damma yi, “Adama a adanshi a̱ wu, wala a̱ ka̱mba̱ o uꞌwa, otoni a̱ lima̱ꞌa̱ a lyawa ta̱ mawun ma̱ wu.” ");
INSERT INTO tswNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","A̱vu u ka̱mba̱ o uꞌwa, a̱vu u cina mawun ma̱ yi nven a aavalu. Cina otoni a̱ lima̱ꞌa̱ a lyawa yi. ");
INSERT INTO tswNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","A̱vu u lyawa mɓa̱nga̱ ma Taya, u toni a̱ ꞌya̱wa̱ Sida a̱ ꞌya̱wa̱ a Mala ma̱ Ga̱lili, ni iɗa i na a̱ tsu ɗe Dikafoli. ");
INSERT INTO tswNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ama o ro a̱ ta̱wa̱a̱ yi ta̱ na̱ vuma na da̱na̱i aagulani waru nu usa̱n u ɗa u tsu gura damma, a̱vu a pati Yesu ankuri u kuruwa̱ vumaꞌa ukere. ");
INSERT INTO tswNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","A̱vu Yesu tara yi a̱ ꞌya̱wa̱ uba̱ta̱ u na ama a̱ da̱na̱i shi, a̱vu u zuwa akatsu a̱ yi a atsuvu a vumaꞌa, u tsuwa̱n ma̱tsa̱n ma̱ yi, a̱vu u juꞌwa̱n eelentsu a vumaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","A̱vu Yesu ka̱lyuwa̱ zuva no okolo a̱ ta̱, a̱vu u damma yi, “Ifata!” adansa, “Kpa̱tuꞌwa̱!” ");
INSERT INTO tswNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","A̱vu u kpa̱tuꞌwa̱ atsuvu a̱ yi. Ili i na i shi yi nla̱i eelentsu a̱ yi, u ba̱ɗa̱. A̱vu u yuwan adanshi mejege. ");
INSERT INTO tswNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","U damma le ta̱ she a damma ama wan, amma she ili i na i lyuwai elime a casu alabari a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","A̱vu a yuwan asalama lon, a damma, “Ka̱lyuwa̱ cine u yuwain iliꞌi suru mejege. Hali u gura zuwa agulani a uwwa. Aza a na a tsu gura yuwan adanshi shi, a yuwan adanshi.” ");
INSERT INTO tswNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","A mantsa mo ndolo, oɓolo a ama o ro o ɓoloto ta̱ a̱bunda̱, agba a̱ ri ni ilyalya i na aa lyuwa shi. A̱vu Yesu ɗe ojoro a̱ yi, a̱vu u damma le, ");
INSERT INTO tswNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“N te eneshe oɓolo a ama ndaꞌa iliyali, adama a na o to oɓolo na̱ mu hali rana taꞌatsu, agba a̱ ri ni ilyalya i na aa lyuwa shi. ");
INSERT INTO tswNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Waru na̱ n damma le a̱ tyo o uꞌwa na ambulu, aa gura rawa o uꞌwa shi, ozo o ro ɗa nda gba o uta̱i alanga.” ");
INSERT INTO tswNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","A̱vu ojoro a̱ yi a̱ usu yi, a damma, “Uba̱ta̱ u nda ogozo a ɗa, te ɗa gba tsaa gura tsura̱ ilyalya i na tsaa gura lyuwato ama a̱ a̱bunda̱ a nda?” ");
INSERT INTO tswNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","A̱vu we ece le, “Opopofu a yan a ɗa ɗu?” A̱vu a damma, “A̱za̱ e cindere.” ");
INSERT INTO tswNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","A̱vu u zuwa amaꞌa a̱ da̱nu e iɗa. Ana u tarai opopofu e cindere o ndolo, a̱vu u godyoo A̱sula̱, a̱vu u bubusa, u casu ojoro a̱ yi a̱ ꞌya̱wa̱a̱ oɓolo a amaꞌa. A̱vu a̱ ꞌya̱wusa̱a̱ le. ");
INSERT INTO tswNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","A̱ da̱na̱ ta̱ na̱ mugula n kekeꞌen waꞌa. Ana u godyoyi A̱sula̱, a̱vu u damma a̱ ꞌya̱wa̱a̱ le. ");
INSERT INTO tswNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Ama ukpakukupa una̱shi (4,000) u ɗa a̱ shi o ɓolotoi, a̱vu gba a lyuwa ilyalya hali a̱ cuwa̱n. Reve ojoro o ɓoloto akapi a na a buwai reve o shiton asaka e cindere. A̱vu u damma le a̱ tyo o uꞌwa. ");
INSERT INTO tswNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","A jima shi, ɗaɗa u uwai a wantsun no ojoro a̱ yi a̱ tyo Dalmanuta. ");
INSERT INTO tswNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Afarishi a̱ ta̱wa̱ e teme mawasan na̱ a̱yi, a ta zama u roco le iroci ɗe zuva, adama a̱ lyungwa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","A̱vu wi ivuwan ogbolo a̱ ruhu va̱ yi, u damma, “Nye i zuwai ama o gogo a̱ ri e izami yi iroci? Amayun a ɗa n damma nɗu, babu iroci i na oo roco ama o gogo.” ");
INSERT INTO tswNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","A̱vu u lyawa le lo, a̱vu u ka̱mba̱ a wantsun u pasa a̱ ꞌya̱wa̱ a̱ mɓa̱nga̱ n ndeɗe. ");
INSERT INTO tswNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Reve e reme mmalu agba e icina ta̱ a na a̱ ta̱wa̱a̱ no opopofu, ili i na i ri lo le pe a wantsuꞌun u laꞌa za ta̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","A̱vu u damma le, “I yuwan ugbozu na̱ wolilo wa Afarishi na̱ a̱za̱ a̱ Hiridu.” ");
INSERT INTO tswNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","A̱vu a dammulai, “U damma ta̱ ne ana wo oꞌwoi tsu ri no opopofu shi.” ");
INSERT INTO tswNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu gba u reve ta̱ ili i na a dammulai, a̱vu we ece le, “Nye i zuwai i dammai i ri no opopofu shi? Koto ye ene ko i reve shi? ");
INSERT INTO tswNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","I ta̱ ne esu, amma yee ene shi. I ta̱ na atsuvu, amma yaa uwwa shi. ");
INSERT INTO tswNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Waru i cuwan ana m bubusai opopofu o ton, a̱vu n neꞌeshen ama ukpakukupa uton shi? Akapi gba asaka a yan a ɗa i ɓolotoi?” A̱vu a̱ usu, “Kupa ne ejere.” ");
INSERT INTO tswNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ɗaɗa we ece nle, “Ana m bubusayi ama opopofu e cindere, akapi a asaka a yan a ɗa a buwai ana i ɓolotoi?” Reve a̱ usu yi “A̱za̱ e cindere a ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ɗaɗa we ece nle, “Hali n gogo koto i reve ili i na maa dansaa ɗu shi?” ");
INSERT INTO tswNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","A̱vu a rawa a̱ lyuci va Besaida. Reve ama a̱ ta̱wa̱a̱ Yesu ni irumba̱, a̱vu a pati yi u juꞌwa̱n yi. ");
INSERT INTO tswNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","A̱vu u reme ukere wa̱ yi, wu uta̱a̱ yi a̱ mɓa̱nga̱ n lyuci. Reve u tsuwa̱a̱n yi ma̱tsa̱n e esu, waru u kuruwa̱ yi ukere, a̱vu we ece yi, “Vu gura ta̱ ene ili i ro?” ");
INSERT INTO tswNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","A̱vu irumba̱ꞌa̱ u ꞌya̱sa̱n urewesu, a̱vu u usu, “N te eneshe ama. Amma oroci a ɗanga a ɗa mee eneshe le a agara.” ");
INSERT INTO tswNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","A̱vu u zuwisaa yi ukere o urewesu. A̱vu irumba̱ i kpa̱tuꞌwa̱ esu yi we ene ili suru mejege. ");
INSERT INTO tswNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","A̱vu Yesu damma yi u wala a̱ tyo o uꞌwa, waru u damma yi ta̱, “She vu uwa a ma̱lyuci mo ndolo wan.” ");
INSERT INTO tswNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu ꞌyon ta̱ no ojoro a̱ yi, u uwa mulyuci n Kasariya Filibi. A̱vu we ece ojoro a̱ yi, “Zane ɗa ama aa dansa n ri?” ");
INSERT INTO tswNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","A̱vu a̱ usu yi, “Yahaya za vu Urumbusu, ozo o ro gba a damma, Iliya, ozo o ro gba a damma vu uta̱ ta̱ a̱tsuma̱ a ama̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","A̱vu we ece le, “Amma a̱ɗu gba, zane ɗa yaa dansa n ri?” A̱vu Bituru usu yi, “A̱vu ɗa Kristiꞌi† Zamawawa.”† ");
INSERT INTO tswNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","A̱vu u rono le atsuvu she a damma nanza wan. ");
INSERT INTO tswNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","A̱vu u teme o ritosu le, a dansa, “A̱mu Mawun ma Vuma n to sowo a̱tsuma̱lima̱ lon. Waru azagbain, na̱ nan ganu a gbagbain, na̱ munlu n Wila̱ a ta ꞌyuwan mu, hali o una mu. Agba na a yuwan rana taꞌatsu, n ta̱ ꞌyon wuma.” ");
INSERT INTO tswNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A alanga eteshe a ɗa u damma nle adanshi o ndolo. A̱vu Bituru ɗe yi a̱ tyo a̱ ngeꞌen, u teme a yuwusaan yi nla̱ngi. ");
INSERT INTO tswNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Amma ana Yesu vadalai, we enei ojoro a̱ yi, a̱vu u ɓara Bituru, u damma, “Vu yuwan alanga na̱ a̱mu, a̱vu Male! Vaa yuwusan avasa adama a na ili ya̱ A̱sula̱ yaa shiwan shi, she ili ya ama.” ");
INSERT INTO tswNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","A̱vu u ɗe oɓoloꞌo oɓolo no ojoro a̱ yi, u damma le, “Za na cigai u toni mu, she nu u ꞌyuwan aciya̱yi suru suru, nu u ciga u ꞌyuwan u tara akpata a̱ yi, a̱vu u toni mu. ");
INSERT INTO tswNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Za na ri aɗa a wuma wa̱ yi, u ta lamba yi. Amma za na lambai wuma wa̱ yi adama a̱ va̱, adama a Alabari a Saꞌani waru, u ta̱ tsura̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nye i ɗa vuma munai ko nu u tsura̱ uvaɗi u nda suru, a̱vu u lamba wuma wa̱ yi? ");
INSERT INTO tswNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nye waru vuma aa gura tsupa, a̱vu u wawa wuma wa̱ yi? ");
INSERT INTO tswNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Na̱ za uwwa wono u va̱ na alajiya a̱ va̱ o uvaɗi u iwuya wu ulambu wa̱ a̱ɓula̱ u nda, Mawun ma Vuma fo u ta uwwa wono wa̱ yi, nu u ꞌya̱wa̱ a̱ ma̱ka̱ka̱n ma Dada va̱ yi na̱ nlingata ma̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","A̱vu u lyuwa elime na adanshi, “Amayun ɗa maa dansaa ɗu, ozo o ro a̱ ta̱ pa uba̱ta̱ u nda na ee ene ukwa̱ shi, she ne e ene tsugono tsa̱ A̱sula̱ tsa̱ ta̱wa̱ nu ucira.” ");
INSERT INTO tswNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ana a yuwain rana ta̱li, a̱vu Yesu tara Bituru, na̱ Yakubu, na̱ Yahaya, u ꞌya̱wa̱to le a masasan mo ugaꞌan, ele goon. A̱vu oroci a̱ yi a vadala elime e le. ");
INSERT INTO tswNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Itana ya̱ yi i vadala yo oꞌwo uꞌuri puwu a madala, pa o uvaɗi u nda babu za na aa gura za̱za̱ꞌwa̱ le ne. ");
INSERT INTO tswNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","A̱vu e eneshi Iliya† na̱ Musa, a yuwusan adanshi na̱ Yesu. ");
INSERT INTO tswNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","A̱vu Bituru cananaa yi una̱, “Manlu, u lobono ta̱ ana tsu ri pa. Tsu ta yuwan pa ogodo a taꞌatsu, za ta̱ za va̱ wu, za ta̱ za va Musa, za ta̱ waru za va Iliya.” ");
INSERT INTO tswNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","U lamba ta̱ ili i na waa damma, adama a na wu uwwai wovon lon. ");
INSERT INTO tswNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","A̱vu eleshe a̱ ta̱wa̱ a̱ kpa̱to le nu ululu, a̱vu uɗyo wu uta̱ ɗe e elesheꞌe, “Mawun ma na n cigai lon ɗa nda, yu uwwa yi.” ");
INSERT INTO tswNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","A̱vu a̱ jika̱ a̱ ka̱nla̱shi, amma e ene waru za ro shi, Yesu ɗa goon e enei oɓolo ne ele. ");
INSERT INTO tswNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ana a̱ cipa̱i ɗe a masasaꞌan, a̱vu u damma le, “She i damma nanza ili i na ye enei wan, she na̱ Mawun ma Vuma mo ꞌyon a̱tsuma̱ o ukwa̱.” ");
INSERT INTO tswNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","A yuwan ta̱ ili i na u damma nle a yuwan, amma a yuwusan ta̱ adanshiꞌi goon le, “Nye i ɗa waa dansa adama o uꞌyosun o ukwa̱ u nda?” ");
INSERT INTO tswNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","A̱vu e ece yi, “Nye i zuwai munlu n Wila̱ n dammai nga Iliya ta fara ta̱wa̱ elime a̱ Kristi Zamawawa?” ");
INSERT INTO tswNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","A̱vu u usu le, “Iliya ɗa fara ta̱wa̱i, adama a na woo foɓo ili suru. Nye i zuwai a ɗanai, adama a Mawun ma Vuma, ‘U to sowo awuya icuꞌun icuꞌun, waru aa ꞌyuwan yi?’ ");
INSERT INTO tswNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Amma n ta dansaa ɗu, Iliya ta̱wa̱ ta̱ ɗe, a yuwaan yi ta̱ cine a cigai, cine alabari a̱ yi a̱ ri uɗanu.” ");
INSERT INTO tswNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ana a̱ ka̱mba̱i uba̱ta̱ u na ojoro a̱ yi a̱ ri, a̱vu e ene a̱ba̱jini o oɓolo uka̱nda̱ruwu ne ele. Munlu n Wila̱ waru n da̱na̱ ta̱ a mawasan ne ele. ");
INSERT INTO tswNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Na̱ menee ma̱ Yesu, a̱vu oɓoloꞌo a yuwan asalama lon. A̱vu o ɓoso ni ilaɗi a̱ ta̱wa̱ uba̱ta̱ wa̱ yi, a̱ ca̱sa̱sa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","A̱vu we ece le, “Mawasan ma̱ ne yaa yuwusan?” ");
INSERT INTO tswNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","A̱vu za ta̱ a̱tsuma̱ o oɓoloꞌo u usu yi, “Manlu, mpa nda n ta̱wa̱a̱ nuwu na̱ molobo ma̱ va̱ za na ri no otoni a̱ lima̱. Adama o ndolo u tsu gura yuwan adanshi shi. ");
INSERT INTO tswNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mantsa ma na otoni a̱ lima̱ꞌa̱ a kumba niyi suru, she na a vari yi e iɗa, una̱ wa̱ yi a yuwusan apiva, u gagalai anga a̱ yi, a̱vu wo oꞌwo wudaruwu. A̱vu m pati ojoro a̱ wu o lo otoni a̱ lima̱ a̱ yi, a̱vu a̱ kuɗa̱.” ");
INSERT INTO tswNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","A̱vu u usu le, “A̱ɗu ama o gogo aza a na aa casu okolo shi. N jima ta̱ nden na̱ a̱ɗu. Hali mantsa ma̱ ne ma̱a̱ da̱nu na̱ a̱ɗu a yuwusan ankuri na̱ a̱ɗu? Ta̱wa̱a̱ numu na̱ a̱yi.” ");
INSERT INTO tswNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","A̱vu a̱ ta̱wa̱a̱ yi na̱ moloboꞌo. Ana otoni a̱ lima̱ꞌa̱ e enei Yesu, a̱vu a varu moloboꞌo e iɗa babu usa̱n, lipu va̱ yi e mejeꞌen. Reve u riya̱ u da̱na̱ e igandalu, una̱ wa̱ yi o utusa̱ apiva. ");
INSERT INTO tswNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","A̱vu Yesu ece dada va̱ yi, “Urana u ne ili i ndolo i cina niyi?” A̱vu u damma, “A̱yi a mawun. ");
INSERT INTO tswNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","U sowo ta̱ a varusu yi a akina na̱ a̱ mini, adama wu una yi. Amma na̱ vaa gura yuwan ili i ro, ve ene tsu iliyali, vu kamba tsu.” ");
INSERT INTO tswNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","A̱vu u damma yi, “Na̱ maa gura? Ili suru ili i na aa gura yuwan ɗa e ekere a za na cayi okolo.” ");
INSERT INTO tswNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","A̱vu wu uta̱a̱ uɗyo babu usa̱n, “N ca ta̱ okolo. Kamba mu n da̱shi ca okolo.” ");
INSERT INTO tswNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ana Yesu enei oɓolo a ama a̱ ta̱wusa̱ lo uba̱ta̱ꞌa̱, a̱vu u ɓara otoni a̱ lima̱, u damma, “A̱vu otoni a̱ lima̱ a na a tsu putsaa na adanshi, n damma wu ta̱, vu kasa na̱ a̱yi. She vu da̱shi toni yi wan.” ");
INSERT INTO tswNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ana otoni a̱ lima̱ a̱ yi a saalai, a̱vu a kpasuꞌwa yi e iɗa lon, lipu va̱ yi e mejeꞌen, a̱vu a kasa na̱ a̱yi. A̱vu moloboꞌo wo oꞌwo tsa̱ a̱a̱kwa̱kwa̱, hali wo oꞌwo ama na̱ a̱bunda̱ a damma, “U kuwa̱ ta̱.” ");
INSERT INTO tswNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","A̱vu Yesu reme ukere wa̱ yi u ꞌya̱sa̱n yi, a̱vu u ꞌyon mishin. ");
INSERT INTO tswNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ana u uwai o uꞌwa, a̱vu ojoro a̱ yi e ece yi usokowu, “Nye i zuwai tsu kuɗa̱i, a na tsoo lo otoni a̱ lima̱ o ndolo?” ");
INSERT INTO tswNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","A̱vu u usu le, “Na avasa a ɗa goon aa gura lo cuꞌun ndolo a alanga, babu ili i ro.” ");
INSERT INTO tswNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","A̱vu a̱ ꞌyon lo, a uwa e iɗa ya̱ Ga̱lili. U ciga nanza reve shi. ");
INSERT INTO tswNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Adama a na u to ritosu ojoro a̱ yi, u ta dansaa le, “A ta ca Mawun ma Vuma e ekere a ama waru a̱ to una yi. Na̱ o una yi, na a yuwan rana taꞌatsu u ta̱ ꞌyon.” ");
INSERT INTO tswNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Amma a gura reve adanshiꞌi shi, a̱vu waru a uwwusa wovon na ee ece yi. ");
INSERT INTO tswNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","A̱vu a rawa Kafarnahum. Ana u uwai o uꞌwa, a̱vu we ece le, “Mawasan ma̱ ne yaa yuwusan o ure?” ");
INSERT INTO tswNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","A̱vu a̱ rungwa̱ kpaku kpaku, adama a na a yuwan ta̱ mawasan o ure za na oꞌwo zagbain a̱tsuma̱ e le. ");
INSERT INTO tswNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","A̱vu u da̱nu, u ɗe Kupanejereꞌe. A̱vu u damma le, “Za na cigai woo oꞌwo zagbain, u ka̱mba̱ za vu ukosu, aagbashi a ama suru waru.” ");
INSERT INTO tswNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","A̱vu u sheɗe mawun mo ro u zuwa yi e memere, a̱vu u katala yi. Ɗaɗa u damma nle, ");
INSERT INTO tswNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Za na ushiyi mawun me keꞌen cuꞌun nda adama a ala† a̱ va̱, a̱mu ɗa u ushiyi. Za na waru usu numu, a̱mu ɗa u ushiyi goon shi, amma za na lyungu numu ɗa u ushiyi.” ");
INSERT INTO tswNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","A̱vu Yahaya usu yi, “Manlu, tse ene ta̱ nanza o utusa̱a̱ otoni a̱ lima̱ na ala a̱ wu. A̱tsu gba tsu putsa yi ta̱, adama a na u ri oo tono tsu shi.” ");
INSERT INTO tswNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Amma u damma ta̱, “She i putsa yi wan, adama a na za na gura yuwain ulinga wa asalama a ala a̱ va̱, waa gura vadala u yuwan adanshi avama adama a̱ va̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Za na ri a tsurala na̱ tsu shi, za tsu ɗa. ");
INSERT INTO tswNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Amayun a ɗa maa dansaa ɗu, za na ca nɗu mini i sowo adama a̱ va̱, u ta̱ tsura̱ iliyinkapa. ");
INSERT INTO tswNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Na̱ nanza aa zuwa a̱tsuma̱ a̱ muwun n nda a̱ riya̱, u ta laꞌa a̱ nla̱a̱ yi utali u yira a̱ yinlu ya̱ yi, a̱vu a vari yi a mala. ");
INSERT INTO tswNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nu ukere wa̱ wu waa zuwa wu, vu nusan, vu koɗo yi. U ta laꞌaa wu, vu tsura̱ wuma babu ukere u ta̱ ana va̱a̱ tsura̱ ekere e re, a̱vu vu uwa a akina.† ");
INSERT INTO tswNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Uba̱ta̱ u na azun a̱ tsu kuwa̱ shi, waru akina a̱ tsu kima̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na anana a̱ wu aa zuwa wu vu yuwan unusu, vu koɗo yi. U ta laꞌaa wu, vu tsura̱ wuma na̱ tsukutsuma̱, ana aa vari wu a̱tsuma̱ a akina na ana e re. ");
INSERT INTO tswNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Uba̱ta̱ u na azun a̱ ri n kuwa̱ shi, waru akina a̱ ri n kima̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na̱ lyusu va̱ wu aa zuwa wu vu yuwan unusu, vu kongoro yi. U ta laꞌaa wu, vu uwa o tsugono tsa̱ A̱sula̱ na̱ lyusu ta̱, ana aa vari wu a̱tsuma̱ a akina ne esu e re. ");
INSERT INTO tswNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Uba̱ta̱ u na azun a̱ ri n kuwa̱ shi, waru akina a̱ ri n kima̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Na akina a ɗa aa lyungwa̱ ama suru, cine a tsu lapula ili na akpaɗi. ");
INSERT INTO tswNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Akpaɗi a̱ tu ulobonu, amma na̱ a̱ la̱nga̱, na̱ nye ɗa vaa lapula yi? “I da̱na̱ na akpaɗi o okolo a̱ ɗu, i yuwan nden n saꞌani.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu lyawa ta̱ ɗe, a̱vu u ka̱mba̱ e iɗa ya Yahuda, waru nu upasu wa̱ Urdu, ama na̱ a̱bunda̱ o ɓoloto ta̱ uba̱ta̱ wa̱ yi, a̱vu u ka̱ra̱ o rocosu le ununa u tsu yuwusan. ");
INSERT INTO tswNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","A̱vu Afarishi a̱ ta̱wa̱ uba̱ta̱ wa̱ yi, reve e ece yi, “Unusu u ɗa vuma lyawa ka va̱ yi?” ");
INSERT INTO tswNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","A̱vu we ece le, “Nye i ɗa Musa damma nɗu?” ");
INSERT INTO tswNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Reve a̱ usu yi, “Musa damma tsu ta̱ tsu ca ka aatagada a wukasu u lolo, a̱vu a lyawa yi.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ɗaɗa u usu nle, “Musa damma ɗu ta̱ ne, adama a na i ri na aciyogbamu. ");
INSERT INTO tswNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Amma a mantsa ma na a yuwain uvaɗi ne ɗa u da̱na̱i shi. Amma ana a fara a yuwain, ‘vali na̱ ka ɗa a yuwan nle.’ ");
INSERT INTO tswNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Adama o ndolo a ɗa vuma aa lyawa dada va̱ yi na̱ mma va̱ yi, tsa̱ra̱ u suraa ka va̱ yi goon. ");
INSERT INTO tswNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ele ra o to oꞌwo ili i ta̱.’ Ana wo oꞌwoi a buwa ili i re shi, ");
INSERT INTO tswNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","adama o ndolo ili i na A̱sula̱ o ɓoloi, she vuma kakasa wan.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","A̱vu ana a̱ ka̱mba̱i o uꞌwa ɗaɗa ojoro a̱ yi e ece niyi ili i na u ritoi. ");
INSERT INTO tswNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","A̱vu u damma le, “Za na kakasai, reve u yuwisan lolo ro, tsipere tsa ɗa waa yuwusan na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Waru na̱ ka lyawa vali va̱ yi, a̱vu u yuwisan lolo ro, tsipere tsa ɗa waa yuwusan.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","A̱ ta̱wusa̱a̱ yi ta̱ na̱ muwun, tsa̱ra̱ u juꞌwa̱n le. Reve ojoro a̱ yi a putsa le. ");
INSERT INTO tswNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Amma ana Yesu enei ne, reve a̱tsuma̱ a̱ la̱nga̱ yi. A̱vu u damma le, “Lyawai muwun n kekeꞌen n ta̱wa̱ uba̱ta̱ u va̱, she i putsa le wan. Adama e icuꞌun i ndolo i ɗa o foɓoi tsugono tsa̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","“Amayun a ɗa maa dansaa ɗu, za na usuyi tsugono tsa̱ A̱sula̱ cine muwun n ri shi, waa uwa a̱tsuma̱ o tsugono tsa̱ A̱sula̱ shi.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Reve u sheɗe le e ekere, a̱vu u zuwaa le abaꞌun. ");
INSERT INTO tswNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ana u remei mmalu a̱ tyo Urishelima, ɗaɗa nanza sumai elime e Yesu, a̱vu u kingyo. A̱vu u damma, manlu ma̱ a̱ɓula̱, “Nye ɗa maa yuwan, tsa̱ra̱ n tsura̱ wuma u babu ukotu?” ");
INSERT INTO tswNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","A̱vu Yesu usu yi, “Cine vee ɗesu mu manlu ma̱ a̱ɓula̱? Babu za va̱ a̱ɓula̱, she A̱sula̱ goon. ");
INSERT INTO tswNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A̱vu na aciya̱wu vu reve ta̱ ili i na A̱sula̱ a dammai a yuwan: ‘She vu una vuma nu ucigu wa̱ wu wan, she vu yuwan wivu wan, she vu yuwan tsipere wan. She vu usu ili i na vu revei shi wan, waru she vu paala za ro wan. Vu ca dada na̱ mma va̱ wu tsugbain.’ ” ");
INSERT INTO tswNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","A̱vu u usu yi, “Manlu, ele ndolo suru n yuwusan le ta̱, a̱mu o molobo.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","A̱vu Yesu ka̱lyuwa̱ yi ni icigi. A̱vu u damma yi, “Ili i ta̱ i ɗa vu lambai, ꞌya̱wa̱ vu wina ili i na vu ri na̱ a̱yi suru, tsa̱ra̱ vu ca alambi, adama vu tsura̱ uzuwa zuva. Na̱ vu yuwan ne a̱vu vu ta̱wa̱ vu toni mu.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ana wu uwwai ne, a̱vu u lukuta̱ urewesu, adama a na u ri ni ili a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","A̱vu u vadala u ka̱lyuwa̱ ojoro a̱ yi, a̱vu u damma le, “Ili yu usa̱n i ɗa za vu utsuru u tsura̱ u uwa a̱tsuma̱ o tsugono tsa̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A̱vu ojoro a̱ yi a uwa asalama, adama e ili i na u dammai. A̱vu u da̱shi dammisa, “Muwun n va̱, u ta yuwan usa̱n za vu utsuru uwa o tsugono tsa̱ A̱sula̱.† ");
INSERT INTO tswNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","U ta laꞌaa aarakumi a̱ pusula̱i na̱ vunu vu bele, ana za vu utsuru aa uwa o tsugono tsa̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ana a uwwai ne, a̱vu a̱ ka̱ra̱ a asalama, a̱vu a damma, “Na̱ wo oꞌwo za vu utsuru a̱a̱ tsura̱ u uwa a̱tsuma̱ o tsugono tsa̱ A̱sula̱ shi, zane ɗa aa laꞌa?” ");
INSERT INTO tswNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","A̱vu u usu le, “E ekere a vaɗilima̱ ili yu usa̱n i ɗa, amma e ekere a̱ A̱sula̱ shi. Babu ili i na A̱sula̱ a̱a̱ kuɗa̱ yuwan.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","A̱vu Bituru usu yi, “A̱tsu ɗa nda tsu lyawai ili suru, a̱vu tsu kuru wu.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","A̱vu u usu u damma, “Amayun a ɗa maa dansaa ɗu, za na lyawai uꞌwa wa̱ yi, ko dada va̱ yi, ko mma va̱ yi, ko u lyawai zakpara va̱ yi, ko vawun va̱ yi, ko gba u lyawai muwun ma̱ yi, ko ka va̱ yi, adama a̱ va̱ na Alabari a Saꞌani, she nu u tsura̱ atsupu. ");
INSERT INTO tswNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","A mantsa mo gogo, u ta̱ tsura̱ ꞌwa, na̱ a̱za̱ a̱ yi, na̱ muwun ma̱ a̱na̱wu, na̱ a̱ɗuma̱, na̱ muwun, ukpaku ukpaku. Amma waru a̱ ta̱ lyungwa̱ yi. Ɗe zuva† waru u ta̱ tsura̱ wuma u babu ukotu. ");
INSERT INTO tswNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","A̱za̱ e elime na̱ a̱bunda̱ a̱ ta̱ ka̱mba̱ a̱ca̱pa̱. A̱za̱ a̱ a̱ca̱pa̱ a̱ ta̱ ka̱mba̱ elime.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ele a̱tsuma̱ a mmalu a gawan Urishelima, Yesu ɗe elime e le, a̱vu ojoro yi ka̱ra̱ asalama. A̱vu ama a na oo tono yi, a̱ ka̱ra̱ o wovon. A̱vu waru u da̱shi ɗe ojoro a̱ yi, a̱vu u fara a dansaa le ili i na yaa cina yi. ");
INSERT INTO tswNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","A̱vu u damma, “A̱tsu ɗa nda a̱ tyo Urishelima, a ta ca Mawun ma Vuma e ekere a nan ganu a gbagbain na̱ munlu n Wila̱. A ta paɗaa yi ugana u na oo una yi, waru a ta zuwa yi e ekere a̱ a̱za̱ e iwuya. ");
INSERT INTO tswNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","A ta yuwaan yi ulamu reve a̱ tsuwa̱n yi ma̱tsa̱n. Waru a ta fufaba yi, a̱vu o una yi. Agba na a yuwan rana taꞌatsu, u ta̱ ꞌyon.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","A̱vu muwun ma̱ Za̱ba̱di, Yakubu na̱ Yahaya, a rawa zuzu na̱ a̱yi a damma, “Manlu tsu ciga wu ta̱, vu yuwaan tsu ili i na tsaa pati wu.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Reve we ece le, “Nye i cigai n yuwaan ɗu?” ");
INSERT INTO tswNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Reve a̱ usu, “Urana u na a̱ ꞌya̱sa̱n nuwu zuva na̱ tsugono, tsu ta ciga wu vu zuwa za ta̱ o ukere usaꞌani, za ta̱ o ukere ugula̱.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","A̱vu u usu le, “I reve ili i na yaa patishi shi. I ta gura sowo awuya a na moo sowo, a ta gura tsupu ɗu ununa a̱a̱ tsupu mu a awuya?” ");
INSERT INTO tswNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Reve a̱ usu a ta gura. A̱vu u usu le, “I ta gura sowo awuya a na moo sowo, ununa a̱a̱ tsupu mu ne ɗa a̱a̱ tsupu ɗu. ");
INSERT INTO tswNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Amma adama a na ya̱a̱ da̱nu o ugula̱ ko o usaꞌani, za va̱ ɗa shi na maa ca. A̱sula̱ a ɗa aa ca ba̱ta̱ na u foɓoyi aza a na a ɗangwai.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ana ojoro a̱ yi a uwwai ne, reve a uwa a̱tsumola̱ngu na̱ Yakubu na̱ Yahaya. ");
INSERT INTO tswNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","A̱vu u ɗe le, u damma le, “I reve ta̱ aza a na a zuwai o oꞌwo aza a tsugbain a ama o uvaɗi, a̱ ta̱ na̱ tsugbain a aci e le. ");
INSERT INTO tswNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ne ɗa woo oꞌwo e ekere a̱ ɗu shi. Za na cigai wo oꞌwo zagbain, she nu u ka̱mba̱to aciya̱yi aagbashi a̱ ɗu biti. ");
INSERT INTO tswNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Za na cigai u uwa elime a̱ ɗu, she nu u ka̱mba̱to aciya̱yi aagbashi a̱ ɗu suru. ");
INSERT INTO tswNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ko Mawun ma Vuma, u ta̱wa̱ tsa̱ra̱ a yuwaan yi tsugbashi shi. Amma tsa̱ra̱ u yuwan tsugbashi, waru u ca aciya̱yi, adama a wawa ama.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","A̱vu a rawa Jeriko. A̱yi o uta̱ Jeriko no ojoro a̱ yi no oɓolo a ama a̱bunda̱, a̱vu irumba̱ i ro i ta̱wa̱ zavipati aala a̱ yi Bartimawu, mawun ma Timawu. U tsu da̱nusu ta̱ a̱ ngeꞌen mu ure. ");
INSERT INTO tswNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ana wu uwwai Yesu va Nazara ta̱ lo a̱ ta̱wa̱, a̱vu u ꞌya̱sa̱n uɗyo wa̱ yi a dansa, “Yesu, Yesu, mawun ma̱ Da̱wuda, ka̱lyuwa̱ ununa n ri iliyali.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","A̱vu ama na̱ a̱bunda̱ a putsa yi, a dansaa yi u rungwa̱ una̱ wa̱ yi. Amma she ili i na i ꞌya̱wa̱i elime, a̱vu u da̱shi uta̱a̱ uɗyo a dansa, “Yesu, Yesu, mawun ma̱ Da̱wuda, ka̱lyuwa̱ ununa n ri iliyali.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","A̱vu wi isawan, reve u zuwa e ɗe yi. A̱vu e ɗe irumba̱ꞌa̱, a damma yi, “Yuwan ma̱za̱nga̱, u ta̱ ɗesu wu.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","A̱vu u vari aapalutsu a̱ yi, a̱vu u jika̱ a̱ ꞌya̱wa̱ uba̱ta̱ wa̱ Yesu. ");
INSERT INTO tswNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","A̱vu we ece yi, “Nye vu cigai n yuwaan wu?” A̱vu u usu yi, “Manlu, adama n tsura̱ me ene ure.” ");
INSERT INTO tswNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","A̱vu u usu yi, “Yuwan mmalu ma̱ wu, ucawu wo okolo a̱ wu u wawa wu ta̱.” Babu usa̱n, a̱vu esu a̱ yi a̱ kpa̱tuꞌwa̱, a̱vu u kuru Yesu a̱ ka̱ra̱. ");
INSERT INTO tswNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ele arawa Urishelima, zuzu na̱ lyuci va Batafaji na̱ Batanya, reve a rawa a Masasan ma̱ Zetun. Reve Yesu lyungu ama e re a̱tsuma̱ o ojoro a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Reve u damma le, “ꞌYa̱wa̱i a̱tsuma̱ a̱ ma̱lyuci ma na ma̱ ri elime a̱ ɗu, na̱ maꞌuwaa ma̱ ɗu i te ene molloli wunlu za na koto a kumbai shi. I ba̱ɗa̱ yi a̱ ta̱wa̱. ");
INSERT INTO tswNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Na̱ za ro ece ɗu, nye i zuwai yaa yuwusan ne? I damma yi, ‘Zagbain ɗa ciga niyi, amma wa̱a̱ la̱pa̱ ka̱mbuwa̱ yi shi.’ ” ");
INSERT INTO tswNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","A̱vu a̱ ka̱ra̱, reve a cina molloli a̱ ngeꞌen mu ure. ");
INSERT INTO tswNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ele a̱ ma̱ba̱ɗa̱ ma̱ yi, reve aza a na a̱ da̱na̱i lo mishin e ece le, “Nye ɗa i zuwai ya̱a̱ ba̱ɗa̱sa̱ yi?” ");
INSERT INTO tswNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","A̱vu a̱ usu le ili i na Yesu damma nle. Reve a̱ rungwa̱ le a̱ ka̱ra̱ na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Reve a̱ ta̱wa̱a̱ Yesu na̱ a̱yi, a̱vu o polo amuna e le o molloliꞌi. A̱vu u kumba ɗe. ");
INSERT INTO tswNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ama na̱ a̱bunda̱ ɗa o poloi amuna e le a̱tsuma̱ o ure, ozo o ro waru a baza a̱vuꞌun o ure, aza a na a kuɗai a atsusa. ");
INSERT INTO tswNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Aza a na a̱ da̱na̱i elime na aza a na a̱ da̱na̱i a̱ca̱pa̱, reve a̱ da̱na̱ e ishipa, “Husana!† “Abaꞌun a̱ tyo a za na a̱ ta̱wa̱ a ala† a̱ A̱sula̱! ");
INSERT INTO tswNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Abaꞌun a̱ tyo o tsugono tsa dada tsu Da̱wuda tsa na tsa̱ ri lo a̱ ta̱wa̱! “Husana a̱ tyo e ekere a̱ A̱sula̱!” ");
INSERT INTO tswNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Reve u uwa Urishelima, ɗaɗa u uwai a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗa. A̱vu u ka̱lyuwa̱ uba̱ta̱ suru. Ana wo oꞌwoi ulivu u ɗa, a̱vu wu uta̱ u ka̱mba̱ Batanya oɓolo no ojoro a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ana usana u tawai, a̱vu o uta̱ Batanya. U da̱na̱ ta̱ a uwwusa ambulu. ");
INSERT INTO tswNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ana we enei ubiri na̱ a̱vuꞌun a̱ a̱bunda̱, reve u ꞌya̱wa̱ tsa̱ra̱ u tsura̱ muwun u lyuwa. Ana u rawai, u ka̱lyuwa̱i biti, u cina ɗe ili shi, adama a na a mantsa ma na ubiri u tsu matsan ɗa shi. ");
INSERT INTO tswNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","A̱vu u damma ubiriꞌi, “She nanza da̱shi lyuwa muwun ma̱ wu wan, diga gogo.” Agba ojoro a̱ yi a̱ da̱na̱ ta̱ a uwwusa ili i na u dammai. ");
INSERT INTO tswNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Reve a rawa Urishelima.† Ana Yesu† uwai a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗa,† a̱vu u lo aza a na a̱ da̱na̱i atsulu na awina pe. Waru a̱vu wu keɓe apada a aza a na a̱ da̱na̱i a kitaꞌusa ikebe, a̱vu u baza otogu ni ili i na a̱ da̱na̱i a yuwusan ulinga, na aza a na a̱ da̱na̱i a winasa nrukuku. ");
INSERT INTO tswNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","U putsa ta̱ aza a na a̱ da̱na̱i ni itana a ɓatsa pe a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗa. ");
INSERT INTO tswNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","A̱vu u yuwaan le adanshi, “Ashe Adanshi a̱ A̱sula̱,† a damma, ‘Uꞌwa u va̱ uba̱ta̱ wa avasa adama a ama suru ɗa shi?’ Amma, a̱ɗu i ka̱mba̱to yi ta̱ uba̱ta̱ u na ya̱a̱ da̱na̱ a yuwusan wivu.” ");
INSERT INTO tswNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ana nan ganu a gbagbain na̱ munlu n Wila̱ me enei ili i na i farai, a̱vu a zami ure u na oo una yi. Agba a uwwa ta̱ wovon, adama a na ama suru a uwa ta̱ asalama na̱ cuꞌun vu uritosu wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nu ulivu, a̱vu Yesu lyawa lyuciꞌi. ");
INSERT INTO tswNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ele a̱ ma̱ka̱mba̱a̱ nu usana, reve e ene ubiri u na Yesu yuwayin una̱ u ꞌyewe a̱ tyo a aralu. ");
INSERT INTO tswNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","A̱vu Bituru gura cuwan na̱ cuꞌun vi ili i na i farai, a̱vu u damma, “Manlu, ka̱lyuwa̱ ubiri u na vu yuwayin una̱ꞌa̱ u ꞌyewe ta̱.” ");
INSERT INTO tswNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","A̱vu u usu le, “I usu A̱sula̱, amayun a ɗa maa dansaa ɗu, za na dammai masasan ma nda u mula̱ u riya̱ a̱tsuma̱ a mala no okolo a̱ yi a daꞌwan shi, amma u ca ta̱ okolo e ili i na u dammai, u to oꞌwo ne. ");
INSERT INTO tswNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","A̱yi ɗa i zuwai maa dansaa ɗu ili i na i patiyi suru a̱tsuma̱ a avasa, ni i ca okolo i ta̱ tsura̱. ");
INSERT INTO tswNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ni yi isawan a mantsa ma na yaa yuwan avasa, ni i ri o upan na̱ a̱za̱ a̱ ɗu, i yuwan gafura, tsa̱ra̱ Dada ɗu za na ri zuva a̱yi fo u yuwaan ɗu gafura. ");
INSERT INTO tswNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Amma ni i yuwaan za ɗu gafura shi, cine tsa ɗa Dada ɗu za na ri zuva waa yuwaan ɗu gafura vu unusu u ɗu?” ");
INSERT INTO tswNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Reve ana Yesu no ojoro a̱ yi a̱ ka̱mbisa̱i Urishelima a uwa ta̱ a̱ A̱a̱ꞌisamapaɗa. A̱yi pe a̱tsuma̱ a agara a̱ A̱a̱ꞌisamapaɗaꞌa reve nan ganu a gbagbain na̱ munlu n Wila̱ na azagbain a̱ ta̱wa̱ uba̱ta̱ wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Reve e ece yi, “Nu ucira u ne u ɗa vaa yuwusan ulinga u nda, waru zane ɗa ca nuwu a̱yi?” ");
INSERT INTO tswNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Reve Yesu usu le, “A̱mu fo n ta yuwan ɗu yeci, i usu mu. A̱mu waru n ta gura damma ɗu uba̱ta̱ u na cuꞌun vu ucira na maa yuwusan ulinga wu uta̱i. ");
INSERT INTO tswNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Urumbusu u na Yahaya† aa yuwusan, te ɗa wu uta̱i, uba̱ta̱ wa̱ A̱sula̱ ko uba̱ta̱ wu vaɗilima̱?” ");
INSERT INTO tswNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","A̱vu e reme mawasan va̱ni le, a damma “Na̱ tsu damma zuva ɗa wu uta̱i, u te ece tsu, ‘To nye i zuwai tsu cayi okolo shi?’ ");
INSERT INTO tswNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Na̱ waru tsu damma uba̱ta̱ wa ama ɗa wu uta̱i, u ta̱ ta̱wa̱a̱ tsu na addama.” A ta uwwusa wovon wa ama, adama a na ama e reve ta̱ Yahaya vumava̱sula̱† ɗa. ");
INSERT INTO tswNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","A̱vu a̱ usu yi, “Tsu reve shi.” A̱vu fo u usu le, “Maa damma ɗu uba̱ta̱ u na n tsura̱i ucira u na maa yuwusan ili i na maa yuwusan shi.” ");
INSERT INTO tswNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","A̱vu Yesu uwa a yuwusaan le adanshi ni iroci. Reve u damma, “Vuma ro ɗa cuwa̱in uɗuma̱ wa̱ inabi, a̱vu u suwaa yi uɓaɓu a̱ka̱nda̱ruwa̱. Reve waru u ka̱pa̱ a̱ka̱ri, tsa̱ra̱ u tsura̱ uba̱ta̱ u na wa̱a̱ da̱na̱ o kpokuso masayan. A̱vu u suwaa yi aburu, adama we eneshe ili i na i ri pe suru. Reve u ca aza a zamalinga uɗuma̱ꞌa̱, adama a linga yi. Reve u ka̱ra̱ a̱ ꞌya̱wa̱ mmalu a̱ lyuci ro. ");
INSERT INTO tswNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Ana mantsa mo ugasa ma rawai, reve u lyungu vuma ta̱ a̱tsuma̱ a agbashi a̱ yi u ꞌya̱wa̱ u ushi akunda e ili i na o ɓolotoi. ");
INSERT INTO tswNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","A̱vu aza a zamalingaꞌa e reme aagbashiꞌi, reve a lalapa yi reve a damma yi u ka̱mba̱ ekere lya̱nga̱. ");
INSERT INTO tswNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Reve za vu uɗuma̱ꞌa̱ u lyunguwisa̱ aagbashi o ro, a̱vu a lalapa yi lon. ");
INSERT INTO tswNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ana u lyunguwisa̱i aagbashi o ro, reve o una yi. Aza a na u koso lyunguwisa̱i na̱ a̱ca̱pa̱, a lalapa akapi, akapi gba o una le. ");
INSERT INTO tswNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“A̱vu wo oꞌwo vuma ta̱ ɗa shi buwai, a̱yi ɗa mawun ma̱ ta̱ ma̱ yi za na u cigai lon. A̱vu za vu uɗuma̱ꞌa̱ u koso lyungu yi a majiyan ne e ene yi, a ta uwwa wovon, a̱vu a yuwaan yi ili i na i lobonoi. ");
INSERT INTO tswNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ana e ene niyi, a̱vu a dammulai, ‘Ndeɗe magaji ma̱ ta̱ ma̱ yi a̱ ta̱wa̱, tsu una niyi adama uba̱ta̱ꞌa̱ wo oꞌwo uba̱ta̱ u tsu.’ ");
INSERT INTO tswNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Reve e reme mawuꞌun o una yi, a̱vu a vari yi a̱tsuma̱ o ogozo.” ");
INSERT INTO tswNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","A̱vu Yesu damma, “Cuꞌun majiyan ne ɗa yaa yuwusan za vu uɗuma̱ꞌa̱ waa yuwan? A̱yi za vu uɗuma̱ꞌa̱ u ta̱ ta̱wa̱ wu una le suru, a̱vu u ca aza a zamalinga o ro a linga uɗuma̱ꞌa̱. ");
INSERT INTO tswNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Koto i ɗenuna̱ ili i na Adanshi a̱ A̱sula̱ a dammai shi? ‘Aatali a na asuwi a ꞌyuwain, a̱yi ɗa wo oꞌwoi ikyun yu ucira a̱tsuma̱ o usaa. ");
INSERT INTO tswNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Zagbain ɗa yuwain ili i nda, waru u lobono ta̱ e esu a̱ tsu.’ ” ");
INSERT INTO tswNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Reve Afarishi† a zami ure u na ee reme yi adama a na e reve ta̱ u ta yuwusan adanshi a aciyele. Amma a ta uwwusa wovon wa ama, adama o ndolo a ɗa a lyawa niyi. Reve a saɓa ure u le. ");
INSERT INTO tswNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","A̱vu a̱ lyunguwa̱ yi ama o ro a̱tsuma̱ a Afarishi na ama a̱ Hiridu, tsa̱ra̱ e reme yi nu unusu a̱tsuma̱ a adanshi a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ana a rawai, reve e ece yi, “Manlu, a̱tsu tsu reve ta̱ a̱vu za va amayun a ɗa, waru vu ri na aɗangulu shi. Vu tara ta̱ ama suru una̱ta̱, vu to rocosu ure wa̱ A̱sula̱. Damma tsu u lobono ta̱ a tsupa utafa a̱ tyo ya Kaisa mogono ma̱ Roma† ko tsu tsupa wan?” ");
INSERT INTO tswNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ana u revei ili i na a cigai, reve u damma, “Nye i zuwai ya̱a̱ lyungusa̱ mu?” A̱vu u damma le, “Ta̱wa̱a̱ numu ni ikebe.” ");
INSERT INTO tswNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ana a̱ ta̱wa̱a̱ niyi, a̱vu we ece le, “Ululu wa zane u ɗa u ri ɗe?” Reve a̱ usu yi, “Ululu wa Kaisa u ɗa u ri ɗe.” ");
INSERT INTO tswNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ɗaɗa u damma nle, “I ca Kaisa† ili i na i ri ya Kaisa, A̱sula̱ waru a ca yi ili i na i ri za va̱ yi. Reve ama a̱ ka̱ra̱ a yuwusan asalama a̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Reve ama a na a̱ tsu ɗe aza a Sadukiya† aza a na a dammai na̱ vuma kuwa̱ u buwa a̱ ꞌyon shi, ele fo a̱ ta̱wa̱ uba̱ta̱ wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Reve a damma yi, “Manlu, Musa ɗanaa tsu ta̱, na̱ vuma kuwa̱, a̱vu u lyawa ka va̱ yi babu u matsan, a̱vu zawaꞌa va̱ yi sotso kaꞌa, tsa̱ra̱ u tsura̱a̱ yi mawun. ");
INSERT INTO tswNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","A yuwan ta̱ ama e cindere ali. Za vu ufaru yuwan ta̱ lolo, a̱vu u kuwa̱ babu u matsan. ");
INSERT INTO tswNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Reve za ve ire sotso yi, a̱yi fo u kuwa̱ babu mawun na̱ a̱yi. Za va taꞌatsu waru ne ɗa, ne ɗa a yuwusain. ");
INSERT INTO tswNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ele ama e cindereꞌe ko za tsura̱ mawun na̱ a̱yi shi. O ukosu, a̱vu fo kaꞌa u ta̱wa̱ u kuwa̱. ");
INSERT INTO tswNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","To o urana u na a̱a̱ ꞌya̱sa̱n a̱kwa̱kwa̱, ka va zane ɗa woo oꞌwo, adama a na wo oloi mecindere me le suru?” ");
INSERT INTO tswNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Reve u usu le, “Adama o ndolo a ɗa i puwa̱in. Adama a na i reve Adanshi a̱ A̱sula̱ shi, waru i reve ucira wa̱ A̱sula̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","O urana u na a̱a̱ ꞌya̱sa̱n a̱kwa̱kwa̱, babu adama o lolo. O to oꞌwo ununa nlingata ma̱ A̱sula̱ n ri, aa yuwan ɗe lolo shi. ");
INSERT INTO tswNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Koto i ɗenuna̱ ili i na aatagada a Musa a dammai shi, uba̱ta̱ u na u yuwain adanshi o molopu a madala, ana A̱sula̱ a dammai, ‘A̱mu ɗa A̱sula̱ a Ibrahim na̱ Ishiyaku na̱ Yakubu?’ ");
INSERT INTO tswNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","A̱yi A̱sula̱ a aza a wuma a ɗa, amma A̱sula̱ a̱ a̱kwa̱kwa̱ a ɗa shi. Amayun i puwa̱n ta̱ suru suru.” ");
INSERT INTO tswNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","A̱vu manlu ma̱ Wila̱† ma Musa ma̱ ta̱wa̱ ma uwwa le a mawasan va̱ni le. Ana we enei Yesu usu nle mejege, a̱vu we ece, “Wila̱ u ne u ɗa u laꞌai mgbain?” ");
INSERT INTO tswNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","A̱vu u usu yi, “Wila̱ u gbain a̱yi ɗa, ‘I polo atsuvu a̱ɗu muwun ma Israꞌila, A̱sula̱ mogono ma̱ tsu a̱yi ɗa A̱sula̱ goon. ");
INSERT INTO tswNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","I ciga A̱sula̱ no okolo a̱ ɗu suru, na asuvu a̱ ɗu, nu ucira u ɗu.’ ");
INSERT INTO tswNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Za ve ire a̱yi ɗa, ‘I ciga a̱za̱ a̱ ɗu ununa i cigai aciya̱ɗu.’ Ili i ro yi lo i laꞌai ndolo shi.” ");
INSERT INTO tswNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","A̱vu manluꞌu u usu yi, “Manlu amayun a ɗa wu, A̱sula̱ a̱ ta̱ a ɗa, za ro lo shi she a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","A ciga yi no okolo a̱ ta̱, na asuvu a̱ ta̱, nu ucira u tsu, a̱vu waru tsu ciga a̱za̱ a̱ tsu ununa tsu cigai aciya̱tsu. U laꞌa ta̱ wocosu wu mpasa nu ukula̱tosu.” ");
INSERT INTO tswNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ana Yesu enei ununa u usuyi mejege, reve u damma yi, “Vu ri alanga na̱ tsugono tsa̱ A̱sula̱ shi.” Ko za da̱shi yuwan yi yeci waru shi. ");
INSERT INTO tswNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu a̱tsuma̱ o uritosu a̱ A̱a̱ꞌisamapaɗa, a̱vu we ece le, “O una̱ wu nye munlu n dammai Kristi Zamawawa to uta̱ o ugundo wa̱ Da̱wuda? ");
INSERT INTO tswNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Agba Ruhu va Akiza zuwa ta̱ ɗe Da̱wuda damma: ‘A̱sulazuva a damma ta̱ Zagbain va̱: “Da̱nu o ukere usaꞌani u va̱, she na̱ n zuwa nꞌyuwatan ma̱ wu a apata a ana a̱ wu.” ’ ");
INSERT INTO tswNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Na̱ Da̱wuda na aciya̱yi u ɗe yi ‘Zagbain’, cine woo oꞌwo waru mawun ma tsukaya ma̱ Da̱wuda?” Ama na̱ a̱bunda̱ a uwwa ta̱ uyoꞌo wu uritosu wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","A̱tsuma̱ o uritosu wa̱ yi, a̱vu u damma le, “I yuwan ugbozu na̱ munlu n Wila̱.† ");
INSERT INTO tswNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Aza a na a cigai a̱ da̱na̱ a casu le tsugbain e eden uꞌwotowu na̱ a̱tugu a gaꞌan le, a̱ da̱na̱ a̱ da̱nusu a̱ nda̱na̱ta̱ koꞌo a̱ a̱ꞌisa̱, na̱ nda̱na̱ta̱ n saꞌani e eden. ");
INSERT INTO tswNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Aza a na a tsu ususa ili yi nruna̱. A̱vu a̱ da̱na̱ a yuwusan avasa o ugaɗi. A̱sula̱ a ta ca icuꞌun ya ama o ndolo a̱tsuma̱lima̱ lon.” ");
INSERT INTO tswNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","A̱vu Yesu da̱nu zuzu nu uzuwata wi ikebe a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗa. Reve u ka̱lyuwusa̱ ama a zuwusa ikebe. A̱za̱ o utsuru na̱ a̱bunda̱ a zuwusa ikebe ya̱ a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","A̱vu ma̱runa̱ mo ro me iliyali mo uta̱ ɗe, a̱vu u zuwa anini e re. ");
INSERT INTO tswNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Reve u ɗe ojoro a̱ yi, a̱vu u damma le, “Ma̱runa̱ me iliyali ma nda ma zuwa ta̱ ili i na i laꞌai ama suru. ");
INSERT INTO tswNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","A̱za̱ o utsuru a nda suru e kene ta̱ a̱tsuma̱ o utsuru u le. A̱yi gba ni iliyali ya̱ yi suru, reve u pura̱ suru ko ili u lyawa shi a̱vu u zuwa.” ");
INSERT INTO tswNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu o uta̱ a̱ A̱a̱ꞌisamapaɗa,† reve za ta̱ a̱tsuma̱ o ojoro a̱ yi u rawa uba̱ta̱ wa̱ yi, a̱vu u damma, “Manlu, ka̱lyuwa̱ cuꞌun vu usaa u saꞌani na atali† a nda!” ");
INSERT INTO tswNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Reve u usu yi, “Ye ene ta̱ cuꞌun vu usaa ndolo? Ko aatali a̱ ta̱ aa lyawa zuva vu za va̱ yi shi. Suru nle o to oco le e iɗa.” ");
INSERT INTO tswNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","A̱yi nden a masasan ma̱ Zetun za na da̱na̱i a̱ nka̱la̱la̱i na̱ A̱a̱ꞌisamapaɗa, reve Bituru na̱ Yakubu na̱ Yahaya na̱ Andarawu a yuwan yi yeci. ");
INSERT INTO tswNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","A damma, “Damma tsu mantsa ma na ili i ndolo yaa fara. Waru damma tsu ili i na yaa fara o ukosu.” ");
INSERT INTO tswNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","A̱vu u damma le, “I yuwan ugbozu she i lyawa nanza yuwan ɗu tsulo wan. ");
INSERT INTO tswNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ama na̱ a̱bunda̱ a̱ ta̱ ta̱wa̱ na aala a̱ va̱ a damma ele ɗa Kristi Zamawawaꞌa. Reve a damma ɗu, ‘A̱mu ɗa,’ o to polo ama na̱ a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","She okolo a̱ ɗu a daꞌwan wan, na̱ yu uwwa alabari o uvon zuzu ko alanga. She na a yuwan ili i ndolo suru, amma ukosu u ɗa shi. ");
INSERT INTO tswNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Iɗa i ta yuwan nla̱ngi ni iɗa. Tsugono tsu ta yuwan nla̱ngi na̱ tsugono. A ta yuwan ura̱mosu wi iɗa a̱bunda̱. Ambulu a ta yuwan a̱bunda̱. Ili i nda suru u to rocosu ufaru wu ukosu wu uvaɗi. ");
INSERT INTO tswNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“I yuwan ugbozu na aciya̱ɗu. E te reme ɗu a̱ ꞌya̱wa̱to ɗu o ukobu wu ugeꞌetosu adama a̱ va̱. A ta fufaba ɗu a̱ a̱ꞌisa̱. A̱ ta̱ ꞌya̱wa̱to ɗu a̱ ma̱ka̱ka̱n mo ngono na̱ a̱za̱ o ugeꞌetosu, adama a̱ va̱. I damma le adama a Alabari a Saꞌani. ");
INSERT INTO tswNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Amma kafu ukosu wu uvaɗi, a ta yuwan alajiya a Alabari a Saꞌani a̱ va̱ a̱tsuma̱ o uvaɗi suru. ");
INSERT INTO tswNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na a tara ɗu a̱ tyo uba̱ta̱ o ugeꞌetosu, she yi daꞌwan o una̱ wi ili i na ya̱a̱ usu le wan. Na̱ mantsa ma rawa, o to roco ɗu ili i na yaa damma. Ili i na yaa damma yoo uta̱ o una̱ u ɗu shi, Ruhu va akiza† to roco ɗu ili i na yaa damma. ");
INSERT INTO tswNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Vuma ta wina mawun ma̱ a̱na̱wu ma̱ yi adama o una yi. Nan dada waru a ta yuwaan ne muwun n le. Muwun n ta ꞌyuwan mbara n le na̱ mukuci n le, tsa̱ra̱ o una le. ");
INSERT INTO tswNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ama suru a ta ꞌyuwan ɗu adama a̱ va̱. Amma za na isawain ugbamu, a̱ tyo o ukosu u ta laꞌa. ");
INSERT INTO tswNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Mantsa ma̱ ta̱ lo a̱ ta̱wa̱ a na yee ene za na a yuwusan ili yi idaba a̱ ma̱ka̱ka̱n ma̱ A̱sula̱ a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗa, uba̱ta̱ u na wu ntsayi shi ununa Daniyan dammai.” (Za vu ɗesununa̱ u yuwan ugbozu.) “Reve aza a na a̱ ri a̱tsuma̱ a Yahuda a suma a̱ tyo a nsasan. ");
INSERT INTO tswNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Za na ri zuva vu ukwa̱ꞌa̱, she u cipa̱ u uwa o uꞌwa wa̱ yi, tsa̱ra̱ u tara ili i ro a̱tsuma̱ o uꞌwa wan. ");
INSERT INTO tswNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Za na ri ɗe o uɗuma̱, she u ka̱mba̱ o uꞌwa, tsa̱ra̱ u tara aapalutsu a̱ yi wan. ");
INSERT INTO tswNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","U ta suɗuwa a̱ma̱ci a na a̱ ri na̱ a̱tsuma̱ oɓolo na̱ a̱ma̱ci a na a̱ ri na̱ muwun n na ma apasa maani. ");
INSERT INTO tswNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","“She i yuwan avasa, tsa̱ra̱ ili i ndolo i fara na̱ lyushi wan. ");
INSERT INTO tswNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","A̱tsuma̱ a rana ndolo, o to oꞌwo rana va̱ a̱tsuma̱lima̱ lon, cuꞌun na koto a yuwain shi, ana A̱sula̱ a yuwain uvaɗi u nda. A̱ da̱shi waru cuꞌun va̱ yi shi. ");
INSERT INTO tswNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Amma A̱sula̱ e jebe ta̱ rana ndolo, na̱ ne ɗa shi, ko za aa laꞌa shi. Agba adama a aza a na waru A̱sula̱ a ɗangwai, ɗaɗa e jebei rana ndolo. ");
INSERT INTO tswNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Na̱ za ro damma ɗu, ‘Ndeɗe Zamawawa,’ ko ‘Apa yi,’ she i usu wan. ");
INSERT INTO tswNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Adama a na azamawawa e epen na ama̱sula̱ e epen, a̱ ta̱ ta̱wa̱. A ta gura yuwan ili ya asalama na̱ a̱bunda̱, tsa̱ra̱ o polo aza a na a ɗangwai n na aa gura. ");
INSERT INTO tswNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Amma i yuwan ugbozu n damma ɗu ta̱ ɗe ili i na yaa fara suru. ");
INSERT INTO tswNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Amma a̱tsuma̱ a rana ndolo, na̱ mantsa ma̱ a̱tsuma̱lima̱ lon mo koto, urana u to oꞌwo irumbu, woto waru wa̱a̱ da̱na̱ ne ekan shi. ");
INSERT INTO tswNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Italyoꞌo waru i ta̱ da̱na̱ a̱ riya̱sa̱ e iɗa. A̱ ta̱ jinga̱ɗa̱ cira na ri zuva. ");
INSERT INTO tswNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Reve ee ene Mawun ma Vuma a̱ ta̱wa̱ e eleshe nu ucira na̱ tsugono tsa̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Reve u lyungu nlingata ma̱ A̱sula̱, tsa̱ra̱ o ɓoloto ojoro a̱ yi, aza a na u ɗangwai uba̱ta̱ suru, diga o ufaru wu uvaɗi a̱ tyo o ukosu. ");
INSERT INTO tswNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“I rito ili i ro o uɗanga wu ubiri. Na̱ yee ene a̱vuꞌun a̱ yi a vadalasa, a yuwusan ototopi, i reve lyushi yuwan ta̱ zuzu. ");
INSERT INTO tswNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ne ɗa waru na̱ yee ene ili i nda a farasa, i reve u yuwan ta̱ zuzu na̱ ma̱ta̱wa̱a̱, u ta̱ lo o una̱ntsutsu. ");
INSERT INTO tswNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Amayun a ɗa maa dansaa ɗu, uvaɗi u nda woo koto shi, she ni ili i na a dammai nda suru a shiwan. ");
INSERT INTO tswNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Zuva ni iɗa o to koto, amma adanshi a̱ va̱ oo koto shi. ");
INSERT INTO tswNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Amma adama o urana u ndolo, ko mantsa babu za na revei, ko nlingata ma̱ A̱sula̱, ko Mawuꞌun, she Dada va̱ yi goon. ");
INSERT INTO tswNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","I yuwan ugbozu waru i yuwan avasa adama a na i revei mantsaꞌa shi. ");
INSERT INTO tswNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“U to oꞌwo cine vuma tsu da̱na̱ mocin e iɗa i ro u lyawa ta̱ ɗe uꞌwa wa̱ yi, reve u ca agbashi a̱ yi ucira, suru nle waru u ca le ta̱ ulinga u na aa yuwan. Reve u damma za vi ipiri u ka̱lyuwa̱ ulobonu. ");
INSERT INTO tswNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","I da̱na̱ ufoɓu adama a na i revei mantsa ma na zavuꞌwaꞌa wa̱a̱ ta̱wa̱ shi. Ko nu ulivu, ko nu urana, ko e memere ma ayin, ko nu usana. ");
INSERT INTO tswNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nu u ta̱wa̱ she u cina ɗu a nlavu wan. ");
INSERT INTO tswNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ili i na maa dansaa ɗu, a̱yi ɗa i da̱na̱ ufoɓu.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Rana re ɗa shi buwai, ana aa yuwan A̱buki a Mapasa oɓolo na̱ A̱buki o Opopofu.† A̱vu nan ganu oɓolo na̱ munlu n Wila̱ a zami ure u na ee reme Yesu nu unusu, tsa̱ra̱ o una yi. ");
INSERT INTO tswNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Reve a damma, “Tsoo una niyi a mantsa ma̱ a̱buki shi, adama ama a̱ ꞌya̱sa̱n uvon wan.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu pe o uꞌwa wa̱ Simo Ma̱kutu a lyuwusa ilyalya a̱ lyuci va Batanya, a̱vu ka ro uta̱ ɗe na̱ maniꞌin ma̱ ma̱guru me ikebe lon. Reve u ɓala ikpa̱ta̱tsu i medeꞌen, reve u tsuwa̱n Yesu a aaci. ");
INSERT INTO tswNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Aza a na a̱ da̱na̱i lo, a̱vu a uwwa upan. Reve a damma, “Cine tsa ɗa wa̱a̱ lungusa̱ maniꞌiꞌin? ");
INSERT INTO tswNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Na̱ a̱ shi a wina yi, a̱ shi ta̱ ushi ili i na i laꞌai ikebe i na i rawai ikebe yu ulivu ukpakutaꞌatsu (300), a̱vu a ca a̱za̱ o ulambu ikebeꞌe.” A̱vu a uwa upan na̱ a̱yi, reve a ɓara yi. ");
INSERT INTO tswNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","A̱vu Yesu damma le, “Rungwa̱ niyi, cine tsa ɗa yaa damatosun yi? U yuwaan mu ta̱ ili i na i lobonoi. ");
INSERT INTO tswNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","I to oɓolo na alambi kuci, mantsa ma na i cigai suru, i ta gura yuwaan le ili i saꞌani. A̱mu gba ma̱a̱ da̱na̱ na̱ ɗu kuci shi. ");
INSERT INTO tswNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","U yuwan ta̱ ili i na waa gura yuwan, u tsun ta̱ lipu va̱ maniꞌin kafu mantsa ma̱ a̱ciɗa̱. ");
INSERT INTO tswNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Amayun a ɗa maa dansaa ɗu, uba̱ta̱ u na aa yuwan alajiya a Alabari a Saꞌani a̱tsuma̱ o uvaɗi u nda suru, ee icina ili i na ka nda u yuwaan numu shi.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","A̱vu Yahuza Iskariyoti, a̱tsuma̱ a Kupanejere, u ꞌya̱wa̱ uba̱ta̱ u nan ganu a gbagbain, tsa̱ra̱ u winaa le Yesu. ");
INSERT INTO tswNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ana a uwwai ne, a̱vu a̱ za̱nga̱na̱. A̱vu a yuwaan yi nzuwulai, a ta ca yi ikebe lon. A̱vu u zamishi ure u na waa wina yi. ");
INSERT INTO tswNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","O urana wu ufaru u na a yuwain A̱buki o Opopofu,† urana u mapaɗa me ikyon i Mapasa,† a̱vu ojoro a̱ yi e ece yi, “Te ɗa vu cigai tsu foɓoo wu ilyalya ya̱ a̱bukiꞌi?” ");
INSERT INTO tswNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","A̱vu u lyungu ojoro e re a̱ yi, u damma le, “Uwai a̱ lyuci, i ta gaꞌan na̱ vuma utanuwu na̱ a̱a̱ka̱bu a̱ mini, a̱vu i toni yi. ");
INSERT INTO tswNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Uꞌwa u na u uwai suru, i damma za vu uꞌwaꞌa, ‘Manlu ma damma, te ɗa aasula a na a̱mu no ojoro a̱ va̱ tsaa lyuwa ilyalya ya̱ a̱buki?’ ");
INSERT INTO tswNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","U to roco ɗu uꞌwa wa zuva, i foɓo ununa u lobonoi i yuwan, tsa̱ra̱ i foɓoo tsu.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Reve a̱ ka̱ra̱, ɗaɗa e enei ili i na Yesu damma nle ununa u dammai. A̱vu o foɓo ilyalya i Mapasaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ana ulivu u yuwain, reve u ta̱wa̱ oɓolo no ojoro a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ele a̱tsuma̱ a alya e ilyalya, a̱vu u damma, “Amayun a ɗa maa dansaa ɗu, a̱tsuma̱ a̱ ɗu vuma ta̱ ta wina mu, waru za na tsaa lyuwusa uba̱ta̱ u ta̱ u ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","A̱vu a uwa a̱tsumola̱ngu a dansa a̱za̱ ta̱ ta̱, “A̱mu ɗa, a̱mu ɗa?” ");
INSERT INTO tswNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","A̱vu u damma le, “A̱tsuma̱ a̱ ɗu za ta̱ ɗu ta wina mu, za na tsaa lyuwusa a mapara ma̱ ta̱. ");
INSERT INTO tswNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mawun ma Vuma† ma̱ ta̱ kuwa̱ cine u ri uɗanu. Woo yoꞌono za na aa wina Mawun ma Vumaꞌa shi. Na̱ a̱ shi a matsan yi shi, u shi ta laꞌaa yi.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ele pe a alya, a̱vu u tara opopofu u yuwaan A̱sula̱ ma̱za̱nga̱. A̱vu wu busa u ca le u damma, “Ushiyi, lipu va̱ ɗa ndaꞌa.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ana u tarai mokoto ma masayan ma inabi,† a̱vu u yuwaan A̱sula̱ ma̱za̱nga̱. A̱vu u damma, “Ushiyi,” a̱vu o sowo. ");
INSERT INTO tswNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","A̱vu u damma le, “Mpasa nda mpasa n va̱ n ɗa na n zuwai A̱sula̱ a yuwain akucunu,† adama oo oco mpasa adama a wawa ama na̱ a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Amayun a ɗa maa dansaa ɗu, ma̱a̱ da̱shi sowo masayan waru shi, she za na moo sowo o tsugono tsa̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ana a yuwain ishipa yi ica, a̱vu o uta̱ a̱ tyo a Masasan ma̱ Zetun. ");
INSERT INTO tswNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","A̱vu u damma le, “Suru nɗu i ta̱ beteꞌwe adama a na ne ɗa A̱sula̱ a dammai a̱tsuma̱ a Adanshi a̱ A̱sula̱ ana: ‘N to una za va aguɓa, a̱vu ikyon i beteꞌwe.’ ");
INSERT INTO tswNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Amma na̱ a̱ ꞌya̱sa̱n mu, n ta fara ꞌya̱wa̱a̱ ɗu Ga̱lili.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","A̱vu Bituru usu, “Maa lyawa wu shi, ko na aa lyawa wu.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","A̱vu u usu Bituru, “Kafu moton ma saala ure na ayin a nda, vu ta wasan mu utaꞌatsu.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","A̱vu Bituru usuwisa̱ nu ucira, “Ko keꞌen maa wasan wu shi, ko na̱ ma̱a̱ kuwa̱ oɓolo na̱ a̱vu.” Reve akapiꞌi fo a damma ne. ");
INSERT INTO tswNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","A̱vu a rawa uba̱ta̱ u na a̱ tsu ɗe Getisemeni. A̱vu u damma ojoro a̱ yi, “Da̱nuyi pa n ta yuwan avasa.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","A̱vu u tara Bituru na̱ Yakubu na̱ Yahaya. A̱vu iliꞌi i uwa a damatosun yi, a̱vu u uwa a̱tsumola̱ngu lon. ");
INSERT INTO tswNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","A̱vu u damma le, “A̱tsumola̱ngu a̱ va̱ a yuwan ta̱ a̱bunda̱ lon, gashi wu una mu. Puro numu pa i da̱na̱ ufoɓu.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ana u ꞌya̱wa̱i malanga, a̱vu u riya̱ e iɗa, a̱vu u yuwan avasa u damma, n na̱ waa yuwan, a tawa yi mantsa mo ndolo. ");
INSERT INTO tswNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Reve u damma, “Dada, ya̱ꞌa̱ wu ili suru ili i mayuwaan ma ɗa. Tawa mu a̱tsuma̱lima̱ a nda. Amma she vu kuru ili i na n cigai wan, amma ili i na vu cigai.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ana u ka̱mba̱i, a̱vu u cina le a nlavu. A̱vu u damma Bituru, “Bituru, nlavu n ɗa yaa yuwusan, yaa gura piri ko rumu ta̱ shi?” ");
INSERT INTO tswNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","A̱vu u damma le, “Da̱nuyi ufoɓu tsa̱ra̱ i riya̱ a̱tsuma̱ a̱ ma̱lyungwa̱ wan. Asuvu a ciga ta̱ amma lipu ri nu ucira shi.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","A̱vu u ꞌya̱wisa̱ u yuwan avasa, a dansa ili i ta̱. ");
INSERT INTO tswNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Reve u ta̱wisa̱ uba̱ta̱ u le. A̱vu u cinisa le a nlavu, a gura kpa̱tuꞌwa̱ esu e le shi. A gura reve ili i na aa damma yi shi. ");
INSERT INTO tswNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ana u ta̱wa̱i uta̱wu wa taꞌatsu, a̱vu u damma le, “I buwa ta̱ a nlavu na̱ wivuwusan? U rawa ta̱ ne, mantsa ma rawa ta̱. A ca ta̱ Mawun ma Vuma e ekere a̱ a̱za̱ o unusu. ");
INSERT INTO tswNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ꞌYoyin tsu ka̱ra̱i. Ye ene ndolo za na wina numu rawai.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu a̱tsuma̱ a adanshi, a̱vu Yahuza Iskariyoti a̱tsuma̱ a Kupanejere, u rawa, ugeru no oɓolo a ama no oloko nu mutsun mu peꞌeni. Nan ganu a gbagbain, na̱ munlu n Wila̱, na azagbagbain e le suru o ɓoloto ta̱. ");
INSERT INTO tswNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Za na wina niyi u ca le ta̱ ɗe iroci yi ili i na waa yuwan, u damma, “Vuma na n katalai a̱yi ɗaɗa. I reme yi i ka̱ra̱ na̱ a̱yi.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ana Yahuza rawai, a̱vu u ꞌya̱wa̱ uba̱ta̱ wa̱ yi. A̱vu u damma, “Manlu.” A̱vu u katala yi. ");
INSERT INTO tswNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Reve e reme Yesu. ");
INSERT INTO tswNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","A̱tsuma̱ a aza a na a̱ da̱na̱i lo mishin, a̱vu vuma ta̱ tala matsun me peꞌeni u koɗo utsuvu wa aagbashi wa aabara a nan ganu. ");
INSERT INTO tswNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","A̱vu we ece le, “Yu uta̱ ta̱ ɗe ni ilaɗi no oloko adama i reme mu ana za vu nga̱la̱la̱i? ");
INSERT INTO tswNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","N tsu da̱na̱ ta̱ na̱ a̱ɗu a̱ A̱a̱ꞌisamapaɗa kuci, agba i reme mu shi. A yuwan ta̱ ne, tsa̱ra̱ Adanshi a̱ A̱sula̱ aa shiwan.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Lo ɗa ojoro a̱ yi a suma a paꞌain, a̱vu a lyawa yi lo. ");
INSERT INTO tswNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","A̱vu ulobo u ro u toni yi diga a̱yi she aapalutsu. A̱vu a gbagbala yi. ");
INSERT INTO tswNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ɗaɗa u lyawa nle aapalutsuꞌu, a̱vu u suma aataɓu. ");
INSERT INTO tswNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","A̱vu a tara Yesu a̱ tyo uba̱ta̱ wa aabara a nan ganu, a̱vu nan ganu a gbagbain† na azagbagbain na̱ munlu n Wila̱ o ɓoloto. ");
INSERT INTO tswNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","A̱vu Bituru tonishi yi alanga, hali u uwa o uꞌwa wa aabara a nan ganuꞌu. A̱vu u da̱nu zuzu na̱ a̱duga̱ri a̱ A̱a̱ꞌisamapaɗa a lyasuwusa akina. ");
INSERT INTO tswNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","A̱vu nan ganu a gbagbain a zamishi ure u na a̱a̱ tsura̱ Yesu nu unusu, tsa̱ra̱ a̱ tsura̱ ure u na oo una yi. Agba a̱ tsura̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Na̱ a̱bunda̱ a yuwaan yi ta̱ epen, amma adanshi e le a̱ ta̱wa̱ a̱ ta̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Na̱ a̱ca̱pa̱ a ɗa waru ozo o ro a̱ ꞌyoyin, a̱vu waru a yuwaan yi epen. ");
INSERT INTO tswNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tsu uwwa yi ta̱ u dammai u to ɓoso A̱a̱ꞌisamapaɗaꞌa za na ama a suwai, a̱vu u suwa yi a̱tsuma̱ a rana taꞌatsu, waru usaa u vuma u ɗa shi.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Hali n gogo adanshi e le a̱ ta̱wa̱ a̱ ta̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","A̱vu aabara a nan ganu a̱ ꞌyon e memere me le. A̱vu we ece yi, “Vu ri ni ili i na va̱a̱ usu e ili i na ama a dammai adama a̱ wu shi?” ");
INSERT INTO tswNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","A̱vu u rungwa̱ kuci kuci, u yuwan adanshi shi. A̱vu waru aabara a nan ganu e ecishe yi, “A̱vu ɗa Zamawawaꞌa, Mawun ma̱ A̱sula̱?” ");
INSERT INTO tswNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","A̱vu Yesu usu yi, “A̱mu ɗa. I te ene Mawun ma Vuma nden o ukere usaꞌani wa̱ A̱sula̱, waru u ta̱ ta̱wisa̱ e eleshe.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","A̱vu aabara a nan ganu a kakara itana ya̱ yi. A̱vu u damma “Adanshi a̱ ne waru tsu cigai uba̱ta̱ wa̱ yi? ");
INSERT INTO tswNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yu uwwa yi ta̱ a yuwusan adanshi a vama e ekere a̱ A̱sula̱. Cine tsa ɗa ye enei?” A̱vu a paɗa ugana a na oo una yi. ");
INSERT INTO tswNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","A̱vu ozo o ro a uwa a̱ tsuwusa̱n yi ma̱tsa̱n, a̱vu a pala yi esu a̱ ka̱ra̱ a̱ cikusa̱ yi a dansa, “Damma tsu ili i na i farai.” A̱vu waru a̱duga̱ri a ɓuɓasa yi. ");
INSERT INTO tswNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Bituru lo zuzu na aabala o uꞌwa, a̱vu aagbashi a̱ ta̱ a̱tsuma̱ a agbashi e esheli a aabara a nan ganu a rawa. ");
INSERT INTO tswNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ana we enei Bituru a lyasuwusa akina, a̱vu u ka̱lyuwa̱ yi mejege. A̱vu u damma, “A̱vu fo vu to oɓolo na̱ Yesu vuma va Nazara.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","A̱vu u wasan u damma, “N reve yi shi, n reve ili i na vaa dansa shi.” A̱vu wu uta̱ o ukobu, ɗaɗa moton ma saalai. ");
INSERT INTO tswNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","A̱vu aagbashi o usheliꞌi we ene yi, a̱vu u dansaa aza a na a̱ ri lo mishin, “Vuma ndaꞌa fo a̱tsuma̱ e le a ɗa u ri.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","A̱vu u wasisan. A jima lon shi, ɗaɗa aza a na a̱ ri mishin lo a dammai Bituru, “A̱vu fo toni va̱ yi ɗa adama a na a̱vu vuma va̱ Ga̱lili ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","A̱vu u uwa akucunu, nu u dansai, “N reve vumaꞌa shi.” ");
INSERT INTO tswNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","U jima shi, ɗaɗa moton ma saalai ire. A̱vu Bituru cuwan ni ili i na Yesu damma niyi ana u damma niyi, kafu moton ma saala ure, u ta wasan yi utaꞌatsu. Ana u cuwain ne, ɗaɗa u ɓoshoi na̱ mesun. ");
INSERT INTO tswNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na̱ wasasa a̱vu nan ganu a gbagbain na̱ munlu n Wila̱ o ɓoloto Azagbain a Mbara,† reve a yuwan a̱sa̱la̱. A̱vu a̱ nla̱ Yesu, a̱vu a̱ ka̱ra̱ na̱ a̱yi a̱ tyo ya Bilatu† Gwamna. Reve a ca Bilatu a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","A̱vu Bilatu ece yi, “A̱vu ɗaɗa mogono ma aza a Israꞌila?” A̱vu Yesu usu, “Ununa vu dammai ne ɗaɗa u ri.” ");
INSERT INTO tswNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ili ya̱ a̱bunda̱ i ɗa nan ganu a gbagbain a̱ ꞌya̱wusa̱yi na adanshi a aci a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","A̱vu Bilatu ecishe yi, “Vu ri ni ili i na va̱a̱ usu shi? Ka̱lyuwa̱ ili i na a̱a̱ ta̱wusa̱a̱ adama a̱ wu.” ");
INSERT INTO tswNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Agba u yuwisan adanshi o ro shi, hali Bilatu uwa asalama. ");
INSERT INTO tswNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","A̱tsuma̱ a rana va̱ A̱buki a Mapasaꞌa, Bilatu tsu ba̱ɗa̱a̱ le ta̱ vuma ta̱ a̱tsuma̱ a aza a na a̱ nla̱i. ");
INSERT INTO tswNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","A̱tsuma̱ a aza a na a̱ shi wunlu Baraba da̱na̱ ta̱ pe ana e reme nle a̱tsuma̱ a aza a na o unai ama a mantsa ma̱ nla̱ngi. ");
INSERT INTO tswNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","A̱vu ama a̱ a̱bunda̱ o ɓoloto a patishi yi u lyawaa le aza a na wu nla̱i ununa u tsu yuwusan. ");
INSERT INTO tswNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","A̱vu Bilatu† ece, “N lyawaa ɗu mogono ma aza a Israꞌila?” ");
INSERT INTO tswNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","U reve ta̱ adama e iꞌima̱ i ɗa nan ganu a gbagbain e remei Yesu. ");
INSERT INTO tswNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Reve nan ganu a gbagbain a zuwa ama a saala a̱ ba̱ɗa̱a̱ le Baraba. ");
INSERT INTO tswNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","A̱vu we ece le, “To cine maa yuwan na̱ Yesu za na i ɗeyi mogono ma aza a Israꞌila?” ");
INSERT INTO tswNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","A̱vu a saala, “A vara yi a akpata.”† ");
INSERT INTO tswNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","A̱vu Bilatu ece le, “Nye i ɗa i zuwai? Unusu u ne u ɗa u yuwain?” Ele gba a saalisa yi, “A vara yi a akpata.” ");
INSERT INTO tswNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Adama a na u cigai ama aa uwwa uyoꞌo, a̱vu u damma a̱ ba̱ɗa̱a̱ le Baraba. Reve u zuwa a̱soja a faba Yesu na asuɗu o ugbamu, a̱vu u zuwa le a vara yi a akpata. ");
INSERT INTO tswNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","A̱vu a̱soja a uwato yi a aabala o ukobu wu ugeꞌetosu, a̱vu e ɗe akapi a̱ a̱sojaꞌa suru. ");
INSERT INTO tswNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","A̱vu o oto yi aayala saan da̱a̱n-da̱a̱n ana mogono, a̱vu waru a yuwaan yi ookokolo a awanda,† a̱vu o oto yi. ");
INSERT INTO tswNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","A̱vu a̱ ca̱sa̱sa̱ yi, a dansa, “A̱ ca̱sa̱ wu mogono ma aza a Israꞌila.” ");
INSERT INTO tswNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","A̱vu a̱ ga̱la̱ yi a aaci no owoꞌo. Waru a̱vu a̱ tsuwa̱n yi ma̱tsa̱n. A̱vu a̱ kingyo a ciɓalasa yi. ");
INSERT INTO tswNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ana a yuwaan niyi ulamu, a̱vu o foɗo yi aayalaꞌa, a̱vu o oto yi itana ya̱ yi. Reve a̱ ꞌya̱wa̱to yi uba̱ta̱ u na aa vara yi a akpata. ");
INSERT INTO tswNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Vuma na a̱ tsu ɗe Simo vuma va Kurani, dada va Iskandari na̱ Rufo, cina wu uta̱ ɗe upasuꞌu, a̱ ka̱ra̱. Reve a zuwa yi u toni le adama u tanu akpataꞌa.† ");
INSERT INTO tswNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","A̱vu a̱ ta̱wa̱ na̱ a̱yi uba̱ta̱ u na a̱ tsu ɗe Gologota,† ana uba̱ta̱ wo okoluwo. ");
INSERT INTO tswNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","A̱vu o ɓolo mini ma alamu na̱ a̱guma̱ a na a̱ tsu ɗe mur,† a̱vu a ca yi tsa̱ra̱ u sowo. A̱yi gba u ꞌyuwan. ");
INSERT INTO tswNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","A̱vu a vara yi a akpata,† reve e neꞌeshen itana ya̱ yi va̱ni le. Reve a zuwa aɗanga, tsa̱ra̱ e reve ili i na vuma suru aa tara. ");
INSERT INTO tswNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Rumu kucci ɗa da̱na̱i nu usana a mantsa ma na a vara niyi a akpata. ");
INSERT INTO tswNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","A̱vu a yuwan ɗe iɗana yi icuꞌun vu unusu wa̱ yi zuva ana: Mogono ma aza a Israꞌila. ");
INSERT INTO tswNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Oɓolo na̱ a̱yi ɗa waru a varai evu e re a akpata. Za ta̱ o ukere usaꞌani za ta̱ gba o ukere ugula̱.  ");
INSERT INTO tswNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Adanshi a̱ A̱sula̱† a shiwan ta̱, za na dammai: “A̱vu e kece yi a̱tsuma̱ a̱ a̱za̱ o unusu.” ");
INSERT INTO tswNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Aza a na a̱ ka̱ra̱sa̱i lo, a̱vu a yuwaan yi ulamu a lumgbatsasa aci e le, a dansa, “Ashe a̱vu vu ta gura ɓuɓoso A̱a̱ꞌisamapaɗa, a̱vu waru vu suwisa yi a̱tsuma̱ a rana taꞌatsu. ");
INSERT INTO tswNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Wawa aciya̱wu, vu cipa̱ e iɗa.” ");
INSERT INTO tswNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ne ɗa waru nan ganu a gbagbain a yuwaan niyi ulamu oɓolo na̱ munlu n Wila̱, a dansa, “U wawa ta̱ ozo o ro, agba u gura wawa aciya̱yi shi. ");
INSERT INTO tswNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Lyawa Kristiꞌi Zamawawa, mogono ma aza a Israꞌila, u cipa̱ ɗe gogo a akpataꞌa, tsa̱ra̱ tsee ene adama tsu ca okolo.” Aza a na fo a vara nle oɓolo, e isula yi ta̱ fo. ");
INSERT INTO tswNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ana urana u rawai a aci, a̱vu irumbu i ɓa̱ru iɗaꞌa ma̱ɓula̱ a̱ tyo rumu taꞌatsu vu ulivu. ");
INSERT INTO tswNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ana rumu taꞌatsuꞌu u yuwain, a̱vu Yesu uta̱a̱ uɗyo, a̱vu u saala, “Eloi, Eloi, lama sabaktani.” Nga, “A̱sula̱ a̱ va̱, A̱sula̱ a̱ va̱, cine vu vari numu?” ");
INSERT INTO tswNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ozo o ro ana a̱ da̱na̱i lo mishin uba̱ta̱ꞌa̱, ana a uwwai ne, a̱vu a damma, u te ɗesu va Iliya. ");
INSERT INTO tswNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","A̱vu za ro suma u tsupu ashiɗi a̱ mini ma alamu ma na ma̱ ri e medele, a̱vu u ca yi u sowo. A̱vu a damma, “Lyawai tse ene ko Iliya ta gura wawa yi.” ");
INSERT INTO tswNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","A̱vu u saala lon, ɗaɗa u kuwa̱i. ");
INSERT INTO tswNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Umuna u na u da̱na̱i pe a̱ A̱a̱ꞌisamapaɗa Upasa wa Akiza, a̱vu u kara diga zuva a̱ tyo e iɗa. ");
INSERT INTO tswNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Soja gbain na da̱na̱i lo mishin, we ene ta̱ ununa u kuwa̱i. A̱vu u damma, “Amayun Mawun ma̱ A̱sula̱ ma ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","A̱ma̱ci a̱ da̱na̱ ta̱ lo a̱ a̱ka̱nla̱ a̱ yi alanga, ele ɗa Meri† Magadaliya, na̱ Meri mma va Yakubu keꞌen na̱ Isuhu, oɓolo na̱ Solomi. ");
INSERT INTO tswNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ele ɗa o toni niyi a yuwusaan yi a̱ga̱nda̱ a̱tsuma̱ a̱ Ga̱lili, reve a̱ma̱ci o ro waru a̱ kuru yi a̱ tyo Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ili i suru i fara ta̱ urana wa Ajuma, Urana wi Ifoɓi adama a Ashibi. ");
INSERT INTO tswNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","A̱vu Isuhu vuma va Arimatiya za tsugbain a̱tsuma̱ a Azagbain a Mbara,† vuma va̱ a̱ɓula̱, za na ri e ipiri wu uwwa uta̱wu u tsugono tsa̱ A̱sula̱ ta̱wa̱, u yuwan ta̱ asuvu. A̱vu u uwa o ukobu wa Bilatu, reve u pati lipu va̱ Yesu. ");
INSERT INTO tswNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bilatu uwa ta̱ asalama ko Yesu kuwa̱ ta̱ ɗe. A̱vu u ɗe a̱soja a̱ yi, reve we ece le ko Yesu kuwa̱ ta̱ ɗe nu ujimu. ");
INSERT INTO tswNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ana wu uwwai o una̱ wa̱ a̱soja a̱ yi, a̱vu u zuwa a ca Isuhu lipu va̱ Yesuꞌu. ");
INSERT INTO tswNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","A̱vu Isuhu tsula okoro. Ana a̱ cipa̱toi lipuꞌu, reve u pupala yi no okoroꞌo. A̱vu u zuwa yi a̱tsuma̱ a aason a na a̱ ka̱pa̱i a̱tsuma̱ a aatali. Reve u keɓe aatali o ro, a̱vu u to una̱ wa aasoꞌon. ");
INSERT INTO tswNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","A̱vu Meri Magadaliya na̱ Meri mma va̱ Isuhu a̱ ka̱lyuwa̱ uba̱ta̱ u na a zuwa niyi. ");
INSERT INTO tswNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ana urana wa Ashibi u ka̱ra̱i, a̱vu Meri Magadaliya na̱ Meri mma va Yakubu na̱ Solomi a tsula itana i ma̱guru, adama a̱ ta̱wa̱ a sukuma lipu va̱ Yesu. ");
INSERT INTO tswNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","A̱vu a̱ ta̱wa̱ na̱ wasasa o urana wa Aladi, cina usana u tawa ɗaɗa a̱ ta̱wa̱i a aasoꞌon. ");
INSERT INTO tswNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","A̱vu a dammulai, “Zane ɗa ee keɓe tsu aatali o ndolo o una̱ wa aasoꞌon?” ");
INSERT INTO tswNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ana a̱ ꞌya̱sa̱in esu e le, a̱vu a cina e keɓe ɗe aataliꞌi agba aatali a gbain a ɗa a̱ da̱na̱i. ");
INSERT INTO tswNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ana a uwai a aasoꞌon, reve e ene ulobo u ro nden o ukere usaꞌani, ni itana i uꞌuri. Reve a uwa asalama. ");
INSERT INTO tswNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","A̱vu u damma le, “She i uwa asalama wan. N reve ta̱ i te izami ya̱ Yesu za va Nazara, za na a varai a akpata. Wu pa shi. U ꞌyon ta̱. Ka̱lyuwa̱i uba̱ta̱ u na u da̱na̱i. ");
INSERT INTO tswNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ꞌYa̱wa̱i i damma ojoro a̱ yi na̱ Bituru u ta̱ ɗe elime a̱ ɗu a̱ ꞌya̱wa̱ Ga̱lili. I te ene yi ununa u damma nɗu.” ");
INSERT INTO tswNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ana o uta̱i, a̱vu a suma ni ilaɗi. Reve e reme asalama na̱ mejeꞌen ma̱ lipu. A damma za shi, adama a na wovon u reme nle. ");
INSERT INTO tswNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nu usana u na Yesu ꞌyoyin o urana wa Aladi, Meri† Magadaliya ɗa fara ene niyi, za na wu uta̱yi otoni a̱ lima̱ e cindere a̱tsuma̱ a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","U ꞌya̱wa̱ ta̱ damma otoni a̱ yi, aza a na a̱ da̱na̱i a saali na̱ a̱tsumola̱ngu. ");
INSERT INTO tswNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ana a uwwai u ta̱ wuma, hali we ene yi, reve a ꞌyuwan a̱ usu. ");
INSERT INTO tswNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ana addama o ndolo o kotoi, a̱vu Yesu ta̱wa̱ uba̱ta̱ wa ama e re a̱tsuma̱ e le no oroci o ro, ele a mmalu o ure a̱ tyo a̱ ma̱lyuci. ");
INSERT INTO tswNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","A̱vu a̱ ꞌya̱wa̱ a damma akapiꞌi, agba a̱ usu shi. ");
INSERT INTO tswNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Na̱ a̱ca̱pa̱ a ɗa u ta̱wa̱i uba̱ta̱ wo ojoro kupa na̱ za ta̱ꞌa̱, ele nden a alya e ilyalya. A̱vu u yuwaan le nla̱ngi adama o okolo o ugbamu u le nu ulambu u na a cayi okolo. Adama a na a ꞌyuwain a̱ usu ili i na aza a na e ene niyi a damma nle cina u ꞌyon. ");
INSERT INTO tswNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","A̱vu u damma le, “ꞌYa̱wa̱i a̱tsuma̱ o uvaɗi suru i yuwaan ama alajiya a Alabari a Saꞌani. ");
INSERT INTO tswNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Za na usuyi a̱ rumbu niyi waru, a ta wawa yi. Amma za na usuyi shi, wa̱a̱ tsura̱ wuma u babu ukotu shi. ");
INSERT INTO tswNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aza a na a̱ usuyi a ta gura yuwan iroci yi ili ya asalama i nda: A̱tsuma̱ a ala† a̱ va̱ a̱ to uta̱a̱ otoni a̱ lima̱, waru a ta yuwan adanshi ne elentsu o ro, ");
INSERT INTO tswNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","a ta tara yo, agba ko no o sowo yaza, waa yuwan ili ne ele shi ko keꞌen, a̱ ta̱ juꞌwa̱n a̱za̱ o ubanakun a̱vu a̱ tsura̱ lafiya.” ");
INSERT INTO tswNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ana Yesu† yuwain adanshi ne ele, a̱vu a tara yi a̱ tyo zuva, tsa̱ra̱ u da̱nu o ukere usaꞌani wa̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ele gba a̱ ka̱ra̱ a yuwan alajiya a Alabari a Saꞌani ko te ɗa, A̱sula̱ a yuwusan ulinga ne ele. Ulinga wa asalama a na a yuwusain, u roco ta̱ Alabari a Saꞌani e le amayun a ɗa.");
INSERT INTO tswNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tiwofilu, vuma va̱ a̱ɓula̱: Ana wo oꞌwoi, ama na̱ a̱bunda̱ a zuwa ta̱ aciyele reve a ɗana urevetyowu wi ili i na i farai a̱tsuma̱ a̱ tsu. ");
INSERT INTO tswNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ununa a ɗanai ili i na ele na e enei ne esu diga o ufaru a ca ntsu ele, aza a na e enei ele ɗa a̱za̱ o ulinga wa adanshi a̱ A̱sula̱ waru. ");
INSERT INTO tswNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","A̱mu me ene ta̱ u lobono ta̱, ili yu ufaru i ɗa n toniyi ili suru mejege, tsa̱ra̱ n ɗanaa wu ili i na i farai mejege, ");
INSERT INTO tswNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","tsa̱ra̱ vu reve amayun a adanshi a na a damma nuwu una̱ nu una̱. ");
INSERT INTO tswNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mantsa ma na Hiridu† da̱na̱i Mogono ma Yahuda, a yuwan ta̱ ganu ro, za na a̱ tsu ɗe Zakariya. Wu uta̱ ta̱ upasu u nan ganu† wa Abija. Alisa̱ba̱tu ɗa aala a ka va̱ yi. A̱yi fo o uꞌwa u nan ganu o ugundo wa Haruna† u ɗa wu uta̱i. ");
INSERT INTO tswNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ele ra a yuwan ta̱ nden n saꞌani n na A̱sula̱ a cigai. O toni ta̱ ili i na Zagbain ca nle suru. ");
INSERT INTO tswNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Agba a̱ ri na̱ muwun shi. Alisa̱ba̱tu idari i ɗa i shi. A̱yi na̱ vali va̱ yi a kutsa ta̱. ");
INSERT INTO tswNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Urana u lo, Zakariya yuwusan ta̱ ulinga u tsuganu a̱ A̱a̱ꞌisamapaɗa,† a mantsa ma na ulinga u rawai upasu u le. ");
INSERT INTO tswNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ili i na agadu e le a yuwusain a̱yi ɗa, ele nan ganu a tsu ɗangwa ta̱ vuma na̱ matawa ma agita, u uwa a̱tsuma̱ o Upasu wa Akiza,† tsa̱ra̱ u kula̱to ili i ma̱guru.† ");
INSERT INTO tswNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ana mantsa ma rawai tsa̱ra̱ a̱ kula̱to ili i ma̱guruꞌu, reve ama o ɓoloto suru a yuwusan avasa a alanga. ");
INSERT INTO tswNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Reve malingata ma Zagbain ma̱ ta̱wa̱ uba̱ta̱ wa̱ yi, wi isawan o ukere u usaꞌani u masaꞌa, uba̱ta̱ u na wa̱a̱ kula̱tosu ili i ma̱guruꞌu. ");
INSERT INTO tswNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ana Zakariya ene niyi, reve wu uwwa wovon, lipu va̱ yi ka̱ra̱ e mejeꞌen. ");
INSERT INTO tswNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","A̱vu malingataꞌa u damma yi, “Zakariya, she vu uwwa wovon wan, a uwwa ta̱ avasa a̱ wu. Ka va̱ wu, Alisa̱ba̱tu ta yuwan a̱a̱tsuma̱, u ta matsaan wu ulobo. Vu ta ca yi aala Yahaya.† ");
INSERT INTO tswNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","U to oꞌwo wu ili i ma̱za̱nga̱, ne e ekere a aza a na aa uwwa adama a limatan va̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","U to oꞌwo vumagbain e ekere a Zagbain. Woo sowo mini ma masayan ma inabi, ni ili yo oso i na woo oꞌwo usowu shi. O to shiton yi na̱ Ruhu va Akiza† a̱yi a̱ a̱a̱tsuma̱ a mma va̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ama na̱ a̱bunda̱ aza a Israꞌila a̱ ta̱ ka̱mba̱ e ekere a Zagbain le adama a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","U ta wala elime a Zagbain na̱ cuꞌun vu ucira na̱ ruhu va Iliya, tsa̱ra̱ a̱ ka̱mba̱to okolo a nan dada a̱ ka̱mba̱ uba̱ta̱ u muwun n le. U ta̱ ka̱mba̱to a̱za̱ o ulambu wu ugbozu o toni ugbozu wa aza a akiza a̱ A̱sula̱, tsa̱ra̱ u foɓoo Zagbain ama, tsa̱ra̱ u cina le ufoɓu.” ");
INSERT INTO tswNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Reve Zakariya ece yi, “Cine cuꞌun nda aa fara? A̱mu ɗa nda n kutsai ɗe, ka va̱ fo ɗa nda u kutsai ɗe.” ");
INSERT INTO tswNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Reve u usu, “A̱mu ɗa Jiburaꞌilu, n ta̱ mishin a̱ ma̱ka̱ka̱n ma̱ A̱sula̱ kuci. A̱ lyungu mu ta̱, tsa̱ra̱ n damma wu adanshi o uyoꞌo a nda. ");
INSERT INTO tswNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Gogo vu ta̱ da̱na̱ kpaku, vaa gura yuwan adanshi shi, she urana u na ili i nda i shiwain. Adama a na vu usuyi adanshi a̱ va̱ shi. Adanshi a na a̱a̱ ta̱wa̱ woo oꞌwo amayun a mantsa ma na wu ntsayi.” ");
INSERT INTO tswNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ama lo a pura Zakariya, a̱vu a̱ ka̱ra̱ a asalama ili i na i zuwai u jimai pe Upasu wa Akizaꞌa.† ");
INSERT INTO tswNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ana wu uta̱i, u gura yuwan adanshi shi. Reve e reve u ta yuwan we ene ili i ro cuꞌun va alavu alavu a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗaꞌa. A̱vu u yuwusaan le iroci ne ekere, agba u gura yuwan adanshi shi. ");
INSERT INTO tswNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ana mantsa mo ulinga ma̱ yi mo kotoi, reve u ka̱mba̱ o uꞌwa. ");
INSERT INTO tswNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Reve ka va̱ yi Alisa̱ba̱tu tsura̱ a̱a̱tsuma̱. A̱yi ubuwu na̱ woto ton, a̱vu u da̱nusu o uꞌwa. ");
INSERT INTO tswNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","U dansa ta̱, “Zagbaiꞌin u yuwaan mu ta̱ nda, a rana nda u roco mu ta̱ isaꞌani, u tawa mu ta̱ ili ya adanshi e ekere a ama.” ");
INSERT INTO tswNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Alisa̱ba̱tu na̱ a̱a̱tsuma̱ woto ta̱li, a̱vu A̱sula̱ a̱ lyungu Jiburaꞌilu malingata ma̱ yi a̱ lyuci na a̱ tsu ɗe Nazara e iɗa ya̱ Ga̱lili. ");
INSERT INTO tswNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","U lyungu yi ta̱ uba̱ta̱ o usheli u na koto u revei vali shi, eegeɓe a̱ yi vuma ro ɗa o ugundo wa̱ Da̱wuda Mogono, aala a̱ yi Isuhu. Meri ɗa aala o usheliꞌi. ");
INSERT INTO tswNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","A̱vu malingataꞌa u ꞌya̱wa̱ ya̱ꞌa̱ yi, reve u damma, “A̱zoꞌwa, macigata, Zagbain to oɓolo na̱ a̱vu!” ");
INSERT INTO tswNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Adanshiꞌi gba u ɓa̱la̱ yi ta̱ lon, u yuwusan ta̱ majiyan cuꞌun vi ica̱su i ne i ɗa tsunda. ");
INSERT INTO tswNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","A̱vu u damma yi, “She vu uwwa wovon wan, Meri. Vu tsura̱ ta̱ icigi e ekere a̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Vu ta yuwan a̱a̱tsuma̱, vu matsan ulobo, reve waru vu zuwaa yi aala Yesu. ");
INSERT INTO tswNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","U to oꞌwo zagbain. E te ɗe aala a̱ yi Mawun mo Mogono ma̱ A̱sula̱. A̱sula̱ Zagbain a ta ca yi ootogu o tsugono tsa dada va̱ yi Da̱wuda. ");
INSERT INTO tswNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","U ta yuwan tsugono o uꞌwa wa Yakubu babu ukotu. Tsugono tsa̱ yi tsa̱ ri nu ukosu shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","A̱vu u damma yi, “Cine woo oꞌwo ne, ana wo oꞌwoi koto n reve vali shi?” ");
INSERT INTO tswNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Reve u usu yi, “Ruhu va Akiza ta̱ ta̱wa̱ wu, ucira u Mogono ma̱ A̱sula̱ waru u ta pupala wu, adama a na za va akiza a na vaa matsan a̱ ta̱ ɗe yi Mawun ma̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Cuwan moron ma̱ wu Alisa̱ba̱tu. A damma ta̱ wa̱a̱ tsura̱ a̱a̱tsuma̱ shi, agba gogo u ta̱ na̱ a̱a̱tsuma̱ woto ta̱li, ko na wo oꞌwoi u kutsai ɗe. ");
INSERT INTO tswNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ili i lo a na A̱sula̱ a̱a̱ kuɗa̱ yuwan shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","A̱vu Meri damma, “A̱mu ɗa nda aagbashi a Zagbain. Lyawa wo oꞌwo ununa vu dammai.” Reve malingataꞌa u ka̱ra̱. ");
INSERT INTO tswNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","A rana ndolo, a̱vu Meri ꞌyon u jika̱, reve u ꞌya̱wa̱ a̱ lyuci ro a̱tsuma̱ e ilyuci ya agaɗi e iɗa ya Yahuda. ");
INSERT INTO tswNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","A̱vu u uwa o uꞌwa wa Zakariya, tsa̱ra̱ u ca̱sa̱ Alisa̱ba̱tu. ");
INSERT INTO tswNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ana wu uwwai ica̱suꞌu, a̱vu ba̱ba̱ jinga̱ɗa̱ a̱ a̱a̱tsuma̱ a̱ yi nu ucira. Reve o shiton yi na̱ Ruhu va Akiza.† ");
INSERT INTO tswNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","A̱vu u ꞌya̱sa̱n uɗyo nu ucira, u damma, “A̱vu za va abaꞌun a ɗa a̱tsuma̱ a̱ a̱ma̱ci. Mawun ma̱ a̱a̱tsuma̱ a̱ wu waru za va abaꞌun a ɗa! ");
INSERT INTO tswNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Cine ili i saꞌani i nda i cina numu, a na mma vu Zagbain va̱ ta̱wa̱i u ka̱lyuwa̱ mu? ");
INSERT INTO tswNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ana mu uwwai ica̱su ya̱ wu, ɗaɗa ba̱ba̱ na ri a̱ a̱a̱tsuma̱ a̱ va̱ jinga̱ɗa̱i nu ucira a yuwusan ma̱za̱nga̱. ");
INSERT INTO tswNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","A̱vu za va abaꞌun ɗa adama a na vu usuyi ili i na Zagbain dammai u ta shiwan.” ");
INSERT INTO tswNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Reve Meri damma, “Ookolo a̱ va̱ a ciɓala ta̱ Zagbain. ");
INSERT INTO tswNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Asuvu a̱ va̱ a̱ ta̱ na̱ ma̱za̱nga̱ adama a̱ A̱sula̱ Zamawawa va̱. ");
INSERT INTO tswNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","A̱yi u cuwan ta̱ na̱ a̱mu, aagbashi a̱ yi. Diga gogo a̱ ꞌya̱wa̱, ama a̱ ta̱ ɗe mu za va abaꞌun. ");
INSERT INTO tswNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Adama a na a̱yi Zavucira ɗa, u yuwaan mu ta̱ ili ya̱ a̱ɓula̱. Aala a̱ yi waru akiza a ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Diga mantsa a̱ tyo mantsa, u tse ene ta̱ iliyali ya aza a na a casu yi tsugbain. ");
INSERT INTO tswNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","U yuwan ta̱ a̱ba̱jini e ili ya asalama ne ekere a̱ yi, u beteꞌwe ta̱ aza a aciyogbamu. ");
INSERT INTO tswNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","U cipa̱to ta̱ ngono m gbagbain o otogu e le, reve u ꞌya̱sa̱n aza a na a̱ ri ili shi. ");
INSERT INTO tswNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","U cuwa̱ton ta̱ aza a ambulu ni ili i saꞌani, a̱za̱ o utsuru waru u lo le ta̱ ekere lya̱nga̱. ");
INSERT INTO tswNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","U kamba ta̱ aagbashi a̱ yi Israꞌila, u cuwan ta̱ na̱ nzuwulai ma̱ yi we ene yi iliyali. ");
INSERT INTO tswNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ununa u yuwayin akaya a̱ tsu Ibrahim nzuwulai, na̱ muwun n tsukaya ma̱ yi hali ukosu.” ");
INSERT INTO tswNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","A̱vu Meri da̱nu na̱ Alisa̱ba̱tu a̱ tyo woto taꞌatsu, reve u ka̱mba̱ o uꞌwa. ");
INSERT INTO tswNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mantsa ma na Alisa̱ba̱tu aa matsan yuwan ta̱, reve u matsan mawun mo ulobo. ");
INSERT INTO tswNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","A̱vu nron mu nden na̱ mmaci ma̱ yi, a uwwa ununa Zagbain yuwaan niyi isaꞌani, a̱vu a kamba yi ma̱za̱nga̱. ");
INSERT INTO tswNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ana mawuꞌun u rawai urana wa̱ kunla̱, reve a̱ ta̱wa̱ tsa̱ra̱ a paɗa yi uryumbu, reve a̱ shi a ciga a ca yi aala a dada va̱ yi Zakariya o una̱ wa dada va̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","A̱vu mma va̱ yi damma, “Oꞌo, Yahaya ɗa aa ca yi.” ");
INSERT INTO tswNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Reve a damma yi, “Moron ma̱ wu ma̱ ri na aala Yahaya shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","A̱vu o roco dada va̱ yi, a̱ te izami ya aala a na aa ca yi. ");
INSERT INTO tswNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Reve u pati le ili yi iɗana, a̱vu u ɗana ɗe, “Aala a̱ yi a ɗa Yahaya.” Reve o oꞌwo a asalama suru. ");
INSERT INTO tswNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","A jima shi, ɗaɗa una̱ wa̱ yi u kpa̱tuꞌushi, a̱vu eelentsu a̱ yi a gura yuwan adanshi. A̱vu u yuwusaan A̱sula̱ ica. ");
INSERT INTO tswNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","A̱vu wovon u tsura̱ nron mu nden ma̱ yi n na n da̱na̱i lo suru. Reve a̱ ka̱ra̱ a adanshiꞌi uba̱ta̱ suru a̱tsuma̱ e ilyuci ya agaɗi ya Yahuda. ");
INSERT INTO tswNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Aza a na a uwwai ili ya asalama o ndolo suru, she a uwa majiyan ne e eci, “Nye i ɗa mawun ma nda moo oꞌwo?” A damma ta̱ ne adama a na ukere wu Zagbain u to oɓolo na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakariya dada va Yahaya da̱na̱ ta̱ ushiwun na̱ Ruhu va Akiza, a̱vu u yuwan adanshi o usokowu wa̱ A̱sula̱: ");
INSERT INTO tswNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Tsu yuwayin Zagbain ica, A̱sula̱ a Israꞌila! U ta̱wa̱ ta̱ u tsupa a̱vu u wawa ama a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","U ꞌya̱sa̱n ta̱ Za vi Iwawi† za vu ucira o uꞌwa wa aagbashi a̱ yi Da̱wuda adama a̱ tsu. ");
INSERT INTO tswNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(Ununa u dammai o una̱ wa ama a akiza a̱ A̱sula̱ nu ujimu.) ");
INSERT INTO tswNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","U wawa tsu ta̱ e ekere a arala na̱ nꞌyuwatan n tsu suru. ");
INSERT INTO tswNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","We ene ta̱ nkaya n tsu iliyali, u cuwan ta̱ na akucunu† a akiza a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","A̱yi ɗa akucunu a na u yuwayin dada tsu Ibrahim. ");
INSERT INTO tswNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ana u ta wawa tsu e ekere a nꞌyuwatan n tsu, tsa̱ra̱ u kamba tsu. Adama tsu yuwaan yi a̱ga̱nda̱ babu wovon, ");
INSERT INTO tswNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","na akiza ni ili ya̱ a̱ɓula̱ a̱ ma̱ka̱ka̱n ma̱ yi. Tsu yuwain ne a mantsa ma wuma ma̱ tsu suru. ");
INSERT INTO tswNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A̱vu waru, mawun ma̱ va̱, a̱ ta̱ ɗe wu vumava̱sula̱ Mogono me Ili Suru. Vu ta̱ wala elime a Zagbain, tsa̱ra̱ vu foɓoo yi ure, ");
INSERT INTO tswNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","tsa̱ra̱ vu ca ama a̱ yi urevu wi iwawi o ure u na a yuwaan le gafura vu unusu u le. ");
INSERT INTO tswNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Adama e isaꞌani ya̱ a̱bunda̱ ya̱ A̱sula̱ a̱ tsu, ekan a wasasa a̱a̱ ta̱wa̱ tsu ɗe zuva. ");
INSERT INTO tswNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tsa̱ra̱ wi ikana aza a na a̱ ri nden a̱tsuma̱ e irumbu, na aza a na a yuwain zuzu na̱ ma̱kuwa̱a̱, tsa̱ra̱ u toni na̱ a̱tsu ure wo okolo a̱ nden.” ");
INSERT INTO tswNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Reve mawuꞌun u kungwa, a̱vu waru u yuwan mgbain a̱tsuma̱ a̱ ruhu. A̱vu u da̱nu a̱tsuma̱ o una, hali urana u na wu uta̱i a alanga e eteshe e ekere a aza a Israꞌila. ");
INSERT INTO tswNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","A rana ndolo, Kaisa Agusta mogono ma gbain ma zuwa ta̱ e kece ama a na a̱ ri za̱la̱ tsugono tsa̱ Roma† suru. ");
INSERT INTO tswNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Mekece mo ufaru ma ɗa ndolo, ana a yuwain a mantsa ma na Kiriniyu da̱na̱i o tsugono tsi iɗa ya Suriya a̱tsuma̱ a̱ Roma.) ");
INSERT INTO tswNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","A̱vu ama suru a̱ ꞌya̱wa̱ a̱ lyuci le, tsa̱ra̱ e kece le. ");
INSERT INTO tswNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Isuhu uta̱ ta̱ a̱ lyuci va Nazara e iɗa ya̱ Ga̱lili. Adama a na a̱yi ugundo wa̱ Da̱wuda u ɗa, a̱vu u ka̱ra̱ a̱ tyo a̱ lyuci va Batalami e iɗa ya Yahuda. Batalami ɗa uba̱ta̱ u na a matsain mogono Da̱wuda. ");
INSERT INTO tswNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","U ꞌya̱wa̱ ta̱ tsa̱ra̱ e kece yi na̱ Meri eegeɓe a̱ yi, waru u da̱na̱ ta̱ na̱ a̱a̱tsuma̱. ");
INSERT INTO tswNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Yashi i na a̱ da̱na̱i ɗe, a̱vu yashi i limatan va̱ yi rawa. ");
INSERT INTO tswNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","U matsan ta̱ mawun mo ufaru ma̱ yi ulobo, reve wu pala yi nu umuna, a̱vu u zuwa yi o ukungulu. Adama a na a̱ tsura̱i ure a aasula o omocin shi. ");
INSERT INTO tswNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Upasu wi iɗa i ndolo, aza a aguɓa a̱ da̱na̱ ta̱ lo a atsusa e indanasa ikyon i le na ayin. ");
INSERT INTO tswNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Reve malingata ma Zagbain ma̱ ta̱wa̱ uba̱ta̱ u le, reve ekan a tsugbain tsa̱ A̱sulazuva e ikana uba̱ta̱ u na a̱ ri, hali a uwwa wovon lon. ");
INSERT INTO tswNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Reve malingataꞌa u damma le, “Yu uwwa wovon wan. N ta̱wa̱a̱ ɗu ta̱ na adanshi a̱ ma̱za̱nga̱ adama a ama suru. ");
INSERT INTO tswNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Anaꞌan a̱ lyuci va̱ Da̱wuda, a matsaan ɗu ta̱ Zamawawa,† a̱yi ɗa Kristi Zagbain. ");
INSERT INTO tswNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Apa ili i na ya̱a̱ da̱na̱ ɗu iroci: I ta cina ba̱ba̱ wupalu o umuna, uvotowun o ukungulu.” ");
INSERT INTO tswNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","A jima shi, reve oɓolo a̱ a̱za̱ o uvon a zuva na̱ malingataꞌa a yuwusaan A̱sula̱ ica, adansa, ");
INSERT INTO tswNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Tsugbain tsa̱ A̱sula̱ ɗe zuva suru suru, o uvaɗi nden mo okolo waru e ekere a aza a na waa uwwusa uyoꞌo u le!” ");
INSERT INTO tswNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ana nlingataꞌa n lyawa nle a̱ ka̱mba̱i zuva, a̱vu aza a aguɓa a dammulai va̱ni le, “Tsu ꞌya̱wa̱i Batalami gogo, tse enei ili i na i yuwain, ili i na Zagbain revetyo ntsu.” ");
INSERT INTO tswNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","A̱vu a̱ jika̱ a̱ ꞌya̱wa̱, reve a cina Isuhu na̱ Meri na̱ ba̱ba̱ꞌa̱ uvotowun o ukungulu. ");
INSERT INTO tswNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ana e ene niyi, reve a baza adanshi a na a damma nle adama a mawuꞌun. ");
INSERT INTO tswNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Reve aza a na a uwwai suru a̱ ka̱ra̱ a asalama e ili i na a uwwai o una̱ wa aza a aguɓaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Meri zuwa ta̱ ili i na a damma niyi o ookolo suru, a̱vu u yuwusan ma̱la̱la̱ ma̱ a̱bunda̱ adama e le. ");
INSERT INTO tswNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Reve aza a aguɓa a̱ ka̱mba̱. A̱vu a canasa ishipa yi ica a̱ tyo a̱ A̱sula̱, adama e ili i na a uwwai ni ili i na e enei. Ne ɗa wo oꞌwoi ununa malingata ma̱ A̱sula̱ ma dammai. ");
INSERT INTO tswNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ana a yuwain rana kunla̱, a na aa paɗa mawuꞌun uryumbu, a̱vu a ca yi aala Yesu.† A̱yi ɗa aala a na malingata ma̱ A̱sula̱ ma dammai, kafu a yuwan a̱a̱tsuma̱ a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","A̱vu mantsa ma̱ kucci ma na oo oꞌwo cece ma rawa, cine Wila̱ wa Musa u dammai. A̱vu a̱ ta̱wa̱ na̱ a̱yi Urishelima tsa̱ra̱ a ca yi e ekere a̱ A̱sulazuva. ");
INSERT INTO tswNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Ununa u ri uɗanu a̱ Wila̱ wa̱ A̱sulazuva, “A ca mawun mo ulobo mo ufaru suru, za na a ɗangwai e ekere a̱ A̱sulazuva.”) ");
INSERT INTO tswNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","A yuwan ta̱ waru kucci,† ununa a dammai a̱ Wila̱ wa̱ A̱sulazuva ana, “Muɗa n re ko muwun mu nrukuku n re.” ");
INSERT INTO tswNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","A mantsa mo ndolo, a yuwan ta̱ vuma na a̱ tsu ɗe Saminu, vuma na da̱nuyi a̱ lyuci va̱ Urishelima. Vuma va̱ a̱ɓula̱ ɗa, a uwwusa wovon wa̱ A̱sula̱, waru u purosu ta̱ we ene za na a̱a̱ da̱na̱to okolo a aza a Israꞌila. Ruhu va Akiza da̱na̱ ta̱ oɓolo na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ruhuꞌu u roco yi ta̱ wa̱a̱ kuwa̱ shi, she we ene Kristi Zamawawa va̱ A̱sulazuva. ");
INSERT INTO tswNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nu ucira wa̱ Ruhu u ɗa u uwai a̱ A̱a̱ꞌisamapaɗa. Ana nan dada va̱ Yesu a uwai na̱ a̱yi, tsa̱ra̱ a yuwaan yi ununa Wila̱ u dammai, ");
INSERT INTO tswNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","a̱vu Saminu sheɗe yi, a̱vu u godyoo A̱sula̱, adansa, ");
INSERT INTO tswNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Mogono ma Gbain, gogo vu shiton ta̱ nzuwulai ma̱ wu, vu lyawa aagbashi a̱ wu a̱ ka̱ra̱ no okolo nden. ");
INSERT INTO tswNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Me ene ta̱ iwawi† ya̱ wu ne esu a̱ va̱, ");
INSERT INTO tswNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Za na vu foɓoi adama a ama suru. ");
INSERT INTO tswNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ekan a na o tsu roco Atakpaci† ure wa̱ wu, na̱ tsugbain tsa̱ wu e ekere a aza a Israꞌila, ama a̱ wu.” ");
INSERT INTO tswNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Mma va̱ yi na̱ dada va̱ yi a̱ ka̱ra̱ ta̱ a asalama e ili i na a dammai adama a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Reve Saminu zuwaa le abaꞌun, a̱vu u damma mma va̱ Yesu, “A̱yi mawun ma nda a ɗangwa yi ta̱ adama a̱ a̱risa̱ a ama a Israꞌila na̱ a̱bunda̱. Waru a ɗangwa yi ta̱ adama a mawawa ma ama a Israꞌila na̱ a̱bunda̱. U to oꞌwo iroci yi ili i na ama aa ꞌyuwan. ");
INSERT INTO tswNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Adama o ndolo, e te reve majiyan ma ama a̱ a̱bunda̱. Waru matsun me peꞌeni ma ta ɓatsa asuvu a̱ wu.” ");
INSERT INTO tswNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","A yuwan ta̱ ka ro vumava̱sula̱,† aala a̱ yi a ɗa Hana̱tu, usheli wa Fanuyila o ugundo wa Asha. U kutsa ta̱ lon. U yuwan ta̱ nden n lolo aꞌwan e cindere, a̱vu vali va̱ yi kuwa̱. ");
INSERT INTO tswNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","U da̱na̱ ta̱ na aꞌwan kupakunla̱ na̱ a̱za̱ a̱ na̱shi. U lyawa A̱a̱ꞌisamapaɗaꞌa shi, amma u yuwusan ta̱ a̱ga̱nda̱ ayin nu urana. Waru u yuwusan ta̱ akuli na avasa. ");
INSERT INTO tswNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Babu usa̱n, reve u rawa zuzu u godyoo A̱sula̱. Reve u yuwan adanshi adama a mawun ma na ama suru aa zuwusa atsuvu adama e iwawi ya̱ Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ana Isuhu na̱ Meri kotoi mayan me ili i na Wila̱ wa̱ A̱sulazuva a dammai suru, a̱vu a̱ ka̱mba̱ o uꞌwa u le a̱ lyuci va Nazara e iɗa ya̱ Ga̱lili. ");
INSERT INTO tswNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mawuꞌun u yuwan ta̱ mgbain reve u yuwan ucira, u da̱na̱ ta̱ nu ugbozu lon, abaꞌun a̱ A̱sula̱ a̱ da̱na̱ ta̱ oɓolo na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nan dada va̱ yi a̱ tsu ꞌya̱wa̱ ta̱ Urishelima aaꞌwan suru a mantsa ma̱ A̱buki a Mapasa. ");
INSERT INTO tswNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ana u rawai aꞌwan kupa ne ejere, a̱ ꞌya̱wa̱ ta̱ A̱buki ununa a tsu yuwusan. ");
INSERT INTO tswNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ana o kotoi A̱bukiꞌi, ele a̱ ma̱ka̱mba̱a̱, a̱vu mawuꞌun wi isawan Urishelima, agba nan dada va̱ yi e reve shi. ");
INSERT INTO tswNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","A̱vu ele a yuwan mmalu mu urana u ta̱, ele a dansa u ta̱ pe a̱tsuma̱ o oɓolo a ama. A̱vu e ece aza a na a̱ da̱na̱i oɓolo ne ele. ");
INSERT INTO tswNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","A̱ tsura̱ e ene yi shi, ɗaɗa a̱ ka̱mba̱i Urishelima e izami ya̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","O urana wa taꞌatsu, ɗaɗa a̱ tsura̱ e ene niyi a̱ A̱a̱ꞌisamapaɗa nden na̱ munlu na aza a Israꞌila, a uwwusa le nu u yuwin nle yeci. ");
INSERT INTO tswNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Aza a na a uwwa niyi suru, a yuwan ta̱ asalama lon na̱ cuꞌun vu urevu nu ususu wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ana nan dada va̱ yi ene niyi, a̱vu a uwa asalama lon, a̱vu mma va̱ yi damma yi, “Mawun ma̱ va̱, cine vu yuwan ntsu tsunda? Vu lyawa ta̱ dada va̱ wu na̱ a̱mu e izami ya̱ wu na̱ a̱tsumola̱ngu.” ");
INSERT INTO tswNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","A̱vu u usu le, “Cine yaa zami mu ɗe? I reve u lobono ta̱ n da̱na̱ aɗa a Dada va̱ shi?” ");
INSERT INTO tswNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Agba e reve ili i na u damma nle shi. ");
INSERT INTO tswNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","A̱vu u ka̱mba̱ Nazara oɓolo ne ele a casu le tsugbain. Mma va̱ yi gba u zuwa ta̱ ili i ndolo suru o ookolo. ");
INSERT INTO tswNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu a̱ da̱shishi nu urevu nu ugbozu, na̱ mgbain, nu utsuru wi isaꞌani† e ekere a̱ A̱sula̱ ne e ekere a ama. ");
INSERT INTO tswNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","A aaꞌwan e gendu a na Kaisa Tibariya da̱na̱i mogono ma gbain ma̱ Roma, ngono n na̱shi n nda n da̱na̱ ta̱ za̱la̱ va̱ yi: Bontu Bilatu† o tsugono tsa Yahuda, Hiridu Antiba o tsugono tsa̱ Ga̱lili, Filibu zawaꞌa va̱ yi o tsugono tsa Ituriya na̱ Tarakunita, Lisaniya waru a yuwusan tsugono tsa Abiliya. ");
INSERT INTO tswNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","A yashi i na Hanana na̱ Kayafa a̱ da̱na̱i nan abara ganu, a̱vu adanshi a̱ A̱sula̱ a̱ ta̱wa̱ ya Yahaya mawun ma Zakariya a̱tsuma̱ o una. ");
INSERT INTO tswNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","U garasa ta̱ uba̱ta̱ suru zuzu nu Uɗolu wa̱ Urdu, a yuwusaan ama alajiya a na a̱a̱ rumbu† le, adama u roco a vadala† ta̱ a̱ nusu le, tsa̱ra̱ a yuwaan le gafura. ");
INSERT INTO tswNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Cine u ri uɗanu adama a Yahaya a̱tsuma̱ a Aatagada a Ishaya, vumava̱sula̱, ana, “Uɗyo wu nanza e ɗewu a̱tsuma̱ o una, ‘I foɓoo Zagbain ure, i yuwan ure wa̱ yi mejege. ");
INSERT INTO tswNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","O to shiton uka̱ri suru, agaɗi na̱ nsasan suru a ta vala le. A ta lapula re na ri ugondoru. O to shiton muka̱ri mu re. ");
INSERT INTO tswNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Vaɗilima̱ suru te ene iwawi ya̱ A̱sula̱.’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Adama o ndolo a ɗa Yahaya dammai oɓolo a ama a na a̱ ta̱wusa̱i ya̱ꞌa̱ yi, tsa̱ra̱ u rumbu le, “A̱ɗu apili! Zane damma nɗu i suma a̱tsuma̱lima̱ a na a̱ ri lo a̱ ta̱wa̱? ");
INSERT INTO tswNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","I yuwan ili i na yoo roco i vadala ta̱ a̱tsuma̱ o unusu† u ɗu. She i uwa a dansa o okolo a̱ ɗu a na Ibrahim a̱yi ɗa akaya a̱ ɗu wan. A̱sula̱ a ta gura yuwaan Ibrahim muwun na atali a nda. ");
INSERT INTO tswNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Aaɓau a̱ tu ufoɓu wu gasa ɗanga a aralu e le. Uɗanga u na u matsain ili ya̱ a̱ɓula̱ shi suru, o to koɗo yi, a̱vu a vari yi a akina.” ");
INSERT INTO tswNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Reve amaꞌa e ece yi, “Cine tsaa yuwan?” ");
INSERT INTO tswNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","A̱vu u damma le, “Za na ri na̱ a̱tugu e re, u ca za na ri na̱ a̱yi shi za ta̱. Za na ri ni ilyalya waru u yuwan ne.” ");
INSERT INTO tswNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","A̱za̱ o ushishi wu utafa o ro a̱ ta̱wa̱ ta̱, tsa̱ra̱ u rumbu le, reve e ece yi, “Manlu, nye tsaa yuwan?” ");
INSERT INTO tswNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Reve u damma le, “She i ushi ili i na i laꞌai ili i na a damma nɗu i ushi wan.” ");
INSERT INTO tswNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","A̱soja o ro waru a̱ ta̱wa̱ ta̱ e ece yi, “A̱tsu gba, nye tsaa yuwan?” A̱vu u damma le, “She i usa ikebe yi za ro nu ucira wan, ko i yuwaan za ro epen pere m pere wan. I yuwan ankuri na atsupu a̱ ɗu.” ");
INSERT INTO tswNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ama e ipiri yu uta̱wu yi Zamawawa, reve a̱ ka̱ra̱ a majiyan ko Yahaya a̱yi ɗaɗa Zamawawaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","A̱vu u usu le, “N rumbu ɗu ta̱ na̱ mini, agba za na laꞌa numu tsugbain u ta̱ lo a̱ ta̱wa̱. Vunu va atan a̱ yi n rawa n ka̱nza̱ m ba̱ɗa̱ shi. A̱yi ɗa wa̱a̱ rumbu ɗu na̱ Ruhu va Akiza na akina. ");
INSERT INTO tswNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","U ta̱ na aakpatalutsu o uyeluwu o ukere wa̱ yi, u ta raɗa oosoroto cece, a̱vu u ɓoloto ishina ya̱ yi o mopon, agba owopoꞌo u ta̱ kula̱to le na akina a na a̱ ri n kima̱ shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Re va̱ a̱bunda̱ ɗa Yahaya yuwain alajiya a Alabari a Saꞌani a̱ tyo e ekere a ama. ");
INSERT INTO tswNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","A̱vu u yuwaan Hiridu Antiba mogono nla̱ngi adama a Hiridiya, ka vu zawaꞌa va̱ yi, ni iwuya ya̱ a̱bunda̱ i na u yuwain. ");
INSERT INTO tswNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Reve u yuwisan iwuya i ro, ana u zuwai Yahaya o uꞌwa wa ali. ");
INSERT INTO tswNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ana a̱ rumbuyi ama a na a̱ ta̱wa̱i suru, a̱vu fo a̱ rumbu Yesu. A̱yi a̱tsuma̱ a avasa, reve zuva kpa̱tuꞌwa̱, ");
INSERT INTO tswNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","reve Ruhu va Akiza telee yi na̱ lipu oroci a muɗa. A̱vu a uwwa uɗyo ɗe zuva ana, “A̱vu ɗa Mawun ma̱ va̱, macigata ma̱ va̱, na̱ a̱vu ɗa maa yuwusan ma̱za̱nga̱ lon.” ");
INSERT INTO tswNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu shi ta̱ na aꞌwan a na a yuwain zuzu na̱ mataꞌatsu, ana u temei uritosu wa̱ yi. A tara yi ta̱ ana a̱yi mawun ma̱ Isuhu ma ɗa. Isuhu ulobo wa̱ Heli u ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli ulobo wa Matata u ɗa. Matata ulobo wa̱ Levi u ɗa. Levi ulobo wa Maliki u ɗa. Maliki ulobo wa Yana u ɗa. Yana ulobo wa̱ Isuhu u ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Isuhu ulobo wa Matiya u ɗa. Matiya ulobo wa̱ Emos u ɗa. Emos ulobo wa Nahum u ɗa. Nahum ulobo wa Azaliya u ɗa. Azaliya ulobo wa Najaya u ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Najaya ulobo wa Maꞌata u ɗa. Maꞌata ulobo wa Matiya u ɗa. Matiya ulobo wa Simiya u ɗa. Simiya ulobo wa̱ Isuhu u ɗa. Isuhu ulobo wa Yahuda u ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yahuda ulobo wa Yowana u ɗa. Yowana ulobo wa Risa u ɗa. Risa ulobo wa̱ Zerubabe u ɗa. Zerubabe ulobo wa Shayatiya u ɗa. Shayatiya ulobo wa̱ Niri u ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Niri ulobo wa Maliki u ɗa. Maliki ulobo wa Adi u ɗa. Adi ulobo wa Kosama u ɗa. Kosama ulobo wa Alamadama u ɗa. Alamadama ulobo wa̱ Iri u ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Iri ulobo wa̱ Yosi u ɗa. Yosi ulobo wa Eliyaza u ɗa. Eliyaza ulobo wa Yorima u ɗa. Yorima ulobo wa Matata u ɗa. Matata ulobo wa̱ Levi u ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi ulobo wa Saminu u ɗa. Saminu ulobo wa Yahuda u ɗa. Yahuda ulobo wa̱ Isuhu u ɗa. Isuhu ulobo wa̱ Yonana u ɗa. Yonana ulobo wa̱ Eliyaki u ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyaki ulobo wa Malaya u ɗa. Malaya ulobo wa Mena u ɗa. Mena ulobo wa Matata u ɗa. Matata ulobo wa Natan u ɗa. Natan ulobo wa̱ Da̱wuda u ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Da̱wuda ulobo wa̱ Yese† u ɗa. Yese ulobo wa̱ Obe u ɗa. Obe ulobo wa Buwaza u ɗa. Buwaza ulobo wa Salumuna u ɗa. Salumuna ulobo wa Nashon u ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashon ulobo wa Aminadabu u ɗa. Aminadabu ulobo wa Aram u ɗa. Aram ulobo wa̱ Hesuruna u ɗa. Hesuruna ulobo wa Farisa u ɗa. Farisa ulobo wa Yahuda u ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuda ulobo wa Yakubu u ɗa. Yakubu ulobo wa Ishiyaku u ɗa. Ishiyaku ulobo wa Ibrahim u ɗa. Ibrahim ulobo wa̱ Tera u ɗa. Tera ulobo wa Naho u ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naho ulobo wa̱ Seru u ɗa. Seru ulobo wa̱ Reyu u ɗa. Reyu ulobo wa̱ Fele u ɗa. Fele ulobo wa̱ Eba u ɗa. Eba ulobo wa̱ Shela u ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shela ulobo wa̱ Kena u ɗa. Kena ulobo wa Afasha u ɗa. Afasha ulobo wa̱ Shem u ɗa. Shem ulobo wa̱ Nuhu u ɗa. Nuhu† ulobo wa Lame u ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lame ulobo wa̱ Metusela u ɗa. Metusela ulobo wa Anuhu u ɗa. Anuhu ulobo wa Jare u ɗa. Jare ulobo wa Mahalalel u ɗa. Mahalalel ulobo wa̱ Kena u ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kena ulobo wa̱ Enos u ɗa. Enos ulobo wa̱ Shitu u ɗa. Shitu ulobo wa Ada̱mu.† Ada̱mu za na A̱sula̱ a yuwain. ");
INSERT INTO tswNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu waru ushitowun na̱ Ruhu va Akiza, a̱vu wu uta̱ o Uɗolu wa̱ Urdu. Reve Ruhu va Akiza tara yi a̱ tyo a̱tsuma̱ o una rana amunga, ");
INSERT INTO tswNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","uba̱ta̱ u na Mekerenkesu ma̱ lyungusa̱ niyi. Agba u lyuwa ili a̱tsuma̱ a ranaꞌa shi, o ukosu reve wu uwwa ambulu. ");
INSERT INTO tswNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ɗaɗa Mekerenkesu ma damma niyi, “Na̱ a̱vu Mawun ma̱ A̱sula̱ ma ɗa, vu zuwa aatali a nda a̱ ka̱mba̱ opopofu.” ");
INSERT INTO tswNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","A̱vu Yesu usu yi, “U tu uɗanu a Adanshi a̱ A̱sula̱,† ‘Ni ilyalya i ɗa goon vuma a̱a̱ da̱na̱ wuma shi.’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Reve Mekerenkesu ma tara yi a̱ tyo zuva masasan, ɗaɗa u rocoshi niyi tsugono tsu uvaɗi suru. ");
INSERT INTO tswNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Reve u damma yi, “N ta ca wu tsugbain nu utsuru u ndaꞌa suru, adama a na a zuwa le ta̱ o ukere u va̱. Waru n ta ca za na n cigai. ");
INSERT INTO tswNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Suru ili i nda o to oꞌwo a̱za̱ a̱ wu, na̱ vu ka̱ɗa̱to vu yuwaan mu a̱ga̱nda̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ɗaɗa Yesu usuyi niyi, “U tu uɗanu, ‘Zagbain A̱sula̱ a̱ wu a ɗa vaa yuwaan a̱ga̱nda̱, a̱yi a̱ ndeꞌen ɗa vaa yuwaan tsugbashi.’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Reve Mekerenkesu ma tara yi a̱ tyo Urishelima, a̱vu u zuwa yi ɗe e ncilecile ma̱ A̱a̱ꞌisamapaɗa. Ɗaɗa u tsu damma yi, “Na̱ a̱vu Mawun ma̱ A̱sula̱ ma ɗa, teteruwe e iɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Adama a na a ɗana ta̱, ‘A̱sula̱ a ta zuwa nlingata ma̱ yi n tiga̱ wu. ");
INSERT INTO tswNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Waru e te keɗe wu e ekere e le, adama ko anana a̱ wu a̱ ta̱ɗa̱tsa̱ a aatali wan.’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Reve Yesu usu yi, “Adanshi a̱ A̱sula̱ a damma ta̱, ‘She vu lyungwa̱ Zagbain A̱sula̱ a̱ wu wan.’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ana Mekerenkesu mo kotoi ma̱lyungwa̱ ma̱ yi suru, reve u lyawa yi neꞌen. ");
INSERT INTO tswNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Reve Yesu ka̱mba̱ a̱tsuma̱ o ucira u Ruhu va Akiza a̱ tyo Ga̱lili. Reve alabari a̱ yi a rawa e ilyuci i na i ri lo uka̱nda̱ruwu zuzu. ");
INSERT INTO tswNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","A̱vu u rocosu a̱ a̱ꞌisa̱ e le, reve u tsura̱ ica e ekere a ama suru. ");
INSERT INTO tswNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ana u tyoyi Nazara (lyuci na u kungwai), ɗaɗa u uwai a̱ a̱a̱ꞌisa̱† ununa u tsu yuwusan o urana wa Ashibi. Reve u ꞌyon adama u ɗenuna̱. ");
INSERT INTO tswNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Reve a ca yi Aatagada a Ishaya vumava̱sula̱. Ɗaɗa u buba̱ruwa̱ niyi, reve u cina uba̱ta̱ u na a ɗanai, ");
INSERT INTO tswNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ruhu vu Zagbain to oɓolo na̱ a̱mu, adama a na u ɗangwa mu ta̱, adama n yuwaan a̱za̱ e iliyali adanshi a Alabari a Saꞌani. U lyungu mu ta̱ adama n yuwan adanshi a na aa lyawa aza a na a̱ ri a tsugbashi, nrumba̱ waru ee ene ure, aza a na ee leꞌeshe waru o oꞌwo fa̱a̱n. ");
INSERT INTO tswNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Reve waru n yuwan adanshi a aaꞌwan a na Zagbain zuwai a na aa yuwaan ama isaꞌani u yuwan ta̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Reve u kutsulu aatagadaꞌa, a̱vu u ca za vu ulingaꞌa. A̱vu u da̱nu, tsa̱ra̱ u rito. Reve ama a na a̱ ri pe a̱ a̱a̱ꞌisa̱ꞌa̱ suru a uwa a̱ka̱nla̱ a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","A̱vu u damma le, “Anaꞌan adanshi a nda a shiwan ta̱ a atsuvu a̱ ɗu.” ");
INSERT INTO tswNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Reve a uwwa uyoꞌo, a yuwusan asalama na adanshi e isaꞌani i na yu uta̱i o una̱ wa̱ yi. A̱vu a damma, “A̱yi nda, a̱yi ɗaɗa mawun ma̱ Isuhu shi?” ");
INSERT INTO tswNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","A̱vu u damma le, “Amayun, i ta damma mu udammu u nda, ‘Boci, ka̱mba̱to aciya̱wu gbaga.’ ‘Suru ili i na waru tsu uwwai vu yuwain a Kafarnahum, vu yuwan yi fo pa a̱ lyuci va̱ wu.’ ");
INSERT INTO tswNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Amayun, n ta dansaa ɗu, a tsu tara vumava̱sula̱ ili ya̱ a̱ɓula̱ a̱ lyuci va̱ yi shi. ");
INSERT INTO tswNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Waru amayun a ɗa maa dansaa ɗu, a mantsa ma Iliya a yuwan ta̱ nruna̱ ma̱ a̱bunda̱ a̱tsuma̱ a Israꞌila. A mantsa ma na a̱ ɓa̱ruyi zuva o roꞌo shi aꞌwan a taꞌatsu na̱ woto ta̱li, reve ambulu a suɗuwa e iɗaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Agba a̱ ca̱co Iliya a̱ tyo uba̱ta̱ wu za ro a̱tsuma̱ e le shi, she uba̱ta̱ wa Sarafatu, e iɗa ya Sida, ka na da̱na̱i ma̱runa̱. ");
INSERT INTO tswNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Waru a yuwan ta̱ nkutu na̱ a̱bunda̱ a̱tsuma̱ a Israꞌila a mantsa ma Ilisha† vumava̱sula̱. Agba ko za ta̱ a̱ ka̱mba̱to gbaga shi, she Naꞌaman† vuma va Suriya.” ");
INSERT INTO tswNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ana ama a na a̱ ri pe a̱ a̱a̱ꞌisa̱ a uwwai ne, reve suru nle a uwwa upan lon. ");
INSERT INTO tswNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Reve a̱ ꞌyon nu upan, a̱vu o uta̱a̱ yi a̱tsuma̱ a̱ lyuci. Reve a tara yi a̱ tyo e ncilecile m masasan ma na lo ɗa lyuci le ri usuwu, adama e keɓe yi e iɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Reve wu utula̱i ben e memere me le, a̱vu u ka̱ra̱ ili ya̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Reve Yesu ka̱ra̱ a̱ tyo Kafarnahum lyuci ro a̱tsuma̱ e iɗa ya̱ Ga̱lili. Reve u uwa o rocosu ama o urana wa Ashibi. ");
INSERT INTO tswNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Reve a uwa asalama na̱ cuꞌun vu uritosu wa̱ yi, adama a na u to ritosu nu ucira. ");
INSERT INTO tswNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","A̱tsuma̱ a̱ a̱a̱ꞌisa̱ꞌa̱, vuma vo otoni a̱ lima̱† da̱na̱ ta̱ pe, reve u saala na̱ yisaali lon, ");
INSERT INTO tswNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Eyee! Te imini ya̱ wu na̱ a̱tsu, Yesu za va Nazara? Vu ta̱wa̱ ta̱ adama vu una tsu? N reve wu ta̱, a̱vu ɗa Akiza a̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Reve Yesu ɓara yi, u damma, “Ɓa̱ru una̱ wa̱ wu, reve vu kakasa na̱ a̱yi!” Ana otoni a̱ lima̱ꞌa̱ a varu niyi e memere me le, reve wu kasa na̱ a̱yi, u yuwan na̱ a̱yi ili shi. ");
INSERT INTO tswNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Reve amaꞌa a uwa asalama, reve a dammulai va̱ni le, “Cuꞌun va adanshi e ne a ɗa tsunda? Nu ucira nu ukadu u ɗa u ɓarai otoni a̱ lima̱, reve o uta̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Reve alabari a̱ yi a rawa uba̱ta̱ suru upasu wi iɗaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Reve u ꞌyon wu uta̱ a̱ a̱a̱ꞌisa̱ꞌa̱, a̱vu u uwa o uꞌwa wa̱ Simo. Agba a̱na̱wa̱le Simo a̱ shi a uwwa uyoꞌo shi, u shi ta̱ a uwwusa uta̱nu lon. Reve a damma Yesu adama a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Reve u rawa wi isawan zuzu na̱ a̱yi, ɗaɗa u ɓarai ubanakuꞌun, reve ubanakun u lyawa yi. Reve u ꞌyoshin u yuwaan le a̱ga̱nda̱. ");
INSERT INTO tswNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Urana a̱ ma̱riya̱a̱, ɗaɗa mmaci ma̱ a̱za̱ o ubanakun n ta̱wa̱i ne ele uba̱ta̱ wa̱ Yesu. A̱ da̱na̱ ta̱ na̱ banakun icuꞌun icuꞌun. Reve wu juꞌwa̱n le, ɗaɗa a̱ ka̱mba̱i gbagba. ");
INSERT INTO tswNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Waru otoni a̱ lima̱ a kakasa ta̱ na ama na̱ a̱bunda̱ a yisaali, “A̱vu ɗa Mawun ma̱ A̱sula̱!” A̱vu u ɓara le, u lyawa a yuwan adanshi shi, adama a na e reve ta̱ a̱yi ɗa Kristi Zamawawaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ana usana u tawai, reve u ka̱ra̱ a̱ tyo uba̱ta̱ u na vuma ri shi. Reve ama a uwa izami ya̱ yi, ɗaɗa a̱ ta̱wa̱i uba̱ta̱ wa̱ yi. Reve a̱ shi a ciga a zuwa yi u da̱nu ne ele. ");
INSERT INTO tswNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","A̱vu gba u damma le, “N ciga n ꞌyuwan n yuwaan ilyuci i ro alajiya a Alabari a Saꞌani o tsugono tsa̱ A̱sula̱† fo. Adama o ndolo a ɗa a̱ lyungu numu.” ");
INSERT INTO tswNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ɗaɗa u lyuwai elime na alajiya a̱ a̱ꞌisa̱ a̱tsuma̱ a Yahuda. ");
INSERT INTO tswNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Urana u ro, Yesu da̱na̱ ta̱ mishin a̱ ngeꞌen m Mala ma Janisara, na ama uɓolotowu uba̱ta̱ wa̱ yi, a uwwusa adanshi a̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","A̱ ngeꞌen m miniꞌi we ene ta̱ antsun e re, aza a na eremi a mugula a lyawai. Aza a na a̱ da̱na̱i e iza̱ꞌusa̱ igolo i le. ");
INSERT INTO tswNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","A̱tsuma̱ a antsuꞌun u uwa ta̱ pe a za ta̱ za na ri za va Simo, reve u damma yi u keɓe wantsuꞌun waꞌa a uwa pe a̱ miniꞌi. Reve u da̱nu a wantsuꞌun, reve u reme o ritosu ama. ");
INSERT INTO tswNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ana u kotoi adanshi, reve u damma Simo, “Keɓe wantsuꞌun a̱ ꞌya̱wa̱ uba̱ta̱ wa̱ a̱ruꞌun, a̱vu vu vari igolo i ɗu, tsa̱ra̱ i reme mugula.” ");
INSERT INTO tswNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Reve Simo usu, “Manlu, ili ya ayin i ɗa tsu ri o ulinga, agba tsu reme ili shi, amma ana vu dammai tsu vari, n ta vari igoloꞌo.” ");
INSERT INTO tswNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ana a yuwain ne, reve a vari igolo i le, reve a̱ tsura̱ mugula ma̱ a̱bunda̱, hali igolo i le i reme makara. ");
INSERT INTO tswNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","A̱vu e ɗe a̱za̱ e le, aza a na a̱ ri lo na̱ wantsun, tsa̱ra̱ a̱ ta̱wa̱ na̱ wantsun u le, adama a kamba le. Reve a̱ ta̱wa̱ o shiton antsuꞌun, she damma a ta liɓa. ");
INSERT INTO tswNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ana Simo Bituru enei ne, reve u kingyo a̱ ma̱ka̱ka̱n ma̱ Yesu a̱vu u damma, “Lyawa mu, Zagbain, a̱mu za vu unusu ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","A̱yi na aza a na a̱ da̱na̱i lo, a yuwan ta̱ asalama lon na̱ cuꞌun mugula n na e remei. ");
INSERT INTO tswNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ne ɗa fo Yakubu na̱ Yahaya, muwun ma̱ Za̱ba̱di, aza a na a̱ da̱na̱i o ulinga oɓolo na̱ Simo. A̱vu Yesu damma Simo, “She vu uwwa wovon wan, diga gogo vu ta̱ da̱na̱ a̱ ta̱wusa̱ na ama.” ");
INSERT INTO tswNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Reve o uta̱a̱ antsun e le a agaɗi, a̱vu a lyawa ili suru, reve o toni Yesu. ");
INSERT INTO tswNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Urana u ro, Yesu pe a̱tsuma̱ a̱ lyuci ro e iɗaꞌa, reve vuma ro ta̱wa̱ ɗe, za na ukutu u remei lipu ma̱ɓula̱. Ana we enei Yesu, reve u ka̱ɗa̱to urewesu wa̱ yi e iɗa, reve u pati yi, “Zagbain, na̱ vu usu, ka̱mba̱to mu mo oꞌwo cece.” ");
INSERT INTO tswNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Reve Yesu canana ukere wa̱ yi, a̱vu u juꞌwa̱n vumaꞌa, a̱vu u damma, “N usu ta̱, vo oꞌwo cece!” Babu usa̱n, a̱vu ukutuꞌu u lyawa yi. ");
INSERT INTO tswNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","A̱vu Yesu damma yi, “She vu damma za wan, vu ka̱ra̱ vu roco aciya̱wu uba̱ta̱ u na ganu ri, tsa̱ra̱ u ka̱lyuwa̱ wu. Reve vu ca kucci ununa Musa dammai, adama ama a̱ da̱na̱ nu urevu u na vo oꞌwoi cece.” ");
INSERT INTO tswNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Agba alabari a̱ yi she ili i na i ꞌya̱wa̱i elime, hali ama o ɓoloto lon, tsa̱ra̱ a uwwa yi, waru tsa̱ra̱ u ka̱mba̱to le gbaga. ");
INSERT INTO tswNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Agba Yesu tsu lyawa ta̱ ama a̱vu u ꞌya̱wa̱ o ogozo, tsa̱ra̱ u da̱nu a̱yi a̱ ndeꞌen, a̱vu u yuwan avasa. ");
INSERT INTO tswNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Urana u ro, Yesu pe a̱tsuma̱ o uritosu, a̱vu Afarishi† na̱ munlu n Wila̱ n da̱na̱ lo. Ele ɗa aza a na o uta̱i e ilyuci kokoꞌo e iɗa ya̱ Ga̱lili ne e iɗa ya Yahuda na̱ Urishelima. Ucira wu Zagbain u to oɓolo na̱ a̱yi, tsa̱ra̱ u yuwan opocino. ");
INSERT INTO tswNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","A̱vu ama o ro e sheɗe vuma ro na ri no osowi a̱ lipu a aavalu, a̱vu a̱ ꞌya̱wa̱a̱ yi o uꞌwaꞌa, tsa̱ra̱ a zuwa yi a̱ ma̱ka̱ka̱n ma̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ana a̱ tsura̱i ure u na aa yuwan ne shi adama o oɓolo a ama, reve a kumba zuva a̱ ka̱tsuꞌwa̱ ukwa̱ꞌa̱ꞌa̱. Ɗaɗa e telyuwetyo niyi oɓolo na aavalu a̱ yi e memere mo oɓolo a̱ ma̱ka̱ka̱n ma̱ Yesu. ");
INSERT INTO tswNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ana we enei ucawu wo okolo e le, a̱vu u damma vumaꞌa, “Vuma nda, a yuwaan wu ta̱ gafura wu unusu wa̱ wu.” ");
INSERT INTO tswNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","A̱vu Afarishi na̱ munlu n Wila̱ a yuwan majiyan, a damma, “Vuma ne ɗa aa yuwusan adanshi a vama o ndolo e ekere a̱ A̱sula̱? Zane ɗa aa gura yuwaan vuma gafura, she A̱sula̱ goon shi?” ");
INSERT INTO tswNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu reve ta̱ majiyan me le, ɗaɗa we ece nle, “Nye i zuwai yaa yuwusan cuꞌun majiyan mo ndolo o okolo a̱ ɗu? ");
INSERT INTO tswNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Zane ɗa ri babu usa̱n a damma, ‘A yuwaan wu ta̱ gafura wu unusu wa̱ wu,’ ko a damma, ‘ꞌYon vu wala?’ ");
INSERT INTO tswNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","N ta yuwan ne, tsa̱ra̱ i reve a̱mu Mawun ma Vuma† ma̱ ta̱ nu ucira o uvaɗi u yuwan gafura vu unusu.” A̱vu u damma osowi a̱ lipuꞌu, “N damma, ꞌyon vu tara aavalu a̱ wu, vu ka̱ra̱ a̱ tyo o uꞌwa.” ");
INSERT INTO tswNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","E esu e le a ɗa u ꞌyoyin a̱vu u tara aavalu a̱ yi babu usa̱n, reve u ka̱ra̱ a̱ tyo o uꞌwa a yuwusaan A̱sula̱ ica. ");
INSERT INTO tswNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ama suru a uwa ta̱ asalama, a̱vu a yuwaan A̱sula̱ ica. Wovon u reme le ta̱, a̱vu a damma, “Anaꞌan tse ene ta̱ ili ya asalama.” ");
INSERT INTO tswNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ana Yesu kotoi a̱yi ndolo, a̱vu wu uta̱, a̱vu we ene za vu uꞌushishi wu utafa.† Aala a̱ yi a ɗa Levi. U cina yi ta̱ nden uba̱ta̱ wu ulinga. A̱vu u damma yi, “Toni mu.” ");
INSERT INTO tswNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","A̱vu u lyawa ili suru u ꞌyon, a̱vu u toni yi. ");
INSERT INTO tswNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","A̱vu u foɓo a̱buki a gbain o uꞌwa wa̱ yi adama e Yesu. A̱za̱ o uꞌushishi wu utafa a̱ da̱na̱ ta̱ pe lon, na ama o ro a alya oɓolo ne ele. ");
INSERT INTO tswNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","A̱vu Afarishi na̱ munlu n Wila̱, a gbarana ojoro a̱ yi, “Cine yaa lyuwusa ni i sowi na̱ a̱za̱ o uꞌushishi wu utafa na̱ a̱za̱ o unusu?” ");
INSERT INTO tswNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","A̱vu Yesu usu le, “Vuma na ri gbaga u ciga za va̱ a̱guma̱ shi, she za vu ubanakun. ");
INSERT INTO tswNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","N ta̱wa̱ adama a̱ a̱za̱ a̱ a̱ɓula̱ shi, she n ɗe a̱za̱ o unusu tsa̱ra̱ a vadala.” ");
INSERT INTO tswNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","A̱vu a damma yi, “Ojoro a Yahaya a tsu yuwusan ta̱ akuli na avasa, ne ɗa waru ojoro a Afarishi, agba a̱za̱ a̱ wu she a lyuwa o sowo.” ");
INSERT INTO tswNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","A̱vu u usu le, “I ta zuwa nꞌutsa̱ n vali vu kasaꞌavu n yuwan akuli, a̱yi lo oɓolo ne ele? ");
INSERT INTO tswNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mantsa ma̱ ta̱ lo a̱ ta̱wa̱ ana aa tara le valiꞌi, a̱tsuma̱ a rana ndolo a ta yuwan akuli.” ");
INSERT INTO tswNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Reve u yuwaan le iroci i nda, u damma: “Babu za na a paɗa tana saꞌavu u lapula akuci a tana na̱ a̱yi. Nu u yuwan ne, u ta̱ vura̱nu a̱vu u kara akuciꞌi, agba apaɗi a tana saꞌavuꞌu wa ntsaa akuci a tanaꞌa shi. ");
INSERT INTO tswNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Waru, a̱a̱ tsun ribina saꞌavu a akuci e itsa̱n yu kwan shi, adama a na ribinaꞌa u to ɓoso itsa̱ꞌa̱n. Na̱ a̱ tsun yi pe, u ta̱ lungusa̱ ribina oɓolo ni itsa̱ꞌa̱n. ");
INSERT INTO tswNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","E itsa̱n i saꞌavu i ɗa a̱ tsu tsun ribina. ");
INSERT INTO tswNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Aza a na o tsu sowo wasu aa ciga o sowo ribina shi, adama a na wasu u laꞌaa le ta̱. A ta damma, ‘Akuci a laꞌa ta̱ ulobonu.’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Urana wa Ashibi,† a̱yi a ɓatsasa a̱ a̱ɗuma̱ e ishina, reve ojoro a̱ yi a kuɗusa a̱ga̱za̱ e ishinaꞌa, a picirasa na a tami. ");
INSERT INTO tswNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","A̱vu Afarishi o ro a damma, “Nye i zuwai yaa kuɗusa ishina, i reve wila̱ u ɗa o urana wa Ashibi shi?” ");
INSERT INTO tswNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","A̱vu Yesu usu le, “I reve ili i na Da̱wuda na̱ nꞌutsa̱ ma̱ yi n yuwain, a mantsa ma na a uwwai ambulu shi? ");
INSERT INTO tswNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ana u uwai o uꞌwa wa̱ A̱sula̱, reve u tama opopofu a̱ Wila̱. Reve u ca akapi a na a̱ da̱na̱i oɓolo na̱ a̱yi, agba aza a na nan ganu ɗa goon aa tama.” ");
INSERT INTO tswNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","A̱vu u koso na adanshi, “A̱mu Mawun ma Vuma, Zagbain vu urana wa Ashibi u ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Urana wa Ashibi o ro, a̱vu u uwa a̱ a̱a̱ꞌisa̱, reve u reme uritosu. Reve u cina pe vuma na ukere u usaꞌani wa̱ yi u da̱na̱i usowu. ");
INSERT INTO tswNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Afarishi gba na̱ munlu n Wila̱ a zamishi ta̱ ure u na ee reme yi nu unusu. A̱vu a karishi yi ana, tsa̱ra̱ e ene ko u ta̱ yuwaan yi opocino urana wa Ashibi. ");
INSERT INTO tswNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Agba u reve ta̱ ili i na aa yuwusan majiyan, reve u damma vumaꞌa, “ꞌYon vi isawan mishin elime a ama suru.” A̱vu u ꞌyon wi isawan. ");
INSERT INTO tswNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","A̱vu we ece le, “N ta yuwusan ɗu yeci. Zane ɗa laꞌai ulobonu a̱ Wila̱ wu urana wa Ashibi: a yuwan isaꞌani ko iwuya? A wawa ko o una?” ");
INSERT INTO tswNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","A̱vu u ka̱lyuwa̱ le suru, a̱vu u damma vumaꞌa, “Canana ukere wa̱ wu.” Reve u canana, ɗaɗa ukere wa̱ yi u ka̱mba̱i gbaga. ");
INSERT INTO tswNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Reve a uwwa upan lo, reve a dammulai ununa aa yuwan na̱ Yesu. ");
INSERT INTO tswNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","A̱tsuma̱ a rana ndolo, a̱vu u ka̱ra̱ a̱ ꞌya̱wa̱ a masasan, tsa̱ra̱ u yuwan avasa. Reve u yuwan avasaꞌa e ekere a̱ A̱sula̱ ayin ma̱ɓula̱. ");
INSERT INTO tswNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ana usana u tawai, reve u ɗe ojoro a̱ yi, reve u ɗangwa ama kupa ne ejere, reve u ɗe le ajiya.† ");
INSERT INTO tswNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","A̱vu u ɗe Simo (za na u cayi aala Bituru), na̱ zawaꞌa va̱ yi Andarawu, na̱ Yakubu, na̱ Yahaya, oɓolo na̱ Filibu, na̱ Batalamawu, ");
INSERT INTO tswNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","u ɗangwa ta̱ fo Matta, na̱ Toma, oɓolo waru na̱ Yakubu mawun ma Alfa, na̱ Simo za na a̱ tsu ɗe Bakanani, ");
INSERT INTO tswNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","waru u ɗangwa ta̱ Yahuza mawun ma Yakubu na̱ Yahuza Iskariyoti, za na wina niyi. ");
INSERT INTO tswNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Reve u cipa̱ oɓolo ne ele, reve wi isawan a agalaci a saꞌani. Otoni a̱ yi na̱ a̱bunda̱ a̱ da̱na̱ ta̱ lo na ama a̱ a̱bunda̱ diga Yahuda, na̱ Urishelima, nu upasu wi iɗa ya Taya na̱ Sida, aza a na a̱ ri a̱ ngeꞌen m mala. ");
INSERT INTO tswNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","A̱ ta̱wa̱ ta̱ tsa̱ra̱ a uwwa yi, reve waru u yuwaan le opocino a banakun le. Aza a na a̱ da̱na̱i no otoni a̱ lima̱ o oꞌwo ta̱ gbaga. ");
INSERT INTO tswNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Reve ama suru a ciga a̱ juꞌwa̱n yi, adama a na ucira wu utusa̱ ta̱ a̱tsuma̱ a̱ yi, reve o oꞌwo gbaga suru. ");
INSERT INTO tswNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","A̱vu u ka̱lyuwa̱ ojoro a̱ yi, reve u damma le, “Abaꞌun za ɗu ɗa aza a na a̱ ri nu ulambu, adama a na tsugono tsa̱ A̱sula̱ za ɗu ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Aza a na a uwwusa ambulu gogo, abaꞌun za ɗu ɗa, adama a na a̱ ta̱ cuwa̱ton ɗu. A̱za̱ e mesun gogo abaꞌun za ɗu ɗa, adama a na i ta̱ ta̱wa̱ i zoꞌoso. ");
INSERT INTO tswNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Abaꞌun za ɗu ɗa mantsa ma na ama a ꞌyuwan ɗu, a̱vu a kasa ɗu, a̱vu e isula ɗu, agba ee ɗe ɗu na ala a saꞌani shi, adama a̱ va̱ Mawun ma Vuma. ");
INSERT INTO tswNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Na̱ cuꞌun ndolo fara, i yuwan ma̱za̱nga̱, a̱vu i yuwan tsuꞌyan tsu uyoꞌo wa asuvu, adama a na atsupu a̱ ɗu a̱ ta̱ a̱bunda̱ ɗe zuva. Ne ɗa nan dada le a yuwain na ama̱sula̱ nu ujimu. ");
INSERT INTO tswNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Woo yoꞌono a̱za̱ o utsuru gogo shi, adama a na i tsura̱i ɗe asuvu nden. ");
INSERT INTO tswNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Woo yoꞌono a̱za̱ o ucuwun gogo shi, i ta̱ ta̱wa̱ i yuwan ambulu. Woo yoꞌono a̱za̱ e izoꞌoshi ya avama gogo shi, i ta̱ ta̱wa̱ i shon na̱ yisaali. ");
INSERT INTO tswNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Woo yoꞌono aza a na ama aa cuwusa shi. Ne ɗa nkaya n le n cuwai ama̱sula̱ e epen.” ");
INSERT INTO tswNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","A̱vu Yesu lyuwa elime na adanshi u damma, “Agba n ta dansaa ɗu aza a na aa uwwusa mu, i ciga nꞌyuwatan n ɗu, i yuwaan aza a na a ꞌyuwan ɗu isaꞌani. ");
INSERT INTO tswNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","I zuwaa aza a na a yuwaan ɗu una̱ abaꞌun, aza a na a yuwusaan ɗu ikpaꞌa, i yuwaan le avasa. ");
INSERT INTO tswNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Na̱ za ro ɓasa wu o ugbaguzu u ta̱, vadalaa yi ugbaguzu we ire. Za na usa nuwu aapalutsu, vu ca yi utugu fo. ");
INSERT INTO tswNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Za na pati nuwu ili suru, vu neꞌe yi. Na̱ vuma ro usa ili ya̱ wu, she ve ece yi wan. ");
INSERT INTO tswNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ununa vu cigai ama a yuwaan wu, vu yuwaan le ne fo. ");
INSERT INTO tswNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Na̱ vu ciga aza a na a yuwaan nuwu isaꞌani goon, atsupu e ne a ɗa va̱a̱ tsura̱? A̱za̱ o unusu fo a tsu ciga ta̱ aza a na a ciga nle. ");
INSERT INTO tswNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Na̱ vu yuwan isaꞌani a̱ tyo aza a na a yuwaan nuwu isaꞌani goon, to, atsupu e ne a ɗa va̱a̱ tsura̱? A̱za̱ o unusu fo a tsu yuwan ta̱ ne. ");
INSERT INTO tswNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na̱ yaa yuwusan majiyan she aza a na aa tsupa ɗu ɗa yaa ca okopu, to, atsupu e ne a ɗa ya̱a̱ tsura̱? A̱za̱ o unusu fo a tsu ca ta̱ a̱za̱ o unusu, tsa̱ra̱ a̱ ta̱wa̱ a tsupa le ununa o kopoi. ");
INSERT INTO tswNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","I ciga nꞌyuwatan n ɗu, i yuwaan le isaꞌani. I kopoo le agba i zuwa okolo na aa tsupa ɗu wan. Ne ɗa atsupu a̱ ɗu a̱a̱ da̱na̱ a̱bunda̱. Ne ɗa waru yoo oꞌwo muwun m Mogono ma̱ A̱sula̱. Waru u tsu yuwaan ta̱ aza a na o tsu godyo shi, na̱ a̱za̱ e iwuya isaꞌani. ");
INSERT INTO tswNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ye eneshe iliyali ya ama ununa Dada ɗu eneshe iliyali.” ");
INSERT INTO tswNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","A̱vu u lyuwa elime na adanshi, “I geꞌeto wan, a̱ɗu fo ee geꞌetowa̱ ɗu shi. I kototo wan, tsa̱ra̱ o kototo ɗu wan. I yuwan gafura, tsa̱ra̱ a yuwaan ɗu gafura. ");
INSERT INTO tswNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Neꞌei, e te neꞌe ɗu: makundatsu ma saꞌani, wukiru ushiwun, torotoro, hali ocusho e iɗa. Ne ɗa a̱a̱ tsuwa̱n ɗu e ekere. Na̱ makundatsu ma na i kunzuwa̱yi, na̱ a̱yi ɗa a̱a̱ kunzuwa̱ ɗu.” ");
INSERT INTO tswNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Reve u yuwaan le iroci i nda: “Irumba̱ i ta gura roco irumba̱ ure? Ele ra a̱a̱ riya̱ a̱ a̱a̱ka̱ri shi? ");
INSERT INTO tswNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mawun ma makaranta ma laꞌa manlu ma̱ yi shi, amma za na o ritoi lon, u to oꞌwo ununa manlu ma̱ yi ma̱ ri. ");
INSERT INTO tswNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Cine va̱a̱ ka̱nla̱sa̱ macaka ma na ma̱ ri pe a̱ lyusu vu za va̱ wu, a̱vu vi icina na̱ a̱a̱gba̱la̱ a na a̱ ri pe a̱ lyusu va̱ wu? ");
INSERT INTO tswNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Cine vaa gura damma za va̱ wu, ‘Isawan, lyawa mu uta̱a̱ macaka ma na ma̱ ri pe a̱ lyusu va̱ wu,’ agba a̱vu vu rono a̱a̱gba̱la̱ a na a̱ ri pe a̱ lyusu va̱ wu shi? A̱vu vuma vi ikpaꞌa! Rono neꞌen a̱a̱gba̱la̱ a na a̱ ri a̱ lyusu va̱ wu, tsa̱ra̱ ve ene ulobonu u na voo uta̱a̱ za va̱ wu macaka ma na ma̱ ri a̱ lyusu va̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","A̱vu Yesu lyuwa elime na adanshi, “Uɗanga u saꞌani wu lo ana u tsu matsan muwun m babu a̱ɓula̱ shi, agba uɗanga u babu a̱ɓula̱ u tsu matsan muwun n saꞌani shi. ");
INSERT INTO tswNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Uɗanga suru na̱ muwun ma̱ yi n ɗa a̱ tsu reve yi. A tsu taɓa ubiri o uɗanga wa awanda shi, ko a̱ɗyumbu a ataci† shi. ");
INSERT INTO tswNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Vuma va̱ a̱ɓula̱ u tsu uta̱a̱ ta̱ ni ili i saꞌani i na u zuwai o ookolo, za vu ulambu wa̱ a̱ɓula̱ waru e ili yu ulambu ya̱ a̱ɓula̱ a na u zuwai o ookolo pe ɗa ulambu wa̱ a̱ɓula̱ u tsu uta̱. A̱tsuma̱ e ili i na i ri pe o ookolo a̱ yi pe ɗa adanshi a̱ tsu uta̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","A̱vu u lyuwa elime na adanshi, “Cine tsa ɗa ya̱a̱ ɗesu mu, ‘Zagbain, Zagbain,’ agba i yuwan ili i na n damma nɗu i yuwan shi? ");
INSERT INTO tswNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Za na a̱a̱ ta̱wusa̱ ya̱ꞌa̱ va̱ aa uwwusa ili i na maa dansa suru, a yuwusan le waru suru, n to roco ɗu cuꞌun vuma na u ri. ");
INSERT INTO tswNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","U ta̱ cuꞌun vuma na aa suwusa usaa, reve u ka̱pa̱ wa̱cin wu usaa a̱lungu, reve u suwa ikyun yu usaaꞌa uba̱ta̱ o ugbamu. Ana mini ma gbain ma̱ ta̱wa̱i, a̱vu u keɓe usaaꞌa, agba u gura varu yi shi. Ana wo oꞌwoi a suwa niyi ulobonu. ");
INSERT INTO tswNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Za na uwwai adanshi a̱ va̱, agba u linga ni ili i na wu uwwai shi, u to oroci a vuma na suwai uꞌwa wa̱ yi a̱ wuyun, agba u ri ni ikyun shi. Ana mini ma lapai usaaꞌa, reve u ra̱mo babu usa̱n. Uriyu wu uꞌwa u ndolo u riya̱ ta̱ suru suru.” ");
INSERT INTO tswNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ana u kotoi a dansaa ama ili i ndolo suru, reve u uwa Kafarnahum. ");
INSERT INTO tswNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Yali† ya̱ Roma i ro i shi ta̱ na aagbashi a na u cigai lon. Aagbashiꞌi u shi ta̱ ubanakun, gashi u ta̱ kuwa̱. ");
INSERT INTO tswNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ana wu uwwai adama e Yesu, reve u lyunguwa̱ yi azagbain a aza a Israꞌila a damma yi u ta̱wa̱ u ka̱mba̱to aagbashi a̱ yi gbaga. ");
INSERT INTO tswNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ana a̱ ta̱wa̱i uba̱ta̱ wa̱ yi, reve a pati yi, adansa, “Vuma nda rawa ta̱ vu yuwaan yi ulinga u nda, ");
INSERT INTO tswNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","adama a na u ciga ta̱ iɗa i tsu lon, waru a̱yi ɗa u suwaa ntsu a̱a̱ꞌisa̱ a̱ tsu.” ");
INSERT INTO tswNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Reve u kuru le. A̱yi a rawa zuzu nu uꞌwaꞌa, reve yaliꞌi u lyungu nꞌutsa̱ ya̱ꞌa̱ yi, a damma yi, “Zagbain, she vu damaton aciya̱wu wan. N rawa vu uwa o uꞌwa u va̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Waru n rawa n ta̱wa̱ ya̱ꞌa̱ wu shi. Vu yuwan adanshi goon u rawa ta̱, aagbashi a̱ va̱ o to oꞌwo gbaga. ");
INSERT INTO tswNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Adama a na a̱mu fo n ta̱ na̱ za na laꞌa numu, waru n ta̱ na̱ a̱soja a na a̱ ri za̱la̱ va̱. Agba n tsu damma ta̱ za nda, ‘ꞌYa̱wa̱,’ reve gba u ꞌya̱wa̱. Waru n tsu damma ta̱ za ro, ‘Ta̱wa̱’, reve gba u ta̱wa̱. Aagbashi a̱ va̱ waru, n tsu damma yi ta̱, ‘Yuwan tsunda,’ a̱vu u yuwan.” ");
INSERT INTO tswNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ana Yesu uwwai ne, reve u yuwan asalama adama a yaliꞌi. Reve u vadala u damma oɓolo a ama a na oo tono yi, “N ta dansaa ɗu, ko a̱tsuma̱ a Israꞌila n tsura̱ ucawu wo okolo ne tsunda shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ana aza a na a̱ lyunguyi a̱ ka̱mba̱i o uꞌwa, reve a cina aagbashiꞌi wo oꞌwo gbaga. ");
INSERT INTO tswNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","A jima shi, ɗaɗa u ka̱ra̱i a̱ tyo a̱ lyuci na a̱ tsu ɗe Nayim, reve ojoro a̱ yi no oɓolo a ama a̱ kuru yi. ");
INSERT INTO tswNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ana u rawai zuzu nu uꞌuwata u lyuciꞌi, ɗaɗa a gaꞌain na̱ a̱a̱kwa̱kwa̱ utanuwu. Agba a̱yi ɗa ulobo a̱ ndeꞌen o umatsun u makuci ma̱ yi; waru makuci ma̱ yi ma̱runa̱ ma ɗa. Ama a̱ a̱bunda̱ a̱ lyuciꞌi a̱ shi ta̱ oɓolo na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ana Zagbain we ene niyi, reve we ene iliyali ya̱ yi, a̱vu u damma yi, “She vu shon wan.” ");
INSERT INTO tswNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Reve u rawa u juꞌwa̱n a̱a̱kpa̱ga̱ꞌa̱, reve aza a na a tanu niyi e isawan kuci. A̱vu u damma, “Ulobo, n ta dansaa wu, vu ꞌyon.” ");
INSERT INTO tswNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Reve a̱a̱kwa̱kwa̱ꞌa̱ u ꞌyon u da̱nu, reve u uwa adanshi. Reve u tara yi u ca makuci ma̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Reve a uwwa wovon suru, reve a yuwaan A̱sula̱ ica. Reve a damma, “Tsu tsura̱ ta̱ vuma gbain va̱ A̱sula̱ a̱tsuma̱ a̱ tsu!” Waru, “A̱sula̱ a cuwan ta̱ na ama a̱ yi!” ");
INSERT INTO tswNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Reve alabari a̱ yi a baza a̱tsuma̱ a Yahuda ni iɗa i na i ri lo zuzu. ");
INSERT INTO tswNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Reve ojoro a Yahaya a damma yi ili i na i farai suru. ");
INSERT INTO tswNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ɗaɗa Yahaya ɗeyi ama e re a̱tsuma̱ o ojoro a̱ yi, reve u lyungu le uba̱ta̱ wu Zagbain, adansa, “A̱vu ɗaɗa za na ri lo a̱ ta̱wa̱ꞌa̱, ko tsu piri za ro?” ");
INSERT INTO tswNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ana amaꞌa a rawai uba̱ta̱ wa̱ yi, reve a damma, “Yahaya za vu Urumbusu ɗa lyungu ntsu ya̱ꞌa̱ wu, ana, ‘A̱vu ɗaɗa za na ri lo a̱ ta̱wa̱ꞌa̱ ko tsu piri za ro?’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Babu usa̱n, reve Yesu ka̱mba̱to a̱za̱ o ubanakun na̱ mɓa̱la̱ icuꞌun icuꞌun, no ozo o otoni a̱ lima̱ gbaga. Waru u kpa̱tuꞌwa̱ ta̱ esu a̱ nrumba̱. ");
INSERT INTO tswNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Reve u usu le, “ꞌYa̱wa̱i i damma yi ili i na yu uwwai, ni ili i na ye enei: nrumba̱ me ene ta̱ ure, a̱kutsuma̱ a wala ta̱, nkutu mo oꞌwo ta̱ gbaga. Waru agulani a uwwa ta̱ adanshi, a̱ ꞌya̱sa̱n ta̱ a̱kwa̱kwa̱. A̱za̱ e iliyali waru a uwwa ta̱ alajiya a Alabari a Saꞌani. ");
INSERT INTO tswNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Za va abaꞌun ɗa za na a̱a̱ ta̱ɗa̱tsa̱ adama a̱ va̱ shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ana ojoro a Yahaya a̱ ka̱ra̱i, reve u uwa a yuwusaan amaꞌa adanshi a Yahaya, a̱vu u damma, “Nye i ꞌya̱wa̱i a̱ka̱nla̱ ɗe a̱tsuma̱ o una? Apumpu a na upepu wa̱a̱ jinga̱ɗa̱sa̱? ");
INSERT INTO tswNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Na̱ ne ɗa shi, nye i ꞌya̱wa̱i ye ene? Vuma uꞌwotowu ni itana i saꞌani? Oꞌo, aza a na a̱ ri ni itana i saꞌani gba, aza a na a̱ ri a̱ nden mu uyoꞌo o ukobu u tsugono u ɗa a̱ ri. ");
INSERT INTO tswNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nye i ꞌya̱wa̱i ye ene? Vumava̱sula̱? Ee, amayun a ɗa, n damma ɗu, u laꞌa ta̱ vumava̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","A̱yi ɗaɗa za na a ɗanai a Adanshi a̱ A̱sula̱ adama a̱ yi, ‘Mpa n lyunguyi malingata ma̱ va̱ elime a̱ wu, za na oo foɓoo wu ure.’ ");
INSERT INTO tswNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Amayun a ɗa maa dansaa ɗu, a̱tsuma̱ a aza a na ka matsain, za lo na rawai Yahaya shi. Ko ana wo oꞌwoi ne, za na laꞌai uka̱la̱mu o tsugono tsa̱ A̱sula̱ u laꞌa yi ta̱ mgbain.” ");
INSERT INTO tswNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ana a uwwai ne, reve ama suru hali na̱ a̱za̱ o ushishi wu utafa a̱ usu A̱sula̱ a na za va̱ a̱ɓula̱† a ɗa, ana a̱ rumbu nle na̱ cuꞌun vu urumbusu wa Yahaya. ");
INSERT INTO tswNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Afarishi gba na aza a na e revei Wila̱ lon, reve a ꞌyuwan ifoɓi ya̱ A̱sula̱ adama e le, ana a ꞌyuwain urumbusu wa Yahaya. ");
INSERT INTO tswNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Reve Yesu lyuwa elime na adanshi, “Na̱ nye ɗa maa kurato ama o gogo a nda? Nye i ɗa o rotsoi? ");
INSERT INTO tswNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","O rotso ta̱ muwun n na n ri nden e eden e ɗewu va̱ a̱za̱ e le, ‘Tsi ivula̱a̱ ɗu ta̱ gbala, agba i jeꞌen shi. Tsu yuwaan ɗu ta̱ ishipa ya̱ a̱tsumola̱ngu, agba i saala shi.’ ");
INSERT INTO tswNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Ana Yahaya† za vu Urumbusu ta̱wa̱i u lyuwusa shi, agba u sowuso masayan ma inabi shi; a̱vu i damma, ‘U ta̱ no otoni!’ ");
INSERT INTO tswNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","A̱vu waru a̱mu Mawun ma Vuma n ta̱wa̱ ta̱ a lyuwusa o sowuso, reve i damma, ‘Apa liwi no osowi, iꞌutsa̱ ya̱ a̱za̱ o ushishi wu utafa na̱ a̱za̱ o unusu!’ ");
INSERT INTO tswNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Agba a̱ tsu reve ta̱ urevu wa̱ A̱sula̱ amayun a ɗa adama o ure u na ama o toni niyi.” ");
INSERT INTO tswNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Reve Mafarishi mo ro, za na a̱ tsu ɗe Simo, u banu Yesu u ꞌya̱wa̱ u lyuwa ilyalya na̱ a̱yi. Reve u ꞌya̱wa̱ o uꞌwa u Mafarishiꞌi, reve u da̱nu alya. ");
INSERT INTO tswNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ka ro shi ta̱ pe a̱tsuma̱ a̱ lyuciꞌi, za na da̱na̱i nu unusu. Ana wu uwwai u ta̱ pe a alya e ilyalya o uꞌwa wa̱ Simo Mafarishiꞌi, reve u ta̱wa̱ na̱ meden ma saꞌani ma maniꞌin ma̱ ma̱guru me ikebe. ");
INSERT INTO tswNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Reve u kingyo zuzu na̱ a̱yi, ɗaɗa u uwai mesun e reꞌwetosu ana e Yesu na aɓara a̱ yi. Reve u tasa le na̱ a̱nji a̱ yi, a̱vu u katala ana a̱ yi. A̱vu u sukuma le maniꞌiꞌin. ");
INSERT INTO tswNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ana Mafarishi ma na ma banu niyi me enei ne, reve u jiyan o ookolo a̱ yi, “Na̱ shi vuma nda vumava̱sula̱ ɗa, u shi te reve cuꞌun vu ka ne ɗa a̱ juꞌusa̱n yi, adama a na za vu unusu ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Reve u usu u damma yi, “Simo, n ta̱ ni ili i na maa damma wu.” Reve u usu, “Nye i ɗa, manlu?” ");
INSERT INTO tswNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","A̱vu u damma, “Vuma ro shi ta̱ o tono ama e re utan, za ta̱ ikebe i na i rawai ikebe yu ulivu ukpakuton (500), za ta̱ waru kupoton. ");
INSERT INTO tswNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ana a gura tsupai shi, reve u lyawaa le ikebeꞌe. A̱tsuma̱ e le zane ɗa aa laꞌa ciga yi?” ");
INSERT INTO tswNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Reve u usu, “E yeni i va̱, za na a lyawayi a̱bunda̱.” Reve Yesu usu yi, “Vu usu ta̱ mejege.” ");
INSERT INTO tswNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ana u vadalai uba̱ta̱ wu kaꞌa, reve u damma Simo, “Ve ene ta̱ ka nda? N uwa ta̱ o uꞌwa wa̱ wu, vu ca mu mini n saꞌa ana shi. A̱yi gba u reꞌweto ta̱ ana a̱ va̱ na aɓara a̱ yi, reve u tasa le na̱ a̱nji a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ana vu raba numu, vu katala mu shi. A̱yi gba diga ana n uwai pa u lyawa ukatalu wa ana a̱ va̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Vu sukuma aaci a̱ va̱ maniꞌin shi. A̱yi gba u sukuma ta̱ ana a̱ va̱ maniꞌin ma̱ ma̱guru. ");
INSERT INTO tswNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Adama o ndolo n ta dansaa wu, unusu wa̱ a̱bunda̱ wa̱ yi suru a yuwaan yi ta̱ gafura, adama a na u roco ta̱ icigi lon. Waru za na a yuwayin gafura waꞌa, icigi ya̱ yi waꞌa ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Reve u damma kaꞌa, “A yuwaan wu ta̱ gafura wu unusu wa̱ wu.” ");
INSERT INTO tswNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ɗaɗa aza a na a̱ ri a alya oɓolo na̱ a̱yi a uwai a dansa va̱ni le, “Zane ɗa ne tsundaꞌa, zane ɗa fo rawai u yuwan gafura vu unusu?” ");
INSERT INTO tswNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Reve u damma kaꞌa, “Ucawu wo okolo a̱ wu u wawa wu ta̱. Wala vu rawa lafiya.” ");
INSERT INTO tswNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","A jima shi, ɗaɗa Yesu ka̱nda̱ruwa̱i ilyuci na̱ mulyuciꞌi a yuwusan alajiya, a casu Alabari a Saꞌani o tsugono tsa̱ A̱sula̱. Ele Kupanejereꞌe a̱ da̱na̱ ta̱ oɓolo na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Waru a̱ma̱ci a na o uta̱yi otoni a̱ lima̱ nu ubanakun a̱tsuma̱ e le o toni yi ta̱. Ele ɗa Meri,† za na a̱ tsu ɗe Magadaliya, za na o uta̱yi otoni a̱ lima̱ e cindere a̱tsuma̱ a̱ yi, ");
INSERT INTO tswNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","na̱ Yuwana ka va Kuza (zagbain o uꞌwa wa̱ Hiridu), na̱ Suzana, no ozo o ro na̱ a̱bunda̱. A̱ma̱ci a nda a kambusa le ta̱ ni ili ya aciyele. ");
INSERT INTO tswNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ana ama a̱ a̱bunda̱ o ɓolotoi, waru ama a̱ ta̱wusa̱ ya̱ꞌa̱ yi lyuci lyuci, reve u yuwaan le iroci: ");
INSERT INTO tswNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Cimbi ro ꞌya̱wa̱ ta̱ ca̱ꞌa̱n. A̱yi pe a̱tsuma̱ a mazaza me icuꞌun, reve ozo o ro o oco o ure. A̱vu ama a dadasa icuꞌuꞌun, a̱vu nnunu n ka̱ka̱ɗa̱ le. ");
INSERT INTO tswNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Icuꞌun i ro waru yo oco uba̱ta̱ wa atali. Ana o uta̱i, reve e ꞌyewe adama a na a̱ tsura̱i a̱ta̱ni shi. ");
INSERT INTO tswNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","A̱vu ozo o ro o oco a awanda, a̱vu a̱ ꞌyon oɓolo na awandaꞌa, a̱vu awandaꞌa a gbagbala le. ");
INSERT INTO tswNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","A̱vu icuꞌun i ro yo oco a̱ ma̱bula̱ ma saꞌani, a̱vu ishinaꞌa a yuwan mgbain, a̱vu a matsan a̱ga̱za̱ a̱ga̱za̱. Nu u cuꞌwa̱n ma̱cuꞌuntsu ma̱ ta̱, reve a matsan ncuꞌuntsu ukpaku.” Ana u dammai ne, a̱vu u ꞌya̱sa̱n uɗyo u damma, “Za na ri na atsuvu, wu uwwa.” ");
INSERT INTO tswNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Reve ojoro a̱ yi e ece yi ucuɗuwu wi irociꞌi. ");
INSERT INTO tswNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Reve u damma le, “A̱ɗu ɗa a lyawai i reve ili yu usokowu u tsugono tsa̱ A̱sula̱. Amma aza a na a̱ ri pe shi, she ni iroci i ɗa a tsu yuwaan le tsa̱ra̱: ‘A ta gura ka̱lyuwa̱, agba e ene shi. A mawwa a ta gura uwwa, agba aa gura tsura̱ urevu shi.’ ");
INSERT INTO tswNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Apa ucuɗuwu wi irociꞌi: Cuꞌun a̱yi ɗa adanshi a̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Icuꞌun i na yo ocoi o ure, ele ɗa iroci ya aza a na a uwwai adanshi a̱ A̱sula̱. Reve Mekerenkesu ma̱ ta̱wa̱, a̱vu u tara le adanshiꞌi o okolo e le, tsa̱ra̱ a zuwa okolo e le a wawa le wan. ");
INSERT INTO tswNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Icuꞌun i na yo ocoi uba̱ta̱ wa atali, ele ɗa aza a na a̱ ushiyi adanshiꞌi na̱ ma̱za̱nga̱ ana a uwwa niyi, agba a̱ ri na aralu shi. Ucawu wo okolo e le yashi meketeci ma ɗa, yashi yu ulyungusa̱, a̱vu a̱ riya̱. ");
INSERT INTO tswNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Aza a na o ocoi a awanda, ele ɗa aza a na a uwwai adanshi a̱ A̱sula̱, agba a̱tsuma̱ a mmalu n le, reve a̱tsuma̱lima̱, nu uyoꞌo wu uvaɗi, nu utsuru u reme le, reve a̱ kuɗa̱ a lyuwa elime. ");
INSERT INTO tswNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Aza a na o ocoi a̱ ma̱bula̱ ma saꞌani, ele ɗa ama a̱ a̱ɓula̱, aza a na a uwwai adanshi a̱ A̱sula̱, reve e reme yi ugbamu o okolo e le, a̱vu a yuwan ankuri a bala.” ");
INSERT INTO tswNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","A̱vu Yesu lyuwa elime na adanshi, “A tsu daɓa fitila, a̱vu a̱ kpa̱to yi na aasaꞌatsu shi, ko a zuwa yi a̱ mbungulu shi. A tsu zuwa yi ta̱ e eelele, tsa̱ra̱ aza a na a uwusa e ene ekan. ");
INSERT INTO tswNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Babu ili i na i ri usokowu i na oo uta̱a̱ a alanga e eteshe shi. Babu waru ili i na i ri wupalu e irumbu ana oo uta̱a̱ e ekan shi. ");
INSERT INTO tswNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","I ka̱lyuwa̱ ben ununa yaa uwwusa. Za na ri na̱ a̱yi a̱ ta̱ da̱shi yi, za na gba ri na̱ a̱yi shi, keꞌen na we inda u ri na̱ a̱yi a̱ ta̱ ushi yi i ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mma va̱ Yesu na̱ muwun ma̱ a̱na̱wu a̱ ta̱wa̱ ta̱ uba̱ta̱ u na u ri, amma adama o oɓolo a gura rawa zuzu na̱ a̱yi shi. ");
INSERT INTO tswNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","A̱vu a damma yi, “Mma va̱ wu na̱ muwun ma̱ a̱na̱wu ma̱ wu a̱ ta̱ ɗe a alanga, a ciga ta̱ e ene wu.” ");
INSERT INTO tswNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Reve u usu, “Mma va̱ na̱ muwun ma̱ a̱na̱wu n va̱, ele ɗa aza a na a uwwusa adanshi a̱ A̱sula̱, a̱vu a yuwusan ulinga na̱ a̱yi.” ");
INSERT INTO tswNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Urana u ro, a̱vu Yesu damma ojoro a̱ yi, “Tsu ꞌya̱wa̱i a̱ ngeꞌen m mala n ndeɗe.” A̱vu a uwa a wantsuꞌun oɓolo, reve a̱ ka̱ra̱. ");
INSERT INTO tswNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ele a̱tsuma̱ a mmalu, a̱vu nlavu m pura̱ yi. Reve wunla̱ nu upepu u ꞌyon a malaꞌa, reve mini ma ciga mo shiton wantsun u le, hali a̱ shi a ciga maliɓaa. ");
INSERT INTO tswNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Reve a̱ ꞌya̱wa̱ a jisan yi, reve a damma, “Zagbain, zagbain, tsu ciga ta̱ maliɓaa!” A̱vu u ꞌyon u ɓara upepu na̱ miniꞌi, reve upepuꞌu u von kwin. ");
INSERT INTO tswNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","A̱vu we ece le, “Te ɗa ucawu wo okolo a̱ ɗu?” Na̱ wovon na asalama, a̱vu e ecelei, “Zane ɗa ndaꞌa? Hali u yuwaan upepu na̱ mini nla̱ngi, reve a yuwan ili i na u dammai!” ");
INSERT INTO tswNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","A̱vu a rawa e iɗa ya Garasa, za na mini ma kasalai ni iɗa ya̱ Ga̱lili. ");
INSERT INTO tswNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu a̱ mota̱a̱ a wantsuꞌun, reve vuma ro a̱tsuma̱ a̱ lyuci gbain u gaꞌan na̱ a̱yi, u ta̱ no otoni a̱ lima̱. Vumaꞌa u jima ta̱ ana wo otoyi itana, ko wa asa a̱tsuma̱ a ama. Uba̱ta̱ wa ason u ɗa u tsu da̱na̱. ");
INSERT INTO tswNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ana we enei Yesu, a̱vu u ɓosho na̱ yisaali, a̱vu u riya̱ a̱ ma̱ka̱ka̱n ma̱ yi, a̱vu u saala lon, “Yesu, Mawun mo Mogono ma̱ A̱sula̱, te ɗa imini ya̱ wu na̱ a̱mu, n ta patishi wu she vu zuwa mu a̱ a̱tsuma̱lima̱ wan!” ");
INSERT INTO tswNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","U damma ta̱ ne, ana Yesu zuwai otoni a̱ lima̱ o ndolo a lyawa vumaꞌa. Na̱ a̱bunda̱ otoni a̱ lima̱ o ndolo a tsu vari ta̱ vuma ndolo e iɗa. A̱ tsu ɓa̱ru yi ta̱, reve a vara yi akani a ana ne ekere, tsa̱ra̱ a̱ da̱na̱ a̱ ka̱lyuwusa̱ yi. Agba u tsu kasa ta̱ akani o ndolo, reve otoni a̱ lima̱ o lo yi a̱ tyo a̱tsuma̱ o una. ");
INSERT INTO tswNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ana Yesu ece niyi, “Cine tsa ɗa aala a̱ wu?” A̱vu u usu, “Aala a̱ va̱ a ɗa Oɓolo,” adama a na otoni a̱ lima̱ a uwa yi ta̱ na̱ a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","A̱vu a pati yi, she u gba̱ra̱ le a̱ tyo a̱ a̱a̱ka̱ri a̱ a̱ruꞌun lungu-lungu a na a̱ ri nu utyo shi wan. ");
INSERT INTO tswNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Oɓolo a̱ ngurusumu ma̱ a̱bunda̱ n da̱na̱ ta̱ lo a alyuna za̱la̱ va agaɗi. A̱vu otoni a̱ lima̱ꞌa̱ a pati yi u lyawa le a uwa a̱tsuma̱ e le, reve u lyawa le a uwa. ");
INSERT INTO tswNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ana otoni a̱ lima̱ꞌa̱ o uta̱i a̱tsuma̱ a vumaꞌa, a̱vu a uwa a̱tsuma̱ a̱ ngurusumuꞌu. Reve oɓolo a̱ ngurusumuꞌu a suma a̱ zura̱ a̱ tyo a malaꞌa, reve a̱ kuwa̱ pe. ");
INSERT INTO tswNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aza a na a̱ da̱na̱i a aguɓa a̱ ngurusumuꞌu, a̱vu a suma, a̱ ꞌya̱wa̱ a ca alabari a̱ lyuci gbain na̱ mulyuci. ");
INSERT INTO tswNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","A̱vu ama a̱ ꞌya̱wa̱, tsa̱ra̱ e ene ili i na i farai. Ana a̱ ta̱wa̱i uba̱ta̱ wa̱ Yesu, a̱vu a cina lo vuma na da̱na̱i no otoni a̱ lima̱ nden uba̱ta̱ wa̱ yi, uꞌotowu ni itana nu ugbozu wa̱ yi. Reve wovon u tsura̱ le. ");
INSERT INTO tswNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Aza a na e enei ne esu e le, a̱vu a damma ununa a wawai za vo otoni a̱ lima̱ꞌa̱. ");
INSERT INTO tswNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","A̱vu ama e iɗa ya Garasa a pati yi u lyawaa le iɗa i le, adama a na a uwwa ta̱ wovon lon. A̱vu u uwa a wantsun, azama u lyawa le. ");
INSERT INTO tswNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","A̱yi gba za na otoni a̱ lima̱ o uta̱i a̱tsuma̱ a̱ yi, reve u pati tsa̱ra̱ u lyawa yi u kuru yi. Agba Yesu usu shi, ɗaɗa u damma niyi, ");
INSERT INTO tswNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ka̱mba̱ o uꞌwa, reve vu damma ili i na A̱sula̱ a yuwaan nuwu suru.” A̱vu vumaꞌa u ka̱ra̱, a̱vu u reme a casu aalabari e ili i na Yesu yuwaan niyi suru. ");
INSERT INTO tswNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ana Yesu ka̱mba̱i Ga̱lili, a̱vu oɓolo a raba yi, adama a na a ta pura yi. ");
INSERT INTO tswNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","A̱tsuma̱ a azagbagbain a̱ a̱a̱ꞌisa̱ꞌa̱, za na a̱ tsu ɗe Jayiru, u ta̱wa̱ ta̱ u kingyo a̱ ma̱ka̱ka̱n ma̱ yi, a̱vu u pati yi, tsa̱ra̱ u ꞌya̱wa̱ o uꞌwa wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Adama a na usheli u ta̱ wa̱ yi, za na ri aꞌwan kupa ne ejere, u ciga ta̱ ma̱kuwa̱a̱. A̱yi a̱tsuma̱ a mmalu, reve oɓoloꞌo a gbagbalasa yi. ");
INSERT INTO tswNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ka ro waru, za na yuwain aꞌwan kupa ne ejere o ocosu mpasa, wu una ta̱ ili i na u ri na̱ yi suru e ekere a̱ a̱za̱ a̱ a̱guma̱, agba u jebe yi shi. ");
INSERT INTO tswNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A̱vu u ta̱wa̱ nu ucina̱, a̱vu u juꞌwa̱n upasu wu utugu wa̱ Yesu. Babu usa̱n, ɗaɗa wocosu wu mpasa ma̱ yi n lyawai. ");
INSERT INTO tswNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","A̱vu Yesu ece, “Zane ɗa juꞌwa̱n numu?” Ana a wasain suru, reve Bituru damma, “Zagbain, ama a̱ a̱bunda̱ a ɗa a̱ ri pa, waru a ta gbagbalasa wu.” ");
INSERT INTO tswNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","A̱vu u damma, “A̱ juꞌwa̱n mu ta̱. Mu uwwa ta̱ ucira wu uta̱i a̱tsuma̱ a̱ va̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ana kaꞌa we enei waa gura soko aciya̱yi shi, a̱vu wu uta̱ e mejeꞌen ma̱ lipu, reve u kingyo a̱ ma̱ka̱ka̱n ma̱ yi. A̱ ma̱ka̱ka̱n ma ama suru, a̱vu u damma ili i na i zuwai u juꞌwa̱in utugu wa̱ yi nu ununa wo oꞌwoi gbaga babu usa̱n. ");
INSERT INTO tswNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","A̱vu u damma yi, “Usheli, ucawu wo okolo a̱ wu wo oꞌwoto wu ta̱ gbaga. Wala na asuvu nden.” ");
INSERT INTO tswNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","A̱yi a̱tsuma̱ a adanshi, a̱vu nanza ta̱wa̱ ɗe o uꞌwa wa Jayiru, zagbain va̱ a̱a̱ꞌisa̱ꞌa̱, a̱vu u damma Jayiru, “Usheli wa̱ wu u kuwa̱ ta̱ ɗe. She vu damaton manluꞌu wan.” ");
INSERT INTO tswNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ana Yesu uwwai ne, a̱vu u damma Jayiru, “She vu uwwa wovon wan. Ca okolo, u ta̱ ka̱mba̱ gbaga.” ");
INSERT INTO tswNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ana u rawai o uꞌwa wa Jayiru, u lyawa nanza uwa oɓolo na̱ a̱yi shi, she Bituru, na̱ Yahaya, na̱ Yakubu, na̱ dada na̱ mma mawuꞌun. ");
INSERT INTO tswNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ama pe a̱tsuma̱ a̱ mesun na̱ yisaali adama a̱ yi. A̱vu Yesu damma le, “Lyawai mesun. Koto u kuwa̱ shi. Nlavu n ɗa waa yuwusan.” ");
INSERT INTO tswNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","A̱vu o zoꞌoso yi, adama a na e reve ta̱ u kuwa̱ ta̱ ɗe. ");
INSERT INTO tswNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ana u remei ukere wa̱ yi, a̱vu u ꞌya̱sa̱n uɗyo, a̱vu u damma, “Usheli u va̱, ꞌyon!” ");
INSERT INTO tswNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Reve wivuwun wa̱ yi u ka̱mba̱, babu usa̱n ɗaɗa u ꞌyoyin. A̱vu u damma a ca yi ilyalya tsa̱ra̱ u lyuwa. ");
INSERT INTO tswNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","A̱vu nan dada va̱ yi a yuwan asalama. A̱vu u damma le, she a damma vuma ili i na i farai wan. ");
INSERT INTO tswNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Reve Yesu ɗe Kupanejereꞌe, a̱vu u ca le ucira nu ukadu e ekere o otoni a̱ lima̱ suru, waru a yuwan opocino icuꞌun-icuꞌun. ");
INSERT INTO tswNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Waru u lyungu le ta̱ a yuwan alajiya a Alabari a Saꞌani o tsugono tsa̱ A̱sula̱, reve waru a̱ ka̱mba̱to a̱za̱ o ubanakun gbaga. ");
INSERT INTO tswNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Reve u damma le, “She i tara ili i ro adama a mmalu n ɗu wan; she i tara aɗanga, ko tsa̱n, ko ilyalya, ko ikebe wan. Waru i tara utugu u ro wan. ");
INSERT INTO tswNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","O uꞌwa u na i cuꞌwain suru, i da̱nu pe hali mantsa ma na ya̱a̱ ka̱ra̱. ");
INSERT INTO tswNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Waru uba̱ta̱ u na a̱ usu nɗu shi, na̱ yaa lyawa lyuciꞌi, i ka̱ka̱la̱ ma̱buta̱ ma ana ma̱ ɗu. U to oꞌwo iroci i na yoo roco ama a̱ lyuciꞌi a yuwan mejege shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","A̱vu a̱ ka̱ra̱ a uwusa a̱ mulyuci, a yuwusan alajiya, waru a yuwusan opocino uba̱ta̱ biti. ");
INSERT INTO tswNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ana mogono Hiridu Antiba uwwai alabari e ili i na aa yuwusan, reve asuvu a̱ yi a̱ riya̱, adama a na ozo o ro a ta dansa, Yahaya ɗa a̱ ꞌya̱sa̱in a̱tsuma̱ a̱ a̱kwa̱kwa̱. ");
INSERT INTO tswNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ozo o ro gba a damma, ana Iliya ɗa ta̱wa̱i. Ozo o ro a damma, vuma ta̱ a̱tsuma̱ a ama̱sula̱ a ɗa ꞌyoyin. ");
INSERT INTO tswNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","A̱vu Hiridu damma, “N koɗo ta̱ aaci a Yahaya. To, zane ɗa maa uwwusa cuꞌun vi ili i nda adama a̱ yi?” Reve u ciga we ene yi. ");
INSERT INTO tswNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ana ajiyaꞌa a̱ ka̱mba̱i, reve a damma Yesu ili i na a yuwain. Reve u ka̱ra̱ oɓolo ne ele a̱ ngeꞌen a̱ tyo a̱ lyuci ro na a̱ tsu ɗe Besaida. ");
INSERT INTO tswNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ana oɓolo a ama e enei ne, reve a̱ kuru yi. A̱vu u raba le, reve u yuwaan le adanshi o tsugono tsa̱ A̱sula̱. Reve u ka̱mba̱to a̱za̱ o ubanakun gbaga. ");
INSERT INTO tswNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Urana a̱ ma̱riya̱a̱, reve Kupanejereꞌe a rawa a damma yi, “Vu lyawa amaꞌa adama a uwa a̱ mulyuci ni ilyuci i na i ri zuzu adama a cuꞌwan, adama waru a̱ tsura̱ ilyalya. Adama a na uba̱ta̱ u na tsu ri za pa shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","A̱vu u usu le, “Ca nle ilyalya.” Ɗaɗa a̱ usuyi, “Tsu ri ni ili i na i laꞌai akpatali o ton na̱ mugula n re shi. She na̱ tsa̱a̱ ꞌya̱wa̱ tsu tsulaa ama a nda ilyalya suru.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Ama a na a̱ shi lo a rawa ta̱ ali ukpakukupa uton.) A̱vu u damma ojoro a̱ yi, “Zuwai ama a̱ da̱nu oɓolo oɓolo, ama kupoton-uton.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Reve a yuwan ne, a zuwa le a̱ da̱nu suru. ");
INSERT INTO tswNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ana u tarai akpatali o toꞌon na̱ mugula n reꞌe, a̱vu u ꞌya̱sa̱n aaci u ka̱lyuwa̱ zuva, a̱vu u godyoo A̱sula̱. A̱vu wu busa a casu ojoro a̱ yi a̱ tyowushe ama. ");
INSERT INTO tswNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Suru nle a lyuwa ta̱ a̱ cuwa̱n. Ana o ɓolotoi akapi a na a buwai, a rawa ta̱ asaka kupa ne ejere. ");
INSERT INTO tswNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Urana u ro, a̱yi a avasa a̱yi a̱ ndeꞌen, a̱vu ojoro a̱ yi a rawa zuzu. A̱vu we ece le, “Zane ɗa ama aa tarasa mu?” ");
INSERT INTO tswNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Reve a̱ usu, “Ozo o ro a damma, a̱vu ɗa Yahaya za vu Urumbusu. Ozo o ro gba a damma Iliya ɗa. Ozo o ro waru a damma, vuma ta̱ a̱tsuma̱ a ama̱sula̱ a ɗa ꞌyoyin.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","A̱vu we ece le, “A̱ɗu gba, zane ɗa yaa tarasa n ri?” A̱vu Bituru usu u damma, “A̱vu ɗa Kristi Zamawawa,† za na uta̱i uba̱ta̱ wa̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Reve u ɓara le, she a damma za wan. ");
INSERT INTO tswNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","A̱vu u damma, “Amayun a ɗa, Mawun ma Vuma ma ta uwwa a̱tsuma̱lima̱ icuꞌun-icuꞌun. Azagbain, na̱ nan ganu a gbagbain, na̱ munlu n Wila̱ waru a ta ꞌyuwan yi, hali o una yi. O urana wa taꞌatsu, a̱ ta̱ ꞌya̱sa̱n yi.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Reve u damma le suru, “Za na cigai u kuru mu, she nu u wasan aciya̱yi, reve u tara akpata a̱ a̱tsuma̱lima̱ a̱ yi urana suru, a̱vu u kuru mu. ");
INSERT INTO tswNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Za na a yuwusan adama a wuma wa̱ yi, u ta lamba yi. Za na waru ꞌyuwain aciya̱yi adama a̱ va̱, a ta wawa yi. ");
INSERT INTO tswNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nye i ɗa vuma munai, nu u tsura̱ uvaɗi u nda suru, a̱vu u lamba wuma wa̱ yi? ");
INSERT INTO tswNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Za na aa uwwusa wono u va̱ na adanshi a̱ va̱, a̱mu Mawun ma Vuma fo n ta uwwa wono wa̱ yi, na̱ n ta̱wa̱ na̱ tsugbain tsa Dada tsa̱ va̱ na̱ tsugbain tsa nlingata ma̱ A̱sula̱ a akiza. ");
INSERT INTO tswNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Amma amayun a ɗa maa dansaa ɗu, ozo o ro a̱ ta̱ pa uba̱ta̱ u nda na a̱a̱ kuwa̱ shi, she ne e ene tsugono tsa̱ A̱sula̱.”† ");
INSERT INTO tswNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ana a yuwain ayin kunla̱, ana u yuwain adanshi o ndolo, a̱vu u tara Bituru na̱ Yahaya na̱ Yakubu. Reve a katsa masasan mo ro adama u yuwan avasa. ");
INSERT INTO tswNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","A̱yi a̱tsuma̱ a avasa, ɗaɗa urewesu wa̱ yi u vadalai, itana ya̱ yi waru a̱ ka̱mba̱i uꞌuri a lyulyuwusa esu. ");
INSERT INTO tswNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Reve e ene ama e re a adanshi na̱ a̱yi, ele ɗa Iliya na̱ Musa. ");
INSERT INTO tswNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","A̱ ta̱wa̱i a̱tsuma̱ a tsugbain a yuwusan adanshi o ukwa̱ wa̱ yi u na wa̱a̱ kuwushi Urishelima ununa Adanshi a̱ A̱sula̱ a dammai. ");
INSERT INTO tswNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bituru na aza a na a̱ ri oɓolo na̱ a̱yi, a̱ shi ta̱ a nlavu lon. Ana a̱ ꞌyoyin, reve e ene tsugbain tsa̱ yi na ama e re ana a̱ ri mishin na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ana ama o ndolo a lyawa niyi, a̱vu Bituru yuwan adanshi nu ulambu u majiyan, u damma Yesu, “Zagbain, u lobono ta̱ ana tsu ri pa. Tsu ta yuwan pa ogodo a taꞌatsu: za ta̱ za va̱ wu, za ta̱ za va Musa, za ta̱ waru za va Iliya.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ana u dammai ne, reve eleshe a̱ ta̱wa̱ wu pupala le, ɗaɗa a uwwai wovon. ");
INSERT INTO tswNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Reve uɗyo wu uta̱ pe ana, “A̱yi ɗa Mawun ma̱ va̱ za na n ɗangwai. Yu uwwa yi.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ana uɗyoꞌo u yuwain adanshi, a̱vu e ene Yesu a̱yi a̱ ndeꞌen. Reve a̱ ɓa̱ru na̱ le. A mantsa mo ndolo, a damma za ro ili i na e enei shi. ");
INSERT INTO tswNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ana usana u tawai, ana a̱ cipa̱i a masasaꞌan, a̱vu oɓolo a ama a gaꞌaton yi. ");
INSERT INTO tswNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Reve vuma ro a̱tsuma̱ o oɓoloꞌo u yuwan ɗewu, “Manlu, yuwan ankuri, ka̱lyuwa̱ mawun ma̱ va̱. Adama a na a̱yi ɗa mu goon. ");
INSERT INTO tswNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","No otoni a̱ lima̱ a kumba yi, u tso oruwo ta̱. Reve u polo yi, a̱vu wo oꞌwo e ikpatatsu, reve una̱ wa̱ yi u yuwan a̱puciꞌya̱. U tsu lyawa yi goꞌo shi, u tsu ciga ta̱ wu una yi. ");
INSERT INTO tswNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","A̱vu m pati ojoro a̱ wu o uta̱a̱ yi otoni a̱ lima̱ꞌa̱, agba a gura shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","A̱vu u usu, “A̱ɗu ama o gogo, aza a na a cayi okolo shi, ozo o okolo o ugbamu; hali mantsa ma̱ ne ma̱a̱ da̱nu na̱ a̱ɗu a yuwusaan ɗu ankuri? Ta̱wa̱ na̱ mawun ma̱ wu pa nda.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","A̱yi a̱ ta̱wa̱, a̱vu otoni a̱ lima̱ꞌa̱ o polo yi, a̱vu u uwa ikpatatsu. A̱vu Yesu ɓara otoni a̱ lima̱ꞌa̱, reve u ka̱mbuwa̱ mawuꞌun gbaga. Reve u ca dada va̱ yi a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Reve ama a uwa asalama o ucira wa̱ A̱sula̱. Ele a̱tsuma̱ a asalama e ili i na u yuwain suru, a̱vu u damma ojoro a̱ yi, ");
INSERT INTO tswNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Lyawa adanshi a nda a uwa a atsuvu a̱ ɗu. A ta wina Mawun ma Vuma e ekere a ama.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Agba ele a gura reve adanshiꞌi shi. O soko le ta̱ urevu wa adanshiꞌi adama e reve wan. Ele gba a uwwusa ta̱ wovon u na ee ece yi. ");
INSERT INTO tswNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","A̱vu mawasan ma̱ ꞌyon a̱tsuma̱ e le adama a zane ɗa zagbain a̱tsuma̱ e le. ");
INSERT INTO tswNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ana Yesu revei majiyan me le, ɗaɗa u tarai mawun mo ro, reve wi isawaton yi zuzu na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","A̱vu u damma le, “Za na ushiyi mawun ma nda na ala a̱ va̱, a̱mu ɗa u ushiyi. Waru za na usu numu, za na lyungu numu ɗa u ushiyi. Za na ri zawaꞌa a̱tsuma̱ a̱ ɗu, a̱yi ɗa zagbain.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Reve Yahaya usu, u damma, “Zagbain, tse ene ta̱ nanza o uta̱su otoni a̱ lima̱ na ala a̱ wu, agba tsu putsa yi ta̱ adama a na u ri oɓolo na̱ a̱tsu shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","A̱vu u damma yi, “She i putsaa yi wan, adama a na za na ꞌyuwan tsu shi, za tsu ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ana yashi i na wa̱a̱ ka̱ra̱ zuva yuwain zuzu, reve u saɓa a̱ tyo Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Reve u lyungu nlingata elime a̱ yi. A̱vu gba a̱ ka̱ra̱, reve a uwa a̱ ma̱lyuci ma aza a Samariya adama o foɓoo yi. ");
INSERT INTO tswNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","A̱vu amaꞌa a ꞌyuwan yi, adama a na u zuwai ma̱ka̱ka̱n ma̱ yi a̱ tyo Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ana Yakubu na̱ Yahaya ojoro a̱ yi e enei ne, a̱vu a damma, “Zagbain, vu ciga ta̱ tsu zuwa akina a̱ cipa̱ zuva u kula̱to le?” ");
INSERT INTO tswNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","A̱vu u vadala, reve u ɓara le. ");
INSERT INTO tswNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Reve a̱ ka̱ra̱ a̱ tyo a̱ ma̱lyuci mo ro. ");
INSERT INTO tswNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ele a mmalu o ure, a̱vu vuma ro damma yi, “N ta̱ kuru wu uba̱ta̱ u na vu tyoyi suru.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","A̱vu Yesu damma yi, “Nranji n ta̱ na angu; nnunu waru n ta̱ ni ikinda. A̱mu Mawun ma Vuma† n ri nu uba̱ta̱ u na maa gbasato shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","A̱vu u damma za ro, “Vu kuru mu.” A̱vu u damma, “Zagbain, lyawa neꞌen she na̱ n ciɗo aabara a̱ va̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","A̱vu gba u damma yi, “Lyawa a̱kwa̱kwa̱ a̱ ciɗo a̱kwa̱kwa̱ e le. A̱vu gbaꞌa vu ꞌya̱wa̱ vu yuwan alajiya o tsugono tsa̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","A̱vu za ro waru damma, “N ta̱ kuru wu manlu, agba lyawa neꞌen n ꞌya̱wa̱ n revetyo a̱za̱ o uꞌwa a̱ tsu uka̱ru u va̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ɗaɗa Yesu damma niyi, “Za na guza̱i uba̱ri wi inan, a̱vu u vadala a̱ ka̱nla̱sa̱ a̱ca̱pa̱, wu ntsaa na̱ tsugono tsa̱ A̱sula̱ shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ana o kotoi a̱yi ndolo, a̱vu Zagbain ɗangwisa ama o ro kupocindere ne ejere, a̱vu u lyungu le ejere-re, tsa̱ra̱ a̱ ka̱ra̱ elime a̱ yi a̱ tyo e ilyuci i na a̱yi wa̱a̱ ta̱wa̱ u ꞌya̱wa̱. ");
INSERT INTO tswNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","U damma le ta̱, “Ugasaꞌa u ta̱ a̱bunda̱, agba alingiꞌi a̱ ka̱la̱ma̱ ta̱. Adama o ndolo i pati Zagbain vu uɗuma̱ꞌa̱, tsa̱ra̱ u lyungu a̱za̱ o ulinga, tsa̱ra̱ a yuwaan yi ugasaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Walai! N ta̱ lyungusu ɗu cine i revei mukyokyon e memere ma̱ nkerenkesu. ");
INSERT INTO tswNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","I tara osonu e ikebe, ko tsa̱n, ko atan o ro wan. She i jima e ica̱su o ure wan. ");
INSERT INTO tswNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ni i fara uwa o uꞌwa, i fara yuwan, ‘A̱zoꞌwa! Tsu ta̱wa̱a̱ ɗu ta̱ na asuvu nden!’ ");
INSERT INTO tswNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na̱ vuma na cigai asuvu nden pe o uꞌwa u ndolo, lyawa asuvu nden n ɗu a̱ da̱nu o uꞌwa u ndolo. Agba na a ꞌyuwan, asuvu nden n ɗu a̱ ka̱mba̱ ya̱ꞌa̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yi isawan o uꞌwa u ndolo, i lyuwa i sowo ili i na a ca nɗu pe, adama a na lingi ntsaa ta̱ na atsupu a̱ yi. I ka̱nda̱ruwa̱ nden o uꞌwa u nda a̱ tyo o uꞌwa u ndeɗe wan. ");
INSERT INTO tswNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ni i uwa a̱ lyuci, a̱vu a̱ ushi ɗu, i lyuwa ili i na a̱ ta̱wa̱a̱ nɗu suru. ");
INSERT INTO tswNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","A̱za̱ o ubanakun, i yuwaan le opocino. A̱vu i damma le, ‘Tsugono tsa̱ A̱sula̱ tsa̱ ta̱ lo zuzu na̱ a̱ɗu.’ ");
INSERT INTO tswNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ni i uwa a̱ lyuci, a̱vu a̱ kuɗa̱ a̱ ushi ɗu, ꞌya̱wa̱i e re, a̱vu i damma, ");
INSERT INTO tswNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ma̱buta̱ ma na tsu dasai a ana a̱ tsu tsu ka̱pa̱tsa̱a̱ ɗu ta̱. I reve, tsugono tsa̱ A̱sula̱ tsa̱ ta̱ lo zuzu.’ ");
INSERT INTO tswNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","N ta dansaa ɗu o urana wu ugeꞌetosu, ugeꞌetosu wo Sodom u to oꞌwo waꞌa e ekere a̱ lyuci ndolo.” ");
INSERT INTO tswNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","A̱vu Yesu lyuwa elime na adanshi, “Woo yoꞌono ɗu shi, aza a Korasinu, woo yoꞌono ɗu shi, aza a Besaida. Na̱ a̱ shi a yuwaan aza a Sida na aza a Taya ili ya asalama i na a yuwaan ɗu, a̱ shi ta vadala nu ujimu, a̱vu a̱ da̱nu na akashi usukutu, adama a̱ a̱tsumola̱ngu. ");
INSERT INTO tswNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","O urana wu ugeꞌetosu, A̱sula̱ a ta laꞌa roco Taya na̱ Sida isaꞌani na̱ a̱ɗu. ");
INSERT INTO tswNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A̱vu Kafarnahum, a̱ ta̱ ꞌya̱sa̱n wu zuva? Oꞌo, a ta vari wu a̱ a̱a̱ka̱ri a̱ a̱lungu a̱ a̱tsuma̱lima̱. ");
INSERT INTO tswNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Za na uwwa nɗu, a̱mu ɗa waa uwwusa. Za na ꞌyuwan ɗu, a̱mu ɗa u ꞌyuwain. Za na ꞌyuwan numu waru u ꞌyuwan ta̱ za na lyungu numu.” Ana a uwwai ne, a̱vu o uta̱. ");
INSERT INTO tswNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","A̱vu ama kupocindere ne ejere o ndolo a̱ ka̱mba̱ na̱ ma̱za̱nga̱, reve a damma, “Zagbain, hali no otoni a̱ lima̱ a tsu yuwan ta̱ ili i na tsu damma nle a yuwan a ala a̱ wu.” ");
INSERT INTO tswNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Reve u usu, “Me ene ta̱ Male† ma̱ riya̱i ana imaɗatsu diga zuva. ");
INSERT INTO tswNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","N ca ɗu ta̱ ucira e ekere e iyo na agashi na a aci a nꞌyuwatan n ɗu. Ili yi lo i na ya̱a̱ juꞌwa̱n ɗu shi ko keꞌen. ");
INSERT INTO tswNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","She i yuwan ma̱za̱nga̱ adama o ndolo wan, agba i yuwan ma̱za̱nga̱ ana a ɗanai ala a̱ ɗu zuva.” ");
INSERT INTO tswNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","A yashi i ndolo, Yesu da̱na̱ ta̱ tapu na̱ ma̱za̱nga̱ o ucira u Ruhu va Akiza, a̱vu u damma, “Dada, n godyoo wu ta̱, Zagbain va zuva ni iɗa, adama a na vu sokoi adanshi o ndolo e ekere a̱ a̱za̱ o urevu nu ugbozu, a̱vu vu cuɗuwaa muwun n keꞌen. Amayun a ɗa, Dada, adama a na a̱yi nda a̱yi ɗa ifoɓi i saꞌani ya̱ wu. ");
INSERT INTO tswNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Ili suru Dada va̱ ɗa ca numu. Za lo revei ko zane ɗa Mawuꞌun shi, she Dada va̱ yi goon, ko za reve waru ko zane ɗa Dada u ri shi she Mawuꞌun goon, na aza a na Mawuꞌun u ɗangulai tsa̱ra̱ u cuɗuwa le.” ");
INSERT INTO tswNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","A̱vu u vadala uba̱ta̱ wo ojoro a̱ yi, a̱vu u damma le usokowu, “Aza a abaꞌun a ɗa esu a na e enei ili i na ye enei. ");
INSERT INTO tswNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","N ta dansaa ɗu ama̱sula̱ a̱ a̱bunda̱ na̱ ngono, a ciga ta̱ e ene ili i na ye enei, agba e ene shi. A uwwa waru ili i na yu uwwai, agba a uwwa shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","A̱vu za ro za na revei Wila̱† wa Musa lon, u ꞌyon mishin a̱ lyungusa̱ yi, a̱vu u damma, “Manlu, nye maa yuwan, a̱vu n tsura̱ wuma u na woo koto shi?” ");
INSERT INTO tswNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","A̱vu Yesu ece yi, “Nye i ɗa i ri uɗanu a̱ Wila̱? Cine vu tsu cuɗuwa le?” ");
INSERT INTO tswNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Reve vuma u usu, “Vu ciga Zagbain A̱sula̱ a̱ wu no ookolo a̱ wu suru, na̱ wuma wa̱ wu suru, nu ucira wa̱ wu suru, na asuvu a̱ wu suru. A̱vu vu ciga moron ma̱ nden ma̱ wu cine vu cigai aciya̱wu.” ");
INSERT INTO tswNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","A̱vu Yesu damma, “Amayun a ɗa vu dammai, yuwan ne vu ta̱ tsura̱ wuma.” ");
INSERT INTO tswNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","A̱yi gba vumaꞌa u ciga ta̱ u ka̱mba̱to aciya̱yi za na ri nu unusu shi, a̱vu we ece yi, “Zane ɗa moron ma̱ nden ma̱ va̱?” ");
INSERT INTO tswNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","A̱vu Yesu usu yi, “Vuma ro uta̱ ta̱ gawan va̱ Urishelima a̱ ꞌya̱wa̱ za̱la̱ va̱ Jeriko, a̱vu u gaꞌan na̱ a̱za̱ a̱ nga̱la̱la̱i. A̱vu o foɗo yi itana, a̱vu a̱ ruꞌwa̱ yi lon, keꞌen ɗa a lyawaa niyi wuma. ");
INSERT INTO tswNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Wo oꞌwo ta̱ ganu ro ta a mmalu o ureꞌe, ana we enei vumaꞌa, a̱vu u kanzuꞌwa alanga. ");
INSERT INTO tswNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ne ɗa waru vuma va̱ Levi ro kuruyi ureꞌe, ana we enei vumaꞌa, reve u kanzuꞌwa alanga. ");
INSERT INTO tswNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Reve vuma va Samariya ro a̱yi a̱tsuma̱ a mmalu, reve u rawa uba̱ta̱ u na vumaꞌa u ri. Ana we ene niyi, a̱vu we ene yi iliyali. ");
INSERT INTO tswNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","A̱vu u ꞌya̱wa̱ uba̱ta̱ u na u ri, reve u tsuwa̱n yi maniꞌin na̱ a̱guma̱, ɗaɗa wu nla̱i antsuꞌu na akashomuna. A̱vu u zuwa yi o mololi ma̱ yi. A̱vu u ꞌya̱wa̱to yi o uꞌwa wo omocin, uba̱ta̱ u na wi indana niyi. ");
INSERT INTO tswNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ana usana u tawai, a̱vu u tara ikebe yu ulivu i re, a̱vu u ca za vu uka̱lyuwusa̱ wu uꞌwa wo omociꞌin. A̱vu u damma, ‘Vu ka̱lyuwusa̱ yi, ni ili i ro i buwa, na̱ n ka̱mba̱ n ta tsupa wu.’ ");
INSERT INTO tswNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“O ookolo a̱ wu, a̱tsuma̱ a ama a taꞌatsu a nda, zane ɗa moron ma̱ nden ma za na a̱za̱ a̱ nga̱la̱la̱i a̱ ga̱ga̱la̱i?” ");
INSERT INTO tswNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","A̱vu vumaꞌa u usu, “Za na roco niyi isaꞌani.” A̱vu Yesu damma yi, “ꞌYa̱wa̱ vu yuwan ne fo.” ");
INSERT INTO tswNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu no ojoro a̱ yi a̱tsuma̱ a mmalu, a̱vu a rawa uba̱ta̱ u na ka ro za na a̱ tsu ɗe Marta, za na raba nle, a̱vu waru u ca le ucuꞌwatan. ");
INSERT INTO tswNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","U ta̱ na̱ zawaꞌa na a̱ tsu ɗe Meri,† za na da̱nuyi a̱ ma̱ka̱ka̱n ma Zagbain a uwwusa adanshi a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta gba ifoɓi i na waa yuwusan i tara ta̱ ugbozu wa̱ yi. Reve u ta̱wa̱, a̱vu we ece yi, “Zagbain, u ɓa̱li wu ana zawaꞌa va̱ lyawa numu o ulinga a̱ ndeꞌen shi? Damma yi u ta̱wa̱ u kamba mu.” ");
INSERT INTO tswNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","A̱vu a̱yi Zagbain u usu yi, “Marta, Marta, vu dama ta̱ na̱ a̱tsuma̱lima̱ e ili ya̱ a̱bunda̱, ");
INSERT INTO tswNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","agba ili i ta̱ i ɗa a laꞌa cigai. Meri gba u ɗangwa ta̱ ili i na i laꞌai ulobonu, waru aa usa yi i ɗa e ekere a̱ yi shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Urana u ro, Yesu yuwan ta̱ avasa uba̱ta̱ u ro. Ana u kotoi, a̱vu za ta̱ a̱tsuma̱ o ojoro a̱ yi, u damma, “Zagbain, roco tsu cine tsaa yuwan avasa, cine Yahaya rocoyi ojoro a̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","A̱vu u damma le, “A mantsa ma na yaa yuwan avasa, i damma, ‘Dada, aala a̱ wu a̱ da̱na̱ na̱ tsugbain, tsugono tsa̱ wu tsa̱ ta̱wa̱. ");
INSERT INTO tswNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Urana suru vu ca tsu ilyalya i malya. ");
INSERT INTO tswNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Vu yuwaan tsu gafura vu unusu u tsu, adama a na a̱tsu tsaa yuwusaan aza a na a yuwusaan tsu unusu gafura. Vu lyawa tsu tsu uwa a̱tsuma̱ a̱ ma̱lyungwa̱ wan.’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","A̱vu u damma le, “A damma za ro ɗu ta̱ ni iꞌutsa̱, a̱vu u ꞌya̱wa̱ ya̱ꞌa̱ yi na ayin uta̱nu, a̱vu u damma, ‘N ciga ta̱ vu kopoo mu opopofu a taꞌatsu. ");
INSERT INTO tswNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","N tsura̱ ta̱ mocin za na uta̱i uba̱ta̱ a mmalu, u cuꞌwan ta̱ ya̱ꞌa̱ va̱ gogo, agba n ri ni ilyalya i na maa ca yi shi.’ ");
INSERT INTO tswNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“A̱vu iꞌutsa̱ꞌa̱ i usu yi pe a̱tsuma̱, ‘Vu damaton mu wan! A̱ ɓa̱ru ta̱ ɗe una̱ntsu, waru suru n tsu, tsu von ta̱ ɗe. Maa gura ꞌyon n ca wu ili i ro shi.’ ");
INSERT INTO tswNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","N ta dansaa ɗu, ko na̱ wa̱a̱ ꞌyon u ca yi ili i ro, adama a na a̱yi iꞌutsa̱ ya̱ yi i ɗa shi, adama a na u ꞌyuwain a̱ ka̱ra̱, u ta̱ ꞌyon u ca yi ko nye i ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ne ɗa maa dansaa ɗu, i patishi, a ta ca ɗu. I zamishi, i ta̱ tsura̱. Yi gugulusa, a̱ ta̱ kpa̱tuꞌwa̱a̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Za vi ipati suru, a tsu ca yi ta̱. Za vi izami suru, u tsu tsura̱ ta̱. Za wugulusa waru, a̱ ta̱ kpa̱tuꞌwa̱a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“A̱tsuma̱ a̱ ɗu, a̱ɗu na i ri nan dada, zane ɗa mawun ma̱ yi maa pati yi magula, a̱vu u ca yi yo? ");
INSERT INTO tswNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ko u pati ookowo, a̱vu u ca yi ugashi? ");
INSERT INTO tswNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","A̱ɗu na i ri ni iwuya, i reve ta̱ cine yaa ca muwun n ɗu ili i saꞌani. Dada ɗu, za na ri zuva, u ta laꞌa ca aza a na a pati niyi Ruhu va Akiza.” ");
INSERT INTO tswNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Urana u ro, Yesu lo ta̱ otoni a̱ lima̱† a na a gura yuwain adanshi shi. Ana otoni a̱ lima̱ o ndolo o uta̱i, reve vumaꞌa u fara a yuwusan adanshi. Amaꞌa e reme ta̱ asalama. ");
INSERT INTO tswNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","A̱vu ozo o ro e le a damma, “Nu ucira wa Baꞌalzabu† mogono mo otoni a̱ lima̱ ma ɗa u lo nle.” ");
INSERT INTO tswNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ozo o ro waru tsa̱ra̱ a̱ lyungwa̱ yi, reve a pati yi u roco le iroci i ro ɗe zuva. ");
INSERT INTO tswNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","A̱yi gba ana u revei majiyan me le, a̱vu u damma le, “Tsugono tsa na tse neꞌeshein ure, u ta̱ riya̱. Ne ɗa waru nu uꞌwa u neꞌeshen ure, u ta̱ beteꞌwe. ");
INSERT INTO tswNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","I damma n lo ta̱ otoni a̱ lima̱ nu ucira wa Baꞌalzabu, to, na̱ Male me neꞌeshen aciya̱yi ure, cine tsugono tsa̱ yi tsee isawan? ");
INSERT INTO tswNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Na̱ n lo otoni a̱ lima̱ nu ucira wa Baꞌalzabu, ojoro a̱ ɗu nu ucira wa yan u ɗa oo utusa̱? Adama o ndolo, ele ɗa oo oꞌwo a̱za̱ o ugeꞌetosu u ɗu. ");
INSERT INTO tswNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","A̱mu gba nnu ucira wa̱ A̱sula̱ a ɗa n loyi otoni a̱ lima̱, to, tsugono tsa̱ A̱sula̱ tsa rawa ta̱ zuzu na̱ a̱ɗu. ");
INSERT INTO tswNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Na̱ vuma vu ucira tsa Male foɓo a̱ ka̱lyuwusa̱ uꞌwa wa̱ yi, gbaga ɗa itana yu uꞌwa wa̱ yi i ri. ");
INSERT INTO tswNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Na̱ vuma na gba laꞌa niyi ucira u ta̱wa̱ uba̱ta̱ wa̱ yi, u ta usa itana yu uvon i na waa zuwusaa uciraꞌa, a̱vu u neꞌeshen ama utsuru wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Za na ri oɓolo na̱ a̱mu shi, u ꞌyuwan mu ta̱. Za na oo ɓolotosu na̱ a̱mu shi, ukacaru u ɗa waa kacarasa. ");
INSERT INTO tswNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“No otoni a̱ lima̱ o uta̱ a̱tsuma̱ a vuma, u tsu kuru ta̱ uba̱ta̱ u na u ri na̱ mini shi, e izami yu uba̱ta̱ u na wee ivuwan. Nu u lamba, a̱vu u damma, ‘N ta̱ ka̱mba̱ o uꞌwa u na mu uta̱i.’ ");
INSERT INTO tswNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nu u rawa, a̱vu u cina yi wizu, ufoɓu ulobonu. ");
INSERT INTO tswNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","A̱vu u ꞌya̱wa̱ u tara otoni e cindere o ro aza a na a laꞌa niyi ucira wi iwuya, a̱vu a uwa a̱ da̱nu uba̱ta̱ꞌa̱. Ukosu wu nden n vuma ndolo u ta laꞌa cine u da̱na̱i.” ");
INSERT INTO tswNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu a̱tsuma̱ adanshi o ndolo, a̱vu ka ro a̱tsuma̱ oɓoloꞌo u ꞌya̱sa̱n uɗyo, a̱vu u damma, “Abaꞌun a̱ tyo a za na matsan nuwu na̱ za na apato nuwu maani.” ");
INSERT INTO tswNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","A̱vu u ka̱mbuwa̱ yi, “Ne ɗa, agba abaꞌun a laꞌa ta̱ a̱ tyo a aza a na a uwwai adanshi a̱ A̱sula̱, a̱vu a yuwan ulinga ni ili i na a uwwai.” ");
INSERT INTO tswNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Oɓoloꞌo o ɓolotosu uba̱ta̱ wa̱ yi, a̱vu Yesu damma, “Mantsa mo gogo mantsa me iwuya ma ɗa. A ciga ta̱ e ene iroci ya asalama, agba oo roco le shi, she za va Yunana.† ");
INSERT INTO tswNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Cine Yunana da̱na̱i iroci e ekere a ama a Niniva,† ne ɗa Mawun ma Vuma moo oꞌwo a mantsa ma nda. ");
INSERT INTO tswNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","O urana wu ugeꞌetosu, Egbere va Sheba ta̱ ꞌya̱wa̱ na adanshi a aci a ama a mantsa ma nda. Adama a na a̱yi wu uta̱i alanga lon, tsa̱ra̱ wu uwwa urevu nu ugbozu wa Sulemanu,† gogo gba za na laꞌai Sulemanu ta̱ pa agba i ꞌyuwan ta̱ a̱ usu. ");
INSERT INTO tswNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","O urana wu ugeꞌetosu, ama a Niniva a̱ ta̱ ꞌya̱wa̱ na adanshi a aci a ama a mantsa ma nda. Adama a na ele a vadalai na alajiya a Yunana. Gogo gba za na laꞌai Yunana ta̱ pa agba i ꞌyuwan ta̱ a̱ usu.” ");
INSERT INTO tswNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Babu za na aa daɓa fitila, a̱vu u zuwa yi a̱ mbungulu, ko u kpa̱to yi na aasaꞌatsu. U tsu zuwa yi ta̱ e eelele, tsa̱ra̱ aza a na a uwusa e ene ekaꞌan. ");
INSERT INTO tswNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lyusu a̱yi ɗa fitila lipu va̱ wu. Ne esu a̱ wu a̱ ri ulobonu, lipu va̱ wu suru u ta̱ ne ekan. Na̱ a̱ ri ulobonu shi, lipu va̱ wu ta̱ ni irumbu suru. ");
INSERT INTO tswNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","I ka̱lyuwa̱ ulobonu ko ekan a na i ri na̱ a̱yi ko irumbu i ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Na̱ lipu va̱ wu ri ne ekan suru, babu uba̱ta̱ u na u ri ni irumbu, u to oꞌwo ekan suru ununa fitila tsu ca wu ekan.” ");
INSERT INTO tswNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu o koto adanshi, a̱vu Mafarishi ma banu yi u ꞌya̱wa̱ u lyuwa ilyalya na̱ a̱yi. A̱vu u uwa u reme alya na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","A̱vu Mafarishi ma uwa asalama, ana we enei Yesu cigai u lyuwa ilyalya babu u saꞌa ekere o ure u na wu ntsayi shi. ");
INSERT INTO tswNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","A̱vu Zagbain damma yi, “A̱ɗu Afarishi i tsu za̱za̱ꞌwa̱ ta̱ ucina̱ u munda na̱ ntaɗa, agba a̱tsuma̱ a̱ ɗu i ta̱ tapu ni iwuya nu utsa̱n. ");
INSERT INTO tswNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","A̱ɗu olo! Za na yuwain ucina̱, a̱yi ɗaɗa u yuwain peꞌe shi? ");
INSERT INTO tswNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","I ca alambi ili i na i ri a munda na̱ ntaɗa n ɗu, ili suru waru i to oꞌwo cece. ");
INSERT INTO tswNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Woo yoꞌono ɗu shi, Afarishi! I tsu ca ta̱ A̱sula̱ za ta̱ a̱tsuma̱ a kupa, a̱tsuma̱ e ili i na i ri na̱ a̱yi ko cine u ri keꞌen akpakusu, na akapi e isuꞌwan i na i buwai. Agba i ꞌyuwan ta̱ a yuwan ugeꞌetosu u saꞌani, a̱vu waru i ꞌyuwan a ciga A̱sula̱. Ele ɗa wu ntsayi i yuwan, agba i vari a̱za̱ o ufaru wan. ");
INSERT INTO tswNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Woo yoꞌono ɗu shi, Afarishi! A̱ɗu ɗa nda i cigai nda̱na̱ta̱ n saꞌani a̱ a̱ꞌisa̱ ni ica̱su i tsugbain e eden. ");
INSERT INTO tswNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Woo yoꞌono ɗu shi, i rotso ta̱ ason a̱ ri gashi a zuwayi iroci shi, aza a na ama a̱ ri a mmalu ɗe babu urevu.” ");
INSERT INTO tswNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","A̱vu za na revei Wila̱ꞌa̱ lon u usu, “Manlu ana vu dammai tsundolo, vi isula tsu ta̱ fo.” ");
INSERT INTO tswNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","A̱vu Yesu damma yi, “A̱ɗu fo woo yoꞌono ɗu shi, a̱ɗu aza a na e revei Wila̱ lon! I tsu tanu ta̱ ama itana, itana i na i ri ume, a̱ɗu ko na̱ makatsu i tsu zuwa tsa̱ra̱ i kamba le shi! ");
INSERT INTO tswNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Woo yoꞌono ɗu shi! I lapula ta̱ ason a ama̱sula̱ a na nkaya n ɗu mu unai. ");
INSERT INTO tswNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Agba u roco ta̱ i usu ta̱ ili i na nkaya n ɗu n yuwain. O una ta̱ ama̱sula̱ waru i usu ta̱ ni ili i na a yuwain ana i lapulai asoꞌon. ");
INSERT INTO tswNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","A̱yi ɗa i zuwai A̱sula̱ o urevu a dammai, ‘N ta̱ lyunguwa̱ le ama̱sula̱ na ajiya, o una ozo o ro, a ca ozo o ro a̱tsuma̱lima̱.’ ");
INSERT INTO tswNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ama o gogo e te reme le adama a mpasa ma ama̱sula̱ꞌa̱ suru a na o ocoi diga ufaru wu uvaɗi, ");
INSERT INTO tswNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","diga a mpasa ma Habila† a̱ tyo a mpasa ma Zakariya, za na o unai e memere ma masaꞌa mo ukula̱tosu nu Upasu wa Akiza.† Amayun, e te reme ama o gogo adama e le suru. ");
INSERT INTO tswNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Woo yoꞌono aza a na e revei Wila̱ lon shi, adama a na i sokoi ma̱kpa̱tuꞌutsu ma na a̱a̱ kpa̱tuꞌwa̱ una̱ntsu wu urevu, agba a̱ɗu na aciya̱ɗu yaa uwa pe shi, a̱vu i putsaa aza a na a cigai a uwa ure.” ");
INSERT INTO tswNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ana Yesu lyawai uba̱ta̱ꞌa̱, a̱vu munlu n Wila̱ na Afarishi a uwa adanshi a̱ yi babu uyoꞌo, o ronuso yi adanshi, tsa̱ra̱ u yuwan adanshi a̱ a̱bunda̱, ");
INSERT INTO tswNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","tsa̱ra̱ e reme yi e ili i na waa dansa. ");
INSERT INTO tswNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ele lo ana oɓolo a ama a̱ a̱bunda̱ o ɓolotoi hali a uwa ndasalai va̱ni le. A̱vu u teme a yuwusan adanshi no ojoro a̱ yi ana, “I yuwan ugbozu na̱ wolilo wa Afarishi, a̱yi ɗa ikpaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Babu ili i na i ri ukpa̱towu na a̱ kpa̱tuꞌwa̱ shi, ko usokowu a na woo uta̱ a alanga e eteshe shi. ");
INSERT INTO tswNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ili i na i dammai e irumbu suru, a ta uwwa yi a alanga eteshe. Ili i na waru i yuwain yemenu ya̱ yi usokowu, a ta yuwan adanshi a̱ yi a̱ a̱ra̱ra̱. ");
INSERT INTO tswNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“A̱ɗu nꞌutsa̱ n va̱, n ta dansaa ɗu, she yu uwwa wovon wu za na oo una vuma wan, no o una yi aa gura yuwan ili i na̱ a̱yi waru shi. ");
INSERT INTO tswNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","N to roco ɗu za na yaa uwwa wovon. Yu uwwa wovon wa̱ A̱sula̱ a̱yi ɗa na̱ wu una, u ta̱ nu ucira u vari a̱tsuma̱ a akina. Amayun a ɗa maa dansaa ɗu, a̱yi ɗa yaa uwwa wovon. ");
INSERT INTO tswNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ashe a tsu wina mutali n ton kobo re shi? Ko za ta̱ le gba A̱sula̱ e icina na̱ a̱yi shi. ");
INSERT INTO tswNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ko a̱nji a aaci a̱ wu a̱ tu uketsu. She yu uwwa wovon wan, i laꞌa ta̱ mutali ma̱ a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Waru n ta dansaa ɗu, za na usu numu a̱ ma̱ka̱ka̱n ma ama, a̱mu Mawun ma Vuma fo n ta̱ usu yi a̱ ma̱ka̱ka̱n ma nlingata ma̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Za na wasan numu a̱ ma̱ka̱ka̱n ma ama, adama o urevu u va̱, a ta wasan yi fo a̱ ma̱ka̱ka̱n ma nlingata ma̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Za na yuwain adanshi a vama e ekere a Mawun ma Vuma a ta yuwaan yi gafura, amma za na yuwayin Ruhu va Akiza adanshi a vama, aa yuwaan yi gafura shi. ");
INSERT INTO tswNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Na̱ a̱ ꞌya̱wa̱to ɗu a̱ a̱ꞌisa̱, nu uba̱ta̱ wa̱ a̱za̱ o ugeꞌetosu, ko uba̱ta̱ wa azagbain, she u ɓa̱la̱ ɗu ko cine ya̱a̱ usu, ko ili i na yaa damma wan. ");
INSERT INTO tswNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Adama a na Ruhu va Akiza to roco ɗu ili i na yi ntsayi i damma a mantsaꞌa.” ");
INSERT INTO tswNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","A̱vu vuma ro a̱tsuma̱ o oɓoloꞌo u damma Yesu, “Manlu, damma mawun ma̱ a̱na̱wu ma̱ va̱ me neꞌeshen agadu oɓolo na̱ a̱mu.” ");
INSERT INTO tswNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","A̱vu Yesu damma yi, “Zane ɗa zuwa numu za vu ugeꞌetosu u ɗu, ko n neꞌeshen ɗu agadu a̱ ɗu?” ");
INSERT INTO tswNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","A̱vu u damma le, “I ka̱lyuwa̱ ulobonu, i suma ili i na i rotsoi utsa̱n. A̱bunda̱ e itana a̱yi ɗa wuma shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","A̱vu u yuwaan le iroci i nda, “A yuwan ta̱ za vu utsuru u ro, za na uɗuma̱ wa̱ yi u matsain ulobonu. ");
INSERT INTO tswNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","A̱vu u damma o ookolo a̱ yi, ‘Cine maa yuwan? N ri nu uba̱ta̱ u na maa zuwa itana yu uɗuma̱ i va̱ shi.’ ");
INSERT INTO tswNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","A̱vu u damma, ‘Apa ili i na maa yuwan. N to ɓoso mpon n va̱, a̱vu n suwa aza a gbagbain, pe ɗa maa zuwa ishina i va̱ ni ili i na n ri ne ele suru. ");
INSERT INTO tswNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","A̱vu n damma aciya̱va̱, “Vu ta̱ ni ili i saꞌani ya̱ a̱bunda̱ uzuwu, a na aa yuwan wu aꞌwan a̱ a̱bunda̱. Ivuwan, vu lyuwa vu sowo, a uwwusa uyoꞌo.” ’ ");
INSERT INTO tswNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“A̱vu A̱sula̱ a damma yi, ‘A̱vu ulo u nda! Na ayin a nda a ɗa a cigai wuma wa̱ wu. Itana i na vu foɓoi gba, aza a zane a ɗa a̱ ri o oꞌwo?’ ");
INSERT INTO tswNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Ne ɗa za na zuwayi aciya̱yi utsuru u ri, agba u ri nu uzuwa uba̱ta̱ wa̱ A̱sula̱ shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","A̱vu u damma ojoro a̱ yi, “Adama o ndolo a ɗa maa dansaa ɗu, she u ɓa̱la̱ ɗu adama a wuma u ɗu wan, ili i na yaa lyuwa, ko ili i na yoo oto wan. ");
INSERT INTO tswNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Wuma u laꞌa ta̱ ilyalya, lipu waru u laꞌa ta̱ itana. ");
INSERT INTO tswNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","I ka̱lyuwa̱ akakan: a̱ tsu cuꞌwa̱n shi, agba a tsu gasa shi, a̱ ri na̱ mpon shi. A̱sula̱ a ɗa a lyuwatosu le. Tsugbain tsa̱ ɗu tsa laꞌa ta̱ tsa̱ nnunu! ");
INSERT INTO tswNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","A̱tsuma̱ a̱ ɗu zane ɗa aa gura da̱shi aciya̱yi mantsa a wuma wa̱ yi adama a̱ a̱tsumola̱ngu? ");
INSERT INTO tswNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ana yaa gura yuwan ili i keꞌen i nda shi, cine i ri a̱tsumola̱ngu adama a akapi? ");
INSERT INTO tswNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ka̱lyuwa̱i ununa yipa̱lu i tsu uta̱. A tsu yuwan ulinga shi agba aa ɗava shi ko keꞌen. Agba n ta dansaa ɗu, ko Sulemanu† a̱tsuma̱ a tsugbain tsa̱ yi wo oto itana i saꞌani u laꞌa le ulobonu shi. ");
INSERT INTO tswNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Na̱ ne ɗa A̱sula̱ aa lapulusa anlya o ogozo, anaꞌan u ta̱ lo, nfaꞌan gba a̱ kula̱to yi. A̱ɗu gba i reve A̱sula̱ a ta yuwaan ɗu itana. Suru na̱ ne nye i zuwai i ri nu ucawu wo okolo keꞌen? ");
INSERT INTO tswNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“She i uwa majiyan me ili i na yaa lyuwa ko yoo sowo wan, she i dama adama a̱ yi wan. ");
INSERT INTO tswNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Aza a na e revei A̱sula̱ shi ili yu uvaɗi i ɗa a zama suru, Dada ɗu gba za na ri zuva u reve ta̱ a na i cigai ili i ndolo. ");
INSERT INTO tswNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Amma i zami tsugono tsa̱ yi, a̱ ta̱ da̱shi ɗu ili i ndolo suru. ");
INSERT INTO tswNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“A̱ɗu moɓolo me keꞌen, she yu uwwa wovon wan, adama a na Dada ɗu za̱nga̱na̱ ta̱ a na waa lyawaa ɗu tsugono tsa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","I wina ili i na i ri na̱ a̱yi, a̱vu i ca alambi, i zuwaa aciya̱ɗu osonu a na a̱a̱ la̱nga̱ shi, i zuwa ɗe uzuwa zuva u na woo koto shi, uba̱ta̱ u na evu aa rawa zuzu ko aran a̱a̱ lungusa̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Uba̱ta̱ u na uzuwa wa̱ wu u ri lo ɗa okolo a̱ wu a̱ ri.” ");
INSERT INTO tswNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","A̱vu Yesu lyuwa elime na adanshi, “I da̱na̱ ufoɓu, ifitila i ɗu udaɓu a madala. ");
INSERT INTO tswNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","I da̱na̱ ufoɓu cine i revei ama a̱ tsu da̱na̱ e ipiri yi zagbain le a̱ ka̱mba̱ diga o uꞌwa wa̱ a̱buki o lolo. A̱yi a yuwan a̱zoꞌwa, a̱vu ele a̱ kpa̱tuꞌwa̱a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","U to yoꞌono agbashi a na yashi i na zagbain le ta̱wa̱i, a̱vu u cina le e ipiri. Amayun a ɗa maa dansaa ɗu, u to foɓo u reme ulinga, a̱vu u damma a̱ da̱nu alya e ilyalya, a̱vu u yuwaan le a̱ga̱nda̱. ");
INSERT INTO tswNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nu u ta̱wa̱ na ayin uɓatsu ko na̱ wasasa, a̱vu u cina agbashi o ndolo ufoɓu, o to oꞌwo aza a abaꞌun. ");
INSERT INTO tswNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Amma i reve nda: Na̱ za vu uꞌwa reve yashi i na vivu a̱a̱ ta̱wa̱, waa lyawa a uwa yi o uꞌwa shi. ");
INSERT INTO tswNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","A̱ɗu fo i da̱na̱ ni ifoɓi, yashi i na i zuwai Mawun ma Vuma ma̱a̱ ta̱wa̱ shi ɗaɗa wa̱a̱ ta̱wa̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","A̱vu Bituru ece, “A̱tsu ɗa vaa yuwusaan iroci i ndaꞌa, ko ama suru?” ");
INSERT INTO tswNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","A̱vu Zagbain usu, “Zane ɗa aagbashi a̱ a̱ɓula̱ nu ugbozu? A̱yi ɗa za na zagbain va̱ yi zuwa niyi u ka̱lyuwusa̱ uꞌwa wa̱ yi, a̱vu u ca akapi a agbashi akunda e ilyalya mantsa ma na wu ntsayi. ");
INSERT INTO tswNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","U to yoꞌono aagbashi a na na̱ zagbain va̱ yi ta̱wa̱i, a̱vu u cina yi a yuwusan ne. ");
INSERT INTO tswNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Amayun a ɗa maa dansaa ɗu, u ta zuwa u ka̱lyuwusa̱ ili i na u ri na̱ yi suru. ");
INSERT INTO tswNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Agba na aagbashi o ndolo a damma o ookolo a̱ yi, ‘Zagbain va̱ jima ta̱ ma̱ta̱wa̱a̱.’ A̱vu u reme malapa ma agbashi suru, ali na̱ a̱ma̱ci. A̱vu u uwa alya no oso hali wo oꞌwo usowu. ");
INSERT INTO tswNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Zagbain va aagbashi o ndolo, u ta̱ ta̱wa̱ urana u na u zuwai shi, mantsa waru u reve shi. U ta ɓuɓatsa yi lipu, a̱vu u ca yi akunda a̱ yi na aza a na a̱ ri na̱ a̱ɓula̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Aagbashi a na e revei ili i na zagbain va̱ yi cigai, agba u foɓo tsa̱ra̱ u yuwan shi, a ta fufaba yi lon. ");
INSERT INTO tswNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Agba za na revei shi, a̱vu u yuwan ili i na i rawai wulapu, keꞌen ɗa aa lulapa yi. Za na a cayi a̱bunda̱ suru, na̱ a̱bunda̱ a ɗa aa zami e ekere a̱ yi. Za na a cayi na̱ a̱bunda̱ lon, a̱bunda̱ lon a ɗa aa zami e ekere a̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","A̱vu Yesu lyuwa elime na adanshi, “N ta̱wa̱ ta̱ tsa̱ra̱ n ta̱wa̱a̱ na akina a̱tsuma̱ o uvaɗi, icigi i va̱ i ɗa a damma u ta̱ wivulu! ");
INSERT INTO tswNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Agba n ta̱ nu urumbusu u na a̱a̱ rumbu mu, n ta̱ na̱ a̱tsumola̱ngu hali a̱ tyo o ukosu. ");
INSERT INTO tswNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","I ta yuwusan majiyan n ta̱wa̱a̱ ta̱ na asuvu nden o uvaɗi? Oꞌo ɗa maa dansaa ɗu, amma wukasu. ");
INSERT INTO tswNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Diga gogo uꞌwa u na u ri na ama o ton a ta ɓatsa: ama taꞌatsu a ta ꞌyuwan ama e re, waru ama e re a ta ꞌyuwan ama a taꞌatsu. ");
INSERT INTO tswNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ne ɗa aa kakasa. Dada ta ꞌyuwan mawun ma̱ yi, mawun waru u ta ꞌyuwan dada va̱ yi. Mma ta ꞌyuwan mawun mo usheli ma̱ yi, mawun mo usheli ma ta ꞌyuwan mma va̱ yi. A̱na̱wa̱ a ta ꞌyuwan jene va̱ yi, jene waru u ta ꞌyuwan a̱na̱wa̱le.” ");
INSERT INTO tswNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","A̱vu u damma oɓoloꞌo: “Na̱ ye ene eleshe o ɓolotosu o uta̱su asana, babu usa̱n i tsu damma ta̱, ‘A ta yuwan mini.’ A̱vu gba a yuwan. ");
INSERT INTO tswNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na̱ ye ene upepu wu uyagi a lapusa, i tsu damma ta̱, ‘A ta yuwan usuɗuwu lon.’ A̱vu gba a yuwan. ");
INSERT INTO tswNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","A̱za̱ e ikpaꞌa, i reve ta̱ iroci yi iɗa na̱ zuva. Nye i zuwai i revei iroci i mantsa ma nda shi?” ");
INSERT INTO tswNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nye i zuwai yaa gura revee aciya̱ɗu ili i saꞌani shi? ");
INSERT INTO tswNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Iroci, na̱ za ro tara wu a̱ ꞌya̱wa̱ uba̱ta̱ wu za vu ugeꞌetosu, yuwan a̱tyo a na vaa yuwan tsa̱ra̱ yi kakasalai kafu i rawa uba̱ta̱ wu ugeꞌetosu. Na̱ vu yuwan ne shi, a̱ ta̱ keɓe wu a̱ tyo uba̱ta̱ wu za vu ugeꞌetosu, za na aa ca muwun maɗanga a̱vu, a̱vu ele a zuwa wu o uꞌwa wa ali. ");
INSERT INTO tswNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","N ta dansaa wu, voo uta̱ pe shi, she na̱ vu tsupa suru, ko kebuꞌuri aa buwa shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","A mantsa mo ndolo ama o ro a̱ shi ta̱ lo, a̱vu a damma Yesu alabari a̱ a̱za̱ a̱ Ga̱lili a na Bilatu zuwa o unai a̱ A̱a̱ꞌisamapaɗa, hali mpasa n le m ɓoluloi na̱ mpasa n kucci. ");
INSERT INTO tswNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","A̱vu u damma le, “I ta dansa a̱za̱ a̱ Ga̱lili o ndolo a laꞌa ta̱ akapi a ama a̱ Ga̱lili unusu, ɗaɗa a uwai a̱tsuma̱lima̱ ne tsunda? ");
INSERT INTO tswNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","N ta dansaa ɗu, ne ɗa shi! Waru ni i vadala o unusu u ɗu shi, ne ɗa fo yoo koto. ");
INSERT INTO tswNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Waru ama kupa na̱ kunla̱ na aatsura a̱ riya̱yi a Siluwamu, reve wu una le, i ta zuwusa a laꞌa ta̱ akapi a ama a na a̱ ri nden Urishelima unusu? ");
INSERT INTO tswNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","N ta dansaa ɗu ne ɗa shi. Ni i vadala† o unusu u ɗu shi, ne ɗa fo yoo koto.” ");
INSERT INTO tswNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Reve u yuwaan le iroci i nda: “Vuma ro cuꞌwa̱n ta̱ ubiri o ubara wa̱ yi. Reve u ta̱wa̱ a zama muwun mu ubiriꞌi agba u tsura̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","A̱vu u damma za vu ulapulusa wu ubaraꞌa, ‘Lala aꞌwan a taꞌatsu a ɗa nda maa zama muwun o ubiri u nda, agba n tsura̱ ili shi. Koɗo yi, adama a̱ nye wee geshe ure?’ ");
INSERT INTO tswNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Reve u usu, ‘Zagbain, da̱shi lyawa yi a aaꞌwan a nda. N ta̱ ka̱ka̱pa̱ yi a̱ ka̱nda̱ruwa̱, reve n tsun yi umili. ");
INSERT INTO tswNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nu u matsan nkoli, u lobono ta̱. Nu u matsan gba shi, a̱vu vu koɗo yi.’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Urana u ro, a̱yi a̱tsuma̱ o uritosu a̱ a̱a̱ꞌisa̱ o ro, o urana wa Ashibi, ");
INSERT INTO tswNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","reve we ene ka ro na otoni a̱ lima̱ o sowoi lipu aꞌwan kupa na̱ kunla̱. U da̱na̱ ta̱ uka̱ɗa̱towu, u tsu gura buba̱ruwa̱ ulobonu shi. ");
INSERT INTO tswNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ana Yesu ene niyi, a̱vu u ɗe yi u damma yi, “Ka, a kasa wu ta̱ nu ubanakun wa̱ wu.” ");
INSERT INTO tswNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Reve u juꞌwa̱n yi, ɗaɗa wu buba̱ruwushi, a̱vu u yuwaan A̱sula̱ ica. ");
INSERT INTO tswNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","A̱vu zagbain va̱ a̱a̱ꞌisa̱ꞌa̱ wu uwwa upan, adama a na Yesu yuwain opocino o urana wa Ashibi. Reve u damma ama, “Tsu ta̱ na̱ rana ta̱li na aa yuwan ulinga. Ta̱wa̱i a rana ndolo adama a yuwaan ɗu opocino, amma o urana wa Ashibi shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","A̱vu Zagbain usu yi, u damma, “A̱ɗu a̱za̱ e ikpaꞌa! I tsu ba̱ɗa̱ inan i ɗu ko nloli o uguza̱ta̱ o urana wa Ashibi, reve i tara le a̱ tyo o uɗolu shi? ");
INSERT INTO tswNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","U lobono a̱ ba̱ɗa̱ ka nda a̱tsuma̱ a tsugbashi o urana wa Ashibi shi? A̱yi umatsun wa Ibrahim u ɗa, za na Male ma̱ nla̱i aꞌwan kupa na̱ kunla̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ana u dammai ne, a̱vu aza a na a̱ shi a mawasan na̱ a̱yi a uwwa wono. Reve akapi a amaꞌa suru a̱ za̱nga̱na̱ adama e ili ya asalama i na u yuwain. ");
INSERT INTO tswNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","A̱vu Yesu damma, “Nye tsugono tsa̱ A̱sula̱ tso rotsoi, na̱ nye waru maa kurato yi? ");
INSERT INTO tswNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","U rotso ta̱ cuꞌun vu suꞌwan uri na vuma tarai, reve u ꞌya̱wa̱ u cuꞌwa̱n yi o uɗuma̱ wa̱ yi. Ana u kungwai, a̱vu wo oꞌwo uɗanga, reve nnunu n ɗava ɗe ikinda e eten a̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Reve waru u dammisa, “Na̱ nye maa kurato tsugono tsa̱ A̱sula̱? ");
INSERT INTO tswNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","U rotso ta̱ wolilo† u na ka tarai, reve u ja̱mba̱ra̱ yi e meretsu ma yira utaꞌatsu hali yiraꞌa i tsutsa.” ");
INSERT INTO tswNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Reve Yesu reme ure o utula̱i e ilyuci na̱ mulyuci o urocosu a mmalu a̱ tyo Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Reve vuma ro damma yi, “Zagbain, aza a na aa wawa waꞌa ɗa?” A̱vu u damma le, ");
INSERT INTO tswNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“I yuwan mpolo tsa̱ra̱ i uwa nu una̱ntsu wu uɓoru. N ta dansaa ɗu ama na̱ a̱bunda̱ a ta ciga a uwa, agba aa gura shi. ");
INSERT INTO tswNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Na̱ za vu uꞌwa uwa u ɓa̱ru una̱ntsu, i te isawan a alanga reve i yuwusan a̱zoꞌwa na̱ mesun, ‘Zagbain, kpa̱tuꞌwa̱a̱ tsu.’ “A̱vu u usu ɗu, ‘N reve ɗu shi, waru n reve uba̱ta̱ u na yu uta̱i shi.’ ");
INSERT INTO tswNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Reve i uwa adansa, ‘Tsu lyuwa ta̱ tsu sowo a̱ ma̱ka̱ka̱n ma̱ wu. Waru vu yuwan ta̱ uritosu e re tsu.’ ");
INSERT INTO tswNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Agba u ta damma, ‘N damma ɗu ta̱, n reve uba̱ta̱ u na yu uta̱i shi suru suru. Buwa numu ure, a̱ɗu a̱za̱ o ulinga wi iwuya.’ ");
INSERT INTO tswNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“A mantsa ma na ye enei Ibrahim na̱ Ishiyaku na̱ Yakubu na ama̱sula̱ suru, a̱tsuma̱ o tsugono tsa̱ A̱sula̱, a mantsa ma ɗaɗa yaa saala ni i lumi anga, a̱vu a̱ɗu gba a̱ gba̱ra̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ama a̱ ta̱ ta̱wa̱ diga asana na̱ a̱livu nu ugana nu uyagi. A̱vu a̱ da̱nu alya o tsugono tsa̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Waru ozo o ro a̱za̱ a̱ a̱ca̱pa̱ a̱ ta̱ ka̱mba̱ elime, ozo o ro waru a̱za̱ e elime a̱ ta̱ ka̱mba̱ a̱ca̱pa̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","A mantsa mo ndolo, reve Afarishi o ro a̱ ta̱wa̱, a̱vu a damma yi, “Vu lyawa uba̱ta̱ u nda, adama a na Hiridu Antiba te izami wu una wu.” ");
INSERT INTO tswNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Reve u damma le, “ꞌYa̱wa̱i i damma a̱a̱ga̱ja̱wa̱ o ndolo, ‘N ta̱ uta̱su otoni a̱ lima̱, n ta yuwusan opocino anaꞌan na̱ nfaꞌan. O urana u taꞌatsu n to koto ulinga u va̱. ");
INSERT INTO tswNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Suru na̱ ne, n te reme mmalu anaꞌan na̱ nfaꞌan na̱ santawa. Adama a na u ri n yuwan o una vumava̱sula̱ a alanga a̱ Urishelima shi.’ ");
INSERT INTO tswNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ayaa! Urishelima,† Urishelima, vu to unusa ama̱sula̱ na̱ vu vari aza a na a̱ lyunguwa̱ nuwu! Uyan u ɗa n cigai m ɓoloto muwun ma̱ wu uba̱ta̱ u ta̱ ununa moton ma̱ tsu ɓoloto muwun ma̱ yi a̱tsuma̱ e evelu a̱ yi, a̱ɗu gba a ꞌyuwusan! ");
INSERT INTO tswNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ndolo a lyawaa nɗu uꞌwa u ɗu ofoli. N ta dansaa ɗu ya̱a̱ da̱shi ene mu shi, she o urana u na waa yuwan i damma, ‘Za va abaꞌun ɗa za na ri a̱a̱ ta̱wa̱ a ala a̱ A̱sulazuva.’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","O urana wa Ashibi u ro, a̱vu Yesu uwa o uꞌwa wu zagbain ro va Afarishi adama u lyuwa ilyalya. Reve ama a varaa yi esu, ");
INSERT INTO tswNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","adama a na vuma ro shi ta̱ lo za na da̱na̱i na̱ mɓa̱la̱ ma atsutsa. ");
INSERT INTO tswNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Reve Yesu yuwan adanshi na̱ a̱za̱ o urevu u Wila̱ lon na Afarishi, u damma, “U lobono ta̱ a yuwan opocino o urana wa Ashibi, ko u lobono shi?” ");
INSERT INTO tswNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Reve a̱ rungwa̱ kpaku-kpaku. Ɗaɗa u tara niyi, reve u ka̱mbuwa̱ yi gbaga, a̱vu u zuwa yi u ka̱ra̱. ");
INSERT INTO tswNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","A̱vu u damma le, “Zane ɗa a̱tsuma̱ a̱ ɗu nu u ri na̱ mawun ko nan, a̱vu u riya̱ o ookoꞌo, waa papushi niyi o urana wa Ashibi shi?” ");
INSERT INTO tswNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Agba a gura usu yi waru shi. ");
INSERT INTO tswNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ana Yesu enei ununa aza a na a banuyi a cigai nda̱na̱ta̱ ma azagbain, a̱vu u yuwaan le iroci i nda, u damma, ");
INSERT INTO tswNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“A mantsa ma na nanza banu nuwu a̱buki o lolo, she vu da̱nu a̱ nda̱na̱ta̱ ma azagbain wan. Ta̱wa̱ wo oꞌwo u banu ta̱ za na laꞌa nuwu, ");
INSERT INTO tswNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","a̱vu za na banu nɗu ra u ta̱wa̱ u damma wu, ‘Vu ca vuma nda ure.’ Reve vu da̱nu na̱ wono a̱ nda̱na̱ta̱ ma̱ a̱ca̱pa̱. ");
INSERT INTO tswNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Amma a mantsa ma na a banu nuwu, vu ꞌya̱wa̱ vu da̱nu a̱ nda̱na̱ta̱ ma̱ a̱ca̱pa̱ suru suru. Adama na̱ za na banu nuwu u ta̱wa̱, u ta gura damma wu, ‘Iꞌutsa̱, katsa zuva.’ A̱vu vu tsura̱ ica e ekere a aza a na i ri alya oɓolo. ");
INSERT INTO tswNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Za na tarai aciya̱yi ili i ro suru, aa tara yi ili i ro shi. Za na gba tarai aciya̱yi ili shi, a ta tara yi ili i ro.” ");
INSERT INTO tswNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Reve waru u damma za na banu niyi, “Na̱ vaa banu ama alya ko vaa yuwan a̱buki, she vu banu nꞌutsa̱ ma̱ wu, ko a̱za̱ a̱ wu, ko nron ma̱ wu, ko aza a na a̱ ri zuzu na̱ a̱vu a̱za̱ o utsuru wan. Adama ele fo a tsupa wu ili i na vu yuwain wan. ");
INSERT INTO tswNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Amma na̱ vaa banu ama alya ko a̱buki, vu banu a̱za̱ e iliyali, ama o osowi lipu, a̱kutsuma̱, na̱ nrumba̱. ");
INSERT INTO tswNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","A̱vu fo vu ta̱ tsura̱ abaꞌun; adama a na a̱ ri ni ili i na aa tsupaa wu shi. O urana u na a̱za̱ a̱ a̱ɓula̱ a̱a̱ ꞌyon, a ta tsupa wu.” ");
INSERT INTO tswNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ana vuma ta̱ a̱tsuma̱ a aza a na a̱ ri a alya na̱ a̱yi wu uwwai ne, a̱vu u damma yi, “Za va abaꞌun a ɗa za na aa lyuwa ilyalya o tsugono tsa̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","A̱vu gba u damma yi, “Vuma ro yuwan ta̱ a̱ba̱jini a̱ a̱buki. A̱vu u banu ama na̱ a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ana mantsa ma̱ a̱buki ma rawai, reve u lyungu aagbashi a̱ yi adama u damma aza a na a banuyi, ‘Ta̱wa̱i adama a na ili biti i tu ufoɓu!’ ");
INSERT INTO tswNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Suru nle gba, reve a uwa a̱ ta̱wusa̱a̱ na adanshi a̱ ma̱bula̱a̱ kokoꞌo. Za vu ufaru damma aagbashiꞌi, ‘N tsula ta̱ uɗuma̱, agba n ciga ta̱ n ꞌya̱wa̱ n ka̱lyuwa̱ yi. M pati wu ta̱, vu yuwaan mu ankuri.’ ");
INSERT INTO tswNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Reve za ro damma, ‘N tsula ta̱ inan yi iluma wunlu u ton. N ta̱ ꞌya̱wa̱ n rito le. M pati wu ta̱ vu yuwaan mu ankuri.’ ");
INSERT INTO tswNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Reve za ro damma, ‘N yuwan ta̱ lolo adama o ndolo ma̱a̱ tsura̱ a̱ ꞌya̱wa̱ shi.’ ");
INSERT INTO tswNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Reve aagbashiꞌi u ka̱mba̱ u ka̱mbuwa̱ zavuꞌwa va̱ yi ili i nda suru. Reve zavuꞌwaꞌa a̱tsuma̱ o upan, u damma aagbashiꞌi, ‘Jika̱ ꞌya̱wa̱ e re gbain na̱ murere n lyuci, vu ta̱wa̱a̱ na alambi, na ama o osowi a̱ lipu, nrumba̱, na̱ a̱kutsuma̱.’ ");
INSERT INTO tswNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Reve aagbashiꞌi u damma, ‘Zagbain, ili i na vu dammai a yuwan o koto ta̱, agba ure u buwa ta̱.’ ");
INSERT INTO tswNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Reve u damma aagbashiꞌi, ‘ꞌYa̱wa̱ e murere na̱ re gbain vu mɓa̱nga̱, vu zuwa ama a̱ ta̱wa̱, adama uꞌwa u va̱ u shiwan. ");
INSERT INTO tswNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","N ta dansaa wu a̱tsuma̱ aza a na a banuyi ko za ee peɗe ilyalya i va̱ shi.’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Reve oɓolo a ama a̱ a̱bunda̱ a̱ kuru yi, ɗaɗa u vadalai a̱vu u damma le, ");
INSERT INTO tswNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Aza a na a̱a̱ kuru mu o oꞌwo ojoro a̱ va̱, she na a laꞌa ciga mu na̱ mbara, na̱ mukuci, na̱ a̱ma̱ci, na̱ muwun, na azakpakpara a̱ a̱ma̱ci, na ali na azawawaꞌa e le, hali na aciyele fo. ");
INSERT INTO tswNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aza a na a tarai akpata e le, a̱vu a̱ kuru mu shi, a rawa o oꞌwo ojoro a̱ va̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Zane ɗa a̱tsuma̱ a̱ ɗu waa ciga u suwa ugungu, agba waa fara ka̱lyuwa̱ ili i na woo una, ko u ta̱ nu ucira u na woo gono yi shi? ");
INSERT INTO tswNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ta̱wa̱ wo oꞌwo nu u fara vara ikyun, reve u kuɗa̱ o ure. Reve aza a na a̱ ka̱ra̱sa̱ lo a yuwaan yi ulamu. ");
INSERT INTO tswNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","A damma, ‘Vuma nda teme ta̱ usaa, a̱vu u kuɗa̱ o ure.’ ");
INSERT INTO tswNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ko cuꞌun mogono ma ne ma ɗa na̱ wa̱a̱ ꞌya̱wa̱ u yuwan uvon, agba wa̱a̱ da̱nu neꞌen u yuwan majiyan shi? Ko nu u tara ama ukpakukupa kupa (10,000) u ta gura yuwan uvon na̱ mogono ma na ma̱ ri na ama ukpakukupa ushin (20,000). ");
INSERT INTO tswNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Na̱ waa gura shi, mogono ma̱ ndeɗe ubuwu alanga ɗaɗa wa̱a̱ lyungu nlingata ma̱ a̱sa̱la̱ a uwwulayi. ");
INSERT INTO tswNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ne ɗa fo suru nɗu, za na kakasai ni ili i na u ri na̱ a̱yi shi, waa gura oꞌwo ojoro a̱ va̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Akpaɗi a̱ tu ulobonu, amma na a buwa peme shi, na̱ nye wa̱a̱ ka̱mbuwisa̱ peme va̱ yi? ");
INSERT INTO tswNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","U ri nu ulinga wu umili e iɗa, ko e edemu shi. O tso oco yi ta̱. “Za na ri na atsuvu, lyawa wu uwwa.” ");
INSERT INTO tswNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Suru a̱za̱ o uꞌushishi wu utafa na̱ a̱za̱ o unusu a rawusa ta̱ ya̱ꞌa̱ yi, tsa̱ra̱ a uwwa yi. ");
INSERT INTO tswNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","A̱vu Afarishi na̱ munlu n Wila̱ e reme adanshi, a damma, “Vuma nda ushi ta̱ a̱za̱ o unusu, a̱vu waru u lyuwa oɓolo ne ele.” ");
INSERT INTO tswNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","A̱vu Yesu yuwaan le iroci i nda: ");
INSERT INTO tswNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Na̱ nanza a̱tsuma̱ a̱ ɗu u ri ni ikyon ukpaku, a̱vu u lamba za ta̱ a̱tsuma̱ e le, nye waa yuwan? U ta lyawa kupakucci na̱ kucci o ogozo, a̱vu u ꞌya̱wa̱ u zami za na puwa̱yin hali u tsura̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nu u tsura̱ yi, a̱vu u tanu yi e ilyungu a yuwusan ma̱za̱nga̱. ");
INSERT INTO tswNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","A̱vu u tara yi a̱ ta̱wa̱ o uꞌwa. A̱vu u banu nꞌutsa̱ ma̱ yi na̱ nron mu nden ma̱ yi oɓolo, a̱vu u damma, ‘Yuwain ma̱za̱nga̱ na̱ a̱mu, me ene ta̱ kyon na shi puwa̱a̱n nuwu.’ ");
INSERT INTO tswNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ne ɗa maa dansaa ɗu, a ta laꞌa yuwan ma̱za̱nga̱ ma̱ a̱bunda̱ ɗe zuva, na̱ za vu unusu ta̱ vadala, a na aa yuwan a aci ama kupakucci na̱ kucci a̱za̱ a̱ a̱ɓula̱ a na wo oꞌwoi she na a vadala shi. ");
INSERT INTO tswNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Na̱ ka ri ni ikebe i azurufa kupa, na̱ za ta̱ puwa̱a̱n a̱tsuma̱ e le, cine waa yuwan? U ta daɓa fitila, a̱vu wi iza̱ uꞌwaꞌa, a̱vu u zami yi ben uba̱ta̱ suru, hali u tsura̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nu u tsura̱ yi, a̱vu u ɗe nꞌutsa̱ na̱ nron mu nden ma̱ yi oɓolo, a̱vu u damma le, ‘Ta̱wa̱i i kamba mu ma̱za̱nga̱! Me ene ta̱ kebe ta̱ na riya̱ numu.’ ");
INSERT INTO tswNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ne ɗa maa dansaa ɗu, a ta yuwan ma̱za̱nga̱ a̱ ma̱ka̱ka̱n ma nlingata ma̱ A̱sula̱ na̱ za vu unusu ta̱ vadala.” ");
INSERT INTO tswNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","A̱vu Yesu lyuwa elime na adanshi, “A yuwan ta̱ vuma ro za na da̱na̱i na̱ muwun mo olobo n re. ");
INSERT INTO tswNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","A̱vu zawaꞌa damma yi, ‘N ciga ta̱ vu ca mu akunda a agadu a̱ va̱ gogo.’ A̱vu u neꞌeshen le itanaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Ana a yuwain rana meketeci, a̱vu zawaꞌa wina akunda e itana ya̱ yi, a̱vu u lyawa uꞌwa wa dada va̱ yi ni ikebeꞌe. A̱vu u ꞌya̱wa̱ e iɗa ya alanga, uba̱ta̱ u na wu unai ikebeꞌe babu aci. ");
INSERT INTO tswNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","A̱vu wu una ili i na u ri na̱ yi suru. A̱vu ambulu a uwa uba̱ta̱ suru e iɗaꞌa, ko ili ya anini u da̱na̱ na̱ yi shi. ");
INSERT INTO tswNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","A̱vu u ꞌya̱wa̱ zamalinga o uɗuma̱ wu nanza. A̱vu u lyungu yi o uɗuma̱ wa̱ yi, tsa̱ra̱ u guɓusaa yi ngurusumu. ");
INSERT INTO tswNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","A̱vu u yuwan majiyan gashi u ta̱ tsura̱ ilyalya i na ngurusumu maa lyuwusa u lyuwa, agba babu za na ca niyi ili i na waa lyuwa. ");
INSERT INTO tswNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ana esu a̱ ta̱wa̱ niyi o ure, a̱vu u damma, ‘Agbashi a dada va̱ suru a tsu lyuwa ta̱ o sowo hali u buwa le. A̱mu ɗa nda a̱ kuwa̱ na ambulu. ");
INSERT INTO tswNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","N to foɓo, a̱vu n ka̱mba̱ uba̱ta̱ wa dada va̱, a̱vu n damma yi, “Dada, n yuwaan ta̱ A̱sula̱ na̱ a̱vu unusu. ");
INSERT INTO tswNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mu ntsaa vu ɗe mu mawun ma̱ wu shi, ka̱mba̱to mu aagbashi a̱ wu.” ’ ");
INSERT INTO tswNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","A̱vu u foɓo u ka̱mba̱ uba̱ta̱ wa dada va̱ yi. “A̱yi gba alanga nu uꞌwa, a̱vu dada va̱ yi ene yi, a̱vu we ene yi iliyali. Reve dada va̱ yi suma, a̱vu u katala yi, a̱vu u reme ipapuru ya̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“A̱vu uloboꞌo u damma dada va̱ yi, ‘Dada, n yuwaan ta̱ A̱sulazuva unusu na̱ a̱vu waru. Mu ntsaa vu ɗe mu mawun ma̱ wu shi.’ ");
INSERT INTO tswNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“A̱vu dada va̱ yi damma agbashi a̱ yi, ‘Ta̱wa̱yi nu utugu u na u laꞌai ulobonu, a̱vu yo oto yi gogo nda. Yo oto yi makawani a aakatsu na atan. ");
INSERT INTO tswNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","A̱vu i ta̱wa̱ na̱ manan ma saꞌani, a̱vu i paɗa yi, tsa̱ra̱ tsu yuwain a̱buki. ");
INSERT INTO tswNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mawun ma̱ va̱ ma̱ shi ta̱ ma̱ kuwa̱, gogo gba apa yi wuma. U shi ta̱ u puwa̱n, gogo gba a̱ tsura̱ yi ta̱!’ A̱vu e teme a̱buki. ");
INSERT INTO tswNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“A mantsa mo ndolo gba, mawun mo ufaru ma̱ yi u da̱na̱ ta̱ o uɗuma̱. A̱yi a̱ ma̱ta̱wa̱a̱, ana u rawai zuzu nu uꞌwa, a̱vu wu uwwa aganga nu ujeꞌen. ");
INSERT INTO tswNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","A̱vu u ɗe a̱tsuma̱ a agbashiꞌi vuma ta̱, a̱vu we ece yi ili i na i ri a mmalu. ");
INSERT INTO tswNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","A̱vu aagbashiꞌi u usu yi, ‘Zawaꞌa va̱ wu ɗa ka̱mba̱i, dada va̱ wu gba u paɗa ta̱ manan ma saꞌani mo ndolo, adama a na u ta̱wa̱i gbaga!’ ");
INSERT INTO tswNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“A̱vu zakparaꞌa u yuwan upan, a̱vu u ꞌyuwan a uwa o uꞌwa. A̱vu dada va̱ yi uta̱ a alanga, a̱vu u kparasa yi. ");
INSERT INTO tswNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","A̱vu u damma dada va̱ yi, a na, ‘Ka̱lyuwa̱ aꞌwan a̱ a̱bunda̱ a na n lingaa nuwu. Koto n kuɗa̱ a yuwan ili i na vu damma numu shi. Agba koto vu ca mu meggbele, tsa̱ra̱ n yuwan ma̱za̱nga̱ na̱ nꞌutsa̱ n va̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","A̱vu ana mawun ma̱ wu ma nda ma̱ ta̱wa̱i, za na lungusa̱i utsuru wa̱ wu a tsushakala, a̱yi ɗa nda, vu paɗa niyi manan ma saꞌani.’ ");
INSERT INTO tswNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“A̱vu dada va̱ yi u damma yi, ‘Mawun ma̱ va̱, vu ta̱ na̱ a̱mu kuci, ili i va̱ suru ili ya̱ wu i ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Wu ntsaa ta̱ tsu yuwain ma̱za̱nga̱ na̱ a̱buki, adama a na zawaꞌa va̱ wu shi ta̱ u kuwa̱, agba a̱yi ɗa nda wuma gogo. U shi ta̱ u puwa̱n, gogo gba a̱yi ɗa nda a̱ tsura̱ niyi.’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","A̱vu Yesu damma ojoro a̱ yi, “A yuwan ta̱ za vi ikebe i ro, u ta̱ na aagbashi a gbain a yuwusaan yi ulinga. Reve a damma yi ana u ta̱ lungususa̱ yi itana. ");
INSERT INTO tswNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Reve u ɗe yi we ece yi, ‘Nye i ɗa maa uwwusa adama a̱ wu? Roco mu ulinga u na vaa yuwusan. Va̱a̱ da̱shi oꞌwo zagbain vu ulingaꞌa shi.’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“A̱vu zagbain vu ulingaꞌa u damma, ‘Nye i ɗa maa yuwan? Zavuꞌwa va̱ ɗa nda u cigai u usa mu ulinga u va̱. N ri nu ucira u na maa yuwan cimba shi. Waru n ta uwwusa wono u na maa yuwan ipati. ");
INSERT INTO tswNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","N reve ta̱ ili i na maa yuwan, tsa̱ra̱ na̱ n lamba ulinga u va̱, ama a̱ ushi mu a ꞌwa le.’ ");
INSERT INTO tswNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“A̱vu u ɗe aza a na o kopoi itana yi zagbain va̱ yi a̱za̱ a̱ ta̱ ta̱. Reve we ece za vu ufaru, ‘Iyan i ɗa zagbain va̱ oo tono wu?’ ");
INSERT INTO tswNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“A̱vu u usu, ‘Ndele m maniꞌin ukpakukunla̱.’ “A̱vu za vu ulingaꞌa u damma yi, ‘Kakara a̱a̱vuꞌun a nzuwulaiꞌi, reve vu da̱nu, a̱vu vu ka̱mba̱to yi ukpakuna̱shi.’ ");
INSERT INTO tswNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“A̱vu we ecishe za ve ire, ‘Iyan i ɗa oo tono wu?’ “A̱vu u usu, ‘Ibufu yi ishina ukpaku.’ “Reve u damma yi, ‘Tara aatagada vu ka̱mba̱to yi kupakunla̱.’ ");
INSERT INTO tswNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Reve za vi ikebeꞌe u cuwa aagbashi a babu a̱ɓula̱ o ndolo adama o ugbozu wa̱ yi. Ama o uvaɗi a nda a̱ ta̱ nu ugbozu ununa a walato na̱ cuꞌun nda a mantsa ma nda, hali a laꞌa ta̱ ama a na a uwwusa wovon wa̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Amayun a ɗa maa dansaa ɗu, i linga nu utsuru wu uvaɗi u nda u na i ri na̱ a̱yi, tsa̱ra̱ i tsura̱ nꞌutsa̱, adama nu u koto ɗu, i tsura̱ uzuwa u na woo koto shi. ");
INSERT INTO tswNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Za na yuwain isaꞌani e ili i keꞌen, e ili i gbain fo u ta yuwan isaꞌani. Za na ri nu ulambu wa̱ a̱ɓula̱ e ili i keꞌen, u ta yuwan ulambu wa̱ a̱ɓula̱ e ili i gbain fo. ");
INSERT INTO tswNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ni i yuwan isaꞌani nu utsuru wu uvaɗi u nda shi, zane ɗa a̱ usuwa̱ ɗu nu utsuru wa zuva? ");
INSERT INTO tswNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na̱ ya̱a̱ ɓa̱na̱sa̱ itana ya avaɗi ulobonu shi, zane ɗa aa kamba ɗu i tsura̱ ili ya aciya̱ɗu? ");
INSERT INTO tswNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Aagbashi a̱ ta̱ aa gura yuwaan azagbain e re tsugbashi shi. U ta ꞌyuwan za ta̱, reve u ciga za ta̱. Ko u kuru za ta̱, reve u ꞌyuwan a̱ kuru za ta̱. Aa yuwaan A̱sula̱ ni Ikebe tsugbashi shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ana wo oꞌwoi Afarishi aza a na a cigai ikebe lon ɗa, ana a uwwai ne a̱vu a̱ ka̱ra̱ a yuwusaan yi ulamu. ");
INSERT INTO tswNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","A̱vu u damma le, “A̱ɗu i ta̱ ka̱lyuwusa̱ i ta yuwusan ili ya̱ a̱ɓula̱ a̱ ma̱ka̱ka̱n ma ama, agba A̱sula̱ e reve ta̱ okolo a̱ ɗu. Ili i na i ri ulobonu a̱ ma̱ka̱ka̱n ma ama, a ma̱ka̱ka̱n ma̱ A̱sula̱ idaba i ɗa a̱ ri.” ");
INSERT INTO tswNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","A̱vu Yesu lyuwa elime na adanshi, “Wila̱ wa Musa na adanshi a ama̱sula̱ o to lo hali a̱ tyo a mantsa ma Yahaya. Diga a yashi ya Yahaya i ɗa, aa yuwusan alajiya a Alabari a Saꞌani o tsugono tsa̱ A̱sula̱. Ama a̱ a̱bunda̱ a ta rawatosu aciyele, tsa̱ra̱ a uwa o tsugono tsa̱ A̱sula̱ nu ucira. ");
INSERT INTO tswNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","U ta laꞌa agalaci a zuva ni iɗa i koto, ana daɓi ta̱ a̱ Wila̱ꞌa̱ wa̱a̱ ka̱la̱ma̱. ");
INSERT INTO tswNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Za na lyawai ka va̱ yi, a̱vu u zuwisa ka ro, tsipere tsa ɗa waa yuwusan na̱ a̱yi. Za na waru zuwai ka na a lyawai, tsipere tsa ɗa waa yuwusan.” ");
INSERT INTO tswNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","A̱vu Yesu lyuwa elime na adanshi, “A yuwan ta̱ za vu utsuru u ro, u tso otosu ta̱ itana i shili ni itana i uri a̱za̱ e ikebe, u tsu uwwusa ta̱ uyoꞌo usana suru. ");
INSERT INTO tswNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","A zuwa ta̱ lambi ro o una̱ntsu wu uꞌwa wa̱ yi, aala a̱ yi a ɗa Liꞌazaru, lipu va̱ yi ma̱ɓula̱ antsu a ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","U ciga ta̱ u tsura̱ u lyuwa akapi a na o ocosu a mapara ma za vu utsuruꞌu. Musa̱n n tsu ta̱wa̱ ta̱ m pipeɗeshe antsuꞌu. ");
INSERT INTO tswNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ele lo ɗaɗa lambi ndolo u kuwa̱i, a̱vu nlingata ma̱ A̱sula̱ n tara yi a̱ ꞌya̱wa̱ uba̱ta̱ wa Ibrahim. A̱vu fo, za vu utsuruꞌu u kuwa̱, a̱vu a̱ ciɗo yi. ");
INSERT INTO tswNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","A̱yi a̱tsuma̱ a akina o sowuso a̱tsuma̱lima̱, a̱vu u ꞌya̱sa̱n aaci, a̱vu we ene Ibrahim alanga, na̱ Liꞌazaru a̱ ma̱ka̱ka̱n ma̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","A̱vu u ɗe yi, ‘Dada Ibrahim, ka̱lyuwa̱ iliyali i va̱. A̱vu vu lyungu Liꞌazaru daɓa aakatsu a̱ yi a̱ mini, tsa̱ra̱ u ta̱na̱to eelentsu a̱ va̱. A akina nda n to sowuso a̱tsuma̱lima̱.’ ");
INSERT INTO tswNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“A̱vu Ibrahim damma yi, ‘Mawun ma̱ va̱, vu cuwan a̱ nden mu uvaɗi ma̱ wu, na vu yuwain vu uwwa ta̱ uyoꞌo, Liꞌazaru waru a̱tsuma̱lima̱ a ɗa u sowusoi. Gogo gba uyoꞌo u ɗa waa uwwusa, a̱vu gba a̱tsuma̱lima̱ a ɗa voo sowuso. ");
INSERT INTO tswNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Babu na̱ a̱yi a̱a̱ka̱ri a̱ a̱ruꞌun o ta̱ lo e memere ma̱ a̱tsu na̱ a̱vu, tsa̱ra̱ aza a na a cigai a pasa a̱ tyo upasu u ndeɗe, aa gura wan. Waru za na ri ɗe upasu u ndeɗe, u pasa upasu u nda wan.’ ");
INSERT INTO tswNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“A̱vu za vu utsuruꞌu u damma, ‘Dada Ibrahim, n ta patishi wu, vu lyungu Liꞌazaru o uꞌwa wa dada va̱, ");
INSERT INTO tswNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","uba̱ta̱ u na n ri na̱ muwun ma̱ a̱na̱wu n ton. Tsa̱ra̱ u ꞌya̱wa̱ u damma le e reve cuꞌun vu nden n le, tsa̱ra̱ ele fo a̱ ta̱wa̱ uba̱ta̱ wa̱ a̱tsuma̱lima̱ a nda wan.’ ");
INSERT INTO tswNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“A̱vu Ibrahim damma yi, ‘A̱ ta̱ ɗe na atagada a Musa oɓolo na atagada a ama̱sula̱, lyawa le a uwwa le.’ ");
INSERT INTO tswNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“A̱vu u damma, ‘Oꞌo, dada Ibrahim, na̱ za ro a̱tsuma̱ a̱ a̱kwa̱kwa̱ a̱ ꞌya̱wa̱ uba̱ta̱ u le, a ta vadala.’ ");
INSERT INTO tswNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","A̱vu Ibrahim damma yi, ‘Na a uwwa Musa na ama̱sula̱ shi, ko na̱ za ro ꞌyon a̱tsuma̱ a̱ a̱kwa̱kwa̱ a̱vu u ꞌya̱wa̱, aa uwwa yi shi.’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","A̱vu Yesu damma ojoro a̱ yi, “Ili i na yaa zuwa vuma yuwan nusu o ta̱ lo, agba woo yoꞌono e ekere a za na a̱ ta̱wa̱i shi. ");
INSERT INTO tswNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","U shi ta laꞌaa yi a̱ nla̱a̱ yi aatali a yira a̱ yinlu a̱vu a vari yi a mala na waa zuwa a̱tsuma̱ a aza a wawaꞌa a nda a yuwan unusu. ");
INSERT INTO tswNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","I yuwan ugbozu na aciya̱ɗu. “Na̱ za va̱ wu yuwan unusu, vu damma yi. A̱vu nu u vadala, vu yuwaan yi gafura. ");
INSERT INTO tswNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nu u yuwaan wu unusu ucindere urana u ta̱, nu u ta̱wa̱ ya̱ꞌa̱ wu toto ucindere, adansa, ‘N vadala ta̱,’ vu yuwaan yi gafura.” ");
INSERT INTO tswNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","A̱vu ajiya a damma Zagbain, “Da̱shi tsu ucawu wo okolo!” ");
INSERT INTO tswNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","A̱vu Zagbain u usu, “Ni i shi nu ucawu wo okolo keꞌen cine suꞌwan uri ri, i shi ta damma ubiri u nda, ‘Vu mula̱, a̱vu vu shuwa̱ aciya̱wu a mala!’ Waru u ta uwwa ɗu. ");
INSERT INTO tswNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“A damma, a̱tsuma̱ a̱ ɗu nanza ta̱ na aagbashi a na a yuwusaan yi cimba ko aguɓa. Na̱ ma̱ta̱wa̱a̱ ma̱ yi o una, u ta damma yi, ‘Ta̱wa̱ vu lyuwa ilyalya gogo?’ ");
INSERT INTO tswNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Waa yuwan ne shi. U ta damma yi, ‘Foɓoo mu ilyalya yu ulivu, vu foɓo, a̱vu vu yuwaan mu a̱ga̱nda̱, hali n koto alya no oso. A̱vu vu ta̱wa̱ vu lyuwa vu sowo fo.’ ");
INSERT INTO tswNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","U ta damma aagbashi a̱ yi u godyo ta̱ adama a na u yuwain ili i na wu ntsayi u yuwan? ");
INSERT INTO tswNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","A̱ɗu fo ni i koto ili i na a damma nɗu i yuwan, i damma, ‘Tsu rawa shi. Tsu yuwan ta̱ ulinga u na u ri ulinga u tsu.’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Urana u ro, a̱yi a mmalu a̱ tyo Urishelima, a̱vu u toni na̱ mɓa̱nga̱ mi iɗa ya Samariya† na̱ Ga̱lili. ");
INSERT INTO tswNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","A̱yi a maꞌuwaa a̱ ma̱lyuci mo ro, a̱vu u gaꞌan na ali kupa nkutu. Ele alanga na̱ a̱yi, a̱vu e ɗe yi. ");
INSERT INTO tswNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","A̱vu a̱ ꞌya̱sa̱n ɗyo le, “Yesu Zagbain, ka̱lyuwa̱ iliyali i tsu.” ");
INSERT INTO tswNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ana we ene nle, a̱vu u damma le, “ꞌYa̱wa̱i uba̱ta̱ u nan ganu, tsa̱ra̱ e ene ɗu.” Ele a̱tsuma̱ a mmalu, a̱vu o oꞌwo gbaga. ");
INSERT INTO tswNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Za ta̱ a̱tsuma̱ e le, ana we enei u ka̱mba̱ ta̱ gbaga, a̱vu u ka̱mba̱ a yuwusaan A̱sula̱ ica o uta̱su uɗyo zuva. ");
INSERT INTO tswNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","A̱vu u kingyo a̱ ma̱ka̱ka̱n ma̱ Yesu o godyusho yi. A̱yi gba za va Samariya ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","A̱vu Yesu damma, “Ama kupa ɗa a̱ ka̱mba̱i gbaga shi? Te gba kucciꞌi? ");
INSERT INTO tswNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Cine wo oꞌwoi mocin nda ɗa goon ka̱mba̱i tsa̱ra̱ u godyoo A̱sula̱?” ");
INSERT INTO tswNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","A̱vu Yesu damma yi, “ꞌYon vu wala. Ucawu wo okolo a̱ wu a zuwa wu ta̱ vo oꞌwo gbaga.” ");
INSERT INTO tswNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Afarishi o ro e ece ta̱ yashi i na tsugono tsa̱ A̱sula̱† tsa̱a̱ ta̱wa̱. A̱vu u damma, “Tsugono tsa̱ A̱sula̱ na̱ yeni ye esu i ɗa wa̱a̱ ta̱wa̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Aa gura damma, ‘Ka̱lyuwa̱ pa nda ɗa u ri!’ ko aa damma, ‘A̱ ɗe yi!’ shi. Adama a na tsugono tsa̱ A̱sula̱ u te e memere ma̱ ɗu.” ");
INSERT INTO tswNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","A̱vu u damma ojoro a̱ yi, “Mantsa ma̱ ta̱ lo a̱ ta̱wa̱ ana yaa ciga yee ene urana u ta̱ a̱tsuma̱ a rana Mawun ma Vuma, agba yee ene shi. ");
INSERT INTO tswNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","A ta damma ɗu, ‘Apa yi!’ ko ‘A̱ ɗe yi!’ She i toni le wan. ");
INSERT INTO tswNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Urana u na Mawun ma Vuma ma̱a̱ ta̱wisa̱ u to oꞌwo oroci e imaɗatsu, i na i tsi ikana ɗe zuva diga ɗe o ufaru a̱ tyo o ukosu. ");
INSERT INTO tswNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Amayun u to sowo a̱tsuma̱lima̱ icuꞌun icuꞌun neꞌen, waru ama o gogo a ta ꞌyuwan yi. ");
INSERT INTO tswNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ununa u da̱na̱i a rana va̱ Nuhu,† ne ɗa waru woo oꞌwo a rana Mawun ma Vuma. ");
INSERT INTO tswNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ama a lyuwusa ta̱ no o sowi, na a casuyi lolo na a yuwin lolo, hali urana u na Nuhu uwai a wantsuꞌun. A̱vu mini ma gbain ma̱ ta̱wa̱, a̱vu u lyuwa le suru. ");
INSERT INTO tswNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ne ɗa u da̱na̱i a rana va̱ Lutu.† Ama a lyuwusa ta̱ no o sowi, a atsulu na a wini, a̱ ca̱ꞌa̱n na a suwi. ");
INSERT INTO tswNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Urana u na Lutu lyawai Sodom,† o roꞌoo yi ta̱ akina na̱ mikyon ana yaza diga zuva, a̱vu wu una le suru. ");
INSERT INTO tswNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ne ɗa woo oꞌwo urana u na Mawun ma Vuma ma̱a̱ ta̱wa̱. ");
INSERT INTO tswNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","O urana u ndolo, za na ri a̱ a̱ra̱ra̱ a̱ yi, ni itana ya̱ yi pe a̱tsuma̱, u uwa tsa̱ra̱ u tsura̱ le wan. Za na ri o una, she u ka̱mba̱ u tara ili i ro wan. ");
INSERT INTO tswNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","I cuwan na̱ ka va̱ Lutu! ");
INSERT INTO tswNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Za na cigai u soko wuma wa̱ yi, u ta lamba yi. Za na lambai wuma wa̱ yi waru ugoloɓu u ɗa u goloɓoi. ");
INSERT INTO tswNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","N ta dansaa ɗu, a ayin o ndolo, ama e re a̱ ta̱ da̱na̱ a aavalu a̱ ta̱, a ta tara za ta̱, a̱vu a lyawa za ta̱. ");
INSERT INTO tswNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","A̱ma̱ci e re a̱ ta̱ da̱na̱ a yira uba̱ta̱ u ta̱; a ta tara vuma ta̱, a lyawa vuma ta̱.  ");
INSERT INTO tswNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ali e re a̱ ta̱ da̱na̱ o uɗuma̱, a ta tara vuma ta̱, a lyawa vuma ta̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","A̱vu e ece yi, “Zagbain, te ɗa aa yuwan ili i ndaꞌa?” A̱vu u usu, “Cine i revei na̱ ye ene asala uɓolotowu uba̱ta̱ u ta̱ a̱a̱kwa̱kwa̱ o ta̱ lo zuzu, ne ɗa iroci i nda yoo rocosu ukosu u yuwan ta̱ zuzu.” ");
INSERT INTO tswNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","A̱vu Yesu yuwaan ojoro a̱ yi adanshi ni iroci adama u roco le u lobono ta̱ a yuwusan avasa kuci, agba a lyawa wan. ");
INSERT INTO tswNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","A̱vu u damma, “A̱ lyuci ro a yuwan ta̱ za vu ugeꞌetosu ro, za na aa uwwusa wovon wa̱ A̱sula̱ shi, agba u tara vuma ili i ro shi. ");
INSERT INTO tswNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ma̱runa̱ mo ro waru ma̱ shi ta̱ pe a̱ lyuciꞌi, a̱vu u ta̱wusa̱ uba̱ta̱ wu za vu ugeꞌetosuꞌu, adansa, ‘Vu kamba mu e ekere a nꞌyuwatan n va̱.’ ");
INSERT INTO tswNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“U shi ta̱ u ꞌyuwusan neꞌen. Na̱ a̱ca̱pa̱, ɗaɗa u dammai, ‘Ko ana maa uwwusa wovon wa̱ A̱sula̱ shi, agba n tara vuma ili i ro shi, ");
INSERT INTO tswNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","suru na̱ ne, adama a na ma̱runa̱ ma nda maa damatosun mu, n ta kamba yi. Na̱ n yuwan ne shi, u ta̱ kuna̱to mu na̱ ma̱ta̱wa̱!’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","A̱vu Zagbain damma, “Uwwai ili i na za vu ugeꞌetosu na ri na̱ a̱ɓula̱ shi dammai. ");
INSERT INTO tswNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","To, A̱sula̱ aa kamba aza a na u ɗangwai, aza a na a̱a̱ shoshen yi usana nu ulivu, adama a nꞌyuwatan n le shi? Waa kambushi nle shi? ");
INSERT INTO tswNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","N ta dansaa ɗu u ta kamba le ni ilaɗi. Suru na̱ ne, a mantsa ma na a̱mu Mawun ma Vuma ma̱a̱ ta̱wa̱, u ta cina a̱za̱ a̱ a̱ɓula̱ o uvaɗi gba?” ");
INSERT INTO tswNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Reve Yesu ene aza a na a̱a̱ ka̱lyuwusa̱ aciyele ili ya̱ a̱ɓula̱, na a laꞌai ama suru, agba a tara ozo o ro ili ya̱ a̱ɓula̱ shi. A̱vu u yuwaan le iroci i nda, u damma, ");
INSERT INTO tswNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ama e re a̱ ꞌya̱wa̱ ta̱ avasa a̱ A̱a̱ꞌisamapaɗa: za ta̱ Mafarishi, za ta̱ waru za vu ushishi wu utafa. ");
INSERT INTO tswNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Reve Mafarishi ma̱ ꞌyon u yuwan avasa a aciya̱yi, u damma, ‘A̱sula̱, n godyoo wu ta̱ a na n ri una̱ta̱ na akapi a ama shi, evu, a̱za̱ o ulambu wa̱ a̱ɓula̱, a̱za̱ a̱ tsipere ko ana za vu ushishi wu utafa u ndeɗe shi. ");
INSERT INTO tswNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","N tsu tara ta̱ akuli ure a ajuma suru. Waru n tsu uta̱ ta̱ za ta̱ a̱tsuma̱ a kupa e ili i na n tsura̱i suru.’ ");
INSERT INTO tswNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Za vu ushishi wu utafa gba reve wi isawan ɗe alanga. U ꞌya̱sa̱n aaci u ka̱lyuwa̱ zuva shi. A̱vu u lapa ma̱ka̱ka̱n ma̱ yi a̱ a̱tsumola̱ngu, a̱vu u damma, ‘A̱sula̱ vu ka̱lyuwa̱ iliyali i va̱, a̱mu za vu unusu ɗa!’ ");
INSERT INTO tswNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“N ta dansaa ɗu, vuma nda ka̱mba̱ ta̱ o uꞌwa wa̱ yi ookolo cece e ekere a̱ A̱sula̱, agba tsa Mafarishi mo ndolo shi. Adama a na za na ꞌya̱sa̱in aciya̱yi biti a̱ ta̱ ka̱ɗa̱to yi, za na gba ka̱ɗa̱toi aciya̱yi, a̱ ta̱ ꞌya̱sa̱n yi.” ");
INSERT INTO tswNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Reve a uwa a̱ ta̱wusa̱a̱ yi na̱ muwun n kekeꞌen, adama u juꞌwa̱n le. Ana ojoro a̱ yi e enei ne, reve a ɓara le. ");
INSERT INTO tswNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Reve Yesu ɗe muwuꞌun ya̱ꞌa̱ yi, a̱vu u damma, “Lyawai muwuꞌun a̱ ta̱wa̱ uba̱ta̱ u va̱, she i putsa le wan. Adama a na tsugono tsa̱ A̱sula̱, adama e icuꞌun i le i ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Amayun a ɗa maa dansaa ɗu, za na suru ushiyi tsugono tsa̱ A̱sula̱ tsa mawun me keꞌen shi, waa uwa o tsugono tsa̱ A̱sula̱ shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Reve zagbain ro ece yi, “Manlu ma̱ a̱ɓula̱, nye maa yuwan adama n uwa a wuma u na woo koto shi?” ");
INSERT INTO tswNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","A̱vu Yesu usu yi, “Nye i zuwai vu ɗe numu, za va̱ a̱ɓula̱?† Za lo na̱ a̱ɓula̱ shi, she A̱sula̱ goon. ");
INSERT INTO tswNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Vu reve ta̱ Wila̱: ‘She vu yuwan tsipere wan. She vu una za wan. She vi iva̱ wan. She vu usuwa̱ nanza ili i na vu revei shi wan. Waru vu ca abara na̱ makuci ma̱ wu tsugbain.’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Reve u usu, “Ele nda suru, a̱mu o molobo ɗaɗa maa yuwusan le.” ");
INSERT INTO tswNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ana Yesu uwwai ne, reve u damma yi, “Ili i ta̱ i ɗa i buwa nuwu. ꞌYa̱wa̱ vu wina ili i na vu ri na̱ a̱yi suru, reve vu neꞌeshen a̱za̱ e iliyali. Vu ta̱ tsura̱ uzuwa ɗe zuva. A̱vu vu ta̱wa̱ kuru mu.” ");
INSERT INTO tswNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ana wu uwwai ne, reve u uwa a̱tsumola̱ngu, adama a na u ri ni ili waꞌashi. ");
INSERT INTO tswNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ana Yesu ka̱lyuwa̱ niyi, ɗaɗa u tsu damma, “Ili yu usa̱n i ɗa aza a na a̱ ri nu utsuru a uwa o tsugono tsa̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","U ta laꞌa aarakumi a̱ pusula̱i na̱ vunu vu bele, ana za vu utsuru aa uwa o tsugono tsa̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Aza a na a uwwai ne, reve a damma, “To, zane ɗa aa laꞌa?” ");
INSERT INTO tswNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","A̱vu u damma, “Ili i na i ri usa̱n e ekere a vaɗilima̱ suru, ili yu usa̱n i ɗa e ekere a̱ A̱sula̱ shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","A̱vu Bituru damma, “A̱yi ɗa nda tsu lyawai ꞌwa tsu, a̱vu tsu kuru wu.” ");
INSERT INTO tswNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","A̱vu u damma le, “Amayun a ɗa maa dansaa ɗu, za na lyawai ili suru suru adama o tsugono tsa̱ A̱sula̱, u yuwan ta̱ ili i na i lobonoi. A̱yi ɗa za na aa lyawa uꞌwa, ko ka, ko zawaꞌa, ko zakpara, ko abara na̱ makuci, ko muwun. ");
INSERT INTO tswNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Za na yuwain ne, u ta̱ tsura̱ udoɓonuwu a mantsa mo gogo. A mantsa me elime, waru u ta̱ tsura̱ wuma u na woo koto shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Reve u tara ojoro a̱ yi a̱ tyo a̱ ngeꞌen, a̱vu u damma le, “A̱tsu ɗa nda a̱ ꞌya̱wa̱ Urishelima, agba ili i na ama̱sula̱ a ɗanai adama a Mawun ma Vuma biti, u ta shiwan. ");
INSERT INTO tswNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Adama a na u ta uwa e ekere a Atakpaci, a ta yuwaan yi ulamu. A ta yuwaan yi ili i na waa uwwa wono. A̱ ta̱ tsuwa̱a̱n yi ma̱tsa̱n. ");
INSERT INTO tswNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","A ta fufaba yi, reve o una yi. O urana wa taꞌatsu gba u ta̱ ꞌyon.” ");
INSERT INTO tswNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Agba a gura reve ili i na waa dansa shi. O soko ta̱ ucuɗuwu wa adanshiꞌi e ekere e le, ɗaɗa a gura revei ili i na u dammai shi. ");
INSERT INTO tswNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu arawa zuzu na̱ Jeriko, irumba̱ i ro i shi ta̱ lo nden e ipati a̱ ngeꞌen mu ure. ");
INSERT INTO tswNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ana wu uwwai ama a̱ ka̱ra̱sa̱, reve we ece nye i yuwain. ");
INSERT INTO tswNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Reve a damma yi, “Yesu va Nazara ɗa ri lo a̱ ka̱ra̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Reve u saala, “Yesu, Mawun ma̱ Da̱wuda, ka̱lyuwa̱ iliyali i va̱!” ");
INSERT INTO tswNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Reve aza a na a̱ da̱na̱i elime a ɓara yi, a damma yi u ɓa̱ru una̱. Reve gba u da̱shi uta̱a̱ uɗyo, “Mawun ma̱ Da̱wuda, ka̱lyuwa̱ iliyali i va̱!” ");
INSERT INTO tswNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Reve Yesu isawan, a̱vu u zuwa a̱ ta̱wa̱ na̱ a̱yi uba̱ta̱ wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Ana vumaꞌa u rawai zuzu, a̱vu Yesu damma, “Nye vu ciga n yuwaan wu?” A̱vu u damma, “Zagbain, n ciga ta̱ me ene ure.” ");
INSERT INTO tswNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Reve Yesu damma yi, “Ve ene ure. Ucawu wo okolo a̱ wu wo oꞌwoto wu ta̱ gbaga.” ");
INSERT INTO tswNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Lo ɗa we eneshi ure, reve u kuru yi a ciɓalasa A̱sula̱. Ana ama e enei ne waru, ɗaɗa a ciɓalai A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu uwa ta̱ Jeriko, a̱vu u ka̱ra̱la̱i. ");
INSERT INTO tswNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Zagbain vu uꞌushishi wu utafa da̱na̱ ta̱ lo, za na a̱ tsu ɗe Zaka, za vi ikebe i ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","U ciga ta̱ we ene ko zane ɗa Yesu, agba a̱yi mokoɗi ma ɗa. Adama o ndolo u gura ene yi shi adama a̱ a̱bunda̱ a ama. ");
INSERT INTO tswNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","A̱vu u suma elime a amaꞌa, a̱vu u kumba uteɗu u ro, tsa̱ra̱ we ene yi, adama a na o ure u ɗaɗa wa̱a̱ kuru. ");
INSERT INTO tswNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ana Yesu rawai uba̱ta̱ꞌa̱, a̱vu u ka̱lyuwa̱ zuva, a̱vu u damma yi, “Zaka, jika̱ vu cipa̱, adama a na anaꞌan o uꞌwa wa̱ wu u ɗa maa cuꞌwan.” ");
INSERT INTO tswNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","A̱vu Zaka jika̱ u cipa̱, a̱vu u ushi yi na̱ ma̱za̱nga̱. ");
INSERT INTO tswNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ana ama o ndolo suru e enei ne, a̱vu a uwa adanshawuya ana, “O uꞌwa wu za vu unusu u ɗa vuma nda uwai!” ");
INSERT INTO tswNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","A̱vu Zaka ꞌyon, a̱vu u damma Zagbain, “Zagbain, ve ene, n ta ca alambi uɓatsalai wi ili i na n ri na̱ a̱yi. Na̱ m paala waru nanza, n ta̱ ka̱mbuwa̱a̱ yi toto una̱shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","A̱vu Yesu damma yi, “Anaꞌan iwawi† i uwa ta̱ o uꞌwa u nda, adama a na a̱yi fo o ugundo wa Ibrahim u ɗa wu uta̱i. ");
INSERT INTO tswNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","A̱mu Mawun ma Vuma n ta̱wa̱ ta̱ izami yi ili i na i puwa̱yin, tsa̱ra̱ waru n wawa yi.” ");
INSERT INTO tswNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ana a uwwai ili i ndolo, a̱vu Yesu reme a dansaa le iroci i ro, adama a na u rawa ta̱ zuzu na̱ Urishelima. A yuwusan ta̱ majiyan waru gashi tsugono tsa̱ A̱sula̱ tsu ta̱ ta̱wa̱ keɗu. ");
INSERT INTO tswNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","A̱vu u damma, “A yuwan ta̱ vuma na da̱na̱i na̱ tsugbain lon, za na a̱a̱ ꞌya̱wa̱ e iɗa i ro, tsa̱ra̱ a ca yi tsugono, a̱vu u ka̱mba̱. ");
INSERT INTO tswNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","A̱vu u ɗe agbashi a̱ yi kupa, a̱vu u ca le ikebe i azurufa i ta̱-ta̱, a̱vu u damma le, ‘I vadalasa le hali n ta̱wa̱.’ ");
INSERT INTO tswNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ama a̱ yi a ciga yi shi, a̱vu a̱ lyungu ajiya na̱ a̱ca̱pa̱ a na, ‘Tsu ciga vuma nda wo oꞌwo mogono ma̱ tsu shi!’ ");
INSERT INTO tswNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Suru na̱ ne, vumaꞌa wo oꞌwo ta̱ mogono, a̱vu u ka̱mba̱ o uꞌwa. A̱vu u lyungu e ɗe agbashi a na u cayi ikebeꞌe. Tsa̱ra̱ we ene ili i na a̱ tsura̱i a̱tsuma̱ o uvadalasa u le. ");
INSERT INTO tswNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“A̱vu za vu ufaru ta̱wa̱ a̱ ma̱ka̱ka̱n ma̱ yi, a̱vu u damma, ‘Kebe azurufa ta̱ na vu ca numu, u ta̱wa̱a̱ ta̱ na̱ ikebe toto kupa.’ ");
INSERT INTO tswNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“A̱vu u damma yi, ‘A̱ku, aagbashi a̱ a̱ɓula̱! Ana vu yuwain a̱ɓula̱ e ili i keꞌen, n ca wu ta̱ tsugono tse ilyuci kupa.’ ");
INSERT INTO tswNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Reve za ve ire ta̱wa̱, a̱vu u damma, ‘Zagbain, kebe ta̱ va̱ wu rono ta̱ ikebe toto uton.’ ");
INSERT INTO tswNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“A̱vu zagbain va̱ yi damma yi, ‘Vu yuwan tsugbain tse ilyuci i ton.’ ");
INSERT INTO tswNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“A̱vu aagbashi o ro a̱ ta̱wa̱, a̱vu u damma yi, ‘Zagbain, apa wu kebe ta̱ va̱ wu! A aakashomuna a ɗa n shi n soko niyi. ");
INSERT INTO tswNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","N ta uwwusa wovon wa̱ wu, vu ri nu uro shi, vu ciga ta̱ ili ye pere, vu tsu gasa ta̱ ili i na vu cuꞌwa̱in shi.’ ");
INSERT INTO tswNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“A̱vu zagbain va̱ yi damma yi, ‘N ta̱ geꞌeto wu na adanshi o una̱ wa̱ wu. Vu reve ta̱ a̱mu n tu usuɗuwu, za vi icigi yi ili ye pere, n tsu gasa ta̱ ili i na n cuꞌwa̱in shi? ");
INSERT INTO tswNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Na̱ ne ɗa, nye i zuwai vu zuwai ikebe i va̱ o uꞌwa wi ikebe e ekere a̱ a̱za̱ o uvadalasa shi? Na̱ ma̱ta̱wa̱a̱ ma̱ va̱, a̱vu n ushi ni ili i na i kumbai zuva.’ ");
INSERT INTO tswNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“A̱vu u damma aza a na a̱ da̱na̱i mishin, ‘Ushiyi kebe ta̱ꞌa̱ e ekere a̱ yi, a̱vu i ca aagbashi a na a̱ ri ni ikebe kupa.’ ");
INSERT INTO tswNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“A̱vu e reme a dansa, ‘Zagbain, u ta̱ ni ikebe kupa!’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“A̱vu u usu, ‘N ta dansaa ɗu, za na ri ni ili, a̱yi ɗa a̱ da̱shi. Za na ri ni ili shi, keꞌen na u ri na̱ a̱yi, a̱ tsu ushi ta̱. ");
INSERT INTO tswNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nꞌyuwatan n na n cigai n yuwan tsugbain a aci e le shi, ta̱wa̱i ne ele o una le e esu a̱ va̱!’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ana Yesu dammai ne, a̱vu u lyuwa elime a̱ tyo Urishelima no ojoro a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ana u yuwain zuzu na̱ Batafaji na̱ Batanya, a masasan ma na a̱ tsu ɗe Masasan ma̱ Zetun, a̱vu u lyungu ama e re a̱tsuma̱ o ojoro a̱ yi ana, ");
INSERT INTO tswNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“ꞌYa̱wa̱i a̱tsuma̱ a̱ ma̱lyuci ma na ma̱ ri elime a̱ ɗu. Na̱ maꞌuwaa ma̱ ɗu, i te ene molloli wunlu, za na koto a kumbai shi. I ba̱ɗa̱ yi a̱ ta̱wa̱. ");
INSERT INTO tswNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Na̱ za ro ece ɗu, ‘Nye i zuwa ya̱a̱ ba̱ɗa̱sa̱ yi?’ I damma yi, ‘Zagbain ɗa ciga niyi.’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","A̱vu aza a na u lyunguyiꞌi a̱ ꞌya̱wa̱ a cina ununa u damma nle. ");
INSERT INTO tswNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ele a̱ ba̱ɗa̱sa̱ molloliꞌi, a̱vu za vi ili ece le, “Nye i zuwai ya̱a̱ ba̱ɗa̱sa̱ yi?” ");
INSERT INTO tswNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","A̱vu a̱ usu, “Zagbain ɗa ciga niyi.” ");
INSERT INTO tswNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","A̱vu a̱ ta̱wa̱a̱ Yesu. Ana o poloi amuna e le o molloliꞌi, a̱vu a kumbato ɗe Yesu. ");
INSERT INTO tswNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","A̱yi a̱tsuma̱ a mmalu, a̱vu ama o poluso amuna e le o ure. ");
INSERT INTO tswNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ana u rawai zuzu na̱ za̱la̱ Masasan ma̱ Zetun, a̱vu oɓolo o otoni a̱ yi e teme ica yu uyoꞌo a̱ tyo a̱ A̱sula̱ na̱ ɗyo, adama e ili ya asalama i na e enei. ");
INSERT INTO tswNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","A̱vu a damma, “Abaꞌun a̱ tyo o Mogono ma na ma̱a̱ ta̱wa̱ a ala a Zagbain!” “Asuvu nden zuva, na̱ tsugbain uba̱ta̱ wa̱ A̱sula̱!” ");
INSERT INTO tswNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","A̱vu Afarishi† o ro a̱tsuma̱ a ama a damma yi, “Manlu, ɓara ojoro a̱ wu.” ");
INSERT INTO tswNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","A̱vu u damma le, “Na̱ a̱ rungwa̱ kpaku, atali o to ɓoso ni ica.” ");
INSERT INTO tswNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ana u rawai zuzu, a̱vu we ene lyuciꞌi, a̱vu u showen yi. ");
INSERT INTO tswNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","A̱vu u damma, “Ni i shi i reve ili i na ya̱a̱ ta̱wa̱a̱ ɗu na asuvu nden, gogo gba o soko yi ta̱ e esu a̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mantsa ma̱ ta̱ ta̱wa̱ ɗu, ana nꞌyuwatan n ɗu maa suwaa ɗu atsura o ukari u ɗu, a̱vu a̱ ka̱nda̱ruwa̱ ɗu, a zuwa ɗu e memere. A̱vu e gigeshe ɗu upasu suru. ");
INSERT INTO tswNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","O to polo ɗu e iɗa, a̱ɗu na̱ muwun n ɗu. Aa lyawa aatali a̱ ta̱ zuva va aatali a̱tsuma̱ a̱ lyuciꞌi shi. Adama a na i revei mantsa ma na A̱sula̱ a̱ ta̱wa̱ nɗu shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","A̱vu u uwa a̱ A̱a̱ꞌisamapaɗa, reve u teme o losuso aza a na a̱ da̱na̱i a awina. ");
INSERT INTO tswNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","A̱vu u damma, “Uɗanu u ɗa u ri, ‘Uꞌwa u va̱ u to oꞌwo uꞌwa wa avasa.’ A̱vu a̱ɗu i ka̱mba̱to yi asaꞌa e evu.” ");
INSERT INTO tswNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Usana suru u tsu da̱na̱ ta̱ o rocosu a̱ A̱a̱ꞌisamapaɗa. Agba nan ganu a gbagbain na̱ munlu n Wila̱ na azagbain a̱tsuma̱ a amaꞌa a ciga ta̱ tsa̱ra̱ o una yi. ");
INSERT INTO tswNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","A̱vu a lamba ili i na aa yuwan, adama a na adanshi a̱ yi a̱ pura̱ ta̱ ugbozu wa ama. ");
INSERT INTO tswNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Urana u ro, Yesu o ritosu ama a̱ A̱a̱ꞌisamapaɗa, nu u yuwusain alajiya a Alabari a Saꞌani, a̱vu nan ganu a gbagbain, na̱ munlu n Wila̱, oɓolo na azagbain a̱ ta̱wa̱ ya̱ꞌa̱ yi. A̱vu a damma, ");
INSERT INTO tswNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Damma tsu nu ucira u ne u ɗa vaa yuwusaan cuꞌun vu ulinga u ndolo. Zane ɗa ca nuwu ucira u ndolo?” ");
INSERT INTO tswNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Reve u usu, “N ta yuwan ɗu yeci. Damma numu, ");
INSERT INTO tswNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","urumbusu u na Yahaya yuwusain, uba̱ta̱ wa̱ A̱sula̱ a ɗa wu uta̱i, ko uba̱ta̱ wu vaɗilima̱?” ");
INSERT INTO tswNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","A̱vu a dammulai va̱ni le, “Na̱ tsu damma, ‘Uba̱ta̱ wa̱ A̱sula̱,’ u te ece, nye i zuwai tsu usu niyi shi? ");
INSERT INTO tswNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Waru na̱ tsu damma, ‘Uba̱ta̱ wa ama,’ ama suru a ta vuvara tsu, adama a na ama e reve ta̱ Yahaya vumava̱sula̱ ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","A̱vu a̱ usu, “Tsu reve uba̱ta̱ u na wu uta̱i shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","A̱vu Yesu usu le, “A̱mu fo maa damma ɗu uba̱ta̱ u na ucira u na maa yuwusaan ulinga u nda wu uta̱i shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Reve u reme a yuwusaan ama iroci i nda, “Vuma ro ɗa cuꞌwa̱in uɗuma̱ wa inabi, a̱vu u lyawaa aza a zamalinga, a̱vu u jima ɗe uba̱ta̱ wu mmaluꞌu. ");
INSERT INTO tswNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mantsa mo ugasa, a̱vu u lyungu aagbashi a̱ ꞌya̱wa̱ uba̱ta̱ wa aza a zamalingaꞌa, tsa̱ra̱ a ca yi abaꞌun o uɗuma̱ꞌa̱. A̱vu aza a zamalinga a̱ ga̱ga̱la̱ yi, a̱vu o lo yi ekere lya̱nga̱. ");
INSERT INTO tswNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","A̱vu u lyungu aagbashi o ro waru, a̱vu a̱ ga̱ga̱lisa̱ yi fo, a̱vu a yuwaan yi ili i na i lobonoi shi, a̱vu o lo yi ekere lya̱nga̱. ");
INSERT INTO tswNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","A̱vu u lyunguwisa̱ aagbashi a taꞌatsu, a̱vu a uwwato yi usa̱n, a̱vu o lo yi. ");
INSERT INTO tswNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“A̱vu za vu uɗuma̱ꞌa̱ u damma, ‘Cine maa yuwan? N ta̱ lyungu macigata ma mawun ma̱ va̱. Ne e ene yi a ta uwwa yi.’ ");
INSERT INTO tswNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ana aza a zamalinga e ene niyi a̱ ta̱wa̱, a̱vu a dammulai, ‘Ndeɗe magaji ma̱ ta̱ ma̱ yi a̱ ta̱wa̱. Tsu una niyi, tsa̱ra̱ uba̱ta̱ꞌa̱ wo oꞌwo uba̱ta̱ u tsu.’ ");
INSERT INTO tswNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Reve o uta̱a̱ mawuꞌun o uɗuma̱ꞌa̱, a̱vu o una yi o ogozo. “Nye za vu uɗuma̱ꞌa̱ waa yuwan ne ele? ");
INSERT INTO tswNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","U to una aza a zamalinga o ndolo, a̱vu u ca ozo o ro uɗuma̱ꞌa̱.” Ana a uwwai ne, a̱vu a damma, “A̱sula̱ a para!” ");
INSERT INTO tswNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","A̱vu Yesu ka̱lyuwa̱ le mejege, a̱vu we ece, “Nye i ɗa urevu wi ili i na i ri uɗanu: ‘Aatali a na asuwi a ꞌyuwain, a̱yi ɗa wo oꞌwoi ikyun yu ucira a̱tsuma̱ o usaa.’ ");
INSERT INTO tswNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Za na riya̱i a aatali o ndolo suru, u ta kukuɗa suru suru. Za na gba aatali o ndolo a̱ riya̱yi u ta̱ luɓa̱tsa̱ yi cine vu revei yira.” ");
INSERT INTO tswNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Munlu n Wila̱ na̱ nan ganu a gbagbain a zami ta̱ ure u na ee reme yi babu usa̱n, e reve ta̱ iroci i na u yuwain a aciyele a ɗa u yuwain. A̱vu a uwwusa wovon wa ama. ");
INSERT INTO tswNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","A̱vu a vawusan yi, a̱vu a̱ lyungu aza a matawa mo utyo. A̱vu ele a yuwan gashi ama a̱ a̱ɓula̱ a ɗa, tsa̱ra̱ e reme yi nu unusu a adanshi a̱ yi, tsa̱ra̱ a̱ ca̱co yi e ekere a tsugbain tsa gwamna. ");
INSERT INTO tswNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","A̱vu e ece yi, “Manlu, a̱tsu tsu reve ta̱ adanshi a̱ wu na alajiya a̱ wu amayun a ɗa. Vuma suru una̱ta̱ u ɗa vu tara nle. Adanshi a saꞌani a̱ A̱sula̱ a ɗa voo rocosu. ");
INSERT INTO tswNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","U tu ulobonu tsu tsupa utafa u tsu ya Kaisa, ko tsu tsupa wan?” ");
INSERT INTO tswNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","A̱yi gba u reve ta̱ ugbozu u le, a̱vu u damma le ");
INSERT INTO tswNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","o roco yi ikebe. A̱vu u damma, “Ululu nu ukere wa zane ɗa u ri ɗe uɗanu?” ");
INSERT INTO tswNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","A̱vu a̱ usu, “Kaisa ɗa.” A̱vu u damma le, “I ca Kaisa ili i na i ri ili ya Kaisa, ili ya̱ A̱sula̱ waru i ca A̱sula̱ ili i na i ri ili ya̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","A gura reme yi e ili i na u dammai o oɓolo a amaꞌa shi. A̱vu a uwa asalama nu uꞌususu wa̱ yi, ɗaɗa a̱ rungwa̱i. ");
INSERT INTO tswNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Reve ama a na a̱ tsu ɗe Sadukiya† (aza a na a dammai babu uꞌyosun wa̱ a̱kwa̱kwa̱), a̱ ta̱wa̱ a yuwan Yesu yeci. ");
INSERT INTO tswNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","A̱vu a damma, “Manlu, Musa ɗanaa tsu ta̱, ‘Na̱ vuma kuwa̱, a̱vu u lyawa ka va̱ yi babu u matsan. A̱vu za va̱ yi sotso kaꞌa, tsa̱ra̱ u tsura̱a̱ yi mawun.’ ");
INSERT INTO tswNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","A yuwan ta̱ muwun ma̱ a̱na̱wu, ali e cindere. Za vu ufaru zuwa ta̱ ka, a̱vu u kuwa̱ babu mawun. ");
INSERT INTO tswNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","A̱vu za ve ire sotso yi, a̱vu u kuwa̱ babu mawun. ");
INSERT INTO tswNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ne ɗa fo, za va taꞌatsu sotso niyi, reve waru u kuwa̱ babu mawun. Ne ɗa ama e cindere o ndolo a zuwa niyi, na̱ a̱ kuwi, babu za na tsura̱i mawun na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Na̱ a̱ca̱pa̱, a̱vu kaꞌa u kuwa̱. ");
INSERT INTO tswNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","O urana u na a̱a̱ ꞌya̱sa̱n a̱kwa̱kwa̱, ka va zane ɗa woo oꞌwo a̱tsuma̱ e le? Adama a na ali e cindere o ndolo suru a zuwa yi ta̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","A̱vu u usu le, “Ama a mantsa ma nda, a ta yuwusan lolo na̱ a̱ ꞌya̱wi lolo. ");
INSERT INTO tswNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Aza a na e enei na̱ a̱ɓula̱ a na aa uwa a mantsa nu uꞌyosun wa̱ a̱kwa̱kwa̱, aa yuwan ko a̱ ꞌya̱wa̱ lolo shi. ");
INSERT INTO tswNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","A̱ da̱shi kuwa̱ shi, o to oꞌwo tsa nlingata ma̱ A̱sula̱. Muwun ma̱ A̱sula̱ n ɗa ana wo oꞌwoi A̱sula̱ a̱ ꞌya̱sa̱n nle. ");
INSERT INTO tswNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Adama o uꞌyosun wa̱ a̱kwa̱kwa̱ waru, Musa damma ta̱ a aalabari o oroci o molopu a madala uba̱ta̱ u na u ɗeyi Zagbain, ‘A̱sula̱ a Ibrahim, na̱ A̱sula̱ a Ishiyaku, na̱ A̱sula̱ a Yakubu.’ ");
INSERT INTO tswNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","A̱yi A̱sula̱ a̱ a̱kwa̱kwa̱ a ɗa shi, amma A̱sula̱ a aza a wuma a ɗa, e ekere a̱ yi ama suru wuma u ɗa a̱ ri.” ");
INSERT INTO tswNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","A̱vu munlu n Wila̱† n ro n usu, “Manlu, amayun a ɗa vu dammai!” ");
INSERT INTO tswNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","A̱ tsura̱ za na tsura̱i ucira u na wee ece yi ili i ro shi. ");
INSERT INTO tswNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","A̱vu Yesu damma le, “Cine yaa dansa Kristi Mawun ma̱ Da̱wuda ma ɗa? ");
INSERT INTO tswNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Da̱wuda na aciya̱yi u damma ta̱ a Aatagada e Ica:† ‘A̱sulazuva a damma ta̱ Zagbain va̱, “Da̱nu o ukere u usaꞌani, ");
INSERT INTO tswNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","she na̱ n zuwa nꞌyuwatan ma̱ wu a apata a ana a̱ wu.” ’ ");
INSERT INTO tswNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Da̱wuda ɗe yi ta̱ ‘Zagbain.’ Cine a̱yi woo oꞌwo mawun ma̱ yi?” ");
INSERT INTO tswNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ama a uwwusa ili i na waa dansa, ɗaɗa Yesu dammai ojoro a̱ yi, ");
INSERT INTO tswNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“I reve ununa yaa yuwan na̱ munlu n Wila̱. Aza a na a cigai agara na̱ a̱tugu a gbagbain, aza a na a cigai a̱ ca̱sa̱ le e eden, a̱ da̱na̱ na̱ nda̱na̱ta̱ n saꞌani a̱ a̱ꞌisa̱ na̱ nda̱na̱ta̱ n tsugbain uba̱ta̱ wa̱ a̱buki. ");
INSERT INTO tswNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ele ɗa a tsu ususa nruna̱ ili. A̱vu waru a yuwusan avasa o ugaꞌan adama a̱ ꞌya̱sa̱n avangaci. Icuꞌun ya ama o ndolo a ta uwwa a̱tsuma̱lima̱ lon.” ");
INSERT INTO tswNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ana Yesu ꞌya̱sa̱in aaci zuva, a̱vu we ene a̱za̱ o utsuru a zuwusa uneꞌe u le o uzuwata wa̱ A̱a̱ꞌisamapaɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","We ene ta̱ waru ma̱runa̱ me iliyali u zuwai anini e re. ");
INSERT INTO tswNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","A̱vu u damma le, “Amayun a ɗa maa dansaa ɗu, ma̱runa̱ ma nda u zuwa ta̱ ili i na i laꞌai akapi a ama. ");
INSERT INTO tswNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ama a nda suru a zuwa ta̱ a̱tsuma̱ o utsuru u na a̱ ri na̱ a̱yi, a̱yi gba a̱tsuma̱ o ulambu wa̱ yi, u zuwa ta̱ ikebe i na waa lyuwa ilyalya suru.” ");
INSERT INTO tswNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ojoro o ro a yuwusan ta̱ adanshi adama a̱ A̱a̱ꞌisamapaɗa, nu ununa a lapula niyi na atali a saꞌani,† nu uneꞌe u na a cayi A̱sula̱ kucci.† A̱vu Yesu damma, ");
INSERT INTO tswNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ele nda suru a na ye eneshe, mantsa mo ta̱ lo a̱ ta̱wa̱ ana aa lyawa aatali a̱ ta̱ zuva vu za va̱ yi shi, suru nle o to oco le e iɗa.” ");
INSERT INTO tswNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Reve e ece, “Manlu, yashi i ne i ɗa ili i ndolo yaa fara? Nye i ɗa yoo roco tsu mantsa ma yuwan ta̱ a na ili i ndolo yaa fara?” ");
INSERT INTO tswNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","A̱vu Yesu damma le, “I yuwan ugbozu, i lyawa nanza pusa̱n ɗu ana wan. Ama na̱ a̱bunda̱ a̱ ta̱ ta̱wa̱ na aala a̱ va̱ adansa, ‘A̱mu ɗa a̱yi,’ waru, ‘Mantsaꞌa u yuwan ta̱ zuzu.’ She i toni le wan. ");
INSERT INTO tswNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na̱ yu uwwa alabari o uvon na̱ nla̱ngi, she yi dadaꞌwan wan. ꞌYuwan ciga ili i ndolo i ta fara, agba koto ukosu u rawa shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","A̱vu u damma le, “Iɗa i ta yuwan nla̱ngi ni iɗa, tsugono tsa̱ ꞌya̱sa̱n nla̱ngi na̱ tsugono. ");
INSERT INTO tswNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","A ta yuwan ura̱mosu wi iɗa nu ucira, a ta yuwan ambulu na̱ mɓa̱la̱ ba̱ta̱ kokoꞌo. A ta yuwan ili i wovon ni iroci i gbagbain zuva. ");
INSERT INTO tswNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Agba kafu a̱yi ndolo, e te reme ɗu, a zuwa ɗu a̱ a̱tsuma̱lima̱. A̱ ta̱ ꞌya̱wa̱to ɗu a̱ a̱ꞌisa̱ na̱ ꞌwa va ali, na̱ a̱ ma̱ka̱ka̱n mo ngono na aza a tsugbain adama a aala a̱ va̱. ");
INSERT INTO tswNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","A̱yi ndolo u to oꞌwo ɗu ure u na yaa damma le Alabari a Saꞌani. ");
INSERT INTO tswNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","I gbama asuvu a̱ ɗu i lyawa u ɓa̱la̱ ɗu e ili i na ya̱a̱ usu wan. ");
INSERT INTO tswNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","N ta ca ɗu idanshi nu ugbozu, a na aza a na a ꞌyuwan nɗu aa gura isawan shi. ");
INSERT INTO tswNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","A̱za̱ a̱ ɗu suru: nan dada, na azakpakpara, na̱ mmaci n ɗu, na̱ nꞌutsa̱, a ta wina ɗu. Waru a ta zuwa o una ozo o ro a̱tsuma̱ a̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ama suru a ta ꞌyuwan ɗu adama a̱ va̱. ");
INSERT INTO tswNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Agba ko a̱nji a̱ ta̱ a aci a̱ ɗu a̱a̱ riya̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","I yuwan asuvu, i ta̱ tsura̱ wuma u ɗu. ");
INSERT INTO tswNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Na̱ ye ene a̱soja a̱ ka̱nda̱ruwa̱ Urishelima, i reve ulungusu wa̱ yi u rawa ta̱. ");
INSERT INTO tswNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Aza a na a̱ ri Yahuda a suma a̱ tyo a atali. Aza a na a̱ ri pe a̱ e ilyuciꞌi o uta̱ pe. Aza a na a̱ ri a̱ mulyuci a uwa a̱ lyuciꞌi wan. ");
INSERT INTO tswNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mantsa ma̱ a̱tsuma̱lima̱ ma ɗa a na ili i na a ɗanai yaa shiwan. ");
INSERT INTO tswNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Woo yoꞌono a̱ma̱ci a na a̱ ri na̱ a̱tsuma̱ shi, na aza a na aa casu muwun maani a mantsaꞌa! A̱tsuma̱lima̱ a ta uwa e iɗa i ndolo nu upan wa̱ A̱sula̱ e ekere a ama o ndolo. ");
INSERT INTO tswNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","A̱ to una ozo o ro na̱ matsun me peꞌeni, a ta tara ozo o ro a̱ ꞌya̱wa̱ o uꞌwa wa ali e iɗa suru. Atakpaci a ta dadasa Urishelima hali mantsa ma Atakpaci mo koto. ");
INSERT INTO tswNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“E te ene iroci o urana, na̱ woto, ni italyoꞌo. O uvaɗi waru iɗa suru u to oꞌwo na̱ wovon wi ilama i mala, ni ikeɗu ikeɗu i malaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Adama o wovon ama a̱ ta̱ lima̱, adama e ili i na yaa farasa a̱tsuma̱ o uvaɗi. Waru asuvu a̱ ta̱ da̱na̱ a̱ riya̱sa̱ ama, adama a na a̱ ta̱ jinga̱ɗa̱ ili i gbagbain i na i ri zuva. ");
INSERT INTO tswNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","A mantsa mo ndolo ma ɗa ee ene Mawun ma Vuma a̱ ta̱wa̱ e eleshe, nu ucira, na̱ tsugbain tsa̱ a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mantsa ma na ili i ndolo i farai e temeshe, i ꞌya̱sa̱n aci i ka̱lyuwa̱ zuva, adama a na mantsa ma mawawa ma̱ ɗu ma yuwan ta̱ zuzu.” ");
INSERT INTO tswNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","A̱vu Yesu yuwaan le iroci i nda: “Ka̱lyuwa̱i uɗanga wu ubiri na akapi a ɗanga. ");
INSERT INTO tswNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","No o topo a̱vuꞌun, i te reve na aciya̱ɗu lyushi yuwan ta̱ zuzu. ");
INSERT INTO tswNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ne ɗa waru, na̱ ye ene ili i ndolo a farasa, i reve tsugono tsa̱ A̱sula̱ tsa yuwan ta̱ zuzu. ");
INSERT INTO tswNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Amayun a ɗa maa dansaa ɗu, ama a mantsa ma nda oo koto shi, she ni ili i ndolo i shiwan. ");
INSERT INTO tswNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Zuva ni iɗa i ta̱ ka̱ra̱, agba adanshi a̱ va̱ oo koto shi. ");
INSERT INTO tswNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“I yuwan ugbozu na aciya̱ɗu adama a alya a̱ a̱bunda̱, no oso a̱ a̱bunda̱ ni iwuya, na̱ a̱tsumola̱ngu adama e izami yi ili yu uvaɗi u nda. Na̱ ne ɗa shi, urana u ndolo u ta̱ ta̱wa̱ ɗu babu urevu ununa i revei yakuru. ");
INSERT INTO tswNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ne ɗa wa̱a̱ ta̱wa̱ e ekere a aza a na a̱ ri nden a̱tsuma̱ o uvaɗi suru. ");
INSERT INTO tswNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","I da̱na̱ ufoɓu kuci. I yuwusan avasa tsa̱ra̱ i tsura̱ ucira u na yaa laꞌa ni ili i na yaa fara, tsa̱ra̱ waru yi isawan a̱ ma̱ka̱ka̱n ma Mawun ma Vuma.” ");
INSERT INTO tswNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Usana suru Yesu tsu da̱na̱ ta̱ o ritosu a̱ A̱a̱ꞌisamapaɗa.† Ulivu suru waru, u tsu ꞌya̱wa̱ ta̱ a masasan ma na a̱ tsu ɗe Masasan ma̱ Zetun. ");
INSERT INTO tswNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nu usanusana, waru ama suru a̱ tsu ta̱wa̱ ta̱ a̱ A̱a̱ꞌisamapaɗa, tsa̱ra̱ a uwwa yi. ");
INSERT INTO tswNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yashi ya̱ A̱buki o Opopofu,† za na a̱ tsu ɗe A̱buki a Mapasa,† a yuwan ta̱ zuzu. ");
INSERT INTO tswNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Reve nan ganu a gbagbain na̱ munlu n Wila̱ a uwa izami yu ure u na oo una Yesu. Agba a̱ shi ta uwwusa wovon wa ama. ");
INSERT INTO tswNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Reve Male† ma uwa o okolo a Yahuza Iskariyoti, vuma ta̱ a̱tsuma̱ a Kupanejereꞌe. ");
INSERT INTO tswNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","A̱vu u ꞌya̱wa̱ u yuwan a̱sa̱la̱ na̱ nan ganu a gbagbain na̱ a̱duga̱ri a̱ A̱a̱ꞌisamapaɗa ununa waa winaa le a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Reve a yuwan ma̱za̱nga̱, a̱vu a damma a ta ca yi ikebe. ");
INSERT INTO tswNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Reve u usu, ɗaɗa u zamishiyi ure u na waa zuwa e reme yi babu ama lo. ");
INSERT INTO tswNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","A̱vu urana wa̱ A̱buki o Opopofu u rawa, urana u mapaɗa me ikyon i Mapasa.† ");
INSERT INTO tswNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","A̱vu Yesu lyungu Bituru na̱ Yahaya u damma le, “ꞌYa̱wa̱i i foɓoo tsu uba̱ta̱ a alya e ilyalya i Mapasa, adama tsu lyuwa.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","A̱vu e ece yi, “Te ɗa vu cigai tsu foɓo yi?” ");
INSERT INTO tswNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","A̱vu u damma le, “Ni i uwa a̱ lyuci, i ta gaꞌan na̱ vuma utanuwu na̱ a̱a̱ka̱bu a̱ mini. I kuru yi a uwa o uꞌwa u na waa uwa, ");
INSERT INTO tswNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","a̱vu i damma za vu uꞌwaꞌa, ‘Manlu ma damma ta̱: Te ɗa aasula o omocin, uba̱ta̱ u na maa lyuwa ilyalya i Mapasa no ojoro a̱ va̱?’ ");
INSERT INTO tswNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","U to roco ɗu aasula a gbain o uꞌwa wa zuva ufoɓu, a̱vu i foɓoo tsu.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Reve a̱ ꞌya̱wa̱ ɗaɗa a cinai ili i na Yesu damma nle ununa u dammai. Reve o foɓo ilyalya i Mapasa.† ");
INSERT INTO tswNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ana mantsa ma rawai, a̱vu u da̱nu alya oɓolo na ajiya† a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","A̱vu u damma le, “N zuwa ta̱ okolo a̱ va̱ n lyuwa ilyalya i Mapasa i nda oɓolo na̱ a̱ɗu, kafu n sowo a̱tsuma̱lima̱. ");
INSERT INTO tswNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","N ta dansaa ɗu, ma̱a̱ da̱shi lyuwa yi shi, she no o shiton ili i ndolo o tsugono tsa̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Reve u tara mokoto ana u godyoyi A̱sula̱, a̱vu u damma, “Ushiyi nda, i neꞌeshen. ");
INSERT INTO tswNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","N ta dansaa ɗu, diga gogo ma̱a̱ da̱shi sowo masayan ma ataci a inabi shi, she na̱ tsugono tsa̱ A̱sula̱ tsa̱ ta̱wa̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Reve u tara opopofu, ana u godyoyi A̱sula̱, reve u bubusa yi. Ɗaɗa u ca nle, a̱vu u damma, “Nda lipu va̱ ɗa na a cayi adama a̱ ɗu. I yuwusan ne kuci, adama i cuwusan na̱ a̱mu.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ana o kotoi alyaꞌa, reve u tara mokoto ma masayan ma inabi,† a̱vu u damma, “Mokoto ma nda akucunu† a saꞌavu a̱ A̱sula̱ a ɗa a̱tsuma̱ a mpasa n va̱ n na oo oco adama a̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Agba za na aa wina mu u ta alya oɓolo na̱ a̱mu. ");
INSERT INTO tswNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","A̱mu Mawun ma Vuma n ta̱ kuwa̱ ununa a zuwai. Agba woo yoꞌono za na aa wina mu shi!” ");
INSERT INTO tswNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Reve a uwa mecilei va̱ni le, zane aa yuwan ulinga u ndolo. ");
INSERT INTO tswNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Reve ojoroꞌo a uwa mawasan adama a za na oo oꞌwo zagbain a̱tsuma̱ e le. ");
INSERT INTO tswNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","A̱vu u damma le, “Ngono ma Atakpaci† a tsu yuwan ta̱ tsugbain e ekere e le. Aza a tsugbain waru a tsu ciga ta̱ e ɗe le Ama e Ikambi ya Ama. ");
INSERT INTO tswNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","She wo oꞌwo ne e ekere ɗu wan. Za na cigai wo oꞌwo zagbain a̱tsuma̱ a̱ ɗu, she nu u ka̱mba̱ mawun ma̱ ɗu. Za na cigai u uwa elime a̱ ɗu waru wo oꞌwo aagbashi. ");
INSERT INTO tswNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Zane ɗa gba laꞌai mgbain, za na ri nden a alya ko za na e neꞌesheshen? Za na ri nden ɗa shi? A̱mu ɗa nda a̱tsuma̱ a̱ ɗu ana za tsugbashi. ");
INSERT INTO tswNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","A̱ɗu ɗa i ri oɓolo na̱ a̱mu a̱ a̱tsuma̱lima̱ a̱ va̱. ");
INSERT INTO tswNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ununa Dada va̱ ca numu tsugono, ne ɗa fo maa casu ɗu, ");
INSERT INTO tswNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","adama i lyuwa i sowo oɓolo na̱ a̱mu o tsugono tsa̱ va̱. Waru reve i da̱nu o otogu o tsugono e geꞌetosu gundo kupa ne ejere va Israꞌila.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","A̱vu Zagbain damma, “Simo, Simo, Male ma zami ta̱ ure adama u tsura̱ u yeluwe ɗu ana ishina. ");
INSERT INTO tswNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Agba n yuwaan wu ta̱ avasa adama vu riya̱ wan. Na̱ vu ka̱mbisa̱, vu kamba a̱za̱ a̱ wu.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","A̱vu u damma yi, “Zagbain, n tu ufoɓu n kuru wu a̱ tyo o uꞌwa wa ali, hali a̱ tyo o ukwa̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","A̱vu u damma yi, “N ta dansaa wu, Bituru, kafu moton ma saala anaꞌan, vu ta wasan mu utaꞌatsu.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","A̱vu u damma le, “Ana n lyungu nɗu babu ikebe ko tsa̱n ko atan, i lamba ta̱ ili i ro?” Reve a̱ usu, “Ko ili i ta̱ tsu lamba shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","A̱vu u damma le, “Gogo za na ri ni ikebe ko tsa̱n u tara. Za na waru ri na̱ matsun me peꞌeni shi, u wina aapalutsu a̱ yi adama u tsula. ");
INSERT INTO tswNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","N ta dansaa ɗu, adanshi a̱ A̱sula̱ a nda a ta shiwan a aci a̱ va̱, a na, ‘Reve e kece yi oɓolo na aza a na a̱ ꞌya̱sa̱sa̱a̱n tsugono aci,’ adama a na ili i na a ɗanai adama a̱ va̱ u ta shiwan.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Reve a damma, “Zagbain, ka̱lyuwa̱ nda mutsun mu peꞌeni n re.” Reve u damma le, “A rawa ta̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","A̱vu wu uta̱ ununa u tsu yuwusan a̱ ꞌya̱wa̱ a Masasan ma̱ Zetun. Reve ojoro a̱ yi a̱ kuru yi. ");
INSERT INTO tswNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ana u rawai uba̱ta̱ꞌa̱, reve u damma le, “I yuwan avasa adama i uwa a̱tsuma̱ a̱ ma̱lyungwa̱ wan.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ana u ka̱ra̱i malanga ne ele, reve u kingyo, a̱vu u yuwan avasa. ");
INSERT INTO tswNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","A̱vu u damma, “Dada, na̱ vu usu vu tawaa mu mokoto ma̱ a̱tsuma̱lima̱ ma nda. Amma she vu kuru ili i na n cigai wan, amma ili i na vu cigai.”  ");
INSERT INTO tswNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","A̱vu malingata ma̱ A̱sula̱ ma̱ ta̱wa̱ diga zuva a kambusa yi. ");
INSERT INTO tswNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Agba ana u ri a uwwusa a̱tsuma̱lima̱ lon, reve u da̱shi lyuwa elime na avasa, reve melen ma̱ yi ma uwa a̱ ɗa̱wusa̱ e iɗa, cine vu revei mudaɓi mu mpasa. ");
INSERT INTO tswNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ana u kotoi avasa, reve u ta̱wa̱ uba̱ta̱ wo ojoro a̱ yi, a̱vu u cina le a nlavu ana a̱ kuna̱i na̱ a̱tsumola̱ngu. ");
INSERT INTO tswNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Reve u damma le, “Adama a̱ nye i ri a nlavu? ꞌYoyin i yuwan avasa adama i riya̱ a̱tsuma̱ a̱ ma̱lyungwa̱ wan.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","A̱yi a̱tsuma̱ a adanshi ɗaɗa ama a rawushi. Vuma na a̱ tsu ɗe Yahuza a̱tsuma̱ o ojoro a̱ yi a̱yi ɗa u walaa nle elime. Reve u rawa zuzu na̱ Yesu adama u katala yi. ");
INSERT INTO tswNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","A̱vu Yesu damma yi, “Nu ukatalu u ɗa vaa wina Mawun ma Vuma?” ");
INSERT INTO tswNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ana aza a na a̱ ri zuzu na̱ a̱yi e enei ili i na yaa fara, reve a damma, “Zagbain, tsu gasa na̱ matsun me peꞌeni?” ");
INSERT INTO tswNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Reve nanza a̱tsuma̱ e le u gasa aagbashi a aabara a nan ganu, reve u koɗo yi utsuvu wu ukere usaꞌani. ");
INSERT INTO tswNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Reve Yesu damma, “She i da̱shi wan.” Reve u juꞌwa̱n yi utsuvuꞌu u ka̱mbuwa̱ yi gbaga. ");
INSERT INTO tswNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Reve Yesu damma nan ganu a gbagbain na azagbain a̱ a̱duga̱ri a̱ A̱a̱ꞌisamapaɗa na azagbain aza a na a̱ ta̱wa̱i adama a̱ yi, “Adama a̱ nye i ta̱wa̱i na̱ mutsun mu peꞌeni na̱ a̱kpa̱mkpa̱la̱, ana aza a na a zama vivu? ");
INSERT INTO tswNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","A mantsa ma na n da̱na̱i na̱ a̱ɗu a̱ A̱a̱ꞌisamapaɗa kuci, i reme mu shi. Gogo gba mantsa ma̱ ɗu ma ɗa, a na irumbu i ri a tsugbain.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Reve e reme Yesu, reve a tara yi a̱ ka̱ra̱ a̱ tyo o uꞌwa wa aabara a nan ganu. Reve Bituru kurusu alanga-alanga. ");
INSERT INTO tswNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ana a zuwai akina e memere mo uꞌwa, reve u da̱nu oɓolo ne ele. ");
INSERT INTO tswNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Reve aagbashi o usheli o ro e ene yi nden uba̱ta̱ we ekan a akina, a̱vu u vara yi esu. Reve u damma, “Vuma nda fo u shi ta̱ oɓolo na̱ a̱yi.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Reve u wasan u damma, “Ka nda, a̱mu n reve yi shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ana a jimai keꞌen, reve vuma ro e ene yi. A̱vu u damma, “A̱vu fo a̱tsuma̱ e ele a ɗa vu ri.” A̱vu Bituru damma, “Vuma nda, a̱mu ɗa shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ana a jimai u ta rawa zuzu na̱ rumu ta̱, reve waru za ro dammisa, “Ili i ro yi pe shi vuma nda fo u to oɓolo na̱ a̱yi, adama a na a̱yi za va̱ Ga̱lili ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","A̱vu Bituru damma, “Vuma nda, n reve ili i na vaa dansa shi.” A̱yi a̱tsuma̱ a adanshi ɗaɗa moton ma saalashi. ");
INSERT INTO tswNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Reve Zagbain vadala u ka̱lyuwa̱ yi. A̱vu Bituru cuwan na adanshi a̱ yi, ana u damma niyi, “Kafu moton ma saala anaꞌan, vu ta wasan mu utaꞌatsu.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ɗaɗa wu uta̱i a̱vu u ɓosho na̱ mesun. ");
INSERT INTO tswNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Reve ama a na a̱ da̱na̱i e ipiri ya̱ Yesu a yuwaan yi ulamu, reve a lulapa yi. ");
INSERT INTO tswNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Reve waru a pala yi esu, reve e ece yi, “Damma tsu ili i na yaa fara! Zane ɗa lapa nuwu?” ");
INSERT INTO tswNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Reve waru a yuwan adanshi a vama na̱ a̱bunda̱ a aciya̱yi. ");
INSERT INTO tswNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ana usana u tawai, reve azagbain a nan ganu a gbagbain na̱ munlu n Wila̱ na Azagbain a Mbara† o ɓoloto. Reve a tara yi a̱ tyo o ukobu u tsugbain, reve a damma, ");
INSERT INTO tswNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Na̱ a̱vu ɗa Kristiꞌi, damma tsu.” A̱vu u damma le, “Na̱ n damma ɗu, ya̱a̱ usu shi, ");
INSERT INTO tswNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","waru na̱ n yuwan ɗu yeci, ya̱a̱ usu shi. ");
INSERT INTO tswNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ɗe elime, Mawun ma Vuma† ma̱a̱ ta̱ da̱nu o ukere usaꞌani u Mogono ma̱ A̱sulazuva.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Reve suru nle a damma, “A̱vu Mawun ma̱ A̱sula̱ ma ɗa?” A̱vu u damma le, “Cine i dammai, ne ɗaɗa.” ");
INSERT INTO tswNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Reve a damma, “Nye waru tsu cigai i na i laꞌai nda? Tsu uwwa ta̱ na aciya̱tsu o una̱ wa̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","A̱vu oɓoloꞌo suru a̱ ꞌyon a tara yi a̱ tyo ya Bilatu† Gwamna vuma va̱ Roma. ");
INSERT INTO tswNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","A̱vu e reme adanshi a̱ yi ana, “Tsu reme ta̱ vuma nda a̱ lungususa̱ ama a̱ tsu. U ta putsusaa le a na aa tsupa utafa a̱ tyo ya̱ Kaisa wan. U ta dansa, a na a̱yi ɗa Kristi Zamawawa, mogono.” ");
INSERT INTO tswNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","A̱vu Bilatu ece yi, “A̱vu ɗaɗa mogono ma aza a Israꞌilaꞌa?” A̱vu Yesu usu, “Ununa vu dammai ne ɗa u ri.” ");
INSERT INTO tswNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","A̱vu Bilatu damma nan ganu a gbagbain no oɓoloꞌo, “N reme yi nu unusu shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Reve a uwa a dansaa yi, “U ta̱ ꞌya̱sa̱sa̱n okolo a ama, u to ritosu e iɗa ya Yahuda suru, diga Ga̱lili a̱ ta̱wa̱ pa.” ");
INSERT INTO tswNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ana Bilatu uwwai ne, a̱vu we ece ko vumaꞌa za va̱ Ga̱lili ɗa. ");
INSERT INTO tswNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ana wu uwwai u tu upasu u na Hiridu† Antiba aa yuwusan tsugono, reve u zuwa a̱ tyowetyo yi ya̱ Hiridu. A̱yi fo Urishelima ɗa u shi a mantsaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ana Hiridu enei Yesu, reve u za̱nga̱na̱ adama a na u jima ta̱ e izami we ene yi. Wu uwwusa ta̱ alabari a̱ yi, waru u ciga ta̱ we ene ili ya asalama i na Yesu aa yuwan. ");
INSERT INTO tswNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Reve u yuwan Yesu yeci ya̱ a̱bunda̱, agba u usu yi ili shi. ");
INSERT INTO tswNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","A̱vu nan ganu a gbagbain na̱ munlu n Wila̱ e isawan lo a̱ ta̱wusa̱a̱ na adanshi a vama adama a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Reve Hiridu na̱ a̱soja a̱ yi a yuwaan yi ili i na i lobonoi shi ko keꞌen, waru reve a yuwaan yi ulamu. Ana o oto niyi a̱tugu a gbagbain, ɗaɗa a̱ ka̱mba̱to niyi ya Bilatu. ");
INSERT INTO tswNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","O urana u ndolo u ɗa Hiridu na̱ Bilatu o oꞌwoi a̱ a̱sa̱la̱, agba ɗe a̱ca̱pa̱ a̱ shi a tsu dasalai ululu shi. ");
INSERT INTO tswNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Reve Bilatu ɓoloto nan ganu a gbagbain na azagbain na ama, ");
INSERT INTO tswNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","a̱vu u damma le, “I ta̱wa̱a̱ mu ta̱ na̱ vuma nda, ana u ta̱ ꞌya̱sa̱sa̱n okolo a ama, n ka̱lyuwa̱ yi ta̱ elime a̱ ɗu suru, agba n tsura̱ yi nu unusu u na i dammai shi. ");
INSERT INTO tswNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hiridu tsura̱ yi nu unusu fo shi, a̱vu u lyungu yi a̱ ka̱mba̱ ya̱ꞌa̱ tsu. Vuma nda yuwan ili i na oo una yi shi. ");
INSERT INTO tswNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","N ta fufaba yi, a̱vu n lyawa yi u ka̱ra̱.”  ");
INSERT INTO tswNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","A yashi ya̱ A̱buki a Mapasa u tsu lyawaa le ta̱ vuma ta̱ a̱tsuma̱ o uꞌwa wa ali. ");
INSERT INTO tswNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","A̱vu oɓoloꞌo suru a saala una̱ta̱, “Una niyi! A̱vu i lyawaa tsu Baraba!” ");
INSERT INTO tswNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(A zuwa ta̱ Baraba o uꞌwa wa ali, adama a̱ nla̱ngi a̱tsuma̱ a̱ lyuci, na ama a na wu unai.) ");
INSERT INTO tswNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bilatu shi ta̱ ciga lyawa Yesu, ɗaɗa u cayi amaꞌa adanshi waru. ");
INSERT INTO tswNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Agba a lyuwa ta̱ elime na̱ yisaali, “Vara niyi! Vara niyi!” ");
INSERT INTO tswNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","U yuwisaan le ta̱ adanshi, udammu wa taꞌatsu, “Adama a̱ nye? Unusu u ne u ɗa u yuwain? Me ene ili i na u yuwain ana oo una yi shi! N ta fufaba yi a̱vu n lyawa yi u ka̱ra̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","A̱vu a lyuwa elime na̱ yisaali ya̱ a̱bunda̱, a na a vara yi a akpata. A̱vu yisaali i le i lyuwa. ");
INSERT INTO tswNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Reve Bilatu ca le Yesu ununa a patiyi. ");
INSERT INTO tswNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","U lyawa ta̱ vuma na ele a cigai, za na a̱ shi a zuwai o uꞌwa wa ali, adama a̱ nla̱ngi, na ama a na wu unai. A̱vu u ca le Yesu a yuwan ununa a cigai. ");
INSERT INTO tswNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ele a̱tsuma̱ a mmalu na̱ Yesu, a̱vu a tara vuma ro, za na ri na aala Simo vuma va Kurani, a̱yi a̱ ma̱ta̱wa̱a̱ a̱ ma̱lyuci. A̱vu a tanu yi akpataꞌa,† a̱vu u tanu u toni Yesu. ");
INSERT INTO tswNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ama na̱ a̱bunda̱ o toni ta̱, oɓolo na̱ a̱ma̱ci a na a yuwain mesun na̱ a̱tsumola̱ngu adama a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","A̱vu Yesu vadala u damma le, “A̱ma̱ci a̱ Urishelima, she i shon adama a̱ va̱ wan. I shon adama a̱ ɗu na̱ muwun n ɗu. ");
INSERT INTO tswNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mantsa mo ta̱ lo a̱ ta̱wa̱ a na yaa damma, ‘A̱ma̱ci a na a matsain muwun shi, aza a na koto a apai maani me le shi aza a abaꞌun a ɗa.’ ");
INSERT INTO tswNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","A̱vu ‘a damma nsasan, “Riya̱a̱ tsu!” A̱vu waru a damma agaɗi o soko le.’ ");
INSERT INTO tswNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ni ili i ndolo i fara nu uɗanga wu uta̱nu, cine wa̱a̱ da̱na̱ nu u ꞌyewe?” ");
INSERT INTO tswNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","A̱vu waru ama e re a̱za̱ o unusu, a tara le ta̱ tsa̱ra̱ a̱ ꞌya̱wa̱ o una le oɓolo na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ana a rawai uba̱ta̱ u na a̱ tsu ɗe Ookoluwo, lo ɗa a vara niyi, na̱ a̱za̱ o unusu o ndolo, za ta̱ o ukere wu usaꞌani, za ta̱ o ukere wu ugula̱. ");
INSERT INTO tswNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","A̱vu Yesu damma, “Dada, vu yuwaan le gafura, adama a na e revei ili i na aa yuwusan shi.” A̱vu e neꞌeshen itana ya̱ yi na̱ mazuwa ma agita. ");
INSERT INTO tswNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","A̱vu ama e isawan e reme a̱ka̱nla̱. A̱vu azagbain a yuwaan yi ulamu, adansa, “U wawa ta̱ ozo o ro, u wawa aciya̱yi woꞌo, na̱ a̱yi ɗa Kristi Zamawawa† va̱ A̱sula̱ Ɗangwiꞌi.” ");
INSERT INTO tswNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","A̱soja a yuwaan yi ta̱ ulamu. A̱vu a rawa zuzu a canana yi mini ma alamu, ");
INSERT INTO tswNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","adansa, “Na̱ a̱vu ɗa mogono ma aza a Israꞌila, wawa aciya̱wu!” ");
INSERT INTO tswNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Zuva va̱ a̱yi, a̱vu a ɗana ɗe, A̱yi nda a̱yi ɗa mogono ma aza a Israꞌila. ");
INSERT INTO tswNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","A̱vu vuma ta̱ a̱tsuma̱ a aza a na a varai a akpataꞌa, u yuwaan Yesu ulamu ana, “A̱vu ɗaɗa Kristi Zamawawaꞌa shi? Wawa aciya̱wu oɓolo na̱ a̱tsu woꞌo.” ");
INSERT INTO tswNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","A̱vu vivu ve ire yuwaan yi nla̱ngi, u damma, “Vaa uwwusa wovon wa̱ A̱sula̱ shi, ana wo oꞌwoi ugeꞌetosu wa̱ wu una̱ta̱ u ɗa u ri na̱ za va̱ yi shi? ");
INSERT INTO tswNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","A̱tsu wu ntsaa tsu ta̱, tsu tsura̱ ta̱ atsupu o ulinga a̱ tsu, agba vuma nda u yuwan unusu u ro shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Reve u damma, “Yesu, cuwan na̱ a̱mu, na̱ vu uwa o tsugono tsa̱ wu.” ");
INSERT INTO tswNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Reve u usu yi, “Amayun a ɗa maa dansaa wu, anaꞌan vu ta̱ da̱na̱ oɓolo na̱ a̱mu o uꞌwa u wivuwun.”† ");
INSERT INTO tswNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ana urana u rawai aci, a̱vu irumbu i ɓa̱ru iɗaꞌa ma̱ɓula̱ a̱ tyo rumu taꞌatsu vu ulivu. ");
INSERT INTO tswNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","A̱vu urana u lyawa a casu ekan. Reve umuna wa̱ A̱a̱ꞌisamapaɗa u karalai ure. ");
INSERT INTO tswNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","A̱vu Yesu uta̱a̱ uɗyo, adansa, “Dada, n zuwa ta̱ wuma u va̱ e ekere a̱ wu.” Ana u dammai ne, a̱vu u rono wivuwun wu ukosu. ");
INSERT INTO tswNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ana yali ye enei ili i na i farai, a̱vu u ciɓala A̱sula̱ adansa, “Amayun vuma nda u ri nu unusu shi!” ");
INSERT INTO tswNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ana amaꞌa suru aza a na a̱ ta̱wa̱i e enei ili i na i farai, a̱vu a̱ ka̱mba̱ a ꞌwa suru, o koruso aci e le na̱ a̱tsumola̱ngu. ");
INSERT INTO tswNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Suru aza a na e reve niyi, oɓolo na̱ a̱ma̱ci a na o toni niyi diga ɗe Ga̱lili, e isawan ta̱ alanga a̱ ka̱lyuwusa̱ ili i na yaa farasa. ");
INSERT INTO tswNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","A yuwan ta̱ vuma na a̱ tsu ɗe Isuhu, u ta̱ pe a̱tsuma̱ a Azagbain a Mbara,† vuma va̱ a̱ɓula̱ a ɗa na̱ vuma saꞌani. ");
INSERT INTO tswNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","U shi u usu a̱sa̱la̱ e le, ni ili i na a yuwain shi. Wu uta̱ ta̱ a̱ lyuci va Arimatiya a̱tsuma̱ a Yahuda. U ta pura tsugono tsa̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ana Yesu kuwa̱i, a̱vu u ꞌya̱wa̱ ya Bilatu u pati a ca yi lipu va̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","A̱vu u cipa̱to yi e iɗa, ɗaɗa u katala niyi no okoro. A̱vu u zuwa yi a aason a na a̱ ka̱pa̱i a aatali a gbain, za na koto a zuwai pe a̱kwa̱kwa̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Urana u na a yuwusain Ifoɓi i ɗa, ana urana wa Ashibi u yuwain zuzu. ");
INSERT INTO tswNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","A̱ma̱ci a na a̱ ta̱wa̱i oɓolo na̱ a̱yi diga ɗe e iɗa ya̱ Ga̱lili, reve o toni a̱ca̱pa̱, a̱vu a̱ ka̱lyuwa̱ aasoꞌon nu ununa a zuwai lipuꞌu. ");
INSERT INTO tswNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","A̱vu a̱ ka̱mba̱ o uꞌwa o foɓo itana i ma̱guru† na̱ maniꞌin mo usukumu. Reve e ivuwan urana wa Ashibi† ununa Wila̱ u damma nle. ");
INSERT INTO tswNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Na̱ wasasa wa Aladi, reve a̱ma̱ciꞌi a̱ ka̱ra̱ a̱ ꞌya̱wa̱ a aasoꞌon, na̱ maniꞌin ma̱ ma̱guru ma na o foɓoi. ");
INSERT INTO tswNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Reve a cina cina a gandaluwa aatali a gbain o una̱ntsutsu wa aasoꞌon. ");
INSERT INTO tswNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ana a uwai pe, a cina pe lipu vu Zagbain Yesu shi. ");
INSERT INTO tswNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ele a̱tsuma̱ a asalama e ili i ndolo, ɗaɗa e enei ama e re zuzu ne ele ni itana i uri puwu. ");
INSERT INTO tswNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Adama o wovon, reve a̱ma̱ciꞌi a̱ ka̱ɗa̱to esu e le e iɗa. A̱vu amaꞌa a damma le, “Cine i ri e izami yi za wuma a̱tsuma̱ a̱ a̱kwa̱kwa̱? ");
INSERT INTO tswNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wu pa shi, u ꞌyon ta̱! I cuwan ili i na u damma nɗu a̱yi ɗe Ga̱lili, ");
INSERT INTO tswNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ana, ‘Ciga ꞌyuwan a ta ca Mawun ma Vuma e ekere a̱ a̱za̱ e iwuya, a ta vara yi a akpata, o urana wa taꞌatsu a̱ ta̱ ꞌya̱sa̱n yi.’ ” ");
INSERT INTO tswNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Reve a cuwan na adanshi a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ana a̱ ka̱mba̱i, reve a damma ojoro kupa na̱ za ta̱ na akapi a na a buwai ili i na i farai suru. ");
INSERT INTO tswNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Meri Magadaliya na̱ Yuwana, na̱ Meri† mma va Yakubu, na akapi a̱ma̱ci a na a̱ da̱na̱i oɓolo, ele ɗa a dammai ajiya ili i ndolo suru. ");
INSERT INTO tswNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ajiyaꞌa a jiyan ta̱ gashi ili i na a̱ma̱ciꞌi a dammai tsulo tsa ɗa. Adama o ndolo a zuwaa le atsuvu shi. ");
INSERT INTO tswNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Amma gba Bituru ꞌyon ta̱, reve u suma a̱ tyo a aasoꞌon. U ka̱nza̱ ta̱ reve u ka̱lyuwa̱ pe, a̱vu we ene pe okoro. Babu pe ili i ro. Reve u ka̱mba̱ a majiyan ni ili i na i farai. ");
INSERT INTO tswNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","O urana u ndoloꞌo ama e re a̱ shi ta̱ a mmalu a̱ tyo a̱ ma̱lyuci ma na a̱ tsu ɗe Imawu. Alanga a̱ yi a̱ tyo Urishelima u ta rawa mili cindere. ");
INSERT INTO tswNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Reve a uwa adanshi e ili i na i farai. ");
INSERT INTO tswNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ele a̱tsuma̱ a adanshi na̱ majiyan ele ra, reve Yesu na aciya̱yi u rawa zuzu ne ele. Reve u uwa mmalu oɓolo ne ele. ");
INSERT INTO tswNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Agba a̱ kpa̱to le ta̱ esu a gura reve yi shi. ");
INSERT INTO tswNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Reve u damma le, “Adanshi a̱ nye yaa yuwusan a̱ɗu a̱tsuma̱ a mmalu?” Reve e isawan esu ulukutu. ");
INSERT INTO tswNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Reve vuma ta̱ za na a̱ tsu ɗe Kiliyoba usu yi, “A̱vu ɗa mocin a̱ ndeꞌen a̱tsuma̱ a̱ Urishelima za na koto uwwai ili i na i farai ɗe a yashi i nda shi?” ");
INSERT INTO tswNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Reve u damma le, “Ili i ne i ɗa?” A̱vu a damma yi, “Adama e Yesu za va Nazara, za na shi vumava̱sula̱ a yuwusan linga va asalama na̱ a̱tsuma̱ a adanshi e ekere a̱ A̱sula̱ na ama suru. ");
INSERT INTO tswNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Waru na̱ cine nan ganu a gbagbain na azagbain a zuwai o una yi, reve a vara yi a akpata.† ");
INSERT INTO tswNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Agba tsu shi ta̱ a zuwusa okolo a̱ tsu a̱yi ɗa waa tsupa† adama u wawa aza a Israꞌila. Ana a yuwain ili i nda suru, anaꞌan ɗa urana wa taꞌatsu. ");
INSERT INTO tswNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Waru ɗaɗa a̱ma̱ci o ro aza a na a̱ ri oɓolo na̱ a̱tsu a yuwaan ntsu ili ya asalama. A̱ shi ta̱ a̱ ꞌya̱wa̱ uba̱ta̱ wa aasoꞌon na̱ wasasa, ");
INSERT INTO tswNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","agba a cina pe lipu va̱ yi shi. Reve a̱ ta̱wa̱ a dansaa tsu, ana hali o roco le alavu-alavu a nlingata ma̱ A̱sula̱, aza a na a damma nle u ta̱ wuma. ");
INSERT INTO tswNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Reve ozo o ro a̱tsuma̱ a̱ tsu a̱ ꞌya̱wa̱ uba̱ta̱ wa aasoꞌon. A̱vu a cina ununa a̱ma̱ciꞌi a dammai, agba a̱yi aciya̱yi e ene yi shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Reve u damma le, “A̱ɗu ama o ulambu wu urevu, waru ozo o okolo o ugbamu a na a̱a̱ usu ili i na ama̱sula̱ suru a dammai. ");
INSERT INTO tswNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","A ꞌyuwan a ciga Kristiꞌi wu uwwa a̱tsuma̱lima̱ a nda suru adama u uwa o tsugbain tsa̱ yi shi?” ");
INSERT INTO tswNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ana u temei ya Musa a̱ tyo akapi a ama̱sula̱ suru, reve u cuɗuwa le Adanshi a̱ A̱sula̱ adama a aciya̱yi suru. ");
INSERT INTO tswNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ana a rawai ma̱lyuci ma na a̱a̱ ꞌya̱wa̱, reve u yuwan gashi u ta̱ ka̱ra̱ elime. ");
INSERT INTO tswNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","A̱vu a patishi yi lon, adansa, “Isawan va asa oɓolo na̱ a̱tsu, adama a na rumu ta̱li yuwan ta̱ zuzu. Waru urana u ɗa nda o mokotoo.” Reve wi isawan oɓolo ne ele. ");
INSERT INTO tswNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","A̱yi a alya e ilyalya oɓolo ne ele, reve u tara opopofu u zuwaa yi abaꞌun. A̱vu u bubusa yi u ca le. ");
INSERT INTO tswNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ɗaɗa esu e le a̱ kpa̱tuꞌwa̱i, reve e reve yi. A̱vu u puwa̱n le. ");
INSERT INTO tswNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Reve a dammulai, “Okolo a̱ tsu gba a̱ shi ta̱ a̱ da̱nu a mantsa ma na u yuwusain adanshi na̱ a̱tsu o ure ana u cuɗuwa ntsu Adanshi a̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Reve a̱ ꞌyoshin a̱ ka̱mba̱ Urishelima. Reve a cina ojoro kupa na̱ za ta̱ꞌa̱ uɓolotowu uba̱ta̱ u ta̱ na aza a na a̱ ri oɓolo ne ele. ");
INSERT INTO tswNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ele fo a̱vu a damma ama e reꞌe, “Amayun Zagbain ꞌyon ta̱, hali u ꞌya̱wa̱ ya̱ Simo!” ");
INSERT INTO tswNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Reve a damma ili i na i farai o ure, nu ununa e revei a̱yi ɗa a mantsa ma na u bubusai opopofu. ");
INSERT INTO tswNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ele a̱tsuma̱ a adanshi o ndolo, ɗaɗa Yesu na aciya̱yi u ta̱wa̱ wi isawan e memere me le. A̱vu u damma le, “A̱zoꞌwa! Asuvu nden a̱ da̱nu na̱ a̱ɗu.” ");
INSERT INTO tswNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Reve okolo e le a̱ ꞌyon, reve a uwwa wovon. A ta dansa yimoɗi i ɗa e enei. ");
INSERT INTO tswNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","A̱vu u damma le, “Adama a̱ nye okolo a̱ ɗu a̱ ꞌyoyin? Waru adama a̱ nye i kuɗai asuvu? ");
INSERT INTO tswNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ka̱lyuwa̱i ekere na ana a̱ va̱. A̱mu ɗa na aciya̱va̱. Juꞌwa̱in ye ene, adama a na yimoɗi i ri na̱ lipu ne etele ununa ye e nda n ri shi.” ");
INSERT INTO tswNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ana u dammai ne, reve u roco le ana ne ekere a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Adama a̱ ma̱za̱nga̱ na asalama a̱ shi a̱ usu shi. Reve u damma le, “I ta̱ pa ni ilyalya?” ");
INSERT INTO tswNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","A̱vu a ca yi abishi a magula mo uzatsuwu. ");
INSERT INTO tswNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Reve u ushi u tama e esu e le. ");
INSERT INTO tswNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Reve u damma le, “A̱yi ɗa ili i na n damma nɗu ana n shi oɓolo na̱ a̱ɗu ana n dammai: Ili i na a ɗanai adama a̱ va̱ a̱ Wila̱ wa Musa, na Ama̱sula̱, na Aatagada e Ica† suru a ta shiwan.” ");
INSERT INTO tswNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Reve u kpa̱tuꞌwa̱ okolo e le adama e reve Adanshi a̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Reve u damma le, “Ne ɗa u ri uɗanu: Ana u lobono ta̱ Kristi† Zamawawa sowo a̱tsuma̱lima̱, o urana wa taꞌatsu gba u ta̱ ꞌyon a̱tsuma̱ a̱ a̱kwa̱kwa̱. ");
INSERT INTO tswNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Waru a ta yuwaan ama suru alajiya a na aa vadala a̱ tsura̱ gafura a̱tsuma̱ a aala a̱ yi. E te teme Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Na aciya̱ɗu a ɗa yaa damma amayun e ili i na ye enei. ");
INSERT INTO tswNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","N ta̱ lyunguwa̱ ɗu Ruhu va Akiza, za na Dada va̱ yuwaan nɗu nzuwulai. Amma yi isawan a̱tsuma̱ a̱ Urishelima neꞌen, hali a ca ɗu ucira diga zuva.” ");
INSERT INTO tswNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Reve u tara le o uta̱ a̱tsuma̱ a̱ lyuci a̱ tyo Batanya. Reve u ꞌya̱sa̱n ekere a̱ yi zuva u zuwaa le abaꞌun. ");
INSERT INTO tswNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","A̱yi a zuwusaa le abaꞌun, ɗaɗa u ka̱ra̱ u lyawa nle, reve a tara yi a̱ tyo zuva. ");
INSERT INTO tswNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Reve a yuwaan yi a̱ga̱nda̱, ɗaɗa a̱ ka̱mba̱i Urishelima na̱ ma̱za̱nga̱ ma asuvu lon. ");
INSERT INTO tswNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Reve a yuwusaan A̱sula̱ ica a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗa kuci.");
INSERT INTO tswNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kafu a yuwan uvaɗi Danshi da̱na̱ ta̱ lo. Danshiꞌi u da̱na̱ ta̱ oɓolo na̱ A̱sula̱, Danshiꞌi una̱ta̱ u ɗa u ri na̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","U to oɓolo na̱ A̱sula̱ kafu ufaru wu uvaɗi. ");
INSERT INTO tswNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","A̱yi ɗa u yuwain ili suru. Babu ili i na i ri lo i na u yuwain shi. ");
INSERT INTO tswNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Danshiꞌi a̱yi ɗa ufaru u wuma, a̱vu wumaꞌa u ta̱wa̱a̱ ama ne ekan. ");
INSERT INTO tswNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Reve ekaꞌan e ikana a̱tsuma̱ e irumbu, agba irumbuꞌu i gura laꞌa yi ucira shi. ");
INSERT INTO tswNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Vuma ro da̱na̱ ta̱ lo za na a̱ tsu ɗe Yahaya,† za na A̱sula̱ a̱ lyunguyi tsa malingata ma̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","U ta̱wa̱ ta̱ u damma ama amayun e ekaꞌan, tsa̱ra̱ ama suru a ca okolo adama e ili i na u dammai. ");
INSERT INTO tswNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","A̱yi aciya̱yi a̱yi ɗa ekaꞌan shi, amma u ta̱wa̱ ta̱ tsa̱ra̱ u damma ama amayun e ekaꞌan. ");
INSERT INTO tswNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ekan a amayun a na a casu ama suru ekan a̱ ta̱ ta̱wa̱ o uvaɗi, waru u ta̱wa̱ ta̱ ɗe! ");
INSERT INTO tswNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Danshiꞌi u da̱na̱ ta̱ a̱tsuma̱ o uvaɗi waru A̱sula̱ a yuwan ta̱ ulinga na̱ a̱yi u yuwan uvaɗi, agba ama o uvaɗi e reve yi shi. ");
INSERT INTO tswNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","U ta̱wa̱ ta̱ a̱tsuma̱ e iɗa ya̱ yi agba ama a̱ yi a̱ usu yi shi. ");
INSERT INTO tswNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Amma ozo o ro a̱ usu yi ta̱, reve a ca okolo e le ya̱ꞌa̱ yi. Ɗaɗa u zuwa nle o oꞌwoi muwun ma̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Agba cine na nan dada le a matsan nle ɗa u zuwa nle o oꞌwoi muwun ma̱ A̱sula̱ shi. A̱sula̱ a ɗa na aciya̱yi u zuwa nle o oꞌwoi muwun ma̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Danshiꞌi u ka̱mba̱ ta̱ vaɗilima̱, reve u da̱nu a̱tsuma̱ a̱ tsu. U da̱na̱ ta̱ tapu ni isaꞌani na amayun. Tse ene ta̱ tsugbain tsa̱ yi tsa na u tsura̱i adama a na a̱yi ɗa Mawun ma Dada goon. ");
INSERT INTO tswNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yahaya yuwan ta̱ adanshi a amayun adama a̱ yi ana u dammai, “A̱yi nda a̱yi ɗa Za na n yuwaan nɗu adanshi adama a̱ yi: ‘Za na a matsain a̱ca̱pa̱ a̱ va̱ u laꞌa mu ta̱ tsugbain adama a na u ta̱ lo wuma, kafu a yuwan ekpeꞌwin a na a matsan mu.’ ” ");
INSERT INTO tswNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Adama e icigi ya̱ a̱ɓula̱ ya̱ yi e ekere a̱ tsu, ɗaɗa u zuwaa ntsu abaꞌun suru, waru u ta casu tsu abaꞌun kuci. ");
INSERT INTO tswNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ama a̱ ushi ta̱ Wila̱ e ekere a Musa, agba isaꞌani† na amayun e ekere e Yesu Kristi† Zamawawa ɗa o uta̱i. ");
INSERT INTO tswNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Babu za na enei ɗe A̱sula̱, she Mawun ma̱ ta̱ goon, za na ri una̱ta̱ na̱ A̱sula̱ waru u ri a muwwulai na̱ Dada. A̱yi ɗa goon u zuwai ama e revei cine A̱sula̱ a̱ ri. ");
INSERT INTO tswNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","A̱vu azagbain a aza a Israꞌila a̱tsuma̱ a̱ Urishelima a̱ lyungu nan ganu oɓolo na̱ nan Levi o ro a̱ ꞌya̱wa̱ e ece Yahaya za vu Urumbusu, “Zane ɗa gba a̱vu vu ri?” ");
INSERT INTO tswNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Agba u pala le shi, a̱vu u yuwan adanshi a alanga e eteshe, adansa, “A̱mu ɗa Kristi Zamawawaꞌa shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ɗaɗa e ece niyi, “Na̱ a̱vu ɗa Kristi Zamawawaꞌa shi, zane ɗa vu ri? A̱vu ɗa Iliya?” Reve u usu, “Oꞌo, a̱mu ɗa shi.” A̱vu e ecishe yi, “A̱vu Vumava̱sula̱† ro ɗa la̱nga̱?” A̱vu u usu, “Oꞌo, a̱mu ɗa shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Reve a damma yi, “To zane ɗa vu ri? Damma tsu tsa̱ra̱ tsu reve ili i na tsaa damma aza a na a̱ lyungu ntsu. Zane ɗa gba vaa tarasa aciya̱wu?” ");
INSERT INTO tswNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Reve u ka̱mbuwa̱ le ni idanshi ya Ishaya vumava̱sula̱: “A̱mu ɗa uɗyo wu nanza e ɗewu a̱tsuma̱ o una, adansa, ‘I foɓoo Zagbain ure u saꞌani, za na ri lo a̱ ta̱wa̱.’ ” ");
INSERT INTO tswNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Afarishi† a ɗa aza a na a̱ lyunguyi ama o ndolo. ");
INSERT INTO tswNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","A̱vu e ece, “Na̱ a̱vu ɗa Kristi Zamawawaꞌa shi, ko Iliya, ko Vumava̱sula̱ ro la̱nga̱ shi, to, cine vaa yuwusan urumbusu tsunda?” ");
INSERT INTO tswNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ɗaɗa Yahaya damma nle, “N tsu rumbu† ta̱ na̱ mini, amma gogo a̱tsuma̱ o oɓolo a nda, vuma ro ta̱ pa a na i revei shi. ");
INSERT INTO tswNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","A̱yi ɗa u ta̱wa̱i a̱ca̱pa̱ a̱ va̱. N rawa m ba̱ɗa̱ vunu va atan va̱ yi shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yahaya rumbusu ta̱ ama a̱ lyuci va Batanya za na ri asana a̱ mɓa̱nga̱ mu Uɗolu wa̱ Urdu ana ili i nda i farai suru. ");
INSERT INTO tswNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ana usana u tawai, a̱vu Yahaya ene Yesu† a̱ ta̱wa̱ uba̱ta̱ u na u ri. Reve u damma, “Apa Ma̱giriꞌi ma̱ A̱sula̱† ma na A̱sula̱ a yuwain ulinga na̱ a̱yi na u yuwayin ama o uvaɗi gafura vu nusu le. ");
INSERT INTO tswNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Vuma na n yuwusain adanshi a aci a̱ yi a ɗaɗa nda ana n dammai, ‘Za na a matsain a̱ca̱pa̱ a̱ va̱ u laꞌa mu ta̱ tsugbain, adama a na u ta̱ lo wuma kafu a yuwan ekpeꞌwin a na a matsan mu.’ ");
INSERT INTO tswNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","N reve ko a̱yi ɗa shi, amma n yuwusan ta̱ urumbusu na̱ mini, tsa̱ra̱ n zuwa ama a Israꞌila e reve ko zane ɗa u ri.” ");
INSERT INTO tswNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Reve Yahaya damma, “Me ene ta̱ Ruhu cipa̱i diga zuva oroci a muɗa a̱vu u telee yi. ");
INSERT INTO tswNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","N shi n reve ko na a̱yi ɗa shi, amma ana A̱sula̱ a̱ lyungu numu n rumbusu na̱ mini, u damma mu ta̱, ‘Na̱ ve ene Ruhu va Akiza a̱ cipusa̱ reve u telee vuma ro, vuma na yaa zama ɗaɗa ndolo. A̱yi ɗa za na tsu rumbu na̱ Ruhu va Akiza.’† ");
INSERT INTO tswNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Me ene ta̱ ana ili i nda i farai na̱ Yesu. Adama o ndolo n ta dansaa ɗu amayun a na a̱yi ɗaɗa Mawun ma̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ana usana u tawai, Yahaya da̱na̱ ta̱ ɗe oɓolo no ojoro† e re a̱ yi a yuwusan urumbusu. ");
INSERT INTO tswNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ana we enei Yesu a mmalu, reve u damma, “Apa Ma̱giriꞌi ma̱ A̱sula̱!”† ");
INSERT INTO tswNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ojoroꞌo a uwwa ta̱ ana Yahaya dammai ne, ɗaɗa o toniyi Yesu. ");
INSERT INTO tswNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ana u vadalai a̱vu we ene le o tonishi yi, ɗaɗa we ece nle, “Nye ɗa i ri e izami?” Reve a̱ usu, “Rabbi,† te ɗa vu ri na̱ nden?” (“Rabbi” urevu wa̱ yi a̱yi ɗa “Manlu.”) ");
INSERT INTO tswNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Reve u usu, “Ta̱wa̱i ye ene.” (A mantsa ma̱ rumu na̱shi vu ulivu ɗa.) Reve o toni e ene uba̱ta̱ꞌa̱, reve a̱ da̱nu oɓolo hali urana u koto. ");
INSERT INTO tswNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Vuma ta̱ a̱tsuma̱ o ojoroꞌo a̱yi ɗa Andarawu mawun ma̱ a̱na̱wu ma̱ Simo Bituru. ");
INSERT INTO tswNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ili i na Andarawu fara yuwain a̱yi ɗa u zami ta̱ mawun ma̱ a̱na̱wu ma̱ yi Simo, a̱vu u damma yi, “Tse ene ta̱ Zamawawa† na a yuwaan ntsu nzuwulaiꞌi!” (Na̱ Tsuyahuda† a yuwan ta̱ ulinga na̱ “Zamawawa” waru una̱ta̱ u ɗa u ri na̱ Tsuheleni† “Kristi.”) ");
INSERT INTO tswNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","A̱vu Andarawu tara yi a̱ tyo uba̱ta̱ u na Yesu ri. Ana Yesu ka̱lyuwa̱ niyi a̱vu u damma, “A̱vu ɗa Simo, aala a dada va̱ wu a ɗa Yahaya.† A̱ ta̱ ɗe wu Kefa.” (A̱yi “Kefa” ili i ta̱ i ɗa na̱ “Bituru.”) ");
INSERT INTO tswNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ana usana u tawisai, reve Yesu jiyan u ka̱ra̱ a̱ tyo Ga̱lili. Ana we enei Filibu, a̱vu u damma yi, “Toni mu.” ");
INSERT INTO tswNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Besaida lyuci na Filibu uta̱i ɗa, waru lyuci va Andarawu na̱ Bituru ɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ana Filibu ꞌya̱wa̱ cinai Nataniya a̱vu u damma yi, “Tse ene ta̱ vuma na Musa ɗanai adama a̱ yi a̱tsuma̱ a̱ Wila̱. Waru ama̱sula̱ a ɗana ta̱ adama a̱ yi. A̱yi ɗa Yesu ulobo wa̱ Isuhu, waru Nazara ɗa lyuci va̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Amma Nataniya damma ta̱ Filibu, “A̱ ta̱ tsura̱ ili i saꞌani a̱ lyuci va Nazara?” Reve u usu, “Ta̱wa̱ ve ene.” ");
INSERT INTO tswNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ana Yesu enei Nataniya a̱ ta̱wa̱ yi, reve u damma, “Apa ugundo wa amayun a nkaya n tsu aza a Israꞌila.† A̱yi za yipaalishi i ɗa shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","A̱vu Nataniya ece yi, “Cine tsa ɗa vu reve numu?” A̱vu u usu yi, “Me ene wu ta̱ nden e ikyun yu ubiri, kafu Filibu ɗe wu.” ");
INSERT INTO tswNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ɗaɗa Nataniya usu niyi, “Manlu, a̱vu ɗaɗa Mawun ma̱ A̱sula̱. A̱vu ɗa Mogono ma aza a Israꞌila.” ");
INSERT INTO tswNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Reve we ece yi, “Vu usu mu ta̱ adama a na n dammai me ene wu ta̱ e ikyun yu ubiri? Vu te ene ili i gbagbain i na i laꞌai nda.” ");
INSERT INTO tswNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ɗaɗa Yesu damma nle, “Amayun a ɗa maa dansaa ɗu, i te ene zuva ukpa̱tuꞌu, a̱vu waru nlingata ma̱ A̱sula̱ n da̱na̱ a̱ ꞌya̱wusa̱ na̱ a̱ cipi e ekere a Mawun ma Vuma.”† ");
INSERT INTO tswNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","O urana wa taꞌatsu, a̱vu a yuwan a̱buki o lolo a̱ lyuci va Kana a̱tsuma̱ a̱ Ga̱lili. Mma va̱ Yesu da̱na̱ ta̱ pe. ");
INSERT INTO tswNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","A banu ta̱ Yesu oɓolo no ojoro a̱ yi fo. ");
INSERT INTO tswNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ana masayan ma inabi† mo kotoi, ɗaɗa mma va̱ yi tsu damma yi, “Masayan mo koto ta̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Reve Yesu usu, “Mma, nye i ɗa i bura numu na adanshi a nda? Mantsa ma̱ va̱ mo koto ma yuwan na maa yuwan ili i nda shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Reve mma va̱ yi damma agbashi, “I yuwan ili i na u damma nɗu i yuwan suru.” ");
INSERT INTO tswNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nu ufaru, A̱sula̱ a ca ta̱ aza a Israꞌila wila̱ cine a̱a̱ da̱na̱ a yuwusan wuza̱ꞌu. Adama o ndolo ama o uꞌwaꞌa a̱ da̱na̱ ta̱ na araꞌatsu a̱ mini a̱ ta̱li, aza a na e sheꞌein na atali. Uraꞌatsu suru u tsu gura ta̱ tara ndele m mini ushin a̱ tyo mataꞌatsu. ");
INSERT INTO tswNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","A̱vu Yesu damma agbashiꞌi, “Shitoyin araꞌatsuꞌu na̱ mini.” Ɗaɗa o shitoyin le tapu hali a̱ tyo o una̱. ");
INSERT INTO tswNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ɗaɗa u damma nle, “Gogo kenei waꞌa, reve i ca zagbain va̱ a̱bukiꞌi.” Reve gba a yuwan ne. ");
INSERT INTO tswNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ana u peɗei, miniꞌi u ka̱mba̱ ta̱ ɗe masayan ma inabi. U reve uba̱ta̱ u na masayaꞌan wu uta̱i shi, amma agbashi a na a̱ ta̱wa̱yi na̱ miniꞌi e reve ta̱. Ɗaɗa u ɗeyi vali vu kasaꞌavuꞌu, ");
INSERT INTO tswNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","reve u damma yi, “O ufaru wa̱ a̱buki o lolo ama a tsu fara ta̱ neꞌeshen masayan ma na ma laꞌai uyoꞌo. A̱ tyo ɗe no o sowo masayan lon, a̱vu e neꞌeshen za na rawai a̱yi ndolo uyoꞌo shi. Agba a̱vu vu soko ta̱ masayan ma na ma laꞌai uyoꞌo hali a̱ tyo gogo.” ");
INSERT INTO tswNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Adama o ndolo a̱tsuma̱ a Kana va̱ Ga̱lili ɗa Yesu fara yuwain ulinga wi iroci ya asalama† yu ufaru. Lo ɗa u rocoi tsugbain tsa̱ yi, reve gba ojoro a̱ yi a̱ usu yi. ");
INSERT INTO tswNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ana a̱yi ndolo kotoi, a̱vu u ka̱ra̱ a̱ tyo a̱ lyuci va Kafarnahum oɓolo na̱ mma va̱ yi, na̱ a̱za̱ a̱ yi, oɓolo no ojoro a̱ yi. A̱ da̱nu ta̱ ɗe rana meketeci. ");
INSERT INTO tswNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","A̱vu Yesu ka̱ra̱ a̱ tyo Urishelima adama a na mantsa ma̱ A̱buki a Mapasa ma yuwan ta̱ zuzu. ");
INSERT INTO tswNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ana u ꞌya̱wa̱i a̱ A̱a̱ꞌisamapaɗa, a̱vu u cina ama a winasa inan, ni ikyon, oɓolo na̱ nrukuku. We ene ta̱ waru ozo o ro o otogu a kitaꞌusa ikebe icuꞌun icuꞌun. ");
INSERT INTO tswNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","A̱vu u kene amunga reve u munga aasuɗu. Ɗaɗa u loyi amaꞌa suru a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗaꞌa, oɓolo ni ikyon ni inan i le. A̱vu wu keɓe apada a aza a na a̱ ri a kitaꞌusa ikebeꞌe, reve u baza ikebe i le. ");
INSERT INTO tswNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","A̱vu u damma aza a na a winasa nrukuku, “Tawai ili i nda uba̱ta̱ u nda! She i ka̱mba̱to uꞌwa wa Dada va̱ wo oꞌwo eden wan.” ");
INSERT INTO tswNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ana ili i nda i farai, reve ojoro a̱ yi a cuwan ni ili i na i ri uɗanu ɗe nu ujimu a̱tsuma̱ a Adanshi a̱ A̱sula̱:† “Icigi yu uꞌwa ya̱ wu i to una mu.” ");
INSERT INTO tswNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Reve azagbain a aza a Israꞌila e ece yi, “Cuꞌun vi ili ya asalama i ne i ɗa vaa yuwan, tsa̱ra̱ vu roco tsu uba̱ta̱ u na vu tsura̱i ucira u na vu yuwain ili i nda?” ");
INSERT INTO tswNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","A̱vu u usu le, “Lungusa̱i uꞌwa wa̱ A̱sula̱ u nda, waru n ta suwisa yi a̱tsuma̱ a rana taꞌatsu.” ");
INSERT INTO tswNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Reve a̱ usu, “Ana a farai usaa wa̱ A̱a̱ꞌisamapaɗa† a nda, u ka̱ra̱ ta̱ aꞌwan amunga na̱ a̱za̱ a̱ ta̱li kafu o koto yi. Cine tsa ɗa vaa gura suwisa yi a̱tsuma̱ a rana taꞌatsu?” ");
INSERT INTO tswNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Amma ana Yesu yuwain adanshi o “uꞌwaꞌa,” lipu va̱ yi ɗa u da̱na̱i a yuwusan adanshi. ");
INSERT INTO tswNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ana a̱ ꞌya̱sa̱n niyi a̱tsuma̱ a̱ a̱kwa̱kwa̱, ojoro a̱ yi a cuwan ta̱ ana u dammai tsundolo. Ɗaɗa a̱ usuyi Yesu na Adanshi a̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ana Yesu da̱na̱i pe a̱tsuma̱ a̱ Urishelima adama a̱ A̱buki a Mapasa, ama na̱ a̱bunda̱ a̱ usu yi ta̱ adama a na e enei iroci yi ili ya asalama i na u yuwusain. ");
INSERT INTO tswNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yesu gba u reve ta̱ majiyan ma na ma̱ ri pe a̱tsuma̱ o okolo e le suru, agba u lyawa le a ɗangwaa yi ili i na waa yuwan shi. ");
INSERT INTO tswNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ko vuma aa damma yi majiyan ma ama shi, adama a na a̱yi na aciya̱yi u reve ta̱ majiyan me le. ");
INSERT INTO tswNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","A̱tsuma̱ a Azagbain a Mbara,† vuma ro da̱na̱ ta̱ pe za na a̱ tsu ɗe Nikodimu, a̱yi Mafarishi ma ɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","U ꞌya̱wa̱ ta̱ uba̱ta̱ wa̱ Yesu na ayin, a̱vu u damma, “Zagbain, tsu reve ta̱ A̱sula̱ a̱ lyungu wu ta̱ uba̱ta̱ u tsu adama vu rito tsu. Babu za na aa gura yuwan iroci yu ulinga ya asalama i na vaa yuwusan, she na̱ A̱sula̱ a̱ ri oɓolo na̱ a̱yi.” ");
INSERT INTO tswNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Reve u usu, “Amayun a ɗa maa dansaa wu, babu za na aa uwa o tsugono tsa̱ A̱sula̱† she na a matsan yi ure.” ");
INSERT INTO tswNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","A̱vu Nikodimu damma, “Amma na̱ vuma o oꞌwo ɗe aabara, cine aa gura matsisan yi? Waa uwisa a̱a̱tsuma̱ a mma va̱ yi waru shi. Cine aa yuwan a̱vu a matsisan vuma we ire?” ");
INSERT INTO tswNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Reve u usu, “Amayun a ɗa maa dansaa wu, babu za na aa gura uwa a̱tsuma̱ o tsugono tsa̱ A̱sula̱, she na a matsisan yi umatsun we ire na̱ mini na̱ Ruhu. ");
INSERT INTO tswNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ili i na vaɗilima̱ matsain vaɗilima̱ ɗa, amma ili i na a matsain a̱tsuma̱ a̱ Ruhu, Ruhu ɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","She vu yuwan asalama wan a na n damma nuwu, ‘Ni i ꞌyuwan i ciga a̱a̱ da̱shi matsisan ɗu.’ ");
INSERT INTO tswNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Upepu u tsu toni ta̱ uba̱ta̱ u na u cigai, waru vu tsu uwwa ta̱ ilama ya̱ yi, agba vu reve uba̱ta̱ u na wu uta̱i shi, agba vee reve uba̱ta̱ u na wee tyo shi. Ne ɗa u ri na̱ vuma na Ruhu matsain.” ");
INSERT INTO tswNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Reve Nikodimu ece, “Cine ili i ndolo yaa fara?” ");
INSERT INTO tswNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ɗaɗa u usu niyi, “A̱vu manlu ma gbain ma ɗa vu ri a̱tsuma̱ a Israꞌila. Nye i zuwai vu kuɗa̱i e reve ili i nda? ");
INSERT INTO tswNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","N damma wu amayun, tsu yuwan ta̱ adanshi e ili i na tsu revei, waru tsu damma ta̱ ili i na tse enei ne esu a̱ tsu, na̱ ne suru i usu ili i na tsu damma nɗu shi. ");
INSERT INTO tswNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","N damma ɗu ta̱ adama e ili yu uvaɗi suru, agba i usu shi. Adama o ndolo ya̱a̱ usu shi, ko na̱ n yuwaan ɗu adanshi e ili i na i ri ɗe zuva. ");
INSERT INTO tswNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","A̱mu ɗa Mawun ma Vuma,† za na uta̱i zuva goon, agba ko za koto ꞌya̱wa̱ ɗe shi. ");
INSERT INTO tswNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Cine Musa† ꞌya̱sa̱in yo vu rumushili a̱tsuma̱ o una, ne ɗa fo a ciga a ꞌyuwan a̱a̱ ꞌya̱sa̱n Mawun ma Vuma, ");
INSERT INTO tswNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tsa̱ra̱ za na ushi niyi no okolo a̱ ta̱ u tsura̱ wuma u babu ukotu. ");
INSERT INTO tswNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Adama e icigi i na A̱sula̱ a yuwayin uvaɗi, ɗaɗa u cayi Mawun ma̱ ta̱ ma̱ yi goon, adama a za na ushi niyi suru u kuwa̱ wan, agba u tsura̱ wuma u babu ukotu. ");
INSERT INTO tswNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","A̱sula̱ a̱ lyungu Mawun ma̱ yi a̱tsuma̱ o uvaɗi tsa̱ra̱ u kototo ama shi. Amma u lyungu yi ta̱ adama u wawa ama. ");
INSERT INTO tswNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Aa yuwaan aza a na a̱ ushiyi Mawuꞌun ugeꞌetosu shi. Amma a yuwaan ta̱ ɗe aza a na a̱ ushi niyi shi ugeꞌetosu, adama a na a zuwai okolo e le e ekere a Mawun ma̱ ta̱ ma̱ A̱sula̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Apa ili i na i zuwai ugeꞌetosu u ri lo adama e le: Ekan a̱ ta̱wa̱ ta̱ a̱tsuma̱ o uvaɗi, agba a ciga yi shi. Irumbu i ɗa a cigai, adama a na linga le iwuya i ɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Aza a na a yuwusan iwuya a ꞌyuwan ta̱ ekan, waru a ciga a rawa uba̱ta̱ we ekaꞌan shi, adama a na a ciga vuma reve iwuya i na aa yuwusan shi. ");
INSERT INTO tswNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Aza a na a yuwusan wuma wa̱ a̱ɓula̱ a̱ tsu ta̱wa̱ ta̱ uba̱ta̱ e ekan, ama suru a̱ tsu reve ta̱ a na a yuwusan ili i na A̱sula̱ a cigai.” ");
INSERT INTO tswNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ana o kotoi ili i ndolo, reve Yesu no ojoro a̱ yi a̱ ꞌya̱wa̱ upasu wa Yahuda, uba̱ta̱ u na u da̱nuyi oɓolo ne ele neꞌen waꞌa. Waru u yuwusaan ta̱ ama urumbusu. ");
INSERT INTO tswNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","A mantsaꞌa koto a̱ shi a zuwa Yahaya† a̱tsuma̱ o uꞌwa wa ali shi. U rumbusu ta̱ ama a Ayino, adama a na mini ma̱ a̱bunda̱ ma̱ da̱na̱ ta̱ lo. (Uba̱ta̱ꞌa̱ u laꞌashi alanga na̱ Salima shi.) Ama a̱ ꞌya̱wusa̱ ta̱ ya̱ꞌa̱ yi, waru u rumbusu le ta̱. ");
INSERT INTO tswNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","A̱tsuma̱ o ojoro a Yahaya ozo o ro a uwa ta̱ mawasan na̱ vuma va Israꞌila ro adama a̱ wuza̱ꞌu. ");
INSERT INTO tswNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Reve a̱ ꞌya̱wa̱ a damma Yahaya, “Manlu, vuma na ve enei a̱ mɓa̱nga̱ mu Uɗolu wa̱ Urdu, vuma na vu dammai a̱yi ɗa Kristi Zamawawa, a̱yi fo u ta̱ rumbusu ama. Waru ama suru a̱ ta̱ ꞌya̱wusa̱ ya̱ꞌa̱ yi, agba a̱ ta̱wa̱ uba̱ta̱ u tsu shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","A̱vu u usu, “Vuma tsu tsura̱ ta̱ ili i na A̱sula̱ a ca niyi goon. ");
INSERT INTO tswNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","A̱ɗu yu uwwa ta̱ ana n dammai, ‘A̱mu ɗa Kristi† Zamawawaꞌa shi, amma a̱mu ɗa za na A̱sula̱ a̱ lyunguyi n lapula ure adama a̱ yi.’ ");
INSERT INTO tswNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kasaꞌavu tsu ꞌya̱wa̱ ta̱ uba̱ta̱ u na vali vu kasaꞌavu ri. Iꞌutsa̱ i valiꞌi u tsu za̱nga̱na̱ ta̱ oɓolo na̱ a̱yi, na̱ wu uwwa uɗyo wa̱ yi. A̱mu iꞌutsa̱ i vali vu kasaꞌavu i ɗa, n yuwan ta̱ ma̱za̱nga̱ ma̱ a̱bunda̱ a na u lyuwai aci. ");
INSERT INTO tswNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","A̱yi gba na a ciga a ꞌyuwan u da̱shishi, a̱mu waru n jebushe.” ");
INSERT INTO tswNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Reve Yahaya lyuwa elime na adanshi u damma, “Za na ta̱wa̱i diga zuva u laꞌa ta̱ ama suru tsugbain. Za na ta̱wa̱i diga o uvaɗi za vu uvaɗi ɗa, waru adanshi o uvaɗi a ɗa u ri a yan. Za na gba ta̱wa̱i diga zuva u laꞌa ta̱ ama tsugbain suru. ");
INSERT INTO tswNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","U damma ta̱ ili i na we enei ni ili i na wu uwwai, agba ama a̱ usu ili i na u dammai shi. ");
INSERT INTO tswNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Vuma na ushiyi ikaka ya̱ yi, u roco ta̱ u usu ta̱ ili i na A̱sula̱ a dammai amayun a ɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Vuma na A̱sula̱ a̱ lyunguyi u tsu damma ta̱ adanshi a̱ A̱sula̱, adama a na A̱sula̱ a ca yi ta̱ ucira u Ruhu va̱ yi tapu. ");
INSERT INTO tswNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dada u ciga ta̱ Mawun lon, ɗaɗa u ca niyi ucira a aci e ili suru. ");
INSERT INTO tswNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Vuma na ushiyi Mawuꞌun u ta̱ tsura̱ wuma u babu ukotu, amma aza a na a yuwain tsutoni na̱ Mawuꞌun shi, a̱a̱ tsura̱ wuma shi. Ama o ndolo a̱ ta̱ da̱na̱ o sowuso a̱tsuma̱lima̱ e ekere a̱ A̱sula̱ babu ukotu.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesu tsurusa̱ ta̱ aza a na a̱ ususu niyi reve u rumbusu le. Reve Afarishi a uwwa a na aza a na oo tono yiꞌi a laꞌa ta̱ aza a Yahaya a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Yesu rumbusu amaꞌa na aciya̱yi shi, amma ojoro a̱ yi a ɗa u zuwai a̱ rumbusu le.) ");
INSERT INTO tswNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu reve ta̱ a na Afarishi a uwwa ta̱ adama a̱ yi, ɗaɗa u lyawai Yahuda, reve u reme mmalu a̱ ka̱mba̱ Ga̱lili. ");
INSERT INTO tswNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ureꞌe wu utula̱i ta̱ nu upasu wa Samariya.† ");
INSERT INTO tswNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","A̱yi a mmalu upasuꞌu, a̱vu u rawa lyuci na a̱ tsu ɗe Saka, za na ri zuzu ni iɗa i na Yakubu cayi Isuhu mawun ma̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Urana a̱ tyo aci ɗaɗa Yesu rawai ookoꞌo a Yakubu. A̱vu u kuna̱ adama a mmalu ma alanga n na u yuwain, ɗaɗa u da̱nuyi zuzu no ookoꞌoꞌo. ");
INSERT INTO tswNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ana ojoro a̱ yi a uwai a̱ lyuci a tsula ilyalya, a̱vu ka va Samariya ro ta̱wa̱ o ookoꞌoꞌo adama u kene mini. Ɗaɗa Yesu damma niyi, “Neꞌe mu mini n sowo.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Reve u uwa asalama adama a na aza a Israꞌila a tsu kiralai na ama a Samariya shi. Ɗaɗa u damma niyi, “A̱vu vuma va Israꞌila ɗa, a̱mu gba ka va Samariya ɗa. Adama a̱ nye vaa pati mu mini mo oso?” ");
INSERT INTO tswNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","A̱vu u usu yi, “Vu reve ili i na A̱sula̱ a cigai u ca wu shi, waru vu reve vuma na aa patishi wu mini shi. Na̱ shi vu reve, vu shi ta pati mu mini ma wuma.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","A̱vu u damma, “Zagbain, vu ri na aaguga shi, waru ookoꞌoꞌo u ta̱ a̱ruꞌun. Te ɗa va̱a̱ tsura̱ mini ma wumaꞌa? ");
INSERT INTO tswNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Akaya a̱ tsu Yakubu† ɗa ka̱pa̱a̱ ntsu ookoꞌoꞌo, reve a̱yi na ama o uꞌwa a̱ yi ni inama ya aguɓa ya̱ yi o sowo mini o ookoꞌo a nda. Vu laꞌa ta̱ Yakubu tsugbain?” ");
INSERT INTO tswNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","A̱vu Yesu usu, “Za na suru sowoi mini mo ookoꞌo a nda u ta̱ da̱shi uwwa akuli. ");
INSERT INTO tswNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Amma aza a na oo sowo mini ma na maa ca le a̱a̱ da̱shi uwwa akuli shi. Mini ma na maa ca le u to oꞌwo gashi lyusu mini pe a̱tsuma̱ e le, za na aa ca le mini ma wuma u na woo koto shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Reve u damma yi, “Zagbain, ca mu miniꞌi adama n da̱shi uwwa akuli wan. Waru adama n da̱shi ta̱wa̱ pa mekene ma̱ mini wan.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","A̱vu u damma yi, “ꞌYa̱wa̱ vu ɗe vali va̱ wu a̱vu i ta̱wa̱ ra.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Reve u usu, “N ri na̱ vali shi.” A̱vu Yesu usu, “Amayun a ɗa a na vu dammai vu ri na̱ vali shi. ");
INSERT INTO tswNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Vo olo ta̱ ɗe ali o ton, agba za na vu ri nden na̱ a̱yi gogo, vali va̱ wu ɗa shi. Vu damma mu ta̱ amayun.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Reve u damma, “Zagbain, n reve ta̱ a̱vu vumava̱sula̱ ɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nkaya n va̱ n yuwaan ta̱ A̱sula̱ a̱ga̱nda̱ a Masasan ma̱ Gerizim, agba a̱ɗu aza a Israꞌila i damma ta̱ Urishelima ɗa goon uba̱ta̱ u na aa yuwan a̱ga̱nda̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","A̱vu u damma yi, “Usu mu, ka, mantsa mo ta̱ lo a̱ ta̱wa̱ ana ama aa yuwaan Dada a̱ga̱nda̱ ko a masasan ma nda ko a̱tsuma̱ a̱ Urishelima shi. ");
INSERT INTO tswNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","A̱ɗu aza a Samariya keꞌen ɗa i revei adama a za na yaa yuwusaan a̱ga̱nda̱, a̱tsu gba aza a Israꞌila tsu reve ta̱ ili ya̱ a̱bunda̱ adama a̱ yi, adama a na aza a Israꞌila a ɗa aa damma cine A̱sula̱ aa wawusa ama. ");
INSERT INTO tswNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mantsa mo ta̱ lo a̱ ta̱wa̱, amayun, mantsaꞌa ma rawa ta̱ ɗe, ana Ruhu va̱ A̱sula̱ aa zuwa ama a yuwaan A̱sula̱ a̱ga̱nda̱ ununa a̱yi u ri. Ele ɗa aza a na Dada cigai a yuwaan yi a̱ga̱nda̱. ");
INSERT INTO tswNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","E tse ene A̱sula̱ shi, adama o ndolo aza a na a yuwaan yi a̱ga̱nda̱ na a ꞌyuwan a ciga a yuwaan yi na̱ yeni ye esu wan, amma a̱tsuma̱ a̱ ruhu na amayun.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","A̱vu kaꞌa u damma, “N reve ta̱ a na Zamawawa ri lo a̱ ta̱wa̱. A̱yi ɗa za na a̱ tsu ɗe Kristi. Nu u ta̱wa̱, u ta cuɗuwa tsu ili biti.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","A̱vu Yesu damma, “A̱mu, za na aa yuwusan adanshi gogoꞌo, a̱mu ɗa a̱yi.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","A mantsaꞌa, reve ojoro e Yesu a̱ ka̱mbushi, reve a uwa asalama a na a cina niyi a adanshi na̱ kaꞌa. Agba ko vuma ta̱ gura ece kaꞌa, “Nye vu cigai?” shi. Ko e ece Yesu, “Nye i zuwai vaa yuwusan adanshi na̱ a̱yi?” shi. ");
INSERT INTO tswNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","A̱vu kaꞌa u lyawa lo meden ma̱ mini ma̱ yi o ookoꞌo. Reve u ka̱mba̱ a̱ lyuci ɗaɗa u dammai ama suru, ");
INSERT INTO tswNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ta̱wa̱i ye ene vuma na damma numu ili i na n yuwain ɗe suru! Ko u ta gura oꞌwo a̱yi ɗa Kristi Zamawawaꞌa?” ");
INSERT INTO tswNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Reve o uta̱ a̱ lyuci a̱ ꞌya̱wa̱ ya̱ Yesu. ");
INSERT INTO tswNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ele a̱tsuma̱ e ili i ndolo, a̱vu ojoro e Yesu a uwa a dansaa yi, “Manlu, yuwan ankuri, lyuwa ili i ro.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","A̱vu gba u damma le, “N ta̱ ni ilyalya i na i revei shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Reve a uwa mecilei, “Vuma ro ta̱wa̱a̱ yi ta̱ ɗe ni ilyalya?” ");
INSERT INTO tswNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","A̱vu u damma, “Ya̱ꞌa̱ va̱, nna̱ n yuwan ili i na za na lyungu numu cigai n yuwan ili i ta̱ i ɗa ni ilyalya, waru ya̱ꞌa̱ va̱ nna̱ n koto ulinga wa̱ yi ili i ta̱ i ɗa ni ilyalya. ");
INSERT INTO tswNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","I ta̱ nu udammu, ‘Na a yuwan woto na̱shi ama o to ɓoloto a yuwan ugasa!’ Amma n ta dansaa ɗu i ka̱lyuwa̱ mejege, i te ene a na ishina i kutsai azama ugasa. ");
INSERT INTO tswNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Za na ri o ugasa u ta̱ ushishi atsupu, waru u to ɓolotosu itana yu uɗuma̱ adama a wuma u na woo koto shi. Adama o ndolo a mantsa ma̱ ta̱ za vu ca̱ꞌa̱n na̱ za vu ugasa a̱ ta̱ ma̱za̱nga̱ oɓolo. ");
INSERT INTO tswNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Pa nda udammu u nda amayun a ɗa, ‘Vuma ro a̱ cuꞌusa̱n, za ro waru o ugasa.’ ");
INSERT INTO tswNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","N lyungu ɗu ta̱ i gasa ili i na i lingai shi. Ozo o ro a ɗa a yuwain ulingaꞌa, a̱ɗu gba a̱vu i koso ulinga u le, waru reve i tsura̱ akunda a̱ ɗu.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Reve ama a Samariya a̱ lyuci ndolo na̱ a̱bunda̱ a ca Yesu okolo e le adama e ili i na kaꞌa u dammai, “U damma mu ta̱ ili i na n yuwain ɗe biti.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ana aza a Samariya a rawai ya̱ Yesu, reve a pati yi u da̱nu ne ele, ɗaɗa wa asai pe ayin e re. ");
INSERT INTO tswNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Reve ama na̱ a̱bunda̱ a ca okolo adama e ili i na u dammai. ");
INSERT INTO tswNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","A̱vu a damma kaꞌa, “Nu ufaru tsu ca ta̱ Yesu okolo adama a adanshi a̱ wu, amma gogo tsu ca ta̱ okolo adama a na tsu uwwa niyi na aciya̱tsu. Tsu reve ta̱ a na vuma nda na amayun a̱yi ɗa Zamawawa vu uvaɗi.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ana a yuwain ayin e reꞌe, reve Yesu ka̱ra̱ a̱ tyo Ga̱lili. ");
INSERT INTO tswNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(U damma ta̱ ɗe, a na vumava̱sula̱ tsu tsura̱ tsugbain a̱ lyuci va̱ yi shi.) ");
INSERT INTO tswNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ana u rawai Ga̱lili, reve ama o upasuꞌu a̱ ushi yi. E ene ta̱ ɗe ili i na u yuwain a̱ A̱buki a Mapasa a̱tsuma̱ a̱ Urishelima adama a na a̱ shi ta̱ ɗe fo. ");
INSERT INTO tswNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","A̱yi a̱tsuma̱ a̱ Ga̱lili, reve u ka̱mba̱ a̱ ma̱lyuci ma Kana uba̱ta̱ u na u ka̱mba̱toi mini masayan. Vuma ro za tsugbain uba̱ta̱ u mogono ta̱ nden a̱ lyuci va Kafarnahum, ulobo wa̱ yi u tu ubanakun. ");
INSERT INTO tswNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ana wu uwwai a na Yesu uta̱ ta̱ diga Yahuda a̱vu u rawa Ga̱lili, a̱vu u rawa ya̱ꞌa̱ yi, a̱vu u pati yi u ta̱wa̱ Kafarnahum u ka̱mba̱to mawun ma̱ yi gbaga, adama a na mawuꞌun u shi a gan ma̱kuwa̱a̱. ");
INSERT INTO tswNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","A̱vu Yesu damma yi, “Na̱ ye ene iroci yi ili ya asalama ni ili i saꞌavu shi, ya̱a̱ usu shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Reve zagbaiꞌin u damma yi, “Manlu, ta̱wa̱ kafu mawun ma̱ va̱ ma̱ kuwa̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ɗaɗa u damma niyi, “Wala a̱ tyo o uꞌwa, mawun ma̱ wu ma̱a̱ kuwa̱ shi.” Reve vumaꞌa u usu ili i na Yesu damma niyi, a̱vu u ka̱ra̱ a̱ tyo o uꞌwa. ");
INSERT INTO tswNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","A̱yi a̱ tyo, reve agbashi a̱ yi a gaꞌaton yi a̱vu a damma yi, “Mawun ma̱ wu ma̱ ba̱ruwa̱ ta̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","A̱vu we ece le mantsa ma na mawuꞌun u ka̱mba̱i gbaga, reve a̱ usu, “Ubanakuꞌun u lyawa yi ta̱ yon rumu ta̱ vu urana.” ");
INSERT INTO tswNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Dadaꞌa u reve ta̱ a na na̱ rumu ta̱ gan ɗa Yesu dammai, “Mawun ma̱ wu ma̱a̱ kuwa̱ shi.” Ɗaɗa vumaꞌa na aza a na a̱ ri nden o uꞌwa wa̱ yi suru a cayi Yesu okolo e le. ");
INSERT INTO tswNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","A̱yi ɗa ulinga wa asalama† we ire u na Yesu yuwain a̱ Ga̱lili ana wu uta̱i Yahuda. ");
INSERT INTO tswNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ana ili i ndolo i kotoi, a̱vu Yesu ka̱ra̱ a̱ tyo Urishelima adama a̱ a̱buki† a aza a Israꞌila o ro. ");
INSERT INTO tswNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","A̱tsuma̱ a̱ lyuciꞌi, mabata ma na a̱ tsu ɗe Beteseda na̱ Tsuꞌarama† ma̱ da̱na̱ ta̱ lo zuzu nu una̱ntsu u na a̱ tsu ɗe Una̱ntsu wi Ikyon. A yuwan ta̱ kwa̱ꞌa̱ a̱ mukisa̱ n ton uka̱nda̱ruwu a mabataꞌa. ");
INSERT INTO tswNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","A̱ mukisa̱ n ndolo, a̱za̱ o ubanakun na̱ a̱bunda̱ a̱ tsu da̱nusu ta̱ lo, ozo o ro nrumba̱ n ɗa, ozo o ro waru a̱kutsuma̱, ozo o ro waru gba shi ozo o osowi a̱ lipu. A ta pura mantsa ma na malingata ma̱ A̱sula̱ ma̱ lukuta̱ miniꞌi ");
INSERT INTO tswNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","adama a na mantsa a̱ tyo mantsa malingataꞌa ma̱ tsu cipa̱ ta̱ a̱ miniꞌi, reve u lukuta̱ yi. Nu u lukuta̱ yi u koto, a̱vu vuma na fara dasai pe reve u tsura̱ opocino a banakun na a damatosun yi suru. ");
INSERT INTO tswNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Vuma ro da̱na̱ ta̱ lo ubanakun aꞌwan mataꞌatsu na̱ kunla̱. ");
INSERT INTO tswNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu ene yi ta̱ nven, a̱vu u reve a na vuma ndolo jima ta̱ ubanakun. Ɗaɗa we ece niyi, “Vu ciga ta̱ voo oꞌwo gbaga?” ");
INSERT INTO tswNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","A̱vu u usu, “Zagbain, u ri n yuwan shi, adama a na n ri na̱ za na ee sheɗe mu a uwa a̱ miniꞌi shi, mantsa ma na a̱ lukuta̱i mini. Na̱ n ciga maꞌuwaa a̱vu nanza fara uwaa mu.” ");
INSERT INTO tswNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Reve u damma yi, “ꞌYon mishin, vu tara aavalu a̱ wu, a̱vu vu wala.” ");
INSERT INTO tswNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Babu usa̱n a̱vu vumaꞌa u ka̱mbushi gbaga. A̱vu u tara aavalu a̱ yi reve u ka̱ra̱. Urana wa Ashibi† u ɗa ili i ndolo i farai. ");
INSERT INTO tswNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ana azagbain a Israꞌila e enei vuma ndolo na aavalu a̱ yi, ɗaɗa a damma niyi, “Anaꞌan Ashibi a ɗa! Wila̱ u lyawa a na vuma ro a tanu aavalu a̱ yi o urana wa Ashibi shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","A̱vu u usu, “Vuma na ka̱mba̱to numu gbaga u damma mu ta̱, ‘Tara aavalu a̱ wu, a̱vu vu wala.’ ” ");
INSERT INTO tswNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Reve e ece yi, “Vuma ne ɗa damma nuwu vu yuwan cuꞌun vu ulinga u nda?” ");
INSERT INTO tswNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Agba u reve ko vuma ne ɗa ka̱mba̱to niyi gbagaꞌa shi, adama a na ama a̱ da̱na̱ ta̱ lo a̱bunda̱ lon, waru cina Yesu ka̱ra̱ ɗe sanyi. ");
INSERT INTO tswNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","A̱ ꞌya̱wa̱ ɗe, a̱vu Yesu gaꞌan na̱ vumaꞌa a̱ A̱a̱ꞌisamapaɗa a̱vu u damma yi, “Ka̱lyuwa̱, vo oꞌwo ta̱ gbaga gogo. Vu lyawa mayan mo unusu tsa̱ra̱ ili i na i laꞌai ili i nda i cina wu wan.” ");
INSERT INTO tswNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Reve vumaꞌa u ꞌya̱wa̱ u damma azagbain a na Yesu ɗa ka̱mba̱to niyi gbagba. ");
INSERT INTO tswNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Adama o ndolo, reve azagbain a Israꞌila a fara a casu Yesu a̱tsuma̱lima̱ a na u ta yuwusan cuꞌun vi ili i ndolo o urana wa Ashibi. ");
INSERT INTO tswNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","A̱vu gba Yesu damma le, “Kuci ɗa Dada va̱ aa yuwusan ulinga, ne ɗa fo maa lyuwa elime nu ulinga.” ");
INSERT INTO tswNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Adama o ndolo, a̱vu azagbain a Israꞌila a zamishi ure u na o una yi, adama a na u ꞌyuwain o toni wila̱ wa Ashibi. Amma ili i na i laꞌai uwuyanu a̱yi ɗa, u damma ta̱ A̱sula̱ a ɗa Dada va̱ yi, za na zuwa niyi wo oꞌwoi una̱ta̱ na̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","A̱vu Yesu usu, “N damma ɗu amayun, babu ili i na Mawun waa yuwan na aciya̱yi, amma ili i na we enei Dada a yuwusan, ɗaɗa fo waa yuwusan. Ili i na Dada yuwain suru, ɗaɗa fo Mawun u tsu yuwan goon. ");
INSERT INTO tswNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Dada u ciga ta̱ Mawuꞌun, ɗaɗa u roco niyi ili i na waa yuwusan suru. Waru u to roco yi ili i na i laꞌai nda mgbain, tsa̱ra̱ suru n ɗu yo oꞌwo a asalama. ");
INSERT INTO tswNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Cine Dada tsu ꞌya̱sa̱n ama a̱tsuma̱ a̱ a̱kwa̱kwa̱ a̱vu u ca le wuma, ne ɗa fo Mawuꞌun waa ca aza a na u ɗangwai wuma. ");
INSERT INTO tswNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Babu vuma na Dada u geꞌetoi, amma u zuwa ta̱ Mawuꞌun za vu ugeꞌetosu wa ama suru. ");
INSERT INTO tswNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Dada ciga ta̱ ama suru a ca Mawuꞌun tsugbain, cine a ca niyi tsugbain. Na ama a ꞌyuwan a ca Mawuꞌun tsugbain, una̱ta̱ u ɗa a na a ꞌyuwain a ca Dada za na lyungu niyi tsugbain. ");
INSERT INTO tswNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Amayun a ɗa maa dansaa ɗu, vuma na uwwai ili i na n dammai a̱vu u usu za na lyungu numu, u ta̱ na̱ wuma u babu ukotu. O kototo vuma ndolo shi, amma u pasa ta̱ ukwa̱ a̱ tyo wuma. ");
INSERT INTO tswNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Amayun a ɗa maa dansaa ɗu, mantsa mo ta̱ lo a̱ ta̱wa̱ waru u ta̱ pa ana a̱kwa̱kwa̱ aa uwwa uɗyo u va̱ Mawun ma̱ A̱sula̱, aza a na a uwwai a̱ ta̱ tsura̱ wuma. ");
INSERT INTO tswNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Dada ɗa ri nu ucira u na waa ca wuma, waru u ca ta̱ ɗe Mawuꞌun cuꞌun vu ucira u ndolo. ");
INSERT INTO tswNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Waru u ca ta̱ ɗe Mawuꞌun ucira u na wee geꞌeto ama suru, adama a na a̱yi Mawun ma Vuma ma ɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“She yo oꞌwo a asalama adama a nda wan. Mantsa mo ta̱ lo a̱ ta̱wa̱ ana a̱kwa̱kwa̱ a̱tsuma̱ a ason aa uwwa uɗyo wa̱ yi, ");
INSERT INTO tswNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","a̱vu o uta̱ a̱tsuma̱ a ason. Aza a na a yuwain isaꞌani a̱ ta̱ ꞌyon a̱ tyo a wuma, aza a na gba a yuwain iwuya a̱ ta̱ ꞌyon a̱ tyo uba̱ta̱ u na oo kototo le.” ");
INSERT INTO tswNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","A̱vu Yesu lyuwa elime na adanshi, “Babu ili i na maa yuwan na aciya̱va̱. Dada ɗa lyungu numu, a̱yi ɗa waru za na roco numu cine mee geꞌeto. N tsu geꞌeto ta̱ ulobonu, adama a na n ta yuwusan itoni na̱ a̱yi, waru n tsu yuwan ili i na maa uwwaa aciya̱va̱ uyoꞌo shi. ");
INSERT INTO tswNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Na̱ a̱mu ɗa n yuwain adanshi adama a aciya̱va̱ goon, babu za na aa zuwaa mu atsuvu. ");
INSERT INTO tswNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Amma za na aa yuwusan adanshi adama a̱ va̱ ta̱ lo, waru n reve ta̱ adanshi adama a̱ va̱ amayun a ɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“I lyungu ta̱ nlingata a̱ ꞌya̱wa̱ ya Yahaya, a̱vu gba u damma le amayun. ");
INSERT INTO tswNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ko na wo oꞌwoi adanshi a vaɗilima̱ o roco ko zane ɗa n ri shi, amma n yuwaan ɗu ta̱ adanshi ne ele adama i tsura̱ iwawi. ");
INSERT INTO tswNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yahaya ikanasa ta̱ gashi fitila na a daɓai, waru i za̱nga̱na̱ ta̱ a na a ca nɗu ekan a̱ yi a mantsa waꞌa. ");
INSERT INTO tswNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Amma ili i gbain i ro i ta̱ lo i na i laꞌai Yahaya i na yoo rocosu amayun adama a̱ va̱. N ta yuwusan adama e ili i na Dada zuwa numu n yuwan! Ili i nda suru i to rocosu a na Dada ɗa za na lyungu numu. ");
INSERT INTO tswNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Dada na lyungu numu fo ta yuwusan adanshi adama a̱ va̱, agba koto yu uwwa uɗyo ko ye ene yi shi. ");
INSERT INTO tswNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","I zuwa adanshi a̱ yi o okolo a̱ ɗu shi, a̱yi ɗa i zuwai a̱ɗu i kuɗa̱i a̱ usu a na a̱mu ɗa za na u lyunguyi. ");
INSERT INTO tswNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","I te petelyuwushe a̱tsuma̱ a Adanshi a̱ A̱sula̱ a majiyan i ta̱ tsura̱ wuma u babu ukotu. Adanshi a̱ A̱sula̱ a nda waru u yuwan ta̱ adanshi a̱ va̱! ");
INSERT INTO tswNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Suru na̱ ne i ꞌyuwan ta̱ a̱ ta̱wa̱ ya̱ꞌa̱ va̱, tsa̱ra̱ n ca ɗu wuma u babu ukotu. ");
INSERT INTO tswNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“N ri e izami yi ica ya ama shi. ");
INSERT INTO tswNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Amma n reve ɗu ta̱. N reve ta̱ ko vuma ta̱ a̱tsuma̱ a̱ ɗu ciga A̱sula̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","N ta̱wa̱ ta̱ a̱tsuma̱ a ala a Dada, agba i usu mu shi. Agba i tsu usu ta̱ ama a na a̱ ta̱wa̱i adama a aciyele. ");
INSERT INTO tswNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Va̱ni ɗu i tsu ciga ta̱ i tsura̱ ica ya aciya̱ɗu, agba i tsu yuwan a̱tyo a na yaa yuwan, tsa̱ra̱ i tsura̱ ica e ekere a̱ A̱sula̱ goon shi. To, cine ya̱a̱ usu mu? ");
INSERT INTO tswNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Agba a̱mu ɗa ma̱a̱ ꞌya̱wa̱ na adanshi a̱ ɗu uba̱ta̱ wa Dada shi. Musa ɗa a̱a̱ ꞌya̱wa̱ na adanshi a̱ ɗu! Ee, Musa za na yaa zuwusa okolo waa kamba ɗu. ");
INSERT INTO tswNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Musa ɗana ta̱ adama a̱ va̱. Ni i shi i usu Musa, i shi ta̱ usu mu. ");
INSERT INTO tswNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ni i usu ili i na Musa ɗanai shi, to, cine ya̱a̱ usu ili i na n dammai?” ");
INSERT INTO tswNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ana ili i ndolo i farai, a̱vu Yesu ka̱ra̱ a̱ tyo upasalai u Mala ma̱ Ga̱lili (za na a̱ tsu ɗe Mala ma Tibariya). ");
INSERT INTO tswNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","A̱ba̱jini o oɓolo o toni yi ta̱, adama a na e ene yi ta̱ ɗe ana u yuwain iroci yi ili ya asalama, ana u ka̱mba̱toi a̱za̱ o ubanakun gbaga. ");
INSERT INTO tswNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Mantsa ma̱ A̱buki a Mapasa ma aza a Israꞌila ma yuwan ta̱ zuzu, a̱vu Yesu ꞌya̱wa̱ a masasan oɓolo no ojoro a̱ yi, reve a̱ da̱nu. ");
INSERT INTO tswNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ana Yesu enei a̱ba̱jini o oɓolo a ama a̱ ta̱wa̱ uba̱ta̱ wa̱ yi, reve we ece Filibu, “Te ɗa tsa̱a̱ tsura̱ ilyalya i na tsaa lyuwato ama a nda?” ");
INSERT INTO tswNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Yesu ece ta̱ Filibu yeci i nda, tsa̱ra̱ u lyungwa̱ yi, adama a na u reve ta̱ ɗe ili i na waa yuwan.) ");
INSERT INTO tswNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","A̱vu Filibu usu, “Ikebe yu ulivu ukpakure (200) aa gura tsula ilyalya i na za suru a lyuwa ko keꞌen shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","A̱tsuma̱ o ojoro a̱ yi, reve Andarawu mawun ma̱ a̱na̱wu ma̱ Bituru ma damma, ");
INSERT INTO tswNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Apa ulobo u ro za na ri no opopofu a yitabo† o ton na̱ mugula mu uꞌyewu n re. Agba ko cine a yuwain aa rawa le shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","A̱vu Yesu damma le, “Dammai amaꞌa a̱ da̱nu.” Uba̱ta̱ꞌa̱ u da̱na̱ ta̱ na anlya o uta̱nu lon. Ali ukpakukupa uton (5,000) u ɗa a̱ da̱nuyi uba̱ta̱ u ndoloꞌo. ");
INSERT INTO tswNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Reve Yesu tara opopofuꞌu, a̱vu u godyoo A̱sula̱ adama a na u ca nle. A̱vu u ca e neꞌeshen ali a na a̱ ri lo nden. Ne ɗa fo u yuwain na̱ mugulaꞌa, hali suru nle a tama a̱ cuwa̱n. ");
INSERT INTO tswNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ana a tamai a̱ cuwa̱in, ɗaɗa u dammai ojoro a̱ yi, “Ɓolotoi akapi a na a buwai. She tsu lungusa̱i ko ili wan.” ");
INSERT INTO tswNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ɗaɗa o ɓolotoi akapi o opopofu a yitabo a na a buwai, a̱vu o shiton asaka kupa ne ejere. ");
INSERT INTO tswNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ana ama e enei ili ya asalama i na Yesu yuwain, reve a damma, “Amayun, a̱yi ɗaɗa Vumava̱sula̱ la̱nga̱ na ri lo a̱ ta̱wa̱ a̱tsuma̱ o uvaɗi.” ");
INSERT INTO tswNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu reve ta̱ a na ama a̱ ri e ifoɓi tsa̱ra̱ a̱ ta̱wa̱ a̱ ka̱mba̱to yi wo oꞌwo mogono me le nu ucira, ɗaɗa gba u ka̱ra̱i a̱ tyo a agaɗi a̱yi a̱ ndeꞌen. ");
INSERT INTO tswNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ana urana u riya̱i, reve ojoro a̱ yi a̱ ka̱ra̱ a̱ cipa̱ za̱la̱ mala. ");
INSERT INTO tswNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ana uba̱ta̱ u rumba̱na̱i, agba babu Yesu ta̱wa̱ uba̱ta̱ u le. A̱vu a uwa a wantsun adama a pasalai a̱ tyo Kafarnahum. ");
INSERT INTO tswNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","A mantsa mo ndolo a̱ba̱jini o upepu a lapusa ta̱, a̱vu u yuwusan a̱ba̱jini a̱ba̱jini e ikeɗu i mala. ");
INSERT INTO tswNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ana ojoro a̱ luwa̱i a̱ tyo e memere ma malaꞌa, a̱vu e ene Yesu a mmalu zuva mini. A̱vu u lyuwa elime na̱ mmalu a̱ tyo uba̱ta̱ u na a̱ ri, ɗaɗa a uwwai wovon lon. ");
INSERT INTO tswNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ɗaɗa u damma nle, “A̱mu ɗa. She yu uwwa wovon wan.” ");
INSERT INTO tswNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","A̱vu a̱ shi a ciga a tara yi a wantsun. Babu usa̱n, a̱vu wantsuꞌun u rawa uba̱ta̱ u na a cigai a̱ tyo. ");
INSERT INTO tswNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ana usana u tawai, ama a na a buwai upasu u ndeɗe e reve ta̱ a na wantsun u ta̱ u ɗa u shi ɗe. E reve ta̱ a na Yesu uwai pe a wantsuꞌun oɓolo no ojoro a̱ yi shi, amma a̱ ka̱ra̱ ta̱ a lyawa yi. ");
INSERT INTO tswNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Antsun o ro o uta̱ ta̱ ɗe a̱ lyuci va Tibariya, a̱vu e isawan zuzu nu uba̱ta̱ u na Zagbain godyoyi A̱sula̱ adama o opopofu a na ama a tamai. ");
INSERT INTO tswNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ana oɓolo a ama e enei ɗe Yesu shi, ko e enei ɗe ojoro a̱ yi shi, a̱vu a uwa a antsun a pasa a̱ tyo a̱ mɓa̱nga̱ ma Kafarnahum tsa̱ra̱ a zami yi. ");
INSERT INTO tswNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ana a̱ ꞌya̱wa̱i a cina niyi ɗe, reve e ece yi, “Manlu, cine vu yuwain ɗaɗa vu rawushi pa nda?” ");
INSERT INTO tswNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ɗaɗa Yesu usuyi, “Amayun a ɗa maa dansaa ɗu, i te izami i va̱ adama a na i tamai opopofu hali i cuwa̱in. Agba i ri e izami i va̱ adama a na ye enei iroci yi ili ya asalama i va̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","She i zuwa ucira u ɗu e izami yi ilyalya i na ya̱a̱ la̱nga̱ wan. Amma, i zuwa ucira u ɗu e izami yi ilyalya i na yaa ca wuma u babu ukotu. A̱yi ɗaɗa ilyalya i na Mawun ma Vuma maa ca ɗu, adama a na Dada A̱sula̱ o roco ta̱ u usu ta̱ Mawuꞌun.” ");
INSERT INTO tswNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ɗaɗa e ece niyi, “Nye i ɗa A̱sula̱ a ciga ntsu tsu yuwan?” ");
INSERT INTO tswNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Reve u usu, “Apa ili i na A̱sula̱ a ciga nɗu i yuwan: I usu vuma na u lyunguyi.” ");
INSERT INTO tswNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","A̱vu a damma, “Na̱ vu ciga tsu usu wu, yuwaan tsu ili ya asalama. Nye vaa yuwaan tsu? ");
INSERT INTO tswNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nkaya n tsu n tama ta̱ mana† a̱tsuma̱ o una. A ɗana yi ta̱ pe a̱tsuma̱ a Adanshi a̱ A̱sula̱, ‘U ca tsu ta̱ opopofu diga zuva tsa̱ra̱ tsu tama.’ ” ");
INSERT INTO tswNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Reve Yesu damma, “Amayun a ɗa maa dansaa ɗu, Musa ɗa za na ca nɗu opopofu diga zuva shi. Dada va̱ ɗa za na aa casu opopofu a amayun diga zuva. ");
INSERT INTO tswNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Waru opopofu a na A̱sula̱ a cayi, a̱yi ɗaɗa za na ta̱wa̱i diga zuva reve u ca uvaɗi wuma.” ");
INSERT INTO tswNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Reve amaꞌa a̱ usu, “Zagbain, ca tsu opopofu o ndolo kuci.” ");
INSERT INTO tswNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ɗaɗa Yesu dammai, “A̱mu ɗa opopofu a na a tsu ca wuma. Vuma na ta̱wa̱i uba̱ta̱ u va̱ suru wa̱a̱ da̱na̱ na ambulu shi, waru za na usu numu suru waa uwwa akuli shi. ");
INSERT INTO tswNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","N damma ɗu ta̱ ɗe ye ene mu ta̱, agba suru na̱ ne i usu mu shi. ");
INSERT INTO tswNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Dada ca mu ta̱ ama a̱ va̱, suru nle a̱ ta̱wa̱ ya̱ꞌa̱ va̱, agba maa ꞌyuwan le shi. ");
INSERT INTO tswNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","N cipa̱ ta̱ diga zuva tsa̱ra̱ n yuwan ili i na A̱sula̱ a cigai n yuwan, agba ili i na n cigai shi. ");
INSERT INTO tswNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Apa ili i na za na lyungu numu ciga numu n yuwan: N ciga n ꞌyuwan n lamba ko vuma ta̱ a̱tsuma̱ a aza a na A̱sula̱ a ca numu wan, n ciga n ꞌyuwan n ꞌya̱sa̱n le o urana wu ukosu. ");
INSERT INTO tswNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Aza a na e enei Mawuꞌun, a̱vu a̱ usu yi a̱ ta̱ tsura̱ wuma u babu ukotu, waru n ta̱ ꞌya̱sa̱n le o urana wu ukosu. A̱yi ɗa ili i na Dada va̱ cigai.” ");
INSERT INTO tswNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","A̱vu ama a uwa a yuwusan adanshawuya a aci a̱ yi, adama a na u dammai, “A̱mu ɗa opopofu a na a̱ cipa̱i diga zuva.” ");
INSERT INTO tswNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","A̱vu a damma, “A̱yi nda a̱yi ɗa Yesu, ulobo wa̱ Isuhu. Tsu reve ta̱ dada na̱ mma va̱ yi. Cine waa damma, ‘N cipa̱ ta̱ diga zuva?’ ” ");
INSERT INTO tswNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ɗaɗa Yesu aa damma, “Lyawai adanshawuya. ");
INSERT INTO tswNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Dada ɗa za na lyungu numu. Babu za na a̱a̱ ta̱wa̱ uba̱ta̱ u va̱, she na̱ Dada ɗe yi a̱ tyo ya̱ꞌa̱ va̱, waru n ta̱ ꞌya̱sa̱n vuma ndolo o urana wu ukosu. ");
INSERT INTO tswNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ama̱sula̱ a ɗana ta̱, ‘A̱sula̱ o to rito le suru.’ Za na zuwayi Dada atsuvu, a̱vu u rito ili i na woo ritosu yi, u ta̱ ta̱wa̱ ya̱ꞌa̱ va̱. ");
INSERT INTO tswNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Babu za na enei ɗe Dada, she a̱mu za na A̱sula̱ a̱ lyunguyi. A̱mu ɗa a̱ ndeꞌen goon me ene niyi. ");
INSERT INTO tswNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“N ta dansaa ɗu amayun, za na usu numu suru u ta̱ na̱ wuma u babu ukotu. ");
INSERT INTO tswNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","A̱mu ɗa opopofu a na a tsu ca wuma. ");
INSERT INTO tswNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nkaya n ɗu n tama ta̱ mana† o ogozo, a̱ tyo ɗe reve a̱ kuwa̱. ");
INSERT INTO tswNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Apa nda opopofu a na a̱ cipa̱i diga zuva a̱ tyo o uvaɗi. Vuma na tamai opopofu a nda wa̱a̱ kuwa̱ shi suru suru. ");
INSERT INTO tswNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","A̱mu ɗa opopofu a na a tsu ca wuma, za na cipa̱i diga zuva. Vuma na tamai opopofu a nda suru wa̱a̱ kuwa̱ shi. Opopofu a na maa ca ɗu lipu va̱ ɗa, za na maa ca tsa̱ra̱ ama o uvaɗi a̱ tsura̱ wuma.” ");
INSERT INTO tswNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","A̱vu aza a Israꞌila a uwa mawasan va̱ni le, adansa, “Cine tsa ɗa vuma nda a ca tsu lipu va̱ yi tsu tama?” ");
INSERT INTO tswNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","A̱vu Yesu usu le, “N damma ɗu amayun, ni i tama lipu Mawun ma Vuma waru i sowo mpasa ma̱ yi shi, ya̱a̱ tsura̱ wuma u babu ukotu shi. ");
INSERT INTO tswNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Aza a na a tamai lipu va̱ waru o sowoi mpasa n va̱, a̱ ta̱ tsura̱ wuma u babu ukotu, waru n ta̱ ꞌya̱sa̱n le o urana wu ukosu. ");
INSERT INTO tswNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Lipu va̱ ilyalya ya amayun i ɗa, waru mpasa n va̱ ili yo oso ya amayun i ɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Aza a na a tamai lipu va̱ waru o sowoi mpasa n va̱ o to oɓolo na̱ a̱mu, waru a̱mu n to oɓolo ne ele. ");
INSERT INTO tswNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Dada va̱ za na ri wuma ɗa lyungu numu, a̱mu fo n ta̱ wuma adama e ili i na Dada va̱ yuwain. Adama o ndolo, za na tama numu ta yuwan wuma adama e ili i na n yuwain. ");
INSERT INTO tswNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","A̱mu ɗa opopofu a amayun a na a̱ cipa̱i diga zuva. Vuma na tamai opopofu a nda suru, u ta̱ tsura̱ wuma u babu ukotu. Agba wa̱a̱ kuwa̱ cine nkaya n ɗu n kuwa̱i shi, ko na a tamai mana.”† ");
INSERT INTO tswNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu yuwan ta̱ adanshi a nda suru a̱yi pe a yuwusan uritosu a̱tsuma̱ a̱ a̱a̱ꞌisa̱† a Kafarnahum. ");
INSERT INTO tswNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ana aza a na oo tono Yesu a uwwai ne, a̱vu a damma, “Ili i nda i tu usa̱n u na vuma ee reve. Cine ama a̱ usu adanshi a nda?” ");
INSERT INTO tswNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu reve ta̱ a ta adanshawuya. Ɗaɗa we ecei, “Ili i nda u ɓa̱la̱ ɗu ta̱? ");
INSERT INTO tswNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","To nye yaa jiyan na̱ ye ene mu, Mawun ma Vuma, a̱ ka̱mba̱ zuva waru? ");
INSERT INTO tswNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ruhu ɗa tsu ca wuma u babu ukotu. Ucira u vuma waa gura yuwan ili shi. Adanshi a na n yuwain ɗa a zuwa nɗu i tsura̱i Ruhu va̱ A̱sula̱, za na tsu ca wuma. ");
INSERT INTO tswNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Agba ozo o ro a̱ ɗu a ca okolo shi.” (O ufaru, Yesu reve ta̱ ɗe aza a na a cayi okolo shi, na̱ vuma na aa wina yi.) ");
INSERT INTO tswNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Reve Yesu damma, “Adama o ndolo a ɗa n dammai, ‘Na̱ Dada ta̱wa̱a̱ na̱ vuma uba̱ta̱ u va̱ shi, vuma ndolo waa gura ta̱wa̱ shi.’ ” ");
INSERT INTO tswNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Adama e ili i na Yesu dammai, ɗaɗa aza a na oo tono yi na̱ a̱bunda̱ a vadalai, a̱vu a lyawa itoni ya̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ɗaɗa we ecei Kupanejereꞌe, “A̱ɗu fo i ta ciga i ka̱ra̱?” ");
INSERT INTO tswNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Reve Simo Bituru usu yi, “Zagbain, ya zane ɗa tsa̱a̱ tyo? Vu ta̱ ni idanshi i na i tsu ca wuma u babu ukotu. ");
INSERT INTO tswNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tsu ca ta̱ okolo, waru tsu reve ta̱ a na a̱vu ɗa Za va Akiza va̱ A̱sula̱ꞌa̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Reve Yesu usu, “N ɗangwa ɗu ta̱ Kupanejere.† Agba za ta̱ a̱tsuma̱ a̱ ɗu Mekerenkesu ma ɗa!” ");
INSERT INTO tswNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yahuza ulobo wa̱ Simo Iskariyoti ɗa Yesu yuwusain adanshi a aci a̱ yi. A̱ tyo o ukosu u ta wina Yesu, ko na wo oꞌwoi za ta̱ ɗa a̱tsuma̱ a Kupanejereꞌe. ");
INSERT INTO tswNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ana ili i ndolo i kotoi, a̱vu Yesu garasa upasu wa̱ Ga̱lili, adama a na u ciga u ꞌya̱wa̱ upasu wa Yahuda shi, adama a na azagbain a Israꞌila a ciga ta̱ o una yi. ");
INSERT INTO tswNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","A mantsaꞌa A̱buki o Ogodo o Ucuwusan a aza a Israꞌila a yuwan ta̱ zuzu. ");
INSERT INTO tswNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ɗaɗa muwun ma̱ a̱na̱wu ma̱ yi n damma niyi, “Vu lyawa uba̱ta̱ u nda reve vu ka̱ra̱ a̱ tyo Yahuda, tsa̱ra̱ aza a na oo tono wu e ene ili ya asalama i na vaa yuwusan. ");
INSERT INTO tswNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Vuma na cigai ama suru e reve ili i na waa yuwusan, u tsu paꞌaton aciya̱yi shi. Na̱ vaa yuwusan cuꞌun vi ili i nda, to, uta̱a̱ aciya̱wu a alanga eteshe.” ");
INSERT INTO tswNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ko muwun ma̱ a̱na̱wu n usu shi. ");
INSERT INTO tswNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ɗaɗa Yesu damma nle, “Gogo ɗa mantsa ma na ma̱a̱ ka̱ra̱ shi. Amma ya̱ꞌa̱ ɗu, mantsa suru wu ntsaa ɗu ta̱. ");
INSERT INTO tswNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ama o uvaɗi u nda aa ꞌyuwan ɗu shi. A ꞌyuwan mu ta̱ adama a na n damma nle a ta yuwusan ili i iwuya. ");
INSERT INTO tswNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ꞌYoyin i ka̱ra̱ a̱ ꞌya̱wa̱ uba̱ta̱ wa̱ a̱buki. N ri ufoɓu u na ma̱a̱ ꞌya̱wa̱ ɗe shi, adama a na mantsa ma̱ va̱ koto ma yuwan shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ana Yesu dammai tsundolo, a̱vu wi isawan pe a̱tsuma̱ a̱ Ga̱lili. ");
INSERT INTO tswNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ana muwun ma̱ a̱na̱wu n ka̱ra̱i a̱ tyo uba̱ta̱ wa̱ a̱bukiꞌi, a̱yi fo u ꞌya̱wa̱ ta̱ ɗe usokowu, u ꞌya̱wa̱ a alanga e eteshe shi. ");
INSERT INTO tswNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Azagbain a Israꞌila a ciga ta̱ e ene yi uba̱ta̱ wa̱ a̱bukiꞌi, ɗaɗa a lyuwai elime na̱ yeci adansa, “Te ɗa gba u ri?” ");
INSERT INTO tswNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","A̱tsuma̱ o oɓoloꞌo, ama na̱ a̱bunda̱ a yuwusan ta̱ adanshi na̱ yemenu a aci e Yesu. Ozo o ro a damma a na, “Vuma va̱ a̱ɓula̱ ɗa.” Ozo o ro gba a damma, “Ama a ɗa waa yuwusaan epen.” ");
INSERT INTO tswNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Babu vuma na yuwain adanshi a̱ yi a alanga e eteshe, adama a na a ta uwwusa wovon wa azagbain a Israꞌila. ");
INSERT INTO tswNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","O urana wa̱ na̱shi wa̱ a̱bukiꞌi, Yesu ꞌya̱wa̱ ta̱ a̱ A̱a̱ꞌisamapaɗa, a̱vu u reme uritosu. ");
INSERT INTO tswNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Aza a Israꞌila a yuwan ta̱ asalama hali a damma, “Koto vuma nda da̱nu e ekere a manlu shi. Cine tsa ɗa u yuwan u revei ili i nda na̱ a̱bunda̱ tsunda?” ");
INSERT INTO tswNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ɗaɗa Yesu usuyi, “Ili i na moo ritosu ya̱ꞌa̱ va̱ ɗa wu uta̱i shi, amma A̱sula̱ a na a̱ lyungu numu, a̱yi ɗa u ca numu ele. ");
INSERT INTO tswNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Na ama a ɗangwa a yuwan ili i na A̱sula̱ a cigai, e te reve uritosu u va̱ uba̱ta̱ wa̱ A̱sula̱ u ɗa wu uta̱i, amma ya̱ꞌa̱ va̱ ɗa shi. ");
INSERT INTO tswNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ama a na aa yuwusan uritosu wi ili ya aciyele, e te izami yi ica e ekere a ama. Amma vuma na cigai akapi a cuwa za na lyungu niyi, amayun a ɗa u tsu damma. U tsu yuwan epen shi, ko keꞌen. ");
INSERT INTO tswNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musa ca ɗu ta̱ Wila̱ꞌa̱, agba babu za na kuru niyi. Nye i zuwai i cigai yu una mu?” ");
INSERT INTO tswNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Reve amaꞌa a̱ usu, “Vu ta̱ no otoni a̱ lima̱! Nan zane ɗa gba a cigai o una wu?” ");
INSERT INTO tswNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ɗaɗa Yesu usu nle, “N yuwan ta̱ ili ya asalama i ta̱, a̱vu suru nɗu i ka̱ra̱ a asalama. ");
INSERT INTO tswNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa damma ɗu ta̱ i paɗa muwun n ɗu uryumbu. (Nkaya n ɗu n ɗa n farai ulinga u ndolo, Musa ɗa shi). I tsu paɗa ta̱ mawun uryumbu, ko urana wa Ashibi u ɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","A̱yi ɗa nda i tsu paɗa ta̱ mawun uryumbu o urana wa Ashibi adama i kuru Wila̱ wa Musa. To, adama a̱ nye i ri o upan na̱ a̱mu a na n ka̱mba̱toi vuma ro gbaga o urana wa Ashibi? ");
INSERT INTO tswNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","I lyawa ugeꞌetosu adama a na ye enei cine ili i rotsoi. I yuwan ugeꞌetosu wi ili i na ye enei amayun.” ");
INSERT INTO tswNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","A mantsa mo ndolo, a̱vu ama a̱ Urishelima o ro a dammulai, “Vuma na azagbain a cigai o una ɗaɗa nda. ");
INSERT INTO tswNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Agba u ta yuwusan uritosu uba̱ta̱ u na ama e ene yi waru a uwwa yi, agba babu vuma na putsaa niyi. She damma azagbagbain a̱ usu ta̱ a na a̱yi Zamawawa ɗa na amayun. ");
INSERT INTO tswNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Amma tsu reve ta̱ lyuci vuma ndaꞌa. Agba na̱ Zamawawa va amayun ta̱wa̱, babu za na ee reve uba̱ta̱ u na wu uta̱i.” ");
INSERT INTO tswNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu pe a yuwusan uritosu a̱ A̱a̱ꞌisamapaɗa, ɗaɗa u ꞌya̱sa̱in uɗyo, “Ee, i reve mu ta̱, waru i reve ta̱ lyuci va̱. A̱mu ɗa n lyunguyi aciya̱va̱ shi. Za na lyungu numu za va amayun ɗa, agba i reve yi shi. ");
INSERT INTO tswNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Amma a̱mu n reve yi ta̱, adama a na mu uta̱ ta̱ uba̱ta̱ u na u ri, a̱yi ɗa waru u lyungu numu.” ");
INSERT INTO tswNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ana u dammai ili i nda, a̱vu ama a̱ shi a ciga e reme yi. Agba a̱ tsura̱ vuma na gura juꞌwa̱n niyi shi, adama a na mantsa mo koto ma rawa shi. ");
INSERT INTO tswNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ama na̱ a̱bunda̱ a̱ usu ta̱ Yesu. Ɗaɗa a dammai, “Na̱ Zamawawa u ta̱wa̱, u ta gura yuwan ili ya asalama i na i laꞌai ili i na vuma nda aa yuwusan?” ");
INSERT INTO tswNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ana Afarishi a uwwai oɓolo a adanshi adama e Yesu, reve ele oɓolo na̱ nan ganu a gbagbain a̱ lyungu a̱duga̱ri a̱ A̱a̱ꞌisamapaɗa e reme yi. ");
INSERT INTO tswNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","A̱vu Yesu damma, “N ta̱ da̱na̱ oɓolo na̱ a̱ɗu woto meketeci, a̱vu n ka̱mba̱ a̱ tyo uba̱ta̱ wu za na lyungu numu. ");
INSERT INTO tswNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","A mantsa mo ndolo, i ta zami mu, agba ya̱a̱ tsura̱ mu shi. Agba yaa gura ꞌya̱wa̱ uba̱ta̱ u na n ri shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","A̱vu azagbain a Israꞌila a dammulai va̱ni le, “Uba̱ta̱ u ne u ɗa vuma nda cigai u ꞌya̱wa̱ hali na tsaa zami yi agba tsee ene yi shi? U ta̱ ꞌya̱wa̱ e ilyuci ilyuci ya̱ Heleni† uba̱ta̱ u na ama a̱ tsu a̱ ri nden tsa̱ra̱ u rito Nheleni† n na n ri ɗe? ");
INSERT INTO tswNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nye i ɗa waa yuwusan majiyan ana u dammai, ‘I ta zami mu, agba ya̱a̱ tsura̱ mu shi’, waru ‘Yaa gura ꞌya̱wa̱ uba̱ta̱ u na n ri shi’?” ");
INSERT INTO tswNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","O urana wu ukosu wa̱ a̱bukiꞌi, za na a̱yi ɗa a̱ba̱jini o urana, a̱vu Yesu ꞌyon mishin ɗaɗa wu uta̱yi uɗyo zuva, “Vuma na aa uwwusa akuli biti u ta̱wa̱ uba̱ta̱ u va̱, reve u sowo. ");
INSERT INTO tswNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Cine Adanshi a̱ A̱sula̱† a dammai, ‘Vuma na usu numu suru, ɗolu na tsu casu mini ma wuma ma̱ ta̱ da̱na̱ oo utusa̱ a̱tsuma̱ a̱ yi.’ ” ");
INSERT INTO tswNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu yuwan ta̱ adanshi adama a̱ Ruhu va Akiza. Koto A̱sula̱ a ca Ruhuꞌu shi, adama a na koto u ꞌya̱sa̱n Yesu a̱vu u ca yi tsugbain shi. Agba a̱ tyo o ukosu, aza a na a̱ usuyi Yesu a̱ tsura̱ ta̱ Ruhuꞌu. ");
INSERT INTO tswNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ana ama a uwwai adanshi e Yesu, ɗaɗa ozo o ro e le a dammai, “Ili i ro yi lo shi, vuma ndaꞌa Vumava̱sula̱ la̱nga̱ va amayun ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ozo o ro gba a damma, “A̱yi ɗa Kristi Zamawawaꞌa.” Reve gba ozo o ro a damma, “Kristi Zamawawa oo uta̱ diga Ga̱lili shi. ");
INSERT INTO tswNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Adanshi a̱ A̱sula̱ a damma ta̱ Kristi Zamawawa to uta̱ o ugundo u Mogono Da̱wuda waru a ta matsan yi Batalami, lyuci na Da̱wuda da̱na̱i nden.” ");
INSERT INTO tswNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Oɓolo a amaꞌa e neꞌeshen ta̱ ure adama e Yesu. ");
INSERT INTO tswNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ozo o ro a̱tsuma̱ e le a̱ shi ta̱ a ciga e reme Yesu, amma babu za na gura juꞌwa̱n niyi. ");
INSERT INTO tswNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","A̱vu a̱duga̱riꞌi a̱ ka̱mba̱ uba̱ta̱ u nan ganu a gbagbain† na Afarishi, aza a na e ece nle, “Nye i zuwai i ta̱wa̱i na̱ Yesu pa shi?” ");
INSERT INTO tswNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Reve a̱ usu, “Koto a̱ tsura̱ vuma na dammai ili i na vuma nda dammai shi!” ");
INSERT INTO tswNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ɗaɗa Afarishi a̱ usuyi, “Hali na̱ a̱ɗu fo Yesu pusa̱n ɗu ta̱ ana? ");
INSERT INTO tswNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ko ganu gbain ko Mafarishi ma̱ ta̱ a̱tsuma̱ a̱ tsu a̱ usu yi shi! ");
INSERT INTO tswNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Oɓolo a ama a nda koto e reve Wila̱ wa Musa shi. A̱sula̱ yuwaan le ta̱ una̱!” ");
INSERT INTO tswNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimu Mafarishi ma̱ da̱na̱ ta̱ lo, vuma na shi ꞌya̱wa̱i ya̱ Yesu nu ufaru tsa̱ra̱ we ene yi. U damma le ta̱, ");
INSERT INTO tswNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Wila̱ u tsu u lyawa tsu tsu kototo ama babu tsu uwwa ili ya aguji i le shi. U ri ulobonu tsu geꞌeto nle babu na tsu revei unusu u na a yuwain shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ɗaɗa ele a dammai, “Upasu wa̱ Ga̱lili u ɗa vu uta̱i fo? Ka̱lyuwa̱ Adanshi a̱ A̱sula̱ ulobonu, vu te reve babu vumava̱sula̱ na oo uta̱ diga Ga̱lili.”  ");
INSERT INTO tswNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ne ɗa iɓoloꞌo i kotoi, a̱vu ama e beteꞌwe a̱ tyo a ꞌwa le. ");
INSERT INTO tswNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu gba u ka̱ra̱ ta̱ a̱ tyo a Masasan ma̱ Zetun. ");
INSERT INTO tswNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ana usana u tawai, reve u ꞌya̱wisa̱ a̱ A̱a̱ꞌisamapaɗa na̱ wasasa. Ama suru a̱ ta̱wa̱ ta̱ uba̱ta̱ u na u ri, a̱vu u da̱nu u ka̱ra̱ o ritosu le. ");
INSERT INTO tswNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Reve munlu n Wila̱ na Afarishi a̱ ta̱wa̱ na̱ ka na e remei e tsipere. A̱vu a zuwa yi wi isawan e memere ma ama. ");
INSERT INTO tswNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","A̱vu a damma, “Manlu, ka nda e reme yi ta̱ a̱tsuma̱ e tsipere. ");
INSERT INTO tswNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Wila̱ wa Musa u rito tsu ta̱ a na cuꞌun vu ka ndolo suru a vara yi na atali o una yi! A̱vu gba nye vu dammai?” ");
INSERT INTO tswNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","A yuwan yi ta̱ cuꞌun yeci i ndolo tsa̱ra̱ a̱ lyungwa̱ yi, waru e reme yi nu unusu. Reve u ka̱ɗa̱to reve u yuwan iɗana e iɗa na aakatsu a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","A̱vu a yuwisan yi yeci adama a kaꞌa, a̱ tyo o ukosu a̱vu u gaɗuwa ɗaɗa u damma nle, “Na̱ vuma ro a̱tsuma̱ a̱ ɗu koto u yuwan unusu shi, lyawa wo oꞌwo za na aa fara vara yi na aatali.” ");
INSERT INTO tswNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","A̱vu u ka̱ɗa̱towisa̱ u yuwan iɗana e iɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ana a uwwai ne, reve e beteꞌwe a̱za̱ a̱ ta̱ ta̱. Aza a kpakpara ɗa a fara ka̱ra̱i. A̱ tyo o ukosu Yesu ɗa na̱ kaꞌa a buwai lo goon no oɓoloꞌo. ");
INSERT INTO tswNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","A̱vu u gaɗuwisa ɗaɗa we ecei kaꞌa, “Te gba amaꞌa? Vuma ro buwa lo a na wee geꞌeto wu shi?” ");
INSERT INTO tswNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Reve u usu, “Manlu, ko vuma buwa pa shi.” Ɗaɗa u damma niyi, “To, ko a̱mu moo kototo wu shi. Wala, agba she vu da̱shi yuwan unusu wan.” ");
INSERT INTO tswNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","A̱ tyo ɗe, a̱vu Yesu damma amaꞌa, “A̱mu ɗa maa casu ama o uvaɗi ekan. Vuma na kuru numu suru u ta̱ tsura̱ ekan a na a tsu ca wuma, waru waa wala a̱tsuma̱ e irumbu shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Reve Afarishi a damma yi, “Ana vaa yuwusan adanshi a aciya̱wu, a̱vu ɗa goon vaa dansa a na ili i nda amayun a ɗa. Tsu usu ili i na vu dammai shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Reve u usu, “Ee, n ta dansa ili i nda adama a aciya̱va̱, amma waru amayun a ɗa. N reve ta̱ uba̱ta̱ u na mu uta̱i, waru n reve ta̱ uba̱ta̱ u na mee tyo. A̱ɗu gba i reve uba̱ta̱ u na mu uta̱i nu uba̱ta̱ u na mee tyo shi. ");
INSERT INTO tswNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","A̱ɗu ɗa yee geꞌetosu cine vaɗilima̱ ee geꞌetosu. A̱mu gba mee geꞌetosu vuma shi. ");
INSERT INTO tswNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Agba ko na̱ n geꞌeto, ure u na mee geꞌetosu amayun a ɗa, adama a na a̱mu ɗa a̱ ndeꞌen shi. Dada na lyungu numu to oɓolo na̱ a̱mu. ");
INSERT INTO tswNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Wila̱ u ɗu u damma ta̱, na ama e re a yuwan adanshi a̱ ta̱ adama e ili i ro, i ciga i ꞌyuwan i usu ili i na a dammai. ");
INSERT INTO tswNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","A̱mu ɗa vuma na yuwain adanshi adama a aciya̱va̱, waru Dada na lyungu numu ta yuwusan adanshi a aci a̱ va̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Reve e ece, “Te ɗa dada va̱ wu?” A̱vu u usu, “I reve mu shi, agba i reve Dada va̱ shi. Ni i shi i reve mu, i shi te reve Dada va̱ fo.” ");
INSERT INTO tswNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","U damma ta̱ ili i nda suru a mantsa ma na u yuwusain uritosu a̱ A̱a̱ꞌisamapaɗa, zuzu nu uba̱ta̱ u na a̱ shi a zuwusa ikebe. Agba babu za na reme niyi, adama a na mantsa ma̱ yi ma buwai. ");
INSERT INTO tswNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu dammisa ta̱ Afarishiꞌi, “N ta̱ ka̱ra̱ n lyawa ɗu, i ta zami mu, ne ɗa waru yaa lyuwa elime nu unusu u ɗu, reve i kuwa̱. Ya̱a̱ ꞌya̱wa̱ uba̱ta̱ u na mee tyo shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","A̱vu azagbain a Israꞌila a damma, “U damma ta̱ tsa̱a̱ ꞌya̱wa̱ uba̱ta̱ u na wee tyo shi. U ta a majiyan wu una aciya̱yi?” ");
INSERT INTO tswNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Reve u damma, “A̱ɗu ama o uvaɗi a na a̱ ri za̱la̱ ɗa, agba a̱mu o uvaɗi wa zuva u ɗa n ri. A̱ɗu a̱za̱ o uvaɗi a nda a ɗa, agba a̱mu za vu uvaɗi u nda u ɗa n ri shi. ");
INSERT INTO tswNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","A̱yi ɗa i zuwai n damma nɗu i ta̱ kuwa̱ oɓolo nu unusu u na yaa yuwusan. Nni i ꞌyuwan a̱ usu a na a̱mu ɗaɗa za na n dammai n ri, babu ili i ro i ta̱ kuwa̱ a̱tsuma̱ a̱ nusu ɗu.” ");
INSERT INTO tswNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Reve e ece, “A̱vu gba zane ɗa vu ri?” A̱vu u usu, “A̱mu ɗa vuma na n tsu dansaa ɗu n ri. ");
INSERT INTO tswNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","N ta̱ ni ili i na maa damma aci a̱ ɗu, waru ni ili ya̱ a̱bunda̱ i na mee geꞌeto a aci a̱ ɗu. Amma maa damma ili i na n ri ne ele shi. Adama a na za na lyungu numu amayun a ɗa u tsu dansa kuci, waru n damma ta̱ a̱za̱ o uvaɗi ili i na u damma numu goon.” ");
INSERT INTO tswNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ama e reve a na waa dansaa le adama a Dadaꞌa shi. ");
INSERT INTO tswNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Adama o ndolo a ɗa u damma nle, “Ni i ꞌya̱sa̱n Mawun ma Vuma zuva va akpata,† i ta̱ reve a na a̱mu ɗaɗa za na maa dansaa ɗu n ri. I reve waru n tsu yuwan ili nu ucira u va̱ shi. Ili i na Dada va̱ rito numu ɗa goon n tsu damma. ");
INSERT INTO tswNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Za na lyungu numu to oɓolo na̱ a̱mu. Koto u ka̱ra̱ u lyawa mu a̱ ndeꞌen shi, kuci ɗa waru n tsu yuwan ili i na waa uwwa uyoꞌo u va̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ama a̱ a̱bunda̱ a na a uwwai ili i na Yesu dammai, a̱ usu yi ta̱. ");
INSERT INTO tswNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","A̱vu Yesu damma aza a na a̱ usu niyi, “Ni i lyuwa elime ni itoni yu uritosu u va̱ a̱za̱ e itoni ya amayun a ɗa i ri. ");
INSERT INTO tswNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ne ɗa yee reve amayun, waru amayuꞌun u ta̱ ba̱ɗa̱ ɗu.” ");
INSERT INTO tswNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Reve a̱ usu, “A̱tsu muwun n tsukaya ma Ibrahim n ɗa, koto tso oꞌwo agbashi a ama o ro shi. Cine vu dammai a̱ ta̱ ba̱ɗa̱ tsu?” ");
INSERT INTO tswNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Reve u usu, “N damma ɗu amayun, vuma na yuwain unusu suru aagbashi o unusu a ɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Aagbashi a̱ tsu da̱nu o uꞌwa wu zagbain suru suru shi, amma ulobo wu uꞌwa kuci o uꞌwa wa dada va̱ yi ɗa u tsu da̱na̱. ");
INSERT INTO tswNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Adama o ndolo na̱ Mawun u ba̱ɗa̱ ɗu, i to oꞌwo fa̱a̱n na amayun. ");
INSERT INTO tswNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","N reve ta̱ a na a̱ɗu muwun n tsukaya ma Ibrahim n ɗa, agba i ciga ta̱ yu una mu adama a na i usuyi uritosu u va̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","N ta dansaa ɗu ili i na Dada va̱ roco numu, agba i ta yuwusan ili i na dada ɗu damma nɗu.” ");
INSERT INTO tswNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Reve a̱ usu, “Ibrahim ɗa dada tsu.” A̱vu u damma, “Na̱ a̱ɗu muwun ma Ibrahim n ɗa na amayun, i ta yuwan ili i na Ibrahim yuwain. ");
INSERT INTO tswNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Amayun a ɗa maa dansaa ɗu, amayun e ili i na mu uwwai uba̱ta̱ wa̱ A̱sula̱, a̱ɗu ɗa nda gba i cigai yu una mu. Ibrahim aa yuwan cuꞌun vi ili i ndolo shi. ");
INSERT INTO tswNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Agba a̱ɗu i ta yuwusan ili i na dada ɗu yuwain foyi.” Reve a̱ usu, “A̱tsu a̱girutu a ɗa shi! A̱sula̱ a ɗa Dada va amayun tsu.” ");
INSERT INTO tswNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","A̱vu u damma le, “Na̱ A̱sula̱ a ɗa Dada ɗu, i shi ta ciga mu, adama a na n ta̱wa̱ ta̱ uba̱ta̱ u ɗu diga a̱ A̱sula̱. Agba a̱mu ɗa n ta̱wa̱toyi aciya̱va̱ shi, a̱yi ɗa u lyungu numu. ");
INSERT INTO tswNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","I reve ili i na n damma nɗu shi, adama a na i usuyi uritosu u va̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mekerenkesu ma ɗa dada ɗu, i tsu yuwan ta̱ ili i na u cigai foyi. Diga o ufaru za mona ɗa waru za ve epen ɗa. Babu ili ya amayun a aci a̱ yi. Ili ya aciya̱yi a ɗa u tsu yuwan adanshi, waru ili i na u dammai suru epen a ɗa. Za ve epen ɗa goon shi, amma waru dada ve epen ɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Amma amayun a ɗa maa dansaa ɗu, a̱yi ɗa waru ili i na i zuwai i usu numu shi. ");
INSERT INTO tswNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","A̱tsuma̱ a̱ ɗu, zane ɗa na amayun aa gura reme mu nu unusu? Waru ana maa dansaa ɗu amayun, nye i zuwai i usuyi shi? ");
INSERT INTO tswNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Vuma na A̱sula̱ a ɗa Dada va̱ yi, u tsu zuwa ta̱ atsuvu a Adanshi a̱ A̱sula̱. A̱ɗu gba a̱za̱ a̱ A̱sula̱ a ɗa shi, a̱yi ɗa i zuwai i zuwai atsuvu a̱ ɗu shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","A̱vu aza a Israꞌila a̱ usu, “Tsu ta̱ mejege na̱ tsu damma a̱vu vuma va Samariya† ɗa, waru vu ta̱ no otoni a̱ lima̱ a̱tsuma̱ a̱ wu!” ");
INSERT INTO tswNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Reve Yesu usu, “N ri no otoni a lima̱ shi. N ca ta Dada va̱ tsugbain, a̱vu i ꞌyuwan a ca mu tsugbain. ");
INSERT INTO tswNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","N ri e izami i tsugbain tsa aciya̱va̱ shi. Amma za na cigai n ushi tsugbain ta̱ lo, a̱yi ɗa waru za na aa yuwan ugeꞌetosu. ");
INSERT INTO tswNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Amayun a ɗa maa dansaa ɗu, vuma na yuwain itoni nu uritosu u va̱, wa̱a̱ kuwa̱ shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","A̱vu a damma yi, “Gogo tsu reve ta̱ a na vu ri no otoni a̱ lima̱! Ko Ibrahim na ama̱sula̱ a̱ kuwa̱ ta̱. A̱vu gba vu damma ta̱, ‘Vuma na yuwain itoni nu uritosu u va̱, wa̱a̱ kuwa̱ shi.’ ");
INSERT INTO tswNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","A̱vu vu laꞌa ta̱ dada tsu Ibrahim a̱tsuma̱ a tsugbain? U kuwa̱ ta̱, ne ɗa fo ama̱sula̱. A majiyan ma̱ wu, zane ɗa vaa tarasa vu ri?” ");
INSERT INTO tswNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Reve u usu, “Na̱ n ca aciya̱va̱ tsugbain, tsugbain tso ndolo ili i ɗa shi, ko keꞌen. Dada ɗa vuma na ca numu tsugbain, waru i damma ta̱ a na a̱yi ɗa A̱sula̱ a̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Koto i reve yi shi, amma a̱mu n reve yi ta̱. Na̱ n damma koto n reve yi shi, n to oꞌwo za ve epen tsa̱ a̱ɗu. Amma n reve yi ta̱, waru n tsu yuwan ta̱ itoni ni ili i na u dammai biti. ");
INSERT INTO tswNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Dada ɗu Ibrahim yuwan ta̱ ma̱za̱nga̱ a na wee ene mantsa ma na ma̱a̱ ta̱wa̱. We ene yi ta̱ waru u yuwan ta̱ ma̱za̱nga̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","A̱vu a damma, “Cine vu yuwain ve enei ɗe Ibrahim? Koto vu rawa aꞌwan kupoton shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Reve u usu, “Amayun a ɗa maa dansaa ɗu, kafu a matsan Ibrahim, A̱mu ɗaɗa za na n ri lo.”† ");
INSERT INTO tswNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ana Yesu yuwain adanshi a nda, a̱vu ama a̱ ta̱ɗa̱ atali tsa̱ra̱ o una yi. Reve Yesu wo oɗoru o uta̱, u lyawa A̱a̱ꞌisamapaɗaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu pe a̱tsuma̱ a mmalu, a̱vu we ene vuma na a matsain irumba̱. ");
INSERT INTO tswNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","A̱vu ojoro a̱ yi e ece yi, “Manlu, nye i zuwai a matsain vuma nda irumba̱? Adama o unusu wa̱ yi u ɗa ko adama o unusu u nan dada va̱ yi?” ");
INSERT INTO tswNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Reve u usu, “Vuma nda ri irumba̱ adama o unusu wa̱ yi ko o unusu u nan dada va̱ yi shi. Ne ɗa a matsan niyi tsa̱ra̱ A̱sula̱ o roco ucira wa̱ yi a̱ tyo e ekere a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nu urana, tsu ꞌyuwan tsu ciga tsu lyuwa elime nu ulinga wu za na lyungu numu. Ayin o ta̱ lo a̱ ta̱wa̱ na vuma aa gura linga shi. ");
INSERT INTO tswNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","A̱mu pa a̱tsuma̱ o uvaɗi u nda, a̱mu ɗa n tsu ca ama o uvaɗi ekan.” ");
INSERT INTO tswNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ana u dammai ne, a̱vu u tsuwa̱n ma̱tsa̱n e iɗa, a̱vu u sukuta̱ yi, reve u kene yi ɗaɗa u putalayi vumaꞌa e esu. ");
INSERT INTO tswNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Reve u damma vumaꞌa, “ꞌYa̱wa̱ vu saꞌa esu a̱ wu a Mabata ma Siluwamu.” (Urevu wa “Siluwamu” a̱yi ɗa “Lyungu.”) A̱vu vumaꞌa u ka̱ra̱ u saꞌa. Ana a̱ ka̱mba̱i o uꞌwa, reve we ene ure. ");
INSERT INTO tswNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","A̱vu ama o uba̱ta̱ꞌa̱ na akapi a na e revei u da̱na̱ ta̱ irumba̱ a yuwusan ipati reve e ece, “Vuma ndeɗe ɗaɗa, za na tsu da̱nusu a yuwusan ipati shi?” ");
INSERT INTO tswNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","A̱vu ozo o ro a damma, “A̱yi ɗaɗa.” Akapi gba a damma, “Oꞌo, u rotso ta̱ vuma ndeɗeꞌe.” Reve zavipatiꞌi u reme adansa, “A̱mu ɗaɗa!” ");
INSERT INTO tswNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Reve e ece yi, “Cine vu yuwain ɗaɗa ve eneshe gogo?” ");
INSERT INTO tswNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ɗaɗa u usuyi, “Vuma na a̱ tsu ɗe Yesu ɗa reꞌwetoi ma̱bula̱ a̱vu u putala mu e esu. Reve u damma mu, ‘ꞌYa̱wa̱ a Mabata ma Siluwamu vu saꞌa esu a̱ wu.’ Ana n ꞌya̱wa̱ n saꞌai, reve me ene.” ");
INSERT INTO tswNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","A̱vu e ece yi, “Te ɗa vumaꞌa?” A̱vu u usu, “N reve shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","A̱vu amaꞌa a̱ ꞌya̱wa̱a̱ Afarishi na̱ vuma na da̱na̱i irumba̱ꞌa̱. ");
INSERT INTO tswNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Urana u na Yesu foɓoi ma̱bula̱ a̱vu u ka̱mba̱to yi gbaga Ashibi a ɗa a̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ɗaɗa Afarishi o ro e ecei vumaꞌa, “Te ɗa vu tsura̱i yeni ya̱ wu?” Reve u usu, “Vuma ro putala mu ta̱ ma̱bula̱ mo uta̱nu e esu, a̱vu n saꞌa le, gogo a̱mu ɗa nda e eneshe.” ");
INSERT INTO tswNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","A̱vu Afarishi o ro a damma, “A̱yi vuma nda Yesu, wu uta̱ uba̱ta̱ wa̱ A̱sula̱ shi, adama a na u yuwan tsutoni na̱ wila̱ wa Ashibi shi.” Ozo o ro gba a damma, “Vuma na ri nu unusu waa gura yuwan cuꞌun vi iroci yi ili ya asalama o ndolo shi.” Adama o ndolo a̱ usula̱i shi. ");
INSERT INTO tswNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","A̱vu e ecishe vumaꞌa, “Nye vaa damma adama a vuma na ka̱mbuwa̱i esu a̱ wu gbaga?” A̱vu vuma u usu, “A̱yi vumava̱sula̱ ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Agba azagbain a Israꞌila a̱ usu a na u da̱na̱i irumba̱ shi, a̱vu u ka̱ra̱ eneshe gogo shi. Reve a̱ lyungu e ɗewe le nan dada va̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","A̱vu e ece le, “Ulobo u ɗu u ɗa ndaꞌa? I damma u da̱na̱ ta̱ irumba̱ ana i matsan niyi. Cine tsa ɗa u yuwain ɗaɗa we eneshe gogo?” ");
INSERT INTO tswNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Reve nan dada va̱ yi a̱ usu, “Tsu reve ta̱ a na a̱yi mawun ma̱ tsu ma ɗa, waru tsu reve ta̱ tsu matsan yi ta̱ irumba̱. ");
INSERT INTO tswNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Amma tsu reve ko cine tsa ɗa u yuwain we eneshe gogo shi. Waru tsu reve za na ka̱mba̱to niyi gbaga shi. Ece niyi. U rawa ta̱ aꞌwan a na waa gura damma ɗu na aciya̱yi.” ");
INSERT INTO tswNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","A damma ta̱ ne adama a na a ta uwwusa wovon wa aza a Israꞌila. Aza a Israꞌila a damma ta̱ ɗe vuma na dammai Yesu Zamawawa ɗa, wa̱a̱ da̱shi uwisa a̱ a̱a̱ꞌisa̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","A̱yi ɗa i zuwai nan dada va̱ yi a dammai, “U rawa ta̱ u yuwan adanshi na aciya̱yi. Ece niyi!” ");
INSERT INTO tswNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","A̱vu aza a Israꞌila e ɗewishe yi we ire a̱vu a damma, “Kucina na̱ A̱sula̱ reve vu damma tsu amayun! Tsu reve ta̱ vuma na ka̱mba̱to nuwu gbaga nda za vu unusu ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","A̱vu u usu, “N reve ko za vu unusu ɗa shi. Apa ili i ta̱ i na n revei: N da̱na̱ ta̱ irumba̱ agba gogo n te eneshe.” ");
INSERT INTO tswNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","A̱vu e ece yi, “Nye u yuwaan nuwu? Cine tsa ɗa u ka̱mba̱toi esu a̱ wu gbaga?” ");
INSERT INTO tswNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Reve u usu, “N damma ɗu ta̱ ɗe, agba i zuwaa mu atsuvu shi. Cine i cigai yu uwwisa? I ciga ta̱ yoo oꞌwo a̱za̱ e itoni a̱ yi fo?” ");
INSERT INTO tswNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","A̱vu e isula yi adansa, “A̱vu ɗa za vi itoni va̱ yi, agba a̱tsu a̱za̱ e itoni ya Musa a ɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tsu reve ta̱ A̱sula̱ a yuwaan ta̱ Musa adanshi, agba a̱tsu tsu reve lyuci na vuma nda uta̱i shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","A̱vu u usu, “Ili ya asalama i ɗa ndaꞌa! U ka̱mba̱to ta̱ esu a̱ va̱ gbaga, agba a̱ɗu i reve uba̱ta̱ u na wu uta̱i shi. ");
INSERT INTO tswNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","A̱tsu tsu reve ta̱ A̱sula̱ a tsu zuwaa a̱za̱ o unusu atsuvu shi. Amma u tsu zuwaa ta̱ aza a na a yuwusaan yi a̱ga̱nda̱ a̱vu waru a yuwan ili i na u damma nle atsuvu. ");
INSERT INTO tswNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ana A̱sula̱ a yuwain uvaɗi, koto a̱ tsura̱ vuma na kpa̱tuꞌwa̱i esu a vuma na a matsain irumba̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Na̱ vuma na A̱sula̱ a̱ lyunguyi ɗa shi, ko ili i ta̱ waa gura yuwan shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Reve a damma yi, “A̱vu za vu unusu ɗa diga urana u na a matsan nuwu! Vu ta a majiyan vu to rito tsu ili i ro?” A̱vu a damma yi wa̱a̱ da̱shi uwa a̱ a̱a̱ꞌisa̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ana Yesu uwwai ili i na i farai, a̱vu u zami vumaꞌa, a̱vu we ece yi, “Vu usu ta̱ Mawun ma Vumaꞌa?” ");
INSERT INTO tswNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Reve u usu, “Zagbain, damma mu ko zane ɗa u ri, tsa̱ra̱ n usu yi fo.” ");
INSERT INTO tswNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Reve u damma yi, “Ve ene yi ta̱ ɗe, a̱yi ɗa waru vuma na a yuwusan adanshi na̱ a̱vu gogo.” ");
INSERT INTO tswNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ɗaɗa u dammai, “Zagbain, n usu ta̱!” A̱vu u yuwaan Yesu a̱ga̱nda̱. ");
INSERT INTO tswNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","A̱vu Yesu damma yi, “N ta̱wa̱ ta̱ tsa̱ra̱ n zangaɗa ama o uvaɗi a nda. N ta̱wa̱ ta̱ tsa̱ra̱ n ca nrumba̱ yeni, waru n roco aza a na a yuwusan majiyan a̱ te inda ele gba nrumba̱ n ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Afarishi a na a̱ ri lo a uwwa yi ta̱, a̱vu e ece yi, “Vu ta dansa a̱tsu nrumba̱ n ɗa?” ");
INSERT INTO tswNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","A̱vu u usu, “Na̱ nrumba̱ n ɗa i ri, a̱ shi a̱ tsura̱ ɗu nu unusu shi. Amma ana i dammai i te inda, u ta dansa i buwa ta̱ pe a̱tsuma̱ o unusu u ɗu.” ");
INSERT INTO tswNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","A̱vu Yesu damma, “Amayun a ɗa maa dansaa ɗu, evu na̱ a̱za̱ a̱ nga̱la̱la̱i a ɗa goon a tsu uwa ni isula wu uba̱ta̱ u na a̱ nla̱sa̱ ikyon, agba a tsu uwa nu una̱ntsu shi. ");
INSERT INTO tswNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Za na tsu uwa nu una̱ntsu a̱yi ɗa za va aguɓa e ikyoꞌon. ");
INSERT INTO tswNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Za vi ipiri yu una̱ntsu tsu kpa̱tuꞌwa̱a̱ le ta̱. Waru ikyon yi za biti e reve ta̱ uɗyo wa̱ yi. U tsu ɗe ta̱ ikyon ya̱ yi na ala e le reve a̱ kuru yi o uta̱. ");
INSERT INTO tswNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Na̱ wu uta̱a̱ le suru reve u uwa elime e le, reve gba a̱ kuru yi adama a na e reve ta̱ uɗyo wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Agba a̱a̱ kuru vuma ro shi, shede a suma yi, adama a na e reve uɗyo wa̱ yi shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu yuwaan le ta̱ iroci i nda, agba a gura reve ili i na waa dansa shi. ");
INSERT INTO tswNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ɗaɗa Yesu dammisai, “Amayun a ɗa maa dansaa ɗu: A̱mu ɗa una̱ntsu wu uba̱ta̱ wi ikyon. ");
INSERT INTO tswNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ama a na a̱ ta̱wa̱i elime a̱ va̱ suru evu a ɗa na̱ a̱za̱ a̱ nga̱la̱la̱i. Ikyon i poloo le atsuvu shi. ");
INSERT INTO tswNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","A̱mu ɗa una̱ntsu, waru za na uwai nu uba̱ta̱ u va̱ a ta wawa yi. Waru u ta gura uwa wu uta̱ u tsura̱ anlya a na waa tama. ");
INSERT INTO tswNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Vivu tsu ta̱wa̱ ta̱ adama wi iva̱ wu una waru u lungusa̱, a̱mu gba n ta̱wa̱ ta̱ n ca wuma adama a̱ tsura̱ wuma suru suru. ");
INSERT INTO tswNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“A̱mu ɗa za va aguɓa a̱ a̱ɓula̱. Za va aguɓa a̱ a̱ɓula̱ u tu ufoɓu u ca wuma wa̱ yi adama u geshe ikyon ya̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Za na a tarai aguɓa u ri tsu za vi ikyoꞌon shi. Na̱ we ene mekerenkesu a̱ ta̱wa̱, u tsu suma ta̱ reve u lyawa lo ikyoꞌon. Reve mekerenkesu ma saɓa le a̱vu u beteꞌwe le. ");
INSERT INTO tswNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Vumaꞌa u tsu suma ta̱ adama a na ulinga wa atsupu a ɗa waa yuwusan goon. Agba ko ili i damaton yi ni ikyoꞌon shi. ");
INSERT INTO tswNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“A̱mu ɗa za va aguɓa a̱ a̱ɓula̱. N reve ta̱ ikyon i va̱, cine Dada va̱ reve numu. Ikyon i va̱ waru e reve mu ta̱, cine n revei Dadaꞌa. N usu ta̱ n ca wuma u va̱ adama n kamba ikyoꞌon. ");
INSERT INTO tswNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","N ta̱ ni ikyon i ro i na i ri a̱tsuma̱ a aza a nda shi, waru n ciga n ꞌyuwan n ta̱wa̱ ne ele fo. A ta uwwa uɗyo u va̱, reve suru nle o oꞌwo oɓolo a̱ ta̱ na̱ za va aguɓa a̱ ta̱. ");
INSERT INTO tswNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Dadaꞌa u ciga mu ta̱ adama a na n usu ta̱ n ca wuma u va̱, tsa̱ra̱ n ta̱wa̱ n ushiyisa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ko za lo a usa mu wuma u va̱ shi. O ucigu u va̱ ɗa n cayi. N ta̱ nu ucira u na maa ca wuma u va̱ waru nu ucira u na ma̱a̱ ushiyisa̱ yi, ununa Dada va̱ damma numu n yuwan.” ");
INSERT INTO tswNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Adama a adanshi a̱ yi o ndolo, reve aza a Israꞌila e remishe nwasanlai va̱ni le. ");
INSERT INTO tswNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ozo o ro le na̱ a̱bunda̱ a damma, “Otoni a̱ lima̱ a uwa yi ta̱, reve o oꞌwoto yi ajaarata. Adama a̱ nye yaa zuwusaa yi atsuvu?” ");
INSERT INTO tswNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ozo o ro gba a damma, “Vuma na otoni a̱ lima̱ a jaaratoi tsu yuwan adanshi ne tsunda shi. Otoni a̱ lima̱ a ta gura zuwa irumba̱ ye ene?” ");
INSERT INTO tswNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","A̱vu mantsa mo uta̱nu ma rawa, mantsa ma na a tsu yuwan A̱buki o Ucuwusan nu Ucasu wa̱ A̱a̱ꞌisamapaɗa a̱ Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","A mantsaꞌa, Yesu shi ta̱ a mmalu uba̱ta̱ u na a̱ tsu ɗe Ma̱kisa̱ ma̱ Sulemanu a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Reve azagbain a Israꞌila o ɓoloto zuzu na̱ a̱yi, a̱vu a damma, “Cine tsa ɗa va̱a̱ da̱na̱ a zuwusa tsu majiyan, zane ɗa vu ri na amayun? Na̱ a̱vu ɗaɗa Kristi Zamawawaꞌa, vu damma tsu mejege.” ");
INSERT INTO tswNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Reve u usu, “N damma ɗu ta̱ ɗe agba i usu shi. Linga va asalama na maa yuwusan a̱tsuma̱ a ala a Dada va̱ o roco ta̱ ko zane ɗa n ri. ");
INSERT INTO tswNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Agba i usu shi, adama a na a̱ɗu ikyon i va̱ i ɗa shi. ");
INSERT INTO tswNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ikyon i va̱ i tsu uwwa ta̱ uɗyo u va̱. N reve le ta̱, ele waru a̱ tsu kuru mu ta̱. ");
INSERT INTO tswNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","N ca le ta̱ wuma u na woo koto shi, waru a̱a̱ kuwa̱ shi. Ko za lo aa gura usa le o ukere u va̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Dada va̱ ɗa ca numu ele. U laꞌa ta̱ koyan, waru babu za na aa gura usa le e ekere a Dada va̱. ");
INSERT INTO tswNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Dadaꞌa na̱ a̱mu ili i ta̱ i ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ɗaɗa waru azagbain a Israꞌila a tarai atali azama o una yi. ");
INSERT INTO tswNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","A̱vu u damma le, “N roco ɗu ta̱ ili i saꞌani i na Dada va̱ lyungu numu n yuwan na̱ a̱bunda̱. Adama e ili ya asalama i ne i ɗa i cigai i vuvara mu?” ");
INSERT INTO tswNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Reve a̱ usu, “Tsu ciga tsu vuvara wu adama e ili i saꞌani i ro shi, amma adama a na vu yuwain adanshi a vama† e ekere a̱ A̱sula̱. A̱vu vaɗilima̱ ɗa, amma vu ka̱mba̱to ta̱ aciya̱wu una̱ta̱ na̱ A̱sula̱!” ");
INSERT INTO tswNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","A̱vu u usu, “A ɗana ta̱ a̱tsuma̱ a̱ Wila̱ a̱ ɗu a na A̱sula̱ a damma ta̱, ‘A̱ɗu musula̱ n ɗa.’ ");
INSERT INTO tswNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tsu reve ta̱ ili i na Adanshi a̱ A̱sula̱ a dammai suru wo oꞌwo ta̱ amayun babu ukotu. Reve A̱sula̱ e ɗe ama o ndolo musula̱, ama a na u cayi ikaka ya̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","A̱mu gba, Dadaꞌa u ɗangwa mu ta̱ adama o ulinga wa̱ a̱ɓula̱, reve u lyungu mu a̱tsuma̱ o uvaɗi. Adama a̱ nye i ɗa gba yaa dansa n ta yuwusan adanshi a vama e ekere a̱ A̱sula̱ o una̱ u na n dammai, ‘A̱mu Mawun ma̱ A̱sula̱ ma ɗa?’ ");
INSERT INTO tswNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nna̱ maa yuwusan ili i na Dada va̱ ciga numu n yuwan shi, she i usu mu wan. ");
INSERT INTO tswNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Amma na̱ n ta yuwusan ili i na Dada va̱ aa yuwusan, i usu mu adama e ili i ndolo, ko na̱ ya̱a̱ usu ili i na n dammai shi. Reve i reve amayun a na Dadaꞌa ili i ta̱ i ɗa na̱ a̱mu, a̱mu waru ili i ta̱ i ɗa na̱ Dadaꞌa.” ");
INSERT INTO tswNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Reve a uwa mpolo a na ee remishe Yesu, a̱vu gba u laꞌa. ");
INSERT INTO tswNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Reve u ꞌya̱wa̱ u pasa Uɗolu wa̱ Urdu a̱ tyo uba̱ta̱ u na Yahaya farai urumbusu, reve wi isawan ɗe neꞌen. ");
INSERT INTO tswNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","A̱vu ama na̱ a̱bunda̱ a̱ ta̱wa̱ uba̱ta̱ wa̱ yi, adansa va̱ni le, “Yahaya yuwan ulinga wa asalama ko za ta̱ shi, amma ili i na u dammai adama a vuma nda suru amayun a ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Reve ama a na a̱ ri lo na̱ a̱bunda̱ a̱ usu Yesu. ");
INSERT INTO tswNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","A yuwan ta̱ vuma ro na a̱ tsu ɗe Liꞌazaru a̱ lyuci va Batanya ɗa u shi. U da̱na̱ ta̱ oɓolo na̱ muwun ma̱ a̱na̱wu me esheli ma̱ yi Meri† na̱ Marta. A̱yi Meri nda a̱yi ɗa za na ta̱wa̱ tsuwa̱yin Zagbain maniꞌin ma̱ ma̱guru a ana, a̱vu u tasa le na̱ a̱nji a̱ yi. Urana u ro Liꞌazaru banakan ta̱. ");
INSERT INTO tswNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","A̱vu Meri na̱ Marta a̱ lyungu vuma ro damma Yesu, “Zagbain, vuma na vu cigai banakan ta̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ana Yesu uwwai ne, a̱vu u damma, “Ubanakuꞌun woo una yi shi. Ili i nda i fara ta̱ tsa̱ra̱ a̱ ta̱wa̱a̱ A̱sula̱ na̱ tsugbain. A̱mu waru Mawun ma̱ A̱sula̱, n tsura̱ tsugbain adama e ili i ndolo.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu ciga ta̱ Marta na azawawaꞌa a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ana wu uwwai a na Liꞌazaru tu ubanakun, u da̱shi ta̱ asisa pe ayin e re. ");
INSERT INTO tswNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","A̱vu u damma ojoro a̱ yi, “Lyawai tsu ka̱mba̱i Yahuda.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","A̱vu gba a damma yi, “Manlu, a yashi i nda i ɗa azagbain a Israꞌila a̱ shi a cigai a vuvara wu, ɗaɗa vu cigai vu ka̱mba̱ ɗe?” ");
INSERT INTO tswNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","A̱vu u usu, “Tsu ta̱ ni irumu kupa ne ejere e ekan a̱tsuma̱ o urana u ta̱. Ne ekan o lo, ama a ta wala agba a̱ ta̱ɗa̱tsa̱ shi. E te ene adama a na ekan a̱ ta̱ pe o uvaɗi. ");
INSERT INTO tswNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Agba na a yuwan mmalu na ayin, a̱ ta̱ ta̱ɗa̱tsa̱, adama a na babu ekan.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ɗaɗa u damma nle, “Iꞌutsa̱ i tsu Liꞌazaru ta a nlavu, n ta̱ ꞌya̱wa̱ ɗe ya̱ꞌa̱ yi n jisan yi.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Reve a damma, “Zagbain nu u ri a nlavu, u ta dansa u ta̱ tsura̱ opocino!” ");
INSERT INTO tswNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","A ta jiyasan Liꞌazaru nlavu ma amayun n ɗa yi, agba a adanshi e Yesu u ta dansa u kuwa̱ ta̱ ɗe. ");
INSERT INTO tswNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Reve wu uta̱ le eteshe u damma, “Liꞌazaru kuwa̱ ta̱ ɗe. ");
INSERT INTO tswNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Adama a̱ ɗu a ɗa maa yuwusan ma̱za̱nga̱ a na n ri oɓolo na̱ a̱yi shi. Adama e ili i ndolo i to rito i usu mu. Ta̱wa̱i tsa̱ra̱ tsu ꞌya̱wa̱i uba̱ta̱ u na u ri gogo.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","A̱vu oojoro† o ro a na a̱ tsu ɗe Toma (za na a̱ tsu ɗe “Mepishe”) u damma akapi, “Tsu shoyin manluꞌu suru ntsu, tsa̱ra̱ tsu kuwa̱i oɓolo na̱ a̱yi!” ");
INSERT INTO tswNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ana Yesu rawai, u cina ta̱ cina a̱ ciɗo ɗe Liꞌazaru hali rana na̱shi. ");
INSERT INTO tswNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Aza a Israꞌila† a̱ ꞌya̱wa̱ ta̱ ɗe na̱ a̱bunda̱ tsa̱ra̱ a̱ ca̱sa̱ Marta na̱ Meri adama a mawun ma̱ a̱na̱wu me le. Batanya ta̱ zuzu na̱ Urishelima, alanga e le mili re ɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ana Marta uwwai Yesu ta̱ lo a̱ ta̱wa̱, wu uta̱ ta̱ tsa̱ra̱ u gaꞌaton yi, Meri gba wi isawan ta̱ pe o uwa. ");
INSERT INTO tswNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","A̱vu Marta damma yi, “Zagbain, na̱ vu shi pa, mawun ma̱ a̱na̱wu ma̱ va̱ ma̱ shi a̱ kuwa̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Amma ko gogo n reve ta̱ A̱sula̱ a ta ca wu ili i na vu pati niyi suru.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","A̱vu u damma, “Mawun ma̱ a̱na̱wu ma̱ wu u ta̱ ꞌyon a̱vu u yuwisan wuma.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","A̱vu u usu, “N reve ta̱ u ta̱ ꞌyon a̱vu waru u yuwan wuma o urana wu ukosu, a mantsa ma na A̱sula̱ a̱a̱ ꞌya̱sa̱n a̱kwa̱kwa̱ suru.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Reve u damma yi, “A̱mu ɗa uꞌya̱sa̱sa̱n wa̱ a̱kwa̱kwa̱ na̱ wuma. Aza a na waru a̱ usu numu a ta yuwan wuma ko a̱ shi a̱ kuwa̱. ");
INSERT INTO tswNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Vuma na ri wuma a̱vu u usu mu wa̱a̱ kuwa̱ shi. Marta vu usu ta̱ ne?” ");
INSERT INTO tswNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Reve u usu, “Ee, Zagbain. N usu ta̱ a na a̱vu ɗa Kristi Zamawawa, za na a̱yi ɗa Mawun ma̱ A̱sula̱, waru a̱yi ɗa za na ri lo a̱a̱ ta̱wa̱ a̱tsuma̱ o uvaɗi.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ana Marta dammai ne, a̱vu u ka̱mba̱ u yuwan adanshi na̱ mawun ma̱ a̱na̱wu ma̱ yi Meri goon. A̱vu u damma, “Manluꞌu u ta̱ pa, waru u te ɗesu wu.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ana Meri uwwai tsundolo, a̱vu u ꞌyoshin u ka̱ra̱ a̱ tyo uba̱ta̱ wa̱ Yesu. ");
INSERT INTO tswNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Koto u shi u rawa a̱ lyuciꞌi shi, amma u buwa ta̱ ɗe uba̱ta̱ u na Marta cina niyi. ");
INSERT INTO tswNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ama na̱ a̱bunda̱ a̱ ta̱wa̱ ta̱ tsa̱ra̱ a̱ ca̱sa̱ le, ana e enei Meri uta̱i goꞌo u lyawai uꞌwaꞌa, a jiyan ta̱ gashi u ta̱ ꞌya̱wa̱ uba̱ta̱ wa aason tsa̱ra̱ u shon. Ɗaɗa o toni niyi. ");
INSERT INTO tswNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","A̱vu Meri rawa uba̱ta̱ u na Yesu da̱na̱i. Ana we ene niyi, u kingyo ta̱ a̱ ma̱ka̱ka̱n ma̱ yi, a̱vu u damma, “Zagbain, na̱ vu shi pa, mawun ma̱ a̱na̱wu mo ulobo ma̱ va̱ ma̱ shi a̱ kuwa̱ shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ana Yesu ene niyi e mesun, a̱vu waru we ene cine ama a̱ ri e mesun oɓolo na̱ a̱yi fo. U yuwan ta̱ a̱tsumola̱ngu a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Reve we ece, “Te ɗa gba i ciɗo niyi?” A̱vu a damma yi, “Zagbain, ta̱wa̱ ve ene uba̱ta̱ꞌa̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Reve u shon. ");
INSERT INTO tswNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Reve ama a na a̱ da̱na̱i zuzu na̱ a̱yi a damma, “Ka̱lyuwa̱i cine u ciga niyi lon.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","A̱vu ozo o ro e le a damma, “U ca ta̱ irumba̱ yeni. Amayun nu u shi lo u shi a lyawa Liꞌazaru kuwa̱ shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu buwa ta̱ na̱ a̱tsumola̱ngu a̱ a̱bunda̱ lon. A̱vu u ka̱ra̱ a̱ ꞌya̱wa̱ a aason, za na wungu u ɗa u da̱na̱i a̱tsuma̱ a aatali na aatali a na a̱ bunda̱la̱i tsa̱ra̱ o to uꞌuwataꞌa. ");
INSERT INTO tswNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Reve u damma, “Bunda̱la̱i aataliꞌi a̱ ngeꞌen.” Reve Marta damma, “Zagbain, vu reve ta̱ a na Liꞌazaru kuwa̱i ɗe hali rana na̱shi na ka̱ra̱i, gogo u ta̱ fara a shamusa.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","A̱vu u damma yi, “Vu cuwan cine n damma nuwu a na na̱ vu ca okolo, vu te ene tsugbain tsa̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","A̱vu a̱ bunda̱la̱ aataliꞌi a̱ ngeꞌen. Reve u ka̱lyuwa̱ zuva uba̱ta̱ wa̱ A̱sula̱ a̱vu u damma, “Dada, n godyo ta̱ a na vu uwwa numu. ");
INSERT INTO tswNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","N reve ta̱ vu tsu uwwa mu ta̱ kuci, amma n damma ta̱ ne adama a ama a na a̱ ri pa uɓolotowu zuzu na̱ a̱mu. N ciga le ta̱ e reve a na vu lyungu numu.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ana Yesu kotoi avasa, a̱vu u saala, “Liꞌazaru, uta̱!” ");
INSERT INTO tswNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Reve wu uta̱ a mmalu. A katala ta̱ ana ne ekere a̱ yi no okoro, a̱vu a katalaa yi okoro o urewesu. A̱vu Yesu damma le, “Ba̱ɗa̱ niyi a̱vu i lyawa yi u ka̱ra̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ama a̱ a̱bunda̱ a na a̱ ta̱wa̱i a̱ ka̱lyuwa̱ Meri e ene ta̱ ili i na Yesu yuwain, a̱vu a̱ usu yi. ");
INSERT INTO tswNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Amma ozo o ro e le gba a̱ ꞌya̱wa̱ ta̱ a damma Afarishi ili i na Yesu yuwain. ");
INSERT INTO tswNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","A̱vu nan ganu a gbagbain na Afarishi e ɗe iɓolo ya Azagbain a Mbara† uba̱ta̱ u ta̱ reve a damma le, “Nye tsaa yuwain? Vuma nda ta yuwusan iroci yi ili ya asalama ya̱ a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Na̱ tsu lyawa yi u lyuwa elime na̱ mayan me ili i nda, ama suru a̱ ta̱ usu yi. A̱soja a̱ Roma a̱ ta̱ ta̱wa̱ a̱ lungusa̱ A̱a̱ꞌisamapaɗa ni iɗa i tsu.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kayafa vuma ta̱ ɗa a̱tsuma̱ a Azagbain a Mbara† za na da̱na̱i aabara a nan ganu a̱tsuma̱ a aaꞌwan o ndolo, a̱vu u damma, “Ko ili i ta̱ i reve shi! ");
INSERT INTO tswNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Cine tsa ɗa yaa lyawa a̱ lungusa̱ iɗaꞌa suru? Lyawai vuma nda kuwa̱, tsa̱ra̱ ama suru a̱ da̱na̱ wuma.” ");
INSERT INTO tswNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Majiyan ma nda mo uta̱ a asuvu a Kayafa shi. Amma adama a na a̱yi ɗa u da̱na̱i aabara a nan ganu a aaꞌwan o ndolo, u yuwisan ta̱ adanshi e ili i na yaa fara: U dansa ta̱ a na Yesu ta̱ kuwa̱ adama a aza a Israꞌila suru. ");
INSERT INTO tswNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ko na̱ ne Yesu a̱a̱ kuwa̱ adama a aza a Israꞌila goon shi. U ta̱ kuwa̱ tsa̱ra̱ u ɓoloto muwun ma̱ A̱sula̱ o oꞌwo za ta̱, aza a na a̱ ri ubazu a̱tsuma̱ o uvaɗi. ");
INSERT INTO tswNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Urana u ndolo u ɗa a farai izami yu ure u na oo una yi. ");
INSERT INTO tswNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Adama o ndolo, Yesu yuwan mmalu a̱tsuma̱ a Yahuda a alanga eteshe shi, a̱vu u lyawa Urishelima. U ka̱ra̱ ta̱ a̱ tyo a̱ lyuci va Ifaramu, za na ri a̱ ngeꞌen mu una, a̱vu u da̱nu ɗe oɓolo no ojoro a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mantsaꞌa ma yuwan ta̱ zuzu na̱ yashi ya̱ A̱buki a Mapasa. Ama a̱ a̱bunda̱ aza a na a̱ da̱na̱i a̱ mulyuci n kekeꞌen a̱ ka̱ra̱ ta̱ a̱ tyo Urishelima kafu mantsa ma̱ a̱bukiꞌi, tsa̱ra̱ a̱ ka̱mba̱to aciyele cece ununa Wila̱ u damma nle a yuwan. ");
INSERT INTO tswNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","A̱ shi ta̱ a ciga e ene Yesu, amma ele pe a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗa, a̱vu e ecelei va̱ni le, “Nye i ɗa majiyan ma̱ ɗu? U ta̱ ta̱wa̱ uba̱ta̱ wa̱ a̱bukiꞌi?” ");
INSERT INTO tswNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","A̱vu nan ganu a gbagbain na Afarishi a damma amaꞌa a na na̱ vuma ro ene Yesuꞌu, vumaꞌa u ta̱wa̱ u damma le. A̱vu a̱ ta̱wa̱ e reme yi. ");
INSERT INTO tswNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ana u buwai rana ta̱li a fara A̱buki a Mapasa, a̱vu Yesu ka̱ra̱ a̱ tyo Batanya, reve u rawa o uꞌwa wa Liꞌazaru, za na u ꞌya̱sa̱in a̱tsuma̱ a̱ a̱a̱kwa̱kwa̱. ");
INSERT INTO tswNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Reve o foɓoo yi pe malyuwaa. Marta ɗa ta̱wa̱i ni ilyalyaꞌa, Liꞌazaru waru u shi ta̱ oɓolo na aza a na a lyuwai oɓolo na̱ Yesu. ");
INSERT INTO tswNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Reve Meri tara meden ma maniꞌin ma̱ ma̱guru, za vi ikebe lon, a̱vu u tsun yi a ana e Yesu. Reve u tasa le na̱ a̱nji a̱ yi. Reve ma̱guru mo shiton uꞌwaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Oojoro o ro za na a̱ tsu ɗe Yahuza Iskariyoti shi ta̱ lo. A̱yi ɗa za na aa wina Yesu, a̱vu u damma, ");
INSERT INTO tswNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Maniꞌin mo ndolo ma ta rawa ikebe i na i rawai ikebe yu ulivu ukpakutaꞌatsu (300). A̱ shi ta wina yi reve a ca alambi ikebeꞌe.” ");
INSERT INTO tswNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Agba Yahuza yuwan adanshi a alambi na amayun shi. U damma ta̱ ne ana wo oꞌwoi a̱yi vivu ɗa. A̱yi ɗa u da̱na̱i za vu uzuwa wi ikebe, waru u tsu tarasa ta̱ ikebe pe adama a aciya̱yi. ");
INSERT INTO tswNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","A̱vu gba Yesu damma, “She vu damaton yi wan. U yuwan ta̱ ne e ifoɓi ya̱ a̱ciɗa̱ a̱ va̱. ");
INSERT INTO tswNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","I ta̱ da̱na̱ na alambi kuci, agba ya̱a̱ da̱na̱ oɓolo na̱ a̱mu kuci shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ana ama a uwwai a na Yesu rawa ta̱, a̱ ta̱wa̱ ta̱ na̱ a̱bunda̱ adama e ene Yesu na̱ Liꞌazaru, vuma na u ꞌya̱sa̱in a̱tsuma̱ o ukwa̱. ");
INSERT INTO tswNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ama na̱ a̱bunda̱ a lyawa ta̱ itoni i nan ganu va aza a Israꞌila, reve a uwa itoni ya̱ Yesu adama a Liꞌazaru. Ili i ndolo i ɗa i zuwai nan ganu a gbagbain a yuwain ifoɓi i na oo una Liꞌazaru fo. ");
INSERT INTO tswNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ana usana u tawai, reve oɓolo a ama na̱ a̱bunda̱ a na a̱ ta̱wa̱i adama a̱ A̱buki a Mapasa† a uwwa a na Yesu ta̱ lo a̱ ta̱wa̱ Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ɗaɗa a tarai ashuwa-shuwa reve a̱ ꞌya̱wa̱ a gaꞌan na̱ Yesu, a yisaali, “Husana!† A ciɓala A̱sula̱!” “A̱sula̱ a zuwaa za na ta̱wa̱i a̱tsuma̱ a ala a̱ A̱sulazuva abaꞌun!” “A̱sula̱ a zuwaa Mogono ma Israꞌila abaꞌun!” ");
INSERT INTO tswNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","A̱vu Yesu zami molloli reve u kumba yi. A̱yi ɗa ili i na Zakariya vumava̱sula̱ dammai, ");
INSERT INTO tswNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ama a̱ Urishelima she yu uwwa wovon wan! Mogono ma̱ ɗu mo ta̱ lo a̱ ta̱wa̱, waru u ta kumba molloli.” ");
INSERT INTO tswNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","A mantsa mo ndolo, ojoro a̱ yi a gura reve ili i ndolo shi. Amma a̱ tyo ɗe a mantsa ma na a̱ ꞌya̱sa̱n niyi a̱ tyo a tsugbain, reve a cuwan a na Adanshi a̱ A̱sula̱ a dammai ne adama a̱ yi, waru a yuwaan yi ta̱ ili i nda. ");
INSERT INTO tswNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ama na̱ a̱bunda̱ a̱ shi ta̱ oɓolo na̱ a̱yi, ana u ꞌya̱sa̱in Liꞌazaru a̱tsuma̱ a̱ a̱kwa̱kwa̱, a̱vu u damma yi wu uta̱ a aason. A̱ shi ta̱ a dansaa ozo o ro ili i na Yesu yuwain. ");
INSERT INTO tswNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ama na̱ a̱bunda̱ o uta̱ ta̱ aa cina yi, adama a na a uwwai ili ya asalama i nda. ");
INSERT INTO tswNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ɗaɗa Afarishi† a dammulai, “Ye ene ta̱, tsu tsura̱ ulyuwu wa aci shi suru suru! Ka̱lyuwa̱i, uvaɗi suru u to tono yi!” ");
INSERT INTO tswNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nheleni† n ro n ꞌya̱wa̱ ta̱ fo Urishelima a yuwan a̱ga̱nda̱ a mantsa ma̱ A̱buki a Mapasaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Reve a̱ ꞌya̱wa̱ uba̱ta̱ wa̱ Filibu (vuma na uta̱i diga a̱ lyuci va Besaida a̱tsuma̱ a̱ Ga̱lili) a̱vu a damma, “Manlu, tsu ciga ta̱ tse ene Yesu.” ");
INSERT INTO tswNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","A̱vu Filibu ꞌya̱wa̱ u damma Andarawu, reve ele ra a̱ ꞌya̱wa̱ a damma Yesu. ");
INSERT INTO tswNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","A̱vu u damma le, “Mantsa ma yuwan ta̱ ana Mawun ma Vuma† ma̱a̱ ushi tsugbain tsa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Amayun a ɗa maa dansaa ɗu, cuꞌun vu shina ta̱ na riya̱i e iɗa waa ka̱mba̱ a̱bunda̱ shi, she nu u kuwa̱. Agba nu u kuwa̱, u ta matsan a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Za na cigai wuma wa̱ yi a̱tsuma̱ o uvaɗi u nda u ta lamba yi. Za na wasain wuma wa̱ yi o uvaɗi u nda u ta̱ tsura̱ wuma u na woo koto shi. ");
INSERT INTO tswNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Za na cigai u yuwaan mu tsugbashi suru, u ciga u ꞌyuwan u ta̱wa̱ u kuru mu, adama aagbashi a̱ va̱ a̱ da̱na̱ oɓolo na̱ a̱mu uba̱ta̱ u na n ri suru. Waru Dada va̱ ta ca za na yuwaan numu tsugbashi suru tsugbain.” ");
INSERT INTO tswNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","A̱vu Yesu lyuwa elime na adanshi, “Gogo nda n ta̱ a̱tsuma̱ a addama. N damma, ‘Dada wawa mu na̱ mantsa ma nda?’ Ne ɗa shi, n ta̱wa̱ ta̱ a mantsa ma nda adama a nda, adama n sowo a̱tsuma̱lima̱. ");
INSERT INTO tswNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dada, roco ama tsugbain tsa̱ wu!” Ɗaɗa uɗyo wu uta̱i diga zuva a̱vu u damma, “N roco ta̱ ɗe cine n ri na̱ tsugbain waru n ta̱ da̱shi roco.” ");
INSERT INTO tswNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Oɓolo a ama a na a̱ da̱na̱i lo mishin a uwwa ta̱ uɗyoꞌo, reve ozo o ro e le a damma tsata tsa ɗa. Ozo o ro gba a damma, “Malingata ma̱ A̱sula̱ ma ɗa ma yuwain adanshi na̱ a̱yi!” ");
INSERT INTO tswNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","A̱vu Yesu damma le, “Adama a̱ ɗu a ɗa uɗyoꞌo u ta̱wa̱i, adama a̱ va̱ a ɗa shi. ");
INSERT INTO tswNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Gogo mantsa ma ɗa na A̱sula̱ e geꞌeto ama o uvaɗi. Waru mantsa ma ɗa ana A̱sula̱ a̱a̱ gba̱ra̱ Male za na aa yuwusan tsugono tsu uvaɗi tsa nda. ");
INSERT INTO tswNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Agba na̱ a̱ ꞌya̱sa̱n mu a akpata a̱tsuma̱ o uvaɗi, n to rono koyan a̱ ta̱wa̱ ya̱ꞌa̱ va̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu damma ta̱ ne adama u roco cine wa̱a̱ kuwa̱. ");
INSERT INTO tswNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Reve oɓolo a amaꞌa a̱ usu, “Wila̱ u tsu u damma tsu ta̱ a na Zamawawaꞌa u ta̱ da̱na̱ lo kuci. To, cine tsa ɗa, vaa damma a̱ ta̱ ꞌya̱sa̱n Mawun ma Vuma zuva va akpata? Zane ɗa Mawun ma Vuma ma ndaꞌa?” ");
INSERT INTO tswNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","A̱vu Yesu usu, “I ta̱ tsura̱ ekan a na a jima keꞌen. I lyuwa elime na̱ mmalu ekaꞌan ubuwu lo. Ni i yuwan ne, to, ya̱a̱ ta̱ɗa̱tsa̱ shi ni irumbu i ta̱wa̱. Amma ni i yuwan mmalu a̱tsuma̱ e irumbu, yee reve uba̱ta̱ u na yee tyo shi. ");
INSERT INTO tswNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Cayi za na ta̱wa̱i ne ekan okolo a̱ ɗu, a̱yi ubuwu oɓolo na̱ a̱ɗu. Ɗaɗa yoo oꞌwo ama a na a̱ ri nden a̱tsuma̱ e ekan.” Ana Yesu dammai ne, reve u ka̱ra̱ u ꞌya̱wa̱ u paꞌan adama e ene yi wan. ");
INSERT INTO tswNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ko na u yuwain iroci yi linga va asalama a nda a̱ ma̱ka̱ka̱n me le, a̱ ushi yi shi. ");
INSERT INTO tswNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","A yuwan ta̱ ne adama e ili i na Ishaya vumava̱sula̱ dammai wo oꞌwo amayun, “A̱sulazuva, zane ɗa usuyi ili i na tsu damma nle? Waru zane ɗa enei ucira wa̱ wu?” ");
INSERT INTO tswNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ishaya† waru u damma ta̱ ili i na i zuwai a̱ kuɗa̱i a̱ usu a̱yi ɗa: ");
INSERT INTO tswNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“A̱sulazuva a̱ rumba̱na̱to ta̱ esu a ama, reve waru u zuwa o oꞌwo aza a aciyogbamu. U yuwan ta̱ ne adama e ene ko e reve wan, waru adama a̱ ka̱mba̱ uba̱ta̱ wa̱ A̱sulazuva u ka̱mbuwa̱ le gbaga wan.” ");
INSERT INTO tswNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ishaya damma ta̱ ne, adama a na we enei tsugbain tsa̱ Yesu, a̱vu u yuwan adanshi a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","A mantsaꞌa, reve azagbain na̱ a̱bunda̱ a ca yi okolo e le. Agba adama a na aa uwwusa wovon wa Afarishi, a yuwan adanshi a̱ yi a alanga eteshe shi, adama Afarishi a̱ gba̱ra̱ le a̱tsuma̱ a̱ a̱a̱ꞌisa̱ꞌa̱ wan. ");
INSERT INTO tswNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","A laꞌa ta̱ ciga ama a cuwa le a na A̱sula̱ a cuwa le. ");
INSERT INTO tswNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","A̱vu Yesu damma koyan a uwwusa, “Za na ushi numu suru, u ushi mu ta̱ oɓolo na̱ za na lyungu numu. ");
INSERT INTO tswNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Za na suru ene numu, we ene ta̱ za na lyungu numu. ");
INSERT INTO tswNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","N ta̱wa̱ ta̱ a̱tsuma̱ o uvaɗi ana za na ta̱wa̱yi ne ekan a̱tsuma̱ o uvaɗi, adama za na ca numu okolo waa buwa a̱tsuma̱ e irumbu shi. ");
INSERT INTO tswNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Za na suru uwwai adanshi a̱ va̱, reve u ꞌyuwan a̱ kuru le, a̱mu ɗa moo kototo yi shi. Adama a na n ta̱wa̱ adama n kototo uvaɗi shi, amma adama n wawa yi. ");
INSERT INTO tswNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Agba ili i na yoo kototo za na ꞌyuwan numu na adanshi a̱ va̱ o ta̱ lo. Adanshi a na n dammai, a̱yi ɗa ili i na yoo kototo yi o urana wu ukosu. ");
INSERT INTO tswNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ili i na moo ritosu ili ya aciya̱va̱ i ɗa shi. Dada na lyungu numu, a̱yi ɗa u damma numu ili i na maa damma ni ili i na moo rito. ");
INSERT INTO tswNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","N reve ta̱ ili i na u dammai ama a yuwan, iliꞌi i zuwa ta̱ ama a̱ tsura̱ wuma u na woo koto shi. A̱yi ɗa i zuwai maa dansaa ɗu ili i na Dadaꞌa u damma numu gan.” ");
INSERT INTO tswNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ele lo kafu urana wa̱ A̱buki a Mapasa a rawa, Yesu reve ta̱ mantsa ma na waa lyawa uvaɗi u rawa ta̱, tsa̱ra̱ u ka̱mba̱ uba̱ta̱ wa Dada. U ciga ta̱ ama a na a̱ ri pe a̱tsuma̱ o uvaɗi aza a na a ciga niyi, waru u ciga le ta̱ hali a̱ tyo o ukosu. ");
INSERT INTO tswNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","A̱yi a lyuwusa ilyalya oɓolo no ojoro a̱ yi nu ulivu, agba Mekerenkesu ma zuwa ta̱ ɗe Yahuza, mawun ma̱ Simo Iskariyoti, u jiyan adama u wina yi. ");
INSERT INTO tswNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu reve ta̱ a na Dada va̱ yi ca niyi ɗe ucira e ekere e ili suru, waru u ta̱wa̱ ta̱ diga a̱ A̱sula̱, waru u ta̱ ka̱mba̱ uba̱ta̱ wa̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ele a̱tsuma̱ a alya, a̱vu u ꞌyon mishin ɗaɗa u foɗoi utugu wa̱ yi reve wu nla̱ mayaga e ikyun ya̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","A̱vu u tsun mini a masaꞌatsu reve u uwa masaꞌa ma ana mo ojoro a̱ yi, a̱vu u tasa le na̱ mamuna ma na wu nla̱i e ikyun ya̱ yiꞌi. ");
INSERT INTO tswNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ana u rawai uba̱ta̱ wa̱ Simo Bituru, a̱vu u damma yi, “Zagbain, vu ciga ta̱ vu saꞌa mu ana?” ");
INSERT INTO tswNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Reve u usu, “Vu reve ili i na maa yuwusan gogo shi, amma vu ta̱ ta̱wa̱ vu reve na̱ a̱ca̱pa̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","A̱vu Bituru damma, “Oꞌo, vaa saꞌa ana a̱ va̱ shi.” A̱vu u usu, “Na̱ n saꞌa ana a̱ wu shi, vu pe a̱tsuma̱ a ama a̱ va̱ shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ɗaɗa u dammai, “Zagbain, she vu saꞌa ana a̱ va̱ goon wan! Saꞌa ekere na aaci a̱ va̱ fo!” ");
INSERT INTO tswNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","A̱vu u damma, “Na̱ vuma sumba̱, lipu va̱ yi suru u tsu da̱na̱ ta̱ cece. Ana a̱ yi a ɗa goon u cigai u saꞌa. Waru a̱ɗu i ta̱ cece, agba suru nɗu ɗa shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","U reve ta̱ vuma na aa wina yi, a̱yi ɗa i zuwai u dammai, “Suru nɗu ɗa i ri cece shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ana u kotoi masaꞌa ma ana me le, a̱vu wo oto utugu wa̱ yi. A̱vu u da̱nuwisa̱, reve we ece le, “I reve ta̱ ili i na n yuwaan nɗu gogo? ");
INSERT INTO tswNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","I ɗe mu ta̱ ‘Manlu’ na̱ ‘Zagbain’ waru amayun a ɗa ɗu, adama a na ne ɗaɗa n ri. ");
INSERT INTO tswNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","A̱mu, Zagbain na̱ Manlu ma̱ ɗu, n saꞌa ta̱ ana a̱ ɗu gogo. A̱ɗu fo i saꞌalai ana a̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","N yuwan ta̱ ne adama e iroci tsa̱ra̱ i yuwan cine n yuwaan nɗu. ");
INSERT INTO tswNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Amayun a ɗa maa dansaa ɗu, aagbashi a laꞌa zavuꞌwa va̱ yi shi. Malingata ma laꞌa za na lyungu niyi shi. ");
INSERT INTO tswNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","I reve ta̱ ili i nda, waru A̱sula̱ a ta zuwaa ɗu abaꞌun, ni i yuwan le. ");
INSERT INTO tswNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Maa yuwusan adanshi adama a̱ ɗu suru shi. N reve ta̱ aza a na n ɗangwai. Amma ili i na Adanshi a̱ A̱sula̱ a dammai ciga ꞌyuwan u shiwan. Reve u damma, ‘Vuma na aa lyuwusa oɓolo na̱ a̱mu ɗa wina numu!’ ");
INSERT INTO tswNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“N ta dansaa ɗu ili i nda gogo kafu u fara, tsa̱ra̱ nu u fara, i usu a na a̱mu ɗaɗa za na ri lo kuci. ");
INSERT INTO tswNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","N ta dansaa ɗu amayun, vuma na ushiyi malingata ma̱ va̱, u ushi mu ta̱ fo. Waru vuma na usu numu, u usu ta̱ vuma na lyungu numu.” ");
INSERT INTO tswNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ana Yesu kotoi adanshi o ndolo, a̱vu u uwa a̱tsumola̱ngu a̱ a̱bunda̱ lon. Ɗaɗa u dammai a alanga e eteshe, “N ta dansaa ɗu amayun, vuma ta̱ a̱tsuma̱ a̱ ɗu u ta wina mu.” ");
INSERT INTO tswNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Agba ojoro a̱ yi e reve ili i na waa dansa shi. A̱vu a̱ ka̱lyuwula̱i va̱ni le. ");
INSERT INTO tswNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Za ta̱ a̱tsuma̱ o ojoro a̱ yi za na Yesu cigai lon, da̱na̱ ta̱ nden zuzu na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","A̱vu Simo Bituru yuwaan yi adanshi nu ukere reve u damma, “Ece yi ko zane ɗa waa yuwusan adanshi a aci a̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Reve oojoroꞌo u raɓatowo Yesu, a̱vu we ece yi, “Zagbain, a̱tsuma̱ a̱ tsu, vuma ne ɗa vaa yuwusan adanshi a aci a̱ yi?” ");
INSERT INTO tswNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","A̱vu u usu, “N to oto assala a nda o usaꞌan. Vuma na n cayi a̱yi ɗa waa wina mu.” A̱vu wo oto assalaꞌa a̱vu u ca Yahuza, ulobo wa̱ Simo Iskariyoti. ");
INSERT INTO tswNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ana Yahuza ushiyi assala o ndolo, ɗaɗa Male ma uwa niyi. Ɗaɗa Yesu dammai, “Yahuza, ꞌya̱wa̱ gogo vu yuwan ili i na vu cigai vu yuwan.” ");
INSERT INTO tswNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","A̱tsuma̱ a aza a na a̱ da̱na̱i lo a alya, babu za na revei ili i na i zuwai Yesu dammai ne Yahuza. ");
INSERT INTO tswNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Amma adama a na Yahuza a̱yi ɗa le za vu uzuwa, ozo o ro a yuwusan ta̱ majiyan gashi Yesu damma yi ta̱, u ꞌya̱wa̱ u tsupa ikebe yi ilyalya, ko u neꞌeshen alambi ikebe. ");
INSERT INTO tswNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ana Yahuza ushiyi assala o ndolo, reve wu utushi, cina ayin a yuwan. ");
INSERT INTO tswNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ana Yahuza ka̱ra̱i, reve Yesu damma, “Mantsa ma rawa ta̱ a na a̱mu Mawun ma Vuma maa uwa a̱tsuma̱ a tsugbain tsa̱ va̱, waru A̱sula̱ a̱ ta̱ tsura̱ tsugbain adama e ili i na yaa cina mu suru. ");
INSERT INTO tswNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na̱ A̱sula̱ a̱ tsura̱ tsugbain adama a̱ va̱, A̱sula̱ na aciya̱yi u to roco cine Mawun ma Vuma ma̱ ri na̱ tsugbain gogogo. ");
INSERT INTO tswNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Muwun n va̱, mantsa keꞌen ɗa ma buwa numu a na ma̱a̱ da̱nu na̱ a̱ɗu. I ta zami mu, agba ya̱a̱ tsura̱ mu shi. N damma ɗu ta̱ cine n dammai aza a Israꞌila, ‘Yaa gura ꞌya̱wa̱ uba̱ta̱ u na ma̱a̱ ꞌya̱wa̱ shi.’ ");
INSERT INTO tswNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Amma n ta casu ɗu wila̱ u saꞌavu u na ya̱a̱ kuru. I ciga i ꞌyuwan i cigalai cine n ciga nɗu. ");
INSERT INTO tswNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ni i cigalai, ama suru e te reve a̱ɗu ojoro a̱ va̱ a ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Reve Simo Bituru ece Yesu, “Zagbain, te ɗa vee tyo?” Reve u usu, “Uba̱ta̱ u na ma̱a̱ ꞌya̱wa̱ vaa gura toni mu ɗe shi, amma a̱ ꞌya̱wa̱ ɗe vu to toni mu.” ");
INSERT INTO tswNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","A̱vu we ece yi, “Zagbain, nye i zuwai moo toni wu gogo shi? N tu ufoɓu n kuwa̱ oɓolo na̱ a̱vu!” ");
INSERT INTO tswNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Reve u usu yi, “Vu tu ufoɓu vu kuwa̱ adama a̱ va̱? Amayun a ɗa maa damma wu, kafu moton ma saala, vu ta wasan mu utaꞌatsu.” ");
INSERT INTO tswNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Reve Yesu damma ojoro a̱ yi, “She u ɓa̱la̱ ko i da̱na̱ na̱ a̱tsumola̱ngu wan. I ushi A̱sula̱, waru i ushi mu fo. ");
INSERT INTO tswNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Asula a̱ a̱bunda̱ a̱ ta̱ ɗe o uꞌwa wa Dada va̱, waru n ta̱ ꞌya̱wa̱ n foɓoo ɗu uba̱ta̱. Na amayun a ɗa shi, n shi a damma ɗu ne shi. ");
INSERT INTO tswNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na̱ n koto mayan me ili i nda, n ta̱ ta̱wisa̱ n tara ɗu a̱ tyo oɓolo na̱ a̱mu. Reve tsu da̱nuyi oɓolo. ");
INSERT INTO tswNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","I reve ta̱ ure a̱ tyo uba̱ta̱ u na mee tyo.” ");
INSERT INTO tswNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Reve Toma usu yi, “Zagbain, tsu reve uba̱ta̱ u na vee tyo shi. Cine tsee reve ure a̱ tyo ɗe?” ");
INSERT INTO tswNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Reve u usu, “A̱mu ɗa ure u na u rocoi amayun a̱ A̱sula̱ waru n ca ama wuma. Babu vuma na a̱a̱ ꞌya̱wa̱ ya Dada she nu u kuru nu uba̱ta̱ u va̱. ");
INSERT INTO tswNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ni i shi i reve mu na amayun, i te reve Dada va̱ fo. Amma diga gogo i reve yi ta̱, waru ye ene yi ta̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","A̱vu Filibu damma, “Zagbain, roco tsu Dadaꞌa, a̱tsu u ta rawa tsu.” ");
INSERT INTO tswNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Reve u usu, “Filibu, n to oɓolo na̱ a̱ɗu nu ujimu. Cine tsa ɗa wo oꞌwoi hali n gogo koto vu revei ko zane ɗa n ri shi? Vuma na ene numu suru, we ene ta̱ Dada. To, cine vaa dansa n roco ɗu Dadaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Koto vu ca okolo a na a̱mu n ri pe a̱tsuma̱ a Dada, waru Dada ri pe a̱tsuma̱ a̱ va̱ shi? Adanshi a na maa dansaa ɗu adanshi a̱ va̱ a ɗa shi, amma Dada ɗa na ri pe a̱tsuma̱ a̱ va̱, waru a̱yi ɗa waa yuwusan ulinga wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Usuyi Dadaꞌa u ta̱ pe a̱tsuma̱ a̱ va̱, a̱mu waru n ta̱ pe a̱tsuma̱ a Dada. Na̱ ya̱a̱ usu mu adama e idanshi i va̱ shi, to, usu numu adama e ili i na n yuwain. ");
INSERT INTO tswNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Amayun a ɗa maa dansaa ɗu, vuma na suru usu numu, ta yuwan ili i na n yuwusain. Aza a na a̱ usu numu a ta yuwan ili i na i laꞌai za na n yuwusain, adama a na n ta̱ ka̱mba̱ n da̱nu oɓolo na̱ Dada. ");
INSERT INTO tswNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Waru ni i pati ili i ro a̱tsuma̱ a ala a̱ va̱, n ta yuwaan ɗu, adama Mawuꞌun u ta̱wa̱a̱ Dada na̱ tsugbain. ");
INSERT INTO tswNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","N ta yuwaan ɗu ili i na i patiyi suru a̱tsuma̱ a ala a̱ va̱. ");
INSERT INTO tswNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ni i ciga mu, i ta yuwan ili i na n damma nɗu i yuwan suru. ");
INSERT INTO tswNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Waru n ta pati Dada u ca ɗu Za vi Ikambi i ro, za na a̱a̱ da̱nu na̱ a̱ɗu hali ukosu. ");
INSERT INTO tswNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","A̱yi ɗa Ruhu va Akiza,† za na rocoi amayun adama a̱ A̱sula̱. Ama o uvaɗi a̱a̱ usu yi shi, adama a na e ene yi shi, waru e reve yi shi. Amma a̱ɗu i reve yi ta̱, adama a na u ta̱ pe nden a̱tsuma̱ a̱ ɗu, waru u ta̱ da̱na̱ pe a̱tsuma̱ a̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Na̱ n ka̱ra̱, maa lyawa ɗu a̱ ndeꞌen tsa mkpaꞌan shi, n ta̱ ta̱wisa̱ ya̱ꞌa̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mantsa ma buwa ta̱ keꞌen, ama o uvaɗi a buwa ee ene mu shi, amma a̱ɗu i te ene mu. Adama a na a̱mu wuma u ɗa n ri, a̱ɗu waru i ta̱ da̱na̱ wuma. ");
INSERT INTO tswNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nu urana u ndolo u ta̱wa̱, i te reve a na n ri pe a̱tsuma̱ a Dada. Waru i te reve a na i ri a̱tsuma̱ a̱ va̱, waru a̱mu n ri a̱tsuma̱ a̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Vuma na ciga numu suru, u ta yuwan ili i na n dammai suru, a̱vu Dada va̱ ciga yi fo. A̱mu fo n ta ciga yi, a̱vu n roco yi ko zane ɗa n ri.” ");
INSERT INTO tswNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","A̱vu Yahuza (a̱yi nda Yahuza Iskariyoti ɗa shi) damma, “Amma Zagbain, cine vu foɓoi vu roco tsu aciya̱wu amma a̱ tyo a akapi shi?” ");
INSERT INTO tswNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Reve u usu, “Na ama a ciga mu, a ta yuwan ili i na n damma nle a yuwan suru. Dada va̱ ta ciga le, a̱vu tsu ta̱wa̱ ya̱ꞌa̱ le, a̱vu waru tsu da̱nu oɓolo ne ele. ");
INSERT INTO tswNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Vuma na gba ciga numu shi, waa yuwan ili i na n dammai shi. Ili i na yu uwwa numu n dammai, ya̱ꞌa̱ va̱ ɗa wu uta̱i shi, amma o una̱ wa Dada u ɗa za na lyungu numu. ");
INSERT INTO tswNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“N damma ɗu ta̱ ili i nda suru a mantsa ma na n da̱na̱i oɓolo na̱ a̱ɗu. ");
INSERT INTO tswNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Amma a̱yi Za vi Ikambi u to roco ɗu ili suru, waru u ta zuwa ɗu i cuwan ili i na n damma nɗu suru. A̱yi Za vi Ikambi i nda a̱yi ɗa Ruhu va Akiza za na Dada va̱ a̱a̱ lyungu a̱tsuma̱ a ala a̱ va̱. ");
INSERT INTO tswNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","N zuwa ɗu ta̱ i tsura̱ ma̱za̱nga̱ o okolo a̱ ɗu, cuꞌun ma̱za̱nga̱ na n ri na̱ a̱yi o okolo a̱ va̱, a̱yi ɗa maa zuwa ɗu i tsura̱. Asuvu nden a na maa ca woo oꞌwo cine uvaɗi waa ca shi. Adama o ndolo she i yuwan a̱tsumola̱ngu lon wan, waru she yu uwwa wovon wan. ");
INSERT INTO tswNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Yu uwwa mu ta̱ ɗe adansa n ta̱ ka̱ra̱ waru n ta̱ ta̱wisa̱ ya̱ꞌa̱ ɗu. Ni i ciga mu na amayun i yuwan ma̱za̱nga̱ a na ma̱a̱ ka̱mba̱ ya Dada, adama a na u laꞌa mu ta̱ tsugbain. ");
INSERT INTO tswNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","N ta dansaa ɗu ili i nda gogo kafu u fara, adama nu u fara i usu. ");
INSERT INTO tswNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ma̱a̱ da̱shi yuwan adanshi a̱ a̱bunda̱ na̱ a̱ɗu shi. Adama a na za tsugono tsu uvaɗi u nda u ta̱ lo a̱ ta̱wa̱. Amma u ri nu ucira a aci a̱ va̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","N yuwan ta̱ ili i na Dada va̱ damma numu n yuwan suru, tsa̱ra̱ ama o uvaɗi a nda e reve n ciga yi ta̱. “Ta̱wa̱i gogo tsu ka̱ra̱i.” ");
INSERT INTO tswNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","A̱vu Yesu lyuwa elime na adanshi no ojoro a̱ yi, reve u damma, “A̱mu ɗa ikyun ya amayun i na i tsu uta̱a̱ ataci† a inabi. Dada va̱ a̱yi ɗa cimbi. ");
INSERT INTO tswNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ne eeten a na a̱ ri za va̱ nu u matsan shi, u tsu gasa yi ta̱. Waru u tsu lapula ta̱ eeten a na a tsu matsan muwun, tsa̱ra̱ u matsan muwun ma̱ a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ili i na n damma nɗu u zuwa ɗu ta̱ ɗe i ka̱mba̱ cece. ");
INSERT INTO tswNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ni i ri ukaɓu na̱ a̱mu, n to oꞌwo ukaɓu na̱ a̱ɗu. Eeten a tsu matsan na aciya̱yi shi. U ta matsan nu u buwa ukaɓu ni ikyun. Ne ɗa a̱ɗu fo yaa matsan shi, she ni i ri ukaɓu na̱ a̱mu. ");
INSERT INTO tswNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“A̱mu ɗa ikyun ya ataciꞌi, a̱ɗu gba eten. Na̱ za suru kaɓa ya̱ꞌa̱ va̱, a̱mu waru ukaɓu na̱ a̱yi, u ta̱ matsan lon. Agba yaa gura yuwan ili i ro shi, she na̱ n kamba ɗu. ");
INSERT INTO tswNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Na̱ za ri ukaɓu na̱ a̱mu shi, u ta̱ gashi eeten a na a tsu vari reve u ꞌyewe. Ama a tsu tara ta̱ eten a na e ꞌyewei, reve a zuwa le a akina a̱ kula̱to le. ");
INSERT INTO tswNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ni i ri ukaɓu na̱ a̱mu na̱ waru ya̱a̱ kurusu uritosu u va̱, i ta pati Dada ili i na i cigai suru, a̱vu gba u ca ɗu. ");
INSERT INTO tswNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Na̱ yaa matsasan muwun ma̱ a̱bunda̱, u to rocosu a na a̱ɗu ojoro a̱ va̱ a ɗa, waru i to rocosu ama tsugbain tsa Dada va̱. ");
INSERT INTO tswNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“N ciga ɗu ta̱ cine Dada va̱ ciga numu. Gogo i kaɓa a̱tsuma̱ e icigi i va̱. ");
INSERT INTO tswNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ni i yuwan ili i na n dammai, i ta kaɓa a̱tsuma̱ e icigi i va̱. Ne ɗa waru, n yuwain ili i na Dada va̱ damma numu n yuwan, ne ɗa fo n ri ukaɓu a̱tsuma̱ e icigi ya̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","N damma ɗu ta̱ ili i nda suru adama yoo oꞌwo na̱ cuꞌun ma̱za̱nga̱ ma na n ri na̱ a̱yi, adama waru ma̱za̱nga̱ ma̱ ɗu mo oꞌwo ushete wan. ");
INSERT INTO tswNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Apa nda ili i na maa dansaa ɗu i yuwan: i cigalai ununa n ciga nɗu. ");
INSERT INTO tswNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Babu icigi i na i laꞌai nda, vuma kuwa̱ adama a̱ nꞌutsa̱ ma̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","“A̱ɗu nꞌutsa̱ n va̱ ɗa, ni i kuru ili i na maa dansa. ");
INSERT INTO tswNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","M buwa e ɗesu ɗu agbashi shi, adama a na zagbain tsu damma agbashi a̱ yi ili biti shi. Amma n te ɗesu ɗu nꞌutsa̱, adama a na n damma nɗu ili i na Dada va̱ damma numu biti. ");
INSERT INTO tswNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","I ɗangwa mu shi. A̱mu ɗa n ɗangwa nɗu. A̱vu waru n ca ɗu ulinga u nda i yuwan: ꞌYa̱wa̱i i matsan muwun, icuꞌun i na yaa jima. Ne ɗa Dada aa ca ɗu ili i na i pati niyi suru na ala† a̱ va̱. ");
INSERT INTO tswNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Apa ili i na n damma nɗu i yuwan: I cigalai. ");
INSERT INTO tswNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Na ama o uvaɗi a nda a ꞌyuwan ɗu, i cuwan a̱mu ɗa a fara ꞌyuwain. ");
INSERT INTO tswNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Na̱ a̱ɗu a̱za̱ o uvaɗi a ɗa, a ta ciga ɗu ununa a cigai a̱za̱ e le. Amma n ɗangwa ɗu ta̱ yu uta̱ a̱tsuma̱ o uvaɗi, adama o ndolo a̱ɗu a̱za̱ o uvaɗi a ɗa shi. A̱yi ɗa i zuwai uvaɗi u ꞌyuwan nɗu. ");
INSERT INTO tswNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","I cuwan ni ili i na n damma nɗu: Aagbashi a laꞌa zavuꞌwa va̱ yi shi. Na ama o ɓongi mu, o to ɓongi ɗu fo. Waru na a yuwan ili i na n rito nle a yuwan, a ta yuwan ili i na i damma nle fo a yuwan. ");
INSERT INTO tswNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Agba o to ɓongi ɗu adama a na i ri a̱za̱ a̱ va̱. A ta yuwan ne adama a na e revei za na lyungu numu shi. ");
INSERT INTO tswNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Na̱ n shi n ta̱wa̱ n yuwaan le adanshi shi, a̱ shi a̱ da̱na̱ nu unusu u na wa̱a̱ ta̱wa̱a̱ le no oforo shi. Amma gogo a̱ ri nu ure u mota̱a̱ shi adama o unusu u le. ");
INSERT INTO tswNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Za na ꞌyuwan numu biti u ꞌyuwan ta̱ Dada va̱. ");
INSERT INTO tswNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","N yuwan ta̱ linga va asalama e memere me le, icuꞌun i na ko za koto yuwain shi. Na̱ n shi n yuwan linga nda shi, a̱ shi a̱ da̱na̱ nu unusu shi. Agba gogo nda e ene ta̱ ili i na n yuwain. Agba suru na̱ ne, a ꞌyuwan mu ta̱ oɓolo na̱ Dada va̱. ");
INSERT INTO tswNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Agba ili i nda i fara ta̱ adama e ili i na a ɗanai a̱ Wila̱ u le wo oꞌwo amayun: ‘A ꞌyuwan mu ta̱ pere m pere.’ ");
INSERT INTO tswNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“N ta̱ lyunguwa̱ ɗu za na a̱ tsu ɗe Za vi Ikambi. U to uta̱ uba̱ta̱ wa Dada a̱vu u ta̱wa̱ uba̱ta̱ u ɗu. A̱yi ɗa Ruhu va amayun. Nu u ta̱wa̱, u ta yuwan adanshi adama a̱ va̱. ");
INSERT INTO tswNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Reve a̱ɗu fo ni i ciga i ꞌyuwan i damma ama adama a̱ va̱, adama a na i ri oɓolo na̱ a̱mu diga a mantsa ma na n temei uritosu.” ");
INSERT INTO tswNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","A̱vu Yesu lyuwa elime na adanshi, u damma, “N damma ɗu ta̱ ili i nda, adama i lyawa uꞌususu u va̱ wan. ");
INSERT INTO tswNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","A̱ ta̱ gba̱ra̱ ɗu a̱ a̱ꞌisa̱. Waru mantsa ma̱ ta̱ ta̱wa̱ ana ama oo una ɗu, reve a jiyan gashi a ta yuwusaan A̱sula̱ a̱ga̱nda̱ na a yuwan ne. ");
INSERT INTO tswNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","A ta yuwan ne, adama a na e reve Dadaꞌa shi, waru e reve mu shi. ");
INSERT INTO tswNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Agba n damma ɗu ta̱ ili i nda, adama na̱ mantsa ma̱ ta̱wa̱ ana aa yuwusan ili i nda, i cuwan ni ili i na n damma nɗu. “Mantsa ma na n temei uritosu, n damma ɗu ili i nda shi, adama a na n shi oɓolo na̱ a̱ɗu. ");
INSERT INTO tswNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Gogo gba n ta̱ ka̱mba̱ uba̱ta̱ wu za na lyungu numu. Agba ko vuma ta̱ a̱tsuma̱ a̱ ɗu ece mu, ‘Te ɗa vee tyo?’ shi. ");
INSERT INTO tswNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ana n damma nɗu gogo, a̱ɗu ɗa nda i remei a̱tsumola̱ngu. ");
INSERT INTO tswNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Agba amayun a ɗa maa dansaa ɗu, u laꞌaa ɗu ta̱ ulobonu n ka̱ra̱. Na̱ n ka̱ra̱ n ta̱ lyunguwa̱ ɗu na̱ Za vi Ikambi. Na̱ n ka̱ra̱ shi, Za vi Ikambiꞌi wa̱a̱ ta̱wa̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nu u ta̱wa̱, u to roco ama o uvaɗi a na a nusain ana a dammai, ‘Tsu reve ta̱ ili i na i ri unusu, waru tsu reve ta̱ ili i na i ri mejege, waru tsu reve ta̱ ununa A̱sula̱ a̱ tsu geꞌeto unusu.’ ");
INSERT INTO tswNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","A yuwan mejege shi adama o unusu, adama a na a̱ usu mu shi. ");
INSERT INTO tswNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","A nusan ta̱ adama e ili i na i ri mejege, adama a na n ta̱ ꞌya̱wa̱ uba̱ta̱ wa Dada, waru yaa lyuwa elime na̱ mene ma̱ va̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","A yuwan mejege shi adama o ugeꞌetosu adama a na u yuwaan ta̱ ɗe za tsugono tsu uvaɗi u nda ugeꞌetosu. ");
INSERT INTO tswNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“N ta̱ ni ili ya̱ a̱bunda̱ i na maa damma ɗu, agba gogo u laꞌa ta̱ ucira u na yee reve. ");
INSERT INTO tswNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Agba na̱ Ruhu na o rocosu ili i na i ri amayun adama a̱ A̱sula̱ u ta̱wa̱, u ta zuwa ɗu i reve ili i na i ri mejege i na yoo utusa̱ uba̱ta̱ wa̱ A̱sula̱. Waa yuwan adanshi a na o uta̱i uba̱ta̱ wa̱ yi shi, amma u ta damma ili i na wu uwwai goon, waru u ta damma ɗu ili i na ya̱a̱ ta̱wa̱. ");
INSERT INTO tswNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","U ta ca mu tsugbain, adama a na u ta tara ili i na n dammai reve u damma ɗu. ");
INSERT INTO tswNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ili i na Dada ri ne ele suru, n ta̱ fo ne ele. A̱yi ɗa i zuwai n dammai Ruhuꞌu u ta tara ili i na maa damma a̱vu u damma ɗu. ");
INSERT INTO tswNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Na a jima keꞌen yee ene mu shi, amma a̱ tyo ɗe i te enishe mu.” ");
INSERT INTO tswNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Reve ozo o ro a̱tsuma̱ o ojoro a̱ yi a dammulai, “Nye waa dansa ana u dammai, ‘Na a jima yee ene a̱mu shi, reve waru a̱ tyo ɗe a̱vu ye enishe mu?’ Waru nye i ɗa waa dansa ana u dammai, ‘Adama a na n ta̱ ka̱ra̱ a̱ tyo uba̱ta̱ wa Dada?’ ” ");
INSERT INTO tswNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Reve waru e ecelei, “Nye i ɗa waa dansa ‘na a jima keꞌen?’ Tsu gura reve ili i na waa dansa shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu reve ta̱ ojoro a̱ yi a ciga ta̱ e ece yi adama o ndolo, ɗaɗa u damma nle, “I te mecilei ili i na maa dansa ana n dammai, ‘Na a jima keꞌen ye ene mu waru shi, reve waru n damma a̱ tyo ɗe i te enishe mu?’ ");
INSERT INTO tswNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Amayun a ɗa maa dansaa ɗu, i ta̱ shon a̱vu waru i yuwan a̱tsumola̱ngu, amma uvaɗi u ta yuwan ma̱za̱nga̱. I ta yuwan a̱tsumola̱ngu, amma a̱tsumola̱ngu a̱ ɗu a̱ ta̱ ka̱mba̱ ma̱za̱nga̱. ");
INSERT INTO tswNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Na̱ ka da̱nu limatan, u ta̱ na̱ mɓa̱la̱, adama a na mantsa ma̱ yi ma rawai. Amma nu u matsan mawuꞌun, a̱vu wi icina na̱ mɓa̱la̱ꞌa̱ adama a na u ri a̱ ma̱za̱nga̱ ma na u tsura̱i mawun o uvaɗi. ");
INSERT INTO tswNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ne ɗa fo u ri ya̱ꞌa̱ ɗu. Gogo i ta̱ a̱tsumola̱ngu, amma n te enishe ɗu. A mantsaꞌa i ta yuwan ma̱za̱nga̱, waru ko vuma aa gura zuwa ɗu i lyawa ma̱za̱nga̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Na̱ mantsa mo ndolo ma rawa, yee ece mu ili i ro waru shi. Amayun a ɗa maa dansaa ɗu, Dada va̱ ta ca ɗu ili i na i patiyi suru a̱tsuma̱ a ala a̱ va̱. ");
INSERT INTO tswNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hali n gogo koto i pati ili i ro a̱tsuma̱ a ala a̱ va̱ shi. Patishiyi, A̱sula̱ waru a ta ca ɗu a̱yi, tsa̱ra̱ i shiwan na̱ ma̱za̱nga̱. ");
INSERT INTO tswNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“N yuwan ta̱ adanshi a nda ni iroci, agba mantsa mo ta̱ lo a̱ ta̱wa̱ ana ma̱a̱ da̱shi yuwan ne shi. A mantsaꞌa n ta̱ pa̱ɗuwa̱ ɗu ili suru adama a Dadaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","O urana u ndolo i ta pati Dadaꞌa na ala a̱ va̱, agba woo oꞌwo she na̱ n yuwan ipati o una̱ u ɗu shi. ");
INSERT INTO tswNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","A̱sula̱ Dada u ciga ɗu ta̱ adama a na i ciga numu, reve waru i usu a na mu uta̱i uba̱ta̱ wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mu uta̱ ta̱ uba̱ta̱ wa Dada, reve n ta̱wa̱ o uvaɗi. Gogo gba n ta lyawa uvaɗi a̱vu n ka̱mba̱ ya Dadaꞌa.” ");
INSERT INTO tswNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","A̱vu ojoroꞌo a damma, “Gogo vu ta adanshi na̱ a̱tsu upa̱ɗuwu! Vaa yuwusan adanshi ni iroci shi. ");
INSERT INTO tswNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Gogo tsu reve ta̱ vu reve ta̱ ili biti. Vu ta gura usu yeci i vuma kafu u yuwan yeciꞌi. A̱yi nda, u zuwa tsu ta̱ tsu usu vu uta̱ ta̱ uba̱ta̱ wa̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","A̱vu u usu, “Amayun a ɗa i usu ta̱ gogo? ");
INSERT INTO tswNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mantsa mo ta̱ lo a̱ ta̱wa̱, waru u rawa ta̱ ɗe, ana suru nɗu yee beteꞌwe, koyan ɗa a̱tsuma̱ a̱ ɗu a̱ ka̱mba̱ o uꞌwa wa̱ yi, reve i lyawa mu a̱ ndeꞌen. Agba Dada to oɓolo na̱ a̱mu, waru adama o ndolo n ri a̱ ndeꞌen shi. ");
INSERT INTO tswNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“N damma ɗu ta̱ ili i ndolo adama yoo oꞌwo na̱ ma̱za̱nga̱ ma amayun adama a na i ri oɓolo na̱ a̱mu. Uvaɗi u ta zuwa ɗu i sowo a̱tsuma̱lima̱. Agba i kaɓa asuvu! N lyuwa ta̱ aci o ucira wu uvaɗi!” ");
INSERT INTO tswNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ana Yesu kotoi a dansaa le ili i nda suru, reve u ka̱lyuwa̱ zuva a̱vu u damma, “Dada, mantsa ma rawa ta̱. Vu ca Mawun ma̱ wu tsugbain adama u ca wu tsugbain. ");
INSERT INTO tswNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Vu ca yi ta̱ tsugbain a aci a ama suru adama u ca aza a na vu ca niyi wuma u na woo koto shi. ");
INSERT INTO tswNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Waru nda ure u na a̱a̱ tsura̱ wuma u na woo koto shi: e reve wu, za na a̱vu ɗa A̱sula̱ a amayun goon, reve waru e reve Yesu Zamawawa, za na vu lyunguyi. ");
INSERT INTO tswNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","N roco ta̱ tsugbain tsa̱ wu o uvaɗi ana n kotoi ulinga u na vu ca numu n yuwan. ");
INSERT INTO tswNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Gogo, Dada, vu da̱shi ca mu tsugbain tsa na n shi na̱ a̱yi ana n shi oɓolo na̱ a̱vu kafu vu yuwan uvaɗi. ");
INSERT INTO tswNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Vu ca mu ta̱ a̱za̱ e itoni o ro a̱tsuma̱ o uvaɗi u nda, waru n roco le ta̱ ili i na vu rotsoi. A̱za̱ a̱ wu a ɗa a̱ shi, agba vu ca mu ta̱ ele, a̱vu gba a yuwaan wu tsutoni. ");
INSERT INTO tswNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","E reve ta̱ a na a̱vu ɗa vu ca numu ili i na n ri na̱ a̱yi suru. ");
INSERT INTO tswNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Adama a na n damma ta̱ a̱za̱ e itoni a̱ va̱ ili i na vu damma numu, agba a̱ usu ta̱. E reve ta̱ a na mu uta̱i uba̱ta̱ wa̱ wu, a̱vu waru a̱ usu a̱vu ɗa vu lyungu numu. ");
INSERT INTO tswNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","N ta avasa adama e le. Maa yuwusan avasa adama a ama o uvaɗi shi, amma adama a aza a na vu ca numu, adama a na ele a̱za̱ a̱ wu a ɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ama o ndolo suru aza a na a̱ ri a̱za̱ e itoni a̱ va̱ a̱za̱ a̱ wu a ɗa fo, waru aza a na oo tono wu suru a̱za̱ a̱ va̱ a ɗa fo. O roco ta̱ na amayun ili i na tsugbain tsa̱ va̱ tsa̱ ri. ");
INSERT INTO tswNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","N ta̱ lo a̱ ta̱wa̱ ya̱ꞌa̱ wu. M buwa e isawan o uvaɗi waru shi. Agba a̱za̱ e itoni i va̱ a buwa ta̱ a̱tsuma̱ o uvaɗi. Vu roco ucira wa ala a̱ wu, a̱yi ɗa ala a na vu ca numu, tsa̱ra̱ vu geshe le. Ɗaɗa oo oꞌwo ili i ta̱, ununa a̱vu na̱ a̱mu tsu ri. ");
INSERT INTO tswNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nu ucira wa̱ wu u ɗa, ucira u na vu ca numu a mantsa mo ndolo a̱mu ubuwu o uvaɗi ɗaɗa m putsayi ili i wuya a̱ juꞌwa̱n le. Shede a̱yi vuma na o kototoi a̱yi ɗa a̱ lungusa̱i adama Adanshi a̱ A̱sula̱ a shiwan. ");
INSERT INTO tswNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Dada, n ta̱ ta̱wa̱ ya̱ꞌa̱ wu gogo. Agba n damma ta̱ ili i nda a̱mu ubuwu o uvaɗi, adama a̱za̱ e itoni a̱ va̱ a shiwan na̱ ma̱za̱nga̱ ununa a̱mu n ri. ");
INSERT INTO tswNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","N damma le ta̱ ikaka ya̱ wu. Agba ama o uvaɗi u nda a ꞌyuwan le ta̱, adama a na a̱ ri ili i ta̱ ne ele shi, ununa a̱mu fo n ri ili i ta̱ na ama o uvaɗi shi. ");
INSERT INTO tswNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Maa patishi wu vu tawa le a̱tsuma̱ o uvaɗi shi, amma vu ꞌyasan za wuya a̱ juꞌwa̱n le. ");
INSERT INTO tswNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","A̱mu za vu uvaɗi u nda u ɗa shi. Ne ɗa waru ele fo a̱za̱ o uvaɗi a nda a ɗa shi. ");
INSERT INTO tswNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Vu zuwa le o oꞌwo cece na akiza o uritosu wa adanshi a̱ wu za na a̱yi ɗa amayun. ");
INSERT INTO tswNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","N lyungu le ta̱ a̱tsuma̱ o uvaɗi, cine vu lyungu numu a̱tsuma̱ o uvaɗi. ");
INSERT INTO tswNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","N ca ta̱ aciya̱va̱ n yuwaan wu tsugbashi adama ele fo a ca aciyele a yuwaan wu tsugbashi. ");
INSERT INTO tswNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Dada, n ta yuwusan avasa adama a̱ a̱za̱ e itoni a nda, agba waru n ta yuwusan avasa adama a aza a na a̱a̱ ta̱wa̱ a ca mu okolo e le suru, adama e ili i na a̱za̱ e itoni a̱ va̱ aa damma adama a̱ va̱. ");
INSERT INTO tswNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","N ciga ta̱ suru nle o oꞌwo ili i ta̱, ununa a̱mu n ri ili i ta̱ na̱ a̱vu, a̱vu waru vu ri ili i ta̱ na̱ a̱mu. N ciga le ta̱ fo o oꞌwo ili i ta̱ na̱ a̱tsu. Ɗaɗa ama o uvaɗi a nda a̱a̱ usu a na a̱vu ɗa vu lyungu numu. ");
INSERT INTO tswNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","N ca ta̱ ama a nda tsugbain tsa na vu ca numu adama o oꞌwo ili i ta̱, ununa a̱vu na̱ a̱mu tsu ri ili i ta̱. ");
INSERT INTO tswNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","A̱mu ili i ta̱ i ɗa ne ele, a̱vu waru ili i ta̱ vu ri na̱ a̱mu, adama o oꞌwo ili i ta̱ suru suru. Ne ɗa ama o uvaɗi ee reve a̱vu ɗa vu lyungu numu. E te reve a na vu cigai a̱za̱ e itoni a̱ va̱ ununa vu ciga numu. ");
INSERT INTO tswNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Dada, vu ca mu ta̱ ele, waru n ciga le ta̱ a̱ da̱na̱ uba̱ta̱ u na n ri, adama ee ene tsugbain tsa̱ va̱, za na vu ca numu adama a na vu ciga numu kafu vu yuwan uvaɗi. ");
INSERT INTO tswNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Dada, a̱vu ɗa za va̱ a̱ɓula̱.† Uvaɗi u reve wu shi, a̱mu gba n reve wu ta̱, ama a nda waru e reve ta̱ a na vu lyungu numu. ");
INSERT INTO tswNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","N roco le ta̱ ili i na vu rotsoi, waru n ta lyuwa elime nu uyuwusan ne. Ne ɗa aa gura ciga ozo o ro ununa vu ciga numu, adama moo oꞌwo ili i ta̱ ne ele.” ");
INSERT INTO tswNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ana Yesu kotoi avasa, reve a̱yi no ojoro a̱ yi a̱ ka̱ra̱ reve a pasa Uɓaa wa̱ Kidron. Reve a rawa uba̱ta̱ u na u ri na̱ ɗanga zetun† va̱ a̱bunda̱ a̱vu a uwa pe. ");
INSERT INTO tswNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","A̱ ꞌya̱wusa̱ ta̱ uba̱ta̱ꞌa̱ na̱ a̱bunda̱, a̱yi ɗa i zuwai Yahuza za na wina niyi revei uba̱ta̱ u na a̱ ri. ");
INSERT INTO tswNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Reve nan ganu a gbagbain na Afarishi a̱ lyungu a̱duga̱ri a̱ A̱a̱ꞌisamapaɗa o ro a̱ kuru Yahuza. Waru oɓolo a̱ a̱soja a̱ Roma a̱ shi ta̱ oɓolo ne ele, ama a nda a̱ shi ta̱ ni itana yu uvon ni ifitila na akata. A̱vu Yahuza tara le a̱ tyo uba̱ta̱ꞌa̱. ");
INSERT INTO tswNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu reve ta̱ ili i na yaa fara na̱ a̱yi, ɗaɗa wu uta̱i reve we ece le, “Zane ɗa yaa zama?” ");
INSERT INTO tswNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Reve a̱ usu, “Yesu za va Nazara.” A̱vu u damma le, “A̱mu ɗaɗa Yesuꞌu!” (Yahuza za na wina niyi, shi ta̱ mishin ne ele.) ");
INSERT INTO tswNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ana Yesu damma nle, “A̱mu ɗaɗa a̱yiꞌi,” reve o rono na̱ a̱ca̱pa̱ a̱vu a̱ riya̱ e iɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Reve we ecishe le, “Zane ɗa yaa zama?” A̱vu a damma, “Yesu za va Nazara.” ");
INSERT INTO tswNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","A̱vu u usu, “N damma ɗu ta̱ ɗe a̱mu ɗaɗa Yesu. Na̱ a̱mu ɗa yaa zama, lyawai ojoro a̱ va̱ a̱ ka̱ra̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","A yuwan ta̱ ne adama e ili i na Yesu dammai ɗe a shiwan, “N lamba ko za ta̱ a̱tsuma̱ a aza na vu ca numu shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Reve Simo Bituru tala matsun me peꞌeni ma̱ yi reve u koɗo utsuvu wu usaꞌani wa aagbashi a aabara a nan ganu. (Aala a aagbashiꞌi Maluku.) ");
INSERT INTO tswNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","A̱vu Yesu damma Bituru, “Ka̱mbuwa̱ matsun me peꞌeni ma̱ wu e ibici ya̱ yi. Vu ta a majiyan n ciga n sowo a̱tsuma̱lima̱ ununa Dada zuwai n sowo shi?” ");
INSERT INTO tswNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Reve yali i gbain† na̱ a̱soja a̱ yi a̱ Roma, oɓolo na̱ a̱duga̱ri a̱ A̱a̱ꞌisamapaɗa, e reme Yesu a̱vu a̱ nla̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","A̱vu a fara tara yi a̱ tyo ya Hanana, a̱sha̱wa̱le Kayafa. Kayafa ɗa da̱na̱i aabara a nan ganu a aaꞌwan o ndolo. ");
INSERT INTO tswNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","A̱yi ɗaɗa za na ɗe a̱ca̱pa̱ u dammai azagbain a Israꞌila, “Lyawai vuma nda kuwa̱ tsa̱ra̱ ama suru a̱ da̱na̱ wuma.” ");
INSERT INTO tswNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Reve Simo Bituru no oojoro o ro a̱ kuru Yesu. Oojoroꞌo u reve ta̱ aabara a nan ganuꞌu, ɗaɗa u uwai oɓolo na̱ Yesu a̱tsuma̱ a agalaci o ukobu wu ugeꞌetosu wa aabara a nan ganu. ");
INSERT INTO tswNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Bituru gba reve wi isawan a alanga zuzu nu una̱ntsu. A̱vu oojoroꞌo u ka̱mba̱ u yuwan adanshi na aagbashi o usheli a na a̱ ri o una̱ntsu. Reve a lyawa Bituru u uwa. ");
INSERT INTO tswNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Amma a̱vu usheliꞌi we ece Bituru, “A̱vu oojoro a vuma ndolo Yesu ɗa, ko ne ɗa shi?” A̱vu u wasan, “Oꞌo, a̱mu ɗa shi!” ");
INSERT INTO tswNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Mantsa mo uta̱nu ma ɗa ma̱ shi, reve agbashi na̱ a̱duga̱ri a̱ A̱a̱ꞌisamapaɗa a gbaꞌato akina. Ele a lyasuwusa, ɗaɗa Bituru rawai zuzu na akinaꞌa adama u lyasuwa. ");
INSERT INTO tswNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","A̱vu aabara a nan ganu a yuwan Yesu yeci adama o ojoro a̱ yi nu uritosu wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Reve u usu, “N yuwusan ta̱ adanshi adama koyan ɗa uwwa. N ritosu ta̱ a̱ a̱ꞌisa̱ na̱ a̱ A̱a̱ꞌisamapaɗa, uba̱ta̱ u na aza a Israꞌila suru o tsu ɓoloto. N damma ko ili i ta̱ usokowu shi. ");
INSERT INTO tswNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Adama a̱ nye vee eceshe mu cuꞌun vi ili i nda? Ece ama a na a uwwai uritosu u va̱. E reve ta̱ ili i na n dammai.” ");
INSERT INTO tswNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ana Yesu dammai ne, a̱vu duga̱ri ro ɓasa yi o ugbaguzu a̱vu u damma, “Zane ɗa a̱vu a na vaa yuwaan aabara a nan ganu† cuꞌun va adanshi o ndolo?” ");
INSERT INTO tswNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","A̱vu u damma, “Na̱ n damma ta̱ ili i ro i na Wila̱ u dammai u ri mejege shi, i roco iliꞌi. Agba ni ili i na n dammai amayun a ɗa, adama a̱ nye vu ɓasa numu?” ");
INSERT INTO tswNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yesu ubuwu wunlu ɗaɗa Hanana ca̱co niyi a̱ tyo ya Kayafa aabara a nan ganu. ");
INSERT INTO tswNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ili i nda a farasa pe a̱tsuma̱, Simo Bituru ɗe mishin zuzu na akina a lyasuwusa. Ɗaɗa e ece niyi, “A̱vu za vi itoni ya̱ Yesu ɗa, ko ne ɗa shi?” A̱vu u wasan reve u damma, “Oꞌo, a̱mu ɗa shi!” ");
INSERT INTO tswNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Aagbashi o ro a aabara a nan ganu a̱ shi ta̱ lo. Maci vuma na Bituru koɗoi utsuvu u ɗa. A̱vu u damma, “Me ene wu ta̱ uba̱ta̱ a ɗanga zetun, ko me ene wu shi?” ");
INSERT INTO tswNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","A̱vu Bituru wasisan, a mantsaꞌa a̱vu moton ma saalashi. ");
INSERT INTO tswNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ana Kayafa kotoi ugeꞌetosu wa̱ Yesu na̱ wasasa, ɗaɗa azagbain a Israꞌila a tara niyi a̱ tyo uba̱ta̱ wa Bilatu† gwamna vuma va̱ Roma. A̱vu amaꞌa e isawan a alanga. Na̱ shi za ro uwa pe, u shi to oꞌwo babu cece, agba Wila̱ u shi a lyawa yi u yuwan A̱buki a Mapasa shi. ");
INSERT INTO tswNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","A̱vu Bilatu uta̱ a alanga reve we ece le, “Adanshi a̱ nye a ɗa i ta̱wa̱yi a aci a vuma nda?” ");
INSERT INTO tswNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Reve a̱ usu, “Na̱ shi vuma nda za vu ulinga wi iwuya i ɗa shi, tsu shi a̱ ta̱wa̱ na̱ a̱yi uba̱ta̱ wa̱ wu shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","A̱vu u damma le, “To, a̱ɗu na aciya̱ɗu tara niyi i ꞌya̱wa̱ i geꞌeto yi cine Wila̱ u ɗu u dammai i geꞌeto yi.” Reve a wasan a damma, “A̱ɗu a̱za̱ a̱ Roma i tsu lyawa tsu tsu una vuma shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ili i na a dammai u roco ta̱ ili i na Yesu dammai ɗe cine wa̱a̱ kuwa̱ u fara ta̱ o oꞌuso amayun. ");
INSERT INTO tswNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Reve u ka̱mba̱ o ukobu a̱vu u ɗe Yesu a̱vu we ece yi, “A̱vu ɗa mogono ma aza a Israꞌila?” ");
INSERT INTO tswNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","A̱vu u damma, “Yeci ya̱ wu i ɗa ndaꞌa, ko ama o ro a yuwaan wu ta̱ adanshi a̱ va̱?” ");
INSERT INTO tswNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Reve u usu, “Vu reve ta̱ a̱mu za va Israꞌila ɗa shi! Ama a̱ wu na̱ nan ganu a gbagbain a ɗa a̱ ta̱wa̱i na̱ a̱vu ya̱ꞌa̱ va̱. Nye i ɗa gba vu yuwain?” ");
INSERT INTO tswNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Reve Yesu usu, “Tsugono tsa̱ va̱ za vu uvaɗi u nda u ɗa shi. Na̱ shi za vu uvaɗi u nda u ɗa, agbashi a̱ va̱ a̱ shi ta yuwan nla̱ngi adama a zuwa mu e ekere a azagbain a Israꞌila wan. A̱mu n ri ana ngono n na maa yuwusan tsugono pa o uvaɗi shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","A̱vu we ece yi, “A̱vu mogono ma ɗa, ko ne ɗa shi?” Reve u usu yi, “Vu damma ta̱ a̱mu mogono ma ɗa, waru vu damma ta̱ mejege. A̱yi ɗa i zuwai a matsan numu, a̱vu n ta̱wa̱ o uvaɗi adama n damma ama amayun. Waru za na ri za va amayun tsu poloo mu ta̱ atsuvu.” ");
INSERT INTO tswNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","A̱vu we ece yi, “Nye i ɗa amayun?” Ana Bilatu dammai ne, a̱vu wu utisa̱ a̱ tyo ya aza a Israꞌila a̱vu u damma le, “Vuma nda yuwan ili i na i rawai n damma, ‘Nu u ciga u ꞌyuwan u kuwa̱’ shi. ");
INSERT INTO tswNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","I reve n tsu ba̱ɗa̱ ta̱ vuma ta̱ a̱tsuma̱ o uꞌwa wa ali u ka̱ra̱ a mantsa ma̱ A̱buki a Mapasa. I ciga ta̱ n lyawa ‘mogono ma aza a Israꞌila?’ ” ");
INSERT INTO tswNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Reve a saala, “Oꞌo, a lyawa yi wan! Tsu ciga ta̱ a lyawa Baraba.” (Baraba gba u shi ta̱ u tsu ꞌya̱sa̱sa̱n nla̱ngi.) ");
INSERT INTO tswNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Reve Bilatu† damma a̱soja a faba Yesu na asuɗu. ");
INSERT INTO tswNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Reve a ɗava ookokolo e eten a awanda, a̱vu a zuwayi a aaci, a̱vu o oto yi aayala a sawun da̱a̱n-da̱a̱n. ");
INSERT INTO tswNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","A̱vu a̱ ta̱wusa̱ ya̱ꞌa̱ yi na a dammi, “Wuma wa̱ wu u jima, mogono ma aza a Israꞌila!” Na a ɓasasa niyi o ugbaguzu. ");
INSERT INTO tswNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","A̱vu Bilatu ka̱ra̱ o utisa̱ waru, reve u damma amaꞌa, “Uwwai, n ta̱ o uta̱ yi pa nda ya̱ꞌa̱ ɗu, adama i reve n tsura̱ ili i ro i na yaa zuwa n kototo yi shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Reve Yesu uta̱, wotowu no ookokolo a awanda† na aayalaꞌa. A̱vu Bilatu damma le, “Apa vumaꞌa!” ");
INSERT INTO tswNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ana nan ganu a gbagbain oɓolo na̱ a̱duga̱ri a̱ A̱a̱ꞌisamapaɗa e ene niyi, reve a saala, “Vara niyi a akpata!† Vara niyi a akpata!” A̱vu u usu, “I tara yi reve i vara yi a akpata. N tsura̱ ili i na yaa zuwa n kototo yi shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Reve a̱ usu, “U damma ta̱ a na a̱yi Mawun ma̱ A̱sula̱ ma ɗa. Adama o ndolo, Wila̱ u tsu u damma ta̱ u kuwa̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ana wu uwwai ili i nda, reve wu uwwa wovon lon. ");
INSERT INTO tswNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","A̱vu u ka̱ra̱ a̱ ka̱mba̱ o ukobu wa̱ yi reve we ece Yesu, “Te ɗa vu uta̱i?” Agba u usu ili i ro shi. ");
INSERT INTO tswNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","A̱vu Bilatu damma, “Vu ꞌyuwan ta̱ a yuwan adanshi na̱ a̱mu? Vu reve, n ta̱ nu ucira u na maa lyawa wu vu ka̱ra̱ pere, ko n zuwa a vara wu a akpata.” ");
INSERT INTO tswNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","A̱vu u usu, “Vu ta gura yuwaan mu ne adama a na A̱sula̱ a zuwa nuwu vu yuwan. Vuma na ca numu e ekere a̱ wu u laꞌa wu ta̱ unusu.” ");
INSERT INTO tswNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ana wu uwwai ili i nda, u shi ta̱ u ciga u lyawa yi u ka̱ra̱ pere. A̱vu azagbain a Israꞌila a lyuwa elime na̱ yisaali, “Na̱ vu lyawa vuma nda pere, a̱vu iꞌutsa̱ i Mogono Kaisa ɗa shi! Vuma na suru tarai aciya̱yi mogono ma ɗa, vuma ndolo maꞌyuwatan mo mogono ma ɗa!” ");
INSERT INTO tswNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ana wu uwwai ili i na aa dansa, reve wu uta̱ na̱ Yesu a alanga a̱vu u da̱nu o ootogu o ugeꞌetosu o ukobu u na a̱ tsu ɗe Ukobu u na a̱ Ruꞌwa̱i na Atali a Gbagbain. (Aala o uba̱ta̱ u nda na̱ Tsuꞌarama† a̱yi ɗa “Gabata.”) ");
INSERT INTO tswNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Gogo urana u ta̱ e meremee ma aci o Urana wi Ifoɓi ya̱ A̱buki a Mapasa. Reve u damma aza a Israꞌilaꞌa, “Apa ɗu mogono ma̱ ɗu!” ");
INSERT INTO tswNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Reve a̱ ka̱mbuwa̱ yi na̱ yisaali, “Una niyi! Una niyi! Vara yi a akpata!” A̱vu we ece le, “I ciga ta̱ n vara mogono ma̱ ɗu a akpata?” Reve nan ganu a gbagbain a̱ usu, “Tsu ri na̱ mogono mo ro shi, she Kaisa!” ");
INSERT INTO tswNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Reve u ca le Yesu adama a vara yi a akpata. A̱vu a̱soja a tara Yesu reve a̱ ka̱ra̱ na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","A̱yi a̱ mota̱a̱ a̱tsuma̱ a̱ lyuciꞌi, u tanu ta̱ akpata† a̱ yi a̱ tyo Uba̱ta̱ wo Ookoluwo. (Aala o uba̱ta̱ꞌa̱ na̱ Tsuꞌarama a̱yi ɗa “Gologota”†). ");
INSERT INTO tswNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Uba̱ta̱ u ɗaɗa a vara niyi a akpata.† A yuwaan ta̱ ne waru a̱za̱ o uꞌwa wa ali e re o ro, vuma ta̱ suru e eeɓele a̱ ta̱, Yesu gba e memere. ");
INSERT INTO tswNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Reve Bilatu zuwa le a zuwa ɗe iroci zuva va a akpataꞌa, adansa, Yesu va Nazara, mogono ma aza a Israꞌila. ");
INSERT INTO tswNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Reve a ɗana irociꞌi toto utaꞌatsu: Za vu ufaru na̱ Tsuyahuda,† waru na̱ Tsuroma, waru na̱ Tsuheleni.† Ama na̱ a̱bunda̱ e ɗe yi ta̱ nu una̱, adama a na uba̱ta̱ u na a varai Yesu a akpata u ri alanga na̱ lyuci shi. ");
INSERT INTO tswNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Reve nan ganu a gbagbain a damma Bilatu, “She vu ɗana, ‘Mogono ma aza a Israꞌila’ wan, amma vu ɗana, ‘Vuma nda damma ta̱ a̱mu ɗa mogono ma aza a Israꞌila.’ ” ");
INSERT INTO tswNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","A̱vu u usu, “N ɗana yi ta̱ ne, waru ne ɗa u ri.” ");
INSERT INTO tswNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ana a̱soja o kotoi mavara ma̱ Yesu a akpata, reve a tara itana ya̱ yi a̱vu e neꞌeshen ba̱ta̱ na̱shi. Soja suru ta̱ nu upasu wa̱ yi. Reve fo a tara utugu wu ugaꞌan wa̱ yi, za na da̱na̱i uɗavu diga zuva a̱ cipa̱. ");
INSERT INTO tswNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Reve a dammulai va̱ni le, “She tsu karai a̱yi nda ba̱ta̱ ba̱ta̱ wan. Tsu yuwain ancaꞌwa adama tsu reve za na aa tara yi.” Ili i nda i fara ta̱ adama e ili i na Adanshi a̱ A̱sula̱ a dammai wo oꞌwo amayun: “E neꞌeshen ta̱ itana i va̱ va̱ni le, a̱vu a yuwan ancaꞌwa adama o utugu u va̱.” A̱yi nda gba, a̱yi ɗa ili i na a̱sojaꞌa a yuwain. ");
INSERT INTO tswNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Mma va̱ Yesu da̱na̱ ta̱ lo mishin a̱ ngeꞌen ma akpata oɓolo na̱ mma keꞌen va̱ yi. Meri ka va Kiliyofa na̱ Meri Magadaliya a̱ da̱na̱ ta̱ lo fo. ");
INSERT INTO tswNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Oojoro a na u cigai da̱na̱ ta̱ lo fo zuzu na̱ mma va̱ Yesu. Ana Yesu ene nle oɓolo, reve u damma mma va̱ yi, “Vuma nda mawun ma̱ wu ma ɗa gogo.” ");
INSERT INTO tswNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Reve u damma oojoroꞌo, “A̱yi ɗa mma va̱ wu gogo.” Diga lo ɗa oojoro o ndolo a tara niyi a̱ tyo o uꞌwa wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu reve ta̱ a na u kotoi ɗe ulinga wa̱ yi. Amma adama u lyawa Adanshi a̱ A̱sula̱ o oꞌwo amayun, reve u damma, “N ta uwwusa akuli!” ");
INSERT INTO tswNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Meden ma̱ da̱na̱ ta̱ lo tapu na̱ mini ma alamu, a̱vu a̱sojaꞌa a̱ tsupu pe ashiɗi. Ɗaɗa a̱ nla̱ niyi o oosondori,† reve a canana a zuwaa Yesu o una̱. ");
INSERT INTO tswNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ana Yesu sowoi miniꞌi, a̱vu u damma, “U koto ta̱.” A̱vu u ka̱ɗa̱to aaci, reve u kuwa̱. ");
INSERT INTO tswNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Urana u nda Urana wi Ifoɓi i ɗa, agba nu usana u tawa Ashibi a ɗa za na wo oꞌwoi a̱ba̱jini o urana waru Urana u Mapasa u ɗa. Ana wo oꞌwoi aza a Israꞌila a ciga a lyawa lipu le zuva va akpataꞌa† shi hali urana wa Ashibi, a̱vu a pati Bilatu u lyawa a̱soja a kukuɗa ana a aza a na a̱ da̱na̱i ɗe a akpata adama a̱ kuwa̱ goꞌo. Reve waru a̱ cipa̱to lipu le e iɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","A̱vu a̱sojaꞌa a fara kuɗa ana a ama e reꞌe aza a na a̱ da̱na̱i zuva va akpata e eɓele e Yesu. ");
INSERT INTO tswNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Amma ana a rawai uba̱ta̱ wa̱ Yesu, reve e ene u kuwa̱ ta̱ ɗe, agba a kuɗa ana a̱ yi shi. ");
INSERT INTO tswNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","A̱vu za ta̱ a̱tsuma̱ a̱ a̱sojaꞌa tara ibata ya̱ yi reve u sapa Yesu e eeɓele. Reve mpasa na̱ mini mo uta̱. ");
INSERT INTO tswNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tsu reve ta̱ ili i nda amayun a ɗa, adama a na za na enei ne esu ɗa dammai. U damma ta̱ ne adama a̱ɗu fo i usu. ");
INSERT INTO tswNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ili i nda i fara ta̱ adama Adanshi a̱ A̱sula̱† a shiwan: “Ko eetele a̱ ta̱ a̱ yi aa kuɗa shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Waru Adanshi a̱ A̱sula̱ o ro a damma ta̱, “A̱ ta̱ ka̱lyuwa̱ vuma na a sapai ni ibata.” ");
INSERT INTO tswNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ana ili i nda i kotoi, reve Isuhu, vuma lyuci va Arimatiya, pati Bilatu ko u ta lyawa yi u tara lipu va̱ Yesu. (Isuhu za vi itoni va̱ Yesu ɗa, amma usokowu, adama a na wu uwwusa ta̱ wovon wa azagbain a Israꞌila.) A̱vu Bilatu usu, reve Isuhu ꞌya̱wa̱ u tara lipuꞌu u ka̱ra̱ na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimu, za na shi ta̱wa̱i ɗe ya̱ Yesu na ayin, shewun ta̱ Isuhu. A̱vu u ta̱wa̱a̱ na̱ a̱guma̱ a̱ ma̱guru e re na rawai uritowu ukpaku na a̱ tsu tsuwa̱a̱n a̱a̱kwa̱kwa̱. ");
INSERT INTO tswNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ama e re a nda a tara ta̱ lipu va̱ yi reve a katala yi a̱ka̱nda̱ruwa̱ no okoro oɓolo na̱ a̱guma̱ꞌa̱. Ne ɗa aza a Israꞌila a tsu yuwan na̱ a̱a̱ ciɗo a̱a̱kwa̱kwa̱. ");
INSERT INTO tswNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Uba̱ta̱ u mavara ma akpataꞌa u ta̱ zuzu na̱ a̱a̱rumbu, a̱tsuma̱ a̱ a̱a̱rumbuꞌu aason a saꞌavu a̱ da̱na̱ ta̱ pe za na koto a yuwain ulinga na̱ a̱yi shi. ");
INSERT INTO tswNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Adama a na wo oꞌwoi Urana wi Ifoɓi u ɗa kafu Mapasa,† waru adama a na aasoꞌon a̱ ri zuzu, ɗaɗa a zuwai pe lipuꞌu. ");
INSERT INTO tswNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nu usana wa Aladi uba̱ta̱ ubuwu haɓa, a̱vu Meri Magadaliya ka̱ra̱ a̱ ꞌya̱wa̱ a aasoꞌon, reve we ene aatali a aasoꞌon ugandaluwu utakatsuwu nu una̱ntsu wa aasoꞌon. ");
INSERT INTO tswNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Reve u suma a̱ ꞌya̱wa̱ ya̱ Bituru za na a̱tsu ɗe Simo oɓolo no oojoro o ro, za na Yesu cigai, a̱vu u damma le, “A tara ta̱ Zagbain pe a aasoꞌon, agba tsu reve uba̱ta̱ u na a zuwa niyi shi!” ");
INSERT INTO tswNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Reve Bituru no oojoroꞌo a̱ ka̱ra̱ a̱ ꞌya̱wa̱ ɗe. ");
INSERT INTO tswNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Mere me le a̱ da̱na̱ ta̱ e ilaɗi, agba oojoro o roꞌo a sara ta̱ Bituru hali u fara rawaa yi. ");
INSERT INTO tswNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ana u ka̱nza̱ u ka̱lyuwa̱i a̱tsuma̱ a aasoꞌon, reve we ene pe okoro goon, agba u uwa pe shi. ");
INSERT INTO tswNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ɗaɗa Simo Bituru a rawa a̱vu u uwa pe, reve we ene pe okoroꞌo. ");
INSERT INTO tswNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","We ene ta̱ fo apaɗi o okoro a na a palayi urewesu wa̱ Yesu na̱ a̱yi. A̱ kutsulu yi ta̱, reve wo oꞌwo upasu u ta̱. ");
INSERT INTO tswNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Reve oojoro o roꞌo, za na fara rawai a aasoꞌon fo u uwa pe. Reve we ene a̱vu u usu a na a̱ ꞌya̱sa̱in Yesu a̱tsuma̱ a̱ a̱kwa̱kwa̱. ");
INSERT INTO tswNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(A mantsa mo ndolo koto a̱ shi e reve ili i na Adanshi a̱ A̱sula̱ a dammai a na amayun a ɗa a ciga a ꞌyuwan u ꞌyon a̱tsuma̱ o ukwa̱ shi.) ");
INSERT INTO tswNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Reve ojoroꞌo a̱ ka̱ra̱ a̱ ka̱mba̱ o uꞌwa. ");
INSERT INTO tswNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Meri gba wi isawan ta̱ a alanga a aasoꞌon e mesun. Reve u ka̱nza̱ u ka̱lyuwa̱ a̱tsuma̱ a aasoꞌon. ");
INSERT INTO tswNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","A̱vu we ene pe nlingata ma̱ A̱sula̱ n re. A̱ da̱na̱ ta̱ wotowu ni itana i uri waru a̱ da̱na̱ ta̱ nden uba̱ta̱ u na lipu va̱ Yesu shi. Za ta̱ da̱na̱ ta̱ uba̱ta̱ a aaci za ta̱ gba shi uba̱ta̱ wa ana. ");
INSERT INTO tswNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Reve e ece yi, “Adama a̱ nye vu ri e mesun?” A̱vu u usu, “A tara ta̱ Zagbain va̱, agba n reve uba̱ta̱ u na a zuwa niyi shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ana Meri dammai ne, reve u vadala a̱vu we ene Yesu mishin lo, agba u gura reve a na Yesu ɗa shi. ");
INSERT INTO tswNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Reve Yesu ece yi, “Adama a̱ nye vu ri e mesun? Zane ɗa vu ri e izami?” A̱vu u yuwan majiyan gashi a̱yi ɗa wa̱a̱ ka̱lyuwusa̱ a̱a̱rumbuꞌu a̱vu u damma, “Zagbain, nna̱ a̱vu ɗa vu tarai lipu va̱ Yesu, m pati wu ta̱ vu yuwan ankuri, vu damma mu, adama n ꞌya̱wa̱ n tara yi.” ");
INSERT INTO tswNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","A̱vu u damma yi, “Meri.” A̱vu Meri vadala a̱ tyo ya̱ꞌa̱ yi, reve u damma, “Rabboni!”† (Na̱ Tsuꞌarama† “Rabboni” urevu wa̱ yi a̱yi ɗa “Manlu.”) ");
INSERT INTO tswNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Reve Yesu damma yi, “She vu reme mu wan, adama a na koto n ka̱ra̱ a̱ tyo ya Dada shi. Amma vu ka̱ra̱ a̱ tyo uba̱ta̱ o ojoro a̱ va̱ vu damma le, ‘N ta̱ ka̱ra̱ a̱ ka̱mba̱ uba̱ta̱ wa Dada va̱ za na ri fo Dada ɗu. A̱yi ɗa A̱sula̱ a̱ va̱, waru a̱yi ɗa A̱sula̱ a̱ ɗu.’ ” ");
INSERT INTO tswNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Reve u ka̱ra̱ u ꞌya̱wa̱ u damma ojoroꞌo a na we ene ta̱ Zagbaiꞌin. Reve waru u damma le ili i u damma niyi. ");
INSERT INTO tswNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na ayin o urana wa Aladi o ndolo, a̱vu ojoroꞌo o ɓoloto a aasula a̱ ta̱ a̱vu a katsu na̱ntsu, adama a na a uwwusa ta̱ wovon wa azagbain a Israꞌila. Reve Yesu ta̱wa̱ wi isawan e memere me le babu usa̱n, a̱vu u ca̱sa̱ le, adansa, “N yuwan ta̱ avasa i tsura̱ asuvu nden.” ");
INSERT INTO tswNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ana u dammai ili i nda, reve u roco le antsu e ekere a̱ yi na̱ za ve eeɓele. Ojoroꞌo a shiwan ta̱ na̱ ma̱za̱nga̱ adama a na e te inda Zagbain. ");
INSERT INTO tswNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Reve u dammisa, “Asuvu nden n da̱na̱ oɓolo na̱ a̱ɗu. Cine Dada va̱ lyungu numu a̱tsuma̱ o uvaɗi, ne ɗa fo ma̱a̱ lyungusu ɗu.” ");
INSERT INTO tswNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","A̱vu wi ivuwaan le reve u damma, “Ushiyi Ruhu va Akiza. ");
INSERT INTO tswNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nni i yuwaan ama gafura vu nusu le, A̱sula̱ fo u ta yuwaan le, o to oꞌwo na̱ gafura. Nna̱ gba i ꞌyuwan a yuwaan le gafura, A̱sula̱ fo u ta ꞌyuwan a yuwaan le gafura.” ");
INSERT INTO tswNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Za ro a̱tsuma̱ a Kupanejereꞌe, Toma (za na waru a̱ tsu ɗe fo Mepishe), u da̱na̱ oɓolo ne ele shi, a mantsa ma na Yesu rocoi aciya̱yi. ");
INSERT INTO tswNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ana u rawai, reve akapi o ojoro a damma yi, “Tse ene ta̱ Zagbain!” Amma a̱vu Toma damma, “Ma̱a̱ usu shi she na̱ me ene antsu e ekere a̱ yi, waru she na̱ n juꞌwa̱n antsuꞌu na aakatsu a̱ va̱ uba̱ta̱ u na ikusa i da̱na̱i, waru n oto ukere u va̱ a̱tsuma̱ a̱ wuntsu we eeɓele a̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ana a yuwain ajuma a̱ ta̱, reve ojoroꞌo o ɓolotowiso a aasulaꞌa, waru Toma da̱na̱ ta̱ oɓolo ne ele. Reve a katsu na̱ntsu vadamma nu ufaru, amma a̱vu Yesu ta̱wa̱ wi isawisan e memere me le babu usa̱n. A̱vu u ca̱sa̱ le, reve u damma, “N yuwan ta̱ avasa i tsura̱ asuvu nden.” ");
INSERT INTO tswNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Reve u damma Toma, “Ka̱lyuwa̱ ekere a̱ va̱. Zuwa aakatsu a̱ wu antsuꞌu. Oto ukere wa̱ wu e eeɓele a̱ va̱. Vu lyawa mawasan a na va̱a̱ usu.” ");
INSERT INTO tswNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","A̱vu u usu yi, “A̱vu ɗa Zagbain va̱ na̱ A̱sula̱ a̱ va̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Reve u damma yi, “Vu usu ta̱ o una̱ na ve ene numu. Aza abaꞌun a ɗa aza a na e ene numu shi a̱vu gba a̱ usu.” ");
INSERT INTO tswNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ojoro e Yesu e ene yi ta̱ a yuwusan iroci yi linga va asalama ro na̱ a̱bunda̱ aza a na a ɗanai a̱tsuma̱ a aatagada a nda shi. ");
INSERT INTO tswNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","N ɗana ta̱ ili i nda adama i usu a na Yesu ɗa Zamawawa, Mawun ma̱ A̱sula̱, waru adama a na i usu niyi, i ta̱ tsura̱ wuma. ");
INSERT INTO tswNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","A̱ tyo ɗe, reve Yesu rocowiso aciya̱yi uba̱ta̱ wo ojoro a̱ yi a̱ ngeꞌen m Mala ma̱ Ga̱lili. Apa cine iliꞌi i farai: ");
INSERT INTO tswNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ojoro a̱ yi na̱ a̱bunda̱ a̱ da̱na̱ ta̱ lo: Simo Bituru, na̱ Toma (za na a̱ tsu ɗe Mepishe), na̱ Nataniya va Kana va̱ Ga̱lili, na̱ muwun ma̱ Za̱ba̱di, no ojoro e re o ro. ");
INSERT INTO tswNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Reve Simo Bituru damma a̱za̱ a̱ yi, “A̱mu n ta̱ ꞌya̱wa̱ mereme ma mugula ni igolo.” Reve a̱za̱ a̱ yi a damma, “A̱tsu fo tsu ta̱ ꞌya̱wa̱ oɓolo na̱ a̱vu.” A̱vu a̱ ka̱ra̱ a̱ ꞌya̱wa̱ a wantsun u le. Agba e reme ko ili i shi na ayin o ndolo. ");
INSERT INTO tswNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ana usana u tawai na̱ wasasa, reve Yesu isawan a̱ ngeꞌen m malaꞌa, agba ojoroꞌo e reve a na Yesu ɗa shi. ");
INSERT INTO tswNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Reve u ɗe le, “Ama a̱ va̱, i reme ta̱ ɗe mugula?” A̱vu a̱ usu, “Oꞌo.” ");
INSERT INTO tswNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Reve u damma le, “Variyi igolo i ɗu usaꞌani u wantsun u ɗu, i te reme ozo o ro.” Reve a yuwan ne, a̱vu igoloꞌo e reme mugula ma̱ a̱bunda̱ hali a̱ kuɗa̱ o rono yi. ");
INSERT INTO tswNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Reve oojoro a na Yesu cigai damma Bituru, “Zagbain ɗa!” Ana Simo Bituru uwwai a na Zagbain ɗa, reve wo oto utugu wa̱ yi (adama a na u shi ta̱ u foɗo yi ana u da̱na̱i o ulinga), a̱vu wu teruwe a̱ mini u reme uda̱su a̱ tyo uba̱ta̱ wa̱ Yesu. ");
INSERT INTO tswNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Reve akapi o ojoro o toni yi a̱tsuma̱ a wantsuꞌun, uguzu ni igoloꞌo tapu na̱ mugula. A̱ da̱na̱ alanga ni iɗa shi, alanga e le a̱ da̱na̱ ta̱ zuzu na ana ukpakutaꞌatsu (300). ");
INSERT INTO tswNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ana ojoroꞌo o uta̱i a̱tsuma̱ a wantsuꞌun, reve e ene u ta̱ ni ilyalya, waru u da̱na̱ ta̱ a̱ zusun mugula na akinkina. ");
INSERT INTO tswNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","A̱vu u damma, “Ta̱wa̱i na̱ mugula n ro n na i remei gogo.” ");
INSERT INTO tswNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Reve Simo Bituru ka̱ra̱ u uwa a̱tsuma̱ a wantsuꞌun, reve u rono igoloꞌo a̱ tyo e iɗa. A̱tsuma̱ a̱ yi mugula m gbagbain ukpaku na̱ kupoton na aza a taꞌatsu (153) n da̱na̱ ta̱ pe. Agba suru na̱ ne igoloꞌo i kara shi. ");
INSERT INTO tswNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Reve Yesu damma le, “Ta̱wa̱i i lyuwa.” Ko za ta̱ gba a̱tsuma̱ o ojoroꞌo gura ece yi, “Zane ɗa vu ri?” shi, adama a na e reve ta̱ a na Zagbain ɗa. ");
INSERT INTO tswNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","A̱vu u ꞌya̱wa̱ u tara ilyalya, reve u ca le. Reve waru u ca le fo mugulaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","A̱yi nda, a̱yi ɗa wa taꞌatsu a na u rocoi aciya̱yi uba̱ta̱ wo ojoroꞌo ana a̱ ꞌya̱sa̱n niyi a̱tsuma̱ o ukwa̱. ");
INSERT INTO tswNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ana o kotoi alya, reve Yesu ece Simo Bituru, “Simo mawun ma Yahaya, vu laꞌa ta̱ a̱za̱ a̱ wu ciga mu?” A̱vu u usu, “Ee, Zagbain, vu reve ta̱ a na n ciga nuwu.” Reve u damma, “Vu lyuwato mukyokyon n va̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Reve we ecishe yi we ire, “Simo mawun ma Yahaya, vu ciga mu ta̱?” A̱vu u usu, “Ee, Zagbain, vu reve ta̱ a na n ciga nuwu!” A̱vu u damma, “Vu ka̱lyuwa̱ ikyon i va̱.” ");
INSERT INTO tswNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Reve we ecishe yi wa taꞌatsu, “Simo mawun ma Yahaya, vu ciga mu ta̱?” Bituru yuwan ta̱ a̱tsumola̱ngu adama a na Yesu yuwan yi ta̱ yeci hali utaꞌatsu ko u ciga yi ta̱. Adama o ndolo reve u damma Yesu, “Zagbain, vu reve ta̱ ili suru. Vu reve ta̱ a na n ciga nuwu.” A̱vu Yesu damma yi, “Vu lyuwato ikyon i va̱. ");
INSERT INTO tswNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","N ta dansaa wu amayun, a̱vu o ulobo, vu tso oto ta̱ itana i na vu cigai, reve vu ꞌya̱wa̱ uba̱ta̱ u na vu cigai. Agba na̱ vu kutsa, vu ta̱ buba̱ruwa̱ e ekere a̱ wu. Reve ozo o ro a̱ nla̱ wu a̱vu a tara wu a̱ tyo uba̱ta̱ u na vu cigai shi.” ");
INSERT INTO tswNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(U damma ta̱ ne adama u roco cine Bituru a̱a̱ kuwa̱, reve u ca A̱sula̱ tsugbain.) Reve u damma Bituru, “Toni mu!” ");
INSERT INTO tswNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","A̱vu Bituru vadala reve we ene oojoro o ro, za na Yesu cigai. Waru a̱yi ɗa fo za na raɓatoi Yesu ele a alya a̱vu we ece, “Zagbain, zane ɗa aa wina wu?” ");
INSERT INTO tswNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ana Bituru ene niyi, a̱vu we ece Yesu, “Zagbain, ili i ne yaa cina yi?” ");
INSERT INTO tswNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Reve u usu yi, “Nna̱ n ciga ta̱ u yuwan wuma hali mantsa ma na ma̱a̱ ka̱mba̱, te imini ya̱ wu na adama o ndolo? Vu toni mu.” ");
INSERT INTO tswNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Adama o ndolo reve aalabariꞌi a baza a̱tsuma̱ a̱ a̱za̱ e Itoni a na, a̱yi nda wa̱a̱ kuwa̱ shi. Agba Yesu damma ne shi. Ili i na u dammai a̱yi ɗa, “Nna̱ n ciga ta̱ u yuwan wuma hali mantsa ma na ma̱a̱ ka̱mba̱, te imini ya̱ wu na adama o ndolo?” ");
INSERT INTO tswNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","A̱yi oojoro† a nda a̱yi ɗa u dammai ili i nda suru. U ɗana yi ta̱, waru tsu reve ta̱ a na amayun a ɗa waa dansa. ");
INSERT INTO tswNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu yuwan ta̱ ili i ro na̱ a̱bunda̱. Nna a ɗana ili i ndolo suru a̱tsuma̱ a atagada, n jiyan a̱tsuma̱ o uvaɗi suru a na a̱a̱ tsura̱ uba̱ta̱ u na waa rawa a na a zuwa atagadaꞌa suru shi.");
INSERT INTO tswNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiwofilu, a aatagada o ufaru u va̱ n damma wu ta̱ ili i na Yesu temei mayan oɓolo ni ili i na u ritosuyi, ");
INSERT INTO tswNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hali urana u na a tara niyi a̱ tyo zuva. Amma kafu a tara yi a̱ tyo zuva ɗaɗa u yuwayin ajiya† a na u ɗangwai adanshi a̱ a̱ɓula̱ nu ucira u Ruhu va Akiza. ");
INSERT INTO tswNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ana u kuwa̱i, u rocosu le ta̱ aciya̱yi wuma, reve u roco le a na u ꞌyoyin na̱ linga icuꞌun icuꞌun. U yuwan ta̱ rana amunga a yuwusan adanshi adama o tsugono tsa̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","A yashi i na u da̱na̱i a alya oɓolo ne ele, u damma le ta̱, “She i lyawa Urishelima wan.† Amma i puro she na̱ nzuwulai n na Dada yuwain u shiwan neꞌen, za na n damma nɗu nu una̱ u va̱, ");
INSERT INTO tswNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yahaya rumbu ta̱ ama na̱ mini. Aa jima shi, a̱vu a̱ rumbu ɗu na̱ Ruhu va Akiza.” ");
INSERT INTO tswNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ana ajiya a̱ da̱na̱i oɓolo na̱ Yesu,† e eceshe yi ta̱, “Zagbain, gogo ɗa va̱a̱ ka̱mbuwa̱a̱ aza a Israꞌila na̱ tsugono tse le waru?” ");
INSERT INTO tswNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Reve u usu le, “Dada ɗa goon ri nu ucira u na woo foɓo yashi na̱ mantsaꞌa, a̱ɗu gba a ca ɗu ucira u na yaa gura reve shi. ");
INSERT INTO tswNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Amma i ta̱ tsura̱ ucira na̱ Ruhu va Akiza† ta̱wa̱ ɗu. I to oꞌwo aza a na aa yuwan adanshi o una̱ u va̱ a̱tsuma̱ a̱ Urishelima na̱ a̱tsuma̱ a Yahuda, na̱ Samariya, hali a̱ tyo ukosu wu uvaɗi.” ");
INSERT INTO tswNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ana u dammai ne, ele a̱ a̱ka̱nla̱, reve a tara yi a̱ tyo zuva. Reve eleshe o ro a pupala yi, a gura enishe yi shi. ");
INSERT INTO tswNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ajiyaꞌa lo a̱ ka̱lyuwusa̱ yi a̱ ka̱ra̱ a̱ tyo zuva, reve ama e re wotowu na̱ a̱tugu a̱ uri e isawan mishin zuzu ne ele. ");
INSERT INTO tswNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Reve a damma, “A̱ɗu ama a̱ Ga̱lili, adama a̱ nye i ri mishin a̱ a̱ka̱nla̱ zuva? Yesu na a tarai a̱tsuma̱ a̱ ɗu a̱ tyo zuva, u ta̱ ta̱wisa̱ ununa ye enei a tara niyi a̱ tyo zuva.” ");
INSERT INTO tswNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ana ili i ndolo i farai, reve ajiya a lyawa Masasan ma̱ Zetun, reve a yuwan mmalu u ta rawa ana ukpakukupa utaꞌatsu (3,000) a̱ ka̱mba̱ Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ana a̱ ka̱mba̱i a̱tsuma̱ a̱ lyuci gbain na a̱ da̱na̱i, reve a kumba o uꞌwa wa zuva u na a̱ da̱na̱i, ele ɗa nan Bituru na̱ Yahaya na̱ Yakubu na̱ Andarawu na̱ Filibu na̱ Toma na̱ Batalamawu na̱ Matta na̱ Yakubu mawun ma Alfa na̱ Simo za na fo a̱ tsu ɗe Bakanani, na̱ Yahuza mawun ma Yakubu. ");
INSERT INTO tswNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Suru nle reve o ɓoloto aciyele a yuwusan avasa kuci na̱ majiyan ma̱ ta̱, oɓolo na̱ a̱ma̱ci o ro, na̱ Meri† mma va̱ Yesu oɓolo na azawawaꞌa e Yesu suru. ");
INSERT INTO tswNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","A̱tsuma̱ a rana ndolo iɓolo ya ama ukpaku nu ushin (120) aza a na a cayi okolo a̱ da̱na̱ ta̱ lo. Reve Bituru ꞌyon mishin, reve u damma, ");
INSERT INTO tswNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“A̱za̱ a̱ va̱, a ciga a ꞌyuwan o shiton Adanshi a̱ A̱sula̱ a na Ruhu va Akiza yuwain o una̱ wa̱ Da̱wuda adama a Yahuza, za na uwai elime a aza a na e remei Yesu. ");
INSERT INTO tswNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yahuza vuma ɗa na da̱na̱i oɓolo na̱ a̱tsu, waru Yesu ɗangwa yi ta̱ tsa̱ra̱ u yuwan ulinga na̱ a̱tsu.” ");
INSERT INTO tswNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yahuza tsula ta̱ iɗa ni ikebe i na u winai Yesu, reve u riya̱ u cika̱to aaci, ɗaɗa a̱a̱tsuma̱ o ɓoso niyi, reve iliya̱tsuma̱ suru yu uta̱ a alanga. ");
INSERT INTO tswNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Aza a na a̱ ri nden suru a̱tsuma̱ a̱ Urishelima a uwwa ta̱ ili i na i farai, ɗaɗa e ɗeyi uba̱ta̱ꞌa̱ “Akaladama” ne elentsu e le, ana Uba̱ta̱ wu Mpasa.) ");
INSERT INTO tswNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Reve Bituru lyuwa elime na adanshi, “U tu uɗanu a Aatagada e Ica,† ‘Uꞌwa wa̱ yi wo oꞌwo ta̱ uvariyi, she vuma da̱nu pe wan.’ Reve waru u dammisa, ‘Tsugbain tsa̱ yi nanza tara.’ ");
INSERT INTO tswNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Adama o ndolo wo oꞌwo ta̱ a ciga a ꞌyuwan a ɗangula vuma ro o una̱ u vuma ndolo. Vuma ndolo o oꞌwo u da̱na̱ ta̱ oɓolo na̱ a̱tsu a mantsa ma na Yesu Zagbain da̱na̱i oɓolo na̱ a̱tsu. ");
INSERT INTO tswNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Waru wo oꞌwo u da̱na̱ ta̱ na̱ a̱tsu a mantsa ma na Yahaya rumbuyi Yesu, hali urana u na a tara niyi e memere ma̱ a̱tsu a̱ tyo zuva. Vuma na aa ɗangwa u ciga u ꞌyuwan woo oꞌwo za vu ucasu wa Alabari a Saꞌani adama o uꞌyosun wa̱ Yesu oɓolo na̱ a̱tsu.” ");
INSERT INTO tswNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ɗaɗa a zagwai ama e re: Isuhu za na a̱ tsu ɗe Basaba za va aala Yusutu oɓolo na̱ Mataya. ");
INSERT INTO tswNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Reve a yuwan avasa tsa̱ra̱ a gura ɗangwa vuma saꞌani na ntsayi. Reve a damma, “Zagbain, vu reve ta̱ ookolo a vuma suru, vu roco tsu vuma na vu cigai a̱tsuma̱ a ama e re a nda. ");
INSERT INTO tswNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Wo oꞌwo aajiya, u tara tsugbain tsa na Yahuza lyawai, adama a na u ꞌya̱wa̱i uba̱ta̱ u na wu ntsaa niyi.” ");
INSERT INTO tswNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Reve a zuwa aɗanga a aci e le, reve Mataya lyuwa, reve u ɓolo na akapi kupa na̱ za ta̱ na buwai. ");
INSERT INTO tswNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ana urana wa̱ A̱buki† o Urana wa Kupoton† a rawai, a̱za̱ e Itoni a̱ da̱na̱ ta̱ uba̱ta̱ u ta̱. ");
INSERT INTO tswNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ele lo babu urevu, ɗaɗa a uwwai ilama diga zuva gashi a̱ba̱jini o upepu a ɗa, reve u shiton uꞌwaꞌa suru u na a̱ ri pe nden. ");
INSERT INTO tswNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Reve ili i ro gashi elentsu a akina a̱ ta̱wa̱ ya̱ꞌa̱ le, reve u cipa̱ a aci e le. ");
INSERT INTO tswNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Reve o shiton le suru na̱ Ruhu va Akiza.† Reve e teme adanshi ne elentsu o ro kokoꞌo, cine Ruhu va Akiza neꞌe nle. ");
INSERT INTO tswNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Aza a Israꞌila a̱ a̱bunda̱ a na a uwwusa wovon wa̱ A̱sula̱ a̱ da̱na̱ ta̱ pe a̱tsuma̱ a̱ Urishelima a yuwusan a̱ga̱nda̱ a na a̱ ta̱wa̱i ba̱ta̱ ba̱ta̱. ");
INSERT INTO tswNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ana a uwwai ilama i ndolo, reve ama o ɓoloto a̱bunda̱. Reve a yuwan asalama lon, adama a na aza a na a̱ ri lo suru a uwwa ta̱ iɓolo ya̱ a̱za̱ e Itoni a yuwusan adanshi ne elentsu a̱ lyuci le. ");
INSERT INTO tswNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Reve a yuwan asalama a̱ a̱bunda̱, adansa, “Ashe aza a na a yuwusan adanshi a nda a̱za̱ a̱ Ga̱lili a ɗa suru shi? ");
INSERT INTO tswNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Cine wo oꞌwoi suru ntsu tsu uwwa nle a adanshi ne elentsu a̱ tsu? ");
INSERT INTO tswNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","A̱tsu ɗa pa nda aza a Paratiya na aza a Madaya oɓolo na aza a Elam na ama a Masapotomiya na aza a na o uta̱i Yahuda na aza a Kafadokiya na ama e iɗa ya Pontu na aza a Asiya. ");
INSERT INTO tswNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Na aza a Firijiya na aza a Bamafiliya waru na aza a Masar, na̱ a̱za̱ e iɗa ya Libiya zuzu na̱ Kurani omocin diga Roma a na a matsain a̱tsuma̱ a̱ a̱dini a aza a Israꞌila na aza a na a vadalai a uwai a̱tsuma̱ a̱ a̱dini a̱ tsu. ");
INSERT INTO tswNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","A̱tsu ɗa nda aza a Karita,† oɓolo na aza a Laraba suru ntsu tsu uwwa le ta̱ a yuwusan adanshi ne elentsu a̱ tsu a̱tsuma̱ e ili i na A̱sula̱ a yuwain.” ");
INSERT INTO tswNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Reve suru nle a lamba ili i na aa yuwan, reve a uwa asalama, adansa va̱ni le, “Nye i ɗa urevu wi ili i ndaꞌa?” ");
INSERT INTO tswNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Reve ozo o ro a uwa a yuwusaan le ulamu adansa, “Usowu u ɗa a̱ ri.” ");
INSERT INTO tswNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Reve Bituru ꞌyon mishin oɓolo na akapi a ajiya kupa na̱ za ta̱ na buwai, a̱vu u ꞌya̱sa̱n uɗyo a yuwusaan le adanshi, adansa, “Ama a Israꞌila na aza a na a̱ ri nden Urishelima, i zuwa atsuvu yu uwwa ili i na maa damma ɗu. ");
INSERT INTO tswNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ama a na ye eneshe nda a̱ ri usowu shi, ana wo oꞌwoi mantsa ma na tsu ri gogo rumu kucci vu usana ɗa. ");
INSERT INTO tswNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","A̱yi ili i nda a̱yi ɗa Juwe vumava̱sula̱ dammai, ");
INSERT INTO tswNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","A̱sula̱ a damma: ‘A mantsa mo ukosu n ta̱ lyungu Ruhu va̱ a̱ ꞌya̱wa̱ ba̱ta̱ a ama. Muwun n ɗu olobo ne esheli a ta yuwan adanshi o usokowu. Olobo a̱ ɗu e te ene alavu alavu. Mbara n ɗu waru a ta yuwan alavu a̱ a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Amayun Ruhu va Akiza ta̱ ta̱wa̱ uba̱ta̱ wa agbashi a̱ va̱, ali na̱ a̱ma̱ci a ta yuwan adanshi a̱ va̱ a rana ndolo. ");
INSERT INTO tswNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","N ta yuwan ili ya asalama zuva, waru n to roco iroci e iɗa, mpasa na akina na̱ mikyon n lima̱. ");
INSERT INTO tswNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","A̱ ta̱ ka̱mbuwa̱ urana irumbu, woto waru u to oꞌwo ushili ana mpasa kafu urana wu Zagbain u ta̱wa̱, urana u gbain u tsugbain. ");
INSERT INTO tswNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","A mantsa mo ndolo ma ɗa za na yuwain ɗewu a̱tsuma̱ a ala a Zagbain wa̱a̱ tsura̱ iwawi.’† ");
INSERT INTO tswNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“A̱ɗu a̱za̱ a̱ va̱ aza a Israꞌila, yu uwwa adanshi a na maa yuwan. Yesu va Nazara ɗa vuma na A̱sula̱ a kucinaa ntsu a na u usu niyi. Amayun e ili i ndolo A̱sula̱ o roco tsu ta̱ e ili ya asalama i na u yuwain, ni iroci za na u yuwain. Ili suru i fara ta̱ e esu a̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","A ca ɗu ta̱ a̱yi, reve yu una yi o ure u mavara a akpata.† I yuwan ta̱ ili i ndolo ni ikambi ya aza a na e revei Wila̱ shi. Na̱ ne suru, A̱sula̱ e reve ta̱ ili i ndolo i ta fara suru. U yuwan ta̱ ifoɓi i ndolo nu ujimu. ");
INSERT INTO tswNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Reve gba A̱sula̱ a̱ ꞌya̱sa̱n yi a̱tsuma̱ a̱ a̱kwa̱kwa̱, reve u ka̱mbuwa̱ yi wuma. Babu cine ukwa̱ waa gura guza̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Reve Da̱wuda yuwan adanshi adama a̱ yi, ‘Kuci ɗa n revei a na Zagbain ri oɓolo na̱ a̱mu. Adama a na u ri o ukere usaꞌani u va̱, babu ili i na maa uwwa wovon. ");
INSERT INTO tswNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Adama o ndolo ookolo a̱ va̱ a̱ ta̱ asuvu nden, eelentsu a̱ va̱ a̱ ta̱ na̱ ma̱za̱nga̱, lipu va̱ waru ta̱ da̱na̱ nu uzuwu wo okolo. ");
INSERT INTO tswNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Waa lyawa wuma u va̱ a aason shi, waa lyawa Mawun ma Akiza ma̱ yi maa shama shi. ");
INSERT INTO tswNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Vu roco mu ta̱ ure u wuma. Vu shiton mu ta̱ na̱ ma̱za̱nga̱ adama a na vu ri oɓolo na̱ a̱mu.’ ");
INSERT INTO tswNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“A̱za̱ a̱ va̱ aza a Israꞌila, n ta yuwusaan ɗu adanshi babu wovon adama a akaya a̱ tsu Da̱wuda. Da̱wuda kuwa̱ ta̱ waru a̱ ciɗo yi ta̱, waru aason a̱ yi a ta̱ pa oɓolo na̱ a̱tsu hali anaꞌan. ");
INSERT INTO tswNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","A̱yi vumava̱sula̱ ɗa, u reve ta̱ A̱sula̱ a yuwaan yi ta̱ nzuwulai na akucunu, a na u ta zuwa za ro mogono a̱tsuma̱ a̱ muwun n tsukaya ma̱ yi, ununa u zuwai Da̱wuda oꞌwoi mogono. ");
INSERT INTO tswNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Da̱wuda ta zuwusa okolo e ili i na yaa fara elime adama o uꞌyosun wu Zamawawa,† adansa, aa lyawa lipu va̱ yi a aason shi, waru lipu va̱ yi aa shama shi. ");
INSERT INTO tswNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","A̱sula̱ a̱ ꞌya̱sa̱n ta̱ Yesuꞌu a̱tsuma̱ a̱ a̱kwa̱kwa̱, a̱tsu waru tse ene ta̱ ne esu a̱ tsu. ");
INSERT INTO tswNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","A ca yi ta̱ tsugbain o ukere usaꞌani wa̱ A̱sula̱, waru u ushi ta̱ Ruhu va Akiza o ukere wa Dada ununa a yuwain nzuwulai. Gogo waru Yesu ca tsu ta̱ Ruhu va Akiza. Ili i na tsee eneshe, waru tsaa uwwusa ɗa nda. ");
INSERT INTO tswNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Da̱wuda ɗa kumbai zuva shi, amma a̱yi na aciya̱yi u damma ta̱, ‘A̱sulazuva a damma ta̱ Zagbain va̱: “Da̱nu o ukere usaꞌani u va̱, ");
INSERT INTO tswNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","she na̱ n zuwa nꞌyuwatan ma̱ wu a apata a ana a̱ wu.” ’ ");
INSERT INTO tswNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Adama o ndolo, aza a Israꞌila suru e te reve a na Yesu ndolo za na a varai a akpata,† A̱sula̱ a̱ ka̱mbuwa̱ yi ta̱ Zagbain na̱ Zamawawa.” ");
INSERT INTO tswNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ana a uwwai ne, reve iliꞌi i juꞌwa̱n okolo e le, reve e ece Bituru na akapi a ajiya a na a buwai, “A̱za̱ a̱ va̱, nye i ɗa tsaa yuwain?” ");
INSERT INTO tswNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","A̱vu Bituru damma le, “She i vadala,† tsa̱ra̱ a̱ rumbu ɗu a̱tsuma̱ a ala e Yesu Zamawawa, waru a yuwaan ɗu gafura vu unusu u ɗu. I ta̱ tsura̱ uneꞌe u Ruhu va Akiza. ");
INSERT INTO tswNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nzuwulai n nda za ɗu ɗa na̱ muwun n ɗu, oɓolo na Atakpaci. Amayun a ɗa maa dansaa ɗu, ili i nda adama a aza a na A̱sulazuva A̱sula̱ a̱ tsu ee ɗe a̱ tyo e ekere a̱ yi a ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Reve Bituru yuwan alajiya o ugaꞌan adansa, “N ta patishi ɗu i wawa aciya̱ɗu a̱tsuma̱ e ili i na yaa cina ama e iwuya a nda.” ");
INSERT INTO tswNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Reve aza a na a uwwai ili i na Bituru dammai, reve a̱ rumbu† le. O urana u ndolo ama a na a̱ da̱shi toniyi a rawa ta̱ ama ukpakukupa utaꞌatsu (3,000). ");
INSERT INTO tswNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Reve a zuwa okolo e le suru o uritosu wa ajiya na̱ muwwulai, a lyuwusa ilyalya oɓolo, na avasa. ");
INSERT INTO tswNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Reve wovon u reme le suru, adama a na A̱sula̱ a yuwain ili ya asalama ni iroci ya̱ a̱bunda̱ e ekere ajiyaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Aza a na a cayi okolo o ɓolotosu ta̱ uba̱ta̱ u ta̱, reve a̱ ka̱ra̱ a nkambulai ni itana i le. ");
INSERT INTO tswNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","A tsu wina ta̱ itana ni iɗa i le, mantsa ma na ozo o ro a̱ ri ni ili i na yaa damatosun le. ");
INSERT INTO tswNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Usana suru a̱ tsu ꞌya̱wa̱ ta̱ a̱ A̱a̱ꞌisamapaɗa na̱ majiyan ma̱ ta̱. A tsu lyuwusa ta̱ ilyalya a ꞌwa le oɓolo na̱ ma̱za̱nga̱ no okolo a̱ ta̱, waru a lyuwusa ta̱ Ilyalya yi Zagbain, ");
INSERT INTO tswNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","na a yuwusayin A̱sula̱ ica. A̱ tsura̱ ta̱ isaꞌani uba̱ta̱ wa ama. Usana suru Zagbain da̱shishi le ta̱ ama aza a na a̱ tsura̱i iwawi. ");
INSERT INTO tswNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ama a̱ tsu ꞌya̱wa̱ ta̱ a̱ A̱a̱ꞌisamapaɗa a mantsa ma̱ rumu taꞌatsu vu urana. Urana u ro, Bituru na̱ Yahaya† a̱ ꞌya̱wa̱ ta̱ adama a yuwan avasa. ");
INSERT INTO tswNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ana a rawai zuzu nu una̱ntsu wa̱ A̱a̱ꞌisamapaɗa u na a̱ tsu ɗe Una̱ntsu u Saꞌani reve e ene a̱a̱kutsuma̱ a na a matsain ukutsumu a na a tsu tanu, reve a zuwa yi, adama u yuwusan ipati. ");
INSERT INTO tswNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ana we enei Bituru na̱ Yahaya azama a uwa a̱ A̱a̱ꞌisamapaɗa, reve u pati le ikebe. ");
INSERT INTO tswNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Reve Bituru na̱ Yahaya a̱ ka̱lyuwa̱ yi ulobonu, a̱vu Bituru damma, “Ka̱lyuwa̱ tsu!” ");
INSERT INTO tswNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","A̱vu a̱a̱kutsuma̱ꞌa̱ u ka̱lyuwa̱ le na̱ majiyan ma na ee neꞌe yi ikebe. ");
INSERT INTO tswNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ɗaɗa Bituru dammai, “N ri ni ikebe i na maa ca wu shi. Amma n ta ca wu ili i na n ri na̱ a̱yi, a̱tsuma̱ o ucira wa ala e Yesu Zamawawa za va Nazara ꞌyon vu wala.” ");
INSERT INTO tswNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Reve u reme yi ukere usaꞌani, reve u kamba ꞌya̱sa̱n yi. Ana u yuwain ne, reve ana na̱ a̱lu a̱ yi a̱ ka̱mba̱ gbaga, reve o oꞌwo mejege. ");
INSERT INTO tswNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","A̱vu wu ꞌyawan, reve wi isawan mishin na ana a̱ yi. A̱vu u ka̱ra̱ a mmalu. Hali u ka̱ra̱ a mmalu nu u yuwin ogoɗiyo a ciɓalasa A̱sula̱. A̱vu u ka̱ra̱ a uwa a̱ A̱a̱ꞌisamapaɗa ne ele. ");
INSERT INTO tswNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ama a na a̱ da̱na̱i pe suru e ene yi ta̱ a mmalu waru a uwwa yi ta̱ a ciɓalasa A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ama a yuwan ta̱ asalama lon, ana e enei ili i na i farai, a na a̱a̱kutsuma̱ a na a̱ tsu da̱nusu o Una̱ntsu u Saꞌani a yuwusan ipati i ɗa ka̱mba̱i gbaga. ");
INSERT INTO tswNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Reve ama a̱ jika̱ a cina vumaꞌa uguzu na̱ Bituru na̱ Yahaya uba̱ta̱ u na a̱ tsu ɗe Ma̱kisa̱ ma̱ Sulemanu. A̱vu ama a na a̱ da̱na̱i pe suru a uwa asalama e ili i na i farai. ");
INSERT INTO tswNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ana Bituru enei ama o ɓolotoi reve u teme alajiya adansa, “Aza a Israꞌila, nye i ɗa ili ya asalama a na a̱a̱kutsuma̱ꞌa̱ u ka̱mba̱i gbaga? Waru nye i zuwai i ri a̱ a̱ka̱nla̱ a̱ tsu, vadamma tsu yuwan ta̱ iliꞌi nu ucira wa aciya̱tsu na̱ a̱ɓula̱ a̱ tsu? ");
INSERT INTO tswNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","A̱sula̱ a Ibrahim na̱ Ishiyaku na̱ Yakubu n na nkaya n tsu n yuwayin a̱ga̱nda̱, a̱yi ɗa u ta̱wa̱yi aagbashi a̱ yi Yesu na̱ tsugbain. A̱yi ɗa Yesu na i ꞌyuwain, reve i ca yi e ekere a Bilatu,† ko na Bilatu shi ta̱ ciga u lyawa yi. A̱vu i damma Bilatu a na i ciga yi shi. ");
INSERT INTO tswNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Za va akiza ɗa u da̱na̱i, waru za vi isaꞌani ɗa, reve i ꞌyuwan yi a̱vu i damma Bilatu lyawaa ɗu za mona ma ama. ");
INSERT INTO tswNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Reve yu una za vu ucasu u wuma wa̱ A̱sula̱, amma A̱sula̱ a̱ ꞌya̱sa̱n yi ta̱. A̱tsu gba tse ene ta̱ ne esu a̱ tsu amayun a nda. ");
INSERT INTO tswNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ucawu wo okolo a̱tsuma̱ a ala e Yesu ɗa a̱ ka̱mba̱toi a̱a̱kutsuma̱ a nda gbaga e esu a̱ ɗu. Vuma na ye enei ɗa, waru i reve ta̱ ununa vuma nda shi ukutsumu. Ucawu wo okolo a̱ yi e ekere e Yesu ɗa a̱ ka̱mba̱to niyi gbaga a̱ ma̱ka̱ka̱n ma̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“A̱za̱ a̱ va̱, n gura ta̱ reve ili i na i yuwayin Yesu, i yuwan yi ta̱ o ulambu wu urevu, hali ulambu wu urevuꞌu u ka̱ra̱ a̱ tyo e ekere a azagbain a̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Amma A̱sula̱ a zuwa ta̱ ama̱sula̱ a yuwan adanshi adama a Zamawawa ɗe nu ujimu, a na u to sowo a̱tsuma̱lima̱ e ili i nda suru, waru u shiton ta̱ nzuwulaiꞌi. ");
INSERT INTO tswNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Vadalai i lyawa unusu u ɗu suru, reve i vadala i kuru A̱sula̱, adama i tsura̱ gafura vu unusu u ɗu. ");
INSERT INTO tswNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ne ɗa ya̱a̱ tsura̱ mantsa ma̱ wivuwun uba̱ta̱ wa̱ A̱sula̱, waru u ta̱ da̱shi lyunguwisa̱ ɗu na̱ Yesu za na u ɗangwai wo oꞌwo Zamawawa. ");
INSERT INTO tswNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Zuva ɗa Yesu a̱a̱ da̱na̱ hali mantsa ma na a̱a̱ ka̱mba̱to ili suru usaꞌavu, ununa A̱sula̱ a yuwain nzuwulai nu ujimu, e ekere a ama̱sula̱ a akiza. ");
INSERT INTO tswNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musa damma ta̱, ‘A̱sula̱ a̱ ta̱ ꞌya̱sa̱n vumava̱sula̱ tsa̱ va̱ a̱tsuma̱ a ama a̱ ɗu. I polo atsuvu ulobonu yu uwwa ili i na waa damma ɗu.’ ");
INSERT INTO tswNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Waru Musa damma ta̱, ‘Za na uwwai ili i na vumava̱sula̱ꞌa̱ u dammai shi a̱ to uta̱a̱ yi a̱tsuma̱ a ama a̱ A̱sula̱, reve o una yi.’ ");
INSERT INTO tswNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Waru ama̱sula̱ diga Samaꞌila† a yuwan ta̱ adanshi e ili i na aa yuwusan anaꞌan. ");
INSERT INTO tswNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","A̱ɗu ɗa muwun ma ama̱sula̱ o ndolo, waru i ta̱ pe a̱tsuma̱ a akucunu† a nzuwulai n na A̱sula̱ a yuwayin nkaya n ɗu. U damma ta̱ Ibrahim,† ‘Adama a mawun ma̱ ta̱ a̱tsuma̱ o ugundo wa̱ wu n ta zuwaa uvaɗi ma̱ɓula̱ abaꞌun.’ ");
INSERT INTO tswNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Amma ana A̱sula̱ a̱ ꞌya̱sa̱in aagbashi a̱ yi Yesu, u lyungu yi ta̱ a̱ ꞌya̱wa̱ a̱tsuma̱ a ama a̱ ɗu aza a Israꞌila o ufaru, u zuwaa ɗu ta̱ abaꞌun, reve u vadala ɗu a̱za̱ a̱ ta̱ ta̱ diga o unusu u ɗu.” ");
INSERT INTO tswNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Bituru na̱ Yahaya a̱tsuma̱ a adanshi, reve nan ganu na̱ zagbain va̱ a̱duga̱ri a̱ A̱a̱ꞌisamapaɗa na aza a Sadukiya† a̱ ta̱wa̱ uba̱ta̱ u na a̱ ri. ");
INSERT INTO tswNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","A̱ da̱na̱ ta̱ na̱ a̱tsumola̱ngu a na ajiya e reꞌe a̱ da̱na̱i o ritosu ama a na, Yesu kuwa̱ ta̱ waru u ꞌyon ta̱. Ne ɗa fo a̱a̱ ꞌya̱sa̱n a̱kwa̱kwa̱ a̱ ka̱mba̱ wuma. ");
INSERT INTO tswNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Reve e reme le nu ulivu, a̱vu a zuwa le o uꞌwa wa ali hali usana. ");
INSERT INTO tswNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ama na̱ a̱bunda̱ a na a uwwai alajiya e le a vadala ta̱, hali a̱bunda̱ a ali a̱ a̱za̱ e Itoni a rawa zuzu nu ukpakukupa uton (5,000), babu na̱ a̱ma̱ci na̱ muwun. ");
INSERT INTO tswNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","O urana we ire, reve azagbain a aza a Israꞌila, na̱ mbara, na̱ munlu n Wila̱ o ɓoloto Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Hanana aabara a nan ganu fo u da̱na̱ ta̱ lo, na̱ Kayafa, na̱ Yahaya† na̱ Iskandari ne edenge o ro va aabara a nan ganu. ");
INSERT INTO tswNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Reve a̱ ta̱wa̱ no ojoro e reꞌe a̱ ma̱ka̱ka̱n me le. A̱vu e ece le, “Nu ucira ko na ala a zane ɗa i yuwayin ulinga u ndolo?” ");
INSERT INTO tswNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Reve Bituru za na da̱na̱i tapu na̱ Ruhu va Akiza, damma le, “Azagbain na̱ mbara mi iɗa i tsu, ");
INSERT INTO tswNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","i ta yuwusan tsu yeci i nda adama a na tsu yuwain isaꞌani a̱ tyo uba̱ta̱ wa̱ a̱a̱kutsuma̱ꞌa̱? I ciga ta̱ i reve ununa u ka̱mba̱i gbaga? ");
INSERT INTO tswNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Lyawai n damma ɗu hawun hali na ama a Israꞌila, u ka̱mba̱ ta̱ gbaga a̱tsuma̱ a ala nu ucira wa̱ Yesu Kristi na uta̱i Nazara. Vuma na i varai a akpata, agba A̱sula̱ a̱ ꞌya̱sa̱n yi ta̱ a̱tsuma̱ a̱ a̱kwa̱kwa̱. ");
INSERT INTO tswNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","A yuwan ta̱ adanshi a̱ yi a̱tsuma̱ a Adanshi a̱ A̱sula̱, uba̱ta̱ u na a ɗanai, ‘Aatali a na asuwi a ꞌyuwain, a̱yi ɗa wo oꞌwoi ikyun yu ucira a̱tsuma̱ o usaa.’ ");
INSERT INTO tswNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Za lo a̱ tsura̱ iwawi† uba̱ta̱ wu za ro shi! Waru ala† a za ro o lo a̱tsuma̱ o uvaɗi u nda na ama ee ɗe reve a̱ tsura̱ iwawi shi.” ");
INSERT INTO tswNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Reve azagbain a yuwan asalama lon, ana e enei Bituru na̱ Yahaya a gura yuwain adanshi a̱ ma̱ka̱ka̱n me le okolo nden, adama a na ama a ɗa a na a̱ ri nu urevu u makaranta shi. Waru a gura ta̱ reve ama a ɗa a na a̱ da̱na̱i oɓolo na̱ Yesu. ");
INSERT INTO tswNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","A gura damma le ili i ro shi, adama a na e ene ta̱ vuma na a̱ ka̱mba̱toi gbaga na ajiyaꞌa mishin a̱ ngeꞌen n le. ");
INSERT INTO tswNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","A̱vu azagbaiꞌin a damma Bituru na̱ Yahaya a lyawa ukobuꞌu. Reve a uwa ndammulai va̱ni le. ");
INSERT INTO tswNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","E ecelei ta̱ aciyele, “Nye tsaa yuwan na ama a nda? Tsaa gura wasan a na a yuwain ulinga wa asalama shi. Adama a na ama a̱ Urishelima suru e reve ta̱ ili i na i farai. ");
INSERT INTO tswNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Amma tsu zuwaa nle utyo adama iliꞌi i yuwan a̱bunda̱ a̱tsuma̱ a ama a̱ tsu wan. Waru tsu ta zuwaa le utyo she a̱ da̱shi yuwaan za ro adanshi a ala e Yesu wan.” ");
INSERT INTO tswNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Reve e ɗewishe ajiyaꞌa o ukobu u le, a̱vu a damma le she a̱ da̱shi yuwan adanshi ko uritosu adama a ala e Yesu wan. ");
INSERT INTO tswNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Reve Bituru na̱ Yahaya a̱ usu le, “I ta majiyan A̱sula̱ a ta laꞌa ciga tsu toni ɗu ko a̱yi? ");
INSERT INTO tswNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tsaa gura lyawa adanshi a saꞌani a na tse enei waru tsu uwwai shi.” ");
INSERT INTO tswNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","A̱vu ama suru a̱ ka̱ra̱ a yuwusaan A̱sula̱ ica adama e ili i na i farai: Vuma na yuwain aꞌwan amunga ukutsumu u ka̱mba̱i gbaga. Adama o ndolo azagbain a Yahuda e reve ununa aa ca Bituru na̱ Yahaya a̱tsuma̱lima̱ shi. Reve a ca le wovon, reve a lyawa le a̱ ka̱ra̱. ");
INSERT INTO tswNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Diga na a lyawa nle, reve Bituru na̱ Yahaya a̱ bunga̱ a̱za̱ e le a̱za̱ e Itoni, reve a damma le ili i na nan ganu a gbagbain na̱ mbara n dammai. ");
INSERT INTO tswNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ana a̱za̱ e Itoni suru a uwwai ili i na i farai, reve o ɓolo okolo e le. A̱vu a̱ ꞌya̱sa̱n uɗyo a yuwusan avasa, “Mogono ma Gbain, za na yuwain zuva ni iɗa, na̱ mala ni ili i na i ri pe suru. ");
INSERT INTO tswNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Vu yuwan ta̱ ɗe adanshi nu ujimu na̱ Ruhu va Akiza e ekere a akaya a̱ tsu mogono Da̱wuda agbashi a̱ wu, adansa, ‘Adama a̱ nye ama o uvaɗi a yuwain upan? Adama a̱ nye ama a̱a̱ lungusa̱ mantsa me le e ili ye pere? ");
INSERT INTO tswNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ngono mu uvaɗi n foɓo ta̱ uvon, reve azagbain o ɓolo aci a ꞌyuwan Zagbain na̱ Zamawawa va̱ yi.’ ");
INSERT INTO tswNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Ili i nda i fara ta̱ pa Urishelima. Hiridu Antiba, na̱ Bontu Bilatu gwamna, na Atakpaci na ama a Israꞌila suru o ɓoloi aci e le, reve a ꞌyuwan Yesu, aagbashi a akiza a̱ wu, za na vu foɓoi wo oꞌwo Zamawawa. ");
INSERT INTO tswNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Mejege ma ɗa, ili i na a yuwain suru, a yuwan le ta̱ ununa vu yuwain ɗe adanshi nu ujimu. ");
INSERT INTO tswNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Gogo A̱sulazuva, uwwa iwuya i na a dansa, reve vu ca tsu agbashi a̱ wu okolo o ugbamu a mantsa ma na tsaa yuwusan alajiya a adanshi a̱ wu. ");
INSERT INTO tswNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Vu lyungu nu ucira wu uka̱mba̱tosu gbaga, nu ulinga wa asalama a̱ wu, waru ili i nda suru i fara na ala a aagbashi a̱ wu Yesu.” ");
INSERT INTO tswNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ana o kotoi avasa a nda, a̱vu usaa u na a̱ da̱na̱i u jinga̱ɗa̱, reve suru nle a shiwan na̱ Ruhu va Akiza. A̱vu a yuwan alajiya a adanshi a̱ A̱sula̱ no okolo ugbamu. ");
INSERT INTO tswNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","A̱za̱ e Itoni† suru a̱ da̱na̱ ta̱ no okolo na asuvu a̱ ta̱, reve e ene utsuru u na a̱ ri na̱ a̱yi za le ɗa goon shi, ɗaɗa a kambusai aciyele va̱ni le. ");
INSERT INTO tswNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","A̱vu ajiyaꞌa a ca urevetyowu wu ukwa̱ nu uꞌyosun wa̱ Yesu Zagbain nu ucira, waru a̱ tsura̱ ta̱ isaꞌani† ya̱ a̱bunda̱ e ekere a̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","A̱ da̱na̱ nu ulambu shi, adama a na mantsa a̱ tyo mantsa ama a na a̱ da̱na̱i ni iɗa na̱ ꞌwa biti a winasa le ta̱, a̱vu a̱ ta̱wusa̱a̱ ni ikebeꞌe wira̱ u ta̱. ");
INSERT INTO tswNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","A̱vu a casu ajiyaꞌa ikebeꞌe reve a casu aza a na a cigai ikambi. ");
INSERT INTO tswNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Apa iroci yi ili i na a yuwusain, vuma ro shi ta̱ lo za na a̱ tsu ɗe Isuhu za na ajiyaꞌa a cayi aala Banaba (za na urevu wa̱ yi u ɗa Mawun mo Uda̱shishi wo Okolo). A̱yi za ve elentsu e Levi a ɗa, waru u ta̱wa̱ ta̱ diga Kuburu iɗa i memere ma̱ mini. ");
INSERT INTO tswNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","U da̱na̱ ta̱ ni iɗa, reve u wina yi, a̱vu u ta̱wa̱a̱ ajiyaꞌa ni ikebeꞌe, tsa̱ra̱ a ca aza a na a cigai ikambi. ");
INSERT INTO tswNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","A yuwan ta̱ vuma ro na a̱ tsu ɗe Ananiya, za na a̱yi na̱ ka va̱ yi, Safiratu, a winai iɗa i le. ");
INSERT INTO tswNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","A̱vu a̱ sa̱la̱la̱i a damma mejege wan ko iyan i ɗa a winai iɗaꞌa. Ana a winai reve u ta̱wa̱a̱ na akapi e ikebe, a̱vu u damma ikebe i ɗaɗa ndolo suru suru. ");
INSERT INTO tswNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Reve Bituru damma yi, “Ananiya adama a̱ nye vu lyawai Male† ma uwai o okolo a̱ wu? Vu yuwaan ta̱ Ruhu va Akiza epen, a̱vu vu zuwaa aciya̱wu akapi e ikebeꞌe. ");
INSERT INTO tswNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Itanaꞌa a̱za̱ a̱ wu a ɗa vu ta gura wina ko vu kuɗa̱ wina le, cine vu cigai ɗa vaa yuwan. Ko na vu winai itanaꞌa, ikebeꞌe a̱za̱ a̱ wu a ɗa na vaa gura yuwan uneꞌe ne ele. Adama a̱ nye vu yuwain tsunda? A̱tsu ɗa vu yuwayin epen shi, amma A̱sula̱ a ɗa vu yuwayin epen.” ");
INSERT INTO tswNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Diga na Ananiya uwwai adanshi o ndolo, reve u riya̱ e iɗa reve u kuwushi. Aza a na a uwwai ili i na i farai, a uwwa ta̱ wovon lon. ");
INSERT INTO tswNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Reve olobo a̱ ꞌyon a̱vu a katala yi no okoro, reve e sheɗe yi o uta̱, a̱vu a̱ ciɗo yi. ");
INSERT INTO tswNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","A̱ tyo a mantsa me irumu i taꞌatsu a na vali va̱ yi kuwa̱i, a̱vu ka va̱ yi uwa, babu na u revei ili i na i farai. ");
INSERT INTO tswNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","A̱vu Bituru ece yi, “Ikebe i na a̱vu na̱ vali va̱ wu i winai iɗa i ɗu i ɗa nda?” A̱vu kaꞌa u usu, “Ee, ikebe i ɗaɗa ne.” ");
INSERT INTO tswNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Reve Bituru damma, “Cine tsa ɗa a̱ɗu ra i sa̱la̱la̱i i yuwan cuꞌun vi ili i nda? Adama a̱ nye i ɓoloi aci i lyungwa̱ Ruhu va̱ A̱sulazuva? Ka̱lyuwa̱ o una̱ntsu, vu te ene ana o olobo a na a̱ ciɗoi vali va̱ wu, waru a ta tanu wu fo o uta̱ a alanga.” ");
INSERT INTO tswNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Lo ɗa u riya̱shi a̱ ma̱ka̱ka̱n ma̱ yi a̱vu u kuwa̱. Ana oloboꞌo a uwai, a̱vu a cina yi ukwa̱. Reve e sheɗe yi o uta̱, a̱vu a̱ ciɗo yi a̱ ngeꞌen ma aason a vali va̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Reve wovon u reme a̱za̱ e Itoni lon oɓolo na ama a na a uwwai ili i na i farai. ");
INSERT INTO tswNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ajiya a yuwan ta̱ ulinga wa asalama† ni iroci yi ili ya asalama lon a̱tsuma̱ a ama. Waru a̱za̱ e Itoni o tsu ɓoloto ta̱ usana suru a̱ A̱a̱ꞌisamapaɗa e eɓele a na a̱ tsu ɗe Ma̱kisa̱ ma̱ Sulemanu. ");
INSERT INTO tswNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Amma, adama o wovon, ama na̱ a̱bunda̱ a kawan uwa oɓolo ne ele shi. Agba suru na̱ ne, ama a casu le ta̱ tsugbain. ");
INSERT INTO tswNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Suru na̱ ne ali na̱ a̱ma̱ci na̱ a̱bunda̱ a cayi okolo a Zagbain. ");
INSERT INTO tswNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Adama o ulinga wa asalama u na ajiyaꞌa aa yuwusan, hali a̱ ka̱ra̱ a̱ ta̱wusa̱a̱ na̱ a̱za̱ a̱ mɓa̱la̱ e re mulyuci a̱ a̱ga̱da̱ e le na a avalu e le, a majiyan ko ululu wa̱ Bituru u ta̱ juꞌwa̱n ozo o ro e le a̱ ka̱mba̱ gbaga a mantsa ma na wa̱a̱ ka̱ra̱la̱i. ");
INSERT INTO tswNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ama na̱ a̱bunda̱ a̱ ta̱wa̱a̱ ta̱ na aza a na a̱ da̱na̱i nu ubanakun, na aza a na a̱ ri no otoni a̱ lima̱, diga mulyuci n na n ri zuzu na̱ Urishelima. Waru a̱ ka̱mba̱to le ta̱ gbaga. ");
INSERT INTO tswNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Aabara a nan ganu na aza a Sadukiya a̱ ka̱ra̱ ta̱ a̱ tsushuꞌun na ajiya adama a malyuwa me elime ma na aa yuwusan o ulinga u le. ");
INSERT INTO tswNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ɗaɗa e remei ajiyaꞌa a̱vu a zuwa le o uꞌwa wa ali. ");
INSERT INTO tswNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Na ayin a̱vu malingata ma̱ A̱sula̱ ma̱ ta̱wa̱, a̱vu u kpa̱tuꞌwa̱ una̱ntsu wu uꞌwa wa aliꞌi, reve wu uta̱a̱ le pe. ");
INSERT INTO tswNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","A̱vu u damma le, “Ka̱ra̱i a̱ ꞌya̱wa̱ a̱ ma̱kisa̱ ma̱ A̱a̱ꞌisamapaɗa, i damma ama alabari a wuma a saꞌavu a nda.” ");
INSERT INTO tswNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Usana a matawaa, a̱vu ajiyaꞌa a uwa a̱ A̱a̱ꞌisamapaɗa ununa malingata ma̱ A̱sula̱ ma damma nle, reve e reme uritosu wa ama. Ana aabara a nan ganu na aza a na a̱ da̱na̱i lo oɓolo a rawai, reve e ɗe iɓolo ya Azagbain a Mbara† oɓolo na azagbain a Israꞌila. Reve a̱ lyungu nlingata n ro n ꞌya̱wa̱ o uꞌwa wa aliꞌi, a̱ ta̱wa̱ ne ele. ");
INSERT INTO tswNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ana nlingataꞌa n ꞌya̱wa̱i o uꞌwa wa aliꞌi, a cina le pe shi, ɗaɗa a̱ ka̱mbushi uba̱ta̱ wa azagbaiꞌin, a̱vu a damma le ili i na a cinai. ");
INSERT INTO tswNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Reve a damma, “Tsu rawa ta̱ o uꞌwa wa aliꞌi, a̱vu tsu cina una̱ntsuꞌu ukpa̱towu, na̱ a̱soja mishin o una̱ntsuꞌu. Amma ana tsu katsuꞌwai, tsu cina pe za shi.” ");
INSERT INTO tswNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ana zagbain va̱ a̱duga̱ri na̱ nan ganu a gbagbain va̱ A̱a̱ꞌisamapaɗa uwwai ili i na i farai, a gura reve cine iliꞌi i farai shi. A̱vu a̱ ka̱ra̱ a majiyan cine iliꞌi yoo oꞌwo. ");
INSERT INTO tswNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ele pe a̱vu za ro uwa u damma, “Gogo tsunda ama a na i zuwai o uꞌwa wa aliꞌi a̱ ta̱ ɗe a̱ A̱a̱ꞌisamapaɗa o ritosu ama!” ");
INSERT INTO tswNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Adama a nda a ɗa zagbain va̱ a̱duga̱ri na̱ a̱duga̱ri a̱ yi e remei ajiyaꞌa a̱ tyo uba̱ta̱ e iɓolo. Ko na wo oꞌwoi a̱duga̱riꞌi e reme le nu ukadu shi, adama o wovon u na ama aa vara le na atali. ");
INSERT INTO tswNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ana a̱ ta̱wa̱i na ajiyaꞌa uba̱ta̱ e iɓoloꞌo, reve aabara a nan ganu a damma, ");
INSERT INTO tswNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tsu damma ɗu ta̱ a alanga e eteshe, ‘She i da̱shi yuwan uritosu a̱tsuma̱ a ala e Yesu wan.’ Amma a̱ɗu ɗa nda i kotoi Urishelima suru nu uritosu u ɗu a̱tsuma̱ a ala a̱ yi, a̱vu waru i tawaa tsu nu ukwa̱ wa̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Reve Bituru na ajiya o ro a̱ usu, “U laꞌa ta̱ ulobonu tsu toni A̱sula̱ a na tsoo toni vaɗilima̱. ");
INSERT INTO tswNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yu una ta̱ Yesu ana i vara niyi a akpata,† agba A̱sula̱ a nkaya n tsu a̱ ꞌya̱sa̱n yi ta̱ a̱tsuma̱ a̱ a̱kwa̱kwa̱. ");
INSERT INTO tswNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","A̱sula̱ a zuwa yi ta̱ o ukere usaꞌani wa̱ yi u zuwa yi ta̱ Mogono na̱ Za vi Iwawi. A̱sula̱ a yuwan ta̱ ne, tsa̱ra̱ u ca aza a Israꞌila ure u na aa vadala tsa̱ra̱ a̱ tsura̱ gafura vu unusu u le e ekere a̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tsu gura ta̱ damma amayun e ili i nda, adama a na tse ene ta̱ ne esu a̱ tsu, ne ɗa fo Ruhu va Akiza, za na wo oꞌwoi uneꞌe wa̱ A̱sula̱ e ekere a aza a na o toniyi A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ana nan ganu a gbagbain na azagbaiꞌin a uwwai ili i na ajiyaꞌa a dammai, reve a suɗuwa asuvu. Hali a̱ shi a ciga o una le. ");
INSERT INTO tswNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ele pe a̱vu vuma ro na a̱ tsu ɗe Gamaliya, za ta̱ a̱tsuma̱ a Afarishi waru manlu ma̱ Wila̱ ꞌyon mishin. A̱vu u damma a tara neꞌen ajiyaꞌa o uta̱ a alanga keꞌen. ");
INSERT INTO tswNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","A̱vu u damma nan ganuꞌu na azagbaiꞌin, “Ama a Israꞌila, i yuwan majiyan ulobonu e ili i na i farai a yuwusaan ama a nda. ");
INSERT INTO tswNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Koto u jima shi, a na Tuda dammai a̱yi vuma vu ucira ɗa. Ama a̱ tyo ukpakuna̱shi (400) o toni yi ta̱. Amma ana o una niyi, ojoro a̱ yi e beteꞌwe ta̱ suru. Agba ko ili i ro tsu tsura̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Yahuza va̱ Ga̱lili ɗa ta̱wa̱i a̱ca̱pa̱ a̱ yi a mantsa me mekece ma ama. A̱vu u zuwa ama a̱ ꞌya̱sa̱n ama ugbozu, agba a̱yi fo o una yi ta̱ reve ojoro a̱ yi e beteꞌwe fo suru. ");
INSERT INTO tswNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","A̱sa̱la̱ a na maa ca ɗu, a̱yi ɗa i lyawa amaꞌa a yuwan ili i na aa yuwan. Nnu ucira wa aciyele a ɗa aa yuwusan uritosu ni ili ya asalama a nda, a̱ ta̱ ta̱wa̱ a̱ ka̱la̱ma̱. ");
INSERT INTO tswNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Amma nnu ucira wa̱ A̱sula̱ u ɗa aa yuwusan ili i nda, yaa gura putsaa le a lyawa shi. I ta cina aciya̱ɗu a̱ nla̱ngi na̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Reve oɓolo a amaꞌa a̱ usu a̱sa̱la̱ a̱ yi. A̱vu e ɗe ajiyaꞌa a uwa o ukobu reve a faba le. A̱vu a zuwaa le utyo, she a̱ da̱shi yuwan alajiya a̱tsuma̱ a ala e Yesu wan, a̱vu a lyawa le. ");
INSERT INTO tswNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","A̱vu ajiyaꞌa a lyawa oɓoloꞌo na̱ ma̱za̱nga̱ ma na A̱sula̱ e ene ta̱ a̱ ta̱ no okolo ugbamu u na o sowo a̱tsuma̱lima̱ adama e Yesu. ");
INSERT INTO tswNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Usana suru a̱ tsu ꞌya̱wa̱ ta̱ a̱ A̱a̱ꞌisamapaɗa a yuwusan uritosu a dansaa ama Yesu Zamawawa† ɗa. Waru a yuwusan ta̱ ne a ꞌwa va ama. ");
INSERT INTO tswNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","A mantsa ma na a̱za̱ e Itoni a̱ ka̱ra̱i a̱ da̱shishi a̱bunda̱, agba suru nle aza a Israꞌila a ɗa. A̱vu ozo o ro a na a yuwusan Tsuheleni† a uwa adanshi a̱ tyo uba̱ta̱ wa aza a na a yuwusan Tsuyahuda,† adansa, “Nna a kambusa nruna̱ usana suru, nruna̱ n tsu n tsu tsura̱ una̱ta̱ na̱ a̱za̱ e le shi.” ");
INSERT INTO tswNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ɗaɗa Kupanejereꞌe o ɓolotoi a̱za̱ e Itoni suru, reve a damma, “Woo lobono tsi icinai nu ulinga wa alajiya wa adanshi a̱ A̱sula̱, reve tsu reme adama e ilyalya shi. ");
INSERT INTO tswNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","A̱za̱ a̱ tsu, ɗangulai ama e cindere a̱tsuma̱ a̱ ɗu, aza a na i revei a̱ ri na̱ Ruhu va Akiza, nu urevu, tsu ta zuwa ulinga u nda e ekere e le. ");
INSERT INTO tswNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","A̱tsu gbaꞌa tsu zuwa ugbozu uba̱ta̱ wa avasa na alajiya nu uritosu wa adanshi a̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Reve a̱sa̱la̱ꞌa̱ u yoꞌono aza a na o ɓolotoiꞌi suru. Reve a fara ɗangula Istifanu vuma na ri nu ucawu wo okolo na̱ Ruhu va Akiza lon. Reve o toni na̱ Filibu, na̱ Burukoro, oɓolo na̱ Nikana, waru a ɗangula ta̱ Timan, na̱ Baramina, na̱ Nikola va Antakiya, Takpaci na uwai o ure wi itoni wa aza a Israꞌila. ");
INSERT INTO tswNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Reve a tara ama e cindereꞌe a̱ ta̱wa̱ ne ele a̱ ma̱ka̱ka̱n ma ajiya, reve ajiyaꞌa a̱ kuruwa̱ le ekere a̱vu a yuwaan le avasa. ");
INSERT INTO tswNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","A yuwan ta̱ alajiya a adanshi a̱ A̱sula̱ uba̱ta̱ suru. Reve a̱za̱ e Itoni a̱ da̱shi a̱bunda̱ lon a̱tsuma̱ a̱ Urishelima, hali nan ganu va aza a Israꞌila fo na̱ a̱bunda̱ a ca okolo e le. ");
INSERT INTO tswNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Reve Istifanu, vuma na tsura̱i isaꞌani† nu ucira wa̱ A̱sula̱ lon, u yuwan linga va asalama ni iroci e memere ma ama. ");
INSERT INTO tswNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Reve urana u ro ama o ro a na a̱ ri a̱ a̱a̱ꞌisa̱ a na a̱ tsu ɗe A̱a̱ꞌisa̱ a Agbashi a na a Lyawai, a uwa mawasan na̱ a̱yi. Ele aza a Israꞌila a na o uta̱i diga Kurani, na̱ Iskandariya, na̱ Kilikiya, ni iɗa ya Asiya i ɗa. ");
INSERT INTO tswNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Agba ko vuma ta̱ gura yuwan nronuloi na̱ a̱yi shi, adama o urevu u na Ruhu va Akiza ca niyi. ");
INSERT INTO tswNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Usokowu ɗaɗa a zuwai ama o ro a yuwaan Istifanu epen ana, “Tsu uwwa yi ta̱ a yuwusan adanshi a vama a̱ tyo e ekere a Musa, hali na̱ A̱sula̱ fo.” ");
INSERT INTO tswNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Reve adanshiꞌi u ꞌya̱sa̱n ugbozu wa ama na̱ munlu n Wila̱ ma̱ a̱dini na azagbain. Reve e reme Istifanu a̱vu a̱ ta̱wa̱ na̱ a̱yi uba̱ta̱ wa azagbain o ugeꞌetosu u na a̱ tsu ɗe Azagbain a Mbara. ");
INSERT INTO tswNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Reve a̱za̱ e epeꞌen a damma, “Vuma nda u tsu yuwusan ta̱ adanshi e iwuya adama a̱ A̱a̱ꞌisamapaɗa na̱ Wila̱ wa Musa. ");
INSERT INTO tswNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tsu uwwa yi ta̱ adansa a na Yesu va Nazara u to ɓoso A̱a̱ꞌisamapaɗa a nda reve u vadala agadu a Musa a na a lyawaa ntsu.” ");
INSERT INTO tswNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ana a uwwai ne, reve vuma biti a̱tsuma̱ a azagbain u vara a̱ka̱nla̱ a Istifanu, reve e ene urewesu wa̱ yi e ikanasa ana malingata ma̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Reve aabara a nan ganu e ece Istifanu, “Ili i na aa dansa a aciya̱wu amayun a ɗa?” ");
INSERT INTO tswNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ɗaɗa Istifanu tsu usu, “A̱ɗu a̱za̱ a̱ va̱ na azagbain, poloo numu atsuvu! Mogono ma̱ A̱sula̱ za tsugbain mo roco ta̱ aciya̱yi ya Ibrahim akaya a̱ tsu e iɗa ya Masapotomiya kafu Ibrahim tyo e iɗa ya Haran. ");
INSERT INTO tswNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","A̱sula̱ a damma yi ta̱, ‘Vu ꞌyon vu lyawa iɗa i na a matsan nuwu na ama a̱ wu, reve vu tyo e iɗa i na moo roco wu.’ ");
INSERT INTO tswNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Ɗaɗa Ibrahim ꞌyoyin e iɗa ya aza a Kaldiya, reve u da̱nu Haran hali ukwa̱ wa abara a̱ yi. Reve A̱sula̱ a̱ ta̱wa̱to yi pa e iɗa i na i ri nden gogo. ");
INSERT INTO tswNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Agba A̱sula̱ a ca yi agadu e iɗaꞌa shi, waru ko udasuwu u ta̱ wi iɗaꞌa u ca yi shi. Amma A̱sula̱ a yuwan ta̱ nzuwulai n na waa ca yi iɗaꞌa a̱yi na̱ limatan vu ugundo wa̱ yi ko na u shi na̱ mawun neꞌen shi. ");
INSERT INTO tswNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Agba A̱sula̱ a damma yi ta̱, ‘Limatan va̱ wu ta yuwan limocin e iɗa i ro uba̱ta̱ u na oo sowo a̱tsuma̱lima̱ ana agbashi hali aꞌwan ukpakuna̱shi (400). ");
INSERT INTO tswNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Agba n ta zuwa iɗa i na i zuwai aza a Israꞌila tsugbashi a̱tsuma̱lima̱. Waru o ukosu u tsugbashi a̱ to uta̱ adama a yuwaan mu a̱ga̱nda̱ uba̱ta̱ u nda.’ Ili i na A̱sula̱ a dammai ɗa nda. ");
INSERT INTO tswNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Waru A̱sula̱ a yuwaan ta̱ Ibrahim akucunu† a mapaɗa mo uryumbu† a mantsaꞌa. Ɗaɗa i zuwai a paɗai Ishiyaku mawun ma Ibrahim uryumbu a̱yi na ayin kunla̱ nu umatsun. Ishiyaku ɗa ta̱wa̱ u matsain Yakubu, reve Yakubu matsan nkaya n tsu kupa ne ejere. ");
INSERT INTO tswNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ele nkaya n tsu ana a̱ ri a̱ tsushuꞌun na̱ Isuhu zawaꞌa le, reve a wina yi wo oꞌwo aagbashi e iɗa ya Masar. Agba A̱sula̱ a̱ shi ta̱ oɓolo na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Reve gba u wawa yi a̱tsuma̱ a̱ a̱tsuma̱lima̱ a̱ yi. A̱vu A̱sula̱ a zuwa yi u tsura̱ icigi e ekere a Firiꞌawuna,† mogono ma Masar, adama a na A̱sula̱ a ca yi ta̱ urevu u na u ka̱ra̱la̱i. Ɗaɗa i zuwai Firiꞌawuna ca niyi tsugbain tsi iɗa tsa Masar na̱ tsugbain tsu uꞌwa tsa̱ yi suru. ");
INSERT INTO tswNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Reve ambulu a uwa e iɗa ya Masar suru ni iɗa ya Kaꞌana,† na̱ a̱tsuma̱lima̱ lon, hali nkaya n tsu n lamba ilyalya. ");
INSERT INTO tswNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","A̱vu ana Yakubu uwwai ishina i ta̱ ɗe e iɗa ya Masar, reve u lyungu nkaya n tsu n ꞌya̱wa̱ n tsula. ");
INSERT INTO tswNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","O uꞌya̱wu we ire u le ɗaɗa Isuhu revetyoi aciya̱yi e ekere a̱ a̱za̱ a̱ yi, reve a tara le o roco Firiꞌawuna. ");
INSERT INTO tswNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","“Reve Isuhu lyunguwa̱ dada va̱ yi Yakubu na ama a̱ yi adama a̱ tyo Masar ama kupocindere no ozo o ton ɗa suru suru. ");
INSERT INTO tswNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ɗaɗa Yakubu† tyoyi Masar. Ɗe ɗa a̱yi na̱ nkaya n tsu n kuwa̱i. ");
INSERT INTO tswNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Reve a̱ pura̱ etele e le suru a̱ tyo Shekem, ɗe ɗa a̱ ciɗo nle a aason a na Ibrahim tsulai ni ikebe† e ekere o olobo a Hama. ");
INSERT INTO tswNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ana mantsa ma na A̱sula̱ oo shiton nzuwulai ma̱ yi ya Ibrahim ma rawai zuzu, reve ama a̱ tsu a̱ da̱shi a̱bunda̱ a̱tsuma̱ a Masar. ");
INSERT INTO tswNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","A̱vu wo oꞌwo mogono ma saꞌavu ma kumba tsugono tsa Masar, agba u ri nu urevu wi ili i ro adama a̱ Isuhu shi. ");
INSERT INTO tswNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","A̱vu mogono u yuwaan ama a̱ tsu ugbozu u wuya, reve u roco le a̱tsuma̱lima̱, hali u zuwa le a varishi muwun n le adama a̱ kuwa̱. ");
INSERT INTO tswNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“A mantsa mo ndolo ma ɗa a matsain Musa mawun ma saꞌani. Mbara ma̱ yi m ɓa̱na̱ yi ta̱ woto taꞌatsu o uꞌwa u le. ");
INSERT INTO tswNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Na̱ a̱ca̱pa̱ reve wo oꞌwo le ko a ciga ko a ꞌyuwan a vari yi, reve usheli u mogono u tsura̱ yi, reve u kungwato yi ana mawun ma̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Reve o rito Musa urevu wa aza a Masar suru, reve wo oꞌwo nu ucira a̱tsuma̱ a adanshi na̱ a̱tsuma̱ o ulinga waru. ");
INSERT INTO tswNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Ana u rawai aꞌwan amunga, urana u ro, reve u damma lyawa u ꞌya̱wa̱ u bura ama a̱ yi, ama a Israꞌila. ");
INSERT INTO tswNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","A mantsa ma ɗaɗa we enei vuma va Masar e leꞌeshe vuma va Israꞌila. Ɗaɗa Musa rawai adama u wawa yi, reve u tsupaa yi wu una za va Masarꞌm. ");
INSERT INTO tswNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","U ta dansa a̱za̱ a̱ yi e te reve A̱sula̱ a̱ lyungu yi ta̱ u wawa le, agba a gura reve shi. ");
INSERT INTO tswNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ana usana u tawai waru, reve wu utisa̱ mabura me le, a̱vu we ene ama a Israꞌila e re a̱ nla̱ngi. A̱vu u ciga wu kasa le. A̱vu u damma, ‘Ili i ta̱ i ɗa i ri, adama a̱ nye yaa amatonloi?’ ");
INSERT INTO tswNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Reve za vi igishi ca̱co Musa a̱ ngeꞌen, a̱vu u damma yi, ‘Zane ɗa zuwa nuwu zagbain na̱ za vu ugeꞌetosu u tsu? ");
INSERT INTO tswNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Vu ciga ta̱ vu una mu ununa vu unai vuma va Masar yon?’ ");
INSERT INTO tswNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ana Musa uwwai ne, ɗaɗa u sumai u lyawai iɗaꞌa, reve u reme limocin e iɗa ya Midiya, uba̱ta̱ u na u matsain olobo e re a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ana a yuwain aꞌwan amunga, urana u ro a̱tsuma̱ o ogozo zuzu na Masasan ma Sinai,† reve malingata ma̱ A̱sula̱ ma̱ ta̱wa̱ ya Musa a̱tsuma̱ e elentsu a akina a madala o molopu. ");
INSERT INTO tswNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ana Musa ene niyi, reve u reme asalama e ili i na wee inda. Ana u rawai zuzu adama we ene, ɗaɗa wu uwwai uɗyo wa̱ A̱sulazuva a dansaa yi, ");
INSERT INTO tswNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘A̱mu ɗa A̱sula̱ a nkaya n ɗu A̱sula̱ a Ibrahim, na̱ Ishiyaku, na̱ Yakubu.’ Reve Musa reme mejeꞌen adama o wovon, u da̱shi gura ka̱lyuwa̱ iliꞌi shi. ");
INSERT INTO tswNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Reve A̱sulazuva a damma yi, ‘Foɗo atan a̱ wu adama a na uba̱ta̱ u na vu ri uba̱ta̱ wa akiza u ɗa. ");
INSERT INTO tswNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Me ene ta̱ a̱tsuma̱lima̱ a na ama a̱ va̱ a̱ ri o sowuso a Masar,† waru mu uwwa ta̱ mɓa̱la̱ mo okolo n le. N cipa̱ ta̱ adama n wawa le. Ta̱wa̱ gogo, n ta̱ lyungu wu a̱ ka̱mba̱ e iɗa ya Masar.’ ");
INSERT INTO tswNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ɗaɗa A̱sula̱ a̱ lyunguwisa̱ vuma na ama a̱ yi a ꞌyuwain ɗe, za na a dammai, ‘Zane ɗa zuwa nuwu zagbain na̱ za vu ugeꞌetosu a aci a̱ tsu?’ Ni ikambi i malingata ma̱ A̱sula̱ ma na ma̱ ta̱wa̱i ya̱ꞌa̱ yi o molopu ma na ma̱ da̱na̱i a madala, ma ɗa mo oꞌwoto niyi zagbain na̱ zamawawa le. ");
INSERT INTO tswNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nu uyuwusan wu ulinga wa asalama, ɗaɗa wu uta̱a̱ nle e iɗa ya Masar a pasalai Mala ma̱ Shili.† Na̱ a̱ ꞌya̱wi elime na̱ a̱ca̱pa̱, hali a yuwan aꞌwan amunga a̱tsuma̱ o una. ");
INSERT INTO tswNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Musa na aciya̱yi u damma ta̱ ama a Israꞌila, ‘A̱sula̱ a ta ɗangwa vumava̱sula̱ tsa̱ va̱ a̱tsuma̱ a ama a̱ ɗu.’ ");
INSERT INTO tswNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Musa da̱na̱ ta̱ oɓolo no oɓolo a ama a̱tsuma̱ o una. Waru malingata ma̱ A̱sula̱ ma yuwan ta̱ adanshi na̱ a̱yi a Masasan ma Sinai, na adanshi a̱ a̱ɓula̱. Ne ɗa u ca ntsu adanshi a wumaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“A̱vu nkaya n tsu n ꞌyuwan ili i na Musa dammai, a̱vu a ꞌyuwan a zuwaa yi atsuvu, reve a̱ shi a ciga a vadala a̱ ka̱mba̱ Masar. ");
INSERT INTO tswNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","A̱vu a damma Haruna,† ‘Yuwaan tsu musula̱ n na maa tsu walaa elime, adama a na tsu reve ili i na i yuwain Musa za na uta̱a̱ ntsu a̱tsuma̱ a Masar shi.’ ");
INSERT INTO tswNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Reve a ruma a̱ma̱li ana ma̱dindim, reve a yuwaan yi kucci, na̱ a̱buki reve a̱ za̱nga̱na̱ e ili i na a rumai ne ekere e le. ");
INSERT INTO tswNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ɗaɗa A̱sula̱ a vadalaa nle ucina̱. Reve u lyawa le a̱ ꞌya̱wa̱ o toni urana, woto, ni italyoꞌo o oꞌwo musula̱ n le, ununa u ri pe uɗanu a aatagada a Ama̱sula̱: ‘Ama a Israꞌila, i yuwaan mu kucci na̱ sadaka a̱tsuma̱ a aꞌwan amunga a na i da̱na̱i a̱tsuma̱ o una shi. ");
INSERT INTO tswNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","I ꞌya̱sa̱n ta̱ masaꞌa† ma̱ a̱ma̱li uba̱ta̱ u na aa yuwusaan a̱a̱ma̱li Mole a̱ga̱nda̱ na̱ a̱a̱ma̱li a talyoꞌo ma̱ ɗu Rafani, i yuwan ta̱ a̱ma̱li o ndolo, a̱vu i yuwaan le a̱ga̱nda̱. Adama o ndolo i ta uwa a tsugbashi e iɗa ya Babila† alanga!’ ");
INSERT INTO tswNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Reve nkaya n tsu n tanu Oogodo o Ucuwusan† adama a cuwan ni ili i na A̱sula̱ a yuwaan nle o una. A yuwan yi ta̱ ni ifoɓi ununa A̱sula̱ o rocoi Musa. ");
INSERT INTO tswNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ana a yuwain aꞌwan o ro, a̱vu Josuwa† uwa elime o uvon a aci e iɗa ya Atakpaci a na A̱sula̱ a̱ gba̱ra̱i e iɗa i ndolo. A tara ta̱ Oogodoꞌo a̱ tyo a̱ nda̱na̱ta̱ n saꞌavu n le. A yuwusan ta̱ ulinga na̱ a̱yi a̱ tyo mantsa ma̱ Da̱wuda. ");
INSERT INTO tswNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Da̱wuda tsura̱ ta̱ icigi e ekere a̱ A̱sula̱, hali u pati a lyawa yi u suwaa A̱sula̱ a Yakubu A̱a̱ꞌisamapaɗa. ");
INSERT INTO tswNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Amma Sulemanu† ɗa ta̱wa̱i u suwa niyi. ");
INSERT INTO tswNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Agba a̱vu wo oꞌwo Mogono ma̱ A̱sula̱ ma̱ tsu da̱nu o uꞌwa u na vaɗilima̱ suwai shi, ununa vumava̱sula̱ dammai, a̱yi a yuwusan adanshi a̱ A̱sula̱, ");
INSERT INTO tswNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Zuva nda̱na̱ta̱ n tsugono n va̱ n ɗa, uvaɗi waru udasata u va̱ u ɗa. Uba̱ta̱ u ne u ɗa yaa gura suwaa mu? I ta gura suwaa mu wivuwatan? ");
INSERT INTO tswNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","A̱mu ɗa n yuwain ili biti a̱tsuma̱ a zuva ni iɗa ne ekere a̱ va̱ shi?’ ");
INSERT INTO tswNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“A̱ɗu agbawata, aza a na okolo e le a̱ ri mejege shi, aza a na atsuvu a̱ ɗu a̱ ri uꞌulu. I ta yuwusan nronuloi na̱ Ruhu va Akiza kuci. Ununa nkaya n ɗu n yuwusain, ne ɗa yaa yuwusan. ");
INSERT INTO tswNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","A̱tsuma̱ a ama̱sula̱ zane ɗa nkaya n ɗu n ꞌyuwain shi? Hali gba o una aza a na a yuwain adanshi o uta̱wu wu Za va̱ A̱ɓula̱ na i winai hali yu una yi. ");
INSERT INTO tswNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ko a na i ushiyi Wila̱ wa̱ A̱sula̱ e ekere a nlingata ma̱ A̱sula̱, ne ɗa i ꞌyuwain a̱ kuru yi mejege suru suru.” ");
INSERT INTO tswNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ana azagbain a Israꞌila a uwwai ne, reve a uwwa upan lon, hali a uwa maluma ma akatsu adama o upan. ");
INSERT INTO tswNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Istifanu gba ana u ri na̱ Ruhu va Akiza, reve u zuwa esu a̱ yi zuva a̱vu we ene tsugbain tsa̱ A̱sula̱. A̱vu we ene Yesu mishin uba̱ta̱ u tsugbain o ukere usaꞌani wa̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Reve u damma le, “Ka̱lyuwa̱i, me ene ta̱ zuva ukpa̱tuꞌu, reve me ene Mawun ma Vuma mishin uba̱ta̱ u tsugbain o ukere usaꞌani wa̱ A̱sula̱!” ");
INSERT INTO tswNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Reve a ula atsuvu e le na akatsu o oruwo lon. Reve a̱ zura̱ yi nu u ta̱. ");
INSERT INTO tswNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Reve o uta̱a̱ yi o ugyuru, ɗaɗa a uwai mavara ma̱ yi na atali. Reve aza a na a̱ shi lo a uwwa niyi a adanshi o foɗo a̱tugu e le o ɓoloto le a̱ ma̱ka̱ka̱n mo ulobo u na a̱ tsu ɗe Shawulu. ");
INSERT INTO tswNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ele a vuvarasa yi, reve Istifanu yuwan avasa u damma, “Yesu Zagbain, ushi wivuwun u va̱.” ");
INSERT INTO tswNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ana u dammai ne, ɗaɗa u kingyoi reve u damma nu ucira, “A̱sulazuva she vu tara le nu unusu wan.” Ɗaɗa u kuwa̱i. ");
INSERT INTO tswNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Shawulu shi ta̱ a̱tsuma̱ a aza a na a̱ usuyi ili i na a yuwain a mantsa ma na o unai Istifanu. Reve ama o ro aza a na a yuwusaan A̱sula̱ a̱ga̱nda̱ a̱ ta̱wa̱ a̱ ciɗo Istifanu na̱ mesun lon. Reve urana u ndolo a̱tsuma̱lima̱ lon a uwa e ekere a̱ a̱za̱ e Itoni a na a̱ ri Urishelima. Reve a̱za̱ e Itoni suru e beteꞌwe a̱ tyo Yahuda na̱ Samariya,† she ajiya goon a ɗa e isawain Urishelima.† ");
INSERT INTO tswNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Reve Shawulu gbaꞌa u uwa a garasa ba̱ta̱ ba̱ta̱ a casu a̱za̱ e Itoni a̱tsuma̱lima̱ lon. U uwusa ta̱ a ꞌwa nu u remi ali na̱ a̱ma̱ci nu u ɓa̱rusu nle o uꞌwa wa ali. ");
INSERT INTO tswNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Reve aza a na e beteꞌwei a yuwusan alajiya a Alabari a Saꞌani.† ");
INSERT INTO tswNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Reve Filibu saɓa a̱ tyo a̱ lyuci gbain a̱tsuma̱ a Samariya reve u uwa a yuwusaan le alajiya a Zamawawa ɗe. ");
INSERT INTO tswNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ana ama a uwwai, waru e enei linga va asalama a na Filibu yuwain, reve o polo atsuvu lon. ");
INSERT INTO tswNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Reve o uta̱a̱ otoni a̱ lima̱ na̱ a̱bunda̱ a̱tsuma̱ a ama, a̱vu otoni a̱ lima̱ꞌa̱ a uwa yisaali lon. Ozo o osowi a̱ lipu na̱ a̱kutsuma̱ na̱ a̱bunda̱ a̱ ka̱mba̱ ta̱ gbaga. ");
INSERT INTO tswNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Adama o ndolo, reve a uwa ma̱za̱nga̱ a̱tsuma̱ a̱ lyuciꞌi suru. ");
INSERT INTO tswNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Vuma ro shi ta̱ pe a̱ lyuciꞌi za na a̱ tsu ɗe Simo a yuwusan tsuboci kuci. Ama a̱ lyuciꞌi a̱ shi ta̱ a yuwusan asalama a̱ yi, u shi ta̱ a tarasa aciya̱yi ili i ro. ");
INSERT INTO tswNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ama a Samariya zagbain na̱ mawun a̱ shi ta̱ a tsu yuwusan adanshi a̱ yi, adansa a na, “Vuma nda ta̱ nu ucira wa̱ A̱sula̱, a̱ tsu ɗe yi ta̱ Za vu Ucira.” ");
INSERT INTO tswNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Reve a̱ ka̱mbuwa̱ ugbozu ya̱ꞌa̱ yi adama a na u jima ta̱ a yuwusaan le linga va asalama o ure u tsuboci. ");
INSERT INTO tswNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ana ama a̱ usuyi alajiya a Alabari a Saꞌani o tsugono tsa̱ A̱sula̱ a ala e Yesu a na Filibu yuwaan nle, a̱vu a̱ rumbu le ali na̱ a̱ma̱ci. ");
INSERT INTO tswNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Reve a̱yi Simo fo na aciya̱yi u ca okolo a̱ yi, a̱vu a̱ rumbu yi. Reve u reme itoni ya̱ Filibu uba̱ta̱ u na u tyoyi biti. Ana we enei iroci na̱ linga va asalama a na a yuwusan reve u uwa asalama lon. ");
INSERT INTO tswNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ana ajiya a na a̱ ri Urishelima a uwwai ama a Samariya a̱ usu ta̱ adanshi a̱ A̱sula̱, reve a̱ lyunguwa̱ le Bituru na̱ Yahaya. ");
INSERT INTO tswNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ele gba ana a rawai reve a yuwaan le avasa adama a̱ tsura̱ Ruhu va Akiza, ");
INSERT INTO tswNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","adama a na koto shi Ruhu va Akizaꞌa u cipa̱a̱ le shi. A̱ shi ta̱ a̱ rumbu le goon na ala† e Yesu Zagbain. ");
INSERT INTO tswNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Reve a̱ kuruwa̱ le ekere, ɗaɗa a̱ tsura̱i Ruhu va Akiza. ");
INSERT INTO tswNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ana Simo enei nu ukurusu we ekere u ɗa a̱ tsu tsura̱ Ruhu va Akiza, ɗaɗa u shi u cigai u ca Bituru na̱ Yahaya ikebe. ");
INSERT INTO tswNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","A̱vu u damma, “Ca numu cuꞌun vu ucira u nda fo, adama za na n kuruwa̱yi ukere suru u tsura̱ Ruhu va Akiza!” ");
INSERT INTO tswNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Reve gba Bituru usu yi, “Vu ta̱ kuwa̱ a̱vu ni ikebe ya̱ wu suru, adama a na vu zuwai ni ikebe i ɗa a̱ tsu tsura̱ uneꞌe wa̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Vu pe na akunda a̱tsuma̱ o ulinga u nda shi, ko keꞌen, adama a na ookolo a̱ wu a̱ ri mejege na̱ A̱sula̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Vu vadala† vu lyawa iwuya ya̱ wu, vu pati A̱sula̱ adama u yuwaan wu gafura vi ili i wuya i na vu sokoi o ookolo a̱ wu. ");
INSERT INTO tswNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Adama a na me ene ta̱ vu ta̱ na̱ tsushuꞌun, waru vu tu ugbedegu nu unusu. ");
INSERT INTO tswNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Reve Simo usu u damma, “Patiya numu Mogono ma̱ A̱sula̱ adama ko ili i ta̱ e ili i na vu dammai i tsura̱ mu wan.” ");
INSERT INTO tswNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ana Bituru na̱ Yahaya rocoi amayun a adanshi o Mogono ma̱ A̱sula̱, reve a̱ ka̱mba̱ Urishelima a yuwusan alajiya a Alabari a Saꞌani a̱ mulyuci ma aza a Samariya na̱ a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","A mantsa mo ndolo reve malingata ma̱ A̱sula̱ mo ro ma damma Filibu, “ꞌYon vu saɓa uyagi vu kuru ure wo ogozo u na wu uta̱i Urishelima a̱ tyo Gaza.” ");
INSERT INTO tswNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Reve u ꞌyon u reme ure, ɗaɗa u gaꞌain na̱ zagbain vi izuwa o tsugono tsu ka Kandakatu vi iɗa ya Habasha. U shi ta̱ u ꞌya̱wa̱ Urishelima adama u yuwan a̱ga̱nda̱. ");
INSERT INTO tswNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","A̱yi a̱ ma̱ka̱mba̱a̱ nden e keke vi ido va̱ yi, a̱vu u uwa ɗesununa̱ a Aatagada a Ishaya vumava̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Reve Ruhu va Akiza damma Filibu, “Wala a rawa zuzu na̱ keke vi ido i ndolo, vi isawan lo na̱ vumaꞌa.” ");
INSERT INTO tswNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ɗaɗa Filibu sumai a rawa zuzu ɗaɗa u tsu uwwa yi e ɗesununa̱ a aatagada a Ishaya† vumava̱sula̱. A̱vu we ece yi, “Vu te reveshe ili i na vee ɗesununa̱?” ");
INSERT INTO tswNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","A̱vu u usu, “Te gba? She na̱ za ro cuɗuwa mu.” Reve u pati Filibu kumba u da̱nu na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Uba̱ta̱ u na u shi e ɗesununa̱ u ɗa nda, “O rono yi ta̱ a̱ tyo uba̱ta̱ u mapaɗa ana kyon,† ununa ma̱giriꞌi ma̱ tsu da̱na̱ kpaku uba̱ta̱ wu za na oo kukoɗuso yi eleme, ne ɗa ko una̱ wa̱ yi u kpa̱tuꞌwa̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","O roco yi ta̱ a̱tsuma̱lima̱ hali a putsaa yi ni ili i na i ri mejege. Zane ɗa aa gura ca alabari a limatan a̱ muwun ma̱ yi na̱ muwun mu ugundo ma̱ yi? Babu za, adama a na o koɗoi wuma wa̱ yi a̱tsuma̱ o uvaɗi.” ");
INSERT INTO tswNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","A̱vu zagbaiꞌin u damma Filibu, “Damma mu, vumava̱sula̱ nda adanshi a̱ zane a ɗa waa yuwusan? Adanshi a aciya̱yi ko za ro?” ");
INSERT INTO tswNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Reve Filibu kpa̱tuꞌwa̱ una̱ wa̱ yi u teme nu uba̱ta̱ u na wee ɗesununa̱ꞌa̱, a̱vu u yuwaan yi adanshi a Alabari a Saꞌani† e Yesu. ");
INSERT INTO tswNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ele a̱tsuma̱ a mmalu, reve a rawa a̱ mini mo ro. A̱vu zagbaiꞌin u damma, “Nda mini! Nye yaa putsaa a̱a̱ rumbu mu?”  ");
INSERT INTO tswNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","A̱vu Filibu usu u damma, “Na̱ vu usu Yesu Zamawawa Mawun ma̱ A̱sula̱ ma ɗa, n ta̱ rumbu wu.” Reve vumaꞌa u usu, “N usu ta̱ Yesu Mawun ma̱ A̱sula̱ ma ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Reve u zuwa e isawaton keke vi idoꞌo. Reve ele ra a uwa a̱ miniꞌi, reve Filibu rumbu yi. ");
INSERT INTO tswNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ana o uta̱i a̱ miniꞌi, reve Ruhu Mogono ma̱ A̱sula̱ ma̱ ka̱fa̱ Filibu, agba zagbaiꞌin u da̱shi ene yi waru shi. Reve u ka̱ra̱ a̱ ma̱za̱nga̱ ma̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Agba reve e ene Filibu a̱ lyuci va Azatu. Reve u ka̱nda̱ruwa̱ ilyuci suru a yuwusan alajiya a Alabari a Saꞌani, hali u rawa Kasariya. ");
INSERT INTO tswNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Shawulu lyuwa ta̱ elime a casu a̱za̱ e Itoni a̱tsuma̱lima̱ lon, adansa a na u to una le. Reve u ꞌya̱wa̱ ya aabara a nan ganu, ");
INSERT INTO tswNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","reve u pati u ca yi mpepelime a̱ ꞌya̱wa̱ a̱ a̱ꞌisa̱ a̱tsuma̱ a Dimaska. U zamishi ta̱ uɓolu wa aci u le, tsa̱ra̱ nu u tsura̱ pe aza a na o toniyi Ure wu Zagbain u lyungwa̱ le, ali na̱ a̱ma̱ci, tsa̱ra̱ waru u ta̱wa̱ ne ele wunlu a akani a̱tsuma̱ a̱ Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ana u rawai zuzu na̱ Dimaska adama o ulinga u ndolo, babu usa̱n reve ekan o uta̱ ɗe zuva u ka̱nda̱ruwa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Reve u riya̱ e iɗa, reve wu uwwa uɗyo, adansa, “Shawulu, Shawulu, cine tsa ɗa voo ɓongishi mu?” ");
INSERT INTO tswNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Reve u damma, “A̱vu ɗa zane, Zagbain?” Reve uɗyoꞌo u damma yi, “A̱mu ɗa Yesu za na voo ɓongishi. ");
INSERT INTO tswNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ꞌYon vu uwa a̱tsuma̱ a̱ lyuci ndeɗe, a ta damma wu ili i na vaa yuwan.” ");
INSERT INTO tswNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Reve nꞌutsa̱ mu mmalu ma̱ yi a̱ kuɗa̱ a yuwan adanshi, a ta uwwusa uɗyo agba e ene vuma shi. ");
INSERT INTO tswNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Reve Shawulu ꞌyon, ana u kpa̱tuꞌwa̱i esu a̱ yi u gura ene shi. Reve e reme yi ukere reve a̱ ta̱wa̱to yi Dimaska. ");
INSERT INTO tswNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","U yuwan ta̱ rana taꞌatsu urumba̱nu, u lyuwa shi agba u sowo shi. ");
INSERT INTO tswNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","A mantsaꞌa za vi Itoni† ro da̱na̱ ta̱ pe a̱tsuma̱ a Dimaska, za na a̱ tsu ɗe Ananiya. Zagbain yuwaan yi ta̱ adanshi a̱tsuma̱ a alavu alavu, adansa, “Ananiya.” Reve a̱yi u usu, “A̱mu ɗa nda Zagbain.” ");
INSERT INTO tswNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Reve Zagbaiꞌin damma, “ꞌYon vu ꞌya̱wa̱ o ure u na a̱ tsu ɗe Ure u Mejege. Vu ꞌya̱wa̱ o uꞌwa wa Yahuza ve ece ko vuma va Tarsu ta̱ pe za na ri na aala Shawulu. U ta̱ lo a yuwusan avasa uba̱ta̱ꞌa̱. ");
INSERT INTO tswNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","N roco yi ta̱ alavu alavu a vuma na a̱ tsu ɗe Ananiya a uwa, u zuwaa yi ukere adama we enishe ure.” ");
INSERT INTO tswNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","A̱vu gba Ananiya usu u damma, “Zagbain n sowo ta̱ a uwwusa adanshi a vuma ndaꞌa o una̱ wa ama na̱ a̱bunda̱, adama e iwuya ya̱ a̱bunda̱ a na u yuwayin ama a akiza a̱ wu a̱tsuma̱ a̱ Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","A̱yi ɗa nda nan ganu a gbagbain a ca niyi ucira u reme vuma na yuwain avasa a̱tsuma̱ a ala a̱ wu.” ");
INSERT INTO tswNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Reve Zagbain damma yi, “A̱vu de ꞌya̱wa̱ adama a na a̱yi vuma na n ɗangwai ɗa tsa̱ra̱ u yuwan ulinga u va̱, tsa̱ra̱ u revetyo ala a̱ va̱ a̱tsuma̱ a Atakpaci, na̱ ngono, na aza a Israꞌila. ");
INSERT INTO tswNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","A̱mu na aciya̱va̱ n to roco yi cuꞌun va̱ a̱tsuma̱lima̱ a na woo sowo adama a ala a̱ va̱.” ");
INSERT INTO tswNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Reve Ananiya ꞌya̱wa̱ reve u uwa o uꞌwaꞌa, a̱vu u canana ukere wa̱ yi a̱vu u juꞌwa̱n Shawulu, u damma, “Moron ma̱ va̱ Shawulu, Yesu Zagbain ɗa lyungu numu a̱ tyo ya̱ꞌa̱ wu. Yesu za na roco nuwu aciya̱yi o ure u na vu kuruyi. U ciga wu ta̱ tsa̱ra̱ vu da̱shi gura ene ure, reve waru o shiton wu na̱ Ruhu va Akiza.” ");
INSERT INTO tswNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Babu usa̱n reve ili i ro i riya̱ diga pe esuꞌu gashi a̱ka̱ɓa̱, ɗaɗa we eneshi ure. A̱vu u ꞌyon, ɗaɗa a̱ rumbu niyi. ");
INSERT INTO tswNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Reve u lyuwa ilyalya ɗaɗa u tsura̱shi ucira. Reve Shawulu yuwan rana re oɓolo na̱ a̱za̱ e Itoni a na a̱ ri pe a̱tsuma̱ a Dimaska. ");
INSERT INTO tswNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Babu a jima, ɗaɗa Shawulu temei alajiya e Yesu a̱tsuma̱ a̱ a̱ꞌisa̱ a aza a Israꞌila, adansa Yesu ɗa Mawun ma̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Reve aza a na a uwwa niyi suru a̱ ka̱ra̱ a asalama, adansa, “A̱yi nda a̱yi ɗa vuma na unusai a̱za̱ e Itoni, reve waru u beteꞌwe le, ele aza a na e ɗesu a̱tsuma̱ a ala o ndolo shi? U ta̱wa̱ ta̱ pa tsa̱ra̱ u reme le, reve wu nla̱ le na akani, reve waru u ꞌya̱wa̱to le a̱ ma̱ka̱ka̱n ma nan ganu a gbagbain shi?” ");
INSERT INTO tswNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Reve Shawulu da̱shi tsura̱ ucira a̱tsuma̱ a alajiya a̱ yi. Agba aza a Israꞌila a̱tsuma̱ a Dimaska a gura polo yi a adanshi a̱ yi shi, a na Yesu ɗa Zamawawa va amayun. ");
INSERT INTO tswNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ana a yuwain rana meketeci, a̱vu aza a Israꞌila† a yuwan ifoɓi i na oo una Shawulu. ");
INSERT INTO tswNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Reve a̱yi wu uwwa ifoɓi i le. A zuwusa ta̱ esu e le usana nu ulivu o una̱ntsu wu ukari u lyuci tsa̱ra̱ o una yi. ");
INSERT INTO tswNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Na ayin, a̱vu ojoro a̱ yi a tara yi, reve a̱ ta̱lyuwa̱to yi a̱tsuma̱ a aasaka na̱ wungu wu ukari. ");
INSERT INTO tswNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ana Shawulu ta̱wa̱i Urishelima, u yuwan ta̱ a̱tyo a na waa yuwan tsa̱ra̱ u ɓolo aci no ojoro.† A̱vu suru nle a uwwa wovon adama a na a̱ usu ko a̱yi oojoro a ɗa shi. ");
INSERT INTO tswNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","A̱vu Banaba tara yi a̱ tyo uba̱ta̱ wa ajiya. Reve u damma le ununa Shawulu enei Zagbain o ure. Reve waru u damma le cine Zagbain yuwaan niyi adanshi, na̱ cine Shawulu yuwain alajiya adama e Yesu a̱ lyuci va Dimaska babu wovon. ");
INSERT INTO tswNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Diga lo ɗaɗa Shawulu remei maꞌuwa na̱ wu uti oɓolo ne ele a̱tsuma̱ a̱ Urishelima. Reve u uwa alajiya a̱tsuma̱ a ala a Zagbain, babu wono babu wovon. ");
INSERT INTO tswNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Reve u uwa a yuwusan adanshi na aza a Israꞌila a na a yuwusan Tsuheleni,† reve u uwa mawasan ne ele. A̱vu a zamishi ure u na oo una yi. ");
INSERT INTO tswNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ana a̱za̱ a̱ yi a uwwai ili i na i ri pe, ɗaɗa a tara niyi a̱ ꞌya̱wa̱ Kasariya a̱vu a tara yi a wantsun a̱ ka̱mba̱ Tarsu. ");
INSERT INTO tswNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mantsa mo ndolo ma ɗa a̱za̱ e Itoni a Yahuda, na̱ Ga̱lili, na̱ Samariya, a̱ tsura̱i nden n lafiya. A̱za̱ e Itoni a̱ tsura̱ ta̱ ucira, reve a̱ da̱shi a̱bunda̱ ni ikambi ya̱ Ruhu va Akiza a yashi i na a̱ da̱na̱i a mmalu na̱ Zagbain. ");
INSERT INTO tswNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Reve Bituru ka̱nda̱ruwa̱ uba̱ta̱ suru tsa̱ra̱ u ka̱lyuwa̱ le. A̱yi a̱tsuma̱ a̱ a̱ka̱nda̱riya̱, reve u ta̱wa̱ u cina aza a akiza a̱ lyuci va Lida. ");
INSERT INTO tswNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","A̱ lyuci ɗaɗa u cinai vuma ro za na a̱ tsu ɗe Iniyasu na̱ mɓa̱la̱ n tsukutsuma̱ aꞌwan kunla̱. ");
INSERT INTO tswNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Reve Bituru damma yi, “Iniyasu, Yesu Zamawawa ka̱mba̱to wu ta̱ gbaga. ꞌYon vu kutsulu aavalu a̱ wu.” Babu usa̱n, reve u ꞌyoshin. ");
INSERT INTO tswNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Reve ama a Lida ni iɗa ya Sharana suru a vadala a̱ tyo uba̱ta̱ wu Zamawawa ana e enei Iniyasu a mmalu. ");
INSERT INTO tswNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","A̱tsuma̱ a̱ lyuci va Japa ka ro za vi Itoni da̱na̱ ta̱ pe za na a̱ tsu ɗe Tabita a na Dokas na̱ Tsuheleni. Kaꞌa u zuwa ta̱ aciya̱yi u yuwan ulinga u saꞌani, reve waru u da̱na̱ a kambusa alambi. ");
INSERT INTO tswNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","A yashiꞌi u banakan ta̱, reve u kuwa̱. Ana a̱ sumba̱ niyi reve o voton yi a aasula a zuva. ");
INSERT INTO tswNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ana a uwwai Bituru ta̱ Lida, lyuci na ri zuzu na̱ Japa, reve a̱ lyungu ama e re a lyawa Japa a̱ ꞌya̱wa̱ a damma yi, “Yuwan ankuri, ta̱wa̱ gogo, she vu jima wan.” ");
INSERT INTO tswNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Reve Bituru ꞌyon u kuru le. Ana u rawai, a̱vu a̱ ꞌya̱wa̱to yi a aasula a zuva. Nruna̱ suru e isawan ta̱ zuzu na̱ a̱yi, e mesun. Reve a uwa o rocosu a̱tugu na akapi e itana i na Dokas u yuwaan nle a̱yi oɓolo ne ele. ");
INSERT INTO tswNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Reve Bituru uta̱a̱ le suru, reve u ka̱ɗa̱to u yuwan avasa. Reve u vadala a̱ tyo uba̱ta̱ wa̱ a̱a̱kwa̱kwa̱ꞌa̱, reve u damma, “Dokas ꞌyon.” Reve u kpa̱tuꞌwa̱ esu. Ana we enei Bituru reve u ꞌyon u da̱nu. ");
INSERT INTO tswNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Reve Bituru cananaa yi ukere a̱vu u kamba yi tsa̱ra̱ u ꞌyon. Reve u ɗe a̱za̱ e Itoni oɓolo na̱ nruna̱, ɗaɗa u roco le a na Dokas ka̱mba̱i wuma. ");
INSERT INTO tswNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Adanshi o ndolo a uwa ta̱ ba̱ta̱ suru a̱tsuma̱ e iɗa ya Japa. Reve ama a̱ a̱bunda̱ a vadala a̱ tyo uba̱ta̱ wu Zagbain. ");
INSERT INTO tswNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Bituru yuwan ta̱ rana re a̱ lyuci va Japa, o uꞌwa wa̱ Simo za na aa yuwusan yozu vu kwan. ");
INSERT INTO tswNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","A̱tsuma̱ a Kasariya vuma na a̱ tsu ɗe Kaniliya da̱na̱ ta̱ pe a̱tsuma̱ a yali ya̱ a̱soja, u da̱na̱ ta̱ a̱tsuma̱ a̱ A̱soja a Italiya. ");
INSERT INTO tswNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","A̱yi vuma va̱ a̱ɓula̱ ɗa. U ta uwwusa wovon wa̱ A̱sula̱, a̱yi na̱ muwun ma̱ yi suru. U tsu kambusa ta̱ ama a na a̱ ri ni ili shi. U tsu yuwusan ta̱ avasa kuci a̱ tyo a̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Urana u ro, zuzu na̱ rumu taꞌatsu vu ulivu, reve we ene malingata ma̱ A̱sula̱ a alanga e eteshe a̱tsuma̱ a alavu alavu, u ta̱wa̱i uba̱ta̱ wa̱ yi, adansa, “Kaniliya!” ");
INSERT INTO tswNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Reve u zuwaa yi esu a̱tsuma̱ o wovon, reve u damma, “Zagbain nye i ɗa?” Reve malingata ma̱ A̱sula̱ ma damma yi, “Avasa a na vaa yuwusan ni ikambi ya alambi a na vaa yuwusan u rawa ta̱ a̱ ma̱ka̱ka̱n ma̱ A̱sula̱. Gogo A̱sula̱ a uwwa ta̱ avasa a̱ wu. ");
INSERT INTO tswNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Gogo lyungu ama a̱ ꞌya̱wa̱ Japa tsa̱ra̱ e ɗe Simo za na ee ɗesu Bituru. ");
INSERT INTO tswNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Za na cuꞌwain o uꞌwa wa̱ Simo za na aa yuwusan yozu vu kwan, za na uꞌwa wa̱ yi u ri zuzu na̱ mala.” ");
INSERT INTO tswNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ana malingata ma̱ A̱sula̱ ma na ma yuwaan niyi adanshi ma̱ ka̱ra̱i, reve u ɗe agbashi e re a̱ yi, na̱ soja ro, za na a uwwusa wovon wa̱ A̱sula̱, a̱tsuma̱ a aza a na a yuwusaan yi ulinga kuci. ");
INSERT INTO tswNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ana u damma nle iliꞌi suru, a̱vu u lyungu le a̱ ꞌya̱wa̱ Japa. ");
INSERT INTO tswNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ana usana u tawai, cina urana u rawa a aci, agbashi a Kaniliya a̱tsuma̱ a mmalu, ɗaɗa a rawai zuzu na̱ lyuciꞌi. A̱vu Bituru kumba o uꞌwa wa zuva tsa̱ra̱ u yuwan avasa. ");
INSERT INTO tswNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Reve wu uwwa ambulu, hali u ciga u lyuwa ilyalya. Agba ele pe a̱tsuma̱ e ifoɓi yi ilyalya, a̱vu we ene alavu alavu. ");
INSERT INTO tswNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Reve we ene zuva kpa̱tuꞌwa̱, ni ili i ro a̱ cipusa̱ oroci a aapalutsu o umuna ne elentsu a̱ na̱shi uguzu a̱ tyo e iɗa. ");
INSERT INTO tswNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","A aapalutsuꞌu cuꞌun vi inama suru a̱ ta̱ pe: inama ya ana a̱ na̱shi, ni inama yi ika̱ta̱pu, na̱ nnunu. ");
INSERT INTO tswNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Reve wu uwwa uɗyo adansa yi, “Bituru, ꞌyon vu paɗa, reve vu tama.” ");
INSERT INTO tswNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Reve u damma, “Zagbain, oꞌo! A wuma u va̱ koto n tama cuꞌun va̱ yi shi, adama a na a̱tsu tsu tsu ta̱ na̱ Wila̱ u na tsu tama le shi, adama a na a̱ ti idaba.” ");
INSERT INTO tswNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Reve uɗyoꞌo u dammisa yi, “She vu yuwan mawasan na̱ A̱sula̱ wan. Nu u damma u tu ulobonu she vu damma u lamba ta̱ ulobonu wan.” ");
INSERT INTO tswNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","U tsura̱ ta̱ alavu alavu o ndolo toto utaꞌatsu. Reve a paluꞌushi aapalutsuꞌu a̱ tyo zuva. ");
INSERT INTO tswNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Bituru da̱na̱ ta̱ a majiyan, ko cuꞌun va alavu alavu e ne ɗa we enei. Reve ama a na Kaniliya lyunguyi a rawa a̱ lyuciꞌi, reve e ece uꞌwa wa̱ Simo. Ana a rawai, a̱vu e isawan mishin o una̱ntsu. ");
INSERT INTO tswNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","A̱vu a yuwan a̱zoꞌwa, e eceshe ko Simo na a̱ tsu ɗe Bituru cuꞌwan ta̱ uba̱ta̱ꞌa̱. ");
INSERT INTO tswNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","A mantsa ma na Bituru da̱na̱i a majiyan ma alavu alavu o ndolo, reve Ruhu damma yi, “Ama a taꞌatsu a ɗa ndolo e izami ya̱ wu. ");
INSERT INTO tswNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ꞌYon vu cipa̱ vu kuru le. She vu lyawa ookolo a̱ wu a̱ ꞌyon wan, adama a na a̱mu ɗa n lyungu nle.” ");
INSERT INTO tswNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Reve Bituru cipa̱ u cina amaꞌa, a̱vu u damma le, “A̱mu ɗaɗa i ri e izami. Nye i zuwai i ri azama mu?” ");
INSERT INTO tswNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Reve a damma yi, “Yali† ya̱ a̱soja ya̱ Roma ɗa, za na a̱ tsu ɗe Kaniliya lyungu ntsu. Vuma va̱ a̱ɓula̱ ɗa, za na a uwwusa wovon wa̱ A̱sula̱. Aza a Israꞌila suru a ta yuwusan adanshi a saꞌani a aci a̱ yi. A̱yi ɗa malingata ma̱ A̱sula̱ ma dammai u lyungu tsu uba̱ta̱ wa̱ wu vu ta̱wa̱, tsa̱ra̱ wu uwwa ili i na vaa damma.” ");
INSERT INTO tswNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ana Bituru uwwai ne, reve u uwato le o uꞌwa, reve u ca le uba̱ta̱ u na aa asa. Ana usana u tawai, reve a̱ ka̱ra̱ suru, a̱vu nron mi Itoni n ro a̱tsuma̱ a Japa e shewun yi. ");
INSERT INTO tswNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Reve a rawa Kasariya nu usana. Reve Kaniliya da̱na̱ a pura le, a̱vu u banu edenge a̱ yi na̱ nꞌutsa̱ ma̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ana Bituru uwai o uꞌwa wa̱ yi, reve Kaniliya ka̱ɗa̱to e iɗa a̱ ma̱ka̱ka̱n ma̱ yi. Reve u teme a yuwusaan yi a̱ga̱nda̱. ");
INSERT INTO tswNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Reve Bituru damma yi, “ꞌYon mishin a̱mu fo vuma ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Reve u ꞌyon a yuwunlai adanshi waꞌa, reve a uwa uba̱ta̱ u na ama o ro a̱ ri uɓolotowu. ");
INSERT INTO tswNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Reve Bituru damma le, “I reve ta̱ a na Wila̱ u tsu u putsaa ntsu a na tsaa yuwan ndammulai na Atakpaci. Amma A̱sula̱ o roco mu ta̱ she n ɗe za ro za babu akiza wan, ko za vi idaba wan. ");
INSERT INTO tswNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ana i lyunguwa̱ numu n ta̱wa̱, n ta̱wa̱ ta̱ babu usa̱n. Gogo damma numu ili i na i zuwai i lyunguwa̱ numu.” ");
INSERT INTO tswNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Reve Kaniliya damma, “Rana na̱shi na ka̱ra̱i, a̱mu a̱tsuma̱ a avasa a mantsa ma na n tsu yuwusan. Reve me ene vuma mishin a̱ ma̱ka̱ka̱n ma̱ va̱ wotowu ni itana a madala. ");
INSERT INTO tswNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Reve u damma mu, ‘Kaniliya, a uwwa ta̱ avasa a̱ wu, A̱sula̱ e reve ta̱ a na vaa casu alambi ili. ");
INSERT INTO tswNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Vu lyungu ama a̱ ꞌya̱wa̱ Japa e ɗe Simo za na a̱ tsu ɗe Bituru. U cuꞌwan ta̱ o uꞌwa wa̱ Simo, za na aa yuwusan yozu vu kwan, za na uꞌwa wa̱ yi u ri zuzu na̱ mala.’ ");
INSERT INTO tswNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Koto a jima shi a na n lyunguwa̱ nuwu, a̱vu ɗa nda vu ta̱wushi babu usa̱n. A̱tsu ɗa nda a̱ ma̱ka̱ka̱n ma̱ A̱sula̱, tsa̱ra̱ tsu uwwa ili i na Zagbain damma nuwu vu damma tsu suru.” ");
INSERT INTO tswNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Reve Bituru yuwaan le adanshi a na, “N gura ta̱ reve gogo, A̱sula̱ a̱ ri na aɗangulu shi. ");
INSERT INTO tswNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","U ciga ta̱ vuma na a uwwusa wovon wa̱ yi a̱tsuma̱ e iɗa suru, vuma na a yuwusan isaꞌani i na A̱sula̱ a cigai. ");
INSERT INTO tswNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","I reve ta̱ ikaka i na A̱sula̱ a̱ lyunguwa̱yi aza a Israꞌila. U damma le ta̱ Alabari a Saꞌani o ta̱ lo, na̱ nden mo okolo e Yesu Zamawawa, za na a̱yi ɗa Zagbain vi ili suru suru. ");
INSERT INTO tswNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","I reve ta̱ cine ili i ndolo i farai a̱tsuma̱ a Yahuda suru. Yahaya damma ta̱ vuma suru a̱ rumbu yi, ili i ndolo suru i fara ta̱ diga Ga̱lili. ");
INSERT INTO tswNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yu uwwa ta̱ alabari e Yesu vuma va Nazara, ununa A̱sula̱ a sukuma niyi na̱ Ruhu va Akiza, reve u ca yi ucira. Yesu da̱na̱ ta̱ a̱ ka̱nda̱ruwusa̱ a yuwusan ulinga u saꞌani. U wawusa ta̱ aza a na Mekerenkesu ma zuwai elime, adama a na A̱sula̱ o to oɓolo na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“A̱tsu waru tse ene ta̱ ne esu a̱ tsu ili i na u yuwain suru a̱tsuma̱ a̱ Urishelima ni iɗa ya aza a Israꞌila. Ɗaɗa waru a vara niyi zuva va akpata. ");
INSERT INTO tswNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Reve gba A̱sula̱ a̱ ꞌya̱sa̱n yi o urana wa taꞌatsu, reve u lyawa yi u roco aciya̱yi uba̱ta̱ wa ama. ");
INSERT INTO tswNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","U roco aciya̱yi uba̱ta̱ wa ama suru shi, amma a̱ tyo ya̱ꞌa̱ tsu, a̱tsu na A̱sula̱ a ɗangwai tso oꞌwo alingi a̱ yi. Tsu lyuwa ta̱ tsu sowo oɓolo na̱ a̱yi ana u ꞌyoyin a̱tsuma̱ a̱ a̱kwa̱kwa̱. ");
INSERT INTO tswNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","U damma tsu ta̱ tsu yuwaan ama alajiya, tsu damma waru a̱yi ɗa za na A̱sula̱ a zuwai u geꞌeto aza a wuma na̱ a̱kwa̱kwa̱. ");
INSERT INTO tswNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ama̱sula̱ suru a yuwan ta̱ adanshi adama a̱ yi, a na za na cayi okolo e ekere a̱ yi u ta̱ tsura̱ gafura vu unusu a̱tsuma̱ a ala a̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Bituru a̱tsuma̱ a adanshi, reve Ruhu va Akiza† cipa̱a̱ aza a na a̱ da̱na̱i a uwwusa adanshi a̱ yi suru. ");
INSERT INTO tswNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","A̱za̱ e Itoni a Yahuda, aza a na a̱ ta̱wa̱i oɓolo na̱ Bituru a uwa ta̱ asalama a na e enei Atakpaci† fo a̱ tsura̱i uneꞌe u Ruhu va Akiza. ");
INSERT INTO tswNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","A uwwa le ta̱ a yuwusan adanshi ne elentsu o ro, a casu A̱sula̱ tsugbain. Reve Bituru damma, ");
INSERT INTO tswNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Nanza ta̱ lo za na aa gura putsaa a̱ rumbu ama a nda a̱ mini? Ele ɗa nda a̱ tsura̱i uneꞌe u Ruhu va Akiza cine a̱tsu tsu tsura̱i.” ");
INSERT INTO tswNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Reve Bituru damma a yuwaan le urumbusu a̱tsuma̱ a ala e Yesu Zamawawa. Reve a pati yi u da̱nu ne ele rana meketeci. ");
INSERT INTO tswNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Reve ajiya na̱ a̱za̱ e Itoni a̱tsuma̱ a Yahuda a uwwa a na Atakpaci a̱ usuyi adanshi a̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ana Bituru ka̱mba̱i Urishelima, reve aza a Israꞌila a na o oꞌwoi a̱za̱ e Itoni a gasa yi na̱ a̱ga̱ci a adanshi. ");
INSERT INTO tswNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","A̱vu a damma, “A̱yi ɗa nda vu uwai a̱tsuma̱ a Atakpaci, hali vu lyuwa ilyalya oɓolo ne ele!” ");
INSERT INTO tswNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Reve Bituru cuɗuwa le ili i na i yuwain suru. ");
INSERT INTO tswNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","A̱vu u damma, “N shi ta̱ a̱ lyuci va Japa a̱mu a̱tsuma̱ a avasa, reve n uwa a̱tsuma̱ a alavu alavu. A̱tsuma̱ a alavu alavuꞌu me ene ta̱ zuva kpa̱tuꞌwa̱i, reve a̱ cipa̱towa̱ mu ili i ro ana aapalutsu o umuna uguzu ne elentsu a̱ na̱shi a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ana n ka̱lyuwa̱i pe, reve me ene inama ya ana a̱ na̱shi yu uvaɗi, ni inama yi ika̱ta̱pu e iɗa, na̱ nnunu. ");
INSERT INTO tswNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Reve mu uwwa uɗyo u ro adansa mu, ‘ꞌYon Bituru! Vu paɗa vu tama.’ ");
INSERT INTO tswNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Reve n usu, ‘Ne ɗa shi A̱sulazuva! Koto n tama ili i na Wila̱ wa̱ wu u putsayi shi.’ ");
INSERT INTO tswNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Reve uɗyoꞌo u da̱shi dammisa ire, ‘She vu ka̱mbuwa̱ ili i na A̱sula̱ o oꞌwotoi cece ili yi idaba wan.’ ");
INSERT INTO tswNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ne ɗa a yuwain hali toto utaꞌatsu, reve o koso o rono umunaꞌa a̱ tyo zuva. ");
INSERT INTO tswNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“A̱mu lo ɗaɗa ama a Kasariya a taꞌatsu a rawushi, aza a na a̱ lyunguyi a̱ ta̱wa̱ ya̱ꞌa̱ va̱, reve a rawa o uꞌwa u na n shi. ");
INSERT INTO tswNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Reve Ruhu va Akiza† damma mu, she n ꞌyuwan a̱ kuru le wan. Reve ama a̱ ta̱li a̱tsuma̱ a̱ a̱za̱ e Itoni a̱ kuru mu, reve tsu uwa o uꞌwa u vuma ro. ");
INSERT INTO tswNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Reve vumaꞌa u damma tsu ununa we enei malingata ma̱ A̱sula̱ o uꞌwa wa̱ yi. Reve u damma yi, ‘Vu lyungu ozo o ro a̱ lyuci va Japa e ɗewe wu Simo za na a̱ tsu ɗe Bituru. ");
INSERT INTO tswNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Vumaꞌa u ta̱ ta̱wa̱a̱ wu nu ure u na aa wawa wu na ama a na a̱ ri pe o uꞌwa wa̱ wu suru.’ ");
INSERT INTO tswNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Ana n farai adanshi, reve Ruhu va Akiza ta̱wa̱ le ununa u ta̱wa̱ ntsu o ufaru. ");
INSERT INTO tswNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ɗaɗa n cuwain a na A̱sulazuva a dammai, ‘Yahaya rumbu† ɗu ta̱ na̱ mini, amma A̱sula̱ a̱ ta̱ rumbu ɗu na̱ Ruhu va Akiza.’ ");
INSERT INTO tswNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","To, na̱ A̱sula̱ a ca Atakpaci a nda uneꞌe una̱ta̱ na̱ a̱tsu a mantsa ma na tsu ushiyi Yesu Zagbain Zamawawa, zane ɗa a̱mu a na maa wasan ili i na A̱sula̱ a cigai?” ");
INSERT INTO tswNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ana a uwwai ili i na Bituru dammai, reve a lyawa mawasan. Reve a uwa a ciɓalasa A̱sula̱, reve a damma, “Gogo A̱sula̱ a lyawa ta̱ Atakpaci a vadala adama a̱ tsura̱ wuma u babu ukotu!” ");
INSERT INTO tswNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","A mantsa ma nda cina o una Istifanu, reve a̱za̱ e Itoni a na a̱ ri Urishelima e beteꞌwe adama a̱ a̱tsuma̱lima̱. Reve a̱ ka̱ra̱ a̱ tyo e iɗa ya Finisiya na̱ Kuburu na̱ Antakiya va Suriya. Reve a yuwusaan aza a Israꞌila goon alajiya a Alabari a Saꞌani e Yesu Zagbain. ");
INSERT INTO tswNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Reve a̱za̱ e Itoni aza a na a̱ ri ama a̱ Kuburu na̱ Kurani, a̱ ka̱ra̱ a̱ tyo Antakiya, a̱vu a uwa a yuwusaan Atakpaci alajiya a Alabari a Saꞌani e Yesu Zagbain. ");
INSERT INTO tswNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ucira wa̱ A̱sulazuva u shi ta̱ oɓolo ne ele, reve ama na̱ a̱bunda̱ a ca okolo e le. Reve a vadala a̱ kuru A̱sulazuva. ");
INSERT INTO tswNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Reve a̱za̱ e Itoni a̱tsuma̱ a̱ Urishelima a uwwa ili i na i farai a̱tsuma̱ a Antakiya, a̱vu a̱ lyungu Banaba ɗe. ");
INSERT INTO tswNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ana u rawa we enei icigi i na A̱sula̱ a yuwaan nle, reve u yuwan ma̱za̱nga̱. A̱vu u ca le a̱sa̱la̱ adama a kaɓa asuvu, waru a lyuwa elime ni itoni ya̱ A̱sulazuva. ");
INSERT INTO tswNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banaba vuma va̱ a̱ɓula̱ ɗa, waru u tu ushitowun na̱ Ruhu va Akiza nu ucawu wo okolo. Reve ama o ro na̱ a̱bunda̱ a̱ da̱shi usuwisa̱ a̱ kuru A̱sulazuva. ");
INSERT INTO tswNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Reve u kuru a̱ tyo Tarsu adama u bunga̱ Shawulu. ");
INSERT INTO tswNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ana we ene niyi reve u ta̱wa̱ na̱ a̱yi Antakiya. Reve ele ra o una aaꞌwan ma̱ɓula̱ pe oɓolo na̱ a̱za̱ e Itoni oo ritosu ama na̱ a̱bunda̱. A̱tsuma̱ a Antakiya a ɗa a fara ɗeyi aza a na a̱ kurusu Yesu “A̱za̱ e Itoni.”† ");
INSERT INTO tswNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","A mantsa ma nda ma ɗa ama̱sula̱ o ro o uta̱i Urishelima reve a̱ tyo Antakiya. ");
INSERT INTO tswNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Reve vuma ta̱ a̱tsuma̱ e le za na a̱ tsu ɗe Agabu ꞌyon mishin. Ni ikambi i Ruhu va Akiza, reve u damma a na a ta yuwan ambulu lon uba̱ta̱ suru a̱tsuma̱ o uvaɗi. A yuwan ta̱ iliꞌi a mantsa ma na Kaladiya da̱na̱i o tsugono tsi iɗa tsa̱ Roma.† ");
INSERT INTO tswNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Reve a̱za̱ e Itoni ya Antakiya a yuwan majiyan a̱ lyungu ni ikambi a̱ tyo uba̱ta̱ wa̱ a̱za̱ e Itoni a na a̱ ri nden e iɗa ya Yahuda. Vuma suru u ca ununa waa gura. ");
INSERT INTO tswNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ne ɗa a yuwain, reve a̱ lyungu Banaba na̱ Shawulu ni ikambi i le a ca mbara ma̱ a̱za̱ e Itoni n Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","A mantsa ma na Banaba na̱ Shawulu a̱ ta̱wa̱yi nu uneꞌe a̱tsuma̱ a̱ Urishelima, reve mogono Hiridu† Agaripa teme a̱ ta̱wusa̱ na̱ a̱tsuma̱lima̱ e ekere a̱ a̱za̱ e Itoni ɗe Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Reve u zuwa a̱soja o koɗo aaci a Yakubu aajiya, mawun ma̱ a̱na̱wu ma Yahaya. ");
INSERT INTO tswNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ana we enei ili i ndolo i yoꞌonoto ta̱ okolo a amaꞌa, reve u lyungu a̱sojaꞌa tsa̱ra̱ e reme Bituru a mantsa ma̱ A̱buki o Opopofu.† ");
INSERT INTO tswNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Reve u zuwa le a̱ ɓa̱ru yi o uꞌwa wa ali, reve u zuwa a̱soja a̱ na̱shi a̱ na̱shi oɓolo a̱ na̱shi a̱ piri yi. U yuwan ta̱ ifoɓi tsa̱ra̱ u geꞌeto yi a alanga e eteshe no o koto a̱bukiꞌi. ");
INSERT INTO tswNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","A mantsa ma na Bituru da̱na̱i a̱tsuma̱ o uꞌwa wa ali, a̱za̱ e Itoni a lyawa avasa adama a̱ yi shi. ");
INSERT INTO tswNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","A̱tsuma̱ a ayin o ndolo ana Hiridu yuwain majiyan ma na woo uta̱a̱ na̱ Bituru nu usana u tawa, Bituru da̱na̱ ta̱ wunlu a nlavu na akani e re a̱tsuma̱ a̱ a̱soja e re. A̱soja e re o ro waru lo mishin a̱ pirishi una̱ntsu. ");
INSERT INTO tswNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ele lo babu usa̱n, reve ekan e ikana a̱tsuma̱ o uꞌwa wa ali a̱tsuma̱ a aasula a na u da̱na̱i, reve malingata ma̱ A̱sula̱† me isawan elime a̱ Bituru. Reve u lapa yi e eeɓele tsa̱ra̱ u jisan yi. Reve u damma, “Jika̱! Vu ꞌyon!” Reve akaniꞌi o oco diga e ekere a̱ Bituru. ");
INSERT INTO tswNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Reve malingataꞌa u damma, “Oto itana ya̱ wu na atan a̱ wu.” Reve Bituru yuwan ili i na u damma niyi u yuwan. Reve malingataꞌa u damma, “Ka̱nda̱ꞌwa̱ umuna wa̱ wu reve vu toni mu.” ");
INSERT INTO tswNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Reve Bituru toni malingata ma̱ A̱sula̱, reve a lyawa uꞌwa wa aliꞌi. Agba Bituru reve ko ili i na yaa farasa amayun a ɗa shi. U ta dansa alavu alavu a ɗa yi. ");
INSERT INTO tswNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","A pasa a̱soja o ufaru na̱ a̱soja e ire reve a̱ ta̱wa̱ o una̱ntsu wu rumu za na ri a̱ tyo a̱ lyuci gbain. Reve u kpa̱tuꞌwa̱a̱ le na aciya̱yi, reve o uta̱a̱ lo. Reve a̱ ka̱ra̱a̱ lo o ureꞌe. Reve malingataꞌa u lyawushi niyi. ");
INSERT INTO tswNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Reve esu a̱ Bituru a̱ ta̱wa̱ o ure, ɗaɗa u revei ili i na i farai. Reve u damma, “N reve ta̱ Zagbain ɗa lyunguyi malingata ma̱ yi u ta̱wa̱ u wawa mu e ekere a̱ Hiridu na azagbain a Israꞌila a̱tsuma̱ e ili i na a̱ shi a cigai a yuwan na̱ a̱mu.” ");
INSERT INTO tswNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ana Bituru revei ne, a̱vu u ka̱ra̱ a̱ tyo o uꞌwa wa̱ Meri† za na a̱yi ɗa mma va Yahaya.† Yahaya waru a̱ tsu ɗe yi ta̱ Marku. A̱za̱ e Itoni na̱ a̱bunda̱ o ɓoloto ta̱ uba̱ta̱ꞌa̱ a yuwusan avasa. ");
INSERT INTO tswNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Reve wu gugula una̱ntsu wu uꞌwaꞌa, reve aagbashi o usheli za na ri na aala Roda ta̱wa̱ tsa̱ra̱ u usu yi. ");
INSERT INTO tswNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","U reve ta̱ a na Bituru ɗa adama a na u revei uɗyo wa̱ yi. U yuwan ta̱ na̱ ma̱za̱nga̱ ma̱ a̱bunda̱, hali u kuɗa̱ a̱ kpa̱tuꞌwa̱ una̱ntsuꞌu. Reve u suma a̱ ꞌya̱wa̱ uba̱ta̱ u na ama a̱ ri, reve u saala, “Bituru ɗa ri ɗe o una̱ntsu!” ");
INSERT INTO tswNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Reve a damma yi, “Vu jaara ta̱!” Reve gba u lyuwa elime adansa, “Bituru ɗa! Bituru ɗa!” Reve a damma, “U to oꞌwo malingata ma̱ yi ma ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Reve gba Bituru lyuwa elime na̱ wugulu wu una̱ntsu, she na a̱ tyo o ukosu a̱ kpa̱tuꞌwa̱a̱ niyi. Ana e ene niyi a shiwan ta̱ na̱ ma̱za̱nga̱. ");
INSERT INTO tswNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Reve Bituru yuwaan le ukere a̱ rungwa̱. Reve u damma ununa Zagbain uta̱a̱ niyi o uꞌwa wa ali. Reve u damma, “Dammai Yakubu na akapi a̱ a̱za̱ e Itoni ili i na i farai.” ");
INSERT INTO tswNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ana usana u tawai reve a̱soja o uꞌwa wa aliꞌi, aza a na a̱ da̱na̱i a̱ ka̱lyuwusa̱ Bituruꞌu o oꞌwo udamu lon. A̱vu a̱ ka̱ra̱ a majiyan ko nye i ɗa i cina niyi. ");
INSERT INTO tswNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Reve Hiridu zuwa a̱soja a̱ yi a̱ bunga̱ Bituru, agba a̱ tsura̱ e ene yi shi. Reve u yuwaan le yeci ya̱ a̱bunda̱, agba a gura usu yi mejege shi, ɗaɗa u zuwai o una nle. Ana Hiridu yuwain ne, reve u lyawa iɗa ya Yahuda, a̱vu u ka̱ra̱ a̱ tyo Kasariya. A̱vu u da̱nu ɗe rana meketeci. ");
INSERT INTO tswNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hiridu da̱na̱ ta̱ na̱ a̱tsumola̱ngu na ama a Sida na̱ Taya. Reve amaꞌa a zagwa ama a̱ lyungu le tsa̱ra̱ a pati ankuri. A yuwan ta̱ ne adama a na ilyuciꞌi i ciga ta̱ ilyalya i na yoo utusa̱ e iɗa ya̱ yi. A yuwan ta̱ tsuꞌutsa̱ na̱ Bilasata, za na da̱na̱i toni va̱ Hiridu. Reve u foɓo tsa̱ra̱ Hiridu usu le. ");
INSERT INTO tswNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ana urana u rawai, reve Hiridu oto a̱tugu o tsugono tsa̱ yi, reve u da̱nu o ootogu o tsugono, reve u yuwan adanshi ne ele. ");
INSERT INTO tswNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ana oɓolo a amaꞌa a uwwa niyi, reve a̱ ꞌya̱sa̱n uɗyo, “Uɗyo u ma̱sula̱ ma̱ tsu mo ro ma ɗa, uɗyo u vuma u ɗa shi!” ");
INSERT INTO tswNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Amaꞌa a̱tsuma̱ a yisaali, reve malingata ma̱ A̱sula̱ ma faba Hiridu a̱ cipa̱ e iɗa. A yuwan ta̱ ne adama a na u tarai tsugbain tsa̱ A̱sula̱. O ukosu azun a̱tsuma̱ a̱ yi a ɗa a tamusai lipu va̱ yi, hali u kuwa̱. ");
INSERT INTO tswNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Adanshi a̱ A̱sula̱ a lyuwa ta̱ elime na̱ mabaza. ");
INSERT INTO tswNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ana Banaba na̱ Shawulu o kotoi ulinga u na a̱ lyungu nle, reve a lyawa Urishelima a̱ ka̱mba̱ Antakiya oɓolo na̱ Yahaya Marku. ");
INSERT INTO tswNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","A̱a̱ꞌisa̱ a̱ a̱za̱ e Itoni† a Antakiya a̱ da̱na̱ ta̱ na ama̱sula̱ na̱ munlu lon. Ele ɗa nan Banaba, na̱ Saminu za na e ɗesuyi “Vuma Lima̱,” na̱ Lusiya za lyuci va Kurani, na̱ Manayan za na kungwai mantsa ma̱ ta̱ na̱ Mogono Hiridu Antiba na̱ Shawulu. ");
INSERT INTO tswNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ele pe a yuwusaan A̱sulazuva a̱ga̱nda̱ a̱tsuma̱ a akuli, a̱vu Ruhu va Akiza damma le, “Ɗangula numu Banaba na̱ Shawulu tsa̱ra̱ a yuwan ulinga u na n ɗangula nle a yuwan.” ");
INSERT INTO tswNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ana a yuwain akuli na avasa a̱bunda̱, a̱vu ama a̱ kuruwa̱ le ekere a zuwaa le abaꞌun o ulinga wa̱ A̱sula̱ a na aa yuwan, a̱vu a lyawa le a̱ ka̱ra̱. ");
INSERT INTO tswNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ana Ruhu va Akiza lyunguyi Banaba na̱ Shawulu, a̱ ka̱ra̱ ta̱ a̱ tyo a̱ lyuci va Salusiya. Ele pe a̱vu a lyawa Salusiya a uwa a wantsun a̱ tyo e iɗa i memere ma̱ mini ma̱ Kuburu. ");
INSERT INTO tswNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Yahaya Marku fo u da̱na̱ ta̱ oɓolo ne ele tsa̱ra̱ u kambusa le. Ele pe a̱tsuma̱ e iɗa ya̱ Kuburu reve a̱ ka̱ra̱ a̱ tyo a̱ lyuci va Salami a̱vu a uwa a̱ a̱ꞌisa̱ a aza a Israꞌila, reve a uwa alajiya a adanshi a̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ele pe a̱tsuma̱ e iɗa ya̱ Kuburu, a̱vu a̱ ka̱nda̱ruwa̱ ilyuci i na i ri lo zuzu suru. A rawa ta̱ lyuci na a̱ tsu ɗe Pafo, lo ɗa a cinai za va Israꞌila ro na a̱ tsu ɗe Ba-Yesu. Waru vumava̱sula̱ va amayun ɗa shi, boci ɗa shi. ");
INSERT INTO tswNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Vuma nda a̱yi ɗa u tsu walasa na̱ gwamna vi iɗaꞌa, za na a̱ tsu ɗe Sarajiya Bulu. Gwamnaꞌa vuma ɗa na ri nu ugbozu waru u ta̱ nu urevu wi ili lon. A̱vu u ɗe Banaba na̱ Shawulu a̱ ta̱wa̱. U yuwan ta̱ ne adama a na u cigai wu uwwa adanshi a̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Agba boci Alima u da̱na̱ ta̱ a̱ tsushuꞌun ne ele, u yuwan ta̱ a̱tyo a na waa yuwan u putsaa gwamna u usu alajiya e le. (Na̱ Tsuheleni Alima ta̱ nu urevu wa aala Ba-Yesu na̱ Tsuyahuda.†) U yuwan ta̱ a̱tyo a na waa putsaa gwamnaꞌa a na waa ca A̱sulazuva okolo. ");
INSERT INTO tswNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Shawulu, vuma na ama na̱ a̱bunda̱ a̱ tsu ɗe Bulu, u tu ushitowun na̱ Ruhu va Akiza. A̱vu u varaa Alima esu mejege. ");
INSERT INTO tswNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","A̱vu u damma, “A̱vu mawun ma̱ Mekerenkesu! A mantsa suru vu tsu damma mejege shi, waru vu ta̱ pususa̱n ama ugbozu. A̱vu rala ɗa e ekere e ili i na i ri ulobonu. Urana u ne vaa lyawa tsushuꞌun na adanshi a̱ A̱sulazuva? ");
INSERT INTO tswNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","A̱sulazuva a ta ca wu a̱tsuma̱lima̱, vu to oꞌwo irumba̱ hali mantsa mo ro.” Babu usa̱n, a̱vu esu a̱ yi a yuwushin dalimbaa, a̱vu irumbu yi pala yi, reve u da̱na̱ e izami yi za na a̱a̱ guza̱ yi ukere. ");
INSERT INTO tswNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ana gwamnaꞌa enei ili i na i farai, reve u ca A̱sulazuva okolo. Reve waru u uwa asalama lon adama o uritosu wa̱ A̱sulazuva u na wu uwwai. ");
INSERT INTO tswNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","A̱vu Bulu na aza a na a̱ da̱na̱i oɓolo na̱ a̱yi a lyawa Pafo, a̱vu a uwa a wantsun a̱ ka̱ra̱ a̱ tyo e iɗa ya Bamafiliya. A̱vu a rawa e isawan a̱ lyuci va Pega. Ele pe Pega a̱vu Yahaya Marku lyawa le, a̱vu u ka̱ra̱ a̱ ka̱mba̱ Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Banaba na̱ Bulu gba a̱vu a lyawa Pega a̱ ka̱ra̱ a̱ tyo a̱ lyuci na a̱ tsu ɗe Antakiya va Bisidiya. A̱vu a̱ ka̱ra̱ a̱ ꞌya̱wa̱ a̱ a̱a̱ꞌisa̱† o urana wa Ashibi, tsa̱ra̱ a yuwan a̱ga̱nda̱. ");
INSERT INTO tswNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ana o kotoi ɗesununa̱ a̱tsuma̱ a atagada a Musa na a ama̱sula̱, reve aza a na a̱ da̱na̱i azagbain a̱ a̱a̱ꞌisa̱ꞌa̱ a̱ lyungu vuma ta̱ we ece le, “A̱za̱ a̱ tsu, ko i ta̱ ni ili i ro i na ya̱a̱ da̱shi tsu okolo ugbamu, ta̱wa̱i i damma tsu!” ");
INSERT INTO tswNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","A̱vu Bulu ꞌyon mishin reve u ꞌya̱sa̱n ekere zuva adama amaꞌa a̱ rungwa̱, a̱vu u teme adanshi. A̱vu u damma, “Ama a Israꞌila† na Atakpaci a na a yuwusaan A̱sula̱ a̱ga̱nda̱, poloi atsuvu a̱ ɗu yu uwwa. ");
INSERT INTO tswNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","A̱sula̱ a Israꞌila a ɗangula ta̱ nkaya n tsu, waru u lyawa ta̱ ama a̱ tsu o oꞌwo a̱za̱ o utsuru e iɗa ya Masar. Nu ucira wa̱ yi u ɗa waru wu uta̱a̱ nle a̱tsuma̱ e iɗaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Waru u yuwan ta̱ ankuri ne ele nu ulambu wu ugbozu u le a̱tsuma̱ o ogozo aꞌwan amunga. ");
INSERT INTO tswNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","A̱vu u usa iɗa i cindere i Kaꞌana,† a̱vu u ca aza a Israꞌila iɗaꞌa agadu. ");
INSERT INTO tswNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ili i nda suru i fara ta̱ a̱tsuma̱ a aꞌwan ukpakuna̱shi na̱ kupoton (450). “Ana mantsa ma ndolo mo kotoi, a̱vu a̱za̱ o ugeꞌetosu a yuwan tsugono hali a mantsa ma Samaꞌila† vumava̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Amma ama a pati ta̱ a ca le mogono. A̱vu A̱sula̱ a ca le Shawulu wo oꞌwo mogono me le hali aꞌwan amunga. Shawulu mawun ma Kishu ma ɗa o ugundo wa Banyami.† ");
INSERT INTO tswNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","A̱vu A̱sula̱ a̱ cipa̱to yi o ootogu o tsugonoꞌo, a̱vu u zuwa Da̱wuda o una̱ wa̱ yi. A̱vu A̱sula̱ a yuwan adanshi adama a̱ Da̱wuda, adansa, ‘Da̱wuda za na ri mawun ma̱ Yese,† Da̱wuda nda vuma ɗa na a ɗangulai u zuwa okolo a̱ va̱ u yuwan ma̱za̱nga̱. U ta yuwan ili suru i na n ciga niyi u yuwan.’ ");
INSERT INTO tswNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“A̱sula̱ a yuwan ta̱ nzuwulai a na vuma ta̱ o ugundo wa̱ yi ta̱ ta̱wa̱ u wawa aza a Israꞌila, vumaꞌa gba a̱yi ɗa Yesu. ");
INSERT INTO tswNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Amma kafu Yesu ta̱wa̱, Yahaya da̱na̱ ta̱ a dansaa vuma suru a̱tsuma̱ a Israꞌila u ka̱mba̱ uba̱ta̱ wa̱ A̱sula̱, a̱vu a̱ rumbu yi a̱ mini. ");
INSERT INTO tswNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yahaya o kotuso ulinga wa̱ yi, a̱vu u yuwan yeci, ‘I ta a majiyan a̱mu ɗa Zamawawaꞌa? Oꞌo! Amma u ta̱ lo a̱ ta̱wa̱ babu ujimu. Waru a̱mu n rawa m ba̱ɗa̱ vunu va atan va̱ yi shi.’ ");
INSERT INTO tswNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Uwwai gogo, a̱ɗu ama o ugundo wa Ibrahim! Poloi atsuvu a̱ ɗu yu uwwa, hali na Atakpaci a na a̱ ta̱wa̱i a yuwaan A̱sula̱ a̱ga̱nda̱! Uwwai adanshi a nda ununa yaa yuwan i tsura̱ iwawi, za va koyan ɗa. ");
INSERT INTO tswNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ama a na a̱ ri na̱ nden a̱tsuma̱ a̱ Urishelima a tsu uwwa ta̱ adanshi a ama̱sula̱ urana wa Ashibi suru a na a̱ tsu ɗesununa̱ a atsuvu e le. Agba suru na̱ ne, a tara Yesu ɗa vuma na ama̱sula̱ a yuwain adanshi a̱ yi shi. Ele na azagbain e le o shiton ta̱ udammu wa ama̱sula̱ ana o una niyi. ");
INSERT INTO tswNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","A̱ tsura̱ ili i na i zuwai o una niyi shi, amma suru na̱ ne, a pati ta̱ Bilatu† u zuwa a̱soja a̱ yi o una yi. ");
INSERT INTO tswNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Ana o kotoi mayan me ili suru i na a ɗanai adama a̱ yi, a̱vu a̱ cipa̱to yi a akpata† a na a vara niyi, reve a̱ ciɗo yi a aason a aatali. ");
INSERT INTO tswNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Amma A̱sula̱ a̱ ꞌya̱sa̱n yi ta̱ a̱tsuma̱ a̱ a̱kwa̱kwa̱. ");
INSERT INTO tswNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Rana na̱ a̱bunda̱ u roco ta̱ aciya̱yi uba̱ta̱ wa aza a na a̱ da̱na̱i Ga̱lili na̱ a̱yi a̱vu a̱ ka̱ra̱ a̱ tyo Urishelima waru na̱ a̱yi. Ama a nda ele ɗa o oꞌwoi esu a̱ yi a̱ tyo e ekere a ama a Israꞌila. ");
INSERT INTO tswNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Gogo a̱mu na̱ Banaba tsu ta̱ pa na̱ a̱ɗu, adama tsu ta̱wa̱a̱ ɗu na Alabari a Saꞌani a nda. Nzuwulai ma̱ A̱sula̱ a̱ tyo e ekere a nkaya n tsu wo oꞌwo ta̱ amayun a mantsa ma̱ tsu. ");
INSERT INTO tswNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","A̱sula̱ a̱ ꞌya̱sa̱n ta̱ Yesu. A̱yi nda a̱yi ɗa ili i na Aatagada e Ica a̱ a̱a̱ɗiva̱ e ire aa yuwusan adanshi ana u dammai, ‘A̱vu Mawun ma̱ va̱ ma ɗa. Anaꞌan mo oꞌwo ta̱ Dada va̱ wu.’ ");
INSERT INTO tswNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“A̱sula̱ a̱ ꞌya̱sa̱n ta̱ Yesu a̱tsuma̱ a̱ a̱kwa̱kwa̱, waru mantsa mo lo na waa lyawa lipu va̱ yi shama shi. U tu ununa A̱sula̱ a dammai a Aatagada a Ishaya vumava̱sula̱, ‘N ta zuwaa ɗu abaꞌun a akiza a na n yuwain nzuwulai na̱ Da̱wuda.’ ");
INSERT INTO tswNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Aatagada e Ica† a̱ a̱a̱ɗiva̱ o ro a ca ta̱ urevu u saꞌani, a na, ‘Vaa lyawa Vuma va̱ wu va akiza u shama a aason shi.’ ");
INSERT INTO tswNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Gogo udammu u nda a̱ tyo ya̱ Da̱wuda ɗa shi, adama a na Da̱wuda yuwaan ta̱ ama a mantsa ma̱ yi a̱ga̱nda̱ ununa A̱sula̱ a cigai. U kuwa̱ ta̱, a̱vu a̱ ciɗo yi oɓolo na̱ nkaya ma̱ yi, waru lipu va̱ yi shama ta̱. ");
INSERT INTO tswNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Gogo tsunda udammu u nda u ta̱ a̱ tyo e ekere a za ro, Yesu, za na A̱sula̱ a̱ ꞌya̱sa̱in a̱tsuma̱ a̱ a̱kwa̱kwa̱, waru lipu va̱ yi shama shi. ");
INSERT INTO tswNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“A̱za̱ a̱ va̱, adanshiꞌi a̱yi ɗa, Yesu ɗa aa gura yuwaan ɗu gafura vu nusu ɗu! ");
INSERT INTO tswNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Wila̱ wa Musa waa gura wawa ɗu a̱tsuma̱ a̱ nusu ɗu shi. Amma za na cayi okolo uba̱ta̱ wa̱ Yesu biti, a tara yi waru za vu unusu e ekere a̱ A̱sula̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","“I yuwan ugbozu! She i lyawa adanshi a ama̱sula̱ a shiwan a aci a̱ ɗu wan. Adanshi a̱ A̱sula̱ a damma ta̱, ");
INSERT INTO tswNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ka̱lyuwa̱i a̱ɗu aza a adanshi a vama, i ta yuwan asalama na̱ ye ene ili i na A̱sula̱ aa yuwan, reve i kuwa̱! Adama a na maa yuwan ili i ro a mantsa ma̱ ɗu, ili i ro i na i cayi okolo shi, waru ko na̱ za ro dammisa ɗu adama a̱ yi.’ ” ");
INSERT INTO tswNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Bulu na̱ Banaba azama a lyawa uba̱ta̱ e iɓoloꞌo, reve amaꞌa a pati le a̱ da̱shi yuwan adanshi e ili i nda uba̱ta̱ e iɓoloꞌo urana wa Ashibi u na wa̱a̱ ta̱wa̱. ");
INSERT INTO tswNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ana o kotoi mayan ma̱ a̱ga̱nda̱ꞌa̱, a̱vu aza a Israꞌila na Atakpaci na̱ a̱bunda̱ a na a yuwayin A̱sula̱ a̱ga̱nda̱ a̱ kuru le. A̱vu Bulu na̱ Banaba a pati le a ca okolo e le e ekere a̱ A̱sula̱, za na yuwaan nle isaꞌani. ");
INSERT INTO tswNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ana ajuma a̱ ka̱nda̱ruwa̱i, ɗaɗa ama suru o uta̱i tsa̱ra̱ a uwwa adanshi a̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ana azagbain a Israꞌila e enei oɓolo a amaꞌa, reve a yuwan tsushuꞌun lon, reve a uwa mawasan e ili i na Bulu dammai a̱vu a̱ ka̱ra̱ a̱ durusa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","A̱vu Bulu na̱ Banaba a yuwan adanshi no okolo ugbamu reve a damma, “Wo oꞌwo ta̱ na̱ tsu ꞌyuwan tsu ciga Alabari a Saꞌani a̱ A̱sula̱ a nda tsu fara ca ɗu a̱yi, a̱ɗu na yo oꞌwoi aza a Israꞌila. Amma i ꞌyuwan ta̱ ikaka i nda, a̱yi nda u roco ta̱ yi ntsaa i tsura̱ wuma u babu ukotu shi. Adama o ndolo tsu ta̱ ka̱mba̱ uba̱ta̱ wa Atakpaci. ");
INSERT INTO tswNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","“A̱tsuma̱ a Aatagada a Ishaya, A̱sulazuva a zuwa tsu ta̱ tsu yuwan ulinga u nda, adansa, ‘N zuwa ɗu ta̱ pa nda yoo oꞌwo ekan ya Atakpaci. I tara ucira wi iwawi ya̱ A̱sula̱ a̱ tyo uba̱ta̱ wa ama, uba̱ta̱ suru o uvaɗi.’ ” ");
INSERT INTO tswNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ana Atakpaci† a uwwai ili i nda, a yuwan ta̱ ma̱za̱nga̱ lon, a̱vu o godyoo A̱sulazuva adama a adanshi a̱ yiꞌi. Reve ama a na A̱sula̱ a ɗangulai a̱ tsura̱ wuma u babu ukotu o oꞌwo a̱za̱ e Itoni. ");
INSERT INTO tswNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","A̱vu adanshi a̱ A̱sulazuva a rawa uba̱ta̱ suru e iɗaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Amma azagbain a Israꞌila gba a̱ ka̱ra̱ a̱ ꞌya̱wusa̱ uba̱ta̱ wa azagbain a̱ lyuci nu uba̱ta̱ wa̱ a̱ma̱ci a̱ a̱ɓula̱ a na a tsu damma a̱vu a uwwa le. Reve a zuwa le a tawa ugbozu u le e ekere a̱ Bulu na̱ Banaba, reve a ca le a̱tsuma̱lima̱, hali o lo le a̱tsuma̱ e iɗaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","A̱vu Bulu na̱ Banaba a̱ ka̱ka̱la̱ ma̱buta̱ ma ana me le, tsa̱ra̱ wo oꞌwo iroci a̱ tyo e ekere e le. A̱vu a̱ ka̱ra̱ a̱ tyo a̱ lyuci va Ikoniya. ");
INSERT INTO tswNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","A̱tsuma̱ a Ikoniya a̱za̱ e Itoni a̱ da̱na̱ ta̱ na̱ ma̱za̱nga̱ lon, waru a̱ da̱na̱ ta̱ tapu na̱ Ruhu va Akiza. ");
INSERT INTO tswNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ana a rawai Ikoniya, reve Bulu na̱ Banaba a uwa a̱ a̱a̱ꞌisa̱ a aza a Israꞌila ununa a tsu yuwusan. A̱vu a yuwan alajiya, hali ama a Israꞌila na Atakpaci na̱ a̱bunda̱ a ca okolo. ");
INSERT INTO tswNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ama aza a Israꞌila na a ꞌyuwain a ca okolo, reve a̱ ꞌya̱sa̱n ugbozu wa Atakpaci o ro. A̱vu Atakpaciꞌi a̱ la̱nga̱la̱i na̱ a̱za̱ e Itoni. ");
INSERT INTO tswNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Suru na̱ ne gba Bulu na̱ Banaba a̱ da̱nu ta̱ pe hali rana re a yuwusan alajiya e isaꞌani† yi Zagbain nu ucira. Zagbain gba roco ta̱ ulinga u le a alanga e eteshe ana u ca nle ucira u na aa yuwan ulinga wa asalama. ");
INSERT INTO tswNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ama a Ikoniya gba majiyan me le me neꞌeshenlei ta̱. Ozo o ro o woꞌo ucina̱ wa aza a Israꞌila, ozo o ro gba shi o woꞌo ucina̱ wa ajiya. ");
INSERT INTO tswNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","A̱vu Atakpaci o ro na aza a Israꞌila o ro oɓolo na azagbain e le o ɓolo aciyele adama a zuwa Bulu na̱ Banaba a addama, tsa̱ra̱ a vara le na atali. ");
INSERT INTO tswNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Amma ana ajiya e revei ili i na yaa farasa, a̱vu a̱ ka̱ra̱ a̱ tyo e iɗa ye elentsu a aza a Likiya, a̱ lyuci va Lisitira na̱ Daraba ni ilyuci i na i ri uka̱nda̱ruwu ne ele. ");
INSERT INTO tswNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ɗe ɗa a lyuwai elime na alajiya a Alabari a Saꞌani. ");
INSERT INTO tswNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ele pe a̱tsuma̱ a Lisitira, a̱vu Bulu na̱ Banaba a cina a̱a̱kutsuma̱. Ne ɗa a matsan niyi ukutsumu, koto u rito dasu shi, ko keꞌen. ");
INSERT INTO tswNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Wu uwwusa ta̱ alajiya a̱ Bulu. Reve Bulu ka̱lyuwa̱ yi, ana we enei vumaꞌa u ta̱ nu ucawu wo okolo u na waa gura ka̱mba̱to yi gbaga, ");
INSERT INTO tswNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","a̱vu u ꞌya̱sa̱n uɗyo wa̱ yi zuva nu ucira, “ꞌYon vi isawan mishin!” Reve vumaꞌa gba u ꞌyoshin mishin reve u fara mmalu. ");
INSERT INTO tswNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ana oɓolo a amaꞌa e enei ili i na Bulu yuwain, reve a̱ ꞌya̱sa̱n uɗyo u le a mantsa ma̱ ta̱ adansa ne elentsu a Tsulikiya, “Amayun a ɗa musula̱ n cipa̱a̱ tsu ta̱ anaꞌan na̱ lipu va ama!” ");
INSERT INTO tswNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","A̱vu amaꞌa a ca Banaba aala Zafasa, reve e ɗe Bulu Hamisa, adama a na a̱yi ɗa u da̱na̱i za va adanshi. ");
INSERT INTO tswNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","A̱a̱ꞌisa̱ a Zafasa a̱ da̱na̱ ta̱ o ugyuru. A̱vu ganu na ama a̱ yi a̱ ta̱wa̱ no ogono e inan na̱ yipa̱lu uka̱nda̱ruwu o uꞌuwata u lyuciꞌi adama a yuwaan ajiyaꞌa kucci. ");
INSERT INTO tswNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Amma ana Bulu na̱ Banaba a uwwai ili i na yaa farasa, reve a kakara itana i le adama a̱ a̱tsumola̱ngu. A̱vu a suma na̱ yisaali o uta̱ a̱tsuma̱ a amaꞌa, adansa, ");
INSERT INTO tswNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“A̱za̱ a̱ va̱, nye i zuwai yaa yuwusan ili i nda? A̱tsu ama a ɗa tsu ri tsa̱ ɗu. Alabari o uyoꞌo a ɗa tsu ta̱wa̱a̱ nɗu, adama i vadala i lyawa mayan me ili i babu ulobonu i ka̱mba̱ uba̱ta̱ wa̱ A̱sula̱ a wuma. A̱yi ɗa za na yuwain zuva ni iɗa, na̱ mala, ni ili i na i ri pe biti. ");
INSERT INTO tswNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","A mantsa mo ufaru, u lyawa ta̱ ama a yuwan ili i na a cigai a yuwan. ");
INSERT INTO tswNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Suru na̱ ne u tsu roco ta̱ aciya̱yi uba̱ta̱ e ili i saꞌani i na u yuwain. A̱sula̱ a̱ tsu lyungu ta̱ ni iroꞌi diga zuva, reve u zuwa itana yu una i ɗu i kungwa. U tsu ca ɗu ta̱ ilyalya nu uyoꞌo wo okolo.” ");
INSERT INTO tswNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ko na Bulu na̱ Banaba a dammai ili i nda suru, u da̱na̱ ta̱ usa̱n a na aa gura putsaa amaꞌa a na aa yuwaan le kucci. ");
INSERT INTO tswNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","A̱vu aza a Israꞌila o ro diga Antakiya na̱ Ikoniya a̱ ta̱wa̱ a vadala ugbozu wa amaꞌa, reve a uwa agaba na̱ Bulu. A̱vu a vara yi, reve o rono yi o uta̱ a̱ lyuciꞌi, a majiyan me le a na u kuwa̱ ta̱. ");
INSERT INTO tswNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Amma ana a̱za̱ e Itoni a̱ ka̱nda̱ruwa̱ niyi reve u ꞌyon, u ka̱ra̱ a̱ tyo a̱tsuma̱ a̱ lyuci. Ana usana u tawai, a̱vu u ka̱ra̱ a̱ tyo Daraba oɓolo na̱ Banaba. ");
INSERT INTO tswNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Bulu na̱ Banaba a yuwan ta̱ alajiya a Alabari a Saꞌani a Daraba, a̱vu gba ama na̱ a̱bunda̱ a ca okolo e le uba̱ta̱ a Zagbain. A̱vu a̱ ka̱ra̱ a̱ ka̱mba̱ Lisitira na̱ Ikoniya na̱ Antakiya va Bisidiya. ");
INSERT INTO tswNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pe ɗa a̱ da̱shishiyi a̱za̱ e Itoni okolo ugbamu, a dansaa le e isawan mishin o ucawu wo okolo e le. Reve a damma, “Na̱ tsu ꞌyuwan tsu ciga tsu sowo a̱tsuma̱lima̱ lon, kafu tsu uwa o tsugono tsa̱ A̱sula̱.”† ");
INSERT INTO tswNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","A̱vu Bulu na̱ Banaba a ɗangula azagbain† a̱ a̱ꞌisa̱ a̱ a̱za̱ e Itoni biti, reve a yuwusan akuli, a̱vu a vasasaa le, reve a ca A̱sula̱ ele. ");
INSERT INTO tswNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Reve Bulu na̱ Banaba a̱ ka̱ra̱ a̱ ka̱mba̱ Bisidiya a̱ tyo Bamafiliya. ");
INSERT INTO tswNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","A̱vu a yuwusan alajiya a Pega, reve a lyuwa elime a̱ ka̱ra̱ a̱ tyo Ataliya. ");
INSERT INTO tswNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Lo ɗa a uwai a wantsun a̱ tyo Antakiya va Suriya, uba̱ta̱ u na e temei mmalu n le. Ɗe ɗa a̱za̱ e Itoni a zuwaa nle una̱ u saꞌani, waru ɗe ɗa a zuwa nle o ukere wa̱ A̱sula̱, reve a̱ lyungu le a yuwan ulinga u na gba o kotoi. ");
INSERT INTO tswNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ana a rawai Antakiya reve e ɗe a̱za̱ e Itoni suru uba̱ta̱ u ta̱. A̱vu a damma amaꞌa ili i na A̱sula̱ a kamba nle nu ununa u yuwain hali Atakpaci a cayi okolo. ");
INSERT INTO tswNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","A̱vu a̱ da̱nu pe na̱ a̱za̱ e Itoni hali rana a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Reve waru ama o ro o uta̱ ɗe Yahuda, a̱vu a̱ ꞌya̱wa̱ Antakiya va Suriya, tsa̱ra̱ o roco a̱za̱ e Itoni, a dansaa le, “Na a paɗa ɗu uryumbu ununa Wila̱ wa Musa u dammai shi, ya̱a̱ tsura̱ iwawi shi.” ");
INSERT INTO tswNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Adama a adanshiꞌi Bulu na̱ Banaba o sowo ta̱ a yuwusan mawasan lon na amaꞌa. Ɗaɗa a zuwai Bulu na̱ Banaba na ama o ro waru a̱ ꞌya̱wa̱ Urishelima uba̱ta̱ wa ajiya na azagbain adama a adanshiꞌi. ");
INSERT INTO tswNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ana a̱za̱ e Itoni e shewun nle, ana a̱a̱ ka̱mba̱ Urishelima, ɗaɗa a ɓatsai e iɗa ya Finisiya na̱ Samariya. Reve a̱ ka̱lyuwusa̱ a̱za̱ e Itoni a dansaa le adama a na Atakpaci fo a cayi okolo e le. Reve a̱za̱ e Itoni suru a yuwan ma̱za̱nga̱ lon. ");
INSERT INTO tswNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ana a rawai Urishelima, reve a̱za̱ e Itoni suru oɓolo na azagbain na ajiya a raba Bulu na̱ Banaba. Reve a damma le ulinga u na A̱sula̱ a yuwain e ekere e le. ");
INSERT INTO tswNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ɗaɗa aza a na a̱ shi Afarishi kafu a ca okolo e le, a̱ ꞌyoyin reve a damma, “Na a ciga a ꞌyuwan a paɗa le uryumbu, reve waru a zuwa le a̱ kuru Wila̱ wa Musa.” ");
INSERT INTO tswNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Reve ajiya† na azagbain a̱ a̱za̱ e Itoni o ɓoloto adama e petelyuwe adanshiꞌi. ");
INSERT INTO tswNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ana a jimai a̱ a̱sa̱la̱ a adanshiꞌi, reve Bituru ꞌyon a̱vu u damma le, “A̱za̱ a̱ va̱, i reve ta̱ ɗe ufaru wi iliꞌi, A̱sula̱ a yuwan ta̱ aɗangulu a̱tsuma̱ a̱ ɗu, a na o una̱ u va̱ u ɗa Atakpaci aa uwwa adanshi a Alabari a Saꞌani,† reve a ca okolo e le. ");
INSERT INTO tswNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","A̱sula̱ gba za na ri nu urevu wo okolo a̱ koyan ɗa, u yuwaan tsu ta̱ iroci a na u cayi Atakpaci Ruhu va Akiza ununa u ca ntsu. ");
INSERT INTO tswNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Agba u roco aɗangulu e ekere a̱ tsu ne ele shi, ana wu za̱za̱ꞌwa̱i okolo e le adama o ucawu wo okolo e le. ");
INSERT INTO tswNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Adama o ndolo, adama a̱ nye ya̱a̱ lyungusa̱ A̱sula̱ yaa zuwusaa agbashi a nda itana i na a̱tsu na̱ nkaya n tsu suru tsu kuɗa̱i a tanu? ");
INSERT INTO tswNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","She tsu yuwain ne wan, tsu reve ta̱ adama e isaꞌani ya̱ Yesu Zagbain i ɗa tsu tsura̱i iwawi† ununa ele fo a̱ tsura̱i.” ");
INSERT INTO tswNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Reve oɓolo a amaꞌa suru e isawan kuci kuci, reve o poloo Banaba na̱ Bulu atsuvu a mantsa ma na aa casu alabari a linga va asalama ni iroci i na A̱sula̱ a yuwain uba̱ta̱ wa Atakpaci o ukere u le. ");
INSERT INTO tswNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ana o kotoi adanshi, ɗaɗa Yakubu usuyi, reve u damma, “A̱ɗu a̱za̱ a̱ va̱ poloo numu atsuvu. ");
INSERT INTO tswNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Bituru ɗa nda cayi aalabari ununa A̱sula̱ a fara ka̱lyuwa̱i Atakpaci, adama u ɗangwa ama o ro a̱tsuma̱ e le oo oꞌwo ama a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Adanshi a ndaꞌa gba wo oꞌwo ta̱ una̱ta̱ na adanshi a ama̱sula̱, ununa u ri uɗanu a na, ");
INSERT INTO tswNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘A̱mu A̱sulazuva, nna̱ n ka̱mbisa̱, n ta suwisa uꞌwa wa̱ Da̱wuda u na u riya̱i. N ꞌya̱sisa̱n asaꞌa a̱ yi mi isawaton yi. ");
INSERT INTO tswNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Adama akapi a ama a zami A̱sulazuva, oɓolo na Atakpaci na aza a na n ɗeyi a̱ tyo ya̱ꞌa̱ va̱. Ne ɗa A̱sulazuva a dammai. ");
INSERT INTO tswNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","A̱yi na u rocoi ili i nda suru diga ɗe a mantsa mo ufaru.’ ");
INSERT INTO tswNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Adama o ndolo a̱mu a̱ yindi i va̱, she tsu zuwayi Atakpaci a na aa vadalasa uba̱ta̱ wa̱ A̱sula̱ ili yu ume wan. ");
INSERT INTO tswNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Amma tsu ɗanaa nle a tawa ekere e le e ili i na a cayi a̱ma̱li adama a na o oꞌwo ta̱ ili yi idaba, waru a suma tsipere. She a tama a̱kutsu a mpasa wan. Waru she a tama nama vi inama i na a̱ punda̱ra̱i wan. ");
INSERT INTO tswNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Adama a na ɗe nu ujimu a̱ lyuci biti a yuwusan ta̱ ɗe alajiya na atagada a Musa, waru e ɗesu le ta̱ nu una̱ a̱tsuma̱ a̱ a̱ꞌisa̱ Ashibi biti.” ");
INSERT INTO tswNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Reve ajiya, na̱ a̱za̱ e Itoni, na azagbain e le suru e ene u lobono ta̱ a ɗangula ama o ro a̱tsuma̱ e le a̱ lyungu le Antakiya va Suriya oɓolo na̱ Bulu na̱ Banaba. Ɗaɗa a̱ lyunguyi Yahuza (za na a̱ tsu ɗe Basaba) na̱ Sila. Ele ra azagbain a ɗa a̱tsuma̱ a̱ a̱za̱ e Itoni. ");
INSERT INTO tswNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Mepepelime ma na a̱ lyunguwa̱ nle na̱ a̱yi, a̱yi ɗa: “A̱ tyo uba̱ta̱ wa Atakpaci a̱za̱ e Itoni a̱tsuma̱ a Antakiya ni iɗa ya Suriya na̱ Kilikiya. “Uba̱ta̱ wa ajiya na azagbain, a̱tsu ɗa a̱za̱ a̱ ɗu a̱ a̱za̱ e Itoni. “Tsu ta̱ ca̱sa̱sa̱ ɗu. ");
INSERT INTO tswNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Tsu uwwa ta̱ a na ama o ro a̱tsuma̱ a̱ tsu a ta damatosun ugbozu u ɗu, agba tsu lyungu le shi. ");
INSERT INTO tswNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ɗaɗa tse enei u lobono ta̱ ana adanshi a̱ ta̱wa̱ ntsu a̱ ta̱, tsu lyunguwa̱ ɗu ama o ro oɓolo na̱ nꞌutsa̱ n tsu Banaba na̱ Bulu. ");
INSERT INTO tswNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ama a na a cayi wuma u le ko ukwa̱, adama a ala e Yesu Zagbain tsu Zamawawa. ");
INSERT INTO tswNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Adama a adanshi o ndolo a ɗa fo i zuwai tsu lyunguwa̱ nɗu na̱ Yahuza na̱ Sila adama ele fo a damma ɗu iliꞌi na aciyele. ");
INSERT INTO tswNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Adama a na Ruhu va Akiza ene ta̱ u lobono ta̱, a̱tsu fo ne ɗa tse enei, she tsu zuwaa ɗu ume wi ili i na i laꞌai ili i na yaa gura yuwan wan, suru na̱ ne: ");
INSERT INTO tswNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","I suma utamu wi ili i na a paɗayi a̱ma̱li, nu utamu wi inama oɓolo na̱ mpasa, nu utamu wi ili i na a̱ punda̱ra̱i, na̱ tsipere waru. Ni i guza̱ aciya̱ɗu, ni i yuwan le shi, i ta̱ da̱nu lafiya. “Yo oꞌwo lafiya.” ");
INSERT INTO tswNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ana a ca nle lingataꞌa, reve a̱ ka̱ra̱ a̱ tyo Antakiya, ana a rawai reve o ɓoloto a̱za̱ e Itoni, a̱vu a ca le mepepelimeꞌe. ");
INSERT INTO tswNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ana e ɗeyi mepepelimeꞌe nu una̱, reve a̱ za̱nga̱na̱ adama a na ikaka i na yaa gbamato le okolo a ɗa a̱ ri pe. ");
INSERT INTO tswNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Reve Yahuza na̱ Sila a na wo oꞌwoi ele ama̱sula̱ a ɗa, reve a ca a̱za̱ e Itoni a̱sa̱la̱ na̱ a̱bunda̱ a na aa gbama asuvu. ");
INSERT INTO tswNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ana a jimai pe reve a̱za̱ e Itoni e shewun le na abaꞌun a̱ a̱bunda̱, adama a̱ ka̱mba̱ uba̱ta̱ wa aza a na a̱ lyungu nle.  ");
INSERT INTO tswNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Sila gba u ɗangwa ta̱ wi isawan waꞌa ne ele a̱tsuma̱ a Antakiya. ");
INSERT INTO tswNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Reve Bulu na̱ Banaba gbaꞌa e isawan pe Antakiya, a̱vu ele na ama o ro aa yuwusan uritosu na alajiya a adanshi a Zagbain. ");
INSERT INTO tswNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ana a tarai mantsa, reve Bulu damma Banaba, “Tsu ka̱mba̱ tsu bura a̱za̱ e Itoni e ilyuci i na tsu yuwain alajiya a adanshi a Zagbain suru. Adama waru tse ene ununa aa lyuwusa elime.” ");
INSERT INTO tswNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Reve Banaba ciga u tara Yahaya† za na waru a̱ tsu ɗe Marku u ꞌya̱wa̱ oɓolo ne ele. ");
INSERT INTO tswNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Bulu gba we ene u lobono a tara yi shi, adama a na u kuɗa̱ ta̱ ulingaꞌa waru u lyawa le ta̱ e iɗa ya Bamafiliya. ");
INSERT INTO tswNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Reve a yuwan nwasanlai lon, hali u zuwa le a kakasa. Ɗaɗa Banaba tarai Marku, reve a uwa a wantsun a̱ tyo Kuburu. ");
INSERT INTO tswNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Reve Bulu gbaꞌa u ɗangwa Sila. Ana a̱za̱ e Itoni a yuwaan nle avasa e isaꞌani ya̱ A̱sula̱, reve a̱ ka̱ra̱. ");
INSERT INTO tswNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Reve Bulu na̱ Sila a̱ kurusu a̱za̱ e Itoni e iɗa ya Suriya na̱ Kilikiya adama a gbamato asuvu e le. ");
INSERT INTO tswNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bulu na̱ Sila a fara ta̱ ꞌya̱wa̱ Daraba she Lisitira uba̱ta̱ u na a cinai Timoti, za na mma va̱ yi za vi Itoni ɗa, umatsun wa Israꞌila u ɗa. Dada va̱ yi gba shi Meheleni ma ɗa. ");
INSERT INTO tswNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","A̱za̱ e Itoni a na a̱ ri a̱tsuma̱ a Lisitira na̱ Ikoniya a cuwusa ta̱ Timoti. ");
INSERT INTO tswNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Bulu shi ta̱ ciga Timoti toni yi, ɗaɗa u tara niyi. Reve u paɗa yi uryumbu, adama a na aza a Israꞌila a na a̱ ri uba̱ta̱ u ndolo, e reve ta̱ a na dada va̱ yi Meheleni ma ɗa. ");
INSERT INTO tswNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Mantsa ma na Bulu na̱ Sila a uwusai lyuci lyuci, reve a cuɗuwa ama ili i na azagbain a dammulai adama a Atakpaci, tsa̱ra̱ a̱ kuru. ");
INSERT INTO tswNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ne ɗa a̱za̱ e Itoni a̱ da̱shi tsura̱i ucira o ucawu wo okolo, waru urana suru a̱ da̱shishi ta̱ a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Reve o toni iɗa ya Firijiya ni iɗa ya Galatiya, adama a na Ruhu va̱ A̱sula̱ putsaa le ta̱ a yuwan alajiya neꞌen a̱tsuma̱ a Asiya wan. ");
INSERT INTO tswNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ana a rawai o utyo wi iɗa ya Misiya, reve a yuwan a̱tyo o ukadu u na a yuwan tsa̱ra̱ a̱ tyo e iɗa ya Bitiniya, amma Ruhu va̱ Yesu lyawa le shi. ");
INSERT INTO tswNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Reve o toni a̱ mɓa̱nga̱ mi iɗa ya Misiya, reve a̱ ka̱ra̱ a̱ cipa̱ a̱ tyo Taruwasa. ");
INSERT INTO tswNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Na ayin, reve Bulu ene alavu alavu. A̱tsuma̱ a alavu alavuꞌu we ene ta̱ vuma va Makidoniya mishin, a patishi yi, adansa, “Ta̱wa̱ Makidoniya tsa̱ra̱ vu kamba tsu.” ");
INSERT INTO tswNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ana Bulu enei alavu alavu o ndolo, babu usa̱n reve tsu ꞌyon a̱ ꞌya̱wa̱ Makidoniya, tsu reve ta̱ a na A̱sula̱ a ɗa e ɗe ntsu tsu yuwaan le alajiya a Alabari a Saꞌani. ");
INSERT INTO tswNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Reve tsu ꞌyon tsu uwa a̱tsuma̱ a wantsun diga Taruwasa, reve tsu ka̱ra̱ tsu ꞌya̱wa̱ e iɗa i memere ma̱ mini ma Samutara. Ana usana u tawai, a̱vu tsu da̱shi uwa a̱tsuma̱ a wantsun, reve tsu ꞌya̱wa̱ a̱ lyuci va Niyapali. ");
INSERT INTO tswNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Reve tsu koso rawa Filibi uba̱ta̱ u na ama a̱ Roma na̱ a̱bunda̱ a̱ da̱nuyi, waru a̱yi ɗa a̱ba̱jini a̱ lyuci upasu wa Makidoniya. Tsu cuꞌwan ta̱ a̱ lyuciꞌi rana re. ");
INSERT INTO tswNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Urana wa Ashibi, a̱vu tsu uta̱ lo zuzu nu una̱ntsu u lyuci, reve tsu ꞌya̱wa̱ zuzu nu uɗolu a yuwusan majiyan uba̱ta̱ u na aza a Israꞌila aa yuwan avasa o ta̱ lo. Reve tsu yuwaan a̱ma̱ci a na a̱ ta̱wa̱i adanshi. ");
INSERT INTO tswNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ka ro da̱na̱ ta̱ lo za na a̱ tsu ɗe Lidiya, za na tsu yuwusaan A̱sula̱ a̱ga̱nda̱ a uwwusa tsu. A̱yi kaꞌa umatsun wa Tayatira u ɗa. U tsu winisa ta̱ amuna a na a̱ ri na̱ ma̱ɗiya̱, aza a na a̱ ri ni ikebe lon. A̱sula̱ a̱ kpa̱tuꞌwa̱ ta̱ okolo a̱ yi e ili i na Bulu ri adansa. ");
INSERT INTO tswNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","A̱ rumbu yi ta̱ oɓolo na ama a na a̱ ri pe a̱tsuma̱ o uꞌwa wa̱ yi, reve u pati tsu tso oꞌwo omocin a̱ yi a̱vu u damma, “Ni i usu a̱mu vuma na cayi okolo uba̱ta̱ wa̱ A̱sula̱ a ɗa, i ta̱wa̱ o uꞌwa u va̱ i cuꞌwan pa.” U kpara tsu ta̱ hali tsu usu. ");
INSERT INTO tswNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Urana u ro a̱tsu a̱ ꞌya̱wa̱ uba̱ta̱ wa avasa, reve tsu gaꞌan na aagbashi o usheli a na a̱ ri no otoni a̱ lima̱ a̱ yindi. Aza a na a̱ ri na̱ a̱yi gba a̱ ta̱ tsurusa̱ ikebe lon o ukere u yindi u na waa yuwusan. ");
INSERT INTO tswNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Reve u tonishi tsu a̱ca̱pa̱ a yisaali, “Ama a nda agbashi o Mogono ma̱ A̱sula̱ ma ɗa o to rocosu ure wi iwawi.” ");
INSERT INTO tswNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","U jima ta̱ a yuwusan ne. Reve Bulu oꞌwo udamu, reve u vadala u damma otoni a̱ lima̱ꞌa̱, “N ta dansaa wu, vu uta̱ a̱tsuma̱ a ala e Yesu Kristi Zamawawa, vu lyawa yi.” Babu usa̱n reve u lyawa yi. ");
INSERT INTO tswNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ana aza a na a̱ ri nu usheliꞌi e enei ili i na i farai, agba a̱a̱ tsurisa̱ ikebe waru shi, reve e reme Bulu na̱ Sila. A̱vu o rono le a̱ tyo e eden a̱ tyo a̱ ma̱ka̱ka̱n ma azagbain. ");
INSERT INTO tswNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ana a rawai, reve a damma, “Aza a Israꞌila a nda a ta damatosun ama a̱ tsu. ");
INSERT INTO tswNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","O to ritosu ili i na a̱tsu a̱za̱ a̱ Roma wu ntsayi tsu yuwan shi.” ");
INSERT INTO tswNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Reve oɓolo a ama o ɓolushi aci adama a adanshi a na aa yuwusan adama a̱ Bulu na̱ Sila. Reve azagbaiꞌin a zuwa a fufaba le na aɗanga. ");
INSERT INTO tswNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Reve a fufaba le waꞌashi, na̱ ne suru a̱vu a̱ ꞌya̱wa̱to le o uꞌwa wa ali. Reve a damma za vi ipiri va amaꞌa u lyawa le a̱a̱ pusa̱ wan. ");
INSERT INTO tswNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Reve u yuwan ununa a damma niyi. Reve u zuwa le pe pe a̱tsuma̱ na akani a ana e le a̱ a̱gba̱la̱ o ume. ");
INSERT INTO tswNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ana ayin a cigai maɓatsaa, reve Bulu na̱ Sila e reme avasa ni ishipa a̱ tyo e ekere a̱ A̱sula̱. Akapi a ama a na a̱ ri o uꞌwa wa aliꞌi a uwwusa le. ");
INSERT INTO tswNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Babu usa̱n reve iɗa i ra̱mo nu ucira. Uꞌwa wa aliꞌi u jinga̱ɗa̱ ta̱ diga pe e iɗa. Reve na̱ntsuꞌu a̱ kpa̱tuꞌwa̱, reve akani suru a̱ ba̱ɗa̱ a ana a aza a na a̱ ri pe o uꞌwa wa aliꞌi suru. ");
INSERT INTO tswNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ana za vi ipiriꞌi u jiwain, reve we ene na̱ntsuꞌu ukpa̱tuꞌu, reve u jiyan gashi amaꞌa suru a suma ta̱. Reve u tara matsun me peꞌeni tsa̱ra̱ wu una aciya̱yi. ");
INSERT INTO tswNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ɗaɗa Bulu saalaa niyi, “She vu yuwan ne wan! Suru ntsu tsu ta̱ pa!” ");
INSERT INTO tswNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Reve vumaꞌa u damma a̱ ta̱wa̱a̱ yi na akata a akina reve wi ikana, ɗaɗa u uwai pe pe o uꞌwa wa aliꞌi. Na̱ mejeꞌen ma̱ lipu ɗaɗa u kingyoi a̱ ma̱ka̱ka̱n ma̱ Bulu na̱ Sila. ");
INSERT INTO tswNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ana wu uta̱a̱ nle a̱tsuma̱ o uꞌwa wa aliꞌi, reve we ece, “Nye i ɗa maa yuwan tsa̱ra̱ a wawa mu?” ");
INSERT INTO tswNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Reve a damma yi, “Vu usu Yesu Zagbain, vu ta̱ tsura̱ iwawi, a̱vu na̱ a̱za̱ o uꞌwa a̱ wu suru.” ");
INSERT INTO tswNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Reve Bulu na̱ Sila yuwaan vumaꞌa na ama a na a̱ ri pe a̱tsuma̱ o uꞌwa wa̱ yi adanshi adama e Yesu Zagbain. ");
INSERT INTO tswNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ayin ubuwu, reve u tara le a̱ ꞌya̱wa̱ uba̱ta̱ u na a̱ za̱za̱ꞌwa̱ antsu na̱ wufuru u na a̱ ri na̱ a̱yi. A̱vu Bulu na̱ Sila a̱ rumbu yi na ama a na a̱ ri o uꞌwa wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Amaꞌa a yuwan ta̱ ma̱za̱nga̱ ma̱ a̱bunda̱ adama a na a cayi okolo e le e ekere a̱ A̱sula̱. Ana o kotoi ili i ndolo, vumaꞌa u tara ta̱ Bulu na̱ Sila a̱ ꞌya̱wa̱ o uꞌwa wa̱ yi, reve u ca le ilyalya a lyuwa. ");
INSERT INTO tswNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ana usana u tawai, reve azagbain a̱ lyuci a̱ lyungu nlingata uba̱ta̱ wu za vi ipiriꞌi a damma yi, “Lyawa ama o ndolo a̱ ka̱ra̱ fa̱a̱n.” ");
INSERT INTO tswNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Reve za vi ipiriꞌi u damma Bulu, “A̱vu na̱ Sila i ta gura ka̱ra̱ gogo. Walai na̱ ma̱za̱nga̱!” ");
INSERT INTO tswNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Reve Bulu na̱ Sila a damma nlingataꞌa, “A̱tsu a̱za̱ a̱ Roma ɗa. A fufaba tsu ta̱ babu e ece tsu ili i ro, reve a̱ ɓa̱ru tsu. Gogo a ciga tsu ta̱ tsu ka̱ra̱ usokowu? U ri n yuwan ne shi! Lyawa le a̱ ta̱wa̱ na aciyele a lyawa tsu!” ");
INSERT INTO tswNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ana nlingataꞌa n dammai azagbain a̱ lyuci a na Bulu na̱ Sila a̱za̱ a̱ Roma ɗa, a uwwa ta̱ wovon. ");
INSERT INTO tswNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Reve a̱ ta̱wa̱ o uꞌwa wa ali a̱vu a pati le ankuri. Reve o uta̱a̱ le a̱vu a pati le a lyawa lyuciꞌi. ");
INSERT INTO tswNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Reve gba Bulu na̱ Sila a̱ ka̱ra̱ mejege a̱ ꞌya̱wa̱ o uꞌwa wa Lidiya, uba̱ta̱ u na a cinai a̱za̱ e Itoni, reve a ca le adanshi. Reve a̱ ka̱ra̱. ");
INSERT INTO tswNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Gogo Bulu na̱ Sila a yuwan ta̱ mmalu reve a ɓatsalai a̱tsuma̱ a̱ lyuci va Amifipali na̱ Apoloni, a̱vu a rawa Tasalonika, uba̱ta̱ u na a̱a̱ꞌisa̱ a aza a Israꞌila a̱ da̱na̱i. ");
INSERT INTO tswNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","A̱vu Bulu uwa e memere me le ununa u tsu yuwusan, hali Ashibi a taꞌatsu a yuwusan adanshi a̱tsuma̱ a Aatagada a̱ A̱sula̱ ne ele. ");
INSERT INTO tswNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","U da̱na̱ ta̱ a casu urevu wa̱ a̱tsuma̱lima̱ a na Zamawawa sowoi na ama̱sula̱ a dammai woo sowo nu uꞌyosun wa̱ yi diga o ukwa̱, a̱vu u damma, “Yesu na maa yuwusan adanshi a̱ yi, a̱yi ɗa Zamawawa.” ");
INSERT INTO tswNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Reve aza a Israꞌila o ro a na a̱ da̱na̱i a uwwusa yi a̱ usu a̱vu a ca okolo, hali na Atakpaci a na o tonishi Wila̱ wa̱ A̱sula̱ na̱ a̱bunda̱, na̱ a̱ma̱ci a̱ a̱bunda̱ a na a̱ ri na̱ tsugbain e iɗaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","A̱vu aza a Israꞌila e reme tsushuꞌun, reve a̱ bunga̱ agbawata. Ana o ɓolotoi suru wira̱ u ta̱, a̱vu a̱ ꞌya̱sa̱n ugbozu wa ama a̱ lyuciꞌi. Reve a uwa o uꞌwa wa Yason nu ucira, azama Bulu na̱ Sila, adama a̱ ta̱wa̱ ne ele uba̱ta̱ wa ama. ");
INSERT INTO tswNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ana a̱ tsura̱ nle shi, reve e reme Yason na̱ a̱za̱ e Itoni o ro, hali a̱ ꞌya̱wa̱ ne ele uba̱ta̱ wa̱ a̱za̱ o ugeꞌetosu, a yuwusan yisaali, adansa, “Ama a nda a ɗa a̱ ꞌya̱sa̱sa̱n ugbozu wa ama uba̱ta̱ suru a̱tsuma̱ o uvaɗi, ele ɗa nda a rawai pa nda. ");
INSERT INTO tswNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","A̱vu Yason ca le ucuꞌwatan. Agba suru nle a ta kuɗusa wila̱ wa Kaisa,† adansa a na mogono mo ro ma̱ ta̱ lo aala a̱ yi Yesu.” ");
INSERT INTO tswNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ana a̱za̱ o ugeꞌetosu na ama a̱ lyuci a uwwai ne, reve okolo e le a̱ ꞌyon. ");
INSERT INTO tswNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","A lyawa Yason na̱ a̱za̱ e Itoni o roꞌo goꞌo shi, she na a lyuwa nle ugana. ");
INSERT INTO tswNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ana ayin a yuwain, reve a̱za̱ e Itoni a̱ shewun Bulu na̱ Sila, a̱vu a̱ ka̱ra̱ a̱ tyo Biriya. Ana a rawai, a̱vu a uwa a̱ a̱a̱ꞌisa̱ a aza a Israꞌila. ");
INSERT INTO tswNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Reve wo oꞌwo aza a Biriya a laꞌa ta̱ aza a Tasalonika ugbozu, adama a na a̱ usu ta̱ adanshiꞌi ne ekere e re. Waru a mantsa suru a̱ tsu da̱na̱ ta̱ e ɗesununa̱ a̱tsuma̱ a Atagada a Ama̱sula̱ a na a̱ da̱na̱i uɗanu, adama e ene ko ili i na Bulu dammai amayun a ɗa. ");
INSERT INTO tswNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Adama o ndolo ama na̱ a̱bunda̱ a̱tsuma̱ a aza a Israꞌila a ca ta̱ okolo, hali na̱ a̱ma̱ci a Heleni a na a̱ ri na̱ tsugbain na ali a̱ a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Amma ana aza a Israꞌila a na a̱ ri Tasalonika a uwwai Bulu ta̱ ɗe, a yuwusan alajiya a̱ lyuci va Biriya fo, a̱vu a̱ ka̱ra̱ a̱ tyo ɗe a kushanu ama, waru a̱ ꞌya̱sa̱sa̱n ugbozu wa ama. ");
INSERT INTO tswNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Reve a̱za̱ e Itoni a zuwushi Bulu u ka̱ra̱ a̱ tyo e ikyun i mala, a̱vu Sila na̱ Timoti e isawan pe a̱tsuma̱ a̱ lyuciꞌi neꞌen. ");
INSERT INTO tswNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Aza a na gba e shewuyin Bulu, e shewun yi ta̱ a̱ tyo a̱ lyuci va Atina. Ana a̱a̱ ka̱mba̱, reve Bulu ca le ikaka a̱ tyo ya Sila na̱ Timoti. U damma le ta̱ a̱ ta̱wa̱ uba̱ta̱ u na u ri, she a̱ lungusa̱ mantsa wan. ");
INSERT INTO tswNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Bulu a̱tsuma̱ e ipiri ya Sila na̱ Timoti a Atina, u yuwan ta̱ a̱tsumola̱ngu lon, ana we enei lyuciꞌi na̱ a̱ma̱li a̱bunda̱. ");
INSERT INTO tswNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Adama o ndolo u yuwusan ta̱ adanshi na aza a Israꞌila a̱ a̱a̱ꞌisa̱ oɓolo na aza a Heleni† aza a na o toniyi Wila̱ wa̱ A̱sula̱. Usana suru u tsu yuwusan ta̱ adanshi na aza a na u cinai e eden. ");
INSERT INTO tswNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ne ɗa waru a̱za̱ e Epikuri na aza a Sitoki a̱za̱ o urevu wa adanshi a yuwusain mawasan na̱ a̱yi. Ana Bulu aa yuwusan alajiya e Yesu nu ukwa̱ wa̱ yi nu uꞌyosun wa̱ yi diga o ukwa̱. Hali ozo o ro e le a damma, “Nye i ɗa za ve elemu a nda aa dansa?” Ozo o ro waru a damma, “U ta̱ vadamma za na a yuwusan alajiya a̱ a̱ma̱li e iɗa i ro ɗa koꞌo.” ");
INSERT INTO tswNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Adama o ndolo a ɗa a tara niyi a̱ tyo uba̱ta̱ wa̱ a̱za̱ o urevu, uba̱ta̱ u na a̱ tsu ɗe Ariyopagu. Reve a damma yi, “Ko vu ta ca tsu ucuɗuwu wu uritosu u saꞌavu u na vaa yuwusan? ");
INSERT INTO tswNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Koto tsu uwwa cuꞌun va adanshi a nda shi. Tsu ciga ta̱ tsu reve urevu wi ili i na i ri pe.” ");
INSERT INTO tswNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ama a Atina no omocin a na a̱ ri pe nden suru, a laꞌa ta̱ ciga a uwwa adanshi a saꞌavu waru a yuwan adanshi a̱ yi tsi ili i ro. ");
INSERT INTO tswNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Reve Bulu ꞌyon mishin a̱ ma̱ka̱ka̱n mo oɓoloꞌo, a̱vu u damma, “A̱ɗu aza a Atina, ama a ɗa a na i cigai itoni ya̱ a̱ma̱li e ili suru. ");
INSERT INTO tswNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ana n ri a̱ a̱ka̱nda̱riya̱ a̱tsuma̱ a̱ lyuciꞌi, me ene ta̱ ili i na yaa yuwusaan a̱ga̱nda̱. Me ene ta̱ masaꞌa mo ro ni iɗana zuva va̱ yi adansa, ‘Za Ro na e Revei Shi.’ A̱yi za ro ndolo na yaa yuwusaan a̱ga̱nda̱ za na i revei shiꞌi, a̱yi ɗa A̱sula̱ a na maa dansaa ɗu. ");
INSERT INTO tswNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“A̱sula̱ a̱yi ɗa u yuwain uvaɗi ni ili i na i ri pe a̱tsuma̱ a̱ yi biti. A̱yi na wo oꞌwoi A̱sulazuva a zuva ni iɗa, u tsu da̱nu a̱ a̱a̱ꞌisa̱ a na vuma suwai shi. ");
INSERT INTO tswNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ne ɗa waru u tsu zami ikambi uba̱ta̱ u vuma shi, waru u tsu lamba ili i ro shi. Ana wo oꞌwoi a̱yi ɗa u cayi ama suru wuma, na̱ wivuwun na akapi e ili suru. ");
INSERT INTO tswNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","A̱yi ɗa waru u yuwain ama o uvaɗi suru diga a vuma ta̱, adama a̱ da̱nu a̱tsuma̱ o uvaɗi suru. Waru u foɓo ta̱ mantsa nu uba̱ta̱ u na vaɗilima̱ suru wa̱a̱ da̱na̱. ");
INSERT INTO tswNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","“A̱sula̱ a yuwan ta̱ ne tsa̱ra̱ a̱ bunga̱ yi, a patsa, ko a̱ tsura̱ yi, ko na wo oꞌwoi u ri alanga na̱ ko za ta̱ tsu shi. ");
INSERT INTO tswNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","O una̱ wa̱ yi u ɗa tsu ri wuma, waru tsu ri a̱ ma̱zungwa̱, ne ɗa a yuwan ntsu waru. Ununa a̱za̱ e ishipa a̱ ɗu a dammai, ‘Amayun, a̱tsu fo diga o ugundo wa̱ yi u ɗa.’ ");
INSERT INTO tswNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“To, ana tso oꞌwoi a̱tsu diga o ugundo wa̱ A̱sula̱ a ɗa tsu uta̱i, u lobono shi tsu yuwan majiyan ma̱ A̱sula̱ a̱ tu urumu vadamma ili i ro i na a yuwain na̱ zinariya ko azurufa, ko na aatali shi, ili i na vuma rumai nu ugbozu wa̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ɗe nu ufaru A̱sula̱ a ca ama a̱tsuma̱lima̱ adama o unusu u le shi, adama o ulambu wu urevu u le. Amma gogo u ciga ta̱ ama suru ko te ɗa a vadala† a yuwaan le gafura vu unusu u le. ");
INSERT INTO tswNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","“Adama a na u zuwa ta̱ urana u na wa̱a̱ ta̱wa̱ u yuwaan ama o uvaɗi suru ugeꞌetosu wa amayun e ekere a vuma ro na u ɗangwai. A̱sula̱ a yuwan ta̱ nzuwulai n na waa yuwan ne, e ekere a vuma na u ꞌya̱sa̱in o ukwa̱.” ");
INSERT INTO tswNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ana a uwwai adanshi o uꞌyosun wa̱ a̱kwa̱kwa̱, a̱vu ozo o ro a yuwaan yi ulamu, reve ozo o ro gba a damma, “Tsu ta ciga tsu uwwa ili i na va̱a̱ da̱shi damma a adanshi a nda.” ");
INSERT INTO tswNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pa nda ɗa Bulu lyawai adanshi ne ele. ");
INSERT INTO tswNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ozo o ro e le gba a̱ ka̱mba̱ ta̱ uba̱ta̱ u na Bulu da̱na̱i, reve a ca okolo a̱tsuma̱ e le hali na̱ Diyanisi, vuma ta̱ a̱tsuma̱ a azagbain, na̱ ka ro za na a̱ tsu ɗe Damari. ");
INSERT INTO tswNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ana ili i ndolo i kotoi, reve Bulu lyawa Atina a̱vu u ka̱ra̱ a̱ tyo a̱ lyuci gbain va̱ Korinti. ");
INSERT INTO tswNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ɗe ɗa u cinai vuma va Israꞌila ro za na a̱ tsu ɗe Akila. Vuma vi iɗa va Pontu ɗa, koto u shi u jima na̱ wutu e iɗa ya Italiya shi, a̱yi na̱ ka va̱ yi Birisika. U lyawa ta̱ iɗa ya Italiya ana Kaladiya mogono ma zuwai vuma va Israꞌila suru u lyawa Roma.† ");
INSERT INTO tswNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ana wo oꞌwoi cuꞌun vu ulinga u ta̱ u ɗa le, maɗava ma amuna mo ogodo, reve u da̱nu ne ele a yuwusan ulinga oɓolo. ");
INSERT INTO tswNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","A̱vu Ashibi suru u yuwusan adanshi na aza a Israꞌila na Atakpaci a Heleni a̱tsuma̱ a̱ a̱a̱ꞌisa̱ adama u rono ugbozu u le. ");
INSERT INTO tswNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ana Sila na̱ Timoti o uta̱i Makidoniya, a̱vu a̱ ta̱wa̱ Korinti. Reve Bulu reme alajiya o rocosu aza a Israꞌila Yesu Zamawawa ɗa. ");
INSERT INTO tswNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Reve aza a Israꞌila† a ꞌyuwan adanshi a̱ yi, a̱vu e reme e isulusa yi. Ɗaɗa u za̱ka̱tsa̱i a̱buta̱ a̱ a̱tugu a̱ yi, a̱vu u damma le, “Mpasa n ɗu n ka̱mba̱ e ekere a̱ ɗu, a̱mu n yuwan ta̱ ili i na maa yuwan. Diga gogo uba̱ta̱ wa Atakpaci u ɗa mee tyo.” ");
INSERT INTO tswNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Reve u lyawa a̱a̱ꞌisa̱ꞌa̱, a̱vu u ka̱ra̱ a̱ tyo o uꞌwa wu Takpaci ro zuzu na̱ a̱a̱ꞌisa̱, za na a̱ tsu ɗe Titiyu Yusutu vuma na aa yuwusaan A̱sula̱ a̱ga̱nda̱. A̱vu u da̱na̱ a̱ da̱nu pe. ");
INSERT INTO tswNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Reve Kirisibu zagbain va̱ a̱a̱ꞌisa̱ u ca Yesu Zagbain okolo a̱ yi na ama o uꞌwa a̱ yi suru. A̱vu fo ama a̱ Korinti a na a uwwa niyi a ca okolo reve a̱ rumbu le. ");
INSERT INTO tswNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Urana u ro na ayin, reve A̱sulazuva a yuwan adanshi na̱ Bulu a̱tsuma̱ a alavu alavu. A̱vu u damma yi, “She vu uwwa wovon wan, lyuwa elime na alajiya, she ɓa̱ru una̱ wan. ");
INSERT INTO tswNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","N to oɓolo na̱ a̱vu, ko ili i ro ya̱a̱ juꞌwa̱n wu shi, adama a na n ta̱ na ama a̱ a̱bunda̱ a na a̱a̱ kuru mu a̱ lyuci ndaꞌa.” ");
INSERT INTO tswNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ɗaɗa Bulu isawain a̱ lyuciꞌi hali aaꞌwan a̱ ta̱ na akapi o ritosu le adanshi a̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","A mantsa ma na Galiya oꞌwoi gwamna va Akataya, a̱vu aza a Israꞌila o ɓolo aci, reve e reme Bulu a̱ ta̱wa̱ na̱ a̱yi uba̱ta̱ wu ugeꞌetosu. ");
INSERT INTO tswNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Reve a damma, “Vuma nda u te leꞌeshishe ama a̱ tsu aa zuwusa le aa yuwusaan A̱sula̱ a̱ga̱nda̱ o ure u na Wila̱ꞌa̱ u ꞌyasain.” ");
INSERT INTO tswNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Bulu o mpolo u yuwan adanshi, ɗaɗa Galiya dammai, “A̱ɗu aza a Israꞌila, a damma a̱ba̱jini o unusu u ro u ɗa u yuwain ko ikpaꞌa, n shi ta gura poloo ɗu atsuvu. ");
INSERT INTO tswNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Amma ana wo oꞌwoi adama e idanshi i ɗu i ɗa, na adama a ala, na̱ Wila̱ u ɗu, ꞌya̱wa̱i i sa̱la̱la̱i na aciya̱ɗu. A̱mu imini i va̱ yi pe na mee geꞌeto cuꞌun vi ili i kekeꞌen i nda shi.” ");
INSERT INTO tswNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Reve u gba̱ra̱ le a lyawa ukobu wu ugeꞌetosuꞌu. ");
INSERT INTO tswNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ɗaɗa oɓolo a amaꞌa e remei Satsani zagbain va̱ a̱a̱ꞌisa̱, a̱vu a fufaba yi lon a̱ a̱a̱ra̱ra̱ zuzu nu ukobu wu ugeꞌetosu. Galiya dama ni ili i na a yuwain shi. ");
INSERT INTO tswNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Reve Bulu gbaꞌa u da̱shi jima pe a̱tsuma̱ a̱ Korinti. Reve u ꞌyon u lyawa a̱za̱ e Itoni u uwa a wantsun a̱ tyo Suriya oɓolo na̱ Birisika na̱ Akila. Kafu u ka̱ra̱, reve u puna oogbondo ɗe Kankiriya, adama u shiton akucunu a na u tarai. ");
INSERT INTO tswNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ana a rawai Afisu (pe ɗa u lyawai Birisika na̱ Akila), reve u uwa a̱ a̱a̱ꞌisa̱ a yuwusan adanshi na aza a Israꞌila. ");
INSERT INTO tswNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Reve a pati yi u da̱shi jima pe ne ele, agba u usu shi. ");
INSERT INTO tswNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","A̱vu u ka̱ra̱ u lyawa le, amma u damma le ta̱, “Na̱ A̱sula̱ a ciga, n ta̱ lo a̱ ta̱wisa̱.” ");
INSERT INTO tswNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Reve u uwa a wantsun ɗe Afisu. Ana u rawai Kasariya, reve u ꞌya̱wa̱ u ca̱sa̱ a̱za̱ e Itoni a̱tsuma̱ a̱ Urishelima, ɗaɗa u ka̱ra̱i a̱ tyo Antakiya. ");
INSERT INTO tswNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ana u jimai pe waꞌa, reve u ꞌyon u bubura iɗa ya Galatiya na̱ Firijiya a̱ kurusu le lyuci lyuci a yuwusaan a̱za̱ e Itoni adanshi e isawan ugbamu. ");
INSERT INTO tswNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Reve vuma va Israꞌila ro za na a̱ tsu ɗe Apolo ta̱wa̱ Afisu. Lyuci na a matsan niyi a̱yi ɗa Iskandariya. U ta̱ nu urevu, u reve ta̱ adanshi a̱ A̱sula̱ lon. ");
INSERT INTO tswNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","O rito yi ta̱ lon o Ure wu Zagbain, waru u tsu yuwan ta̱ adanshi ulobonu, a̱vu u yuwusan uritosu adama e Yesu kuci mejege, ko a na wo oꞌwoi urumbusu wa Yahaya u ɗa u revei goon. ");
INSERT INTO tswNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Reve u reme uritosu a̱tsuma̱ a̱ a̱a̱ꞌisa̱ no okolo ugbamu. Ana Akila na̱ Birisika uwwa niyi reve a banu yi o uꞌwa u le, reve a̱ da̱shi cuɗuwa yi ure wa̱ A̱sula̱ mejege. ");
INSERT INTO tswNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ana u cigai u gawan a̱ tyo e iɗa ya Akataya, ɗaɗa a̱za̱ e Itoni a kamba niyi na̱ a̱sa̱la̱, a̱vu a ɗanaa a̱za̱ e Itoni a na a̱ ri ɗe mepepelime, adama a̱ ushi yi ne ekere e re. Ana u rawai, reve gba u kamba aza a na a cayi okolo e le ni isaꞌani ya̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Adama a na u polo ta̱ aza a Israꞌila a̱tsuma̱ a mawasan ma na a yuwusain, reve u rocosu le a̱tsuma̱ a Adanshi a̱ A̱sula̱ a na Yesu ɗa Zamawawa.† ");
INSERT INTO tswNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Yashi i na Apolo da̱na̱i a̱tsuma̱ a̱ Korinti, Bulu gara ta̱ a̱ mɓa̱nga̱ mi iɗaꞌa, reve u rawa Afisu lyuci gbain. Ɗe ɗa u cinai a̱za̱ e Itoni o ro. ");
INSERT INTO tswNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Reve we ece le, “I tsura̱ ta̱ ɗe Ruhu va Akiza a na i cayi okolo a̱ ɗu uba̱ta̱ wa̱ Yesu?” Reve a̱ usu, “Oꞌo, tsu uwwa adama a̱ Ruhu va Akiza shi, ko keꞌen.” ");
INSERT INTO tswNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Reve we ece le, “Cuꞌun vu urumbusu u ne u ɗa a yuwaan nɗu?” Reve a̱ usu, “Urumbusu wa Yahaya.” ");
INSERT INTO tswNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Reve Bulu usu, “Yahaya rumbu ta̱ ama, tsa̱ra̱ a̱ ka̱mba̱ uba̱ta̱ wa̱ A̱sula̱. Waru u damma le ta̱ a na vuma ro ta̱ lo a̱ ta̱wa̱, reve u damma le a ca okolo e ekere a vumaꞌa. Yesu ɗa vuma na Yahaya yuwusain adanshi a aci a̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ana a uwwai ne, reve a̱ rumbushi nle a̱tsuma̱ a ala e Yesu Zagbain. ");
INSERT INTO tswNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Reve Bulu kuruwa̱ le ekere, reve Ruhu va Akiza ta̱wa̱ le. Reve a yuwan adanshi ne elentsu o ro, na adanshi e ikaka ya̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ele ɗa a̱ da̱na̱i ama kupa ne ejere suru suru. ");
INSERT INTO tswNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Bulu ꞌya̱wa̱ ta̱ a̱ a̱a̱ꞌisa̱, a̱tsuma̱ o woto taꞌatsu u yuwusaan ta̱ amaꞌa adanshi babu wovon. A dammulai ta̱, tsa̱ra̱ u gura le e reve adama o tsugono tsa̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ozo o ro a̱tsuma̱ e le a ꞌyuwan ta̱ adanshi a̱ yi, a alanga e eteshe a ɗa a yuwain adanshi a vanvama o Ure wu Zagbain. Adama o ndolo, reve Bulu lyawa a̱a̱ꞌisa̱ꞌa̱, a̱vu u tara a̱za̱ e Itoni a̱ ka̱ra̱ na̱ a̱yi. Reve u teme alajiya a aasula o uritosu a Tayaranu usana suru. ");
INSERT INTO tswNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","U yuwusan ta̱ cuꞌun vu uritosu u nda, hali aꞌwan e re, hali aza a Israꞌila na̱ Nheleni† a Asiya suru a uwwa adanshi a̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","A̱sula̱ a yuwan ta̱ ili ya asalama i na i laꞌai ili ya asalama o ro e ekere a̱ Bulu. ");
INSERT INTO tswNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ama a tara ta̱ mukashi mu ukere na̱ a̱tugu o ulinga a na Bulu otoi, reve a tara le a̱ ꞌya̱wa̱ uba̱ta̱ u na a̱za̱ o ubanakun a̱ ri. Banakun na damatosuyi amaꞌa a lyawa le ta̱, hali no otoni a̱ lima̱ a kakasa ta̱ ne ele waru. ");
INSERT INTO tswNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ama a Israꞌila o ro a̱ ꞌya̱wusa̱ ta̱ lyuci lyuci o utusa̱a̱ otoni a̱ lima̱. Amaꞌa o rito ta̱ yuwan ulinga na ala e Yesu Zagbain. A dansa ta̱ idanshi i nda na̱ a̱ ka̱mbi: “N ta dansaa wu a ala e Yesu, za na Bulu aa yuwusan alajiya, uta̱!” ");
INSERT INTO tswNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Muwun n cindere ma ganu gbain† na a̱ tsu ɗe Shiva, ele ɗa a yuwusain ili i nda. ");
INSERT INTO tswNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Urana u ro, otoni a̱ lima̱† a damma le ta̱, “N reve ta̱ Yesu! Waru n reve ta̱ adama a̱ Bulu. A̱ɗu gba zane ɗa i ri?” ");
INSERT INTO tswNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Reve vuma na da̱na̱i no otoni a̱ lima̱ wu ꞌyawan u raɓa le, reve wu ruꞌwa̱ le, hali a suma o uta̱ a alanga ataɓu, waru a uwwa ta̱ usa̱n. ");
INSERT INTO tswNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Babu usa̱n, a̱vu alabari e ili i na i farai suru, u baza a̱tsuma̱ a Afisu, a̱ ꞌya̱wa̱ aza a Israꞌila na̱ Nheleni. A̱za̱ a̱ lyuciꞌi a uwwa ta̱ wovon lon, reve ala e Yesu Zagbain a̱ tsura̱ ica lon. ");
INSERT INTO tswNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Aza a na o oꞌwoi a̱za̱ e Itoni a damma ta̱ unusu u le. ");
INSERT INTO tswNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Aza a na a yuwusain ulinga u tsuboci, reve a̱ ta̱wa̱ na atagada a na a yuwusayin ulinga, reve a̱ kula̱to le e memere ma ama. Ana e kecei ikebe ya atagadaꞌa, a ta rawa ikebe ya aza a zamalinga na a̱a̱ tsura̱ wu ulinga vu ulivu vu rana ukpakukupa kupoton (50,000). ");
INSERT INTO tswNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ne ɗa adanshi a̱ A̱sula̱ a̱ da̱shi bazai, reve waru u yuwan ucira lon. ");
INSERT INTO tswNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ana ili i ndolo i farai suru, reve Bulu yuwan majiyan o okolo a̱ yi u ꞌya̱wa̱ Makidoniya na̱ Akataya, reve u ka̱mba̱ Urishelima. U damma ta̱ waru, “Diga Urishelima n ta̱ ꞌya̱wa̱ Roma.”† ");
INSERT INTO tswNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Timoti na̱ Arasata a kambusa ta̱ Bulu. U lyungu le ta̱ elime a̱ yi a̱ ꞌya̱wa̱ Makidoniya, reve a̱yi wi isawan neꞌen waꞌa e iɗa ya Asiya. ");
INSERT INTO tswNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","A mantsa mo ndolo addama a cina ta̱ a̱za̱ e Itoni yu Ure yi Zagbain. ");
INSERT INTO tswNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Addama a fara ta̱ diga ya Dimitiriya, maruma za na aa yuwusan ulinga na̱ azurufa tsa̱ra̱ u yuwan muꞌisa̱ ma̱ a̱a̱ma̱li a ka Atima. A̱yi na aza a na a yuwusan cuꞌun vu ulingaꞌa a̱ ta̱ tsurusa̱ ikebe lon o ureꞌe. ");
INSERT INTO tswNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Dimitiriya ɓoloto ta̱ amaꞌa na ama o ro a na a yuwusan oroci o ulinga u le, reve u damma, “Ama a̱ va̱, i reve utsuru u tsu a̱tsuma̱ o ulinga u nda u ɗa woo utusa̱. ");
INSERT INTO tswNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ye ene ta̱, waru yu uwwa ta̱ cine vuma nda Bulu oo ronuso ama na̱ a̱bunda̱. U yuwan ta̱ ne a̱tsuma̱ a Afisu, na̱ ba̱ta̱ a̱bunda̱ e iɗa ya Asiya. U ta dansa a̱ma̱li a na a̱tsu tsaa yuwusan, a̱ma̱li a̱ a̱ɓula̱ a na a ɗa shi, ko keꞌen. ");
INSERT INTO tswNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ama suru a̱ ta̱ da̱na̱ a adanshi a vama o ulinga u tsu. A̱a̱ da̱shi tara a̱a̱ꞌisa̱ a̱ a̱a̱ma̱li a ka Atima ili i ro shi. Woo lobono shi, adama a na a ta yuwusaan Atima a̱ga̱nda̱ e iɗa ya Asiya na̱ a̱tsuma̱ o uvaɗi suru. Waru a̱ te icina na̱ a̱ba̱jini a̱ a̱a̱ma̱li a̱ tsu!” ");
INSERT INTO tswNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ana a̱za̱ o ulinga o ndolo a uwwai ne, reve a fara yisaali, “Atima ta̱ mgbain, a̱a̱ma̱li a aza a Afisu a ɗa!” ");
INSERT INTO tswNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Reve oɓolo a fara o ɓolotosu, babu usa̱n reve ugbozu wa ama a̱tsuma̱ a̱ lyuciꞌi ma̱ɓula̱ u ꞌyon. Ama suru a suma ta̱ a̱ tyo uba̱ta̱ wi iɓolo. Reve a zuwa Gayu na̱ Arista ꞌya̱wa̱ oɓolo ne ele. Ama e reꞌe a̱ da̱na̱ ta̱ a mmalu na̱ Bulu diga Makidoniya. ");
INSERT INTO tswNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Bulu shi ta̱ ciga u ꞌya̱wa̱ u yuwan adanshi no oɓoloꞌo, agba a̱za̱ a̱ yi a lyawa yi shi. ");
INSERT INTO tswNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Azagbagbain o ro e iɗaꞌa nꞌutsa̱ ma̱ Bulu n ɗa. Reve gba ama a nda a̱ lyunguwa̱ yi ikaka. Ikakaꞌa a̱yi ɗa she u usu u ꞌya̱wa̱ ɗe wan, tsa̱ra̱ u kenee aciya̱yi addama wan. ");
INSERT INTO tswNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","A̱tsuma̱ o uba̱ta̱ꞌa̱, ugbozu wa ama u ꞌyon ta̱. Ozo o ro a yisaali adama e ili i ro, ozo o ro gba shi a yisaali adama e ili i ro. Ozo o ro gba na̱ a̱bunda̱ e reve ili i na i zuwai a̱ ri ɗe shi. ");
INSERT INTO tswNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Vuma na a̱ tsu ɗe Iskandari ɗa aza a Israꞌila a zuwai elime, a̱yi ɗa a zuwai u cuɗuwa ili i na i farai. U zuwa ta̱ ama a̱ rungwa̱, reve u yuwan adanshi o una̱ wa ama a̱ yi tsa̱ra̱ u voton ugbozu wo oɓoloꞌo. ");
INSERT INTO tswNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ana amaꞌa e revei za va Israꞌila ɗa, reve e teme yisaali, na a dammi, “Atima a̱ba̱jini a̱ a̱a̱ma̱li a aza a Afisu ɗa! Atima a̱ba̱jini a aza a Afisu ɗa!” A yuwan ta̱ cuꞌun ndolo hali irumu i re. ");
INSERT INTO tswNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","O ukosu, a̱vu vuma ta̱ a̱tsuma̱ a azagbain a̱ lyuci u zuwa amaꞌa a̱ rungwa̱. Reve u damma, “Ama a Afisu, a̱tsuma̱ o uvaɗi u nda vuma ta̱ lo za na revei lyuci tsu uba̱ta̱ u na aa yuwusaan Atima a̱ba̱jini a̱ a̱a̱ma̱li a̱ga̱nda̱ a ɗa shi? Vuma ta̱ lo za na revei ana diga zuva ɗa u riya̱i agba waru u ta̱ pa nda shi? ");
INSERT INTO tswNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Babu za na a wasan a na u reve shi. She waru u ɓa̱la̱ ɗu wan. Ko nye i ɗa, she i yuwan ili i tsulo wan. ");
INSERT INTO tswNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","“I ta̱wa̱to ta̱ ama a nda uba̱ta̱ u nda, koto e iva̱ ili i ro a̱tsuma̱ a̱ a̱a̱ꞌisa̱ shi, waru koto a yuwan adanshi a vama adama a̱ a̱a̱ma̱li a nda shi. ");
INSERT INTO tswNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Na̱ Dimitiriya na aza a na aa yuwusan cuꞌun vu ulingaꞌa a̱ ri na adanshi a aci e le, tsu ta̱ na̱ ꞌwa vu ugeꞌetosu na̱ a̱za̱ o ugeꞌetosu. Lyawa le a tara adanshi e le a̱ ꞌya̱wa̱ ɗe. ");
INSERT INTO tswNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Na adanshi o ro o lo, a tara le a̱ tyo uba̱ta̱ wa azagbain a̱ lyuci. ");
INSERT INTO tswNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","“N ta uwwusa wovon azagbain a gwamnati va̱ Roma e te reme tsu nu unusu adama a̱ nla̱ngi, adama a na babu ili i na i rawai a yuwan ili i na aa yuwusan nda. Na̱ Roma ciga ucuɗuwu wi ili i na yaa farasa, tsa̱a̱ tsura̱ ili i na tsaa damma shi.” ");
INSERT INTO tswNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ɗaɗa u damma nle a̱ ka̱ra̱, reve e beteꞌwe. ");
INSERT INTO tswNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ana ugbozu u voyin, reve Bulu ɗe a̱za̱ e Itoni a̱vu u yuwaan le adanshi a na e isawan ugbamu. A̱vu u lyawa le u ka̱ra̱ a̱ tyo e iɗa ya Makidoniya. ");
INSERT INTO tswNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","O ureꞌe, reve u ɓatsasa ba̱ta̱ ba̱ta̱ a yuwusaan le adanshi a na a gbama okolo. Ɗaɗa u tyoyi e iɗa ya̱ Heleni.† ");
INSERT INTO tswNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Wu una ta̱ woto taꞌatsu pe. A mantsa ma na waa zama u uwa a wantsun a̱ tyo e iɗa ya Suriya, ana wu uwwai a na aza a Israꞌila o ɓolo ta̱ una̱ adama o una yi, reve u ka̱mba̱ ni iɗa ya Makidoniya. ");
INSERT INTO tswNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Waru ama e cindere a ɗa o toni niyi. Ele ɗa Supata mawun ma Puruhu vuma va Biriya, Arista na̱ Sakunda ama a Tasalonika, na̱ Gayu vuma va Daraba, na̱ Timoti, waru na̱ Tikiku na̱ Tarafima ama e iɗa ya Asiya. ");
INSERT INTO tswNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ele ama a nda a wala ta̱ elime, reve a̱ ꞌya̱wa̱ o puro tsu Taruwasa. ");
INSERT INTO tswNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ana o kotoi A̱buki o Opopofu,† a̱tsu gba a̱vu tsu lyawa Filibi va Makidoniya a wantsun. Ana tsu yuwain rana ton a mmalu, reve tsu cina le Taruwasa. Pe ɗa tsu yuwain ayin e cindere. ");
INSERT INTO tswNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","O urana wu ufaru wa ajuma, reve tsu ɓoloto adama tsu lyuwa ilyalya. A̱vu Bulu yuwaan le adanshi adama a na u foɓoi na wa̱a̱ ka̱ra̱ nu usana u tawa. Reve u reme adanshi hali ayin uɓatsu. ");
INSERT INTO tswNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ifitila i shi ta̱ pe a̱bunda̱ o uꞌwa wa zuva u na tsu ɓolotoi. ");
INSERT INTO tswNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Reve ulobo u ro u na a̱ tsu ɗe Afitiku da̱nu o uɓatsu wu usowoto wu upepu. A̱vu gba nlavu m pura̱ yi a mantsa ma na Bulu da̱na̱i adanshi vadamma babu ukotu. Ɗaɗa u fa̱tsa̱i ɗe a aasula a taꞌatsu o uꞌwa wa zuvaꞌa. Reve e sheɗe yi ukwa̱. ");
INSERT INTO tswNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Reve Bulu cipa̱, a̱vu u vowon uloboꞌo u gbagbala yi ne ekere a̱ yi a̱vu u ꞌya̱sa̱n yi. Ɗaɗa waa damma, “She okolo a̱ ꞌyon ɗu wan! U ta̱ wuma.” ");
INSERT INTO tswNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ana Bulu kumbai o uꞌwa wa zuva, reve u lyuwa ilyalya na̱ a̱tsu. Ɗaɗa u koso asai a adanshi, nu usana a̱vu u reme ure. ");
INSERT INTO tswNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ɗaɗa ama a tarai uloboꞌo a̱ tyo o uꞌwa u le gbaga, a̱vu asuvu e le a̱ da̱nu. ");
INSERT INTO tswNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Reve Bulu reme mmalu a̱ tyo a̱ lyuci va Asusu. A̱tsu gbaꞌa reve tsu uwa a wantsun adama tsu gaꞌasan ɗe, uba̱ta̱ u na tsaa tara yi a wantsun. ");
INSERT INTO tswNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ana u cina ntsu ɗe, reve u uwa a wantsun ɗaɗa tsu ka̱ra̱i a̱ tyo Mitilini. ");
INSERT INTO tswNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ana usana u tawai, reve tsu uwa wantsun a̱ tyo zuzu ni iɗa i memere ma̱ mini ma̱ Kiyo. Reve ana usana u tawai, tsu pasa a̱ tyo e iɗa i memere ma̱ mini ma Samo. Ana usana u tawisai waru, reve tsu rawa Milita. ");
INSERT INTO tswNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Bulu gba u zuwa ta̱ okolo a̱ yi u ka̱ra̱la̱i a̱tsuma̱ a Afisu, adama a na u cigai u tara mantsa a̱tsuma̱ e iɗa ya Asiya shi. U zuwa ta̱ okolo u rawa Urishelima a mantsa ma̱ A̱buki o Urana wa Kupoton.† ");
INSERT INTO tswNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ana u rawai Milita, a̱vu Bulu lyunguwa̱ azagbain a̱ a̱za̱ e Itoni a Afisu, a̱vu a̱ ta̱wa̱ e enelei. ");
INSERT INTO tswNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ana a rawai, reve u damma le, “I reve ta̱ cuꞌun vu nden n na n yuwain mantsa ma na n da̱nuyi oɓolo na̱ a̱ɗu, diga urana u na n dasai iɗa ya Asiya. ");
INSERT INTO tswNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","N yuwan ta̱ ulinga wa̱ A̱sulazuva n tara aciya̱va̱ ili i ro shi, hali na aɓara. Reve n yuwan ankuri ni ikpaꞌa i na ama a Israꞌila a yuwusaan numu. ");
INSERT INTO tswNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Waru n kuɗa̱ a damma ɗu amayun shi, ko a̱tsuma̱ a ama ko a ꞌwa ɗu. ");
INSERT INTO tswNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ili i na n dammai ama a Israꞌila a̱yi ɗa waru n dammai Atakpaci, a̱yi ɗa cine aa vadala uba̱ta̱ wa̱ A̱sula̱, reve a ca Yesu Zagbain okolo e le. ");
INSERT INTO tswNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Gogo nda gba, Ruhu va Akiza† pura̱ ta̱ ugbozu u va̱ a gbagbusa mu n tyo Urishelima. A̱yi ɗa nda gba n reve ili i na ya̱a̱ tsura̱ mu ɗe shi. ");
INSERT INTO tswNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","N gura ta̱ reve a mantsa ma na m burusai lyuci lyuci, Ruhu va Akiza dansaa mu ta̱ a na uꞌwa wa ali u ta̱ lo a pura mu, na̱ a̱tsuma̱lima̱ waru. ");
INSERT INTO tswNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Suru na̱ ne, n tara wuma u va̱ ili i ro shi nna̱ koto n koto ulinga u na Yesu Zagbain zuwa numu shi. A̱yi ɗa ulinga wa alajiya a Alabari a Saꞌani a na oo rocosu icigi ni isaꞌani ya̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“N ꞌya̱wa̱ ta̱ ba̱ta̱ ba̱ta̱ a yuwusaan ɗu alajiya, gogo ko vuma ta̱ a̱tsuma̱ a̱ ɗu a̱a̱ da̱shi ene mu shi. ");
INSERT INTO tswNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Lyawa n damma ɗu mejege, nna̱ A̱sula̱ a tara wuma u vuma, za lo a damma ee ece yi e ekere a̱ va̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Adama a na ko ili i ta̱ n soko ɗu shi n damma ɗu ta̱ ili i na A̱sula̱ a cigai i reve suru. ");
INSERT INTO tswNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","I ka̱lyuwa̱ aciya̱ɗu ulobonu waru na̱ a̱za̱ e Itoni a na Ruhu va Akiza zuwa nɗu yo oꞌwo aza a aguɓa e ikyon† ya̱ A̱sula̱. Ele ɗa aza a na u tsulai na̱ mpasa ma̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","N gura ta̱ reve na̱ n ka̱ra̱, munlu me epen n na n rotsoi nkerenkesu n ta̱ ta̱wa̱ agba aa lyawa ikyon ya̱ A̱sula̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ozo o ro fo a̱tsuma̱ a̱ ɗu o to gondoro ili i na i ri mejege adama a̱ tsura̱a̱ aciyele ojoro. ");
INSERT INTO tswNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","I da̱na̱ ufoɓu! I cuwan n da̱nu ta̱ na̱ a̱ɗu aꞌwan a taꞌatsu a ɓarasa ɗu waru a̱ ka̱lyuwusa̱ ɗu nu usana na ayin, na̱ moo ocosuyi aɓara. ");
INSERT INTO tswNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Gogo n zuwa ɗu ta̱ o ukere wa̱ A̱sula̱. I cuwan na adanshi e isaꞌani ya̱ yi! A̱yi ɗa waa suwa ɗu, reve i ushi ili i na A̱sula̱ o foɓoi na waa ca ɗu ama a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","“N ri a maluwa me ikebe yi za ro, ko gba itana shi. ");
INSERT INTO tswNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","A̱ɗu na aciya̱ɗu i reve ta̱ ne ekere a̱ va̱ a ɗa n lingai adama n lyuwa, reve waru n kamba aza a na a̱ ri oɓolo na̱ a̱mu. ");
INSERT INTO tswNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","N yuwusan ta ne adama n roco ɗu ure u na ya̱a̱ kuru, adama i yuwan ulinga lon i kamba aza a na a̱ ri nu ucira shi a̱tsuma̱ a̱ ɗu. I cuwan na adanshi e Yesu Zagbain ana u dammai, ‘U laꞌa ta̱ lobono vuma ca, ana wa̱a̱ ushi.’ ” ");
INSERT INTO tswNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ana Bulu kotoi adanshi, reve u kingyo oɓolo ne ele suru u yuwan avasa. ");
INSERT INTO tswNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Reve suru nle a uwa mesun, reve a katala yi adama a na wa̱a̱ ka̱ra̱. ");
INSERT INTO tswNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ili i na i laꞌa zuwa nle a̱tsumola̱ngu, a̱yi ɗa udammu u na u dammai a na a̱a̱ da̱shi ene yi waru shi. Reve suru nle e shewun yi a̱ tyo uba̱ta̱ u na u uwai a wantsun. ");
INSERT INTO tswNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ana tsu kasai na̱ mbara ma Afisu, a̱vu tsu uwa a wantsun tsu saɓa a̱ tyo Koso e iɗa i memere ma̱ mini mejege. Ana usana u tawai, a̱vu tsu rawa Rodusa, diga lo waru she Patara. ");
INSERT INTO tswNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Reve tsu cina lo wantsun u na waa pasalai a̱ tyo Finisiya, reve tsu uwa tsu lyuwa elime na̱ mmalu. ");
INSERT INTO tswNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Tse ene ta̱ iɗa i memere ma̱ mini ma̱ Kuburu a̱vu tsu lyawa yi ugula̱ tsu ka̱ra̱ tsu cipa̱ a̱ lyuci va Taya, e iɗa ya Suriya, uba̱ta̱ u na a̱a̱ cipa̱to itana i na i ri a wantsuꞌun. ");
INSERT INTO tswNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ana tsu uwai a̱ lyuci, reve tsu cina pe a̱za̱ e Itoni, reve tsu yuwan pe ayin e cindere. Reve Ruhu va Akiza zuwa le a ca Bulu a̱sa̱la̱ she u ꞌya̱wa̱ Urishelima wan. ");
INSERT INTO tswNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ana tsu yuwain ayin e cindereꞌe, reve tsu va̱sa̱ tsu lyuwa elime na̱ mmalu. Reve a̱za̱ e Itoni na̱ a̱ma̱ci na̱ muwun n le e shewun tsu o uta̱ a̱ lyuci a̱ tyo a̱ ngeꞌen m mala. A̱vu tsu ka̱ɗa̱to a̱ wuyun tsu yuwan avasa. ");
INSERT INTO tswNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ana tsu kasalai, reve tsu uwa a wantsun. Ele gba a̱ ka̱mba̱ o uꞌwa. ");
INSERT INTO tswNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Reve tsu lyawa Taya a̱ tyo Talamaya. Ana tsu ca̱sa̱la̱i na̱ a̱za̱ e Itoni, a̱vu tsa asa pe ayin a̱ ta̱. ");
INSERT INTO tswNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ana usana u tawai, reve tsu ka̱ra̱ a̱ tyo Kasariya, a̱vu tsu cuꞌwan ya Filibu za va alajiya, vuma ta̱ a̱tsuma̱ a ama e cindere a na a kambusai ajiya. ");
INSERT INTO tswNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","U ta̱ ne esheli a̱ na̱shi aza a na o koto o oloi shi, a tsu yuwusan ta̱ adanshi e ikaka ya̱ A̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ana tsu jimai pe, a̱vu vumava̱sula̱ ro na a̱ tsu ɗe Agabu ta̱wa̱ diga Yahuda. ");
INSERT INTO tswNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ana u ta̱wa̱i ya̱ꞌa̱ tsu, a̱vu u tara gbakala vi ikyun ya̱ Bulu, reve wu nla̱ aciya̱yi ekere na ana. A̱vu u damma, “Ruhu va Akiza damma ta̱, ‘Ne tsunda tsa ɗa aza a Israꞌila a̱ Urishelima a̱a̱ nla̱ za gbakala vi ikyun i nda, a̱vu a zuwa yi e ekere a̱ a̱za̱ a̱ Roma.’ ” ");
INSERT INTO tswNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ana tsu uwwai ne, reve a̱tsu na̱ a̱za̱ e Itoni a na a̱ ri lo tsu pati Bulu she u ꞌya̱wa̱ Urishelima wan. ");
INSERT INTO tswNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Reve Bulu usu u damma, “Adama a̱ nye i ri e mesun a kuɗusa okolo a̱ va̱? N ri ufoɓu n uwa o uꞌwa wa ali Urishelima goon shi, amma hali n kuwa̱ adama e Yesu Zagbain.” ");
INSERT INTO tswNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ana tse enei wa̱a̱ bula̱ shi, ɗaɗa tsu dammai, “Lyawa a yuwan ili i na A̱sulazuva e enei a̱ ri mejege.” ");
INSERT INTO tswNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Tsu jima shi, ɗaɗa tsu foɓoi tsu va̱sa̱i a̱ tyo Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Reve ama o ro a̱tsuma̱ a̱ a̱za̱ e Itoni a Kasariya e shewun tsu, reve a̱ tyowetyo tsu o uꞌwa wa Nnasan uba̱ta̱ u na tsa̱a̱ da̱nu. A̱yi vuma va Kuburu ɗa za na fara cayi okolo a̱tsuma̱ e Itoni. ");
INSERT INTO tswNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ana tsu rawai Urishelima, reve a̱za̱ e Itoni suru a raba tsu na̱ ma̱za̱nga̱. ");
INSERT INTO tswNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ana usana u tawai, reve a̱tsu na̱ Bulu tsu ꞌya̱wa̱ tse ene Yakubu, waru azagbain a̱ a̱za̱ e Itoni a̱ shi ta̱ lo. ");
INSERT INTO tswNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ana Bulu ca̱sa̱ nle, reve u damma ununa A̱sula̱ a yuwain ulinga na̱ a̱yi adama u kamba Atakpaci. ");
INSERT INTO tswNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ana a uwwai ne suru, reve a ciɓala A̱sula̱, reve a damma Bulu, “Za tsu, vu ta uwwusa, ama ukpakukupa na̱ a̱bunda̱ aza a Israꞌila o oꞌwo ta̱ a̱za̱ e Itoni, agba suru nle o to mpolo nu ukurusu u Wila̱ wa Musa mejege. ");
INSERT INTO tswNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Agba a damma le ta̱ ɗe a na vu to rocosu aza a Israꞌila a na a̱ ri nden a̱tsuma̱ a Atakpaci, she a̱ kuru Wila̱ wa Musa wan. A na vu ta dansaa le she a paɗa muwun n le uryumbu wan, waru she a̱ kuru agadu a̱ tsu wan. ");
INSERT INTO tswNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","“Cine tsaa yuwain gogo, ana wo oꞌwoi a̱za̱ a̱ tsu a uwwa ta̱ ɗe na vu ri pa? ");
INSERT INTO tswNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Yuwan ankuri, vu yuwan ili i na tsaa dansaa wu. Tsu ta̱ na ama a̱ na̱shi aza a na a yuwayin A̱sula̱ akucunu. ");
INSERT INTO tswNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Vu ɓolo ekere na ama a nda. Vu foɓo aciya̱wu adama a̱ a̱ga̱nda̱ a na a tsu yuwan adama a akucunuꞌu. Vu tsupa adama a puna aci e le. Ɗaɗa ama ee reve adanshi a na a yuwain a aci a̱ wu epen a ɗa. E te reve a na voo tono Wila̱ wa Musa. ");
INSERT INTO tswNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","“Tsu damma ta̱ ɗe Atakpaci a̱za̱ e Itoni ili i na i lobonoi a yuwan. Tsu ɗanaa le ta̱, she a lyuwa ili i na a cayi a̱ma̱li wan. She a tama a̱kutsu a mpasa wan, waru a tama nama na a̱ punda̱ra̱i wan. Tsu damma le ta̱ waru she a yuwan tsipere wan.” ");
INSERT INTO tswNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Reve Bulu usu a̱sa̱la̱ e le. Ana usana u tawai, reve u ꞌya̱wa̱ u yuwan a̱ga̱nda̱ a̱ wulecu oɓolo na amaꞌa. A̱vu u uwa a̱ A̱a̱ꞌisamapaɗa adama u damma le mantsa ma na akucunu e le oo koto, reve a yuwan kucci† adama a̱ koyan a̱tsuma̱ e le. ");
INSERT INTO tswNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ana a yuwain ayin e cindere a na akucunuꞌu oo koto, reve aza a Israꞌila o ro a na a̱ ri e iɗa ya Asiya e ene Bulu a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗa. Ɗaɗa a̱ ꞌya̱sa̱in okolo a ama, reve e reme Bulu. ");
INSERT INTO tswNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Na a saali, “A̱za̱ a̱ tsu, kamba ntsu! Vuma nda u ta garasa ba̱ta̱ ba̱ta̱ o ritosu ili i vama a̱ tyo e ekere a ama a̱ tsu oɓolo na̱ Wila̱ wa Musa, na adama a̱ A̱a̱ꞌisamapaɗa a nda. U zuwa ta̱ uba̱ta̱ wa akiza u nda wo oꞌwo ili i wono a na u tarai Atakpaci a uwa pe.” ");
INSERT INTO tswNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ozo o ro e le a̱ shi ta̱ ɗe e ene Bulu oɓolo na̱ Tarafima vuma va Afisu a̱tsuma̱ a̱ lyuci. Adama o ndolo, a ta dansa u tara yi ta̱ a uwa pe a̱ A̱a̱ꞌisamapaɗaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Reve ugbozu wa ama a̱ lyuci suru u ꞌyon, a̱vu ama a uwa a̱ ta̱wusa̱ ni ilaɗi ba̱ta̱ ba̱ta̱. Ɗaɗa e remei Bulu a̱vu o uta̱a̱ yi a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗa reve a̱ ɓa̱rushi na̱ntsu va̱ A̱a̱ꞌisamapaɗaꞌa. ");
INSERT INTO tswNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ele o mpolo n na oo una yi, ɗaɗa a dammai yali i gbain† yo oɓolo a̱ a̱soja va̱ Roma a na, lyuci suru ta̱ ɗe azama u daɓa na akina. ");
INSERT INTO tswNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Reve u tarashi nan yali na̱ a̱soja o ro, a̱vu a suma a̱ tyo uba̱ta̱ u na ama a̱ ri uɓolotowu. Ana aza a addamaꞌa e enei zagbaiꞌin na̱ a̱soja a̱ yi a̱vu a lyawa malapa ma̱ Bulu. ");
INSERT INTO tswNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","A̱vu yali i gbaiꞌin u reme Bulu, a̱vu u zuwa a̱ nla̱ yi na akani e re. A̱vu we ece oɓolo a amaꞌa ko zane ɗa Buluꞌu, ni ili i na u yuwain waru. ");
INSERT INTO tswNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Reve akapi a saala ili i ro, akapi waru ili i ro koꞌo. Ana wo oꞌwoi a yuwusan ta̱ elemu lon, u gura reve ili i na aa dansa shi, ɗaɗa u zuwa a tarai Bulu a̱ tyo o uꞌwa wa̱ a̱soja. ");
INSERT INTO tswNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ana a rawai a dasata, a̱vu yisaali i yuwan a̱bunda̱ she na a̱sojaꞌa a tanuyi Bulu a̱ nlyungu adama a wawa yi. ");
INSERT INTO tswNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","A̱vu oɓolo a amaꞌa a̱ kuru adansa, “O kototo yi, o kototo yi.” ");
INSERT INTO tswNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","A̱soja azama o oto yi a̱tsuma̱ a aasula o ukari wa̱ a̱soja, a̱vu Bulu damma yali i gbaiꞌin, “Ko vu ta lyawa n yuwan adanshi na̱ a̱vu?” Reve yali i gbaiꞌin u usu a̱tsuma̱ a asalama u damma, “Vu gura ta̱ Tsuheleni?† ");
INSERT INTO tswNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Mu uwwa ta̱ a na a̱vu ɗa za va Masar na ta̱wa̱yi nu uꞌya̱sun wa asuvu, a̱vu vu pura̱ ama a akpaka ukpakukupa una̱shi (4,000) a̱ tyo o ogozo mantsa mo ro ɗe shi. Ne ɗa shi?” ");
INSERT INTO tswNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","A̱vu Bulu usu, “Oꞌo, a̱mu za va Israꞌila ɗa umatsun wa Tarsu, lyuci na ri ili i ro a̱tsuma̱ a Kilikiya. Yuwan ankuri, lyawa n yuwan adanshi na amaꞌa.” ");
INSERT INTO tswNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ana zagbaiꞌin u damma niyi u ta gura yuwan adanshi, reve Bulu isawan o udasata, a̱vu u yuwaan ama iroci ne ekere tsa̱ra̱ a̱ rungwa̱. Ana a̱ rungwa̱i, ɗaɗa u yuwaan nle adanshi na̱ Tsuꞌarama.† ");
INSERT INTO tswNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Ɗaɗa Bulu dammai, “A̱za̱ a̱ va̱ na̱ mbara n va̱, poloi atsuvu yu uwwa adanshi a na maa yuwan adama a aciya̱va̱.” ");
INSERT INTO tswNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ana a uwwa niyi u yuwaan nle adanshi na̱ Tsuꞌarama elentsu e le, a̱ da̱shi ta̱ polo atsuvu. ");
INSERT INTO tswNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","A̱vu Bulu lyuwa elime na adanshi, “A̱mu za va Israꞌila ɗa umatsun wa Tarsu va Kilikiya, a̱tsuma̱ a̱ Urishelima ɗa n kungwai. A̱mu o rito mu ta̱ e ekere a Gamaliya, a̱vu gba u rito mu n kuru Wila̱ wu nkaya n tsu suru. N shi ta̱ no okolo e itoni ya̱ A̱sula̱ mejege. N shi ta̱ ununa suru nɗu i ri anaꞌan. ");
INSERT INTO tswNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","N casu ta̱ vuma na suru kuruyi Ure wu Zagbain nda a̱tsuma̱lima̱, hali gba n zuwa ozo o ro o uꞌwa wa ali, ozo o ro gba hali n zuwa o una le. N ɗangula ko ali a ɗa ko a̱ma̱ci a ɗa shi. ");
INSERT INTO tswNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Aabara a nan ganu na azagbain na aciyele a̱ ta̱ usu ne ɗa a yuwain. Ele ɗa a tsu ca mu mpepelime n na ma̱a̱ ꞌya̱wa̱a̱ uba̱ta̱ wa aza a Israꞌila a̱za̱ a̱ tsu a na a̱ ri Dimaska. Reve n reme a̱za̱ e Itoni ɗe n ta̱wa̱ ne ele Urishelima a mmalu na akani, adama a ca le a̱tsuma̱lima̱.” ");
INSERT INTO tswNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","A̱vu Bulu lyuwa elime, adansa, “Ne ɗa gba urana u ro nu urana a aci a̱mu a marawaa Dimaska, ɗaɗa ekan o ro diga zuva e ikanai zuzu na̱ a̱mu. ");
INSERT INTO tswNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","A̱vu n riya̱ e iɗa, reve mu uwwa uɗyo a dansaa mu, ‘Shawulu, Shawulu, cine tsa ɗa voo ɓongishi mu?’ ");
INSERT INTO tswNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Reve n usu, ‘Zagbain, a̱vu ɗa zane?’ “Reve u usu, ‘A̱mu ɗa Yesu va Nazara, za na voo ɓongishi!’ ");
INSERT INTO tswNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ama a na a̱ shi oɓolo na̱ a̱mu e ene ta̱ ekaꞌan, agba a uwwa uɗyoꞌo shi. ");
INSERT INTO tswNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“A̱vu me ece, ‘Zagbain, nye vu cigai n yuwan?’ “Reve Zagbain usu mu, ‘ꞌYon vu uwa a̱tsuma̱ a Dimaska. Na̱ vu rawa a ta damma wu ili i na vaa yuwan.’ ");
INSERT INTO tswNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","“Reve aza a na a̱ ri oɓolo na̱ a̱mu o rono mu aɗanga a uwa Dimaska, adama a na ucira we ekaꞌan wo oꞌwoto mu ta̱ irumba̱. ");
INSERT INTO tswNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Vuma ro na a̱ tsu ɗe Hananiya shi ta̱ pe na̱ nden a̱tsuma̱ a Dimaska. Vumava̱sula̱ ɗa e ekere e itoni i Wila̱. Aza a Israꞌila a na a̱ ri nden pe suru a tara yi ta̱ vuma va̱ a̱ɓula̱ ɗa. ");
INSERT INTO tswNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Reve u ta̱wa̱ wi isawan zuzu na̱ a̱mu, a̱vu u damma, ‘Iꞌutsa̱ i va̱ Shawulu, ushi yeni ya̱ wu.’ Lo ɗa me eneshi niyi! ");
INSERT INTO tswNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“A̱vu u damma mu, ‘A̱sula̱ a nkaya n tsu a ɗangwa wu ta̱ adama vu reve ili i na u cigai, waru ve ene Za va̱ A̱ɓula̱, a̱vu vu uwwa yi a adanshi. ");
INSERT INTO tswNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Vu to oꞌwo za va alajiya a̱ yi na vaa tara adanshi a̱ tyo uba̱ta̱ biti, a dansaa uvaɗi suru ili i na vu uwwai ni ili i na ve enei waru. ");
INSERT INTO tswNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Gogo mantsa mo ulinga ma ɗa, she vu lungusa̱ mantsa wan. ꞌYon, a̱ rumbu wu, a̱vu vu ɗe ala a̱ yi, adama a̱ za̱za̱ꞌwa̱ unusu wa̱ wu.’ ” ");
INSERT INTO tswNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","A̱vu Bulu damma, “Ana n ka̱mba̱i Urishelima urana u ro, a̱mu a̱tsuma̱ a avasa a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗa, reve me ene alavu alavu. ");
INSERT INTO tswNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Reve me ene Yesu a adanshi. Reve u damma mu, ‘Jika̱ vu uta̱ Urishelima adama a na a̱a̱ usu adanshi a̱ wu a na vaa ca adama a̱ va̱ shi.’ ");
INSERT INTO tswNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Reve n usu, ‘Zagbain, ama e reve ta̱ n ꞌya̱wusa̱ ta̱ a̱ a̱ꞌisa̱ a̱ꞌisa̱ na̱ n remi a̱za̱ e Itoni ya̱ wu na̱ n ruꞌwi nle. ");
INSERT INTO tswNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","O una ta̱ Istifanu adama a na u yuwain adanshi adama a̱ wu. N shi ta̱ lo mishin waru n usu ta̱ ili i na a yuwain, a̱vu m piri a̱tugu a aza a na o una niyi.’ ");
INSERT INTO tswNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Reve Zagbain damma mu, ‘ꞌYon vu ꞌya̱wa̱ n ta̱ lyungusu wu alanga uba̱ta̱ wa Atakpaci.’ ” ");
INSERT INTO tswNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","A̱vu oɓolo a amaꞌa o poloo yi atsuvu hali uba̱ta̱ u na u ɗeyi, “Atakpaci.” Ɗaɗa a̱ ꞌya̱sa̱in uɗyo u le reve a saala, “O kototo cuꞌun vuma nda! O una yi! Wu ntsaa u da̱na̱ wuma shi!” ");
INSERT INTO tswNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Reve a uwa yisaali no o foɗusoi a̱tugu na a kushaꞌwi ma̱bula̱ ne ekere. ");
INSERT INTO tswNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Adama o ndolo reve yali i gbaiꞌin u zuwa o oto Bulu a̱tsuma̱ o ukari wa̱ a̱soja. Reve u zuwa a fufaba yi, adama u reve ili i na i zuwai ama a yuwusan yisaali a aci a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ana a̱ nla̱ niyi azama a fufaba yi, reve Bulu damma yali i na i ri lo mishin, “U lobono ta̱ a fufaba za na ri umatsun u vuma va̱ Roma,† babu a̱ tsura̱ yi nu unusu?” ");
INSERT INTO tswNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ana wu uwwai ne, reve u ꞌya̱wa̱ uba̱ta̱ u yali i gbain ya̱ yi, a̱vu u damma, “Nye i ɗa gba vu cigai vu yuwan? Vuma nda vuma va̱ Roma ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","A̱vu yali i gbaiꞌin u rawa ya̱ Bulu a̱vu we ece yi, “Damma mu, a̱vu vuma va̱ Roma ɗa?” A̱vu u usu, “Ee, a̱mu vuma va̱ Roma ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","A̱vu u damma Bulu, “She na n tsupai ikebe ya̱ a̱bunda̱, ɗaɗa n tsura̱ mo oꞌwoi vuma va̱ Roma.” A̱vu gba Bulu usu, “A̱mu umatsun wa̱ Roma u ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ɗaɗa a̱soja a na a̱ shi a cigai a fufaba yi, a lyawushi ana a uwwai a̱yi umatsun wa̱ Roma u ɗa. A̱yi fo yali i gbain† ya̱ a̱sojaꞌa a̱vu wu uwwa wovon, ana u revei u zuwa ta̱ a̱ nla̱ yi azama a fufaba umatsun wa̱ Roma. ");
INSERT INTO tswNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ana usana u tawai, ana yali i gbaiꞌin u cigai u reve ili i na i zuwai azagbain a aza a Israꞌila a̱ ta̱wa̱yi na adanshi a aci a̱ Bulu, a̱vu u zuwa a̱ ba̱ɗa̱ yi. Ɗaɗa u zuwai nan ganu a gbagbain na Azagbain a Mbara† suru o ɓoloto. Reve u zuwa a uwa na̱ Bulu a̱vu u zuwa yi wi isawan a̱ ma̱ka̱ka̱n me le. ");
INSERT INTO tswNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","A̱vu Bulu varaa Azagbain a Mbara† esu, reve u damma, “A̱za̱ a̱ va̱, hali anaꞌan n ri no okolo ukuɗu shi, ko ili i na yaa damatosun mu shi, adama a wuma u na n yuwain a̱ ma̱ka̱ka̱n ma̱ A̱sula̱.” ");
INSERT INTO tswNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ana u dammai ne, reve Ananiya aabara a nan ganu zuwa ama a na a̱ ri mishin zuzu na̱ a̱yi ɓasa yi o una̱. ");
INSERT INTO tswNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","A̱vu Bulu damma yi, “A̱sula̱ a ta ɓasa wu, a̱vu za vi ikpaꞌa vu ta̱ gashi afili e ishina! Vu da̱nu ta̱ lo, tsa̱ra̱ vu yuwaan mu ugeꞌetosu u Wila̱, a̱vu ɗa nda gba vu zuwai a ɓasa mu, ili i na Wila̱ u putsayi.” ");
INSERT INTO tswNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Reve ama a na a̱ ri mishin zuzu na̱ a̱yi a damma Bulu, “Vu ciga ta̱ vi isula aabara a nan ganu va̱ A̱sula̱?” ");
INSERT INTO tswNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","A̱vu Bulu gba u usu le, “A̱za̱ a̱ va̱, n reve a na a̱yi ɗa aabara a nan ganu shi. Adama a na u tu uɗanu, ‘She vi isula zagbain va ama wan.’ ” ");
INSERT INTO tswNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ana Bulu enei ozo o ro e le aza a Sadukiya a ɗa, ozo o ro gba shi Afarishi,† a̱vu u saala, “A̱za̱ a̱ va̱, a̱mu fo Mafarishi ma ɗa waru mawun ma Mafarishi ma ɗa. O una̱ u na n zuwai okolo a na a̱a̱ ꞌya̱sa̱n a̱kwa̱kwa̱ a̱yi ɗa i zuwai aa yuwusaan mu ugeꞌetosu.” ");
INSERT INTO tswNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ana u dammai ne, reve Afarishiꞌi na aza a Sadukiyaꞌa e teme mawasan va̱ni le, hali e neꞌeshen ure. ");
INSERT INTO tswNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Adama a na aza a Sadukiya† a̱ usu a na nlingata ma̱ A̱sula̱ ko mukabi n ri lo shi, waru a̱ usu nu uꞌyosun wa̱ a̱kwa̱kwa̱ shi. Afarishi gba a̱ usu ta̱ ili i taꞌatsu i ndolo suru. ");
INSERT INTO tswNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Reve e reme mawasan va̱ni le, hali munlu n Wila̱† ma Afarishi n ꞌyon mishin a̱vu a yuwan mawasan o una̱ wa̱ Bulu. A̱vu a̱ ꞌya̱sa̱n uɗyo zuva, adansa, “Tse ene unusu u na vuma nda yuwain shi. Nu ululu u ɗa ko malingata ma̱ A̱sula̱ ma ɗa ma yuwaan niyi adanshi gba?” ");
INSERT INTO tswNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Mawasaꞌan u suɗuwa ta̱ hali amaꞌa a̱ ka̱ra̱ o morono ma̱ Bulu eɓele ra ra ra. Ɗaɗa yali ya̱ a̱soja i bunga̱i ure u na wa̱a̱ ka̱ra̱ na̱ Bulu adama o wovon u na a̱ ta̱wa̱ a kakara yi. Reve u zuwa a̱soja a tara yi a̱ tyo o ukari wa̱ a̱soja. ");
INSERT INTO tswNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Na ayin o ndolo, reve Zagbain ta̱wa̱ uba̱ta̱ wa̱ Bulu a̱vu u damma yi, “Vu gbama okolo, Bulu. Cine vu yuwayin ama adanshi a̱ va̱ Urishelima, ne ɗa fo vaa yuwan alajiya a Alabari a Saꞌani a̱ va̱ a̱ Roma.” ");
INSERT INTO tswNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ana usana u tawai, reve aza a Israꞌila o ɓolo una̱, a̱vu a yuwan akucunu a na aa lyuwa shi, agba oo sowo ili shi, she no o una Bulu. ");
INSERT INTO tswNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ama a na a yuwain akucunu a nda a laꞌa ta̱ ama amunga. ");
INSERT INTO tswNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","A̱vu a̱ ꞌya̱wa̱ uba̱ta̱ u nan ganu a gbagbain na azagbain o ro, reve a damma le ili i na a yuwain. “Tsu nla̱ ta̱ aciya̱tsu na akucunu a na tsaa lyuwa shi waru tsoo sowo shi, she na̱ tsu una Bulu. ");
INSERT INTO tswNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Adama a nda, a̱ɗu Azagbain a Mbara† i damma yali i gbain u ta̱wa̱a̱ ɗu na̱ a̱yi, vadamma i ciga ta̱ i da̱shi petelyuwe adanshi a̱ yi ulobonu. Reve a̱tsu gba tsu da̱na̱ uvawun tsa̱ra̱ tsu una yi o ure.” ");
INSERT INTO tswNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ana mawun ma zakpara ma̱ Bulu ma uwwai ili i na o foɓoi a na aa yuwan na̱ a̱yi, reve u ka̱ra̱ a̱ tyo o ukari wa̱ a̱soja a̱vu u ka̱mbuwa̱ Bulu. ");
INSERT INTO tswNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","A̱vu Bulu ɗe yali i ta̱ a̱tsuma̱ a̱ a̱soja a̱ Romaꞌa. Reve u damma yi, “Vu ꞌya̱wa̱ nu ulobo u nda a zagbain va̱ wu, u ta̱ ni ili i na waa damma yi.” ");
INSERT INTO tswNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","A̱vu vuma u usu, a̱vu u tara uloboꞌo a̱ ꞌya̱wa̱ uba̱ta̱ u na zagbaiꞌin u ri. Reve u damma, “Vuma na ri o uꞌwa wa ali na a̱ tsu ɗe Bulu ɗa pati numu n tara ulobo u nda a̱ ta̱wa̱ uba̱ta̱ wa̱ wu, adama a na u ta̱ na adanshi a na u cigai u damma wu.” ");
INSERT INTO tswNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","A̱vu yali i gbain† ya̱ a̱sojaꞌa u guza̱ yi ukere, reve a̱ tyo a̱ mɓa̱nga̱, a̱vu we ece yi, a̱yi a̱ ndeꞌen, “Nye vu cigai vu damma mu?” ");
INSERT INTO tswNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Reve u usu yi, “Ama o ro a ta zama a pati wu vu ꞌya̱wa̱ na̱ Bulu uba̱ta̱ wa Azagbain a Mbara† a aza a Israꞌila nfaꞌan. A ta damma a ciga ta̱ e petelyuwishe adanshi a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Amma she vu tara yi a̱ ꞌya̱wa̱ wan! Ama upasu na amunga a̱ ta̱ ɗe uva̱pu azama o una Bulu o ure. A kucina ta̱ a na aa lyuwa shi, waru oo sowo shi, she no o una yi. A̱ tu ufoɓu a pura vu usu ipati i le.” ");
INSERT INTO tswNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","A̱vu yali i gbaiꞌin u damma yi, “She vu lyawa za reve a na vu damma numu adanshi a nda wan.” A̱vu u lyawa yi u ka̱ra̱. ");
INSERT INTO tswNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ana uloboꞌo u ka̱ra̱i, a̱vu yali i gbaiꞌin u ɗe nan yali e re, reve u damma le, “I foɓo na ya̱a̱ ka̱ra̱ a̱ ꞌya̱wa̱ Kasariya ni irumu kucci va ayin oɓolo na̱ a̱soja ukpakure (200), na̱ a̱soja a na a tsu kumba ido kupocindere (70), na̱ a̱soja ukpakure (200) na a tsu yuwan nla̱ngi ni ibata. ");
INSERT INTO tswNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","A̱ɗu waru i zamiya Bulu ido i na waa kumba. A̱vu i ꞌya̱wa̱to yi uba̱ta̱ wa gwamna Feli gbaga.” ");
INSERT INTO tswNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","A̱vu yali i gbaiꞌin u ɗana mepepelime ma nda a̱ tyo ya gwamnaꞌa: ");
INSERT INTO tswNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“A̱mu Kaladiya Lisiya n te ica̱su yi zagbain gwamna Feli: ");
INSERT INTO tswNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","“Aza a Israꞌila o ro e reme ta̱ vuma nda, reve a̱ shi a ciga o una yi. Amma ana n revei vuma va̱ Roma ɗa, ɗaɗa n jika̱i oɓolo na̱ a̱soja a̱ va̱ reve n wawa yi. ");
INSERT INTO tswNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ana gba n cigai n reve unusu wa̱ yi, reve n tara yi a̱ tyo o ukobu wa Azagbain a Mbara† n le. ");
INSERT INTO tswNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Diga na n revei nronuloi n na aa yuwusan na̱ a̱yi adama a̱ Wila̱ u le ɗa. Reve me ene ili i na i rawai a zuwa yi o uꞌwa wa ali ko o una yi ɗa shi. ");
INSERT INTO tswNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","A̱vu waru nanza damma mu ifoɓi i na aa yuwusan, tsa̱ra̱ o una yi, a̱yi ɗa i zuwai n zuwai a tara niyi a̱ tyo ya̱ꞌa̱ wu. Waru n damma ta̱ aza a na a̱ ri na adanshi na̱ a̱yi a̱ ta̱wa̱ uba̱ta̱ wa̱ wu.” ");
INSERT INTO tswNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Na ayin o ndolo, ɗaɗa a̱sojaꞌa a tarai Bulu a̱ tyo a̱ lyuci va Antipatari ununa zagbain le damma nle. ");
INSERT INTO tswNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ana usana u tawai, reve a lyawa a̱soja a na a tsu kumbusa ido a tara yi o koso tyo Kasariya. Reve a̱soja e iɗa a̱ ka̱ra̱ a̱ ka̱mba̱ o ukari wa̱ a̱soja u le. ");
INSERT INTO tswNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ana a rawai Kasariya, reve a ca Bulu e ekere a gwamnaꞌa na̱ mepepelimeꞌe. ");
INSERT INTO tswNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ana gwamnaꞌa u ɗeyinuna̱ e mepepelime ma na a ca niyi, reve we ece Bulu ko a̱yi za vi iɗa i ne i ɗa. A̱vu Bulu usu a na, “A̱mu za va Kilikiya ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","A̱vu gwamna u usu yi, “N to polo atsuvu a̱ va̱ mu uwwa adanshi a̱ wu, a mantsa ma na aza a na a̱ ri na adanshi na̱ a̱vu, a̱ ta̱wa̱i.” Reve u zuwa a kpada yi pe o uꞌwa u na Hiridu† suwai. ");
INSERT INTO tswNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ana a yuwain rana ton, a̱vu ama o ro a̱ ta̱wa̱ diga Kasariya adama a damma unusu u na Bulu yuwain. Ananiya aabara a nan ganu a ɗa a̱ da̱na̱i na azagbain a Israꞌila na̱ Taratulu za va adanshi a mantsa mo ugeꞌetosu. ");
INSERT INTO tswNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ana e ɗeyi Bulu a uwa o ukobu wa̱ Feli, a̱vu Taratulu damma gwamna unusu wa̱ Bulu. Reve u damma, “Zagbain Feli, nu ujimu vu ta̱wa̱ ta̱ na̱ nden mo okolo a̱tsuma̱ a̱ tsu, waru vu yuwan ta̱ ulinga nu ugbozu wa̱ wu, waru o una̱ u na vu ri na̱ majiyan me elime, a̱yi ɗa i zuwai ama a̱ tsu a̱ ri a̱ nden mu ulobonu. ");
INSERT INTO tswNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Zagbain Feli, ama a̱ tsu uba̱ta̱ suru o to godyusho wu. ");
INSERT INTO tswNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Amma n ka̱ɗa̱towa̱ wu ta̱ vu yuwaan mu ankuri, vu ca mu ugbozu wa̱ wu neꞌen keꞌen, tsa̱ra̱ n damma wu unusu u na tsu remei vuma nda na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Tsu reme ta̱ vuma nda za vu uꞌya̱sa̱sa̱n wo okolo wa ama a ɗa. Vuma na zuwusai aza a Israꞌila a̱tsuma̱ o uvaɗi suru nla̱ngi. Waru a̱yi zagbain vo moɓolo ma Aza a Nazara ɗa. ");
INSERT INTO tswNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Hali u shi ta̱ u ciga u lungusa̱ tsu A̱a̱ꞌisamapaɗa. Ɗaɗa tsu reme niyi.  ");
INSERT INTO tswNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","“Tsu shi ta̱ tsu ciga tsu geꞌeto yi na̱ Wila̱ u tsu. Agba Lisiya yali i gbain u usa yi ta̱ nu ukadu e ekere a̱ tsu. A̱vu u zuwa tsu tsu ta̱wa̱ o ukobu wu ugeꞌetosu wa̱ wu, tsa̱ra̱ tsu damma wu unusu u vuma u nda. ");
INSERT INTO tswNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","“Vu ta̱ tsura̱ amayun e ili i na tsaa dansa e ekere a̱ yi nna̱ vu koto yi ugbozu na̱ yeci na aciya̱wu.” ");
INSERT INTO tswNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Reve aza a Israꞌila a̱ usu, a na mejege ma ɗa ili i na Taratulu dammai suru. ");
INSERT INTO tswNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ana gwamna damma niyi u yuwan adanshi, a̱vu Bulu usu yi, “Zagbain Gwamna, n reve ta̱ a na vu ta̱ geꞌetosu ama e iɗa i tsu aꞌwan na̱ a̱bunda̱. Waru n ta yuwan adanshi adama a aciya̱va̱ na̱ ma̱za̱nga̱. ");
INSERT INTO tswNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Vu ta gura kari mu ana, a̱vu vu reve babu usa̱n u ka̱ra̱ rana kupa ne ejere shi a na n ꞌya̱wa̱i Urishelima adama n yuwan a̱ga̱nda̱ a̱ A̱a̱ꞌisamapaɗa. ");
INSERT INTO tswNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","N yuwan mawasan na̱ za a̱tsuma̱ a̱ A̱a̱ꞌisamapaɗa shi. Waru n zuwa nla̱ngi ko a̱ a̱a̱ꞌisa̱ a̱ ta̱ shi, ko araꞌan a̱tsuma̱ a̱ lyuci shi. ");
INSERT INTO tswNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Adanshi a na ama a nda adansa aa gura damma wu mejege ma adanshiꞌi ununa u ri shi. ");
INSERT INTO tswNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Gogo ili i ta̱ i ɗa ma̱a̱ usu, ana a dammai n ta̱ kurusu Ure wu Zagbain u na aa dansa amayun a ɗa shi. Agba n tsu yuwaan ta̱ A̱sula̱ a nkaya n tsu a̱ga̱nda̱, waru n usu ta̱ ili suru i na i ri uɗanu a atagada a Ama̱sula̱. ");
INSERT INTO tswNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","N ta̱ nu uzuwu wo okolo a̱ tyo e ekere a̱ A̱sula̱ a̱ ta̱ ꞌya̱sa̱n a̱za̱ a̱ a̱ɓula̱ na aza a na e revei A̱sula̱ shi diga a̱tsuma̱ a̱ a̱a̱kwa̱kwa̱, ne ɗa fo ama a nda a̱ da̱na̱i nu uzuwu wo okolo. ");
INSERT INTO tswNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","A̱yi ɗa i zuwai n cigai n yuwan wuma u saꞌani adama n tsura̱ nden mo okolo a̱ ma̱ka̱ka̱n ma̱ A̱sula̱ na ama suru. ");
INSERT INTO tswNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“N jima ta̱ ana n ta̱wa̱i Urishelima. Gogo, n ta̱wa̱ ta̱ ni ikebe i na maa kamba ama a̱ va̱ ne ele, a̱vu waru n yuwaan A̱sula̱ kucci. ");
INSERT INTO tswNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","A mantsa ma na aza a na a karishi mu ana e ene numu a̱ A̱a̱ꞌisamapaɗa, n da̱na̱ ta̱ o mokotoo ma̱ a̱ga̱nda̱ a matawa ma̱ nshinda̱. Ama a̱ da̱na̱ oɓolo na̱ a̱mu shi, waru ko za da̱na̱ a̱ nla̱ngi shi. ");
INSERT INTO tswNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","U ta̱ da̱na̱ ulobonu ama a Israꞌila diga e iɗa ya Asiya a na a̱ da̱na̱i lo a̱ ta̱wa̱ pa nna a ciga ta̱ a kari mu ana. ");
INSERT INTO tswNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Waru ama a na a̱ ri pa a damma wu unusu u na Azagbain a Mbara† e reme numu na̱ a̱yi, ana a yuwain ugeꞌetosu wa adanshi a nda. ");
INSERT INTO tswNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ili i ta̱ i na a gura damma a aci a̱ va̱ a̱yi ɗa, a na n yuwan ta̱ adanshi a nda nu uɗyo zuva o ukobu wu ugeꞌetosu u le, ‘Anaꞌan n ta̱ a̱ a̱tsuma̱lima̱ adama a na n cayi okolo a na a̱a̱ ka̱mba̱to a̱kwa̱kwa̱ wuma.’ ” ");
INSERT INTO tswNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feli gwamna vuma ɗa na da̱na̱i nu urevu wu Ure wu Zagbain, reve wi isawaton le, a̱vu u damma, “Na̱ Lisiya zagbain vu ukari wa̱ a̱soja wa̱ Urishelima ta̱wa̱, ɗaɗa moo koto ugeꞌetosu.” ");
INSERT INTO tswNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","A̱vu u zuwa yali piri Buluꞌu, agba she a kpa̱to yi wan. Waru she a putsaa nꞌutsa̱ ma̱ yi n kamba yi wan. ");
INSERT INTO tswNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ana a yuwain rana meketeci, a̱vu Feli ta̱wa̱ na̱ ka va̱ yi. Za na a̱ tsu ɗe Durusila, waru za va Yahuda ɗa da̱na̱i. A̱vu a̱ lyungu vuma ro ɗewe le Bulu, reve o polo atsuvu e le ana waa dansaa le adama o ucawu wo okolo e ekere e Yesu Za vi Iwawi. ");
INSERT INTO tswNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Bulu yuwan ta̱ adanshi ne ele adama a̱ a̱ɓula̱, nu uguzu wa aci, nu ugeꞌetosu u na u ri lo a̱ ta̱wa̱, a̱vu adanshiꞌi a̱ juꞌwa̱n Feli lon. Reve u damma Bulu, “U rawa ta̱ ne neꞌen. Vu ta gura ka̱ra̱. Amma na̱ n tsura̱ mantsa, n ta̱ lyunguwa̱ wu vu ta̱wa̱.” ");
INSERT INTO tswNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","U ta zuwusa okolo gashi Bulu ta ca yi ikebe, ɗaɗa waa yuwusan uro na̱ a̱yi kuci adama wu uwwusa ili i na vuma nda aa damma. ");
INSERT INTO tswNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ana a yuwain aꞌwan e re a yuwusan ne, a̱vu o uta̱a̱ Feli o ootogu a̱ yi. Reve Poruku Fesutu wo oꞌwo gwamna. Amma o una̱ u na Feli cigai u tsura̱ icigi e ekere a azagbain a Yahuda, a̱vu u lyawa Bulu o uꞌwa wa ali. ");
INSERT INTO tswNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fesutu rawa ta̱ Kasariya, tsa̱ra̱ u fara ulinga u tsugwamna. Ana u yuwain rana taꞌatsu, reve u lyawa Kasariya u ka̱ra̱ a̱ tyo Urishelima. ");
INSERT INTO tswNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Pe ɗa nan ganu a gbagbain na azagbain o ro a Israꞌila a cina niyi adama a̱ Bulu. A̱vu waru e ece yi ");
INSERT INTO tswNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ko u ta ciga u ta̱wa̱ na̱ Bulu Urishelima. A pati yi ta̱ u ta̱wa̱ na̱ a̱yi, adama a na a ta azama a vawan yi, tsa̱ra̱ o una yi a mantsa ma mmalu. ");
INSERT INTO tswNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","A̱vu Fesutu usu le, “Bulu tu ugutsuwu a Kasariya, waru maa jima shi, n ta̱ ꞌya̱wa̱ ɗe na aciya̱va̱. ");
INSERT INTO tswNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Nnu u yuwan ili i na i lobonoi shi, i lyawa azagbain a̱ ɗu a̱ kuru mu, a̱vu a damma ili yu uwuyanu i na u yuwaan nɗu ɗe.” ");
INSERT INTO tswNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesutu da̱na̱ ta̱ ɗe Urishelima hali rana kunla̱ a̱ tyo rana kupa, a̱vu u ka̱ra̱ a̱ tyo Kasariya. Ana usana u tawai, reve u da̱nu o ukobu wu ugeꞌetosu, a̱vu u damma le a̱ ta̱wa̱ na̱ Bulu. ");
INSERT INTO tswNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Bulu a maꞌuwaa, a̱vu azagbain a Israꞌila a na a̱ ta̱wa̱i diga Urishelima o ɓoloto a̱ ka̱nda̱ruwa̱ yi e memere. A̱vu a damma ili yu uwuyanu ya̱ a̱bunda̱ a na u yuwain, agba a gura damma amayun a adanshi a̱ ta̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Bulu gba u wasan ta̱ ili i na a dammai suru a aciya̱yi, reve u damma, “N ri nu unusu shi. N yuwan unusu a̱ tyo a̱ Wila̱ wa aza a Israꞌila shi, ko a̱ A̱a̱ꞌisamapaɗa, ko a̱ tyo a gwamnati va̱ Roma shi.” ");
INSERT INTO tswNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fesutu shi ta̱ ciga u yoꞌonoto azagbain a Israꞌila okolo. Ɗaɗa we ecei Bulu, “Ko vu ta̱ usu vu ka̱ra̱ a̱ tyo Urishelima, tsa̱ra̱ a yuwaan wu ɗe ugeꞌetosu wa adanshi a nda a̱ ma̱ka̱ka̱n ma̱ va̱?” ");
INSERT INTO tswNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","A̱vu Bulu usu, “Oꞌo! Ukobu wu ugeꞌetosu u nda wa̱ Roma u ɗa, adama a nda a ɗa aa yuwaan mu ugeꞌetosu pa. A̱vu na aciya̱wu vu reve ta̱ na n ri nu unusu e ekere a aza a Israꞌila shi. ");
INSERT INTO tswNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nna̱ n yuwan ta̱ ili i na i rawai o una mu, n ꞌyuwan yu una mu shi. Amma nna̱ n ri nu unusu shi, ko a̱vu ko za ro lo na rawai u ca mu e ekere a ama a nda hali o una mu shi. N te ipati a tara adanshi a nda a̱ tyo ya Kaisa† mogono ma̱ Roma.” ");
INSERT INTO tswNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Reve Fesutu dammulai na̱ a̱za̱ o ucasu wa̱ a̱sa̱la̱ a̱ yi, a̱vu u usu yi, “U lobono ta̱! Vu pati ta̱ a̱ tyo ya Kaisa, vu ta̱ gba a̱ tyo ya Kaisa!” ");
INSERT INTO tswNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ana a yuwain rana re, a̱vu Agaripa mogono na̱ ka va̱ yi Baranisi a̱ ta̱wa̱ Kasariya, tsa̱ra̱ a raba Fesutu. ");
INSERT INTO tswNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","A̱ da̱nu ta̱ ɗe rana meketeci, ana Fesutu ka̱mbuwa̱i Agaripa mogono adanshi a na a dansa adama a̱ Bulu. A̱vu u damma, “Vuma na a zuwai o uꞌwa wa ali ta̱ pa, za na Feli lyawai o uꞌwa wa ali, tsa̱ra̱ n yuwan ugeꞌetosu wa adanshi a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ana n da̱na̱i Urishelima, nan ganu a gbagbain na azagbain a Israꞌila a yuwusan ta̱ adanshi a̱ yi, hali a patishi mu m paɗaa yi ugana wu ukwa̱. ");
INSERT INTO tswNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Amma n damma le ta̱, a̱tsu a̱za̱ a̱ Roma u ri n yuwan tsu yuwaan za vu unusu ugeꞌetosu shi, she na̱ a̱ ꞌya̱wa̱ na̱ a̱yi uba̱ta̱ a̱za̱ e iɗa. Waru a tsu lyawa yi ta̱ u yuwan adanshi a na a̱ ꞌya̱wa̱i na̱ a̱yi o ukobu wu ugeꞌetosu a̱ ma̱ka̱ka̱n ma aza a na a̱ ꞌya̱wa̱i na adanshiꞌi. ");
INSERT INTO tswNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Adama o ndolo, ana a̱ ta̱wa̱i pa oɓolo na̱ a̱mu, n lungusa̱ mantsa shi, n da̱nu ta̱ o ootogu o ugeꞌetosu, a̱vu n zuwa a̱ ta̱wa̱a̱ mu na̱ a̱yi. ");
INSERT INTO tswNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Agba ana amaꞌa a̱ ꞌyoyin a na aa yuwan adanshi a na a̱ ri na̱ a̱yi a̱ tyo e ekere a̱ Bulu, a gura damma ko ili i ta̱ yu uwuyanu i na n shi aa majiyan a damma shi. ");
INSERT INTO tswNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Adanshi e Itoni i le a ɗa, waru adama a za na a̱ tsu ɗe Yesu na kuwa̱i a na Bulu gba a dansa u ta̱ wuma. ");
INSERT INTO tswNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","A̱mu gba n shi ta̱ n lamba ununa ma kari yi ana a adanshi a nda. Reve me ece yi ko u ta̱ usu u ꞌya̱wa̱ Urishelima tsa̱ra̱ a yuwaan yi ugeꞌetosu wa adanshi a nda. ");
INSERT INTO tswNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Bulu gba u pati ta̱ a lyawa mogono ma gbain ma uwwa adanshiꞌi. Ɗaɗa n zuwai a zuwa yi o uꞌwa wa ali hali n foɓo, a̱vu n tara yi a̱ ꞌya̱wa̱ ya Kaisa.” ");
INSERT INTO tswNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","A̱vu Agaripa damma Fesutu, “N ta ciga mu uwwa ili i na vuma nda aa damma.” Ɗaɗa Fesutu damma niyi, “Nfaꞌan, vu ta uwwa yi.” ");
INSERT INTO tswNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ana usana u tawai, a̱vu Agaripa na̱ Baranisi o oto itana i tsugono reve a̱ ta̱wa̱ oɓolo na azagbain a̱ a̱soja na azagbain a̱ lyuci. A̱vu Fesutu zuwa a̱ ta̱wa̱ na̱ Bulu. ");
INSERT INTO tswNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","A̱vu Fesutu yuwaan le adanshi u damma, “Mogono Agaripa oɓolo no omocin a gbagbain a na a̱ ri pa, ka̱lyuwa̱i vuma nda! Aza a Israꞌila a na o uta̱i Urishelima na̱ Kasariya suru a̱ ta̱wa̱ ta̱ ya̱ꞌa̱ va̱ a patishi mu n zuwa o una yi. ");
INSERT INTO tswNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Agba a̱ yindi i va̱, u yuwan ili i na i rawai o una yi shi. Ana wo oꞌwoi u pati ta̱ a̱ ꞌya̱wa̱ na adanshi a̱ yi o ukobu u mogono ma gbain, a̱yi ɗa i zuwai n jiyain n ꞌya̱wa̱ na adanshi a̱ yi uba̱ta̱ u mogono ma̱ Roma.† ");
INSERT INTO tswNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Agba n ri na amayun a adanshi na maa ɗanaa mogono adama a vuma a nda shi. A̱yi ɗa i zuwai n ta̱wa̱i na̱ a̱yi a̱ ma̱ka̱ka̱n ma̱ ɗu suru. Waru n ta̱wa̱ ta̱ na̱ a̱yi a̱ ma̱ka̱ka̱n ma̱ wu, mogono Agaripa. Na̱ tsu koto adanshi a̱ yi, ɗaɗa ma̱a̱ tsura̱ ili i na maa ɗana. ");
INSERT INTO tswNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","A̱ yindi i va̱ u to oꞌwo ulambu wu ugbozu n tara vuma na ri o uꞌwa wa ali a̱ tyo o ukobu u mogono ma gbain babu mejege ma adanshi e ili i na u yuwain!” ");
INSERT INTO tswNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","A̱vu Agaripa damma Bulu, “Vu yuwan adanshi na aciya̱wu, mu uwwa.” A̱vu Bulu ꞌya̱sa̱n ekere a̱ yi zuva, tsa̱ra̱ ama a̱ rungwa̱. Reve u teme adanshi, a̱vu u damma, ");
INSERT INTO tswNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Mogono Agaripa, n ta̱ na̱ ma̱za̱nga̱ a na n tsura̱i mantsa ma na maa yuwan adanshi a̱ ma̱ka̱ka̱n ma̱ wu anaꞌan. N geshe aciya̱va̱ adama a adanshi a na ama a̱ va̱ a̱ ta̱wa̱yi uba̱ta̱ wa̱ wu. ");
INSERT INTO tswNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","N reve ta̱ vu ta̱ nu urevu wa agadu a aza a Israꞌila lon na̱ cuꞌun vu nden n le. Gogo, vu yuwan ankuri vu polo atsuvu a̱ wu vu uwwa mu ulobonu! ");
INSERT INTO tswNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“A kungwato mu ta̱ a Tarsu nu urevu wi ili suru wa aza a Israꞌila na̱ a̱tsuma̱ a̱ Urishelima. Azagbain a Israꞌila a̱ ta̱ nu urevu u nda suru. ");
INSERT INTO tswNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","E reve mu ta̱ nu ujimu, waru a̱ ta̱ nu urevu u na a̱mu Mafarishi ma ɗa, aza a na a laꞌai wila̱ a̱tsuma̱ o ure wi itoni i tsu. A ta gura damma ne, nna̱ a ciga a damma mejege. ");
INSERT INTO tswNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Gogo, n ta̱ mishin e geꞌetosu mu adama o uzuwu wo okolo a na n zuwai a nzuwulai n na A̱sula̱ a yuwayin ama a̱ tsu nu ujimu. ");
INSERT INTO tswNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Nzuwulai n nda n ɗa n zuwai gundo tsu kupa ne ejere a yuwusaan A̱sula̱ a̱ga̱nda̱ urana na ayin. Nzuwulai n nda n ta̱wa̱a̱ ta̱ nu uzuwu wo okolo. Mogono ma̱ va̱, adama a na n ri nu uzuwu wo okolo a nda a ɗa aza a Israꞌila a̱ ta̱wa̱yi na adanshi a̱ va̱ pa nda. ");
INSERT INTO tswNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Nye i zuwai woo oꞌwo usa̱n vuma usu a na A̱sula̱ a̱ tsu ꞌya̱sa̱n ta̱ a̱kwa̱kwa̱? ");
INSERT INTO tswNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“A̱mu aciya̱va̱ n shi ta̱ n ciga n putsaa na̱ malyuwa me elime na̱ mayan ma adanshi e Yesu va Nazara. ");
INSERT INTO tswNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nan ganu a gbagbain a ca mu ta̱ ucira u na maa yuwan ili i nda suru, waru n reme ta̱ a̱za̱ e Itoni na̱ a̱bunda̱ a̱ Urishelima, reve n zuwa ukere u va̱ fo tsa̱ra̱ o unusa le. ");
INSERT INTO tswNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","N zuwa ta̱ a fufaba le a mantsa na̱ a̱bunda̱ a̱tsuma̱ a̱ a̱ꞌisa̱, ko u ta zuwa le a wasan Kristi Zamawawa. N da̱na̱ ta̱ na̱ tsushuꞌun ne ele lon, hali n karishi le ana a̱ tyo e ilyuci ya alanga e iɗa yo omocin, a̱vu n zuwa le ɗe a̱tsuma̱lima̱.” ");
INSERT INTO tswNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","A̱vu Bulu lyuwa elime, adansa, “Urana u ro n da̱na̱ ta̱ a̱tsuma̱ a mmalu a̱ tyo Dimaska, tsa̱ra̱ n yuwan ulinga u nda, na̱ mepepelime ma na ma̱ ri nu ucira u na nan ganu a gbagbain a zuwai ukere. ");
INSERT INTO tswNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mogono, a̱ tyo o urana a aci, ɗaɗa ekan a na a laꞌai ekan o urana o uta̱i ɗe zuva, a̱vu u reme mu esu oɓolo na aza a na a̱ da̱na̱i na̱ a̱mu. ");
INSERT INTO tswNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","A̱tsuma̱ a̱ tsu, koyan riya̱ ta̱ e iɗa. Reve mu uwwa uɗyo a yuwusaan mu adanshi na̱ Tsuꞌarama,† adansa, ‘Shawulu, Shawulu, nye i zuwai voo ɓongishi mu? Tsulo tsa ɗa na̱ nan yuwan nla̱ngi na aaɗanga a aguɓa.’ ");
INSERT INTO tswNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Reve me ece, ‘A̱vu ɗa gba zane, Zagbain?’ “A̱vu Zagbain u usu, ‘A̱mu ɗa Yesu za na voo ɓongishi. ");
INSERT INTO tswNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ꞌYon gogo! Ili i na i zuwai n ta̱wa̱i uba̱ta̱ wa̱ wu gogo, n ɗangula wu ta̱ vo oꞌwo aagbashi a̱ va̱, reve waru vu damma ili i na ve enei. Vu ta damma uvaɗi ili i na i farai pa, na̱ mantsa mo ro na̱ ve ene mu. ");
INSERT INTO tswNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","N ta̱ lyungusu wu a̱ tyo uba̱ta̱ wa aza a Israꞌila, waru n ta lyungusu wu a̱ tyo uba̱ta̱ wa Atakpaci. N te keɗe wu na̱ va̱a̱ ꞌya̱wa̱ uba̱ta̱ u na n lyungu nuwu. ");
INSERT INTO tswNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","N ta ciga vu kpa̱tuꞌwa̱ esu e le, reve waru vu vadala le a lyawa irumbu a̱ tyo uba̱ta̱ e ekan. A̱vu a vadala a lyawa ucira u Male a̱ ka̱mba̱ uba̱ta̱ wa̱ A̱sula̱. A̱sula̱ a ta yuwaan le gafura vu unusu u le, a̱vu a̱ tsura̱ ure oɓolo na ama a na a tawai nshinda̱ n le adama o ucawu wo okolo e le ya̱ꞌa̱ va̱.’ ” ");
INSERT INTO tswNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","A̱vu Bulu damma waru, “Ne ɗa waru, mogono Agaripa, n wasan shi. ");
INSERT INTO tswNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","N fara ta̱ yuwaan aza a Dimaska alajiya. A̱vu n ka̱ra̱ a̱ tyo Urishelima hali a̱ tyo e iɗa ya Yahuda. Reve waru n ka̱ra̱ a̱ ꞌya̱wa̱ uba̱ta̱ wa Atakpaci. A̱vu n damma le, ama suru a lyawa mayan mo unusu, a̱vu a vadala a̱ ka̱mba̱ uba̱ta̱ wa̱ A̱sula̱. Reve a yuwan isaꞌani tsa̱ra̱ o roco ama a na a vadalai. ");
INSERT INTO tswNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","“A̱yi ɗa i zuwai aza a Israꞌila e reme numu a̱ A̱a̱ꞌisamapaɗa, azama o una mu. ");
INSERT INTO tswNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Amma A̱sula̱ a kamba mu ta̱, a̱yi ɗa i zuwai n ri wuma anaꞌan, tsa̱ra̱ n damma ama amayun a nda, diga a vuma keꞌen hali a̱ tyo o mogono ma gbain. Ili i na n dammai suru ili i na ama̱sula̱ na̱ Musa dammai ɗa na yaa fara. ");
INSERT INTO tswNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ili i na gba yaa fara, ele ɗa Zamawawa to sowo a̱tsuma̱lima̱, a̱yi ɗa waru wo oꞌwoi vuma vu ufaru na ꞌyoyin a̱tsuma̱ a̱ a̱kwa̱kwa̱, waru u ta̱ da̱na̱ ekan e ekere a aza a Israꞌila na Atakpaci.” ");
INSERT INTO tswNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Bulu a̱tsuma̱ adanshi, reve Fesutu yuwan adanshi nu uɗyo zuva, “Bulu vu jaara ta̱ wayan? A̱bunda̱ e ɗesununa̱ u zuwa ta̱ ma̱puna̱ ma̱ wu ma̱ sa̱da̱!” ");
INSERT INTO tswNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","A̱vu Bulu ka̱mbuwa̱ yi, “N jaara shi, Zagbain Fesutu. Ili i na maa dansa amayun a ɗa, waru u ta̱ nu urevu u saꞌani. ");
INSERT INTO tswNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Agaripa mogono u ta̱ nu urevu wi ili i nda. N ta yuwusan adanshi babu wovon, n reve ta̱ u ta̱ nu urevu wi ili i na i farai ɗe nu ujimu. Ili i nda i fara o oboguzu o ro usokowu shi. ");
INSERT INTO tswNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Agaripa mogono, vu ca ta̱ okolo na ama̱sula̱? N reve ta̱ vu ca ta̱—” ");
INSERT INTO tswNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Reve Agaripa gbandara yi neꞌen, “Vu ta a majiyan vu to oꞌwoto mu za vi Itoni a mantsa waꞌa?” ");
INSERT INTO tswNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","A̱vu Bulu usu yi, “Ko nu u tara mantsa me keꞌen ko mantsa ma̱ a̱bunda̱, avasa a̱ va̱ a̱yi ɗa a̱vu na aza a na a uwwusa mu anaꞌan yoo oꞌwo ununa a̱mu n ri! Shede maa ciga ɗu i da̱na̱ wunlu na akani a nda shi.” ");
INSERT INTO tswNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","A̱vu mogono Agaripa, na̱ gwamna Fesutu, na̱ Baranisi, na aza a na a̱ da̱na̱i oɓolo ne ele suru a̱ ꞌyon reve a̱ ka̱ra̱ a lyawa uba̱ta̱ꞌa̱. ");
INSERT INTO tswNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ana a dammulai va̱ni le, a̱vu a damma, “Vuma nda yuwan ili i na i rawai o una yi shi, ko a zuwa yi o uꞌwa wa ali shi.” ");
INSERT INTO tswNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Hali Agaripa damma Fesutu, “O una̱ u na u pati ntsu tsu ꞌya̱wa̱ na adanshi a̱ yi ya̱ Kaisa ɗa goon yaa putsaa tsu tsu lyawa yi.” ");
INSERT INTO tswNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ana mantsa ma na tsa̱a̱ ka̱ra̱ a̱ tyo Italiya yuwain, a̱vu a zuwa Bulu na akapi a ama a na a̱ da̱na̱i o uꞌwa wa ali e ekere a yali ya̱ a̱soja i na a̱ tsu ɗe Juliyo tsa̱ra̱ u ka̱lyuwa̱ le. U da̱na̱ ta̱ pe a̱tsuma̱ a azagbain a̱ a̱soja a na a̱ tsu ɗe A̱soja a Kaisa Mogono. ");
INSERT INTO tswNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Arista da̱na̱ ta̱ fo oɓolo na̱ a̱tsu. A̱yi vuma lyuci va Tasalonika ɗa upasu wi iɗa ya Makidoniya. Tsu uwa ta̱ wantsun u na wu uta̱i Adaramiti. Ama a na a̱ luwusa̱ wantsuꞌun a̱ shi ta̱ a yuwan majiyan ma na e isawan a̱ mulyuci n na n ri a̱ ngeꞌen m mala mi iɗa ya Asiya. ");
INSERT INTO tswNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ana usana u tawai, reve tsu uwa a̱tsuma̱ e iɗa ya Sida. Juliyo zagbain va̱ a̱soja u yuwusaan ta̱ Bulu isaꞌani lon. Hali u lyawusa yi u ka̱lyuwusa̱ nꞌutsa̱ ma̱ yi, tsa̱ra̱ a ca yi ili i na u cigai suru. ");
INSERT INTO tswNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ana tsu lyawai lyuci va Sida a̱vu upepu u purusa̱ tsu, a̱vu tsu ka̱ra̱ a̱ tyo zuzu ni iɗa i memere ma̱ mini ma̱ Kuburu, tsa̱ra̱ tsi ivuwan nu upepuꞌu. ");
INSERT INTO tswNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Reve tsu ka̱ra̱ a̱ tyo uyagi a̱ mɓa̱nga̱ ma Kilikiya na̱ Bamafiliya, hali tsu rawa a̱ lyuci va Mira e iɗa ya Likiya. ");
INSERT INTO tswNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ɗaɗa yaliꞌi u tsura̱i wantsun u na wu uta̱i diga a̱ lyuci va Iskandariya waru u da̱na̱ ta̱ a̱ tyo Italiya. Adama o ndolo a ɗa u zuwa ntsu, tsu uwai a wantsuꞌun. ");
INSERT INTO tswNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Tsu yuwan ta̱ mmalu ma̱ a̱tsuma̱lima̱ mu upepu ni ikeɗu i mala rana kpara. Ana tsu yuwain a̱tsuma̱lima̱ lon, reve tsu rawa zuzu na̱ lyuci va Kinida. A̱vu upepu u putsaa tsu a na tsa̱a̱ ka̱ra̱ elime. Ɗaɗa tsu ka̱nda̱ruwa̱i a̱ tyo e iɗa i memere ma̱ mini ma Karita zuzu nu uba̱ta̱ u na a̱ tsu ɗe Salamani, upasu u na Karita ee geshee tsu upepuꞌu. ");
INSERT INTO tswNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ne ɗa tsu yuwain mmalu na̱ a̱tsuma̱lima̱ hali tsu rawa a wisawatan u wantsun u na a̱ tsu ɗe Uba̱ta̱ u Saꞌani u Wivuwun, zuzu na̱ lyuci va Lasiya. ");
INSERT INTO tswNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Tse ene ta̱ lyushi yuwan ta̱ zuzu, waru uluwu u wantsuꞌun u to oꞌwo na̱ meleshe lon. Amayun urana wa̱ A̱buki u Mayan ma Gafura mo Unusu† ma̱ ka̱ra̱ ta̱. ");
INSERT INTO tswNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","A̱vu Bulu yuwan adanshi na azagbain adama a mantsa ma mmaluꞌu. Reve u damma, “Azagbain, n ta yuwusan majiyan na̱ tsu lyuwa elime na̱ mmalu n nda tsu ta uwa a̱tsuma̱lima̱ lon. Tsu ta gaꞌan ni iwuya i na ya̱a̱ lungusa̱ wantsuꞌun. Tsu ta̱ waru o oco itana i na i ri a wantsuꞌun a̱ mini. Ama a ta uwwa usa̱n lon, waru wuma u tsu u ta̱ da̱na̱ e ekere e iwuya.” ");
INSERT INTO tswNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Yali† ya̱ a̱za̱ o uꞌwa wa aliꞌi gba u usu adanshi a̱ Bulu shi, a̱vu u usu adanshi a zagbain vu uluwusa̱ u wantsuꞌun na̱ za wantsuꞌun. ");
INSERT INTO tswNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ana wo oꞌwoi Uba̱ta̱ u Saꞌani u Wivuwun u tu ukpa̱tuꞌu lon, wa̱a̱ da̱na̱ ulobonu lyushi koto wantsun u le lo shi. Reve ozo o ro e le a damma a lyuwa elime na̱ mmalu, tsa̱ra̱ a rawa a̱ lyuci va Finikiya, adama lyushi cina le ɗe. Finikiya wisawatan u wantsun u saꞌani u ɗa a Karita,† za na a̱ ka̱lyuwusa̱ ugana a̱ tyo a̱livu nu uyagi a̱ tyo a̱livu. ");
INSERT INTO tswNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ana upepu u saꞌani u farai e keɓushe diga uyagi, reve a̱za̱ o uluwu u wantsuꞌun a yuwan majiyan a mantsa ma saꞌani ma ɗa a yuwain mmalu cine o foɓoi. A̱vu o foɗo rumu na a tsu vari a̱ mini tsa̱ra̱ wi isawaton wantsun, reve a̱ kuru a̱ ngeꞌen m mala a̱ tyo a̱ ngeꞌen mi iɗa ya Karita. ");
INSERT INTO tswNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Amma a̱vu a̱ba̱jini o upepu u na a̱ tsu ɗe “Upepu wu Ugana na Asana” u keɓe tsu a̱ tyo e memere ma̱ mini. ");
INSERT INTO tswNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Reve upepuꞌu u faba wantsun u tsu, hali tsu kuɗa̱ a wala a̱ tyo uba̱ta̱ u na tsu cigai. A̱vu tsu lyawa upepuꞌu u pura̱ wantsuꞌun. ");
INSERT INTO tswNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","A̱vu tsu kuru na̱ ngeꞌen mi iɗa i memere ma̱ mini ma Kawuda e eɓele a na upepu waa damaton tsu shi. Tsu yuwan ta̱ ukadu u na tsaa wawa wantsun u keꞌen adama u la̱nga̱ wan. A̱vu tsu nla̱ yi a wantsun u gbain. ");
INSERT INTO tswNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ana tsu ronoi wantsun u keꞌen, tsu ta̱wa̱to niyi uba̱ta̱ wu zagbaiꞌin, a̱vu aza a wantsuꞌun a̱ nla̱ wantsun u gbaiꞌin na amunga a̱ka̱nda̱ruwa̱, tsa̱ra̱ wo oꞌwo uɓolu. A̱vu a̱ cipa̱to aapalutsu a wantsuꞌun adama u ka̱ra̱ ben, tsa̱ra̱ u gama ma̱bula̱ ma Siriti wan. ");
INSERT INTO tswNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ana usana u tawai, a yuwan ta̱ upepu wu ucira, hali a varishi itana a mala. ");
INSERT INTO tswNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ana usana u tawisai, reve a̱za̱ o uluwu u wantsun a varishi itana i wantsuꞌun ne ekere e le. ");
INSERT INTO tswNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ne ɗa upepuꞌu u damatosun ntsu, agba u jebe shi, hali rana a̱bunda̱. Upepuꞌu u pala ta̱ urana ni italyoꞌo, hali tsu tawa okolo a na tsaa laꞌa. ");
INSERT INTO tswNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ne ɗa tsu da̱na̱i babu za na lyuwai ilyalya. A̱ tyo ɗe ɗaɗa Bulu ɗeyi ama a wantsuꞌun, reve u damma le, “Ama a nda, nni i shi yu uwwa mu a na tsu lyawa Uba̱ta̱ u Saꞌani u Wivuwun shi. Ni i shi i yuwan ne, tsu shi a̱ tsura̱ antsu a nda shi, waru ko ili i ta̱ i tsu tsu shi a lamba shi. ");
INSERT INTO tswNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Amma gogo i gbama okolo, ko za pa na wa̱a̱ kuwa̱ shi, amma tsu ciga tsu ꞌyuwan wantsuꞌun u ta liɓa a̱ mini. ");
INSERT INTO tswNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","I reve a̱mu vuma vu uꞌwa wa̱ A̱sula̱ u ɗa, waru n tsu yuwaan yi ta̱ a̱ga̱nda̱. Na ayin o yon, A̱sula̱ a̱ lyungu ta̱ malingata ma̱ yi a̱ tyo ya̱ꞌa̱ va̱. ");
INSERT INTO tswNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Malingataꞌa wi isawan ta̱ a̱ ngeꞌen n va̱, reve u damma, ‘Bulu she vu uwwa wovon wan! Vu te isawan a̱ ma̱ka̱ka̱n mo mogono ma gbain Kaisa. Waru adama a̱ wu a ɗa A̱sula̱ ni isaꞌani ya̱ yi waa wawa ama a na a̱ ri a mmalu oɓolo na̱ a̱vu.’ ");
INSERT INTO tswNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Adama o ndolo i gbama asuvu! N ca ta̱ okolo e ekere a̱ A̱sula̱, ne ɗa woo oꞌwo. ");
INSERT INTO tswNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ko na wo oꞌwoi, upepu u to oco tsu e iɗa i memere ma̱ mini waru wantsun u tsu u ta liɓa.” ");
INSERT INTO tswNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Tsu yuwan ta̱ rana kupa na̱ a̱za̱ a̱ na̱shi upepuꞌu e keɓushe wantsuꞌun a̱ ta̱wa̱ uba̱ta̱ u nda nu uba̱ta̱ u ndeɗe o uyagi u malaꞌa e iɗa ya Italiya. Amma a̱ tyo e memere ma ayin o urana wa kupa na̱ a̱za̱ a̱ na̱shi, ɗaɗa a̱za̱ o uluwu u wantsuꞌun e revei a na tsu rawai zuzu ni iɗa. ");
INSERT INTO tswNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ɗaɗa o rito, reve a cina a̱ruꞌun a̱ miniꞌi udasuwu ukpaku nu ushin (120). Ana a̱ ka̱ra̱i keꞌen, reve o ritowiso a̱vu a cina a̱ruꞌun a̱ miniꞌi udasuwu kupakucci. ");
INSERT INTO tswNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","A̱vu a fara a uwwusa wovon u na upepu wee keɓe tsu a̱ tyo uba̱ta̱ wa atali e iɗaꞌa. Ɗaɗa a variyi irumu yu ume i na̱shi o ucina̱ u wantsuꞌun, tsa̱ra̱ u putsaa wantsuꞌun na̱ mmalu. Reve e teme a yuwusan avasa a patishi A̱sula̱ usana u tawa le gbaga. ");
INSERT INTO tswNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Reve a̱za̱ o uluwu u wantsuꞌun a̱ shi a ciga a lyawa wantsuꞌun. A̱vu a tara mawantsun, reve a zuwa a̱ mini vadamma a ta vari rumu vu ume elime a wantsuꞌun tsa̱ra̱ a̱ pusa̱a̱n a̱za̱ e le ugbozu. ");
INSERT INTO tswNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Reve Bulu damma yali na̱ a̱soja, “Nna̱ ama a nda e isawan a̱tsuma̱ a wantsun u nda shi, babu ununa yaa yuwan i laꞌa.” ");
INSERT INTO tswNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ana a uwwai ne, reve a̱sojaꞌa a pupaɗa amunga a mawantsuꞌun, a̱vu a lyawa yi pe a̱ mini. ");
INSERT INTO tswNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Usana azama matawa, a̱vu Bulu pati le a lyuwa ilyalya, adansa, “A̱za̱ a̱ va̱, tsu yuwan ta̱ rana kupa na̱ a̱za̱ a̱ na̱shi a na tsu yuwain mmalu ma̱ a̱tsuma̱lima̱ a̱ mini, agba tsu lyuwai ili i ro shi. ");
INSERT INTO tswNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Adama o ndolo n ta patishi ɗu i lyuwa ilyalya adama a lafiya ɗu, ana wo oꞌwoi ko vuma ta̱ a̱tsuma̱ a̱ ɗu aa lamba a̱nji a̱ ta̱ a aaci a̱ yi shi.” ");
INSERT INTO tswNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Ana u dammai ne, a̱vu u tara opopofu, a̱vu u yuwaan A̱sula̱ ma̱za̱nga̱, reve wu bubusa yi, a̱vu u tama. Ne ɗa u yuwain a̱ ma̱ka̱ka̱n me le suru. ");
INSERT INTO tswNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","A̱vu suru nle a̱ da̱shi ugbamu wa asuvu, reve ele fo a lyuwa ilyalya. ");
INSERT INTO tswNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","A̱bunda̱ a̱ tsu na tsu da̱na̱i pe a̱tsuma̱ a wantsuꞌun gba a̱tsu ɗa tsu da̱na̱i ama ukpakure na̱ kupocindere na̱ a̱za̱ a̱ ta̱li (276). ");
INSERT INTO tswNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ana a lyuwa a̱ cuwa̱in, reve o oco ishina ya̱ a̱bunda̱ tsa̱ra̱ a̱ sa̱da̱ ume u wantsuꞌun. ");
INSERT INTO tswNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ana usana u tawai, a̱za̱ o uluwu u wantsuꞌun a gura reve e iɗa i na a̱ ri shi. Amma e ene ta̱ oboguzu o ro a na a̱ ri na̱ wuyun. Reve a yuwan majiyan ma na a̱a̱ luwa̱ wantsuꞌun a̱ ꞌya̱wa̱ uba̱ta̱ u wuyuꞌun. ");
INSERT INTO tswNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","A̱vu a pupaɗa amunga a na a̱ tsu nla̱a̱ irumu yu ume, reve a lyawa le pe a malaꞌa. A̱vu a̱ ba̱ɗa̱ amunga a na a̱ nla̱i aaci o uwalata u wantsuꞌun fo a mantsa ma̱ ta̱. Reve a̱ ka̱ra̱ a̱ ꞌya̱sa̱sa̱n aapalutsu a wantsuꞌun ununa waa zuwa upepu u keɓe wantsuꞌun a̱ tyo elime hali a rawa a̱ ngeꞌen m mala. ");
INSERT INTO tswNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Agba wantsuꞌun u rawa e iɗa shi, a̱vu tsu rawa uba̱ta̱ u na mini ma palai wuyun, reve wantsuꞌun u uwa a̱ wuyuꞌun hali u kuɗa̱ a̱ zungwa̱. A̱vu wantsuꞌun u ka̱ra̱ o moɓoso na̱ a̱ca̱pa̱ adama o upepu ni ikeɗu i mala. ");
INSERT INTO tswNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","A̱vu a̱sojaꞌa a̱ shi a ciga o una a̱za̱ o uꞌwa wa ali, tsa̱ra̱ a yuwan uda̱su a suma wan. ");
INSERT INTO tswNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Amma ana wo oꞌwoi yaliꞌi u ciga ta̱ u wawa Bulu, reve u putsaa le. A̱vu u damma le aza a na a gurai uda̱su a̱ da̱sa̱ a̱ tyo e eɓele a mala. ");
INSERT INTO tswNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Akapi gba shi a kumba a akpata, ko a kumba akpata o ukosu u wantsun u na wu ɓosoi. Ne ɗa a yuwain hali suru nle a rawai a̱ ngeꞌen m malaꞌa gbaga. ");
INSERT INTO tswNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ana tsu laꞌai, a̱vu tsu uwwa a na tsu ta̱ e iɗa i memere ma̱ mini i na a̱ tsu ɗe Malita. ");
INSERT INTO tswNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ama a̱ lyuciꞌi a yuwaan tsu ta̱ isaꞌani lon. Mantsa ma̱ mini na̱ mantsa mo uta̱nu ma ɗa ma̱ da̱na̱i, a̱vu a kaɓatowo tsu akina, tsa̱ra̱ tsu lyasuwa. ");
INSERT INTO tswNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","A̱vu Bulu zami ɗanga a zuwusa a akina, reve yo ro na ri na̱ tsukono wu uta̱ pe a̱tsuma̱ a ɗangaꞌa adama o usuɗuwu, a̱vu u ka̱ɗa̱ Bulu o ukere reve u kaɓa ɗe. ");
INSERT INTO tswNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ana ama a̱ lyuciꞌi e enei yoꞌo ukaɓu o ukere wa̱ yi, a̱vu a dammulai va̱ni le, “Vuma nda za mona ma ama ma ɗa! Ye ene, ko na u kuwa̱i a̱ mini shi, amma suru na̱ ne a̱a̱ma̱li a ka o ugeꞌetosu wa amayun a ɗa a zuwai mpasa ma ama n kurusu yi, u ta̱ gba a̱ kuwa̱.” ");
INSERT INTO tswNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","A̱vu Bulu za̱ka̱tsa̱ ekere a̱ yi reve u vari yoꞌo a akina, agba wu uwwa mɓa̱la̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Reve amaꞌa a̱ ka̱ra̱ a majiyan a na Bulu ta tsutsa ko u riya̱ a̱vu u kuwushi lo. Amma ana a jimai, agba e ene ili i fara na̱ a̱yi shi. Reve a vadala majiyan me le, a̱vu a damma, “Ma̱sula̱ ma ɗa.” ");
INSERT INTO tswNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Vuma na a̱ tsu ɗe Pubiliya ɗa da̱na̱i gwamna vi iɗa i memere ma̱ miniꞌi. U da̱na̱ ta̱ ni iɗa lo zuzu a̱ ka̱nda̱ruwa̱. A̱yi ɗa u ushi ntsu, reve u ca tsu ucuꞌwatan o uꞌwa wa̱ yi hali rana taꞌatsu. ");
INSERT INTO tswNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Dada va Pubiliya gba u da̱na̱ ta̱ ni ivuna̱ nu ucaruwu. A̱vu Bulu uwa uba̱ta̱ u na u da̱na̱i. Reve u kuruwa̱ yi ukere a yuwusaan yi avasa, a̱vu gba vumaꞌa u ka̱mba̱ gbaga. ");
INSERT INTO tswNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ana vuma wo oꞌwoi gbaga, reve ama e iɗa i memere ma̱ miniꞌi a̱ ka̱ra̱ a̱ ta̱wusa̱a̱ na ama e le a na a̱ ri nu ubanakun ya̱ Bulu a̱vu u ka̱mba̱to le gbaga. ");
INSERT INTO tswNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Amaꞌa a ca tsu ta̱ tsugbain lon, waru ana tsa̱a̱ ka̱ra̱ a ca tsu ta̱ ili biti i na tsu cigai. ");
INSERT INTO tswNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ana tsu yuwain woto taꞌatsu a Malita, reve tsu teme mmalu a malaꞌa. A̱vu tsu uwa a wantsun u na wi isawain e iɗa i memere ma̱ miniꞌi a mantsa ma na mmalu a wantsun n shi n yuwan shi. Wantsun u lyuci wa Iskandariya u ɗa u da̱na̱i. A aaci a wantsuꞌun, iroci yu usheꞌen vu mpishe va̱ a̱ma̱li a na a̱ tsu ɗe Kasata na̱ Polu ɗa da̱na̱i ɗe. ");
INSERT INTO tswNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Ana tsu rawai a̱ lyuci va Sirakusa, tsu da̱nu ta̱ pe rana taꞌatsu. ");
INSERT INTO tswNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Reve tsu uwa a wantsun a̱vu tsu lyawa Sirakusa, a̱vu tsu ka̱ra̱ a̱ tyo uba̱ta̱ u na a̱ tsu ɗe Rigiyun. Ana usana u tawai, upepu u lapusa ta̱ a̱ tyosu ugana, a̱vu tsu rawa a̱ lyuci va Putiyoli. ");
INSERT INTO tswNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","A̱tsuma̱ a̱ lyuci va Putiyoli tsu cina ta̱ pe a̱za̱ e Itoni, reve a pati tsu tsi isawan pe ne ele. Ana tsu yuwain ajuma a̱ ta̱ ne ele, a̱vu tsu ka̱ra̱ a̱ tyo a̱ lyuci va̱ Roma. ");
INSERT INTO tswNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ana a̱za̱ e Itoni ya̱ Roma a uwwai a na tsu ta̱ lo o ure a̱ ta̱wa̱, reve a̱ ta̱wa̱ a gaꞌaton tsu e Eden a Apiya. Ozo o ro gba shi a gaꞌaton tsu ta̱ uba̱ta̱ u na a̱ tsu ɗe Cuꞌwatan Taꞌatsu. Ana Bulu ene nle, reve u godyoo A̱sula̱ reve u da̱shi tsura̱ ugbamu wo okolo. ");
INSERT INTO tswNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ana tsu uwai a̱ lyuci va̱ Roma, a lyawa ta̱ Bulu da̱na̱ a̱yi a̱ ndeꞌen oɓolo na̱ a̱soja a na a̱ pirishi yi. ");
INSERT INTO tswNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ana tsu yuwain rana taꞌatsu, a̱vu Bulu ɗe azagbain a Israꞌila a̱tsuma̱ a̱ Roma. Ana o ɓolotoi a̱vu u damma le, “A̱ɗu a̱za̱ a̱ va̱, ko na wo oꞌwoi n yuwaan ama a̱ tsu unusu shi, n nusaan le uba̱ta̱ e ili ya agadu a nkaya n tsu shi. Suru na̱ ne e reme mu ta̱ a̱ Urishelima, a̱vu a ca mu e ekere a ama a̱ Roma ugutsuwu. ");
INSERT INTO tswNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ele gba a̱za̱ a̱ Roma e petelyuwe ta̱ adanshi a̱ va̱, a̱vu a ciga a lyawa mu, adama a na e reme mu nu unusu u na u rawai o una mu shi. ");
INSERT INTO tswNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Amma ana aza a Israꞌila a̱ usu yi shi, a̱yi ɗa i zuwai u reme numu m patiyi a̱ tyo na adanshi a̱ va̱ uba̱ta̱ wa Kaisa mogono, ko na wo oꞌwoi n ciga n ꞌya̱wa̱ na ama a̱ tsu o ukobu wu ugeꞌetosu shi. ");
INSERT INTO tswNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","A̱yi ɗa i zuwai n zamiyi ure u na me ene ɗu, tsa̱ra̱ tsu dammulai neꞌen, ana wo oꞌwoi adama a vuma na aza a Israꞌila e indanasa uta̱wu wa̱ yi u ɗa a̱ nla̱ numu na akani a nda.” ");
INSERT INTO tswNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Reve a̱ usu yi, “A̱tsu tsu uwwa adanshi a̱ wu uba̱ta̱ wa aza a Israꞌila shi. Tsu tsura̱ mpepelime n na a ɗanaa ntsu ɗe Yahuda shi. Waru tsu uwwa adanshi o uwuyanu a̱ wu uba̱ta̱ wa aza a na a rawai shi. ");
INSERT INTO tswNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Amma tsu ciga ta̱ tsu uwwa yo okolo a̱ wu. Ili i na a̱tsu tsu revei a̱yi ɗa, adama o ure wa̱ A̱sula̱ a saꞌavu a nda na ama suru a yuwusan adanshi a vanvama adama a̱ yi.” ");
INSERT INTO tswNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ana a zuwai urana u na a gaꞌan, reve ama na̱ a̱bunda̱ gba a̱ ta̱wa̱ uba̱ta̱ u na u cuꞌwain. Diga usana hali a̱ tyo ulivu u yuwusaan le ta̱ adanshi o tsugono tsa̱ A̱sula̱. A̱vu u yuwan ulinga na atagada a̱ Wila̱ wa Musa na atagada a Ama̱sula̱, tsa̱ra̱ u vadala le a̱ kuru Yesu. ");
INSERT INTO tswNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ozo o ro e le a̱ usu ta̱ ili i na u damma nle, ozo o ro gba shi a ꞌyuwan ta̱ a na a ca okolo. ");
INSERT INTO tswNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","A̱vu a uwa mawasan va̱ni le, reve a̱ ka̱ra̱ e beteꞌushe. A̱ tyo o ukosu a̱vu Bulu damma, “Ruhu va Akiza damma ta̱ mejege, ana u yuwain adanshi na̱ nkaya n tsu o una̱ wa Ishaya vumava̱sula̱, ");
INSERT INTO tswNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Vu ꞌya̱wa̱ vu damma ama a̱ va̱, “I ta uwwa adanshi a̱ va̱, agba ya̱a̱ tsura̱ urevu wa̱ yi shi. I te ene ili i na n yuwain, agba ya̱a̱ da̱na̱ nu urevu wa̱ yi shi. ");
INSERT INTO tswNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Suru nɗu i ta̱ no okolo ugbamu. Atsuvu a̱ ɗu a ula ta̱, esu a̱ ɗu waru a̱ tu upalu. Yee ene shi, waru yaa uwwa adanshi shi, waru ya̱a̱ tsura̱ urevu shi. Ni i shi a uwwa, ana i vadala ta̱ a̱ tyo ya̱ꞌa̱ va̱, waru n shi ta̱ ka̱mba̱to ɗu gbaga.” ’ ");
INSERT INTO tswNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Adama a nda, n ciga ta̱ i reve A̱sula̱ a̱ lyungu ta̱ na alabari e iwawi, hali a̱ tyo e ekere a Atakpaci. Ele gba a̱ ta̱ ushi.”  ");
INSERT INTO tswNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Ana Bulu dammai ne, a̱vu aza a Israꞌila a̱ ꞌyon a lyawa uba̱ta̱ꞌa̱, reve a̱ ka̱ra̱ a mawasan va̱ni le. ");
INSERT INTO tswNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Bulu gba u da̱nu ta̱ pe o uꞌwa u na wa tsupusa ikebe hali aꞌwan e re. A̱ ushishi vuma na ta̱wa̱i uba̱ta̱ wa̱ yi suru. ");
INSERT INTO tswNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","A̱ shi a putsaa yi na alajiya shi. U yuwusan ta̱ uritosu wa̱ Yesu Zagbain Za vi Iwawi, babu wovon.");
INSERT INTO tswNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","A̱mu Bulu ɗa n ɗanai mepepelime ma nda. A̱mu aagbashi e Yesu Kristi Zamawawa ɗa. A̱sula̱ a ɗangwa mu ta̱ mo oꞌwo aajiya,† reve u lyungu mu n ꞌya̱wa̱ n yuwan alajiya a Alabari a Saꞌani a̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ɗe nu ujimu, A̱sula̱ a yuwan ta̱ nzuwulai ma Alabari a Saꞌani a nda e ekere a ama̱sula̱ a̱ yi, ununa a ɗanai a̱tsuma̱ a Aatagada a Akiza. ");
INSERT INTO tswNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","4","Alabari a Saꞌaniꞌi u ta yuwusan adanshi adama a Mawun ma̱ yi, Yesu† Kristi Zagbain tsu. A matsan yi ta̱ vuma za na shi mawun ma tsukaya mo Mogono Da̱wuda.† Agba Ruhu na ri akiza roco ta̱ nu ucira na Yesu Mawun ma̱ A̱sula̱ ma ɗa, adama a na u ꞌya̱sa̱n niyi o ukwa̱. ");
INSERT INTO tswNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","O ure wa̱ Kristi Zamawawa ɗa, A̱sula̱ a ca numu ulinga u saꞌani wa aajiya. Ulinga u nda adama o rono ama e iɗa suru a̱ usu a̱vu a̱ kuru ɗa. N ta yuwusaan yi ulinga u nda. ");
INSERT INTO tswNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","A̱ɗu fo i ta̱ pe a̱tsuma̱ a ama a na Yesu Zamawawa ɗangwai. ");
INSERT INTO tswNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","N ta ɗanasaa ɗu aza a na a̱ ri a̱tsuma̱ a̱ a̱ba̱jini a̱ lyuci va̱ Roma† mepepelime ma nda. A̱sula̱ a ciga ɗu ta̱ a̱vu waru u ɗe ɗu yo oꞌwo ama a akiza a̱ yi. Lyawa A̱sula̱ Dada tsu na̱ Yesu Zagbain Zamawawa ca ɗu isaꞌani na asuvu nden. ");
INSERT INTO tswNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Lyawa n fara damma n godyo ta̱ A̱sula̱ a̱tsuma̱ a ala e Yesu Zamawawa adama a̱ ɗu suru. N ta yuwusan ne adama a na ama a ta yuwusan adanshi o ucawu wo okolo a̱ ɗu uba̱ta̱ suru. ");
INSERT INTO tswNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","A̱sula̱ e reve ta̱ a na n lyawai a yuwusaan ɗu avasa shi, n ta yuwusaan yi a̱ga̱nda̱ no okolo a̱ va̱ suru waru n ta casu Alabari a Saꞌani adama a Mawun ma̱ yi. ");
INSERT INTO tswNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Mantsa ma na maa yuwusan avasa biti, n tsu pati ta̱ A̱sula̱ u lyawa mu m bura ɗu, waru u to oꞌwo ne na̱ A̱sula̱ a̱ usu. ");
INSERT INTO tswNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","N ciga ta̱ me ene ɗu, a̱vu n ca ɗu cuꞌun va abaꞌun a na Ruhu va̱ A̱sula̱ ca numu. U ta kamba ɗu i kungwa nu ucira a̱tsuma̱ a Zagbain. ");
INSERT INTO tswNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","N ta dansa n ciga ta̱ tsu kambulai nu ucawu wo okolo a na tsu ri na̱ a̱yi. Ucawu wo okolo a̱ ɗu u ta kamba mu, ucawu wo okolo a̱ va̱ waru u ta kamba ɗu. ");
INSERT INTO tswNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Nꞌutsa̱ n va̱, n ciga ɗu ta̱ i reve na n tsu da̱na̱ ta̱ e ifoɓi i na maa bura ɗu. Agba ili i ro i tsu gesheshe mu ta̱ kuci. N ciga ta̱ n zuwa ama a̱ kuru Zamawawa a̱tsuma̱ a̱ Roma, ununa n yuwain na akapi a Atakpaci. ");
INSERT INTO tswNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Na̱ n ciga n ꞌyuwan n yuwaan ama suru a̱ga̱nda̱: aza a na a̱ ri Nheleni† na aza a na Nheleni n ɗa shi, waru na aza a na a̱ ri nu urevu na aza a na e revei ili shi. ");
INSERT INTO tswNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","A̱yi ɗa i zuwai n ri no okolo n yuwaan ɗu alajiya a Alabari a Saꞌani a̱tsuma̱ a̱ Roma. ");
INSERT INTO tswNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Maa uwwusa wono adama a Alabari a Saꞌani† a̱ Kristi Zamawawa shi, adama a na a̱yi ɗa ucira u na A̱sula̱ aa yuwusaan ulinga adama u wawa za na suru cayi okolo, o ufaru aza a Israꞌila reve a̱ kuru na Atakpaci. ");
INSERT INTO tswNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Alabari a Saꞌaniꞌi u to rocosu cine A̱sula̱ aa tarasa ama na̱ a̱ɓula̱† a̱ ma̱ka̱ka̱n ma̱ yi, a̱yi ɗa o ure wu ucawu wo okolo diga o ufaru a̱ tyo o ukosu. Una̱ta̱ ni ili i na Adanshi a̱ A̱sula̱ a dammai, “A̱yi nda za na A̱sula̱ a tarasa za va̱ a̱ɓula̱ ɗa a̱ ma̱ka̱ka̱n ma̱ yi, u ta̱ tsura̱ wuma o una̱ u na u cayi A̱sula̱ okolo.” ");
INSERT INTO tswNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","A̱sula̱ za na ri zuva u to rocosu cine waa uwwusa upan wa ama adama a̱ cuꞌun vu nusu ni iwuya i na aa yuwusan suru. E geshe ta̱ amayun ni iwuya i le. ");
INSERT INTO tswNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","A̱sula̱ a ta casu le a̱tsuma̱lima̱ adama a na e reve ta̱ ili i na i lobonoi na za biti ee reve a̱ tyo e ekere a̱ A̱sula̱, adama a na A̱sula̱ o roco le ta̱ ili i ndolo suru a alanga e eteshe. ");
INSERT INTO tswNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Ama aa gura ene ucira wa̱ A̱sula̱ u na u ri babu ukotu nu ure wa akiza u majiyan ma̱ yi shi. Diga ana A̱sula̱ a yuwain uvaɗi, ili i na u yuwain suru i roco ta̱ cine a̱yi u ri. Adama o ndolo ama a̱ ri nu ure u mota̱a̱ shi. ");
INSERT INTO tswNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21",