﻿USE sofia;
DROP TABLE IF EXISTS sofia.tsn_vpl;
CREATE TABLE tsn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tsn_vpl WRITE;
INSERT INTO tsn_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ba ke bagolwagolwane ba ga Jesu Keresete wa lotso lwa ga Kgosi Dafide le Aberahame: ");
INSERT INTO tsn_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aberahame e ne e le rraagwe Isake; Isake e ne e le rraagwe Jakobe; Jak obe e ne e le rraagwe Juda le bomonnawe ba basimane. ");
INSERT INTO tsn_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda e ne e le rraagwe Perese le Sera (Tamare e ne e le mmaabo); Perese e ne e le rraagwe Heserone; Heserone e ne e le rraagwe Arame; ");
INSERT INTO tsn_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arame e ne e le rraagwe Aminadabe; Aminadabe e ne e le rraagwe Nashone; Nashone e ne e le rraagwe Salemone; ");
INSERT INTO tsn_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salemone e ne e le rraagwe Boase (Rahabe e ne e le mmaagwe); Boase e ne e le rraagwe Obede (Ruthe e ne e le mmaagwe); Obede e ne e le rraagwe Jese; ");
INSERT INTO tsn_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese e ne e le rraagwe Kgosi Dafide. Dafide e ne e le rraagwe Solomone (mmaagwe o ne a kile a ne a le mogatsa Uria); ");
INSERT INTO tsn_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomone e ne e le rraagwe Rehoboame; Rehoboame e ne e le rraagwe Abija; Abija e ne e le rraagwe Asa; ");
INSERT INTO tsn_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa e ne e le rraagwe Jehoshafate; Jehoshafate e ne e le rraagwe Jerame; Jerame e ne e le rraagwe Usia; ");
INSERT INTO tsn_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia e ne e le rraagwe Jothame; Jothame e ne e le rraagwe Ahase; Ahase e ne e le rraagwe Hesekia; ");
INSERT INTO tsn_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia e ne e le rraagwe Manase; Manase e ne e le rraagwe Amone; Amone e ne e le rraagwe Josaea; ");
INSERT INTO tsn_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaea e ne e le rraagwe Jokonia le bomonnawe ba basimane (ba tsetswe ka nako ya go gapelwa kwa Babelona). ");
INSERT INTO tsn_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Morago ga go gapelwa kwa Babelona: Jokonia o ne a tsala Salathiele; Salathiele e ne e le rraagwe Serubabele; ");
INSERT INTO tsn_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabele e ne e le rraagwe Abiude; Abiude e ne e le rraagwe Eliakime; Eliakime e ne e le rraagwe Asore; ");
INSERT INTO tsn_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asore e ne e le rraagwe Sadoke; Sadoke e ne e le rraagwe Akime; Akime e ne e le rraagwe Eliude; ");
INSERT INTO tsn_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliude e ne e le rraagwe Eleasare; Eleasare e ne e le rraagwe Mathame; Mathame e ne e le rraagwe Jakobe; ");
INSERT INTO tsn_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakobe e ne e le rraagwe Josefa yo e neng e le monna wa ga Marea Mma-Jesu Keresete Mesia. ");
INSERT INTO tsn_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tse ke ditshika di le lesome le metso e le mene mo ditshikeng tse di simololang ka Aberahame go tla go fitlha mo go Kgosi Dafide; le tse di lesome le bone go simolola ka nako ya ga Kgosi Dafide go ya nakong ya go gapelwa kwa Babelona; le tse di lesome le bone go simolola ka nako eo go tla go fitlha mo go Keresete. ");
INSERT INTO tsn_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","A ke mabaka a boammaaruri a a amanang le botsalo jwa ga Jesu Keresete: Marea mmaagwe, o ne a beeletswe go nyalwa ke Josefa. Mme ya re a sa ntse a le kgarebana, a ithwala ga Mowa o o boitshepo. ");
INSERT INTO tsn_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mme Josefa mmeeledi wa gagwe ka a le mosiami, a ikaelela go senya tsholofetso ka tidimalo ka a ne a sa rate go mmaa mo mpepeneneng go mo tlhabisa ditlhong. ");
INSERT INTO tsn_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mme ya re a sa ntse a thantse a akanya ka ga selo se, a thulamela, a lora, mme a bona moengele a eme fa go ene a mo raya a re, “Josefa, morwa Dafide, se etsaetsege go tsaya Marea jaaka mosadi wa gago ka gore ngwana yo o mo rweleng o mo ithwele ka Mowa o o Boitshepo.” ");
INSERT INTO tsn_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mme o tlaa tshola ngwana wa mosimane, mme o tlaa mo raya leina o re Jesu (Ke gore “Mmoloki”). Ka gore o tlaa golola batho ba gagwe mo dibeng tsa bone. ");
INSERT INTO tsn_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mo go tlaa diragatsa molaetsa wa Modimo o o kileng wa anamisiwa ke baporofiti ba one, ba re, ");
INSERT INTO tsn_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Reetsang! Kgarebana e tlaa ithwala ngwana! E tlaa tshola ngwana wa mosimane, mme o tlaa bidiwa ‘Imanuele’.” (Ke gore “Modimo o na le rona”) fa go tlhalosiwa. ");
INSERT INTO tsn_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Erile Josefa a tsoga, a dira jaaka moengele a mo laetse, a isa Maria gae go nna mosadi wa gagwe. ");
INSERT INTO tsn_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mme a nna a ntse a le kgarebana go fitlhelela morwawe a tsholwa mme Josefa a mo raya leina a re “Jesu.” ");
INSERT INTO tsn_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesu o na a tsalelwa mo motseng wa Bethelehema, mo Judea metlheng ya puso ya ga Kgosi Herode. E rile ka yone nako eo balepi ba dinaledi bangwe ba goroga mo Jerusalema ba tswa mafatshing a botlhabatsatsi, mme ba botsa ba re, ");
INSERT INTO tsn_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“E fa kae Kgosi e ncha e e tsetsweng ya Bajuda? Ka gore re bonye naledi ya gagwe mo mafatshing a a kgakala a botlhabatsatsi, mme re tsile go mo obamela”. ");
INSERT INTO tsn_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kgosi Herode o ne a tshwenyega thata ka potso ya bone, le batho botlhe ba motse wa Jerusalema ba ne ba tlala khuduego. ");
INSERT INTO tsn_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","A bitsa phuthego ya baeteledipele ba tumelo ya Sejuda, a ba botsa a re, “A baporofiti ba kile ba re bolelela kwa Mesia o tsalelwang teng?” ");
INSERT INTO tsn_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Mme ba mo araba ba re, “Ee, mo Bethelehema, ka gore mo ke mo moporofiti Mika o go kwadileng a re, ");
INSERT INTO tsn_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Wena motsana wa Bethelehema, ga o legae la Juda le le nyatsegang, gonne mo go wena go tlaa tswa molaodi yo o busang batho ba me ba Iseraele.’ ” ");
INSERT INTO tsn_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hong Herode a romela molaetsa ka sephiri kwa baleping ba dinaledi, a ba kopa gore ba tle go mmona, e rile mo phuthegong e, a ba tlhotlhomisa go mmolelela nako tota e ba simolotseng go bona naledi ka yone. Mme a ba raya a re ");
INSERT INTO tsn_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","“Tsamayang lo yeng kwa Bethelehema lo fete lo senke ngwana. E re lo sena go mmona lo boele kwano go nkitsise gore le nna ke tle ke ye go mo obamela.” ");
INSERT INTO tsn_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","E rile morago ga puisanyo e, balepi ba dinaledi ba simolola go tsamaya gape. Mme bonang! Naledi ya iponatsa gape mo go bone, e eme fa godimo ga Bethelehema. ");
INSERT INTO tsn_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Boitumelo jwa bone jwa nna bogolo thata! ");
INSERT INTO tsn_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ya re ba tsena mo tlung e ngwana le Marea mmaagwe ba mo go yone, ba wela ka mangole fa pele ga gagwe ba mo obamela. Ba bula dimpho tsa bone mme ba mo fa gauta, leswalo le le nkgang monate (la kobamelo) le setlolo se sengwe se se bidiwang mera. ");
INSERT INTO tsn_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mme e rile fa ba boela kwa ga bone, ba se ka ba ralala Jerusalema go itsise Herode, ka gore Modimo o ne o ba tlhagisitse mo torong go boela gae ka tsela e sele. ");
INSERT INTO tsn_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","E rile ba sena go tsamaya, moengele wa Modimo a bonala ka toro mo go Josefa. Mme a mo raya a re, “Tsoga o tshabele le ngwana le mmaagwe kwa Egepeto, o nne teng go fitlhelela ke go raya ke re o boe, ka gore Kgosi Herode o tsile go leka go bolaya ngwana.” ");
INSERT INTO tsn_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","E rile mo bosigong joo a ya Egepeto le Marea le losea, ");
INSERT INTO tsn_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","mme a nna teng koo go fitlhelela Kgosi Herode aa swa. Mo ga diragatsa polelelopele ya moporofiti e e reng, “ke biditse morwaake go tswa mo Egepeto.” ");
INSERT INTO tsn_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herode o na a tlala bogale fa a lemoga gore balepi ba dinaledi ga ba a dira ka fa a ba laetseng ka teng. Mme a roma masole kwa Bethelehema go bolaya ngwana mongwe le mongwe wa mosimane go simolola ka wa dingwaga tse pedi go ya kwa tlase mo motsing le mo tikologong yotlhe ka gore balepi ba dinaledi ba ne ba mmoleletse gore naledi e sale e bonala mo dingwageng tse pedi tse di fetileng. ");
INSERT INTO tsn_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tiragalo e e setlhogo e ya ga Herode, ya diragatsa polelelopele ya ga Jeremia e e reng, ");
INSERT INTO tsn_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Selelo sa khutsafalo sa utlwala se tswa Rama, selelo sa khutsafalo e kgolo; ragele a lelela bana ba gagwe; a gana go gomodiwa ka gobo ba sule.” ");
INSERT INTO tsn_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","E rile Herode a sena go swa, moengele wa Modimo a bonala ka toro kwa go Josefa mo Egepeto, mme a mo raya a re, ");
INSERT INTO tsn_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Tloga o tseye ngwana le mmaagwe o boele nabo kwa Iseraele, ka gore ba ba neng ba leka go bolaya ngwana ba sule.” ");
INSERT INTO tsn_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mme ka bofefo a boela kwa Iseraele le Jesu le mmaagwe. ");
INSERT INTO tsn_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mme e rile mo tseleng a boifa fa a utlwa gore Kgosi e ncha ke Arekelao morwa Herode. Mme ya re ka toro e nngwe a tlhagisiwa gore a seka a ya Judea, jalo a ya Galalea; ");
INSERT INTO tsn_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ba nna mo Nasaretha. Mo, ga diragatsa seporofeso sa baporofiti kaga Mesia se se reng, “O tlaa bidiwa Monasara”. ");
INSERT INTO tsn_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","E rile fa ba sa ntse ba le mo Nasaretha, Johane wa Mokolobetsi a simolola go rera mo sekakeng sa Judea. Thero ya gagwe gangwe le gape e ne e re, ");
INSERT INTO tsn_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Sokologang mo dibeng tsa lona, boelang mo Modimong, gonne Bogosi jwa Legodimo bo atametse.” ");
INSERT INTO tsn_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Isaia moporofiti mo makgolong a dingwaga a a fetileng, o boletse ka ga thuto ya ga Johane. O ne a kwadile a re, “Ke utlwa lentswe le le goang mo sekakeng, ‘Baakanyang tsela ya Morena, tlhamalatsang tsela e a tlaa tsamayang mo go yone.’ ” ");
INSERT INTO tsn_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Diaparo tsa ga Johane di ne di dirilwe ka boboa jwa kamele, o ne a itlama ka moitlamo wa letlalo; dijo tsa gagwe e ne e le tsie le dinotshe tsa naga. ");
INSERT INTO tsn_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Batho ba ba tswang Jerusalema le ba ba tswang mo tikologong yotlhe kwa moseja ga mogogoro wa Jorodane, le ba ba tswang mo kgaolong nngwe le nngwe ya Judea ba tswela kwa sekakeng go mo reetsa a rera, ");
INSERT INTO tsn_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","mme fa ba sena go ipolela dibe tsa bone, a ba kolobetsa mo nokeng ya Jorodane. ");
INSERT INTO tsn_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mme e rile a bona Bafarasai le Basadukai ba le bantsi ba tla go kolobediwa, a ba nyatsa a re, “Losika lwa dinoga ke lona! Yo o lo reileng a re lo ne lo ka falola mo bogaleng jwa Modimo jo bo tlang ke mang? ");
INSERT INTO tsn_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pele ga lo kolobediwa supang gore lo sokologile mo dibeng ka go dira ditiro tse di tshwanetseng. ");
INSERT INTO tsn_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Lo seka lwa ikaketsa lwa re, ‘Re falotse ka re le Bajuda, losika lwa ga Aberahame.’ Moo ga go reye sepe. Modimo o ka fetola maje a a fano a, go nna Bajuda! ");
INSERT INTO tsn_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Mme le jaanong selepe sa katlholo ya Modimo se tsepame go kgaola setlhare sengwe le sengwe se se sa ungweng. Di tlaa rengwa di tshubiwa. ");
INSERT INTO tsn_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nna ke kolobetsa mo metsing ba ba sokologileng mo dibeng tsa bone; mme mongwe o e tla; yo mogolo go mpheta thata, o bogolo jo e leng gore ga ke a lekana go tshola ditlhako tsa gagwe. Ene o tlaa lo kolobetsa ka Mowa o o Boitshepo le ka molelo. ");
INSERT INTO tsn_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","O tlaa tlhopa mmoko mo mabeleng, a fisa mmoko ka molelo o o sa khutleng, a ba a boloka mabele mo polokelong.” ");
INSERT INTO tsn_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mme a tswa mo ga gabo mo Galalea a ya kwa nokeng ya Jorodane go kolobediwa teng ke Johane. ");
INSERT INTO tsn_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Johane o ne a sa batle go mo kolobetsa a re, “Mo ga go a tshwanela, ke nna ke tlhokang go kolobediwa ke wena.” ");
INSERT INTO tsn_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mme Jesu a fetola a re, “Tswee-tswee dira jalo ka gore ke tshwanetse go dira tshiamo yotlhe.” Jalo he, Johane a mo kolobetsa. ");
INSERT INTO tsn_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Morago ga kolobetso, fela fa Jesu a tswa mo metsing, magodimo a mmulegela mme a bona Mowa wa Modimo o fologa o le mo setshwanong sa lephoi. ");
INSERT INTO tsn_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mme lentswe la tswa kwa legodimong le re, “Yo ke morwaake yo o rategang, ke itumela thata ka ene”. ");
INSERT INTO tsn_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mme Jesu a gogelwa ke Mowa o o Boitshepo kwa sekakeng, go ya go lekwa ke Satane. ");
INSERT INTO tsn_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ka malatsi a le masome a mane le masigo a le masome mane o na a sa je sepe, mme a tshwarwa ke tlala. ");
INSERT INTO tsn_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mme Satane a mo leka gore a fetole maje senkgwe. Mme a re, go tlaa supa fa o le Morwa Modimo. ");
INSERT INTO tsn_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mme Jesu a mo raya a re, “Nnyaa! gonne dikwalo tsa re senkgwe ga se ka ke sa otla mewa ya batho: se re se tlhokang ke go reetsa lefoko lengwe le lengwe la Modimo.” ");
INSERT INTO tsn_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mme Satane a mo tsaya a mo isa setlhoeng sa Tempele mo Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","A mo raya a re, “Itige o itshupe fa o le Morwa Modimo; ka dikwalo tsa re, ‘Modimo o tlaa roma baengele ba One go go agelela gore o seka wa golafala,’ ba tlaa go agelela mo go sugagakaneng mo matlapeng a a kwa tlase.” ");
INSERT INTO tsn_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesu a mo araba ka kgakalo a re, “Gape gatwe ‘o se ka wa leka Morena Modimo ka teko ya boeleele.’ ” ");
INSERT INTO tsn_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mme Satane a mo tsaya a mo isa setlhoeng sa thaba e e goletseng kwa godimo thata mme a mo kaela dichaba tsa lefatshe le kgalalelo yotlhe ya tsone. ");
INSERT INTO tsn_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","A mo raya a re, “Ke tlaa go fa mo gotlhe fa o ka khubama wa nkobamela.” ");
INSERT INTO tsn_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mme Jesu a mo raya a re, “Tloga fa Satane. Dikwalo tsa re, ‘obamela Morena Modimo a le nosi. Reetsa ene fela.’ ” ");
INSERT INTO tsn_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mme Satane a mo tlogela mme baengele ba tla go mo direla. ");
INSERT INTO tsn_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","13","Mme e rile fa Jesu a utlwa gore Johane o tshwerwe, a tswa mo Judea a boela gae kwa Nasaretha mo Galalea; Mme ka bofefo a fetela kwa Kaperanama fa thoko ga Lecha la Galalea gautshwane le Sebulona le Nafetali. ");
INSERT INTO tsn_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Mo ga diragatsa seporofeso sa ga Isaia se se reng ");
INSERT INTO tsn_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Lefatshe la Sebulona le lefatshe la ga Nafetali fa thoko ga Lecha, le moseja ga noka ya Jorodane, le kwa godimo ga Galalea kwa go tletseng Badichaba, ");
INSERT INTO tsn_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","teng koo batho ba ba neng ba le mo lefifing, ba bonye lesedi le legolo; ba ne ba ntse mo lefatshing la loso, mme lesedi la ba tlhabela.” ");
INSERT INTO tsn_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Go simolola foo, Jesu a simolola go ruta a re, “Sokologang mo sebing lo sokologele mo Modimong gonne Bogosi jwa Legodimo bo, atametse.” ");
INSERT INTO tsn_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Mme ya re ka letsatsi lengwe a tsamaya mo motlhabeng wa lotshitshi lwa Lecha la Galalea, a bona banna ba le babedi, bana ba motho, ebong Simone yo o bidiwang Petere le Anderea, ba le mo mokorong ba tshwara ditlhapi ka lotloa ka e ne e le batshwari le barekisi ba ditlhapi. ");
INSERT INTO tsn_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Mme Jesu a ba bitsa a re, “Ntshalang morago mme ke tlaa lo ruta ka fa lo ka tshwarang ka teng mewa ya batho.” ");
INSERT INTO tsn_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mme ba akofa ba tlogela matloa a bone ba tsamaya nae. ");
INSERT INTO tsn_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ya re kgakalanyana mo motlhabeng wa lotshitshi, a bona bana ba motho ba bangwe gape ba le babedi, ebong Jakobe le Johane ba ntse mo mokorong le Sebede rraabo, ba roka matloa a bone; mme le bone a ba bitsa. ");
INSERT INTO tsn_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Mme ba akofa ba emisa tiro ya bone ba tsamaya nae, ba tlogela rraabo. ");
INSERT INTO tsn_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesu a tsamaya mo tikologong yotlhe ya Galalea a ruta mo dikerekeng tsa Bajuta a rera Mafoko a a Molemo kaga Bogosi jwa Legodimo. A fodisa mofuta mongwe le mongwe wa khidiego le malwetse. ");
INSERT INTO tsn_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Pego ya dikgakgamatso tsa gagwe ya anama go feta melelwane ya Galalea mo e leng gore batho ba ba neng ba lwalela kgakala kwa Siria, ba ne ba tla kwa go ene go fodisiwa. A e ka ne e ne e le bolwetse bofe le setlhabi, kgotsa ba tsenywe ke badimo, kgotsa botsenwa, kgotsa teteselo, o ne a ba fodisa. ");
INSERT INTO tsn_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bontsintsi jo bogolo jwa batho jwa mo sala morago gongwe le gongwe kwa a yang gone. Batho ba ne ba tswa Galalea le mo metseng e e some le Jerusalema, le gongwe le gongwe mo Judea le kwa moseja ga Noka ya Jorodane. ");
INSERT INTO tsn_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Mme ya re ka letsatsi lengwe fa bontsintsi jwa batho bo kokoana, a tlhatlogela le barutwa ba gagwe mo mhapheng wa thaba, mme a nna fa fatshe le bone a ba ruta. ");
INSERT INTO tsn_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","A ba raya a re, “Go sego ba ba ingotlang gonne Bogosi jwa Legodimo ke jwa bone. ");
INSERT INTO tsn_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Go sego ba ba lelang gonne ba tlaa gomodiwa. ");
INSERT INTO tsn_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Go sego ba ba bonolo gonne lefatshe lotlhe ke la bone. ");
INSERT INTO tsn_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Go sego ba ba nyoretsweng tshiamo gonne ba tlaa e bona. ");
INSERT INTO tsn_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Go sego ba ba pelontle le kutlwelobotlhoko gonne ba tlaa utlwelwa botlhoko. ");
INSERT INTO tsn_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Go sego ba ba pelo di itshekileng gonne ba tlaa bona Modimo. ");
INSERT INTO tsn_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Go sego ba ba huhulelang kagiso, gonne ba tlaa bidiwa barwa Modimo. ");
INSERT INTO tsn_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Go sego ba ba bogisediwang tshiamo, gonne Bogosi jwa Legodimo ke jwa bone. ");
INSERT INTO tsn_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Fa lo kgobiwa lo bogisiwa, lo akelwa ka ntlha ya gore lo barutwa ba me, lo sego jang! ");
INSERT INTO tsn_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Itumeleng ka ga gone! Ipeleng thata! Gonne tuelo ya lona e kgolo e lo letile kwa legodimong. Mme gakologelwang gore, Baporofiti ba bogologolo le bone ba ne ba bogisiwa. ");
INSERT INTO tsn_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ke lona letswai la lefatshe, mme fa lona lo latlhegelwa ke molodi go tlaa nna jang ka lefatshe? Le lona lo tlaa latlhelwa kwa ntle lo gatakwa ka dinao lo sena molemo. ");
INSERT INTO tsn_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Lo lesedi la lefatshe, motse o o mo thabeng, o o phatsimang bosigo gore botlhe ba o bone. ");
INSERT INTO tsn_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","16","Se fitlheng lesedi la lona! A le phatsimele botlhe; a ditiro tsa lona tse di molemo di phatsimele botlhe go di bona, gore ba tle ba galaletse Rra lona wa Legodimo. ");
INSERT INTO tsn_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Se tlhokeng go tlhaloganya se ke se tletseng. Ga se go senya melao ya ga Moshe le ditlhagiso tsa baporofiti. Nnyaa ke tletse go di tlhomamisa le gore di diragale jaaka go boletswe. ");
INSERT INTO tsn_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","“Ka tlhomamiso yotlhe e ke nang nayo ka re: molao mongwe le mongwe o o mo Lokwalong o tlaa tswelela pele go fitlhelela maikaelelo a one a diragala. ");
INSERT INTO tsn_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jalo he, fa mongwe a tlola molao o mmotlanyana, a ba a ruta ba bangwe go dira jalo, o tlaa nna mmotlana mo Bogosing jwa Legodimo. Mme ba ba rutang melao ya Modimo ba e reetsa ba tlaa nna batona mo Bogosing jwa Legodimo. ");
INSERT INTO tsn_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Mme ke a lo tlhagisa ga lo ka ke lwa tsena mo Bogosing jwa Legodimo fa e se tshiamo ya lona e feta ya Bafarasai le baeteledipele ba bangwe ba Bajuda. ");
INSERT INTO tsn_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mo melaong ya ga Moshe e ne e le gore, ‘Fa o bolaya motho, o tshwanetse wa swa le wena.’ ");
INSERT INTO tsn_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mme ke okeditse molao oo, e bile ke lo bolelela gore fa o shakgetse fela, le fa e le mo motseng wa gago, o lebaganywe ke katlholo! Fa o bitsa tsala ya gago seeleele, o ka nna wa tseelwa kwa kgotleng ya tshekelo fa o mo hutsa, o mo diphatseng tsa molete wa molelo. ");
INSERT INTO tsn_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Mme ke gone fa o eme fa pele ga sebeso (aletara) mo Tempeleng, o ntshetsa Modimo setlhabelo, mme ka tshoganetso o bo o gakologelwa gore wa ga eno o na le sekgopi nao, ");
INSERT INTO tsn_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Tlogela setlhabelo sa gago gone foo fa pele ga sebeso (aletara) go ikopa maitshwarelo o bo o letlane nae. ");
INSERT INTO tsn_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Akofa outlwane le mmaba wa gago nako e ise e tsamaye thata e se re kgotsa a go gogele kwa tshekong, o bo o latlhelwa mo tlung ya kgolegelo. ");
INSERT INTO tsn_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Gonne o tlaa nna moo go fitlhelela o bo o duela ledinyana la bofelo. ");
INSERT INTO tsn_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Melao ya ga Moshe e ne e re, ‘O seka wa dira boaka’. ");
INSERT INTO tsn_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mme ka re: Le fa e le mang yo o lebang mosadi ka go mo eletsa, o setse a dirile boaka nae mo pelong. ");
INSERT INTO tsn_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Mme fa leitlho la gago, le fa e ka ne e le leitlho le le itekanetseng le tsosolosa keletso, le gonye o le latlhe. Go botoka gore tokololo e e go leofisang e senngwe go na le gore mmele otlhe wa gago o latlhelwe mo moleting wa molelo. ");
INSERT INTO tsn_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mme fa seatla sa gago le fa e le sa moja se go leofisa, se kgaole o se latlhe. Gonne go botoka go se kgaola go na le go iphitlhela o le mo moleting ka ntlha ya sone. ");
INSERT INTO tsn_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Molao wa ga Moshe wa re, ‘Fa mongwe a batla go kgaogana le mosadi wa gagwe, o ka mo tlhala fela ka go mo neela lokwalo lwa tlhalo’. ");
INSERT INTO tsn_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mme nna ka re monna yo o tlhalang mosadi wa gagwe fa e se ka ntlha ya boaka, o mo dirisa boaka. Mme yo o mo nyalang le ene o dira boaka. ");
INSERT INTO tsn_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Gape molao wa ga Moshe wa re, ‘Ga o a tshwanela go dirolola maikano a gago le Modimo, o tshwanetse go a diragatsa otlhe.’ ");
INSERT INTO tsn_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","“Mme ka re: o se ka wa dira maikano ape! Lefa e le go ikana ka ‘Magodimo!’ Ke seikano se se boitshepo mo Modimong, ka magodimo ke setulo sa Bogosi jwa Modimo. ");
INSERT INTO tsn_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Gape fa o ikana ka ‘Lefatshe’ ke seikano se se boitshepo mo Modimong, ka gore lefatshe ke sebeo sa dinao tsa one. Gape o se ka wa ikana ka Jerusalema ka gore Jerusalema ke motse-mogolo wa Kgosi e kgolo. ");
INSERT INTO tsn_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","“Gape o se ka wa ikana ka ‘phogwana’! Ka gore ga o kake wa fetola thiri nngwe go nna tshweu kgotsa ntsho. ");
INSERT INTO tsn_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mme go bua ga lona e nne Ee, ke tlaa, kgotsa Nnyaa ga nkake, lefoko la lona le lekanye. Tiisa tsholofetso ya gago ka go ikana, go supa gore sengwe ga se a siama. ");
INSERT INTO tsn_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Molao wa ga Moshe wa re, ‘Fa motho a gonya leitlho la yo mongwe, le ene o tshwanetse go gonngwa leitlho. Fa mongwe a go itaya a go kgola leino, a leino la motho yoo le ene le kgolwe.’ ");
INSERT INTO tsn_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mme nna ka re: Se emelelaneng le bosula! Fa o phanngwa mo lerameng, retolola le lengwe. ");
INSERT INTO tsn_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Fa o isiwa tshekong, o bo o tseelwa hempe, ntsha le baki ya gago. ");
INSERT INTO tsn_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Fa masole a batla gore o rwale dithoto tsa bone sekgala sa mmaele e le nngwe di rwale di mmaele tse pedi. ");
INSERT INTO tsn_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Naya ba ba kopang, o se ka wa hularela yo o batlang go adima mo go wena. ");
INSERT INTO tsn_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Go na le puo e e reng, ‘Rata ditsala tsa gago mme o ile baba ba gago.’ ");
INSERT INTO tsn_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mme nna ka re: ‘Rata baba ba gago! Rapelela ba ba go bogisang!’ ");
INSERT INTO tsn_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","“Ka tsela eo lo tlaa bo lo dira jaaka bana ba boammaaruri ba Rraeno yo o kwa legodimong. Gonne o tlhabisetsa basiami le ba ba sa siamang letsatsi, a nesetse basiami le ba ba sa siamang pula ka go tshwana. ");
INSERT INTO tsn_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Fa o rata ba ba go ratang fela, go thusang?, le ba ba bosula ba dira jalo. ");
INSERT INTO tsn_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Fa o siametse ditsala tsa gago fela, o farologanye jang le batho ba bangwe? Le baheitane tota ba dira fela jalo. ");
INSERT INTO tsn_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mme lo tshwanetse lwa nna boikanyego, fela jaaka Rraeno yo o kwa legodimong a le boikanyego. ");
INSERT INTO tsn_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mme elang tlhoko! Se direng tshiamo ya lona fa pele ga batho gore ba lo tlotle, fa lo dira jalo ga lona go bona tuelo e e tswang kwa go Rraeno yo o kwa legodimong. ");
INSERT INTO tsn_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Fa o naya mokopi mpho, se bue kaga yone mo mpepeneneng jaaka baitimokanyi ba dira: ba letsa ditorompeta mo dikerekeng le mo mebileng ya motse gore ditiro tsa bone tsa lorato di tle di bonwe! Ke a lo bolelela ka pelo yotlhe, ba setse ba amogetse tuelo yotlhe, e ba neng ba tlaa e bona. ");
INSERT INTO tsn_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mme fa o direla mongwe tshiamo, ka sephiri, se bolelele lebogo la gago la molema se se dirwang ke lebogo la moja. ");
INSERT INTO tsn_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mme Rraeno yo o itseng diphiri tsotlhe o tla go duela. ");
INSERT INTO tsn_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Mme jaanong kaga thapelo. Fa lo rapela, lo se ka lwa nna jaaka baitimokanyi ba ba ipaang jaaka o ka re ke ba ba obamelang Modimo ka go rapela mo ponong ya mongwe le mongwe mo makopanelong a mebila le mo dikerekeng mo ba ka bonwang ke mongwe le mongwe teng. Ammaaruri ke yone tuelo yotlhe e ba tlaa lalang ba e bonye. ");
INSERT INTO tsn_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mme fa o rapela, tsamaya o le nosi, o itswalele mo tlung mme o rapele Rraeno ka sephiri, mme Rraeno yo o itseng diphiri tsa gago, o tlaa go duela. ");
INSERT INTO tsn_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","8","“Se, boaboele thapelo ya gago jaaka baheitane ba dira, ba ba gopolang gore dithapelo di arabiwa fela ka go boaboelwa. Gakologelwa gore Rrago o itse se tota o se tlhokang pele ga o mo kopa! ");
INSERT INTO tsn_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Rapelang jaana: ‘Rraetsho yo o kwa legodimong re tlotla leina la gago le le itshephileng. ");
INSERT INTO tsn_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Re kopa gore bogosi jwa gago bo tle ka bofefo. A go rata ga gago go dirwe mono lefatshing jaaka go dirwa kwa legodimong. ");
INSERT INTO tsn_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Re neele dijo tsa rona gape gompieno jaaka malatsi otlhe. ");
INSERT INTO tsn_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mme o re itshwarele dibe tsa rona, jaaka re itshwaretse ba ba re leofetseng. ");
INSERT INTO tsn_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Se re ise mo thaelong, mme o re golole mo go yo o bosula. Amen.’ ");
INSERT INTO tsn_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","15","Rraeno wa Legodimo o tlaa go itshwarela, fa o itshwarela ba ba go leofelang, mme fa o gana go ba itshwarela ga a kitla a go itshwarela. ");
INSERT INTO tsn_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Jaanong ka ga go ikitsa dijo; fa o ikitsa dijo, o tlogela dijo ka maikaelelo a semowa, se dire jalo mo mpepeneneng, jaaka baitimokanyi ba dira ba leka go itlhontsha difatlhogo le go tlhoka go apara sentle gore batho ba ba utlwele botlhoko. Ammaaruri, ke yone tuelo e ba tlaa lalang ba e bonye. ");
INSERT INTO tsn_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","“Mme fa o ikitsa dijo, apara sentle, ");
INSERT INTO tsn_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Gore le fa e le ope a seka a belaela gore o bolailwe ke tlala, fa e se Rraeno fela yo o itseng sephiri sengwe le sengwe. Mme o tlaa go duela. ");
INSERT INTO tsn_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Se boloke dikhumo tsa gago fano mo lefatshing mo di ka senyegang kgotsa tsa utswiwa. ");
INSERT INTO tsn_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Di boloke kwa legodimong kwa di se kitlang di latlhegelwa ke tlhwatlhwa teng, di bolokesegile mo magodung! ");
INSERT INTO tsn_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","“Fa dikhumo tsa gago di le kwa legodimong le pelo ya gago e tlaa nna teng. ");
INSERT INTO tsn_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Fa leitlho la gago le itshekile go tlaa nna lesedi mo pelong ya gago. ");
INSERT INTO tsn_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mme fa leitlho la gago le sirilwe ke dikgopolo tse di bosula le dikeletso, o mo botennye jwa lefifi la semowa. Ao, kana lefifi leo le ka nna legolo thata jang! ");
INSERT INTO tsn_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ga o ka ke wa direla barena ba le babedi: Modimo le madi. Ka o tla ila yo mongwe o rate yo mongwe, kgotsa go nne ka tsela e sele. ");
INSERT INTO tsn_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Jalo he, tlhagiso ya me ke e: se tshwenyegeng ka ga dilo-ebong dijo, dino, madi le diaparo. Ka gore o setse o na le botshelo le mmele-mme di botlhokwa go na le se se tshwanetseng go jewa le se se tshwanetseng go aparwa. ");
INSERT INTO tsn_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Bonang dinonyane! Ga di tshwenyege kaga se se jewang ga di tlhoke go jala kgotsa go roba kgotsa go boloka dijo ka gore Rraalona wa Legodimo o a di otla. Mme lona lo tlhwatlhwa kgolo mo go ene go na le tsone. ");
INSERT INTO tsn_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","A ditlhobaelo tsa lona tsotlhe di ka oketsa botshelo jwa lona ka motsotso o le mongwe? ");
INSERT INTO tsn_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Mme ke eng fa o tlhobaela kaga diaparo tsa gago. Lebang dithunya tsa naga! Ga di tlhobaele kaga diaparo tsa tsone. ");
INSERT INTO tsn_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Le fa go ntse jalo, Kgosi Solomone mo kgalalelong ya gagwe o na a sa apesiwa bontle jaaka di ntse. ");
INSERT INTO tsn_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mme fa Modimo o tlhokomela dithunya tse di fano gompieno ka tlhokomelo e kgolo, mme ka moso di be di seyo, a tota ga o na go lo tlhokomela, lona batho ba tumelo e potlana? ");
INSERT INTO tsn_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","32","“Jalo he, se tlhobaeleng gotlhelele kaga go nna le dijo tse di lekanyeng le diaparo. Ke eng fa lo nna jaaka baheitane ka gore ba nna le boikgantsho mo dilong tse tsotlhe, gape ba amega thata kaga tsone, mme Rraeno wa legodimo o setse a itse sentle gore lo a di tlhoka. ");
INSERT INTO tsn_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","“Mme ka boitumelo o tlaa di lo naya fa lo mo naya tlotlo e kgolo mo botshelong jwa lona. ");
INSERT INTO tsn_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Jalo he, se tlhobaeleleng bokamoso, Modimo o tlaa tlhokomela bokamoso jwa lona. Lebogelang tlhabo ya letsatsi e lo e boneng. ");
INSERT INTO tsn_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Se sekiseng mme ga lo na go sekisiwa! ");
INSERT INTO tsn_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gonne ba bangwe le bone ba tlaa lo tsaya fela jaaka lo ba tsaya. ");
INSERT INTO tsn_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Mme o tshwenyegelang kaga selabe se se mo leitlhong la mongwe ka wena fa o na le sehidikwe mo go la gago? ");
INSERT INTO tsn_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","A o tlaa re, ‘Tsala, mma ke go thuse ke ntshe selabe seo mo leitlhong la gago; fa tota o sa bone ka ntlha ya sehidikwe se se mo go la gago’ ");
INSERT INTO tsn_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Moitimokanyi! Pele ntsha sehidikwe se se mo leitlhong la gago. Ke gone o ka bonang go thusa mongwe ka wena. ");
INSERT INTO tsn_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Se neeleng dikolobe dilo tsa lona tsa botlhokwa (diperela)! Di tlaa di gataka di be di retologela kwa go lona di lo tlhasela. ");
INSERT INTO tsn_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kopang, mme lo tlaa newa se lo se kopang. Batlang, mme lo tlaa bona. Kokonyang, mme lo tlaa bulelwa. ");
INSERT INTO tsn_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","“Gonne mongwe le mongwe yo o kopang, o a amogela. Le fa e le mang yo o batlang, o a bona; fela fa o kokonya, o tlaa bulelwa. ");
INSERT INTO tsn_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Fa ngwana a kopa rraagwe dijo, a o tlaa neelwa lentswe mo boemong jwa tsone? ");
INSERT INTO tsn_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Fa a kopa tlhapi, a o tlaa neelwa noga e e nang le botlhole? Nnyaa! ");
INSERT INTO tsn_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mme fa lona ba ba dipelo di thata, badira-dibe lo itse go fa bana ba lona dimpho tse di siameng, a Rraa-lona yo o kwa legodimong ga a na go naya ba ba mo kopang dimpho tse di siameng fela jalo? ");
INSERT INTO tsn_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Direlang ba bangwe se lo batlang ba se lo direla. Se ke thuto ya melao ya ga Moshe ka mafoko a makhutshwane. ");
INSERT INTO tsn_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Legodimo le ka tsenwa fela ka kgoro e tshesane. Tsela e kgolo e e yang kwa moleting e atlhame, kgoro ya one e atlhametse bontsintsi jo bo tlhophang tsela ya one e e motlhofo. ");
INSERT INTO tsn_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mme boatlhamo jwa kgoro e e isang botshelong bo bonnye, le tsela e tshesane, mme basekae fela ba a e bona. ");
INSERT INTO tsn_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Itiseng mo baruting ba e seng bone ba ba tlang ba apere jaaka dinku tse di senang molato, mme e le diphiri tse di lo gagoganyang. ");
INSERT INTO tsn_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Lo ka ba lemoga ka tsela e ba dirang ka yone, fela jaaka lo ka lemoga setlhare ka loungo lwa sone ga lo kake lwa tshwantshanya mofine le ditlhare tse di mitlwa! Kgotsa difeige le masitlwana! ");
INSERT INTO tsn_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mefuta ya ditlhare tsa loungo e ka lemogwa ka bofefo ka go tlhatlhoba loungo lwa tsone. ");
INSERT INTO tsn_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mofuta o o ungwang loungo lo lo monate ga o ke o ungwa mofuta o o sa jeweng! ");
INSERT INTO tsn_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Jalo he ditlhare tse di nang le loungo lo lo sa jeweng di a rengwa di bo di latlhelwa mo molelong. ");
INSERT INTO tsn_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ee, tsela ya go lemoga setlhare kgotsa motho ke ka mofuta wa loungo lo o lo ungwang. ");
INSERT INTO tsn_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ga se botlhe ba ba buang boModimo ba ba ntseng jalo. Ba ka mpitsa ‘Morena’ mme ga ba kitla ba ya legodimong. Gonne potso ya botlhokwa ke gore a ba reetsa Rre yo o kwa legodimong. ");
INSERT INTO tsn_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","“Ka letsatsi la katlholo ba le bantsi ba tlaa nthaya ba re, Morena Morena, re boleletse ba bangwe ka ga gago ra ba ra dirisa leina la gago go lelekela badimo ntle le go dira dikgakgamatso tse dingwe tse dintsi. ");
INSERT INTO tsn_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mme ke tlaa fetola ke re, ‘Ga lo ise lo ke lo bo lo nne ba me. Tsamayang, gonne ditiro tsa lona di bosula’, ");
INSERT INTO tsn_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Botlhe ba ba reetsang ditaelo tsa me ba di sala morago, ba botlhale, jaaka monna yo o agang ntlo ya gagwe mo lefikeng le le kwenneng. ");
INSERT INTO tsn_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Le fa pula e tla ka bontsi morwalela o bo o tlhatloga mme go tsubutla ditsuatsue ka fa ntle ga ntlo ya gagwe ga e kitla e wa, gonne e agilwe mo lefikeng. ");
INSERT INTO tsn_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Mme ba ba utlwang ditaelo tsa me, mme ba sa di tlhokomele ba dieleele, jaaka monna yo o agang ntlo ya gagwe mo motlhabeng. ");
INSERT INTO tsn_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Gonne fa dipula le merwalela di tla, mme diphefo di foka di itaaka ntlo ya gagwe, e tlaa gosomana mo go golo.” ");
INSERT INTO tsn_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Bontsintsi jwa batho bo ne jwa gakgamadiwa ke thuto ya ga Jesu. ");
INSERT INTO tsn_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Gonne o ne a ruta jaaka mongwe yo o nang le nonofo e kgolo, eseng jaaka baeteledipele ba bone ba Sejuda. ");
INSERT INTO tsn_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Bontsintsi jwa batho jwa sala Jesu mora-go fa a fologa mo mhapheng wa lentswe. ");
INSERT INTO tsn_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mme bonang! Molepero a atamela. A-khubama fa pele ga gagwe a obama a mo rapela a re, “Rra, fa o rata o ka mphodisa.” ");
INSERT INTO tsn_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Mme Jesu a mo tshwara a mo raya a re “Ke a rata, fola.” Mme gone fela foo lepero la nyelela. ");
INSERT INTO tsn_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mme Jesu a mo raya a re, “O se ka wa bolelela ope; tlhamalalela kwa moperesiting go ya go tlhatlhojwa; mme o tlaa ntsha mpho e e batlwang ka molao wa ga Moshe wa balepero ba ba fodisitsweng, ebong bosupi jwa phatlhalatsa jwa gore o fodisitswe.” ");
INSERT INTO tsn_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Erile Jesu a goroga mo Kaperanama, mogolwane wa sesole sa Roma a tla kwa go ene mme a mo rapela go ya kwa lwapeng lwa gagwe go fodisa motlhanka wa gagwe wa mosimane yo o neng a le mo bolaong a bolawa ke bolwetse jwa teteselo a tlhoafaditswe ke setlhabi. ");
INSERT INTO tsn_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Mme Jesu a mo fetola a re, “Ke tlaa tla go mo fodisa.” ");
INSERT INTO tsn_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Mme mogolwane a re, “Rra ga ke a lekana go go tseela kwa lwapeng lwa me gape ga go tlhokafale gore o tle. Fa o ka nna fela fa mme wa re, ‘Fola’, motlhanka wa me o tlaa fola! Ke a itse, ka gore ke ka fa tlase ga taolo ya baeteledipele ba me ba bagolo mme ke na le taolo mo masoleng a me, mme ke raya lengwe ke re, ‘Tsamaya’ mme le tsamaye, mme ke reye le lengwe ke re, ‘Tla’ mme le tle, mme ke reye motlhanka wa me wa mosimane ke re, ‘Dira se kgotsa sele’ mme a se dire. Mme ke itse gore o na le thata ya go raya bolwetse jwa gagwe o re bo tsamaye mme bo tlaa tsamaya.” ");
INSERT INTO tsn_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesu a nna foo a akabetse! Mme a retologela kwa bontsintsing jwa batho a re, “Ga ke ise ke ke ke bone tumelo e e tshwanang le e mo Iseraele! ");
INSERT INTO tsn_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mme ke lo bolelela se, Badichaba ba le bantsi jaaka mogolwane yo wa Roma, ba tlaa tswa mo tikologong yotlhe ya lefatshe ba nna fa fatshe mo Bogosing jwa Legodimo le Aberahame, Isake le Jakobe. ");
INSERT INTO tsn_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Baiseraele ba le bantsi ba ba neng ba baakanyeditswe Bogosi, ba tlaa lelekelwa mo lefifing le le kwa ntle, mo felong ga selelo le tlhokofatso”. ");
INSERT INTO tsn_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Hong Jesu a raya mogolwane wa Roma a re, “Tsamaya o ye lwapeng. Se o se dumetseng se diragetse!” Mme mosimane a fola ka yone nako eo. ");
INSERT INTO tsn_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Erile Jesu a goroga kwa tlung ya ga Petere, mogwagwadia Petere wa mosadi o ne a le mo bolaong a tshwere ke letshoroma. ");
INSERT INTO tsn_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mme erile fa Jesu a tshwara lebogo la gagwe, letshoroma la mo tlogela; mme a ema a ba baakanyetsa dijo. ");
INSERT INTO tsn_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mo maitseboeng ao batho ba le bantsi ba ba neng ba tsenywe ke mewa e e maswe ba leriwe kwa go Jesu; mme ya re a bua lefoko le le lengwe; mewa e e maswe yotlhe ya sia; mme botlhe ba ba neng ba lwala ba fola. ");
INSERT INTO tsn_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mo ga diragatsa seporofeso sa ga Isaia se se reng, “O na a tsaya malwetse a rona, a rwala dipobolo tsa rona.” ");
INSERT INTO tsn_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Fa Jesu a lemoga ka fa bontsintsi jwa batho bo neng bo gola ka teng, o na a laela barutwa ba gagwe gore ba ipaakanyetse go kgabaganyetsa ntlheng e nngwe ya lecha. ");
INSERT INTO tsn_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ka yone nako eo mongwe wa baruti ba tumelo ya Sejuda a mo raya a re, “Moruti, ke tlaa go sala morago, ga gore sepe gore o ya kae!” ");
INSERT INTO tsn_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mme Jesu a re, “Bophokoje ba na le mesima le dinonyane di na le dintlhaga, mme nna Morwa Motho, ga ke na legae le e leng la me, ga go na fa nka latsang tlhogo gone.” ");
INSERT INTO tsn_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mongwe wa barutwa ba gagwe a re, “Morena, mma ke tsamaye pele ke ye go fitlha rre.” ");
INSERT INTO tsn_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mme Jesu a mo raya a re, “Ntshala morago! Lesa ba ba suleng mo moweng ba tlhokomele baswi ba bone.” ");
INSERT INTO tsn_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Mme a tsena mo mokorong a simolola go kgabaganya lecha le barutwa ba gagwe. ");
INSERT INTO tsn_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ka tshoganyetso ga tsoga setsuatsue se segolo, makhubu a goletsegile go feta mokoro. Mme Jesu o ne a robetse. ");
INSERT INTO tsn_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Barutwa ba ya kwa go ene ba feta ba mo tsosa, ba gowa ba re, “Morena, re boloke! Re a nwela!” ");
INSERT INTO tsn_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mme Jesu a ba raya a re, “Ao batho ba tumelo e potlana! Ke eng fa lo tshogile jaana?” Hong a ema a kgalemela phefo le makhubu, mme ga nna tuulalo e kgolo. ");
INSERT INTO tsn_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Barutwa ba nna fela foo ba reregile! ba botsanya ba re, “Motho yo ke mang, yo le e leng diphefo tota le lewatle di mo reetsang?” ");
INSERT INTO tsn_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Erile ba goroga ka fa ntlheng e nngwe ya lecha mo lefatshing la Bagadara, banna ba le babedi ba ba tsenyweng ke mewa e e maswe ba mo kgatlhantsha. Ba ne ba nna mo diphupung ba le diphatsa thata mo motho ope o neng a ka se ka a ralala golo foo. ");
INSERT INTO tsn_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mme ba simolola go goela kwa go ene ba re, “O batlang mo go rona, wena Morwa Modimo? Ga o ise o nne le tshwanelo ya go re tlhokofatsa.” ");
INSERT INTO tsn_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Serapa sa dikolobe se ne se fula kgakalanyana. ");
INSERT INTO tsn_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jalo mewa e e maswe ya kopa ya re fa o re “kgoromeletsa ntle re, lelekele mo serapeng sele sa dikolobe.” ");
INSERT INTO tsn_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesu a e raya a re, “Go siame, tsamayang” mme ya tswa mo banneng ya tsena mo dikolobeng, mme serapa sotlhe sa kgokologa mo thoteng ka bofefo sa wela mo metsing kwa tlase. ");
INSERT INTO tsn_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mme badisa ba tsone ba sianela kwa motseng o o gaufi go ya go bolela kaga se se diragetseng. ");
INSERT INTO tsn_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mme batho botlhe ba motse ba sianela go tla go bona Jesu, ba mo kopa gore a tsamaye a ba tlogele ba le bosi. ");
INSERT INTO tsn_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Mme Jesu a palama mokoro a kgabaganya lecha a ya Kaperanama, motse wa ga gabo. ");
INSERT INTO tsn_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ka bofefo banna bangwe ba lere kwa go ene mosimane yo o teteselang a le mo phateng. Erile fa Jesu a bona tumelo ya bone a raya mosimane yo o teteselang a re, “Nametsega ngwana, gonne ke go itshwaretse dibe!” ");
INSERT INTO tsn_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mme bangwe ba baeteledipele ba tumelo ba gowa ba re, “O a tlhapatsa, Monna yo a re ke Modimo!” ");
INSERT INTO tsn_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesu o ne a itse se ba neng ba se akanya mme a re, “Ke eng fa lo akanya megopolo e e maswe jaana? ");
INSERT INTO tsn_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","A go thata go itshwarela dibe tsa gagwe go na le go mo fodisa? ");
INSERT INTO tsn_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mme jalo he, go supa gore ke na le thata fano mo lefatshing go itshwarela dibe.” Jalo a retologela kwa mosimaneng yo o teteselang a mo raya a re, “Tsoga o phuthe phate ya gago o ye lwapeng.” ");
INSERT INTO tsn_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mme mosimane a nanoga a tsamaya! ");
INSERT INTO tsn_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Poifo e kgolo ya wela bontsintsi jwa batho fa ba bona se se diragala fa pele ga matlho a bone. Ba galaletsa Modimo thata ka go naya motho thata e e ntseng jalo. ");
INSERT INTO tsn_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Fa Jesu a tsamaya mo phologelong ya tsela, a bona mokgethisi Mathaio, a ntse fa go kgethisediwang teng, mme Jesu a mo raya a re, “Tla o nne morutwa wa me.” ");
INSERT INTO tsn_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Morago, fa Jesu le barutwa ba gagwe ba a ja dijo kwa tlung ya ga Mathaio, ga bo go le batsietsi ba le bantsi e le balalediwa ba ba itsegeng ka mekgwa e e maswe. ");
INSERT INTO tsn_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mme Bafarasai ba kgotswa ba re, “Ke eng fa moruti wa lona a dirisanya le batho ba ba ntseng jaana.” ");
INSERT INTO tsn_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mme Jesu a ba raya a re, “Ka gore ba ba itekanetseng ga ba tlhoke ngaka, ba ke ba ba e tlhokang!” ");
INSERT INTO tsn_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mme a oketsa a re, “Tsamayang lo ithute tlhaloso ya temana ya Lokwalo, ‘Ga se ditlhabelo tsa lona le dimpho tsa lona tse ke tshwenyegang ka tsone, ke batla gore lo nne le kutlwelobotlhoko’. Tiro ya me fano mo lefatshing ke go busetsa badiradibe mo Modimong e seng go tshwenyega ka batho ba ba siameng.” ");
INSERT INTO tsn_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Letsatsi lengwe barutwa ba ga Johane wa Mokolobetsi ba tla kwa go Jesu ba mmotsa ba re, “Ke eng fa barutwa ba gago ba sa ikitse go ja dijo jaaka rona le Bafarasai re dira?” ");
INSERT INTO tsn_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mme Jesu a botsa a re, “A ditsala tsa monyadi di tshwanetse go hutsafala, di ikitsa dijo fa a sa ntse a na le tsone? Mme nako e tlaa tla fa ke tlaa tlosiwang mo go tsone. Mme ke gone ba tlaa nnang le nako e ntsi go ikitsa dijo. ");
INSERT INTO tsn_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Mme ke mang yo o ka bitiyang seaparo se segologolo ka letsela le lesha? Ka gore sebata se ka gagola sa dira leroba le legolo go gaisa pele. ");
INSERT INTO tsn_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Mme emang yo o ka dirisang makuka a magologolo a mofine go tshela mofine o mosha? Gonne a magologolo a ka phanngwa ke go hupela, mme mofine, o tshologe, makuka a senyege. Ke makuka a masha fela a a dirisiwang go tshela mofine o mosha.” ");
INSERT INTO tsn_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ya re a sa ntse a bua jaana, moruti wa ntlo ya thuto a tla a mo obamela a re, “Morwadiake yo mmotlana o sule, mme o ka mo rudisa fa o ka tla wa mo ama.” ");
INSERT INTO tsn_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ya re Jesu le barutwa ba gagwe ba sa ntse ba ya kwa lwapeng lwa moruti ");
INSERT INTO tsn_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","mosadi yo o sa bolong go lwala bolwetse jwa tshologo ya madi mo teng ka dingwaga di le lesome le metso e le mebedi a tla a mo setse morago mme a ama momeno wa seaparo sa gagwe. ");
INSERT INTO tsn_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Gonne o na a akantse gore, “Fela fa nka mo ama ke tlaa fola.” ");
INSERT INTO tsn_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesu a retologa a bua nae a re, “Morweetsana, gotlhe go siame! Tumelo ya gago e go fodisitse.” Mme mosadi a fola ka yone nako eo. ");
INSERT INTO tsn_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Erile fa Jesu a goroga kwa lwapeng lwa ga Moruti, a bona bontsintsi jwa batho bo tsositse modumo mme a utlwa le moopelo wa phitlho, ");
INSERT INTO tsn_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","A re, “Ba ntshetseng kwa ntle, gonne morweetsana ga a swa; o robetse fela!” Mme ba ne ba mo tshega ka tshotlo le ka go mo nyatsa! ");
INSERT INTO tsn_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ya re fa bontsi jwa batho bo sena go tswela kwa ntle, Jesu a tsena mo teng kwa go neng go namaletse morweetsana mme a mo tshwara ka seatla, mme a nanoga a itekanetse sentle gape. ");
INSERT INTO tsn_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mme pego ya kgakgamatso e e gakgamatsang e ya tlala mo lefatshing lotlhe. ");
INSERT INTO tsn_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ya re fa Jesu a tswa mo lwapeng lwa morweetsana, banna ba le babedi ba difofu ba mo sala morago ba goa ba re, “Ao Morwa Kgosi Dafide, re utlwele botlhoko.” ");
INSERT INTO tsn_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ba tsena mo tlung kwa a neng a nna teng, Mme Jesu a ba botsa a re, “A lo dumela fa ke nonofile go lo foufolola?” Ba re, “Morena, re a dumela.” ");
INSERT INTO tsn_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Hong a ama matlho a bone mme a re “Ka ntlha ya tumelo ya lona go tlaa diragala!” ");
INSERT INTO tsn_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mme ka tshoganetso ba foufologa! Jesu a ba laya gore ba seka ba itsise ope kaga selo seo, ");
INSERT INTO tsn_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","mme mo boemong jwa go dira jalo ba anamisa tumo ya gagwe gongwe le gongwe mo motsing. ");
INSERT INTO tsn_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Erile Jesu a tswa mo lefelong leo, a rakana le monna wa semumu yo o neng a sa kgone go bua ka ntlha ya mowa o o maswe o o neng o le mo go ene. ");
INSERT INTO tsn_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Hong Jesu a kgoromeletsa mowa o o maswe kwa ntle, mme gone fela foo monna a simolola go bua. Bontsi jwa batho jwa gakgamala thata ba re, “Ga go ise nke go diragale mo matshelong a rona go bona se se tshwanang le se.” ");
INSERT INTO tsn_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mme Bafarasai ba re, lebaka le a nonofileng go kgoromeletsa ntle mewa e e maswe ke gore ene ka bo ene o tsenywe ke mewa e e maswe. O tsenywe ke Satane Kgosi ya mewa e e maswe. ");
INSERT INTO tsn_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesu o na a tsamaya mo tikologong yotlhe mo magaeng a lefatshe leo, a ruta mo matlung a thuto ya Sejuda a anamisa Mafoko a a Molemo kaga Bogosi. Mme gongwe le gongwe kwa a neng a ya teng o na a fodisa batho mofuta mongwe le mongwe wa bolwetse. ");
INSERT INTO tsn_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mme o na a na le kutlwelo botlhoko thata mo bontsintsing jwa batho jo bo neng bo tla; ka gore matshwenyego a bone a ne a le matona thata mme ba sa itse se ba ka se dirang kgotsa kwa ba neng ba ka ya teng go bona thuso. Ba ne ba tshwana le dinku tse di senang modisa. ");
INSERT INTO tsn_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mme a raya barutwa ba gagwe a re “Thobo e kgolo thata mme barobi ba ba botlana thata. ");
INSERT INTO tsn_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jalo he, rapelang yo a leng motlhokomedi wa thobo, lo mo kope go thapa barobi ba bangwe ba masimo a gagwe.” ");
INSERT INTO tsn_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesu a ipiletsa barutwa ba ba lesome le bobedi, mme a ba naya taolo go kgoromeletsa mewa e e maswe ntle le go fodisa malwetse mangwe le mangwe le dipobolo. ");
INSERT INTO tsn_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Maina a barutwa ba gagwe ba ba lesome le bobedi ke a; Simone yo o bidiwang Petere, Anderea monnaa Petere; Jakobe morwa Sebede, Johane monnaa Jakobe, ");
INSERT INTO tsn_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo, Baretholomica, Thomase, Mathaio wa mokgethisi, Jakobe morwa Alefaio, Thadaeo, ");
INSERT INTO tsn_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simone (leloko la “diganka” tsa mokgatlho wa dipolotiki o o neng o batla go diga puso), Judase Isekariota yo o neng a mo oka. ");
INSERT INTO tsn_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesu o ne a ba roma ka ditaelo tse; “Se yeng kwa go Badichaba kgotsa Basamaria, ");
INSERT INTO tsn_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","mme yang fela kwa bathung ba Iseraela; dinku tsa Modimo tse di latlhegileng. ");
INSERT INTO tsn_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tsamayang lo anamise mo go bone gore Bogosi jwa legodimo bo atametse. ");
INSERT INTO tsn_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","“Fodisang ba ba lwalang, tsosang baswi, fodisang balepero, lo bo lo kgoromeletse mewa e e maswe kwa ntle. Nayang fela jaaka lo amogetse fela. ");
INSERT INTO tsn_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Se tseyeng madi mo dipateng fa lo tsamaya; ");
INSERT INTO tsn_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","lo se ka lwa tsaya le fa e le kgetsi ya diaparo e na le diaparo tse dingwe le ditlhako, le fa e le seikokotlelo, gonne ba lo ba thusang ba tshwanetse go lo otla le go lo tlhokomela. ");
INSERT INTO tsn_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nako le nako fa lo tsena mo motseng le mo metsaneng, senkang motho yo o boifang Modimo lo nne mo legaeng la gagwe go fitlhelela lo tswela kwa motseng o mongwe. ");
INSERT INTO tsn_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Fa lo kopa tetlelelo ya go nna, nnang botsalano le batho. ");
INSERT INTO tsn_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mme fa le itshupa e le legae la SeModimo, le segofatseng, fa go sa nna jalo, nnang ka tshegofatso ya lona. ");
INSERT INTO tsn_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Motse mongwe le mongwe kgotsa legac le le sa lo amogeleng sentle, lo itlhotlhore lorole lwa lefelo leo mo dinaong tsa lona fa lo tsamaya. ");
INSERT INTO tsn_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ammaaruri, metse e e maswe ya Sodoma le Gomora e tlaa nna botoka bogolo go metse eo ka Letsatsi la Katlholo. ");
INSERT INTO tsn_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ke lo roma jaaka dinku mo gare ga diphiri. Nnang botlhale jaaka dinoga le bori jaaka maphoi. ");
INSERT INTO tsn_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mme itlhokomeleng! Gonne lo tlaa tshwarwa, lo sekisiwa lo kgwathisiwa mo matlung a thuto. ");
INSERT INTO tsn_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","“Ee, lo tshwanetse go emela tshekiso fa pele ga balaodi le dikgosi ka ntlha ya me. Mo go tlaa lo neela lobaka lwa go ba bolelela ka ga me, ee, go supegetsa lefatshe. ");
INSERT INTO tsn_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","“Fa lo tshwarwa, se tshwenyegeng gore lo tlaa reng mo tshekong, gonne lo tlaa newa mafoko a a tshwanetseng ka nako e e tshwanetseng. ");
INSERT INTO tsn_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Gonne e tlaa bo e se lona ba lo buang; e tlaa bo e le Mowa wa ga Rraeno wa legodimo o bua ka lona. ");
INSERT INTO tsn_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Motho o tlaa okela morwa rraagwe losung, mme borabana ba tlaa oka bana ba bone. Mme bana ba tlaa tsogologela batsadi ba bone ba ba neela losung. ");
INSERT INTO tsn_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mongwe le mongwe o tlaa lo ila ka ntlha ya gore lo ba me. Mme lotlhe ba lo itshokang go ya bokhutlong lo tlaa bolokwa. ");
INSERT INTO tsn_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Fa lo bogisiwa mo motseng mongwe, tshabelang kwa go o mongwe! Ke tlaa boa pele ga lo tsena mo go yone yotlhe! ");
INSERT INTO tsn_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Morutwana ga a mogolo go feta moruti wa gagwe. Motlhanka ga a mogolo go mong wa gagwe. ");
INSERT INTO tsn_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Morutwana o tshwanetse go gata mo dikgatong tsa yo o mo rutang, motlhanka a latele mong wa gagwe. Mme fa ba reile nna mong wa ntlo lona jaanong go tlaa nna jang! ");
INSERT INTO tsn_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Mme lo se ka lwa boifa ba ba lo bopelang. Gonne nako e e tla e boammaaruri bo tlaa senolwang ka yone: merero ya bone ya sephiri e tlaa itsiwe ke batho botlhe. ");
INSERT INTO tsn_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Se ke se lo bolelelang mo lefifing jaanong jaana, se phatlalatseng kgakala fa bosigo bo o sa! Se ke se sebelang mo ditsebeng tsa lona, se phatlalatseng lo le mo ditlhoeng tsa matlo! ");
INSERT INTO tsn_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Se boifeng ba ba ka bolayang mebele ya lona fela; mme ba ka seka ba ama mewa ya lona! Boifang Modimo fela o o nonofileng go ka nyeletsa mowa le mmele mo moleting. ");
INSERT INTO tsn_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ga go thaga (kana di ja bokae? A di ja thebe di le pedi?) e e welang fa fatshe Rraeno wa Legodimo a sa itse. ");
INSERT INTO tsn_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mme le e leng meriri ya ditlhogo tsa lona tota e badilwe yotlhe. ");
INSERT INTO tsn_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ke gone se tshwenyegeng! Lona lo botlhokwa thata mo Modimong go feta dithaga tse dintsi. ");
INSERT INTO tsn_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Fa mongwe fela a mpolela mo mpepeneneng e le tsala yame ke tlaa mmolela ele tsala yame fa pele ga ga Rre yo o kwa legodimong. ");
INSERT INTO tsn_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mme fa mongwe a intatola mo mpepeneneng, ke tlaa mo itatola mo mpepeneneng fa pele ga ga Rre yo o kwa Legodimong. ");
INSERT INTO tsn_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Se gopoleng gore ke tletse go lere kagiso mo lefatsheng! Nnyaa fa e se chaka. ");
INSERT INTO tsn_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ke tletse go lotlhanya motho le rraagwe, mosetsana le mmaagwe, ngwetsi le matsalaa yone. ");
INSERT INTO tsn_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","“Bana ba motho ba ba maswe go fetisa selekanyo ba tlaa bo ba le mo ntlung ya gagwe tota. ");
INSERT INTO tsn_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Fa o rata rrago le mmago go gaisa jaaka o nthata, ga o a tshwanela go nna wa me; kgotsa fa o rata morwao kgotsa morwadio go mpheta, ga o a tshwanela go nna wa me. ");
INSERT INTO tsn_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Fa o gana go itshikarela mokgoro o ntshala morago, ga o a tshwanela go nna wa me. ");
INSERT INTO tsn_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Fa o ngaparela botshelo jwa gago, bo tlaa go latlhegela, mme yo o latlhegelwang ke botshelo jwa gagwe ka ntlha ya me, o tlaa bo boloka. ");
INSERT INTO tsn_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ba ba lo tsholang ‘sentle ba tshola nna. Mme fa ba ntshola ba tshola Modimo oo nthomileng’. ");
INSERT INTO tsn_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Fa lo tshola moporofiti ka ntlha ya gore ke monna wa Modimo, lo tlaa newa tuelo e moporofiti o e bonang. Mme fa lo amogela batho ba ba siameng, ba ba boifang Modimo ka ntlha ya boModimo jwa bone, lo tlaa newa tuelo e e tshwanang le ya bone. ");
INSERT INTO tsn_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mme fa lo siela ngwanyana kopi ya metse a a tsididi lo le baemedi ba me, ruri lo tlaa duelwa.” ");
INSERT INTO tsn_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mme e rile fa Jesu a sena go fetsa go nee-la barutwa ba gagwe ba ba lesome le metso e le mebedi ditaelo tse, a tsamaya mo metseng e ba neng ba tshwanetse go rera mo go yone. ");
INSERT INTO tsn_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Johane wa Mokolobetsi yo o neng jaanong a le mo kgolegelong, a utlwa kaga dikgakgamatso tsotlhe tse Mesia o neng a di dira, jalo a roma barutwa ba gagwe go botsa Jesu gore, ");
INSERT INTO tsn_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“A o ene tota yo re mo lebeletseng, kgotsa re nne re lebeletse?” ");
INSERT INTO tsn_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesu a ba raya a re, “Boelang kwa go Johane lo mmolelele kaga dikgakgamatso tse lo mponyeng ke di dira ");
INSERT INTO tsn_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","difofu tse ke di foufolotseng, le digole tse jaanong di tsamayang kwa ntle ga thuso le balepero ba ba fodisitsweng, le bosusu ba ba utlwang, le baswi ba ba rudisitsweng; lo bo lo mmolelele gore ke rerela bahumanegi mafoko a a molemo. ");
INSERT INTO tsn_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jaanong lo bo lo mo neela molaetsa o, ‘Go sego ba ba sa mpelaeleng.’ ” ");
INSERT INTO tsn_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Erile barutwa ba ga Johane ba sena go tsamaya, Jesu a simolola go bua le bontsintsi jwa batho ka ga gagwe a re, “Erile lo tswela mo sekakeng se se senang sepe go bona Johane, lo no lo solofetse gore lo tlaa mmona a ntse jang? A tshwana le tlhaga e e fokang mo phefong? ");
INSERT INTO tsn_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kgotsa a lo no lo solofetse go bona monna yo o apereng jaaka kgosana mo maphatsipatsing a bogosi? ");
INSERT INTO tsn_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kgotsa moporofiti wa Modimo? Ee, mme o mogolo go na le moporofiti fela. ");
INSERT INTO tsn_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Gonne Johane ke ene yo o umakilweng mo dikwalong; morongwa yo o neng a tshwanetse go tla pele game, go anamisa go tla game, le go baakanya batho go nkamogela. ");
INSERT INTO tsn_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ammaaruri, mo go botlhe ba ba kileng ba tsalwa, ga go na yo o galalelang thata go gaisa Johane wa Mokolobetsi. Mme le fa go ntse jalo, le masedi a mabotlana mo Bogosing jwa legodimo a tlaa nna a magolo go na nae! ");
INSERT INTO tsn_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Mme go simolola nako e Johane wa Mokolobetsi o neng a simolola go rera ka yone a kolobetsa go fitlhelela jaanong jaana, matshwititshwiti a a matlhagatlhaga a ntse a kgobokanela Bogosi jwa Legodimo, ");
INSERT INTO tsn_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Gonne melao yotlhe le baporofiti ba ne ba solofetse Mesia. Mme Johane a bonala, ");
INSERT INTO tsn_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","mme fa lo batla go tlhaloganya se ke se rayang, ke Elija; ene yo baporofiti ba rileng o tlaa tla ka nako e Bogosi bo simololang ka yone. ");
INSERT INTO tsn_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","“Fa e le gore lo kile lwa rata go reetsa, reetsang jaanong. ");
INSERT INTO tsn_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ke tlaa reng ka ga chaba e? Batho ba, ba tshwana le bana ba tshameka, ba ba rayang balekane ba bone ba re, ");
INSERT INTO tsn_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Re tshamekile lenyalo mme lwa seka lwa itumela, ra tshameka phitlho mme lwa seka lwa utlwa botlhoko’. ");
INSERT INTO tsn_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Gonne Johane wa Mokolobetsi ga a nwe le fa e le mofine, gape o itima dijo gantsi, mme lwa re, ‘O a tsenwa’. ");
INSERT INTO tsn_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mme nna, Morwa Motho, ke a ja e bile ke a nwa, mme lo ngongoregela gore ke ‘sejabobe, ke senwi, e bile ke dirisanya le mofuta o o maswe wa baleofi!’ Mme batho ba ba botlhale jaaka lona ba ka bona seipato mo go sengwe le sengwe se ba se dirang!” ");
INSERT INTO tsn_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mme a simolola go kgoba metse e a neng a dirile bogolo jwa dikgakgamatso dingwe tsa gagwe mo go yone ka gore e ne e sa boela mo Modimong. ");
INSERT INTO tsn_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","A re, “A bo go latlhega wena Korasina, a bo go latlhega wena Bethesaida! Gonne fa dikgakgamatso tse ke di dirileng mo mebileng ya lona di ne di dirilwe mo Ture le Sidona ba ba kgopo, batho ba teng ba ka bo ba sa bolo go sokologa ka ditlhong le boingotlo. ");
INSERT INTO tsn_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","“Ammaaruri Ture le Sidona ba tlaa bo ba le botoka go na le lona ka Letsatsi la Katlholo! ");
INSERT INTO tsn_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mme Kaperanama, lefa a tlotlwa thata, o tlaa fologela mo diheleng! Gonne fa dikgakgamatso tse dintle tse di dirilweng mo go wena di ka bo di dirilwe mo Sodoma, o ka bo a sa ntse a le teng le gompieno. ");
INSERT INTO tsn_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ammaaruri, Sodoma, o tlaa bo a le botoka go na le wena ka Letsatsi la Katlholo.” ");
INSERT INTO tsn_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mme Jesu a rapela thapelo e, “Rara, Morena wa legodimo le lefatshe, ke lebogela gore o fitlhetse ba ba ikgopolang ba le botlhale boammaaruri, mme wa bo senolela banyana! ");
INSERT INTO tsn_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ee, Rara, gonne go go kgatlhile go go dira ka tsela e!” ");
INSERT INTO tsn_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Boammaaruri jotlhe ke bo neetswe ke Rre. Rara fela ke ene a itseng Morwa, le Rara o itsiwe ke Morwa fela le ba Morwa o ba mo senolelang. ");
INSERT INTO tsn_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tlang kwano go nna mme ke tla lo lapolosa, lotlhe ba lo dirang thata ka fa tlase ga jokwe e e bokete. ");
INSERT INTO tsn_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Sikarang jokwe ya me, gonne e lo lekana sentle mmang ke lo rute; gonne ke bonolo le boingotlo, jalo lo tlaa bonela mewa ya lona tapologo, gonne ke lo naya merwalo e e motlhofo fela.” ");
INSERT INTO tsn_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mme erile ka lobaka loo, ka letsatsi le-ngwe Jesu a tsamaya a raletse masimo a mabele le barutwa ba gagwe. Go ne go le letsatsi la Sabata, letsatsi la Sejuta la kobamelo-Modimo, barutwa ba gagwe ba ne ba tshwerwe ke tlala, jalo ba simolola go roba diako tsa mabele ba a ja. ");
INSERT INTO tsn_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mme Bafarasai bangwe ba ba bona ba dira jalo mme ba go tlhabantsha ba re, “Barutwa ba gago ba tlola molao. Ba roba go le Sabata.” ");
INSERT INTO tsn_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mme Jesu a ba raya a re, “A ga lo ise nke lo bo lo bale se Kgosi Dafide o neng a se dira fa a bolailwe ke tlala le ditsala tsa gagwe? ");
INSERT INTO tsn_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","O na a tsena mo Tempeleng mme ba a ja senkgwe se se faphegileng se se letleletsweng baperesiti fela. Moo le gone e ne e le go tlola molao! ");
INSERT INTO tsn_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Gape a ga lo ise nke lo bo lo bale mo molaong wa ga Moshe ka fa baperesiti ba ba mo tirong mo Tempeleng, ba ka dirang ka teng go le Sabata? ");
INSERT INTO tsn_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mme ammaaruri, mongwe o fano yo o mogolo go Tempele! ");
INSERT INTO tsn_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mme fa lo ka bo lo itsile tlhaloso ya temana ya lokwalo lo lo reng, ‘Ke batla gore lo nne kutlwelobotlhoko go feta jaaka ke batla dimpho tsa lona,’ lo ka bo lo sa sekisa ba ba senang molato. ");
INSERT INTO tsn_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Gonne Morwa Motho, ke Morena le wa Sabata tota.” ");
INSERT INTO tsn_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Mme ka nako eo a ya kwa ntlung ya thuto, ");
INSERT INTO tsn_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mme teng koo a bona monna yo o golafetseng seatla. Bafarasai ba botsa Jesu ba re, “A go letleletswe go fodisa ka letsatsi la Sabata?” (Tota ba ne ba solofetse gore o tlaa re, “Ee”, gore ba tle ba mo tshware). ");
INSERT INTO tsn_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Hong Jesu a fetola a re; “Fa o ne o na le nku e le yosi fela, ya be e wela mo sedibeng go le Sabata, a o no o ka dira gore o e falotshe ka letsatsi leo? Ee tota o no o ka dira jalo. ");
INSERT INTO tsn_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mme motho o tlhwatlhwa-kgolo thata jang go feta nku! Ee go siame go dira tshiamo ka Sabata!” ");
INSERT INTO tsn_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Mme a raya monna yoo a re, “Otlolola lebogo la gago.” Mme ya re a le otlolola, seatla sa gagwe sa itekanela, fela jaaka se sengwe! ");
INSERT INTO tsn_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mme, Bafarasai ba bitsa phuthego go loga maano a ka fa ba ka tshwarang le go bolaya Jesu ka teng. ");
INSERT INTO tsn_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Mme a itse leano le ba neng ba le loga, mme a tswa mo ntlung ya thuto a setswe morago ke bontsi. A fodisa botlhe ba ba lwalang mo go bone, ");
INSERT INTO tsn_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","mme a ba tlhagisa gore ba seka ba anamisa mafoko kaga dikgakgamatso tsa gagwe. ");
INSERT INTO tsn_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Se se diragaditse seporofeso sa ga Isaia se se buang ka ga Jesu se re. ");
INSERT INTO tsn_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Bonang motlhanka wa me. Bonang yo ke mo itshenketseng. Ke moratwi wa me, yo mowa wa me o itumelang mo go ene, ke tlaa tsenya mowa wa me mo go ene o tlaa atlhola dichaba. ");
INSERT INTO tsn_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ga a lwe e bile ga a goe; ga a tlhatlose lentswe la gagwe! ");
INSERT INTO tsn_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ga a repitletse ba ba bokoa, kgotsa go timola tsholofelo e potlana; o tlaa wetsa ntwa ya gagwe yotlhe ka phenyo, ");
INSERT INTO tsn_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","mme leina la gagwe le tlaa nna tsholofelo ya lefatshe lotlhe.” ");
INSERT INTO tsn_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mme ga leriwe kwa go Jesu monna yo o tsenyweng ke badimo, a le sefofu a bile a le semumu, mme Jesu a mo fodisa gore a bue a ba a bone. ");
INSERT INTO tsn_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bontsintsi jwa batho ba gakgamala ba re, “Kgotsa Jesu ke Mesia.” ");
INSERT INTO tsn_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mme e rile fa Bafarasai ba utlwa kaga kgakgamatso e ba re, “O ka kgoromeletsa mewa e e maswe ntle ka gore ke Satane, kgosi ya mewa e e maswe.” ");
INSERT INTO tsn_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesu a itse megopolo ya bone mme a fetola a re, “Bogosi jo bo kgaoganyeng bo felela ka go pheretlhana. Motse kgotsa lolwapa lo lo ikgaoganyang ga lo ka ke lwa ema. ");
INSERT INTO tsn_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mme fa Satane a kgoromeletsa Satane ntle, o a itwantsha o bile o senya bogosi jwa gagwe. ");
INSERT INTO tsn_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mme fa e le gore lwa re, ke goromeletsa mewa e e maswe ntle, ka go dirisa dinonofo tsa ga Satane, jaanong batho ba lona ba dirisa nonofo efe go e kgoromeletsa ntle? A ba arabele ka fa lo mpegang molato ka teng. ");
INSERT INTO tsn_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mme fa ke kgoromeletsa mewa e e maswe ntle ka Mowa wa Modimo, hong bogosi jwa Modimo bo tsile mo go lona. ");
INSERT INTO tsn_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Motho ga a ka ke a thopa bogosi jwa ga Satane kwa ntleng ga gore a golege Satane pele. Ke gone fela mewa ya gagwe e e maswe e ka kgoromelediwang ntle a sena go golegwa. ");
INSERT INTO tsn_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Le fa e le mang yo o sa nthuseng o nkutlwisa botlhoko. ");
INSERT INTO tsn_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","“Mme le fa e le mang yo o ntlhapatsang kgotsa a bua sebe sengwe fela, o tlaa itshwarelwa tsotlhe, fa e se se sengwe fela: go bua bosula kgatlhanong le Mowa o o Boitshepo ga go na go itshwarelwa mo lefatshing leno, le fa e le mo lefatshing le le tlang. ");
INSERT INTO tsn_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Setlhare se lemogwa ka loungo lwa sone. Setlhare se se tlhophilweng mo mofuteng o o faphegileng se ungwa loungo lo lo siameng; mefuta e e seng yone ga e ungwe loungo lo lo siameng. ");
INSERT INTO tsn_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Losika lwa dinoga ke lona! Batho ba ba bosula jaaka lona ba ka bua se se molemo le tshiamo jang? Gonne pelo ya motho e laola puo ya gagwe. ");
INSERT INTO tsn_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Puo e e molemo ya motho e senola mahumo a a mo go ene. Motho yo o pelo e bosula o tletse botlhole le puo ya gagwe e a bo supa. ");
INSERT INTO tsn_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mme ke lo bolelela se, gore lo tlamega go arabela lefoko lengwe le lengwe le lo le buang la boithamako ka letsatsi la katlholo. ");
INSERT INTO tsn_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","“Mafoko a lona a supa se se tlaa lo diragalelang ka nako eo: lo ka nna lwa siamisiwa kgotsa lwa sekisiwa ka one.” ");
INSERT INTO tsn_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Letsatsi lengwe baeteledipele ba Sejuta le Bafarasai bangwe, ba tla kwa go Jesu ba mo kopa go bona kgakgamatso go supa gore a ke ene Mesia tota. ");
INSERT INTO tsn_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","40","Mme Jesu a fetola a re, “Sechaba se se bosula se se senang tumelo ke sone fela se ne se ka kopa bosupi bongwe gape; mme bope ga bo kitla bo dirwa fa e se fela se se neng sa diragalela moporofiti Jona! Gonne fela jaaka Jona a ne a le mo mpeng ya leruarua malatsi a le mararo le masigo a le mararo, jalo he, nna Morwa Motho, ke tlaa nna mo mpeng ya lefatshe malatsi a le mararo le masigo a le mararo. ");
INSERT INTO tsn_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Banna ba Ninefe ba tlaa ema kgatlhanong le chaba e kwa tshekong ba lo bona molato. Gonne e rile fa Jona a ba rerela ba ne ba sokologa mo ditseleng tsa bone tsotlhe tse di bosula ba boela mo Modimong. Mme jaanong yo mogolo go feta Jona o fano mme lo gana go mo dumela. ");
INSERT INTO tsn_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Kgosigadi ya Sheba e tlaa emelana le chaba e, e e bona molato; gonne o dule kwa lefatshing le le kgakala go tla go utlwa botlhale jwa ga Solomone, mme jaanong yo mogolo go feta Solomone o fano; mme lo gana go mo dumela. ");
INSERT INTO tsn_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","45","“Chaba e e bosula e, e tshwana le motho a tsenywe ke mowa o o maswe. Gonne fa mowa o o maswe o tswa mo go ene, o ya mo dikakeng ka lobakanyana, o senka boikhutso mme o seke o bo bone. Mme o re, ‘Ke tlaa boela kwa mothong yo ke neng ke tswa mo go ene’ o boe o fitlhele pelo ya motho yoo e le phepa e bile e sena sepe mo teng! Mme mowa o o maswe o bone mewa e mengwe e supa e e bosula go o gaisa, mme yotlhe e tsene motho yoo e nne mo go ene. Mme a bife go gaisa pele.” ");
INSERT INTO tsn_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","47","Ka Jesu a na a bua mo ntlung e e tletseng batho, mmaagwe le bomonnawe ba ne, ba le kwa ntle kwa, ba batla go bua nae. Mme erile mongwe a mmolelela gore ba foo, ");
INSERT INTO tsn_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","a fetola a re, “Mme ke Mang? Bonnake ke bomang?” ");
INSERT INTO tsn_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","A supa barutwa ba gagwe a re, “Bonang! Mme le bonnake ke ba.” ");
INSERT INTO tsn_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mme a oketsa ka gore, “Le fa ele mang yo o reetsang Rre kwa Legodimong ke nnake, kgaitsadiake le mme.” ");
INSERT INTO tsn_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mme ya re morago ga lone letsatsi leo, Jesu a tswa mo tlung a fologela kwa lotshitshing lwa lewatle, ");
INSERT INTO tsn_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","3","kwa boidiidi jwa batho bo neng jwa tloga jwa kokoanela teng. O na a tsena mo mokorong mme a ruta a le mo go one fa batho ba reeditse ba le mo lotshitshing. O na a bolela dipolelo di le dintsi ka ditshwantsho jaaka e e reng, “Mojadi o ne a jala mabele mo masimong a gagwe. ");
INSERT INTO tsn_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Erile fa a ntse a gasa peo, e nngwe ya wela mo tseleng mme dinonyane tsa tla tsa e e ja. ");
INSERT INTO tsn_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","“Mme e nngwe ya wela mo mmung o o maje, mo go neng go na le mmunyana o o motlhofo; dijalo tsa tlhoga ka bofefo sentle mo mmunyaneng oo, ");
INSERT INTO tsn_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","mme letsatsi le le molelo la tloga la di fisa mme tsa swaba tsa a swa, ka gore di ne di na le medinyana fela. ");
INSERT INTO tsn_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Dipeo tse dingwe tsa wela mo mitlweng, mme mitlwa ya di hupetsa di sena go tlhoga. ");
INSERT INTO tsn_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mme tse dingwe tsa wela mo mmung o o siameng, mme tsa ungwa ga masome a mararo, masome a marataro, le lekgolo go le go tona go feta jaaka a ne a jetse. ");
INSERT INTO tsn_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Fa lo na le ditsebe utlwang!” ");
INSERT INTO tsn_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Barutwa ba gagwe ba tla ba mmotsa ba re, “Ke eng fa o aga o dirisa ditshwantsho tse di thata go tlhaloganngwa?” ");
INSERT INTO tsn_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Hong a ba tlhalosetsa gore ke bone fela ba ba letleletsweng go tlhaloganya ka ga Bogosi jwa Legodimo, mme ba bangwe bone ga ba a letlelelwa. ");
INSERT INTO tsn_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","13","A ba a ba tlhalosetsa a re, “Ka gore yo o nang le sengwe o tlaa okelediwa, o tlaa nna le go le go tona; mme yo o senang sepe o tlaa tseelwa le bonnyenyane jo a nang najo. Ke sone se ke dirisang ditshwantsho tse ka sone, jalo he batho ba tlaa utlwa, ba bo ba bona, mme ga ba kitla ba tlhaloganya.” ");
INSERT INTO tsn_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Mo go diragatsa seporofeso sa ga Isaia se se reng, ‘Ba a utlwa, mme ga ba tlhaloganye; ba a leba mme ga ba bone. ");
INSERT INTO tsn_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Gonne dipelo tsa bone di thata, ditsebe tsa bone di kabetse, mme ba ipuduladitse mo borokong. ");
INSERT INTO tsn_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jalo ga ba kitla ba bona le go utlwa le go tlhaloganya le go boela kwa Modimong gape, le go ntetla go ba fodisa.’ Mme go sego matlho a lona gonne lo a bona; le ditsebe tsa lona gonne di a utlwa. ");
INSERT INTO tsn_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Baporofiti ba le bantsi le batho ba ba boifang Modimo ba tlhologeletswe go bona dilo tse lo di bonyeng, le go utlwa dilo tse lo di utlwileng, mme ga ba a ka ba di utlwa le fa e le go di bona. ");
INSERT INTO tsn_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Jaanong tlhaloso ya polelo e ke e lo boleletseng kaga molemi a jala ke e: ");
INSERT INTO tsn_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","tsela e e kwakwaletseng e peo e nngwe e neng ya wela mo go yone e raya pelo ya motho yo o utlwang mafoko a a molemo kaga Bogosi mme a ba a sa a tlhaloganye; mme Satane a ba a tla a phamola peo mo pelong ya gagwe. ");
INSERT INTO tsn_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mmu o o maje o o motlhofo o raya pelo ya motho yo o utlwang molaetsa a ba a o amogela ka boitumelo, ");
INSERT INTO tsn_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","mme a se na modi mo botshelong jwa gagwe, le peo ga e tlhogele kwa teng, mme e re moragonyana fa matshwenyego a tla, kgotsa pogiso e simologa ka ntlha ya tumelo ya gagwe, tlhoafalo ya gagwe e swe, a ba a we mo tumelong. ");
INSERT INTO tsn_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mmu o o tlhogileng o o khurumeditsweng ke mitlwa o raya motho yo o utlwang molaetsa, mme ditlhobaelo tsa botshelo le keletso ya gagwe ya madi di hupetse Lefoko la Modimo, mme a direle Modimo ka boutsana. ");
INSERT INTO tsn_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mmu o o siameng o raya pelo ya motho yo o reetsang molaetsa a ba a o tlhaloganya a tswela kwa ntle a ya go lere ba bangwe ba le masome mararo, masome marataro kgotsa lekgolo mo Bogosing.” ");
INSERT INTO tsn_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Setshwantsho se sengwe ke se, se Jesu o neng a se dirisa: “Bogosi jwa Legodimo bo tshwana le molemi a jala peo e e siameng mo tshimong ya gagwe. ");
INSERT INTO tsn_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mme ya re bosigo bongwe a robetse, mmaba wa gagwe a tla a jala mhero mo gare ga mabele. ");
INSERT INTO tsn_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Erile dijalo di simolola go tlhoga, mhero le one wa tlhoga. ");
INSERT INTO tsn_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Batlhanka ba mong wa tshimo ba tla ba mmolelela ba re, ");
INSERT INTO tsn_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Mmaba ke ene a dirileng jalo, mme ba mo raya ba re, ‘A re ka kumula mhero?’ ");
INSERT INTO tsn_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Mme a fetola a re, ‘Nyaa lo tlaa utlwisa mabele botlhoko fa lo dira jalo. ");
INSERT INTO tsn_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Lesang gotlhe go gole mmogo go fitlhelela motlha wa thobo, mme ke tlaa raya barobi ba kokoanya mhero ba o tshuba, ba baya mabele mo ntlung ya polokelo’.” ");
INSERT INTO tsn_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Sengwe sa ditshwantsho tsa gagwe ke se: “Bogosi jwa Legodimo bo tshwana le peo e nnyennyane ya mosetara e e lemilweng mo tshimong. Ke peo e potlana mo dipeung tsotlhe, mme e nna setlhare se se tona mo ditlhareng tsotlhe, se be se gole go nna setlhare se dinonyane di ka tlang tsa aga mo go sone.” ");
INSERT INTO tsn_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Gape o dirisa sekai se: “Bogosi jwa Legodimo bo ka tshwantshiwa le mosadi a dira senkgwe. O tsaya selekanyo sa bopi a se tlhakanye mo sebidisong go fitlhelela se tlhakatlhakana le bopi.” ");
INSERT INTO tsn_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","35","Jesu o na a dirisa ditshwantsho tse gangwe le gape ka tlhaloso fa a bua le bontsintsi jwa batho. Tota le gone ka gore baporofiti ba ne ba boletse gore o tlaa dirisa di le dintsi, o na a seke a bua le bone kwa ntleng ga go dirisa setshwantsho. Gonne go no ga porofitwa gatwe, “Ke tlaa bua ka ditshwanatsho, ke tlaa tlhalosa dikgakgamatso tse di saleng di lojwa go tswa kwa tshimologong.” ");
INSERT INTO tsn_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mme erile a tlogela matshwititshwiti kwa ntle a tsena mo tlung. Barutwa ba gagwe ba mo kopa gore a ba tlhalosetse polelo ya mhero le mabele. ");
INSERT INTO tsn_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","A re, “Go siame”. Ke nna molemi yo o jalang peo e siameng. ");
INSERT INTO tsn_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","“Tshimo e emetse lefatshe ka bophara, mme peo e emetse batho ba Bogosi jwa Legodimo mme mhero ke batho ba ga Satane. ");
INSERT INTO tsn_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mmaba yo o jalang mhero mo mabeleng ke Diabole; thobo ke bokhutlo jwa lefatshe mme barobi ke baengele. ");
INSERT INTO tsn_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Fela jaaka ere mo polelong e, mhero o bo o tlosiwa mo mabeleng o ba o tshujwa, go tlaa nna fela jalo ka bokhutlo jwa lefatshe. ");
INSERT INTO tsn_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ke tlaa romela baengele bame mme ba tlaa tlosa mo Bogosing jwa Legodimo, thaelo nngwe le nngwe le botlhe ba ba boleo, ");
INSERT INTO tsn_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","mme ba ba latlhele mo moubeng ba ba tshube. Go tlaa nna selelo le khuranyo ya meno. ");
INSERT INTO tsn_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jalo ba ba itshepileng ba tlaa phatsima jaaka letsatsi mo Bogosing jwa ga Rraabo. A ba ba nang le tsebe ba utlwe! ");
INSERT INTO tsn_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Bogosi jwa Legodimo bo tshwana le letlotlo le monna mongwe a neng a le bona mo tshimong. Monna yo, erile ka go tsenekega, a rekisa ditsagagwe tsotlhe gore a tle a reke tshimo a bo a rue letlotlo leo. ");
INSERT INTO tsn_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Gape, Bogosi jwa Legodimo bo tshwana le morekisi wa mekgabisa (diperela) mme a tsoma tsa marata-go-lejwa. ");
INSERT INTO tsn_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","O ne a bona ya botlhokwa, e e tlhotlhwa kgolo—mme a rekisa gotlhe mo a neng a na nago gore a tle a e reke. ");
INSERT INTO tsn_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","48","“Gape, Bogosi jwa legodimo bo ka tshwantshanngwa le motshwara-ditlhapi, yo o latlhelang letloa la gagwe mo metsing a ba a tshwara methalethale ya ditlhapi, dingwe di le tlhotlhwa kgolo tse dingwe di sena tiro. Fa letloa le tletse, o le gogela fa lotshitshing, a nna fatshe a tlhopha tse di ka nnang monate a bo a di paka mo matloleng mme tse dingwe a di latlhela koo. ");
INSERT INTO tsn_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Go tlaa nna fela jalo ka bokhutlo jwa lefatshebaengele ba tlaa tla go tlhopha baikepi mo baitsheping, ");
INSERT INTO tsn_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ba latlhela ba ba bosula mo moleting. Go tlaa nna selelo le khuranyo ya meno. ");
INSERT INTO tsn_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","A lo a utlwisisa?” Mme ba araba ba re, “Ee re a utlwisisa!” ");
INSERT INTO tsn_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Mme o ne a tswelela a re, “Baitseanape ba molao wa Sejuta ba jaanong e leng barutwa ba me ba humile ntlheng tsotlhe-ebong mo kitsong ya Testamente E Kgologolo le mo go ya e Ntsha.” ");
INSERT INTO tsn_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Erile Jesu a sena go bolela dipolelo tse, a boela kwa ga gabo kwa Nasaretha mo Galalea mme a ruta mo ntlung ya thuto mo a gakgamaditseng batho ka botlhale jwa gagwe le dikgakgamatso. ");
INSERT INTO tsn_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Batho ba ne ba ipotsa ba re, “A ke gone? Ke ngwana fela wa mmetli, le Marea mmaagwe re a mo itse le bomorwarraagwe bo Jakoba, Josefa, Simone le Jutase. ");
INSERT INTO tsn_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Le bokgaitsadie, botlhe ba nna mono. O ka tuma jang mo go kanakana?” ");
INSERT INTO tsn_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mme ba mo shakgalela. Mme Jesu a ba raya a re, “Moporofiti o tlotlwa gongwe le gongwe, fa ese kwa ga gabo a bile a nyadiwa ke ba ga gabo.” ");
INSERT INTO tsn_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jalo o ne a dira dikgakgamatso di se kaenyana fela, ka ntata ya go tlhoka tumelo ga bone. ");
INSERT INTO tsn_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mme erile fa Kgosi Herode a utlwa kaga Jesu, ");
INSERT INTO tsn_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","A raya banna ba gagwe a re, “Yo e tshwanetse ya bo e le Johane wa Mokolobetsi a rudile. Ke gone ka mo a kgonang go dira dikgakgamatso.” ");
INSERT INTO tsn_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Gonne Herode o na a tshwere Johane a mo golegile ka dikeetane mo kgolegelong ka topo ya mosadi wa gagwe Herodiase mosadi yo o kileng a bo a le wa ga Filipo morwarraagwe, ");
INSERT INTO tsn_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","gonne Johane o ne a mo reile a re, ga go a siama gore a mo nyale. ");
INSERT INTO tsn_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","O ka bo a ne a bolaya Johane mme o ne a boifa mokubukubu o batho ba ka o tsosang, ka gore batho botlhe ba ne ba dumela gore Johane ke moporofiti. ");
INSERT INTO tsn_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mme ya re ka mokete wa botsalo jwa ga Herode, morwadia Herodiase a bina mo go neng ga kgatlha Herode thata, ");
INSERT INTO tsn_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","hong a mo solofetsa ka ikano gore o tlaa mo naya le fa e le eng se o tlaa se lopang. ");
INSERT INTO tsn_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jalo he, ka go tlhotlhelediwa ke mmaagwe, ngwanyana a kopa tlhogo ya ga Johane wa Mokolobetsi e le mo mogotswaneng. ");
INSERT INTO tsn_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kgosi e ne ya utlwa botlhoko, mme ka ntlha ya ikano ya yone, gape ka gore e ne e sa batle go boela lefoko la yone ka morago fa pele ga balalediwa, ya ntsha taolo ya gore go dirwe jalo. ");
INSERT INTO tsn_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jalo, Johane a kgaolwa tlhogo a le mo kgolegelong, ");
INSERT INTO tsn_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","tlhogo ya gagwe ya leriwe ka mogotswana, ya neelwa morweetsana yo o neng a e isa kwa go mmaagwe. ");
INSERT INTO tsn_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Hong barutwa ba ga Johane ba tla go tsaya setopo sa gagwe go ya go se boloka mme ba ya go bolelela Jesu se se diragetseng. ");
INSERT INTO tsn_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Mme erile fela fa Jesu a utlwa mafoko a, a tsamaya ka boene ka mokoro go ya kwa thoko go nna a le nosi. Mme bontsintsi jwa bona kwa o neng a ya teng, mme ba mo sala morago ka dinao ba tswa mo magaeng a mantsi. ");
INSERT INTO tsn_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Hong ya re Jesu a tswa mo nageng, bontsintsi jo bogolo jwa batho jwa bo bo mo letile mme a ba tlhomogela pelo a ba a fodisa balwetse. ");
INSERT INTO tsn_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Maitseboeng ao barutwa ba gagwe ba tla kwa go ene ba re, “Lobaka lwa dijo lo setse lo fetile, mme ga gona sepe se se ka jewang fano mo sekakeng; phatlalatsa bontsintsi jwa batho gore ba ye mo magaeng ba reke dijo!” ");
INSERT INTO tsn_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Mme Jesu a fetola a re, “Mo ga go tlhokafale, ba feng dijo!” ");
INSERT INTO tsn_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Mme ba mo raya ba re, “Ga tweng! Re na le dinkgwe di le tlhano tse di nnye le ditlhapi di le pedi!” ");
INSERT INTO tsn_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesu a ba raya a re, “Di lereng kwano.” ");
INSERT INTO tsn_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Hong a raya batho a re ba nne fa fatshe mo bojannyeng mme a tsaya dinkgwe tse tlhano le ditlhapi tse pedi, a leba kwa godimo mo loaping a kopela dijo tshegofatso ya Modimo, hong a ngathoganya dinkgwe a di neela barutwa ba gagwe go di abela batho. ");
INSERT INTO tsn_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mme mongwe le mongwe a ja go fitlhelela a kgora! Mme erile ba sela masalela kwa morago, ga sala diroto di le lesome le bobedi tse di tletseng. ");
INSERT INTO tsn_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","E ne e ka nna banna ba le dikete tse tlhano mo bontsintsing jwa batho tsatsing leo, kwa ntle ga basadi le bana. ");
INSERT INTO tsn_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ka bofefo morago ga moo, Jesu a raya barutwa ba gagwe a re ba tsene mo mokorong go kgabaganyetsa ntlheng e nngwe ya lecha fa a sa ntse a phatlalaletsa batho kwa gae. ");
INSERT INTO tsn_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","24","Morago ga moo a tlhatloga dithaba go ya go rapela. Bosigo jwa tla, mme kwa lecheng barutwa ba ne ba le mo matshwenyegong. Gonne phefo e ne e tsogile ba tshwere bothata mo mawatleng a a sa sisibalang. ");
INSERT INTO tsn_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Erile e ka nna nako ya bone mo mosong, Jesu a tla kwa go bone a tsamaya mo godimo ga metse. ");
INSERT INTO tsn_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ba gowa ka letshogo gonne ba ne ba gopola gore ke sepoko. ");
INSERT INTO tsn_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mme Jesu ka bofefo a bua nabo a ba nametsa. A re, “Ke nna se boifeng!” ");
INSERT INTO tsn_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Hong Petoro a mo fetola a re, “Rra, fa o le ene tota, nthaya ke tle kwa go wena ke tsamaya mo godimo ga metse.” ");
INSERT INTO tsn_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Mme Morena a re, “Go siame, tla kwano.” Hong Petoro a fologa mokoro a tsamaya fa godimo ga metsi a ya kwa go Jesu. ");
INSERT INTO tsn_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mme erile fa a leba kwa godimo, a tshoga mme a simolola go nwela. A gowa a re, “Mpoloka Morena!” ");
INSERT INTO tsn_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Gone fela foo Jesu a otlolola lebogo a mmoloka. Jesu a re, “A motho wa tumelo e potlana, ke eng fa o no o belaela. ");
INSERT INTO tsn_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Mme fa ba sena go palama mo mokorong, phefo ya didimala?” ");
INSERT INTO tsn_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ba bangwe ba nna ba tseanye, ba goa ba re, “O Morwa Modimo tota!” ");
INSERT INTO tsn_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mme ba fitlha kwa Genesareta. ");
INSERT INTO tsn_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Dikgang tsa go goroga ga bone tsa anama ka bofefo mo tikologong yotlhe ya motse, mme ka bofefo batho botlhe ba tswa mo motseng ba ya go bolelela batho gore ba lere balwetse ba bone go tla go fodisiwa. ");
INSERT INTO tsn_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Balwetse ba mo kopa gore a ba letlelele go ama momeno wa seaparo sa gagwe, mme botlhe ba ba neng ba ama momeno wa seaparo sa gagwe ba fodisiwa. ");
INSERT INTO tsn_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Bafarasai bangwe le baeteledipele ba Sejuda ba goroga ba tswa Jerusalema go tla go buisanya le Jesu. ");
INSERT INTO tsn_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Mme ba mmotsa ba re, “Ke eng fa barutwa ba gago ba tlola ngwao ya Sejuda ya bogologolo? Ka gore ba tlhokomologa mokgwa wa setho sa rona wa go tlhapa diatla pele ga ba a ja.” ");
INSERT INTO tsn_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","A fetola a re, “Mme ke go reng fa ngwao ya lona e le kgatlhanong le melao e e tlhamaletsengya Modimo? ");
INSERT INTO tsn_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Sekai ke se, molao wa Modimo wa re, ‘Tlotla rrago le mmago; yo o buang bosula ka batsadi ba gagwe o tshwanetse go swa’. ");
INSERT INTO tsn_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Mme lwa re, ‘Le fa batsadi ba lona ba tlhoka, go na le gore lo ba neye madi a dilo tse ba di tlhokang, bogolo lo ka a isa kwa kerekeng.’ Mme jalo ka molao wa lona o o itiretsweng ke motho, lo nyeletsa molao o o tlhamaletseng wa Modimo wa go tlotla le go tlhokomela batsadi ba lona. ");
INSERT INTO tsn_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Baitimokanyi ke lona! Isaia o porofitile sentle ka ga lona a re, ");
INSERT INTO tsn_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Batho ba ba re baa ntlotla, mme dipelo tsa bone di kgakala. ");
INSERT INTO tsn_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kobamelo ya bone ga e na molemo, ka gore ba ruta melao ya bone e ba e itiretseng mo boemong jwa ya Modimo’ ”. ");
INSERT INTO tsn_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Hong Jesu a bitsa bontsintsi jwa batho a re, “Reetsang se ke se buang, lo bo lo leke go se tlhaloganya: ");
INSERT INTO tsn_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ga lo itshekololwe ke go ja dijo tse di idiwang ka molao wa Sejuda! Ke se lo se buang lo bile lo se akanya se se lo leswafatsang.” ");
INSERT INTO tsn_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Hong barutwa ba tla ba mo raya ba re, “O kgopisitse Bafarasai ka lefoko lele.” ");
INSERT INTO tsn_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Jesu a fetola a re, “Setlhatshana sengwe le sengwe se se sa jalwang ke Rre se tlaa kumulwa ka medi, jalo he, ba itlho komoloseng. Ke bagogi ba ba foufetseng ba goga difofu, mme di tlaa wela mmogo mo khuting.” ");
INSERT INTO tsn_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Hong Petoro a kopa Jesu go tlhalosa se a neng a se raya fa a re batho ga ba leswafadiwe ke dijo tse di idiwang ka molao wa Sejuda. ");
INSERT INTO tsn_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Mme Jesu a mmotsa a re, “A ga o tlhaloganye? ");
INSERT INTO tsn_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ga o bone gore sengwe fela se o se jang, se tsena mo mpeng se be se tswela kwa ntle. ");
INSERT INTO tsn_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mme mafoko a a bosula a tswa mo pelong e e bosula, a ba a leswafatsa motho yo o a buang. ");
INSERT INTO tsn_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gonne mo pelong go tswa dikakanyo tse di bosula, polao, kgokafalo, boaka, bogodu, maaka le pateletso. ");
INSERT INTO tsn_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tse ke tsone dilo tse di leswafatsang; mme ga go na teswafatso ya semowa ka go ja pele ga o tlotla ngwao ya go tlhapa diatla.” ");
INSERT INTO tsn_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesu a tloga foo, a tsamaya dimaele di le masome matlhano go ya Ture le Sidona. ");
INSERT INTO tsn_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mosadi yo o tswang Kanana yo a neng a nna teng, a tla kwa go ene a kopa a re, “Nkutlwela botlhoko, Ao Morena, Morwa Kgosi Dafide! Gonne morwadiake o tsenywe ke mowa o o maswe o mo tlhokofatsa gangwe le gape.” ");
INSERT INTO tsn_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mme Jesu a seka a mo fetola le fa e le go bua lefoko lepe! Barutwa ba gagwe ba mo kopa ba re, “Mo reye a tsamaye, ka o re tshwenya ka go kopa ga gagwe.” ");
INSERT INTO tsn_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mme a raya mosadi a re, “Ke rometswe go thusa Bajuda e seng Badichaba.” ");
INSERT INTO tsn_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mme a tla a mo obamela a mo rapela gape a re, “Nthusa!” ");
INSERT INTO tsn_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesu a mo raya a re, “Ga go bonale go siame go tsaya dijo mo baneng o di latlhelela dintsa.” ");
INSERT INTO tsn_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mme mosadi a re, “Ee, mme go siame ka gore le dintsanyana ka fa tlase ga lomati lwa bojelo di letlelelwa go ja mahohora a a wang.” ");
INSERT INTO tsn_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mme Jesu a mo raya a re, “Mosadi, tumelo ya gago e kgolo, mme kopo ya gago e letleletswe.” Mme Morwadie a fodisiwa gone fela foo! ");
INSERT INTO tsn_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Erile morago ga moo a boela kwa lewatleng la Galalea, a palama thaba a nna gone. ");
INSERT INTO tsn_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mme bontsintsi jwa batho jwa lere kwa go ene ba ba tlhotsang, difofu, digole, le dimumu le ba bangwe ba bantsi, ba ba baya fa pele ga ga Jesu, mme a ba fodisa botlhe. ");
INSERT INTO tsn_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","E ne ya nna kgakgamalo jang! Ba pele ba neng ba ntse ba sa kgone go bua ba ne ba bua ka boitumelo, digole di ne di tsamaya di tlolaka, le ba ba neng ba le difofu ba ne ba bona! Bontsintsi jwa batho jwa gakgamala fela, mme ba galaletsa Modimo wa Iseraele. ");
INSERT INTO tsn_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Mme Jesu a bitsa barutwa ba gagwe a re, “Ke tlhomogela batho ba pelo, ba ntse ba le fano le nna malatsi a le mararo jaanong, mme ga baa salelwa ke sepe go se ja; ga ke batle go ba phatlalatsa ba bolailwe ke tlala, kgotsa e ka re gongwe ba idibala mo tseleng.” ");
INSERT INTO tsn_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Barutwa ba fetola ba re, “Mme re tlaa bona dijo tse di lekanyeng kae fano mo sekakeng gore batho ba botlhe ba je?” ");
INSERT INTO tsn_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesu a ba botsa a re, “Lo na le dijo di le kae?” ba fetola ba re, “Re na le dinkgwe di supa le ditlhatswana di se kae.” ");
INSERT INTO tsn_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Hong Jesu a raya batho botlhe a re ba nne fa fatshe ");
INSERT INTO tsn_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","mme Jesu a tsaya dinkgwe tse di supang le ditlhapi, a di lebogela, a di ngathoganya, a di neela barutwa ba gagwe gore ba di neele batho. ");
INSERT INTO tsn_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","Mme botlhe ba a ja ba kgora, e le dikete di le nne tsa banna kwa ntle ga basadi le bana! moragonyana, fa masalela a kokoangwa, go ne ga tladiwa diroto di supa! ");
INSERT INTO tsn_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Mme Jesu a phatlalatsa batho go ya kwa gae, a tsena mo mokorong a kgabaganyetsa kwa Magadana. ");
INSERT INTO tsn_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mme ka letsatsi lengwe Bafarasai le Basadukai ba tla go leka Jesu mabapi le polelo ya gagwe ya gore ke Mesia ka go mo kopa go ba supegetsa ditshupo dingwe tse di tona mo magodimong. ");
INSERT INTO tsn_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","A fetola a re, “Lo siame mo go baleng ditshupo tsa seemo sa mawapi; lo a tle lo re bohibidu jwa loapi maitseboeng bo raya seemo se sentle sa mawapi; lo a tle lo re bohibidu jwa loapi maitseboeng ano bo raya seemo se sentle sa loapi ka moso; lo bo lo re loapi lo lo hibidu mo mosong lo raya seemo se se bosula sa loapi motshegare otlhe, mme ga lo kgone go bala ditshupo tse di itlhalosang ka botsone tsa metlha! ");
INSERT INTO tsn_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Sechaba se se bosula se, se se sa dumeleng se batla tshupo nngwe e e sa tlwaelesegang mo magodimong, mme ga go na sesupo sepe se se tlaa dirwang fa e se mofuta o o neetsweng Jona.” Hong Jesu a tswela kwa ntle a ba tlogela. ");
INSERT INTO tsn_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Erile ba sena go kgabaganya lecha, barutwa ba lemoga gore ba lebetse go tla le dijo. ");
INSERT INTO tsn_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Mme Jesu a ba tlhagisa a re, “Itlhokomeleng! Itiseng mo sebidisong sa Bafarasai le Basadukai.” ");
INSERT INTO tsn_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ba gopola gore o na a bua jaana ka gore ba ne ba lebetse go tla le senkgwe. ");
INSERT INTO tsn_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesu a ba a itse se ba se akanyang mme a ba raya a re, batho ba tumelo potlana! Ke eng fa lo tshwenyegile jaana ka go tlhoka senkgwe? ");
INSERT INTO tsn_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","10","A ga lo kitla lo tlhaloganya? A ga lo gakologelwe bontsi jwa batho bo le dikete tse ke di hephileng ka dinkgwe di le tlhano, le diroto tse di neng tsa tlogelwa di tletse masalela? A ga lo gakologelwe dikete tse nne tse ke di hephileng le gotlhe mo go neng ga sala? ");
INSERT INTO tsn_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Lo ka akanya jang gore ke ne ke bua ka dijo? Mme gape ka re, “Itiseng mo sebidisong sa Bafarasai le Basadukai.” ");
INSERT INTO tsn_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Hong kwa bofelong ba tlhaloganya gore ka ‘sebidiso’ o na a raya thuto e e sa siamang ya Bafarasai le Basadukai. ");
INSERT INTO tsn_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Erile a goroga kwa Kaesarea Filipi, a botsa barutwa ba gagwe a re, “Batho ba re ke mang?” ");
INSERT INTO tsn_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ba fetola ba re, “Bangwe ba re Johane wa Mokolobetsi; bangwe ba re Elija, bangwe ba re Jeremia kgotsa mongwe wa baporofiti ba bangwe.” ");
INSERT INTO tsn_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Hong a ba botsa a re, “Lona lo akanya gore ke mang?” ");
INSERT INTO tsn_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simone Petere a fetola a re, “Keresete Mesia Morwa Modimo o o tshedileng”. ");
INSERT INTO tsn_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesu a mo raya a re, “Modimo o go segofaditse, Simone, morwa Jona. Gonne Rara yo o kwa legodimong ke ene yo o go senoletseng dilo tse ka boene, ga go a tswa mo go ope. ");
INSERT INTO tsn_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","O Petere, lefika, mme ke aga phuthego ya me mo lefikeng le, mme dinonofo tsotlhe tsa molete ga di kitla di e fenya. ");
INSERT INTO tsn_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mme ke tlaa go neela dilotlolo tsa bogosi jwa legodimo, dikgoro dingwe le dingwe tse o di lotlelang mo lefatshing, di tla lotlelwa kwa legodimong; mme dikgoro dingwe le dingwe tse o di lotlololang mo lefatsheng, di tlaa lotlololwa kwa legodimong!” ");
INSERT INTO tsn_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Hong a laya barutwa gore ba se ka ba bolelela bape fa e le Mesia. ");
INSERT INTO tsn_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Go tswa foo Jesu a simolola go tlhalosetsa barutwa ba gagwe kaga go ya kwa Jerusalema, le se se tlaa mo diragalelang teng, gore o tlaa boga mo diatleng tsa baeteledipele ba Sejuta, le gore o tla bolawa le gore e tlaa re morago ga malatsi a le mararo a tsosiwe gape. ");
INSERT INTO tsn_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Mme Petere a mo tseela fa thoko go mo kgalemela a mo raya a re, “A mogopolo oo o nyelele Morena. Mo ga go kitla go go diragalela!” ");
INSERT INTO tsn_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesu a retologela kwa go Petere a re, “Tloga fa go nna, Satane ke wena! O lemena le le diphatsa mo go nna. O akanya ka fa batho ba bonang ka teng, e seng ka fa Modimo o akanyang ka teng.” ");
INSERT INTO tsn_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Hong Jesu a raya barutwa a re, “Fa motho le fa e le mang a rata go nna molatedi wa me, a a iitatole a tseye mokgoro wa gagwe a ntshale morago. ");
INSERT INTO tsn_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Gonne le fa e le mang yo o ipolokelang botshelo jwa gagwe bo tlaa mo latlhegela; mme le fa e le mang yo o latlhegelwang ke botshelo jwa gagwe ka ntlha ya me o tlaa bo bona gape. ");
INSERT INTO tsn_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Go na le poelo ya eng fa motho a rua lefatshe lotlhe, mme a latlhegelwa ke botshelo jo bo sa khutleng? Se se ka tshwantshiwang le letlotlo la botshelo jo bo sa khutleng ke eng? ");
INSERT INTO tsn_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Gonne Nna, Morwa Motho, ke tlaa tla le baengele ba me mo kgalalelong ya ga Rre go atlhola mongwe le mongwe ka fa ditirong tsa gagwe. ");
INSERT INTO tsn_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mme bangwe ba lona ba ba emeng fano jaanong jaana ba tshelela go mpona ke tla mo Bogosing jwa me.” ");
INSERT INTO tsn_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mme erile morago ga malatsi a le marataro Jesu a tsaya Petere, Jakobe le Johane monnawe go tlhatlogela kwa setlhoweng sa thaba e e godileng e e kwa thoko. ");
INSERT INTO tsn_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mme erile ba etse tlhoko, ponalo ya gagwe ya fetoga mo e leng gore sefatlhego sa gagwe se ne sa phatshima jaaka letsatsi, le diaparo tsa gagwe tsa nna bosweu jo bo fatlhang. ");
INSERT INTO tsn_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ka tshoganetso ga bonala Moshe le Elija ba bua nae. ");
INSERT INTO tsn_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petere a bua ka tshoganetso a re, “Morena, go molemo gore re be re le fano. Fa o rata, ke tlaa aga metlaagana e le meraro o mongwe e le wa gago, o mongwe e nne wa ga Moshe, o mongwe e nne wa ga Elija.” ");
INSERT INTO tsn_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mme erile a sa bua jalo, leru le le sedifetseng la tla fa godimo ga bone, mme lentswe le le tswang mo lerung la re, “Yo ke morwaake yo o rategang, mme ke itumela thata mo go ene. Mo utlweng.” ");
INSERT INTO tsn_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mo tiragalong e, barutwa ba wela fa fatshe ka difatlhogo ba tsenywe ke letshogo le legolo. ");
INSERT INTO tsn_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesu a tla kwa go bone a ba ama a ba raya a re, “Tsogang, se boifeng.” ");
INSERT INTO tsn_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Mme ya re ba leba, ya bo e le Jesu fela yo o nang nabo. ");
INSERT INTO tsn_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mme ya re ba fologa thaba, a ba laya gore ba se ka ba itsise ope se ba se boneng go fitlhelela a tsoga mo baswing. ");
INSERT INTO tsn_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Barutwa ba gagwe ba mmotsa ba re, “Ke eng fa baeteledipele ba Sejuda ba gatelela gore Elija o tshwanetse go boa pele ga Mesia a tla?” ");
INSERT INTO tsn_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesu a fetola a re, “Ba bua sentle. Elija o tshwanetse go tla go baya sengwe le sengwe ka fa thulaganyong. ");
INSERT INTO tsn_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mme legale o setse a tsile, mme ga a a ka a lemogwa, o na a sotlwa ke batho thata. Mme le Nna Morwa Motho ke tlaa sotlega mo diatleng tsa bone.” ");
INSERT INTO tsn_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Hong barutwa ba lemoga fa a bua kaga Johane wa Mokolobetsi. ");
INSERT INTO tsn_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Erile ba goroga kwa tlase ga thaba, bontsintsi jo bogolo jwa bo bo ba letile. Monna mongwe a tla a khubamela Jesu a re, ");
INSERT INTO tsn_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Morena, utlwela morwaake botlhoko, ka gore o tlhakatlhakanye tlhaloganyo, re mo bothatengjo bogolo, ka gore o a tle a wele mo molelong kgotsa mo metsing. ");
INSERT INTO tsn_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Jalo ke ne ka mo lere mo barutweng ba gago, mme ba retelelwa ke go mo fodisa.” ");
INSERT INTO tsn_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesu a fetola a re, “Ao batho ke lona ba ba ditlhogo di thata ba ba senang tumelo! Ke tlaa nna le lona boleele bo le kae? Mo lereng kwano go nna.” ");
INSERT INTO tsn_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Hong Jesu a kgalemela mowa o o maswe o o mo mosimaneng mme wa tswa mo go ene, mme go simolola ka lobaka loo mosimane a fola. ");
INSERT INTO tsn_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Moragonyana barutwa ba botsa Jesu mo sephiring ba re, “Ke ka ntlha yang fa re ne re sa kgone go kgoromeletsa mowa o o maswe kwa ntle?” ");
INSERT INTO tsn_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Mme Jesu a ba raya a re, “Ke ka ntlha ya tumelo ya lona e potlana. Gonne fa lo no lo na le tumelo le fa e le e nnyennyane jaaka peo e tshesane ya mosetara lo no lo ka raya thaba e lwa re ‘Suta!’ mme e ne e tlaa sutela kgakala. Ga go na se se neng se ka retela. ");
INSERT INTO tsn_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Mme mofuta o wa mowa o o maswe ga o ka ke wa tsamaya fa e se fela lo rapetse lo ikiditse dijo.” ");
INSERT INTO tsn_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Letsatsi lengwe fa ba sale mo Galalea Jesu a ba raya a re, “Ke ya go okelwa mo nonofong ya ba ba tlaa mpolayang, mme e tla re ka letsatsi la boraro ke tlaa tsoga mo baswing.” Mme dipelo tsa barutwa tsa tlala khutsafalo le poifo. ");
INSERT INTO tsn_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mo kgorogong ya bone kwa Kaperanama, baphuthi ba lekgetho la tempele ba tla mo go Petere ba mmotsa ba re, “A mong wa lona ga a duele lekgetho?” ");
INSERT INTO tsn_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petere a araba a re, “Ee, o a le duela.” Hong a tsena mo ntlung go bolelela Jesu ka potso ya makgetho, mme e rile pele ga a ka bua, Jesu a mmotsa a re, “O akanyang Petere? A dikgosi di phutha makgetho mo bathung ba tsone, kgotsa mo go batswakwa ba ba fentsweng?” ");
INSERT INTO tsn_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","27","Mme Petere a fetola a re, “Mo go batswakwa.” Jalo he, Jesu a re, “Go siame.” “Beng-ba legae ba gololesegile! Le fa go ntse jalo, ga re batle go ba kgopisa, jalo fologela kwa lotshitshing o konopele sekgoge (huku e e tshwarang ditlhapi), o atlhamolole molomo wa tlhapi ya ntlha e o e tshwarang. O tlaa bona ledi le le tlaa lekanang makgetho a rona rotlhe; le tseye mme o ba duele!” ");
INSERT INTO tsn_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mme erile ka nako eo barutwa ba tla kwa go Jesu go mmotsa gore ke ofe wa bone yo o tlaa nnang mogolo mo Bogosing jwa Legodimo. ");
INSERT INTO tsn_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesu a bitsa ngwana yo monnyennyane a mmaya fa fatshe fa gare ga bone, ");
INSERT INTO tsn_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","mme a re, “Fa e se fela lo boela Modimong lo latlha dibe tsa lona lo bo lo nna jaaka bana ba bannyennyane, ga lo kitla lo tsena mo Bogosing jwa Legodimo. ");
INSERT INTO tsn_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jalo he, le fa e le mang yo o ingotlang jaaka ngwananyana yo monnyennyane yo, o mogolo bogolo mo Bogosing jwa Legodimo. ");
INSERT INTO tsn_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mme le fa e le mang mo go lona yo o tsholang ngwananyana yo monnyennyane jaaka yo, ka ntlha ya gore lo ba me, o tshola nna ebile o a ntlhokomela. ");
INSERT INTO tsn_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Mme le fa e le mang yo o dirang gore mongwe wa ba ba botlana ba, ba ba dumelang mo go nna a latlhegelwe ke tumelo ya gagwe, go ka nna botoka mo go ene go golegelelwa lefika mo thamung a ba a latlhelwa mo lewatleng. ");
INSERT INTO tsn_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“A bo go latlhega lefatshe ka ntlha ya masula otlhe a jone. Gonne thaelo e na le go tla fela, mme a bo go latlhega motho yo thaelo e tlang ka ene. ");
INSERT INTO tsn_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jalo fa seatla sa gago kgotsa lonao lo go leofisa, lo kgaole o lo latlhe. Go botoka go tsena mo legodimong o golafetse go na le go tsena mo moleting ka mabogo le maoto a le mmogo. ");
INSERT INTO tsn_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mme fa leitlho la gago le go leofisa, le gonye o le latlhe. Go botoka go tsena mo legodimong ka leitlho le le lengwe go na le go tsena mo moleting ka a le mabedi. ");
INSERT INTO tsn_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Itiseng gore lo seka lwa lebela ope wa bananyana ba ba nnyennyane ba kwa tlase. Gonne ke lo bolelela gore kwa legodimong baengele ba bone ba fa pele ga ga Rre ka metlha yotlhe. ");
INSERT INTO tsn_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mme nna, Morwa Motho, ke tletse go boloka ba ba latlhegileng. ");
INSERT INTO tsn_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Fa motho a na le dinku di le lekgolo, mme e nngwe e tsamaya e bo e timela, o tlaa dira eng? A ga a na go tlogela tse di masome a fera bongwe le metso e fera bongwe a ba a ya kwa dithabeng go ya go batla e e latlhegileng? ");
INSERT INTO tsn_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mme fa a e bona, o tlaa e itumelela go gaisa tse di masome a fera bongwe le metso e fera bongwe tse di babalesegileng kwa gae! ");
INSERT INTO tsn_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Fela jalo, ga se go rata ga ga Rre gore le fa e le mang wa ba bannye ba a nyelele. ");
INSERT INTO tsn_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Fa wa gaeno a go leofela, ya kwa go ene ka sephiri go mo kaela molato o. Fa a reetsa a ba a ipona phoso, o gapile wa gaeno. ");
INSERT INTO tsn_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Fa a gana, ke gone tsaya mongwe kgotsa ba le babedi lo boele go ene gape, go tlhomamisa sengwe le sengwe se o se buang ka bone basupi ba. ");
INSERT INTO tsn_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mme fa a sa ntse a gana go reetsa, isa ngongorego ya gago kwa phuthegong, mme fa katlholo ya phuthego e dumalana nao mo kgannyeng e, mme ene a sa dumalane, phuthego e tshwanetse go mo kgaola. ");
INSERT INTO tsn_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Mme ke lo bolelela se, le fa e le eng se lo se bofang mo lefatsheng se bofiwa kwa legodimong, mme le fa e le eng se lo se bofololang mo lefatsheng, se tlaa bofololwa kwa legodimong. ");
INSERT INTO tsn_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Gape ke lo bolelela se, fa ba le babedi ba lona fano mo lefatsheng ba dumalana kaga sengwe se lo se kopang, Rara yo o kwa legodimong o tlaa se lo direla. ");
INSERT INTO tsn_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","“Gonne kwa bobedi kgotsa kwa boraro bo phuthegelang teng ka ntlha ya gore ke ba me, ke tlaa bo ke le gone tota fa gare ga bone.” ");
INSERT INTO tsn_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mme ga tla Petere a mmotsa a re, “Morena, ke tshwanetse go itshwarela wa gaetsho ga kae fa a nteofela? Ga supa?” ");
INSERT INTO tsn_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Mme Jesu a fetola a re, “Nnyaa, masome a supa a ntsifaditshwe ga supa! ");
INSERT INTO tsn_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Bogosi jwa Legodimo bo ka tshwantshiwa le Kgosi e e neng e ikaeletse go gakolola batho go mo duela melato ya bone. ");
INSERT INTO tsn_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Fa go ntse go tsweletswe, mongwe wa ba ba nang le molato nae yo e neng a mo kolota didikadike di le lesome tsa dipula! (P10,000,000) a tlisiswa kwa go ene. ");
INSERT INTO tsn_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","A se ka a kgona go duela, jalo Kgosi ya laola gore a rekisiwe ka ntlha ya sekoloto le mosadi wa gagwe le banna le sengwe le sengwe se a neng a na naso. ");
INSERT INTO tsn_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Mme monna a wela fa fatshe fa pele ga kgosi ka sefatlhogo a re, ‘Ao Morena, nna pelotelele mo go nna mme ke tlaa duela sekoloto sotlhe’. ");
INSERT INTO tsn_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","“Mme kgosi ya mo utlwela botlhoko mme ya mo golola ya mo itshwarela molato. ");
INSERT INTO tsn_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Mme erile fa monna a tlogela kgosi a ya kwa monneng yo o mo kolotang dipula di le dikete tse pedi, a mo tshwara ka mometso a batla tuelo ya gagwe ka nako eo. ");
INSERT INTO tsn_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Monna a wela fa fatshe fa pele ga gagwe mme a mo kopa go mo fa lobakanyana. A mo rapela a re nna pelotelele mme ‘ke tlaa duela’. ");
INSERT INTO tsn_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mme yo o kolotwang a se ka a dumela go mo letela. A laola gore a tshwarwe a ba a tlhatlhelwe mo tlung ya kgolegelo go fitlhelela molato o duelwa otlhe. ");
INSERT INTO tsn_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Mme ditsala tsa monna yo o mo tlung ya kgolegelo tsa ya kgosing go e bolelela se se diragetseng. ");
INSERT INTO tsn_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mme kgosi ya bitsa monna yo e neng e mo itshwaretse sekoloto se se gakgamatsang ya re, ‘Molotsana ke wena yo o pelo e maswe! Ke go itshwaretse sekoloto se se gakgamatsang, fela ka ntlha ya gore o nkopile, ");
INSERT INTO tsn_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","a ga o a tshwanela go nna le kutlwelobotlhoko mo go ba bangwe, fela jaaka ke ne ka nna le kutlwelobotlhoko mo go wena?’ ");
INSERT INTO tsn_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mme kgosi e e kgopegileng ya romela monna yo kwa tlung ya kgolegelo go fitlhelela a duela thebe ya bofelo ya madi a a a kolotang. ");
INSERT INTO tsn_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Mme Rara wa legodimo o tlaa lo direla fela jalo fa lo gana go itshwarela bangwe ka-lona ka boammaaruri.” ");
INSERT INTO tsn_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mme e rile Jesu a sena go fetsa mafoko a, a tswa mo Galalea a boela kwa morago kwa Judea go kgabaganya Noka ya Jorodane. ");
INSERT INTO tsn_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Boidiidi jwa batho jwa mo sala morago, mme a fodisa malwetse a bone. ");
INSERT INTO tsn_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bafarasai bangwe ba tla go buisanya nae, gape ba leka go mmeela seru gore a bue sengwe se se tlaa mo senyang. Ba mmotsa ba re, “A o letlelela tlhalo?” ");
INSERT INTO tsn_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesu a ba fetola a re, “A ga lo bale dikwalo? Mo go tsone go kwadilwe gore mo tshimologong Modimo o tlhodile monna le mosadi, ");
INSERT INTO tsn_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","6","gore monna o tlaa tlogela rraagwe le mmaagwe mme a ngaparele mosadi wa gagwe. Mme bobedi jo bo tlaa nna bongwe fela, e sa tlhole e le bobedi, mme ele bongwe fela! a go se nne ope yo o kgaoganyang se Modimo o se kopantseng”. ");
INSERT INTO tsn_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ba botsa ba re, “Jaanong Moshe o ne a raya jang fa a re monna o ka tlhala mosadi wa gagwe ka go mo kwalela lokwalo lwa tlhalo fela?” ");
INSERT INTO tsn_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesu a fetola a re, “Moshe o dirile jalo ka ntlha ya go bona dipelo tsa lona tse di thata tse di bosula, mme tota e ne e se se Modimo o simolotseng o se ikaeletse. ");
INSERT INTO tsn_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mme ke lo bolelela se, ka re, le fa e le mang yo o tlhalang mosadi wa gagwe, fa e se fela ka kgokafalo, a bo a nyala yo mongwe, o dira kgoka falo.” ");
INSERT INTO tsn_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Barutwa ba ga Jesu ba mo raya ba re, “Fa e le gore go ntse jalo go botoka go sa nyaleng.” ");
INSERT INTO tsn_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesu a fetola a re, “Ga se mongwe le mongwe yo o ka amogelang mafoko a, fa e se fela ka thuso ya Modimo. ");
INSERT INTO tsn_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Banna bangwe ba tsetswe e le baopa, ba bangwe ba opafaditswe ke batho, gore ba seka ba nyala, ba bangwe ba ikgapa mo nyalong ka ntlha ya Bogosi jwa Legodimo. A yo o kgonag, a amogele mafoko a me.” ");
INSERT INTO tsn_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mme ga tlisiwa bana ba bannye kwa go Jesu gore a ba beye diatla a ba rapelele. Mme barutwa ba kgalemela ba ba neng ba tlisitse bana. Ba ba raya ba re, “Se mo tshwenyeng.” ");
INSERT INTO tsn_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesu a re, “Lesang banyana ba tle kwa go nna, se ba kganeleng. Gonne bogosi jwa Legodimo ke jwa ba ba ntseng jalo.” ");
INSERT INTO tsn_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Foo a ba baya diatla a ba segofatsa pele ga a tsamaya. ");
INSERT INTO tsn_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mme mongwe a tla kwa go Jesu ka potso e e reng: “Morena yo o Molemo ke ka dira eng se se siameng go nna le botshelo jo bo sa khutleng?” ");
INSERT INTO tsn_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesu a mo raya a re fa o re, “Ke molemo o raya Modimo. Mme go araba potso ya gago ka re, o ka tsena kwa legodimong fa o tshegetsa ditaolo.” ");
INSERT INTO tsn_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mme monna a mmotsa a re, “Ditaolo dife?” Mme Jesu a fetola a re “O seka wa bolaya motho, o seka wa dira boaka, o seka wa utswa, o seka wa bua maaka, ");
INSERT INTO tsn_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","tlotla rrago le mmago, gape o rate mongwe ka wena jaaka o ithata!” ");
INSERT INTO tsn_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mme lekawana la fetola la re, “Ke sa le ke e tshegetsa yotlhe fela, ke tshwanetse go dirang gape?” ");
INSERT INTO tsn_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesu a mo raya a re, “Fa o batla go itekanela, ya o rekise sengwe le sengwe se o nang naso o neele bahumanegi madi, mme o tlaa nna le khumo kwa legodimong; mme o tle o ntshale morago.” ");
INSERT INTO tsn_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mme e rile fa lekau le utlwa jaana, la tsamaya le nyemile moko ka bohutsana, ka gore le ne le humile thata. ");
INSERT INTO tsn_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hong a raya barutwa ba gagwe a re, “Ruri go thata mo mohuming go tsena mo Bogosing jwa Legodimo. ");
INSERT INTO tsn_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mme ke ipoeletsa gape ke re, go motlhofo mo kammeleng go tsena ka leroba la nnale go na le gore mohumi a tsene mo Bogosing jwa Modimo.” ");
INSERT INTO tsn_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Polelo e ya gakgamatsa barutwa. Mme ba botsa ba re, “Mme fa go ntse jalo, ke mang yo o ka bolokwang mo lefatshing?” ");
INSERT INTO tsn_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Hong Jesu a ba leba ka kelotlhoko a re, “Ka fa senameng ga go na ope.” ");
INSERT INTO tsn_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Hong Petere a mo raya a re, “Re tlogetse sengwe le sengwe gore re go sale morago. Re tlaa boelwa ke eng ka go dira jalo?” ");
INSERT INTO tsn_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesu a fetola a re, “E tlaa re nna, Morwa Motho, fa ke nna mo setilong se se galalelang sa Bogosi, lona barutwa ba me lo tlaa nna mo ditilong di le lesome le bobedi tsa puso go atlhola merafe e le lesome le bobedi ya Iseraele. ");
INSERT INTO tsn_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mme le fa e le mang yo a tlogelang motse wa gagwe, bomonnawe, bokgaitsadie, rraagwe, mmaagwe, mosadi wa gagwe, bana kgotsa dilwana go ntshala morago, o tlaa amogela galekgolo go menaganye, ebile o tlaa nna le botshelo jo bo sa khutleng. ");
INSERT INTO tsn_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mme ba le bantsi ba e leng ba ntlha jaanong e tlaa nna ba morago ka nako eo: le bangwe ba e leng ba bofelo jaanong e tlaa nna ba ntlha.” ");
INSERT INTO tsn_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Setshwantsho sengwe ke se se se tshwantshang Bogosi jwa Legodimo. “Mong wa tshimo o kile a phakela go ya go thapela tshimo ya gagwe ya thobo badiri. ");
INSERT INTO tsn_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","A dumalana go ba duela madi a tuelo ya letsatsi, hong a ba laela go ya go dira. ");
INSERT INTO tsn_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Morago ga dioura di se kae, o na a feta fa ntlong e go thapelwang batho teng mme a bona banna bangwe ba eme foo ba batla tiro, ");
INSERT INTO tsn_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","jalo le bone a ba romela mo masimong a gagwe, a ba bolelela gore o tlaa ba duela fela se se ba tshwanetseng fa letsatsi le phirima. ");
INSERT INTO tsn_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mo motshegareng wa sethoboloko, le mo tshokologong e ka nna nako ya boraro a nna a tswelela ka go thapa badiri. ");
INSERT INTO tsn_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Ka nako ya botlhano mo go one maitseboa ao, a ya kwa motseng gape, mme a bona banna ba bangwe gape ba eme teng foo mme a ba botsa a re, ‘Ke eng fa lo ntse fela lo sa dire sepe letsatsi lotlhe?’ ");
INSERT INTO tsn_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ba araba ba re, ‘Ke ka gore ga go ope yo o re thapileng’. Hong a ba raya a re, ‘tsamayang lo ye go tlatsa ba bangwe mo masimong a me.’ ");
INSERT INTO tsn_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Mo maitseboeng ao a raya radituelo wa gagwe a re a bitse banna bao a ba duele, a simolola pele ka banna ba bofelo. ");
INSERT INTO tsn_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","E rile fa banna ba ba thapilweng ka nako ya botlhano ba duelwa mongwe le mongwe wa bone o na a amogela madi a tuelo ya letsatsi. ");
INSERT INTO tsn_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","E rile fa banna ba ba thapilweng pele ba tla go tsaya a bone, ba ne ba ithaya ba re ba tlaa amogela go feta foo thata. Le bone ba ne ba duelwa madi a lekanang le a ba bangwe. ");
INSERT INTO tsn_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","“Ba ngongorega ba re, ‘Batho bale ba dirile lobaka lwa oura fela, le fa go ntse jalo a oba duetse jaaka rona ba re dirileng letsatsi lotlhe mo mogoteng o o fisang’. ");
INSERT INTO tsn_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Mme a araba mongwe wa bone aa re ‘Tsala, ga ke a go fosetsa ka gope! A o ne o sa dumalana go dira o duelwa tuelo ya letsatsi? ");
INSERT INTO tsn_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","A tseye o tsamaye. Ke keletso ya me go lo duela ka go lekana; ");
INSERT INTO tsn_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","a go kgatlhanong le molao go ntsha madi a me fa ke batla go dira jalo? A o tshwanetse go kgotswa ka go bo ke le kutlwelobotlhoko?’ ");
INSERT INTO tsn_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Mme fela jalo, ba morago e tlaa nna ba ntlha, ba ntlha e tlaa nna ba morago.” ");
INSERT INTO tsn_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Mme ya re Jesu a le mo tseleng a ya Jerusalema, a tseela barutwa ba ba lesome le bobedi kwa thoko, ");
INSERT INTO tsn_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","mme a bua nabo ka ga se se tlaa mo diragalelang fa ba goroga. “Ke tlaa neelwa baperesiti ba bagolo le baeteledipele ba Sejuda ba bangwe, mme ba tlaa nkatlholela loso. ");
INSERT INTO tsn_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Me ba tlaa ntsenya mo diatleng tsa mmuso wa Roma, ke tlaa sotlwa ke bapolwa, mme e tlaa re mo letsatsing la boraro ke rule.” ");
INSERT INTO tsn_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Hong mmaagwe Jakobe le Johane bomorwa Sebede, a ba lere kwa go Jesu, a obama, a kopa thuso. ");
INSERT INTO tsn_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesu a mmotsa a re “O batla ke go direlang?” Mme a fetola a re, “Mo Bogosing jwa gago, a o tlaa letla bomorwaake ba babedi go nna mo ditilong tse pedi go bapa le sa gago, yo mongwe ka fa letsogong la gago le legolo yo mongwe ka fa go la molema?” ");
INSERT INTO tsn_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Mme Jesu a mo fetola a re, “Ga o itse se o se lopang!” Mme a retologela kwa go Jakobe le Johane a ba botsa a re, “A lo nonofile go nwa mo senwelong se se boitshegang se ke tlaa tlogang kee nwa mo go sone?” Jalo ba fetola ba re, “Ee, re nonofile.” ");
INSERT INTO tsn_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Mme a ba fetola a re, “Lo tlaa nwa mo go sone ruri. Mme ga ke na thata go bua gore ke mang yo o tlaa nnang mo ditilong go bapa le same. Maemo ao a beetswe batho ba Rre a ba tlhophang”. ");
INSERT INTO tsn_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Barutwa ba bangwe ba ba lesome ba ne ba gakala fa ba utlwa ka go se Jakobe le Johane ba se lopileng. ");
INSERT INTO tsn_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mme Jesu a ba bitsa botlhe a ba raya a re, “Mo baheitaneng, dikgosi ke batho ba ba bogoma, mme le bagolwane ba ba ka fa tlase ga tsone, ba dipisa ba ba ka fa tlase ga bone. ");
INSERT INTO tsn_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mme mo go lona go pharologanyo. Le fa e le mang mo go lona yo o batlang go nna moeteledipele, o tshwanetse go nna motlhanka wa lona. ");
INSERT INTO tsn_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mme fa o batla go nna kwa godimodimo, o tshwanetse go dira jaaka lekgoba. ");
INSERT INTO tsn_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mokgwa wa lona o tshwanetse go nna jaaka wa me, gonne nna Morwa Motho, ga ke a tlela go direlwa, fa e se go direla, le go ntshetsa ba le bantsi botshelo jwa me go nna thekololo.” ");
INSERT INTO tsn_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","E rile Jesu le barutwa ba tswa mo motseng wa Jeriko, bontsintsi jwa batho jo bogolo jwa ba sala morago. ");
INSERT INTO tsn_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Banna ba le babedi ba difofu ba ne ba ntse fa thoko ga tsela mme e rile fa ba utlwa gore Jesu o e tla ba simolola go goa ba re, “Morena, Morwa Dafide, re utlwele botlhoko!” ");
INSERT INTO tsn_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Bontsintsi jwa batho jwa ba raya jwa re ba didimale, mme ba goela godimo go gaisa pele. ");
INSERT INTO tsn_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","33","E rile a tla fa difofu di neng di le teng a ema mo tseleng a botsa a re, “Lo batla ke lo direlang?” Mme ba fetola ba re, “Morena re batla go bona!” ");
INSERT INTO tsn_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesu a ba utlwela botlhoko a ama matlho a bone. Mme ya re gone fela foo ba foufologa, ba mo sala morago. ");
INSERT INTO tsn_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Mme ya re Jesu le barutwa ba atamela Jerusalema, ba le gaufi le motse wa Bethefage mo Thoteng ya Lotlhware, Jesu a roma bangwe ba barutwa ba gagwe ba le bebedi mo motsaneng o o fa pele. ");
INSERT INTO tsn_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","A ba raya a re, “E tlaa re fela fa lo tsena teng lo tlaa bona tonki e golegilwe le tonkana ya yone e le fa thoko ga yone. Lo bo lo di golola lo di lere kwano. ");
INSERT INTO tsn_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Fa mongwe a lo botsa gore lo dirang, lo re, ‘Morena o a di batla’, mme ga go na go nna matshwenyego ape.” ");
INSERT INTO tsn_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Se se ne se dirwa go diragatsa seporofeso sa bogologolo se se reng, ");
INSERT INTO tsn_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Bolelela Jesusalema gore Kgosi ya gagwe e tla kwa go ene, ka bonolo e palame tonkana.” ");
INSERT INTO tsn_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Barutwa ba babedi ba dira ka fa Jesu a neng a ba boleletse, ka teng, ");
INSERT INTO tsn_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ba lere tonki le tonkana kwa go ene, ba pega diaparo tsa bone mo godimo ga tonkana gore a nne mo godimo ga tsone. ");
INSERT INTO tsn_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mme ba bangwe mo bontsintsing jwa batho ba ala diaparo tsa bone mo tseleng kwa pele ga gagwe, ba bangwe ba kgetla dikala tsa ditlhare ba di ala fa pele ga gagwe. ");
INSERT INTO tsn_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Hong bontsi jwa batho ba ba mo eteletseng pele le ba ba kwa morago ba goa ba re, “Modimo segofatsa Morwa Kgosi Dafide! Mo galaletse mo segofatse, Morena A go bakwe Modimo mogodimodimo!” ");
INSERT INTO tsn_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Motse otlhe wa Jerusalema o ne wa huduega fa a tsena. Ba botsa ba re, ke mang yo? ");
INSERT INTO tsn_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mme bontsintsi jwa batho jwa fetola jwa re, “Jesu Moporofiti yo o tswang Nasaretha wa Galalea.” ");
INSERT INTO tsn_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesu a tsena mo Tempeleng, a lelekela barekisi kwa ntle, a pitikolola mabati a go ananyediwang madi mo go one le ditilo tsa ba ba rekisang maphoi. ");
INSERT INTO tsn_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","A ba raya a re, “Dikwalo tsa re tempele ya me ke lefelo la thapelo, mme lona lo e fetotse borakanelo jwa magodu.” ");
INSERT INTO tsn_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Hong difofu le digole tsa tla kwa go ene mme a di fodisa teng mo tempeleng. ");
INSERT INTO tsn_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mme ya re baperesiti ba bagolo le baeteledipele ba bangwe ba Sejuda ba bona dikgakgamatso tse di ntle tse ba bile ba utlwa le bananyana ba goa mo tempeleng ba re, “Modimo segofatsa Morwa Dafide,” ba ne ba se ka ba itumela ba gakala ba mmotsa ba re, “A o utlwa se bana ba ba se buang?” ");
INSERT INTO tsn_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesu a fetola a re, “Ee, a ga lo ise lo ke lo bale dikwalo? Gonne tsa re, ‘Le bananyana tota ba tlaa mo galaletsa!’ ” ");
INSERT INTO tsn_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Hong a boela kwa Bethania, kwa a letseng teng. ");
INSERT INTO tsn_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mo mosong fa a boela Jerusalema, a tshwarwa ke tlala, ");
INSERT INTO tsn_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yare a bona setlhare sa mofeige fa thoko ga tsela, a tsamaela kwa go sone go bona gore a se na le maungo, mme ga bo go le matlhare fela. Hong a se hutsa a re, “O se ka wa tlhola o ungwa gape!” Mme ka bofefo setlhare sa mofeige sa omelela. ");
INSERT INTO tsn_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Barutwa ba gakgamala thata ba bo ba mmotsa ba re, “Setlhare sa mofeige se omeletse ka bofefo jang?” ");
INSERT INTO tsn_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Mme Jesu a ba raya a re, “Ammaaruri, fa lo na le tumelo lo sa belaele, lo ka dira dilo tse di ntseng jaana le go feta. Lo ka ba lwa raya thaba e ya Lotlhare lwa re, ‘Thabuela mo lewatleng,’ mme go ka diragala. ");
INSERT INTO tsn_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Lo ka amogela sengwe le sengwe, se lo se kopang ka thapelo fa lo dumela.” ");
INSERT INTO tsn_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Mme e rile a sena go boela kwa Tempeleng a sa ntse a ruta, baperesiti ba bagolo le bangwe ba bagolwane ba Sejuda ba tla kwa go ene ba batla go itse gore e ne e le ka tetlelelo ya ga mang gore a lelekele baananyi kwa ntle maabane. ");
INSERT INTO tsn_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesu a ba fetola a re “Ke tlaa lo bolelela fa lo ka araba potso e le nngwe pele. ");
INSERT INTO tsn_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","A Johane wa Mokolobetsi o ne a romilwe ke Modimo, kgotsa nnyaa?” Ba ne ba gakololana ka fa ba ka arabang ka teng potso e, ba re, “Fa re re, ‘o ne a romilwe ke Modimo’, hong o tlaa re botsa gore ke eng re ne re sa dumele se Johane o neng a se bua. ");
INSERT INTO tsn_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mme fa re ganela gore Modimo o mo romile, re tlaa tlhaselwa ke bontsi jwa batho, gonne bontsi jotlhe bo dumela gore e ne e le moporofiti.” ");
INSERT INTO tsn_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Hong lwa bofelo ba fetola ba re, “Ga re itse!” Mme Jesu a re, “Jalo le nna ga ke na go araba potso ya lona ka tsela epe.” ");
INSERT INTO tsn_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mme lo akanya jang ka ga se? Monna yo o neng a na le bomorwawe ba le babedi o na a raya yo motona a re, ‘Morwaaka, tsamaya o ye go dira mo tshimong ya me gompieno.’ ");
INSERT INTO tsn_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Morwawe a fetola a re, ‘Ga ke na go dira jalo,’ mme kwa morago a fetola maikutlo a gagwe a tsamaya. ");
INSERT INTO tsn_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Hong rraagwe a raya yo monnyennyane a re, ‘Wena tsamaya!’ Mme a re, ‘Ee, rra, ke tlaa tsamaya.’ Mme a seka a dira jalo. ");
INSERT INTO tsn_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ke ofe mo go ba babedi yo o neng a dira go rata ga ga rraagwe?” Ba fetola ba re, “Ke wa ntlha.” Hong Jesu a tlhalosa se a se rayang a re: “Ammaaruri batho ba ba bosula le basadi ba diaka ba tlaa lo raka mo Bogosing. ");
INSERT INTO tsn_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Gonne Johane wa Mokolobetsi o lo reile a re lo sokologe lo latlhe ditiro tsa lona tse di maswe lo boele mo Modimong, mme ga lo a dira jalo, fa batho ba ba bosula le diaka ba sokologa ba boela mo Modimong. Mme le fa tota lo ne lwa bona ba sokologa lona lo ne lwa gana go sokologa, ga lo aka lwa dumela. ");
INSERT INTO tsn_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Jaanong reetsang polelo e: Mong wa setsha mongwe o kile a tlhoma tshimo ya mofine e e ageletsweng, mme a direla motlhokomedi wa yone lefelo la boletelo, hong a hirisetsa balemi bangwe tshimo ya gagwe ka tumalano ya go kgaogana thobo, mme a huduga go nna mo lefatsheng le lengwe. ");
INSERT INTO tsn_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“E rile ka nako ya thobo ya maungo a mofine a roma baemedi ba gagwe kwa baleming go ya go tsaya seabe sa gagwe. ");
INSERT INTO tsn_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mme balemi ba tlhasela batlhanka ba gagwe, ba itaya yo mongwe, ba bolaya yo mongwe, ba kgobotletsa yo mongwe ka matlapa. ");
INSERT INTO tsn_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","“Hong a roma setlhopa se segolwane sa batlhanka ba gagwe go ya go mo tseela seabe, mme ba diragalelwa ke se se diragaletseng batlhanka ba ntlha. ");
INSERT INTO tsn_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Lwa bofelo mong wa tshimo a roma morwawe a gopola gore ba tlaa mo tshoga seemo ba mo tlotle. ");
INSERT INTO tsn_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Mme e rile fa balemi ba bona morwawe a tla, ba buisanya ba re ‘Moja boswa ke yoo o e tla; tlaang, re mmolayeng re bo itseele!’ ");
INSERT INTO tsn_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jalo ba mo swaswailela ka kwa ntle ga tshimo ya mafine ba mmolaya. ");
INSERT INTO tsn_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Fa mong wa tshimo a boa, lo akanya gore o tlaa feta a dirang ka balemi bao?” ");
INSERT INTO tsn_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Baeteledipele ba Sejuda ba fetola ba re, “O tlaa bolaya batho bao ba ba bosula ka polao e e setlhogo, mme a hirisetse ba bangwe tshimo ya gagwe ba ba tlaa mo duelang ka fa tshwanelong.” ");
INSERT INTO tsn_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Hong Jesu a ba botsa a re, “A ga lo ise lo ke lo bale mo dikwalong gore: ‘Lentswe le le gannweng ke baagi le dirilwe lentswe la kgokgotso le le tlotlegang. Ana go gontle jang! Morena o dirile selo se se gakgamatsang jang mo matlhong a rona?’ ");
INSERT INTO tsn_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Se ke se rayang ke gore Bogosi jwa Modimo bo tlaa tsewa mo go lona bo neelwe chaba e e tlaa neelang Modimo seabe sa one sa thobo ya maungo. ");
INSERT INTO tsn_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Botlhe ba ba kgotswang mo lefikeng le la boammaruri, ba tlaa robega, mme ba ba welang godimo ba tlaa phatlalala jaaka lorole.” ");
INSERT INTO tsn_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","E rile baperesiti ba bagolo le baeteledipele ba bangwe ba Sejuda ba lemoga gore Jesu o ne a bua ka ga bone, gore e ne e le balemi mo polelong ya gagwe, ");
INSERT INTO tsn_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ba ne ba batla go mmolaya, mme ba boifa go lekeletsa ka ntlha ya bontsintsi jwa batho, gonne bo ne bo kaya Jesu e le moporofiti. ");
INSERT INTO tsn_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","Jesu a bolela dipolelo tse dingwe tse dintsi go supa gore Bogosi jwa Legodimo bo tshwana le eng. Sekai, bo ka tshwantshiwa ka polelo ya Kgosi e e kileng ya baakanyetsa morwaa yone mokete o mogolo wa lenyalo. ");
INSERT INTO tsn_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Baeng ba le bantsi ba lalediwa, mme e rile fa dijo di setse di siame a roma batho go itsise mongwe le mongwe gore ke nako ya gore ba tle. Mme batho ba ba laleditsweng ba gana! ");
INSERT INTO tsn_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Jalo a roma batlhanka ba bangwe go ba bolelela gore, “Sengwe le sengwe se siame le dinama tse di besiwang di setse di le mo isong. Itlhaganeleng!” ");
INSERT INTO tsn_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mme baeng ba a neng a ba laleditse ba tshega fela ba tswelela pele le ditiro tsa bone, mongwe kwa morakeng wa gagwe yo mongwe kwa madirelong a gagwe; ");
INSERT INTO tsn_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ba bangwe ba itaya batlhanka ba gagwe ba ba tshwara setlhogo mo go tlhabisang ditlhong, ba bo ba bolaya bangwe ba bone. ");
INSERT INTO tsn_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Hong Kgosi e e galefileng ya bolotsa ntwa ya yone ya bolaya babolai ya tshuba motse wa bone. ");
INSERT INTO tsn_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Mme ya raya batlhanka ba yone ya re, “Modiro wa lenyalo o siame, mme baeng ba ke ba laleditseng ga ba a tshwanelwa ke tlotlo. ");
INSERT INTO tsn_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jaanong tsamayang mo mebileng ya motse lo laletse mongwe le mongwe yo lo mmonang.” ");
INSERT INTO tsn_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Mme batlhanka ba dira fela jalo, ba lere batho botlhe, basiami le baleofi ka go tshwana; mme ntlo ya tlala balalediwa. ");
INSERT INTO tsn_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mme e rile fa Kgosi e tla go rakana le balalediwa, ya bona monna yo a neng a sa apara seaparo sa lenyalo (se a neng a se neetswe). ");
INSERT INTO tsn_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kgosi ya botsa ya re, “Tsala, go diragetse jang gore o bo o le fano o sena seaparo sa lenyalo?” Mme monna a tlhoka karabo. ");
INSERT INTO tsn_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Hong Kgosi ya raya bathusi ba yone ya re, “Mo golegeng mabogo le maoto lo mo latlhele kwa ntle mo lefifing kwa go nang le selelo le khuranyo ya meno gone.” ");
INSERT INTO tsn_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Gonne ba le bantsi ba biditswe, mme ba se kae ba itshenketswe! ");
INSERT INTO tsn_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Bafarasai ba kopana go leka go akanya tsela e ba ka mo tshwarang mo puong ka yone. ");
INSERT INTO tsn_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ba ikaelela go roma bangwe ba banna ba bone le Baheroda go mmotsa potso e: “Rra, re itse gore o ikanyega thata le gore o ruta boammaaruri kwa ntleng ga go tlhokomela tse di ka go diragalelang, e bile o sa boife bomang-mang jwa ga ope. ");
INSERT INTO tsn_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jaanong re bolelele, a go siame go ntshetsa mmuso wa Roma lekgetho kgotsa nnyaa?” ");
INSERT INTO tsn_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Mme Jesu a bona se ba neng ba se ikaeletse. A re, “Baitimokanyi ke lona! Lo leka go tsietsa mang ka dipotso tsa lona tsa bolotsana? ");
INSERT INTO tsn_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ntshupegetsang ledi,” Mme ba le mo naya. ");
INSERT INTO tsn_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","A ba botsa a re, “Le tshwantshitswe mang? Gape leina le le ka fa tlase ga setshwantsho se ke la ga mang”? ");
INSERT INTO tsn_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ba mo fetola ba re, “la ga Kaisara.” Mme a ba raya a re, “Go siame le neyeng Kaisara fa e le la gagwe, mme lo neele Modimo sengwe le sengwe se e leng sa one.” ");
INSERT INTO tsn_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mme phetolo ya gagwe e ne ya ba gakgamatsa ya ba ya ba palela ba mo tlogela ba tsamaya. ");
INSERT INTO tsn_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mme ka letsatsi leo bangwe ba Basadukai, ba ba reng ga go na tsogo ya baswi morago ga loso, ba tla kwa go ene mme ba mmotsa ba re ");
INSERT INTO tsn_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Morena, Moshe o rile fa motho a a swa a sena bana, monnawe a nyale motlholagadi yoo, mme bana ba bone ba tlaa ja boswa. ");
INSERT INTO tsn_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Go kile ga bo go na le monna mongwe mo motseng wa rona a na le bana ba basimane ba supa. Mme wa ntlha a nyala mme a swa a sena bana, jalo motlholagadi wa gagwe a nna mosadi wa ga monnawe yo o mo tlhomaganelang. ");
INSERT INTO tsn_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mme le ene monnawe yo, a swa a sena bana, mme mosadi a nyalwa ke monnawe yo mongwe. Ga direga fela jalo go fitlhelela a nna mosadi wa mongwe le mongwe wa bone ka bosupa! ");
INSERT INTO tsn_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mme mosadi le ene a swa. ");
INSERT INTO tsn_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jalo o tlaa nna mosadi wa ga mang mo tsogong ya baswi? Gonne e ne e le mosadi wa bone ka bosupa.” ");
INSERT INTO tsn_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Mme Jesu a re, “Phoso ya lona e dirwa ke bosenakitso jwa lona jwa go tlhoka go itse dikwalo le nonofo ya Modimo. ");
INSERT INTO tsn_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Gonne mo tsogong ya baswi ga go na lenyalo; mongwe le mongwe o tshwana le baengele mo legodimong. ");
INSERT INTO tsn_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mme jaanong, fa e le gore go na le tsogo ya baswi, a ga lo ke lo bala dikwalo? A ga lo lemoge gore Modimo o ne o bua le lona fa o re, ");
INSERT INTO tsn_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ke Modimo wa ga Aberahame, Isake le Jakobe!’ Jalo Modimo ga se Modimo wa baswi, mme ke wa batshedi.” ");
INSERT INTO tsn_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Bontsintsi jwa batho jwa itumedisiwa thata ke dikarabo tsa gagwe. ");
INSERT INTO tsn_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","35","Mme e seng Bafarasai! E rile ba utlwa gore o didimaditse Basadukai ka phetolo ya gagwe, ba akanya sesha potso e bone ba ka e mmotsang. Mongwe wa bone yo e neng e le mmueledi (Agente), a bua a re: ");
INSERT INTO tsn_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Morena, taolo ya botlhokwa mo melaong ya ga Moshe ke efe?” ");
INSERT INTO tsn_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesu a fetola a re, “ ‘Rata Morena Modimo wa gago ka pelo yotlhe ya gago, ka mowa le tlhaloganyo.’ ");
INSERT INTO tsn_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","39","E ke taolo ya ntlha ebile e le e kgolo. Ya bobedi ya botlhokwa thata e e tshwanang le yone ke e e reng: ‘Rata mongwe ka wena jaaka o ithata.’ ");
INSERT INTO tsn_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ditaolo tse dingwe tsotlhe le se se batlwang ke baporofiti di tswa mo melaong e mebedi e, mme e diragadiwa fa e tshegediwa. Tshegetsa yone e mebedi e fela, mme o tlaa bona gore o tshegeditse e mengwe yotlhe.” ");
INSERT INTO tsn_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mme ya re a farafarilwe ke Bafarasai, a ba botsa potso a re: ");
INSERT INTO tsn_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Lo gopolang ka ga Mesia? Ke Morwa mang?” Ba araba ba re “Ke Morwa Dafide.” ");
INSERT INTO tsn_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Mme Jesu a botsa a re, “Mme ke eng fa Dafide, a bua ka tlhotlheletso ya Mowa o o Boitshepo, a mmitsa a re ‘Morena’ Ka gore Dafide o rile, ");
INSERT INTO tsn_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Modimo o reile Morena wa me wa re, nna ka fa letsogong la me le legolo go fitlhelela ke baya baba ba gago ka fa tlase ga dinao tsa gago!’ ");
INSERT INTO tsn_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mme fa Dafide a mmitsa ‘Morena’, e ka nna morwawe jang?” ");
INSERT INTO tsn_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ba tlhoka karabo. Mme morago ga moo ba tshaba go tlhola ba mmotsa dipotso tse dingwe. ");
INSERT INTO tsn_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mme Jesu a raya bontsintsi le barutwa ba gagwe a re, ");
INSERT INTO tsn_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Lo ne lo ka gopola gore baeteledipele ba ba Sejuda le Bafarasai ba, ke BoMoshe, ka tsela e ba e tshegeditseng go dira melao e mentsi! ");
INSERT INTO tsn_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mme go ntse fela jalo lo tshwanetse go reetsa sengwe le sengwe se ba se buang! Go ka ne go siame go dira se ba se buang, mme mo godimo ga tsotlhe fela, se nneng jaaka bone. Gonne ga ba dire se ba lo rayang ba re lo se dire. ");
INSERT INTO tsn_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ba lo imetsa ka dilo tse di sa kgonegeng tse bone ba sa lekeng le fa e le go di tshegetsa. ");
INSERT INTO tsn_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Sengwe le sengwe se ba se dirang ba se direla go bonwa. Ba dira boitshepo ka go apara diaparo tse di maburabura di kwadilwe ditemana tsa dikwalo tsa Modimo ka fa teng, le ka go lelefatsa makgabe a diaparo tsa bone tsa segopotso. ");
INSERT INTO tsn_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Gape ba rata thata jang go nna kwa pele fa lomating lwa bojelo lwa tlotlo e kgolo mo medirong, le mo ditilong tse di faphegileng tsa phuthego mo tlong ya thuto! ");
INSERT INTO tsn_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ba itumelela jang tlotlo e ba e newang mo mebileng, le go bidiwa ‘Rabi’ le ‘Morena’. ");
INSERT INTO tsn_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Lo se ka lwa ba lwa letla le fa e le mang go lo bitsa jalo. Gonne ke Modimo o o leng Rabi wa lona, mme lotlhe lo mo selekanyong se se tshwanang, jaaka bakaulengwe. ");
INSERT INTO tsn_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mme lo seka lwa bitsa ope fano mo lefatshing ‘Rara,’ ka gore Modimo fela, kwa legodimong ke one o tshwanetseng go bidiwa jalo. ");
INSERT INTO tsn_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Le gone lo seka lwa bidiwa ‘Morena’, ka gore a le nosi fela ke Morena wa lona, ebong Mesia. ");
INSERT INTO tsn_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","“Fela ka go direla ba bangwe ka boingotlo ga lona, lo tlaa nna bagolo. Gore o nne yo mogolo thata, nna modiredi wa ba bangwe. ");
INSERT INTO tsn_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mme ba ba ikgopolang ba le bagolo ba tlaa tlhabisiwa ditlhong ba bo ba ngotlafadiwa; mme ba ba ingotlafatsang ba tlaa godisiwa. ");
INSERT INTO tsn_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“A bo go latlhega lona Bafarasai le baeteledipele ba tumelo. Baitimokanyi! Gonne ga lo letle ba bangwe gore ba tsene mo Bogosing jwa Legodimo, gonne lona ka bolona ga lo tsene. Mme lo ipaya jaaka ekete lo boitshepo ka dithapelo tsa lona tse di telele tsa go itshupa fa pele ga batho mo mebileng, etswa lo leleka batlholagadi mo matlong a bone. Baitimokanyi ke lona! ");
INSERT INTO tsn_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ee, a bo go latlhega baitimokanyi. Gonne lo tsamaya sekgala se se telele gore lo sokolole motho a le mongwe, mme lo bo lo mo fetola gore a nne ngwana wa molete go menaganye go lo gaisa. ");
INSERT INTO tsn_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","A bo go latlhega lona! Bagogi ba lo foufetseng! Molao wa lona wa re go ikana ka ‘Tempele,’ ga go reye gore, lo ka roba ikano eo, mme go ikana ka ‘Gouta e e mo Tempeleng’ go a golega. ");
INSERT INTO tsn_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Dieleele ke lona tsa difofu! Go go golo eng, gouta kgotsa Tempele e e itshepisang gouta?! ");
INSERT INTO tsn_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Gape lwa re go ikana ‘Ka Sebeso’ go ka dirololwa, mme go ikana ‘Ka dimpho mo sebesong,’ go a golega. ");
INSERT INTO tsn_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Difofu ke lona! Go go golo eng, mpho mo sebesong, kgotsa sebeso ka bosone se se itshepisang? ");
INSERT INTO tsn_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Fa o ikana ‘Ka sebeso,’ o ikana ka sone le sengwe le sengwe se se mo go sone, ");
INSERT INTO tsn_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","gape fa o ikana ‘Ka Tempele’ o ikana ka yone, le ka Modimo o o nnang mo go yone. ");
INSERT INTO tsn_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Gape fa o ikana ‘Ka magodimo’ o ikana ka Setilo sa Modimo le Modimo ka sebele. ");
INSERT INTO tsn_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ee, a bo go latlhega lona Bafarasai, le lona bangwe ba baeteledipele ba tumelo, baitimokanyi ke lona! Gonne lo ntsha ditsabolesome mo lo e tleng lo bo lo ntshe letlhare la bofelo la menta mo tshimong ya lona, mme lo tlhokomologe dilo tsa botlhokwa ebong, tshiamo le kutlhwelobotlhoko le tumelo. Ee, lo tshwanetse go ntsha ditsabolesome, mme lo seka lwa tlogela dilo tsa botlhokwa di sa dirwa. ");
INSERT INTO tsn_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“Bagogi ba lo foufetseng! Lo ntshetsa montsana kwa ntle mme lo metsa kammela. ");
INSERT INTO tsn_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“A bo go latlhega Bafarasai le lona baeteledipele ba tumelo, baitimokanyi! Lo kelotlhoko mo go ntlafatseng bokafantle jwa senwelo, mme bokafateng jwa sone bo le leswe la patiko le bohula! ");
INSERT INTO tsn_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Bafarasai ke lona ba difofu! Pele tlhatswang bo ka-fa-teng jwa senwelo, hong ke gone senwelo sotlhe se nnang phepa. ");
INSERT INTO tsn_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“A bo go latlhega lona Bafarasai le baeteledipele ba tumelo! Lo tshwana le mabitla a mantle a a tletseng marapo a baswi le boitshekologo le makgapha. ");
INSERT INTO tsn_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Lo leka go nna jaaka ba ba itshepileng mme ka fa teng ga diaparo tseo tsa lona tsa kobamelo Modimo, go dipelo tse di marilweng ka mofuta mongwe le mongwe wa boitimokanyi le dibe. ");
INSERT INTO tsn_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","“Ee, a bo go latlhega lona baeteledipele ba tumelo le baitimokanyi! Gonne lo agela baporofiti ba ba bolailweng ke borraeno dihikantswe, lo bo lo baya dithunya mo mabitleng a batho ba ba boifang Modimo ba ba bolailweng, mme lo re ‘Ruri re ka bo re sa dira jaaka bo rraetsho ba dirile.’ ");
INSERT INTO tsn_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","“Ka go bua jalo, lo ipaya molato wa go nna bomorwa batho ba ba maswe. ");
INSERT INTO tsn_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mme lo tsamaya mo dikgatong tsa bone lo tlatsa dikgato tse di tletseng bosula jwa bone. ");
INSERT INTO tsn_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Dinoga ke lona! Bomorwa shaushawane! Lo tlaa falola jang katlholo ya molete? ");
INSERT INTO tsn_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ke tlaa lo romelela baporofiti, le banna ba ba botlhale, le batho ba ba tletseng mowa, le bakwadi ba ba tlhotlheleditsweng ka mowa o o galalelang, mme lo tlaa bolaya bangwe ka go ba bapola lo tlaa ba fatola mekwatla ka go ba kgwathisa mo matlong a thuto a lona, lo bo lo ba leleka mo motsing mongwe le mongwe. ");
INSERT INTO tsn_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Gore lo tle lo nne molato wa go tsholola madi a batho ba ba boifang Modimo ba ba bolailweng go simologa ka mosiami Abele go fitlhelela ka Sakaria (morwa Barakia), yo o bolailweng ke lona mo Tempeleng fa gare ga sebeso le felo ga boitshepo Ee, Katlholo yotlhe e e kgobokantsweng mo makgolong a dingwaga e tlaa wela mo ditlhogong tsa losika. ");
INSERT INTO tsn_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Jerusalema wee Jerusalema wee! Motse o o bolayang baporofiti, e bile o kgobotletsa ka maje ba Modimo o ba romang kwa go wena! Ga ke bolo go rata jang go phutha bana ba gago jaaka koko e phuthela bana ba yone ka fa tlase ga diphuka tsa yone, mme o ganne. ");
INSERT INTO tsn_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Mme jaanong ntlo ya gago o e tlogeletswe e sena le fa e le sepe. ");
INSERT INTO tsn_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Gonne ke go boleletse se gore, ga o kitla o tlhola o mpona go fitlhelela o ipaakanyetsa go amogela yo o romilweng kwa go wena a tswa kwa Modimong.” ");
INSERT INTO tsn_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","“Gonne ke go boleletse se gore ga o kitla o tlhola o mpona go fitlhelela o ipaakanyetsa go amogela yo o romilweng kwa go wena a tsa Modimong.” ");
INSERT INTO tsn_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Mme ya re fela fa Jesu a tswa mo patlelong ya Tempele, barutwa ba gagwe ba mo sala morago ba tla go mo tsamaisa ba mo kaetsa dikago tse di farologanyeng tsa Tempele. ");
INSERT INTO tsn_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mme a ba raya a re, “Dikago tse tsotlhe di tlaa digelwa fa fatshe, lentswe lepe le sa tlogelwe le tlhatlaganye le le lengwe!” ");
INSERT INTO tsn_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mme ya re morago fa barutwa ba gagwe ba ntse fa fatshe mo thoteng ya Thaba ya Lotlhware, ba mmotsa ba re, “mo go diragala leng? Ditshupo tse di tlaa supang go boa ga gago le bokhutlo jwa lefatshe ke dife?” ");
INSERT INTO tsn_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesu a fetola a re, “Se letleng ope go lo timetsa. ");
INSERT INTO tsn_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Gonne ba le bantsi ba tlaa tla ba ipitsa gore ke bone BoMesia, mme ba timetsa ba le bantsi. ");
INSERT INTO tsn_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Fa lo utlwa ka go simologa ga dintwa, mo go tlaa bo go sa supe go boa ga me; mo go tshwanetse go diragala, mme bokhutlo bo tlaa bo bo ise bo tle. ");
INSERT INTO tsn_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dichaba le Mebuso ya lefatshe di tlaa tsogologelana, go tlaa nna mauba le dithoromo tsa lefatshe mo mafelong a le mantsi. ");
INSERT INTO tsn_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mme gotlhe mo e tlaa bo e le tshimologo ya ditlalelo tse di tlang fela.” ");
INSERT INTO tsn_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Hong lo tlaa tlhokofadiwa, lo bolawe, lo bo lo ilwe ke lefatshe lotlhe ka ntlha ya gore lo ba me. ");
INSERT INTO tsn_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mme ba le bantsi ba lona ba tlaa boela mo sebeng, ba okane ba bo ba ilane.” ");
INSERT INTO tsn_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mme go tlaa nna le baporofiti ba le bantsi ba eseng bone mme ba tlaa timetsa bontsi. ");
INSERT INTO tsn_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sebe se tla ntsifala thata gongwe le gongwe, se tsidifatse lorato lwa ba le bantsi. ");
INSERT INTO tsn_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mme ba ba itshokang go ya bokhutlong ba tlaa bolokwa. ");
INSERT INTO tsn_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","“Mme mafoko a a molemo a Bogosi a tlaa rerwa mo lefatshing lotlhe gore dichaba tsotlhe di utlwe, mme hong lwa bofelo bokhutlo bo tlaa tla. ");
INSERT INTO tsn_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jalo, fa lo bona selo se se makgapha, (se se boletsweng ke Moporofeti Daniele, a mmadi a tlhaloganye se se buiwang!) ");
INSERT INTO tsn_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","hong ba ba mo Judea ba patelesega go tshabela kwa dithabeng tsa Judea. ");
INSERT INTO tsn_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","“Ba ba mo maribelong a matlo a bone ba seka ba tsena mo teng go phutha dilwana pele ga ba tshaba. ");
INSERT INTO tsn_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ba ba kwa masimo ba seka ba boela kwa magaeng a bone go tsaya diaparo. ");
INSERT INTO tsn_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“Mme a bo go tlaa bo go latlhega basadi ba baimana le ba ba nang le masea mo malatsing ao. ");
INSERT INTO tsn_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mme lo rapele gore go sia ga lona go seka ga nna mariga, kgotsa go le Sabata ");
INSERT INTO tsn_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Gonne go tlaa nna pogisego e lefatshe le iseng le ke le e bone pele mo tshimologong ya lone go fitlha nako eno, mme ga e kitla e tlhola e bonwa gape.” ");
INSERT INTO tsn_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","“Mme tota fa malatsi ao a sa khutshwafadiwe, batho botlhe ba tlaa nyelela, mme a tlaa khutshwafadiwa ka ntlha ya batho ba Modimo o ba itshenketseng.” ");
INSERT INTO tsn_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Hong fa mongwe a lo raya a re ‘Mesia o gorogile kwa lefelong lengwe, kgotsa o bonetse fano kgotsa fale, kgotsa mo motseng o kgotsa ole,’ se dumeleng. ");
INSERT INTO tsn_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Gonne go tlaa nna teng Bo-Kereste ba le bantsi ba eseng bone, le baporofiti ba eseng bone, ba tlaa dira dikgakgamatso, gore e re fa go no go ka kgonega, le e leng ba ba itlhophetsweng ke Modimo tota ba tsiediwe. ");
INSERT INTO tsn_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Bonang, ke lo tlhagisitse. ");
INSERT INTO tsn_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Mme ke gone fa mongwe a lo raya a re Mesia o boile mme o ile kwa sekakeng, lo se ka lwa eletsa go tsamaya lo ya go bona, kgotsa, gore o iphitlhile golo gongwe, se dumeleng! ");
INSERT INTO tsn_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Gonne jaaka logadima lo tle lo gadime go kgabaganya loapi go tsweng botlhabatsatsi go ya bophirima, go tla ga me go tlaa nna jalo, fa nna Morwa Motho ke boa. ");
INSERT INTO tsn_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mme gongwe le gongwe kwa go nang le setoto, manong a phuthegela gone. ");
INSERT INTO tsn_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“E tlaa re ka bofefo morago ga pogiso ya malatsi letsatsi le tlaa fifadiwa, le ngwedi o tlaa ntshofala, le dinaled di bonala o ka re di wa mo magodimong, le dinonofo tse di khuromeditseng lefatshe di tlaa reketlisiwa. ");
INSERT INTO tsn_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Mme kwa bofelong sesupo sa go tla ga me se tlaa bonala mo magodimong, mme go tlaa nna khutsafalo e kgolo mo tikologong ya lefatshe lotlhe, mme dichaba tsa lefatshe di tlaa mpona ke goroga ka maru a legodimo, ka nonofo le kgalalelo e kgolo. ");
INSERT INTO tsn_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mme ke tlaa roma baengele ba me ka tumo ya torompeta e kgolo, mme ba tlaa phutha baitshenkedwi ba me go tsweng dikhutlong tsa lefatshe le legodimo. ");
INSERT INTO tsn_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Jaanong ithuteng thuto ka setlhare sa mofeige. Fa kala ya sone e le nana matlhare a simolola go kukunya, lo itse gore selemo se setse se gorogile. ");
INSERT INTO tsn_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Fela jalo, fa lo bona dilo tse tsotlhe di simolola go diragala, lo ka itse gore go boa ga me go gaufi, go fela fa mojakong. ");
INSERT INTO tsn_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Hong kwa bofelong lobaka lo lo tlaa tla mo bokhutlong jwa lone. ");
INSERT INTO tsn_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","“Legodimo le lefatshe di tlaa nyelela, mme mafoko a me a tla nna ka bosenabokhutlo.” ");
INSERT INTO tsn_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Mme ga go ope yo o itseng letsatsi le fa e le nako e bokhutlo bo tlaa tlang ka yone, le fa e le baengele. Nnyaa, le fa e le Morwa Modimo tota. Ke Rara fela a le esi yo o itseng. ");
INSERT INTO tsn_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","38","“Lefatshe le tlaa bo le iketlile, le le mo tlhapeding ya meletlo batho ba a ja ba a nwa, ba nyala ba nyadisa, jaaka go ne go ntse ka nako ya ga Noa pele ga go tla ga tshoganetso ga morwalela. ");
INSERT INTO tsn_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Batho ba ne ba sa dumele se se neng se ya go diragala go fitlhelela morwalela o tla o ba phaila botlhe. Jalo go tla ga me go tlaa nna fela jalo. ");
INSERT INTO tsn_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Banna ba le babedi ba tlaa bo ba dira mo masimong, mongwe o tlaa tsewa, yo mongwe a tlogelwa. ");
INSERT INTO tsn_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Basadi ba le babedi ba tlaa bo ba dira tiro ya bone ya lolwapa, mongwe o tlaa tsewa, yo mongwe a tlogelwe. ");
INSERT INTO tsn_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ke gone ipaakanyeng, gonne ga lo itse letsatsi le Morena wa lona o tlang ka lone. ");
INSERT INTO tsn_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Fela jaaka motho a ka kganela matshwenyego a a leriweng ke magodu ka go nna a itlhokometse mo go one. ");
INSERT INTO tsn_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jalo lo ka kganela matshwenyego ka go nna malatsi otlhe lo ipaakanyeditse go boa ga me mo go se kitlang go anamisiwa. ");
INSERT INTO tsn_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“A o motlhanka yo o botlhale yo o ikanyegang wa Morena? a ke go neetse tironyana ya go laola ba ntlo ya me, go fepa bongwanake letsatsi le letsatsi? ");
INSERT INTO tsn_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","O sego fa e ka re ke boa ka fitlhela o dira tiro ya gago ka go ikanyega. ");
INSERT INTO tsn_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ke tlaa dira ba ba ikanyegang jalo balaodi ba sengwe le sengwe se ke nang naso. ");
INSERT INTO tsn_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mme fa o le bosula o bo o ithaya o re, ‘Morena wa me ga a na go tla ka bofefo,’ ");
INSERT INTO tsn_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","o bo o simolola go gatelela batlhanka ka wena, o o ja o nwa o tagwa. ");
INSERT INTO tsn_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Morena wa gago o tlaa goroga a sa anamisiwa e bile a sa solofelwa, ");
INSERT INTO tsn_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","“Mme a ba a go kgwathisa thata a go lelekela katlholong ya baitimokanyi; kwa go tlaa nnang selelo le khuranyo ya meno teng.” ");
INSERT INTO tsn_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Bogosi jwa Legodimo bo ka tshwants-hiwa ka polelo ya makgarebana a a some a a neng a tsaya dipone tsa one a ya go kgatlhantsha monyadi. ");
INSERT INTO tsn_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Mme ba le batlhano fela ba bone ba ne ba nna botlhale go tlatsa dipone tsa bone lookwane, fa ba bangwe ba batlhano ba ne ba dira boeleele ba lebala go dira jalo. ");
INSERT INTO tsn_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","6","“Mme ya re monyadi a diega, ba nna fa fatshe go itapolosa go fitlhelela bosigogare fa ba thantshiwa ke mokgosi o o reng, ‘Monyadi o e tla! Tswelang kwa ntle lo mo amogeleng.’ ");
INSERT INTO tsn_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","8","“Basetsana botlhe ba phaphama ba baakanya dipone tsa bone. Mme, ba batlhano ba ba neng ba sena lookwane ba kopa ba bangwe go ba thelela lookwane gonne dipone tsa bone di ne di tima. ");
INSERT INTO tsn_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Mme ba bangwe ba fetola ba re, ‘ga re na lookwane lo lo lekanyeng. Tsamayang lo ye kwa mabentleleng lo ye go ithekela.’ ");
INSERT INTO tsn_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Mme ya re ba sa ntse ba tsamaile monyadi a goroga mme ba ba neng ba ipaakantse ba tsena nae mo modirong wa lenyalo, mme kgoro ya tswalwa. ");
INSERT INTO tsn_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Morago fa ba bangwe ba batlhano ba boa, ba nna kwa ntle ba bitsa ba re, ‘Morena Morena, re bulele!’ ");
INSERT INTO tsn_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Mme a fetola a re ‘Tsamayang! nako e setse e fetile!’ ");
INSERT INTO tsn_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Jalo nnang lo itisitse lo ipaakantse, gonne ga lo itse letsatsi kgotsa lobaka lwa go boa ga me.” ");
INSERT INTO tsn_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Gape, Bogosi jwa Legodimo bo ka tshwantshiwa ka polelo ya monna yo o kileng a ya kwa lefatshing lengwe, yo o neng a bitsa batlhanka ba gagwe mme a ba neela madi go a mo atisetsa a sa ntse a seyo. ");
INSERT INTO tsn_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A neela wa ntlha madi a selekanyo sa ditalenta di le tlhano, yo mongwe a mo neela ditalenta di le pedi, mme wa bofelo a mo neela talenta e le nngwe fela, a a kgaoganya ka fa nonofong ya bone, mme hong a simolola loeto lwa gagwe. ");
INSERT INTO tsn_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Monna yo o amogetseng ditalenta di le tlhano a simolola go reka a rekisa mme a dira lesome. ");
INSERT INTO tsn_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Monna yo o tshotseng ditalenta tse pedi a tlhamalalela kwa tirong, le ene a dira ditalenta tse pedi tse dingwe. ");
INSERT INTO tsn_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","“Mme monna yo o amogetseng talenta e le nngwe a e epela mosima a e fitlha mo teng gore e bolokesege. ");
INSERT INTO tsn_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Morago ga nako e telele monnga-bone a boa mo loetong lwa gagwe, mme a ba biletsa kwa go ene go arabela madi a gagwe. ");
INSERT INTO tsn_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Monna yo o neng a mo neetse ditalenta di le tlhano a mo neela ditalenta di le some. ");
INSERT INTO tsn_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Monngagwe a mo akgolela tiro e ntle eo. A mo raya a re o ikanyegile mo go bolokeng bonnyennyane jo, jalo he ke tlaa go naya thata mo dilong di le dintsi. Tla o tlhakanele le nna boitumelo jwa me.” ");
INSERT INTO tsn_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Lwa bobedi ga tla monna yo a neng a amogetse ditalenta di le pedi ka polelo e e reng, ‘Morena, o nneetse ditalenta di le pedi go di dirisa, mme ke menagantse gabedi.’ ");
INSERT INTO tsn_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Monngagwe a mo raya a re, ‘O dirile tiro e ntle, O motlhanka yo o siameng yo o ikanyegang. O ntse o ikanyega mo go bolokeng bonnyennyane jo, mme jaanong ke go neela go le gontsi.’ ");
INSERT INTO tsn_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","Hong monna yo o tshotseng talenta e le nngwe a tla mme a re, ‘Morena ke go itse o le motho yo o pelo e thata, mme ke ne ka tshaba gore o tlaa ntseela se ke se boneng ka go atisa madi, jalo ka fitlha madi a gago mo mmung, mme ke a!’ ");
INSERT INTO tsn_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mme monngagwe a fetola a re, ‘Motlhanka yo o bosula! Lekgoba le le setshwakga! Ka o no o itse ke tlaa batla ga mofufutso wa phatla ya gago, ");
INSERT INTO tsn_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","O ka bo bogolo o ne wa baya madi a me mo polokelong gore ke tle ke bone morokotso wa one ");
INSERT INTO tsn_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tsayang madi a mo monneng yo lo a neele monna yo o nang le ditalenta di le some. ");
INSERT INTO tsn_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Gonne motho yo o dirisang se a se neetsweng sentle o tlaa neelwa go le go tona, mme o tlaa nna le letlotlo, mme motho yo o sa ikanyegeng, le e leng tshwanelo e potlana e a nang nayo e tlaa tsewa mo go ene. ");
INSERT INTO tsn_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mme fa e le motlhanka yo o senang molemo yo o tlaa latlhelwa kwa ntle mo lefifing kwa go tlaa nnang selelo le khuranyo ya meno.’ ");
INSERT INTO tsn_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Mme fa nna Morwa Motho ke tla mo kgalalelong ya me, le baengele botlhe ba na le nna, ke tlaa nna mo setulong sa me sa kgalalelo. ");
INSERT INTO tsn_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mme dichaba tsotlhe di tlaa phuthelwa fa pele ga me. Mme ke tlaa kgaoganya batho jaaka modisa a kgaoganya dinku le dipudi; ");
INSERT INTO tsn_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ke baya dinku ka fa lebogong le legolo, dipudi ka fa go la molema. ");
INSERT INTO tsn_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Hong nna Kgosi ke tlaa raya ba ba ka fa lebogong la me le legolo ke re, ‘Tlang, basegofadiwa ba ga Rre mo Bogosing jo lo bo baakanyeditsweng go tsweng kwa tlholegong ya lefatshe. ");
INSERT INTO tsn_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gonne ke ne ka bolawa ke tlala mme lwa mpha dijo; ke ne ka nyorwa mme lwa nnosa; ke ne ka nna moeng mme lwa ntaletsa mo malwapeng a lona; ");
INSERT INTO tsn_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","“Ke ne ke sa apara mme lwa nkapesa; ke ne ke lwala ka ba ka nna mo kgolegelong, mme lwa tla go ntlhola.’ ");
INSERT INTO tsn_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Hong basiami ba tlaa fetola ba re, ‘Morena re kile ra go bona leng o bolailwe ke tlala mme ra go fa dijo? Kgotsa o nyorilwe mme ra go nosa? ");
INSERT INTO tsn_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kgotsa o le moeng mme ra go thusa? Kgotsa o sa apara mme ra go apesa? ");
INSERT INTO tsn_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Re kile ra go bona leng o lwala kgotsa o le mo kgolegelong mme ra go etela?’ ");
INSERT INTO tsn_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Mme nna Kgosi, ke tlaa lo raya ke re, ‘E rile fa lo go direla’ bakaulengwe ba, lwa bo lo go ntirela! ");
INSERT INTO tsn_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Hong ke tlaa gadimela ka fa go ba ba fa molemeng wa me ke re, ‘Tlong, lona ba lo hutsegileng, lo yeng kwa molelong o o sa khutleng, o o baakanyeditsweng diabolo le mewa e e maswe. ");
INSERT INTO tsn_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gonne ke ne ka bolawa ke tlala mme lwa seka lwa mpha dijo; ka nyorwa mme lwa seka lwa nneela le fa e le sepe go se nwa. ");
INSERT INTO tsn_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ka nna moeng mme lwa seka lwa ntshola; ke ne ke sa apara mme ga lo a ka lwa nkapesa; ka lwala, ka ba ka nna mo kgolegelong ga lo a ka lwa tla go ntlhola.’ ");
INSERT INTO tsn_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Hong ba tlaa fetola ba re ‘Morena, re kile ra go bona leng o bolailwe ke tlala kgotsa o tshwerwe ke lenyora kgotsa o le moeng kgotsa o sa apara kgotsa o lwala kgotsa o le mo kgolegelong mme ra se ka ra go thusa?’ ");
INSERT INTO tsn_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Mme ke tlaa araba ke re, ‘E rile fa lo gana go direla bakaulengwe ba ba botlana ba, lo no lo gana go direla nna.’ ");
INSERT INTO tsn_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Mme ba tlaa ya kwa kwatlhaong e e sa khutleng; mme basiami ba tla a ya mo botshelong jo bo sa khutleng.” ");
INSERT INTO tsn_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Mme e rile Jesu a sena go fetsa puo e le barutwa ba gagwe a ba raya a re, ");
INSERT INTO tsn_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Jaaka lo itse, gore modiro wa Tlolaganyo o simologa mo malatsing a mabedi a a tlang, ke tlaa okwa ke be ke bapolwa.” ");
INSERT INTO tsn_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ka lone lobaka loo ditlhogo tsa baperesiti le bagolwane ba bangwe ba Sejuda ba phuthegela kwa kgotleng ya ga Kaiafase moperesiti yo mogolo, ");
INSERT INTO tsn_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","go gakololana ka maano a go tshwara Jesu ka bokukuntshwane go mmolaya. ");
INSERT INTO tsn_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mme ba dumalana ba re, “Eseng ka modiro wa Tlolaganyo, gonne go ka tsoga pheretlhego.” ");
INSERT INTO tsn_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Foo Jesu a tswela kwa Bethania, kwa legaeng la ga Simone wa molepero. ");
INSERT INTO tsn_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mme ya re Jesu a sa ntse a a ja ga tla mosadi mongwe a tshotse lebotlolo la setlolo se se tlhwatlhwa kgolo, mme a se tshela mo tlhogong ya gagwe. ");
INSERT INTO tsn_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Barutwa ba ne ba gakatsega ba re, “A tshenyo ya madi a magolo! O ka bo a se rekisitse madi a mantsi mme a a abela bahumanegi.” ");
INSERT INTO tsn_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesu a itse se ba se akanyang, mme a re, “Ke eng fa lo mo tshwaya phoso? Gonne o ntiretse tiro e ntle thata. ");
INSERT INTO tsn_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Lo tlaa aga lo na le bahumanegi, mme ga lo na go nna le nna ka malatsi otlhe. ");
INSERT INTO tsn_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","O tshetse setlolo se mo go nna go baakanyetsa mmele wa me go fitlhwa. ");
INSERT INTO tsn_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mme o tlaa aga a gopolwa ka tiro e. Polelo ya se a se dirileng e tlaa bolelwa mo lefatshing lotlhe, gongwe le gongwe kwa Mafoko a a Molemo a rerwang teng.” ");
INSERT INTO tsn_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Judase Isekariota, mongwe wa baaposetoloi ba ba some le bobedi a ya kwa ditlhogong tsa baperesiti, ");
INSERT INTO tsn_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","mme a botsa a re, “Lo tlaa ntuela bokae go tsenya Jesu mo diatleng tsa lona?” Mme ba mo naya dipapetlana tsa selefera di le masome mararo. ");
INSERT INTO tsn_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mme go simologa ka lobaka loo, Judase a batla lebaka le le siameng la go ba okela Jesu. ");
INSERT INTO tsn_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mo letsatsing la ntlha la mediro ya Tlolaganyo, fa senkgwe se se sa bidisi wang se se, tswang mo malapeng a a farologaneng a Sejuda se jewa, barutwa ba tla kwa go Jesu ba mmotsa ba re, “Re baakanyetsa go jela Moletlo wa Tlolaganyo kae?” ");
INSERT INTO tsn_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","A fetola a re, “Tsenang mo motseng lo fete lo bone rre semangmang, mme lo mo reye lo re, ‘Monnga rona a re, nako yame e gorogile mme ke tlaa jela dijo tsa Moletlo wa Tlolaganyo le barutwa ba me kwa tlong ya gago.’” ");
INSERT INTO tsn_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jalo barutwa ba dira jaaka a ba boleletse, mme ba baakanya dijo teng. ");
INSERT INTO tsn_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","21","Mme ya re mo maabanyaneng ao fa a sa ntse a a ja le ba ba some le bobedi, a bua a re “Mongwe wa lona o tlaa nkoka.” ");
INSERT INTO tsn_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mme ba futsafala thata, mme mongwe le mongwe wa bone a botsa a re, “A ke nna?” ");
INSERT INTO tsn_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","A fetola a re, “Ke yo ke mo fileng sejo pele. ");
INSERT INTO tsn_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Gonne ke tshwanetse go swa fela jaaka go porofitilwe, mme a bo go latlhega monna yo o nkokang. Go ka bo go le molemo thata fa yoo a ka bo a na a seka a tsalwa.” ");
INSERT INTO tsn_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judase le ene, o ne a mmotsa a re, “Moruti, a ke nna?” Mme Jesu a mo raya a re, “Ke wena.” ");
INSERT INTO tsn_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ya re ba sa ja, Jesu a tsaya senkgwe a se segofatsa, a se ngathoganya a se neela barutwa a re, “Tsayang lo je gonne se ke mmele wa me.” ");
INSERT INTO tsn_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Gape a tsaya senwelo sa mofine a se segofatsa, a se ba neela a re, “Mongwe le mongwe a nwe, ");
INSERT INTO tsn_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","gonne se ke madi ame, a a kanelang Kgolagano e Ncha. A tshololelwa go itshwarela dibe tsa bontsintsi jwa batho. ");
INSERT INTO tsn_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Tlhokomelang mafoko a me: Ga ke na go tlhola ke nwa mofine o gape go fitlhelela letsatsi le ke tlaa o nwang le lona o le mosha mo Bogosing jwa ga Rre.” ");
INSERT INTO tsn_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mme ya re ba sena go opela sefela, ba ya kwa Thabeng ya Lotlhware. ");
INSERT INTO tsn_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mme Jesu a ba raya a re, “Bosigong jono, lotlhe lo tlaa mphatlalalela. Gonne go kwadilwe mo Dikwalong gore Modimo o tlaa itaya modisa, mme letsomane la dinku le tlaa phatlalala. ");
INSERT INTO tsn_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mme morago ga ke tsosiwa ke tlaa ya Galalea, go lo rakantsha teng.” ");
INSERT INTO tsn_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petere a mo fetola a re, “Fa botlhe ba ka go tlogela, nna ga ke na go go tlogela.” ");
INSERT INTO tsn_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesu a mo raya a re, “Boammaaruri ke gore mo bosigongjono, pele ga mokoko o lela ka nako ya mahube maphakela, o tlaa bo o intatotse gararo!”. ");
INSERT INTO tsn_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petere a fetola a re, “Go ka swa nna pele.” Mme le barutwa ba bangwe botlhe ba bua fela jalo. ");
INSERT INTO tsn_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Hong Jesu a ba lere fa moseleng wa tshimo ya Gethesemane, mme a ba raya a re ba nne fa fatshe mme ba lete foo a sa ntse a tsamaela fa pele go ya go rapela. ");
INSERT INTO tsn_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","A tsaya Petere le bomorwa Sebede ba babedi Jakobe le Johane, mme a simolola go hutsafala le go huduega. ");
INSERT INTO tsn_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Mme a ba raya a re, “Mowa wa me o hutsafetse thata o bile o utlwile botlhoko mo go isang losung: Lo lebelele le Nna.” ");
INSERT INTO tsn_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A ya fa pelenyana, a wela ka sefatlhogo fa fatshe, a rapela a re, “Rara! Fa go kgonega, a senwelo se se tlosiwe fa go nna. Mme ke batla thato ya gago, eseng ya me.” ");
INSERT INTO tsn_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mme a boela morago kwa barutweng ba bararo mme a ba fitlhela ba thulametse. Mme a bitsa Petere a re, “a lo no lo ka seka lwa lebelela le nna ka lobaka lwa selekanyo sa oura fela? ");
INSERT INTO tsn_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Lebelelang lo rapele. Esengjalo thaelo e tlaa lo fenya. Gonne mowa tota o a rata, mme mmele o bokoa thata!” ");
INSERT INTO tsn_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Gape a ba tlogela a ya go rapela, a re, “Rara! Fa senwelo se se sa kake sa feta fela fa ke sa se nwe sotlhe, a go rata ga gago go diragale.” ");
INSERT INTO tsn_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","A boela kwa go bone mme a fitlhela ba robetse, gonne ba ne ba otsela thata, ");
INSERT INTO tsn_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","mme a boela gape mo thapelong lwa boraro, a boelela mafoko a o neng a ntse a a bua. ");
INSERT INTO tsn_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Hong a tla kwa barutweng a re, “Robalang lo itapoloseng, bonang! Nako e gorogile, ke okelwa mo diatleng tsa batho ba ba bosula! ");
INSERT INTO tsn_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tsogang; a re tsamayeng! Bonang, motho yo o nkokang ke yoo o e tla!” ");
INSERT INTO tsn_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mme ya re ka lona lobaka loo a ntse a bua, Judase, mongwe wa ba ba lesome le bobedi, a goroga le bontsi jo bogolo jwa batho ba tshotse dichaka le melamu ba romilwe ke Baeteledipele ba Sejuda. ");
INSERT INTO tsn_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judase o na a ba reile a re ba tshware yo o tlaa mo dumedisang gonne e tlaa bo e le ene yo ba mmatlang. ");
INSERT INTO tsn_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Hong Judase a tla a tlhamalaletse kwa go Jesu a re, “Dumela Morena!” Mme a mo tlamparela ka tsela ya go atla ka lorato lo lo feteletseng lwa tlhologelelo. ");
INSERT INTO tsn_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesu a re, “Tsala ya me, tswelela pele o dire se o se tletseng.” Hong ba bangwe ba mo tshwara. ");
INSERT INTO tsn_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mongwe wa banna ba ba patileng Jesu a somola chaka a kgaola tsebe ya motlhanka wa Moperesiti yo mogolo. ");
INSERT INTO tsn_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Mme Jesu a mo raya a re, “Baya chaka ya gago, ba ba dirisang dichaka ba tlaa bolawa. ");
INSERT INTO tsn_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","A ga o lemoge gore ke ne ke ka kopa Rre dikete tsa baengele go re sireletsa, mme o na a ka ba roma gone fela ka nako eo. ");
INSERT INTO tsn_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mme fa nkabo ke dirile jalo; Dikwalo di ne di ka diragadiwa jang tse di tlhalosang se se diragalang jaanong jaana?” ");
INSERT INTO tsn_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hong Jesu a bua le bontsintsi jwa batho a re, “A ke serukutlhi se se diphatsa, mo lo neng lwa tshwanelwa ke go tsaya dichaka le melamu pele ga lo ntshwara? Ke ntse le lona ka malatsi otlhe ke ruta mo Tempeleng mme ga lo ise lo ke lo nkganele. ");
INSERT INTO tsn_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mme mo gotlhe ga diragala go diragatsa mafoko a baporofiti jaaka a kwadilwe mo Dikwalong.” ");
INSERT INTO tsn_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Hong bontsi jwa batho jwa mo isa kwa legaeng la ga Kaiafase Moperesiti yo mogolo, kwa baeteledipele botlhe ba Sejuda ba neng ba phuthegetse teng. ");
INSERT INTO tsn_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Mme e rile ka yone nako eo Petere a bo a le kgakala a mo setse morago, mme a tla mo kgotleng ya moperesiti yo mogolo a tsena mo teng a nna le masole, mme a emela go bona se se neng se tsile go diragalela Jesu. ");
INSERT INTO tsn_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ditlhogo tsa baperesiti le lekgotla lotlhe le le tona la Sejuda tsa phuthaganela teng mme tsa senka basupi ba ba ka buang maaka ka ga Jesu, go mo direla kgang e e ka felelang ka katlholo ya loso. ");
INSERT INTO tsn_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Mme le fa ba ne ba bona bontsi jo bo neng jwa dumalana go nna basupi ba eseng ba boammaaruri, bone bao ba ne ba aga ba ganetsanya. Lwa bofelo ga bonwa banna ba le babedi ba ba neng ba supa ba re, “Monna yo o rile, ‘Ke kgona go senya Tempele ya Modimo ke bo ke e age mo malatsing a mararo’ ");
INSERT INTO tsn_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Hong Mo peresiti yo Mogolo a ema ka dinao a raya Jesu a re, wa reng ka ga gone? A o buile jalo kgotsa nnyaa?” ");
INSERT INTO tsn_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mme Jesu a didimala fela. Jalo Moperesiti yo Mogolo a mo raya a re, “Ke go ikanisa mo leineng la Modimo o o tshedileng gore o re bolelele gore a o ipitsa Mesia Morwa Modimo.” ");
INSERT INTO tsn_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Mme Jesu a re, “Ee, ke ene. Mme e tlaa re mo malatsing a a tlang lo tlaa mpona, Nna Morwa Motho, ke ntse ka fa lebogong le legolo la Modimo ke tla ka maru a legodimo.” ");
INSERT INTO tsn_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","66","Hong moperesiti yo Mogolo a ikgagola diaparo a goa a re, “O a tlhapatsa! Re sa ntse re tlhokelang basupi ba bangwe? Lo mo utlwile lotlhe a buajalo! Katlholo ya lona ke efe?” Ba gowa ba re, “A a bolawe! A a bolawe! A a bolawe!” ");
INSERT INTO tsn_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hong ba mo kgwela mathe mo sefatlhogong, ba mo itaya mme ba bangwe ba mo phanya. ");
INSERT INTO tsn_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ba re, “Re porofesetse, wena Mesia ke mang yo o nang a go itaya ka nako ele?” ");
INSERT INTO tsn_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mme e rile ka lobaka loo, fa Petere a ntse mo kgotleng, mosetsana a tla kwa go ene a mo raya a re, “O ne o na le Jesu, gonne lotlhe lo tswa Galalea.” ");
INSERT INTO tsn_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mme Petere a itatolela kwa godimo a gaketse a re, “Ga ke itse se o buang ka sone.” ");
INSERT INTO tsn_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Mme ya re a sena go tswa ka kgoro, mosetsana yo mongwe a mo lemoga, mme a raya ba ba neng ba eme foo a re, “Monna yo o ne a na le Jesu wa Nasaretha.” ");
INSERT INTO tsn_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Gape Petere a itatola, ka ikano a re “Ga ke itse monna yo.” ");
INSERT INTO tsn_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mme morago ga lobakanyana banna ba ba neng ba eme foo ba tla kwa go ene ba re, “Re itse gore o mongwe wa barutwa ba gagwe, gonne re utlwile loleme lwa gago lwa Segalalea.” ");
INSERT INTO tsn_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Petere a simolola go rogakana le go ikana a re, “Ga ke itse monna yo.” Mme ka bofefo mokoko wa lela. ");
INSERT INTO tsn_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Hong Petere a gakologelwa se Jesu a se mo reileng fa a re, “Pele ga mokoko o lela o tlaa bo o intatotse gararo.” Mme a tswela kwa ntle a lela mo go botlhoko. ");
INSERT INTO tsn_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mme e rile mo mosong, ditlhogo tsa pa-peresiti le baeteledipele ba Sejuda ba rakana gape go gakololana ka fa ba ka tlhotlheletsang ka teng mmuso wa Se-Roma go atlholela Jesu loso. ");
INSERT INTO tsn_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mme ba mo romela kwa go Pilatwe molaodi wa Roma a golegilwe ka dikeetane. ");
INSERT INTO tsn_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","E rile ka nako eo, fa Judase yo o mo okileng a bona gore Jesu o atlholetswe loso, a ikwatlhaya a utlwa botlhoko thata ka se a se dirileng, a busetsa madi kwa ditlhogong tsa baperesiti le baeteledipele ba bangwe ba Sejuda. ");
INSERT INTO tsn_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","A re, “Ke leofile, gonne ke okile motho yo o senang molato.” Ba mo fetola ba re, “Ke dibonwa ke wena.” ");
INSERT INTO tsn_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hong a latlhela madi mo bodilong jwa Tempele, a tswa a ya go ikaletsa. ");
INSERT INTO tsn_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ditlhogo tsa baperesiti tsa sela madi ao. Tsa re, “Ga re kake ra a tsenya mo letloleng, gonne go kgatlhanong le melao ya rona go amogela madi a a dueletseng polao ya motho.” ");
INSERT INTO tsn_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ba go rerisanya mme kwa bofelong ba dumalana go reka setsha sa lefatshe se letsopa la sone le neng le dirisiwa go bopa dinkgwana le gore se dirisiwe go fitlha baeng ba ba swelang mo Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ke sone se e leng gore setsha se, se sa ntse se bidiwa “Lefatshe la Madi” ");
INSERT INTO tsn_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Se se dirafaditse seporofeso sa ga Jeremia se se reng, “Ba tsaya dipapetlana tsa selefera di le masome mararo, tlhwatlhwa e a neng a e beetswe ke batho ba Iseraele, ");
INSERT INTO tsn_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","mme ba reka setsha mo baboping ba dinkgwana jaaka Morena Modimo a nkaetse.” ");
INSERT INTO tsn_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Mme ya re Jesu a eme fa pele ga ga Pilatwe, molaodi wa Roma, a mmotsa a re, “A o Mesia wa Bajuda”? Jesu a mo araba a re, “Ee go ntse jalo.” ");
INSERT INTO tsn_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mme e rile ditlhogo tsa baperesiti le baeteledipele ba bangwe ba Sejuda ba mmaya melato e mentsintsi, Jesu a didimala fela. ");
INSERT INTO tsn_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilatwe a mo raya a re, “A ga o utlwe se ba se buang?” ");
INSERT INTO tsn_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mme Jesu a seka a bua sepe mme mo ga gakgamatsa moladi thata. ");
INSERT INTO tsn_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mme ka fa mokgweng wa molaodi e ne e le gore ngwaga le ngwaga a golole legolegwa lengwe la Sejuda ka moletlo wa Tlolaganyo. Mongwe fela yo ba mo ratang. ");
INSERT INTO tsn_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mo ngwageng eo ga bo go le mo kgolegelong Barabase serukutlhi se se itsegeng thata, ");
INSERT INTO tsn_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","mme ya re bontsintsi bo phuthegela fa pele ga ntlo ya ga Pilatwe mo mosong oo, a ba botsa a re, “Lo batla ke lo gololela mang, Barabase kgotsa Jesu Mesia wa lona?” ");
INSERT INTO tsn_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Gonne o na a itse sentle gore baeteledipele ba Sejuda ba golegile Jesu ka kilo ka ntlha ya go tuma ga gagwe. ");
INSERT INTO tsn_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mme ya re a ntse a sekisa, mosadi wa gagwe a mo romelela molaetsa o: “Tlogela monna yo o siameng yoo; gonne ke letse ke tshwenyegile thata mo torong ka ntlha ya gagwe.” ");
INSERT INTO tsn_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ka nako eo ditlhogo tsa baperesiti le bagolwane ba Sejuda ba tlhotlheletsa bontsintsi jwa batho go kopa gore Barabase a gololwe, Jesu ene a bolawe. ");
INSERT INTO tsn_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Hong ya re fa molaodi a botsa gape a re, “Ke ofe mo go ba babedi ba, yo lo batlang ke lo mo gololela?” Bontsi jwa batho ba goa ba re, “Barabase!” ");
INSERT INTO tsn_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Hong Pilatwe a botsa a re, “Jaanong ke tlaa reng ka Jesu, Mesia wa lona?” Mme ba goa, ba re, “A a bapolwe!” ");
INSERT INTO tsn_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatwe a re, “Ka ntlha yang? O dirile bosula jwa eng?” Mme ba tswelela ba goa ba re, “A a bapolwe! A a bapolwe!” ");
INSERT INTO tsn_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","E rile fa Pilatwe a bona gore ga a kgone, le gore pheretlhego e a tsoga, a kopa mogopo wa metsi a tlhapa diatla tsa gagwe fa pele ga bontsi jwa batho a re, “Ga ke na molato mo mading a monna yo o siameng yo.” ");
INSERT INTO tsn_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Mme bontsi jwa goa jwa re “Madi a gagwe a a nne mo ditlhogong tsa rona le bana ba rona!” ");
INSERT INTO tsn_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hong Pilatwe a ba gololela Barabase. Mme e rile a sena go kgwathisa Jesu, a mo neela masole a Roma go ya go mmapola. ");
INSERT INTO tsn_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mme masole a mo tseela kwa tlung ya ditlhabano, mephato yotlhe ya mo phuthaganela. ");
INSERT INTO tsn_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Hong ba mo apola, ba mo apesa kobo e khibidu, ");
INSERT INTO tsn_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","mme ba mo logela serwalo ka mitlwa e meleele ba se mo rwesa, ba mo naya thobane mo lebogong le legolo e e emetseng thobane ya Segosi mme ba khubama fa pele ga gagwe ka tshotlo ba goa ba re, “Dumela Kgosi ya Bajuda.” ");
INSERT INTO tsn_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Mme ba mo kgwela mathe, ba tsaya thobane ba mo itaya ka yone mo tlhogong. ");
INSERT INTO tsn_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Morago ga tshotlo, ba mo apola kobo ba mo apesa seaparo sa gagwe gape, ba mo isa kwa ntle go ya go mmapola. ");
INSERT INTO tsn_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ya re ba le mo tseleng e e yang kwa go bolaelwang teng, ba bona monna yo o tswang Sirene mo Aferika, yo o neng a bidiwa Simone, ba mo pateletsa go tsaya mokgoro wa ga Jesu. ");
INSERT INTO tsn_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Hong ba ya felong fa go bidiwang Gologotha, ke gore “Felo ga Logata,” ");
INSERT INTO tsn_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","kwa masole a neng a mo neela mofine o o tlhakantsweng le santlhokwe, mme ya re a sena go o lekeletsa ka legano a o gana. ");
INSERT INTO tsn_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Morago ga papolo, masole a kgaogana diaparo tsa gagwe ka go di thelela bola (mataise). ");
INSERT INTO tsn_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Hong ba nna ba mo lebeletse mo mokgorong. ");
INSERT INTO tsn_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mme ba baya sesupo fa godimo ga tlhogo ya gagwe se balega se re, “Yo ke Jesu Kgosi ya Bajuda.” ");
INSERT INTO tsn_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Dinokwane di le pedi le tsone di ne tsa bapolwa mo mosong oo di mo tsentse fa gare. ");
INSERT INTO tsn_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Mme bafeti ka tsela ba mo kgala, ba tshikinya ditlhogo tsa bone ba re, “O ka senya Tempele wa e aga gape mo malatsing a mararo, a o ka kgona. Go siame ipholose mo mokgorong fa o le Morwa Modimo!” ");
INSERT INTO tsn_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","43","Mme baperesiti ba bagolo le baeteledipele ba Sejuda le bone ba mo kgala ka tshotlo ba re, “O bolokile ba bangwe, mme ga a kgone go ipoloka! Ga ke re o Kgosi ya Baiseraele, a ga go jalo? Jalo he, fologa mo mokgorong ke gone re tlaa go dumelang! O ikantse Modimo, a Modimo o supe gore o eme le ene o mo golole! A ga a are, ‘Ke Morwa Modimo’?” ");
INSERT INTO tsn_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mme dinokwane le tsone tse di neng di bapotswe nae tsa latlhela tshotlo tsa mo gobolola ka mokgwa o o tshwanang. ");
INSERT INTO tsn_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ya re mo go yone tshokologo ya letsatsi leo, lefatshe lotlhe la welwa ke lefifi dioura di le tharo, go simologa motshegare go fitlhelela ka nako ya boraro. ");
INSERT INTO tsn_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","E rile ka nako ya boraro, Jesu a goa a re, “Eli, Eli Lama Sabakathani” ke gore, “Modimo wa me, Modimo wa me, ontatlhetseng?” fa go tlhalosiwa. ");
INSERT INTO tsn_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bangwe ba batho ba ba neng ba le gaufi ba se ka ba mo tlhalogan ya mme ba gopola gore o bitsa Elija. ");
INSERT INTO tsn_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mongwe wa bone a siana a tlatsa ngami mofine o o botsarara, a e tlhomela mo thobaneng a e isa kwa molomong wa gagwe go mo nosa. ");
INSERT INTO tsn_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mme bangwe ba re, “Mo leseng re bone gore a Elija o tlaa tla go mmoloka.” ");
INSERT INTO tsn_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Hong Jesu a goa ka lentswe le legolo gape, a golola mowa wa gagwe, a swa. ");
INSERT INTO tsn_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jalo Sesiro se se farologanyang Felo ga Boitshepo mo Tempeleng sa fatogana go simologa kwa godimo go ya kwa tlase; le lefatshe la tshikinyega, mafika a phatloga, ");
INSERT INTO tsn_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","le mabitla a bulega, mme banna ba ba boifang Modimo ba le bantsi le basadi ba ba neng ba sule ba rula. ");
INSERT INTO tsn_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Morago ga tsogo ya ga Jesu, ba tlogela diphuphu ba ya Jerusalema, mme ba bonala mo bathong ba le bantsi teng. ");
INSERT INTO tsn_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Masole kwa papolong le bagolwane ba one a tshosiwa thata ke thoromo ya lefatshe le gotlhe mo go neng go diragala. Ba bua ba re, “Ammaaruri e ne e le Morwa Modimo.” ");
INSERT INTO tsn_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mme basadi ba le bantsi ba ba neng ba tswa Galalea le Jesu go mo tlhokomela ba ne ba lebeletse ba le kgakala. ");
INSERT INTO tsn_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mo go bone ga bo go le Marea Magatalena le Marea mmaagwe Jakobe le Josefe, le mmaagwe Jakobe le Johane (bomorwa Sebede). ");
INSERT INTO tsn_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","E rile mo maitseboeng, monna mongwe yo o humileng a tswa Arimathea yo o bidiwang Josefe, mongwe wa balatedi ba ga Jesu, ");
INSERT INTO tsn_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","a ya go kopa setopo sa ga Jesu kwa go Pilatwe. Mme Pilatwe a laola gore a se neelwe. ");
INSERT INTO tsn_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josefe a tsaya setopo a se phutha ka letsela la leloba le le phepa, ");
INSERT INTO tsn_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","mme a se baya mo phuphung ya gagwe e e gabilweng mo lefikeng, mme e rile a tsamaya a pitikololela lentswe le le tona fa godimo ga yone go e khurumela. ");
INSERT INTO tsn_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Marea Magatalena le Marea yo mongwe ba bo ba ntse gautshwane ba lebeletse. ");
INSERT INTO tsn_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mme e rile ka letsatsi le le latelang, e le letsatsi la bofelo la mediro ya Iketleetso, ditlhogo tsa baperesiti le Bafarasai ba ya kwa go Pilatwe, ");
INSERT INTO tsn_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","mme ba mo raya ba re, “Morena, moaki yole o kile a re ‘E tlaa re morago ga malatsi a le mararo ke bo ke rula gape’. ");
INSERT INTO tsn_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jalo re kopa taolo mo go wena go kana phuphu go fitlhelela letsatsi la boraro, go itsa barutwa ba gagwe go tla go utswa mmele wa gagwe ba tloga ba raya batho ba re! O tsogile. Fa mo go ka diragala re tlaa nna mo matshwenyegong go gaisa pele.” ");
INSERT INTO tsn_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Mme Pilatwe a ba raya a re, “Dirisang mapodisi a lona a Tempele, ba ka e tlhokomela sentle thata.” ");
INSERT INTO tsn_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jalo ba kanela lentswe le le khurumetseng phuphu ba bo ba ntsha masole go e disa. ");
INSERT INTO tsn_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mme ya re phakela mo mosong wa Tshipi, fa bosigo jwa tshipi boo sa, Marea Magatalena le Maria yo mongwe ba ya kwa phupung. ");
INSERT INTO tsn_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ka tshoganetso ga nna thoromo ya lefatshe e kgolo; gonne moengele wa Morena o na a fologa kwa legodimong mme a pitikololela lentswe fa thoko ga phupu mme a nna mo godimo ga lone. ");
INSERT INTO tsn_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sefatlhogo sa gagwe sa bo se phatsima jaaka logadima, le diaparo tsa gagwe tsa bo di le bosweu jo bo fatlhang. ");
INSERT INTO tsn_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Balebeledi ba roromisiwa ke letshogo fa ba mmona, mme ba idibala mo o neng o ka re ba sule. ");
INSERT INTO tsn_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mme moengele a bua le basadi a re, “Se boifeng!” Ke itse gore lo batla Jesu yo o neng a bapotswe, ");
INSERT INTO tsn_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","mme ga a yo fano! Gonne o rudile fela jaaka a boletse. Tsenang lo bone fa mmele wa gagwe o neng o namaletse gone. ");
INSERT INTO tsn_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mme jaanong, itlhaganeleng lo ye go itsise barutwa ba gagwe gore o tsogile mo baswing le gore o ya kwa Galalea go rakana nabo teng. Ke one molaetsa wa me o ke o lo nayang. ");
INSERT INTO tsn_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Basadi ba akofa ba tloga fa phupung ba tshogile gape ba itumetse thata, mme ba itlhaganelela go batla barutwa go ba bolelela molaetsa wa moengele. ");
INSERT INTO tsn_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mme ya re ba santse ba siane, ka tshoganetso Jesu a ba kgatlhantsha! A re, “Dumelang!”. Ba wela fa fatshe fa pele ga gagwe ba mo tshwara dinao ba mo obamela. ");
INSERT INTO tsn_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Mme Jesu a ba raya a re, “Se boifeng! Yang go raya bana ba ga Rre lo re ba itlhaganelele kwa Galalea go nkgatlhantsha teng.” ");
INSERT INTO tsn_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ya re basadi ba santse ba le mo tseleng e e yang motseng, bangwe ba mapodisi a Tempele ba ba neng ba disitse phupu ba ya kwa baperesiting ba bagolo go ba bolelela se se diragetseng. ");
INSERT INTO tsn_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Phuthego ya baeteledipele botlhe ba Sejuda ya kuiwa, ga dumalanwa gore mapodisi a rekwe ka madi gore ba re erile ba robetse barutwa ba ga Jesu ba tla bosigo mme ba utswa mmele wa gagwe. ");
INSERT INTO tsn_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mme phuthego ya ba solofetsa ya re, “Fa molaodi a ka utlwa ka ga kgang e, re tlaa lo sireletsa mme sengwe le sengwe se tlaa siama.” ");
INSERT INTO tsn_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jalo mapodisi a dumalana go rekwa ka madi, mme ba bua se ba neng ba se rutilwe. Polelo ya bone ya anama mo Bajudeng, le gompieno e sa ntse e dumelwa. ");
INSERT INTO tsn_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mme barutwa ba ba lesome le motso ba ya Galalea, ba ya thabeng e Jesu a neng a rile ba tlaa mo fitlhela teng. ");
INSERT INTO tsn_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mme koo ba feta ba rakana nae mme ba mo obamela; mme bangwe ba bone ba bo ba sa tlhomamise gore a ke ene Jesu tota! ");
INSERT INTO tsn_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","A raya barutwa ba gagwe a re, “Ke neilwe taolo yotlhe kwa Legodimong le mo lefatshing. ");
INSERT INTO tsn_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ke gone tsamayang mme lo dire barutwa mo merafeng yotlhe, lo ba kolobetse mo ineng la ga Rara le la Morwa le la Mowa o o Boitshepo. ");
INSERT INTO tsn_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mme ke gone lo rute barutwa ba basha ba go tshegetsa ditaolo tsotlhe tse ke di lo neileng; mme lo tlhomamise Gore ke na le lona ka malatsi otlhe le go ya bokhutlong jwa lefatshe.”");
INSERT INTO tsn_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","E ke tshimologo ya polelo e ntle ya ga Jesu Mesia, Morwa Modimo. ");
INSERT INTO tsn_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Mo bukeng e e kwadilweng ke moporofiti Isaia, Modimo o ile wa anamisa gore o tla romela morwaa one, mo lefatsheng, pele ga moo go tlaa tla morongwa yo o faphegileng go tla go baakanyetsa lefatshe go tla ga gagwe. ");
INSERT INTO tsn_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Mme morongwa yo o tlaa nna kwa ntle mo sekakeng se se senang sepe,” Isaia o bua jaana a re, “O tlaa anamisa gore mongwe le mongwe o tshwanetse go ipaakanyetsa go tla ga Morena.” ");
INSERT INTO tsn_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Morongwa yo e ne e le Johane wa Mokolobetsi. O ne a nna mo sekakeng a ruta botlhe gore ba tshwanetse go kolobediwa e le molaetsa mo go botlhe gore ba sokologe mo dibeng tsa bone, gore Modimo o tle o ba itshwarele. ");
INSERT INTO tsn_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Batho botlhe ba kwa Jerusalema le botlhe ba Judea ba ne ba tswela mo mafatsheng a Judea go tla go bona le go utlwa Johane, mme e re fa ba sena go ipolela dibe a ba kolobetse mo nokeng ya Jorodane. ");
INSERT INTO tsn_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Diaparo tsa gagwe di ne di logilwe ka boboa jwa kamela mme o ne a itlamile ka moitlamo wa letlalo mo lothekeng; tsie le dinotshe tsa naga e ne e le dijo tsa gagwe. ");
INSERT INTO tsn_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Sekai sa thero ya gagwe ke se; “Mongwe o etla ka bonako yo o leng mogolo mo go nna, yo o leng mogolo thata go mpheta yo ruri ke sa tshwanelang go ka nna motlhanka wa gagwe. ");
INSERT INTO tsn_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nna ke lo kolobetsa ka metsi mme ene o tla lo kolobetsa ka Mowa o o Boitshepo!” ");
INSERT INTO tsn_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Erile letsatsi lengwe Jesu a tswa kwa Nasaretha wa Galalea, a kolobediwa ke Johane teng mo nokeng ya Jorodane. ");
INSERT INTO tsn_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mme erile ka bonako fa Jesu a tswa mo metsing, a bona magodimo a bulega le Mowa o o Boitshepo o le mo setshwanong sa lephoi o fologela mo go ene. ");
INSERT INTO tsn_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Mme lentswe la tswa kwa legodimong la re, “O Morwaake yo o rategang; o boitumelo jwa me.” ");
INSERT INTO tsn_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","13","Ka bofefo Mowa o o Boitshepo wa gogela Jesu kwa nageng. A nna malatsi a le masome a mane, a nna teng mmogo le diphologolo tsa naga. O ne a tsentswe mo ditekong tsa ga Satane gore a leofe. Mme morago ga moo baengele ba tla ba mo direla. ");
INSERT INTO tsn_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Morago ga moo Johane a sena go tshwarwa ke Kgosi Herode, Jesu a ya Galalea a ya go rera Mafoko a a Molemo a Modimo. ");
INSERT INTO tsn_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Mme la bofelo a ba bolelela a re, “Nako e tsile. Bogosi jwa Modimo bo atametse! Sokologang lo tswe mo dibeng, mme lo dire ka fa mafokong a a molemo a.” ");
INSERT INTO tsn_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Letsatsi lengwe fa Jesu a tsamaya fa lotshitshing lwa lewatle la Galalea, a bona Simone le Anterea monnawe ba tshwara ditlhapi ka matloa, gonne e ne e le batshwari ba ditlhapi ba ba di rekisang. ");
INSERT INTO tsn_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesu a ba bitsa a re, “Tlang lo ntshale morago! Mme ke tla lo dira batshwari ba mewa ya batho!” ");
INSERT INTO tsn_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ka bofefo ba tlogela matloa a bone ba tsamaya nae. ");
INSERT INTO tsn_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mme kgakajana fa lotshitshing lwa lewatle, a bona bomorwa Sebede, Jakobe le Johane, ba le mo mokorong ba baakanya matloa a bone. ");
INSERT INTO tsn_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Le bone a ba bitsa, ka bofefo ba tlogela rraabo Sebede le badiri ba bangwe mo mokorong ba mo sala morago. ");
INSERT INTO tsn_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mme Jesu le bapati ba gagwe ba fitlha mo motseng wa Kaperanama ka letsatsi la Sabata mo mosong mme ba tsena fa felong ga kobamelo ya Sejuta fa go bidiwang Senagoge (Tempele) kwa o neng a ruta gone. ");
INSERT INTO tsn_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Hong phuthego ya gakgamala thata go utlwa thero ya gagwe gonne o ne a ruta se se builweng ke ba bangwe gona le kafa ba tlwaetseng go utlwa ka teng. ");
INSERT INTO tsn_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mme ga bo go le monna mongwe yo o tsenweng ke mewa e e maswe, mme a simolola go goa; a re, ");
INSERT INTO tsn_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ke ka ntlha yang fa o re tshwenya, Jesu wa Nasaretha a o tsile go re nyeletsa rona Mewa e e maswe? Ke a itse fa o le Morwa Modimo o o Boitshepo.” ");
INSERT INTO tsn_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesu a laola moya o o maswe gore o didimale o tswe mo go ene. ");
INSERT INTO tsn_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mme mowa o o maswe wa goa wa mo kgaratlhisa wa tswa mo go ene. ");
INSERT INTO tsn_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Batho ba gakgamala mme ba simolola go bua ka ga se se diragetseng. Ba botsanya ka kakabalo ba re, “Ke mofuta ofe wa tumelo e ncha e? Ke ka ntlha yang, fa le mewa e e maswe e utlwa ditaolo tsa gagwe!” ");
INSERT INTO tsn_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mme dikgang ka ga se o se dirileng tsa akofa tsa utlwala mo lefatsheng lotlhe la Galalea. ");
INSERT INTO tsn_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","30","Mme e rile fa a tswa mo tempeleng, ene le barutwa ba gagwe ba tsena kwa ga bo Simone le Anterea, kwa ba fitlhetseng mogwagwadia Simone wa mosadi a namaletse mo bolaong a lwala bolwetse jwa letshoroma. Mme ya re fela ka bofefo ba bolelela Jesu ka gagwe. ");
INSERT INTO tsn_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","A ya fa thoko ga bolao jwa gagwe, mme a mo kakatlolola gore a nne sentle, ka bofefo letshoroma la mo tlogela, mme a ema a ba baakanyetsa dijo! ");
INSERT INTO tsn_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Mme e rile letsatsi le phirima lolwapa lwa bo lo tletse balwetse le ba ba neng ba tsenwe ke mewa e e maswe, ba lerilwe kwa go ene go fodisiwa; bontsi jwa batho ba ba tswang kwa metseng ya Kaperanama ba kgobokanela kwa ntle ga kgoro go lebelela. ");
INSERT INTO tsn_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Mme Jesu a fodisa ba le bantsi ba ba neng ba lwala mo maitseboeng ao, a ba a laola mewa e e maswe go tswa mo go ba e neng e ba tsenye. (Mme a gana go letla mewa e e maswe go bua gonne e ne e itse gore ke mang). ");
INSERT INTO tsn_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Erile mo mosong o o latelang a phakela thata a tsamaya a le esi go ya go rapela mo nageng. ");
INSERT INTO tsn_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","37","Mme morago ga moo Simone le ba bangwe ba ya go mmatla, ba mo raya ba re, “Mongwe le mongwe o a go batla.” ");
INSERT INTO tsn_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mme a araba a re, “Re tshwanetse go ya le kwa metseng e mengwe, gore le bone ke ba neele molaetsa wame, gonne ke lone lebaka le ke le tletseng.” ");
INSERT INTO tsn_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mme a tsamaya le lefatshe lotlhe la Galalea, a rera mo ditempeleng ebile a golola ba le bantsi mo thateng ya Mewa e e maswe. ");
INSERT INTO tsn_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mme ka bofefo ga tla moleperwa a khubama fa pele ga gagwe a kopa gore a fodisiwe. A mo rapela a re, “Fa o rata o ka mphodisa.” ");
INSERT INTO tsn_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Mme Jesu a mo utlwela botlhoko a mo ama a re, “Ke a rata! fola!” ");
INSERT INTO tsn_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ka bofefo leperwa la tloga, monna a fola! ");
INSERT INTO tsn_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Mme Jesu a mo laya thata a re, “Tsamaya o ye go tlhatlhobiwa ka bonako ke moperesiti wa Sejuta. O seka wa ema go bolelela ope mo tseleng. Tsaya neo ya gago ka fa molaong wa ga Moshe wa moleperwa yo o fodisitsweng, gore mongwe le mongwe a tle a nne le bosupi jwa gore o fodile.” ");
INSERT INTO tsn_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Erile fa moleperwa a ntse a tsamaya mo tseleng a simolola go goeletsa mafoko a a molemo a gore o fodile. Mme yare ka ntlha ya moo, bontsi jwa batho jwa dikaganyetsa Jesu gore a ba a retelelwe ke go tsena mo motseng, mme a tshwanelwa ke go nna kwa ntle mo sekakeng. Mme batho ba tswa gongwe le gongwe ba tla kwa go ene. ");
INSERT INTO tsn_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mme erile morago ga malatsi a le mantsi a boela gape kwa Kaperanama, mme kutlwedi ya go tla ga gagwe ya tuma ka bofefo mo motseng otlhe. ");
INSERT INTO tsn_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ka bonako ntlo e o neng a le mo go yone e ne ya tlala baeng thata mo go neng go sena bonno le fa e le jwa motho a le esi, le fa e le kwa kgorong tota. Mme a ba rerela lefoko. ");
INSERT INTO tsn_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mme ya re a sa ntse a rera, banna ba le bane, ba goroga ba tshotse monna yo o suleng mhama a le mo lepareng. ");
INSERT INTO tsn_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mme ba palelwa ke go tsena kwa go Jesu ka ntlha ya bontsi jwa batho, hong ba rutlolola ntlo go lebagana le tlhogo ya gagwe, mme ba folosa molwetsi ka lepara, go lebagana sentle le fa pele ga ga Jesu. ");
INSERT INTO tsn_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Mme erile Jesu a bona kafa ba dumelang thata ka teng gore o tlaa thusa, Jesu a raya monna yo o lwalang a re, “Morwaaka, dibe tsa gago di itshwaretswe!” ");
INSERT INTO tsn_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mme bangwe ba baeteledipele ba Sejuta ba ba neng ba ntse foo ba raana ba re, ");
INSERT INTO tsn_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Gatweng? Se ke tlhapatso! A o gopola gore ke Modimo? Gonne ke Modimo fela o o ka itshwarelang dibe.” ");
INSERT INTO tsn_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mme Jesu ka a ne a itsile ditlhaloganyo tsa bone a ba raya a re, “Ke eng fa se se lo tshwenya? ");
INSERT INTO tsn_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","A go thata go itshwarela dibe tsa gagwe go na le go mo fodisa? ");
INSERT INTO tsn_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Mme jalo ke tlaa lo supegetsa, gore Nna, motho yo o tswang legodimong, ke itshwaretse monna yo dibe.” Hong a retologela kwa monneng yo o suleng mhama a re, “O fodisitswe. Tsaya lepara la gago o ye gae!” ");
INSERT INTO tsn_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mme monna a nanoga, a tsaya lepara a ralala batho ba ba neng ba mo lebeletse! ");
INSERT INTO tsn_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Hong Jesu a ya gape kwa lotshitshing lwa lewatle mme a rerela boidiidi jwa batho jo bo neng bo mo dikaganyeditse. ");
INSERT INTO tsn_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Erile fa Jesu a ntse a tsamaya fa lotshitshing a bona Lefi, morwa Alefo, a ntse fa go kgethisediwang teng. A mo raya a re, “Ntshala morago. O nne morutwa wa me.” Mme Lefi a nanoga a tsamaya nae. ");
INSERT INTO tsn_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mo bosigongjoo, Lefi a laletsa badiri-ka ene ba bakgethisi le baleofi ba bangwe ba ba tumileng go nna balalediwa ba gagwe ka nako ya dijo tsa maitseboa gore ba tle ba kopane le Jesu le barutwa ba gagwe, (go ne go na le batho ba le bantsi ba mofuta o, mo boidiiding jwa batho jo bo neng bo mo setse morago). ");
INSERT INTO tsn_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mme erile fa baeteledipele bangwe ba tumelo ya Sejuta ba mmona a a ja le batho ba ba mekgwa e e maswe, ba raya barutwa ba gagwe ba re, “Ke eng fa a a ja le batho ba ba ntseng jaana?” ");
INSERT INTO tsn_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Erile fa Jesu a utlwa se ba neng ba se bua, a ba raya a re, “Batho ba ba lwalang ke bone ba ba batlang ngaka, e seng ba ba itekanetseng! Ga ke a tla go sokolola basiami fa e se baleofi.” ");
INSERT INTO tsn_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mme barutwa ba ga Johane le baeteledipele ba Sejuta e ne e tle e re ka nako tse dingwe ba ikitse dijo, ke gore, ba tlhoke go ja e le ntlha nngwe ya tumelo ya bone; ya re letsatsi lengwe ba tla kwa go Jesu ba mmotsa gore ke ka ntlha yang fa barutwa ba gagwe le bone ba sa ikitse dijo? ");
INSERT INTO tsn_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Mme Jesu a ba araba a re, “A ditsala tsa monyadi di ka gana go ja mo moletlong wa nyalo, A di ka hutsafala fa a sa ntse a na le tsone? ");
INSERT INTO tsn_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mme letsatsi lengwe o tlaa tlosiwa mo go bone, mme ba tla hutsafala. ");
INSERT INTO tsn_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Mo godimo ga moo, go ikitsa dijo ke mongwe mokgwa wa bogologolo wa go dira dilo. Go tshwana le go bitia seaparo se segologolo ka letsela le lesha! Go ka diragala eng? Sedibo se ka garola mme sa dira gore leroba le nne maswe go gaisa pele. ");
INSERT INTO tsn_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Lo itse botoka gore go tshela mofine o mosha mo dinkgwaneng tse dikgologolo, di ka thubega. Mofine o ka tshologela kwa ntle mme dinkgwana di senyege. Mofine o mosha o tlhoka dinkgwana tse dintsha.” ");
INSERT INTO tsn_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ka nako nngwe go le Sabata Jesu le barutwa ba gagwe ba tsamaya mo masimong, barutwa ba ne ba roba diako tsa mabele ba a ja. ");
INSERT INTO tsn_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Bangwe ba baeteledipele ba tumelo ya Sejuta ba raya Jesu ba re, “Ga ba a tshwanela ba ka bo ba dira jalo! Go kgatlhanong le melao ya rona go roba mabele ka letsatsi la Sabata.” ");
INSERT INTO tsn_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Jesu a araba a re, “A ga lo ise lo ke lo utlwalele kaga Kgosi Dafide le bapati ba gagwe, ba ba neng ba tshwerwe ke tlala, mme a tsena mo tlung ya Modimo Abiathare e ne e le Moperesiti yo Mogolo ka nako eo--mme ba a ja senkgwe se se faphegileng se se neng se jewa ke baperesiti fela? Seo le sone se ne se le kgatlhanong le molao. ");
INSERT INTO tsn_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Mme Sabata e ne e diretswe go solegela motho molemo, e seng motho go solegela Sabata molemo. ");
INSERT INTO tsn_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mme Nna, Mesia, ke na le nonofo ya go dira tshwetso ya se batho ba ka se dirang ka malatsi a Sabata!” ");
INSERT INTO tsn_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Erile Jesu a sa ntse a le mo Kaperanama a ya kwa Tempeleng gape, mme a bona teng monna yo o neng a omeletse letsogo. ");
INSERT INTO tsn_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ka e ne e le letsatsi la Sabata, baba ba ga Jesu ba mo tlhoma matlho thata gore a o tlaa fodisa letsogo la monna yo? Fa a ne a ka dira jalo, ba ne ba ikaeletse go mo tshwara! ");
INSERT INTO tsn_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Hong Jesu a raya monna a re a tle go ema fa pele ga phuthego. ");
INSERT INTO tsn_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mme a retologela kwa babeng ba gagwe a ba botsa a re, “A go siame go dira ditiro tse di molemo ka malatsi a Sabata? Kgotsa a ke letsatsi la go utlwisa botlhoko? A ke letsatsi la go boloka matshelo kgotsa go a senya?” Mme ga ba ise ba ke ba mo arabe. ");
INSERT INTO tsn_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Erile a ba leba ka kgalefo gonne o ne a tshwentswe ke go tlhoka kelotlhoko ga bone mo ditlhokong tsa batho, a raya monna a re, “Otlolola letsogo la gago.” A le otlolola mme ka bofefo letsogo la gagwe la fola. ");
INSERT INTO tsn_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mme e rile fela ka yone nako eo Bafarasai ba tsamaya ba ya go kopana le Baherodia ba loga maano a go mmolaya. ");
INSERT INTO tsn_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Erile ka lobakanyana, Jesu, le barutwa ba gagwe ba ya kwa lotshitshing lwa lewatle, ba setswe morago ke bontsintsi jwa batho go tswa mo tikologong yotlhe ya Galalea, Judea Jerusalema, Idumea le kwa moseja ga Noka ya Jorodane, le go tswa bokgakala jo bo kanang ka Ture le Sidona. Gonne dikgang ka ga dikgakgamatso tsa gagwe di ne di utlwetse kwa kgakala le ka bophara mme batho ba le bantsi ba tla go iponela ka matlho. ");
INSERT INTO tsn_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Mme a laela barutwa ba gagwe go tlisa mokoro le go o baakanyetsa gore o tle o mo namole fa a ka pitlaganyediwa ke batho mo lotshitshing. ");
INSERT INTO tsn_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Gonne go ne ga diragala diphodiso di le dintsi ka letsatsi leo, mme ya re ka ntlha ya moo balwetse ba le bantsi ba mo dikaganyetsa, ba leka go mo ama. ");
INSERT INTO tsn_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","E ne e tle e re ka dinako tsotlhe fa ba ba tsenweng ke mewa e e maswe ba mmona ba wele fa fatshe fa pele ga gagwe ba goele kwa godimo ba re, “O Morwa Modimo!” ");
INSERT INTO tsn_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mme a ba laya thata gore ba seka ba mo utlwatsa. ");
INSERT INTO tsn_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Erile morago ga moo a tlhatlogela kwa godimo ga dithaba mme a bitsa bangwe ba ene o ba tlhophileng, a ba laletsa go tsamaya nae; mme ba dira jalo. ");
INSERT INTO tsn_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Hong a tlhopha ba le lesome le bobedi mo go bone go nna bapati ba gagwe ba malatsi otlhe le go tswela kwa ntle nae go ya go rera le go kgoromeletsa mewa e e maswe kwa ntle. ");
INSERT INTO tsn_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","A ke maina a ba ba lesome le bobedi ba o ba tlhophileng: Simone (yo o neng a mmitsa Petere) Jakobe le Johane (bomorwa Sebede, Jesu a ba bitsa barwa Tumo ya Maru). Anterea, Filipo, Baretholomea, Mathaio, Thomase, Jakobe, (Morwa Alefaio) Thadaeo, Simone (yo o neng e le wa leloko la lekgotla la dipolotiki le le neng le ikemiseditse go menola puso ya Roma.) Judase Isekariota, (yo e leng ene yo o mo okileng). ");
INSERT INTO tsn_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mme e rile a boela kwa ntlung e o neng a nna mo go yone, boidiidi jwa batho jwa simolola go phuthega gape, mme ya re ka bofefo ntlo ya tlala baeng ba le bantsi mo o neng a tlhoka le yone nako ya go ja. ");
INSERT INTO tsn_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Erile fa ditsala tsa gagwe di utlwa se se neng se diragala tsa tla go leka go mo tsaya tsa mo isa kwa di nnang teng. “Tsa re, O tlhakanye tlhogo.” ");
INSERT INTO tsn_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mme baruti ba tumelo ya Sejuta ba ba neng ba tsile ba tswa Jerusalema ba re, “Molato wa gagwe ke gore o tsenwe ke Satane kgosi ya Mewa e e maswe. Ke ka moo mewa e e maswe e mo reetsang.” ");
INSERT INTO tsn_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hong Jesu a bitsa banna ba, mme a ba botsa (A dirisa diane tse botlhe ba neng ba di tlhaloganya), a re, “Satane o ka kgoromeletsa Satane ntle jang? ");
INSERT INTO tsn_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Bogosi jo bo ikgaogantseng ka bo jone bo tlaa swa. ");
INSERT INTO tsn_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Lolwapa lo lo tletseng dikgogakgogano le dikgaogano lo inyeletsa ka bo lone. ");
INSERT INTO tsn_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mme fa Satane a itwantsha, o ka dira eng? Ga a kitla a ema. ");
INSERT INTO tsn_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Satane o tshwanetse go golegwa pele ga mewa e e maswe e kgoromelediwa ntle. Fela jaaka monna yo o nonofileng a tshwanetse go golegwa pele ga ntlo ya gagwe e ka thujwa a ba a gapelwa dilwana. ");
INSERT INTO tsn_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Mme ke lo tlhomamisetsa gore boleo bongwe le bongwe jwa motho bo ka itshwarelwa, le e leng go ntlhapatsa tota. ");
INSERT INTO tsn_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mme go tlhapatsa Mowa o o Boitshepo ga go kake ga itshwarelwa, ke sebe sa bosakhutleng.” ");
INSERT INTO tsn_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","O ne a ba raya jalo ka ntlha ya gore ba ne ba re o dira dikgakgamatso ka nonofo ya ga Satane. (Mo boemong jwa gore ba dumele gore e ne e le ka nonofo ya Mowa o o Boitshepo). ");
INSERT INTO tsn_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Hong mmaagwe le bomonnawe ba tla mo ntlung e bontsi jwa batho bo neng bo kgobokanetse mo go yone, fa a neng a rutela teng, ba romela mongwe gore a ba mmiletse. Ba mo raya ba re, “Mmago le bomonnao ba kwa ntle ba batla go go bona.” ");
INSERT INTO tsn_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Hong Jesu a araba a re, “Mme ke mang? Bonnake ke bo mang?” ");
INSERT INTO tsn_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","A leba ba ba mo dikologileng a re, “Mme le bonnake ke ba! ");
INSERT INTO tsn_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mongwe le mongwe yo o dirang go rata ga Modimo ke nnake, ke kgaitsadiake, ke mme.” ");
INSERT INTO tsn_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mme boidiidi jwa batho jo bo senang palo jwa mo dikaganyetsa mo lotshitshing fa a ntse a ruta, hong a tsena mo mokorong a nna fa fatshe a bua a le mo teng ga one. ");
INSERT INTO tsn_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mokgwa wa gagwe wa gale wa go ruta e ne e le go bolelela batho dipolelo. Nngwe ya tsone e tsamaile jaana: ");
INSERT INTO tsn_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Reetsang! Molemi o kile a ikaelela go jala peo. Mme ya re a e gasa mo tshimong ya gagwe, ");
INSERT INTO tsn_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","nngwe ya yone ya wela mo tseleng, mme dinonyane tsa tla tsa e sela tsa e e ja. ");
INSERT INTO tsn_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Nngwe ya yone ya wela mo mmung o mosesane fa go neng go ikadile lefika teng. Ya gola ka bonako, mme ya akofa ya swabisiwa ke mogote wa letsatsi ya a swa, ka ntlha ya gore medi ya yone e ne e sa otlega sentle mo mmung o o seng boteng. ");
INSERT INTO tsn_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tse dingwe dipeo tsa wela mo mitlweng, mme mitlwa ya gola ya hupetsa dijalo tse di potlana, jalo tsa se ka tsa ungwa, ");
INSERT INTO tsn_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","“Mme tse dingwe tsa wela mo mmung o o molemo, tsa ungwa ga masome a mararo tsa ata go fetisa jaaka a ne a jetse, dingwe tsa tsone tsa ungwa ga masome a marataro kgotsa lekgolo. ");
INSERT INTO tsn_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Fa lo na le ditsebe, reetsang!” ");
INSERT INTO tsn_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mme morago ga moo fa a le esi le ba ba lesome le bobedi le bangwe ba barutwa ba gagwe, ba mmotsa ba re, “Polelo ya gago e raya eng?” ");
INSERT INTO tsn_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Mme a ba araba a re, “Lo letleletswe go itse boammaaruri ka ga Bogosi jwa Modimo jo bo fitlhetsweng ba ba kwa ntle ga Bogosi: jaaka Moporofiti Isaia a bolela a re, ‘Le fa ba bona ebile ba utlwa ga ba kitla ba tlhaloganya, kgotsa ba sokologela mo Modimong kgotsa ba itshwarelwa dibe tsa bone.’ ");
INSERT INTO tsn_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","“Mme fa lo se ka ke lwa tlhaloganya setshwantsho se se motlhofo se, lo tlaa dira jang kaga tse dingwe tse ke yang go di bolela. ");
INSERT INTO tsn_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Molemi yo ke neng ke bua ka ga gagwe ke mongwe yo o lereditseng batho molaetsa wa Modimo, a leka go jala peo e e siameng mo matshelong a bone. ");
INSERT INTO tsn_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tsela e e thata, fa go wetseng peo nngwe teng e tshwantshiwa le bopelo-e-thata jwa batho bangwe ba ba utlwang lefoko la Modimo; mme e re ka bofefo Satane a tle a leke go ba lebatsa lefoko. ");
INSERT INTO tsn_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mme mmu o o lokgwarapana o tshwantshiwa le dipelo tsa batho ba ba utlwang molaetsa ka boitumelo, ");
INSERT INTO tsn_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","mme jaaka ditlhatshana tse di mo mmung o o ntseng jalo, medi ya tsone ga e tsenelele mo teng, le fa, lwa ntlha di gola sentle, ere ka bonako fa matshwenyego a simologa di korobele. ");
INSERT INTO tsn_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Mmu o o mitlwa ke sesupo sa dipelo tsa batho ba ba reetsang Mafoko a a Molemo ba bo ba a amogela, ");
INSERT INTO tsn_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mme ka bofefo dithato tsa lefatshe le menate ya mahumo le go batla go tswelela pele le go eletsa dilo tse dintle go tsene ka bofefo mme go kgoreletse molaetsa wa Modimo mo dipelong tsa bone mme go seke go nne loungo lope. ");
INSERT INTO tsn_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Mme mmu o o molemo o tshwantshiwa le dipelo tsa batho ba ba amogelang molaetsa wa Modimo ka boammaaruri, mme ba ungwele Modimo thobo e ntsi thata, ba ungwe ga masome a mararo le ga masome a le marataro le ga lekgolo tota go gaisa jaaka go jetswe mo dipelong tsa bone.” ");
INSERT INTO tsn_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Hong a ba botsa a re, “Fa mongwe a tshuba lobone, a o lo baya ka fa tlase ga tafole gore lo fitlhe lesedi? Go ka se nne jalo! Lesedi ga le ka ke la bonwa kgotsa la dirisiwa. Lobone lo siametse go bewa mo setlhomong go bonesa le go nna le mosola. ");
INSERT INTO tsn_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Gonne sengwe le sengwe se se fitlhegileng letsatsi lengwe se tlaa nna mo leseding. ");
INSERT INTO tsn_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Fa lo na le ditsebe, reetsang! ");
INSERT INTO tsn_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mme gape tlhomamisang lo dirise se lo se utlwang. Gantsi fa lo dira jalo, lo tlaa kgona go tlhaloganya thata se ke se lo bolelelang. ");
INSERT INTO tsn_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mme yo o nang le sengwe o tlaa newa; mme yo o senang sepe o tlaa tseelwa le se o nang le sone tota. ");
INSERT INTO tsn_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Setshwantsho sengwe ke se, se se supang gore bogosi jwa Modimo bo ntse jang: Molemi o kile a jala peo mo tshimong ya gagwe, ");
INSERT INTO tsn_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","mme a tsamaya, ya re malatsi a ntse a feta, dijalo tsa gola kwa ntle ga tlhokomelo ya gagwe. ");
INSERT INTO tsn_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Gonne mmu o ne o godisa dijalo. La ntlha mogwang wa tswa, diako tsa tlhoga, mme morago mabele a butswa. ");
INSERT INTO tsn_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Hong molemi a tla ka thipa ya gagwe a akofa a roba.” ");
INSERT INTO tsn_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Mme Jesu a ba botsa a re, “Ke ka tshwantsha Bogosi jwa Modimo jang? Ke ka dirisa polelo efe go bo tshwantsha? ");
INSERT INTO tsn_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Bo tshwana le peo ya mosetara! Le ntswa e le nngwe ya dipeo tse di potlana, e gola e nna nngwe ya ditlhare tse di tona thata, e nne le dikala tse di telele mo dinonyane di ka agang dintlhaga tsa tsone teng mme tsa sireletsega.” ");
INSERT INTO tsn_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","O ne a dirisa ditshwantsho di le dintsi tse di ntseng jalo go ruta batho ka fa ba ka kgonang go tlhaloganya ka teng. ");
INSERT INTO tsn_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Legale, o ne a ruta fela ka ditshwantsho fa a ruta mo pepeneneng, mme e re morago ga moo, fa a le esi le barutwa ba gagwe a simolole go ba di tlhalosetsa. ");
INSERT INTO tsn_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mme ya re mo maitseboeng, Jesu a raya barutwa ba gagwe a re, “A re tsheleleng ka kwa ntlheng e nngwe ya lecha.” ");
INSERT INTO tsn_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Hong ba mo tsaya, ba tswelela, ba tlogela bontsi jwa batho (le fa mekoro e mengwe e ne ya ba sala morago). ");
INSERT INTO tsn_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mme ya re ka bonako matsubutsubu a magolo a phefo a tsoga. Makhubu a metse a simolola go tlolela mo mokorong go fitlhelela metse a tlala mo mokorong ebile o tloga o nwela. ");
INSERT INTO tsn_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesu o ne a robetse kwa motsheo ga mokoro a samile mosamo. Mme ka bonako ba mo tsosa ka letshogo le legolo ba re, “Moruti, a ga o tshwenyege le fa re tloga re nwela rotlhe?” ");
INSERT INTO tsn_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Hong a kgalemela phefo a raya lewatle a re, “Didimala!” Mme phefo ya didimala, ga ba ga nna tuulalo e kgolo! ");
INSERT INTO tsn_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mme a ba botsa a re, “Lo ne lo tshositswe ke eng? A le jaana ga lo ise lo bo lo inkanye?” ");
INSERT INTO tsn_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mme ba tlala poifo thata ba ipotsa ba re, “Monna yo ke mang, yo diphefo le mawatle di mo utlwang?” ");
INSERT INTO tsn_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","2","Mme erile fa ba goroga ka kwa ntlheng e nngwe ya lecha monna mongwe yo o tsenyweng ke mewa e e maswe a betsega mo diphupung, fa Jesu a fologa mo mokorong. ");
INSERT INTO tsn_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Monna yo o ne a nna mo diphupung, a nonofile mo e leng gore le fa a ne a golegilwe jaaka a ne a tle a dirwe o ne a tle a kgaole dikeetane mo mabogong a gagwe a tsamae. Go ne go se ope yo o mo kgonang. ");
INSERT INTO tsn_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Motshegare otlhe le mo bosigong o ne a lala a tsamaya mo diphupung le mo dithabeng, a goa a itshegaka ka maje a a bogale. ");
INSERT INTO tsn_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mme e rile Jesu a sa le kgakala kwa ntle mo metsing, monna yo a bo a setse a mmone, a taboga a mo kgatlhantsha, a ba a wela fa pele ga gagwe. ");
INSERT INTO tsn_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Hong Jesu a bua le mowa o o maswe o o neng o le mo monneng yo, a re, “Tswa, wena mowa o o maswe.” Mme wa goela kwa godimo wa re, “O ya go dirang ka nna, Jesu Morwa Modimo Mogodimodimo? Ke go ikanisa ka Modimo, o se ka wa ntlhokofatsa.” ");
INSERT INTO tsn_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mme Jesu a botsa moya o o maswe a re, “Leina la gago ke mang?” moya o o maswe wa re, “Mophato, gonne re bantsi thata mo mothong yo.” ");
INSERT INTO tsn_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Hong mewa e e maswe ya mo rapela gangwe le gape gore a se ka a e romela kwa lefatshing le le kgakala. ");
INSERT INTO tsn_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mme ga bo go le serapa sa dikolobe se hula fa mhapheng wa thaba ntlheng ya lecha. ");
INSERT INTO tsn_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","“Mewa e e maswe ya mo rapela ya re, re romele mo serapeng sele sa dikolobe.” ");
INSERT INTO tsn_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Mme Jesu a e letla. Hong mewa e e maswe ya tswa mo monneng ya tsena mo dikolobeng, mme serapa sotlhe sa kgokologa mo mhapheng wa thaba sa thabuela mo lecheng sa betwa ke metse. ");
INSERT INTO tsn_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mme badisa ba siela mo metseng e e gaufi le mo tikologong ya lefatshe leo ba anamisa dikgang fa ba ntse ba taboga mme mongwe le mongwe a ya go iponela. ");
INSERT INTO tsn_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mme batho ba le bantsi ba tloga ba kokoanela fa Jesu a neng a le teng. Ya re ba bona monna yoo a ntse fa fatshe, a apere e bile a ikutlwa sentle, ba tshoga thata. ");
INSERT INTO tsn_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bao botlhe ba ba neng ba bona se se diragetseng ba bolelela mongwe le mongwe ka ga sone. ");
INSERT INTO tsn_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mme bontsi jwa batho jwa simolola go rapela Jesu gore a tsamae a ba tlogele! ");
INSERT INTO tsn_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jalo a boela mo mokorong. Mme monna yo o neng a tsenwe ke mewa e e maswe a kopa Jesu gore a mo letle a tsamae nae. ");
INSERT INTO tsn_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mme Jesu a gana a mo raya a re, “Ya gae kwa ditsaleng tsa gago, o ba bolelele dilo tse dintle tse Modimo o di go diretseng; le ka fa o ileng wa nna le kutlwelo botlhoko ka teng.” ");
INSERT INTO tsn_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Hong monna a simolola go etela metse e le some mo tikologong eo a bolelela mongwe le mongwe ka ga dilo tse dikgolo tse Jesu o di mo diretseng; mme ba gakgamadiwa thata ke se o neng a se bolela. ");
INSERT INTO tsn_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mme e rile fa Jesu a sena go kgabaganyetsa ka kwa ntlhenge nngwe ya lecha ka mokoro, batho ba le bantsi ba phuthaganela kwa go ene fa lotshitshing. ");
INSERT INTO tsn_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mme moeteledipele wa tempele, yo o neng a bidiwa Jairo, a tla a wela fa pele ga gagwe, ");
INSERT INTO tsn_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","a mo rapela gore a fodise morwadie. A bua ka tlhwaafalo e kgolo a re, “O gaufi le go swa. Tswee-tswee tla o mmee diatla gore a tshele.” ");
INSERT INTO tsn_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Hong Jesu a tsamaya nae, mme bontsi jwa batho jwa mo sala morago. ");
INSERT INTO tsn_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mo bontsintsing joo go ne go na le mosadi yo o saleng a lwala tshologo ya madi dingwaga di le lesome le bobedi. ");
INSERT INTO tsn_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mme o ne a sa bolo go tshwenyega thata mo dingakeng di le dintsi ka dingwaga e bile a humanegisitswe ke go di duela, mme go ne go sa tokafale ka gope, go ntse go tswelela pele. ");
INSERT INTO tsn_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mme o ne a setse a utlwile dikgakgamatso tse Jesu o di dirileng, ke gone ka moo o ileng a tla kafa morago ga gagwe mo bontsintsing jwa batho a ama diaparo tsa gagwe. ");
INSERT INTO tsn_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Gonne o ne a gopotse ka boene gore, “Fa ke ka ama diaparo tsa gagwe, ke tlaa fola.” ");
INSERT INTO tsn_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mme ka boammaaruri, erile fela fa a sena go mo ama, go tshologa ga madi ga khutla, mme a itse gore o fodile. ");
INSERT INTO tsn_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Hong Jesu a lemoga ka bonako gore nonofo ya phodiso e dule mo go ene, a retologela kwa bontsintsing jwa batho a ba botsa a re, “Ke mang yo o amileng diaparo tsa me?” ");
INSERT INTO tsn_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Barutwa ba mo raya ba re, “Bontsintsi jwa batho bo go pitlaganyeditse, mme o botsa gore ke mang yo o go amileng.” ");
INSERT INTO tsn_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mme a bo a ntse a batlisisa go bona gore ke mang yo o dirileng selo seo. ");
INSERT INTO tsn_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Hong mosadi yo o tshogileng, a roromisiwa ke letshogo ka se se mo diragaletseng, a tla a wela fa dinaung tsa gagwe a mmolelela se a se dirileng. ");
INSERT INTO tsn_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Mme Jesu a mo raya a re, “Morwadiaka, tumelo ya gago e go fodisitse; tsamaya ka kagiso, o fodile mo bolwetsing jwa gago.” ");
INSERT INTO tsn_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Erile fa a sa ntse a bua le ene, barongwa ba goroga ba tswa kwa legaeng la ga Jairo, ka mafoko a a reng morwadio o sule, jalo ga go tlhole go tlhokega gore Jesu a tle. ");
INSERT INTO tsn_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mme Jesu a tlhokomologa puo ya bone a raya Jairo a re, “Se boife! Ikanye nna.” ");
INSERT INTO tsn_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Hong Jesu a kganela bontsintsi jwa batho, mme a se ka a letla ope go tsena nae mo legaeng la ga Jairo, fa e se Petere le Jakobe le Johane. ");
INSERT INTO tsn_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mme erile fa ba goroga, Jesu a bona gore dilo tsotlhe di tlhakatlhakanye, go le selelo se segolo le kuruetso. ");
INSERT INTO tsn_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","A tsena mo teng a bua le batho, a ba botsa gore, “Ke ka ntlha yang fa go le selelo se se kanakana? Ngwana ga a swa o robetse fela!” ");
INSERT INTO tsn_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ba mo tshega ka tshotlo, mme a ba ntshetsa kwa ntle botlhe, a tsaya rraa-ngwana le mma-ngwana le barutwa ba gagwe ba le bararo, a tsena mo ntlung e ngwana o neng a beilwe mo go yone. ");
INSERT INTO tsn_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","42","A mo tshwara ka seatla a mo raya a re, “Tsoga mosetsana!” (O ne a na le dingwaga di le lesome le bobedi). Mme a nanoga a tsamaya! Batsadi ba gagwe ba gakgamala thata. ");
INSERT INTO tsn_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesu a ba laela ka tlhoafalo gore ba se ka ba bolelela ope se se diragetseng, mme a ba raya a re ba nee ngwana sengwe a je. ");
INSERT INTO tsn_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Mme ka bofefo morago ga moo a tloga mo kgaolong eo a boela le barutwa ba gagwe ba ya Nasaretha, motse wa ga gabo. ");
INSERT INTO tsn_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Mme ka Sabata se se latelang a ya kwa Tempeleng go ya go ruta, mme batho ba gakgamalela botlhale jwa gagwe le dikgakgamatso tsa gagwe ka ntlha ya gore e ne e le motho fela yo o tshwanang le bone. Mme ba bua ba tenegile ba re, “Ga a botoka go na le rona. Ke mmetli fela, morwa Marea, mogoloa Jakobe le Josefe, Judase le Simone. Le bokgaitsadie re agile nabo.” ");
INSERT INTO tsn_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Hong Jesu a ba raya a re, “Moporofiti o tlotlwa gongwe le gongwe fela fa e se mo ga gabo le mo losikeng lwa gagwe le mo go ba ntlo ya gagwe.” ");
INSERT INTO tsn_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mme ka ntlha ya go tlhoka go dumela ga bone a se ka a kgona go dira dikgakgamatso tse di tona mo go bone, fa e se fela go baya diatla mo baboboding ba se kae, a ba fodisa. ");
INSERT INTO tsn_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mme a gakgamalela go tlhoka tumelo ga bone. Hong a tswa a tsamaya mo metseng, a ruta. ");
INSERT INTO tsn_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","A bitsa barutwa ba gagwe ba ba lesome le bobedi a ba roma ka bobedi le bobedi, a ba neetse nonofo ya go kgoromeletsa ntle mewa e e maswe. ");
INSERT INTO tsn_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","A ba raya a re, ba se ka ba tsaya sepe fa e se dithobane tse ba tsamayang ka tsone (diikokotlelo) le fa e le dijo, le fa e le kgetsana le fa e le madi, le fa e le ditlhako kgotsa diaparo tse dingwe. ");
INSERT INTO tsn_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","A ba raya a re, “Fa lo tsena mo motsing nnang mo lwapeng lo le longwe, se suteng fa lo leng teng go tsena ntlo le ntlwana fa lo sa ntse lo le mo motsing oo. ");
INSERT INTO tsn_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Fa e le gore ba motse ga ba lo amogele kgotsa ga ba lo reetse itlhotlhoreng lorole mo dinaung tsa lona lo tsamaye; ke sesupo sa gore lo tlogeletse motse oo tshekiso.” ");
INSERT INTO tsn_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Barutwa ba tsamaya, ba bolelela mongwe le mongwe yo ba kopanang nae gore a sokologe mo dibeng. ");
INSERT INTO tsn_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mme ba kgoromeletsa ntle mewa e e maswe e le mentsi ba fodisa babobodi ba le bantsi ba ba tlotsa ka lookwane. ");
INSERT INTO tsn_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mme ka bofefo Kgosi Herode a utlwa kaga Jesu, gonne dikgakgamatso tsa gagwe di ne di buiwa gongwe le gongwe. Kgosi e ne e akanya gore Jesu ke Johane wa Mokolobetsi a boetse mo botshelong. Hong batho ba ne ba re, “Ga go gakgamatse fa a ka dira dikgakgamatso tse di kalo.” ");
INSERT INTO tsn_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mme ba bangwe ba ne ba gopola gore Jesu ke Elija Moporofiti wa bogologolo o ka ne a boetse gape mo botshelong; ba bangwe ba gopola gore ke moporofiti yo mosha yo o tshwanang le bangwe ba ba tona ba bogologolo. ");
INSERT INTO tsn_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herode a re, “Nnyaa, ke Johane, monna yo ke mo kgaotseng tlhogo. O tsogile mo baswing.” ");
INSERT INTO tsn_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Gonne Herode o ne a rometse masole go tshwara Johane go mo isa kgolegelong ka ntlha ya gore o ne a tswelela a ntse a re, ke phoso fa kgosi e nyala Herodiase, mogatsa Filipo monnawe kgosi. ");
INSERT INTO tsn_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodiase o ne a batla gore Johane a bolawe a ipusulosetse, le fa go ntse jalo, kwa ntle ga tumalano ya ga Herode, Herodiase a palelwa. ");
INSERT INTO tsn_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herode o ne a tlotla Johane, a itse fa e le motho yo o molemo a bile a le boitshepo, foo a mmaya ka fa tlase ga tshireletso ya gagwe. Herode o ne a tshwenyega nako tsotlhe fa a bua le Johane, le fa go ntse jalo o ne a rata go mo reetsa. ");
INSERT INTO tsn_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mme ya re la bofelo lobaka lwa ga Herodiase la tla. Ya re letsatsi la botsalo jwa ga Herode, Herode a direla bagolwane ba bogosi jwa gagwe mokete le bagolwane ba sesole, le baeteledipele ba baagedi ba motse wa Galalea. ");
INSERT INTO tsn_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Hong ngwana wa mosetsana wa ga Herodiase a tla a bina fa pele ga bone ka botswerere a ba itumedisa fela botlhe. Kgosi ya mo raya ya re, “Nkopa sengwe se o se ratang,” “Le fa e le bontlha jwa bogosi jwa me, mme ke tla bo go naya!” ");
INSERT INTO tsn_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mme a tsamaya a ya go itsise mmaagwe, yo o neng a mo raya a re, “Lopa tlhogo ya ga Johone wa Mokolobetsi!” ");
INSERT INTO tsn_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hong a boela kwa morago kwa kgosing a ya go e bolelela, a re, “Ke batla tlhogo ya ga Johane wa Mokolobetsi e le mo mogopong.” ");
INSERT INTO tsn_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mme kgosi ya hutsahala thata, ya tlhajwa ke ditlhong go roba maikano a yone fa pele ga baeng ba yone. ");
INSERT INTO tsn_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hong a roma mongwe wa batlhokomedi ba gagwe kwa kgolegelong go ya go kgaola tlhogo ya ga Johane le go e lere kwa go ene. Mme lesole la ya go bolaya Johane mo kgolegelong, ");
INSERT INTO tsn_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","a tla ka tlhogo ya ga Johane e le mo mogopong, a e naya mosetsana, mosetsana ene a ya go e naya mmaagwe. ");
INSERT INTO tsn_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Erile barutwa ba ga Johane ba utlwa se se diragetseng, ba tla ba tsaya mmele wa gagwe ba ya go o boloka mo lebitleng. ");
INSERT INTO tsn_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mme baaposetoloi ba boela kwa go Jesu ba tswa loetong lwa bone ba mmolelela gotlhe mo ba go dirileng le mo ba go buileng le batho ba ba neng ba ba etela. ");
INSERT INTO tsn_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Hong Jesu a ba raya a re, “A re tsweng mo bontsing jwa batho ka lobakanyana re yeng go itapolosa.” Gonne go ne go na le batho ba le bantsi ba ba tlang le ba ba tsamayang ba sena nako le ya go ja tota. ");
INSERT INTO tsn_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mme ba tsamaya ka mokoro ba ya fa lefelong le le tuuletseng. ");
INSERT INTO tsn_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mme batho ba le bantsi ba ba bona ba tsamaya mme ba tabogela kwa pele ba le mo lotshitshing ba ba kgatlhantsha fa ba tswa mo mokorong. ");
INSERT INTO tsn_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Fela jaaka gale, bontsi jwa batho jwa bo bo le teng fa a tswa mo mokorong; mme a ba tlhomogela pelo ka ntlha ya gore ba ne ba tshwana le dinku tse di senang modisa a ba ruta dilo di le dintsi tse ba tshwanetseng go di itse. ");
INSERT INTO tsn_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Mme morago ga tshokologo ya letsatsi barutwa ba gagwe ba tla kwa go ene ba re, “Bolelela batho gore ba tsamaye ba ye kwa metsing e e gaufi le masimo ba ye go itshenkela dijo, gonne ga go na sepe se se ka jewang mo thoteng e, gape go nna bosigo.” ");
INSERT INTO tsn_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Hong Jesu a re, “Ba fepeng.” Mme ba botsa ba re, “Ka eng? Go tlaa lopa madi a le mantsi go reka dijo tsa bontsi jo bo kana!” ");
INSERT INTO tsn_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mme a ba botsa a re, “Re na le dijo di le kana kang? Tsamayang lo yeng go bona.” Mme ba tla gape go tla go mmolelela gore go na le dinkgwe di le tlhano le ditlhapi di le pedi. ");
INSERT INTO tsn_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Hong Jesu a bolelela bontsi jwa batho gore ba nne fa fatshe, mme ka bonako ba kgaoganngwa ka ditlhopha tsa masome a matlhano kgotsa lekgolo mme botlhe ba bo ba ntse mo bojannyeng jo botala. ");
INSERT INTO tsn_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Hong a tsaya dinkgwe tse tlhano le ditlhapi tse pedi a leba kwa legodimong, a lebogela dijo tseo. A ngathoganya dinkgwe go nna dikapetlana, a neela barutwa ba gagwe bontlha bongwe jwa dinkgwe le ditlhapi go di fa batho. ");
INSERT INTO tsn_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mme batho baa ja botlhe ba kgora! ");
INSERT INTO tsn_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","44","Go ne go le banna ba ka nna dikete di le tlhano ka nako ya dijo, morago ga moo ditlatlana di le lesome le bobedi tsa tlala masalela a a neng a selwa fa fatshe mo bojannyeng! ");
INSERT INTO tsn_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mme ka bonako morago ga moo Jesu a laola barutwa ba gagwe gore ba boele mo mokorong ba kgabaganye lecha ba ye Bethesaida, kwa o neng a tlaa kopana le bone teng morago. Fa Ene a ne a sa ntse a saletse go sadisa batho sentle gore ba boele gae. ");
INSERT INTO tsn_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Morago ga moo a tsamaya a ya kwa dithabeng go rapela. ");
INSERT INTO tsn_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mme ya re bosigo, fa barutwa ba gagwe ba le mo mokorong mo gare ga lecha, ene a bo a le nosi ka kwa ntle ga lecha. ");
INSERT INTO tsn_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mme a bona fa ba le mo matshwenyegong a magolo, ba hudua ka bothata le go kgaratlha kgatlhanong le phefo e e tsubutlang le makhubu a lewatle. Erile e ka ne e le nako ya boraro mo mosong a tsamaela kwa go bone mo godimo ga metsi. Mme ya re ekete o a ba feta, ");
INSERT INTO tsn_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ba bona sengwe se tsamaya tsamaya fa thoko ga bone ba goa ka letshogo, ba gopola fa e le sepoko, ");
INSERT INTO tsn_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","gonne ba ne ba mmona botlhe. Mme a bua le bone a re, “Go siame, se boifeng! Ke nna.” ");
INSERT INTO tsn_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Hong a palama mo mokorong, phefo ya didimala! Ba nna fela foo ba gakgametse. ");
INSERT INTO tsn_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Gonne ba ne ba ise ba lemoge gore ke mang le fa e le morago ga kgakgamatso ya maabane maitsiboa! Gonne ba ne ba sa batle go dumela. ");
INSERT INTO tsn_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mme ya re ba fitlha kwa Geneseretha ka fa ntlheng e nngwe ya lecha ba bohelela mokoro, ");
INSERT INTO tsn_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ba fologa. Mme batho ba ba neng ba eme mo tikologong eo ba mo lemoga fela ka nako eo, ");
INSERT INTO tsn_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","mme ba taboga le tikologo yotlhe ba anamisa dikgang kaga kgorogo ya gagwe, ba simolola go rwalela balwetse kwa go ene ka mapara le ka meseme. ");
INSERT INTO tsn_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Gongwe le gongwe mo a neng a tsamaya teng, mo metsaneng le mo metseng e megolo, le kwa ntle kwa masimo, ba baya balwetse mo dipatlelong tsa marekelo le mo ditseleng ba mo rapela gore a ba letle ba ame makantsa a diaparo tsa gagwe; mme botlhe ba ba mo amileng ba fodisiwa. ");
INSERT INTO tsn_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ka letsatsi lengwe baeteledipele bangwe ba tumelo ya Sejuta ba tla kwa go ene ba tswa kwa Jerusalema go tla go mo tlhotlhomisa, ");
INSERT INTO tsn_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ba lemoga gore bangwe ba barutwa ba gagwe ga ba diragatse mekgwa ya bone e e tlwaelesegileng ya Sejuta pele ga ba a ja. ");
INSERT INTO tsn_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Gonne Bajuta, segolo jang Bafarasai, ga ba ka ke ba a ja pele ga ba tlhapa diatla tsa bone go fitlha mo dikgonong, jaaka go tlhokafala ka dingwao tsa bone tsa bogologolo. ");
INSERT INTO tsn_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Jalo fa ba tla gae ba tswa marekelong ba tshwanetse go tlhapa ka mokgwa oo pele ga ba ka ama dijo. Se ke sengwe sa dikai tse dintsi tsa melao e e tlwaelesegileng e ba saleng ba e ngaparela ka dingwaga di le dintsi e sa ntse e tsweletse e dirisiwa, fela jaaka tlwaelo ya bone ya go tlhatswa dipitsa le senwelo le dijana tse di jelang. ");
INSERT INTO tsn_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Hong baeteledipele ba tumelo ba mmotsa ba re, “Ke ka ntlha yang fa barutwa ba gago ba sa latele ngwao ya rona ya bogologolo? Gonne ba ja pele ga ba tlhapa.” ");
INSERT INTO tsn_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Mme Jesu a araba a re, “Baitemokanyi ke lona! Isaia moporofiti o lo bonye sentle fa a re, ‘Batho ba ba bua sentle ka ga Morena mme ba sa mo rate ka boammaaruri. Kobamelo ya bone ke ya dinyana, gonne ba re Modimo o laola batho go obamela melao ya bone! Ruri Isaia o ne a le boammaaruri jang!’ ");
INSERT INTO tsn_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Gonne lo itlhokomolosa melao ya Modimo e e tlhomameng mme mo boemong jwa moo lo tshegeditse ngwao ya lona fela. ");
INSERT INTO tsn_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ga re lo a tle lo gane melao ya Modimo fela lo bo lo e gataka ka dinao gore lo tle lo tshegetse ngwao ya lona. ");
INSERT INTO tsn_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Fela jaaka Moshe a lo neile molao o o tswang kwa Modimong; o o reng, ‘Tlotla rrago le mmago!’ Mme a re le fa e le mang yo o buang bosula ka ga rraagwe kgotsa mmaagwe o tshwanetse go swa. ");
INSERT INTO tsn_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mme lwa re go siame fa motho a itlhokomolosa batsadi ba gagwe ba ba tlhokang, a ba raya a re, ‘Lo intshwarele, ga nkake ka lo thusa! Gonne se ke neng ke tlaa se lo naya ke se ntsheditse Modimo.’ ");
INSERT INTO tsn_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","13","Jalo lo roba molao wa Modimo go diragatsa ngwao ya lona e e dirilweng ke batho. Mme se ke sekai se le sengwe fela. Go na le tse dingwe di le dintsi thata.” ");
INSERT INTO tsn_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Hong Jesu a bitsa bontsintsi jwa batho go tla go reetsa: A re, “A mongwe le mongwe wa lona a reetse, lo bo lo leke go tlhaloganya. ");
INSERT INTO tsn_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Mewa ya lona ga e senngwe ke se lo se jang, mme e senngwa ke se lo se akanyang le se lo se buang!” ");
INSERT INTO tsn_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Hong a tsena mo tlung go tswa fa bontsing jwa batho, mme barutwa ba gagwe ba mmotsa gore o rayang ka se a neng a se bolela. ");
INSERT INTO tsn_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Mme a ba botsa a re, “A le lona ga lo tlhaloganye? A ga lo bone gore se lo se jang ga se kake sa senya mewa ya lona? ");
INSERT INTO tsn_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Gonne dijo ga di amane ka gope le pelo ya gago, mme di feta fela ka mometso di ye kwa di silwang teng,” (go bua se o ne a supa fa mofuta mongwe le mongwe o na le go ka jewa.) ");
INSERT INTO tsn_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Mme a nna a tswelela a re, “Ke dikakanyo fela tse di bosula tse di itshekololang. ");
INSERT INTO tsn_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Gonne go tswa mo dipelong tsa batho, go tswa dikakanyo tse di bosula, tsa dikeletso, bogodu, go bolaya, boaka, ");
INSERT INTO tsn_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","go batla tse e leng tsa ba bangwe, boikepo, tsietso, maaka, dithato, bopelompe, mabela le dilo tsotlhe tsa boeleele. ");
INSERT INTO tsn_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mme dilo tse tsotlhe tse di bosula di tswa mo teng; ke tsone tse di go itshekololang gore o seka wa itekanela mo Modimong.” ");
INSERT INTO tsn_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Mme a tswa a tloga mo Galalea a tsamaya a ya kwa kgaolong ya Ture le Sidona, mme a leka go go dira sephiri sa gore o ne a le teng koo, mme ga seka ga diragala. Gonne jaaka gale, dikgang tsa kgorogo ya gagwe di ne tsa anama ka bofefo. ");
INSERT INTO tsn_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ka bonako ga tla mosadi kwa go ene yo ngwana wa gagwe o neng a na le mowa o o maswe, a utlwaletse kaga Jesu mme a tla a wela fa dinaong tsa gagwe, ");
INSERT INTO tsn_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","mme a mo rapela gore a golole ngwana wa gagwe mo thateng ya taolo ya mowa o o maswe. (Mme a bo a le modichaba wa Se-Siria le Se-Fonishia yo o nyaditsweng!) ");
INSERT INTO tsn_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mme Jesu a mo raya a re, “Pele ke tshwanetse go thusa bagaetsho Bajuta. Ga go a siama go tsaya dijo tsa bana o di latlhelela dintsa.” ");
INSERT INTO tsn_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Hong mosadi a araba a re, “Go boammaaruri, Morena, le tsone dintsanyana kafa tlase ga lomati lwa bojelo di newa mafofora a a wang mo dijaneng tsa bana.” ");
INSERT INTO tsn_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Mme a mo raya a re, “Go siame! O arabile sentle mo eleng gore ke fodisitse ngwana wa gago wa mosetsana. Tsamaya o ye gae, gonne mowa o o maswe o dule mo go ene!” ");
INSERT INTO tsn_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mme e rile fa a tsena kwa gae, ngwana wa gagwe a bo a robetse ka tidimalo e kgolo mo bolaong, mme mowa o o maswe wa bo o tsamaile. ");
INSERT INTO tsn_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mme go tswa kwa Ture a tsamaya a ya Sidona, a boela kwa lewatleng la Galalea ka tsela ya metse e le lesome. ");
INSERT INTO tsn_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ga tlisiwa kwa go ene monna yo o neng a sa utlwe e le susu a bile a kwakwaetsa, mme botlhe ba kopa Jesu gore a beye diatla tsa gagwe mo monneng yoo go mo fodisa. ");
INSERT INTO tsn_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesu a mo ntsha mo bontsing jwa batho a tsenya menwana ya gagwe mo ditsebeng tsa gagwe, a kgwa mathe a ama loleme lwa monna yoo. ");
INSERT INTO tsn_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Hong a leba kwa legodimong, a fegelwa mme a laola gore a “Kabologe!” ");
INSERT INTO tsn_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ka bonako monna a simolola go utlwa sentle le go bua sentle ka tlhamalalo! ");
INSERT INTO tsn_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Mme Jesu a raya bontsi jwa batho a re ba seka ba bolelela ope, mme le fa a na a ba iditse jalo, bone ba ya ba bolela bogolo segolo. ");
INSERT INTO tsn_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Gonne ba ne ba gakgametse ka se se diragetseng. Gangwe le gape ba re, “Sengwe le sengwe se o se dirang ke se se gakgamatsang; o kgona gore ba ba susu ba utlwe le ba ba kwakwaetsang ba bue!” ");
INSERT INTO tsn_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Ka letsatsi lengwe jaaka bontsi bo phuthega, batho ba felelwa ke dijo gape, Jesu a bitsa barutwa ba gagwe go tla go bua ka seemo seo. A re, “Ke utlwela batho ba botlhoko, gonne ga ba bolo go nna fano malatsi a le mararo, mme ga ba a salelwa ke sepe go se ja. ");
INSERT INTO tsn_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mme fa ke ba phatlalaletsa kwa magaeng a bone ke sa ba fa dijo ba tlaa idibalela mo tseleng! Gonne bangwe ba bone ba tswa kgakala.” ");
INSERT INTO tsn_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mme ba mo fetola ka tshotlo ba re, “A re tshwanetse go ba senkela dijo fano mo sekakeng?” ");
INSERT INTO tsn_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","A botsa a re, “Lo na le dinkgwe di le kae?” Mme bone ba re, “Di supa”. ");
INSERT INTO tsn_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Hong a raya bontsi jwa batho a re bo nne fa fatshe. Mme a tsaya dinkgwe di supa, a di lebogela, a di ngathoganya dikapetlana a di fetisetsa kwa barutweng, mme barutwa ba di abela batho. ");
INSERT INTO tsn_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mme ba bo ba na le ditlhatswana di se kae, hong Jesu a di segofatsa a raya barutwa a re ba fe batho. ");
INSERT INTO tsn_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Hong bontsi jwa batho jwa a ja jotlhe go fitlhelela bo kgora, mme morago ga moo a ba phatlalaletsa kwa magaeng a bone. Go ne go na le batho ba ka nna dikete tse nne ka letsatsi leo. Mme ya re masalela a sena go kokoanngwa morago ga dijo ga sala diroto di supa tse di tona di tletse! ");
INSERT INTO tsn_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ka bonako morago ga moo a tsena mo mokorong le barutwa ba gagwe a ya kwa kgaolong ya Dalemanutha. ");
INSERT INTO tsn_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","E rile baeteledipele ba Sejuta ba kgaolo eo ba utlwa gore o gorogile ba tla go tatalalana nae ba re, “Re direle kgakgamatso, dira gore sengwe se diragale mo loaping. Ke gone re tlaa dumelang mo go wena.” ");
INSERT INTO tsn_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mme a utlwa botlhoko fa a utlwa kafa ba buang ka teng mme a re, “Nnyaa bathong. Lo ntse lo batla dikgakgamatso dife?” ");
INSERT INTO tsn_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Hong a boela mo mokorong a ba tlogela, a tshelela ka kwa ntlheng e nngwe ya lecha. ");
INSERT INTO tsn_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mme barutwa ba bo ba lebetse go tsaya dijo pele ga ba tsamaya, mme ba ne ba na le senkgwe se le sengwe fela mo mokorong. ");
INSERT INTO tsn_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ya re ba kgabaganya, Jesu a ba tlhagisa ka tlhoafalo a re, “Itlhokomeleng mo sebidisong sa ga Kgosi Herode le mo sebidisong sa Bafarasai.” ");
INSERT INTO tsn_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Mme barutwa ba botsanya ba re, “O rayang?” Ya re kwa bofelong ba akanya gore o tshwanetse a ba a bua ka go lebala ga bone go tla le senkgwe. ");
INSERT INTO tsn_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesu a lemoga se ba neng ba se bua mme a re, “Nnyaa, ga go a nna jalo gotlhelele! A ga lo tlhaloganye? A dipelo tsa lona di thata go ka lemoga? ");
INSERT INTO tsn_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Fela jaaka Isaia a boletse, ‘Matlho a lona ke a go re lo bone ka one--ke ka ntlha yang fa lo sa lebe? Ke ka ntlha yang fa lo sa bule ditsebe tsa lona mme lwa reetsa’ A ga lo gakologelwe sepe gotlhelele? ");
INSERT INTO tsn_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","“Lwa reng ka batho ba ba dikete tse tlhano ba ke neng ka ba fepha ka dinkgwe tse tlhano? Go ne go na le diroto di le kae tse di neng di tletse masalela ba sena go ja?” Ba re, “Lesome le bobedi.” ");
INSERT INTO tsn_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Mme e rile fa ke abela batho ba le dikete di le nne dinkgwe di supa, go ne ga sala di le kae?” Ba re, “Go ne ga sala diroto tse di tletseng di supa.” ");
INSERT INTO tsn_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Mme a lo gopola gore ke a tshwenyega fa go sena senkgwe?” ");
INSERT INTO tsn_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ya re ba fitlha mo Bethesaida, batho bangwe ba tlisa kwa go ene monna yo o foufetseng mme ba mo kopa gore a mo ame gore a fole. ");
INSERT INTO tsn_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesu a tshwara monna yo o foufetseng ka letsogo a mo gogela kwa ntle ga motse, a mo kgwela mathe mo matlhong a bo a mmaya diatla. Jesu a mmotsa a re, “A o bona sengwe jaanong?” ");
INSERT INTO tsn_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mme monna a leba mo tikologong a re, “Ee, ke bona batho. Mme ga ke ba bone sentle; ba lebega e ka re ke dithito tsa ditlhare di a tsamaya?” ");
INSERT INTO tsn_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Hong Jesu a mmaya gape diatla mo matlhong mme ya re a leba, a boelwa ke pono ya gagwe gotlhelele, mme a bona sengwe le sengwe sentle, se se neng se le mo tikologong ya gagwe. ");
INSERT INTO tsn_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesu a mo romela kwa gae kwa go ba ntlo ya gagwe. A mo raya a re, “O seka wa ya mo motseng pele.” ");
INSERT INTO tsn_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesu le barutwa ba gagwe ba tswa mo Galalea ba tswela kwa ntle kwa metseng ya Kaesarea Filipo. Mme ya re ba ntse ba tsamaya a ba botsa a re, “Ana batho ba re ke mang? Ba reng ka ga me?” ");
INSERT INTO tsn_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Barutwa ba araba ba re, “Bangwe ba bone ba gopola gore o Johane wa Mokolobetsi, mme bangwe ba re o Elija kgotsa o mongwe wa baporofiti ba bogologolo o rudile.” ");
INSERT INTO tsn_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Hong a ba botsa a re, “Mme lona lo gopola gore ke mang?” Petere a araba a re, “O Mesia.” ");
INSERT INTO tsn_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Hong Jesu a ba laya gore ba se bolelele ope! ");
INSERT INTO tsn_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","A simolola go ba bolelela ka matshwenyego a a boitshegang a o tlaa a bogang le gore o tlaa ganwa ke baeteledipele le bagolwane ba baperesiti le bangwe baeteledipele ba Sejuta, le gore o tlaa bolawa, mme morago ga malatsi a le mararo o tlaa tsoga gape. ");
INSERT INTO tsn_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mme o ne a bua le bone ka tlhamalalo, hong Petere a mo tseela kwa thoko a ya go mo kgalemela a re, “O seka wa bua dilo tse di ntseng jalo.” ");
INSERT INTO tsn_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Hong Jesu a retologa a leba barutwa ba gagwe a gakalela Petere a re, “Satane, tloga fa morago ga me! O leba dilo tse ka tebo ya senama fela, e seng kafa ntlheng ya bo-Modimo.” ");
INSERT INTO tsn_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Hong a bitsa barutwa ba gagwe le bontsi jwa batho go tla go mo reetsa, a ba raya a re, “Fa mongwe wa lona a rata go nna molatedi wa me, o tshwanetse go beela mahumo a gagwe fa thoko a itshikarele mokgoro, mme a ntshale morago. ");
INSERT INTO tsn_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Fa lo tsweletse go boloka botshelo jwa lona, bo tlaa lo latlhegela. Fela ba ba latlhegelwang ke matshelo a bone ka ntlha ya me le ka ntlha ya Mafoko a a Molemo, ba tlaa itse gore tota botshelo bo rayang. ");
INSERT INTO tsn_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“Mme motho o boelwa ke eng fa a fenya lefatshe lotlhe mme a lathegelwa ke botshelo jwa gagwe? ");
INSERT INTO tsn_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Gonne a go na le sengwe sa botlhokwa go gaisa mowa wa gagwe? ");
INSERT INTO tsn_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Le, fa e le mang yo o ntlhabelwang ke ditlhong le molaetsa wa me mo malatsing ano a go tlhoka go dumela le a boleo, Nna Mesia, ke tlaa mo tlhabelwa ke ditlhong fa ke boa ke le mo kgalalelong ya ga Rre, le baengele ba ba boitshepo.” ");
INSERT INTO tsn_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesu a tswelela a raya barutwa ba gagwe a re, “Bangwe ba lona ba ba emeng fa, gompieno ba tlaa tshela go bona Bogosi jwa Modimo bo tla ka nonofo e kgolo!” ");
INSERT INTO tsn_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Malatsi a le marataro a sena go feta Jesu a tsaya Petere, Jakobe le Johane, a tlhatlhogela kwa godimo ga thaba. Go ne go sena ope teng. Ka bofefo sefatlhogo sa gagwe sa simolola go phatshima ka kgalalelo, ");
INSERT INTO tsn_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","mme diaparo tsa gagwe tsa tsabakela, tsa nna ditshweu thata, di galalela thata go gaisa jaaka motho ope mo lefatshing a ka di sweufatsa. ");
INSERT INTO tsn_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Hong Elija le Moshe ba bonala mme ba simolola go bua le Jesu! ");
INSERT INTO tsn_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Mme Petere a bua a re, “Moruti, go go ntle jang!” Re tlaa aga metlaagana e le meraro fa, mongwe le mongwe wa lona a na le wa gagwe. ");
INSERT INTO tsn_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","O ne a bua se fela, gonne o ne a sa itse se a ka se buang ka botlhe ba ne ba tshogile. ");
INSERT INTO tsn_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mme erile fa a sa ntse a tsweletse ka go bua mafoko a, leru la ba khurumetsa, la sira letsatsi, mme lentswe la tswa mo lerung la re, “Yo ke morwaake. Reetsang ene.” ");
INSERT INTO tsn_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mme ka tshoganyetso fa ba leba kafa le kafa, Moshe le Elija ba bo ba seyo, mme ya bo e le Jesu fela yo o nang nabo. ");
INSERT INTO tsn_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ya re ba fologa mo thabeng a ba raya are ba seka ba bolelela ope kaga se ba se boneng go fitlhelela a sena go tsoga mo baswing. ");
INSERT INTO tsn_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mme ba ipolokela kgang e, ba nna ba bua ka ga yone, gore o kane a raya eng “Ka go tsoga mo baswing.” ");
INSERT INTO tsn_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Hong ba simolola go mmotsa kaga sengwe se baeteledipele ba tumelo ya Sejuta ba tlwaetseng go se bua, ba re Elija o tshwanetse go tla (pele ga Mesia a ka tla). ");
INSERT INTO tsn_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Mme Jesu a dumela gore Elija o tshwanetse go tla pele go baakanya tsela, le fa go ntse jalo go setse go diragetse, o setse a tsile! Le gore o kopane le matshwenyego a a boitshegang, fela jaaka Baporofiti ba ne ba boletse. Hong Jesu a ba botsa gore baporofiti ba ka ne ba ne ba raya eng fa ba re, Mesia o tlaa boga a ba a tsewa ka lonyatso. ");
INSERT INTO tsn_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mme ya re ba goroga kwa tlase ga thaba, ba fitlhela bontsi jo bogolo jwa batho bo dikaganyeditse barutwa ba bangwe ba ba ferang bongwe, fa bangwe ba baeteledipele ba Sejuta ba ntse ba ganetsanya nabo. ");
INSERT INTO tsn_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mme bontsi jwa batho ba leba Jesu ka poifo fa a atamela kwa go bone, hong ba tabogela kwa go ene go mo dumedisa. ");
INSERT INTO tsn_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Mme a ba botsa a re, “Lo ganetsanya kaga eng?” ");
INSERT INTO tsn_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Monna mongwe mo bontsing joo a bua a re, “Moruti, ke lerile morwaake mo go wena gore o mo fodise--ga a kgone go bua ka ntlha ya gore o tswenwe ke mowa o o maswe. ");
INSERT INTO tsn_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mme fa mowa o o maswe o mo laola o mo digela fa fatshe o mo dira gore a phoke mafulo ka molomo a phuranye meno a kwatlalale. Mme ka kopa barutwa ba gago gore ba kgoromeletse ntle mowa o o maswe mme ba retelelwa.” ");
INSERT INTO tsn_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesu a raya barutwa ba gagwe a re, “Ao, a batho ba ba tumelo e potlana, ke tshwanetse go nna le lona lobaka lo lo kae mme lo sa dumele? Ke lobaka lo lo kae lo ke tshwanetseng go lo itshokela? Lereng mosimane kwa go nna.” ");
INSERT INTO tsn_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Hong ba lere mosimane, mme erile fa a bona Jesu, mowa o o maswe wa mo kgothakgotha mo go botlhoko, mme a wela fa fatshe a bidikama a phoka mafulo ka molomo. ");
INSERT INTO tsn_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesu a botsa rraagwe a re, “Go lobaka lo lo kae a ntse jaana?” Rraagwe a araba a re, “a le mmotlana, ");
INSERT INTO tsn_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","mme gantsi mowa o o maswe o dira gore a wele mo molelong kgotsa mo teng ga metsi go mmolaya. Ao, re utlwele botlhoko, o dire sengwe fa go kgonega.” ");
INSERT INTO tsn_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesu a botsa a re, “A wa re fa ke kgona? Sengwe le sengwe se a kgonega fa o na le tumelo.” ");
INSERT INTO tsn_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ka bofefo rraagwe a araba a re, “Ke na le tumelo; Nthusa o e nkokeletse.” ");
INSERT INTO tsn_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Erile fa Jesu a bona gore bontsi jwa batho bo a gola, a kgalemela mowa o o maswe. A raya mowa o o maswe o o semumu le bosusu, a re, “Ke a go laola gore o tswe mo ngwaneng yo, o seka wa tlhola o tsena mo go ene gape!” ");
INSERT INTO tsn_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Hong mowa o o maswe wa goa mo go boitshegang wa kgothakgotha mosimanyana gape mme wa mo tlogela; a robala a sa tshikinyege a bonala jaaka moswi. Modumonyana wa utlwala mo bathung o re, “O sule.” ");
INSERT INTO tsn_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesu a mo tshwara ka seatla a mo thusa gore a eme ka maoto, mme a ema a itekanetse! ");
INSERT INTO tsn_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ya re morago ga moo Jesu a le esi mo tlung le barutwa ba gagwe, ba mmotsa ba re, “Ke ka ntlha yang fa re ne re sa kgone go kgoromeletsa ntle mowa o o maswe?” ");
INSERT INTO tsn_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesu a araba a re, “Mofuta o o ntseng jaana o kgonwa ke thapelo fela.” ");
INSERT INTO tsn_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Ya re ba tloga mo kgaolong eo ba tsamaya ba ralala Galalea mo a neng a leka go tila batho gore a tle a nne le nako ya go nna le barutwa ba gagwe, go ba ruta. O ne a ba raya a re, “Nna, Mesia ke tla okiwa, ke bolawe mme morago ga malatsi a le mararo ke tlaa rula.” ");
INSERT INTO tsn_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Lefa go ntse jalo, ba bo ba sa tlhaloganye, mme ba tshaba go mmotsa gore o rayang. ");
INSERT INTO tsn_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mme ba goroga kwa Kaperanama. Ya re ba sena go nna fa fatshe mo tlung e ba neng ba tshwanetse go nna mo go yone a ba botsa a re, “Lo ne lo bua ka ga eng mo tseleng.” ");
INSERT INTO tsn_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mme ba tlhajwa ke ditlhong go araba, gonne ba ne ba ganetsanya ka gore e mang mo go bone yo mogolo! ");
INSERT INTO tsn_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","A nna fa fatshe a ba bitsa a ba raya a re, “Mongwe yo o batlang go nna yo mogolo o tshwanetse go nna wa bofelo, motlhanka wa botlhe!” ");
INSERT INTO tsn_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Hong a baya ngwana mo gare ga bone; mme e rile a tsaya ngwana ka mabogo a gagwe a ba raya a re, ");
INSERT INTO tsn_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Le fa e le mang yo o amogelang ngwana yo monnye jaana mo leineng la me o amogela nna, mme le fa e le mang yo o mo amogelang o amogela Rre yo o nthomileng!” ");
INSERT INTO tsn_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Mme mongwe wa barutwa ba gagwe, ebong Johane, ya re ka letsatsi lengwe a mo raya a re, “Moruti, re bone monna mongwe a dirisa leina la gago go kgoromeletsa mewa e e maswe kwa ntle; mme ra mo raya ra re a se ka a dira jalo, gonne ga se mongwe wa setlhopha sa rona.” ");
INSERT INTO tsn_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesu a ba raya a re, “Se mo itseng! gonne ga go ope yo o dirang dikgakgamatso ka leina la me yo o tla reng ka bofefo a nne kgatlhanong le nna. ");
INSERT INTO tsn_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Lefa e le mang yo o seng kgatlhanong le rona ke wa rona. ");
INSERT INTO tsn_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Fa mongwe a ka lo siela metse ka ntlha ya gore lo ba ga Keresete ka re ammaaruri ga a kitla a latlhegelwa ke tuelo ya gagwe. ");
INSERT INTO tsn_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Mme fa mongwe a ka dira gore mongwe wa ba ba botlana ba yo o dumelang mo go nna a latlhegelwe ke tumelo--go ka nna botoka fa motho yoo a ka hunelelwa lolwala lo lo golo mo thamong a ya go thabuediwa mo lewatleng. ");
INSERT INTO tsn_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Fa seatla sa gago se leofa, se kgaole. Go botoka go tshelela ruri ka seatla se le sengwe go na le go latlhelwa mo molelong wa molete o o sa timeng ka diatla tse pedi! ");
INSERT INTO tsn_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Fa lonao lwa gago lo go isa bosuleng lo kgaole! Go botoka go nna setlhotsa lobaka lo loleele, go na le go nna le dinao tse pedi tse di go isang moleting. ");
INSERT INTO tsn_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Mme fa leitlho la gago le go leofisa, le gonye. Go botoka go tsena mo Bogosingjwa Modimo o le mogapa, go na le go tsena ka matlho a mabedi mo moleting wa molelo, ");
INSERT INTO tsn_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","kwa seboko se sa sweng, le kwa molelo o sa timeng, ");
INSERT INTO tsn_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","kwa tsotlhe di lokwang ka molelo. ");
INSERT INTO tsn_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Letswai le le molemo, ga le na thuso fa le latlhegelwa ke molodi, ga le ka ke la loka sepe. Se latlhegelweng ke molodi wa lona! Nnang kagiso mo go ba bangwe.” ");
INSERT INTO tsn_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Erile a tloga mo Kaperanama a ya ntlheng ya Borwa kwa melelwaneng ya Judea le mo kgaolong ya botlhabatsatsi jwa Noka ya Jorodane. Fela jaaka gale ga bo go le matshutitshuti a batho mme a ba ruta. ");
INSERT INTO tsn_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bangwe ba Bafarasai ba tla kwa go ene ba mmotsa ba re, “A o letlelela tlhalo?” le fa go ntse jalo ba ne ba leka go mo lalela. ");
INSERT INTO tsn_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesu a ba botsa a re, “Moshe o ne a reng ka ga tlhalo?” ");
INSERT INTO tsn_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ba araba ba re, “O rile e siame.” O rile, “Se se tlhokafalang ke gore monna a kwalele mosadi lokwalo lwa tlhalo.” ");
INSERT INTO tsn_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesu a ba botsa a re, “Mme o ne a buelang jalo? Ke tla lo bolelela gore ke ka ntlha yang fa a ne a bua jalo. Ke ka ntlha ya boikepo jwa bopeloethata jwa lona. ");
INSERT INTO tsn_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","7","Mme tota ga se ka fa tseleng ya Modimo, gonne e rile mo tshimologong O dirile monna le mosadi go ba kopanya go nnela ruri mo nyalong; ke gone ka moo monna o tlaa tlogelang rraagwe le mmaagwe, ");
INSERT INTO tsn_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","mme ene le mosadi wa gagwe ba kopane gore ba se nne bobedi, fa e se bongwe fela. ");
INSERT INTO tsn_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mme ke gone go seng ope yo o tshwanetseng go kgaoganya se Modimo o se kopantseng.” ");
INSERT INTO tsn_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ya re morago, a le nosi le barutwa ba gagwe mo tlung, ba lere kgang eo. ");
INSERT INTO tsn_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mme a ba raya a re, “Fa monna a tlhala mosadi wa gagwe a nyala o sele, o a mo akafalela. ");
INSERT INTO tsn_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mme fa mosadi a tlhala monna wa gagwe a nyalwa gape, le ene o dira boaka.” ");
INSERT INTO tsn_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","E rile ka nako nngwe fa bomma-bana ba lere bana ba bone kwa go Jesu gore a ba segofatse, barutwa ba ba leleka, ba ba raya ba re ba seka ba mo tshwenya. ");
INSERT INTO tsn_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mme e rile Jesu a bona se se diragalang o ne a seka a itumedisiwa ke barutwa ba gagwe mme a ba raya a re, “Lesang bana ba tle kwa go nna, gonne Bogosi jwa Modimo ke jwa ba ba ntseng jalo. Se ba lelekeng! ");
INSERT INTO tsn_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ke lo bolelela ka tlhoafalo jaaka ke itse gore fa mongwe a gana go tla mo Modimong jaaka ngwana yo monnye ga a kitla a letlelelwa go tsena mo Bogosing jwa One.” ");
INSERT INTO tsn_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Hong a tsaya bana ka mabogo a gagwe a ba baya diatla a ba segofatsa. ");
INSERT INTO tsn_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","E rile fa a simolola go tsaya loeto, monna mongwe a tla a tabogela kwa go ene a khubama ka mangole a re, “Moruti yo o molemo, ke tshwanetse gore ke direng go tsena kwa legodimong?” ");
INSERT INTO tsn_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesu a mmotsa a re, “Ke ka ntlha yang fa o mpitsa mosiami? ");
INSERT INTO tsn_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mme mo karabong ya potso ya gago o itse ditaolo tse di reng, o seka wa bolaya, o seka wa dira boaka, o seka wa utswa, o seka wa bua maaka, o seka wa tsietsa, tlotla rrago le mmago.” ");
INSERT INTO tsn_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Monna a araba a re, “Moruti, ga ke ise ke ko ke tlole le fa e le o le mongwe fela wa melao eo.” ");
INSERT INTO tsn_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Mme Jesu a ikutlwa a rata monna yo fa a mo leba, a mo raya a re, “O tlhoka selo se le sengwe fela, tsamaya o ye go rekisa dilo tsotlhe tse o nang natso mme o tseye madi o a abele bahumanegi mme o tlaa nna le khumo kwa legodimong, mme o tle o ntshale morago.” ");
INSERT INTO tsn_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mme sefatlhogo sa monna sa sulafala, a tsamaya ka kutlobotlhoko, gonne o ne a humile thata. ");
INSERT INTO tsn_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesu a mo lebelela a tsamaya, hong a retologa a raya barutwa ba gagwe a re, “Ga go motlhofo gore mohumi a tsene mo Bogosing jwa Modimo!” ");
INSERT INTO tsn_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mme mafoko a, a ba gakgamatsa. Hong Jesu a boelela mafoko a gape a re, “Bana ba ba rategang, go thata jang mo go ba ba ikantseng dikhumo go tsena mo Bogosing jwa Modimo. ");
INSERT INTO tsn_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Go motlhofo mo kammeleng go tsena ka leroba la nnale go na le mohumi go tsena mo Bogosing jwa Modimo.” ");
INSERT INTO tsn_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Mme go ne ga nna thata, gore barutwa ba dumele mafoko ao. Hong ba botsa ba re, “Mme he, e be e le mang mo lefatsheng yo o ka bolokwang fa mohumi a sa bolokwe?” ");
INSERT INTO tsn_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesu a ba tsepega matlho a re, “Kwa ntle ga Modimo go retetse. Mme mo Modimong sengwe le sengwe se a direga.” ");
INSERT INTO tsn_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Hong Petere a simolola go bolela kaga tsotlhe tse ene le barutwa ba bangwe ba di tlogetseng a re, “Re tlogetse sengwe le sengwe go go sala morago.” ");
INSERT INTO tsn_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Mme Jesu a araba a re, “Mma ke go tlhomamisetse gore ga go na ope yo o tlogetseng sepe, ebong legae, bokgaitsadie, bomorwa rraagwe, mmaagwe, rraagwe, bana kgotsa dithoto tsa gagwe, ka ntlha ya go nthata le go bolelela ba bangwe kaga mafoko a me a a Molemo, ");
INSERT INTO tsn_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","yo o se kitlang a newa ga lekgolo go menagane, ebong magae, bomorwa rraagwe, bokgaitsadie, le bo mmaagwe, bana le masimo di na le dipogisego! Tse tsotlhe e tlaa nna tsa gagwe mo lefatsheng leno le mo go le le tlang o tlaa bona botshelo jo bo sa khutleng. ");
INSERT INTO tsn_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bontsi jwa batho ba ba bonalang e ka re ba tlhokwa jaanong jaana ba tlaa nna ba ba botlana ka nako eo, mme ba bantsi ba ba bonalang ba le ba botlana fano ba tlaa nna bagolo ka nako eo.” ");
INSERT INTO tsn_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mme ya re ba le mo tseleng ba ya Jerusalema, Jesu a ba eteletse pele barutwa ba gagwe ba mo setse morago ba tlelwa ke poifo. Hong Jesu a ba tseela kwa thoko, a simolola gape go ba tlhalosetsa gotlhe mo go tlaa mo diragalelang fa ba goroga kwa Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","A ba raya a re, “E tlaa re re tsena teng. Nna, Mesia ke tlaa tshwarwa ke isiwa fa pele ga baperesiti ba bagolo le bagolwane ba Bajuta ba ba tlaa nkatlholelang loso ba bo ba neele Baroma go mpolaya. ");
INSERT INTO tsn_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ba tlaa ntshotla, ba nkgwele mathe ba mpetse ka dithupa tsa bone; mme morago ga malatsi a mararo ke tlaa rula.” ");
INSERT INTO tsn_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Hong Jakobe le Johane, bomorwa Sebede, ba tla ba bua le ene ka lentswe le le kwa tlase ba re, “Morena, re batla gore o re direle ka fa re batlang ka teng.” ");
INSERT INTO tsn_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Mme a ba botsa a re, “Lo batla ke lo direla eng?” ");
INSERT INTO tsn_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ba mo raya ba re, “Re batla go nna mo ditilong tsa bogosi re bapa nao mo bogosing jwa gago, yo mongwe ka fa letsogong la gago le legolo yo mongwe ka fa letsogong la gago la molema!” ");
INSERT INTO tsn_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Mme Jesu a araba a re, “Ga lo itse se lo se lopang! A lo nonofile go nwa mo senwelong se se botlhoko sa khutsafalo se ke tshwanetseng go nwa mo go sone? Kgotsa go kolobediwa ka kolobetso ya pogisego e ke tshwanetseng go kolobediwa ka yone?” ");
INSERT INTO tsn_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ba mo raya ba re, “Ee, re nonofile!” Mme Jesu a re, “Lo tlaa nwa mo senwelong se ke nwang mo go sone lo bo lo kolobediwa ka kolobetso ya me e ke kolobeditsweng ka yone, ");
INSERT INTO tsn_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","mme ga ke na thata ya go lo baya mo ditilong tsa bogosi go bapa le sa me. Ba ba tshwanetseng ba setse ba go baakanyeditswe.” ");
INSERT INTO tsn_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Fa ba bangwe ba barutwa ba tla go lemoga se Jakobe le Johane ba se lopileng, ba kgotswa thata. ");
INSERT INTO tsn_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Hong Jesu a ba biletsa kwa go ene mme a re, “Lo a itse fa dikgosi le banna ba bagolo ba lefatshe ba laola batho; ");
INSERT INTO tsn_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","mme mo go lona go pharologanyo. Le fa e le mang yo o ratang go nna mogolo mo go lona o tshwanetse go nna motlhanka wa lona. ");
INSERT INTO tsn_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mme le fa e le mang yo o ratang go ka nna mogolo mo go botlhe o tshwanetse go nna motlhanka wa botlhe. ");
INSERT INTO tsn_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Gonne le nna tota, Mesia, ga ke fano go tla go direlwa fa e se go thusa ba bangwe, le go ntsha botshelo jwa me gore e nne thekololo ya batho ba le bantsi.” ");
INSERT INTO tsn_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mme ba fitlha kwa Jeriko. Ya re morago fa ba tloga mo motseng bontsi jwa batho jo bogolo jwa ba sala morago. Hong ga diragala gore monna wa sefofu wa mokopi yo o bidiwang Baratimaio (morwa Timaio) a ba a ntse fa thoko ga tsela fa Jesu a feta. ");
INSERT INTO tsn_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mme e rile fa Baratimaio a utlwa gore Jesu wa Nasaretha o gaufi a simolola go goa, a re, “Jesu Morwa Dafide, nkutlwela botlhoko!” ");
INSERT INTO tsn_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mme batho bangwe ba mo kgalemela ba re, “Didimala!” Mme a goa segolo bogolo gangwe le gape a re, “Ao! Morwa Dafide, nkutlwela botlhoko!” ");
INSERT INTO tsn_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Erile Jesu a mo utlwa a ema foo mo tseleng, mme a re, “Mo reyeng lo re a tle kwano.” Hong ba bitsa monna wa sefofu. Ba re, “Heela wena yo o letlhogonolo, tla Jesu o a go bitsa.” ");
INSERT INTO tsn_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Hong Baratimaio a apola seaparo sa gagwe se segologolo a se latlhela kwa thoko, a tlola a tla kwa go Jesu. ");
INSERT INTO tsn_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesu a mmotsa a re, “O batla ke go direla eng?” Monna wa sefofu a araba a re, “Moruti, ke batla go bona.” ");
INSERT INTO tsn_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesu a mo raya a re, “Gotlhe go siame, go diragetse. Tumelo ya gago e go fodisitse.” E rile gone fela foo monna wa sefofu a bona, a sala Jesu morago mo tseleng! ");
INSERT INTO tsn_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mme erile ba atamela Bethefage le Bethania ntlheng ya Jerusalema ba tla mo thoteng ya Lotlhware, Jesu a romela barutwa ba gagwe ba babedi kwa pele. ");
INSERT INTO tsn_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","A ba raya a re, “Yang mo motsing ole, mme e tlaa re fela fa lo tsena lo tlaa bona tonkana e golegilwe e e iseng e ke e palangwe, e gololeng lo e lere kwano. ");
INSERT INTO tsn_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mme e re fa mongwe a lo botsa gore lo dirang, lo re, ‘Morena wa rona o a e batla mme o tlaa e busa ka bonako.’ ” ");
INSERT INTO tsn_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Hong banna ba babedi bao ba tsamaya ba fitlhela tonkana eo?” ");
INSERT INTO tsn_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Hong ba bua se Jesu a se ba boleletseng mme batho ba ba letla. ");
INSERT INTO tsn_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Hong tonkana ya isiwa kwa go Jesu, barutwa ba baya diaparo mo mokwatleng wa yone gore Jesu a nne mo go tsone. ");
INSERT INTO tsn_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Hong ba le bantsi mo matshutitshuting ba ala diaparo tsa bone mo tseleng fa pele ga ga Jesu, fa ba bangwe ba latlhela dikala tsa ditlhare tse ba tswang go di rema kwa nageng. ");
INSERT INTO tsn_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","O ne a le fa gare ga dipopelelo, go na le boidiidi kwa pele le kwa morago, ba goa ba re, “Tshela ka boleele Kgosi! Go sego yoo tlang ka leina la Morena! ");
INSERT INTO tsn_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Go sego bogosi jo o bo lereng, Bogosi jwa ga Dafide rraetsho! Modimo boloka kgosi!” ");
INSERT INTO tsn_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Mme hong a tsena mo Jerusalema a ya mo Tempeleng. Mme ya re a sena go leba dilo tsotlhe, ka kelotlhoko, a tswa a tsamaya, gonne go ne go setse go le maitseboa, a ya Bethania le barutwa ba gagwe ba ba lesome le bobedi. ");
INSERT INTO tsn_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","E rile moso o o latelang fa ba tloga mo Bethania, a tshwarwa ke tlala. ");
INSERT INTO tsn_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ya re kgakalanyana fa thoko ga tsela a bona setlhare sa mofeige se le matlhare a matala, hong a tsamaya a ya go bona gore a ga a kake a bona loungo mo go sone. Le fa go ntse jalo ga bo go se na sepe, e le matlhare fela, gonne e ne e ise e nne lobaka lwa maungo. ");
INSERT INTO tsn_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Hong Jesu a raya setlhare a re, “Ga o kitla o tlhola o ungwa gape!” Mme barutwa ba mo utlwa fa a bua jalo. ");
INSERT INTO tsn_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Mme e rile fa ba goroga mo Jerusalema a tsena mo Tempeleng a simolola go kgoromeletsa kwa ntle ba ba rekisang le ba ba rekang, a pitikolola ditafole tsa ba ba ananyang madi le maobo a ba ba rekisang maphoi, ");
INSERT INTO tsn_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","a kganela botlhe ba ba neng ba lere dilwana tsa thekiso. ");
INSERT INTO tsn_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","A ba raya a re, “Go kwadilwe mo dikwalong gore, ‘Ntlo ya me ya thapelo e tshwanetse go nna bonno jo dichaba tsotlhe di rapelelang mo go jone;’ mme lo setse lo e fetotse mongobo wa dinokwane.” ");
INSERT INTO tsn_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hong e rile baperesiti ba bagolo le baeteledipele ba Sejuta ba utlwa se o se dirileng ba simolola go loga maano a gore ba ka mmolaya jang. Mathata a bone e ne e le go boifa gore go tlaa tsoga mokubukubu gonne batho ba ne ba kgatlhegela thuto ya ga Jesu thata. ");
INSERT INTO tsn_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mo maitseboeng ao jaaka gale ba ne ba tloga mo motsing. ");
INSERT INTO tsn_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Letsatsi le le latelang, fa barutwa ba feta fa setlharing sa mofeige se o se hutsitseng, ba bona gore se omeletse go simologa kwa meding! ");
INSERT INTO tsn_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Hong Petere a gakologelwa se Jesu a neng a se raya setlhare maabane, mme a re “Bona, Moruti! setlhare sa mofeige se o se hutsitseng se omeletse!” ");
INSERT INTO tsn_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Mo karabong ya gagwe, Jesu a raya barutwa a re, “Fa lo na le tumelo mo Modimong, boammaaruri jo e leng jone ke jo, lo ka raya thaba ya Lotlhware lwa re, ‘Manologa o wele mo teng ga lewatle’, mme taolo ya lona e tlaa diragala. Se se tlhokegang fela ke gore lo dumele lo sa belaele! ");
INSERT INTO tsn_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ntheetsang! Lo ka rapelela le fa e le eng, mme fa lo dumela, lo tlaa se amogela! ");
INSERT INTO tsn_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mme fa lo rapela, pele itshwareleng ba lo nang le melato le bone gore Rraeno yo o kwa legodimong a lo itshwarele dibe le lona.” ");
INSERT INTO tsn_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","28","Ka nako e ba bo ba gorogile mo Jerusalema gape, mme ya re a tsamaya mo felong ga Tempele, baperesiti ba bagolo le ba bangwe ba baeteledipele ba Sejuta ba tla kwa go ene ba mo raya ba re, “Go diragalang fano? Ke mang yo o go neileng nonofo ya go lelekela babapatsi kwa ntle?” ");
INSERT INTO tsn_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Mme Jesu a ba araba a re, “Ke tla lo bolelela fa lo ka araba potso e le nngwe fela! ");
INSERT INTO tsn_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Lwa reng ka Johane wa Mokolobetsi? A o ne a romilwe ke Modimo kgotsa nnyaa? Nkarabang!” ");
INSERT INTO tsn_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mme ba buisanya ka ga potso eo ba re, “Fa re araba re re o romilwe ke Modimo, o tlaa re, ‘Go siame, ke ka ntlha yang lo ne lo sa mo dumele’ ");
INSERT INTO tsn_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mme fa re re Modimo o ne o sa mo roma, hong batho ba tlaa tsosa mokubukubu,” (Gonne batho botlhe ba dumela fa Johane e ne e le moporofiti). ");
INSERT INTO tsn_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hong ba re, “Ga re ka ke ra araba. Ga re itse.” Mme Jesu a fetola a re, “Le nna ga nkitla ke araba potso ya lona!” ");
INSERT INTO tsn_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tse ke ditshwantsho dingwe tsa dipolelo tse Jesu o kileng a di bolelela batho ka nako eo. Monna o kile a jala tshimo, mme a e agelela ka logora a ba a epa lehuti la go gamolela matute a moretlwa, a aga ntlo ya molebeledi. Hong a naya balemi tshimo go e thapa ka tuelo, mme a ya kwa lefatshing le le kgakala. ");
INSERT INTO tsn_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ka motlha wa thobo a romela mongwe wa badiri ba gagwe go tla go tsaya seabe sa gagwe sa thobo. ");
INSERT INTO tsn_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mme balemi ba itaya morongwa ba mmusetsa morago a sa tsaya sepe. ");
INSERT INTO tsn_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mme mong wa tshimo a romela mongwe gape wa badiri ba gagwe, yo le ene o neng a itewa fela jalo, ba mo itaya go gaisa wa pele, gonne o ne a ntshitswe dintho tse di boitshegang mo tlhogong. ");
INSERT INTO tsn_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Monna yo mongwe yo o neng a mo romile o ne a bolawa; mme morago, ba bangwe ba ne ba itewa kgotsa ba bolawa, ");
INSERT INTO tsn_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","go fitlhela go sala a le mongwe fela, ebong morwawe yo o tsetsweng a le esi. La bofelo a romela ene, a gopola gore ba tlaa mo tlotla. ");
INSERT INTO tsn_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Mme e rile fa balemi ba mmona a tla ba re, ‘Ke ene yo o tlaa tsayang tshimo fa rraagwe a a swa. Tlang re mmolayeng. Hong tshimo e tlaa nna ya rona!’ ");
INSERT INTO tsn_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Hong ba mo tshwara ba mmolaya ba latlhela setopo sa gagwe kwa ntle ga tshimo. ");
INSERT INTO tsn_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“O akanya gore mong wa tshimo o tlaa dirang fa a utlwa ka se se diragetseng? O tlaa tla a ba bolaya botlhe, mme a neela ba bangwe tshimo eo. ");
INSERT INTO tsn_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","A ga lo ga kologelwe gore lo badile temana mo dikwalong? e e reng, ‘Lentswe le baagi ba neng ba le latlha le ne la nna lentswe la kgokgotsho, lentswe le le tlotlegang thata mo kagong! ");
INSERT INTO tsn_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Se ke tiro ya Modimo e bile ke selo se se gakgamatsang go bonwa.’ ” ");
INSERT INTO tsn_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Baeteledipele ba Bajuta ba ne ba batla go mo tshwara teng foo, ka ntlha ya go dirisa setshwantsho se, gonne ba ne ba itse gore o raya bone, e ne e le balemi ba ba bosula mo polelong ya gagwe. ");
INSERT INTO tsn_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mme ba romela bangwe ba baeteledipele ba tumelo le ba dipolotiki go bua le ene le go leka go mo lalela gore a tle a bue sengwe se ba ka lekang go mo tshwara ka sone. ");
INSERT INTO tsn_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mme ditlhola tse tsa re, “Moruti, re itse gore o bolela boammaaruri le fa go ntse jang! Ga o tlhotlhelediwe ke dikakanyo le dikeletso tsa batho, mme o ruta ditsela tsa Modimo sentle. Jaanong re bole lele, a go siame go duela lekgetho la Roma, kgotsa nnyaa?” ");
INSERT INTO tsn_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesu a bona leano la bone mme a re, “Ntshupegetsang ledi mme ke tlaa lo bolelela.” ");
INSERT INTO tsn_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","E rile fa ba le mo naya a re, “Setshwantsho se le mokwalo ke tsa ga mang?” Ba mo raya ba re, “Ke tsa ga Kaesara.” ");
INSERT INTO tsn_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mme Jesu a ba raya a re, “Go siame, fa e le gore ke tsa gagwe, mo neyeng ditsa gagwe. Mme tse eleng tsa Modimo di tshwanetse go newa Modimo!” Mme ba simolola go ingwaya ditlhogo ka ntlha ya go palelwa ke karabo ya gagwe. ");
INSERT INTO tsn_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hong Basadukai ba tla kwa go ene, e le setlhopha sengwe sa banna se se reng ga go na tsogo ya baswi. Potso ya bone ke e: ");
INSERT INTO tsn_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Moruti, Moshe o re neile molao gore fa motho a a swa a sena bana, a monnawe a tseye mosadi wa gagwe mme a nne le bana le ene mo leineng la ga mogolowe. ");
INSERT INTO tsn_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","22","Go kile ga bo go le bomorwa motho ba supa mme yo mo tona a nyala, a swa a sena bana. Jalo monnawe a nyala motlholagadi yoo mme le ene a akofa a swa a sena bana. Mme yo mongwe a mo nyala le ene a swa a sena bana ga tswelela jalo go fitlhelela ba a swa botlhe. Mme le gona go ne go sena bana; morago ga moo mosadi le ene a swa. ");
INSERT INTO tsn_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","“Se re batlang go se itse ke se—Mo tsogong ya baswi, e tlaa nna mosadi wa ga mang gonne e ne e le mosadi wa bone botlhe?” ");
INSERT INTO tsn_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesu a araba a re, “Molato wa lona ke gore ga lo itse dikwalo, le fa e le nonofo ya Modimo. ");
INSERT INTO tsn_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Gonne e tlaa re fa batho ba ba supang ba, le mosadi ba tsoga mo baswing, ba tlaa bo ba sa nyala mme ba tlaa bo ba tshwana le baengele. ");
INSERT INTO tsn_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Mme kaga tsogo ya baswi a ga lo ise lo ke lo bale mo lokwalong lwa ga Ekesodo ka ga Moshe le setlhare se se tukang? Modimo o ne wa raya Moshe wa re, ‘Ke Modimo wa ga Aberahame, Isake le Jakobe’. ");
INSERT INTO tsn_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","“Modimo o ne o bolelela Moshe gore batho ba, le fa ba sule mo dingwageng tse di makgolokgolo tse di fetileng, ba ne ba sa ntse ba tshela, gonne o ka bo o se ka wa re, ‘Ke Modimo wa ba ba seong!’ Lo dirile phoso e tona.” ");
INSERT INTO tsn_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mme mongwe wa baruti ba tumelo yo o neng a eme foo a reeditse puisanyo ya bone a lemoga gore Jesu o arabile sentle. Hong a botsa a re, “Mo melaong yotlhe, ke ofe wa botlhokwa?” ");
INSERT INTO tsn_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesu a araba a re, “Ke o o reng, ‘Utlwa wena Iseraele! Morena Modimo wa rona ke ene Modimo a le nosi. ");
INSERT INTO tsn_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mme o tshwanetse go mo rata ka pelo yotlhe ya gago le ka mowa le ka tlhaloganyo le ka thata yotlhe ya gago.’ ");
INSERT INTO tsn_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","“Wa bobedi wa re, ‘O tshwanetse go rata ba bangwe fela jaaka o ithata;’ ga go na melao epe e e fetang e.” ");
INSERT INTO tsn_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mme Moruti wa tumelo a araba a re, “Morena o buile boammaaruri fa o re go na le Modimo o le mongwe fela mme ga go na ope gape. ");
INSERT INTO tsn_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mme ke itse gore go tlhokega thata go mo rata ka pelo yotlhe ya me le ka kitso, le go rata ba bangwe jaaka ke ithata, go na le go ntsha mehuta yotlhe ya ditlhabelo mo aletareng ya Tempele.” ");
INSERT INTO tsn_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Mme e rile Jesu a lemoga go tlhaloganya ga monna yo a re, “Ga o kgakala le Bogosi jwa Modimo.” Mme morago ga moo ga seka ga tlhola ga nna le ope yo o pelokgale go mmotsa dipotso. ");
INSERT INTO tsn_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ya re morago Jesu a ntse a ruta batho mo tikologong ya Tempele, a ba botsa potso e: “Ke eng fa baruti ba tumelo ya lona ba re, Mesia o tshwanetse a bo a le wa lotso lwa ga Kgosi Dafide? ");
INSERT INTO tsn_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dafide ka esi o buile ka Mowa o o Boitshepo a re, ‘Modimo o reile Morena wa me wa re, nna ka fa letsogong ja me je legolo, ke be ke tle ke dire baba ba gago sebeo sa dinao tsa gago.’ ");
INSERT INTO tsn_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","E re ka Dafide a ne a mmitsa Morena wa gagwe, o ka nna morwawe jang?” (Kakanyo e ya itumedisa bontsintsi jwa batho, mme ba mo reetsa ka kgatlhego e kgolo thata.) ");
INSERT INTO tsn_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Dilo dingwe tse a di ba rutileng ka nako eo ke tse: “Itlhokomeleng mo baruting ba tumelo! Gonne ba rata go apara diaparo tsa bahumi le tsa barutegi, le gore batho botlhe ba ba ikobele fa ba tsamaya mo marekisetsong. ");
INSERT INTO tsn_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ba rata go nna mo ditilong tse di kwa pele mo ditempeleng le manno a tlotlo mo medirong, ");
INSERT INTO tsn_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","mme ga ba tlhabiwe ke ditlhong go tsietsa batlholagadi mo matlung a bone, tota ba fitlha gore ke batho ba mekgwa e e ntseng jang, ba dira jaaka o ka re ba obamela Modimo ka go rapela dithapelo tse di telele mo ponong ya batho. Ka ntlha ya go dira jalo katlholo ya bone e tlaa nna e kgolo.” ");
INSERT INTO tsn_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Hong a ya fa letloleng la madi a Tempele a nna fa fatshe a lebelela fa bontsi jwa batho bo ntse bo latlhela madi. Bangwe ba ba neng ba humile ba ne ba latlhela a magolo. ");
INSERT INTO tsn_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Hong ga tla mosadi wa motlholagadi wa mohumanegi a tla a latlhela dithebe di le pedi. ");
INSERT INTO tsn_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","A biletsa barutwa ba gagwe kwa go ene a re, “Mohumanegi yole wa motlholagadi o ntshitse mo go golo go feta gotlhe ga bahumi go kopantswe! Gonne bone ba ntshitse mo go botlana, ga dikhumo tsa bone, fa ene a ntshitse thebe ya gagwe ya bofelo.” ");
INSERT INTO tsn_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mme ya re a tswa mo Tempeleng ka letsatsi leo, mongwe wa barutwa ba gagwe a re, “Moruti, dikago tse di dintle jang! Bona mekgabisa ya maje a a mo lokotswaneng jaaka e ntse.” ");
INSERT INTO tsn_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesu a araba a re, “Ee, bona! gonne ga go na leje lepe le le tlaa tlogelwang le tlhatlaganye le le lengwe, otlhe a tlaa fetoga matlotla.” ");
INSERT INTO tsn_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Mme ya re a ntse mo dithoteng tsa thaba ya Lotlhware go kgabaganya molatswana o o tswang Jerusalema, Petere le Jakobe le Anterea le Johane ba bo ba na nae mme ba mmotsa ba re, “Dilo tse tsotlhe di tlaa diragalela Tempele leng? A go tlaa nna le tlhagiso pele ga nako?” ");
INSERT INTO tsn_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Hong Jesu a dirisa nako e ntsi ya go ba tlhalosetsa a re, “Lo se letle ope go lo timetsa, ");
INSERT INTO tsn_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","gonne ba le bantsi ba tlaa tla ba ikaya fa e le Mesia wa lona, mme ba tlaa timetsa ba le bantsi. ");
INSERT INTO tsn_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mme go tlaa tsoga dintwa gongwe le gongwe mme mo ga se sesupo sa bokhutlo. ");
INSERT INTO tsn_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","“Gonne dichaba le mebuso di tlaa tsogologelana, mme go tlaa nna dithoromo tsa lefatshe mo mafelong a le mantsi le mauba. Mme dilo tse e tlaa bo e le dikai tsa ntlha tsa dipogisego tse di tlang. ");
INSERT INTO tsn_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Mme fa dilo tse di simolola go diragala, lo tlhokomele! Gonne lo tlaa bo lo le mo diphatseng tse dikgolo. Lo tlaa gogelwa fa pele ga basekisi, mme lo tlaa itewa mo ditempeleng, lo tlaa ema fa pele ga balaodi le dikgosi ka ntlha ya go nna balatedi ba me. Se e tlaa bo e le nako ya lona ya go ba bolelela Mafoko a a Molemo. ");
INSERT INTO tsn_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Gonne Mafoko a a Molemo a tshwanetse go itsiwe mo merafeng yotlhe pele ga bokhutlo bo tla. ");
INSERT INTO tsn_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mme fa lo tshwarwa lo bo lo sekisiwa, lo se ka lwa tshwenyega kaga se lo tlaa se buang go iphemela. Buang se Modimo o lo bolelelang gore lo se bue. Gonne e tlaa bo e se lona lo buang mme e le Mowa o o Boitshepo. ");
INSERT INTO tsn_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mme morwa rraa motho o tlaa neela morwa rraagwe go bolawa, borrabana ba tlaa neela bana ba bone, le bana ba tlaa neela batsadi ba bone gore ba bolawe. ");
INSERT INTO tsn_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mme lo tlaa ilwa ke mongwe le mongwe ka ntlha ya gore lo ba me. Mme botlhe ba ba tlaa itshokang go ya bokhutlong ba sa intatole ba tlaa bolokwa. ");
INSERT INTO tsn_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Mme fa lo bona selo se se makgapha se eme mo Tempeleng, mmadi, ela tlhoko! Tshaba, o tshabele kwa dithabeng tsa Judea fa go kgonega. ");
INSERT INTO tsn_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","16","Akofa! Fa o le mo setlhoeng fa godimo ga ntlo, o se ka wa boela mo tlung. Fa o le kwa masimo, o se ka wa boela kwa gae go ya go tsaya madi kgotsa diaparo. ");
INSERT INTO tsn_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","“A bo go latlhega basadi ba baimana mo malatsing ao, le basadi ba ba amusang. ");
INSERT INTO tsn_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mme lo rapele gore go sia ga lona go se ka ga nna go le mariga. ");
INSERT INTO tsn_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Gonne malatsi ao e tlaa bo e le metlha ya pitlagano e e iseng e ke e nne teng fa e sa le kwa tlholegong ya lefatshe, mme ga go kitla go nna gape jalo. ");
INSERT INTO tsn_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kwa ntle ga gore Morena a khutshwafatse nako eo ya kutlobotlhoko, ga go na le fa e le mowa ope mo lefatsheng o o tlaa bolokesegang, mme ka ntlha ya ba o ba ikgethetseng o tlaa khutshwafatsa malatsi ao. ");
INSERT INTO tsn_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Mme fa mongwe a lo raya a re, ‘Yo ke Mesia’, kgotsa ‘ke yole’, lo se ka lwa mo ela tlhoko. ");
INSERT INTO tsn_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Gonne go tlaa nna bo-Mesia ba le bantsi ba tsietso le baporofiti ba tsietso ba ba tlaa dirang dikgakgamatso tse dintsi tse di tlaa timetsang ba le bantsi, le e leng bone bana ba Modimo tota. ");
INSERT INTO tsn_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Elang tlhoko! Ke lo tlhagisitse! ");
INSERT INTO tsn_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Morago ga pitlagano eo, letsatsi le tlaa fifala mme ngwedi ga a kitla a phatsima. ");
INSERT INTO tsn_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Dinaledi di tlaa wa, magodimo a tlaa reketlisiwa. ");
INSERT INTO tsn_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Hong batho botlhe ba tlaa mpona, Nna Morwa Motho ke tla ke le mo marung ka nonofo e kgolo le kgalalelo. ");
INSERT INTO tsn_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mme ke tlaa romela baengele ba me go tla go phutha botlhe baitshenkedwi ba me go tswa mo tikologong yotlhe ya lefatshe le legodimo. ");
INSERT INTO tsn_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Jaanong, thuto ke e ka setlhare sa mofeige. Fa dikala tsa one di simolola go kukunya le makakaba a simolola go tlhoga, lo itse sentle fela gore selemo se setse se gorogile. ");
INSERT INTO tsn_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","“Mme fa lo bona dilo tse di diragala tse ke setseng ke tswa go di tlhalosa, lo ka tlhomamisa gore go tla ga me go setse go le gaufi, le gore ke setse ke le mo kgorong. ");
INSERT INTO tsn_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","“Ee, tse ke ditiragalo tse di kayang nako ya bokhutlo. ");
INSERT INTO tsn_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Legodimo le lefatshe di tlaa nyelela, mme Lefoko la me le emetse ruri. ");
INSERT INTO tsn_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Le fa go ntse jalo, ga go na ope, le fa e le baengele mo legodimong, le fa e le nna, ga ke itse letsatsi le fa e le nako e dilo tse di tlaa diragalang ka yone; fa e se Rara fela yo o itseng. ");
INSERT INTO tsn_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mme ere ka lo sa itse gore go tlaa diragala leng, nnang lo itisitse. Nnang ka kelotlhoko kaga go boa ga me. ");
INSERT INTO tsn_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Go tla ga me go ka tshwantshiwa ka monna yo o neng a tsamaya a ya kwa lefatsheng le sele, yo o neng a baya tiro yotlhe ya gagwe mo batlhankeng ba gagwe go e dira fa a sa ntse a seyo a tsamaile, mme a raya motlhokomedi wa kgoro a re, a lebelele go boa ga gagwe. ");
INSERT INTO tsn_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","37","“Nnang lo lebeletse thata! Gonne ga lo itse gore a go tla ga me go tlaa bo go le maitseboa, bosigo, phakela kgotsa motshegare. Lo se ka lwa letla gore ke lo fitlhele lo robetse. Disang go bowa ga me! se ke molaetsa wa me mo go lona le mo go botlhe ba bangwe.” ");
INSERT INTO tsn_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mme Modiro wa Tlolaganyo wa simologa morago ga malatsi a le mabedi, e le letsatsi la boitapoloso la Bajuta la ngwaga le ngwaga le go neng go sa jewe senkgwe se se bedisitsweng, baperesiti ba bagolo le ba bangwe baeteledipele ba Sejuta ba bo ba sa ntse ba batla leano le ba ka tshwarang Jesu ka lone ka sephiri go mmolaya. ");
INSERT INTO tsn_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mme ba re, “Ga re ka ke ra dira jalo ka letsasi la modiro wa Tlolaganyo, e ka re kgotsa ga nna pheretlhego.” ");
INSERT INTO tsn_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ka lobaka loo Jesu o ne a le kwa Bethania, mo tlung ya ga Simone wa molepero; ka nako ya dijo tsa maitseboa, mosadi mongwe a tla a tshotse kurwana ya setlolo se se tlhwatlhwa kgolo se se nkgang monate. Hong a thuba kurwana, a tshela setlolo mo tlhogong ya gagwe. ");
INSERT INTO tsn_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Bangwe ba ba neng ba le fa lomating lwa bojelo ba galefa thata kaga “tshenyo” eo, ka fa ba neng ba bua ka teng. Ba re, “O ka bo a rekisitse setlolo seo ka tlhwatlhwa e e kwa godimo mme a naya bahumanegi madi ao!” ");
INSERT INTO tsn_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mme Jesu a re, “Mo leseng, lo mo omanyetsang ka go dira selo se se molemo. ");
INSERT INTO tsn_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Gonne lo na le bahumanegi malatsi otlhe mme ba tlhoka thuso mo go lona thata, lo ka kgona go ba thusa nako nngwe le nngwe e lo batlang go ba thusa ka yone; mme ga ke na go nna le lona ka lobaka lo lo leele. ");
INSERT INTO tsn_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","O dirile se a neng a ka se kgona, mmele wa me o o tloleditse phitlho go sa le gale. ");
INSERT INTO tsn_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mme ke lo bolelela ka tlhwaafalo ya boammaaruri gore gongwe le gongwe kwa Mafoko a a Molemo a rerwang gone mo lefatsheng lotlhe, tiro ya mosadi yo, e tlaa nna e gakologelwa, e bo e galalediwa.” ");
INSERT INTO tsn_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mme Judase Isekariota, mongwe wa barutwa ba gagwe, a ya kwa ditlhogong tsa baperesiti go ya go rulaganya go ba okela Jesu. ");
INSERT INTO tsn_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Erile fa baperesiti ba bagolo ba utlwa gore o tletse eng ba itumela thata ba bo ba mo solofetsa tuelo. Hong a simolola go batla nako e e siameng le lefelo le o ka okelang Jesu mo go lone. ");
INSERT INTO tsn_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ka letsatsi la ntlha la modiro wa Tlolaganyo, letsatsi le go neng go ntshiwa ditlhabelo tsa dikonyana, barutwa ba gagwe ba mmotsa gore o rata go ya go jela modiro wa Tlolaganyo kae? ");
INSERT INTO tsn_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Mme a roma ba le babedi kwa Jerusalema go ya go dira dithulaganyo a ba raya a re, “E tlaa re fa lo sa ntse lo tsamaya, lo tlaa bona monna a tla a lebaganye le lona a rwele nkgwana ya metse. Lo mo sale morago. ");
INSERT INTO tsn_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mo tlung e o tsenang mo go yone, bolelelang mong-wa ntlo lo re, ‘Morena wa rona o re rometse go tla go bona ntlwana e lo e re baakanyeditseng, e re tlaa jelang modiro wa Tlolaganyo mo go yone maitseboeng ano!’ ");
INSERT INTO tsn_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","O tlaa lo isa kwa ntlwaneng e e kwa godimo e kgolo e e baakantsweng. Baakanyang dijo tsa rona gone.” ");
INSERT INTO tsn_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Mme barutwa ba babedi ba tswelela jalo ba tsena mo motsing ba fitlhela sengwe le sengwe se ntse jaaka Jesu a ba boleletse, mme ba baakanyetsa Tlolaganyo. ");
INSERT INTO tsn_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mo maitseboeng Jesu a goroga le barutwa ba bangwe, ");
INSERT INTO tsn_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","mme ya re ba ntse fa lomating lwa bojelo ba a ja, Jesu a re “Ammaaruri ke a lo raya mongwe wa lona o tlaa nkoka, mongwe wa lona yo o leng fano yo ke jang nae.” ");
INSERT INTO tsn_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mme ba tlala khutsafalo e kgolo botlhe, mme mongwe le mongwe wa bone a mmotsa a re, “A ke nna?” ");
INSERT INTO tsn_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mme a araba a re, “Ke mongwe wa lona ba ba lesome le bobedi yo ke jang nae fano gompeino. ");
INSERT INTO tsn_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ke tshwanetse go swa, fela jaaka baporofiti ba boletse bogologolo; mme a bo go latlhega monna yo o nkokang. Go ka bo go le molemo fa a ka bo a sa tsalwa.” ");
INSERT INTO tsn_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ya re ba ntse baa ja Jesu a tsaya senkgwe a se segofatsa a se ngathoganya a se ba naya a re, “Jaang se, ke mmele wa me.” ");
INSERT INTO tsn_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","A tsaya senwelo sa mofine a leboga Modimo kaga sone a se ba naya, mme botlhe ba a nwa mo go sone. ");
INSERT INTO tsn_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Mme a ba raya a re, “Se ke madi a me, a a tshololetsweng batho ba le bantsi, a a kanelang kgolagano e ncha ya Modimo le batho. ");
INSERT INTO tsn_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ammaaruri ke a lo raya ga nke ke tlhola ke e nwa loungo lwa mofine go fitlhelela letsatsi le ke nwang mofuta o sele mo Bogosing jwa Modimo.” ");
INSERT INTO tsn_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Hong ba opela sefela mme ba ya kwa Thabeng ya Lotlhware. ");
INSERT INTO tsn_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mme Jesu a ba raya a re, “Lotlhe lo tlaa ntlogela, gonne Modimo o buile jaana ka baporofiti wa re, ‘Ke tlaa ya kwa Galalea go ya go kopana le lona teng.’” ");
INSERT INTO tsn_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","29","Petere a mo raya a re, “Nna ga nkake ka go tlogela le fa ba bangwe ba ka go tlogela!” ");
INSERT INTO tsn_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesu a re, “Petere, Pele ga koko e tonanyana e lela la bobedi ka moso mo mosong o tla bo o intatotse gararo.” ");
INSERT INTO tsn_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mme Petere a re, “Nnyaa! Le fa nkabo ke na le go swa nao ga nkake ka go itatola!” Mme ba ikana fela jalo botlhe. ");
INSERT INTO tsn_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Hong ba fitlha fa felong fa go bidiwang tshimo ya Gethesemane, a feta a raya barutwa ba gagwe a re, “Nnang fa, ke sa ntse ke ya go rapela.” ");
INSERT INTO tsn_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Mme a tsaya Petere, Jakobe le Johane a ya nabo, a simolola go fuduega thata le go tshwenyega. ");
INSERT INTO tsn_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","A ba raya a re, “Mowa wa me o hutsafetse thata mo ruri go isang losong; nnang fano, lo lebelele le nna.” ");
INSERT INTO tsn_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","A tsamaela fa pelenyana a wela fa fatshe, a rapela gore fa go ne go kgonega nako e e boitshegang e e mo letetseng e seka ya mo diragalela. ");
INSERT INTO tsn_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Mme a re, “Rara, Rara, dilo tsotlhe di ka diragala mo go wena. Tlosa senwelo se mo go nna. Le fa go ntse jalo ke batla thato ya gago, eseng ya me.” ");
INSERT INTO tsn_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Hong a boela kwa barutweng ba gagwe ba bararo a ba fitlhela ba robetse, a re, “Simone a o robetse? A o ne o sa ka ke wa leta le nna lobaka lwa oura e le nngwe fela? ");
INSERT INTO tsn_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","lebelelang le nna lo rapele gore moraedi a seka a lo fenya. Gonne le fa mowa o le tlhaga mmele o bokoa.” ");
INSERT INTO tsn_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mme a boa gape a ya go rapela, a boeletsa kopo ya gagwe. ");
INSERT INTO tsn_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","A boela gape kwa go bone a fitlhela ba robetse, gonne ba ne ba lapile thata. Ba bile ba sa itse ka fa ba ka mo fetolang ka teng. ");
INSERT INTO tsn_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","La boraro fa a boela kwa go bone a ba raya a re, “Tswelelang lo robale; Lo itapolose! Nnyaa! Nako ya go robala e setse e fetile! Bonang! ke okelwa mo diatleng tsa batho ba ba bosula. ");
INSERT INTO tsn_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tsogang! Re tshwanetse go tsamaya! yo o nkokang o gaufi!” ");
INSERT INTO tsn_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mme erile ka bonako a sa ntse a bua, Judase mongwe wa barutwa ba gagwe a goroga le setlhopha sa batho ba ba ipapanneng ka dichaka le melamu ba ba romilweng ke baperesiti ba bagolo le baeteledipele ba bangwe ba Sejuta. ");
INSERT INTO tsn_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judase o ne a ba boleletse gore, “Yo ke tlaa yang kwa go ene go mo dumedisa, lo itse gore ke ene mme lo mo tshware. Mme lo ka mo tsaya motlhofo.” ");
INSERT INTO tsn_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mme erile fela jaaka ba goroga, a tlhamalalela kwa go Jesu, a re, “Morena!” Mme a mo tlamparela ka tshupo ya botsalano jo bogolo. ");
INSERT INTO tsn_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jalo setlhopha sa batho sa mo tshwara. ");
INSERT INTO tsn_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Gone fela foo, mongwe a somola chaka, a kgaola motlhanka wa moperesiti yo mogolo tsebe. ");
INSERT INTO tsn_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesu a ba botsa a re, “A ke serukhutlhi se se diphatsa, gore lo bo lo tla ka tsela e lo tlang ka yone, lo tla kwa go nna lo ipapanne ka ditlhabano? ");
INSERT INTO tsn_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ke eng lo ile lwa seka lwa ntshwara kwa Tempeleng? Ke ne ke le teng koo, ke ruta letsatsi le letsatsi. Mme le fa go ntse jalo, dilo tse di dirafala gore di tlatse diperofeso tse di buang ka ga me.” ");
INSERT INTO tsn_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ka nakonyana, barutwa ba gagwe botlhe ba bo ba tshabile. ");
INSERT INTO tsn_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Mme le fa go ntse jalo ga bo go le lekawana lengwe le mo setse morago, le apere seaparo sa leloba e le seaparo sa bosigo. Ya re setlhopha seo se leka go mo tshwara, a falola, le fa go ntse jalo diaparo tsa gagwe tsa gagoga, a tshaba a sa ikatega. ");
INSERT INTO tsn_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Hong Jesu a isiwa kwa legaeng la Moperesiti yo Mogolo kwa bagolwane botlhe ba baperesiti le baeteledipele bangwe ba Sejuta ba neng ba phuthaganela teng. ");
INSERT INTO tsn_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Mme Petere a bo a mo setse morago a le kgakalanyana nae a ba a tla a tsena ka kgoro ya motse wa Moperesiti yo Mogolo a kotama fa molelong a nna fa gare ga batlhanka. ");
INSERT INTO tsn_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mo teng baperesiti ba bagolo le ba Kgotla kgolo ya tshekelo ya Sejuta ba ne ba leka go bona sengwe se ba ka pegang Jesu molato ka sone gore ba tle ba mmolaye. Mme ga se ka ga kgonega. ");
INSERT INTO tsn_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Basupi ba le bantsi ba maaka ba ne ba ithaopa, mme bosupi jwa bone jwa ganetsanya. ");
INSERT INTO tsn_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Lwa bofelo ga ema banna ba bangwe ba bua maaka ka ga gagwe ba re, ");
INSERT INTO tsn_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Re mo utlwile a re, ‘Ke tlaa senya Tempele e e agilweng ka diatla tsa batho mme mo malatsing a le mararo ke tlaa aga e nngwe e e sa dirwang ka diatla!’ ” ");
INSERT INTO tsn_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Le fa go ntse jalo ga ba ise ba ke ba bo ba bue polelo e e tlhamaletseng! ");
INSERT INTO tsn_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Hong Moperesiti yo mogolo a ema fa pele ga Lekgotla a botsa Jesu a re, “A o gana go arabela molato o? O na le eng se o ka iphemelang ka sone?” ");
INSERT INTO tsn_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mme Jesu a seka a araba. Hong Moperesiti yo mogolo a mmotsa a re, “A o Mesia, Morwa Modimo?” ");
INSERT INTO tsn_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesu a araba a re, “Ke ene, mme lo tlaa mpona ke ntse ka fa letsogong la Modimo le legolo, ke tla mo lefatsheng ka maru a legodimo.” ");
INSERT INTO tsn_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Hong moperesiti yo Mogolo a ikgagola diaparo a re, “Re sa ntse re tlhoka eng gape? Re sa ntse re tlhoka bosupi jwa eng? Lo setse lo utlwile tlhapatso ya gagwe. Katlholo ya lona ya reng?” Mme ba dumalana ka bongwe fela jwa pelo gore a atlholelwe loso. ");
INSERT INTO tsn_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mme bangwe ba bone ba simolola go mo kgwela mathe, ba mmipa sefatlhogo ba mo itaya ka mabole. Ba mo sotla ba re, “Ke mang yo o go iteileng moporofiti?” Ba mo nyonnyobetsa. Le masole tota a ne a mo itaya ka mabole fa a ntse a tsamaya nae. ");
INSERT INTO tsn_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Mme ka lobaka loo Petere o ne a le kwa tlase mo lolwapaneng. Mongwe wa basetsana ba ba neng ba direla Moperesiti yo Mogolo a lemoga Petere a ikomosa fa molelong. A tsepega Petere matlho a goa a re, “O ne o na le Jesu, wa Monasara.” ");
INSERT INTO tsn_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Petere a itatola a re, “Ga ke itse se o buang ka ga sone!” A tswela kwa ntle kwa mathuding a lolwapa. Gone fela foo koko e tonanyana ya lela. ");
INSERT INTO tsn_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mme morweetsana a mmona a eme foo a simolola go bolelela ba bangwe, a re, “Ke yole morutwa wa ga Jesu!” ");
INSERT INTO tsn_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petere a itatola gape. Moragonyana bangwe ba ba neng ba dikaganyeditse molelo ba simolola go raya Petere ba re, “Le wena o mongwe wa bone, gonne o tswa Galalea!” ");
INSERT INTO tsn_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","A simolola go tlhapatsa a ikana a re, “Ga ke mo itse monna yo lo buang ka ga gagwe.” ");
INSERT INTO tsn_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ka bonako koko e tonanyana ya lela lwa bobedi. Mme Petere a gakologelwa mafoko a ga Jesu a a reng, “Pele ga koko e tonanyana e lela lwa bobedi o tla a bo o intatotse gararo.” Mme a simolola go lela. ");
INSERT INTO tsn_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mme ya re mo mosong ditlhogo tsa bapereesiti le bagolwane ba phuthego, baruti ba tumelo le botlhe ba Kgotla kgolo, ba kopana go buisana kaga se ba neng ba tshwanetse go se dira. Maikaelelo a bone e ne e le gore masole a ise Jesu kwa go Pilatwe mmusi wa Seroma. ");
INSERT INTO tsn_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatwe a mmotsa a re, “A o Kgosi ya Bajuta?” Hong Jesu a fetola a re, “Ee, ke jaaka o bolela.” ");
INSERT INTO tsn_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","4","Hong baperesiti ba bagolo ba mmaya molato ka dilo di le dintsi, mme Pilatwe a mmotsa a re, “Ke ka ntlha yang fa o sa bue sepe? Wa reng ka ga melato e ba e go pegang.” ");
INSERT INTO tsn_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mme Jesu a seka a tlhola a bua sepe, mo go neng ga gakgamatsa Pilatwe thata. ");
INSERT INTO tsn_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mme jaana, e ne e le tlwaelo ya ga Pilatwe go golola legolegwa le le lengwe la Mojuta ngwaga e nngwe le e nngwe ka nako ya Paseka, legolegwa lengwe fela le batho ba lopang gore le gololwe. ");
INSERT INTO tsn_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mongwe wa magolegwa ka nako eo e ne e le Barabase yo o neng a atlhotswe le ba bangwe ka molato wa polao ya motho, ka nako ya ba tsogologela mmuso. ");
INSERT INTO tsn_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Hong lesomo la simolola go kokoanela Pilatwe, la mo kopa gore a golole legolegwa jaaka gale. ");
INSERT INTO tsn_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatwe a botsa a re, “Go ka nna jang gore ke lo gololele kgosi ya Bajuta? A ke ene yo lo batlang a gololwa?” ");
INSERT INTO tsn_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Gonne o ne a lemoga gore se ke segwenegwene, se se neng se tlhotlhelediwa ke baperesiti ba bagolo gonne ba ne ba fufegela go tuma ga ga Jesu. ");
INSERT INTO tsn_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mme ka nako e, baperesiti ba bagolo ba tlhotlheletsa lesomo gore le batle gore go gololwe Barabase boemong jwa ga Jesu. ");
INSERT INTO tsn_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mme Pilatwe a botsa a re, “Fa ke golola Barabase, Ke tlaa dirang ka monna yo lo mmitsang kgosi ya lona yo?” ");
INSERT INTO tsn_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mme ba goa ba re, “Mmapole!” ");
INSERT INTO tsn_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatwe a ba galefela a re, “Ka ntlha yang? O dirileng sa bosula?” Ba tswelela ba goa thata ba re, “Mmapole!” ");
INSERT INTO tsn_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Mme Pilatwe ka ntlha ya go tshaba mokubukubu gape a rata go itumedisa batho, a ba gololela Barabase. A laola gore ba iteye Jesu ka kubu, a ba mo neela gore a bapolwe. ");
INSERT INTO tsn_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","17","Mme, masole a Roma a mo tsaya a mo isa kwa teng ga lolwapa lwa bogosi, ba bitsa mapodise a kgotla otlhe, ba mo apesa kobo e e bohibidu jo bo mokgona, ba mo direla serwalo sa mitlwa e meleele ba se mo rwesa. ");
INSERT INTO tsn_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ba simolola go mo dumedisa ba re, “Ahee! Kgosi ya Bajuta!” ");
INSERT INTO tsn_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mme ba mo itaya mo tlhogong ka lotlhaka ba mo kgwela mathe, ba khubama ka mangole ba mo “obamela”. ");
INSERT INTO tsn_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Erile ba sena go lapisiwa ke go mo sotla, ba mo apola seaparo sa gagwe se se bohibidu jo bo mokgona, mme ba mo apesa diaparo tsa gagwe gape, ba mo kgwakgwaetsa go ya go bapolwa. ");
INSERT INTO tsn_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Simone wa Kurene yo o neng a tswa kwa ga bone ka nako eo, a patelediwa go sikara mokgoro wa ga Jesu. (Simone ke rraagwe Alekasantarea le Rufase). ");
INSERT INTO tsn_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mme ba tsaya Jesu ba mo isa kwa felong fa go bidiwang Gologotha (Ke gore felo ga logata). ");
INSERT INTO tsn_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ba mo naya mofine o o tlhakantsweng le ditlhare tse di babang mme a o gana. ");
INSERT INTO tsn_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mme ba mmapola, ba tshelela diaparo tsa gagwe bola. ");
INSERT INTO tsn_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","E ne e ka ne e le ka nako ya bofera-bongwe mo mosong fa papolo e diragala. ");
INSERT INTO tsn_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Lokwalo lo lo bolelang molato wa gagwe lo ne lo kokotetswe mo mokgorong fa godimo ga tlhogo ya gagwe lo balega jaana, “Kgosi ya Bajuta.” ");
INSERT INTO tsn_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mme ga bo go bapotswe nae magodu a le mabedi mo mosong oo, mekgoro ya bone e tsentse wa gagwe fa gare. ");
INSERT INTO tsn_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mme lokwalo lwa diragadiwa lo lo reng, “O baletswe le baleofi.” ");
INSERT INTO tsn_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Batho ba ne ba mo kgala fa ba feta, ba tshikinya ditlhogo tsa bone ka tshotlo, ba goeletsa kwa go ene ba re, “Ahee! Ipone jaanong; Ammaaruri o ka senya Tempele wa ba wa e aga mo malatsing a le mararo! Fa e le gore o nonofile go le kalo, ipoloke o fologe mo mokgorong.” ");
INSERT INTO tsn_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Baperesiti ba bagolo le baeteledipele ba tumelo le bone ba bo ba eme foo ba sotla Jesu. Ba re, “O botlhale thata go boloka ba bangwe, mme ene ga a kgone go ipoloka!” ");
INSERT INTO tsn_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ba goa ba re, “Hee, wena Mesia!” “Wena Kgosi ya Iseraela! Fologa mo mokgorong mme re tlaa go dumela!” Le magodu a mabedi tota a a neng a swa nae a mo kgoba. ");
INSERT INTO tsn_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Erile e ka ne e le motshegare wa sethoboloko, lefatshe lotlhe la fifala go fitlhelela ka nako ya boraro mo tshokologong eo. ");
INSERT INTO tsn_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Hong Jesu a bitsa ka lentswe le legolo a re, “Eli, Eli Lamasabakatani?” (“Modimo wa me, Modimo wa me, o ntatlhetseng?”) ");
INSERT INTO tsn_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bangwe ba batho ba ba neng ba eme foo ba gopola gore o ka ne a bitsa Elija moporofiti. ");
INSERT INTO tsn_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Hong mongwe a tla a taboga a ina ngami mo mofineng o o botlha a e tlhomela ka lotlhaka a re, “A re ke re bone gore a Elija o tlaa tla go mo folosa.” ");
INSERT INTO tsn_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Mme sesiro mo Tempeleng sa gagoga ka bogare go simologa kwa godimo go ya kwa tlase. ");
INSERT INTO tsn_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","E rile fa lesole la Se-Roma le le neng le eme gaufi le mokgoro wa gagwe le bona ka fa o neng a neela mowa wa gagwe ka gone la re, “Ruri e ne e le Morwa Modimo!” ");
INSERT INTO tsn_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Basadi bangwe ba bo ba le foo ba lebeletse ba le kgakala, e le Marea Magatalena, Marea (mmaagwe Jakobe yo mmotlana le Josese), Salome le ba bangwe. ");
INSERT INTO tsn_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bone le basadi ba bangwe ba bantsi ba Galalea ba e neng e le balatedi ba gagwe ba mo direla fa a le kwa Galalea, ba tsile nae mo Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Dilo tse tsotlhe di ne tsa diragala pele ga Sabata. Mme ya re tshokologong ya letsatsi leo Josefe wa Arimathea, yo o neng a le leloko le le tlotlegang la Kgotla Kgolo ya Sejuta (yo o neng a lebeletse go tla ga Bogosi jwa Modimo), a nna pelokgale go ya kwa go Pilatwe go lopa setopo sa ga Jesu. ");
INSERT INTO tsn_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatwe o ne a sa dumele gore Jesu o ne a setse a sule, hong a bitsa mogolwane wa Roma a mmotsa. ");
INSERT INTO tsn_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mogolwane a tlhomamisa mafoko ao, Pilatwe a raya Josefe a re, “O ka nna wa tsaya setopo.” ");
INSERT INTO tsn_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mme Josefe a ya go reka letsela le letelele la leloba a pagolola setopo sa ga Jesu mo mokgorong, a se phuthela ka letsela leo a se baya mo phupung e e neng e gabilwe mo lefikeng, a pitikela leje mo kgorong ya phupu. ");
INSERT INTO tsn_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Marea Magatalena le Marea MmaJosese ba ne ba le teng ba lebile Jesu fa a fitlhwa. ");
INSERT INTO tsn_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","2","Mme mo maitseboeng a a latelang, fa Sabata e setse e fetile, Marea Magatalena le Salome le Marea mmaagwe Jakobe ba tsamaya ba ya go reka ditlolo go tlotsa setopo sa ga Jesu. Mo maphakeleng a magolo a letsatsi le le latelang fa letsatsi le tlhaba, ba tsaya ditlolo tseo ba ya natso kwa phupung. ");
INSERT INTO tsn_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mo tseleng ba bo ba ntse ba buisanya ka gore ba tlaa feta ba tlosa jang letlapa le legolo fa kgorong ya phupu. ");
INSERT INTO tsn_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mme ya re ba goroga ba leba ba bona gore letlapa le legolo le le bokete thata, le ne le setse le tlositswe mme kgoro ya lebitla ya bo e setse e bulegile! ");
INSERT INTO tsn_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Hong ba tsena mo phupung, mme mo letsogong le legolo ga bo go ntse lekau le apere diaparo tse di tshweu. Mme basadi ba gamarega. ");
INSERT INTO tsn_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mme moengele a re, “Se boifeng. A ga lo batle Jesu wa Monasara yo o neng a bapotswe? Ga a yo fa! Bonang fa mmele wa gagwe o neng o robaditswe teng. ");
INSERT INTO tsn_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jaanong tsamayang lo ise molaetsa o kwa barutweng ba gagwe le kwa go Petere lo re: Jesu o lo eteletse pele go ya Galalea; lo tlaa mmona gone, fela jaaka a lo boleletse pele ga aa swa!” ");
INSERT INTO tsn_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Basadi ba taboga ba tswa fa phupung, ba roroma ba tshogile thata mo ba neng ba palelwa ke go bua. ");
INSERT INTO tsn_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","E ne e le maphakela ka letsatsi la Tshipi mo mosong fa Jesu a tsoga mo baswing, mme motho wa ntlha go mmona e ne e le Marea Magatalena, mosadi yo Jesu o kileng a kgoromeletsa ntle mewa e e maswe e supa mo go ene. ");
INSERT INTO tsn_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Hong a fitlhela barutwa ba lela ka kutlobotlhoko mme a ba bolelela gore o bonye Jesu, le gore o tshedile. Mme ga ba a ka ba mo dumela! ");
INSERT INTO tsn_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Morago ga letsatsi leo a iponatsa mo go ba babedi ba ba neng ba tsamaya ba tswa Jerusalema ba ya kwa nageng, mme ga ba a ka ba mo lemoga lwa ntlha ka gore o ne a fetogile setshwano. ");
INSERT INTO tsn_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Mme ya re kwa bofelong fa ba lemoga gore ke mang, ba tabogela kwa Jerusalema go ya go bolelela ba bangwe, mme ga se ka ga nna le yo o ba dumelang. ");
INSERT INTO tsn_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kwa moragonyana a iponatsha mo barutweng ba ba lesome le motso ba sa ntse ba a ja. Mme a ba omanyetsa thata go tlhoka go dumela ga bone, ka botlhogo-e-thata jwa bone le go gana go dumela ba ba mmonyeng a sena go tsoga. ");
INSERT INTO tsn_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Mme a ba raya a re, “Lo tshwanetse go ya mo lefatsheng lotlhe lwa rerela mongwe le mongwe Mafoko a a Molemo, gongwe le gongwe. ");
INSERT INTO tsn_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ba ba dumelang ba bo ba kolobediwa ba tlaa bolokwa. Mme ba ba ganang go dumela ba tlaa sekisiwa. ");
INSERT INTO tsn_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mme ba ba dumelang ba tlaa dirisa thata ya me go kgoromeletsa ntle mewa e e maswe, ba tlaa bua dipuo tse di ncha. ");
INSERT INTO tsn_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ba tlaa nna le thata ya go tshwara dinoga ba babalesegile, mme fa ba a nwa le fa e le eng se se bolayang ga se kitla se ba utlwisa botlhoko: Ba tlaa kgona go baya balwetse diatla ba ba fodisa.” ");
INSERT INTO tsn_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Erile Morena Jesu a sena go fetsa go bua le bone, a tsholelediwa kwa legodimong a ya go nna ka fa letsogong le legolo la Modimo. ");
INSERT INTO tsn_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Mme barutwa ba tswa ba ya gongwe le gongwe ba rera, mme Morena a bo a na le bone, a tlhomamisa se ba se buang ka dikgakgamatso tse di diragalang morago ga melaetsa ya bone.");
INSERT INTO tsn_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Go tsala e e ratang Modimo. Dipolelo tse dintsi kaga Keresete di setse di kwadilwe di dirisiwa ka maitshegeletso a tsone jaaka dipolelo mo go rona go tswa mo barutweng ba pele le ba bangwe ba ba di boneng ka matlho. ");
INSERT INTO tsn_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Le fa go ntse jalo, go ne ga diragala mo go nna gore go ka siama fa nka boelela dipolelo tse gape go simolola ka palo ya ntlha go ya kwa go ya bofelo morago ga tlhotlhomiso tota ke be ke lo bolelela polelo e. ");
INSERT INTO tsn_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Go lo tlhomamisetsa boammaaruri kaga se lo se rutilweng. ");
INSERT INTO tsn_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Polelo ya me e simologa ka Moperesiti wa Sejuta, ebong Sakarea yo o tshedileng ka lobaka lwa Herode e le kgosi ya Judea. Sakarea e ne e le leloko la batsamaisi ba Tempele ya ga Abija, (mosadi wa gagwe Elisabetha le ene o ne a tshwana le ene e le leloko la baperesiti ba morafe wa Sejuta, wa losika lwa ga Arone.) ");
INSERT INTO tsn_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakarea le Elisabetha e ne e le batho ba ba boifang Modimo, ba tlhokometse go utlwa melao yotlhe ya Modimo mo moweng le mo lokwalong. ");
INSERT INTO tsn_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mme ba ne ba sena bana, gonne Elisabetha e ne e le moopa; mme ka bobedi jwa bone ba bo ba tsofetse thata. ");
INSERT INTO tsn_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Ka letsatsi lengwe ya re Sakarea a tsamaisa tiro ya gagwe mo Templeng, gonne lesomo la gagwe le ne le le mo tirong mo bekeng eo, tlotlego ya mo tlela ya go tsena mo felong ga Boitshepo go ya go fisa mashwalo fa Pele ga Modimo. ");
INSERT INTO tsn_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ka lobakanyana, bontsi jwa kokoano ya batho jwa emela kwa ntle ga Tempele, ba rapela jaaka ba tle ba dire fa mashwalo a fisiwa. ");
INSERT INTO tsn_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","12","Sakarea o ne a le mo felong ga boitshepo fa ka tshoganetso Moengele a iponatsa mo go ene, a eme ka fa letsogong le legolo la sebeso sa ma-shwalo! Sakarea o ne a tshogile ebile a gamaregile. ");
INSERT INTO tsn_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mme moengele a mo raya a re, “Se boife, Sakarea! Gonne ke tletse go go bolelela gore Modimo o utlwile thapelo ya gago le mosadi wa gago Elisabetha o tlaa tshola ngwana wa mosimane! Mme o tlaa mo raya leina o re Johane. ");
INSERT INTO tsn_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ka bobedi jwa lona lo tlaa nna le boipelo jo bogolo le boitumelo ka botsalo jwa gagwe, mme ba le bantsi ba tla ipela le lona. ");
INSERT INTO tsn_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Gonne e tlaa nna mongwe wa batho ba bagolo ba Morena. A se ka a nwa mofine kgotsa seno se se tagisang-gonne o sa le a tladitswe ka Mowa o o Boitshepo, le e leng pele ga a tsalwa! ");
INSERT INTO tsn_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mme o tlaa tlhotlheletsa Bajuta ba le bantsi go sokologela mo go Morena Modimo wa gagwe. ");
INSERT INTO tsn_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","E tlaa nna motho yo o mowa o makgawekgawe a nonofile jaaka Elija, moporofiti yo mogolo; mme o tlaa etelela pele go tla ga ga Mesia, a baakanyetsa batho go goroga ga gagwe. O tlaa ba ruta go rata Morena fela jaaka bagolwane ba bone ba ne ba dira, le go tshela jaaka batho ba ba boifang Mo-dimo.” ");
INSERT INTO tsn_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Hong Sakarea a raya moengele a re, “Mme mo ga go kgonege! Ke setse ke le monna mogolo jaanong, le mosadi wa me le ene o tsofetse.” ");
INSERT INTO tsn_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Hong moengele a mo raya a re, “Ke Gabariele ke eme sentle fa pele ga Modimo. Ke one o o ntho-mileng kwa go wena ka mafoko a a molemo a! ");
INSERT INTO tsn_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mme jaanong, ka gore ga o a ka wa ntumela, o tlaa dirwa semumu, o tlaa palelwa ke go bua go fitlhelela ngwana a tsholwa. Gonne mafoko a me a tlaa diragala ka nako e e leng yone.” ");
INSERT INTO tsn_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ka lobakanyana kokoano ya batho kwa ntle ba bo ba letile Sakarea go boa, ebile ba gakgametse gore ke eng fa a diegile. ");
INSERT INTO tsn_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ya re a tswa a bo a palelwa, ke go bua nabo, jalo ba lemoga fa a bonye ponatshegelo mo tempeleng. Ene a nna a ba gwetlha fela a ntse. ");
INSERT INTO tsn_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Hong a nna mo Tempeleng selekanyo sa malatsi a a setseng a tiro ya gagwe ya Tempele mme morago a boela gae. ");
INSERT INTO tsn_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ka bonako morago ga lobaka Elisabetha mosadi wa gagwe a ithwala a nna a le nosi selekanyo sa kgwedi tse tlhano. ");
INSERT INTO tsn_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“A goa” a re, “Morena o pelotlhomogi mo go kae, go ntsha tlotlologo ya me ya go tlhoka bana!” ");
INSERT INTO tsn_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kgwedi e e latelang Modimo wa roma moengele Gabariele kwa Nasaretha, motse wa Galalea, ");
INSERT INTO tsn_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kwa kgarebaneng, Marea, yo o neng a beeletswe go nyalwa ke monna yo o neng a bidiwa Josefe, wa lotso lwa ga Kgosi Dafide. ");
INSERT INTO tsn_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabariele a iponatsa mo go ene a re, “A go nne boitumelo kgarebane e e rategang! Morena o na le wena!” ");
INSERT INTO tsn_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Marea o ne a tshwenyegile thata fa a leka go akanya se moengele a ka neng a se raya. ");
INSERT INTO tsn_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Moengele a mo raya a re, “Se tshoge Marea, gonne Modimo o thata. ");
INSERT INTO tsn_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ka bonako jaanong o tlaa ithwala mme o tlaa nna le ngwana wa mosimane, mme o tlaa mo raya leina o re ‘Jesu’ ");
INSERT INTO tsn_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","O tlaa nna mogolo thata mme o tlaa bidiwa Morwa Modimo. Mme Morena Modimo o tlaa mo naya setilo sa bogosi sa mogolwagolwane wa gagwe Dafide. ");
INSERT INTO tsn_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","O tlaa busa mo Iseraela ka bosakhutleng, Bogosi jwa gagwe ga bo kitla bo fela!” ");
INSERT INTO tsn_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mme Marea a botsa moengele a re, “Ke ka nna jang le ngwana? ke le kgarebane.” ");
INSERT INTO tsn_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Moengele a mo fetola a re, “Mowa o o Boitshepo o tlaa tla mo go wena, le nonofo ya Modimo e tlaa go apesa, jalo ngwana yo o tlaa mo tsholang o tlaa ba a le boitshepo e le Morwa Modimo. ");
INSERT INTO tsn_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mo godimo ga moo, Elisabetha ntsalao wa ‘moopa’ jaaka a bidiwa-o setse a na le dikgwedi di le thataro a ithwele mo botsofeng ja gagwe! ");
INSERT INTO tsn_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Gonne tsholofetso nngwe le nngwe e e tswang mo Modimong e tlaa diragala.” ");
INSERT INTO tsn_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mme Marea a re, “Ke motlhanka wa Morena e bile ke batla go dira sengwe le sengwe se o se batlang. A sengwe le sengwe se o se buileng se diragale.” Hong moengele a nyelela. ");
INSERT INTO tsn_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Morago ga malatsi a se kae Marea a itlhaganelela kwa makhubung a Judea kwa motseng o Sakarea o neng a nna mo go one, go etela Elisabetha. ");
INSERT INTO tsn_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mme ya re Elisabetha a utlwa tumediso ya ga Marea, ngwana a tlola mo sebopelong sa gagwe mme Elisabetha a tlala Mowa o o Boitshepo. ");
INSERT INTO tsn_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","A tshega ka boitumelo a raya Marea a re, “o ratilwe ke Modimo mo basading botlhe, le ngwana, wa gago, o tlhologeletswe kgalalelo ya Modimo e kgolo. ");
INSERT INTO tsn_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ana ke tlotlo e kgolo thata jang, e Mma-Morena wa me o nketetseng ka yone! ");
INSERT INTO tsn_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Erile fa ke utlwa lentswe la gago ka nako e o neng o ntumedisa ka yone, ngwana a tlola mo sebopelong sa me ka boitumelo! ");
INSERT INTO tsn_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","O dumetse gore Modimo o tlaa dira se o se buileng; ke ka moo o go neileng letlhogonolo le le gakgamatsang le.” ");
INSERT INTO tsn_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Marea a fetola a re, “Ao, ke galaletsa Morena jang. ");
INSERT INTO tsn_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ke itumela jang mo Modimong Mmoloki! ");
INSERT INTO tsn_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Gonne o tlhokometse motlhanka wa one wa morweetsana, le jaanong kokomana morago ga kokomana go ya bosakhutleng ba tlaa mpitsa mosegofadiwa wa Modimo. ");
INSERT INTO tsn_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","“Gonne ene yo mogolo yo o boitshepo, o ntiretse dilo tse dikgolo. ");
INSERT INTO tsn_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Boutlwelo-botlhoko jwa gagwe bo tsamaya go tsweng kokomaneng go ya kokomaneng, mo go botlhe ba ba o boifang: ");
INSERT INTO tsn_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","“Nonofo ya letsogo la gagwe e kgolo jang! O faladitse baikgantshi le ba ba ikgodisang. ");
INSERT INTO tsn_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","O digile dikgosi tse di kgolo mo ditilong tsa tsone tsa bogosi mme o godisitse ba ba ingotlileng. ");
INSERT INTO tsn_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","O kgorisitse dipelo tse di bolailweng ke tlala mme o busitse bahumi ba sa tsaya sepe. ");
INSERT INTO tsn_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ebile o thusitse motlhanka wa gagwe Iseraele jang! Ga a ka a lebala tsholofetso ya kutlwelo-botlhoko. ");
INSERT INTO tsn_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","“Gonne o solofeditse bo rraarona-Aberahame le bana ba gagwe go nna kutlwelo-botlhoko mo go bone go ya bosakhutleng.” ");
INSERT INTO tsn_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Marea a nna le Elisabetha selekanyo sa dikgwedi tse tharo mme a boela kwa legaeng la gagwe. ");
INSERT INTO tsn_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ka nako e, tebelelo ya ga Elisabetha e ne e setse e wetse, ka gore lobaka lo ne lo setse lo fitlhile lwa ngwana gore a tsholwe mme ya bo e le mosimane. ");
INSERT INTO tsn_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mme lefoko la anamela ka bonako kwa go bangwe ka ene le ba losika gore Morena o mo diretse molemo go le kae, mme mongwe le mongwe a itumela. ");
INSERT INTO tsn_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","E rile fa ngwana a na le malatsi a fera bobedi botlhe ba losika le ditsala ba tla modirong wa thupiso. Botlhe ba ne ba ithaya ba re leina la ngwana e tlaa nna Sakarea, a reelelwa rraagwe. ");
INSERT INTO tsn_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mme Elisabetha a re, “Nnyaa! O tshwanetse go bidiwa Johane!” ");
INSERT INTO tsn_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mme ba gakgamala ba re, “Wa reng? Ga go na ope mo go ba gaeno wa leina leo.” ");
INSERT INTO tsn_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jalo ba botsa rangwana, ba bua le ene ka diatla. ");
INSERT INTO tsn_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Mme a kopa pampiri e e kwalelang mme mo kgakgamalong ya mongwe le mongwe a kwala a re, “Leina la gagwe ke Johane!” ");
INSERT INTO tsn_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ka bonako Sakarea a kgona go bua gape, mme a simolola go baka Modimo. ");
INSERT INTO tsn_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kgakgamalo ya wela botlhe ba ba agileng gaufi, mme mafoko a se se diregileng a anama le dithota tsa Judea. ");
INSERT INTO tsn_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mme batho botlhe ba ba utlwileng kaga gone, ba akanya ka boleele ba ipotsa ba re, “Re a gakgamala gore ngwana yo o tsile go nna eng? Gonne letsogo la Morena ruri le mo okame ka mokgwa mongwe wa botlhokwa.” ");
INSERT INTO tsn_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Hong rraagwe ebong Sakarea a tlala Mowa o o Boitshepo mme a ntsha polelopele e e reng: ");
INSERT INTO tsn_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Bakang Modimo, Morena wa Iseraele gonne o tsile go etela batho ba gagwe mme o ba golotse. ");
INSERT INTO tsn_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","O re romeletse Mmoloki yo o senatla a tswa mo losikeng lwa motlhanka wa gagwe Dafide, ");
INSERT INTO tsn_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","fela jaaka a solofeditse ka baporofiti ba gagwe ba ba boitshepo mo lobakeng lo lo fetileng ");
INSERT INTO tsn_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","gore o tlaa re romelela mongwe yo o tlaa re gololang mo babeng ba rona, le mo go botlhe ba ba re ilang. ");
INSERT INTO tsn_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","“O na a le kutlwelobotlhoko mo bagolwaneng ba rona, ee, mo go Aberahame ka bo ene, ka go gakologelwa tsholofetso ya gagwe e e boitshepo mo go ene, ");
INSERT INTO tsn_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","le go re naya tshwanelo ya go direla Modimo kwa ntle ga poifo, re golotswe mo babeng ba rona. ");
INSERT INTO tsn_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Le go re dira boitshepo le go amogelesega, re siametse go ema fa pele ga one ka bosakhutleng. ");
INSERT INTO tsn_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Mme wena morwaaka yo mmotlana, o tlaa bidiwa moporofiti wa Modimo o o galalelang, gonne o tlaa baakanya ditsela tsa ga Mesia. ");
INSERT INTO tsn_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","O tlaa bolelela batho ba one ka fa ba ka bonang poloko ka teng ka boitshwarelo jwa dibe. ");
INSERT INTO tsn_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Gotlhe mo go tlaa nna ka ntlha ya gore boutlwelo-botlhoko jwa Modimo wa rona bo bonolo thata, e bile bosa jwa legodimo bo tlaa re sela. ");
INSERT INTO tsn_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Go bonesetsa ba ba ntseng mo lefifing la moruti wa loso, le go re goga mo tseleng ya kagiso.” ");
INSERT INTO tsn_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mme e rile ngwana a sena go gola a rata Modimo thata. A nna kwa ntle mo sekakeng a le esi go fitlhelela a simolola thuto ya gagwe mo Iseraele. ");
INSERT INTO tsn_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ka nako e Kaesare Aguseto, Kgosi e kgolo ya Roma a ntsha molao wa gore merafe yotlhe e kwalwe. ");
INSERT INTO tsn_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Go kwalwa mo go ne ga dirwa ka lobaka lwa Kwirinio e le molaodi wa Siria. ");
INSERT INTO tsn_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mongwe le mongwe o ne a kopiwa go boela kwa ga gabo mogolo go ikwadisa. ");
INSERT INTO tsn_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Mme Josefe ka e ne e le ngwana wa bogosi, a tshwanelwa ke go tswa kwa motseng wa Galalea wa Nasaretha a etela kwa Bethelehema mo Judea legae la bogologolo la ga Kgosi Dafide. ");
INSERT INTO tsn_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","A tsamaya le Marea, mmeelediwa wa gagwe yo o neng a bonala a le moimana ka nako e. ");
INSERT INTO tsn_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mme fa ba sa le teng foo, lobaka lwa tla lwa gore ngwana a tsholwe; ");
INSERT INTO tsn_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","mme a tshola ngwana wa ntlha, e le mosimane. A mo phuthela ka kobo a mmaya mo bojelong jwa diruiwa, gonne ba ne ba sena bonno mo motseng wa baeti. ");
INSERT INTO tsn_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bosigo joo badisa bangwe ba bo ba le mo nageng kwa ntle ga motse, ba disitse letsomane la bone la dinku. ");
INSERT INTO tsn_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ka tshoganetso moengele a iponatsa mo go bone mme lefatshe la phatsima ka ntlha ya kgalalelo ya Morena, mme ba tshoga thata. ");
INSERT INTO tsn_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mme moengele a ba nametsa a re, “Se boifeng!” “Ke lo lereditse mafoko a boitumelo jo bogolo jo bo tlaa bolelwang ka bosakhutleng, mme ke jwa mongwe le mongwe! ");
INSERT INTO tsn_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mmoloki ee, Mesia o tsetswe bosigong jono mo Bethelehema! ");
INSERT INTO tsn_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Lo tlaa mo lemoga jang? Lo tlaa bona losea lo phuthetswe mo kobong, lo robaditswe mo bojelong!” ");
INSERT INTO tsn_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ka tshoganetso moengele a tlhakana le lesomo le legolo la ba bangwe ebong mephato ya legodimo ba baka Modimo ba opela ba re: ");
INSERT INTO tsn_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kgalalelo e nne go Modimo kwa magodimong, le kagiso mo lefatsheng mo go botlhe ba ba mo itumedisang.” ");
INSERT INTO tsn_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Erile mophato o mogolo wa baengele o sena go boela gape kwa legodimong, badisa ba raana ba re, “A re yeng! A re yeng kwa Bethelehema! A re yeng go bona kgakgamatso e e diragetseng, e Morena o re boleletseng kaga yone.” ");
INSERT INTO tsn_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mme ba sianela kwa motseng ba tsaya tsela e e yang kwa go Marea le Josefe. Mme ga bo go le ngwana a rapame mo bojelong. ");
INSERT INTO tsn_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Badisa ba bolelela mongwe le mongwe kaga se se diragetseng le se moengele o se ba boleletseng kaga ngwana yo. ");
INSERT INTO tsn_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Botlhe ba ba utlwileng polelo ya badisa ba gakgamala. ");
INSERT INTO tsn_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mme Marea a baya dilo tse mo pelong ya gagwe ka tidimalo mme a akanya kaga tsone gantsi. ");
INSERT INTO tsn_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Hong badisa ba boela gape kwa nageng kwa letsomaneng la bone, ba galaletsa Modimo kaga go etelwa ke moengele le gore ba bone ngwana, fela jaaka baengele ba ba boleletse. ");
INSERT INTO tsn_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Morago ga malatsi a fera bobedi, kwa tirelong ya thupiso ya losea, a rewa leina gatwe Jesu, leina le o le neilweng ke moengele pele ga a ise a ithwalwe. ");
INSERT INTO tsn_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","E rile fa nako e tla ya gore Marea a ntshe tshupelo ya ntlafatso kwa tempeleng, ka fa melaong ya ga Moshe morago ga botsalo jwa ngwana, batsadi ba gagwe ba mo tseela kwa Jerusalema go ya go mo neela mo Moreneng; ");
INSERT INTO tsn_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Gonne mo melaong e go tulwe, “Fa ngwana wa ntlha wa mosadi e le mosimane, o tlaa neelwa Morena.” ");
INSERT INTO tsn_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ka nako eo batsadi ba ga Jesu le bone ba ntsha setlhabelo sa bone sa go itshekisiwa, a e ka nna maphoi a le mabedi! kgotsa maebana a mabedi! E ne e le kopo e e ka fa molaong. ");
INSERT INTO tsn_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ka letsatsi leo monna yo o bidiwang Simione moagi wa Jerusalema, o na a le mo tempeleng. E ne e le monna yo o siameng, morapedi yo mogolo, a tletse Mowa o o Boitshepo ebile ka metlha yotlhe a solofetse Mesia go tla ka bonako. ");
INSERT INTO tsn_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Gonne Mowa o o Boitshepo o ne o iponaditse mo go ene gore ga a na go swa go fitlhelela a bona kgosi e e tloditsweng ya Modimo. ");
INSERT INTO tsn_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mowa O O Boitshepo o ne wa mo tlhotlheletsa go ya kwa tempeleng ka letsatsi leo; mme jalo fa Marea le Josefe ba goroga go neela Jesu mo Moreneng ka go ikobela molao, ");
INSERT INTO tsn_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simione o ne a le teng mme a tsaya ngwana ka mabogo a gagwe, a baka Modimo. ");
INSERT INTO tsn_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","A re, “Morena. Jaanong ke ka a swa ka kagiso! Gonne ke mmone jaaka o ntsholofeditse gore ke tlaa mmona, ke bone Mmoloki yo o mo neileng lefatshe. ");
INSERT INTO tsn_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ke lesedi le le tlaa phatshimelang dichaba, e bile o tlaa nna kgalalelo mo bathong ba gago ba Iseraele!” ");
INSERT INTO tsn_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Marea le Josefe ba ema fela foo, ba gakgamalela se se buiwang kaga Jesu. ");
INSERT INTO tsn_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Simione a ba segofatsa mme a raya Marea a re, “Chaka e tlaa tlhaba mowa wa gago, gonne ngwana yo o tlaa ganwa ke batho ba le bantsi mo Iseraele ka ntlha ya tshenyego ya bone. Mme o tlaa nna boipelo jo bogolo jwa ba bangwe ba le bantsi. Le dikakanyo tse di kwa teng tsa dipelo tse di ntsi di tlaa senolwa.” ");
INSERT INTO tsn_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ana, moporofiti wa mosadi o na a le teng ka letsatsi leo. E ne e le morwadia Fanuela, wa morafe wa Sejuta wa ga Ashere, mme o ne a tsofetse, gonne e ne e le motlholagadi wa selekanyo sa dingwaga di le masome a fera bobedi le bone go tloga mo dingwageng di supa tsa lenyalo la gagwe, o ne a seka a tloga mo tempeleng mme a nna teng bosigo le motshegare, a obamela Modimo ka go rapela le go itima dijo gantsi. ");
INSERT INTO tsn_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","A atamela fa Simione a sa ntse a bua le Marea le Josefe, mme a simolola go leboga Modimo le go itsise mongwe le mongwe mo Jerusalema yo a neng a letile go tla ga Mmoloki kaga kgorogo ya ga Mesia. ");
INSERT INTO tsn_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Erile batsadi ba ga Jesu ba sena go diragatsa gotlhe mo go neng go tlhokwa ke Molao wa Modimo ba boela gae kwa Nasaretha mo Galalea. ");
INSERT INTO tsn_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Koo ngwana a feta a nna mosimane yo o thata yo o nonofileng, a ba a itsiwe ka botlhale jo bo fetileng dingwaga tsa gagwe; mme Modimo wa gorometsa matlhogonolo a one mo go ene. ");
INSERT INTO tsn_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Erile Jesu a le dingwaga di le lesome le bobedi a tsamaya le batsadi ba gagwe go ya kwa moletlong wa Tlolaganyo o ba neng ba o tsena ngwaga le ngwaga. ");
INSERT INTO tsn_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Morago ga moletlo ba simolola go boela gae kwa Nasaretha, mme Jesu a sala mo Jerusalema. Mme batsadi ba gagwe ga ba a ka ba mo tlhoka letsatsi la ntlha, ");
INSERT INTO tsn_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","gonne ba ne ba gopola gore o na le ditsala mo baeting ba bangwe. Mme erile fa a sa bonale mo maabanyaneng ao, ba simolola go mmatla mo ditsaleng tsa bone. ");
INSERT INTO tsn_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mme ya re ba sa mmone, ba boela kwa Jerusalema go ya go mmatla teng. ");
INSERT INTO tsn_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","47","Morago ga malatsi a mararo ba mmona. O ne a le mo Tempeleng, a ntse fa gare ga baruti ba molao, a ganetsanya le bone ka dipotso tse di thata mme a gakgamatsa mongwe le mongwe ka kitso ya gagwe le dikarabo. ");
INSERT INTO tsn_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mme batsadi ba gagwe ba se ka ba itse gore ba ka akanyang fa ba mmona a ntse foo a didimetse. Hong mmaagwe a mo raya a re, “Morwaaka! Ke eng fa o re diretse jaana. Rrago le nna re go batlile ka tlhoafalo gongwe le gongwe?” ");
INSERT INTO tsn_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mme a ba raya a re, “Lo ne lo mpatlelang? A lo ne lo sa lemoge gore ke tlaa bo ke le fano mo Tempeleng, mo tlung ya ga Rre?” ");
INSERT INTO tsn_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mme ba bo ba sa tlhaloganye gore o raya jang. ");
INSERT INTO tsn_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Hong a boela kwa Nasaretha le bone a ba utlwa; mme mmaagwe a boloka dilo tse tsotlhe mo pelong ya gagwe. ");
INSERT INTO tsn_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Mme Jesu a gola a nna moleele ebile a le botlhale, mme a ratwa ke Modimo le batho. ");
INSERT INTO tsn_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Mme e rile mo ngwageng ya lesome le botlhano ya puso ya ga kgosi kgolo Teberio Kaefase, molaetsa wa tla mo go Johane (morwa Sakarea) ka a ne a nna kwa ntle mo dikakeng (Pilatwe e ne e le mmusi mo Judea ka lobaka loo; Herode e le mmusi mo Galalea, monnawe Filipo e le mmusi mo Iturea le Trakoniti; Lusaniase e le mmusi mo Abilene; Anase le Kaeafase e le baperesiti ba bagolo ba Sejuta). ");
INSERT INTO tsn_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Hong Johane a tsamaya gongwe le gongwe mo ditlhakoreng tsoopedi tsa noka ya Jorodane, a rera gore batho ba tshwanetse go kolobediwa go supa gore ba sokologetse mo Modimong, ebile ba sokologile mo dibeng tsa bone, gore ba tle ba itshwarelwe. ");
INSERT INTO tsn_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mo mafokong a ga moporofiti Isaia, Johane e ne, “E le lentswe le le kuang mo sekakeng, le re baakanyang tsela e Morena o tlaa tsamayang mo go yone! Mo katolosetseng tsela. ");
INSERT INTO tsn_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ritibatsang dithaba! Katelang melatswana! Tlhamalatsang ditsela tse di kgopo! Rethefatsang le tsone tse di dikhuti! ");
INSERT INTO tsn_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ke gone batho botlhe ba tlaa bonang Mmoloki yo o tswang legodimong.” ");
INSERT INTO tsn_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Se ke sekai sa thero ya ga Johane mo dikokoanong tsa batho ba ba neng ba tsile kolobetsong: “Losika lwa dinoga ke lona! Lo leka go falola molete kwa ntle ga go sokologela mo Modimong ka boammaaruri! Ke gone ka moo lo batlang go kolobediwa! ");
INSERT INTO tsn_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tsamayang pele lo ye go itshupa ka mokgwa o lo tshelang ka one gore ke boammaaruri lo ikwatlhaile. Le gone lo se ka lwa akanya gore lo falotse ka gore lo losika lwa ga Aberahame. Moo ga go a lekana. Modimo o ka ntsha bana ba ga Aberahame mo majeng a a sekaka a! ");
INSERT INTO tsn_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“Selepe sa katlholo ya gagwe se tlhomilwe mo godimo ga lona, se baakanyeditswe go kgaola medi ya lona le go lo kgaolela fa fatshe. Ee, setlhare sengwe le sengwe se se sa ungweng loungo lo lo siameng se tlaa rengwa se be se latlhelwa mo molelong.” ");
INSERT INTO tsn_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mme batho ba ba kokoaneng ba fetola bare, “O batla gore re direng?” Hong a ba fetola a re, ");
INSERT INTO tsn_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","“Fa o na le dikobo di le pedi,” naya yo o tlhokang e nngwe. Fa o na le dijo tse dingwe di abele ba ba bolailweng ke tlala. ");
INSERT INTO tsn_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Le e leng bone bakgethisi tota ba ba itsegeng ka bosula jwa bone ba tla go kolobediwa mme ba botsa ba re, “Re tlaa go tlhomamisetsa jang gore re latlhile dibe tsa rona?” ");
INSERT INTO tsn_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Johane a re, “Ke tlaa itse jang boammaaruri jwa lona. Tlhomamisang gore lo seka lwa phutha makgetho a a fetang a mmuso wa Seroma o o lo kopang gore lo a kokoanye.” ");
INSERT INTO tsn_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mme masole mangwe a botsa a re, “A le rona? Jaanong ka ga rona?” Johane a fetola a re, “Lo seka lwa gapa madi ka patiko le thubakanyo; lo se pateletse ope ka ga se lo itseng a sa se dire; mme itumeleleng tuelo ya lona!” ");
INSERT INTO tsn_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Batho botlhe ba solofetse Mesia go tla ka bonako, ebile ba gakaletse go itse gore a Johane ke ene kgotsa nnyaa. E e ne e le potso ya lobaka lwa oura, mme ba ne ba tsaya kgang ka yone gongwe le gongwe. ");
INSERT INTO tsn_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Johane a araba potso e a re, “Ka nna legale ke lo kolobetsa ka metsi; mme mongwe o e tla yo o nang le nonofo e kgolo go feta yame; yo ke sa tshwanelang le fa e le go nna motlhanka wa gagwe mme ene o tlaa lo kolobetsa ka molelo ka Mowa o o Boitshepo. ");
INSERT INTO tsn_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","O tlaa kgaoganya mmoko le mabele, a tshube mmoko ka molelo o o sa khutleng mme a boloke mabele.” ");
INSERT INTO tsn_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","A dirisa ditlhagiso di le dintsi fa a ntse a bolelela batho mafoko a a molemo a Modimo. ");
INSERT INTO tsn_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","(Mme ya re Johane a sena go bona Herode mmusi wa Galalea molato, ka go nyala Herodease, mosadi wa ga monnawe, le ka ga diphoso tse dintsi tse o di dirileng, Herode a tsenya Johane mo kgolegelong, ka go dira jalo a ba a oketsa sebe se, mo go tse dingwe tse dintsi tsa gagwe). ");
INSERT INTO tsn_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Erile ka letsatsi lengwe Jesu ka boene a tlhakana le boidiidi jwa batho ba ba neng ba kolobediwa ke Johane. Mme e rile fa a sena go kolobediwa, a rapela, mme magodimo a bulega, ");
INSERT INTO tsn_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","mme Mowa o o Boitshepo o le mo setshwanong sa lephoi wa tlhomama mo godimo ga gagwe, mme lentswe le le tswang legodimong la re, “O Morwaake yo o rategang thata. Ee, o boitumelo jwa me.” ");
INSERT INTO tsn_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesu o ne a na le dingwaga di ka nna masome mararo fa a simolola tirelo ya gagwe. O na a itsege e le morwa Josefe. ");
INSERT INTO tsn_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Josefe rraagwe e ne e le Eli; Eli rraagwe e ne e le Lefi; Lefi rraagwe e ne e le Meleki; Meleki rraagwe e ne e le Janai; Janai rraagwe e ne e le Josefe; ");
INSERT INTO tsn_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josefe rraagwe e ne e le Mathatio; Mathatio rraagwe e ne e le Amose; Amose rraagwe e ne e le Nahume; Nahume rraagwe e ne e le Eseli; Eseli rraagwe e ne le Nagai; ");
INSERT INTO tsn_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai rraagwe e ne e le Maathe; Maathe rraagwe e ne e le Mathatio; Mathatio rraagwe e ne e le Semeine; Semeine rraagwe e ne e le Joseke; Joseke rraagwe e ne e le Joda; ");
INSERT INTO tsn_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda rraagwe e ne e le Joane; Joane rraagwe e ne e le Resa; Resa rraagwe e ne e le Sorobabela; Sorobabela rraagwe e ne e le Salatheile; Salathiele rraagwe e ne e le Neri; ");
INSERT INTO tsn_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri rraagwe e ne e le Meleki; Meleki rraagwe e ne e le Adi; Adi rraagwe e ne e le Kosame; Kosame rraagwe e ne e le Elemadame; Elemadame rraagwe e ne e le Ere; ");
INSERT INTO tsn_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ere rraagwe e ne e le Joshua; Joshua rraagwe e ne e le Eliesere; Eliesere rraagwe e ne e le Jorime; Jorime rraagwe e ne e le Mathate; Mathate rraagwe e ne e le Lefi; ");
INSERT INTO tsn_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lefi rraagwe e ne e le Simione; Simione rraagwe e ne e le Juda; Juda rraagwe e ne e le Josefe; Josefe rraagwe e ne e le Joname; Joname rraagwe e ne e le Eliakime; ");
INSERT INTO tsn_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakime rraagwe e ne e le Melea; Melea rraagwe e ne e le Mene; Mene rraagwe e ne e le Matatha; Matatha rraagwe e ne e le Nathame; Nathame rraagwe e ne e le Dafide; ");
INSERT INTO tsn_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dafide rraagwe e ne e le Jese; Jese rraagwe e ne e le Obede; Obede rraagwe e ne e le Boase; Boase rraagwe e ne e le Sala; Sala rraagwe e ne e le Naasone; ");
INSERT INTO tsn_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasone rraagwe e ne e le Aminadabe; Aminadabe rraagwe e ne e le Admine; Admine rraagwe e ne e le Areni; Areni e ne e le rraagwe Eserome; Eserome e ne e le rraagwe Perese; Perese rraagwe e ne e le Juda; ");
INSERT INTO tsn_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda rraagwe e ne e le Jakobe; Jakobe rraagwe e ne e le Isake; Isake rraagwe e ne e le Aberahame; Aberahame rraagwe e ne e le Thara; Thara rraagwe e ne e le Nagore; ");
INSERT INTO tsn_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nagore rraagwe e ne e le Seruge; Seruge rraagwe e ne e le Ragau; Ragau rraagwe e ne e le Faleke; Faleke rraagwe e ne e le Ebere; Ebere rraagwe e ne e le Sala; ");
INSERT INTO tsn_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala rraagwe e ne e le Kainame; Kainame rraagwe e ne e le Arpagasadi; Arpagasadi rraagwe e ne e le Sheme; Sheme rraagwe e ne e le Lamege; ");
INSERT INTO tsn_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamege rraagwe e ne e le Methusela; Methusela rraagwe e ne e le Enoke; Enoke rraagwe e ne e le Jareke; Jareke rraagwe e ne e le Mahalele; Mahalele rraagwe e ne e le Kainame; ");
INSERT INTO tsn_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainame rraagwe e ne e le Enose; Enose rraagwe e ne e le Sethe; Sethe rraagwe e ne e le Adamo; Adamo rraagwe e ne e le Modimo. ");
INSERT INTO tsn_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Mme ya re Jesu a ntse a tletse Mowa O O Boitshepo, a tloga mo nokeng ya Jorodane, a tlhotlheleditswe ke Mowa O O Boitshepo a ya mafatshing a Judea, kwa Satane o neng a mo raela selekanyo sa malatsi a le masome a mane. O ne a sa je sepe mo lobakeng loo lotlhe, mme a ba a tshwerwe ke tlala. ");
INSERT INTO tsn_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Satane a mo raela a mo raya a re, “Fa o le Morwa Modimo, raya leje le o re le fetoge senkgwe.” ");
INSERT INTO tsn_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mme Jesu a mo fetola a re, “Go kwadilwe mo dikwalong gatwe, ‘Dilo dingwe mo botshelong di botlhokwa thata go na le senkgwe.’ ” ");
INSERT INTO tsn_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mme Satane a mo tseela kwa godimo mme a mmontsha magosi a lefatshe otlhe ka nako e khutshwane; ");
INSERT INTO tsn_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","mme Satane a mo raya a re, “Ke tlaa go naya magosi a mantle a otlhe le kgalalelo ya one gonne ke a me ke a naya mongwe yo ke eletsang go a mo naya fa o ka khubama ka mangole wa nkobamela.” ");
INSERT INTO tsn_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesu a fetola a re “Re tshwanetse go obamela Modimo, ene ka esi. ‘Go kwadilwe jalo mo dikwalong.’ ” ");
INSERT INTO tsn_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Hong Satane a mo tseela kwa Jerusalema kwa setlhoeng se se kwa godimo sa Tempele mme a re, “Fa o le morwa Modimo itige! Gonne dikwalo tsa re Modimo o tlaa romela baengele ba one go go sireletsa le go go tlamela gore o seka wa sugakana fa fatshe!” ");
INSERT INTO tsn_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mme Jesu a fetola a re, “Dikwalo gape tsa re ‘O se leke bopelotelele jwa Modimo.’ ” ");
INSERT INTO tsn_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Erile Diabole a sena go fetsa dithaelo tsotlhe a tlogela Jesu ka lobakanyana mme a tsamaya. ");
INSERT INTO tsn_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Mme Jesu a boela kwa Galalea, a tletse nonofo ya Mowa O O Boitshepo. Mme ka bofefo a tuma mo tikologong ya kgaolo eo yotlhe. ");
INSERT INTO tsn_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Gonne o ne a galalediwa ke mongwe le mongwe mo disenagogeng ka ntlha ya dithero tsa gagwe. ");
INSERT INTO tsn_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","E rile fa a tsena mo motsing wa Nasaretha, mo legaeng le o tsaletsweng mo go lone, a ya jaaka gale kwa tlung ya thuto ka Sabata, mme a ema a bala dikwalo. ");
INSERT INTO tsn_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Mme a neelwa lokwalo lwa ga Moporofiti Isaia, mme a lo bula mo kgaolong e e reng. ");
INSERT INTO tsn_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","“Mowa wa Modimo o mo go nna. O ntaoletse go rerela bahumanegi Mafoko a a Molemo; o nthometse go fodisa dipelo tse di phatlogileng le go bolela gore magolegwa a tla gololwa, le difofu di tlaa bona, bapatikegi ba tlaa gololwa mo bagateleding ba bone le gore Modimo o ipaakanyeditse go naya letlhogonolo botlhe ba ba tlang mo go one.” ");
INSERT INTO tsn_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Mme a tswala lokwalo a lo busetsa kwa molebeleding, a nna fa fatshe, mongwe le mongwe mo senagogeng a mo lebeletse thata ka tlhoafalo. ");
INSERT INTO tsn_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Hong a oketsa a re, “Dikwalo tse di diragetse gompieno!” ");
INSERT INTO tsn_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Botlhe ba ba neng ba le foo ba bua sentle kaga gagwe e bile ba gakgamaditswe ke mafoko a mantle a a neng a tswa mo molomong wa gagwe. Mme ba botsa ba re, “Mo go ka diragala jang. A motho yo ga se morwa Josefe?” ");
INSERT INTO tsn_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Mme Jesu a re, “Nkete lo tlaa mpuela seane se se reng, ‘Ngaka, iphodise’ ke gore, ‘Ke eng fa o sa dire dikgakgamatso fano mo legaeng la gaeno jaaka tse o neng o di dira kwa Kaperenama?’ ");
INSERT INTO tsn_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mme ke lo tlhomamisetsa gore ga go moporofiti ope yo o amogelesegang mo ga gabo!” ");
INSERT INTO tsn_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Sekai ke se, “Gakologelwang jaaka moporofiti Elija a ne a dira Sarefa a le moeti go tswa lefatsheng la Sidona. Go ne go le batlholagadi ba Sejuta ba le bantsi ba ba neng ba tlhoka thuso mo malatsing ao a leuba, gonne go ne go se na pula selekanyo sa dingwaga di le tharo le sephatlo, mme tlala ya tsena mo lefatsheng ka bokukuntshwane; le fa go ntse jalo Elija a ba a sa romelwa kwa go bone. ");
INSERT INTO tsn_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kgotsa akanyang moporofiti Elija, yo o neng a fodisa Naamane wa Mosiria, bogolo go balepero ba le bantsi ba Sejuta ba ba neng ba tlhoka thuso.” ");
INSERT INTO tsn_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mme mafoko a a ba shakgatsa thata; ");
INSERT INTO tsn_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mme ba tlola, ba mo gagautlha ba ba ba mo tseela kwa losing lwa lentswe le le godileng mo go neng go agilwe motse teng, go mo kgoromeletsa mo godimo ga lekhubu. ");
INSERT INTO tsn_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mme a tswa mo bontsintsing jwa batho a ba tlogela. ");
INSERT INTO tsn_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mme a boela kwa Kaperenama, motse o o mo Galalea, mme a ruta teng mo senagogeng ka Sabata mongwe le mongwe. ");
INSERT INTO tsn_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Teng koo le gone batho ba gakgamadiwa ke dilo tse o neng a di bua. Gonne o ne a bua jaaka mongwe yo o itseng boammaaruri mo boemong jwa go nankola megopolo ya ba bangwe. ");
INSERT INTO tsn_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mme ya re nako nngwe a ruta mo ntlung ya thuto, monna yo o neng a tsenywe ke mowa o o maswe a simolola a goeletsa kwa go Jesu a re, ");
INSERT INTO tsn_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Tsamaya! Ga re na sepe le wena, Jesu wa Nasaretha. O tsile go re senya, ke a itse gore o mangMorwa Modimo yo o boitshepo.” ");
INSERT INTO tsn_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesu a mo kgaodisa go bua a re, “Didimala!” A raya mowa o o maswe a re, “Tswela kwa ntle!” Mme mowa o o maswe wa latlhela monna fa fatshe fa bontsintsing jwa batho bo ntse bo lebeletse; mme wa mo tlogela ‘o’ sa mo utlwisa botlhoko gope. ");
INSERT INTO tsn_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Hong batho ba botsa ka kgakgamalo ba re, “Ke eng se se mo mafokung a monna yo fa le mewa e e maswe e mo utlwa?” ");
INSERT INTO tsn_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mme polelo kaga se a se dirileng ya anama jaaka molelo wa naga mo tikologong yotlhe. ");
INSERT INTO tsn_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Erile a sena go tloga mo tlung ya thuto ka letsatsi leo, a ya kwa legaeng la ga Simone kwa a neng a fitlhela mogwagwadia Simone wa mosadi a lwala thata bolwetse jwa letshoroma. Mme batho botlhe ba mo kopa go re a mo fodise. ");
INSERT INTO tsn_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ya re a eme fa thoko ga bolao jwa gagwe a bua le letshoroma, a le kgalemela, ka bonako a fola a tsoga a ba direla dijo! ");
INSERT INTO tsn_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ya re letsatsi le phirima mo maabanyaneng ao, baagi ba motse botlhe ba ba nang le balwetse mo magaeng a bone, go sa re sepe gore e ka bo e le malwetse a a ntseng jang, ba ba tlisa kwa go Jesu; mme erile fa a ba baya diatla ba fola. ");
INSERT INTO tsn_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Bangwe ba ne ba tsenwe ke mewa e e maswe, mme mewa e e maswe ya tswela kwa ntle ka taolo ya gagwe, ya goa ya re, “O Morwa Modimo.” Mme ka gore ba ne ba itse fa e le Keresete, a ba didimatsa. ");
INSERT INTO tsn_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mme ya re phakela mo mosong o o latelang a tswela kwa ntle mo sekakeng. Bontsintsi jwa batho ba mmatla gongwe le gongwe mme ya re fa ba mmonang gone ba mo kopa gore a seka a ba tlogela, mme a nne kwa Kaperenama. ");
INSERT INTO tsn_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mme a ba fetola a re, “Ke tshwanetse go rera Mafoko a a Molemo a bogosi jwa Modimo le mo metseng e mengwe, gonne ke sone se ke se tletseng.” ");
INSERT INTO tsn_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jalo a nna a tsamaya a rera mo matlung a thuto mo Judea otlhe. ");
INSERT INTO tsn_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Mme ya re ka letsatsi lengwe a rera mo lotshitshing lwa lecha la Genesareta, bontsintsi jo bogolo jwa batho jwa kokoanela mo go ene go reetsa Lefoko la Modimo. ");
INSERT INTO tsn_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Mme a lebela mekoro e mebedi e e senang sepe e eme fa thoko ga metse fa batshwari ba ditlhapi ba tlhatswa matloa a bone. ");
INSERT INTO tsn_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Erile Jesu a tsena mo go mongwe wa mekoro, a raya Simone mong wa mokoro o mongwe a re, a o suteletse kwa pelenyana mo metsing gore a tle a nne mo go one a bue le batho a le mo teng. ");
INSERT INTO tsn_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Erile a sena go fetsa go bua, a raya Simone a re, “Jaanong tsamaela fa go boteng o lese matloa a gago mme o tlaa tshwara ditlhapi di le dintsi!” ");
INSERT INTO tsn_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Mme Simone a fetola a re, “Morena,” re dirile thata bosigo jotlhe mme ra se ka ra tshwara sepe, mme fa o rialo re tlaa leka gape. ");
INSERT INTO tsn_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Mme ka nako e matloa a bone a ne a tlala thata mo e leng gore a ne a simolola go gagoga! ");
INSERT INTO tsn_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mme go goa ga bone ba batla thuso ga tlisa bangwe ka bone mo mokorong o mongwe mme ka bonako mekoro yotlhe ya bo e tletse ditlhapi mo e ka nwelang. ");
INSERT INTO tsn_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Erile Simone Petere a lemoga se se diragetseng a itigela ka mangole fa pele ga ga Jesu mme a re, “Ao, Morena, tswee-tswee, re tlogele ke moleofi yo mogolo go ka nna le wena.” ");
INSERT INTO tsn_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Gonne o ne a gakgamaditswe thata ke selekanyo se ba se tshwereng jaaka ba bangwe ba ba neng ba na le bone. ");
INSERT INTO tsn_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Le bapati ba bangwe le bone bo Jakobe le Johane, bomorwa Sebede. Mme Jesu a fetola a re, “Se tshwenyege! go simolola gompieno lo tlaa tshwara mewa ya batho!” ");
INSERT INTO tsn_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Mme ya re ka bonako fa ba fologa mo mekorong ba tlogela tsotlhe ba tsamaya le ene. ");
INSERT INTO tsn_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Mme ka letsatsi lengwe mo motsaneng mongwe o a neng a o etela, teng koo ga bo go le monna yo o neng a na le lepero le le sa foleng. Erile a bona Jesu a itigela fa fatshe fa pele ga gagwe, a oba sefatlhogo a kopa gore a fodisiwe. A re, “Morena, fa o rata o ka mphodisa.” ");
INSERT INTO tsn_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Hong Jesu a otlolola seatla a ama monna yoo mme a re, “Go ntse jalo ke a rata, fola!” Mme lepero la mo tlogela ka bonako. ");
INSERT INTO tsn_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mme Jesu a mo laela gore a tsamaye ka bofefo a sa bolelele ope se se diragetseng le go ya go tlhatlhojwa ke moperesiti wa Sejuta. Mme Jesu a mo raya a re, “Ntsha setlhabelo se ka molao wa ga Moshe se batlwang mo baleperweng ba ba fodisitsweng. Se se tlaa supegetsa mongwe le mongwe gore o fodile.” ");
INSERT INTO tsn_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Hong polelo ya nonofo ya gagwe ya anama ka bonako mme kokoano e kgolo ya batho ya tla go utlwa a ruta le go fodisiwa malwetse a bone. ");
INSERT INTO tsn_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mme Jesu o ne a tle a ngwangwaelele kwa nageng go ya go rapela. ");
INSERT INTO tsn_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ka letsatsi lengwe fa a ntse a ruta, bangwe ba molao ba bo ba ntse gaufi nae. (Go ne go bonala fa batho ba ba ne ba tswa mo metsaneng mengwe le mengwe ya Galalea otlhe le Judea, le mo Jerusalema). Mme nonofo ya phodiso ya Morena e ne e le mo go ene. ");
INSERT INTO tsn_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Mme bonang! banna bangwe ba tlaa ba tshotse monna yo o suleng mofama a robetse mo phateng. Ba leka go itshukela mo gare ga bontsintsi jwa batho go ya kwa go Jesu mme ba se ka ba mmona. Jalo ba tlhatlogela mo ditlhomesong fa godimo ga gagwe, ba tlosa makote a a neng a khurumetse ditlhomeso mme ba baya fa fatshe monna yo o lwalang mo bontsintsing jwa batho, a ntse a robetse mo phateng, fa pele ga ga Jesu! ");
INSERT INTO tsn_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mme ya re Jesu a bona tumelo ya bone, a raya monna a re, “Tsala ya me, dibe tsa gago di itshwaretswe!” ");
INSERT INTO tsn_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mme Bafarasai le baruti ba molao ba botsanya ba re, “Motho yo o ikgopola a le eng?” O a tlhapatsa! E mang fa e se Modimo yo o ka itshwarelang dibe. ");
INSERT INTO tsn_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesu a ba a setse a itsile se ba se akantseng, mme a fetola a re, “Ke eng fa e le tlhapatso? ");
INSERT INTO tsn_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","A go thata go itshwarela dibe tsa gagwe go na le go mo fodisa?” ");
INSERT INTO tsn_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Jaanong ke tlaa supa thata ya me go itshwarela sebe ka go supa nonofo ya me ka go fodisa bolwetse. Mme a raya monna yo o suleng mofama a re, “Ema o menaganye phate ya gago o ye gae.” ");
INSERT INTO tsn_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mme ya re ka bonako, fa mongwe le mongwe a lebeletse, monna a nanoga a tsaya phate ya gagwe a ya gae a baka Modimo. ");
INSERT INTO tsn_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mme mongwe le mongwe yo o neng a le foo a tshwarwa ke kgakge le letshogo. Mme ba baka Modimo, ba boaboela gangwe le gape ba re, “Re bone dilo tse di gakgamatsang gompieno.” ");
INSERT INTO tsn_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mme morago ya re Jesu a tswa mo motseng a bona mokgethisi ka sekao sa gale sa go tsietsa a ntse fa bokgethelong. Leina la monna yo e ne e le Lefi, Jesu a mo raya a re, “Tla o nne mongwe wa barutwa ba me!” ");
INSERT INTO tsn_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Mme Lefi, a tlogela sengwe le sengwe a nanoga a tsamaya le ene. ");
INSERT INTO tsn_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mme ka bonako Lefi a dira modiro mo legaeng la gagwe a o direla Jesu e le moeng yo o tlotlegang. Ba le bantsi ba ditsala tsa ga Lefi tsa bakgethisi le baeti ba bangwe ba ne ba le teng. ");
INSERT INTO tsn_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mme Bafarasai le baruti ba molao ba ngongoregela barutwa ba ga Jesu ka go ja le baleofi ba mofuta oo. ");
INSERT INTO tsn_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mme Jesu a ba araba a re, “Ke molwetse yo o tlhokang ngaka eseng ba ba itekanetseng, ");
INSERT INTO tsn_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Tiro ya me ke go laletsa baleofi gore ba sokologe mo dibeng tsa bone, eseng go senya nako ya me ka ba ba ikgopolang gore ba setse ba siame thata.” ");
INSERT INTO tsn_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ngongorego e nngwe e ne e le ya gore barutwa ba ga Jesu ba dira modiro mo boemong jwa go ikitsa dijo, fa barutwa ba ga Johane le ba Bafarasai bone ba aga ba itima dijo ebile ba rapela. Ba re, “Ke eng fa barutwa ba gago bone ba a nwa ba a ja?” ");
INSERT INTO tsn_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesu a botsa a re, “A batho ba ba itumelang ba ka ikitsa go ja? A balalediwa ba lenyalo ba ka tshwarwa ke tlala fa ba le mo moketeng le monyadi? ");
INSERT INTO tsn_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mme nako e tlaa tla e monyadi o tlaa bolawang ka yone; ke gone ba se kitlang ba batla go ja.” ");
INSERT INTO tsn_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Hong Jesu a dirisa setshwantsho se: a re, “Ga go na ope yo o gagolang sebata sa seaparo se sesha go bitiya seaparo se segologolo, gonne seaparo se sesha se tlaa bo se sentswe, mme seaparo se segologolo se tlaa lebega se le maswe ka ntlha ya sebata se sesha mo go sone. ");
INSERT INTO tsn_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mme ga go ope yo o ka tshelang seno sa mofine se sesha mo teng ga dinkgwana tse di kgologolo, gonne seno se sesha se tlaa phunya dinkgwana mme di tsholole mofine. ");
INSERT INTO tsn_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mofine o mosha o tshwanetse go tshelwa mo dinkgwaneng tse disha. ");
INSERT INTO tsn_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mme ga go ope yo e a reng a sena go nwa mofine o mogologolo a eletse o mosha. Mme batho ba re ditsela tsa bogologolo di botoka.” ");
INSERT INTO tsn_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ka Sabata mongwe ya re Jesu le barutwa ba gagwe ba tsamaya mo gare ga masimo mangwe a mabele, ba kgetla diako ba sosorela ditlhaka mo diatleng tsa bone mme ba a ja mabele. ");
INSERT INTO tsn_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mme Bafarasai bangwe ba re, “Ga go ka fa molaong! Barutwa ba gago ba roba mabele, mme go kgatlhanong le molao wa Sejuta go dira jalo go le Sabata.” ");
INSERT INTO tsn_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesu a fetola a re, “A ga lo bale dikwalo? a ga lo ise lo ke lo bale se Kgosi Dafide o neng a se dira fa ene le batho ba gagwe ba ne ba tshwerwe ke tlala? ");
INSERT INTO tsn_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","O ne a tsena mo teng ga Tempele mme a tsaya senkgwe sa tshupelo, senkgwe se se neng se tlhophetswe go bewa fa pele ga Morena, mme a se ja se sa letlelelwa go jewa fela jaaka mo go sa letlelelwa mme a se kgaogana le ba bangwe.” ");
INSERT INTO tsn_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Mme Jesu a tlatsa a re, “Ke Morena le wa Sabata tota.” ");
INSERT INTO tsn_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ka Sabata nngwe o ne a le mo tlung ya thuto a ruta, mme monna mongwe a ba a le foo yo o golafetseng letsogo le legolo. ");
INSERT INTO tsn_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Baruti ba molao le Bafarasai ba lebelela sentle go bona gore a o tlaa fodisa monna ka letsatsi leo, ka e ne e le la Sabata. Gonne ba ne ba ikaeletse go mmaya molato. ");
INSERT INTO tsn_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Hong a itse megopolo ya bone jang! Mme a raya monna yo o neng a golafetse letsogo a re, “Tla o eme fa, fa mongwe le mongwe a tlaa go bonang gone.” Mme monna a dira jalo. ");
INSERT INTO tsn_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Hong Jesu a raya Bafarasai le baruti ba molao a re, “Ke na le potso. A go siame go dira tshiamo ke letsatsi la Sabata, kgotsa go tlhokofatsa? Go boloka botshelo kgotsa go bo senya?” ");
INSERT INTO tsn_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","A leba mongwe le mongwe wa bone mme a raya monna a re, “Otlolola letsogo la gago,” mme ya re a le otlolola, la fola! ");
INSERT INTO tsn_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mme ya re ka ntlha ya tiragalo e, baba ba ga Jesu ba galefa thata, mme ba simolola go rerisanya polao ya gagwe. ");
INSERT INTO tsn_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ka letsatsi lengwe Jesu a tswela mo dithabeng go ya go rapela, bosigo jotlhe. ");
INSERT INTO tsn_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mme ya re letsatsi le tswa a bitsa balatedi ba gagwe a tlhopha ba le lesome le bobedi mo go bone go nna baeteledipele ba barutwa ba gagwe. (Ba ne ba tlhomamisiwa jaaka “Baapostoloi,” ba gagwe kgotsa “Barongwa.”) ");
INSERT INTO tsn_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Maina a bone ke a: Simone (yo o neng a bidiwa Petere), Anderea (monnawe Simone), Jakobe, Filipo, Barotholomea, Mathaio, Thomase, Jakobe, (morwa Alafaio), Simone, (yo o neng a bidiwa “Moselote”) Judase (morwa Jakobe), Judase Isekariota (yo o neng ya re morago a oka Jesu). ");
INSERT INTO tsn_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Erile fa ba fologa mekgokolosa ya thaba, ba ema le Jesu mo lobaleng lo lo tona, ba dikaganyeditswe ke bontsi jwa balatedi ba gagwe, ba le bone ba neng ba dikaganyeditswe ke bontsintsi jwa batho. Gonne batho botlhe ba ba tswang mo tikologong ya Judea le go tswa Jerusalema le go tswa bokgakala jwa bokone jwa lotshitshi lwa lewatle la Ture le Sidona ba ne ba tsile go mo reetsa a ruta kgotsa a fodisa. Mme a kgoromeletsa mewa e e maswe e le mentsi ntle. ");
INSERT INTO tsn_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mongwe le mongwe o ne a leka go mo ama, gonne ka go dira jalo nonofo ya phodiso e ne e tswa mo go ene mme ba fodisiwe. ");
INSERT INTO tsn_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Hong a retologela kwa barutweng ba gagwe a ba raya a re, “Lo sego lona ba lo bahumanegi, gonne Bogosi jwa Modimo ke jwa lona! ");
INSERT INTO tsn_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Lo sego lona ba lo bolawang ke tlala, gonne lo tlaa kgorisiwa. Lo sego lona ba lo lelang gonne nako e e tla, e lo tlaa tshegang ka boitumelo! ");
INSERT INTO tsn_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Lo sego motlhang batho ba ba lo ilang ba ikgaoganya le lona ba lo kgoba ba lo senya leina ka ntlha ya gore lo ba me! ");
INSERT INTO tsn_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Fa moo go diragala itumeleng! Ee, ipeleng gonne lo tla nna le tuelo e kgolo. Mme lo tlaa nna mo lesomong le le siameng baporofiti ba bogologolo ba ne ba dirwa jalo le bone. ");
INSERT INTO tsn_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Mme mafutsana a letile bahumi! Gonne ba na le boitumelo fela fano. ");
INSERT INTO tsn_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ba nonne ba tsweletse pele gompieno, mme lobaka lwa tlala e e boitshegang lo ba letile. Ditshego tsa bone tse e seng tsa sepe gompieno di raya kutlobotlhoko. ");
INSERT INTO tsn_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mme kutlobotlhoko e lebagane ba ba galalediwang ke batho gonne baporofiti ba tsietso ba ne ba aga ba galalediwa jalo. ");
INSERT INTO tsn_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Reetsang! Ratang baba ba lona. Direlang tshiamo ba ba lo ilang. ");
INSERT INTO tsn_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Rapelelang boitumelo ba ba lo hutsang; kopelang ba ba lo utlusang botlhoko matlhogonolo a Modimo. ");
INSERT INTO tsn_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Fa mongwe a go faphola mo lerameng, mo lese a faphole le lengwe! Fa mongwe a go kopa baki, mo nee le hempe ya gago. ");
INSERT INTO tsn_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Naya se o nang naso yo o se kopang; mme fa dilo di tshotswe mo go wena, se tshwenyege ka gore di boe. ");
INSERT INTO tsn_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Direla ba bangwe jaaka o batla ba go direla. ");
INSERT INTO tsn_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“A o gopola gore o tshwanetswe ke tlotlo ka go rata ba ba go ratang fela? Le baleofi ba dira jalo! ");
INSERT INTO tsn_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mme fa o direla molemo fela ba ba go direlang molemo-a moo go siame? Le baleofi ba dira jalo! ");
INSERT INTO tsn_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Fa o adima madi fela ba ba go duelang ana ke tshiamo, efe? Le baikepi ba bagolo le bone ba tle ba adime baikepi ka bone gore ba amogele mo go kalo gape! ");
INSERT INTO tsn_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Ratang baba ba lona! Ba direleng tshiamo. Ba adimeng! Mme lo se ka lwa tshwenyega ka gore ga ba kitla ba duela. Hong tuelo ya lona kwa legodimong e tlaa nna kgolo thata, mme ruri lo tlaa dira jaaka bomorwa Modimo: Gonne o siametse ba ba sa lebogeng le ba ba bosula. ");
INSERT INTO tsn_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","“Leka go supa kutlwelo botlhoko e tona jaaka Rraeno a dira. ");
INSERT INTO tsn_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“O se ka wa tshwaya diphoso kgotsa wa sekisa, e se re kgotsa ga boela mo go wena. Direla ba bangwe ka bopelonomi; mme le bone ba tlaa go direla jalo. ");
INSERT INTO tsn_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gonne fa o aba, o tlaa bona! Mpho ya gago e tlaa go boela ka botlalo e bile e le selekanyo se se tshologang, e papietswe e tshikintswe go direla tse dingwe photlha, e bile e penologa. A e ka bo e le selekanyo sefe se o se dirisang se se tona kgotsa se se nnye se tlaa dirisiwa go lekanya se se go boelang.” ");
INSERT INTO tsn_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Dingwe tsa ditshwantsho tsa dipolelo tse Jesu a neng a di dirisa mo ditherong tsa gagwe ke tse: “Go thusang gore sefofu se etelele se sengwe kwa pele? Gonne e tlaa re se wela mo kgatamping se gogele se sengwe mo teng. ");
INSERT INTO tsn_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","“Moithuti o ka itse jang go gaisa moruti wa gagwe? Mme fa a ithuta thata o ka tshwana le moruti wa gagwe. ");
INSERT INTO tsn_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Mme ke eng fa o tshwenyega kaga selabe se se mo leitlhong la yo mongwe ebong molato o monnye wa gagwe fa mosipori o le mo go la gago? ");
INSERT INTO tsn_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","O ka akanya jang go mo raya o re, mokaulengwe, tla ke go thuse go ntsha selabe mo leitlhong la gago, fa o sa kgone go bona ka ntlha ya mosipori pele ke gone gongwe o ka bonang sentle go dira sengwe ka selabe sa gagwe. Moitimokanyi: ");
INSERT INTO tsn_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Setlhare se se tswang mo thitong e e siameng ga se ka ke sa ungwa loungo lo lo motlhofo le ditlhare tse di tswang mo thitong e e motlhofo ga di ka ke tsa ungwa loungo lo lo tlhophegileng. ");
INSERT INTO tsn_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Setlhare se lemogwa ka mofuta wa loungo lwa sone. Maungo a difeige ga a ka ke a ungwiwa ke ditlhare tse di mitlwa, kgotsa moretlwa mo manganeng. ");
INSERT INTO tsn_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","“Motho yo o siameng o ntsha ditiro tse di siameng mo pelong e e siameng. Mme motho yo o bosula o ntsha dilo tse di bosula mo boikepong jwa gagwe jo bo fitlhegileng. Sengwe le sengwe se se mo pelong ya gagwe se fetogela mo puong. ");
INSERT INTO tsn_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Jaanong ke eng fa lo mpitsa Morena lo sa nkutlwe? ");
INSERT INTO tsn_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Mme botlhe ba ba tlang go reetsa le go nkutlwa ba tshwana le monna yo o agang ntlo mo motheong o o nonofileng o o beilweng mo lefikeng le le kwa tlase. E re fa merwalela e tlhatloga e thubaka ntlo, e eme e nitame mo lefikeng. ");
INSERT INTO tsn_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mme ba ba reetsang mme ba sa utlwe ba tshwana le monna yo o agileng ntlo e e senang motheo. E re fa merwalela e elelela mo tlung eo, e senyege e be e tswe letlotla.” ");
INSERT INTO tsn_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Erile Jesu a sena go fetsa thero ya gagwe a boela mo motsing wa Kaperenama. ");
INSERT INTO tsn_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Fela ka yone nako eo motlhanka yo mogolo wa moeteledi pele wa mophato wa Seroma o ne a lwala a bile a le gaufi le go swa. ");
INSERT INTO tsn_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","E rile fa moeteledipele wa mophato a utlwa kaga Jesu, a romela bangwe ba Sejuta ba ba tlotlegang go ya go mo kopa gore a tle go fodisa motlhanka wa gagwe. ");
INSERT INTO tsn_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Hong ba simolola go kopa Jesu ka tlhoafalo go ya le bone go thusa monna yoo. Ba mmolelela ka fa moeteledipele wa masole o neng a le senatla ka gone. “Fa mongwe a tshwanelwa ke go thusiwa, ke ene, ");
INSERT INTO tsn_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","gonne o rata Bajuta o bile o re agetse ntlo ya thuto!” ");
INSERT INTO tsn_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Jesu a tsamaya le bone; mme ya re pele ga ba goroga kwa tlung, moeteledipele wa masole a romela ditsala dingwe go ya gore, “Morena o se ka wa itapisa ka go tla kwa lwapeng la me, gonne ga ke a tshwanelwa ke tlotlo e e kalo kgotsa le fa e le go ka kopana nao, bua lefoko fela fa o leng teng mme motlhanka wa me o tlaa fola. ");
INSERT INTO tsn_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ke a itse, ka gore ke ka fa tlase ga taolo ya maotlana a magolo, mme ke na le taolo mo bathong ba me. Ke na le tshwanelo ya gore ‘Tsamayang!’ mme ba tsamaye; kgotsa ‘Tlang!’ mme ba tle; mme ke reye motlhanka wa me ke re, dira se kgotsa sele; mme a se dire. Jalo, bua fela jaana o re, ‘Fola’ mme motlhanka wa me o tlaa fola!.” ");
INSERT INTO tsn_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesu a hakgamala. A retologela kwa bathong ba ba kgobokaneng a re, “Ga ke ise nke ke kopane le motho wa tumelo e e ntseng jaana mo Bajuteng botlhe ba ba mo Iseraele.” ");
INSERT INTO tsn_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mme ya re ditsala tsa moeteledipele wa masole di boela kwa tlung ya gagwe, tsa fitlhela motlhanka a fodile gotlhelele! ");
INSERT INTO tsn_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Morago ga lobakanyana Jesu a tsamaya le barutwa ba gagwe ba ya kwa motsaneng wa Naine le batho ba bantsi ba mo kgobokanetse jaaka gale. ");
INSERT INTO tsn_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Popelelo ya phitlho ya tswela kwa ntle fa Jesu a atamela kgoro ya motsana. Mosimane yo o neng a sule e ne e le ene fela ngwana wa mosimane wa mosadi wa motlholagadi, mme bahutsahadi ba le bantsi ba tswa nae mo motsaneng oo. ");
INSERT INTO tsn_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","E rile fa Morena a mmona, pelo ya gagwe ya tlala kutlwelobotlhoko. Mme a mo raya a re, “Se lele!” ");
INSERT INTO tsn_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Hong a tsamaela kwa kesing ya moswi! Mme a e ama, mme batshodi ba yone ba ema. A mo raya a re, “Morwaaka, tsoga mo losong!” ");
INSERT INTO tsn_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Hong mosimane a nna sentle mme a simolola go bua le ba ba neng ba mo dikaganyeditse! Mme Jesu a mmusetsa kwa go mmaagwe. ");
INSERT INTO tsn_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Letshogo le legolo la tsena batho, mme ba goa ba baka Modimo. Ba re, “Moporofiti yo mogolo o tsogile mo gare ga rona mme re bonye letsogo la Modimo le dira gompieno!” ");
INSERT INTO tsn_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Polelo ya se a se dirileng ka letsatsi leo ya anamela ka bonako go tswa ntlheng e nngwe go ya go e nngwe ya Judea le go kgabaganya melelwane tota. ");
INSERT INTO tsn_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Mme barutwa ba ga Johane wa Mokolobetsi ba tloga ba utlwa gotlhe mo Jesu o neng a go dira. Ya re ba bolelela Johane kaga gone, ");
INSERT INTO tsn_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","a romela bangwe ba barutwa ba gagwe ba le babedi kwa go Jesu go ya go mmotsa ba re, “A o Mesia tota? Kgotsa re nne re mo lebeletse?” ");
INSERT INTO tsn_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","22","Barutwa ba babedi ba fitlhela Jesu a sa ntse a alafa balwetse ba malwetse a a farologanyeng, a fodisa digole le difofu ebile a kgoromeletsa ntle mewa e e maswe. Erile ba mmotsa potso ya ga Johane, a fetola a re, “Boelang kwa go Johane mme lo mmolelele gotlhe mo lo go boneng le mo lo go utlwileng gompieno: gore ba ba neng ba foufetse ba a bona! Batlhotsi ga ba tlhole ba tlhotsa! Balepero ba setse ba fodisitswe! Bosusu ba a utlwa! Baswi ba a rula! Mme bahumanegi ba utlwa Mafoko a a Molemo. ");
INSERT INTO tsn_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mme lo mmolelele gore, ‘Go sego yo o sa latlhegelwang ke tumelo mo go nna.’ ” ");
INSERT INTO tsn_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Erile ba sena go tsamaya Jesu a bua le batho kaga Johane. A re, “Motho yo ke mang yo lo neng lo ile go mmona mo sekakeng sa Judea? A lo ne lwa mmona a le motlhofo jaaka bojang jo bo sutisiwang ke mosumo mongwe le mongwe wa phefo! ");
INSERT INTO tsn_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","A lo kile lwa mmona a apere diaparo tse di tlhwatlhwa kgolo? Nnyaa! Batho ba ba nnang mo monateng ba bonwa mo matlung a segosi, e seng kwa ntle mo sekakeng. ");
INSERT INTO tsn_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mme a lo kile lwa bona moporofiti? Ee! Le go feta moporofiti? ");
INSERT INTO tsn_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ke ene yo dikwalo di neng di mo raya fa di re, ‘Bona! Ke romela morongwa wa me kwa pele ga gago, go go baakanyetsa ditsela!’ ");
INSERT INTO tsn_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mo bathong botlhe ga go na ope yo mogolo go feta Johane. Mme le fa go ntse jalo yo mmotlana mo Bogosing jwa Modimo o mogolo go mo feta.” ");
INSERT INTO tsn_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mme botlhe ba ba utlwileng Johane a rera, le e leng bone ba ba neng ba le bosula thata, ba dumela gore se se batlwang ke Modimo se siame, mme ba kolobediwa ke ene. ");
INSERT INTO tsn_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Botlhe ba kolobediwa kwa ntle ga Bafarasai le baruti ba molao wa ga Moshe. Ba ne ba gana leano la Modimo mo go bone mme ba gana kolobetso ya ga Johane. ");
INSERT INTO tsn_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Mme Jesu a ba botsa a re, “Ke ka reng ka batho ba ba ntseng jalo? Ke ka ba tshwantsha le eng? ");
INSERT INTO tsn_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ba tshwana le setlhopha sa bana ba ba ngongoregang mo ditsaleng tsa bone, ba re, ‘Ga lo rate fa re tshameka “Lonyalo” e bile ga lo rate fa re tshameka phitlho!’ ");
INSERT INTO tsn_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Gonne Johane wa Mokolobetsi o ne a tlwaetse go tsamaya a sa tsaya dijo e bile a se ke a tsaya seno mo botshelong jwa gagwe jotlhe, mme lwa re, ‘O tshwanetse a ba a tsenwa!’ ");
INSERT INTO tsn_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mme ke ja dijo tsa me e bile ke nwa mofine wa me mme lwa re, ‘Kana Jesu o rata dijo jang! E bile o a nwa! E bile o na le ditsala tsa mofuta o o kwa tlase!’ ");
INSERT INTO tsn_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mme nna ke tlhomamisa gore lo ka kgona go itshegetsa mo tshiamololong ya lona.” ");
INSERT INTO tsn_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Hong mongwe wa Bafarasai a kopa Jesu gotla kwa lwapeng lwa gagwe go ya go ja, mme Jesu a amogela taletso eo. Ya re ba nna fa fatshe ba a ja, ");
INSERT INTO tsn_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","mosadi wa mebila, wa seaka, a utlwalela fa Jesu a le foo mme a lere lebotlolo le tletse setlolo se se tlhwatlhwa kgolo. ");
INSERT INTO tsn_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ya re a tsena mo teng a obama fa dinaung tsa gagwe ka mangole, a lela go fitlhela dinao tsa ga Jesu di kolobediwa ke dikeledi tsa gagwe; mme a di phimola ka moriri wa gagwe a di atla a ba a tshela setlolo mo go tsone. ");
INSERT INTO tsn_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","E rile Mofarasai mongwe yo Jesu o neng a mmiditse, a bona se se diregang le gore mosadi e ne e le mang, a ithaya a re, “Se supa gore Jesu ga se moporofiti, gonne fa tota a ne a romilwe ke Modimo, o ka bo a itsile gore mosadi yo ke wa mofuta ofe!” ");
INSERT INTO tsn_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Hong Jesu a buela kwa godimo a araba dikakanyo tsa ga Simone wa Mofarasai a re, “Ke na le sengwe se ke batlang go se bua le wena.” Simone a fetola are, “Gosiame moruti, tswelela.” ");
INSERT INTO tsn_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Hong Jesu a mmolelela polelo e: “Monna o kile a adima batho ba babedi madi, a adima yo mongwe dikete di le tlhano tsa dipula mme a adima yo mongwe makgolo a matlhano a dipula. ");
INSERT INTO tsn_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mme ga go ise go ke go nne le ope wa bone yo o neng a mo duela, jalo ka bopelo-tlhomogi a ba itshwarela botlhe, a ba lesa gore ba seka ba duela. Ke ofe yo o gopolang gore o ne a mo rata thata morago ga moo?” ");
INSERT INTO tsn_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simone a araba a re, “Ke gopola gore ke yo o neng a mo kolota thata.” Jesu a dumela a re go ntse jalo. ");
INSERT INTO tsn_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Hong a retologela kwa mosading a raya Simone a re, “A o bona mosadi yo o khubameng fa yo! Erile ke tsena mo lwapeng lwa gago ga o a ka wa tshwenyega ka go nnaya metse go tlhapa lorole mo dinaong tsa me, mme ene o di tlhapisitse ka dikeledi tsa gagwe a ba a di phimola ka moriri wa gagwe! ");
INSERT INTO tsn_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Lo nkganeletse katlo ya tlwaelesego ya tumediso, mme ene o atlile dinao tsa me gangwe le gape go simologa ka nako e ke neng ke goroga ka yone. ");
INSERT INTO tsn_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Lo ne lwa tlhokomologa bopelonomi jwa gale jwa lookwane lwa motlhware go tlotsa tlhogo ya me, mme ene o bipile dinao tsa me ka setlolo se se sa tlwaelesegang. ");
INSERT INTO tsn_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ka moo dibe tsa gagwe tse dintsi di itshwaretswe, gonne o nthatile thata; mme yo o itshwaretsweng go le gonnye go supa lorato lo lo nnye.” ");
INSERT INTO tsn_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mme a mo raya a re, “Dibe tsa gago di itshwaretswe.” ");
INSERT INTO tsn_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mme banna ba ba neng ba ntse fa lomating lwa bojelo ba raana ba re, “Monna yo o akanya gore ke mang, yo o tsamayang a itshwarela dibe?” ");
INSERT INTO tsn_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mme Jesu a raya mosadi a re, “Tumelo ya gago e go bolokile; tsamaya ka kagiso.” ");
INSERT INTO tsn_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mme ka bofefo morago ga moo a etela metse le metsana ya Galalea go bolela go tla ga Bogosi jwa Modimo, mme a tsamaya le barutwa ba gagwe ba ba lesome le bobedi. ");
INSERT INTO tsn_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Basadi bangwe ba tsamaya nae, ba o ntshitseng mewa e e maswe mo go bone kgotsa ba o ba fodisitseng; mo go bone go ne go le Marea Magatalena (Jesu o ne a ntshitse mewa e e maswe ele supa mo go ene). ");
INSERT INTO tsn_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana mosadi wa ga Chusa (Chusa e ne e le molaodi wa papadi ya ga Kgosi Herode a bile a le motlhokomedi wa ntlo ya segosi le dilwana tsa yone). Susana, le ba bangwe ba ba neng ba ntsha dikatso go otla Jesu le barutwa ba gagwe. ");
INSERT INTO tsn_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ka letsatsi lengwe a neela boidiidi jwa batho ba ba neng ba phuthegile go tla go mo utlwa, setshwantsho se, fa ba bangwe ba bantsi ba sa ntse ba le mo tseleng ba tswa mo metseng e mengwe. ");
INSERT INTO tsn_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Molemi o kile a tswela kwa tshimong ya gagwe go ya go jala peo. Ya re a gasa peo fa fatshe, nngwe ya yone ya wela mo tseleng mme ya gatakwa; mme dinonyane tsa e e ja ka e ne e le mo lobaleng. ");
INSERT INTO tsn_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Peo e nngwe ya wela mo mmunyaneng o go neng go ikadile letlapa ka fa tlase ga one. Peo ya simolola go gola, mme ka bonako ya swaba ya a swa ka ntlha ya go tlhoka longola. ");
INSERT INTO tsn_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Peo e nngwe ya wela mo gare ga masitlwana, mme medi e mennye ya akofa ya hupela. ");
INSERT INTO tsn_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","E nngwe ya wela mo mmung o o molemo; peo e ya gola ya ungwa thobo ya selekanyo sa lekgolo go menagane go gaisa ka fa a neng a jetse ka teng.” (Ya re a a fa setshwantsho se a re, “Yo o nang le ditsebe a a utlwe.”) ");
INSERT INTO tsn_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Baapostoloi ba gagwe ba mmotsa gore polelo e e rayang. ");
INSERT INTO tsn_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Mme a fetola a re, “Modimo o lo letleletse go itse tlhaloso ya ditshwantsho tse, gonne di bolela tiro e kgolo ya Bogosi jwa Modimo. Mme bontsintsi jo jwa batho bo utlwa mafoko mme ga ba tlhaloganye, fela jaaka baporofiti ba boletse. ");
INSERT INTO tsn_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Tlhaloso ya sone ke e: Peo ke molaetsa wa Modimo mo bathong. ");
INSERT INTO tsn_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Tsela e e kwakwaletseng e peo nngwe e wetseng mo go yone e tshwantshiwa le dipelo tse di thata tsa batho ba ba utlwang mafoko a Modimo, mme diabolo a tle a utswe mafoko a kganele batho go dumela le go bolokwa. ");
INSERT INTO tsn_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Lefatshe le le maje le tshwantshiwa le ba ba itumelelang go reetsa dithero, mme ka mokgwa mongwe molaetsa tota o sa tsene mo go bone le gone ga o mele ebile ga o gole. Ba a itse gore molaetsa o o boammaaruri mme ba dumela ka lobakanyana fela; ere fa dipogiso di tla ba felelwe, ke kgatlhego. ");
INSERT INTO tsn_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Peo e e mo gare ga mitlwa e tshwantshiwa le batho ba ba dumelang mafoko a Modimo mme ba e reng morago tumelo ya bone e hupediwe ke matshwenyego le dikhumo le ditiro le maitumelo a botshelo. Mme jalo ga ba na nonofo ya go thusa ope go dumela Mafoko a a Molemo. ");
INSERT INTO tsn_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Mme mmu o o molemo o tshwantshiwa le batho ba ba ikanyegang ba ba pelo di siameng. Ba reetsa mafoko a Modimo ba a tshegetse mme ba a anamise ka bonya mo go ba bangwe.” ");
INSERT INTO tsn_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ka nako e nngwe a botsa a re, “E mang yo o kileng a utlwalela mongwe yo e a reng a sena go tshuba lobone a lo khurumetse gore lo se ka lwa bonesa? Nnyaa! Dipone di bewa mo di ka bonwang teng. ");
INSERT INTO tsn_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Se se supa gore ka letsatsi leo sengwe le sengwe mo dipelong tsa batho se tlaa leriwe mo leseding mme se supegediwe botlhe. ");
INSERT INTO tsn_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jalo itlhokomeleng ka fa lo reetsang ka gone, gonne yo o nang le gone, o tlaa newa mo go tona; mme le fa e le mang yo o senang sepe, le e leng se o nang naso tota o tlaa se tseelwa.” ");
INSERT INTO tsn_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mme ya re ka nako nngwe fa mmaagwe le bomonnawe ba tsile go mmona, ba seka ba tsena mo tlung e o neng a ruta mo go yone ka ntlha ya bontsintsi jwa batho. ");
INSERT INTO tsn_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","E rile Jesu a utlwa fa ba eme kwa ntle ba batla go mmona, ");
INSERT INTO tsn_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","a re, “Mme le bonnake ke botlhe ba ba utlwang molaetsa wa Modimo ba bo ba o tshegetsa.” ");
INSERT INTO tsn_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ka letsatsi lengwe mo lobakeng loo, fa ene le barutwa ba gagwe ba le kwa ntle mo mokorong, a ntsha mogopolo wa gore ba kgabaganyetse ka kwa ntlheng e nngwe ya lecha. ");
INSERT INTO tsn_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mme ya re ba kgabaganya a rapama a thulamela, mme ya re a sa ntse a robetse ga tsoga matsubutsubu a phefo a a boitshegang a leka go kgaphela mokoro mo lewatleng. Mme ba ne ba le mo diphatseng tse di kgolo. ");
INSERT INTO tsn_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mme ba taboga ba mo tsosa ba goa ba re, “Morena, Morena re a nwela!” Hong a bua le phefo a re, “Kgaotsa,” mme diphefo le makhubu a metse tsa khutla, gotlhe ga nna tidimalo. ");
INSERT INTO tsn_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Mme a ba botsa a re, “Tumelo ya lona e kae?” Mme ba bo ba tletse therego le go mmoifa ba raana ba re, “Monna yo ke mang, yo le e leng diphefo le makhubu a metse a mo utlwang?” ");
INSERT INTO tsn_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Mme ba goroga ka fa ntlheng e nngwe, mo lefatsheng la Bagerasena go lebagana le lecha la Galalea. ");
INSERT INTO tsn_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ya re a fologa mo mokorong monna yo o tswang mo motseng wa Gatara a tla go mo kgatlhantsha, monna yo o neng a tsenwe ke mewa e e maswe ka lobaka lo lo leele. A se na legae a bile a sa ikatega, a nna mo mabitleng mo gare ga diphupu. ");
INSERT INTO tsn_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ya re ka bonako fa a bona Jesu a gala a wela fa fatshe fa pele ga ga Jesu, a goa, a re, “O batla go dirang ka nna, Jesu, Morwa Modimo o o tlotlegang? Tsweetswee, ke a go rapela, o se ka wa ntlhokofatsa!” ");
INSERT INTO tsn_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Gonne Jesu o ne a setse a laola mowa o o maswe gore o tswe mo go ene. Mowa o o maswe o ne o tle o laole monna yo mo e leng gore e ne e tle e re le fa a bofilwe ka dikeetane a kgaole mme a siele mo nageng, a laolwa ke mowa o o maswe gotlhelele. ");
INSERT INTO tsn_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mme Jesu a botsa mowa oo maswe a re, “Leina la gago ke mang?” Mme wa fetola wa re, “Diketekete,” gonne o ne a tletse diketekete tsa mowa o o maswe! ");
INSERT INTO tsn_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mme ya mo kopa gore a se ka a e laolela go tsena mo lehuting le le senang bolekanngo. ");
INSERT INTO tsn_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Serapa sa dikolobe sa bo se fula gautshwane mo mhapheng wa thaba mme mewa e e maswe ya mo kopa gore a e letle go tsena mo dikolobeng. Mme Jesu a e letla. ");
INSERT INTO tsn_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mme ya tswa mo monneng ya tsena mo dikolobeng, mme ka bonako serapa sotlhe sa kgokologa thaba sa wela mo teng ga lecha kwa tlase, mo di neng tsa nwela teng tsotlhe. ");
INSERT INTO tsn_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Hong badisa ba dikolobe ba sianela kwa motsing o o gaufi, ba gasa mafoko fa ba ntse ba siana. ");
INSERT INTO tsn_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ka bofefo bontsintsi jwa batho jwa tla go iponela ka bobone se se diragetseng mme ba bona monna yo o neng a tsenwe ke mowa o o maswe a ntse ka tidimalo fa dinaong tsa ga Jesu, a apere a bile a ikutlwa sentle. Mme bontsintsi jwa batho botlhe ba tshoga thata. ");
INSERT INTO tsn_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Hong ba ba neng ba bone selo se se diragala ba bolela ka fa monna yo o neng a tsenwe ke mewa e e maswe a fodisitsweng ka teng. ");
INSERT INTO tsn_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mme batho botlhe ba kopa Jesu gore a tsamaye a ba tlogele (gonne therego e kgolo ya letshogo e ne ya ba wela). Mme a boela kwa mokorong a tsamaya, a kgabaganyetsa gape ka kwa ntlheng e nngwe ya lecha. ");
INSERT INTO tsn_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Monna yo o neng a tsenwe ke mewa e e maswe a kopa go tsamaya le ene, mme Jesu a gana. ");
INSERT INTO tsn_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","A mo raya a re, “Boela kwa go ba ntlo ya gago, o ba bolelele selo se sentle se Modimo o se go diretseng.” O ne a tsamaya le motse otlhe a bolelela mongwe le mongwe kaga kgakgamatso e kgolo ya ga Jesu. ");
INSERT INTO tsn_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ka fa ntlheng e nngwe ya lecha bontsintsi jwa batho jwa mo amogela ka botlalo, gonne ba ne ba ntse ba mo lebeletse. ");
INSERT INTO tsn_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mme jaanong monna yo o neng a bidiwa Jairo, moeteledipele wa ntlo ya thuto ya Sejuta, a tla a wela fa dinaong tsa ga Jesu a mo kopa gore a ye nae kwa ga gagwe, ");
INSERT INTO tsn_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","gonne ngwana wa gagwe yo o esi o ne a swa, morweetsana wa dingwaga tse di lesome le bobedi. Mme Jesu a tsamaya nae, ba sutlhelela ka bothata mo gare ga batho. ");
INSERT INTO tsn_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","44","Ya re ba ntse ba tsamaya mosadi yo o neng a batla phodiso a tla kwa morago a ama Jesu, gonne o ne a dutlile madi ka bonya selekanyo sa dingwaga di le lesome le bobedi, mme a sa bone kalafi (ntswa a sentse sengwe le sengwe se a neng a na naso mo dingakeng), mme nako e o neng a ama ntlha ya seaparo sa ga Jesu, madi a ema. ");
INSERT INTO tsn_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mme Jesu a botsa a re, “Ke mang yo o nkamileng?” Mme mongwe le mongwe a itatola, mme Petere a re, “Morena, bontsintsi bo go dikaganyeditse…” ");
INSERT INTO tsn_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mme Jesu a mo raya a re, “Nnyaa, e ne e le mongwe fela yo o nkamileng ka bomo, gonne ke utlwile nonofo ya phodiso e tswa mo go nna.” ");
INSERT INTO tsn_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mme ya re mosadi a lemoga gore Jesu o a itse, a simolola go roroma a wela fa fatshe ka mangole fa pele ga gagwe a mmolelela go re o ne a mo amelang le gore jaanong o fodile. ");
INSERT INTO tsn_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Hong Jesu a mo raya a re, “Morwadiaka, tumelo ya gago e go fodisitse. Tsamaya ka kagiso.” ");
INSERT INTO tsn_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","E rile a sa ntse a bua le ene, morongwa a goroga a tswa kwa lapeng la ga Jairo ka mafoko a a reng ngwanyana o sule. A raya rraagwe ngwana a re, “O sule, ga go thuse go tshwenya Moruti jaanong.” ");
INSERT INTO tsn_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mme e rile fa Jesu a utlwalela se se diragetseng, a raya rraagwe ngwana a re, “Se boife! Ikanye nna fela, ngwana o tla siama.” ");
INSERT INTO tsn_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ya re ba goroga kwa tlung Jesu a se ka a letla ope go tsena mo tlung fa e se Petere, Jakobe le Johane le batsadi ba morweetsana. ");
INSERT INTO tsn_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Lelapa le ne le tletse batho ba ba hutsafetseng, mme a re, “Lesang go lela! Ga a a swa; o robetse fela!” ");
INSERT INTO tsn_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Se sa tlisa tshotlo le setshego, gonne ba ne ba itse botlhe gore o sule. ");
INSERT INTO tsn_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Hong a mo tshwara ka seatla a mmitsa a re, “Tsoga morweetsana.” ");
INSERT INTO tsn_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mme ka yone nako eo a rula a nanoga! A ba raya a re, “Mo neeng sengwe a je!” ");
INSERT INTO tsn_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Batsadi ba gagwe ba ne ba itumela thata. Mme Jesu a ba laya gore ba seka ba bolelela ope kaga se se diragetseng. ");
INSERT INTO tsn_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Mme ya re ka letsatsi lengwe Jesu a phutha baaposetoloi ba gagwe ba ba lesome le bobedi! A ba naya taolo mo meweng e e bosula, a ba naya nonofo go e kgoromeletsa ntle go fodisa malwetse otlhe. ");
INSERT INTO tsn_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Hong a ba roma go ya go bolelela mongwe le mongwe kaga go tla ga Bogosi jwa Modimo le go fodisa balwetse. ");
INSERT INTO tsn_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","A ba laela a re, “Se tseyeng le fa e le seikokotlelo, kgotsa kgetsana ya loeto, kgotsa dijo, kgotsa madi le fa e le hempe e nngwe. ");
INSERT INTO tsn_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Lo nne fela fa lo gorogetseng teng mo motsing mongwe le mongwe. ");
INSERT INTO tsn_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","“Fa batho ba motse ba sa lo reetse fa lo tsena, hularang lo tsamaye, lo supa bogale jwa Modimo kgatlhanong le motse o o ka go itlhotlhora lorole lwa one mo dinaong tsa lona fa lo tsamaya.” ");
INSERT INTO tsn_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mme jalo ba simolola go tlhatlologanya metsana, ba rera Mafoko a a Molemo ba bile ba fodisa balwetse. ");
INSERT INTO tsn_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Mme e rile fa dipolelo tsa dikgakgamatso tsa ga Jesu di tsena kwa go Herode wa mmusi, a tshwenyega thata a akabala, gonne bangwe ba ne ba re “Ke Johane wa Mokolobetsi o rudile”, ");
INSERT INTO tsn_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ba bangwe ba re, “Ke Elija kgotsa mongwe wa baporofiti ba bogologolo o tsogile mo losong.” Mme magatwe a a anama le lefatshe lotlhe. ");
INSERT INTO tsn_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mme Herode a re, “Ke kgaotse Johane tlhogo.” “Jaanong ke mang monna yo ke utlwang dipolelo tse di sa tlwaelesegang ka ga gagwe?” Mme a eletsa go mmona. ");
INSERT INTO tsn_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mme ya re Baapostoloi ba sena go boela kwa go Jesu go ya go bolela se ba se dirileng, a ngwangwaela ka tidimalo le bone go ya kwa motsing wa Bethesaida. ");
INSERT INTO tsn_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mme bontsintsi jwa batho jwa bona kwa o yang gone, mme ba mo sala morago. A ba amogela a ba ruta gape kaga Bogosi jwa Modimo a ba a fodisa ba ba neng ba lwala. ");
INSERT INTO tsn_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mo tshokologong barutwa botlhe ba ba lesome le bobedi ba tla ba mo kopa gore a phatlalaletse batho kwa metsaneng le masimo a a gautshwane go ya go batla dijo le marobalo. Ba re, “Gonne ga go na se se jewang fa mo sekakeng se.” ");
INSERT INTO tsn_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mme Jesu a fetola a re, “Ba feng dijo!” Mme bone ba re, “Go reng, re na le dinkgwe di le tlhano fela le ditlhapi tse pedi mo gare ga bontsintsi jwa rona, kgotsa o gopotse gore re ye go rekela bontsintsi jo dijo tse di lekaneng?” ");
INSERT INTO tsn_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Gonne go ne go na le batho ba ka nna dikete tse tlhano foo. Jesu a fetola a re, “Ba reyeng ba nne fa fatshe ka ditlhopha tse di ka nnang tsa masome a matlhano.” ");
INSERT INTO tsn_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Mme ba dira jalo. ");
INSERT INTO tsn_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Mme Jesu a tsaya dinkgwe tse tlhano le ditlhapi tse pedi a leba kwa godimo mo loaping a leboga; mme a ngathoganyetsa barutwa ba gagwe go di abela batho. ");
INSERT INTO tsn_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mme mongwe le mongwe a ja a kgora; mme ga sala diroto di le lesome le bobedi di tletse masalela! ");
INSERT INTO tsn_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ka letsatsi lengwe fa a le esi, a rapela le barutwa ba gagwe, a tla kwa go bone a ba botsa a re, “Batho ba re ke mang?” ");
INSERT INTO tsn_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ba mo raya ba re, “Johane wa Mokolobetsi, kgotsa gongwe Elija kgotsa mongwe wa baporofiti ba bogologolo a tsogile mo losong.” ");
INSERT INTO tsn_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Hong a ba botsa a re, “Lona lo akanya gore ke mang?” Mme Petere a fetola a re, “O Mesia Keresete wa Modimo!” ");
INSERT INTO tsn_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Mme a ba naya ditaolo tse di gagametseng gore ba se ka ba bolelela ope. ");
INSERT INTO tsn_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","A re, “Gonne ke tlaa sotlega thata, e bile ke tlaa ganwa ke baeteledipele ba Sejuta, bagolwane, baperesiti ba bagolo le bomaitseanape ba molao, ke tlaa bolawa mme morago ga malatsi a mararo ke tlaa rula!” ");
INSERT INTO tsn_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mme a ba raya botlhe a re, “Le fa e le mang yo o batlang go ntshala morago a a tseye mokgoro wa gagwe letsatsi le letsatsi a nne gaufi le nna! ");
INSERT INTO tsn_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Le fa e le mang yo o latlhegelwang ke botshelo ka ntlha ya me, o tlaa bo boloka mme le fa e le mang yo o tsweletseng a boloka botshelo jwa gagwe bo tlaa mo latlhegela; ");
INSERT INTO tsn_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","mme go thusang gore motho a gape lefatshe lotlhe mme a latlhegelwe ke botshelo jwa gagwe? ");
INSERT INTO tsn_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Fa nna Morwa Motho, ke tla ka kgalalelo ya ga Rara le baengele ba ba boitshepo, ke tlaa ba tlhabelwa ke ditlhong botlhe ba ba ntlhabelwang ke ditlhong le mafoko a me gompieno. ");
INSERT INTO tsn_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mme boammaaruri jo e leng jone ke jo, bangwe ba lona ba ba emeng fano fa nako e, ga ba kitla ba a swa go fitlhelela lo sena go bona Bogosi jwa Modimo!” ");
INSERT INTO tsn_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Morago ga malatsi a le lesome le bofera bobedi Jesu a tsaya Petere, Jakoba le Johane go ya go rapela kwa dithabeng. ");
INSERT INTO tsn_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mme ya re a ntse a rapela, sefatlhogo sa gagwe sa simolola go phatsima le diaparo tsa gagwe tsa sweufala tsa lakasela. ");
INSERT INTO tsn_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Hong banna ba babedi Moshe le Elija ba iponatsa mme ba simolola go bua nae. ");
INSERT INTO tsn_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ba ne ba bonala ba galalela, ba le bantle thata; ba bua ka loso lwa gagwe lo lo tlaa diragalang kwa Jerusalema go diragatsa leano la Modimo. ");
INSERT INTO tsn_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petere le ba bangwe ba ne ba otsela ebile ba robetse. Hong ba tsoga ba bona Jesu a apesitswe ke phatsimo le kgalalelo, le banna ba babedi ba eme le ene. ");
INSERT INTO tsn_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Erile fa Moshe le Elija ba simolola go tsamaya, Petere a sa itlhaloganye, a bile a sa itse se a se buang a kgomoga a re, “Morena, go molemo jang! Re tlaa aga metlaagana e le meraro, o mongwe e le wa gago o mongwe e le wa ga Moshe o mongwe e le wa ga Elija.” ");
INSERT INTO tsn_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mme ya re a santse a bua jaana leru le le phatsimang la ikaga mo godimo ga bone; mme ba tshwarwa ke poifo fa le ba khurumetsa. ");
INSERT INTO tsn_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mme lentswe le le tswang mo lerung la re, “Yo ke morwaake, yo ke mo itlhaoletseng; mo utlweng.” ");
INSERT INTO tsn_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mme ya re morago, lentswe le sena go feta, Jesu a bo a le esi le barutwa ba gagwe. Mme ba seka ba bolelela ope se ba se boneng go fitlhelela morago ga lobaka lo lo leele. ");
INSERT INTO tsn_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mme ya re ka letsatsi le le latelang fa ba fologa thaba, boidiidi jo bogolo jwa batho jwa mo kgatlhantsha, ");
INSERT INTO tsn_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","hong monna mongwe mo bontsing a mo tlhaeletsa a re, “Moruti, mosimane yo o fano yo ke ene fela morwaake, ");
INSERT INTO tsn_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","mme mowa o o maswe o tsweletse ka go mo tshwenya, o mo dira gore a goe; mme o mo karalatse gore a bo a phoke mafulo mo molomong; o aga o mo keteka, mme ga o ke o bo o mo tlogela. ");
INSERT INTO tsn_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ke kopile barutwa ba gago gore ba kgoromeletse mowa o o maswe o kwa ntle mme ga ba a ka ba kgona.” ");
INSERT INTO tsn_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Hong Jesu a raya barutwa ba gagwe a re, “Batho ba ba logwadi ke lona ba lo senang tumelo, ke tlaa nna le lona lobaka lo lo kae? Mo tliseng kwano.” ");
INSERT INTO tsn_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ya re mosimane a tla mowa o o maswe wa mo digela fa fatshe wa mo karalatsa mo go botlhoko. Mme Jesu a laola mowa o o maswe gore o tswele kwa ntle, a fodisa mosimane mme a mo neela rraagwe. ");
INSERT INTO tsn_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mme batho ba welwa ke kgakgamalo fa ba bona tiragalo ya nonofo ya Modimo. E rile ba sa ntse ba bolela dilo tse di molemo tse o neng a di dira, Jesu a raya barutwa ba gagwe a re, ");
INSERT INTO tsn_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ntheetsang lo bo lo gakologelwe se ke se buang. Nna, Morwa Motho, ke tlaa okwa.” ");
INSERT INTO tsn_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mme barutwa ba gagwe ba ne ba sa itse gore o rayang, gonne megopolo ya bone e ne e kaneletswe, ba boifa go mmotsa. ");
INSERT INTO tsn_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mme jaanong ga tsoga kgang mo gare ga bone gore ke ofe wa bone yo o tlaa nnang mogolo mo Bogosingjo bo tlang! ");
INSERT INTO tsn_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mme Jesu a bo a setse a itsile megopolo ya bone, a baya ngwanyana fa go ene, ");
INSERT INTO tsn_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","mme a ba raya a re, “Le fa e le mang yo o tlhokomelang ngwananyana yo o tshwanang le yo, o tlhokomela nna! Mme le fa e le mang yo o ntlhokomelang o tlhokometse Modimo o o nthomileng. Tlhokomelo ya lona mo go ba bangwe ke sone selekanyo sa bogolo ba lona.” ");
INSERT INTO tsn_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Mme morutwa mongwe wa gagwe ebong Johane a tla kwa go ene a re, “Morena, re bone mongwe a dirisa leina la gago go kgoromeletsa mewa e e maswe kwa ntle. Mme ra mo itsa. Ka gonne e ne e se wa setlhopha sa rona!” ");
INSERT INTO tsn_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mme Jesu a re, “Ga lo a tshwanela go ka bo lo dirile jalo! Gonne mongwe le mongwe yo o seng kgatlhanong le lona ke wa lona.” ");
INSERT INTO tsn_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Mme ya re ka lobaka lwa gagwe lwa go boela kwa legodimong lo atamela, a tsamaya ka boiketlo go ya Jerusalema ka maikaelelo a a tlhomameng. ");
INSERT INTO tsn_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Mme ya re ka letsatsi lengwe a romela barongwa kwa pele go ya go ba baakanyetsa matlwana mo motseng wa Samaria. ");
INSERT INTO tsn_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mme batho ba motse oo ba ba koba ba gana go ba amogela ka gore ba ne ba fetela Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Mme e rile fa ba utlwa gore go diragetseng, Jakobe le Johane ba raya Jesu ba re, “Morena, a ke re laole molelo gore o fologe kwa legodimong o ba laile?” ");
INSERT INTO tsn_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mme Jesu a retologa a ba kgalemela, ");
INSERT INTO tsn_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","mme ba tsamaela kwa motseng o mongwe. ");
INSERT INTO tsn_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ya re ba ntse ba tsamaya mongwe a raya Jesu a re, “Nna ke tlaa go sala morago gongwe le gongwe kwa o yang teng.” ");
INSERT INTO tsn_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mme Jesu a mo fetola a re, “Gakologelwa gore ga ke na fa ke robalang teng, bophokoje ba na le mesima e ba nnang mo go yone, le dinonyane di na le dintlhaga, mme nna Morwa Motho ga ke na lelapa mo lefatsheng gotlhelele.” ");
INSERT INTO tsn_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Mme ya re ka nako e nngwe fa a laletsa monna mongwe go nna morutwa wa gagwe, monna a dumela, mme a batla go leta go fitlhela loso lwa ga rraagwe. ");
INSERT INTO tsn_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Hong Jesu a mo fetola a re, “Lesa ba ba senang botshelo jo bo sa khutleng ba dire dilo tse di ntseng jalo. Wena tiro ya gago ke go tla go rerela lefatshe lotlhe Bogosi jwa Modimo.” ");
INSERT INTO tsn_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yo mongwe a re, “Ee, Morena, ke tlaa tla, mme ntetla go ya go kopa tetlelelo mo go bagaetsho.” ");
INSERT INTO tsn_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mme Jesu a mo raya a re, “Le fa ele mang yo o iteseletsang go tsietsega mo tirong e ke e mo laetseng ga a a nonofela Bogosi jwa Modimo.” ");
INSERT INTO tsn_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Hong Morena a tlhopha barutwa ba le masome a supa mme a ba roma ka bobedi ka bobedi mo metseng le metsana e o neng a laotse go e etela. ");
INSERT INTO tsn_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Mme ditaelo tse a neng a di ba naya ke tse: “Rapelang Morena wa thobo gore a romele badiri ba bangwe go tla go lo thusa. ");
INSERT INTO tsn_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Tsamayang jaanong, mme lo gakologelwe gore ke lo roma jaaka dikonyana mo gare ga diphiri. ");
INSERT INTO tsn_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Lo se ka lwa tsaya madi, kgotsa kgetsana, kgotsa le fa e le dilwana tse dingwe le gone lo se ka lwa senya nako mo tseleng. ");
INSERT INTO tsn_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Mme e ne e re fa lo tsena mo lolwapeng, lo lo segofatsa. ");
INSERT INTO tsn_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Fa lo tshwanelwa ke tshegofatso, tshegofatso e tlaa nna mo go lone; fa e sa lo tshwanele; tshegofatso e tlaa boela mo go lona. ");
INSERT INTO tsn_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","“Mme e re fa lo tsena mo motseng, ");
INSERT INTO tsn_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","9","Fa lo amogelesega mo motseng lo se ka lwa tlhatlologanya malwapa, lo nne mo lefelong le le lengwe, lo o ja lo o nwa se lo tlaa bong lo se newa kwa ntle ga potso epe. Mme lo se ka lwa etsaetsega ka go amogelesega mo motseng, fa lo amogelesega mo motsing, lo latele ditaolo tse pedi tse: jang sengwe le sengwe se lo se fiwang. Fodisang balwetse; mme e re fa lo ba fodisa lo ba reyeng lo re ‘Bogosi jwa Modimo bo gaufi le lona thata gompieno.’ ");
INSERT INTO tsn_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Mme fa batho ba motse ba lo gana, tsamayang le mebila ya one lo re, ");
INSERT INTO tsn_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Re tlhotlhora lorole lwa motse wa lona mo dinaong tsa rona elekanamiso ya lona mo pontsheng. Lo se lebale gore lo ne lo le gaufi jang le Bogosi jwa Modimo!’ ");
INSERT INTO tsn_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Le Sodoma tota yo o bosula o tlaa nna botoka go na le motse oo ka letsatsi la katlholo. ");
INSERT INTO tsn_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","A bo go latlhega lona, metse ya Korasina le Bethesaida! Gonne fa dikgakgamatso tse ke di lo diretseng di ka bo di dirilwe mo metseng ya Ture le Sidona, batho ba yone ba ka bo ba sa bolo go sokologa bogologolo, ba apere letsela la kgetse ba bile ba latlhetse melora mo ditlhogong tsa bone go supa kutlobotlhoko ya dipelo tsa bone. ");
INSERT INTO tsn_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ee, Ture le Sidona ba tlaa reng kaga lona? A lo tlaa golelediwa kwa legodimong? Nnyaa, lo tlaa folosediwa kwa moleteng.” ");
INSERT INTO tsn_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mme lona batho ba Kaperenama, ke tla reng kaga lona? A lo tla galalediwa kwa legodimong? Nnyaa, lo tla folosediwa kwa moleteng. ");
INSERT INTO tsn_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mme a raya barutwa ba gagwe a re, “Ba ba lo amogelang ba amogela nna. Mme ba ba lo ganang ba gana nna. Le ba ba nkganang ba gana Modimo o o nthomileng.” ");
INSERT INTO tsn_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Mme e rile barutwa ba gagwe ba ba masome a supa ba boa, ba mmolelela ka boitumelo ba re, “Le mewa e e maswe tota e a re utlwa fa re dirisa leina la gago.” ");
INSERT INTO tsn_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mme Jesu a ba raya a re, “Ee, ke bone Satane a wa kwa legodimong jaaka logadima! ");
INSERT INTO tsn_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mme ke lo neetse taolo mo nonofong yotlhe ya Mmaba le go tsamaya mo gare ga dinoga le diphepheng le go di gataka. Mme ga go na sepe se se tlaa lo utlwisang botlhoko! ");
INSERT INTO tsn_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Le fa go ntse jalo, selo sa botlhokwa ga se go re mewa e e maswe e a lo utlwa, mme e bo e le gore maina a lona a kwadilwe jaaka baagedi ba legodimo.” ");
INSERT INTO tsn_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mme a tlala boitumelo jwa Mowa O O Boitshepo a re, “Ke a go baka, Rara Morena wa legodimo le lefatshe, ka go fitlhela ba ba nang le ditlhaloganyo le botlhale, dilo tse, mme wa di senolela ba ba ikanyegang jaaka bana. Ee, ke a leboga, gonne ke ka fa o batlileng ka teng. ");
INSERT INTO tsn_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ke moemedi wa ga Rre mo dilong tsotlhe; mme ga go ope tota yo o itseng Morwa fa e se Rara, le gone ga go ope yo o itseng Rara fa e se Morwa le ba Morwa o ba tlhophang go mo senola.” ");
INSERT INTO tsn_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mme Jesu a retologela kwa barutweng ba gagwe ba ba lesome le bobedi a ba sebetsa a re, “Lo lesego jang go bona dilo tse lo di boneng. ");
INSERT INTO tsn_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Baporofiti ba le bantsi le dikgosi tsa bogologolo ba ne ba eletsa malatsi ano, go bona le go utlwa se lo se boneng le se lo se utlwileng!” ");
INSERT INTO tsn_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ka letsatsi lengwe moitseanape wa melao ya ga Moshe a tla go leka tumelo ya ga Jesu ka go mmotsa potso e: “Moruti, motho o tshwanelwa ke go dira eng gore a nnele ruri mo legodimong?” ");
INSERT INTO tsn_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Mme Jesu a fetola a re, “Molao wa ga Moshe wa reng ka ga gone?” ");
INSERT INTO tsn_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mme moitseanape a fetola a re, wa re, “O tshwanetse go rata Morena Modimo wa gago ka pelo yotlhe ya gago, le ka mowa otlhe wa gago, le ka nonofo yotlhe ya gago, le ka mogopolo otlhe wa gago. Le gore o tshwanetse go rata mong ka wena fela jaaka o ithata.” ");
INSERT INTO tsn_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesu a mo raya a re, “Go siame, dira sone se mme o tlaa tshela!” ");
INSERT INTO tsn_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Monna a batla go siamisa (go tlhaela ga lorato lwa gagwe mo bathung bangwe) jalo a botsa a re, “Bangwe ka nna ba fe?” ");
INSERT INTO tsn_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesu a mo fetola ka setshwantsho: a re, “Mojuta mongwe o kile ya re a etile go tswa Jerusalema go ya Jeriko a tlhaselwa ke dinokwane. Tsa mo tseela diaparo le madi tsa ba tsa mo keteka mme tsa mo tlogela a namaletse foo. ");
INSERT INTO tsn_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ka tshoganetso Moperesiti wa Mojuta a feta ka tsela eo, mme ya re a mmona a mo feta fela. ");
INSERT INTO tsn_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Fela jalo le Molefi ya re a fitlha felong foo, mme a mmona a mo feta fela. ");
INSERT INTO tsn_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Mme ga tla Mosamaria yo o nyatsegileng, e rile a mmona, a tlhomoga pelo thata. ");
INSERT INTO tsn_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","A obama ka mangole fa go ene a tlotsa dintho tsa gagwe molemo a ba a di fapa. Mme a pega monna mo tonking a tsamaya fa thoko ga gagwe go fitlhelela ba tsena hoteleng, kwa o neng a mo oka bosigo jotlhe teng. ");
INSERT INTO tsn_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ka letsatsi le le latelang a naya motlhokomedi wa hotele dipula di le masome a mane a mo laela gore a tlhokomele monna yoo a mo raya a re, ‘Fa ditshenyegelo tsa gago di feta foo; ke tlaa go duela a a setseng fa ke boa.’ ");
INSERT INTO tsn_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Jaanong ke ofe mo go ba bararo ba yo wena o ka reng e ne e le mongwe ka yo o bolailweng ke dinokwane?” ");
INSERT INTO tsn_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Monna a fetola a re, “Ke yo o mo tlhomoge-tseng pelo.” Mme Jesu are, “Ee, jaanong tsamaya o dire fela jalo.” ");
INSERT INTO tsn_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ya re Jesu le barutwa ba gagwe ba tsweletse mo loetong lwa bone go ya Jerusalema ba tsena mo motsaneng mongwe kwa mosadi yo o neng a bidiwa Maratha o neng a ba amogela mo lwapeng lwa gagwe. ");
INSERT INTO tsn_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Monnawe Marea a nna fa fatshe, a reeditse Jesu fa a bua. ");
INSERT INTO tsn_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mme Morena a mo raya a re, Maratha, tsala ee rategang, o ngongorega thata mo dilong tse tsotlhe. ");
INSERT INTO tsn_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mme Maratha e ne e le motho yo o matlhagatlhaga, mme a bo a ngongorega fa a ntse a baakanya dijo. Hong a tla kwa go Jesu a re, “Morena, a ga o bone gore ga go a siama gore ke dire tiro yotlhe nnake ene a ntse fela fa fatshe. ");
INSERT INTO tsn_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Go na le selo se le sengwe fela se o tshwanetseng go amega mo go sone, Marea o se bone, mme ga nke ke se tsaya mo go ene!” ");
INSERT INTO tsn_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mme ya re ka nako nngwe fa Jesu a ile go rapela, mongwe wa barutwa ba gagwe a tla mo go ene fa a fetsa a re, “Morena re rute thapelo jaaka Johane a rutile barutwa ba gagwe.” ");
INSERT INTO tsn_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Mme e ke yone thapelo e a neng a e ba ruta: “Rara leina la gago le tlotlelwe boitshepo jwa lone; Romela Bogosi jwa gago ka pele. ");
INSERT INTO tsn_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Re fe dijo letsatsi le letsatsi. ");
INSERT INTO tsn_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mme o re itshwarele melato ya rona gonne re itshwaretse ba ba neng ba re leofetse. Mme o se re letle go raelesega.” ");
INSERT INTO tsn_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Hong ya re a ba ruta thata ka ga thapelo, a dirisa setshwantsho se a re: “A ke re o etetse tsala ya gago bosigogare o batla go adima dinkgwe di le tharo. Otlaa mo tlhaeletsa o re, ‘Tsala ya me e nketetse e e tswang kgakala mme ga ke na sepe se e ka se jang!’ ");
INSERT INTO tsn_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","O tlaa fetola a le ka fa ntlwaneng ya borobalo a re, ‘Tswee-tswee se ntsose. Ga ke ka ke ka go thusa ka nako e!’ ");
INSERT INTO tsn_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Mme ke tlaa go bolelela se, le fa a sa go direla jaaka tsala, fa o tswelela o kokota o tlaa tsoga a go neye sengwe le sengwe se o se batlang ka ntlha ya bobelotelele jwa gago. ");
INSERT INTO tsn_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Mme go ntse fela jalo mo thapelong, tswelelang lo lope lo tlaa newa, batlang lo tlaa bona, kokotang lo tlaa bulelwa. ");
INSERT INTO tsn_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mongwe le mongwe yo o kopang o tlaa amogela; botlhe ba ba batlang, ba a bona; mme go bulelwa mongwe le mongwe yo o kokotang. ");
INSERT INTO tsn_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Mme lona bo rra-bana, fa ngwana wa gago wa mosimane a go kopa senkgwe, a o ka mo naya lentswe? Fa a kopa tlhapi a o ka mo naya noga? ");
INSERT INTO tsn_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Fa a kopa lee, a o ka mo naya phepheng? Nnyaa! ");
INSERT INTO tsn_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","“Mme fa baleofi jaaka lona ba naya bana se ba se tlhokang, a ga lo lemoge gore Rraeno yo o kwa legodimong o tlaa dira mo go tona, a neela Mowa O O Boitshepo ba ba o kopang?” ");
INSERT INTO tsn_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ka nako nngwe, fa Jesu a kgoromeletsa ntle mowa o o maswe mo monneng yo o neng a le semumu, lentswe la gagwe la mmoela, a mumuloga. Mme bontsintsi jwa batho jwa itumela thata ba nna matlhagatlhaga, ");
INSERT INTO tsn_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","mme bangwe ba re, “Ga go hakgamatse fa a kgoromeletsa mewa e e maswe ntle. O tsaya nonofo ya gagwe mo go Satane, Kgosi ya mewa e e maswe!” ");
INSERT INTO tsn_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bangwe ba kopa gore a dire sesupo sengwe mo loaping go supa go ipitsa ga gagwe a re ke Mesia. ");
INSERT INTO tsn_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mme ka a ne a itsile dikakanyo tsa mongwe le mongwe wa bone a re, “Bogosi bongwe le bongwe jo bo itwantshang bo a senyega; le lolwapa lo lo tletseng kganetsanyo le ntwa lo ntse fela jalo. ");
INSERT INTO tsn_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Hong fa se lo se buang e le boammaaruri, gore Satane o a itwantsha ka go nnonotsha go kgoromeletsa mewa ya gagwe e e maswe ntle, bogosi jwa gagwe bo ka ema jang? ");
INSERT INTO tsn_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mme fa ke newa nonofo ke Satane, balatedi ba lona bone? Gonne ba kgoromeletsa mewa e e maswe ntle! A lo gopola gore mo go supa gore ba tsenywe ke Satane? Ba botseng fa e le gore lo bolelela ruri! ");
INSERT INTO tsn_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mme fa ke kgoromeletsa ntle mewa e e maswe ka ntlha ya nonofo e e tswang mo Modimong, go supa gore Bogosi jwa Modimo bo tsile. ");
INSERT INTO tsn_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Gonne fa Satane a le thata a bile a tshotse dibolao, a tlhokomela ntlo ya gagwe ya segosi, e bolokesegile. ");
INSERT INTO tsn_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Go fitlhelela mongwe yo o nonofileng a bile a tshotse dibolao tse di botoka a tla a mo fenya a bo a gapa dibolao tsa gagwe le dilwana tsa gagwe. ");
INSERT INTO tsn_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Mongwe le mongwe yo e seng wa me o kgatlhanong le nna; fa a sa nthuse, o a ntlhokofatsa. ");
INSERT INTO tsn_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“E ya re fa mowa o o maswe o dule mo mothong o ye kwa dikakeng o batla boikhutso; mme e re o sa bo bone o boele kwa go yo o neng o tswa mo go ene, ");
INSERT INTO tsn_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","mme o fitlhele lolwapa lwa one lwa gale lo feetswe lo le phepa. ");
INSERT INTO tsn_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Hong ‘o’ tsamaye, ‘o’ ye go tlisa mewa e mengwe e e maswe e le supa e e bosula go na le one, mme yotlhe e tsene mo mothung yoo. Hong motho wa mogolo a bife go gaisa jaaka a ne a ntse pele.” ");
INSERT INTO tsn_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mme ya re a ntse a bua mosadi mongwe mo bontsintsing jwa batho a mo tlhaeletsa a re, “A Modimo o segofatse mmago, le sebopelo se o duleng mo go sone, le mabele a o a amuleng.” ");
INSERT INTO tsn_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Hong a mo fetola a re, “E, mme bogolo go sego botlhe ba ba utlwang Lefoko la Modimo ba le dirisa.” ");
INSERT INTO tsn_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","30","Ya re bontsi jwa batho bo ntse bo ikgotlhaganyetsa mo go ene, a ba rerela thero e, a re: “Dipaka tseno ke tse di bosula, tsa batho ba ba bosula. Ba tswelela ka go kopa tiragalo e e sa tlwaelesegang mo loaping gore ke supe gore ke Mesia, mme kgakgamalo e ke tlaa ba e nayang fela ke ele ya ga Jona, yo dikai tsa gagwe di neng tsa supegetsa batho ba Ninefe gore o rometswe ke Modimo. Sekai sa me se se tshwanang le sone se tlaa supegetsa batho ba gore ke romilwe ke Modimo. ");
INSERT INTO tsn_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Mme ka Letsatsi la Katlholo Mohumagadi wa Sheba o tlaa tsoga mme a supe morafe o ka monwana, a o sekise gonne o tsamaile loeto lo lo leele go tla go reetsa botlhale jwa ga Solomone; mme fano go yo mogolo thata go gaisa Solomone mme o reediwa ke ba se kae fela. ");
INSERT INTO tsn_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Batho ba Ninefe le bone ba tlaa tsoga ba sekisa sechaba se, gonne ba sokologile ka lobaka lwa thero ya ga Jona, mme yo mogola go gaisa Jona o fano. Mme sechaba se ga se mo reetse. ");
INSERT INTO tsn_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ga go ope yo o tshubang lobone a tswe a lo fitlhe! eseng jalo, o lo baya mo setlhomong go bonesetsa botlhe ba ba tsenang mo tlung. ");
INSERT INTO tsn_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matlho a gago a bonesa bokafateng jwa gago. Leitlho le le nang le keletso e e bosula le fifatsa lesedi mme le go latlhela mo lefifing. ");
INSERT INTO tsn_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Jalo tlhokomela gore lesedi la gago le se ka la fifala. ");
INSERT INTO tsn_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Fa go tletse lesedi mo go wena, go se na dintlha dipe tsa lefifi, hong bontle jwa gago le jone bo tlaa phatsima jaaka ekete lesedi le go phatsimela ka marang a lone.” ");
INSERT INTO tsn_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","38","Ya re a ntse a bua, mongwe wa Bafarasai a mo kopa go ya go ja kwa lwapeng lwa gagwe. Mme ya re a goroga a nna fa fatshe a ja kwa ntle ga go dirisa mokgwa wa Sejuta wa go tlhapa diatla pele ga a ja. Mme mo ga gakgamatsa yo o neng a mo laleditse. ");
INSERT INTO tsn_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mme Jesu a mo raya a re, “Lona Bafarasai lo tlhatswa bokafa ntle, mme mo teng lo sa le leswe, go tletse bobelotshetlha le bosula! ");
INSERT INTO tsn_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Dieleele ke lona! A Modimo ga oa ka wa dira bokafateng le bokafantle? ");
INSERT INTO tsn_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Bophepa bo supa bopelontle. ");
INSERT INTO tsn_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Mme a bo go latlhega lona Bafarasai! Gonne le fa lo tlhokomela go ntsha di tsa bosome tsa mo go nnye mo lo go amogetseng, lo lebala gotlhelele kaga tshiamo le lorato lwa Modimo. Lo tshwanetse go kgetha, ee, lo tshwanetse go ntsha ditsa bosome, mme ga lo a tshwanela go tlogela tse dingwe tse di sa dirwa. ");
INSERT INTO tsn_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“A bo go latlhega lona Bafarasai! Gonne lo rata manno a tlotlego mo disenagogeng le go dumedisiwa ka maitseo ke mongwe le mongwe fa lo tsamaya mo marekelong! ");
INSERT INTO tsn_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ee, katlholo e e boitshegang e lo letile. Gonne lo tshwana le mabitla a a fitlhilweng mo nageng. Batho ba feta ka lona ba sena kitso ya gore lo batho ba ba kgopo jang.” ");
INSERT INTO tsn_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mme moitseanape wa tumelo yo o neng a eme foo a re, “Morena, o tlhapaditse le yone tiro ya me ka se o ntseng o se bua.” ");
INSERT INTO tsn_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Mme Jesu a re, “Ee, bogale jo bo ntseng jalo bolo emetse! Gonne lo gatelela batho mo ditaolong tsa tumelo tse di se ka keng tsa kgonega, tse le lona ka bo lona lo se ka keng lwa leka go di tshegetsa. ");
INSERT INTO tsn_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","A bo go latlhega lona! Gonne lo tshwana fela le bagolwane ba lona ba ba bolaileng baporofiti bogologolo. ");
INSERT INTO tsn_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Babolai ke lona! Lo dumalana le bo rraalona gore se ba neng ba se dira se ne se siame, lo ka bo lo dirile jalo le lona. ");
INSERT INTO tsn_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Mme se ke se Modimo o se buang kaga lona: ‘Ke tlaa romela baporofiti le baapostoloi kwa go lona, mme lo tlaa bolaya bangwe ba bone lo bo lo leleke ba bangwe’. ");
INSERT INTO tsn_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Mme lona ba dipaka tseno lo tlaa arabela polao ya batlhanka ba Modimo go tswa tshimologong ya lefatshe, ");
INSERT INTO tsn_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","go tswa polaong ya ga Abele go tsena ka ya ga Sakarea yo o swetseng fa gare ga aletara le felo fa go boitshepo. Ee, ruri e tlaa lopiwa mo go lona. ");
INSERT INTO tsn_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“A bo go latlhega lona baitseanape ba tuelo! Gonne lo fitlhela batho boammaaruri. Ga lo bo ikamogelele, mme lo kganela ba bangwe go nna le nako ya go bo dumela.” ");
INSERT INTO tsn_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Hong Bafarasai le baruti ba molao ba gakala; mme ya re go tswa foo ba mo gagautlha ka dipotso tse dintsi, ba leka go mo raela gore a bue sengwe se ba ka mo tshwarang ka sone. ");
INSERT INTO tsn_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mme ya re ka lobakanya na loo bontsintsi jwa batho jwa ntsifala go fitlhelela ba nna diketekete ba bo ba hereetsega ba gatakana. Mme Jesu a retologela kwa barutweng ba gagwe a ba tlhagisa a re, “Mo godimo ga dilo tsotlhe, lo itlhokomeleng mo Bafarasaing ba, le ka mokgwa o ba ipayang jaaka ba siame mme ba sa siama. Mme boitimokanyi jo bo kana ga bo ka ke jwa fitlhegela ruri. ");
INSERT INTO tsn_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bo tlaa nna sesupo jaaka sebediso mo boping jo bo dubilweng. ");
INSERT INTO tsn_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Sengwe le sengwe se ba se buetseng mo lefifing se tlaa utlwiwa mo pontsheng, le se lo se sebetseng mo matlung a a kwa teng se tlaa anamisiwa mo ditlhoeng tsa matlo gore botlhe ba utlwe! ");
INSERT INTO tsn_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ditsala tse di rategang, lo se ka lwa boifa ba, ba ba batlang go lo bolaya. Ka gore ba ka bolaya mmele fela mme ga ba na nonofo mo meweng ya lona. ");
INSERT INTO tsn_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mme ke lo bolelela yo lo tshwanetseng go mmoifa, boifang Modimo o o nang le nonofo ya go bolaya le go latlhela mo moleteng. ");
INSERT INTO tsn_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Tlhwatlhwa ya dithaga tse tlhano ke bokae? A ke dithebe di se kae e seng go feta moo? Le fa go ntse jalo Modimo ga o lebale le fa e le epe ya tsone. ");
INSERT INTO tsn_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ebile o itse palo ya meriri ya ditlhogo tsa lona! Se boifeng gonne lo botlhokwa thata mo go one go gaisa setlhopha sa dithaga. ");
INSERT INTO tsn_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Mme ke lo tlhomamisetsa se, ka re: Nna Morwa Motho ke tlaa lo tlotla mo pepeneneng fa pele ga baengele ba Modimo fa lo mpolela jaaka Tsala ya lona mono lefatsheng. ");
INSERT INTO tsn_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mme ba ba intatolang mo gare ga batho ke tlaa ba itatola fa pele ga baengele. ");
INSERT INTO tsn_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","(Le fa go ntse jalo ba ba buang ka ga me ba ka nna ba itshwarelwa, fa ba ba buang kgatlhanong le Mowa O O Boitshepo ba se kitla ba itshwarelwa). ");
INSERT INTO tsn_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Mme e re fa lo tlisiwa tshekong fa pele ga babusi ba ba Sejuta le ba ba nang le ditaolo mo matlung a thuto lo se tshwenyege ka se lo tlaa se buang go iphemela, ");
INSERT INTO tsn_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","gonne Mowa O O Boitshepo o tlaa lo naya mafoko a a tshwanetseng fa lo ntse lo le foo.” ");
INSERT INTO tsn_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Hong mongwe a mo tlhaeletsa mo bontsintsing jwa batho a re, “Morena, tswee-tswee raya mogolole a kgaogane boswa le nna.” ");
INSERT INTO tsn_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mme Jesu a mo fetola a re, “Rra, ke mang yo o ntirileng moatlhodi mo go lona go akanya dilo tse di ntseng jaaka tseo? ");
INSERT INTO tsn_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Itlhokomeleng lo se ka lwa aga lo eletsa dilo tse lo senang natso. Gonne botshelo jwa boammaaruri le go tshela ga boammaaruri ga go a ikaega ka dikhumo tsa rona.” ");
INSERT INTO tsn_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Mme a fa setshwantsho: a re, “Monna wa mohumi o ne a na le tshimo e e mmu o nonneng e e ntshang thobo e ntsi. ");
INSERT INTO tsn_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Le fa go ntse jalo difalana tsa gagwe di ne di tletse mo go penologang, o ne a sa kake a kgona go tsenya sengwe le sengwe mo teng. Mme a akanya mathata a gagwe, ");
INSERT INTO tsn_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ya re kwa bofelong a goa a re, ‘Ke a itse, ke tlaa rutla difalana tsa me ke aga tse di tona! Jaanong ke tlaa nna le polokelo e e lekaneng. ");
INSERT INTO tsn_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mme ke tlaa nna, ke ithaya ke re, “Tsala o na le dithoto tse dintsi tsa dingwaga tse di tlang. Thuba kobo segole! Itumedise botshelo jwa gago ka mofine le basadi o opelelwe.” ’ ");
INSERT INTO tsn_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Mme Modimo wa mo raya wa re, ‘Seeleele ke wena; bosigo jono o a swa mme dilo tse tsotlhe e tlaa nna tsa ga mang?’ ");
INSERT INTO tsn_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ee, mongwe le mongwe ke seeleele yo o amogelang dikhumo mo lefatsheng e seng kwa legodimong.” ");
INSERT INTO tsn_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Hong a retologela kwa barutweng ba gagwe a ba raya a re, “Se tshwenyegeng ka gore a lo na le dijo tse dintsi go ja kgotsa diaparo go apara. ");
INSERT INTO tsn_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Gonne botshelo bo gaisa dijo le diaparo. ");
INSERT INTO tsn_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Lebelelang magakabe, ga a leme, ga a robe, ga a na difalana go boloka dijo tsa one, mme le fa go ntse jalo a tshela sentle fela gonne Modimo o a a otla. Mme lo tlhwatlhwa kgolo mo go one go gaisa dinonyane! ");
INSERT INTO tsn_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Jaanong mo godimo ga mo, go thusang gore lo tshwenyege? Go lo thusa ka eng? A go ka lo okeletsa botshelo ka letsatsi le le lengwe fela? Nnyaa! ");
INSERT INTO tsn_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mme fa tlhobaelo e se ka ke ya dira selo se sennye jaaka seo, go thusang go tlhobaelela dilo tse di tona? ");
INSERT INTO tsn_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Lebelelang dithunya: Ga di dire ebile ga di otlhe tlhale mme le fa go ntse jalo Solomone mo kgalalelong yotlhe ya gagwe o ne a sa apare sentle jaaka tsone. ");
INSERT INTO tsn_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Mme fa Modimo o apesa dithunya tse di leng fano gompieno e re ka moso di bo di seyo, a ga lo gopole gore o tlaa lo apesa babelaedi ke lona! ");
INSERT INTO tsn_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Le gone lo se ka lwa tshwenyega ka ga dijo, se se jewang le se se nowang; se tshwenyegeng gotlhelele gonne Modimo o tlaa di lo naya. ");
INSERT INTO tsn_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","“Batho botlhe ba itapisa ka senkgwe sa letsatsi le letsatsi, mme Rraeno yo o kwa legodimong o itse go tlhoka ga lona. ");
INSERT INTO tsn_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","O tlaa aga a lo naya tsotlhe tse lo di tlhokang letsatsi le letsatsi fa lo tlhoafaletse Bogosi jwa Modimo. ");
INSERT INTO tsn_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Jalo se boifeng, lona motlhape o monnye gonne go naya Rraeno boitumelo jo bogolo go lo naya Bogosi. ");
INSERT INTO tsn_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Rekisang tse lo nang natso lo di neye ba ba tlhokang. Mo go tlaa oketsa dikhumo tsa lona kwa legodimong! Mme dikgwama tsa legodimo ga di gagoge e bile ga di na maroba. Dikhumo tsa lona ga di kitla di nyelela, ga go na magodu a a ka di utswang, ga go na motoutwana o o di senyang. ");
INSERT INTO tsn_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Gongwe le gongwe kwa khumo ya gago e leng teng, pelo ya gago le dikakanyo tsa gago di tlaa nna teng. ");
INSERT INTO tsn_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Nnang lo ipaakantse, lo apere lo iketleeleditse, ");
INSERT INTO tsn_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","go boa ga Morena wa lona kwa modirong wa lonyalo. Hong lo tlaa bo lo ipaakanyeditse go mmulela kgoro gore a tsene ka nako e o gorogang ka yone a kokota. ");
INSERT INTO tsn_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Go tlaa nna boitumelo jo bogolo mo go ba ba ipaakantseng ba bile ba letile go boa ga gagwe. Ene ka boene o tlaa ba amogela a ba naya bonno a ba a apara seaparo sa baabi ba dijo go ba heha. ");
INSERT INTO tsn_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","“O ka nna a tla ka nako ya boroba bongwe bosigo, kgotsa bosigo gare. Mme e tlaa re mogang a tlang, go tlaa nna boitumelo mo batlhankeng ba gagwe ba ba ipaakantseng! ");
INSERT INTO tsn_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Mongwe le mongwe o ne a tlaa mo ipaakanyetsa fa ba ne ba itsile nako tota ya go boa ga gagwe, fela jaaka ba ne ba ka ipaakanyetsa legodu fa ba itsile fa le tlaa tla. ");
INSERT INTO tsn_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jalo ipaakanyeng ka nako tsotlhe. Gonne Nna Morwa Motho, ke tlaa tla go sa solofela ope.” ");
INSERT INTO tsn_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petere a botsa a re, “Morena a o bua le rona fela kgotsa le mongwe le mongwe?” ");
INSERT INTO tsn_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","44","Mme Morena a fetola a re, “Ke bua le mongwe le mongwe yo o ikanyegang yo o nang le tlhaloganyo yo mong wa gagwe o mo nayang tiro ya go otla batlhanka ba gagwe. Mme fa mong wa gagwe a boa a fitlhela a dirile tiro e e siameng, go tlaa nna le tuelo, mong wa gagwe o tlaa mmaya motlhokomedi wa dilo tsa gagwe tsotlhe. ");
INSERT INTO tsn_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Mme fa motho a simolola go akanya gore, ‘Morena wa me ga a nke a tla o diegile,’ hong a simolole go itaya banna le basadi ba o tshwanetseng go ba sireletsa, le go senya nako ya gagwe mo medirong ya dino le botagwa, ");
INSERT INTO tsn_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mme mong wa gagwe o tlaa boa kwa ntle ga kitsiso epe mme a mo ntshe mo maemong a gagwe a go tshephega a mo neye bonno jwa ba ba sa ikanyegeng. ");
INSERT INTO tsn_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","O tlaa otlhaiwa mo go botlhoko, gonne le fa a ne a itse tiro ya gagwe o ganne go e dira. ");
INSERT INTO tsn_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","“Mme le fa e le mang yo o sa itseng gore o dira phoso o tlaa otlhaiwa fela go le gonnye. Mo go tona go batlwa mo go ba ba neilweng mo go tona, gonne boikarabelo jwa bone bo bo tona. ");
INSERT INTO tsn_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ke tsile go lere molelo mo lefatshing, mme ruri, ke eletsa jang gore ekete tiro ya me e ka bo e setse e fedile! ");
INSERT INTO tsn_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Go na le kolobetso e e maswe kwa pele ga me, mme ke pitlagane thata go tsamaya e diragala! ");
INSERT INTO tsn_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“A lo gopola gore ke tsile go lere kagiso mo lefatsheng? Nnyaa! Ke lerile ntwa le kgaogano fela. ");
INSERT INTO tsn_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Go tloga fano malwapa a tlaa kgaogana ka bogare, ba bararo ba eme le nna, ba babedi ba nne kgatlhanong le nna, kgotsa go nne ka mokgwa o sele. ");
INSERT INTO tsn_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","“Rrabana o tlaa ntsha maikutlo a sele ka ga me; morwawe le ene a ntshe a sele; mmangwana le morwadie ba tlaa tlhoka kutlwisisanyo, mogopolo wa matsalaa motho yo o tlotlegang o tlaa nyadiwa ke ngwetsi ya gagwe.” ");
INSERT INTO tsn_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Mme a retologela kwa bontsintsing jwa batho a re, “Fa lo bona maru a simolola go ipopa kwa bophirima, lwa re, ‘Pula e e tla’, mme lo bo lo bolelela ruri. ");
INSERT INTO tsn_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","“Fa phefo ya borwa e foka lo re, ‘Gompieno go tlaa nna mogote’. Mme ruri go nne jalo. ");
INSERT INTO tsn_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Baitimokanyi! lo lemoga loapi sentle thata, mme lo gana go lemoga ditlhagiso tse di lo dikaganyeditseng kaga dipaka tse di diphatsa tse di tlang. ");
INSERT INTO tsn_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ke eng fa lo gana go iponela se se siameng? ");
INSERT INTO tsn_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","“Fa o kopana le moganetsi wa gago mo tseleng a isa kgang ya lona kgotleng, leka go letlana nae pele ga kgang e tsena kwa moatlhoding, e se re gongwe a go isa kwa kgolegelong; ");
INSERT INTO tsn_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","gonne fa seo se diragala ga o kitla o gololesega gape go fitlhelela thebe ya bofelo e duelwa yotlhe”. ");
INSERT INTO tsn_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mme ya re ka lone lobaka lo a itsisiwe fa Pilatwe a bolaile Bajuta bangwe ba ba neng ba tswa kwa Galalea fa ba ntsha ditlhabelo kwa Tempeleng mo Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mme a ba botsa a re, “A lo akanya gore e ne e le baleofi ba bagolo go feta batho botlhe ba ba tswang Galalea? A ke gone ka fa ba sotlegileng ka gone? ");
INSERT INTO tsn_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ga go a nna jalo! A ga lo lemoge gore le lona lo tlaa nyelela fa lo sa tlogele ditsela tsa lona tse di bosula lwa sokologela mo Modimong? ");
INSERT INTO tsn_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Mme lwa reng kaga batho ba ba lesome le bofera-bobedi ba ba neng ba a swa fa kago e e godileng ya Siloama e ba wela. A e ne e le baleofi ba bagolo mo Jerusalema? ");
INSERT INTO tsn_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ga go a nna jalo! Mme le lona lo tlaa nyelela fa lo sa ikwatlhae.” ");
INSERT INTO tsn_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Hong a dirisa setshwantsho se: “Monna mongwe o kile a tlhoma setlhare sa mofeige mo tshimong mme a tla gangwe le gape go tlhola gore a ga a ka ke a bona loungo lope mo go sone, mme o ne a aga a sa fitlhele sepe. ");
INSERT INTO tsn_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mme ya re kwa bofelong a raya motlhokomedi wa tshimo ya gagwe a re a se reme. A mo raya a re, ‘Ke letile dingwaga di le tharo ga go ise nke go nne le fa e le feige e le nngwe! Ke eng fa o se ngongoregela? se tsere phatlha e re ka bong re e dirisetsa sengwe gape.’ ");
INSERT INTO tsn_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Mme motlhokomedi wa tshimo a araba a re, ‘Se neye lobaka lo longwe gape. Se lese ngwaga e le nngwe, ke tlaa se tlhokomela ka go se tshela monontshane. ");
INSERT INTO tsn_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Fa re ka bona difeige ngwaga e e tlang go siame, mme fa go sa nne jalo ke tlaa se rema.’ ” ");
INSERT INTO tsn_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mme ka Sabata mongwe ya re a ruta mo senagogeng, ");
INSERT INTO tsn_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ga bo go na le sekoa sa mosadi yo o neng a obegile selekanyo sa dingwaga di le lesome le boferabobedi mme a sa kgone go itlhamalatsa. ");
INSERT INTO tsn_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Mme Jesu a mmitsa a re, “Mosadi o fodisitswe mo bolwetseng jwa gago!” ");
INSERT INTO tsn_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","A mo ama mme a akofa a inamologa. Hong mosadi a leboga a ba a galaletsa Modimo! ");
INSERT INTO tsn_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mme motlhokomedi wa ntlo ya thuto ya Sejuta a gakala thata ka gonne Jesu o ne a fodisitse mosadi yoo ka letsatsi la Sabata. A goa a raya batho a re, “Go na le malatsi a le marataro mo bekeng a go dirwang ka one, ao ke one malatsi a go ka fodisiwang ka one eseng go le Sabata!” ");
INSERT INTO tsn_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mme Morena a mo fetola a re, “Moitimokanyi ke wena! O dira go le Sabata! A ga o ko o golola dikgomo tsa gago mo marakeng a tsone go le Sabata o di kgweeletsa kwa metsing. ");
INSERT INTO tsn_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Jaanong a go phoso mo go nna, fela ka ntlha ya gore e re ka letsatsi la Sabata ke golole mosadi yo wa Mojuta mo bokgobeng jwa ga Satane selekanyo sa dingwaga di le lesome le boferabobedi?” ");
INSERT INTO tsn_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mo ga tlhabisa baba ba gagwe ditlhong. Mme batho botlhe ba itumelela tiro e ntle e o e dirileng. ");
INSERT INTO tsn_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jaanong a simolola go ba ruta kaga Bogosi jwa Modimo; A ba botsa a re, “Bogosi jwa Modimo bo ka tshwantshiwa le eng? Ke ka bo tshwantsha le eng? ");
INSERT INTO tsn_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bo tshwana le peo e nnye ya mosetara e e jetsweng mo tshimong; ya akofa ya gola ya tswa setlhare, mme dinonyane tsa nna mo gare ga dikala tsa sone. ");
INSERT INTO tsn_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Bo tshwana le sebediso se se dubetsweng mo boupeng, se se dirang se sa bonwe go fitlhelela boupe bo gogomoga bo bo bo nna motlhofo.” ");
INSERT INTO tsn_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Hong a tsamaya metse le metsana, a ruta fa a ntse a tsamaela kwa Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mongwe a mmotsa a re, “A go tlaa bolokwa ba se kae fela?” Mme a mo fetola a re, ");
INSERT INTO tsn_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","25","“Kgoro e e yang legodimong e tshesane. Lekang thata go tsena mo go yone, gonne boammaaruri ke gore ba le bantsi ba tlaa leka go tsena mme fa mong wa ntlo a setse a tswetse kgoro, nako e tlaa bo e setse e fetile. Mme e tlaa re fa lo eme kwa ntle lo kokota lo re, ‘Morena re bulele,’ o tlaa fetola a re, ‘Ga ke lo itse’. Hong lo tlaa re, ");
INSERT INTO tsn_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Mme re jele le wena ebile o rutile mo mebileng ya rona.” ");
INSERT INTO tsn_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Mme o tlaa fetola a re, ‘Ke a lo bolelela, ga ke lo itse. Ga lo ka ke lwa tla fa lo le molato jaana. Tsamayang.’ ");
INSERT INTO tsn_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Mme go tlaa nna selelo le khuranyo ya meno fa lo eme kwa ntle lo bona Aberahame, Isake le Jakobe le baporofiti botlhe mo Bogosing jwa Modimo, ");
INSERT INTO tsn_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","gonne batho ba tlaa tswa ntlheng tsotlhe tsa lefatshe go tla go tsaya manno a bone. ");
INSERT INTO tsn_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mme tlhokomelang se: Ba ba nyatsegang gompieno ba tlaa tlotlwa thata, ba ba tseetsweng kwa godimo gompieno ba tlaa ngotlafadiwa.” ");
INSERT INTO tsn_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mme ya re morago ga metsotso e se kae Bafarasai bangwe ba mo raya ba re, “Tloga fano fa o batla go tshela, gonne Kgosi Herode o go tsomile!” ");
INSERT INTO tsn_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesu a ba fetola a re, “Tsamayang lo reye phokoje yoo lo re ke tlaa tswelela ke ntshetsa mewa e e maswe ntle, ke dira dikgakgamatso tsa phodiso gompieno le ka moso; mme ka letsatsi la boraro ke tlaa fitlha kwa ke yang teng. ");
INSERT INTO tsn_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ee, gompieno, ka moso le ka letsatsi le le latelang! Gonne ga go ka ke ga direga gore moporofiti wa Modimo a bolawe ka kwa ntle ga Jerusalema! ");
INSERT INTO tsn_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalema wee! Jerusalema! Motse o o bolayang baporofiti. Motse o o kgobotletsang ka maje ba ba rometsweng go o thusa. Ke ratile gantsi jang go phutha bana ba gago jaaka koko e e sireletsang dikokwana tsa yone ka fa diphukeng, mme ga o aka wa ntetla. ");
INSERT INTO tsn_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mme jaanong, ntlo ya gago e tlogetswe e le letlotla. Ga o kitla o mpona gape go fitlhelela o re, ‘A go bakwa yo o tlang mo leineng la Morena.’ ” ");
INSERT INTO tsn_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Mme ka Sabata nngwe ya re a le mo lwapeng lwa leloko lengwe la Lekgotla la Sejuta, Bafarasai ba bo ba mo lebeletse thata jaaka bophakalane go bona gore a o tlaa fodisa monna yo o neng a le foo a lwala go tlala metsi mo ditokololong. ");
INSERT INTO tsn_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Mme Jesu a raya Bafarasai le bomaitseanape ba ba neng ba le foo a re, “A go kafa molaong go fodisa motho ka letsatsi la Sabata, kgotsa nnyaa?” ");
INSERT INTO tsn_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mme ya re ba gana go mo araba, Jesu a tshwara monna yo o lwalang ka letsogo a mo fodisa a mo rebola go tsamaya. ");
INSERT INTO tsn_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Hong a retologela kwa go bone: A botsa a re, “Ke ofe wa lona yo o sa direng ka letsatsi la Sabata? Fa kgomo ya gago e wela mo sedibeng, a ga o ka ke wa tswelela pele go e ntsha ka bonako?” ");
INSERT INTO tsn_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Gape ba tlhoka karabo. ");
INSERT INTO tsn_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Mme erile fa a lemoga fa batho botlhe ba ba tsileng dijong ba leka go nna gaufi le lomati lwa bojelo, a ba gakolola a re: ");
INSERT INTO tsn_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Fa lo laleditswe modiro wa nyalo, lo se ka lwa aga lo lwela go nna kwa mannong a a botoka. Gonne fa mongwe yo o tlotlegang thata go lo gaisa a goroga, ");
INSERT INTO tsn_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ene yo o laleditseng o tlaa mo lere fa o ntseng gone mme a re, ‘A monna yoo a nne fa mo boemong jwa gago’. Mme wena, ka ditlhong o tlaa tshwanelwa ke go nna mo setilong se se setseng kwa morago ga lomati lwa bojelo! ");
INSERT INTO tsn_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Jaanong dira se mo boemong jwa seo, simolola kwa morago; mme fa yo o go laleditseng a go bona, o tlaa tla a go raya a re, ‘Tsala, re go bonetse bonno jo bo botoka go na le jo! Hong o tlaa tlotlega fa pele ga balalediwa ba bangwe botlhe! ");
INSERT INTO tsn_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Gonne mongwe le mongwe yo o lekang go itlotla o tlaa ngotlafadiwa; mme yo o ikokobetsang o tlaa tlotlwa.’ ” ");
INSERT INTO tsn_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Hong a retologela kwa go yo o mo laleditseng a re, “E re fa o dira dijo, o se ka wa laletsa ditsala, bomorwarrago, bagaeno, le bahumi! Gonne le bone ba tlaa go laletsa. ");
INSERT INTO tsn_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mme mo boemong jwa mo, o laletse bahumanegi, digole, batlhotsi le difofu. ");
INSERT INTO tsn_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Hong e tlaa re ka tsogo ya basiami, Modimo o tlaa go duelela go laletsa ba ba se ka keng ba go laletsa.” ");
INSERT INTO tsn_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Erile monna mongwe yo o neng a ntse fa lomating lwa bojelo le Jesu a utlwa dilo tse a goa a re, “Go tlaa nna boitumelo jo bo kae go tsena mo Bogosing jwa Modimo!” ");
INSERT INTO tsn_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mme Jesu a fetola ka setshwantsho se: “Monna mongwe o kile a baakanya modiro o mogolo mme a dira ditaletso tse dintsi. ");
INSERT INTO tsn_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Erile fa gotlhe go siame, a roma motlhanka wa gagwe go itsise balalediwa gore ke nako ya gore ba tle. ");
INSERT INTO tsn_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mme botlhe ba simolola go dira diipato. Mongwe a re, ke gone fela o neng a reka tshimo mme o batla go ya go e bona, mme a kopa go itshwarelwa. ");
INSERT INTO tsn_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yo mongwe a re ke gone fela a neng a reka sepane sa dipholo tse some mme o batla go di lekeletsa. ");
INSERT INTO tsn_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yo mongwe e ne e le gone fela a neng a nyala, ka lebaka leo ga aa ka a tla. ");
INSERT INTO tsn_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Motlhanka a boa a ya go bolelela mong wa gagwe se ba se buileng. Mong wa gagwe a gakatsega thata mme a mo raya a re, itlhaganelele mo mebileng le mo dikgorong tsa motse o laletse bakopi, digole, batlhotsi le difofu. ");
INSERT INTO tsn_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mme ga bo go santse go na le phatlha. ");
INSERT INTO tsn_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Mong wa gagwe a re, ‘Go siame, jaanong tswela mo diferwaneng tsa motse le mo morago ga dikgoro o kope mongwe le mongwe yo o mmonang go tla, gore ntlo e tle e tlale. ");
INSERT INTO tsn_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Gonne ga go ope mo go ba ke ba laleditseng pele yo o tlaa itatswang mo go se ke se ba baakanyeditseng.’ ” ");
INSERT INTO tsn_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mme batho ba bantsi ba ne ba mo setse morago. Hong a retologa a ba raya a re, ");
INSERT INTO tsn_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Fa mongwe a batla go nna molatedi wa me o tshwanetse go nthata bogolo go gaisa rraagwe, mmaagwe, mosadi wa gagwe, bana ba gagwe, bomonnawe kgotsa bokgaitsadie-ee, go gaisa le jone tota botshelo jwa gagwe, kwa ntle ga moo ga a ka ke a nna morutwa wa me. ");
INSERT INTO tsn_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ebile ga go na ope yo o ka nnang morutwa wa me fa a sa sikare mokgoro wa gagwe a ntshala morago. ");
INSERT INTO tsn_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Mme lo se ka lwa simolola go fitlhelela lo bala tlhwatlhwa. Gonne e mang yo o ka simololang kago, kwa ntle ga go bona pele tekanyo le go bona gore a o na le madi a a lekanyeng go duela melato. ");
INSERT INTO tsn_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","E seng jalo, o ka kgona go fetsa motheo pele ga a tlhaelelwa ke madi. Mme ka ntlha ya moo mongwe le mongwe o ka mo tshega jang! ");
INSERT INTO tsn_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Mme ba tlaa mo sotla ba re, ‘A lo bona motho yo o fa yole? O simolotse kago ele mme o tlhaeletswe ke madi pele ga a e fetsa!’ ");
INSERT INTO tsn_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Kgotsa ke efe kgosi e e ka lorang go ya ntweng pele ga e nna fa fatshe le bagakolodi ba yone ba buisanya gore a masole a selekanyo sa dikete tse di lesome a itekanetse go ka fenya a a dikete tse di masome a mabedi a a kgatlhanong nae? ");
INSERT INTO tsn_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mme fa mogopolo o sa kgonege, e re fa masole a mmaba a sa le kgakala, e rome batsereganyi go buisanya ka mafoko a kagiso. ");
INSERT INTO tsn_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jalo ga go na ope yo o ka nnang morutwa wa me fa a sa nna fa fatshe pele ga a bala masego a gagwe, mme a a latlhela otlhe mo go nna. ");
INSERT INTO tsn_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Tshiamo ya letswai ke eng fa le latlhegetswe ke molodi? ");
INSERT INTO tsn_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Letswai le le senang molodi ga le na tiro le fa e le go nna monontshane. Ga le na tiro mme le tshwanetse go latlhelwa kwa ntle. Reetsang sentle, fa lo batla go tlhaloganya phuthololo ya me.” ");
INSERT INTO tsn_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mme bakgethisi ba ba sa ikanyegeng le baleofi ba ne ba tla gantsi go reetsa dithero tsa ga Jesu, ");
INSERT INTO tsn_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","mme mo ga tsosa dingongorego mo baeteledingpele ba tumelo ya Sejuta le bomaitseanape ba melao ya Sejuta ka gore o na a tsalane le baleofi ba ba ntseng jalo, ebile aa ja le bone! ");
INSERT INTO tsn_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Hong Jesu a dirisa setshwantsho se: “Fa o na le dinku di le lekgolo mme nngwe ya tsone ya bo e ya le naga, e timela a ga o ka ke wa tlogela tse di masome a ferabongwe le metso e fera bongwe wa latela e e timetseng go fitlhelela o e bona? ");
INSERT INTO tsn_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mme o tlaa e baya mo magetleng o ya gae ka boitumelo. ");
INSERT INTO tsn_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ere fa o goroga o phuthe ditsala tsa gago le ba o agileng nabo go itumela le wena ka gore o bonye nku e e neng e timetse. ");
INSERT INTO tsn_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Go ntse fela jalo, legodimo le tlaa itumelela moleofi a le mongwe yo o sokologelang mo Modimong go na le ba ba masome a ferabongwe le metso e ferabongwe, ba ba neng ba sa timela! ");
INSERT INTO tsn_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Setshwantsho se sengwe ke se: Mosadi o na le diselefera di le lesome tsa madi mme a bo a latlhegelwa ke e le nngwe. A ga a ka ke a tshuba lobone go sekaseka mo dihukung tsa ntlo le go feela mo dikgokgotshwaneng le mo diphatlheng go fitlhelela a e bona. ");
INSERT INTO tsn_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","A mme ga a ka ke a bitsa ditsala tsa gagwe ba a agileng nabo go itumela nae? ");
INSERT INTO tsn_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Fela jalo go na le boitumelo fa pele ga baengele ba Modimo fa moleofi a le mongwe a sokologa.” Go tshwantsha ntlha e ka botlalo, a ba bolelela polelo e: ");
INSERT INTO tsn_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","“Monna o ne a na le bomorwawe ba le babedi. ");
INSERT INTO tsn_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ya re yo mmotlana a raya rraagwe a re, ‘Ke batla seabe sa boswa jwa gago gompieno, go na le go letela go fitlhelela o swa!’ Rraagwe a dumela go kgaoganyetsa bomorwawe ba babedi khumo ya gagwe. ");
INSERT INTO tsn_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“E rile morago ga malatsi a se kae morwawe yo mmotlana a phutha dilwana tsa gagwe a etela kwa lefatsheng le le kgakala, koo a feta a senya madi a gagwe mo medirong le mo boakeng. ");
INSERT INTO tsn_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Mme ya re mo lobakeng lo madi a gagwe a neng a fedile ka lone, leuba, le legolo la wela lefatshe, mme a simolola go bolawa ke tlala. ");
INSERT INTO tsn_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","A tshwenya morui mongwe wa lefatshe leo gore a mo hire go otla dikolobe tsa gagwe. ");
INSERT INTO tsn_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mosimane o ne a bolawa ke tlala mo a neng a bona le tsone dijo tsa dikolobe di mo siametse. Mme ga seka ga nna le ope yo o mo nayang sepe. ");
INSERT INTO tsn_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“E rile kwa morago a tlelwa ke tlhaloganyo, a ithaya a re, ‘Kana le bone tota banna ba ba hirilweng kwa gaetsho ba na le dijo tse di lekanyeng, di bo di sala, mme nna fano, ke bolawa ke tlala! ");
INSERT INTO tsn_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ke tlaa ya gae kwa go rre ke re, “Rra, ke leofetse legodimo le wena.” ");
INSERT INTO tsn_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mme ga ke tlhole ke tshwanetse go bidiwa morwao. Tswee-tswee mma ke nne modiredi wa gago.’ ");
INSERT INTO tsn_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Jalo a boela gae kwa go rraagwe. Mme e rile a sa le kgakala, rraagwe a mmona a tla, mme a mo tlhomogela pelo ka lorato a taboga a mo tlamparela a bo a mo atla. ");
INSERT INTO tsn_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Morwawe a mo raya a re, ‘Rra, ke leofetse legodimo le wena, mme ga ke na tshwanelo ya go bidiwa morwao—’ ");
INSERT INTO tsn_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mme rraagwe a raya batlhanka a re, ‘Itlhaganeleng! Tlisang seaparo se se ntle mo tlung lo mo apese. Le mhitshana wa botlhokwa go o rwala mo monwaneng wa gagwe le ditlhako. ");
INSERT INTO tsn_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mme lo bolaye kgongwana e e nonneng e re nang nayo mo sakeng. Re tshwanetse go dira mokete, ");
INSERT INTO tsn_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","gonne morwaake yo, o ne a sule mme o rudile. O ne a timetse mme o bonywe!’ Hong modiro wa simologa. ");
INSERT INTO tsn_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ka nako eo, morwawe yo mo tona o ne a dira mo tshimong, erile fa a boela gae a utlwa moopelo wa mmino o tswa mo tlung; ");
INSERT INTO tsn_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","mme a botsa mongwe wa batlhanka gore go diregang? ");
INSERT INTO tsn_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“A mo raya a re, ‘Monnao o buile mme rrago o bolaile kgongwana e e nonneng o baakantse modiro o mogolo wa go itumelela go boa ga gagwe a sa bolaisega gope’. ");
INSERT INTO tsn_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Mogolowe a shakgala thata a bo a se ka a tsena mo teng. Rraagwe a tswela kwa ntle a mo rapela, ");
INSERT INTO tsn_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","mme a fetola a re, ‘Mo dingwageng tse tsotlhe ke go diretse thata mme ga ke ise nke ke gane go dira sepe se o neng o re ke se dire; mme mo lobakeng loo lotlhe ga o ise o ke o nneye le fa e le potsane go dira modiro le ditsala tsa me. ");
INSERT INTO tsn_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Le fa go ntse jalo ngwana yo wa gago yo o boileng a sena go senya madi mo boakeng, o mo itumeletse ka go mo tlhabela kgongwana e e nonneng e re neng re na nayo mo sakeng’. ");
INSERT INTO tsn_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Mme rraagwe a mo raya a re, ‘Bona morwaaka yo o rategang, wena le nna re atamalane thata, sengwe le sengwe se ke nang naso ke sa gago. ");
INSERT INTO tsn_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mme go tshwanetse go dirwa modiro. Gonne ke monnao; yo o neng a sule mme o rudile, yo o neng a timetse mme o bonywe.’ ” ");
INSERT INTO tsn_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Mme Jesu a bolelela barutwa ba gagwe polelo e: “Monna wa mohumi o kile a hira molebeledi go tlhokomela dilo tsa gagwe mme ka bonako ga utlwala fa molebeledi a sa ikanyege. ");
INSERT INTO tsn_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mme mong wa gagwe a mmitsa a mo raya a re, Ke eng se ke se utlwang ka go nkutswela ga gago? Baakanya pego ya gago, gonne o tshwanetse go tlogela tiro. ");
INSERT INTO tsn_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Mme molebeledi a ithaya a re, ‘Ke tlaa dirang? Fano ke feditse mme ga ke na nonofo ya go tsamaya ke epa mesele, le gone go kopa go ntlhabisa ditlhong. ");
INSERT INTO tsn_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ke itse selo se fela! Gore ke tlaa nna le ditsala tse dintsi go ntlhokomela fa ke tswa mo tirong.’ ");
INSERT INTO tsn_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","6","“Mme a laletsa mongwe le mongwe yo o neng a kolota mong wa gagwe go tla go buisana nae. A botsa wa ntlha a re, ‘O mo kolota bokae?’ Monna a fetola a re, ‘Molato wa me ke selekanyo sa dinkgwana di le makgolo a ferabobedi le masome a matlhano a lookwane.’ Molebeledi a mo raya a re, ‘Ee, tumalano e o e kwadileng ke e: e senye o kwale e e leng bontlha bongwe jwa yone.’ ");
INSERT INTO tsn_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Mme a botsa monna yo mongwe a re, ‘Wena o mo kolota bokae?’ A fetola a re, ‘Sekete sa dikgetse tsa mabele. Mme molebeledi a re tsaya lokwalo lwa gago o kwale o re, di makgolo a ferabobedi.’ ");
INSERT INTO tsn_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Monna wa mohumi a tshwanelwa ke go baka molebeledi yo o bolotsana ka go dira botlhale jo bo kalo. Mme ke boammaaruri gore banni ba lefatshe le, ba tlhalefile thata mo go sa ikanyegeng! go gaisa batho ba Modimo. ");
INSERT INTO tsn_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Mme a ke tshwanetse go lo raya ke re lo dire jalo, go reka botsalano ka go tsietsa? A mo go tlaa lo tlhomamisetsa go tsena ga lona mo legaeng la bosakhutleng kwa legodimong? ");
INSERT INTO tsn_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nnyaa! Gonne fa lo sa ikanyege mo dilong tse di potlana, ga lo ka ke lwa ikanyega mo go tse di kgolo. Fa lo dira tsietso e potlana, ga lo ka ke lwa ikanyega mo dilong tse dikgolo. ");
INSERT INTO tsn_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mme fa lo sa ikanyege kaga mahumo a lefatshe, ke mang yo o tlaa lo ikanyang mo mahumong a boammaaruri a legodimo? ");
INSERT INTO tsn_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mme fa lo sa ikanyege ka madi a batho ba bangwe, lo ka ikanyega jang ka madi a e leng a lona. ");
INSERT INTO tsn_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Gonne le fa e le wena kgotsa mongwe fela ga go ope yo o ka direlang barena ba babedi. O tlaa ila yo mongwe mme o rate yo mongwe, kgotsa go nne ka mokgwa mongwe o sele. O tla nna mafolofolo ka yo mongwe mme o nyatse yo mongwe. Ga o ka ke wa direla Modimo le madi!” ");
INSERT INTO tsn_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mme Bafarasai, ba ba ratang madi thata, ba mo sotla ka ntlha ya mo gotlhe. ");
INSERT INTO tsn_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mme a ba raya a re, “Lo apara tshiamo ya lona mo pepeneneng, mme Modimo o itse bosula jwa dipelo tsa lona. Go ipaya ga lona jaaka ekete lo siame go lo tlisetsa tlotlo mo bathong, mme ke makgapha fa pele ga Modimo. ");
INSERT INTO tsn_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Go tla go fitlha mo motlheng o Johane wa Mokolobetsi o neng a simolola go rera ka one, melao ya ga Moshe le ya Baporofiti e ne e le yone e e lo kaelang. Mme Johane a lo itsise kaga: Mafoko a a Molemo gore bogosi jwa Modimo bo tlaa tla ka bonako. Mme bontsintsi jwa ba ba eletsang ba itshukunyetsa mo go jone. ");
INSERT INTO tsn_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mme moo ga go reye gore molao o senyegetswe ke thata le fa e le ka ntlhanyana epe. O nonofile ebile ga o na botshikhinngo fela jaaka legodimo le lefatshe. ");
INSERT INTO tsn_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Mme jalo fa mongwe a tlhala mosadi wa gagwe a nyala o sele o dira boaka, mme yo o nyalang mosadi yo o tlhadilweng le ene o dira boaka”. ");
INSERT INTO tsn_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Hong Jesu a re, “Gonne go ne go na le monna mongwe wa mohumi, yo o neng a apara sentle a nna mo letlepung mo monateng ka letsatsi le letsatsi. ");
INSERT INTO tsn_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Mme ya re ka letsatsi lengwe Lasaro, wa mokopi, yo o neng a le dintho, a lala fa kgorong ya gagwe. ");
INSERT INTO tsn_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","E ne e tle e re a rapame foo a laletse masalela a a wang mo lomating lwa bojelo jwa monna wa mohumi, dintsa di latswe dintho tsa gagwe. ");
INSERT INTO tsn_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mme ya re kwa bofelong mokopi a swa mme a tsewa ke baengele go ya go nna le Aberahame mo felong ga baswi ba ba siameng. Mme monna wa mohumi le ene a swa a fitlhwa, ");
INSERT INTO tsn_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","mme mowa wa gagwe wa ya moleting. E rile fa a le koo, mo tlhokofatsong a lebela Lasaro a le kgakala a na le Aberahame. ");
INSERT INTO tsn_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Mme a goa a re Rre Aberahame, Nkutlwela botlhoko! romela Lasaro kwano fela gore a ine ntlha ya monwana wa gagwe mo metsing go ntsidifatsa loleme, gonne ke mo tlhokofatsong e e maswe mo dikgabung tse. ");
INSERT INTO tsn_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Mme Aberahame a mo raya a re, ‘Morwaaka, gakologelwa gore erile mo botshelong jwa gago o ne o na le sengwe le sengwe se o se batlang, mme Lasaro o ne a sena sepe. Jaanong o fano o a gomodiwa mme wena o mo tlhokofatsong. ");
INSERT INTO tsn_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Gape kwa ntle ga moo, go na le phata e tona e e senang bolekeletso, e e re kgaoganyang, mme mongwe yo o batlang go tla kwa go wena a tswa fano o kganelwa ke losi lwa yone; le gone ga go ope yo o ka kgabaganyetsang ka kwano go rona’. ");
INSERT INTO tsn_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Mme monna wa mohumi a re, ‘Ao, Rre Aberahame, tswee-tswee mo romele kwa legaeng la ga rre, ");
INSERT INTO tsn_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","gonne go na le bana ba ga rre ba le batlhano ba basimane, go ba tlhagisa kaga felo fano ga tlhokofatso e e botlhoko gore ba se ka ba tla fano fa ba a swa.’ ");
INSERT INTO tsn_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Mme Aberahame a re, ‘Dikwalo di ba tlhagisitse gangwe le gape. Bomorwarrago ba ka di bala ka nako nngwe le nngwe e ba e ratang’. ");
INSERT INTO tsn_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Mme monna wa mohumi a fetola a re, ‘Nnyaa Rre Aberahame ga ba kitla ba itshwenya ka go di bala. Mme fa mongwe a rometswe kwa go bone a tswa mo baswing ke gone ba ka sokologang mo dibeng tsa bone.’ ");
INSERT INTO tsn_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Hong Aberahame a mo fetola a re, ‘Fa ba sa reetsa Moshe le baporofiti ga ba kitla ba reetsa le fa mongwe a ka tsoga mo baswing.’ ” ");
INSERT INTO tsn_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Mme ya re ka letsatsi lengwe Jesu raya barutwa ba gagwe a re, “Go tlaa aga go le dithaelo tsa go leofa, mme a bo go latlhega motho yo o raelang. ");
INSERT INTO tsn_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","3","Fa a ne a latlhetswe mo lewatleng ka lentswe le legolo le fapeletswe mo molaleng wa gagwe, o ne a ka bo a le botoka thata go na le go otlhaelwa go tlhokofatsa mewa ya ba bannye ba. Ke a lo tlhagisa! Kgalemela morwa-rrago fa a leofa mme o mo itshwarele fa a ipona molato. ");
INSERT INTO tsn_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Le fa a go leofela ga supa ka letsatsi mme nako nngwe le nngwe a boela go wena a kopa maitshwarelo, mo itshwarele.” ");
INSERT INTO tsn_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ka letsatsi lengwe Baaposetoloi ba raya Morena ba re, “Re tlhoka tumelo e kgolo; re ka e bona jang?” ");
INSERT INTO tsn_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesu a ba araba a re, “Fa tumelo ya lona e le selekanyo sa peo ya mosetara, e tlaa bo e le kgolo thata go kumula setlhare se se kwa sele sa mosikamine le go se tlhoma mo teng ga lewatle! Taolo ya lona e ne e ka diragala ka bofefo! ");
INSERT INTO tsn_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","9","Fa motlhanka a tswa go lema kgotsa a tswa go disa dinku, ga a nne fela fa fatshe a a ja, mme pele o baakanyetsa mong wa gagwe dijo tsa maitseboa pele ga a a ja tsa gagwe. Mme ga a lebogwe, gonne o dira se a tshwanetseng go se dira. ");
INSERT INTO tsn_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Fela jalo, fa lo nkutlwa, ga lo a tshwanela go galalediwa. Gonne lo dirile tiro ya lona!” ");
INSERT INTO tsn_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","E rile ba ntse ba tsweletse mo loetong lwa go ya Jerusalema, ba tsena fa molelwaneng o o fa gare ga Galalea le Samarea, ");
INSERT INTO tsn_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","mme ya re ba tsena mo motsaneng oo, baleperwa ba le some ba bo ba emetse kwa kgakajana, ");
INSERT INTO tsn_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ba goa ba re, “Jesu, Morena, re utlwele botlhoko!” ");
INSERT INTO tsn_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Mme a ba leba a re, “Tsamayang lo ye kwa moperesiting wa Sejuta lo mo supegetse gore lo fodisitswe!” Mme ya re ba tsamaya, boleperwa jwa bone jwa nyelela! ");
INSERT INTO tsn_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mme mongwe wa bone a boela kwa go Jesu a goa a re, “A go galalediwe Modimo, ke fodisitswe!” ");
INSERT INTO tsn_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","A wela fa fatshe fa pele ga dinao tsa ga Jesu, a lebile fa fatshe mo loroleng a lebogela se a se dirileng. Monna yo e ne e le Mosamarea yo o nyatsegileng. ");
INSERT INTO tsn_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Mme Jesu a botsa a re, “A ga ke a fodisa banna ba le lesome? Ba ba ferang bongwe ba kae? ");
INSERT INTO tsn_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","A ke Modichaba yo fela yo o boileng go tla go galaletsa Modimo?” ");
INSERT INTO tsn_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Mme Jesu a mo raya a re, “Ema o tsamaye tumelo ya gago e go fodisitse.” ");
INSERT INTO tsn_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mme ya re ka letsatsi lengwe Bafarasai ba botsa Jesu ba re, “Bogosi jwa Modimo bo tlaa simologa leng? Jesu a ba fetola a re, Bogosi jwa Modimo ga bo tle ka ditshupo tse di bonalang. ");
INSERT INTO tsn_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ga lo ka ke lwa kgona gore lo re, ‘Bo simologile fano mo lefelong le kgotsa kwa ntlheng ele ya lefatshe’. Gonne Bogosi jwa Modimo bo mo go lona.” ");
INSERT INTO tsn_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mme morago a bua gape kaga selo se le barutwa ba gagwe. A ba raya a re, “Lobaka lo e tla lo lo tlaa ntlhoafalelang ka lone go nna le lona le fa e le letsatsi le le lengwe fela mme ke tlaa bo ke seyo fa.” ");
INSERT INTO tsn_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","“Dipolelo di tlaa tla mo go lona tsa gore ke boile le gore ke mo lefelong le kgotsa le; mme lo se ka lwa di dumela kgotsa lwa ya go mpatla. ");
INSERT INTO tsn_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gonne e tlaa re fa ke boa, lo tlaa itse kwa ntle ga pelaelo epe. Ke tlaa bo ke tshwana le logadima lo lo phatsimang go kgabaganya loapi. ");
INSERT INTO tsn_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mme pele ke tshwanetse go sotlega thata le go ganwa ke sechaba se sotlhe. ");
INSERT INTO tsn_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“E tlaa re fa ke boa lefatshe le tlaa tlhokomologa dilo tsa Modimo jaaka batho ba lobaka lwa ga Noa. ");
INSERT INTO tsn_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ba ne ba a ja, ba a nwa, ba nyala, sengwe le sengwe se siame go fitlhelela letsatsi le Noa o neng a tsena mo tlung e e kokobalang ka lone mme morwalela wa tla wa senya botlhe. ");
INSERT INTO tsn_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Mme lefatshe le tlaa nna jaaka mo metlheng ya ga Lote: Batho ba ne ba dira ditiro tsa bone tsa letsatsi le letsatsi, ba a nwa ba a ja, ba reka ba rekisa, ba tlhoma ditlhare ba aga, ");
INSERT INTO tsn_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","go fitlhelela mo mosong o Lote o neng a tswa mo Sodoma. Hong molelo le sebabole tse di neng di tswa kwa legodimong tsa ba nyeletsa botlhe. ");
INSERT INTO tsn_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ee, go tlaa ‘bo go berekwa’ jaaka gale go fitlhelela lobaka lwa go boa ga me. ");
INSERT INTO tsn_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ba ba tlaa bong ba se mo lwapeng ka letsatsi leo ba seka ba ya go phutha; ba ba mo nageng ba se ka ba boela kwa motsing. ");
INSERT INTO tsn_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Gakologelwang se se neng sa diragalela mosadi wa ga Lote! ");
INSERT INTO tsn_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Le fa e le mang yo o ngaparetseng botshelo jwa gagwe bo tlaa mo latlhegela mme le fa e le mang yo o latlhegelwang ke botshelo jwa gagwe o tlaa bo boloka. ");
INSERT INTO tsn_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mo bosigong joo banna ba le babedi ba tlaa bo ba robetse mo tlung e le nngwe mme mongwe o tlaa tsewa yo mongwe a tlogelwe. ");
INSERT INTO tsn_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Basadi ba le babedi ba tlaa bo ba dira botlhe mo tlung; yo mongwe o tlaa tsewa, yo mongwe o tlaa tlogelwa; mme go tlaa nna fela jalo mo banneng ba ba dirang ba bapile mo tshimong.” ");
INSERT INTO tsn_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mme barutwa ba botsa ba re, “Morena, ba tlaa bo ba isiwa kae?” Jesu a fetola a re, “Kwa setoto se leng gone, manong a phuthegela gone!” ");
INSERT INTO tsn_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mme ya re ka letsatsi lengwe Jesu a bolelela barutwa ba gagwe polelo ya go ba supegetsa ka fa go tlhokegang ka teng gore ba rapele ka metlha yotlhe le go ba bontsha gore ba tshwanetse go tswelela ba rapela go fitlhelela ba bona karabo. ");
INSERT INTO tsn_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","A ba raya a re, “Go kile ga bo go na le moatlhodi mo motsing, monna yo o ne a sa boife Modimo a le lonyatso lo logolo mo go botlhe. ");
INSERT INTO tsn_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mme motlholagadi mongwe wa motse oo o ne a tla kwa go ene nako le nako go ikopela tsheko kgatlhanong le monna yo o neng a mo utlwisitse botlhoko. ");
INSERT INTO tsn_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","“Moatlhodi o ne a mo tlhokomologa ka lobakanyana mme ya re morago a mo lapisa. A ithaya a re, ‘Ga ke boife Modimo le fa e le motho, mme mosadi yo o a ntshwenya. Ke tlaa mo atlhola gonne o ntapisa ka go boaboa ga gagwe.’ ” ");
INSERT INTO tsn_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Hong Morena a ba raya a re, “Fa e le gore moatlhodi yo o bosula o ka dira jalo, ");
INSERT INTO tsn_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","a ga lo akanye gore Modimo o tlaa atlholela batho ba one ka tshiamo ba ba o lopang bosigo le motshegare? ");
INSERT INTO tsn_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ee! O tlaa ba araba ka bonako! Mme potso ke gore: Fa nna Morwa motho, ke boa, ke tlaa fitlhela ba le kae ba ba nang le tumelo ebile ba rapela?” ");
INSERT INTO tsn_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Hong a ba bolelela polelo ya bangwe ba ba kileng ba ikgantsha ka tshiamo ya bone ba nyatsa ba bangwe. ");
INSERT INTO tsn_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Banna ba babedi ba kile ba ya kwa Tempeleng go ya go rapela. Mongwe e ne e le moikgantshi wa Mofarasai, yo o iponang tshiamo yo mongwe e le mokgethisi wa motsietsi. ");
INSERT INTO tsn_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mme moikgantshi wa Mofarasai a ‘rapela’ thapelo e: ‘Ke a leboga Mo-dimo, ga ke moleofi jaaka ba bangwe, bogolo jang jaaka mokgethisi yole! Gonne ga ke tsietse, ga ke dire boaka, ");
INSERT INTO tsn_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ke itima dijo gabedi mo bekeng, mme ke naya Modimo di tsa bosome jwa dilo tsotlhe tse ke di bapalang.’ ");
INSERT INTO tsn_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Mme mokgethisi yo o bosula a emetse kwa kgakala a sa batle go lelala kwa legodimong fa a rapela, a ititaya sefuba ka kutlobotlhoko, a goa a re, ‘Modimo nkutlwela botlhoko nna moleofi!’ ");
INSERT INTO tsn_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ke a lo bolelela, moleofi yo, e seng Mofarasai, o ne a boela gae a itshwaretswe! Gonne baikgantshi ba tlaa ngotlafadiwa mme ba ba ingotlang ba tlaa godisiwa.” ");
INSERT INTO tsn_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ka letsatsi lengwe basadi bangwe ba tlisa masea a bone kwa go ene go ba ama le go ba segofatsa. Mme barutwa ba ba raya ba re ba tsamaya. ");
INSERT INTO tsn_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","17","Hong Jesu a ipiletsa bananyana mme a raya barutwa a re, “Lesang bananyana ba tle kwa go nna! Lo se ka lwa ba kganela! Gonne Bogosi jwa Modimo ke jwa batho ba dipelo tsa bone di nang le tumelo jaaka tsa bananyana. Mme le fa e le mang yo o senang tumelo e e tshwanang le ya bone, ga a kitla a tsena ka dikgoro tsa Bogosi!” ");
INSERT INTO tsn_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ka bofefo Moeteledipele wa tumelo ya Sejuta a mmotsa potso e: “Morena yo o molemo ke ka dira jang go tsena mo legodimong?” ");
INSERT INTO tsn_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Mme Jesu a mo raya a re, “A o lemoga se o se buang fa o mpitsa ‘molemo’? Ke Modimo fela ke one o molemo, e seng ope gape. ");
INSERT INTO tsn_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mme ka fa potsong ya gago, o itse gore melao e e lesome ya re, o seka wa dira boaka, o seka wa bolaya, o seka wa utswa, o se ka wa aka, tlotla batsadi ba gago, le e mengwe jalo.” ");
INSERT INTO tsn_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mme monna a fetola a re, “Ke tlhokometse mongwe le mongwe wa melao eo go tswa bonnyeng jwa me.” ");
INSERT INTO tsn_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Hong Jesu a mo raya a re, “Go santse go na le sengwe se o se tlhokang, rekisa tsotlhe tse o nang natso o abele bahumanegi madi, e tlaa nna yone khumo ya gago kwa legodimong, mme o tle, o ntshale morago.” ");
INSERT INTO tsn_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mme e rile fa monna a utlwa se, a tsamaya ka kutlo botlhoko, ka a ne a humile thata. ");
INSERT INTO tsn_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesu a mo lebelela a tsamaya mme a raya barutwa ba gagwe a re, “Go thata jang gore mohumi a tsene mo bogosing jwa Modimo! ");
INSERT INTO tsn_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Go bonolo mo kammeleng go tsena ka leroba la nnale bogolo go mohumi go tsena mo Bogosing jwa Modimo!” ");
INSERT INTO tsn_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mme ba ba mo utlwileng jaana ba gakgamala ba re, “Fa go le thata jalo, batho ba ka bolokesega jang?” ");
INSERT INTO tsn_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","A ba fetola a re, “Modimo o ka dira se batho ba se ka keng ba se dira!” ");
INSERT INTO tsn_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Mme Petere a re, “Re tlogetse malwapa a rona ra go sala morago.” ");
INSERT INTO tsn_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesu a fetola a re, “E, mme botlhe ba ba dirileng jaaka lona, ba tlogetse lolwapa, mosadi, bomorwarraagwe, batsadi kgotsa bana ka ntlha ya Bogosi jwa Modimo, ");
INSERT INTO tsn_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ba tlaa duelwa gantsintsi ka lobaka lo, le go amogela botshelo jo bo sa khutleng mo lefatsheng le le tlang.” ");
INSERT INTO tsn_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Hong a phutha ba ba Lesome le Bobedi a ba raya a re, “Jaaka lo itse, re ya Jerusalema. Mme fa re tsena koo dipolelelo-pelo tsa baporofiti ba bogologolo ka ga me di tlaa diragala. ");
INSERT INTO tsn_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ke tlaa neelwa Badichaba go sotlwa le go kgwelwa mathe le go gagautlhwa mo go tlhabisang ditlhong, ");
INSERT INTO tsn_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ke tlaa itewa ke bo ke bolawa. Mme ka letsatsi la boraro ke tlaa tsoga gape.” ");
INSERT INTO tsn_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mme ba seka ba tlhaloganya selo se o neng a se bua. O ne a bonala ekete o bua dinaane fela. ");
INSERT INTO tsn_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Mme ya re ba atamela Jeriko, ga bo go le monna mongwe wa sefofu a ntse fa thoko ga tsela, a kopa mo bafeting. ");
INSERT INTO tsn_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","E rile a utlwa modumo wa bontsintsi bo feta a botsa gore go diragalang? ");
INSERT INTO tsn_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","A bolelelwa gore Jesu wa Nasaretha o a feta. ");
INSERT INTO tsn_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Hong a simolola go goa a re, “Jesu, Morwa Dafide, nkutlwela botlhoko!” ");
INSERT INTO tsn_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mme bontsintsi jwa batho jo bo neng bo eteletse Jesu pele jwa leka go didimatsa monna yo, mme a goela kwa godimo a re, “Morwa Dafide nkutlwela botlhoko!” ");
INSERT INTO tsn_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","E rile Jesu a goroga fa lefelong leo a ema a re, “Lereng monna yoo wa sefofu kwano.” ");
INSERT INTO tsn_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Hong Jesu a botsa monna a re, “O batlang”? A kopa a re, “Morena ke batla go bona!” ");
INSERT INTO tsn_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesu a mo raya a re, “Go siame, bona! Tumelo ya gago e go fodisitse!” ");
INSERT INTO tsn_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mme ka bofefo monna a kgona go bona, a latela Jesu, a baka Modimo. Mme botlhe ba ba neng ba go bona go direga le bone ba baka Modimo. ");
INSERT INTO tsn_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Mme ya re a feta mo Jeriko, monna mongwe yo o neng a bidiwa Sakaio, yo e neng e le mongwe wa batlhotlheletsi ba Sejuta mo papading ya go phutha lekgetho la Seroma (ebile e le mohumi), ");
INSERT INTO tsn_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","a leka go bona Jesu mme a ba a le mokhutshwane thata go mmona mo bontsintsing jwa batho. ");
INSERT INTO tsn_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mme a sianela kwa pele a palama setlhare sa mosikamore fa thoko ga tsela, a lebelela a le koo. ");
INSERT INTO tsn_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","E rile Jesu a feta foo a lelala Sakaio mme a mmitsa ka leina a re, “Sakaio! Itlhaganele! Fo-loga! Gonne ke ya go nna moeng mo lwapeng lwa gago gompieno!” ");
INSERT INTO tsn_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakaio a itlhaganela a fologa a tseela Jesu kwa tlung ya gagwe ka boitumelo jo bogolo. ");
INSERT INTO tsn_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mme bontsintsi jwa batho ba se ka ba itumela. Ba ngongorega ba re, “O ile go nna moeng wa moleofi yo o itsegeng ka mokgwa o o maswe”. ");
INSERT INTO tsn_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mme ya re ka lobaka loo, Sakaio a ema fa pele ga Morena a re, “Morena, go tloga fano ke tlaa abela bahumanegi bontlha bongwe jwa dikhumo tsa me, mme fa ke bona ke patikile mongwe mo makgethong a gagwe ke tlaa ipona molato ka go mmusetsa di tsa gagwe go menagane gane!” ");
INSERT INTO tsn_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Mme Jesu a mo raya a re, “Se se supa gore poloko e tsile mo lwapeng lo gompieno. Monna yo e ne e le mongwe wa bana ba ga Aberahame yo o neng a timetse, mme nna Morwa Motho, ke tsile go batla ke bo ke boloka mewa e e ntseng jaaka wa gagwe.” ");
INSERT INTO tsn_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mme ka gonne Jesu o ne a atamela Jerusalema, a bolela polelo go baakanya mogopolo o o reng Bogosi jwa Modimo bo tlaa simologa gone jaana. ");
INSERT INTO tsn_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","A re, “Mogolwane mongwe yo o neng a nna mo lefatsheng lengwe kwa motseng mogolo o o kgakala wa bogosi, o ne a bilediwa go ya go tlhongwa kgosi ya lefatshe la gagwe. ");
INSERT INTO tsn_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pele ga a tsamaya o ne a phutha bathusi ba le some a naya mongwe le mongwe wa bone dikete tse pedi tsa dipula, go sala ba di atisa fa a setse a tsamaile. ");
INSERT INTO tsn_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mme bangwe ba batho ba gagwe ba ne ba mo ila ba bo ba mo romelela polelo ya gore ba batla boipuso, ba bolela gore ba mo tsogologetse ga ba kitla ba mo amogela go nna kgosi ya bone. ");
INSERT INTO tsn_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ya re fa a boa a bitsa batho ba o neng a ba neetse madi, go bona gore ba dirileng ka one, le gore ba boetswe ke bokae. ");
INSERT INTO tsn_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Monna wa ntlha a bega papadi e kgolo, e menaganye ga some go feta tlhwatlhwa e o neng a e neetswe. ");
INSERT INTO tsn_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Mme kgosi ya goa ya re, ‘O dirile sentle! O monna yo o siameng o ikanyegile mo bonnyennyaneng jo ke go bo neileng. Mme tuelo ya gago ke gore, o tlaa nna molaodi wa metse e le some!’ ");
INSERT INTO tsn_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Monna wa bobedi le ene a bega papadi e e itumedisang, e menaganye ga tlhano go feta tlhatlhwa e o neng a e neetswe. ");
INSERT INTO tsn_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Mong wa gagwe a mo raya a re, ‘Go siame! o ka nna molaodi mo metseng e metlhano.’ ");
INSERT INTO tsn_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Mme monna wa boraro a bega fela madi a o neng a simolotse ka one, a re, ‘Ke a bolokile, ");
INSERT INTO tsn_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ka gore ke ne ke tshaba gore o tlaa batla papadi ya me gonne o monna yo o thata go dirisanya nao o tsaya se e seng sa gago e bile o gapa jalo tse di lemilweng ke ba bangwe.’ ");
INSERT INTO tsn_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mme Kgosi ya goa ya re, ‘Selo ke wena sa motlhanka yo o bosula. A ke pelo e thata? Ke tlaa nna fela jalo mo go wena! Fa o itsile bopelo-e-thata jwa me le ka fa ke leng logwadi ka gone, ");
INSERT INTO tsn_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ke eng fa o ne o sa boloke madi a me mo polokelong gore ke tle ke bone morokotso mo go one.’ ");
INSERT INTO tsn_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Mme a retologela kwa go ba ba emeng fa go ene a ba raya a re, ‘Tsayang madi mo go ene lo a neele monna yo o dirileng a mantsi.’ ");
INSERT INTO tsn_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Mme ba re ‘Morena, o setse a na le a mantsi!’ ");
INSERT INTO tsn_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kgosi ya fetola ya re, ‘Ee, ke boammaaruri gore ba ba nang le go le gontsi ba newa go le gontsi, mme ba ba nang le go le gonnye ba latlhegelwa le ke gone mo ba nang nago. ");
INSERT INTO tsn_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mme jaanong kaga baba ba, ba me ba ba rukutlhileng, ba tliseng kwano lo ba bolaye fa pele ga me!’ ” ");
INSERT INTO tsn_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Mme ya re Jesu a sena go bolela polelo e, a ya Jerusalema le barutwa ba gagwe (a ba eteletse pele). ");
INSERT INTO tsn_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ya re ba tsena mo motsing wa Bethefeige le Bethania, mo Thoteng ya Lotlhware, a romela barutwa ba gagwe ba le babedi kwa pele, ");
INSERT INTO tsn_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","a ba laela go ya kwa motseng o o fa pele le gore e re ba tsena ba senke tonki e e golegilweng fa thoko ga tsela. E tlaa bo e le tonkana, e e iseng e ke e palangwe. “E gololeng, mme lo e lere kwano. ");
INSERT INTO tsn_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mme e re fa mongwe a lo botsa gore lo dira eng, lo re, ‘Morena o a e batla!’ ” ");
INSERT INTO tsn_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Mme ba bona tonkana jaaka Jesu a boletse, ");
INSERT INTO tsn_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","mme ka boammaaruri ya re ba e golola, beng ba yone ba batla tlhaloso. Ba botsa ba re, “Lo dira eng? Lo gololelang tonkana ya rona?” ");
INSERT INTO tsn_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Mme barutwa ba fetola ba re, “Morena o a e batla!” ");
INSERT INTO tsn_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mme ba lere tonkana kwa go Jesu ba pega dingwe tsa diaparo tsa bone mo go yone gore a e palame. ");
INSERT INTO tsn_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","37","Mme bontsi jwa batho jwa ala diaparo tsa bone mo tseleng kwa pele ga gagwe, mme ya re ba fitlha fa tsela e fologelang gone go tswa kwa Thoteng ya Lotlhware, batho ba simolola go goa ba opela fa ba ntse ba tsamaya ba baka Modimo kaga dikgakgamatso tse Jesu o di dirileng. ");
INSERT INTO tsn_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ba ipela ba re, “Modimo o re neile Kgosi, e tshele ka boleele! A legodimo lotlhe le itumele! Kgalalelo go Modimo kwa magodimong!” ");
INSERT INTO tsn_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mme bangwe ba Bafarasai mo gare ga batho ba re, “Morena, kgalemela balatedi ba gago go bua dilo tse di ntseng jalo!” ");
INSERT INTO tsn_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mme a fetola a re, “Fa ba ka didimala, maje a a fa thoko ga tsela a, a tlaa thubega ka tuduetso!” ");
INSERT INTO tsn_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mme ya re ba atamela Jerusalema a lebela motse kwa pele, a simolola go lela. ");
INSERT INTO tsn_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","A lela a re, “Kagiso e e sa khutleng e ne e le gautshwane le wena mme wa e gana, mme jaanong lobaka lo setse lo fetile. ");
INSERT INTO tsn_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Baba ba gago ba tlaa go agelela ka lobota lwa mmu, ba go dika, ba go kganelela ka ntlha tsotlhe, ");
INSERT INTO tsn_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ba bo ba go ripitlela fa fatshe le bana ba gago ba o nang nabo; ga ba kitla ba tlogela leje le tlhatlaganye le le lengwe, gonne o ganne sebaka se Modimo o se go neileng.” ");
INSERT INTO tsn_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Hong a tsena mo Tempeleng a simolola go lelekela ntle barekisi mo marekisetsong a bone, ");
INSERT INTO tsn_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","a ba raya a re, “Dikwalo di bolela gore ‘Tempele ya me ke lefelo la thapelo; mme lo e fetotse mongobo wa magodu.’ ” ");
INSERT INTO tsn_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Morago ga moo a ba ruta malatsi otlhe mo Tempeleng, mme baperesiti ba bagolo le baruti bangwe ba molao le bagwebi ba ne ba leka tsela e ba ka mmolayang ka yone. ");
INSERT INTO tsn_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mme ba se ka ba akanya sepe, gonne o ne a tumile thata mo bathong, ebile ba utlwa lefoko lengwe le lengwe le o neng a le bua. ");
INSERT INTO tsn_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mme ya re ka letsatsi lengwe la malatsi ao fa a ntse a ruta a bile a rera Mafoko a a Molemo mo Tempeleng, a engwa pele ke baperesiti ba bagolo le baeteledipele ba tumelo le bagolwane ba motse. ");
INSERT INTO tsn_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ba batla go itse gore o neilwe e mang nonofo ya go lelekela barekisi kwa ntle ga Tempele. ");
INSERT INTO tsn_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","A ba fetola a re, “Ke tlaa lo botsa potso pele ga ke lo araba. ");
INSERT INTO tsn_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","A Johane o ne a rometswe ke Modimo kgotsa o ne a itirela fela ka fa nonofong ya gagwe?” ");
INSERT INTO tsn_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ba buisanya ka ga gone bare, “Fa re re molaetsa wa gagwe o ne o tswa legodimong, hong re tlaa bo re itshwarisa ka gore o tla re botsa gore, ‘Ke eng falo sa dumela?’ ");
INSERT INTO tsn_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mme fa re re Johane o ne a sa rongwa ke Modimo batho ba tlaa re kgobotletsa ka maje, gonne ba dumela thata gore ene ele moporo-fiti.” ");
INSERT INTO tsn_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mme ya re kwa morago ba fetola ba re, “Ga re itse!” ");
INSERT INTO tsn_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mme Jesu a ba araba a re, “Ga nkitla ke araba potso ya lona ka gope.” ");
INSERT INTO tsn_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Mme a retologela kwa bathong gape a ba bolelela polelo e: “Monna o kile a lema tshimo ya mofine mme a e hirisetsa balemi bangwe, mme a tsamaela kwa lefatsheng le le kgakala go ya go nna gone dingwaga di se kae. ");
INSERT INTO tsn_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mme e rile fa nako ya thobo e fitlha, a romela mongwe wa batho ba gagwe go ya go phutha seabe sa gagwe sa thobo. Mme balemi ba mo itaya ba mmusetsa morago a iphotlhere fela. ");
INSERT INTO tsn_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mme a romela yo mongwe, mme ga diragala gape jalo le ene a itewa a tlhapadiwa a bo a busediwa morago a sa tsaya sepe. ");
INSERT INTO tsn_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","“Motho wa boraro le ene a rongwa mme ga diragala fela jalo le ene a ntshiwa dintho a ba a lelekwa. ");
INSERT INTO tsn_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Hong mong wa tshimo a ipotsa a re, ‘Ke tlaa dira eng? Ke tlaa roma morwaake yo ke mo ratang thata. Ammaaruri ene ba tlaa mo tlotla.’ ");
INSERT INTO tsn_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Mme e rile balemi ba bona morwawe, ba re, ‘E ke yone fela nako ya rona! Motho yo o tlaa ja boswa jwa lefatshe lotlhe fa rraagwe a sena goswa. Tlang, a re mmolayeng, ke gone e tlaa nnang jwa rona.’ ");
INSERT INTO tsn_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Hong ba mo gogela kwa ntle ga tshimo ya mofine ba mmolaya. Jaanong lo akanya gore mong wa tshimo o tlaa dira eng? ");
INSERT INTO tsn_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ke a lo bolelela, o tlaa tla go ba bolaya a bo a hirisetsa ba sele tshimo ya mofine.” Mme bareetsi ba ganela ba re, “Ga ba ke ba dira selo se se ntseng jalo.” ");
INSERT INTO tsn_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mme Jesu a ba leba a re, “Jaanong dikwalo di raya eng fa di re, ‘Lentswe le le gannweng ke baagi ke lone le le dirilweng lentswe la kgokgotshwana.’ ” ");
INSERT INTO tsn_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mme a tlatsa a re, “Le fa e le mang yo o kgotswang mo lentsweng leo o tlaa robega; mme ba le ba welang le tlaa ba sugakanya go fitlhelela ba nna lorole.” ");
INSERT INTO tsn_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","E rile baperesiti ba bagolo le baeteledipele ba molao ba utlwa kaga polelo e o e boletseng, ba batla gore a tshwarwe ka bonako, gonne ba ne ba lemoga gore o bua kaga bone. E ne e le bahiri ba ba bosula mo polelong ya gagwe. Mme ba ne ba boifa gore fa bone ka sebele ba ka mo tshwara go tlaa nna le pheretlhego. Hong ba leka go mo tshwara ka go bua sengwe se se ka bolelelwang molaodi wa Seroma e le lebaka le le ka mo tshwarang. ");
INSERT INTO tsn_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ya re ba ntse ba lebeletse lebaka le la bone, ba romela ditlhola di ipeile jaaka ekete ke basiami. ");
INSERT INTO tsn_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ba raya Jesu ba re, “Morena re a itse fa o le moruti yo o ikanyegang. O aga o bolela boammaaruri o sa fapoge ka gope se bangwe ba se akanyang, ebile o ruta ditsela tsa Modimo. ");
INSERT INTO tsn_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Jaanong a o ko o re bolelele, a go siame go duela makgetho a mmuso wa Seroma kgotsa nnyaa?” ");
INSERT INTO tsn_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mme ya re ka go lemoga boferefere jwa bone a re, ");
INSERT INTO tsn_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ntshupegetsang ledi. Ke setshwantsho sa ga mang se se mo go lone? Ke leina la ga mang?” Mme ba fetola ba re, “Kaesara, molaodi yo mogolo wa Roma.” ");
INSERT INTO tsn_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mme a ba raya a re, “Hong nayang molaodi tsotlhe tse e leng tsa gagwe mme lo neye Modimo tse e leng tsa one.” ");
INSERT INTO tsn_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mme maiteko a bone a go leka go mo tshwara ka mafoko mo pele ga batho a pala; ba hakgamalela karabo ya gagwe mme ba didimala. ");
INSERT INTO tsn_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mme Basadukai bangwe, batho ba ba dumelang gore loso ke bokhutlo jwa botshelo, ba re ga go na tsogo ya baswi, ");
INSERT INTO tsn_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ba tla kwa go Jesu ba re, “Melao ya ga Moshe ya re fa monna a a swa a sena bana, morwa-rraagwe o ka nyala motlholagadi wa gagwe mme bana ba bone e bo e le ba monna yo o suleng, go tsweledisa leina la gagwe. ");
INSERT INTO tsn_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Re itse kaga bo morwa motho ba basimane ba supa. Yo mogolo mo go bone a nyala mme a swa a sena bana. ");
INSERT INTO tsn_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Monnawe a nyala motlholagadi yoo mme le ene, a swa a sena bana. ");
INSERT INTO tsn_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Mme ga tswelela fela jalo, go fitlhelela wa bosupa a mo nyala a bo a swa, a sena bana. ");
INSERT INTO tsn_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mme ya re kwa morago mosadi le ene a swa. ");
INSERT INTO tsn_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Jaanong potso ya rona fano ke gore: E tlaa nna mosadi wa ga mang mo tsogong ya baswi! Gonne ba ne ba mo nyetse botlhe?” ");
INSERT INTO tsn_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","35","Jesu a ba fetola a re, “Nyalo ke selo sa batho mono lefatsheng, mme e tlaa re ka letsatsi leo, batho ba ba bonwang ba tshwanetswe ke go tsosiwa mo baswing ba tsena kwa legodimong ga ba kitla ba nyala. ");
INSERT INTO tsn_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Le gone ga ba kitla ba tlhola ba a swa ka gope, ka tsela e, ba tshwana le baengele, ke bana ba Modimo gonne ba tsoseditswe botshelong jo bosha go tswa mo baswing. ");
INSERT INTO tsn_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","38","“Mme ka fa potsong ya lona, e, le go ka ne go na le tsogo ya baswi kgotsa nnyaa, ke eng, fa le dikwalo tsa ga Moshe di supa selo se. Gonne fa a tlhalosa ka fa Modimo o iponaditseng ka gone mo go ene mo setlhareng se se tukang, o bua kaga Modimo e le, ‘Modimo wa ga Aberahame, Isake le Jakobe.’ Gore Morena ke Modimo wa motho, mongwe, go raya gore motho yoo o a tshela, ga aa swa. Jalo ka fa Modimong batho botlhe ba a tshela.” ");
INSERT INTO tsn_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Bangwe ba baruti ba molao ba Sejuta ba ba neng ba eme foo ba re, “O buile sentle Morena!” ");
INSERT INTO tsn_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mme seo sa khutlisa dipotso tsa bone, gonne ba ne ba tshaba go botsa go feta foo. ");
INSERT INTO tsn_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mme a ba botsa potso e: “Ke eng fa Keresete, Mesia, gotwe ke wa lotso lwa ga Kgosi Dafide? ");
INSERT INTO tsn_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Gonne Dafide ka boene o kwadile mo bukeng ya Dipesalema a re, ‘Modimo o reile Morena wa me, Mesia, wa re, “Nna ka fa seatleng sa me se segolo go fitlhelela ke baya baba ba gago ka fa tlase ga dinao tsa gago.” ’ ");
INSERT INTO tsn_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Mesia o ka nna jang Morwa Dafide le Modimo wa ga Dafide ka nako e le nngwe.” ");
INSERT INTO tsn_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mme ya re batho ba reeditse, a retologela kwa barutweng ba gagwe a re, ");
INSERT INTO tsn_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Itiseng mo bomaitseanapeng ba, ba tumelo, gonne ba rata go apara diaparo tse di kgokgothang le go dumedisiwa ka tlotlo fa ba tsamaya mo mebileng. Mme ba rata jang ditulo tsa tlotlego mo disenagogeng le manno a tlotlomalo mo medirong! ");
INSERT INTO tsn_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mme le fa ba rapela ba rapela dithapelo tse di telele ka bobelonomi jo bogolo jo bo bonalang ka kwa ntle, ba loga maano a go gapela basadi ba batlholagadi dilo tsa bone ka tsietso. Mme katlholo e e boitshegang ya Modimo e letetse batho ba.” ");
INSERT INTO tsn_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Mme ya re a ema mo Tempeleng a bo a lebeletse bahumi thata fa ba tsenya dineo tsa bone mo letloleng. ");
INSERT INTO tsn_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Mme mohumanegi wa motlholagadi a tla a latlhela dithebe di le pedi. ");
INSERT INTO tsn_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Mme Jesu a re, “Ammaaruri motlholagadi yo wa mohumanegi o ntshitse mo go tona go gaisa ga ba ba ntshitseng gotlhe go kopantswe. ");
INSERT INTO tsn_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Gonne ba ntshitse bonnye jwa se ba sa se tlhokeng, mme ene ka fa khumanegong ya gagwe o ntshitse gotlhe mo o neng a na le gone.” ");
INSERT INTO tsn_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bangwe ba barutwa ba gagwe ba simolola go bua kaga bontle jwa maje a a kgabisitseng Tempele le mekgabisa ya segopotso mo dipoteng. ");
INSERT INTO tsn_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Mme Jesu a re, “Lobaka lo e tla lo dilo tse tsotlhe tse di lo kgatlhang di tlaa digelwang fa fatshe, mme ga go leje lepe le le tlaa tlogelwang le tlhatlaganye le le lengwe; gotlhe go tlaa nna mokoa o le mongwe fela wa matlakala.” ");
INSERT INTO tsn_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mme ba goa ba re, “Morena! mo go tlaa diragala leng? A go tlaa nna le tlhagiso nngwe pele ga nako ya go diragala?” ");
INSERT INTO tsn_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Mme a fetola a re, “Lo se lese ope go lo timetsa. Gonne ba le bantsi ba tlaa tla ba ipolela fa e le bo-Mesia, ba re, ‘Nako e gorogile’ mme lo se ka lwa ba dumela!” ");
INSERT INTO tsn_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","“Mme e re fa lo utlwela dintwa le dipheretlhego di simologa, lo se ka lwa tshoga. Dintwa tsa boammaaruri di tshwanetse go tla mme bokhutlo ga bo kitla bo tla ka bonako, ");
INSERT INTO tsn_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","gonne chaba e tlaa tsogologela chaba e nngwe le bogosi bo tlaa tsogologela jo bongwe, ");
INSERT INTO tsn_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","mme go tlaa nna dithoromo tse dikgolo tsa lefatshe le mauba mo mafatsheng a le mantsi, le maroborobo le dipoitshego tse di diregang mo magodimong. ");
INSERT INTO tsn_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Mme pele ga mo gotlhe go diragala; go tlaa nna le paka ya dipogiso, lo tlaa gogelwa mo disenagogeng mo dikgolegelong le fa pele ga dikgosi le balaodi ka ntlha ya Leina la Me. ");
INSERT INTO tsn_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","“Mme ka ntlha ya gone moo, Mesia o tlaa itsege ka bophara a bo a tlotlwa. ");
INSERT INTO tsn_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Jalo, lo se tshwenyege ka gore lo tlaa ikarabela jang, ");
INSERT INTO tsn_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","gonne ke tlaa lo naya mafoko a a tshwanetseng le botlhale mo e leng gore baganetsi ba lona ga ba kitla ba lo fetola! ");
INSERT INTO tsn_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Le e leng ba ga lona tota, batsadi ba lona, bomorwa-rraalona, ba lo tsalwang nabo ditsala tsa lona di tlaa lo oka gore lo tshwarwe; mme bangwe ba lona ba tlaa bolawa. ");
INSERT INTO tsn_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","“Mme batho botlhe ba tlaa lo ila ka ntlha ya gore lo ba me e bile lo bidiwa ka Leina la Me. ");
INSERT INTO tsn_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mme le fa e le thiri ya tlhogo ya lona ga e kitla e nyelela! ");
INSERT INTO tsn_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Gonne fa lo eme ka tlhomamo, lo tlaa boloka mewa ya lona. ");
INSERT INTO tsn_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Mme fa lo bona Jerusalema a dikaganyeditswe ke dintwa, ke gone lo tlaa itseng gore nako ya tshenyego e gorogile. ");
INSERT INTO tsn_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Hong lesang batho ba Judea ba tshabele kwa dithabeng. Lesang ba ba mo Jerusalema ba leke go falola, mme ba ba kwa ntle ga motse ba se ka ba leka go boa. ");
INSERT INTO tsn_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Gonne ao e tlaa bo e le malatsi a katlholo ya Modimo, le mafoko a dikwalo tsa bogologolo a a kwadilweng ke baporofiti a tlaa diragala ka botlalo. ");
INSERT INTO tsn_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","“Mme a bo go tlaa latlhega bomme ba baimana mo malatsing ao, le ba ba nang le masea. Gonne go tlaa nna pitlagano e kgolo mo chabeng e le bogale mo bathong ba. ");
INSERT INTO tsn_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","“Ba tlaa bolawa polao e e setlhogo ka ditlha-bani tsa mmaba, kgotsa ba isiwe jaaka bafaladi le ditshwara mo dichabeng tsotlhe tsa lefatshe; mme Jerusalema o tlaa fenngwa a gatakwa ke Badi-chaba go fitlhelela nako ya phenyo ya Badi-chaba e khutla mo lobakeng lwa Modimo. ");
INSERT INTO tsn_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Mme go tlaa nna le ditiragalo tse di sa tlwaelesegang mo loaping, ditlhagiso le botlhodi jo bo maswe mo letsatsing, ngwedi le dinaledi, le mono lefatsheng dichaba di tlaa nna mo pheretlhegong le mo tlalelong e kgolo ka ntlha ya modumo wa mawatle le makhubu a a sa tlwaelesegang. ");
INSERT INTO tsn_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bopelo-kgale jwa batho ba le bantsi bo tlaa reketla ka ntlha ya tiragalo e ba e bonang e tla mo lefatsheng, gonne dinonofo tsa magodimo di tlaa thubaganngwa. ");
INSERT INTO tsn_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mme batho ba lefatshe ba tlaa mpona nna Mesia, ke tla mo lerung ka nonofo le kgalalelo e kgolo. ");
INSERT INTO tsn_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mme e tlaa re fa dilo tse tsotlhe di simologa go diragala, lo eme lo tlhamalale lo lebe kwa godimo! gonne poloko ya lona e gaufi.” ");
INSERT INTO tsn_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mme a ba fa setshwantsho se: “Lepang setlhare sa mofeige kgotsa setlhare sengwe fela. ");
INSERT INTO tsn_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Fa matlhare a tlhoga, lo itse lo sa bolelelwa gore selemo se gaufi. ");
INSERT INTO tsn_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Fela jalo fa lo bona ditiragalo tse ke di lo tlhaloseditseng di diragala lo tlhomamise gore bogosi jwa Modimo bo gaufi. ");
INSERT INTO tsn_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ke lo tlhomamisetsa gore fa dilo tse di diragala, bokhutlo jwa motlha ono bo tlaa bo bo gorogile. ");
INSERT INTO tsn_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Legodimo le lefatshe di tlaa feta, le fa go ntse jalo mafoko a me a eme mo boammaaruring ka bosakhutleng. ");
INSERT INTO tsn_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","“Itiseng! Lo se letle gore go tla ga me ka tshoganetso go lo fitlhele lo sa ipaakanya. Ke se ka ka lo fitlhela lo iketlile mo boatleng, kgotsa mo medirong ya botlhapelwa, lo gapilwe ke matshwenyego a botshelo jo, jaaka mo lefatsheng lotlhe. ");
INSERT INTO tsn_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Lo lebeleleng ka metlha yotlhe. Lo rapele gore e re fa go kgonega lo tle fa pele ga me lo ise lo bone dikhuduego tse.” ");
INSERT INTO tsn_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Letsatsi le letsatsi Jesu o ne a ya kwa Tempeleng go ya go ruta, mme bontsi jwa batho ba phuthega go sa le mo mosong go ya go mo reetsa. Mme mo maabanyaneng mangwe le mangwe o ne a tle a boele kwa Thoteng ya Lotlhware go ya go lala teng. ");
INSERT INTO tsn_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mme jaanong moletlo wa Tlolaganyo wa bo o le gaufi, moletlo wa Sejuta o go neng go dirisiwa senkgwe se se sa bedisiwang. ");
INSERT INTO tsn_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Baperesiti ba bagolo le baeteledipele ba bangwe ba tumelo ba ne ba tlhoafaletse polao ya ga Jesu ba leka go senka tsela e ba ka mmolayang ka yone kwa ntle ga go tsosa mokubukubu, selo se ba neng ba se tshaba segolo. ");
INSERT INTO tsn_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mme Satane a tsena mo go Judase Isekariota, yo e neng e le mongwe wa barutwa ba ba lesome le bobedi, ");
INSERT INTO tsn_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","a ya kwa baperesiting ba bagolo le bagolwane ba batlhokomedi ba Tempele go ya go buisanya ka tsela e e siameng ya go ba okela Jesu. ");
INSERT INTO tsn_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Mme ba ne ba rata, ba itumelela go itse fa a ipaakanyeditse go ba thusa mme ba mo solofetsa tuelo. ");
INSERT INTO tsn_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Hong a simolola go ba senkela nako ya go tshwara Jesu ka tidimalo batho ba seyo. ");
INSERT INTO tsn_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mme letsatsi la moletlo wa Tlolaganyo la fitlha, le ka lone kwana ya modiro e neng ya bolawa ya ba ya jewa le senkgwe se se sa bedisiwang. ");
INSERT INTO tsn_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesu a roma Petere le Johane go ya go batla felo fa go tlaa baakanyediwang Tlolaganyo ya bone gone. ");
INSERT INTO tsn_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Mme ba botsa ba re, “O batla re ya kae?” ");
INSERT INTO tsn_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Mme a fetola a re, “E tlaa re fela fa lo tsena mo Jerusalema, lo tlaa bona monna a tshotse nkgwana ya metsi. Mo lateleng go ya kwa lwapeng lo a tsenang mo go lone, ");
INSERT INTO tsn_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","mme lo reye monna yo o nnang foo lo re, ‘Moruti wa rona a re o re kaele ntlo ya baeti fa a ka jelang Tlolaganyo gone le barutwa ba gagwe.’ ");
INSERT INTO tsn_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mme o tlaa lo tseela kwa godimo kwa tlung e tona e re setseng re e baakanyeditswe. Ke lone lefelo leo. Tsamaelang pele lo ye go baakanya dijo gone.” ");
INSERT INTO tsn_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mme ba tswa ba ya kwa motseng mme ba fitlhela sengwe le sengwe se ntse fela jaaka Jesu a boletse, mme ba baakanya dijo tsa Tlolaganyo. ");
INSERT INTO tsn_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mme Jesu le ba bangwe ba goroga, mme ka nako e e tshwanetseng ba nna fa fatshe botlhe fa lomating lwa bojelo; ");
INSERT INTO tsn_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","mme a ba raya a re, “Ke lebeletse lobaka lo ka tlhoafalo e kgolo, ke batla go ja Tlolaganyo e le lona pele ga pogiso ya me e simologa. ");
INSERT INTO tsn_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Gonne ke a lo bolelela gompieno gore ga nkitla ke tlhola ke e ja gape; go fitlhela se e se emetseng se diragala mo Bogosing jwa Modimo.” ");
INSERT INTO tsn_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Mme a tsaya senwelo sa mofine, ya re a sena go se lebogela a re, “Tsaya se lo se kgaogane. ");
INSERT INTO tsn_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Gonne ga nkitla ke e nwa mofine gape go fitlhelela Bogosi jwa Modimo bo tla.” ");
INSERT INTO tsn_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Mme a tsaya senkgwe; mme a se lebogela, a se ngathoganya a se ba naya a re, “Se ke mmele wa me, o lo o neetsweng. O jeng e le segopotso sa me.” ");
INSERT INTO tsn_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Morago ga dijo a ba naya senwelo se sengwe sa mofine a re, “Mofine o, ke sesupo sa kgolagano e ncha ya Modimo go lo boloka, kgolagano e e kanetsweng ka madi a ke tlaa a tshololang go reka mewa ya lona. ");
INSERT INTO tsn_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Mme fano fa lomating lwa bojelo go ntse mongwe jaaka tsala mo gare ga rona, ke ene monna yo o tlaa nkokang. ");
INSERT INTO tsn_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ke tshwanetse go swa. Ke ntlha nngwe ya leano la Modimo. Mme bomadimabe bo letile monna yo, yo o nkokang,” ");
INSERT INTO tsn_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mme barutwa ba ikgakgamalela gore ke ofe wa bone yo o ka dirang selo se se ntseng jalo. ");
INSERT INTO tsn_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ba simolola go ganetsanya gore ke ofe yo o tlaa nnang mo maemong a a kwa godimo mo Bogosing jo bo tlang. ");
INSERT INTO tsn_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Mme Jesu a ba raya a re, “Mo lefatsheng leno dikgosi le banna ba batona ba laola batlhanka ba bone, mme batlhanka ga ba ke ba itlhophela fa e se go ineela fela! ");
INSERT INTO tsn_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mme mo gare ga lona, ene yo o lo direlang ke ene o tlaa nnang moeteledipele wa lona. ");
INSERT INTO tsn_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mo lefatsheng Morena o nna fa lomating lwa bojelo mme a direlwe ke batlhanka ba gagwe. Mme e seng fano! Gonne ke motlhanka wa lona. ");
INSERT INTO tsn_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Le fa go ntse jalo, ka ntlha ya gore lo ntse lo le boammaaruri mo go nna mo malatsing a a matshwenyego, ");
INSERT INTO tsn_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","le ka ntlha ya gore Rre a nneetse Bogosi, le Nna gompieno ke lo naya tshwanelo, ");
INSERT INTO tsn_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ya go ja le go nwa fa lomating lwa bojelo mo Bogosing joo; mme lo tlaa nna mo ditilong tsa segosi lo atlhola ditso tse di lesome le bobedi tsa Iseraele. ");
INSERT INTO tsn_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simone, Simone, Satane o lopile gore lo mo neelwe, gore a lo fefere jaaka mabele, ");
INSERT INTO tsn_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","mme ke go rapeletse gore tumelo ya gago e seka ya fenngwa gotlhelele. Mme e re fa o sena go sokologa o bo o boela mo go nna gape, o nonotshe tumelo ya bakaulengwe ba gago o bo o e age.” ");
INSERT INTO tsn_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simone a re, “Morena ke ipaakanyeditse go ya kgolegelong le wena, le go swa le wena.” ");
INSERT INTO tsn_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Mme Jesu a mo raya a re, “Petere, mma ke go bolelele sengwe. Go simolola ka nako eno go ya go tsena ka moso mo mosong fa mokoko o lela, o tlaa bo o intatotse gararo, o bolela gore ga o nkitse.” ");
INSERT INTO tsn_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Mme Jesu a ba botsa a re, “E rile fa ke lo phatlalatsa go ya go rera Mafoko a a Molemo lo sena madi, sekgwama kgotsa diaparo tse dingwe, lo ne lwa tsamaya jang?” Mme ba fetola ba re, “Re tsamaile sentle.” ");
INSERT INTO tsn_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","A re, “Jaanong a yo o nang le sekgwama a se tseye le madi. Mme le yo o senang chaka, go botoka gore a rekise diaparo tsa gagwe a ye go e reka! ");
INSERT INTO tsn_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Gonne lobaka lo fitlhile lwa gore polelelo pele ka ga me e e reng: ‘O tlaa bonwa molato jaaka dinokwane,’ e diragale! Ee, sengwe le sengwe se se kwadilweng ka ga me ke baporofiti se tlaa diragala.” ");
INSERT INTO tsn_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Mme ba fetola ba re, “Morena, re na le dichaka tse pedi,” mme a ba fetola a re, “Di lekane!” ");
INSERT INTO tsn_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Mme a tswa mo tlung e e kwa godimo a ya kwa Thoteng ya Lotlhware jaaka gale. ");
INSERT INTO tsn_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mme ya re teng koo a ba raya a re, “Rapelang Modimo gore lo se ka lwa fenngwa ke thaelo.” ");
INSERT INTO tsn_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","Mme a tsamaya gongwe e ka ne e le sebaka sa konopelo ya lentswe, a khubama a rapela thapelo e: “Rara, fa o rata tsweetswee, tlosa senwelo se sa tlhokofatso mo go nna mme ke batla go rata ga gago, e seng ga me.” ");
INSERT INTO tsn_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Mme moengele yo o tswang legodimong a iponatsa a mo nonotsha, ");
INSERT INTO tsn_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","gonne o ne a le mo tlhokofatsong ya mowa mo o neng a rotha mofufutso wa madi; ka marothodi a magolo a wela fa fatshe fa a ntse a rapela thata ka tlhoafalo. ");
INSERT INTO tsn_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mme ya re lwa bofelo a boela gape kwa barutweng ba gagwe, a ba fitlhela ba robetse, ba lapisitswe ke bohutsana. ");
INSERT INTO tsn_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","A ba raya a re, “A lo robetse! Tsogang! Rapelang gore lo se ka lwa fenngwa fa lo raelwa.” ");
INSERT INTO tsn_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Mme ya re fa a sa ntse a bua jaana lesomo la batho la tla le eteletswe pele ke Judase, mongwe wa barutwa ba gagwe ba ba neng ba le lesome le bobedi. Judase a tsamaela kwa go Jesu a mo atla mo lerameng ka tumediso ya botsalano. ");
INSERT INTO tsn_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mme Jesu a mo raya a re, “Judase ke eng fa o dira jaana, o oka Morwa Motho ka katlo?” ");
INSERT INTO tsn_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Mme ya re barutwa ba gagwe ba bona se se tlaa tlogang se direga ba goa ba re, “Morena a re ka lwa? Re tsile le dichaka!” ");
INSERT INTO tsn_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mme mongwe wa bone a rema tsebe e e kafa letsogong le legolo la motlhanka wa Moperesiti yo Mogolo a e kgaola. ");
INSERT INTO tsn_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mme Jesu a re, “Lo seka lwa busolosa ka gope”. Mme a ama fa tsebe e neng e le teng a e busetsa. ");
INSERT INTO tsn_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mme Jesu a bua le baperesiti ba bagolo le balaodi ba batlhokomedi ba Tempele le baeteledipele ba tumelo ba ba neng ba eteletse lesomo la batho pele. A botsa a re, “A ke serukutlhi, fa lo tsile ka dichaka le melamu go ntshwara jaana?” ");
INSERT INTO tsn_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ke eng fa lo ne lo sa ntshware mo Tempeleng. Ke ne ke le koo malatsi otlhe. Mme lo ke lobaka lwa lona, lobaka lo nonofo ya ga Satane e busang thata ka lone. ");
INSERT INTO tsn_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jalo ba mo tshwara ba mo isa kwa bonnong jwa Moperesiti yo Mogolo, mme Petere a ba latela a katogetse kgakajana. ");
INSERT INTO tsn_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mme masole a gotsa molelo mo lwapeng ba nna fa fatshe ba ora, mme Petere a ora nabo. ");
INSERT INTO tsn_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mme motlhanka wa morweetsana a mo lemoga mo leseding la molelo hong a simolola go mo tlhoma matlho. Mme ya re lwa bofelo a re, “Monna yo o ne a na le Jesu!” ");
INSERT INTO tsn_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Petere a itatola a re, “Mosadi, ga ke itse monna yoo gotlhelele!” ");
INSERT INTO tsn_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Morago ga lobakanyana mongwe a mo leba a re, “O tshwanetse wa bo o le mongwe wa bone!” Petere a fetola a re, “Nnyaa rra, ga ke ene!” ");
INSERT INTO tsn_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","E rile kwa moragonyana e ka nna lobaka lwa oura mongwe a tlhomamisa a re, “Ke itse motho yo, ke mongwe wa barutwa ba ga Jesu, gonne ba tswa Galalea mmogo.” ");
INSERT INTO tsn_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mme Petere a re, “Monna ke wena, ga ke itse gore o bua kaga eng.” Mme ya re a bua mafoko a, mokoko wa lela. ");
INSERT INTO tsn_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mme ya re ka lobaka loo Jesu a retologa a leba Petere mme Petere a gakologelwa gore o ne a mo reile a re, “Pele ga mokoko o lela ka moso mo mosong o tlaa bo o intatotse gararo.” ");
INSERT INTO tsn_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Hong Petere a tswa mo lwapeng, a lela mo go botlhoko. ");
INSERT INTO tsn_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Mme badisa ba ba neng ba disitse Jesu ba simolola go mo sotla. Ba mo fapa matlho ba mo itaya ka mabole ba mmotsa ba re, “E mang yo o neng a go itaya ka nako eo, moporofiti?” ");
INSERT INTO tsn_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ba mo tlhaeletsa ka matlhapa a mefuta yotlhe. ");
INSERT INTO tsn_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","E rile letsatsi le tlhaba mo mosong o o latelang Kgotla e Tona ya Sejuta ya phuthega, go na le baperesiti ba bagolo le baruti ba molao ba bagolo ba Sechaba, Jesu a tlisiwa fa pele ga Lekgotla leo, ");
INSERT INTO tsn_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","68","mme a tewa gatwe a tlhomamise gore a o ipitsa Mesia kgotsa nnyaa. Mme a fetola a re, “Le fa nka lo bolelela ga lo kitla lo ntumela kgotsa lo ntetla go ntsha ngongorego ya me. ");
INSERT INTO tsn_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","“Mme nako e e tla ka bofefo fa Nna, Morwa Motho, ke tlaa nnang fa seatleng se segolo sa nonofo ya Modimo.” ");
INSERT INTO tsn_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Hong ba goa botlhe ba re, “A jaanong o ipitsa gore o Morwa Modimo?” Mme a fetola a re, “Ee ke ene.” ");
INSERT INTO tsn_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mme ba goa ba re, “Re santse re tlhoka eng? Gonne rona ka bo rona re mo ikutlwetse a bua jalo.” ");
INSERT INTO tsn_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mme Lekgotla lotlhe la tseela Jesu kwa go Pilatwe wa molaodi. ");
INSERT INTO tsn_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mme ba simolola go mmaya molato ba re: “Motho yo o ntse a timetsa batho ba rona ka go ba raya a re ba se ka ba ntshetsa mmuso wa Seroma makgetho ebile o ipitsa gore ke Mesia wa rona, Kgosi.” ");
INSERT INTO tsn_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mme Pilatwe a mmotsa a re, “A o Mesia wa bone, Kgosi ya bone?” Jesu a fetola a re, “Ee, ke jaaka o bua.” ");
INSERT INTO tsn_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Mme Pilatwe a retologela kwa baperesiting ba bagolo le kwa lesomong la batho a re, “Moo ga se molato!” ");
INSERT INTO tsn_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ba kgobega marapo ba re, “Mme o tsosa dipheretlhego kgatlhanong le mmuso gongwe le gongwe kwa o yang teng, mo Judea otlhe, go tswa Galalea, go ya Jerusalema!” ");
INSERT INTO tsn_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatwe a botsa a re, “A ke Moga lalea?” ");
INSERT INTO tsn_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Mme ya re ba dumela, Pilatwe a re ba mo ise kwa go Kgosi Herode, gonne Galalea o ne a le ka fa tlase ga taolo ya ga Herode, mme Herode o ne a le mo Jerusalema ka lobaka loo. ");
INSERT INTO tsn_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herode o ne a itumelela sebaka seo sa go bona Jesu, gonne o ne a mo utlwaletse thata mme a solofetse go bona a dira kgakgamatso. ");
INSERT INTO tsn_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","A botsa Jesu dipotso ka go latelana, mme a se ka a fetola. ");
INSERT INTO tsn_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mme ya re ka lobakanyana loo, baperesiti ba bagolo le baeteledipele ba tumelo ba goa ba eme foo ba mmaya molato. ");
INSERT INTO tsn_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mme Herode le masole a gagwe ba simolola go sotla Jesu ba mo tshega; ba mo apesa seaparo sa segosi, ba mmusetsa kwa go Pilatwe. ");
INSERT INTO tsn_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mme ya re letsatsi leo Herode le Pilatwe ba ba kileng ba ne ba tlhoane pele, ba nna ditsala tse dikgolo. ");
INSERT INTO tsn_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Mme Pilatwe a phutha baperesiti ba bagolo le baeteledipele ba bangwe ba Sejuta le batho, ");
INSERT INTO tsn_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","a bolela mogopolo wa gagwe a re, “Lo ntereditse monna yo, lo mmaya molato ka go tsosa khuduego kgatlhanong le mmuso wa Se-Roma. Mme ke mo tlhatlhobile sentle mo ntlheng e mme ga ke mmone molato ope. ");
INSERT INTO tsn_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herode le ene o mmuseditse kwano go rona, a sa mmona molato o o tshwanetseng loso. ");
INSERT INTO tsn_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jalo ke tlaa mo kgwathisa ka thupa e e mitlwa, ke bo ke mo golola.” ");
INSERT INTO tsn_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","Mme modumo o mogolo wa tsoga mo bathong ka lentswe le le lengwe ba re, “Mmolaye, o re gololele Barabase!” ");
INSERT INTO tsn_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabase o ne a le mo kgolegelong ka ntlha ya go simolola dipheretlhego mo Jerusalema kgatlhanong le mmuso le go bolaya batho). ");
INSERT INTO tsn_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Mme Pilatwe a ganetsanya nabo, gonne o ne a batla go golola Jesu. ");
INSERT INTO tsn_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mme ba goa ba re, “Mmapole! Mmapole!” ");
INSERT INTO tsn_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","A bo a bua le bone la boraro a kopa a re, “Ka ntlha yang? O dirile molato ofe? Ga ke a bona lebaka lepe la go mo atlholela loso. Mme ke tlaa mo kgwathisa ke bo ke mo lesa a tsamaya.” ");
INSERT INTO tsn_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mme ba goela kwa godimodimo gore Jesu a bapolwe, mantswe a bone a bo a fenya. ");
INSERT INTO tsn_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Mme Pilatwe a atlholela Jesu loso jaaka ba lopile. ");
INSERT INTO tsn_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Mme a golola Barabase, ka fa kopong ya bone, monna yo o neng a tshwaretswe go feretlha le go bolaya batho. Mme Pilatwe a ba neela Jesu gore ba mo dire ka fa ba ratang ka teng. ");
INSERT INTO tsn_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mme ya re bontsi jwa batho bo isa Jesu kwa o neng a ya go bolaelwa teng, ba bona Simone wa Mokurene yo e neng e le gone a gorogang mo Jerusalema a tswa kwa dikgaolong, mme ba mo pateletsa go ba sala morago, a sikere mokgoro wa ga Jesu. ");
INSERT INTO tsn_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bontsintsijwa batho jwa mo sala morago, le basadi ba le bantsi ba ba neng ba mo lelela ka kutlobotlhoko. ");
INSERT INTO tsn_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mme Jesu a retologa a ba raya a re, “Bomorwadia Jerusalema, se nteleleng, iteleleng lo bo lo lelele bana ba lona. ");
INSERT INTO tsn_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Gonne malatsi a e tla, a basadi ba ba senang bana ba tlaa bidiwang ba ba sego tota. ");
INSERT INTO tsn_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Batho ba tlaa lopa dithaba gore di ba wele di ba sugakanye le maje gore a ba khurumetse. ");
INSERT INTO tsn_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Gonne fa dilo tse di ntseng jaana di dirwa mo go nna Setlhare sa Botshelo, lona ba tlaa lo dira jang?” ");
INSERT INTO tsn_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","33","Dinokwane tse pedi di ne tsa tlisiwa go ya go bolawa nae kwa lefelong le le bidiwang “Logata.” Ka boraro jwa bone ba bapolwa, Jesu a le mo mokgorong o o fa gare, dinokwane tse pedi di le mo ditlhakoreng. ");
INSERT INTO tsn_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Mme Jesu a re, “Rara, itshwarele batho ba, gonne ga ba itse se ba se dirang.” Mme masole a kgaogana diaparo tsa gagwe ba di laola ka bola. ");
INSERT INTO tsn_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Batho ba lebelela. Mme Baeteledipele ba Sejuta ba sotla. Ba re, “O ne a siame thata go thusa ba bangwe, a re mmoneng a ipoloka fa e le gore ke ene tota yo o tlhophilweng ke Modimo go nna Mesia.” ");
INSERT INTO tsn_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mme masole le one a mo sotla ka go mo nosa seno se se botlha sa mofine. ");
INSERT INTO tsn_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Mme ba mo tlhaeletsa ba re, “Fa o le kgosi ya Bajuta, ipoloke!” ");
INSERT INTO tsn_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kitsiso ya pegwa mo mokgorong fa godimo ga gagwe ka mafoko a, “Yo ke Kgosi ya Bajuta.” ");
INSERT INTO tsn_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mongwe wa dinokwane yo o neng a pegilwe go bapa nae a sotla a re, “Wa re o Mesia, a ga o ene? Itshupe ka go ipoloka le rona o re boloke.” ");
INSERT INTO tsn_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Mme senokwane se sengwe sa re, “A le Modimo ga o o boife, le fa o o swa? Re tshwanetse go swa ka ntlha ya ditiro tsa rona tse di bosula, mme monna yo ga a a dira sepe se se molato.” ");
INSERT INTO tsn_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mme a re, “Jesu, o nkgopole fa o tsena mo Bogosing jwa gago!” ");
INSERT INTO tsn_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Mme Jesu a fetola a re, Tsatsi jeno o tlaa nna le nna kwa Paradaiseng ke go solofetsa ka boammaaruri. ");
INSERT INTO tsn_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Mme ya bo e setse e le motshegare wa sethoboloko; ga nna lefifi mo lefatshing lotlhe selekanyo sa oura tse tharo, go fitlha ka nako ya boraro. ");
INSERT INTO tsn_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Letsatsi la fifala, mme ka tshoganetso sesiro sa Tempele sa gagoga ka bogare. ");
INSERT INTO tsn_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Mme Jesu a goa a re, “Rara, ke go neela mowa wa me.” Mme ka mafoko ao a swa. ");
INSERT INTO tsn_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ya re molaodi wa masole a Se-Roma yo o neng a laola polao ya bone a bona se se diragetseng, a tlelwa ke poifo fa pele ga Modimo a re, “Ruri monna yo o ne a sena molato.” ");
INSERT INTO tsn_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mme ya re bontsintsi jwa batho ba ba neng ba tsile go bona papolo ba bona Jesu a sule, ba boela magaeng ka kutlobotlhoko e kgolo. ");
INSERT INTO tsn_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mme ya re barutwa ba gagwe ba bona se se tla tlogang se direga ba goa ba re “Morena, a re ka lwa re tsile le dichaka.” ");
INSERT INTO tsn_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","52","Mme monna mongwe yo o bidiwang Josefa, leloko la Kgotla Kgolo ya Sejuta, wa motse wa Arimathea mo Judea, a ya kwa go Pilatwe a mo kopa setopo sa ga Jesu. E ne e le monna yo o boifang Modimo yo o neng a ntse a lebeletse go tla ga Mesia ebile o ne a ise a ke a dumalane le maikaelelo le dikgato tsa baeteledipele ba bangwe ba Sejuta. ");
INSERT INTO tsn_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mme a folosa mmele wa ga Jesu a o phuthela ka letsela le le leele la lene mme a o baya mo lebitleng le lesha le le iseng le ke le dirisiwe, le gabilwe mo lefikeng mo mhapheng wa thaba. ");
INSERT INTO tsn_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mo go ne ga diragala ka Labotlhano mo tshokologong ka letsatsi la iketleetso ya Sabata. ");
INSERT INTO tsn_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mme ya re setopo se tsewa, basadi ba ba neng ba tswa Galalea ba se sala morago, ba se bona se tsenngwa mo phupung. ");
INSERT INTO tsn_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mme ba ya magaeng go ya go baakanya malao le ditlolo go dibela setopo; mme ya re ba fetsa ga bo go le Sabata. Hong ba itapolosa letsatsi leo lotlhe ka fa molaong wa Sejuta. ");
INSERT INTO tsn_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Erile go sa le mo mosong ka Tshipi ba tseela ditlolo tsa bone kwa phupung, ");
INSERT INTO tsn_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","mme ba fitlhela lentswe le legolo le le neng le khurumeditse phupu le hidikolotswe. ");
INSERT INTO tsn_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Jalo ba tsena mo teng, mme setopo sa ga Jesu sa bo se seyo. ");
INSERT INTO tsn_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ba ema foo ba reregile ba akanya gore se ka bo se diragaletswe ke eng? Ka tshoganetso banna ba babedi ba iponatsa mo go bone, ba apere diaparo tse di tshweu di lakasela mo e leng gore matlho a bone a ne a kaloga. ");
INSERT INTO tsn_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Basadi ba bo ba tshogile thata mme ba obama fa pele ga bone. Mme banna ba ba botsa ba re, “Ke eng fa lo batla motshedi mo diphupung? ");
INSERT INTO tsn_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Ga a yo fa! O rudile! A ga lo gakologelwe se o neng a se lo bolelela kwa Galalea gore Mesia o tshwanetse go okelwa mo nonofong ya batho ba ba bosula a bo a bapolwa mme a tsoge ka letsatsi la boraro?” ");
INSERT INTO tsn_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mme ba gakologelwa, ");
INSERT INTO tsn_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ba sianela kwa Jerusalema go ya go bolelela barutwa ba gagwe ba ba lesome le bongwe le mongwe le mongwe se se diragetseng. ");
INSERT INTO tsn_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","(Basadi ba ba neng ba ya kwa phupung e ne e le Marea Magatalena, Joana le Marea mmagwe Jakobe le ba bangwe ba le bantsinyana). ");
INSERT INTO tsn_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mme polelo e ya utlwala ekete dinaane fela mo bathong, ba se ka ba e dumela. ");
INSERT INTO tsn_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Le fa go ntse jalo, Petere a sianela kwa phupung go ya go bona. A obama a okomela mme a bona diphutho tse di senang sepe; a boela gae, a gakgamaletse se se diragetseng. ");
INSERT INTO tsn_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ka lone letsatsi leo, balatedi bangwe ba ga Jesu ba le babedi ba bo ba ya kwa motsaneng wa Emau; bokgakala jwa dimmaele di supa go tswa kwa Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ya re ba ntse ba tsamaya ba bo ba bua; kaga loso lwa ga Jesu, ");
INSERT INTO tsn_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","mme ka tshoganetso Jesu ka sebele a tla a tseisanya nabo tsela! ");
INSERT INTO tsn_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mme ba se ka ba mo lemoga, gonne Modimo o ne wa dira gore ba seka ba lemoga. ");
INSERT INTO tsn_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","A ba raya a re, “Lo lebega o ka re lo tshotse kgang e tona ka ga sengwe. Lo tshotse kgang ka ga eng?” Ba ema go se kae ba tlhontse difatlhogo. ");
INSERT INTO tsn_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mme mongwe wa bone, ebong Keleopase a fetola a re, “E tshwanetse ya bo e le wena fela mo Jerusalema yo o iseng o utlwalele dilo tse di gakgamatsang tse di diragetseng mo bekeng e e fetileng.” ");
INSERT INTO tsn_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesu a botsa a re, “Dilo di fe?” Ba re, “Dilo tse di dirageletseng Jesu, wa Monasara. E ne e le Moporofiti yo o neng a dira dikgakgamatso tse di leng thata go dumelwa ebile e le Moruti yo mogolo yo o neng a tlotlwa thata ke Modimo le batho. ");
INSERT INTO tsn_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mme baperesiti ba bagolo le baeteledipele ba tumelo ya rona ba mo tshwara ba mo neela mmuso wa Se-Roma go atlholelwa loso, ba bo ba mmapola. ");
INSERT INTO tsn_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Re ne re solofetse gore e ne e le Mesia yo o galalelang yo o tsileng go golola Iseraele. Mme jaanong, mo godimo ga mo gotlhe mo go diragetseng mo malatsing a mararo a a fetileng, ");
INSERT INTO tsn_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","basadi bangwe ba setlhopha sa rona sa balatedi ba gagwe ba ne ba le kwa phupung phakela thata mme ba boa ka polelo e e hakgamatsang e e reng setopo sa gagwe ga seyo, le gore ba bonye baengele gone ba ba ba boleletseng gore Jesu o a tshela! ");
INSERT INTO tsn_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bangwe ba rona ba ne ba sianela teng go ya go bona, mme ka boammaaruri jo bo tletseng setopo sa ga Jesu sa bo se seyo, fela jaaka basadi ba boletse.” ");
INSERT INTO tsn_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Mme Jesu a ba raya a re, “Lo dieleele go le kae? A batho ba ba dieleele! Lo palelwa ke go dumela se baporofiti ba se kwadileng mo dikwalong! ");
INSERT INTO tsn_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","A ga go a tlhalosiwa pele ke baporofiti gore Mesia o tlaa bogela dilo tse tsotlhe pele ga a tsena mo kgalalelong ya Gagwe!” ");
INSERT INTO tsn_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mme a ba phuthololela mafoko ka go latelana ga one mo dikwalong tsa baporofiti, a simolola ka lokwalo lwa Genesese mme a tsamaya le dikwalo tse dingwe, a tlhalosa gore mafoko a ne a raya eng le gore a ne a bua kaga gagwe. ");
INSERT INTO tsn_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ka nako e ba ne ba atamela Emau kwa ba neng ba ya teng. Jesu a dira jaaka o ka re o santse a fetela kwa pele, ");
INSERT INTO tsn_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","mme ba mo kopa go lala nabo, ka nako e ne e setse e fetile. Jalo a ya lwapeng nabo. ");
INSERT INTO tsn_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mme ya re ba nna fa fatshe ba a ja, a kopela dijo tshegofatso mo Modimong mme a tsaya senkgwe se sennye a se ngathoganya a se ba naya, ");
INSERT INTO tsn_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ka bonako matlho a bone a bulega mme ba mo lemoga! mme ka sone sebaka se a nyelela. ");
INSERT INTO tsn_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ba simolola go bolelelana ka fa dipelo tsa bone di tlhotlhelesegileng ka teng fa a bua le bone a tlhalosa dikwalo fa ba ntse ba tsamaya mo tseleng. ");
INSERT INTO tsn_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","34","Fela ka yone nako eo ba nanoga ba boela kwa Jerusalema, kwa barutwa ba ba lesome le motso le balatedi ba bangwe ba ga Jesu ba neng ba ba dumedisa ka mafoko a, “Ruri Morena o tsogile. O iponaditse mo go Petere!” ");
INSERT INTO tsn_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mme ba babedi ba ba tswang Emau ba bolela ka fa Jesu a iponaditseng mo go bone ka teng fa a ngathoganya senkgwe. ");
INSERT INTO tsn_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mme ya re ba sa ntse ba bua ka gone, ka tshoganetso Jesu a bo a setse a eme foo mo gare ga bone, a ba dumedisa! ");
INSERT INTO tsn_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mme botlhe ba bo ba tshogile thata, ba gopola gore ba bona sepoko. ");
INSERT INTO tsn_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","A ba botsa a re, “Lo tshositswe ke eng? Ke eng fa lo belaela gore a ruri ke Nna? ");
INSERT INTO tsn_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","“Lebelelang dinao tsa me! Lo ka bona gore ke nna ka sebele. Nkamang gore lo tlhomamise sentle gore ga ke sepoko! Gonne dipoko ga di na mebele, jaaka lo bona nna ke na le one.” ");
INSERT INTO tsn_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Mme ya re a bua jaana, a tsholetsa diatla gore ba bone dipadi tsa dipekere mo diatleng tsa gagwe, a ba a ba kaela dintho mo dinaong tsa gagwe. ");
INSERT INTO tsn_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Le fa go ntse jalo ba nna foo ba sa itse gore ba ka reng, ba tletse boitumelo le pelaelo. Mme a ba botsa a re, “A lo na le sengwe se se jewang fano?” ");
INSERT INTO tsn_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ba mo naya setoki sa tlhapi e e besitsweng. ");
INSERT INTO tsn_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Mme a e ja ba mo lebeletse. ");
INSERT INTO tsn_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Mme a ba raya a re, “Mafoko a, ke ona a ke kileng ka a bua le lona ke santse ke na le lona fa dilo tsotlhe di na le go diragala, ebong tse di kwadilweng mo molaong wa ga Moshe, le mo baporofiting le mo dipesalemeng, kaga me.” ");
INSERT INTO tsn_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Hong a rarabolola tlhaloganyo ya bone, gore ba tlhaloganye dikwalo. ");
INSERT INTO tsn_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Mme a ba raya a re, “Go kwadilwe jaana, fa ene Keresete a tla swa jalo, mme a ba a tsoga mo losong ka letsatsi la boraro; ");
INSERT INTO tsn_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","le gore go rerelwe merafe yotlhe boikotlhao jwa dibe ka leina la gagwe, go simolola mo Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","“Lona lo basupi ba dilo tse. ");
INSERT INTO tsn_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mme, bonang, ke tlisa polelo ya tsholofetso ya ga Rre mo go lona: mme lo name lo sa diegile mo motseng wa Jerusalema, go tlo go tsamaye lo amogele nonofo e e tswang kwa godimo.” ");
INSERT INTO tsn_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Mme a ba etelela pele ba ya go fitlha go lebagana le Bethania; mme a choletsa mabogo a gagwe, a ba segofatsa. ");
INSERT INTO tsn_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mme ga diragala ya re a sa ntse a ba segofatsa, a kgaogana nabo, mme a tsholelediwa kwa legodimong. ");
INSERT INTO tsn_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mme ba mo obamela; mme ba boela kwa Jerusalema ka boitumelo jo bogolo, ");
INSERT INTO tsn_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","mme ba tlhola ba ntse ba le mo tempeleng ka gale, ba baka Modimo.");
INSERT INTO tsn_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Erile pele ga tlholego ya dilo tshotlhe, Keresete a bo a ntse a le teng le Modimo. Ga a bolo go nna a tshela mme a le Modimo ka sebele. ");
INSERT INTO tsn_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","O tlhodile sengwe le sengwe se se leng teng, ga gona sepe se se tshelang se se sa tlholwang ke ene. ");
INSERT INTO tsn_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Botshelo jo bo sa khutleng bo mo go ene, mme botshelo jo bo naya batho lesedi. ");
INSERT INTO tsn_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Botshelo jwa gagwe ke lesedi le le phatsimang mo lefifing, mme lefifi ga le kake la tima lesedi. ");
INSERT INTO tsn_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Modimo o ne wa roma Johane wa Mokolobetsi e le mosupi wa gore Jesu Keresete ke lesedi la Boammaaruri. ");
INSERT INTO tsn_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Johane e ne e se lesedi ka boene; o ne a le mosupi wa lone fela. ");
INSERT INTO tsn_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Moragonyana, yo e leng ene lesedi la boammaaruri a goroga go tla go phatsima mo go mongwe le mongwe yo o tlang mo lefatsheng. ");
INSERT INTO tsn_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mme le fa tota a dirile lefatshe, lefatshe ga le a ka la mo itse fa a sena go tla. ");
INSERT INTO tsn_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","12","Le fa e le mo lefatsheng la ga gabo le mo go ba ga gabo ebong Bajuta, ga a a ka a amogelesega. Ba se kae fela ba ne ba mo amogela. Mme botlhe ba ba neng ba mo amogela, o ne a ba naya tshiamelo ya go nna bana ba Modimo. Gotlhe mo ba neng ba tlhoka go go dira, e ne e le go mo ikanya gore a ba boloke. ");
INSERT INTO tsn_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Botlhe ba ba dumelang se, ba tsalwa sesha eseng ga senama mo go tswang mo thatong ya motho kgotsa leano; mme go tswa mo go rateng ga Modimo. ");
INSERT INTO tsn_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mme Keresete a nna motho mme a nna mo lefatsheng mo gare ga rona a tletse lorato lwa boitshwarelo le boammaaruri. Bangwe ba rona ba bonye kgalalelo ya gagwe; kgalalelo ya Morwa yo o esi wa ga Rara wa Legodimo! ");
INSERT INTO tsn_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Johane a mo supegetsa batho, a bolelela batho ba le bantsintsi a re, “Yo ke ene yo ke neng ka bua ka ga gagwe ke re, ‘Mongwe o e tla yo o mphetang go menaganye; gonne ga a bolo go nna pele ga ke tsalwa.’ ” ");
INSERT INTO tsn_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Rotlhe re amogetse mahumo a a tswang mo matlhogonolong a gagwe a o a re lereditseng, letlhogonolo mo godimo ga letlhogonolo go koegilwe mo go rona! ");
INSERT INTO tsn_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Gonne Moshe o re neetse molao fela o o nang le maikaelelo a a thata go tshegediwa, le tshiamo e e senang kutlwelobotlhoko, fa Jesu Keresete ene a re lereditse lorato le boitshwarelo. ");
INSERT INTO tsn_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ga go na ope yo tota o kileng a bona Modimo ka matlho, fa e se Morwawe fela a le esi yo o mmonyeng, gonne ke mopati wa ga Rara ebile o re boleletse gotlhe ka ga Ene. ");
INSERT INTO tsn_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Baeteledipele ba Sejuta ba roma baperesiti le bathusi ba bone go tsweng kwa Jerusalema go botsa Johane gore a o ne a ipitsa Mesia. ");
INSERT INTO tsn_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Mme a ganela mo go senang gotwe sepe. A re, “Ga ke Keresete.” ");
INSERT INTO tsn_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Mme ba mmotsa ba re, “Go siame, jaanong o mang? A o Elija?” A fetola a re, “Nnyaa.” “A o moporofiti?” “Nnyaa.” ");
INSERT INTO tsn_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Jaanong o mang? Re bolelele gore re tle re kgone go neela ba ba re romileng karabo. Wa reng fa o ikarabela?” ");
INSERT INTO tsn_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","A fetola a re, “Ke lentswe le le tswang mo sekakeng se se senang sepe, ke goa fela jaaka Isaia a porofitile a re, ‘ipaakanyetseng go tla go Morena’.” ");
INSERT INTO tsn_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Mme ba ba neng ba romilwe ke Bafarasai ba mmotsa ba re, “Fa o se Mesia kgotsa Elija kgotsa moporofiti, o tsaya kae tetlelelo ya go kolobetsa?” ");
INSERT INTO tsn_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Johane a ba raya a re, “Ke kolobetsa fela ka metsi, mme mo gare ga bontsintsi jwa batho, go na le mongwe yo lo iseng lo ke lo rakane nae. ");
INSERT INTO tsn_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yo o tlaa tlogang a simolola tirelo-Modimo mo go lona, mme ga ke a lekana go nna le fa e le lekgoba la gagwe.” ");
INSERT INTO tsn_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tiragalo e e ne ya diragala kwa Bethania, motse o o ka fa ntlheng e nngwe ya Noka ya Jorodane kwa Johane o neng a kolobetsa teng. ");
INSERT INTO tsn_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Letsatsi le le latelang Johane a bona Jesu a tla ntlheng ya gagwe mme a re, “Bonang! Kwana ya Modimo e e tlosang boleo jwa lefatshe! ");
INSERT INTO tsn_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ke ene yo ke neng ke bua ka ga gagwe ke re, ‘Monna yo o mphetang thata o tlaa tloga a tla ka bofefo, yo o sa bolong go nna pele ga me!’ ");
INSERT INTO tsn_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ke ne ke sa itse gore ke ene, mme ke fano ke kolobetsa ka metse gore ke mo supe mo chabeng ya Iseraele.” ");
INSERT INTO tsn_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Mme Johane a bolela ka go bona Mowa O O Boitshepo o fologela mo go Jesu o le mo setshwa-nong sa lephoi o tswa kwa legodimong. ");
INSERT INTO tsn_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Gape Johane a re, “Ke ne ke sa itse gore ke ene, mme erile ka nako e Modimo o neng o nthoma ka yone go tla go kolobetsa wa re, ‘Fa o bona Mowa O O Boitshepo o fologa o nna mo mongweng, ke ene yo o mmatlang. Ke ene yo o kolobetsang ka Mowa O O Boitshepo.’ ");
INSERT INTO tsn_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ke bonye go diragala mo monneng yo, mme ke sone se ke supang gore ke Morwa Modimo.” ");
INSERT INTO tsn_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Letsatsi le le latelang fa Johane a eme le barutwa ba bangwe ba le babedi, ");
INSERT INTO tsn_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesu a feta gautshwane le bone. Johane a mo leba thata mme a bua a re, “Bonang Kwana ya Modimo!” ");
INSERT INTO tsn_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Mme barutwa ba babedi ba ga Johane ba retologa ba sala Jesu morago! ");
INSERT INTO tsn_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesu a retologa a ba bona ba mo setse morago. Mme a ba botsa a re, “Lo batlang?” Ba mo raya ba re, “Rra, o nna kae?” ");
INSERT INTO tsn_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","A ba raya a re, “Tlang lo bone.” Mme ba ya le ene kwa a neng a nna teng mme ba nna nae lobaka lo e neng e ka nna go simologa nako ya bone mo tshokologong go fitlhelela go nna lotlatlana. ");
INSERT INTO tsn_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","(Mongwe wa banna ba e ne e le Anderea Monnaa Simone Petoro). ");
INSERT INTO tsn_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Mme Anderea a ya go senka Petoro mogolowe a mo raya a re, “Re bonye Mesia.” ");
INSERT INTO tsn_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Mme a isa Petoro kwa go Jesu. Jesu a tlhoma Petoro matlho le mogopolo ka lobakanyana mme a re, “O Simone, morwa Johane, mme o tlaa bidiwa Petoro, ke gore Lefika!” ");
INSERT INTO tsn_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Letsatsi le le latelang Jesu a ikaelela go ya Galalea. Mme bona Filipo a mo raya a re, “Ntshala morago.” ");
INSERT INTO tsn_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo a ya go senka Nathaniele mme a mo raya a re, “Re bonye Mesia! Ene tota motho yo Moshe le baporofiti ba boletseng ka ga gagwe! Leina la gagwe ke Jesu, morwa Josefe yo o tswang Nasaretha!” ");
INSERT INTO tsn_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nathaniele a hakgamala a re. ");
INSERT INTO tsn_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“Kwa Nasaretha! a gona le sengwe se se siameng se se ka tswang teng?” Filipo a re, “Tla fela o iponele.” ");
INSERT INTO tsn_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ya re ba atamela Jesu a re, “Monna yo o ikanyegang ke yo o e tla, Moiseraele wa boammaaruri.” ");
INSERT INTO tsn_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathaniele a re, “O nkitsile jang?” Mme Jesu a fetola a re, “Erile o le ka fa tlase ga setlhare sa mofeige, Filipo a ise a go bone, ke ne ke go bona.” ");
INSERT INTO tsn_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathaniele a fetola a re, “Rra, O Morwa Modimo, Kgosi ya Iseraele!” ");
INSERT INTO tsn_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesu a mmotsa a re, “A o dumela gotlhe mo fela ka gore ke go boleletse gore ke ne ka go bona ka fa tlase ga setlhare sa mofeige? O tlaa bona ditshupo tse dikgolo go na le tse. ");
INSERT INTO tsn_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","O tlaa bo o bone le legodimo le atlhamologa le baengele ba Modimo ba boaboela ba tla kwa go nna, Monna wa kgalalelo.” ");
INSERT INTO tsn_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mme erile morago ga malatsi a mabedi, mmaagwe Jesu o ne a le molalediwa mo lenyalong kwa motseng wa Kana mo Galalea, ");
INSERT INTO tsn_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","mme Jesu le barutwa ba gagwe le bone ba ne ba laleditswe. ");
INSERT INTO tsn_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mofine wa fela go sa ntse go itumelwa, mme mmaagwe Jesu a tla kwa go ene go mmolelela ka mathata a. ");
INSERT INTO tsn_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Mme Jesu a mo fetola a re, “Ga nkake ka go thusa jaanong jaana ga e ise e be e nne nako ya me ya go dira dikgakgamatso.” ");
INSERT INTO tsn_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mme mmaagwe a raya batlhanka a re, “Dirang sengwe le sengwe se a se lo bolelelang.” ");
INSERT INTO tsn_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Dinkgwana tsa metse di le thataro tse di dirilweng ka lentswe, tsa bo di le foo; di ne di dirisiwa kafa mokgweng wa Sejuta wa mediro mme nngwe le nngwe ya tsone e ne e ka tshela diemere di ka nna masome a le mabedi kgotsa a le mararo. ");
INSERT INTO tsn_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","8","Mme Jesu a raya batlhanka a re, ba di tlatse metsi go fitlhelela metsi a nna mo mosetlhong o o kwa godimo. Erile go sena go dirwa jalo a re, “Gang mo go tsone lo ise kwa go motsamaisi wa modiro.” ");
INSERT INTO tsn_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Erile motsamaisi wa mediro a leka metsi mo ganong a jaanong a neng a fetogile mofine, a sa itse gore o ne o tswa kae (lefa tota batlhanka bone ba ne ba itse), a bitsa monyadi a re, ");
INSERT INTO tsn_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Se ke seno se se gakgamatsang! Wena o farologanye le batho ba bangwe! Motho yo o amogelang balalediwa o tle a dirise mofine o o monate pele, mme e re morago fa mongwe le mongwe a kgotshe a sa tlhole a kgathala, mme a lere mofine o o seng monate. Mme wena o beetse lobaka lono lwa bofelo mofine o o monate.” ");
INSERT INTO tsn_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kgakgamatso e e ne ya dirwa mo Kana wa Galalea e le sesupo sa ntlha sa ga Jesu mo pontsheng sa nonofo ya legodimo e a romilweng go tla go e supa. Mme barutwa ba gagwe ba dumela tota gore ke Mesia. ");
INSERT INTO tsn_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Erile morago ga lenyalo a ya Kaperenama go ya go nna teng malatsinyana le mmaagwe, le bomonnawe le barutwa. ");
INSERT INTO tsn_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Mme ya bo e le lobaka lwa Tlolaganyo ya Sejuta ya ngwaga le ngwaga, mme Jesu a ya Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mme a bona mo patlelong ya Tempele barekisi ba rekisa dikgomo, dinku le maphoi e le ga ditlhabelo, le baananyi ba madi ba le ka fa morago ga mabati a go ananyediwang mo go one. ");
INSERT INTO tsn_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Erile Jesu a bona go dirwa jalo a loga seiteo sa megala, a ba lelekela kwa ntle le dinku le dipelesa, a gasagasa madi a baananyi mo bodilong, a pitikolola ditafole tsa bone! ");
INSERT INTO tsn_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Hong ya re a ya kwa banneng ba ba rekisang maphoi a ba raya a re, “Ntshang dilo tse fa. Se fetoleng Ntlo ya ga Rre ntlo ya marekisetso!” ");
INSERT INTO tsn_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Mme barutwa ba gagwe ba gakologelwa seporofeto se se mo dikwalong se se reng, “Tlhoafalelo ya ntlo ya Modimo e tlaa nna tirololo ya me.” ");
INSERT INTO tsn_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mme baeteledipele ba Sejuta ba mmotsa ba re, “O tsaya kae tetlelelo ya go ba lelekela kwa ntle? Fa e le gore tetlelelo e o e newa ke Modimo, re bontshe kgakgamatso e e go supelang.” ");
INSERT INTO tsn_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesu a fetola a re, “Go siame se ke kgakgamatso e ke tlaa e lo direlang: Senyang kago e mme e tlaa re mo malatsing a le mararo ke e tsose!” ");
INSERT INTO tsn_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ba gakgamala ba re, “Wa reng! go tsere dingwaga di le masome a mane le borataro go aga Tempele e, mme wena wa re o ka e aga mo malatsing a le mararo?” ");
INSERT INTO tsn_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mme ka “Kago e” o ne a raya mmele wa gagwe. ");
INSERT INTO tsn_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Erile a sena go rula, barutwa ba gakologelwa fa a kile a bua jalo mme ba lemoga gore se a neng a se bua o ne a se ntsha mo dikwalong, se ne se raya ene ka sebele, le gore gotlhe go diragetse ka boammaaruri! ");
INSERT INTO tsn_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ka ntlha ya dikgakgamatso tse a di dirileng kwa Jerusalema go le moletlo wa Tlolaganyo, batho ba le bantsi ba dumela gore e ne e le ene Mesia tota. ");
INSERT INTO tsn_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Mme Jesu a seka a ba ikanya ka gore o ne a itse motho le tlhaloganyo ya gagwe. O ne a sa tlhoke gore le fa e le mang o ka mmolelela gore tlholego ya motho e fetoga fetoga jang! ");
INSERT INTO tsn_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Mme ya re bosigo bongwe morago ga lotlatlana, moeteledipele wa tumelo ya Sejuta yo o bidiwang Nikodemo, wa leloko la phuthego ya Bafarasai, a tla go kopa Jesu thuso. A re, “Rra, rotlhe re itse gore Modimo o go romile go tla go re ruta. Dikgakgamatso tsa gago di supa ka botlalo gore o romilwe ke Modimo.” ");
INSERT INTO tsn_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Mme Jesu a fetola a re, “Ka tlhoafalo yotlhe e ke nang nayo ke go bolelela se: fa o sa tsalwe sesha, ga o kake wa tsena mo Bogosing jwa Modimo.” ");
INSERT INTO tsn_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Mme Nikodemo a gakgamala a re, “Ke tsalwe gape! O rayang? Motho e ka re e le mogolo o ka boela jang mo sebopelong sa ga mmaagwe gore a tsalwe gape?” ");
INSERT INTO tsn_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Mme Jesu a fetola a re, “Se ke se go bolelelang ka tlhoafalo ke se: kwa ntle ga gore motho a tsalwe ka metsi le ka mowa ga a ka ke a tsena mo Bogosing jwa Modimo. ");
INSERT INTO tsn_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Batho ba ka tsala batho ba bangwe fela, mme Mowa O O Boitshepo o naya botshelo jo bosha jo bo tswang legodimong. ");
INSERT INTO tsn_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Jalo he, o se gakgamalele go bua ga me fa ke re o tshwanetse go tsalwa gape! ");
INSERT INTO tsn_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Fela jaaka o ka utlwa phefo mme o ka seka wa bolela kwa e tswang teng kgotsa kwa e tlaa fokelang teng gape, Mowa o ntse fela jalo. Ga re itse gore o tlaa neela mang botshelo jo, jo bo tswang legodimong.” ");
INSERT INTO tsn_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Mme Nikodemo a mmotsa a re, “O rayang?” ");
INSERT INTO tsn_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","11","Mme Jesu a fetola a re, “O moruti wa Bajuta yo o tlotlegang, mme a ga o ise o tlhaloganye dilo tse? Ke go bolelela se ke se itseng e bile ke se bonye, mme le fa go ntse jalo ga o ise o ntumele. ");
INSERT INTO tsn_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mme fa o sa ntumele fa ke go bolelela ka ga dilo tse di diragalang fano mo bathong, o ka dumela jang fa ke go bolelela ka tse di diragalang kwa legodimong? ");
INSERT INTO tsn_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Gonne ke nna fela, Morwa Motho, yo ke tsileng mo lefatsheng mme ke tlaa boela kwa legodimong gape. ");
INSERT INTO tsn_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Mme fela jaaka Moshe a ne a tsholetsa setshwantsho sa noga ya kgotlho mo mopakong, le nna ke tshwanetse go tsholediwa fela jalo mo mopakong. ");
INSERT INTO tsn_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Gore le fa e le mang yo o dumelang mo go nna a tle a bone botshelo jo bo sa khutleng. ");
INSERT INTO tsn_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Gonne Modimo o ratile lefatshe mo go kalokalo mo o neng wa ntsha Morwa One a le esi gore le fa e le mang yo o dumelang mo go ene a seka a nyelela mme a bone botshelo jo bo sa khutleng. ");
INSERT INTO tsn_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Modimo ga o wa ka wa romela Morwa One go atlhola lefatshe, fa e se go le boloka. ");
INSERT INTO tsn_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Ga go na tshekiso ya bosakhutleng e e emetseng ba ba mo ikanyang go ba boloka. Mme ba ba sa mo ikanyeng ba setse ba sekisitswe ebile ba atlhotswe ka ntlha ya go sa dumeleng mo go morwa Modimo yo o esi. ");
INSERT INTO tsn_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Katlholo ya bone e itsetsepetse mo boammaaruring jo: gore Lesedi le le tswang kwa legodimong le tsile mo lefatsheng, mme ba rata lefifi go gaisa Lesedi, gonne ditiro tsa bone di ne di le bosula. ");
INSERT INTO tsn_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ba ila Lesedi la legodimo gonne ba ne ba batla go leofa mo lefifing. Ba nna kgakala le Lesedi leo gonne ba ne ba tshaba gore dibe tsa bone di tlaa bewa mo pontsheng, mme ba otlhaiwe. ");
INSERT INTO tsn_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mme ba ba dirang tshiamo, ba tla ka boitumelo mo Leseding gore mongwe le mongwe a bone gore ba dira se Modimo o batlang ba se dira.” ");
INSERT INTO tsn_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Erile morago, Jesu le barutwa ba gagwe ba tswa mo Jerusalema mme ba nna ka lobakanyana mo Judea ba kolobetsa teng. ");
INSERT INTO tsn_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Ka nako e, Johane wa Mokolobetsi o ne a ise a tsenngwe mo kgolegelong. O ne a kolobetsa kwa Ainona gaufi le Salema, gonne go ne go na le metsi a mantsi teng. ");
INSERT INTO tsn_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Letsatsi lengwe mongwe a simolola go ngangisa barutwa ba ga Johane a ba bolelela gore kolobetso ya ga Jesu ke yone fela e e botoka. ");
INSERT INTO tsn_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Hong ba tla kwa go Johane ba mo raya ba re, “Rra, monna yo o neng o na nae ka kwa moseja ga Noka ya Jorodane, yo o neng wa re ke Mesia, le ene o a kolobetsa, mme mongwe le mongwe o ya teng mo boemong jwa go tla kwano go rona.” ");
INSERT INTO tsn_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Johane a fetola a re, “Modimo kwa legodimong o tlhoma tiro ya mongwe le mongwe. ");
INSERT INTO tsn_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Tiro ya me ke go betlela monna yoo tsela gore mongwe le mongwe a tle a ye kwa go ene. Le lona tota lo itse ka fa ke lo boleletseng sentle ka teng gore ga ke Mesia. Ke fano go mmaakanyetsa tsela, ke gone gotlhe. ");
INSERT INTO tsn_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ka tlwaelo bontsintsi bo ya kwa go se se gapang maikutlo, monyadiwa o ya kwa monyadi o teng! Ditsala tsa monyadi di itumela nae. Ke tsala ya monyadi, mme ke tletse boitumelo mo tswelelong pele ya gagwe. ");
INSERT INTO tsn_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","O tshwanetse go tlotlega thata, mme nna ke tshwanetse go ngotlafala thata. ");
INSERT INTO tsn_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","O tswa legodimong ebile o mogolo mo go mongwe le mongwe. Nna ke wa lefatshe, mme tlhaloganyo ya me e lekaganyeditswe mo dilong tsa lefatshe fela. ");
INSERT INTO tsn_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","O bolela se a se bonyeng le se a se utlwileng, mme ke ba se kae fela ba ba dumelang se a se ba bolelelang! ");
INSERT INTO tsn_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","34","“Ba ba mo dumelang ba bona gore Modimo ke motswedi wa boammaaruri. Gonne yo, yo o romilweng ke Modimo, ebile o bua mafoko a Modimo, gonne Mowa wa Modimo o mo go ene mo go senang selekanyo. ");
INSERT INTO tsn_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Rara o rata monna yo gonne ke Morwae, mme Modimo o mo neile sengwe le sengwe se se leng teng. ");
INSERT INTO tsn_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mme botlhe ba ba dumelang Morwa Modimo go ba boloka, ba na le botshelo jo bo sa khutleng; ba ba sa mo dumeleng ebile ba sa mo reetse ga ba kitla ba bona legodimo, mme bogale jwa Modimo bo ntse mo go bone.” ");
INSERT INTO tsn_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Erile Morena a itse gore Bafarasai ba utlwile kaga bontsintsi jo bo yang kwa go ene go na le kwa go Johane go kolobediwa le go nna barutwa ba gagwe (ntswa Jesu ene ka boene a ne a sa ba kolobetse, go ne go kolobetsa barutwa ba gagwe). ");
INSERT INTO tsn_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","A tswa mo Judea mme a boela kwa kgaolong ya Galalea. ");
INSERT INTO tsn_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mme a tshwanelwa ke go ralala Samaria a le mo tseleng. ");
INSERT INTO tsn_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","Mme erile motshegare wa sethoboloko, fa a atamela motse wa Sikara, a goroga fa Sedibeng sa ga Jakobe se se neng se le mo setsheng sa lefatshe se Jakobe a neng a se neile morwawe Josefe. Jesu o ne a lapisitswe ke go tsamaya mo mogoteng wa letsatsi sekgala se se leele, hong a nna fa thoko ga sediba a lapile thata. ");
INSERT INTO tsn_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mme ka bofefo ga tla mosadi wa Mosamaria a tla go ga metsi, mme Jesu a mo kopa metse a go nwa. ");
INSERT INTO tsn_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","O ne a le nosi ka nako eo, barutwa ba gagwe ba ile kwa motseng go reka dijo. ");
INSERT INTO tsn_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mosadi a gakgamala gore a Mojuta o ka kopa “Mosamaria yo o nyatsegang” sengwe, ka tlwaelo ba ne ba sa buisanye! Mme a bua kaga selo se le Jesu. ");
INSERT INTO tsn_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Mme Jesu a fetola a re, “Fa o ne o itsile gore Modimo o go tsholetse neo e e gakgamatsang jang, le gore ke nna mang, o kabo o nkopile metse a botshelo!” ");
INSERT INTO tsn_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mme mosadi a re, “Ga o na segelelo, le gone sediba se se boteng thata! O ne o tlaa tsaya kae metse a botshelo? ");
INSERT INTO tsn_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kwa ntle ga moo, a o mogolo mo go rraarona mogolwagolwane Jakobe? O ka mpha metse a a botoka jang go na le a Jakobe le bo morwawe le dikgomo tsa bone di a noleng ka boitumelo?” ");
INSERT INTO tsn_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesu a fetola a re, “Batho ba tshwarwa ke lenyora ka bofefo fa ba sena go nwa metsi a. A ke a ba nayang, a nna motswedi wa bosakhutleng mo go bone. ");
INSERT INTO tsn_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Mme metsi a. A ke a motswedi o o ba nose-tsang ka metlha ka botshelo jo bo sa khutleng.” ");
INSERT INTO tsn_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mme mosadi a mo raya a re, “Tswee-tswee rra, nnosa metsi ao! Hong ga ke na go tlhola ke nyorwa gape, le fa e le go tsamaya mosepele o moleele o wa go tla go ga metse fano malatsi otlhe.” ");
INSERT INTO tsn_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Mme Jesu a mo raya a re, “Tsamaya o ye go tla le monna wa gago.” ");
INSERT INTO tsn_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","Mme mosadi a mo fetola a re, “Kana ga ke a nyalwa.” Jesu a re, “O bua boammaaruri Ka gore o kile wa nna le banna ba le batlhano, mme monna yo o nnang le ene gompieno jaana ga a go nyala.” ");
INSERT INTO tsn_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mme mosadi a mo raya a re, “Rra, o tshwa-netse wa bo o le moporofiti. ");
INSERT INTO tsn_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Mme he, mpolelela, ke eng fa lona Bajuta lo re Jerusalema ke lone fela lefelo la kobamelo-Modimo, fa rona Basamaria re re ke fano mo Thabeng ya Gerasime kwa borraa-rona mogolwagolwane ba neng ba obamela teng?” ");
INSERT INTO tsn_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","24","Jesu a fetola a re, “Nako e e tla, mma, fa re tlaa bong re sa tlhole re tshwenyega ka gore a re obamela Rara fano kgotsa mo Jerusalema. Gonne ga go mo go reng re obamela kae, fa e se gore re obama jang, ebong gore a kobamelo ya rona ke ya semowa le ya boammaaruri? A re na le thuso ya Mowa O O Boitshepo? Gonne Modimo ke Mowa, jalo re tshwanetse go nna le thuso ya one go o obamela jaaka re tshwanetse. Rara o batla one mofuta o wa kobamelo mo go rona. Mme lona Basamaria lo itse go se kae fela kaga gagwe, lo obamela ka bofofu fa rona Bajuta re itse gotlhe kaga gagwe, gonne poloko e tla mo lefatsheng ka Bajuta.” ");
INSERT INTO tsn_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mosadi a re, “Go siame, le fa go ntse jalo ke itse gore Mesia o tlaa tla, yo ba mmitsang Keresete, mme fa a tla o tlaa re tlhalosetsa sengwe le sengwe.” ");
INSERT INTO tsn_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Hong Jesu a mo raya a re, “Ke nna Mesia!” ");
INSERT INTO tsn_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mme erile gone foo fela barutwa ba gagwe ba goroga. Ba gakgamalela go mmona a bua le mosadi, mme le fa e le ope wa bone a se ka a mmotsa gore ke eng. ");
INSERT INTO tsn_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Mme mosadi a tsamaya a tlogela nkgwana ya gagwe ya metsi fa thoko ga sediba a boela kwa motseng mme a feta a bolelela mongwe le mongwe jaana, “Tlang lo bone monna yo o mpoleletseng sengwe le sengwe se ke neng ke tshela ke se dira! A e ka ne e le ene Mesia?” ");
INSERT INTO tsn_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mme batho ba motse ba tla ba tsositse modumo ba ya go mmona. ");
INSERT INTO tsn_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Erile ka lobakanyana fa mosadi a sa ntse a ile go bolelela batho kwa motseng, barutwa ba sala ba leka go kgothaletsa Jesu go ja. ");
INSERT INTO tsn_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mme Jesu a ba fetola a re, “Nnyaa, ke na le dijo tse lo sa itseng kaga tsone.” ");
INSERT INTO tsn_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Mme barutwa ba botsanya ba re, “Yo o di mo lereditseng ke mang?” ");
INSERT INTO tsn_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Mme Jesu a ba tlhalosetsa jaana a re: “Dikotla tsa me di mo go direng go rata ga Modimo o o nthomileng, le mo go fetseng tiro ya One. ");
INSERT INTO tsn_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","A lo gopola gore tiro ya thobo ga e na go simolola go fitlhelela selemo se fela mo dikgweding tse nne go simolola jaanong jaana? Lebang mo tikologong! Masimo a magolo a e leng mewa ya batho, a simolola go butswa mo tikologong yotlhe ya rona, ebile a setse a ka rojwa. ");
INSERT INTO tsn_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Barobi ba tlaa duelwa tuelo e ntle, mme ba tlaa phuthela mewa e e bolokwang mo difalaneng tsa legodimo! Ke boitumelo jo bogolo jang jo bo letileng mojadi le morobi! ");
INSERT INTO tsn_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Gonne ke boammaaruri gore mongwe o a jala mme yo mongwe o a roba. ");
INSERT INTO tsn_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ke lo romile go roba kwa lo sa jalang teng; ba bangwe ba dirile tiro ya bone mme lona lwa amogela thobo.” ");
INSERT INTO tsn_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Batho ba le bantsi ba ba tswang mo motseng wa Samarea, ba dumela gore ke Mesia ka ntlha ya polelo ya mosadi e e reng, “O mpoleletse sengwe le sengwe se ke neng ke aga ke se dira!” ");
INSERT INTO tsn_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","41","Erile ba ya go mmona kwa sedibeng, ba feta ba mo kopa go ya go nna mo motseng wa bone; mme a dira jalo, a nna malatsi a le mabedi, a a neng a lekanye ba le bantsi go dumela mo go ene ba sena go mo utlwa. ");
INSERT INTO tsn_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mme ba raya mosadi ba re, “Jaanong re a dumela gonne re mo ikutlwetse, e seng fela ka ntlha ya se wena o se re boleletseng. Ke ene tota Mmoloki wa lefatshe.” ");
INSERT INTO tsn_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Erile a sena go nna malatsi a mabedi, a ya Galalea fela jaaka a ne a tle a re, “Moporofiti o tlotlega gongwe le gongwe fa e se fela mo lefatsheng la ga gabo!” ");
INSERT INTO tsn_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Mme Bagalalea ba feta ba mo amogela sentle ka diatla tsoo pedi gonne ba ne ba le mo Jerusalema ka moletlo wa Tlolaganyo le gore ba ne ba bonye dikgakgamatso dingwe tsa gagwe. ");
INSERT INTO tsn_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Mo lobakeng lwa loeto lwa gagwe a raletse Galalea, o ne a goroga mo motseng wa Kana kwa a neng a kile a fetola metsi mofine teng. Erile a sale teng koo, monna mongwe mo motseng wa Kaperenama, yo e neng e le kgosana, yo morwawe o neng a lwala thata, a utlwa gore Jesu o boile kwa Judea jaanong o mo Galalea. Monna yo a ya kwa Kana, a fitlhela Jesu, mme a kopa gore a ye le ene kwa Kaperenama go ya go fodisa morwawe yo a neng a le fa gare ga loso le botshelo. ");
INSERT INTO tsn_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Mme Jesu a mmotsa a re, “A ga gona ope wa lona yo o dumelang mo go nna fa e se ke tswelela ka go dira dikgakgamatso?” ");
INSERT INTO tsn_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kgosana ya mo rapela ya re, “Rra, tswee-tswee itlhaganele pele ngwanake o a swa.” ");
INSERT INTO tsn_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Mme Jesu a mo raya a re, “Boela kwa gae. Morwao o fodile!” Mme kgosana ya dumela Jesu ya boela kwa gae. ");
INSERT INTO tsn_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mme ya re fa a sale mo tseleng, bangwe ba batlhanka ba gagwe ba mo rakantsha ka mafoko a a reng sengwe le sengwe se siame, morwao o namologile mo bolwetseng. ");
INSERT INTO tsn_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","A ba botsa gore mosimanyana o sale a simolola go ikutlwa botoka leng? Mme ba mo fetola ba re, “Erile maabane mo tshokologong nako e ka nna ya bongwe, letshoroma la gagwe la bo le nyelela!” ");
INSERT INTO tsn_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Hong rraagwe a lemoga gore e ne e le ka lone lobaka lo Jesu a neng a mo raya a re, “Morwao o fodile.” Mme Kgosana le bantlo ya gagwe ba dumela gore Jesu ke Mesia. ");
INSERT INTO tsn_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Se e ne e le kgakgamatso ya bobedi mo Ga-lalea morago ga go boa ga ga Jesu kwa Judea. ");
INSERT INTO tsn_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mme erile morago ga mo o Jesu a boela kwa Jerusalema ka ntlha ya letsatsi lengwe la malatsi a boikhutso a tumelo ya Sejuta. ");
INSERT INTO tsn_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Mo mo-tseng, gaufi le kgoro ya dinku go ne go na le Lekadiba ja Betheseda le na le maobo a le matlhano. ");
INSERT INTO tsn_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Bontsintsi jwa batho ba ba lwalang, ba ba tlho-tsang, ba ba foufetseng, kgotsa ba ba suleng mefama ba ne ba ntse mo maobong ba letetse go fetlhega ga metsi, ");
INSERT INTO tsn_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","gonne moengele wa Morena o ne a tle a tle go fetlha metsi, mme motho wa ntlha go tlolela mo teng o ne a fodisiwa. ");
INSERT INTO tsn_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mongwe wa banna ba ba neng ba namaletse gone foo, o ne a sa bolo go lwala mo dingwageng di le masome mararo le bofera bobedi. ");
INSERT INTO tsn_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Erile fa Jesu a mmona ebile a itse lobaka lo a saleng a lwala ka lone a mmotsa a re, “A o batla go fola?” ");
INSERT INTO tsn_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mme monna yo o lwalang a re, “Ga ke kgone, ka gore ga ke na ope yo o ntsenyang mo lekadibeng ka nako ya phetlho ya metsi, e a re fa ke sa ntse ke leka go tlolela mo teng, mongwe a bo a nthaka.” ");
INSERT INTO tsn_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Mme Jesu a mo raya a re, “Nanoga, phutha phate ya gago o ye gae!” ");
INSERT INTO tsn_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ka bonako monna a fola! A phutha phate a simolola go tsamaya! Mme go ne go le letsatsi la Sabata fa kgakgamatso e e diragala. Mme baeteledipele ba Sejuta ba nna kgatlhanong le tiro eo. ");
INSERT INTO tsn_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ba raya monna yo o fodisitsweng ba re, “Ga o a tshwanela go dira ka letsatsi la Sabata! Ga go kafa molaong go tshola phate eo!” ");
INSERT INTO tsn_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Mme ene a ba fetola a re, “Monna yo o mphodisitseng o rile ke e tsee.” ");
INSERT INTO tsn_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ba mmotsa ba re, “Yo o neng a bua selo se se ntseng jalo ke mang?” ");
INSERT INTO tsn_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Monna yo o fodisitsweng a bo a sa itse gore ke mang, gonne Jesu o ne a nyeletse mo bontsintsing jwa batho. ");
INSERT INTO tsn_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mme erile kwa morago Jesu a mmona mo Tempeleng mme a mo raya a re, “Jaanong o fodile; o se ka wa tlhola o leofa gape, ka gore fa o ka leofa e ka re kgotsa wa diragalelwa ke se se bosula bogolo!” ");
INSERT INTO tsn_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mme monna yo o fodisitsweng a ya go senka baeteledipele ba Sejuta mme a ba bolelela gore o fodisitswe ke Jesu. ");
INSERT INTO tsn_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mme ba simolola go gagautlha Jesu ba mo raya ba re ke motlola melao ya Sabata. ");
INSERT INTO tsn_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Mme Jesu a fetola a re, “Rre o tsweletse pele ka go dira tshiamo, mme le nna ke dira jaaka ene.” ");
INSERT INTO tsn_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mme baeteledipele ba Sejuta ba gakala thata ba batla go mmolaya gonne mo godimo ga go tlola melao ya Sabata, o ne a re Modimo ke rraagwe, ka go bua jalo a itekanya le Modimo. ");
INSERT INTO tsn_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Mme Jesu a fetola a re, “Ga go na sepe se Morwa a ka se dirang ka boene. O dira fela se a bonang Rara a se dira, ka tsela e e tshwanang. ");
INSERT INTO tsn_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Gonne Rara o rata Morwa, o mmolelela sengwe le sengwe se a se dirang; mme Morwa o tlaa dira dikgakgamatso tse dikgolo go feta phodiso ya monna yo! ");
INSERT INTO tsn_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ebile o tlaa tsosa mo baswing mongwe fela yo ene a batlang go mo tsosa, fela jaaka Rara a dira. ");
INSERT INTO tsn_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mme Rara o neetse Morwa katlholo yotlhe; ya sebe ");
INSERT INTO tsn_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","gore mongwe le mongwe a tle a tlotle Morwa, fela jaaka ba tlotla Rara. Mme fa lo gana go tlotla Morwa Modimo, yo o mo romileng kwa go lona, hong ga lo tlotle Rara gotlhelele. ");
INSERT INTO tsn_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ke bua ke gatelela gore mongwe yo o reetsang molaetsa wa me a bo a dumela mo Modimong o o nthomileng, o na le botshelo jo bo sa khutleng, mme ga a na go sekisiwa ka ntlha ya dibe tsa gagwe, gonne o setse a dule mo losong a tsenye mo botshelong. ");
INSERT INTO tsn_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mme ke bua ka tlhoafalo ke re, ‘Lobaka lo e tla, tota legale lo setse lo fitlhile, fa baswi ba tlaa utlwang lentswe la me, lentswe la Morwa Modimo, mme ba ba reetsang ba tlaa tshela.’ ");
INSERT INTO tsn_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Rara ka esi o na le botshelo, jalo he o neetse Morwawe botshelo joo gore bo nne mo go ene ka esi, ");
INSERT INTO tsn_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","le go atlhola dibe tsa batho botlhe gonne ke Morwa Modimo. ");
INSERT INTO tsn_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Se gakgamaleng! Ruri lobaka lo e tla lo baswi botlhe mo mabitleng a bone ba tlaa utlwang lentswe la Morwa Modimo, ");
INSERT INTO tsn_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","mme ba ba dirileng tshiamo ba tlaa tsoga gape go ya botshelong jo bo sa khutleng; mme ba ba neng ba tsweletse mo bosuleng, ba tlaa bo ba tsogela katlholong. ");
INSERT INTO tsn_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mme ga ke dire katlholo epe ke sa rerisa Rara. Ke atlhola jaaka ke laetswe. Mme katlholo ya me e siame ebile e tlhamaletse gonne e ka fa go rateng ga Modimo o o nthomileng, ga se ya me fela. ");
INSERT INTO tsn_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Fa ke bua ka bo nna, ga ke dumelwe. ");
INSERT INTO tsn_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","33","“Mme mongwe, ebong Johane wa Mokolobetsi, le ene o bua ka ga me. Lo ne lwa tswa lwa ya go reetsa thero ya gagwe, mme ke lo tlhomamisetsa gore mo a go buang ka ga me ke boammaaruri! ");
INSERT INTO tsn_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mme bosupi jwa boammaaruri jo ke nang nang najo, ga bo tswe mo mothong, lo gakolotswe ka bosupi jwa ga Johane gore lo tle lo dumele mo go nna lo bolokwe. ");
INSERT INTO tsn_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Johane o ne a phatsima sentle ka lobakanyana, mme go ne ga lo solegela molemo lwa itumela, ");
INSERT INTO tsn_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","mme Nna ke na le mosupi yo mogolo go feta Johane. Ke raya dikgakgamatso tse ke di dirang; ke di neetswe ke Rara, mme di supa gore Rara o nthomile. ");
INSERT INTO tsn_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Mme Rara le ene o supile ka ga me, le fa a sa lo itshupegetsa ka sebele, kgotsa a bua le lona lo lebaganye mo matlhong. ");
INSERT INTO tsn_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","“Mme ga lo mo reetse, gonne lo gana go ntumela, nna yo ke romilweng kwa go lona ka molaetsa wa Modimo. ");
INSERT INTO tsn_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Lo phuruphutsa dikwalo tsa tumelo, gonne lo dumela gore di lo naya botshelo jo bo sa khutleng. Mme dikwalo di raya nna! ");
INSERT INTO tsn_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","“Mme ga lo tle kwa go nna gore ke lo neye botshelo jo jo bo sa khutleng! ");
INSERT INTO tsn_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","Go rata kgotsa go sa rateng ga lona ga go reye sepe mo go nna gonne jaaka ke itse sentle, ga go na lorato lwa Modimo mo go lona. ");
INSERT INTO tsn_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ke a itse, gonne ke tsile kwa go lona ke emetse Rre mme lo gana go nkamogela, le fa go ntse jalo lo ipaakanyeditse go amogela ba ba sa rongwang ke ene, mme ba ikemetse ka bo bone! ");
INSERT INTO tsn_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ga go hakgametse fa lo sa dumele! Gonne lo tlotlana ka boitumelo, mme ga lo na sepe ka ga tlotlo e e tswang Modimong o o osi! ");
INSERT INTO tsn_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Mme ga se nna yo ke tlaa lo bayang molato ka ga selo se kwa go Rara; ke Moshe yo o tlaa dirang jalo! Moshe, yo mo melaong ya gagwe lo tlhomileng ditsholofelo tsa lona tsa legodimo. ");
INSERT INTO tsn_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","“Gonne lo ganne go dumela Moshe. O kwadile ka ga me, mme lo gana go mo dumela, jalo he, le nna lo gana go ntumela. ");
INSERT INTO tsn_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mme ka lo sa dumele se a se kwadileng, ga go hakgamatse fa le nna lo sa ntumele.” ");
INSERT INTO tsn_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Morago ga mo, Jesu a kgabaganya Lewatle la Galalea, le le itsegeng gape ka leina la Tiberia. ");
INSERT INTO tsn_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","5","Mme bontsi jo bogolo jwa batho, jo bontsi jwa bone e neng e le batsamai ba ya Jerusalema kwa moletlong wa Tlolaganyo, ba bo ba mo setse mo-rago gongwe le gongwe kwa a yang teng, go mmona a fodisa balwetse. Mme erile Jesu a sena go tlha-tlogela mo thabeng a nna fa fatshe, barutwa ba gagwe ba mo dikaganyeditse, mme a tloga a bona bontsi jo bogolo jwa batho bo tlhatloga thaba bo mo senka. Hong a retologela kwa go Filipo a mo raya a re, “Filipo, re ka reka senkgwe kae go fa batho ba botlhe?” ");
INSERT INTO tsn_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(O ne a leka Filipo, gonne o ne a setse a itse se a neng a ya go se dira). ");
INSERT INTO tsn_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo a fetola a re, “Go tlaa lopa madi a mantsi thata go simolola go dira jalo!” ");
INSERT INTO tsn_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Mme Anderea, monnaa Simone Petoro, a bua a re, “Go na le mosimanyana fano yo o tshotseng dinkgwe tsa korong di le tlhano le ditlhapi di le pedi! Mme go ka thusang fa batho ba le bantsi jaana?” ");
INSERT INTO tsn_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Mme Jesu a ba raya a re, “Rayang mongwe le mongwe a nne fa fatshe,” mme botlhe fela ba nna fa fatshe mo bojannye, mme palo ya banna ba le bosi e ne e ka nna dikete di le tlhano. ");
INSERT INTO tsn_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Hong Jesu a tsaya dinkgwe, a di lebogela, a di naya batho. Morago ga moo a dira fela jalo ka ditlhapi. Mme mongwe le mongwe a ja a kgora! ");
INSERT INTO tsn_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mme Jesu a ba raya a re, “Kokoanyang masalela, gore le fa e le sepe se seka sa latlhwa.” ");
INSERT INTO tsn_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mme diroto di le lesome le bobedi tsa tlala masalela ao! ");
INSERT INTO tsn_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Erile fa batho ba lemoga kgakgamatso e tona tona eo e e diragetseng, ba bua ka kgakgamalo ba re, “Ammaaruri, ke mopopofiti yo re ntseng re mo solofetse!” ");
INSERT INTO tsn_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Mme erile ka go bua jalo, Jesu a bona gore ba ipaakanyeditse go mo tsaya ka pateletso go mo dira kgosi ya bone, hong a tlhatlogela kwa godimo mo dithabeng a le nosi. ");
INSERT INTO tsn_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mo maabanyaneng ao barutwa ba gagwe ba fologela kwa lotshitshing go mo emela teng. ");
INSERT INTO tsn_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Mme erile go nna lefifi Jesu a ise a tle, ba tsena mo mokorong ba kgabaganya lewatle go ya Kaperenama. ");
INSERT INTO tsn_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","19","Mme ka bofefo ga tsoga phefo e kgolo thata mo lewatleng, ya ba tsubutletsa le mokoro o ba neng ba o kgweetsa, le lewatle la rwalelesega. Mme le fa go ntse jalo, erile ba ka ne ba tsamaile bommaele ba le bararo kgotsa ba le bane, ka tshoganetso ba bona Jesu a tsamaela ntlheng ya mokoro! Mme ba tshoga thata, ");
INSERT INTO tsn_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","mme a ba bitsa a re se boifeng. ");
INSERT INTO tsn_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Mme ba eletsa go mo tseela mo teng, mme ka bofefo mokoro wa goroga kwa ba neng ba ya teng! ");
INSERT INTO tsn_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Mme ya re mo mosong o o latelang, morago ga ba kgabaganya lecha, bontsintsi jwa batho jwa simolola go phuthaganela mo lotshitshing (bo emetse go bona Jesu). Gonne ba ne ba itse gore barutwa ba ne ba tsamaile ka mokoro wa bone ba mo tlogela kwa morago. Mekoro e mennye e le mentsinyana e e tswang kwa Tiberia e ne e le gautshwane, ");
INSERT INTO tsn_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","mme erile batho ba bona gore Jesu o ne a seyo foo, le fa e le barutwa ba gagwe, ba tsena mo mekorong ba kgabaganyetsa kwa Kaperenama go ya go mo senka teng. ");
INSERT INTO tsn_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Erile fa ba goroga ba mmona ba re, “Morena o tsile fano jang?” ");
INSERT INTO tsn_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesu a ba fetola a ba raya a re, “Boammaaruri jwa potso ya lona ke gore lo batla go nna le nna gonne ke lo file dijo, e seng ka ntlha ya gore lo dumela mo go nna. ");
INSERT INTO tsn_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Jalo he, ga lo a tshwanela go baya mo dilong tse di nyelelang jaaka dijo. Nnyaa, dirisang nonofo ya lona ka go batla botshelo jo bo sa khutleng jo nna Morwa Motho ke ka bo lo nayang. Gonne Modimo Rara o nthomile gone go dira jalo.” ");
INSERT INTO tsn_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mme ba mo fetola ba re, “Re tshwanetse go dira eng go itumedisa Modimo?” ");
INSERT INTO tsn_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesu a ba raya a re, “Go rata ga Modimo ke gore lo dumele mo go yo o mo romileng.” ");
INSERT INTO tsn_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Ba fetola ba re, “O tshwanetse go re bontsha dikgakgamatso tse dingwe fa o batla gore re dumele gore o Mesia. Re fe dijo mahala malatsi otlhe, jaaka borraa rona ba ne ba di fiwa fa ba tsamaya ba raletse sekaka! Fela jaaka dikwalo di re, ‘Moshe o ba neetse senkgwe se se tswang legodimong’.” ");
INSERT INTO tsn_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesu a ba raya a re, “Moshe ga a ise a ke a se ba neele. Rre ke ene yo a neng a se ba naya. Mme jaanong o lo fa senkgwe sa boammaaruri se se tswang legodimong. ");
INSERT INTO tsn_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Senkgwe sa boammaaruri ke Motho, yo o romilweng ke Modimo a tswa legodimong, mme ene o neela lefatshe botshelo.” ");
INSERT INTO tsn_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Mme ba mo raya ba re, “Morena, re nnele senkgwe se mo matshelong a rona malatsi otlhe!” ");
INSERT INTO tsn_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Mme Jesu a re, “Ke nna Senkgwe sa Botshelo. Ga go na ope yo o tlang kwa go nna yo o tlaa tlholang a bolawa ke tlala gape. Ba ba dumelang mo go nna ga ba kitla ba tlhola ba nyorwa. ");
INSERT INTO tsn_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mme molato fela ke gore, jaaka ke lo boleletse pele, ga lo dumele le fa tota lo mponye. ");
INSERT INTO tsn_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mme bangwe ba Rara a ba nneileng ba tlaa tla kwa go nna mme ga nkitla ke ba gana. ");
INSERT INTO tsn_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Gonne ke tsile fano ke tswa legodimong go tla go dira go rata ga Modimo o o nthomileng, e seng go rata ga me. ");
INSERT INTO tsn_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Mme mo ke go rata ga Modimo go re, ‘Ke seka ka latlhegelwa le fa e le ke a le mongwe fela mo go botlhe ba o ba nneileng, mme e leng gore ke ba tsosetse botshelong jo bo sa khutleng ka Letsatsi la Bofelo.’ ");
INSERT INTO tsn_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Gonne ke go rata ga ga Rre gore mongwe le mongwe yo o bonang Morwawe a ba a dumela mo go ene o tshwanetse go nna le botshelo jo bo sa khutleng, gore ke tle ke mo tsose ka Letsatsi la Bofelo.” ");
INSERT INTO tsn_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Hong Bajuta ba simolola go mo ngongoregela, gonne a re ke Senkgwe se se tswang legodimong. ");
INSERT INTO tsn_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ba hakgamala ba re, “A reng? Gonne re mo itse e le Jesu fela, morwa Josefa yo rraagwe le mmaagwe re ba itseng. O rayang fa a re o fologile kwa legodimong?” ");
INSERT INTO tsn_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Mme Jesu a fetola a re, “Se ngongoregeng ka ntlha ya go bua ga me jalo. ");
INSERT INTO tsn_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Gonne ga go ope yo o ka tlang kwa go nna fa e se Rara yo o nthomileng a mo gogela kwa go nna, mme ka Letsatsi la Bofelo ke tlaa mo tsosa. ");
INSERT INTO tsn_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Jaaka go kwadilwe mo Dikwalong, ‘Botlhe ba tlaa rutwa ke Modimo.’ Ba Rara o buang nabo, ba ba ithutang boammaaruri mo go ene, ba tlaa tla kwa go nna. ");
INSERT INTO tsn_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","(Ga go ope yo o bonyeng Rara, ke nna fela yo ke mmonyeng). ");
INSERT INTO tsn_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Ke bua ka go gatelela ke re, le fa e le mang yo o dumelang mo go nna o setse a na le botshelo jo bo sa khutleng! ");
INSERT INTO tsn_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ee, ke senkgwe sa botshelo. ");
INSERT INTO tsn_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Go ne go sena botshelo bope mo senkgweng se, se se neng se tswa mo loaping, se se neng sa neelwa borraeno mo sekakeng, gonne botlhe ba ne ba a swa. ");
INSERT INTO tsn_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","51","Mme go na le senkgwe tota se se tswang legodimong se se nayang mongwe le mongwe yo o se jang botshelo jo bo sa khutleng. Mme ke sone senkgwe seo se se tshelang se se fologileng kwa Legodimong. Le fa e le mang yo o jang senkgwe se o tlaa tshelela ruri; mmele wa me ke sone senkgwe se, se ntsheditswe go golola batho.” ");
INSERT INTO tsn_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Hong Bajuta ba simolola go ganetsanya kaga se a se rayang. Ba re, “Monna yo o ka re naya nama ya gagwe gore re e je?” ");
INSERT INTO tsn_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Hong Jesu a ipoeletsa a re, “Ka tlhomamiso yotlhe e ke nang nayo ke lo raya, ke re: fa lo sa je nama ya Morwa Motho lo bo lo nwa madi a gagwe, ga lo ka ke lwa nna le botshelo jo bo sa khutleng mo go lona. ");
INSERT INTO tsn_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mme le fa e le mang yo o jang nama ya me a ba a a nwa le madi a me, o na le botshelo jo bo sa khutleng, mme ke tlaa mo tsosa ka Letsatsi la Bofelo. ");
INSERT INTO tsn_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Gonne nama ya me ke dijo tsa boammaaruri, le madi ke seno sa boammaaruri. ");
INSERT INTO tsn_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","“Mongwe le mongwe yo o jang nama ya me a ba a a nwa madi a me o mo go nna, le nna ke mo go ene. ");
INSERT INTO tsn_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ke tshela ka nonofo ya ga Rara yo o tshelang yo o nthomileng, mme fela jalo ba ba njang le bone ba tlaa tshela ka ntlha ya me! ");
INSERT INTO tsn_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ke Senkgwe sa boammaaruri se se tswang legodimong; mme le fa e le mang yo o jang Senkgwe se, o tlaa tshelela ruri, a sa swe jaaka borraeno ba ne ba a swa, le fa ba ne ba jele senkgwe se se tswang legodimong.” ");
INSERT INTO tsn_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","(A rera thero e mo ntlung ya thuto mo Kaperenama). ");
INSERT INTO tsn_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Le barutwa ba gagwe tota ba re, “Golo mo go thata go tlhaloganngwa. Ke mang yo o ka thalosang se a se rayang?” ");
INSERT INTO tsn_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesu a itse mo pelong ya gagwe gore barutwa ba gagwe ba ne ba ngongorega mme a ba raya a re, “A golo mo go a lo kgopisa? ");
INSERT INTO tsn_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mme lo tlaa akanya eng fa lo mpona, Morwa Motho, ke boela kwa legodimong gape? ");
INSERT INTO tsn_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mowa O O Boitshepo ke one fela o o nayang botshelo jo bo sa khutleng. Ba ba tsetsweng gangwe fela ka tsalo ya senama, ga ba kitla ba amogela mpho e. Mme jaanong ke lo boleletse ka fa lo ka nnang le botshelo jo jwa semowa ka teng. ");
INSERT INTO tsn_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mme bangwe ba lona ga ba ntumele.” (Gonne Jesu o ne a sale a itse kwa tshimologong ba ba neng ba sa dumele le yo o tlaa mo okang). ");
INSERT INTO tsn_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Mme a re, “Ke sone se ke neng ke se raya fa ke re ga go na ope yo o ka tlang kwa go nna fa e se Rara a mo lere kwa go nna.” ");
INSERT INTO tsn_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Erile fela gone foo barutwa ba gagwe ba le bantsintsi ba mo furalela ba mo tlogela. ");
INSERT INTO tsn_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mme Jesu a retologela kwa go ba ba lesome le bobedi a ba botsa a re, “A le lona lo a tsamaya?” ");
INSERT INTO tsn_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Mme Simone Petoro a fetola a re, “Morena, re ka ya kwa go mang? Ke wena fela o le esi yo o nang le mafoko a a nayang botshelo jo bosakhutleng, ");
INSERT INTO tsn_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","jalo he re a dumela ebile re itse gore o Morwa Modimo o o boitshepo.” ");
INSERT INTO tsn_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Hong Jesu a re, “Ke tlhophile ba le lesome le bobedi ba lona, mme a le esi ke diabolo.” ");
INSERT INTO tsn_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(O ne a bua ka ga Judase, Morwa Simone Isekariota, mongwe wa ba ba lesome le bobedi, yo o tlaa mo okang). ");
INSERT INTO tsn_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Erile morago ga mo, Jesu a ya Galalea, a tsena motse le motsana gonne o ne a batla go nna ka kwa ntle ga Judea kwa Bajuta ba neng ba mo logela leano la go mmolaya teng. ");
INSERT INTO tsn_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mme jaana ya bo e le lobaka lwa Mediro ya Metlaagana letsatsi lengwe la ngwaga la boitapoloso la Sejuta. ");
INSERT INTO tsn_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Mme bomonnaa Jesu ba mo tlhotlheletsa gore a ye kwa Judea kwa medirong. Ba mo raya ka tshotlo ba re, “Ya kwa batho ba bantsi ba ka bonang dikgakgamatso tsa gago gone! ");
INSERT INTO tsn_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ga o ka ke wa tuma fa o iphitlha jaana! Fa o le mogolo jaana, itshupegetse lefatshe!” ");
INSERT INTO tsn_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Gonne le bomonnawe ba ne ba sa dumele mo go ene. ");
INSERT INTO tsn_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesu a fetola a re, “Ga e ise e nne nako e e ntshwanetseng gore ke ye teng. Mme lona lo ka nna lwa tsamaya nako nngwe fela ga go na go dira pharologanyo epe mo go lona. ");
INSERT INTO tsn_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Gonne lefatshe ga le ka ke la lo ila; mme nna le a nkila gonne ke le bona molato kaga sebe le bosula. ");
INSERT INTO tsn_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Lona tsamayang, ke tlaa tla kwa morago fa nako e setse e siame.” ");
INSERT INTO tsn_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jalo a sala mo Galalea. ");
INSERT INTO tsn_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Mme erile bomonnawe ba sena go ya moletlong, le ene a tsamaya, le fa go ntse jalo a ngwangwaela a sa bonwe ke ope. ");
INSERT INTO tsn_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Baeteledipele ba Sejuta ba leka go mo senka kwa moletlong mme ba nna ba botsa gore a ope ga a ise a ke a mmone. ");
INSERT INTO tsn_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Go ne, go na le ditlotlo tse dintsi kaga gagwe mo bathong. Bangwe ba re, “Ke monna yo o gakgamatsang,” fa ba bangwe bone ba ne ba re, “Nnyaa, o timetsa batho.” ");
INSERT INTO tsn_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mme ga bo go sena motho ope yo o neng a na le maikaelelo a go mmuelela mo pontsheng ka ntlha ya go tshaba ipusolosetso ya baeteledipele ba Sejuta. ");
INSERT INTO tsn_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mme erile go setse go le fa gare ga moletlo, Jesu a ya kwa Tempeleng mme a feta a ruta mo pontsheng. ");
INSERT INTO tsn_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Baeteledipele ba Sejuta ba hakgamala fa ba mo utlwa, mme ba botsanya ba re, “Ke eng fa a itse thata jaana mme a ise a ke a tsene dikole tsa rona?” ");
INSERT INTO tsn_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Mme Jesu a ba raya a re, “Ga ke lo rute megopolo ya me, fa e se ya Modimo o o nthomileng. ");
INSERT INTO tsn_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Fa mongwe wa lona a ikaelela go dira go rata ga Modimo ka boammaaruri, hong lo tlaa itse gore a thuto ya me e tswa Modimong kgotsa ke ya me fela. ");
INSERT INTO tsn_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Le fa e le mang yo o ntshang megopolo ya gagwe o a bo a ipuisa a batla go galalediwa, mme yo o batlang go tlotla yo o mo romileng, ke motho yo o siameng yo o boammaaruri. ");
INSERT INTO tsn_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ga go na ope wa lona yo o obamelang melao ya ga Moshe! Jalo ke eng fa lo ntshwaya phoso ka go sa e obameleng? Ke eng fa lo mpolaela go dira jaana?” ");
INSERT INTO tsn_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mme bontsi jwa batho jwa fetola jwa re, “O a tsenwa! Yo o lekang go go bolaya ke mang?” ");
INSERT INTO tsn_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","23","Jesu a fetola a re, “Ke dirile go le Sabata ke fodisa motho, mme lo ne lwa hakgamala. Mme le lona lo dira go le Sabata, fa lo obamela molao wa ga Moshe wa go rupisa (tota, le gale, mokgwa o wa go rupisa o mogologolo go na le molao wa ga Moshe); ka gore fa nako e e siameng ya go rupisa bana ba lona e tla go le Sabata, lo tswelela pele lo rupisa, jaaka lo tshwanetse. Jaanong ke eng fa ke atlholelwa go fodisa motho go le Sabata? ");
INSERT INTO tsn_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Aka-nyang selo se mme lo tlaa bona gore ke bolelela ruri.” ");
INSERT INTO tsn_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bangwe ba batho ba ba neng ba nna koo mo Jerusalema ba buisanya ba re, “A monna yo ga se ene yo ba lekang go mmolaya? ");
INSERT INTO tsn_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mme ke yo fa, o rera mo mpepeneneng, ga ba mo reye sepe. A e kane e le gore baeteledipele ba rona ba bonye gore ke Mesia tota? ");
INSERT INTO tsn_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mme o ka nna Mesia jang? Gonne re itse kwa monna yo a tsaletsweng teng; fa Keresete ene a tla, o tlaa bonala fela mme ga gona ope yo o tlaa itseng kwa o tswang teng.” ");
INSERT INTO tsn_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mme Jesu mo therong ya gagwe mo Tempeleng a goa a re, “Ee, lo a nkitse le kwa ke tsaletsweng gone le kwa ke neng ka godisediwa gone, mme ke moemedi wa mongwe yo lo sa mo itseng, mme ene o Boammaaruri. ");
INSERT INTO tsn_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ke a mo itse nna ka gore ke ne ke na nae, mme o nthomile mo go lona.” ");
INSERT INTO tsn_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Mme baeteledipele ba Sejuta ba batla go mo tshwara, le fa go ntse jalo ga se ka ga nna letsogo le le mo amang, gonne nako e a e beetsweng ke Modimo e ne e ise e nne yone. ");
INSERT INTO tsn_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ba le bantsi mo bontsintsing jwa batho kwa Tempeleng ba dumela mo go ene ba re, “Oai, lo solofela dikgakgamatso dife mo go Mesia tse monna yo a sa di dirang?” ");
INSERT INTO tsn_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Erile Bafarasai ba utlwa gore bontsintsi bo ne bo le mo mogopolong o, bone le ditlhogo tsa baperesiti ba romela mapodise a Tempele go tshwara Jesu. ");
INSERT INTO tsn_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Mme Jesu a ba raya a re, “Ga e ise e nne nako! Ke tshwanetse go nna fa ka lobakanyana. Hong ke gone ke tlaa boelang kwa go yo o nthomileng. ");
INSERT INTO tsn_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Lo tlaa mpatla mme ga lo na go mpona, gape ga lo na go kgona go tla kwa ke gone!” ");
INSERT INTO tsn_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Baeteledipele ba Sejuta ba akabadiwa ke polelo e, mme ba botsanya ba re, “O ikaelela go ya kae? Kgotsa o akanya go tswa mo kgaolong e a tsamaya e le moruti mo Bajuteng mo dikgaolong tse dingwe tsa lefatshe, kgotsa le fa e le kwa go Badichaba! ");
INSERT INTO tsn_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","O raya eng fa a re, re tlaa mmatla mme ga re na go mmona, le gore, ‘Ga lo kitla lo kgona go tla kwa ke leng teng?’ ” ");
INSERT INTO tsn_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mo letsatsing la bofelo, e le pheletso ya malatsi a boitapoloso, Jesu a goela kwa bontsintsing jwa batho a re, “Le fa e le mang yo o nyorilweng, a a tle kwa go nna a nwe. ");
INSERT INTO tsn_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Gonne dikwalo tsa re dinoka tsa metse a a tshedileng di tlaa elela ditswa mo teng ga yoo o dumelang mo go nna.” ");
INSERT INTO tsn_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(O ne a bua ka Mowa O O Boitshepo, o o tlaa newang mongwe le mongwe yo o dumelang mo go ene; mme Mowa o ne o ise o abiwe, gonne Jesu o ne a ise a boele kwa kgalalelong ya gagwe kwa legodimong). ");
INSERT INTO tsn_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Erile bontsintsi bo utlwa a buajaana, bangwe ba bone ba re, “Ammaaruri monna yo ke moporofiti yo o tlaa tlang pele ga Mesia.” ");
INSERT INTO tsn_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","42","Bangwe ba re, “Ke Mesia.” Mme ba bangwe bone ba nna ba re, “Ga e ka ke ya nna ene! A Mesia o tlaa tswa kwa Galalea? Gonne dikwalo di bua sentle fela gore Mesia o tlaa tsalwa ke ba ntlo ya bogosi jwa ga Dafide, mo Bethelehema, motse o Dafide o neng a tsalelwa mo go one.” ");
INSERT INTO tsn_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jalo ga tsoga kgaogano mo bontsing jwa batho ka ga gagwe. ");
INSERT INTO tsn_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mme bangwe ba batla gore a tshwarwe mme ga seka ga nna ope yo o mo amang ka letsogo. ");
INSERT INTO tsn_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mapodisi a Tempele a a neng a romilwe go mo tshwara a boela kwa ditlhogong tsa baperesiti le Bafarasai. Mme tsa feta tsa ba botsa tsa re, “Ke eng lo ne lo sa tle le ene?” ");
INSERT INTO tsn_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mme mapodisi a dumaduma a re, “O bua dilo tse di hakgamatsang! Ga re ise re ke re be re utlwe sepe se se ntseng jaaka se a se buang.” ");
INSERT INTO tsn_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mme Bafarasai ba fetola ka tshotlo ba re, “Go raya gore le lona lo timeditswe?” ");
INSERT INTO tsn_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“A go na le mongwe mo go rona babusi ba Sejuta kgotsa Bafarasai yo o dumelang fore Jesu ke Mesia? ");
INSERT INTO tsn_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Bontsintsi jo jwa dieleele bo a dumela, ee, mme baitse ka ga gone? Le gale ba hutsegile!” ");
INSERT INTO tsn_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Mme Nikodemo a bua. (A lo a mo gakologelwa? Ke ene yole yo e neng e le moeteledipele wa Sejuta yo o neng a tla ka sephiri go tla go buisanya le Jesu), ");
INSERT INTO tsn_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","A botsa a re, A go ka fa molaong go atlhola motho pele ga a sekisiwa? ");
INSERT INTO tsn_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Mme ba mo gakalela ba re, “A le wena o Mogalalea yo o tlhomolang pelo? Tlhatlhoba dikwalo o iponele, ga go na baporofiti ba ba tlaa tswang kwa Galalea!” ");
INSERT INTO tsn_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mme phuthego ya phatlalala mongwe le mongwe a ya gae. ");
INSERT INTO tsn_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mme Jesu a boela kwa Thabeng ya lotlhware, ");
INSERT INTO tsn_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","mme ya re phakela mo mosong o o latelang a bo a le mo Tempeleng gape. Mme bontsintsi jwa simolola go kokoana, mme a nna fa fatshe a bua nabo. ");
INSERT INTO tsn_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ya re a santse a bua, baeteledipele ba Sejuta le Bafarasai ba lere mosadi yo o tshwerweng mo boakeng ba mmaya fa pele ga bontsintsi jwa batho jo bo lebeletseng. ");
INSERT INTO tsn_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ba raya Jesu ba re, “Moruti, mosadi yo o tshwerwe fela a santse a dira boaka. ");
INSERT INTO tsn_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Molao wa ga Moshe wa re a bolawe. Wa reng ka ga gone?” ");
INSERT INTO tsn_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ba ne ba leka go mmeela seru sa gore a bue sengwe se ba tlaa mmonang molato ka sone, mme Jesu a inama a kwala mo mmung ka monwana wa gagwe. ");
INSERT INTO tsn_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ba tswelela pele ba batla karabo mo go Jesu, jalo a inamologa a ba raya a re, “Go siame, mo kgobotleng ka matlapa go fitlhela a swa. Mme le gale a konopiwe lwa ntlha ke yo a iseng a ke a leofe.” ");
INSERT INTO tsn_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mme a inama a kwala gape mo mmung. ");
INSERT INTO tsn_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mme baeteledipele ba Sejuta ba ngwangwaela ka bongwe ka bongwe go simolola ka yo mogolo mo go bone go fitlhelela Jesu le mosadi ba sala ba le bosi fa pele ga bontsintsi jwa batho. ");
INSERT INTO tsn_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mme Jesu a inamologa gape mme a mo raya a re, “Ba ba go bayang molato ba kae? A le fa e le ope wa bone ga aa go sekisa?” ");
INSERT INTO tsn_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mme mosadi a fetola a re, “Nnyaa rra.” Mme Jesu a mo raya a re, “Le nna ga ke go sekise. Tsamaya mme o seka wa tlhola o leofa.” ");
INSERT INTO tsn_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Mme erile morago, mo go nngwe ya dithero tsa gagwe, Jesu a raya batho a re, “Ke lesedi la lefatshe. Jalo fa lo ntshala moragao, ga lo na go kgotswa mo lefifing, gonne lesedi le le tshelang le tlaa bonesa tsela ya lona.” ");
INSERT INTO tsn_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mme Bafarasai ba mo fetola ba re, “O a ikgantsha ebile o bua maaka!” ");
INSERT INTO tsn_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesu a ba raya a re, “Ditshupo tse di boammaaruri le fa ke di bua di raya nna. Gonne ke itse kwa ke tswang teng le kwa ke go yang, mme ga lo itse kwa ke go tswang le kwa ke go yang. ");
INSERT INTO tsn_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Lo nkatlhola lo sena mabaka a a utlwalang. Nna ga ke lo atlhole jaanong jaana, ");
INSERT INTO tsn_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","mme fa ke ne nka lo atlhola, e ne e tlaa bo e le katlholo ya boammaaruri gotlhelele, gonne ke na le Rara yo o nthomileng. ");
INSERT INTO tsn_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Melao ya lona ya re fa batho ba le babedi ba dumalana mo go sengwe se se diragetseng, bosupi jwa bone bo amogelwa e le boammaaruri. ");
INSERT INTO tsn_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mme he, Nna ke mosupi yo mongwe le Rre yo o nthomileng ke mosupi yo mongwe.” ");
INSERT INTO tsn_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Mme bone ba botsa Jesu ba re, “Rrago o kae?” Jesu a ba araba a re, “Ga lo nkitse gore ke mang, jalo he, ga lo itse gore Rre ke mang. Fa lo no lo nkitsile, hong le ene lo ka bo lo mo itsele.” ");
INSERT INTO tsn_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesu o ne a bua mafoko a a sa ntse a le mo lefelong la Tempele le le bidiwang Ntlo ya Dikhumo. Mme ga a ka a tshwarwa, gonne e ne e ise e nne lobaka lwa gagwe. ");
INSERT INTO tsn_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Kwa morago a ba raya a re, “Ke a tsamaya; mme lo tlaa mpatla, mme lo tlaa swela mo dibeng tsa lona. Mme ga lo ka ke lwa tla kwa ke yang teng.” ");
INSERT INTO tsn_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bajuta ba botsa ba re, “A o ikaelela go ipolaya? O raya eng fa a re, ‘Ga lo ka ke lwa tla kwa ke yang teng’?” ");
INSERT INTO tsn_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Mme a ba raya a re, “Lo tswa kwa tlase; ke tswa kwa godimo. Lo ba lefatshe leno; nna ga ke wa lona. ");
INSERT INTO tsn_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ke sone se ke neng ke re lo tlaa swela mo dibeng tsa lona; gonne fa lo sa dumele gore Ke Mesia, Morwa Modimo, lo tlaa swela mo dibeng tsa lona.” ");
INSERT INTO tsn_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ba batla go itse, “Re bolelele gore o mang.” A fetola a re, “Ke yo o agang a lo ipolelela malatsi otlhe. ");
INSERT INTO tsn_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ke ne ke ka lo sekisetsa dilo di le dintsi ka ba ka lo ruta di le dintsi, mme ga ke na go dira jalo, gonne ke bua fela se ke se boleletsweng ke yo o nthomileng; yo o boammaaruri.” ");
INSERT INTO tsn_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Mme ba nna ba tlhoka go tlhaloganya gore o ne a bua le bone ka ga Modimo. ");
INSERT INTO tsn_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mme Jesu a re, “E tlaa re lo sena go bolaya Morwa Motho, lo tlaa lemoga gore ke nna tota le gore ke ntse ke sa lo bolelele se ke se intshetsang fela mo tlhaloganyong ya me, mme ke ne ke bua se Rara o se nthutileng. ");
INSERT INTO tsn_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mme yo o nthomileng o na le nna, ga a a ntatlha, gonne ke aga ke dira dilo tse di mo itumedisang.” ");
INSERT INTO tsn_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","31","Mme baeteledipele ba Sejuta ba le bantsi ba ba mo utlwileng a bua dilo tse ba simolola go mo dumela fa e le Mesia. Jesu a ba raya a re, “Lo barutwa ba me ba boammaaruri fa lo tshela ka fa ke lo bolelelang ka teng, ");
INSERT INTO tsn_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","mme lo tlaa itse boammaaruri, mme boammaaruri bo tlaa lo golola.” ");
INSERT INTO tsn_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mme ba re, “Mme re losika lwa ga Aberahame, ga re ise re ke re nne makgoba a ga ope mo lefatsheng! O raya eng fa o re ‘boammaaruri bo tlaa lo golola’?” ");
INSERT INTO tsn_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Mme Jesu a ba raya a re, “Lo makgoba a sebe, mongwe le mogwe wa lona. ");
INSERT INTO tsn_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mme makgoba ga a na ditshwanelo, mme Morwa o na le tshwanelo nngwe le nngwe, e e teng! ");
INSERT INTO tsn_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Jalo fa Morwa a lo golola, lo tlaa gololesega tota. ");
INSERT INTO tsn_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","(Ee, ke lemoga gore lo losika lwa ga Aberahame!) Mme le fa go ntse jalo bangwe ba lona ba leka go mpolaya gonne molaetsa wa me ga o bone boikhutso mo dipelong tsa bone. ");
INSERT INTO tsn_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ke lo bolelela se ke se bonyeng fa ke na le Rre. Mme lona lo diragatsa kgakololo ya ga rraa-lona.” ");
INSERT INTO tsn_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ba re, “Rraa-rona ke Aberahame,” mme Jesu a fetola a re, “Nnyaa! Fa e ne e le ene, lo ka bo lo tshwana nae. ");
INSERT INTO tsn_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mme mo boemong jwa gore lo tshwane nae lo leka go mpolaya, ka ntlha ya go bo ke lo boleletse boammaaruri jo ke bo utlwileng kwa Modimong. Aberahame o ne o ka seka a dira selo se se ntseng jalo! ");
INSERT INTO tsn_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nnyaa! Lo obamela rraa-lona tota fa lo dira jalo.” Ba fetola ba re, “Ga re a tsalelwa mo dikgoreng, rraa-rona wa boammaaruri ke Modimo o le osi.” ");
INSERT INTO tsn_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Mme Jesu a ba raya a re, “Fa go ne go ntse jalo, lo ka bo lo nthata, gonne ke tsile kwa go lona ke tswa kwa Modimong. Ga ke fano ka go rata ga me, ke ene o nthomileng. ");
INSERT INTO tsn_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ke eng fa lo sa kgone go tlhaloganya se ke se buang? Ke ka ntlha ya gore lo kganelwa go dira jalo! ");
INSERT INTO tsn_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Gonne lo bana ba ga rraa-lona ebong Diabolo, jalo he lo rata dilo tse di bosula tse a di dirang. Ene o sale a nna mmolai le mo tshimologong, le Moidi wa boammaaruri, ga go na le fa e le tlhase-nyana ya boammaaruri mo go ene. Fa a bua maaka, ke tlwaelo ya gagwe gonne ke Ramaaka. ");
INSERT INTO tsn_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mme jalo fa ke bua boammaaruri, ga lo dumele ka ntlha ya ka fa lo tlholegileng ka teng! ");
INSERT INTO tsn_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Ke ofe wa lona yo o ka mpayang molato wa sebe? Ga gona ope! Mme ka ke lo bolelela boammaaruri, ke eng fa lo sa ntumele? ");
INSERT INTO tsn_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Le fa e le mang yo e leng gore rraagwe ke Modimo o reetsa mafoko a Modimo ka boitumelo. Mme ka lo sa reetse, go supa fa lo se bana ba one.” ");
INSERT INTO tsn_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mme baeteledipele ba Sejuta ba goa ba re, “Mosamarea ke wena! Motswakwa! Diabolo! A ga re a go bolelela ra re o tsenwe ke mowa o o maswe?” ");
INSERT INTO tsn_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesu a re, “Nnyaa, ga ke a tsenwa ke mowa o o maswe. Gonne ke tlotla Rre, mme nna ga lo ntlotle? ");
INSERT INTO tsn_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mme le fa ke sa eletse go ikgodisa, Modimo o mpatlela selo se ebile o atlhola ba ba sa mpatleng. ");
INSERT INTO tsn_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ka tlhomamiso yotlhe ke lo raya ke re, ga go na ope yo o ntheetsang yo o tlaa swang!” ");
INSERT INTO tsn_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Baeteledipele ba Sejuta ba mo raya ba re, “Jaanong re itse gore o tsenwe ke mowa o o maswe. Le Aberahame tota le baporofiti ba bagolo ba sule, mme wena wa re fa re go obamela ga re kitla re e swa! ");
INSERT INTO tsn_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Jalo he, a o mogolo mo go rraa-rona Aberahame yo o suleng? Gape a o mogolo mo baporofiting ba ba suleng? O ikgopola gore o eng.” ");
INSERT INTO tsn_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Hong Jesu a ba raya a re, “Fa e le gore ke a ikgodisa, ga go reye sepe. Mme Modimo ke Rre, mme lwa re Modimo ke wa lona, yo o buang dilo tse di galalelang tse ka ga me. ");
INSERT INTO tsn_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mme le fa e le go mo itse ga lo mo itse. Nna ke a mo itse. Fa e le gore ke buile ka tsela nngwe, ke tlaa bo ke mo obamela ka botlalo. ");
INSERT INTO tsn_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Rraa-lona Aberahame o itumeletse go bona letsatsi la me. O ne a itse gore ke e tla mme a itumela.” ");
INSERT INTO tsn_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mme baeteledipele ba Sejuta ba re, “Ga o ise o bo o nne dingwaga di le masome matlhano, tota ga o ise o ke o bone Aberahame!” ");
INSERT INTO tsn_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Mme Jesu a re, “Boammaaruri jotlhe ke gore ke ne ke sale ke tshedile pele ga Aberahame a tsalwa!” ");
INSERT INTO tsn_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Gone fela foo baeteledipele ba Sejuta ba sela matlapa go mmolaya. Mme a ba iphitlhela, a ba ralala a tswa mo Tempeleng. ");
INSERT INTO tsn_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Mme ya re a santse a tsamaya, a bona monna yo o saleng a tsalwa a foufetse. ");
INSERT INTO tsn_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mme barutwa ba gagwe ba mmotsa ba re, “Morena, ke eng fa monna yo a tsetswe e le sefofu? A ke ka ntlha ya dibe tsa gagwe kgotsa dibe tsa batsadi ba gagwe?” ");
INSERT INTO tsn_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Mme Jesu a araba a re, “Ga se ka ntlha ya dibe dipe. Go ne go direlwa gore nonofo ya Modimo e supiwe. ");
INSERT INTO tsn_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Rotlhe re tshwanetse go akofa ra dira ditiro tse re di neetsweng ke yo o nthomileng, gonne go setse nakonyana fela pele ga bosigo bo tla mme tiro yotlhe e bo e khutla. ");
INSERT INTO tsn_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mme fa ke santse ke le fano mo lefatsheng, ke naya lefatshe lesedi la me.” ");
INSERT INTO tsn_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mme a kgwela mathe mo mmung a duba seretse ka mathe mme a se tshasa mo matlhong a monna yo o foufetseng, ");
INSERT INTO tsn_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","mme a mo raya a re, “Tsamaya o ye go tlhapa mo lekadibeng la Siloame” (lefoko le le reng ‘Siloame’ le raya gore ‘Romilwe’) jalo monna a ya kwa a romilweng teng, mme a feta a tlhapa a boela kwa morago a bona! ");
INSERT INTO tsn_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mme ba ga gabo le batho ba bangwe ba ba mo itseng e le sefofu sa mokopi ba botsanya ba re, “A yo ke ene tota, mokopi yo re mo itseng?” ");
INSERT INTO tsn_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bangwe ba re, ee, mme ba bangwe ba re nnyaa. Jalo ba akanyetsa ba re, “Ga e ka ke ya nna ene, mme o lebega jaaka ene!” Mme mokopi a ba raya a re, “Ke nna yo lo nkitseng!” ");
INSERT INTO tsn_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Mme ba mmotsa gore go diragetse jang gore a foufologe. Tota-tota go tsamaile jang! ");
INSERT INTO tsn_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mme a ba raya a re, “Monna yo ba mmitsang Jesu o ne a duba seretse a se tshasa mo matlhong a me mme a nthaya a re ke ye kwa lekadibeng la Siloame ke ye go tlhapa seretse. Mme ke ne ka dira jalo, jaanong ke a bona!” ");
INSERT INTO tsn_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Mme ba mmotsa ba re, “O kae jaanong?” Mme a araba a re, “Ga ke itse.” ");
INSERT INTO tsn_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mme ba tsaya monna ba mo isa kwa Bafarasaing. ");
INSERT INTO tsn_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Mme ya re mo go diragala ga bo go le letsatsi la Sabata. ");
INSERT INTO tsn_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mme Bafarasai ba mmotsa gotlhe ka ga tiragalo eo. Jalo a ba bolelela ka fa Jesu a neng a dira seretse ka teng a se tshasa mo matlhong a gagwe, mme ya re a sena go tlhapa a bona! ");
INSERT INTO tsn_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Bangwe ba bone ba re, “Motho yo Jesu ga a tswe kwa Modimong gonne o dira go le Sabata.” Ba bangwe ba re, “Mme motho fela wa modira dibe ao ka dira dikgakgamatso tse jang?” Mme ga nna kgaogano e tona ya megopolo mo go bone. ");
INSERT INTO tsn_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mme Bafarasai ba retologela kwa monneng yo a neng a foufetse ba mmotsa ba re, “Wa re monna yo o go foufolotseng ke mang?” Mme monna a re, “Ke bona gore e tshwanetse ya bo e le moporofiti a romilwe ke Modimo.” ");
INSERT INTO tsn_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mme Baeteledipele ba Sejuta ba seka ba dumela gore o ne a foufetse, go fitlhelela ba botsa batsadi ba gagwe. ");
INSERT INTO tsn_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Erile ba sena go ba bitsa ba ba botsa ba re, “A motho yo ke morwaa lona? A o-tsetswe a foufetse? Fa go ntse jalo, ke eng fa a bona?” ");
INSERT INTO tsn_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Batsadi ba gagwe ba fetola ba re, “e itse gore motho yo ke ngwana wa rona le gore o tsetswe e le sefofu, ");
INSERT INTO tsn_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","mme ga re itse gore go diragetse jang gore a foufologe, kgotsa gore o foufolotswe ke mang. O setse a godile o lekanye go ikarabela. Mmotseng.” ");
INSERT INTO tsn_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Ba ne ba bua jaana ka ba boifa baeteledipele ba Sejuta ba ba neng ba setse ba anamisitse gore mongwe fela yo o reng Jesu ke Mesia o tlaa kgaolwa mo phuthegong. ");
INSERT INTO tsn_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mme lwa bobedi ba bitsa monna yo o foufolotsweng ba mo raya ba re, “Galaletsa Modimo e seng Jesu, gonne re itse gore Jesu ke motho yo o bosula.” ");
INSERT INTO tsn_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mme monna a fetola a re, “Ga ke itse gore a o siame kgotsa o bosula, mme nna ke itse fela gore, ke ne ke le sefofu mme jaanong ke a bona!” ");
INSERT INTO tsn_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ba mmotsa ba re, “O ne a dira eng? O ne a go fodisa jang”? ");
INSERT INTO tsn_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mme monna a ba botsa a re, “Bonang! Ke lo boleletse gagwe fela, a lo ne lo sa reetsa? Ke eng fa lo mpotsa gape? A le lona lo batla go nna barutwa ba gagwe?” ");
INSERT INTO tsn_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Mme ba mo hutsa ba mo raya ba re, “Morutwa wa gagwe, mme rona re barutwa ba ga Moshe. ");
INSERT INTO tsn_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Re itse gore Modimo o buile le Moshe, mme fa e le yo ene ga re itse sepe ka ga gagwe.” ");
INSERT INTO tsn_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mme a fetola a re, “Ka ntlha yang, go a hakgamatsa! ");
INSERT INTO tsn_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","O foufolola difofu, mme o na le ditsebe tse di bulegetseng ba ba o obamelang ba dirago rata ga one. ");
INSERT INTO tsn_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Fa e sale lefatshe le simologa ga go ise go ke go nne le ope yo a neng a ka foufola matlho a mongwe yo o tsetsweng a le sefofu. ");
INSERT INTO tsn_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Fa monna yo a ne a sa tswe kwa Modimong, o ka bo a sa kgona go foufolola difofu.” ");
INSERT INTO tsn_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mme ba goa ba re, “Ngwana wa mpa ya dikgora ke wena! A o leka go re ruta?” Mme ba mo kgoromeletsa kwa ntle. ");
INSERT INTO tsn_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Erile fa Jesu a utlwalela se se diragetseng, a bona monna yo mme a mo raya a re, “A o dumela mo go Mesis?” ");
INSERT INTO tsn_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mme monna a araba a re, “E mang, rra, gonne ke a batla.” ");
INSERT INTO tsn_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Mme Jesu a re, “O mmonye, ebile ke ene yo o buang le wena!” ");
INSERT INTO tsn_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Monna a re, “Ee, Morena, Ke a dumela!” mme a obamela Jesu. ");
INSERT INTO tsn_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Mme Jesu a mo raya a re, “E tletse mo lefatsheng go naya ba ba foufetseng mo moweng pono le go kaela ba ba ithayang ba re ba a bona gore ba foufetse.” ");
INSERT INTO tsn_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Bafarasai ba ba neng eme foo ba botsa ba re, “A wa re re foufetse?” ");
INSERT INTO tsn_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Mme Jesu a ba raya a re, “Fa lo ne lo foufetse, lo ka bo lo se molato! Mme lo molato gonne lo ipona gore lo itse se lo se dirang.” ");
INSERT INTO tsn_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Le fa e le mang yo o ganang go tsena ka kgoro mo lesakeng la dinku, yo o tlolelang ka lokotswana, o tshwanetse tota a be a le legodu. ");
INSERT INTO tsn_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Gonne modisa o tsena ka kgoro. ");
INSERT INTO tsn_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Motlhokomedi wa kgoro o a e mmulela, mme dinku di utlwa lentswe la gagwe jalo di tle kwa go ene; mme a bitse dinku tsa gagwe ka maina a di etelele pele di ya kwa ntle. ");
INSERT INTO tsn_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","O tsamaya kwa pele ga tsone; mme di mo sale morago, gonne di tlhaloganya lentswe la gagwe. ");
INSERT INTO tsn_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ga di kitla di sala moeng morago, mme di tlaa mo phatlalalela, gonne ga di itse lentswe la gagwe.” ");
INSERT INTO tsn_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ba ba neng ba utlwa Jesu a dirisa setshwantsho se ba ne ba seka ba tlhaloganya se a se rayang. ");
INSERT INTO tsn_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mme a se ba tlhalosetsa a re, “Ke nna Kgoro ya dinku. ");
INSERT INTO tsn_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Botlhe ba bangwe ba ba tsileng pele ga me e ne e le magodu le dinokwane. Mme dinku tsa boammaaruri ga di ise di ke di ba reetse. ");
INSERT INTO tsn_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ee, ke nna Kgoro. Ba ba tsenang ka Kgoro ba tlaa bolokwa mme ba tlaa tsena ba bo ba tswa mme ba tlaa bona mafulo a matalana. ");
INSERT INTO tsn_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Maikaelelo a legodu ke go utswa, le go bolaya le go senya. Mme nna maikaelelo a me ke go aba botshelo jo bo sa khutleng ka letlotlo. ");
INSERT INTO tsn_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ke Modisa yo o Molemo. Modisa yo o molemo o ntshetsa dinku botshelo jwa gagwe. ");
INSERT INTO tsn_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Motho yo o thapilweng o tlaa sia a tlogela dinku fa a bona phiri e tla, gonne ga se tsa gagwe ebile ga se modisa wa tsone. Mme jalo phiri e di tlolele e phatlalatse letsomane. ");
INSERT INTO tsn_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Motho yo o thapilweng o sia ka ntlha ya gore o thapilwe, le ka ntlha ya gore ga a kgathalele dinku thata. ");
INSERT INTO tsn_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Ke Modisa yo o Molemo ebile ke itse dinku tsa me, le tsone di a nkitse. ");
INSERT INTO tsn_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Fela jaaka Rara a nkitse le nna ke itse Rara; jalo ke ntshetsa dinku botshelo jwa me. ");
INSERT INTO tsn_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ke na le dinku tse dingwe mo lesakeng le lengwe. Le tsone ke tshwanetse go di lere, mme di tlaa utlwa lentswe la me; jalo go tlaa nna letsomane le le lengwe ka fa tlase ga tlhokomelo ya Modisa a le mongwe fela. ");
INSERT INTO tsn_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Rara o a nthata gonne ke ntsha botshelo jwa me setlhabelo gore ke tle ke nne le jone gape. ");
INSERT INTO tsn_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ga go na ope yo o ka mpolayang kwa ntle ga go rata ga me. Ke ntsha botshelo jwa me setlhabelo ka bonna. Gonne ke na le tshwanelo le nonofo ya go bo ntsha setlhabelo fa ke batla le tshwanelo le nonofo ya go bo tsaya gape. Gonne Rara o nneile tshwanelo e.” ");
INSERT INTO tsn_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Erile fa a bua jaana, baeteledipele ba Sejuta ba kgaogana mo megopolong gape ka ga gagwe. ");
INSERT INTO tsn_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bangwe ba bone ba re, “O na le mowa o o maswe eseng jalo o a tsenwa. Ke eng re reetsa motho yo o ntseng jalo?” ");
INSERT INTO tsn_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ba bangwe ba re, “Mo go rona golo mo ga go utlwale go buiwa ke motho yo o tsenweng ke mowa o o maswe! A mowa o o maswe o ka foufolola matlho a difofu?” ");
INSERT INTO tsn_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","23","Go ne go le mariga, fa Jesu a le mo Jerusalema ka lebaka lwa Moletlo wa Boshafatso. O ne a le kwa Tempeleng, a raletse golo fa go bidiwang Mathudi a ga Solomone. ");
INSERT INTO tsn_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Baeteledipele ba Sejuta ba mo dikgaganyetsa mme ba mmotsa ba re, “O tlaa re baya mo lefifing la bosena-kitso fitlhelela leng? Fa e le gore o Mesia re bolelele sentle.” ");
INSERT INTO tsn_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Mme Jesu a ba raya are, “Ke setse ke lo bole-letse, mme ga lo ntumele. Sesupo ke dikgakgamatso tse ke di dirang ka leina la ga Rara. ");
INSERT INTO tsn_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mme ga lo ntumele gonne ga lo ba letsomane la me. ");
INSERT INTO tsn_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Dinku tsa me di itse lentswe la me, le nna ke a di itse, mme dintshala morago. ");
INSERT INTO tsn_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ke di naya botshelo jo bo sa khutleng mme ga di kitla di nyelela. Ga gona ope yo o tlaa di phamolang mo go nna, ");
INSERT INTO tsn_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","gonne Rara o di nneile, mme o nonofile go feta mongwe le mongwe, jalo he ga go na ope yo o ka di utswang mo go nna. ");
INSERT INTO tsn_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nna le Rara re selo se le sengwe.” ");
INSERT INTO tsn_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Mme gape baeteledipele ba Sejuta ba sela matlapa go mmolaya. ");
INSERT INTO tsn_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesu a ba raya a re, “E fa kaelong ya Modimo ke dirile dikgakgamatso di le dintsi go thusa batho. Lo mpolaela kgakgamatso efe?” ");
INSERT INTO tsn_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Mme ba mo fetola ba re, “Ga re go balaele tiro epe e e siameng, re go bolaela tlhapatso; wena, mothonyana ke wena yo o seng wa sepe o ipiditse gore o Modimo.” ");
INSERT INTO tsn_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","36","Mme a fetola a re, “Mo molaong wa lona gatwe batho ke medimo Jalo he, fa lokwalo, lo lo sa ka keng lwa bua maaka, lo bua ka gore medimo ke batho ba molaetsa wa Modimo o tsileng mo go bone, a lo go bitsa tlhapatso fa yo ene a itshepisitsweng a bile a romilwe mo lefatsheng ke Rara a re, ‘Ke Morwa Modimo?’ ");
INSERT INTO tsn_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Se ntumeleng, fa e se fela ke dira dikgakgamatso tsa Modimo. ");
INSERT INTO tsn_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mme fa ke di dira, di dumeleng lefa lo sa ntumele. Hong lo tlaa dumela tota gore Rara omo go nna, le gore ke mo go Rara.” ");
INSERT INTO tsn_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Gape ba leka go mo tshwara. Mme a tsamaya a ba tlogela… ");
INSERT INTO tsn_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mme a tlhatlogela kwa moseja ga Noka ya Jorodane go nna gaufile lefelo le Johane a neng a kolobeletsa mo go lone lwa ntlha. ");
INSERT INTO tsn_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mme ba le bantsi ba mo sala morago. Mme ba le bantsi ba mo sala morago. Mme ba dumaduma ba re, “Johane ga a ise a ke a dire dikgakgamatso, mme dipolelelopele tsa gagwe tsotlhe kaga monna yo di diragetse,” ");
INSERT INTO tsn_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Hong ba le bantsi ba dumela gore ke Mesia. ");
INSERT INTO tsn_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Mme jaana ga bo go le monna mongwe yo o neng a bidiwa Lasaro yo o neng a lwala. O ne a tswa Bethania motse wa ga gabo Marea Le Maratha mogolowe. Marea Kgaitsadia Lasaro, ke ene yo o kileng a tlotsa Morena setlolo a ba a se phimola mo dinaong tsa gagwe ka moriri. ");
INSERT INTO tsn_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mme bokgaitsadie ba babedi ba romela molaetsa kwa go Jesu ba mo raya ba re, “Morena, tsala ya gago e e molemo e lwala thata thata.” ");
INSERT INTO tsn_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mme erile fa Jesu a utlwa ka ga moo, a re, “Maikaelelo a bolwetse jwa gagwe ga se loso, mme ke maikaelelo a gore Modimo o tlo o galalediwe. Nna, Morwa Modimo, Ke tlaa galalediwa ka ga jone bolwetse jo.” ");
INSERT INTO tsn_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Lefa Jesu a ne a rata Maratha le Marea le Lasaro thata, ");
INSERT INTO tsn_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","o ne a nna fela kwa a neng a le teng malatsi a mabedi a a latelang a sa ye kwa go bone fa a sena go bolelelwa. ");
INSERT INTO tsn_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Lwa bofelo morago ga malatsi a mabedi, a raya barutwa ba gagwe a re, “A re yeng kwa Judea.” ");
INSERT INTO tsn_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mme barutwa ba gagwe ba gana ba re, “Morena, malatsinyana fela a a fetileng a se kae, baeteledipele ba Sejuta mo Judea ba ne ba leka go go bolaya. A o yo teng gape?” ");
INSERT INTO tsn_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesu a fetola a re, “Motshegare mongwe le mongwe o na le dioura di le lesome le bodedi, mme mo oureng nngwe le nngwe ya one motho o ka tsamaya a babalesegile a sa kgotswe. ");
INSERT INTO tsn_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Bosigo fela ke gone go nang le diphatsa tsa go kgotswa, ka ntlha ya lefifi.” ");
INSERT INTO tsn_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Mme a bua a re, “Tsala ya rona Lasaro o robetse, mme jaanong ke ya go mo tsosa!” ");
INSERT INTO tsn_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","13","Erile ka barutwa ba ne ba gopola gore Jesu o raya gore Lasaro o robetse boroko fela jwa bosigo, ba re, “Moo go raya gore o nna botoka!” Mme Jesu o ne a raya gore Lasaro o sule. ");
INSERT INTO tsn_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mme a ba bolelela sentle a re, “Lasaro o sule. ");
INSERT INTO tsn_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mme ka ntlha ya lona, Ke a itumela, ka ke ne ke se fa go ene, mme mo go tlaa lo naya sebaka sa go dumela mo go nna. A re yeng kwa go ene.” ");
INSERT INTO tsn_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Thomase yo o bidiwang “Lewelana” a raya barutwa ba bangwe ka ene a re, “A re tsamaeng le rona re ye go swa nae.” ");
INSERT INTO tsn_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mme ya re ba goroga kwa Bethania, ba bolelelwa gore Lasaro o setse a le mo phupung malatsi a le mane. ");
INSERT INTO tsn_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethania o ne a le dimmaele di se kae fela ka tsela e e tswang Jerusalema, ");
INSERT INTO tsn_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","mme baeteledipele ba Sejuta ba le bantsi ba ne ba tsile Maratha le Marea matshidiso. ");
INSERT INTO tsn_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Erile fa Maratha a utlwa gore Jesu o e tla, a ya go mo kgatlhantsha, mme Marea ene a sala mo lwapeng. ");
INSERT INTO tsn_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maratha a raya Jesu a re, “Morena, fa o ka bo o ne o le fano kgaitsadiake o ka bo a sa swa. ");
INSERT INTO tsn_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mme le jaanong ga go ise go fete nako e telele thata, gonne ke itse gore Modimo o tlaa lere kgaitsadiake mo botshelong gape, fa o ka mo kopa gore a dire jalo.” ");
INSERT INTO tsn_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesu a mo raya a re, “Kgaitsadio o tlaa rula.” ");
INSERT INTO tsn_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maratha a re, “Ee, fa mongwe le mongwe a rula mo Letsatsing la Tsogo.” ");
INSERT INTO tsn_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Mme Jesu a mo raya a re, “Ke nna yo ke tsosang baswi ke bo ke ba naya botshelo gape. Le fa e le mang yo o dumelang mo go nna, le mororo a a swa jaaka mongwe le mongwe, o tlaa tshela gape. ");
INSERT INTO tsn_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","O neelwa botshelo jo bo sa khutleng ka ntlha ya go dumela mo go nna mme ga a kitla a nyelela, A o dumela se Maratha?” ");
INSERT INTO tsn_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mme Maratha a re, “Ee, Morena, ke dumela gore o Mesia, Morwa Modimo, ene tota yo re sa bolong go mo letela.” ");
INSERT INTO tsn_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mme a mo tlogela a boela kwa go Marea, mme a feta a mmiletsa kwa thoko ga ba ba tsileng ma-tshidiso, a mo raya a re, “Jesu o fano o batla go go bona.” ");
INSERT INTO tsn_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mme Marea a itlhaganelela kwa go ene. ");
INSERT INTO tsn_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ka nako eo Jesu o ne a ntse ka kwa ntle ga motse, kwa lefelong le Maratha a neng a rakana le ene teng. ");
INSERT INTO tsn_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Fa baeteledipele ba Sejuta ba ba neng ba le mo tlung ba leka go gomotsa Marea ba bona a nanoga ka bofefo, ba ne ba gopola gore o ya kwa phupung ya ga Lasaro go lela; jalo ba mo sala morago. ");
INSERT INTO tsn_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Erile fa Marea a goroga kwa Jesu a leng teng, a wela ka mangole fa pele ga dinao tsa gagwe a mo raya a re, “Morena, fa o ne o le fano, kgaitsadiake o ka bo a sa ntse a tshela.” ");
INSERT INTO tsn_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Erile fa Jesu a mmona a lela, le baeteledipele ba Sejuta ba lela nae a hohomoga mo moweng a huduega. ");
INSERT INTO tsn_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Mme a ba botsa a re, “O fitlhilwe kae?”, “Tla o bone.” ");
INSERT INTO tsn_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesu a lela. ");
INSERT INTO tsn_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mme baeteledipele ba Sejuta ba re, “Ba ne ba le ditsala tse di ratanang thata. Bonang gore o ne a mo rata jang.” ");
INSERT INTO tsn_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","38","Mme bangwe ba re, “Motho yo o foufolotse monna wa sefofu, ke eng a ne a sa dire gore Lasaro a seka a swa?” Mme gape Jesu a hohomoga mo moweng. Mme ba tla kwa lebitleng. Lebitla leo e ne e le logaga lo lo tswalwang ka lentswe le legolo thata. ");
INSERT INTO tsn_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesu a ba raya a re, “Pitikololelang lentswe kwa thoko.” Mme Maratha, kgaitsadia moswi, a re, “Ka nako eno monkgo wa gagwe o tlaa nna maswe thata, gonne o na le malatsi a le mane a sule.” ");
INSERT INTO tsn_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesu a mmotsa a re, “A mme ga ke a go raya ka re o tlaa bona kgakgamatso e e tswang Modimong fa o dumela?” ");
INSERT INTO tsn_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mme ba pitikololela lentswe fa thoko. Jesu a leba kwa legodimong mme a re, “Rara, ke lebogela go nkutlwa ga gago. ");
INSERT INTO tsn_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","(O nkutlwa ka gale, ee, mme ke ipoeleditse ka ntlha ya batho ba botlhe ba ba emeng fano, gore ba tle ba dumele fa o nthomile).” ");
INSERT INTO tsn_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mme a goa a re, “Lasaro, tswela kwa ntle!” ");
INSERT INTO tsn_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mme Lasaro a tswa a fapilwe ka matsela a phitlho, sefatlhogo sa gagwe se fapilwe ka tuku. Jesu a ba raya a re, “Mmofololeng lo mo lese a tsamaye!” ");
INSERT INTO tsn_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mme jalo lwa bofelo fa baeteledipele ba Sejuta ba le bantsi ba ba neng ba na le Marea ba bona tiragalo eo, ba dumela ene! ");
INSERT INTO tsn_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mme bangwe ba ya kwa Bafarasaing go ba bolelela ka ga gone. ");
INSERT INTO tsn_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mme ditlhogo tsa baperesiti tsa bitsa lekgotla go buisanya ka ga tiragalo e. Mme ba botsanya ba re, “Re dirang ka ga tiragalo e, gonne monna yo tota o dira dikgakgamatso? ");
INSERT INTO tsn_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Fa re mo lesa fela, sechaba sotlhe se tlaa mo sala morago, mme masole a Roma a tlaa tla go re bolaya a bo a tsaya mmuso wa Sejuta.” ");
INSERT INTO tsn_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mme mongwe wa bone ebong Kaeafase, yo a neng a le Moperesiti yo Mogolo mo ngwageng eo, a re, “Dieleele ke lona, ");
INSERT INTO tsn_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","tlogelang monna yo a swele batho botlhe, ke eng fa sechaba sotlhe se ka nyelela ka ntlha ya motho a le nosi?” ");
INSERT INTO tsn_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Seporofeto se sa gore Jesu o tshwanetse go swela Sechaba sotlhe, se dule mo go Kaefase a le mo maemong a gagwe jaaka a ne a le Moperesiti yo mogolo, e ne e se ene a se ikakanyeditseng mme o ne a tlhotlhelediwa ke mowa go bua jalo. ");
INSERT INTO tsn_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","E ne e le polelo pele gore loso lwa ga Jesu e tlaa bo e se lwa Iseraele fela, mme e tlaa bo e le lwa bana ba Modimo ba ba anameng mo lefatsheng lotlhe. ");
INSERT INTO tsn_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Jalo go simolola nako eo baeteledipele ba Sejuta ba simolola go tsoma Jesu. ");
INSERT INTO tsn_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Mme Jesu a khutlisa dithuto tsa gagwe mme a tswa mo Jerusalema, a ya kwa lotshitshing lwa sekaka, kwa motseng wa Eferaima; mme a nna teng le barutwa ba gagwe. ");
INSERT INTO tsn_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tlolaganyo, e e leng letsatsi la Sejuta la boitapoloso, e ne e le gaufi, mme batho ba le bantsi ba ba tswang kwa dikgaolong ba goroga mo Jerusalema malatsinyana a sa le kwa pele gore ba tle ba tsene mo modirong wa bontlafatso pele ga Tlolaganyo e simolola. ");
INSERT INTO tsn_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ba ne ba batla go bona Jesu, mme ka ba ne ba sebaseba mo Tempeleng, ba be ba botsanya ba re, “Lo akanya jang? A o tlaa tla kwa Tlolaganyong?” ");
INSERT INTO tsn_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ka lone lobaka loo, ditlhogo tsa baperesiti le Bafarasai di ne di anamisitse phatlalatsa gore yo o tlaa bonang Jesu a ba bolelele gore ba tle ba mo tshware. ");
INSERT INTO tsn_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Malatsi a le marataro pele ga meletlo ya Tlolaganyo e simologa, Jesu a goroga mo Bethania kwa Lasaro monna yo a mo rudisitseng a neng a le teng. ");
INSERT INTO tsn_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mme Jesu a baakanyediwa modiro wa tlotlo teng. Maratha a ba tsholela mme Lasaro ene a nna le bone kwa lomating lwa bojelo (tafole). ");
INSERT INTO tsn_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mme Marea a tsaya setlolo se se tlhwatlhwa kgolo se dirilwe ka dinkgisamonate a tlotsa dinao tsa ga Jesu ka sone, a bo a di phimola ka moriri wa gagwe. Mme ntlo ya tlala monkgo o o monate wa setlolo. ");
INSERT INTO tsn_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mme Judase Isekariota, mongwe wa barutwa ba gagwe, ene yo o tlaa mo okang, a re, ");
INSERT INTO tsn_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Setlolo seo se ne se lekanye madi a mantsi. Se ka bo se rekisitswe mme madi a sone a abelwa bahumanegi.” ");
INSERT INTO tsn_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","E ne e se gore ka go bua jalo o gopotse go tlhokomela bahumanegi, gonne o ne a le mmei wa madi a barutwa mme o ne a tle a a utswe a a dirise mo ditirong tsa gagwe! ");
INSERT INTO tsn_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Mme Jesu a fetola a re, “Mo tlogele. O dirile jalo e le paakanyetso ya phitlho ya me. ");
INSERT INTO tsn_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Lo ka aga lo thusa bahumanegi, mme nna ga ke na go nna le lona ka lobaka lo loleele.” ");
INSERT INTO tsn_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Erile fa ba e leng batho fela ba Jerusalema ba utlwalela ka kgorogo ya gagwe ba itlhaganela ka bontsintsi go ya go mmona le go bona Lasaro, monna yo o rudileng. ");
INSERT INTO tsn_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mme ditlhogo tsa baperesiti tsa ikaelela go bolaya le Lasaro, ");
INSERT INTO tsn_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","gonne e ne e le ka ntlha ya ga Lasaro gore baeteledipele ba Sejuta ba le bantsi ba tlogele Sejuta ba dumele mo go Jesu e le Mesia wa bone. ");
INSERT INTO tsn_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Letsatsi le le latelang, dikgang tse di reng Jesu o mo tseleng ya Jerusalema tsa anama mo motseng, mme bontsintsi jo bogolo jwa baeti ba Tlolaganyo, ");
INSERT INTO tsn_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","jwa tsaya dikala tsa makolane mme jwa fologela mo tseleng go mo kgatlhantsha ba goa ba re, “Mmoloki! Modimo segofatsa Kgosi ya Iseraele! A go bakwe moemedi wa Modimo!” ");
INSERT INTO tsn_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesu a tsamaya a palame tonkana, a diragatsa seporofeso se se reng ");
INSERT INTO tsn_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Se boifeng Kgosi ya lona, batho ba Iseraele, gonne e tlaa tla kwa go lona ka boingotlo, e palame tonkana!” ");
INSERT INTO tsn_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","(Barutwa ba gagwe ba seka ba lemoga ka nako eo gore se e ne e le tiragatso ya seporofeso; mme morago ga Jesu a boela kwa kgalalelong ya gagwe kwa legodimong, ba simolola go lemoga gore go setse go diragetse diporofeso di le kae tsa lokwalo mo matlhong a bone). ");
INSERT INTO tsn_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mme ba ba mo bontsintsing joo ba ba neng ba bonye Jesu a tsosa Lasaro mo baswing ba ne ba bolela gotlhe ka gone. ");
INSERT INTO tsn_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ke sone se batho ba le bantsi ba neng ba ya go mo kgatlhantsha, gonne ba ne ba utlwile kgakgamatso e tona eo. ");
INSERT INTO tsn_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mme Bafarasai ba raana ba re, “Re fentswe. Bonang, lefatshe lotlhe le mo setse morago!” ");
INSERT INTO tsn_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Bagerika bangwe ba ba neng ba tsile mo Jerusalema go obama mo Tlolaganyong, ");
INSERT INTO tsn_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ba etela Filipo yo a neng a tswa Bethesaida, mme ba feta ba re, “Rara, re batla go rakana le Jesu.” ");
INSERT INTO tsn_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo a bolelela Anderea ka gone, mme ba tsamaya botlhe go kopa Jesu. ");
INSERT INTO tsn_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","24","Jesu a ba fetola ka gore nako e mo gorogetse ya go boela kwa kgalalelong ya gagwe kwa legodimong, le gore, “Ke tshwanetse go wa ka swa jaaka tlhaka ya mabele e e welang mo mmung wa boleme. Fa ke sa swe, ke tlaa nna ke le nosi, peo e e yosi. Mme loso lwa me lo tlaa tlhogisa ditlhaka tsa mabele di le dintsi, thobo e kgolo ya matshelo a masha. ");
INSERT INTO tsn_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Fa lo rata botshelo jwa lona mono lefatsheng, bo tlaa lo latlhegela. Mme fa lo nyatsa botshelo jwa lona mono lefatsheng, o tlaa bo ananya ka kgalalelo ya bosakhutleng. ");
INSERT INTO tsn_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","“Fa e le gore Bagerika ba, ba batla go nna barutwa ba me, ba boleleleng gore ba tle ba ntshale morago, gonne batlhanka ba me ba tshwanetse go nna kwa ke teng. Mme fa ba ntshala morago, Rara o tlaa ba tlotla ");
INSERT INTO tsn_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jaanong mowa wa me o tshwenyegile thata. A nka rapela ka re, ‘Rara, mpoloka mo go se se nkemeng pele?’ Mme ke lone lebaka le ke le tletseng! ");
INSERT INTO tsn_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Rara, galaletsa leina la gago o bo o le tlotle.” Mme ga bua lentswe le tswa kwa legodimong le re, “Ke setse ke dirile jalo, mme ke tlaa dira jalo gape.” ");
INSERT INTO tsn_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Erile fa bontsintsi jwa batho bo utlwa lentswe, bangwe ba bone ba gopola gore ke tladi, fa ba bangwe bone ba re ke moengele o buile nae. ");
INSERT INTO tsn_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mme Jesu a ba raya a re, “Lentswe leo ga le a tla ka ntlha ya me, mme e leng ka ntlha ya lona. ");
INSERT INTO tsn_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Lobaka lwa katlholo ya lefatshe lo gorogile, le nako ya fa Satane, Kgosana ya lefatshe leno a tlaa kgoromelediwang ntle. ");
INSERT INTO tsn_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Mme fa ke tsholediwa (mo mokgorong) ke tlaa gogela mongwe le mongwe kwa go nna?” ");
INSERT INTO tsn_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","O ne a bua jaana go supa ka fa o tlaa swang ka teng. ");
INSERT INTO tsn_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Bontsintsi jwa botsa jwa re, “Go swa? Re utlwile gore Mesia o tlaa tshela ka bosakhutleng mme ga a kitla a a swa. Ke eng fa o re o tlaa swa? O bua kaga. Mesia ofe?” ");
INSERT INTO tsn_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Mme Jesu a fetola a re, “Lesedi la me le tlaa lo phatsimela ka lobakanyana. Tsamayang mo go lone lo sa ntse lo ka kgona, mme lo ye kwa lo batlang go ya teng pele ga lefifi le tla, gonne ka nako eo lobaka lo tlaa bo lo setse lo fetile thata gore lo bone tsela ya lona. ");
INSERT INTO tsn_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Dirisang Lesedi nako e sa le teng; ka go dira jalo lo tlaa nna batsamaisi ba lesedi.” Morago ga a bua dilo tse, Jesu a tsamaya mme a ba iphitlhetse. ");
INSERT INTO tsn_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mme le fa a ne a dirile dikgakgamatso tse tsotlhe, batho ba le bantsi ba ne ba sa dumele gore ke Mesia. ");
INSERT INTO tsn_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ke sone tota se Isaia o se porofetileng a re: “Morena, re tlaa dumelwa ke mang? E mang yo o tlaa tsayang dikgakgamatso tsa Modimo tse di tona e le bosupi?” ");
INSERT INTO tsn_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Mme ba ne ba seka ba dumela, fela jaaka Isaia le ene a ne a rile: ");
INSERT INTO tsn_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Modimo o foufaditse matlho a bone o bile o thatafaditse dipelo tsa bone gore ba seka ba bona le fa e le go tlhaloganya e se re kgotsa ba sokologela kwa go nna gore ke ba fodise.” ");
INSERT INTO tsn_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaia o ne a raya Jesu fa a porofeta jaana, gonne o ne a bonye ponatshego ya kgalalelo ya ga Mesia. ");
INSERT INTO tsn_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Le fa go ntse jalo, le baeteledipele ba Sejuta ba le bantsi ba ne ba dumela mo go ene gore ke Mesia mme legale ba ne ba sa dumele fa ba na le batho ka ntlha ya go tshaba go kgaolwa ke Bafarasai mo tlung ya ga Jehofa; ");
INSERT INTO tsn_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","gonne ba ne ba rata kgalaletso ya batho bogolo go kgalaletso ya Modimo. ");
INSERT INTO tsn_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Mme Jesu a goela kwa bontsintsing a re, “Fa lo ntumela lo dumela Modimo. ");
INSERT INTO tsn_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Gonne fa lo mpona, lo bona ene yo o nthomileng. ");
INSERT INTO tsn_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ke tsile ke le Lesedi go phatsima mo lefatsheng leno le le lefifi gore botlhe ba ba dumelang mo go nna ba seka ba tlhola ba tsamaya mo lefifing. ");
INSERT INTO tsn_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mme le fa e le mang yo o nkutlwang mme a sa nkobamele, ga ke moatlhodi wa gagwe, gonne ke tletse go boloka lefatshe eseng go le atlhola. ");
INSERT INTO tsn_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mme botlhe ba ba nkganang le molaetsa wa me, ba tlaa atlholwa ka Letsatsi la Katlholo ka mafoko a boammaaruri a ke a buileng. ");
INSERT INTO tsn_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Gonne se ga se tlhaloganyo ya me, mme ke lo boleletse se Rara a rileng ke se lo bolelele. ");
INSERT INTO tsn_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mme ke itse gore ditaolo tsa gagwe di gogela kwa botshelong jo bo sa khutleng; jalo sengwe le sengwe se a reng ke se bue, ke a se bua!” ");
INSERT INTO tsn_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","3","Jesu o ne a itse mo maitseboeng a tsatsi la Tlolaganyo gore ke bosigo jwa gagwe jwa bofelo mo lefatsheng pele ga a boela kwa go Rraagwe. Erile go jewa dijo tsa maitseboa Diabolo a bo a setse a feditse mogopolo wa ga Judase Isekariota, morwa Simone, gore jo ke bosigo jwa gore a dirise leano la gagwe la go oka Jesu. Jesu o ne a itse gore Rara o mo neetse sengwe le sengwe le gore o ne a tswa kwa Modimong le gore o tlaa boela kwa Modimong. Le ka fa a neng a rata barutwa ba gagwe ka teng! ");
INSERT INTO tsn_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mme a tswa fa lomating lwa bojelo, (tafole) a apola seaparo sa gagwe, a thathelela toulo (taole) mo lothekeng, ");
INSERT INTO tsn_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","a tshela metsi mo mogotswaneng mme a simolola a tlhapisa barutwa ba gagwe dinao a ba a di phimola ka taole e a neng a ithathile ka yone. ");
INSERT INTO tsn_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Erile a tla fa go Simone Petere, Petere a mo raya a re, “Morena, ga o a tshwanela o ka bo o re tlhapisa dinao!” ");
INSERT INTO tsn_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesu a fetola a re, “Ka nako e ga o tlhaloganye se ke se dirang, mme o tlaa tlhaloganya ka letsatsi lengwe.” ");
INSERT INTO tsn_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petere a gana a re, “Nnyaa, ga o kitla o ntlhapisa dinao gope!” Mme Jesu a fetola a re, “Kana fa ke sa di tlhapise, ga o kake wa nna mopati wa me.” ");
INSERT INTO tsn_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simone Petere a mo raya a re, “Mme tlhapisa diatla tsa me le tlhogo, e seng dinao fela!” ");
INSERT INTO tsn_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesu a fetola a re, “Yo o setseng a tlhapile mmele otlhe o tlhoka go tlhapisiwa dinao fela gore a nne phepa gotlhelele. Jaanong o phepa, mme ga go a nna jalo mo go mongwe le mongwe yo o fano.” ");
INSERT INTO tsn_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Gonne Jesu o ne a itse gore o tlaa okwa ke mang. Ke sone se a neng a se raya fa a re, “Ga lo phepa lotlhe.” ");
INSERT INTO tsn_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Erile a sena go ba tlhapisa dinao, a apara seaparo sa gagwe gape mme a nna fa fatshe a botsa potso a re, “A lo tlhaloganya se ke neng ke se dira? ");
INSERT INTO tsn_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Lo mpitsa ‘Moruti’ le ‘Morena’, mme lo dira sentle go bua jalo, gonne ke boammaaruri. ");
INSERT INTO tsn_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mme ka nna, Morena, le Moruti, ke lo tlhapisitse dinao, lo tshwanetse go tlhapisanya dinao fela jalo. ");
INSERT INTO tsn_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ke lo neile sekai se lo tshwanetseng go se sala morago: dirang jaaka ke lo diretse. ");
INSERT INTO tsn_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Go boammaaruri thata jang gore motlhanka ga a mogolo go mong wa gagwe. Le fa e le morongwa ga a mogolo go motho yo o mo romang. ");
INSERT INTO tsn_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Lo itse dilo tse, jaanong di direng! Ke yone tsela ya matlhogonolo. ");
INSERT INTO tsn_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ga ke lo reye lotlhe; ke itse mongwe le mongwe wa lona yo ke mo tlhophileng sentle. Lokwalo lo bua jaana lwa re, ‘Ene yo o jang dijo le nna o tlaa nkoka’ mme se ke se buang se tlaa tloga se diragala. ");
INSERT INTO tsn_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mme ke lo bolelela selo se jaanong jaana gore e re fa se diragala, lo dumele mo go nna. ");
INSERT INTO tsn_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","“Ammaaruri, le fa e le mang yo o amogelang Morongwa wame, yo ke tlaa mo romang, o amogela nna. Mme go nkamogela ke go amogela Rara yo o nthomileng.” ");
INSERT INTO tsn_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Mme jaanong Jesu o ne a huduegile thata mo moeng mme a re, “Ee, go boammaaruri, mongwe wa lona o tlaa nkoka.” ");
INSERT INTO tsn_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Barutwa ba lebana, ba hakgamala gore o ka ne a raya mang. ");
INSERT INTO tsn_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","E re ka ke ne ke ntse go bapa le Jesu fa lomating lwa bojelo (tafole) ke le tsala ya gagwe e tona thata, ");
INSERT INTO tsn_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simone Petere a tla kwa go nna go mpotsa gore ke mang yo o tlaa dirang tiro e e setlhogo eo ya go mo oka. ");
INSERT INTO tsn_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mme ka retologa ka mmotsa ka re, “Morena, ke mang?” ");
INSERT INTO tsn_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","A mphetola a re, “Ke yo ke mo tlotlang ka go mo neela senkgwe se innwe mo morong.” Mme erile a sena go se ina, a se inola a se neela Judase, morwa Isekariota. ");
INSERT INTO tsn_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Mme ya re Judase a sena go se ja, Satane a tsena mo go ene. Mme Jesu a mo raya a re, “Itlhaganele, dira se o se ikaeletseng jaanong jaana.” ");
INSERT INTO tsn_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Go ne go sena le fa e le ope wa ba ba fa lomating lwa bojelo yo o neng a itse se Jesu o se rayang. ");
INSERT INTO tsn_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bangwe ba gopola gore ka Judase e ne e le mmei wa madi a bone Jesu o ne a mmolelela gore a ye go duelela dijo kgotsa a ye go abela bahumanegi madi mangwe. ");
INSERT INTO tsn_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judase a nanoga ka bofefo, a ralala lefifi. ");
INSERT INTO tsn_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Erile fela Judase a tswa mo tlung, Jesu a re, “Lobaka lwa me lo gorogile; kgalalelo ya Modimo e tlaa tloga e ntikaganyetsa, mme Modimo o tlaa amogela kgalaletso e tona ka ntlha ya gotlhe mo go ntiragalelang. ");
INSERT INTO tsn_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Mme Modimo o tlaa nnaya kgalalelo ya one, fela jaanong jaana. ");
INSERT INTO tsn_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bana ba ba rategang, kana nako e khutshwane jang pele ga gore ke tsamaye ke lo tlogele! Mme, le fa lo ka ntshenka ga lo ka ke lwa tla kwa go nna, fela jaaka ke boleletse baeteledipele ba Sejuta. ");
INSERT INTO tsn_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Jaanong ke lo naya taolo e ncha ka re, ‘Ratanang fela jaaka ke lo ratile.’ ");
INSERT INTO tsn_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Go ratana ga lona mo go kitlaneng go tlaa supegetsa lefatshe gore lo barutwa ba me.” ");
INSERT INTO tsn_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simone Petere a re, “Morena o ya kae?” Mme Jesu a fetola a re, “Ga o ka ke wa tsamaya le nna jaanong jaana; mme e tlaa re morago, o ntatele.” ");
INSERT INTO tsn_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Mme Simone Petere a mmotsa a re, “Mme ke kganelwa ke eng go tla jaanong jaana gonne ke ipaakanyeditse go go swela?” ");
INSERT INTO tsn_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesu a araba a re, “O ntshwela? Nnyaa e tlaa re pele ga mokoko o lela gararo ka moso o tlaa bo o intatotse o re ga o nkitse.” ");
INSERT INTO tsn_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“A dipelo tsa lona di se fuduege. Lo ikanya Modimo, jaanong inkanyeng le nna. ");
INSERT INTO tsn_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","3","Go na le malapa a le mantsi kwa godimo kwa Rara o nnang teng, mme ke ya go a baakanyetsa go tla ga lona. Fa go setse go siame gotlhe, mme ke tlaa tla go lo tsaya, gore lo nne le nna ka metlha yotlhe kwa ke teng. Fa go ne go sa nna jalo nkabo ke lo boleletse sentle fela. ");
INSERT INTO tsn_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mme lo itse kwa ke yang teng le tsela e e yang teng lo a e itse.” ");
INSERT INTO tsn_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomase a mo raya a re, “Nnyaa, ga re itse, ga re na kitso epe ya kwa o yang teng, jaanong re ka itse tsela jang?” ");
INSERT INTO tsn_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Mme Jesu a mo raya a re, “Ke nna Tsela, ee, le Boammaaruri le Botshelo. Ga go na ope yo o ka tlang kwa go Rara fa e se ka nna. ");
INSERT INTO tsn_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Fa lo ne lo itsile gore ke mang, hong lo ka bo lo itsile gore Rre ke mang. Go tloga fano lo a mo itse, ebile lo mmonye!” ");
INSERT INTO tsn_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo a mo raya a re, “Morena, re supegetse Rara mme go tlaa bo go re lekanye.” ");
INSERT INTO tsn_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesu a fetola a re, “A ga o ise o nkitse Filipo, le fa ke sa bolo go nna le wena ka lobaka lo lo kana? Le fa e le mang yo o mponyeng o bonye Rre! Jaanong ke eng fa o kopa go mmona? ");
INSERT INTO tsn_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","A ga o dumele gore ke mo go Rara yo o agileng mo go nna. Ebile o dira tiro ya gagwe ka nna. ");
INSERT INTO tsn_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Dumela fela gore ke mo go Rara ebile le Rara o mo go nna. E seng jalo dumela ka ntlha ya dikgakgamatso tse dikgolo tse o mponyeng ke di dira. ");
INSERT INTO tsn_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","13","“Ka boammaaruri jo bo feletseng ke lo bolelela gore, le fa e le mang yo o dumelang mo go nna o tlaa dira dikgakgamatso tse ke di dirileng, gonne ke ya go nna le Rara. Lo ka mo kopa sengwe le sengwe lo dirisa leina la me, mme ke tlaa se dira, gonne mo go tlaa lere kgalaletso kwa go Rara ka ntlha ya se nna, Morwa, ke tlaa se lo direlang. ");
INSERT INTO tsn_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ee, lopang le fa e le eng lo dirisa leina la me mme ke tlaa se dira!” ");
INSERT INTO tsn_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","16","“Fa e le gore lo a nthata, inkokobeletseng; mme ke tlaa kopa Rara mme o tlaa lo naya Mogomotsi yo mongwe, mme ga a kitla a lo tlogela. ");
INSERT INTO tsn_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mogomotsi yoo ke Mowa O O Boitshepo, Mowa o o gogelang mo boammaaruring jotlhe. Lefatshe ka bophara ga le ka ke la o amogela, gonne ga le o batle ebile ga le o itse. Mme lona lo a mo itse gonne o nna le lona gompieno, mme mo malatsinyaneng a a latelang o tlaa bo o le mo go lona. ");
INSERT INTO tsn_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nnyaa, ga ke na go lo latlha kgotsa go lo tlogela lo le masiela mo setsuatsueng, ke tlaa tla kwa go lona. ");
INSERT INTO tsn_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mo lobakanyaneng ke tlaa bo ke tsamaile ke dule mo lefatsheng, mme ke tlaa bo ke sa ntse ke na le lona. Gonne ke tlaa tshela gape, mme le lona lo tlaa tshela. ");
INSERT INTO tsn_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","E tlaa re fa ke boela mo botshelong gape, lo tlaa itse gore ke mo go Rre, mme lona lo mo go nna le nna ke mo go lona. ");
INSERT INTO tsn_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ene yo o inkobelang ke ene yo o nthatang; mme ka ntlha ya gore o a nthata, Rara o tlaa mo rata; mme le nna ke tlaa mo rata, ke tlaa mo itshenolela.” ");
INSERT INTO tsn_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judase, (eseng Judase Isekariota, mme e leng morutwa yo mongwe wa gagwe yo o bidiwang ka leina leo le ene) a mo raya a re, “Morena, ke eng fa e le gore o tlaa itshenolela rona barutwa fela e seng lefatshe ka bophara?” ");
INSERT INTO tsn_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesu a fetola a re, “Gonne ke tlaa itshenolela ba ba nthatang le ba ba inkobelang. Rara le ene o tlaa ba rata, mme re tlaa tla kwa go bone go nna nabo. ");
INSERT INTO tsn_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Le fa e le mang yo o sa inkobelang ga a nthate. Mme gakologelwang, ga se nna ke arabang potso ya lona ka go bua jaana! Ke karabo e e tswang mo go Rara yo o nthomileng. ");
INSERT INTO tsn_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ke lo bolelela dilo tse gompieno ke sa ntse ke na le lona. ");
INSERT INTO tsn_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mme fa Rara a roma Mogomotsi mo boemong jwa me, mme ka Mogomotsi ke raya Mowa O O Boitshepo, o tlaa lo ruta go le go ntsi thata, le go lo gakolola sengwe le sengwe se nna ke se lo boleletseng. ");
INSERT INTO tsn_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ke lo tlogela ka mpho, ebong, kagiso ya pelo le mogopolo. Mme kagiso e ke e lo nayang ga e senyege jaaka kagiso e lo e newang ke lefatshe. Mme ke gona se tshwenyegeng kgotsa lwa boifa. ");
INSERT INTO tsn_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Gakologelwang se ke se lo boleletseng, ke a tsamaya, le gale ke tlaa boela kwa go lona gape. Fa e le gore lo a nthata, lo tlaa intumelela, gonne jaanong nka ya kwa go Rara, yo o leng mogolo mo go nna. ");
INSERT INTO tsn_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ke lo boleletse dilo tse pele ga di diragala gore ere di diragala, lo tle lo ntumele. ");
INSERT INTO tsn_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Ga ke nako e ntsi ya go bua le lona, gonne Kgosana e e bosula ya lefatshe leno e a atamela. Ga e na nonofo epe mo go nna, ");
INSERT INTO tsn_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","mme ke tlaa dira ka kgololesego se Rara o se batlang mo go nna gore lefatshe le tle le itse fa ke rata Rara. Tlang, a re tsamayeng.” ");
INSERT INTO tsn_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ke nna mofine wa boammaaruri, mme Rara ke ene mmaakanyi wa tshimo. ");
INSERT INTO tsn_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","O kgaola kala nngwe le nngwe e e sa ungweng. Mme o ntlafatsa dikala tse di ungwang gore di ungwe thata. ");
INSERT INTO tsn_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","O setse a bile a lo ntlafaditse ka go lo ntlafaletsa mo go ene gore lo nne le nonofo e kgolo thata le tiriso ka ditaolo tse ke di lo neileng. ");
INSERT INTO tsn_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Elang tlhoko gore lo nne mo go nna, le nna ke nne mo go lona. Gonne ga e kake ya re kala e kgaotswe mo mofineng ya ungwa, le lona ga lo kake lwa ungwa kwa ntle ga me. ");
INSERT INTO tsn_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ee, ke mofine; lona lo dikala. Lefa e le mang yo o nnang mo go nna le nna ke nna mo go ene, o tlaa ungwa loungo lo logolo. Gonne ga go na sepe se lo ka se dirang kwa ntle ga me. ");
INSERT INTO tsn_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Fa mongwe a ikgaoganya le nna, o latlhwa jaaka kala e e senang molemo, e omelela, e phuthwa le tse dingwe mme di tshujwe. ");
INSERT INTO tsn_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mme fa lo nna mo go nna lo reetsa ditaolo tsa me, lo ka kopa kopo nngwe fela e lo e ratang, mme lo tlaa e newa! ");
INSERT INTO tsn_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Barutwa ba me ba boammaaruri ba ungwa thobo e kgolo thata. Mme go tlisa kgalalelo e kgolo thata mo go Rre. ");
INSERT INTO tsn_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Ke lo ratile fela jaaka Rara a nthatile. Nnang mo loratong lwa me. ");
INSERT INTO tsn_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Fa lo inkobela, lo nna mo loratong lwa me, fela jaaka ke reetsa Rara ebile ke nna mo loratong lwa gagwe. ");
INSERT INTO tsn_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ke lo boleletse se gore lo tlale boitumelo jwa me. Ee, senwelo sa lona sa boitumelo se tlaa penologa. ");
INSERT INTO tsn_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ke batla gore lo ratane fela jaaka ke lo rata. ");
INSERT INTO tsn_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mme lorato lo lekanngwa jaana, lorato lo logolo lo supega fa motho a ntshetsa ditsala tsa gagwe botshelo jwa gagwe; ");
INSERT INTO tsn_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","mme lona lo ditsala tsa me fa lo inkobela. ");
INSERT INTO tsn_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ga ke sa tlhole ke lo bitsa batlhanka gonne mong wa batlhanka ga a ba rerise sepe; lo ditsala tsa me jaanong, gonne go supiwa ke lobaka lwa gore ke lo boleletse sengwe le sengwe se Rara o se mpoleletseng. ");
INSERT INTO tsn_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Ga lo a ntlhopha! Ke nna ke lo tlhophileng! Ke lo tlhomile go ya go ntsha maungo a mantle malatsi otlhe, gore le fa e le eng se lo se kopang mo go Rara, lo dirisa leina la me, o tlaa se lo neela. ");
INSERT INTO tsn_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ke batla gore lo ratane. ");
INSERT INTO tsn_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Gonne lo ilwa ke lefatshe thata! Mme nna lefatshe le sale le nkila pele ga lona. ");
INSERT INTO tsn_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Lefatshe le ne le ka lo rata fa lo ne lo le ba lone; mme ga lo ba lone, gonne ke lo tlhophetse go tswa mo lefatsheng, mme jalo le a lo ila. ");
INSERT INTO tsn_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","A lo gakologelwa se ke se lo boleletseng? ‘Motlhanka ga a mogolo mo go mong wa gagwe!’ mme ereka ba mpogisitse, le lona fela jalo ba tlaa lo bogisa. Mme fa ba ka bo ba ne ba ntheetsa, ba ne ba tlaa lo reetsa. ");
INSERT INTO tsn_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Batho ba lefatshe ba tlaa lo bogisa gonne lo ba me, gonne ga ba itse Modimo o e leng one o nthomileng. ");
INSERT INTO tsn_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Ba ka bo ba se molato fa nkabo ke sa tla ka buisanya nabo. Mme jaanong ga ba na seipato ka ntlha ya dibe tsa bone. ");
INSERT INTO tsn_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Le fa e le mang yo o nkilang, o ila Rara. ");
INSERT INTO tsn_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Fa nkabo ke sa dira dikgakgamatso tse dikgolo jaana mo go bone ba ka bo ba sa tsewe ba le molato. Mme jaanong jaaka go ntse, ba bonye dikgakgamatso tse, mme ba re ila rotlhe, Nna le Rara. ");
INSERT INTO tsn_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mo go diragatsa se baporofiti ba se buileng ka ga Mesia ba re, ‘Ba nkidile ke sena molato.’ ");
INSERT INTO tsn_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Mme ke tlaa lo romelela Mogomotsi, Mowa O O Boitshepo, motswedi wa boammaaruri jotlhe. O tlaa tswa kwa go Rara mme o tlaa lo bolelela gotlhe ka ga me. ");
INSERT INTO tsn_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mme le lona lo tshwanetse go bolelela mongwe le mongwe ka ga me, gonne lo ntse lo na le nna go tswa kwa tshimologong.” ");
INSERT INTO tsn_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ke lo boleletse dilo tse gore lo seka lwa etsaetsega (ka ga dilo tse di kwa pele). ");
INSERT INTO tsn_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Gonne lo tlaa kgaolwa mo matlung a thuto, mme tota lobaka lo, e tla nna lo ka lone babolai ba lona ba tlaa gopolang gore ba dira tiro ya Modimo. ");
INSERT INTO tsn_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Se ke ka ntlha ya gore ga go nako epe e ba kileng ba itse Rara le fa e le nna. ");
INSERT INTO tsn_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ee, ke lo bolelela dilo tse gompieno gore e tle e re di diragala lo tlo lo gakologelwe gore ke lo tlhagisitse. Ga ke ise ke ko ke lo bolelele le fa e le sepe gonne ke ne ke tsile go nna le lona ka lobaka lo lo leejana. ");
INSERT INTO tsn_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Mme jaanong ke a tsamaya ke boela kwa go yo o nthomileng; mme go bonala fa e le gore ga go na ope wa lona yo o nang le kgatlhego mo lebakeng la go tsamaya ga me; le fa e le ope ga a hakgamale. ");
INSERT INTO tsn_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mo boemong jwa go dira jalo lo tletse bohutsana fela. ");
INSERT INTO tsn_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mme boammaaruri ke gore, go lo solegela molemo fa ke tsamaya, gonne fa ke sa tsamaye, Mogomotsi ga a na go tla. Fa ke tsamaya, o tlaa tla, gonne ke tlaa mo romela kwa go lona. ");
INSERT INTO tsn_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“Mme fa a sena go tla, o tlaa senolela lefatshe boleo jwa lone, le gore tshiamo ya Modimo e teng, le kgololo mo katlholong. ");
INSERT INTO tsn_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Boleo jwa lefatshe ke go sa dumeleng mo go Nna; ");
INSERT INTO tsn_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","mme tshiamo e teng gonne ke ya kwa go Rara mme ga lo na go tlhola lo mpona gape; ");
INSERT INTO tsn_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","go na le go gololwa mo katlholong gonne kgosana ya lefatshe leno e setse e bile e atlhotswe. ");
INSERT INTO tsn_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Oo, go sa ntse go na le dilo di le dintsi tse ke batlang go di lo bolelela, mme ga lo ka ke lwa di tlhaloganya jaanong jaana. ");
INSERT INTO tsn_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Fa Mowa O O Boitshepo, o e leng boammaaruri, o tla, o tlaa lo gogela mo boammaaruring jotlhe, mme o tlaa bo o sa bue mafoko a one; mme o tlaa bo o lo bolelela se o se utlwileng. O tlaa lo bolelela kaga dilo tse di tlaa tlang. ");
INSERT INTO tsn_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","O tlaa nkgalaletsa a bo a nteretse tlotlo e kgolo ka go lo bontsha kgalalelo ya me. ");
INSERT INTO tsn_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kgalalelo yotlhe ya ga Rara ke ya me; ke sone se ke se rayang fa ke re o tlaa lo supegetsa kgalalelo ya me. ");
INSERT INTO tsn_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","E tlaa re fela mo lobakanyaneng morago ga moo, lo tlaa mpona gape!” ");
INSERT INTO tsn_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","18","Mme bangwe ba barutwa ba gagwe ba re, “A reng? Ke eng se a se rayang fa a re ke ya kwa go Rara? Rona ga re tlhaloganye se a se rayang.” ");
INSERT INTO tsn_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesu a lemoga gore ba batla go mmotsa, mme a ba botsa a re, “A lo ipotsa se ke se rayang? ");
INSERT INTO tsn_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Lefatshe le tlaa itumela thata kaga se se tsileng go ntiragalela, mme lona lo tlaa lela. Mme e tlaa re ka bonako selelo sa lona se fetoge boitumelo jo bogolo (fa lo mpona gape). ");
INSERT INTO tsn_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","E tlaa bo e le boitumelo jo bo tshwanang le jwa mosadi a le mo ditlhabing fa a tshola ngwana wa gagwe, hong ditlhabi tse di lebalwe gotlhelele. ");
INSERT INTO tsn_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Gompieno jaana lo futsafetse, mme ke tlaa lo bona gape, mme lo tlaa itumela, mme ga gona ope yo o ka lo tseelang boitumelo joo. ");
INSERT INTO tsn_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ka nako eo ga lo na go tlhokana le go nkopa sepe, gonne lo tlaa bo lo ka tlhamalalela kwa go Rara go mo kopa, mme o tlaa lo naya se lo tlaa bong lo se kopa gonne lo tlaa bo lo dirisa leina la me. ");
INSERT INTO tsn_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ga lo ise lo ke lo leke go dira jaana pele, (mme simololang gompieno). Kopang, lo dirisa leina la me. Mme lo tlaa amogela, mme senwelo sa lona sa boitumelo se tlaa penologa. ");
INSERT INTO tsn_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ke buile kaga dilo tse ke itisitse mo puong, mme nako e tlaa tla fa go itisa mo puong go tlaa bo go sa tlhokege mme ke tlaa lo bolelela sentle thata gotlhe ka ga Rara. ");
INSERT INTO tsn_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mme lo tlaa lere dikopo tsa lona ka leina la me! Mme ga nkitla ke tlhoka go kopa Rara go lo naya dikarabo tsa dikopo tse, ");
INSERT INTO tsn_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","gonne Rara ene o lo rata fela thata ka gore lo a nthata ebile lo dumela gore ke tsile ke tswa kwa go Ene. ");
INSERT INTO tsn_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ee, ke tsile ke tswa kwa go Rara fa ke tla mo lefatsheng, mme ke tlaa tswa mo lefatsheng ke boela kwa go Rara.” ");
INSERT INTO tsn_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mme barutwa ba gagwe ba re, “Jaanong o bua sentle thata, eseng ka diane. ");
INSERT INTO tsn_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Jaanong re tlhaloganya gore o itse sengwe le sengwe ebile ga o tlhoke ope go go bolelela sepe. Jaanong ka ntlha ya one mabaka a, re dumela gore o tsile o tswa kwa Modimong.” ");
INSERT INTO tsn_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Mme Jesu a ba raya a re, “A jaanong lo dumela se ke se buang? ");
INSERT INTO tsn_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mme lobaka lo e tla, le gone tota lo setse lo fitlhile, fa lo tlaa phatlalala, mongwe le mongwe a boela kwa legaeng la gagwe, a ntlogela ke le nosi. Le fa go ntse jalo ke tlaa bo ke se nosi, gonne Rara o na le nna. ");
INSERT INTO tsn_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ke lo boleletse mo gotlhe gore lo tle lo nne le kagiso mo mogopolong le mo pelong. Lo tlaa nna le meleko e mentsi le dikutlobotlhoko fano mo lefatsheng; mme lo itumele thata, gonne ke fentse lefatshe.” ");
INSERT INTO tsn_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Erile fa Jesu a sena go fetsa go bua dilo tse tsotlhe, a lelalela kwa legodimong mme a re, “Rara, Nako e gorogile. Senola kgalalelo ya ga Morwao gore a tle a kgone go e busetsa kwa go wena. ");
INSERT INTO tsn_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Gonne o mo neile taolo mo godimo ga banna le basadi mo lefatsheng lotlhe. O neela mongwe le mongwe botshelo jo bo sa khutleng jo o bo mo neileng. ");
INSERT INTO tsn_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mme tsela e e isang botshelong jo bosa khutleng ke e—ke ka go go itse wena Modimo o o boammaaruri o le esi, le Jesu Keresete, ene yo o mo romileng mo lefatsheng! ");
INSERT INTO tsn_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ke go lereditse kgalalelo mo lefatsheng ka go dira sengwe le sengwe se o ntheileng wa re ke se dire. ");
INSERT INTO tsn_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mme jaanong, Rara, senola kgalalelo ya me jaaka ke eme fa pele ga gago, kgalalelo e re neng ra e tlhakanela pele ga lefatshe le simologa. ");
INSERT INTO tsn_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ke boleletse batho, ba, gotlhe ka ga gago. Ba ne ba le mo lefatsheng, mme wa ba nneela. Tota tota e ne e le ba gago ka malatsi otlhe, mme wa ba nnaya, mme ba go reetsa. ");
INSERT INTO tsn_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Jaanong ba itse gore sengwe le sengwe se ke nang naso ke mpho e e tswang kwa go wena, ");
INSERT INTO tsn_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","gonne ke ba neetse melao e o e nneetseng; mme ba e amogetse ebile ba itse ka botlalo gore ke tsile mo lefatsheng ke tswa kwa go wena, jalo ba dumela fa o nthomile. ");
INSERT INTO tsn_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Thapelo ya me ga se go rapelela lefatshe, mme ke go rapelela ba o ba nneileng gonne ke ba gago. ");
INSERT INTO tsn_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Mme botlhe fela, ka e le ba me, ke ba gago; mme o ba buseditse mo go nna ka sengwe le sengwe se e leng sa gago, jalo ba o ba nneileng ke kgalalelo ya me! ");
INSERT INTO tsn_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Jaanong ke tloga mo lefatsheng, mme ke ba tlogela kwa morago, ke tla kwa go wena. Rara yo o Boitshepo, ba babalele, botlhe ba o ba nneileng, gore ba nne selo se le sengwe fela jaaka re ntse, go sa latlhega ope. ");
INSERT INTO tsn_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ka nako ya fa ke sa ntse ke le mono, ke bolokile batho botlhe ba o ba nneileng ba lwapa lwa gago. Ke ne ka ba tlhokomela gore le fa e le ope wa bone a seka a nyelela, fa e se morwa tatlhego fela fela jaaka dikwalo di boletse pele. ");
INSERT INTO tsn_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Mme jaanong ke tla kwa go wena. Ke ba boleletse dilo tse dintsi fa ke sa ntse ke na le bone gore ba tle ba tlale boitumelo jwa me. ");
INSERT INTO tsn_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ke ba neetse ditaolo tsa gago. Mme lefatshe le a ba ila gonne ga ba dire mekgwa ya lone e e maswe, fela jaaka nna ke sa e dire. ");
INSERT INTO tsn_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ga ke go kope gore o ba ntshe mo lefatsheng, mme ke kopa gore o ba boloke ba se ka ba wela mo nonofong ya ga Satane. ");
INSERT INTO tsn_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ga ba sa tlhole e le ba lefatshe leno jaaka le nna ke se wa lone. ");
INSERT INTO tsn_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ba ntlafatse o ba itshepise ka go ba ruta mafoko a gago a boammaaruri. ");
INSERT INTO tsn_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Fela jaaka o nthomile mo lefatsheng, le nna ke ba roma mo lefatsheng. ");
INSERT INTO tsn_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mme ke ineela gore ke ba thuse mo ditlhokong tsa bone tsa go gola mo boammaaruring le mo boitshepong. ");
INSERT INTO tsn_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ga ke rapelele fela ba, mme ke rapelela le badumedi ba malatsi a a tlang ba ba tlaa tlang kwa go nna ka ntlha ya bosupi jwa bone ba. ");
INSERT INTO tsn_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Go ba rapelela ga me botlhe ke gore ba nne pelo e le nngwe le mogopolo o le mongwe fela jaaka wena le nna re ntse, Rara. Gore fela jaaka o le mo go nna le nna ke le mo go wena, le bone ba tle ba nne mo go rona, jalo lefatshe le tlaa dumela fa o nthomile. ");
INSERT INTO tsn_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","“Ke ba neile kgalalelo e o e nneileng, kopano e e galalelang ya go bopagana, jaaka re ntse, ");
INSERT INTO tsn_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nna ke le mo go bone le wena o le mo go nna, botlhe ba ntlafaleditswe mo go bopaganeng, gore lefatshe le tle le itse fa o nthomile le bo le tlhaloganye gore o ba rata fela jaaka o nthata. ");
INSERT INTO tsn_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Rara, ke batla gore ba o ba nneetseng ba, ba nne le nna kwa ke gone, gore ba tle ba bone kgalalelo ya me. O nneetse kgalalelo gonne o sale o nthata pele ga lefatshe le simologa! ");
INSERT INTO tsn_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Oo Rara yo o tshiamo, lefatshe ga le go itse, mme nna ke a go itse; le barutwa ba, ba itse fa o nthomile. ");
INSERT INTO tsn_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mme ke go senotse mo go bone, jalo ke tlaa nna ke go senola gore lorato lwa gago lo logolo lo o ntshotseng ka lone lo nne mo go bone, le nna ke nne mo go bone.” ");
INSERT INTO tsn_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Mme erile Jesu a sena go bua dilo tse, a kgabaganya molatswana wa Kide-rona le barutwa ba gagwe mme a tsena mo sekgweng sa lotlhware. ");
INSERT INTO tsn_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judase wa moraedi, o ne a itse lefelo le, gonne Jesu o ne a sa bolo go nna a ya teng gantsi le barutwa ba gagwe. ");
INSERT INTO tsn_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ditlhogo tsa baperesiti le Bafarasai di ne di neetse Judase segopa sa masole le mapodisi go mo pata. Mme ba goroga mo sekgweng sa lotlhware ba tshotse dipone tsa mefuta e farologanye ba tshotse le ditlhabani. ");
INSERT INTO tsn_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","5","Jesu a tlhaloganya ka botlalo se se neng se ya go mo diragalela. Erile a tsamaela kwa pele go ba kgatlhantsha a re, “Lo batla mang?” Mme ba mo fetola ba re, “Jesu wa Nasaretha.” Mme Jesu a ba raya a re, “Ke nna.” ");
INSERT INTO tsn_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Mme erile a bua jalo, botlhe ba boela kwa morago ba wela fa fatshe. ");
INSERT INTO tsn_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Mme a ba botsa gape a re, “Lo batla mang?” Mme ba mo fetola gape ba re, “Jesu wa Nasaretha.” Mme Jesu a ba raya a re, ");
INSERT INTO tsn_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Ke lo reile ka re ke Nna, mme ka ke Nna yo lo mpatlang, tlogelang ba bangwe ba, ba tsamaye.” ");
INSERT INTO tsn_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","O ne a dira jaana go diragatsa seporofeso se a neng a setse a se buile a re, “Ga ke a latlhegelwa ke ope mo go ba o ba nneileng.” ");
INSERT INTO tsn_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Mme Simone Petere a somola chaka a kgaola “tsebe e e ka fa letsogong la moja ya ga Maleko motlhanka wa moperesiti yo mogolo”. ");
INSERT INTO tsn_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Mme Jesu a raya Petere a re, “Somela chaka ya gago. A ga ke a tshwanela go nwa mo senwelong se Rara o se nneileng?” ");
INSERT INTO tsn_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mme mapodisi a Sejuta le masole le maotlana a tshwara Jesu a mo golega. ");
INSERT INTO tsn_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ba mo tseela “pele” kwa go Anase mogwagadia Kaiafase, Moperesiti yo mogolo mo ngwageng eo. ");
INSERT INTO tsn_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiafase e ne e le ene yo o reileng baeteledipele ba Sejuta a re go botoka gore motho a le mongwe fela a swele batho botlhe. ");
INSERT INTO tsn_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simone Petere a ba sala morago, jaaka yo mongwe wa barutwa yo ene a neng a tsalanye le Moperesiti yo Mogolo a ne a dira ");
INSERT INTO tsn_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","fa Petere a eme fa ntle ga kgoro ya batsena. Mme Morutwa yo a buisanya le mosetsana yo o tlhokometseng kwa kgorong, mme a letlelela Petere go tsena. ");
INSERT INTO tsn_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mosetsana a botsa a re, “A ga o mongwe wa barutwa ba ga Jesu?” Mme Petere a re, “Nnyaa ga ke mongwe wa bone.” ");
INSERT INTO tsn_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Mme mapodise le batlhanka ba mo lwapeng ba ne ba eme ka dinao ba dikologile molelo o ba neng ba o gotsitse gonne go ne go le serame. Mme Petere a nna foo le bone a ikomosa. ");
INSERT INTO tsn_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mme mo teng ga kgotla ya tshekelo Moperesiti yo Mogolo a simolola go botsa Jesu kaga barutwa ba gagwe le se a neng a ntse a se ba ruta. ");
INSERT INTO tsn_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesu a fetola a re, “Se ke se rutang se itsege ka bophara, gonne ke rutile ka gale mo disenagogeng le mo Tempeleng; ke utlwilwe ke baeteledipele ba Sejuta botlhe mme ga ke rute sepe mo sephiring se ke sa se buang mo ponong ya mongwe le mongwe. ");
INSERT INTO tsn_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ke eng fa o mpotsa potso e? Botsa ba ba nkutlwileng. O na le bangwe ba bone fano. Ba itse se ke se buileng.” ");
INSERT INTO tsn_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Mongwe wa masole a a emeng foo a ngadibola Jesu ka lebole a mmotsa a re, “A ke yone tsela ya go araba Moperesiti yo Mogolo eo?” ");
INSERT INTO tsn_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Mme Jesu a fetola a re. “Fa ke buile maaka, ntsha bosupi, a o tshwanetse go iteela motho go bua boammaaruri?” ");
INSERT INTO tsn_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Mme Anase a romela Jesu a golegilwe kwa go Kaiafase Moperesiti yo Mogolo. ");
INSERT INTO tsn_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mme ya re ka lobaka loo, fa Simone Petere a sa ntse a eme fa molelong, a bodiwa gape gatwe, “A ga o mongwe wa barutwa ba gagwe?” Mme ene a fetola a re, “Nnyaa,” ");
INSERT INTO tsn_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mme mongwe wa batlhanka ba mo lwapeng lwa Moperesiti yo mogolo, wa losika lwa monna yo o neng a kgaotswe tsebe ke Petere, a botsa a re, “A ga ke a go bona kwa sekgweng sa lotlhware o na le Jesu?” ");
INSERT INTO tsn_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Mme Petere a itatola gape. Mme ka bofefo mokoko wa lela. ");
INSERT INTO tsn_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Go sekisiwa ga ga Jesu ke Kaiafase ga fela maphakela thata. Go tsweng foo a tseelwa kwa kgotleng ya Molaodi wa Mmuso wa Roma. Basekisi ba gagwe ba seka ba tsena mo teng gonne ba ne ba re, go ne go tlaa ba “itshekolola”, le gone ba ne ba sena go letlelelwa go ja kwanyana ya Tlolaganyo. ");
INSERT INTO tsn_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mme Pilatwe molaodi wa mmuso wa Roma, a ya kwa ntle kwa go bone a botsa a re, “Lo bona monna yo molato wa eng? Lo mmona molato wa go dira eng.” ");
INSERT INTO tsn_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Mme ba fetola ka go gakala ba re, “Fa e ka bo ene e se serukutlhi re ka bo re sa mo tshwara!” ");
INSERT INTO tsn_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Mme Pilatwe a ba raya a re, “Mo tseyeng lo mo atlhole lo le nosi ka melao ya lona.” Mme ba re, Mme kana re batla a bapolwa, mme, re batla tetlelelo ya gago ");
INSERT INTO tsn_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Se se ne sa rurifatsa kakanyetsopele ya ga Jesu ka ga tsela e a tla bolawang ka yone. ");
INSERT INTO tsn_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Mme Pilatwe a boela kwa kgotleng ya gagwe ya tshekelo a laola gore Jesu a leriwe kwa go ene. Ammotsa a re, “A o Kgosi ya Bajuta?” ");
INSERT INTO tsn_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesu a botsa a re, “A le wena wa re ke ‘Kgosi’ kgotsa o bua kafa Bajuta ba buang ka teng.” ");
INSERT INTO tsn_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatwe a botsa ka kgakalo a re, “A ke Mojuta? Batho ba gaeno le ditlhogo tsa bone tsa baperesiti ba go lerile kwano. Ka ntlha yang? O dirile eng?” ");
INSERT INTO tsn_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Mme Jesu a araba a re, “Ga ke Kgosi ya lefatshe. Fa ke ne ke le yone, balatedi ba me ba ka bo ba lole fa ke tshwarwa ke baeteledipele ba Sejuta. Mme bogosi jwa me ga se jwa lefatshe.” ");
INSERT INTO tsn_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatwe a fetola a re, “Ee, fa e le gore go ntse jalo o Kgosi?” Jesu a re, “Ee, ke tsaletswe gone moo. Mme ke tletse go lere boammaaruri mo lefatsheng. Botlhe ba ba ratang boammaaruri ke balatedi ba me.” ");
INSERT INTO tsn_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatwe a botsa a re, “Boammaaruri ke eng?” Mme a boela a tswela gape kwa ntle kwa bathong a ba raya a re, “Ga a na molato ope wa borukutlhi motho yo. ");
INSERT INTO tsn_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mme lo na le ngwao ngwaga le ngwaga ya go nkopa go lo gololela mongwe mo kgolegelong fa go le Tlolaganyo. Mme fa lo batla ke dira jalo, ke tlaa golola ‘Kgosi ya Bajuta’.” ");
INSERT INTO tsn_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mme ba goa ba re, “Nnyaa! E seng monna yo, e leng Barabase!” Barabase e ne e le serukutlhi. ");
INSERT INTO tsn_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Mme Pilatwe a fatola mokwatla wa ga Jesu ka thupa, ");
INSERT INTO tsn_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","mme masole a loga serwalo sa mitlwa a se mo rwesa mo tlhogong a bo a mo apesa seaparo se se bohibidu jo bo mokgona. ");
INSERT INTO tsn_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ba mo sotla ba re, “Dumela, Kgosi ya Bajuta!” Ba bo ba mo itaya ka mabole. ");
INSERT INTO tsn_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatwe tswela kwa ntle gape mme a raya Bajuta a re, “Ke ya go mo ntshetsa kwa ntle kwa go lona jaanong, mme legale tlhaloganyang sentle gore nna ga ke mmone molato.” ");
INSERT INTO tsn_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Mme Jesu a tswela kwa ntle a rwele serwalo sa mitlwa a bile a apere seaparo se se bohibidu jo bo mokgona. Mme Pilatwe a re, “Bonang monna yo!” ");
INSERT INTO tsn_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Erile fela fa ba mmona, ditlhogo tsa baperesiti le bagolwane ba Sejuta ba simolola go goa ba re, “A a bapolwe! A a bapolwe!” Pilatwe a re, “Mmapoleng lona, nna ga ke mmone molato.” ");
INSERT INTO tsn_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mme ba mo fetola ba re, “Ka melao ya rona o tshwanetse go swa gonne o ipiditse Morwa Modimo.” ");
INSERT INTO tsn_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Erile fa Pilatwe a utlwa ba bua jalo, a tshoga thata go gaisa malatsi otlhe. ");
INSERT INTO tsn_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","A busetsa Jesu kwa kgotleng ya tshekelo a mmotsa a re, “O tswa kae?” Mme Jesu a seka a ntsha karabo epe. ");
INSERT INTO tsn_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Mme Pilatwe a re, “A ga o batle go bua le nna? A ga o lemoge gore ke na le nonofo ya go go golola kgotsa go go bapola?” ");
INSERT INTO tsn_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Mme Jesu a re, “O ka bo o sena nonofo epe gotlhelele mo go nna fa o ne o sa e newa e tswa kwa godimo. Mme ba ba ntlisitseng kwa go wena ba na le sebe se segolo.” ");
INSERT INTO tsn_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Mme Pilatwe a leka go mo golola, mme baeteledipele ba Sejuta ba mo raya ba re, “Fa o golola monna yo, ga o tsala ya ga Kaesara. Le fa e le mang yo o ipitsang gore ke Kgosi o tlhabana le Kaesara.” ");
INSERT INTO tsn_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Erile Pilatwe a utlwa mafoko a, a ntshetsa Jesu kwa ntle gape kwa go bone mme a nna mo setilong sa tshekelo mo bonnong jo bo dirilweng ka matlapa. ");
INSERT INTO tsn_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","E ne jaanong e ka nna motshegare wa sethoboloko pele ga letsatsi la Tlolaganyo. Mme Pilatwe a raya Bajuta a re, “Kgosi ya lona ke e!” ");
INSERT INTO tsn_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Mme ba goa ba re, “A a ye koo, A a ye koo, mmapole!” Pilatwe a re, “Lwa reng? Ke bapole Kgosi ya lona? Baperesiti ba bagolo ba goa ba re, Ga re na kgosi epe fa se Kaesara.” ");
INSERT INTO tsn_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mme Pilatwe a ba neela Jesu gore a bapolwe. ");
INSERT INTO tsn_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jalo Jesu lwa bofelo a tsenngwa mo diatleng tsa bone, mme a tseelwa kwa ntle ga motse, a itshikaretse mokgoro a isiwa kwa lefelong le le bidiwang “Logata.” Ka Sehebera le bidiwa “Gologotha.” ");
INSERT INTO tsn_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ba feta ba mmapola le ba bangwe teng koo ba le babedi, yo mongwe a bapolwa ka fa letsogong la gagwe la molema, yo mongwe ka fa go la moja, Jesu a le fa gare ga bone. ");
INSERT INTO tsn_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Mme Pilatwe a baya sesupo fa godimo ga ga Jesu se se balegang jaana, “JESU WA NASARETHA, KGOSI YA BAJUTA.” ");
INSERT INTO tsn_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Lefelo le Jesu a bapoletsweng mo go lone le ne le le gaufi le motse; mme sesupo se ne se kwadilwe ka Selatina le Segerika, gore batho ba le bantsi ba tle ba kgone go se bala. ");
INSERT INTO tsn_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Mme baperesiti ba bagolo ba raya Pilatwe ba re, “Fetola sesupo mo go reng, ‘Kgosi ya Bajuta’ o se fetolele mo go reng, ‘A re ke Kgosi ya Bajuta’.” ");
INSERT INTO tsn_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatwe a fetola a re, “Se ke se kwadileng ke se kwadile. Se nna fela jaaka se ntse.” ");
INSERT INTO tsn_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","24","Erile masole a sena go bapola Jesu, a baya diaparo tsa gagwe ka mekoanyana e le mene, mongwe le mongwe wa one masole ao a nna le seabe mo mekoanyaneng eo. Mme ba re, “Re seka ra kgagola seaparo sa gagwe,” gonne se ne se sena momeno, “A re se tsheleleng bola (mataese) gore re tle re bone gore se tsewa e mang.” Mo ga diragatsa polelo ya dikwalo e e reng, “Ba kgaogana diaparo tsa me, mme ba tshelela hempe ya me bola.” ");
INSERT INTO tsn_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Se ke sone se ba se dirileng. Gaufi le mokgoro go ne go eme Marea Mma Jesu le mmangwanaagwe ebong mosadi wa ga Kelopase le Marea Magatalena. ");
INSERT INTO tsn_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Erile fa Jesu a bona mmaagwe a eme foo fa thoko ga me, nna tsala ya gagwe e kgolo, a raya mmaagwe a re, “Ke morwao.” ");
INSERT INTO tsn_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nna a nthaya a re, “Ke mmago.” Mme go simolola foo ka mo tseela kwa lwapeng lwa me. ");
INSERT INTO tsn_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesu a itse gore sengwe le sengwe jaanong se weditswe, mme go diragatsa dikwalo a bua a re, “Ke nyorilwe.” ");
INSERT INTO tsn_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nkgwana ya mofine o o botsarara e ne e le foo, mme ngami ya inwa mo go yone ya ba ya tlhomelwa ka thupa ya mosiama mme ya tsholelediwa kwa molomong wa gagwe. ");
INSERT INTO tsn_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Erile fa Jesu a sena go leka mofine ka legano, a re, “Go fedile,” mme a lepeletsa tlhogo a golola mowa wa gagwe. ");
INSERT INTO tsn_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Baeteledipele ba Sejuta ba ne ba sa rate gore batho ba ba bapotsweng ba nne foo go fitlhelela letsatsi le le latelang, le e neng e le Sabata (le gone e le Sabata yo mogolo thata, gonne e ne e le Tlolaganyo) mme ba kopa Pilatwe go laola gore maoto a banna bao a rojwe go re ba swe ka bonako, le gore mebele ya bone e tle e folosiwe. ");
INSERT INTO tsn_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Mme masole a tla a roba maoto a banna ba babedi ba ba bapotsweng le Jesu; ");
INSERT INTO tsn_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","mme erile fa ba tla kwa go ene, ba bona gore o setse a sule, mme ba seka ba roba a gagwe. ");
INSERT INTO tsn_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Le fa go ntse jalo, mongwe wa masole a tlhaba lotlhakore lwa gagwe ka segai, mme madi le metsi a elela. ");
INSERT INTO tsn_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ke iponetse selo se ka matlho mme ke ntshitse polelo ya boammaaruri gore le lona lo dumele. ");
INSERT INTO tsn_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","Masole a dira jaana a diragatsa seporofeso sa dikwalo se se reng, “Le fa e le lengwe la marapo a gagwe ga le na go rojwa, mme ba tlaa leba kwa go ene yo ba mo tlhabileng.” ");
INSERT INTO tsn_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Moragonyana Josefa wa Arimathea, yo a neng a le morutwa wa ga Jesu ka sephiri ka ntlha ya go boifa baeteledipele ba Sejuta, a kopa Pilatwe ka bopelokgale go mo fa tetlelelo ya go tsaya mmele wa ga Jesu; mme Pilatwe a mo raya a re o ka tswelela pele wa ya go o tsaya. Mme a ya teng a ya go o tsaya a tsamaya ka one. ");
INSERT INTO tsn_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemo, monna yo a neng a kile a ya kwa go Jesu go le bosigo, a tla le ene a lere lookwane lo lo dirilweng ka mera le aloe lo lo tlhwatlhwa ya makgolo a le mabedi a dipula. ");
INSERT INTO tsn_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Botlhe ka bobedi ba phutha mmele wa ga Jesu ka leloba le le telele le innwe mo ditlolong tse di nkgang monate, ka e le mokgwa wa Sejuta wa phitlho. ");
INSERT INTO tsn_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Lefelo la Papolelo le ne le le gaufi le sekgwa sa ditlhare, kwa go neng go na le lebitla le lesha le le neng le ise le ke le dirisiwe. ");
INSERT INTO tsn_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Mme jalo, ka ntlha ya iketleetso pele ga Sabata, le ka ntlha ya gore lebitla le ne le le gautshwane, ba mo robatsa mo go lone. ");
INSERT INTO tsn_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Mme ya re mo mosong wa letsatsi la Tshipi, go sa ntse go le lefifi, Marea Magatalena a tla kwa phupung mme a fitlhela lentswe le pitikolotswe fa kgorong. ");
INSERT INTO tsn_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","A siana mme a bona Simone Petere le nna mme a re raya a re, “Ba tsere mmele wa Morena mo phupung, mme ga ke itse kwa ba mmeileng gone!” ");
INSERT INTO tsn_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","4","Ra sianela kwa phupung go bona, mme ka sia Petere ka goroga pele, ");
INSERT INTO tsn_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","mme ka inama ka leba mo teng ka bona letsela la leloba le le moo, mme ka seka ka tsena mo teng. ");
INSERT INTO tsn_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Mme Simone Petere le ene a goroga mme a tsena mo teng. Le ene a bona leloba le le teng moo, ");
INSERT INTO tsn_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","fa tuku e e neng e fapile Jesu mo tlhogong yone e ne e phuthilwe e beilwe fa thoko. ");
INSERT INTO tsn_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mme le nna ka tsena mo teng, mme ka bona, ka ba ka dumela (gore o tsogile). ");
INSERT INTO tsn_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Gonne go fitlhelela letsatsing leo go ne go ise go ke go tle mo kgakologelong ya rona gore a kana dikwalo di rile o tla rula. ");
INSERT INTO tsn_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Re ne ra ya gae. ");
INSERT INTO tsn_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mme ka nako eo Marea o ne a boetse kwa phupung a eme kwa ntle a lela. Mme ya re a ntse a lela a inama a leba mo teng. ");
INSERT INTO tsn_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Mme a bona baengele ba le babedi ba apere diaparo tse ditshweu yo mongwe a ntse fa tlhogong yo mongwe kwa maotong a lefelo le mmele wa ga Jesu o neng o namaletse mo go lone. ");
INSERT INTO tsn_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Baengele ba mmotsa ba re “O lelelang?” A ba fetola a re, “Gonne ba tsere Morena wa me, mme ga ke itse kwa ba mmeileng teng.” ");
INSERT INTO tsn_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","A gadima mme a bona mongwe a eme fa morago ga gagwe. E ne e le Jesu, mme a seka a mo lemoga! ");
INSERT INTO tsn_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Mme Jesu a mmotsa a re, “O lelelang? O batla mang?” Mme a mo raya a re, “Fa o mo tsere, mpolelela kwa o mmeileng teng, mme ke tlaa tsamaya ke ya go mo tsaya.” ");
INSERT INTO tsn_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Mme Jesu a mmitsa a re, “Marea!” Mme Marea a retologela kwa go ene a araba “Morena!” ");
INSERT INTO tsn_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","A mo tlhagisa a re, “Se nkame, gonne ga ke ise ke tlhatlogele kwa go Rara. Mme tsamaya o ye go senka bana ba ga Rre o ba bolelele gore ke tlhatlogela kwa go Rara le Rraa lona, Modimo wa me le Modimo wa lona.” ");
INSERT INTO tsn_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Marea Magatalena a bona barutwa mme a ba bolelela a re, “Ke bonye Morena!” Mme a ba bolelela molaetsa wa gagwe. ");
INSERT INTO tsn_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Maitseboeng ao barutwa ba ne ba kopana ba itotlelela mo tlung ka ntlha ya go boifa baeteledipele ba Sejuta, fa ka tshoganetso Jesu abo a ema fa gare ga bone! Morago a ba dumedisa, ");
INSERT INTO tsn_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","a ba kaela mabogo a gagwe le lotlhakore. Mme boitumelo jwa bone jwa nna bogolo thata jang fa ba bona Morena wa bone! ");
INSERT INTO tsn_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","A bua le bone gape a re, “Fela jaaka Rara a nthomile, le nna fela jalo ke a lo roma.” ");
INSERT INTO tsn_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Mme a ba budulela mowa a ba raya a re, “Amogelang Mowa o o Boitshepo. ");
INSERT INTO tsn_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Fa lo itshwarela mongwe dibe, di a itshwarelwa. Fa lo gana go di itshwarela ga di itshwarelwe.” ");
INSERT INTO tsn_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Mongwe wa barutwa ebong Thomase, “Lewelana,” o ne a seyo foo ka nako e ba bangwe ba neng ba na le Jesu ka yone. ");
INSERT INTO tsn_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ya re ba tsweletse pele ba mmolelela ba re, “Re bonye Morena,” a ba fetola a re, “Ga ke na go dumela fa e se ke bone dintho tsa dimapo mo mabogong a gagwe, ke bo ke tsenya menwana ya me mo go tsone, ke bo ke tsenya seatla sa me mo lotlhakoreng lwa gagwe.” ");
INSERT INTO tsn_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Erile malatsi a ferabobedi a sena go feta, barutwa ba bo ba le mmogo gape, mme ka nako e, Thomase o ne a na nabo. Dikgoro di ne di lotletswe; mme ka tshoganetso fela jaaka pele, Jesu a bo a eme fa gare ga bone a ba dumedisa. ");
INSERT INTO tsn_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mme a raya Thomase a re, “Tsenya monwana wa gago mo diatleng tsa me. Tsenya seatla sa gago mo lotlhakoreng lwa me. O seka wa tlhola o tlhoka tumelo. Dumela!” ");
INSERT INTO tsn_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomase a re, “Morena wa me le Modimo wa me!” ");
INSERT INTO tsn_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Hong Jesu a mo raya a re, “O dumela ka ntlha ya gore o mponye. Go sego ba ba sa mponang mme le fa go ntse jalo ba dumela.” ");
INSERT INTO tsn_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","31","Barutwa ba ga Jesu ba ne ba mmona fa a dira dikgakgamatso tse dingwe tse dintsi kwa ntle ga tse di bolelwang mo lokwalong lo, mme tse tsone di kwaletswe gore lo tlo lo dumele gore ke Mesia, Morwa Modimo, le gore ka go dumela mo go ene lo tlaa nna le botshelo. ");
INSERT INTO tsn_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Mme ya re morago Jesu a bonala gape kwa barutweng fa thoko ga Lecha la Galalea. Go ne ga diragala jaana: ");
INSERT INTO tsn_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Setlhopha sa rona se ne se le teng koo, Simone Petere, Thomase “Lewelana” Nathaniele wa Kana mo Galalea, mokaulengwe Jakobe le nna le barutwa ba bangwe ba babedi. ");
INSERT INTO tsn_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simone Petere a re, “Ke ya go tshwara ditlhapi,” le rona rotlhe ra re, “Re tsamaya nao.” Re ne ra dira jalo, mme ra seka ra tshwara sepe bosigo jotlhe. ");
INSERT INTO tsn_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mme ya re ka makuku ra bona monna a eme mo moshaweng mme ra seka ra bona gore ke mang. ");
INSERT INTO tsn_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","A botsa a re, “A go na le ditlhapi, basimane?” Mme ra mo fetola ra re, “Nnyaa.” ");
INSERT INTO tsn_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Mme a re raya a re, “Latlhelang lotloa lwa lona ka fa letsogong le legolo la mokoro, mme lo tlaa di tshwara di le dintsi!” Ra dira jalo, mme ra seka ra kgona go goga lotloa ka ntlha ya bokete jwa ditlhapi, di ne di le dintsi thata! ");
INSERT INTO tsn_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mme ka raya Petere ka re, “Ke Morena!” Erile fela foo, Simone Petere a apara seaparo sa gagwe (gonne o ne a se tsotse go fitlhelela kwa lothekeng). Mme a itatlhela mo metsing (a shapela kwa lotshitshing). ");
INSERT INTO tsn_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Mme rona ra sala mo mokorong ra gogela lotloa lo lo tletseng kwa moshaweng o o neng o ka nna dikgato di le makgolo a mararo. ");
INSERT INTO tsn_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Erile fa re goroga koo, ra fitlhela molelo o gotsitswe, ditlhapi di besitswe, ebile go na le senkgwe. ");
INSERT INTO tsn_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Mme Jesu a re raya a re, “Lereng dingwe tsa ditlhapi tse lo di tshwereng.” ");
INSERT INTO tsn_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Mme Simone Petere a tswela kwa ntle mme a gogela lotloa kwa lotshitshing. Ka bala e le ditlhapi di le lekgolo le masome a matlhano le boraro; mme le fa go ntse jalo lotloa lo ne lo sa kgagoga! ");
INSERT INTO tsn_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Mme Jesu a re raya a re, “Tlang kwano re tle go fitlhola.” Mme ga go na ope wa rona yo o neng a tshwenyega go mmotsa gore a ke Morena tota, gonne re ne re tlhomamisa gore ke ene. ");
INSERT INTO tsn_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Mme Jesu a ya le rona rotlhe a re fa senkgwe le ditlhapi. ");
INSERT INTO tsn_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Le e ne e le lekgetho la boraro Jesu a bonala mo go rona a sena go rula. ");
INSERT INTO tsn_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Morago ga sefitlholo Jesu a raya Simone Petere a re, “Simone, morwa Johane, a o nthata go gaisa ba bangwe ba?” Petere a fetola a re, “Ee, O a itse gore ke tsala ya gago.” Mme Jesu a mo raya a re, “Go siame hudisa dikwanyana tsa me.” ");
INSERT INTO tsn_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Mme Jesu a boelela potso a re: “Simone morwa Johane, a o nthata tota?” Petere a re, “Ee, Morena, oa itse gore ke tsala ya gago.” Mme Jesu a mo raya a re, “Tlhokomela dinku tsa me.” ");
INSERT INTO tsn_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Gape gape a mmotsa a re, “Simone, morwa Johane, a o tsala ya me tota?” Petere a hutsafala ka ntlha ya tsela e Jesu o neng a botsa potso e lwa boraro ka yone. Mme a mo fetola a re, “Morena, o itse pelo ya me, O itse gore ke tsala ya gago.” Mme Jesu a mo raya a re, “Hudisa dikwanyana tsa me. ");
INSERT INTO tsn_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Erile o sa le monana, o ne o kgona go dira ka fa o ratang ka teng, o ya gongwe le gongwe kwa o go ratang, mme fa o setse o tsofetse, o tlaa otlolola mabogo a gago mme ba bangwe ba tlaa go goga ba go isa kwa o sa rateng go ya teng.” ");
INSERT INTO tsn_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesu o ne a bua jalo go mo itsise loso lo a tlaa lo swang go galaletsa Modimo. Mme Jesu a mo raya a re, “Ntshala morago.” ");
INSERT INTO tsn_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petere a retologa mme a bona morutwa yo Jesu o mo ratang a mo setse morago, ene yo a neng a le fela fa dijong ka nako ele gotla go botsa Jesu a re, “Morena, ke ofe wa rona yo o tla go okang?” ");
INSERT INTO tsn_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petere a botsa Jesu a re, “Go tlaa diragalang ka ga gagwe, Morena? O tlaa swa loso lo lo ntseng jang?” ");
INSERT INTO tsn_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesu a mo fetola a re, “Fa e le gore ke batla gore a tshele go fitlhelela ke boa, moo go go ama ka eng? Wena ntshala morago.” ");
INSERT INTO tsn_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Mme monahune oo wa anama mo bakaulengweng gore morutwa yoo ga a na go swa! Mme seo e ne e se se Jesu o se rayang! O ne a rile, “Fa ke batla gore a tshele go fitlhelela ke tla, go go ama ka eng?” ");
INSERT INTO tsn_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ke nna morutwa yoo! Ke bonye ditiragalo tse mme ke di kwadile fano. Mme rotlhe re itse gore polelo ya me ya dilo tse e boammaaruri. ");
INSERT INTO tsn_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Mme ke bona gore fa ditiragalo tse dingwe mo botshelong jwa ga Jesu di ne di kwadilwe, lefatshe lotlhe le ne le ka se ka lekana go tshola dikwalo tseo tsotlhe!");
INSERT INTO tsn_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tsala e e rategang e e ratang Modimo: mo lokwalong lwa me lwa ntlha, ke lo boleletse kaga botshelo le dithuto tsa ga Morena Jesu le ka fa a neng a boela legodimong ka teng fa a sena go fa barutwa ba gagwe ditaelo tse di tswang kwa Moweng O O Boitshepo. ");
INSERT INTO tsn_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mo malatsing a le masome mane morago ga papolo ya gagwe, o ne a ntse a ipontsha barutwa ba gagwe a le mo sebopegong sa setho, gape a ba lemotsha ka ditsela tse dintsi gore ke ene tota yo ba mmonang. Mme mo dinakong tse o ne a buisanya le bone kaga Bogosi jwa Modimo. ");
INSERT INTO tsn_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Mo go nngwe ya diphuthego tse, o ne a ba bolelela gore ba seka ba tloga mo Jerusalema go fitlhelela Mowa O O Boitshepo o ba apesa e le go diragatsa tsholofetso ya ga Rara, puo e a neng a kile a buisanya le bone ka yone. ");
INSERT INTO tsn_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Mme a ba gakolola gore “Johane o kolobeditse ka metsi, mme jaanong lo tlaa kolobediwa ka Mowa O O Boitshepo mo malatsing a se kae a a tlang”. ");
INSERT INTO tsn_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mme ka lobaka longwe fa a bonala kwa go bone, ba mmotsa ba re, “Morena a o ya go golola Iseraele mo go Roma jaanong o bo o re dira chaba e e gololesegileng?” ");
INSERT INTO tsn_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Mme a fetola a re, “Rara ke ene a rulaganyang dipaka tsa go nna jalo. Mme ga se ga lona gore lo itse kaga tsone. ");
INSERT INTO tsn_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mme fa Mowa O O Boitshepo o sena go tla mo go lona, lo tlaa amogela nonofo ya go rera ka bothakga jo bogolo mo bathong ba Jerusalema le mo Judea yotlhe le mo Samarea, le kwa dikhutlong tsa lefatshe ka ga loso le tsogo ya me.” ");
INSERT INTO tsn_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Mme erile a sena go bua mafoko a, a tlhatlhogela kwa legodimong a nyelela mo lerung, a ba tlogela ba mo lebile ka kakabalo. ");
INSERT INTO tsn_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Fa ba sa ntse ba mo tsepegile matlho go mmona lwa bofelo, ka tshoganetso banna ba babedi ba apere dipurapura tse di tshweu ba bo ba eme fa thoko ga bone, ");
INSERT INTO tsn_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","mme ba re, “Banna ba Galalea ke eng fa lo tsepegetse a matlho kwa legodimong ka kakabalo? Jesu o ile legodimong mme ka letsatsi lengwe o tlaa tla fela jaaka a ile!” ");
INSERT INTO tsn_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ba ne ba le kwa Thabeng Lotlhware fa se se diragala, jaanong ba boela kwa morago ba tsamaya sephatlo sa mmaele go boela kwa Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","14","Mme ba tshwara thapelo mo ntlwanenge e kwa godimo e ba neng ba nna mo go yone. A ke maina a ba ba neng ba le teng mo phuthegong ya thapelo. Petere, Johane, Jakobe Anderea, Filipo, Thomase, Baretholomea, Mathaio, Jakobe, le bomorwa rraagwe Jesu, ba le setlhophanyana le mmaagwe Jesu, ba ne ba le teng. ");
INSERT INTO tsn_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Phuthego e ya thapelo e ne ya tswelela ka malatsi a le mantsi. Mme ya re ka nako eo, mo letsatsing leo fa go ne go na le batho ba ka nna lekgolo le masome a mabedi, Petere o ne a ema ka dinao mme a ba raya a re: ");
INSERT INTO tsn_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Bakaulengwe, go ne go tlhokega gore dikwalo di diragadiwe mabapi le Jutase yo o okileng Jesu ka go supegetsa bontsintsi jwa batho kwa a leng teng, gonne selo se, se sale se boletswe pele bogologolo ka Mowa O O Boitshepo o bua ka Kgosi Dafide. ");
INSERT INTO tsn_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","“Jutase e ne e le mongwe wa rona a tlhophilwe go nna morutwa fela jaaka rona. ");
INSERT INTO tsn_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","O ne a reka setsha sa lefatshe ka madi a o a amogetseng ka go loga maano a boithamako mme a wela fa fatshe a phanyega ka bogare mme mala a gagwe a gorometsegela kwa ntle. ");
INSERT INTO tsn_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Dikgang tsa loso lwa gagwe di ne tsa anama ka bofefo mo bathong ba Jerusalema, jalo ba bitsa setsha seo Lefatshe la Madi.! ");
INSERT INTO tsn_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Polelelo-pele ya ga Kgosi Dafide ka ga se, e bonwa mo lokwalong lwa Dipesalema mo a reng, ‘A motse wa gagwe o senngwe o seka wa nnwa ke ope.’ Gape, ‘A tiro ya gagwe e neelwe o sele go e dira.’ ");
INSERT INTO tsn_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Mme jaanong re tshwanetse go tlhopha mongwe yo o ka tsayang maemo a ga Jutase, le go re tlatsa re le basupi ba tsogo ya ga Jesu. A re tlhopheng mongwe yo o saleng a nna le rona go simolola fa re tsalana le Morena, go tloga ka nako e o neng a kolobediwa ke Johane go fitlhelela a tseelwa kwa legodimong.” ");
INSERT INTO tsn_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Phuthego e ne ya tlhopha maina a banna ba le babedi: Jusefa Justiso (yo gape a itsegeng ka leina la Barenabase) le Mathiase. ");
INSERT INTO tsn_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Jalo ba rapela gore ba tlhope monna yo o tshwanetseng, ba re, “O! Morena, o itse pelo nngwe le nngwe re bontshe gore ke ofe wa banna ba yo wena o mo kgethileng gore a nne moaposetoloi, yo o ileng kwa mannong a a mo tshwanetseng.”. ");
INSERT INTO tsn_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Jalo ba laola ka bola mme ya re ba gasa bola jwa supa Mathiase, jalo a kgethwa go nna mongwe wa ba ba lesome le motso. ");
INSERT INTO tsn_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Mme erile go setse go fetile dibeke di supa, morago ga loso le tsogo ya ga Jesu, ga fitlha letsatsi la Pentekosete. Ya re ka letsatsi leo badumedi ba phuthega, ");
INSERT INTO tsn_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ka tshoganetso ga utlwala mosumo o ka re wa sefefo se segolo kwa loaping kwa godimo ga bone, mme wa tlala ka ntlo e ba neng ba phuthegetse mo go yone. ");
INSERT INTO tsn_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Hong, ga bonala kwa go bone sengwe ekete dikgabo kgotsa diteme tsa molelo mme tsa nna mo ditlhogong tsa bone. ");
INSERT INTO tsn_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Mme botlhe ba ba neng ba le teng ba tladiwa ka Mowa O O Boitshepo, mme ba simolola go bua ka dipuo tse ba sa di itseng, gonne Mowa O O Boitshepo o ne wa ba naya nonofo e. ");
INSERT INTO tsn_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mme ga bo go le Bajuta ba le bantsi ba ba boifang Modimo mo Jerusalema ka letsatsi leo mo moketeng wa tumelo, ba tswa mo dichabeng tse dintsi. ");
INSERT INTO tsn_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Mme ya re ba utlwa mosumo mo loaping kwa godimo, bontsintsi jwa batho jwa tla bo tabogile go tla go bona gore go diragala eng. Mme ba gamarega fa ba utlwa barutwa ba bua ka dipuo tsa bone. ");
INSERT INTO tsn_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ba bua ka kgakgamalo ba re, “Mo go ka diragala jang? Gonne banna ba botlhe ke ba ba tswang kwa Galalea? ");
INSERT INTO tsn_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Mme re utlwa ba bua ka diteme tsotlhe tsa mafatshe a re tsaletsweng mo go one! ");
INSERT INTO tsn_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Fano re le Baparathaia, le Bameda, Baelama, le batho ba ba tswang kwa Mesopotamia, le kwa Judea, le Kapodokia le Ponto le kwa Asia. ");
INSERT INTO tsn_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Le kwa Feregia le Pamfilea le Egepeto le puo ya dikgaolo tsa Kurene ntlheng ya Libia, le baeng ba ba tswang kwa Roma, e le Bajuta le ba ba sokologetseng kwa Sejuteng. ");
INSERT INTO tsn_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Le Bakereta, le Baarabia. Mme rotlhe fela re utlwa banna ba ba bua dikgakgamatso tse dikgolo tsa Modimo ka puo ya ga rona!” ");
INSERT INTO tsn_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Mme ba ema foo ba hakgametse thata ebile ba gamaregile. Mme ba botsana ba re, “Tota mo go ka ne go raya eng?” ");
INSERT INTO tsn_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mme bangwe le fa go ntse jalo ba ne ba ba sotla, ba re “Batho ba ba tagilwe fela ba!” ");
INSERT INTO tsn_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Mme Petere a ema fa pele le barutwa ba bangwe ba le lesome le motso, mme a goeleletsa kwa bontsintsing jwa batho a re, “Lona lotlhe reetsang, baeng le lona baagi ba Jerusalema ka mokgwa o o tshwanang! ");
INSERT INTO tsn_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Bangwe ba lona ba re batho ba ba tlhapetswe! Ga se boammaaruri! Go sa le mo mosong thata mo go se se ntseng jalo! Batho ga ba tlhapelwe ka nako ya bofera o le mongwe mo mosong! ");
INSERT INTO tsn_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nnyaa Se lo se bonang mo mosong ono se ne sa porofeswa mo dingwageng tse di makgolokgolo tse di fitileng ke moporofiti Joele, o rile ");
INSERT INTO tsn_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘E tlaa re mo malatsing a bofelo ke goromeletse Mowa wa me O O Boitshepo mo bathong botlhe, bomorwaalona le bomorwadia lona ba tlaa porofesa. Makau a lona a tlaa bona diponatshegelo, le banna ba tlaa lora ditoro. ");
INSERT INTO tsn_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ee, Mowa O O Boitshepo o tlaa goromediwa le mo batlhankeng ba me botlhe banna le basadi ka mokgwa o o tshwanang, mme ba tlaa porofesa. ");
INSERT INTO tsn_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mme ke tlaa dira ditshupo tse di sa tlwaelesegang mo Magodimong le mo lefatsheng, madi le molelo le maru a a looto la mosi; ");
INSERT INTO tsn_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","letsatsi le tlaa fifala le kgwedi e tlaa nna khibidu jaaka madi pele ga Letsatsi leo le le boitshegang la Morena le tla. ");
INSERT INTO tsn_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Mme le fa e le mang yo o kopang kutlwelo-botlhoko mo Modimong o tlaa e newa, matlho kwa legodimong ka kakabalo? Jesu o ile legodimong mme ka letsatsi lengwe o tlaa tla fela jaaka a ile!’ ");
INSERT INTO tsn_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Lona banna ba Iseraele, reetsang, “Modimo o ne wa supela Jesu wa Monasara ka go dira dikgakgamatso tse di kgolo ka ene fela jaaka lo itse sentle. ");
INSERT INTO tsn_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Mme Modimo o setse morago leano la one le o saleng o le dira bogologolo, a lo letla gore lo dirise puso ya Roma gore lo mmapole mo mokgorong lo mmolaye. ");
INSERT INTO tsn_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Mme Modimo wa mo golola mo losong lo lo boitshegang wa mo tsosa mo baswing, gonne loso lo ne lo sena thata ya go mo tshegetsa mo taolong ya lone. ");
INSERT INTO tsn_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“Kgosi Dafide o kile a ama mafoko a a builweng ke Jesu fa a re, ‘Ke itse gore Morena o na le nna ka malatsi otlhe o a nthusa, nonofo e kgolo ya Modimo e a ntshireletsa. ");
INSERT INTO tsn_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","“Mme ga go hakgamatse fa pelo ya me e tletse boitumelo le loleme lo goeletsa dipako tsa gagwe, gonne ke a itse gore dilo tsotlhe di tlaa ntshiamela mo losong. ");
INSERT INTO tsn_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","“Gonne ga o kitla o tlogela mowa wa me mo bobipong le fa e le go letla mmele wa ga Morwao yo o Boitshepo go bola. ");
INSERT INTO tsn_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","“Mme o tlaa mpusetsa botshelo jwa me, o mphe le boitumelo jo bo hakgamatsang fa pele ga gago.’ ");
INSERT INTO tsn_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Bakaulengwe ba ba rategang, gakologelwang gore Dafide o ne a sa ithee fa a bua mafoko a ke setseng ke tswa go a ama, gonne o ne a swa, a ba a fitlhwa, le lebitla la gagwe le sa ntse le le teng le gompieno. ");
INSERT INTO tsn_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Mme e ne e le moporofiti, gape a itse gore Modimo o sale o solofetsa ka maikano a a sa senyegeng gore mongwe wa losika lwa ga Dafide (o tlaa nna Mesia) a nne mo setilong sa bogosi sa ga Dafide. ");
INSERT INTO tsn_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dafide o ne a lebela dilo pele, gape a porofeta tsogo ya ga Mesia mo baswing, a re Mowa wa ga Mesia ga o kitla o tlogelwa mo bobipong le mmele wa gagwe ga o na go bola. ");
INSERT INTO tsn_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","O ne a bua kaga Jesu, mme rotlhe, re basupi ba gore Jesu o tsogile mo baswing. ");
INSERT INTO tsn_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","“Mme jaanong o ntse mo setilong sa bogosi sa tlotlo e kgolo thata kwa legodimong, go bapa le Modimo, mme fela jaaka go solofeditswe, Rara o mo neile taolo ya go romela Mowa O O Boitshepo, ka ditshupo tse lo di bonang le tse lo di utlwang gompieno. ");
INSERT INTO tsn_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Nnyaa, Dafide o ne a sa ithee ka bo ene ka mafoko agagwe a ke sa tswang go a umaka gonne ga a ise a ke a tlhatlhogele kwa magodimong. Mo godimo ga moo, o buile gape a re, ‘Modimo o buile le Morena wa me, Mesia, wa re, “Nna fano ka tlotlego go bapa le Nna, ");
INSERT INTO tsn_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","go fitlhelela ke tlisa baba ba gago” mo boineelong jo bo feletseng.’ ");
INSERT INTO tsn_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Mme ke gone ka moo ke buang phatlalatsa le mongwe le mongwe mo Iseraele gore Modimo o dirile ene Jesu yo, yo lo mmapotseng go nna Morena le Mesia.” ");
INSERT INTO tsn_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Mme mafoko a a ga Petere a ba ama thata; mme ba mo raya le baaposetoloi ba bangwe ba re, “Bakaulengwe re tshwanetse go dira eng?” ");
INSERT INTO tsn_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Mme Petere a fetola a re, “Sokologang mo dibeng, lo boele mo Modimong, lo bo lo kolobediwe boitshwarelo jwa dibe tsa lona mo leineng la ga Jesu Keresete; mme ke gone le lona lo tlaa amogelang neo e ya Mowa o o Boitshepo. ");
INSERT INTO tsn_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Gonne Keresete o e solofeditse mongwe le mongwe wa lona yo o biditsweng ke Morena Modimo wa rona, le bana ba lona le ba ba kwa mafelong a a kgakala!” ");
INSERT INTO tsn_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Mme Petere a rera thero e telele a bolela ka ga Jesu, a gatelela ka go kopa bareetsi ba gagwe botlhe fela go ipoloka mo boleong jwa chaba ya ga bone. ");
INSERT INTO tsn_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Mme ba ba neng ba dumela thero ya ga Petere ba ne ba kolobediwa, e ne e ka nna batho ba le dikete tse tharo! ");
INSERT INTO tsn_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Mme ba kopanela ditirelo tsa malatsi otlhe le badumedi ba bangwe, mo dithutong le mo selalelong sa Morena le mo dikopanong tsa merapelo. ");
INSERT INTO tsn_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mme poifo e kgolo e ne e le mo go bone botlhe, foo baaposetoloi ba dira dikgakgamatso tse dintsi. ");
INSERT INTO tsn_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Mme badumedi botlhe ba ne ba kopana ka nako tsotlhe ba abalana dilo tsotlhe tse ba nang natso, ");
INSERT INTO tsn_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ba rekisa dithoto tsa bone ba di abela ba ba tlhokang. ");
INSERT INTO tsn_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ba ne ba obama mmogo ka nako tsotlhe mo Tempeleng, ba kgobokana ka ditlhophanyana mo malwapeng, ba a ja Selalelo sa Morena, gape ba tlhakanela le tsone dijo tsa bone ka boitumelo le ka tebogo e kgolo, ");
INSERT INTO tsn_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ba baka Modimo. Ba be ba ratwa ke batho botlhe ba motse, mme Modimo wa ba okeletsa malatsi otlhe ka ba ba bolokwang. ");
INSERT INTO tsn_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Erile maitsiboa mangwe Petere le Johane ba ya kwa Tempeleng go ya go kopanela merapelo e e neng e nna ka nako ya boraro malatsi otlhe. ");
INSERT INTO tsn_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ya re ba atamela Tempele, ba bona monna yo o neng a sale a nnanye go tsweng mo sebopelong sa ga mmaagwe a rwelwe mo tseleng mme a bewa fa thoko ga kgoro ya Tempele e e neng e bidiwa Bontle, ka e ne e le tlwaelo ya gagwe ya malatsi otlhe. ");
INSERT INTO tsn_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ya re Petere le Johane ba feta gaufi nae a ba kopa madi. ");
INSERT INTO tsn_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ba mo tlhoma matlho, mme Petere a re, “Leba kwano!” ");
INSERT INTO tsn_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Segole sa ba tlhoma matlho ka tlhoafalo, se solofetse mpho nngwe. ");
INSERT INTO tsn_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Mme Petere a mo raya a re, “Ga re na madi a re ka go a nayang! Mme ke tlaa go naya sengwe! Ke go laola ka leina la ga Jesu Keresete wa Nasaretha ka re, Ema o tsamaye!” ");
INSERT INTO tsn_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","8","Petere a tshwara segole ka seatla a se emisa ka dinao. Mme ya re a dira jalo, maoto a monna yoo le magwejana a fodisiwa a bo a nonotshiwa mo e leng gore o ne a ba a kgona go tlolaka, a ema foo lobakanyana mme a simolola go tsamaya! Mme a tsamaya a tlolaka a baka Modimo a tsena le bone mo Tempeleng. ");
INSERT INTO tsn_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Erile fa batho ba ba mo Tempeleng ba mmona a tsamaya ebile ba utlwa a galaletsa Modimo, ");
INSERT INTO tsn_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ebile ba lemoga fa e le mokopi yo ba mmoneng gantsi fa kgorong e e bidiwang Bontle, ba hakgamadiwa ke se se diragetseng. ");
INSERT INTO tsn_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ya re a ntse a ngaparetse Petere le Johane, batho botlhe ba taboga ba ba kgobokanela kwa loobong lo lo bidiwang lwa ga Solomone ba hakgametse thata. ");
INSERT INTO tsn_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Mme Petere a bona sebaka sa go bua le batho a ba raya a re, “Batho ba Iseraele, ke eng se se hakgamatsang thata kaga se? Ke eng fa lo re lebile thata jaaka o ka re re fodisitse monna yo ka nonofo le ka bo-Modimo jwa rona re dirile gore a tsamaye? ");
INSERT INTO tsn_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Gonne ke Modimo wa ga Aberahame, Isake, Jakobe le Modimo wa borra-a-rona mogolwagolwane o o lerileng kgalalelo mo motlhankeng wa one Jesu Keresete ka go dira jalo. Ke raya Jesu yo lo mo itatotseng fa pele ga ga Pilatwe, mo godimo ga maikaelelo a ga Pilatwe a go mo golola. ");
INSERT INTO tsn_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ga lo aka lwa batla gore moitshepi yo o siameng yo a gololwe. Mo boemong jwa gagwe lwa lopa gore go gololwe mmolai. ");
INSERT INTO tsn_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mme lwa bolaya Motlhodi wa botshelo; mme Modimo wa mo rudisa mo losong. Mme nna le Johane re basupi ba selo se se diragetseng se, gonne, erile lo sena go mmolaya ra mmona a tshela! ");
INSERT INTO tsn_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Leina la ga Jesu le fodisitse monna yo, mme lo itse gore o ne a le segole jang pele. Go fola mo go itekanetseng mo go dirilwe ke go dumela mo leineng la ga Jesu le tumelo e re e neilweng ke Modimo. ");
INSERT INTO tsn_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Bakaulengwe ba ba rategang, ke lemoga gore se lo se dirileng mo go Jesu lo se dirile ka go tlhoka kitso; mme le baeteledipele ba lona ba ka bolelwa fela jalo. ");
INSERT INTO tsn_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","“Mme Modimo o ne o diragatsa seporofeso sa gore Mesia o tshwanetse go boga dilo tse tsotlhe. ");
INSERT INTO tsn_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ke gone sokololelang ditlhaloganyo le megopolo ya lona kwa Modimong, lo sokologele kwa go one gore o tlose maleo a lona o bo o lo leretse metlha ya boitumelo jo bo tswang kwa Moreneng, ");
INSERT INTO tsn_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","le go re a bo a lo romelele Jesu Mesia wa lona gape. ");
INSERT INTO tsn_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","22","Gonne o tshwanetse go nna kwa legodimong go fitlhelela nako e Modimo o busetsang dilo tsotlhe mo maemong a tsone, jaaka go porofitilwe mo dinakong tsa bogologolo. Fela jaaka Moshe a kile a bua bogologolo a re, ‘Morena Modimo o tlaa tsosa Moporofiti mo gare ga lona yo o tlaa tshwanang le nna! Lo mo reetseng ka kelo-tlhoko mo go sengwe le sengwe se o se lo bolelelang. ");
INSERT INTO tsn_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Lefa e le mang yo o se kitlang a mo reetsa o tlaa senyediwa ruri. ");
INSERT INTO tsn_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuele le moporofiti mongwe le mongwe ga ba bolo go bolela kaga se se diragalang gompieno.’ ");
INSERT INTO tsn_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Lo bana ba baporofiti bao; mme lo baletswe mo tsholofetsong ya Modimo e o e diretseng bagologolwane ba lona go segofatsa lotlhe ka Bajuta, eo ke tsholofetso e Modimo o e neileng Aberehame. ");
INSERT INTO tsn_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Mme erile fela fa Modimo o sena go rudisa motlhanka wa one mo baswing, o ne wa mo roma pele kwa go lona batho ba Iseraele, go lo segofatsa ka go lo sokolola mo dibeng tsa lona.” ");
INSERT INTO tsn_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Mme ya re ba santse ba bua le batho, baperesiti ba bagolo le molaodi wa mapodisi a Tempele, le bangwe ba Basadukai ba tla kwa go bone, ");
INSERT INTO tsn_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ba tshwenyegile thata ka ntlha ya gore Petere le Johane ba ne ba bolela gore Jesu o tsogile mo baswing. ");
INSERT INTO tsn_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ba ba tshwara, mme ka go ne go setse go le maitsiboa, ba ba tlhatlhela mo tlung ya kgolegelo bosigo jotlhe. ");
INSERT INTO tsn_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mme bontsi jwa batho ba ba utlwileng molaetsa wa bone ba o dumela, mo e leng gore palo ya badumedi e ne ya tsholetsega ya batla go nna dikete tse tlhano! ");
INSERT INTO tsn_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Erile ka letsatsi le le latelang ga diragala gore Lekgotla la baeteledipele ba Sejuta le bo le phuthegetse mo Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anase Moperesiti yo mogolo a bo a le teng, le Kaiafase, Johane, Alekesandere le ba bangwe ba losika lwa Moperesiti yo Mogolo. ");
INSERT INTO tsn_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Jalo barutwa ba babedi ba leriwe kwa go bone. Mme lekgotla la ba botsa la re, “Lo dirile selo se ka nonofo ya ga mang kgotsa ka taolo ya ga mang?” ");
INSERT INTO tsn_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Mme Petere, ka a tletse Mowa O O Boitshepo a ba raya a re, “Baeteledipele ba ba tlotlegang le ditlhogo tsa sechaba sa rona, ");
INSERT INTO tsn_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","fa lo raya tiro e ntle e e diretsweng segole se, le ka fa o neng a fodisiwa ka teng, ");
INSERT INTO tsn_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","a nke ke lo bolelele sentle lona le batho botlhe ba Iseraele gore tiro e e dirilwe ka leina le nonofo ya ga Jesu wa Nasaretha, Mesia, monna yo lo mmapotseng, mme Modimo o mo tsositse mo baswing. Ke ka nonofo ya gagwe fa monna yo a eme fano a fodile! ");
INSERT INTO tsn_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Gonne Jesu Mesia (ene yo go buiwang ka ga gagwe mo dikwalong) ke ‘lentswe je le gannweng ke baagi le le neng la nna lentswe la kgokgotshwana.’ ");
INSERT INTO tsn_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ga go na poloko mo go ope! Ka fa tlase ga legodimo lotlhe ga gona leina lepe le batho ba ka le bitsang gore ba bolokwe.” ");
INSERT INTO tsn_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Erile Lekgotla le bona bopelokgale jwa ga Petere le Johane, gape le lemoga gore ga ba a rutega ke batho fela, ba hakgamala mme ba lemoga gore go nna le Jesu go ba diretse eng. ");
INSERT INTO tsn_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Mme Lekgotla le ne le se kake la latola go fodisiwa ga gagwe gonne motho yo o neng a fodisitswe o ne a eme gone foo gaufi nabo! ");
INSERT INTO tsn_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Mme ba ba ntshetsa kwa ntle ga ntlwana e Lekgotla le kopanelang mo go yone ba sala ba gakololana. ");
INSERT INTO tsn_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ba botsana ba re, “Re tlaa dirang ka banna ba? Ga re ka ke ra ganela gore ba dirile kgakgamatso e kgolo, gonne mongwe le mongwe mo Jerusalema o itse ka ga selo se. ");
INSERT INTO tsn_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mme gongwe re ka ba emisa mo go anamiseng tumelo ya bone. Re tlaa ba bolelela gore fa ba ka dira gape jalo re tlaa dira gore ba obamele molao wa rona ka kgang.” ");
INSERT INTO tsn_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mme ba ba biletsa mo teng, ba ba raya ba re ba seka ba tlhola ba bua sepe ka ga Jesu. ");
INSERT INTO tsn_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mme Petere le Johane ba ba raya ba re, “Atlholang lona gore a Modimo o batla re reetsa lona mo boemong jwa one! ");
INSERT INTO tsn_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ga re ka ke ra khutlisa go bua ka dilo tse di ntle tse re bonyeng Jesu a di dira ebile re mo utlwile a di bua.” ");
INSERT INTO tsn_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Mme Lekgotla la ba bopela, lwa bofelo ba ba lesa ba tsamaya gonne ba ne ba sa itse gore ba ka ba otlhaya jang kwa ntle ga go tsosa mokubukubu. Gonne mongwe le mongwe o ne a galaletsa Modimo ka ntlha ya tiro e ntle e, ");
INSERT INTO tsn_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ebong phodiso ya monna yo o saleng a lwetse dingwaga di le masome mane! ");
INSERT INTO tsn_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ka bofefo fela fa ba sena go gololwa, Petere le Johane ba bona barutwa ba bangwe mme ba ba bolelela se Lekgotla le se ba reileng. ");
INSERT INTO tsn_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Mme badumedi botlhe ba kopanela thapelo e: “Oo Morena yo o dirileng legodimo le lefatshe le lewatle le tsotlhe tse di mo go tsone, ");
INSERT INTO tsn_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","26","o buile bogologolo ka Mowa O O Boitshepo ka mogolwagolwane wa rona, motlhanka wa gago Kgosi Dafide, wa re ‘Ke ka ntlha yang fa baheitane ba tsogologela Morena, le merafe e e dieleele e dira maanonyana a a kgatlhanong le Modimo-Mothata-Yotlhe? Dikgosi tsa lefatshe di a kopana go tlhabantsha Morwa Modimo yo o tloditsweng!’ ");
INSERT INTO tsn_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Ke sone se se diragalang fano mo motseng o gompieno! Gonne Kgosi Herode, le Ponto Pilato mmusi, le ba-Roma botlhe le batho ba Iseraele, ba kopanetse Jesu, Morwa yo o tloditsweng, motlhanka wa gago yo o boitshepo. ");
INSERT INTO tsn_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ga ba na go tlogela le fa e le sepe se wena mo nonofong ya gago o tlaa ba letlang go se dira. ");
INSERT INTO tsn_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Mme jaanong Morena, utlwa go bopa ga bone, mme o neye batlhanka ba gago bopelokgale jo bogolo mo therong ya bone, ");
INSERT INTO tsn_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","o bo o romele nonofo ya gago ya phodiso, le dikgakgamatso di le dintsi le ditshupo di dirwe ka leina la motlhanka wa gago yo o itshepileng Jesu.” ");
INSERT INTO tsn_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Morago ga thapelo e, kago e ba neng ba kopanetse mo go yone ya tshikinyega, mme botlhe ba tlala Mowa O O Boitshepo mme ba rera molaetsa wa Modimo ka bopelokgale. ");
INSERT INTO tsn_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Badumedi botlhe ba ne ba le pelo e le nngwe le mowa o le mongwe, mme ga bo go sena ope yo o reng sepe sa dilo tse o nang natso ke sa gagwe; mme dilo tsotlhe ba ne ba di tlhakanetse. ");
INSERT INTO tsn_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Mme baaposetoloi ba rera dithero tse di nonofileng ka ga tsogo ya ga Morena Jesu, mme ga nna le bolekane jo bo nitameng mo badumeding botlhe. ");
INSERT INTO tsn_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Go ne go sena ope yo o tlhokang, gonne botlhe ba ba neng ba na le ditsha kgotsa matlo ba ne ba a rekisa ba tlisa madi kwa baaposetoloing go a abela ba ba tlhokang. ");
INSERT INTO tsn_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jaaka go ne go na le Josefa, (yo baaposetoloi ba neng ba mmitsa “Barenabase wa Moreti!” E ne e le wa Balifi ba kwa setlhaketlhakeng sa Kupero). ");
INSERT INTO tsn_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","E ne e le mongwe wa ba ba neng ba rekisa ditsha tsa bone tse ba neng ba na natso mme ba tlisa madi kwa baaposetoloing gore ba a abele ba ba tlhokang. ");
INSERT INTO tsn_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mme ga bo go le monna a bidiwa Ananiase (le mosadi wa gagwe Safira) ba ba neng ba a rekisa bontlha-bongwe jwa setsha, ");
INSERT INTO tsn_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","mme ba tlisa bontlhabongwe fela jwa madi, ba kaya fa e le tlhwatlhwa e e feletseng (mosadi wa gagwe o ne a dumalana tsietso e). ");
INSERT INTO tsn_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Mme Petere a re, “Ananiase, Satane o tladitse pelo ya gago ka maaka fa o bolela gore tlhwatlhwa e ke yone yotlhe, o ne o aketsa Mowa O O Boitshepo. ");
INSERT INTO tsn_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Setsha e ne e le sa gago go se rekisa kgotsa nnyaa, go ya fela ka fa o neng o rata ka teng. Mme morago ga o sena go se rekisa, e ne e le ga gago go bona gore o ntsha bokae. Ke eng fa o ne o dira jaana? Ga oa aketsa rona o akeditse Modimo.” ");
INSERT INTO tsn_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Erile fela fa Ananiase a utlwa mafoko a, a wela fa fatshe a swa! Mongwe le mongwe a tlewa ke poifo e kgolo, ");
INSERT INTO tsn_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","mme makau a mo phutha ka letsela a mo tsaya a ya go mo fitlha. ");
INSERT INTO tsn_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Erile morago ga dioura di le tharo mosadi wa gagwe a tla, a sa itse se se diragetseng. ");
INSERT INTO tsn_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petere a mmotsa are, “A lo rekisitse setsha sa lona ka bokana?” A araba are “Ee, re se rekisitse ka bokalo.” ");
INSERT INTO tsn_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Mme Petere a re, “Ke eng fa wena le monna wa gago lo ka akanya go dira selo se se ntseng jaana, lo leka maano a bosula go leka nonofo ya Mowa wa Modimo go itse se se diragalang? Ka kwa ntle ga kgoro ele go na le makawana a a tswang go boloka monna wa gago, mme le wena ba tlaa tla go go rwala ba ya go go boloka.” ");
INSERT INTO tsn_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Erile gone fela foo a wela fa fatshe, a swa, mme makawana a tsena mo teng, ya re ba mmona gore o sule, ba mo tsaya ba ya go mmoloka go bapa le monna wa gagwe. ");
INSERT INTO tsn_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Mme poifo e kgolo ya tlela phuthego yotlhe le ba bangwe botlhe ba ba utlwileng se se diragetseng. ");
INSERT INTO tsn_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ka sebaka seo, Baaposetoloi ba ne ba kopane mo lefelong le le bidiwang mathudi a ga Solomone, mme ba dira ditshupo tse di bonalang le dikgakgamatso mo matlhong a batho. ");
INSERT INTO tsn_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Badumedi ba bangwe ba seka ba kgatlhega go kopana le bone, le fa go ntse jalo, ba ne ba ba tlotla thata. ");
INSERT INTO tsn_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mme badumedi ba oketsega thata mo Moreneng, bontsi jwa banna le basadi. ");
INSERT INTO tsn_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Balwetse ba ntshediwa kwa mebileng ba le mo malaong le mo diphateng gore bogolo moriti wa ga Petere o wele bangwe ba bone fa a feta! ");
INSERT INTO tsn_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mme bontsi jwa batho jwa tla bo tswa mo tikologong ya Jerusalema, ba tlisa balwetse ba bone le ba ba tsenyweng ke mewa e e maswe; mme mongwe le mongwe wa bone a fola. ");
INSERT INTO tsn_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Mme Moperesiti yo mogolo le botlhe ba losika le ditsala tsa gagwe mo Basadukaing ba tlala lefufa, ");
INSERT INTO tsn_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","mme ba tshwara baaposetoloi, ba ba tsenya mo kgolegelong. ");
INSERT INTO tsn_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mme moengele wa Morena a tla bosigo, a bula dikgoro tsa kgolegelo a ba ntshetsa kwa ntle. Mme a ba raya a re, ");
INSERT INTO tsn_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Tsamayang lo ye mo Tempeleng lo rere kaga Botshelo jo!” ");
INSERT INTO tsn_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Mme ba goroga mo Tempeleng e ka ne e le ka nako ya letsatsi le tlhaba mme ka bonako ba simolola go rera! Moragonyana mo mosong oo, Moperesiti yo Mogolo le botlhe ba lekgotla ba tsena mo Tempeleng, ba bitsa Lekgotla le legolo la bagolwane ba Puso, ba romela batho go ya go bitsa baaposetoloi go tla go sekisiwa. ");
INSERT INTO tsn_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mme erile fa mapodisi a tsena kwa kgolegelong, banna ba bo ba seyo, jalo ba boela kwa Lekgotleng ba bega gore ");
INSERT INTO tsn_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Dikgoro tsa kgolegelo di ne di tswetswe, mme batlhokomedi ba ne ba eme ka kwa ntle, mme erile fa re bula dikgoro, ga bo go sena ope!” ");
INSERT INTO tsn_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mme erile fa molaodi wa mapodisi le baperesiti ba bagolwane ba utlwa se, ba akabala, ba hakgametse thata gore go tlaa diragalang le gore mo gotlhe go tlaa felela kae! ");
INSERT INTO tsn_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mme mongwe a goroga ka mafoko a a reng banna ba ba neng ba le mo kgolegelong ba mo Tempeleng ba rerela batho! ");
INSERT INTO tsn_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","27","Mme Mogolwane wa mapodisi a tsamaya le mapodisi ba ba tshwara kwa ntle ga mokubukubu, (gonne ba ne ba tshaba batho gore ba tlaa ba bolaya fa ba ka gakalela barutwa) mme ba ba lere fa pele ga Lekgotla. ");
INSERT INTO tsn_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Moperesiti yo Mogolo a bua a re, “A ga re a lo bolelela gore lo seka lwa tlhola lo ruta kaga Jesu yo? Mme mo boemong jwa go khutlisa go rera kaga Jesu lo tladitse Jerusalema ka thuto ya lona mme lo ikaelela go re baya molato ka loso lwa monna yo!” ");
INSERT INTO tsn_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Mme Petere le baaposetoloi ba araba ba re, “Re tshwanetse go obamela Modimo go na le batho. ");
INSERT INTO tsn_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Modimo wa borra-a-rona mogolwagolwane o tsositse Jesu go tla mo botshelong gape morago ga lo sena go mmolaya ka go mo pega mo mokgorong. ");
INSERT INTO tsn_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mme ka nonofo e kgolo, Modimo wa mo tsholetsa go nna Kgosana le Mmoloki, gore batho ba Iseraele ba tle ba nne le lobaka lwa boikwatlhao le gore dibe tsa bone di itshwarelwe. ");
INSERT INTO tsn_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Mme re basupi ba dilo tse, ga mmogo le Mowa O O Boitshepo, o o neetsweng botlhe ba ba obamelang Modimo.” ");
INSERT INTO tsn_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","“Ya re ka ntlha ya go bua jalo, Lekgotla la gakala la ikaelela go ba bolaya.” ");
INSERT INTO tsn_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mme mongwe wa bone, Mofarasai yo o bidiwang Gamaliele, (moitseanape wa molao wa tumelo a bile a itsege thata mo bathong) a ema a kopa gore baaposetoloi ba ntshediwe kwa ntle fa a sa ntse a bua. ");
INSERT INTO tsn_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Mme a raya banna ba Lekgotla a re, ");
INSERT INTO tsn_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","“Motlha mongwe go kile ga bo go le Theudase, yo o neng a ipaya jaaka e ka re ke mongwe yo o kwa godimo. Bangwe ba ka nna makgolo a mane ba ikopanya nae, mme a bolawa, mme botlhe ba ba ineetseng mo go ene ba phatlaladiwa kwa ntle ga kutlwelobotlhoko epe. ");
INSERT INTO tsn_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","“Morago ga gagwe, ka nako ya fa go kgethisiwa, ga bo go le Judase wa Galalea. A itatedisa batho bangwe go nna barutwa, mme le ene a swa, mme balatedi ba gagwe ba phatlalala. ");
INSERT INTO tsn_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Mme jaanong kgakololo ya me ke e, tlogelang banna ba, mme fa se ba se rutang le se ba se dirang e le ga bone fela, ka bofefo se tlaa fedisiwa. ");
INSERT INTO tsn_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Mme fa e le ga Modimo lo tlaa retelelwa ke go ba emisa, e sere kgotsa lona ka bo lona lwa iphitlhela lo tlhabantsha Modimo.” ");
INSERT INTO tsn_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Lekgotla la dumalana le kgakololo ya gagwe, ba bitsa baaposetoloi, ba ba itaya, ba ba bolelela gore ba seka ba tlhola ba bua ka leina la ga Jesu, mme morago ba ba lesa ba tsamaya. ");
INSERT INTO tsn_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ba tloga fa lekgotleng ba itumeletse gore Modimo o ba supile ba nonofile go tlontlologela leina la one. ");
INSERT INTO tsn_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Mme ka malatsi otlhe mo Tempeleng le mo motsing, ba tswelela go ruta le go rera gore Jesu ke Mesia. ");
INSERT INTO tsn_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mme ya re ka go ntsifala ga badumedi ka bofefo, ga nna le dingongorego. Ba ba buang puo ya Segerika fela ba ngongoregela gore batlholagadi ba bone ba a kgethololwa ga ba newe dijo tse di lekanyeng ka nako ya fa go abiwa dijo, jaaka go fiwa ba ba buang Sehebera. ");
INSERT INTO tsn_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jalo ba ba lesome le bobedi ba bitsa phuthego ya badumedi botlhe ba re, “Re tshwanetse go dirisa nako ya rona mo go rereng, e seng go tsamaisa thulaganyo ya dijo. ");
INSERT INTO tsn_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ke gone bakaulengwe ba ba rategang, senkang banna ba supa mo gare ga lona, ba ba botlhale ba bile ba tletse Mowa O O Boitshepo, ba ba itsegeng ka molemo mo bathong botlhe; mme re tlaa ba tlhoma go nna batsamaisi ba tiro e. ");
INSERT INTO tsn_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Mme re tlaa dirisa nako ya rona mo thapelong, mo therong, le mo thutong.” ");
INSERT INTO tsn_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Mme mo ga utlwala sentle mo phuthegong yotlhe, mme ba tlhopha ba ba latelang: Setefane, (monna yo o tletseng tumelo le Mowa O O Boitshepo), Filipo, Porokoro, Nikanore, Timone, Paramenase, Nikolase wa Antioka (Modichaba yo o sokologetseng mo tumelong ya Sejuta, yo o rileng la bofelo a sokologela mo Bokereseteng). ");
INSERT INTO tsn_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Mme ba ba supang ba, ba isiwa fa pele ga Baaposetoloi ba ba baya diatla ba ba rapelela ba ba kopela tshegofatso. ");
INSERT INTO tsn_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Molaetsa wa Modimo wa rerwa ka bophara mo tikologong yotlhe, mme palo ya barutwa ya ntsifala ka go anama mo Jerusalema; mme baperesiti ba Sejuta ba le bantsi le bone ba sokologa. ");
INSERT INTO tsn_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Setefane, monna yo o tletseng tumelo le nonofo ya Mowa O O Boitshepo a dira dikgakgamatso tse dikgolo tse di sa tlwaelesegang mo bathong. ");
INSERT INTO tsn_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mme ya re ka letsatsi lengwe banna bangwe ba tumelo ya Sejuta ba simolola go ganetsanya nae, mme ya re ka bofefo ba kopana le Bajuta ba ba tswang kwa Saerine, Alekesandria mo Egepeto, le mo dikgaolong tsa Take, ebong Kilikia le Ausia. ");
INSERT INTO tsn_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mme go ne go se ope wa bone yo o emelanang le botlhale le mowa wa ga Setefane. ");
INSERT INTO tsn_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mme ba tlisa bangwe ba banna go tla go bua maaka ka ga gagwe ba re ba utlwile Setefane a tlhapatsa Moshe, le Modimo tota. ");
INSERT INTO tsn_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mme ditshele tse, tsa dira gore batho ba tsogologele Setefane, mme baeteledipele ba Sejuta ba mo tshwara ba mo tlisa fa pele ga lekgotla. ");
INSERT INTO tsn_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Basupi ba maaka ba supa gore Setefane o ne a aga a bua kgatlhanong le Tempele le melao ya ga Moshe. ");
INSERT INTO tsn_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Mme ba re, “Re mo utlwile a re Jesu wa Nasaretha o tlaa senya Tempele le melao yotlhe ya ga Moshe.” ");
INSERT INTO tsn_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ya re ka nako eo botlhe ba ba neng ba le mo lekgotleng ba bona sefatlhogo sa ga Setefane se tsabakela jaaka sa moengele. ");
INSERT INTO tsn_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mme Moperesiti yo Mogolo a mmotsa a re, “A mafoko a, a boammaaruri?” ");
INSERT INTO tsn_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Mme Setefane a araba ka boleele a re, “Mo-dimo o o galalelang o ne wa iponatsa mo go rraetsho Aberahame mo Iraka pele ga a ya kwa Seria, ");
INSERT INTO tsn_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","mme wa mo raya wa re a tloge mo lefatsheng la ga gabo, a laele ba gagabo a ba a tloge a ye kwa lefatsheng le Modimo o tlaa le mo kaelang. ");
INSERT INTO tsn_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Hong a tswa mo lefatsheng la Bakaladea a ya go nna mo kgaolong ya Harana, mo Seria, go fitlhelela rraagwe a a swa. Mme Modimo wa mmusetsa mono lefatsheng la Iseraele, ");
INSERT INTO tsn_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ga wa ka wa mo naya sepe sa dilo tsa gagwe, le fa e le setsha se sennye sa lefatshe. Le fa go ntse jalo Modimo wa mo solofetsa gore o tlaa mo naya lefatshe lotlhe le ditlogolwana tsa gagwe, le fa ka nako eo a ne a sena bana! ");
INSERT INTO tsn_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“Mme Modimo wa mo raya gape wa re, ditlogolwana tsa gago di tlaa tswa mo lefatsheng leo di ye go nna mo lefatsheng la seeng mme koo di nne batlhanka, selekanyo sa dingwaga di le makgolo a mane. ");
INSERT INTO tsn_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mme Modimo wa ba raya wa re, ‘Ke tlaa otlhaya Chaba e e tlaa ba dirang batlhanka mme morago ga moo batho ba me ba tlaa boela mo lefatsheng le la Iseraele ba nkobamela teng.’ ");
INSERT INTO tsn_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Gape Modimo wa neela Aberahame kgolagano ya bogwera ka nako eo; e le kgolagano fa gare ga Modimo le batho ba ga Aberahame, mme Isake, morwa Aberahame a rupisiwa fa a le malatsi a fera bobedi a tshotswe. Isake a tsala Jakobe, Jakobe a tsala ditlhogo di le lesome le bobedi tsa lotso lwa Sejuta. ");
INSERT INTO tsn_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Mme batho ba, ba ne ba fufegela Josefa thata ba bo ba mo rekisa go ya go nna motlhanka kwa Egepeto. Mme Modimo o ne wa nna nae, ");
INSERT INTO tsn_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","o ne wa mo golola mo tlalelong yotlhe ya gagwe, wa mo naya tlotlego mo go Farwe Kgosi ya Egepeto. Gape Modimo wa naya Josefa botlhale jo bogolo, mo Farwe o ileng a mo tlhopha go nna molaodi mo Egepeto yotlhe, a bo a mmaya motlhokomedi wa ditiro tsotlhe tsa segosi. ");
INSERT INTO tsn_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Mme ga nna leuba mo Egepeto le Kanana, mme ga nna le bohutsana jo bogolo mo go borraetsho. Erile fa dijo tsa bone di setse di fedile, ");
INSERT INTO tsn_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jakobe a utlwa fa go sa ntse go na le mabele kwa Egepeto, jalo a romela bomorwawe go ya go a reka. ");
INSERT INTO tsn_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Erile fa ba ya labobedi, Josefa a itshenolela bomogolowe, mme ba itsisiwe Farwe. ");
INSERT INTO tsn_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","“Mme Josefa a romela bangwe go ya go tsaya rraagwe ebong Jakobe le ba malwapa a bomogolowe botlhe go tla Egepeto, botlhe e ne e le batho ba le masome a supa le botlhano. ");
INSERT INTO tsn_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jalo Jakobe a tla Egepeto, kwa o neng a swela teng, le bana botlhe ba gagwe. ");
INSERT INTO tsn_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Mme botlhe ba ne ba isiwa kwa Shekema ba fitlhwa mo lebitleng le Aberahame o neng a le rekile mo go bomorwa Hamore, rraagwe Shekema. ");
INSERT INTO tsn_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","18","Mme erile fa nako e atamela e Modimo o neng o tlaa diragatsa tsholofetso ya one mo go Aberahame go golola bana ba gagwe mo botlhankeng, Bajuta ba ntsifala thata mo Egepeto; mme ga tlhongwa kgosi e e neng e sena tlotlo mo segopotsong sa ga Josefa. ");
INSERT INTO tsn_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kgosi e ya nna kgatlhanong le losika lwa rona, ya pateletsa batsadi go latlhela bana ba bone mo masimong. ");
INSERT INTO tsn_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Mme ka nako eo Moshe a tsalwa, ngwana yo o neng a bonala a na le bontle jwa Se-Modimo. Batsadi ba gagwe ba mo fitlha mo lwapeng se-lekanyo sa dikgwedi tse tharo, ");
INSERT INTO tsn_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","mme ya re kwa bofelong ba sa tlhole ba kgona go mo fitlha, ebile ba tshwanelwa ke go mo latlha, morwadia Farwe a mmona mme a mo ikgodisetsa e le ngwana wa gagwe, ");
INSERT INTO tsn_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","mme a mo ruta botlhale jotlhe jwa Baegepeto, mme a nna kgosana e kgolo le sebui se se tumileng. ");
INSERT INTO tsn_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Mme erile letsatsi lengwe fa a atamela bo-tsalo jwa letsatsi la gagwe la dingwaga tse di masome a mane, a tlelwa ke mogopolo wa go etela ba ga gabo, batho ba Iseraele. ");
INSERT INTO tsn_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Mo loetong lo a bona Moegepeto a sotla Moiseraele. Jalo Moshe a bolaya Moegepeto. ");
INSERT INTO tsn_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moshe o ne a gopola gore ba ga gabo ba tlaa lemoga gore Modimo o mo rometse go tla go ba thusa, mme ba se ka ba lemoga. ");
INSERT INTO tsn_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Ka letsatsi le le latelang a ba etela gape mme a fitlhela banna ba le babedi ba Baiseraele ba lwa. Mme a leka go ba letlanya a re ‘Banna, lo bana ba monna ga lo a tshwanela go lwa jaana! Ga go a siama.’ ");
INSERT INTO tsn_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Mme monna yo o molato a raya Moshe a re, ‘Re tlhokomologe o tlhokomele tsa gago. Ke mang yo o go beileng molaodi le moatlhodi mo go rona?’ ");
INSERT INTO tsn_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","A o rata go mpolaya jaaka o bolaile Moegepeto yole maabane? ");
INSERT INTO tsn_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","“Mme ka ntlha ya lefoko le, Moshe a tswa mo Egepeto, a tshabela kwa lefatsheng la Mediana, kwa o neng a tsala bana ba basimane ba le babedi gone. ");
INSERT INTO tsn_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Morago ga dingwaga di le masome a mane, mo sekakeng gaufi le Thaba ya Senai, moengele a iponatsa mo go ene a le mo kgabong ya molelo mo setlhareng. ");
INSERT INTO tsn_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moshe a bona tiragalo e, mme a hakgamala gore ke eng, mme ya re a sianela go ya go bona, lentswe la Morena la bua nae le re, ");
INSERT INTO tsn_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ke Modimo wa bo-rraeno mogolwagolwane, Modimo wa ga Aberahame, Isake le Jakobe!’ Moshe a roroma ka poifo e kgolo mme a se ka a batla go leba. ");
INSERT INTO tsn_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Mme Morena a mo raya a re, ‘Rola ditlhako tsa gago, gonne o eme mo mmung o o boitshepo. ");
INSERT INTO tsn_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ke bonye kutlobotlhoko ya batho ba me ba ba kwa Egepeto ebile ke utlwile selelo sa bone. Ke tsile go ba golola. Tla, ke tlaa go romela kwa Egepeto.’ ");
INSERT INTO tsn_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mme jalo Modimo wa romela ene tota motho yo ba ga bone ba kileng ba mo gana ka go mo raya ba re, ‘Ke mang yo o go beileng molaodi le moatlhodi mo go rona?’ Moshe o ne a rometswe go ya go nna molaodi le mmoloki wa bone. ");
INSERT INTO tsn_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mme ka dikgakgamatso tse dintsi a ba ntsha mo Egepeto a ba kgabagantsha Lewatle le le Hibidu, a bo a ba ralatsa sekaka selekanyo sa dingwaga di le masome a mane. ");
INSERT INTO tsn_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Moshe ka boene o ne a raya batho ba Iseraele a re, ‘Modimo o tlaa tsosa moporofiti yo o tshwanang le nna mo gare ga bo-morwa rraa lona.’ ");
INSERT INTO tsn_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mme se se ne sa supega se le boammaaruri, gonne mo sekakeng, Moshe e ne e le ene yo o fa gare, motsereganyi fa gare ga batho ba Iseraele le moengele yo o neng a ba naya molao wa Modimo, Lefoko le le Tshelangmo thabeng ya Senai. ");
INSERT INTO tsn_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Mme borraetsho ba ne ba gana Moshe, ba batla go boela kwa Egepeto. ");
INSERT INTO tsn_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","“Ba raya Arone ba re, ‘Re direle medimo ya disetwa, gore re tle re nne le medimo e e re etelelang pele go boela kwa morago; gonne ga re itse gore go rileng kaga Moshe yo o re ntshitseng mo Egepeto.’ ");
INSERT INTO tsn_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Mme ba dira modimo wa namane mme ba o ntshetsa ditlhabelo, mme ba itumelela selo se, se ba se dirileng. ");
INSERT INTO tsn_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Mme Modimo wa ba huralela wa ba tlogela, mme wa ba lesa ba direla letsatsi, ngwedi le dinaledi jaaka medimo ya bone! Mo lokwalong lwa polelelopele ya ga Amose, Modimo o botsa jaana wa re, ‘Iseraele, a o ne o direla nna setlhabelo mo sekakeng selekanyo sa dingwaga di le masome a mane? ");
INSERT INTO tsn_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nnyaa, tota kgatlhego ya gago e ne e le mo medimong ya seheitane ebong Sakutlhe, le modimo wa naledi Kaiwae, le mo ditshwantshong tsotlhe tse o di dirileng. Jalo ke tlaa go isa botshwarong kgakala go feta Babelone.’ ");
INSERT INTO tsn_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Mme borraetsho mogolwagolwane ba ne ba tsamaya le motlaagana ba ralala sekaka. Mo teng ga one ba ne ba beile matlapa a go neng go kwadilwe Melao e e Lesome mo go one. Kago e, e ne e agilwe fela ka thulaganyo e Moshe o neng a e kaetswe ke moengele. ");
INSERT INTO tsn_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Erile morago ga dingwaga, fa Joshua a eteletse pele dintwa kgatlhanong le Badichaba, Motlaagana o ba tsena nao mo lefatsheng le lesha, mme wa dirisiwa go fitlhelela mo lobakeng lwa ga Kgosi Dafide. ");
INSERT INTO tsn_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","“Modimo o ne wa segofatsa Dafide a kopa tetlelelo ya go agela Modimo wa ga Jakobe Tempele e e siameng. ");
INSERT INTO tsn_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Mme tota e ne ya agiwa ke Solomone. ");
INSERT INTO tsn_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","49","Le fa go ntse jalo, Modimo ga o nne mo Ditempeleng tse di agilweng ka diatla tsa batho. Morena o bua ka baporofiti jaana a re, ‘Legodimo ke setilo sa me sa bogosi, mme lefatshe ke sebeo sa dinao tsa me’. Morena o botsa jaana a re, ‘Lo ka nkagela ntlo e e ntseng jang? A ke ka nna mo go yone? ");
INSERT INTO tsn_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","A ga ke a dira legodimo le lefatshe?’ ");
INSERT INTO tsn_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Baheitane ke lona ba lo thamo di thata! A lo tshwanetse go ganetsa Mowa O O Boitshepo ka bosakhutleng? Mme borraalona ba ne ba dira jalo, a le lona lo dira jalo! ");
INSERT INTO tsn_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Bolelang moporofiti mongwe yo borralona ba iseng ba ke ba mmogise! Ba bolaile le ene tota yo o ntshitseng polelelopele ya go tla ga Mosiami, Mesia yo lo mo okileng lwa ba lwa mmolaya. ");
INSERT INTO tsn_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ee, lo sentse Melao ya Modimo ka bomo, le fa lo ne lo e amogetse mo diatleng tsa baengele.” ");
INSERT INTO tsn_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Mme baeteledipele ba Sejuta ba tenwa thata ke go omanngwa ke Setefane ba bo ba mo shenela meno ka kgakalo. ");
INSERT INTO tsn_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mme Setefane, a tletse Mowa O O Boitshepo, a leba ka iketlo kwa legodimong, a bona kgalalelo ya Modimo le Jesu a ntse ka fa letsogong le legolo la Modimo. ");
INSERT INTO tsn_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Mme a ba raya a re, “Bonang, ke bona legodimo le bulegile mme Jesu Mesia a eme fa thoko ga Modimo, ka fa letsogong la one le legolo!” ");
INSERT INTO tsn_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Mme ba mo gagautlha, ba ikaba ditsebe, ba tima lentswe la gagwe ka go goa thata, ");
INSERT INTO tsn_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","mme ba mo gogela kwa ntle ga motse go ya go mo kgobotletsa ka matlapa. Basupi ba bagolo le babolai ba apola dibaki tsa bone ba di baya fa dinaong tsa lekawana lengwe le le bidiwang Saulo. ");
INSERT INTO tsn_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mme erile fa babolai ba mo kgobotletsa ka maje, Setefane a rapela a re, “Morena Jesu, amogela Mowa wa me.” ");
INSERT INTO tsn_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mme a wela fa fatshe ka mangole, a goa a re, “Morena o se ka wa ba bona molato ka ntlha ya boleo jo!” Mme ka mafoko ao, a swa. ");
INSERT INTO tsn_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Mme Saulo o ne a dumalana le gore Setefane a bolawe. Mme pogiso e kgolo ya badumedi ya simologa ka letsatsi leo, ya tlhasela, mme mongwe le mongwe a tshabela kwa Judea le Samaria kwa ntle ga baaposetoloi fela. ");
INSERT INTO tsn_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","(Mme bangwe ba badumedi ba Bajuta ba tla go fitlha Setefane ka kutlo-botlhoko e kgolo). ");
INSERT INTO tsn_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mme Saulo o ne a nna jaaka setsenwa, a tsamaya gongwe le gongwe a nyeletsa badumedi, a tsena mo matlung a swatola banna le basadi a ba tsenya mo kgolegelong. ");
INSERT INTO tsn_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mme badumedi ba ba neng ba tshabile kwa Jerusalema ba ne ba tsamaya gongwe le gongwe ba rera Mafoko a a Molemo kaga Jesu! ");
INSERT INTO tsn_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Jaaka Filipo, yo o neng a ya kwa Samaria go bolelela batho ka ga Keresete teng. ");
INSERT INTO tsn_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bontsintsi jo bogolo jwa batho bo ne jwa reetsa thata se o neng a tshwanetse go se bua ka ntlha ya go bona dikgakgamatso tse o neng a di dira. ");
INSERT INTO tsn_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mewa e le mentsi e e maswe e ne ya ntshediwa kwa ntle, e goa fa e tswa mo bathong ba e neng e ba tsenye, mme ba le bantsi ba ba neng ba tetesela kgotsa ba ba neng ba golafetse ba fodisiwa, ");
INSERT INTO tsn_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","mme ga nna boitumelo jo bogolo mo motseng oo! ");
INSERT INTO tsn_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","11","Mme monna mongwe yo o neng a bidiwa Simone o ne a kile a bo a dira boloi ka dingwaga di le dintsi; e ne e le monna yo o tlhotlheletsang thata, a bile a le boikgogomoso ka ntlha ya dikgakgamatso tse o neng a di dira mo e leng gore Basamaria ba ne ba tlwaetse go bua kaga gagwe ba re ke Mesia. ");
INSERT INTO tsn_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Mme jaanong ba ne ba dumela molaetsa wa ga Filipo gore Jesu e ne e le Mesia, le mafoko a gagwe kaga Bogosi jwa Modimo; mme go ne ga kolobediwa banna le basadi ba le bantsi. ");
INSERT INTO tsn_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Mme Simone ka sebele a dumela a bo a kolobediwa jalo a simolola go sala Filipo morago gongwe le gongwe kwa a yang teng, mme o ne a hakgamadiwa ke dikgakgamatso tse (Filipo) o neng a di dira. ");
INSERT INTO tsn_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Mme erile fa baaposetoloi kwa Jerusalema ba utlwa fa batho ba Samaria ba amogetse molaetsa wa Modimo, ba romela Petere le Johane. ");
INSERT INTO tsn_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Erile fela jaaka ba goroga ba simolola go rapelela Bakeresete ba basha ba, go amogela Mowa O O Boitshepo. ");
INSERT INTO tsn_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Gonne o ne o ise o tle mo go ope wa bone ka gonne ba ne ba kolobeditswe fela mo leineng la Morena Jesu. ");
INSERT INTO tsn_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Jalo Petere le Johane ba baya diatla tsa bone mo badumeding ba, mme ba amogela Mowa O O Boitshepo. ");
INSERT INTO tsn_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Erile Simone a bona se, gore Mowa O O Boitshepo o ne o fologela mo bathong fa Baaposetoloi ba ba baya diatla, a ntsha madi go reka nonofo e. ");
INSERT INTO tsn_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Mme o ne a re, “Le nna nnayang nonofo e, gore mongwe le mongwe yo ke mmayang diatla a amogele Mowa O O Boitshepo!” ");
INSERT INTO tsn_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Mme Petere a mo fetola a re, “A madi a gago a nyelele le wena gonne o gopola gore mpho ya Modimo e ka rekwa! ");
INSERT INTO tsn_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ga o ka ke wa nna le seabe mo go se, gonne pelo ya gago ga e a siama fa pele ga Modimo. ");
INSERT INTO tsn_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Sokologa mo tshiamololong e, mme o rapele. Gongwe Modimo o tlaa itshwarela dikakanyo tsa gago tse di bosula, ");
INSERT INTO tsn_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","gonne ke bona fa go na le lefufa le boleo mo pelong ya gago.” ");
INSERT INTO tsn_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Mme Simone a re, “Nthapelela gore dilo tse di maswe tse di se ntiragalele.” ");
INSERT INTO tsn_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Morago ga bosupi le thero mo Samaria, Petere le Johane ba ne ba boela Jerusalema, mme ba tla ba ema mo metsaneng ya Samaria mo tseleng go rera Mafoko a a Molemo. ");
INSERT INTO tsn_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mme Filipo ene, moengele wa Morena a mo raya a re, “Ya kwa tseleng e e tswang Jerusalema e e ralalang sekaka sa Gasa, o goroge motshegare.” ");
INSERT INTO tsn_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Mme o ne a dira jalo, mme ya re mo tseleng ga bo go tla mang fa e se motshola madi wa Itopia, moopa wa taolo kgolo ka fa tlase ga Kgosigadi ya Itopia. O ne a ile Jerusalema go rapela kwa Tempeleng, ");
INSERT INTO tsn_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","mme o ne a bowa a le mo kareng ya gagwe a balela kwa godimo mo lokwalong lwa ga moporofiti Isaia. ");
INSERT INTO tsn_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Mowa O O Boitshepo wa raya Filipo wa re, “Tsamaya o ye gaufi le kara!” ");
INSERT INTO tsn_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipo a taboga mme a utlwa se o neng a se bala mme jalo a botsa a re, “A o tlhaloganya se o se balang?” ");
INSERT INTO tsn_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mme monna a fetola a re, “Tota ga ke tlhaloganye! Nka tlhaloganya jang go sena yo o ntlhalosetsang?” Jalo a kopa Filipo go palama kara gore a tle go nna nae. ");
INSERT INTO tsn_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Se o neng a se bala mo lokwalong se ne se balega jaana. “O ne a gogwa jaaka nku e isiwa kwa matlhabelong, le jaaka kwanyana e e didimetseng fa pele ga babeodi ba yone, ga a ka a tswa molomo; ");
INSERT INTO tsn_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","mo go sotlweng ga gagwe, ga a ka a direlwa tshiamo; mme ke mang yo o ka ranolang bomaswe jwa losika lwa gagwe? Gonne botshelo jwa gagwe bo tlositswe mo lefatsheng.” ");
INSERT INTO tsn_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mme moopa a botsa Filipo a re, “A Isaia o ne a bua ka ga gagwe kgotsa ka mongwe?” ");
INSERT INTO tsn_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Mme jaana Filipo a simolola ka lokwalo lo, le tse dingwe di le dintsi go mmolelela kaga Jesu. ");
INSERT INTO tsn_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Erile ba ntse ba tsamaya ka koloi, ba fitlha fa metsing mangwe, moopa a re, “Metsi ke a, ke eng fa ke sa kolobediwe?” ");
INSERT INTO tsn_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipo o ne a mo araba a re, “O ka kolobediwa fa o dumela ka pelo ya gago yotlhe.” Mme moopa a fetola a re, “Ke dumela gore Jesu Keresete ke Morwa Modimo.” ");
INSERT INTO tsn_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Mme a emisa kara ya gagwe ba fologela mo teng ga metse mme Filipo a mo kolobetsa. ");
INSERT INTO tsn_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Mme erile fa ba tswa mo metsing, Mowa wa Modimo wa tsaya Filipo, mme moopa a seka a tlhola a mmona gape, mme a tswelela mo tseleng ya gagwe a itumetse. ");
INSERT INTO tsn_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Mme ka nako eo Filipo ene a ipona a le kwa Asoto. O ne a rera Mafoko a a Molemo gone koo le mo motseng mongwe le mongwe mo tseleng, fa a ya Kaesara. ");
INSERT INTO tsn_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mme Saulo, ka go tshosa ka bogale jwa go nyeletsa Mokeresete mongwe le mongwe, o ne a ya kwa Moperesiting yo mogolo kwa Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","O ne a kopa lokwalo lo lo kwaletsweng diphuthego kwa Damaseko, a kopa thuso ya go bogisa badumedi ba o tlaa ba bonang teng, banna le basadi gore a tle a ba lere kwa Jerusalema ba golegilwe. ");
INSERT INTO tsn_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Mme mo loetong lo, ya re a atamela Damaseko ka tshoganetso lesedi le le galalelang thata la mo phatsimela le tswa legodimong! ");
INSERT INTO tsn_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","O ne a wela fa fatshe mme a utlwa lentswe le re, “Saulo! Saulo! o mpogisetsang?” ");
INSERT INTO tsn_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Mme ene a re, “O mang Morena?” Jalo lentswe la fetola la re, “Ke Jesu yo o mmogisang! ");
INSERT INTO tsn_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Jaanong tsoga o tsene mo motseng mme o letele ditaelo tsa me.” ");
INSERT INTO tsn_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Mme banna ba ba neng ba na le Saulo ba ema ba tuulala ka kgakgamalo, gonne ba ne ba utlwa lentswe la mongwe mme ba sa mmone! ");
INSERT INTO tsn_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","9","Mme erile fa Saulo a tsoga fa fatshe a bo a sa bone. O ne a tshwanelwa ke go gogelwa kwa Damaseko kwa o neng a nna teng malatsi a mararo, a sa bone, a sa je, a sa nwe ka nako eo yotlhe. ");
INSERT INTO tsn_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Mme mo Damaseko go ne go na le morutwa, ebong Ananiase. Modimo o ne wa bua nae mo ponatshegelong wa re, “Ananiase!” Mme a re, “Morena”! ");
INSERT INTO tsn_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mme Morena a re, “Tsamaya o ye kwa mmileng o go tweng Tolamo o batle ntlo ya monna yo o bidiwang Judase mme o botse gore Saulo wa Tareso o kae. O a rapela gone jaanong, gonne ");
INSERT INTO tsn_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ke mmontshitse ponatshegelo ya monna yo o bidiwang Ananiase a tla go baya diatla tsa gagwe mo go ene gore a foufologe gape!” ");
INSERT INTO tsn_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Mme Ananiase a re, “Morena, ke utlwile kaga dilo tse di sa siamang tse monna yo o di dirileng mo badumeding kwa Jerusalema! ");
INSERT INTO tsn_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Gape re utlwa gore o tshotse tetlelelo ya go tshwara e e tswang kwa baperesiting ba bagolo go mo fa thata ya go tshwara modumedi mongwe le mongwe mo Damaseko!” ");
INSERT INTO tsn_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Mme Morena a re, “Tsamaya o dire se ke se buang. Gonne Saulo ke sejana same se se tlhaotsweng go isa molaetsa wame mo go Badichaba le mo dikgosing tsa bone, le mo bathong ba Iseraele. ");
INSERT INTO tsn_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mme ke tlaa mo supegetsa gore o tshwanetse go mpogela go le kae.” ");
INSERT INTO tsn_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Mme Ananiase a tsamaya a bona Saulo a bo a mmaya diatla a re, “Mokaulengwe Saulo, Morena Jesu yo o neng a go ipontsha mo tseleng, o nthomile gore o tle o tladiwe ka Mowa O O Boitshepo le gore o foufologe.” ");
INSERT INTO tsn_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ya re gone fela foo (ya ne ekete go wa dikgapetlana mo matlhong a ga Saulo) a foufologa, mme ka bonako a kolobediwa. ");
INSERT INTO tsn_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Mme a ja mme a nonofa. O ne a nna le badumedi mo Damaseko malatsinyana, ");
INSERT INTO tsn_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","mme erile gone fela foo a ya kwa tlung ya thuto go bolelela mongwe le mongwe Mafoko a a Molemo kaga Jesu, gore tota ke Morwa Modimo! ");
INSERT INTO tsn_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Botlhe ba ba neng ba mo utlwa ba ne ba hakgamala. Ba ne ba botsa ba re, “A monna yo ga se ene yo o neng a bogisa thata balatedi ba ga Jesu kwa Jerusalema? Mme re utlwa gore o tletse fano go tla go ba tshwara botlhe mme a ba golega go ba isa kwa baperesiting ba bagolo.” ");
INSERT INTO tsn_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulo o ne a nna tlhaga thata mo therong ya gagwe, mme Bajuta ba Damaseko ba ne ba sa kgone go emela ditshupo tsa gagwe gore Jesu tota e ne e le Keresete. ");
INSERT INTO tsn_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Moragonyana, baeteledipele ba Sejuta ba ikaelela go mmolaya. ");
INSERT INTO tsn_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Mme o ne a bolelelwa kaga maikaelelo a bone, gore ba ne ba tlhokometse dikgoro tsa motse bosigo le motshegare ba ipaakanyeditse go mmolaya. ");
INSERT INTO tsn_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mme erile bosigo bangwe ba o ba sokolotseng ba mo falotsha ka kgorwana mo loboteng lwa motse a le mo serotong. ");
INSERT INTO tsn_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Erile fa a goroga kwa Jerusalema a leka go kopana le badumedi, mme ba ne ba mo tshaba. Ba ne ba gopola gore o itira yo o dumelang! ");
INSERT INTO tsn_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Jalo Barenabase a mo tlisa mo baaposetoloing mme a ba bolelela ka fa Saulo a ileng a bona Morena ka teng mo tseleng a ya Damaseko, le se Morena o neng a se bua nae, le ka thero ya gagwe e e nonofileng ka leina la ga Jesu kwa Damaseko. ");
INSERT INTO tsn_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Mme ba mo amogela, mme morago ga moo o ne a nna le badumedi ka nako tsotlhe, ");
INSERT INTO tsn_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","mme a rera ka bopelokgale mo leineng la Morena. Mme Bajuta bangwe ba ba neng ba bua Segerika ba o kileng a ganetsana nabo ba loga leano la go mmolaya. ");
INSERT INTO tsn_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Le fa go ntse jalo, erile badumedi ba bangwe ba utlwa diphatsa tse a leng mo go tsone, ba mo isa kwa Kaesarea mme ya re morago ga moo ba mo isa kwa ga gabo kwa Tareso. ");
INSERT INTO tsn_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Erile ka lobaka lo, phuthego e ne e le mo kagisong mo ntlheng tsotlhe tsa Judea, Galalea le Samaria, mme tsa gola mo nonofong le mo palong. Badumedi ba ithuta go tsamaya ba boifa Morena mo kgomotsong ya Mowa O O Boitshepo. ");
INSERT INTO tsn_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petere o ne a tsamaya mafelo a a farologanyeng go ba etela, o ne a etela le badumedi ba ba kwa motseng wa Lida. ");
INSERT INTO tsn_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Teng koo, a kopana le monna yo o neng a bidiwa Aenease, yo o neng a gateletswe ke bolwetse a bile a sa kgone go tsoga mo bolaong ka dingwaga di roba bobedi. ");
INSERT INTO tsn_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Mme Petere a mo raya a re, “Aenease! Jesu Keresete o go fodisitse! Tsoga o baakanye bolao jwa gago.” Mme erile fela gone foo a fodisiwa. ");
INSERT INTO tsn_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Mme batho botlhe ba Lida le ba Sharona ba sokologela mo Moreneng fa ba bona Aenease a tsamaya. ");
INSERT INTO tsn_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mo motseng wa Jopa go ne go na le mosadi a bidiwa Dorokase, (le fa e le Tshephe) modumedi yo o neng a tshela a direla ba bangwe bo-molemo, bogolo jang batlhoki. ");
INSERT INTO tsn_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ka nako eo o ne a lwala mme a swa. Ditsala tsa gagwe tsa mmaakanyetsa phitlho mme tsa mo robatsa mo ntlwaneng e e kwa godimo. ");
INSERT INTO tsn_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Mme erile fa ba utlwa fa Petere a le gaufi mo Lida, ba roma banna ba le babedi go kopa go boela le bone kwa Jopa. ");
INSERT INTO tsn_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Mme o ne a dira jalo, erile fela fa a goroga, ba mo tseela kwa ntlwaneng ee kwa go-dimo kwa Dorokase o neng a beilwe teng. Ntlo e ne e tletse batlholagadi ba ba lelang ba ba neng ba bontshana diaparo tse Dorokase o di ba diretseng. ");
INSERT INTO tsn_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Mme Petere a ba kopa gore botlhe ba tswele kwa ntle; jalo a khubama a rapela. Erile a retologela kwa setopong a re, “Tsoga Dorokase,” mme a bula matlho! Ya re a bona Petere a tsoga! ");
INSERT INTO tsn_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","A mo naya letsogo a mo thusa go tsoga mme a biletsa badumedi botlhe le batlholagadi mo teng, a ba mo neela! ");
INSERT INTO tsn_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Dikgang tsa anama le motse, mme ba le bantsi, ba dumela mo Moreneng. ");
INSERT INTO tsn_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Mme Petere a nna lobaka lo loleele mo Jopa, a nna le Simone, wa mosuga matlalo. ");
INSERT INTO tsn_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mme mo Kaesarea go ne go nna mo eteledipele wa mophato wa ntwa ya Seroma gotwe Korenelio, e le molaodi wa mophato wa Itale. ");
INSERT INTO tsn_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","E ne e le motho yo o ratang Modimo, a bile a o tlotla thata, le ba ntlo ya gagwe ba ne ba ntse jalo. O ne a aba ka mowa o o gololesegileng a bile a le motho wa thapelo. ");
INSERT INTO tsn_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Tshokologo nngwe ya letsatsi ya re a santse a ntse, ka nako e ka nna ya boraro, a bona ponatshegelo, mme mo ponatshegelong e, a bona moengele wa Modimo a tla kwa go ene a re, “Korenelio”. ");
INSERT INTO tsn_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Korenelio a re, “O batlang Morena!” Moengele a fetola a re, “Dithapelo tsa gago le dimpho tsa gago Modimo o di bonye. ");
INSERT INTO tsn_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","6","Jaanong roma banna bangwe kwa Jopa go ya go batla mongwe yo o bidiwang Simone Petere, yo o nnang le Simone wa mosuga matlalo, go bapa le lotshitshi lwa lewatle, mme lo mo kope gore a lo etele.” ");
INSERT INTO tsn_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Erile moengele a sena go tsamaya, Korenelio a bitsa batlhanka ba ntlo ya gagwe ba le babedi le motlhabani yo o boifang Modimo, mongwe wa ba ba ikanyegang, ");
INSERT INTO tsn_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","mme a ba bolelela se se diragetseng a bo a ba roma kwa Jopa. ");
INSERT INTO tsn_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","10","Erile letsatsi le le latelang, fa ba atamela motse, Petere a tlhatlogela kwa godimo ga ntlo ya gagwe go rapela. Go ne go le motshegare ebile o ne a tshwerwe ke tlala, mme erile dijo tsa motshegare di sa ntse di baakanngwa a bona ponatshegelo. ");
INSERT INTO tsn_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","O ne a bona legodimo le bulega, mme a bona letsela le legolo le lepeleditswe ka dinaka tsa lone tse nne, le fitlha fa fatshe. ");
INSERT INTO tsn_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mme mo letseleng go ne go le diphologolo tsa mefuta yotlhe, dinoga le dinonyane (tse di idiwang Bajuta go di ja). ");
INSERT INTO tsn_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Mme lentswe la mo raya la re, “Tsamaya o bolaye o je nngwe ya tsone e o e batlang.” ");
INSERT INTO tsn_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petere a fetola a re, “Nnyaa, Morena, ga ke ise nke ke je diphologolo tse di ntseng jaana mo botshelong jwa me, gonne di a idiwa ka melao ya rona ya Sejuta.” ");
INSERT INTO tsn_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Lentswe la bua gape, la re, “Se ganetsanye le Modimo! Fa o re selo se tshwanetse go jewa go raya gore se siame.” ");
INSERT INTO tsn_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mme ponatshegelo e ya direga gararo. Mme letsela la boela gape kwa legodimong. ");
INSERT INTO tsn_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petere o ne a akabala thata gore ponatshegelo e ka ne e raya eng? O ne a tshwanetse go dirang? Mme jaana banna ba ba romilweng ke Korenelio ba ne ba bone ntlo e, mme ba bo ba eme kwa ntle fa kgorong, ");
INSERT INTO tsn_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ba botsa gore a ntlo e ke yone e Simone Petere o nnang mo go yone. ");
INSERT INTO tsn_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Mme erile Petere a sa ntse a hakgamaletse ponatshegelo, Mowa O O Boitshepo wa mo raya wa re, “Banna ba bararo ba tsile kwa go wena. ");
INSERT INTO tsn_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Fologela kwa tlase o kopane le bone mme o tsamaye nabo. Sengwe le sengwe se siame, ke ba romile.” ");
INSERT INTO tsn_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Jalo Petere a fologa, mme a re, “Ke nna yo lo mmatlang. Jaanong ke eng se lo se batlang.” ");
INSERT INTO tsn_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Mme jalo ba mmolelela kaga Korenelio molaodi wa Mo-Roma yo o siameng wa Modimo, yo o neng a itsege thata mo Bajuteng le jaaka moengele a ne a mo laetse go ya go bitsa Petere go tla go mmolelela se Modimo o batlang a se dira. ");
INSERT INTO tsn_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Mme Petere a ba amogela a bo a ba fa boroko sigong joo. Letsatsi le le tlang a tsamaya nabo, ba na le (badumedi) ba ba tswang Jopa. ");
INSERT INTO tsn_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ba goroga mo Kaesarea letsatsi le le latelang, mme Korenelio o ne a ba letile a bile a biditse ba losika lwa gagwe le ditsala tsa gagwe tsa botlhokwa go nna le Petere. ");
INSERT INTO tsn_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Erile fa Petere a tsena mo ga gagwe, Korenelio a wela fa fatshe fa pele ga gagwe a mo obamela. ");
INSERT INTO tsn_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Mme Petere a re, “Ema! Le nna ka nosi ke motho!” ");
INSERT INTO tsn_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Mme a ema ba buisanya ka sebakanyana ba bo ba ya kwa ba bangwe ba neng ba phuthegetse teng. ");
INSERT INTO tsn_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Mme Petere a ba raya a re, “Lo a itse gore go kgatlhanong, le melao ya Sejuta gore ke tsene mo lolwapeng lwa Modichaba. Mme Modimo o mpontshitse mo ponatshegelong gore ke seka ka ba ka lebela ope kwa tlase. ");
INSERT INTO tsn_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Mme ka tla fela jaaka ke bidiwa. Jaanong mpolelelang se lo se batlang.” ");
INSERT INTO tsn_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Mme Korenelio a fetola a re, “Malatsi a mane a a fetileng ke ne ke rapela jaaka gale ka nako e ya maitseboa, fa ka tshoganetso monna a ema fa pele ga me a apere seaparo se se galalelang! ");
INSERT INTO tsn_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Mme a nthaya a re, ‘Korenelio, thapelo tsa gago di utlwetse le dimpho tsa gago di lemogilwe ke Modimo! ");
INSERT INTO tsn_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Jaanong roma banna bangwe kwa Jopa go itsise Simone Petere, yo o nnang mo motseng wa ga Simone, wa mosuga matlalo, fa lotshitshing lwa lewatle.’ ");
INSERT INTO tsn_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Mme ke ne ka re o ye go bidiwa, mme o dirile sentle ka go tla ka bonako. Jaanong ke rona ba, re letile fa pele ga Morena, re batla go itse se o se go boleletseng go se re bolelela!” ");
INSERT INTO tsn_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Mme Petere a fetola a re, “Ke bona sentle gore Bajuta ga se bone fela ba Modimo o ba ratang! ");
INSERT INTO tsn_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mo chabeng nngwe le nngwe o na le ba ba mo obamelang ba bile ba dira dilo tse di siameng mme mo go ene ba a amogelesega. ");
INSERT INTO tsn_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","37","Ke tlhomamisa gore lo utlwile kaga Mafoko a a Molemo a batho ba Iseraele, gore go na le kagiso mo Modimong ka Jesu, Mesia, yo e leng Morena wa (lobopo) lotlhe. Molaetsa o, o aname le Judea yotlhe, o simolotswe ke Johane wa Mokolobetsi mo Galalea. ");
INSERT INTO tsn_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mme ga go belaesege go itse gore Jesu wa Nasaretha o ne a tlodiwa ke Modimo ka Mowa o o Boitshepo le ka nonofo, mme o ne a tsamaya a dira molemo a bile a fodisa botlhe ba ba neng ba na le mewa e e maswe, gonne Modimo o ne o na nae. ");
INSERT INTO tsn_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Mme rona baaposetoloi re basupi ba tsotlhe tse o di dirileng mo Iseraele yotlhe le mo Jerusalema kwa o neng a bolaelwa teng mo sefapaanong. ");
INSERT INTO tsn_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","41","Mme Modimo o ne wa mo tshedisa gape morago ga malatsi a mararo, mme wa mmontsha basupi bangwe ba Modimo o neng o sale o ba tlhopha pele, e seng mongwe le mongwe, mme e leng rona ba re neng ree ja re ba ree nwa nae a sena go tsoga mo baswing. ");
INSERT INTO tsn_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Mme o ne a re roma go ya go rera Mafoko a a Molemo gongwe le gongwe le go supa gore Jesu o beilwe go nna Moatlhodi wa botlhe, baswi le batshedi. ");
INSERT INTO tsn_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Mme le baporofiti botlhe ba kwadile ka ga gagwe, ba re mongwe le mongwe yo o dumelang mo go ene o tlaa itshwarelwa dibe ka leina la gagwe.” ");
INSERT INTO tsn_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Mme erile Petere a sa ntse a bua dilo tse Mowa O O Boitshepo wa fologela mo go botlhe ba ba neng ba reeditse! ");
INSERT INTO tsn_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Mme Bajuta ba ba neng ba tsile le Petere ba ne ba hakgamala gore neo ya Mowa O O Boitshepo e ka newa le Badichaba! ");
INSERT INTO tsn_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","47","Mme go ne go ka se ka ga nna le pelaelo, gonne ba ba utlwile ba bua ka diteme ba bile ba galaletsa Modimo. Petere o ne a botsa a re, “A mongwe o ka gana gore ke ba kolobetse, ka gore jaanong ba amogetse Mowa O O Boitshepo fela jaaka re ne ra o amogela?” ");
INSERT INTO tsn_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Mme o ne a dira jalo, a ba kolobetsa mo leineng la ga Jesu, Mesia. Morago Korenelio a mo kopa go nna le bone malatsinyana. ");
INSERT INTO tsn_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ka bonako dikgang tsa fitlha kwa baaposetoloing le bakaulengwe ba bangwe kwa Judea gore Badichaba le bone ba amogetse Lefoko la Modimo. ");
INSERT INTO tsn_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Mme erile Petere a boela kwa Jerusalema, badumedi ba Bajuta ba ganetsanya nae. ");
INSERT INTO tsn_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ba ne ba mmaya molato ba re, “O itsalantse le Badichaba ebile o jele nabo.” ");
INSERT INTO tsn_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Mme Petere a ba bolelela polelo yotlhe. ");
INSERT INTO tsn_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","O ne a re, “Erile letsatsi lengwe mo Jopa ke sa ntse ke rapela, ka bona ponatshegelo, letsela le legolo la fologela fa fatshe ka dinaka tsa lone tse nne le tswa legodimong. ");
INSERT INTO tsn_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mo letseleng go ne go le mefuta yotlhe ya diphologolo, digagabi le dinonyane (tse re sa tshwanelang go di ja). ");
INSERT INTO tsn_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mme ke ne ka utlwa lentswe le re, ‘Bolaya mme o je tse o di ratang.’ ");
INSERT INTO tsn_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mme ke ne ka fetola ka re, ‘Nnyaa, Morena, gonne ga ke ise ke ko ke je sepe se se idiwang ka melao ya rona ya Sejuta!’ ");
INSERT INTO tsn_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Mme lentswe la tla gape la re, ‘Se re ga go a siama go jewa fa Modimo One o re go siame.’ ");
INSERT INTO tsn_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","“Mo go ne ga diragala gararo pele ga letsela le tsotlhe tse di neng di le mo go lone di nyelelela kwa legodimong. ");
INSERT INTO tsn_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Mme banna ba bararo ba ba neng ba tsile go ntsaya go ya Kaesarea ba goroga kwa tlung e ke neng ke nna mo go yone! ");
INSERT INTO tsn_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Mme Mowa O O Boitshepo o ne wa nthaya wa re ke tsamaye le bone le gone ke seka ka tshwenyega ka Bodichaba jwa bone! Bakaulengwe ba barataro ba, ba tsamaya le nna, mme ka bofefo ra goroga kwa mo-tseng wa monna yo o neng a romile barongwa. ");
INSERT INTO tsn_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mme a re bolelela ka fa moengele a neng a tla kwa go ene ka teng a mmolelela gore a rome barongwa kwa Jopa go batla Simone Petere. ");
INSERT INTO tsn_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Moengele a mmolelela gore, ‘monna yoo o tlaa go bolelela ka fa wena le ba ntlo ya gago lo ka bolokwang ka teng.’ ");
INSERT INTO tsn_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Mme ka simolola go ba bolelela Mafoko a a Molemo, mme e rile fela jaaka ke simolola thero ya me, Mowa O O Boitshepo wa fologela mo go bone, fela jaaka o ne wa fologela mo go rona pele! ");
INSERT INTO tsn_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","“Mme ke ne ka gopola mafoko a Morena fa a ne a re, ‘Ee, Johane o ne a kolobetsa ka metsi, mme lona lo tlaa kolobediwa ka Mowa O O Boitshepo.’ ");
INSERT INTO tsn_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Mme ka e ne e le Modimo ka boone o o neileng Badichaba ba mpho e e tshwanang le ya rona fa re dumela mo go Morena Jesu Keresete, ke ne ke le mang yo ke ka ganetsang?” ");
INSERT INTO tsn_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Mme erile fa ba bangwe ba utlwa kaga se, dikganetso tsa bone tsotlhe di ne tsa arabiwa mme ba simolola go galaletsa Modimo; ba ne ba re, “Ee, Modimo o neetse le Badichaba tshwanelo ya gore ba sokologele kwa go one le gore ba bone botshelo jo bo sa khutleng!” ");
INSERT INTO tsn_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Mme badumedi ba ba neng ba siile mo Jerusalema ka nako ya pogiso morago ga loso lwa ga Setefane ba tsamaya ba bo ba ya go fitlha kwa Fenikia, le kwa Kupero le kwa Antioka, ba gasa Mafoko a a Molemo mo Bajuteng fela. ");
INSERT INTO tsn_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Le fa go ntse jalo, bangwe ba badumedi ba ba neng ba ya kwa Antioka ba tswa mo Kupero le mo Kurene le bone ba ile ba rerela Bagerika molaetsa wa bone kaga Morena Jesu. ");
INSERT INTO tsn_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Mme Morena o ne a rotloetsa maiteko a gore Badichaba ba le bantsi ba nne badumedi. ");
INSERT INTO tsn_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mme erile phuthego e e kwa Jerusalema e utlwa se se diragetseng, ba romela Barenabase kwa Antioka go thusa ba e leng gone ba sokologang. ");
INSERT INTO tsn_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Erile fa a goroga ebile a bona dikgakgamatso tse Modimo o neng o di dira, a tlala kgakgamalo le boitumelo, mme a kgothatsa badumedi gore le fa go ka nna jang, ba nne mo Moreneng. ");
INSERT INTO tsn_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barenabase e ne e le motho yo o bonolo a tletse Mowa O O Boitshepo a bile a nonofile mo tumelong. Mme ka ntlha ya gone mo, batho ba le bantsi ba ne ba oketsega mo Moreneng. ");
INSERT INTO tsn_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mme Barenabase o ne a ya kwa Tareso go batla Saulo. ");
INSERT INTO tsn_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Erile a mmona a mmusetsa kwa Antioka; ka bobedi jwa bone ba nna koo ngwaga yotlhe, ba ruta badumedi ba basha. (Ke kwa Antioka kwa badumedi ba neng ba simolola go bidiwa “Bakeresete” teng.) ");
INSERT INTO tsn_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ka nako e baporofiti bangwe ba ne ba tswa Jerusalema ba ya Antioka, ");
INSERT INTO tsn_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","mme mongwe wa bone yo o bidiwang Agabuse, o ne a ema ka tlhotlheletso ya Mowa mo go nngwe ya dikopano a bolelela pele gore leuba le legolo le tlaa tla mo lefatsheng la Iseraele. (Mo go ne ga diragala ka nako ya puso ya ga Kalaudio). ");
INSERT INTO tsn_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mme jalo badumedi ba ikaelela go romela thuso kwa Bakereseteng mo Judea, mongwe le mongwe a ntsha kafa a ka kgonang ka teng. ");
INSERT INTO tsn_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Mme ba ile ba dira, ba isa dimpho tsa bone kwa go Barenabase le Saulo gore ba di ise kwa bagolwaneng ba phuthego kwa Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mme ka nako e o Kgosi Herode o ne a nna kgatlhanong le badumedi bangwe, ");
INSERT INTO tsn_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","mme a bolaya moaposetoloi Jakobe (mogoloa Johane). ");
INSERT INTO tsn_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Erile fa Herode a bona gore go itumedisa baeteledipele ba Bajuta jang, a tshwara Petere ka modiro wa Tlolaganyo, ");
INSERT INTO tsn_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","mme a mo tsenya mo kgolegelong, a mmaya ka fa tlase ga tlhokomelo ya masole a le lesome le borataro. Maikaelelo a ga Herode e ne e le go isa Petere kwa Bajuteng gore a bolawe morago ga modiro wa Tlolaganyo. ");
INSERT INTO tsn_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Mme thapelo e e nonofileng e tswa mo phuthegong e ne ya tsena kwa Modimong gore Petere a babalesege ka nako tsotlhe fa a sa ntse a le mo kgolegelong. ");
INSERT INTO tsn_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Bosigo pele ga nako e o neng a tshwanetse go bolawa ka yone, o ne a robetse, a bofilwe thata ka keetane a le fa gare ga masole a le mabedi le ba bangwe ba eme ba tlhokometse fa pele ga kgoro ya kgolegelo, ");
INSERT INTO tsn_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","fa ka tshoganetso go nna lesedi mo ntlwaneng ya kgolegelo mme moengele wa Morena a ema fa thoko ga ga Petere! Moengele a mo itaya fa lotlhakoreng go mo tsosa, a mo raya a re, “Tsoga ka bonako!” Mme dikeetane tsa wa mo mabogong a gagwe! ");
INSERT INTO tsn_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mme moengele a mo raya a re, “Apara o rwale ditlhako tsa gago.” Mme a dira jalo. Moengele a re, “Apara seaparo sa gago o ntshale morago!” ");
INSERT INTO tsn_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Mme Petere a tlogela ntlwana ya kgolegelo, a sala moengele morago. Mme ka nako yotlhe o ne a gopola gore ke toro kana ponatshegelo mme o ne a sa dumele gore tota go a direga. ");
INSERT INTO tsn_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ba ne ba feta ntlwana ya kgolegelo ya bobedi, mme ba tla fa kgorong ya tshipi fa mmileng, mme ya ba bulegela ka bo yone! ba feta ba tsamaya botlhe, mme moengele a mo tlogela. ");
INSERT INTO tsn_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Mme kwa morago Petere a lemoga se se diragetseng; O ne a ithaya a re, “Ke boammaaruri! Morena o romile moengele wa gagwe ebile o mphaloditse mo go Herode le mo go se Bajuta ba neng ba ikemiseditse go se dira ka nna!” ");
INSERT INTO tsn_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Morago ga a itharabologelwa a ya kwa lwapeng lwa ga Marea, mmaagwe Johane Mareko, kwa ba le bantsi ba neng ba kgobokanetse thapelo teng. ");
INSERT INTO tsn_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","O ne a kokota fa setswalong, se se kwa ntle, mme mosetsana yo o bidiwang Roda a tla go bula. ");
INSERT INTO tsn_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Erile fa a lemoga lentswe la ga Petere, a itumela thata mo a neng a tabogela mo teng go bolelela mongwe le mongwe gore Petere o eme kwa ntle mo mmileng. ");
INSERT INTO tsn_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ga ba a ka ba mo dumela. Ba ne ba re, “O a tsenwa,” mme erile a tlhomamisa ba re, “E tshwanetse ya bo e le moengele wa gagwe. (Ba tshwanetse ba bo ba mmolaile).” ");
INSERT INTO tsn_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ka lobaka loo Petere ene o ne a tsweletse a kokota. ");
INSERT INTO tsn_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","A ya kwa go bone a ba didimatsa mme a ba bolelela se se diragetseng le ka fa Morena a mo ntshitseng mo kgolegelong ka teng. Erile a tsamaya are, “Bolelelang Jakobe le ba bangwe se se diragetseng.” ");
INSERT INTO tsn_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mme ya re fa bosigo boo sa, ga tsoga pheretlhego e kgolo kwa kgolegelong. Batlhabani ba botsanya gore Petere o ile kae? ");
INSERT INTO tsn_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erile fa Herode a romela gore a Petere a ye go bidiwa mme a utlwa gotwe ga a yo, a laola gore batlhokomedi ba ba lesome le borataro ba tshwarwe, mme ba bolawe. Erile kwa morago a tsamaya go ya go nna kwa Kaesarea ka lobakanyana. ");
INSERT INTO tsn_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erile a ntse a le mo Kaesarea, ga tla barongwa ba ba neng ba tswa Ture le Sidoma ba tsile go mmona. Ga a ka a itumelela batho ba metse e mebedi eo, mme barongwa ba itsalanya le Belaseto, mokwaledi wa bogosi, ba bo ba kopa kagiso, gonne mo kgwebong, metse ya bone e ne e ikaegile thata mo lefatsheng la ga Herode. ");
INSERT INTO tsn_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Go ne ga dirwa tumalano ya go buisanya le Herode, mme erile fa letsatsi leo le tla, a apara diaparo tsa gagwe tsa bogosi, a nna mo setilong sa gagwe mme a bua nabo. ");
INSERT INTO tsn_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Mme erile kwa bokhutlong batho ba duduetsa ba re, “Ke lentswe la Modimo e seng la motho!” ");
INSERT INTO tsn_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ka bonako, moengele wa Morena a otlhaya Herode ka bolwetse mo e leng gore o ne a jewa ke diboko a ntse a tshela mme a swa ka gonne o ne a amogela kobamelo ya batho go na le gore a galaletse Modimo. ");
INSERT INTO tsn_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Mafoko a Modimo a a Molemo a ne a anama ka bofefo mme go ne ga nna badumedi ba basha ba le bantsi. ");
INSERT INTO tsn_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Mme Barenabase le Paulo ba ne ba etela Jerusalema, mme ya re ba sena go fetsa tiro ya bone, ba boela kwa Antioka, ba tsaya Johane Mareko. ");
INSERT INTO tsn_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mo baporofiting le mo baruting ba phuthego kwa Antioka go ne go le Barenabase le Simeone (yo gape o neng a bidiwa “Monna Montsho”), le Lukio (wa Kurene), le Manaene (yo o otletsweng gongwe le Kgosi Herode), le Saulo. ");
INSERT INTO tsn_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Letsatsi lengwe banna ba, ba ntse ba rapela ba bile ba itimile dijo, Mowa O O Boitshepo wa re, “Ntomololelang Barenabase le Saulo go dira tiro e e tlhophegileng e ke e ba bileditseng.” ");
INSERT INTO tsn_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Mme morago ga go itima dijo le go rapela, ba ba baya diatla, mme ba ba naya tsela. ");
INSERT INTO tsn_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Mme ya re ka go gogwa ke Mowa O O Boitshepo ba ya kwa Seleukia ba bo ba ya kwa Kupero. ");
INSERT INTO tsn_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Mme mo motseng wa Salamise, ba ne ba ya kwa tlung ya thuto ya Sejuta ba rera. (Johane Mareko o ne a tsamaya le bone e le mothusi wa bone). ");
INSERT INTO tsn_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","7","Morago ba rera mo motseng mongwe le mongwe go kgabaganya setlhaketlhake sotlhe go fitlhelela ba tsena mo Pafosa kwa ba neng ba kopana teng le moloi wa Mojuta, moporofiti wa tsietso yo o neng a bidiwa Barajesu. O ne a ikgolagantse le molaodi Seregio Paulo, yo e neng e le motho yo o tlhaloganyang thata. Molaodi a laletsa Barenabase le Saulo go mo etela, gonne o ne a batla go utlwa molaetsa wa bone o o neng o tswa kwa Modimong. ");
INSERT INTO tsn_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Mme Elemase (leina la gagwe ka Segerika), wa moloi a leka go faposa le go tlhotlheletsa gore molaodi a seka a reetsa se Saulo le Barenabase ba neng ba se bua, a leka go mo dira gore a seka a ikanya Morena. ");
INSERT INTO tsn_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Mme Saulo ka a tletse Mowa O O Boitshepo, a leba moloi ka bogale mme a re, ");
INSERT INTO tsn_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Morwa diabolo ke wena, o tletse mofuta mongwe le mongwe wa go tsietsa le bolotsana, mmaba wa sengwe le sengwe se se siameng, a ga o kitla o khutlisa go ganetsa Morena? ");
INSERT INTO tsn_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Mme Modimo gompieno o beile seatla sa one sa kwatlhao mo go wena, mme o tlaa foufala ka lobakanyana.” Ka bonako ga nna mouwane le lefifi mo go ene, mme a simolola go tsamaya a kopa mongwe gore a mo tshware ka letsogo a mo goge. ");
INSERT INTO tsn_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Mme erile molaodi a bona se se diragetseng a dumela mme a hakgamalela nonofo ya molaetsa wa Modimo. ");
INSERT INTO tsn_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Mme Paulo le ba o neng a na nabo ba tloga mo Pafosa ka sekepe ba ya Perega, wa Pamfilia. Mme Johane a ba ngwegela a boela Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Mme Barenabase le Paulo ba ne ba ya Antioka, motse o o neng o le mo kgaolong ya Pisidia. Ka letsatsi la Sabata ba ne ba tsena mo tlung ya thuto go tshwara tirelo-Modimo. ");
INSERT INTO tsn_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mme morago ga go balwa mo go tlwaelesegileng ga Dikwalo tsa ga Moshe le tsa Baporofiti, bagolwane ba ntlo ya thuto ba ba romelela molaetsa o: “Bakaulengwe, fa lo na le lefoko la tao mo go rona, tlang lo le bue!” ");
INSERT INTO tsn_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Mme Paulo a ema, a dumedisa mme a simolola a re, “Bana ba Iseraele, le botlhe ba ba fano ba ba tlotlang Modimo, mmang ke simolole se ke se buang ka go lo bolelela ditso di se kae. ");
INSERT INTO tsn_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","“Modimo wa chaba e, ya Iseraele o tlhophile bo rraa-ronamogolwagolwane mme wa ba tlotla mo Egepeto ka go ba ntsha ka kgalalelo mo botlhankeng jwa bone. ");
INSERT INTO tsn_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","“Mme wa ba tlhokomela mo go tsamayeng ga bone mo sekakeng ka dingwaga di le masome mane. ");
INSERT INTO tsn_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","20","Mme wa senya dichaba di supa mo Kanana, mme wa neela Iseraele lefatshe la bone e le boswa. Baatlhodi ba busitse ka lobaka lo e neng e ka nna dingwaga di le makgolo a mane le masome a matlhano, mme ba ne ba salwa morago ke Samuele wa moporofiti. ");
INSERT INTO tsn_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“Mme batho ba kopa gore ba nne le kgosi, mme Modimo wa ba neela Saulo (morwa Kishe), monna wa lotso lwa ga Benjamine, yo o neng a busa ka dingwaga di le masome a mane. ");
INSERT INTO tsn_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","“Mme le fa go ntse jalo, Modimo wa mo tlosa wa tlhoma Dafide go nna kgosi mo maemong a gagwe, monna yo Modimo o neng wa re ka ga gagwe, ‘Dafide (morwa Jese) monna yo pelo yame e mo itumelelang thata, yo o tlaa dirang go rata ga me gotlhe.’ ");
INSERT INTO tsn_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Go tswa mo losikeng lwa monna yo, Modimo o ne wa tlisetsa Iseraele Mmoloki, ebong Jesu, fela jaaka o solofeditse. ");
INSERT INTO tsn_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Mme pele ga a goroga, Johane wa Mokolobetsi o ne a rera botlhokwa jwa gore mongwe le mongwe mo Iseraele a sokologe mo dibeng le go boela mo Modimong. ");
INSERT INTO tsn_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Mme erile fa Johane a fetsa tiro ya gagwe a botsa a re, ‘A lo akanya gore ke Mesia? Nnyaa! Ene o e tla ka bonako, mme mo go ene ga ke sepe!’ ");
INSERT INTO tsn_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Bakaulengwe, lona bomorwa Aberahame, le lona lotlhe Badichaba ba lo tlotlang Modimo, poloko e ke ya rona rotlhe! ");
INSERT INTO tsn_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Bajuta mo Jerusalema le baeteledipele ba bone ba diragaditse seporofeso ka go bolaya Jesu, gonne ba ne ba sa mo lemoge, kgotsa ba sa itse gore ke ene yo baporofiti ba neng ba kwadile ka ga gagwe, le fa ba ne ba utlwa mafoko a baporofiti a balwa Sabata mongwe le mongwe. ");
INSERT INTO tsn_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Mme ba ne ba tlhoka mabaka a a utlwalang go mmolaya, mme ba kopa Pilatwe gore a ba letle gore ba bolaye Jesu. ");
INSERT INTO tsn_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Mme erile ba sena go diragatsa seporofeso sotlhe ka ga loso lwa gagwe, o ne a pagololwa mo sefapanong mme a tsenngwa mo lebitleng. ");
INSERT INTO tsn_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","“Mme Modimo wa mo tsosa gape! mo losong. ");
INSERT INTO tsn_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Mme o ne a bonwa gantsi mo malatsing a makhutshwane a a latelang ke banna ba ba neng ba na nae go tswa Galalea go ya Jerusalema, banna ba ba neng ba sa bolo go nna ba bolela ka gale mo phatlalatseng. ");
INSERT INTO tsn_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Mme jaanong Barenabase le nna re fano go lo tlisetsa Mafoko a a Molemo a, gore tsholofetso ya Modimo mo go borraetsho-mogolo e diragaditswe mo dinakong tsa rona, ka go tsosa Jesu mo losong gape. Se ke sone se Pesalema ya bobedi e buang kaga sone fa e bua kaga Jesu e re, ‘Gompieno ke go tlotlile jaaka Morwaake.’ ");
INSERT INTO tsn_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Gonne Modimo o ne o solofeditse go mo rudisa gape, a se kitla a tlhola a a swa gape. Mo go kwadilwe mo lokwalong lo lo reng, ‘Ke tlaa lo direla dilo tse di hakgamatsang tse ke di solofeditseng Dafide.’ ");
INSERT INTO tsn_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Mo Pesalemeng e nngwe o tlhalositse thata a re, ‘Modimo ga o kitla o letla gore yo o Boitshepo wa one a bole.’ ");
INSERT INTO tsn_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Mo go ne go sa reye Dafide, gonne erile Dafide a sena go direla dikokomana tsa gagwe ka fa go rateng ga Modimo, o ne a swa mme a fitlhwa, mme mmele wa gagwe wa bola. ");
INSERT INTO tsn_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nnyaa, go ne go raya yo mongwe, mongwe yo Modimo o mo rudisitseng, yo mmele wa gagwe o iseng o ke o tshwarwe ke tshenyego ya loso. ");
INSERT INTO tsn_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Bakaulengwe! Reetsang! Mo monneng yo ebong Jesu, go na le boitshwarelo jwa dibe tsa lona! ");
INSERT INTO tsn_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mme mongwe le mongwe yo o mo ikanyang o golotswe mo melatong yotlhe le gone o siame, sengwe se molao wa Sejuta o neng o sa kake wa se dira. ");
INSERT INTO tsn_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mme jaanong itlhokomeleng! Se direng gore mafoko a baporofiti a reye lona. Gonne ba re, ");
INSERT INTO tsn_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Lebang mme lo nyelele, lona banyatsi ba boammaaruri, gonne ke dira sengwe mo lobakeng lwa lona, sengwe se lo se ka keng lwa se dumela fa lo utlwa se bolelwa.’ ” ");
INSERT INTO tsn_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Mme erile batho ba tswa mo tlung ya thuto ka letsatsi leo, ba kopa Paulo go boa a ya go bua le bone beke e e latelang. ");
INSERT INTO tsn_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mme Bajuta ba le bantsi le Badichaba ba badumedi ba ba neng ba rapela kwa tlung ya thuto ba sala Paulo le Barenabase morago mo mmileng mme bone ba ba tlhotlheletsa go amogela kutlwelobotlhoko e Modimo o e ba nayang. ");
INSERT INTO tsn_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Beke e e latelang motse otlhe wa batla go tla go ba utlwa ba rera Lefoko la Modimo. ");
INSERT INTO tsn_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Mme erile fa Bajuta ba baeteledipele ba bona bontsintsi jwa batho ba tlala lefufa, mme ba hutsa ba bo ba ganetsa se Paulo o neng a se bua. ");
INSERT INTO tsn_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Mme Paulo le Barenabase ba ne ba bua ka bopelokgale ba re, “Go ne go tlhokega gore Mafoko a a Molemo a a tswang kwa Modimong a tshwanetse go neelwa lona Bajuta pele. Mme ka gobo lo a ganne, lwa ba lwa itshupa fa lo sa tshwanela botshelo jo bo sa khutleng, go siame re tlaa bo neela Badichaba. ");
INSERT INTO tsn_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Gonne se ke se Morena o se laotseng fa a re, Ke lo dirile lesedi mo go badichaba, go ba goga mo khutlong tse di kgakala tsa lefatshe go ba tlisa mo polokong ya me.” ");
INSERT INTO tsn_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Mme erile Badichaba ba utlwa se, ba itumela thata mme ba ipelela molaetsa wa ga Paulo; ba le bantsi ba ba neng ba batla botshelo jo bo sa khutleng, ba dumela. ");
INSERT INTO tsn_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Mme molaetsa wa Modimo wa gasama mo kgaolong eo yotlhe. ");
INSERT INTO tsn_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Mme baeteledipele ba Sejuta ba feretlha badumedi ba basadi ba ba boifang Modimo ga mmogo le baeteledipele ba motse mme ba tlhotlheletsa boidiidi jwa batho go nna kgatlhanong le Paulo le Barenabase, mme ba ba kobela kwa ntle ga motse. ");
INSERT INTO tsn_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Mme ba ne ba itlhotlhora lorole mo dinaong tsa bone go supa go nna kgatlhanong le motse o, mme ba ya kwa motseng wa Ikonio. ");
INSERT INTO tsn_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Mme ba ba ba sokolotseng ba tlala boitumelo le Mowa O O Boitshepo. ");
INSERT INTO tsn_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Mme kwa Ikonio, Paulo le Barenabase ba ne ba tsamaya mmogo ba ya kwa tempeleng mme ba rera ka nonofo e kgolo e Bajuta le Badichaba ba neng ba e dumela. ");
INSERT INTO tsn_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Mme Bajuta ba ba neng ba gana molaetsa wa Modimo ba feretlha Badichaba gore ba seka ba dumela Paulo le Barenabase, ba bua ka dilo di le dintsi tse di maswe ka bone. ");
INSERT INTO tsn_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Mme le fa go ntse jalo, ba ne ba nna foo lobaka lo lo leele, ba rera ka bopelokgale, mme Morena a supa fa molaetsa wa bone o tswa kwa go ene ka go ba neela nonofo ya go dira dikgakgamatso tse di kgolo. ");
INSERT INTO tsn_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Mme batho ba motse ba ne ba farologana ka maikutlo kaga banna ba. Bangwe ba ne ba dumalana le baeteledipele ba Sejuta mme ba bangwe ba dumalana le baaposetoloi. ");
INSERT INTO tsn_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","6","Mme erile fa Paulo le Barenabase ba lemoga leano la go tlhotlheletsa bontsi jwa Badichaba, Bajuta le baeteledipele ba Sejuta go ba tlhasela le go ba bolaya, ba ipoloka, ba ya kwa metseng ya Lukaonia, Lusetera, Derebe le mo tikologong, ");
INSERT INTO tsn_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","mme ba rera Mafoko a a Molemo teng koo. ");
INSERT INTO tsn_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Mme erile fa ba le kwa Lusetera, ba tla fa monneng yo o neng a golafetse dinao go tswa sebopelong sa ga mmaagwe, ebile a ise a ke a tsamaye. ");
INSERT INTO tsn_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","O ne a reeditse fa Paulo a rera, mme Paulo a mo lemoga mme a bona gore o na le tumelo ya go fodisiwa. ");
INSERT INTO tsn_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Jalo Paulo a mmitsa a re, “Ema ka dinao!” Mme monna a tlola a ema ka dinao a simolola go tsamaya! ");
INSERT INTO tsn_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Mme erile boidiidi jo bo reeditseng bo bona se Paulo a se dirileng, ba goa (ka puo ya bone) ba re, “Banna ba ke medimo mo setshwanong sa motho!” ");
INSERT INTO tsn_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ba ne ba akanya gore Barenabase ene ke Modimo wa Segerika ebong Jupitere, mme Paulo, ka gonne e ne e le sebui se segolo, ke Merekuri. ");
INSERT INTO tsn_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Mme moperesiti wa Tempele ya Jupitere, e e agilweng ka kwa ntle ga motse, o ne a ba tlisetsa merwalo ya dithunya a bo a ba ntshetsa setlhabelo sa dikgomo kwa kgorong ya motse fa pele ga boidiidi jwa batho. ");
INSERT INTO tsn_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Mme erile fa Paulo le Barenabase ba bona se se diragalang ba gagola diaparo tsa bone ka kutlo botlhoko mme ba ralala batho ba, ba goa ba re, ");
INSERT INTO tsn_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Banna! Lo dirang? Re batho fela jaaka lona! Re tletse go lo neela Mafoko a a Molemo gore lo lalediwa go tlogela kobamelo ya dilo tsa bomatla mme mo boemong jwa moo go rapela Modimo o o tshelang one o o dirileng legodimo le lefatshe le lewatle le sengwe le sengwe se se mo go tsone. ");
INSERT INTO tsn_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Mo malatsing a a fetileng Modimo o ne wa letla dichaba go tsaya ditsela tsa tsone, ");
INSERT INTO tsn_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","mme ga o ke o ne o tlhoka bosupi ja dilo tse di molemo tse o neng o di dira jaaka go lo nesetsa pula le dijalo tse di siameng le go lo fa dijo le boitumelo.” ");
INSERT INTO tsn_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mme le fa go ntse jalo, Paulo le Barenabase ba ne ba sa kgone go itsa batho go ba direla setlhabelo! ");
INSERT INTO tsn_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Mme morago ga malatsinyana, Bajuta bangwe ba goroga ba tswa Antioka le Ikonio mme ba fetola boidiidi jwa batho gore bo nne babolai ba ba neng ba kgobotletsa Paulo ka matlapa ba mo gogela kwa ntle ga motse a bonala o ka re o sule. ");
INSERT INTO tsn_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Mme erile fa badumedi ba mo dikaganyetsa, a ema a tsena mo motseng! Letsatsi le le latelang a tsamaya le Barenabase ba ya Derebe. ");
INSERT INTO tsn_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Mme erile morago, ba sena go rera Mafoko a a Molemo teng koo, ba bo ba dira barutwa ba bantsi, ba boela gape kwa Lusetera, Ikonio le Antioka, ");
INSERT INTO tsn_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","kwa ba neng ba thusa badumedi go tia mo loratong lwa Modimo le gore ba ratane. Ba ne ba ba kgothatsa go tsena mo Bogosing jwa Modimo ka dipogisego tse dintsi. ");
INSERT INTO tsn_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Mme Paulo le Barenabase le bone ba tlhopha bagolwane mo phuthegong nngwe le nngwe ba ba rapelela ka go itima dijo, ba ba isa mo tlhokomelong ya Morena yo ba mo ikantseng. ");
INSERT INTO tsn_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Mme ba ralala Pisidia go ya kwa Pamfilia, ");
INSERT INTO tsn_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ba rera gape mo Perega, mme ba tswelela ba ya kwa Atalia. ");
INSERT INTO tsn_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Mme la bofelo ba boela ka sekepe kwa Antioka, kwa loeto lwa bone lo simologileng teng, le kwa ba neng ba ineela mo Modimong mo tirong e jaanong e weditsweng. ");
INSERT INTO tsn_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Erile fa ba goroga ba bitsa badumedi mme ba bolela loeto lwa bone, ba bolela ka fa Modimo o buletseng le Badichaba tumelo ka teng. ");
INSERT INTO tsn_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Mme ba ne ba nna le badumedi kwa Antioka sebaka se seleele. ");
INSERT INTO tsn_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Mme erile fa Paulo le Barenabase ba sa le kwa Antioka, banna bangwe ba tswa Judea ba goroga mme ba simolola go ruta badumedi gore fa ba sa ngaparele ngwao ya Sejuta ya bogologolo ya go rupisiwa ga ba ka ke ba bolokwa. ");
INSERT INTO tsn_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulo le Barenabase ba ganetsanya nabo, ba bo ba buisanya nabo ka nako e telele kaga selo se, mme la bofelo badumedi ba ba romela kwa Jerusalema, go ya go bua le baaposetoloi le bagolwane koo kaga selo se. ");
INSERT INTO tsn_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Mme morago ga phuthego yotlhe e ba ntsha mo motseng, ba ralala Foneshia le Samaria ba etela badumedi, ba ba bolelela mo go ileng ga itumedisa batho botlhe, gore Badichaba le bone ba ne ba sokologa. ");
INSERT INTO tsn_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Fa ba goroga kwa Jerusalema, ba kopana le bagolwane ba phuthego, baaposetoloi botlhe le bagolwane ba ne ba le teng mme Paulo le Barenabase ba bolela se Modimo o ntseng o se dira mo go boleleng Lefoko ga bone. ");
INSERT INTO tsn_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Mme banna bangwe ba e neng e le Bafarasai pele ga ba sokologa ba ema ka dinao ba bolela gore Badichaba botlhe ba ba sokologileng ba tshwanetse go rupisiwa le gone go tlhokega gore ba sale ngwao le mekgwa ya Sejuta morago. ");
INSERT INTO tsn_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Mme jalo baaposetoloi le bagolwane ba phuthego ba ne ba ikemisetsa go bitsa phuthego ya go tla go buisanya kaga selo se. ");
INSERT INTO tsn_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Mme mo phuthegong, morago ga puisanyo e telele, Petere a ema mme a ba bolelela jaana: “Bakaulengwe, lotlhe lo itse gore Modimo ga o bolo go tlhopha bogologolo go rerela Badichaba Mafoko a a Molemo, gore le bone ba dumele. ");
INSERT INTO tsn_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Modimo o o itseng dipelo tsa batho, o tlhomamisitse gore o amogela Badichaba ka go ba neela Mowa O O Boitshepo, fela jaaka o re o neetse. ");
INSERT INTO tsn_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ga o a dira pharologanyo fa gare ga bone le rona, gonne o tlhatswitse matshelo a bone ka tumelo, fela jaaka o tlhatswitse a rona. ");
INSERT INTO tsn_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mme jaanong a lo tlaa tshwaya Modimo phoso ka go rwesa Badichaba mokgweleo o le e leng rona le borraetsho re sa kgonang go o rwala. ");
INSERT INTO tsn_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","A ga lo dumele gore botlhe ba bolokwa ka tsela e le nngwe, ka mpho e e neelwang fela kwa ntle ga theko ke Morena Jesu.” ");
INSERT INTO tsn_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ga go a ka ga tlhola go nna le kgang epe, mme mongwe le mongwe a reetsa fa Barenabase le Paulo ba bolela kaga dikgakgamatso tse Modimo o di dirileng ka bone mo go Badichaba. ");
INSERT INTO tsn_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Mme erile ba sena go fetsa, Jakobe a ema a re, “Bakaulengwe, ntheetsang. ");
INSERT INTO tsn_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Petere o lo boleletse ka nako e Modimo o etetseng Badichaba ka yone go ntsha mo go bone ba ba tlaa leretseng leina la one tlotlo. ");
INSERT INTO tsn_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Mme lobaka lo lwa go ipolela ga Badichaba lo dumalana le se baporofiti ba se buileng. Sekai ke se, reetsang temana e, e e tswang mo go moporofiti Amose: ");
INSERT INTO tsn_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Morena a re, ‘Morago, ke tlaa tla ke tla go aga sesha ntlo ya ga Dafide e e senyegileng. ");
INSERT INTO tsn_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Gore Badichaba le bone, ba tle ba bone Morena, ebong botlhe ba ba tshwailweng ka leina la me.’ ");
INSERT INTO tsn_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Mme se ke se Morena o se buang, yo o senolang ditiro tsa gagwe tse di dirilweng mo tshimologong. ");
INSERT INTO tsn_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Mme mogopolo wa me ke gore re seka ra re Badichaba ba ba sokologang ba tshwanetse go obamela melao ya rona ya Sejuta, ");
INSERT INTO tsn_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","fa e se gore re ba kwalele gore ba ikgaphe mo go jeng nama ya ditlhabelo tsa disetwa, mo boakeng jotlhe, le mo go jeng nama e e sa ntshiwang madi ya diphologolo tse di kgamilweng. ");
INSERT INTO tsn_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Gonne dilo tse tsotlhe ga go bolo go rerwa ka tsone mo matlung a thuto a Sejuta, mo metseng mengwe le mengwe ka Sabata mongwe le mongwe mo dikokomaneng tse dintsi.” ");
INSERT INTO tsn_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Mme baaposetoloi le bagolwane le phuthego yotlhe ba tlhopha go romela barongwa kwa Antioka ba na le Paulo le Barenabase, go ya go bega kaga mogopolo o. Banna ba ba neng ba tlhophilwe e ne e le baeteledipele ba le babedi ba phuthego, Jutase, (yo gape o neng a bidiwa Barabase) le Silase. ");
INSERT INTO tsn_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Lo ke lokwalo lo ba neng ba lo tsaya: “Lo tswa kwa baaposetoloing, bagolwane le bakaulengwe kwa Jerusalema. Go bakaulengwe ba Badichaba kwa Antioka, Siria le Silisia. Ditumediso! ");
INSERT INTO tsn_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Re utlwa gore badumedi bangwe ba ba tswang kwano ba lo tlhakantse ditlhogo ba lo botsa kaga poloko ya lona, mme re ne re sa ba laela jalo. ");
INSERT INTO tsn_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Mme re bonye e le kakanyo e e siameng fa re sena go dumalana ka mogopolo o le mongwe gore re lo romelele baemedi ba babedi ba, ebong Barenabase le Paulo. ");
INSERT INTO tsn_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Banna ba, Judase le Silase, ba ba itatotseng matshelo a bone ka ntlha ya Morena wa rona Jesu Keresete, ba tlaa bolela se re se dumalaneng kaga potso ya lona. ");
INSERT INTO tsn_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","29","“Gonne go bonetse go siame mo Moweng O O Boitshepo le mo go rona gore re se beye morwalo o mogolo wa melao ya Sejuta mo go lona go na le gore re khutlise go ja dijo tse di neetsweng medimo ya disetwa le mo nameng e e sa ntshiwang madi a diphologolo tse di kgamilweng le mo boakeng. Fa lo dira se, go lekanye. Salang sentle.” ");
INSERT INTO tsn_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Mme barongwa ba bane ba ya kwa Antioka ka bonako, kwa ba neng ba bitsa teng phuthego ya Bakeresete mme ba ba neela lokwalo. ");
INSERT INTO tsn_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Mme go ne ga nna boitumelo jo bogolo mo phuthegong yotlhe letsatsi leo fa ba lo bala. ");
INSERT INTO tsn_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Mme Judase le Silase, ka bobedi e le dibui tse di abetsweng puo, ba rerela badumedi dithero tse di telele, ba ba nonotsha mo tumelong. ");
INSERT INTO tsn_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ba ne ba nna malatsi, a mantsi, mme Judase le Silase ba boela kwa Jerusalema ba isa ditumediso le boitumelo kwa go ba ba neng ba ba romile. ");
INSERT INTO tsn_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","35","Mme Paulo le Barenabase ba ne ba nna kwa Antioka go thusa ba bangwe ba se kae ba ba neng ba rera ba bile ba ruta koo. ");
INSERT INTO tsn_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mme morago ga malatsinyana, Paulo a raya Barenabase a re, “A re boele kwa morago, re etele bakaulengwe mo metseng yotlhe e re rerileng Lefoko la Morena mo go yone, mme re bone ka fa ba tsweletseng ka teng.” ");
INSERT INTO tsn_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barenabase o ne a dumela, mme a rata gore ba tsamaye le Johane Mareko. ");
INSERT INTO tsn_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Mme Paulo ene o ne a sa batle mogopolo oo gotlhelele, gonne Johane o ne a ba ngwegetse kwa Pamfilia. ");
INSERT INTO tsn_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mme kganetsanyo ya bone e ne ya nna e kgolo thata kaga selo se, mo ba neng ba kgaogana. Barenabase a tsamaya le Mareko ba ya Kupero, ");
INSERT INTO tsn_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","41","fa Paulo ene a tlhopha Silase, mme ka tshegofatso ya badumedi ba ya Siria le Silisia, go kgothatsa diphuthego koo. ");
INSERT INTO tsn_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo le Silase ba simolola pele ba ya kwa Derebe ba bo ba ya kwa Lusetera kwa ba neng ba kopana le Timotheo teng, modumedi yo mmaagwe e neng e le Mokeresete wa Mojuta, mme rraagwe e le Mogerika. ");
INSERT INTO tsn_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timotheo o ne a kaiwa fa a le motho yo o siameng mo Lusetera le mo Ikonio, ");
INSERT INTO tsn_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Jalo Paulo a mo kopa go tsamaya nabo mo loetong lwa bone. Ka ntlha ya Bajuta ba Kgaolo eo, o ne a rupisa Timotheo pele ga ba tsamaya, gonne mongwe le mongwe o ne a itse gore rraagwe e ne e le Mogerika. (Mme o ne a ise a ke a letlelele selo seo pele). ");
INSERT INTO tsn_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Mme ba tsena motse le motse, ba itsise mogopolo o kaga Badichaba, jaaka go ne go laotse baaposetoloi le bagolwane kwa Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Mme phuthego ya gola letsatsi le letsatsi mo tumelong le mo palong. ");
INSERT INTO tsn_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Mme morago ga moo ba ralala Feregia le Galatia, gonne Mowa O O Boitshepo o ne o ba boleletse gore ba seka ba tsena mo Asia. ");
INSERT INTO tsn_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Mme erile ba tsamaya mo molelwaneng wa Misia ba leba kwa borwa kwa kgaolong ya Bithinia, mme gape Mowa wa ga Jesu wa gana. ");
INSERT INTO tsn_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mme mo boemong jwa moo ba tswelela ba tsena mo kgaolong ya Misia go ya kwa motseng wa Toroase. ");
INSERT INTO tsn_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Bosigo joo Paulo a bona ponatshegelo. Mo torong ya gagwe o ne a bona kwa Masedonia, Mogerika, a mo rapela a re, “Tla kwano o re thuse.” ");
INSERT INTO tsn_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Jalo mo ga siamisa kgang. Mme ba re, re tlaa ya kwa Masedonia, gonne re lemoga gore Modimo o re roma go ya go rera Mafoko a a Molemo teng. ");
INSERT INTO tsn_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Mme re ne ra palama mokoro kwa Toroase, ra tlhamalala ra kgabaganyetsa kwa Samatharase, mme letsatsi le le latelang ra ya Neapolise. ");
INSERT INTO tsn_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Mme la bofelo ra tsena mo Filipi, motse mogolo wa Ba-Roma fela mo teng ga molelwane wa Masedonia, ra nna teng malatsinyana. ");
INSERT INTO tsn_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ka letsatsi la Sabata, ra tsamaela kgakajana kwa ntle ga motse fa lotshitshing lwa noka kwa re neng re utlwaletse fa bangwe ba rakanela teng go rapela; mme re ne ra ruta basadi bangwe dikwalo ba ba neng ba tla. ");
INSERT INTO tsn_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mongwe wa bone e ne e le Lidia, mosadi wa morekisi go tswa kwa Thiatira, mmapatsi wa letsela le le bohibidu jo bo mokgona. E ne e ntse e le morapedi wa Modimo gale, mme ya re a re reeditse, Morena a bula pelo ya gagwe mme a amogela gotlhe mo Paulo o neng a go bua. ");
INSERT INTO tsn_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","O ne a kolobediwa le botlhe ba ntlo ya gagwe a bo a re kopa go nna baeng ba gagwe. O ne a re, “Fa lo dumela gore ke a ikanyega mo Moreneng, tlang lo nne kwa tlung ya me.” Mme o ne a re kopa go fitlhela re dumela. ");
INSERT INTO tsn_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Letsatsi le lengwe fa re ya kwa felong ga thapelo fa thoko ga noka, ra kopana le mosetsana mongwe yo o neng a na le mewa e e maswe yo o neng a bolela dilo tsa boitseanape, a direla beng ba gagwe madi a mantsi. ");
INSERT INTO tsn_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","O ne a re sala morago a goa a re, “Banna ba ke batlhanka ba Modimo mme ba tsile go lo bolelela gore dibe tsa lona di ka itshwarelwa jang.” ");
INSERT INTO tsn_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Mme mo go ne ga tswelela ka malatsi a le mantsi go fitlhela Paulo, ka go tshwenyega thata, a bo a tla a bua le mowa o o maswe o o mo go ene a re, “Ke a go laola ka leina la ga Jesu Keresete go tswa mo go ene,” ka bonakonyana wa mo tlogela. ");
INSERT INTO tsn_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Mme ditsholofetso tsa beng ba gagwe tsa khumo tsa fela; ba tshwara Paulo le Silase ba ba gogela fa pele ga baatlhodi kwa borekisetsong. ");
INSERT INTO tsn_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","21","Mme ba ne ba re, “Bajuta ba, ba senya motse wa rona, ba ruta batho go dira dilo tse di kgatlhanong le melao ya Se-Roma.” ");
INSERT INTO tsn_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mme ka bonako batho ba nna kgatlhanong le Paulo le Silase, mme baatlhodi ba laola gore ba apolwe diaparo ba kgwathisiwe. ");
INSERT INTO tsn_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ba ne ba itewa thata mo mekwatleng mme morago ba tsenngwa mo kgolegelong. Motlhokomedi wa kgolegelo o ne a solofediwa loso fa a ka ba lesa, ");
INSERT INTO tsn_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","mme jalo ga a ka a tshameka fa a sena go laiwa, o ne a ba tsenya mo ntlwaneng e e kwa teng mme a bofelela maoto a bone mo disaneng. ");
INSERT INTO tsn_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ka nako ya bosigogare, fa Paulo le Silase ba ntse ba rapela ba bile ba opelela Morena difela, magolegwa a mangwe a ne a reeditse, ");
INSERT INTO tsn_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ka tshoganetso ga nna thoromo e kgolo ya lefatshe; kgolegelo ya tshikinyega go ya go fitlha kwa motheong, ditswalo tsotlhe tsa kgolegelo tsa bulega, mme dikeetane tsotlhe tse di neng di bofile magolegwa tsa bofologa. ");
INSERT INTO tsn_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mme erile fa motlhokomedi wa kgolegelo a tsoga a bona dikgoro tsa kgolegelo di bulegile, a gopola gore magolegwa a siile, mme a ntsha chaka ya gagwe a re o a ipolaya. ");
INSERT INTO tsn_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Mme Paulo a goa a re, “Se ipolaye re teng rotlhe!” ");
INSERT INTO tsn_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ka go tshoga thata, motlhokomedi wa magolegwa a laola gore dipone di tle mme a tabogela kwa ntlwaneng e e kwa teng a feta a wela fa pele ga ga Paulo le Silase. ");
INSERT INTO tsn_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","O ne a ba ntshetsa kwa ntle mme a ba kopa a re, “Barena, ke ka dirang gore ke bolokwe?” ");
INSERT INTO tsn_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ba mohetola ba re, dumela mo go Morena Jesu mme o tlaa bolokwa, wena le bantlo ya gago. ");
INSERT INTO tsn_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Mme ba ne ba mmolelela le botlhe ba ntlo ya gagwe mafoko a a molemo a a tswang kwa Moreneng. ");
INSERT INTO tsn_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ka yone nako eo a ba tlhatswa dintho mme ene le ba lwapa lwa gagwe ba kolobediwa. ");
INSERT INTO tsn_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Mme a ba isa kwa tlung ya gagwe a ba fa dijo. Ene le bantlo ya gagwe ba ne ba ipela thata ka gonne botlhe jaanong e ne e le badumedi! ");
INSERT INTO tsn_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Moso o o latelang baatlhodi ba romela mapodisi go bolelela motlhokomedi wa kgolegelo jaana, “Tlogela banna bao ba tsamaye!” ");
INSERT INTO tsn_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mme motlhokomedi o ne a bolelela Paulo gore ba golotswe. ");
INSERT INTO tsn_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Mme Paulo a fetola a re, “Nnyaa, ga ba ka ke! Ba re iteile fa pele ga batho kwa ntle ga go sekisiwa, ba bo ba re tsenya mo kgolegelong le gone re baagi ba Roma! Jaanong ba batla gore re tsamaye ka sephiri? Ga go nne jalo! A go tle bone ba tle go re golola!” ");
INSERT INTO tsn_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Mme barongwa ba mapodisi ba ya go bolelela baatlhodi ba ba neng ba boifa thata fa ba utlwa gore Paulo le Silase ke Ba-Roma. ");
INSERT INTO tsn_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Mme jalo ba tla fa kgolegelong ba ba kopa gore ba tsamaye, ba ba ntshetsa kwa ntle ba kopa gore ba tswe mo motseng. ");
INSERT INTO tsn_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Mme Paulo le Silase ba boela kwa tlung ya ga Lidia kwa ba neng ba kopana le badumedi mme ba ba rerela gape pele ga ba tswa mo motseng. ");
INSERT INTO tsn_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Mme ba ralala metse ya Amfipolisa le Apolonia mme ba tla mo Thesalonia, kwa go neng go na le ntlo ya thuto ya Sejuta teng. ");
INSERT INTO tsn_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Jaaka e ne e le tlwaelo ya ga Paulo, a tsena mo teng a rera, mme ya re ka go latelana ga bo Sabata ba le bararo a bulela batho dikwalo, ");
INSERT INTO tsn_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","a tlhalosetsa batho diporofeso ka pogo ya ga Mesia le ka tsogo ya gagwe mo baswing, a ba a tlhomamisa gore Jesu ke Mesia. ");
INSERT INTO tsn_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Bangwe ba ba neng ba reeditse ba ne ba kgonwa ke molaetsa wa Lefoko mme ba sokologa ba inaakanya le Paulo le Silase mmogo le badumedi ba Bagerika ba banna ba le bantsi, le basadi ba motse ba ba tlotlegang ba le bantsi. ");
INSERT INTO tsn_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Mme baeteledipele ba Bajuta ba ne ba fufega mme ba tlhotlheletsa batho ba ba senang molemo (dimatla) mo motseng go dira lesomo la go simolola mokubukubu. Ba ne ba tlhasela bonno jwa ga Jasone, ba loga leano la go isa Paulo le Silase kwa tlung ya tsheko go otlhaiwa. ");
INSERT INTO tsn_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Erile ba sa ba fitlhele koo, ba gogela Jasone kwa ntle le badumedi bangwe, mme ba ba tlisa fa pele ga lekgotla. Ba goa ba re, “Paulo le Silase ba fetotse lefatshe lotlhe, jaanong ba fano ba dubaka motse wa rona, ");
INSERT INTO tsn_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","mme Jasone o ba letleletse go tsena mo tlung ya gagwe. Botlhe ba molato wa go tsogologela puso, gonne ba bolela fa go na le kgosi nngwe, e go tweng Jesu mo boemong jwa ga Kaesarea.” ");
INSERT INTO tsn_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","9","Mme batho ba motse, le baatlhodi, ba ne ba tshwenyega thata ka mafoko a, mme ba ba lesa ba tsamaya fela ba sena go ba duedisa madi a go sekela kwa ntle. ");
INSERT INTO tsn_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Mme bosigo joo Bakeresete ba akofa ba tshabisetsa Paulo le Silase kwa Berea, mme jaaka gale, ba ya kwa tlung ya thuto go ya go rera. ");
INSERT INTO tsn_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mme batho ba Berea ba ne ba tlhaloganya go na le ba ba kwa Thesalonika, ba ne ba reetsa molaetsa ka boitumelo. Ba ne ba batlisisa mo dikwalong letsatsi le letsatsi go bona gore a se se builweng ke Paulo le Silase ke Boammaaruri. ");
INSERT INTO tsn_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Lwa bofelo bangwe ba bone ba le bantsi ba ne ba dumela, mmogo le basadi ba ba tlotlegang ba Bagerika le banna ba le bantsi le bone ba dumela. ");
INSERT INTO tsn_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Mme erile fa Bajuta mo Thesalonika ba utlwa gore Paulo o ne a rera kwa Berea, ba ya teng go ya go tsosa mokubukubu. ");
INSERT INTO tsn_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ka bonako badumedi ba tshabisetsa Paulo kwa lewatleng, fa Silase le Timotheo bone ba sala. ");
INSERT INTO tsn_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ba ba neng ba patile Paulo ba ne ba tsamaya nae go ya kwa Athena, mme ba boela kwa Berea ka molaetsa o o yang kwa go Silase le Timotheo gore ba itlhaganelele go kopana nae. ");
INSERT INTO tsn_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Mme erile fa Paulo a sa ntse a ba letetse mo Athena, a tshwenyega thata ka go bona medimo ya disetwa gongwe le gongwe mo motseng. ");
INSERT INTO tsn_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","O ne a ya kwa tempeleng go ya go buisanya le Bajuta le Badichaba ba ba neng ba kgatlhegela go obamela Modimo, mme a bua letsatsi le letsatsi mo patlelong le botlhe ba ba neng ba le foo. ");
INSERT INTO tsn_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Mme ba kopana le batlhalefi bangwe ba Bapikuria le Basetoika. Erile fa a ba bolelela kaga Jesu le kaga tsogo ya gagwe ba re, “Ke molori,” kgotsa, “O leka go dirisa tumelo ya seeng.” ");
INSERT INTO tsn_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Mme ba ne ba mo laletsa kwa patlelong ya Thaba ya Marase ba re, “Tla o re bolelele thata ka ga tumelo e ncha e, ");
INSERT INTO tsn_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","gonne o bua dilo tse di hakgamatsang mme re batla go utlwa mo gogolo.” ");
INSERT INTO tsn_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Ke tshwanetse go tlhalosa gore Baathena mmogo le baeng ba ba mo Athena ba ne ba lebega ba senya nako ya bone yotlhe ba buisanya ka ga megopolo e mesha)! ");
INSERT INTO tsn_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Mme Paulo erile fa a ema fa pele ga bone kwa Areapago a ba raya a re, “Batho ba Athena ke lemoga fa lo le badumedi, ");
INSERT INTO tsn_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","gonne erile ke ntse ke tsamaya ke ne ka bona dibeso di le dintsi tsa lona, mme nngwe ya tsone e ne e kwadilwe go twe. ‘Go Modimo o o sa itseweng.’ Lo ntse lo o obamela lo sa itse gore ke mang, mme gompieno ke batla go lo bolelela ka ga one. ");
INSERT INTO tsn_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“O dirile lefatshe le sengwe le sengwe se se mo go lone, mme jaaka e le Morena wa legodimo le lefatshe, ga o nne mo ditempeleng tse di dirilweng ke batho. ");
INSERT INTO tsn_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Le gone diatla tsa batho ga di ka ke tsa direla ditlhoko tsa one se o se tlhokang, ga o tlhoke sepe! One ka bo one o naya botshelo ebile o tshedisa sengwe le sengwe gape o diragatsa sengwe le sengwe se se tlhokegang. ");
INSERT INTO tsn_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","O bopile batho botlhe ba lefatshe go tswa mo mothong a le mongwe Adamo, mme wa phatlalatsa dichaba mo lefatsheng. O itsile pele gore ke dife tse di tshwanetseng go tsholetsega le go wa, le gore leng. O emisitse melelwane ya tsone. ");
INSERT INTO tsn_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","“Maikaelelo a one mo go tse tsotlhe ke gore batho ba tshwanetse go batla Modimo, le gore motlhaope ba bone tsela e e yang kwa go one ba o bone, ntswa o se kgakala le ope wa rona. ");
INSERT INTO tsn_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Gonne mo go one re a tshela ebile re a tsamaya! re bile re teng ka one! Jaaka mongwe wa bakwadi ba lona ba maboko a boletse a re, ‘Re bana ba Modimo!’ ");
INSERT INTO tsn_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Fa se e le boammaaruri, ga re a tshwanela go gopola Modimo jaaka modimo o o dirilweng ka gauta kana selefera kgotsa o betlilwe ka lentswe. ");
INSERT INTO tsn_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mme Modimo o ne wa itshokela botlhoka-kitso jwa motho mo lobakeng lo lo fetileng kaga dilo tse, mme jaanong o laola mongwe le mongwe gore a latlhe medimo ya gagwe mme a obamele one fela. ");
INSERT INTO tsn_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Gonne o tlhophile letsatsi la go sekisa lefatshe ka tshiamo ka monna yo o mo losong.” ");
INSERT INTO tsn_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Erile fa ba utlwa Paulo a bua kaga tsogo ya motho yo o neng a sule, bangwe ba tshega, mme ba bangwe ba re, “Re batla gore re tle re utlwe gape kaga gone.” ");
INSERT INTO tsn_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Mme moo ga fetsa puisanyo ya bone le Paulo, ");
INSERT INTO tsn_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","mme bangwe ba se kae ba ikopanya nae ba nna badumedi. Mongwe mo go bone e ne e le Dionisio wa lekgotla la motse le mosadi mongwe yo o neng a bidiwa Damarise, le ba bangwe. ");
INSERT INTO tsn_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Morago ga mo Paulo a tswa mo Athena a ya kwa Korintha. ");
INSERT INTO tsn_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","3","Mme koo a feta a tlwaelana le Mojuta yo o bidiwang Akwila, yo o tsaletsweng kwa Ponto, yo o neng a sa tswa go goroga a tswa kwa Itale le mosadi wa gagwe Peresila. Ba ne ba kobilwe mo Itale ka ntlha ya taolo ya ga Kalaodio Kaesarea ya gore Bajuta botlhe ba lelekwe mo Roma, Paulo o ne a nna nabo a ba a dira le bone, gonne e ne e le badiri ba megope (ditante) fela jaaka ene. ");
INSERT INTO tsn_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sabata mongwe le mongwe Paulo o ne a fetolana le batho mo tlung ya thuto, a leka go tlhalosetsa Bajuta le Bagerika. ");
INSERT INTO tsn_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Mme erile Silase le Timotheo ba sena go goroga ba tswa kwa Masedonia, Paulo a dirisa nako ya gagwe yotlhe a rera ebile a bolelela Bajuta gore Jesu ke Mesia. ");
INSERT INTO tsn_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Mme erile fa Bajuta ba mo ganetsa ba kgala se a se buang, ba tlhapatsa Jesu, Paulo a tlhotlhora lorole mo seaparong sa gagwe a re, “A madi a lona a nne mo ditlhogong tsa lona, nna ga ke na molato, go tloga gompieno ke tlaa rerela Badichaba.” ");
INSERT INTO tsn_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Morago ga moo o ne a nna le Tito Jeseto, Modichaba yo o neng a obamela Modimo a nna gaufi le ntlo ya thuto. ");
INSERT INTO tsn_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Mme le fa go ntse jalo, Kerisepo, moeteledipele wa senagoge, le botlhe ba ntlo ya gagwe ba ne ba dumela mo Moreneng mme ba kolobediwa le Bakorintha ba le bantsi ba ba mo utlwileng ba dumela ba bo ba kolobediwa. ");
INSERT INTO tsn_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Bosigo bongwe Morena o ne a bua le Paulo ka ponatshegelo a re, “O seka wa boifa! Bua! Se didimale! ");
INSERT INTO tsn_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Gonne ke na le wena mme ga go na ope yo o ka go utlwisang botlhoko. Batho ba le bantsi mo motseng o ke ba me.” ");
INSERT INTO tsn_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Mme Paulo a nna moo ngwaga e e lateleng le sephatlo, a ruta boammaaruri jwa Modimo. ");
INSERT INTO tsn_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Mme erile Galeo a nna molaodi wa Akaia, Bajuta ba tsogologela Paulo mme ba mo isa fa pele ga molaodi gore a sekisiwe. ");
INSERT INTO tsn_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ba ne ba re, “Paulo o molato wa go raya batho a re ba obamele Modimo ka mekgwa e e leng gore e kgatlhanong le molao wa Ba-Roma.” ");
INSERT INTO tsn_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Mme erile fela jaaka Paulo a simolola go ikarabela, Galeo a retologela kwa go ba ba pegang Paulo molato a re, “Reetsang, lona Bajuta ke lona, fa mo e ka bo e ne e le molato wa borukhutlhi, ke ne ke tlaa tlamega go lo reetsa, ");
INSERT INTO tsn_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","mme e re ka e le dipotso fela tse di mabapi le mafoko a lo a ipopetseng, le melao ya lona ya Sejuta ya boeleele, lo tlaa nna lo ipona. Ga ke na kgatlhego mo kgannyeng eo ebile ga ke e ame.” ");
INSERT INTO tsn_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Hong a ba ntshetsa kwa ntle ga ntlo ya tshekelo. ");
INSERT INTO tsn_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Mme batho ba tshwara Sosethenese, moeteledipele yo mosha wa tempele, mme ba mo iteela kwa ntle ga ntlo ya tshekelo! Mme Galeo ene o ne a sena sepe. ");
INSERT INTO tsn_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Mme Paulo o ne a nna mo motseng malatsi a le mantsinyana morago ga moo a sadisa Bakeresete sentle, a bo a tshwara mokoro a leba kwa Siria a tsamaya le Peresila le Akwila. Mme kwa Kenkerea Paulo o ne a ipeola ka ngwao ya Sejuta, ka gonne o ne a ikanne. ");
INSERT INTO tsn_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Erile fa a goroga kwa boemelong jwa mekoro jwa Efeso, a ba tlogela mo mokorong a ya kwa tempeleng go buisanya le Bajuta. ");
INSERT INTO tsn_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Mme ba ne ba mo kopa go nna malatsi a se kae, mme a bona a sena nako epe e o ka e senyang nabo. ");
INSERT INTO tsn_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Mme a re, “Ke tshwanetse ka bo ke le kwa Jerusalema ka malatsi a boikhutso.” Mme o ne a solofetsa go boela kwa Efeso fa Modimo o mo letla; mme jalo a tswelela le loeto gape. ");
INSERT INTO tsn_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Lefelo le le latelang le go neng ga engwa mo go lone e ne e le Kaesarea kwa o neng a etela phuthego ya Jerusalema go tswa foo a ya kwa Antioka. ");
INSERT INTO tsn_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Morago ga sebaka koo, a tsamaya mo Galatia le mo Feregia a etela badumedi botlhe, a ba kgothatsa ebile a ba thusa go re ba gole mo Moreneng. ");
INSERT INTO tsn_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Mme ka nako eo Mojuta mongwe yo o neng a bidiwa Apolose, moruti le moreri wa Baebele yo o tumileng, e ne e le gone fela a gorogang mo Efeso a tswa kwa Alekesanderia mo Egepeto. ");
INSERT INTO tsn_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","26","Erile fa a sa ntse a le mo Egepeto, mongwe o ne a mmoleletse ka ga Johane wa Mokolobetsi le se Johane o se buileng ka ga Jesu, mme moo e ne e le gone fela mo a go itseng. O ne a ise a ke a utlwe polelo yotlhe! Jalo o ne a rera ka bopelokgale le ka botlhaga mo tlung ya thuto a re, “Mesia o e tla! Ipaakanyetseng go mo amogela!” Peresila le Akwila ba ne ba le teng mme ba mo utlwa, mme e ne e le thero e e nonofileng. Morago ga moo ba kopana nae mme ba mo tlhalosetsa se se diragaletseng Jesu go tloga ka nako ya ga Johane, le gore mo gotlhe go raya eng! ");
INSERT INTO tsn_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Mme Apolose o ne a kile a akanya go ya Gerika, badumedi le bone ba mo kgothatsa go dira jalo. Ba ne ba kwalela bakaulengwe ba bone koo, ba ba raya ba re ba mo amogele. Mme erile fa a goroga kwa Gerika, a dirisiwa ke Modimo go nonotsha Phuthego, ");
INSERT INTO tsn_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","gonne o ne a ganetsa Bajuta mo pepeneneng a supa ka dikwalo gore Jesu ka boammaaruri ke Mesia. ");
INSERT INTO tsn_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Mme erile Apolose a santse a le mo Kontha, Paulo a ralala ntlheng ya godimo mme a goroga kwa Efeso, kwa o neng a fitlhela teng barutwa ba le bantsinyana. ");
INSERT INTO tsn_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","One a ba botsa a re, “A lo ne lwa amogela Mowa O O Boitshepo fa lo dumela?” Mme ba fetola ba re, “Nnyaa, ga re itse gore o rayang. Mowa O O Boitshepo ke eng?” ");
INSERT INTO tsn_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Mme Paulo a ba botsa a re, “Lo kolobeditswe ka kolobetso e e ntseng jang?” Mme ba araba ba re, “Kolobetso ya ga Johane?” ");
INSERT INTO tsn_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Mme Paulo a ba bolelela gore kolobetso ya ga Johane e ne e le go supa keletso ya go sokologa mo sebeng go ya kwa Modimong le gore ba ba amogelang kolobetso ya gagwe ba tshwanetse go tswelela ba dumela mo go Jesu, yo Johane o neng a bolela gore o tlaa tla. ");
INSERT INTO tsn_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Erile fela jaaka ba utlwa a bua jaana, ba kolobediwa mo leineng la Morena Jesu. ");
INSERT INTO tsn_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Erile fa Paulo a ba baya diatla, Mowa O O Boitshepo wa fologela mo go bone, mme ba bua dipuo di sele ba bo ba porofesa. ");
INSERT INTO tsn_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","E ne e ka nna banna ba le lesome le bobedi ");
INSERT INTO tsn_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Mme Paulo o ne a ya kwa tlung ya thuto a rera ka bopelokgale Sabata mongwe le mongwe mo dikgweding tse tharo, a bolela se a se dumetseng le gore ke ka ntlha yang fa a ne a dumela, ebile a tlhotlheletsa ba le bantsi gore ba dumele mo go Jesu. ");
INSERT INTO tsn_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Mme bangwe ba ne ba gana molaetsa wa gagwe mme ba bua mo pepeneneng kgatlhanong le Keresete, mme a tsamaya, a gana go ba rerela gape. Mme a tswa le badumedi, mme a simolola kopano e nngwe gape mo tlung ya ga Turano mme a rapela koo letsatsi le letsatsi. ");
INSERT INTO tsn_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Mo go ne ga tswelela dingwaga di le pedi, mo e leng gore mongwe le mongwe mo kgaolong ya Asia ebong Bajuta le Bagerika, ba ne ba utlwa molaetsa wa Morena. ");
INSERT INTO tsn_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Mme Modimo wa naya Paulo nonofo ya go dira dikgakgamatso tse di sa tlwaelesegang, ");
INSERT INTO tsn_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","mo e leng gore e ne e re fa diiphimolo (disakatuku) tsa gagwe kgotsa diaparo tsa gagwe di bewa mo balwetseng, ba fole, le mewa e e maswe e e neng e le mo go bone e tswe. ");
INSERT INTO tsn_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Mme setlhopha sengwe sa Bajuta ba ba neng ba tsena motse le motse ba ntsha mewa e e maswe, ba ne ba loga leano la go leka go dirisa leina la ga Jesu Keresete. Se ba neng ba se akantse e ne e le gore ba tlaa bua ba re, “Ke a go laola ka Jesu yo Paulo o mo rerang gore o tswele kwa ntle!” ");
INSERT INTO tsn_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Bo-morwa Sekefa moperesiti wa Mojuta, ba supa, ba ne ba dira jalo. ");
INSERT INTO tsn_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Mme erile ba lekeletsa mo monneng yo o nang le mowa o o maswe wa fetola wa re, “Ke itse Jesu ebile ke itse Paulo, mme lona lo bo mang?” ");
INSERT INTO tsn_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Mme a tlolela bangwe ba bone ba le babedi a ba betsa mo ba neng ba siela kwa ntle ga ntlo ya gagwe ba sa ikatega ebile ba bolaisegile thata. ");
INSERT INTO tsn_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Polelo ya se se diragetseng ya anama ka bonako mo motseng otlhe wa Efeso, mo Bajuteng le mo Bagerikeng ka go tshwana, ga nna poifo e kgolo mo motseng, mme leina la Morena Jesu la tlotlwa thata. ");
INSERT INTO tsn_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","19","Badumedi ba le bantsi ba ba neng ba dirisa maselamose ba ipolela ditshiamololo tsa bone ba tlisa dikwalo tsa bone tsa boloi le melemo e ba e dirisang ba di tshuba ka molelo mo pepeneneng. (Mongwe a akanyetsa tlhwatlhwa ya dikwalo tseo go ka nna dipula di le dikete tse di masome matlhano). ");
INSERT INTO tsn_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Mo go ne go supa gore kgaolo yotlhe e ne e amilwe ke molaetsa wa Modimo go le kae. ");
INSERT INTO tsn_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Morago ga moo Paulo a utlwa a gogwa ke Mowa O O Boitshepo go ya kwa Gerika pele ga a boela Jerusalema. O ne a re, “Morago ga moo ke tshwanetse go ya kwa Roma!” ");
INSERT INTO tsn_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","O ne a romela bathusi ba gagwe ba le babedi, Timotheo le Eraseto, gore ba tsamaele pele go ya Masedonia fa a sa ntse a setse lobakanyana mo Asia. ");
INSERT INTO tsn_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Mme ka nako eo, go ne ga nna pheretlhego e kgolo mo Efeso kaga Bakeresete. ");
INSERT INTO tsn_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","E ne ya simologa ka Demeterio, mothudi wa tshipi tsa selefera yo o neng a hirile babetli ba le bantsi go dira ditempelana tsa selefera tsa ga Diana, modimo wa sesadi wa Segerika. ");
INSERT INTO tsn_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","O ne a bitsa phuthego ya banna ba gagwe, le ba bangwe ba ba hirilweng mo ditirong tse di boletsweng, mme a ba bolelela jaana: “Borra, tiro e ke yone re amogelang ka yone. ");
INSERT INTO tsn_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Jaaka lo itse sentle mo go se lo se bonyeng le se lo se utlwileng, monna yo, Paulo, o tlhotlheleditse batho ba le bantsintsi gore medimo e e itirelwang ga se medimo gotlhelele. Ka ntlha ya moo, theko ya dilo tsa rona e ya kwa tlase! Mme mo ga go bonale fela mo Efeso, go mo tikologong yotlhe ya kgaolo! ");
INSERT INTO tsn_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Mme ruri, ga ke bue fela ka theko le thekiso mo seemong se, le kaga tatlhegelo ka fa re neng re ntse re boelwa ka teng, mme le gore go ka diragala gore tempele ya ga Diana modimo wa sesadi o mogolo e latlhegelwe ke tlotlo, mme Diana, modimo o montlentle o, o o sa obamelweng fela ke tikologo yotlhe ya Asia mme o obamelwa ke lefatshe lotlhe, o lebalwe!” ");
INSERT INTO tsn_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Erile fa ba utlwa jaana, ba galefa thata mme ba simolola go goa ba re, “Go mogolo Diana wa Baefesia!” ");
INSERT INTO tsn_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Bontsi jo bogolo jwa batho jwa simolola go phuthega mme ka bofefo motse wa tlala pheretlhego. Mongwe le mongwe a tabogela kwa kagong ya botshamekelo, ba swaswaila Gaio le Arisetareko, bapati ba ga Paulo go ya go sekisiwa. ");
INSERT INTO tsn_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo o ne a batla go tsena, mme barutwa ba ne ba se ka ba mo letla. ");
INSERT INTO tsn_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Mme bangwe balaodi ba Baroma ba kgaolo e, ditsala tsa ga Paulo, le bone ba ne ba romela molaetsa kwa go ene, ba mo kopa gore a seka a ba a tshameka ka botshelo jwa gagwe ka go tsena mo tlung ya botshamekelo. ");
INSERT INTO tsn_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Mo teng, batho botlhe ba ne ba goa, ba tsositse modumo, mongwe a bua sele yo mongwe le ene a bua sele, sengwe le sengwe se ne se tlhakatlhakanye. Tota bontsi jwa bone bo ne bo sa itse gore bo tletse eng foo. ");
INSERT INTO tsn_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Mme Alekesandere o ne a lemogwa mo boidiiding ke Bajuta bangwe mme ba mo gogela fa pele. O ne a gwetlha ka seatla gore go didimalwe mme a leka go bua. ");
INSERT INTO tsn_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Mme ya re fa boidiidi jwa batho bo lemoga gore ke Mojuta, ba simolola gape ba tsosa modumo sebaka sa oura tse pedi ba ntse ba re, “Go mogolo Diana wa Baefesia!” ");
INSERT INTO tsn_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Mme lwa bofelo molaodi o ne a kgona go ba didimatsa gore a kgone go bua. O ne a re, “Banna ba Efeso, mongwe le mongwe o itse gore Efeso ke motse mogolo wa tumelo ya ga Diana yo mogolo, yo setshwantsho sa gagwe se fologileng se tswa legodimong. ");
INSERT INTO tsn_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Mme e re ka se e le boammaaruri jo bo sa kakeng jwa ganediwa, ga lo a tshwanela go tshwenyega le fa go ka buiwa go tweng ebile lo seka lwa dira sepe ka mahega. ");
INSERT INTO tsn_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ntswa lo tlisitse banna ba fano ba sa utswa sepe mo tempeleng ya ga Diana le gone ba sa mo nyenyefatsa ka gope. ");
INSERT INTO tsn_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Mme fa Demeterio le babetli ba gagwe ba na le molato nabo, ditsheko di tsenye mme basekisi ba ka seka tsheko e gone jaanong jaana. A ba tsamaye ka fa molaong. ");
INSERT INTO tsn_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Mme fa go na le dingongorego kaga dilo dingwe, di ka baakanngwa sentle mo diphuthegong tsa lekgotla la motse; ");
INSERT INTO tsn_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","gonne re mo diphatseng tsa go bidiwa ke mmuso wa Ba-Roma gore re bolele gore khuduego e ya gompieno e simologile jang, ka go sena mabaka ape a a e simolotseng. Mme fa Baroma ba batla tlhaloso ga ke itse gore ke tlaa reng.” ");
INSERT INTO tsn_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Hong a ba phatlalatsa ba tsamaya. ");
INSERT INTO tsn_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Mme erile mo gotlhe go fela, Paulo a laetsa gore barutwa ba ye go bidiwa, a ba rerela molaetsa wa go ba sadisa sentle, mme a ya Masedonia, ");
INSERT INTO tsn_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","a tsamaya a rerela badumedi mo tseleng, mo metseng yotlhe e o neng a feta ka yone. ");
INSERT INTO tsn_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","O ne a nna mo Gerika dikgwedi di le tharo mme o ne a ipaakanyetsa go ya kwa Siria fa a lemoga leano la Bajuta la go mmolaya, jalo a ikaelela go ya kwa borwa jwa Masedonia pele. ");
INSERT INTO tsn_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Banna ba le bantsinyana ba ne ba tsamaya nae, ba ya kwa Asia; e ne e le bo Sopatere wa Berea, morwa Pirilia, Arisetareko le Sekundo wa Mothesalonia, Gaio wa Moderebe le Timotheo; le Tukiko le Terofimo, ba ba neng ba boela kwa magaeng a bone kwa Asia, ");
INSERT INTO tsn_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","mme ba ne ba tsamaetse pele ebile ba ne ba re letetse kwa Teroase. ");
INSERT INTO tsn_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Erile fela fa modiro wa Tlolaganyo o fela, ra palama sekepe kwa Filipi, borwa jwa Gerika mme morago ga malatsi a matlhano ra goroga mo Teroase, kwa re neng ra nna teng beke. ");
INSERT INTO tsn_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Mme ka Sontaga ra phuthega ra a ja selalelo, Paulo a rera. Mme ka a ne a tsamaya letsatsi le le latelang, o ne a bua go fitlhelela bosigogare! ");
INSERT INTO tsn_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ntlwana e e kwa godimo e re neng re phuthaganetse mo go yone e ne e na le dipone di le dintsi tse di tshubilweng. ");
INSERT INTO tsn_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mme erile Paulo a ntse a tsweletse a bua, lekau lengwe le le neng le bidiwa Eutiko, a nnetse fa fensetereng, a thulamela mme a wa a tswa kwa ntlwaneng ya boraro e e kwa godimo a swa. ");
INSERT INTO tsn_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","12","Paulo o ne a tswela kwa ntle mme a mo tsaya ka diatla a re, “Se tshwenyegeng, o siame fela!” Mme ka boammaaruri o ne a siame! Mme ga nna boitumelo jwa kgakgamalo jang mo bathong! Botlhe ba boela kwa ntlwaneng e e kwa godimo mme ba a ja selalelo sa Morena mmogo; Paulo a rera gape thero e telele go fitlhelela phakela fa a ba tlogela lwa bofelo! ");
INSERT INTO tsn_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Paulo o ne a tsamaya ka dinao go ya kwa Asoso, mme rona re ne ra tsamaela pele ka sekepe. ");
INSERT INTO tsn_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","O ne a re fitlhela teng kwa Asoso mme ra tsena mo sekepeng rotlhe ra ya Mitilene; ");
INSERT INTO tsn_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","mme ka letsatsi le le latelang ra feta Kioso; le le latelang ra tsena mo Samosa; mme morago ga letsatsi leo ra goroga mo Mileto. ");
INSERT INTO tsn_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo o ne a feditse mogopolo gore ga a kake a ema mo Efeso ka nako e, gonne o ne a itlhaganeletse go tsena kwa Jerusalema, gore fa go kgonega, a ye go kopanela modiro wa Pentekosete le bone. ");
INSERT INTO tsn_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mme erile fa re goroga kwa Mileto, a romela molaetsa kwa bagolwaneng ba phuthego kwa Efeso a ba kopa gore ba ye go kopana nae kwa mokorong. ");
INSERT INTO tsn_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Mme erile ba goroga, a ba raya a re, “Lona banna ke lona lo itse gore go simologa ka letsatsi le ke gorogileng ka lone mo Asia go fitlhelela gompieno, ");
INSERT INTO tsn_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ke dirile tiro ya Morena ka boikokobetso, ee, le ka dikeledi, mme ke kopane le mathata a a boitshegang a maano a Bajuta a go mpolaya. ");
INSERT INTO tsn_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mme ke ne ke sa etsaetsege go lo bolelela boammaaruri, mo bathong kgotsa mo magaeng a lona. ");
INSERT INTO tsn_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ke ne ka nna le molaetsa o o tshwanang mo Bajuteng le mo go Badichaba ebong tlhokego ya gore ba sokologe mo sebeng ba ye kwa Modimong ka tumelo mo go Morena wa rona Jesu Keresete. ");
INSERT INTO tsn_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Mme jaanong ke ya Jerusalema, ke gogelwa teng ke Mowa O O Boitshepo o ke se ka keng ka o ganetsa, ke sa itse se se nkemetseng kwa pele, ");
INSERT INTO tsn_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","fa e se fela gore Mowa O O Boitshepo o mpoleletse gore fa ke sena go tsena motse le motse kgolegelo le tshotlego di ntetetse kwa pele. ");
INSERT INTO tsn_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Mme botshelo ga se sepe fa ke sa bo dirise go dira tiro e ke e neetsweng ke Morena Jesu, tiro ya go bolelela ba bangwe Mafoko a a Molemo kaga lorato le kutlwelo botlhoko e kgolo ya Modimo. ");
INSERT INTO tsn_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Mme jaanong ke a itse gore ga go ope wa lona mo go ba ke ba rutileng kaga Bogosi yo o tlaa mponang gape. ");
INSERT INTO tsn_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mmang ke bue phatlalatsa fela ke re ga go na madi a ga ope a a tlaa lopiwang mo tlhogong ya me, ");
INSERT INTO tsn_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","gonne ga ke a ka ka boifa go lo bolelela molaetsa wa Modimo otlhe. ");
INSERT INTO tsn_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","“Mme jaanong itlhokomeleng! Tlhomamisang gore lo otle lo bo lo dise letsomane la Modimo, ebong phuthego, e e rekolotsweng ka madi a gagwe, gonne Mowa O O Boitshepo o lo tlhomile go nna baokamedi. ");
INSERT INTO tsn_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ke itse sentle gore morago ga ke tsamaya, go tlaa tla mo go lona baruti ba ba maaka, jaaka diphiri tse di gagolakang, tse di sa rekegeleng letsomane. ");
INSERT INTO tsn_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Bangwe ba lona ba tlaa fetola boammaaruri gore ba salwe morago. ");
INSERT INTO tsn_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Itlhokomeleng! Gakologelwang dingwaga tse tharo tse ke di ntseng le lona, tlhokomelo ya me mo go lona ka metlha yotlhe le dikeledi tsa me tse dintsi ke lo lelela. ");
INSERT INTO tsn_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Mme jaanong ke lo neela Modimo le mo tlhokomelong ya one le mo mafokong a one a a hakgamatsang a a kgonang go aga tumelo ya lona le go lo fa boswa jotlhe jwa ba ba itshenketsweng ke one. ");
INSERT INTO tsn_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","“Ga ke ise ke be ke eletse madi kgotsa diaparo tse dintle, ");
INSERT INTO tsn_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","lo itse gore diatla tse tsa me di diretse tse ke neng ke di tlhoka le go thusa ba ke neng ke na nabo. ");
INSERT INTO tsn_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mme ke ne ka nna sekao sa nako tsotlhe mo go lona mo go thuseng bahumanegi; gonne ke ne ka gakologelwa mafoko a ga Morena Jesu a a reng; ‘Go lesego go aba go na le go amogela.’ ” ");
INSERT INTO tsn_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Erile fa a sena go bua a khubama a rapela nabo, ");
INSERT INTO tsn_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","mme ba lelela kwa godimo fa ba mo tlamparela ba mo tsamaisa sentle, ");
INSERT INTO tsn_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ba utlwa botlhoko go feta ka gore o ne a re ga a kitla a tlhola a tla gape. Hong ba tsamaya nae go ya kwa sekepeng. ");
INSERT INTO tsn_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Mme erile re sena go kgaogana le ba golwane ba Efeso, ra tlhamalalela kwa Kosa, letsatsi le le latelang ra goroga mo Rodesa ra ba ra tswelela ra ya Patara. ");
INSERT INTO tsn_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Mme foo ra tshwara sekepe se se yang kwa Siria mo kgaolong ya Finikia. ");
INSERT INTO tsn_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Re ne ra bona setlhake sa Kopero, mme ra se feta ka fa molemeng ra ema mo Ture, kwa Siria, kwa sekepe se neng sa ololelwa teng. ");
INSERT INTO tsn_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Mme re ne ra fologa mo sekepeng, ra bona badumedi, mme ra nna le bone selekanyo sa beke. Barutwa ba ba ne ba tlhagisa Paulo, Mowa O O Boitshepo o porofesa ka bone gore a seka a ya Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Mme erile bofelo ja beke fa re boela kwa mokorong, phuthego yotlhe mmogo le basadi le bana ba ya le rona kwa lotshitshing kwa re neng ra rapela ra bo ra ba sadisa sentle. ");
INSERT INTO tsn_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Mme rona ra palama sekepe bone ba boela gae. ");
INSERT INTO tsn_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Mme kwa re neng ra ema teng gape go tloga kwa Ture ke kwa Potolomaia kwa re neng ra dumedisa badumedi teng mme ra tlhola nabo le-tsatsi le le lengwe fela. ");
INSERT INTO tsn_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Hong ra tswelela ra ya Kaesarea ra nna kwa lwapeng lwa ga Filipo wa Moefangele, mongwe wa batiakone ba ntlha ba ba supa. ");
INSERT INTO tsn_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","O ne a na le bana ba basetsana ba le bane ba ba sa nyalwang ba ba neng ba na le mpho ya go porofesa. ");
INSERT INTO tsn_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Mme erile re santse re ntse malatsinyana, monna mongwe yo o neng a bidiwa Agabo, yo le ene o neng a na le mpho ya go porofesa, o ne a goroga a tswa Judea, ");
INSERT INTO tsn_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","mme a re etela. O ne a tsaya moitlamo wa ga Paulo, a ipofa maoto le mabogo ka one mme a re, “Mowa O O Boitshepo ware, mme fela jalo mong wa moitlamo o, o tlaa bofiwa ke Bajuta kwa Jerusalema a bo a isiwa Roma!” ");
INSERT INTO tsn_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Mme erile re utlwa mo, rona rotlhe badumedi ba mo gae le bapati ba gagwe ba o tsamayang nabo, ra kopa Paulo gore a seka a ya Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Mme ene a re, “Lo lelelang? Lo mphatlola pelo! Gonne ke ipaakanyeditse gore ke se ka ka tshwarwa fela kwa Jerusalema, mme le gore ke swe ka ntlha ya Morena Jesu.” ");
INSERT INTO tsn_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Mme erile fa re bona gore ga a ka ke a rapelesega, ra itlhoboga mme ra re, “A go rata ga Morena go diragadiwe.” ");
INSERT INTO tsn_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Mme ya re morago ga moo ra phutha dilwana tsa rona ra ya kwa Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Barutwa bangwe kwa Kaesarea ba tsamaya le rona, mme fa re goroga re ne re le baeng kwa lwapeng lwa ga Monasone; mongwe wa badumedi ba pele, yo o tlholegileng a tswa Kupero ");
INSERT INTO tsn_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","mme le badumedi botlhe kwa Jerusalema ba re amogela ka boitumelo. ");
INSERT INTO tsn_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Letsatsi la bobedi Paulo o ne a re tsaya go ya go kopana le Jakobe le bagolwane ba phuthego ya Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Mme morago ga re dumedisana, Paulo a bolela gape dilo tse dintsi tse Modimo o di diretseng Badichaba ka tirelo ya gagwe. ");
INSERT INTO tsn_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ba ne ba galaletsa Modimo mme ba re, “O a itse, mokaulengwe yo o rategang, gore go dumetse Bajuta ba le dikete tse kae. Mme ba gatelela thata gore Bajuta ba badumedi ba tshwanetse go sala ngwao ya bone morago. ");
INSERT INTO tsn_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bakeresete ba rona ba Sejuta mono Jerusalema ba setse ba boleletswe gore lo kgatlhanong le melao ya ga Moshe, le ngwao ya rona ya Sejuta, le gore lo itsa bana ba bone go rupa. ");
INSERT INTO tsn_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Mme jaanong go ka dirwang? Gonne ba tlaa utlwa gore lo tsile. ");
INSERT INTO tsn_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","“Rona re akanya jaana: Re na le banna ba le bane fano ba ba ipaakanyeditseng go ipeola le go ikana. ");
INSERT INTO tsn_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Tsamayang le bone kwa Tempeleng le lona lo fete lo ipeole, mme lo ba duelele go ipeola. Mme mongwe le mongwe o tlaa itse gore lo dumalana le Bakeresete ba Sehebera le gore le lona lo obamela melao ya Sejuta mme lo akanya jaaka rona mo dilong tse. ");
INSERT INTO tsn_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Mme mo Bakereseteng ba Badichaba ga re ba laolele gore ba sale dingwao tse tsa Sejuta morago gotlhelele, fa e se tse re di ba kwaletseng kaga gore ba seka ba a ja dijo tse di tlhabetsweng medimo ya disetwa, ba seka ba a ja nama e e sa tshololwang madi ya diphologolo tse di kgamilweng, le gore ba seka ba dira boaka.” ");
INSERT INTO tsn_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","27","Mme jalo Paulo o ne a dumalana le kopo ya bone mme letsatsi le le latelang a tsamaya le banna a ya kwa Tempeleng, a dira gore maikano a gagwe a itsege ka go ntsha setlhabelo morago ga malatsi a supa le ba bangwe. Malatsi a supa a ne a tloga a fela fa Bajuta bangwe ba ba tswang Asia ba mmona mo Tempeleng mme ba tsosa mokubukubu mo bathong kgatlhanong nae. Ba ne ba mo tshwara, ");
INSERT INTO tsn_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ba goa ba re, “Banna ba Iseraele! Thusang! Monna yo ke ene yo o rerang kgatlhanong le batho ba rona a ba raya a re ba tlole melao ya Sejuta. Ebile o bua kgatlhanong le Tempele ebile a e leswafatsa ka go tsenya Badichaba mo teng.” ");
INSERT INTO tsn_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Gonne mo motseng letsatsi leo, ba ne ba mmonye a na le Terofimo wa Modichaba yo o tlholegileng kwa Efeso, mme ba gopola gore o tsentswe ke Paulo mo Tempeleng.) ");
INSERT INTO tsn_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Baagi ba motse otlhe ba ne ba shakgadiwa thata ke melato e a e pegwang mme ga tsoga mokubukubu o mogolo. Paulo o ne a gogelwa kwa ntle ga Tempele, mme ga tswalwa mabati ka bonako a sena go tsena. ");
INSERT INTO tsn_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Erile fa ba ntse ba leka go mmolaya, lentswe la tla mo molaoding wa mophato wa masole a Roma gore motse otlhe wa Jerusalema o feretlhegile. ");
INSERT INTO tsn_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Mme a akofa a laola masole a gagwe le baeteledipele gore ba tsene fa gare ga boidiidi. Erile fa baferetlhi ba bona mephato e tla, ba khutlisa go betsa Paulo. ");
INSERT INTO tsn_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mme molaodi wa mephato a tshwara Paulo mme a laola gore a bofiwe gabedi ka dikeetane. Mme a botsa boidiidi jwa batho gore ke mang le gore o dirileng. ");
INSERT INTO tsn_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Bangwe ba ne ba bua se, ba bangwe le bone ba bua se sele. Mme erile fa a sa tlhaloganye se ba mo pegang molato ka sone, a laola gore Paulo a isiwe kwa kagong ya ditlhabano. ");
INSERT INTO tsn_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Mme erile fa ba fitlha fa mapalamong ga nna pheretlhego e kgolo thata mo e leng gore masole a ne a tsholetsa Paulo a mmaya mo magetleng a bone go mmabalela, ");
INSERT INTO tsn_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","mme boidiidi jwa batho jwa salela kwa morago bo goa bo re, “A a bolawe! A a bolawe!” ");
INSERT INTO tsn_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","38","Mme erile fa Paulo a tloga a tsenngwa mo teng a raya molaodi a re, “A nka bua nao?” Molaodi a botsa ka kgakgamalo a re, “A o itse Segerika? A ga o Moegepeto yo o neng a eteletse pele ditsuulodi dingwaganyana tse di fetileng a bo a tsaya maloko a babolai a le dikete tse nne a ya nabo kwa sekakeng?” ");
INSERT INTO tsn_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulo o ne a fetola a re, “Nnyaa, Nna ke Mojuta kwa Tareso mo Kilikia, motse o o seng mmotlana. Ke kopa tetlelelo go bua le batho ba.” ");
INSERT INTO tsn_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Mme molaodi o ne a dumela, jalo Paulo a ema mo mapalamong mme a gwetlha batho ka seatla gore ba didimale; ka bofefo ga nna tidimalo mo bathong, mme a bua le bone ka Sehebera a re: ");
INSERT INTO tsn_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Bagaetsho le borara ntheetsang fa ke bolela boiphemelo jwa me.” ");
INSERT INTO tsn_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","(Erile fa ba utlwa a bua Sehebera, ga nna tidimalo e kgolo). ");
INSERT INTO tsn_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","A ba raya a re, “Ke Mojuta, yo o tsaletsweng kwa Tareso, motse o o mo Kilikia, mme ke ithutile fano mo Jerusalema mo go Gamaliele yo ke ithutileng mo go ene go sala morago sentle melao le dingwao tsa Sejuta. Ke ne ka tlhoafalela go tlotla Modimo mo go sengwe le sengwe se ke neng ke se dira, fela jaaka lo lekile go dira gompieno. ");
INSERT INTO tsn_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Mme ke ne ke bogisa Bakeresete, ke ba beletsa go swa, ke bofa banna le basadi ke ba tsenya mo kgolegelong. ");
INSERT INTO tsn_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Moperesiti yo mogolo kgotsa mongwe wa bagolwane o ka ntshupela. Gonne ke ne ka kopa tetlelelo ya dikwalo tse di yang kwa baeteledipeleng ba Sejuta ba ba kwa Damaseko, tse di nang le ditaelo go ntetla go bofa Bakeresete bangwe ba ke ba bonang go ba isa kwa Jerusalema gore ba otlhaiwe. ");
INSERT INTO tsn_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Mme erile ke le mo tseleng, ke le gaufi le Damaseko, go le motshegare, ka tshoganetso lesedi le le galalelang thata le tswa legodimong la phatshima mo tikologong ya me. ");
INSERT INTO tsn_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ke ne ka wela fa fatshe mme ka utlwa lentswe le nthaya le re, ‘Saulo, Saulo, o mpogisetsang?’ ");
INSERT INTO tsn_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Mme ke ne ka re, ‘Ke mang yo o buang le nna Morena?’ Mme a fetola a re ‘Ke nna Jesu wa Nasaretha, yo o mmogisang!’ ");
INSERT INTO tsn_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Banna ba ke neng ke na nabo ba ne ba bona lesedi mme ba ne ba sa tlhaloganye se se neng se buiwa. ");
INSERT INTO tsn_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Mme ke ne ka re, ‘Ke direng Morena?’ Mme Morena o ne a nthaya a re, ‘Tsoga o tsene mo Damaseko, mme koo o tlaa bolelelwa se se go letetseng mo dingwageng tse di kwa pele.’ ");
INSERT INTO tsn_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ke ne ka foufadiwa ke lesedi le legolo, mme ka tshwanelwa ke go gogelwa mo Damaseko ke bapati ba me. ");
INSERT INTO tsn_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Mme koo ga bo go na le monna yo o bidiwang Ananiase, monna yo o neng a boifa Modimo ka fa molaong, a bile a bolelwa bo-molemo ke Bajuta botlhe ba Damaseko, ");
INSERT INTO tsn_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","o ne a tla kwa go nna, mme ya re a eme fa thoko ga me a re, ‘Mokaulengwe Paulo, foufologa!’ Mme ka yone nako eo ka foufologa ka mmona! ");
INSERT INTO tsn_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Mme a nthaya a re, ‘Modimo wa borraa rona o go tlhophile go itse go rata ga One le go bona Mesia le go mo utlwa a bua. ");
INSERT INTO tsn_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Mme o tshwanetse go tsamaisa molaetsa wa gagwe gongwe le gongwe, o bolela se o se bonyeng le se o se utlwileng. ");
INSERT INTO tsn_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Mme jaanong o diegelang? Tsamaya o ye go kolobediwa, o bo o tlhatswiwe mo dibeng tsa gago, o bitse leina la Morena.’ ");
INSERT INTO tsn_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","18","“Mme erile letsatsi lengwe ke sena go boela kwa Jerusalema, fa ke santse ke rapela mo Tempeleng, ka nna jaaka ekete ke a lora mme ka bona ponatshegelo ya Modimo o nthaya o re, ‘Akofa! Tswa mo Jerusalema, gonne batho ba ba fano ga ba na go go dumela fa o ba neela molaetsa wa me.’ ");
INSERT INTO tsn_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Mme ka re, ‘Morena, ba itse sentle gore ke ne ka betsa ka bo ka tsenya mo kgolegelong ba ba neng ba dumela mo go wena, mo tlung ya thuto nngwe le nngwe. ");
INSERT INTO tsn_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Le ka nako e mosupi wa gago Setefane o neng a bolawa ka yone, ke ne ke eme teng foo ke dumalana nabo, ke tshotse diaparo tse ba neng ba di beetse fa thoko fa ba mmolaya.’ ");
INSERT INTO tsn_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Mme Modimo o ne wa nthaya wa re, ‘Tswa mo Jerusalema, gonne ke tlaa go roma kgakala kwa go Badichaba!’ ” ");
INSERT INTO tsn_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Mme boidiidi jwa batho bo ne jwa reetsa go fitlhelela Paulo a tla mo lefokong leo, mme ka lentswe le le lengwe ba goa ba re, “A motho yoo a tlosiwe! Mmolaeng! Ga a tshwanela go tshela!” ");
INSERT INTO tsn_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ba ne ba goa ba latlhela diaparo tsa bone kwa godimo ba kubuela lorole. ");
INSERT INTO tsn_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Mme molaodi o ne a mo tlisa mo teng ga kago ya batlhabani mme a laola gore a itewe ka dithupa gore a tle a ipolele bosula jwa gagwe. O ne a batla go itse gore ke eng fa batho ba ne ba galefa thata! ");
INSERT INTO tsn_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Mme ya re ba bofa Paulo gore ba mmetse, Paulo a raya moeteledipele mongwe wa mophato a re, “A go siame ka molao gore o betse Mo-Roma a ise a bo a sekisiwe?” ");
INSERT INTO tsn_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Moeteledipele wa mophato a ya kwa go molaodi le ene a re, “O dirang? Monna yo ke Mo-Roma!” ");
INSERT INTO tsn_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Mme molaodi a ya kwa go Paulo a mmotsa a re, “A ko o mpolelele, a o Mo-Roma!” Mme Paulo a fetola a re, “Ee, ke Mo-Roma!” ");
INSERT INTO tsn_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mme molaodi le ene a re, “Le nna ke Mo-Roma, le gone go ntopile tlhwatlhwa e kgolo go nna Mo-Roma!” Mme Paulo ene a re, “Nna ke tsetswe ke le Mo-Roma!” ");
INSERT INTO tsn_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Masole a a neng a ipaakanyeditse go mo itaya, a nyelela ka bonako fa ba utlwa gore Paulo ke Mo-Roma, mme molaodi le ene o ne a tshoga ka gore o ne a laotse gore a bofiwe a bo a itewe. ");
INSERT INTO tsn_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Mme erile letsatsi le le latelang molaodi a golola Paulo mo dikeetaneng mme a laela baperesiti ba bagolo gore ba kopane le lekgotla la Sejuta. O ne a laola gore Paulo a tlisiwe fa pele ga bone go leka go bona gore molato ke eng. ");
INSERT INTO tsn_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Mme erile Paulo a tsepega matlho mo go ba lekgotla, a ba raya a re, “Bagaetsho, ke ntse ke tshela fa pele ga Modimo ka pelo e e siameng!” ");
INSERT INTO tsn_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ka bonako Ananiase Moperesiti yo mogolo a laola gore ba ba gaufi le Paulo ba mo itee mo molomong. ");
INSERT INTO tsn_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Mme Paulo a mo raya a re, “Modimo o tlaa go itaya, wena yo o leng lobota lo lo takilweng. O molaodi yo o ntseng jang yo o tlolang molao ka go laola gore ke itewe?” ");
INSERT INTO tsn_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Mme ba ba neng ba eme go bapa le Paulo ba mo raya ba re, “A ke yone tsela ya go bua le moperesiti yo mogolo wa Modimo”. ");
INSERT INTO tsn_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Mme Paulo a fetola a re, “Ke ne ke sa itse gore a ke Moperesiti yo mogolo, bagaetsho, gonne Dikwalo tsa re, ‘O seka wa ba wa bua bosula kaga ope wa balaodi ba gago.’ ” ");
INSERT INTO tsn_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Mme Paulo a akanya kaga sengwe! Bontlha bongwe jwa batho e ne e le Basadukai mme jo bongwe e le Bafarasai! Mme o ne a goa a re, “Bagaetsho, ke Mofarasai fela jaaka borraetsho mogologolwane mme ke sekisiwa fa gompieno ka gore ke dumela mo tsogong ya baswi!” ");
INSERT INTO tsn_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Mme mo go ne ga kgaoganya lekgotla ka bogare, Bafarasai ba nna kgatlhanong le Basadukai, ");
INSERT INTO tsn_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","gonne Basadukai ba re ga go na tsogo ya baswi kgotsa baengele kgotsa le mowa wa bosenabokhutlo mo go rona, mme Bafarasai bone ba dumela mo go tse tsotlhe. ");
INSERT INTO tsn_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Jalo ga tsoga modumo o mogolo. Bangwe ba baeteledipele ba Bajuta ba tlola ba re Paulo o bua sentle. Ba ne ba goa ba re, “Rona ga re bone molato ope mo go ene, gongwe mowa kgotsa moengele o buile le ene gone mo tseleng ya Damaseko.” ");
INSERT INTO tsn_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Modumo o ne wa golela kwa pele, mme batho ba rutha Paulo mo ditlhakoreng tsoopedi ba mo gogela kwa le kwa. La bofelo molaodi, a laola gore masole a gagwe a mo tseye mo go bone ka dikgoka go mmusetsa mo kagong ya batlhabani ka gore o ne a tshaba gore ba tloga ba mo gagolaka. ");
INSERT INTO tsn_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Mo bosigong joo Morena o ne a ema Paulo fa lotlhakoreng a mo raya a re, “Se tlhobaele, Paulo; fela jaaka o boleletse batho ka ga me mo Jerusalema, o tshwanetse go dira fela jalo le mo Roma.” ");
INSERT INTO tsn_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Tsatsi le le latelang Bajuta ba ka nna masome a mane kgotsa go feta ba ipopa ka maikano a go re ga ba kitla ba a ja le fa e le go nwa go fitlhelela ba bolaya Paulo! ");
INSERT INTO tsn_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Mme ba ya kwa bape-resiting ba bagolo le bagolwane ba ya go ba bolelela se ba se dirileng. ");
INSERT INTO tsn_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ba ne ba kopa jaana, “Re kopa gore molaodi wa masole a busetse Paulo mo lekgo-tleng, lo dire jaaka o ka re lo batla go mmotsa dipotso gape. Rona re tlaa mmolaya mo tseleng.” ");
INSERT INTO tsn_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Mme setlogolo sa ga Paulo sa lemoga leano la bone le le bosula mme a ya kwa kagong ya batlhabani a bolelela Paulo. ");
INSERT INTO tsn_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Mme Paulo a bitsa mongwe wa bagolwane a mo raya a re, “Tsaya mosimane yo o mo ise kwa go molaodi. O na le sengwe sa botlhokwa go se mmolelela.” ");
INSERT INTO tsn_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Jalo mogolwane a dira jalo, a feta a tlhalosa a re, “Legolegwa Paulo, o mpiditse mme a kopa gore ke tlise mosimane yo kwano go wena go go bolelela sengwe.” ");
INSERT INTO tsn_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Molaodi a tshwara mosimane ka seatla, a mo gogela kwa thoko a mmotsa a re, “Ke eng se o batlang go se mpolelela mosimane?” ");
INSERT INTO tsn_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Mme mosimane a mo raya a re, “Ka moso Bajuta ba tlaa tla go kopa gore o tlise Paulo mo lekgotleng gape, ba dira jaaka o ka re ba batla go tlhotlhomisa thata ka ga gagwe. ");
INSERT INTO tsn_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Mme o seka wa dira jalo! Go na le banna ba feta masome a mane ba ba iphitlhileng go bapa le tsela ba ipaakanyeditse go mo tlolela ba mmolaya. Ba ipopile ka maikano a gore ba seka ba ja kgotsa baa nwa go fitlhelela a a swa. Ba mo laletse teng koo, ba lebeletse gore o dumalane le kopo ya bone.” ");
INSERT INTO tsn_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Mme molaodi o ne a tlhagisa mosimane a re, “O seka wa ba wa dira gore mongwe a itse gore o mpoleletse selo se.” ");
INSERT INTO tsn_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","24","Mme molaodi a bitsa bangwe ba bagolwane ba gagwe ba le babedi a ba raya a re, “Baakanyang batlhabani ba le makgolo mabedi ba ye Kaesarea ka nako ya boroba bongwe bosigo! Tsayang banna ba dichaka ba le makgolo a mabedi le bapalami ba le masome a supa. Neelang Paulo pitse gore a palame mme lo mo ise kwa go kgosana Felise a babalesegile.” ");
INSERT INTO tsn_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Mme a kwalela Felise lokwalo lo lo buang jaana: ");
INSERT INTO tsn_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Go tswa kwa go Kalaudio Lusia, Lo ya kwa go Motlotlegi Kgosana Felise, Ditumediso! ");
INSERT INTO tsn_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","“Monna yo o ne a gapilwe ke Bajuta mme ba ne ba batla go mmolaya mme ke romela masole gore ba mo falotshe, gonne ke ne ke utlwile fa e le Mo-Roma. ");
INSERT INTO tsn_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Mme ke ne ka mo isa kwa lekgotleng la bone go bona se a se dirileng. ");
INSERT INTO tsn_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Mme ka bofefo ka lemoga fa e le sengwe kaga ditumelo tsa bone tsa Sejuta, mme tota go sena sepe se se neng se supa gore o ka tsenngwa mo kgolegelong kgotsa a bolawa. ");
INSERT INTO tsn_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Mme erile ke bolelelwa ka leano la go mmolaya, ka tlelwa ke kakanyo ya go mo romela kwa go wena mme ke tlaa laela ba ba mmonyeng molato go tlisa dikatlholo tsa bone fa pele ga gago.” ");
INSERT INTO tsn_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Mme erile bosigo joo, jaaka go laotswe masole a isa Paulo kwa Antipateri. ");
INSERT INTO tsn_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Mme ba boela kwa kagong ya batlhabani moso o o latelang, ba mo tlogela le bapalami ba dipitse gore ba mo ise kwa Kaesarea. ");
INSERT INTO tsn_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Erile ba goroga kwa Kaesarea, ba neela Kgosana Paulo le lokwalo. ");
INSERT INTO tsn_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","O ne a bala lokwalo mme a botsa Paulo gore o tswa kae. Paulo a araba a re, “Ke tswa Kilikia.” ");
INSERT INTO tsn_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Kgosana ya mo raya ya re, “Ke tlaa utlwa kgang ya gago sentle fa ba ba go bonyeng molato ba tla,” mme a laola gore Paulo a tshegediwe mo kgolegelong e e mo kagong ya Bogosi ya ga Kgosi Herode. ");
INSERT INTO tsn_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Erile morago ga malatsi a le matlhano Ananiase Moperesiti yo Mogolo a goroga le bangwe bagolwane ba Bajuta le mmueledi Teretulo, go tla go bolela molato wa ga Paulo. ");
INSERT INTO tsn_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Mme erile Teretulo a bidiwa, a bolelela kgosana kaga molato wa ga Paulo jaana: “Motlotlegi, rona Bajuta o re neile kagiso le kutlwano ebile o ngotlile kgethololo thata mo go rona. ");
INSERT INTO tsn_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Mme ka se, re go leboga thata. ");
INSERT INTO tsn_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mme gore ke se ka ka tlhola ke go lapisa, ntheetsa ka bopelo-namagadi fela ka bokhutshwane fa ke bua ditlhogo tsa tsheko ya rona kgatlhanong le monna yo. ");
INSERT INTO tsn_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Gonne re mmonye gore ke motho yo o letshwenyo, monna yo ka nako tsotlhe o tlhotlheletsang Bajuta mo tikologong yotlhe ya lefatshe go tsogologela mmuso wa Roma. Ke Moeteledipele wa lekoko le le bidiwang Banasaretha. ");
INSERT INTO tsn_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Mme gape o ne a leka go senya Tempele fa re mo tshwara. Re ka bo re mo neile se tota se mo tshwanetseng, ");
INSERT INTO tsn_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","mme Lisiase, molaodi wa mophato, o ne a tla go mo tsaya ka kgopholo mo go rona, ");
INSERT INTO tsn_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","a batla gore a sekisiwe ka molao wa Roma. O ka nna wa utlwa boammaaruri jwa go mo tshwaa phoso ga rona ka go mo tlhotlhomisa.” ");
INSERT INTO tsn_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Mme Bajuta ba bangwe botlhe ba dumalana gore sengwe le sengwe se Teretulo o se buileng ke boammaaruri. ");
INSERT INTO tsn_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Mme jaanong e ne e le nako ya ga Paulo gore a bue. Kgosana ya mo gwetlha ka seatla gore a eme a bue. Paulo a simolola a re, “Ke a itse rra, gore ga o bolo go nna moatlhodi wa ditsheko tsa Sejuta fa ke bua boiphemelo jwa me, ");
INSERT INTO tsn_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","o ka lemoga ka bonako gore ke malatsi a le lesome le bobedi ke sena go goroga kwa Jerusalema go tla go obama mo Tempeleng, ");
INSERT INTO tsn_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","mme gape o tlaa lemoga gore ga ke ise ke tsose khuduego mo tlung ya thuto kgotsa mo mebileng ya motse; ");
INSERT INTO tsn_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","mme banna ba tota ga ba ka ke ba supa dilo tse ba di ntshwaelang phoso. ");
INSERT INTO tsn_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Mme selo sengwe fela se ke se dumelang ke gore ke dumela mo polokong, e ba e bitsang lekoko la tumelo ya bakgelogi, ke sala morago mokgwa oo wa go direla Modimo wa borraetshomogolo; ke dumela thata mo molaong wa Sejuta le sengwe le sengwe se se kwadilweng mo dibukeng tsa seporofeto; ");
INSERT INTO tsn_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","mme ke a dumela, fela jaaka banna ba, gore go tlaa nna le tsogo ya basiami le baleofi. ");
INSERT INTO tsn_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Mme ka ntlha ya se, ke leka ka bojotlhe gore ka metlha yotlhe ke nne le pelo e e senang sekgopi fa pele ga Modimo le batho. ");
INSERT INTO tsn_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Morago ga dingwaga tse dintsinyana tse di fetileng, ke ne ka boela kwa Jerusalema ka madi go thusa Bajuta, le go ntshetsa Modimo setlhabelo. ");
INSERT INTO tsn_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Balatofatsi ba me ba ne ba mpona mo Tempeleng fa ke ntsha dimpho tsa me. Ke ne ke ipeotse tlhogo jaaka go batlwa ke melao ya bone mme go ne go se na bontsi bope fa go nna, le fa e le khuduego! Mme Bajuta bangwe ba ba neng ba tswa Asia ba ne ba le teng, ");
INSERT INTO tsn_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","(ba ba neng ba tshwanetse ba ka bo ba le fano fa, fa e le gore ba na le sengwe kgatlhanong le nna), ");
INSERT INTO tsn_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","mme bona! Botsa banna ba gone fa gore ke ofe molato o lekgotla la bone le o bonyeng mo go nna, ");
INSERT INTO tsn_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","fa e se go bua selo se le sengwe fela se ke neng ke sa tshwanela go se bua fa ke re, ‘Ke fano fa pele ga lekgotla go iphemela ka ntlha ya go dumela gore baswi ba tlaa tsoga gape!’ ” ");
INSERT INTO tsn_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Mme Felise, yo o neng a itse gore Bakeresete ba ne ba ise ba ke ba tsamaye ba tsosa khuduego, a bolelela Bajuta gore ba iketle ba emele go goroga ga ga Lusia molaodi wa mophato, mme ke gone o tlaa atlholang kgang. ");
INSERT INTO tsn_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Mme a laola gore Paulo a tsenngwe mo kgolegelong, a bo a laela batlhokomedi gore ba mo tshware sentle le gore ba seka ba itsa ditsala dipe tsa gagwe go mo etela kgotsa go mo tlisetsa dimpho go dira gore a nametsege fa a ntse a le mo kgolegelong. ");
INSERT INTO tsn_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Erile morago ga malatsi a se kae Felise a tla le Durusila, mosadi wa gagwe wa Mojuta. A romela gore Paulo a ye go bidiwa, ba reetsa jaaka a ba bolelela kaga tumelo mo go Keresete Jesu. ");
INSERT INTO tsn_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Mme erile a sa ntse a buisanya nabo kaga tshiamo le boikgapo le katlholo e e tlang, Felise a boifa thata. Mme a mo raya a re, “Tsamaya jaanong, mme fa ke na le nako e e siameng, ke tlaa go bitsa gape.” ");
INSERT INTO tsn_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Mme gape o ne a gopola gore Paulo o tlaa mo reka ka madi, jalo, he, o ne a mmitsa kgapetsakgapetsa go buisanya nae. ");
INSERT INTO tsn_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Dingwaga tse pedi tsa fela ba ntse ba buisanya; mme Porokio Feseto a tsaya maemo a ga Felise. Mme ka gore Felise o ne a batla go itumedisa Bajuta, o ne a tlogela Paulo mo kgolegelong. ");
INSERT INTO tsn_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Erile morago ga malatsi a mararo Feseto a sena go goroga kwa Kaesarea go tsaya maemo a gagwe a masha, a ya Jerusalema, ");
INSERT INTO tsn_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","kwa baperesiti ba bagolo le bangwe bagolwane ba Bajuta ba neng ba mo fitlhela teng ba bo ba mmolelela polelo ya bone ka ga Paulo. ");
INSERT INTO tsn_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ba mo kopa go tlisa Paulo ka bonako kwa Jerusalema. (Leano la bone e ne e le go mo lalela mo tseleng ba mmolaya). ");
INSERT INTO tsn_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Mme Feseto a ba fetola a re, “E re ka Paulo a le kwa Kaesarea, le ene ka boene a ne a boela teng ka bofefo, ");
INSERT INTO tsn_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ba ba nang le thata mo puong e ba tshwanetse go boela le ene kwa tshekong.” ");
INSERT INTO tsn_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Erile morago ga malatsi a robabobedi kgotsa a le some a boela kwa Kaesarea. Mme letsatsi le le latelang a rebola gore tsheko ya ga Paulo e tsene. ");
INSERT INTO tsn_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Mme erile fa Paulo a goroga mo kgotleng Bajuta ba ba tswang Jerusalema ba phuthega, ba mo pega melato e mentsi e ba neng ba sena bosupi mo go yone. ");
INSERT INTO tsn_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Mme Paulo a itatola melato ya bone a re, “Ga ke molato, ga ke ise ke ko ke ganetse melao ya Sejuta le fa e le go nyatsa Tempele ya Sejuta kgotsa go tsogologela mmuso wa Seroma.” ");
INSERT INTO tsn_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Mme erile ka Feseto a batla go itumedisa Bajuta, a mmotsa a re, “A o batla go ya Jerusalema go ya go sekisiwa ke nna?” ");
INSERT INTO tsn_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","11","Mme Paulo a fetola a re, “Nnyaa! Ke batla go utlwa katlholo ya me fa pele ga Kgosi e kgolo ka bo yone. O itse sentle gore ga ke molato. Fa ke dirile sengwe se se tshwanetseng loso, ga ke tshabe go swa! Mme fa ke se na molato, lefa e le wena kgotsa mongwe fela ga a na thata ya go nneela banna ba gore ba mpolaye. Ke ikuela mo go Kaesara!” ");
INSERT INTO tsn_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Mme Feseto a buisanya le bagakolodi ba gagwe a fetola jaana, “Go siame! o ikuetse mo go Kaesara, mme o tlaa ya kwa go Kaesara!” ");
INSERT INTO tsn_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Mme erile morago ga malatsinyana Kgosi Ageripa a goroga le Berenise mo Kaesarea a etetse Feseto. ");
INSERT INTO tsn_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Erile ba ntse ba le mo malatsing a bone a loeto Feseto a tlotlela Kgosi ka tsheko ya ga Paulo. A mo raya a re, “Go na le legolegwa lengwe fano le tsheko ya lone ke e tlogeletsweng ke Felise. ");
INSERT INTO tsn_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Erile fa ke le kwa Jerusalema, baperesiti ba bagolo le bangwe bagolwane ba Bajuta ba mpolelela bontlha-bongwe jwa polelo ya bone kaga Paulo mme ba nkopa gore ke mo atlhole gore a bolawe. ");
INSERT INTO tsn_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Mme ruri ke ne ka ba bolelela ka bonako gore molao wa Roma ga o tshwae motho phoso a ise a sekisiwe. O neelwa sebaka sa go re a iphemele a lebaganye le basekisi ba gagwe. ");
INSERT INTO tsn_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“Erile fa ba tla kwano ba tlela tsheko, ka bitsa kgang e ka letsatsi le le latelang mme ka laola gore Paulo a tlisiwe. ");
INSERT INTO tsn_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Mme melato e o neng a e bonwa e ne e se yone tota e ke neng ke e solofetse. ");
INSERT INTO tsn_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","E ne e le sengwe kaga tumelo ya bone, le kaga mongwe yo o bidiwang Jesu yo o neng a swa, mme Paulo ene o ne a tswelela a bolela gore o tshedile! ");
INSERT INTO tsn_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ke ne ke eme tlhogo ke sa itse gore ke ka atlhola tsheko ya mofuta o jang mme ka mmotsa gore a o ka rata go ya go sekisediwa kwa Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Mme Paulo a ikuela kwa go Kaesara! Mme ka mmusetsa mo kgolegelong go fitlhelela ke rulaganya gore a ye kwa Kgosing e kgolo.” ");
INSERT INTO tsn_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ageripa a fetola a re, “Ke batla go utlwa monna yoo ka bonna.” Mme Feseto a fetola a re, “O tlaa mo utlwa ka moso!” ");
INSERT INTO tsn_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Mme erile letsatsi le le latelang, morago ga Kgosi le Berenise ba goroga mo Kgotleng ka boitlotlomatso jo bogolo, ba patilwe ke matona a masole le banna ba ba tlotlegang ba motse, Feseto a laola gore Paulo a leriwe mo teng. ");
INSERT INTO tsn_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Mme Feseto a buisa bareetsi jaana: “Kgosi Ageripa le ba ba teng botlhe, monna yo ke ene yo loso lwa gagwe lo batlwang ke Bajuta botlhe; ba mono le ba ba kwa Jerusalema! ");
INSERT INTO tsn_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Mme mo mogopolong wa me ga a dira sepe se se tshwanetseng loso. Legale, o ikuetse mo go Kaesara, mme nna ga go na se ke ka se dirang fa e se go mo romela kwa go ene. ");
INSERT INTO tsn_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Mme ke tlaa kwalela kgosi-kgolo ke mo raya ke reng? Gonne ga go na molato ope o o bonalang mo go ene! Mme ke mo tlisitse fa pele ga lona lotlhe, bogolo jang wena Kgosi Ageripa, go mo tlhotlhomisa sentle o bo o mpolelela se ke ka se kwalang. ");
INSERT INTO tsn_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Gonne ga go lebege go utlwala sentle go romela legolegwa kwa kgosing e kgolo go sena molato o o bonwang mo go lone!” ");
INSERT INTO tsn_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Mme Ageripa a raya Paulo a re, “Tswelela o re bolelele polelo ya gago.” Jalo Paulo a otlolola letsogo a ikarabela a re: ");
INSERT INTO tsn_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Ke sego, Kgosi Ageripa, fa ke na le tshwanelo ya go ikarabela fa pele ga gago gompieno, ");
INSERT INTO tsn_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","gonne ke itse fa o le moitseanape wa melao ya Sejuta le ngwao. Mme ke a go kopa gore o ntheetse ka bopelotelele! ");
INSERT INTO tsn_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Fela jaaka Bajuta ba itse sentle, ke rutilwe thata ka Sejuta go tswa bonyaneng jwa me kwa Tareso, mme morago ka rutwa kwa Jerusalema, mme ka tshela fela jalo. ");
INSERT INTO tsn_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Mme fa ba rata ba ka dumalana le nna, ba itse gore ke ne ke le mofarasai yo o tlhokomelang melao fa go tla mo kobamelong ya melao ya Sejuta le dingwao. ");
INSERT INTO tsn_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Mme lebaka le ba ntshetseng morago go ntshekisa ke ka ntlha ya selo sengwe, ke ka ntlha ya gore ke solofetse tiragalo ya tsholofetso ya Modimo e e neng ya solofediwa borraa-ronamogologolwane. ");
INSERT INTO tsn_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Merafe e e lesome le bobedi ya Iseraele e leka bosigo le motshegare go goroga kwa tsholofelong e ke nang nayo! Le fa go ntse jalo Kgosi, mo go nna ba re ke molato! ");
INSERT INTO tsn_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","A mme go molato go dumela mo tsogong ya baswi. ");
INSERT INTO tsn_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“A go utlwala go sa dumelesege mo go wena gore Modimo o ka tsosa batho mo losong gore ke tshwanetse go dira ditiro tse di boitshegang mo balateding ba ga Jesu wa Nasaretha. ");
INSERT INTO tsn_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ke ne ka tsenya baitshepi ba le bantsi mo kgolegelong kwa Jerusalema, jaaka go ne go laotswe ke baperesiti ba bagolo; mme erile ba atlholelwa leso ka dumelana nabo. ");
INSERT INTO tsn_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ke ne ke tlhokofatsa Bakeresete gongwe le gongwe go leka gore ba hutse Keresete. Ke ne ke le bogale thata mo go bone mo ke neng ka bogisa le ba metse e e kgakala mo mafatsheng a sele. ");
INSERT INTO tsn_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Ke ne ke le mo loetong lo lo ntseng jalo ke ya Damaseko, ke tshotse ditaelo tse di neng di tswa kwa baperesiting ba bagolo, ");
INSERT INTO tsn_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","fa ka letsatsi lengwe ka e ne e le motshegare wa sethoboloko, nna le bapati ba me ra phatshimelwa ke lesedi le le neng le phatsima go gaisa letsatsi. ");
INSERT INTO tsn_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Re ne ra wela fa fatshe rotlhe, mme ka utlwa lentswe le bua le nna ka Sehebera le re, ‘Saulo, Saulo, o mpogisetsang? O ikutlwisa botlhoko fela!’ ");
INSERT INTO tsn_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Ka botsa ka re, ‘O mang Morena?’ Mme a fetola a re, ‘Ke Jesu, yo o mmogisang. ");
INSERT INTO tsn_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Jaanong ema ka dinao! Gonne ke bonetse mo go wena go go dira modiredi le mosupi wa me. O tshwanetse go bolelela lefatshe ka tiragalo e, le kaga tse dingwe tse ke tlaa di go supegetsang. ");
INSERT INTO tsn_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mme ke tlaa go sireletsa mo go bagaeno le mo go Badichaba. Ee, ke tlaa go romela kwa go Badichaba, ");
INSERT INTO tsn_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","go bula matlho a bone mo go tse e leng tsa boammaaruri gore ba tle ba ikwatlhaye ba nne mo leseding la Modimo go na le gore ba tshele mo lefifing la ga Satane, gore ba tle ba bone boitshwarelo jwa dibe tsa bone le go ja boswa jwa Modimo mmogo le batho botlhe gongwe le gongwe ba dibe tsa bone di tlhatswitsweng, ba ba beetsweng kwa thoko ka ntlha ya go dumela mo go nna.’ ");
INSERT INTO tsn_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Mme jalo, Kgosi Ageripa, ga ke a ka ka tlhoka go reetsa ponatshegelo eo e e tswang kwa legodimong! ");
INSERT INTO tsn_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ke ne ka rerela pele ba ba kwa Damaseko, le Jerusalema le mo tikologong yotlhe ya Judea, le mo go Badichaba gore botlhe ba tshwanetse go tlogela dibe tsa bone mme ba sokologela kwa Modimong, mme ba supe tshokologo ya bone ka go dira ditiro tse di siameng. ");
INSERT INTO tsn_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Bajuta ba ne ba ntshwara mo Tempeleng ka ntlha ya go rera jaana, mme ba leka go mpolaya, ");
INSERT INTO tsn_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","mme Modimo o ne wa ntshireletsa gore ke be ke sa ntse ke tshela gompieno gore ke bolelele mongwe le mongwe dilo tse, bagolo le bannye. Ga ke rute sepe fa e se se baporofiti le Moshe ba se buileng, ");
INSERT INTO tsn_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","gore Mesia o tlaa boga, mme a nne wa ntlha go tsoga mo baswing, go tlisa lesedi mo Bajuteng le mo go Badichaba.” ");
INSERT INTO tsn_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Mme ka tshoganetso Feseto a goa a re, “Paulo oa tsenwa, Go rutega thata ga gago go a go tsentsha!” ");
INSERT INTO tsn_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Mme Paulo a fetola a re, “Ga ke tsenwe, Motlotlegi Feseto. Ke bua mafoko a boammaaruri jo bo itekanetseng. ");
INSERT INTO tsn_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Mme Kgosi Ageripa o itse kaga dilo tse. Ke bua ke gololesegile gonne ke itse sentle gore ditiragalo tse di tlwaelesegile mo go ene, gonne ga di a direlwa mo sephiring! ");
INSERT INTO tsn_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kgosi Ageripa, a o dumela baporofiti? Mme ke a itse gore o a dumela.” ");
INSERT INTO tsn_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Mme Ageripa a mo tsena ganong a re, “A o batla go ntira Mokeresete mo lobakeng lo lokhutshwane lo?” ");
INSERT INTO tsn_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Mme Paulo a fetola a re, “Mo Modimong le fa mafoko a me a le bokoa kgotsa a nonofile, wena le botlhe ba ba leng fano mo bathong ba ba tsileng go reetsa ba, lo ka nna jaaka nna, ke sa reye lo golegilwe ka dikeetane tse.” ");
INSERT INTO tsn_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Mme Kgosi le molaodi, le Berenise le ba bangwe botlhe ba ema ba tsamaya. ");
INSERT INTO tsn_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Mme erile ba ntse ba buisanya kgang e, ba dumalana jaana ba re, “Monna yo ga a dira sepe se se tshwanetseng loso kgotsa go tsenngwa mo kgolegelong.” ");
INSERT INTO tsn_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Mme Ageripa a raya Feseto a re, “Fa a ka bo a sa dira boikuelo kwa go Kaisara, o ka bo a gololwa.” ");
INSERT INTO tsn_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Mme lwa bofelo dithulaganyo tsa dirwa go re re simolole mosepele wa rona wa go ya kwa Roma ka sekepe; jalo Paulo le magolegwa a mangwe a mantsi ba bewa mo tlhokomelong ya mogolwane yo o neng a bidiwa Julio, leloko la mophato wa badisa. ");
INSERT INTO tsn_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Mme re ne ra tsamaya ka sekepe se se neng se ya kwa Gerika, se se neng se rulaganyeditswe go ema gantsinyana mo mafelong a sekae mo lotshitshing lwa lewatle la Asia. Ke tshwanetse go bolela gore Arisetareka wa Mogerika yo o neng a tswa kwa Thesalonika o ne a na le rona. ");
INSERT INTO tsn_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Tsatsi le le latelang erile re ema kwa Sidona, Julio o ne a siame thata mo go Paulo mme a mo letla gore a fologe mo sekepeng a etele ditsala tsa gagwe gore di mo amogele ka boitumelo. ");
INSERT INTO tsn_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Mme erile go tloga foo, ra kgorelediwa ke diphefo tse di neng tsa dira gore go nne thata go tlhamalatsa sekepe, jalo ra leba kwa bokone jwa Kupero fa gare ga setlhake le lefatshe, ");
INSERT INTO tsn_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","mme ra feta go bapa le kgaolo ya Kilikia le Pamfilia, ra ema kwa Mira, mo kgaolong ya Lukia. ");
INSERT INTO tsn_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Mme foo molaodi wa rona a bona sekepe sa Egepeto se se tswang kwa Alekesanderia, se ya Itale, mme sa re tsaya. ");
INSERT INTO tsn_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","8","Re ne ra tsamaya mo dikgoberegong malatsi a le mantsi, mme la bofelo ra atamela Kinido; mme diphefo di ne di setse di gaketse, jalo ra tabogela kwa Kereta, ra feta mo boemelong dikepe jwa Salamone. Mme erile re ntse re lebaganye le phefo ka bothata jo bogolo re tsamaya re iketlile mo lotshitshing lwa borwa, ra goroga mo felong fa go bidiwang Dinwane Dintle gaufi le motse wa Lusia. ");
INSERT INTO tsn_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Mme ra nna malatsi a le mantsi koo. Ka nako eo phefo e ne ya nna maswe mo e leng gore re ne re sa kgone go tsamaya mosepele o moleele, gonne ngwaga e ne e tsamaela go fela, mme Paulo a bua le balaodi ba sekepe ka gone. ");
INSERT INTO tsn_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","A re, “Borra, ke dumela gore go tlaa nna mathata kwa pele fa re ka tswelela, gongwe sekepe sa rona se ka nna sa senyega, kgotsa ra latlhegelwa ke morwalo wa rona, ra gobala kgotsa ra a swa.” ");
INSERT INTO tsn_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Mme le fa gontse jalo batlhokomedi ba magolegwa ba ne ba reetsa molaodi wa sekepe le mong wa sone go na le Paulo. ");
INSERT INTO tsn_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Mme ka gore Dinwane Dintle e ne e le boemelo jo bo mo pepeneneng, lefelo le le sa siamelang go nna mo go lone mariga, bontsi jwa batho ba ba dirang mo sekepeng ba re gakolola gore go ka nna jang fa re leka go tlhatlogela kwa Finekisa go fetsa mariga teng; Finekisa e ne e le boemelo jwa dikepe jo bo siameng bo lebile kwa bokone-bophirima le kwa borwa-bophirima. ");
INSERT INTO tsn_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Mme ka yone nako eo ga simologa phefo e e fokang ka bonya e tswa borwa, mme go ne go lebega e le letsatsi le le siametseng loeto, jalo ba tsamaya ba ikamile lotshitshi lwa lewatle. ");
INSERT INTO tsn_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","15","Mme ka bofefo morago ga moo, ga nna le phetogo mo loaping, ga tsoga ledimo la phefo e e nonofileng thata (e ba e bitsang ya Bokone-botlhaba) la kapa sekepe la se phailela kwa teng ga lewatle. La ntlha ba ne ba leka go se lebisa kwa lotshitshing mme ba se ka ba kgona, jalo ba ineela gore phefo e kgweeletse sekepe kwa e yang teng. ");
INSERT INTO tsn_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Mme la bofelo ra goroga fa setlhakenyaneng se se neng se bidiwa Jauda, kwa e rileng ka bothata ra tlolela mo mokorong wa namolo o o neng o tswa kwa morago, ");
INSERT INTO tsn_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","mme ra fapa sekepe kwa tlase. Badiri mo sekepeng ba ne ba tshaba go phepheulelwa ke phefo kwa go totomelang kwa lotshitshing lwa Afrika. Ba folosa disaile tsa sekepe ba ntse ba phepheulwa ke phefo. ");
INSERT INTO tsn_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Erile letsatsi le le latelang fa lewatle le kokomoga, badiri mo sekepeng ba simolola go latlhela merwalo mo lewatleng. ");
INSERT INTO tsn_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Mme letsatsi le le latelang ba latlhela dilwana tsa bone le sengwe le sengwe se se neng se le gaufi nabo. ");
INSERT INTO tsn_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Dikhuduego tsa lewatle tsa nna dikgolo ka malatsi a le mantsi go fitlhelela la bofelo go sena tsholofelo epe. ");
INSERT INTO tsn_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Mme ka lobaka lo lo leele go ne go sena ope yo o kileng a ja, mme la bofelo Paulo o ne a bitsa badiredi ba sekepe botlhe a re, “Banna, lo ka bo lo ne lwa ntheetsa lantlha mme ra seka ra tloga mo Dinwane Dintle, lo ka bo lo falotse dikgobalo tse le tatlhegelo! ");
INSERT INTO tsn_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Mme le fa go ntse jalo nametsegang! Ga go ope wa rona yo o tlaa latlhegelwang ke botshelo, ntswa sekepe sone se tlaa nwela. ");
INSERT INTO tsn_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","“Gonne bosigo jo bo fetileng moengele wa Modimo yo ke leng wa gagwe le yo ke mo direlang o ne a ema fa thoko ga me, ");
INSERT INTO tsn_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","a re, ‘Se boife, Paulo, gonne ka boammaaruri o tlaa sekisiwa ke Kaesara! Mo gongwe gape ke eng, Modimo o arabile kopo ya gago mme o tlaa boloka matshelo a botlhe ba ba mo loetong le wena.’ ");
INSERT INTO tsn_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Mme jaanong nametsegang! Gonne ke dumela Modimo! Go tlaa nna fela jaaka o buile! ");
INSERT INTO tsn_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Mme le fa go ntse jalo sekepe sa rona se tlaa senyegela fa setlhakeng.” ");
INSERT INTO tsn_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Mme erile e ka nna nako ya bosigo-gare mo bosigong jwa bo lesome le bone jwa khuduego ya lewatle, fa re ntse re phepheulelwa kwa pele le kwa morago mo lewatleng la Aderia, batsamaisi ba sekepe ba belaela gore lefatshe le gaufi. ");
INSERT INTO tsn_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ba ne ba lekeletsa boteng jwa metse mme ba bona e le boteng jwa dikgato di le lekgolo le masome a mabedi. Morago ga sebakanyana ba lekeletsa gape, mme ba bona e le dikgato di le masome a roba bongwe. ");
INSERT INTO tsn_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Mme ka selekanyo se ba itse gore ba gaufi le go phepheulelwa kwa lotshitshing, mme ka ba tshaba mafika a a gaufi le lotshitshi, ba digela diitsetsepelo di le nne ka kwa morago ga sekepe mme ba rapela gore go nne lesedi. ");
INSERT INTO tsn_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Mme batsamaisi ba bangwe ba loga leano la go tlogela sekepe, mme ba fologa mokoro wa phalotsho jaaka o ka re ba ya go tlhoma diitsetsepelo kwa pele. ");
INSERT INTO tsn_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Mme Paulo a raya masole le molaodi a re, “Lo tlaa swa lotlhe fa lo ka seka lwa nna mo sekepeng.” ");
INSERT INTO tsn_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Mme masole a kgaola megala a tlogela mokoro wa wa. ");
INSERT INTO tsn_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Erile masa a sa, Paulo a kopa mongwe le mongwe gore a je, a re, “Ga lo ise lo ke lo ame dijo mo dibekeng tse pedi tse di fetileng! ");
INSERT INTO tsn_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Tsweeng-tsweeng jang sengwe gore lo thusege! Gonne le fa ele thiri ya ditlhogo tsa lona ga e na go nyelela!” ");
INSERT INTO tsn_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Mme a tsaya senkgwenyana se se omisitsweng a leboga Modimo fa pele ga bone botlhe, mme a ja. ");
INSERT INTO tsn_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ka bofefo mongwe le mongwe a ikutlwa sentle mme ba simolola go ja, ");
INSERT INTO tsn_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","rotlhe re ne re le makgolo a mabedi le masome a supa le borataro, gonne eo ke yone palo e e neng e le mo sekepeng. ");
INSERT INTO tsn_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Erile re sena go ja, badiri ba sekepe ba fokotsa morwalo ka go latlhela mabele mo lewatleng. ");
INSERT INTO tsn_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Mme erile bosa bo sele, ba seka ba tlhaloganya lefatshe gore ke lefe, mme ba bona senwane se se lobota lo papametseng mme ba akanya gore a ba ka tsena fa gare ga mantswe ba phepheulelwa ke phefo kwa lotshitshing. ");
INSERT INTO tsn_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Mme la bofelo ba ikaelela go leka jalo. Ba kgaola diitsetsepelo ba di tlogela mo lewatleng, ba folosa dikgong tse di sokololang sekepe ba pega disaile ba leba kwa lotshitshing. ");
INSERT INTO tsn_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Mme sekepe sa thula totoma ya motlhaba sa totomela. Mpa ya sone ya tsena mo mmung, mme marago a sone a thujwa ke makhubu a metsi. ");
INSERT INTO tsn_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Mme masole a buisanya le molaodi wa bone gore ba bolaye magolegwa e se re kgotsa ope wa bone a shapela kwa lotshitshing a falola. ");
INSERT INTO tsn_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Mme Julio ka a ne a batla go boloka Paulo, a ganana le mogopolo oo. Mme a laola gore botlhe ba ba ka kgonang go shapa ba fologe ba shapele kwa ntle, ");
INSERT INTO tsn_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","mme ba ba sa kgoneng go shapa ba leke ka dipolanka le dikgong tse di robegileng mo sekepeng. Mme mongwe le mongwe a kgona go falolela kwa lotshitshing. ");
INSERT INTO tsn_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","2","Mme ka bofefo ra lemoga fa re gorogile mo setlhakeng sa Malita. Batho ba setlhake ba ne ba re siametse thata, ba ne ba gotsa molelo o motona fa lotshitshing go re amogela le go re thuthafatsa mo puleng le mo botsididing. ");
INSERT INTO tsn_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Mme erile fa Paulo a kokoanya ngata ya dikgong go di tsenya mo molelong, noga e e botlhole ya ntshiwa mo molelong ke mogote, ya ithatha ka letsogo la gagwe! ");
INSERT INTO tsn_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Mme batho ba setlhake ba ne ba e bona e lepeletse mme ba raana ba re, “Ke mmolai ga gona pelaelo! Le ntswa a falotse mo lewatleng, tshiamiso ga e ka ke ya mo letla gore a tshele!” ");
INSERT INTO tsn_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Mme Paulo a tlhotlhorela noga mo molelong e sa mo loma. ");
INSERT INTO tsn_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Mme batho ba solofela gore ba tlaa bona a ruruga kgotsa a wa fela ka tshoganetso a a swa; mme erile ba sena go nna ba lebeletse ka lobaka lo loleele mme go sena kgobalo epe mo go ene, ba fetola megopolo ya bone mme ba re ke modimo. ");
INSERT INTO tsn_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Fa lotshitshing fa re neng ra nna teng go ne go na le tshimo ya ga Pubelio, molaodi wa setlhake. O ne a re amogela sentle a bo a re fa dijo ka malatsi a le mararo. ");
INSERT INTO tsn_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Mme erile ka yone nako eo, rraagwe Pubelio a bo a lwala bolwetse jwa letshoroma le motabogo o mohibidu. Paulo a tsena a mo rapelela, mme a mmaya diatla a mo fodisa! ");
INSERT INTO tsn_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Mme balwetse ba bangwe botlhe mo setlhakeng ba tla mme ba fodisiwa. ");
INSERT INTO tsn_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Mme ka ntlha ya moo ra tshologelwa ke dimpho di le dintsi, mme erile fa go tla nako ya gore re tsamaye, batho ba olela mefuta yotlhe ya dilo tse re tlaa di tlhokang mo loetong. ");
INSERT INTO tsn_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","E ne e le kgwedi tse tharo sekepe se sena go senyega pele ga re simolola go tsamaya, mme ka nako e, re ne ra tsamaya ka sekepe se se bidiwang Mafatlha a Basimane sa Alekesanderia, sekepe se se neng se feditse mariga mo setlhakeng. ");
INSERT INTO tsn_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Re ne ra ema la ntlha kwa Sirakuse, kwa re neng ra nna teng malatsi a mararo. ");
INSERT INTO tsn_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Mme go tswa foo ra dikologa ra ya kwa Regiama; letsatsi le le latelang phefo ya borwa ya simolola go foka, mme letsatsi le le latelang ra goroga kwa Puteoli, ");
INSERT INTO tsn_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","kwa re neng ra bona badumedi bangwe teng! Ba ne ba re kopa gore re nne nabo malatsi a supa. Go tsweng foo ra tswelela ra ya Roma. ");
INSERT INTO tsn_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Bakaulengwe ba Roma ba ne ba utlwile gore re e tla mme ba tla go re kopantsha kwa patlelong mo Tseleng ya Apio. Bangwe ba kopana le rona kwa matlung a mararo a boitapoloso. Erile Paulo a ba bona, a leboga Modimo mme a nametsega. ");
INSERT INTO tsn_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Mme erile fa re goroga kwa Roma, Paulo o ne a letlelelwa gore a nne fa a ratang teng, le fa a ne a disitswe ke lesole. ");
INSERT INTO tsn_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Mme erile malatsi a mararo a sena go feta, a bitsa bagolwane ba Bajuta botlhe ba motse mme a ba raya a re: “Bakaulengwe ke ne ke tshwerwe ke Bajuta kwa Jerusalema mme ka isiwa kwa mmusong wa Roma gore ke sekisiwe, ntswa ke ne ke sa utlwisa ope botlhoko kgotsa go tsuolola ngwao ya borraetsho mogologolwane. ");
INSERT INTO tsn_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Mme Ba-Roma ba ne ba ntshekisa ba bo ba rata go nkgolola, gonne ba ne ba sa bone molato ope o o tshwanetseng loso jaaka bagolwane ba Bajuta ba ne ba batla. ");
INSERT INTO tsn_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Mme erile fa Bajuta ba gana katlholo eo, ka bona go tlhokega, gore ke ikuele mo go Kaisara, ke sa ba eleletse bosula bope. ");
INSERT INTO tsn_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ke lo kopile go tla fano gompieno gore re itsanye le gore ke lo bolelele gore ke golegilwe ka dikeetane ka ntlha ya gore ke dumela gore Mesia o tsile.” ");
INSERT INTO tsn_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Mme ba fetola ba re, “Ga re ise re ke re utlwe sepe se o sekisiwang ka ga sone! Ga re ise re ke re amogele dikwalo dipe tse di tswang kwa Judea kgotsa dipego tse di tlang le ba ba tswang kwa Jerusalema. ");
INSERT INTO tsn_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Mme re batla go utlwa se o se dumelang, gonne se re se itseng fela kaga Bakeresete ba ke gore ba nyadiwa gongwe le gongwe!” ");
INSERT INTO tsn_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Mme ga tlhongwa nako, mme ka letsatsi leo ga tla batho ba le bantsi mo tlung ya gagwe. A ba bolelela kaga Bogosi jwa Modimo a bo a ba ruta kaga Jesu mo Dikwalong, go tswa mo dikwalong tsa ga Moshe tse tlhano le dikwalo tsa baporofiti. A simolola a ruta mo mosong go fitlhelela maitseboa! ");
INSERT INTO tsn_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Mme bangwe ba ne ba dumela, ba bangwe ba gana go dumela. ");
INSERT INTO tsn_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Mme erile ba sena go ganetsanya ka bosi ba tsamaya ba tlhabilwe ke lefoko la bofelo la ga Paulo le le reng, “Mowa O O Boitshepo o ne o bua boammaaruri fa o bua ka Moporofiti Isaia o re, ");
INSERT INTO tsn_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Raya Bajuta o re, “Lo tlaa utlwa lo bo lo bona mme ga lo na go tlhaloganya,” ");
INSERT INTO tsn_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","gonne dipelo tsa lona di thata le ditsebe tsa lona ga di reetse mme lo tswetse matlho a lona gore lo seka lwa bona lwa tlhaloganya, le go sokologela kwa go nna gore ke lo fodise.’ ");
INSERT INTO tsn_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Mme jalo ke batla gore lo lemoge gore poloko e, e e tswang kwa Modimong le Badichaba ke ya bone, ebile bone ba tla e amogela.” ");
INSERT INTO tsn_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Mme Paulo o ne a nna dingwaga tse pedi mo tlung e o neng a e hirile, mme a amogela botlhe ba ba neng ba mo etela, ");
INSERT INTO tsn_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","a ba bolelela ka bopelokgale jotlhe kaga Bogosi jwa Modimo le kaga Morena Jesu Keresete; mme ga seka ga nna le ope yo o lekang go mo didimatsa.");
INSERT INTO tsn_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ditsala tse di rategang mo Roma, Lokwalo lo lo tswa kwa go Paulo, motlhanka wa ga Jesu Keresete, yo o tlhophilweng go nna morongwa, ebile a romilwe go rera Mafoko a Modimo a a Molemo. ");
INSERT INTO tsn_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Mafoko a a Molemo a, a ne a sa bolo go solofediwa batho bogologolo ke baporofiti ba Modimo mo Kgolaganong e kgologolo. ");
INSERT INTO tsn_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Ke Mafoko a a Molemo kaga Morwaa one, Jesu Keresete Morena wa rona, yo o tsileng e le ngwana mo setshwanong sa motho, a tsalelwa mo losikeng lwa bogosi lwa ga Kgosi Dafide, ");
INSERT INTO tsn_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","mme ka go tsosiwa mo baswing o ne a supiwa e le Morwa Modimo yo o senatla, ka tlholego e e boitshepo ya Modimo ka sebele. ");
INSERT INTO tsn_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Mme jaanong, ka Keresete, tshiamo yotlhe ya Modimo e goromeleditswe mo go rona baleofi ba e neng e sa re tshwanela; mme jaanong o re roma mo tikologong ya lefatshe go bolelela batho botlhe gongwe le gongwe kaga dilo tse dikgolo tse Mo-dimo o di ba diretseng, gore le bone ba tle ba dumele ba o obamele. ");
INSERT INTO tsn_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","7","Mme lona, ditsala tse di rategang mo Roma, le lona lo bangwe ba o ba ratang thata, le lona lo lalediwa ke Jesu Keresete go nna ba Modimo tota, ee batho ba one ba ba boitshepo. A masego otlhe a Modimo le kagiso e e tswang kwa Modimong Rara wa rona, le Jesu Keresete Morena wa rona a nne le lona. ");
INSERT INTO tsn_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Mmang ke simololeng ka go re, gongwe le gongwe kwa ke yang teng ke utlwa go buiwa kaga lona! Gonne tumelo ya lona mo Modimong e simolola go itsege mo tikologong ya lefatshe. Ke leboga Modimo thata jang ka Jesu Keresete ka pego e e molemo, le ka mongwe le mongwe wa lona. ");
INSERT INTO tsn_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Modimo o itse gore ke lo rapelela gangwe le gape jang. Bosigo le motshegare ke lo baya le tse lo di tlhokang ka thapelo mo go yo ke mo direlang ka thata yotlhe, ke bolelela ba bangwe Mafoko a a molemo kaga Morwaa one. ");
INSERT INTO tsn_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Mme sengwe sa dilo tse ke di rapelelang gangwe le gape ke lobaka lo lo atlegileng lwa gore, fa Modimo o rata, ke tle go lo bona, le gore fa go kgonega ke tle ke nne le mosepele o o babalesegileng. ");
INSERT INTO tsn_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","12","Gonne ke tlhologeletswe go lo etela gore ke tle ke kgone go lo naya tumelo e e tlaa thusang phuthego ya lona go nitama mo Moreneng. Fela jalo le nna, ke tlhoka thuso ya lona, gonne ga ke batle fela go abalana tumelo ya me le lona le nna ke tlhoka go kgothadiwa ke tumelo ya lona. Mongwe le mongwe wa rona o tlaa nna tshegofatso mo go yo mongwe. ");
INSERT INTO tsn_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Ke batla gore lo itse, bakaulengwe ba ba rategang, gore ke gantsi ke ikaelela go tla kwa go lona (mme go sa kgonege) gore ke tle go dira le lona ke bo ke bone maungo a a molemo, fela jaaka ke dirile mo diphuthegong tse dingwe tsa Badichaba. ");
INSERT INTO tsn_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Gonne ke molato o mogolo mo go lona le mo go mongwe le mongwe, le mo bathong ba ba tlhabologileng le dichaba tsa baheitane; ee, mo go ba ba rutegileng le mo go ba ba sa rutegang fela ka go tshwana. ");
INSERT INTO tsn_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Jalo he, ka fa selekanyong sa nonofo ya me e e tletseng, ke setse ke siame go tla le kwa go lona mo Roma go rera Mafoko a a Molemo a Modimo. ");
INSERT INTO tsn_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Gonne ga ke tlhabisiwe ditlhong ke Mafoko a a Molemo a, kaga Keresete. Ke leano la Modimo le le nonofileng la go gapela kwa legodimong botlhe ba ba dumelang. Molaetsa o, o ne wa rerelwa Bajuta pele ba le bosi, mme jaanong mongwe le mongwe o lalediwa go tla mo Modimong ka yone tsela e. ");
INSERT INTO tsn_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Mafoko a a Molemo a, a re bolelela gore Modimo o re baakanyetsa gore re ye legodimong, a re siamisa mo ponong ya Modimo fa re baya tumelo ya rona le boikanyo mo go Keresete go re boloka. Mo go bonwa ka tumelo go tswa tshimologong go ya bokhutlong. Jaaka lokwalo lo bua lo re, “Motho yo o bonang botshelo o tlaa bo bona ka go ikanya Modimo.” ");
INSERT INTO tsn_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Mme Modimo o supa bogale jwa one jo bo tswang legodimong mo baleofing, batho ba ba bosula ba ba tlosang boammaaruri mo go bone. ");
INSERT INTO tsn_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Gonne ba itse boammaaruri kaga Modimo sentle thata; Modimo o tsentse kitso e mo dipelong tsa bone. ");
INSERT INTO tsn_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Go simolola mo dinakong tsa pele batho ba bonye lefatshe le loapi le gotlhe mo Modimo o go dirileng, ebile ba itsile ka go tshela ga one le nonofo e kgolo ya bosakhutleng. Jalo ga ba kitla ba nna le seipato (fa ba ema fa pele ga Modimo ka letsatsi la katlholo). ");
INSERT INTO tsn_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ee, ba itsile kaga one sentle thata, mme ga ba a ka ba dumela gore ba a o itse kgotsa ba o obamela le fa e le go o leboga ka fa o ba tlhokomelang ka teng malatsi otlhe. Mme morago ga lobakanyana ba simolola go akanya dikakanyo tsa boeleele tsa gore Modimo o ntse jang le gore o batla gore ba dire eng. Jalo ga diragala gore megopolo ya bone ya boeleele e fifale e bo e tlhakatlhakane. ");
INSERT INTO tsn_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ba ikaya fa ba le botlhale kwa ntle ga Modimo, mme ba fetoga dieleele tse di feteletseng ka ntlha ya go tlhoka go ikanya Modimo. ");
INSERT INTO tsn_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Mme hong mo boemong jwa go obamela Modimo o o galalelang o o tshelang ka bosakhutleng, ba ne ba tsaya dikgong le maje mme ba itirela medimo ya disetwa go e obamela, ba e betla go nna jaaka dinonyane le diphologolo le dinoga le batho ba e seng ba sepe ba ba nyatsegang. ");
INSERT INTO tsn_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Jalo Modimo wa ba lesa go tswelela pele mo mofuteng mongwe le mongwe wa boaka, le go dira sengwe le sengwe se ba se batlang ee, ba tlontlolo-lana mebele ka boatla. ");
INSERT INTO tsn_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Mo boemong jwa gore ba dumele se ba itseng e le boammaaruri kaga Mo-dimo, ba dumela ka bomo mo maakeng. Jalo ba obamela dilo tse Modimo o di dirileng, ba gana go obamela one Modimo o o dirileng dilo tse. ");
INSERT INTO tsn_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ke sone se Modimo o ba leseleditseng go dira tsotlhe tse di bosula tse, le gore le basadi ba bone ba furalele leano la Modimo la tlholego mme ba simolola go tlontlololana mebele. ");
INSERT INTO tsn_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Mme banna, mo boemong jwa go tlhakanela dikobo le basadi ka fa tlholegong, ba simolola go gakalelana, banna ba dira dilo tse di tlhabisang ditlhong le banna ba bangwe, mme ka ntlha ya moo ba bona tuelo e e ba tshwanetseng. ");
INSERT INTO tsn_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Jalo ke sone se e rileng fa ba latlha Modimo ebile ba sa batle go o itse, Modimo wa ba tlhokomologa gore ba dire sengwe le sengwe se megopolo ya bone e e bosula e neng e ka se akanya. ");
INSERT INTO tsn_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Matshelo a bone a tlala mofuta mongwe le mongwe wa boikepo le sebe, wa bogagapa le kilo, keletso ya senama, polao, ntwa, maaka, bogalaka le ditshebo. ");
INSERT INTO tsn_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","E ne e le basebi, ba ba ilang Modimo, ba le makgakga, e le baikgantshi, ba aga ba akanya ditsela tse dintsha tsa go leofa ebile ba tswelela pele ba sa reetse batsadi ba bone. ");
INSERT INTO tsn_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Ba leka go itira ba ba sa tlhaloganyeng, ba senya ditsholofetso tsa bone, ba le setlhogo, ba se pelotlhomogi. ");
INSERT INTO tsn_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ba ne ba itse sentle thata gore Modimo o atlholela loso ka ntlha ya melato e, le fa go ntse jalo ba tswelela pele mme ba e dira ka methale yotlhe, ba kgothatsa ba bangwe gore le bone ba e dire. ");
INSERT INTO tsn_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Go siame, o ka ne kgotsa o re, “O ntse o bua kaga batho ba ba sa siamang thata jang!” Iketle pele! Le wena o tshwana nabo. Fa lo re ba ikepile ba tshwanetse go otlhaiwa, go ithaya lona gonne lo dira tsone fela ditiro tse ba di dirang. ");
INSERT INTO tsn_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Mme re itse gore Modimo mo tshekisong o tlaa otlhaya le fa e le mang yo o dirang dilo tse di tshwanang le tse. ");
INSERT INTO tsn_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","A o gopola gore Modimo o tlaa sekisa o bo o atlhola ba bangwe ka ntlha ya go dira dilo tseo mme o go tlodise matlho fa le wena o ntse o di dira? ");
INSERT INTO tsn_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","A ga o lemoge ka fa Modimo o leng pelotelele mo go wena ka teng? Kgotsa a ga o tshwenyege ka gope? A ga o bone gore o ntse o sa go otlhae mo lobakeng lo lotlhe, e le go go naya sebaka sa go sokologa mo sebeng? Bopelonomi jwa one bo diretswe go go gogela kwa boikwatlhaong. ");
INSERT INTO tsn_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Mme le fa go ntse jalo, ga o reetse; mme ka go dira jalo o ipolokela kwatlhao e e setlhogo ka ntlha ya botlhogo-e-thata jwa gago jwa go gana go soko-loga mo sebeng; gonne go tlaa tla letsatsi la bogale fa Modimo o tlaa bong o le moatlhodi yo o sa patikeng wa lefatshe lotlhe. ");
INSERT INTO tsn_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","O tlaa naya mongwe le mongwe tuelo ka fa ditirong tsa gagwe. ");
INSERT INTO tsn_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","O tlaa naya botshelo jo bo sa khutleng ba ba dirang go rata ga Modimo ka bopelotelele, ba batla kgalalelo e e sa bonweng ka matlho le tlotlo le botshelo jo bo sa khutleng jo o bo abang. ");
INSERT INTO tsn_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Mme o tlaa otlhaya setlhogo ba ba tlhabantshang boammaaruri jwa Modimo ba tsamaya mo ditseleng tse di bosula, bogale jwa Modimo bo tlaa ba wela godimo. ");
INSERT INTO tsn_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Go tlaa nna khutsafalo le pogisego mo Bajuteng le mo go Badichaba ba ba tswelelang ba dira boleo. ");
INSERT INTO tsn_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Mme go tlaa nna kgalalelo le tlotlo le kagiso e tswa kwa Modimong e le tsa ba ba o reetsang, le fa e ka ne e le Bajuta kgotsa Badichaba. ");
INSERT INTO tsn_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Gonne Modimo o tsaya batho ka tekatekanyo. ");
INSERT INTO tsn_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","15","O tlaa otlhaya sebe gongwe le gongwe kwa se bonwang teng. O tlaa otlhaya baheitane fa ba leofa, le fa ba ise ba ke ba nne le melao ya Modimo e e kwadilweng, gonne mo botennye jwa dipelo tsa bone ba itse tshiamo le bosula. Melao ya Modimo e kwadilwe mo go bone; segakolodi sa bone se ba baya molato, ka nako e nngwe se dumalana nabo. Mme Modimo o tlaa otlhaela Bajuta go leofa gonne ba na le melao ya one e e kwadilweng mme ga ba e tshegetse. Ba itse se se siameng mme ga ba se dire. Kana poloko ga e newe ba ba itseng se ba tshwanetseng go se dira, fa e se fela ba se dira. ");
INSERT INTO tsn_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ammaaruri letsatsi le tlaa tla fa ka taolo ya Modimo, Jesu Keresete o tlaa atlholang masaitsiweng a mongwe le mongwe, maikutlo a bone a a kwa teng le maikaelelo a bone; se ke bontlha bongwe jwa leano la Modimo le legolo le ke lo le bolelelang. ");
INSERT INTO tsn_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Lona Bajuta lo gopola gore gotlhe go siame fa gare ga lona le Modimo gonne o lo neetse melao ya one; lo ipelafatsa ka gore lo ithaya lo re lo ditsala tsa one tse di tlhophegileng. ");
INSERT INTO tsn_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ee, lo itse se o se batlang; lo itse pharologanyo ya bosula le molemo mme lo rata tshiamo gonne lo rutilwe melao ya one go tsweng bonyaneng jwa lona. ");
INSERT INTO tsn_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Lo tlhomamisa tota tsela e e yang kwa Modimong mo e leng gore lo ka e supegetsa le sone sefofu tota. Lo ipona lo le masedi a a bontshang tsela, lo kaela batho ba ba latlhegetseng mo lefifing tsela ya go ya kwa Modimong. ");
INSERT INTO tsn_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Lo akanya gore lo ka goga dieleele lwa ba lwa ruta le bana ditiro tsa Modimo, gonne lo itse melao ya one sentle e e tletseng kitso yotlhe le boammaaruri. ");
INSERT INTO tsn_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Ee, lo ruta ba bangwe, jaanong ke eng fa lona lo sa ithute? Lo raya ba bangwe lo re ba seka ba utswa, a e bile lo a utswa? ");
INSERT INTO tsn_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Lwa re go phoso go dira kgokafalo a ebile lo a e dira? Lwa re, “Go seka ga rapelwa medimo ya disetwa,” mme lona lo dira madi modimo wa lona wa disetwa mo boemong jwa go rapela Modimo. ");
INSERT INTO tsn_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Lo ipelafatsa thata ka go itse melao ya Modimo, mme lo o tlontlolola ka go e roba. ");
INSERT INTO tsn_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Ga go gakgamatse fa Dikwalo di re lefatshe le bua bosula ka ga Modimo ka ntlha ya lona. ");
INSERT INTO tsn_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Go nna Mojuta go botlhokwa fa o tshegetsa melao ya Modimo; mme fa o sa e tshegetse, ga o botoka go na le moheitane. ");
INSERT INTO tsn_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Mme fa baheitane ba tshegetsa melao ya Modimo, a Modimo ga o kitla o ba naya ditshwanelo tsotlhe le tlotlo e o neng o ikaeletse go e naya Bajuta? ");
INSERT INTO tsn_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ammaaruri baheitane bao ba tlaa nna botoka thata go na le lona Bajuta ba lo itseng thata kaga Modimo ebile lo na le ditsholofetso tsa one mme lo sa tshegetse melao ya one. ");
INSERT INTO tsn_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Gonne ga lo Bajuta tota, fela ka ntlha ya gore lo tsetswe ke batsadi ba Sejuta kgotsa ka ntlha ya gore lo rupisitswe mo mokgweng wa Sejuta, ebong modiro wa bogwera. ");
INSERT INTO tsn_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Nnyaa, Mojuta tota ke mongwe fela yo pelo ya gagwe e siameng mo Modimong. Gonne ga o batle ba ba kgaolang ditokololo dingwe tsa mebele ya bone go rupisiwa ga senama, mme o batla ba ba fetogileng dipelo le mewa. Le fa e le mang yo o nang le phetogo e e ntseng jalo mo botshelong jwa gagwe o tlaa amogela pako e e tswang kwa Modimong, le fa e sa tswe mo go lona. ");
INSERT INTO tsn_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Mme go thusang go nna Mojuta? A go na le botlhokwa bongwe mo thupisong ya Sejuta? ");
INSERT INTO tsn_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ee, go nna Mojuta go na le dithuso di le dintsi. Santlha Modimo o ne wa ba neela melao ya one ka go ba ikanya gore ba tle ba itse mme ba dire go rata ga one. ");
INSERT INTO tsn_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Boammaaruri ke gore, bangwe ba bone ba ne ba sa ikanyege, mme fela ka ntlha ya gore ba ne ba senya ditsholofetso tsa bone mo Modimong, a seo se raya gore Modimo o tlaa senya ditsholofetso tsa one? ");
INSERT INTO tsn_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ga go a nna jalo! Le fa batho mo lefatsheng e le baaki, Modimo one ga o a nna jalo. A o gakologelwa se se buiwang ke lokwalo lwa Dipesalema kaga selo se? Gore mafoko a Modimo a tlaa aga a supega a le boammaaruri a bile a siame, ga gore sepe gore mongwe o a ganetsa. ");
INSERT INTO tsn_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Mme bangwe ba re, “Mme go senya tumelo ya rona mo Modimong go siame, tsa rona dibe di bontsha tshiamo, gonne batho ba tlaa lemoga gore Modimo o siame thata jang fa ba bona ka fa re leng maswe ka teng. A go siame jaanong, gore o re otlhae fa dibe tsa rona di o thusa?” (Ke ka fa batho bangwe ba buang ka teng.) ");
INSERT INTO tsn_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Modimo o a gana wa re a go se tualo! Gonne e ne e tlaa bo e le Modimo o o ntseng jang, fa o tlodisa sebe matlho? O ne o ka atlhola le fa e le mang jang? ");
INSERT INTO tsn_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Gonne o ne o ka seka wa ntshekisa wa bo wa nkatlhola ke le moleofi fa go tlhoka go ikanyega ga me go ne go o leretse kgalalelo ka go supa go ikanyega ga one fa go tshwantshanngwa le maaka a me. ");
INSERT INTO tsn_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Fa o tsweletse ka mogopolo o o reng: Modimo o itumela fa re le baleofi! Katlholo e go emetse wena yo o buang dilo tse di ntsengjaana. Legale bangwe ba re ke sone se ke se rutang se! ");
INSERT INTO tsn_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Jalo he, a rona Bajuta re botoka go na le ba bangwe? Nnyaa, le goka, gonne re setse re supile gore batho botlhe ke baleofi ka go tshwana, a e ka ne e le Bajuta kgotsa Badichaba. ");
INSERT INTO tsn_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Jaaka dikwalo di bua, “Ga go na ope yo o siameng, ga go na ope mo lefatsheng lotlhe yo o senang molato.” ");
INSERT INTO tsn_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ga go na le fa e le ope yo o kileng a tsamaya sentle mo ditseleng tsa Modimo, kgotsa le fa e le go batla go tsamaya mo go tsone ka boammaaruri. ");
INSERT INTO tsn_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Botlhe ba leofile ba fapogile. Ga go na ope le fa e le kae yo o tsweletseng pele a dira se se siameng; le fa e le a le mongwe. ");
INSERT INTO tsn_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Dipuo tsa bone di leswe ebile di bosula jaaka monkgo wa sebodu o o tswang mo phupung e e atlhameng. Diteme tsa bone di tletse maaka. Sengwe le sengwe se ba se buang se na le lobolela le botlhole jwa dinoga tse di bolayang. ");
INSERT INTO tsn_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Melomo ya bone e tletse thogakano le bogalaka. ");
INSERT INTO tsn_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Ba bofefo go bolaya, ba ila le fa e le mang yo o sa dumalaneng le bone. ");
INSERT INTO tsn_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Gongwe le gongwe kwa ba yang teng ba tlogela tshotlego le matshwenyego kwa morago, ");
INSERT INTO tsn_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","le gone ga ba ise ba ke ba itse tsela ya kagiso le fa e le go akola masego a Modimo. ");
INSERT INTO tsn_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Ga ba boife sepe kaga Modimo le fa e le se Modimo o se gopolang kaga bone. ");
INSERT INTO tsn_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Jalo tshegetsa melao ya Modimo mo boemong jwa go dira dilo tse tsotlhe tse di bosula; ga go na le fa e le ope wa bone yo o nang le seipato; ka boammaaruri lefatshe lotlhe le didimetse ebile le molato fa pele ga Modimo Mothatayotlhe. ");
INSERT INTO tsn_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Jaanong a lo lemoga sentle? Ga go na le fa e le ope yo o ka siamisiwang mo ponong ya Modimo ka go dira se molao o se laolang. Gonne fa re ntse re tswelela ka go itse melao ya Modimo, re simolola go lemoga sentle gore ga re e obamele; melao ya one e dira gore re bone gore re baleofi. ");
INSERT INTO tsn_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","22","Mme jaanong Modimo o re supegeditse tsela e sele ya go ya kwa legodimong, e seng “ka go siama ga rona” le go leka go tshegetsa melao ya one, mme e leng ka tsela e ncha (lefa go ntse jalo tota ga e ncha, gonne dikwalo ga di bolo go bolela ka ga yone bogologolo). Jaanong Modimo wa re o tlaa re amogela o bo o re golola, o re supa “re se molato” fa re ikanya Jesu go tlosa dibe tsa rona. Mme le rona rotlhe re ka bolokwa mo go yone tsela e, ka go tla kwa go Keresete, ga gore sepe gore re bomang kgotsa gore ra re re ntse jang. ");
INSERT INTO tsn_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Ee, botlhe ba leofile; botlhe ba tlhaela kgalaletso ya Modimo; ");
INSERT INTO tsn_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","mme le fa go ntse jalo Modimo o re supa “re se molato” wa go o leofela fa re ikanya mo go Jesu Keresete, yo mo bopelonoming jwa gagwe o tlosang dibe tsa rona kwa ntle ga tuelo epe. ");
INSERT INTO tsn_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Gonne Modimo o rometse Jesu Keresete go tlosa kwatlhao ya rona ka ntlha ya dibe tsa rona, le go fedisa bogale jotlhe jwa Modimo jo bo re okameng. Modimo o dirisitse madi a ga Keresete le tumelo ya rona e le tsela ya go re boloka mo bogaleng jwa one. Ka yone tsela e, o ne wa supa tshiamo ya one o sa patike ope, le fa o ise o ke o otlhae ba ba neng ba leofa mo metlheng ya pele. Gonne o ne o lebetse kwa pele nako e Keresete o neng a tlaa tla ka yone go tlosa dibe tseo tsotlhe. ");
INSERT INTO tsn_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Mme jaanong le mo malatsing ano, o ka amogela baleofi ka yone tsela e, gonne Jesu o tlositse dibe tsa bone. A mme tota golo mo go siame gore Modimo o golole badira bosula, mme o bo o re ga ba na le fa e le molato ope? Nnyaa, gonne o go dira ka go ikanya ga bone mo go Jesu yo o tlositseng dibe tsa bone. ");
INSERT INTO tsn_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Mme re ka ipelafatsa ka go dira eng gore re bone poloko? Ga go sepe gotlhelele. Ka go reng? Gonne kgololo ya rona ga e a ikaega mo ditirong tsa rona tse di molemo; e ikaegile mo go se Keresete o se dirileng, le tumelo ya rona mo go ene. ");
INSERT INTO tsn_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Jalo go raya gore re bolokwa ka tumelo ya rona mo go Keresete e seng ka ditiro tse di molemo tse re di dirang. ");
INSERT INTO tsn_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","A mme Modimo o boloka Bajuta fela ka yone tsela e? Nnyaa, le Badichaba ba ka tla kwa go ene ka yone tsela e. ");
INSERT INTO tsn_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Modimo o re tsaya fela ka go tshwana; botlhe fela, a e ka ne e le Bajuta kgotsa Badichaba, ba a gololwa fa ba na le tumelo. ");
INSERT INTO tsn_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Mme jalo he, fa re bolokwa ka tumelo, a mo go raya gore ga re sa tlhole re tlhokana le go obamela melao ya Modimo? Nnyaa ga go a nna jalo! Tota fela fa re ikanya Jesu ke gone re ka o obamelang ka boammaaruri. ");
INSERT INTO tsn_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","2","Aberahame fa re bua ka fa nameng, re ka re ke mosimolodi wa sechaba sa Sejuta. Maitemogelo a gagwe kaga potso e ya go bolokwa ka tumelo e ne e le eng? A Modimo o ne wa mo amogela ka ntlha ya ditiro tsa gagwe tse di molemo? Fa e le gore go ntse jalo, o ne a ka nna le sengwe se a ipelafatsang ka sone. Mme mo mogopolong wa Modimo, Aberahame o ne a sena sepe se a ka ipelafatsang ka sone. ");
INSERT INTO tsn_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Gonne dikwalo di re bolelela gore Aberahame o ne a dumela Modimo, mme ke sone se Modimo o neng wa phimola dibe tsa gagwe wa mo supa gore “ga a na molato”. ");
INSERT INTO tsn_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","5","A mme ga a a ka a bona tshwanelo ya gagwe go ya kwa legodimong ka ntlha ya dilo tsotlhe tse di molemo tse a di dirileng? Nnyaa, gonne go bolokwa, ke mpho; fa e le gore motho o ne a ka e bona ka go e fufulela, mme e ne e ka seka ya nna mpho fela ntswa tota e le mpho fela! E newa ba ba sa e fufuleleng: Gonne Modimo o supa baleofi ba le molemo mo ponong ya one fa ba na le tumelo mo go Keresete go ba boloka mo bogaleng jwa Modimo. ");
INSERT INTO tsn_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Kgosi Dafide o buile ka sone selo se, fa a tlhalosa boitumelo jwa moleofi yo o neng a sa bo tshwanela pele ga a supiwa a “sena molato” ke Modimo. ");
INSERT INTO tsn_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","O ne a re, “Go sego ba ba itshwaretsweng dibe ebile di tlositswe mo matlhong a bone. ");
INSERT INTO tsn_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Ee, go boitumelo thata jang mo mothong yo dibe tsa gagwe a sa tlholeng a di balelwa ke Morena.” ");
INSERT INTO tsn_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Jaanong he, potso ke gore: A lesego le le neelwa fela ba ba dumelang mo go Keresete ebile ba boloka melao ya Sejuta, kgotsa le neelwa le ba ba sa bolokeng melao ya Sejuta, mme ba ikanya Keresete fela. Mme he, ra reng kaga Aberahame? Ra re o amogetse masego a ka tumelo ya gagwe. A e ne e le ka tumelo fela? Kgotsa a e ne e le ka ntlha ya gore le ene o ne a boloka melao ya Sejuta? ");
INSERT INTO tsn_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Mo go arabeng potso eo, arabang e: Modimo o neetse Aberahame masego a leng? O a mo neetse pele ga a nna Mojuta, pele ga a tsena mo modirong wa thupiso ya Sejuta. ");
INSERT INTO tsn_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Erile Modimo o sena go solofetsa go mo segofatsa ka ntlha ya tumelo ya gagwe, a rupisiwa. Sekao sa thupiso e ne e le sesupo sa gore Aberahame o ne a setse a na le tumelo le gore Modimo o ne o setse o mo amogetse o mo supile fa a le tshiamo mo ponong ya one pele ga modiro wa thupiso o diragala. Jalo Aberahame ke rara wa semowa wa ba ba dumelang mme ba bolokwa kwa ntle ga go tshegetsa melao ya Sejuta. Re a bona, jaanong gore ba ba sa tshegetseng melao e, ba siamisiwa ke Modimo ka tumelo. ");
INSERT INTO tsn_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Gape Aberahame ke rara wa semowa wa Bajuta ba ba rupisitsweng, gonne Aberahame o ne a bona kutlwelo botlhoko ya Modimo ka ntlha ya tumelo fela, pele ga a rupisiwa. ");
INSERT INTO tsn_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Jaanong go bonala sentle gore tsholofetso e Modimo o neng wa e naya Aberahame ya gore o tlaa mo naya lefatshe lotlhe mmogo le losika lwa gagwe, e ne e se ka ntlha ya gore Aberahame o ne a tshegetsa melao ya Modimo, mme e ne e le ka ntlha ya gore o ne a ikanya Modimo gore o tlaa diragatsa tsholofetso ya one. ");
INSERT INTO tsn_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Mme fa e le gore o sa ntse o re masego a Modimo a ya kwa go ba ba “siameng thata” mme o raya gore ditsholofetso tsa Modimo mo go ba ba nang le tumelo ga di reye sepe, ebile tumelo ke boeleele. ");
INSERT INTO tsn_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Mme boammaaruri ke gore: Fa re leka go nna le lesego le poloko ya Modimo ka go boloka melao ya one re aga re felela mo bogaleng jwa one, gonne re palelwa ke go e tshegetsa malatsi otlhe. Tsela e nngwe fela e re ka ipabalelang ka yone gore re seka ra tlola melao, ke ya gore go seka ga bewa melao, e se re kgotsa ra e tlola. ");
INSERT INTO tsn_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Jalo masego a Modimo re a newa ka tumelo, e le neo fela; re tlhomamisa go nna le one re sala morago ngwao ya Sejuta kgotsa re sa e sale morago fa re na le tumelo e e tshwanang le ya ga Aberahame, gonne Aberahame ke rraa rona rotlhe fa go tla mo dilong tse tsa tumelo. ");
INSERT INTO tsn_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Ke sone se dikwalo di se rayang fa di re Modimo o dirile Aberahame rara wa dichaba tse dintsi. Modimo o tlaa amogela batho botlhe mo dichabeng tsotlhe ba ba o ikanyang jaaka Aberahame a ne a dira. Mme tsholofetso e, e tswa mo Modimong ka bo one, o o dirang gore baswi ba tshele gape, ebile o bua ka ditiragalo tsa malatsi a a tlang ka tlhomamiso e e gagametseng jaaka o ka re di setse di bile di diragetse! ");
INSERT INTO tsn_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Jalo erile fa Modimo o raya Aberahame o re o tlaa mo naya ngwana wa mosimane yo o tlaa nnang ra-merafe e mentsi e bo e nna chaba e tona, Aberahame o ne a dumela Modimo le fa tsholofetso e e ntseng jalo e ne e ka seka ya diragala! ");
INSERT INTO tsn_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Mme ka ntlha ya gore tumelo ya gagwe e ne e nonofile, o ne a seka a tshwenyega kaga lobaka lwa gore o ne a tsofetse thata go ka nna motsadi, ka nako eo o ne a le dingwaga di le lekgolo, le ene Sara mosadi wa gagwe o ne a le dingwaga di le masome a fera bongwe, a tsofetse thata go ka nna le ngwana. ");
INSERT INTO tsn_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Mme Aberahame ga a ise a ke a belaele. O ne a dumela Modimo, gonne tumelo ya gagwe le tshepo di ne di nonofile, mme o ne a galaletsa Modimo, ka masego a, le pele ga a diragala. ");
INSERT INTO tsn_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","O ne a tlhomamisa thata gore Modimo o ne o kgona sentle go dira le fa e le eng se o se solofeditseng. ");
INSERT INTO tsn_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Mme ka ntlha ya tumelo ya ga Aberahame Modimo o ne wa mo itshwarela dibe wa mo supa “a sena molato.” ");
INSERT INTO tsn_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Jaanong polelo e ntle e, ya gore o ne a amogelwa a bo a letlelesega ka tumelo ya gagwe, e ne e sa solegele Aberahame molemo a le nosi. ");
INSERT INTO tsn_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Le rona e ne e le ya rona, e re tlhomamisetsa gore Modimo o tlaa re amogela ka yone tsela e o amogetseng Aberahame ka yone, fa re dumela ditsholofetso tsa Modimo o o tsositseng Jesu Morena wa rona mo baswing. ");
INSERT INTO tsn_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","O swetse dibe tsa rona mme a tsoga gape go re siamisa mo Modimong a re tlatsa ka tshiamo ya Modimo. ");
INSERT INTO tsn_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Mme jaanong, ka re siamisitswe mo ponong ya Modimo ka tumelo mo ditsholofetsong tsa one, re ka nna le kagiso mo go one ka ntlha ya se Jesu Keresete Morena wa rona o se re diretseng. ");
INSERT INTO tsn_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Gonne ka ntlha ya tumelo ya rona, o re beile mo lefelong le le nang le tshwanelo e e kwa godimo fa re leng teng jaanong, mme re lebeletse ka tshepo le ka boitumelo go nna se tota Modimo o neng o gopotse gore re nne sone. ");
INSERT INTO tsn_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Le rona re ka itumela, fa re tsena mo matha-teng le mo melekong gonne re itse gore mathata a re siametse, a re thusa go ithuta go nna pelotelele. ");
INSERT INTO tsn_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Mme bopelotelele bo tlhogisa boitshwaro jo bo nonofileng mo go rona, ebile bo re thusa go ikanya Modimo thata mo nakong nngwe le nngwe fa re bo dirisa go fitlhelela lwa bofelo tsholofelo ya rona le tumelo di nonofa di bo di dira ka boiketlo le kelotlhoko di sa reketle. ");
INSERT INTO tsn_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Mme fa moo go diragala, re kgona go ema re nitame, ga go re sepe gore go diragala eng ebile re itse gore gotlhe go siame, gonne re itse ka fa Modimo o re ratang ka teng, ebile re utlwa lorato lo lo tukang gongwe le gongwe mo go rona gonne Modimo o re neile Mowa O O Boitshepo go tlatsa dipelo tsa rona ka lorato lwa one. ");
INSERT INTO tsn_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","E rile re sa kgone go ithusa gotlhelele go se na letshoba la go falola, Jesu a tla ka nako e e tshwa-netseng mme a re swela rona baleofi ba re neng re sena molemo mo go ene. ");
INSERT INTO tsn_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Le fa tota re ne re siame, re ne re se ka ke ra solofela ope go re swela, lefa go ntse jalo, go re swela go ne go ka kgonega. ");
INSERT INTO tsn_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Mme Modimo o ne wa supa lorato lwa one lo logolo mo go rona ka go romela Keresete go tla go re swela fa re ne re sa ntse 