﻿USE sofia;
DROP TABLE IF EXISTS sofia.tsg_vpl;
CREATE TABLE tsg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tsg_vpl WRITE;
INSERT INTO tsg_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Manjari, amu ini in usulan sin pangkat hi Īsa Almasi, hambuuk panubuꞌ hi Daud, amu in hambuuk panubuꞌ hi Ibrahim. ");
INSERT INTO tsg_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","6","Biyaꞌ ha ini in pangkat hi Īsa Almasi tagnaan dayn kan Ibrahim sampay naabut mawn kan Sultan Daud. Hi Ibrahim, in anak niya hi Isahak; in hi Isahak, in anak niya hi Yaꞌkub; in hi Yaꞌkub, in anak niya hi Yudah iban sin manga taymanghud niya. Sakali in anak sin Yudah hi Piris kay Sira (in inaꞌ nila hi Tamar). In hi Piris, in anak niya hi Hisdun; in hi Hisdun, in anak niya hi Aram; in hi Aram, in anak niya hi Amminadab; in hi Amminadab, in anak niya hi Nassun; in hi Nassun, in anak niya hi Salmun; in hi Salmun, in anak niya hi Buwas (in inaꞌ hi Buwas hi Rahab); in hi Buwas, in anak niya hi Ubid (in inaꞌ hi Ubid hi Rut); in hi Ubid, in anak niya hi Jissi; in hi Jissi, in anak niya hi Sultan Daud. ");
INSERT INTO tsg_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","11","Na, biyaꞌ ha ini isab in usulan sin pangkat hi Īsa tagnaan dayn kan Sultan Daud sampay pa waktu narā in manga tau Israil pa hulaꞌ Babilun ha bukun nila kabayaan. In hi Daud, in anak niya hi Sulayman (in inaꞌ hi Sulayman amuna in bakas asawa hi Uriyas); in hi Sulayman, in anak niya hi Rubuwam; in hi Rubuwam, in anak niya hi Abiyas; in hi Abiyas, in anak niya hi Asa; in hi Asa, in anak niya hi Jusapat; in hi Jusapat, in anak niya hi Jihuram; in hi Jihuram, in anak niya hi Usiyas; in hi Usiyas, in anak niya hi Jutam; in hi Jutam, in anak niya hi Ahas; in hi Ahas, in anak niya hi Hijikiyas; in hi Hijikiyas, in anak niya hi Manassi; in hi Manassi, in anak niya hi Amun; in hi Amun, in anak niya hi Jusiyas; in hi Jusiyas, in anak niya hi Jihuyakin iban sin manga taymanghud niya. ");
INSERT INTO tsg_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Hāti dayn na waktu narā in manga tau Israil pa hulaꞌ Babilun sampay pa waktu piyagꞌanak hi Īsa, biyaꞌ ha ini isab in usulan sin pangkat niya. In hi Jihuyakin, in anak niya hi Salati; in hi Salati, in anak niya hi Sirubbabil; in hi Sirubbabil, in anak niya hi Abiyud; in hi Abiyud, in anak niya hi Iliyakim; in hi Iliyakim, in anak niya hi Asur; in hi Asur, in anak niya hi Saduk; in hi Saduk, in anak niya hi Akim; in hi Akim, in anak niya hi Iliud; in hi Iliud, in anak niya hi Iliyasar; in hi Iliyasar, in anak niya hi Mattan; in hi Mattan, in anak niya hi Yaꞌkub; in hi Yaꞌkub, in anak niya hi Yusup. Hi Yusup amuna in nakaasawa kan Mariyam inaꞌ hi Īsa, amu in pagꞌiyanun Almasi. ");
INSERT INTO tsg_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Na, manjari awn hangpuꞌ tagꞌupat pangkat in nanubuꞌ tagnaan dayn kan Ibrahim sampay naabut mawn kan Daud. Hāti tagnaan dayn kan Daud sampay pa waktu narā in manga tau Israil pa hulaꞌ Babilun awn isab hangpuꞌ tagꞌupat pangkat in nanubuꞌ. Hāti awn isab hangpuꞌ tagꞌupat pangkat in nanubuꞌ dayn ha waktu narā in manga tau Israil pa hulaꞌ Babilun sampay naabut piyagꞌanak in Almasi. ");
INSERT INTO tsg_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Biyaꞌ ha ini in kahālan sin pagꞌanak kan Īsa Almasi. In hi Mariyam, inaꞌ niya, saꞌbu nagtutunang iban hi Yusup, sagawaꞌ ha walaꞌ pa sila nakapagtiyaun kiyananaman niya sin burus siya dayn ha kusug sin kudarat sin Rū sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","In hi Yusup ini hambuuk tau miyamagad sadja ha daakan sin Tuhan. Pagga niya kiyaingatan sin burus hi Mariyam napikil niya baybarun na in pagtunang nila, sagawaꞌ diꞌ niya hibukag in sabab sin pagbaybad nila, ha supaya diꞌ sumipug hi Mariyam. ");
INSERT INTO tsg_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sakali ha saꞌbu hi Yusup namimikil sin pasal ini, nakalipat siya sartaꞌ nanagainup siya. Ha lawm tagainup niya nagpanyataꞌ mawn kaniya in hambuuk malāikat naraak sin Tuhan. Namung in malāikat, amu agi, “Yusup, hambuuk panubuꞌ hi Daud, ayaw kaw mahanggaw umasawa kan Mariyam. Karnaꞌ in siya yan naburus dayn ha kusug sin kudarat sin Rū sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Umanak siya hambuuk bataꞌ-bataꞌ usug iban ngānan mu in bataꞌ-bataꞌ yan hi Īsa, sabab siya na yan in manglappas ha tau niya dayn ha manga dusa nila.” (Amu yadtu in pamung kaniya sin malāikat.) ");
INSERT INTO tsg_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Na, nabunnal in kiyabaytaꞌ sin Tuhan amu in kiyasulat nakauna hi Nabi Isayas ha lawm Kitab, amu agi, ");
INSERT INTO tsg_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ha susūngun awn hambuuk budjang magburus iban magꞌanak siya hambuuk bataꞌ-bataꞌ usug. In bataꞌ-bataꞌ usug ini amuna in pagtawagun Immanwil.” (In hāti sin Immanwil, “Yari in Tuhan limamud kātuꞌniyu.”) ");
INSERT INTO tsg_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Na, pagbatiꞌ hi Yusup iyagad niya in baytaꞌ sin malāikat kaniya. Tiyaunan niya na hi Mariyam. ");
INSERT INTO tsg_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Sumagawaꞌ walaꞌ siya naghulid kay Mariyam ha salugay walaꞌ pa siya nagꞌanak. Pagꞌanak hi Mariyam, ngiyānan hi Yusup in bataꞌ-bataꞌ usug hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Manjari in hi Īsa piyagꞌanak duun ha kawman sin Baytlaham, ha hulaꞌ Yahudiya, ha waktu sin pagsultan hi Sultan Hirud. Bukun mawgay awn dimatung manga tau dayn ha subangan mawn pa Awrusalam (Baytal Makdis). In manga tau ini ilmuan, amu in nangangadjiꞌ pasal sin manga bituun ha langit. ");
INSERT INTO tsg_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pagdatung nila pa Awrusalam (Baytal Makdis), magtūy sila nangasubu, laung nila, “Ha unu in sultan sin manga bangsa Yahudi amu in baꞌgu piyagꞌanak? Kītaꞌ namuꞌ gimuwaꞌ dayn ha subangan in bituun amu in tandaꞌ sin piyagꞌanak na siya. Hangkan miyari kami mamudji kaniya.” ");
INSERT INTO tsg_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pagdungug hi Sultan Hirud sin pasal ini miyugaꞌ tuud siya sambil da isab sin katān tau ha Awrusalam (Baytal Makdis). ");
INSERT INTO tsg_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Piyatawag hi Sultan Hirud in katān manga nakuraꞌ kaimaman iban sin manga guru saraꞌ agama. Pagꞌubus ampa niya sila iyasubu, laung niya, “Ha unu hipagꞌanak in Almasi?” ");
INSERT INTO tsg_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","In sambung nila, “Didtu ha Baytlaham, ha hulaꞌ Yahudiya, karnaꞌ in yan kiyabaytaꞌ hi Nabi (Mikas) ha lawm Kitab, amu agi, ");
INSERT INTO tsg_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Kamu manga tau ha kawman Baytlaham ha hulaꞌ Yahudiya, minsan in kawman niyu asibiꞌ, in kamu, tau mataas, sabab awn gumuwaꞌ dayn kaniyu hambuuk nakuraꞌ amu in magꞌiipat ha manga tau ku, amu in bangsa Israil biyaꞌ sapantun tau magꞌiipat bili-bili.’” (Amu yan in kiyasulat sin nabi ha lawm Kitab.) ");
INSERT INTO tsg_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pagdungug hi Hirud sin bihādtu, magtūy niya piyakawaꞌ in manga bisita dayn ha subangan dāhun niya magbichara ha wayruun makaingat tau dugaing. Pagdatung nila mawn, iyasubu sila hi Hirud bang kaꞌnu nila tuud tagnaꞌ kītaꞌ in bituun. Sakali kiyabaytaan mayan siya sin manga bisita, ");
INSERT INTO tsg_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","piyakadtu niya sila pa Baytlaham iban laung niya kanila, “Kadtu kamu iban lawaga niyu marayaw in bataꞌ-bataꞌ. Iban bang niyu siya kabaakan na, balik kamu magtūy, baytai niyu aku bat isab aku makakadtu mamudji kaniya.” ");
INSERT INTO tsg_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Pagꞌubus sin sultan nagbichara, miyanaw na in manga tau dayn ha subangan. Ha saꞌbu pa sila miyamanaw, kītaꞌ nila isab nagbalik in bituun amu in bakas kītaꞌ nila didtu ha hulaꞌ nila ha subangan. Pagkitaꞌ nila, landuꞌ tuud sila kiyūgan. Miyanaw in bituun ha unahan nila ampa himundung ha lugal kiyabubutangan sin bataꞌ-bataꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Simūd sila pa lawm bāy. Pagsūd nila, kītaꞌ nila in bataꞌ-bataꞌ iban sin inaꞌ niya hi Mariyam. Simujud sila ampa nila piyudji in bataꞌ-bataꞌ. Iyukab nila na in manga darāhan nila iban piyanghulmat nila na mawn pa bataꞌ-bataꞌ in bulawan, kamanyan, iban ubat mahalgaꞌ pagtawagun “mira”. ");
INSERT INTO tsg_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na, ha sūng nila muwiꞌ pa hulaꞌ nila, limabay sila dayn ha dugaing dān sabab asal sila biyandaan sin Tuhan ha lawm tagainup nila, diꞌ sila pabalikun madtu kan Hirud. ");
INSERT INTO tsg_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pagꞌīg nila, awn hambuuk malāikat diyaak sin Tuhan nagpakitaꞌ mawn kan Yusup ha lawm tagainup niya. Namung in malāikat kaniya, amu agi, “Bangun kaw ampa mu dāha in bataꞌ-bataꞌ iban sin inaꞌ niya maguy pa hulaꞌ Misir, iban ayaw kamu mīg dayn didtu ha salugay diꞌ ta kamu baytaan paīgun. Karnaꞌ in bataꞌ-bataꞌ yan hipalawag hi Hirud hipapatay.” ");
INSERT INTO tsg_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Magtūy hi Yusup nagbangun. Sin dūm da yadtu diyā niya magtūy in bataꞌ-bataꞌ iban sin inaꞌ pa hulaꞌ Misir. ");
INSERT INTO tsg_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Duun na sila himulaꞌ ha Misir sampay miyatay hi Hirud. Na, dayn duun nabunnal in baytaꞌ sin Tuhan kiyabaytaꞌ hi Nabi (Husiyas), amu agi, “Piyauwiꞌ ku in Anak ku dayn ha hulaꞌ Misir.” ");
INSERT INTO tsg_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Manjari ha waktu buhiꞌ pa hi Sultan Hirud, pagꞌingat niya sin iyakkalan siya sin manga tau ilmuan nanibaw dayn ha subangan, diyugalan tuud siya. Magtūy siya nagdaak hipapatay in katān bataꞌ-bataꞌ usug ha kawman Baytlaham sampay pa manga dugaing kawman ha pangdaig niya, dayn ha umul duwa tahun sampay pa manga baꞌgu piyagꞌanak sabab giyantaꞌ niya na dayn ha pagbaytaꞌ sin manga tau dayn ha subangan, bang kaꞌnu nila tagnaꞌ kītaꞌ in bituun. ");
INSERT INTO tsg_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Na, nabunnal tuud in bakas bichara hi Nabi Irmiyas, laung niya, ");
INSERT INTO tsg_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Karungugan in tingug ha dāira Rama, tingug sin pagtangis iban pagsilawak. Duun in manga panubuꞌ hi Rakiya nagmamatay ha manga anak nila. Diꞌ sila mabayaꞌ ūūhun sabab miyatay in manga anak nila.” ");
INSERT INTO tsg_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Manjari miyatay mayan hi Hirud, nagpakitaꞌ na isab nagbalik in malāikat diyaak sin Tuhan mawn kan Yusup ha lawm tagainup, duun ha hulaꞌ Misir. ");
INSERT INTO tsg_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Amu agi sin malāikat, “Bangun kaw ampa mu dāha in bataꞌ-bataꞌ iban inaꞌ niya magbalik pa hulaꞌ Israil, sabab in manga tau amu in mabayaꞌ mamatay ha bataꞌ-bataꞌ miyatay na.” (Na, amu yadtu in pamung sin malāikat kan Yusup.) ");
INSERT INTO tsg_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Pagbangun hi Yusup, magtūy niya diyā in bataꞌ-bataꞌ iban sin inaꞌ nagbalik pa hulaꞌ Israil. ");
INSERT INTO tsg_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Sagawaꞌ, pagdungug hi Yusup sin hi Arkilas in nakagantiꞌ nagsultan ha amaꞌ niya hi Hirud ha hulaꞌ Yahudiya, miyugaꞌ hi Yusup magbalik madtu. Hangkan himarap sila madtu pa hulaꞌ Jalil, karnaꞌ biyaꞌ da isab ha yan in baytaꞌ kaniya ha lawm tagainup niya. ");
INSERT INTO tsg_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Pagdatung nila pa hulaꞌ Jalil, duun sila himulaꞌ ha kawman Nasarit. Na, nabunnal tuud isab in baytaꞌ sin manga kanabihan pasal hi Īsa Almasi, laung nila, “In siya tawagun hambuuk tau Nasarit.” ");
INSERT INTO tsg_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Manjari ha waktu yadtu hi Yahiya amu in Mangliliguꞌ miyawn nagnasīhat pa hulaꞌ Yahudiya, duun ha hulaꞌ paslangan mahunit paghulaan. ");
INSERT INTO tsg_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Laung niya ha manga tau, “Pagtawbati niyu na in manga dusa niyu sabab masuuk na dumatung mari in pamarinta sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Bang paamuhun, hi Yahiya ini amuna in tau piyagꞌiyan hi Nabi Isayas, laung niya, “Awn hambuuk tau ha lawm hulaꞌ paslangan mahunit paghulaan. Manawag-tawag siya ha manga tau, amu agi niya, ‘Parayawa niyu iban pabuntula niyu in dān sabab masuuk na lumabay in Panghuꞌ.’ ” ");
INSERT INTO tsg_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","In tamungun hi Yahiya ini hīnang dayn ha bulbul untaꞌ iban nagsasabitan siya pais sapiꞌ, iban in pagkaunun niya hambuuk ginis sin ampan dulu iban gulaꞌ pussukan. ");
INSERT INTO tsg_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Na, miyawn in manga tau dayn ha Awrusalam (Baytal Makdis) iban dayn ha katilingkal sin hulaꞌ Yahudiya iban na dayn ha katān hulaꞌ ha katilibut sin Subaꞌ Jurdan dimungug kan Yahiya. ");
INSERT INTO tsg_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Miyawn sila kaniya nagsabunnal sin manga dusa nila, iban nagpaliguꞌ na sila kan Yahiya duun ha Subaꞌ Jurdan. ");
INSERT INTO tsg_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Sagawaꞌ pagkitaꞌ hi Yahiya mataud manga tau agad ha parhimpunan sin Parisi iban agad ha parhimpunan sin Sadduki in miyawn kaniya nagpaliguꞌ, laung niya kanila, “In kamu yan panipu! Magpabawꞌ-bawꞌ sadja kamu mabuntul, sagawaꞌ bingkuk in lawm atay niyu. Na, in pangannal niyu makapuas kamu dayn ha murkaꞌ sin Tuhan amu in masuuk na dumatung bang kamu magpaliguꞌ? ");
INSERT INTO tsg_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bang kamu diꞌ tuud mabayaꞌ pagmurkaan sin Tuhan pakitaan niyu dayn ha kawl-piil niyu marayaw sin piyagtawbatan niyu na tuud in manga dusa niyu. ");
INSERT INTO tsg_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ayaw kamu magpikil sin diꞌ kamu kugdanan sin murkaꞌ sin Tuhan sawkat kamu panubuꞌ hi Ibrahim sabab baytaan ta kamu, minsan in manga batu ini mapapanjari sin Tuhan tau, hinangun panubuꞌ hi Ibrahim higantiꞌ kaniyu. ");
INSERT INTO tsg_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","In kamu yan biyaꞌ sapantun kahuy masuuk na pilaun sin kapa, tibtibun dayn ha gamut niya. Na sasukuꞌ sin kahuy amu in diꞌ magbunga marayaw tantu pilaun da ampa hilaruk pa lawm kāyu. ");
INSERT INTO tsg_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“In aku ini mangliguꞌ kaniyu sin tubig ha supaya awn tandaꞌ sin piyagtawbatan niyu na in manga dusa niyu. Sagawaꞌ awn hambuuk sumunud kākuꞌ dumatung mari labi mataas dayn kākuꞌ. Diꞌ aku minsan tūpun dumā sin tawmpaꞌ niya. Siya yan in magpatulun sin Rū sin Tuhan pa kaibanan tau amu in biyaꞌ sapantun hipangliguꞌ kanila, iban siya da isab in magparatung murkaꞌ pa kaibanan. ");
INSERT INTO tsg_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Biyaꞌ siya sin hambuuk tau magtahap iban maghawan sin pāy bakas piyaggiikan niya. Pagꞌubus ampa niya hitawꞌ in unud ha pagtatawꞌan niya. Hāti in apa iban sin manga kaput, hilaruk pa lawm kāyu diꞌ magkapūng kasaumulan.” ");
INSERT INTO tsg_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Manjari ha waktu yadtu nākawn hi Īsa pa Subaꞌ Jurdan dayn ha hulaꞌ Jalil. Miyawn siya nagpaliguꞌ kan Yahiya. ");
INSERT INTO tsg_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Sagawaꞌ diꞌ mabayaꞌ hi Yahiya mangliguꞌ kaniya. Laung hi Yahiya “Tuwan, maytaꞌ ikaw pa in mari kākuꞌ magpaliguꞌ? Gām mayan subay aku in liguun mu.” ");
INSERT INTO tsg_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Sagawaꞌ in sambung hi Īsa kaniya, “Kadtui na. Ligua na aku bihaun. Matūp da kaw mangliguꞌ kākuꞌ ha supaya maagad katān in kabayaan sin Tuhan.” Na, timaayun na hi Yahiya. Līguꞌ na hi Yahiya hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Naubus mayan siya līguꞌ, minīg na siya dayn ha tubig. Pagꞌīg niya, magtūy naukab in lawang langit. Kītaꞌ niya in Rū sin Tuhan nagpasalupa assang nanaug dayn ha langit ampa timapuꞌ mawn kaniya. ");
INSERT INTO tsg_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Pagꞌubus awn nagsuwara dayn ha langit, amu agi, “Amuna ini in Anak ku kalasahan ku. Siya in makasulut tuud kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Manjari diyā timukad hi Īsa sin Rū sin Tuhan madtu pa hulaꞌ paslangan mahunit paghulaan. Hangkan siya diyā madtu, ha supaya siya sasatun sin Iblis. ");
INSERT INTO tsg_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ha lawm sin kaꞌpatan adlaw iban kaꞌpatan dūm wayruun hangsulag kakaun in nakaun niya. Na, pagꞌubus yadtu hiyapdiꞌ na siya. ");
INSERT INTO tsg_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sakali kiyawn na tuud siya sin Mananasat yaun, amu agi kaniya, “Bang kaw bunnal amuna in Anak Tuhan, daaka in manga batu ini mahinang kakaun.” ");
INSERT INTO tsg_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Sagawaꞌ in sambung hi Īsa, “Kiyasulat ha lawm Kitab in Parman sin Tuhan, amu agi, ‘In mānusiyaꞌ diꞌ mabuhiꞌ sin kakaun sadja, sagawaꞌ in makabuhiꞌ tuud kanila amuna in katān Parman sin Tuhan.’” ");
INSERT INTO tsg_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pagꞌubus yadtu diyā hi Īsa sin Iblis madtu pa Awrusalam (Baytal Makdis) amu in pagtawagun Dāira Suchi, piyasakat pa puntuk sin Bāy sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Na, laung sin Iblis kan Īsa, “Bang kaw bunnal amuna in Anak Tuhan, tugpaꞌ kaw dayn ha taas ini pa babaꞌ, sabab kiyasulat ha lawm Kitab, amu agi, ‘Daakun sin Tuhan in manga malāikat niya magjaga kaymu. Tayakun nila kaw ha supaya in siki mu diꞌ kumugdan pa manga batu.’” ");
INSERT INTO tsg_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Laung hi Īsa kaniya, “Sagawaꞌ kiyasulat da isab ha lawm Kitab, amu agi, ‘Subay niyu diꞌ dustaun in Tuhan, amu in Panghuꞌ niyu.’” ");
INSERT INTO tsg_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pagꞌubus yadtu diyā na isab sin Iblis hi Īsa madtu pa puntuk būd ampa piyakitaꞌ kaniya in katān kahulaꞌ-hulaan ha lawm dunya, amu in hipuꞌ sin katān daya iban kawasa. ");
INSERT INTO tsg_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Laung sin Iblis kan Īsa, “In katān yan hirihil ku kaymu bang kaw sumujud sumumba kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Laung hi Īsa kaniya, “Īg kaw dayn dī, Saytan Puntukan! Kiyasulat ha lawm Kitab, amu agi, ‘Subay hambuuk-buuk Tuhan, Panghuꞌ niyu in sumbahun iban pagtagꞌīpunan niyu.’” ");
INSERT INTO tsg_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pagꞌubus yadtu minīg na in Iblis, amu in Saytan Puntukan. Pagꞌīg niya, miyawn na in manga malāikat timabang kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Manjari diyungug mayan hi Īsa sin najīl hi Yahiya amu in mangliliguꞌ, miyadtu siya pa hulaꞌ Jalil. ");
INSERT INTO tsg_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Walaꞌ na siya himulaꞌ duun ha Nasarit, sagawaꞌ miyadtu siya himulaꞌ pa Kapirnaum, hambuuk kawman ha higad Dagat Jalil ha hulaꞌ Sibulun iban hulaꞌ Naptali. ");
INSERT INTO tsg_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Na, dayn duun nabunnal in kiyabichara hi Nabi Isayas, laung niya, ");
INSERT INTO tsg_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“In hulaꞌ Sibulun iban hulaꞌ Naptali, amu in dapit pa dagat ha hansipak sin Subaꞌ Jurdan, amu in pagtawagun da isab Jalil, amu in paghulaan sin bangsa ginisan! ");
INSERT INTO tsg_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","In manga tau ha manga hulaꞌ yan bakas sila biyaꞌ hantang ha lawm katigidluman, saꞌ makakitaꞌ na sila kasawahan amu in landuꞌ masilak. Bakas sila awam, biyaꞌ sapantun ha lawm katigidluman iban mabugaꞌ sila mapatay, saꞌ bihaun awn na kasawahan sin pamikil nila.” ");
INSERT INTO tsg_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Dayn ha waktu yadtu timagnaꞌ na nagnasīhat hi Īsa. Laung niya ha manga tau, “Pagtawbati niyu na in manga dusa niyu, sabab masuuk na dumatung mari in pamarinta sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Manjari, ha saꞌbu niya miyamanaw ha higad sin dagat pagngānan Dagat Jalil, kītaꞌ niya in duwa magtaymanghud magꞌiistaꞌ, hi Simun amu in pagngānan da isab Pitrus, iban sin taymanghud niya hi Andariyas. Duun in duwa magtaymanghud nanglalaya istaꞌ ha dagat. ");
INSERT INTO tsg_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Laung hi Īsa kanila, “Manga bagay, agad kamu mari kākuꞌ. In piyaghulas-sangsaan niyu bihaun, magꞌistaꞌ, saꞌ hinduan ta kamu bang biyaꞌdiin maghulas-sangsaꞌ dumā ha mānusiyaꞌ pagkahi niyu magad kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Na, saruun-duun biyutawanan nila in laya nila ampa sila miyagad kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Limanjal na sila sin panaw nila. Sakali kītaꞌ hi Īsa in duwa magtaymanghud hi Yaꞌkub kay Yahiya, manga anak hi Sibidi. Yaun sila iban sin amaꞌ nila hi Sibidi ha taas kumpit asibiꞌ nagdarayaw sin laya nila. Tiyawag sila hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Saruun-duun binīn nila in amaꞌ nila iban sin kumpit asibiꞌ, ampa sila miyagad kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Na, liyatag hi Īsa piyanaw in katilibut sin hulaꞌ Jalil. Nanghinduꞌ siya ha manga tau ha manga lawm langgal. Nagnasīhat siya sin Baytaꞌ Marayaw pasal sin pamarinta sin Tuhan iban napauliꞌ niya in indaginis lamma iban sakit sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Na, magtūy natanyag in hinang niya pa katān hulaꞌ ha katilingkal Siriya. Hangkan diyā na mawn kaniya in manga tau imuukuy sin indaginis sakit, siyusūd saytan, biyababuy-babuy iban nagpapatay in baran. In manga tau kiyugdan sin manga sakit ini napauliꞌ hi Īsa katān. ");
INSERT INTO tsg_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Pakain-pakain siya manaw, mataud tuud tau in miyamagad imuurul kaniya, manga tau dayn ha hulaꞌ Jalil, dayn ha hulaꞌ pagtawagun Hangpuꞌ Dāira, dayn ha Awrusalam (Baytal Makdis), dayn ha Yahudiya iban dayn ha hulaꞌ ha hansipak sin Subaꞌ Jurdan. ");
INSERT INTO tsg_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Manjari pagkitaꞌ hi Īsa mataud tau in imuurul kaniya, timukad siya pa taas būd-būd ampa siya limingkud. Paglingkud niya, nagtipun ha katilibut niya in manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Na, timagnaꞌ na siya nagnasīhat, laung niya, ");
INSERT INTO tsg_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Hisiyu-siyu in magkahagad, sin kagunahan niya tuud in tabang sin Tuhan, dakulaꞌ in karayawan niya, sabab ha lawm siya sin pamarinta sin Tuhan! ");
INSERT INTO tsg_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Hisiyu-siyu in magkasusahan sabab sin manga kangīan ha lawm dunya, dakulaꞌ in karayawan niya, sabab tantu tabangun tuud siya sin Tuhan! ");
INSERT INTO tsg_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Hisiyu-siyu in mababaꞌ in pangatayan niya, dakulaꞌ in karayawan niya, sabab mataymaꞌ niya in kiyajanjiꞌ kaniya sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Hisiyu-siyu in mabayaꞌ tuud umādil in atay niya, dakulaꞌ in karayawan niya, sabab dūlan siya sin Tuhan. Umādil siya. ");
INSERT INTO tsg_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Hisiyu-siyu in maluuy ha pagkahi niya, dakulaꞌ in karayawan niya, sabab kaluuyan da isab siya sin Tuhan! ");
INSERT INTO tsg_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Hisiyu-siyu in mabuntul in itikad niya pa Tuhan, dakulaꞌ in karayawan niya, sabab makapagkitaꞌ siya iban Tuhan ha susūngun! ");
INSERT INTO tsg_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Hisiyu-siyu in makapasulut ha pagkahi niya, dakulaꞌ in karayawan niya, sabab simupu siya ha Tuhan, amu in magpasulut ha manga mānusiyaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Hisiyu-siyu in nabibinsanaꞌ pasal sin pagꞌagad niya sin kabayaan sin Tuhan, dakulaꞌ in karayawan niya, sabab in siya ha lawm pamarinta sin Tuhan! ");
INSERT INTO tsg_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“In kamu isab, bang kamu guraꞌ-guraun iban binasahun iban hinangan kamu bichara sin katān ginisan puting sin manga tau sabab miyamagad kamu kākuꞌ, dakulaꞌ in karayawan niyu. ");
INSERT INTO tsg_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pagkūg-kuyag tuud kamu, sabab awn tungbas dakulaꞌ tiyatagama kaniyu didtu ha surgaꞌ. Biyaꞌ da isab ha yan in manga kanabihan sin nakauna yadtu, piyagbinasa sin manga tau pagkahi nila.” ");
INSERT INTO tsg_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Iban laung pa isab hi Īsa, “In manga kamu agad kākuꞌ biyaꞌ kamu sapantun asin amu in makaparayaw sin kahālan sin katān. Karnaꞌ in asin amu in makaparayaw sin kakaun. Sagawaꞌ in asin bang maīg na in kaasin niya way na dapat paasinun magbalik. Wayruun na yan kapūsan niya. Hangkan hibugit na yan pa dān, paggiikan na sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Iban biyaꞌ da isab kamu sin sapantun ilaw dumihil kasawahan ha katilingkal dunya. Na, in ilaw diꞌ hikatapuk. Biyaꞌ da yan sapantun sin dāira nakabutang ha taas būd-būd, amu in tantu kakitaan sadja sin manga tau katān. ");
INSERT INTO tsg_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Wayruun tau magsūꞌ sin ilaw niya, pagꞌubus ampa niya sauban sin pastan. Gām mayan hibutang niya ha taas sin pagbubutangan ilaw ha supaya makarihil sawa pa tau katān ha lawm bāy. ");
INSERT INTO tsg_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Damikkiyan, biyaꞌ da isab ha yan in hantang niyu. Subay kamu dumihil kasawahan pa manga mānusiyaꞌ. Hāti niya pakitaan niyu pa manga tau in manga hinang niyu marayaw, ha supaya nila sanglitun in Amaꞌ niyu ha surgaꞌ, amu in Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ayaw kamu magpikil sin in maksud ku miyari umīg sin saraꞌ agama piyanaug dayn kan Musa iban sin hinduꞌ sin manga kanabihan. Walaꞌ aku miyari umīg ha yan, sagawaꞌ miyari aku dumihil kasabunnalan sin manga hinduꞌ yan. ");
INSERT INTO tsg_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ini in tumtuma niyu! In saraꞌ agama diꞌ tuud manjari pahil-pahilun. Ha salugay masi pa in langit iban dunya iban walaꞌ pa naawn in katān kiyabaytaꞌ ha lawm saraꞌ agama, na wayruun minsan hambuuk batang sulat atawa baris sin manga saraꞌ agama in maīg. ");
INSERT INTO tsg_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Hangkan hisiyu-siyu in lumanggal sin saraꞌ agama minsan saraꞌ amu in biyaꞌ way tantu, iban manghinduꞌ ha kaibanan lumanggal da isab sin saraꞌ, na siya in mababaꞌ tuud ha lawm pamarinta sin Tuhan. Sagawaꞌ hisiyu-siyu in magkahagad sin saraꞌ agama iban manghinduꞌ ha kaibanan kumahagad sin saraꞌ, awn kalagguan niya ha lawm pamarinta sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Baytaan ta kamu, bang in pagtaat niyu pa Tuhan diꞌ da lumabi dayn ha pagtaat sin manga guru sin saraꞌ agama iban sin manga Parisi, na, wayruun palsukuan niyu ha lawm pamarintahan sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Bakas niyu na piyagkarungugan in hinduꞌ ha manga tau sin timpu nakauna, amu agi, ‘Ayaw kamu mamunuꞌ ha pagkahi niyu. Hisiyu-siyu in mamunuꞌ ha pagkahi niya, in siya yan hukumun.’ ");
INSERT INTO tsg_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Sagawaꞌ bihaun ini in hibaytaꞌ ku kaniyu! Hisiyu-siyu in marugal ha pagkahi niya, na, kabutangan siya hukuman. Damikkiyan, hisiyu-siyu in imiyan ‘Asmak’ ha pagkahi niya marā siya pa saraꞌ dakulaꞌ paghuhukuman. Iban hisiyu-siyu in imiyan ha pagkahi niya, ‘Babbal kaw. Wayruun tuud kapūsan mu,’ in siya yan masiksaꞌ ha narkaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Na, bang ha saꞌbu sūng niyu umungsud sin pagkulbanan niyu pa Tuhan, ampa sumaīgpat pa atay niyu in dusa niyu ha pagkahi niyu, ");
INSERT INTO tsg_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bīnan in pagkulbanan niyu pa Tuhan duun ha lugal sin pagkukulbanan, ampa kamu kadtu dumā magdayaw ha pagkahi niyu. Subay na kamu makapagdayaw na, ampa kamu magbalik umungsud sin pagkulbanan niyu pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Bang kamu tuntutan iban dāhun maghukum sin hambuuk tau, dāha niyu siya magtūy magsulut bābā diꞌ pa marā pa paghuhukuman in parakalaꞌ niyu. Sabab bang kamu marā na pa paghukuman ampa kamu kamattanan sin dusa niyu, butangan na kamu hukuman sin manghuhukum ampa kamu hitukbal pa pulis. Pagꞌubus ampa kamu hiluun sin pulis pa jīl. ");
INSERT INTO tsg_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Na, ingat kamu, duun kamu tumuddas ha salugay diꞌ niyu kabayaran in kasāan narusa niyu. ");
INSERT INTO tsg_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Piyagkarungugan niyu da isab in hinduꞌ ini, amu agi, ‘Ayaw kamu magjina.’ ");
INSERT INTO tsg_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Sagawaꞌ bihaun ini in hibaytaꞌ ku kaniyu: hisiyu-siyu in umatud ha hambuuk babai ampa pagnapsuhan niya in babai yan, nagjina na siya iban sin babai yan ha lawm atay niya. ");
INSERT INTO tsg_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Hangkan bang sawpama in mata niyu makarā kaniyu magdusa, na, amu in pagbahasahun marayaw pa lugitun niyu in mata niyu ampa niyu bugitan. Labi pa marayaw maīg in hansipak mata niyu, dayn sin pa lawm narkaꞌ in uwian sin ginhawa-baran niyu. ");
INSERT INTO tsg_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Damikkiyan, bang sawpama in hansipak lima niyu amu in makarā kaniyu magdusa, na, amu in pagbahasahun marayaw pa yan uturun niyu ampa niyu bugitan. Labi pa marayaw mapukul in hansipak lima niyu, dayn sin makapalawm narkaꞌ in ginhawa-baran niyu. ");
INSERT INTO tsg_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Awn pa isab hinduꞌ kiyasulat ha lawm Kitab, amu agi, ‘Hisiyu-siyu in mamugit ha asawa niya subay siya magparā sulat pasa bat kaingatan sin nagbugit na sila.’ ");
INSERT INTO tsg_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Sagawaꞌ bihaun ini in hibaytaꞌ ku kaniyu! Bang awn hambuuk tau mamugit ha asawa niya, ha wayruun nagꞌusug-usug in asawa niya, in tau yan magdusa ha asawa niya. Sabab bang in asawa niya magbana dugaing, na nakalanggal in babai yan sin saraꞌ magjina. Damikkiyan in usug amu in umasawa kaniya, nakalanggal da isab sin saraꞌ magjina. ");
INSERT INTO tsg_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Piyagkarungugan niyu da isab in bakas kiyahinduꞌ ha manga kamaasan natuꞌ amu agi, ‘Ayaw niyu balubaha in janjiꞌ niyu, gām mayan hinanga niyu in janjiꞌ bakas siyapahan niyu pa Tuhan!’ ");
INSERT INTO tsg_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Sagawaꞌ bihaun ini in hibaytaꞌ ku kaniyu! Bang kamu jumanjiꞌ, ayaw kamu sumapa. Ayaw kamu sumapa sumabbut sin surgaꞌ sabab amu yan in hulaan sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Atawa ayaw na kamu sumabbut sin dunya sabab amu yan in kiyabubutangan sin siki niya. Atawa ayaw na kamu sumabbut sin hulaꞌ Awrusalam (Baytal Makdis) sabab amu yan in dāira sin Sultan Makawasa. ");
INSERT INTO tsg_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Iban ayaw kamu sumapa sumabbut sin ū niyu sabab Tuhan in nagpapanjari sin ū niyu. Siya da in makapagbayaꞌ magpapinda sin buhuk niyu dayn ha itum pa putiꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Bang kamu makaiyan na ‘Huun’ atawa ‘Diꞌ’, ayaw niyu na sugpati dugaing sabab unu-unu in bichara hikasugpat niyu, in yan guwaꞌ na dayn ha Saytan, amu in puunan sin katān kangīan. ");
INSERT INTO tsg_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Damikkiyan, piyagkarungugan niyu da isab in hinduꞌ ini, amu agi, ‘Bang awn tau mamuta sin mata sin pagkahi niya, subay da isab butahun in mata niya. Bang awn tau manigpuꞌ sin ipun sin pagkahi niya subay da isab tigpuun in ipun niya.’ ");
INSERT INTO tsg_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Sagawaꞌ bihaun ini in hibaytaꞌ ku kaniyu! Ayaw niyu bawsa in tau nakarusa kaniyu. Gām mayan bang awn tau sumampak sin hansipak bayhuꞌ niyu, pasampakan niyu pa isab kaniya in hansipak bayhuꞌ niyu. ");
INSERT INTO tsg_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Iban bang awn tau manuntut kaniyu ha supaya niya makawaꞌ in badjuꞌ niyu, ayaw na kamu sumulang. Gām mayan sampay juba niyu dihilan na madtu kaniya. ");
INSERT INTO tsg_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Bang awn sundalu dumaak kaniyu dumā sin darāhan niya harap pa lugal awn hangka-batu in layuꞌ niya, ayaw kamu magsumlut. Gām mayan dāha niyu duwa batu in layuꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Bang awn tau mangayuꞌ kaniyu unu-unu na, dihili niyu siya. Iban bang awn tau mamūs unu-unu niyu, būsi niyu siya. ");
INSERT INTO tsg_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Piyagkarungugan niyu da isab in hinduꞌ, amu agi, ‘Kalasahi in bagay niyu, karugali in banta niyu.’ ");
INSERT INTO tsg_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Sagawaꞌ bihaun ini in hibaytaꞌ ku kaniyu! Kalasahi in manga banta niyu iban pangayui niyu duwaa marayaw pa Tuhan in manga tau dimirihil kabinsanaan kaniyu, ");
INSERT INTO tsg_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ha supaya kamu mahinang biyaꞌ sin Tuhan, Amaꞌ niyu ha surgaꞌ, sabab tumabang siya ha tau katān. Karnaꞌ in tau katān dihilan sin Tuhan sawa dayn ha suga, sibuꞌ da tau mangīꞌ iban marayaw, iban dihilan niya da isab ulan in tau katān, sibuꞌ da tau mabuntul iban tau maghihinang sin mangīꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Na, bang in kalasahan niyu amu sadja in manga tau malasa kaniyu, awn ka tungbas niyu marayaw dayn ha Tuhan? Tantu way. Karnaꞌ minsan in tau magkakawaꞌ sukay pa parinta, amu in laung niyu pangungugut, malasa da ha manga tau malasa kanila! ");
INSERT INTO tsg_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Iban bang amu sadja isab manga bagay niyu in asipun niyu marayaw, na, wayruun da karayawan mahinang niyu, sabab minsan in manga tau amu in nagtutuhan dugaing dayn ha Tuhan tuud, magꞌasip da marayaw ha manga bagay nila! ");
INSERT INTO tsg_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","In kamu yan subay tubus in kawl-piil niyu tudju pa pagkahi niyu biyaꞌ da isab sin Tuhan, Amaꞌ niyu ha surgaꞌ, tubus ha unu-unu katān. ");
INSERT INTO tsg_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Tantuha niyu tuud in ini. Bang kamu magꞌammal ibārat, ibut-ibut ayaw niyu hinanga ha harapan sin mayran madjīlis ha supaya kakitaan sin manga tau, sabab bang bihādtu in hinang niyu, wayruun da tungbas makawaꞌ niyu dayn ha Amaꞌ niyu ha surgaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Hangkan sa bang awn hirihil niyu unu-unu na ha tau miskin, subay kamu diꞌ magpakitaꞌ-kitaꞌ ha manga tau, biyaꞌ sin manga tau magpabawꞌ-bawꞌ sadja. In sila yan, bang awn hirihil nila ha manga miskin subay hadja didtu ha manga kalanggalan, iban ha manga karān-dānan bat kakitaan sin tau mataud, ha supaya sila mabantug. Baytaan ta kamu, bang in sila yan bantugun sin manga tau, na, amu da yan in tungbas kanila, kabantugan dayn ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Sagawaꞌ bang kamu tumabang ha manga miskin, ayaw niyu paingatan ha hisiyu-siyu tau minsan ha bagay niyu tuud. ");
INSERT INTO tsg_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Na, in hāti niya subay niyu diꞌ hipagbukag ha manga tau in pagtabang niyu. Ampa kamu tungbasan sin Tuhan, Amaꞌ niyu, amu in makaingat sin hinang niyu, amu in hinang walaꞌ niyu piyaingat ha hisiyu-siyu tau. ");
INSERT INTO tsg_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Bang kamu mangarap pa Tuhan, ayaw kamu sumingud ha tau amu magpabawꞌ-bawꞌ sadja nagtaat pa Tuhan, sagawaꞌ diꞌ magkugdan in kawl-piil nila iban sin lawm atay nila. Mabayaꞌ sadja sila tumindug mangarap pa Tuhan duun ha manga langgal iban ha manga suliꞌpang sin manga dān supaya sila kakitaan sin manga tau. Matantu ku kaniyu bang sila yan sanglitun sin manga tau, amu da yan in tungbas nila. Wayruun na tungbas dugaing taymaun nila. ");
INSERT INTO tsg_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Sagawaꞌ kuꞌnu-kuꞌnu kamu mangayuꞌ duwaa pa Tuhan kadtu kamu pa lawm bilik, tambula niyu in lawang, ampa kamu pangarap pa Tuhan, Amaꞌ niyu, amu in diꞌ pagkakitaan. Unu-unu in hinang niyu amu in diꞌ kakitaan sin mānusiyaꞌ, kakitaan da sin Amaꞌ niyu. Na, tungbasan niya tuud kamu. ");
INSERT INTO tsg_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Bang kamu mangayuꞌ duwaa pa Tuhan, ayaw kamu magpataud sin manga bichara wayruun da maana niya, biyaꞌ sin hinang sin manga tau amu in nagtutuhan sin dugaing dayn ha Tuhan tuud. Sawkat mahabaꞌ in pagpangayuꞌ nila duwaa, pangannal nila dungugun sila sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ayaw niyu tuud singuri in hinang nila, sabab kiyaingatan na sin Tuhan, Amaꞌ niyu, in kagunahan niyu, minsan ha way pa kamu nakapangayuꞌ kaniya. ");
INSERT INTO tsg_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Na, bang kamu mangarap pa Tuhan subay biyaꞌ ha ini in hibichara niyu: ‘Ū Amaꞌ namuꞌ ha surgaꞌ, bang mayan lagguun sin mānusiyaꞌ in ngān mu mahasuchi. ");
INSERT INTO tsg_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bang mayan ikaw na in mamarinta ha mānusiyaꞌ katān. Bang mayan maagad dī ha dunya in kabayaan mu, biyaꞌ sin ha surgaꞌ, asal maagad in kabayaan mu. ");
INSERT INTO tsg_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Dihilan kāmuꞌ adlaw ini in kakaun kagunahan namuꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ampuna in manga dusa namuꞌ biyaꞌ sin pagmaap namuꞌ ha manga tau nakarusa kāmuꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Palayua kami dayn ha kasigpitan makapilad sin īman namuꞌ iban tampani kami dayn ha Saytan, amu in puunan sin katān kangīan.’ (Na, biyaꞌ ha yan in suntuan sin pagpangayuꞌ niyu duwaa pa Tuhan.) ");
INSERT INTO tsg_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Na, pasal da isab sin pagmaap, bang niyu maapun in tau nakarusa kaniyu, na ampunun da kamu isab sin Tuhan, Amaꞌ niyu ha surgaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Sagawaꞌ bang niyu diꞌ maapun in tau nakarusa kaniyu, tantu diꞌ da isab ampunun sin Amaꞌ niyu in manga dusa niyu. ");
INSERT INTO tsg_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Iban bang kamu magpuasa, ayaw kamu magpadagbus, biyaꞌ nasususa kamu, biyaꞌ sin hinang sin manga tau magpabawꞌ-bawꞌ sadja. Bang sila magpuasa, diꞌ sila mamaꞌmus iban diꞌ sila magsudlay, ha supaya kaingatan sin tau sin nagpupuasa sila. Matantu ku kaniyu bang sila yan bantugun sin tau, amu da yan in tungbas nila. Wayruun na tungbas kanila marayaw ha adlaw susūngun. ");
INSERT INTO tsg_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Sagawaꞌ in kamu, bang kamu magpuasa pamaꞌmus kamu iban sudlaya in buhuk niyu, ");
INSERT INTO tsg_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","supaya kamu diꞌ kakilāhan sin manga kaibanan sin nagpupuasa kamu. Amura in Tuhan, Amaꞌ niyu, amu in diꞌ pagkakitaan in makaingat sin hinang niyu. Unu-unu in hinang niyu amu in diꞌ kakitaan sin tau, kīkitaꞌ da sin Amaꞌ niyu. Na, tungbasan niya tuud kamu. ");
INSERT INTO tsg_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ayaw kamu magtawꞌ pangaltaꞌ dī ha dunya, sabab kutkutun da sin kuuk, mahansul da sin gahaꞌ, takawun da sin sugarul. ");
INSERT INTO tsg_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Gām pa kamu maghinang sin marayaw, ha supaya awn altaꞌ niyu ha surgaꞌ, sabab bang ha surgaꞌ in altaꞌ niyu, diꞌ makutkut sin kuuk, diꞌ mahansul sin gahaꞌ, iban diꞌ matakaw. ");
INSERT INTO tsg_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Karnaꞌ haunu-haunu in kiyabutangan sin pangaltaꞌ niyu, duun da isab in bimbang sin atay niyu. ");
INSERT INTO tsg_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“In manga mata niyu amuna in biyaꞌ sapantun ilaw sin ginhawa-baran niyu. Bang in mata niyu marayaw, na awn kasawahan sin ginhawa-baran niyu. ");
INSERT INTO tsg_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Sagawaꞌ bang in mata niyu bukun marayaw, na ha lawm katigidluman in ginhawa-baran niyu. Bang in ilaw ha ginhawa-baran niyu way sawa, makaluuy kamu. Katigidluman dakulaꞌ sa yan! ");
INSERT INTO tsg_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Wayruun tau in makapagtagꞌīpun ha duwa nakuraꞌ, sabab bang duwa in nakuraꞌ sin tau, tantu kalasahan niya in hangka-tau, hāti karugalan niya in hambuuk. In hambuuk yan kahagarun niya tuud, sagawaꞌ in hambuuk, diꞌ niya asipun. Na biyaꞌ da isab hādtu, bang altaꞌ in malabi tuud ha lawm atay niyu, na diꞌ niyu maagad in kabayaan sin Tuhan hipahinang kaniyu. ");
INSERT INTO tsg_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Hangkan ini in hinduꞌ ku kaniyu! Ayaw kamu magsusa ha pasal sin kabuhianan niyu, bang unu in kaunun iban inumun niyu, atawa magsusa sin pagtamung niyu. Karnaꞌ bukun ka mahalgaꞌ in kabuhiꞌ ta dayn sin kakaun? Atawa bukun ka mahalgaꞌ in anggawtaꞌ-baran ta dayn sin tamungun? ");
INSERT INTO tsg_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kitaa niyu ba in manga manuk-manuk naglulupad. Diꞌ sila magtanum iban diꞌ magꞌani, iban diꞌ magtawꞌ sin manga naani ha pagtatawꞌan nila. Malayngkan piyakakaun da isab sila sin Tuhan, Amaꞌ niyu ha surgaꞌ. Na, bukun ka labi kamu māyuꞌ mahalgaꞌ dayn sin manga manuk-manuk? ");
INSERT INTO tsg_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Maytaꞌ, humabaꞌ ka in umul niyu bang kamu magsusa? ");
INSERT INTO tsg_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Damikkiyan da isab maytaꞌ kamu magsusa sin pasal pagtamung niyu? Kitaa niyu ba in kasumping-sumpingan yan amu in timubuꞌ isa-isa nila. Diꞌ sila maghinang, iban diꞌ sila maghablun sin tamungun nila. ");
INSERT INTO tsg_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Sagawaꞌ baytaan ta kamu, minsan in pakayan hi Sultan Sulayman, amu in bantug tuud dayahan, diꞌ da makaatu sin lingkat sin manga kasumpingan yan. ");
INSERT INTO tsg_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tuhan da in magpatamung ha manga kaparangan amu in buhiꞌ adlaw ini, sagawaꞌ kunsum-kuꞌnisa mapatay da hirungul pa kāyu. Bang piyatatamung sin Tuhan in manga kaparangan biyaꞌ ha yan, na amu pa isab in kamu in diꞌ niya patamungun? Bukun pakarayaw mahugut in pangandul niyu pa Tuhan! ");
INSERT INTO tsg_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Hangkan sa ayaw kamu masusa bang dayn diin in pagkaun niyu atawa dayn diin in pagꞌinum niyu, iban pagtamung niyu. ");
INSERT INTO tsg_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sabab mabiyaꞌ kamu sin manga tau amu in nagtutuhan sin dugaing dayn ha Tuhan tuud, amu in magsusa sadja sin manga kabuhianan nila. Unu-unu in kagunahan niyu katān, kiyaiingatan da sin Tuhan, Amaꞌ niyu, ha surgaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Gām mayan subay sadja Tuhan in papagbayaun niyu ha lawm atay niyu, iban subay niyu agarun in manga daakan niya, ampa niya hirihil kaniyu in unu-unu kagunahan niyu katān. ");
INSERT INTO tsg_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hangkan sa ayaw kamu masusa sin pasal sin susūngun. Sabab bang kamu magsusa pasal sin susūngun tumaud sadja in kasusahan niyu. In kasusahan niyu ha bihaun ayaw niyu na bangkati sin kasusahan niyu ha susūngun. ");
INSERT INTO tsg_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ayaw kamu mangliling pa mangīꞌ sin hinang sin tau dugaing supaya isab kamu diꞌ lilingun sin Tuhan butangan hukuman. ");
INSERT INTO tsg_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sabab bang kamu mangliling pa mangīꞌ ha pagkahi niyu, na lilingun da isab kamu sin Tuhan butangan hukuman. Iban in kaagi niyu mangliling ha pagkahi niyu biyaꞌ da isab sin kaagi sin Tuhan mangliling kaniyu. ");
INSERT INTO tsg_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Līliling niyu sadja pa mangīꞌ in kasāan sin pagkahi niyu. Maingat niyu lilingun in kasāan nila minsan sibiꞌ-sibiꞌ da, sagawaꞌ diꞌ niyu kaingatan lilingun in kasāan niyu minsan da biyaꞌ lagguꞌ unu. Amu in pagꞌiyanun kakitaan niyu in puling sibiꞌ-sibiꞌ ha lawm mata sin pagkahi niyu, sagawaꞌ diꞌ niyu kakitaan in puling malagguꞌ ha lawm mata niyu. ");
INSERT INTO tsg_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Diꞌ kamu yan manjari. Mabayaꞌ kamu magꞌīg sin puling ha mata sin pagkahi niyu, sin awn puling biyaꞌ lagguꞌ hāg ha lawm mata niyu. ");
INSERT INTO tsg_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","In kamu yan lansuk ha guwaꞌ, bingit ha lawm. Magpabawꞌ-bawꞌ sadja kamu marayaw. Īgi niyu na muna in puling biyaꞌ lagguꞌ hāg dayn ha lawm mata niyu, ampa kamu makakitaꞌ marayaw umīg sin puling sin pagkahi niyu.” ");
INSERT INTO tsg_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Laung isab hi Īsa, “Ayaw kamu magdihil sin unu-unu suchi ha manga iruꞌ, magbīng da sila mangutkut kaniyu. Ayaw niyu tiluan in mussaꞌ niyu pa manga babuy sabab giikan nila sadja iban pagtasak-tasakun. ");
INSERT INTO tsg_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Bang kamu mangarap pa Tuhan, pangayuꞌ-ngayuꞌ kamu, tantu dihilan kamu. Paglawag kamu, tantu makabaak kamu. Pagkuꞌkuꞌ kamu ha lawang, tantu ukaban kamu. ");
INSERT INTO tsg_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Hisiyu-siyu in mangayuꞌ pa Tuhan tantu karihilan sadja, iban hisiyu-siyu in maglawag, tantu makabaak sadja sin piyaglawag niya. Iban hisiyu-siyu isab in kumuꞌkuꞌ ha lawang, tantu kaukaban sadja siya. ");
INSERT INTO tsg_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","In kamu manga tagaanak, bang in anak niyu mangayuꞌ kakaun dihilan niyu ka siya batu? ");
INSERT INTO tsg_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Atawa dihilan niyu ka in anak niyu hās bang in piyangayuꞌ niya istaꞌ? ");
INSERT INTO tsg_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Na, minsan biyaꞌ diin in ngīꞌ niyu, maingat da isab kamu mangdihil sin unu-unu hikarayaw ha manga anak niyu. Na, amu pa ka isab in Tuhan, Amaꞌ niyu ha surgaꞌ, in diꞌ maingat dumihil sin unu-unu marayaw kaniyu bang kamu mangayuꞌ da kaniya? ");
INSERT INTO tsg_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Unu-unu in kabayaan niyu hinangun sin pagkahi niyu kaniyu, amuna yan in subay niyu hinangun isab kanila. Amuna yan in hāti sin saraꞌ piyanaug dayn kan Musa iban sin panghinduꞌ sin manga nabi. ");
INSERT INTO tsg_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Labay kamu ha lawang makiput, karnaꞌ in pagsusūran pa narkaꞌ maluag iban in dān harap madtu landuꞌ maluhay labayan. Mataud in tau nagpapanaw ha labayan yan. ");
INSERT INTO tsg_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Sagawaꞌ in pagsusūran harap pa surgaꞌ makiput, iban in dān labayan harap madtu landuꞌ mahunit. Tiyuꞌ-tiyuꞌ da in tau makabatuk madtu. ");
INSERT INTO tsg_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Kamayaꞌ kamu dayn ha manga tau amu in magpabawꞌ-bawꞌ guru sin agama. Laung nila in hinduꞌ nila dayn ha Tuhan iban miyamagad tuud sila sin daakan sin Tuhan. Sagawaꞌ in bunnal niya in hinduꞌ nila yan makamula ha manga tau. In sila yan panipu! ");
INSERT INTO tsg_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Dayn ha manga hinang nila, kaingatan niyu sin in sila bukun bunnal guru sin agama. Saliꞌ sila yan sin manga kahuy amu in kakilāhan dayn ha manga bunga nila. In sagbut tunukan diꞌ mamunga anggul. Damikkiyan da isab in kahuy tunukan diꞌ mamunga sin bungang-kahuy tina. ");
INSERT INTO tsg_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","In kahuy marayaw, tantu in bunga niya marayaw da isab. In kahuy mangīꞌ, tantu mangīꞌ da isab in bunga niya. ");
INSERT INTO tsg_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","In kahuy masambu diꞌ magbunga mangīꞌ, iban in kahuy lanus diꞌ magbunga marayaw. ");
INSERT INTO tsg_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Na sasukuꞌ sin kahuy amu in diꞌ magbunga marayaw, tantu pilaun ampa hilaruk pa lawm kāyu. ");
INSERT INTO tsg_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Hangkan laung ku kaniyu, duun niyu kakilāhan in manga guru bukun bunnal dayn ha manga hinang nila. ");
INSERT INTO tsg_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Bukun katān tau amu in sumabbut kākuꞌ ‘Ū, Panghuꞌ’ in makatabuk sin karayawan dayn ha pamarinta sin Tuhan. Amu sadja in tau himihinang tuud sin daakan sin Tuhan, Amaꞌ ku, ha surgaꞌ in makatabuk sin karayawan yan. ");
INSERT INTO tsg_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Bang dumatung na in adlaw paghukum ha manga mānusiyaꞌ mataud na tau in imiyan biyaꞌ ha ini. Laung nila kākuꞌ, ‘Ū Panghuꞌ, dayn ha kawasa sin ngān mu napasaplag namuꞌ in baytaꞌ kasabunnalan dayn ha Tuhan. Dayn ha kawasa sin ngān mu napaguwaꞌ namuꞌ in manga saytan dayn ha baran sin manga tau, iban dayn da isab ha kawasa sin ngān mu mataud nahinang namuꞌ makainu-inu!’ ");
INSERT INTO tsg_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Sakali in sambung ku kanila biyaꞌ ha ini, ‘Diꞌ ta kamu kakilāhan. Īg kamu dayn dī, manga tau mangīꞌ tuud kamu yan!’ ");
INSERT INTO tsg_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Na, sasukuꞌ sin tau nakarungug sin manga hinduꞌ ku ini ampa nila kahagarun, biyaꞌ sila sapantun sin tau tagaakkal amu in naghinang bāy. Nagpatindug siya sin bāy niya ha lupaꞌ matugas iban tiyambakan sin batu in manga hāg niya. ");
INSERT INTO tsg_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na, bang kugdanan in bāy niya sin ulan matigdaꞌ, iban sin dunuk dayn ha manga subaꞌ iban sin hunus, diꞌ malubu in bāy niya sabab mahugut in kiyabutangan niya. ");
INSERT INTO tsg_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Sagawaꞌ hisiyu-siyu in tau nakarungug sin manga hinduꞌ ku ini ampa diꞌ magkahagad, biyaꞌ sila sapantun tau dupang naghinang sin bāy niya nagꞌusuk ha lupaꞌ mahabluꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Bang kugdanan sin ulan matigdaꞌ, sin dunuk dayn ha subaꞌ iban sin hangin makusug, na in bāy niya malubu, way tuud tabangan.” ");
INSERT INTO tsg_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pagꞌubus hi Īsa namichara pasal sin unu-unu katān ini, sangat nainu-inu in manga tau nagtitipun sin kaagi niya nagnasīhat, ");
INSERT INTO tsg_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","sabab in pagnasīhat niya taga kawasa tuud dayn ha Tuhan. Bukun siya biyaꞌ sin manga guru sin saraꞌ agama. ");
INSERT INTO tsg_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Manjari limūd na hi Īsa dayn ha taas būd-būd. Paglūd niya, mataud tuud tau imuurul kaniya. ");
INSERT INTO tsg_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Manjari awn hambuuk tau īipul in miyawn kan Īsa ampa simujud ha alupan niya, amu agi, “Tuwan, mapauliꞌ mu aku bang mu kabayaan kaulian aku.” ");
INSERT INTO tsg_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Na biyutang hi Īsa in lima niya pa tau īipul sartaꞌ imiyan siya, laung niya, “Kabayaan ku kaulian na in sakit mu. Lumanuꞌ na in pais mu!” Na, saruun-duun naīg in ipul niya iban limanuꞌ na in pais niya. ");
INSERT INTO tsg_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Sakali biyandaan siya hi Īsa, laung niya “Ibut-ibut kaymu, ayaw kaw magbaytaꞌ minsan kansiyu pasal sin pagpauliꞌ ku kaymu, sagawaꞌ kadtu kaw magtūy pa imam ampa mu palilingan in baran mu kaniya. Pagꞌubus, ampa kaw kadtu ungsud sin pagkulbanan amu in daakan hi Musa, ha supaya awn tandaꞌ kakitaan sin manga tau katān sin kiyaulian na kaw.” ");
INSERT INTO tsg_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Manjari pagdatung hi Īsa pa dāira Kapirnaum, awn hambuuk kapitan tau Rūm in miyāk mawn kaniya, ampa nagmuhut-muhut nangayuꞌ tabang kaniya. ");
INSERT INTO tsg_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Laung sin kapitan, “Tuwan, in daraakun ku nasasakit ha bāy, diꞌ makahibal iban kiyasasakitan tuud.” ");
INSERT INTO tsg_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Laung hi Īsa, “Madtu aku magpauliꞌ sin sakit niya.” ");
INSERT INTO tsg_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","“Ayaw na kaw madtu, Tuwan,” in sambung sin kapitan kaniya. “Diꞌ aku tūpun magpakadtu kaymu pa taas sin bāy ku sabab labi in kawasa mu dayn kākuꞌ! Malayngkan minsan kaw umiyan sadja dayn dī, tantu kaulian na in daraakun ku didtu ha bāy. ");
INSERT INTO tsg_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kaingatan ku maagad in uldin mu, sabab in aku ini hambuuk da isab tau ha babaan sin kawasa sin manga nakuraꞌ ku, iban awn da isab manga sundalu ha babaan ku. Bang laung ku ha sundalu ku, ‘Kadtu kaw’, madtu siya. Bang laung ku ha hangka-tau, ‘Kari kaw’, mari siya. Bang laung ku ha īpun ku, ‘Hinanga ini’, na magtūy niya hinangun.” ");
INSERT INTO tsg_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Na, nainu-inu tuud hi Īsa pagdungug niya. Laung niya ha manga tau mataud imuurul kaniya, “Baytaan ta kamu tuud, way aku nakalanggal hambuuk tau bangsa natuꞌ Israil amu in biyaꞌ ha yan in kusug sin parachaya iban pangandul. ");
INSERT INTO tsg_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Matantu ku kaniyu bang tumindug na tuud in pamarinta sin Tuhan mataud tau ginis-ginisan bangsa dayn ha manga hulaꞌ ha subangan iban sadlupan in makapagsāw kaynda Ibrahim, Isahak, iban hi Yaꞌkub sin pagjamu ha lawm pamarintahan sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Sumagawaꞌ mataud tau bangsa Israil in diꞌ makatabuk sin karayawan sin pamarinta sin Tuhan amu in bakas kiyasukuꞌ kanila. Hilaruk na sila pa lawm narkaꞌ jahannam. Duun sila magtangis iban sumandal sin kasiksaan makalap.” ");
INSERT INTO tsg_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sakali laung hi Īsa ha kapitan “Uwiꞌ na kaw madtu. Dayn ha sabab sin parachaya iban pangandul mu, hikarihil na kaymu in piyangayuꞌ mu.” Sartaꞌ in daraakun sin kapitan didtu ha bāy kiyaulian na saruun-duun. ");
INSERT INTO tsg_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sakali limanjal na hinda Īsa mawn pa bāy hi Pitrus. Na, pagsūd nila pa bāy, kītaꞌ hi Īsa in ugangan babai hi Pitrus nagkukulang hīhinglaw. ");
INSERT INTO tsg_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kiyaputan hi Īsa in lima sin babai, sartaꞌ magtūy kiyaulian in hinglaw sin ugangan hi Pitrus. Na, nagbangun na siya ampa nagbutang pagkaun kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pagsadlup sin suga, mataud tau in diyā madtu kan Īsa. Sasukuꞌ sin tau siyusūd saytan, piyaguwaꞌ hi Īsa katān in manga saytan dayn ha lawm baran nila sin hambuuk lapal sadja, iban sasukuꞌ sin nasasakit kiyaulian niya. ");
INSERT INTO tsg_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Hīnang niya in katān ini ampa mabunnal in kiyabaytaꞌ hi Nabi Isayas ha lawm Kitab, amu agi, “Siya in nakapauliꞌ sin sakit natuꞌ, iban nakapalayuꞌ sin manga sakit dayn kātuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Manjari pagkitaꞌ hi Īsa sin mataud tau ha katilibut niya, diyaak niya in manga mulid niya, magsakap supaya sila makauntas pa hansipak hunasan. ");
INSERT INTO tsg_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Sakali awn hambuuk guru saraꞌ agama miyawn kan Īsa. Laung niya “Tuwan, magad aku kaymu minsan kaw pakain.” ");
INSERT INTO tsg_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","In sambung hi Īsa kaniya “In manga iruꞌ talun awn lugal pagꞌuwian nila iban in kamanuk-manukan awn pugad paghali-halihan nila, sumagawaꞌ in aku, amu in Anak Mānusiyaꞌ, wayruun tantu lugal pagtūgan iban paghali-halihan ku.” ");
INSERT INTO tsg_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Awn isab hambuuk mulid hi Īsa namung kaniya, amu agi, “Tuwan, pauwia naa aku magbalik pa bāy. Bang ku hikakubul naa in amaꞌ ku ampa aku mari magbalik magad kaymu.” ");
INSERT INTO tsg_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Sagawaꞌ laung hi Īsa kaniya, “Agad na kaw kākuꞌ bihaun iban ayaw na kaw mabimbang sin pasal yan, sabab in manga tau patay in pagtaat nila pa Tuhan, amu in matūp magkubul ha manga patay.” ");
INSERT INTO tsg_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sakali simakat na hi Īsa pa taas kumpit asibiꞌ, ampa miyagad in manga mulid niya. Imuntas na sila sin dagat. ");
INSERT INTO tsg_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bukun malugay magtūy himuyup in hangin makusug, agun-agun na sila malunud, saꞌbu hi Īsa natutūg. ");
INSERT INTO tsg_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Sakali kiyadtu sin manga mulid niya hi Īsa, ampa biyatiꞌ. Laung nila, “Tuwan, panabang na kaw. Magmula na kitaniyu!” ");
INSERT INTO tsg_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Na, laung hi Īsa kanila, “Maytaꞌ kamu miyugaꞌ tuud? Kulang pakarayaw in pangandul niyu.” Sakali nagbangun na siya ampa niya diyaak in hangin iban alun pahundungun. Na, saruun-duun magtūy liminaw tuud in hulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Magtūy in manga mulid niya kiyublaan. Agi nila, “Ay kaw naa, hisiyu bahaꞌ tuud in tau ini? Minsan in hangin iban alun magkahagad kaniya!” ");
INSERT INTO tsg_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pagꞌubus yadtu dimungguꞌ na sila pa hansipak sin hunasan ha hulaꞌ sakup sin Gadara. Manjari awn duwangka-tau siyusūd saytan duun. Naghulaꞌ sila ha lawm kakubulan. Landuꞌ sila makabugaꞌ-bugaꞌ hangkan wayruun maglabay dayn ha dān masuuk pa kanila. Sakali gimuwaꞌ in duwangka-tau ini miyāk kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Saruun-duun magtūy sila nagsilawak, amu agi “Unu in kabayaan mu kāmuꞌ, ikaw amu in Anak Tuhan? Miyari ka kaw supaya kami binsanaun sin bukun pa waktu?” ");
INSERT INTO tsg_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Manjari ini awn manga babuy mataud nagbabaan didtu nagkakaun malayuꞌ-layuꞌ mawn kanila. ");
INSERT INTO tsg_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Sakali nangayuꞌ junjung in manga saytan kan Īsa, laung nila “Anduꞌ kailu, bang mu kami paguwaun, pakadtua kami pa lawm baran sin manga babuy yaun.” ");
INSERT INTO tsg_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Kadtu na kamu,” laung hi Īsa. Sakali magtūy na gimuwaꞌ in manga saytan dayn ha baran sin duwangka-tau limīn madtu pa manga baanan babuy, ampa na in baanan sin babuy limungtud dimagan dayn ha pangpang pa babaꞌ. Nakatūy sila pa lawm dagat, iban naubus tuud sila naluꞌmus. ");
INSERT INTO tsg_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Manjari in manga tau nagꞌiipat sin manga babuy magtūy dimagan madtu pa dāira, nanuysuy ha manga tau sin katān kiyakitaan nila, iban sin pasal sin nahinang hi Īsa ha duwangka-tau siyusūd sin saytan. ");
INSERT INTO tsg_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hangkan mataud tau dayn ha dāira in miyadtu miyāk kan Īsa, ampa sila nangayuꞌ junjung kan Īsa, bang mayan siya mīg na dayn ha hulaꞌ nila. ");
INSERT INTO tsg_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Simakat na hi Īsa pa taas kumpit asibiꞌ, ampa na sila imuntas pa hansipak hunasan harap madtu nagbing pa luggiyaꞌ dāira niya. ");
INSERT INTO tsg_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Didtu mān sila, awn diyā mawn kan Īsa hambuuk tau nasasakit, nagpapatay in baran niya, kimukulang na sadja ha kulangan niya. Na, pagkitaꞌ hi Īsa sin makusug in pangandul sin manga tau nagdarā ha nāsakit, laung hi Īsa ha tau nagpapatay in baran, “Ayaw kaw mabugaꞌ, Utuꞌ! Iyampun na in manga dusa mu.” ");
INSERT INTO tsg_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Manjari ini awn manga guru saraꞌ agama duun. In manga guru ini kaibanan naghunaꞌ-hunaꞌ, amu agi, “Uy, in tau ini namung pangkal pa Tuhan!” ");
INSERT INTO tsg_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kiyaingatan hi Īsa bang unu in pīpikil nila. Laung hi Īsa, “Maytaꞌ mangīꞌ in ha lawm pikilan niyu? ");
INSERT INTO tsg_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ha pikil niyu, unu in maluhay hipamung ha tau, bang aku umiyan, ‘Iyampun na in manga dusa mu.’ Atawa umiyan ha tau nasasakit, ‘Bangun kaw ampa kaw panaw?’ ");
INSERT INTO tsg_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Na, dihilan ta kamu tandaꞌ sin in aku amu in Anak Mānusiyaꞌ awn kapatutan ku umampun sin dusa sin manga mānusiyaꞌ.” Sakali laung hi Īsa ha tau amu in nagpapatay in baran, “Utuꞌ, bangun kaw mumusa in kulangan mu ampa kaw uwiꞌ na!” ");
INSERT INTO tsg_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Sakali nagbangun na in tau yadtu, ampa siya miyanaw na minuwiꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Na, miyugaꞌ in manga tau nakakitaꞌ. Piyudji nila in Tuhan sin kawasa dīhil niya pa mānusiyaꞌ maghinang sin biyaꞌ ha ini. ");
INSERT INTO tsg_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Sakali minīg na hi Īsa dayn didtu. Ha saꞌbu sila miyamanaw, kītaꞌ hi Īsa in hambuuk mangangawaꞌ sukay pa parinta, naglilingkud ha pustu pagkakawaan sukay. In ngān niya hi Matiyu. Laung hi Īsa kaniya, “Kari kaw agad kākuꞌ magguru.” Na, magtūy timindug hi Matiyu ampa miyagad kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ha saꞌbu hi Īsa iban sin manga mulid niya nagkakaun ha bāy hinda Matiyu mataud mangangawaꞌ sukay pa parinta iban manga kaibanan tau baldusa in miyawn limamud kanda Īsa simāw nagkaun hangka-lamisahan. ");
INSERT INTO tsg_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Sakali kītaꞌ sin manga tau parhimpunan Parisi sin miyawn in manga tau ini simāw nagkaun. Na, nangasubu in manga tau Parisi ha manga mulid hi Īsa, laung nila “Maytaꞌ magsāw magkaun in guru niyu iban sin manga mangangawaꞌ sukay pa parinta iban sin manga tau baldusa?” ");
INSERT INTO tsg_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Diyungug hi Īsa in pangasubu nila. Na, diyalil niya kaagi in sambung niya kanila, laung niya, “In manga tau way sakit diꞌ magkagunahan mangungubat, amu da in magkagunahan mangungubat in manga tau nasasakit. ");
INSERT INTO tsg_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kadtu kamu, hātiha niyu bang unu in maana sin kiyasulat ha Kitab, amu agi ‘Bukun mahalgaꞌ kākuꞌ in manga hayup hiungsud niyu pagkulbanan. Sagawaꞌ in kabayaan ku tuud, bayngꞌulungun kamu ha pagkahi niyu.’” Laung isab hi Īsa, “In maksud ku miyari pa dunya, bukun paagarun kākuꞌ in manga tau, amu in imiyan, in sila mabuntul, saꞌ miyari aku supaya magad kākuꞌ in manga tau baldusa (amu in biyaꞌ sapantun tau taga sakit).” ");
INSERT INTO tsg_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Manjari awn manga mulid hi Yahiya amu in mangliliguꞌ in miyawn kan Īsa nangasubu. Laung nila, “Tuwan, in kami ini iban sin manga tau Parisi mawmu magpuasa, sagawaꞌ in manga mulid mu diꞌ tuud magpuasa. Maytaꞌ bahaꞌ?” ");
INSERT INTO tsg_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Diyalil kaagi hi Īsa in sambung niya kanila, laung niya, “Masusa ka in manga luruk ha pagtiyaunan bang in pangantin usug masi yaun pa duun kanila? Tantu diꞌ! Sagawaꞌ dumatung da in waktu in pangantin usug kawaun na dayn kanila. Na, bang dumatung na in waktu yan in sila magpuasa na.” ");
INSERT INTO tsg_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Pagꞌubus nagdalil hi Īsa pasal sin panghinduꞌ nakauna iban sin panghinduꞌ niya. Laung niya, “Wayruun tau in magtupak sin pīs-pīs baꞌgu pa tamungun daan, sabab in pīs-pīs baꞌgu hipanupak kumungkung da, na gām mayan lumagguꞌ in gisiꞌ ha tamungun. ");
INSERT INTO tsg_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Iban wayruun tau lumuun sin tubig anggul (biyaꞌ tubaꞌ), amu in masi pa nagbubukal, pa luluunan pais hayup, amu in daan iban matugas na, sabab bang biyaꞌ hādtu in kaagi, na in luluunan pais hayup, amu in daan iban matugas na, tantu mabustak. Na, maasag na in tubig anggul iban magkangīꞌ na in luluunan pais hayup. Saꞌ in tubig anggul amu in baꞌgu subay hiluun ha luluunan pais hayup baꞌgu. Na, diꞌ maluppas in tubig anggul iban sin luluunan niya.” ");
INSERT INTO tsg_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ha saꞌbu hi Īsa nagbibichara, awn hambuuk nakuraꞌ sin langgal in miyawn kaniya ampa simujud ha alupan niya. Laung niya kan Īsa, “Tuwan, in anak ku babai hayn-duun sadja miyatay, saꞌ bang kaw magad kākuꞌ ampa mu siya kaputan, tantu mabuhiꞌ siya magbalik.” ");
INSERT INTO tsg_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Magtūy na hi Īsa timindug ampa miyagad iban sin manga mulid niya ha tau nakuraꞌ sin langgal. ");
INSERT INTO tsg_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Sakali awn imuurul kan Īsa hambuuk babai nasasakit giyuguwaan duguꞌ, hangpuꞌ tagduwa tahun na in lugay niya. Simuuk siya pa taykud hi Īsa, ampa niya iyabut in duhul sin juba niya, sarang sadja dimaggut in lima niya. ");
INSERT INTO tsg_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Laung niya ha lawm atay niya, “Bang ku sadja kakamputan in juba niya, tantu kaulian aku.” ");
INSERT INTO tsg_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kiyasayuhan hi Īsa sartaꞌ himundung siya, ampa siya himarap pa ulihan. Sakali kītaꞌ niya in babai. Laung niya kaniya, “Indaꞌ, ayaw kaw mabugaꞌ! In kusug sin parachaya iban pangandul mu amu in nakauliꞌ kaymu.” Na, ha waktu da yadtu magtūy kiyaulian in babai. ");
INSERT INTO tsg_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sakali limanjal na hi Īsa pa bāy sin tau nakuraꞌ sin langgal. Pagsūd niya pa bāy kītaꞌ niya in manga magmumulsiku bang awn kamatayan iban sin manga tau nahihiluhalaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Laung hi Īsa, “Guwaꞌ kamu katān! Walaꞌ miyatay in bataꞌ ini, saꞌ natūg sadja!” Sakali piyagkatawahan hi Īsa sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pagꞌubus, napaguwaꞌ mayan in manga tau dayn ha lawm bāy, miyadtu na hi Īsa pa lawm bilik sin bataꞌ ampa niya kiyamputan in lima sin bataꞌ. Sakali nagbangun na in bataꞌ babai. ");
INSERT INTO tsg_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Magtūy simaplag in suysuy pasal sin nahinang hi Īsa pa katilingkal sin paghulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sakali gimuwaꞌ na hi Īsa dayn ha bāy sin tau nakuraꞌ sin langgal ampa siya miyanaw. Ha saꞌbu niya miyamanaw, awn duwa tau buta imuurul ha ulihan niya. Nagꞌuulang sila karuwa, amu agi, “Anduꞌ, hambuuk panubuꞌ hi Daud, kaulungi kami.” ");
INSERT INTO tsg_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Sampay hi Īsa nakasūd na pa lawm bāy masi imuurul in duwa tau buta. Sakali iyasubu sila hi Īsa, laung niya, “Na, magkahagad tuud kamu sin kaulian ta kamu?” “Huun, Tuwan,” in sambung sin duwa buta. ");
INSERT INTO tsg_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Sakali, kiyaputan na hi Īsa in mata nila karuwa, ubus laung niya kanila, “Na, dayn ha sabab sin parachaya iban pangandul niyu, maawn in piyangayuꞌ niyu.” ");
INSERT INTO tsg_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na, saruun-duun da nagbalik in pangitaꞌ nila. Nagꞌibut-ibut tuud hi Īsa kanila, laung niya, “Ayaw kamu magsuysuy minsan kansiyu pasal ini!” ");
INSERT INTO tsg_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Sagawaꞌ pagꞌīg nila, nanuysuy da sila pa manga tau ha katilingkal sin paghulaꞌ yadtu pasal sin nahinang hi Īsa kanila. ");
INSERT INTO tsg_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ha sasang sūng na gumuwaꞌ in duwangka-tau yadtu dayn didtu, awn na isab hambuuk tau diyā mawn kan Īsa. In tau ini naumaw pasal siyusūd siya saytan. ");
INSERT INTO tsg_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Sagawaꞌ pagpaguwaꞌ hi Īsa sin saytan dayn ha baran niya magtūy da isab in tau yadtu nakabichara. Nahaylan in katān tau nakakitaꞌ, laung nila pakaniya-pakaniya “Dayn sin tagnaꞌ walaꞌ kitaniyu nakakitaꞌ sin biyaꞌ ha ini dī ha hulaꞌ sin bangsa natuꞌ Israil.” ");
INSERT INTO tsg_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Sagawaꞌ laung sin manga tau Parisi, “Nakuraꞌ sin manga Saytan sayan in nagdihil kaniya barakat pagpaguwaꞌ sin manga saytan.” ");
INSERT INTO tsg_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Manjari nalatag hi Īsa in katān dāira iban manga kawman ha paghulaꞌ yadtu. Nanghinduꞌ siya ha manga langgal iban nagnasīhat siya sin Baytaꞌ Marayaw pasal sin pamarinta sin Tuhan. Lāgiꞌ piyauliꞌ niya in manga tau amu in nasasakit sin indaginis lamma iban sakit. ");
INSERT INTO tsg_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pagkitaꞌ hi Īsa sin baanan tau, landuꞌ tuud siya limuuy kanila sabab ha lawm kasusahan sila iban wayruun makatabang kanila. Biyaꞌ sila sapantun manga bili-bili wayruun magꞌiipat kanila. ");
INSERT INTO tsg_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Sakali laung hi Īsa pa manga mulid niya, “In manga tau (mabayaꞌ na magad ha hinduꞌ sin Baytaꞌ Marayaw) biyaꞌ sila sapantun manga bunga sin tiyanum, amu in tūp na tuud pusuun, sagawaꞌ hangkatiyuꞌ da in magpupusuꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Hangkan pangayuꞌ-ngayuꞌ kamu duwaa pa tagdapu sin uma, bang mayan siya magdaak mari manga tau tumabang magpusuꞌ sin manga bunga sin tiyanum.” ");
INSERT INTO tsg_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Na, pagꞌubus yadtu tiyawag hi Īsa in hangpuꞌ tagduwa mulid niya mawn kaniya ampa niya dīhilan katān sin kapatutan magpaguwaꞌ saytan dayn ha baran sin tau iban manguliꞌ sin sakit ginisan na. ");
INSERT INTO tsg_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Na, amuna ini in ngān sin hangpuꞌ tagduwangka-tau kiyawakilan hi Īsa: ha unahan hi Simun amu in pagngānan isab hi Pitrus, iban sin taymanghud niya hi Andariyas, ampa hi Yaꞌkub iban sin taymanghud niya hi Yahiya, amu in anak hi Sibidi. ");
INSERT INTO tsg_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Sumunuꞌ hi Pilip iban hi Bartulumi, ampa hi Tumas iban hi Matiyu, amu in mangangawaꞌ sukay pa parinta, ampa isab hi Yaꞌkub amu in anak hi Alpa. Sumunuꞌ hi Tadiyus, ");
INSERT INTO tsg_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ampa hi Simun amu in bantug simulang ha parinta Rūm. In hinapusan hi Judas, tau dayn ha Kiriyud, amu in manipu kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","In hangpuꞌ tagduwangka-tau ini diyaak hi Īsa manaw. Ha way pa sila miyanaw biyandaan sila hi Īsa, laung niya “Ayaw kamu madtu pa hulaꞌ sin manga tau bukun bangsa Yahudi atawa pa manga dāira sin manga tau Samariya. ");
INSERT INTO tsg_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Sagawaꞌ kadtu kamu pa manga tau bangsa Israil, amu in biyaꞌ bili-bili nalalawaꞌ dayn ha magꞌiipat kanila. ");
INSERT INTO tsg_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kadtu kamu magnasīhat sin in pamarinta sin Tuhan masuuk na dumatung mari! ");
INSERT INTO tsg_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Paulia niyu in manga nasasakit. Buhia niyu magbalik in manga tau patay. Paulia niyu in manga tau īipul, iban paguwaa niyu in manga saytan dayn ha baran sin manga tau. Timaymaꞌ kamu dayn kākuꞌ sin manga hinang yan ha wayruun bayad. Na, pangdihil kamu ha wayruun da isab bayad. ");
INSERT INTO tsg_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ayaw kamu magdā bulawan atawa pilak ha lawm bulsa niyu. Minsan pisita ayaw kamu magdā. ");
INSERT INTO tsg_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ayaw kamu isab dumā pagluluunan sin kapanyapan niyu atawa tamungun dugaing dayn sin ha baran niyu, atawa tawmpaꞌ iban tungkud, sabab in maghihinang tūp balanjaan sin manga tau piyaghulas-sangsaan niya. ");
INSERT INTO tsg_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Bang kamu dumatung pa hambuuk dāira atawa hambuuk kawman, paglawag kamu tau amu in mabayaꞌ gabanan niyu, hāti duun kamu humantiꞌ kanila ha salugay niyu duun ha hulaꞌ yan. ");
INSERT INTO tsg_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Bang kamu sumūd pa lawm bāy sin tau pamung kamu, laung niyu, ‘Bang mayan kamu ha lawm kasannyangan sadja.’ ");
INSERT INTO tsg_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Manjari bang kamu taymaun sin tau ha lawm bāy yan, na datungan sila sin kasannyangan amu in piyagꞌiyan niyu. Sagawaꞌ bang sila diꞌ tumaymaꞌ kaniyu, bawia niyu in kasannyangan yan dayn kanila. ");
INSERT INTO tsg_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Na bang awn manga tau ha bāy iban dāira amu in diꞌ tumaymaꞌ kaniyu atawa diꞌ dumungug sin panghinduꞌ niyu, īg kamu dayn ha lugal yan. Paspasi niyu in bagunbun dayn ha siki niyu (ha supaya mapakitaꞌ niyu in tandaꞌ sin diꞌ sila tūpun parulihun niyu). ");
INSERT INTO tsg_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Baytaan ta kamu, bang ha adlaw paghukum na, mabuggat in hukuman hibutang sin Tuhan pa manga tau ha kawman yan. Labi pa in buggat niya dayn sin hukuman hibutang pa manga tau ha dāira Sudum iban dāira Gumura,” (amu in manga tau bakas tanyag in kangīan nila). ");
INSERT INTO tsg_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Dungug kamu,” laung hi Īsa. “Yari kamu sūng daakun ku pa manga tau. Biyaꞌ kamu sapantun bili-bili pakadtuun pa lawm baanan iruꞌ talun amu in mangangaun kanila. Hangkan subay kamu taga akkal tuud iban subay mabuntul tuud in lawm atay niyu. ");
INSERT INTO tsg_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Jaga kamu, sabab ha waktu susūngun awn manga tau sumaggaw kaniyu ampa kamu hiungsud pa lawm lima sin manga manghuhukum, iban lubakan kamu sin manga tau duun ha lawm manga langgal. ");
INSERT INTO tsg_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Marā da isab kamu pa alupan sin manga gubnul iban manga sultan supaya hukumun sabab in kamu agad kākuꞌ. Na, bang kamu marā na madtu, makabaytaꞌ na kamu kanila iban pa manga tau kaibanan, amu in bukun bangsa Yahudi, pasal sin Baytaꞌ Marayaw pasal sin pamarinta sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bang kamu hisampay na pa paghuhukuman ayaw kamu masusa bang unu in hibichara niyu atawa bang biyaꞌ diin in kaagi niyu mamichara. ");
INSERT INTO tsg_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Sabab in lapal hibichara niyu bukun dayn ha lawm pamikil niyu, saꞌ dayn ha Rū sin Tuhan, Amaꞌ niyu, amu in mamichara sin manga kabtangan gumuwaꞌ dayn ha simud niyu. ");
INSERT INTO tsg_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ha waktu susūngun maggaus na in magtalianak. Hitukbal sin tau in taymanghud niya hipapatay, iban hitukbal da isab sin amaꞌ in anak niya hipabunuꞌ iban umatu na in anak ha maas nila iban hipapatay nila in maas nila. ");
INSERT INTO tsg_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Na, kamu isab manga mulid ku, karugalan kamu sin tau katān sabab in kamu agad kākuꞌ. Sagawaꞌ hisiyu-siyu in sumandal sin manga kasigpitan iban kabinsanaan yan sampay pa kahinapusan, tantu malappas da siya. ");
INSERT INTO tsg_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bang kamu binasahun nila ha hambuuk dāira, paguy kamu pa dugaing dāira. Baytaan ta kamu, ha diꞌ niyu pa malatag katān nasīhatan in manga dāira ha hulaꞌ natuꞌ ini Israil, in aku amu in Anak Mānusiyaꞌ, magbalik na mari pa dunya. ");
INSERT INTO tsg_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Wayruun anak mulid in mataas dayn ha guru niya. Damikkiyan da isab wayruun tindug in makawasa dayn ha nakuraꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Hangkan subay magsukul in mulid makasibuꞌ ha guru niya, iban subay magsukul in tindug mabiyaꞌ sin nakuraꞌ niya. Na, bang in aku amu in nakuraꞌ sin manga tindug ku tiyawag nila nakuraꞌ sin saytan, na lubaꞌ pa in kamu manga tindug ku in diꞌ tawagun nila sin manga ngān mangīꞌ! ");
INSERT INTO tsg_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Hangkan sa ayaw kamu mabugaꞌ ha manga tau. Karnaꞌ unu-unu in tiyatapuk tantu gumuwaꞌ da. Unu-unu isab in līlibun tantu kaingatan da. ");
INSERT INTO tsg_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Unu-unu in hibaytaꞌ ku kaniyu ha katigidluman subay niyu hibaytaꞌ magbalik ha kasawahan, iban unu-unu in kiyahagas-hagas kaniyu, subay niyu hipamahalayak pa katān mānusiyaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ayaw kamu mabugaꞌ ha manga makapatay sin baran niyu saꞌ diꞌ makapatay sin nyawa niyu, sagawaꞌ subay Tuhan in kabugaan niyu, sabab siya in makasiksaꞌ sin baran iban nyawa niyu ha lawm narkaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Pikila niyu ba in manga manuk-manuk asibiꞌ yan, biyaꞌ wayruun tuud halgaꞌ nila. Mabī ta duwa, hambuuk sīn. Malayngkan, wayruun da isab minsan hambuuk manuk-manuk in mahulug pa lupaꞌ bang bukun kabayaan sin Tuhan, Amaꞌ niyu. ");
INSERT INTO tsg_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na, damikkiyan in kamu minsan in taud sin buhuk ha ū niyu naiitung katān sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Hangkan sa, ayaw kamu mabugaꞌ, sabab labi kamu māyuꞌ mahalgaꞌ dayn ha manga manuk-manuk minsan pila in taud nila. ");
INSERT INTO tsg_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Hisiyu-siyu in magsabunnal ha katauran tau sin agad siya kākuꞌ, magsabunnal da isab aku ha alupan sin Tuhan, Amaꞌ ku ha surgaꞌ, sin in siya agad kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Sagawaꞌ hisiyu-siyu in mamaylu ha katauran tau, sin bukun siya agad kākuꞌ, mamaylu da isab aku ha alupan sin Tuhan, Amaꞌ ku ha surgaꞌ, sin bukun siya agad kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ayaw kamu magpikil sin in pagkari ku pa dunya nakarā kasannyangan, sabab aku in nakalingug ha manga mānusiyaꞌ. Aku in mahinang puun-sabab sin pagsaggaꞌ iban pagbunuꞌ sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Dayn ha pasal ku in magtalianak magsaggaꞌ-siyaggai. In anak usug sumaggaꞌ ha amaꞌ niya iban in anak babai sumaggaꞌ ha inaꞌ niya. Dayn ha pasal ku in ugangan babai, sumaggaꞌ ha ugangan niya isab babai. ");
INSERT INTO tsg_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","In mahinang umbul hambuuk banta sin tau amuna in manga lahasiyaꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Hisiyu-siyu in malasa ha amaꞌ niya atawa ha inaꞌ niya labi dayn sin lasa niya kākuꞌ, na diꞌ siya tūpun magad kākuꞌ. Damikkiyan hisiyu-siyu in malasa ha anak niya usug atawa babai, labi dayn sin lasa niya kākuꞌ, na diꞌ siya tūpun magad kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Iban hisiyu-siyu in mabayaꞌ magad kākuꞌ subay siya mangaku sin katān haggut-pasuꞌ minsan siya mapatay ha pasal ku. Bang bukun da, na diꞌ siya tūpun magad kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Hisiyu-siyu in maūg ha kabuhiꞌ niya amu in magpikil sadja sin kabayaan niya, tantu mapatay da siya. Saꞌ hisiyu-siyu in diꞌ maūg ha kabuhiꞌ niya minsan siya mapatay ha pasal ku, tantu makabaak siya kabuhiꞌ salama-lama. ");
INSERT INTO tsg_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Hisiyu-siyu in tumaymaꞌ kaniyu, tiyaymaꞌ nila da isab aku, iban hisiyu-siyu in tumaymaꞌ kākuꞌ, tiyaymaꞌ nila da isab in nagpakari kākuꞌ pa dunya. ");
INSERT INTO tsg_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Bang awn tau kiyawakilan sin Tuhan magnasīhat mawn pa manga tau, hisiyu-siyu in tumaymaꞌ kaniya sabab-karnaꞌ kiyawakilan siya sin Tuhan, makasāw sila sin tungbas hirihil pa tau yan amu in kiyawakilan sin Tuhan. Damikkiyan da isab bang awn tau mabuntul makakawn pa manga tau, hisiyu-siyu in tumaymaꞌ kaniya sabab tau mabuntul siya, awn isab bahagiꞌ niya sin tungbas sin tau mabuntul yan. ");
INSERT INTO tsg_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Baytaan ta kamu, minsan dakuman tubig hagpay in hipanghulmat niyu ha hambuuk tau agad kākuꞌ, tantu tungbasan da kamu. Minsan tau way guna niya, apabila siya agad kākuꞌ, in tau manghulmat kaniya tantu tungbasan da siya pa marayaw.” ");
INSERT INTO tsg_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pagꞌubus hi Īsa nagdaak ha hangpuꞌ tagduwa mulid niya, minīg na siya dayn didtu. Miyanaw siya dayn ha hambuuk kawman pa hambuuk kawman ha paghulaꞌ yadtu nanghinduꞌ iban nagnasīhat. ");
INSERT INTO tsg_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na, saꞌbu ha lawm kalabusu hi Yahiya amu in Mangliliguꞌ, kiyarungugan niya bang unu in hinang sin Almasi. Sakali diyaak niya in manga mulid niya kaibanan madtu kan Īsa mangasubu. ");
INSERT INTO tsg_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Nākawn mayan sila kan Īsa, laung nila, “Tuwan, baytai kami kunuꞌ. Ikaw na ka in piyagꞌiyan hi Yahiya amu in dumatung mari atawa awn pa huwat-huwatun namuꞌ dumatung dugaing dayn kaymu?” ");
INSERT INTO tsg_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","In sambung hi Īsa kanila, laung niya, “Balik na kamu iban baytai niyu hi Yahiya sin manga kīkitaꞌ iban diyurungug niyu! ");
INSERT INTO tsg_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","In tau bakas buta, makakitaꞌ na; in bakas pingkaꞌ, makapanaw na mabuntul; in manga tau bakas īipul, malanuꞌ na in baran nila; in bakas bisu, makarungug na; sampay tau miyatay, nabuhiꞌ na nagbalik; iban piyagnanasīhat na in Baytaꞌ Marayaw ha manga miskin. ");
INSERT INTO tsg_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Na, hisiyu-siyu in diꞌ maghawal-hawal mangandul kākuꞌ, makūg-makuyag tuud siya.” ");
INSERT INTO tsg_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ha sasang sin manga mulid hi Yahiya sūng na muwiꞌ, namichara na hi Īsa pa manga tau mataud natitipun sin pasal hi Yahiya. Laung niya, “Ha waktu miyadtu kamu kimitaꞌ kan Yahiya didtu ha hulaꞌ paslangan mahunit paghulaan, unu in hiyuwat-huwat niyu kakitaan didtu? Hambuuk tau ka siya amu in magpinda-pinda in pikilan biyaꞌ sin dahun parang marā sin hangin madtu mari? Tantu bukun. ");
INSERT INTO tsg_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Unu bahaꞌ in piyagkitaꞌ niyu madtu? Hambuuk tau ka amu in nagtatamung sin mahargaꞌ? Tantu bukun. In tau nagtatamung biyaꞌ ha yan naghuhulaꞌ ha lawm astanaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Baytai niyu aku tuud, unu in kiyadtu niyu kītaꞌ? Hambuuk nabi? Bunnal hambuuk siya nabi, sagawaꞌ in kiyakitaan niyu mataas māyuꞌ dayn ha manga kaibanan nabi. ");
INSERT INTO tsg_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Sabab hi Yahiya in piyagꞌiyan sin Kitab, amu agi sin Tuhan, ‘Pakadtuun ku in kiyawakilan ku muna dayn kaymu ha supaya maparayaw niya in dān labayan mu.’” ");
INSERT INTO tsg_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Laung hi Īsa ha manga tau, “Baytaan ta kamu tuud. Wayruun pa mānusiyaꞌ dayn sin tagnaꞌ kaawn sin mānusiyaꞌ in labi mataas dayn kan Yahiya amu in Mangliliguꞌ. Sagawaꞌ in tau katān ha lawm pamarintahan sin Tuhan sampay pa manga tau amu in bukun mataas in hinang, mataas sila dayn kan Yahiya. ");
INSERT INTO tsg_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Dayn ha waktu timagnaꞌ hi Yahiya nagnasīhat sampay pa adlaw ini, mataud tau in simulay nagtuyuꞌ-tuyuꞌ umingat pasal sin pamarinta sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Sampay pa waktu gimuwaꞌ hi Yahiya, in katān nabi iban sin saraꞌ piyanaug dayn kan Musa namaytaꞌ pasal sin pamarinta sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nagbaytaꞌ isab in hambuuk nabi sin dumatung hi Ilyas pa dunya. Na, bang kamu mabayaꞌ magkahagad sin baytaꞌ sin manga nabi, hi Yahiya ini amuna hi Ilyas piyagꞌiyan sin manga nabi. ");
INSERT INTO tsg_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Na, sasukuꞌ sin kamu nakarungug, dunguga niyu tuud in biyaytaꞌ ku yan kaniyu.” ");
INSERT INTO tsg_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Laung hi Īsa, “Unu in hikapagsawpama ku pasal sin addat sin manga tau ha masa ini? Na, biyaꞌ sila manga bataꞌ-bataꞌ naglilingkud ha halaman tabuꞌ. In hangka-tumpuk bataꞌ-bataꞌ gumasud pa dugaing ha hansipak, laung nila, ");
INSERT INTO tsg_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Magpangalay-pangalay kitaniyu.’ Na in sambung sin kaibanan bataꞌ-bataꞌ, laung nila, ‘Diꞌ kami mabayaꞌ.’ Sakali laung sin ha hansipak, ‘Magluguꞌ-luguꞌ kitaniyu makaulung-ulung.’ Na, in sambung isab sin kaibanan, laung nila, ‘Diꞌ kami mabayaꞌ.’ Biyaꞌ da isab ha yan in manga tau masa ini. (Wayruun unu-unu makasulut kanila.) ");
INSERT INTO tsg_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","In hi Yahiya mahumu diꞌ magkaun, magpuasa sadja siya, iban diꞌ siya magꞌiinum sin unu-unu makahilu. Sakali laung sin manga tau, ‘Siyusūd siya sin saytan.’ ");
INSERT INTO tsg_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ampa in aku, amu in Anak Mānusiyaꞌ, magkaun iban magꞌinum. Sakali laung sin manga tau, ‘Kitaa niyu ba in tau yan. Dahal tuud iban magꞌiinum. Magbagay iban sin tau mangangawaꞌ sukay pa parinta iban sin manga baldusa kaibanan!’ Sagawaꞌ” laung hi Īsa, “diꞌ da maunu minsan niyu diꞌ kabayaan in hinang namuꞌ kay Yahiha karnaꞌ in kasabunnalan sin ingat dayn ha Tuhan kakitaan da ha manga hinang amu in biyaꞌ bunga niya.” ");
INSERT INTO tsg_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Manjari piyagꞌamahan hi Īsa in manga tau naghuhulaꞌ ha manga kawman amu in kiyapakitaan niya sin manga muꞌjijat nahinang niya, sabab walaꞌ sila nagtawbat sin manga dusa nila. ");
INSERT INTO tsg_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Laung hi Īsa kanila, “Anduꞌ, in kamu yan manga tau Kurasin iban sin tau Bitsayda. Diꞌ hikasipat in kasusahan niyu ha susūngun! Sabab maytaꞌ? Mataud muꞌjijat bakas piyakitaꞌ kaniyu, sagawaꞌ walaꞌ niyu da iyasip. Malayngkan bang in manga muꞌjijat yan napakitaꞌ muna ha manga tau ha dāira Tirus iban ha dāira Sidun, tantu magtūy sila magsulug badjuꞌ karut, iban magbutang abu pa ū nila, tandaꞌ sin pagtawbatan nila na in dusa nila! ");
INSERT INTO tsg_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Baytaan ta kamu, bang ha adlaw paghukum na ha manga mānusiyaꞌ, mabuggat in hukuman hibutang sin Tuhan kaniyu. Labi pa in buggat niya dayn sin hukuman hibutang pa manga tau Tirus iban manga tau Sidun. ");
INSERT INTO tsg_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na, in kamu isab manga tau Kapirnaum, nagbantug-bantug kamu sin makasampay kamu pa surgaꞌ. Sagawaꞌ narkaꞌ in sampayan niyu. Bang in manga muꞌjijat amu in piyakitaꞌ duun kaniyu kiyapakitaꞌ nakauna ha manga tau ha dāira Sudum, tantu sampay bihaun masi namān duun in dāira Sudum! ");
INSERT INTO tsg_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Na, baytaan ta kamu, bang ha adlaw paghukum na ha manga mānusiyaꞌ, mabuggat pa in hukuman hibutang sin Tuhan kaniyu dayn sin hukuman hibutang niya ha manga tau Sudum,” (amu in manga tau bakas tanyag in kangīan nila). ");
INSERT INTO tsg_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Pagꞌubus piyagꞌamahan hi Īsa in manga tau yadtu, nangarap siya pa Tuhan. Laung niya, “Ū Amaꞌ ku, ikaw da in makapagbayaꞌ sin unu-unu katān ha langit iban dunya! Magsukul tuud aku kaymu, sabab in piyaglimbung mu dayn ha tau taga ingat sampay taga pangadjiꞌ, amuna in piyahāti mu ha manga tau awam. ");
INSERT INTO tsg_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Na, in yan mattan tuud, Amaꞌ ku, sabab biyaꞌ ha yan in kabayaan mu maawn.” ");
INSERT INTO tsg_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Pagꞌubus ampa namichara hi Īsa pa manga tau, laung niya, “Kiyarihil na kākuꞌ sin Amaꞌ ku in unu-unu katān. Wayruun makaingat tuud kākuꞌ luwal da in Amaꞌ ku. Damikkiyan da isab wayruun makaingat tuud ha Amaꞌ ku luwal da aku, amu in Anak niya, iban sin manga tau amu in miyaksud ku paingatun. ");
INSERT INTO tsg_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Kari kamu sasukuꞌ sin kamu amu in kiyabubuggatan maghinang sin hinang daakan sin agama iban kiyasisigpitan sin kasusahan, ampa ku dihilan kasannyangan in lawm atay niyu. ");
INSERT INTO tsg_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pagguru kamu kākuꞌ iban kahagara niyu in panghinduꞌ ku, sabab marayaw aku iban mababaꞌ in pangatayan ku. Dayn duun kamu makabaak kasannyangan. ");
INSERT INTO tsg_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sabab in panghinduꞌ ku kaniyu maluhay agarun. In daakan ku amu in hipatanggung ku kaniyu, magaan da.” ");
INSERT INTO tsg_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Manjari pagꞌubus yadtu, saꞌbu adlaw Sabtuꞌ, amu in adlaw paghali-hali iban pagpudji pa Tuhan sin manga Yahudi, in hi Īsa iban sin manga mulid niya limabay dayn ha lawm uma. Sakali nangutul bunga sin tiyanum (biyaꞌ lupa pāy), in manga mulid niya, ampa nila kiyaun sabab hiyapdiꞌ na sila. ");
INSERT INTO tsg_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pagkitaꞌ sin manga Yahudi pagtawagun Parisi sin hinang nila, laung nila kan Īsa, “Uy, langgal saraꞌ sin agama in hīnang sin manga mulid mu sabab adlaw paghali-hali iban pagpudji pa Tuhan adlaw ini!” ");
INSERT INTO tsg_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Laung hi Īsa kanila, “Maytaꞌ, walaꞌ niyu ka nabacha ha lawm Kitab in hīnang hi Daud iban sin manga tau niya ha waktu hiyapdiꞌ sila? ");
INSERT INTO tsg_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Simūd sila pa lawm Bāy sin Tuhan ampa sila kimaun sin kakaun bakas iyungsud pa Tuhan. In hīnang nila langgal saraꞌ sin agama, sabab amura manga imam in makajari kumaun sin kakaun bakas iyungsud pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Iban walaꞌ niyu ka nabacha ha lawm Kitab Tawrat sin in manga imam maghinang da ha lawm sin Bāy sin Tuhan sakahabaꞌ adlaw paghali-hali iban pagpudji pa Tuhan, minsan da langgal saraꞌ in maghinang ha adlaw yan? Sagawaꞌ walaꞌ sila nakarusa. ");
INSERT INTO tsg_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“Na, ini in hibaytaꞌ ku kaniyu. Awn dī bihaun kaniyu in labi in kawasa dayn ha saraꞌ agama. ");
INSERT INTO tsg_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Awn Parman sin Tuhan kiyasulat ha lawm Kitab, amu agi, ‘Bukun mahalgaꞌ kākuꞌ in manga hayup hiungsud niyu pagkulbanan, sagawaꞌ in kabayaan ku tuud, bayngꞌulungun kamu ha pagkahi niyu.’ Na, bang niyu kiyahātihan tuud in maana sin himumūngan yan” laung hi Īsa, “walaꞌ niyu na biyutangan hukuman in tau amu in bunnal walaꞌ nakarusa. ");
INSERT INTO tsg_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","(In manga mulid ku walaꞌ nakarusa sabab) in Anak Mānusiyaꞌ amu in makapagbayaꞌ umiyan bang unu in mapatut hinangun ha adlaw paghali-hali iban pagpudji pa Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Manjari limanjal na hi Īsa sin panaw niya. Miyadtu siya simūd pa lawm langgal. ");
INSERT INTO tsg_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Duun ha lawm langgal awn hambuuk tau nakukumay in lima niya. Iban awn da isab duun manga tau amu in mabayaꞌ manglawag dusa kan Īsa ha supaya nila siya katuntutan. Laung nila, “Makajari ka ha saraꞌ sin agama natuꞌ magpauliꞌ ha nasasakit ha adlaw paghali-hali iban pagpudji pa Tuhan atawa diꞌ?” ");
INSERT INTO tsg_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","In sambung hi Īsa, laung niya, “Bang sawpama awn hambuuk bili-bili niyu ampa mahulug pa lawm lungag ha waktu adlaw paghali-hali iban pagpudji pa Tuhan diꞌ niyu ka kawaun dayn ha lawm lungag in bili-bili? ");
INSERT INTO tsg_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","In tau labi mahargaꞌ dayn sin bili-bili! Hangkan wayruun ngīꞌ niya ha lawm saraꞌ agama bang kamu huminang sin marayaw ha pagkahi niyu ha adlaw paghali-hali iban pagpudji pa Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Sakali namung hi Īsa ha tau nakukumay in lima niya, laung niya, “Hunata in buktun mu.” Na, hiyunat na sin tau pikuk in buktun niya. Saruun-duun miyuntul nagbalik in buktun niya biyaꞌ da isab sin hansipak buktun niya. ");
INSERT INTO tsg_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Na, gimuwaꞌ dayn ha lawm langgal in manga Parisi ampa sila nagꞌisun bang biyaꞌ diin in kapatay nila kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sakali nakarungug mayan hi Īsa sin isun sin manga Parisi, minīg siya dayn ha lugal yaun. Pagꞌīg niya, mataud tau in miyurul kaniya. Napauliꞌ niya in katān nasasakit, ");
INSERT INTO tsg_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","sagawaꞌ ībut-ibutan niya tuud in manga tau napauliꞌ niya diꞌ pasuysuyun sin pasal niya pa manga tau (ha supaya siya diꞌ mabantug pa manga tau). ");
INSERT INTO tsg_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Na in manga hīnang niya yan nakarihil kamakbulan sin Parman sin Tuhan kiyasulat hi Nabi Isayas ha lawm Kitab, amu agi, ");
INSERT INTO tsg_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Yari in daraakun napīꞌ ku, siya in kalasahan ku iban makasulut tuud siya sin atay ku. Paruunun ku kaniya in Rū ku, bat niya mapamahalayak in pasal sin kabuntulan sin hukuman ku ha mānusiyaꞌ katān. ");
INSERT INTO tsg_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Sumagawaꞌ diꞌ siya dumā maglugat atawa mamahit bang siya mamichara ha manga tau iban diꞌ siya magbichara matanug ha manga karān-dānan. ");
INSERT INTO tsg_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mahanunut siya ha manga tau mahukaꞌ in pangandul nila pa Tuhan, iban tiyatabang niya in hisiyu-siyu mangandul kaniya. Iban diꞌ tuud siya dumuhung sampay diꞌ niya mapatanyag tuud in kasabunnalan iban mapapanaw in kabuntulan sin hukuman sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Siya da in hiyuhuwat-huwat kapangandulan sin mānusiyaꞌ katān.” ");
INSERT INTO tsg_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Manjari pagꞌubus yadtu awn hambuuk tau siyusūd saytan diyā mawn kan Īsa. In tau ini nabuta iban naumaw sabab siyusūd siya saytan. Sagawaꞌ napaguwaꞌ hi Īsa in saytan dayn ha lawm baran sin tau ini, hangkan makakitaꞌ iban makabichara na siya. ");
INSERT INTO tsg_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Na, nahaylan tuud in manga tau nangingitaꞌ-ngitaꞌ duun. Laung nila, “Siya na bahaꞌ ini in Almasi, hambuuk panubuꞌ hi Daud?” ");
INSERT INTO tsg_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pagdungug sin manga Parisi sin bichara sin manga tau, simambung sila, laung nila, “Mapaguwaꞌ niya in manga saytan dayn ha manga tau siyusūd saytan sabab dihilan siya barakat hi Bilsibul, amu in Nakuraꞌ sin manga Saytan, huminang sin biyaꞌ ha yan.” ");
INSERT INTO tsg_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sagawaꞌ kiyaingatan hi Īsa bang unu in ha lawm pamikil nila, hangkan, piyamungan niya sila, laung niya, “Bang in manga tau ha hambuuk hulaꞌ nababahagiꞌ, nagdurugaing-dugaing agaran iban magbunuꞌ-biyunui, na, in hulaꞌ yan diꞌ lumugay magkangīꞌ da. Damikkiyan bang in manga tau hangka-kawman atawa maglahasiyaꞌ magsaggaꞌ-siyaggai, na diꞌ lumugay kumangīꞌ da sila. ");
INSERT INTO tsg_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Na, hangkan bang sawpama bat dayn ha Saytan Puntukan in barakat ku magpaguwaꞌ ha manga saytan, na hāti niya magkuntara in Saytan Puntukan iban sin manga tindug niya lāgiꞌ diꞌ lumugay kumangīꞌ na sila! ");
INSERT INTO tsg_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Na, in agi niyu hi Bilsibul in nagdihil kākuꞌ barakat magpaguwaꞌ sin manga saytan. Na, bang bunnal in agi niyu yan, na hisiyu bahaꞌ isab in nagdihil barakat ha manga tindug niyu magpaguwaꞌ saytan? In manga tindug niyu amuna in mamaytaꞌ sin kasāan sin pamikil niyu! ");
INSERT INTO tsg_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tantu in barakat ku magpaguwaꞌ saytan bukun dayn ha Saytan Puntukan, sabab in yan nahinang ku dayn ha kusug sin Rū sin Tuhan. Na, amu yan in tandaꞌ magpakitaꞌ kaniyu sin in pamarinta sin Tuhan yari na dī bihaun kaniyu.” ");
INSERT INTO tsg_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","(Diyalil hi Īsa in Saytan Puntukan pa hambuuk tau makusug.) Laung niya, “Wayruun tau makasūd manglangpas pa lawm bāy sin hambuuk tau makusug bang siya diꞌ kahukutan naa muna. Na, bang siya kahukutan na, makawaꞌ na in unu-unu katān ha lawm bāy niya. ");
INSERT INTO tsg_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Hisiyu-siyu in bukun agad kākuꞌ, in siya yan kimukuntara kākuꞌ, iban hisiyu-siyu in diꞌ tumabang kākuꞌ magtipun magpatibuuk ha manga tau, bat sila masukuꞌ sin Tuhan, biyaꞌ niya da piyulak-palik in manga tau. ");
INSERT INTO tsg_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Hangkan, baytaan ta kamu, in katān dusa iban pamung mangīꞌ pa Tuhan sin manga tau, ampunun da sin Tuhan, sagawaꞌ hisiyu-siyu in mamung sin mangīꞌ ha Rū sin Tuhan, diꞌ siya ampunun sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Lāgiꞌ, hisiyu-siyu in mamung mangīꞌ kākuꞌ, amu in Anak Mānusiyaꞌ, ampunun da siya sin Tuhan. Sagawaꞌ hisiyu-siyu in mamung sin mangīꞌ ha Rū sin Tuhan, diꞌ siya maampun kasaumulan. ");
INSERT INTO tsg_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Biyaꞌ sawpama sin hambuuk kahuy, bang in kahuy yan marayaw, tantu in bunga niya marayaw da isab. Damikkiyan, bang in kahuy bukun marayaw, in bunga niya bukun da isab marayaw. Karnaꞌ kaingatan taniyu dayn ha bunga niya bang in kahuy yan marayaw atawa bukun. ");
INSERT INTO tsg_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","In kamu yan panipu tuud! Asal wayruun sa yan marayaw hikabichara niyu sabab asal mangīꞌ in lawm pamikil niyu. Karnaꞌ unu-unu in ha lawm pamikil sin tau amura isab in hikabichara niya. ");
INSERT INTO tsg_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Sabab in tau marayaw, in hinang iban bichara niya marayaw da isab, sabab marayaw in ha lawm pamikil niya. Sagawaꞌ in tau mangīꞌ, in hinang iban bichara niya mangīꞌ da isab, sabab mangīꞌ in ha lawm pamikil niya. ");
INSERT INTO tsg_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Na, ini in hibaytaꞌ ku kaniyu. Bang dumatung na in adlaw paghukum ha manga mānusiyaꞌ, in tau katān subay mamaytaꞌ pasal sin manga katān bichara wayruun kapūsan bakas kiyapamung nila. ");
INSERT INTO tsg_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Sabab in hukuman hibutang sin Tuhan kanila kawaun dayn ha manga bichara kiyapamung nila, ampunun na ka sila atawa siksaun.” ");
INSERT INTO tsg_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pagꞌubus namung in manga guru sin saraꞌ agama iban sin manga Parisi, laung nila, “Tuwan, mabayaꞌ kami kumitaꞌ hambuuk muꞌjijat dayn kaymu amu in tandaꞌ sin barakat mu.” ");
INSERT INTO tsg_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Sagawaꞌ in sambung hi Īsa, laung niya, “In manga tau sin masa bihaun ini landuꞌ tuud mangīꞌ iban miyutas na dayn ha Tuhan! Mabayaꞌ kamu kumitaꞌ muꞌjijat tandaꞌ sin barakat ku, sagawaꞌ diꞌ ta kamu pakitaun unu-unu muꞌjijat, luwal da amu in muꞌjijat biyaꞌ sin barakat kimugdan kan Nabi Yunus sin masa nakauna yadtu. ");
INSERT INTO tsg_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Karnaꞌ in hi Yunus natūn sin istaꞌ dakulaꞌ, iban tūy dūm, tūy adlaw siya ha lawm tiyan sin istaꞌ dakulaꞌ. Damikkiyan, in Anak Mānusiyaꞌ, ha susūngun ha lawm tūy dūm-adlaw duun siya ha lawm kubul. ");
INSERT INTO tsg_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Na, bang dumatung na in adlaw paghukum sin Tuhan ha manga mānusiyaꞌ katān, in manga tau dayn ha hulaꞌ Niniba manaksil da kaniyu. Sabab in sila, pagdungug nila sin nasīhat hi Yunus, magtūy sila nagkahagad iban nagtawbat sin manga dusa nila. Na, baytaan ta kamu, awn dī bihaun in labi pa mataas dayn kan Yunus! ");
INSERT INTO tsg_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Iban duun da isab ha adlaw paghukum ha manga mānusiyaꞌ, in hambuuk pangiyan dayn ha hulaꞌ Siba manaksil da isab kaniyu. Sabab in siya minsan malayuꞌ in hulaꞌ niya miyadtu siya dimungug sin manga hinduꞌ marayaw hi Sultan Sulayman. Na, baytaan ta kamu, awn dī bihaun in labi pa marayaw manghinduꞌ dayn kan Sulayman! ");
INSERT INTO tsg_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Na, bang in saytan makaguwaꞌ na dayn ha lawm baran sin tau, manglunsulan na yan ha hulaꞌ paslangan mahunit paghulaan, lumawag lugal paghali-halihan niya, saꞌ diꞌ siya makabāk lugal. ");
INSERT INTO tsg_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Na, mamung na in saytan pa baran niya, laung niya, ‘Magbalik na aku pa lawm baran sin tau bakas kiyabutangan ku.’ Pagsūd niya magbalik, kītaꞌ niya wayruun dugaing nakasubli kaniya ha lawm baran sin tau, lāgiꞌ malanuꞌ iban mahawan in lawm niya. ");
INSERT INTO tsg_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Na, gumuwaꞌ siya magbalik, ampa siya dumangin pitu saytan labi pa mangīꞌ dayn kaniya, ubus ampa sila sumūd pa lawm baran sin tau. Na, bang sila makasūd na katān, in kahālan sin tau yan magduruhun in ngīꞌ dayn sin nakauna hambuuk da in saytan ha lawm baran niya. Na, biyaꞌ da isab ha yan in kumugdan ha manga tau mangīꞌ ha masa bihaun ini.” ");
INSERT INTO tsg_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ha saꞌbu hi Īsa nanghihinduꞌ ha manga tau nākawn in inaꞌ niya iban manga taymanghud niya usug. Duun sila timindug ha guwaꞌ ampa sila nagparā lapal sin mabayaꞌ sila dumā magbichara kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Na, awn hambuuk tau namaytaꞌ kan Īsa, laung niya, “Tuwan, in inaꞌ mu iban manga taymanghud mu yaun nagtitindug ha guwaꞌ. Mabayaꞌ sila dumā magbichara kaymu.” ");
INSERT INTO tsg_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Simambung hi Īsa, laung niya, “Bukun sadja sila in manga taymanghud iban inaꞌ ku.” ");
INSERT INTO tsg_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Sartaꞌ timudluꞌ siya pa manga mulid niya ampa siya namung laung niya, “Minsan in sila ini manga taymanghud iban inaꞌ ku da. ");
INSERT INTO tsg_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sabab hisiyu-siyu in magkahagad huminang sin kabayaan sin Tuhan, Amaꞌ ku ha surgaꞌ, in siya yan taymanghud ku usug-babai iban inaꞌ ku.” ");
INSERT INTO tsg_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Sin adlaw da yadtu nanaug hi Īsa dayn ha bāy yadtu, ampa siya miyadtu pa higad dagat. Duun siya limingkud nagnasīhat ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mataud tuud tau in miyawn nagtipun dumungug sin nasīhat niya. Hangkan simakat siya pa taas kumpit asibiꞌ ampa siya limingkud nagnasīhat. Ampa in manga tau duun ha higad daplakan dimurungug kaniya. ");
INSERT INTO tsg_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Na, mataud in niyasīhat niya ha manga tau iban diyalil niya kaagi in pagnasīhat niya. Laung niya, “Awn yaun hambuuk tau miyadtu nagtanum binhiꞌ pa uma niya. ");
INSERT INTO tsg_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","In kaagi niya nagtanum, siyabud niya in manga binhiꞌ. In kaibanan binhiꞌ nahulug pa labayan. Na pagkawn sin manga manuk-manuk nakaun in manga binhiꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","In kaibanan binhiꞌ nahulug pa lupaꞌ mabatu iban hangkatiyuꞌ da in lupaꞌ niya. Na, hangkarayꞌ da timubuꞌ in manga binhiꞌ sabab mababaw da in lupaꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Sumagawaꞌ kiyapasuan mayan suga nangluyluy in tiyanum sabab bukun malawm in gamut niya. ");
INSERT INTO tsg_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","In kaibanan binhiꞌ nahulug pa lupaꞌ tiyutubuan sin manga kasagbutan matunuk. Pagtubuꞌ sin manga binhiꞌ, tiyaꞌlung sin manga sagbut matunuk. ");
INSERT INTO tsg_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Na, in kaibanan binhiꞌ nahulug pa lupaꞌ marayaw. Hangkan jimatu in tubuꞌ nila iban nagbunga marayaw. In bunga sin kaibanan landuꞌ tuud mataud, in kaibanan mataud, ampa in kaibanan sarang-sarang in taud sin bunga niya.” ");
INSERT INTO tsg_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Na, mahuli dayn duun, laung hi Īsa, “In sasukuꞌ sin kamu nakarungug, dunguga niyu tuud in biyaytaꞌ ku yan kaniyu.” ");
INSERT INTO tsg_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Sakali miyawn kan Īsa in manga mulid niya ampa nangasubu kaniya. Laung nila, “Maytaꞌ ha sakabaꞌ kaw magnasīhat dalilun mu pa manga isturi malawm in maana niya?” ");
INSERT INTO tsg_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Simambung hi Īsa, laung niya, “In kamu yan kiyarihilan na ingat iban panghāti pasal sin kahālan sin pamarinta sin Tuhan, amu in bakas līlibun dayn ha pikilan sin mānusiyaꞌ! Sagawaꞌ in manga tau yan walaꞌ kiyarihilan sin ingat iban panghāti pasal yan. ");
INSERT INTO tsg_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Karnaꞌ hisiyu-siyu in magparachaya tuud ha hinduꞌ diyungug nila, na sūngan sin Tuhan in panghāti nila, iban maglabi-labihan in hirihil kanila. Sagawaꞌ hisiyu-siyu in wayruun parachaya nila, minsan in maniyuꞌ-tiyuꞌ ingat iban panghāti nila kawaan da dayn kanila. ");
INSERT INTO tsg_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Hangkan ku dalilun in pagnasīhat ku pa manga isturi malawm in maana niya sabab sin manga tau amu in way bayaꞌ nila magad sin hinduꞌ ku. Hangkan amu in pagꞌiyanun minsan sila imaatud diꞌ nila kakitaan iban minsan sila dimurungug diꞌ nila kahātihan. ");
INSERT INTO tsg_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Na, nabunnal tuud in kiyabaytaꞌ hi Nabi Isayas ha lawm Kitab, amu agi, ‘In manga tau ini dimurungug, sagawaꞌ wayruun bayaꞌ nila humāti, imaatud sila, sagawaꞌ diꞌ nila kitaun tuud marayaw. ");
INSERT INTO tsg_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Dayn ha sabab matugas in atay nila, hiyuhulat nila in taynga nila, iban pīpirung nila in mata nila. Sabab bang bukun biyaꞌ ha yan in hinang nila, tantu makakitaꞌ in mata nila, makarungug in taynga nila, makahāti in pamikil nila iban magbalik in atay nila kākuꞌ,’ laung sin Tuhan, ‘ampa ku ampunun in manga dusa nila.’” ");
INSERT INTO tsg_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Na, laung hi Īsa ha manga mulid niya, “In manga kamu yan masukud tuud, sabab in manga kakitaan iban karungugan niyu kahātihan niyu! ");
INSERT INTO tsg_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Na, baytaan ta kamu, mataud manga nabi iban manga tau sukuꞌ sin Tuhan sin masa nakauna yadtu in mabayaꞌ tuud kumitaꞌ sin manga kīkitaꞌ niyu bihaun, sagawaꞌ walaꞌ nila kītaꞌ. Iban mabayaꞌ tuud sila dumungug sin manga diyurungug niyu bihaun, sagawaꞌ walaꞌ nila diyungug.” ");
INSERT INTO tsg_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Na, dungug kamu tuud ampa niyu kahātihan in maana sin dalilan pasal sin tau nagtanum. ");
INSERT INTO tsg_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","In manga tau nakarungug sin Baytaꞌ Marayaw pasal sin pamarinta sin Tuhan, sagawaꞌ diꞌ nila kahātihan, amuna in biyaꞌ sapantun sin manga binhiꞌ iban sin dān labayan kiyahulugan nila. Na, pagkawn sin Saytan, amu in puunan sin katān kangīan, maagaw dayn ha lawm atay nila in hinduꞌ sin Baytaꞌ Marayaw. ");
INSERT INTO tsg_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","In manga binhiꞌ iban sin lupaꞌ mabatu kiyahulugan nila amuna in biyaꞌ sapantun sin manga tau timaymaꞌ iban pagkūg-kuyag pagdungug nila na mayan sin Baytaꞌ Marayaw pasal sin pamarinta sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Sagawaꞌ diꞌ maggamut in hinduꞌ sin Baytaꞌ Marayaw ha lawm atay nila, iban hangkarayꞌ da in tatasan nila. Hangkan bang sila datungan na kasusahan atawa kabinsanaan, sabab sin pagtaymaꞌ sin hinduꞌ sin Baytaꞌ Marayaw, magtūy nila butawanan na in pangandul nila ha Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","In manga binhiꞌ iban sin lupaꞌ kiyahulugan nila, amu in tiyutubuan sin sagbut matunuk, amuna in biyaꞌ sapantun sin manga tau nakarungug sin Baytaꞌ Marayaw pasal sin pamarinta sin Tuhan, sagawaꞌ masi sila magsusa sin manga palihālan dī ha dunya iban malabi ha atay nila in manga altaꞌ. Hangkan maluppas sadja in karayawan makapabuntul sin kawl-piil nila amu in makawaꞌ nila dayn ha hinduꞌ sin Baytaꞌ Marayaw. In sila yan biyaꞌ da sapantun tiyanum diꞌ magbunga. ");
INSERT INTO tsg_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ampa in manga binhiꞌ iban sin lupaꞌ marayaw kiyahulugan nila amuna in biyaꞌ sapantun sin manga tau nakarungug sin Baytaꞌ Marayaw pasal sin pamarinta sin Tuhan iban kiyahātihan nila sabab nagkahagad sila sin hinduꞌ. Hangkan sumūng in dayaw sin kawl-piil nila. In kaibanan landuꞌ tuud dumayaw, in kaibanan isab dumayaw tuud, ampa in kaibanan sarang-sarang in dayaw nila.” ");
INSERT INTO tsg_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Manjari nagnasīhat na isab hi Īsa kanila, diyalil niya kaagi. Laung niya, “In hantang sin pamarinta sin Tuhan hikadalil ta pa kahālan sin pagtanum iban pagꞌani sin tiyanum. Biyaꞌ ha ini in hantang niya. Awn hambuuk tau nagtanum binhiꞌ marayaw ha uma niya. ");
INSERT INTO tsg_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Sakali, hambuuk dūm ha saꞌbu natutūg na in tau katān, miyawn in banta sin tau yaun pa uma ampa niya tiyanuman sagbut ha daig piyagtanuman sin binhiꞌ, ubus ampa siya minīg. ");
INSERT INTO tsg_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Na, timubuꞌ mayan in binhiꞌ sartaꞌ timagnaꞌ na namunga, timubuꞌ da isab in manga sagbut. ");
INSERT INTO tsg_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Na, namaytaꞌ in hambuuk daraakun mawn pa tagdapu sin uma. Laung niya, ‘Tuwan, in binhiꞌ tiyanum ha uma mu marayaw. Sagawaꞌ maytaꞌ bahaꞌ awn timutubuꞌ sagbut duun ha yaun?’ ");
INSERT INTO tsg_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Simambung in tagdapu sin uma, laung niya, ‘Kahinangan sa yan sin banta ku.’ “Laung sin manga daraakun niya, ‘Mabayaꞌ kaw, Tuwan, larutun namuꞌ in manga sagbut?’ ");
INSERT INTO tsg_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Simambung in tagdapu, laung niya, ‘Ayaw, sabab bang kamu maglarut sin manga sagbut gana-gana maagad niyu malarut in manga batangan sin tiyanum ku. ");
INSERT INTO tsg_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pasāri niyu na magdungan magtubuꞌ in tiyanum ku iban sin sagbut sampay dumatung in waktu sin pagꞌani. Na, bang maabut na in pagꞌani, baytaan ku dakuman in manga magꞌaani hipalarut muna in manga sagbut, baggutun ampa sunugun. Pagꞌubus ampa nila anihun in manga bunga sin tiyanum ku iban hitawꞌ pa lawm sin buriga ku.’” ");
INSERT INTO tsg_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Na, pagꞌubus yadtu diyalil na isab hi Īsa in pamarinta sin Tuhan pa hambuuk bigi sibiꞌ-sibiꞌ tuud. Laung niya, “In hantang sin pamarinta sin Tuhan hikadalil ta pa kahālan sin pagtubuꞌ iban pagsambu sin hambuuk bigi sibiꞌ-sibiꞌ tuud tiyanum sin tau ha lupaꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","In bigi ini landuꞌ tuud asibiꞌ, sagawaꞌ bang tumubuꞌ, lumagguꞌ tuud yan dayn ha katān jambangan. Mahinang yan hambuuk kahuy dakulaꞌ, pagtapuan yan sin manga manuk-manuk iban pagpugaran nila in manga sanga niya.” ");
INSERT INTO tsg_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Pagꞌubus yadtu diyalil na isab hi Īsa in pamarinta sin Tuhan pa pasulig. Laung niya, “In pagsaplag sin pamarinta sin Tuhan hikadalil ta ha pasulig, amu in hilamud sin babai pa tūngka-tupung tirigu, ampa muskag in addun.” ");
INSERT INTO tsg_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Dalilun hi Īsa in pagnasīhat niya ha manga tau mataud. Diꞌ siya magnasīhat kanila unu-unu bang bukun dalil kaagi. ");
INSERT INTO tsg_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Na, dayn duun nabunnal tuud in Parman sin Tuhan kiyasulat sin hambuuk nabi ha lawm Kitab, amu agi, “Dalilun ku bang aku magbichara kanila. Baytaan ku sila pasal sin manga unu-unu, amu in līlibun dayn sin tagnaꞌ kapapanjari sin dunya.” ");
INSERT INTO tsg_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pagꞌubus hi Īsa nagnasīhat ha manga tau mataud, minīg na siya ampa siya simūd pa lawm bāy. Miyurul in manga mulid niya kaniya ampa siya iyasubu, laung nila, “Tuwan, baytai kami bang unu in hātihan sin dalilan pasal sin sagbut.” ");
INSERT INTO tsg_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Simambung hi Īsa, laung niya, “In Anak Mānusiyaꞌ, amuna in diyalil tau nagtanum sin binhiꞌ marayaw. ");
INSERT INTO tsg_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","In uma amuna in lawm dunya ini. Hāti in binhiꞌ marayaw amuna in manga tau agad ha pamarinta sin Tuhan. Ampa in manga sagbut amuna in manga tau agad ha Saytan, amu in puunan sin katān kangīan. ");
INSERT INTO tsg_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ampa in banta sin tau amu in nagtanum sin sagbut, amuna in Iblis. In waktu sin pagꞌani, amuna in waktu kahinapusan sin masa ha dunya. In manga tau magꞌaani amuna in manga malāikat. ");
INSERT INTO tsg_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Na, in manga tau agad ha Iblis, in sila yan mabiyaꞌ da isab sin manga sagbut. Tipunun sila ampa daꞌpugan sin kāyu bang maabut na in waktu kahinapusan sin masa ha dunya. ");
INSERT INTO tsg_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","In Anak Mānusiyaꞌ, bang dumatung na in waktu kahinapusan sin masa ha dunya, daakun niya na in manga malāikat mawn pa pagparintahan sin Tuhan kumawaꞌ ha manga tau amu in nakarā ha manga pagkahi nila mānusiyaꞌ huminang sin manga makarusa iban na sin katān tau amu in naghihinang mangīꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Hipatipun niya sila katān ampa niya sila hipalaruk pa lawm narkaꞌ jahannam. Duun sila magtangis iban sumandal sin kasiksaan makalap. ");
INSERT INTO tsg_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Sagawaꞌ in manga tau sukuꞌ sin Tuhan magsahaya sila biyaꞌ sin siꞌnag sin suga didtu ha lawm pagparintahan sin Tuhan. Na, sasukuꞌ sin kamu nakarungug, dunguga niyu tuud in biyaytaꞌ ku yan kaniyu!” ");
INSERT INTO tsg_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","(Pagꞌubus nagbichara na isab hi Īsa hambuuk dalil pasal sin altaꞌ tiyatapuk. Laung niya,) “In hantang sin pamarinta sin Tuhan biyaꞌ sapantun sin kahālan sin hambuuk tau makabāk altaꞌ liyulubung ha lawm lupaꞌ. Kumuyag tuud siya iban hilubung niya magbalik in altaꞌ, ampa siya muwiꞌ magdagang sin katān unu-unu niya. Pagꞌubus ampa siya magbalik mamī sin lupaꞌ piyaglubungan niya sin altaꞌ kiyabaakan niya. ");
INSERT INTO tsg_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Damikkiyan, in hantang sin pamarinta sin Tuhan, biyaꞌ da isab yan sapantun sin kahālan sin hambuuk tau naglalawag mamī sin mussaꞌ marayaw. ");
INSERT INTO tsg_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Bang siya makabāk na sin mussaꞌ marayaw tuud magtūy niya hipagdagang in unu-unu niya katān, ampa niya bīhun in mussaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Damikkiyan, in hantang sin pamarinta sin Tuhan hikadalil ta pa kahālan sin paglaya istaꞌ. Hilaruk sin manga magꞌiistaꞌ in laya pa lawm dagat, ampa makakawaꞌ sin ginisan istaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bang mahipuꞌ na in laya sin istaꞌ utungun na sin manga magꞌiistaꞌ ampa dāhun pa higad daplakan. Didtu mayan ha higad daplakan pīun nila na in manga istaꞌ. In istaꞌ marayaw hibutang nila pa lawm ambung ampa in manga istaꞌ mangīꞌ hibugit nila. ");
INSERT INTO tsg_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Na, biyaꞌ tuud ha yan in kumugdan ha manga tau bang maabut na in kahinapusan sin masa ha dunya, numaug na in manga malāikat magtipun sin manga mānusiyaꞌ katān. Pagꞌubus, ampa nila kandihun in manga tau mangīꞌ dayn ha manga tau marayaw. ");
INSERT INTO tsg_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","In manga tau mangīꞌ hilaruk nila pa lawm narkaꞌ jahannam. Duun sila magtangis iban sumandal sin kasiksaan makalap.” ");
INSERT INTO tsg_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Na, iyasubu hi Īsa in manga mulid niya, laung niya, “Kahātihan niyu na ka in katān kiyabichara ku yan kaniyu?” “Huun Tuwan,” in sambag sin manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Na, simambung hi Īsa, laung niya, “Na, pagga niyu yan kiyahātihan na, hisiyu-siyu in guru sin saraꞌ agama amu in agad na ha pamarinta sin Tuhan, in siya yan mabiyaꞌ sapantun hambuuk tau taga bāy hipuꞌ sin ginis-ginisan mahalgaꞌ manga kapanyapan daan iban baꞌgu.” ");
INSERT INTO tsg_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Manjari naubus mayan in pagnasīhat hi Īsa labay dayn ha bichara dalil, minuwiꞌ na siya. ");
INSERT INTO tsg_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nagbalik siya madtu pa kawman luggiyaꞌ hulaan niya, ampa siya nagnasīhat ha manga kalanggalan didtu. Nahaylan in manga tau nakarungug sin pagnasīhat niya. Laung nila, “Hawnu bahaꞌ nakawaꞌ sin tau yan in manga ingat niya iban sin barakat niya huminang sin manga muꞌjijat yan? ");
INSERT INTO tsg_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bukun ka siya in anak sin hambuuk karpintiru? Iban bukun ka in inaꞌ niya hi Mariyam, iban in manga taymanghud niya hinda Yaꞌkub, Yusup, Simun iban hi Jahud? ");
INSERT INTO tsg_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Bukun ka in manga taymanghud niya babai yari hangka-kawman taniyu? Hāin niya bahaꞌ nakawaꞌ in manga katān ingat niya yan?” ");
INSERT INTO tsg_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Na, siyulak siya sin manga tau Nasarit. Sakali laung hi Īsa kanila, “In hambuuk nabi liyalagguꞌ hawnu-hawnu hulaꞌ. Sagawaꞌ ha luggiyaꞌ hulaꞌ niya diꞌ siya lagguun iban in manga lahasiyaꞌ iban manga tau hangka-kawman niya diꞌ manglagguꞌ kaniya.” ");
INSERT INTO tsg_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Hangkan bukun mataud in muꞌjijat hīnang hi Īsa duun ha luggiyaꞌ hulaꞌ niya sabab diꞌ magkahagad in manga tau duun kaniya. ");
INSERT INTO tsg_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ha waktu yadtu hi Hirud amu in namamarinta ha hulaꞌ Jalil, nakarungug sin kabantugan pasal sin manga hinang hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Laung niya ha manga wajil niya, “In tau yan amuna tuud hi Yahiya Mangliliguꞌ amu in nabuhiꞌ nagbalik. Hangkan na in tau yan taga barakat huminang sin manga muꞌjijat.” ");
INSERT INTO tsg_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Hangkan hi Hirud nakapamung biyaꞌ ha yan sabab biyaꞌ ha ini in isturi maytaꞌ niya piyapatay hi Yahiya Mangliliguꞌ. In hi Hirud nagbabayaꞌ iban sin ipag niya hi Hirudiya, asawa sin taymanghud niya hi Pilip. Sakali daran siya biyabaytaan hi Yahiya, amu agi, “Bukun mapatut asawahun mu in ipag mu.” Na, diyugalan hi Hirud. Hangkan, piyasaggaw niya ampa niya piyahukutan hi Yahiya, ubus ampa niya piyajīl. ");
INSERT INTO tsg_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Na, dayn ha pasal yan, mabayaꞌ niya tuud hipapatay hi Yahiya, sagawaꞌ mabugaꞌ siya ha manga Yahudi, sabab in hi Yahiya ini ītung hambuuk nabi sin manga Yahudi. ");
INSERT INTO tsg_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Manjari hambuuk adlaw naglami-lami, nagpajamu hi Hirud hipagsaꞌbu sin adlaw kapagꞌanak kaniya. Na, nagbayla in anak budjang hi Hirudiya piyanghulmat kan Hirud. Kiyasulutan tuud hi Hirud sin pagbayla niya. ");
INSERT INTO tsg_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Hangkan jiyanjian niya in anak budjang hi Hirudiya, laung niya, “Yari in tau katān saksiꞌ sin hirihil ku kaymu in unu-unu pangayuun mu kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na, in budjang asal biyaytaan sin inaꞌ niya, hipapangayuꞌ kan Hirud papunggulan in ū hi Yahiya Mangliliguꞌ. Laung sin budjang kan Hirud, “Dihilan bihaun kākuꞌ in ū hi Yahiya Mangliliguꞌ. Pabutangan ha talam.” ");
INSERT INTO tsg_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nasusa in sultan pagdungug niya sin piyangayuꞌ sin budjang. Sagawaꞌ pagga siya nakajanjiꞌ ha budjang ha alupan sin manga tau luruk, magtūy siya nagꞌuldin hipaparihil in piyangayuꞌ sin budjang. ");
INSERT INTO tsg_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Hangkan piyapunggulan niya in ū hi Yahiya didtu ha lawm jīl. ");
INSERT INTO tsg_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Pagꞌubus, ampa biyutang in ū hi Yahiya ha talam ampa dīhil pa budjang. Ubus ampa diyā sin budjang madtu pa inaꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Sakali miyawn in manga mulid hi Yahiya kimawaꞌ sin bangkay niya ampa nila kiyubul. Pagꞌubus ampa sila miyadtu namaytaꞌ kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Na, nakarungug mayan hi Īsa sin pasal yan, minīg siya dayn ha hulaꞌ yaun. Simakat siya pa kumpit asibiꞌ ampa siya miyadtu isa-isa niya pa hulaꞌ wayruun tau naghuhulaꞌ. Kiyaingatan mayan sin manga tau bang piyakain siya, imurul in manga tau kaniya, nagpanaw sadja. ");
INSERT INTO tsg_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pagnaug hi Īsa dayn ha kumpit asibiꞌ, kītaꞌ niya in manga tau mataud. Limuuy tuud siya ha manga tau iban piyauliꞌ niya in manga taga sakit. ");
INSERT INTO tsg_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pagga sūng na marūm, miyawn in manga mulid hi Īsa kaniya. Laung nila, “Tuwan, masuuk na marūm in hulaꞌ, ampa in hulaꞌ ini wayruun tau naghuhulaꞌ dī. Marayaw pa pakadtuun mu in manga tau ini pa manga lūngan masuuk mamī sin kakaun nila.” ");
INSERT INTO tsg_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","In sambag hi Īsa, laung niya, “Minsan sila diꞌ na mīg dayn dī. Kamu na in dumihil kakaun kanila.” ");
INSERT INTO tsg_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Laung sin manga mulid niya, “In kakaun natuꞌ ini amura lima tinapay iban duwa istaꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Laung hi Īsa kanila, “Dāha niyu mari kākuꞌ in tinapay iban istaꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pagꞌubus ampa piyalingkud hi Īsa in manga tau ha kabaylihan. Pagꞌubus ampa niya kiyawaꞌ in limang sulag tinapay iban sin duwa istaꞌ, sartaꞌ himangad na siya pa taas langit ampa siya nagsarang-sukul pa Tuhan. Pagꞌubus ampa niya piyagꞌutud-utud in limang sulag tinapay iban duwa istaꞌ ampa niya diyuhal pa manga mulid niya piyarihil pa manga tau. ");
INSERT INTO tsg_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Na, nakakaun in tau katān iban kiyansuban sila. Pagꞌubus sin tau katān nagkaun tīpun sin manga mulid hi Īsa in manga nakapin kakaun. Nakahipuꞌ sila hangpuꞌ tagduwa ambung. ");
INSERT INTO tsg_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","In taud sin tau kimaun awn manga lima ngaibu, diꞌ na magꞌitung sin manga kababaihan iban sin manga kabataan. ");
INSERT INTO tsg_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Manjari piyasakat hi Īsa in manga mulid niya pa taas kumpit asibiꞌ, paunahun na dayn kaniya madtu pa hansipak higad sin dagat. Dimuun naa siya nagpauwiꞌ ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Napauwiꞌ niya mayan in manga tau, miyadtu siya pa taas būd-būd nangarap pa Tuhan. Narūm mayan, duun na hi Īsa isa-isa niya. ");
INSERT INTO tsg_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ampa in manga mulid niya, nakaabut mayan sila pa giꞌtung lawd, kiyugdan na tuud sila alun, sabab simangsang sila sin hangin. ");
INSERT INTO tsg_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Na, subu-subu pa tuud, ha ūt sin lisag tū iban lisag unum, miyanaw hi Īsa ha babaw dagat harap madtu pa manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pagkitaꞌ sin manga mulid niya miyamanaw siya ha babaw sin dagat, landuꞌ tuud sila miyugaꞌ. Sabab in pangannal nila lutaw in kītaꞌ nila. Nakasilawak sila sin bugaꞌ nila, laung nila, “Lutaw na sa yan!” ");
INSERT INTO tsg_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Sagawaꞌ magtūy namung hi Īsa kanila, laung niya, “Pataptapa niyu in atay niyu. Aku sa ini, hangkan ayaw kamu mabugaꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Sakali namung hi Pitrus, laung niya, “Panghuꞌ, bang bunnal tuud ikaw yan, papanawa aku ha babaw sin dagat harap mawn kaymu.” ");
INSERT INTO tsg_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Kari na kaw!” laung hi Īsa kaniya. Na nimaug na hi Pitrus dayn ha kumpit asibiꞌ, ampa siya miyanaw ha babaw dagat tudju madtu kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Sagawaꞌ kītaꞌ niya mayan in alun dakulaꞌ miyugaꞌ siya. Na, magtūy siya liyuddang. Imulak siya magtūy, laung niya, “Panghuꞌ, tabanga aku!” ");
INSERT INTO tsg_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Magtūy siya iyabut hi Īsa iyutung ampa namung hi Īsa, laung niya, “Kulang tuud in pangandul mu! Maytaꞌ nagduwa-ruwa in pikilan mu?” ");
INSERT INTO tsg_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pagꞌubus simakat na sila karuwa pa taas kumpit asibiꞌ, sartaꞌ himundung na in hangin. ");
INSERT INTO tsg_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Pagsakat nila, in manga mulid ha taas kumpit asibiꞌ simujud na katān kan Īsa. Laung nila, “Tantu na tuud sin in ikaw na in Anak Tuhan!” ");
INSERT INTO tsg_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Manjari limanjal na sila pa hansipak sin dagat. Duun sila dimungguꞌ ha kawman sin Ginnisarit. ");
INSERT INTO tsg_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Pagnaug nila dayn ha taas kumpit asibiꞌ, kiyakilāhan sin manga tau ha kawman yaun hi Īsa. Hangkan magtūy nila kiyawaꞌ in manga tau katān nasasakit ha katilibut sin kawman yaun, ampa diyā mawn kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jiyunjung kaniya sin manga tau nagdarā sin manga nasasakit bang mayan pakaputun niya in manga nasasakit minsan dakuman duhul sin juba niya. Na, in katān nakakaput sin juba niya, kiyaulian. ");
INSERT INTO tsg_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Manjari miyawn kan Īsa in manga Parisi iban sin manga guru sin saraꞌ agama dayn ha Awrusalam (Baytal Makdis). Iyasubu nila hi Īsa, laung nila, ");
INSERT INTO tsg_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Maytaꞌ in manga mulid mu diꞌ magkahagad sin manga biatan sin kamaasan natuꞌ? Kumaun sila minsan sila walaꞌ nakapagsuchi sin manga lima nila!” ");
INSERT INTO tsg_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","In sambag hi Īsa, laung niya, “Na, maytaꞌ isab in kamu? Atas niyu liyanggal in daakan sin Tuhan bang mayan niyu maagad in manga biatan sin manga kamaasan niyu amu in piyanghinduꞌ niyu! ");
INSERT INTO tsg_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Karnaꞌ nagparman in Tuhan, amu agi, ‘Pagꞌaddati niyu in inaꞌ-amaꞌ niyu,’ iban, ‘Hisiyu-siyu in manuknaꞌ ha amaꞌ atawa inaꞌ niya subay siya patayun.’ ");
INSERT INTO tsg_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Sagawaꞌ dugaing in hinduꞌ niyu ha manga tau. Laung niyu, bang in hambuuk tau awn hipanabang niya ha maas niya, sagawaꞌ imiyan siya in tabang niya yan kiyaungsud niya pa Tuhan, ");
INSERT INTO tsg_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","na, makajari na minsan niya diꞌ na tabangun in maas niya. Na, in hīnduꞌ niyu yan ha manga tau, karnaꞌ sin pagbawgbug niyu sin hinduꞌ biatan sin kamaasan niyu, amuna in nakapalayuꞌ ha manga tau dayn ha Parman sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","In kamu yan nagpabawꞌ-bawꞌ sadja miyamagad sin daakan sin Tuhan. Kiyugdan tuud kamu sin kiyabaytaꞌ hi Isayas ha lawm Kitab, amu agi sin Tuhan, ");
INSERT INTO tsg_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Liyalagguꞌ aku sin manga tau sin lapal-kabtangan nila, sagawaꞌ malayuꞌ aku dayn ha atay nila. ");
INSERT INTO tsg_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wayruun da pūs nila magpudji kākuꞌ sabab hibaytaꞌ nila sin in hīnduꞌ nila daakan dayn kākuꞌ, sagawaꞌ in kasabunnalan niya hinang-hinang nila sadja in hinduꞌ yan.’” ");
INSERT INTO tsg_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Pagꞌubus yadtu tiyawag hi Īsa in manga tau mataud pakawnun kaniya, ampa siya namichara, laung niya, “Dungug kamu iban hātiha niyu in hibichara ku ini kaniyu. ");
INSERT INTO tsg_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","In unu-unu makaun, makasūd pa lawm simud sin hambuuk tau, in yan diꞌ makasammal kaniya. Sagawaꞌ amu in makasammal kaniya in unu-unu mangīꞌ gumuwaꞌ dayn ha lawm simud niya.” ");
INSERT INTO tsg_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Sakali miyawn in manga mulid niya kaniya ampa namung, laung nila, “Tuwan, in manga Parisi kimangīꞌ in atay sin pamung mu.” ");
INSERT INTO tsg_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Na, diyalil kaagi hi Īsa in sambung niya kanila, laung niya, “In unu-unu namān pananum amu in bukun tiyanum sin Amaꞌ ku ha surgaꞌ, hipalarut da ha susūngun. ");
INSERT INTO tsg_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ayaw kamu magsusa pasal nila. In sila yan manga nakuraꞌ sin saraꞌ agama, sagawaꞌ manga nakuraꞌ amu in diꞌ makaingat sin tudjuhan nila. Biyaꞌ sila manga buta. Ampa bang in hambuuk tau buta amu in mangambit ha buta da isab biyaꞌ kaniya, na karuwa sila in mahulug pa lubang.” ");
INSERT INTO tsg_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Namichara hi Pitrus, laung niya, “Tuwan, pahātiha kunuꞌ kami sin maana sin bichara diyalil mu yadtu.” ");
INSERT INTO tsg_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Laung hi Īsa, “Bat biyaꞌ da kamu hāti yan sin manga kaibanan masi pa wayruun panghāti. ");
INSERT INTO tsg_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Maytaꞌ, diꞌ mu ka kaingatan sin bang in kakaun matūn na sin tau sumampay na yan pa tiyan niya, pagꞌubus gumuwaꞌ da dayn ha baran niya. ");
INSERT INTO tsg_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Sagawaꞌ in manga unu-unu mangīꞌ ha lawm atay iban pikilan sin tau amu in gumuwaꞌ dayn ha simud niya, amu in makasammal kaniya, ");
INSERT INTO tsg_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","karnaꞌ in manga pikilan mangīꞌ amu in guwaꞌ dayn ha lawm atay niya, biyaꞌ na sin mamunuꞌ, magjina, maghinang sin manga unu-unu kalumuan, manakaw, mamuting iban magbichara mangīꞌ pasal sin pagkahi niya ha wayruun kasabunnalan niya, ");
INSERT INTO tsg_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","amu yan in makasammal, mahinang dusa sin tau. Sagawaꞌ diꞌ kamu masammal bang kamu kumaun ha diꞌ magsuchi sin lima niyu biyaꞌ sin agi nila subay niyu hinangun.” ");
INSERT INTO tsg_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Pagꞌubus yadtu miyadtu hi Īsa pa lugal amu in masuuk pa dāira Tirus iban Sidun. ");
INSERT INTO tsg_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Sakali awn hambuuk babai dayn ha hulaꞌ Kanan naghuhulaꞌ duun in miyawn kaniya. Laung sin babai ini kan Īsa, “Ū Tuwan, hambuuk panubuꞌ hi Nabi Daud, kaluuyi aku. In anak ku babai siyusūd saytan, iban malasahi tuud siya.” ");
INSERT INTO tsg_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Sagawaꞌ walaꞌ simambung hi Īsa. Simuuk mawn kaniya in manga mulid niya sartaꞌ nangayuꞌ, laung nila, “Tuwan, paīga in babai yan sabab imuurul sadja kātuꞌ iban mahibuk tuud siya.” ");
INSERT INTO tsg_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Simambung hi Īsa, laung niya, “In aku ini naraak tumabang ha manga tau bangsa Israil, amu in biyaꞌ sapantun bili-bili nalalawaꞌ dayn ha magꞌiipat kanila.” ");
INSERT INTO tsg_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pagdungug sin babai sin pamung hi Īsa, magtūy siya simujud pa alupan niya. Laung niya, “Tuwan, tabanga tuud aku!” ");
INSERT INTO tsg_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Sakali diyalil kaagi hi Īsa in sambung niya, laung niya, “Bukun patut in kakaun sin manga bataꞌ-bataꞌ hipakaun ha manga iruꞌ ipatan.” ");
INSERT INTO tsg_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Bunnal in bichara mu yan, Tuwan,” in sambung sin babai, “sagawaꞌ minsan in manga iruꞌ ipatan, kumaun da sin manga kakaun mahulug dayn ha lamisahan sin tagꞌipatan kanila.” ");
INSERT INTO tsg_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Simambung hi Īsa, laung niya, “Uy, Indaꞌ, makusug tuud in pangandul mu! In piyangayuꞌ mu hikarūl kaymu.” Na, ha waktu da yadtu magtūy kiyaulian in anak sin babai yadtu. ");
INSERT INTO tsg_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Pagꞌubus yadtu minīg na hi Īsa dayn ha lugal yaun. Miyanaw siya limabay dayn ha higad sin Dagat Jalil, ampa siya timukad pa taas būd-būd. Duun siya limingkud. ");
INSERT INTO tsg_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Sakali mataud tau in miyawn kaniya nagdarā sin manga nasasakit biyaꞌ na sin manga pingkaꞌ, sin manga buta, sin manga pingkul, sin manga umaw iban na sin manga kaibanan kiyukugdan sin ginisan sakit. Biyutang nila sadja in manga tau nasasakit ini pa daig sin siki hi Īsa. Na, napauliꞌ sila hi Īsa katān. ");
INSERT INTO tsg_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Sangat tuud nainu-inu in manga tau pagkitaꞌ nila sin in umaw makabichara na, in pingkul uliꞌ na, in pingkaꞌ makapanaw na, iban in buta makakitaꞌ na. Na, piyudji nila in Tuhan sin bangsa Israil. ");
INSERT INTO tsg_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sakali tiyawag hi Īsa in manga mulid niya ampa siya namung, laung niya, “Maluuy aku ha manga tau ini sabab awn na tūy adlaw sila ini miyamagad kākuꞌ, ampa bihaun wayruun na makaun nila. Diꞌ aku mabayaꞌ magpauwiꞌ kanila bang ku sila diꞌ mapakaun naa, sabab gana-gana punungun sila ha panawan nila.” ");
INSERT INTO tsg_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Iyasubu siya sin manga mulid niya, laung nila, “Hawnu kitaniyu kumawaꞌ kakaun makainihan hipakaun ha manga tau mataud ini sin wayruun tau naghuhulaꞌ ha hulaꞌ ini?” ");
INSERT INTO tsg_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Laung hi Īsa, “Pila in taud sin tinapay diyarā niyu yan?” Simambung in manga mulid niya, laung nila, “Awn pitung sulag tinapay iban hangkatiyuꞌ istaꞌ sibiꞌ-sibiꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Na, īyan hi Īsa in manga tau mataud papalingkurun ha lupaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Pagꞌubus ampa niya kiyawaꞌ in pitung sulag tinapay iban sin istaꞌ, ampa siya nagsarang-sukul pa Tuhan. Ubus ampa niya piyagꞌutud-utud ampa diyuhal pa manga mulid niya hiparihil pa manga tau. Na, dīhilan na kakaun sin manga mulid niya in manga tau. ");
INSERT INTO tsg_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Na, nakakaun in tau katān iban kiyansuban sila. Pagꞌubus sin manga tau nagkaun, tīpun sin manga mulid hi Īsa in manga kakaun nakapin. Nakahipuꞌ sila pitu ambung. ");
INSERT INTO tsg_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","In taud sin tau piyakaun awn upat ngaibu, diꞌ na magꞌitung sin manga kababaihan iban sin manga kabataan. ");
INSERT INTO tsg_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pagꞌubus, ampa piyauwiꞌ hi Īsa in manga tau. Hāti ampa isab siya iban sin manga mulid niya simakat pa taas kumpit asibiꞌ. Miyadtu sila pa hulaꞌ Magadan. ");
INSERT INTO tsg_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Manjari awn manga Parisi iban Sadduki miyawn kan Īsa. Mabayaꞌ nila sulayan in barakat hi Īsa, hangkan nangayuꞌ sila kumitaꞌ dayn kaniya hambuuk muꞌjijat bat awn tandaꞌ kakitaan nila sin bunnal tuud naraak siya sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Sagawaꞌ in sambung hi Īsa kanila, laung niya, “Bang sumadlup na in suga imiyan kamu, laung niyu, ‘Kinsum marayaw in hulaꞌ sabab mapula in higad langit.’ ");
INSERT INTO tsg_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Iban subu-subu pa sin mahinaat imiyan kamu, laung niyu, ‘Umulan adlaw ini sabab mapula in higad langit iban maandum.’ Maingat niyu pamandugahan in ngīꞌ dayaw sin hulaꞌ dayn ha lupa sin langit kakitaan niyu, sumagawaꞌ diꞌ niyu kaingatan pamandugahan in maana sin manga tandaꞌ kītaꞌ niyu ha masa bihaun ini. ");
INSERT INTO tsg_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","In manga tau sin masa bihaun ini mangīꞌ tuud iban miyutas na dayn ha Tuhan. Mabayaꞌ kamu kumitaꞌ muꞌjijat tandaꞌ sin barakat ku, sagawaꞌ diꞌ ta kamu pakitaun muꞌjijat, luwal da in muꞌjijat biyaꞌ sin barakat kimugdan kan Yunus sin masa nakauna yadtu.” Pagꞌubus yadtu ampa minīg hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Pagdatung sin manga mulid hi Īsa pa hansipak sin dagat, ampa nila kiyatumtuman sin kiyalupahan nila walaꞌ nakarā kakaun. ");
INSERT INTO tsg_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Laung hi Īsa kanila, “Kamayaꞌ-mayaꞌ da kamu, iban halliꞌ kamu dayn ha pasulig sin manga Parisi iban Sadduki.” ");
INSERT INTO tsg_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Na, nagꞌinu-inu nagbichara in manga mulid niya bang maytaꞌ siya namung biyaꞌ hādtu. Laung nila, “Marayꞌ hangkan siya namung biyaꞌ hādtu sabab walaꞌ kitaniyu nagdā tinapay kakaun taniyu.” ");
INSERT INTO tsg_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Na, kiyaingatan hi Īsa bang unu in piyagginggungan nila. Hangkan laung niya kanila, “Maytaꞌ kamu magginggung pasal sin wayruun kakaun? Kulang tuud in pangandul niyu ini! ");
INSERT INTO tsg_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Maytaꞌ, masi namān kamu diꞌ makaingat? Diꞌ niyu ka katumtuman in waktu piyagbahagiꞌ-bahagiꞌ ku in lima tinapay piyakaun ha lima ngaibu tau? Iban tumtuma niyu, pila ambung pa in nakapin hipuꞌ sin kakaun, pagꞌubus sin manga tau kimaun? ");
INSERT INTO tsg_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Iban katumtuman niyu da ka isab in pitung sulag tinapay piyakaun ku ha upat ngaibu tau? Hāti pagꞌubus nila kimaun, awn pa pila ambung nakapin hipuꞌ sin kakaun. ");
INSERT INTO tsg_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Sagawaꞌ maytaꞌ pagꞌiyan ku kaniyu, pahalliun ta kamu dayn ha pasulig sin tinapay sin manga Parisi iban Sadduki, in pangannal niyu pasal kakaun in piyagbichara ku. Maytaꞌ, diꞌ niyu na mayan kahātihan sin bukun kakaun in piyagbichara ku?” ");
INSERT INTO tsg_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Sakali kiyahātihan na sin manga mulid niya in maana sin bichara niya. Pahalliun sila hi Īsa bukun dayn ha pasulig sin tinapay, sagawaꞌ dayn ha manga hinduꞌ sin manga Parisi iban Sadduki. ");
INSERT INTO tsg_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Pagꞌubus miyadtu hi Īsa iban sin manga mulid niya pa kawman masuuk pa hulaꞌ Sisariya Pilipi. Duun mayan sila iyasubu hi Īsa in manga mulid niya, laung niya, “Bang ha bichara sin manga tau, hisiyu kunuꞌ in Anak Mānusiyaꞌ?” ");
INSERT INTO tsg_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Na, laung sin manga mulid niya, “Laung sin kaibanan tau in Anak Mānusiyaꞌ amuna hi Yahiya Mangliliguꞌ. Laung isab sin kaibanan hi Ilyas atawa hi Irmiyas atawa hambuuk nabi sin masa nakauna yadtu amu in nabuhiꞌ nagbalik.” ");
INSERT INTO tsg_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Na, laung hi Īsa kanila, “Na, bang kamu, hisiyu aku?” ");
INSERT INTO tsg_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simambung hi Pitrus, laung niya, “Ikaw in Almasi, amu in Anak Tuhan amu in Tuhan buhiꞌ kasaumulan.” ");
INSERT INTO tsg_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","“Dakulaꞌ in karayawan mu, Simun, anak hi Yahiya,” laung hi Īsa, “sabab in kasabunnalan kiyapamung mu bukun mu nakawaꞌ dayn ha mānusiyaꞌ, sagawaꞌ dīhil kaymu sin Amaꞌ ku ha surgaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na, ini in hibaytaꞌ ku kaymu. In ikaw yan ngānan ku na Pitrus (sabab in maana sin ngān yan batu) iban dayn ha biyaꞌ sin kusug sin pangandul iban parachaya mu kākuꞌ, patindugun ku biyaꞌ bāy in manga tau agad kākuꞌ. Biyaꞌ sila yan sin sapantun bāy landuꞌ mahugut in papagan niya sabab minsan in Saytan, amu in puunan sin katān kangīan, wayruun da kusug manglubu kanila. ");
INSERT INTO tsg_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ikaw in hinangun ku kaput kunsiꞌ umukab sin sūran pa lawm pagparintahan sin Tuhan. Unu-unu in hilāng mu dī ha dunya, hirūl kaymu sin Tuhan, iban unu-unu in hitugut mu dī ha dunya, hirūl da isab kaymu sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pagꞌubus ampa ībut-ibutan hi Īsa in manga mulid niya sin diꞌ tuud pabaytaun minsan hisiyu sin in siya amuna in Almasi. ");
INSERT INTO tsg_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Manjari timagnaꞌ na hi Īsa nagpahāti ha manga mulid niya pasal sin manga kumugdan kaniya ha susūngun. Laung niya, “Subay aku madtu pa dāira Awrusalam (Baytal Makdis) iban duun aku numanam kabinsanaan dakulaꞌ ha lawm lima sin manga tau nagtatau-maas ha hulaꞌ, sin manga nakuraꞌ kaimaman iban sin manga guru sin saraꞌ agama. Hipapatay nila aku, sagawaꞌ ha hikatū sin adlaw dayn ha kamatay kākuꞌ mabuhiꞌ da aku magbalik.” ");
INSERT INTO tsg_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Sakali diyā hi Pitrus hi Īsa limawak hangkatiyuꞌ dayn ha kaibanan ampa niya siyamlang in bichara hi Īsa. Laung niya, “Ayaw kaw magbichara biyaꞌ ha yan, Panghuꞌ. Sipais piyakalayuꞌ sin Tuhan! Tantu in manga biyaꞌ ha yan diꞌ kumugdan kaymu.” ");
INSERT INTO tsg_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Na, timaykud hi Īsa dayn kan Pitrus ampa siya namung, laung niya, “Īg kaw dayn kākuꞌ, Saytan Puntukan. Ikaw yan in sumasat sin hinang ku. Sabab in ha lawm sin pikilan mu yan pamikil sin mānusiyaꞌ bukun pamikil dayn ha Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pagꞌubus ampa siya namung ha manga mulid niya, laung niya, “Bang awn tau mabayaꞌ magad kākuꞌ subay agarun niya in kabayaan ku, bukun in kabayaan niya. Subay siya mangaku sin katān haggut-pasuꞌ minsan siya mapatay ha pasal ku, ampa siya tūpun magad kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","“Karnaꞌ hisiyu-siyu in maūg sin kabuhiꞌ niya iban magpikil sadja sin kabayaan niya, tantu mapatay da siya. Sagawaꞌ hisiyu-siyu in diꞌ maūg ha kabuhiꞌ niya minsan siya mapatay ha pasal ku, tantu makabaak siya kabuhiꞌ salama-lama. ");
INSERT INTO tsg_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Sabab unu in kapūsan sin hambuuk tau magparūl sadja sin katān kanapsuhan niya dī ha dunya bang ha adlaw mahuli masiksaꞌ da in nyawa niya ha lawm narkaꞌ? Wayruun unu-unu dī ha dunya in hikalukat sin hambuuk tau sin nyawa niya dayn ha lawm kasiksaan. ");
INSERT INTO tsg_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Karnaꞌ ha susūngun in aku amu in Anak Mānusiyaꞌ, magbalik da mari pa dunya iban sin manga malāikat ku tumungbas ha manga mānusiyaꞌ sin tungud sin manga nahinang nila dī ha dunya. Iban in sahaya iban kalagguan ku biyaꞌ da sin sahaya iban kalagguan sin Tuhan, Amaꞌ ku. ");
INSERT INTO tsg_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Na, ini in mattan hibaytaꞌ ku kaniyu. Awn kaibanan dī kaniyu in masi pa buhiꞌ sampay maabut in waktu kamasahan nila in aku amu in Anak Mānusiyaꞌ, dihilan kawasa mamarinta ha manga tau.” ");
INSERT INTO tsg_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Manjari nakalabay mayan unum adlaw dayn ha adlaw yadtu diyā hi Īsa timukad hi Pitrus iban sin duwa magtaymanghud, hi Yaꞌkub kay Yahiya, madtu pa būd mataas. Sila-sila da in miyadtu. ");
INSERT INTO tsg_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Didtu mayan sila ha taas būd, pagkitaꞌ nila magtūy napinda in lupa hi Īsa. In bayhuꞌ niya similak biyaꞌ sin mata suga, iban makasilaw in putiꞌ sin tamungun niya. ");
INSERT INTO tsg_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Pagꞌubus, kītaꞌ sin tū mulid ini in duwa nabi (amu in malugay na nanaykud dayn ha dunya) hi Musa kay Ilyas nagbibichara iban hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Na, magtūy namung hi Pitrus kan Īsa, laung niya, “Panghuꞌ, marayaw tuud isab sin yari kami dī! Bang kaw mabayaꞌ hinangan ta kamu tū panggung paghantian niyu. In hambuuk kaymu, hambuuk kan Musa, iban in hambuuk kan Ilyas.” ");
INSERT INTO tsg_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ha saꞌbu hi Pitrus namimichara kan Īsa magtūy sila kiyalambungan sin gabun masawa tuud sartaꞌ awn na suwara diyungug nila dayn ha lawm gabun. Amu agi sin suwara, “Amu na ini in Anak ku kalasahan ku. Siya in makasulut tuud kākuꞌ. Dungug kamu sin hinduꞌ niya.” ");
INSERT INTO tsg_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pagdungug sin manga mulid sin suwara, landuꞌ tuud sila miyugaꞌ. Magtūy sila simujud pa lupaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Sakali miyawn hi Īsa pa manga mulid niya ampa niya sila kiyaputan. Laung niya, “Tindug kamu, ayaw kamu mabugaꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pagtunga nila wayruun tau dugaing kītaꞌ nila luwal da hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na, paglūd nila dayn ha taas būd, ībut-ibutan hi Īsa in manga mulid niya, laung niya, “Ayaw kamu magbaytaꞌ minsan hisiyu pasal sin kītaꞌ niyu didtu ha taas būd. Subay na aku, amu in Anak Mānusiyaꞌ mabuhiꞌ magbalik dayn ha kamatay ampa kamu makabaytaꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Sakali iyasubu hi Īsa sin manga mulid niya, laung nila, “Tuwan, maytaꞌ in baytaꞌ sin manga guru sin saraꞌ agama lumahil naa muna mari hi Ilyas ampa in Almasi”? ");
INSERT INTO tsg_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Simambag hi Īsa, laung niya, “Bunnal, muna lumahil mari hi Ilyas magsaddiya sin unu-unu katān. ");
INSERT INTO tsg_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Sagawaꞌ ini in hibaytaꞌ ku kaniyu. In hi Ilyas bakas na limahil mari, sagawaꞌ walaꞌ siya kīla sin manga mānusiyaꞌ. Gām mayan hīnang sin manga tau in unu-unu kabayaan nila hinangun kaniya. Damikkiyan, in aku, amu in Anak Mānusiyaꞌ numanam da isab kabinsanaan ha lawm lima sin manga tau.” ");
INSERT INTO tsg_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Sakali iyampa kiyahātihan sin manga mulid niya sin in tau piyagbichara niya amuna hi Yahiya Mangliliguꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pagbalik hinda Īsa mawn pa manga tau mataud, awn hambuuk tau miyawn limuhud pa alupan niya. ");
INSERT INTO tsg_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Laung niya kan Īsa, “Panghuꞌ, kaulungi in anak ku usug! Pagbabuy-babuyun siya bang siya sūrun na saytan. Binsanaꞌ tuud siya bang siya sūrun na saytan sabab masuhul magpakahantak siya pa kāyu atawa magkahulug siya pa tubig. ");
INSERT INTO tsg_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Diyā ku siya pa manga mulid mu, sagawaꞌ diꞌ nila siya mapauliꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Simambung hi Īsa, laung niya, “In manga tau sin masa ini wayruun tuud pangandul pa Tuhan iban bingkuk tuud in pamikil! Maunu pa in lugay ku dī kaniyu ampa niyu kahātihan in kusug sin kawasa sin Tuhan? Maunu pa in lugay sandalan ku ampa kamu magparachaya? Dāha mari in bataꞌ kākuꞌ!” ");
INSERT INTO tsg_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Narā mayan in bataꞌ mawn kaniya, magtūy na iyuldinan hi Īsa in saytan paguwaun dayn ha lawm baran sin bataꞌ! Na, saruun-duun gimuwaꞌ in saytan dayn ha lawm baran sin bataꞌ sartaꞌ kiyaulian na in bataꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Sakali iyasubu sin manga mulid niya hi Īsa, ha wayruun tau dugaing nakarungug. Laung nila, “Tuwan, maytaꞌ kami diꞌ makapaguwaꞌ sin saytan dayn ha lawm baran sin bataꞌ?” ");
INSERT INTO tsg_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","“Sabab kulang pa tuud in pangandul niyu pa Tuhan,” in sambag hi Īsa kanila. “Ini in tumtuma niyu! Bang in pangandul niyu pa Tuhan mabiyaꞌ sadja sin lagguꞌ sin bigi sibiꞌ-sibiꞌ, mahinang niyu in unu-unu katān mahunit tuud hinangun. Amu in pagꞌiyanun minsan in būd mīg dayn ha biyutangan niya bang niyu uldinan paīgun.” ");
INSERT INTO tsg_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Laung pa isab hi Īsa, “Sagawaꞌ in saytan biyaꞌ ha yan diꞌ niyu mapaīg dayn ha lawm baran sin tau bang kamu diꞌ mangayuꞌ duwaa pa Tuhan iban magpuasa naa muna.” ");
INSERT INTO tsg_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sakali nakapagtipun mayan in katān mulid hi Īsa duun ha hulaꞌ Jalil, namichara hi Īsa kanila, laung niya, “In aku amu in Anak Mānusiyaꞌ masuuk na hiungsud pa lawm lima sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Hipapatay nila aku sagawaꞌ pagꞌabut hikatū sin adlaw dayn ha kamatay kākuꞌ mabuhiꞌ aku magbalik.” Na, nasusa tuud in manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pagdatung hi Īsa iban sin manga mulid niya pa Kapirnaum, nangasubu kan Pitrus in manga tau magkakawaꞌ sukay ha Bāy sin Tuhan, laung nila, “Magbayad ka sukay pa Bāy sin Tuhan in guru mu?” ");
INSERT INTO tsg_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Huun,” in sambag hi Pitrus. Pagsūd hi Pitrus pa bāy, magtūy hi Īsa namung kaniya, laung niya, “Simun, bang ha pikil mu hisiyu bahaꞌ in kawaan sukay sin sultan namamarinta ha hulaꞌ, in manga anak-kampung niya atawa in manga tau dugaing?” ");
INSERT INTO tsg_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“In manga tau dugaing,” in sambung hi Pitrus. “Na, bang biyaꞌ ha yan,” in sambung hi Īsa, “in hāti niya bukun wajib ha manga anak-kampung in magbayad sukay. ");
INSERT INTO tsg_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Sagawaꞌ diꞌ kita mabayaꞌ kumangīꞌ in atay sin manga tau yan. Hangkan kadtu kaw pamingit pa dagat yaun. Hillaa magtūy bang awn na istaꞌ tuminduk sin bingit mu. Pagkawaꞌ mu sin istaꞌ ukaba in simud. Makabāk kaw sīn ha lawm simud sin istaꞌ sarang hipamayad ta sukay pa Bāy sin Tuhan. Pagꞌubus kadtu kaw pa Bāy sin Tuhan ampa mu bayari in sukay ta duwa.” ");
INSERT INTO tsg_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Na, nagsartaꞌ isab miyawn in manga mulid hi Īsa nangasubu kaniya, laung nila, “Tuwan, hisiyu in itungun mataas tuud ha lawm pamarintahan sin Tuhan?” ");
INSERT INTO tsg_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Sakali tiyawag hi Īsa in hambuuk bataꞌ-bataꞌ, ampa niya piyatindug ha alupan sin manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ampa siya namung, laung niya, “Na, ini in mattan hibaytaꞌ ku kaniyu. Bang in pamikil niyu diꞌ da mapinda mabiyaꞌ sin pamikil sin bataꞌ-bataꞌ ini (amu in diꞌ magpikil magpataas sin baran niya), na tantu diꞌ tuud kamu makaagad ha lawm pamarintahan sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Sabab amu in itungun mataas ha lawm pamarintahan sin Tuhan in tau mababaꞌ in atay biyaꞌ sin bataꞌ ini. ");
INSERT INTO tsg_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na, hisiyu-siyu in magparuli tuud ha hambuuk bataꞌ-bataꞌ biyaꞌ sin bataꞌ ini, sabab-karnaꞌ agad in tau yaun kākuꞌ, na, biyaꞌ da tuud isab baran ku in piyaruli niya. ");
INSERT INTO tsg_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Sagawaꞌ hisiyu-siyu in makarā magdusa ha manga tau nangangandul kākuꞌ, amu in piyagꞌiyan ku biyaꞌ sapantun bataꞌ-bataꞌ, na marayaw pa in tau yan malumus ha giꞌtung tawid iban sin gilingan batu dakulaꞌ hiyuhukut ha liug niya bat siya diꞌ makahinang sin biyaꞌ ha yan. ");
INSERT INTO tsg_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Anduꞌ, makaluuy tuud in manga mānusiyaꞌ sabab awn manga sasat amu in makarā kanila magdusa. Na, asal in manga sasat biyaꞌ ha yan diꞌ katangkisan sin manga mānusiyaꞌ, sagawaꞌ labi awla tuud anduꞌ kailu in tau amu in makarā ha kaibanan niya magdusa (sabab siksaun siya sin Tuhan)! ");
INSERT INTO tsg_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Na, bang sawpama in siki atawa lima niyu amu in makarā kaniyu magdusa, na, amu in pagbahasahun marayaw pa uturan niyu in siki atawa lima niyu. Labi pa marayaw mapukul in siki atawa lima niyu, bang mayan kamu makasūd pa surgaꞌ dayn sin jukup in siki-lima niyu, saꞌ in uwian niyu pa lawm narkaꞌ jahannam amu in nalalaga kasaumulan. ");
INSERT INTO tsg_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Damikkiyan, bang sawpama in mata niyu amu in makarā kaniyu magdusa, na, amu in pagbahasahun marayaw pa lugitun niyu in mata niyu, ampa niyu bugitan. Labi pa marayaw maīg in hansipak mata niyu, bang mayan kamu makasūd pa surgaꞌ, dayn sin jukup in duwa mata niyu saꞌ pa lawm narkaꞌ nalalaga in uwian niyu. ");
INSERT INTO tsg_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Na, kamayaꞌ-mayaꞌ kamu. Ayaw niyu babaꞌ-babaa in manga tau agad kākuꞌ amu in mababaꞌ in atay. Sabab baytaan ta kamu, in sila yan piyaparuli tuud sin manga malāikat ha surgaꞌ. Piyapangayuan sila tabang pa Tuhan sin manga malāikat yadtu didtu ha haddarat sin Tuhan, Amaꞌ ku. ");
INSERT INTO tsg_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Karnaꞌ in aku, amu in Anak Mānusiyaꞌ limahil mari pa dunya lumappas ha manga tau nalawaꞌ dayn ha dān tudju pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Biyaꞌ diin in pikil niyu?” laung hi Īsa ha manga dimurungug kaniya. “Bang sawpama awn hambuuk tau nagꞌiipat hanggatus bili-bili ampa malawaꞌ in hambuuk, unu in hinangun niya? Bukun ka hibīn niya in kasiyaman tagsiyam bili-bili duun ha kaparangan ampa niya lawagun in hambuuk bili-bili nalawaꞌ? ");
INSERT INTO tsg_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na, bang niya kabaakan na in hambuuk bili-bili nalawaꞌ, kūgan tuud siya minsan da awn pa kasiyaman tagsiyam bili-bili niya amu in way simihaꞌ dayn ha baanan. ");
INSERT INTO tsg_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Na, biyaꞌ da isab ha yan in Tuhan, Amaꞌ niyu, ha surgaꞌ. Diꞌ siya mabayaꞌ sin awn tau sukuꞌ niya in malawaꞌ dayn ha lawm ukuman niya, minsan da in tau yan biyaꞌ lupa way hargaꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Na, bang awn pagkahi mu makarusa kaymu, kadtua siya baytai pasal sin narusa niya kaymu, sagawaꞌ subay duwa-ruwa niyu sadja in magbichara pasal yan. Bang niya akuhun in dusa niya iban mabayaꞌ siya magdayaw iban ikaw, na napatibuuk mu nagbalik in pagbagay iban paghangka-atay sin kamu hangka-agaran. ");
INSERT INTO tsg_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Sumagawaꞌ bang niya diꞌ akuhun in dusa niya iban diꞌ siya mabayaꞌ magdayaw iban ikaw, na, kawaꞌ kaw hambuuk atawa duwa tau sumaksiꞌ sin bichara mu kaniya, ha supaya maagad mu in Parman sin Tuhan ha lawm Kitab, amu agi, ‘In unu-unu dusa hibutang ha hambuuk tau, diꞌ masabunnal bang wayruun duwa tū tau sumaksiꞌ sin kasabunnalan niya.’ ");
INSERT INTO tsg_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Sagawaꞌ bang siya diꞌ pa dumungug sin hinduꞌ sin tau dugaing diyā mu, na, baytaan na in parakalaꞌ niyu pa katān pagkahi niyu agad ha Almasi. Na, bang siya diꞌ na mayan dumungug sin hinduꞌ sin manga katān pagkahi niyu, na, niyatun niyu in siya bukun na lamud ha paghambuuk niyu. Niyatun niyu na siya biyaꞌ sin tau nagtutuhan dugaing dayn sin Tuhan tuud atawa biyaꞌ sin tau magkakawaꞌ sukay pa parinta (amu in pangugut). ");
INSERT INTO tsg_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Na, hangkan ini in hibaytaꞌ ku kaniyu. Unu-unu in hilāng niyu dī ha dunya, hirūl kaniyu sin Tuhan, iban unu-unu in hitugut niyu dī ha dunya, hirūl da isab kaniyu sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Lāgiꞌ, ini pa isab in hibaytaꞌ ku kaniyu. Bang awn duwa tau duun kaniyu maghangka-pikilan mangayuꞌ pa Tuhan sin unu-unu na, hirihil yan kanila sin Amaꞌ ku ha surgaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Karnaꞌ bang awn duwa tū tau magtipun mangayuꞌ duwaa pa Tuhan sabab sin parachaya iban pangandul nila kākuꞌ, in aku yaun da isab miyamagad kanila.” ");
INSERT INTO tsg_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pagꞌubus miyawn hi Pitrus nangasubu kan Īsa, laung niya, “Panghuꞌ, makapila ku maapun in pagkahi ku bang makarusa kākuꞌ? Makapitu bahaꞌ?” ");
INSERT INTO tsg_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","“Bukun makapitu,” in sambag hi Īsa, “sagawaꞌ subay makakapituan lipatun magpitu. ");
INSERT INTO tsg_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Karnaꞌ in hantang sin pamarinta sin Tuhan hikadalil ta pa kahālan sin pagpasukut sin sultan sin manga utang kaniya sin manga daraakun niya. ");
INSERT INTO tsg_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Na, timagnaꞌ mayan in pagpasukut niya, awn hambuuk daraakun narā mawn kaniya. In daraakun ini nakautang salaksaꞌ pilak kaniya. ");
INSERT INTO tsg_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Na, kulang in sīn hipamayad sin daraakun ini kaniya. Hangkan nagꞌuldin siya hipaparagang in daraakun ini sampay sin manga unu-unu niya katān iban na sin manga anak-asawa niya, ha supaya kabayaran in utang kaniya. ");
INSERT INTO tsg_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Sagawaꞌ simujud duun ha alupan niya in daraakun ini sartaꞌ jimunjung kaniya, amu agi, ‘Ū Ampun, patangguha naa aku. Tantu bayaran ku tuud in katān nautang ku kaymu.’ ");
INSERT INTO tsg_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Limuuy in sultan ha daraakun ini. Na, hangkan miyaap na siya sin sultan iban walaꞌ na siya piyabayad sin utang niya. ");
INSERT INTO tsg_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Na, pagguwaꞌ sin daraakun ini piyagbāk niya in hambuuk daraakun biyaꞌ kaniya. In daraakun ini nakautang hangkatiyuꞌ da kaniya. Na, magtūy niya giyanggut in daraakun ini, sūng niya pikulun. Laung niya, ‘Bayari na in nautang mu kākuꞌ.’ ");
INSERT INTO tsg_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Limuhud na jimunjung kaniya in daraakun ini nakautang kaniya sartaꞌ namung na, laung niya, ‘Anduꞌ, maluuy na kaw kākuꞌ. Patangguha naa aku. Bayaran ta da kaw sin utang ku kaymu!’ ");
INSERT INTO tsg_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Sagawaꞌ diꞌ siya katangguhan iban wayruun luuy niya ha pagkahi niya daraakun. Gām mayan piyarasuk niya pa lawm jīl iban diꞌ papaguwaun sampay diꞌ makabayad sin utang kaniya. ");
INSERT INTO tsg_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pagkitaꞌ sin kaibanan daraakun sin sultan sin hīnang niya ha nakautang kaniya, iyastulan tuud sila. Hangkan miyadtu sila namaytaꞌ pasal sin katān kītaꞌ nila pa sultan. ");
INSERT INTO tsg_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Na, piyakawaꞌ sin sultan in daraakun yadtu. Pagdatung mawn sin daraakun, laung sin sultan kaniya, ‘In ikaw ini jahulakaꞌ tuud. Wayruun ulung mu ha pagkahi mu. In ikaw mataud in utang mu kākuꞌ, sagawaꞌ walaꞌ ta na kaw piyabayad sabab nagpaulung-ulung kaw tuud kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na, hangkan subay kaw isab maluuy ha pagkahi mu biyaꞌ sin luuy ku kaymu!’ ");
INSERT INTO tsg_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Na, diyugalan tuud in sultan kaniya. Hangkan, piyarasuk iban piyabinasa niya in daraakun ini ha lawm jīl ha salugay diꞌ makabayad sin katān utang niya.” ");
INSERT INTO tsg_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Mahuli dayn duun, namung hi Īsa, laung niya, “Na, in Amaꞌ ku ha surgaꞌ biyaꞌ da isab ha sultan yan in kaagi niya magdā kaniyu. Bang niyu diꞌ maapun in pagkahi niyu, damikkiyan, in kamu diꞌ niya da isab ampunun. Iban subay guwaꞌ tuud dayn ha lawm atay niyu in pagmaap niyu ha pagkahi niyu.” ");
INSERT INTO tsg_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pagꞌubus hi Īsa nanghinduꞌ, minīg na siya dayn ha hulaꞌ Jalil ampa siya miyadtu pa hulaꞌ Yahudiya, ha hansipak sin Subaꞌ Jurdan. ");
INSERT INTO tsg_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mataud tau in imurul kaniya iban mataud tau nasasakit in napauliꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Sakali awn manga Parisi miyawn kaniya nangasubu pasal sin saraꞌ sin agama ha supaya nila masaggaw hi Īsa ha bichara. Laung nila kan Īsa, “Bang ha saraꞌ sin agama natuꞌ, makajari ka mamugit in tau ha asawa niya minsan unu-unu na in palsababan hikabaytaꞌ niya?” ");
INSERT INTO tsg_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","In sambung hi Īsa kanila, “Maytaꞌ, walaꞌ niyu ka nabacha in kiyasulat ha lawm Kitab, sin ha tagnaan piyapanjari sin Tuhan in mānusiyaꞌ usug iban babai. ");
INSERT INTO tsg_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Iban in agi sin Tuhan ‘Hangkan dayn ha sabab yan mutas in usug dayn ha inaꞌ-amaꞌ niya, ampa siya humambuuk ha asawa niya ampa sila duwa matibuuk na.’ ");
INSERT INTO tsg_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Hangkan bukun na duwa in baran nila sagawaꞌ mahambuuk na in ginhawa-baran nila. Na, hangkan diꞌ makajari magbutas in manga tau piyapaghambuuk sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Sakali iyasubu sin manga Parisi hi Īsa, “Na, maytaꞌ ha hinduꞌ hi Musa makajari hibugit sin usug in asawa niya bang awn da sulat pasa?” ");
INSERT INTO tsg_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","In sambung hi Īsa, laung niya, “Na, in sabab hangkan tiyugutan hi Musa in usug mamugit ha asawa niya, sabab matugas in ū sin manga kamaasan niyu biyaꞌ da isab sin tugas sin ū niyu. Sagawaꞌ bukun biyaꞌ ha yan in kabayaan sin Tuhan ha tagnaꞌ niya nagpapanjari sin usug iban babai. ");
INSERT INTO tsg_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ini in hibaytaꞌ ku kaniyu. Hisiyu-siyu in usug mamugit ha asawa niya ha bukun sabab nagꞌusug-usug in asawa niya, ampa siya magꞌasawa dugaing, na in usug yan makalanggal sin saraꞌ magjina.” ");
INSERT INTO tsg_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Laung sin manga mulid hi Īsa kaniya, “Bang biyaꞌ da ha yan in kahālan sin magtiyaun marayaw pa diꞌ na magꞌasawa.” ");
INSERT INTO tsg_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Simambung hi Īsa, laung niya, “Na, in pasal yan bukun tau katān in makatangkaꞌ sin bayaꞌ nila magꞌasawa, luwal da in manga tau amu in inīgan sin Tuhan in bayaꞌ nila ha hāl yan. ");
INSERT INTO tsg_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Karnaꞌ mataud palsababan maytaꞌ in tau diꞌ magꞌasawa. In kaibanan pasal awn sallaꞌ nila kariasali, in kaibanan, amu in manga usug īpun, kiyabili sin tagꞌīpun kanila. Ampa in kaibanan way bayaꞌ nila magꞌasawa, pasal malabi ha atay nila in hinang magpamahalayak sin hinduꞌ iban daakan sin pamarinta sin Tuhan. Na, hisiyu-siyu in mabayaꞌ mamawgbug sin hinduꞌ ku yan, na, kadtui niyu.” ");
INSERT INTO tsg_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Na, awn manga tau nagdā sin manga bataꞌ-bataꞌ nila mawn kan Īsa, ha supaya hikabutang niya in lima niya pa babaw sin ū sin manga bataꞌ-bataꞌ, ampa niya kapangayuan duwaa pa Tuhan. Na, piyagꞌamahan sin manga mulid hi Īsa in manga tau ini. ");
INSERT INTO tsg_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Sagawaꞌ laung hi Īsa kanila, “Pakaria niyu kākuꞌ in manga bataꞌ-bataꞌ yan iban ayaw niyu sila lāngi, sabab in manga tau amu in mangandul ha Tuhan biyaꞌ sin pangandul sin manga bataꞌ-bataꞌ yan (ha inaꞌ-amaꞌ nila), na amu in makaagad sin pamarinta sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Pagꞌubus, ampa biyantang hi Īsa in lima niya pa manga bataꞌ-bataꞌ piyangayuan anugharaꞌ dayn ha Tuhan. Pagꞌubus ampa siya minīg. ");
INSERT INTO tsg_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Manjari awn hambuuk tau miyawn kan Īsa nangasubu, laung niya, “Tuwan Guru, unu in hinang marayaw tuud subay ku hinangun ha supaya aku karihilan sin kabuhiꞌ salama-lama?” ");
INSERT INTO tsg_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","“Maytaꞌ kaw nangasubu kākuꞌ bang unu tuud in marayaw,” in sambung hi Īsa. “Hambuuk-buuk da in puunan sin unu-unu katān marayaw. Bang kaw mabayaꞌ karihilan sin kabuhiꞌ salama-lama agara in katān daakan sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Unu in daakan subay agarun ku?” in pangasubu sin tau yaun kan Īsa. In sambung hi Īsa, laung niya, “Amu in manga daakan, ayaw kaw mamunuꞌ, ayaw kaw magjina, ayaw kaw manakaw, ayaw kaw magsaksiꞌ sin puting, ");
INSERT INTO tsg_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","pagꞌaddati in inaꞌ-amaꞌ mu, kalasahi in manga tau pagkahi mu biyaꞌ sin lasa mu ha baran mu.” ");
INSERT INTO tsg_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","“Iyaagad ku in katān daakan yan,” in sambung sin tau yaun. “Unu pa bahaꞌ in subay hinangun ku?” ");
INSERT INTO tsg_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Laung hi Īsa kaniya, “Bang kaw mabayaꞌ sin matubus tuud in dayaw mu, kadtu kaw dagangan in katān altaꞌ mu ampa mu pagdihilan pa manga miskin in bīhan, ha supaya awn altaꞌ mu didtu ha surgaꞌ. Pagꞌubus, ampa kaw kari agad kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pagdungug sin tau yaun sin bichara hi Īsa simusa tuud siya sabab in siya landuꞌ tuud altaan. Na, saꞌ siya minīg. ");
INSERT INTO tsg_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Sakali namung hi Īsa pa manga mulid niya, laung niya, “Bunnal bunnal da tuud in tau dayahan kahunitan magad ha pamarinta sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Na, ini in hibaytaꞌ ku kaniyu. Amu in pagꞌiyanun kaluhayan pa in untaꞌ lumabay dayn ha buliꞌ jawm dayn sin tau dayahan magad ha pamarinta sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nainu-inu tuud in manga mulid niya pagdungug nila sin bichara niya. Laung nila, “Na, bang bihādtu, in hāti niya, wayruun tau malappas.” ");
INSERT INTO tsg_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iyatud hi Īsa in manga mulid niya ampa siya simambung laung niya, “Asal bang ha pikilan sin mānusiyaꞌ, in biyaꞌ ha yan diꞌ tuud marapat mahinang, sagawaꞌ wayruun mahunit ha Tuhan. In unu-unu katān marapat niya mahinang.” ");
INSERT INTO tsg_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Sakali namung hi Pitrus, laung niya, “Na, biyaꞌ diin in kami ini? Tiyaykuran namuꞌ na in unu-unu katān ampa kami miyagad kaymu. Unu bahaꞌ in hitungbas kāmuꞌ?” ");
INSERT INTO tsg_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Laung hi Īsa kanila, “Baytaan ta kamu sin tuman. Bang dumatung na in waktu mabaꞌgu na in unu-unu katān kahālan ha lawm dunya, iban in aku amu in Anak Mānusiyaꞌ lumingkud ha lawm kasawahan magbayaꞌ ha mānusiyaꞌ katān iyampa in manga kamu hangpuꞌ tagduwa mulid ku dihilan ku kalagguan. Kamu in manga wakil ku dihilan ku kawasa magbayaꞌ ha hangpuꞌ tagduwa pihak sin bangsa Israil. ");
INSERT INTO tsg_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Lāgiꞌ hisiyu-siyu in atas mamīn sin pamāy-bāy niya, atawa sin manga taymanghud niya usug-babai, atawa sin inaꞌ-amaꞌ niya, atawa sin manga anak niya, atawa sin manga lupaꞌ niya sabab-karnaꞌ sin pagꞌagad niya kākuꞌ, na lipat manglipat in hitungbas kaniya sin Tuhan iban karihilan siya kabuhiꞌ salama-lama. ");
INSERT INTO tsg_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Malayngkan in manga tau amu in ha unahan bihaun, ha adlaw mahuli sila in ha ulihan, ampa in manga tau amu in ha ulihan bihaun, ha adlaw mahuli sila in ha unahan.” ");
INSERT INTO tsg_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Karnaꞌ in hantang sin pamarinta sin Tuhan hikadalil ta pa kahālan sin pagdā sin hambuuk tau ha manga tau maghihinang kaniya. Biyaꞌ ha ini in hantang niya. Hambuuk adlaw in tau tagdapu sin kabbun miyanaw subu-subu pa nanglawag tau maghinang ha kabbun niya. ");
INSERT INTO tsg_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Na, nakapagsulut mayan siya iban sin manga maghihinang, sin gadjihan niya sila biyaꞌ sin pagkabiyaksahan hipaggadji kanila ha lawm hangka-adlaw, piyakadtu niya na sila piyapaghinang pa kabbun niya. ");
INSERT INTO tsg_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Pagꞌubus, pagꞌabut lisag siyam miyadtu siya pa tabuꞌ. Sakali nākitaꞌ siya manga tau didtu ha tabuꞌ nagtitindug wayruun hīhinang. ");
INSERT INTO tsg_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Laung niya ha manga tau ini, ‘Kadtu kamu isab paghinang pa kabbun ku. Gadjihan ta kamu ha gantaꞌ tūp higadji kaniyu.’ ");
INSERT INTO tsg_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Na, miyadtu na in manga tau naghinang pa kabbun. “Sakali pagꞌabut ugtu suga nanglawag na isab siya tau maghinang ha kabbun niya. Biyaꞌ da isab hādtu in hīnang niya pagꞌabut lisag tū sin mahapun. ");
INSERT INTO tsg_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pagga masuuk na lisag lima sin mahapun, nagbalik siya pa tabuꞌ. Awn kītaꞌ niya manga tau nagtitindug wayruun hīhinang. Laung niya ha manga tau ini, ‘Maytaꞌ kamu yan magtindug sadja duun ha yan tingpus hangka-adlaw wayruun hīhinang niyu?’ ");
INSERT INTO tsg_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“‘Sabab wayruun tau kimawaꞌ kāmuꞌ maghinang,’ in sambag sin manga tau kaniya. “‘Na, marayaw na, kadtu kamu pa kabbun ku maghinang,’ laung niya ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Manjari narūm mayan biyaytaan sin tagdapu kabbun in kapatas, laung niya, ‘Tawaga naa in manga tau maghihinang ampa mu gadjihi. Gadjihi naa muna in manga tau kiyawaꞌ ku naghinang ha ulihan, ubus ampa in manga kiyawaꞌ ku nakauna.’ ");
INSERT INTO tsg_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Na, in manga tau amu in timagnaꞌ naghinang lisag lima sin mahapun giyadjihan sila tungud sin hinang hangka-adlaw. ");
INSERT INTO tsg_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Na, in pangannal sin manga tau amu in nakawaꞌ muna naghinang in gadji nila mataas, pasal sila in nakauna naghinang. Sagawaꞌ pagtabuk nila sin gadji nila, sibuꞌ da iban sin manga tau ha ulihan naghinang. ");
INSERT INTO tsg_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tiyabuk nila in gadji nila, ampa nila piyagdubduban in tau nagkawaꞌ kanila naghinang. ");
INSERT INTO tsg_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Laung nila, ‘In manga tau kiyawaꞌ mu naghinang ha ulihan hangka-jām da naghinang, sagawaꞌ in kami tingpus hangka-adlaw naghinang ha pasuan suga. Sagawaꞌ sibuꞌ da in gadji namuꞌ iban sila!’ ");
INSERT INTO tsg_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Laung sin tagdapu sin kabbun ha hangka-tau, laung niya, ‘Kitaa ba bagay, walaꞌ ta sa kamu iyakkalan. Piyagsulutan natuꞌ sin gadjihan ta kamu tungud sin hinang hangka-adlaw. ");
INSERT INTO tsg_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Na, kawaa niyu in gadji niyu, ampa kamu uwiꞌ na. Kabayaan ku piyagsibuꞌ in gadji niyu iban sin manga tau kiyawaꞌ ku naghinang ha ulihan. ");
INSERT INTO tsg_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Maytaꞌ, asubuhun ta kamu, wayruun ka kapatut ku magbayaꞌ sin pilak ku? Atawa nangabughuꞌ kamu pasal piyagmarayaw ku ha tau in pilak ku?’” ");
INSERT INTO tsg_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Na, mahuli dayn duun, laung hi Īsa, “Hangkan hisiyu-siyu in ha ulihan, ha adlaw mahuli amu in makapaunahan, ampa in ha unahan, ha adlaw mahuli amu in makapaulihan.” ");
INSERT INTO tsg_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Manjari sūng mayan hinda Īsa tumukad pa Awrusalam (Baytal Makdis), diyā hi Īsa in manga hangpuꞌ tagduwa mulid niya kimandī dayn ha manga kaibanan tau, ampa niya sila biyaytaan. ");
INSERT INTO tsg_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Laung niya, “Kitaa niyu ba, in kitaniyu ini tudju madtu pa Awrusalam (Baytal Makdis). Didtu aku, amu in Anak Mānusiyaꞌ, hiungsud pa lawm lima sin manga nakuraꞌ kaimaman iban guru sin saraꞌ agama. Laung nila subay kamatay in hukuman hibutang kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Pagꞌubus ampa nila aku hiungsud pa lawm lima sin manga tau bukun Yahudi amu in namamarinta sin hulaꞌ. Na, paglikiꞌ-likian aku sin manga tau yan iban lapdusan nila aku sin lulubak. Pagꞌubus ampa nila aku hilansang pa usuk pagpatayan tau. Sumagawaꞌ, pagꞌabut hikatū sin adlaw dayn ha kamatay kākuꞌ, mabuhiꞌ da aku magbalik.” ");
INSERT INTO tsg_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Na, sakali in asawa hi Sibidi miyawn iban sin duwa anak niya simujud pa alupan hi Īsa sabab awn pangayuun niya kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“Unu in pangayuun mu?” laung hi Īsa kaniya. Simambung siya, laung niya, “Bang dumatung na in waktu, ikaw na in lumingkud mamarinta ha manga mānusiyaꞌ, dihili kalagguan in duwa anak ku ini. Janjii aku sin palingkurun mu sila ha dapit pa tuu iban lawa mu.” ");
INSERT INTO tsg_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","“Diꞌ mu kaingatan tuud bang unu in piyangayuꞌ mu yan,” in sambag hi Īsa. “Ha pikil niyu, makasandal kamu minum sin luun sin sawan amu in subay inumun ku?” laung hi Īsa kanila. “Huun, makasandal kami,” in sambag nila. ");
INSERT INTO tsg_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","“Na, tantu minum kamu sin luun sin sawan amu in inumun ku,” laung hi Īsa kanila, “sagawaꞌ wayruun kapatut ku magpīꞌ bang hisiyu in lumingkud ha dapit pa tuu iban lawa ku, sabab in manga yan tiyatagama sin Tuhan, Amaꞌ ku amu in magbayaꞌ dumihil ha manga kiyasukuan niya.” ");
INSERT INTO tsg_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pagdungug sin kaibanan hangpuꞌ mulid hi Īsa sin piyangayuꞌ sin asawa hi Sibidi, diyugalan sila ha duwa magtaymanghud. ");
INSERT INTO tsg_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Na hangkan tiyawag sila katān hi Īsa pakawnun kaniya, ampa siya namung, laung niya, “Kaingatan niyu in addat sin manga tau bangsa dugaing namamarinta dī ha dunya matagi sila magkawasa ha manga tau iban in manga tau mataas in kawasa amuna magbayaꞌ-bayaꞌ sin hinangun nila ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Sagawaꞌ in kamu dugaing in hinang niyu dayn kanila. Bang awn dayn kaniyu in mabayaꞌ tumaas, na subay siya maghulas-sangsaꞌ ha kaibanan niya. ");
INSERT INTO tsg_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Iban bang awn dī kaniyu in mabayaꞌ tumaas tuud dayn ha katān, na subay siya magtagꞌīpun ha manga pagkahi niya. ");
INSERT INTO tsg_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Karnaꞌ minsan in aku, amu in Anak Mānusiyaꞌ, miyari pa dunya bukun ha supaya paghulas-sangsaan sin manga mānusiyaꞌ, sagawaꞌ aku in naghulas-sangsaꞌ kanila. Miyari aku lumillaꞌ sin duguꞌ-nyawa ku amu in hipanglukat ha manga tau mataud dayn ha manga dusa nila.” ");
INSERT INTO tsg_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ha sasang hi Īsa iban sin manga mulid niya miyamanaw muwiꞌ na dayn ha dāira Ariha, awn tau mataud in imurul kanila. ");
INSERT INTO tsg_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Sakali awn duwa tau buta naglilingkud ha higad dān. Pagdungug nila sin hi Īsa limabay, magtūy sila timawag matanug, laung nila, “Anduꞌ, hambuuk panubuꞌ hi Daud, kaulungi kami.” ");
INSERT INTO tsg_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pagdungug kanila sin manga tau mataud, piyagꞌamahan sila iban īyan sila diꞌ papaghibukun. Sagawaꞌ gām mayan, piyatanug nila tuud in pagsuwara nila. Laung nila, “Ū, Tuwan, hambuuk panubuꞌ hi Daud, kaulungi kami!” ");
INSERT INTO tsg_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Sakali himundung hi Īsa ampa niya tiyawag in duwa tau buta. Laung hi Īsa kanila, “Unu in kabayaan niyu hitabang ku kaniyu?” ");
INSERT INTO tsg_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Tuwan,” laung sin duwa buta, “kabayaan namuꞌ makakitaꞌ kami magbalik.” ");
INSERT INTO tsg_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Limuuy hi Īsa kanila. Na, iyulinan niya in mata sin duwa tau buta. Na, saruun-duun nakakitaꞌ na sila, ubus ampa sila miyagad kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Manjari masuuk mayan hinda Īsa pa Awrusalam (Baytal Makdis), kītaꞌ nila na in lūngan Bitpaji ha Būd Jaytun. Na, diyaak hi Īsa in duwa mulid niya paunahun dayn kanila. ");
INSERT INTO tsg_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Laung niya kanila, “Kadtu kamu pa lūngan amu in sūngun niyu yaun. Pagdatung niyu na mayan madtu, magtūy kamu makabāk hambuuk kuraꞌ hiyuhukutan iban anak niya mabataꞌ pa, amu in walaꞌ pa kiyapanguraan. Hubari niyu ampa niyu dāha mari kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Bang awn tau mangasubu kaniyu, baytai niyu, ‘Kagunahan sila sin Panghuꞌ.’ Na, magtūy niya sa yan hiparā kaniyu.” ");
INSERT INTO tsg_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Na, in ini naawn sabab kiyapamung iban kiyasulat ha lawm Kitab sin hambuuk nabi sin timpu nakauna in Parman sin Tuhan, amu agi, ");
INSERT INTO tsg_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Baytai in manga tau ha Awrusalam (Baytal Makdis), ‘Kitaa niyu ba! Bihaun yan na tudju mawn kaniyu in makapagbayaꞌ kaniyu. In siya yan mababaꞌ in atay. Manguraꞌ siya ha kuraꞌ, amu in anak kuraꞌ walaꞌ pa kiyapanguraan.’” ");
INSERT INTO tsg_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Na, miyadtu na in duwa mulid niya. Iyagad nila in daakan kanila hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Pagbalik sin duwa mulid, nagdarā na sila sin kuraꞌ iban anak kuraꞌ. Liyampikan nila sin juba nila in taykud sin kuraꞌ iban sin anak kuraꞌ, ubus ampa nanguraꞌ hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Sakali nanguraꞌ mayan hi Īsa, hīklad sin manga tau mataud in juba nila ha dān labayan hi Īsa. Ampa in kaibanan tau nanuꞌtuꞌ manga sanga dahunan, ampa nila kiyanat ha dān labayan hi Īsa. (Hīnang nila yan bat nila mapakitaꞌ in panglagguꞌ nila kan Īsa.) ");
INSERT INTO tsg_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","In manga tau mataud miyamanaw ha unahan iban ha ulihan hi Īsa nagꞌulang. Laung nila, “Pudjihun natuꞌ in hambuuk panubuꞌ hi Daud. Bang mayan siya barakatan amu in kiyawakilan sin Tuhan! Pudjihun natuꞌ in Tuhan didtu ha surgaꞌ amu in mataas dayn ha katān!” ");
INSERT INTO tsg_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Na, pagdatung hi Īsa pa Awrusalam (Baytal Makdis) nahiluhalaꞌ in tau katān ha lawm dāira. “Hisiyu bahaꞌ in tau yan,” laung sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Laung sin manga tau miyamagad kan Īsa, “Siya na ini in hi Īsa, nabi dayn ha Nasarit ha hulaꞌ Jalil.” ");
INSERT INTO tsg_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Sakali simūd hi Īsa pa lawm halaman sin Bāy sin Tuhan, ampa niya diyūy pa guwaꞌ in manga mamī-mī iban magdaragang duun. Biyalintuwad niya in manga lamisahan sin manga tau magsasambiꞌ sīn sin sīn dayn ha dugaing hulaꞌ iban sin lingkuran sin manga tau magdaragang assang. ");
INSERT INTO tsg_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Sartaꞌ piyamungan niya in manga tau, laung niya, “Kiyasulat ha lawm Kitab in Parman sin Tuhan, amu agi, ‘In bāy ku, subay ngānan bāy pagtataatan!’ Sagawaꞌ,” laung hi Īsa, “hīnang niyu yan lugal pagꞌaanyayahan sin sīn sin manga tau!” ");
INSERT INTO tsg_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Sakali, duun pa hi Īsa masi ha lawm halaman sin Bāy sin Tuhan, awn manga buta iban pingkaꞌ in miyawn kaniya. Napauliꞌ sila hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Na, diyugalan kan Īsa in manga nakuraꞌ kaimaman iban sin manga guru sin saraꞌ agama pagkitaꞌ nila sin manga hīnang niya makainu-inu. Sartaꞌ yaun nagꞌuulang in manga kabataan ha halaman sin Bāy sin Tuhan, laung nila, “Pudjihun natuꞌ in hambuuk panubuꞌ hi Daud!” ");
INSERT INTO tsg_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Manjari, laung nila kan Īsa, “Diyungug mu da ka in bichara sin manga bataꞌ-bataꞌ yaun?” “Huun, diyungug ku,” laung hi Īsa. “Maytaꞌ, walaꞌ niyu ka nabacha in kiyasulat ha lawm Kitab, amu agi, ‘Minsan in manga kabataan sampay pa sibiꞌ-sibiꞌ hīhinduan mamudji ha Tuhan.’” ");
INSERT INTO tsg_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pagꞌubus minīg na hi Īsa, ampa siya miyadtu pa kawman sin Bitani. Didtu siya himantiꞌ hangka-dūm. ");
INSERT INTO tsg_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na, pagbulat mahinaat, ha sūng na hi Īsa magbalik pa Awrusalam (Baytal Makdis), nakananam siya hapdiꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Sakali nākitaꞌ siya kahuy tina ha higad sin dān. Kiyadtu niya sagawaꞌ pagkitaꞌ niya wayruun bunga, luwal da manga dahun. Na, laung hi Īsa ha kahuy tina, “Tagnaan dayn ha adlaw ini, diꞌ na tuud kaw magbunga magbalik!” Na, magtūy nangluyluy in kahuy tina yaun. ");
INSERT INTO tsg_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pagkitaꞌ sin manga mulid niya, nainu-inu tuud sila. Laung nila, “Ay kaw naa, maytaꞌ bahaꞌ nanglanus magtūy in kahuy tina ini?” ");
INSERT INTO tsg_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","“Na, baytaan ta kamu sin mattan,” laung hi Īsa, “bang kamu magparachaya tuud ha way paghawal-hawal sin lawm atay niyu, mahinang niyu da isab in biyaꞌ sin nahinang ku ha kahuy tina yan. Iban labi pa dayn duun in mahinang niyu. Sabab amu in pagꞌiyanun minsan in būd ini bang niyu iyanun, ‘Īg kaw dayn ha biyutangan mu, ampa kaw laksu pa lawm dagat’, na tantu maagad in kabayaan niyu. ");
INSERT INTO tsg_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Bang kamu mangarap pa Tuhan iban magparachaya kamu, in unu-unu katān pangayuun niyu pa Tuhan hikarihil sadja kaniyu.” ");
INSERT INTO tsg_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Manjari nagbalik hi Īsa pa lawm halaman sin Bāy sin Tuhan. Ha saꞌbu niya duun nanghihinduꞌ kiyawn siya iyasubu sin manga nakuraꞌ kaimaman iban sin manga nagtatau-maas ha hulaꞌ. Laung nila kan Īsa, “Unu taꞌ in kawasa mu maghinang sin manga nahinang mu yan dī ha Bāy sin Tuhan ini? Hisiyu in nagdihil kaymu sin kawasa maghinang sin manga hīnang mu yan?” ");
INSERT INTO tsg_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","In sambung kanila hi Īsa, “Awn hambuuk isab hipangasubu ku kaniyu. Bang niyu masambag in pangasubu ku, na baytaan ta isab kamu bang dayn ha unu ku nakawaꞌ in kawasa ku maghinang sin manga hinang ku yan. ");
INSERT INTO tsg_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Na, asubuhun ta kamu. Dayn hāin nakawaꞌ hi Yahiya in kawasa niya mangliguꞌ ha manga tau, dayn ha Tuhan atawa dayn ha mānusiyaꞌ?” Na, nagꞌisun-isun na sila bang unu in hisambung nila. Laung nila, “Na, unu na in hisambung natuꞌ kaniya? Bang kitaniyu imiyan in kawasa hi Yahiya dayn ha Tuhan, na iyanun niya kitaniyu, laung niya, ‘Na, maytaꞌ kamu walaꞌ nagparachaya kan Yahiya?’ ");
INSERT INTO tsg_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Sagawaꞌ bang kitaniyu isab imiyan dayn ha mānusiyaꞌ in kawasa niya, na piligru kitaniyu. Gana-gana maghiluhalaꞌ in manga tau, sabab magkahagad tuud in manga tau katān sin hambuuk nabi hi Yahiya.” ");
INSERT INTO tsg_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Na, in sambung nila kan Īsa, laung nila, “Inday, diꞌ namuꞌ kaingatan bang dayn diin niya nakawaꞌ in kawasa niya.” Na, laung hi Īsa kanila, “Na, bang biyaꞌ hādtu, diꞌ ta da kamu isab baytaan bang dayn hāin ku nakawaꞌ in kawasa ku huminang sin manga hinang ku yan.” ");
INSERT INTO tsg_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Na, masi hi Īsa nanghihinduꞌ, laung niya, “Pikila niyu in maana sin hambuuk dalil ini. Awn yaun hambuuk tau taga anak duwa usug. Miyadtu siya pa anak niya magulang ampa niya biyaytaan, laung niya, ‘Utuꞌ, kadtu kaw paghinang adlaw ini pa kabbun anggul.’ ");
INSERT INTO tsg_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“‘Diꞌ aku mabayaꞌ madtu!’, in sambag sin anak niya. Sagawaꞌ pagꞌubus napinda da in pikilan sin anak niya, miyadtu da siya naghinang pa kabbun anggul. ");
INSERT INTO tsg_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Sakali miyadtu isab siya pa anak niya manghud ampa niya biyaytaan da isab sin biyaꞌ hādtu. ‘Huun, Amaꞌ,’ laung sin anak niya manghud. Sagawaꞌ walaꞌ da siya naghinang madtu pa kabbun anggul. ");
INSERT INTO tsg_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Na, bang kamu hisiyu ha duwa in nagkahagad sin kabayaan sin amaꞌ nila?” “In anak magulang,” in sambag nila. “Na, ini in hibaytaꞌ ku kaniyu,” laung hi Īsa kanila. “In manga tau baldusa biyaꞌ na sin magkakawaꞌ sukay pa parinta iban sin manga babai mangīꞌ, makauna pa dayn kaniyu makatabuk sin karayawan dayn ha pamarinta sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Karnaꞌ walaꞌ kamu nagparachaya kan Yahiya amu in Mangliliguꞌ, amu in miyari namaytaꞌ kaniyu sin dān mabuntul tudju pa Tuhan. Sagawaꞌ in manga tau magkakawaꞌ sukay pa parinta iban sin manga babai mangīꞌ, nagparachaya kaniya. Sagawaꞌ in kamu, minsan niyu kītaꞌ na in biyaꞌ ha yan, walaꞌ da napinda in pamikil niyu. Walaꞌ da kamu nagparachaya kaniya. ");
INSERT INTO tsg_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Dungug kamu, awn pa isab hambuuk dalil ini,” laung hi Īsa. “Awn yaun hambuuk tau nagtanum anggul ha kabbun niya. Iyād niya in katilibut sin kabbun niya ampa siya naglungag dakulaꞌ, hīnang lugal pagpupugaan sin manga bunga anggul. Iban naghinang siya bāy-bāy mataas in hāg niya amu in pamantawan sin magꞌiipat sin kabbun niya. Pagꞌubus ampa niya piyatungguan in kabbun anggul niya ha manga magtutungguꞌ kabbun, ampa siya timulak pa hulaꞌ dugaing. ");
INSERT INTO tsg_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Sakali naabut mayan in musim pagpusuꞌ sin manga anggul, diyaak na sin tagkabbun in manga daraakun niya madtu pa manga nagtungguꞌ sin kabbun niya kumawaꞌ sin manga bunga anggul bahagiꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Pagkadtu sin manga daraakun niya, siyaggaw sila sin manga tungguꞌ kabbun, ubus ampa bīnasa. In kaibanan piyatay nila iban in kaibanan biyatu nila. ");
INSERT INTO tsg_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sagawaꞌ minsan biyaꞌ hādtu, in tagkabbun nagpakadtu na isab nagbalik ha manga daraakun niya pa manga tungguꞌ sin kabbun niya. Mataud in daraakun piyakadtu niya dayn sin nakauna. Na, pagkadtu sin manga daraakun biyaꞌ da hādtu in hīnang kanila sin manga tungguꞌ sin kabbun. ");
INSERT INTO tsg_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Na, ha kahinapusan, diyaak na sin tagkabbun in anak niya madtu pa manga tungguꞌ sin kabbun niya. Laung niya ha lawm atay niya, ‘Tantu pagꞌaddatan nila in anak ku!’ ");
INSERT INTO tsg_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Sumagawaꞌ pagkitaꞌ sin manga tungguꞌ sin kabbun ha anak niya, magtūy sila nagꞌisun. Laung nila, ‘Yan na in anak sin tagkabbun, amu in kiyapusakaan sin kabbun ini. Kari kamu, patayun natuꞌ siya bat natuꞌ makawaꞌ in kabbun pusakaꞌ kaniya!’ ");
INSERT INTO tsg_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Na, siyaggaw nila in anak sin tagkabbun. Piyaguwaꞌ nila dayn ha lawm kabbun anggul ampa nila piyatay. ");
INSERT INTO tsg_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Na, ha pikil niyu bang makauwiꞌ na mawn in tagkabbun, unuhun niya in manga tungguꞌ sin kabbun niya?” laung hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","“Na, tantu patayun niya in manga tau mangīꞌ tungguꞌ sin kabbun anggul niya,” in sambag sin manga nakuraꞌ kaimaman iban sin manga nagtatau-maas ha hulaꞌ, “ampa niya patungguan in kabbun niya ha manga tau dugaing tungguꞌ amu in dumihil kaniya sin bahagiꞌ niya bang maabut na in musim sin pagpusuꞌ sin anggul.” ");
INSERT INTO tsg_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Laung hi Īsa kanila, “Walaꞌ niyu ka nabacha in kiyasulat ha Kitab? In agi sin Kitab, ‘In batu biyugit sin manga maghihinang bāy (sabab in pangannal nila way guna), amura tuud isab in batu nanjari piyagpapagun sin bāy. Hīnang yan sin Tuhan iban makahaylan tuud kātuꞌniyu.’ ");
INSERT INTO tsg_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Hangkan ini in hibaytaꞌ ku kaniyu,” laung hi Īsa. “Īgan na dayn kaniyu in manga karayawan dayn ha pamarinta sin Tuhan ampa hirihil pa bangsa dugaing amu in magkahagad sin daakan sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","In hāti sin batu amu in piyagpapagun sin bāy, amuna in Almasi. Na, bang sawpama awn tau makaligad pa batu ini, magkapusat-pusat in baran niya, iban bang awn tau kahulugan sin batu ini, magkatumu-tumu in baran niya mahinang bagunbun.” ");
INSERT INTO tsg_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pagdungug sin manga nakuraꞌ sin kaimaman iban sin manga Parisi sin manga piyagdalil hi Īsa, magtūy nila kiyahātihan sin sila in piyarungugan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Na, hangkan mabayaꞌ nila saggawun hi Īsa, sagawaꞌ mabugaꞌ sila ha manga tau mataud, amu in nagkahagad sin in hi Īsa hambuuk nabi. ");
INSERT INTO tsg_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Manjari nanghinduꞌ na isab hi Īsa ha manga tau pasal sin pamarinta sin Tuhan. In panghinduꞌ niya diyalil niya kaagi pa hambuuk isturi. ");
INSERT INTO tsg_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Laung niya, “In hantang sin pamarinta sin Tuhan hikadalil ha hambuuk sultan nagsaddiya sin pagtiyaun sin anak niya usug. ");
INSERT INTO tsg_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Diyaak niya in manga īpun niya kumawaꞌ ha manga luruk pakawnun na pa pagtiyaunan sin anak niya. Sagawaꞌ diꞌ mabayaꞌ in manga tau amu in piyakawaꞌ mangluruk mawn pa pagjamuhan. ");
INSERT INTO tsg_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Na, hangkan diyaak niya na isab magbalik in manga kaibanan īpun niya kumawaꞌ ha manga luruk pakawnun pa pagjamuhan. Laung niya ha manga īpun niya, ‘Baytai niyu in manga luruk sin saddiya na in paghinang sin pagtiyaun. Nasumbayꞌ na in manga sapiꞌ mandangan iban sin manga anak sapiꞌ mahambug. Saddiya na in katān. Pakaria niyu na sila pa pagjamuhan.’ ");
INSERT INTO tsg_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Sagawaꞌ in manga luruk walaꞌ nagꞌasip. Amu in piyaruli nila in pagꞌusaha nila. In hambuuk miyadtu naghinang pa uma, in hambuuk miyadtu pa tinda niya. ");
INSERT INTO tsg_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ampa in kaibanan, siyaggaw nila in manga īpun sin sultan, piyagbinasa iban piyagpatay nila. ");
INSERT INTO tsg_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Na, pagꞌingat sin sultan sin hīnang sin manga tau ha manga īpun niya, diyugalan tuud siya. Magtūy niya diyaak piyabunuꞌ ha manga sundalu in manga tau namatay ha manga īpun niya, iban piyapasunug niya in dāira nila. ");
INSERT INTO tsg_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Pagꞌubus yadtu piyatawag niya in manga īpun niya ampa biyaytaan, laung niya, ‘Sakap na in paghinang sin pagtiyaun, sagawaꞌ diꞌ na tūpun lumuruk in manga piyakawaꞌ ku, sabab siyulak nila in pagpakawaꞌ ku kanila mangluruk. ");
INSERT INTO tsg_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Na, bihaun kadtu kamu pa manga dān paglalabayan sin manga tau mataud, ampa niyu kawaa mangluruk mari pa pagjamuhan in katān tau kakitaan niyu.’ ");
INSERT INTO tsg_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Na, miyadtu na in manga īpun pa karān-dānan. Kiyawaꞌ nila na in tau katān kītaꞌ nila mangluruk pa pagtiyaunan sibuꞌ da tau mangīꞌ iban marayaw. Na, manjari nahipuꞌ na sin tau in bāy pagtiyaunan. ");
INSERT INTO tsg_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Sakali, pagsūd sin sultan sumagina ha manga luruk, awn kītaꞌ niya hambuuk tau nagbabadjuꞌ sin bukun hipagpabadjuꞌ ha manga luruk sin tau nagkawaꞌ kanila. ");
INSERT INTO tsg_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Laung sin sultan ha tau yaun, ‘Utuꞌ, biyaꞌ diin in kasūd mu mari sin in badjuꞌ mu yan bukun badjuꞌ hipangluruk pa pagtiyaunan?’ Sagawaꞌ walaꞌ simambung in tau yaun. ");
INSERT INTO tsg_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Na, laung sin sultan ha manga īpun, ‘Hukuti niyu in siki-lima sin tau yan, ampa niyu larukan pa guwaꞌ, madtu pa lawm katigidluman. Duun siya magtangis iban sumandal sin kasiksaan makalap.’” ");
INSERT INTO tsg_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Na, mahuli dayn duun, laung hi Īsa, “Hangkan biyaꞌ ha yan sabab mataud in tau nataabbit paagarun ha pamarinta sin Tuhan, sagawaꞌ hangkatiyuꞌ da in napīꞌ amu in magad tuud.” ");
INSERT INTO tsg_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Na, manjari minīg in manga Parisi, ampa sila nagꞌisun bang biyaꞌ diin in kalusut nila kan Īsa ha bichara. ");
INSERT INTO tsg_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Sakali diyaak nila in kaibanan mulid nila iban sin manga kaibanan tau agad kan Hirud nangasubu madtu kan Īsa. Laung sin manga tau ini kan Īsa, “Tuwan, kaingatan namuꞌ in ikaw mabuntul iban kasabunnalan sadja in bichara mu. Nanghihinduꞌ kaw pasal sin manga addat iban kawl-piil amu in kabayaan sin Tuhan pakayun sin manga mānusiyaꞌ! Diꞌ kaw masusa minsan unu in pikilan sin manga tau pasal sin bichara mu sabab diꞌ kaw magpīꞌ tau minsan unu in kawasa niya. ");
INSERT INTO tsg_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Na, sambungi kunuꞌ kami, Tuwan, sin pangasubu namuꞌ ini. Langgal saraꞌ ka sin saraꞌ agama bang kitaniyu magbayad sayrulla pa Sultan sin hulaꞌ Rūm amu in namamarinta kātuꞌniyu, atawa bukun?” ");
INSERT INTO tsg_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Na, asal kiyaingatan hi Īsa sin mangīꞌ in papanaw sin akkal nila. Na, hangkan in sambung hi Īsa, laung niya, “In kamu yan magpabawꞌ-bawꞌ sadja mangasubu! Maytaꞌ niyu aku sulayan saggawun ha bichara? ");
INSERT INTO tsg_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pakitaan niyu mari kākuꞌ in pilak hipamayad sayrulla pa parinta.” Na, diyuhal nila kan Īsa in pilak. ");
INSERT INTO tsg_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Pagꞌubus, iyasubu sila hi Īsa, laung niya, “Kansiyu in pattaꞌ iban ngān ha pilak ini?” ");
INSERT INTO tsg_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Laung nila, “Ha sultan sin hulaꞌ Rūm.” Laung hi Īsa kanila, “Na, pagga biyaꞌ ha yan, unu in sukuꞌ sin Sultan sin hulaꞌ Rūm subay hiungsud kaniya. Damikkiyan, unu in sukuꞌ sin Tuhan subay hiungsud pa Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pagdungug nila sin sambung hi Īsa, landuꞌ tuud sila nainu-inu. Pagꞌubus ampa sila minīg na. ");
INSERT INTO tsg_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na, ha adlaw da isab yadtu, awn manga Yahudi pagngānan Sadduki in miyawn kan Īsa. In manga tau ini imiyan sin in manga patay diꞌ na mabuhiꞌ magbalik ha adlaw mahuli. ");
INSERT INTO tsg_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Nangasubu sila kan Īsa, laung nila, “Tuwan Guru, hi Musa nanghinduꞌ sin bang in hambuuk usug mapatay ampa wayruun anak niya ha asawa niya, subay asawahun sin taymanghud niya in balu niya, ha supaya awn tubuꞌ amu in dumā sin ngān sin miyatay. ");
INSERT INTO tsg_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na, bakas awn pitu magtaymanghud usug naghuhulaꞌ dī. Manjari in magulang amu in taga asawa miyatay ampa wayruun anak niya iban sin asawa niya. Na, manjari iyasawa sin taymanghud niya, amu in sumunuꞌ kaniya in balu. ");
INSERT INTO tsg_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Sagawaꞌ miyatay da isab in taymanghud niya wayruun tubuꞌ ha balu. Hangkan iyasawa na isab sin taymanghud sumunuꞌ in balu, sagawaꞌ miyatay da isab siya iban wayruun da nakabāk tubuꞌ. In hawpuꞌ niya, in babai naasawa sin pitu magtaymanghud, sagawaꞌ miyatay sila katān, wayruun da nakabāk tubuꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ha ulihan miyatay da isab in babai. ");
INSERT INTO tsg_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na, bang dumatung na in waktu mabuhiꞌ na magbalik in manga patay, hisiyu ha pitu magtaymanghud in tagꞌasawa ha babai yadtu? Karnaꞌ bakas siya naasawa sin katān pitu magtaymanghud.” ");
INSERT INTO tsg_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","In sambung kanila hi Īsa, laung niya, “Saꞌ tuud in pikilan niyu yan, sabab diꞌ niyu kaingatan in ha lawm Kitab, iban diꞌ niyu da isab kaingatan in kusug sin kawasa sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Karnaꞌ bang mabuhiꞌ na magbalik in manga patay, in sila mabiyaꞌ na sin manga malāikat ha surgaꞌ. Iban in usug iban babai diꞌ na magtiyaun. ");
INSERT INTO tsg_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na, ha pasal isab sin manga patay mabuhiꞌ magbalik, maytaꞌ, walaꞌ niyu ka nabacha ha lawm Kitab in Parman sin Tuhan, amu agi, ");
INSERT INTO tsg_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Aku in Tuhan hinda Ibrahim, iban aku in Tuhan hi Isahak, iban aku da isab in Tuhan hi Yaꞌkub’?” Laung hi Īsa, “In Tuhan, amu in piyagtutuhanan sin manga buhiꞌ bukun sin manga patay.” ");
INSERT INTO tsg_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Na, pagdungug sin katauran tau, nainu-inu tuud sila sin hinduꞌ hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sakali, pagdungug sin manga Parisi sin natahamul in manga Sadduki sin pamung hi Īsa, na miyawn sila nagtipun kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Awn hambuuk dayn kanila in mabayaꞌ sumulay lumusut kan Īsa ha bichara. In tau ini guru sin saraꞌ agama. ");
INSERT INTO tsg_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Iyasubu niya hi Īsa, laung niya, “Tuwan Guru, unu in umbulsatu daakan sin saraꞌ agama?” ");
INSERT INTO tsg_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","In sambung hi Īsa, laung niya, “Wajib puspusun niyu in lasa niyu ha Tuhan, Panghuꞌ niyu, labi dayn ha unu-unu katān ha lawm atay niyu, ha kabuhiꞌ niyu iban ha lawm pikilan niyu. ");
INSERT INTO tsg_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Amu yan in umbulsatu mahargaꞌ dayn ha katān daakan. ");
INSERT INTO tsg_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","In daakan hikaruwa ini biyaꞌ da isab ha yan in hargaꞌ niya. Amu agi, ‘Subay niyu kalasahan in pagkahi niyu mānusiyaꞌ, biyaꞌ sin lasa niyu ha baran niyu.’ ");
INSERT INTO tsg_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Dayn ha duwa daakan ini, gimuwaꞌ in katān manga saraꞌ daakan piyanaug sin Tuhan dayn kan Musa iban sin manga hinduꞌ sin manga kanabihan.” ");
INSERT INTO tsg_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Na, nakapagtipun mayan in manga Parisi, napikil hi Īsa mangasubu kanila, laung niya, ");
INSERT INTO tsg_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Unu in pikilan niyu pasal sin Almasi? Hisiyu in tagtubuꞌ kaniya?” “Hambuuk panubuꞌ siya hi Daud,” in sambung nila. ");
INSERT INTO tsg_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Nakaamu in sambung niyu, sagawaꞌ maytaꞌ ha waktu hiyūp hi Daud sin Rū sin Tuhan, tiyawag niya Panghuꞌ in Almasi? Karnaꞌ nakapamung siya, amu agi, ");
INSERT INTO tsg_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Namung in Tuhan ha Panghuꞌ ku, amu agi, “Lingkud kaw dī ha dapit pa tuu ku, sampay ku mapabutang ha babaan mu in katān simusulang kaymu.”’ ” ");
INSERT INTO tsg_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Na, laung hi Īsa, “In pagtāg hi Daud ha Almasi, Panghuꞌ. Na, maytaꞌ siya tiyawag Panghuꞌ bang siya hambuuk sadja panubuꞌ hi Daud?” ");
INSERT INTO tsg_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Na, walaꞌ nakapamung in manga tau kan Īsa minsan hangka-kabtang. Tagnaan dayn ha adlaw yadtu wayruun na timawakkal mangasubu kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Manjari namichara hi Īsa ha manga tau mataud iban ha manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Laung hi Īsa, “In manga guru sin saraꞌ agama iban sin manga Parisi awn kapatut nila manghinduꞌ sin manga saraꞌ sin Tuhan piyanaug dayn kan Musa. ");
INSERT INTO tsg_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Hangkan subay niyu kahagarun in katān hinduꞌ nila. Sagawaꞌ ayaw niyu singuri in manga hinang nila, sabab walaꞌ nila iyaagad in hīhinduꞌ nila ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Hinduan nila in manga tau hipaagad in manga daakan mahunit hinangun, malayngkan, in sila walaꞌ miyamagad sin daakan yan. ");
INSERT INTO tsg_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“In katān hinang nila yan hipagpakitaꞌ sadja ha manga tau. Kitaa niyu ba in lagguꞌ sin luluunan sin manga piyagsulatan sin manga ayat dayn ha Kitab, biyubutang nila ha manga tuktuk iban buktun nila, iban atura niyu ba in habaꞌ sin jambu sin manga juba nila. ");
INSERT INTO tsg_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bang sila lumuruk pa pagjamuhan lumingkud sila ha lilingkuran tiyatawꞌ ha manga tau balkanan iban bang sila ha langgal lumingkud sila ha unahan amu in paglilingkuran tiyatawꞌ ha manga tau mataas. ");
INSERT INTO tsg_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mabayaꞌ tuud sila bang sila lagguun sin manga tau ha mayran, iban mabayaꞌ tuud sila gulalun ‘Tuwan Guru’. ");
INSERT INTO tsg_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Sagawaꞌ in kamu subay kamu diꞌ magpagulal ‘Tuwan Guru’ sabab in katān mānusiyaꞌ saliꞌ da sin magtawtaymanghud katān iban hambuuk-buuk da in Guru niyu tuud. ");
INSERT INTO tsg_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Iban subay wayruun tau gulalun niyu Amaꞌ, sabab hambuuk-buuk da Tuhan ha surgaꞌ in Amaꞌ niyu. ");
INSERT INTO tsg_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Iban diꞌ kamu makajari gulalun Panghuꞌ sabab hambuuk-buuk da Almasi in Panghuꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Hisiyu-siyu in mataas tuud dayn ha manga pagkahi niya, na subay siya magtagꞌīpun kanila. ");
INSERT INTO tsg_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Hisiyu-siyu in magpataas sin baran niya, hidusdus da pa babaꞌ. Hāti hisiyu-siyu in magpababaꞌ sin baran niya, angkatun da siya pa taas.” ");
INSERT INTO tsg_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Pagꞌubus laung hi Īsa, “Makaluuy tuud in manga kamu guru sin saraꞌ agama iban manga Parisi! In kamu magpabawꞌ-bawꞌ sadja miyamagad sin kabayaan sin Tuhan, sagawaꞌ in bunnal niya, kamu yan in timambul sin dān labayan sin manga tau pa lawm pamarintahan sin Tuhan, sabab in kamu baran niyu diꞌ mabayaꞌ magad ha pamarinta sin Tuhan. Na, hangkan diꞌ niyu tugutan magad ha pamarinta sin Tuhan in manga tau amu in mabayaꞌ magad! ");
INSERT INTO tsg_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Makaluuy tuud in manga kamu guru sin saraꞌ agama iban manga Parisi! Magpabawꞌ-bawꞌ sadja kamu miyamagad sin daakan sin Tuhan. Anyayahun niyu in manga bāy sin manga balu babai, ubus ampa kamu magpahabaꞌ sin pagpangarap niyu pa Tuhan, hipagpakitaꞌ-kitaꞌ ha manga tau, ha supaya in manga tau magpikil sin in kamu tau marayaw. Na, dayn ha sabab yan, murkaꞌ dakulaꞌ in dumatung kaniyu. ");
INSERT INTO tsg_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Makaluuy tuud in manga kamu guru sin saraꞌ agama iban manga Parisi. Magpabawꞌ-bawꞌ sadja kamu miyamagad ha daakan sin Tuhan. Landuꞌ tuud in tuyuꞌ niyu magpasaplag sin hinduꞌ niyu pa manga tau sabab umuntas kamu kalawd-lawran iban madtu kamu pa kahulaꞌ-hulaan ha supaya mapaagad niyu ha hinduꞌ niyu minsan dakuman hambuuk tau. Na, bang niyu siya mapaagad na sin hinduꞌ niyu, in siya yan lumabi pa in kangīan dayn kaniyu iban masukuꞌ na siya sin narkaꞌ biyaꞌ kaniyu! ");
INSERT INTO tsg_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Makaluuy tuud kamu. Biyaꞌ kamu yan sapantun buta imambit ha pagkahi niyu buta. Biyaꞌ ha ini in hinduꞌ niyu ha manga tau, laung niyu, ‘Bang in hambuuk tau sumapa ampa niya hinangun saksiꞌ in Bāy sin Tuhan, wayruun da ngīꞌ niya minsan niya diꞌ agarun in siyapahan niya. Sagawaꞌ bang siya sumapa ampa hinangun niya saksiꞌ in manga kapanyapan bulawan ha lawm sin Bāy sin Tuhan, na subay niya tuud agarun in siyapahan niya.’ ");
INSERT INTO tsg_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Dupang tuud kamu iban sāꞌ tuud in pikilan niyu. Maytaꞌ, hawnu in mahargaꞌ in bulawan atawa in Bāy sin Tuhan? Tantu mahargaꞌ in Bāy sin Tuhan dayn sin kapanyapan bulawan ha lawm niya. In Bāy sin Tuhan suchi, hangkan in unu-unu katān ha lawm niya, suchi da isab. ");
INSERT INTO tsg_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Lāgiꞌ, nanghinduꞌ pa isab kamu, laung niyu, ‘Bang awn hambuuk tau sumapa ampa hinangun niya saksiꞌ in lugal pagkukulbanan, wayruun ngīꞌ niya minsan niya diꞌ agarun in siyapahan niya. Sagawaꞌ bang siya sumapa ampa niya hinangun saksiꞌ in manga unu-unu biyubutang ha lugal pagkukulbanan, subay niya agarun in siyapahan niya.’ ");
INSERT INTO tsg_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nasāꞌ tuud in pikilan niyu yan! Maytaꞌ, hawnu in mahargaꞌ in lugal pagkukulbanan atawa in manga iyungsud pagkulbanan? In lugal pagkukulbanan suchi, hangkan in unu-unu katān hikabutang mawn suchi da isab. ");
INSERT INTO tsg_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Na, hangkan bang in tau sumapa ampa niya hinangun saksiꞌ in lugal pagkukulbanan, na, malapay na sampay in katān biyubutang duun amu in iyungsud pagkulbanan. ");
INSERT INTO tsg_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na, bang isab in tau sumapa, ampa niya hinangun saksiꞌ in Bāy sin Tuhan, na malapay da isab in Tuhan, sabab in Bāy yan, Bāy niya. ");
INSERT INTO tsg_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na, bang isab in tau sumapa ampa surgaꞌ in hinangun niya saksiꞌ, na malapay da isab in Tuhan iban sin kiyabubutangan niya. ");
INSERT INTO tsg_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Makaluuy tuud in kamu manga guru sin saraꞌ agama iban sin manga Parisi! In kamu yan magpabawꞌ-bawꞌ sadja miyamagad ha daakan sin Tuhan! Hiungsud niyu jakat in hangka-bahagiꞌ sin hangpuꞌka-bahagiꞌ sin manga dahun-dahun hipagpahamut sin kakaun iban hipagpangubat, biyaꞌ na sin dahun-dahun pagngānan minta, dil, iban kummin. Sagawaꞌ walaꞌ niyu biyawgbugan in manga daakan sin Tuhan amu in mahargaꞌ tuud, biyaꞌ na sin manga daakan subay mabuntul in hukuman niyu, subay kamu maluuy ha pagkahi niyu iban subay kamu kapangandulan. Na, in manga ini subay niyu tuud bawgbugan, lāgiꞌ subay niyu da isab diꞌ lupahun in manga kaibanan daakan sin saraꞌ agama. ");
INSERT INTO tsg_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Biyaꞌ kamu yan sin manga tau buta amu in umambit ha pagkahi niyu buta! In hinang niyu yan biyaꞌ kamu nagsaan sin tubig inumun niyu bat maīg in latik-latik ha tubig, sagawaꞌ biyaꞌ lagguꞌ untaꞌ in natūn niyu pagꞌinum niyu sin tubig! ");
INSERT INTO tsg_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Makaluuy tuud in kamu manga guru sin saraꞌ agama iban manga Parisi! Magpabawꞌ-bawꞌ sadja kamu miyamagad ha daakan sin Tuhan. Tuyuan niyu suchihun in anggawtaꞌ-baran iban kapanyapan niyu, sagawaꞌ in lawm atay niyu bukun suchi sabab hipuꞌ sin hawa-napsu mangīꞌ iban bayaꞌ mangulliꞌ ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Sāꞌ tuud in pikilan sin manga kamu Parisi! Lanui niyu naa muna in lawm atay niyu ha supaya muntul in kawl-piil niyu! ");
INSERT INTO tsg_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Makaluuy tuud in kamu manga guru sin saraꞌ agama iban manga Parisi! Magpabawꞌ-bawꞌ sadja kamu miyamagad ha daakan sin Tuhan. In kamu yan biyaꞌ sapantun kubul pīpinta putiꞌ in guwaꞌ niya iban malingkat aturun, sagawaꞌ in lawm niya hipuꞌ sin bukug sin tau patay iban sin manga patay nahahaluꞌ na. ");
INSERT INTO tsg_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Na, biyaꞌ ha yan in hantang niyu. Bang aturun sin manga tau, in kamu marayaw, sagawaꞌ in lawm atay niyu bingkuk sabab magpabawꞌ-bawꞌ sadja kamu iban mangīꞌ tuud in manga hinang niyu. ");
INSERT INTO tsg_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Makaluuy tuud in kamu manga guru sin saraꞌ agama iban manga Parisi. Magpabawꞌ-bawꞌ sadja kamu miyamagad ha daakan sin Tuhan. Piyalingkat niyu tuud in paghinang sin manga tampat sin manga kanabihan iban iyari-arihan niyu in kubul sin manga tau mabuntul. ");
INSERT INTO tsg_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Iban namung kamu, laung niyu, ‘Bang sadja kami natau na ha masa sin manga kaapuꞌ-apuan namuꞌ, diꞌ namuꞌ tuud hinangun in biyaꞌ sin nahinang nila. Diꞌ namuꞌ patayun in manga kanabihan.’ ");
INSERT INTO tsg_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Na, pagga biyaꞌ hādtu in pamung niyu,” laung hi Īsa, “in hāti niya nagsabunnal kamu sin in kamu panubuꞌ sin manga tau amu in namunuꞌ ha manga kanabihan. (Na, supu da sa kamu yan kanila.) ");
INSERT INTO tsg_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Na, kadtui niyu na, talusa niyu in hinang bakas tiyagnaan sin kaapuꞌ-apuan niyu. ");
INSERT INTO tsg_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“In kamu yan landuꞌ tuud panipu! Na, in pangannal niyu makapuas kamu dayn ha hukuman hihulug pa lawm narkaꞌ? Tantu diꞌ! ");
INSERT INTO tsg_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Na, hangkan ini in hibaytaꞌ ku kaniyu. Ha supaya niyu matalus in bakas hīnang sin manga kaapuꞌ-apuan niyu, pakariun ku kaniyu in manga kanabihan, manga tau malawm in ingat pasal Tuhan iban manga tau manghihinduꞌ sin Parman sin Tuhan. Na, in sila ini patayun niyu, in kaibanan hilansang niyu pa usuk, in kaibanan lapdusan niyu ha lawm langgal iban in kaibanan apasun niyu binasahun minsan sila maguy na pakain-pakain. ");
INSERT INTO tsg_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Na, dayn ha sabab yan, in kamu kugdanan sin murkaꞌ sin Tuhan sabab sin pagpamunuꞌ ha manga tau katān way dusa, tagnaan dayn ha kabunuꞌ kan Hābil amu in anak hi Apuꞌ Adam sampay pa kabunuꞌ kan Jakariyas, anak hi Baraki, amu in biyunuꞌ sin kaapuꞌ-apuan niyu ha ūt sin Bilik Suchi iban sin lugal pagbutangan sin pagkulbanan. ");
INSERT INTO tsg_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Na, ini in mattan hibaytaꞌ ku kaniyu. In manga tau sin masa ini amu in kugdanan sin murkaꞌ sin Tuhan pasal sin pagpamunuꞌ ha manga tau yadtu!” ");
INSERT INTO tsg_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Nasusa tuud hi Īsa pasal sin manga tau ha Awrusalam (Baytal Makdis). Laung niya, “Anduꞌ kailu in kamu manga tau Awrusalam (Baytal Makdis). Masi-masi in pagpamunuꞌ niyu ha manga kanabihan iban pagpamatu niyu ha manga tau daraakun sin Tuhan magpasampay sin Parman niya mawn kaniyu! Nakapila ku na piyakitaꞌ kaniyu in bayaꞌ ku magꞌayad kaniyu. Amu in pagꞌiyanun biyaꞌ aku sapantun hambuuk inaꞌ manuk magtipun sin manga anak niya ha sawm pikpik niya bat sila diꞌ magmula. Sagawaꞌ diꞌ kamu mabayaꞌ ayaran ku. ");
INSERT INTO tsg_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na, ingat kamu, bihaun pasāran na sin Tuhan in hulaꞌ niyu. ");
INSERT INTO tsg_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Sabab baytaan ta kamu, in aku bukun na malugay diꞌ niyu na kakitaan, lāgiꞌ diꞌ aku magbalik mari sampay diꞌ maabut in waktu in kamu makaiyan na, laung niyu, ‘Pudjihun natuꞌ in kiyawakilan sin Tuhan.’” ");
INSERT INTO tsg_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Manjari gimuwaꞌ na hi Īsa dayn ha Bāy sin Tuhan iban ha sūng niya na mīg dayn duun, miyawn in manga mulid niya kaniya namichara pasal sin dayaw kahinang sin Bāy sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Simambung hi Īsa, laung niya, “Huun, atura niyu tuud yan marayaw sabab baytaan ta kamu ha susūngun in Bāy sin Tuhan yan magkalubu-lubu da, iban wayruun tuud makapin batu nagbabangkat-bangkat, sagawaꞌ mapantay yan maligad katān.” ");
INSERT INTO tsg_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Pagꞌubus ampa miyadtu hi Īsa pa Būd Jaytun. Duun mayan ha Būd Jaytun, ha saꞌbu niya naglilingkud miyawn in manga mulid niya nangasubu kaniya ha wayruun tau dugaing makarungug kanila. Laung nila, “Tuwan, baytai kunuꞌ kami bang kuꞌnu maawn in biyaytaꞌ mu kāmuꞌ kāina pasal sin paglubu sin Bāy sin Tuhan iban bang unu in tandaꞌ gumuwaꞌ amu in magpakitaꞌ sin masuuk na in pagbalik mu mari pa dunya iban sin kahinapusan sin masa dī ha dunya.” ");
INSERT INTO tsg_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Simambung hi Īsa, laung niya, “Halliꞌ kamu bat supaya wayruun tau makaakkal kaniyu. ");
INSERT INTO tsg_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sabab ha susūngun mataud tau in mari mag-ngān sin ngān ku mangakkal kaniyu. In pakaniya-pakaniya kanila umiyan siya na in Almasi, hangkan mataud tau in kaakkalan nila. ");
INSERT INTO tsg_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Karungugan niyu in pagbunuꞌ iban manga habal sin pagbunuꞌ ha hulaꞌ dugaing, sagawaꞌ ayaw kamu mabugaꞌ. Sabab in manga yan asal subay maawn, sagawaꞌ bukun pa yan in waktu kahinapusan sin masa dī ha dunya. ");
INSERT INTO tsg_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","In manga kabangsa-bangsahan magbunuꞌ-biyunui iban magkuntara in manga parinta sin kahulaꞌ-hulaan. Maawn in gutum iban linug ha manga kahulaꞌ-hulaan. ");
INSERT INTO tsg_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Na, in manga yan panagnaan sadja sin manga kasigpitan iban kabinsanaan nanamun sin manga mānusiyaꞌ. Biyaꞌ yan sapantun sin sakit tagnaꞌ kananaman sin babai bang siya sūng na magꞌanak. ");
INSERT INTO tsg_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ha waktu susūngun in kamu yan saggawun ampa hiungsud pa lawm lima sin manga tau taga kawasa bat kamu mabinsanaꞌ iban mapatay. Karugalan na kamu sin tau katān sabab in kamu agad kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Na, bang dumatung na in waktu yan, mataud manga tau agad kākuꞌ in mamutawan na sin īman nila. Magtipu-tīpuhi na sila pakaniya-pakaniya iban marugal na sila ha pagkahi nila. ");
INSERT INTO tsg_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mataud tau in magpabawꞌ-bawꞌ nabi sila, daak sin Tuhan, iban mataud tau in kaakkalan nila. ");
INSERT INTO tsg_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Na, dayn ha sabab kumaruk na tuud in kangīan ha lawm dunya, in kamatauran sin manga tau maīg na in kasi-lasa ha pagkahi nila. ");
INSERT INTO tsg_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Sagawaꞌ hisiyu-siyu in sumandal sin katān kasigpitan iban kabinsanaan yan sampay pa kahinapusan, tantu malappas da siya. ");
INSERT INTO tsg_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Iban in Baytaꞌ Marayaw pasal sin pamarinta sin Tuhan hipamahalayak pa katilingkal dunya ha supaya kaingatan sin mānusiyaꞌ katān in kasabunnalan. Na, pagꞌubus yan amuna in kahinapusan sin masa dī ha dunya. ");
INSERT INTO tsg_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Na, ha susūngun kakitaan niyu da in satruꞌ sin Tuhan duun makabutang ha lugal suchi sukuꞌ sin Tuhan. In pasal ini kiyasulat hi Nabi Daniyal ha lawm Kitab. (Pahāti ha manga magbabacha: hātiha niyu in maana niya yan!) ");
INSERT INTO tsg_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Na, bang niyu ini kakitaan na, in manga tau ha hulaꞌ Yahudiya subay maguy na pa kabūran. ");
INSERT INTO tsg_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Hāti hisiyu-siyu in tau kasaꞌbuhan duun ha guwaꞌ bāy niya, subay siya magꞌūs-ꞌūs na maguy. Subay siya diꞌ na sumūd pa lawm bāy kumawaꞌ sin manga kalangkapan niya. ");
INSERT INTO tsg_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Iban hisiyu-siyu in tau kasaꞌbuhan duun ha uma niya subay siya magꞌūs-ꞌūs na maguy. Subay siya diꞌ na magbalik kumawaꞌ sin juba niya pa lugal piyagbutangan niya. ");
INSERT INTO tsg_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Na, landuꞌ tuud makaluuy in manga babai burus iban sin manga babai taga anak sibiꞌ-sibiꞌ bang dumatung na in kabinsanaan yan! ");
INSERT INTO tsg_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Hangkan, pangayuꞌ-ngayua niyu duwaa pa Tuhan bang mayan ha waktu sin pagpaguy niyu diꞌ kumugdan ha waktu mangīꞌ in hulaꞌ iban adlaw paghahali-hali iban pagpudji pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Karnaꞌ in manga kabinsanaan ha waktu yan sangat tuud makalap dayn ha katān kabinsanaan bakas kiyalabayan sin manga mānusiyaꞌ, dayn ha tagnaꞌ kapapanjari sin dunya sampay pa waktu bihaun ini. Iban wayruun na kabinsanaan makasibuꞌ ha yan. ");
INSERT INTO tsg_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Na, bang lumugay in kabinsanaan yan, in mānusiyaꞌ katān mapatay. Sagawaꞌ dayn ha sabab sin luuy sin Tuhan ha manga tau napīꞌ niya sukuꞌ, in kabinsanaan dumatung yan diꞌ niya palugayun. ");
INSERT INTO tsg_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Na, bang dumatung na in kabinsanaan yan, ampa awn tau umiyan kaniyu, laung niya, ‘Huy, kitaa niyu ba, yari na in Almasi.’ Atawa imiyan ‘Yadtu siya didtu!’ Ayaw kamu magkahagad sin bichara niya. ");
INSERT INTO tsg_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Karnaꞌ ha waktu yan awn manga tau gumuwaꞌ amu in umiyan pakaniya-pakaniya sin siya na in Almasi iban in kaibanan umiyan sin in sila manga nabi daak sin Tuhan. Huminang sila sin manga muꞌjijat iban sin manga hinang makainu-inu ha supaya bang awn dapat minsan in manga tau napīꞌ sin Tuhan sukuꞌ niya marā sin lidjal. ");
INSERT INTO tsg_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Na, dunguga niyu tuud in bichara ku yan. In manga yan asal ku na biyabaytaꞌ kaniyu ha diꞌ pa yan dumatung mari kaniyu. ");
INSERT INTO tsg_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Na, hangkan bang awn tau umiyan kaniyu, laung niya, ‘Kitaa niyu ba, yadtu didtu in Almasi ha hulaꞌ paslangan mahunit paghulaan.’ Na, ayaw kamu magkahagad kaniya, iban ayaw kamu madtu. Atawa bang awn umiyan, laung niya, ‘Kitaa niyu ba, yadtu in Almasi timatapuk didtu.’ Na, ayaw kamu magkahagad. ");
INSERT INTO tsg_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Karnaꞌ in aku amu in Anak Mānusiyaꞌ, bang aku magbalik na mari pa dunya magtaghaꞌ sadja biyaꞌ sin biskay sin kilat magsiꞌnag ha langit dayn ha subangan pa sadlupan. ");
INSERT INTO tsg_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Karnaꞌ biyaꞌ na sin agi sin hambuuk masaalla, hawnu-hawnu lugal awn tau patay nahahaluꞌ, pagtipunan yan mawn sin manga billiꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Na, pagꞌubus na mayan sin waktu maubus na in kabinsanaan yan,” laung hi Īsa, “magtūy na manigidlum in suga, diꞌ na sumawa in bulan iban mahulug na in manga bituun dayn ha langit iban majugjug na in unu-unu katān ha taas langit. ");
INSERT INTO tsg_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Pagꞌubus yadtu awn na gumuwaꞌ tandaꞌ ha taas langit mamaytaꞌ sin pagbalik ku pa dunya. Na, magkarukkaan tuud in manga mānusiyaꞌ pagkitaꞌ nila kākuꞌ, amu in Anak Mānusiyaꞌ, numaug magbalik mari pa dunya miyamagad ha kagabunan. Kakitaan nila na in kusug sin kawasa ku iban sin sahaya iban kalagguan ku. ");
INSERT INTO tsg_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pagꞌubus yadtu huyupun na in sangkakala, ampa ku na daakun in manga malāikat pa upat pidju sin ālam kumawaꞌ ha manga tau napīꞌ ku sukuꞌ ha katilibut sin dunya.” ");
INSERT INTO tsg_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Subay niyu pandugahan marayaw in kahuy tina. Bang niyu kakitaan in kahuy tina magꞌugbus iban magdahun na, kaingatan niyu na sin masuuk na in panuga. ");
INSERT INTO tsg_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Damikkiyan, bang niyu kakitaan na in manga katān biyaytaꞌ ku kaniyu, kaingatan niyu na sin masuuk na in pagbalik ku mari pa dunya, hangkarayꞌ dakuman. ");
INSERT INTO tsg_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Na, ini in tum-tuma niyu. In manga kiyabaytaꞌ ku yan, tantu dumatung mari kaniyu ha diꞌ pa maubus malanyap in bangsa sin manga tau ha masa ini. ");
INSERT INTO tsg_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Sabab ha susūngun in langit iban dunya ini malanyap da, sagawaꞌ in katān kiyapamung ku diꞌ tuud maluppas salama-lama (sabab in yan tantu tuud mabunnal).” ");
INSERT INTO tsg_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Malayngkan,” laung hi Īsa, “wayruun minsan hambuuk in makaingat sin adlaw iban waktu sin pagbalik ku mari pa dunya. Minsan in manga malāikat ha surgaꞌ iban sin aku baran ku amu in Anak Mānusiyaꞌ diꞌ da makaingat. Hambuuk-buuk da Tuhan, Amaꞌ ku, in makaingat sin pasal yan. ");
INSERT INTO tsg_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Bang aku magbalik na mari pa dunya in kahālan sin manga mānusiyaꞌ biyaꞌ da tuud sin kahālan sin manga tau ha waktu sin masa hi Nū. ");
INSERT INTO tsg_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ha waktu sin masa yadtu ha walaꞌ pa nagꞌumbak tawpan, amu in dunuk dakulaꞌ, in piyaparuli sin manga tau in pagkaun, pagꞌinum iban sin pagtiyaun sin manga usug iban babai. Biyaꞌ ha yan in hīnang sin manga tau sampay pa adlaw simakat na hinda Nū pa taas sin bahitraꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Walaꞌ nila tuud kiyaingatan in pasal sin kamulahan dumatung kanila sampay dimatung in umbak tawpan. Na, naluꞌmus sila katāntan. Na, biyaꞌ da isab ha yan in kahālan sin manga mānusiyaꞌ bang aku, amu in Anak Mānusiyaꞌ, magbalik na mari pa dunya. ");
INSERT INTO tsg_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Na, ha waktu sin pagbalik ku, bang awn duwa tau naghihinang ha uma, in hangka-tau dāhun na sin manga malāikat, ampa in hangka-tau makabīn. ");
INSERT INTO tsg_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bang awn duwa babai naggigiling gandum, in hangka-tau dāhun na sin manga malāikat, ampa in hangka-tau makabīn. ");
INSERT INTO tsg_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Na, hangkan jaga tuud kamu. Sabab diꞌ niyu kaingatan in waktu bang kuꞌnu adlaw aku, amu in Panghuꞌ niyu, magbalik mari. ");
INSERT INTO tsg_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Na, ingat kamu. Bang kaingatan sin tau tagdapu bāy bang kuꞌnu waktu sumūd in sugarul pa lawm bāy niya, na magjaga tuud siya iban diꞌ niya pasāran masūd in bāy niya. ");
INSERT INTO tsg_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Damikkiyan, subay isab biyaꞌ ha yan in kaagi niyu magjaga sin pagbalik ku, sabab in aku, amu in Anak Mānusiyaꞌ, magbalik mari pa dunya ha waktu diꞌ niyu mapikil magbalik aku.” ");
INSERT INTO tsg_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Sakali diyalil na isab hi Īsa in hantang sin pagbalik niya mari pa dunya. Laung niya, “Hisiyu-siyu in daraakun kapangandulan iban taga akkal amuna in pīun sin nakuraꞌ niya magparuli sin lawm pamāy-bāy niya. Siya in magparuli magdihil sin kakaun sin manga kaibanan daraakun ha sakabaꞌ waktu sin pagkaun. ");
INSERT INTO tsg_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Na, bang in daraakun ini datungan sin nakuraꞌ niya, naghihinang siya sin hinang kiyapangandul kaniya, na kumuyag tuud siya! ");
INSERT INTO tsg_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Na, baytaan ta kamu, tantu tuud in daraakun ini amu in pangandulan sin katān altaꞌ sin nakuraꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Sagawaꞌ, bang sawpama bukun marayaw in daraakun ini, laung niya ha lawm atay niya, ‘A, malugay pa magbalik in nakuraꞌ ku!’ ");
INSERT INTO tsg_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Na, binasahun niya in manga pagkahi niya daraakun. Hāti in siya maglami-lami magkaun iban magꞌinum iban sin manga tau maghihilu. ");
INSERT INTO tsg_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Sakali in nakuraꞌ sin daraakun ini nagtaghaꞌ na sadja nagbalik ha waktu walaꞌ niya naniyat sin dumatung in nakuraꞌ niya, sabab diꞌ niya kaingatan bang kuꞌnu in balik sin nakuraꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Na, tantu tadtarun siya sin nakuraꞌ niya iban magsibuꞌ na in uwian niya iban sin manga tau amu in magpabawꞌ-bawꞌ sadja himihinang sin daakan kanila. Makapanarkaꞌ na siya iban duun siya magtangis iban sumandal sin kasiksaan makalap.” ");
INSERT INTO tsg_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Manjari diyalil na isab hi Īsa in hantang sin pamarinta sin Tuhan. Laung niya, “Bang dumatung na in waktu sin pagbalik ku in hantang sin pamarinta sin Tuhan, biyaꞌ sapantun sin kahālan kumugdan ha hangpuꞌ budjang amu in nagdarā lampu-lampu pakaniya-pakaniya madtu mamāk ha pangantin usug. ");
INSERT INTO tsg_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","In lima budjang, dupang, ampa in kaibanan lima, taga akkal. ");
INSERT INTO tsg_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Sabab in manga budjang dupang nagdā sadja sin lampu nila, sagawaꞌ walaꞌ sila dimā dugaing lana hipaghipuꞌ bang maubus na in lana sin lampu nila. ");
INSERT INTO tsg_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Sagawaꞌ in lima taga akkal, dimā sila lana dugaing dayn sin luun sin lampu nila. ");
INSERT INTO tsg_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Na, ampa in pangantin usug biyāk nila, natarasaw in datung. Hangkan ha salugay nila nagtatagad, kiyaruꞌ sila sartaꞌ nakatūg na sila. ");
INSERT INTO tsg_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Sakali naabut mayan tungaꞌ dūm awn na imulak, amu agi, ‘Yan na in pangantin usug! Kari na kamu bāk.’ ");
INSERT INTO tsg_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Na, nakabatiꞌ na in hangpuꞌ budjang sartaꞌ diyayaw nila na in laga sin manga lampu nila. ");
INSERT INTO tsg_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Na, in manga lampu sin lima budjang dupang kiyaubusan na lana. Laung nila ha lima budjang taga akkal, ‘Dihili niyu ba kami lana sabab mapūng na in manga lampu-lampu namuꞌ ini.’ ");
INSERT INTO tsg_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“‘Diꞌ kamu karihilan namuꞌ,’ laung sin manga budjang taga akkal, ‘sabab diꞌ makainihan in lana ha kātuꞌniyu katān. Kadtu na kamu pamī pa tinda.’ ");
INSERT INTO tsg_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Na, miyadtu na pa tinda in manga budjang dupang namī lana. Na, ha saꞌbu nila walaꞌ duun dimatung na in pangantin usug. In lima budjang taga akkal amu in duun namāk ha pangantin usug, nakaagad ha pangantin usug pa bāy pagtiyaunan, sartaꞌ, pagꞌubus nila na mayan simūd tiyambul na in lawang sin bāy. ");
INSERT INTO tsg_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Bukun malugay dimatung in lima budjang dupang. Nagtawag na sila, laung nila, ‘Ū Tuwan, ukabi ba kami.’ ");
INSERT INTO tsg_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Sagawaꞌ, in sambung sin pangantin usug, laung niya, ‘Tantu diꞌ ta kamu ukaban sabab diꞌ ta kamu kaingatan!’” ");
INSERT INTO tsg_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Mahuli dayn duun, laung hi Īsa, “Na, hangkan jaga kamu tuud, sabab diꞌ niyu kaingatan in adlaw iban waktu sin pagbalik ku.” ");
INSERT INTO tsg_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Karnaꞌ,” laung hi Īsa, “in hantang sin pagbalik ku mari biyaꞌ yan sapantun sin kahālan sin hambuuk tau nagsakap tumulak. Sūng mayan siya tumulak, piyakawaꞌ niya in manga tindug niya, ampa niya piyamīn kanila in manga altaꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","In taud sin pilak piyamīn niya dayn hambuuk pa hambuuk piyapagtungud niya iban sin ingat-kapandayan nila magꞌusaha. In hambuuk tindug binīnan niya lima ngaibu pilak, in hangka-tau binīnan niya duwa ngaibu pilak, ampa in hambuuk binīnan niya hangibu pilak. Pagꞌubus, ampa siya timulak. ");
INSERT INTO tsg_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Na, in tindug amu in kiyabīnan lima ngaibu pilak, magtūy niya piyagꞌusaha in pilak binīn kaniya iban nakauntung siya isab lima ngaibu pilak. ");
INSERT INTO tsg_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Damikkiyan, in tindug kiyabīnan duwa ngaibu pilak, magtūy da isab piyagꞌusaha niya in pilak binīn kaniya iban nakauntung isab siya duwa ngaibu pilak. ");
INSERT INTO tsg_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Sagawaꞌ in tindug amu in kiyabīnan hangibu pilak, kimaliꞌ siya lupaꞌ ampa niya liyubung in pilak sin nakuraꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Limugay mayan dimatung na in nakuraꞌ nila. Piyatawag na sila sin nakuraꞌ nila sartaꞌ iyasubu na pakaniya-pakaniya bang iyunu nila in pilak binīn niya kanila. ");
INSERT INTO tsg_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Na, in tindug amu in kiyabīnan lima ngaibu pilak miyawn na imungsud sin pilak iban sin lima ngaibu pilak nauntung niya. Laung niya ha nakuraꞌ niya, ‘Tuwan, yari na in lima ngaibu pilak bakas mu binīn kākuꞌ, sartaꞌ yari pa isab awn dugaing lima ngaibu pilak untung sin sīn mu piyagꞌusaha ku.’ ");
INSERT INTO tsg_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Simambung in nakuraꞌ niya, laung niya, ‘Marayaw tuud in nahinang mu. Ikaw na yan in tindug taga kapūsan iban kapangandulan. Kapangandulan kaw magparuli sin altaꞌ sibiꞌ-sibiꞌ, hangkan hipangandul ku kaymu in altaꞌ ku labi dakulaꞌ dayn duun. Kari kaw bat kaw kumuyag biyaꞌ kākuꞌ.’ ");
INSERT INTO tsg_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Pagꞌubus, simunud na isab miyawn in tindug amu in bakas binīnan duwa ngaibu pilak. Laung niya ha nakuraꞌ niya, ‘Tuwan, yari na in duwa ngaibu pilak bakas mu binīn kākuꞌ, sartaꞌ yari pa isab awn dugaing duwa ngaibu pilak untung sin sīn mu piyagꞌusaha ku.’ ");
INSERT INTO tsg_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Simambung in nakuraꞌ niya, laung niya, ‘Marayaw tuud in nahinang mu. Ikaw na yan in tindug taga kapūsan iban kapangandulan! Kapangandulan kaw magparuli sin altaꞌ sibiꞌ-sibiꞌ, hangkan hipangandul ku kaymu in altaꞌ ku labi dakulaꞌ dayn duun. Kari kaw bat kaw kumuyag biyaꞌ kākuꞌ.’ ");
INSERT INTO tsg_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Pagꞌubus miyawn na isab in tindug amu in bakas binīnan hangibu pilak. Laung niya, ‘Tuwan kaingatan ku in ikaw yan diꞌ maluuy ha pagkahi mu sabab anyayahun mu sadja sila. Magdayaw parasahan sadja kaw sin unu-unu walaꞌ mu piyaghulas-sangsaan. Amu in pagꞌiyanun magꞌani kaw sin bukun mu tiyanum. ");
INSERT INTO tsg_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Na, in aku mabugaꞌ kaymu, hangkan kiyalian ku in pilak mu ampa ku liyubung ha lawm lupaꞌ. Yari na in pilak bakas binīn mu kākuꞌ.’ ");
INSERT INTO tsg_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Simambag in nakuraꞌ niya, laung niya, ‘Ikaw na yan in tindug way kapūsan iban lisuan! Bukun ka biyaꞌ na sin agi mu, in aku magdayaw parasahan sadja sin unu-unu walaꞌ ku piyaghulas-sangsaan, iban in aku magꞌani sadja sin bukun ku tiyanum? ");
INSERT INTO tsg_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Na, pagga mu yan kiyaiingatan, maytaꞌ mu walaꞌ biyutang ha bangku in pilak piyangandul ku kaymu, ha supaya pagbalik ku mari makawaꞌ ku magbalik in pilak ku iban sin anak niya?’ ");
INSERT INTO tsg_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Pagꞌubus yadtu ampa namung in nakuraꞌ ha manga kaibanan tindug niya, laung niya, ‘Kawaa niyu in pilak yan dayn kaniya ampa niyu dihilan madtu pa hangka-tau amu in taga hangpuꞌ ngaibu pilak. ");
INSERT INTO tsg_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Karnaꞌ hisiyu-siyu in matuyuꞌ magpasūng sin altaꞌ kiyarihil kaniya dugangan pa iban maglabi-labihan pa in hirihil kaniya, sagawaꞌ hisiyu-siyu in way tuyuꞌ, minsan in maniyuꞌ-tiyuꞌ altaꞌ niya kawaun da dayn kaniya. ");
INSERT INTO tsg_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na, in tindug amu in way kapūsan yan larukan niyu madtu pa lawm katigidluman. Didtu siya magtangis iban sumandal sin kasiksaan makalap.’” ");
INSERT INTO tsg_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Pagꞌubus yadtu namung hi Īsa, laung niya, “Bang aku, amu in Anak Mānusiyaꞌ, magbalik na mari pa dunya kakitaan niyu na in kalagguan ku. Magbalik aku mari iban sin katān malāikat, lāgiꞌ aku na in magsultan iban manghukum ha manga mānusiyaꞌ katān. ");
INSERT INTO tsg_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Na, in mānusiyaꞌ katān mawn na magtipun kākuꞌ. Bahagiun ku sila magduwa ampa ku pīun in manga sukuꞌ ku biyaꞌ kaagi sin magꞌiipat bili-bili magpīꞌ sin manga bili-bili dayn ha manga kambing. ");
INSERT INTO tsg_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","In manga tau mabuntul hibutang ku ha dapit pa tuu ku, ampa in manga tau mangīꞌ hibutang ku ha dapit pa lawa. ");
INSERT INTO tsg_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Pagꞌubus ampa aku, amu in magbabayaꞌ, mamung ha manga tau ha dapit pa tuu ku, laung ku, ‘Kari kamu manga tau sukuꞌ ku. Awn karayawan niyu dayn ha Tuhan, Amaꞌ ku! Kari kamu tumaymaꞌ sin manga karayawan ha lawm pamarintahan sin Tuhan, amu in pusakaꞌ asal tiyatagama kaniyu dayn ha tagnaꞌ kapaawn sin dunya. ");
INSERT INTO tsg_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","(Amu yan in tungbas kaniyu.) Sabab ha waktu hiyapdiꞌ aku dīhilan niyu aku pagkaun iban ha waktu iyuhaw aku dīhilan niyu aku inumun. Ha waktu nākawn aku pa kawman niyu iyupiksaꞌ niyu aku ha lawm bāy niyu. ");
INSERT INTO tsg_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ha waktu kulang in tamungun ku dīhilan niyu aku tamungun. Ha waktu nāsakit aku, īpat niyu aku. Ha waktu ha lawm jīl aku, bīsita niyu aku.’ ");
INSERT INTO tsg_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Sakali in manga tau mabuntul ha dapit pa tuu ku mangasubu, laung nila, ‘Panghuꞌ, kaꞌnu namuꞌ kaw kītaꞌ hiyapdiꞌ iban iyuhaw, hāti dīhilan namuꞌ kaw kakaun iban inumun? ");
INSERT INTO tsg_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kaꞌnu namuꞌ kaw kītaꞌ miyari pa kawman namuꞌ, hāti iyupiksaꞌ namuꞌ kaw ha bāy namuꞌ? Atawa kulang in tamungun mu, hāti dīhilan namuꞌ kaw tamungun? ");
INSERT INTO tsg_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Atawa kaꞌnu kaw kītaꞌ namuꞌ nāsakit atawa najīl, hāti bīsita namuꞌ kaw?’ ");
INSERT INTO tsg_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Sambagun sila sin magbabayaꞌ, amu in aku, laung ku, ‘Ini in mattan hibaytaꞌ ku kaniyu. Ha unu-unu waktu nahinang niyu in manga nasabbut ku yan ha manga tau agad kākuꞌ minsan wayruun gaus nila, na biyaꞌ da tuud baran ku in tiyabang niyu!’ ");
INSERT INTO tsg_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Pagꞌubus ampa na isab aku mamung ha manga tau dapit pa lawa ku. Laung ku kanila, ‘Īg kamu dayn dī sabab in kamu yan piyagmurkaan sin Tuhan! Kadtu kamu pa narkaꞌ amu in hulaan asal tiyatagama ha Iblis iban sin manga tindug niya. ");
INSERT INTO tsg_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","(Amu yan in tungbas tūp kaniyu.) Sabab ha waktu hiyapdiꞌ aku, walaꞌ niyu aku dīhilan pagkaun iban ha waktu iyuhaw aku walaꞌ niyu aku dīhilan inumun. ");
INSERT INTO tsg_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ha waktu miyawn aku pa kawman niyu, walaꞌ niyu aku iyupiksaꞌ ha bāy niyu. Ha waktu kulang in tamungun ku, walaꞌ niyu aku dīhilan tamungun. Ha waktu najijīl iban nāsakit aku, walaꞌ niyu aku īpat.’ ");
INSERT INTO tsg_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Na, sumambag sila kākuꞌ, laung nila, ‘Panghuꞌ, kaꞌnu namuꞌ bahaꞌ kaw kītaꞌ hiyapdiꞌ, atawa iyuhaw, atawa miyawn pa kawman namuꞌ, atawa kulang in tamungun mu atawa nāsakit kaw atawa najīl kaw ha walaꞌ namuꞌ kaw tiyabang?’ ");
INSERT INTO tsg_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Na, sambagun ku sila, laung ku, ‘Ini in mattan hibaytaꞌ ku kaniyu. Ha kuꞌnu-kuꞌnu waktu walaꞌ niyu tiyabang in manga tau agad kākuꞌ, minsan wayruun gaus nila, biyaꞌ da tuud baran ku in walaꞌ niyu tiyabang.’ ");
INSERT INTO tsg_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Na, in manga tau yan pakadtuun pa lawm narkaꞌ iban duun sila siksaun salama-lama. Ampa in manga tau mabuntul hikadtu pa lawm surgaꞌ iban dihilan kabuhiꞌ salama-lama.” ");
INSERT INTO tsg_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Manjari naubus mayan hi Īsa nanghinduꞌ sin katān palihālan yadtu, namung siya ha manga mulid niya, laung niya, ");
INSERT INTO tsg_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Biyaꞌ na sin kiyaiingatan niyu, duwa adlaw dakuman in Haylaya sin Paglappas dayn ha Kamatay. Na, ha waktu yan in aku, amu in Anak Mānusiyaꞌ, saggawun na, ampa hitukbal pa lawm lima sin manga tau taga kawasa bat hikalansang pa usuk.” ");
INSERT INTO tsg_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na, ha saꞌbu hi Īsa namimichara ha manga mulid niya, in manga nakuraꞌ sin kaimaman iban sin manga nagtatau-maas ha hulaꞌ nagtipun, sartaꞌ nagꞌisun duun ha bāy dakulaꞌ hi Kayapas, amu in Imam Dakulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nagꞌisun sila sin subay tapuk kaagi in pagsaggaw kan Īsa iban subay siya patayun. ");
INSERT INTO tsg_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Laung nila, “Subay natuꞌ siya diꞌ saggawun ha saꞌbu sin paghaylaya sabab gana-gana maghiluhalaꞌ in manga tau.” ");
INSERT INTO tsg_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Sakali in hi Īsa duun ha kawman Bitani, ha bāy hi Simun, amu in tau bakas īipul. ");
INSERT INTO tsg_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ha saꞌbu niya nagkakaun duun ha bāy hi Simun, awn miyawn hambuuk babai nagdarā kibut-kibut habaꞌ liug pagtawagun alabistrus hipuꞌ sin lana mahamut mahargaꞌ. Biyusug sin babai in lana mahamut pa ū hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pagkitaꞌ sin manga mulid hi Īsa, diyugalan sila ha babai. Laung nila, “Maytaꞌ mu iyusibaan in lana mahamut? ");
INSERT INTO tsg_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Bang in lana mahamut yan kiyapagdagang, mataud sīn in bīhan niya, amu in sīn hikasarakka ha manga miskin!” ");
INSERT INTO tsg_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kiyaiingatan hi Īsa bang unu in ha lawm pikilan nila. Laung niya, “Ayaw niyu pasusaha in atay sin babai ini, karnaꞌ in nahinang niya kākuꞌ marayaw tuud. ");
INSERT INTO tsg_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","In manga tau miskin matabang niyu sadja ha kuꞌnu-kuꞌnu waktu sabab yari sila dī kaniyu, sagawaꞌ in aku ini diꞌ lumugay taptap dī kaniyu. ");
INSERT INTO tsg_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Hangkan aku biyuꞌsugan lana mahamut sin babai ini ha supaya ha pagkubul kākuꞌ asal na saddiya in anggawtaꞌ-baran ku. ");
INSERT INTO tsg_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Na, ini in mattan hibaytaꞌ ku kaniyu. Hawnu-hawnu na mayan dī ha katilibut sin dunya, hipamahalayak in Baytaꞌ Marayaw, hikasuysuy in nahinang kākuꞌ sin babai ini gantiꞌ panumtuman kaniya.” ");
INSERT INTO tsg_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Manjari awn hambuuk ha hangpuꞌ tagduwa mulid hi Īsa, amu in pagngānan Judas tau dayn ha Kiriyud, miyadtu pa manga nakuraꞌ kaimaman. ");
INSERT INTO tsg_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Laung niya ha manga nakuraꞌ kaimaman, “Pila in hirihil niyu kākuꞌ bang ku hitukbal pa lawm lima niyu hi Īsa?” Na, dīhilan nila siya katluan pilak batu. ");
INSERT INTO tsg_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Pagꞌubus tagnaan dayn ha waktu yadtu simipi na marayaw hi Judas bang biyaꞌ diin in katipu niya kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Manjari ha adlaw panagnaan sin pakaradjaan pagkaun sin tinapay way pasulig niya, miyawn kan Īsa in manga mulid niya nangasubu, laung nila “Tuwan, hariin mu kabayaan sakapun namuꞌ in pagjamuhan taniyu?” ");
INSERT INTO tsg_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","In sambag hi Īsa, laung niya, “Kadtu kamu pa dāira, ampa niyu baytai in hambuuk tau hipaglanggal niyu didtu. Biyaꞌ ha ini in hibaytaꞌ niyu kaniya, ‘Nagbaytaꞌ in Tuwan Guru mabayaꞌ siya magjamu hipagsaꞌbu sin Haylaya Paglappas Dayn ha Kamatay iban sin manga mulid niya duun ha bāy mu, sabab bukun na malugay manaykud na siya dayn ha dunya ini.’” ");
INSERT INTO tsg_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Na, miyadtu na in manga mulid hi Īsa sartaꞌ iyagad nila in baytaꞌ hi Īsa. Siyaddiya nila na in pagjamuhan nila. ");
INSERT INTO tsg_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Na, naabut mayan magrib limingkud na hi Īsa nagjamu iban sin hangpuꞌ tagduwa mulid niya. ");
INSERT INTO tsg_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ha saꞌbu nila nagjajamu, namung hi Īsa, laung niya, “Ini in mattan hibaytaꞌ ku kaniyu. Awn hambuuk dī kaniyu in manipu kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Na, nasusa tuud in manga mulid niya sartaꞌ nangasubu na pakaniya-pakaniya, laung nila, “Uy, tantu Panghuꞌ, bukun aku in piyagꞌiyan mu?” ");
INSERT INTO tsg_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","In sambag hi Īsa, laung niya, “In tau manipu kākuꞌ amu in simasāw kākuꞌ timublak sin tinapay niya pa lāy pagbabahug-bahugan. ");
INSERT INTO tsg_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","In aku amu in Anak Mānusiyaꞌ manaykud na dayn ha dunya biyaꞌ na sin asal kiyabaytaꞌ ha lawm Kitab! Sagawaꞌ murkaꞌ dakulaꞌ in kumugdan ha tau manipu kākuꞌ! Marayaw pa sa walaꞌ na siya piyagꞌanak!” ");
INSERT INTO tsg_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Sakali, nangasubu hi Judas, amu in manipu kan Īsa, laung niya “Uy, Tuwan, aku ka in piyagꞌiyan mu?” Laung hi Īsa kaniya, “Na, kiyapamung mu na.” ");
INSERT INTO tsg_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ha saꞌbu nila nagkakaun, kimawaꞌ hi Īsa tinapay ampa siya nagsarang-sukul pa Tuhan. Pagꞌubus ampa niya sīpak in tinapay diyuhal pa manga mulid niya. Laung niya ha manga mulid niya, “Kawaa niyu ini ampa niyu kauna iban niyat sin amu yan in ginhawa-baran ku.” ");
INSERT INTO tsg_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pagꞌubus ampa kiyawaꞌ hi Īsa in hambuuk sawan, ampa siya nagsarang-sukul pa Tuhan. Pagꞌubus ampa niya diyuhal in sawan pa manga mulid niya. Laung niya, “In kamu katān, inuma niyu ini. ");
INSERT INTO tsg_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Niyata niyu sin amu yan in duguꞌ ku, amu in dumihil kamakbulan ha janjiꞌ baꞌgu sin Tuhan ha manga tau sukuꞌ niya. Maasag in duguꞌ ku ha supaya mataud tau in maampun dayn ha manga dusa nila. ");
INSERT INTO tsg_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Na, ini in mattan hibaytaꞌ ku kaniyu. Diꞌ na aku minum magbalik sin tubig anggul ini ha salugay diꞌ dumatung in waktu magmakbul na in maksud sin pamarinta sin Amaꞌ ku. Lāgiꞌ mabaꞌgu na in unu-unu katān. Tantu ha waktu yan humambuuk aku kaniyu magꞌinum magbīng biyaꞌ ha ini.” ");
INSERT INTO tsg_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pagꞌubus ampa sila nagkalang sin kalangan pamudji pa Tuhan ubus ampa sila miyadtu pa Būd Jaytun. ");
INSERT INTO tsg_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Na, ha sūng nila pa Būd Jaytun, namung hi Īsa ha manga mulid niya, laung niya, “Dūm ini in kamu katān maguy, iban mutas na kamu dayn kākuꞌ sabab asal kiyasulat ha lawm Kitab, amu agi, ‘Hirūl sin Tuhan mapatay in magꞌiipat ha manga bili-bili iban mapulak-palik in manga bili-bili niya.’ ");
INSERT INTO tsg_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Sagawaꞌ,” laung hi Īsa, “mabuhiꞌ mayan aku magbalik dayn ha kamatay, madtu aku muna dayn kaniyu pa hulaꞌ Jalil. Magbāk kitaniyu didtu.” ");
INSERT INTO tsg_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Sakali namung hi Pitrus kan Īsa, laung niya, “Tuwan, tantu tuud diꞌ aku mutas dayn kaymu, minsan in sila katān mutas dayn kaymu!” ");
INSERT INTO tsg_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Laung hi Īsa kan Pitrus, “Indani in bichara ku ini. Ha dūm ini ha diꞌ pa maabut tumugauk in manuk usug sin subu-subu, makatū kaw umiyan, laung mu diꞌ mu aku kaingatan.” ");
INSERT INTO tsg_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Simambag hi Pitrus, laung niya, “Tuwan, tantu diꞌ aku umiyan sin diꞌ ta kaw kaingatan minsan pa aku mapatay umunung kaymu.” Na, biyaꞌ da isab hādtu in pamung sin katān mulid niya. ");
INSERT INTO tsg_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Manjari limanjal hi Īsa iban sin manga mulid niya madtu pa hambuuk lugal pagtawagun Gitsimani. Duun mayan sila, namung hi Īsa ha manga mulid niya, laung niya, “Lingkud na kamu dī. Madtu pa aku didtu mangarap pa Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Piyaagad niya kaniya hi Pitrus iban sin duwa anak hi Sibidi. Nagdukka iban nasusa in lawm atay hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Laung niya ha tūngka-tau, “Landuꞌ tuud in dukka sin lawm atay ku, agun-agun na hikamatay ku. Tagad na kamu dī iban agad kamu kākuꞌ magjaga.” ");
INSERT INTO tsg_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Na, limayuꞌ-layuꞌ hi Īsa dayn ha manga mulid, ampa siya simujud pa lupaꞌ sartaꞌ nangarap na siya pa Tuhan. Nangayuꞌ siya duwaa, laung niya, “Ū Amaꞌ ku, bang makajari kaymu, ayaw mu na aku palabaya sin kabinsanaan ini. Sagawaꞌ bukun kabayaan ku in maagad, saꞌ amu in kabayaan mu.” ");
INSERT INTO tsg_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pagꞌubus ampa siya nagbalik pa tū mulid niya. Pagkitaꞌ niya natutūg in mulid niya. Laung niya kan Pitrus, “Ay kaw naa, diꞌ ka kamu makatatas magad magjaga kākuꞌ minsan dakuman hangka-jām? ");
INSERT INTO tsg_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pagjaga kamu iban pangayuꞌ kamu duwaa bat kamu diꞌ marā sin sasat makapilad sin īman niyu. Bunnal na sa ha lawm pikilan iban atay niyu mabayaꞌ tuud kamu magad sin daakan ku, sagawaꞌ in anggawtaꞌ-baran niyu maluhay marā sin sasat.” ");
INSERT INTO tsg_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Pagꞌubus, limayuꞌ-layuꞌ na isab siya nagbalik dayn ha tūngka-tau ampa siya nangarap pa Tuhan. Laung niya, “Ū Amaꞌ ku, bang subay da tuud aku lumabay sin kabinsanaan ini, na maagad in kabayaan mu.” ");
INSERT INTO tsg_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pagbalik niya, kītaꞌ niya natutūg in tūngka-tau, sabab diꞌ sila makasandal sin karuꞌ nila. ");
INSERT INTO tsg_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Pagꞌubus, limayuꞌ-layuꞌ na isab hi Īsa dayn kanila ampa na isab siya nangarap pa Tuhan nagbalik. Biyalikan niya na isab in manga lapal-kabtangan niya. ");
INSERT INTO tsg_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ubus yadtu ampa siya nagbalik madtu pa manga mulid niya. Laung niya kanila, “Bat natutūg pa kamu yan hāti iban naghahali-hali. Taynghug kamu! Miyabut na in waktu! Bihaun in aku amu in Anak Mānusiyaꞌ, hiungsud na pa lawm lima sin manga tau baldusa. ");
INSERT INTO tsg_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bangun na kamu bat kitaniyu mākadtu na. Kitaa niyu ba, yan na in tau manipu kākuꞌ!” ");
INSERT INTO tsg_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ha saꞌbu pa nagbibichara hi Īsa, dimatung na mawn hi Judas, amu in hambuuk dayn ha hangpuꞌ tagduwa mulid hi Īsa. Mataud in tau miyamagad kaniya nagdarā manga pakukus iban kakakal. In manga tau ini diyaak sin manga nakuraꞌ kaimaman iban sin manga nagtatau-maas ha hulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na, asal biyaytaan hi Judas in manga tau, laung niya, “In tau siyumun ku amuna in tau saggawun niyu!” ");
INSERT INTO tsg_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pagdatung hi Judas magtūy siya timūy madtu kan Īsa. Laung niya, “Assalamu alaykum, Tuwan.” Ubus ampa niya sīyum hi Īsa. (Karnaꞌ biyaꞌ ha yan in addat sin manga Yahudi bang sila magbāk magpagkahi.) ");
INSERT INTO tsg_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Simambag hi Īsa, laung niya, “Na, bagay, hinanga na magtūy in gawi mu miyari.” Sakali siyuuk na sin manga tau hi Īsa siyaggaw ampa giyapus. ");
INSERT INTO tsg_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na, magtūy liyarut sin hambuuk mulid hi Īsa in pakukus niya, ampa liyagut in hambuuk daraakun sin Imam Dakulaꞌ. Nautud in hansipak taynga sin tau liyagut niya. ");
INSERT INTO tsg_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Pagkitaꞌ hi Īsa, laung niya ha mulid niya, “Butangan in pakukus mu magbalik pa taguban niya. Sabab hisiyu-siyu in mangatu iban pakukus mapatay da isab kaagi sin pakukus. ");
INSERT INTO tsg_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Walaꞌ mu ka kiyaingatan sin makapangayuꞌ aku tabang ha Tuhan, Amaꞌ ku, lāgiꞌ saruun-duun parāhan niya aku ibuhan malāikat tumabang kākuꞌ? ");
INSERT INTO tsg_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Sagawaꞌ bang ku yan hinangun, biyaꞌ diin in kamakbul sin baytaꞌ ha lawm Kitab sin subay biyaꞌ ha ini in kumugdan kākuꞌ?” ");
INSERT INTO tsg_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pagꞌubus namung hi Īsa pa manga tau mataud, laung niya, “Maytaꞌ, mundu ka aku ini, subay niyu saggawun iban sin pakukus iban kakakal niyu? Adlaw-adlaw duun aku naglilingkud nagnanasīhat ha halaman sin Bāy sin Tuhan, sagawaꞌ maytaꞌ niyu aku walaꞌ siyaggaw didtu? ");
INSERT INTO tsg_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Sagawaꞌ in katān ini naawn ha supaya mabunnal in kiyasulat sin manga nabi ha lawm Kitab.” Pagꞌubus miyutas na dayn kan Īsa in katān mulid niya, iban miyaguy na sila. ");
INSERT INTO tsg_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Manjari, in hi Īsa diyā na sin manga tau nakasaggaw kaniya madtu pa bāy hi Kayapas, amu in Imam Dakulaꞌ. Duun natitipun in manga guru sin saraꞌ agama iban sin manga nagtatau-maas ha hulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Sakali in hi Pitrus miyumurul kan Īsa dayn ha kalayuan sampay nakaabut pa halaman bāy sin Imam Dakulaꞌ. Simūd siya pa lawm halaman ampa siya limingkud limamugay ha manga jaga bat niya kaingatan bang unu in kumugdan kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","In manga nakuraꞌ kaimaman iban sin katān nakuraꞌ Yahudi manghuhukum, nanglawag tuud sin makasaksiꞌ sin puting pasalan hi Īsa, ha supaya awn puun-sabab in hi Īsa kabutangan sin hukuman subay patayun. ");
INSERT INTO tsg_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Sagawaꞌ minsan da mataud na in simaksiꞌ sin puting, wayruun da dusa kabaakan nila amu in patut pamutangan kan Īsa hukuman subay patayun. Sakali awn na tuud duwa tau timindug miyadtu pa unahan sartaꞌ namung, laung nila, ");
INSERT INTO tsg_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“In tau yan bakas namuꞌ diyungug imiyan sin malubu niya in Bāy sin Tuhan, ubus ampa siya kunuꞌ magpatindug dugaing ha lawm tūy adlaw.” ");
INSERT INTO tsg_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pagdungug sin Imam Dakulaꞌ, timindug siya sartaꞌ namung kan Īsa, laung niya, “Na, unu in hikasambung mu ha manga saksiꞌ ini pasal sin baytaꞌ nila sin narusa mu?” ");
INSERT INTO tsg_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Walaꞌ nagkaybaꞌ hi Īsa. Namichara na isab nagbalik in Imam Dakulaꞌ kaniya, amu agi, “Na, bihaun sapa kaw iban Tuhan in saksiꞌ mu, amu in Tuhan asal buhiꞌ, sin in ikaw amuna in Almasi, amu in Anak Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Simambag hi Īsa, laung niya, “Na, kiyapamung mu na. Sagawaꞌ ini in mattan hibaytaꞌ ku kaniyu katān. Bukun na malugay in aku amu in Anak Mānusiyaꞌ limingkud na ha dapit pa tuu sin Tuhan Mahatinggi, iban ha pagbalik ku mari ha susūngun kakitaan niyu aku miyamagad ha lawm gabun!” ");
INSERT INTO tsg_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pagdungug sin Imam Dakulaꞌ sin bichara hi Īsa, magtūy niya gīsiꞌ in juba niya (sabab diyugalan tuud siya). Ampa siya namung, laung niya, “In bichara niya yan pangkal pa Tuhan. Na, maytaꞌ pa kitaniyu maglawag manga saksiꞌ? Diyungug niyu na in bichara niya pangkal! ");
INSERT INTO tsg_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Na, ha pikil niyu unu in hukuman hibutang natuꞌ kaniya?” Simambag in manga nakuraꞌ kaimaman iban sin manga nakuraꞌ manghuhukum, laung nila, “In tūp kaniya, subay siya patayun.” ");
INSERT INTO tsg_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Pagꞌubus liyuraan sin manga tau hi Īsa ha bayhuꞌ ampa nila siyuntuk. Hāti in kaibanan tiyabunan nila in mata hi Īsa ampa nila biyaga. ");
INSERT INTO tsg_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Pagꞌubus ampa sila namung, laung nila, “Na, bang ikaw in Almasi, baytai kunuꞌ kami bang hisiyu in namaga kaymu!” ");
INSERT INTO tsg_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Sakali ha saꞌbu hi Pitrus duun naglilingkud ha halaman sin bāy, nakakawn na tuud in hambuuk daraakun babai sin Imam Dakulaꞌ. Laung niya kan Pitrus, “In ikaw yan agad da isab kan Īsa, amu in tau dayn ha hulaꞌ Jalil.” ");
INSERT INTO tsg_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Sagawaꞌ namaylu tuud hi Pitrus ha alupan sin tau katān. Laung niya, “Diꞌ ku kaingatan bang unu in bībichara niyu yan.” ");
INSERT INTO tsg_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ubus ampa siya gimuwaꞌ miyadtu pa labayan sin lawang sin halaman bāy. Sakali awn na isab hambuuk daraakun babai nākitaꞌ kaniya. Laung sin babai ini ha manga tau duun ha halaman, “In tau yan agad kan Īsa amu in dayn ha Nasarit.” ");
INSERT INTO tsg_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Namaylu na isab nagbalik hi Pitrus, laung niya, “Utukan pa aku bang ku kaingatan in tau piyagꞌiyan niyu yan.” ");
INSERT INTO tsg_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Na, bukun mawgay in manga tau nagtitindug duun ha halaman miyawn kan Pitrus. Laung nila, “Mattan tuud in ikaw yan agad kanila, sabab dayn ha dāhan sin pagbichara mu diꞌ kaw makapaylu sin in ikaw tau dayn ha hulaꞌ Jalil.” ");
INSERT INTO tsg_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Sakali nagsuknaꞌ-suknaꞌ tuud hi Pitrus sin baran niya iban simapa siya, laung niya, “Bang mayan aku pagmurkaan sin Tuhan bang puting in baytaꞌ ku yan kaniyu! Diꞌ ku tuud kaingatan in tau piyagꞌiyan niyu yan.” Na, magtūy na timagauk in manuk usug. ");
INSERT INTO tsg_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pagdungug hi Pitrus ampa niya kiyatumtuman in baytaꞌ hi Īsa kaniya. Amu agi hi Īsa, “Ha diꞌ pa tumagauk in manuk usug, makatū kaw imiyan sin in aku diꞌ mu kaingatan.” Na, kiyatumtuman niya mayan in agi hi Īsa, gimuwaꞌ na siya dayn ha halaman sin bāy dakulaꞌ ampa siya nagtangis tuud. ");
INSERT INTO tsg_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Manjari pagbulat mahinaat nagꞌisun na in manga katān nakuraꞌ sin kaimaman iban sin manga nagtatau-maas ha hulaꞌ, bang biyaꞌ diin in pagpatay kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Na, kiyadinahan nila hi Īsa, ampa nila diyā madtu tiyukbal pa lawm lima hi Pilatu, amu in gubnul sin parinta sin hulaꞌ Rūm. ");
INSERT INTO tsg_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Na, pagꞌingat mayan hi Judas, amu in nanipu kan Īsa sin in hukuman biyutang kan Īsa subay patayun, nagsusun tuud siya sin nahinang niya. Iyuliꞌ niya na in katluan pilak batu pa manga nakuraꞌ sin kaimaman iban sin manga nagtatau-maas ha hulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Laung niya, “Nagdusa aku sabab tīpu ku in tau way dusa ha supaya siya mapatay!” “Na, in yan way na lamud namuꞌ. Bayaꞌ-bayaꞌ mu na,” in sambag sin manga nakuraꞌ kaimaman iban sin manga nagtatau-maas ha hulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Sakali liyaruk hi Judas in manga pilak batu pa lawm sin Bāy sin Tuhan, ubus ampa siya minīg, miyadtu naggantung sin baran niya. ");
INSERT INTO tsg_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Piyūt sin manga nakuraꞌ kaimaman in sīn, ampa sila namung, laung nila, “In sīn ini langgal saraꞌ sin agama bang hilamud ha sīn sin Bāy sin Tuhan, sabab bakas ini piyanangdan hipagpatay ha tau.” ");
INSERT INTO tsg_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pagꞌubus piyagꞌisunan nila na bang unuhun in sīn. Na, in kiyapagꞌisunan nila, in sīn piyamī nila lupaꞌ sin tau maghihinang anglit lupaꞌ. In lupaꞌ ini hīnang pangubulan sin manga patay dayn ha dugaing hulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hangkan na in lupaꞌ yan sampay pa bihaun in pagtawag Lupaꞌ Binī sin Duguꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Na, dayn duun nabunnal in bakas kiyabaytaꞌ hi Nabi Irmiyas ha lawm Kitab, amu agi, “Kiyawaꞌ nila in katluan pilak batu, amu in hargaꞌ kiyapagꞌisunan sin manga tau Israil hipanangdan ha pagpatay kaniya. ");
INSERT INTO tsg_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Pagꞌubus ampa nila piyamī in sīn lupaꞌ sin tau maghihinang anglit lupaꞌ. In ini daakan kākuꞌ sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Sakali narā mayan hi Īsa mawn kan Gubnul Pilatu, duun na siya nagtitindug siyumariya sin gubnul. Laung sin gubnul kaniya, “Ikaw na ka in sultan sin manga Yahudi?” “Na, biyaꞌ na sin kiyapamung mu,” in sambag hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sagawaꞌ siyumariya mayan siya sin manga nakuraꞌ kaimaman iban sin manga nagtatau-maas ha hulaꞌ, walaꞌ tuud siya simambung minsan hangka-kabtang sin manga tuntut kaniya. ");
INSERT INTO tsg_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Na, laung hi Pilatu kaniya, “Walaꞌ mu ka kiyarungugan in katān tuntut nila kaymu?” ");
INSERT INTO tsg_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Sagawaꞌ walaꞌ tuud hi Īsa simambung minsan hangka-kabtang. Hangkan landuꞌ tuud nainu-inu in gubnul. ");
INSERT INTO tsg_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na, tahun-tahun biyaꞌ na sin pagkabiyaksahan sin gubnul ha sakabaꞌ waktu sin Haylaya Paglappas dayn ha Kamatay, paguwaun niya in hambuuk pilisu amu in kabayaan sin manga Yahudi paguwaun. ");
INSERT INTO tsg_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ha waktu yadtu awn hambuuk pilisu landuꞌ bantug. In ngān niya hi Barabbas. ");
INSERT INTO tsg_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Sakali natipun mayan in manga tau mataud, iyasubu sila hi Pilatu, laung niya, “Hisiyu ha duwa pilisu in kabayaan niyu paguwaun ku? Hi Barabbas atawa hi Īsa amu in pagngānan Almasi?” ");
INSERT INTO tsg_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Hangkan hi Pilatu nangasubu sabab asal kiyaiingatan niya sin in manga nakuraꞌ kaimaman iban sin manga nagtatau-maas ha hulaꞌ maabughuꞌ kan Īsa, hangkan tiyukbal nila hi Īsa pa lawm lima niya. ");
INSERT INTO tsg_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ha saꞌbu hi Pilatu limilingkud ha bilik paghuhukuman, nagparā lapal mawn kaniya in asawa niya, amu agi, “Ayaw kaw lumamud sin pagpatay ha tau yan, sabab wayruun tuud dusa sin tau yan. Karnaꞌ kābii mangīꞌ tuud in parasahan ku sin tagainup ku pasal niya.” ");
INSERT INTO tsg_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Na, bīcharahan sin manga nakuraꞌ sin kaimaman iban sin manga nagtatau-maas ha hulaꞌ in manga tau hipapangayuꞌ kan Pilatu paguwaun hi Barabbas, hāti in hi Īsa hipapatay. ");
INSERT INTO tsg_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Sakali iyasubu na sin gubnul in manga tau, laung niya, “Hisiyu ha duwa ini in kabayaan niyu paguwaun ku?” “Hi Barabbas,” in sambung sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Na, unu in hinangun ku kan Īsa amu in pagngānan Almasi?” laung hi Pilatu ha manga tau. “Palansangan siya pa usuk,” in sambag sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Laung hi Pilatu kanila, “Maytaꞌ? Unu in dusa nahinang niya?” Sagawaꞌ walaꞌ siyambag sin manga tau in pangasubu niya. Gām mayan nagꞌulak na makusug in manga tau. Laung nila, “Palansangan na siya pa usuk.” ");
INSERT INTO tsg_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pagga ha kītaꞌ hi Pilatu diꞌ niya da malāng in kabayaan sin manga tau sabab maawn na sadja in hiluhalaꞌ, kimawaꞌ siya tubig ampa niya hiyugasan in lima niya ha alupan sin manga tau mataud (tandaꞌ sin wayruun lamud niya sin pagpatay kan Īsa.) Ubus ampa siya namung, laung niya, “Mamuas aku sin pagpatay ha tau ini! Kamu in mangaku sin dusa sin pagpatay kaniya!” ");
INSERT INTO tsg_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Simambag in manga tau, laung nila, “Akuhun namuꞌ iban sin manga kaawꞌanakan namuꞌ in dusa sin pagpatay kaniya!” ");
INSERT INTO tsg_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pagꞌubus piyaguwaꞌ na hi Pilatu hi Barabbas dayn ha lawm jīl. Hāti ampa niya piyalubakan hi Īsa, ubus ampa niya tiyukbal pa manga sundalu hipapalansang pa usuk pagpatayan kaniya. ");
INSERT INTO tsg_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pagꞌubus diyā na hi Īsa sin manga sundalu hi Pilatu madtu pa bāy dakulaꞌ sin gubnul. Duun mayan siya piyaglibutan na siya sin katān sundalu hangka-panji. ");
INSERT INTO tsg_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Inīgan nila in badjuꞌ hi Īsa, ampa nila siya siyulugan sin siub badjuꞌ taluk biyaꞌ lupa sin siub badjuꞌ sin sultan. ");
INSERT INTO tsg_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ubus ampa nila liyubid in manga sanga kahuy matunuk hīnang biyaꞌ kuruna, ampa nila siyangun pa ū hi Īsa. Pagꞌubus ampa nila piyakamputan kan Īsa in kahuy-kahuy ha tuu niya. Ubus, ampa nila piyagꞌudjuꞌ-udjuꞌ hi Īsa. Limuhud sila ha alupan niya sartaꞌ imiyan, laung nila, “Mabuhay in Sultan sin manga Yahudi.” ");
INSERT INTO tsg_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ubus yadtu ampa nila liyuraan hi Īsa. Kiyawaꞌ nila in kahuy-kahuy dayn ha lima niya, ampa nila piyanglubak pa ū niya. ");
INSERT INTO tsg_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pagꞌubus nila piyaglangugan hi Īsa, inīgan nila na in siub badjuꞌ taluk ampa nila siyulugan hi Īsa nagbalik sin badjuꞌ niya. Ubus ampa nila diyā hi Īsa pa lugal paglansangan kaniya pa usuk. ");
INSERT INTO tsg_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Manjari ha sūng nila na gumuwaꞌ dayn ha lawang sin dāira, piyagbāk nila in hambuuk tau pagngānan Simun, tau dayn ha dāira Kirini. Liyugus nila in tau ini dumā sin usuk paglansangan kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Sakali nakaabut na sila mawn pa lugal pagtawagun Gulguta (in maana niya kulakub ū). ");
INSERT INTO tsg_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Duun mayan sila, dīhilan nila hi Īsa sin tubig anggul (biyaꞌ tubaꞌ), liyalamuran sin ubat mapait. Sagawaꞌ pagkinam niya diꞌ siya mabayaꞌ minum. ");
INSERT INTO tsg_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pagꞌubus hiyubuꞌ nila na in tamungun hi Īsa ampa nila siya liyansang pa usuk. Kiyalansang mayan siya pa usuk piyagbahagian sin manga sundalu in tamungun hi Īsa. Piyagkuut-kuutan nila bang unu in masukuꞌ sin pakaniya-pakaniya. ");
INSERT INTO tsg_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pagꞌubus ampa sila limingkud duun nagjaga kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Duun ha usuk ha tungud babaw ū hi Īsa biyutang nila in pahāti ini, amu agi, “Amu na ini hi Īsa, in Sultan sin manga Yahudi.” Amu yan in tuntut kaniya. ");
INSERT INTO tsg_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Iban ha adlaw da isab yadtu awn duwa mundu liyansang pa usuk diyungan kan Īsa. In hambuuk iyusuk ha dapit pa tuu hi Īsa, ampa in hambuuk ha dapit pa lawa. ");
INSERT INTO tsg_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na, in manga tau maglalabay, pagkitaꞌ nila kan Īsa magꞌilung-ilung sadja sin ū nila nangudjuꞌ-ngudjuꞌ kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Laung nila, “In baytaꞌ mu malubu mu in Bāy sin Tuhan ubus mapatindug mu magbalik ha lawm tū adlaw. Na, tabanga na in baran mu! Bang kaw bunnal amu in Anak Tuhan, naug na kaw dayn ha taas sin usuk yan!” ");
INSERT INTO tsg_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Damikkiyan, piyaglagiꞌ-lagiꞌ da isab siya sin manga nakuraꞌ kaimaman, sin manga guru sin saraꞌ agama iban sin manga nagtatau-maas ha hulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Laung nila, “Natabang niya in tau dugaing dayn ha kamulahan, sagawaꞌ in baran niya diꞌ niya matabang! Bukun ka siya in Sultan sin bangsa Israil? Bang siya makaīg dayn ha usuk yaun bihaun, ampa kami magparachaya kaniya! ");
INSERT INTO tsg_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nangandul tuud siya ha Tuhan iban in baytaꞌ niya, siya na in Anak Tuhan. Na, kitaun ta kunuꞌ bihaun bang siya tabangun sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Lāgiꞌ, minsan in duwa mundu amu in diyūngan kan Īsa liyansang da isab pa usuk, nanglagiꞌ-lagiꞌ da kaniya. ");
INSERT INTO tsg_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Manjari pagꞌabut ugtu suga nanigidlum na in katilibut sin hulaꞌ sampay naabut lisag tū sin mahapun. ");
INSERT INTO tsg_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Na, pagꞌabut mayan manga lisag tū sin mahapun nagsuwara hi Īsa matanug, “Iluy, iluy, lama sabaktani.” In hāti niya, “Ya Tuhan ku, maytaꞌ mu aku piyasāran?” ");
INSERT INTO tsg_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Na, pagdungug sin manga kaibanan tau nagtitindug duun, nasāꞌ in pangdungug nila. Laung nila, “Tiyawag niya hi Ilyas!” ");
INSERT INTO tsg_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sakali magtūy awn hambuuk tau dimagan madtu kimawaꞌ luppus, ampa niya hiyaꞌgum pa tubig anggul (biyaꞌ tubaꞌ). Pagꞌubus ampa niya biyutang in luppus ha duhul sin kahuy-kahuy ampa niya diyuhal piyasupsup kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Sagawaꞌ imiyan in kaibanan, laung nila, “Tagad na kaw, kitaun taniyu bang siya tabangan hi Ilyas.” ");
INSERT INTO tsg_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Sakali nagsuwara matanug nagbalik hi Īsa. Pagꞌubus miyugtuꞌ na in napas niya. ");
INSERT INTO tsg_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na, pagbugtuꞌ na mayan sin napas niya, magtūy isab nagisiꞌ nagduwa dayn ha taas pa duhul in kurtina marakmul didtu ha lawm Bāy sin Tuhan. Sartaꞌ naglinug na iban nasipak in manga batu dakulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Naukab in manga kubul iban nabuhiꞌ nagbalik in manga patay amu in nagkahagad ha daakan sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Gimuwaꞌ sila dayn ha lawm kubul, iban nabuhiꞌ mayan nagbalik hi Īsa, miyadtu sila pa dāira Awrusalam (Baytal Makdis). Mataud tau in nakakitaꞌ duun kanila. ");
INSERT INTO tsg_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na, miyugaꞌ tuud in kapitan iban sin manga sundalu amu in nagjajaga duun kan Īsa, pagnanam nila sin linug iban pagkitaꞌ nila sin katān naawn. Laung nila, “Tantu tuud siya na ini in Anak Tuhan!” ");
INSERT INTO tsg_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Lāgiꞌ mataud da isab duun manga babai in nagkikitaꞌ dayn ha kalayuan. In manga babai ini amuna in bakas miyagad kan Īsa dayn ha hulaꞌ Jalil timabang kaniya. ");
INSERT INTO tsg_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Miyamagad ha manga kababaihan ini hinda Mariyam amu in babai dayn ha dāira Magdala iban hi Mariyam amu in inaꞌ hi Yaꞌkub kay Yusup iban sin asawa hi Sibidi. ");
INSERT INTO tsg_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Manjari himapun mayan tuud, awn hambuuk tau dayahan dayn ha kawman Arimati in nākawn. In ngān niya hi Yusup iban in siya ini agad da isab kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Miyadtu siya kan Pilatu nangayuꞌ sin bangkay hi Īsa. Na, diyūl hi Pilatu in piyangayuꞌ niya, hangkan nagꞌuldin hi Pilatu hipaparihil na in bangkay hi Īsa kan Yusup. ");
INSERT INTO tsg_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Na, kiyawaꞌ na hi Yusup in bangkay, ampa niya siyaput sin kuku putiꞌ baꞌgu. ");
INSERT INTO tsg_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Pagꞌubus ampa niya biyutang in bangkay ha kubul baꞌgu piyahinang, amu in batu dakulaꞌ liyungagan hīnang biyaꞌ lupa sungab batu. In kubul ini tiyatagama hi Yusup ha baran niya. Kiyasūd niya mayan in bangkay pa lawm, giyulung niya in batu dakulaꞌ piyagtambul sin sūran pa lawm kubul. Pagꞌubus ampa siya minīg. ");
INSERT INTO tsg_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","In hi Mariyam amu in babai dayn ha dāira Magdala iban sin isay niya hi Mariyam duun naglilingkud, imaalup sin kubul. ");
INSERT INTO tsg_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Manjari pagꞌadlaw hambuuk, adlaw Sabtuꞌ, in manga nakuraꞌ kaimaman iban sin manga Parisi miyadtu dimā nagkitaꞌ kan Pilatu. ");
INSERT INTO tsg_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Laung nila kan Pilatu, “Tuwan, kiyatumtuman namuꞌ ha waktu buhiꞌ pa in putingan yadtu, namung siya laung niya, bang siya matay, pagꞌabut tū adlaw mabuhiꞌ siya magbalik. ");
INSERT INTO tsg_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Hangkan, Tuwan, subay mu pajagahan in kubul niya sampay mapuas in tū adlaw, ha supaya diꞌ matakaw sin manga mulid niya in bangkay niya. Bang nila matakaw in bangkay, baytaan nila sin puting in manga tau sin in nakuraꞌ nila nabuhiꞌ nagbalik. Na, in puting nila yan labi pa in ngīꞌ sin kasūngan dayn sin puting niya (sin in siya amuna in Almasi).” ");
INSERT INTO tsg_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“Na, kawaꞌ kamu sundalu ampa niyu pajagahi tuud marayaw in kubul niya,” in sambag hi Pilatu kanila. ");
INSERT INTO tsg_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Na, miyadtu na sila pa kubul ampa nila biyutangan pangindanan in lawang kubul, (ha supaya kaingatan nila bang in lawang kubul bakas naukab). Ubus ampa nila piyajagahan in kubul ha manga sundalu. ");
INSERT INTO tsg_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Manjari napuas mayan in adlaw paghali-hali iban pagpudji pa Tuhan sin manga Yahudi, amu in adlaw Sabtuꞌ, iban naabut na subu-subu sin adlaw Ahad, in hi Mariyam, amu in babai dayn ha dāira Magdala, iban sin isay niya isab hi Mariyam, miyadtu kimitaꞌ sin kubul hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Na, magtūy naglinug makusug sabab awn hambuuk malāikat naraak sin Tuhan nimaug dayn ha surgaꞌ. Giyulung niya inīgan in batu tambul sin sūran pa lawm kubul ampa niya līngkuran. ");
INSERT INTO tsg_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","In lupa sin malāikat ini, magsiꞌnag biyaꞌ sin kilat iban in tamungun niya landuꞌ tuud maputiꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Na, pagkitaꞌ sin manga jaga namidpid tuud sila sin bugaꞌ iban nalawaꞌ sila ha sayu. ");
INSERT INTO tsg_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Namung in malāikat ha manga babai, laung niya, “Ayaw kamu mabugaꞌ. Kaingatan ku miyari kamu naglawag kan Īsa, amu in bakas liyansang pa usuk. ");
INSERT INTO tsg_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Way na siya dī ha lawm kubul sabab nabuhiꞌ na siya nagbalik biyaꞌ sin asal kiyabaytaꞌ niya. Kari kamu, kitaa niyu in lugal bakas kiyabutangan kaniya. ");
INSERT INTO tsg_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Na, bihaun kadtu kamu samut, baytai niyu in manga mulid niya sin nabuhiꞌ na siya nagbalik iban muna na siya dayn kanila madtu pa hulaꞌ Jalil. Kakitaan nila siya didtu. Tumtuma niyu in baytaꞌ ku kaniyu.” ");
INSERT INTO tsg_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Na, nagꞌūs-ꞌūs na in manga babai minīg dayn ha kubul. Miyumugaꞌ sila sagawaꞌ hipuꞌ da isab sin kakuyagan in lawm atay nila. Dimagan na sila madtu namaytaꞌ ha manga mulid hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Sakali ini magtūy sila piyagbāk hi Īsa. Laung hi Īsa kanila, “Na, kamu na sa yan!” Simuuk sila mawn kan Īsa ampa sila simujud duun ha tungud siki niya. ");
INSERT INTO tsg_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","“Ayaw kamu mabugaꞌ,” laung hi Īsa kanila. “Kadtu kamu, baytai niyu in manga mulid ku subay sila madtu pa hulaꞌ Jalil. Didtu nila aku kakitaan.” ");
INSERT INTO tsg_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Na, ha saꞌbu sin manga babai harap madtu pa manga mulid hi Īsa, in manga kaibanan sundalu jaga sin kubul miyadtu pa dāira namaytaꞌ ha manga nakuraꞌ sin kaimaman sin katān kītaꞌ nila naawn. ");
INSERT INTO tsg_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Na, nagtipun na in manga nakuraꞌ sin kaimaman iban sin manga nagtatau-maas ha hulaꞌ, ampa sila nagꞌisun. Ubus nila nagꞌisun ampa nila dīhilan sīn mataud in manga sundalu bakas nagjaga sin kubul. ");
INSERT INTO tsg_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Laung nila ha manga sundalu, “Suysuyi niyu in manga tau sin in bangkay hi Īsa tiyakaw sin manga mulid niya sin tungaꞌ dūm ha saꞌbu niyu natutūg. ");
INSERT INTO tsg_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Bang in suysuy yan makaabut pa gubnul ayaw kamu masusa. Kami na in maingat mamichara kaniya bat kamu diꞌ kapagꞌamahan.” ");
INSERT INTO tsg_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Na, kiyawaꞌ na sin manga sundalu in sīn iban iyagad nila in baytaꞌ kanila. Na, sampay pa waktu bihaun amu yan in suysuy kiyahagad sin manga Yahudi. ");
INSERT INTO tsg_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Na, in hangpuꞌ tagꞌisa mulid hi Īsa timukad na madtu pa taas būd-būd sin hulaꞌ Jalil sabab piyabaytaan sila hi Īsa pakadtuun. ");
INSERT INTO tsg_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pagkitaꞌ nila duun kan Īsa magtūy sila simujud nanglagguꞌ kaniya, sagawaꞌ in kaibanan hawal-hawal bang hi Īsa da tuud in kītaꞌ nila yaun. ");
INSERT INTO tsg_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Simuuk hi Īsa kanila ampa namung, laung niya, “Kiyatukbal na pa lawm lima ku in katāntan kawasa dī ha dunya iban ha surgaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Hangkan kadtu kamu, baytai niyu in mānusiyaꞌ katān sin pasal ku, ha supaya isab sila magad kākuꞌ. Ligua niyu sila amu in tandaꞌ magpakitaꞌ sin in sila agad na tuud ha Amaꞌ Tuhan, kākuꞌ amu in Anak Tuhan iban ha Rū sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Iban hindui niyu in manga tau kumahagad sin katān daakan ku kaniyu. Na, ini in tumtuma niyu. Aku in taptap iban niyu, mananabang kaniyu, hawnu-hawnu iban kuꞌnu-kuꞌnu waktu sampay pa kahinapusan sin masa sin dunya.”");
INSERT INTO tsg_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ini in panagnaan sin Baytaꞌ Marayaw pasal hi Īsa Almasi, amu in Anak Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Asal kiyasulat hi Nabi Isayas ha lawm Kitab in Parman sin Tuhan (pasal sin paglahil sin Almasi pa dunya, amu agi sin Tuhan ha Almasi). “Paunahun ku lumahil dayn kaymu, in hambuuk daraakun ku. Sakapun niya in dān labayan mu. ");
INSERT INTO tsg_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Siya in manawag-tawag duun ha hulaꞌ paslangan mahunit paghulaan. Amu agi niya, ‘Masuuk na dumatung in Panghuꞌ. Sakapa niyu in dān labayan niya. Pabuntula niyu in dān panawan niya.’” ");
INSERT INTO tsg_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Manjari timagnaꞌ na hi Yahiya nagpamahalayak pasal sin Almasi ha hulaꞌ paslangan mahunit paghulaan. Līguꞌ niya in manga tau amu in nagtawbat na sin manga dusa nila. Laung niya ha manga tau, “Pagtawbati niyu na in manga dusa niyu ampa kamu pagpaliguꞌ, tandaꞌ sin tiyaykuran niyu in dusa niyu iban iyampun na kamu sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Na, in manga tau mataud dayn ha katilingkal Yahudiya iban dayn ha dāira Awrusalam (Baytal Makdis) miyawn dimungug kan Yahiya. Nagsabunnal na sila sin manga dusa nila iban līguꞌ na sila hi Yahiya duun ha Subaꞌ Jurdan. ");
INSERT INTO tsg_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Na, in tamungun hi Yahiya hīnang dayn ha bulbul untaꞌ iban in sabitan niya pais sapiꞌ. In pagkaunun niya hambuuk ginis sin ampan iban gulaꞌ pussukan. ");
INSERT INTO tsg_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nagpamahalayak siya ha manga tau, laung niya, “In tau ha ulihan ku amu in magdaratung mari kaniyu, labi tuud mataas in kawasa dayn kākuꞌ. Hangkan diꞌ aku minsan tūpun umanduk humubad sin hukut sin tawmpaꞌ niya sabab labi in kalagguan niya dayn kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","In aku tubig in kaniyu, sagawaꞌ in siya patulunan niya kamu sin Rū sin Tuhan, amu in pangliguꞌan niya kaniyu.” ");
INSERT INTO tsg_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sakali pagꞌubus yadtu miyawn hi Īsa kan Yahiya dayn ha Nasarit, hambuuk dāira ha hulaꞌ Jalil, ampa siya līguꞌ hi Yahiya duun ha Subaꞌ Jurdan. ");
INSERT INTO tsg_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Na, pagꞌīg niya na mayan dayn ha tubig magtūy niya kītaꞌ naukab in lawang langit iban nimaug in Rū sin Tuhan mawn kaniya nagpasalupa assang. Ubus ampa siya hiyūp sin Rū sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sartaꞌ awn na suwara dayn ha langit, amu agi, “Ikaw in Anak ku kalasahan. Kiyasulutan tuud aku kaymu.” ");
INSERT INTO tsg_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Sakali magtūy hi Īsa piyakadtu sin Rū sin Tuhan pa hulaꞌ paslangan mahunit paghulaan. ");
INSERT INTO tsg_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Duun siya kaꞌpatan adlaw siyasat sin Saytan Puntukan, (saꞌ way siya narā sin sasat). Awn da isab manga sattuwa talun duun, sagawaꞌ miyawn in manga malāikat timabang kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Na, pagꞌubus najīl mayan hi Yahiya, miyadtu na hi Īsa pa hulaꞌ Jalil nagpamahalayak sin Baytaꞌ Marayaw naug dayn ha Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Laung hi Īsa, “Naabut na in waktu giyantaꞌ sin Tuhan, amu in waktu dumatung na mari in pamarinta niya. Pagtawbati niyu na in manga dusa niyu iban pagparachaya kamu ha Baytaꞌ Marayaw!” ");
INSERT INTO tsg_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Manjari, ha saꞌbu hi Īsa miyamanaw ha higad sin dagat pagngānan Dagat Jalil, kītaꞌ niya nanglalaya in duwa magꞌiistaꞌ, hi Simun iban sin taymanghud niya hi Andariyas. ");
INSERT INTO tsg_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Laung hi Īsa kanila, “Kari kamu agad kākuꞌ! Bihaun in hinang niyu magꞌiistaꞌ, sagawaꞌ hinduan ta kamu bang biyaꞌ diin maghulas-sangsaꞌ dumā ha manga mānusiyaꞌ pagkahi niyu magad kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Na, saruun-duun biyutawanan nila in laya nila, ampa sila miyagad kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Sakali nakalayuꞌ-layuꞌ mayan in panaw nila, kītaꞌ niya isab in duwa magtaymanghud, hi Yaꞌkub kay Yahiya manga anak hi Sibidi. Duun sila ha taas sin kumpit asibiꞌ nagdarayaw sin laya nila. ");
INSERT INTO tsg_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pagkitaꞌ hi Īsa kanila, magtūy niya sila tiyawag paagarun kaniya. Na, binīn nila in amaꞌ nila duun ha kumpit asibiꞌ iban sin manga tau giyagadjihan ampa sila miyagad kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Miyadtu hinda Īsa pa dāira Kapirnaum, iban pagꞌabut adlaw Sabtuꞌ, amu in adlaw paghali-hali iban pagpudji pa Tuhan sin manga bangsa Yahudi, miyadtu hi Īsa pa langgal ampa nagnasīhat. ");
INSERT INTO tsg_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Manjari, nainu-inu tuud in manga tau ha langgal sin pagnasīhat niya sabab in pagnasīhat niya magbiddaꞌ tuud iban pagnasīhat sin manga guru sin saraꞌ agama. Karnaꞌ in pagnasīhat niya taga kawasa tuud dayn ha Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Sakali magtūy awn dimatung hambuuk tau mawn pa langgal siyusūd saytan. Imulak in tau ini, laung niya, ");
INSERT INTO tsg_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Unu in kabayaan mu kāmuꞌ, Īsa, tau Nasarit? Miyari ka kaw dumihil kamulahan kāmuꞌ? Kaingatan ta kaw. Ikaw in hambuuk-buuk suchi naraak sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Sagawaꞌ piyagꞌamahan hi Īsa in saytan. Laung niya, “Hipus kaw ampa kaw guwaꞌ dayn ha lawm baran sin tau yan.” ");
INSERT INTO tsg_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Na, piyapagpaspad sin saytan in tau iban piyapagsilawak makusug. Pagꞌubus ampa gimuwaꞌ in saytan dayn ha lawm baran sin tau. ");
INSERT INTO tsg_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nahaylan tuud in tau katān nakakitaꞌ. Nagꞌasubu-iyasubuhi na sila, laung nila, “Unu taꞌ ini? Hinduꞌ baꞌgu bahaꞌ ini? In tau ini tagakawasa magbayaꞌ ha manga saytan iban magkahagad in manga saytan kaniya.” ");
INSERT INTO tsg_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Na, saruun-duun natanyag in kabantugan hi Īsa pa katān hulaꞌ ha katilibut sin hulaꞌ Jalil. ");
INSERT INTO tsg_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pagꞌubus yadtu gimuwaꞌ na hinda Īsa dayn ha langgal ampa sila timūy madtu pa bāy hi Simun kay Andariyas. Miyagad kanila hi Yaꞌkub kay Yahiya. ");
INSERT INTO tsg_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Manjari, in ugangan babai hi Simun nagkukulang hīhinglaw. Pagdatung na mayan hi Īsa magtūy nila siya biyaytaan sin pasal sin babai hīhinglaw. ");
INSERT INTO tsg_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Na, miyadtu hi Īsa pa babai. Kiyaputan niya in lima ampa niya biyangun, sartaꞌ naīg na in hinglaw sin babai. Pagꞌīg sin hinglaw niya, nagbangun na siya nagbutang kakaun kanila. ");
INSERT INTO tsg_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Na simadlup mayan in suga, lāgiꞌ naabut na magrib, miyawn na in manga tau kan Īsa nagdarā sin manga tau katān nasasakit iban sin manga siyusūd saytan. ");
INSERT INTO tsg_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","In manga tau katān dayn ha dāira Kapirnaum duun nagtipun ha alupan sin bāy kiyabutangan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Na, mataud tau nasasakit sin ginisan sakit in napauliꞌ hi Īsa. Iban napaguwaꞌ niya isab in manga saytan dayn ha baran sin manga tau siyusūd saytan. Sagawaꞌ walaꞌ niya diyūlan in manga saytan mamichara unu-unu na, sabab kiyaingatan sin manga saytan bang hisiyu hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pagꞌadlaw hambuuk, subu-subu pa tuud, nagbangun na hi Īsa ampa siya gimuwaꞌ dayn ha bāy. Miyadtu siya pa lugal way bahittuk ha guwaꞌ sin dāira. Didtu siya nangarap pa Tuhan isa-isa niya. ");
INSERT INTO tsg_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Sakali liyawag siya hinda Simun. ");
INSERT INTO tsg_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kiyabaakan nila mayan siya, laung nila, “In manga tau katān naglawag kaymu.” ");
INSERT INTO tsg_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Sagawaꞌ in sambung hi Īsa, “Subay kitaniyu madtu pa kaibanan kawman ha supaya isab aku makapagnasīhat didtu, karnaꞌ amu yan in maksud ku miyari pa dunya.” ");
INSERT INTO tsg_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Na, miyadtu na hi Īsa nagnasīhat ha kalanggalan ha katilibut sin hulaꞌ Jalil. Napaguwaꞌ niya da isab in manga saytan dayn ha manga tau siyusūd saytan. ");
INSERT INTO tsg_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Manjari awn tau īipul miyawn kan Īsa limuhud ha alupan niya iban nangayuꞌ tabang kaniya. Laung niya kan Īsa, “Mapauliꞌ mu aku bang mu kabayaan kaulian aku.” ");
INSERT INTO tsg_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Na imulung tuud hi Īsa kaniya. Biyutang hi Īsa in lima niya pa tau īipul, ampa siya imiyan, laung niya, “Kabayaan ku kaulian na in sakit mu. Lumanuꞌ na in pais mu!” ");
INSERT INTO tsg_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Na, saruun-duun naīg in ipul niya iban limanuꞌ na in pais niya. ");
INSERT INTO tsg_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Sakali biyandaan siya hi Īsa, laung niya, “Ibut-ibut kaymu, ayaw kaw magbaytaꞌ minsan kansiyu pasal sin pagpauliꞌ ku kaymu. Sagawaꞌ kadtu kaw magtūy pa imam, ampa mu palilingan in baran mu kaniya. Pagꞌubus, ampa kaw kadtu ungsud sin pagkulbanan, amu in daakan hi Musa, ha supaya awn tandaꞌ kakitaan sin manga tau katān sin kiyaulian na kaw.” Pagꞌubus, piyakadtu na hi Īsa in tau. ");
INSERT INTO tsg_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Sagawaꞌ pagꞌīg sin tau bakas īipul, miyadtu siya nanuysuy pawyu-pawyu sin pasalan sin pagpauliꞌ kaniya, iban mataud tuud in suysuy niya pasal hi Īsa. Hangkan kiyahunitan hi Īsa sumūd pa manga lugal mataud tau. Saꞌ siya miyadtu pa manga hulaꞌ wayruun tau naghuhulaꞌ, sagawaꞌ miyadtu da kaniya in manga tau dayn ha kahulaꞌ-hulaan. ");
INSERT INTO tsg_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Manjari, pilay adlaw mayan limabay, nagbalik hi Īsa pa Kapirnaum. Pagbalik niya, nabukag na ha manga tau sin nakauwiꞌ na siya pa bāy. ");
INSERT INTO tsg_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Na, mataud tuud tau in nagtipun mawn pa bāy kiyaruunan niya. Nahipuꞌ tuud sin tau in bāy, sampay in lawang diꞌ kasūran. Duun hi Īsa nagnanasīhat kanila sin Parman sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Sakali awn upat tau miyawn nagdarā sin tau nagpapatay in baran. ");
INSERT INTO tsg_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pagga sila diꞌ makasūd pa lawm bāy, makasuuk madtu kan Īsa, sabab sin taud sin tau, inīgan nila in atup sin bāy amu in ha tungud hi Īsa. Pagꞌubus yadtu ampa nila tiyuntun pa lawm bāy in tau nasasakit nagbubutang ha kulangan niya. ");
INSERT INTO tsg_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Na, pagkitaꞌ hi Īsa sin makusug in pangandul sin manga tau ini namung hi Īsa ha tau nagpapatay in baran, laung niya, “Utuꞌ, iyampun na in manga dusa mu.” ");
INSERT INTO tsg_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Sakali, awn duun naglilingkud manga guru sin saraꞌ agama Yahudi. Naghunaꞌ-hunaꞌ na sila bang maytaꞌ hi Īsa namung bihādtu. Laung nila ha lawm atay nila, “Maytaꞌ in tau ini tawakkal mamung pangkal pa Tuhan? Hambuuk-buuk da Tuhan in makaampun sin dusa sin mānusiyaꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Na, magtūy kiyatalusan hi Īsa bang unu in piyaghunaꞌ-hunaꞌ nila. Hangkan laung niya kanila, “Maytaꞌ kamu maghunaꞌ-hunaꞌ sin biyaꞌ ha yan? ");
INSERT INTO tsg_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Na, ha pikil niyu unu in maluhay hipamung ha tau ini bang aku umiyan, ‘Iyampun na in manga dusa mu!’ Atawa umiyan ha tau nasasakit, ‘Bangun kaw, mumusa in kulangan mu, ampa kaw panaw?’ ");
INSERT INTO tsg_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Na, dihilan ta kamu tandaꞌ sin in aku amu in Anak Mānusiyaꞌ awn kapatutan ku umampun sin dusa sin manga mānusiyaꞌ!” Sakali laung hi Īsa ha tau nagpapatay in baran, ");
INSERT INTO tsg_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Utuꞌ, bangun na kaw, mumusa in kulangan mu, ampa kaw uwiꞌ na!” ");
INSERT INTO tsg_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na, nagbangun na in tau yadtu. Miyumus niya in kulangan niya ampa siya miyanaw minuwiꞌ ha kīkitaꞌ sin tau katān. Nahaylan tuud in manga tau katān iban piyudji nila in Tuhan. “Uy,” laung nila, “dayn tagnaꞌ walaꞌ kitaniyu nakakitaꞌ sin biyaꞌ ha yan!” ");
INSERT INTO tsg_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Manjari, nagbalik hi Īsa madtu pa higad sin Dagat Jalil. Sakali nagtipun mawn kaniya in tau katān. Na, nagnasīhat na isab hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Sakali ha saꞌbu niya nagpapanaw, kītaꞌ niya in mangangawaꞌ sukay pa parinta duun naglilingkud ha pustu pagkakawaan sukay. In ngān sin tau ini hi Libi, anak hi Alpa. Laung hi Īsa kaniya, “Kari kaw agad kākuꞌ magguru.” Na, magtūy timindug hi Libi, ampa miyagad kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Manjari, ha saꞌbu hi Īsa duun nagkakaun ha bāy hi Libi, mataud in mangangawaꞌ sukay pa parinta, iban manga baldusa kaibanan in miyawn limamud simāw nagkaun kan Īsa iban sin manga mulid niya, sabab mataud sila in miyagad kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Na, awn manga guru sin saraꞌ agama, amu in agad ha parhimpunan Parisi, in nākitaꞌ kan Īsa naglalamud nagkaun iban sin manga baldusa iban sin manga mangangawaꞌ sukay pa parinta. Na, iyasubu nila in manga mulid hi Īsa, laung nila, “Maytaꞌ in nakuraꞌ niyu yan magsāw magkaun iban sin manga mangangawaꞌ sukay pa parinta iban sin manga tau baldusa?” ");
INSERT INTO tsg_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Pagdungug hi Īsa sin bichara nila, simambung siya. Diyalil niya kaagi in sambung niya, laung niya, “In manga tau way sakit diꞌ magkagunahan mangungubat, amu da in magkagunahan mangungubat in manga tau nasasakit. In maksud ku miyari pa dunya, bukun paagarun kākuꞌ in manga tau, amu in imiyan, in sila mabuntul, saꞌ miyari aku supaya magad kākuꞌ in manga tau baldusa (amu in biyaꞌ sapantun tau taga sakit).” ");
INSERT INTO tsg_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Manjari, awn hambuuk waktu in manga mulid hi Yahiya amu in Mangliliguꞌ iban sin manga Parisi nagpuasa. Sakali awn manga tau miyawn nangasubu kan Īsa, laung nila, “Maytaꞌ in manga mulid hi Yahiya amu in Mangliliguꞌ iban sin manga mulid sin manga Parisi magpuasa, sagawaꞌ in manga mulid mu diꞌ magpuasa?” ");
INSERT INTO tsg_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Diyalil kaagi hi Īsa in sambung niya kanila, laung niya, “Maytaꞌ, magpuasa ka in manga luruk ha pagtiyaunan salugay yaun pa duun kanila in pangantin usug? Tantu diꞌ! Ha salugay sin pangantin usug duun kanila, diꞌ sila magpuasa. ");
INSERT INTO tsg_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Sagawaꞌ dumatung da in waktu in pangantin usug kawaun na dayn kanila. Na, bang dumatung na in waktu yan in sila magpuasa na.” ");
INSERT INTO tsg_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","(Pagꞌubus nagdalil hi Īsa pasal sin panghinduꞌ nakauna iban sin panghinduꞌ niya.) Laung niya, “Wayruun tau in magtupak sin pīs-pīs baꞌgu pa tamungun daan, sabab bang biyaꞌ hādtu in pagtupak niya, pagkungkung sin pīs-pīs baꞌgu, magisiꞌ da dayn ha tamungun iban lumagguꞌ pa in gisiꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Damikkiyan, wayruun tau in lumuun sin tubig anggul (biyaꞌ tubaꞌ) amu in masi pa nagbubukal pa luluunan pais hayup amu in daan iban matugas na, sabab bang biyaꞌ hādtu in hinangun niya, in luluunan pais hayup amu in matugas na, tantu mabustak. Na, kawgun sadja in tubig anggul iban sin luluunan pais hayup. Saꞌ in tubig anggul amu in baꞌgu subay hiluun ha luluunan pais hayup baꞌgu.” ");
INSERT INTO tsg_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Manjari, hambuuk adlaw, adlaw Sabtuꞌ, amu in adlaw paghali-hali iban pagpudji pa Tuhan sin manga Yahudi, limabay hi Īsa iban sin manga mulid niya dayn ha lawm uma. Sakali nangutul bunga sin tiyanum (biyaꞌ lupa pāy) in manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Na, laung sin manga Parisi kan Īsa, “Uy, langgal saraꞌ sin agama in hīnang sin manga mulid mu sabab adlaw paghali-hali iban pagpudji pa Tuhan adlaw ini!” ");
INSERT INTO tsg_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Na, laung hi Īsa kanila, “Maytaꞌ, walaꞌ niyu ka nabacha ha lawm Kitab in hīnang hi Daud ha waktu in siya iban sin manga iban niya way na kakaun nila iban hiyapdiꞌ na tuud sila? ");
INSERT INTO tsg_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Simūd hi Daud pa lawm Bāy sin Tuhan, ampa siya kimaun sin kakaun bakas iyungsud pa Tuhan. Dihilan niya isab in manga iban niya. Sin masa yadtu hi Abiyatar in imam dakulaꞌ ha Bāy sin Tuhan. In hīnang nila langgal saraꞌ sin agama, sabab amura manga imam in makajari kumaun sin kakaun bakas iyungsud pa Tuhan. Sagawaꞌ minsan bihādtu in hīnang hi Daud, walaꞌ da siya nagdusa.” ");
INSERT INTO tsg_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Mahuli dayn duun, laung hi Īsa, “Piyaawn in adlaw paghali-hali iban pagpudji pa Tuhan ha hikarayaw sin mānusiyaꞌ, saꞌ in mānusiyaꞌ piyapanjari bukun ha supaya kabuꞌgatan sin pagꞌagad sin manga palihālan pasal sin adlaw paghali-hali pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Na, in amu in Anak Mānusiyaꞌ amu in makapagbayaꞌ umiyan bang unu in mapatut hinangun ha adlaw paghali-hali iban pagpudji pa Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Na, naabut na isab hambuuk waktu in hi Īsa simūd pa lawm langgal. Sakali awn hambuuk tau duun nakukumay in lima niya. ");
INSERT INTO tsg_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Yaun da isab in manga kaibanan tau marugal kan Īsa. Mabayaꞌ nila lawagan hi Īsa dusa ha supaya nila siya katuntutan. Hangkan, jiyagahan nila tuud marayaw hi Īsa bat nila kakitaan bang pauliun hi Īsa in tau nakukumay in lima minsan adlaw paghali-hali iban pagpudji pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Na, laung hi Īsa ha tau nakukumay in lima, “Kari kaw mari pa unahan.” ");
INSERT INTO tsg_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pagꞌubus ampa niya iyasubu in manga tau, laung niya, “Bang ha aturan sin saraꞌ agama natuꞌ unu in patut natuꞌ hinangun ha adlaw paghali-hali iban pagpudji pa Tuhan? Huminang sin marayaw atawa makamula? Tumabang sin kabuhiꞌ sin tau atawa mamatay?” Na, walaꞌ tuud simambung minsan hangka-kabtang in manga tau. ");
INSERT INTO tsg_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iyatud hi Īsa in manga tau iban diyugalan siya kanila, sagawaꞌ nasusa da isab in lawm atay niya pasal nila sabab matugas in ū nila iban saꞌ in pamikil nila. Pagꞌubus, laung hi Īsa ha tau nakukumay in lima, “Hunata in lima mu.” Na hiyunat na sin tau in lima niya. Na, saruun-duun dimayaw nagbalik in lima niya. ");
INSERT INTO tsg_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Na, gimuwaꞌ in manga Parisi dayn ha lawm langgal, ampa sila magtūy nagꞌisun iban sin manga tindug hi Sultan Hirud bang biyaꞌ diin in hikapatay nila kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sakali minīg na hi Īsa iban sin manga mulid niya, ampa sila miyadtu pa Dagat Jalil. Mataud tuud tau in imurul kan Īsa. In manga tau ini dayn ha Jalil, Yahudiya, ");
INSERT INTO tsg_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Awrusalam (Baytal Makdis), Idumiya, dayn ha hulaꞌ ha dapit pa subangan sin Subaꞌ Jurdan, iban dayn ha manga dāira sin Tirus iban Sidun. In manga tau mataud ini miyawn kan Īsa sabab kiyasuysuyan sila pasal sin nahinang hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Landuꞌ tuud mataud in manga tau. Hangkan nagpasakap hi Īsa kumpit ha manga mulid niya ha supaya siya diꞌ karaꞌganan sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mataud tau nasasakit in napauliꞌ niya, hangkan in katān tagasakit nagtuyuꞌ tuud similut bat makakaput kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na, bang siya kakitaan sin manga tau siyusūd saytan, magtūy magpatiligad sila ha alupan niya ampa similawak, laung nila, “Ikaw in Anak Tuhan!” ");
INSERT INTO tsg_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Sagawaꞌ ībut-ibutan tuud hi Īsa in manga saytan diꞌ papagbaytaun bang hisiyu siya. ");
INSERT INTO tsg_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Na, pagꞌubus yadtu timukad hi Īsa pa taas būd-būd ampa niya tiyawag in manga tau amu in kabayaan niya paagarun kaniya. Miyawn in manga tau kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Pagꞌubus ampa niya pinīꞌ in hangpuꞌ tagduwa tau hīnang manga wakil niya. Laung niya kanila, “Kamu in napīꞌ ku tutug magad kākuꞌ. Kamu da isab in daakun ku magnasīhat sin Baytaꞌ Marayaw dayn ha Tuhan, ");
INSERT INTO tsg_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","iban dihilan ta kamu kawasa magpaguwaꞌ sin saytan dayn ha manga tau siyusūd saytan.” ");
INSERT INTO tsg_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","In manga hangpuꞌ tagduwa mulid napīꞌ niya, amuna hinda Simun (ngiyānan siya hi Īsa, Pitrus), ");
INSERT INTO tsg_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","hi Yaꞌkub iban sin taymanghud niya hi Yahiya, amu in manga anak hi Sibidi. (Ngiyānan sila hi Īsa, Buwanirgis, in hāti niya makusug biyaꞌ dawgdug), ");
INSERT INTO tsg_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","hi Andariyas, hi Pilip, hi Bartulumi, hi Matiyu, hi Tumas, hi Yaꞌkub, amu in anak hi Alpa, hi Tadiyus, hi Simun, amu in bantug simulang ha pamarinta sin hulaꞌ Rūm, ");
INSERT INTO tsg_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","iban hi Judas tau dayn ha Kiriyud amu in manipu kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pagꞌubus minuwiꞌ na hi Īsa iban sin manga mulid niya pa hulaan nila. Sakali nagtipun na isab mawn kan Īsa in manga tau mataud. Diꞌ na siya makaluhaya minsan kumaun iban sin manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Na, pagdungug sin manga mawmaas iban taymanghud hi Īsa sin kahālan niya, miyadtu sila kumawaꞌ kaniya, sabab laung sin manga tau in hi Īsa narupang na. ");
INSERT INTO tsg_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Lāgiꞌ, awn isab manga guru sin saraꞌ agama, in nakalūd mawn dayn ha Awrusalam (Baytal Makdis). Laung nila, “Siyusūd hi Īsa sin Nakuraꞌ sin manga Saytan amu in pagngānan Bilsibul. Nakuraꞌ sin manga Saytan in nagdihil kaniya barakat magpaguwaꞌ sin manga saytan dayn ha manga tau siyusūd saytan.” ");
INSERT INTO tsg_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Na, hangkan tiyawag hi Īsa in manga tau piyakawn kaniya ampa niya diyalil in bichara niya, laung niya, “Unu in karnaꞌ sin Saytan Puntukan magpaguwaꞌ sin manga tindug niya dayn ha manga tau siyusūd saytan? Bang bihādtu biyaꞌ da baran niya in piyaguwaꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Biyaꞌ da isab hantang sin hambuuk hulaꞌ. Bang in manga tau ha hambuuk hulaꞌ nababahagiꞌ, nagdurugaing-dugaing agaran iban magbunuꞌ-biyunui, na in hulaꞌ yan diꞌ lumugay kumangīꞌ da. ");
INSERT INTO tsg_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Damikkiyan bang in maglahasiyaꞌ magsaggaꞌ-siyaggai, diꞌ lumugay kumangīꞌ da sila. ");
INSERT INTO tsg_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Na, hangkan bang sawpama in Saytan Puntukan magkuntara iban sin manga tindug niya, in kusug sin kawasa niya diꞌ tumatas. Kumangīꞌ siya iban duun na in katubtuban niya.” ");
INSERT INTO tsg_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Diyalil hi Īsa in Saytan Puntukan pa hambuuk tau makusug. Laung niya, “Way tau makasūd manglangpas pa lawm bāy sin hambuuk tau makusug bang siya diꞌ kahukutan naa muna. ");
INSERT INTO tsg_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ini in bunnal hibaytaꞌ ku kaniyu. In katān dusa iban pamung mangīꞌ pa Tuhan sin manga tau, ampunun da sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Sagawaꞌ hisiyu-siyu in mamung mangīꞌ ha Rū sin Tuhan, diꞌ siya ampunun sin Tuhan sabab in dusa yan tanggungun niya sampay kasaumulan.” ");
INSERT INTO tsg_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Hangkan namung hi Īsa sin biyaꞌ ha yan sabab awn manga kaibanan tau namung sin siyusūd saytan hi Īsa). ");
INSERT INTO tsg_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Sakali nākawn na in inaꞌ hi Īsa iban sin manga taymanghud niya usug. Duun sila timindug ha guwaꞌ sin bāy ampa sila nagparā lapal sin mabayaꞌ sila dumā magkitaꞌ kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na, mataud tuud tau in naglilingkud duun ha katilibut hi Īsa. Laung nila kan Īsa, “Tuwan, in inaꞌ mu iban manga taymanghud mu yaun ha guwaꞌ, naglawag kaymu.” ");
INSERT INTO tsg_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","In sambung hi Īsa, “Bukun sadja sila yan in manga taymanghud iban inaꞌ ku!” ");
INSERT INTO tsg_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Imatud siya pa manga tau naglilingkud ha katilibut niya ampa siya namung, laung niya, “Minsan in sila ini manga taymanghud iban inaꞌ ku da. ");
INSERT INTO tsg_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sabab hisiyu-siyu in magkahagad huminang sin kabayaan sin Tuhan in siya yan taymanghud ku usug-babai iban inaꞌ ku.” ");
INSERT INTO tsg_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Manjari, nagnasīhat na isab nagbalik hi Īsa didtu ha higad Dagat Jalil. Landuꞌ tuud mataud tau in miyawn nagtipun dumungug sin nasīhat niya. Hangkan simakat siya pa taas kumpit asibiꞌ, ampa siya limingkud nagnasīhat. Duun in kumpit asibiꞌ piyaantung masuuk pa hunasan ampa in manga tau duun timitindug ha higad daplakan dimurungug kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Na, mataud in niyasīhat niya. In pagnasīhat niya, laung niya, ");
INSERT INTO tsg_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Dungug kamu! Awn yaun hambuuk tau nagtanum binhiꞌ ha uma niya. ");
INSERT INTO tsg_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","In kaagi niya nagtanum, siyabud niya in manga binhiꞌ. In kaibanan binhiꞌ nahulug pa labayan. Na, pagkawn sin manga manuk-manuk nakaun in manga binhiꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","In kaibanan binhiꞌ nahulug pa lupaꞌ mabatu iban hangkatiyuꞌ da in lupaꞌ niya. Na hangkarayꞌ da timubuꞌ in manga binhiꞌ sabab mababaw da in lupaꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Sakali kiyapasuan mayan sin suga, nangluyluy in tiyanum sabab bukun malawm in gamut niya. ");
INSERT INTO tsg_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","In kaibanan binhiꞌ nahulug pa lupaꞌ tiyutubuan sin manga kasagbutan matunuk. Pagtubuꞌ sin manga binhiꞌ tiyaꞌlung sin manga sagbut matunuk, hangkan walaꞌ na namunga. ");
INSERT INTO tsg_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ampa in kaibanan binhiꞌ nahulug pa lupaꞌ marayaw. Hangkan jimatu in tubuꞌ nila iban nagbunga marayaw. In bunga sin kaibanan sarang-sarang in taud, in kaibanan mataud, ampa in kaibanan landuꞌ tuud mataud.” ");
INSERT INTO tsg_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Mahuli dayn duun, laung hi Īsa, “Na, sasukuꞌ sin kamu nakarungug, dunguga niyu tuud in biyaytaꞌ ku yan kaniyu!” ");
INSERT INTO tsg_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pagꞌubus yadtu, nakaīg mayan in manga tau mataud, miyawn kaniya in hangpuꞌ tagduwa mulid niya iban sin kaibanan tau nakarungug sin nasīhat niya. Nangasubu sila bang unu in hāti sin isturi diyalil niya. ");
INSERT INTO tsg_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Laung hi Īsa. “In kamu yan kiyarihilan na ingat iban panghāti pasal sin kahālan sin pamarinta sin Tuhan amu in bakas līlibun dayn ha pikilan sin mānusiyaꞌ. Sagawaꞌ in kaibanan tau dugaing sila dayn kaniyu. In katān hinasīhat ku kanila dalilun ku kaagi pa manga isturi malawm in maana niya. ");
INSERT INTO tsg_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Hangkan biyaꞌ ha yan in pagnasīhat ku sabab biyaꞌ na sin kiyasulat ha lawm Kitab, nagparman in Tuhan, amu agi, ‘Minsan sila imaatud diꞌ sila makakitaꞌ, minsan sila dimurungug diꞌ sila makahāti, sabab bang sila makahāti pindahun nila na in atay nila pa Tuhan ampa maampun in manga dusa nila.’” ");
INSERT INTO tsg_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Pagꞌubus laung hi Īsa kanila, “Maytaꞌ, walaꞌ niyu pa kiyahātihan in maana sin dalilan pasal sin tau nagtanum? Tantu bang niyu yan diꞌ kahātihan, na diꞌ niyu da isab kahātihan in kaibanan hinasīhat ku amu in dalilun ka kaagi. ");
INSERT INTO tsg_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Ha isturi diyalil ku, in tau nagtanum amuna in biyaꞌ sapantun tau magpamahalayak sin Parman sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","In tau kaibanan nakarungug sin Baytaꞌ Marayaw pasal sin pamarinta sin Tuhan amuna in biyaꞌ sapantun sin manga binhiꞌ iban sin dān labayan kiyahulugan nila. Pagdungug nila na mayan sin Baytaꞌ Marayaw, magtūy mawn in Saytan Puntukan umagaw dayn kanila sin hinduꞌ sin Baytaꞌ Marayaw. ");
INSERT INTO tsg_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Na, in kaibanan tau nakarungug sin Baytaꞌ Marayaw amuna in biyaꞌ sapantun sin manga binhiꞌ iban sin lupaꞌ mabatu kiyahulugan nila. Pagdungug nila na mayan sin Baytaꞌ Marayaw magtūy nila tiyaymaꞌ iban pagkūg-kuyag nila. ");
INSERT INTO tsg_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Sagawaꞌ diꞌ maggamut in hinduꞌ sin Baytaꞌ Marayaw ha lawm atay nila, iban hangkarayꞌ da in tatasan nila. Hangkan bang sila datungan na kasusahan atawa kabinsanaan sabab sin pagtaymaꞌ nila sin hinduꞌ sin Baytaꞌ Marayaw, na magtūy nila butawanan in pangandul nila ha Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ampa in kaibanan tau nakarungug sin Baytaꞌ Marayaw amuna in biyaꞌ sapantun sin manga binhiꞌ iban sin lupaꞌ kiyahulugan nila amu in tiyutubuan sin manga sagbut matunuk. Diyungug nila in hinduꞌ sin Baytaꞌ Marayaw, ");
INSERT INTO tsg_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","sagawaꞌ masi sila magsusa sin manga palihālan dī ha dunya. Malabi ha atay nila in manga altaꞌ iban masi sila manapsu ha unu-unu katān. Na, hangkan maluppas sadja in karayawan makapabuntul sin kawl-piil nila, amu in makawaꞌ nila dayn ha hinduꞌ sin Baytaꞌ Marayaw. In sila yan biyaꞌ da sapantun tiyanum diꞌ magbunga. ");
INSERT INTO tsg_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Sagawaꞌ in tau kaibanan nakarungug sin hinduꞌ sin Baytaꞌ Marayaw amuna in biyaꞌ sapantun sin manga binhiꞌ iban sin lupaꞌ marayaw kiyahulugan nila. Diyungug nila in hinduꞌ sin Baytaꞌ Marayaw iban tiyaymaꞌ nila. Hangkan sumūng in dayaw sin kawl-piil nila. In kaibanan sarang-sarang in dayaw, in kaibanan isab dumayaw tuud ampa in kaibanan landuꞌ tuud dumayaw.” ");
INSERT INTO tsg_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Pagꞌubus, nangasubu hi Īsa, laung niya, “Maytaꞌ, awn ka magdā palitaan pa lawm bilik ubus ampa niya lukuban sin pastan atawa hibutang niya pa sawm kantil? Bukun ka subay niya hibutang in palitaan pa taas sin pagbubutangan palitaan? ");
INSERT INTO tsg_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Karnaꞌ unu-unu in tiyatapuk tantu gumuwaꞌ da iban unu-unu in līlibun tantu kaingatan da. ");
INSERT INTO tsg_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Na, sasukuꞌ sin kamu nakarungug, dunguga niyu tuud marayaw in biyaytaꞌ ku yan kaniyu!” ");
INSERT INTO tsg_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Laung pa isab hi Īsa, “Pahūpa niyu tuud marayaw pa lawm pamikil niyu in manga diyungug niyu yan. Sabab bang kamu matuyuꞌ tuud dumungug sin hinduꞌ, na sumūng in panghāti iban ingat niyu. ");
INSERT INTO tsg_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Karnaꞌ hisiyu-siyu in dumungug tuud marayaw sūngan sin Tuhan in panghāti niya, sagawaꞌ hisiyu-siyu in diꞌ dumungug marayaw minsan in maniyuꞌ-tiyuꞌ kahātihan niya, maīg da dayn kaniya.” ");
INSERT INTO tsg_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Na laung hi Īsa, “In hantang sin pamarinta sin Tuhan biyaꞌ sapantun sin kahālan sin hambuuk tau nagtanum manga binhiꞌ ha uma niya. ");
INSERT INTO tsg_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pagꞌubus niya nagtanum, pasāran niya na in manga binhiꞌ tumubuꞌ isa-isa niya. Himinang na siya sin manga hinang dugaing. Magsusūng in adlaw, in manga binhiꞌ tiyanum niya tumubuꞌ iban sumulig isa-isa nila. Diꞌ niya kaingatan bang biyaꞌ diin in pagtubuꞌ iban pagsulig sin manga binhiꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Pasal dayn ha lupaꞌ tumubuꞌ in manga binhiꞌ. Magjawm naa tagnaꞌ, ampa magburus, ubus ampa magbunga. ");
INSERT INTO tsg_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Na, bang hinug na in manga bunga, mawn na magꞌani in nagtanum sabab naabut na in musim sin pagꞌani.” ");
INSERT INTO tsg_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Laung pa isab hi Īsa, “Unu in hikasaliꞌ natuꞌ ha pamarinta sin Tuhan? Unu in hikadalil natuꞌ bat natuꞌ mapapata in kahantang sin pamarinta sin Tuhan? ");
INSERT INTO tsg_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","In pamarinta sin Tuhan hikadalil taniyu pa hambuuk bigi sibiꞌ-sibiꞌ ini hikatanum, ");
INSERT INTO tsg_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Na diꞌ lumugay tumubuꞌ iban lumagguꞌ tuud yan dayn ha katān jambangan. Dakulaꞌ in manga sanga niya amu in katapuan iban kapagpugaran sin manga manuk-manuk.” ");
INSERT INTO tsg_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Na, mataud ginisan dalilan biyaꞌ ha yan in kiyaisturi hi Īsa bang siya nagnasīhat ha manga tau sin hinduꞌ sin Baytaꞌ Marayaw pasal sin pamarinta sin Tuhan. Dalilun niya kaagi in pagnasīhat niya ha gantaꞌ kahātihan sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Diꞌ siya magnasīhat ha manga tau bang bukun dalil kaagi. Sagawaꞌ bang siya dakuman iban sin manga hangpuꞌ tagduwa mulid niya in duun, pahātihun niya sila sin maana sin katān isturi diyalil niya. ");
INSERT INTO tsg_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Sakali himapun-hapun mayan sin adlaw da yadtu, laung niya ha manga mulid niya, “Sūng kitaniyu umuntas pa hansipak hunasan.” ");
INSERT INTO tsg_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Na, minīg na sila dayn ha manga tau mataud. Simakat na in manga mulid hi Īsa pa kumpit asibiꞌ, lāgiꞌ in hi Īsa asal duun na naglilingkud. Na, diyā nila na siya timulak. Awn da isab kaibanan kumpit asibiꞌ dimungan timulak kanila. ");
INSERT INTO tsg_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pagꞌuntas nila, bukun malugay himuyup in hangin makusug iban nagꞌalun na. Nagsimpuwak in alun pa lawm kumpit nila iban agun-agun na mahipuꞌ sin tubig in kumpit. ");
INSERT INTO tsg_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","In hi Īsa didtu ha buliꞌ sin kumpit natutūg iban sin pagꞌūan niya. Biyatiꞌ siya sin manga mulid niya, laung nila, “Tuwan, diꞌ ka kaw magparuli minsan kitaniyu maabut na mapatay?” ");
INSERT INTO tsg_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Na, nagbangun hi Īsa ampa niya diyaak piyahundung in hangin. Laung niya, “Hundung kaw!” iban laung niya ha alun, “Linaw kaw!” Na saruun-duun himundung in hangin iban liminaw tuud in dagat. ");
INSERT INTO tsg_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Laung hi Īsa kanila, “Maytaꞌ kamu miyugaꞌ tuud? Maytaꞌ, masi pa wayruun pangandul niyu pa Tuhan?” ");
INSERT INTO tsg_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na, nahaylan tuud in manga mulid hi Īsa. Laung nila pakaniya-pakaniya, “Hisiyu bahaꞌ tuud in tau ini? Minsan in hangin iban alun magkahagad kaniya!” ");
INSERT INTO tsg_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Sakali dimatung na hi Īsa iban sin manga mulid niya pa hansipak sin Dagat Jalil, mawn pa hulaꞌ Girasa. ");
INSERT INTO tsg_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pagnaug na mayan hi Īsa dayn ha kumpit, biyāk siya sin hambuuk tau guwaꞌ dayn ha lawm kakubulan. In tau ini siyusūd saytan ");
INSERT INTO tsg_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","iban naghuhulaꞌ siya ha kakubulan. Diꞌ na tuud siya kahukutan minsan pa basiꞌ in hipanghukut kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nakamataud na bilangguan sin manga tau in siki-lima niya, sagawaꞌ magkabugtuꞌ-bugtuꞌ niya da in bilangguꞌ iban pagbaliꞌ-baliun niya in manga ikang-ikang. Wayruun tau makagapus kaniya sabab landuꞌ tuud in kusug niya. ");
INSERT INTO tsg_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Magsāsab siya magsilawak dūm-adlaw ha kakubulan iban ha manga būd-būd, iban panggisun niya sin manga batu in baran niya. ");
INSERT INTO tsg_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pagkitaꞌ sin tau ini kan Īsa dayn ha kalayuan, dimagan siya madtu kan Īsa ampa siya simujud ha alupan niya. ");
INSERT INTO tsg_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Laung hi Īsa kaniya, “Guwaꞌ kaw dayn ha lawm baran sin tau ini, saytan!” Magtūy similawak in tau siyusūd saytan, laung niya, “Unu in kabayaan mu kākuꞌ, Īsa, amu in Anak Tuhan Mahatinggi? Pangayuun ku junjung kaymu, ayaw mu aku binsanaa.” ");
INSERT INTO tsg_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Na, iyasubu siya hi Īsa, “Hisiyu in ngān mu?” In sambung niya, “In ngān ku hi Ibuhan sabab mataud tuud kami ini!” ");
INSERT INTO tsg_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Na, piyangayuꞌ niya tuud jiyunjung kan Īsa bang mayan diꞌ sila paīgun dayn ha hulaꞌ yaun. ");
INSERT INTO tsg_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Manjari ini awn manga babuy mataud nagbabaan didtu ha pigiꞌ būd nagkakaun. ");
INSERT INTO tsg_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Na, nangayuꞌ junjung kan Īsa in manga saytan, laung nila “Pakadtua kami pa manga babuy yaun. Pasūra kami pa lawm baran nila.” ");
INSERT INTO tsg_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Na, diyūlan sila hi Īsa. Gimuwaꞌ na in manga saytan dayn ha baran sin tau ampa sila limīn pa manga babuy. Na, magtūy in manga babuy nagbaan-baan limungtud dimagan dayn ha pangpang pa babaꞌ. Nakatūy sila pa lawm dagat iban naluꞌmus sila katān, awn manga kulang labi duwa ngaibu. ");
INSERT INTO tsg_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Manjari, in manga tau nagꞌiipat sin manga babuy magtūy dimagan madtu pa dāira iban pa kagimbahan nanuysuy ha manga tau pasal sin kītaꞌ nila. Na, miyadtu in manga tau nyimataꞌ sin suysuy diyungug nila. ");
INSERT INTO tsg_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pagdatung nila mawn kan Īsa, kītaꞌ nila in tau amu in bakas siyusūd sin saytan hangka-panji duun naglilingkud iban pagtamung marayaw. Kiyaulian iban ha lawm sayu na siya. Na, miyugaꞌ in tau katān. ");
INSERT INTO tsg_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Na, in manga tau amu in duun nakakitaꞌ nanuysuy na ha manga tau sin nahinang hi Īsa ha tau siyusūd sin manga saytan iban pasal sin manga babuy. ");
INSERT INTO tsg_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Na, pagꞌingat sin manga tau sin biyaꞌ hādtu, piyangayuꞌ nila kan Īsa sin subay siya mīg dayn ha hulaꞌ nila. ");
INSERT INTO tsg_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Sakali sūng mayan hi Īsa sumakat pa kumpit asibiꞌ, nangayuꞌ junjung kan Īsa in tau bakas siyusūd sin manga saytan, laung niya, “Tuwan, paagara aku kaymu.” ");
INSERT INTO tsg_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Sagawaꞌ diꞌ siya paagarun hi Īsa. Gām mayan laung hi Īsa kaniya, “Uwiꞌ na kaw madtu pa manga lahasiyaꞌ mu iban baytai sila pasal sin nahinang sin Panghuꞌ kaymu iban sin luuy niya kaymu.” ");
INSERT INTO tsg_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Na, minīg na in tau yaun, ampa niya liyatag siyuysuyan in manga tau ha hulaꞌ pagngānan Hangpuꞌ Lungsud sin nahinang hi Īsa kaniya. Na, nahaylan in tau katān nakarungug sin suysuy niya. ");
INSERT INTO tsg_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Manjari, imuntas na isab nagbalik hinda Īsa pa hansipak sin Dagat Jalil. Pagdatung nila, mataud tau in miyawn nagtipun ha katilibut hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ha saꞌbu niya duun, nākawn hi Jayrus, hambuuk nakuraꞌ sin langgal sin manga Yahudi. Pagkitaꞌ niya kan Īsa, magtūy siya simujud pa tungud siki hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Pagꞌubus, ampa siya nangayuꞌ junjung kan Īsa, laung niya, “Tuwan, in anak ku babai dāga-rāga nagdarā na napas. Anduꞌ, kari kaw agad kākuꞌ pa bāy ampa mu siya kumpiti bat siya dumayaw iban mabuhiꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Na, miyagad na hi Īsa kaniya. Mataud tuud tau in miyamagad kan Īsa iban naggigipit siya iban sin manga tau ha katilibut niya. ");
INSERT INTO tsg_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Sakali awn dimungan kanila hambuuk babai nasasakit pagguwaan duguꞌ, hangpuꞌ tagduwa tahun na in lugay niya. ");
INSERT INTO tsg_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mataud na mangungubat in nakaubat kaniya iban naubus na in pilak niya piyagpaubat, sagawaꞌ walaꞌ da siya imuliꞌ. Gām mayan magsusūng in sakit niya. ");
INSERT INTO tsg_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Sakali nakarungug siya manga suysuy pasal hi Īsa. Hangkan, limamugay siya ha manga tau mataud imurul kan Īsa ampa siya simuuk pa taykud hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Laung niya ha lawm atay niya, “Bang ku sadja kakamputan in juba niya, kaulian na in sakit ku.” ");
INSERT INTO tsg_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nakasuuk mayan siya kan Īsa, kiyamputan niya na in juba hi Īsa. Na, saruun-duun himundung in pagguwaꞌ sin duguꞌ niya iban kiyananaman niya na sin kiyaulian na siya dayn ha sakit niya. ");
INSERT INTO tsg_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Na, magtūy isab kiyaingatan hi Īsa sin awn kiyaulian dayn ha kusug sin barakat niya magpauliꞌ ha tagasakit. Hangkan, himundung siya ampa himarap pa ulihan. Laung niya, “Hisiyu in kimaput sin juba ku?” ");
INSERT INTO tsg_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Laung sin manga mulid niya, “Inday Tuwan. Kītaꞌ mu na in taud sin tau yan naggigipit iban ikaw, biyaꞌ diin in kaingat namuꞌ bang hisiyu in kimaput sin juba mu?” ");
INSERT INTO tsg_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Sagawaꞌ nanghinghing hi Īsa bat niya kaingatan bang hisiyu in kimaput sin juba niya. ");
INSERT INTO tsg_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na, in babai namidpid sin bugaꞌ sabab kiyaingatan niya na in kimugdan kaniya. Hangkan, miyadtu siya simujud pa tungud siki hi Īsa ampa siya namaytaꞌ sin kasabunnalan tuud. ");
INSERT INTO tsg_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Laung hi Īsa kaniya, “Indaꞌ, in kusug sin parachaya iban pangandul mu amu in nakauliꞌ kaymu. Pataptapa na in lawm atay mu. In sakit mu uliꞌ na tuud.” ");
INSERT INTO tsg_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ha saꞌbu hi Īsa namimichara ha babai yaun, awn nākawn manga tau dayn ha bāy hi Jayrus, amu in nakuraꞌ sin langgal. Laung nila kan Jayrus, “In anak mu miyatay na. Ayaw mu na paluuga madtu in Tuwan Guru.” ");
INSERT INTO tsg_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Sagawaꞌ walaꞌ hi Īsa nagꞌasip sin bichara nila. Gām mayan laung niya kan Jayrus, “Ayaw kaw masusa. Pagparachaya sadja kaw.” ");
INSERT INTO tsg_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Na, walaꞌ na piyaagad hi Īsa in manga tau kanila, luwal da hinda Pitrus iban sin duwa magtaymanghud hi Yaꞌkub kay Yahiya. ");
INSERT INTO tsg_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pagdatung nila pa bāy hi Jayrus, kītaꞌ hi Īsa sin nahiluhalaꞌ in manga tau iban diyungug niya na in pagtangis iban pagmatay sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Simūd siya pa lawm bāy ampa siya namichara, laung niya, “Maytaꞌ kamu nahiluhalaꞌ iban nagtangis? In bataꞌ walaꞌ miyatay, sagawaꞌ natūg sadja siya.” ");
INSERT INTO tsg_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Na, piyagkatawahan siya sin manga tau, sabab sin bichara niya. Sakali piyaguwaꞌ niya in manga tau. Ubus ampa niya diyā in inaꞌ amaꞌ sin bataꞌ iban sin tū mulid niya pa lawm bilik kiyabubutangan sin bataꞌ babai. ");
INSERT INTO tsg_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pagꞌubus, ampa niya kiyamputan in lima sin bataꞌ iban namung siya ha bahasa nila, laung niya, “Talita kumi.” In hāti niya, “Indaꞌ, bangun na kaw!” ");
INSERT INTO tsg_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Na, magtūy nagbangun in bataꞌ babai iban miyanaw na ha lawm bāy. (In umul sin bataꞌ babai hangpuꞌ tagduwa tahun.) Na, nahaylan tuud in manga nakakitaꞌ ha ini. ");
INSERT INTO tsg_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Sagawaꞌ ībut-ibutan tuud sila hi Īsa diꞌ pabaytaan minsan kansiyu pasal sin nahinang niya ha bataꞌ babai. Iban biyaytaan niya sila paparihilan kakaun in bataꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pagꞌubus yadtu minīg na hi Īsa dayn ha hulaꞌ yaun, ampa siya nagbalik madtu pa kawman luggiyaꞌ hulaan niya. Miyagad isab in manga mulid niya kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sakali, pagꞌabut adlaw Sabtuꞌ, amu in adlaw paghali-hali iban pagpudji pa Tuhan, timagnaꞌ na hi Īsa nagnasīhat didtu ha langgal. Mataud tau duun in nahaylan pagdungug nila sin pagnasīhat niya. Laung sin pakaniya-pakaniya, “Hawnu niya bahaꞌ nakawaꞌ in katān ingat niya yan? Unu bahaꞌ in barakat niya yan? Iban biyaꞌ diin in kahinang niya sin manga muꞌjijat yan? ");
INSERT INTO tsg_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Bukun ka in siya hambuuk karpintiru, amu in anak hi Mariyam iban taymanghud hinda Yaꞌkub, Yusup, Jahud iban Simun? Bukun ka in manga taymanghud niya babai yari hangka-lūngan taniyu?” Na, siyulak siya sin manga tau Nasarit. ");
INSERT INTO tsg_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Laung hi Īsa kanila, “In hambuuk nabi liyalagguꞌ hawnu-hawnu hulaꞌ! Sagawaꞌ ha luggiyaꞌ hulaꞌ niya diꞌ siya lagguun iban in manga lahasiyaꞌ iban sin manga tau hangka-kawman niya diꞌ manglagguꞌ kaniya.” ");
INSERT INTO tsg_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Na, wayruun unu-unu muꞌjijat in nahinang hi Īsa duun ha Nasarit, luwal da napauliꞌ niya in manga tau tagasakit kiyaputan niya, sagawaꞌ hangkatiyuꞌ da. ");
INSERT INTO tsg_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Landuꞌ tuud nainu-inu hi Īsa bang maytaꞌ wayruun pangandul kaniya sin manga tau duun. Pagꞌubus yadtu miyadtu na hi Īsa pa kakawm-kawman nagnasīhat ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sakali tiyawag niya in hangpuꞌ tagduwa mulid niya, ampa niya piyapanaw duwa-ruwa papagnasīhatun pa kahulaꞌ-hulaan. Dīhilan niya sila kawasa makapagꞌagi ha manga saytan. ");
INSERT INTO tsg_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Iban biyaytaan niya sila, laung niya, “Ha panaw niyu ini ayaw kamu magdā unu-unu luwal da manga tungkud niyu. Ayaw kamu magdā kakaun, pagluluunan sin kapanyapan niyu, iban sīn ha lawm sabitan niyu. ");
INSERT INTO tsg_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Makajari kamu magtawmpaꞌ sagawaꞌ ayaw kamu magdā badjuꞌ dugaing dayn sin ha baran niyu.” ");
INSERT INTO tsg_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Iban laung pa isab hi Īsa kanila, “Hawnu-hawnu na mān bāy kakadtuan niyu, bang marayaw in pagꞌasip kaniyu, duun na kamu hantiꞌ ha salugay niyu duun ha hulaꞌ yan. ");
INSERT INTO tsg_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na, bang kamu mākawn pa hulaꞌ sin manga tau amu in diꞌ magꞌasip kaniyu atawa diꞌ dumungug kaniyu, īg kamu dayn duun. Iban pagꞌīg niyu paspasi niyu in bagunbun dayn ha siki niyu (ha supaya mapakitaꞌ niyu in tandaꞌ sin diꞌ sila tūpun parulihun niyu).” ");
INSERT INTO tsg_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Na, miyanaw na in manga mulid niya, ampa nagnasīhat ha manga tau sin subay sila magtawbat na sin manga dusa nila. ");
INSERT INTO tsg_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mataud manga saytan in napaguwaꞌ nila dayn ha baran sin manga tau siyusūd saytan iban mataud tau nasasakit in siyapuhan nila sin lana amu in kiyaulian nila. ");
INSERT INTO tsg_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Manjari kiyarungugan hi Sultan Hirud in katān nahinang hi Īsa sabab simaplag na in suysuy pasal sin kabantugan niya. In manga kaibanan tau nagtukud-tukud na bang hisiyu hi Īsa. Laung sin kaibanan tau, “Nabuhiꞌ na nagbalik hi Yahiya Mangliliguꞌ. Hangkan sa in tau yan tagabarakat huminang sin manga muꞌjijat yan.” ");
INSERT INTO tsg_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Sagawaꞌ laung isab sin kaibanan, “Hi Ilyas in tau yan amu in nabi sin timpu nakauna.” Laung isab sin kaibanan, “Hambuuk nabi in tau yan, biyaꞌ sin manga nabi sin masa nakauna.” ");
INSERT INTO tsg_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pagdungug hi Hirud sin manga suysuy, laung niya, “Hi Yahiya Mangliliguꞌ in tau yan. Bakas ku piyapunggulan in ū niya, sagawaꞌ nabuhiꞌ siya nagbalik.” ");
INSERT INTO tsg_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Karnaꞌ biyaꞌ ha ini in isturi pasal sin pagpatay kan Yahiya. Iyasawa hi Hirud hi Hirudiya, amu in asawa sin taymanghud niya hi Pilip. Liyāngan siya hi Yahiya sin pagꞌasawa niya kan Hirudiya, hangkan piyasaggaw niya hi Yahiya, piyahukutan ampa piyajīl. ");
INSERT INTO tsg_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Karnaꞌ daran in pagbaytaꞌ hi Yahiya kan Hirud, laung niya, “Bukun mapatut asawahun mu in asawa sin taymanghud mu, hi Pilip.” ");
INSERT INTO tsg_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hangkan, dimugal hi Hirudiya kan Yahiya iban mabayaꞌ niya hipapatay hi Yahiya, sagawaꞌ diꞌ niya mahinang sabab diꞌ mabayaꞌ hi Hirud hipapatay hi Yahiya. ");
INSERT INTO tsg_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Karnaꞌ malagguꞌ in pagꞌaddat hi Hirud kan Yahiya pasal kiyaingatan niya sin in hi Yahiya tau marayaw iban suchi. Hangkan iyayaran niya hi Yahiya dayn ha kamulahan. Mabayaꞌ siya magdungug sin manga bichara hi Yahiya, sagawaꞌ sumigpit tuud in pamikil niya bang niya karungugan na. ");
INSERT INTO tsg_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Sakali naawn in waktu marayaw makapamaws hi Hirudiya kan Yahiya. Karnaꞌ dimatung mayan in adlaw bakas kapagꞌanak kan Hirud, nagpajamu siya ha manga katān wajil niya, ha manga nakuraꞌ sin manga sundalu iban ha manga tau barkanan ha Jalil. ");
INSERT INTO tsg_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sakali in anak hi Hirudiya budjang miyawn nagbayla pa pagjamuhan. Kiyasulutan tuud hi Hirud iban sin manga luruk sin pagbayla niya. Hangkan laung sin sultan ha budjang, “Sukat kaw sin unu-unu kabayaan mu, hirihil ku kaymu.” ");
INSERT INTO tsg_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Lāgiꞌ, simapa tuud siya ha budjang, laung niya, “Tantu hirihil ku tuud kaymu minsan unu in pangayuun mu, minsan in hangtungaꞌ sin altaꞌ ku.” ");
INSERT INTO tsg_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Na, miyadtu in budjang nangasubu ha inaꞌ niya kan Hirudiya laung niya, “Unu in pangayuun ku ha sultan?” In sambung sin inaꞌ niya, “Pangayua in ū hi Yahiya Mangliliguꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na, nagꞌūs-ꞌūs nagbalik in budjang madtu pa sultan ampa siya nangayuꞌ, laung niya, “In kabayaan ku hirihil mu kākuꞌ bihaun in ū hi Yahiya Mangliliguꞌ. Pabutangan ha talam!” ");
INSERT INTO tsg_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pagdungug sin sultan, nasusa tuud siya. Sagawaꞌ pagga siya nakajanjiꞌ ha budjang ha alupan sin manga tau luruk, na diꞌ niya na mabawiꞌ in kiyabichara niya kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hangkan, magtūy in sultan nagdaak ha hambuuk sundalu jaga hipaparā mawn kaniya in ū hi Yahiya. Na, miyadtu na pa jīl in sundalu jaga ampa piyunggulan in ū hi Yahiya. ");
INSERT INTO tsg_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Pagꞌubus ampa niya biyutang in ū ha talam ampa diyā madtu pa budjang. Diyā isab sin budjang in ū madtu pa inaꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Na, diyungug mayan sin manga mulid hi Yahiya in pasal ini, miyadtu sila kimawaꞌ sin bangkay hi Yahiya ampa nila kiyubul. Na, amu yan in suysuy pasal sin kamatay hi Yahiya Mangliliguꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Manjari, nakauwiꞌ na in manga mulid kiyawakilan hi Īsa dayn ha pagnasīhatan nila. Miyawn sila nagtipun kan Īsa ampa sila namaytaꞌ sin katān nahinang iban kiyahinduꞌ nila ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Na, landuꞌ tuud mataud tau in magkadtu-kari kimitaꞌ kan Īsa, hangkan diꞌ minsan makaluhaya kumaun hi Īsa iban sin manga mulid niya. Na, hangkan laung hi Īsa ha manga mulid niya, “Sūng kitaniyu pa lugal wayruun makasasaw kātuꞌniyu bat kamu makapaghali-hali.” ");
INSERT INTO tsg_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Na, miyadtu na sila nagkumpit harap pa hulaꞌ wayruun tau naghuhulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Sagawaꞌ mataud tau in nakakitaꞌ sin pagtulak nila iban magtūy sila kiyakilāhan sin manga tau. Na, in manga tau dayn ha kadāirahan katān imūsꞌ-ūs imurul nagpanaw sadja madtu pa hulaꞌ kadtuun hinda Īsa. Na, dimatung sila madtu muna dayn kan Īsa iban sin manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pagnaug hi Īsa dayn ha kumpit asibiꞌ, kītaꞌ niya in manga tau mataud. Limuuy tuud siya pagkitaꞌ niya ha manga tau sabab biyaꞌ sila sapantun manga bili-bili wayruun magꞌiipat kanila. Na, nagnasīhat na hi Īsa kanila iban mataud in niyasīhat niya. ");
INSERT INTO tsg_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pagga sin himapun na tuud, miyawn na in manga mulid niya kaniya, laung nila, “Tuwan, masuuk na marūm in hulaꞌ ampa in hulaꞌ ini wayruun tau naghuhulaꞌ dī. ");
INSERT INTO tsg_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Marayaw pa pakadtuun mu in manga tau ini pa manga lūngan iban pa manga bāy sin manga magꞌuuma amu in masuuk mari bat sila makapamī sin kakaun nila.” ");
INSERT INTO tsg_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Sagawaꞌ in sambung hi Īsa, laung niya, “Kamu na in dumihil kakaun kanila.” Laung nila, “Uy, na biyaꞌ diin yan? Ha banus sin tau yan subay hargaꞌ walu bulan gadji in hipamī sin kakaun hipakaun kanila.” ");
INSERT INTO tsg_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Na, laung hi Īsa kanila, “Pila in taud sin tinapay diyarā niyu? Kitaa niyu madtu.” Na, pagkitaꞌ nila, laung nila, “Awn lima tinapay iban duwa istaꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Pagꞌubus biyaytaan hi Īsa in manga mulid niya papalingkurun in manga tau katān, papagtumpuk-tumpukun ha kabaylihan. ");
INSERT INTO tsg_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Hangkan limingkud na in manga tau, nagtumpuk-tumpuk hanggatus-hanggatus iban kayꞌman-kayꞌman. ");
INSERT INTO tsg_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Na, kiyawaꞌ na hi Īsa in lima tinapay iban sin duwa istaꞌ, ampa siya himangad pa taas langit nagsarang-sukul pa Tuhan. Pagꞌubus, ampa niya piyagꞌutud-utud in manga tinapay, diyuhal pa manga mulid niya ampa piyarihil pa manga tau. Piyagbahagiꞌ-bahagiꞌ niya da isab in duwa istaꞌ ha manga tau katān. ");
INSERT INTO tsg_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Na, nakakaun in tau katān iban kiyansuban sila. ");
INSERT INTO tsg_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pagꞌubus sin manga tau nagkaun, tīpun sin manga mulid hi Īsa in nakapin kakaun iban istaꞌ. Nakahipuꞌ sila hangpuꞌ tagduwa ambung. ");
INSERT INTO tsg_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na, in taud sin tau kimaun, in manga usug sadja, awn lima ngaibu. ");
INSERT INTO tsg_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pagꞌubus yadtu magtūy piyasakat hi Īsa in manga mulid niya pa taas kumpit asibiꞌ, paunahun dayn kaniya madtu pa Bitsayda, ha hansipak sin dagat. Dimuun naa siya nagpauwiꞌ ha manga tau mataud. ");
INSERT INTO tsg_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Napauwiꞌ niya mayan in manga tau, miyadtu hi Īsa pa taas būd-būd nangarap pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Narūm mayan nakaabut na in manga mulid hi Īsa pa giꞌtungan sin dagat. Ampa in hi Īsa duun isa-isa niya ha ginlupaan. ");
INSERT INTO tsg_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Sakali kītaꞌ hi Īsa kiyahunitan nagdayung in manga mulid niya sabab simasangsang sila sin hangin. Na, subu-subu pa tuud ha ūt sin lisag tū iban lisag unum, miyanaw hi Īsa ha babaw dagat harap madtu pa manga mulid niya. Ambayaꞌ niya sila labayan, ");
INSERT INTO tsg_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","sagawaꞌ kītaꞌ siya sin manga mulid niya nagpapanaw ha babaw dagat. Na, similawak sin bugaꞌ in manga mulid niya sabab in pangannal nila lutaw in kītaꞌ nila. ");
INSERT INTO tsg_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Similawak tuud sila katān pagkitaꞌ nila kaniya sabab landuꞌ tuud sila miyugaꞌ. Sagawaꞌ magtūy hi Īsa namung kanila, laung niya, “Pataptapa niyu in atay niyu. Aku sa ini, hangkan ayaw kamu mabugaꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pagꞌubus simakat siya pa kumpit sartaꞌ himundung na in hangin. Nahaylan tuud in manga mulid niya kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Karnaꞌ diꞌ nila pa kaingatan bang hisiyu tuud hi Īsa minsan nila bakas na kītaꞌ bang biyaꞌ diin in pagpakaun hi Īsa ha manga tau. Diꞌ maabut sin pikilan nila in kītaꞌ nila. ");
INSERT INTO tsg_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Manjari limanjal na sila pa hansipak sin dagat. Duun sila dimungguꞌ ha kawman sin Ginnisarit. ");
INSERT INTO tsg_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pagnaug nila dayn ha kumpit, magtūy kiyakilāhan sin manga tau hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Hangkan in manga tau katān dayn ha pangdaig sin hulaꞌ yaun nagꞌūs-ūs miyawn kan Īsa nagdarā sin manga nasasakit amu in nagkukulang ha kulangan nila. Dāhun nila in manga nasasakit madtu kan Īsa minsan hawnu-hawnu hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iban pakain-pakain na mayan hi Īsa madtu, pa kawman atawa pa manga dāira atawa pa kagimbahan, dāhun sin manga tau in manga nasasakit madtu pa tabuꞌ ampa nila junjungan kan Īsa bang mayan pakaputun niya in manga nasasakit minsan dakuman duhul sin juba niya. Na, in katān tau nakakaput sin juba niya kiyaulian. ");
INSERT INTO tsg_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Manjari, in manga Parisi iban manga guru sin saraꞌ agama amu in nakalūd dayn ha dāira Awrusalam (Baytal Makdis) miyawn nagtipun kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Sakali, kītaꞌ nila in kaibanan manga mulid hi Īsa nagkakaun, ampa walaꞌ nakapanghugas tuud marayaw sin manga lima nila biyaꞌ kaagi sin addat sin manga Yahudi magsuchi sin lima nila bang sila kumaun. ");
INSERT INTO tsg_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Karnaꞌ in addat sin manga katān Yahudi labi awla na in manga Parisi diꞌ sila kumaun bang nila diꞌ masuchi naa muna in manga lima nila. Iyaagad nila tuud marayaw in manga biatan sin kamaasan nila. ");
INSERT INTO tsg_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Iban diꞌ sila kumaun sin unu-unu dayn ha tabuꞌ bang diꞌ kahugasan naa muna biyaꞌ sin kaagi nila maghugas. Iban iyaagad nila tuud marayaw in manga katān hinduꞌ daakan sin kamaasan nila biyaꞌ na sin kaagi sin paghugas marayaw sin manga sawan, siliꞌ, iban sin manga paglulutuan tumbaga. ");
INSERT INTO tsg_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Hangkan, pagkitaꞌ sin manga Parisi iban sin manga guru sin saraꞌ agama ha manga mulid hi Īsa nagkakaun ha walaꞌ makapagsuchi sin manga lima nila, iyasubu nila hi Īsa, laung nila, “Maytaꞌ in manga mulid mu diꞌ magkahagad sin manga biatan sin manga kamaasan natuꞌ? Magkaun sadja sila minsan walaꞌ nakapanghugas tuud marayaw sin manga lima nila.” ");
INSERT INTO tsg_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","In sambung hi Īsa kanila, “In kamu yan magpabawꞌ-bawꞌ sadja miyamagad ha daakan sin Tuhan! Sagawaꞌ in ha lawm atay niyu diꞌ magkugdan iban sin manga bichara niyu. Kiyugdan tuud kamu sin kiyabaytaꞌ hi Isayas ha lawm Kitab, amu agi sin Tuhan, ‘Liyalagguꞌ aku sin manga tau sin lapal-kabtangan nila, sagawaꞌ malayuꞌ aku dayn ha lawm atay nila. ");
INSERT INTO tsg_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Way da pūs nila magpudji kākuꞌ sabab hibaytaꞌ nila sin in hinduꞌ nila daakan dayn kākuꞌ, sagawaꞌ in kasabunnalan niya hinang-hinang nila sadja in hinduꞌ yan.’” ");
INSERT INTO tsg_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Na, biyaꞌ ha yan tuud in kamu,” laung hi Īsa. “Walaꞌ niyu na iyagad in daakan sin Tuhan, sagawaꞌ amu in kiyahagad niyu in manga daakan sin pagkahi niyu mānusiyaꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Laung pa isab hi Īsa, “Mapanday tuud kamu huminang sin dān hikasulak niyu in daakan sin Tuhan ha supaya niyu kabawgbugan in manga hinduꞌ biatan sin kamaasan niyu. ");
INSERT INTO tsg_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Karnaꞌ,” laung hi Īsa, “Nagparman in Tuhan, piyanaug niya dayn kan Musa, amu agi, ‘Pagꞌaddati niyu in inaꞌ amaꞌ niyu,’ iban, ‘Hisiyu-siyu in manuknaꞌ ha amaꞌ atawa inaꞌ niya subay patayun.’ ");
INSERT INTO tsg_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Sagawaꞌ dugaing in hīnduꞌ niyu ha manga tau. Laung niyu, bang in hambuuk tau awn hipanabang niya ha maas niya, sagawaꞌ imiyan siya sin in tabang niya kanila hiungsud niya na kulban, (hāti niya kiyaungsud na pa Tuhan), ");
INSERT INTO tsg_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","na in yan makajari, minsan siya diꞌ na tumabang ha inaꞌ-amaꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Na, in hinduꞌ biatan sin kamaasan niyu biyaꞌ ha yan amu in hīnduꞌ niyu isab ha manga tau,” laung hi Īsa, “amuna in nakapalayuꞌ ha manga tau dayn ha Parman sin Tuhan. Lāgiꞌ, bukun sadja yan in nahinang niyu. Mataud pa dugaing nahinang niyu amu in nakalanggal ha daakan sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Pagꞌubus tiyawag nagbalik hi Īsa in tau mataud mawn kaniya ampa siya namung kanila, laung niya, “In kamu katān, dungug kamu sin hinduꞌ ku iban hātiha niyu tuud. ");
INSERT INTO tsg_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","In unu-unu kakaun makasūd pa lawm baran sin tau diꞌ makasammal kaniya, sagawaꞌ in manga unu-unu mangīꞌ guwaꞌ dayn ha lawm simud sin tau amu in makasammal kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Na, sasukuꞌ sin kamu nakarungug, dunguga niyu tuud in biyaytaꞌ ku yan kaniyu!” ");
INSERT INTO tsg_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Na, pagꞌīg hi Īsa dayn ha manga tau mataud miyadtu siya pa hambuuk bāy. Duun mayan siya ha lawm bāy, iyasubu siya sin manga mulid niya pasal sin hinduꞌ diyalil niya. ");
INSERT INTO tsg_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Laung hi Īsa kanila, “Bat biyaꞌ da isab kamu sin kaibanan tau masi pa wayruun panghāti. Maytaꞌ, diꞌ niyu kaingatan sin in unu-unu kakaun makasūd pa lawm baran sin tau diꞌ yan makasammal kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Sabab in kakaun yan diꞌ sumūd pa lawm atay niya sagawaꞌ pa lawm tiyan niya, iban pagꞌubus gumuwaꞌ da yan dayn ha lawm baran niya.” (Dayn ha bichara hi Īsa yan, piyahāti niya sin in katān kakaun halal iban wayruun kakaun in haram.) ");
INSERT INTO tsg_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Iban laung pa isab hi Īsa, “In unu-unu mangīꞌ gumuwaꞌ dayn ha lawm atay sin tau amu in makasammal kaniya mahinang niya dusa. ");
INSERT INTO tsg_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Karnaꞌ dayn ha lawm atay sin tau gumuwaꞌ in manga unu-unu mangīꞌ amu in makarā kaniya huminang maasihat, manakaw, mamunuꞌ, ");
INSERT INTO tsg_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","magjina, magnapsu sin unu-unu sin kaibanan, maghinang sin unu-unu katān mangīꞌ, mangakkal ha pagkahi, magbais, mangabughuꞌ, manglimut, magtaas atay iban magkarupangan. ");
INSERT INTO tsg_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","In manga katān hinang mangīꞌ yan guwaꞌ dayn ha lawm pikilan sin tau iban amu yan in makasammal, mahinang niya dusa.” ");
INSERT INTO tsg_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pagꞌubus minīg na hi Īsa, ampa siya limanjal dayn didtu pa hulaꞌ ha tungud sin dāira Tirus. Miyadtu siya pa hambuuk bāy iban in kabayaan niya wayruun makaingat sin yaun siya duun. Sagawaꞌ diꞌ da siya makatapuk dayn ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Awn hambuuk babai amu in tagaanak babai siyusūd saytan in nakarungug pasal hi Īsa. Na, magtūy siya simujud pa alupan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","In babai ini bangsa Piniki dayn ha hulaꞌ Siriya iban bukun siya Yahudi. Piyangayuꞌ niya junjung kan Īsa papaguwaun in saytan dayn ha lawm baran sin anak niya babai. ");
INSERT INTO tsg_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sagawaꞌ diyalil hi Īsa in sambung niya laung niya, “Subay pakaunun naa muna in manga bataꞌ-bataꞌ. Bukun patut in kakaun sin manga bataꞌ-bataꞌ hipakaun pa manga iruꞌ ipatan.” ");
INSERT INTO tsg_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“Bunnal in bichara mu yan, Tuwan,” laung sin babai, “sagawaꞌ minsan in manga iruꞌ ipatan ha sawm lamisahan kumaun da sin manga kakaun matanak dayn ha kakaun sin manga bataꞌ-bataꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Na laung hi Īsa kaniya, “Dayn ha sabab sin pamung mu yan, kiyaulian na in anak mu. Uwiꞌ na kaw. Naīg na in saytan dayn ha lawm baran sin anak mu!” ");
INSERT INTO tsg_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Na, minuwiꞌ na in babai. Pagꞌuwiꞌ niya, kītaꞌ niya in anak niya nagkukulang ha kulangan iban kiyaulian na. Naīg na in saytan dayn ha lawm baran niya. ");
INSERT INTO tsg_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Manjari, dayn ha dāira Tirus nagbalik na hi Īsa pa Dagat Jalil. Limabay siya dayn ha Sidun iban dayn ha hulaꞌ pagngānan Hangpuꞌ Dāira. ");
INSERT INTO tsg_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Dimatung mayan siya madtu, awn manga tau miyawn kaniya nagdarā hambuuk tau bisu iban umaw. Nangayuꞌ sila junjung kan Īsa bang mayan kaputan niya in tau ini. ");
INSERT INTO tsg_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Na, diyā hi Īsa limawak in tau bisu iban umaw dayn ha manga tau mataud ampa niya kiyamputan in lungag taynga sin tau iban piyahiran niya sin luraꞌ niya in dilaꞌ sin tau ini. ");
INSERT INTO tsg_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pagꞌubus ampa hi Īsa himangad pa langit, ampa siya nimapas dakulaꞌ. Laung niya ha tau umaw-bisu, “Ippata,” in hāti niya “Maukab na.” ");
INSERT INTO tsg_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Na, saruun-duun nakarungug na in tau bisu iban gimaan na in dilaꞌ niya sartaꞌ mahantap na siya magbichara. ");
INSERT INTO tsg_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pagꞌubus ampa ībut-ibutan hi Īsa in manga tau, diꞌ pabaytaun minsan kansiyu pasal sin nahinang niya. Sagawaꞌ iyampa na sila liyāng, iyampa na sila nagsuysuy pasal sin nahinang niya. ");
INSERT INTO tsg_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Na, in tau katān nakarungug sin suysuy ini nahaylan tuud. Laung nila, “Uy, landuꞌ tuud marayaw in katān nahinang niya. Minsan in bisu maparungug niya iban umaw mapabichara niya.” ");
INSERT INTO tsg_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pagꞌubus, bukun malugay hambuuk adlaw nagtipun nagbalik mawn kan Īsa in manga tau mataud. Sakali pagga wayruun na kakaun sin manga tau, tiyawag hi Īsa in manga mulid niya iban laung niya kanila, ");
INSERT INTO tsg_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Maluuy aku ha manga tau ini sabab awn na tūy adlaw sila ini miyamagad kākuꞌ, ampa bihaun wayruun makaun nila. ");
INSERT INTO tsg_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Bang ku sila pauwiun hiyahapdiꞌ, na punungun sila ha dān, sabab in kaibanan kanila malayuꞌ in uwian.” ");
INSERT INTO tsg_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Laung sin manga mulid niya, “Ay kaw naa, Tuwan, hariin kitaniyu kumawaꞌ kakaun makainihan hipakaun ha manga tau mataud ini sin wayruun tau naghuhulaꞌ ha hulaꞌ ini?” ");
INSERT INTO tsg_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Pila in taud sin tinapay diyarā niyu?” laung hi Īsa. “Pitu,” in sambung sin manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Na, īyan hi Īsa in manga tau mataud papalingkurun ha lupaꞌ. Pagꞌubus ampa niya kiyawaꞌ in pitu tinapay ampa siya nagsarang-sukul pa Tuhan. Ubus niya piyagꞌutud-utud in tinapay, diyuhal niya pa manga mulid niya ampa piyarihil pa manga tau. Na, dīhil na sin manga mulid niya in tinapay pa manga tau. ");
INSERT INTO tsg_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Awn da isab hangkatiyuꞌ istaꞌ asibiꞌ diyarā sin manga mulid hi Īsa. Pagꞌubus hi Īsa nagsarang-sukul pa Tuhan, diyuhal niya isab in istaꞌ pa manga mulid niya hipaparihil ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Na, nakakaun in tau katān iban kiyansuban sila. Awn manga upat ngaibu tau in nakakaun. ");
INSERT INTO tsg_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Pagꞌubus sin manga tau nagkaun, tīpun sin manga mulid hi Īsa in manga kakaun nakapin. Nakahipuꞌ sila pitu ambung. Sakali piyauwiꞌ na hi Īsa in manga tau, ");
INSERT INTO tsg_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ubus ampa siya magtūy simakat pa kumpit asibiꞌ iban sin manga mulid niya. Timulak sila madtu pa hulaꞌ Dalmanuta. ");
INSERT INTO tsg_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pagdatung hinda Īsa pa Dalmanuta, miyawn in manga Parisi kan Īsa dimā kaniya magsual. Mabayaꞌ nila sulayan in barakat hi Īsa. Hangkan, nangayuꞌ sila kumitaꞌ hambuuk muꞌjijat dayn kan Īsa bat awn tandaꞌ kakitaan nila sin bunnal tuud naraak siya sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Na, nimapas hi Īsa dakulaꞌ sabab masimbul in lawm atay niya ampa siya namung ha manga Parisi, laung niya, “Maytaꞌ in manga tau sin masa ini mabayaꞌ kumitaꞌ muꞌjijat? Sāꞌ tuud in pikilan sin manga tau ini. Na, baytaan ta kamu sin mattan. Diꞌ ku pakitaun muꞌjijat in manga tau sin masa ini.” ");
INSERT INTO tsg_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Na, minīg na hi Īsa dayn kanila, ampa siya nagbalik pa kumpit iban sin manga mulid niya. Imuntas sila pa hansipak sin dagat. ");
INSERT INTO tsg_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Manjari, kiyalupahan sin manga mulid hi Īsa magdā kakaun. Amura in diyarā nila in hambuuk tinapay duun ha kumpit. ");
INSERT INTO tsg_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Sakali laung hi Īsa kanila, “Kamayaꞌ-mayaꞌ da kamu iban halliꞌ kamu dayn ha pasulig sin tinapay sin manga Parisi iban hi Hirud.” ");
INSERT INTO tsg_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Na, nagꞌinu-inu nagbichara pakaniya-pakaniya in manga mulid niya bang maytaꞌ siya namung biyaꞌ hādtu. Laung nila “Marayꞌ hangkan siya namung biyaꞌ hādtu sabab walaꞌ kitaniyu nagdā tinapay kakaun taniyu.” ");
INSERT INTO tsg_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Na, kiyaingatan hi Īsa bang unu in piyagginggungan nila. Hangkan laung niya kanila, “Maytaꞌ kamu magsusa pasal sin wayruun kakaun? Maytaꞌ masi namān kamu diꞌ makaingat atawa diꞌ makahāti? Maytaꞌ pupud na in pikilan niyu? ");
INSERT INTO tsg_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Taga mata sa kamu, na maytaꞌ kamu diꞌ makakitaꞌ? Taga taynga sa kamu, na maytaꞌ kamu diꞌ makarungug? Diꞌ niyu ka katumtuman ");
INSERT INTO tsg_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","in waktu piyagbahagiꞌ-bahagiꞌ ku in lima tinapay piyakaun ku ha lima ngaibu tau? Pila in natipun niyu ambung hipuꞌ sin kakaun kapin pagꞌubus sin manga tau nagkaun?” “Hangpuꞌ tagduwa,” in sambung sin manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Iban ha waktu piyagꞌutud-utud ku in pitu tinapay piyakaun ha upat ngaibu tau,” laung hi Īsa, “pila in natipun niyu ambung hipuꞌ sin kakaun kapin?” “Pitu,” in sambung sin manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Na, diꞌ pa ka kamu makahāti sin bukun pasal kakaun in piyagbichara ku?” laung hi Īsa ha manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Sakali dimatung mayan hinda Īsa pa Bitsayda, awn hambuuk tau buta diyā mawn kaniya sin manga tau. Piyangayuꞌ nila junjung kan Īsa pakumpitan kaniya in tau buta. ");
INSERT INTO tsg_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Na, kiyumpitan hi Īsa in tau buta ampa niya iyambit diyā gimuwaꞌ dayn ha kawman yaun. Pagꞌubus ampa niya liyuraan in mata sin tau buta. Biyutang niya in lima niya pa mata sin buta ubus ampa niya iyasubu, laung niya, “Awn na kakitaan mu?” ");
INSERT INTO tsg_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Sakali biyantang sin tau buta in pangatud niya pa unahan. Laung niya, “Huun, kakitaan ku in manga tau nagpapanaw, saꞌ biyaꞌ sila lupa manga kahuy.” ");
INSERT INTO tsg_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Na, biyutang hi Īsa nagbalik in lima niya pa mata sin tau buta. Imatud in tau buta sartaꞌ nagbalik na in pangitaꞌ niya iban kakitaan niya na marayaw in unu-unu katān. ");
INSERT INTO tsg_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Na, piyauwiꞌ na hi Īsa in tau buta saꞌ īyan niya, laung niya, “Ayaw na kaw humapit dayn ha kawman yan mamaytaꞌ ha manga tau sin makakitaꞌ na kaw.” ");
INSERT INTO tsg_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Manjari, limanjal na hi Īsa iban sin manga mulid niya pa manga kawman masuuk pa hulaꞌ Sisariya Pilipi. Ha saꞌbu nila miyamanaw, iyasubu hi Īsa in manga mulid niya, laung niya, “Bang ha bichara sin manga tau, hisiyu kunuꞌ aku?” ");
INSERT INTO tsg_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Na, laung sin manga mulid niya kaniya, “Laung sin kaibanan tau ikaw kunuꞌ hi Yahiya Mangliliguꞌ. Laung isab sin kaibanan ikaw kunuꞌ hi Ilyas, ampa isab in kaibanan laung nila hambuuk kaw kunuꞌ nabi sin masa nakauna yadtu amu in nabuhiꞌ nagbalik.” ");
INSERT INTO tsg_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Na, iyasubu sila hi Īsa, laung niya, “Na, bang kamu, hisiyu aku?” In sambung hi Pitrus, “Ikaw in Almasi.” ");
INSERT INTO tsg_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Na ībut-ibutan sila hi Īsa, laung niya, “Ayaw kamu magbaytaꞌ minsan hisiyu sin pasal ku.” ");
INSERT INTO tsg_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Pagꞌubus yadtu timagnaꞌ na hi Īsa nanghinduꞌ ha manga mulid niya pasal sin baran niya. “In aku,” laung hi Īsa, “amu in Anak Mānusiyaꞌ subay tuud makalabay kabinsanaan dakulaꞌ, iban kahukawan tuud aku sin manga nagtatau-maas ha hulaꞌ, sin manga nakuraꞌ kaimaman iban sin manga guru sin saraꞌ agama. Hipapatay nila aku sagawaꞌ ha hikatū sin adlaw dayn ha kamatay kākuꞌ, mabuhiꞌ da aku magbalik.” ");
INSERT INTO tsg_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Na, piyahāti tuud hi Īsa in pasal yan ha manga mulid niya. Sakali, diyā hi Pitrus hi Īsa limawak hangkatiyuꞌ dayn ha kaibanan ampa niya siyamlang in bichara hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Sagawaꞌ timaykud hi Īsa dayn kan Pitrus ampa siya imatud ha manga mulid niya, ubus ampa niya piyagꞌamahan hi Pitrus. Laung niya, “Īg kaw dayn kākuꞌ, Saytan Puntukan! Sabab in ha lawm sin pikilan mu yan pamikil sin mānusiyaꞌ, bukun pamikil dayn ha Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pagꞌubus tiyawag hi Īsa in manga tau mataud iban sin manga mulid niya, pakawnun kaniya. Laung niya kanila, “Bang awn tau mabayaꞌ magad kākuꞌ, subay agarun niya in kabayaan ku bukun in kabayaan niya. Subay siya mangaku sin katān haggut-pasuꞌ minsan siya mapatay ha pasal ku, ampa siya tūpun magad kākuꞌ! ");
INSERT INTO tsg_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Karnaꞌ hisiyu-siyu in maūg ha kabuhiꞌ niya iban magpikil sadja sin kabayaan niya tantu mapatay da siya. Sagawaꞌ hisiyu-siyu in diꞌ maūg ha kabuhiꞌ niya minsan siya mapatay ha pasal ku iban pagbawgbug sin Baytaꞌ Marayaw pasal sin pamarinta sin Tuhan, tantu makabaak siya kabuhiꞌ salama-lama. ");
INSERT INTO tsg_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Sabab unu in kapūsan sin hambuuk tau magparūl sadja sin katān kanapsuhan niya dī ha dunya bang ha adlaw mahuli masiksaꞌ da in nyawa ha lawm narkaꞌ? ");
INSERT INTO tsg_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Sabab wayruun unu-unu ha lawm dunya ini in hikalukat sin hambuuk tau sin nyawa niya dayn ha lawm kasiksaan. ");
INSERT INTO tsg_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ha masa ini in manga mānusiyaꞌ baldusa iban miyutas na dayn ha Tuhan. Na, hisiyu-siyu in tau ha masa ini in masipug imiyan sin agad siya kākuꞌ iban masipug magad sin manga hinduꞌ ku, na in aku amu in Anak Mānusiyaꞌ, masipug da isab imiyan sin in siya agad kākuꞌ bang aku magbalik na mari pa dunya. Bang aku magbalik na mari, magꞌagad aku iban sin manga malāikat iban in sahaya iban kalagguan ku biyaꞌ sin sahaya iban kalagguan sin Tuhan, Amaꞌ ku.” ");
INSERT INTO tsg_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Na, laung pa isab hi Īsa ha manga tau iban manga mulid niya, “Na, ini in mattan hibaytaꞌ ku kaniyu! Awn kaibanan dī kaniyu in masi pa buhiꞌ sampay maabut in waktu kamasahan nila dumatung in pamarinta sin Tuhan iban sin kawasa niya sangat makusug.” ");
INSERT INTO tsg_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Manjari, nakalabay mayan unum adlaw dayn ha adlaw yadtu, diyā hi Īsa timukad hinda Pitrus, Yaꞌkub iban hi Yahiya madtu pa būd mataas. Sila-sila da in miyadtu. Didtu mayan sila ha taas būd, magtūy napinda in lupa hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nagsinglab in tamungun niya iban landuꞌ tuud maputiꞌ. Karnaꞌ wayruun tamungun in makaatu sin kaputiꞌ niya minsan da makapila dakdakan. ");
INSERT INTO tsg_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Pagꞌubus, kītaꞌ sin tū mulid ini in duwa nabi, (amu in malugay na nanaykud dayn ha dunya), hi Ilyas kay Musa, nagbibichara iban hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Na, magtūy namung hi Pitrus kan Īsa, laung niya, “Tuwan, marayaw tuud isab sin yari kami dī! Hinangan namuꞌ kamu tū panggung, hambuuk kaymu, hambuuk kan Musa iban hambuuk kan Ilyas.” ");
INSERT INTO tsg_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Hangkan nakapamung hi Pitrus sin biyaꞌ ha yan sabab diꞌ na siya maingat bang unu na in hibichara niya karnaꞌ landuꞌ tuud siya miyugaꞌ iban sin manga iban niya. ");
INSERT INTO tsg_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Na, sartaꞌ awn gimuwaꞌ gabun iban kiyalambungan sila. Pagꞌubus, awn na suwara diyungug nila dayn ha gabun, amu agi sin suwara, “Amu na ini in Anak ku kalasahan. Dungug kamu sin hinduꞌ niya!” ");
INSERT INTO tsg_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Na, magtūy nanglingiꞌ-lingiꞌ in tūngka-tau sin katilibut nila, sagawaꞌ way na tau dugaing duun kītaꞌ nila, luwal da hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Na, paglūd nila dayn ha taas būd, ībut-ibutan hi Īsa in tū mulid niya, laung niya, “Ayaw kamu magbaytaꞌ minsan hisiyu sin manga kītaꞌ niyu didtu ha taas būd. Subay na aku, amu in Anak Mānusiyaꞌ, mapatay iban mabuhiꞌ magbalik dayn ha kamatay.” ");
INSERT INTO tsg_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Na, nagkahagad sila sin baytaꞌ hi Īsa, sagawaꞌ nagꞌasubu-iyasubuhi na sila. Laung nila, “Unu bahaꞌ in hātihan sin bichara niya mabuhiꞌ siya magbalik dayn ha kamatay?” ");
INSERT INTO tsg_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na, laung nila kan Īsa, “Tuwan, maytaꞌ in baytaꞌ sin manga guru sin saraꞌ agama lumahil naa muna hi Ilyas (ampa in Almasi)?” ");
INSERT INTO tsg_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Na, laung hi Īsa kanila, “Bunnal, muna lumahil mari hi Ilyas magsaddiya sin unu-unu katān. Sagawaꞌ kiyasulat da isab ha lawm Kitab sin in aku, amu in Anak Mānusiyaꞌ, lumabay tuud kabinsanaan iban itungun aku hambuuk tau wayruun guna kaagi sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Na,” laung hi Īsa, “ini in hibaytaꞌ ku kaniyu. In hi Ilyas bakas na limahil mari, iban hīnang kaniya sin manga tau in unu-unu kabayaan nila, biyaꞌ da sin kiyasulat ha lawm Kitab pasal niya.” ");
INSERT INTO tsg_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Manjari, nakabalik mayan sila mawn pa manga kaibanan mulid niya, kītaꞌ nila mataud tau nagtitipun duun, iban awn manga guru sin saraꞌ agama in dimarā naglugat ha manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sakali pagkitaꞌ sin manga tau kan Īsa, nainu-inu tuud sila. Dimagan sila madtu kaniya simagina. ");
INSERT INTO tsg_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Na, iyasubu hi Īsa in manga mulid niya, laung niya, “Unu in piyaglugatan niyu iban sila?” ");
INSERT INTO tsg_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Na, awn hambuuk tau simambung, laung niya, “Tuwan, diyā ku in anak ku usug mari kaymu sabab siyusūd siya sin saytan umaw hangkan diꞌ siya makabichara. ");
INSERT INTO tsg_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Bang siya sūrun na sin saytan, dumakdak siya pa lupaꞌ. Magbukal-bukal in simud niya, magkansing in ipun niya iban manugas in baran niya. Piyangayuꞌ ku ha manga mulid mu papaguwaun in saytan dayn ha lawm baran sin anak ku, sagawaꞌ diꞌ nila mahinang.” ");
INSERT INTO tsg_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Laung hi Īsa kanila, “In manga tau sin masa ini wayruun tuud pangandul pa Tuhan. Maunu pa in lugay ku dī kaniyu, (ampa niyu kahātihan in kusug sin kawasa sin Tuhan)? Maunu pa in lugay sandalan ku (ampa kamu magparachaya)? Dāha mari in bataꞌ kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Na, diyā na in bataꞌ madtu kan Īsa. Pagkitaꞌ na mayan sin saytan kan Īsa, magtūy niya piyapagpaspad in bataꞌ diyakdak pa lupaꞌ. Nagpaspad iban nagbukal-bukal in simud sin bataꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Na, iyasubu hi Īsa in amaꞌ, laung niya, “Maunu na in lugay sin bataꞌ yan nabiyaꞌ ha yan?” “Dayn sin kabataꞌ-bataꞌ niya pa,” in sambung sin amaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Mawmu siya pagdāhun sin saytan pa lawm kāyu iban pa lawm tubig ha supaya siya matay. Anduꞌ, Tuwan, kaluuyi kami iban tabanga kami bang awn da dapat mu,” laung sin amaꞌ sin bataꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“Maytaꞌ kaw imiyan bang aku makarapat? Tantu, hisiyu-siyu in magparachaya iban mangandul ha Tuhan, makarapat huminang sin unu-unu katān,” laung hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Na, magtūy namichara matanug in amaꞌ sin bataꞌ, laung niya, “Magparachaya iban mangandul aku. Tabanga aku bat sumūng pa in pagparachaya iban pangandul ku.” ");
INSERT INTO tsg_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Na, pagkitaꞌ hi Īsa sin magtataud in tau harap mawn kanila, magtūy niya iyuldinan in saytan, laung niya, “In ikaw saytan umaw iban bisu, guwaꞌ kaw dayn ha lawm baran sin bataꞌ ini iban ayaw na kaw tuud sumūd magbalik kaniya.” ");
INSERT INTO tsg_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Na, similawak in saytan sartaꞌ nagpaspad in bataꞌ sabab sin saytan ha lawm baran niya. Pagꞌubus ampa gimuwaꞌ in saytan. Nabiyaꞌ lupa mayat in bataꞌ, hangkan in pangannal sin katauran tau miyatay in bataꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sagawaꞌ kiyaputan hi Īsa in lima sin bataꞌ ampa niya piyatindug. Na, timindug in bataꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pagꞌubus yadtu, nakasūd mayan hi Īsa pa lawm bāy, iyasubu siya sin manga mulid niya, ha wayruun tau dugaing nagdurungug. Laung nila, “Tuwan, maytaꞌ kami diꞌ makapaguwaꞌ sin saytan dayn ha lawm baran sin bataꞌ?” ");
INSERT INTO tsg_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","In sambung hi Īsa, “In saytan biyaꞌ hādtu diꞌ mapaguwaꞌ bang kitaniyu diꞌ mangayuꞌ naa muna tabang dayn ha Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Manjari minīg na hinda Īsa dayn ha hulaꞌ yaun iban limabay sila dayn ha hulaꞌ Jalil. In kabayaan hi Īsa wayruun tau makaingat bang hawnu siya, ");
INSERT INTO tsg_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","sabab naghihinduꞌ siya, ha manga mulid niya, laung niya, “In aku amu in Anak Mānusiyaꞌ hiungsud na pa lawm lima sin manga tau. Hipapatay nila aku, sagawaꞌ maabut hikatū sin adlaw dayn ha kamatay kākuꞌ mabuhiꞌ aku magbalik.” ");
INSERT INTO tsg_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Na, walaꞌ nakahāti in manga mulid niya bang unu in hātihan sin bichara niya, sagawaꞌ mabugaꞌ sila mangasubu kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Sakali, dimatung na hinda Īsa pa Kapirnaum iban nakasūd mayan sila pa lawm bāy, iyasubu hi Īsa in manga mulid niya. Laung niya, “Unu in piyaglugatan niyu didtu ha dān?” ");
INSERT INTO tsg_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Na, diꞌ na sila makasambung kan Īsa, sabab in piyaglugatan nila ha dān pasal bang hisiyu in mataas tuud ha sila manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Na, limingkud hi Īsa ampa niya tiyawag in hangpuꞌ tagduwa mulid niya. Laung niya kanila, “Hisiyu-siyu in mabayaꞌ tumaas tuud subay siya magpababaꞌ sin baran niya iban subay siya magtagꞌīpun ha katān.” ");
INSERT INTO tsg_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sakali, kiyawaꞌ hi Īsa in hambuuk bataꞌ-bataꞌ, ampa niya piyatindug ha alupan sin manga mulid niya. Kiyamputan niya in bataꞌ, pīpi niya, ampa siya namichara kanila, ");
INSERT INTO tsg_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","laung niya, “Hisiyu-siyu in magparuli tuud ha hambuuk bataꞌ-bataꞌ biyaꞌ sin bataꞌ ini, sabab-karnaꞌ in tau yaun agad kākuꞌ, na biyaꞌ da tuud isab baran ku in piyaruli niya, iban hisiyu-siyu in magparuli kākuꞌ, na piyaruli niya da isab in nagdaak kākuꞌ mari.” ");
INSERT INTO tsg_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Na, laung hi Yahiya, “Tuwan, awn kītaꞌ namuꞌ hambuuk tau simabbut sin ngān mu nagpaguwaꞌ manga saytan dayn ha lawm baran sin tau. Liyāng namuꞌ siya sabab bukun siya agad kātuꞌniyu.” ");
INSERT INTO tsg_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","“Ayaw niyu siya lāngi,” laung hi Īsa kanila, “sabab hisiyu-siyu in sumabbut sin ngān ku huminang muꞌjijat, in siya yan diꞌ makapamung sin mangīꞌ pasal ku. ");
INSERT INTO tsg_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Karnaꞌ hisiyu-siyu in bukun kimukuntara kātuꞌniyu, na agad kātuꞌniyu. ");
INSERT INTO tsg_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Na, baytaan ta kamu sin tuman, hisiyu-siyu in dumihil kaniyu tubig inumun sabab in kamu agad kākuꞌ, sukuꞌ sin Almasi, na tantu tuud tungbasan da siya sin Tuhan pa marayaw.” ");
INSERT INTO tsg_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Laung pa isab hi Īsa, “Na, hisiyu-siyu in makarā magdusa ha manga tau nangangandul kākuꞌ, amu in piyagꞌiyan ku biyaꞌ sapantun bataꞌ-bataꞌ, na marayaw pa in tau yan hilaruk pa giꞌtung tawid iban sin gilingan batu dakulaꞌ hiyuhukut ha liug niya bat siya diꞌ makahinang sin biyaꞌ ha yan. ");
INSERT INTO tsg_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Na, bang sawpama in lima niyu amu in makarā kaniyu magdusa, na, amu in pagbahasahun marayaw pa uturan niyu in lima niyu. Labi pa marayaw pukul in lima niyu bang mayan kamu makasūd surgaꞌ, dayn sin jukup in lima niyu, sagawaꞌ in uwian niyu pa narkaꞌ jahannam, amu in diꞌ tuud magkapūng in kāyu niya. ");
INSERT INTO tsg_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","‘Sangat tuud makalap in kasiksaan didtu, amu in pagꞌiyanun minsan in manga ūd mīmikit ha manga sīsiksaꞌ diꞌ magkamatay iban in kāyu didtu diꞌ tuud magkapūng.’ ");
INSERT INTO tsg_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na, bang sawpama in siki niyu amu in makarā kaniyu magdusa, na amu in pagbahasahun marayaw pa uturan niyu in siki niyu. Labi pa marayaw pukul in siki niyu bang mayan kamu makasūd surgaꞌ, dayn sin jukup in siki niyu, sagawaꞌ harap pa narkaꞌ jahannam in uwian niyu. ");
INSERT INTO tsg_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","‘Sangat tuud makalap in kasiksaan didtu, amu pagꞌiyanun minsan in manga ūd mīmikit ha manga sīsiksaꞌ diꞌ magkamatay iban in kāyu didtu diꞌ tuud magkapūng.’ ");
INSERT INTO tsg_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na, bang sawpama in mata niyu amu in makarā kaniyu magdusa, na amu in pagbahasahun marayaw pa lugitun niyu in mata niyu. Labi pa marayaw hansipak da in mata niyu bang mayan kamu makasūd surgaꞌ, dayn sin jukup in mata niyu, sagawaꞌ harap pa lawm narkaꞌ jahannam in uwian niyu. ");
INSERT INTO tsg_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Sangat tuud makalap in kasiksaan didtu, amu in pagꞌiyanun minsan in ūd mimikit ha manga sīsiksaꞌ diꞌ magkamatay iban in kāyu didtu diꞌ tuud magkapūng.’ ");
INSERT INTO tsg_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Asal,” laung hi Īsa, “in tau katān lumabay kāyu, hāti niya lumabay kabinsanaan biyaꞌ sapantun sin hayup amu in pagkulbanan asinan ampa hilabay ha kāyu. ");
INSERT INTO tsg_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Asal da isab,” laung hi Īsa, “in asin marayaw, (amu in tandaꞌ sin paglillaꞌ sin tau pa Tuhan), sagawaꞌ bang sawpama in asin maīg na in kaasin niya, na, way na dapat paasinun magbalik. Hangkan baytaan ta kamu, patantuha niyu in paglillaꞌ niyu pa Tuhan iban pagsulut-siyuluti kamu.” ");
INSERT INTO tsg_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Manjari minīg na hinda Īsa dayn ha hulaꞌ yaun, ampa sila miyadtu pa hulaꞌ Yahudiya. Dayn didtu isab imuntas sila sin Subaꞌ Jurdan. Na, mataud tuud tau in miyawn nagtipun kan Īsa. Niyasīhatan niya sila biyaꞌ sin asal kabiyaksahan niya paghinangun. ");
INSERT INTO tsg_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Sakali awn manga Parisi miyawn nangasubu pasal sin saraꞌ agama ha supaya nila masaggaw hi Īsa ha bichara. Laung nila kan Īsa, “Bang ha saraꞌ sin agama natuꞌ, makajari ka in usug mamugit ha asawa niya?” ");
INSERT INTO tsg_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","In sambung kanila hi Īsa, iyasubu sila. Laung niya, “Unu in daakan hi Musa kaniyu sin pasal yan?” ");
INSERT INTO tsg_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","In sambung nila, “Tiyugutan hi Musa in usug magpahinang sulat pasa ampa niya hikabugit in asawa niya.” ");
INSERT INTO tsg_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Laung hi Īsa kanila, “In yan bunnal. Sagawaꞌ hangkan kiyasulat hi Musa in daakan yan sabab diꞌ kahinduan in manga kamaasan niyu, biyaꞌ da isab sin tugas sin ū niyu. ");
INSERT INTO tsg_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Sagawaꞌ ha tagnaan sin pagpanjari sin Tuhan ha mānusiyaꞌ, in sila piyapanjari usug iban babai. ");
INSERT INTO tsg_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Hangkan dayn ha sabab yan, mutas in usug dayn ha inaꞌ-amaꞌ niya, ampa siya humambuuk ha asawa niya, ");
INSERT INTO tsg_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ampa in sila duwa matibuuk na. Hangkan bukun na duwa in baran nila sagawaꞌ mahambuuk na in ginhawa-baran nila. ");
INSERT INTO tsg_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Na, hangkan, diꞌ makajari magbutas in manga tau piyapaghambuuk sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Manjari, nakabalik mayan sila pa bāy iyasubu hi Īsa sin manga mulid niya sin parkalaꞌ pasal sin pagbugit. ");
INSERT INTO tsg_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Laung niya kanila, “Hisiyu-siyu in usug mamugit ha asawa niya, ampa siya magꞌasawa dugaing, na in siya yan makalanggal sin saraꞌ magjina iban magdusa siya ha asawa niya puun. ");
INSERT INTO tsg_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Damikkiyan, in babai mamugit ha bana niya ampa siya magbana dugaing, na in hinang niya isab yan nakalanggal na sin saraꞌ magjina.” ");
INSERT INTO tsg_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Manjari, awn manga tau miyawn nagdā manga bataꞌ-bataꞌ kan Īsa bat niya kakaputan kapangayuan anugharaꞌ dayn ha Tuhan. Sagawaꞌ piyagꞌamahan sin manga mulid hi Īsa in manga tau ini. ");
INSERT INTO tsg_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Na, pagkitaꞌ hi Īsa sin hīnang sin manga mulid niya, diyugalan siya. Laung niya, “Pakaria niyu in manga bataꞌ-bataꞌ yan kākuꞌ, iban ayaw niyu sila lānga, sabab in manga tau, amu in mangandul ha Tuhan biyaꞌ sin pangandul sin manga bataꞌ-bataꞌ yan (ha inaꞌ-amaꞌ nila), amu in makaagad sin pamarinta sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Na, ini in mattan hibaytaꞌ ku kaniyu. Hisiyu-siyu in diꞌ magkahagad sin daakan sin pamarinta sin Tuhan biyaꞌ sin pagkahagad sin bataꞌ-bataꞌ (sin daakan sin maas niya), na diꞌ siya makaagad ha lawm pamarintahan sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pagꞌubus iyagbay hi Īsa in manga bataꞌ-bataꞌ ampa niya biyantang in lima niya piyangayuan anugharaꞌ in manga bataꞌ-bataꞌ dayn ha Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Manjari, sūng mayan hinda Īsa manaw, awn tau dimagan mawn dimukuꞌ pa alupan hi Īsa. Laung niya, “Tuwan Guru, in ikaw tau marayaw. Unu in subay hinangun ku bat aku kasukuan sin kabuhiꞌ salama-lama?” ");
INSERT INTO tsg_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","“Maytaꞌ kaw imiyan marayaw aku?” laung hi Īsa. “Wayruun tau marayaw, amura in Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kahagara in manga saraꞌ agama naug dayn kan Musa, amu in asal mu na kaingatan biyaꞌ sin, ‘Ayaw kaw mamunuꞌ, ayaw kaw magjina, ayaw kaw manakaw, ayaw kaw magsaksiꞌ sin puting, ayaw kaw mangulliꞌ sin altaꞌ sin tau, pagꞌaddati in inaꞌ-amaꞌ mu.’” ");
INSERT INTO tsg_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","“Tuwan Guru,” laung sin tau, “iyaagad ku in katān daakan yan dayn sin kabataꞌ-bataꞌ ku pa.” ");
INSERT INTO tsg_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Na, iyatud hi Īsa in tau ini iban limasa siya kaniya. Laung hi Īsa, “Na, awn pa hambuuk kulang sin hinang mu. Kadtu kaw dagangan in katān unu-unu mu ampa pagdihilan in bīhan ha manga miskin ha supaya awn altaꞌ mu didtu ha surgaꞌ. Pagꞌubus, ampa kaw kari agad kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pagdungug sin tau ini sin agi hi Īsa, magtūy napinda in aymuka niya sartaꞌ minīg na siya, susa in lawm atay niya, sabab in siya landuꞌ tuud altaan. ");
INSERT INTO tsg_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Na, limingiꞌ hi Īsa pa manga mulid niya ampa siya namung, laung niya, “Kahunitan tuud in manga tau dayahan magad ha pamarinta sin Tuhan!” ");
INSERT INTO tsg_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Na, nainu-inu tuud in manga mulid hi Īsa sin bichara niya. Sagawaꞌ laung pa isab hi Īsa, “Na, manga kaanakan, mahunit tuud in magad ha pamarinta sin Tuhan! ");
INSERT INTO tsg_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Amu in pagꞌiyanun, kaluhayan pa in untaꞌ lumabay dayn ha buliꞌ jawm dayn sin tau dayahan magad ha pamarinta sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Na, nainu-inu tuud in manga mulid hi Īsa. Laung sin pakaniya-pakaniya, “Na, bang biyaꞌ hādtu in hāti niya wayruun tau malappas.” ");
INSERT INTO tsg_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iyatud sila hi Īsa ampa siya simambung, laung niya, “Asal bang ha pikilan sin mānusiyaꞌ in biyaꞌ ha yan diꞌ tuud marapat mahinang, sagawaꞌ wayruun mahunit ha Tuhan, sabab marapat sin Tuhan hinangun in unu-unu katān.” ");
INSERT INTO tsg_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Na, namung hi Pitrus, laung niya, “Na, biyaꞌ diin in kami ini? Tiyaykuran namuꞌ na in unu-unu katān ampa kami miyagad kaymu.” ");
INSERT INTO tsg_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","In sambung hi Īsa, laung niya, “Baytaan ta kamu sin tuman. Hisiyu-siyu in atas mamīn sin pamāy-bāy niya atawa sin manga taymanghud niya usug-babai, atawa sin inaꞌ-amaꞌ niya, atawa sin manga anak niya atawa sin manga lupaꞌ niya sabab-karnaꞌ sin lasa niya kākuꞌ iban pasal sin pagpamahalayak sin Baytaꞌ Marayaw, ");
INSERT INTO tsg_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","na lipat-manglipat in hitungbas kaniya sin Tuhan ha masa bihaun. Tumaud in hulaan niya, in manga taymanghud niya usug-babai, in inaꞌ niya, in manga anak niya iban manga lupaꞌ niya, iban lumabay da isab siya manga kabinsanaan sabab sin pagꞌagad niya kākuꞌ, iban ha masa susūngun awn kabuhiꞌ niya salama-lama. ");
INSERT INTO tsg_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Malayngkan mataud in tau amu in ha unahan bihaun, ha adlaw mahuli sila in ha ulihan, ampa mataud in tau amu in ha ulihan bihaun, ha adlaw mahuli sila in ha unahan.” ");
INSERT INTO tsg_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Manjari nakaabut na sila pa dān tumukad pa Awrusalam (Baytal Makdis). In hi Īsa miyumuna dayn ha manga mulid niya. In manga mulid niya hiyanggaw iban in manga tau miyamagad ha ulihan nila miyumugaꞌ da isab. Na, tīpun na isab nagbalik hi Īsa in manga hangpuꞌ tagduwa mulid niya mawn pa daig niya, ampa niya biyaytaan sin manga kahālan kumugdan kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Kitaa niyu ba,” laung hi Īsa kanila, “in kitaniyu ini tudju madtu pa Awrusalam (Baytal Makdis). Didtu aku, amu in Anak Mānusiyaꞌ, hiungsud pa lawm lima sin manga nakuraꞌ kaimaman iban manga guru sin saraꞌ agama. Laung nila subay kamatay in hukuman hibutang kākuꞌ. Hiungsud nila aku pa lawm lima sin manga tau bukun bangsa Yahudi amu in namamarinta sin hulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Na, paglikiꞌ-likian aku sin manga tau ini iban luraan nila aku, lapdusan sin lulubak, pagꞌubus ampa nila aku patayun. Sagawaꞌ pagꞌabut hikatū sin adlaw dayn ha kamatay kākuꞌ mabuhiꞌ aku magbalik.” ");
INSERT INTO tsg_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sakali miyawn kan Īsa hi Yaꞌkub kay Yahiya, amu in manga anak hi Sibidi. Laung nila, “Tuwan, awn kabayaan namuꞌ pangayuun kaymu.” ");
INSERT INTO tsg_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Unu in kabayaan niyu pangayuun kākuꞌ?” laung hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","In sambung nila, “Bang dumatung na in waktu ikaw na in limingkud mamarinta ha manga mānusiyaꞌ, in kabayaan namuꞌ palingkurun mu kami ha daig mu, in hambuuk ha dapit pa tuu mu, hāti in hambuuk dapit pa lawa mu.” ");
INSERT INTO tsg_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Laung hi Īsa kanila, “Diꞌ niyu kaingatan bang unu in piyapangayuꞌ niyu yan. Ha pikil niyu, makasandal kamu minum sin luun sin sawan, amu in subay inumun ku? Iban mangaku ka kamu mapatay biyaꞌ sin pagpatay kākuꞌ?” ");
INSERT INTO tsg_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Huun, makasandal kami,” in sambung nila. Laung hi Īsa kanila, “Na, tantu, minum kamu sin luun sin sawan inumun ku, iban mangaku kamu mapatay biyaꞌ sin pagpatay kākuꞌ, ");
INSERT INTO tsg_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","sumagawaꞌ wayruun kapatut ku magpīꞌ bang hisiyu in lumingkud ha dapit pa tuu iban pa lawa ku, sabab in manga yan tiyatagama sin Tuhan, amu in magbayaꞌ dumihil ha manga kiyasukuan niya.” ");
INSERT INTO tsg_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Na, pagdungug sin kaibanan hangpuꞌ mulid hi Īsa sin piyangayuꞌ hi Yaꞌkub kay Yahiya, diyugalan sila. ");
INSERT INTO tsg_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Hangkan tiyawag sila katān hi Īsa pakawnun kaniya, ampa siya namung kanila, laung niya, “Kaingatan niyu in addat sin manga tau amu in tiyaymaꞌ sin manga tau bukun bangsa Yahudi mamarinta kanila dī ha dunya, matagi sila magkawasa ha manga tau iban in manga tau mataas in kawasa amuna in magbayaꞌ-bayaꞌ sin hinangun nila ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Sagawaꞌ in kamu dugaing in hinang niyu dayn kanila. Bang awn dayn kaniyu in mabayaꞌ tumaas, subay siya maghulas-sangsaꞌ ha kaibanan niya. ");
INSERT INTO tsg_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Iban bang awn kaniyu in mabayaꞌ tumaas tuud dayn ha katān, na subay siya magtagꞌīpun ha katān. ");
INSERT INTO tsg_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Karnaꞌ, minsan in aku, amu in Anak Mānusiyaꞌ, miyari pa dunya bukun ha supaya paghulas-sangsaan sin manga tau, sagawaꞌ aku in naghulas-sangsaꞌ kanila. Miyari aku lumillaꞌ sin duguꞌ-nyawa ku, amu in hipanglukat ha manga tau mataud dayn ha manga dusa nila.” ");
INSERT INTO tsg_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Manjari, nākawn hinda Īsa iban sin manga mulid niya pa dāira Ariha. Ha sūng na hi Īsa gumuwaꞌ dayn ha dāira iban sin manga mulid niya iban sin manga tau mataud, awn duun hambuuk tau buta naglilingkud ha higad dān nanglilimus. In ngān niya hi Bartimiyus amu in anak hi Timiyus. ");
INSERT INTO tsg_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pagdungug niya sin yaun hi Īsa, amu in tau Nasarit, magtūy siya magsuwara matanug, laung niya, “Anduꞌ Īsa, hambuuk panubuꞌ hi Daud, kaulungi aku!” ");
INSERT INTO tsg_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sakali piyagꞌamahan siya sin manga tau mataud iban īyan siya diꞌ papaghibukun. Sagawaꞌ gām mayan piyatanug niya tuud in pagsuwara niya. Laung niya, “Anduꞌ, hambuuk panubuꞌ hi Daud, kaulungi aku!” ");
INSERT INTO tsg_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sakali himundung hi Īsa, laung niya, “Tawaga niyu pakaria.” Na, tiyawag nila na in tau buta. Laung sin tau nagtawag, “Ayaw na kaw masusa. Tindug na kaw, yari kaw piyatawag hi Īsa.” ");
INSERT INTO tsg_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Na, magtūy niya kiyatiluꞌ in siub niya ampa siya limungkahad miyadtu kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","“Unu in kabayaan mu hitabang ku kaymu?” laung hi Īsa kaniya. “Tuwan Guru,” laung sin tau buta, “in kabayaan ku makakitaꞌ aku magbalik.” ");
INSERT INTO tsg_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Na, makajari na kaw muwiꞌ,” laung hi Īsa. “Dayn ha sabab sin parachaya iban pangandul mu in ikaw kiyaulian na.” Saruun-duun magtūy nakakitaꞌ in tau buta iban miyagad na siya imurul kanda Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Manjari, masuuk mayan hinda Īsa pa Awrusalam (Baytal Makdis) kītaꞌ nila na in lūngan Bitpaji iban Bitani duun ha Būd Jaytun. Na, diyaak hi Īsa in duwa mulid niya paunahun dayn kanila. ");
INSERT INTO tsg_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Laung niya ha duwa mulid niya, “Kadtu kamu pa lūngan amu in sūngun niyu yaun. Pagdatung niyu na mayan madtu magtūy kamu makabāk hambuuk kuraꞌ hiyuhukutan, mabataꞌ pa, amu in walaꞌ pa tuud kiyapanguraan. Hubari niyu ampa niyu dāha mari. ");
INSERT INTO tsg_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Bang awn mangasubu kaniyu bang maytaꞌ niyu kiyawaꞌ in kuraꞌ, baytai niyu kagunahan sin Panghuꞌ iban baytai niyu sin hiuliꞌ da magtūy.” ");
INSERT INTO tsg_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Na, miyadtu na in duwa mulid niya. Pagdatung nila, kītaꞌ nila na in kuraꞌ hiyuhukut ha lawang bāy ha dān paglalabayan. Na, magtūy nila kiyadtu hiyubaran. ");
INSERT INTO tsg_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ha saꞌbu nila naghuhubad, iyasubu sila sin manga kaibanan tau nagtitindug duun, laung nila, “Maytaꞌ niyu hiyubaran in kuraꞌ yan?” ");
INSERT INTO tsg_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Siyambungan nila biyaꞌ sin agi hi Īsa kanila. Hangkan piyasāran na sila sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Na diyā nila na madtu kan Īsa in kuraꞌ. Liyampikan nila in kuraꞌ sin juba nila ampa simakat nanguraꞌ hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Hīklad isab sin manga tau mataud in manga juba nila ha dān. Hāti in kaibanan tau nanuꞌtuꞌ manga sanga dahunan dayn ha kabbun, ampa nila kiyanat ha dān labayan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Na, in manga tau nagpapanaw ha unahan iban ha ulihan hi Īsa nagꞌulang nagsama-sama. Laung nila, “Pudjihun natuꞌ siya! Bang mayan barakatan in siya, amu in kiyawakilan sin Tuhan! ");
INSERT INTO tsg_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bang mayan barakatan sin Tuhan in pamarinta sūng niya patindugun amu in biyaꞌ pamarinta sin nanubuꞌ kātuꞌniyu, hi Sultan Daud! Pudjihun natuꞌ in Tuhan didtu ha surgaꞌ, amu in mataas dayn ha katān!” ");
INSERT INTO tsg_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Na, pagdatung hi Īsa pa Awrusalam (Baytal Makdis), miyadtu siya pa lawm Bāy sin Tuhan ampa niya līling in unu-unu katān ha lawm. Na, pagga sin himapun na tuud, miyadtu na siya pa Bitani iban sin hangpuꞌ tagduwa mulid niya. ");
INSERT INTO tsg_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pagꞌadlaw hambuuk, ha saꞌbu nila miyamanaw harap pa Awrusalam (Baytal Makdis), dayn ha Bitani, nakananam hapdiꞌ hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Sakali awn kītaꞌ niya dayn ha kalayuan kahuy tina hipuꞌ sin dahun. Na, kiyadtu niya kītaꞌ bang awn bunga. Sagawaꞌ pagkadtu wayruun bunga kiyabaakan niya luwal da manga dahun, sabab bukun pa musim hipagbubunga sin kahuy tina. ");
INSERT INTO tsg_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Laung hi Īsa ha kahuy tina, “Tagnaan dayn ha adlaw ini diꞌ na tuud kaw magbunga magbalik.” Na, diyungug sin manga mulid hi Īsa in bichara niya. ");
INSERT INTO tsg_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Manjari dimatung mayan sila pa Awrusalam (Baytal Makdis), miyadtu hi Īsa simūd pa halaman Bāy sin Tuhan, ampa niya diyūy pa guwaꞌ in manga tau katān mamī-mī iban magdaragang ha lawm sin Bāy sin Tuhan. Biyalintuwad niya in manga lamisahan sin manga tau magsasambiꞌ sīn sin sīn dayn ha dugaing hulaꞌ, iban sin lingkuran sin manga tau magdaragang assang. ");
INSERT INTO tsg_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Walaꞌ niya isab diyūlan minsan hisiyu in magdā sin kapanyapan nila lumabay dayn ha lawm Bāy sin Tuhan. Liyāngan niya katān. ");
INSERT INTO tsg_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pagꞌubus ampa niya niyasīhatan in manga tau. Laung niya, “Kiyasulat ha lawm Kitab sin nagparman in Tuhan, amu agi, ‘In bāy ku subay ngānan bāy pagtataatan sin katān kabangsahan!’ Sagawaꞌ,” laung hi Īsa, “hīnang niyu in Bāy sin Tuhan lugal pagꞌaanyayahan sin sīn sin manga tau!” ");
INSERT INTO tsg_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na, sakali diyungug sin manga nakuraꞌ kaimaman iban sin manga guru sin saraꞌ agama in bichara hi Īsa. Miyugaꞌ sila sabab in manga tau mataud nahaylan katān iban kiyaamuhan sin nasīhat hi Īsa. Hangkan limawag sila sin dān hikapatay nila kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Sakali naabut mayan magalib minīg na hi Īsa iban sin manga mulid niya dayn ha dāira Awrusalam (Baytal Makdis). ");
INSERT INTO tsg_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na, pagꞌadlaw hambuuk, subu-subu pa, ha saꞌbu hinda Īsa miyamanaw ha dān, kītaꞌ nila in kahuy tina nanglanus na sampay pa gamut niya. ");
INSERT INTO tsg_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Sakali kiyatumtuman hi Pitrus in pasal sin kahuy tina. Hangkan, laung niya kan Īsa, “Uy, Tuwan, kitaa ba in kahuy tina bakas mu siyuknaan, nanglanus na!” ");
INSERT INTO tsg_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","In sambung hi Īsa, “Pagparachaya kamu iban pangandul kamu ha Tuhan, ");
INSERT INTO tsg_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","sabab ini in mattan hibaytaꞌ ku kaniyu. Bang awn tau hisiyu-siyu na, imiyan ha būd ini, ‘Īg kaw dayn ha biyutangan mu, ampa kaw laksu pa lawm dagat,’ na bang diꞌ magduwa-ruwa in lawm atay niya iban magparachaya tuud siya sin maagad in bichara niya, na tantu maagad in kabayaan niya. ");
INSERT INTO tsg_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Hangkan, baytaan ta kamu, bang kamu mangarap pa Tuhan ampa awn pangayuun niyu unu-unu na, pagparachaya kamu sin makawaꞌ niyu in piyangayuꞌ niyu, ampa kamu karihilan sin unu-unu na piyangayuꞌ niyu. ");
INSERT INTO tsg_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na, bang kamu mangarap pa Tuhan ampa sumaīgpat pa atay niyu in narusa kaniyu sin pagkahi niyu, maapa niyu siya minsan unu in dusa niya bat isab ampunun in manga dusa niyu sin Tuhan, amu in Amaꞌ natuꞌ ha surgaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Bang niyu diꞌ maapun in tau nakarusa kaniyu, diꞌ isab ampunun in manga dusa niyu sin Tuhan, amu in Amaꞌ natuꞌ ha surgaꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Manjari, dimatung na sila nagbalik pa Awrusalam (Baytal Makdis). Ha saꞌbu hi Īsa nagpapanaw ha lawm sin Bāy sin Tuhan, miyawn kan Īsa nangasubu in manga nakuraꞌ kaimaman, in manga guru sin saraꞌ agama iban sin manga nagtatau-maas ha hulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Laung nila kan Īsa, “Unu taꞌ in kawasa mu maghinang sin manga hinang mu yan dī ha lawm Bāy Pagtataatan ini? Hisiyu in nagdihil kaymu sin kawasa maghinang sin manga hīnang mu yan?” ");
INSERT INTO tsg_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","In sambung hi Īsa kanila, “Awn ini hambuuk hipangasubu ku kaniyu. Bang niyu aku kasambungan sin tuman, na, baytaan ta kamu isab bang dayn ha unu ku nakawaꞌ in kawasa ku maghinang sin manga hinang ku yan. ");
INSERT INTO tsg_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Baytai niyu aku, dayn hāin nakawaꞌ hi Yahiya in kawasa niya mangliguꞌ ha manga tau, dayn ha Tuhan atawa dayn ha mānusiyaꞌ?” ");
INSERT INTO tsg_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Na, nagꞌisun-isun na sila bang unu in hisambung nila. Laung nila, “Na, unu in hisambung natuꞌ kaniya? Bang kitaniyu imiyan in kawasa hi Yahiya dayn ha Tuhan, na iyanun niya kitaniyu, laung niya, ‘Na, maytaꞌ kamu walaꞌ nagparachaya kan Yahiya?’ ");
INSERT INTO tsg_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Sagawaꞌ bang isab kitaniyu imiyan dayn ha mānusiyaꞌ in kawasa niya, na piligru kitaniyu.” (Mabugaꞌ sila maghiluhalaꞌ in manga tau sabab in manga tau katān nagkahagad tuud sin in hi Yahiya hambuuk tuud nabi.) ");
INSERT INTO tsg_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hangkan, in sambung nila kan Īsa, “Inday, diꞌ namuꞌ kaingatan bang dayn diin niya nakawaꞌ in kawasa niya.” Na, laung isab hi Īsa kanila, “Na, bang biyaꞌ hādtu, diꞌ ta da isab kamu baytaan bang dayn hāin ku nakawaꞌ in kawasa ku huminang sin manga hīnang ku yan.” ");
INSERT INTO tsg_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Manjari, nagnasīhat hi Īsa kanila. Diyalil niya kaagi in pagnasīhat niya. Laung hi Īsa, “Awn hambuuk tau nagtanum anggul ha kabbun niya. Iyād niya in katilibut sin kabbun niya, ampa siya naglungag dakulaꞌ, hīnang lugal pagpupugaan sin manga bunga anggul. Iban naghinang isab siya bāy-bāy mataas in hāg niya, amu in pamantawan sin magꞌiipat sin kabbun niya. Pagꞌubus yadtu ampa niya piyatungguan in kabbun anggul niya ha manga magtutungguꞌ kabbun ampa siya timulak pa hulaꞌ dugaing. ");
INSERT INTO tsg_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Manjari, naabut mayan in musim sin pagpusuꞌ sin manga anggul, diyaak sin tagdapu kabbun in hambuuk daraakun niya madtu pa manga nagtungguꞌ sin kabbun niya, kumawaꞌ sin manga bunga anggul bahagiꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Sagawaꞌ siyaggaw ampa bīnasa sin manga tungguꞌ in daraakun niya ubus ampa piyauwiꞌ ha wayruun unu-unu narā niya. ");
INSERT INTO tsg_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Sakali piyakadtu nagbalik sin tagkabbun in hambuuk na isab daraakun niya pa manga tungguꞌ sin kabbun. Sagawaꞌ kiyakal ha ū sin manga tungguꞌ in daraakun niya ampa sīpug-sipug. ");
INSERT INTO tsg_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Na, piyakadtu na isab nagbalik sin tagkabbun in dugaing daraakun niya, saꞌ walaꞌ da nagkahagad in manga tungguꞌ. Gām mayan piyatay nila in daraakun niya. Biyaꞌ ha yan da isab in hīnang nila ha manga kaibanan daraakun piyakadtu kanila sin tagkabbun. In kaibanan bīnasa nila, in kaibanan piyatay nila. ");
INSERT INTO tsg_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Na, awn pa isab hambuuk nakapin maraak sin tagkabbun, amu in hambuuk-buuk anak niya usug kalasahan. Siya in kahinapusan piyakadtu sin tagkabbun pa manga tungguꞌ sin kabbun. Laung niya ha lawm atay niya, ‘Tantu pagꞌaddatan nila in anak ku.’ ");
INSERT INTO tsg_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pagkitaꞌ sin manga tungguꞌ ha anak sin tagkabbun, magtūy sila nagꞌisun. Laung nila, ‘Yan na in anak sin tagkabbun, amu in kiyapusakaan sin kabbun ini. Kari kamu, patayun natuꞌ siya bat natuꞌ makawaꞌ in kabbun pusakaꞌ kaniya!’ ");
INSERT INTO tsg_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Na, siyaggaw nila in anak sin tagdapu ampa nila piyatay. Pagꞌubus ampa nila liyaruk in bangkay pa guwaꞌ ād sin kabbun anggul. ");
INSERT INTO tsg_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Na,” laung hi Īsa, “pikil niyu, unu in hinangun sin tagkabbun ha manga tungguꞌ sin kabbun? Na, kadtuun niya in manga tungguꞌ ampa niya patayun. Pagꞌubus ampa niya patungguan in kabbun anggul niya ha manga dugaing tungguꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Na, tantu,” laung hi Īsa, “nabacha niyu in ayat ini ha lawm Kitab, amu agi, ‘In batu biyugit sin manga maghihinang bāy, (sabab in pangannal nila way guna) amura tuud isab in batu nanjari piyagpapagun sin bāy. ");
INSERT INTO tsg_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Hīnang yan sin Tuhan, iban makahaylan tuud kātuꞌniyu.’” ");
INSERT INTO tsg_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Na, ambayaꞌ saggawun sin manga nakuraꞌ Yahudi hi Īsa, sabab kiyahātihan nila sin sila in kiyugdan sin isturi diyalil hi Īsa. Sagawaꞌ walaꞌ nila nahinang, sabab mabugaꞌ sila maghiluhalaꞌ in manga tau mataud. Hangkan, minīg na sadja sila. ");
INSERT INTO tsg_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Sakali awn manga Parisi iban manga tau agad ha palti hi Hirud in naraak nila madtu kan Īsa lumawag singgit bat nila masaggaw hi Īsa ha bichara. ");
INSERT INTO tsg_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nākawn mayan sila kan Īsa, laung nila, “Tuwan, kaingatan namuꞌ in ikaw mabuntul iban kasabunnalan sadja in bichara mu. Diꞌ kaw masusa minsan unu in pikilan sin manga tau pasal sin bichara mu sabab diꞌ kaw magpīꞌ tau minsan unu in kawasa niya. Nanghihinduꞌ kaw sin manga addat iban kawl-piil amu in kabayaan sin Tuhan pakayun sin manga mānusiyaꞌ. Na, awn hambuuk hipangasubu namuꞌ kaymu. Langgal saraꞌ ka sin saraꞌ agama in magbayad sayrulla pa Sultan sin hulaꞌ Rūm, amu in namamarinta kātuꞌniyu, atawa bukun. Subay ka kitaniyu magbayad atawa diꞌ?” ");
INSERT INTO tsg_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sagawaꞌ kaingatan hi Īsa in katitipuhan sin lawm atay nila. Na, laung niya kanila, “Maytaꞌ niyu aku sulayan saggawun ha bichara? Karii niyu aku hambuuk pisita, ampa ku lilingun.” ");
INSERT INTO tsg_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Na, pagdā nila sin pisita mawn kan Īsa, iyasubu sila hi Īsa, laung niya, “Kansiyu in pattaꞌ iban ngān ha pisita ini?” “Ha Sultan sin hulaꞌ Rūm,” in sambung nila. ");
INSERT INTO tsg_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","“Na,” laung hi Īsa, “pagga biyaꞌ ha yan, unu in sukuꞌ sin Sultan sin hulaꞌ Rūm, subay hiungsud kaniya. Damikkiyan, unu in sukuꞌ sin Tuhan subay hiungsud pa Tuhan.” Na, nainu-inu tuud sila sin sambung hi Īsa kanila. ");
INSERT INTO tsg_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sakali awn manga Yahudi pagngānan Sadduki in miyawn kan Īsa. In manga tau ini imiyan sin in manga patay diꞌ na mabuhiꞌ magbalik ha adlaw mahuli. ");
INSERT INTO tsg_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Nangasubu sila kan Īsa, laung nila, “Tuwan Guru, kiyasulat hi Musa ha lawm saraꞌ agama natuꞌ, amu agi, ‘Bang awn usug matay ampa wayruun anak niya ha asawa niya, na subay asawahun sin taymanghud niya in balu, bat supaya awn tubuꞌ amu in dumā sin ngān sin miyatay.’ ");
INSERT INTO tsg_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Na, bakas awn pitu magtaymanghud usug. Manjari nagꞌasawa in kamagulangan. Sakali miyatay sadja siya walaꞌ nakabāk anak ha asawa niya. ");
INSERT INTO tsg_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Na, iyasawa sin taymanghud niya, amu in sumunuꞌ kaniya in balu. Sagawaꞌ miyatay sadja in taymanghud niya walaꞌ da isab nakabāk anak ha balu niya. Damikkiyan, in sumunud kaniya nabiyaꞌ hādtu da isab. ");
INSERT INTO tsg_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Na, in hawpuꞌ niya, in babai yadtu naasawa sin pitu magtaymanghud iban miyatay sadja sila katān walaꞌ nakabāk anak. Na, ha katapusan miyatay da isab in babai. ");
INSERT INTO tsg_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na, bang dumatung na in waktu mabuhiꞌ na magbalik in manga patay, hisiyu in tagꞌasawa ha babai yadtu? Karnaꞌ naasawa siya sin kapitu magtaymanghud?” ");
INSERT INTO tsg_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Laung hi Īsa kanila, “Nasāꞌ tuud kamu! Kaingatan niyu bang maytaꞌ kamu nasāꞌ? Sabab diꞌ niyu kaingatan bang unu in kiyasulat ha lawm Kitab iban diꞌ niyu kaingatan in kusug sin kawasa sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Karnaꞌ bang in manga patay mabuhiꞌ na magbalik, in sila mabiyaꞌ na sin manga malāikat ha surgaꞌ. Iban in usug iban babai diꞌ na magtiyaun. ");
INSERT INTO tsg_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Na, ha pasal isab sin manga patay mabuhiꞌ magbalik ha adlaw mahuli. Maytaꞌ, walaꞌ niyu ka nabacha ha lawm Kitab Tawrat in pasal hi Musa iban sin puun kahuy nalalaga? Tantu nabacha niyu na! Didtu hādtu diyungug hi Musa in suwara sin Tuhan mawn kaniya, amu agi, ‘Aku in Tuhan hi Ibrahim, iban aku in Tuhan hi Isahak iban aku da isab in Tuhan hi Yaꞌkub.’ ");
INSERT INTO tsg_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Na,” laung hi Īsa, “In Tuhan amu in piyagtutuhanan sin manga buhiꞌ bukun sin manga patay. Hangkan, nasāꞌ tuud in pikilan iban panghinduꞌ niyu sin manga patay diꞌ na mabuhiꞌ magbalik!” ");
INSERT INTO tsg_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Sakali awn hambuuk guru sin saraꞌ agama in duun nakarungug sin piyaglugatan nila. Napikil niya marayaw in kiyasambung hi Īsa ha manga Sadduki. Hangkan, miyawn siya nangasubu kan Īsa. Laung niya, “Tuwan, unu in umbulsatu tuud daakan sin Tuhan?” ");
INSERT INTO tsg_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Laung hi Īsa, “In umbulsatu tuud daakan sin Tuhan, amu ini, ‘In kamu manga tau Israil, dungug kamu! In Tuhan natuꞌ, amura in hambuuk-buuk Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Wajib puspusun niyu in lasa niyu ha Tuhan, Panghuꞌ niyu, labi dayn ha unu-unu katān ha lawm atay niyu ha kabuhiꞌ niyu, iban ha lawm pikilan niyu. Subay in lasa niyu kaniya labi ha atay iban pikilan niyu, iban diꞌ niyu hipagꞌūg kaniya in hulas-sangsaꞌ niyu.’ ");
INSERT INTO tsg_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","In hikaruwa umbulsatu daakan amu ini: ‘Subay in lasa niyu ha pagkahi niyu mānusiyaꞌ biyaꞌ sin lasa niyu ha baran niyu.’ Wayruun na dugaing daakan sin Tuhan in lumabi pa dayn ha duwa yan.” ");
INSERT INTO tsg_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Na, laung sin guru sin saraꞌ agama kan Īsa, “Marayaw iban bunnal tuud in bichara mu yan, Tuwan! Biyaꞌ na sin agi mu, hambuuk-buuk da in Tuhan, in Panghuꞌ taniyu iban wayruun na dugaing dayn kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Iban subay puspusun sin tau in lasa niya ha Tuhan. Subay in lasa niya ha Tuhan labi ha atay iban pikilan niya iban diꞌ niya hipagꞌūg in hulas-sangsaꞌ niya ha Tuhan. Iban subay kalasahan sin tau in pagkahi niya mānusiyaꞌ biyaꞌ sin lasa niya ha baran niya. Tantu māyuꞌ marayaw in magkahagad huminang sin duwa daakan yan, dayn sin dumihil hayup sunugun pagkulbanan atawa unu-unu na pa Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Na, ha kītaꞌ hi Īsa malawm in panaliꞌ sin guru sin saraꞌ agama sabab marayaw tuud in sambung niya. Hangkan, laung niya kaniya, “Hangkatiyuꞌ dakuman makaagad na kaw ha pamarinta sin Tuhan.” Na, pagpuas dayn duun, way na tau in timawakkal mangasubu kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Na, ha saꞌbu hi Īsa nagnanasīhat duun ha Bāy sin Tuhan nangasubu siya, laung niya, “Biyaꞌ diin kaagi in bichara sin manga guru sin saraꞌ agama sin in Almasi hambuuk panubuꞌ sadja hi Daud? ");
INSERT INTO tsg_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Karnaꞌ ha waktu hiyūp hi Daud sin Rū sin Tuhan nakapamung siya laung niya, ‘Namung in Tuhan ha Panghuꞌ ku, amu agi, “Lingkud kaw dī ha dapit pa tuu ku, sampay ku mapabutang ha babaan mu in katān simusulang kaymu.”’ ” ");
INSERT INTO tsg_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Na,” laung hi Īsa, “in pagtāg hi Daud ha Almasi, ‘Panghuꞌ’. Na, maytaꞌ siya tiyawag, ‘Panghuꞌ’, bang siya hambuuk sadja panubuꞌ hi Daud?” Na, kiyūgan tuud in manga tau mataud yaun nakarungug sin nasīhat hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Na, ha saꞌbu hi Īsa nagnanasīhat, imiyan siya, laung niya, “Halliꞌ kamu dayn ha manga guru sin saraꞌ agama, amu in matagi maglunsul pawyu-pawyu iban sin pagjuba nila mahabaꞌ, iban amu in mabayaꞌ tuud salamun sin manga tau ha mayran bat mapakitaꞌ in pagꞌaddat kanila. ");
INSERT INTO tsg_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Iban bang sila pa langgal lumingkud sila ha lingkuran amu in manga lilingkuran ha unahan tiyatawꞌ ha manga tau mataas. Damikkiyan da ha pagjamuhan lumingkud sila ha lilingkuran tiyatawꞌ ha tau balkanan. ");
INSERT INTO tsg_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Anyayahun nila in manga bāy sin manga balu babai, ubus ampa sila magpahabaꞌ sin pagpangarap nila pa Tuhan, hipagpakitaꞌ-kitaꞌ ha manga tau, ha supaya in manga tau magpikil sin in sila tau marayaw. Na, tantu murkaꞌ dakulaꞌ in dumatung kanila yan.” ");
INSERT INTO tsg_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sakali ha saꞌbu hi Īsa duun naglilingkud ha Bāy sin Tuhan masuuk pa lugal paghuhulugan sin sīn hirihil sin tau, kīkitaꞌ niya in manga tau naghuhulug sin sīn. Mataud sīn in hiyulug sin manga tau dayahan iban mataud tau dayahan in naghulug sīn. ");
INSERT INTO tsg_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sakali awn kītaꞌ hi Īsa hambuuk babai balu miskin in miyawn naghulug sīn. In hiyulug niya duwa pisita tumbaga hargaꞌ hambuuk sīn. ");
INSERT INTO tsg_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Na, magtūy tiyawag hi Īsa in manga mulid niya. Laung niya kanila, “Na, baytaan ta kamu, in balu miskin yaun mataud pa in sīn hiyulug niya dayn sin kiyahulug sin manga tau katān yaun. ");
INSERT INTO tsg_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sabab in manga kaibanan tau, in sīn hiyulug nila diꞌ nila na kagunahan tuud. Sagawaꞌ in babai balu yan minsan siya miskin tuud, hiyulug niya in sīn niya katān minsan amu dakuman in hipamī niya kakaun.” ");
INSERT INTO tsg_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Manjari, pagguwaꞌ hinda Īsa dayn ha Bāy sin Tuhan, laung sin hambuuk mulid niya, “Kitaa ba, Tuwan, in manga batu ini hīnang bāy, way lumagguꞌ! Iban in katān kaginisan sin manga bāy ini, way dumayaw in kahinang!” ");
INSERT INTO tsg_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","In sambung hi Īsa, “Bihaun, kakitaan niyu in dayaw kahinang sin Bāy sin Tuhan yan, sagawaꞌ dumatung da in waktu in Bāy yan magkalubu-lubu iban wayruun tuud makapin batu nagbabangkat-bangkat, sagawaꞌ mapantay yan maligad katān.” ");
INSERT INTO tsg_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Manjari, ha saꞌbu hi Īsa duun naglilingkud ha Būd Jaytun ha tampal pa Bāy sin Tuhan, miyawn kaniya hi Pitrus, hi Yaꞌkub, hi Yahiya iban hi Andariyas nangasubu ha wayruun tau dugaing nakarungug kanila. ");
INSERT INTO tsg_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Laung nila, “Tuwan, baytai kami bang kuꞌnu maawn in biyaytaꞌ mu kāmuꞌ kāina pasal sin Bāy sin Tuhan iban baytai kami bang unu in manga tandaꞌ gumuwaꞌ amu in magpakitaꞌ sin dumatung na in waktu maawn in manga katān parakalaꞌ piyagbaytaꞌ mu kāmuꞌ”. ");
INSERT INTO tsg_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Laung hi Īsa kanila, “Halliꞌ kamu bat supaya wayruun tau makaakkal kaniyu. ");
INSERT INTO tsg_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sabab ha susūngun mataud tau in mari mag-ngān sin ngān ku mangakkal kaniyu. In pakaniya-pakaniya kanila umiyan siya na in Almasi, hangkan mataud tau in kaakkalan nila. ");
INSERT INTO tsg_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Iban bang niyu karungugan in pagbunuꞌ atawa manga habal sin pagbunuꞌ ha dugaing hulaꞌ, ayaw kamu mabugaꞌ. In manga yan asal subay maawn, sagawaꞌ bukun pa yan in waktu kahinapusan sin masa dī ha dunya. ");
INSERT INTO tsg_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","In manga kabangsa-bangsahan magbunuꞌ-biyunui iban magkuntara in manga parinta sin kahulaꞌ-hulaan. Maawn in linug iban gutum ha manga kahulaꞌ-hulaan. In manga yan panagnaan sadja sin kasigpitan iban kabinsanaan nanamun sin manga mānusiyaꞌ. Biyaꞌ yan sapantun sin sakit tagnaꞌ kananaman sin hambuuk babai sūng na magꞌanak. ");
INSERT INTO tsg_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“In kamu yan subay majaga, sabab ha waktu susūngun awn manga tau sumaggaw kaniyu ampa kamu hiungsud pa lawm lima sin manga manghuhukum. Pagꞌubus, lubakan kamu ha lawm manga langgal. Tumindug kamu isab mamayhuꞌ ha manga gubnul iban ha manga sultan ha supaya hukumun sabab in kamu agad kākuꞌ. Na bang kamu marā na madtu, kabaytaan niyu na sila sin Baytaꞌ Marayaw pasal sin pamarinta sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","In Baytaꞌ Marayaw subay hipamahalayak naa muna pa mānusiyaꞌ katān ampa dumatung in kahinapusan sin masa dī ha dunya. ");
INSERT INTO tsg_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Na,” laung hi Īsa, “Ha kuꞌnu-kuꞌnu waktu masaggaw iban marā kamu pa paghukuman, ayaw na kamu magsusa bang unu in hibichara niyu kanila. Unu-unu na in makapasimud niyu manga lapal-kabtangan hirihil sin Tuhan kaniyu, amuna in hibichara niyu, sabab in bichara yan bukun dayn kaniyu, sagawaꞌ dayn ha Rū sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ha waktu susūngun maggaus na in magtalianak. Hitukbal sin tau in taymanghud niya hipapatay iban hitukbal da isab sin amaꞌ in anak niya hipapatay, iban umatu na in anak ha maas nila iban hipapatay nila in maas nila. ");
INSERT INTO tsg_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Na, in kamu karugalan na sin tau katān sabab in kamu agad kākuꞌ. Sagawaꞌ hisiyu-siyu in sumandal sin manga kasigpitan iban kabinsanaan yan sampay pa kahinapusan, tantu malappas da siya.” ");
INSERT INTO tsg_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Na, ha susūngun kakitaan niyu da in satruꞌ sin Tuhan duun makabutang ha lugal bukun mapatut pagbutangan.” (Pahāti ha manga magbabacha: hātiha niyu in maana niya yan!) “Na, bang niyu yan kakitaan na, in manga tau ha hulaꞌ Yahudiya subay maguy na pa kabūran. ");
INSERT INTO tsg_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Hāti hisiyu-siyu in tau kasaꞌbuhan duun ha guwaꞌ bāy niya, subay siya diꞌ na sumūd pa lawm bāy kumawaꞌ sin unu-unu marā niya. ");
INSERT INTO tsg_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Iban hisiyu-siyu in tau kasaꞌbuhan duun ha uma, subay siya magꞌūs-ꞌūs na maguy. Subay siya diꞌ na magbalik kumawaꞌ sin juba niya pa lugal piyagbutangan niya. ");
INSERT INTO tsg_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Na landuꞌ tuud makaluuy in manga burus iban sin manga babai taga anak sibiꞌ-sibiꞌ amu in nagdururuꞌ pa bang dumatung na in kabinsanaan yan! ");
INSERT INTO tsg_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pangayuꞌ kamu duwaa pa Tuhan, bang mayan in kabinsanaan dumatung yan diꞌ kumugdan ha waktu mangīꞌ in hulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Karnaꞌ in kabinsanaan dumatung yan sangat tuud makalap dayn ha katān kabinsanaan bakas kiyalabayan sin manga mānusiyaꞌ, dayn ha tagnaꞌ kapapanjari sin Tuhan sin dunya sampay pa waktu bihaun ini. Iban wayruun na kabinsanaan makasibuꞌ ha yan. ");
INSERT INTO tsg_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Na, bang lumugay in kabinsanaan yan, in mānusiyaꞌ katān mapatay. Sagawaꞌ dayn ha sabab sin luuy sin Tuhan ha manga tau napīꞌ niya sukuꞌ, in kabinsanaan dumatung yan diꞌ niya palugayun. ");
INSERT INTO tsg_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Lāgiꞌ, ha waktu da isab yan,” laung hi Īsa, “bang awn imiyan kaniyu, ‘Huy! kitaa niyu ba, yari na in Almasi,’ atawa, ‘Huy! kitaa niyu ba, yadtu siya didtu!’, ayaw kamu magkahagad. ");
INSERT INTO tsg_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Karnaꞌ ha waktu yan awn manga tau gumuwaꞌ amu in umiyan pakaniya-pakaniya sin siya na in Almasi iban in kaibanan umiyan sin in sila manga nabi daak sin Tuhan. Huminang sila sin manga muꞌjijat iban sin manga hinang makainu-inu ha supaya bang awn dapat minsan in manga tau napīꞌ sin Tuhan sukuꞌ niya marā sin lidjal. ");
INSERT INTO tsg_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Hangkan halliꞌ kamu! Biyaytaan ta na kamu asal sin manga pasal yan ha walaꞌ pa dimatung. ");
INSERT INTO tsg_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Lāgiꞌ ha waktu susūngun da isab yan,” laung hi Īsa, “pagpuas sin manga kabinsanaan dumatung, ‘manigidlum na in suga iban diꞌ na sumawa in bulan. ");
INSERT INTO tsg_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","In manga bituun mahulug na dayn ha langit iban majugjug na in unu-unu katān ha taas langit.’ ");
INSERT INTO tsg_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Pagpuas yan, in aku amu in Anak Mānusiyaꞌ, magbalik na mari pa dunya miyamagad ha kagabunan. Kakitaan sin manga tau in kusug sin kawasa ku iban sin sahaya iban kalagguan ku. ");
INSERT INTO tsg_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pagꞌubus daakun ku in manga malāikat pa upat pidju sin ālam, kumawaꞌ sin manga tau napīꞌ ku sukuꞌ ha katilibut sin dunya.” ");
INSERT INTO tsg_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Manjari,” laung hi Īsa, “In pagbalik ku mari pa dunya kapamandugahan sin manga mānusiyaꞌ. Sabab in pagbalik ku mari biyaꞌ yan sin hantang sin hambuuk kahuy. Bang niyu kakitaan in kahuy tina magꞌugbus iban magdahun na, kaingatan niyu na sin masuuk na in panuga. ");
INSERT INTO tsg_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Damikkiyan, bang niyu kakitaan na maawn in manga katān biyaytaꞌ ku kaniyu, kaingatan niyu na sin masuuk na in pagbalik ku mari pa dunya, hangkarayꞌ dakuman. ");
INSERT INTO tsg_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Na, ini in tumtuma niyu. In katān biyaytaꞌ ku yan kaniyu maawn ha diꞌ pa maubus malanyap in bangsa sin manga tau ha masa ini. ");
INSERT INTO tsg_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ha susūngun in langit iban dunya malanyap da, sagawaꞌ in katān kiyapamung ku diꞌ tuud maluppas salama-lama (sabab in yan tantu tuud bunnal).” ");
INSERT INTO tsg_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Malayngkan,” laung hi Īsa, “wayruun minsan hambuuk in makaingat sin adlaw atawa waktu sin pagbalik ku mari pa dunya. Minsan in manga malāikat ha surgaꞌ iban sin aku baran ku, amu in Anak Mānusiyaꞌ, diꞌ da makaingat. Hambuuk-buuk da Tuhan, Amaꞌ ku, in makaingat sin pasal yan. ");
INSERT INTO tsg_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Hangkan, halliꞌ kamu iban jaga kamu, sabab diꞌ niyu kaingatan bang kuꞌnu in waktu yan dumatung. ");
INSERT INTO tsg_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","In pagbalik ku mari biyaꞌ yan sapantun sin hambuuk tau tumulak pa dugaing hulaꞌ. Ha diꞌ pa siya tumulak hipangandul niya in bāy niya ha manga daraakun niya. Dihilan niya kaniya-kaniya hinang iban baytaan niya in tungguꞌ lawang sin bāy niya papajagahun tuud. ");
INSERT INTO tsg_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Hangkan subay kamu majaga sabab diꞌ niyu kaingatan bang kuꞌnu in balik ku mari amu in diyalil ha tagdapu sin bāy, magalib ka atawa tungaꞌ dūm atawa lapit adlaw atawa subu-subu ka. ");
INSERT INTO tsg_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Karnaꞌ bang mataghaꞌ in pagbalik ku mari, na, subay kamu diꞌ ku abutan natutūg. ");
INSERT INTO tsg_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na, hangkan jaga tuud kamu sin pagbalik ku! Amu yan in pahāti ku kaniyu iban pa tau katān.” ");
INSERT INTO tsg_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Manjari, pagga pagkukuꞌnisahun dakuman in Haylaya Paglappas dayn ha Kamatay iban sin pakaradjaan pagtawagun, Pagkaun sin Tinapay Way Pasulig, nagꞌisun in manga nakuraꞌ kaimaman iban sin manga guru sin saraꞌ agama, bang biyaꞌ diin in kasaggaw nila kan Īsa ha diꞌ kaingatan sin manga tau. In kabayaan nila hipapatay hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Laung nila, “Subay natuꞌ siya diꞌ saggawun ha saꞌbu sin paghaylaya sabab gana-gana maghiluhalaꞌ in manga tau.” ");
INSERT INTO tsg_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Sakali in hi Īsa didtu ha kawman Bitani, ha bāy hi Simun amu in tau bakas īipul. Ha saꞌbu niya nagkakaun, awn miyawn hambuuk babai nagdarā kibut-kibut habaꞌ liug pagtawagun alabistrus, hipuꞌ sin lana mahamut pagtawagun narda. In lana mahamut ini mahargaꞌ tuud, bukun paltik iban wayruun lamud niya dugaing. Biyagbag sin babai in liug sin kibut-kibut ampa niya biyusug in lana mahamut pa ū hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Na, diyugalan in manga kaibanan tau nakakitaꞌ iban laung sin pakaniya-pakaniya, “Maytaꞌ niya iyusibaan in lana mahamut? ");
INSERT INTO tsg_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Bang yan piyagdagang magbīhan timbang gadji sin hambuuk tau ha lawm hangka-tahun, iban labi pa, iban in bīhan hikapagsarakka ha miskin.” Na, iyastulan tuud sila ha babai. Siyahawi nila siya pa mangīꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Sagawaꞌ laung hi Īsa kanila, “Pasāri niyu na siya! Ayaw niyu pasusaha in atay niya. Marayaw tuud in nahinang niya kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","In manga miskin matabang niyu sadja ha kuꞌnu-kuꞌnu waktu kabayaan niyu, sabab hawnu-hawnu kamu yan da isab in manga miskin. Sagawaꞌ in aku ini diꞌ lumugay dī kaniyu. ");
INSERT INTO tsg_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Hīnang sin babai ini in mahinang niya kākuꞌ. Biyusugan niya aku lana mahamut bat supaya saddiya na in anggawtaꞌ-baran ku ha adlaw pagkubul kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na, ini in mattan hibaytaꞌ ku kaniyu! Hawnu-hawnu na mayan dī ha katilibut dunya hipamahalayak in Baytaꞌ Marayaw, hikasuysuy in nahinang kākuꞌ sin babai ini gantiꞌ panumtuman kaniya.” ");
INSERT INTO tsg_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Manjari, awn hambuuk dayn ha hangpuꞌ tagduwa mulid hi Īsa, amu in pagngānan Judas, tau dayn ha Kiriyud, in miyadtu pa manga nakuraꞌ kaimaman ha supaya niya hikaungsud hi Īsa pa lawm lima nila. ");
INSERT INTO tsg_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Na, kiyūgan tuud in manga nakuraꞌ kaimaman pagdungug nila sin baytaꞌ hi Judas iban jimanjiꞌ sila dihilan nila hi Judas sīn. Hangkan, simipi na hi Judas bang biyaꞌ diin in katipu niya kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Manjari, ha adlaw panagnaan sin pakaradjaan pagtawagun Pagkaun sin Tinapay Way Pasulig, amu in adlaw pagsumbayꞌ sin manga anak bili-bili pagjamuhan ha Haylaya Paglappas dayn ha Kamatay, iyasubu hi Īsa sin manga mulid niya, laung nila, “Tuwan, hariin mu kabayaan sakapun namuꞌ in pagjamuhan taniyu?” ");
INSERT INTO tsg_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Na, diyaak hi Īsa in duwa mulid niya, laung niya kanila, “Kadtu kamu pa dāira. Pagdatung niyu madtu, hipagbāk niyu in tau nagdarā kibut tagaluun tubig. Urula niyu siya ");
INSERT INTO tsg_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","iban sūd kamu pa bāy sūran niya. Pagꞌubus ampa niyu baytai in tagdapu bāy, laung niyu, ‘Nagpaasubu in Tuwan Guru bang hawnu in bilik pagjamuhan niya iban sin manga mulid niya hipagsaꞌbu sin Haylaya Paglappas dayn ha Kamatay!’ ");
INSERT INTO tsg_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Na, hipakitaꞌ niya kaniyu in bilik dakulaꞌ ha taas sin bāy niya, amu in asal panyap sin katān kagunahan natuꞌ. Duun niyu saddiyaha in pagjamuhan natuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Na, miyadtu na pa dāira in duwa mulid hi Īsa. Pagdatung nila pa dāira, in katān biyaytaꞌ hi Īsa naagad. Na, siyaddiya nila na in pagjamuhan nila. ");
INSERT INTO tsg_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Na, naabut mayan magrib, dimatung na hi Īsa iban sin hangpuꞌ tagduwa mulid pa pagjamuhan. ");
INSERT INTO tsg_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ha saꞌbu nila nagjajamu duun ha lamisahan, namung hi Īsa, laung niya, “Ini in mattan hibaytaꞌ ku kaniyu. Awn hambuuk dī kaniyu in manipu kākuꞌ, amu in simasāw kākuꞌ nagkaun.” ");
INSERT INTO tsg_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Na, nasusa in manga mulid hi Īsa iban nangasubu na in pakaniya-pakaniya, amu agi, “Uy, tantu, Tuwan, bukun aku in piyagꞌiyan mu?” ");
INSERT INTO tsg_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","In sambung hi Īsa, “Hambuuk dayn ha hangpuꞌ tagduwa mulid ku in manipu kākuꞌ, amu in simasāw kākuꞌ timublak sin tinapay niya pa lāy pagbabahug-bahugan. ");
INSERT INTO tsg_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","In aku amu in Anak Mānusiyaꞌ manaykud na dayn ha dunya biyaꞌ na sin asal kiyabaytaꞌ ha lawm Kitab. Sagawaꞌ murkaꞌ dakulaꞌ in kumugdan ha tau manipu kākuꞌ. Marayaw pa sa walaꞌ na siya piyagꞌanak.” ");
INSERT INTO tsg_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ha saꞌbu nila nagkakaun, kimawaꞌ hi Īsa tinapay ampa siya nagsarang-sukul pa Tuhan. Ubus ampa niya sīpak in tinapay ampa diyuhal pa manga mulid niya. Laung niya, “Kawaa ampa niyu kauna in tinapay ini iban niyat sin amu yan in ginhawa-baran ku.” ");
INSERT INTO tsg_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pagꞌubus ampa kiyawaꞌ hi Īsa in hambuuk sawan, ampa siya nagsarang-sukul pa Tuhan. Pagꞌubus ampa niya diyuhal in sawan pa manga mulid niya. Na, mīnum in manga mulid niya katān. ");
INSERT INTO tsg_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Laung hi Īsa kanila, “Niyata niyu sin amu yan in duguꞌ ku, amu in dumihil kamakbulan ha janjiꞌ baꞌgu sin Tuhan ha manga tau sukuꞌ niya. Maasag in duguꞌ ku sabab-karnaꞌ sin manga tau mataud. ");
INSERT INTO tsg_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na, ini in mattan hibaytaꞌ ku kaniyu. Diꞌ aku minum magbalik sin tubig anggul ini ha salugay diꞌ dumatung in waktu magmakbul na in maksud sin pamarinta sin Tuhan, lāgiꞌ mabaꞌgu na in unu-unu katān.” ");
INSERT INTO tsg_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pagꞌubus ampa sila nagkalang sin kalangan pamudji pa Tuhan, ubus ampa sila miyadtu pa Būd Jaytun. ");
INSERT INTO tsg_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sakali ha sūng nila pa Būd Jaytun, namung hi Īsa, laung niya, “In kamu yan katān maguy iban mutas kamu dayn kākuꞌ, sabab asal kiyasulat ha lawm Kitab, amu agi, ‘Hirūl sin Tuhan mapatay in magꞌiipat ha manga bili-bili, iban mapulak-palik in manga bili-bili niya.’ ");
INSERT INTO tsg_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Sagawaꞌ mabuhiꞌ mayan aku magbalik, madtu aku muna dayn kaniyu pa hulaꞌ Jalil. Magbāk kitaniyu didtu.” ");
INSERT INTO tsg_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Simambung hi Pitrus, laung niya, “Tuwan, tantu diꞌ tuud aku mutas dayn kaymu, minsan in sila katān mutas dayn kaymu!” ");
INSERT INTO tsg_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","In sambung hi Īsa kan Pitrus, “Indani in bichara ku ini. Ha dūm ini ha diꞌ pa maabut tumagauk in manuk usug makaruwa sin subu-subu, makatū kaw umiyan, laung mu diꞌ mu aku kaingatan.” ");
INSERT INTO tsg_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Sagawaꞌ limugat tuud hi Pitrus, laung niya, “Tantu diꞌ tuud aku imiyan sin diꞌ ta kaw kaingatan, minsan pa aku mapatay umunung kaymu!” Na, biyaꞌ da isab hādtu in pamung sin katān mulid niya. ");
INSERT INTO tsg_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sakali miyadtu hinda Īsa pa lugal pagtawagun Gitsimani. Nakaratung mayan sila, laung niya ha manga mulid niya, “Lingkud naa kamu dī. Madtu pa aku mangarap pa Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Piyaagad niya hi Pitrus iban hi Yaꞌkub kay Yahiya. Sakali landuꞌ tuud nagdukka iban simusa hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Laung niya kanila, “Landuꞌ tuud in dukka sin lawm atay ku. Agun-agun na hikamatay ku. Tagad naa kamu dī iban pagjaga kamu.” ");
INSERT INTO tsg_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ubus, limayuꞌ-layuꞌ hi Īsa dayn ha manga mulid niya ampa siya simujud pa lupaꞌ sartaꞌ nangarap na siya pa Tuhan. Nangayuꞌ siya duwaa pa Tuhan bang awn dapat diꞌ na siya palabayun sin kabinsanaan masuuk na dumatung kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Laung hi Īsa, “Ya Tuhan, Amaꞌ ku! Kaingatan ku in unu-unu katān marapat mu hinangun. Bang makajari kaymu ayaw mu na aku palabaya sin kabinsanaan ini. Malayngkan, bukun kabayaan ku in maagad, sagawaꞌ in kabayaan mu in maagad.” ");
INSERT INTO tsg_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pagꞌubus nagbalik siya madtu pa manga mulid niya. Sakali in kiyaratungan niya natutūg in tū mulid niya. Laung hi Īsa kan Pitrus, “Uy! Simun, natutūg kaw? Diꞌ ka kaw makajaga minsan hangka-jām? ");
INSERT INTO tsg_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pagjaga kamu,” laung hi Īsa kanila, “iban pangayuꞌ kamu duwaa ha supaya kamu diꞌ marā sin sasat makapilad sin īman niyu. Sabab bunnal na sa ha lawm pikilan iban atay niyu mabayaꞌ tuud kamu magad sin kabayaan sin Tuhan, sagawaꞌ in anggawtaꞌ-baran niyu maluhay marā sin sasat.” ");
INSERT INTO tsg_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Pagꞌubus miyadtu na isab hi Īsa nagbalik nangarap pa Tuhan iban biyalikan niya in lapal-kabtangan sin duwaa piyangayuꞌ niya pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pagbing niya mawn pa manga mulid niya, kiyaratungan niya natutūg sila sabab miyuꞌgat na in mata nila sin karuꞌ. Iban diꞌ nila kaingatan bang unu in hisambung nila kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Sakali, hikatū mayan sin balik hi Īsa mawn kanila, laung hi Īsa kanila, “Bat natutūg iban naghahali-hali pa hāti kamu yan? Sarang na sa yan. Naabut na in waktu! Taynghug kamu. Bihaun, in aku amu in Anak Mānusiyaꞌ hiungsud na pa lawm lima sin manga tau baldusa. ");
INSERT INTO tsg_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bangun na kamu bat kitaniyu mākadtu na. Kitaa niyu ba, yan na in tau manipu kākuꞌ!” ");
INSERT INTO tsg_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Na, ha saꞌbu pa nagbibichara hi Īsa, dimatung na mawn hi Judas, amu in hambuuk dayn ha hangpuꞌ tagduwa mulid hi Īsa. Mataud tau in miyamagad kaniya nagdarā pakukus iban kakakal. In manga tau ini naraak sin manga nakuraꞌ kaimaman, sin manga guru sin saraꞌ agama iban sin manga nagtatau-maas ha hulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na, asal biyaytaan hi Judas in manga tau, laung niya, “In tau siyumun ku amuna in tau saggawun niyu. Dāha niyu siya iban jagahi niyu marayaw.” ");
INSERT INTO tsg_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Sakali pagdatung na mayan hi Judas, magtūy siya timūy madtu kan Īsa, laung niya, “Tuwan Guru,” ubus ampa niya sīyum hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Na, siyaggaw na sin manga tau hi Īsa ampa giyapus. ");
INSERT INTO tsg_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Na, magtūy liyarut sin hambuuk mulid hi Īsa in pakukus niya ampa niya liyagut in hambuuk īpun sin Imam Dakulaꞌ. Nautud in hansipak taynga sin tau liyagut niya. ");
INSERT INTO tsg_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sakali namung hi Īsa ha manga tau simaggaw kaniya, laung niya, “Maytaꞌ, mundu ka aku ini, subay niyu saggawun iban sin pakukus iban kakakal niyu? ");
INSERT INTO tsg_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Adlaw-adlaw duun aku nagnanasīhat ha Bāy sin Tuhan. Na, didtu da isab kamu, sagawaꞌ maytaꞌ niyu aku walaꞌ siyaggaw didtu? Na, hangkan biyaꞌ ha yan, sabab subay maagad in manga kiyasulat ha lawm Kitab.” ");
INSERT INTO tsg_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Na, pagꞌubus miyutas na dayn kan Īsa in katān mulid niya iban miyaguy na sila. ");
INSERT INTO tsg_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Sakali awn hambuuk subul duun nagsisiub-siub sadja in imuurul kan Īsa. Sakali awn gimanggut kaniya ambayaꞌ siya isab saggawun. ");
INSERT INTO tsg_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Saꞌ niya biyutānan in siub niya, ampa siya dimagan naghuhubuꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Manjari, diyā sin manga tau hi Īsa madtu pa bāy sin Imam Dakulaꞌ, iban nagtipun na mawn katān in manga nakuraꞌ kaimaman, in manga nagtatau-maas ha hulaꞌ iban sin manga guru sin saraꞌ agama. ");
INSERT INTO tsg_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Na, in hi Pitrus imuurul kan Īsa dayn ha kalayuan sampay nakaabut siya madtu pa halaman bāy sin Imam Dakulaꞌ. Pagsūd niya pa halaman sin bāy, duun siya limingkud ha daig sin kāyu nagpaanag, limamugay ha manga jaga, amu in manga daraakun sin Imam Dakulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na, in hi Īsa liyawagan tuud dusa sin manga nakuraꞌ kaimaman iban sin katān nakuraꞌ Yahudi manghuhukum bat hi Īsa kabutangan sin hukuman subay patayun. Sagawaꞌ wayruun dusa kabaakan nila hikatuntut kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mataud in tau simaksiꞌ sin puting bat supaya katuntutan hi Īsa, sagawaꞌ diꞌ magtaayun in bichara sin manga saksiꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sakali awn kaibanan tau timindug ampa simaksiꞌ sin puting. ");
INSERT INTO tsg_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Laung nila, “In tau yan diyungug namuꞌ imiyan sin malubu niya in Bāy sin Tuhan, amu in bakas hīnang sin manga tau, ubus ampa siya kunuꞌ magpatindug dugaing ha lawm tūy adlaw, amu in bukun hinangan mānusiyaꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Sagawaꞌ minsan in manga tau simaksiꞌ ini, walaꞌ da isab nagtaayun in manga bichara nila. ");
INSERT INTO tsg_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Na, timindug in Imam Dakulaꞌ ampa miyadtu pa giꞌtungan sin katān tau duun. Iyasubu niya hi Īsa, laung niya, “Na, unu in hikasambung mu ha manga saksiꞌ ini pasal sin baytaꞌ nila sin narusa mu?” ");
INSERT INTO tsg_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Na, walaꞌ nagkaybaꞌ hi Īsa. Walaꞌ siya simambung minsan hangka-kabtang. Na, iyasubu na isab siya nagbalik sin Imam Dakulaꞌ, amu agi, “Ikaw ka in Almasi, amu in Anak sin hambuuk-buuk Tuhan piyupudji?” ");
INSERT INTO tsg_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","In sambung hi Īsa, “Huun, aku na. Iban kakitaan niyu da in aku amu in Anak Mānusiyaꞌ lumingkud ha dapit pa tuu sin Tuhan Mahatinggi, iban ha pagbalik ku mari ha susūngun kakitaan niyu aku miyamagad ha lawm gabun.” ");
INSERT INTO tsg_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Na, magtūy gīrit sin Imam Dakulaꞌ in juba niya (sabab diyugalan tuud siya) ampa siya namung, laung niya, “Maytaꞌ pa kitaniyu maglawag manga saksiꞌ? ");
INSERT INTO tsg_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Diyungug niyu na hayn-duun in bichara niya pangkal pa Tuhan. Na, ha pikil niyu unu in hukuman hibutang natuꞌ kaniya?” Nagtaayun sila katān sin mattan in dusa hi Īsa iban subay siya patayun. ");
INSERT INTO tsg_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Na, pagꞌubus magtūy piyagluraan sin kaibanan tau hi Īsa. Tiyabunan nila in mata niya ubus ampa nila siya piyagsuntuk. “Na,” laung nila kan Īsa, “tukura bang hisiyu in simuntuk kaymu!” Ubus diyā na siya sin manga jaga amu in naminasa da isab kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Manjari, ha saꞌbu hi Pitrus duun ha halaman bāy sin Imam Dakulaꞌ, nākawn in hambuuk babai daraakun sin Imam Dakulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pagkitaꞌ niya kan Pitrus duun nagpaanag ha daig sin kāyu, magtūy niya iyatud hi Pitrus ampa siya imiyan, laung niya, “In ikaw yan agad da isab kan Īsa amu in tau Nasarit.” ");
INSERT INTO tsg_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Namaylu hi Pitrus, laung niya, “Inday kaymu. Diꞌ ku kahātihan bang unu in piyagbichara mu yan.” Ubus ampa siya minīg, miyadtu pa labayan sin lawang sin halaman bāy. Na, saruun-duun, timagauk na in manuk. ");
INSERT INTO tsg_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Sakali kītaꞌ na isab siya nagbalik sin babai daraakun. Laung sin babai ha manga tau nagtitindug duun, “In tau yan agad da isab kanila!” ");
INSERT INTO tsg_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Na, namaylu na isab hi Pitrus. Bukun mawgay īyan hi Pitrus sin manga tau nagtitindug duun, laung nila, “Mattan tuud in ikaw yan agad kanila, sabab in ikaw yan tau Jalil da isab.” ");
INSERT INTO tsg_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sagawaꞌ nagsuknaꞌ-suknaꞌ tuud hi Pitrus sin baran niya iban simapa siya, laung niya, “Bang mān aku pagmulkaan sin Tuhan bang puting in baytaꞌ ku yan kaniyu. Diꞌ ku tuud kaingatan in tau piyagꞌiyan niyu yan!” ");
INSERT INTO tsg_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Na, magtūy na isab timagauk in manuk usug. Hikaruwa na sin manuk timagauk. Na, pagdungug hi Pitrus, kiyatumtuman niya in bichara hi Īsa, amu agi, “Ha diꞌ pa tumagauk in manuk usug makaruwa, makatū kaw umiyan sin in aku diꞌ mu kaingatan.” Na, nagtangis tuud siya, pagtumtum niya sin bichara hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Manjari, pagbulat mahinaat, in manga nakuraꞌ kaimaman nagꞌūs-ꞌūs nagtipun iban sin manga nagtatau-maas sin hulaꞌ iban sin manga guru sin saraꞌ agama iban na sin katān nakuraꞌ Yahudi manghuhukum, ampa sila nagꞌisun sin hinangun nila. Kiyadinahan nila hi Īsa ampa nila diyā madtu tiyukbal pa lawm lima hi Pilatu. ");
INSERT INTO tsg_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Na, iyasubu hi Īsa kaagi hi Pilatu, laung niya, “Ikaw na ka in sultan sin manga Yahudi?” “Na, biyaꞌ na sin kiyapamung mu,” in sambung hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na, mataud in tiyuntut sin manga nakuraꞌ kaimaman kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Hangkan, iyasubu na isab nagbalik hi Īsa kaagi hi Pilatu, laung niya, “Way ka hikaraawa mu ha manga bichara nila yan? Diyungug mu na in taud sin tiyuntut nila kaymu!” ");
INSERT INTO tsg_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Sagawaꞌ walaꞌ isab simambung hi Īsa minsan hangka-kabtang. Na, landuꞌ tuud nainu-inu hi Pilatu. ");
INSERT INTO tsg_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na, sakahabaꞌ waktu sin Haylaya Paglappas dayn ha Kamatay, biyaꞌ sin pagkabiyaksahan hi Gubnul Pilatu, magpaguwaꞌ siya hambuuk pilisu amu in kabayaan sin manga tau paguwaun. ");
INSERT INTO tsg_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Na, ha waktu yadtu awn hambuuk tau pagngānan hi Barabbas in najijīl. In tau ini agad ha manga tau namunuꞌ ha waktu sin pagpangatu nila ha parinta. ");
INSERT INTO tsg_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Manjari, nakapagtipun mayan in manga tau, nangayuꞌ na sila kan Pilatu paguwaun in hambuuk pilisu biyaꞌ sin addat niya tahun-tahun. ");
INSERT INTO tsg_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Na, iyasubu hi Pilatu in manga tau, laung niya, “Na, unu in kabayaan niyu? Puasun ku kaniyu in sultan sin manga Yahudi?” ");
INSERT INTO tsg_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Na, kiyaingatan hi Pilatu sin in manga nakuraꞌ kaimaman maabughuꞌ kan Īsa, hangkan tiyukbal nila hi Īsa mawn kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Na, bīcharahan sin manga nakuraꞌ kaimaman in manga tau mataud hipapangayuꞌ paguwaun hi Barabbas, bukun hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nangasubu nagbalik hi Pilatu in manga tau, laung niya, “Na, unu in kabayaan niyu hinangun ku ha tau amu in giyulal niyu sultan sin manga Yahudi?” ");
INSERT INTO tsg_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Imulak in manga tau, laung nila, “Palansangan siya pa usuk!” ");
INSERT INTO tsg_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Maytaꞌ, unu in dusa nahinang niya?” laung hi Pilatu ha manga tau. Sagawaꞌ walaꞌ siyambag sin manga tau in pangasubu niya. Gām mayan nagꞌulak makusug in manga tau, laung nila, “Palansangan siya pa usuk!” ");
INSERT INTO tsg_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Na, hi Barabbas in piyaguwaꞌ hi Pilatu sabab kabayaan niya sulutun in kabayaan sin manga tau. Ubus piyalubakan niya na hi Īsa ampa niya tiyukbal pa manga sundalu hipapalansang pa usuk pagpatayan kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sakali diyā na sin manga sundalu hi Īsa madtu pa lawm halaman bāy dakulaꞌ piyaghuhulaan sin gubnul. Pagꞌubus, tīpun nila mawn in katān sundalu hangka-panji ampa piyaglangugan sin manga sundalu hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Inīgan nila in badjuꞌ hi Īsa ampa nila siya siyulugan sin siub badjuꞌ taluk biyaꞌ lupa sin siub sin badjuꞌ sin sultan. Ubus ampa nila liyubid in sanga sin kahuy matunuk hīnang biyaꞌ kuruna ampa nila siyangun pa ū hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ubus, ampa bahasa liyagguꞌ nila hi Īsa, laung nila, “Mabuhay, in Sultan sin manga Yahudi!” ");
INSERT INTO tsg_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Liyubak nila hi Īsa sin kahuy-kahuy ha ū iban piyagluraan nila siya. Pagꞌubus, ampa sila simujud ha alupan hi Īsa, bahasa nagpakitaꞌ sin pagꞌaddat nila kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Na, naubus nila mayan piyaglangugan hi Īsa, inīgan nila na in siub badjuꞌ taluk dayn kan Īsa, ampa nila siya siyulugan nagbalik sin badjuꞌ niya. Ubus diyā nila na siya pa guwaꞌ, madtu pa lugal paglansangan kaniya pa usuk. ");
INSERT INTO tsg_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Manjari ha tudju nila madtu pa lugal pagpatayan, piyagbāk nila in hambuuk tau pagngānan hi Simun, lūd dayn ha gimba mawn pa dāira. Sakali liyugus sin manga sundalu hi Simun piyapagdā sin usuk paglansangan kan Īsa. (In hi Simun ini tau dayn ha hulaꞌ Kirini. Siya in amaꞌ hi Iskandal kay Rupus.) ");
INSERT INTO tsg_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Diyā nila hi Īsa madtu pa lugal pagtawagun Gulguta, (in maana niya kulakub ū). ");
INSERT INTO tsg_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pagꞌabut nila madtu, dīhilan nila hi Īsa sin tubig anggul (biyaꞌ tubaꞌ) liyalamuran sin ubat pagtawagun mira. Sagawaꞌ diꞌ minum hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Na, hiyubuan nila in tamungun hi Īsa, ubus ampa nila siya liyansang pa usuk. Ubus ampa nila piyagbahagian in tamungun hi Īsa. Piyagkuut-kuutan nila bang unu in masukuꞌ sin hambuuk pa hambuuk. ");
INSERT INTO tsg_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Lisag siyam sin mahinaat in kalansang kan Īsa pa usuk. ");
INSERT INTO tsg_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Awn manga kabtangan siyulat amu agi, “In Sultan sin manga Yahudi.” Amu yan in tuntut kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Na, awn da isab duwa mundu liyansang pa usuk diyungan kan Īsa. In hambuuk liyansang ha usuk ha dapit pa tuu hi Īsa, hāti in hangka-tau ha dapit pa lawa. ");
INSERT INTO tsg_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Na, naagad tuud in kiyasulat ha lawm Kitab, amu agi, “Ītung siya agad ha manga tau mangīꞌ.” ");
INSERT INTO tsg_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na, in manga tau maglalabay, pagkitaꞌ nila kan Īsa, magꞌilung-ilung sadja sin ū nila (tandaꞌ sin pangudjuꞌ-ngudjuꞌ nila kaniya) iban liyagiꞌ-lagiꞌ nila hi Īsa. Laung nila, “Aha, na, in baytaꞌ mu malubu mu in Bāy sin Tuhan ubus mapatindug mu magbalik ha lawm tūy adlaw. ");
INSERT INTO tsg_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Na, tabanga na in baran mu, naug na kaw dayn ha taas sin usuk yan!” ");
INSERT INTO tsg_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Damikkiyan, piyaglagiꞌ-lagiꞌ da isab hi Īsa kaagi sin manga nakuraꞌ kaimaman iban sin manga guru sin saraꞌ agama. Laung sin pakaniya-pakaniya, “Natabang niya in tau dugaing dayn ha kamulahan, sagawaꞌ in baran niya diꞌ niya matabang. ");
INSERT INTO tsg_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Na, in Almasi amu in sultan sin bangsa Israil, subay makanaug dayn ha usuk yan bihaun ampa kami magparachaya kaniya!” Damikkiyan, in duwa mundu amu in liyansang da isab pa usuk duun ha daig hi Īsa, nanglagiꞌ-lagiꞌ da isab kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Manjari, naabut mayan ugtu suga nanigidlum na in katilibut sin hulaꞌ sampay naabut lisag tū sin mahapun. ");
INSERT INTO tsg_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na, pagꞌabut mayan manga lisag tū sin mahapun nagsuwara matanug hi Īsa, laung niya, “Iluy iluy, lama sabaktani?” In hāti niya, “Ya Tuhan ku, maytaꞌ mu aku piyasāran?” ");
INSERT INTO tsg_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Na, pagdungug sin manga kaibanan tau nagtitindug duun nasāꞌ in pangdungug nila. Laung nila, “Na, taynghug kamu! Tiyawag niya hi Ilyas!” ");
INSERT INTO tsg_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Sakali dimagan in hambuuk tau kimawaꞌ luppus ampa niya hiyaꞌgum pa tubig anggul (biyaꞌ tubaꞌ). Pagꞌubus, ampa niya biyutang in luppus pa duhul sin kahuy-kahuy ampa niya diyuhal piyasupsup kan Īsa iban laung niya, “Tagad kamu! Kitaun natuꞌ bang siya tabangun hi Ilyas panaugun dayn ha taas usuk yan!” ");
INSERT INTO tsg_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Na, nagsuwara matanug hi Īsa, ubus ampa miyugtuꞌ in napas niya. ");
INSERT INTO tsg_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Pagbugtuꞌ na mayan sin napas niya, magtūy nagisiꞌ nagduwa dayn ha taas pa duhul in kurtina marakmul didtu ha lawm Bāy sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na, awn hambuuk kapitan in nagtitindug duun ha alupan sin usuk piyaglansangan kan Īsa, in nakakitaꞌ sin katān naawn ha pagbugtuꞌ sin napas hi Īsa. Laung niya, “Tantu na tuud sin in tau ini amuna in Anak Tuhan!” ");
INSERT INTO tsg_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Na, awn isab manga babai duun nagkikitaꞌ dayn ha kalayuan. Miyamagad ha manga kababaihan ini hinda Mariyam amu in babai dayn ha dāira Magdala, hi Salumi iban hi Mariyam, amu in inaꞌ hi Jusis kay Yaꞌkub amu in kabungsuhan. ");
INSERT INTO tsg_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","In manga babai ini miyagad iban nagpalihalaꞌ kan Īsa sin duun pa siya ha Jalil. Mataud da isab kaibanan babai duun in miyagad kan Īsa mawn pa Awrusalam (Baytal Makdis). ");
INSERT INTO tsg_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Manjari, himapun mayan tuud dimatung na hi Yusup amu in tau dayn ha dāira Arimati. In siya ini hambuuk kunsiyal sin agama Yahudi piyagꞌaaddatan, amu in timatagad da isab sin waktu tumindug in pamarinta sin Tuhan. Pagga pagkikinsumun na in adlaw Sabtuꞌ, amu in adlaw paghali-hali iban pagpudji pa Tuhan, hāti niya waktu na sin pagsaddiya, timawakkal hi Yusup miyadtu kan Pilatu nangayuꞌ sin bangkay hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Na, nainu-inu hi Pilatu pagdungug niya sin miyatay na hi Īsa. Tiyawag niya in hambuuk kapitan ampa niya iyasubu bang malugay na miyatay hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Na, pagdungug niya dayn ha kapitan, sin patay na hi Īsa, tiyugutan niya na hi Yusup kumawaꞌ sin bangkay hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Na, miyadtu na hi Yusup namī kuku putiꞌ marayaw, ubus ampa siya miyadtu kimawaꞌ sin bangkay hi Īsa. Siyaput niya in bangkay, ampa niya biyutang pa lawm kubul amu in batu dakulaꞌ liyungagan hīnang biyaꞌ lupa sungab batu. Pagꞌubus ampa niya giyulung in hambuuk batu piyagtambul sin sūran pa lawm kubul. ");
INSERT INTO tsg_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Hi Mariyam amu in babai dayn ha Magdala iban hi Mariyam amu in inaꞌ hi Jusis duun nagkikitaꞌ sin pagkubul kan Īsa. Kītaꞌ nila in pagbutang kan Īsa pa lawm kubul. ");
INSERT INTO tsg_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Manjari, pagga sin limabay na in adlaw paghali-hali iban pagpudji pa Tuhan, hi Mariyam, amu in babai dayn ha Magdala, hi Salumi, iban hi Mariyam, amu in inaꞌ hi Yaꞌkub, namī panyap mahamut hipagbutang ha patay bat nila kabutangan in bangkay hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Na, pagbulat mahinaat sin adlaw Ahad, subu-subu pa tuud miyadtu na sila pa kubul. ");
INSERT INTO tsg_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Ha saꞌbu nila ha dān, piyagbicharahan nila bang hisiyu in makagulung kanila sin batu tambul sin sūran pa lawm kubul sabab in batu dakulaꞌ tuud. Sagawaꞌ pagdatung nila madtu, kītaꞌ nila naīg na in batu, nagulung na naīg dayn ha sūran pa lawm kubul. ");
INSERT INTO tsg_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Na, simūd sila pa lawm kubul. Pagsūd nila, kītaꞌ nila in hambuuk usug bataꞌ baꞌgu nagjujuba putiꞌ, duun naglilingkud ha dapit pa tuu. Na, nahaylan tuud sila. ");
INSERT INTO tsg_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","“Ayaw kamu mahaylan,” laung sin tau kanila. “Kaingatan ku naglawag kamu kan Īsa, tau dayn ha Nasarit, amu in liyansang pa usuk. Wayruun na siya dī. Nabuhiꞌ na siya nagbalik! Kitaa niyu in lugal bakas piyagbutangan kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Na, kadtu na kamu, baytai niyu in manga mulid niya, awla-awla na hi Pitrus, sin muna na hi Īsa dayn kanila madtu pa Jalil. Didtu nila siya kakitaan biyaꞌ sin kiyabaytaꞌ niya kanila.” ");
INSERT INTO tsg_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Na, gimuwaꞌ na sila dayn ha lawm kubul ampa sila dimagan, sabab namidpid tuud sila sin bugaꞌ. Walaꞌ sila nagbichara unu-unu minsan ha hisiyu tau sabab miyugaꞌ sila. ");
INSERT INTO tsg_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Manjari, nabuhiꞌ mayan hi Īsa nagbalik dayn ha kamatay, subu-subu pa tuud sin adlaw Ahad, nagpanyataꞌ siya muna mawn kan Mariyam, amu in babai dayn ha Magdala. In hi Mariyam ini bakas kiyapaguwaan hi Īsa pitu saytan dayn ha lawm baran niya. ");
INSERT INTO tsg_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Na, miyadtu siya namaytaꞌ ha manga panāiban hi Īsa. Didtu sila nagdurukka iban nagtatangis. ");
INSERT INTO tsg_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pagdungug nila sin bichara niya sin in hi Īsa buhiꞌ iban kītaꞌ niya tuud sin duwa mata niya, walaꞌ sila nagkahagad kaniya. ");
INSERT INTO tsg_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pagꞌubus yadtu nagpanyataꞌ isab hi Īsa ha duwa mulid niya ha saꞌbu sin duwangka-tau harap pa gimba. Dugaing isab in hantang sin pagpanyataꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Na, nagbalik in duwangka-tau namaytaꞌ ha manga panāiban nila, sagawaꞌ walaꞌ sila nagkahagad. ");
INSERT INTO tsg_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Na, mahuli dayn duun nagpanyataꞌ da isab hi Īsa ha hangpuꞌ tagꞌisa mulid niya ha saꞌbu nila nagkakaun. Piyagꞌamahan hi Īsa in manga mulid niya sabab diꞌ sila magparachaya iban diꞌ tuud sila magkahagad ha baytaꞌ sin manga tau nakakitaꞌ sin in siya buhiꞌ. ");
INSERT INTO tsg_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Laung niya kanila, “Kadtu kamu pa kahulaꞌ-hulaan ha katilingkal sin dunya magpamahalayak sin Baytaꞌ Marayaw pa mānusiyaꞌ katān. ");
INSERT INTO tsg_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Hisiyu-siyu in magparachaya iban magpaliguꞌ tandaꞌ sin pagparachaya niya kākuꞌ, malappas siya. Saꞌ hisiyu-siyu in diꞌ magparachaya kugdanan siya sin hukuman sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Iban awn tandaꞌ kakitaan ha manga tau magparachaya kākuꞌ, karnaꞌ in sila yan dayn ha kusug sin ngān ku, makapaguwaꞌ sila manga saytan dayn ha lawm baran sin tau iban makabichara sila sin manga bahasa diꞌ nila kaingatan. ");
INSERT INTO tsg_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bang sila makakamput manga hās atawa makainum sila lassun, diꞌ sila maunu. Hibutang nila in lima nila ha nasasakit, na kaulian in nasasakit.” ");
INSERT INTO tsg_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pagꞌubus hi Panghuꞌ Īsa nagbichara kanila, naangkat na siya pa taas langit pa lawm surgaꞌ ampa siya limingkud ha dapit pa tuu sin Tuhan, amu in tungud tiyatawꞌ ha makawasa. ");
INSERT INTO tsg_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Na, miyadtu na pa kahulaꞌ-hulaan in manga mulid hi Īsa nagpamahalayak sin Baytaꞌ Marayaw pasal sin pamarinta sin Tuhan. Tiyabangan sila sin Panghuꞌ sin hinang nila iban tiyabangan niya sila nagpakitaꞌ sin manga tandaꞌ sin in piyagpamahalayak nila bunnal tuud.");
INSERT INTO tsg_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Alamat ini sulat naug dayn kan Lukas mawn kan Tiyupilas. Kaingatan mu mataud tau in bakas nagsulat sin manga pakaradjaan pasal sin Almasi amu in naawn ha masa natuꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Siyulat nila in manga pakaradjaan biyaytaꞌ kātuꞌniyu sin manga tau nakakitaꞌ sin manga pakaradjaan ini dayn ha panagnaan, amu in manga tau nagpamahalayak sin baytaꞌ dayn ha Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na, hangkan, Tuwan, pagga napariksaꞌ ku tuud marayaw in katān pakaradjaan ini dayn ha panagnaan, napikil ku marayaw hisulat ku, tagidꞌirun kaymu in manga pakaradjaan ini, ");
INSERT INTO tsg_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ha supaya mu kaingatan sin tantu tuud in kasabunnalan sin manga katān kiyahinduꞌ kaymu. ");
INSERT INTO tsg_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Manjari ha waktu hi Hirud in nagsusultan ha hulaꞌ Yahudiya, awn hambuuk imam pagngānan Jakariyas. In siya ini agad ha tumpuk sin manga imam agad kan Imam Abiyas. In ngān sin asawa niya hi Hashiba, hambuuk da isab panubuꞌ hi Imam Harun. ");
INSERT INTO tsg_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kiyasulutan tuud in Tuhan ha duwa magtiyaun ini. Iyaagad nila tuud in katān saraꞌ iban daakan sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Sagawaꞌ wayruun anak nila sabab in hi Hashiba diꞌ makaanak, ampa in siya iban hi Jakariyas maas na tuud. ");
INSERT INTO tsg_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sakali hambuuk adlaw duun hi Jakariyas ha Bāy sin Tuhan naghihinang, karnaꞌ naabut na in waktu sumubli siya sin hinang duun. ");
INSERT INTO tsg_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Biyaꞌ sin pagkabiyaksahan sin manga kaimaman pagkuut-kuutan nila bang hisiyu in magtugtug kamanyan ha lawm Bāy sin Tuhan. Na, hi Jakariyas in napīꞌ, hangkan siya in simūd pa lawm sin bilik suchi. ");
INSERT INTO tsg_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ha waktu sin pagpaasu kamanyan, in manga tau mataud duun ha guwaꞌ nangangarap pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sakali awn hambuuk malāikat naraak sin Tuhan nagpanyataꞌ mawn kan Jakariyas. Duun timitindug in malāikat ha dapit pa tuu sin pagtutugtugan kamanyan. ");
INSERT INTO tsg_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pagkitaꞌ hi Jakariyas ha malāikat kiyublaan iban miyugaꞌ siya. ");
INSERT INTO tsg_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Sagawaꞌ laung sin malāikat kaniya, “Ayaw kaw mabugaꞌ, Jakariyas! Karnaꞌ in aku ini miyari mamaytaꞌ kaymu sin hirihil na sin Tuhan kaymu in piyangayuꞌ mu kaniya. In asawa mu hi Hashiba makaanak na. Magꞌanak siya usug iban subay mu ngānan Yahiya in anak mu. ");
INSERT INTO tsg_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Magkūg-kuyag tuud kamu iban mataud tau in kumuyag bang siya hipagꞌanak na! ");
INSERT INTO tsg_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mahinang siya hambuuk tau dakulaꞌ tuud in kalagguan pa Tuhan. Subay siya diꞌ minum sin unu-unu na makahilu. Pagbugsak namān kaniya pa sikān magtūy siya hūpun sin Rū sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mataud tau bangsa Israil in marā niya magpabuntul sin atay nila tudju pa Tuhan, Panghuꞌ nila. ");
INSERT INTO tsg_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Hiyuhūp siya sin Rū sin Tuhan iban mabarakat siya biyaꞌ kan Nabi Ilyas. Muna siya dayn ha Panghuꞌ bat niya mapasakap in manga tau sin pagdatung sin Panghuꞌ. Papagsulutun niya magbalik in manga magtalianak amu in nagkakaniya-kaniya. Pabuntulun niya in pikilan sin manga tau, amu in diꞌ magkahagad sin daakan, paagarun ha pikilan sin tau mabuntul.” ");
INSERT INTO tsg_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Laung hi Jakariyas ha malāikat, “Biyaꞌ diin in kaingat ku bang bunnal in baytaꞌ mu yan? In aku ini maas na iban in asawa ku maas na da isab.” ");
INSERT INTO tsg_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","In sambung sin malāikat, “In aku ini hi Jibril. Aku in timitindug ha haddarat sin Tuhan, amu in nagdaak kākuꞌ magbichara kaymu iban mamaytaꞌ kaymu sin baytaꞌ marayaw yan. ");
INSERT INTO tsg_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Sagawaꞌ in ikaw yan walaꞌ nagkahagad sin amānat piyasampay ku kaymu amu in kakitaan mu da in kasabunnalan bang maabut na in waktu kiyagantaꞌ. Hangkan diꞌ kaw makabichara sampay maabut in waktu magmakbul na in manga kiyabaytaꞌ ku yan kaymu.” ");
INSERT INTO tsg_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Manjari in manga tau nagtatagad duun kan Jakariyas nainu-inu bang maytaꞌ siya liyugayan ha lawm sin Bāy sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sakali pagguwaꞌ niya diꞌ na siya makabichara ha manga tau. Hangkan kiyapasihatan nila na sin awn mahal-mahal kiyakitaan hi Jakariyas ha lawm sin Bāy sin Tuhan. Pagga siya diꞌ na makabichara, nagsinyal na sadja siya kanila. ");
INSERT INTO tsg_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pagga naubus na in hinang niya ha Bāy sin Tuhan, minuwiꞌ na hi Jakariyas pa bāy niya. ");
INSERT INTO tsg_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bukun malugay in asawa niya hi Hashiba nagburus na, iban ha lawm lima bulan walaꞌ siya nagꞌīg dayn ha lawm bāy. ");
INSERT INTO tsg_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Laung niya, “Na tiyabang da tuud isab aku sin Tuhan. Piyapasan niya na in kasipugan ku!” ");
INSERT INTO tsg_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Sakali naabut mayan unum bulan in pagburus hi Hashiba, diyaak na isab sin Tuhan in malāikat Jibril madtu pa kawman Nasarit ha hulaꞌ Jalil. ");
INSERT INTO tsg_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Piyakadtu siya magsampay sin amānat pa hambuuk budjang amu in nagtutunang iban sin hambuuk usug pagngānan hi Yusup. Hi Yusup ini hambuuk panubuꞌ hi Sultan Daud, (amu in bakas sultan sin manga tau Israil.) In ngān sin budjang ini hi Mariyam. ");
INSERT INTO tsg_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Na, miyawn na in malāikat kaniya ampa namichara, laung niya, “Pagkūg-kuyag kaw, Indaꞌ! In ikaw yan napīꞌ sin Tuhan iban malagguꞌ tuud in karayawan dīhil niya kaymu!” ");
INSERT INTO tsg_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Na, pagdungug hi Mariyam sin lapal-kabtangan sin malāikat, nasusa tuud siya iban nainu-inu siya bang unu in hāti sin lapal-kabtangan niya. ");
INSERT INTO tsg_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Laung sin malāikat kaniya, “Ayaw kaw mabugaꞌ, Mariyam. In Tuhan kiyasulutan kaymu. ");
INSERT INTO tsg_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","In ikaw yan maburus iban magꞌanak kaw bataꞌ-bataꞌ usug. Subay mu siya ngānan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Dakulaꞌ in kalagguan iban kawasa niya iban siya in gulalun Anak sin Tuhan Mahatinggi. Dihilan siya sin Tuhan PANGHUꞌ kawasa magbayaꞌ ha manga tau, biyaꞌ kan Daud, amu in nanubuꞌ ha kamaasan niya iban nagsultan ha bangsa Israil. ");
INSERT INTO tsg_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Siya in magbayaꞌ kasaumulan ha manga panubuꞌ hi Yaꞌkub, iban wayruun kahinapusan sin kawasa niya!” ");
INSERT INTO tsg_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Simambung hi Mariyam ha malāikat, laung niya, “Biyaꞌ diin in kaburus kākuꞌ sin masi pa aku budjang?” ");
INSERT INTO tsg_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","In sambung sin malāikat, “Hūpun kaw sin Rū sin Tuhan, iban tulunan kaw sin kudarat sin Tuhan Mahatinggi. Hangkan dayn ha sabab ini in bataꞌ hipagꞌanak mu mahasuchi iban siya in gulalun Anak sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ingat kaw, in kampung mu hi Hashiba, amu in piyagꞌiyan diꞌ makaanak, burus na unum bulan bihaun, minsan siya maas na. ");
INSERT INTO tsg_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Karnaꞌ wayruun mahunit ha Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Laung hi Mariyam, “In aku ini īpun sin Tuhan iban taymaun ku in unu-unu kiyahandak kākuꞌ sin Tuhan. Bang mayan isab maagad in kiyabaytaꞌ mu kākuꞌ.” Na, pagꞌubus minīg na in malāikat. ");
INSERT INTO tsg_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Na, bukun malugay nagsakap hi Mariyam ampa siya nagꞌūs-ꞌūs miyadtu pa gimba pa hambuuk kawman ha hulaꞌ mabūd ha Yahudiya. ");
INSERT INTO tsg_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Miyadtu siya pa bāy hi Jakariyas. Pagdatung niya, sīyum niya hi Hashiba. ");
INSERT INTO tsg_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Sakali, pagdungug hi Hashiba sin kabtangan hi Mariyam, himibal in bataꞌ-bataꞌ ha lawm tiyan hi Hashiba. In hi Hashiba hiyuhūp sin Rū sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Namichara matanug hi Hashiba, laung niya, “Ikaw tuud in kiyaanugharaan dayn ha katān babai iban iyanugharaan da isab in bataꞌ-bataꞌ hipagꞌanak mu! ");
INSERT INTO tsg_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Maytaꞌ bahaꞌ aku dīhilan sin kalagguan ini, bisitahun sin inaꞌ sin Panghuꞌ ku? ");
INSERT INTO tsg_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Amu sadja pikila, pagdungug ku na mayan sin manga kabtangan mu kākuꞌ, nagtūy himibal in bataꞌ-bataꞌ ha lawm tiyan ku sabab sin kakuyagan niya. ");
INSERT INTO tsg_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Landuꞌ in kakuyagan mu sabab nagkahagad kaw sin mabunnal iban maagad da in janjiꞌ kaymu sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Manjari nagbichara hi Mariyam laung niya, “Piyupudji ku tuud in Tuhan ha lawm atay ku, ");
INSERT INTO tsg_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Makuyag in ginhawa-baran ku pasal sin Tuhan, Manglalappas kākuꞌ, ");
INSERT INTO tsg_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","karnaꞌ tiyumtum niya aku amu in hambuuk īpun niya mababaꞌ atay! Na, dayn ha bihaun in aku tawagun na sin manga tau katān babai kiyasukuan karayawan, ");
INSERT INTO tsg_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","sabab sin pakaradjaan makainu-inu kimugdan kākuꞌ amu in piyaawn sin Tuhan Mahatinggi. In siya mahasuchi. ");
INSERT INTO tsg_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Bayngꞌulungun siya ha katān nagmamabugaꞌ kaniya dayn ha awal jaman sampay pa huling bataꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Piyakitaꞌ niya in kusug sin kawasa niya dayn ha manga hinang niya. Piyulak-palik niya in manga tau abbuhan amu in nagpipikil sin mataas sila. ");
INSERT INTO tsg_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Inīgan niya kawasa in manga sultan, iban piyataas niya in manga tau mababaꞌ amu in way kawasa. ");
INSERT INTO tsg_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Diyūlan niya in manga hikarayaw sin manga tau mabayaꞌ tuud magad sin kabayaan niya, sagawaꞌ walaꞌ niya diyūlan in kabayaan sin manga dayahan. ");
INSERT INTO tsg_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Iyagad niya in janjiꞌ niya ha manga kamaasan natuꞌ. Tiyabang niya in manga īpun niya amu in panubuꞌ hi Israil. ");
INSERT INTO tsg_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tiyumtum niya in janjiꞌ niya kan Ibrahim, iban sin katān panubuꞌ niya sin kaulungan niya sila kasaumulan.” ");
INSERT INTO tsg_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Na, dimuun hi Mariyam kan Hashiba awn manga tū bulan ampa siya minuwiꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Manjari, naabut na in waktu pagꞌanak hi Hashiba. Nagꞌanak siya bataꞌ-bataꞌ usug. ");
INSERT INTO tsg_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nagkūg-kuyag tuud katān in manga pangdaig bāy iban kampung hi Hashiba, pagdungug nila sin karayawan dīhil sin Tuhan kaniya. ");
INSERT INTO tsg_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Na, pagga naabut na walu adlaw dayn ha kapagꞌanak ha bataꞌ-bataꞌ, miyawn na sila himadil sin pagꞌislam ha bataꞌ-bataꞌ. Ambayaꞌ nila ngānan Jakariyas in bataꞌ-bataꞌ, hisangay ha ngān sin amaꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Sagawaꞌ laung sin inaꞌ, “Ayaw! Subay Yahiya in hingān kaniya.” ");
INSERT INTO tsg_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Laung nila kaniya, “Sagawaꞌ wayruun kampung mu in taga ngān biyaꞌ ha yan!” ");
INSERT INTO tsg_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sakali nagsinyal na sila ha amaꞌ, iyasubu bang unu in kabayaan niya hingān ha bataꞌ-bataꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Siminyal hi Jakariyas nangayuꞌ pagsulatan, ampa niya siyulat, “In ngān niya, hi Yahiya.” Na, kiyublaan tuud sila katān! ");
INSERT INTO tsg_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sakali saruun-duun nakabichara na nagbalik hi Jakariyas iban nagkabtangan na siya sin pamudji pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Na, miyugaꞌ tuud in manga tau pangdaig bāy nila, iban simaplag na in suysuy pa katān kagimbahan mabūd sin hulaꞌ Yahudiya. ");
INSERT INTO tsg_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","In katān tau nakarungug sin suysuy nangannal-ngannal na. Laung nila, “Unu bahaꞌ in kasūngan sin bataꞌ-bataꞌ yan?” Karnaꞌ mattan na tuud sin yan in kawasa sin Tuhan ha bataꞌ-bataꞌ yan. ");
INSERT INTO tsg_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sakali hi Jakariyas, amaꞌ hi Yahiya, hiyūp sin Rū sin Tuhan, ampa siya nagbichara pamudji pa Tuhan iban sin pakaradjaan maawn ha susūngun pasal hi Yahiya. Laung niya, ");
INSERT INTO tsg_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Pudjihun natuꞌ in Panghuꞌ, Tuhan sin bangsa Israil, sabab pagkitaꞌ niya sin kahālan sin manga tau sukuꞌ niya, tiyabang niya sila bat sila mapuas dayn ha manga dusa nila. ");
INSERT INTO tsg_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Parāhan niya kitaniyu hambuuk Manglalappas makawasa. Hambuuk siya panubuꞌ hi Daud, īpun sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Piyasampay sin manga kanabihan suchi sin jaman nakauna in janjiꞌ niya kātuꞌniyu, ");
INSERT INTO tsg_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","sin lappasun niya kitaniyu dayn ha manga banta taniyu, iban dayn ha kawasa sin manga katān marugal kātuꞌniyu. ");
INSERT INTO tsg_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Biyaꞌ na sin kiyajanjiꞌ niya hipakitaꞌ niya in ulung niya ha manga kamaasan natuꞌ iban tumtumun niya in paljanjian diꞌ magbaluba, amu in kiyajanjiꞌ niya kanila. ");
INSERT INTO tsg_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Siyapahan niya in janjiꞌ niya kan Ibrahim amu in nanubuꞌ ha kamaasan taniyu, sin lappasun niya kitaniyu dayn ha manga banta taniyu, ampa kitaniyu makahinang sin daakan sin Tuhan ha wayruun bugaꞌ taniyu, ");
INSERT INTO tsg_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ha supaya ha salugay taniyu buhiꞌ, suchi in lawm atay taniyu iban mabuntul in kawl-piil taniyu huminang sin daakan sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","In ikaw, Utuꞌ, gulalun hambuuk nabi sin Tuhan Mahatinggi. Muna kaw dayn ha Panghuꞌ magsakap sin labayan niya. ");
INSERT INTO tsg_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ikaw in mamaytaꞌ ha manga tau sukuꞌ niya sin malappas sila, bang sila mangayuꞌ kaampunan sin manga dusa nila. ");
INSERT INTO tsg_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","In Tuhan natuꞌ bayngꞌulungun iban makasi-malasa. Pakariun niya mari kātuꞌniyu in kasawahan dayn ha surgaꞌ amu in makarihil kalappasan kātuꞌniyu, ");
INSERT INTO tsg_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","iban sumilak in kasawahan yan pa katān ha lawm katigidluman, amu in manga tau mabugaꞌ mapatay, iban manghinduꞌ kātuꞌniyu sin dān pa kasannyangan.” ");
INSERT INTO tsg_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Na, simulig na in bataꞌ-bataꞌ iban simūng na in pamikil niya. Duun siya naghulaꞌ ha hulaꞌ paslangan mahunit paghulaan sampay naabut na in waktu gimuwaꞌ na siya pa mayran magnasīhat ha manga tau Israil. ");
INSERT INTO tsg_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Manjari ha masa yadtu hi Agustus, amu in Sultan sin hulaꞌ Rūm, nagꞌuldin sin subay in tau katān ha kahulaꞌ-hulaan, amu in ha babaan sin pamarinta sin hulaꞌ Rūm, magpalista sin ngān nila. ");
INSERT INTO tsg_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Na, amu ini in tagnaan sin pagpalista sin manga ngān ha waktu hi Kirini in gubnul ha hulaꞌ Siriya. ");
INSERT INTO tsg_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Na, in tau katān pakaniya-pakaniya miyadtu na pa hulaꞌ amu in luggiyaꞌ hulaan sin tau nanubuꞌ kanila, nagpasulat sin ngān nila. ");
INSERT INTO tsg_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Na, in hi Yusup timukad dayn ha kawman Nasarit, ha hulaꞌ Jalil. Miyadtu siya pa kawman Baytlaham, ha Yahudiya, amu in hulaꞌ kiyapagꞌanakan kan Sultan Daud. Miyadtu hi Yusup sabab in siya hambuuk panubuꞌ hi Daud. ");
INSERT INTO tsg_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Miyadtu siya nagꞌagad iban sin tunang niya hi Mariyam nagpasulat sin ngān nila. Na, in hi Mariyam burus na, ");
INSERT INTO tsg_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","iban ha saꞌbu nila duun ha Baytlaham miyabut na in waktu sin pagꞌanak niya. ");
INSERT INTO tsg_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nagꞌanak siya hambuuk bataꞌ-bataꞌ usug, amu in panganay niya. Sīuban niya in bataꞌ-bataꞌ ampa niya piyakulang ha lawm tuung pagbubutangan kakaun sin manga hayup, sabab wayruun na lugal kabutangan nila ha manga bāy paghahantian didtu. ");
INSERT INTO tsg_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na, sin dūm yadtu awn manga magꞌiipat bili-bili duun ha lugal pagꞌiipatan hayup sin Baytlaham, in nagjajaga sin buyanan bili-bili nila. ");
INSERT INTO tsg_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sakali awn hambuuk malāikat diyaak sin Tuhan nagpanyataꞌ mawn kanila. Kiyasawahan sila sin sahaya sin Tuhan. Landuꞌ tuud sila miyugaꞌ, ");
INSERT INTO tsg_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","sagawaꞌ laung sin malāikat kanila, “Ayaw kamu mabugaꞌ! Miyari aku nagdā sin baytaꞌ marayaw kaniyu, amu in makarihil kakuyagan dakulaꞌ ha tau katān. ");
INSERT INTO tsg_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ha adlaw ini duun ha luggiyaꞌ kawman hi Daud, piyagꞌanak in Manglalappas kaniyu. Siya in Almasi amu in Panghuꞌ! ");
INSERT INTO tsg_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na, ini in tandaꞌ sin kasabunnalan sin baytaꞌ yan, kabaakan niyu in bataꞌ-bataꞌ piyuputus sin lampin duun nagkukulang ha lawm tuung pagkakaunan sin manga hayup.” ");
INSERT INTO tsg_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Sakali nagtaghaꞌ awn salaksaꞌ malāikat dayn ha surgaꞌ in nagpanyataꞌ mawn miyagad ha malāikat yaun nagpudji pa Tuhan. Amu agi nila, ");
INSERT INTO tsg_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Pudjihun natuꞌ in Tuhan ha surgaꞌ iban awn na kasannyangan sin manga tau ha dunya, amu in sasukuꞌ sin makasulut kaniya!” ");
INSERT INTO tsg_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Na, nagbalik mayan in manga malāikat pa surgaꞌ, laung sin manga magꞌiipat bili-bili pakaniya-pakaniya, “Sūng kitaniyu pa Baytlaham nyumataꞌ sin pakaradjaan naawn amu in biyaytaꞌ kātuꞌniyu sin Panghuꞌ natuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Na, miyadtu na sila nagꞌūs-ꞌūs. Kiyabaakan nila hi Mariyam kay Yusup iban kītaꞌ nila in bataꞌ-bataꞌ nagkukulang duun ha lawm tuung pagkakaunan sin manga hayup. ");
INSERT INTO tsg_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pagkitaꞌ nila mayan ha bataꞌ-bataꞌ, biyaytaꞌ nila na in baytaꞌ sin malāikat pasal sin bataꞌ-bataꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Na, nahaylan tuud in katān nakarungug sin baytaꞌ sin manga magꞌiipat bili-bili. ");
INSERT INTO tsg_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tiyutumtum hi Mariyam in katān kītaꞌ iban diyungug niya pasal sin anak niya, iban kiyakannal-kannal niya ha lawm atay niya. ");
INSERT INTO tsg_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Na, nagbalik na in manga magꞌiipat bili-bili pa lugal nila ampa nila liyagguꞌ iban piyudji in Tuhan, sabab sin katān diyungug iban kītaꞌ nila. Nagkugdan tuud in kiyabaytaꞌ kanila sin malāikat iban sin kītaꞌ nila. ");
INSERT INTO tsg_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Manjari, naabut mayan walu adlaw ha guwaꞌ in bataꞌ-bataꞌ, piyaislam na iban ngiyānan nila na siya hi Īsa, sabab amu yan in ngān hipangān kaniya sin malāikat ha walaꞌ pa siya piyagburus. ");
INSERT INTO tsg_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Sakali naabut na in adlaw natapus na hi Mariyam dayn ha pagꞌanakan, miyadtu siya kay Yusup pa Bāy sin Tuhan ha Awrusalam (Baytal Makdis) naghinang sin pakaradjaan pagsuchi sin babai natapus na dayn ha pagꞌanakan, sabab amu yan in saraꞌ daakan sin Tuhan piyanaug dayn kan Musa. Diyā nila da isab in bataꞌ-bataꞌ ha supaya hikaungsud pa Tuhan, ");
INSERT INTO tsg_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","sabab kiyasulat in saraꞌ daakan sin Tuhan, amu agi, “In katān anak usug panganay subay hiungsud pa Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Dimihil da isab sila piyagkulbanan biyaꞌ sin kiyabaytaꞌ sin saraꞌ daakan sin Tuhan sin subay magꞌungsud pagkukulbanan duwa māpati atawa duwa assang asibiꞌ pa. ");
INSERT INTO tsg_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na, ha waktu yadtu awn hambuuk tau pagngānan hi Simiyun duun naghuhulaꞌ ha Awrusalam (Baytal Makdis). In siya ini hambuuk tau mabuntul iban nagtataat tuud pa Tuhan. Nagtatagad siya sin waktu dumatung in Manglalappas ha manga tau Israil. Hiyuhūp siya sin Rū sin Tuhan, ");
INSERT INTO tsg_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","amu in dimihil kaniya katantuhan sin diꞌ siya mapatay ha salugay diꞌ niya kakitaan in Almasi, amu in kiyajanjiꞌ palahilun sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Sakali sin adlaw yadtu piyakadtu sin Rū sin Tuhan hi Simiyun pa Bāy sin Tuhan. Na, diyā mayan sin manga maas niya hi Īsa pa bāy supaya sila makahinang sin kiyawajib kanila sin saraꞌ agama pasal sin bataꞌ-bataꞌ, ");
INSERT INTO tsg_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","kītaꞌ sila hi Simiyun. Kiyawaꞌ hi Simiyun in bataꞌ-bataꞌ iyampupu, ampa siya nagsarang-sukul pa Tuhan, laung niya, ");
INSERT INTO tsg_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ya Tuhan, Panghuꞌ, in aku īpun mu. Bihaun minsan mu aku salayun na iban sin nyawa ku lillaꞌ na aku, sabab naagad na in janjiꞌ mu kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Karnaꞌ kītaꞌ ku na iban sin duwa mata ku in piyarā mu mari amu in manglalappas ha manga mānusiyaꞌ sin dusa nila. ");
INSERT INTO tsg_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Piyakari mu siya bat supaya siya kakitaan sin mānusiyaꞌ katān. ");
INSERT INTO tsg_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Siya in biyaꞌ sapantun ilaw dumihil kasawahan ha manga tau bukun bangsa Yahudi, iban siya in dumihil kalagguan ha manga tau sukuꞌ mu, tau Israil.” ");
INSERT INTO tsg_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nainu-inu tuud in inaꞌ-amaꞌ hi Īsa pagdungug nila sin manga lapal-kabtangan hi Simiyun pasal sin bataꞌ-bataꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Piyangayuan sila hi Simiyun duwaa pa Tuhan iban laung niya kan Mariyam, “In bataꞌ-bataꞌ ini amu in asal giyantaꞌ sin Tuhan mahinang puun-sabab sin kalappasan iban kamulahan sin manga kamatauran tau Israil. Siya in hambuuk tandaꞌ dayn ha Tuhan amu in hisulak sin kamatauran sin mānusiyaꞌ, ");
INSERT INTO tsg_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","sabab siya in makapatampal sin manga pikilan ha lawm atay nila. Ampa in ikaw lumanduꞌ tuud in kasusahan mu pasal niya. Mahansul tuud in atay mu. In nanam mu biyaꞌ kaw sin kiyugdan sin sulab pakukus mahait.” ");
INSERT INTO tsg_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Manjari awn isab hambuuk nabi maas babai balu in duun ha Bāy sin Tuhan. In ngān niya hi Anna. Anak siya hi Panuwil dayn ha hambuuk pihak Israil amu in pagngānan Asir. Pitu tahun in lugay niya nagtiyaun iban sin bana niya ampa siya nabalu. Na, bihaun awn na kawaluan tagꞌupat tahun in umul niya. Diꞌ siya magꞌīg dayn ha Bāy sin Tuhan. Dūm-adlaw duun siya magtaat pa Tuhan. Daran siya mangarap pa Tuhan iban nagpupuasa. ");
INSERT INTO tsg_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na, nākawn isab siya ha saꞌbu hi Simiyun nagbichara kay Mariyam iban hi Yusup. Nagsarang-sukul da isab siya pa Tuhan iban biyaytaan niya isab in katān tau sin pasal sin bataꞌ-bataꞌ. In manga tau ini nagtatagad sin waktu lappasun sin Tuhan in manga tau Awrusalam (Baytal Makdis). ");
INSERT INTO tsg_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Na, pagga naubus na hīnang hi Yusup kay Mariyam in kiyawajib kanila sin saraꞌ daakan sin Tuhan, minuwiꞌ na sila pa luggiyaꞌ hulaan nila ha kawman Nasarit duun ha Jalil. ");
INSERT INTO tsg_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Simulig na in bataꞌ-bataꞌ iban kimusug siya. Halul-akkal tuud siya iban dīhilan siya barakat sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na, sakabaꞌ tahun in maas hi Īsa magkawn pa Awrusalam (Baytal Makdis) sumaꞌbu sin Haylaya Paglappas dayn ha Kamatay. ");
INSERT INTO tsg_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sakali pagga miyabut na hi Īsa hangpuꞌ tagduwa tahun miyagad siya ha maas niya madtu pa Awrusalam (Baytal Makdis) sumaꞌbu sin Paghaylaya biyaꞌ sin pagkabiyaksahan nila. ");
INSERT INTO tsg_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Na, naubus mayan in paghaylaya, minuwiꞌ na sila, sagawaꞌ nagpabīn hi Īsa ha Awrusalam (Baytal Makdis) ha walaꞌ kiyaingatan sin maas niya. ");
INSERT INTO tsg_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","In pangannal nila miyamagad hi Īsa ha manga kamatauran sin tau. Na, nakapanaw na sila hangka-adlaw timpus ampa sila naglawag kan Īsa pa manga kakampungan iban kabagayan nila. ");
INSERT INTO tsg_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Walaꞌ mayan nila siya kiyabaakan, nagbalik sila madtu pa Awrusalam (Baytal Makdis) naglawag kaniya. ");
INSERT INTO tsg_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ha hikatū sin adlaw kiyabaakan nila siya duun ha lawm Bāy sin Tuhan naglilingkud iban sin manga guru sin saraꞌ agama. Dimurungug siya iban nangangasubu siya. ");
INSERT INTO tsg_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","In katān nakarungug kaniya nainu-inu tuud sin ingat niya sumambung. ");
INSERT INTO tsg_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kiyublaan in manga maas niya pagkitaꞌ nila kaniya, iban laung sin inaꞌ niya, “Utuꞌ, maytaꞌ mu kami hīnang biyaꞌ ha ini? Nagsusa tuud kami kay amaꞌ mu naglawag kaymu.” ");
INSERT INTO tsg_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","In sambung niya kanila, “Maytaꞌ kamu subay maglawag kākuꞌ? Walaꞌ niyu kiyaingatan sin subay aku dī ha bāy sin Amaꞌ ku?” ");
INSERT INTO tsg_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Sagawaꞌ walaꞌ nila kiyahātihan in maana sin sambung niya. ");
INSERT INTO tsg_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pagꞌubus miyagad na hi Īsa kanila minuwiꞌ pa Nasarit iban nagkahagad siya sin agihan sin maas niya. In katān naawn yan biyaꞌ sapantun altaꞌ tiyatawꞌ sin inaꞌ niya ha lawm pamikil niya. ");
INSERT INTO tsg_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Na, simulig na in baran hi Īsa iban simūng in lawm sin ingat niya. Simūng da isab in lasa sin manga tau kaniya labi awla na in Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Manjari, ha hikahangpuꞌ taglima tahun sin pagsultan hi Tibirus, amu in sultan sin bangsa Rūm, hi Puntus Pilatu in naggubnul ha Yahudiya. In hi Hirud kiyarihilan kawasa namarinta ha Jalil, hāti in taymanghud niya hi Pilip in namarinta ha hulaꞌ Ituriya iban Tarakunit, iban hi Lisani in namarinta ha Abilin. ");
INSERT INTO tsg_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hāti hi Annas kay Kayapas in manga imam dakulaꞌ. Na, ha waktu yadtu amu in kanaug sin Parman sin Tuhan mawn kan Yahiya, anak hi Jakariyas. Didtu siya naghulaꞌ ha hulaꞌ paslangan mahunit paghulaan. ");
INSERT INTO tsg_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Na, hangkan, miyanaw hi Yahiya naglatag sin kahulaꞌ-hulaan ha katilibut sin Subaꞌ Jurdan nagpamahalayak sin daakan sin Tuhan ha manga tau, laung niya, “Pagtawbati niyu na in manga dusa niyu iban pagpaliguꞌ kamu, amu in tandaꞌ sin pagtawbat niyu, ampa ampunun sin Tuhan in manga dusa niyu.” ");
INSERT INTO tsg_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","In pasal hi Yahiya ini asal kiyasulat hi Nabi Isayas ha lawm Kitab, amu agi, “Awn manawag-tawag ha hulaꞌ paslangan mahunit paghulaan, amu agi, ‘Masuuk na dumatung in Panghuꞌ. Sakapa niyu in dān labayan niya. Pabuntula niyu in dān panawan niya! ");
INSERT INTO tsg_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","In katān lubbak subay patagun. In manga būd-būd iban kabūd-būran subay pantayun. In manga dān bingkuk subay pabuntulun, iban in manga dān naglulubbak subay bunbunan. ");
INSERT INTO tsg_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na, kakitaan sin mānusiyaꞌ katān bang biyaꞌ diin in paglappas sin Tuhan kanila!’” ");
INSERT INTO tsg_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Na, mataud tuud tau in miyawn nagpaliguꞌ kan Yahiya, sagawaꞌ piyagꞌamahan niya sila, laung niya, “In kamu yan panipu! Magpabawꞌ-bawꞌ sadja kamu mabuntul, sagawaꞌ bingkuk in lawm atay niyu. Na, in pangannal niyu makapuas kamu dayn ha murkaꞌ sin Tuhan, amu in masuuk na dumatung, bang kamu magpaliguꞌ? ");
INSERT INTO tsg_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bang kamu diꞌ tuud mabayaꞌ pagmurkaan sin Tuhan pakitaan niyu dayn ha kawl-piil niyu marayaw sin piyagtawbatan niyu na tuud in manga dusa niyu. Iban ayaw kamu magpikil sin diꞌ kamu kugdanan sin murkaꞌ sin Tuhan sawkat na kamu panubuꞌ hi Ibrahim. Sabab baytaan ta kamu minsan in manga batu ini mapapanjari sin Tuhan tau hinangun panubuꞌ hi Ibrahim higantiꞌ kaniyu! ");
INSERT INTO tsg_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","In kamu yan biyaꞌ sapantun kahuy masuuk na pilaun sin kapa, tibtibun dayn ha gamut niya. Na, sasukuꞌ sin kahuy amu in diꞌ magbunga marayaw tantu pilaun da, ampa hilaruk pa lawm kāyu.” ");
INSERT INTO tsg_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Na, iyasubu siya sin manga tau, laung nila, “Bang bihādtu, unu in subay hinangun namuꞌ?” ");
INSERT INTO tsg_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","In sambung niya, “Hisiyu-siyu kamu in awn duwa badjuꞌ niya subay hipagdihil in hambuuk pa tau way kaniya, iban bang awn kakaun niyu subay kamu mamahagiꞌ ha kaibanan.” ");
INSERT INTO tsg_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","In kaibanan magkakawaꞌ sukay pa parinta miyawn nagpaliguꞌ iban nangasubu kan Yahiya, laung nila, “Tuwan, unu in subay hinangun namuꞌ?” ");
INSERT INTO tsg_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","In sambung niya, “Subay kamu diꞌ mangijib. Ayaw kamu mangawaꞌ sukay labi dayn sin ha lawm saraꞌ.” ");
INSERT INTO tsg_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Awn isab manga kaibanan sundalu nangasubu kaniya, laung nila, “Na, biyaꞌ diin in kami ini? Unu in subay hinangun namuꞌ?” In sambung niya, “Ayaw kamu manglugus atawa manglawag dusa ha manga tau bat niyu makawaꞌ in altaꞌ nila. Subay kamu mamarahi na sin gadji niyu.” ");
INSERT INTO tsg_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na, timagnaꞌ na nabuhiꞌ in huwat-huwat sin manga tau pasal sin manglalappas kanila. Nagꞌinu-inu na sila pasal hi Yahiya. In pangannal nila marayꞌ hi Yahiya na in Almasi, amu in tiyatagaran sin bangsa Israil manglalappas kanila. ");
INSERT INTO tsg_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Hangkan laung hi Yahiya kanila katān, “In aku in hipangliguꞌ ku kaniyu tubig, sagawaꞌ awn dugaing dumatung mari sumunud kākuꞌ amu in labi mataas in kawasa dayn kākuꞌ. Diꞌ aku minsan tūpun humubad sin hukut tawmpaꞌ niya. Patulunan niya in kaibanan tau sin Rū sin Tuhan, iban siya da isab in magparatung murkaꞌ pa kaibanan. ");
INSERT INTO tsg_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Biyaꞌ siya sin hambuuk tau magtahap iban maghawan sin pāy bakas piyaggiikan niya. Pagꞌubus ampa niya hitawꞌ in unud ha pagtatawꞌan niya. Hāti in apa iban sin manga kaput, hilaruk pa lawm kāyu diꞌ magkapūng kasaumulan.” ");
INSERT INTO tsg_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mataud in ginisan bīchara hi Yahiya ha pagnasīhat niya sin Baytaꞌ Marayaw pa manga tau iban ha paghinduꞌ niya kanila magpinda sin kawl-piil nila. ");
INSERT INTO tsg_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Sagawaꞌ in hi Gubnul Hirud piyagꞌamahan hi Yahiya sabab iyasawa hi Hirud hi Hirudiya, amu in asawa sin taymanghud niya. Iban mataud pa isab manga kangīan dugaing nahinang niya. ");
INSERT INTO tsg_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Na, gām mayan siyūngan hi Hirud in ngīꞌ sin hinang niya. Piyajīl niya hi Yahiya. ");
INSERT INTO tsg_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Manjari, ha walaꞌ pa najīl hi Yahiya, mataud tau in naliguꞌ niya. Līguꞌ niya da isab hi Īsa. Sakali pagꞌubus hi Īsa līguꞌ, ha saꞌbu niya nangangayuꞌ duwaa, naukab in lawang langit, ");
INSERT INTO tsg_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","iban in Rū sin Tuhan, nimaug mawn kaniya nagpasalupa assang. Sartaꞌ awn na diyungug nila suwara dayn ha langit, amu agi, “Ikaw in Anak ku kalasahan. Kiyasulutan tuud aku kaymu.” ");
INSERT INTO tsg_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Manjari in hi Īsa timagnaꞌ na nagnasīhat naabut mayan manga katluan tahun na in umul niya. In pangannal sin manga tau in hi Īsa anak tuud hi Yusup, amu in ugangan hi Hili (amaꞌ hi Mariyam). ");
INSERT INTO tsg_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","In hi Hili anak hi Mattat. In hi Mattat anak hi Libi. In hi Libi anak hi Malki. In hi Malki anak hi Janni. In hi Janni anak hi Yusup. ");
INSERT INTO tsg_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","In hi Yusup anak hi Mattati. In hi Mattati anak hi Amus. In hi Amus anak hi Nahum. In hi Nahum anak hi Isli. In hi Isli anak hi Naggay. ");
INSERT INTO tsg_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","In hi Naggay anak hi Maat. In hi Maat anak hi Mattati. In hi Mattati anak hi Simain. In hi Simain anak hi Yusik. In hi Yusik anak hi Juda. ");
INSERT INTO tsg_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","In hi Juda anak hi Juwannan. In hi Juwannan anak hi Risa. In hi Risa anak hi Sirubbabil. In hi Sirubbabil anak hi Salati. In hi Salati anak hi Niri. ");
INSERT INTO tsg_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","In hi Niri anak hi Malki. In hi Malki anak hi Addi. In hi Addi anak hi Kusam. In hi Kusam anak hi Ilmadam. In hi Ilmadam anak hi Ir. ");
INSERT INTO tsg_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","In hi Ir anak hi Yussaꞌ. In hi Yussaꞌ anak hi Ilisir. In hi Ilisir anak hi Jurim. In hi Jurim anak hi Mattat. In hi Mattat anak hi Libi. ");
INSERT INTO tsg_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","In hi Libi anak hi Simiyun. In hi Simiyun anak hi Yudah. In hi Yudah anak hi Yusup. In hi Yusup anak hi Junam. In hi Junam anak hi Iliyakim. ");
INSERT INTO tsg_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","In hi Iliyakim anak hi Miliya. In hi Miliya anak hi Minna. In hi Minna anak hi Mattata. In hi Mattata anak hi Natan. In hi Natan anak hi Daud. ");
INSERT INTO tsg_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","In hi Daud anak hi Jissi. In hi Jissi anak hi Ubid. In hi Ubid anak hi Buwas. In hi Buwas anak hi Salmun. In hi Salmun anak hi Nassun. ");
INSERT INTO tsg_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","In hi Nassun anak hi Amminadab. In hi Amminadab anak hi Admin. In hi Admin anak hi Arni. In hi Arni anak hi Hisdun. In hi Hisdun anak hi Piris. In hi Piris anak hi Yudah. ");
INSERT INTO tsg_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","In hi Yudah anak hi Yaꞌkub. In hi Yaꞌkub anak hi Isahak. In hi Isahak anak hi Ibrahim. In hi Ibrahim anak hi Tira. In hi Tira anak hi Nahur. ");
INSERT INTO tsg_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","In hi Nahur anak hi Sirug. In hi Sirug anak hi Raga. In hi Raga anak hi Pilig. In hi Pilig anak hi Ibir. In hi Ibir anak hi Sala. ");
INSERT INTO tsg_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","In hi Sala anak hi Kaynan. In hi Kaynan anak hi Arpaksad. In hi Arpaksad anak hi Sim. In hi Sim anak hi Nū. In hi Nū anak hi Lamik. ");
INSERT INTO tsg_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","In hi Lamik anak hi Mitusala. In hi Mitusala anak hi Idris. In hi Idris anak hi Jarid. In hi Jarid anak hi Mahalalil. In hi Mahalalil anak hi Kinan. ");
INSERT INTO tsg_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","In hi Kinan anak hi Inus. In hi Inus anak hi Sit. In hi Sit anak hi Adam. In hi Adam anak sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Manjari in hi Īsa hiyūp sin Rū sin Tuhan. Pagbalik niya dayn ha Subaꞌ Jurdan diyā siya sin Rū sin Tuhan madtu pa hulaꞌ paslangan mahunit paghulaan. ");
INSERT INTO tsg_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Duun siya siyasat sin Iblis ha lawm kaꞌpatan adlaw. Ha salugay niya didtu wayruun unu-unu nakaun niya. Hangkan pagꞌubus sin kaꞌpatan adlaw hiyapdiꞌ na hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Laung sin Iblis kaniya, “Bang kaw bunnal amuna in Anak Tuhan, daaka in manga batu ini mahinang kakaun.” ");
INSERT INTO tsg_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Na, in sambung kaniya hi Īsa, “Kiyasulat ha lawm Kitab in Parman sin Tuhan, amu agi, ‘In mānusiyaꞌ diꞌ mabuhiꞌ sin kakaun sadja.’” ");
INSERT INTO tsg_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sakali diyā siya sin Iblis pa lugal mataas, ampa piyakitaꞌ kaniya hangka-kullap mata da in katān kahulaꞌ-hulaan ha lawm dunya. ");
INSERT INTO tsg_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Laung sin Iblis kan Īsa, “Hirihil ku kaymu in katān kawasa iban sin katān daya ha kahulaꞌ-hulaan yan. Karnaꞌ in manga yan kiyaungsud pa lawm lima ku iban hikarihil ku ha hisiyu-siyu kabayaan ku dihilan. ");
INSERT INTO tsg_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","In katān yan hirihil ku kaymu bang kaw sumujud sumumba kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","In sambung hi Īsa kaniya, “Kiyasulat ha lawm Kitab, amu agi, ‘Subay hambuuk-buuk Tuhan, Panghuꞌ niyu in sumbahun iban pagtagꞌīpunan niyu!’” ");
INSERT INTO tsg_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pagꞌubus diyā siya sin Iblis pa Awrusalam (Baytal Makdis), ampa siya piyasakat pa puntuk sin Bāy sin Tuhan. Laung sin Iblis kaniya, “Bang kaw bunnal amu na in Anak Tuhan, tugpaꞌ kaw dayn ha taas sin puntuk ini pa babaꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Karnaꞌ kiyasulat ha lawm Kitab, amu agi, ‘Daakun sin Tuhan in manga malāikat magparuli iban magjaga kaymu.’ ");
INSERT INTO tsg_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Iban kiyabaytaꞌ pa isab, amu agi, ‘Tayakun nila kaw ha supaya in siki mu diꞌ kumugdan pa manga batu.’” ");
INSERT INTO tsg_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Sagawaꞌ in sambung hi Īsa, “Kiyabaytaꞌ ha lawm Kitab, amu agi, ‘Subay niyu diꞌ dustaun in Tuhan, amu in Panghuꞌ niyu.’” ");
INSERT INTO tsg_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sakali naubus mayan siyasat sin Iblis hi Īsa sin ginis-ginisan, minīg na siya. Tagaran niya ha waktu dugaing. ");
INSERT INTO tsg_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Na, nagbalik na hi Īsa pa Jalil. Hiyuhūp siya sin Rū sin Tuhan amu in dimirihil kaniya kusug. In suysuy pasal niya nalatag ha katilingkal sin hulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Naghinduꞌ siya ha manga langgal iban liyagguꞌ siya sin katān. ");
INSERT INTO tsg_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Sakali miyadtu hi Īsa pa Nasarit amu in kawman siyuligan niya. Pagꞌabut adlaw Sabtuꞌ, amu in adlaw paghahali-hali iban pagpudji pa Tuhan, miyadtu hi Īsa pa langgal biyaꞌ sin kiyabiyaksahan niya. Timindug siya nagbacha sin Kitab. ");
INSERT INTO tsg_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Diyuhal mawn kaniya in sulat liyulūn siyulat hi Nabi Isayas. Na, pagbuklad niya sin sulat liyulūn kiyabaakan niya in manga bichara kiyasulat, amu agi, ");
INSERT INTO tsg_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Hiyuhūp aku sin Rū sin Tuhan sabab aku in napīꞌ niya magpamahalayak sin Baytaꞌ Marayaw pa manga miskin. Aku in naraak dumā sin kamahardikaan ha manga tau napipilisu iban dumihil pangitaꞌ ha manga buta. Aku in dumihil kalimāyahan ha manga napipissukuꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Aku in magpahāti sin dimatung na in waktu lappasun na sin Tuhan in manga tau sukuꞌ niya.” ");
INSERT INTO tsg_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Na, pagꞌubus liyūn hi Īsa in sulat ampa niya diyuhal nagbalik pa hambuuk daraakun ha langgal ampa siya limingkud. Na, in tau katān ha lawm langgal nahambuuk in pangatud mawn kaniya. ");
INSERT INTO tsg_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Namung mayan siya, laung niya, “Na, in kiyasulat ha lawm Kitab amu in diyungug niyu biyacha ku hayn-duun, nabunnal ha adlaw ini ha saꞌbu kamu dimurungug.” ");
INSERT INTO tsg_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Na, kiyaamuhan tuud in katān kaniya, sagawaꞌ nainu-inu tuud sila sin dayaw sin manga lapal-kabtangan niya. Laung nila, “Bukun ka in siya yan anak hi Yusup?” ");
INSERT INTO tsg_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Laung niya kanila, “Natatantu ku sin pamungan niyu aku sin bichara dalil akkal. Laung niyu, ‘Bang kaw mangungubat, ubati naa muna in baran mu. Hinanga in manga hinang makainu-inu dī ha luggiyaꞌ hulaan mu amu in diyungug namuꞌ nahinang mu ha Kapirnaum.’ ");
INSERT INTO tsg_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Na, baytaan ta kamu,” laung hi Īsa, “wayruun nabi in lagguun ha luggiyaꞌ hulaan niya. ");
INSERT INTO tsg_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Dungug kamu kākuꞌ. Ha waktu nakauna yadtu, ha timpu hi Ilyas, wayruun ulan ha lawm tū tahun iban tungaꞌ iban simaplag pa kahulaꞌ-hulaan katān in gutum dakulaꞌ. Na, bunnal mataud balu bangsa Israil in ha lawm kasigpitan sin timpu yadtu. ");
INSERT INTO tsg_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Sagawaꞌ walaꞌ hi Ilyas diyaak sin Tuhan madtu tumabang minsan ha hambuuk kanila. Amura in kiyadtu hi Ilyas tiyabang in hambuuk balu bangsa dugaing naghuhulaꞌ ha Saripta duun ha hulaꞌ Sidun. ");
INSERT INTO tsg_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Iban ha timpu isab hi Nabi Ilis mataud tau naghuhulaꞌ ha Israil in īipul. Sagawaꞌ minsan hambuuk kanila wayruun kiyaulian, sagawaꞌ amura hi Naaman, tau bangsa Siriya.” ");
INSERT INTO tsg_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Na, napuspus tuud in dugal kaniya sin manga tau ha langgal pagdungug nila sin bichara niya. ");
INSERT INTO tsg_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nagtūy sila timindug ampa nila giyuyud hi Īsa pa guwaꞌ sin kawman ampa nila diyā madtu pa taas sin būd-būd amu kiyatitindugan sin manga kabāyan nila. In gantaꞌ nila hihulug nila siya ha pangpang. ");
INSERT INTO tsg_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Sagawaꞌ miyanaw siya limabay dayn ha giꞌtungan sin tau mataud ampa siya miyanaw minīg dayn kanila. ");
INSERT INTO tsg_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sakali miyadtu hi Īsa pa Kapirnaum, hambuuk kawman ha Jalil. Duun siya nagnasīhat ha langgal pagꞌabut adlaw Sabtuꞌ, adlaw paghali-hali iban pagpudji pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nainu-inu tuud in manga tau sin pagnasīhat niya, sabab in pagnasīhat niya taga kawasa tuud. ");
INSERT INTO tsg_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Sakali awn hambuuk tau duun ha langgal in siyusūd sin saytan in similawak tuud makusug. ");
INSERT INTO tsg_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Laung niya, “Uy! Unu in kabayaan mu kāmuꞌ, Īsa tau Nasarit? Mulahun mu ka kami, hangkan kaw miyari? Kaingatan ku bang hisiyu kaw. Ikaw in hambuuk-buuk suchi naraak sin Tuhan!” ");
INSERT INTO tsg_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Na, piyagꞌamahan hi Īsa in saytan, laung niya, “Hipus kaw iban guwaꞌ kaw dayn ha lawm baran sin tau yan!” Na, hiyantak sin saytan in tau, ubus ampa siya gimuwaꞌ, saꞌ walaꞌ niya da isab iyunu in tau. Duun in manga tau nagkikitaꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Na, nainu-inu tuud in manga tau katān iban laung sin pakaniya-pakaniya, “Ay kaw, unu bahaꞌ in manga kabtangan niya yan? In tau ini taga kawasa iban kusug magbayaꞌ ha manga saytan magpaguwaꞌ dayn ha baran sin tau, iban magkahagad in manga saytan kaniya!” ");
INSERT INTO tsg_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na, in suysuy pasal hi Īsa simaplag pa katilibut sin hulaꞌ yan. ");
INSERT INTO tsg_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pagꞌubus gimuwaꞌ na hi Īsa dayn ha langgal ampa siya timūy madtu pa bāy hi Simun (Pitrus). Sakali in ugangan hi Simun babai kiyakansangan tuud sin hinglaw. Na, biyaytaan nila hi Īsa pasal niya. ");
INSERT INTO tsg_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Na, miyadtu hi Īsa timindug ha daig sin kulangan niya ampa siya nagkabtangan. Na, saruun-duun naīg in hinglaw niya sartaꞌ magtūy siya timindug ampa niya sila biyutangan kakaun. ");
INSERT INTO tsg_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Sakali simadlup mayan in suga miyawn in manga tau kan Īsa nagdā sin manga bagay nila nasasakit sin sakit ginis-ginisan. Na, kiyamputan hi Īsa in manga tau katān nasasakit sartaꞌ kiyaulian niya sila katān. ");
INSERT INTO tsg_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Napaguwaꞌ niya da isab in manga saytan dayn ha lawm baran sin manga tau. Nagsilawak in manga saytan, laung nila, “Ikaw in Anak Tuhan!” Sagawaꞌ piyagꞌamahan hi Īsa in manga saytan iban walaꞌ niya sila piyapagbichara sabab kiyaiingatan nila sin hi Īsa amuna in Almasi. ");
INSERT INTO tsg_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Manjari, pagꞌadlaw hambuuk, lapit adlaw pa minīg na hi Īsa dayn ha kawman yaun, ampa siya miyadtu pa lugal way bahittuk. Sakali liyawag siya sin manga tau. Kiyabaakan nila mayan siya, hiyawiran nila siya diꞌ papaīgun. ");
INSERT INTO tsg_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Sagawaꞌ laung niya kanila, “Subay aku madtu pa manga dugaing kawman magnasīhat isab sin Baytaꞌ Marayaw pasal sin pamarinta sin Tuhan, sabab amu yan in maksud sin Tuhan nagpakari kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Na, nagnasīhat siya ha manga langgal ha katilingkal sin hulaꞌ Yahudiya. ");
INSERT INTO tsg_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Manjari hambuuk adlaw duun hi Īsa nagtitindug ha higad sin Dagat Ginnisarit nagnasīhat ha manga tau. Similut iban nagdigpit in manga tau. In kabayaan nila sumuuk kan Īsa bat sila makarungug sin Parman sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Sakali kītaꞌ hi Īsa in duwa kumpit asibiꞌ diyahik pa higad buhangin sin manga magꞌiistaꞌ. In duwa kumpit yan binīn nila sabab miyadtu sila naghugas sin manga laya nila. ");
INSERT INTO tsg_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Na, simakat hi Īsa pa hambuuk kumpit asibiꞌ, ampa niya diyaak hi Simun, amu in tagdapu sin kumpit asibiꞌ, hipapatulak in kumpit hangkatiyuꞌ dayn ha higad buhangin. Pagꞌubus ampa hi Īsa limingkud ha taas kumpit asibiꞌ nagnasīhat ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pagꞌubus niya mayan nagnasīhat, laung niya kan Simun, “Bugsayi pa lawd in kumpit ampa kaw paglaya iban sin manga iban mu.” ");
INSERT INTO tsg_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","In sambung hi Simun, “Aruy, Tuwan, in pagtuyuꞌ namuꞌ naglaya tingpus hangka-dūm, sagawaꞌ wayruun da nakawaꞌ namuꞌ. Sagawaꞌ pagga isab amu in agihan mu, na maglaya kami magbalik.” ");
INSERT INTO tsg_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Na, hiyulug nila pa dagat in manga laya nila. Pagꞌutung nila, agun-agun na magirit in manga laya nila sin taud sin istaꞌ nakawaꞌ nila. ");
INSERT INTO tsg_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hangkan sīnyalan nila in manga panāiban nila ha hambuuk kumpit pakawnun tumabang kanila. Na, miyawn sila timabang. Nahipuꞌ tuud sin istaꞌ in karuwa kumpit nila, hangkan agun-agun na malunud in kumpit nila. ");
INSERT INTO tsg_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pagkitaꞌ hi Simun Pitrus sin nahinang hi Īsa, limuhud siya ha alupan hi Īsa ampa siya namung, laung niya, “Lawak kaw dayn kākuꞌ, Panghuꞌ, sabab in aku ini baldusa!” ");
INSERT INTO tsg_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Karnaꞌ in siya iban sin katān iban niya landuꞌ tuud nainu-inu sin taud sin istaꞌ nakawaꞌ nila. ");
INSERT INTO tsg_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Damikkiyan, nainu-inu da isab in manga panāiban hi Simun, hi Yaꞌkub kay Yahiya, manga anak hi Sibidi. Laung hi Īsa kan Simun, “Ayaw kamu mabugaꞌ. Tagnaan bihaun bukun na kamu mangingistaꞌ, sagawaꞌ magdā-rā ha manga tau paagarun kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pagꞌubus diyahik nila na in manga kumpit asibiꞌ pa higad buhangin. Binīn nila na in katān duun ampa sila miyagad kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Manjari hambuuk waktu duun hi Īsa ha lawm sin hambuuk kawman. Sakali awn duun hambuuk tau malugay na īipul. Nalatag in baran niya sin ipul. Pagkitaꞌ niya kan Īsa magtūy siya simujud, ampa siya jimunjung nangayuꞌ kan Īsa, laung niya, “Tuwan, mapauliꞌ mu aku bang mu kabayaan kaulian aku!” ");
INSERT INTO tsg_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Na, biyutang hi Īsa in lima niya pa tau īipul sartaꞌ imiyan siya, laung niya, “Kabayaan ku kaulian na in sakit mu. Lumanuꞌ na in pais mu!” Na, saruun-duun naīg in ipul niya. ");
INSERT INTO tsg_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sakali biyandaan siya hi Īsa, amu agi kaniya, “Ibut-ibut kaymu, ayaw kaw tuud magbaytaꞌ minsan kansiyu pasal sin pagpauliꞌ ku kaymu. Sagawaꞌ kadtu kaw magtūy pa imam, ampa mu palilingan in baran mu kaniya. Pagꞌubus ampa kaw kadtu ungsud sin pagkulbanan amu in daakan hi Musa, ha supaya awn tandaꞌ kakitaan sin manga tau katān sin kiyaulian na kaw.” ");
INSERT INTO tsg_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Sagawaꞌ gām mayan na simaplag in suysuy pasal hi Īsa, iban mataud tuud tau in miyawn dumungug sin nasīhat niya iban magpauliꞌ sin sakit nila. ");
INSERT INTO tsg_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Sagawaꞌ kamawmuhan mīg hi Īsa dayn ha manga tau ampa siya madtu mangarap pa Tuhan ha lugal way tau naghuhulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Manjari hambuuk adlaw ha saꞌbu hi Īsa nanghihinduꞌ, awn manga Parisi iban guru sin saraꞌ agama luruk dayn ha manga kakawm-kawman sin Jalil, Yahudiya, iban dayn ha dāira Awrusalam (Baytal Makdis) in duun limilingkud. Yaun kan Īsa in kusug sin kawasa sin Tuhan magpauliꞌ ha manga nasasakit. ");
INSERT INTO tsg_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Sakali awn manga tau miyawn nagdarā sin tau nagpapatay in baran niya. Siyulayan nila simūd pa lawm bāy bat nila hikabutang in nasasakit ha alupan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Sagawaꞌ wayruun tuud dapat nila sumūd sabab nadagsuk sin tau in lawm bāy. Hangkan simakat sila pa taas atup sin bāy ampa nila inīgan in kaibanan atup. Ubus ampa nila tiyuntun in nasasakit iban sin kulangan niya pa lawm bāy, pa giꞌtungan sin manga tau ha alupan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Pagkitaꞌ mayan hi Īsa sin makusug in pangandul nila, laung niya ha nasasakit, “Bagay ku, iyampun na in manga dusa mu.” ");
INSERT INTO tsg_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pagdungug sin manga guru sin saraꞌ agama iban sin manga Parisi sin bichara hi Īsa, naghunaꞌ-hunaꞌ na sila, laung nila, “Hisiyu taꞌ in tau ini magbichara sin pangkal pa Tuhan? Hambuuk-buuk da Tuhan in makaampun sin manga dusa sin mānusiyaꞌ!” ");
INSERT INTO tsg_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Na, kiyatalusan hi Īsa bang unu in piyaghunaꞌ-hunaꞌ nila. Hangkan laung niya kanila, “Maytaꞌ kamu maghunaꞌ-hunaꞌ sin biyaꞌ ha yan? ");
INSERT INTO tsg_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Na, ha pikil niyu unu in maluhay hipamung ha tau, bang aku umiyan, ‘Iyampun na in manga dusa mu,’ atawa umiyan ha tau nasasakit, ‘Bangun kaw ampa kaw panaw’? ");
INSERT INTO tsg_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Na, dihilan ta kamu tandaꞌ sin in aku amu in Anak Mānusiyaꞌ awn kapatutan ku umampun sin dusa sin manga mānusiyaꞌ.” Hangkan laung niya ha tau nagpapatay in baran, “Utuꞌ, bangun na kaw, mumusa in kulangan mu ampa kaw uwiꞌ na!” ");
INSERT INTO tsg_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Na, saruun-duun nagbangun in tau yadtu ha kīkitaꞌ sin tau katān. Miyumus niya in kulangan niya ampa siya miyanaw minuwiꞌ iban pagpudji niya pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Landuꞌ tuud nainu-inu in tau katān. Piyudji nila in Tuhan iban landuꞌ tuud sila nahaylan, laung nila, “Landuꞌ tuud mahal-mahal in manga kītaꞌ natuꞌ adlaw ini!” ");
INSERT INTO tsg_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Na, pagꞌubus yadtu miyanaw hi Īsa. Sakali kītaꞌ niya in mangangawaꞌ sukay pa parinta pagngānan hi Libi, duun naglilingkud ha pustu pagkakawaan sukay. Laung hi Īsa kaniya, “Kari kaw agad kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Na, magtūy timindug hi Libi binīn in hinang niya ampa siya miyagad kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pagꞌubus yadtu, nagpajamu dakulaꞌ hi Libi duun ha bāy niya karnaꞌ sin panglagguꞌ niya kan Īsa. Manjari mataud in manga tau mangangawaꞌ sukay pa parinta iban sin manga tau kaibanan luruk pa pagjamuhan in simāw nagkaun kanila. ");
INSERT INTO tsg_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Sakali piyagꞌamahan sin manga Parisi iban sin manga guru sin saraꞌ agama amu in agad ha manga Parisi in manga mulid hi Īsa. Laung nila, “Maytaꞌ kamu magsāw magkaun iban sin manga mangangawaꞌ sukay pa parinta iban sin manga tau baldusa?” ");
INSERT INTO tsg_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Na, diyalil kaagi hi Īsa in sambung niya kanila, laung niya, “In manga tau way sakit diꞌ magkagunahan mangungubat, amu da in magkagunahan mangungubat in manga tau nasasakit. ");
INSERT INTO tsg_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","In maksud ku miyari pa dunya, bukun paagarun kākuꞌ in manga tau, amu in imiyan, in sila mabuntul, saꞌ miyari aku supaya magad kākuꞌ in manga tau baldusa (amu in biyaꞌ sapantun tau taga sakit) magtawbat sin dusa nila.” ");
INSERT INTO tsg_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Laung sin tau kaibanan kan Īsa, “In manga mulid hi Yahiya mawmu magpuasa iban magpangayuꞌ duwaa. Damikkiyan da isab in manga mulid sin manga Parisi, sagawaꞌ in manga mulid mu magkaun sadja iban magꞌinum.” ");
INSERT INTO tsg_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Diyalil kaagi hi Īsa in sambung niya kanila, laung niya, “Maytaꞌ, maraak mu ka magpuasa in manga luruk ha pagtiyaunan ha salugay yaun pa duun kanila in pangantin usug? Tantu diꞌ! ");
INSERT INTO tsg_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Sagawaꞌ dumatung da in waktu in pangantin usug kawaun na dayn kanila. Na, bang dumatung na in waktu yan in sila magpuasa na.” ");
INSERT INTO tsg_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Pagꞌubus nagdalil hi Īsa (pasal sin panghinduꞌ nakauna iban sin panghinduꞌ niya) laung niya, “Wayruun tau in gumisiꞌ sin tamungun baꞌgu, kumawaꞌ hipanupak ha tamungun daan. Sabab bang niya yan hinangun, in badjuꞌ baꞌgu taga girit na, ampa in pīs-pīs dayn ha badjuꞌ baꞌgu diꞌ tūpun hitupak pa tamungun daan. ");
INSERT INTO tsg_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Damikkiyan, wayruun tau in lumuun sin tubig anggul (biyaꞌ tubaꞌ) amu in masi pa nagbubukal pa luluunan pais hayup amu in daan iban matugas na. Sabab bang biyaꞌ hādtu in hinangun niya, in luluunan pais hayup amu in matugas na, tantu mabustak. Na kawgun sadja maasag in tubig anggul iban magkangīꞌ na in luluunan pais hayup. ");
INSERT INTO tsg_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Saꞌ in tubig anggul amu in baꞌgu subay hiluun pa luluunan pais hayup baꞌgu! ");
INSERT INTO tsg_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Iban wayruun tau in mabayaꞌ minum sin tubig anggul baꞌgu bang siya biyaksa na magꞌinum sin daan, karnaꞌ laung niya, ‘Marayaw in daan.’” ");
INSERT INTO tsg_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Manjari, hambuuk adlaw, adlaw Sabtuꞌ amu in adlaw paghali-hali iban pagpudji pa Tuhan sin manga Yahudi, limabay hi Īsa iban sin manga mulid niya dayn ha lawm uma. Sakali, kiyutul sin manga mulid niya in bunga sin tiyanum (biyaꞌ lupa pāy), ampa nila pīlu ha lima nila. Pagꞌubus ampa nila kiyaun. ");
INSERT INTO tsg_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Laung sin kaibanan Parisi, “Maytaꞌ kamu maghinang sin tiyaꞌgahan sin saraꞌ agama ha adlaw paghali-hali iban pagpudji pa Tuhan?” ");
INSERT INTO tsg_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","In sambung hi Īsa kanila, “Maytaꞌ, walaꞌ niyu nabacha ha lawm Kitab in hīnang hi Daud ha waktu hiyapdiꞌ siya iban sin manga tindug niya? ");
INSERT INTO tsg_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Simūd siya pa lawm Bāy sin Tuhan ampa niya kiyawaꞌ in tinapay suchi bakas iyungsud pa Tuhan. Na, kiyaun niya iban dīhilan niya da isab in manga tindug niya. Na, in hinang nila langgal saraꞌ sin agama natuꞌ sabab amura manga imam in makajari kumaun sin kakaun bakas iyungsud pa Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Mahuli dayn duun, laung hi Īsa, “In aku, amu in Anak Mānusiyaꞌ, amu in makapagbayaꞌ umiyan bang unu in mapatut hinangun ha adlaw paghali-hali iban pagpudji pa Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Manjari paghambuuk adlaw na isab, adlaw paghali-hali iban pagpudji pa Tuhan, miyadtu hi Īsa nagnasīhat pa langgal. Sakali awn duun hambuuk tau nakukumay in lima amu in pa tuu niya. ");
INSERT INTO tsg_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Na, in manga kaibanan guru sin saraꞌ agama iban sin manga kaibanan Parisi mabayaꞌ nila lawagan dusa hi Īsa ha supaya nila siya katuntutan. Hangkan jiyagahan nila tuud hi Īsa bat nila kakitaan bang awn pauliun niya tau ha adlaw paghali-hali iban pagpudji pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Sagawaꞌ asal kiyaingatan hi Īsa in lawm pikilan nila. Hangkan laung niya ha tau nakukumay in lima, “Tindug kaw ampa kaw kari pa unahan.” Na, timindug in tau ampa miyadtu timindug pa unahan. ");
INSERT INTO tsg_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ubus laung hi Īsa kanila, “Awn hiasubu ku kaniyu. Bang ha aturan sin saraꞌ agama natuꞌ, unu in mapatut natuꞌ hinangun ha adlaw paghali-hali iban pagpudji pa Tuhan? Huminang sin marayaw atawa sin makamula? Tumabang sin kabuhiꞌ sin tau atawa mamatay?” ");
INSERT INTO tsg_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Iyatud sila katān hi Īsa ubus laung niya ha tau nakukumay in lima, “Hunata in lima mu.” Na, hiyunat na sin tau in lima niya. Na, saruun-duun dimayaw nagbalik in lima niya. ");
INSERT INTO tsg_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Na, diyugalan tuud sila kan Īsa iban magtūy sila nagꞌisun bang unu in hinangun nila kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Hambuuk waktu sin manga adlaw da isab yadtu, timukad hi Īsa pa taas būd-būd mangarap pa Tuhan. Duun siya tingpus hangka-dūm nangayuꞌ duwaa pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Na, naadlaw mayan, tiyawag hi Īsa mawn kaniya in manga mulid niya, ampa niya pinīꞌ in hangpuꞌ tagduwa hīnang manga wakil niya. ");
INSERT INTO tsg_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","In manga hangpuꞌ tagduwa mulid napīꞌ niya amuna hinda Simun (ngiyānan siya hi Īsa, Pitrus) iban sin taymanghud niya hi Andariyas, hi Yaꞌkub kay Yahiya, hi Pilip iban hi Bartulumi, ");
INSERT INTO tsg_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","hi Matiyu iban hi Tumas, hi Yaꞌkub amu in anak hi Alpa, iban hi Simun (amu in bantug simulang ha pamarinta sin hulaꞌ Rūm), ");
INSERT INTO tsg_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","hi Judas amu in anak hi Yaꞌkub iban hi Judas tau dayn ha Kiriyud amu in manipu kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Paglūd hi Īsa iban sin manga wakil niya dayn ha taas būd-būd, timindug siya duun ha lugal mapatag iban sin manga mulid niya mataud. Mataud tuud tau in nagtipun mawn dayn ha katilibut sin hulaꞌ Yahudiya, dayn ha dāira Awrusalam (Baytal Makdis) iban dayn ha susulan sin dāira Tirus iban Sidun. ");
INSERT INTO tsg_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Miyawn sila dumungug sin nasīhat hi Īsa iban magpauliꞌ sin manga sakit nila. Damikkiyan, in manga tau siyusūd sin saytan miyawn da isab iban kiyaulian sila. ");
INSERT INTO tsg_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","In tau katān mabayaꞌ tuud kumaput kaniya sabab sin barakat niya magpauliꞌ ha manga nasasakit iban kiyaulian niya sila katān. ");
INSERT INTO tsg_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sakali iyatud hi Īsa in manga mulid niya ampa siya namichara, laung niya, “Hisiyu-siyu kamu in magkahagad sin kagunahan niyu tuud in tabang sin Tuhan, dakulaꞌ in karayawan niyu, sabab ha lawm kamu sin pamarintahan sin Tuhan! ");
INSERT INTO tsg_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Hisiyu-siyu kamu ha bihaun in matuyuꞌ huminang sin kabayaan sin Tuhan, dakulaꞌ in karayawan niyu, sabab dūlan kamu sin Tuhan huminang sin hinang niyu marayaw. Hisiyu-siyu kamu in magsusa ha bihaun (sabab sin manga kangīan ha lawm dunya), dakulaꞌ in karayawan niyu, sabab tantu awn da kakuyagan niyu ha susūngun! ");
INSERT INTO tsg_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Hisiyu-siyu kamu in karugalan sin manga tau diꞌ taymaun iban guraꞌ-guraun iban pamungan sin unu-unu mangīꞌ, sabab-karnaꞌ agad kamu ha amu in Anak Mānusiyaꞌ, na, dakulaꞌ in karayawan niyu! ");
INSERT INTO tsg_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Bang yan kumugdan na kaniyu pagkūg-kuyag kamu iban paglami-lami kamu, sabab awn tungbas dakulaꞌ tiyatagama kaniyu didtu ha surgaꞌ. Karnaꞌ in manga kanabihan sin timpu nakauna yadtu hīnang da isab biyaꞌ ha yan sin manga kaapuꞌ-apuan sin manga tau yan. ");
INSERT INTO tsg_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Sagawaꞌ hisiyu-siyu kamu marayaw in parasahan ha bihaun, dakulaꞌ in kasusahan niyu ha susūngun, sabab amura dayaw parasahan ha dunya in kananaman niyu! ");
INSERT INTO tsg_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Hisiyu-siyu kamu magdūl sadja sin kabayaan niyu bihaun, landuꞌ in kasusahan niyu ha susūngun, sabab diꞌ niyu makawaꞌ in kabayaan niyu! Hisiyu-siyu kamu naglalami-lami ha bihaun dakulaꞌ in kasusahan niyu ha susūngun, sabab magdukka iban magtangis da kamu! ");
INSERT INTO tsg_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Hisiyu-siyu kamu biyabantug sin tau katān, dakulaꞌ in kasusahan niyu, sabab in manga nabi bukun bunnal, biyaꞌ da isab kaniyu biyantug sin manga kaapuꞌ-apuan nila.” ");
INSERT INTO tsg_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Sagawaꞌ ini in baytaꞌ ku kaniyu amu in sasukuꞌ sin dumungug kākuꞌ. Kalasahi niyu in banta niyu iban tabanga niyu in manga tau marugal kaniyu. ");
INSERT INTO tsg_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pangayui niyu duwaa pa marayaw in manga tau amu in manuknaꞌ kaniyu pa mangīꞌ. Iban pangayui niyu duwaa pa marayaw in manga tau namiminsanaꞌ kaniyu. ");
INSERT INTO tsg_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bang awn sumampak sin hansipak bayhuꞌ niyu pasampakan niyu pa isab kaniya in hansipak. Iban bang awn tau kumawaꞌ sin badjuꞌ niyu, pakawaan niyu na kaniya sampay in gamis niyu. ");
INSERT INTO tsg_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Dihili niyu in hisiyu-siyu mangayuꞌ kaniyu, iban bang awn kumawaꞌ sin unu-unu niyu, ayaw niyu na sukata magbalik. ");
INSERT INTO tsg_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Unu-unu in kabayaan niyu hinangun sin pagkahi niyu kaniyu, amuna yan in subay niyu hinangun isab kanila. ");
INSERT INTO tsg_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Bang in kalasahan niyu amu sadja isab in manga tau malasa kaniyu, na unu in karayawan makawaꞌ niyu? Karnaꞌ minsan in manga tau mangīꞌ maingat da malasa ha manga tau malasa kanila! ");
INSERT INTO tsg_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Iban bang in tabangun niyu amu sadja in manga tau manabang kaniyu, na, unu in karayawan makawaꞌ niyu? Karnaꞌ minsan in manga tau mangīꞌ biyaꞌ da ha yan in hinang nila. ");
INSERT INTO tsg_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Iban bang amu sadja in pabūsan niyu in tau makatungbas kaniyu, na unu in karayawan makawaꞌ niyu? Karnaꞌ minsan in manga tau mangīꞌ magbūs-biyūsi da ha wayruun kalugian nila! ");
INSERT INTO tsg_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Sagawaꞌ in manga kamu, subay kamu malasa ha manga banta niyu iban tabanga niyu sila. Pabūsi niyu sila sin kagunahan nila iban ayaw kamu maghulat-hulat sin tungbasan nila kamu. Bang niyu yan hinangun, na, makabāk kamu karayawan dakulaꞌ iban mahinang kamu anak sin Tuhan Mahatinggi, sabab in Tuhan marayaw minsan ha manga tau mangīꞌ amu in diꞌ manumtum sin tabang niya kanila. ");
INSERT INTO tsg_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kaulungi niyu in pagkahi niyu biyaꞌ sin ulung sin Tuhan, Amaꞌ niyu, ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ayaw kamu mangliling pa mangīꞌ sin hinang sin tau dugaing ha supaya isab kamu diꞌ lilingun sin Tuhan. Ayaw kamu magꞌūs-ꞌūs mangdihil hukuman sin hinang sin pagkahi niyu bat kamu isab diꞌ butangan sin Tuhan hukuman. Maapa niyu in pagkahi niyu bat kamu isab ampunun sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Bang ibārat magdihil, bang mataud in hirihil niyu ha pagkahi niyu, mataud da isab in hirihil sin Tuhan kaniyu. Dakulaꞌ in tungbas niya kaniyu. Bang biyaꞌ sapantun magtupung lasay-manglasay in hirihil niya kaniyu. In kaagi niyu magtupung sin hirihil niyu, amura isab in kaagi sin Tuhan magtupung sin hirihil niya kaniyu.” ");
INSERT INTO tsg_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Na, diyalil hi Īsa in bichara niya, laung niya, “In hambuuk tau buta diꞌ makaambit ha tau buta da isab, sabab bang niya yan hinangun, mahulug sila karuwa pa lubang. ");
INSERT INTO tsg_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Wayruun anak mulid in mataas dayn ha guru nila. Sagawaꞌ bang tumammat na in manga mulid sin pangadjiꞌ nila, na mabiyaꞌ na sila katān sin guru nila.” ");
INSERT INTO tsg_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Laung pa isab hi Īsa, “Līliling niyu sadja pa mangīꞌ in kasāan sin pagkahi niyu. Maingat niyu lilingun in kasāan nila minsan sibiꞌ-sibiꞌ da, sagawaꞌ diꞌ niyu kaingatan lilingun in kasāan niyu minsan da biyaꞌ lagguꞌ unu. Amu in pagꞌiyanun, kakitaan niyu in puling sibiꞌ-sibiꞌ ha lawm mata sin pagkahi niyu, sagawaꞌ diꞌ niyu kakitaan in puling malagguꞌ ha lawm mata niyu. ");
INSERT INTO tsg_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Diꞌ kamu yan manjari! Mabayaꞌ kamu magꞌīg sin puling ha mata sin pagkahi niyu, saꞌ diꞌ niyu kakitaan sin awn puling biyaꞌ lagguꞌ hāg ha lawm mata niyu. In kamu yan lansuk ha guwaꞌ, bingit ha lawm. Magpabawꞌ-bawꞌ sadja kamu marayaw. Īgi niyu naa muna in puling biyaꞌ lagguꞌ hāg dayn ha lawm mata niyu, ampa kamu makakitaꞌ marayaw umīg sin puling sin pagkahi niyu.” ");
INSERT INTO tsg_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“In kahuy marayaw diꞌ magbunga mangīꞌ. Damikkiyan, in kahuy mangīꞌ diꞌ magbunga marayaw. ");
INSERT INTO tsg_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Asal in kahuy kaingatan dayn ha bunga niya. Biyaꞌ na sin bungang-kahuy tina bukun dayn ha kahuy tunukan makawaꞌ. Damikkiyan in bunga anggul bukun dayn ha sagbut tunukan makawaꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Na, biyaꞌ da isab ha yan in hantang sin mānusiyaꞌ. In tau marayaw in hinang iban bichara niya marayaw da isab, sabab marayaw in ha lawm pamikil niya, sagawaꞌ in tau mangīꞌ, in hinang iban bichara niya mangīꞌ da isab, sabab mangīꞌ in ha lawm pamikil niya. Unu-unu in ha lawm sin pamikil sin tau amura isab in gumuwaꞌ dayn ha simud niya. ");
INSERT INTO tsg_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Maytaꞌ niyu aku tawagun Panghuꞌ, malayngkan diꞌ niyu hinangun in daakan ku kaniyu? ");
INSERT INTO tsg_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Baytaan ta kamu bang biyaꞌ diin in hantang sin tau amu in mari dumungug sin hinduꞌ ku iban kahagarun niya. ");
INSERT INTO tsg_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Biyaꞌ siya yan sin hambuuk tau naghinang sin bāy niya ha lupaꞌ matugas. Kalian niya malawm ampa niya tambakan mahugut in manga hāg niya. Na, minsan kugdanan dunuk dayn ha subaꞌ in bāy niya diꞌ da majugjug sabab mahugut in kahinang niya. ");
INSERT INTO tsg_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Sagawaꞌ in tau nakarungug kākuꞌ ampa diꞌ siya magkahagad sin diyungug niya, na, biyaꞌ siya sin tau naghinang sin bāy niya ha lupaꞌ malunuk. Diꞌ niya kalian malawm iban diꞌ niya tambakan in manga hāg. Na, kugdanan mayan sin dunuk in bāy, saruun-duun malubu iban way tuud tabangan!” ");
INSERT INTO tsg_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Na, naubus mayan hi Īsa nagnasīhat sin katān yan pa manga tau, miyadtu siya pa dāira Kapirnaum. ");
INSERT INTO tsg_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Sakali awn duun hambuuk kapitan, tau dayn ha hulaꞌ Rūm. In hambuuk īpun niya amu in kalasahan niya tuud nasasakit iban nagdarā na napas. ");
INSERT INTO tsg_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pagdungug sin kapitan sin pasal sin nahinang hi Īsa, magtūy niya piyakadtu in kaibanan Yahudi amu in nagtatau-maas ha hulaꞌ mangayuꞌ tabang kan Īsa, pakawnun magpauliꞌ ha īpun niya. ");
INSERT INTO tsg_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Na, pagkadtu nila kan Īsa, nangayuꞌ tuud sila junjung, laung nila, “Anduꞌ Tuwan, in tau nagdaak kāmuꞌ tūpun tuud tabangun mu, ");
INSERT INTO tsg_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","sabab malasa tuud siya ha bangsa natuꞌ iban piyahinangan niya kitaniyu langgal.” ");
INSERT INTO tsg_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Na, miyagad na hi Īsa kanila. Masuuk mayan sila pa bāy, miyawn nagbāk kanila in manga bagay sin kapitan amu in diyaak niya magpasampay sin lapal-kabtangan niya kan Īsa. Tiyukbal nila kan Īsa in kabtangan sin kapitan, amu agi, “Tuwan, ayaw na kaw magpahapus sin baran mu lumaus mari pa bāy ku. Diꞌ aku tūpun magpakari kaymu pa taas sin bāy ku sabab labi in kawasa mu dayn kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Iban diꞌ da isab aku tūpun dumā magkitaꞌ kaymu. Malayngkan minsan kaw umiyan sadja dayn duun, tantu kaulian na in daraakun ku dī ha bāy. ");
INSERT INTO tsg_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kaingatan ku maagad in uldin mu, sabab in aku ini hambuuk da isab tau ha babaan sin kawasa sin manga nakuraꞌ ku, iban awn da isab manga sundalu ha babaan ku. Bang laung ku ha sundalu ku, ‘Kadtu kaw’, madtu siya. Bang laung ku ha hangka-tau, ‘Kari kaw’, mari siya. Bang laung ku ha īpun ku, ‘Hinanga ini’, na magtūy niya hinangun.” ");
INSERT INTO tsg_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Na, nainu-inu tuud hi Īsa, pagdungug niya. Himarap siya pa ulihan ampa siya namung ha manga tau mataud imuurul kaniya, laung niya, “Na, baytaan ta kamu, walaꞌ aku nakalanggal minsan hambuuk tau bangsa natuꞌ Israil amu in biyaꞌ ha yan in kusug sin parachaya iban pangandul.” ");
INSERT INTO tsg_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Na, nagbalik na in manga tau naraak pa bāy sin kapitan. Pagbalik nila, kiyaulian na in īpun sin kapitan. ");
INSERT INTO tsg_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pagꞌubus yadtu, bukun malugay, miyadtu hi Īsa pa dāira pagngānan Nain iban sin manga mulid niya iban mataud da isab tau in miyagad kanila. ");
INSERT INTO tsg_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Na, masuuk mayan sila pa lawang amu in guwaan iban sūran pa lawm sin dāira, nagsartaꞌ isab awn manga tau sūng gumuwaꞌ dayn ha lawm dāira magkubul. In mayat tiyatanggung nila, tunggal anak usug sin hambuuk babai balu. Mataud tau dayn ha dāira in miyagad kaniya nagkubul. ");
INSERT INTO tsg_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Na, pagkitaꞌ hi Panghuꞌ Īsa ha babai balu, landuꞌ tuud siya limuuy kaniya, sartaꞌ laung niya kaniya, “Ayaw kaw magtangis.” ");
INSERT INTO tsg_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Pagꞌubus ampa niya kiyadtu iyulinan in lalungan. Na, himundung in manga tau nagdarā sin lalungan. Laung hi Īsa, “Utuꞌ, bangun kaw.” ");
INSERT INTO tsg_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Na, nagbangun na in mayat ampa nagbichara sabab nabuhiꞌ na siya nagbalik. Ubus, piyakadtu na siya hi Īsa nagbalik pa inaꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Na, miyugaꞌ tuud in tau katān duun. Piyudji nila in Tuhan, laung nila, “Awn na hambuuk nabi dakulaꞌ in yari dī kātuꞌniyu.” Iban laung nila pa isab, “Piyakitaꞌ na sin Tuhan in pagparuli niya kātuꞌ, manga tau sukuꞌ niya.” ");
INSERT INTO tsg_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Na, magtūy simaplag in suysuy pasal sin nahinang hi Īsa ha katilingkal sin hulaꞌ Yahudiya iban pa manga dugaing hulaꞌ ha katilibut niya. ");
INSERT INTO tsg_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Manjari, diyungug sin manga mulid hi Yahiya in pasal sin manga nahinang hi Īsa. Na, biyaytaan nila isab hi Yahiya. Na, tiyawag hi Yahiya in duwa mulid niya ");
INSERT INTO tsg_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ampa niya diyaak piyakadtu, mangasubu kan Panghuꞌ Īsa. Laung niya, “Biyaꞌ ha ini in pangasubu niyu kaniya, ‘Ikaw na ka in piyagꞌiyan hi Yahiya amu in dumatung mari atawa awn pa huwat-huwatun namuꞌ dumatung mari dugaing dayn kaymu?’” ");
INSERT INTO tsg_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Na, pagdatung nila mawn kan Īsa, laung nila, “In kami ini naraak mari kaymu hi Yahiya amu in mangliliguꞌ mangasubu bang ikaw na in piyagꞌiyan niya amu in magdaratung mari atawa awn pa ka huwat-huwatun namuꞌ dumatung mari dugaing dayn kaymu?” ");
INSERT INTO tsg_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na, ha waktu yadtu sin duun pa in duwa tau, mataud na tau in napauliꞌ hi Īsa dayn ha manga sakit nila malawm iban bukun. Napaguwaꞌ niya na in manga saytan dayn ha lawm baran sin manga tau iban kiyarihilan niya na nagbalik pangitaꞌ in manga tau buta. ");
INSERT INTO tsg_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","In sambung niya kanila, laung niya, “Balik na kamu madtu iban baytai niyu hi Yahiya sin manga piyagkakitaan iban piyagkarungugan niyu. In tau bakas buta makakitaꞌ na, in bakas pingkaꞌ makapanaw na mabuntul, in manga tau bakas īipul malanuꞌ na in baran nila, in bakas bisu makarungug na, sampay tau miyatay nabuhiꞌ na magbalik, iban piyagnasīhat na in Baytaꞌ Marayaw ha manga miskin. ");
INSERT INTO tsg_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Na, hisiyu-siyu in diꞌ maghawal-hawal mangandul kākuꞌ, makūg-kuyag tuud siya!” ");
INSERT INTO tsg_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pagꞌubus, nakaīg mayan in manga mulid hi Yahiya, namichara na hi Īsa ha manga tau mataud natitipun sin pasal hi Yahiya. Laung niya, “Ha waktu miyadtu kamu kimitaꞌ kan Yahiya didtu ha hulaꞌ paslangan mahunit paghulaan, unu in hiyuwat-huwat niyu kakitaan didtu? Hambuuk tau ka siya amu in magpinda-pinda in pikilan biyaꞌ sin dahun parang marā sin hangin madtu mari? Tantu bukun. ");
INSERT INTO tsg_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Unu bahaꞌ in kiyadtu niyu kītaꞌ? Hambuuk tau bahaꞌ amu in nagtatamung sin mahargaꞌ? Tantu bukun. Sabab in tau nagtatamung biyaꞌ ha yan iban marayaw tuud in parasahan, naghuhulaꞌ ha lawm astanaꞌ! ");
INSERT INTO tsg_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Baytai niyu aku tuud. Unu in kiyadtu niyu kītaꞌ? Hambuuk nabi? Bunnal hambuuk siya nabi, sagawaꞌ in kiyakitaan niyu mataas māyuꞌ dayn ha manga kaibanan nabi. ");
INSERT INTO tsg_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Sabab in hi Yahiya in piyagꞌiyan sin Kitab, amu agi sin Tuhan, ‘Pakadtuun ku in kiyawakilan ku muna dayn kaymu ha supaya maparayaw niya in dān labayan mu!’ ");
INSERT INTO tsg_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Baytaan ta kamu,” laung hi Īsa, “wayruun pa mānusiyaꞌ dayn sin tagnaꞌ kapanjari ha mānusiyaꞌ in labi mataas dayn kan Yahiya. Sagawaꞌ in tau katān ha lawm pamarintahan sin Tuhan, sampay pa manga tau amu in bukun mataas in hinang, mataas sila dayn kan Yahiya.” ");
INSERT INTO tsg_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Na, diyungug sin manga tau katān duun in bichara niya. In manga tau ini, labi awla na in manga tau mangangawaꞌ sukay pa parinta amuna in timaayun sin mabuntul in manga kiyawajib kanila sin Tuhan. Sila in nagpaliguꞌ kan Yahiya. ");
INSERT INTO tsg_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Sagawaꞌ in manga Parisi iban sin manga guru sin saraꞌ agama siyulak nila in kabayaan sin Tuhan kanila. Diꞌ sila mabayaꞌ magpaliguꞌ kan Yahiya. ");
INSERT INTO tsg_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Laung pa isab hi Īsa, “Na, unu in hikapagsawpama ku sin addat sin manga tau ha masa ini? Biyaꞌ diin in hantang nila? ");
INSERT INTO tsg_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Na, biyaꞌ sila manga bataꞌ-bataꞌ naglilingkud ha halaman tabuꞌ. In hangka-tumpuk sin manga bataꞌ-bataꞌ gumasud pa dugaing ha hansipak, laung nila, ‘Nagtabungguꞌ kami, saꞌ diꞌ kamu mabayaꞌ mangalay! Nagluguꞌ-luguꞌ kami sin luguꞌ patay, saꞌ walaꞌ da kamu nagtangis!’ (Biyaꞌ da isab ha yan in manga tau sin masa ini. Wayruun unu-unu makasulut kanila.) ");
INSERT INTO tsg_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Na,” laung hi Īsa, “in hi Yahiya Mangliliguꞌ, mahumu diꞌ magkaun, magpuasa sadja siya, iban diꞌ siya magꞌinum sin tubig anggul (biyaꞌ tubaꞌ). Sakali laung niyu, ‘Siyusūd siya saytan.’ ");
INSERT INTO tsg_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ampa, in aku, amu in Anak Mānusiyaꞌ, magkaun iban magꞌinum. Sakali laung niyu, ‘Kitaa niyu ba in tau yan, dahal tuud iban magꞌiinum. Magbagay iban sin manga tau mangangawaꞌ sukay pa parinta iban sin manga kaibanan baldusa!’ ");
INSERT INTO tsg_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sagawaꞌ,” laung hi Īsa, “in kami kay Yahiya naraak sin Tuhan. Kahātihan da sin tau amu in taga ingat dayn ha Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Manjari, hambuuk adlaw piyakawaꞌ sin hambuuk tau Parisi hi Īsa piyakaun ha bāy niya. Na, miyadtu hi Īsa pa bāy niya ampa siya simaꞌday kimaun. ");
INSERT INTO tsg_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Sakali awn hambuuk babai mangīꞌ in naghuhulaꞌ duun ha kawman yaun. Pagdungug niya sin yaun hi Īsa nagkakaun ha bāy sin hambuuk Parisi, miyadtu siya iban pagdā niya hambuuk kibut-kibut habaꞌ liug, pagtawagun alabistrus. In kibut-kibut ini hipuꞌ sin lana mahamut. ");
INSERT INTO tsg_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pagkawn niya, duun siya timindug ha taykuran, ha tungud sin siki hi Īsa ampa siya nagtangis. Nabasaꞌ mān in siki hi Īsa sin luhaꞌ niya piyahiran niya in siki hi Īsa iban sin buhuk niya ampa niya sīyum. Pagꞌubus ampa niya biyutangan lana mahamut. ");
INSERT INTO tsg_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pagkitaꞌ sin tau Parisi sin hīnang sin babai, laung niya ha lawm atay niya, “Bang in tau ini bunnal tuud nabi, tantu kaingatan niya bang hisiyu in babai imuulin sin siki niya. Tantu kaingatan niya sin in babai yaun naghihinang mangīꞌ!” ");
INSERT INTO tsg_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sakali namichara hi Īsa, laung niya, “Simun, awn hibaytaꞌ ku kaymu.” “Na, baytai aku, Tuwan Guru, bang unu.” ");
INSERT INTO tsg_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Laung hi Īsa, “Awn yaun duwa tau nakautang sīn ha tau magpabubūs sīn. In hambuuk nakautang limanggatus pilak tibuuk, hāti in hangka-tau nakautang kayꞌman. ");
INSERT INTO tsg_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pagga diꞌ na sila makabayad sin utang nila, na walaꞌ na sila piyabayad sin kiyautangan nila. Na, ha pikil mu, hisiyu ha duwangka-tau ini in malabi in lasa ha tau nagpautang kanila?” ");
INSERT INTO tsg_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","“Na, ha pikil ku,” laung hi Simun, “amu in tau nakautang mataud.” “Nakaamu in sambung mu,” laung hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Limingiꞌ hi Īsa pa babai ampa niya īyan hi Simun, laung niya, “Kītaꞌ mu in hīnang sin babai ini? Piyakawaꞌ mu aku mari pa bāy mu, sagawaꞌ pagdatung ku mari, walaꞌ mu aku dīhilan tubig hipanghugas sin siki ku. Walaꞌ mu iyagad in addat. Sagawaꞌ in babai ini hiyugasan niya in siki ku sin luhaꞌ niya, iban piyahiran niya sin buhuk niya. ");
INSERT INTO tsg_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","In ikaw walaꞌ mu aku sīyum pagdatung ku mari, sagawaꞌ in babai ini way paghundung in pagsiyum niya sin siki ku dayn sin tagnaꞌ karatung ku mari. ");
INSERT INTO tsg_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Walaꞌ mu minsan liyanahan in ū ku, sagawaꞌ in babai ini biyutangan niya liyatag in siki ku sin lana mahamut mahargaꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Na, baytaan ta kaw, in manga dusa mataud sin babai yan naampun na, karnaꞌ piyakitaꞌ niya in lagguꞌ sin lasa niya. Sagawaꞌ in tau naampun amu in hangkatiyuꞌ da in dusa niya, na hangkatiyuꞌ da isab in lasa hipakitaꞌ niya.” ");
INSERT INTO tsg_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pagꞌubus laung hi Īsa ha babai, “Naampun na in manga dusa mu.” ");
INSERT INTO tsg_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Na, in manga kaibanan tau duun nagkakaun ha lamisahan nagbichara na ha lawm atay nila, laung nila, “Ay kaw naa, hisiyu bahaꞌ in tau ini makaampun sin manga dusa sin tau?” ");
INSERT INTO tsg_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Na, laung hi Īsa ha babai, “In parachaya iban pangandul mu amu in nakalappas kaymu. Uwiꞌ na kaw iban pasannyanga na in lawm atay mu.” ");
INSERT INTO tsg_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Manjari, pagꞌubus yadtu, miyanaw hi Īsa himapit pa manga kadāirahan iban manga kakawman nagnasīhat sin Baytaꞌ Marayaw pasal sin pamarinta sin Tuhan. Miyamagad kaniya in hangpuꞌ tagduwa mulid niya, ");
INSERT INTO tsg_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","iban sin kaibanan manga babai isab amu in kiyaulian niya dayn ha manga sakit nila iban napaguwaꞌ niya in manga saytan dayn ha lawm baran nila. In manga babai ini amuna hinda Mariyam (amu in pagtawagun babai dayn ha Magdala). Siya ini in bakas kiyapaguwaan hi Īsa pitu saytan dayn ha lawm baran niya. ");
INSERT INTO tsg_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","In hambuuk isab hi Juwanna, asawa hi Kusi, amu in tau piyangandulan hi Hirud magmandul sin manga hinang ha lawm bāy niya. In hambuuk isab hi Susana, iban mataud pa isab dugaing babai in miyagad amu in nangatas sin kaibanan balanjaꞌ hi Īsa iban sin manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Na, in manga tau dayn ha manga kadāirahan miyawn nagtipun mawn kan Īsa. Natipun mayan in manga tau diꞌ maambat, nagnasīhat na hi Īsa. Diyalil niya kaagi in pagnasīhat niya. ");
INSERT INTO tsg_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Laung niya, “Awn yaun hambuuk tau miyadtu nagtanum binhiꞌ pa uma niya. In kaagi niya nagtanum, siyabud niya in manga binhiꞌ. In kaibanan binhiꞌ nahulug pa labayan, iban kiyagiikan sin manga tau. Na, pagkawn sin manga manuk-manuk nakaun in manga binhiꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","In kaibanan binhiꞌ nahulug pa lupaꞌ mabatu. Sakali pagtubuꞌ sin manga binhiꞌ walaꞌ limugay nangluyluy in tiyanum sabab matahay tuud in lupaꞌ niya. Way tubig niya. ");
INSERT INTO tsg_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","In kaibanan isab manga binhiꞌ nahulug pa lupaꞌ tiyutubuan sin manga kasagbutan matunuk. Na, pagtubuꞌ sin manga binhiꞌ tiyaꞌlung sin manga sagbut matunuk. ");
INSERT INTO tsg_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ampa in kaibanan binhiꞌ nahulug pa lupaꞌ marayaw. Na, hangkan nagtubuꞌ marayaw iban nagbunga, lāgiꞌ namunga landuꞌ tuud mataud.” Na, mahuli dayn duun, laung hi Īsa, “Na, sasukuꞌ sin kamu nakarungug, dunguga niyu tuud in biyaytaꞌ ku yan kaniyu!” ");
INSERT INTO tsg_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Sakali nangasubu in manga mulid hi Īsa kaniya bang unu in hāti sin isturi diyalil niya. ");
INSERT INTO tsg_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Laung hi Īsa kanila, “In kamu yan kiyarihilan na ingat panghāti sin kahālan sin pamarinta sin Tuhan amu in bakas līlibun dayn ha pikilan sin manga mānusiyaꞌ. Sagawaꞌ pa manga kaibanan tau amu in way bayaꞌ magad sin hinduꞌ ku, in pagnasīhat kanila subay dalilun pa manga isturi malawm in maana niya. In sila minsan imaatud diꞌ nila kakitaan iban minsan sila dimurungug diꞌ nila kahātihan. ");
INSERT INTO tsg_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Biyaꞌ ha ini in maana sin dalilan pasal sin tau nagtanum. In binhiꞌ amuna in Parman sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","In manga binhiꞌ iban sin dān labayan kiyahulugan nila amuna in biyaꞌ sapantun sin manga tau nakarungug sin Baytaꞌ Marayaw pasal sin pamarinta sin Tuhan, sagawaꞌ pagkawn sin Iblis maagaw dayn ha lawm atay nila in hinduꞌ sin Baytaꞌ Marayaw ha supaya sila diꞌ magparachaya iban ha supaya sila diꞌ malappas. ");
INSERT INTO tsg_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","In manga binhiꞌ iban sin lupaꞌ mabatu kiyahulugan nila amuna in biyaꞌ sapantun manga tau nakarungug sin Baytaꞌ Marayaw iban tiyaymaꞌ nila iban pagkūg-kuyag, sagawaꞌ diꞌ maggamut in hinduꞌ sin Baytaꞌ Marayaw ha lawm atay nila. Hangkarayꞌ da in pagkahagad nila sin hinduꞌ, hangkan bang sila datungan na kasigpitan, butawanan nila na in pangandul nila ha Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","In manga binhiꞌ iban sin lupaꞌ kiyahulugan nila amu in tiyutubuan sin manga sagbut matunuk amuna in biyaꞌ sapantun sin manga tau nakarungug sin Baytaꞌ Marayaw, sagawaꞌ masi sila magsusa, magnapsu ha altaꞌ iban magdūl sin unu-unu kanapsuhan nila. Hangkan maluppas sadja in karayawan makapabuntul sin kawl-piil nila amu in makawaꞌ nila dayn ha hinduꞌ sin Baytaꞌ Marayaw. In sila biyaꞌ da sapantun tiyanum diꞌ magbunga. ");
INSERT INTO tsg_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","In manga binhiꞌ iban sin lupaꞌ marayaw kiyahulugan nila amuna in biyaꞌ sapantun sin manga tau marayaw nakarungug sin Baytaꞌ Marayaw, amu in magpahūp sin hinduꞌ pa lawm atay nila iban kahagarun nila tuud. Hangkan tumatas sila malugay sampay maabut dumayaw na tuud in dayaw sin kawl-piil nila biyaꞌ sin tiyanum mataud bunga niya.” ");
INSERT INTO tsg_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Laung pa isab hi Īsa, “Wayruun tau magsūꞌ sin palitaan ubus ampa niya lukuban sin pastan atawa hibutang ha sawm sin kantil. Subay niya hibutang ha pagbubutangan palitaan ha supaya pagsūd sin manga tau kakitaan nila in ilaw. ");
INSERT INTO tsg_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Karnaꞌ unu-unu in tiyatapuk, tantu gumuwaꞌ da, iban unu-unu in līlibun tantu kaingatan da iban gumuwaꞌ da pa kasawahan. ");
INSERT INTO tsg_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Na, dunguga niyu tuud yan marayaw sabab hisiyu-siyu in dumungug tuud marayaw sūngan sin Tuhan in panghāti niya, sagawaꞌ hisiyu-siyu in diꞌ dumungug marayaw minsan in maniyuꞌ-tiyuꞌ panghāti, amu in pangannal niya kahātihan niya, maīg da dayn kaniya.” ");
INSERT INTO tsg_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Sakali nākawn in inaꞌ iban manga taymanghud usug hi Īsa, sagawaꞌ diꞌ sila makasuuk madtu kan Īsa, sabab landuꞌ tuud in taud sin tau. ");
INSERT INTO tsg_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Na, awn hambuuk tau namaytaꞌ kan Īsa, laung niya, “In inaꞌ mu iban manga taymanghud mu yaun nagtitindug ha guwaꞌ, mabayaꞌ dumā magkitaꞌ kaymu.” ");
INSERT INTO tsg_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Laung hi Īsa kanila katān, “In hisiyu-siyu tau dumungug iban magkahagad sin Parman sin Tuhan, in siya yan taymanghud ku usug-babai iban inaꞌ ku da isab.” ");
INSERT INTO tsg_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Manjari, hambuuk adlaw simakat hi Īsa iban sin manga mulid niya pa hambuuk kumpit asibiꞌ. Laung niya ha manga mulid niya, “Sūng kitaniyu umuntas pa hansipak hunasan.” Na, imuntas na sila. ");
INSERT INTO tsg_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ha saꞌbu nila ha dān pa, nakatūg hi Īsa. Sakali magtūy himuyup in hangin makusug sartaꞌ nagsimpuwak na in alun pa lawm kumpit nila, hangkan ha lawm kapiligruhan tuud sila. ");
INSERT INTO tsg_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Na, kiyadtu sin manga mulid niya hi Īsa ampa biyatiꞌ. Laung nila, “Tuwan! Tuwan! Magmula na kitaniyu!” Na, nagbangun hi Īsa ampa niya diyaak in hangin iban sin alun pahundungun bat makusug tuud in alun. Na, saruun-duun liminaw in hulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Laung niya kanila, “Nakapakain na in pangandul niyu?” Sagawaꞌ kiyublaan iban miyugaꞌ sila. Laung nila pakaniya-pakaniya, “Hisiyu bahaꞌ tuud in tau ini? Minsan in hangin iban alun daakun niya iban magkahagad da kaniya!” ");
INSERT INTO tsg_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Pagꞌubus, limanjal na timulak hi Īsa iban sin manga mulid niya pa hulaꞌ Girasa, amu in hulaꞌ ha hansipak sin dagat dayn ha Jalil. ");
INSERT INTO tsg_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Sakali pagnaug na mayan hi Īsa pa ginlupaan, biyāk siya sin hambuuk tau dayn ha dāira, amu in siyusūd sin manga saytan. In tau ini malugay na naghuhubuꞌ iban diꞌ maghulaꞌ ha bāy, sagawaꞌ didtu siya naghulaꞌ ha lawm sungab batu pangungubulan sin tau. ");
INSERT INTO tsg_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pagkitaꞌ niya kan Īsa, similawak siya makusug ampa siya simujud pa tungud siki hi Īsa. Laung niya, “Unu in kabayaan mu kākuꞌ, Īsa, amu in Anak Tuhan Mahatinggi? Anduꞌ pangayuun ku kaymu, ayaw mu aku binsanaa!” ");
INSERT INTO tsg_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nakapamung siya biyaꞌ ha yan sabab iyuldinan hi Īsa in manga saytan papaguwaun dayn ha lawm baran niya. Nakamataud na in tau ini siyūd saytan iban minsan siya kiyalabusu kadinahan in siki lima niya makapaguy da siya. Pagbugtuꞌ-bugtuun niya in manga bilangguꞌ, ubus ampa siya dāhun sin saytan pa hulaꞌ paslangan mahunit paghulaan. ");
INSERT INTO tsg_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Laung hi Īsa kaniya, “Hisiyu in ngān mu?” “In ngān ku hi Ibuhan,” in sambung niya sabab mataud saytan in nakasūd pa lawm baran niya. ");
INSERT INTO tsg_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Na, piyangayuꞌ junjung sin manga saytan kan Īsa bang mayan sila diꞌ pakadtuun pa hulaꞌ tigub-tiguban pagbibinasahan kanila. ");
INSERT INTO tsg_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Manjari ini awn manga babuy mataud nagbabaan didtu ha pigiꞌ būd nagkakaun. Na, nangayuꞌ junjung in manga saytan kan Īsa bang mayan sila pasūrun pa lawm baran sin manga babuy. Na, diyūlan sila hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Na, gimuwaꞌ na in manga saytan dayn ha baran sin tau ampa sila limīn madtu pa manga babuy. Na, magtūy in manga babuy nagbaan-baan limungtud dimagan dayn ha pangpang pa babaꞌ. Nakatūy sila pa lawm dagat iban naluꞌmus sila katān. ");
INSERT INTO tsg_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Na, pagkitaꞌ sin manga tau nagꞌiipat ha manga babuy sin biyaꞌ hādtu, magtūy sila dimagan madtu pa dāira iban pa kagimbahan nanuysuy ha manga tau pasal sin kītaꞌ nila. ");
INSERT INTO tsg_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Na, miyadtu na in manga tau nyimataꞌ sin suysuy diyungug nila. Pagdatung nila mawn kan Īsa, kītaꞌ nila in tau amu in bakas siyusūd sin saytan mataud, duun naglilingkud ha daig siki hi Īsa. Nagtatamung na siya iban ha lawm sayu na siya. Na, miyugaꞌ in tau katān. ");
INSERT INTO tsg_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Na, in manga tau amu in duun nakakitaꞌ, nanuysuy ha manga tau bang biyaꞌ diin in kauliꞌ ha tau siyusūd saytan. ");
INSERT INTO tsg_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Na, piyangayuꞌ sin tau katān ha hulaꞌ Girasa kan Īsa papaīgun siya sabab landuꞌ tuud sila miyugaꞌ. Hangkan nagbalik na hinda Īsa pa kumpit nila ampa sila minīg. ");
INSERT INTO tsg_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","In tau bakas siyusūd saytan nangayuꞌ junjung kan Īsa, laung niya. “Tuwan, paagara aku kaymu.” Sagawaꞌ walaꞌ siya piyaagad hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Laung hi Īsa kaniya, “Uwiꞌ na kaw pa hulaꞌ mu ampa kaw panuysuy sin nahinang sin Tuhan kaymu.” Na, kiyadtu liyatag sin tau ini in lawm dāira siyuysuyan in manga tau sin nahinang kaniya hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Na, nakabalik mayan hinda Īsa pa hansipak sin dagat hiyulmat siya sin manga tau sabab asal sila katān nagtatagad kaniya. ");
INSERT INTO tsg_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Sakali awn hambuuk tau pagngānan hi Jayrus in nākawn. Hambuuk siya nakuraꞌ sin langgal didtu. Pagkawn niya, simujud siya pa tungud siki hi Īsa, ampa niya jiyunjung paagarun hi Īsa pa bāy niya, ");
INSERT INTO tsg_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","sabab in hambuuk-buuk anak niya babai, umul hangpuꞌ tagduwa, nagdarā na napas. Na, miyagad na hi Īsa. Naririgpit siya sin manga tau mataud miyamagad kaniya dayn ha kīd pa kīd niya. ");
INSERT INTO tsg_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Sakali awn isab duun hambuuk babai nasasakit pagguwaan duguꞌ, hangpuꞌ tagduwa tahun na in lugay niya. Naubus na in katān unu-unu niya piyagbayad ha manga mangungubat sagawaꞌ wayruun makauliꞌ sin sakit niya. ");
INSERT INTO tsg_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Na miyadtu siya simuuk pa taykud hi Īsa, ampa niya kiyaputan in duhul juba hi Īsa. Na, saruun-duun himundung in pagguwaꞌ sin duguꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Sakali laung hi Īsa, “Hisiyu in kimaput kākuꞌ?” Na, namaylu in tau katān. Laung hi Pitrus, “Tuwan, kītaꞌ mu na in banus sin tau yan ha katilibut mu iban naririgpit na kaw sin manga tau.” ");
INSERT INTO tsg_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Sagawaꞌ laung hi Īsa, “Awn tuud tau kimaput kākuꞌ sabab kaingatan ku bang awn kaulian dayn ha barakat ku.” ");
INSERT INTO tsg_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Na, pagkitaꞌ sin babai sin kiyaingatan na in nahinang niya, namidpid siya, sartaꞌ miyawn siya simujud pa tungud siki hi Īsa. Duun ha alupan sin tau katān, biyaytaan niya hi Īsa bang maytaꞌ niya siya kiyaputan iban pasal sin saruun-duun pagꞌuli sin sakit niya. ");
INSERT INTO tsg_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Laung hi Īsa kaniya, “Indaꞌ, in kusug sin parachaya iban pangandul mu, amu in nakauliꞌ kaymu. Uwiꞌ na kaw iban pasannyanga na in lawm atay mu.” ");
INSERT INTO tsg_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ha saꞌbu hi Īsa nagbibichara ha babai yaun, awn nākawn hambuuk tau dayn ha bāy hi Jayrus. Laung niya kan Jayrus, “In anak mu miyatay na. Ayaw mu na paluuga madtu in Tuwan Guru.” ");
INSERT INTO tsg_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Sagawaꞌ diyungug hi Īsa in baytaꞌ sin tau yaun. Hangkan, laung niya kan Jayrus, “Ayaw kaw masusa. Pagparachaya sadja kaw, ampa siya kaulian.” ");
INSERT INTO tsg_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pagdatung hinda Īsa pa bāy, walaꞌ siya nagpaagad tau simūd pa lawm bāy. Amura in piyaagad niya hinda Pitrus, Yahiya, Yaꞌkub iban sin inaꞌ-amaꞌ sin bataꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","In tau katān ha lawm bāy nagtatangis iban nagmamatay. Laung hi Īsa kanila, “Ayaw kamu magtangis. In bataꞌ walaꞌ miyatay, sagawaꞌ natūg sadja siya!” ");
INSERT INTO tsg_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Na, piyagkatawahan siya sin manga tau, sabab kiyaingatan nila sin tantu tuud patay na in bataꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sagawaꞌ kiyaputan hi Īsa in lima sin bataꞌ ampa siya namung, laung niya, “Bangun kaw, Indaꞌ!” ");
INSERT INTO tsg_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Na, nabuhiꞌ nagbalik in bataꞌ iban nagbangun saruun-duun. Pagꞌubus ampa hi Īsa nagꞌiyan paparihilan kakaun in bataꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Na, nahaylan in inaꞌ-amaꞌ sin bataꞌ, sagawaꞌ ībut-ibutan tuud sila hi Īsa diꞌ pabaytaun minsan hisiyu sin pasal nahinang niya. ");
INSERT INTO tsg_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Manjari tiyawag hi Īsa mawn kaniya in hangpuꞌ tagduwa mulid niya ampa niya sila dīhilan kusug iban kawasa magpaguwaꞌ sin katān saytan dayn ha lawm baran sin manga tau iban magpauliꞌ sin manga sakit sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Na, pagꞌubus diyaak niya in manga mulid niya magnasīhat pa kahulaꞌ-hulaan pasal sin pamarinta sin Tuhan iban magpauliꞌ ha manga nasasakit. ");
INSERT INTO tsg_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Pagꞌubus niya namichara ha ini, laung niya. “Ayaw kamu magdā unu-unu ha panaw niyu. Ayaw kamu magdā tungkud, pagluluunan sin kapanyapan niyu, kakaun, sīn, iban ayaw kamu magdā badjuꞌ dugaing dayn sin ha baran niyu. ");
INSERT INTO tsg_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Hawnu-hawnu bāy kakadtuan niyu, bang marayaw in pagꞌasip kaniyu, duun na kamu hantiꞌ ha bāy yan, ha salugay niyu duun ha kawman yan. ");
INSERT INTO tsg_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Na, bang kamu mākawn pa kawman sin manga tau amu in diꞌ magꞌasip kaniyu, īg kamu dayn ha kawman yan ampa niyu paspasi in bagunbun dayn ha siki niyu (ha supaya mapakitaꞌ niyu in tandaꞌ sin in kamu puas na dayn kanila).” ");
INSERT INTO tsg_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Na, miyanaw na in manga mulid hi Īsa pa manga katān lūngan nagnasīhat sin Baytaꞌ Marayaw iban nagpauliꞌ ha manga tau nasasakit haunu-haunu in kahapitan nila. ");
INSERT INTO tsg_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Manjari kiyarungugan mayan hi Hirud, amu in namamarinta ha Jalil, in manga katān nahinang hi Īsa nahilu tuud in pamikil niya sabab laung sin kaibanan in hi Īsa amuna hi Yahiya Mangliliguꞌ nabuhiꞌ nagbalik. ");
INSERT INTO tsg_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Laung isab sin kaibanan in hi Īsa amuna hi Nabi Ilyas nagbalik pa dunya iban laung isab sin kaibanan hambuuk siya nabi sin masa nakauna nabuhiꞌ nagbalik. ");
INSERT INTO tsg_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Laung hi Hirud, “In hi Yahiya piyapunggulan ku liug, sagawaꞌ hisiyu bahaꞌ in tau ini diyungug ku nakahinang sin manga muꞌjijat ini?” Hangkan mabayaꞌ tuud siya dumā magkitaꞌ kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sakali nakabalik na in manga kiyawakilan hi Īsa, iban biyaytaan nila hi Īsa sin katān nahinang nila. Piyaagad niya kaniya in manga kiyawakilan niya ampa sila miyadtu pa hambuuk dāira pagngānan Bitsayda. Sila-sila sadja in miyadtu. ");
INSERT INTO tsg_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Sakali imurul kaniya in manga tau mataud nakaingat mayan bang piyakain siya. Iyasip niya marayaw in manga tau iban niyasīhatan niya sila pasal sin pamarinta sin Tuhan. Iban napauliꞌ niya isab in manga tau taga sakit hisiyu-siyu sila magkagunahan sin tabang niya. ");
INSERT INTO tsg_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Na, pagga sin magsasadlup na in suga miyawn na kan Īsa in hangpuꞌ tagduwa mulid niya, laung nila, “Tuwan, marayaw pa pakadtuun mu in manga tau pa manga lūngan iban pa manga bāy sin manga magꞌuuma amu in masuuk mari bat sila makabāk kakaun iban lugal pagtūgan nila sabab wayruun tau naghuhulaꞌ ha hulaꞌ ini.” ");
INSERT INTO tsg_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Sagawaꞌ laung hi Īsa kanila, “Kamu na in dumihil kakaun kanila.” In sambung nila, “Na, amura lima tinapay iban duwa istaꞌ in kakaun natuꞌ ini. Unu in kabayaan mu hinangun namuꞌ? Madtu ka kami mamī kakaun hipakaun ha manga tau mataud ini?” ");
INSERT INTO tsg_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Awn manga lima ngaibu in taud sin manga tau, amu in usug sadja.) Laung hi Īsa ha manga mulid niya, “Papalingkura niyu in manga tau kayꞌman-kayꞌman hangka-tumpuk.” ");
INSERT INTO tsg_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Na, iyagad sin manga mulid niya in baytaꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nakalingkud mayan in manga tau, kiyawaꞌ hi Īsa in lima tinapay iban duwa istaꞌ. Himangad siya pa taas langit ampa siya nagsarang-sukul pa Tuhan. Pagꞌubus niya piyagꞌutud-utud in manga tinapay, diyuhal niya pa manga mulid niya ampa piyarihil pa manga tau. ");
INSERT INTO tsg_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Na, nakakaun in tau katān iban kiyansuban sila. Pagꞌubus sin manga tau nagkaun, tīpun sin manga mulid hi Īsa in nakapin kakaun. Nakahipuꞌ sila hangpuꞌ tagduwa ambung. ");
INSERT INTO tsg_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Manjari hambuuk adlaw duun hi Īsa isa-isa niya nangangarap pa Tuhan. Sakali miyawn kaniya in manga mulid niya. Laung hi Īsa kanila, “Bang ha bichara sin manga tau, hisiyu kunuꞌ aku?” ");
INSERT INTO tsg_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","In sambung nila, “Laung sin kaibanan tau ikaw kunuꞌ hi Yahiya Mangliliguꞌ. Na, in kaibanan isab laung nila, ikaw kunuꞌ hi Ilyas. Ampa isab in kaibanan laung nila, hambuuk kaw kunuꞌ nabi sin masa nakauna yadtu amu in nabuhiꞌ nagbalik.” ");
INSERT INTO tsg_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Na, laung hi Īsa kanila, “Na, bang kamu, hisiyu aku?” In sambung hi Pitrus, “Ikaw in Almasi (amu kiyawakilan sin Tuhan magbayaꞌ ha unu-unu katān).” ");
INSERT INTO tsg_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Na, ībut-ibutan tuud sila hi Īsa diꞌ pabaytaun minsan hisiyu sin pasal ini. ");
INSERT INTO tsg_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Laung niya pa isab kanila. “In aku amu in Anak Mānusiyaꞌ subay tuud makalabay kabinsanaan dakulaꞌ iban kahukawan tuud aku sin manga nagtatau-maas ha hulaꞌ, sin manga nakuraꞌ kaimaman iban sin manga guru sin saraꞌ agama. Hipapatay nila aku, sagawaꞌ ha hikatū sin adlaw dayn ha kamatay kākuꞌ mabuhiꞌ da aku magbalik.” ");
INSERT INTO tsg_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Iban laung niya kanila katān, “Bang awn tau mabayaꞌ magad kākuꞌ, subay agarun niya in kabayaan ku bukun in kabayaan niya. Subay siya mangaku sin katān haggut-pasuꞌ ha kuꞌnu-kuꞌnu waktu minsan siya mapatay ha pasal ku ampa siya tūpun magad kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Karnaꞌ hisiyu-siyu in maūg ha kabuhiꞌ niya iban magpikil sadja sin kabayaan niya, tantu mapatay da siya. Sagawaꞌ hisiyu-siyu in diꞌ maūg ha kabuhiꞌ niya minsan siya mapatay ha pasal ku, tantu makabaak siya kabuhiꞌ salama-lama. ");
INSERT INTO tsg_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Sabab unu in kapūsan sin hambuuk tau magparūl sadja sin katān kanapsuhan niya dī ha dunya bang ha adlaw mahuli masiksaꞌ da in nyawa niya ha lawm narkaꞌ? ");
INSERT INTO tsg_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Na, hisiyu-siyu in masipug imiyan sin agad siya kākuꞌ iban masipug magad sin manga hinduꞌ ku, na in aku amu in Anak Mānusiyaꞌ masipug da isab imiyan sin in siya agad kākuꞌ bang aku magbalik na mari pa dunya iban sin manga malāikat. Pagbalik ku mari nalilibut aku sin sahaya ku iban sin sahaya sin Amaꞌ Tuhan, iban sin manga malāikat. ");
INSERT INTO tsg_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ini in mattan hibaytaꞌ ku kaniyu. Awn kaibanan dī kaniyu in masi pa buhiꞌ sampay maabut in waktu kamasahan nila dumatung in pamarinta sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Manjari, manga hangka-pitu na in nakalabay pagꞌubus niya namung sin manga pasal yan, diyā hi Īsa timukad hi Pitrus, hi Yahiya iban hi Yaꞌkub madtu pa taas būd nangarap pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ha saꞌbu niya nangangarap pa Tuhan, magtūy napinda in lupa sin pamayhuan niya iban nagsahaya tuud sin kaputiꞌ sin tamungun niya. ");
INSERT INTO tsg_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sakali magtūy awn duwa tau duun iban hi Īsa nagbichara. In duwangka-tau ini hi Musa kay Ilyas, manga nabi amu in malugay na nanaykud dayn ha dunya. ");
INSERT INTO tsg_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nagsasahaya sila nagpanyataꞌ mawn kan Īsa. Nagbichara sila iban hi Īsa pasal sin kamatay hi Īsa ha Awrusalam (Baytal Makdis) amu in masuuk na dumatung ha susūngun iban amu in dumihil kamakbulan ha maksud sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Na, in hi Pitrus iban sin duwa iban niya nahahaluk natūg, sagawaꞌ nakabatiꞌ sila iban kītaꞌ nila nagsahaya hi Īsa iban sin duwa tau nagtitindug duun. ");
INSERT INTO tsg_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Sūng mayan mīg in duwa tau ini, laung hi Pitrus kan Īsa, “Tuwan, marayaw tuud isab sin yari kami dī! Hinangan namuꞌ kamu tū panggung, hambuuk kaymu, hambuuk kan Musa iban hambuuk kan Ilyas.” (Biyaꞌ hantang bukun ha lawm sayu hi Pitrus namung sin biyaꞌ ha yan.) ");
INSERT INTO tsg_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ha saꞌbu niya pa nagbibichara, awn gabun gimuwaꞌ sartaꞌ kiyalambungan sila. Na, miyugaꞌ tuud in manga mulid hi Īsa kiyalambungan mayan sila sin gabun. ");
INSERT INTO tsg_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sakali awn na kiyarungugan nila suwara dayn ha gabun. Amu agi sin suwara, “Amu na ini in Anak ku, amu in asal kiyasukuan ku huminang sin maksud ku. Dungug kamu sin hinduꞌ niya!” ");
INSERT INTO tsg_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Himundung mayan in suwara, amu dakuman hi Īsa in kītaꞌ nila duun. Na, walaꞌ tuud nagkaybaꞌ in manga mulid hi Īsa sin manga pasal ini. Iban ha waktu yadtu walaꞌ tuud sila namaytaꞌ minsan hisiyu pasal sin manga kītaꞌ nila. ");
INSERT INTO tsg_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Na, pagꞌadlaw hambuuk limūd na hi Īsa iban sin tū mulid niya dayn ha taas būd. Biyāk hi Īsa sin manga tau mataud. ");
INSERT INTO tsg_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Sakali awn duun hambuuk tau in imulak, laung niya, “Tuwan Guru, pangayuun ku junjung kaymu. Kaluuyi in anak ku usug. Tunggal siya anak ku. ");
INSERT INTO tsg_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Magtaghaꞌ sadja siya magsilawak iban dumakdak magpaspad bang siya sūrun na saytan. Magbukal-bukal in simud niya iban agun siya diꞌ paghundungan binasahun sampay wayruun na makapin kusug niya. ");
INSERT INTO tsg_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Jiyunjung ku ha manga mulid mu papaguwaun in saytan dayn ha lawm baran sin anak ku, sagawaꞌ diꞌ nila mahinang.” ");
INSERT INTO tsg_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","In sambung hi Īsa, “Anduꞌ, in manga tau sin masa ini wayruun tuud pangandul pa Tuhan iban bingkuk tuud in pamikil. Maunu pa in lugay ku dimī kaniyu ampa niyu kahātihan in kusug sin kawasa sin Tuhan? Maunu pa in lugay sandalan ku ampa kamu magparachaya?” Pagꞌubus laung niya ha tau, “Dāha mari kākuꞌ in anak mu.” ");
INSERT INTO tsg_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nakasuuk mayan mawn in bataꞌ, dimakdak siya pa lupaꞌ sartaꞌ nagpaspad na siya sabab sin saytan ha lawm baran niya. Sagawaꞌ iyuldinan hi Īsa in saytan paguwaun sartaꞌ kiyaulian na in bataꞌ. Na, piyakadtu niya na in bataꞌ pa amaꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Na, nahaylan tuud in tau katān pagkitaꞌ nila sin kusug sin kawasa sin Tuhan. Na, ha saꞌbu sin manga tau katān masi namān nagꞌiinu-inu pasal sin manga katān nahinang hi Īsa, namung hi Īsa ha manga mulid niya, laung niya, ");
INSERT INTO tsg_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ayaw niyu kalupahi in hibaytaꞌ ku bihaun kaniyu! In aku amu in Anak Mānusiyaꞌ masuuk na hiungsud pa lawm lima sin manga tau.” ");
INSERT INTO tsg_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Sagawaꞌ walaꞌ kiyahātihan sin manga mulid niya in maana sin bichara niya, sabab in yan līlibun dayn kanila bat nila diꞌ kaingatan. Iban mabugaꞌ isab sila mangasubu kan Īsa sin pasal yan. ");
INSERT INTO tsg_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Sakali naglugat in manga mulid hi Īsa pasal bang hisiyu in mataas tuud dayn kanila. ");
INSERT INTO tsg_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kiyaiingatan hi Īsa bang unu in pīpikil nila. Hangkan kimawaꞌ siya hambuuk bataꞌ-bataꞌ ampa niya piyatindug ha daig niya. ");
INSERT INTO tsg_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ubus ampa siya namung, laung niya, “Hisiyu-siyu in magparuli tuud ha bataꞌ-bataꞌ biyaꞌ ha ini, sabab-karnaꞌ agad siya kākuꞌ, na biyaꞌ da tuud isab baran ku in piyaruli niya, iban hisiyu-siyu in magparuli kākuꞌ, na piyaruli niya da isab in nagdaak mari kākuꞌ. Sabab hisiyu-siyu dayn kaniyu in magpatibabaꞌ amu in itungun sin Tuhan labi mataas dayn ha katān.” ");
INSERT INTO tsg_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Namung hi Yahiya, laung niya, “Tuwan, awn kītaꞌ namuꞌ hambuuk tau simabbut sin ngān mu nagpaguwaꞌ manga saytan dayn ha lawm baran sin tau. Liyāng namuꞌ siya sabab bukun siya agad kātuꞌniyu.” ");
INSERT INTO tsg_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","“Ayaw niyu siya lāngi,” laung hi Īsa kan Yahiya iban sin manga kaibanan mulid niya, “sabab hisiyu-siyu in bukun kimukuntara kaniyu na amuna in agad kaniyu.” ");
INSERT INTO tsg_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Manjari pagga magsusuuk na in waktu sin pagbalik hi Īsa pa surgaꞌ, hiyambuuk niya na in pikilan niya sin madtu siya pa Awrusalam (Baytal Makdis). Na miyanaw na siya. ");
INSERT INTO tsg_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nagdaak siya manga tau miyuna dayn kaniya madtu pa hambuuk kawman ha hulaꞌ Samariya ha supaya makapagsakap in manga tau datungan niya. ");
INSERT INTO tsg_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sagawaꞌ in manga tau didtu ha kawman yadtu diꞌ mabayaꞌ magparuli kan Īsa sabab matampal kanila sin harap pa Awrusalam (Baytal Makdis) in gawi hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Na, pagꞌingat sin duwa mulid niya, hi Yaꞌkub kay Yahiya, sin diꞌ magparuli kan Īsa in manga tau, diyugalan sila. Laung nila kan Īsa, “Panghuꞌ, mabayaꞌ kaw mangayuꞌ kami duwaa bang mayan sila panaugan kāyu dayn ha langit bat sila maubus mapatay?” ");
INSERT INTO tsg_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Iyatud sila hi Īsa ampa piyagꞌamahan. ");
INSERT INTO tsg_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Pagꞌubus ampa hi Īsa iban sin manga mulid niya limanjal pa dugaing kawman. ");
INSERT INTO tsg_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sakali ha saꞌbu nila miyamanaw, awn hambuuk tau imiyan kan Īsa, laung niya, “Tuwan, magad aku kaymu minsan kaw pakain.” ");
INSERT INTO tsg_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","In sambung hi Īsa kaniya, “In manga iruꞌ talun awn lugal pagꞌuwian nila iban in kamanuk-manukan awn pugad paghali-halihan nila, sagawaꞌ in aku amu in Anak Mānusiyaꞌ wayruun tantu lugal pagtūgan iban paghali-halihan ku.” ");
INSERT INTO tsg_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Laung hi Īsa ha hambuuk tau, “Agad na kaw kākuꞌ.” Sagawaꞌ laung sin tau, “Huun, Tuwan, saꞌ pauwia naa aku magbalik pa bāy. Bang ku hikakubul na in amaꞌ ku, ampa aku mari magbalik magad kaymu.” ");
INSERT INTO tsg_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Sagawaꞌ laung hi Īsa kaniya, “Ayaw na kaw mabimbang sin pasal yan, sabab in manga tau patay (in pagtaat nila pa Tuhan), amu in matūp magkubul ha manga patay. Kadtu na kaw pagpamahalayak pasal sin pamarinta sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Laung sin hambuuk tau, “Tuwan, magad aku kaymu, sagawaꞌ pakadtua naa aku muna pa bāy mamaid ha manga anak-asawa ku.” ");
INSERT INTO tsg_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Laung hi Īsa kaniya, “Hisiyu-siyu in magꞌararu ampa siya daran naglilingiꞌ pa ulihan, hāti niya, wayruun ha lawm pikilan niya in pagꞌararu niya. Mataud dugaing in pīpikil niya. Damikkiyan, in tau mabayaꞌ magad kākuꞌ, ampa awn pa dugaing kabimbangan niya, na hāti niya diꞌ siya tūpun lumamud ha lawm pamarinta sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pagꞌubus yadtu awn isab kapituwan-tagduwa tau in pinīꞌ sin Panghuꞌ papagnasīhatun pa manga kawman iban kahulaꞌ-hulaan amu in sūng niya da isab kadtuun baran niya. Piyapagbunyug niya duwa-ruwangka-tau in manga diyaak niya piyauna dayn kaniya. ");
INSERT INTO tsg_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Laung niya kanila, “In manga tau (mabayaꞌ na magad ha hinduꞌ sin Baytaꞌ Marayaw) biyaꞌ sapantun manga bunga sin tiyanum amu in tūp na tuud pusuun, sagawaꞌ hangkatiyuꞌ da in magpupusuꞌ. Hangkan pangayuꞌ-ngayuꞌ kamu duwaa ha tagdapu sin tiyanum bang mayan siya magdaak mari manga tau tumabang magpusuꞌ sin manga bunga sin tiyanum. ");
INSERT INTO tsg_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kadtu na kamu. In kamu yan biyaꞌ sapantun manga anak bili-bili pakadtuun pa lawm baanan iruꞌ talun amu in mangangaun kanila. ");
INSERT INTO tsg_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ayaw na kamu magsusa magdā pitakaꞌ, atawa pagluluunan sin kapanyapan niyu atawa tawmpaꞌ. Ayaw na kamu humundung sumagina ha manga tau hipaglanggal niyu ha dān. ");
INSERT INTO tsg_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Bang kamu sumūd pa lawm bāy sin tau haunu-haunu, magtūy niyu pangayui duwaa pa marayaw. Laung niyu, ‘Bang mayan awn kasannyangan sin lawm bāy ini.’ ");
INSERT INTO tsg_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na, bang in manga tau ha lawm bāy yan tūpun dihilan kasannyangan, na maawn in kasannyangan piyangayuꞌ niyu duwaa kanila. Sagawaꞌ bang sila diꞌ tūpun dihilan kasannyangan, na diꞌ maawn in kasannyangan piyangayuꞌ niyu duwaa kanila. ");
INSERT INTO tsg_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tutug kamu ha hambuuk bāy. Kauna iban inuma niyu in unu-unu hilabut nila kaniyu, sabab amu yan in balanjaꞌ niyu. Karnaꞌ in manga maghihinang tūp gadjihan sin manga tau piyaghulas-sangsaan nila. Ayaw na kamu maglayn dayn ha hambuuk bāy pa hambuuk bāy. ");
INSERT INTO tsg_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Kuꞌnu-kuꞌnu kamu makakawn pa hambuuk kawman, ampa kamu hulmatun sin manga tau, kauna in unu-unu hilabut kaniyu. ");
INSERT INTO tsg_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Paulia niyu in manga nasasakit ha kawman yan iban baytai niyu in manga tau duun, laung niyu, ‘In pamarinta sin Tuhan yari na dimatung kaniyu.’ ");
INSERT INTO tsg_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Sagawaꞌ kuꞌnu-kuꞌnu kamu makakawn pa hambuuk kawman, ampa kamu diꞌ asipun sin manga tau, kadtu kamu pa manga karān-dānan ampa niyu iyana in manga tau, laung niyu, ");
INSERT INTO tsg_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Minsan in bagunbun dayn ha hulaꞌ ini amu in mikit ha siki namuꞌ pakpakun namuꞌ da, (amu in tandaꞌ sin diꞌ na kamu parulihun namuꞌ). Sagawaꞌ ini in tumtuma niyu. In pamarinta sin Tuhan bakas na dī kaniyu.’” ");
INSERT INTO tsg_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na, laung hi Īsa, “Baytaan ta kamu, bang ha adlaw paghukum na ha manga mānusiyaꞌ, mabuggat pa in hukuman hibutang sin Tuhan ha manga tau ha kawman yan dayn sin hukuman hibutang niya ha manga tau sin hulaꞌ Sudum, (amu in hulaꞌ bakas tanyag in kangīan niya).” ");
INSERT INTO tsg_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Anduꞌ, in kamu yan manga tau Kurasin iban manga tau Bitsayda diꞌ hikasipat in kasusahan niyu ha susūngun! Sabab maytaꞌ? Mataud muꞌjijat bakas piyakitaꞌ kaniyu, sagawaꞌ walaꞌ niyu da iyasip. Malayngkan bang in manga muꞌjijat yan napakitaꞌ muna ha manga tau ha dāira Tirus iban ha dāira Sidun, tantu magtūy sila magsulug badjuꞌ karut iban magbutang abu pa ū nila, tandaꞌ sin piyagtawbatan nila na in dusa nila. ");
INSERT INTO tsg_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Na bang ha adlaw paghukum na ha manga mānusiyaꞌ, mabuggat in hukuman hibutang sin Tuhan kaniyu. Labi pa in buggat niya dayn sin hukuman hibutang pa manga tau Tirus iban manga tau Sidun. ");
INSERT INTO tsg_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na, in manga kamu isab manga tau Kapirnaum, nagbantug-bantug kamu sin makasampay kamu pa surgaꞌ. Sagawaꞌ narkaꞌ in sampayan niyu!” ");
INSERT INTO tsg_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Na, laung hi Īsa ha manga mulid niya, “Hisiyu-siyu in dumungug kaniyu, saliꞌ da aku in diyungug niya. Damikkiyan, hisiyu-siyu in sumulak kaniyu, saliꞌ da aku in siyulak niya, iban hisiyu-siyu in sumulak kākuꞌ biyaꞌ niya da isab siyulak in nagdaak kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Manjari nakabalik na in manga kapituwan-tagduwa tau naraak niya nagnasīhat. Landuꞌ tuud sila kiyūgan. Laung nila kan Īsa, “Panghuꞌ, minsan in manga saytan ha lawm baran sin manga tau nagkahagad da sin uldin namuꞌ, pagsabbut namuꞌ sin ngān mu!” ");
INSERT INTO tsg_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","In sambung hi Īsa kanila, “Mattan tuud yan, sabab kītaꞌ ku in Saytan Puntukan nahulug biyaꞌ sin kasay sin kilat magsiꞌnag ha langit. Diyaug in kusug niya. ");
INSERT INTO tsg_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kitaa niyu ba, dihilan ta kamu barakat ha supaya minsan kamu makagiik hās atawa tangangngang diꞌ kamu maunu. Iban ha supaya kamu isab diꞌ daugun sin katān kusug sin Saytan Puntukan, amu in kuntara taniyu. Way tuud makamula kaniyu minsan unu. ");
INSERT INTO tsg_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Malayngkan, subay kamu makuyag bukun pasal kapagꞌagihan niyu in manga saytan, sagawaꞌ pasal sin kiyasulat na in manga ngān niyu ha surgaꞌ.” ");
INSERT INTO tsg_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Na sartaꞌ ha waktu da isab yan, in hi Īsa nahipuꞌ sin kakuyagan dīhil kaniya sin Rū sin Tuhan. Laung niya, “Ya Amaꞌ ku, ikaw da in makapagbayaꞌ sin unu-unu katān ha langit iban dunya! Magsukul tuud aku kaymu, sabab in piyaglimbung mu dayn ha tau taga ingat sampay taga pangadjiꞌ, amuna in piyahāti mu ha manga tau awam. Na, in yan mattan tuud, Amaꞌ ku, sabab biyaꞌ ha yan in kabayaan mu maawn.” ");
INSERT INTO tsg_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Laung pa isab hi Īsa, “Kiyarihil na kākuꞌ sin Tuhan, Amaꞌ ku in unu-unu katān. Wayruun makaingat tuud kākuꞌ amu in Anak Tuhan luwal da in Amaꞌ Tuhan. Damikkiyan da isab wayruun na makaingat tuud ha Amaꞌ Tuhan luwal da aku, amu in Anak niya, iban sin manga tau amu in miyaksud ku paingatun.” ");
INSERT INTO tsg_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pagꞌubus, ampa hi Īsa himarap pa manga mulid niya ampa siya namung kanila ha wayruun tau dugaing makarungug kanila. Laung niya, “Awn da karayawan niyu sabab nakakitaꞌ na kamu sin manga piyakitaꞌ sin Tuhan kaniyu! ");
INSERT INTO tsg_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Baytaan ta kamu, mataud in manga nabi iban manga sultan ha masa nakauna yadtu in mabayaꞌ tuud kumitaꞌ sin manga kīkitaꞌ niyu bihaun, sagawaꞌ walaꞌ nila kītaꞌ. Iban mabayaꞌ tuud sila dumungug sin manga diyurungug niyu bihaun, sagawaꞌ walaꞌ nila diyungug.” ");
INSERT INTO tsg_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Sakali awn hambuuk guru, amu in mapanday tuud pasal sin saraꞌ agama in miyawn sumulay lumusut kan Īsa ha bichara. Laung niya, “Tuwan, unu in hinangun ku ha supaya aku kasukuan sin kabuhiꞌ salama-lama?” ");
INSERT INTO tsg_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","In sambung hi Īsa kaniya, “Unu in baytaꞌ ha lawm Kitab sin saraꞌ daakan naug dayn kan Musa? Biyaꞌ diin in panghāti mu?” ");
INSERT INTO tsg_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","In sambung sin guru, “In baytaꞌ sin Kitab, ‘Wajib puspusun niyu in lasa niyu ha Tuhan, Panghuꞌ niyu, labi dayn ha unu-unu katān ha lawm atay niyu, ha kabuhiꞌ niyu iban ha lawm pikilan niyu, iban diꞌ niyu hipagꞌūg kaniya in hulas-sangsaꞌ niyu. Iban subay in lasa niyu ha pagkahi niyu mānusiyaꞌ, biyaꞌ sin lasa niyu ha baran niyu.’” ");
INSERT INTO tsg_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Nakaamu tuud in sambung mu,” laung hi Īsa. “Kahagara in manga daakan yan bat awn kabuhiꞌ mu salama-lama.” ");
INSERT INTO tsg_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Sagawaꞌ in kabayaan sin guru sin saraꞌ agama wayruun sawayun kaniya hi Īsa. Hangkan iyasubu niya hi Īsa, laung niya, “Hisiyu bahaꞌ in pagkahi ku subay kalasahan ku?” ");
INSERT INTO tsg_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","In sambung hi Īsa, “Awn yaun hambuuk tau Yahudi limūd dayn ha Awrusalam (Baytal Makdis) madtu pa Ariha. Sakali ha saꞌbu niya ha dān pa, liyangpasan siya sin manga tau mangīꞌ. Hiyubuan siya ampa bīnasa tuud. Walaꞌ siya hiyundungan bīnasa sampay agun-agun na siya matay ampa minīg in manga manglalangpas. ");
INSERT INTO tsg_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sakali nagtaghaꞌ isab awn hambuuk imam Yahudi in limabay dayn ha dān yaun. Sagawaꞌ pagkitaꞌ niya ha tau bakas liyangpasan, simikuꞌ siya pa hansipak sin dān limabay dayn ha kalayuan. ");
INSERT INTO tsg_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Damikkiyan, awn da isab hambuuk bilal Yahudi in nakalabay. Sagawaꞌ iyatud niya sadja in tau bakas liyangpasan, ubus ampa siya simikuꞌ limabay ha hansipak sin dān. ");
INSERT INTO tsg_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Manjari awn hambuuk tau Samariya in nakalabay isab dayn ha dān yaun. Piyaglanggal niya in tau kiyalangpasan. Pagkitaꞌ niya ha tau, limuuy tuud siya. ");
INSERT INTO tsg_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kiyadtu niya in tau iyubatan in paliꞌ sin lana iban alak ampa niya piyutus. Pagꞌubus ampa niya piyasakat in tau pa hayup piyanguraan niya. Diyā niya in tau pa hambuuk bāy paghahantian ampa niya iyupiksaꞌ marayaw. ");
INSERT INTO tsg_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pagꞌadlaw hambuuk, giyuwaꞌ niya in duwa pilak batu ampa niya dīhil pa tau tagdapu sin bāy paghahantian. Laung niya ha tagdapu, ‘Ipata siya marayaw. Pila-pila na in hikabalanjaꞌ mu labi dayn sin sīn ini bayaran ku kaymu paghapit ku ha uwiꞌ ku.’” ");
INSERT INTO tsg_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Na, mahuli dayn duun, laung hi Īsa. “Na, ha pikil mu hisiyu ha tūngka-tau in nagpakitaꞌ sin lasa niya ha pagkahi niya liyangpasan sin manga tau mangīꞌ?” ");
INSERT INTO tsg_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","In sambung sin guru sin saraꞌ agama, “Amu in tau limuuy iban nagꞌupiksaꞌ kaniya.” Laung hi Īsa, “Na kadtu na kaw ampa mu hinanga in biyaꞌ sin nahinang niya.” ");
INSERT INTO tsg_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Manjari limanjal na miyanaw hi Īsa iban sin manga mulid niya. Nākawn sila pa kawman piyaghuhulaan sin hambuuk babai pagngānan hi Marta. Siyawmbibi niya hinda Īsa ha lawm bāy niya. ");
INSERT INTO tsg_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Awn hambuuk taymanghud niya babai pagngānan hi Mariyam. In siya ini limingkud ha tungud siki sin Panghuꞌ Īsa dimungug sin pagnasīhat niya. ");
INSERT INTO tsg_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Na, nahilu in ū hi Marta sin taud sin hinangun niya. Hangkan miyawn siya kan Īsa, laung niya, “Anduꞌ Tuwan, diꞌ mu ka maparuli in kahālan ku ini? Piyasāran aku sin taymanghud ku maghinang sin katān hinang. Bang mu bahaꞌ siya iyanun patabangun kākuꞌ?” ");
INSERT INTO tsg_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","In sambung sin Panghuꞌ Īsa kaniya, “Marta, maytaꞌ kaw magsusa iban magpahilu sin pikilan mu pasal sin manga unu-unu katān, ");
INSERT INTO tsg_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","malayngkan, hambuuk da in kagunahan niyu tuud, amu in napīꞌ hi Mariyam. In hinang niya nakaamu iban subay yan diꞌ īgan dayn kaniya.” ");
INSERT INTO tsg_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Manjari awn hambuuk adlaw duun hi Īsa nangangarap pa Tuhan ha hambuuk lugal. Sakali pagꞌubus niya nangarap pa Tuhan, namung in hambuuk mulid niya kaniya. Laung niya, “Panghuꞌ, hindui kami mangarap pa Tuhan, biyaꞌ kan Yahiya, hīnduan niya in manga mulid niya.” ");
INSERT INTO tsg_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Laung hi Īsa kanila, “Bang kamu mangarap pa Tuhan subay biyaꞌ ha ini in hibichara niyu: ‘Ya Amaꞌ namuꞌ, bang mayan lagguun sin mānusiyaꞌ in ngān mu mahasuchi. Bang mayan ikaw na in mamarinta ha mānusiyaꞌ katān. ");
INSERT INTO tsg_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Dihili kami adlaw ini sin kakaun kagunahan namuꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ampuna in manga dusa namuꞌ, karnaꞌ maapun namuꞌ da isab in katān hisiyu-siyu nakarusa kāmuꞌ. Palayua kami dayn ha kasigpitan makapilad sin īman namuꞌ.’” ");
INSERT INTO tsg_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Na, laung hi Īsa ha manga mulid niya, “Bang sawpama awn hambuuk dī kaniyu in madtu pa bāy sin bagay niya sin tungaꞌ dūm ampa imiyan, laung niya, ‘Bagay, pasambia ba aku tū tinapay. ");
INSERT INTO tsg_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Awn hambuuk bagay ku in iyampa nakaratung pa bāy ku dayn ha panawan, sagawaꞌ wayruun kakaun hikalabut ku kaniya!’ ");
INSERT INTO tsg_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Na, bang sawpama isab,” laung hi Īsa, “in sambung sin bagay niya dayn ha lawm bāy, amu agi, ‘Ayaw na kaw manghiluhalaꞌ kākuꞌ! In lawang sin bāy ku mahugut na in katambul iban yari na kami nagkukulang iban sin manga anak ku. Malisuꞌ na aku magbangun dumuhal matun kaymu sin piyangayuꞌ mu.’ ");
INSERT INTO tsg_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Na, unu na in kasūngan? Baytaan ta kamu, minsan in tau yan malisuꞌ magbangun dumihil sin tinapay piyangayuꞌ mu ha tungud sin pagbagay niyu, bang kaw matugul iban diꞌ masipug mangayuꞌ kaniya, diꞌ lumugay malugus da siya dumihil sin unu-unu na kagunahan mu. ");
INSERT INTO tsg_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Hangkan ini in hibaytaꞌ ku kaniyu. Ayaw kamu masumu mangayuꞌ sabab tantu karihilan da kamu. Ayaw kamu masumu lumawag sabab tantu makabāk da kamu. Ayaw kamu masumu kumuꞌkuꞌ sin lawang sabab tantu kaukaban da kamu. ");
INSERT INTO tsg_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Karnaꞌ hisiyu-siyu in mangayuꞌ, karihilan siya. In hisiyu-siyu lumawag makabāk siya iban in hisiyu-siyu kumuꞌkuꞌ sin lawang kaukaban siya, minsan hisiyu. ");
INSERT INTO tsg_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Na, asubuhun ta kamu manga kaamaan. Dihilan niyu ka hās in anak niyu bang mangayuꞌ istaꞌ kaniyu? ");
INSERT INTO tsg_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Atawa dihilan niyu ka siya tangangngang bang mangayuꞌ iklug kaniyu? ");
INSERT INTO tsg_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Na, minsan biyaꞌ diin in ngīꞌ niyu, maingat da isab kamu mangdihil sin unu-unu hikarayaw ha manga anak niyu. Na, amu pa ka isab in Tuhan, Amaꞌ niyu ha surgaꞌ in diꞌ maingat dumihil sin hikarayaw kaniyu? Patulunan niya sin Rū sin Tuhan in hisiyu-siyu mangayuꞌ kaniya.” ");
INSERT INTO tsg_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sakali awn hambuuk waktu, piyaguwaꞌ hi Īsa in saytan umaw dayn ha lawm baran sin tau. Naumaw in tau sabab sin saytan ha lawm baran niya. Pagguwaꞌ sin saytan nakabichara na in tau. Na, nahaylan tuud in manga tau mataud. ");
INSERT INTO tsg_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Sagawaꞌ laung sin kaibanan tau, “In nagdihil kaniya yan barakat magpaguwaꞌ saytan, hi Bilsibul amu in Nakuraꞌ sin Manga Saytan.” ");
INSERT INTO tsg_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","In kaibanan tau mabayaꞌ sumulay sin barakat hi Īsa. Hangkan nangayuꞌ sila kumitaꞌ hambuuk muꞌjijat dayn kan Īsa bat awn tandaꞌ kakitaan nila sin bunnal tuud naraak siya sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Sagawaꞌ kiyaiingatan hi Īsa bang unu in ha lawm pikilan nila. Hangkan, laung niya kanila, “Bang in manga tau ha hambuuk hulaꞌ nababahagiꞌ, nagdurugaing-dugaing agaran iban nagbunuꞌ-biyunui, na in hulaꞌ yan diꞌ lumugay magkangīꞌ da. Damikkiyan, bang in maglahasiyaꞌ magsaggaꞌ-siyaggai, na diꞌ lumugay kumangīꞌ da sila. ");
INSERT INTO tsg_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Na, hangkan bang sawpama in Saytan Puntukan magkuntara iban sin manga tindug niya, in kusug sin kawasa niya diꞌ tumatas iban diꞌ lumugay kumangīꞌ na sila. Na, in agi niyu hi Bilsibul in nagdihil kākuꞌ barakat magpaguwaꞌ sin manga saytan. ");
INSERT INTO tsg_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Na, bang bunnal in agi niyu yan, na hisiyu bahaꞌ isab in nagdihil barakat ha manga tindug niyu magpaguwaꞌ saytan? In manga tindug niyu, amuna in mamaytaꞌ sin kasāan sin pamikil niyu! ");
INSERT INTO tsg_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tantu in barakat ku magpaguwaꞌ saytan bukun dayn ha Saytan Puntukan, sabab in yan nahinang ku dayn ha kusug sin kawasa sin Tuhan. Na, amu yan in tandaꞌ magpakitaꞌ kaniyu sin in pamarinta sin Tuhan yari na dī bihaun kaniyu.” ");
INSERT INTO tsg_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","(Diyalil hi Īsa in Saytan Puntukan pa hambuuk tau makusug.) Laung niya, “Bang in tau makusug magjaga sin bāy niya panyap iban sin katān pakukus niya, na way kapiligruhan sin katān altaꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Sumagawaꞌ bang siya gubatun sin hambuuk tau labi makusug dayn kaniya tantu daugun siya. Makawaꞌ in katān pakukus amu in piyanghalapan niya, iban sin manga altaꞌ niya ampa pagbahagiꞌ-bahagiun sin tau nanglangpas kaniya. ");
INSERT INTO tsg_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Na, hisiyu-siyu in bukun agad kākuꞌ in siya yan kimukuntara kākuꞌ, iban hisiyu-siyu in diꞌ tumabang kākuꞌ magtipun magpatibuuk ha manga tau, bat sila masukuꞌ sin Tuhan, biyaꞌ niya da piyulak-palik in manga tau.” ");
INSERT INTO tsg_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Laung pa isab hi Īsa, “Bang in saytan makaguwaꞌ na dayn ha lawm baran sin tau, maglunsulan na yan ha hulaꞌ paslangan mahunit paghulaan lumawag lugal paghali-halihan niya, sagawaꞌ diꞌ mayan siya makabāk lugal, laung niya ha baran niya, ‘Magbalik na aku pa lawm baran sin tau bakas kiyabutangan ku.’ ");
INSERT INTO tsg_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Na, pagsūd niya magbalik, kītaꞌ niya wayruun dugaing nakasubli kaniya ha lawm baran sin tau, lāgiꞌ malanuꞌ iban mahawan in lawm niya. ");
INSERT INTO tsg_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Na, gumuwaꞌ siya magbalik ampa siya dumangin pitu saytan labi pa in ngīꞌ dayn kaniya, ubus ampa sila sumūd pa lawm baran sin tau. Na, bang sila makasūd na katān, in kahālan sin tau yan magduruhun in ngīꞌ dayn sin nakauna hambuuk da in saytan ha lawm baran niya.” ");
INSERT INTO tsg_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Saꞌbu hi Īsa nagbibichara, awn hambuuk babai dayn ha manga tau mataud in namung kan Īsa, laung niya, “Landuꞌ in kakuyagan sin babai imanak iban nagpaduruꞌ kaymu!” ");
INSERT INTO tsg_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sagawaꞌ laung hi Īsa, “Labi pa in kakuyagan sin tau dumungug iban magkahagad sin Parman sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Piyagtipunan mayan hi Īsa sin manga tau diꞌ maambat, īyan niya sila, laung niya, “Diꞌ hikasipat in ngīꞌ sin manga tau ha masa ini! Mabayaꞌ sila kumitaꞌ muꞌjijat tandaꞌ sin barakat ku, sagawaꞌ diꞌ sila pakitaun muꞌjijat luwal da in muꞌjijat biyaꞌ sin barakat kimugdan kan Yunus sin masa nakauna yadtu. ");
INSERT INTO tsg_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","In muꞌjijat kimugdan kan Nabi Yunus amu in tandaꞌ nagpakitaꞌ ha manga tau Niniba sin in siya bunnal naraak sin Tuhan. Damikkiyan, in muꞌjijat kumugdan ha amu in Anak Mānusiyaꞌ amu in tandaꞌ magpakitaꞌ ha manga tau sin masa ini, sin bunnal tuud naraak siya sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Na, bang dumatung na in adlaw paghukum sin Tuhan ha manga mānusiyaꞌ katān, taksilun sin hambuuk Pangiyan dayn ha hulaꞌ Siba in manga tau sin masa ini. Sabab in siya minsan malayuꞌ in hulaꞌ niya miyadtu siya dimungug sin manga himumūngan hi Sultan Sulayman amu in tau malawm tuud in ingat niya. Na, baytaan ta kamu, awn dī bihaun in labi pa dayn kan Sulayman. ");
INSERT INTO tsg_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Damikkiyan, in manga tau dayn ha hulaꞌ Niniba, bang maabut in adlaw paghukum ha manga mānusiyaꞌ, manaksil da isab kaniyu. Sabab in sila, pagdungug nila sin nasīhat hi Yunus, magtūy sila nagkahagad iban nagtawbat sin manga dusa nila. Na, baytaan ta kamu, awn dī bihaun kaniyu in labi pa dayn kan Yunus.” ");
INSERT INTO tsg_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Laung pa isab hi Īsa, “Wayruun tau magsūꞌ sin palitaan ubus ampa niya hitapuk atawa lukuban sin pastan. Gām mayan hibutang niya ha pagbubutangan palitaan ha supaya pagsūd sin manga tau kakitaan nila in ilaw. ");
INSERT INTO tsg_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","In manga mata niyu amuna in biyaꞌ sapantun ilaw sin ginhawa-baran niyu. Bang in mata niyu marayaw, (hāti niya bang mabuntul in lawm atay niyu pa Tuhan) na awn kasawahan sin pikilan niyu. Masilang niyu in hinang mabuntul iban bukun. Sagawaꞌ bang in mata niyu bukun marayaw, (hāti niya bang bingkuk in lawm atay niyu) na biyaꞌ sin ha lawm katigidluman in pikilan niyu. Diꞌ niyu masilang in hinang mabuntul iban bukun. ");
INSERT INTO tsg_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hangkan tantuha niyu tuud in baran niyu sin marayaw in pikilan niyu tudju pa Tuhan, bukun ha lawm katigidluman. ");
INSERT INTO tsg_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bang mabuntul in lawm atay niyu, ha wayruun tuud bingkuk-bingkuk niya, na in katān ha lawm pikilan niyu marayaw tuud. Ha lawm kasawahan kamu biyaꞌ kamu sapantun kiyugdan sin sawa sin palitaan.” ");
INSERT INTO tsg_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Sakali naubus mayan nagbichara hi Īsa, tiyaabbit siya sin hambuuk Parisi pasāwhun magkaun kaniya. Na, miyagad na hi Īsa simūd pa lawm bāy niya ampa siya limingkud kimaun. ");
INSERT INTO tsg_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Na, nainu-inu in tau Parisi bang maytaꞌ hi Īsa kimaun minsan walaꞌ nakapanghugas tuud marayaw sin lima niya biyaꞌ sin kaagi sin manga Yahudi magsuchi sin lima nila bang sila kumaun. ");
INSERT INTO tsg_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Hangkan laung sin Panghuꞌ Īsa kanila, “In kamu manga Parisi, tuyuan niyu suchihun in anggawtaꞌ-baran iban kapanyapan niyu, sagawaꞌ in lawm atay niyu bukun suchi sabab hipuꞌ sin kangīan iban bayaꞌ mangulliꞌ ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Dupang tuud kamu! Walaꞌ niyu ka kiyaingatan sin in nagpapanjari sin anggawtaꞌ-baran niyu amura isab in nagpapanjari sin lawm atay niyu? ");
INSERT INTO tsg_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Bang kamu mabayaꞌ masuchi tuud ha unu-unu katān, na panabangan niyu ha manga miskin in manga altaꞌ kiyakaputan niyu. ");
INSERT INTO tsg_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Makaluuy tuud in kamu manga Parisi! Bunnal na sa matuyuꞌ tuud kamu magdihil jakat pa Tuhan. Hiungsud niyu jakat in hambuuk sin hangpuꞌka-bahagiꞌ sin manga dahun-dahun hipagpahamut sin kakaun biyaꞌ na sin dahun-dahun pagngānan minta iban ru. Jakatan niyu isab in kaibanan tiyanum katān biyaꞌ da ha yan. Sagawaꞌ liyupa niyu in kabuntulan iban sin lasa niyu ha Tuhan. Na amuna yan in subay niyu bawgbugan, lāgiꞌ subay niyu da isab diꞌ lupahun in manga kaibanan daakan sin saraꞌ agama. ");
INSERT INTO tsg_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Makaluuy tuud in kamu manga Parisi! Mabayaꞌ tuud kamu lumingkud ha manga lilingkuran tiyatagama ha manga balkanan duun ha langgal. Iban mabayaꞌ tuud kamu salamun iban lagguun sin manga tau duun ha manga tabuꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Makaluuy tuud kamu! Biyaꞌ kamu sin manga kubul wayruun sunduk amu in makasammal ha manga tau bang nila kagiikan.” ");
INSERT INTO tsg_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Sakali awn hambuuk guru sin saraꞌ agama in imiyan kan Īsa, laung niya, “Tuwan, bang kaw magbichara sin biyaꞌ ha yan, biyaꞌ da isab kami in jiyūk mu!” ");
INSERT INTO tsg_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","In sambung hi Īsa, “Makaluuy tuud isab in kamu manga guru sin saraꞌ agama! Pabuꞌgatan niyu in manga tau sin manga daakan sin saraꞌ agama, amu in diꞌ nila marā. Malayngkan, diꞌ kamu magpikil tumabang kanila mamawgbug sin daakan sin saraꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Makaluuy tuud kamu! Piyalingkat niyu in paghinang sin manga tampat sin manga kanabihan bakas biyunuꞌ sin manga kaapuꞌ-apuan niyu. ");
INSERT INTO tsg_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Na, in hinang niyu yan amu in nagpakitaꞌ sin kiyaamuhan kamu sin hīnang sin manga kaapuꞌ-apuan niyu. Biyunuꞌ nila in manga nabi, hāti kamu in nagparayaw sin tampat sin manga nabi gantiꞌ panumtuman kanila. ");
INSERT INTO tsg_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Dayn ha sabab yan, nagparman in Tuhan, amu in makaingat sin unu-unu katān. Amu agi niya, ‘Pakawnun ku kanila in manga nabi iban sin manga kiyawakilan ku. Saꞌ in kaibanan patayun nila, ampa in kaibanan binsanaun nila.’ ");
INSERT INTO tsg_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Na, hangkan in manga tau sin masa bihaun kugdanan sin murkaꞌ sin Tuhan, sabab sin manga nabi biyunuꞌ sin manga kaapuꞌ-apuan nila dayn ha tagnaꞌ pa sin kapanjari sin dunya. ");
INSERT INTO tsg_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Dayn ha kabunuꞌ kan Hābil (amu in anak hi Apuꞌ Adam) sampay pa kabunuꞌ kan Jakariyas, amu in biyunuꞌ duun ha ūt sin lugal pagkukulbanan iban sin Bilik Suchi. Na, baytaan ta kamu sin mattan. In manga tau sin masa ini amu in kugdanan sin murkaꞌ sin Tuhan sabab sin manga katān nabunuꞌ sin kaapuꞌ-apuan nila! ");
INSERT INTO tsg_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Makaluuy tuud in kamu manga guru sin saraꞌ agama! Bang ibārat nagsūd pa lawm bāy, giyunggungan niyu in kunsiꞌ sin lawang bat supaya in manga tau diꞌ makasūd. Hāti niya kamu in timampan sin panghāti sin manga tau pasal sin hinduꞌ bunnal. Diꞌ pa sarang kaniyu siyulak niyu in baytaꞌ kasabunnalan, sagawaꞌ hawiran niyu in kaibanan mabayaꞌ umingat sin kasabunnalan!” ");
INSERT INTO tsg_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Manjari nakaīg mayan hi Īsa dayn ha lugal yaun, mangīꞌ tuud in sawayan sin manga Parisi iban guru sin saraꞌ agama kaniya. Mataud ginisan in piyangasubu nila kan Īsa, ");
INSERT INTO tsg_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ha supaya nila masaggaw hi Īsa ha bichara, bang masāꞌ in kasambung niya. Hāti katuntutan nila hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sakali ha saꞌbu hi Īsa duun nagsasambung-laung iban sin manga Parisi, miyawn in manga tau diꞌ maambat in taud. Nagdigpit tuud in manga tau ibuhan, amu in pagꞌiyanun agun diꞌ kahulugan jawm. Sakali bīcharahan muna hi Īsa in manga mulid niya, laung niya, “Halliꞌ kamu dayn ha pasulig sin manga Parisi, hāti niya amu in addat nila magpabawꞌ-bawꞌ sadja. ");
INSERT INTO tsg_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kaingatan niyu, unu-unu in tiyatapuk tantu gumuwaꞌ da iban unu-unu in līlibun tantu kaingatan da. ");
INSERT INTO tsg_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hangkan, unu-unu in kiyabaytaꞌ niyu ha katigidluman gumuwaꞌ da pa kasawahan iban unu-unu in kiyahagas-hagas niyu ha sipuk-sipuk hipamahalayak da pa mānusiyaꞌ katān. ");
INSERT INTO tsg_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Na, baytaan ta kamu manga bagay ku, ayaw kamu mabugaꞌ ha manga makapatay sin baran niyu, sagawaꞌ wayruun na dugaing kamulahan mahinang nila pagpuas yadtu. ");
INSERT INTO tsg_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Baytaan ta kamu bang hisiyu in subay kabugaan niyu. Tuhan in subay kabugaan niyu, amu in tagakawasa lumaruk kaniyu pa narkaꞌ pagꞌubus niya kamu bugtuan napas. Pagkahagad kamu kākuꞌ sin subay Tuhan tuud in awla kabugaan niyu! ");
INSERT INTO tsg_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Pikila niyu ba in manga manuk-manuk. Bukun ka in lima manuk-manuk asibiꞌ duwa unud sīn da hipagdagang? Biyaꞌ wayruun halgaꞌ nila. Sagawaꞌ minsan in hambuuk manuk-manuk mahalgaꞌ da ha Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na damikkiyan in kamu, minsan in taud sin buhuk ha ū niyu naiitung katān sin Tuhan. Hangkan, ayaw kamu mabugaꞌ sabab labi pa kamu māyuꞌ mahalgaꞌ kaniya dayn ha manga manuk-manuk minsan pila in taud nila!” ");
INSERT INTO tsg_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Iban ini in hibaytaꞌ ku kaniyu. Hisiyu-siyu in magsabunnal ha katauran tau sin agad siya kākuꞌ, amu in Anak Mānusiyaꞌ, magsabunnal da isab aku ha alupan sin manga malāikat sin Tuhan sin in siya agad kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Sagawaꞌ hisiyu-siyu in imiyan ha katauran tau sin in siya bukun agad kākuꞌ, amu in Anak Mānusiyaꞌ, na umiyan da isab aku ha alupan sin manga malāikat sin Tuhan, sin in siya bukun agad kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Hisiyu-siyu in mamung mangīꞌ kākuꞌ, amu in Anak Mānusiyaꞌ, maampun da siya, sagawaꞌ hisiyu-siyu in mamung mangīꞌ ha Rū sin Tuhan, diꞌ siya ampunun sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Na, ha waktu susūngun bang kamu saggawun hukumun ha lawm manga langgal atawa ha alupan sin manga gubnul iban manga sultan, ayaw kamu magsusa bang biyaꞌ diin in kaagi niyu dumaawa atawa bang unu in hibichara niyu. ");
INSERT INTO tsg_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sabab bang dumatung in waktu yan hinduan da kamu sin Rū sin Tuhan, bang unu in hibichara niyu.” ");
INSERT INTO tsg_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Sakali awn hambuuk tau dayn ha manga kamatauran in namung kan Īsa, laung niya, “Tuwan, iyana in taymanghud ku pabahagii aku sin altaꞌ kiyabīn sin amaꞌ namuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","In sambung hi Īsa kaniya, “Utuꞌ, wayruun kapatutan ku sumaraꞌ atawa magbahagiꞌ sin altaꞌ niyu.” ");
INSERT INTO tsg_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Sakali īyan hi Īsa in manga tau katān duun, laung niya, “Kamayaꞌ-mayaꞌ da kamu iban halliꞌ kamu dayn ha manga unu-unu napsu mangīꞌ sabab in tantu kasannyangan iban kakuyagan diꞌ mabī sin manga altaꞌ niyu, minsan da biyaꞌ diin in daya niyu.” ");
INSERT INTO tsg_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pagꞌubus niyasīhatan hi Īsa in manga tau. Diyalil niya kaagi in pagnasīhat niya. Laung niya, “Awn bakas hambuuk tau dayahan taga lupaꞌ iban mabunga tuud in katān tiyanum ha lupaꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Sakali namikil-mikil in tau ini. Laung niya ha baran niya, ‘Wayruun na lugal kapagtawꞌan ku sin manga bunga sin tiyanum ku. Unu na bahaꞌ in hinangun ku? ");
INSERT INTO tsg_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“‘Ah, biyaꞌ ha ini in hinangun ku,’ laung niya ha baran niya, ‘hipalubu ku in manga buriga ku ampa aku magpahinang dakulaꞌ. Duun ku hitawꞌ in manga bunga sin tiyanum iban sin manga altaꞌ ku kaibanan. ");
INSERT INTO tsg_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ubus ampa ku iyanun in baran ku, laung ku, “Ikaw na ini in tau, hipuꞌ sin altaꞌ ginisan hikapagguna minsan pila tahun. Na, ayaw kaw magsusa. Gām mayan pagpakansub kaw kumaun iban minum iban paglami-lami kaw!”’” ");
INSERT INTO tsg_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“‘Sagawaꞌ’ laung sin Tuhan kaniya, ‘Dupang kaw tuud! Sabab ha dūm da ini masalay na kaw iban sin nyawa mu. Mabutas na kaw iban sin altaꞌ mu iban tau dugaing na in magꞌaltaꞌ sin altaꞌ hitawꞌ mu.’” ");
INSERT INTO tsg_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Mahuli dayn duun, laung hi Īsa, “Na, biyaꞌ ha yan in kumugdan ha manga tau amu in magpabūd iban magtawꞌ sadja sin manga altaꞌ pa baran nila. Sagawaꞌ miskin sila ha pangatud sin Tuhan” (sabab wayruun tagaran nila unu-unu ha surgaꞌ.) ");
INSERT INTO tsg_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Pagꞌubus laung hi Īsa ha manga mulid niya, “Na, hangkan ini in hinduꞌ ku kaniyu. Ayaw kamu magsusa pasal sin kabuhianan niyu, bang unu in kaunun niyu, atawa magsusa sin pagtamung niyu. ");
INSERT INTO tsg_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Karnaꞌ in kabuhiꞌ ta labi mahalgaꞌ dayn sin manga kakaun, iban in anggawtaꞌ-baran ta labi mahalgaꞌ dayn sin manga tamungun. ");
INSERT INTO tsg_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kitaa niyu ba in manga manuk-manuk. Diꞌ sila magtanum iban diꞌ sila magꞌani. Wayruun bilik atawa buriga pagtawꞌan nila sin manga kakaun nila. Malayngkan piyakakaun sila sin Tuhan! Na, ayaw pa isab kamu in diꞌ buhiun sin Tuhan? Labi kamu māyuꞌ mahalgaꞌ kaniya dayn sin manga manuk-manuk! ");
INSERT INTO tsg_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Maytaꞌ, humabaꞌ ka in umul niyu bang kamu magsusa? Minsan hangka jām, diꞌ! ");
INSERT INTO tsg_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Na, bang in manga parakalaꞌ sibiꞌ-sibiꞌ biyaꞌ ha yan diꞌ da matabang sin pagsusa niyu, na maytaꞌ pa kamu magsusa sin manga kaibanan? ");
INSERT INTO tsg_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Kitaa niyu ba in manga kasumping-sumpingan yan amu in timubuꞌ isa-isa nila. Diꞌ sila maghinang iban diꞌ sila maghablun sin tamungun nila. Sagawaꞌ baytaan ta kamu, minsan in pakayan hi Sultan Sulayman, amu in bantug tuud dayahan diꞌ da makaatu sin dayaw sin pakayan sin manga kasumpingan yan. ");
INSERT INTO tsg_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tuhan da in magpatamung ha manga kaparangan, amu in buhiꞌ adlaw ini, sagawaꞌ kunsum-kuꞌnisa mapatay da hirungul pa kāyu. Na, bang piyatatamung sin Tuhan in manga kaparangan biyaꞌ ha yan, na amu pa isab kamu in diꞌ patamungun sin Tuhan? Bukun pakarayaw mahugut in pangandul niyu pa Tuhan! ");
INSERT INTO tsg_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Na, hangkan ayaw niyu tuud pahalgaa ha lawm atay niyu in manga kakaun iban inumun kabuhianan niyu. Ayaw kamu magsusa sin pasal yan. ");
INSERT INTO tsg_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sabab mabiyaꞌ kamu sin manga tau bukun bangsa Yahudi, amu in magsusa sadja sin manga kabuhianan nila. Unu-unu in kagunahan niyu, kiyaingatan da sin Tuhan, Amaꞌ niyu. ");
INSERT INTO tsg_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Gām mayan subay Tuhan in papagbayaun niyu ha lawm atay niyu ampa niya hirihil kaniyu in manga kagunahan niyu yan.” ");
INSERT INTO tsg_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“In kamu manga mulid ku, ayaw kamu mabugaꞌ minsan kamu hangkatiyuꞌ da, karnaꞌ in Tuhan, Amaꞌ niyu, makuyag mangandul kaniyu sin pamarinta niya. ");
INSERT INTO tsg_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Dagangan niyu in manga altaꞌ niyu ampa niyu pagsarakkahan ha manga miskin in bīhan niya. Pagpitakaꞌ kamu sin diꞌ magkangīꞌ. In hāti niya pagmarayawan niyu in altaꞌ niyu bat awn daya niyu didtu ha surgaꞌ, amu in daya diꞌ tuud malawaꞌ iban karagdagan sabab wayruun sugarul makatakaw iban wayruun manga kuuk makamula sin manga altaꞌ niyu duun. ");
INSERT INTO tsg_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Karnaꞌ hawnu-hawnu in kiyabutangan sin pangaltaꞌ niyu duun da isab in bimbang sin atay niyu. ");
INSERT INTO tsg_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Pagsakap kamu asal biyaꞌ sapantun sin manga daraakun nagtatagad sin pagꞌuwiꞌ sin nakuraꞌ nila dayn ha pagtiyaunan. Pahugutun nila asal in panamung nila iban sūan nila asal in palitaan nila. Hāti bang siya dumatung iban magkuꞌkuꞌ na sin lawang magtūy nila siya kaukaban. ");
INSERT INTO tsg_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Landuꞌ tuud in kakuyagan sin manga daraakun bang sila karatungan sin nakuraꞌ nila batiꞌ iban sakap! Na, baytaan ta kamu, in nakuraꞌ magtūy magpahugut sin kambut sin badjuꞌ niya bat siya makatanam manglabut ha manga daraakun niya. Palingkurun niya in manga daraakun niya ampa niya sila labutun. ");
INSERT INTO tsg_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Landuꞌ in kakuyagan nila bang sila karatungan sin nakuraꞌ nila sakap ha unu-unu na waktu, tungaꞌ dūm ka atawa subu-subu. ");
INSERT INTO tsg_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Na, ingat kamu. Bang kaingatan sin tau tagdapu bāy bang kuꞌnu waktu sumūd in sugarul pa lawm bāy niya, na diꞌ niya pasāran masūd in bāy niya. ");
INSERT INTO tsg_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na, hangkan in kamu subay isab majaga, sabab in aku, amu in Anak Mānusiyaꞌ, magbalik mari pa dunya ha waktu diꞌ niyu mapikil magbalik aku.” ");
INSERT INTO tsg_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Laung hi Pitrus, “Panghuꞌ, kami sadja ka in kiyatakdilan sin bichara mu yan atawa agad in tau katān?” ");
INSERT INTO tsg_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","In sambung hi Panghuꞌ Īsa, “Hisiyu-siyu in daraakun kapangandulan iban taga akkal, siya in pīun sin nakuraꞌ niya magparuli sin lawm pamāy-bāy niya. Siya in magparuli magdihil sin kakaun sin manga kaibanan daraakun ha sakabaꞌ waktu sin pagkaun. ");
INSERT INTO tsg_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Na, bang in daraakun ini datungan sin nakuraꞌ niya naghihinang siya sin hinang kiyapangandul kaniya, na kumuyag tuud siya! ");
INSERT INTO tsg_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Na, baytaan ta kamu, tantu tuud in daraakun ini amuna in pangandulan sin katān altaꞌ sin nakuraꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Sagawaꞌ bang in daraakun ini sawpama bukun marayaw, laung niya ha lawm atay ‘Ā, malugay pa magbalik in nakuraꞌ ku!’ Na, binasahun niya in manga kaibanan daraakun usug-babai iban magparūl sadja siya sin baran niya magkaun iban maghilu. ");
INSERT INTO tsg_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Sakali in nakuraꞌ sin daraakun ini nagtaghaꞌ na sadja nagbalik ha waktu walaꞌ niya naniyat sin dumatung in nakuraꞌ niya, sabab diꞌ niya kaingatan bang kuꞌnu in balik sin nakuraꞌ niya. Na, tantu lagutun siya tuud sin nakuraꞌ niya iban magsibuꞌ na in uwian niya iban sin manga tau diꞌ magparachaya ha Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Bang kiyaiingatan sin hambuuk daraakun in kabayaan sin nakuraꞌ hipahinang kaniya, ampa diꞌ siya magsakap maghinang, na tantu masakit tuud in paglubak kaniya. ");
INSERT INTO tsg_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Sagawaꞌ bang in hambuuk daraakun diꞌ makaingat bang unu in kabayaan sin nakuraꞌ hipahinang kaniya, ampa siya makarusa, na binsanaun da isab siya, sagawaꞌ bukun biyaꞌ diin in paglubak kaniya. Karnaꞌ in tau kiyarihilan mataud, na mataud da isab in huwat-huwatun tagaran dayn kaniya. Damikkiyan, in tau kiyarihilan landuꞌ mataud, na landuꞌ mataud da isab in huwat-huwatun tagaran dayn kaniya. ");
INSERT INTO tsg_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“In maksud sin pagkari ku pa dunya dumā sin biyaꞌ sapantun kāyu. Na, in kabayaan ku dumukut na in kāyu. ");
INSERT INTO tsg_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Awn kabinsanaan dakulaꞌ dumatung kākuꞌ iban landuꞌ tuud isab masigpit in pikilan ku ha salugay diꞌ mapuas in kabinsanaan yan! ");
INSERT INTO tsg_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Na in pangannal niyu in pagkari ku pa dunya nakarā kasannyangan ha manga mānusiyaꞌ? Na, walaꞌ. In pagkari ku nakarihil palsaggaan. ");
INSERT INTO tsg_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Sabab tagnaan dayn ha bihaun in manga tau magsaggaꞌ-siyaggai na pasal ku. Bang awn limangka-tau magtalianak, in tūngka-tau sumaggaꞌ ha duwangka-tau, hāti in duwangka-tau sumaggaꞌ ha tūngka-tau. ");
INSERT INTO tsg_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","In manga amaꞌ iban sin manga anak nila usug magsaggaꞌ-siyaggai. In manga inaꞌ magsaggaꞌ-siyaggai iban sin manga anak nila babai. In manga magtali-ugangan babai magsaggaꞌ-siyaggai.” ");
INSERT INTO tsg_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Laung pa isab hi Īsa ha manga tau mataud, “Bang niyu kakitaan in andum guwaꞌ dayn ha sadlupan, laung niyu, umulan. Na, naagad in bichara niyu. ");
INSERT INTO tsg_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Iban bang niyu kananaman in hangin dayn ha sātan, laung niyu masuꞌ na isab in hulaꞌ. Na, naagad in bichara niyu. ");
INSERT INTO tsg_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","In manga kamu yan magpabawꞌ-bawꞌ sadja! Maingat niyu pamandugahan in ngīꞌ-dayaw sin hulaꞌ dayn ha manga lupa sin kakitaan niyu ha lupaꞌ iban ha langit. Sagawaꞌ maytaꞌ niyu diꞌ kaingatan pamandugahan in manga pakaradjaan kīkitaꞌ niyu ha masa bihaun? ");
INSERT INTO tsg_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Na, silanga niyu in mangīꞌ dayn ha marayaw bat supaya kamu makahinang sin mabuntul. ");
INSERT INTO tsg_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bang sawpama awn tau manuntut kaniyu amu in dumā kaniyu maghukum pasal sin utang niyu, hinanga niyu tuud in mahinang niyu bat kamu makapagsulut ha diꞌ pa kamu makaabut pa paghukuman. Sabab bang kamu diꞌ makapagsulut, na marā na kamu pa manghuhukum. Ubus ampa kamu hitukbal pa pulis. Pagꞌubus ampa kamu hiluun sin pulis pa jīl. ");
INSERT INTO tsg_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na, ingat kamu, duun kamu tumuddas ha salugay diꞌ niyu kabayaran in katān utang iban sin murta kaniyu. Minsan hambuuk unud sīn, diꞌ dagdagan.” ");
INSERT INTO tsg_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na, ha waktu da isab yadtu awn manga tau duun in namaytaꞌ kan Īsa pasal sin manga tau Jalil piyapatay hi Pilatu ha saꞌbu nila nagsusumbayꞌ sin manga hayup pagkulbanan pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","In sambung hi Īsa kanila, “Na, pagga biyaꞌ hādtu in kamatay ha manga tau Jalil yadtu, ha pikil niyu bahaꞌ amu yadtu in tandaꞌ sin in sila landuꞌ tuud baldusa dayn ha kaibanan tau Jalil? ");
INSERT INTO tsg_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Tantu bukun! Na, ingat kamu bang kamu diꞌ magtawbat sin manga dusa niyu in kamu yan magmula da isab biyaꞌ kanila. ");
INSERT INTO tsg_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Na, biyaꞌ na isab pasal sin hangpuꞌ tagwalu tau miyatay kiyaraꞌganan sin bāy mataas pagjajagahan, nalubu didtu ha Siluwam. Bang kamu, in kamatay nila yadtu tandaꞌ sin baldusa tuud sila dayn ha kaibanan tau naghuhulaꞌ ha Awrusalam (Baytal Makdis)? ");
INSERT INTO tsg_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Tantu, bukun! Na, ingat kamu, bang niyu diꞌ pagtawbatan in manga dusa niyu, na magmula da isab kamu biyaꞌ kanila.” ");
INSERT INTO tsg_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Manjari niyasīhatan hi Īsa in manga tau. Diyalil niya kaagi in pagnasīhat niya. Laung niya, “Bakas awn hambuuk tau taga lupaꞌ tiyatanuman anggul. Sakali awn hambuuk kahuy tina timutubuꞌ duun ha lupaꞌ niya. Na miyadtu siya kimitaꞌ bang awn na bunga sin kahuy tina, sagawaꞌ wayruun kiyabaakan niya. ");
INSERT INTO tsg_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Hangkan laung niya ha nagtutungguꞌ sin tiyanum niya, ‘Kitaa ba, awn na tū tahun aku magkari maglāg bunga sin kahuy tina yan, sagawaꞌ sampay bihaun wayruun bunga kabaakan ku. Pilaa na in kahuy yan! Makakangīꞌ sadja yan sin lupaꞌ.’ ");
INSERT INTO tsg_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Sagawaꞌ in sambung sin nagtutungguꞌ sin tiyanum niya, ‘Tuwan, ayaw naa kaw magꞌūs-ꞌūs. Pasāri naa duun ha lawm hangka-tahun. Sungkalun ku naa in bulian niya ampa ku butangan tayꞌ sapiꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Na, bang magbunga in kahuy tina yan ha tahun balik, labi marayaw, sagawaꞌ bang diꞌ, na ampa mu hipapilaꞌ kākuꞌ.’” ");
INSERT INTO tsg_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Manjari hambuuk adlaw Sabtuꞌ, adlaw paghali-hali iban pagpudji pa Tuhan sin manga Yahudi, nagnasīhat hi Īsa duun ha langgal. ");
INSERT INTO tsg_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Sakali awn duun ha langgal hambuuk babai nasasakit, kiyalabhaan sin saytan. Awn na hangpuꞌ tagwalu tahun in lugay niya nasasakit. Nabuggul na in taykud niya iban diꞌ na tuud mapabuntul. ");
INSERT INTO tsg_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pagkitaꞌ kaniya hi Īsa, tiyawag siya ampa īyan, amu agi, “Indaꞌ, kaulian na in sakit mu. Puas na kaw.” ");
INSERT INTO tsg_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kiyaputan niya sin lima niya in babai. Na, saruun-duun miyuntul in baran sin babai sartaꞌ piyudji niya in Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Na, diyugalan kan Īsa in tau nagkakaput sin langgal sabab nagpauliꞌ siya ha tau nasasakit ha saꞌbu adlaw paghali-hali iban pagpudji pa Tuhan. Hangkan nagkabtangan siya ha manga tau, laung niya, “Unum adlaw in kiyasukuꞌ kātuꞌniyu maghinang. Hangkan bang kamu mabayaꞌ magpauliꞌ sin sakit niyu, kari kamu ha lawm sin unum adlaw yan, sagawaꞌ bukun ha adlaw Sabtuꞌ, amu in adlaw paghali-hali iban pagpudji pa Tuhan!” ");
INSERT INTO tsg_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","In sambung hi Panghuꞌ Īsa kaniya, “In kamu yan magpabawꞌ-bawꞌ sadja! Sabab wayruun sa yan minsan hambuuk dayn kaniyu in diꞌ humubad sin sapiꞌ niya atawa kuraꞌ niya dayn ha kural ampa niya dāhun gumuwaꞌ painumun tubig minsan da adlaw paghali-hali iban pagpudji pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Na, bihaun yari awn hambuuk panubuꞌ hi Ibrahim amu in giyugunggungan sin Saytan Puntukan ha lawm likusan niya awn na hangpuꞌ tagwalu tahun. Na, bukun ka patut puasan siya dayn ha yan ha adlaw paghali-hali iban pagpudji pa Tuhan?” ");
INSERT INTO tsg_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Na, pagbichara hi Īsa biyaꞌ hādtu, simipug tuud in manga tau simasaggaꞌ kaniya. Sagawaꞌ in kamatauran sin manga tau nagkūg-kuyag pasal sin katān muꞌjijat nahinang hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Na, tiyuy hi Īsa in pagnasīhat niya, laung niya, “Biyaꞌ diin in hantang sin pamarinta sin Tuhan? Biyaꞌ diin bahaꞌ in kapapata ku kaniyu? ");
INSERT INTO tsg_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Na, in pamarinta sin Tuhan biyaꞌ hantang sin kahālan sin pagtanum sin hambuuk tau sin bigi sibiꞌ-sibiꞌ tuud ha lupaꞌ niya. Na, timubuꞌ in bigi iban nanjari kahuy dakulaꞌ iban duun ha manga sanga niya naghinang pugad in manga manuk-manuk.” ");
INSERT INTO tsg_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Laung pa isab hi Īsa, “Biyaꞌ diin bahaꞌ in kapapata ku kaniyu sin pamarinta sin Tuhan? ");
INSERT INTO tsg_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Na, biyaꞌ ha ini in hantang niya. Biyaꞌ yan sapantun sin pasulig amu in hilamud sin babai pa tūngka-kāgaꞌ tirigu, ampa muskag in addun.” ");
INSERT INTO tsg_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Na, liyanjal na hi Īsa in panaw niya tudju pa Awrusalam (Baytal Makdis). Ha sakabaꞌ awn manga dāira iban kawman kalabayan humapit siya magnasīhat ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Sakali awn hambuuk tau nangasubu kan Īsa, laung niya, “Tuwan, hangkatiyuꞌ da ka in tau malappas, amu in makapasurgaꞌ?” ");
INSERT INTO tsg_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","In sambung hi Īsa kanila, “Bang kamu mabayaꞌ sumūd pa lawman sin Tuhan, pagtuyuꞌ tuud kamu lumabay dayn ha lawang makiput, sabab tantu mataud tau in sumulay sumūd, sagawaꞌ diꞌ sila makarapat sumūd. ");
INSERT INTO tsg_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Karnaꞌ bang in tagdapu sin bāy tumindug na tumambul sin lawang sin bāy, in kamu duun na tumindug ha guwaꞌ kumuꞌkuꞌ sin lawang. Laung niyu, ‘Tuwan, ukabi kami lawang!’ “In sambung niya kaniyu, ‘Diꞌ ta kamu kaingatan bang tau dayn diin kamu!’ ");
INSERT INTO tsg_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Na, sumambung kamu, laung niyu, ‘Bakas kami nagsāw nagkaun iban ikaw iban nagnasīhat kaw didtu ha kawman namuꞌ!’ ");
INSERT INTO tsg_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Sagawaꞌ in sambung niya kaniyu, ‘Diꞌ ku kaingatan bang tau dayn diin kamu. Īg kamu katān dayn kākuꞌ. In manga kamu yan naghihinang sin manga hinang mangīꞌ tuud!’ ");
INSERT INTO tsg_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Na, magtangis tuud kamu iban manatat in takuꞌ niyu pagkitaꞌ niyu kanda Ibrahim, Isahak, Yaꞌkub iban sin manga katān kanabihan ha lawm pamarintahan sin Tuhan, sagawaꞌ in kamu minsan mabayaꞌ sumūd hilaruk da pa guwaꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Malayngkan magtipun in manga tau dayn ha katilingkal dunya, dayn ha subangan, sadlupan, iban uttaraꞌ, sātan, mawn na sumāw sin pagjamu ha lawm pamarintahan sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Na, in manga tau amu in ha ulihan bihaun, in kaibanan dayn kanila ha adlaw mahuli amu in makapaunahan, ampa in manga tau ha unahan bihaun, awn dayn kanila ha adlaw mahuli amu in makapaulihan.” ");
INSERT INTO tsg_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Manjari ha saꞌbu hi Īsa duun nagnanasīhat miyawn in manga Parisi kan Īsa namaytaꞌ, laung nila, “Subay kaw mīg dayn dī, pakain-pakain na kaw, sabab kabayaan kaw hipabunuꞌ hi Hirud.” ");
INSERT INTO tsg_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","In sambung hi Īsa kanila, “Kadtu kamu baytai niyu in tau panipu yan sin hilanjal ku in hinang ku magpaguwaꞌ ha manga saytan dayn ha lawm baran sin manga tau iban magpauliꞌ sin sakit sin manga tau ha adlaw ini sampay pa kinsum. Subay ha hikatū sin adlaw ampa maubus in hinang ku. ");
INSERT INTO tsg_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kaingatan ku diꞌ aku maunu dī ha ini sabab in kamatauran sin manga nabi piyatay sin manga tau didtu ha Awrusalam (Baytal Makdis), hangkan subay ku hilanjal in panaw ku ini pa Awrusalam (Baytal Makdis) adlaw ini iban sampay pa kuꞌnisa.” ");
INSERT INTO tsg_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Na, nasusa hi Īsa pasal sin hinang sin manga tau Awrusalam (Baytal Makdis). Laung niya, “Anduꞌ kailu in kamu manga tau Awrusalam (Baytal Makdis). Masi-masi in pagpamunuꞌ niyu ha manga kanabihan iban pagpamatu niyu ha manga tau daraakun sin Tuhan magpasampay sin Parman niya mawn kaniyu! Nakapila ku na piyakitaꞌ kaniyu in bayaꞌ ku magꞌayad kaniyu. Amu in pagꞌiyanun biyaꞌ aku sapantun hambuuk inaꞌ manuk magtipun sin manga anak niya ha sawm pikpik niya bat sila diꞌ magmula. Sagawaꞌ diꞌ kamu mabayaꞌ ayaran ku! ");
INSERT INTO tsg_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Na, ingat kamu, bihaun pasāran na sin Tuhan in Bāy niyu dakulaꞌ pagtataatan. Iban in aku bukun na malugay diꞌ niyu na kakitaan, lāgiꞌ diꞌ aku magbalik sampay diꞌ maabut in waktu in kamu makaiyan na, laung niyu, ‘Saginahun natuꞌ in kiyawakilan sin Tuhan.’” ");
INSERT INTO tsg_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Manjari hambuuk waktu, adlaw paghali-hali iban pagpudji pa Tuhan, miyagad hi Īsa madtu kimaun pa bāy sin hambuuk tau dakulaꞌ, nakuraꞌ sin manga Parisi. Jiyagahan tuud sin manga tau duun in kignut-kuhibal hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Sakali awn hambuuk tau namumuntuꞌ in manga biꞌtis iban buktun niya in diyā mawn kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Na, iyasubu hi Īsa in manga guru sin saraꞌ agama iban sin manga Parisi, laung niya, “Makajari ka ha saraꞌ sin agama natuꞌ magpauliꞌ ha nasasakit ha adlaw paghali-hali iban pagpudji pa Tuhan atawa diꞌ?” ");
INSERT INTO tsg_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Na, walaꞌ tuud sila nakapamung minsan hangka-kabtang. Na, kiyawaꞌ hi Īsa in tau nasasakit ampa niya piyauliꞌ, ubus ampa piyauwiꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pagꞌubus ampa hi Īsa namung kanila, laung niya, “Bang sawpama awn dī kaniyu in taga anak atawa sapiꞌ in nahulug pa lawm tubig kuppung dakulaꞌ ha saꞌbu adlaw paghali-hali iban pagpudji pa Tuhan, diꞌ niyu ka magtūy utungun saruun-duun dayn ha lawm kuppung, minsan da adlaw paghali-hali iban pagpudji pa Tuhan?” ");
INSERT INTO tsg_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Na, walaꞌ tuud sila nakasambung sin pasal yan. ");
INSERT INTO tsg_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Sakali kītaꞌ hi Īsa sin in manga kaibanan luruk nagpīꞌ sin lingkuran marayaw. Hangkan nagnasīhat hi Īsa diyalil niya kaagi. Laung hi Īsa kanila katān, ");
INSERT INTO tsg_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Bang kaw kawaun mangluruk pa pagtiyaunan, ayaw kaw lumingkud ha manga lingkuran marayaw. Sabab adakalaꞌ tiyatawꞌ in lingkuran ha tau naimbayt balkanan dayn kaymu. ");
INSERT INTO tsg_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Na, pagdatung sin tau balkanan, kawnun kaw sin tau nagꞌimbayt kaniyu ampa kaw iyanun, laung niya, ‘Siya in palingkura ha lingkuran yan.’ Na, mabias na kaw. Saꞌ na kaw lumingkud ha lingkuran bukun marayaw. ");
INSERT INTO tsg_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Hangkan bang kaw kawaun mangluruk, pagdatung mu madtu lingkud kaw ha lingkuran bukun marayaw, ha supaya pagkitaꞌ sin tau nagꞌimbayt kaymu, kawnun kaw iyanun, amu agi, ‘Kari kaw bagay lumingkud pa lingkuran marayaw.’ Na, in yan hambuuk kalagguan kaymu ha pangitaꞌ sin manga katān luruk. ");
INSERT INTO tsg_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Karnaꞌ hisiyu-siyu in tau magpataas sin baran niya hidusdus pa babaꞌ iban hisiyu-siyu in magpababaꞌ sin baran niya angkatun da siya pa taas.” ");
INSERT INTO tsg_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pagꞌubus ampa isab īyan hi Īsa in tau nagpajamu, laung niya, “Bang kaw magpajamu, ayaw kaw magpaluruk ha manga bagay mu atawa taymanghud mu, atawa kampung mu atawa manga pangdaig bāy mu dayahan. Sabab in manga tau yan sumubli da isab kumawaꞌ mangluruk kaymu. Na, in hāti niya makabalik da kaymu in kiyapagdihil mu. ");
INSERT INTO tsg_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sagawaꞌ bang kaw magpajamu, kawaa mangluruk in manga miskin, in manga tau taga garnaꞌ in baran iban manga pingkaꞌ iban sin manga buta. ");
INSERT INTO tsg_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Sabab makabaak kaw karayawan bang amu in manga tau yan in kawaun mu mangluruk, sabab in manga tau yan diꞌ makatungbas kaymu. Tuhan in tumungbas kaymu ha adlaw mahuli bang maabut na in waktu mabuhiꞌ na magbalik in manga tau ādil.” ");
INSERT INTO tsg_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Pagdungug sin hambuuk luruk sin bichara hi Īsa, imiyan siya kan Īsa, laung niya, “Diꞌ hikasipat in kakuyagan sin manga tau luruk ha pagjamuhan sin Tuhan didtu ha pagparintahan sin Tuhan!” ");
INSERT INTO tsg_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","In sambung hi Īsa kaniya, “Bakas awn tau nagsaddiya sin pagpajamu dakulaꞌ iban mataud tau in piyakawaꞌ niya mangluruk. ");
INSERT INTO tsg_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Sakali naabut mayan in waktu sin pagpajamu, diyaak niya in daraakun niya madtu pa manga luruk mamaytaꞌ kanila, amu agi, ‘Pakadtuun na kamu, saddiya na in pagjamu.’ ");
INSERT INTO tsg_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Sagawaꞌ nagdaawa pakaniya-pakaniya in manga tau katān amu in piyakawaꞌ mangluruk. Laung sin hambuuk tau ha daraakun, ‘Awn lupaꞌ baꞌgu ku binī. Subay ku kadtuun lilingun. Anduꞌ maapa mayan aku.’ ");
INSERT INTO tsg_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Laung isab sin hangka-tau, ‘Awn hangpuꞌ sapiꞌ baꞌgu binī ku hipaglagi ku bang magꞌararu. Sūng ku sa ini madtu kumitaꞌ bang biyaꞌ diin in kusug sin manga sapiꞌ. Anduꞌ, maapa dakuman aku.’ ");
INSERT INTO tsg_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Laung isab sin hambuuk, ‘Baꞌgu da aku tīyaun, hangkan diꞌ aku makaluruk madtu.’ ");
INSERT INTO tsg_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Na, minuwiꞌ na in daraakun ampa namaytaꞌ ha nakuraꞌ niya. Na, diyugalan tuud in nakuraꞌ. Laung niya ha daraakun, ‘Kadtu kaw magꞌūs-ꞌūs pa dāira ampa lataga in katān karān-dānan iban labayan. Paluruka mari in manga miskin, in manga tau taga garnaꞌ in baran, in manga buta iban sin manga pingkaꞌ.’ ");
INSERT INTO tsg_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Dayꞌ-dayꞌ pakarayaw, nakabalik na in daraakun, laung niya, ‘Tuwan, nahinang ku na in diyaakan mu kākuꞌ, sagawaꞌ kulang pa in manga tau luruk. Awn pa katuputan.’ ");
INSERT INTO tsg_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Hangkan, laung sin nakuraꞌ ha daraakun niya, ‘Kadtu kaw pa kagimbahan. Lataga in katān karān-dānan iban labayan ampa mu paluruka mari in manga tau bat mahipuꞌ in bāy ku. ");
INSERT INTO tsg_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Na, ingat kamu, in manga tau katān amu in piyakawaꞌ ku nakauna mangluruk, diꞌ tuud makahampit sin pagjamu ku ini!’” ");
INSERT INTO tsg_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Manjari hambuuk waktu nagpapanaw hi Īsa, mabanus tau in miyamagad kaniya. Sakali himarap siya ha manga tau ampa siya namung, laung niya, ");
INSERT INTO tsg_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Hisiyu-siyu in mabayaꞌ magad kākuꞌ, subay in lasa niya kākuꞌ malabi dayn sin lasa niya ha inaꞌ-amaꞌ niya, ha anak-asawa niya, ha manga taymanghud niya usug-babai iban ha baran niya sabab bang bukun, diꞌ siya mahinang mulid ku. ");
INSERT INTO tsg_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Hisiyu-siyu in diꞌ mangaku sin katān haggut-pasuꞌ, minsan siya mapatay ha pasal ku iban diꞌ magad mari kākuꞌ, na diꞌ siya mahinang mulid ku. ");
INSERT INTO tsg_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Bang awn hambuuk kaniyu in magpikil magpahinang bāy dakulaꞌ hinangun pamamantawan, in siya yan tantu lumingkud naa muna magbista bang pila in hikagastu niya, ha supaya niya kaingatan bang makagastuhan in sīn niya hipagpahinang sin bāy. ");
INSERT INTO tsg_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Sabab bang niya diꞌ bistahun naa muna, na gana-gana ubus niya magpatindug sin manga hāg sin bāy, kakulangan siya sīn, na diꞌ matalus in bāy niya. Na, pagkatawahan siya sin manga tau katān makakitaꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Laung sin manga tau, ‘In tau ini nagpatindug bāy, sagawaꞌ diꞌ niya matalus.’ ");
INSERT INTO tsg_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Damikkiyan, bang in hambuuk sultan taga tindug hangpuꞌ ngaibu sūng magbunuꞌ iban sin sultan taga tindug kawhaan ngaibu, tantu lumingkud naa siya muna mamikilan bang siya makaatu atawa diꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Bang ha pikilan niya diꞌ siya makaatu, na, magtūy niya pakadtuun in manga tindug niya pa sultan kuntara niya mamaytaꞌ sin mabayaꞌ siya dumā magsulut, bābā malawak pa in hambuuk sultan.” ");
INSERT INTO tsg_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Na, mahuli dayn duun, laung hi Īsa, “Damikkiyan, in kamu, diꞌ kamu makaagad magguru kākuꞌ, mahinang manga mulid ku, bang niyu diꞌ taykuran in manga unu-unu niyu katān.” ");
INSERT INTO tsg_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Laung pa isab hi Īsa, “In asin marayaw, sagawaꞌ bang maīg na in kaasin niya, na way na dapat paasinun magbalik. ");
INSERT INTO tsg_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Wayruun na yan kapūsan niya. Diꞌ yan minsan hikapagguna hipagparayaw sin lupaꞌ bat humambug in manga tiyanum. Hibugit yan sin manga tau. Na, sasukuꞌ sin kamu nakarungug, dunguga iban tumtuma niyu tuud in biyaytaꞌ ku yan kaniyu!” ");
INSERT INTO tsg_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Manjari hambuuk adlaw, mataud mayan manga mangangawaꞌ sukay pa parinta iban manga tau amu in walaꞌ miyamagad sin daakan sin saraꞌ agama in miyawn dimungug sin nasīhat hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Iyamahan in manga Parisi iban sin manga guru sin saraꞌ agama. Laung nila, “Diꞌ manjari in tau ini. Parulihun niya minsan in manga tau, amu in walaꞌ miyamagad sin daakan sin saraꞌ agama, iban dāhun niya magsāw magkaun!” ");
INSERT INTO tsg_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Na, hangkan diyalil kaagi hi Īsa in bichara niya pasal sin bili-bili nalawaꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Laung hi Īsa, “Bang sawpama awn hambuuk dī kaniyu in taga hanggatus bili-bili. Sakali nalawaꞌ in hambuuk, unu bahaꞌ in hinangun niya? Tantu hibīn niya in kasiyaman-tagsiyam bili-bili niya duun ha lupu, ampa siya madtu maglawag sin bili-bili nalawaꞌ sampay niya kabaakan. ");
INSERT INTO tsg_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bang niya kabaakan na, kūgan tuud siya. Paꞌsanun niya in bili-bili, ");
INSERT INTO tsg_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ampa dāhun muwiꞌ. Pagdatung niya pa bāy tawagun niya in manga bagay niya iban sin manga pangdaig bāy niya, laung niya, ‘Kari kamu katān. Makuyag tuud aku sabab kiyabaakan ku na in bili-bili ku bakas nalawaꞌ. Hangkan maglami-lami kitaniyu!’ ");
INSERT INTO tsg_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Damikkiyan, in hambuuk baldusa biyaꞌ da isab hantang sin bili-bili nalawaꞌ. Bang in hambuuk baldusa magtawbat na sin dusa niya, magkūg-kuyag tuud in katān ha lawm surgaꞌ. In kakuyagan nila pasal sin tau yan, malabi tuud dayn sin kakuyagan pasal sin kasiyaman-tagsiyam tau mabuntul kunuꞌ, amu in way kunuꞌ pagtawbatan nila.” ");
INSERT INTO tsg_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Laung pa isab hi Īsa, “Atawa sawpama awn hambuuk babai taga dublun hangpuꞌ in taud niya. Sakali nalawaꞌ in hambuuk. Na, unu bahaꞌ in hinangun niya? Tantu sūan niya in palitaan ampa niya sapuhan in lawm bāy. Lawagun niya tuud marayaw sampay niya kabaakan. ");
INSERT INTO tsg_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na, bang niya kabaakan na, tawagun niya in manga bagay niya iban manga pangdaig bāy niya, laung niya kanila, ‘Kari kamu katān. Makuyag tuud aku sabab kiyabaakan ku na in dublun ku bakas nalawaꞌ. Hangkan maglami-lami kitaniyu!’ ");
INSERT INTO tsg_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Na, damikkiyan, in hambuuk baldusa biyaꞌ da isab hantang sin dublun nalawaꞌ. In manga malāikat sin Tuhan magkūg-kuyag tuud pasal sin hambuuk baldusa nagtawbat sin manga dusa niya.” ");
INSERT INTO tsg_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Laung pa isab hi Īsa, “Awn bakas hambuuk tau taga anak duwa usug. ");
INSERT INTO tsg_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Laung sin anak manghud ha amaꞌ niya, ‘Amaꞌ dihilan na kākuꞌ in sukuꞌ ku sin altaꞌ hipusakaꞌ mu kāmuꞌ.’ Na, biyahagiꞌ na sin tau ini in altaꞌ pusakaꞌ niya ha duwa anak niya usug. ");
INSERT INTO tsg_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Liyabayan pilay adlaw piyagdagang sin anak manghud in altaꞌ pusakaꞌ kaniya. Ampa siya minīg dayn ha bāy nila iban sin pilak bīhan sin altaꞌ niya, miyadtu siya pa hulaꞌ malayuꞌ nagbulaug iban nagꞌusibaꞌ sin sīn niya. ");
INSERT INTO tsg_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Naubus in katān sīn niya. Sakali naggutum ha katilibut sin hulaꞌ yaun. Nakalanduꞌ in paggutum. Kiyasigpitan tuud siya sabab naubus na in unu-unu niya katān. ");
INSERT INTO tsg_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Na, hangkan miyadtu siya naghinang ha hambuuk tau amu in luggiyaꞌ naghuhulaꞌ ha hulaꞌ yaun. Dīhilan siya hinang magꞌipat sin manga babuy didtu ha uma. ");
INSERT INTO tsg_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Na, hiyapdiꞌ na tuud siya, hangkan minsan in manga kakaun sin babuy mabayaꞌ niya na kaunun. Sagawaꞌ wayruun tuud minsan hangka-tau in nakarihil kaniya kakaun. ");
INSERT INTO tsg_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Mahuli dayn duun napikil niya in kasāan nahinang niya. Laung niya ha lawm atay niya, ‘In manga katān giyagadjihan hi amaꞌ labi-labihan in pagkaun nila, hāti in aku ini, marayꞌ na mautas sin hapdiꞌ! ");
INSERT INTO tsg_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Marayaw pa aku magbalik na madtu pa amaꞌ ku, ampa ku siya iyanun, laung ku, “Amaꞌ”, nakarusa aku pa Tuhan iban kaymu. ");
INSERT INTO tsg_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Diꞌ na aku tūpun tawagun anak mu. Niyata na sadja aku hambuuk tau giyagadjihan mu.’” ");
INSERT INTO tsg_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Pagꞌubus niya namikil, magtūy siya timindug ampa siya minuwiꞌ na nagbalik pa amaꞌ niya. “Sakali malayuꞌ pa siya dayn ha bāy nila, kītaꞌ na siya sin amaꞌ niya. Limuuy tuud in amaꞌ niya kaniya. Na, magtūy dimagan in amaꞌ niya madtu kaniya, ampa siya giyulgul sīyum. ");
INSERT INTO tsg_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Laung niya ha amaꞌ niya, ‘Amaꞌ, nakarusa aku pa Tuhan iban kaymu. Diꞌ na aku tūpun tawagun anak mu.’ ");
INSERT INTO tsg_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Sagawaꞌ tiyawag sin amaꞌ in manga daraakun niya. Laung niya kanila, ‘Samut kamu! Dāha niyu mari in badjuꞌ marayaw tuud, ampa niyu suꞌlugan kaniya. Suꞌlugi niyu singsing in lima niya iban suꞌlugi niyu tawmpaꞌ in siki niya. ");
INSERT INTO tsg_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pagꞌubus kawaa niyu madtu in anak sapiꞌ piyahahambug natuꞌ ampa niyu sumbayꞌa. Maglami-lami kitaniyu iban magpajamu! ");
INSERT INTO tsg_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Karnaꞌ in anak ku amu in nīyat ku patay na, yari bihaun buhiꞌ. Bakas siya nalawaꞌ dayn kākuꞌ, sagawaꞌ bihaun nagbalik na siya minuwiꞌ mari kākuꞌ.’ Na, naglami-lami na sila iban nagpajamu. ");
INSERT INTO tsg_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Manjari in anak magulang saꞌbu didtu ha uma. Pagꞌuwiꞌ niya dayn ha uma, masuuk mayan siya pa bāy, diyungug niya in pagkalang iban pagbayla. ");
INSERT INTO tsg_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Hangkan tiyawag niya in hambuuk daraakun ampa niya iyasubu. Laung niya, ‘Unu taꞌ in piyaglami-lamihan ha bāy yaun?’ ");
INSERT INTO tsg_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Laung sin daraakun, ‘In taymanghud mu nakabalik na mari. Hangkan nagpasumbayꞌ sapiꞌ piyahahambug natuꞌ in amaꞌ mu sabab nakabalik in taymanghud mu ha wayruun unu-unu mangīꞌ kimugdan kaniya.’ ");
INSERT INTO tsg_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Na, diyugalan tuud in anak magulang, iban diꞌ siya mabayaꞌ gumaban pa taas bāy. Hangkan kiyadtu siya iyūū sin amaꞌ niya pasakatun pa bāy. ");
INSERT INTO tsg_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Sagawaꞌ laung niya ha amaꞌ niya, ‘Kitaa ba, bukun na pila tahun aku naghinang kaymu biyaꞌ hambuuk īpun iban way minsan hambuuk daakan mu in walaꞌ ku naagad. Na, unu in tungbas kiyarihil mu kākuꞌ? Minsan hambuuk kambing walaꞌ mu aku kiyarihilan pagjamuhan ku iban sin manga bagay ku! ");
INSERT INTO tsg_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Sagawaꞌ in anak mu yan, amu in nangusibaꞌ sin katān altaꞌ mu, piyagdihil ha manga babai mangīꞌ, yan mu piyasumbayꞌan sapiꞌ piyahahambug natuꞌ pagbalik niya mari!’ ");
INSERT INTO tsg_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“In sambung sin amaꞌ, ‘Utuꞌ, in ikaw tutug dī kākuꞌ iban in katān altaꞌ ku kaymu. ");
INSERT INTO tsg_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Sagawaꞌ diꞌ manjari bang diꞌ maglami-lami iban magpajamu sabab in taymanghud mu amu in bakas ku nīyat patay na, yari bihaun nagbalik kātuꞌ. Bakas siya nalawaꞌ, sagawaꞌ bihaun yari na nakauwiꞌ nagbalik.’” ");
INSERT INTO tsg_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Manjari laung hi Īsa ha manga mulid niya, “Bakas awn hambuuk tau dayahan taga daraakun amu in piyangandulan niya magparuli sin manga altaꞌ niya. Sakali kiyasumbungan in tau dayahan ini sin in altaꞌ iyusibaan sin daraakun piyangandulan niya. ");
INSERT INTO tsg_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hangkan piyatawag niya in daraakun niya ini. Laung niya ha daraakun niya, ‘Bunnal ka in manga sumbung diyungug ku pasal mu? Listahan in katān altaꞌ ku kiyaputan mu iban baytai aku bang biyaꞌ diin in pagkaput mu, sabab diꞌ ta na kaw pangandulan sin altaꞌ ku.’ ");
INSERT INTO tsg_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Na, namikil-mikil in daraakun ini. Laung niya ha lawm atay niya, ‘Paīgun na aku sin nakuraꞌ ku dayn ha hinang ku. Magꞌunu na bahaꞌ aku ini? Diꞌ aku makapaghinang magkaliꞌ lupaꞌ sabab bukun makusug in baran ku iban masipug aku manglimus ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A, kaingatan ku na bang unu in hinangun ku, ha supaya aku bagayun sin manga tau pahulaun ha bāy nila, bang way na hinang ku.’ ");
INSERT INTO tsg_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Hangkan piyatawag niya in manga tau katān nakautang ha nakuraꞌ niya. Iyasubu niya in hangka-tau laung niya, ‘Pila in utang mu ha nakuraꞌ ku?’ ");
INSERT INTO tsg_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“‘Hanggatus mital lana jaytun,’ in agi sin tau nakautang. “‘Yari in listahan sin utang mu,’ laung sin daraakun sin tau dayahan. ‘Lingkud kaw ampa mu pindahi pa kayꞌman mital sadja in utang mu.’ ");
INSERT INTO tsg_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Pagꞌubus iyasubu niya na isab in hambuuk. ‘Na, in ikaw pila isab in utang mu ha nakuraꞌ ku?’ “‘Hangibu karut pāy,’ in sambung kaniya. ‘Yari in listahan sin utang mu,’ laung sin daraakun sin tau dayahan. ‘Pindahi pa walunggatus sadja in nautang mu.’ ");
INSERT INTO tsg_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Na, nainu-inu tuud in nakuraꞌ sin kapandayan sin daraakun niya nangakkal kaniya. Mattan tuud in manga tau miyamagad ha ligut sin dunya mapanday tuud mamikil sin hikarayaw pa baran nila. Mapanday dayn ha manga tau sukuꞌ sin Tuhan miyamagad sin daakan niya. ");
INSERT INTO tsg_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Hangkan baytaan ta kamu. Kadtui niya na! Pangakkal na kamu ha supaya kamu makabāk bagay! Ha pikil niyu, bang kamu kasigpitan na, awn kawasa nila magpasūd kaniyu pa lawm surgaꞌ amu in paghulaan kasaumulan? Tantu way tuud. ");
INSERT INTO tsg_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Karnaꞌ hisiyu-siyu in kapangandulan sin parakalaꞌ sibiꞌ-sibiꞌ, na kapangandulan da isab sin parakalaꞌ dakulaꞌ. Damikkiyan, hisiyu-siyu in diꞌ kapangandulan sin parakalaꞌ sibiꞌ-sibiꞌ, diꞌ da isab kapangandulan sin parakalaꞌ dakulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Na, bang kamu diꞌ kapangandulan magkaput sin manga altaꞌ dunya, na, amu pa ka isab kamu kapangandulan bang altaꞌ kakkal na, amu in mahargaꞌ ha Tuhan? ");
INSERT INTO tsg_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Iban bang kamu diꞌ kapangandulan sin altaꞌ sin tau dugaing, tantu diꞌ hikarihil kaniyu in altaꞌ kiyasukuꞌ kaniyu. ");
INSERT INTO tsg_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Wayruun tau in makapagtagꞌīpun ha duwa nakuraꞌ, sabab bang duwa in nakuraꞌ sin tau, tantu kalasahan niya in hangka-tau, hāti karugalan niya in hambuuk. In hambuuk nakuraꞌ yan kahagarun niya tuud, sagawaꞌ in hambuuk diꞌ niya asipun. Na, biyaꞌ da isab hādtu, bang altaꞌ in malabi tuud ha lawm atay niyu, na diꞌ niyu maagad in kabayaan sin Tuhan hipahinang kaniyu.” ");
INSERT INTO tsg_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Na, pagdungug sin manga Parisi sin bichara hi Īsa, iyudjuꞌ-udjuꞌ nila piyagkatawahan hi Īsa, sabab in sila landuꞌ in hawa-napsu nila magꞌaltaꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Laung hi Īsa kanila, “In kamu yan magpakitaꞌ-kitaꞌ sadja ha manga tau sin mabuntul kamu, sagawaꞌ ha pangitaꞌ sin Tuhan bingkuk in lawm atay niyu. Karnaꞌ in manga unu-unu hiyahargaan tuud sin tau way hargaꞌ ha pangatud sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“In tagnaꞌ ha walaꞌ pa nakapagnasīhat hi Yahiya Mangliliguꞌ, in wajib taniyu agarun, amu in saraꞌ agama naug dayn kan Musa iban sin manga hinduꞌ sin manga kanabihan ha lawm Kitab. Sagawaꞌ piyamahalayak mayan hi Yahiya in Baytaꞌ Marayaw pasal sin pamarinta sin Tuhan, in kamatauran sin manga tau nagtuyuꞌ tuud umingat pasal yan ha supaya awn sukuꞌ nila ha lawm pamarinta sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Sagawaꞌ minsan biyaꞌ ha yan bukun in hāti niya bat wayruun na kusug sin saraꞌ agama naug dayn kan Musa. Sabab in yan diꞌ tuud mapinda. Maluhay pa malanyap in langit iban dunya dayn sin maīg in hambuuk baris sin batang sulat ha lawm Kitab. ");
INSERT INTO tsg_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Hisiyu-siyu in tau mamugit ha asawa niya ampa siya magꞌasawa dugaing babai, in hāti niya nakalanggal siya sin saraꞌ magjina iban hisiyu-siyu in tau magꞌasawa sin babai nagbugit iban bana niya, in hāti niya nakalanggal siya sin saraꞌ magjina.” ");
INSERT INTO tsg_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Laung pa isab hi Īsa, “Bakas awn hambuuk tau dayahan. In pamakay niya katān mahargaꞌ sadja iban masarap sadja in pagkaun niya adlaw-adlaw. Masannyang iban marayaw in parasahan niya. ");
INSERT INTO tsg_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Sakali awn isab hambuuk tau miskin pagngānan hi Lasarus. Nahihipuꞌ sin dugsul in baran niya. Daran siya pagdāhun pa lawang bāy sin tau dayahan, ");
INSERT INTO tsg_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ha supaya siya makakaun bang awn mahulug kapin dayn ha lamisahan sin tau dayahan. Makaluuy tuud in parasahan sin tau miskin ini karnaꞌ minsan in manga iruꞌ mawn na dumilat sin manga dugsul niya. ");
INSERT INTO tsg_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Na, sakali miyatay mayan siya kiyawaꞌ siya sin manga malāikat ampa siya diyā madtu pa kiyabutangan hi Ibrahim didtu ha surgaꞌ. Manjari miyatay da isab in tau dayahan iban kiyubul na siya. ");
INSERT INTO tsg_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Na, didtu mayan siya ha kiyabubutangan sin manga patay nimanam tuud siya kabinsanaan. Paghangad niya kītaꞌ niya hi Ibrahim didtu ha kalayuan nagdaraig iban hi Lasarus. ");
INSERT INTO tsg_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Na, gimasud siya, laung niya, ‘Uhaꞌ, Apuꞌ Tuwan Ibrahim, kaluuyi aku. Daaka hi Lasarus patublakan in gulamay lima niya pa lawm tubig, ampa papatūan pa lawm simud ku, sabab in aku ini landuꞌ tuud nabibinsanaꞌ dī ha lawm kāyu ini!’ ");
INSERT INTO tsg_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Sagawaꞌ in sambung hi Ibrahim, ‘Utuꞌ, tumtuma sin ha waktu buhiꞌ pa kaw didtu ha dunya marayaw sadja in kiyasukuꞌ kaymu, ampa in hi Lasarus mangīꞌ tuud in kiyasukuꞌ kaniya. Sagawaꞌ bihaun siya in marayaw parasahan, ampa in ikaw ha lawm kabinsanaan. ");
INSERT INTO tsg_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Iban bukun sadja isab pasal yan. Awn lungag tigub-tiguban ha ūt sin kiyabutangan mu iban sin kiyabutangan namuꞌ. Hangkan minsan hisiyu in dayn dī mabayaꞌ umuntas matun diꞌ makarapat. Damikkiyan, wayruun isab dayn duun in makauntas mari.’ ");
INSERT INTO tsg_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Na, laung sin tau dayahan, ‘Na, pagga biyaꞌ hādtu pangayuun ku junjung kaymu, Apuꞌ Tuwan Ibrahim, pakadtua hi Lasarus pa bāy sin amaꞌ ku, ");
INSERT INTO tsg_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","amu in kiyabubutangan sin lima usug taymanghud ku. Pakadtua siya magbāndaꞌ kanila ha supaya sila diꞌ makakari numanam kabinsanaan bang sila mapatay.’ ");
INSERT INTO tsg_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“In sambung hi Ibrahim, ‘Utuꞌ, yan kanila in manga saraꞌ agama naug dayn kan Musa iban sin manga Kitab kiyasulat sin manga kanabihan amu in makabandaꞌ ha manga taymanghud mu. Subay in manga yan kahagarun sin manga taymanghud mu.’ ");
INSERT INTO tsg_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“In sambung sin tau dayahan, ‘Apuꞌ Tuwan Ibrahim, subay labi pa dayn duun in pagbandaꞌ kanila. Bang awn sadja hambuuk tau miyatay in mabuhiꞌ magbalik in madtu mamaytaꞌ kanila tantu pagtawbatan nila na in manga dusa nila!’ ");
INSERT INTO tsg_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“‘Sagawaꞌ,’ laung hi Ibrahim, ‘Bang sila diꞌ magkahagad sin saraꞌ agama naug dayn kan Musa iban sin manga baytaꞌ ha lawm Kitab kiyasulat sin manga kanabihan, tantu diꞌ da sila magkahagad minsan awn tau patay mabuhiꞌ magbalik mamaytaꞌ kanila.’” ");
INSERT INTO tsg_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Laung hi Īsa ha manga mulid niya, “Asal in tau dī ha dunya makalabay sadja sasat amu in makarā kanila magdusa, sagawaꞌ anduꞌ kailu tuud in tau amu in makarā ha kaibanan niya magdusa, (sabab siksaun siya sin Tuhan)! ");
INSERT INTO tsg_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Marayaw pa siya hihulug pa giꞌtung tawid iban sin gilingan batu dakulaꞌ hiyuhukut ha liug niya bat niya diꞌ marā magdusa in manga tau mababaꞌ in atay amu in biyaꞌ sapantun bataꞌ-bataꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Hangkan kamayaꞌ kamu sin hinang niyu! “Bang sawpama in pagkahi mu makarusa kaymu, hindui siya. Na, bang siya magsusun na sin narusa niya, maapa na siya. ");
INSERT INTO tsg_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bang in pagkahi mu makarusa kaymu makapitu ha lawm hangka-adlaw, ampa ha sakabaꞌ niya makarusa mawn siya kaymu magpamaap, na subay mu siya maapun.” ");
INSERT INTO tsg_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Laung sin manga kiyawakilan kan Panghuꞌ Īsa, “Pakusuga in pangandul namuꞌ ha Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","In sambung sin Panghuꞌ, “Bang in pangandul niyu mabiyaꞌ sadja lagguꞌ sin bigi sibiꞌ-sibiꞌ, maiyan niyu in kahuy yaun, laung niyu, ‘Bang mayan kaw malarut dayn ha kiyabutangan mu ampa kaw tindug duun ha giꞌtung tawid!’ Na tantu maagad in kabayaan niyu.” ");
INSERT INTO tsg_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Bang sawpama awn daraakun niyu uwiꞌ dayn ha pagꞌararuhan atawa dayn ha pagꞌipatan manga bili-bili dayn ha gimba, iyanun niyu ka in daraakun niyu, ‘Ūs-ꞌūs na kaw ampa kaw kari kumaun’? ");
INSERT INTO tsg_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tantu diꞌ. Gām mayan laung niyu kaniya, ‘Adjala na in pagkaun ku. Pagꞌubus ampa pahuguta in panamung mu ampa mu aku butangi pagkaun. Subay na aku maubus kumaun ampa kaw isab kumaun.’ ");
INSERT INTO tsg_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Na, in daraakun yan minsan siya diꞌ na pagsukulan sin nakuraꞌ niya sabab asal amuna yan in hinang kiyatakdil kaniya. ");
INSERT INTO tsg_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Na, damikkiyan in kamu, bang niyu maubus na hinangun in manga katān diyaakan kaniyu, subay laung niyu ha lawm atay niyu, ‘In kami ini daraakun sadja (sin Tuhan). Subay kami diꞌ lagguun sabab hīnang namuꞌ sadja in kiyawajib hinangun namuꞌ.’” ");
INSERT INTO tsg_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Limanjal na hinda Īsa sin panaw nila pa Awrusalam (Baytal Makdis). Limabay sila dayn ha hulaꞌ daplinan amu in imuūt sin hulaꞌ Samariya iban Jalil. ");
INSERT INTO tsg_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ha sūng nila madtu pa hambuuk kawman piyagbaak sila sin hangpuꞌ tau īipul. Timitindug sila ha kalayuan ");
INSERT INTO tsg_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","sartaꞌ timawag sila, laung nila, “Uwaꞌ, Panghuꞌ Īsa, kaluuyi kami!” ");
INSERT INTO tsg_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Na, kītaꞌ sila hi Īsa. Sakali laung niya, “Kadtu na kamu pa manga kaimaman ampa niyu pakitaan in baran niyu sin kiyaulian na kamu.” Na, miyadtu na sila. Ha dān pa sila kiyaulian na sila. ");
INSERT INTO tsg_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pagkitaꞌ sin hangka-tau sin kiyaulian na siya, nagbalik siya madtu kan Īsa iban nagkabtangan siya matanug sin pamudji niya pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Pagdatung niya, magtūy siya simujud ha alupan hi Īsa ampa siya nagsarang-sukul. In tau ini dayn ha hulaꞌ Samariya. ");
INSERT INTO tsg_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Laung hi Īsa, “Bukun ka hangpuꞌka-tau in kiyaulian? Hawnu na bahaꞌ in siyamka-tau? ");
INSERT INTO tsg_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Maytaꞌ bahaꞌ amura in tau bangsa dugaing ini in nagbalik mari nagsarang-sukul ha Tuhan?” ");
INSERT INTO tsg_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Na, laung hi Īsa ha tau ini, “Tindug kaw, ampa kaw kadtu na. Kiyaulian kaw sabab sin pangandul mu ha Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Sakali awn kaibanan manga Parisi in nangasubu kan Īsa bang kuꞌnu dumatung in pamarinta sin Tuhan ha dunya. In sambung hi Īsa kanila, “Diꞌ niyu kakitaan in pagdatung sin pamarinta sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Iban wayruun umiyan amu agi, ‘Huy, kitaꞌ kamu, yari na in pamarinta sin Tuhan!’ atawa, ‘Yadtu didtu in pamarinta sin Tuhan!’ sabab in pamarinta sin Tuhan yan ha lawm atay sin tau.” ");
INSERT INTO tsg_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Pagꞌubus laung niya ha manga mulid niya, “Awn da waktu dumatung ha susūngun, mabayaꞌ tuud kamu kumitaꞌ kākuꞌ, amu in Anak Mānusiyaꞌ, minsan dakuman hangka-adlaw, sagawaꞌ diꞌ niyu aku kakitaan. ");
INSERT INTO tsg_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Awn manga kaibanan tau umiyan kaniyu, laung nila, ‘Huy, kitaꞌ kamu, yadtu siya didtu!’ atawa, ‘Huy, kitaꞌ kamu, yari siya dī!’ Sagawaꞌ ayaw kamu madtu kumitaꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sabab in aku, amu in Anak Mānusiyaꞌ, in kaagi sin pagbalik ku mari pa dunya biyaꞌ sin kilat sumiꞌnag ha taas langit. Diꞌ katapukan. ");
INSERT INTO tsg_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Sagawaꞌ subay aku lumabay naa muna kabinsanaan dakulaꞌ iban hisulak aku sin manga tau sin masa ini. ");
INSERT INTO tsg_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Bang aku amu in Anak Mānusiyaꞌ magbalik na mari pa dunya, in kahālan sin manga tau, biyaꞌ da tuud sin kahālan sin manga tau ha masa hi Nū. ");
INSERT INTO tsg_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","In piyaruli nila in pagkaun iban pagꞌinum iban sin pagtiyaun sin manga usug iban babai. Biyaꞌ ha yan in hinang nila sampay naabut in waktu simakat na hinda Nū pa taas sin bahitraꞌ. Na, pagdatung sin umbak tawpan naubus miyatay in tau katān. ");
INSERT INTO tsg_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“In kahālan sin manga tau ha waktu aku magbalik mari biyaꞌ da tuud isab sin kahālan sin manga tau sin masa hi Lūt. In piyaparuli sin tau katān in pagkaun, pagꞌinum, pamī-mī iban pagdagang, pagtanum iban paghinang bāy. ");
INSERT INTO tsg_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Na, ha adlaw pagꞌīg hinda Lūt dayn ha hulaꞌ Sudum, nagꞌulan kāyu iban maylang dayn ha taas langit, amu in nakamatay ha tau katān. ");
INSERT INTO tsg_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Na, biyaꞌ da isab ha yan in kahālan iban kumugdan ha manga tau bang aku, amu in Anak Mānusiyaꞌ, magpanyataꞌ ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Na, bang dumatung na in waktu yan, hisiyu-siyu in tau kasaꞌbuhan ha guwaꞌ sin bāy niya, subay siya diꞌ na magbīng pa lawm bāy kumawaꞌ sin unu-unu kalangkapan niya. Subay siya maguy na magtūy. Damikkiyan, in tau kasaꞌbuhan ha uma subay siya maguy na magtūy. Subay siya diꞌ na magbalik pa bāy niya. ");
INSERT INTO tsg_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Pamintang kamu sin kimugdan ha asawa hi Lūt! ");
INSERT INTO tsg_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Hisiyu-siyu in maūg sin kabuhiꞌ niya, amu in magpikil sadja sin kabayaan niya, tantu mapatay da siya. Sagawaꞌ hisiyu-siyu in diꞌ maūg sin kabuhiꞌ niya minsan siya mapatay, tantu makabaak siya kabuhiꞌ salama-lama. ");
INSERT INTO tsg_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Na, ingat kamu, ha waktu sin pagbalik ku mari, in manga tau mabahagiꞌ na. Bang sawpama sin dūm awn duwa tau natutūg hangka-kulangan, in hambuuk dāhun na, ampa in hangka-tau makabīn. ");
INSERT INTO tsg_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Damikkiyan, bang sawpama awn duwa babai naggigiling gandum, in hambuuk dāhun na, ampa in hangka-tau makabīn. ");
INSERT INTO tsg_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Iban bang sawpama awn duwa usug naghihinang ha uma, in hambuuk dāhun na, ampa in hangka-tau makabīn.” ");
INSERT INTO tsg_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nangasubu in manga mulid niya, laung nila, “Dāhun sila pakain?” Siyambungan sila sin hambuuk masaalla, laung niya, “Hawnu-hawnu lugal awn patay nahahaluꞌ pagtipunan yan mawn sin manga billiꞌ.” ");
INSERT INTO tsg_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Pagꞌubus nagnasīhat na isab hi Īsa ha manga mulid niya sin subay sila taptap iban diꞌ sumuhun mangarap pa Tuhan. Diyalil niya kaagi in pagnasīhat niya. ");
INSERT INTO tsg_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Laung hi Īsa, “Awn yaun hambuuk huwis ha hambuuk dāira in diꞌ mabugaꞌ ha Tuhan iban wayruun tau pagꞌaddatan niya. ");
INSERT INTO tsg_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Sakali awn isab hambuuk balu duun ha dāira yaun in daran magkawn pa huwis magmuhut-muhut mangayuꞌ tabang bat niya makawaꞌ in kapatutan niya. Laung niya, ‘Tabanga aku sin parakalaꞌ ku iban sin kuntara ku!’ ");
INSERT INTO tsg_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Na, in tagnaꞌ diꞌ tuud mabayaꞌ tumabang in huwis, sagawaꞌ maglulugay, namikil-mikil siya, laung niya ha lawm atay niya, ‘Minsan aku diꞌ mabugaꞌ ha Tuhan iban wayruun tau pagꞌaddatan ku, ");
INSERT INTO tsg_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pagga in balu ini daran manghilu mari kākuꞌ pasal sin parakalaꞌ niya, marayaw ku pa siya tabangun sin kapatutan niya. Sabab bang ku siya diꞌ tabangun, diꞌ siya humundung magkari kākuꞌ. Na, diꞌ lumugay aku in matay sin hapus!’” ");
INSERT INTO tsg_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Na, laung pa isab hi Īsa, “Na, pikila niyu in bichara sin huwis mangīꞌ yadtu. ");
INSERT INTO tsg_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Bang in huwis mangīꞌ maingat tumabang ha tau diꞌ niya pagꞌaddatan, na amu pa ka isab in Tuhan in diꞌ dumihil sin kapatutan sin manga tau sukuꞌ niya amu in mangayuꞌ tabang kaniya dūm-adlaw? Tantu, diꞌ niya palugayun in pagtabang niya. ");
INSERT INTO tsg_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Na, ingat kamu, saruun-duun tabangun sin Tuhan in manga tau sukuꞌ niya sin kapatutan nila. Sagawaꞌ in aku amu in Anak Mānusiyaꞌ, bang magbalik na mari pa dunya hangkatiyuꞌ da in tau karatungan ku amu in diꞌ mapinda in kusug sin pangandul pa Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nagnasīhat da isab hi Īsa ha manga tau, amu in magbantug sadja sin kabuntulan nila iban mamabaꞌ-mabaꞌ sadja ha kaibanan nila. Diyalil niya kaagi in pagnasīhat niya. ");
INSERT INTO tsg_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Laung hi Īsa kanila, “Bakas awn duwa tau timukad pa Bāy sin Tuhan nangarap pa Tuhan. In hambuuk tau Parisi, ampa in hangka-tau mangangawaꞌ sukay pa parinta. ");
INSERT INTO tsg_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pagsūd nila pa lawm Bāy sin Tuhan, timindug nagpakandi isa-isa niya in tau Parisi ampa nangarap pa Tuhan nagbantug sin baran niya, laung niya, ‘Ya Tuhan, magsarang-sukul tuud aku sin bukun aku manapsu, pangakkal iban maghinang sin diꞌ mapatut ha babai bukun asawa ku. Bukun aku biyaꞌ sin manga tau katān. Magsarang-sukul tuud aku sin bukun aku biyaꞌ sin tau mangangawaꞌ sukay pa parinta yaun. ");
INSERT INTO tsg_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Magpuasa aku duwa adlaw ha lawm sin hangka-pitu iban pagjakatan ku katān in altaꞌ ku.’ ");
INSERT INTO tsg_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Sumagawaꞌ in tau mangangawaꞌ sukay pa parinta duun timitindug ha kalayuan iban diꞌ niya minsan hikahangad pa taas in bayhuꞌ niya. Nagdukduk siya sin daghal niya sabab landuꞌ tuud in kasusahan niya. Laung niya, ‘Ya Tuhan, kaluuyi aku hambuuk baldusa!’ ");
INSERT INTO tsg_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Na, ingat kamu,” laung hi Īsa, “in tau mangangawaꞌ sukay muwiꞌ iban kaampunan dayn ha Tuhan. Itungun biyaꞌ sin tau walaꞌ nakarusa. Sagawaꞌ walaꞌ in Tuhan kiyaamuhan ha tau Parisi. Sabab hisiyu-siyu in tau magpataas sin baran niya hidusdus da siya pa babaꞌ, hāti hisiyu-siyu in magpababaꞌ sin baran niya angkatun da siya pa taas.” ");
INSERT INTO tsg_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Sakali in manga kaibanan tau nagdā mawn kan Īsa sin manga anak nila sibiꞌ-sibiꞌ ha supaya niya kakaputan kapangayuan anugharaꞌ dayn ha Tuhan. Pagkitaꞌ sin manga mulid hi Īsa kanila piyagꞌamahan nila in manga tau. ");
INSERT INTO tsg_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Sagawaꞌ tiyawag hi Īsa in manga bataꞌ-bataꞌ, laung niya ha manga mulid niya, “Pakaria niyu kākuꞌ in manga bataꞌ-bataꞌ, iban ayaw niyu sila lānga, sabab in manga tau amu in mangandul ha Tuhan biyaꞌ sin pangandul sin manga bataꞌ-bataꞌ yan (ha inaꞌ-amaꞌ nila), amu in makaagad sin pamarinta sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ini in mattan hibaytaꞌ ku kaniyu. Hisiyu-siyu in diꞌ magkahagad sin daakan sin pamarinta sin Tuhan biyaꞌ sin pagkahagad sin bataꞌ-bataꞌ (sin daakan sin maas niya), na diꞌ siya makaagad ha lawm pamarintahan sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Sakali awn hambuuk nakuraꞌ sin manga Yahudi in nangasubu kan Īsa, laung niya, “Tuwan, in ikaw yan tau marayaw. Unu in subay hinangun ku ha supaya aku kasukuan sin kabuhiꞌ salama-lama?” ");
INSERT INTO tsg_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","“Unu in sabab hangkan mu aku īyan tau marayaw?” laung hi Īsa kaniya. “Wayruun tau marayaw amura in Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kahagara in manga daakan sin Tuhan, amu in asal mu na kaingatan biyaꞌ na sin: ‘Ayaw kaw magjina, ayaw kaw mamunuꞌ, ayaw kaw manakaw, ayaw sumaksiꞌ sin bukun bunnal, pagꞌaddati in inaꞌ-amaꞌ mu.’” ");
INSERT INTO tsg_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Simambung in nakuraꞌ sin manga Yahudi, laung niya, “Iyaagad ku in katān daakan yan dayn sin kabataꞌ-bataꞌ ku pa.” ");
INSERT INTO tsg_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pagdungug hi Īsa sin sambung niya, laung hi Īsa kaniya, “Awn pa hambuuk kulang sin hinang mu. Dagangan in unu-unu mu katān ampa mu pagdihilan in bīhan ha manga miskin ha supaya awn altaꞌ mu didtu ha surgaꞌ. Pagꞌubus ampa kaw kari agad kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Sagawaꞌ pagdungug niya sin bichara hi Īsa, landuꞌ tuud siya nasusa sabab in siya dayahan tuud. ");
INSERT INTO tsg_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Na, kītaꞌ hi Īsa sin nasusa siya. Hangkan laung hi Īsa, “Kahunitan tuud in manga tau dayahan magad ha pamarinta sin Tuhan! ");
INSERT INTO tsg_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Sabab amu in pagꞌiyanun, kaluhayan pa in untaꞌ lumabay dayn ha buliꞌ jawm dayn sin tau dayahan magad ha pamarinta sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Na, in manga tau nakarungug sin pamung niya imiyan, laung nila, “Bang biyaꞌ hādtu in hāti niya wayruun tau malappas.” ");
INSERT INTO tsg_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Sagawaꞌ in sambung hi Īsa, “In unu-unu diꞌ marapat hinangun sin mānusiyaꞌ, marapat sadja sin Tuhan hinangun.” ");
INSERT INTO tsg_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Sakali namung hi Pitrus, laung niya, “Na, biyaꞌ diin in kami ini? Tiyaykuran namuꞌ na in pamāy-bāy namuꞌ ampa kami miyagad kaymu.” ");
INSERT INTO tsg_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","In sambung hi Īsa kanila, “Baytaan ta kamu sin tuman. Hisiyu-siyu in atas mamīn sin pamāy-bāy niya, atawa sin asawa niya, atawa sin manga taymanghud niya, atawa sin maas niya, atawa sin manga anak niya sabab-karnaꞌ sin pagꞌagad niya sin pamarinta sin Tuhan, ");
INSERT INTO tsg_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","na, lipat-manglipat in hitungbas kaniya sin Tuhan ha waktu bihaun iban ha masa susūngun, awn kabuhiꞌ niya salama-lama.” ");
INSERT INTO tsg_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Sakali diyā hi Īsa kimandi in hangpuꞌ tagduwa mulid niya dayn ha kaibanan tau, ampa niya sila biyaytaan, laung niya, “Kitaa niyu ba, in kitaniyu ini tudju madtu pa Awrusalam (Baytal Makdis). Na, duun mabunnal in katān kiyasulat sin manga kanabihan pasal ku, amu in Anak Mānusiyaꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Pagdatung natuꞌ madtu, hiungsud aku pa lawm lima sin manga tau bukun bangsa Yahudi, (amu in namamarinta sin hulaꞌ). Paglikiꞌ-likian nila aku, sipug-sipugun iban luraan nila aku. ");
INSERT INTO tsg_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pagꞌubus lapdusan nila aku sin lulubak, ubus ampa nila aku patayun. Sagawaꞌ ha hikatū sin adlaw dayn ha kamatay kākuꞌ, mabuhiꞌ aku magbalik.” ");
INSERT INTO tsg_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Sagawaꞌ walaꞌ kiyahātihan sin manga mulid niya in manga bichara niya minsan hangkatiyuꞌ. In maana sin manga lapal-kabtangan hi Īsa līlibun dayn kanila. Hangkan diꞌ nila kaingatan bang unu in piyagbibichara hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Sakali masuuk mayan hinda Īsa pa dāira Ariha, awn duun hambuuk tau buta naglilingkud ha higad dān nanglilimus ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pagdungug niya sin hibuk sin manga tau maglalabay, nangasubu siya bang unu in pakaradjaan. ");
INSERT INTO tsg_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Laung sin manga tau kaniya, “Maglalabay hi Īsa amu in tau dayn ha Nasarit.” ");
INSERT INTO tsg_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nagsuwara siya matanug, laung niya, “Anduꞌ, Īsa, hambuuk panubuꞌ hi Daud, kaulungi aku!” ");
INSERT INTO tsg_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sakali piyagꞌamahan siya sin manga tau ha unahan iban īyan siya diꞌ papaghibukun. Sagawaꞌ gām mayan piyatanug niya na tuud in pagsuwara niya, laung niya, “Anduꞌ, hambuuk panubuꞌ hi Daud, kaulungi aku!” ");
INSERT INTO tsg_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Na, himundung hi Īsa ampa siya nagdaak hiparā mawn kaniya in tau buta. Narā mayan mawn in tau buta, iyasubu siya hi Īsa, laung niya, ");
INSERT INTO tsg_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Unu in kabayaan mu hitabang ku kaymu?” “Tuwan,” in sambung niya, “in kabayaan ku makakitaꞌ aku magbalik.” ");
INSERT INTO tsg_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Laung hi Īsa kaniya, “Na, makakitaꞌ na kaw! Dayn ha sabab sin parachaya iban pangandul mu in ikaw kiyaulian na.” ");
INSERT INTO tsg_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Na, saruun-duun nakakitaꞌ na in tau buta. Imurul na siya kan Īsa iban pagsarang-sukul niya pa Tuhan. Pagkitaꞌ sin manga tau sin biyaꞌ hādtu, namudji sila katān pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Pagꞌubus limanjal na hinda Īsa limabay dayn ha dāira Ariha. ");
INSERT INTO tsg_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na, awn duun ha dāira yaun hambuuk nakuraꞌ sin manga mangangawaꞌ sukay pa parinta pagngānan hi Sakkiyas, hambuuk tau dayahan. ");
INSERT INTO tsg_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Mabayaꞌ tuud siya kimitaꞌ bang biyaꞌ diin in lupa hi Īsa. Sagawaꞌ diꞌ siya makakitaꞌ kan Īsa sabab mataud tuud in tau ha unahan niya ampa in siya pandak. ");
INSERT INTO tsg_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hangkan dimagan siya miyuna dayn ha manga tau mataud ampa siya dimāg pa taas kahuy pagngānan kahuy sikamul bat niya kakitaan hi Īsa, sabab dayn didtu hi Īsa lumabay ha tungud sin kahuy yaun. ");
INSERT INTO tsg_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nakaabut mayan hi Īsa pa tungud sin kahuy, himangad siya ampa niya īyan hi Sakkiyas, laung niya, “Ūs-ꞌūs kaw naug Sakkiyas sabab duun aku subay humantiꞌ ha bāy mu adlaw ini.” ");
INSERT INTO tsg_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Na, nagꞌūs-ꞌūs na nanaug hi Sakkiyas ampa niya diyā hi Īsa piyakaun ha bāy niya. Landuꞌ tuud kiyūgan hi Sakkiyas. ");
INSERT INTO tsg_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","In tau katān nakakitaꞌ walaꞌ kiyaamuhan. Laung nila, “Ay kaw naa, in tau yan humantiꞌ ha bāy sin hambuuk tau baldusa!” ");
INSERT INTO tsg_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakali timindug hi Sakkiyas ampa siya imiyan kan Panghuꞌ Īsa, laung niya, “Kitaa ba Tuwan, hirihil ku bihaun in hangtungaꞌ sin altaꞌ ku ha manga miskin, iban bang awn tau kiyakullian ku, hiuliꞌ ku kaniya in altaꞌ niya iban lipatun ku pa magꞌupat in taud niya.” ");
INSERT INTO tsg_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Laung hi Īsa kaniya, “Ha adlaw ini dimatung na in kalappasan pa manga tau ha bāy ini, karnaꞌ in tau ini hambuuk da isab panubuꞌ hi Nabi Ibrahim simupu ha addat niya. ");
INSERT INTO tsg_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Iban hangkan bihādtu sabab in aku, amu in Anak Mānusiyaꞌ limahil mari pa dunya lumawag iban lumappas ha manga tau nalawaꞌ dayn ha dān tudju pa Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sakali pagga sila masuuk na tuud pa Awrusalam (Baytal Makdis) in pangannal sin manga tau masuuk na maawn in pamarinta sin Tuhan. Hangkan, ha saꞌbu sin manga tau nagdurungug kaniya, liyanjal hi Īsa in pagbichara niya. Diyalil niya kaagi in pagbaytaꞌ niya kanila pasal sin pamarinta sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Laung hi Īsa kanila, “Bakas awn hambuuk tau balbangsa, in timulak pa hambuuk hulaꞌ malayuꞌ bat niya makawaꞌ in kapatutan niya magsultan. Ampa in gantaꞌ niya magbalik da siya. ");
INSERT INTO tsg_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ha sūng niya mayan tumulak, piyatawag niya in hangpuꞌ daraakun niya ampa niya dīhilan pakaniya-pakaniya hambuuk dublun (hargaꞌ tūy bulan gadji sin tau). Ubus ampa niya sila īyan, laung niya, ‘Pagpuunan niyu magꞌusaha in sīn yan ha salugay ku walaꞌ dī.’ ");
INSERT INTO tsg_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Sagawaꞌ in tau ini karugalan sin manga tau pagkahi niya hangka-hulaꞌ. Hangkan nagdaak sila manga tau imurul kaniya pa hulaꞌ kadtuun niya mamaytaꞌ sin diꞌ sila mabayaꞌ pagsultanan sin tau yaun. ");
INSERT INTO tsg_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Sagawaꞌ nahinang da sultan in tau yaun iban nagbalik siya pa hulaꞌ niya. Pagdatung niya na mayan, magtūy niya piyatawag in manga daraakun kiyarihilan niya sīn ha supaya niya mapariksaꞌ bang pila na in nausaha nila. ");
INSERT INTO tsg_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Na, pagkawn sin hambuuk daraakun, amu agi kaniya, ‘Tuwan, in dublun dīhil mu kākuꞌ piyagꞌusaha ku nalipat nakahangpuꞌ in taud niya.’ ");
INSERT INTO tsg_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Laung niya ha daraakun niya, ‘Marayaw in nahinang mu. Hambuuk kaw daraakun marayaw. Pagga kaw kapangandulan sin altaꞌ sibiꞌ-sibiꞌ, bihaun ikaw in pangandulan ku magkaput sin hangpuꞌ dāira.’ ");
INSERT INTO tsg_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Na, nākawn na isab in hikaruwa daraakun niya, amu agi kaniya, ‘Tuwan, in dublun dīhil mu kākuꞌ piyagꞌusaha ku nalipat nakalima in taud niya.’ ");
INSERT INTO tsg_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Laung niya ha daraakun niya ini, ‘Ikaw in pangandulan ku magkaput sin lima dāira.’ ");
INSERT INTO tsg_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Pagꞌubus nākawn na isab in hambuuk daraakun niya, amu agi kaniya, ‘Tuwan, yari in dublun bakas mu dīhil kākuꞌ. Tiyawꞌ ku piyutus sin panyuꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mabugaꞌ aku kaymu sabab kaingatan ku in ikaw mabungis. Magdayaw parasahan sadja kaw sin unu-unu walaꞌ mu piyaghulas-sangsaan. Magꞌani kaw sin bukun mu tiyanum!’ ");
INSERT INTO tsg_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Laung niya ha daraakun niya, ‘Hambuuk kaw daraakun way kapūsan! In hukuman hirihil ku kaymu kawaun dayn ha kiyabichara mu yan pasal ku. Kiyaingatan mu asal, laung mu, in aku mabungis iban magdayaw parasahan sadja sin bukun ku piyaghulas-sangsaan iban magpangꞌani sin bukun ku tiyanum. ");
INSERT INTO tsg_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Na, pagga mu kiyaingatan in biyaꞌ ha yan, maytaꞌ mu walaꞌ biyutang ha bangku in sīn ku, ha supaya pagbalik ku makawaꞌ ku magbalik in sīn ku iban sin anak niya?’ ");
INSERT INTO tsg_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Pagꞌubus ampa niya īyan in manga kaibanan daraakun nagtitindug duun, laung niya, ‘Kawaa niyu in dublun dayn kaniya ampa niyu dihilan pa daraakun amu in nalipat nakahangpuꞌ in taud sin sīn nausaha niya.’ ");
INSERT INTO tsg_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Sagawaꞌ in sambung nila kaniya, ‘Tuwan, in siya nalipat na nakahangpuꞌ in taud sin dublun niya!’ ");
INSERT INTO tsg_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Na, in sambung niya, ‘Na, ingat kamu, asal biyaꞌ na ha yan. Karnaꞌ hisiyu-siyu in matuyuꞌ magpasūng sin altaꞌ kiyarihil kaniya, dugangan pa in hirihil kaniya, sagawaꞌ in way tuyuꞌ magpasūng sin altaꞌ kiyarihil kaniya, na, minsan in maniyuꞌ-tiyuꞌ altaꞌ niya, kawaan da dayn kaniya. ");
INSERT INTO tsg_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na, bihaun, in manga tau marugal kākuꞌ amu in diꞌ mabayaꞌ magsultan kākuꞌ, dāha niyu mari ampa niyu pataya dī ha alupan ku!’” ");
INSERT INTO tsg_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pagꞌubus hi Īsa nagbichara limanjal na sila timukad pa Awrusalam (Baytal Makdis). Ha unahan siya sin manga iban niya. ");
INSERT INTO tsg_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Masuuk mayan sila pa duwa kawman pagngānan Bitpaji iban Bitani duun ha Būd Jaytun, piyauna niya madtu in duwa mulid niya. ");
INSERT INTO tsg_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Laung niya ha duwa mulid niya, “Kadtu kamu pa kawman sūngun niyu yaun. Pagdatung niyu madtu, makabāk kamu hambuuk kuraꞌ hiyuhukutan, mabataꞌ pa, iban walaꞌ pa kiyapanguraan. Hubari niyu ampa niyu dāha mari. ");
INSERT INTO tsg_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Bang awn mangasubu kaniyu bang maytaꞌ niyu hiyubaran, baytai niyu kagunahan sin Panghuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Na, miyanaw na in duwangka-tau naraak hi Īsa. Piyaglanggal nila katān in biyaytaꞌ kanila hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ha saꞌbu nila naghuhubad sin kuraꞌ, laung sin manga tagdapu kanila, “Maytaꞌ niyu yan hiyubaran?” ");
INSERT INTO tsg_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","In sambung nila, “Kagunahan sin Panghuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Na, diyā nila na in kuraꞌ madtu kan Īsa. Pagdatung nila madtu, liyampikan nila in kuraꞌ sin juba nila ampa nila piyasakat hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Piyapanaw niya mayan in kuraꞌ, hīklad sin manga tau in juba nila mawn pa dān (tandaꞌ sin panglagguꞌ nila kan Īsa). ");
INSERT INTO tsg_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nakasuuk mayan siya pa Awrusalam (Baytal Makdis), duun ha tungud sin dān ludlurun ha Būd Jaytun, in manga mulid niya landuꞌ mataud nagsuwara matanug sin pagsarang-sukul iban pamudji nila pa Tuhan pasal sin manga katān makahaylan kītaꞌ nila. ");
INSERT INTO tsg_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Laung nila, “Bang mayan barakatan sin Tuhan in kiyawakilan niya magbayaꞌ ha unu-unu katān! Kasannyangan ha lawm surgaꞌ iban kalagguan pa Tuhan!” ");
INSERT INTO tsg_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Sakali awn kaibanan manga Parisi duun miyamagad ha manga tau mataud in imiyan kan Īsa, laung nila, “Tuwan, lāngi in manga mulid mu, ayaw mu papaghibuka!” ");
INSERT INTO tsg_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","In sambung hi Īsa, “Ingat kamu. Bang ku sila lāngun diꞌ papaghibukun, in manga kabatuhan in sumubli maghibuk.” ");
INSERT INTO tsg_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sakali nakasuuk mayan sila pa Awrusalam (Baytal Makdis) sartaꞌ kītaꞌ na hi Īsa in dāira, nagtangis siya sabab sin luuy niya ha manga tau Awrusalam (Baytal Makdis). ");
INSERT INTO tsg_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Laung niya, “Bang niyu sadja kaingatan ha bihaun bang unu in makarihil kaniyu kasannyangan! Sagawaꞌ diꞌ niyu kaingatan! ");
INSERT INTO tsg_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Dumatung da in waktu matikup kamu sin manga kuntara niyu iban būran nila sin lupaꞌ iban batu in katilibut sin dāira niyu ha supaya wayruun guwaan niyu. Hapaan kamu iban jagahan kamu dayn ha kīd pa kīd. ");
INSERT INTO tsg_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Maubus kamu mapatay katān iban magkalubu-lubu tuud in lawm paghulaꞌ niyu. Wayruun minsan hambuuk batu in makapin ha kiyabutangan niya. Biyaꞌ ha yan in kumugdan kaniyu sabab walaꞌ niyu piyaruli in waktu piyakitaꞌ sin Tuhan in luuy niya kaniyu!” ");
INSERT INTO tsg_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pagꞌubus miyadtu hi Īsa pa halaman sin Bāy sin Tuhan ampa niya diyūy pa guwaꞌ in manga magdaragang. ");
INSERT INTO tsg_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Laung niya kanila, “Kiyasulat ha Kitab in Parman sin Tuhan amu agi, ‘In Bāy ku Bāy Pagtataatan.’ Sagawaꞌ,” laung hi Īsa, “hīnang niyu in Bāy sin Tuhan lugal pagꞌaanyayahan sin sīn sin manga tau!” ");
INSERT INTO tsg_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nagnasīhat hi Īsa adlaw-adlaw ha lawm Bāy sin Tuhan. In kabayaan sin manga nakuraꞌ kaimaman, sin manga guru sin saraꞌ agama iban sin manga nakuraꞌ sin manga tau patayun hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Sagawaꞌ wayruun dān kabaakan nila hikabunuꞌ kan Īsa, sabab in tau katān duun masi-masi dimurungug kan Īsa iban in kabayaan nila wayruun minsan hambuuk kabtangan hi Īsa in malipas dayn ha pagdungug nila. ");
INSERT INTO tsg_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Manjari hambuuk adlaw duun hi Īsa ha Bāy sin Tuhan nagnasīhat ha manga tau iban nagpamahalayak sin Baytaꞌ Marayaw. Sakali nākawn in manga nakuraꞌ kaimaman, iban manga guru sin saraꞌ agama nagꞌaagad iban sin manga nagtatau-maas ha hulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Laung nila kan Īsa, “Baytai kami bang unu in kawasa mu maghinang sin manga hinang mu yan dī ha lawm Bāy ini, amu in Bāy sin Tuhan? Hisiyu in nagdihil kaymu sin kawasa maghinang sin manga hinang mu yan?” ");
INSERT INTO tsg_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","In sambung hi Īsa kanila, “Na, awn isab hipangasubu ku muna kaniyu. Baytai niyu aku ");
INSERT INTO tsg_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","bang dayn hāin nakawaꞌ hi Yahiya in kawasa niya mangliguꞌ ha manga tau, dayn ha Tuhan atawa dayn ha mānusiyaꞌ?” ");
INSERT INTO tsg_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Na, nagꞌisun-isun na sila bang unu in hisambung nila. Laung nila, “Na, unu in hisambung natuꞌ kaniya? Bang kitaniyu imiyan in kawasa hi Yahiya dayn ha Tuhan, na, iyanun niya kitaniyu, ‘Na, maytaꞌ kamu walaꞌ nagparachaya kan Yahiya?’ ");
INSERT INTO tsg_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Sagawaꞌ bang isab kitaniyu imiyan dayn ha mānusiyaꞌ in kawasa niya, na, batuhun kitaniyu sin manga tau mataud ini sabab magkahagad tuud in manga tau sin hi Yahiya hambuuk nabi.” ");
INSERT INTO tsg_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hangkan in sambung nila kan Īsa, “Inday, diꞌ namuꞌ kaingatan bang dayn diin niya nakawaꞌ in kawasa niya.” ");
INSERT INTO tsg_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Na, laung hi Īsa kanila, “Na, bang biyaꞌ hādtu, diꞌ da isab kamu baytaan bang dayn hāin ku nakawaꞌ in kawasa ku huminang sin manga hinang ku yan.” ");
INSERT INTO tsg_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Sakali biyaytaan hi Īsa in manga tau (pasal sin manga tau simasaggaꞌ kaniya). Diyalil niya kaagi in pagbaytaꞌ niya. Laung niya, “Bakas awn hambuuk tau nagtanum anggul ha kabbun niya. Pagꞌubus ampa niya piyatungguan in kabbun anggul niya ha manga magtutungguꞌ kabbun, ampa siya timulak pa dugaing hulaꞌ. Malugay siya didtu. ");
INSERT INTO tsg_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Manjari naabut mayan in musim sin pagpusuꞌ sin manga anggul, diyaak sin tagdapu kabbun in hambuuk daraakun niya madtu kumawaꞌ sin manga bunga anggul bahagiꞌ niya. Sagawaꞌ bīnasa sin manga tungguꞌ kabbun in daraakun niya, ampa piyauwiꞌ ha way kaunu-unu. ");
INSERT INTO tsg_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Sakali piyakadtu na isab sin tagkabbun in hambuuk daraakun niya, sagawaꞌ bīnasa da isab sin manga tungguꞌ kabbun iban sīpug-sipug nila, ampa piyauwiꞌ ha wayruun unu-unu narā niya. ");
INSERT INTO tsg_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Sakali piyakadtu na isab sin tagkabbun in hikatū daraakun niya, sagawaꞌ miyula siya sin manga tungguꞌ kabbun. Piyalian in daraakun. Ubus ampa siya liyaruk pa guwaꞌ sin kabbun. ");
INSERT INTO tsg_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Na, namikil-mikil na in tagkabbun. Laung niya ha lawm atay niya, ‘Unu na bahaꞌ in hinangun ku? Na, marayaw pa pakadtuun ku in anak ku kalasahan. Marayꞌ, pagꞌaddatan nila siya!’ ");
INSERT INTO tsg_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Sagawaꞌ pagkitaꞌ sin manga tungguꞌ kabbun ha anak niya, magtūy sila nagꞌisun. Laung nila, ‘Yan na in anak sin tagkabbun amu in kiyapusakaan sin kabbun ini. Patayun natuꞌ siya ha supaya natuꞌ makawaꞌ in kabbun pusakaꞌ kaniya!’ ");
INSERT INTO tsg_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Hangkan giyuyud nila in anak sin tagkabbun pa guwaꞌ sin kabbun ampa nila piyatay. “Na, ha pikil niyu, unu in hinangun sin tagkabbun ha manga tungguꞌ sin kabbun niya?” laung hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Kadtuun niya in manga tungguꞌ kabbun ampa niya sila patayun. Pagꞌubus ampa niya patungguan ha manga dugaing tungguꞌ in kabbun niya.” Pagdungug nila sin bichara hi Īsa, laung nila, “Sipais piyakalayuꞌ sin Tuhan!” ");
INSERT INTO tsg_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iyatud sila hi Īsa ampa niya sila iyasubu, laung niya, “Bang yan bukun bunnal, unu in hātihan sin kiyabaytaꞌ ha lawm Kitab, amu agi, ‘In batu biyugit sin manga maghihinang bāy (sabab in pangannal nila wayruun guna) amura tuud isab in batu nanjari piyagpapagun sin bāy.’ ");
INSERT INTO tsg_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Na, ingat kamu,” laung hi Īsa, “hisiyu-siyu in makaligad pa batu yan magkapusat-pusat in baran niya iban hisiyu-siyu in kahulugan sin batu yan magkatumu-tumu siya mahinang bagunbun.” ");
INSERT INTO tsg_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Na, landuꞌ tuud in bayaꞌ sin manga guru sin saraꞌ agama iban sin manga nakuraꞌ kaimaman sumaggaw kan Īsa saruun-duun, sabab kiyahātihan nila sin sila in kiyugdan sin isturi diyalil hi Īsa. Sagawaꞌ diꞌ nila mahinang sabab mabugaꞌ sila ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Hangkan limawag sila saat marayaw. Nanangdan sila manga tau, piyakadtu kan Īsa magpabawꞌ-bawꞌ mangasubu kaniya, bahasa tau marayaw sila agad ha saraꞌ, sagawaꞌ in bunnal niya hipalusut nila hi Īsa ha bichara ha supaya nila siya hikaungsud pa lawm kiyumkuman iban kawasa sin gubnul. ");
INSERT INTO tsg_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Na, nangasubu na kan Īsa in manga tau kiyatangdanan ini, laung nila, “Tuwan, kiyaiingatan namuꞌ sin in katān bichara iban hinduꞌ mu mabuntul. In hihinduꞌ mu sadja in kasabunnalan pasal sin manga addat iban kawl-piil amu in kabayaan sin Tuhan pakayun sin mānusiyaꞌ karnaꞌ diꞌ kaw magpīꞌ tau minsan hisiyu. ");
INSERT INTO tsg_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Na, baytai kami, langgal saraꞌ ka sin saraꞌ agama bang kitaniyu manga Yahudi, amu in ha babaan sin pamarinta sin hulaꞌ Rūm, magbayad sayrulla pa Sultan sin hulaꞌ Rūm atawa bukun?” ");
INSERT INTO tsg_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Sagawaꞌ kiyatalusan hi Īsa in katitipuhan sin akkal nila. Hangkan laung niya kanila, ");
INSERT INTO tsg_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Pakitaan niyu mari kākuꞌ in hambuuk pisita.” Piyakitaꞌ mayan mawn kaniya in pisita, iyasubu niya sila, laung niya, “Kansiyu in pattaꞌ iban ngān ha pisita ini?” “Ha Sultan sin hulaꞌ Rūm,” in sambung nila. ");
INSERT INTO tsg_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Hangkan laung hi Īsa kanila, “Na, pagga biyaꞌ ha yan, unu in sukuꞌ sin Sultan sin hulaꞌ Rūm subay hiungsud kaniya. Damikkiyan, unu in sukuꞌ sin Tuhan subay hiungsud pa Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Na, walaꞌ nila nasaggaw ha bichara hi Īsa ha alupan sin mayran madjilis. Hangkan walaꞌ na sila nagkaybaꞌ iban nainu-inu sila sin sambung hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Pagꞌubus yadtu awn manga kaibanan Yahudi pagngānan Sadduki in miyawn kan Īsa. In sila ini imiyan sin in manga patay diꞌ na mabuhiꞌ magbalik ha adlaw mahuli. Nangasubu sila kan Īsa, laung nila, ");
INSERT INTO tsg_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Tuwan, kiyasulat hi Musa ha lawm saraꞌ agama natuꞌ, amu agi, ‘Bang awn usug mapatay ampa wayruun anak niya ha asawa niya, na subay asawahun sin taymanghud niya in balu, ha supaya awn tubuꞌ dumā sin ngān sin miyatay! ");
INSERT INTO tsg_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Na, bakas awn pitu magtaymanghud usug. Manjari nagꞌasawa in kamagulangan, sagawaꞌ miyatay sadja siya walaꞌ nakabaak anak. ");
INSERT INTO tsg_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Na, in balu iyasawa sin sumunud ha kamagulangan. Sagawaꞌ miyatay sadja isab siya walaꞌ da nakabaak anak. ");
INSERT INTO tsg_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Damikkiyan, biyaꞌ da isab hādtu in kimugdan ha hikatū. Na, in hawpuꞌ niya in babai yadtu naasawa sin kapitu-pitu magtaymanghud, sagawaꞌ miyatay sadja sila walaꞌ nakabaak anak ha babai yadtu. ");
INSERT INTO tsg_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ha kahinapusan miyatay da isab in babai. ");
INSERT INTO tsg_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na, bang dumatung na in waktu mabuhiꞌ na magbalik in manga patay, hisiyu in tagꞌasawa ha babai yadtu? Karnaꞌ naasawa siya sin kapitu magtaymanghud.’” ");
INSERT INTO tsg_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","In sambung hi Īsa kanila, “Asal in manga usug iban manga babai bihaun dī ha lawm dunya magꞌasawa iban magbana. ");
INSERT INTO tsg_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Sagawaꞌ in manga usug iban manga babai amu in matūp mabuhiꞌ dayn ha kamatay iban kaawnan sin kabuhiꞌ salama-lama ha adlaw mahuli didtu ha surgaꞌ diꞌ na magꞌasawa atawa magbana. ");
INSERT INTO tsg_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mabiyaꞌ na sila sin manga malāikat iban diꞌ na sila magkamatay. Mahinang na sila anak sin Tuhan sabab nabuhiꞌ na sila nagbalik dayn ha kamatay. ");
INSERT INTO tsg_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Na, ha pasal sin manga patay mabuhiꞌ magbalik, in kasabunnalan niya yan napakitaꞌ hi Musa. Karnaꞌ kiyasulat niya in pasal sin bichara sin Tuhan kaniya amu in suwara guwaꞌ dayn ha lawm kahuy nalalaga. Kiyasulat ha lawm Kitab sin namung hi Musa sin in Tuhan amuna in Tuhan hi Ibrahim, Tuhan hi Isahak iban Tuhan hi Yaꞌkub. ");
INSERT INTO tsg_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","In Tuhan amu in piyagtutuhanan sin manga buhiꞌ, bukun sin manga patay. (In hāti niya minsan hinda Ibrahim, Isahak iban Yaꞌkub malugay na miyatay, buhiꞌ sila didtu ha surgaꞌ.) Karnaꞌ bang ha Tuhan in mānusiyaꞌ katān buhiꞌ, wayruun patay.” ");
INSERT INTO tsg_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Sakali imiyan in kaibanan guru sin saraꞌ agama, laung nila, “Tuwan, marayaw in sambung mu!” ");
INSERT INTO tsg_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Iban hangkan sila imiyan biyaꞌ ha yan sabab diꞌ na sila makatawakkal umasubu kan Īsa sin unu-unu na. ");
INSERT INTO tsg_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sakali nagꞌasubu hi Īsa kanila, laung niya, “Biyaꞌ diin kaagi in bichara sin tau sin in Almasi hambuuk panubuꞌ sadja hi Daud? ");
INSERT INTO tsg_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Karnaꞌ, ha lawm Kitab Jabur kiyasulat in pamung hi Daud, amu agi, ‘Namung in Tuhan ha Panghuꞌ ku: “Lingkud kaw dī ha dapit pa tuu ku ");
INSERT INTO tsg_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","sampay ku mapabutang ha babaan mu in katān simusulang kaymu, mahinang biyaꞌ sapantun pagbubutangan sin siki mu.”’” ");
INSERT INTO tsg_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Na,” laung hi Īsa, “In pagtāg hi Daud ha Almasi, ‘Panghuꞌ.’ Na, maytaꞌ siya tiyawag, ‘Panghuꞌ,’ bang siya hambuuk sadja panubuꞌ hi Daud?” ");
INSERT INTO tsg_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ha saꞌbu sin manga tau katān dimurungug, laung hi Īsa ha manga mulid niya, ");
INSERT INTO tsg_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Halliꞌ kamu supaya kamu diꞌ kalaminan sin ngīꞌ sin manga guru sin saraꞌ agama. In sila yan matagi maglunsul pawyu-pawyu iban sin pagjuba nila mahabaꞌ lāgiꞌ mabayaꞌ tuud sila salamun sin manga tau ha tabuꞌ. Bang sila ha lawm langgal lumingkud sila ha unahan ha paglilingkuran tiyatawꞌ ha manga tau mataas, iban bang sila ha pagjamuhan lumingkud sila ha manga lilingkuran tiyatawꞌ ha manga tau balkanan. ");
INSERT INTO tsg_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Anyayahun nila in manga bāy sin manga balu babai. Ubus ampa sila magpakitaꞌ-kitaꞌ ha manga tau sin habaꞌ sin pagpangarap nila pa Tuhan, ha supaya in manga tau magpikil sin in sila tau marayaw. Murkaꞌ dakulaꞌ in dumatung kanila yan!” ");
INSERT INTO tsg_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Sakali nangatud-ngatud hi Īsa ha manga tau. Kītaꞌ niya in manga tau dayahan naghulug sīn pa paghuhulugan sin sīn hirihil pa Bāy sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kītaꞌ niya da isab in hambuuk balu babai miskin tuud himulug duwa pisita tumbaga. ");
INSERT INTO tsg_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Laung hi Īsa, “Baytaan ta kamu, in balu miskin yaun mataud pa in sīn hiyulug niya dayn sin kiyahulug sin manga tau katān yaun. ");
INSERT INTO tsg_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sabab in manga kaibanan tau, in sīn hiyulug nila, diꞌ nila na kagunahan tuud. Sagawaꞌ in balu yan, minsan siya miskin tuud, hiyulug niya in sīn niya katān minsan amu-amurakuman in hipamī niya sin kakaun niya.” ");
INSERT INTO tsg_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Na, in manga kaibanan mulid hi Īsa nagbibichara pasal sin lingkat sin Bāy sin Tuhan iban sin manga batu niya mahargaꞌ, iban sin manga unu-unu ginisan ha Bāy sin Tuhan dīhil sin manga tau pa Tuhan. Laung hi Īsa, ");
INSERT INTO tsg_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“In katān yan kakitaan niyu bihaun. Sagawaꞌ awn da waktu dumatung ha susūngun in katān yan magkalubu-lubu tuud iban wayruun tuud makapin batu nagbabangkat-bangkat, sagawaꞌ mapantay yan maligad katān.” ");
INSERT INTO tsg_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","“Tuwan,” laung nila kan Īsa, “kuꞌnu yan maawn? Iban unu in tandaꞌ gumuwaꞌ amu in magpakitaꞌ sin dumatung na in waktu maawn in manga biyaytaꞌ mu kāmuꞌ?” ");
INSERT INTO tsg_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Laung hi Īsa, “Halliꞌ kamu bat kamu diꞌ kaakkalan. Sabab ha susūngun mataud tau in mari magꞌusal sin ngān ku mangakkal kaniyu. In pakaniya-pakaniya kanila umiyan siya na in Almasi iban laung nila, ‘Dimatung na in waktu!’ Sagawaꞌ ayaw kamu magkahagad kanila. ");
INSERT INTO tsg_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Iban bang niyu karungugan in pagbunuꞌ iban manga hiluhalaꞌ dakulaꞌ ha lawm hulaꞌ ayaw kamu mabugaꞌ. Karnaꞌ in manga yan asal subay maawn muna, sagawaꞌ bukun pa yan in waktu kahinapusan sin masa dī ha dunya.” ");
INSERT INTO tsg_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Laung pa isab hi Īsa, “In manga kabangsa-bangsahan magbunuꞌ-biyunui iban magkuntara in manga parinta sin kahulaꞌ-hulaan. ");
INSERT INTO tsg_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Maawn in linug makusug, in gutum iban manga sakit mangīꞌ ha kahulaꞌ-hulaan. Iban awn gumuwaꞌ manga kagalib-galiban ha langit amu in makabugaꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Sumagawaꞌ ha diꞌ pa maawn in manga ini katān, in kamu masaggaw iban mabinsanaꞌ tuud. Hiungsud kamu pa lawm lima sin manga manghuhukum ampa kamu hukumun ha manga langgal ubus ampa kamu hipajīl. Marā kamu pa alupan sin manga sultan iban manga gubnul sabab in kamu agad kākuꞌ! ");
INSERT INTO tsg_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Na, amu yan in waktu niyu mamaytaꞌ kanila sin Baytaꞌ Marayaw pasal ku. ");
INSERT INTO tsg_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Sagawaꞌ asal tantuha in baran niyu sin diꞌ kamu magsusa bang unu in hiraawa niyu ha walaꞌ pa miyabut in waktu. ");
INSERT INTO tsg_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Sabab dihilan ta kamu ingat iban manga lapal-kabtangan hibichara niyu, amu in diꞌ kaatuhan iban kasaggaan sin manga kuntara niyu. ");
INSERT INTO tsg_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tipuhun kamu sin maas niyu, sin manga taymanghud, sin manga lahasiyaꞌ iban sin manga bagay niyu. Iban in kamu kaibanan hipapatay da. ");
INSERT INTO tsg_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Karugalan kamu sin tau katān sabab in kamu agad kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Sagawaꞌ ayaw kamu masusa. Amu in pagꞌiyanun minsan hambuuk sulag buhuk wayruun malarut dayn ha ū niyu. ");
INSERT INTO tsg_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Na, sandali niyu in manga kabinsanaan yan ampa kamu malappas. ");
INSERT INTO tsg_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Bang niyu kakitaan in Awrusalam (Baytal Makdis) matikup na sin manga sundalu, na matantu niyu na sin masuuk na in dāira yan magmula. ");
INSERT INTO tsg_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Na, ha waktu yan, in manga tau ha Yahudiya subay maguy na pa kabūran. Hāti in manga tau ha lawm sin dāira subay sila mīg na, iban in manga ha gimba subay diꞌ na sumūd pa lawm dāira. ");
INSERT INTO tsg_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sabab amuna yan in waktu paratungun sin Tuhan in murkaꞌ niya. In katān kiyasulat ha manga Kitab ha pasal yan maagad na ha waktu yan. ");
INSERT INTO tsg_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Landuꞌ tuud makaluuy in manga burus iban sin manga taga anak sibiꞌ-sibiꞌ bang dumatung na in kabinsanaan yan! Landuꞌ tuud in kabinsanaan kumugdan ha hulaꞌ ini, iban murkaꞌ dakulaꞌ in kumugdan ha manga tau sin hulaꞌ ini. ");
INSERT INTO tsg_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","In kaibanan tau patayun lagutun sin pakukus. Hāti in kaibanan masaggaw mahinang banyagaꞌ sin manga bangsa dugaing dāhun pa manga ginisan hulaꞌ nila katān. In Awrusalam (Baytal Makdis) makapalawm lima na sin manga tau bangsa dugaing. Iban diꞌ sila hundungan binsanaun sin manga tau bangsa dugaing sampay diꞌ mapuas in waktu nila. ");
INSERT INTO tsg_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Awn mahal-mahal kumugdan ha suga, ha bulan iban ha manga bituun. Dakulaꞌ in kasusahan dumatung pa kahulaꞌ-hulaan ha lawm dunya, iban landuꞌ in bugaꞌ sin manga tau bang sila makarungug sin lagublub sin alun iban bang nila kakitaan in lagguꞌ sin alun. ");
INSERT INTO tsg_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","In manga tau mapunung sin bugaꞌ pagpikil nila sin manga katān kabinsanaan dumatung pa dunya, karnaꞌ majugjug na in unu-unu katān ha taas langit. ");
INSERT INTO tsg_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Pagꞌubus in aku, amu in Anak Mānusiyaꞌ, kakitaan na sin manga mānusiyaꞌ numaug magbalik mari pa dunya miyamagad ha gabun. Kakitaan nila in kusug sin kawasa ku iban sin sahaya iban kalagguan ku. ");
INSERT INTO tsg_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na, bang tumagnaꞌ na maawn in manga biyaytaꞌ ku yan, paisuga niyu in lawm atay niyu. Tindug kamu hangad pa taas sabab masuuk na dumatung in kalappasan niyu.” ");
INSERT INTO tsg_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Pagꞌubus nagbichara hi Īsa dalil. Laung niya, “Kitaa niyu ba in kahuy tina iban sin manga kahuy kaibanan. ");
INSERT INTO tsg_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bang niyu kakitaan tumagnaꞌ na magdahun in manga kahuy yan, kaingatan niyu masuuk na tuud in panuga. ");
INSERT INTO tsg_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Damikkiyan, bang niyu kakitaan maawn na in manga piyagbaytaꞌ ku yan, kaingatan niyu na sin masuuk na dumatung in pamarinta sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Na, ini in tumtuma niyu. In katān biyaytaꞌ ku yan kaniyu, maawn ha diꞌ pa maubus malanyap in bangsa sin manga tau ha masa ini. ");
INSERT INTO tsg_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ha susūngun in langit iban dunya ini malanyap da, sagawaꞌ in manga katān kiyapamung ku, diꞌ tuud maluppas salama-lama.” (sabab in yan tantu tuud mabunnal) ");
INSERT INTO tsg_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","“Halliꞌ kamu ha supaya kamu diꞌ ku abutan biyaꞌ hantang maliꞌtag, naghihinang sin manga bukun marayaw biyaꞌ sin paglami-lami makalanduꞌ, magꞌinum maghilu, iban magsusa sin manga ginis-ginisan dī ha lawm dunya. Karnaꞌ ha pagbalik ku mari magminsan aku dumatung pa katān mānusiyaꞌ ha lawm dunya. ");
INSERT INTO tsg_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Halliꞌ tuud kamu iban taptap kamu pangayuꞌ duwaa bang mayan awn kusug niyu tumatas sin manga kabinsanaan dumatung iban bang mayan wayruun hikasipug niyu bang kamu tumindug na ha alupan ku, amu in Anak Mānusiyaꞌ.” ");
INSERT INTO tsg_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Manjari adlaw-adlaw duun hi Īsa nagnasīhat ha Bāy sin Tuhan, sagawaꞌ pagdūm madtu siya pa Būd Jaytun. Didtu siya humantiꞌ dūm-dūm. ");
INSERT INTO tsg_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Na, mahinaat-mahinaat subu-subu pa madtu in tau katān pa Bāy sin Tuhan dumungug sin pagnasīhat niya. ");
INSERT INTO tsg_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Manjari masuuk na in waktu sin Haylaya Paglappas Dayn ha Kamatay amu in waktu magkaun in bangsa Yahudi sin tinapay way pasulig. ");
INSERT INTO tsg_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","In manga nakuraꞌ kaimaman iban sin manga guru sin saraꞌ agama nagꞌisun bang biyaꞌ diin in kapatay nila kan Īsa ha diꞌ kaingatan sin manga tau, sabab mabugaꞌ sila maghiluhalaꞌ in manga tau. ");
INSERT INTO tsg_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sakali siyasat sin Saytan Puntukan hi Judas tau dayn ha Kiriyud amu in hambuuk sin manga hangpuꞌ tagduwa mulid hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Hangkan miyadtu siya dimā nagꞌisun ha manga nakuraꞌ kaimaman iban manga nakuraꞌ sin manga nagjajaga ha Bāy sin Tuhan bang biyaꞌ diin in katipu niya kan Īsa ha supaya niya siya hikaungsud pa lawm lima nila. ");
INSERT INTO tsg_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Na, kiyaamuhan tuud sila iban atasan nila tangdanan hi Judas. ");
INSERT INTO tsg_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Timaayun hi Judas sin kabayaan nila. Hangkan simipi na siya bang biyaꞌ diin in katipu niya kan Īsa, bat niya hikaungsud pa lawm lima sin manga tau mabayaꞌ sumaggaw kaniya. Limawag siya waktu makulang in manga tau (ha supaya wayruun hiluhalaꞌ). ");
INSERT INTO tsg_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Manjari naabut na in adlaw sin pakaradjaan pagkaun sin tinapay way pasulig niya amu in waktu sin pagsumbayꞌ sin anak bili-bili amu in panumtuman sin bangsa Yahudi sin waktu piyuas sin Tuhan dayn ha kasigpitan in kamaasan nila. ");
INSERT INTO tsg_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Sakali diyaak hi Īsa hi Pitrus kay Yahiya. Laung niya, “Kadtu kamu pagsaddiya sin kakaun hipagsaꞌbu taniyu sin Pagjamu Paglappas dayn ha Kamatay.” ");
INSERT INTO tsg_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Laung nila, “Hariin mu kabayaan sakapun namuꞌ in pagjamuhan taniyu?” ");
INSERT INTO tsg_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","In sambung niya, “Pagdatung niyu pa lawm sin dāira, bākun kamu sin hambuuk usug nagdarā kibut tagaluun tubig. Urul kamu kaniya pa bāy sūran niya. ");
INSERT INTO tsg_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ubus ampa niyu iyana in tagdapu sin bāy, laung niyu, ‘Nagpaasubu in Tuwan Guru bang hawnu in bilik pagjamuhan niya iban sin manga mulid niya hipagsaꞌbu sin Pagjamu Paglappas dayn ha Kamatay.’ ");
INSERT INTO tsg_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Na, hipakitaꞌ niya kaniyu in bilik dakulaꞌ ha taas sin bāy niya amu in asal panyap sin katān kagunahan natuꞌ. Duun niyu saddiyaha in pagjamuhan natuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Na, miyadtu na sila. Pagdatung nila pa dāira, in katān biyaytaꞌ hi Īsa naagad. Na, siyaddiya nila na in kakaun pagjamuhan nila. ");
INSERT INTO tsg_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Na, naabut mayan in waktu sin pagjamu, limingkud na hi Īsa nagjamu iban sin manga kiyawakilan niya. ");
INSERT INTO tsg_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Laung niya ha manga kiyawakilan niya, “Asal mabayaꞌ tuud aku magsāw magkaun iban kamu sin Pagjamu Paglappas dayn ha Kamatay ha diꞌ pa aku numanam kabinsanaan! ");
INSERT INTO tsg_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Sabab baytaan ta kamu amuna ini in kahinapusan sin pagsāw ku magkaun sin pagjamu ini iban kamu. Subay na maabut in waktu magmakbul na in hātihan sin pagjamu ini didtu ha pagparintahan sin Tuhan ampa kitaniyu makapagsāw magbalik magkaun sin pagjamu ini.” ");
INSERT INTO tsg_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Pagꞌubus ampa kiyawaꞌ hi Īsa in hambuuk sawan, ampa siya nagsarang-sukul pa Tuhan. Laung niya ha manga kiyawakilan niya, “Kawaa niyu in sawan ini ampa niyu inuma in luun niya. ");
INSERT INTO tsg_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Sabab, baytaan ta kamu, pagpuas dayn ha waktu ini diꞌ na aku minum magbalik sin tubig anggul ini ha salugay diꞌ dumatung in waktu, tumindug na tuud in pamarinta sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pagꞌubus kimawaꞌ na isab siya tinapay ampa siya nagsarang-sukul pa Tuhan. Ubus ampa niya sīpak in tinapay diyuhal pa manga kiyawakilan niya. Laung niya kanila, “Niyata niyu sin amu yan in ginhawa-baran ku amu in hilillaꞌ ku mapatay sabab-karnaꞌ niyu. Kaun kamu sin tinapay yan amu in gantiꞌ panumtuman niyu kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Damikkiyan, diyuhal niya da isab pa manga kiyawakilan niya in sawan pagꞌubus nila nagkaun. Laung niya, “In luun sin sawan ini tandaꞌ sin paljanjian baꞌgu sin Tuhan kaniyu. In duguꞌ ku maasag sabab-karnaꞌ niyu amu in dumihil katantuhan sin janjiꞌ ini. ");
INSERT INTO tsg_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Sagawaꞌ ingat kamu! In tau tumipu kākuꞌ yari bihaun miyamagad limilingkud kātuꞌniyu ha lamisahan! ");
INSERT INTO tsg_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Asal giyantaꞌ sin Tuhan in aku amu in Anak Mānusiyaꞌ manaykud da dayn ha dunya, sagawaꞌ murkaꞌ dakulaꞌ in kumugdan ha tau manipu kākuꞌ!” ");
INSERT INTO tsg_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Na, nagꞌasubu-iyasubuhi na in manga mulid niya bang hisiyu kanila in manipu kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Sakali naawn in paglugat sin manga mulid hi Īsa pasalan sin hisiyu dayn kanila in subay karihilan sin kawasa mataas. ");
INSERT INTO tsg_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Laung hi Īsa kanila, “In manga sultan sin bangsa dugaing dī ha dunya amu in magkawasa ha manga tau ha babaan nila iban in manga tau mataas in kawasa mabayaꞌ tuud mabantug sin sila in magdirihil sin kagunahan sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Sagawaꞌ in kamu subay bukun biyaꞌ kanila. Karnaꞌ in mataas dayn kaniyu subay magpatibabaꞌ sin baran niya biyaꞌ sin kamanghuran magpababaꞌ dayn ha kamagulangan. Iban in nakuraꞌ subay maghulas-sangsaꞌ biyaꞌ sin daraakun. ");
INSERT INTO tsg_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Bang ha bistahan sin manga tau in nakuraꞌ subay amu in lumingkud kumaun ha lamisahan, hāti in daraakun niya amu in magbutang kaniya sin kakaun niya. Sagawaꞌ bukun aku biyaꞌ ha yan. Yari aku maghulas-sangsaꞌ kaniyu biyaꞌ sin daraakun. ");
INSERT INTO tsg_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Na, pagga kamu imuunung kākuꞌ ha unu-unu kasigpitan ku, ");
INSERT INTO tsg_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","na, dihilan ta kamu sin kawasa magbayaꞌ ha lawm pamarintahan ku biyaꞌ sin kawasa kiyarihil kākuꞌ sin Tuhan, Amaꞌ ku. ");
INSERT INTO tsg_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Magsāw kitaniyu magkaun bang tumindug na in pamarinta ku. Iban hinangun ta kamu manga wakil ku, dihilan kalagguan iban kawasa magbayaꞌ ha hangpuꞌ tagduwa pihak sin bangsa Israil.” ");
INSERT INTO tsg_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Manjari nagbichara hi Īsa kan Simun Pitrus, laung niya, “Simun, dunguga in bichara ku! In Saytan Puntukan tiyugutan sin Tuhan sumulay sumasat kaniyu katān. Biyaꞌ yan sapantun magtahap pāy bat maīg in manga apa niya. ");
INSERT INTO tsg_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","In ikaw mutas dayn kākuꞌ, sagawaꞌ piyangayuan ta kaw duwaa pa Tuhan bang mayan diꞌ malawaꞌ in pangandul mu kākuꞌ. Na, bang magbalik na in pangandul mu kākuꞌ, subay mu tabangan in manga katawtaymanghuran mu magpahugut sin pangandul nila kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","In sambung hi Pitrus, “Panghuꞌ, lillaꞌ aku umunung kaymu majīl iban mapatay.” ");
INSERT INTO tsg_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Laung hi Īsa kaniya, “Ingat kaw, Pitrus, ha dūm ini ha diꞌ pa maabut tumagauk in manuk usug sin subu-subu, makatū kaw umiyan, laung mu diꞌ mu aku kaingatan.” ");
INSERT INTO tsg_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pagꞌubus iyasubu hi Īsa in manga mulid niya, “Ha waktu diyaak ta kamu magnasīhat madtu pa manga kadāirahan ha walaꞌ ta kamu piyapagdā sin manga pitakaꞌ, luluunan sin kapanyapan niyu, iban manga tawmpaꞌ niyu, awn ka nagkabus kaniyu?” “Walaꞌ kami nagkabus unu-unu,” in sambung nila. ");
INSERT INTO tsg_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Sagawaꞌ bihaun,” laung hi Īsa kanila, “hisiyu-siyu in taga pitakaꞌ atawa luluunan sin kapanyapan niyu subay niya dāhun na, iban hisiyu-siyu in way pakukus subay niya hipagdagang in badjuꞌ niya bat siya makabī hambuuk pakukus. ");
INSERT INTO tsg_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sabab ingat kamu, in kiyabaytaꞌ ha lawm Kitab pasal ku maagad na bihaun. Amu agi sin ha lawm Kitab, ‘Itungun siya biyaꞌ sin manga tau nagdusa nakalanggal sin saraꞌ.’ Na, in yan tantu mabunnal.” ");
INSERT INTO tsg_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Laung sin manga mulid niya, “Kitaa ba, Panghuꞌ, yari awn duwa pakukus!” “Ayaw na! Sarang na yan,” in sambung hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Na, pagꞌubus hi Īsa nagbichara gimuwaꞌ na siya dayn ha lawm sin dāira, ampa siya miyadtu pa Būd Jaytun biyaꞌ sin kabiyaksahan niya paghinangun. Miyagad in manga mulid niya kaniya. ");
INSERT INTO tsg_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pagdatung nila madtu, laung hi Īsa ha manga mulid niya, “Pangayuꞌ kamu duwaa bang mayan kamu diꞌ marā sin sasat sin saytan.” ");
INSERT INTO tsg_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Pagꞌubus limawak-lawak hi Īsa dayn ha manga mulid niya ampa siya limuhud nangayuꞌ duwaa pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Laung niya, “Ya Tuhan, Amaꞌ ku, bang makajari kaymu, ayaw mu na aku palabaya sin kabinsanaan masuuk na dumatung kākuꞌ! Sagawaꞌ in kabayaan mu, amu in subay maagad, bukun in kabayaan ku.” ");
INSERT INTO tsg_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Sakali awn malāikat dayn ha surgaꞌ nagpanyataꞌ mawn kaniya dimihil kaniya kusug. ");
INSERT INTO tsg_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sabab sin landuꞌ tuud in kasusahan niya piyakusug tuud hi Īsa in pagpangayuꞌ niya duwaa. Hangkan diyunuk tuud siya sin hulas nabiyaꞌ duguꞌ nagtūꞌ pa lupaꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pagꞌubus niya nangayuꞌ duwaa timindug siya ampa siya nagbalik madtu pa manga mulid niya. Pagkawn niya, in manga mulid niya nakatūg na sabab sin kasusahan nila. ");
INSERT INTO tsg_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Laung niya kanila, “Maytaꞌ kamu natutūg? Bangun kamu ampa kamu pangayuꞌ duwaa bat kamu diꞌ marā sin sasat sin saytan.” ");
INSERT INTO tsg_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ha saꞌbu nagbibichara pa hi Īsa, dimatung na mawn in manga tau mataud. Hi Judas, amu in hambuuk dayn ha hangpuꞌ tagduwa mulid hi Īsa, in nagdā ha manga tau mawn. Simuuk siya madtu kan Īsa sūng niya siyumun. ");
INSERT INTO tsg_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Sagawaꞌ laung hi Īsa kaniya, “Judas, biyaꞌ ka ha yan in kaagi mu manipu ha Anak Mānusiyaꞌ? Siyumun mu aku bat mu aku hikaungsud pa lawm lima sin manga tau managgaw kākuꞌ?” ");
INSERT INTO tsg_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pagkitaꞌ sin manga mulid hi Īsa sin bukun na marayaw in kasūngan, laung nila kan Īsa, “Na, Panghuꞌ, hipanglagut namuꞌ na in pakukus namuꞌ ini?” ");
INSERT INTO tsg_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na, magtūy liyagut sin hambuuk mulid niya in hambuuk daraakun sin Imam Dakulaꞌ. Nautud in taynga dapit pa tuu sin tau liyagut niya. ");
INSERT INTO tsg_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Sagawaꞌ liyāng hi Īsa in mulid niya, laung niya, “Sarang na yan.” Saltaꞌ kiyumpitan hi Īsa in taynga nautud ampa niya piyauliꞌ. ");
INSERT INTO tsg_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pagꞌubus ampa hi Īsa namung ha manga nakuraꞌ kaimaman iban sin manga nakuraꞌ sin manga jaga ha Bāy sin Tuhan iban sin manga nagtatau-maas ha hulaꞌ, amu in miyawn nanaggaw kaniya, laung niya, “Maytaꞌ kamu subay magdā manga pakukus iban kakakal? Maytaꞌ, mundu ka aku ini? ");
INSERT INTO tsg_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Duun sa aku ha Bāy sin Tuhan adlaw-adlaw iban duun da isab kamu, sagawaꞌ maytaꞌ niyu aku walaꞌ siyaggaw? Na, tantu amu ini in waktu kiyagantaꞌ in aku masaggaw niyu, amu in waktu makusug in kawasa sin Saytan Puntukan.” ");
INSERT INTO tsg_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Na, siyaggaw nila na hi Īsa ampa nila diyā madtu pa bāy sin Imam Dakulaꞌ. Sakali in hi Pitrus imuurul dayn ha kalayuan. ");
INSERT INTO tsg_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pagdatung niya pa halaman bāy sin Imam Dakulaꞌ, limamugay siya ha manga tau naglilingkud nagpaanag ha kāyu duun ha gitungan sin halaman bāy sabab awn kāyu duun biyuhiꞌ sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sakali ha saꞌbu niya naglilingkud duun kītaꞌ siya sin hambuuk daraakun babai. Imatud tuud kaniya in babai ampa imiyan, laung niya, “In tau ini panaiban da isab hi Īsa!” ");
INSERT INTO tsg_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Sagawaꞌ imiyan hi Pitrus, laung niya, “Indaꞌ, diꞌ ku kaingatan in tau piyagꞌiyan mu yan!” ");
INSERT INTO tsg_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Na, bukun mawgay awn na isab hambuuk tau nākitaꞌ kan Pitrus. Amu agi kaniya, “In ikaw yan agad da isab kanila!” Sagawaꞌ in sambung hi Pitrus, “Bagay, bukun aku agad kanila!” ");
INSERT INTO tsg_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Sakali nakalabay mayan manga hangka-jām, awn na isab hambuuk tau in limugus imiyan kan Pitrus. Laung niya, “Tantu tuud in tau ini agad kan Īsa, sabab tau Jalil da isab siya!” ");
INSERT INTO tsg_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Sagawaꞌ in sambung hi Pitrus, “Bagay, diꞌ ku kaingatan bang unu in piyagbibichara mu yan!” Na, saruun-duun ha saꞌbu niya pa nagbibichara, timagauk na in manuk usug. ");
INSERT INTO tsg_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Sakali limingiꞌ hi Panghuꞌ Īsa ampa niya iyatud hi Pitrus. Na, iyampa kiyatumtuman hi Pitrus in baytaꞌ kaniya hi Panghuꞌ Īsa amu agi, “Ha diꞌ pa tumagauk in manuk usug dūm ini, makatū kaw umiyan, sin in aku diꞌ mu kaingatan.” ");
INSERT INTO tsg_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Na, gimuwaꞌ na hi Pitrus dayn ha halaman sin bāy ampa siya nagtangis tuud. ");
INSERT INTO tsg_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na, piyaglikiꞌ-likian iban piyagbinasa hi Īsa kaagi sin manga tau nagjajaga kaniya. ");
INSERT INTO tsg_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tiyabunan nila in mata hi Īsa ampa nila siyuntuk. Pagꞌubus ampa nila iyasubu hi Īsa, laung nila, “Tukura bang hisiyu in simuntuk kaymu!” ");
INSERT INTO tsg_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Iban mataud pa manga bichara mangīꞌ iban makasipug in piyamung nila kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Sakali naadlaw mayan nagtipun na in manga nagtatau-maas ha hulaꞌ iban sin manga nakuraꞌ kaimaman iban sin manga guru sin saraꞌ agama. In sila ini manga kunsiyal manghuhukum. Na, narā na hi Īsa mawn imalup kanila. ");
INSERT INTO tsg_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Laung nila kan Īsa, “Baytai kami, bang ikaw na in Almasi.” In sambung hi Īsa, “Bang ta kamu baytaan, diꞌ da kamu magkahagad kākuꞌ ");
INSERT INTO tsg_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","iban bang awn asubuhun ku kaniyu diꞌ da kamu makasambung. ");
INSERT INTO tsg_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Sagawaꞌ tagnaan dayn ha bihaun in aku amu in Anak Mānusiyaꞌ lumingkud na dapit pa tuu sin Tuhan Mahatinggi dihilan kawasa magbayaꞌ ha unu-unu katān.” ");
INSERT INTO tsg_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Laung sin manga kunsiyal Yahudi, “Bang biyaꞌ hādtu ikaw in Anak Tuhan?” In sambung niya kanila, “Na, biyaꞌ na sin agi niyu, aku na.” ");
INSERT INTO tsg_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Na, laung nila, “Na, magꞌunu pa kitaniyu magkāꞌ saksiꞌ sin diyungug na sin kitaniyu katān in bichara niya!” ");
INSERT INTO tsg_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Na, timindug in tau katān ha paghuhukuman, ampa nila diyā hi Īsa madtu kan Gubnul Pilatu. ");
INSERT INTO tsg_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Duun nila biyaytaꞌ in manga tuntut nila kan Īsa. Laung nila, “Siya ini in tau nasaggaw namuꞌ mangdā pa kalawngan ha manga tau pagkahi namuꞌ Yahudi. Biyaytaan niya in manga tau diꞌ papagbayarun sukay pa parinta sin Sultan sin hulaꞌ Rūm. Iban laung niya ha manga tau siya na in Almasi amu in naraak sin Tuhan magsultan kāmuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Laung hi Pilatu kan Īsa, “Ikaw na ka in sultan sin manga Yahudi?” “Na, biyaꞌ na sin kiyapamung mu,” in sambung hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Na, laung hi Pilatu ha manga nakuraꞌ kaimaman iban ha manga tau mataud, “Wayruun dusa kiyabaakan ku ha tau ini, amu in mapatut ku butangan hukuman.” ");
INSERT INTO tsg_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Sagawaꞌ limugus tuud sila sin awn narusa hi Īsa. Laung nila, “In pagnasīhat niya amu in nakarihil hiluhalaꞌ ha tau katān ha katilibut sin Yahudiya. Tiyagnaan niya nagnasīhat didtu ha Jalil. Na, bihaun yan na siya nakaabut pa Awrusalam (Baytal Makdis).” ");
INSERT INTO tsg_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pagdungug hi Pilatu sin bichara nila, nangasubu siya, laung niya, “Tau Jalil ka in tau ini?” ");
INSERT INTO tsg_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na, pagꞌingat hi Pilatu sin in hi Īsa tau dayn ha hulaꞌ piyagparintahan hi Hirud, piyarā niya hi Īsa madtu kan Hirud. Karnaꞌ ha waktu yaun kiyasaꞌbuhan duun hi Hirud ha Awrusalam (Baytal Makdis). ");
INSERT INTO tsg_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Na, kiyūgan hi Hirud pagkitaꞌ niya kan Īsa, sabab malugay na in bayaꞌ niya kumitaꞌ kan Īsa. Mataud in diyungug niya pasal hi Īsa iban hiyuhunaꞌ-hunaꞌ niya makakitaꞌ siya kan Īsa huminang muꞌjijat. ");
INSERT INTO tsg_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hangkan mataud in iyasubu hi Hirud kan Īsa, sagawaꞌ walaꞌ tuud simambung hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Na, miyawn pa unahan in manga nakuraꞌ kaimaman iban manga guru sin saraꞌ agama ampa sila namahit namaytaꞌ sin manga nahinang hi Īsa, amu in tuntut nila kaniya. ");
INSERT INTO tsg_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hāti piyaglami-lamihan hi Hirud iban sin manga sundalu niya hi Īsa iban piyagꞌudjuꞌ-udjuꞌ nila siya. Jiyubahan nila hi Īsa sin juba malingkat ampa nila piyabalik madtu kan Pilatu. ");
INSERT INTO tsg_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na, tagnaan dayn ha adlaw yadtu nakapagbagay na hi Hirud kay Pilatu. In tagnaꞌ magkuntara tuud sila. ");
INSERT INTO tsg_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Sakali piyakawaꞌ hi Pilatu in manga nakuraꞌ kaimaman, in manga nakuraꞌ iban sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Laung niya kanila, “Diyā niyu mari kākuꞌ in tau ini sabab laung niyu mangdā siya ha manga tau sumaggaꞌ ha parinta. Na, siyumariya ku na siya ha alupan niyu sagawaꞌ wayruun dusa niya unu-unu kiyabaakan ku. Walaꞌ siya kiyamattanan sin manga tuntut niyu kaniya. ");
INSERT INTO tsg_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Damikkiyan, in hi Hirud, wayruun da isab kiyabaakan niya dusa sin tau ini. Hangkan piyarā niya nagbalik mari kāmuꞌ. Bukun tuud patut patayun in tau ini sabab wayruun tuud unu-unu mangīꞌ nahinang niya. ");
INSERT INTO tsg_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Hangkan palapdusan ku sadja siya ampa ku siya puasun.” ");
INSERT INTO tsg_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ha sakabaꞌ waktu sin Pagjamu Paglappas dayn ha Kamatay, biyaꞌ sin pagkabiyaksahan paghinangun sin gubnul, subay siya magpaguwaꞌ hambuuk pilisu. ");
INSERT INTO tsg_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Sakali imulang in manga tau mataud, laung nila, “Papatayan hi Īsa! Papaguwaa kāmuꞌ hi Barabbas!” ");
INSERT INTO tsg_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(In hi Barabbas najīl sabab lamud siya ha manga tau ha lawm dāira Awrusalam (Baytal Makdis) nangatu ha parinta iban nakabunuꞌ siya.) ");
INSERT INTO tsg_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","In kabayaan hi Pilatu puasun niya hi Īsa, hangkan bīcharahan niya nagbalik in manga tau. ");
INSERT INTO tsg_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Sagawaꞌ imulang nagbalik in manga tau, laung nila, “Palansangan siya pa usuk! Palansangan siya pa usuk!” ");
INSERT INTO tsg_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Sakali imiyan na isab nagbalik hi Pilatu kanila, laung niya, “Maytaꞌ, unu in dusa nahinang niya? Wayruun dusa niya kiyabaakan ku, hangkan bukun siya patut patayun. Palapdusan ku sadja siya ampa ku siya puasun.” Amu yan in hikatū niya piyamung ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Sagawaꞌ masi-masi in pagꞌulang matanug sin manga tau sin in hi Īsa subay hipalansang pa usuk. Na, mahuli dayn duun naagad da in kabayaan sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Hangkan biyutangan na hi Pilatu hukuman hi Īsa, amu in hukuman kabayaan sin manga tau hibutang kaniya. ");
INSERT INTO tsg_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Piyaguwaꞌ niya in tau, amu in najīl pasal lamud siya ha manga tau nanghiluhalaꞌ ha parinta iban nakabunuꞌ siya, sabab siya in kabayaan sin manga tau paguwaun. Ampa in hi Īsa tiyukbal niya na pa lawm lima sin manga tau bat nila mahinang in kabayaan nila. ");
INSERT INTO tsg_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Na, diyā hi Īsa sin manga sundalu tudju pa lugal pagpatayan kaniya. Ha saꞌbu nila miyamanaw piyagbāk nila in hambuuk tau dayn ha hulaꞌ Kirini pagngānan Simun. In tau ini lūd dayn ha gimba harap mawn pa dāira. Na, liyugus sin manga sundalu in tau ini umurul kan Īsa magdā sin usuk paglansangan kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mataud tau in imurul ha ulihan hi Īsa. In kaibanan kanila manga babai amu in nagtatangis iban nagdurukka kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Sakali himarap hi Īsa kanila ampa imiyan, laung niya, “Kamu manga babai dayn ha Awrusalam (Baytal Makdis), ayaw niyu aku pagtangisi! Sagawaꞌ in pagtangisi niyu in baran niyu iban sin manga anak niyu. ");
INSERT INTO tsg_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Karnaꞌ awn da waktu dumatung ha susūngun kugdanan kasigpitan dakulaꞌ in lawm dunya ini iban makaiyan in manga tau, laung nila, ‘Marayaw sukud sin manga babai diꞌ makaanak, iban sin manga babai way anak iban manga babai walaꞌ nakapaduruꞌ bataꞌ-bataꞌ!’ ");
INSERT INTO tsg_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Amu yan in waktu magsuknaꞌ in manga tau sin baran nila. Laung nila ha manga būd, ‘Bang mayan kamu malubu harap mari kāmuꞌ!’ Hāti laung nila ha manga būd-būd, ‘Bang mayan kami tabunan niyu!’ ");
INSERT INTO tsg_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Karnaꞌ bang nila mahinang in manga kabinsanaan ini ha tau amu in walaꞌ nakarusa, na amu pa ka isab in manga nakarusa in diꞌ nila binsanaun?” ");
INSERT INTO tsg_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Sakali awn isab duwa tau nakarusa bakas nakalanggal saraꞌ in diyā nila patayun hidungan kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nakaabut mayan sila pa tungud sin lugal pagngānan Kulakub Ū, duun nila liyansang pa usuk hi Īsa ampa nila piyatindug in usuk. Damikkiyan, liyansang nila da isab pa usuk in duwa tau nakalanggal saraꞌ ampa piyatindug in hambuuk usuk ha dapit pa tuu hi Īsa ampa in hambuuk ha dapit pa lawa niya. ");
INSERT INTO tsg_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Na, piyangayuan hi Īsa kaampunan pa Tuhan in manga tau nanglaug kaniya. Laung niya, “Ya Amaꞌ, Tuhan, ampuna sila, sabab diꞌ nila kaingatan bang unu in hīhinang nila.” Na, piyagbahagian nila in tamungun hi Īsa. Piyagkuut-kuutan nila bang unu in masukuꞌ sin pakaniya-pakaniya. ");
INSERT INTO tsg_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Duun in manga tau nangingitaꞌ-ngitaꞌ ha saꞌbu piyaglami-lamihan iyuudjuꞌ-udjuꞌ hi Īsa sin manga nakuraꞌ sin manga Yahudi. Laung nila, “Natabang niya in tau dugaing dayn ha kamulahan. Na, kitaun ta kunuꞌ bang niya matabang in baran niya bang siya bunnal amu na in Almasi amu in pinīꞌ sin Tuhan mamarinta!” ");
INSERT INTO tsg_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Damikkiyan in manga sundalu, iyudjuꞌ-udjuꞌ nila da isab. Simuuk sila madtu kan Īsa ampa nila diyuhalan hi Īsa sin tubig anggul (biyaꞌ tubaꞌ). In hinang nila yan hambuuk pamabaꞌ-mabaꞌ nila kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ampa nila īyan hi Īsa, laung nila, “Bang kaw bunnal sultan sin manga Yahudi, lappasa na in baran mu!” ");
INSERT INTO tsg_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Awn sulat biyutang duun ha babaw sin ū hi Īsa, amu agi, “Amu na ini in Sultan sin manga Yahudi.” ");
INSERT INTO tsg_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Damikkiyan in hambuuk tau nakalanggal saraꞌ amu in liyalansang da isab ha usuk, nangjūk kan Īsa, laung niya, “Bukun ka ikaw in Almasi? Na, lappasa na in baran mu iban kami!” ");
INSERT INTO tsg_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Sakali piyagꞌamahan siya sin iban niya, amu agi, “Diꞌ ka kaw mabugaꞌ ha Tuhan? In hukuman biyutang kaniya sibuꞌ da iban sin hukuman biyutang kaymu. ");
INSERT INTO tsg_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Sagawaꞌ in kita patut butangan sin hukuman sabab sin dusa nahinang ta. Sagawaꞌ in siya walaꞌ nakarusa.” ");
INSERT INTO tsg_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ubus ampa siya imiyan kan Īsa, laung niya, “Īsa, tumtuma mayan aku bang kaw mamarinta na!” ");
INSERT INTO tsg_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","In sambung hi Īsa kaniya, “Ini in janjiꞌ ku kaymu. Ha adlaw da ini, didtu kaw magꞌagad iban aku ha uwian sin manga tau marayaw.” ");
INSERT INTO tsg_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Manjari naabut mayan ugtu suga nanigidlum na in katilibut sin hulaꞌ sampay naabut lisag tū sabab nalawaꞌ in sawa sin suga. ");
INSERT INTO tsg_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Na, in kurtina marakmul didtu ha lawm Bāy sin Tuhan nagisiꞌ nagduwa. ");
INSERT INTO tsg_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Sakali nagsuwara matanug hi Īsa, laung niya, “Ya Amaꞌ Tuhan, hiungsud ku pa lawm lima mu in nyawa ku!” Pagꞌubus niya na mayan nagbichara miyugtuꞌ na in napas niya. ");
INSERT INTO tsg_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","In katān naawn yan kītaꞌ sin hambuuk kapitan sin manga sundalu. Nahaylan siya sin manga kītaꞌ niya sartaꞌ piyudji niya in Tuhan, laung niya, “Mattan na tuud sin in tau ini wayruun tuud dusa niya!” ");
INSERT INTO tsg_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Damikkiyan in manga tau nagtipun nangitaꞌ-ngitaꞌ duun kan Īsa, nākitaꞌ da isab sin manga katān naawn. Minuwiꞌ sila katān iban pagdukduk sin daghal nila tandaꞌ sin pagkarukkahan nila. ");
INSERT INTO tsg_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Na, in sasukuꞌ sin katān bagay hi Īsa agad na in manga babai amu in imurul kaniya dayn ha Jalil, duun timitindug nagjajaga dayn ha kalayuan. ");
INSERT INTO tsg_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Sakali awn hambuuk tau pagngānan hi Yusup dayn ha Arimati, amu in hambuuk kawman ha Yahudiya. Tau marayaw siya iban mabuntul. In siya ini timatagad sin waktu tumindug in pamarinta sin Tuhan. Minsan siya hambuuk da isab kunsiyal, walaꞌ siya timaayun sin kiyapagꞌisunan iban sin hinang sin manga kunsiyal. ");
INSERT INTO tsg_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Miyadtu siya dimā nagkitaꞌ kan Pilatu ampa niya piyangayuꞌ in bangkay hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pagꞌubus ampa niya kiyawaꞌ in bangkay dayn ha usuk. Siyaput niya in bangkay sin kuku putiꞌ marayaw, ampa niya diyā madtu biyutang pa lawm kubul amu in batu dakulaꞌ liyungagan hīnang biyaꞌ lupa sungab batu. In kubul ini walaꞌ pa kiyapangubulan. ");
INSERT INTO tsg_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na, in adlaw yadtu adlaw Jumaat. Simadlup mayan in suga, na, timagnaꞌ na in adlaw paghali-hali iban pagpudji pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Na, in manga babai amu in bakas imurul kan Īsa dayn ha Jalil miyagad kan Yusup madtu pa pagkubulan. Kītaꞌ nila in pagbutang sin bangkay hi Īsa pa lawm kubul. ");
INSERT INTO tsg_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pagꞌubus ampa sila minuwiꞌ nagꞌadjal sin manga laksiꞌ iban hipagpahamut ha mayat. Pagꞌabut adlaw Sabtuꞌ himali sila dayn ha hinang nila, sabab amu yan in daakan sin saraꞌ agama. ");
INSERT INTO tsg_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Manjari pagbulat mahinaat sin adlaw Ahad, subu-subu pa miyadtu na in manga babai pa kubul nagdā sin manga laksiꞌ iyadjal nila. ");
INSERT INTO tsg_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pagdatung nila, kītaꞌ nila naīg na in batu tambul sin sūran pa lawm kubul. Nagulung na naīg dayn ha sūran pa lawm kubul. ");
INSERT INTO tsg_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Na, simūd sila pa lawm kubul, sagawaꞌ walaꞌ na duun in bangkay hi Panghuꞌ Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Duun na sila timindug kiyublaan tuud. Sakali magtūy awn nagpanyataꞌ mawn kanila duwa usug timindug ha alupan nila. Masilak tuud in tamungun sin duwa tau ini. ");
INSERT INTO tsg_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Miyugaꞌ tuud in manga babai, hangkan simujud sila pa lupaꞌ. Sagawaꞌ laung sin duwa tau kanila, “Maytaꞌ kamu maglāg ha tau buhiꞌ dī ha lawm paliyangan? ");
INSERT INTO tsg_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Walaꞌ siya dī sabab nabuhiꞌ na siya nagbalik. Tumtuma niyu in agi niya kaniyu sin didtu pa siya ha Jalil. ");
INSERT INTO tsg_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Amu agi niya kaniyu, ‘In aku amu in Anak Mānusiyaꞌ subay hiungsud pa lawm lima sin manga tau baldusa iban patayun nila hilansang pa usuk. Sagawaꞌ mabuhiꞌ aku magbalik ha hikatū sin adlaw.’” ");
INSERT INTO tsg_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Na, kiyatumtuman na sin manga babai in bakas bichara hi Īsa kanila. ");
INSERT INTO tsg_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Minuwiꞌ na sila dayn ha kubul ampa sila miyadtu namaytaꞌ sin manga pasal ini pa hangpuꞌ tagꞌisa mulid hi Īsa iban pa manga tau katān kaibanan. ");
INSERT INTO tsg_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","In manga babai ini amuna hinda Mariyam dayn ha hulaꞌ Magdala, hi Juwanna, iban hi Mariyam amu in inaꞌ hi Yaꞌkub. Sila ini iban sin manga kaibanan babai in namaytaꞌ sin manga pasal yan ha manga kiyawakilan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Sagawaꞌ in pangannal sin manga kiyawakilan, nagbichara sadja way biddaꞌ in manga babai. Hangkan walaꞌ sila nagkahagad. ");
INSERT INTO tsg_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Sagawaꞌ dimagan hi Pitrus madtu pa kubul kimitaꞌ. Pagdatung niya, dimumul siya pa lawm kubul, sagawaꞌ wayruun dugaing kītaꞌ niya luwal da in saput. Na, minuwiꞌ na siya ha lawm inu-inu bang maytaꞌ nabiyaꞌ hādtu. ");
INSERT INTO tsg_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sakali ha adlaw yadtu da isab awn duwa usug agad kan Īsa in miyamanaw harap pa lūngan Immaws, manga hangpuꞌ tagꞌisa batu in layuꞌ dayn ha Awrusalam (Baytal Makdis). ");
INSERT INTO tsg_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nagbibichara sila pasal sin manga katān naawn kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ha saꞌbu nila nagbibichara, magtūy hi Īsa miyawn miyunyug kanila. ");
INSERT INTO tsg_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kītaꞌ nila siya, sagawaꞌ walaꞌ nila siya kiyakilāhan. ");
INSERT INTO tsg_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Laung hi Īsa kanila, “Unu in piyagbibicharahan niyu ha saꞌbu niyu nagpapanaw?” Himundung sila sartaꞌ nasusa in dagbus nila. ");
INSERT INTO tsg_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Sakali simambung in hangka-tau pagngānan Kilupas. Laung niya, “Uy, marayꞌ ikaw da yan in tau himantiꞌ ha Awrusalam (Baytal Makdis) in walaꞌ nakaingat sin pasal sin manga pakaradjaan naawn duun ha Awrusalam (Baytal Makdis) ha pila adlaw limabay yan.” ");
INSERT INTO tsg_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Manga pakaradjaan pasal unu?” laung hi Īsa. “Manga pakaradjaan naawn kan Īsa, amu in tau dayn ha Nasarit,” in sambung nila. “In tau yadtu hambuuk nabi. Ītung siya sin Tuhan iban sin tau katān sin makawasa siya ha katān bīchara iban hīnang niya. ");
INSERT INTO tsg_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Sagawaꞌ iyungsud siya sin manga nakuraꞌ kaimaman iban sin manga nakuraꞌ natuꞌ pa lawm lima sin parinta sin hulaꞌ Rūm, ha supaya siya kabutangan sin hukuman patayun. Pagꞌubus ampa nila siya piyalansang pa usuk. ");
INSERT INTO tsg_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Siya in bakas hiyuhuwat-huwat namuꞌ makapuas makarihil kalappasan ha bangsa Israil. Iban bukun sadja yan. Adlaw ini amuna in hikatū sin adlaw dayn ha kamatay kaniya. ");
INSERT INTO tsg_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Iban awn suysuy kāmuꞌ sin manga kaibanan babai panāiban namuꞌ amu in nakainu-inu kāmuꞌ. Miyadtu sila pa kubul hi Īsa sin subu-subu pa, ");
INSERT INTO tsg_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","sagawaꞌ laung nila walaꞌ na didtu in bangkay hi Īsa. Minuwiꞌ sila ampa nanuysuy sin awn manga malāikat nagpanyataꞌ kanila, iban namaytaꞌ kanila sin buhiꞌ hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","In kaibanan manga panāiban namuꞌ miyadtu pa kubul nyimataꞌ. Na, pagkitaꞌ nila bunnal tuud in suysuy sin manga babai, sagawaꞌ walaꞌ nila da isab kītaꞌ hi Īsa.” ");
INSERT INTO tsg_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Sakali laung hi Īsa kanila, “Dupang tuud kamu ini! Kahunitan tuud kamu magparachaya sin manga katān kiyabaytaꞌ sin manga kanabihan! ");
INSERT INTO tsg_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bukun ka kiyabaytaꞌ sin manga kanabihan sin subay lumabay in Almasi sin katān kabinsanaan yan ampa makapalawm lima niya in salagguꞌ-lagguꞌ kawasa magbayaꞌ ha unu-unu katān?” ");
INSERT INTO tsg_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Pagꞌubus ampa piyapagsunud-sunud iban piyahāti hi Īsa kanila in kiyasulat ha manga lawm Kitab pasal niya. Tiyagnaan niya dayn ha manga Kitab kiyasulat hi Musa iban sin manga kiyasulat sin manga katān kanabihan. ");
INSERT INTO tsg_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pagga sin masuuk na sila pa lūngan kadtuun sin duwangka-tau, in hi Īsa biyaꞌ lupa lumanjal harap pa dugaing. ");
INSERT INTO tsg_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Sagawaꞌ hiyawiran siya sin duwangka-tau, laung nila, “Dī na kaw kāmuꞌ sabab masuuk na marūm.” Hangkan miyagad na siya ha duwangka-tau. ");
INSERT INTO tsg_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Manjari limingkud na siya simāw nagkaun kanila. Kimawaꞌ siya tinapay ampa siya nangayuꞌ duwaa. Pagꞌubus ampa niya sīpak in tinapay diyuhal pa duwangka-tau. ");
INSERT INTO tsg_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Na, saruun-duun biyaꞌ sin sapantun iyampa nabulat in mata nila kiyakilāhan nila na hi Īsa. Sagawaꞌ magtūy nalawaꞌ hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Sakali laung sin hangka-tau pa hangka-tau, “Hangkan da kimusug in kuba-kuba sin atay ta sin saꞌbu ta nagbibichara iban siya ha dān, iban sin piyahāti niya kita sin kiyasulat ha manga lawm Kitab pasal niya.” ");
INSERT INTO tsg_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Na, magtūy sila timindug ampa sila nagbalik pa Awrusalam (Baytal Makdis). Duun nila kiyabaakan in hangpuꞌ tagꞌisa mulid hi Īsa nagtitipun nagbichara iban sin manga kaibanan. ");
INSERT INTO tsg_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Laung nila, “Mattan tuud sin nabuhiꞌ nagbalik in Panghuꞌ! Nagpanyataꞌ siya kan Simun!” ");
INSERT INTO tsg_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Na, nanuysuy na in duwangka-tau kanila pasal sin naawn ha dān ha saꞌbu nila nagpapanaw iban sin kiyakilāhan nila in Panghuꞌ nagsipak mayan siya sin tinapay. ");
INSERT INTO tsg_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sakali ha saꞌbu nanunuysuy in duwangka-tau kanila, saruun-duun yaun na timitindug ha daig nila in Panghuꞌ iban amu agi kanila, “Bang mayan awn kasannyangan sin lawm atay niyu.” ");
INSERT INTO tsg_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Na, miyugaꞌ tuud sila sabab in pangannal nila aluwa in kītaꞌ nila. ");
INSERT INTO tsg_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Sagawaꞌ laung niya kanila, “Maytaꞌ kamu miyugaꞌ? Maytaꞌ na mayan maghawal-hawal in lawm pikilan niyu? ");
INSERT INTO tsg_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kitaa niyu in paliꞌ ha lima iban siki ku, ampa niyu kaingatan sin baran ku tuud in kīkitaꞌ niyu. Sānawa niyu in baran ku bat niyu matantu sin bukun aluwa in kīkitaꞌ niyu, sabab in aluwa wayruun unud iban bukug, ampa in aku ini kīkitaꞌ niyu awn unud iban bukug.” ");
INSERT INTO tsg_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Amu yan in piyamung niya sartaꞌ piyakitaꞌ niya kanila in paliꞌ ha lima iban siki niya. ");
INSERT INTO tsg_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Sagawaꞌ in manga mulid niya agun diꞌ pa makaparachaya. Landuꞌ tuud sila kiyūgan iban ha lawm inu-inu. Hangkan iyasubu sila hi Īsa, laung niya, “Awn ka makaun dī kaniyu?” ");
INSERT INTO tsg_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Na, dīhilan nila siya hangsulag istaꞌ diyangdang. ");
INSERT INTO tsg_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Na, kiyawaꞌ hi Īsa in istaꞌ ampa niya kiyaun duun ha alupan nila. ");
INSERT INTO tsg_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pagꞌubus laung niya kanila, “Amu na ini in manga pakaradjaan biyaytaꞌ ku kaniyu sin dī pa aku nagꞌaagad iban kamu. In katān kiyabaytaꞌ pasal ku ha lawm Kitab Tawrat, amu in kiyasulat hi Musa, iban sin manga kiyasulat sin manga kanabihan iban sin ha Kitab Jabur, subay maagad katān.” ");
INSERT INTO tsg_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Pagꞌubus ampa niya dīhilan kasawahan in pikilan sin manga mulid niya ha supaya nila kahātihan marayaw in baytaꞌ ha lawm manga Kitab. ");
INSERT INTO tsg_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Laung niya kanila, “Amu ini in kiyabaytaꞌ ha lawm Kitab: in Almasi subay lumabay kabinsanaan iban mapatay, sagawaꞌ ha hikatū sin adlaw dayn ha kamatay kaniya, mabuhiꞌ siya magbalik. ");
INSERT INTO tsg_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Iban subay hipamahalayak pa mānusiyaꞌ katān in pasal sin pagtawbat sin manga dusa, karnaꞌ naawn na in kaampunan dayn ha sabab sin nahinang sin Almasi. Iban in pagpamahalayak ini subay tagnaan dayn ha Awrusalam (Baytal Makdis). ");
INSERT INTO tsg_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kamu yan in nakakitaꞌ iban nakasaksiꞌ sin katān pakaradjaan naawn pasal ku. ");
INSERT INTO tsg_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na, pakariun ku kaniyu in Rū sin Tuhan, amu in kiyajanjiꞌ sin Tuhan Amaꞌ ku. Sagawaꞌ subay kamu tumagad dī ha dāira Awrusalam (Baytal Makdis) sampay maabut in waktu hūpun na kamu sin barakat dayn ha Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pagꞌubus ampa niya sila diyā miyanaw pa guwaꞌ sin dāira sampay sila nakaabut pa Bitani. Duun mayan sila, sīntak hi Īsa in lima niya, ampa niya sila piyangayuan barakat. ");
INSERT INTO tsg_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ha saꞌbu sila piyapangayuan niya barakat, miyutas na siya dayn kanila. Naangkat na siya pa taas langit. ");
INSERT INTO tsg_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Na, simujud na sila simumba kan Īsa ampa sila minuwiꞌ pa Awrusalam (Baytal Makdis) iban sin atay nila hipuꞌ sin kakuyagan. ");
INSERT INTO tsg_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Lāgiꞌ, taptap na sila duun ha Bāy sin Tuhan magpudji ha Tuhan.");
INSERT INTO tsg_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Asal ha tagnaan, yaun na in Parman, iban in Parman asal naghahambuuk iban Tuhan, karnaꞌ in Parman amu na in Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Iban asal dayn ha panagnaan pa, naghahambuuk na in Parman iban Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","In unu-unu katān naawn, piyaawn sin Parman dayn ha kabayaan sin Tuhan. Wayruun hangsulag unu-unu in naawn bang bukun guwaꞌ dayn ha Parman. ");
INSERT INTO tsg_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Damikkiyan in Parman amuna in puunan sin kabuhiꞌ sabunnal, iban in puunan sin kabuhiꞌ sabunnal amuna in ilaw dumihil sawa pa pikilan sin mānusiyaꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","In ilaw ini sumiꞌnag na ha lawm sin katigidluman ha lawm dunya, iban in katigidluman diꞌ makapūng sin ilaw ini. ");
INSERT INTO tsg_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Manjari awn hambuuk tau kiyawakilan sin Tuhan. In ngān niya hi Yahiya. ");
INSERT INTO tsg_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Diyaak siya sin Tuhan mamaytaꞌ pa manga tau pasal sin ilaw ini, ha supaya in mānusiyaꞌ katān makarungug iban magparachaya sin baytaꞌ pasal sin ilaw. ");
INSERT INTO tsg_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Bukun hi Yahiya in piyagbahasa ilaw. Karnaꞌ in siya naraak sadja mamaytaꞌ pasal sin ilaw. ");
INSERT INTO tsg_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Na, in Parman amuna tuud in bunnal ilaw, amu in limahil mari pa dunya dumihil kasawahan pa pikilan sin mānusiyaꞌ katān. ");
INSERT INTO tsg_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Sagawaꞌ sin dī siya ha dunya walaꞌ siya kīla sin manga mānusiyaꞌ, minsan da siya in nagpapanjari sin unu-unu katān dayn ha kabayaan sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Miyari siya pa hulaꞌ napīꞌ niya hulaan, sagawaꞌ minsan in manga pagkahi niya hangka-bangsa, walaꞌ da timaymaꞌ kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Sagawaꞌ hisiyu-siyu in timaymaꞌ ha amu in piyagbahasa Parman iban nagparachaya isab kaniya, dīhilan niya sila kapatutan mahinang manga anak sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ampa in kahinang kanila anak sin Tuhan bukun biyaꞌ kaagi sin pagꞌanak sin tau dī ha dunya, amu in guwaꞌ dayn ha kabayaan atawa gantaꞌ sin mānusiyaꞌ. Sagawaꞌ mahinang sila manga anak sin Tuhan dayn ha kabayaan sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Manjari in piyagbahasa Parman nagbaran mānusiyaꞌ, limahil mari pa dunya iban himangka-hulaꞌ kātuꞌniyu. Jukup in kasi-lasa niya iban siya in magpakitaꞌ sin katān kasabunnalan. Kītaꞌ namuꞌ in sahaya iban kawasa niya amu in sahaya iban kawasa matūp tuud ha hambuuk-buuk Anak Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Hi Yahiya in namaytaꞌ pasal sin amu in piyagbahasa Parman. Namichara siya matanug, laung niya, “Siya na ini in bakas piyagꞌiyan ku kaniyu. Laung ku, ‘Siya in sumunud kākuꞌ, sagawaꞌ labi in kawasa niya dayn kākuꞌ, sabab in siya asal awn na ha walaꞌ pa aku natau.’” (Amu yan in baytaꞌ hi Yahiya.) ");
INSERT INTO tsg_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Pagga jukup in kasi-lasa niya, in kitaniyu katān awn kahampitan. Magdurugang in tulung-tabang niya kātuꞌniyu amu in iꞌhilas tuud sin atay niya. ");
INSERT INTO tsg_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Hi Musa in nagpasampay pa manga mānusiyaꞌ sin saraꞌ piyanaug sin Tuhan, sagawaꞌ hi Īsa Almasi, amu in piyagbahasa Parman in nagpasampay pa manga mānusiyaꞌ sin kasi-lasa iban sin kasabunnalan sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wayruun mānusiyaꞌ in nakakitaꞌ ha Tuhan, luwal da amu in hambuuk-buuk Anak niya, karnaꞌ in siya asal amuna tuud in Tuhan. Siya in nagpaingat ha manga mānusiyaꞌ pasal sin Tuhan Amaꞌ niya, sabab in sila asal hambuuk da. ");
INSERT INTO tsg_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Manjari biyaꞌ ha ini in baytaꞌ hi Yahiya pasal sin Almasi. Awn hambuuk waktu diyaak sin manga Yahudi, amu in nagkakaput saraꞌ agama ha Awrusalam (Baytal Makdis), in manga imam iban sin manga tau mananabang ha manga imam, madtu kan Yahiya mangasubu bang hisiyu tuud siya. ");
INSERT INTO tsg_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Walaꞌ naglibun hi Yahiya kanila. Biyaytaan niya sila sin kasabunnalan, laung niya, “Bukun aku in Almasi.” ");
INSERT INTO tsg_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Laung nila, “Bang kaw bukun in Almasi, hisiyu kaw tuud? Ikaw bahaꞌ hi Ilyas?” “Bukun,” in sambung hi Yahiya. “Ikaw ka in nabi amu in tiyatagaran sin bangsa natuꞌ Israil?” “Bukun,” in sambung hi Yahiya. ");
INSERT INTO tsg_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Laung sin manga imam, “Na, baytai kami bang hisiyu kaw, sabab subay tuud awn hikabaytaꞌ namuꞌ pa manga tau nagdaak kāmuꞌ miyari. Baytai kami sin pasal mu bang hisiyu kaw tuud.” ");
INSERT INTO tsg_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Siyambungan sila hi Yahiya sin manga lapal-kabtangan amu in sibuꞌ tuud iban sin baytaꞌ kiyasulat hi Nabi Isayas ha lawm Kitab. Laung niya, “Aku in tau manawag-tawag ha hulaꞌ paslangan mahunit paghulaan. Laung ku ha manga tau, ‘Pabuntula niyu in dān labayan sin Panghuꞌ!’” ");
INSERT INTO tsg_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Na, in manga imam naraak sin manga Parisi, amu in hambuuk tumpuk sin magkakaput sin saraꞌ agama Yahudi, nangasubu na isab kan Yahiya. ");
INSERT INTO tsg_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Laung nila, “Bang kaw bukun in Almasi atawa hi Ilyas atawa in nabi amu in piyagtatagaran sin bangsa natuꞌ Yahudi, maytaꞌ kaw mangliguꞌ ha manga tau?” ");
INSERT INTO tsg_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","In sambung hi Yahiya, “In aku miyari nangliguꞌ ha manga tau sin tubig. Sagawaꞌ awn hambuuk tau in labi dayn kākuꞌ. Yan siya limalamugay kaniyu, saꞌ diꞌ niyu siya kaingatan. ");
INSERT INTO tsg_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Miyari siya pa dunya simunud kākuꞌ, sagawaꞌ minsan humubad sin hukut tawmpaꞌ niya, diꞌ aku tūpun sabab landuꞌ tuud mataas in kawasa niya dayn kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Na, amu na yan in kimugdan kan Yahiya ha waktu siya duun nagliliguꞌ ha manga tau ha hulaꞌ Bitani ha dapit pa subangan sin Subaꞌ Jurdan. ");
INSERT INTO tsg_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Na, pagꞌadlaw hambuuk kītaꞌ hi Yahiya hi Īsa miyamanaw sūng mawn kaniya. Laung hi Yahiya, “Yan na in giyantiꞌ anak bili-bili pagkulbanan pa Tuhan, karnaꞌ siya in piyalahil sin Tuhan mamuas ha manga mānusiyaꞌ dayn ha manga dusa nila! ");
INSERT INTO tsg_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Siya na ini in piyagꞌiyan ku kaniyu. Bakas ta kamu biyaytaan, laung ku, ‘Awn tau sumunud kākuꞌ, sagawaꞌ labi tuud mataas in kawasa niya dayn kākuꞌ, sabab in siya asal naawn ha walaꞌ pa aku natau.’ ");
INSERT INTO tsg_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","In bunnal niya, walaꞌ ku kiyaingatan bang hisiyu in tau naraak sin Tuhan sumunud kākuꞌ, sagawaꞌ miyari aku nangliguꞌ ha manga tau iban tubig ha supaya siya mapanyataꞌ pa manga tau bangsa Israil.” ");
INSERT INTO tsg_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Manjari nanuysuy na hi Yahiya ha manga mulid niya pasal sin Almasi. Laung niya, “Ha walaꞌ ku pa kiyaingatan bang hisiyu in naraak sin Tuhan sumunud kākuꞌ, awn kiyabaytaꞌ kākuꞌ sin Tuhan, amu in nagdaak kākuꞌ mangliguꞌ ha manga tau sin tubig. Laung niya kākuꞌ, ‘Bang mu kakitaan in Rū sin Tuhan, tumulun magpanyataꞌ mawn pa hambuuk tau iban tumutug duun kaniya, in hāti niya, siya na yan in tau sumangun sin Rū Mahasuchi sin Tuhan pa manga mānusiyaꞌ.’ Na, nabunnal tuud in baytaꞌ sin Tuhan, sabab kītaꞌ ku tuud timulun dayn ha surgaꞌ in Rū sin Tuhan, nagpasalupa biyaꞌ māpati, ampa timapuꞌ mawn kan Īsa.” ");
INSERT INTO tsg_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Na, laung hi Yahiya, “In yan kītaꞌ ku tuud iban bihaun baytaan ta na kamu tuud sin kasabunnalan, sin in hi Īsa amuna tuud in Anak Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Manjari, pagꞌadlaw hambuuk duun na isab hi Yahiya timitindug iban sin duwa mulid niya ha higad sin Subaꞌ Jurdan. ");
INSERT INTO tsg_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Sakali kītaꞌ hi Yahiya hi Īsa limabay sartaꞌ laung niya, “Yan na in giyantiꞌ bili-bili pagkulbanan pa Tuhan!” ");
INSERT INTO tsg_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Pagdungug sin duwa mulid hi Yahiya sin bichara niya, magtūy sila imurul kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Sagawaꞌ pagharap hi Īsa pa ulihan, kītaꞌ niya in duwangka-tau miyumurul kaniya, laung niya kanila, “Maytaꞌ kamu imurul kākuꞌ?” In sambung nila, “Rabbi, hariin in kiyaruunan mu?” (In hāti sin Rabbi, Tuwan Guru). ");
INSERT INTO tsg_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Laung hi Īsa kanila, “Agad kamu mari kākuꞌ bat niyu kakitaan.” Manjari miyagad na sila iban kītaꞌ nila na in kiyaruunan niya. Iyabutan na sila dūm didtu sabab in kaagad nila kan Īsa awn na kulang-labi lisag upat sin mahapun. ");
INSERT INTO tsg_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","In ngān sin hambuuk amu in miyurul miyagad kan Īsa, hi Andariyas, taymanghud hi Simun Pitrus. ");
INSERT INTO tsg_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Manjari magtūy hi Andariyas miyadtu naglawag ha taymanghud niya hi Simun. Kiyabaakan niya mān, laung hi Andariyas, “Kiyabaakan namuꞌ na in Almasi.” ");
INSERT INTO tsg_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Sakali diyā niya madtu hi Simun kan Īsa. Iyatud siya hi Īsa ampa namung, amu agi, “Ikaw hi Simun, anak hi Yahiya, sagawaꞌ danglayan ta kaw Kipas.” (In ngān Kipas saliꞌ da iban Pitrus. In hāti niya batu.) ");
INSERT INTO tsg_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Manjari, pagꞌadlaw hambuuk napikil hi Īsa limanjal pa hulaꞌ Jalil. Sakali nagbaak sila kay Pilip. Laung hi Īsa kaniya. “Kari kaw agad kākuꞌ!” ");
INSERT INTO tsg_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","In hi Pilip ini tau Bitsayda, amu in hulaꞌ hi Andariyas kay Pitrus. ");
INSERT INTO tsg_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Na, magtūy hi Pilip naglawag kan Natanyal. Kiyabaakan niya mayan, laung niya kan Natanyal, “Kiyabaakan namuꞌ na in piyagbaytaꞌ hi Musa kiyasulat ha lawm Kitab Tawrat iban sin piyagbaytaꞌ sin manga kanabihan, amu in kiyasulat nila ha manga Kitab. In piyagbaytaꞌ nila amuna hi Īsa, anak hi Yusup dayn ha Nasarit.” ");
INSERT INTO tsg_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Sakali laung hi Natanyal, “Uy! Maytaꞌ, awn tau marayaw dayn ha Nasarit?” In sambung hi Pilip, “Kari kaw agad bat mu kakitaan.” ");
INSERT INTO tsg_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Manjari, pagkitaꞌ hi Īsa kan Natanyal sūng mawn kaniya, namung hi Īsa, laung niya, “Yari na in tau, amu in tantu tuud bangsa Israil. Bukun siya panipu!” ");
INSERT INTO tsg_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Laung hi Natanyal kaniya, “Biyaꞌ diin in kaingat mu kākuꞌ?” In sambung hi Īsa, “Sin way pa kaw natawag hi Pilip, kītaꞌ ta kaw simisilung ha sawm kahuy tina.” ");
INSERT INTO tsg_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Magtūy simambung hi Natanyal kan Īsa, laung niya, “Tuwan Guru, ikaw na tuud in Anak Tuhan, iban ikaw in Sultan sin bangsa namuꞌ Israil!” ");
INSERT INTO tsg_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Laung hi Īsa kaniya, “Nagparachaya na kaw magtūy kākuꞌ sawkat ta na kaw biyaytaan sin kītaꞌ ta kaw similung ha sawm kahuy tina? Ingat kaw ha susūngun awn manga hinang ku kakitaan mu labi makainu-inu dayn ha yan!” ");
INSERT INTO tsg_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Iban laung hi Īsa kanila, “Tantu tuud baytaan ta kamu sin tuman, kakitaan niyu maukab in lawang langit iban magnaug-gaban in manga malāikat sin Tuhan mari kākuꞌ, amu in Anak Mānusiyaꞌ.” ");
INSERT INTO tsg_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Limabay mayan duway adlaw dayn ha kapagbichara hi Īsa kay Natanyal, awn nagtiyaun ha dāira sin Kana ha hulaꞌ Jalil. Didtu in inaꞌ hi Īsa nangluruk. ");
INSERT INTO tsg_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Nataabbit da isab hinda Īsa iban sin manga mulid niya pa pagtiyaunan. ");
INSERT INTO tsg_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Manjari didtu mayan sila ha pagtiyaunan, in tubig anggul naubus na sin manga luruk. Na, laung sin inaꞌ hi Īsa kaniya, “Kiyaubusan na sila tubig anggul.” ");
INSERT INTO tsg_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Sagawaꞌ in sambung hi Īsa ha inaꞌ niya, laung niya, “Inaꞌ, ayaw na kaw magsusa sin pasal yan. Aku na in makaingat ha yan. Way pa miyabut in waktu sin pagpaguwaꞌ ku sin kusug ku.” ");
INSERT INTO tsg_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Sagawaꞌ minsan biyaꞌ hādtu in sambung hi Īsa, biyaytaan sin inaꞌ niya in manga daraakun ha bāy pagtiyaunan, laung niya, “Hinanga niyu in unu-unu daakan kaniyu hi Īsa.” ");
INSERT INTO tsg_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Manjari awn duun unum puga pagluluunan tubig hipagꞌayl sin manga Yahudi. In luun sin hambuuk puga awn manga kawhaan taglima bingkiꞌ tubig. ");
INSERT INTO tsg_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Sakali laung hi Īsa ha manga daraakun duun, “Hipua niyu sin tubig in unum puga yan.” Saruun-duun liyuunan nila in puga hīpuꞌ tuud. ");
INSERT INTO tsg_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ubus laung hi Īsa kanila, “Na, sawk na kamu ampa niyu dāha madtu pa tau nagkakaput sin paghinang.” Pagdā nila madtu, ");
INSERT INTO tsg_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","kīnaman na sin tau nagkakaput sin paghinang in tubig amu in nahinang na tubig anggul. Walaꞌ niya kiyaingatan bang dayn hāin kiyawaꞌ in tubig anggul, sagawaꞌ in manga daraakun nagsāwk sin tubig, nakaingat. Hangkan tiyawag sin tau nagkakaput sin paghinang in pangantin usug, ");
INSERT INTO tsg_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","laung niya, “In kamatauran ha paghinangan in hipainum nila tagnaꞌ in tubig anggul marayaw tuud. Na, bang mataud na in nainum sin manga luruk, hipainum nila in tubig anggul bukun marayaw tuud. Sagawaꞌ in ikaw dugaing. Sampay pa bihaun masi tubig anggul marayaw tuud in hipagpainum mu, saꞌ labi awla in dayaw sin ini.” ");
INSERT INTO tsg_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Na, duun ha kawman Kana ha Jalil timagnaꞌ hi Īsa nagpaawn muꞌjijat, amu in hinang makainu-inu. Duun niya tagnaꞌ napakitaꞌ in kusug sin kawasa niya, lāgiꞌ nagparachaya tuud kaniya in manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pagꞌubus yadtu limūd na hi Īsa pa dāira Kapirnaum nagꞌagad iban sin inaꞌ niya, manga taymanghud niya iban sin manga mulid niya. Himantiꞌ sila duun manga pilay adlaw. ");
INSERT INTO tsg_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Sakali marayꞌ mayan in paghinang sin manga Yahudi sin Haylaya Paglappas dayn ha Kamatay, timukad hi Īsa iban sin manga mulid niya madtu pa Awrusalam (Baytal Makdis). ");
INSERT INTO tsg_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pagdatung nila pa Awrusalam (Baytal Makdis), simūd hi Īsa pa lawm halaman sin Bāy sin Tuhan. Pagsūd niya, kītaꞌ niya in manga tau nagdaragang sapiꞌ iban manga bili-bili iban manga assang. Kītaꞌ niya da isab in manga tau mananambiꞌ sīn dayn ha bangsa dugaing pa sīn sin bangsa Yahudi, naglilingkud ha manga lamisahan nila. ");
INSERT INTO tsg_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Na, diyugalan hi Īsa pagkitaꞌ niya ha manga yan. Hangkan kimāꞌ siya lubid hīnang lulubak ampa niya diyūy in katān hayup, in manga bili-bili iban manga sapiꞌ pa guwaꞌ sin halaman sin Bāy sin Tuhan. Biyalintuwad niya in lamisahan sin manga tau mananambiꞌ sīn sin sīn dayn ha hulaꞌ dugaing, iban piyulak-palik niya in manga pisita nila. ");
INSERT INTO tsg_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ubus ampa niya īyan in manga tau magdaragang assang, laung niya, “Dāha niyu pa guwaꞌ in manga dagangan niyu yan. Ayaw niyu hinanga tabuꞌ in bāy ini amu in Bāy sin Tuhan, Amaꞌ ku!” ");
INSERT INTO tsg_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Na, magtūy kiyatumtuman sin manga mulid niya in kiyasulat ha lawm Kitab, amu agi, “Ya Tuhan landuꞌ tuud in tuyuꞌ ku magparuli sin bāy mu minsan amuna in makamula kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Manjari magtūy miyawn nangasubu kan Īsa in manga nakuraꞌ sin manga Yahudi. Laung nila kan Īsa, “Unu taꞌ in kapatutan mu yan magpaguwaꞌ kanila? Bang bunnal dayn ha Tuhan in kapatutan mu, pakitaa kami hambuuk muꞌjijat, amu in tandaꞌ sin awn kapatutan mu.” ");
INSERT INTO tsg_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","In sambung hi Īsa kanila, “Lubuha niyu in Bāy sin Tuhan ini, hāti ha lawm sin tūy adlaw tibuukun ku magbalik patindugun.” ");
INSERT INTO tsg_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Laung sin manga nakuraꞌ Yahudi, “Uy, mapatindug mu magbalik in Bāy sin Tuhan ini ha lawm tūy adlaw? Minsan in lugay naghinang ha yan awn kaꞌpatan tagꞌunum tahun!” ");
INSERT INTO tsg_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Na, walaꞌ nila kiyahātihan in maana sin bichara hi Īsa sabab in Bāy sin Tuhan piyagꞌiyan hi Īsa amuna in anggawtaꞌ-baran niya. ");
INSERT INTO tsg_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hangkan naabut mayan in waktu nabuhiꞌ nagbalik hi Īsa dayn ha kamatay, kiyatumtuman sin manga mulid niya in bichara hi Īsa pasal sin bāy. Kiyahātihan nila na in maana sin bichara niya. Na, nagparachaya na tuud sila sin manga kiyasulat ha lawm Kitab iban sin manga bichara hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Manjari sin saꞌbu hi Īsa duun ha Awrusalam (Baytal Makdis) himadil sin Haylaya Paglappas dayn ha Kamatay, mataud tau in nagparachaya kaniya sabab kītaꞌ nila in manga muꞌjijat nahinang niya. ");
INSERT INTO tsg_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Sagawaꞌ walaꞌ piyangandul hi Īsa in baran niya kanila sabab asal niya kiyaiingatan bang unu in ha pikilan iban lawm atay sin mānusiyaꞌ katān. ");
INSERT INTO tsg_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Minsan siya diꞌ na baytaan sin manga addat-mangaddat sin manga mānusiyaꞌ sabab asal niya kaingatan in ha lawm atay sin manga mānusiyaꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Manjari awn hambuuk nakuraꞌ sin manga Yahudi agad ha hambuuk tumpuk sin agama nila, amu in pagtawagun Parisi. In ngān niya hi Nikudimus. ");
INSERT INTO tsg_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Sakali hambuuk dūm miyadtu hi Nikudimus kan Īsa dimā nagbichara. Laung niya, “Tuwan, kaingatan namuꞌ in ikaw hambuuk guru piyakari sin Tuhan himinduꞌ kāmuꞌ, karnaꞌ diꞌ kaw makapaawn sin manga muꞌjijat bang kaw walaꞌ dīhilan barakat sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Sagawaꞌ in sambung hi Īsa kaniya, amu agi, “Baytaan ta kaw sin kasabunnalan, bang in tau diꞌ hipagꞌanak magbalik, way lamud niya ha pamarinta sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Laung hi Nikudimus, “Biyaꞌ diin kaagi in tau maas hipagꞌanak magbalik? Tantu diꞌ na siya makasūd magbalik pa lawm tiyan sin inaꞌ niya iban hipagꞌanak magbalik!” ");
INSERT INTO tsg_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","In sambung hi Īsa kaniya, laung niya, “Baytaan ta kaw sin kasabunnalan, bang in tau diꞌ hipagꞌanak dayn ha tubig iban da isab dayn ha Rū sin Tuhan, way lamud niya ha pamarinta sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","In tau hipagꞌanak sin mānusiyaꞌ, mānusiyaꞌ da isab. Sagawaꞌ bang in tau hipagꞌanak magbalik sin Rū sin Tuhan, in siya nahinang na anak sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Na, ayaw kaw mainu-inu sin bichara ku sin subay kaw hipagꞌanak magbalik. ");
INSERT INTO tsg_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","In Rū sin Tuhan biyaꞌ da sapantun sin hangin, makapagbayaꞌ bang pakain in tudjuhan niya. Kananaman ta in hangin sagawaꞌ diꞌ ta kaingatan bang guwaꞌ dayn diin atawa tudju pakain. Na, biyaꞌ da isab ha yan in hantang sin Rū sin Tuhan bang hipagꞌanak magbalik in mānusiyaꞌ dayn ha kusug sin Rū.” ");
INSERT INTO tsg_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Laung hi Nikudimus, “Ay kaw, biyaꞌ diin in kaagi sin biyaꞌ ha yan?” ");
INSERT INTO tsg_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","In sambung hi Īsa kaniya, “Maytaꞌ mu diꞌ kahātihan in panghinduꞌ ku ini? Malayngkan, hambuuk kaw guru lalagguun sin bangsa Israil. ");
INSERT INTO tsg_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Baytaan ta kaw sin kasabunnalan. Nagnasīhat kami sin kiyaingatan namuꞌ iban simaksiꞌ kami sin kiyakitaan namuꞌ. Sagawaꞌ diꞌ kamu magparachaya sin baytaꞌ namuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Bang kamu diꞌ magparachaya sin hinduꞌ ku ha pasal sin kahālan sin dunya, na tantu diꞌ da kamu isab magparachaya kākuꞌ bang ta kamu hinduan sin kahālan sin surgaꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wayruun mānusiyaꞌ in nakakadtu pa surgaꞌ luwal da in aku, amu in Anak Mānusiyaꞌ. In aku miyari dayn ha surgaꞌ sabab amu yan in asal hulaan ku.” ");
INSERT INTO tsg_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Laung pa isab hi Īsa, “Sin masa nakauna yadtu, ha waktu hi Musa iban sin manga bangsa Israil didtu ha hulaꞌ paslangan mahunit paghulaan, giyantung hi Musa pa usuk in hās hīnang dayn ha tumbaga ha supaya bang aturun sin manga tau bakas nakutkut sin hās, kaulian sila. Na, biyaꞌ da isab ha yan in hantang sin amu in Anak Mānusiyaꞌ. Subay aku hikalansang pa usuk pagpatayan tau ampa patindugun, ");
INSERT INTO tsg_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ha supaya hisiyu-siyu in magparachaya kākuꞌ makabāk kabuhiꞌ salama-lama ha lawm ukum milik sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Landuꞌ tuud malasa in Tuhan ha manga mānusiyaꞌ, hangkan atas niya piyalahil pa dunya in hambuuk-buuk Anak niya amu in miyatay, ha supaya hisiyu-siyu in magparachaya kaniya diꞌ makapanarkaꞌ ha adlaw mahuli iban makabāk siya kabuhiꞌ salama-lama. ");
INSERT INTO tsg_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","In maksud sin Tuhan nagpakari ha Anak niya pa dunya bukun manghukum ha manga mānusiyaꞌ, sagawaꞌ lumappas kanila, bat sila diꞌ kabutangan sin hukuman sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Na, hisiyu-siyu in magparachaya ha Anak Tuhan, diꞌ tuud siya kugdanan sin hukuman sin Tuhan, sagawaꞌ hisiyu-siyu in diꞌ magparachaya kaniya, na in tau yan asal kiyugdan na sin hukuman sabab walaꞌ siya nagparachaya ha hambuuk-buuk Anak Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","In Anak Tuhan, amu in piyagbahasa ilaw, miyari pa lawm dunya dumihil kasawahan ha manga mānusiyaꞌ, sagawaꞌ mabayaꞌ in manga mānusiyaꞌ sin katigidluman dayn sin kasawahan sabab mangīꞌ in manga hinang nila. Na, amu yan in sabab hangkan in mānusiyaꞌ kugdanan sin hukuman. ");
INSERT INTO tsg_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Na, in tau mangīꞌ in hinang niya marugal ha ilaw yan. Diꞌ siya mabayaꞌ humarap pa ilaw yan sabab diꞌ siya mabayaꞌ kakitaan in manga hinang niya mangīꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Sagawaꞌ in tau naghihinang sin marayaw mabayaꞌ humarap pa ilaw, ha supaya tumampal sin in siya naghinang marayaw sabab sin pagkahagad niya ha Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pagꞌubus, miyadtu hinda Īsa pa hulaꞌ Yahudiya iban sin manga mulid niya. Dimuun sila manga pilay adlaw iban nagliguꞌ sila ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Ha waktu yadtu walaꞌ pa najīl hi Yahiya. Didtu isab siya nagliguꞌ ha manga tau ha hulaꞌ Inun, amu in masuuk pa hulaꞌ Salim, sabab mataud tubig didtu. Daran in manga tau madtu kaniya magpaliguꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Manjari, in manga kaibanan mulid hi Yahiya naglugat iban sin hambuuk Yahudi pasal sin addat sin pagliguꞌ ha aturan sin agama. ");
INSERT INTO tsg_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Sakali miyadtu in manga mulid hi Yahiya kaniya, amu agi, “Tuwan Guru, katumtuman mu in hambuuk tau piyagbaytaꞌ mu kāmuꞌ amu in iban mu didtu ha hansipak sin Subaꞌ Jurdan? Na, nagliguꞌ na siya ha manga tau iban mataud tuud tau in sūng madtu kaniya!” ");
INSERT INTO tsg_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","In sambung hi Yahiya kanila, “Wayruun tau in tagakawasa bang bukun dayn ha Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Iban makasaksiꞌ kamu sin bakas piyamung ku sin bukun aku in Almasi, sagawaꞌ naraak aku mari piyauna dayn kaniya magsakap sin dān labayan niya. ");
INSERT INTO tsg_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Bang sawpama awn tau maniyaun, in pangantin usug in tagsukuꞌ ha pangantin babai, bukun in bagay niya. Na, in bagay sin pangantin usug, amu in miyuna dayn kaniya, kumuyag tuud bang niya karungugan na in tingug sin pangantin usug. Na, biyaꞌ da isab ha yan in hantang namuꞌ kay Īsa. Jumukup na in kakuyagan ku ");
INSERT INTO tsg_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","bang hi Īsa tumaas na mabantug, hāti in aku mabaꞌ na in kabantugan ku.” ");
INSERT INTO tsg_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Na, bang in tau limahil dayn ha surgaꞌ tantu makawasa tuud siya dayn ha katān. Sagawaꞌ bang dayn ha dunya sadja in tau, na, in kaingatan iban hikahinduꞌ niya amuna in kahālan ha lawm dunya. Sagawaꞌ in tau naug dayn ha surgaꞌ makawasa tuud dayn ha katān. ");
INSERT INTO tsg_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Na pagga siya naug dayn ha surgaꞌ, in hinduꞌ niya pasal sin manga kītaꞌ iban diyungug niya ha surgaꞌ, sagawaꞌ hangkatiyuꞌ da tuud in magparachaya ha hinduꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Sagawaꞌ hisiyu-siyu in magparachaya tuud ha hinduꞌ niya amuna in dumihil tandaꞌ sin bunnal tuud in Tuhan, ");
INSERT INTO tsg_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","sabab in Almasi, amu in piyalahil sin Tuhan pa dunya, mamaytaꞌ pasal sin baytaꞌ sin Tuhan, karnaꞌ in Almasi kapagꞌagihan sin Rū sin Tuhan, amu in piyatutug sin Tuhan duun kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Malasa tuud in Tuhan ha Anak niya, iban dīhil niya in katān kusug iban kawasa kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Hisiyu-siyu in magparachaya ha amu in Anak Tuhan, awn kabuhiꞌ niya salama-lama, sagawaꞌ hisiyu-siyu in diꞌ magparachaya ha Anak Tuhan, diꞌ siya kaawnan sin kabuhiꞌ salama-lama. Gām mayan diꞌ maīg in mulkaꞌ sin Tuhan dayn kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Manjari kiyabaytaan in manga tau Parisi sin mataud tau in miyagad iban nagpaliguꞌ kan Īsa dayn kan Yahiya. ");
INSERT INTO tsg_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","In bunnal niya, bukun hi Īsa in nagliguꞌ ha manga tau, saꞌ manga mulid niya in nagliguꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Na, pagꞌingat hi Īsa sin manga suysuy ini, minīg siya iban sin manga mulid niya dayn ha hulaꞌ Yahudiya, ampa sila miyadtu nagbalik pa hulaꞌ Jalil. ");
INSERT INTO tsg_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Sakali in dān tudju pa Jalil subay lumabay dayn ha Samariya. ");
INSERT INTO tsg_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Na, limabay hinda Īsa dayn ha dān yan, sampay naabut nila in hambuuk kawman sin hulaꞌ Samariya pagngānan Sikar. In dāira ini masuuk madtu pa lupaꞌ amu in piyusakaꞌ hi Yaꞌkub ha anak niya hi Yusup sin masa nakauna yadtu. ");
INSERT INTO tsg_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Manjari duun ha lupaꞌ yaun, awn hambuuk kuppung amu in bakas hīnang hi Yaꞌkub. Sakali limingkud hi Īsa duun ha higad sin kuppung sabab liyaul siya, iban ugtu suga na. ");
INSERT INTO tsg_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Hāti in manga mulid niya miyadtu pa lawm dāira namī pagkaun. Na, nakalingkud mayan hi Īsa, awn hambuuk babai Samariya in miyawn simawk tubig. Manjari laung hi Īsa ha babai ini, “Indaꞌ, dihili aku tubig inumun.” ");
INSERT INTO tsg_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Laung sin babai kan Īsa, “In kita, bukun hangka-bangsa. In ikaw hambuuk Yahudi, ampa in aku tau Samariya, hāti mangayuꞌ kaw kākuꞌ tubig?” Hangkan in babai imiyan biyaꞌ hādtu, sabab diꞌ magꞌiyasipi in manga Yahudi iban sin manga tau Samariya. ");
INSERT INTO tsg_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","In sambung hi Īsa ha babai, laung niya, “Bang mu sadja kaingatan bang unu in hirihil sin Tuhan ha manga mānusiyaꞌ, iban bang mu kaingatan bang hisiyu tuud aku amu in mangayuꞌ tubig bihaun, na mangayuꞌ da kaw isab tubig dayn kākuꞌ. Na, painumun ta kaw sin tubig amu in makabuhiꞌ ha tau.” ");
INSERT INTO tsg_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Laung sin babai kan Īsa, “Tuwan, biyaꞌ diin in kasawk mu sin tubig makabuhiꞌ ha tau sin wayruun hipanawk mu? Ampa in kuppung ini malawm. ");
INSERT INTO tsg_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","In naghinang sin kuppung ini hi Yaꞌkub, amu in kaapuꞌ-apuan natuꞌ. Nakainum sila magtawtayꞌanak sin tubig ini sampay pa manga kahayupan nila. Na, pikil mu bahaꞌ, makawasa kaw dayn kan Yaꞌkub?” ");
INSERT INTO tsg_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","In sambung hi Īsa, “In katān makainum sin tubig dayn ha kuppung ini, tantu uhawun da magbalik. ");
INSERT INTO tsg_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Sagawaꞌ hisiyu-siyu in makainum sin tubig hirihil ku kaniya, tantu diꞌ siya uhawun magbalik kasaumulan. Karnaꞌ in tubig hirihil ku kaniya mahinang biyaꞌ tuburan sin tubig ha lawm atay niya, amu in dumihil kaniya kabuhiꞌ salama-lama.” ");
INSERT INTO tsg_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Laung sin babai, “Tuwan, painuma aku sin tubig piyagꞌiyan mu yan ha supaya aku diꞌ na uhawun magbalik, iban ha supaya aku diꞌ na mari magbalik sumawk tubig.” ");
INSERT INTO tsg_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Laung hi Īsa kaniya, “Kadtu kaw kawaa in bana mu ampa kamu balik mari.” ");
INSERT INTO tsg_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","In sambung sin babai, “Wayruun bana ku bihaun.” Laung hi Īsa, “Bunnal in agi mu sin wayruun bana mu bihaun, ");
INSERT INTO tsg_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","sabab minsan kaw nakalabay na nagbana nakalima, in usug iban mu nagꞌuukum bihaun, bukun kamu halal kawin. Kasabunnalan in biyaytaꞌ mu kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Laung sin babai kan Īsa, “Tuwan, bat hambuuk nabi kaw hāti yan! ");
INSERT INTO tsg_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","In manga kaapuꞌ-apuan namuꞌ yadtu, manga tau Samariya, dī ha būd ini in pagpudjihan nila ha Tuhan. Sagawaꞌ laung sin manga kamu bangsa Yahudi subay ha Awrusalam (Baytal Makdis) in pagpudjihan ha Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Laung hi Īsa kaniya, “Indaꞌ, kahagad na kaw sin baytaꞌ ku kaymu. Dumatung da in waktu sin pagpudji natuꞌ ha Tuhan, Amaꞌ natuꞌ, bukun ha būd ini atawa ha Awrusalam (Baytal Makdis). ");
INSERT INTO tsg_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","In kamu manga tau Samariya diꞌ niyu kaingatan bang hisiyu tuud in piyupudji niyu. Sagawaꞌ in manga kami bangsa Yahudi kaingatan namuꞌ in piyupudji namuꞌ sabab in manglalappas ha mānusiyaꞌ guwaꞌ dayn ha bangsa Yahudi. ");
INSERT INTO tsg_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Na, bihaun dimatung na in waktu sin pagpudji sin manga tau dayn ha lawm atay nila tuud iban dayn ha kasabunnalan. Karnaꞌ biyaꞌ ha yan in kabayaan sin Tuhan bang in tau magpudji kaniya.” ");
INSERT INTO tsg_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Iban laung hi Īsa, “Tuhan in puunan sin nyawa, lāgiꞌ in siya nyawa da isab. Bukun siya biyaꞌ sin mānusiyaꞌ tagabaran. Hangkan hisiyu-siyu in mamudji kaniya subay tuud dayn ha lawm atay iban dayn ha kasabunnalan.” ");
INSERT INTO tsg_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Laung sin babai kan Īsa, “Asal kaingatan ku ha waktu susūngun dumatung mari in Almasi. Pagdatung niya mari, hibaytaꞌ niya kātuꞌniyu in unu-unu katān.” ");
INSERT INTO tsg_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","In sambung hi Īsa kaniya, laung niya, “In piyagꞌiyan mu yan amuna in diyarā mu nagbichara bihaun.” ");
INSERT INTO tsg_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ha saꞌbu hi Īsa nagbibichara iban sin babai, dimatung na in manga mulid hi Īsa. Landuꞌ tuud sila nainu-inu pagkitaꞌ nila nagbibichara hi Īsa iban sin babai. Sagawaꞌ wayruun tuud minsan hambuuk kanila in timawakkal mangasubu ha babai bang unu in gawi niya atawa nangasubu kan Īsa bang maytaꞌ niya diyā nagbichara in babai. ");
INSERT INTO tsg_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Na, binīn sin babai in kibut niya, ampa siya nagbalik pa kawman nanuysuy ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Laung niya ha manga tau, “Kari kamu agad kākuꞌ kimitaꞌ sin tau amu in namaytaꞌ kākuꞌ sin katān bakas nahinang ku. Bukun bahaꞌ siya na in Almasi?” ");
INSERT INTO tsg_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Na, in manga tau kiyabaytaan duun ha kawman miyadtu na kimitaꞌ kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sin walaꞌ pa dimatung mawn in manga tau, siyagina na hi Īsa sin manga mulid niya pakaunun. Laung nila, “Tuwan Guru, bang kaw isab kimaun na muna!” ");
INSERT INTO tsg_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Sagawaꞌ in sambung hi Īsa kanila, “Awn da kakaun ku amu in diꞌ niyu kaingatan.” ");
INSERT INTO tsg_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Na, nagꞌasubu-iyasubuhi na in manga mulid niya. Laung nila, “Awn bahaꞌ tau dimā mari kaniya kakaun?” ");
INSERT INTO tsg_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","“In makarihil kākuꞌ kusug,” laung hi Īsa, “in magad sin daakan sin Tuhan, amu in nagdaak kākuꞌ mari, subay ku ubusun hinangun in katān daakan niya. ");
INSERT INTO tsg_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Na, biyaꞌ na sin agi niyu upat bulan pa in lugay ampa makapagꞌani in tau sin tiyanum niya. Saꞌ baytaan ta kamu, bihaun waktu na sin pagꞌani. Atura niyu ba in manga tau sūng mari. In sila yan biyaꞌ sapantun manga tiyanum amu in matūp na anihun. Bukun na mawgay magparachaya na sila kākuꞌ! ");
INSERT INTO tsg_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Na, hisiyu-siyu in tau makarā ha manga tau magad sin hinduꞌ ku, awn tungbas kaniya marayaw, iban in manga tau mapaagad nila, awn na kabuhiꞌ salama-lama. Na, bang ibārat nagtanum, in tau nagtanum iban sin tau nagꞌaani kūgan sila karuwa bang sila makaani na. Na, biyaꞌ da isab ha yan in hantang sin tau nagpamahalayak sin Baytaꞌ Marayaw iban sin mangangawaꞌ tau magpaagad sin hinduꞌ ku, magkūg-kuyag sila karuwa.” ");
INSERT INTO tsg_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Laung pa isab hi Īsa, “Bunnal tuud in agi sin kamaasan natuꞌ yadtu, amu agi, ‘Dugaing in magtanum, dugaing isab in umaani!’ ");
INSERT INTO tsg_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na, in kamu yan kiyawakilan ku umani sin bukun niyu tiyanum. Dugaing in nagsangsaꞌ, saꞌ kamu in magkawaꞌ magpajatu sin bunga.” ");
INSERT INTO tsg_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Manjari mataud tau Samariya in nagparachaya kan Īsa, sabab sin bichara sin babai, amu agi, “Biyaytaan aku sin tau sin katān bakas nahinang ku.” ");
INSERT INTO tsg_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Na, hangkan nakakawn mayan in manga tau Samariya kan Īsa, piyangayuꞌ nila kan Īsa pahantiun duun kanila. Na, himantiꞌ hi Īsa duun kanila duway adlaw. ");
INSERT INTO tsg_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Lāgiꞌ dayn ha sabab sin pagnasīhat hi Īsa ha manga tau timaud in nagparachaya kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Iban laung sin manga tau Samariya ha babai, “Bihaun magparachaya na tuud kami kan Īsa bukun sadja ha pasal sin suysuy mu, saꞌ diyungug namuꞌ na tuud in hinduꞌ niya. Iban kaingatan namuꞌ na sin siya na tuud in Manglalappas ha manga mānusiyaꞌ dī ha dunya.” ");
INSERT INTO tsg_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Na, pagꞌubus hinda Īsa nakahantiꞌ duun duway adlaw, limanjal na sila pa Jalil. ");
INSERT INTO tsg_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Asal nakapamung hi Īsa, laung niya, “In hambuuk nabi diꞌ siya lagguun ha luggiyaꞌ hulaꞌ niya.” ");
INSERT INTO tsg_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pagdatung nila pa Jalil siyampang na sila sin manga tau duun, sabab in manga tau ini bakas nakakitaꞌ sin katān nahinang hi Īsa ha adlaw pagjamu ha saꞌbu nila didtu ha Awrusalam (Baytal Makdis) himadil sin Haylaya Paglappas dayn ha Kamatay. ");
INSERT INTO tsg_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Pagꞌubus yadtu nagbalik na hinda Īsa pa kawman Kana ha Jalil. Duun ha Kana napapanjari hi Īsa tubig anggul in tubig. Sakali awn hambuuk upisyal dayn ha Kapirnaum, amu in kiyarihilan kawasa sin sultan, in nakasaꞌbu isab duun. In anak niya usug tagasakit. ");
INSERT INTO tsg_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pagꞌingat niya sin yaun hi Īsa ha Jalil bakas dayn ha Yahudiya, miyadtu siya kan Īsa jimunjung paagarun pa Kapirnaum ha supaya kaulian in anak niya nasasakit pangsan. ");
INSERT INTO tsg_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Laung hi Īsa kaniya, “Subay sadja kamu makakitaꞌ manga tandaꞌ iban manga muꞌjijat ampa kamu magparachaya.” ");
INSERT INTO tsg_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","In sambung sin upisyal, “Anduꞌ Tuwan, agad na kaw mari kākuꞌ sabab in anak ku ha ūt na sin kamatay iban kabuhiꞌ.” ");
INSERT INTO tsg_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Laung hi Īsa kaniya, “Kadtu na kaw uwiꞌ. Uliꞌ na in anak mu!” Na, nagkahagad in tau ini sin bichara kaniya hi Īsa iban magtūy na siya minuwiꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Na, ha saꞌbu niya miyanaw tudju pa bāy niya, piyaglanggal siya sin manga daraakun niya. Laung nila kaniya, “In anak mu uliꞌ na!” ");
INSERT INTO tsg_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Sakali iyasubu niya sila, laung niya, “Manga lisag pila imuliꞌ in sakit niya?” Laung nila, “Naīg in hinglaw niya lisag hambuuk sin kahapun mahapun.” ");
INSERT INTO tsg_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Na, kiyatumtuman sin amaꞌ sin bataꞌ-bataꞌ sin amuna isab yadtu in waktu sin pagbichara hi Īsa kaniya, amu agi, “Uliꞌ na in anak mu!” Na, dayn didtu nagparachaya siya kan Īsa iban sin manga tau ha lawman niya. ");
INSERT INTO tsg_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Na, amu yan in hikaruwa muꞌjijat nahinang hi Īsa pagꞌubus niya nagbalik dayn ha Yahudiya pa Jalil. ");
INSERT INTO tsg_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Manjari manga pilay adlaw mayan nakalabay, timukad hinda Īsa pa Awrusalam (Baytal Makdis) sumaꞌbu sin hambuuk hinang pagjamu sin manga Yahudi. ");
INSERT INTO tsg_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na, duun ha Awrusalam (Baytal Makdis) awn tubig amu in pagtawagun, bang ha bahasa Yahudi, Bitsatta, masuuk pa hambuuk lawang sin dāira amu in pagngānan Lawang Bili-bili. Iban awn duun lima bāy-bāy pagsisilungan ha daig sin tubig. ");
INSERT INTO tsg_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Na, mataud tuud tau nasasakit in kimukulang duun ha bāy-bāy. In kaibanan buta, iban in kaibanan pingkaꞌ, diꞌ makapanaw, iban in kaibanan nagpapatay in baran. ");
INSERT INTO tsg_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","In manga tau nasasakit ini, timatagad duun sin pagbukal sin tubig, sabab awn waktu mawn in malāikat sin Tuhan magpabukal sin tubig. Na hisiyu-siyu in makakadtu muna ha saꞌbu nagbubukal in tubig kaulian in sakit niya, minsan sakit unu. ");
INSERT INTO tsg_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Manjari awn hambuuk tau nasasakit duun. Katluan tagwalu tahun na in lugay niya nāsakit. ");
INSERT INTO tsg_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Pagkitaꞌ hi Īsa, kiyaingatan niya magtūy sin malugay na in sakit niya. Manjari iyasubu siya hi Īsa, amu agi, “Mabayaꞌ kaw kaulian?” ");
INSERT INTO tsg_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Laung sin tau nāsakit kan Īsa, “Huun, Tuwan, sagawaꞌ wayruun makabuhat kākuꞌ mawn pa lawm tubig bang in tubig magbukal na. Iyampa namān aku imilud, awn na magtūy makauna dayn kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Na, laung hi Īsa kaniya, “Tindug na kaw. Mumusa na in kulangan mu ampa kaw panaw na.” ");
INSERT INTO tsg_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Saruun-duun kiyaulian in tau nāsakit. Miyumus niya na in kulangan niya ampa siya miyanaw. Na, in adlaw yadtu, adlaw Sabtuꞌ, amu in adlaw paghali-hali iban pagpudji pa Tuhan sin manga bangsa Yahudi. ");
INSERT INTO tsg_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Sakali laung sin manga nakuraꞌ sin manga Yahudi ha tau bakas nāsakit, “Uy, adlaw ini, adlaw paghali-hali iban pagpudji pa Tuhan. Langgal saraꞌ natuꞌ in magmumus kaw sin kulangan mu yan.” ");
INSERT INTO tsg_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","In sambung sin tau bakas nāsakit, laung niya, “In agi sin tau nagpauliꞌ sin sakit ku, hipamumus na in kulangan ku iban diyaak niya na aku papanawun.” ");
INSERT INTO tsg_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","In agi sin manga nakuraꞌ Yahudi, “Hisiyu in tau dimaak kaymu biyaꞌ hādtu?” ");
INSERT INTO tsg_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Sagawaꞌ diꞌ kaingatan sin tau bakas nāsakit bang hisiyu in tau nagpauliꞌ kaniya, sabab mataud tuud tau duun ha daig tubig iban in hi Īsa minīg magtūy. ");
INSERT INTO tsg_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Manjari pagpuas yadtu, kītaꞌ hi Īsa nagbalik in tau amu in bakas nāsakit didtu ha lawm Bāy sin Tuhan. Laung hi Īsa kaniya, “Kitaa ba, kiyaulian na in sakit mu. Hangkan ayaw na kaw maghinang sin manga hinang makarusa ha supaya wayruun mangīꞌ kumugdan kaymu labi pa dayn sin bakas sakit mu.” ");
INSERT INTO tsg_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Na, pagꞌubus, gimuwaꞌ na in tau bakas nāsakit ampa miyadtu namaytaꞌ ha manga nakuraꞌ Yahudi sin hi Īsa in tau nagpauliꞌ sin sakit niya. ");
INSERT INTO tsg_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Hangkan sainagun sin manga nakuraꞌ Yahudi pinjalaun nila hi Īsa, sabab nagpauliꞌ siya sin tau nasasakit ha adlaw hipaghali-hali pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Sagawaꞌ in sambung hi Īsa kanila, laung niya, “In Tuhan, Amaꞌ ku, diꞌ magbugtuꞌ in paghinang niya. Na, damikkiyan in aku subay ku isab diꞌ bugtuun in paghinang ku.” ");
INSERT INTO tsg_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Pagdungug sin manga nakuraꞌ Yahudi sin bichara hi Īsa diyugalan tuud sila. Kimusug na tuud in bayaꞌ nila mamunuꞌ kan Īsa sabab bukun sadja pasal sin pagpauliꞌ niya ha tau nasasakit ha adlaw hipaghali-hali iban pagpudji pa Tuhan, sagawaꞌ imiyan siya sin Amaꞌ niya in Tuhan, iban piyakitaꞌ niya sin siya sibuꞌ iban Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Manjari laung hi Īsa ha manga nakuraꞌ Yahudi, “Baytaan ta kamu sin kasabunnalan. Diꞌ ku mahinang in manga nahinang ku yan bang baran-baran ku sadja, sagawaꞌ unu-unu in kītaꞌ ku hīhinang sin Tuhan, Amaꞌ ku, amu isab in agarun ku hinangun. Sibuꞌ tuud in hinang sin Amaꞌ iban sin Anak. ");
INSERT INTO tsg_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Karnaꞌ dayn ha sabab landuꞌ tuud in lasa kākuꞌ sin Tuhan, Amaꞌ ku, piyaiingat niya kākuꞌ in katān hinang niya. Ha susūngun awn pa hipahinang sin Tuhan, Amaꞌ ku, amu in labi pa dayn sin manga nahinang ku hayn-duun iban mainu-inu tuud kamu. ");
INSERT INTO tsg_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","In Tuhan, Amaꞌ ku, makarihil kabuhiꞌ ha miyamatay. Na, damikkiyan in aku, Anak niya, makarihil kabuhiꞌ ha hisiyu-siyu tau patay kabayaan ku buhiun. ");
INSERT INTO tsg_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Lāgiꞌ bukun Tuhan, Amaꞌ ku, in manghukum ha manga mānusiyaꞌ, sabab kiyasukuꞌ niya na kākuꞌ in kawasa manghukum ha manga mānusiyaꞌ, ");
INSERT INTO tsg_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ha supaya aku lagguun sin mānusiyaꞌ katān biyaꞌ da isab sin paglagguꞌ nila ha Tuhan. Hisiyu-siyu in diꞌ manglagguꞌ kākuꞌ, hāti niya walaꞌ niya da isab liyagguꞌ in Tuhan amu in nagpakari kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Laung pa isab hi Īsa kanila, “Baytaan ta kamu sin kasabunnalan. Hisiyu-siyu in dumungug sin bichara ku iban magparachaya ha nagdaak kākuꞌ mari, awn kabuhiꞌ niya salama-lama, iban diꞌ na siya kugdanan sin hukuman pakadtuun pa narkaꞌ. Mapuas na siya dayn ha kasiksaan salama-lama. Gām mayan awn na kabuhiꞌ niya kasaumulan. ");
INSERT INTO tsg_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Baytaan ta kamu sin kasabunnalan,” laung hi Īsa, “bihaun dimatung na in waktu, awn makabuhiꞌ magbalik ha manga patay bang sila dumungug sin suwara ku amu in Anak Tuhan, iban kaawnan na sila sin kabuhiꞌ salama-lama. ");
INSERT INTO tsg_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Karnaꞌ in aku biyaꞌ da tuud isab Tuhan, Amaꞌ ku, amu in puunan sin kabuhiꞌ sabab sin kawasa kiyarihil niya kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Lāgiꞌ asal aku kiyarihilan kawasa sin Tuhan, Amaꞌ ku, manghukum ha manga mānusiyaꞌ sabab aku in Anak Mānusiyaꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Sagawaꞌ ayaw kamu mainu-inu sin pamung ku ini. Ha susūngun in katān patay makarungug da sin suwara ku, amu in suwara sin Anak Mānusiyaꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Na, pagdungug nila sin suwara ku, magtūy sila mabuhiꞌ magbalik iban gumuwaꞌ na sila dayn ha lawm kubul. Na, in sasukuꞌ sin bakas nakahinang marayaw mabuhiꞌ na magbalik dayn ha kamatay, iban karihilan na kabuhiꞌ salama-lama, sagawaꞌ in sasukuꞌ sin bakas nakahinang mangīꞌ, mabuhiꞌ da isab magbalik ha supaya sila kabutangan hukuman sin narusa nila.” ");
INSERT INTO tsg_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Laung pa isab hi Īsa, “Diꞌ aku makahinang unu-unu bang baran-baran ku sadja. Minsan in manghukum bukun hinang sin baran-baran ku, saꞌ in yan daakan sin Tuhan kākuꞌ. Hangkan in panghukum ku mabuntul tuud sabab kabayaan sin Tuhan in iyaagad ku, amu in nagdaak nagpakari kākuꞌ. Bukun kabayaan ku in iyaagad ku. ");
INSERT INTO tsg_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Lāgiꞌ bang aku sadja in mamaytaꞌ kaniyu pasal sin baran ku diꞌ kamu magkahagad sin bunnal in bichara ku. ");
INSERT INTO tsg_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Sagawaꞌ awn dugaing namaytaꞌ kaniyu pasal ku, ampa kaingatan ku in baytaꞌ niya pasal ku bunnal tuud. ");
INSERT INTO tsg_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Piyakadtu niyu in manga daraakun niyu nangusihat kan Yahiya. Na biyaytaan niya sila sin kasabunnalan pasal ku. ");
INSERT INTO tsg_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Malayngkan, diꞌ aku magkagunahan tau mamaytaꞌ sin pasal ku, sagawaꞌ siyabbut ku hi Yahiya kaniyu ha supaya kamu malappas. ");
INSERT INTO tsg_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","In hi Yahiya biyaꞌ sapantun hambuuk palitaan nalalaga dumihil kasawahan pa manga mānusiyaꞌ. Kiyaamuhan kamu sin hinduꞌ niya, sagawaꞌ hangkarayꞌ da. ");
INSERT INTO tsg_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Sagawaꞌ awn da mamaytaꞌ pasal ku amu in labi pa dayn sin baytaꞌ hi Yahiya. In hinang ku amuna in mamaytaꞌ kaniyu sin pasal ku. Naraak aku sin Tuhan, Amaꞌ ku, tumalus sin hinang kiyasukuꞌ niya hipahinang kākuꞌ. Na, in yan amuna in tandaꞌ sin in aku kiyawakilan sin Tuhan mari. ");
INSERT INTO tsg_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Lāgiꞌ minsan in Tuhan, Amaꞌ ku, amu in nagdaak mari kākuꞌ, simaksiꞌ da isab sin pasal ku. Sagawaꞌ walaꞌ tuud kamu dimungug sin suwara niya, iban walaꞌ niyu tuud kītaꞌ in jāt niya. ");
INSERT INTO tsg_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Iban walaꞌ himūp pa lawm atay niyu in Parman niya, sabab diꞌ kamu magparachaya ha amu in naraak niya mari. ");
INSERT INTO tsg_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Matuyuꞌ tuud kamu mangadjiꞌ sin luun sin manga Kitab sabab in pangannal niyu bang niyu pangadjiun in luun sin manga Kitab makabaak kamu kabuhiꞌ salama-lama. Na, in manga Kitab piyangadjiꞌ niyu yan namaytaꞌ sin pasal ku! ");
INSERT INTO tsg_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Sagawaꞌ matugas in atay niyu. Masi kamu diꞌ magparachaya kākuꞌ minsan da aku in makarihil kaniyu sin kabuhiꞌ salama-lama.” ");
INSERT INTO tsg_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Laung pa isab hi Īsa, “Bukun kalagguan dayn ha mānusiyaꞌ in kabayaan ku. ");
INSERT INTO tsg_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Sagawaꞌ kaingatan ku bang unu in ha lawm atay niyu. Wayruun lasa niyu ha Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Miyari aku iban kawasa kiyarihil kākuꞌ sin Tuhan, Amaꞌ ku, sagawaꞌ diꞌ kamu magkahagad kākuꞌ. Sagawaꞌ bang awn tau dugaing magpakitaꞌ kaniyu sin kawasa niya magkahagad kamu kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Asal diꞌ kamu makakahagad kākuꞌ sabab in piyagtutuyuan niyu in kabantugan dayn ha pagkahi niyu mānusiyaꞌ. Wayruun tuyuꞌ niyu sin kabantugan dayn ha hambuuk-buuk Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Na, ayaw kamu magpikil sin aku in mamaytaꞌ sin manga dusa niyu pa Tuhan, Amaꞌ ku, bang maabut na in adlaw paghukum. Sabab in hi Musa amu in bakas nagpasampay kaniyu sin saraꞌ iyaagad niyu, amu in mamaytaꞌ sin manga dusa niyu. ");
INSERT INTO tsg_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Malayngkan, bang kamu bunnal tuud nagkahagad kan Musa, subay kamu magkahagad kākuꞌ, sabab kiyasulat niya ha lawm Kitab in pasal ku. ");
INSERT INTO tsg_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Sagawaꞌ pagga kamu diꞌ magkahagad sin pasal kiyasulat hi Musa, na asal diꞌ da kamu magkahagad sin hibaytaꞌ ku kaniyu.” ");
INSERT INTO tsg_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Manjari ini, marayꞌ na in haylaya sin bangsa Yahudi, amu in pagtawagun Haylaya Paglappas dayn ha Kamatay. Sakali imuntas na hinda Īsa pa hansipak sin Dagat Jalil, amu in pagtawagun Dagat Tibiri. Mataud tau in miyurul kanila, sabab kītaꞌ nila in manga muꞌjijat nahinang hi Īsa biyaꞌ na sin pagpauliꞌ sin manga tau nāsakit. Na, pagdatung hinda Īsa, timukad hi Īsa iban sin manga mulid niya pa taas būd-būd, ampa sila limingkud duun. ");
INSERT INTO tsg_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Sakali pagkitaꞌ hi Īsa sin manga tau mataud sūng mawn kanila, namung siya ha hambuuk mulid niya hi Pilip, laung niya, “Hariin kita makabī pagkaun hipakaun ha manga tau ini?” ");
INSERT INTO tsg_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Hangkan nangasubu biyaꞌ hādtu hi Īsa, sabab siyulayan niya bang awn da pangandul hi Pilip ha kawasa niya. Malayngkan, asal kaingatan na hi Īsa bang unu in hinangun niya.) ");
INSERT INTO tsg_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","In sambung hi Pilip, “Tuwan, minsan in gadji sin hinang walu bulan in hipamī tinapay diꞌ da makakaunan ha taud sin manga tau yan, minsan da hangkatiyuꞌ in hirihil kanila, diꞌ da makajarihan.” ");
INSERT INTO tsg_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Sakali simambung in hambuuk mulid hi Īsa hi Andariyas, amu in taymanghud hi Simun Pitrus, laung niya, ");
INSERT INTO tsg_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Yari awn hambuuk bataꞌ usug nagdarā lima tinapay iban duwa istaꞌ. Sagawaꞌ tantu tuud diꞌ ini makajarihan hipakaun ha manga tau mataud ini.” ");
INSERT INTO tsg_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Laung hi Īsa kanila, “Palingkura niyu in manga tau.” (Na, maluag in bayli duun lingkuran nila.) Na, limingkud na duun in manga tau. In taud sin manga tau minsan in usug sadja awn manga lima ngaibu, dugaing pa in manga babai iban sin manga bataꞌ-bataꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Manjari kiyawaꞌ na hi Īsa in tinapay ampa siya nagsarang-sukul pa Tuhan. Pagꞌubus ampa niya piyagbahagiꞌ-bahagiꞌ in manga tinapay, piyarihil pa manga tau naglilingkud. Damikkiyan, piyagbahagiꞌ-bahagiꞌ niya da isab in istaꞌ iban kiyarihilan in manga tau pila-pila na in taud sin kabayaan nila. ");
INSERT INTO tsg_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Pagga kiyansuban na in manga tau, laung hi Īsa ha manga mulid niya, “Tipuna niyu in manga kakaun nakapin bat diꞌ makawgun.” ");
INSERT INTO tsg_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Na, tīpun na sin manga mulid hi Īsa in manga tinapay nakapin. Ha lawm sin lima tinapay yadtu piyakaun ha manga tau, in nakapin awn pa hangpuꞌ tagduwa ambung. ");
INSERT INTO tsg_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Sakali pagkitaꞌ sin manga tau duun sin muꞌjijat nahinang hi Īsa, laung nila pakaniya-pakaniya, “Tantu amuna sa ini in nabi amu in piyagꞌiyan mari pa dunya!” ");
INSERT INTO tsg_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Na, asal kiyaingatan hi Īsa sin in manga tau sūng na mawn sumaggaw kaniya iban lugusun nila siya mahinang sultan nila. Hangkan timukad siya pa taas būd-būd isa-isa niya. ");
INSERT INTO tsg_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Sakali naabut mayan magrib, limūd na in manga mulid hi Īsa madtu pa higad dagat, ");
INSERT INTO tsg_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ampa sila simakat pa taas kumpit asibiꞌ. Na, pagga narūm na, walaꞌ pa nakakawn hi Īsa kanila, timulak na sila harap pa Kapirnaum. ");
INSERT INTO tsg_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Sakali kiyugdan sila sin hangin makusug ha dān iban alun dakulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nakarayung mayan sila kulang-labi lima usuk batu, kītaꞌ nila na hi Īsa miyamanaw ha babaw sin dagat sūng mawn pa kumpit nila. Na, miyugaꞌ tuud sila. ");
INSERT INTO tsg_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Sakali laung hi Īsa kanila, “Ayaw kamu mabugaꞌ. Aku sa ini.” ");
INSERT INTO tsg_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Na, piyasakat nila na hi Īsa pa taas kumpit. Nakasakat mayan hi Īsa, saruun-duun dimatung sila pa lugal kadtuun nila. ");
INSERT INTO tsg_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Na, naadlaw mayan, in manga tau mataud (bakas piyakaun hi Īsa), masi duun ha hansipak sin Dagat Jalil. Kītaꞌ nila sin hambuuk kumpit asibiꞌ in nakatulak dayn duun. Iban kiyaingatan nila sin hi Īsa walaꞌ nakaagad ha manga mulid niya timulak. ");
INSERT INTO tsg_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Na, awn isab manga kumpit asibiꞌ dayn ha dāira Tibiri in dimungguꞌ mawn pa lugal masuuk pa bakas piyagkaunan sin manga tau mataud pagꞌubus hi Panghuꞌ Īsa nagsarang-sukul pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Manjari pagꞌingat sin manga tau sin walaꞌ na duun hi Īsa iban sin manga mulid niya, simakat na sila pa manga kumpit asibiꞌ harap pa Kapirnaum naglawag kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pagdatung sin manga tau mawn pa hansipak sin Dagat Jalil, kiyabaakan nila na hi Īsa. Laung nila kaniya, “Tuwan, kaꞌnu kaw dimatung mari?” ");
INSERT INTO tsg_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","In sambung hi Īsa kanila, “Baytaan ta kamu sin mattan. Hangkan niyu aku liyawag sabab kiyansuban kamu sin kakaun kahapun, sagawaꞌ walaꞌ nakasūd pa lawm pikilan niyu bang unu in hātihan sin manga muꞌjijat nahinang ku, amu in kītaꞌ niyu. ");
INSERT INTO tsg_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Subay in pagsangsaan niyu bukun sadja amu in kakaun diꞌ da tumatas malugay. Sagawaꞌ subay labi niyu pagsangsaan in kakaun diꞌ magkahagin salama-lama, amu in hikarihil kaniyu sin aku, amu in Anak Mānusiyaꞌ. Aku tuud in makarihil kaniyu sin kakaun yan, sabab aku in kiyawakilan sin Tuhan, Amaꞌ ku, dumihil ha yan.” ");
INSERT INTO tsg_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Na, iyasubu nila hi Īsa, laung nila, “Unu bahaꞌ in subay namuꞌ hinangun bat namuꞌ maagad in kabayaan sin Tuhan?” ");
INSERT INTO tsg_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","In sambung hi Īsa kanila, “Biyaꞌ ha ini in kabayaan sin Tuhan hipahinang kaniyu. Subay kamu magparachaya tuud kākuꞌ amu in kiyawakilan sin Tuhan mari.” ");
INSERT INTO tsg_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","In sambung nila, “Unu in muꞌjijat mapakitaꞌ mu kāmuꞌ, tandaꞌ sin barakat mu ha supaya kami magparachaya kaymu? Ha waktu sin manga kamaasan natuꞌ yadtu didtu ha hulaꞌ paslangan mahunit paghulaan, in kiyaun nila, amu in pagtawagun ‘manna’, hūg dayn ha langit. Biyaꞌ na sin kiyabaytaꞌ ha lawm Kitab, amu agi, ‘Patulunan niya sila kakaun dayn ha surgaꞌ!’ Na, in ikaw unu in mahinang mu?” laung sin manga tau kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","In sambung hi Īsa kanila, “Baytaan ta kamu sin kasabunnalan. Bukun hi Musa in nagdihil sin kakaun dayn ha surgaꞌ ha manga kamaasan natuꞌ yadtu. In Tuhan, Amaꞌ ku, amu in nagdihil kanila sin kakaun dayn ha surgaꞌ. Siya da isab in dumihil sin kakaun sabunnal. ");
INSERT INTO tsg_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Karnaꞌ in kakaun hirihil sin Tuhan amuna in naraak niya piyanaug dayn ha surgaꞌ mari pa dunya, amu in dumihil ha manga mānusiyaꞌ sin kabuhiꞌ sabunnal.” ");
INSERT INTO tsg_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Na, laung sin manga tau kan Īsa, “Tuwan, taptap kami dihili sin kakaun piyagꞌiyan mu yan.” ");
INSERT INTO tsg_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Laung hi Īsa kanila, “Aku na ini in kakaun amu in makarihil sin kabuhiꞌ. Hisiyu-siyu in mari magad kākuꞌ diꞌ na siya hapdiun kasaumulan, iban hisiyu-siyu in magparachaya kākuꞌ, diꞌ na siya uhawun kasaumulan. ");
INSERT INTO tsg_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Na, bakas ta na kamu biyaytaan sin minsan niyu aku kakitaan na, diꞌ da kamu magparachaya kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Sagawaꞌ in sasukuꞌ sin asal kiyasukuꞌ kākuꞌ sin Tuhan, Amaꞌ ku, magparachaya da iban mari da magad kākuꞌ. Na, taymaun ku tuud in hisiyu-siyu mari magad kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sabab in maksud ku miyari pa dunya dayn ha surgaꞌ bukun huminang sin kabayaan ku, sagawaꞌ huminang sin kabayaan sin Tuhan amu in nagdaak kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na, in kabayaan sin Tuhan amu in nagdaak kākuꞌ, subay wayruun malawaꞌ dayn kākuꞌ minsan hambuuk dayn ha manga asal kiyasukuꞌ niya kākuꞌ. Lāgiꞌ subay ku sila buhiun katān magbalik dayn ha kamatay ha adlaw mahuli. ");
INSERT INTO tsg_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Karnaꞌ in kabayaan sin Tuhan, Amaꞌ ku, in sasukuꞌ sin makakitaꞌ kākuꞌ, amu in Anak Tuhan, iban nagparachaya kākuꞌ, subay dihilan kabuhiꞌ salama-lama, iban ha adlaw mahuli buhiun ku sila magbalik dayn ha kamatay.” ");
INSERT INTO tsg_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Na, kimangīꞌ in atay sin manga tau pasal sin pamung hi Īsa sin in siya amuna in kakaun dayn ha surgaꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Hangkan piyagbicharahan nila in pamung hi Īsa, laung nila, “Maytaꞌ in tau ini imiyan dayn ha surgaꞌ siya? Bukun ka in siya hi Īsa, anak hi Yusup? Kaingatan natuꞌ in inaꞌ-amaꞌ niya.” ");
INSERT INTO tsg_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","In sambung hi Īsa kanila, “Hundung na kamu magbichara biyaꞌ ha yan. ");
INSERT INTO tsg_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Way tau mari magad kākuꞌ bang siya diꞌ dihilan bayaꞌ sin Tuhan, Amaꞌ ku, amu in nagdaak kākuꞌ mari. Iban buhiun ku siya magbalik dayn ha kamatay ha adlaw mahuli. ");
INSERT INTO tsg_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kiyasulat sin manga kanabihan ha lawm Kitab, amu agi, ‘In katān mānusiyaꞌ hinduan sin Tuhan.’ Na,” laung hi Īsa, “hisiyu-siyu in makarungug iban magkahagad sin hinduꞌ sin Tuhan, Amaꞌ ku, mari da siya magad kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Malayngkan bukun in hāti niya yan bat awn nakakitaꞌ ha Tuhan, sabab amura aku in nakakitaꞌ ha Tuhan, Amaꞌ ku, karnaꞌ in aku dayn ha Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Laung pa isab hi Īsa, “Baytaan ta kamu sin kasabunnalan. Hisiyu-siyu in magparachaya kākuꞌ awn kabuhiꞌ niya salama-lama. ");
INSERT INTO tsg_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Aku na ini in kakaun amu in makarihil sin kabuhiꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","In manga kaapuꞌ-apuan niyu yadtu miyatay da didtu ha hulaꞌ paslangan mahunit paghulaan, minsan ‘manna’ in kiyaun nila. ");
INSERT INTO tsg_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Sagawaꞌ in kakaun dayn ha surgaꞌ piyagꞌiyan ku kaniyu dugaing tuud. Hisiyu-siyu in makakaun ha yan diꞌ siya mapatay. ");
INSERT INTO tsg_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Aku na ini in kakaun dayn ha surgaꞌ amu in puunan sin katān kabuhiꞌ. Hisiyu-siyu in kumaun sin kakaun ini awn kabuhiꞌ niya salama-lama. In kakaun hipakaun ku kaniya amuna in unud ku. Hilillaꞌ ku in duguꞌ-nyawa ku ha supaya awn kabuhiꞌ sin mānusiyaꞌ katān.” ");
INSERT INTO tsg_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Na, nagpasuꞌ in paglugat sin manga tau pasal sin pamung hi Īsa. Laung nila, “Biyaꞌ diin in kaagi sin tau ini magpakaun kātuꞌ sin unud niya?” ");
INSERT INTO tsg_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Laung hi Īsa kanila, “Baytaan ta kamu sin kasabunnalan. Bang kamu diꞌ kumaun sin unud ku amu in Anak Mānusiyaꞌ, iban diꞌ minum sin duguꞌ ku wayruun kabuhiꞌ niyu. ");
INSERT INTO tsg_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Hisiyu-siyu in kumaun sin unud ku iban minum sin duguꞌ ku awn kabuhiꞌ niya salama-lama, iban buhiun ku siya magbalik dayn ha kamatay ha adlaw mahuli. ");
INSERT INTO tsg_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Sabab in unud ku iban duguꞌ ku amuna in kakaun iban iinumun diꞌ magkahagin sampay kasaumulan. ");
INSERT INTO tsg_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Hisiyu-siyu in kumaun sin unud ku iban minum sin duguꞌ ku, in pikilan iban atay niya himahambuuk kākuꞌ. Damikkiyan, in aku himahambuuk da isab kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","In Tuhan, Amaꞌ ku, amu in nagdaak kākuꞌ mari. Asal siya in puunan sin katān kabuhiꞌ. Na, dayn ha sabab niya awn kabuhiꞌ ku. Damikkiyan biyaꞌ da isab ha yan in hisiyu-siyu kumaun kākuꞌ, awn kabuhiꞌ niya dayn ha sabab ku. ");
INSERT INTO tsg_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Na, aku in tantu tuud kakaun dayn ha surgaꞌ. Bukun biyaꞌ sin kakaun kiyaun sin manga kaapuꞌ-apuan niyu yadtu. Sabab minsan sila kimaun hādtu, miyatay da sila. Sagawaꞌ hisiyu-siyu in kumaun sin kakaun tantu tuud dayn ha surgaꞌ, awn kabuhiꞌ niya kasaumulan.” ");
INSERT INTO tsg_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Amu yan in manga hinduꞌ hi Īsa didtu ha lawm sin langgal ha Kapirnaum. ");
INSERT INTO tsg_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Na, kamatauran sin manga mulid hi Īsa nakarungug sin pagnasīhat niya. Laung nila, “In hinduꞌ niya yan mahunit agarun. Wayruun mabayaꞌ dumungug ha yan!” ");
INSERT INTO tsg_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Sakali asal kiyatalusan hi Īsa in piyagdubduban sin manga tau. Hangkan laung niya kanila, “Marayꞌ kimangīꞌ in atay niyu sin hinduꞌ ku. ");
INSERT INTO tsg_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Na, marayꞌ lubaꞌ pa in ngīꞌ sin atay niyu bang niyu kakitaan in aku amu in Anak Mānusiyaꞌ, magbalik pa surgaꞌ (amu in asal hulaan ku). ");
INSERT INTO tsg_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","In Rū sin Tuhan amuna in makarihil sin kabuhiꞌ sabunnal. Bang baran-baran niyu hadja wayruun kabuhiꞌ sabunnal makawaꞌ niyu. In hinduꞌ ku amu in makarihil kaniyu kabuhiꞌ sabunnal sabab in yan guwaꞌ dayn ha Rū sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Sagawaꞌ,” laung hi Īsa, “in kaibanan kaniyu diꞌ magparachaya.” (Hangkan hi Īsa namung biyaꞌ ha ini sabab asal niya kiyaingatan dayn sin tagnaꞌ bang hisiyu in manga tau diꞌ magparachaya kaniya iban bang hisiyu in tumipu kaniya ha susūngun.) ");
INSERT INTO tsg_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Laung pa isab hi Īsa, “Hangkan asal ta kamu biyaytaan sin way tau mari magad kākuꞌ bang siya bukun dihilan bayaꞌ sin Tuhan, Amaꞌ ku.” ");
INSERT INTO tsg_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Na, dayn ha sabab sin pamung hi Īsa, mataud in manga mulid niya minīg, iban walaꞌ na miyagad kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Hangkan iyasubu hi Īsa in hangpuꞌ tagduwa mulid niya, laung niya, “Na, biyaꞌ diin in kamu yan? Mabayaꞌ isab kamu mīg biyaꞌ kanila?” ");
INSERT INTO tsg_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","In sambung hi Simun Pitrus kaniya, “Tuwan, hisiyu pa in kadtuan namuꞌ dugaing dayn kaymu? Amura hinduꞌ mu in makarihil sin kabuhiꞌ salama-lama. ");
INSERT INTO tsg_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Magparachaya na tuud kami kaymu bihaun iban kaingatan namuꞌ na tuud sin ikaw na in hambuuk-buuk mahasuchi naug dayn ha Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","In sambung hi Īsa, “In kamu hangpuꞌ tagduwa napīꞌ ku magad kākuꞌ. Sagawaꞌ in hambuuk kaniyu saytan.” ");
INSERT INTO tsg_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","In piyagꞌiyan hi Īsa hi Judas amu in anak hi Simun tau dayn ha Kiriyud. In hi Judas hambuuk sin manga hangpuꞌ tagduwa mulid hi Īsa, sagawaꞌ siya in timipu kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pagꞌubus yadtu miyanaw hi Īsa ha lawm hulaꞌ Jalil. Diꞌ siya mabayaꞌ madtu pa lawm hulaꞌ Yahudiya sabab biyabantuhan siya bunuun sin manga nakuraꞌ Yahudi. ");
INSERT INTO tsg_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Sakali masuuk na in Paghaylaya amu in waktu sin manga Yahudi maghantiꞌ ha manga kūbung-kūbung. ");
INSERT INTO tsg_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Hangkan laung sin manga taymanghud usug hi Īsa kaniya, “Subay kaw diꞌ dimī. Subay kaw madtu pa Yahudiya ha supaya kakitaan sin manga mulid mu in hinang mu. ");
INSERT INTO tsg_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Wayruun tau magtapuk sin hinang niya bang siya mabayaꞌ mabantug. Na, pagga kaw makahinang sin manga muꞌjijat, na kadtu kaw paingata in mānusiyaꞌ katān sin pasal mu!” Na, amu yan in bichara sin manga taymanghud hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Minsan in manga taymanghud tuud hi Īsa diꞌ da magparachaya kaniya.) ");
INSERT INTO tsg_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Laung hi Īsa kanila, “Walaꞌ pa naabut in waktu ku madtu magpakitaꞌ kanila. Bukun aku biyaꞌ kaniyu makakadtu minsan kuꞌnu waktu. ");
INSERT INTO tsg_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Sabab in kamu diꞌ karugalan sin manga tau. Ampa in aku karugalan nila sabab daran ku sila biyabaytaan sin mangīꞌ in hinang nila. ");
INSERT INTO tsg_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kadtu na kamu pa paghaylayahan. Diꞌ pa aku madtu pa paghaylayahan, sabab walaꞌ pa naabut in waktu ku madtu.” ");
INSERT INTO tsg_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Na, amu yan in pamung hi Īsa ha manga taymanghud niya. Nagpabīn siya na muna ha Jalil. ");
INSERT INTO tsg_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Sakali nakataykud mayan in manga taymanghud niya, miyadtu hi Īsa imurul pa paghaylayahan. Sagawaꞌ tapuk kaagi in pagkadtu niya hangkan walaꞌ nakaingat in manga tau sin yaun siya ha paghaylayahan. ");
INSERT INTO tsg_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Manjari didtu ha paghaylayahan piyaglawag hi Īsa sin manga nakuraꞌ Yahudi. Piyangasubu nila bang hawnu hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mataud tau ha paghaylayahan in naghagas-hagas pasal hi Īsa. Laung sin kaibanan, “In hi Īsa tau marayaw.” Sagawaꞌ laung isab sin kaibanan, “Bukun siya tau marayaw, sabab mangdupang sadja siya ha manga tau.” ");
INSERT INTO tsg_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Sagawaꞌ wayruun minsan hambuuk tau in timawakkal nagpatampal namichara pasal hi Īsa sabab mabugaꞌ sila ha manga nakuraꞌ Yahudi. ");
INSERT INTO tsg_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Marayꞌ mayan matungaꞌ in paghaylaya, miyadtu hi Īsa pa halaman sin Bāy sin Tuhan nanghinduꞌ ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Na, nainu-inu tuud in manga nakuraꞌ Yahudi sin paghinduꞌ hi Īsa. Laung nila, “Dayn diin bahaꞌ nakawaꞌ sin tau ini in ingat niya sin walaꞌ siya minsan nakapangadjiꞌ?” ");
INSERT INTO tsg_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","In sambung hi Īsa kanila, “In panghinduꞌ ku ini bukun dayn ha ingat ku, sagawaꞌ dayn ha Tuhan amu in nagdaak kākuꞌ mari. ");
INSERT INTO tsg_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Bang in tau matuyuꞌ tuud magad ha kabayaan sin Tuhan, tantu kaingatan niya bang in panghinduꞌ ku ini dayn ha Tuhan atawa dayn ha baran ku sadja. ");
INSERT INTO tsg_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Sabab, bang in tau manghinduꞌ dayn ha ingat niya sadja, hāti niya in tau yan kumāꞌ sadja kalagguan pa baran niya. Sagawaꞌ bang in tau yan matuyuꞌ manglagguꞌ ha nagdaak kaniya, hāti niya in tau yan mabuntul iban bukun siya pangakkal. ");
INSERT INTO tsg_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Binīn hi Musa kaniyu in saraꞌ daakan sin Tuhan, sagawaꞌ minsan hambuuk kaniyu wayruun da namawgbug sin saraꞌ yan. Na, maytaꞌ aku in kabayaan niyu patayun?” ");
INSERT INTO tsg_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Laung sin manga tau kan Īsa, “Siyasaytan kaw tuud yan! Wayruun sān tau mabayaꞌ mamunuꞌ kaymu.” ");
INSERT INTO tsg_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","In sambung hi Īsa kanila, “Hambuuk da muꞌjijat in nahinang ku ha adlaw paghali-hali iban pagpudji pa Tuhan, hāti magtūy na kamu nainu-inu katān. ");
INSERT INTO tsg_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","In daakan binīn kaniyu hi Musa, subay niyu islamun in manga anak niyu usug. Sagawaꞌ in saraꞌ yan timagnaꞌ dayn ha manga kaapuꞌ-apuan niyu, amu in nakauna pa dayn kan Musa. Hangkan minsan adlaw paghali-hali iban pagpudji pa Tuhan mangꞌislam da kamu ha anak niyu usug. ");
INSERT INTO tsg_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Na, pagga kamu mangꞌislam ha manga anak niyu minsan adlaw paghali-hali iban pagpudji pa Tuhan ha supaya niyu maagad in saraꞌ daakan hi Musa, na maytaꞌ kamu dugalan kākuꞌ sawkat na aku nagpauliꞌ ha tau nāsakit ha adlaw paghali-hali iban pagpudji pa Tuhan? ");
INSERT INTO tsg_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ayaw kamu magtūy magpikil sin in aku tau mangīꞌ, sawkat na kamu walaꞌ kiyaamuhan sin hinang ku. Gām mayan pabuntula in pamikil niyu.” ");
INSERT INTO tsg_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Na, awn manga kaibanan tau duun dayn ha Awrusalam (Baytal Makdis) in nagbichara pasal hi Īsa. Laung nila, “Bukun ka in tau yan amu in piyaglalawag sin manga nakuraꞌ natuꞌ Yahudi, kabayaan nila patayun? ");
INSERT INTO tsg_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kitaa niyu ba, yaun siya namimichara ha mayran madjīlis, sagawaꞌ diꞌ siya minsan lāngun sin manga nakuraꞌ. Marayꞌ nakaingat na tuud in manga nakuraꞌ sin hi Īsa amuna in Almasi, amu in kiyawakilan sin Tuhan magbayaꞌ ha bangsa natuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Sagawaꞌ,” laung sin manga tau, “bang kunuꞌ mari in Almasi wayruun makaingat bang dayn diin siya. Sagawaꞌ in hi Īsa ini kaingatan natuꞌ bang dayn diin siya.” ");
INSERT INTO tsg_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Na, kiyaingatan hi Īsa in piyagbichara nila. Hangkan, piyatanug niya in tingug niya ha saꞌbu niya nanghihinduꞌ ha halaman sin Bāy sin Tuhan. Laung niya, “Bunnal kaingatan niyu aku iban kaingatan niyu bang dayn diin aku, saꞌ walaꞌ aku miyari dayn ha bayaꞌ ku sadja, sagawaꞌ naraak aku mari sin Tuhan amu in diꞌ magputing. Diꞌ niyu kaingatan bang hisiyu tuud siya, ");
INSERT INTO tsg_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","sagawaꞌ kaingatan ku siya sabab dayn didtu aku kaniya iban siya in nagdaak kākuꞌ mari.” ");
INSERT INTO tsg_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Manjari apit nila saggawun hi Īsa, sagawaꞌ way minsan hambuuk in nakakaput kaniya sabab walaꞌ pa naabut in waktu sin pagpatay kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Sagawaꞌ mataud in manga tau nagparachaya kan Īsa. Laung nila, “Way na tau dugaing tagaran natuꞌ magbayaꞌ ha bangsa natuꞌ. Hi Īsa na tuud in Almasi sabab way na makaliyu sin taud sin muꞌjijat nahinang hi Īsa.” ");
INSERT INTO tsg_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Sakali diyungug sin manga Parisi bang unu in piyaghagas-hagasan sin manga tau pasal hi Īsa. Hangkan in manga Parisi iban sin manga nakuraꞌ kaimaman magtūy nagdaak manga pulis jaga madtu sumaggaw kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Na, laung hi Īsa ha manga tau natitipun duun, “In aku diꞌ makalugay dī kaniyu. Masuuk na aku muwiꞌ magbalik pa nagdaak kākuꞌ mari. ");
INSERT INTO tsg_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Lawagun niyu aku, sagawaꞌ diꞌ niyu aku kabaakan, sabab diꞌ kamu makakadtu pa hulaan uwian ku.” ");
INSERT INTO tsg_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Na, nagbichara in manga nakuraꞌ Yahudi pakaniya-pakaniya, “Pakain bahaꞌ in kadtuan sin tau ini ha diꞌ natuꞌ siya kabaakan? Marayꞌ madtu siya pa manga dāira sin bangsa Girik, amu in piyaghuhulaan sin manga pagkahi natuꞌ hangka-bangsa, amu in napulak-palik ha kahulaꞌ-hulaan. Marayꞌ madtu siya manghinduꞌ ha manga bangsa Girik. ");
INSERT INTO tsg_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Laung niya, lawagun natuꞌ siya sagawaꞌ diꞌ natuꞌ siya kabaakan, iban diꞌ kitaniyu makakadtu pa hulaꞌ kadtuan niya. Unu bahaꞌ in hātihan sin bichara niya yan?” ");
INSERT INTO tsg_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na, naabut mayan in adlaw umbulsatu amu in kahinapusan na sin pagjamu, timindug hi Īsa ampa niya piyatanug in bichara niya, laung niya, “Hisiyu-siyu kamu in mauhaw, kari kamu kākuꞌ, painumun ta kamu. ");
INSERT INTO tsg_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Biyaꞌ na sin kiyabaytaꞌ ha lawm Kitab, ‘Hisiyu-siyu in magparachaya kākuꞌ, awn biyaꞌ sapantun tubig tumubud way pagbugtuꞌ dayn ha lawm atay niya, amu in makarihil kaniya kabuhiꞌ tantu.’” ");
INSERT INTO tsg_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","In piyagbichara hi Īsa ini pasal sin Rū sin Tuhan, amu in tumulun pa hisiyu-siyu magparachaya kaniya. Sagawaꞌ ha waktu yadtu in Rū sin Tuhan walaꞌ pa timulun pa mānusiyaꞌ, sabab walaꞌ pa naabut in waktu sin pagpakitaꞌ sin Tuhan sin kalagguan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Na, pagdungug sin manga tau mataud sin bichara hi Īsa, laung sin kaibanan, “Tantu in tau ini amuna in nabi piyagtatagaran natuꞌ!” ");
INSERT INTO tsg_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Laung isab sin kaibanan, “Siya na yan in Almasi!” Sagawaꞌ laung isab sin kaibanan, “In Almasi diꞌ gumuwaꞌ dayn ha Jalil! ");
INSERT INTO tsg_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Sabab kiyabaytaꞌ ha lawm Kitab sin in Almasi hambuuk panubuꞌ hi Sultan Daud iban hipagꞌanak siya ha Baytlaham, amu in kawman hulaan hi Daud.” ");
INSERT INTO tsg_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Na, nabahagiꞌ in pikilan sin manga tau pasal hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","In kaibanan tau mabayaꞌ sumaggaw kaniya, sagawaꞌ way minsan hambuuk in nakakaput kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Na, sakali nakabalik na in manga pulis jaga. Iyasubu sila sin manga Parisi iban sin manga nakuraꞌ kaimaman, amu agi, “Maytaꞌ niyu siya walaꞌ diyā mari?” ");
INSERT INTO tsg_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","In sambung sin manga jaga, “Wayruun pa tau in nakapanghinduꞌ biyaꞌ sin dayaw sin panghinduꞌ niya!” ");
INSERT INTO tsg_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Laung sin manga Parisi ha manga jaga, “Sampay tuwiꞌ kamu narupang niya da! ");
INSERT INTO tsg_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Wayruun minsan hambuuk nakuraꞌ Yahudi atawa Parisi in magparachaya kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Amura sa yan in magparachaya kaniya in manga tau yan amu in awam sin saraꞌ daakan hi Musa. Hangkan sa in sila yan piyagmumurkaan sin Tuhan!” ");
INSERT INTO tsg_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Sakali namichara hi Nikudimus amu in hambuuk Parisi bakas miyadtu kan Īsa. Laung niya, ");
INSERT INTO tsg_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Bang ha saraꞌ natuꞌ diꞌ manjari in tau butangan hukuman bang siya walaꞌ pa nasumariya iban diꞌ pa kaingatan bang unu in saraꞌ nalanggal niya.” ");
INSERT INTO tsg_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","In sambung nila, “Uy! Marayꞌ kaw isab yan tau dayn ha Jalil. Kitaa madtu pa lawm Kitab bat mu kaingatan sin wayruun tuud nabi in guwaꞌ dayn ha Jalil.” ");
INSERT INTO tsg_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pagꞌubus yadtu, in tau katān nagꞌuwiꞌ na. ");
INSERT INTO tsg_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Sagawaꞌ in hi Īsa miyadtu pa Būd Jaytun. ");
INSERT INTO tsg_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pagmahinaat, subu-subu pa miyadtu siya nagbalik pa halaman sin Bāy sin Tuhan. Na, in manga tau mataud nagtipun na isab katān mawn kaniya. Na limingkud hi Īsa ampa siya nanghinduꞌ na isab ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Sakali miyawn in manga guru sin saraꞌ agama iban manga Parisi nagdā sin hambuuk babai bakas iyabutan nagjina iban sin usug bukun halal kawin niya. Piyatindug nila in babai ha alupan sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Laung nila kan Īsa, “Tuwan Guru, in babai ini mattan tuud iyabutan nagjina iban sin usug bukun halal kawin niya. ");
INSERT INTO tsg_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ha lawm saraꞌ daakan hi Musa in babai abutan maghinang biyaꞌ ha yan subay tiluun sin batu patayun. Na, bang ikaw, unu in hukuman hirihil natuꞌ kaniya?” ");
INSERT INTO tsg_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Na, namung sila biyaꞌ ha yan bat nila malusut hi Īsa ha bichara, hāti makabāk sila dān hikatuntut kan Īsa. Sagawaꞌ imanduk hi Īsa ampa siya nagsulat ha lupaꞌ iban sin tudluꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Sagawaꞌ masi namān sila nangangasubu. Na, timunga hi Īsa ampa siya namung. Laung niya, “Hisiyu-siyu kaniyu in wayruun tuud dusa makajari na tumiluꞌ batu ha babai yan.” ");
INSERT INTO tsg_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Pagꞌubus imanduk siya nagbalik ampa siya nagsulat ha lupaꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pagdungug nila sin pamung hi Īsa, nagꞌinut-inut sila minīg hambuuk-hambuuk. Miyuna in manga tau maas ampa simunud in katān. Na, amura hi Īsa in nakapin duun iban sin babai masi nagtitindug. ");
INSERT INTO tsg_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Timunga hi Īsa ampa siya namung ha babai, laung niya, “Indaꞌ, hawnu na in manga tau? Way na minsan hangka-tau nakapin mutang kaymu hukuman?” ");
INSERT INTO tsg_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","In sambung sin babai, “Way na, Tuwan.” “Na, marayaw na,” laung hi Īsa, “minsan in aku, diꞌ da isab mutang kaymu sin hukuman patayun. Kadtu na kaw uwiꞌ, sagawaꞌ ayaw na kaw maghinang magbalik sin makarusa.” ");
INSERT INTO tsg_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Pagꞌubus yadtu namichara na isab hi Īsa nagbalik ha manga tau. Laung niya, “Aku in ilaw amu in makarihil kasawahan ha mānusiyaꞌ. Hisiyu-siyu in magad kākuꞌ, kasaumulan diꞌ na siya manaw ha katigidluman sabab awn na kasawahan niya amu in makarihil kaniya sin kabuhiꞌ tantu.” ");
INSERT INTO tsg_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Laung sin manga Parisi kaniya, “In ikaw yan magsaksiꞌ sin baran mu. Bang in tau magsaksiꞌ sin baran niya wayruun tau magkahagad kaniya.” ");
INSERT INTO tsg_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","In sambung hi Īsa kanila, “Minsan aku magsaksiꞌ sin baran ku, bunnal in bichara ku sabab kaingatan ku bang dayn hayn in giyuwaan ku iban kaingatan ku da isab bang harap pakain in kadtuun ku. Sagawaꞌ in kamu diꞌ niyu kaingatan bang dayn diin in giyuwaan ku iban bang harap pakain in kadtuun ku. ");
INSERT INTO tsg_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","In kamu in panaraꞌ niyu ha tau labay dayn ha pikilan sadja sin mānusiyaꞌ. Ampa in aku diꞌ aku manaraꞌ ha tau minsan hisiyu. ");
INSERT INTO tsg_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Malayngkan,” laung hi Īsa, “bang aku in manaraꞌ, mabuntul sadja in hukuman ku sabab bukun isa-isa ku in manaraꞌ. Duwa kami iban sin Amaꞌ ku amu in nagdaak kākuꞌ mari. ");
INSERT INTO tsg_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Biyaꞌ na sin kiyabaytaꞌ ha lawm saraꞌ niyu, bang awn duwangka-tau sumaksiꞌ ampa magtaayun in daawa nila, hāti niya bunnal in bichara nila. ");
INSERT INTO tsg_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na, ha tungud sin kasabunnalan sin bichara ku, awn da isab duwa saksiꞌ, aku baran ku iban sin Amaꞌ ku amu in nagdaak kākuꞌ mari.” ");
INSERT INTO tsg_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Imasubu in manga Parisi kan Īsa, amu agi, “Hariin in amaꞌ mu?” Sagawaꞌ in sambung hi Īsa, “Bang niyu aku diꞌ kaingatan tantu diꞌ niyu isab kaingatan in Amaꞌ ku, sabab bang niyu kaingatan bang hisiyu aku, tantu kaingatan niyu da isab bang hisiyu in Amaꞌ ku.” ");
INSERT INTO tsg_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Na, in manga yan kiyabichara hi Īsa ha saꞌbu siya nanghihinduꞌ didtu ha halaman sin Bāy sin Tuhan, masuuk ha bilik kiyabutangan sin paghuhulugan sarakka. Wayruun tau makasaggaw kaniya sabab walaꞌ pa naabut in waktu kiyagantaꞌ sin Tuhan pagsaggaw kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Manjari biyalikan na isab hi Īsa in bichara niya ha manga tau. Laung niya, “In aku ini sūng na magꞌīg dayn dī. Minsan biyaꞌ diin in paglawag niyu kākuꞌ, diꞌ niyu aku kabaakan. Sampay sadja kamu mapatay diꞌ kamu mapuas dayn ha dusa hangkan diꞌ kamu makaurul pa kadtuan ku.” ");
INSERT INTO tsg_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Na, nagꞌasubu-iyasubuhi na in manga nakuraꞌ Yahudi, laung nila, “Unu bahaꞌ in hātihan sin bichara niya diꞌ kitaniyu makaurul pa kadtuan niya? Marayꞌ siya magpatay sin baran niya!” ");
INSERT INTO tsg_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","In sambung hi Īsa kanila, “In manga kamu yan tau dī ha dunya. Ampa in aku ini dayn ha surgaꞌ. In katān pikilan niyu yan pikilan sin tau dunya, sagawaꞌ in aku bukun biyaꞌ sin pikilan niyu. ");
INSERT INTO tsg_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Hangkan biyaytaan ta kamu sin diꞌ kamu mapuas dayn ha dusa niyu sampay sadja kamu mapatay. Bang kamu diꞌ magkahagad sin baytaꞌ ku kaniyu ha pasal sin baran ku, bang hisiyu aku, na biyaꞌ na sin agi ku kaniyu sampay sadja kamu mapatay, diꞌ da mapuas in dusa niyu.” ");
INSERT INTO tsg_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Laung nila kan Īsa, “Maytaꞌ, hisiyu ba kaw tuud yan?” Laung hi Īsa, “Bakas ta na kamu biyaytaan dayn sin tagnaꞌ bang hisiyu aku. ");
INSERT INTO tsg_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mataud pa in hibichara ku pasal sin manga hinang iban addat niyu amu in mapatut ku butangan hukuman sabab amuna in kabayaan sin nagdaak kākuꞌ mari. Lāgiꞌ in katān baytaꞌ niya bunnal. Amura in biyaytaꞌ ku ha manga tau dī ha dunya in diyungug ku dayn kaniya.” ");
INSERT INTO tsg_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Na, walaꞌ kiyahātihan sin manga tau in piyagbichara hi Īsa pasal sin Tuhan, Amaꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Hangkan laung hi Īsa kanila, “Bang maabut na in waktu in aku amu in Anak Mānusiyaꞌ, hikalansang niyu na pa usuk pagpatayan ampa in usuk yan patindugun, na duun niyu na kaingatan bang hisiyu aku. Lāgiꞌ kaingatan niyu da isab sin walaꞌ aku nagbayaꞌ-bayaꞌ naghinang unu-unu sin baran-baran ku sadja, sagawaꞌ amura in hinduꞌ ku ha manga tau in daakan kākuꞌ sin Amaꞌ ku. ");
INSERT INTO tsg_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Taptap aku tiyatabang iban biyabawgbugan sin nagdaak kākuꞌ mari pa dunya. Walaꞌ niya aku piyasāran, sabab in hīhinang ku sadja amuna in unu-unu na makasulut kaniya.” ");
INSERT INTO tsg_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Na, mataud in manga tau nakarungug sin pamung hi Īsa nagparachaya na kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Manjari namung hi Īsa ha manga Yahudi amu in nagparachaya kaniya, laung niya, “Bang niyu kahagarun tuud in hinduꞌ ku kaniyu, in kamu yan mattan tuud mulid ku. ");
INSERT INTO tsg_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Makaingat na kamu sin kasabunnalan tuud dayn ha Tuhan. In yan amu in makalimaya kaniyu dayn ha namamanyagaꞌ kaniyu.” ");
INSERT INTO tsg_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","In sambung sin manga Yahudi, “In kami ini panubuꞌ hi Ibrahim. Walaꞌ kami nabanyagaꞌ dayn sin tagnaꞌ. Maytaꞌ kaw imiyan malimaya kami dayn ha namamanyagaꞌ kāmuꞌ?” ");
INSERT INTO tsg_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","In sambung hi Īsa kanila, “Baytaan ta kamu sin kasabunnalan. Hisiyu-siyu in mabayaꞌ sadja huminang sin makarusa, in siya yan mahinang banyagaꞌ sin bayaꞌ niya huminang sin makarusa. ");
INSERT INTO tsg_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Biyaꞌ na sin kiyaingatan niyu, in banyagaꞌ bukun lahasiyaꞌ sin tagbanyagaꞌ kaniya. Hangkan kuꞌnu-kuꞌnu waktu mabutas sila. Sagawaꞌ in anak iban sin amaꞌ diꞌ mabugtuꞌ in pagtalianak nila. ");
INSERT INTO tsg_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Hangkan bang kamu puasun sin amu in Anak Tuhan, na tantu malimaya kamu dayn ha namamanyagaꞌ kaniyu. ");
INSERT INTO tsg_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kaingatan ku in kamu manga panubuꞌ hi Ibrahim. Sagawaꞌ mabayaꞌ kamu mamunuꞌ kākuꞌ sabab diꞌ niyu mataymaꞌ in kasabunnalan sin hinduꞌ ku. ");
INSERT INTO tsg_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","In biyaytaꞌ ku kaniyu amu in manga kītaꞌ ku didtu ha hulaan sin Amaꞌ ku, sagawaꞌ in kamu, in hīhinang niyu in baytaꞌ kaniyu sin amaꞌ niyu.” ");
INSERT INTO tsg_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","In sambung nila kan Īsa, “Hi Ibrahim in ītung namuꞌ amaꞌ.” Sagawaꞌ laung hi Īsa kanila, “Bang kamu bunnal tuud panubuꞌ hi Ibrahim, na subay niyu hinangun in biyaꞌ da isab sin nahinang hi Ibrahim. ");
INSERT INTO tsg_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Sagawaꞌ dugaing siya dayn kaniyu. In kamu kabayaan niyu aku patayun sawkat ta na kamu biyaytaan sin kasabunnalan diyungug ku dayn ha Tuhan. Na, in hi Ibrahim walaꞌ tuud nakahinang sin biyaꞌ ha yan! ");
INSERT INTO tsg_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","In hinang niyu yan biyaꞌ da tuud isab sin hinang sin amaꞌ niyu.” “Uy,” laung nila kan Īsa, “in Tuhan amura in hambuuk-buuk tuud Amaꞌ sin manga kami bangsa Yahudi. Iban in kami mattan tuud manga anak niya.” ");
INSERT INTO tsg_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Laung hi Īsa kanila, “Na, bang bunnal in Tuhan Amaꞌ niyu tuud, na lumasa kamu kākuꞌ, sabab in aku dayn ha Tuhan, hangkan yari aku dī kaniyu bihaun. Bukun aku miyari dayn ha bayaꞌ sadja sin baran ku, sagawaꞌ kiyawakilan aku sin Tuhan mari. ");
INSERT INTO tsg_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Hangkan na kamu diꞌ makahāti sin hinduꞌ ku sabab marugal tuud kamu ha hinduꞌ ku. ");
INSERT INTO tsg_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","In Iblis amu in amaꞌ niyu, hangkan amu in kabayaan niya in iyaagad niyu. In siya yan asal mamumunuꞌ dayn sin tagnaꞌ. Diꞌ siya mabayaꞌ sin kasabunnalan, sabab wayruun unu-unu kasabunnalan guwaꞌ dayn kaniya. In hinang niya magputing sadja, miyamagad na ha addat niya putingan. Asal siya putingan dayn sin tagnaꞌ iban siya na in puunan sin katān puting. ");
INSERT INTO tsg_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ampa in aku kasabunnalan in katān baytaꞌ ku kaniyu, hangkan diꞌ kamu magkahagad kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Hisiyu dī kaniyu in makaiyan in aku taga dusa? Na pagga kamu diꞌ makaiyan sin in aku taga dusa, na maytaꞌ kamu diꞌ magkahagad sin in baytaꞌ ku kaniyu kasabunnalan? ");
INSERT INTO tsg_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Bang in tau bunnal sukuꞌ sin Tuhan, tantu magkahagad siya sin hinduꞌ dayn ha Tuhan. Sagawaꞌ in kamu bukun sukuꞌ sin Tuhan, hangkan diꞌ kamu magkahagad sin hinduꞌ dayn kaniya.” ");
INSERT INTO tsg_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Laung sin manga nakuraꞌ Yahudi kan Īsa, “Bukun ka bunnal in agi namuꞌ in ikaw tau Samariya bukun tuud Yahudi, iban in ikaw siyasaytan?” ");
INSERT INTO tsg_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","In sambung hi Īsa, “Bukun aku siyasaytan, sabab liyalagguꞌ ku in Amaꞌ ku. Sagawaꞌ in kamu biyababaꞌ niyu aku. ");
INSERT INTO tsg_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Walaꞌ aku naglawag kalagguan pa baran ku. Sagawaꞌ awn da manglagguꞌ kākuꞌ. Siya in manghukum ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Baytaan ta kamu sin kasabunnalan. Hisiyu-siyu in magkahagad sin hinduꞌ ku, diꞌ tuud siya mapatay kasaumulan.” ");
INSERT INTO tsg_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Na, laung sin manga nakuraꞌ kan Īsa, “Bihaun kaingatan namuꞌ na tuud sin in ikaw siyasaytan! In kaapuꞌ-apuan namuꞌ hi Ibrahim iban sin manga kanabihan yadtu miyatay na. Sagawaꞌ laung mu hisiyu-siyu in magkahagad sin hinduꞌ mu diꞌ mapatay kasaumulan. ");
INSERT INTO tsg_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Maytaꞌ, ha pikil mu labi kaw makawasa dayn ha nanubuꞌ kāmuꞌ hi Ibrahim amu in miyatay na? Iban minsan in manga kanabihan miyatay da isab. Maytaꞌ pangannal mu hisiyu kaw?” ");
INSERT INTO tsg_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","In sambung hi Īsa, laung niya, “Bang sawpama in aku maglawag sadja kalagguan pa baran ku, in kalagguan yan way da pūs niya. Sagawaꞌ in manglagguꞌ kākuꞌ, in Amaꞌ ku, amu in piyagꞌiyan niyu Tuhan niyu. ");
INSERT INTO tsg_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Sagawaꞌ diꞌ niyu kaingatan tuud in Tuhan. Ampa in aku kaingatan ku tuud siya. Bang aku sawpama imiyan diꞌ ku kaingatan in Tuhan, na putingan da isab aku biyaꞌ kaniyu. Sagawaꞌ kaingatan ku tuud in Tuhan iban iyaagad ku in katān daakan niya. ");
INSERT INTO tsg_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","In hi Ibrahim amu in nanubuꞌ kaniyu kiyūgan tuud pagꞌingat niya sin dumatung da in waktu kakitaan niya aku mari pa dunya. Na, pagkitaꞌ niya sin pagkari ku kiyūgan tuud siya.” ");
INSERT INTO tsg_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Laung nila kan Īsa, “Biyaꞌ diin in kakitaꞌ kaymu hi Ibrahim, sin minsan in umul mu walaꞌ pa miyabut kayꞌman?” ");
INSERT INTO tsg_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","“Baytaan ta kamu sin kasabunnalan,” laung hi Īsa, “Ha walaꞌ pa naawn hi Ibrahim, in aku asal awn na.” ");
INSERT INTO tsg_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Pagꞌubus hi Īsa nagbichara, kimawaꞌ batu in manga tau hipaniluꞌ kaniya, sagawaꞌ timapuk hi Īsa. Pagꞌubus ampa siya gimuwaꞌ dayn ha halaman sin Bāy sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Manjari ha saꞌbu hi Īsa nagpapanaw, kītaꞌ niya in hambuuk usug buta kariasali. ");
INSERT INTO tsg_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Sakali pagkitaꞌ sin manga mulid hi Īsa ha tau buta, iyasubu nila hi Īsa, laung nila, “Tuwan, unu in sabab hangkan in tau yan piyagꞌanak asal buta? Sabab ka sin dusa niya atawa dusa sin manga maas niya?” ");
INSERT INTO tsg_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","In sambung hi Īsa, laung niya, “Nabuta siya bukun pasal sin dusa niya atawa dusa sin maas niya, sagawaꞌ in sabab hangkan in siya yan buta ha supaya mapanyataꞌ duun kaniya in kawasa sin Tuhan (bang siya karihilan na pangitaꞌ). ");
INSERT INTO tsg_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Bābā kitaniyu buhiꞌ pa, subay natuꞌ hinangun in daakan sin Tuhan, amu in nagdaak kākuꞌ mari. Bang maabut na in waktu natuꞌ matay, diꞌ na kitaniyu makahinang. ");
INSERT INTO tsg_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ha salugay ku dī ha dunya, aku in ilaw amu in dumihil kasawahan pa pikilan sin mānusiyaꞌ katān.” ");
INSERT INTO tsg_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pagꞌubus hi Īsa namichara, limuraꞌ siya pa lupaꞌ ampa niya liyamugay in luraꞌ iban lupaꞌ hīnang pisak. Pagꞌubus ampa niya piyahid pa mata sin tau buta. ");
INSERT INTO tsg_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ampa niya īyan in tau buta, laung niya, “Kadtu kaw pamaꞌmus pa tubig Siluwam.” (In hāti sin Siluwam Pagparāhan.) Na, miyadtu na in tau buta namaꞌmus. Pagbalik niya mawn makakitaꞌ na siya. ");
INSERT INTO tsg_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Sakali pagkitaꞌ kaniya sin manga pangdaig bāy niya iban sin manga tau nakakitaꞌ kaniya magpangayuꞌ sarakka, laung nila, “Bukun ka in tau ini amu in naglilingkud magpangayuꞌ sarakka?” ");
INSERT INTO tsg_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Laung sin kaibanan, “Siya na sa yan.” Sagawaꞌ laung isab sin kaibanan, “Bukun sān, saꞌ hangka-dagbus sadja sila.” Simambung in tau buta, laung niya, “Aku na sa ini in tau bakas buta.” ");
INSERT INTO tsg_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Na, iyasubu siya sin manga tau, laung nila, “Maytaꞌ kaw makakitaꞌ na bihaun?” ");
INSERT INTO tsg_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","In sambung niya, laung niya, “In tau amu in pagngānan Īsa in nagpauliꞌ sin mata ku. Hīnang niya pisak in lupaꞌ ampa niya piyahid pa mata ku. Pagꞌubus ampa niya aku piyakadtu mamaꞌmus pa tubig Siluwam. Na, miyadtu na aku namaꞌmus. Na, pagꞌubus ku namaꞌmus makakitaꞌ na aku.” ");
INSERT INTO tsg_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Imasubu in manga tau, laung nila, “Hariin na siya?” In sambung niya, “Inday, diꞌ ku kaingatan.” ");
INSERT INTO tsg_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Manjari diyā sin manga tau madtu pa manga Parisi in tau bakas buta. ");
INSERT INTO tsg_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","In adlaw hīnang hi Īsa pisak in lupaꞌ kimugdan adlaw Sabtuꞌ, amu in adlaw paghali-hali iban pagpudji pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Na, iyasubu na isab sin manga Parisi in tau bakas buta bang maytaꞌ siya makakitaꞌ na. Laung niya kanila, “Biyutangan niya pisak in mata ku. Sakali nakakitaꞌ na aku pagꞌubus ku piyaꞌmusan.” ");
INSERT INTO tsg_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Laung sin kaibanan Parisi, “In tau yan bukun diyaak sin Tuhan, sabab walaꞌ niya iyagad in saraꞌ pasal sin adlaw paghali-hali iban pagpudji pa Tuhan.” Sagawaꞌ laung isab sin kaibanan, “Bang in tau yan baldusa biyaꞌ diin in kahinang niya sin hinang muꞌjijat biyaꞌ ha yan?” Na, nabahagiꞌ nagduwa in pikilan sin manga tau pasal hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Hangkan iyasubu na isab nagbalik sin manga Parisi in tau bakas buta. Laung nila, “In agi mu in tau yadtu amu in nagpauliꞌ kaymu. Na, bang ha pikilan mu hisiyu in tau yadtu?” “Hambuuk siya nabi,” in sambung sin tau bakas buta. ");
INSERT INTO tsg_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Na, in manga nakuraꞌ Yahudi diꞌ makakahagad sin in tau yaun bakas buta, hāti nakakitaꞌ na. Hangkan piyakawaꞌ nila in inaꞌ-amaꞌ niya ampa nila iyasubu. ");
INSERT INTO tsg_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Laung nila ha inaꞌ-amaꞌ sin tau bakas buta, “Anak niyu ka in tau ini amu in piyagꞌiyan asal buta dayn ha kapagꞌanak kaniya? Na, maytaꞌ siya makakitaꞌ na bihaun?” ");
INSERT INTO tsg_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","In sambung sin inaꞌ-amaꞌ niya, “Huun, in siya yan anak namuꞌ. Asal siya buta dayn ha kapagꞌanak kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Sagawaꞌ diꞌ namuꞌ kaingatan bang maytaꞌ siya makakitaꞌ na bihaun iban diꞌ namuꞌ da isab kaingatan bang hisiyu in nakarihil pangitaꞌ kaniya. Asubuha niyu na in baran niya. Maingat na sa siya yan mamaytaꞌ sabab maumul na siya!” ");
INSERT INTO tsg_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Hangkan namung biyaꞌ hādtu in inaꞌ-amaꞌ niya sabab miyugaꞌ sila ha manga nakuraꞌ Yahudi. Miyugaꞌ sila sabab kiyapagꞌisunan sin manga nakuraꞌ sin hisiyu-siyu in imiyan sin hi Īsa amuna in Almasi, na diꞌ na siya palamurun ha lawm langgal nila. ");
INSERT INTO tsg_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Hangkan laung sin inaꞌ-amaꞌ niya ha manga nakuraꞌ, “Asubuha niyu na in baran niya sabab maumul na da siya!” ");
INSERT INTO tsg_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Na, piyatawag nagbalik sin manga nakuraꞌ in tau bakas buta ampa nila īyan, laung nila, “Sapa kaw pa Tuhan sin kasabunnalan in baytaꞌ mu! Kaingatan namuꞌ sin in tau nagpauliꞌ kaymu hambuuk baldusa.” ");
INSERT INTO tsg_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","In sambung sin tau bakas buta, “Diꞌ ku kaingatan bang siya baldusa iban bukun. Amura in kaingatan ku bakas aku buta, sagawaꞌ bihaun makakitaꞌ na aku.” ");
INSERT INTO tsg_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Imasubu na isab in manga nakuraꞌ, laung nila, “Unu in hīnang niya kaymu? Iyunu niya in mata mu hangkan kaw makakitaꞌ na bihaun?” ");
INSERT INTO tsg_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","“Bakas ta na kamu biyaytaan,” laung sin tau bakas buta, “sagawaꞌ diꞌ niyu da dungugun in bichara ku. Iban maytaꞌ namān kamu mabayaꞌ humāti magbalik? Marayꞌ isab mabayaꞌ kamu magguru kan Īsa.” ");
INSERT INTO tsg_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Sakali piyamūngmūngan siya sin manga nakuraꞌ, amu agi kaniya, “Ikaw sa yan in mulid sin tau yan, ampa in kami ini mulid hi Musa. ");
INSERT INTO tsg_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kaingatan namuꞌ in Tuhan bakas nagparman kan Musa. Ampa in tau yan diꞌ namuꞌ minsan kaingatan bang dayn diin siya!” ");
INSERT INTO tsg_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Na, laung sin tau bakas buta, “Ay kaw naa, makainu-inu kamu yan! In tau yan amu in nakapauliꞌ sin mata ku, hāti diꞌ niyu kaingatan bang dayn diin siya! ");
INSERT INTO tsg_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Asal natuꞌ kaingatan sin in tau baldusa diꞌ dungugun sin Tuhan in unu-unu pangayuun niya. Ampa in tau nagmamabugaꞌ iban miyamagad sin kabayaan sin Tuhan, dungugun sin Tuhan in unu-unu pangayuun niya. ");
INSERT INTO tsg_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Dayn sin tagnaꞌ kapaawn sin dunya ini, wayruun pa tau in nakarihil pangitaꞌ ha tau buta kariasali. ");
INSERT INTO tsg_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Na, bang in tau yan bukun diyaak sin Tuhan, tantu diꞌ siya makahinang unu-unu biyaꞌ ha yan.” ");
INSERT INTO tsg_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Na, diyugalan in manga nakuraꞌ ha tau bakas buta. Laung nila kaniya, “Maytaꞌ, hisiyu kaw in manghinduꞌ kāmuꞌ biyaꞌ ha yan? In ikaw yan dayn ha kapagꞌanak kaymu asal kaw baldusa na. Hāti manghinduꞌ kaw kāmuꞌ?” Na, saruun-duun diyūy sin manga nakuraꞌ in tau bakas buta pa guwaꞌ sin langgal. ");
INSERT INTO tsg_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Sakali pagdungug hi Īsa sin diyūy sin manga nakuraꞌ in tau bakas buta, magtūy niya liyawag in tau bakas buta. Kiyabaakan niya mayan, iyasubu niya, laung niya, “Magparachaya ka kaw ha Anak Mānusiyaꞌ?” ");
INSERT INTO tsg_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","In sambung sin tau bakas buta, laung niya, “Tuwan, baytai aku bang hisiyu siya, ha supaya aku makapagparachaya kaniya!” ");
INSERT INTO tsg_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Laung hi Īsa kaniya, “Bakas mu na siya kītaꞌ iban siya na in diyarā mu nagbichara bihaun.” ");
INSERT INTO tsg_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Laung sin tau bakas buta, “Panghuꞌ ku, magparachaya na aku kaymu.” Sartaꞌ simujud na siya ha alupan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Laung hi Īsa, “In pagkari ku pa dunya amu in makapanyataꞌ sin mattan kahālan sin manga mānusiyaꞌ. In manga tau amu in biyaꞌ sapantun buta sabab diꞌ nila kaingatan in kasabunnalan pasal Tuhan, karihilan na pangitaꞌ, sagawaꞌ in manga tau amu in pangannal nila kaingatan nila in kasabunnalan pasal Tuhan, na mabiyaꞌ na sila sapantun buta diꞌ makakitaꞌ.” ");
INSERT INTO tsg_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Sagawaꞌ laung sin kaibanan Parisi amu in duun nakarungug sin bichara niya, “Biyaꞌ kaw nagpaandig sin in kami ini buta. Na, makakitaꞌ sa kami ini.” ");
INSERT INTO tsg_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","In sambung hi Īsa kanila, “Bang kamu mattan tuud buta, hāti niya wayruun tuud panghāti niyu sin kasabunnalan, na diꞌ kamu maitung nakarusa. Sagawaꞌ pagga kamu imiyan sin makakitaꞌ kamu, hāti niya kiyaiingatan niyu in kasabunnalan, na in kamu yan tantu nakarusa, sabab diꞌ kamu magkahagad sin kasabunnalan.” ");
INSERT INTO tsg_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Bunnal in bichara ku ini kaniyu,” laung hi Īsa, “bang in tau diꞌ sumūd dayn ha lawang pa lawm sin lugal pagbubutangan ha manga bili-bili, sagawaꞌ dumāg siya ha labayan dugaing, na in tau yan sugarul iban manglalangpas. ");
INSERT INTO tsg_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Sagawaꞌ bang in tau sumūd dayn ha lawang, in siya yan amu in magꞌiipat ha manga bili-bili. ");
INSERT INTO tsg_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ukaban siya sin tau tungguꞌ lawang. Kakilāhan sin manga bili-bili in tingug niya. Tawagun niya in manga bili-bili sukuꞌ niya, ngānan dayn ha hambuuk pa hambuuk ampa niya dāhun gumuwaꞌ in manga bili-bili. ");
INSERT INTO tsg_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Duun mayan ha guwaꞌ in katān bili-bili niya, muna siya dayn kanila, ampa in manga bili-bili murul kaniya, karnaꞌ kakilāhan sin manga bili-bili in tingug niya. ");
INSERT INTO tsg_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Diꞌ in manga bili-bili magad ha tau dugaing. Gām mayan maguy sila bang awn tau dugaing dumā kanila, sabab diꞌ nila kakilāhan in tingug niya.” ");
INSERT INTO tsg_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Amu yan in isturi diyalil hi Īsa, sagawaꞌ walaꞌ kiyahātihan sin manga tau in maana niya. ");
INSERT INTO tsg_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Hangkan namichara na isab nagbalik hi Īsa ha supaya kahātihan sin manga tau in isturi diyalil niya. Laung niya, “Baytaan ta kamu sin kasabunnalan. In aku amuna in biyaꞌ ibārat lawang sūran iban guwaan sin manga bili-bili. ");
INSERT INTO tsg_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Hisiyu-siyu in manga miyuna mari dayn kākuꞌ, in sila yan biyaꞌ ibārat sugarul iban manglalangpas. Sagawaꞌ in manga tau sukuꞌ ku walaꞌ nagꞌasip sin hinduꞌ nila. ");
INSERT INTO tsg_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Aku in biyaꞌ ibārat lawang. Hisiyu-siyu in sumūd labay dayn kākuꞌ malappas siya. Luhaya na siya, lāgiꞌ makabaak na siya sin hikarayaw kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","In tau sugarul wayruun dugaing maksud niya dayn sin manakaw, māmunuꞌ iban magpakangīꞌ unu-unu na. Sagawaꞌ in aku, in maksud ku miyari, ha supaya dumihil ha manga mānusiyaꞌ sin kabuhiꞌ tantu, amu in ballabi-labihan in kasannyangan. ");
INSERT INTO tsg_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Aku in biyaꞌ ibārat magꞌiipat bili-bili. Īipat ku tuud marayaw in manga sukuꞌ ku, amu in biyaꞌ sapantun manga bili-bili. Hilillaꞌ ku in duguꞌ nyawa ku ha pasalan sin manga tau sukuꞌ ku. ");
INSERT INTO tsg_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Sagawaꞌ in tau, amu in giyadjihan sadja magjaga ha manga bili-bili, diꞌ da magparuli tuud ha manga bili-bili, sabab bukun da siya in magꞌiipat iban tagdapu sin manga bili-bili. Bang siya makakitaꞌ iruꞌ talun harap mawn pa manga bili-bili, magtūy siya maguy. Hibīn niya in manga bili-bili. Na, in manga bili-bili sakmitun, iban masilahag na, apasun sin iruꞌ talun. ");
INSERT INTO tsg_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Hangkan maguy in tau giyadjihan sabab in siya giyadjihan sadja magjaga ha manga bili-bili, iban wayruun lasa niya ha manga bili-bili. ");
INSERT INTO tsg_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Aku ini in biyaꞌ ibārat magꞌiipat ha manga bili-bili iban marayaw tuud in pagꞌipat ku kanila. Magꞌīngati tuud kami marayaw iban sin Amaꞌ ku. Damikkiyan, in aku iban sin manga bili-bili ku magꞌīngati tuud isab marayaw. Iban in aku ini lillaꞌ matay pasalan sin manga bili-bili ku. ");
INSERT INTO tsg_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Awn pa isab manga bili-bili ku dugaing. Sukuꞌ ku da isab sila, sagawaꞌ in sila dayn ha baanan dugaing. Subay ku da isab sila dāhun. Kahagarun nila in hinduꞌ ku. Mahambuuk na sila iban sin manga katān sukuꞌ ku iban aku hambuuk-buuk in magꞌipat kanila. ");
INSERT INTO tsg_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Kalasahan tuud aku sin Amaꞌ ku sabab hilillaꞌ ku in duguꞌ-nyawa ku ha supaya maagad in maksud niya mapatay aku iban mabuhiꞌ aku magbīng. ");
INSERT INTO tsg_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wayruun tau minsan hisiyu in tagakawasa mamatay kākuꞌ, sabab aku in makapagbayaꞌ bang aku mapatay atawa diꞌ. Dayn ha kabayaan ku hilillaꞌ in duguꞌ-nyawa ku. Awn kawasa ku mugtuꞌ sin napas ku, iban awn da isab kawasa ku mamuhiꞌ magbalik ha baran ku. Amu yan in daakan hipahinang kākuꞌ sin Amaꞌ ku.” ");
INSERT INTO tsg_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Na, pagdungug sin manga nakuraꞌ Yahudi sin pamung hi Īsa, nabahagiꞌ na isab nagbalik in pikilan nila pasal hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Laung sin kamatauran kanila, “Siyasaytan in tau yan! Kiyakangug siya! Maytaꞌ kamu dumungug kaniya?” ");
INSERT INTO tsg_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Sagawaꞌ laung isab sin kaibanan, “Bang in tau yan siyasaytan diꞌ makabichara biyaꞌ ha yan, iban in tau siyasaytan diꞌ makapauliꞌ ha tau buta!” ");
INSERT INTO tsg_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Na, manjari naabut na in waktu pagjamu ha Awrusalam (Baytal Makdis) amu in pagngānan Pagsuchi sin Bāy sin Tuhan. Nakasaꞌbu ha timpu mahaggut. ");
INSERT INTO tsg_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Sakali duun hi Īsa nagpapanaw ha balkun sin Bāy sin Tuhan, amu in pagngānan Balkun hi Sultan Sulayman. ");
INSERT INTO tsg_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Manjari, piyaglibutan hi Īsa sin manga nakuraꞌ Yahudi. Laung nila kan Īsa, “Maunu pa in lugay namuꞌ tumagad ampa mu kami baytaan bang hisiyu kaw tuud? Baytai na kami bihaun sin tuman bang ikaw na tuud in Almasi.” ");
INSERT INTO tsg_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","In sambung hi Īsa kanila, “Bakas ta na kamu biyaytaan, saꞌ diꞌ da kamu magkahagad kākuꞌ. Kītaꞌ niyu na sin in manga hinang nahinang ku dayn ha kawasa sin Tuhan. Na, in yan amuna in magpakitaꞌ kaniyu bang hisiyu tuud aku. ");
INSERT INTO tsg_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Sagawaꞌ diꞌ da kamu magkahagad kākuꞌ, sabab in kamu yan bukun sukuꞌ ku. ");
INSERT INTO tsg_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","In manga tau sukuꞌ ku, amu in ibārat bili-bili īipat ku, magkahagad sin hinduꞌ ku. Kaingatan ku sila iban magad sila kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Dihilan ku sila kabuhiꞌ salama-lama ha lawm ukum-milik sin Tuhan. Diꞌ sila mabutas dayn ha Tuhan kasaumulan. Wayruun makasakmit kanila dayn ha lawm ukuman ku. ");
INSERT INTO tsg_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Sabab in sila kiyasukuꞌ kākuꞌ sin Tuhan Amaꞌ ku. Ampa in Amaꞌ ku makawasa dayn ha katān. Wayruun makasakmit kanila dayn ha lawm ukuman niya. ");
INSERT INTO tsg_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","In aku iban sin Amaꞌ ku nahahambuuk.” ");
INSERT INTO tsg_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Na, pagdungug sin manga nakuraꞌ sin pamung hi Īsa, miyūt na isab sila batu nagbalik hipaniluꞌ kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Laung hi Īsa kanila, “Mataud hinang marayaw in kītaꞌ niyu nahinang ku. In manga yan daakan sin Tuhan piyahinang kākuꞌ. Na, unu dayn ha manga nahinang ku yan in kiyarugalan niyu, hangkan niyu aku batuhun?” ");
INSERT INTO tsg_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","In sambung nila kan Īsa, “Bukun kami mamatu kaymu sabab sin unu-unu na nahinang mu marayaw, sagawaꞌ hangkan namuꞌ kaw batuhun, sabab namung kaw pangkal pa Tuhan! In ikaw yan mānusiyaꞌ da, hāti imiyan kaw, ikaw in Tuhan!” ");
INSERT INTO tsg_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","In sambung hi Īsa kanila, “Kiyasulat ha lawm Kitab niyu in pamung sin Tuhan ha manga mānusiyaꞌ, amu agi, ‘In kamu yan manga tuhan!’ ");
INSERT INTO tsg_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Na, kiyaiingatan natuꞌ sin diꞌ kapindahan kasaumulan in unu-unu kiyasulat ha lawm Kitab. Na, in manga tau yadtu, amu in kiyapanaugan sin Parman, manga tuhan in pagtawag sin Tuhan kanila. ");
INSERT INTO tsg_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Na, in hāti niya minsan in aku, matūp da isab tawagun Anak sin Tuhan, sabab in aku kiyandī iban kiyawakilan sin Tuhan, Amaꞌ ku, mari pa dunya. Na, pagga biyaꞌ ha yan, maytaꞌ kamu imiyan sin in aku namung pangkal pa Tuhan, sawkat na aku imiyan Anak aku sin Tuhan? ");
INSERT INTO tsg_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Bang sawpama in hinang ku ini diꞌ magkugdan iban sin hinang sin Tuhan, Amaꞌ ku, na, ayaw kamu magparachaya kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Sagawaꞌ bang magkugdan in hinang namuꞌ, minsan kamu diꞌ na magparachaya sin bichara ku, bang mayan magparachaya kamu ha manga nahinang ku, ha supaya mattan kaingatan niyu na tuud sin in aku iban sin Tuhan, Amaꞌ ku, nahahambuuk tuud.” ");
INSERT INTO tsg_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Sakali ambayaꞌ nila na isab saggawun hi Īsa pasal sin pamung niya, sagawaꞌ nakapaklus hi Īsa dayn kanila. ");
INSERT INTO tsg_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Manjari, miyadtu hi Īsa nagbalik pa hansipak sin Subaꞌ Jurdan, amu in bakas piyagliguan hi Yahiya ha manga tau. Duun siya himantiꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mataud tau in miyawn kaniya. Laung sin manga tau, “In hi Yahiya walaꞌ nakahinang sin manga muꞌjijat, sagawaꞌ in katān bichara niya pasal hi Īsa bunnal.” ");
INSERT INTO tsg_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Na, mataud tau duun in nagparachaya kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Manjari awn hambuuk tau nāsakit, in ngān niya hi Lasarus. Duun siya naghuhulaꞌ ha dāira Bitani, amu in piyaghuhulaan da isab sin duwa taymanghud niya babai, hi Mariyam kay Marta. ");
INSERT INTO tsg_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","In hi Mariyam ini amuna in babai imasag lana mahamut pa siki hi Panghuꞌ Īsa ampa niya tiyarapuhan sin buhuk niya. Na, pagga nāsakit hi Lasarus, ");
INSERT INTO tsg_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","nagparā lapal in duwa magtaymanghud babai madtu kan Īsa, amu agi, “Panghuꞌ, in bagay mu amu in kalasahan mu nāsakit.” ");
INSERT INTO tsg_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Na, pagꞌingat hi Īsa sin paraak kaniya, laung niya, “Bukun nāsakit hi Lasarus ha supaya siya mapatay, sagawaꞌ ha supaya matanyag in kusug sin kawasa sin Tuhan, iban amu isab yan in makarihil kabantugan ha amu in Anak Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Malasa hi Īsa ha tū magtaymanghud, hi Marta, hi Mariyam iban hi Lasarus. ");
INSERT INTO tsg_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Sagawaꞌ pagꞌingat niya sin nāsakit hi Lasarus, walaꞌ siya magtūy miyadtu. Timagad pa siya duwa adlaw duun ha kiyaruruunan niya. ");
INSERT INTO tsg_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Sakali nakalabay mayan in duwa adlaw, laung hi Īsa ha manga mulid niya, “Madtu kitaniyu magbalik pa Yahudiya.” ");
INSERT INTO tsg_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Laung sin manga mulid niya kaniya, “Tuwan Guru, sin kaꞌnu-kaꞌnu yaun ambayaꞌ kaw patayun tiluun sin batu kaagi sin manga nakuraꞌ Yahudi. Na, hāti, mabayaꞌ pa kaw magbalik madtu?” ");
INSERT INTO tsg_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","In sambung hi Īsa, laung niya, “Ayaw kamu mabugaꞌ. Ha lawm sin hangka-adlaw, hangpuꞌ tagduwa kajām masawa in hulaꞌ. Bang kitaniyu manaw ha waktu masawa pa in hulaꞌ, diꞌ kitaniyu makarugtul pa unu-unu kamulahan, sabab kīkitaꞌ taniyu in panawan taniyu. ");
INSERT INTO tsg_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Sagawaꞌ bang kitaniyu manaw ha waktu tigidlum na in hulaꞌ, makarugtul sadja kitaniyu pa kamulahan, sabab diꞌ taniyu kakitaan in panawan taniyu.” ");
INSERT INTO tsg_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pagꞌubus hi Īsa namichara biyaꞌ hādtu, giyanapan niya pa in bichara niya, laung niya, “In bagay natuꞌ hi Lasarus nakatūg na, sagawaꞌ madtu aku batiun ku siya.” ");
INSERT INTO tsg_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Laung sin manga mulid niya, “Panghuꞌ, bang siya nakatūg, in hāti niya dumayaw na siya.” ");
INSERT INTO tsg_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","In hātihan sin bichara hi Īsa, in hi Lasarus miyatay na, sagawaꞌ in panghāti sin manga mulid niya, in hi Lasarus nakatūg na. ");
INSERT INTO tsg_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Hangkan biyuntulan na sila hi Īsa, laung niya, “In hi Lasarus miyatay na. ");
INSERT INTO tsg_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Sagawaꞌ ha sabab niyu, makuyag aku sin walaꞌ aku didtu ha saꞌbu niya nāsakit. Karnaꞌ dayn ha pasal sin hinangun ku ini, in kamu magparachaya na tuud kākuꞌ. Sūng na, madtu na kitaniyu kan Lasarus.” ");
INSERT INTO tsg_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Sakali namichara hi Tumas, amu in diyanglayan Kambal. Laung niya ha manga pagkahi niya mulid hi Īsa, “Sūng na kitaniyu magad ha Panghuꞌ, ha supaya kitaniyu makaunung matay kaniya!” ");
INSERT INTO tsg_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Na, pagdatung hinda Īsa pa Bitani, kiyabaytaan siya sin awn na upat adlaw limabay in kapagkubul kan Lasarus. ");
INSERT INTO tsg_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Pagga in Bitani masuuk da pa Awrusalam (Baytal Makdis), awn da manga tū batu in layuꞌ, ");
INSERT INTO tsg_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","mataud manga Yahudi in limuruk mawn kan Marta iban hi Mariyam, magparayaw sin atay nila pasal sin kamatay sin taymanghud nila hi Lasarus. ");
INSERT INTO tsg_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Pagdungug hi Marta sin magdaratung na hi Īsa mawn, magtūy siya miyadtu miyāk kan Īsa, sagawaꞌ hi Mariyam walaꞌ minīg dayn ha lawm bāy. ");
INSERT INTO tsg_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Na, nagbāk mān hi Marta kay Īsa, laung hi Marta kan Īsa, “Panghuꞌ, bang kaw bakas dī, in taymanghud natuꞌ diꞌ matay! ");
INSERT INTO tsg_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Sagawaꞌ kaingatan ku minsan bihaun hirūl sin Tuhan kaymu in unu-unu pangayuun mu kaniya.” ");
INSERT INTO tsg_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Laung hi Īsa kaniya, “In taymanghud mu mabuhiꞌ da magbalik.” ");
INSERT INTO tsg_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","In sambung hi Marta kan Īsa, “Kaingatan ku sin mabuhiꞌ da siya magbalik ha adlaw mahuli.” ");
INSERT INTO tsg_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Laung hi Īsa kaniya, “Aku in makabuhiꞌ magbalik ha manga patay iban aku in puunan sin kabuhiꞌ. Hisiyu-siyu in magparachaya kākuꞌ mabuhiꞌ siya, minsan siya miyamatay na. ");
INSERT INTO tsg_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Iban hisiyu-siyu in buhiꞌ ampa magparachaya kākuꞌ, diꞌ tuud siya mapatay. Magparachaya ka kaw sin bichara ku yan?” ");
INSERT INTO tsg_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","In sambung hi Marta, “Huun, Panghuꞌ, magparachaya tuud aku sin ikaw na in Almasi, amu in Anak Tuhan, iban amu in kiyawakilan sin Tuhan mari pa dunya.” ");
INSERT INTO tsg_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Na, pagꞌubus hi Marta namichara, miyadtu siya nagbalik pa bāy ampa niya hiyagas-hagasan hi Mariyam, laung niya, “Yari na in Tuwan Guru. Nangasubu siya bang hawnu kaw.” ");
INSERT INTO tsg_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Pagdungug hi Mariyam, nagtūy siya nagꞌūs-ꞌūs gimuwaꞌ miyāk madtu kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Na, in hi Īsa walaꞌ pa nakasampay mawn pa lawm sin kawman. Masi pa siya didtu ha lugal piyagbākan nila kay Marta. ");
INSERT INTO tsg_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na, in manga luruk Yahudi duun ha bāy, amu in nagpaparayaw sin atay hi Mariyam. Pagkitaꞌ nila sin timindug hi Mariyam ampa nagꞌūs-ꞌūs gimuwaꞌ dayn ha bāy, imurul sila, sabab in pangannal nila madtu hi Mariyam pa kubul sin taymanghud niya magtangis. ");
INSERT INTO tsg_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Sagawaꞌ harap hi Mariyam madtu kan Īsa. Na, pagkitaꞌ niya na mayan kan Īsa, magtūy siya simujud pa alupan hi Īsa ampa siya namung, laung niya, “Panghuꞌ, bang kaw bakas dī, diꞌ matay in taymanghud natuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Na, pagkitaꞌ hi Īsa kan Mariyam nagtatangis iban sin manga tau luruk timatangis da isab, nabagbag in lawm atay niya, iban landuꞌ siya nasusa. ");
INSERT INTO tsg_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nangasubu hi Īsa, laung niya, “Hariin niyu siya kiyubul?” Laung nila, “Kari kaw kitaꞌ, Panghuꞌ!” ");
INSERT INTO tsg_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Timūꞌ in luhaꞌ hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Na, laung sin manga tau, “Kitaa niyu ba in lasa niya kan Lasarus.” ");
INSERT INTO tsg_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Sagawaꞌ laung isab sin kaibanan, “Bang siya malasa, maytaꞌ niya walaꞌ piyauliꞌ in sakit hi Lasarus supaya siya diꞌ matay? Pagga in tau dugaing minsan tau buta kiyaulian niya.” ");
INSERT INTO tsg_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Na, nabagbag nagbalik in lawm atay hi Īsa, sartaꞌ miyadtu na siya pa kubul hi Lasarus. In kubul hi Lasarus, biyaꞌ lupa sungab batu, tiyatambulan sin batu dakulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Pagdatung nila pa kubul, laung hi Īsa, “Īgi niyu in batu tambul sin kubul.” Sagawaꞌ laung hi Marta, amu in taymanghud sin miyatay, “Panghuꞌ, mabahuꞌ na sān, sabab awn na upat adlaw in lugay niya kiyubul.” ");
INSERT INTO tsg_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Laung hi Īsa kaniya, “Bakas ta na kaw biyaytaan, bang kaw magparachaya, kakitaan mu bang biyaꞌ diin in kusug sin kawasa sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Na, inīgan nila na in batu tambul sin lawang kubul, sartaꞌ himangad hi Īsa ampa siya namichara, laung niya, “Ya Amaꞌ, magsarang-sukul tuud aku kaymu sin diyūl mu kākuꞌ in piyangayuꞌ ku kaymu. ");
INSERT INTO tsg_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kaingatan ku sin hirūl mu sadja kākuꞌ in unu-unu pangayuun ku kaymu. Sagawaꞌ hiparungug ku ha manga tau ini in bichara ku kaymu ha supaya sila magparachaya sin ikaw tuud in nagdaak kākuꞌ mari.” ");
INSERT INTO tsg_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pagꞌubus ampa siya timawag matanug kan Lasarus. Laung niya, “Lasarus, kari na kaw guwaꞌ!” ");
INSERT INTO tsg_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Sakali gimuwaꞌ na hi Lasarus dayn ha lawm kubul. In baran niya masi pa napuputus sin saput sampay pa siki-lima iban bayhuꞌ niya. Laung hi Īsa, “Īgi niyu na in saput niya bat siya makauwiꞌ na.” ");
INSERT INTO tsg_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Na, dayn didtu mataud Yahudi amu in nangluruk mawn kan Mariyam in nagparachaya kan Īsa, sabab kiyakitaan nila tuud in nahinang hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Sagawaꞌ in kaibanan tau miyadtu pa manga Parisi nagsumbung pasal sin nahinang hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Na, hangkan magtūy piyapagtipun sin manga nakuraꞌ kaimaman iban sin manga Parisi in manga kunsiyal sin agama Yahudi, amu in magpapanaw sin saraꞌ sin agama Yahudi. Napūn mayan sila, laung nila, “Unuhun natuꞌ na in tau yan, sabab mataud na tuud muꞌjijat nahinang niya! ");
INSERT INTO tsg_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Bang natuꞌ siya pasāran maghinang sin hinang niya yan, in tau katān magkahagad na kaniya. Na, dayn ha pasal yan, mulahun sin parinta sin hulaꞌ Rūm in Bāy natuꞌ Mahasuchi sampay pa bangsa natuꞌ!” ");
INSERT INTO tsg_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Sakali namichara in hambuuk duun kanila amu in pagngānan Kayapas. Siya in Imam Dakulaꞌ sin tahun yadtu. Laung niya, “In kamu yan wayruun tuud pikilan! ");
INSERT INTO tsg_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Walaꞌ niyu ka napikil sin sapādpād magmula in bangsa natuꞌ, marayaw pa isab hambuuk sadja tau in mapatay gantiꞌ sin kitaniyu katān.” ");
INSERT INTO tsg_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Na, in pamung hi Kayapas yadtu bukun tuud guwaꞌ dayn ha lawm pikilan niya. Sagawaꞌ pagga siya in Imam Dakulaꞌ sin tahun yadtu, biyaꞌ siya hambuuk mangingitaꞌ, namaytaꞌ sin in hi Īsa matay ha susūngun sabab-karnaꞌ sin bangsa Yahudi. ");
INSERT INTO tsg_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Lāgiꞌ bukun sadja isab ha pasal sin manga bangsa Yahudi, sagawaꞌ ha supaya mahambuuk na hangka-agaran in manga tau amu in nakawkanat ha kahulaꞌ-hulaan, bang sila mahinang na manga sukuꞌ sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Manjari tagnaan dayn sin adlaw yadtu piyagpikilan na sin manga nakuraꞌ Yahudi bang biyaꞌ diin in hikapatay nila kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hangkan in hi Īsa diꞌ na magkawn pa katauran tau ha Yahudiya. Gām mayan miyadtu siya iban sin manga mulid niya pa kawman pagngānan Ipraim masuuk pa hulaꞌ paslangan mahunit paghulaan. Dimuun siya iban sin manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Manjari masuuk na in pagjamu sin manga Yahudi amu in pagngānan Haylaya Paglappas dayn ha Kamatay. Na, mataud tau dayn ha kakawm-kawman in timukad madtu pa Awrusalam (Baytal Makdis). Duun mayan sila ha Awrusalam (Baytal Makdis), nagsuchi sila sin baran nila ha supaya sila makalamud maghaylaya. ");
INSERT INTO tsg_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Na, piyaglawag sin manga tau hi Īsa duun ha paghaylayahan. Bang sila matipun na duun ha Bāy sin Tuhan, magꞌasubu-iyasubuhi na sila, laung nila, “Ha pikil niyu, mari bahaꞌ hi Īsa pa paghaylayahan?” ");
INSERT INTO tsg_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Na, nagdihil daakan in manga nakuraꞌ kaimaman iban manga Parisi, sin hisiyu-siyu in makaingat bang haunu hi Īsa subay mamaytaꞌ magtūy kanila, ha supaya nila masaggaw hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Na, awn pa unum adlaw in lugay ampa dumatung in Haylaya Paglappas dayn ha Kamatay, miyadtu hi Īsa pa Bitani, hulaꞌ hi Lasarus, amu in tau biyuhiꞌ hi Īsa nagbalik dayn ha kamatay. ");
INSERT INTO tsg_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Na, duun mayan siya ha Bitani, liyabut siya sin manga tau duun. Duun da isab hi Marta timabang namutang sin pagkaun. In hi Lasarus nagsāw nagkaun kay Īsa iban sin kaibanan tau. ");
INSERT INTO tsg_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Sakali kimawaꞌ hi Mariyam lana mahamut pagngānan narda. In lana mahamut ini mahargaꞌ tuud, bukun paltik iban wayruun lamud niya dugaing. Iban in taud niya tungaꞌ kilu. Biyutangan niya lana mahamut in siki hi Īsa ampa niya tiyarapuhan sin buhuk niya. Nagtuꞌnug ha lawm bāy in hamut sin lana mahamut. ");
INSERT INTO tsg_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Sakali namichara in hambuuk mulid hi Īsa, hi Judas tau dayn ha Kiriyud, amu in manipu kan Īsa, laung niya, ");
INSERT INTO tsg_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Gām pa in lana mahamut yan piyagdagang magbīhan timbang gadji sin hambuuk tau ha lawm hangka-tahun. Hāti in bīhan niya hikapagsarakka ha manga miskin.” ");
INSERT INTO tsg_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Hangkan siya namichara biyaꞌ hādtu, sabab pangungustaw siya, bukun sabab maluuy siya ha manga miskin. Siya in nagdarā sin pagluluunan sīn nila, iban biyaksa siya magpangawaꞌ dayn ha sīn piyangandul kaniya sin manga pagkahi niya mulid hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Sagawaꞌ laung hi Īsa kaniya, “Pasāri na siya. In lana mahamut yan tiyatagama niya bat supaya saddiya na in anggawtaꞌ-baran ku bang aku hikubul na ha waktu susūngun. ");
INSERT INTO tsg_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","In manga tau miskin matabang niyu ha kuꞌnu-kuꞌnu waktu, sagawaꞌ in aku ini diꞌ lumugay dī kaniyu.” ");
INSERT INTO tsg_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Manjari mataud tuud tau nakarungug sin yaun hi Īsa ha Bitani. Hangkan miyadtu sila, bukun sadja isab kumitaꞌ kan Īsa, sagawaꞌ mabayaꞌ da isab sila kumitaꞌ kan Lasarus, amu in biyuhiꞌ hi Īsa nagbalik dayn ha kamatay. ");
INSERT INTO tsg_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Hangkan nagꞌisun in manga nakuraꞌ kaimaman patayun hi Lasarus hiunung kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Sabab dayn ha pasal hi Lasarus mataud manga Yahudi in nagparachaya na kan Īsa, iban walaꞌ na miyagad ha manga kaimaman. ");
INSERT INTO tsg_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Na, pagꞌadlaw hambuuk in manga tau mataud amu in miyawn pa Awrusalam (Baytal Makdis) himadil sin paghinang sin Haylaya Paglappas dayn ha Kamatay, nakarungug sin in hi Īsa magkakawn pa Awrusalam (Baytal Makdis). ");
INSERT INTO tsg_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Hangkan kimawaꞌ sila manga sanga dahunan, ampa sila miyadtu miyāk kan Īsa. Naglami-lami sila nagꞌulang, laung nila, “Pudjihun natuꞌ in Tuhan! Bang mayan barakatan in siya amu in kiyawakilan sin Tuhan! Bang mayan barakatan sin Tuhan in magbayaꞌ ha bangsa Israil!” ");
INSERT INTO tsg_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Sakali nakabaak hi Īsa hambuuk kuraꞌ amu in piyanguraan niya. Na, naagad tuud in asal kiyasulat ha lawm Kitab, amu agi, ");
INSERT INTO tsg_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Manga tau ha Awrusalam (Baytal Makdis). Ayaw na kamu mabugaꞌ! Kitaa niyu ba, yan na tudju mawn kaniyu in makapagbayaꞌ kaniyu. Manguraꞌ siya ha kuraꞌ, amu in anak kuraꞌ walaꞌ pa kiyapanguraan.” ");
INSERT INTO tsg_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ha waktu yadtu walaꞌ kiyahātihan sin manga mulid hi Īsa in pasal sin ini katān. Subay na hi Īsa nakabalik pa surgaꞌ iban nagmattan na tuud in kawasa iban kalagguan niya ampa nila kiyatumtuman in kiyabaytaꞌ ha lawm Kitab pasal hi Īsa iban kiyatumtuman nila da isab in nahinang nila kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Hangkan mataud tau in miyāk kan Īsa sabab nakarungug sila sin muꞌjijat nahinang hi Īsa, amu in pagtāg niya kan Lasarus dayn ha lawm kubul iban biyuhiꞌ nagbalik dayn ha kamatay. In nagsuysuy kanila pasal yan, amu in manga tau bakas duun ha kubul nakakitaꞌ ha waktu yadtu sin nahinang hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Hangkan, laung sin manga Parisi pa kaibanan Parisi, “Na, kitaa niyu. Napalsu da in palanu natuꞌ. In tau katān magad da kaniya!” ");
INSERT INTO tsg_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na, manjari awn isab manga tau bangsa Girik in himadil sin pagpudji ha waktu sin Haylaya ha Awrusalam (Baytal Makdis). ");
INSERT INTO tsg_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Miyadtu sila kan Pilip, hambuuk mulid hi Īsa dayn ha kawman Bitsayda ha hulaꞌ Jalil. Laung nila kan Pilip, “Tuwan, mabayaꞌ kami kumitaꞌ kan Īsa.” ");
INSERT INTO tsg_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Na, miyadtu hi Pilip namaytaꞌ kan Andariyas. Ubus ampa sila karuwa miyadtu namaytaꞌ kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Laung hi Īsa kanila, “Na, bihaun masuuk na tuud dumatung in waktu kiyagantaꞌ in aku amu in Anak Mānusiyaꞌ karihilan na sin kalagguan dakulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Baytaan ta kamu sin bunnal. In hangsulag binhiꞌ diꞌ tumaud bang diꞌ hitanum pa lupaꞌ biyaꞌ sapantun patay hikubul. Sagawaꞌ bang hikatanum na, tumubuꞌ yan iban tumaud in bunga. ");
INSERT INTO tsg_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Na, damikkiyan biyaꞌ da isab ha yan in tau. Bang in tau maūg sin kabuhiꞌ niya, iban magpikil sadja sin kabayaan niya mapatay da siya. Sagawaꞌ bang in tau diꞌ maūg sin kabuhiꞌ niya dī ha dunya, taga kabuhiꞌ siya salama-lama. ");
INSERT INTO tsg_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Na, hisiyu-siyu in mabayaꞌ mahinang daraakun ku, subay siya magad kākuꞌ lumabay sin unu-unu haggut-pasuꞌ, ha supaya taptap in pagꞌagad namuꞌ. Iban hisiyu-siyu in maghulas-sangsaꞌ kākuꞌ lagguun siya sin Amaꞌ ku.” ");
INSERT INTO tsg_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Laung pa isab hi Īsa, “Bihaun landuꞌ tuud nasusa in lawm atay ku. Sagawaꞌ minsan biyaꞌ ha yan, diꞌ ku pangayuun ha Amaꞌ ku in puasun niya aku dayn ha kabinsanaan kumugdan kākuꞌ, sabab hangkan na aku miyari ha supaya lumabay sin kabinsanaan ini.” ");
INSERT INTO tsg_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ubus ampa namichara hi Īsa pa Tuhan, laung niya, “Ya Amaꞌ, dihili kalagguan in ngān mu!” Sakali magtūy awn suwara dayn ha langit, amu agi sin suwara, “Bakas ku na dīhilan kalagguan iban dihilan ku da kalagguan magbalik.” ");
INSERT INTO tsg_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Manjari in manga tau mataud nagtitindug duun nakarungug sin suwara. Laung sin kaibanan, “Uy, nagdawgdug hayn-duun.” Sagawaꞌ laung isab sin kaibanan, “Malāikat sa yadtu in namichara kan Īsa!” ");
INSERT INTO tsg_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Sagawaꞌ laung hi Īsa kanila, “In suwara yadtu piyarungug, bukun ha hikarayaw ku, sagawaꞌ ha hikarayaw niyu. ");
INSERT INTO tsg_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Bihaun naabut na in waktu hirihil in hukuman bang hisiyu tuud in tagakawasa ha manga mānusiyaꞌ. Bihaun in Saytan Puntukan amu in nagbabayaꞌ ha manga mānusiyaꞌ dī ha dunya, maīg na in kusug sin kawasa niya. ");
INSERT INTO tsg_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Bang aku hikalansang na pa usuk ampa in usuk yan patindugun, na mataud in tau kawaun ku paagarun kākuꞌ dayn ha katilingkal dunya.” ");
INSERT INTO tsg_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Namichara hi Īsa biyaꞌ hādtu hipagpahāti ha manga tau bang biyaꞌ diin in pagpatay kaniya ha susūngun. ");
INSERT INTO tsg_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Laung sin manga tau mataud, “Kaingatan namuꞌ in baytaꞌ ha lawm Kitab sin in Almasi, mabuhiꞌ salama-lama. Sagawaꞌ in agi mu in tau amu in Anak Mānusiyaꞌ, subay hikalansang pa usuk ampa in usuk yan patindugun. Na, hisiyu bahaꞌ in piyagꞌiyan mu yan, Anak Mānusiyaꞌ?” ");
INSERT INTO tsg_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","In sambung hi Īsa kanila, “Bihaun yari pa dī kaniyu in ilaw amu in dumihil kasawahan kaniyu, sagawaꞌ bukun na malugay mīg na in ilaw dayn kaniyu. Hangkan pangandul kamu ha ilaw bābā yari pa dī kaniyu in ilaw, ha supaya kamu diꞌ abutan sin tigidlum. Karnaꞌ in tau manaw ha lawm katigidluman diꞌ niya kaingatan in dūngan niya bang harap pakain. ");
INSERT INTO tsg_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Hangkan ha salugay sin ilaw dī kaniyu, pangandul kamu ha ilaw yan, ha supaya kamu mahinang sukuꞌ sin ilaw yan.” Pagꞌubus hi Īsa nagbichara, minīg siya dayn kanila ampa siya miyadtu pa diꞌ nila kaingatan. ");
INSERT INTO tsg_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Na, in manga tau masi diꞌ magparachaya kan Īsa minsan da mataud na muꞌjijat in kītaꞌ nila nahinang hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Na in yan amu in magpakitaꞌ sin bunnal tuud in bichara hi Nabi Isayas kiyasulat ha lawm Kitab, amu agi, “Ya Tuhan ku, wayruun magparachaya sin baytaꞌ namuꞌ. In manga tau nakakitaꞌ sin kusug sin kawasa mu, hangkatiyuꞌ da in nakahāti.” ");
INSERT INTO tsg_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Lāgiꞌ kiyabaytaꞌ da isab hi Isayas bang maytaꞌ in manga tau walaꞌ nagparachaya. Amu agi niya, ");
INSERT INTO tsg_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Diyūlan sin Tuhan maīg dayn ha mata sin manga tau diꞌ magparachaya in ingat sumilang sin unu-unu kakitaan nila, iban diyūlan sin Tuhan maīg dayn ha pikilan nila in ingat sumilang sin kasabunnalan ha supaya sila diꞌ makahāti. Iban diꞌ magbalik in atay nila kākuꞌ,” amu agi sin Tuhan, “bat ku mapuas in manga dusa nila.” ");
INSERT INTO tsg_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","In yari kiyasulat hi Isayas sabab kītaꞌ niya in sahaya hi Īsa. Hangkan in piyagꞌiyan niya yan way dugaing bang bukun hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Na, minsan biyaꞌ hādtu, mataud manga nakuraꞌ Yahudi in nagkahagad kan Īsa, sagawaꞌ walaꞌ sila nagpatampal sabab in kabugaan nila diꞌ na sila palamurun sin manga Parisi ha lawm langgal nila. ");
INSERT INTO tsg_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Lāgiꞌ labi mahargaꞌ kanila in masulut nila in kabayaan sin pagkahi nila mānusiyaꞌ dayn sin sumulut sin kabayaan sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Manjari namung matanug hi Īsa, laung niya, “Hisiyu-siyu in magparachaya kākuꞌ bukun sadja isab aku in pagparachayahan niya, sagawaꞌ magparachaya da isab siya ha Tuhan amu in nagdaak kākuꞌ mari. ");
INSERT INTO tsg_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Damikkiyan, hisiyu-siyu in nakakitaꞌ kākuꞌ, saliꞌ niya da tuud kītaꞌ in nagdaak kākuꞌ mari. ");
INSERT INTO tsg_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","In aku miyari pa dunya dumihil kasawahan ha manga mānusiyaꞌ, ha supaya hisiyu-siyu in magparachaya kākuꞌ makaguwaꞌ na siya dayn ha lawm katigidluman. ");
INSERT INTO tsg_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Na, hisiyu-siyu in makarungug sin baytaꞌ ku ampa siya diꞌ magkahagad, diꞌ ku siya butangan hukuman. Karnaꞌ in maksud ku miyari bukun manghukum ha manga mānusiyaꞌ sagawaꞌ mamuas kanila dayn ha manga dusa nila. ");
INSERT INTO tsg_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Sagawaꞌ hisiyu-siyu in diꞌ tumaymaꞌ kākuꞌ iban diꞌ magparachaya sin baytaꞌ ku, ha adlaw mahuli kugdanan siya sin hukuman. Iban hangkan siya kugdanan sin hukuman sabab walaꞌ niya iyagad in baytaꞌ ku. ");
INSERT INTO tsg_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Sabab in baytaꞌ ku yan bukun guwaꞌ dayn kākuꞌ, sagawaꞌ dayn ha Amaꞌ ku. Amura in kiyabichara ku iban kiyahinduꞌ ku kaniyu in daakan kākuꞌ sin Amaꞌ ku amu in nagdaak kākuꞌ mari. ");
INSERT INTO tsg_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na, kaingatan ku sin in daakan niya makarihil kabuhiꞌ salama-lama. Hangkan unu-unu na in kiyabaytaꞌ ku, in yan amuna in daakan kākuꞌ sin Amaꞌ ku.” ");
INSERT INTO tsg_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Manjari ha walaꞌ pa timagnaꞌ in Haylaya Paglappas dayn ha Kamatay, asal na kiyaingatan hi Īsa sin masuuk na in waktu niya mamutawan dayn ha dunya ini iban magbalik na siya madtu pa Amaꞌ niya. Asal dayn sin tagnaꞌ kalasahan tuud hi Īsa in manga tau sukuꞌ niya. Hangkan ha waktu ini piyakitaꞌ niya tuud in kusug sin lasa niya ha manga tau sukuꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Sakali narūm mayan in hi Īsa iban sin manga mulid niya nagsāw nagkaun. In hi Judas, anak hi Simun tau dayn ha Kiriyud asal biyutangan na pamikil manipu kan Īsa kaagi sin Iblis. ");
INSERT INTO tsg_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Asal kiyaiingatan hi Īsa sin in katān kawasa sin Tuhan, Amaꞌ niya, kiyarihil na kaniya. Lāgiꞌ kiyaiingatan niya sin in siya guwaꞌ dayn ha Tuhan iban magbalik da siya pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Sakali timindug hi Īsa dayn ha lamisahan piyagkakaunan nila, ampa niya inīg in hanglapis badjuꞌ niya. Ubus ampa siya nanapis sin jimpaw. ");
INSERT INTO tsg_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Pagꞌubus, ampa niya biyutangan tubig in pastan, hiyugasan niya na in siki sin manga mulid niya ampa tiyarapuhan niya sin jimpaw piyananapis niya. ");
INSERT INTO tsg_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Na, pagkawn niya mayan humugas sin siki hi Simun Pitrus, diꞌ mabayaꞌ hi Pitrus. Amu agi niya kan Īsa, “Uy, Panghuꞌ, ikaw in humugas sin siki ku?” ");
INSERT INTO tsg_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","In sambung hi Īsa kaniya, “In hinang ku ini bihaun diꞌ mu kahātihan, sagawaꞌ ha susūngun kahātihan mu da.” ");
INSERT INTO tsg_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Sagawaꞌ laung hi Pitrus, “Tantu diꞌ ta kaw tuud papaghugasun sin siki ku!” In sambung hi Īsa kaniya, “Bang ku diꞌ kahugasan in siki mu, in ikaw diꞌ na maitung mulid ku.” ");
INSERT INTO tsg_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Na, laung hi Simun Pitrus, “Na, pagga biyaꞌ ha yan Panghuꞌ, bukun sadja siki ku in hugasan mu, sagawaꞌ hugasi sampay pa lima iban ū ku!” ");
INSERT INTO tsg_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Laung hi Īsa, “Bang in tau bakas na namayguꞌ, in baran niya malanuꞌ na. Amu dakuman siki niya in subay hugasan magbalik. In kamu katān suchi in pangatayan, sagawaꞌ awn hambuuk kaniyu in bukun.” ");
INSERT INTO tsg_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Asal kiyaiingatan hi Īsa bang hisiyu in manipu kaniya. Hangkan na siya imiyan, laung niya, “In kamu katān suchi in pangatayan, sagawaꞌ awn hambuuk kaniyu in bukun.” ");
INSERT INTO tsg_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Manjari naubus mayan hi Īsa naghugas sin siki sin manga mulid niya, siyulug niya nagbalik in hanglapis badjuꞌ niya ampa siya limingkud nagbalik. Paglingkud niya, iyasubu niya in manga mulid niya, laung niya, “Kiyahātihan niyu da ka in hīnang ku kaniyu hayn-duun? ");
INSERT INTO tsg_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tuwan iban Panghuꞌ in pagtawag niyu kākuꞌ. Na, nakaamu in pagtawag niyu kākuꞌ, sabab aku in guru iban Panghuꞌ niyu. ");
INSERT INTO tsg_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na, pagga in aku amu in guru iban Panghuꞌ niyu himugas sin siki niyu, na subay niyu singuran in hinang ku. Subay kamu maghugas-hiyugasi sin siki sin kamu hangka-agaran. ");
INSERT INTO tsg_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","In hīnang ku yadtu hambuuk suntuan, piyakitaꞌ ku kaniyu ha supaya niyu kasinguran. ");
INSERT INTO tsg_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ini in mattan hibaytaꞌ ku kaniyu,” laung hi Īsa. “In tindug bukun makawasa dayn ha nakuraꞌ. Damikkiyan, in daraakun bukun makawasa dayn ha nagdaak kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Pagga niyu kahātihan na in hinduꞌ ku yan, na bang niyu yan agarun hinangun awn karayawan niyu! ");
INSERT INTO tsg_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Malayngkan,” laung hi Īsa, “in bichara ku yan diꞌ kumugdan ha kaniyu katān, sabab asal ku kaingatan bang hisiyu in pinīꞌ ku magad kākuꞌ. Sagawaꞌ maagad tuud in kiyasulat ha lawm Kitab, amu agi, ‘In tau simāw kākuꞌ nagkaun amu in manipu kākuꞌ!’ ");
INSERT INTO tsg_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Biyaytaan ta kamu bihaun sin pasal yan ha walaꞌ pa miyabut, ha supaya bang yan maabut na, magparachaya na kamu bang hisiyu aku. ");
INSERT INTO tsg_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Na, baytaan ta kamu sin mattan. Hisiyu-siyu in tumaymaꞌ ha tau diyaak ku, saliꞌ da aku in tiyaymaꞌ niya. Damikkiyan, hisiyu-siyu in tumaymaꞌ kākuꞌ, saliꞌ da isab tiyaymaꞌ niya in nagdaak kākuꞌ mari.” ");
INSERT INTO tsg_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pagꞌubus hi Īsa namichara biyaꞌ hādtu, landuꞌ tuud siya nasusa. Laung niya ha manga mulid niya, “Baytaan ta kamu sin mattan. Awn hambuuk dī kaniyu in manipu kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Na, nagꞌiyaturi in manga mulid niya sartaꞌ nagꞌinu-inu bang hisiyu in piyagꞌiyan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Na, awn hambuuk mulid amu in kalasahan hi Īsa in naglilingkud ha daig niya. ");
INSERT INTO tsg_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","In mulid ini sīnyalan hi Simun Pitrus. Laung hi Pitrus, “Asubuha kunuꞌ hi Tuwan bang hisiyu in piyagꞌiyan niya.” ");
INSERT INTO tsg_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Na, simuuk in mulid ini mawn kan Īsa ampa imiyan, amu agi, “Panghuꞌ, hisiyu in tumipu kaymu?” ");
INSERT INTO tsg_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","In sambung hi Īsa, “In tau dihilan ku sin tinapay hitublak ku pa lāy pagbabahug-bahugan amuna in tau piyagꞌiyan ku.” Na, kimāꞌ na hi Īsa tinapay ampa tiyublak pa pagbabahug-bahugan. Ubus ampa niya diyuhal kan Judas, anak hi Simun tau dayn ha Kiriyud. ");
INSERT INTO tsg_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Sakali pagtabuk na mayan hi Judas sin tinapay, nagtūy siya siyūd sin Saytan Puntukan. Laung hi Īsa kaniya, “Ūs-ꞌūs na kaw bat mu mahinang in hinangun mu!” ");
INSERT INTO tsg_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Sagawaꞌ walaꞌ nakahāti in manga mulid sin bichara hi Īsa kan Judas. ");
INSERT INTO tsg_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","In pangannal sin kaibanan mulid, pagga hi Judas in nagkakaput sin manga sīn nila, na diyaak siya hi Īsa madtu mamī-mī sin pagjamuhan nila atawa dumihil sarakka ha manga miskin. ");
INSERT INTO tsg_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pagtabuk na mayan hi Judas sin tinapay, magtūy siya gimuwaꞌ. Na, in waktu sin pagguwaꞌ niya yadtu dūm na tuud. ");
INSERT INTO tsg_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Na, nakaīg mayan hi Judas, laung hi Īsa ha manga mulid niya, “Na, bihaun hipakitaꞌ na in kalagguan ku, amu in Anak Mānusiyaꞌ, iban kakitaan da isab in kawasa sin Tuhan dayn ha sabab sin hinang ku. ");
INSERT INTO tsg_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na, bang ku mapakitaꞌ in kawasa sin Tuhan dayn ha hinang ku, na magtūy da isab hipakitaꞌ sin Tuhan in kalagguan ku amu in Anak Mānusiyaꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Manga anak mulid ku,” laung hi Īsa, “in aku diꞌ na lumugay dī kaniyu. Bihaun baytaan ta na kamu sin biyaꞌ kiyabaytaꞌ ku ha manga nakuraꞌ Yahudi. Lawagun niyu aku sagawaꞌ diꞌ kamu makaurul kākuꞌ pa kadtuan ku. ");
INSERT INTO tsg_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Na, bihaun yari awn baꞌgu daakan hibīn ku kaniyu. Paglasa-liyasahi kamu biyaꞌ sin lasa ku kaniyu. ");
INSERT INTO tsg_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Bang kamu maglasa-liyasahi na, kaingatan sin manga tau sin in kamu mattan manga mulid ku.” ");
INSERT INTO tsg_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Laung hi Simun Pitrus kaniya, “Maytaꞌ Panghuꞌ, pakain kaw?” In sambung hi Īsa, “Bihaun diꞌ kaw makaagad pa kadtuan ku, sagawaꞌ ha susūngun makaurul da kaw kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Laung hi Pitrus, “Panghuꞌ, maytaꞌ aku diꞌ makaagad kaymu? Lillaꞌ aku umunung matay kaymu!” ");
INSERT INTO tsg_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Sagawaꞌ sambung hi Īsa kan Pitrus, “Kabawgbugan mu ka in bichara mu yan sin lillaꞌ kaw umunung matay kākuꞌ? Indani in bichara ku ini. Ha diꞌ pa tumagauk in manuk usug, makatū kaw umiyan, laung mu, diꞌ mu aku kaingatan.” ");
INSERT INTO tsg_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Manjari laung hi Īsa ha manga mulid niya, “Ayaw niyu pasusaha in atay niyu. Pangandul sadja kamu pa Tuhan iban pangandul isab kamu kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ha ukuman sin Tuhan, Amaꞌ ku, mataud in kabutangan. Diꞌ ta kamu baytaan bang yan bukun bunnal. Hangkan madtu aku magbalik pa hulaan ku ha supaya ta kamu katagamahan sin hulaan niyu. ");
INSERT INTO tsg_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Pagꞌubus bang ku yan matagama na, magbalik aku mari kumāꞌ kaniyu ampa ta kamu paagarun pa hulaan ku ha supaya in hulaan ku amu isab in hulaan niyu. ");
INSERT INTO tsg_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Na, kaingatan niyu da in dān pa hulaꞌ kadtuun ku.” ");
INSERT INTO tsg_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Laung hi Tumas kan Īsa, “Panghuꞌ, diꞌ namuꞌ kaingatan in hulaꞌ kadtuun mu. Hangkan biyaꞌ diin in kaingat namuꞌ sin dān tudju madtu?” ");
INSERT INTO tsg_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","In sambung hi Īsa kaniya, “Aku in dān labayan pa Tuhan. Aku in puunan sin kasabunnalan, lāgiꞌ aku da isab in puunan sin kabuhiꞌ. Wayruun makakadtu pa Tuhan, Amaꞌ ku, bang bukun aku in labayan niya. ");
INSERT INTO tsg_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Na, bihaun pagga niyu aku kaingatan na,” laung hi Īsa kanila, “na kaingatan niyu na isab in Amaꞌ ku. Iban tagnaan dayn ha bihaun kaingatan niyu na tuud siya iban kītaꞌ niyu na siya.” ");
INSERT INTO tsg_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Laung hi Pilip kan Īsa, “Panghuꞌ, panyataan kāmuꞌ in Amaꞌ mu ampa kami magkahagad.” ");
INSERT INTO tsg_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","In sambung hi Īsa kaniya, “Pilip, malugay na aku dī kaniyu, sagawaꞌ masi namān kaw awam pasal ku. Hisiyu-siyu in nakakitaꞌ kākuꞌ, na biyaꞌ niya da kītaꞌ tuud in Amaꞌ ku. Na, maytaꞌ in kabayaan mu subay pa hipanyataꞌ kaymu in Amaꞌ ku? ");
INSERT INTO tsg_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Maytaꞌ, Pilip, diꞌ kaw magparachaya sin in aku kakkal himahambuuk ha Amaꞌ ku iban in Amaꞌ ku kakkal himahambuuk kākuꞌ? In katān kiyahinduꞌ ku kaniyu,” laung hi Īsa ha manga mulid niya, “bukun naug dayn kākuꞌ sagawaꞌ dayn ha Amaꞌ ku, amu in kakkal himahambuuk kākuꞌ. In katān hinang ku hinang da isab sin Amaꞌ ku, karnaꞌ siya in himinang sin katān yan. ");
INSERT INTO tsg_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Pagparachaya kamu sin baytaꞌ ku sin in aku kakkal himahambuuk ha Amaꞌ ku iban in Amaꞌ ku kakkal himahambuuk kākuꞌ. Bang sawpama diꞌ kamu magparachaya sin baytaꞌ ku yan, na magparachaya kamu ha manga hinang kītaꞌ niyu nahinang ku. ");
INSERT INTO tsg_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Baytaan ta kamu sin kasabunnalan. Hisiyu-siyu in magparachaya kākuꞌ, makahinang siya sin mahinang ku. Lāgiꞌ, lumabi pa in hinang niya, sabab in aku magbalik na madtu pa Amaꞌ ku. ");
INSERT INTO tsg_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na, unu-unu in pangayuun niyu sabab sin pangandul niyu kākuꞌ, na, hirihil ku kaniyu, ha supaya dayn ha hinang ku mapakitaꞌ in kalagguan sin Tuhan, Amaꞌ ku. ");
INSERT INTO tsg_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Bang kamu mangayuꞌ kākuꞌ unu-unu na ha sabab sin pangandul niyu kākuꞌ, hirihil ku kaniyu in pangayuun niyu.” ");
INSERT INTO tsg_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Laung pa isab hi Īsa, “Bang kamu malasa kākuꞌ, agarun niyu hadja in katān daakan ku. ");
INSERT INTO tsg_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Pangayuan ta kamu ha Amaꞌ ku hambuuk Mananabang gantiꞌ ku, amu in dumuun kaniyu kasaumulan. ");
INSERT INTO tsg_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","In Mananabang ini amuna in Rū sin Tuhan, amu in mamaytaꞌ sin kasabunnalan pasal sin Tuhan. Na, in manga tau bukun agad ha Tuhan diꞌ makataymaꞌ ha Mananabang ini, sabab diꞌ nila siya kahātihan iban diꞌ nila siya kaingatan. Sagawaꞌ in kamu, kaingatan niyu siya sabab yari siya, kiyakahagad niyu siya iban taptap siya ha lawm atay niyu. ");
INSERT INTO tsg_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Minsan aku mutas dayn kaniyu, diꞌ ta kamu pasāran. Magbalik da aku mari kaniyu. ");
INSERT INTO tsg_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Bukun na malugay diꞌ na aku kakitaan sin manga tau bukun agad ha Tuhan. Sagawaꞌ kakitaan aku magbalik ha susūngun. Na, pagga aku taga kabuhiꞌ salama-lama, na in kamu ha susūngun taga kabuhiꞌ da isab salama-lama. ");
INSERT INTO tsg_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Bang dumatung na in waktu yan, kaingatan niyu na sin in aku iban sin Amaꞌ ku naghahambuuk tuud. Damikkiyan, in aku iban sin kamu naghahambuuk da isab. ");
INSERT INTO tsg_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Hisiyu-siyu in tumaymaꞌ iban magkahagad sin daakan ku, amuna in tau malasa kākuꞌ lāgiꞌ hisiyu-siyu in malasa kākuꞌ kalasahan da isab sin Amaꞌ ku. Damikkiyan, in aku malasa da isab ha tau yan, iban hipaingat ku kaniya in katān kahālan pasal ku.” ");
INSERT INTO tsg_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Sakali laung hi Judas, bukun hi Judas tau dayn ha Kiriyud, “Panghuꞌ, maytaꞌ kami sadja in paingatun mu sin kahālan mu, hāti in mānusiyaꞌ katān diꞌ mu paingatun?” ");
INSERT INTO tsg_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","In sambung hi Īsa kaniya, “Hisiyu-siyu in malasa kākuꞌ magkahagad sin hinduꞌ ku. Kalasahan siya sin Amaꞌ ku, lāgiꞌ in aku iban sin Amaꞌ ku duun taptap kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Sagawaꞌ in tau diꞌ malasa kākuꞌ diꞌ magkahagad sin hinduꞌ ku. Na, in hinduꞌ ku yan diyungug niyu bukun guwaꞌ dayn kākuꞌ, sagawaꞌ dayn ha Amaꞌ ku amu in nagdaak kākuꞌ mari. ");
INSERT INTO tsg_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Na, in manga yan asal ku na biyaytaꞌ kaniyu ha salugay ku dī pa kaniyu. ");
INSERT INTO tsg_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Sagawaꞌ ha susūngun in Mananabang amu in Rū sin Tuhan patulunun sin Tuhan mawn kaniyu gumantiꞌ kākuꞌ. Hinduan niya kamu sin unu-unu katān, iban siya in magpatumtum kaniyu sin katān kiyahinduꞌ ku kaniyu. ");
INSERT INTO tsg_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Kasannyangan sin lawm atay iban pikilan in hibīn ku dī kaniyu. In kasannyangan yan guwaꞌ dayn kākuꞌ, iban diꞌ yan magsaliꞌ iban sin kasannyangan hikarihil kaniyu sin pagkahi niyu mānusiyaꞌ. Hangkan ayaw niyu pasusaha in lawm atay niyu. Ayaw kamu mabugaꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Biyaꞌ na sin agi ku kaniyu, in aku magꞌiīg na dayn kaniyu, sagawaꞌ magbalik da aku mari kaniyu. Na, bang kamu malasa kākuꞌ, subay kamu kūgan sin magbalik na aku madtu pa Amaꞌ ku, karnaꞌ labi siya makawasa dayn kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Biyaytaꞌ ku na yan kaniyu bihaun ha walaꞌ pa naabut, ha supaya bang yan maabut na, na magparachaya na kamu. ");
INSERT INTO tsg_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Na, diꞌ na aku makapahabaꞌ sin bichara ku kaniyu, sabab masuuk na dumatung in Saytan Puntukan, amu in magbayaꞌ dī ha lawm dunya ini. In aku diꞌ niya kapagbayaan. ");
INSERT INTO tsg_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Sagawaꞌ subay kaingatan sin manga mānusiyaꞌ katān sin malasa aku ha Amaꞌ ku, hangkan akuhun ku in katān daakan hipahinang niya kākuꞌ.” Na, mahuli dayn duun, laung hi Īsa, “Sūng na. Mīg na kitaniyu dayn dī.” ");
INSERT INTO tsg_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Manjari nagdalil hi Īsa ha manga mulid niya, laung niya, “Aku in puunan batangan sin tiyanum iban Amaꞌ ku in magparuli sin tiyanum. ");
INSERT INTO tsg_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Bang awn sanga ha batangan sin tiyanum ini in diꞌ magbunga, īgan sin Amaꞌ ku. Sagawaꞌ bang in sanga magbunga, hawanan niya yan, ha supaya tumaud in bunga. ");
INSERT INTO tsg_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Na, in kamu yan limanuꞌ na pasal sin hinduꞌ ku kaniyu. ");
INSERT INTO tsg_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Sagawaꞌ subay kamu tutug humambuuk kākuꞌ, iban in aku tutug humambuuk kaniyu. Karnaꞌ biyaꞌ da sa yan sapantun sin sanga. Bang yan matigpuꞌ dayn ha puunan batangan niya, na, diꞌ yan magbunga. Magbunga sadja yan bang diꞌ matigpuꞌ dayn ha puunan batangan niya. Damikkiyan, in kamu, diꞌ kamu makahinang sin marayaw bang kamu bukun tutug himahambuuk kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“In aku amuna in biyaꞌ sapantun puunan batangan sin tiyanum, hāti in kamu amuna in manga sanga. Hisiyu-siyu in tutug humambuuk kākuꞌ iban tutug da isab aku humambuuk kaniya, na, sumūng in dayaw sin kawl-piil niya biyaꞌ sin sanga mataud bunga niya. Sagawaꞌ bang kamu umukat dayn kākuꞌ, in guwaan sin manga hinang niyu way kapūsan. ");
INSERT INTO tsg_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Hisiyu-siyu in diꞌ tumutug humambuuk kākuꞌ hibugit siya biyaꞌ sapantun sin sanga uturun patahayun. Ubus in katān sanga biyaꞌ ha yan tipunun ampa hilaruk pa kāyu sunugun. ");
INSERT INTO tsg_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Sagawaꞌ bang kamu tutug humambuuk kākuꞌ, iban pahūpun niyu pa lawm pikilan niyu in hinduꞌ ku, na hirihil ku kaniyu in unu-unu pangayuun niyu kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Bang sumūng in dayaw sin kawl-piil niyu, na, in yan amu in magpakitaꞌ sin kalagguan sin Tuhan, iban dayn duun kaingatan na sin in kamu tantu tuud manga mulid ku. ");
INSERT INTO tsg_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“In lasa ku kaniyu biyaꞌ da sin lasa sin Amaꞌ ku kākuꞌ. Hangkan tawꞌan ha lawm atay niyu in lasa ku kaniyu. ");
INSERT INTO tsg_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Bang niyu agarun in daakan ku tumutug in lasa ku kaniyu. Biyaꞌ da isab sin aku iyagad ku in daakan kākuꞌ sin Amaꞌ ku, hangkan tutug in lasa niya kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Biyaytaan ta kamu ha yan ha supaya taptap kananaman niyu in kakuyagan guwaꞌ dayn kākuꞌ, iban ha supaya jumukup in kakuyagan niyu. ");
INSERT INTO tsg_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Na, bihaun amu tuud ini in daakan ku kaniyu. Paglasa-liyasahi kamu biyaꞌ sin lasa ku kaniyu. ");
INSERT INTO tsg_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Bang awn tau lillaꞌ matay pasal sin lasa niya ha manga bagay niya, na wayruun na makaliyu sin lasa biyaꞌ ha yan. ");
INSERT INTO tsg_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","In manga kamu yan, bagay ku na, bang niyu agarun in unu-unu daakan ku kaniyu. ");
INSERT INTO tsg_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Diꞌ ta na kamu itungun manga tindug ku, sabab in tindug diꞌ pagpaingatun sin nakuraꞌ sin unu-unu katān pasal niya. Sagawaꞌ in manga kamu yan itungun ku na manga bagay ku tuud sabab piyaingat ku na kaniyu in katān diyungug ku dayn ha Amaꞌ ku. ");
INSERT INTO tsg_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Bukun kamu in nagpīꞌ kākuꞌ manghinduꞌ kaniyu, sagawaꞌ aku in nagpīꞌ kaniyu hīnang manga wakil ku huminang sin manga marayaw. In karayawan sin hinang niyu yan tumatas kasaumulan. Hangkan hirihil sin Amaꞌ ku kaniyu in unu-unu pangayuun niyu, sabab sin pangandul niyu kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Na, ini in daakan ku kaniyu, paglasa-liyasahi kamu.” ");
INSERT INTO tsg_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Laung pa isab hi Īsa, “Na, ayaw kamu mainu-inu, bang kamu kabunsihan sin manga tau bukun agad ha Tuhan. Amu sadja in tumtuma niyu minsan in aku kiyabunsihan nila da. Aku in muna dayn kaniyu kiyabunsihan. ");
INSERT INTO tsg_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Bang sawpama kamu hangka-agaran iban sin manga tau bukun agad ha Tuhan, tantu kalasahan nila kamu. Sagawaꞌ dugaing kamu. Bukun kamu hangka-agaran iban sila sabab pinīꞌ ta kamu piyakandī dayn kanila. Hangkan na sila mabunsi kaniyu. ");
INSERT INTO tsg_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tumtuma niyu in bakas biyaytaꞌ ku kaniyu sin in tindug bukun makawasa dayn ha nakuraꞌ. Pagga in aku ngīꞌ sin manga tau yan, na damikkiyan in kamu ngīun nila da isab. Pagga nila walaꞌ kiyahagad in hinduꞌ ku, na diꞌ nila da isab kahagarun in hinduꞌ niyu. ");
INSERT INTO tsg_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Sagawaꞌ kabunsihan iban ngīun nila kamu sabab in kamu agad kākuꞌ. Hangkan biyaꞌ ha yan in hinang nila kaniyu, sabab diꞌ nila kaingatan tuud in Tuhan amu in nagdaak kākuꞌ mari. ");
INSERT INTO tsg_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Bang aku walaꞌ miyari pa dunya namaytaꞌ kanila sin kasabunnalan diꞌ tumampal in manga dusa nila. Sagawaꞌ bihaun way na hikadaawa nila sin dusa nila, sabab piyaingat ku na kanila in kasabunnalan. ");
INSERT INTO tsg_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Hisiyu-siyu in mabunsi kākuꞌ, kabunsihan niya da isab in Amaꞌ ku. ");
INSERT INTO tsg_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Diꞌ tumampal in manga dusa nila bang nila walaꞌ kītaꞌ sin duwa mata nila in manga hinang nahinang ku amu in walaꞌ nahinang sin minsan hisiyu tau. Sagawaꞌ minsan yan kītaꞌ nila na, masi sila mabunsi kākuꞌ iban ha Amaꞌ ku. ");
INSERT INTO tsg_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Sagawaꞌ asal subay aku kabunsihan nila ha supaya mabunnal in kiyasulat ha lawm saraꞌ biyabantug nila, amu agi, ‘Kabunsihan nila aku minsan way puun sabab.’ ");
INSERT INTO tsg_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Patulunun ku mari kaniyu in Mananabang. In Mananabang ini, amuna in Rū sin Tuhan, amu in mamaytaꞌ sin kasabunnalan pasal sin Tuhan sabab in siya naug dayn ha Tuhan. Patulunun ku siya mawn kaniyu, mamaytaꞌ kaniyu sin pasal ku. ");
INSERT INTO tsg_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na, damikkiyan in kamu mamaytaꞌ da isab ha manga tau sin pasal ku sabab dayn sin tagnaꞌ in kamu miyamagad kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Laung pa isab hi Īsa ha manga mulid niya, “Na, in yan asal ku na biyaytaꞌ kaniyu ha supaya diꞌ maīg in īman niyu kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Sabab ha susūngun diꞌ na kamu palamurun sin manga nakuraꞌ sin agama ha lawm sin manga langgal nila. Lāgiꞌ ha susūngun bang awn tau mamatay hisiyu-siyu na kaniyu, in pangannal niya in nahinang niya yadtu kabayaan sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Biyaꞌ ha yan in hinang sin manga tau yan kaniyu, sabab walaꞌ nila tuud kiyaingatan in Amaꞌ ku iban diꞌ nila da isab aku kaingatan. ");
INSERT INTO tsg_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Biyaytaan ta kamu asal sin pasal yan ha supaya bang maabut na in waktu kabunsihan na kamu sin manga tau yan, na katumtuman niyu in biyaytaꞌ ku kaniyu. “Na in manga yan walaꞌ ku biyaytaꞌ kaniyu sin tagnaꞌ sabab yari pa aku dī kaniyu. ");
INSERT INTO tsg_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Sagawaꞌ bihaun marayꞌ na aku magbalik madtu pa bakas nagdaak kākuꞌ mari pa dunya. Malayngkan, way minsan hambuuk kaniyu in nangasubu bang pakain aku. ");
INSERT INTO tsg_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Na, bihaun landuꞌ nasusa in lawm atay niyu pasal sin biyaytaꞌ ku kaniyu. ");
INSERT INTO tsg_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Sagawaꞌ baytaan ta kamu sin kasabunnalan, hikarayaw kaniyu sin mutas aku dayn kaniyu. Sabab bang aku diꞌ mutas dayn kaniyu, in Mananabang diꞌ makakari kaniyu. Sagawaꞌ bang aku mutas dayn kaniyu, mapakari ku in Mananabang kaniyu. ");
INSERT INTO tsg_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Na, bang dumatung na mari in Mananabang yan, pahātihun niya tuud marayaw in manga tau pasal sin dusa nila, pasal sin kabuntulan iban pasal sin hukuman sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Pahātihun niya in manga tau sin in sila nagdusa pasal walaꞌ sila nagparachaya kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Pahātihun niya in manga tau sin in aku tantu mabuntul tuud sabab in aku magbalik na madtu pa Tuhan, Amaꞌ ku, iban diꞌ niyu na aku kakitaan. ");
INSERT INTO tsg_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Pahātihun niya in manga tau pasal sin hukuman sin Tuhan, karnaꞌ in Saytan Puntukan, amu in magbabayaꞌ ha lawm dunya ini, kiyabutangan na hukuman sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Mataud pa in hibaytaꞌ ku kaniyu, sagawaꞌ bihaun diꞌ marā sin pikilan niyu bang ku hibaytaꞌ kaniyu. ");
INSERT INTO tsg_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Sagawaꞌ bang dumatung na mari in Rū sin Tuhan, amu in magpaingat kaniyu sin kasabunnalan pasal sin Tuhan, hinduan niya kamu sin katān kasabunnalan. In hinduꞌ niya kaniyu bukun guwaꞌ dayn kaniya, sagawaꞌ in unu-unu karungugan niya dayn ha Tuhan amu in hibaytaꞌ niya kaniyu. Baytaan niya kamu bang unu in maawn ha susūngun. ");
INSERT INTO tsg_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Iban dihilan niya aku kalagguan sabab in katān hihinduꞌ niya kaniyu asal da dayn kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","In unu-unu katān sin Amaꞌ ku kākuꞌ da isab, hangkan laung ku kaniyu in unu-unu katān hihinduꞌ kaniyu sin Rū sin Tuhan guwaꞌ dayn kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Laung pa isab hi Īsa, “Bukun na malugay diꞌ niyu na aku kakitaan. Sagawaꞌ bukun na isab malugay kakitaan niyu na aku magbalik.” ");
INSERT INTO tsg_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Na, nagꞌasubu-iyasubuhi na in manga mulid niya kaibanan, laung nila, “Unu bahaꞌ in hāti sin bichara niya yadtu, sin bukun na malugay, diꞌ natuꞌ na siya kakitaan, sagawaꞌ bukun da isab malugay, kakitaan natuꞌ da siya magbalik? Iban imiyan pa isab siya, karnaꞌ in siya magkakadtu pa Amaꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Unu bahaꞌ in hāti sin bichara niya, bukun na malugay? Diꞌ natuꞌ kahātihan bang unu in piyagbibichara niya!” ");
INSERT INTO tsg_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Na, kiyaiingatan hi Īsa sin mabayaꞌ mangasubu kaniya in manga mulid niya. Hangkan laung niya kanila, “Amu ka in piyagꞌasubu-iyasubuhi niyu in hāti sin bichara ku amu in biyaytaꞌ ku kaniyu, laung ku, ‘Bukun na malugay diꞌ niyu na aku kakitaan, sagawaꞌ bukun da isab malugay, kakitaan niyu da aku magbalik’? ");
INSERT INTO tsg_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Na, in bunnal niya, in kamu yan magtangis iban magdukka, sagawaꞌ makuyag in manga tau bukun agad ha Tuhan. Masusa kamu sagawaꞌ kakuyagan in gantiꞌ sin kasusahan niyu. ");
INSERT INTO tsg_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","In kasusahan niyu yan bihaun biyaꞌ da sa yan sapantun sin kasusahan sin hambuuk babai masuuk na magꞌanak. Masusa siya sabab masuuk na dumatung in waktu numanam siya sin masakit. Sagawaꞌ pagꞌubus niya magꞌanak, kalupahan niya na in sakit niyanam niya sabab makuyag na siya sin in anak niya limahil na pa dunya. ");
INSERT INTO tsg_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Na, biyaꞌ da isab ha yan in hantang niyu. Bihaun masusa kamu, sagawaꞌ kakitaan ta kamu magbalik. Lāgiꞌ kūgan tuud kamu iban wayruun makaīg sin kakuyagan niyu yan dayn ha lawm atay niyu. ");
INSERT INTO tsg_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Na, bang dumatung na in waktu yan, minsan kamu diꞌ na mangasubu kākuꞌ unu-unu. Baytaan ta kamu sin bunnal, unu-unu in pangayuun niyu ha Amaꞌ ku sabab sin pangandul niyu kākuꞌ, hirihil niya kaniyu. ");
INSERT INTO tsg_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Dayn sin tagnaꞌ sampay pa bihaun walaꞌ kamu nakapangayuꞌ unu-unu sabab sin pangandul niyu kākuꞌ. Pangayuꞌ kamu ampa kamu karihilan, ha supaya jumukup in kakuyagan niyu.” ");
INSERT INTO tsg_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Laung pa isab hi Īsa, “In manga hinduꞌ kiyahinduꞌ ku kaniyu labay dayn ha manga bichara dalil, sumagawaꞌ awn da waktu dumatung ha susūngun diꞌ ku na hilabay dayn ha manga bichara dalil. Pahantapun ku na tuud kaniyu in paghinduꞌ ku ha pasalan sin Amaꞌ ku. ");
INSERT INTO tsg_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ha waktu susūngun, bang awn pangayuun niyu, baran niyu na in mangayuꞌ ha Amaꞌ ku sabab sin pangandul niyu kākuꞌ. Minsan bukun na aku in mangayuꞌ kaniya para kaniyu, ");
INSERT INTO tsg_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","sabab in Amaꞌ ku malasa kaniyu. Hangkan kamu kiyalasahan niya sabab malasa kamu kākuꞌ iban magparachaya kamu sin naug aku dayn ha Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mattan tuud in aku miyari pa dunya naug dayn ha Tuhan, Amaꞌ ku. Na, bihaun mīg na aku dayn ha dunya ini, madtu na magbalik pa Amaꞌ ku.” ");
INSERT INTO tsg_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Sakali laung sin manga mulid niya kaniya, “Na, bihaun mahantap na in bichara mu kāmuꞌ sabab walaꞌ na kaw nagbichara dalil. ");
INSERT INTO tsg_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Bihaun natantu namuꞌ na tuud sin kaingatan mu in unu-unu katān, sabab minsan in tau diꞌ pa makapangasubu kaymu, kaingatan mu na asal in hipangasubu niya. Hangkan magparachaya na tuud kami sin in ikaw naug dayn ha Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","In sambung hi Īsa kanila, “Bunnal ka yan sin magparachaya na tuud kamu kākuꞌ bihaun? ");
INSERT INTO tsg_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ingat kamu, masuuk na tuud dumatung in waktu in kamu katān makawkanat na. Magꞌuwian na kamu pakaniya-pakaniya pa luggiyaꞌ hulaꞌ niyu. Hibīn niyu na aku isa-isa ku. Sagawaꞌ minsan niyu aku hibīn, awn da iban ku sabab in Amaꞌ ku tutug himahambuuk kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Na, hangkan ku ini biyaytaꞌ kaniyu ha supaya awn kasannyangan sin lawm atay niyu pasal sin paghambuuk niyu iban aku. Pananamun kamu kabinsanaan sin manga tau bukun agad ha Tuhan, sagawaꞌ ayaw kamu mabugaꞌ, sabab diyaug ku na in manga tau bukun agad ha Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Manjari pagꞌubus hi Īsa nagbichara ha manga mulid niya, himangad siya pa langit ampa siya nangarap pa Tuhan, laung niya, “Ya Amaꞌ ku, naabut na in waktu kiyagantaꞌ. Dihili aku kalagguan, aku amu in Anak mu, ha supaya ku isab mapakitaꞌ in kalagguan mu. ");
INSERT INTO tsg_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kiyarihilan mu aku kawasa magbayaꞌ-bayaꞌ ha katān mānusiyaꞌ ha supaya ku karihilan kabuhiꞌ salama-lama in sasukuꞌ sin manga tau kiyasukuꞌ mu kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na, ha supaya in manga mānusiyaꞌ makabaak sin kabuhiꞌ salama-lama, subay nila kaw kaingatan sin ikaw na tuud in hambuuk-buuk Tuhan sabunnal iban subay nila da isab aku kaingatan sin aku amuna in Almasi kiyawakilan mu mari pa dunya. ");
INSERT INTO tsg_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Napakitaꞌ ku na in kalagguan mu dī ha dunya sabab naubus ku na hīnang in katān hinang piyahinang mu kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ya Amaꞌ, dihili aku kalagguan duun ha haddarat mu biyaꞌ sin kalagguan ku sin waktu duun aku kaymu ha walaꞌ pa naawn in dunya ini. ");
INSERT INTO tsg_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Piyahāti ku na ha manga mānusiyaꞌ in pasal mu, amu in manga mānusiyaꞌ siyukuꞌ mu kākuꞌ dī ha lawm dunya. In sila asal manga sukuꞌ mu, ampa siyukuꞌ mu isab sila kākuꞌ. Nagkahagad na sila sin Parman mu, ");
INSERT INTO tsg_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","iban nakaingat na sila sin in katān dīhil mu kākuꞌ tantu tuud naug dayn kaymu. ");
INSERT INTO tsg_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Sabab napasampay ku na kanila in manga hinduꞌ amu in nakawaꞌ ku dayn kaymu iban tiyaymaꞌ nila na. Lāgiꞌ natantu nila na tuud sin in aku naug dayn kaymu iban magparachaya na sila sin in aku naraak mu. ");
INSERT INTO tsg_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“In pangayuan ku ini duwaa bukun amu in manga mānusiyaꞌ katān, sagawaꞌ amu in manga tau siyukuꞌ mu kākuꞌ karnaꞌ in sila asal manga sukuꞌ mu. ");
INSERT INTO tsg_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","In katān sukuꞌ ku, sukuꞌ mu da isab, iban in katān sukuꞌ mu, sukuꞌ ku da isab. Sila ini in magpakitaꞌ sin kalagguan ku. ");
INSERT INTO tsg_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na, bihaun magꞌuuwiꞌ na aku magbalik mawn kaymu. Magꞌiīg na aku dayn ha dunya ini sagawaꞌ in manga tau sukuꞌ ku yari pa masi ha dunya. Ya Amaꞌ ku Mahasuchi, ayari kaagi sin kusug sin kawasa mu, in manga tau amu in dīhil mu kākuꞌ. Ayari sila ha supaya tutug in paghambuuk nila biyaꞌ sin katutug sin paghambuuk ku iban ikaw. ");
INSERT INTO tsg_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ha salugay ku nagꞌaagad iban sin manga tau kiyasukuꞌ mu kākuꞌ, iyaayaran ku sila kaagi sin kusug sin kawasa mu. Wayruun minsan hambuuk kanila in nalawaꞌ dayn kākuꞌ luwal da in hambuuk sukuꞌ sin narkaꞌ amu in asal kiyagantaꞌ malawaꞌ dayn kākuꞌ ha supaya maagad in kiyabaytaꞌ ha lawm Kitab. ");
INSERT INTO tsg_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Na, bihaun magꞌuuwiꞌ na aku magbalik mawn kaymu. Hangkan ha salugay ku pa dī ha dunya hibaytaꞌ ku in katān ini kanila ha supaya in lawm atay nila mahipuꞌ sin kakuyagan biyaꞌ sin kakuyagan ku. ");
INSERT INTO tsg_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Kiyapasampay ku na in hinduꞌ mu pa manga tau sukuꞌ mu. Sakali kiyarugalan sila sin manga pagkahi nila mānusiyaꞌ sabab in manga tau sukuꞌ mu bukun hangka-pikilan iban sin manga tau bukun agad kaymu. Biyaꞌ da isab sila kākuꞌ, bukun hangka-pikilan iban sin manga tau bukun agad kaymu. ");
INSERT INTO tsg_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Malayngkan, bukun in pangayuun ku kaymu in īgan mu sila dayn ha dunya ini, sagawaꞌ in pangayuun ku kaymu ayaran mu sila bat sila diꞌ kapagbayaan sin Iblis, amu in puunan sin katān kangīan. ");
INSERT INTO tsg_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","In manga tau sukuꞌ ku sibuꞌ na tuud iban aku sabab in pikilan nila bukun na biyaꞌ sin pikilan sin manga mānusiyaꞌ dī ha dunya. ");
INSERT INTO tsg_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Bang mayan isab sila pakandihun mu, iban suchihun mu in lawm atay nila. In kasabunnalan sin manga katān kiyabaytaꞌ ha Parman mu amu in makasuchi sin lawm atay nila. ");
INSERT INTO tsg_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Naraak ku na sila mawn pa manga mānusiyaꞌ biyaꞌ da isab sin aku naraak mu mari pa dunya. ");
INSERT INTO tsg_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Iban dayn ha pasal nila hibugsuꞌ ku kaymu in duguꞌ-nyawa ku ha supaya masuchi in lawm atay nila iban tūpun sila mahinang manga sukuꞌ mu. ");
INSERT INTO tsg_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Bukun sadja isab manga mulid ku in pangayuan ku duwaa,” laung hi Īsa, “sagawaꞌ sampay manga tau amu in ha susūngun magparachaya kākuꞌ sabab sin pagnasīhat sin manga mulid ku. ");
INSERT INTO tsg_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Iban, Ya Amaꞌ, pangayuun ku isab kaymu bang mayan isab in sila katān maghangka-atay iban maghangka-pikilan. Bang mayan sila humambuuk kātuꞌ biyaꞌ sin ikaw tutug himahambuuk kākuꞌ iban in aku tutug himahambuuk kaymu. Bang mayan sila humambuuk kātuꞌ ha supaya in manga mānusiyaꞌ magparachaya sin ikaw in nagpakari kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Damikkiyan, kiyarihil ku na kanila in kalagguan biyaꞌ sin kalagguan kiyarihil mu kākuꞌ, ha supaya sila mahambuuk biyaꞌ sin kita maghahambuuk. ");
INSERT INTO tsg_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Tutug aku humambuuk kanila biyaꞌ sin ikaw tutug himahambuuk kākuꞌ, ha supaya sila maghangka-atay tuud. Na, bang sila maghangka-atay na, na kaingatan na sin manga mānusiyaꞌ sin ikaw in nagdaak kākuꞌ mari, iban kaingatan nila na sin kalasahan mu in manga tau sukuꞌ ku biyaꞌ sin lasa mu kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ya Amaꞌ, in kabayaan ku makapaghambuuk aku didtu ha hulaan ku iban sin manga kiyasukuꞌ mu kākuꞌ, ha supaya kakitaan nila in sahaya iban kalagguan ku, amu in kalagguan dīhil mu kākuꞌ pasal asal kaw malasa kākuꞌ ha walaꞌ pa naawn in dunya. ");
INSERT INTO tsg_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Ya Amaꞌ, ikaw in puunan sin kabuntulan. Diꞌ kaw kaingatan sin manga tau bukun agad kaymu, sagawaꞌ kaingatan ta kaw iban kaingatan da isab sin manga tau agad kākuꞌ sin ikaw in nagpakari kākuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Piyahāti ku na kanila in pasal mu, iban diꞌ ku bugtuun in pagpahāti kanila ha supaya humūp in lasa mu kanila biyaꞌ sin lasa mu himūp kākuꞌ, iban ha supaya aku diꞌ malawaꞌ dayn ha lawm atay nila.” ");
INSERT INTO tsg_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Manjari pagꞌubus hi Īsa nangayuꞌ duwaa, miyadtu siya iban sin manga mulid niya pa hansipak sin Sapaꞌ Kidrun. Pagdatung nila pa lugal yaun, timūy siya iban sin manga mulid pa lawm kabbun. ");
INSERT INTO tsg_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Na, kiyaingatan hi Judas, amu in panipu, in lugal kiyadtu hinda Īsa sabab asal niya kabiyaksahan sin mawmu hinda Īsa magtipun duun iban sin manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Hangkan hi Judas in nagmalim ha manga sundalu bangsa Rūm iban sin manga pulis jaga sin Bāy sin Tuhan amu in naraak sin manga nakuraꞌ kaimaman iban sin manga Parisi, madtu pa lawm kabbun. Nagdarā sila manga pakukus, manga tanjuꞌ, iban parul. ");
INSERT INTO tsg_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Sakali asal kiyatalusan hi Īsa in unu-unu katān sūng kumugdan kaniya. Hangkan pagdatung mawn sin manga sundalu iban manga pulis jaga, biyāk niya sila sartaꞌ laung hi Īsa kanila, “Hisiyu in liyawag niyu?” ");
INSERT INTO tsg_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Na, in sambung nila, “Hi Īsa, amu in tau dayn ha Nasarit.” Laung hi Īsa, “Na, aku na sa ini in tau piyaglawag niyu.” Na, in hi Judas amu in manipu kan Īsa, yaun miyamagad ha manga sundalu iban manga pulis jaga. ");
INSERT INTO tsg_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Sakali pagꞌiyan hi Īsa sin siya na in tau piyaglawag nila nakasigput sila pa ulihan iban naligad sila pa lupaꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Na, iyasubu sila nagbalik hi Īsa, laung niya, “Hisiyu in liyawag niyu?” In sambung nila, “Hi Īsa, amu in tau dayn ha Nasarit.” ");
INSERT INTO tsg_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Laung hi Īsa kanila, “Biyaytaan ta na kamu sin aku na in tau piyaglawag niyu. Bang aku tuud in tau piyaglawag niyu, na yari na aku. Sagawaꞌ ayaw niyu lapaya in manga iban ku ini.” ");
INSERT INTO tsg_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Piyamung niya yan ha supaya maagad in bakas kiyapamung niya, amu agi, “Ya Amaꞌ, diꞌ kalawaan minsan hambuuk in manga tau kiyasukuꞌ mu kākuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Sakali ini magtūy liyarut hi Simun Pitrus in pakukus tiyatakus niya, ampa niya liyagut in hambuuk īpun sin Imam Dakulaꞌ. Nautud in taynga dapit pa tuu sin tau liyagut niya. In ngān sin īpun yadtu hi Malkus. ");
INSERT INTO tsg_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Laung hi Īsa kan Pitrus, “Butangan magbalik in pakukus mu pa taguban niya! Akuhun ku in katān kabinsanaan ini sabab asal ini in kiyagantaꞌ kākuꞌ sin Amaꞌ ku.” ");
INSERT INTO tsg_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Na, siyaggaw na hi Īsa sin manga sundalu bangsa Rūm iban sin kapitan nila iban sin manga pulis jaga sin bangsa Yahudi, ampa nila siya hiyukutan. ");
INSERT INTO tsg_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Pagꞌubus ampa nila siya diyā muna madtu kan Annas amu in ugangan usug hi Kayapas. In hi Kayapas amu in Imam Dakulaꞌ sin tahun yadtu. ");
INSERT INTO tsg_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","In hi Kayapas ini amu in bakas nanghinduꞌ ha manga nakuraꞌ Yahudi, sin marayaw pa hambuuk sadja tau in mapatay gantiꞌ sin sila katān. ");
INSERT INTO tsg_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Na, miyurul kan Īsa hi Simun Pitrus iban sin hambuuk mulid, amu in magꞌīngati tuud iban sin Imam Dakulaꞌ. Hangkan in mulid ini nakaagad kan Īsa simūd pa lawm halaman sin bāy sin Imam Dakulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Na, in hi Pitrus duun nakabīn ha guwaꞌ sin lawang. Hangkan gimuwaꞌ nagbalik in mulid amu in magꞌīngati iban sin Imam Dakulaꞌ, ampa niya biyairan piyasūd hi Pitrus dayn ha babai amu in jaga sin lawang. Na, nakasūd na hi Pitrus. ");
INSERT INTO tsg_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Sakali iyasubu hi Pitrus sin babai nagjajaga ha lawang, amu agi, “Bukun ka in ikaw hambuuk mulid sin tau nasaggaw yaun?” Namaylu hi Pitrus, laung niya, “Bukun.” ");
INSERT INTO tsg_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Manjari nagpabaga buling in manga daraakun sin Imam Dakulaꞌ iban sin manga jaga sabab mahaggut in hulaꞌ sin dūm yadtu. Ubus ampa sila duun timindug nagpaanag ha katilibut sin baga kāyu. Na, miyawn hi Pitrus limamud kanila nagpaanag. ");
INSERT INTO tsg_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Manjari siyumariya hi Īsa kaagi hi Annas, amu in bakas Imam Dakulaꞌ, pasal sin manga mulid niya iban sin panghinduꞌ niya ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","In sambung hi Īsa, “In aku nanghinduꞌ duun sadja ha mayran bat karungugan sin manga tau katān. Nanghinduꞌ aku ha manga kalanggalan iban ha Bāy sin Tuhan, amu in pagtitipunan sin manga Yahudi. Bukun tapuk in pagnasīhat ku ha manga tau. ");
INSERT INTO tsg_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Na, maytaꞌ mu aku sumariyahun pasal sin paghinduꞌ ku? In subay sumariyahun mu in manga tau nakarungug sin hinduꞌ ku. Asubuha sila bang unu in biyaytaꞌ ku kanila. Kaingatan nila bang unu in hīnduꞌ ku kanila.” ");
INSERT INTO tsg_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pagꞌubus hi Īsa namichara biyaꞌ hādtu nagtūy siya siyampak ha bayhuꞌ sin hambuuk pulis jaga. Amu agi sin jaga kaniya, “Halipulu kaw ini. Ayaw kaw magpamung biyaꞌ ha yan ha Imam Dakulaꞌ.” ");
INSERT INTO tsg_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","In sambung hi Īsa, “Bang sawpama awn mangīꞌ kiyapamung ku ha Imam Dakulaꞌ, na baytaan pa tau katān yari ha lawm paghuhukuman ini, sagawaꞌ bang wayruun mangīꞌ kiyapamung ku, na maytaꞌ mu aku siyampak?” ");
INSERT INTO tsg_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Na, pagꞌubus tiyukbal na hi Annas hi Īsa pa lawm lima hi Kayapas, amu in Imam Dakulaꞌ, sagawaꞌ in hi Īsa masi hiyuhukutan. ");
INSERT INTO tsg_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Na, in hi Pitrus masi duun nagtitindug ha daig sin kāyu pagpaanagan. Sakali iyasubu siya sin manga kaibanan tau nagtitindug duun, amu agi kaniya, “Bukun ka in ikaw hambuuk mulid sin tau yaun?” Sagawaꞌ namaylu hi Pitrus, laung niya, “Bukun.” ");
INSERT INTO tsg_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sakali namung in hambuuk īpun sin Imam Dakulaꞌ, kampung sin tau amu in nalagut in taynga kaagi hi Pitrus. Amu agi kan Pitrus, “Bukun ka kītaꞌ ta kaw didtu ha lawm sin kabbun miyamagad kan Īsa?” ");
INSERT INTO tsg_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Na, namaylu na isab nagbalik hi Pitrus. Sakali saruun-duun timagauk na in manuk usug. ");
INSERT INTO tsg_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Manjari pagga lapit adlaw na, diyā nila na hi Īsa dayn ha bāy hi Kayapas madtu pa astanaꞌ sin gubnul sin bangsa Rūm. Sagawaꞌ in manga nakuraꞌ Yahudi walaꞌ simūd pa lawm sin astanaꞌ sabab mabaꞌtal sila bang sila sumūd pa bāy sin bukun Yahudi. Ampa bang sila mabaꞌtal diꞌ sila makalamud kumaun sin pagjamu sin Haylaya Paglappas dayn ha Kamatay. ");
INSERT INTO tsg_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Hangkan gimuwaꞌ hi Gubnul Pilatu, miyawn nangasubu ha manga nakuraꞌ Yahudi. Amu agi hi Gubnul Pilatu kanila, “Unu taꞌ in narusa sin tau ini hangkan niyu siya tiyuntutan?” ");
INSERT INTO tsg_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","In sambung nila, “Bang in tau yan walaꞌ nakarusa diꞌ namuꞌ siya dāhun mari kaymu.” ");
INSERT INTO tsg_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Laung hi Pilatu kanila, “Na, pagga biyaꞌ ha yan, dāha niyu na siya ampa niyu butangi hukuman agad ha aturan sin saraꞌ niyu.” In sambung sin manga nakuraꞌ Yahudi, “Way kawasa namuꞌ dumihil hukuman hipapatay in hisiyu-siyu tau nakarusa.” ");
INSERT INTO tsg_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Na, dayn ha sambung nila yan, naagad in bakas bichara hi Īsa pasalan sin bang biyaꞌ diin kaagi in pagpatay kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Sakali simūd nagbalik hi Pilatu pa lawm sin astanaꞌ ampa niya piyatawag hi Īsa iyasubu. Laung niya kan Īsa, “Ikaw na ka in sultan sin manga Yahudi?” ");
INSERT INTO tsg_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","In sambung hi Īsa, “In pangasubu mu yan, guwaꞌ ka dayn ha pikilan mu atawa awn tau dugaing namaytaꞌ kaymu pasal ku?” ");
INSERT INTO tsg_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","In sambung hi Pilatu, “Maytaꞌ, in pangannal mu Yahudi aku? Manga pagkahi mu Yahudi iban sin manga nakuraꞌ kaimaman in timukbal kaymu mari kākuꞌ. Unu in narusa mu?” ");
INSERT INTO tsg_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Na, in sambung hi Īsa, “In hulaꞌ piyagsusultanan ku bukun dī ha dunya ini. Sabab bang in hulaꞌ piyagsusultanan ku bat dī ha dunya ini, na umatu in manga tau agad kākuꞌ ha supaya aku diꞌ masaggaw sin manga nakuraꞌ Yahudi. Sagawaꞌ walaꞌ sila imatu sabab bukun dī ha dunya in hulaꞌ piyagsusultanan ku!” ");
INSERT INTO tsg_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Na, laung hi Pilatu, “Na, bang bihādtu, sultan kaw?” In sambung hi Īsa, “Na, biyaꞌ sin agi mu, in aku sultan. Amu yan in sabab hangkan aku piyagꞌanak iban limahil mari pa dunya ha supaya ku hikabaytaꞌ in kasabunnalan. Na, hisiyu-siyu in agad ha kasabunnalan, magparachaya siya sin baytaꞌ ku.” ");
INSERT INTO tsg_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Laung hi Pilatu, “Unu bahaꞌ in kasabunnalan?” Manjari pagꞌubus hi Pilatu nangasubu kan Īsa, gimuwaꞌ siya nagbalik madtu pa manga Yahudi. Laung niya kanila, “Wayruun dusa niya kiyabaakan ku amu in mapatut ku butangan hukuman. ");
INSERT INTO tsg_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Malayngkan,” laung hi Pilatu, “biyaꞌ na sin pagkabiyaksahan niyu, ha sakabaꞌ waktu sin Haylaya Paglappas dayn ha Kamatay, awn pagpaguwaun ku hambuuk pilisu. Mabayaꞌ kamu paguwaun ku kaniyu in sultan sin manga Yahudi?” ");
INSERT INTO tsg_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Na, imulang in manga nakuraꞌ Yahudi, amu agi, “Ayaw mu siya paguwaa! Hi Barabbas in kabayaan namuꞌ paguwaun mu!” (In hi Barabbas ini hambuuk mundu.) ");
INSERT INTO tsg_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Manjari nagꞌuldin na hi Pilatu palubakan hi Īsa sin lalagut hipanglulubak. ");
INSERT INTO tsg_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pagꞌubus ampa in manga sundalu kimawaꞌ manga sanga kahuy matunuk, ampa nila liyubid hīnang biyaꞌ kuruna ampa siyangun pa ū hi Īsa. Sartaꞌ siyulugan nila hi Īsa sin siub badjuꞌ taluk biyaꞌ sin siub badjuꞌ sin sultan. ");
INSERT INTO tsg_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ubus ampa siya iyalup sin manga sundalu iyudjuꞌ-udjuꞌ, laung nila, “Mabuhay in Sultan sin manga Yahudi!” Ubus ampa nila siyampak hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Sakali gimuwaꞌ nagbalik hi Pilatu miyadtu pa manga tau mataud natitipun, laung niya ha manga tau, “Kitaa niyu ba, paguwaun ku hi Īsa mari kaniyu ha supaya niyu kaingatan sin wayruun ngīꞌ kiyabaakan ku kaniya amu in mapatut butangan hukuman.” ");
INSERT INTO tsg_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Na, narā na mawn pa guwaꞌ hi Īsa, lāgiꞌ masi siyasangunan in ū niya sin sanga kahuy matunuk, iban nagsusuꞌlug siya sin siub badjuꞌ taluk. Laung hi Pilatu ha manga tau, “Kitaa niyu ba, yari na in tau ini!” ");
INSERT INTO tsg_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pagkitaꞌ sin manga nakuraꞌ kaimaman iban sin manga pulis jaga sin Bāy sin Tuhan kan Īsa, magtūy sila nagꞌulang-ulang, laung nila, “Pataya siya! Palansangan siya pa usuk bat siya mapatay na!” Laung hi Pilatu kanila, “Dāha niyu na siya ampa niyu lansangan pa usuk karnaꞌ wayruun ngīꞌ kiyabaakan ku kaniya amu in mapatut pamatayan ku kaniya.” ");
INSERT INTO tsg_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","In sambung sin manga Yahudi, “Bang ha lawm saraꞌ namuꞌ subay siya patayun sabab naggulal siya sin baran niya Anak Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pagdungug hi Pilatu sin bichara nila, gām mayan na siya miyugaꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Simūd siya nagbalik pa lawm astanaꞌ ampa niya iyasubu hi Īsa, laung niya, “Tau dayn diin kaw?” Sagawaꞌ walaꞌ simambung hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Laung hi Pilatu kaniya, “Maytaꞌ kaw diꞌ sumambung kākuꞌ? Walaꞌ mu ka kiyaingatan sin awn kawasa ku magpaguwaꞌ kaymu? Damikkiyan, awn da isab kawasa ku magpalansang kaymu pa usuk bat kaw matay.” ");
INSERT INTO tsg_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","In sambung hi Īsa, “Bang kaw walaꞌ dīhilan sin Tuhan kawasa, na way sa yan kapatut mu dumihil hukuman kākuꞌ. Hangkan labi dakulaꞌ in dusa sin tau timukbal kākuꞌ mari kaymu dayn sin dusa mu.” ");
INSERT INTO tsg_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pagdungug hi Pilatu sin bichara hi Īsa, limāg siya dān sin hikapuas niya kan Īsa. Sagawaꞌ imulang in manga tau mataud, amu in manga Yahudi, laung nila, “Bang mu siya paguwaun kumangīꞌ na in pagbagay mu iban sin sultan sin hulaꞌ Rūm! Karnaꞌ hisiyu-siyu in naggulal sin baran niya sultan, na in siya yan kimuntara ha sultan sin hulaꞌ Rūm!” ");
INSERT INTO tsg_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Na, pagdungug hi Pilatu sin bichara sin manga tau, diyā niya hi Īsa pa guwaꞌ ampa siya limingkud ha lingkuran sin manghuhukum didtu ha lugal pagtawagun Halaman Batu. (Bang ha bahasa Hibrani in ngān sin lugal yadtu Gabbata.) ");
INSERT INTO tsg_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na, in adlaw yadtu kimugdan ha waktu sin Haylaya Paglappas dayn ha Kamatay, ha adlaw pagngānan Adlaw Pagsakap. Pagga mataas na suga, laung hi Pilatu ha manga tau, “Yari na in sultan niyu!” ");
INSERT INTO tsg_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Sagawaꞌ imulang na isab in manga tau, laung nila, “Papatayan siya! Papatayan siya! Palansangan siya pa usuk!” Laung hi Pilatu kanila, “Mabayaꞌ kamu hipalansang ku pa usuk in sultan niyu?” In sambung sin manga nakuraꞌ kaimaman, “Way sultan namuꞌ dugaing dayn sin sultan sin hulaꞌ Rūm!” ");
INSERT INTO tsg_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Na, pagga biyaꞌ hādtu in bichara sin manga tau, na tiyukbal na hi Pilatu kanila hi Īsa, hipapalansang pa usuk bat matay. Sakali diyā nila na hi Īsa ");
INSERT INTO tsg_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","gimuwaꞌ dayn ha lawm dāira. Hi Īsa in piyapagguyud nila sin usuk pagpatayan kaniya sampay sila nakaabut pa lugal pagngānan kulakub ū. (Bang ha bahasa Hibrani, Gulguta.) ");
INSERT INTO tsg_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Na, pagdatung nila mawn, liyansang na sin manga sundalu hi Īsa pa usuk, ubus ampa nila piyatindug iyusuk pa lupaꞌ. Sakali awn isab duwa tau liyansang pa usuk, ubus ampa iyusuk pa lupaꞌ duun ha kīd pa kīd sin kiyausukan kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Manjari awn sulat pahāti biyutang ha usuk piyaglansangan kan Īsa. In pahāti ini siyulat hi Pilatu, amu agi sin pahāti, “Hi Īsa, tau Nasarit, Sultan sin manga Yahudi.” ");
INSERT INTO tsg_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mataud tau in nakabacha sin pahāti sabab in lugal piyagpatayan kan Īsa bukun malayuꞌ dayn ha dāira. In pahāti yadtu siyulat ha tūngka-ginis bahasa: ha bahasa Hibrani, ha bahasa sin manga tau Rūm, iban ha bahasa Girik. ");
INSERT INTO tsg_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Sakali laung sin manga nakuraꞌ kaimaman kan Pilatu, “In sulat pahāti mu walaꞌ nakaamu sabab biyaꞌ ha ini in siyulat mu, ‘In tau ini amuna in Sultan sin manga Yahudi!’ Subay biyaꞌ ha ini in sulat pahāti mu bat makaamu, laung mu, ‘In tau ini nagꞌiyan sin in siya Sultan sin manga Yahudi!’” ");
INSERT INTO tsg_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","In sambung hi Pilatu kanila, “In bakas ku na kiyasulat diꞌ na kapindahan.” ");
INSERT INTO tsg_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Na, pagga naubus na kiyalansang sin manga sundalu hi Īsa pa usuk, kiyawaꞌ nila in katān siyusuꞌlug hi Īsa ampa nila piyagbahagian nagꞌupat. In hambuuk pa hambuuk sundalu kimāꞌ hangka-bahagiꞌ. Kiyawaꞌ nila da isab in juba hi Īsa amu in hiyahablun way sugpat niya. ");
INSERT INTO tsg_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Laung sin manga sundalu pakaniya-pakaniya, “Subay natuꞌ diꞌ gisiun in juba ini. Sapādpād gisiun gām natuꞌ na piyagkuut-kuutan, ingatun bang hisiyu in makakawaꞌ.” Na, in hīnang sin manga sundalu yan nakarihil kasabunnalan sin asal kiyasulat ha lawm Kitab Jabur, amu agi, “Piyagbahagian nila in siyusuꞌlug ku, iban piyagkuut-kuutan nila in juba ku.” Na, naagad tuud in kiyasulat ha lawm Kitab karnaꞌ biyaꞌ da hādtu in hinang sin manga sundalu. ");
INSERT INTO tsg_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Na, in inaꞌ hi Īsa duun nagtitindug masuuk pa usuk piyaglansangan kan Īsa, iban duun isab in taymanghud babai sin inaꞌ niya iban hi Mariyam amu in asawa hi Kurupas iban hi Mariyam amu in dayn ha dāira Magdala. ");
INSERT INTO tsg_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kītaꞌ hi Īsa nagtitindug duun in inaꞌ niya iban sin mulid kalasahan niya. Hangkan laung hi Īsa ha inaꞌ niya, “Inaꞌ, bihaun in mulid ku yan, anak mu na.” ");
INSERT INTO tsg_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Pagꞌubus laung niya isab ha mulid niya, “Bihaun in inaꞌ ku, inaꞌ mu na.” Na, tagnaan dayn ha waktu yadtu in inaꞌ hi Īsa himulaꞌ na ha lawman sin mulid yan. ");
INSERT INTO tsg_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Manjari kiyaingatan na hi Īsa sin in katān daakan piyahinang kaniya naubus na nahinang. Na, ha supaya maagad in kiyasulat ha lawm Kitab, mīchara hi Īsa, laung niya, “Iyuhaw aku.” ");
INSERT INTO tsg_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Sakali asal awn duun bingkiꞌ hipuꞌ sin tubig anggul (biyaꞌ tubaꞌ). Na, pagꞌiyan hi Īsa iyuhaw siya, kimāꞌ luppus in hambuuk sundalu ampa niya liyuꞌgum pa tubig anggul (biyaꞌ tubaꞌ). Ubus ampa niya biyutang in luppus pa duhul kahuy ampa niya siyungit pa simud hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Na, siyupsup hi Īsa in tubig anggul ampa siya namichara, laung niya, “Naubus na in hinang ku!” Pagꞌubus tiyukkuꞌ niya in ū niya sartaꞌ miyugtuꞌ na in napas niya. ");
INSERT INTO tsg_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Manjari in adlaw yadtu adlaw Jumaat. Na, miyadtu in manga nakuraꞌ Yahudi kan Pilatu nangayuꞌ sin subay baliun in paa sin manga tau, amu in liyansang pa usuk bat matay magtūy, ha supaya hikaīg magtūy in manga mayat dayn ha usuk. Hangkan nangayuꞌ in manga nakuraꞌ sin bihādtu, sabab diꞌ sila mabayaꞌ sin masi duun in manga mayat ha taas usuk bang maabut na adlaw paghali-hali iban pagpudji pa Tuhan. Karnaꞌ in adlaw yan, adlaw mulliya, amu in liyalagguꞌ tuud sin manga bangsa Yahudi. ");
INSERT INTO tsg_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Na, miyadtu na in manga sundalu ampa nila biyaliꞌ in paa sin hambuuk tau amu in iyagad kan Īsa liyansang pa usuk. Damikkiyan da isab in hambuuk. ");
INSERT INTO tsg_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Sakali pagsuuk nila mawn kan Īsa, kītaꞌ nila miyamatay na. Hangkan walaꞌ nila na biyaliꞌ in paa niya. ");
INSERT INTO tsg_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sagawaꞌ biyudjak sin hambuuk sundalu in kīd hi Īsa. Na, saruun-duun gimuwaꞌ in duguꞌ iban tubig. ");
INSERT INTO tsg_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","In nakakitaꞌ ha manga pakaradjaan kimugdan kan Īsa, amuna in nagsulat ha ini ha supaya kamu isab magparachaya. Kapangandulan in saksiꞌ sin tau nagsulat ha ini iban kaingatan niya in kasabunnalan sin baytaꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Na, in hīnang (sin manga sundalu) yan nakarihil kasabunnalan sin asal kiyasulat ha lawm Kitab, amu agi, “Way mabaliꞌ minsan hambuuk bukug niya.” ");
INSERT INTO tsg_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Iban awn pa isab kiyasulat ha lawm Kitab, amu agi, “Aturun nila in tau amu in piyabudjak nila.” ");
INSERT INTO tsg_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Manjari awn hambuuk tau dayn ha kawman Arimati, in ngān niya hi Yusup. Miyadtu siya kan Pilatu namaid bang makajari kawaun in bangkay hi Īsa dayn ha usuk. In hi Yusup ini hambuuk da isab agad kan Īsa, sagawaꞌ walaꞌ siya nagpatampal sabab mabugaꞌ siya ha manga nakuraꞌ Yahudi. Na, tiyugutan mān siya hi Pilatu kumāꞌ sin bangkay, miyadtu na hi Yusup kimāꞌ sin bangkay. ");
INSERT INTO tsg_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Miyagad da isab kan Yusup hi Nikudimus, amu in bakas miyadtu kan Īsa sin dūm dimā nagbichara. Nagdarā siya duwangka-ginis ubat mahamut (hipagꞌadjal sin bangkay hi Īsa). In hinang ubat yan burak amu in pagtawagun “mira” piyapaglamud iban sin kahuy alus. In buꞌgat sin ubat mahamut awn manga kayꞌman kilu. ");
INSERT INTO tsg_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Manjari kiyawaꞌ na sin duwangka-tau ini in bangkay hi Īsa ampa nila siyaput sin kuku putiꞌ marayaw biyubutangan nila sin ubat mahamut, karnaꞌ biyaꞌ hādtu in addat sin manga Yahudi bang magkubul sin mayat nila. ");
INSERT INTO tsg_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na, duun ha lugal masuuk ha piyagpatayan kan Īsa awn hambuuk kabbun. Duun ha kabbun yan awn hambuuk kubul biyaꞌ lupa sungab batu in baꞌgu hīnang amu in walaꞌ pa kiyapangubulan. ");
INSERT INTO tsg_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Na pagga pagkikinsumun na in adlaw Sabtuꞌ iban in kubul yaun masuuk pa lugal piyagpatayan kan Īsa, na duun nila na kiyubul in bangkay hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Manjari pagꞌadlaw Ahad subu-subu pa, miyadtu hi Mariyam amu in babai dayn ha Magdala pa kubul hi Īsa. Pagdatung niya pa kubul, kītaꞌ niya naīg na in batu bakas piyagtambul sin sūran pa lawm kubul. ");
INSERT INTO tsg_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Na, dimagan siya madtu namaytaꞌ kan Simun Pitrus iban pa mulid amu in kalasahan hi Īsa. Laung niya kanila, “Kiyawaꞌ nila in Panghuꞌ dayn ha lawm kubul. Diꞌ natuꞌ na ini kaingatan bang haunu nila siya biyutang!” ");
INSERT INTO tsg_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Na, saruun-duun miyadtu hi Pitrus pa kubul hi Īsa iban sin mulid kalasahan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Dimagan sila karuwa madtu pa kubul saꞌ in hi Pitrus kiyabīn ha ulihan sabab mabiskay dumagan in mulid kalasahan hi Īsa. Hangkan siya in nakauna dimatung pa kubul. ");
INSERT INTO tsg_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pagdatung niya pa kubul, sinīb niya in lawm kubul. Kītaꞌ niya in saput nagbubutang sagawaꞌ walaꞌ siya simūd pa lawm kubul. ");
INSERT INTO tsg_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Sakali pagdatung mawn hi Simun Pitrus, timūy siya simūd pa lawm kubul. Kītaꞌ niya in saput nagbubutang, ");
INSERT INTO tsg_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","iban kītaꞌ niya nalulūn na in kakanaꞌ bakas piyagputus sin ū hi Īsa, lāgiꞌ nakakandi na dayn ha saput. ");
INSERT INTO tsg_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Na, in mulid amu in nakaratung muna pa kubul, simūd da isab pa lawm kubul. Pagkitaꞌ niya sin saput, magtūy siya nagparachaya sin in hi Īsa nabuhiꞌ na nagbalik. ");
INSERT INTO tsg_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Asal awn kiyasulat ha lawm Kitab sin mabuhiꞌ hi Īsa magbalik dayn ha kamatay, sagawaꞌ ha waktu yadtu in yan walaꞌ pa kiyahātihan sin manga mulid hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Sakali in duwa mulid minuwiꞌ na nagbalik. ");
INSERT INTO tsg_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Sakali in hi Mariyam masi duun nagtitindug nagtatangis ha guwaꞌ sin kubul. Ha saꞌbu niya nagtatangis sinīb niya in lawm kubul. ");
INSERT INTO tsg_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Pagsīb niya, kītaꞌ niya in duwa malāikat nagtatamung putiꞌ, limilingkud ha bakas kiyabutangan sin bangkay hi Īsa. In hambuuk ha dapit pa ūhan, ampa in hambuuk ha dapit pa sikān. ");
INSERT INTO tsg_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Laung sin manga malāikat kaniya, “Indaꞌ, unu in piyagtangisan?” In sambung niya, “Inīgan nila in bangkay sin Panghuꞌ ku dayn dī iban diꞌ ku na kaingatan bang haunu nila biyutang!” ");
INSERT INTO tsg_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pagꞌubus yadtu himarap hi Mariyam pa ulihan sartaꞌ kītaꞌ niya hi Īsa nagtitindug duun, sagawaꞌ walaꞌ niya kiyakilāhan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Laung hi Īsa kaniya, “Indaꞌ, maytaꞌ kaw nagtangis? Iban hisiyu in liyawag mu?” Sagawaꞌ in pangannal hi Mariyam tau nagtutungguꞌ sin kabbun pangungubulan in dimā nagbichara kaniya. Hangkan in sambung niya, laung niya, “Tuwan, bang ikaw in kimawaꞌ sin bangkay niya dayn dī, baytai aku bang haunu na, bat kadtuun ku kawaun.” ");
INSERT INTO tsg_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Sakali laung hi Īsa kaniya, “Mariyam.” Saruun-duun iyatud niya hi Īsa sartaꞌ timulik siya, laung niya ha bahasa Hibrani, “Rabbuni.” (Hāti niya, “Guru,”) ");
INSERT INTO tsg_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","“Ayaw mu aku gunggungi,” laung hi Īsa kaniya, “sabab walaꞌ pa aku nakabalik madtu pa Amaꞌ ku. Sagawaꞌ kadtu kaw pa katawtaymanghuran ku ampa mu sila baytai sin magbabalik na aku madtu pa Amaꞌ ku amu in Tuhan ku. Siya da isab in Amaꞌ iban Tuhan niyu.” ");
INSERT INTO tsg_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Na, miyadtu hi Mariyam, amu in babai dayn ha Magdala, namaytaꞌ ha manga mulid hi Īsa sin kītaꞌ niya in Panghuꞌ iban biyaytaan niya sila sin bichara hi Īsa kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sakali narūm mayan sin adlaw Ahad, nagtipun in manga mulid hi Īsa ha hambuuk bāy saꞌ tiyatambul nila in lawang kiyakandaru sabab mabugaꞌ sila ha manga nakuraꞌ Yahudi. Sakali miyadtu hi Īsa nagpanyataꞌ timindug ha giꞌtungan nila, laung niya kanila. “Bang mayan awn kasannyangan ha lawm atay niyu.” ");
INSERT INTO tsg_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pagꞌubus hi Īsa nagbichara piyakitaꞌ niya ha manga mulid niya in duwa lima niya iban sin kīd niya, (amu in tandaꞌ nagpakitaꞌ sin siya na tuud hi Īsa). Na landuꞌ tuud in kakuyagan sin manga mulid pagkitaꞌ nila ha Panghuꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Sakali biyalikan hi Īsa in bichara niya kanila, laung niya, “Bang mayan awn kasannyangan ha lawm atay niyu. Bihaun daakun ta kamu biyaꞌ da isab kākuꞌ naraak sin Amaꞌ ku mari.” ");
INSERT INTO tsg_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Pagꞌubus ampa hi Īsa himanggut sin napas niya pa guwaꞌ piyatudju pa manga mulid niya, sartaꞌ laung niya kanila, “Taymaa niyu in Rū sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Bang niyu maapun in manga tau, tantu ampunun da isab sila sin Tuhan, sagawaꞌ bang niyu sila diꞌ maapun, na tantu diꞌ da isab sila ampunun sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Na, in waktu pagkawn hi Īsa pa manga mulid niya saꞌbu walaꞌ duun hi Tumas, (amu in pagtawagun Kambal.) In hi Tumas ini agad ha hangpuꞌ tagduwa mulid hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Hangkan biyaytaan siya sin kaibanan mulid, laung nila kaniya, “Nakapagkitaꞌ kami iban sin Panghuꞌ!” Laung hi Tumas kanila, “Bang ku diꞌ kakitaan sin duwa mata ku iban kakumpitan in limpaꞌ sin lansang ha duwang sipak lima niya iban masanaw in limpaꞌ sin paliꞌ ha kīd niya, diꞌ aku magparachaya sin baytaꞌ niyu.” ");
INSERT INTO tsg_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Manjari pagga hangka-pitu na nakalabay, nagpūn na isab nagbalik in manga mulid hi Īsa iban nakaagad na hi Tumas kanila. Sakali pagsayu nila, yaun na hi Īsa timitindug ha giꞌtungan nila, malayngkan kiyakandaruhan nila in lawang. Laung hi Īsa kanila, “Bang mayan awn kasannyangan ha lawm atay niyu.” ");
INSERT INTO tsg_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Pagꞌubus laung niya kan Tumas, “Kitaa iban kumpiti in lima ku ha supaya mu kananaman in limpaꞌ sin paliꞌ ku, iban sānawa in kīd ku bat kananaman in limpaꞌ. Ayaw na kaw magduwa-ruwa. Pagparachaya na kaw kākuꞌ!” ");
INSERT INTO tsg_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","In sambung hi Tumas kaniya, “Ya Panghuꞌ ku, ikaw in Tuhan ku!” ");
INSERT INTO tsg_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Laung hi Īsa kaniya, “In ikaw nagparachaya kākuꞌ pasal sin kītaꞌ mu aku nagbaran mari. Dakulaꞌ in karayawan sin manga tau magparachaya kākuꞌ minsan nila aku walaꞌ kītaꞌ!” ");
INSERT INTO tsg_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Na, mataud pa manga muꞌjijat nahinang hi Īsa ha matahan sin manga mulid niya, amu in walaꞌ nakalamud siyulat ha Kitab ini. ");
INSERT INTO tsg_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Sagawaꞌ kiyasulat ha lawm Kitab ini in manga pakaradjaan pasal hi Īsa, ha supaya kamu magparachaya sin in hi Īsa amuna tuud in Almasi, amu in Anak Tuhan, iban ha supaya da isab makabaak kamu kabuhiꞌ salama-lama sabab sin pangandul niyu kaniya. ");
INSERT INTO tsg_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Manjari manga pilay adlaw na limabay miyadtu na isab hi Īsa nagbalik nagpanyataꞌ ha manga mulid niya didtu ha higad sin Dagat Tibiri. Biyaꞌ ha ini in pagpanyataꞌ hi Īsa ha manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ha walaꞌ pa nakapagpanyataꞌ hi Īsa mawn pa manga mulid niya, nagpupūn hinda Pitrus, hi Tumas, amu in pagtawagun Kambal, hi Natanyal, amu in dayn ha Kana ha hulaꞌ Jalil, in duwa anak hi Sibidi iban sin duwa pa mulid hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Laung hi Simun Pitrus ha manga iban niya, “Madtu pa aku manglaya.” Laung sin manga iban niya, “Magad kami kaymu.” (Na, diyayungan nila na in kumpit nila asibiꞌ pa lawd.) Sagawaꞌ dayn ha dūm sampay naabut lapit adlaw wayruun istaꞌ nakawaꞌ nila. ");
INSERT INTO tsg_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Baya-baya mān maadlaw na, didtu hi Īsa timitindug ha higad dagat. Sagawaꞌ walaꞌ siya kiyakilāhan sin manga mulid niya. ");
INSERT INTO tsg_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Sakali tiyawag sila hi Īsa, “Uwaꞌ, manga tuwan, awn da ka nakawaꞌ niyu yan?” Laung nila, “Wayruun.” ");
INSERT INTO tsg_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Laung hi Īsa kanila, “Larukan in laya niyu ha dapit pa tuu sin kumpit niyu bat kamu makakawaꞌ istaꞌ.” Na, liyaruk nila na in laya nila, sakali diꞌ nila na mautung pasal mataud tuud istaꞌ in nakawaꞌ sin laya nila. ");
INSERT INTO tsg_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Manjari mīchara kan Pitrus in mulid kalasahan hi Īsa, laung niya, “Hi Panghuꞌ in tau yaun!” Pagdungug hi Pitrus sin bichara sin mulid yaun, magtūy siya nagꞌūs-ꞌūs nagbadjuꞌ. (Pasal bakas niya inīgan in badjuꞌ niya.) Ubus ampa siya timugpaꞌ pa dagat. ");
INSERT INTO tsg_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Na, in kaibanan mulid nagdayung na pa higad dagat ha saꞌbu nila nagꞌuutung sin laya nila hipuꞌ sin istaꞌ. Bukun sila malayuꞌ dayn ha higad dagat karnaꞌ awn da manga kayꞌman ngarupa in layuꞌ nila. ");
INSERT INTO tsg_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pagdatung nila pa higad dagat, kītaꞌ nila in baga kāyu piyagdarangdangan sin istaꞌ iban awn da isab manga tinapay. ");
INSERT INTO tsg_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Na, laung hi Īsa kanila, “Dā kamu mari sin manga istaꞌ nakawaꞌ niyu.” ");
INSERT INTO tsg_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Sakali simakat magtūy hi Pitrus pa kumpit nila ampa niya hiyubaran in laya. Ubus ampa niya giyuyud in laya pa higad dagat. In laya nila nahipuꞌ sin manga istaꞌ maaslag sadja. In taud sin manga istaꞌ awn hanggatus tagkayꞌman tagtū katān. Sagawaꞌ minsan bihādtu in taud sin istaꞌ walaꞌ minsan nagisiꞌ in laya nila. ");
INSERT INTO tsg_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Laung hi Īsa kanila, “Kari na kamu kaun.” Na, wayruun tuud minsan hambuuk mulid niya in timawakkal nangasubu kaniya bang hisiyu siya sabab asal kiyaingatan nila sin siya na in Panghuꞌ nila. ");
INSERT INTO tsg_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Sakali kiyawaꞌ na madtu hi Īsa in tinapay ampa niya dīhil mawn pa manga mulid niya. Damikkiyan in istaꞌ. ");
INSERT INTO tsg_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Na, amuna ini in hikatū pagpanyataꞌ hi Īsa mawn pa manga mulid niya dayn ha waktu kabuhiꞌ kaniya magbalik dayn ha kamatay. ");
INSERT INTO tsg_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pagꞌubus nila nagkaun, laung hi Īsa kan Pitrus, “Simun, anak hi Yahiya, in lasa mu kākuꞌ lumabi tuud bahaꞌ dayn ha lasa sin manga kaibanan ini kākuꞌ?” In sambung hi Pitrus, “Huun, Panghuꞌ, kaingatan mu sin malasa aku kaymu.” Laung hi Īsa kaniya, “Palihalaa in manga tau sukuꞌ ku biyaꞌ sin pagpalihalaꞌ sin magꞌiipat bili-bili ha manga anak bili-bili niya.” ");
INSERT INTO tsg_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nangasubu na isab nagbing hi Īsa kan Pitrus, “Simun, anak hi Yahiya, malasa ka kaw tuud kākuꞌ?” In sambung hi Pitrus, “Huun, Panghuꞌ, kaingatan mu sin malasa aku kaymu.” Laung hi Īsa kaniya, “Palihalaa in manga tau sukuꞌ ku biyaꞌ sin pagpalihalaꞌ sin magꞌiipat bili-bili ha manga bili-bili niya.” ");
INSERT INTO tsg_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Sakali iyasubu na isab nagbalik hi Īsa hi Pitrus, laung niya, “Simun, anak hi Yahiya, malasa ka kaw tuud kākuꞌ?” Na, nasusa hi Pitrus sabab nakatū na siya iyasubu hi Īsa bang siya malasa tuud kaniya. Na, hangkan laung niya, “Panghuꞌ, kaingatan mu in unu-unu katān. Na, tantu kaingatan mu sin malasa aku kaymu!” Laung hi Īsa kaniya, “Palihalaa in manga tau sukuꞌ ku biyaꞌ sin pagpalihalaꞌ sin magꞌiipat bili-bili ha manga bili-bili niya. ");
INSERT INTO tsg_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Baytaan ta kaw sin kasabunnalan. Sin bataꞌ pa kaw luhaya kaw magbadjuꞌ iban maglunsul pakain-pakain in kabayaan mu. Sagawaꞌ lumaas mayan kaw, sayangun mu in karuwang sipak buktun mu ampa kaw hukutan sin dugaing tau. Ubus ampa kaw dāhun pa lugal diꞌ mu kabayaan kadtuun.” ");
INSERT INTO tsg_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Hangkan hi Īsa namichara bihādtu sabab hipaingat niya bang biyaꞌ diin in kamatay hi Pitrus. Lāgiꞌ in kamatay niya makarihil da isab kalagguan ha Tuhan. Na, laung hi Īsa kan Pitrus, “Agad na kaw kākuꞌ!” ");
INSERT INTO tsg_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Manjari pagharap hi Pitrus pa ulihan, kītaꞌ niya in mulid amu in kalasahan hi Īsa. In mulid ini amuna in simuuk tuud kan Īsa ha waktu saꞌbu nila nagjamu ampa nangasubu kan Īsa, laung niya, “Panghuꞌ hisiyu in manipu kaymu?” ");
INSERT INTO tsg_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pagkitaꞌ hi Pitrus ha mulid ini, iyasubu niya hi Īsa, laung niya, “Panghuꞌ, na biyaꞌ diin in siya yaun?” ");
INSERT INTO tsg_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","In sambung hi Īsa kaniya, “Maytaꞌ, unu in kibil mu bang in kabayaan ku buhiꞌ siya sampay aku magbalik mari pa dunya? In pasal ha yan wayruun lamud mu. Agad na kaw kākuꞌ!” ");
INSERT INTO tsg_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Na, dayn didtu naglatag in suysuy pa manga tau agad kan Īsa sin in mulid amu in kalasahan niya diꞌ mapatay. Sagawaꞌ walaꞌ imiyan hi Īsa sin diꞌ matay in mulid yaun. In agi niya biyaꞌ ha ini, laung niya, “Maytaꞌ, unu in kibil mu bang in kabayaan ku buhiꞌ siya sampay aku magbalik mari pa dunya?” ");
INSERT INTO tsg_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","In mulid piyagꞌiyan hi Īsa, amuna in namaytaꞌ iban simulat sin katān pakaradjaan ini pasal hi Īsa. Lāgiꞌ kaingatan sin kitaniyu katān sin bunnal in baytaꞌ sin mulid yan. ");
INSERT INTO tsg_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Mataud pa tuud in manga nahinang hi Īsa, sumagawaꞌ bang hisulat in katān nahinang niya ha manga Kitab, na marayꞌ diꞌ maluun dī ha dunya ini in taud sin manga Kitab pasal niya. Wassalam!");
INSERT INTO tsg_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Alamat ini sulat naug dayn kan Lukas mari kan Tiyupilas. Kaingatan mu ha tagnaꞌ sulat ku kaymu biyaytaꞌ ku in manga pakaradjaan nahinang hi Īsa iban sin manga hinduꞌ niya dayn ha waktu tiyagnaan niya in hinang niya ");
INSERT INTO tsg_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","sampay pa waktu amu in kaangkat kaniya pa taas langit. Ha walaꞌ pa siya naangkat pa taas langit, awn daakan binīn hi Īsa ha manga tau napīꞌ niya wakil niya. In daakan ini naug dayn ha kawasa sin Rū sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","In hi Īsa nakamataud nagpanyataꞌ ha manga kiyawakilan niya ha supaya sila magparachaya tuud sin in siya buhiꞌ. In lugay sin waktu pagpanyataꞌ niya kanila naabut sampay pa kaꞌpatan adlaw dayn ha kamatay kaniya. Ha manga waktu sin pagpanyataꞌ niya yan, nagbichara hi Īsa iban sin manga kiyawakilan niya pasal sin pamarinta sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ha hambuuk waktu, ha saꞌbu hi Īsa duun ha manga kiyawakilan niya, biyaytaan niya sin subay sila diꞌ mīg dayn ha Awrusalam (Baytal Makdis), iban laung niya kanila, “Tagari niyu in kiyajanjiꞌ sin Amaꞌ ku kaniyu. ");
INSERT INTO tsg_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","In hi Yahiya, tubig in piyangliguꞌ niya ha manga tau, sagawaꞌ bukun na malugay in kamu yan hūpun na sin Rū sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Manjari awn hambuuk waktu duun hi Īsa nagtitipun iban sin manga mulid niya. Sakali iyasubu siya sin manga mulid niya, laung nila, “Panghuꞌ, hirihil mu na ka bihaun in kawasa ha bangsa ta Israil mamarinta magbīng?” ");
INSERT INTO tsg_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Laung hi Īsa kanila, “Amaꞌ ku in magbayaꞌ maggantaꞌ bang biyaꞌ diin in lugay iban unu in waktu maawn in piyangasubu niyu yan. Bukun wajib hipaingat kaniyu bang kuꞌnu tuud maawn in pasal yan. ");
INSERT INTO tsg_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Sagawaꞌ bang kamu hūpun na sin Rū sin Tuhan, dayn ha tulung-tabang niya, awn na kawasa niyu. Kamu in mamaytaꞌ sin katān kahālan pasal ku pa manga tau ha dāira Awrusalam (Baytal Makdis), ha katilingkal sin hulaꞌ Yahudiya iban Samariya sampay pa upat pidju ālam sin dunya.” ");
INSERT INTO tsg_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pagꞌubus na mayan hi Īsa namichara, magtūy siya naangkat pa taas langit. Duun in manga kiyawakilan niya nagꞌaatud kaniya sampay siya kiyalibunan na sin gabun. ");
INSERT INTO tsg_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Na, masi sila naghahangad pa taas langit dayn ha waktu kaangkat kan Īsa pa taas langit. Sakali saruun-duun awn duwa tau nagtatamung putiꞌ in timindug ha daig nila. ");
INSERT INTO tsg_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Amu agi kanila, “In kamu manga tau Jalil, maytaꞌ kamu yan timitindug himahangad pa taas langit? In hi Īsa amu in naangkat pa taas langit hayn-duun nabutas dayn kaniyu, ha susūngun magbalik na mari kaniyu. In kaagi sin pagbalik niya mari biyaꞌ da isab sin kaangkat kaniya pa taas langit.” ");
INSERT INTO tsg_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Manjari nagbalik na in manga kiyawakilan hi Īsa pa Awrusalam (Baytal Makdis) dayn ha Būd Jaytun. In layuꞌ sin Būd Jaytun pa Awrusalam (Baytal Makdis) awn manga hambuuk batu. ");
INSERT INTO tsg_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pagdatung nila pa Awrusalam (Baytal Makdis), gimaban sila pa taas bāy, ampa sila simūd pa bilik diridtuan nila. In sila ini amuna hinda Pitrus, hi Yahiya, hi Yaꞌkub, hi Andariyas, hi Pilip iban hi Tumas, hi Bartulumi iban hi Matiyu, hi Yaꞌkub, amu in anak hi Alpa, hi Simun amu in bantug simulang ha pamarinta sin hulaꞌ Rūm, iban hi Judas amu in anak hi Yaꞌkub. ");
INSERT INTO tsg_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","In sila ini katān daran nagtitipun mangarap pa Tuhan iban sin manga kababaihan iban da isab hi Mariyam, inaꞌ hi Īsa iban sin manga taymanghud usug hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pagꞌubus yadtu hambuuk adlaw nagpūn in manga tau nagpaparachaya kan Īsa. In taud nila awn manga hanggatus kawhaan. Sakali timindug hi Pitrus namichara. ");
INSERT INTO tsg_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Laung niya, “Manga katawtaymanghuran ku, diꞌ manjari bang diꞌ maagad in kiyasulat ha lawm Kitab pasal sin baytaꞌ sin Rū sin Tuhan pasal hi Judas amu in nagmalim ha manga tau nanaggaw kan Īsa. In baytaꞌ yan gimuwaꞌ dayn ha simud hi Daud. ");
INSERT INTO tsg_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","In hi Judas bakas hambuuk iban namuꞌ. Hangka-agaran kami iban siya sabab in siya napīꞌ isab lumamud ha hinang kiyasukuꞌ kāmuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(In sīn bakas piyanangdan kan Judas sin hinang niya mangīꞌ, amuna in sīn piyamī lupaꞌ. (Duun ha lupaꞌ yan naggantung hi Judas sin baran niya.) Duun siya nahulug sartaꞌ nabustak in tiyan niya iban gimuwaꞌ in lungun-lungun niya. ");
INSERT INTO tsg_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Na, kiyaingatan sin manga tau katān naghuhulaꞌ ha Awrusalam (Baytal Makdis) in pasal yan. Hangkan ngiyānan nila in lupaꞌ yan, Akildama. In hāti niya bang ha bahasa nila, “Lupaꞌ Binī sin Duguꞌ.”) ");
INSERT INTO tsg_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Na,” laung hi Pitrus, “biyaꞌ ha ini in kiyasulat ha lawm Kitab Jabur, amu agi, ‘Bang mān magꞌīgan in manga tau dayn ha paghulaꞌ niya iban wayruun na tau maghulaꞌ duun!’ Lāgiꞌ kiyasulat da isab ha lawm Kitab, amu agi, ‘Bang mān awn tau makagantiꞌ sin hinang niya!’ ");
INSERT INTO tsg_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Na, hangkan dayn ha sabab yan subay awn tau gumantiꞌ kan Judas magad kāmuꞌ mamaytaꞌ pa manga tau pasal sin nabuhiꞌ hi Panghuꞌ Īsa nagbalik dayn ha kamatay. In tau gumantiꞌ ini subay asal miyamagad ha biyaꞌ kāmuꞌ, amu in bakas nagꞌaagad pakain-pakain iban hi Panghuꞌ Īsa tagnaan dayn ha waktu kaliguꞌ hi Yahiya kan Panghuꞌ Īsa sampay pa waktu kaangkat kaniya pa taas langit.” ");
INSERT INTO tsg_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Na, sakali awn duwa tau piyagpīan nila: hi Yusup amu in pagtawagun Barsabbas (iban pagtawagun da isab siya Justus) iban hi Mattiyas. ");
INSERT INTO tsg_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Na, nangayuꞌ duwaa pa Tuhan hinda Pitrus, laung nila, “Ya Panghuꞌ, ikaw da in makaingat sin lawm pikilan sin manga mānusiyaꞌ katān. Hangkan pangayuun namuꞌ kaymu, baytai kami bang hisiyu ha duwa tau ini in pīun namuꞌ ");
INSERT INTO tsg_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","mahinang wakil mu gumantiꞌ kan Judas, amu in yadtu na nanaykud pa hulaꞌ kiyasukuꞌ kaniya.” ");
INSERT INTO tsg_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Na, pagꞌubus nila nangayuꞌ duwaa, siyulat nila na in ngān sin duwangka-tau ampa nila piyagkuut-kuutan. Na, in ngān nakuut nila, ngān hi Mattiyas. Hangkan hi Mattiyas in nakaganap ha hangpuꞌ tagꞌisa tau kiyawakilan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Manjari naabut na in pagjamu pagtawagun Kayꞌman, in manga tau nagpaparachaya kan Īsa nagtipun ha hambuuk lugal. ");
INSERT INTO tsg_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sakali magtūy awn limagunus dayn ha taas langit saliꞌ hangin makusug. Nalatag sin lagunus in lawm bāy piyagtitipunan nila. ");
INSERT INTO tsg_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Sartaꞌ awn kītaꞌ nila simiꞌnag biyaꞌ kāyu iban biyaꞌ purma dilaꞌ in dagbus niya. Nagkanat in biyaꞌ lupa kāyu ini ampa miyutang pa babaw ū sin tau katān natitipun duun. ");
INSERT INTO tsg_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Na, magtūy na sila hiyūp sin Rū sin Tuhan sartaꞌ timagnaꞌ na sila namichara sin manga bahasa diꞌ nila kaingatan. Nahinang nila in biyaꞌ ha yan dayn ha kusug sin kawasa sin Rū sin Tuhan amu in timatabang kanila. ");
INSERT INTO tsg_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na, awn manga Yahudi dayn ha manga kahulaꞌ-hulaan in himahantiꞌ duun ha Awrusalam (Baytal Makdis). In sila ini manga tau nagtataat tuud pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pagdungug sin manga tau ini sin suysuy pasal sin lagunus, nagtūy sila limuruk madtu. Mabanus tau in limuruk madtu. Pagdatung nila madtu, kiyublaan tuud sila, sabab in manga tau amu in hiyūp sin Rū sin Tuhan namichara sin bahasa sin pakaniya-pakaniya sin sila amu in limuruk mawn. ");
INSERT INTO tsg_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Na, landuꞌ tuud sila nainu-inu iban nahaylan sin diyungug nila. Laung nila, “Ay kaw naa, in manga tau nagbibichara ini, manga tau dayn ha Jalil! ");
INSERT INTO tsg_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Na, maytaꞌ kitaniyu pakaniya-pakaniya nakahāti sin bichara nila? ");
INSERT INTO tsg_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","In kitaniyu ini katān nakaluruk mari dayn ha dugaing-dugaing hulaꞌ biyaꞌ na sin hulaꞌ Partiya, Midda, Ilam, Misuputami, Yahudiya, Kappaduki, Puntus iban dayn ha Asiya. ");
INSERT INTO tsg_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","In kaibanan kātuꞌniyu dayn ha hulaꞌ Piriji, Pampilya, Misir, dayn ha manga dugaing-dugaing lugal ha hulaꞌ Libiya amu in masuuk pa hulaꞌ Kirini. In kaibanan kātuꞌniyu dayn ha dāira Rūm ");
INSERT INTO tsg_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","amu in naglalamud in manga Yahudi iban bukun, sagawaꞌ saliꞌ-saliꞌ namamawgbug sin agama Yahudi. Hāti in kaibanan kātuꞌniyu dayn ha hulaꞌ Kiriti iban hulaꞌ Arab. Sagawaꞌ minsan kitaniyu dayn ha dugaing-dugaing hulaꞌ kiyahātihan natuꞌ in bichara nila pasal sin manga hinang landuꞌ makainu-inu nahinang sin Tuhan, sabab nagbichara sila ha manga bahasa sin kitaniyu pakaniya-pakaniya!” ");
INSERT INTO tsg_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Na kiyublaan tuud sila iban nahilu in pikilan sin sila amu in limuruk mawn. Nagꞌasubu-iyasubuhi na sila, laung nila, “Unu bahaꞌ in hāti ha yan?” ");
INSERT INTO tsg_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Sagawaꞌ in kaibanan nangudjuꞌ-ngudjuꞌ ha manga tau nagpaparachaya kan Īsa. Laung nila, “In manga tau yan maghihilu!” ");
INSERT INTO tsg_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Sakali timindug hi Pitrus iban sin manga hangpuꞌ tagꞌisa kiyawakilan hi Īsa. Namichara matanug hi Pitrus pa manga tau mataud, laung niya, “Manga pagkahi ku Yahudi iban sin manga kamu naghuhulaꞌ dī ha Awrusalam (Baytal Makdis), dunguga niyu in bichara ku ini. Pahātihun ta kamu sin pakaradjaan ini. ");
INSERT INTO tsg_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","In manga tau ini bukun hilu biyaꞌ sin agi niyu, sabab wayruun tau in maghilu sin iyampa lisag siyam sin mahinaat. ");
INSERT INTO tsg_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","In pakaradjaan ini naawn karnaꞌ asal yan kiyabaytaꞌ ha lawm Kitab kaagi hi Nabi Juwil, amu agi, ");
INSERT INTO tsg_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Biyaꞌ ha ini in Parman sin Tuhan, amu agi, Ha katapusan sin masa biyaꞌ ha ini in hinangun ku. Pahūpun ku in Rū ku pa mānusiyaꞌ katān. Ha susūngun hipamahalayak sin manga kaanakan niyu usug-babai in Parman ku, hāti in manga usug bataꞌ-baꞌgu makakitaꞌ sin manga unu-unu walaꞌ piyanyataꞌ pa kaibanan mānusiyaꞌ, iban in manga usug tau maas managainup sin kabayaan ku hipaingat kanila. ");
INSERT INTO tsg_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Na, mattan tuud, in manga īpun ku sibuꞌ da usug-babai patulunan ku sin Rū ku, hāti in sila isab hipamahalayak nila in Parman ku. ");
INSERT INTO tsg_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Hinangun ku in manga mahal-mahal tandaꞌ sin kasabunnalan iban makainu-inu, amu in hipanyataꞌ ku ha taas langit iban ha babaw dunya. Kakitaan niyu in duguꞌ, kāyu, iban asu marakmul. ");
INSERT INTO tsg_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lāgiꞌ manigidlum na in suga iban mula na biyaꞌ duguꞌ in bulan. Na, pagꞌubus yan magbaran na dumatung in Panghuꞌ niyu, iban landuꞌ in kalagguan sin waktu yan, (karnaꞌ amu yan in waktu manghukum na in Tuhan ha mānusiyaꞌ). ");
INSERT INTO tsg_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Na, ha waktu yan hisiyu-siyu in tumawag mangayuꞌ tabang ha Panghuꞌ malappas siya, diꞌ kabutangan sin hukuman!’ ");
INSERT INTO tsg_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Manga pagkahi ku tau Israil,” laung hi Pitrus, “dunguga niyu in bichara ku pasal hi Īsa, amu in tau dayn ha Nasarit. In siya mattan tuud in kawasa niya dayn ha Tuhan, karnaꞌ in katān muꞌjijat tandaꞌ sin kasabunnalan iban katān hinang makainu-inu nahinang niya. In manga yan piyahinang sin Tuhan kaniya. Na, kaingatan niyu da isab in pasal yan sabab in manga hinang yan kītaꞌ niyu naawn dī kaniyu. ");
INSERT INTO tsg_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Asal kiyaingatan sin Tuhan in hi Īsa hiungsud pa lawm lima niyu, sabab amu yan in asal maksud kiyagantaꞌ niya kan Īsa. Pagꞌubus ampa niyu siya piyapatay piyalansang pa usuk ha manga tau isinarkaꞌ. ");
INSERT INTO tsg_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sagawaꞌ biyuhiꞌ siya nagbalik sin Tuhan, piyuas dayn ha kabinsanaan sin kamatay. Sabab in hi Īsa asal tantu tuud diꞌ lumugay ha lawm kamatay. ");
INSERT INTO tsg_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Karnaꞌ kiyabaytaꞌ hi Daud ha lawm Kitab Jabur in pamung hi Īsa, amu agi, ‘Kaingatan ku in Panghuꞌ yari masuuk kākuꞌ ha unu-unu waktu; yari siya ha daig ku, hangkan diꞌ aku masasat. ");
INSERT INTO tsg_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Na, hangkan landuꞌ tuud makuyag in lawm atay ku, iban lunlun kakuyagan in manga lapal-kabtangan ku. Lāgiꞌ minsan mapatay in anggawtaꞌ-baran ku, awn da karayawan hiyuhuwat-huwat ku ha susūngun. ");
INSERT INTO tsg_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Sabab kaingatan ku diꞌ mu aku pasāran didtu ha hulaan sin manga patay, iban diꞌ mu pasāran humaluꞌ ha lawm kubul in aku, amu in daraakun mu suchi. ");
INSERT INTO tsg_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Hīnduan mu na aku sin dān pa kabuhiꞌ, amu in makarihil kākuꞌ kakuyagan dakulaꞌ bang kita makapagkitaꞌ na.’ ");
INSERT INTO tsg_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Manga taymanghud ku,” laung hi Pitrus, “baytaan ta kamu sin tuman pasal hi Sultan Daud, amu in tau bantug nanubuꞌ kātuꞌniyu. Miyatay siya iban dī siya kiyubul. Sampay pa bihaun yari dī in kubul niya. ");
INSERT INTO tsg_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","In siya hambuuk nabi iban kiyaingatan niya in janjiꞌ sin Tuhan kaniya. Jimanjiꞌ in Tuhan mahugut sin awn hambuuk panubuꞌ hi Daud in palingkurun niya magsultan biyaꞌ da isab kan Daud. ");
INSERT INTO tsg_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Asal kiyaingatan hi Daud bang unu in hinangun sin Tuhan ha susūngun. Hangkan nakapamung siya ha pasal sin kabuhiꞌ magbalik sin Almasi, laung niya, ‘Walaꞌ siya piyasāran didtu ha hulaan sin manga patay, walaꞌ nahaluꞌ in baran niya ha lawm kubul.’ ");
INSERT INTO tsg_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Na, in hi Īsa biyuhiꞌ sin Tuhan nagbalik dayn ha kamatay. In yan mattan bunnal tuud sabab kiyasaksian sin kami katān. ");
INSERT INTO tsg_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Iyangkat siya sin Tuhan pa salagguꞌ-lagguꞌ kalagguan iban natabuk niya in kiyajanjiꞌ kaniya sin Tuhan, Amaꞌ niya, amu in Rū sin Tuhan. Hangkan in kītaꞌ niyu iban diyungug niyu hayn-duun amuna in hinang sin Rū sin Tuhan piyatulun mari hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Na, ingat kamu, bukun hi Daud in naangkat pa surgaꞌ, sabab nakapamung hi Daud, laung niya: ‘Namung in Tuhan ha Panghuꞌ ku: “Lingkud kaw dī ha dapit pa tuu ku ");
INSERT INTO tsg_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","sampay ku mapabutang ha babaan mu in katān simusulang kaymu mahinang biyaꞌ sapantun pagtitinggilan sin siki mu.”’” ");
INSERT INTO tsg_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Na, hangkan,” laung hi Pitrus, “in katān tau Israil subay tuud makahāti marayaw sin in hi Īsa amu in piyapatay niyu piyalansang pa usuk, siya in giyulal sin Tuhan, Panghuꞌ iban Almasi!” ");
INSERT INTO tsg_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pagdungug sin manga tau sin bichara hi Pitrus, biyaꞌ sin natagbak in lawm atay nila. Nasusa iban miyugaꞌ sila. Laung nila kan Pitrus iban sin manga kaibanan kiyawakilan hi Īsa, “Na, manga taymanghud, unu in hinangun namuꞌ?” ");
INSERT INTO tsg_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Laung hi Pitrus kanila, “Subay niyu pagtawbatan in manga dusa niyu iban pagpaliguꞌ kamu ha ngān hi Īsa, amu in Almasi, ha supaya maampun in manga dusa niyu iban kapatulunan kamu sin Rū sin Tuhan, amu in hirihil sin Tuhan kaniyu. ");
INSERT INTO tsg_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Sabab in yan asal janjiꞌ sin Tuhan kaniyu iban ha manga kaanakan niyu. Lāgiꞌ in janjiꞌ yan kiyasukuꞌ da isab ha manga tau katān yadtu ha manga hulaꞌ malayuꞌ, amu in kabayaan sin Panghuꞌ Tuhan natuꞌ paagarun kaniya.” ");
INSERT INTO tsg_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Mahabaꞌ in himumūngan hi Pitrus kanila iban nangayuꞌ tuud siya junjung kanila, laung niya, “Ayaw kamu magad ha hinang iban pikilan sin manga tau mangīꞌ bat kamu malappas dayn ha murkaꞌ dumatung ha susūngun pa bangsa mangīꞌ yan!” ");
INSERT INTO tsg_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Na, mataud in nagparachaya sin baytaꞌ hi Pitrus iban nagpaliguꞌ na sila. Ha adlaw yadtu awn manga tū ngaibu tau in nakaganap ha manga tau agad kan Īsa. ");
INSERT INTO tsg_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Na, in manga tau ini, amuna in hiyarap nila piyagtuyuan in umingat sin hinduꞌ sin manga kiyawakilan hi Īsa. Limamud na sila naghangka-atay ha manga tau agad kan Īsa iban nagsāw-sāw na sila nagkaun gantiꞌ panumtuman nila sin kamatay hi Īsa, iban limamud na sila nangarap pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Manjari in manga tau katān siyūd bugaꞌ, sabab mataud mahal-mahal tandaꞌ sin kasabunnalan iban makainu-inu in nahinang sin manga kiyawakilan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","In manga katān nagpaparachaya kan Īsa masi-masi in pagtipun-tipun nila iban in unu-unu nila katān piyagsasāw-sāwhan nila. ");
INSERT INTO tsg_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Piyagdagang nila in manga altaꞌ iban kaginisan nila. Ubus ampa nila piyagbahagiꞌ-bahagian in sīn bīhan, pila-pila na in tungud kagunahan sin pakaniya-pakaniya. ");
INSERT INTO tsg_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Adlaw-adlaw nagtitipun sila ha Bāy sin Tuhan iban nagsāw-sāw sila nagkaun ha manga kabāyan nila. Makuyag sila iban tulus-ihilas in bayaꞌ nila magsāw-sāw magkaun. ");
INSERT INTO tsg_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Liyalagguꞌ nila in Tuhan iban kiyukūgan sila sin dayaw sin manga tau katān kanila. Adlaw-adlaw ganapan sin Panghuꞌ in taud sin sila agad ha Almasi, amu in nalappas na. ");
INSERT INTO tsg_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Manjari hambuuk adlaw hi Pitrus kay Yahiya miyadtu pa Bāy sin Tuhan. Miyadtu sila sin lisag tū sin mahapun amu in waktu pagpangarap pa Tuhan. ");
INSERT INTO tsg_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Sakali duun ha higad lawang amu in pagtawagun, “Lawang Malingkat,” awn tau duun naghihilunu kariasali in siki niya. Adlaw-adlaw dāhun siya sin manga tau mawn pa lawang yaun ha supaya siya makapangayuꞌ sarakka ha manga tau magsusūd pa halaman sin Bāy sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Na, pagkitaꞌ sin tau ini kan Pitrus iban hi Yahiya sūng na sumūd pa lawm Bāy sin Tuhan, nangayuꞌ siya sarakka kanila. ");
INSERT INTO tsg_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Sakali iyatud nila siya, ampa laung hi Pitrus kaniya, “Atud kaw mari kāmuꞌ!” ");
INSERT INTO tsg_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Na, imatud siya kanila. In pangannal niya, dihilan siya sīn. ");
INSERT INTO tsg_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Sagawaꞌ laung hi Pitrus kaniya, “Wayruun tuud sīn ku, saꞌ awn kākuꞌ hirihil ku kaymu. Ha ngān hi Īsa Almasi dayn ha Nasarit, tindug kaw ampa kaw panaw!” ");
INSERT INTO tsg_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Sartaꞌ kiyumpitan siya hi Pitrus ha lima dapit pa tuu, tiyabangan piyatindug. Na, saruun-duun kimusug na in siki iban sin buku-buku siki niya. ");
INSERT INTO tsg_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Limumpat siya ampa timindug, ubus ampa siya miyanaw. Miyagad siya simūd kanda Pitrus pa halaman sin Bāy sin Tuhan. Miyamanaw siya iban naglulumpat sartaꞌ nagbabantug ha Tuhan. ");
INSERT INTO tsg_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kītaꞌ siya sin manga tau katān nagpapanaw iban nagbabantug ha Tuhan. ");
INSERT INTO tsg_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Sakali kiyakilāhan nila na sin siya na in tau naglilingkud nangangayuꞌ sarakka duun ha lawang pagtawagun Lawang Malingkat. Kiyublaan tuud sila katān iban nainu-inu sila pasalan sin nahinang ha tau yan. ");
INSERT INTO tsg_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Manjari ha saꞌbu siya gimugunggung kan Pitrus iban hi Yahiya duun ha salas pagtawagun “Salas hi Sultan Sulayman,” dimagan mawn kanila in manga tau sabab landuꞌ tuud sila nainu-inu. ");
INSERT INTO tsg_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pagkitaꞌ hi Pitrus ha manga tau, laung niya kanila, “Manga pagkahi ku tau Israil, maytaꞌ kamu mainu-inu ha ini? Iban maytaꞌ kami piyapandang niyu? Maytaꞌ, in pangannal niyu, dayn ha kusug namuꞌ hangkan nakapanaw in tau ini atawa dayn ha pasal balꞌibārat kami? Tantu bukun! ");
INSERT INTO tsg_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Sabab awn kalagguan dakulaꞌ dīhil sin hambuuk-buuk Tuhan sin manga kamaasan natuꞌ, amu isab in Tuhan hinda Ibrahim, Isahak iban Yaꞌkub pa hambuuk daraakun niya hi Īsa. Na, in hi Īsa ini amuna in iyungsud niyu pa lawm lima sin manga tau nagkakaput saraꞌ, iban siyulak niyu siya ha alupan hi Pilatu, minsan da in kabayaan hi Pilatu puasun niya hi Īsa dayn ha tuntut kaniya. ");
INSERT INTO tsg_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","In hi Īsa hambuuk tau suchi iban tau marayaw, sagawaꞌ siyulak niyu siya. Lāgiꞌ minsan siya kabayaan puasun hi Pilatu, gām mayan amu in tau māmunuꞌ in piyangayuꞌ niyu kan Pilatu piyaguwaꞌ dayn ha lawm jīl. ");
INSERT INTO tsg_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Piyatay niyu in puunan sin kabuhiꞌ, sagawaꞌ biyuhiꞌ siya nagbalik sin Tuhan dayn ha kamatay. Ampa in pasal yan kiyasaksian namuꞌ. ");
INSERT INTO tsg_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","In kusug sin kawasa sin ngān hi Īsa amu in nakarihil kusug ha tau ini amu in bakas naghihilunu in siki. In hinang kītaꞌ iban kiyasakupan niyu hayn-duun, naawn sabab sin pangandul namuꞌ ha ngān hi Īsa. Dayn ha pasal sin pangandul namuꞌ kan Īsa kiyaulian in tau ini biyaꞌ na sin kiyakitaan sin kamu katān. ");
INSERT INTO tsg_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Na, bihaun manga taymanghud ku, kaingatan ku in kamu iban sin manga nakuraꞌ niyu awam pasal hi Īsa. Hangkan biyaꞌ hādtu in hīnang niyu kaniya. ");
INSERT INTO tsg_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Na, asal piyamahalayak sin manga katān kanabihan sin timpu nakauna sin subay lumabay kabinsanaan in Almasi. In baytaꞌ yan naug dayn ha Tuhan iban naagad tuud isab in baytaꞌ niya yan. ");
INSERT INTO tsg_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Na, bihaun manga taymanghud ku, pagtawbati niyu na in manga dusa niyu iban harapa niyu na in Tuhan ha supaya niya ampunun in manga dusa niyu. Bang niyu yan hinangun, ");
INSERT INTO tsg_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","paratungan kamu sin Tuhan kahayangan iban pakawnun niya kaniyu hi Īsa Almasi, amu in asal giyantaꞌ sin Tuhan magbayaꞌ kaniyu. ");
INSERT INTO tsg_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Sagawaꞌ bihaun subay dimidtu naa hi Īsa Almasi ha surgaꞌ sampay dumatung in waktu baꞌguhun na sin Tuhan in unu-unu katān. In pasal yan asal piyamahalayak ha timpu nakauna pa, kaagi sin manga kanabihan amu in piyanaugan sin Tuhan sin baytaꞌ yan. ");
INSERT INTO tsg_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Karnaꞌ bakas nakapamung hi Musa, laung niya, “‘Palahilun mari kaniyu sin Tuhan, Panghuꞌ niyu, in hambuuk nabi. Palahilun siya mari pa dunya biyaꞌ da isab kākuꞌ. In siya yan pagkahi niyu hangka-bangsa. Subay niyu kahagarun in unu-unu baytaꞌ niya kaniyu. ");
INSERT INTO tsg_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Hisiyu-siyu in diꞌ magkahagad sin daakan sin nabi yan, kandihun siya dayn ha manga tau sukuꞌ sin Tuhan iban tantu magmula tuud siya.’ ");
INSERT INTO tsg_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Na, biyaꞌ da isab ha yan in baytaꞌ sin manga nabi katān, dayn kan Samwil sampay pa manga nabi simunud kaniya. Nagtaayun katān in baytaꞌ nila. Asal nila kiyabaytaꞌ in manga pakaradjaan amu in naawn ha masa ini. ");
INSERT INTO tsg_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kiyasukuꞌ kaniyu in manga janjiꞌ sin Tuhan piyanaug niya dayn ha manga nabi. Awn sukuꞌ niyu ha paljanjian sin Tuhan iban sin manga kamaasan niyu. Karnaꞌ jimanjiꞌ in Tuhan kan Ibrahim, amu agi, ‘Makabaak karayawan in katān mānusiyaꞌ ha dunya dayn ha sabab sin hambuuk panubuꞌ mu.’ Amu yan in janjiꞌ sin Tuhan kan Ibrahim. ");
INSERT INTO tsg_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Na, hangkan piyakawn sin Tuhan muna kaniyu in daraakun kiyawakilan niya hi Īsa, amu in dumā kaniyu simihaꞌ dayn ha manga hinang niyu mangīꞌ, ha supaya kamu makabaak karayawan.” ");
INSERT INTO tsg_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Manjari ha saꞌbu nagbibichara pa hi Pitrus kay Yahiya ha manga tau, nākawn in manga kaimaman, in hambuuk kapitan sin manga jaga ha Bāy sin Tuhan iban sin manga tau pagtawagun Sadduki. ");
INSERT INTO tsg_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Diyugalan sila kan Pitrus iban hi Yahiya sabab in duwa ini namaytaꞌ ha manga tau sin hi Īsa nabuhiꞌ nagbalik dayn ha kamatay, amu in tandaꞌ sin in manga patay tantu tuud mabuhiꞌ magbalik dayn ha kamatay. ");
INSERT INTO tsg_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Na, siyaggaw nila hi Pitrus kay Yahiya ampa nila liyuun pa lawm jīl. Dūm na in karā kanila pa lawm jīl, hangkan duun sila ha jīl sampay naadlaw na. ");
INSERT INTO tsg_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Sagawaꞌ minsan biyaꞌ hādtu, mataud tau amu in nakarungug sin baytaꞌ hinda Pitrus in nagparachaya. Simūng in taud sin manga tau nagparachaya kan Īsa, naabut na manga lima ngaibu kausugan. ");
INSERT INTO tsg_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Sakali naadlaw mayan nagtipun duun ha Awrusalam (Baytal Makdis) in manga nakuraꞌ Yahudi, in manga nagtatau-maas ha hulaꞌ iban sin manga guru sin saraꞌ agama. ");
INSERT INTO tsg_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nagtipun sila iban hinda Annas amu in Imam Dakulaꞌ, hi Kayapas, hi Yahiya, hi Iskandal iban sin kaibanan lahasiyaꞌ sin Imam Dakulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Na, piyakawaꞌ nila hi Pitrus kay Yahiya ampa nila siyumariya. Laung nila, “Dayn diin in kawasa niyu himinang sin hinang niyu yan? Ngāni bang hisiyu in nagdaak kaniyu!” ");
INSERT INTO tsg_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Na, simambung hi Pitrus sartaꞌ hiyūp siya sin Rū sin Tuhan, laung niya, “Manga nakuraꞌ sin agama natuꞌ iban manga nagtatau-maas ha hulaꞌ, ");
INSERT INTO tsg_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","bang niyu kami sumariyahun pasal sin hinang marayaw nahinang namuꞌ ha tau bakas naghihilunu in siki niya iban bang biyaꞌ diin in kauliꞌ kaniya, ");
INSERT INTO tsg_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","na, subay tuud kaingatan sin kamu katān iban sin katān tau Israil, sin in tau ini, amu in timitindug ha alupan niyu bihaun, kiyaulian tuud in sakit niya dayn ha kusug sin kawasa hi Īsa Almasi, tau Nasarit, amu in piyapatay niyu piyalansang pa usuk iban amu in biyuhiꞌ sin Tuhan nagbalik dayn ha kamatay. ");
INSERT INTO tsg_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","In hi Īsa amuna tuud in piyagꞌiyan ha lawm Kitab, amu agi, ‘In batu biyugit sin manga naghihinang bāy amuna in batu nahinang piyagpapagun sin bāy.’ ");
INSERT INTO tsg_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tunggal da hi Īsa in makarihil kalappasan ha manga mānusiyaꞌ, karnaꞌ wayruun dugaing dayn kaniya dī ha lawm dunya in kiyarihilan sin Tuhan kawasa lumappas kātuꞌniyu.” ");
INSERT INTO tsg_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Na, in manga manghuhukum nainu-inu tuud sin katawakkal mamichara hi Pitrus kay Yahiya, iban pagꞌingat nila sin in duwa tau ini wayruun pangadjiꞌ. Na, kiyaingatan nila sin in hi Pitrus kay Yahiya bakas iban hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Sagawaꞌ wayruun hikasambung sin manga manghuhukum sabab yaun nila kīkitaꞌ in tau kiyaulian nagtitindug ha daig hi Pitrus kay Yahiya. ");
INSERT INTO tsg_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Na, pagga wayruun hikasambung nila, piyaguwaꞌ nila hi Pitrus kay Yahiya dayn ha paghuhukuman ampa sila nagꞌisun. ");
INSERT INTO tsg_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Laung nila, “Unuhun natuꞌ na in manga tau yan? Kiyaingatan sin manga tau katān ha Awrusalam (Baytal Makdis) in muꞌjijat muskil nahinang nila, hangkan diꞌ kitaniyu makaiyan in yan puting. ");
INSERT INTO tsg_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Sagawaꞌ biyaꞌ ha ini in hinangun natuꞌ, ha supaya in hinduꞌ nila diꞌ mapamahalayak pa tau katān. Bāndaan iban sanggupan natuꞌ sila diꞌ papagbicharahun iban papagsabbutun sin ngān hi Īsa.” ");
INSERT INTO tsg_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Na, hangkan piyatawag nila hi Pitrus kay Yahiya piyasūd nagbing ampa nila siyanggupan diꞌ tuud papaisabun magbalik mamichara atawa magnasīhat pasal hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Sagawaꞌ in sambung hi Pitrus kay Yahiya, laung nila, “Bang kamu, ha pangatud sin Tuhan, unu in mapatut hinangun namuꞌ, magkahagad ha daakan niyu atawa magkahagad ha daakan sin Tuhan? ");
INSERT INTO tsg_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Karnaꞌ diꞌ tuud makajari bang namuꞌ bugtuun in panghinduꞌ namuꞌ pasal sin manga kītaꞌ iban diyungug namuꞌ.” ");
INSERT INTO tsg_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Na, siyanggupan tuud sin manga manghuhukum hi Pitrus kay Yahiya. Pagꞌubus ampa nila piyuas piyaguwaꞌ. Napikil nila wayruun mahinang nila puun-sabab hikapaminasa nila kan Pitrus kay Yahiya, sabab in manga tau katān nanglalagguꞌ tuud ha Tuhan pasal sin hinang nakainu-inu nahinang hinda Pitrus. ");
INSERT INTO tsg_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Napauliꞌ nila in sakit kariasali sin tau awn na labi kaꞌpatan tahun in umul. ");
INSERT INTO tsg_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Manjari napuas mayan hi Pitrus kay Yahiya, magtūy sila miyadtu pa manga tau pagkahi nila agad kan Īsa ampa nila biyaytaan sin agi kanila sin manga nakuraꞌ kaimaman iban sin manga nagtatau-maas ha hulaꞌ. ");
INSERT INTO tsg_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Pagdungug nila sin agi hinda Pitrus, magtūy sila nagtaayun nangayuꞌ duwaa pa Tuhan. Amu agi nila, “Ya Tuhan Panghuꞌ namuꞌ, ikaw in makapagbayaꞌ iban nagpapanjari sin langit iban lupaꞌ iban sin dagat iban sin katān luun niya! ");
INSERT INTO tsg_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Sin waktu nakauna yadtu, piyatulunan mu sin Rū mu in daraakun mu hi Daud amu in nanubuꞌ kāmuꞌ, hangkan kiyapamung niya in Parman mu, laung niya, ‘Maytaꞌ in manga bangsa dugaing marugal tuud ha Panghuꞌ; maytaꞌ in manga tau nagꞌisun sin manga hinang diꞌ kumugdan? ");
INSERT INTO tsg_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","In manga kasultanan ha babaw dunya nagtaayun kumuntara kaniya, iban in manga nakuraꞌ naghambuuk umatu ha Tuhan iban ha Almasi amu in pinīꞌ niya makapagbayaꞌ ha katān.’ ");
INSERT INTO tsg_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Na, nabunnal tuud in Parman mu, sabab in hi Hirud iban hi Puntus Pilatu nagpūn dī ha dāira iban sin manga tau bukun bangsa Yahudi iban sin manga pagkahi namuꞌ bangsa Israil. Nagpūn sila kimuntara kan Īsa, amu in hambuuk daraakun suchi, lāgiꞌ amu in giyulal mu Almasi. ");
INSERT INTO tsg_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nagtipun sila huminang sin katān amu in asal mu na giyantaꞌ maawn dayn ha kawasa iban kahandak mu. (Sagawaꞌ walaꞌ nila kiyaingatan sin in yan asal mu giyantaꞌ maawn.) ");
INSERT INTO tsg_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Na, bihaun Ya Tuhan, Panghuꞌ namuꞌ, dunguga na in sanggup nila kāmuꞌ. Hangkan in kami manga daraakun mu mangayuꞌ tuud tabang kaymu, bang mayan dihilan mu kami isug ha supaya kami makatawakkal mamaytaꞌ sin Parman mu pa manga tau. ");
INSERT INTO tsg_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Bang mān isab Ya Tuhan, paguwaun mu in kusug sin kawasa mu magpauliꞌ ha manga tau dayn ha sakit nila, iban bang mayan isab dūlan mu maawn in manga tandaꞌ iban hinang makainu-inu dayn ha kusug sin ngān hi Īsa amu in hambuuk daraakun mu suchi.” ");
INSERT INTO tsg_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pagꞌubus nila nangayuꞌ duwaa, najugjug in bāy piyagtitipunan nila sartaꞌ hiyūp na sila katān sin Rū sin Tuhan iban timawakkal na sila nagpamahalayak sin Parman sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","In manga tau agad kan Īsa naghambuuk-pikilan iban naghangka-atay. Wayruun minsan hambuuk in imiyan sin siya in tagdapu sin altaꞌ niya. In unu-unu katān piyagsasāw-sāwhan nila. ");
INSERT INTO tsg_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Masi-masi in pagpamahalayak sin manga kiyawakilan hi Īsa sin nabuhiꞌ nagbalik hi Panghuꞌ Īsa karnaꞌ in yan kiyasaksian nila tuud. Makusug in pagpamahalayak nila iban in sila katān biyarakatan tuud sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","In sila katān bukun kulang-kabus ha unu-unu kagunahan nila, sabab in sila amu in taga lupaꞌ atawa taga bāy, piyagdagang nila ampa nila diyā iyungsud in bīhan ");
INSERT INTO tsg_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","mawn pa manga kiyawakilan hi Īsa. Pagꞌubus in sīn biyahagiꞌ ha manga tau sasukuꞌ sin magkagunahan. ");
INSERT INTO tsg_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Na, awn hambuuk tau piyagꞌanak ha hulaꞌ Kiprus. In tau ini dayn ha pihak Libi, amu in hangka-bangsa sin manga tau Israil. In ngān sin tau ini hi Yusup, saꞌ diyanglayan siya Barnabas sin manga kiyawakilan hi Īsa. (In hāti sin Barnabas, tau mangdayaw atay.) ");
INSERT INTO tsg_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Na, diyagang hi Yusup in hambuuk lupaꞌ niya ampa niya diyā iyungsud in bīhan mawn pa manga kiyawakilan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Manjari awn isab hambuuk tau hi Ananiyas iban sin asawa niya hi Sappira, in nagdagang sin kaibanan lupaꞌ nila, bat mabahagiꞌ in bīhan pa manga tau magkagunahan. ");
INSERT INTO tsg_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Sagawaꞌ walaꞌ iyungsud hi Ananiyas in katān sīn bīhan pa manga kiyawakilan hi Īsa. Tiyawꞌ niya in kaibanan sīn ha ingat-bayaꞌ da isab sin asawa niya. ");
INSERT INTO tsg_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Sakali laung hi Pitrus kaniya, “Ananiyas, maytaꞌ kaw miyagad sin sasat sin Saytan Puntukan kaymu iban piyutingan mu in Rū sin Tuhan. Tiyawꞌ mu in kaibanan sīn bīhan sin lupaꞌ mu. ");
INSERT INTO tsg_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kitaa ba, sin walaꞌ mu pa kiyadagang in altaꞌ, bukun ka ikaw in tagdapu sin altaꞌ? Na, ubus mu mān diyagang in altaꞌ tantu ikaw in makapagbayaꞌ sin sīn bīhan niya. Na, unu in sabab hangkan kaw naghinang sin biyaꞌ ha yan? Na, ingat kaw, bukun mānusiyaꞌ in piyutingan mu sin hinang mu yan sagawaꞌ Tuhan!” ");
INSERT INTO tsg_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Na, pagdungug na mayan hi Ananiyas sin bichara hi Pitrus, saruun-duun himantak siya pa lupaꞌ sartaꞌ miyugtuꞌ in napas niya. Na, in tau katān nakarungug sin pasal ini landuꞌ tuud miyugaꞌ. ");
INSERT INTO tsg_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Dayꞌ-dayꞌ pakarayaw miyawn in manga bataꞌ baꞌgu nagsaput ha mayat ampa nila kiyubul. ");
INSERT INTO tsg_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Sakali manga kulang-labi tūngka-jām in nakalabay nakakawn hi Sappira. Walaꞌ niya kaingati bang unu in kimugdan ha bana niya. ");
INSERT INTO tsg_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Laung hi Pitrus kaniya, “Baytai aku bang amuna ini in katān bīhan sin altaꞌ niyu iban sin bana mu!” In sambung hi Sappira, “Huun, amuna yan in katān bīhan.” ");
INSERT INTO tsg_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Na, laung hi Pitrus kaniya, “Maytaꞌ kaw iban sin bana mu nakapikil mangdustaꞌ ha Rū sin Tuhan? Na, in manga tau nagkubul ha bana mu, yan na bihaun ha lawang. Bihaun ikaw isab in dāhun nila hikubul!” ");
INSERT INTO tsg_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Na, saruun-duun himantak hi Sappira ha tungud siki hi Pitrus sartaꞌ miyugtuꞌ in napas niya. Na, pagsūd mawn sin manga bataꞌ baꞌgu, kītaꞌ nila miyamatay na hi Sappira. Hangkan siyaput nila na in mayat ampa nila kiyubul ha daig sin bana niya. ");
INSERT INTO tsg_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Na, landuꞌ tuud miyugaꞌ in tau katān agad ha Almasi iban sin kaibanan tau amu in nakarungug sin pasal ini. ");
INSERT INTO tsg_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Manjari ha waktu yadtu mataud in manga hinang mahal-mahal tandaꞌ sin kasabunnalan iban makainu-inu in nahinang sin manga kiyawakilan hi Īsa duun ha manga tau Awrusalam (Baytal Makdis). Na, ha waktu yadtu isab, daran magtipun in manga tau agad kan Īsa duun ha sawrung salas pagtawagun sawrung hi Sultan Sulayman. ");
INSERT INTO tsg_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Liyalagguꞌ sila sin manga tau kamatauran, sagawaꞌ wayruun minsan hambuuk kanila in makatawakkal lumamud ha manga tau agad kan Īsa ha pagtipun-tipun nila ha mayran. ");
INSERT INTO tsg_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Malayngkan minsan bihādtu naggaganap in taud sin manga tau agad kan Īsa. Mataud tuud tau usug-babai in nagparachaya na kan Panghuꞌ Īsa. ");
INSERT INTO tsg_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Na, dayn ha sabab sin manga hinang nakainu-inu nahinang sin manga kiyawakilan hi Īsa, in manga tau nāsakit nagbubutang ha kulangan nila piyagdā sin manga tau mawn pa dān, ha supaya bang lumabay hi Pitrus minsan dakuman lambung niya kalambungan in manga tau nāsakit. ");
INSERT INTO tsg_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nagtipun mawn in manga tau mataud dayn ha kakawm-kawman ha katilibut sin dāira Awrusalam (Baytal Makdis) nagdarā sin manga tau nāsakit iban sin manga tau siyusūd saytan. Na, kiyaulian sila katān. ");
INSERT INTO tsg_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Sakali in Imam Dakulaꞌ iban sin manga iban niya katān sampay in manga manghuhukum pagtawagun Sadduki landuꞌ tuud nangabughuꞌ ha manga kiyawakilan hi Īsa. Hangkan napikil nila subay tuud awn hinangun nila. ");
INSERT INTO tsg_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Na, piyasaggaw nila in manga kiyawakilan hi Īsa, ampa nila piyajīl. ");
INSERT INTO tsg_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Sagawaꞌ sin dūm yadtu piyanaug sin Tuhan in hambuuk malāikat niya imukab sin lawang jīl. Diyā sin malāikat gimuwaꞌ in manga kiyawakilan hi Īsa, ubus laung niya kanila, ");
INSERT INTO tsg_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kadtu kamu pa halaman sin Bāy sin Tuhan ampa kamu tindug didtu mamaytaꞌ ha manga tau pasal sin kabuhiꞌ salama-lama. Pahātihun niyu kanila marayaw.” ");
INSERT INTO tsg_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Na, iyagad sin manga kiyawakilan hi Īsa in agi sin malāikat kanila. Pagꞌabut subu-subu simūd na sila pa lawm halaman sin Bāy sin Tuhan ampa sila nagnasīhat. Sakali in Imam Dakulaꞌ iban sin manga iban niya nagtipun, lāgiꞌ nagꞌisun iban sin manga katān tau-maas Yahudi amu in manghuhukum. Pagꞌubus ampa sila nagꞌuldin hiparā mawn kanila in manga kiyawakilan hi Īsa yadtu ha lawm jīl. ");
INSERT INTO tsg_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Sagawaꞌ pagdatung sin manga sundalu walaꞌ na duun ha lawm jīl in manga kiyawakilan hi Īsa. Hangkan nagbing sila madtu namaytaꞌ ha manga manghuhukum. ");
INSERT INTO tsg_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Laung nila, “Pagdatung namuꞌ pa jīl, in lawang tiyatambul tuud mahugut, lāgiꞌ in manga jaga yaun nagtutungguꞌ. Sagawaꞌ pagꞌukab namuꞌ sin lawang jīl wayruun minsan hambuuk tau kītaꞌ namuꞌ ha lawm!” ");
INSERT INTO tsg_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Pagdungug sin manga nakuraꞌ kaimaman iban sin nakuraꞌ sin manga jaga ha Bāy sin Tuhan nahilu in pikilan nila. Diꞌ nila kaingatan bang unu in kimugdan ha manga kiyawakilan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Sakali awn hambuuk tau nākawn namaytaꞌ kanila, amu agi, “In manga tau jinīl niyu yadtu ha lawm sin halaman sin Bāy sin Tuhan, nagnanasīhat ha manga tau!” ");
INSERT INTO tsg_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Na, miyadtu in nakuraꞌ sin manga jaga iban sin manga tindug niya kimawaꞌ ha manga kiyawakilan hi Īsa. Sagawaꞌ walaꞌ nila liyugus in manga kiyawakilan hi Īsa, sabab mabugaꞌ sila isab tiluun sin batu kaagi sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Diyā nila in manga kiyawakilan hi Īsa, ampa nila piyatindug ha alupan sin manga manghuhukum. Sakali siyumariya na sin Imam Dakulaꞌ in manga kiyawakilan hi Īsa, laung niya, ");
INSERT INTO tsg_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Biyabandaan namuꞌ kamu diꞌ papagnasīhatun pasal sin tau yadtu, sagawaꞌ walaꞌ da kamu nagkahagad! Nalatag na ha katilingkal Awrusalam (Baytal Makdis) in nasīhat niyu, lāgiꞌ sakainagun niyu kāan niyu kami dusa sin pagpatay kaniya!” ");
INSERT INTO tsg_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Simambung hi Pitrus iban sin kaibanan kiyawakilan hi Īsa, laung nila, “Wajib subay kami magkahagad ha Tuhan bukun ha tau. ");
INSERT INTO tsg_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","In hi Īsa piyapatay niyu piyalansang pa usuk, sagawaꞌ biyuhiꞌ siya nagbalik sin Tuhan, amu in piyagtuhanan sin manga kamaasan natuꞌ! ");
INSERT INTO tsg_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dayn ha kusug sin kawasa sin Tuhan nabuhiꞌ siya nagbalik dīhilan sin salagguꞌ-lagguꞌ kawasa magnakuraꞌ iban manglappas, ha supaya in manga tau Israil makapagtawbat sin manga dusa nila bat sila maampun. ");
INSERT INTO tsg_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kiyasaksian namuꞌ in manga yan, lāgiꞌ in pagpatulun sin Tuhan sin Rū niya pa manga sasukuꞌ sin magkahagad sin daakan niya, hambuuk tandaꞌ sin bunnal tuud in katān baytaꞌ namuꞌ!” ");
INSERT INTO tsg_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Na, pagdungug sin manga manghuhukum sin sambung nila, diyugalan tuud in manga manghuhukum iban sakainagun nila patayun nila magtūy in manga kiyawakilan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Sagawaꞌ timindug magtūy in hambuuk iban nila manghuhukum. In ngān niya hi Gamaliyal. In siya ini hambuuk guru sin saraꞌ agama iban hambuuk isab siya Parisi, amu in hambuuk tumpuk sin agama Yahudi. Piyagꞌaaddatan tuud siya sin manga tau katān. Pagtindug niya, piyapaguwaꞌ niya in manga kiyawakilan hi Īsa dayꞌ-dayꞌ dakuman, ");
INSERT INTO tsg_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ubus ampa siya namung ha manga pagkahi niya manghuhukum. Laung niya, “Manga pagkahi ku tau Israil, subay kamu maayad sin hinangun niyu ha manga tau yan. ");
INSERT INTO tsg_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Karnaꞌ katumtuman niyu ka hi Tudas, amu in gimuwaꞌ sin waktu limabay yaun, nagbantug sin baran niya tau mataas siya. Na, awn manga upat-ngagatus tau in miyagad kaniya, sagawaꞌ nabunuꞌ mayan siya napulak-palik in manga tindug niya iban amuna yadtu in kiyatubtuban nila. ");
INSERT INTO tsg_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Na, pagꞌubus awn na isab hambuuk tau dayn ha hulaꞌ Jalil pagngānan Judas in gimuwaꞌ nagnakuraꞌ ha manga tau simulang ha parinta ha waktu sin pagpasulat sin parinta sin ngān sin manga tau katān. Mataud tau in miyagad kaniya, sagawaꞌ nabunuꞌ mayan siya, napulak-palik in katān tindug niya. ");
INSERT INTO tsg_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Na, bihaun bāndaan ta kamu ha pasal sin manga tau yan. Subay niyu pasāran sadja sabab bang in maksud iban hinang nila yan bat dayn ha pikilan sadja sin mānusiyaꞌ, na diꞌ da sa yan sumūng in hinang nila iban magmula da sila. ");
INSERT INTO tsg_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Sagawaꞌ bang yan dayn ha Tuhan, na wayruun dapat niyu umatu kanila, sabab na Tuhan in marā niyu magꞌatu!” ");
INSERT INTO tsg_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Na, iyagad sin manga manghuhukum in bichara hi Gamaliyal. Piyatawag nila in manga kiyawakilan hi Īsa, ampa nila piyalubakan. Pagꞌubus ampa nila biyandaan diꞌ paisabun magbalik magbichara pasal hi Īsa. Ubus ampa nila piyauwiꞌ in manga kiyawakilan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Na, nakaguwaꞌ mayan in manga kiyawakilan hi Īsa dayn ha paghuhukuman, nagkūg-kuyag sila, sabab kiyarihilan sila sin kalagguan limabay sin kasipugan sabab-karnaꞌ sin pagbawgbug nila sin daakan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Na, adlaw-adlaw in paghinduꞌ iban pagnasīhat nila sin Baytaꞌ Marayaw pasal hi Īsa Almasi duun ha halaman sin Bāy sin Tuhan iban ha kabāyan sin manga tau. ");
INSERT INTO tsg_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Manjari limugay mayan nagtataud na in manga tau agad kan Īsa. Sakali naawn in pagkalu sin manga Yahudi amu in bahasa Girik in pagbichara nila iban sin manga purul Yahudi. Naawn in pagkalu, sabab laung sin manga Yahudi amu in bahasa Girik in pagbichara nila, in manga kababaihan nila balu, diꞌ pagbahagian sin balanjaꞌ adlaw-adlaw. ");
INSERT INTO tsg_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Na, hangkan tīpun sin hangpuꞌ tagduwa kiyawakilan hi Īsa in manga tau katān agad kan Īsa. Laung nila ha manga tau, “Diꞌ manjari bang namuꞌ pasāran in pagnasīhat sin Parman sin Tuhan ha supaya namuꞌ maharap in pagbahagiꞌ sin manga balanjaꞌ. ");
INSERT INTO tsg_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Hangkan manga taymanghud, pīꞌ kamu pitu tau duun kaniyu amu in kaingatan niyu halul-akkal iban hiyuhūp sin Rū sin Tuhan. Na, in manga tau mapīꞌ niyu amu in papagkaputun namuꞌ sin parakalaꞌ pasal balanjaꞌ. ");
INSERT INTO tsg_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ampa in kami ini in harapun namuꞌ in pagpangarap pa Tuhan iban pagnasīhat sin Parman sin Tuhan.” ");
INSERT INTO tsg_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Na, kiyaamuhan in manga tau katān sin bichara sin manga kiyawakilan hi Īsa. Hangkan pinīꞌ nila hi Istipan, hambuuk tau balꞌīman iban hiyuhūp sin Rū sin Tuhan. In kaibanan tau isab napīꞌ nila amuna hinda Pilip, Purukurus, Nikanur, Timun, Parminas iban hi Nikulas dayn ha hulaꞌ Antiyuk. In hi Nikulas ini bukun Yahudi saꞌ simūd siya sin agama Yahudi. ");
INSERT INTO tsg_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Na, diyā nila madtu pa manga kiyawakilan hi Īsa in manga napīꞌ nila. Diyupunan in ū ampa piyangayuan duwaa pa Tuhan sin manga kiyawakilan hi Īsa in manga tau napīꞌ nila. ");
INSERT INTO tsg_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Na, hangkan walaꞌ nabugtuꞌ in pagpasaplag sin Parman sin Tuhan. Timaud tuud in manga tau agad kan Īsa duun ha Awrusalam (Baytal Makdis), iban mataud kaimaman in miyagad na magkahagad sin daakan hi Īsa. ");
INSERT INTO tsg_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Manjari in hi Istipan ini, hambuuk tau tiyatabang tuud sin Tuhan iban mabarakat siya. Mataud in manga hinang makainu-inu iban hinang mahal-mahal tandaꞌ sin kasabunnalan in nahinang niya duun ha manga tau Awrusalam (Baytal Makdis). ");
INSERT INTO tsg_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Sagawaꞌ awn manga tau simaggaꞌ kaniya, jamaa dayn ha hambuuk langgal pagtawagun, Langgal Tau Nalimāya. In sila ini manga Yahudi dayn ha hulaꞌ Kirini iban hulaꞌ Iskandal. Naglamud sila iban sin manga kaibanan Yahudi dayn ha hulaꞌ Silisiya iban hulaꞌ Asiya nanglugat kan Istipan. ");
INSERT INTO tsg_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Sagawaꞌ diꞌ nila kaatuhan maglugat hi Istipan sabab in hi Istipan dīrihilan sin Rū sin Tuhan ingat iban kapandayan mamichara. ");
INSERT INTO tsg_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Hangkan siyapali nila in manga tau kaibanan papaiyanun sin diyungug nila hi Istipan namung pangkal pa Tuhan iban kan Musa. ");
INSERT INTO tsg_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Na, amu isab yan in suysuy kiyanat sin manga tau siyapali nila. Na, unu pa? Nahiluhalaꞌ na in manga tau sampay in manga nagtatau-maas ha hulaꞌ iban sin manga guru sin saraꞌ agama. Hangkan siyaggaw nila hi Istipan ampa nila diyā madtu pa manga manghuhukum. ");
INSERT INTO tsg_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Pagꞌubus ampa nila isab diyā in manga tau siyapali nila pa paghukuman mamaytaꞌ sin puting. Laung sin manga tau, “In tau ini daran mamung sin mangīꞌ pasal sin Bāy natuꞌ Dakulaꞌ iban sin manga saraꞌ daakan hi Musa. ");
INSERT INTO tsg_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Diyungug namuꞌ siya nagbichara, amu agi, ‘Lubuhun hi Īsa, tau Nasarit, in Bāy sin Tuhan ini iban pindahan niya in manga addat-mangaddat sin agama naug dayn kan Musa!’” ");
INSERT INTO tsg_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Na, piyandang sin manga manghuhukum hi Istipan sartaꞌ in pamayhuan hi Istipan dimagbus biyaꞌ sin pamayhuan sin malāikat. ");
INSERT INTO tsg_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Sakali laung sin Imam Dakulaꞌ kan Istipan, “Bunnal ka in bichara nila ini pasal mu?” ");
INSERT INTO tsg_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","In sambung hi Istipan, “Manga maas taymanghud, dungug kamu kākuꞌ! Ha waktu walaꞌ pa nakapaghulaꞌ didtu ha Haran hi Ibrahim amu in nanubuꞌ kātuꞌniyu, in Tuhan amu in puunan sin sanglit-sahaya nagpanyataꞌ kan Ibrahim duun ha hulaꞌ Misuputami. ");
INSERT INTO tsg_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Amu agi sin Tuhan kaniya, ‘Īg kaw dayn ha manga lahasiyaꞌ iban dayn ha hulaꞌ mu, ampa kaw kadtu pa hulaꞌ dugaing hipakitaꞌ ku kaymu.’ ");
INSERT INTO tsg_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Na, hangkan minīg siya dayn ha luggiyaꞌ hulaꞌ niya, ampa siya miyadtu naghulaꞌ pa Haran. Limugay mayan, miyatay na in amaꞌ hi Ibrahim duun ha hulaꞌ yaun. Miyamatay mayan in amaꞌ niya, piyapaglayn siya sin Tuhan pa hulaꞌ ini amu in piyaghuhulaan niyu bihaun. ");
INSERT INTO tsg_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Malayngkan, minsan biyaꞌ hādtu,” laung hi Istipan, “walaꞌ pa isab hi Ibrahim dīhilan sin Tuhan sukuꞌ ha hulaꞌ ini. Way minsan hangka-tikang in kiyasukuꞌ kaniya, sagawaꞌ jiyanjian siya sin Tuhan sin hirihil da kaniya iban makakaniya da iban sin manga panubuꞌ niya in hulaꞌ piyagꞌiyan sin Tuhan. Na, ha waktu sin kajanjiꞌ sin Tuhan, in hi Ibrahim way pa anak niya. ");
INSERT INTO tsg_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Biyaꞌ ha ini in baytaꞌ sin Tuhan kan Ibrahim, amu agi, ‘In manga panubuꞌ mu maghulaꞌ ha hulaꞌ dugaing. Mabanyagaꞌ iban mabinsanaꞌ sila duun ha hulaꞌ yan ha lawm upat ngagatus tahun in lugay nila maghulaꞌ duun. ");
INSERT INTO tsg_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Sagawaꞌ panaugan ku da kabinsanaan in bangsa namanyagaꞌ kanila. Pagꞌubus makaīg da sila dayn ha hulaꞌ namanyagaꞌ kanila iban mari na sila magtaat kākuꞌ pa hulaꞌ ini.’ ");
INSERT INTO tsg_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Na, pagꞌubus yadtu nagdaak in Tuhan kan Ibrahim sin subay awnun in pagꞌislam ha manga anak-apuꞌ niya, amu in mahinang tandaꞌ sin paljanjian sin Tuhan kan Ibrahim. Hangkan naabut mayan walu adlaw ha guwaꞌ hi Isahak dayn ha kapagꞌanak kaniya, īslam na siya hi Ibrahim. Sakali nakabaak mayan isab hi Isahak anak, hi Yaꞌkub, īslam niya da isab. Damikkiyan, in hi Yaꞌkub, īslam niya da isab in hangpuꞌ tagduwa anak niya usug, amu in manga kamaasan natuꞌ yadtu. ");
INSERT INTO tsg_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Na, in manga anak hi Yaꞌkub nangabughuꞌ ha taymanghud nila hi Yusup. Hangkan piyagdagang nila hi Yusup. Na, nahinang banyagaꞌ hi Yusup ha Misir, sagawaꞌ walaꞌ siya piyasāran sin Tuhan. ");
INSERT INTO tsg_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Tiyabangan siya piyuas sin Tuhan dayn ha manga kasigpitan kiyalabayan niya. Narā mayan siya pa alupan sin sultan sin Misir, dayn ha tulung-tabang sin Tuhan kiyasulutan in sultan sin addat iban ingat hi Yusup. Hangkan giyulal siya gubnul sin Misir kaagi sin Sultan iban dīhilan siya kawasa nagbayaꞌ ha lawm sin astanaꞌ. ");
INSERT INTO tsg_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Manjari naawn in gutum ha katilingkal Misir iban ha Kanan. Landuꞌ tuud nabinsanaꞌ in manga tau pasal sin gutum. Na, in manga kamaasan natuꞌ yadtu kiyugdan da isab sin gutum, lāgiꞌ wayruun na kabaakan nila kakaun ha hulaꞌ nila. ");
INSERT INTO tsg_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Sakali pagdungug hi Yaꞌkub sin awn kakaun ha Misir, diyaak niya in manga anak niya, amu in manga kamaasan natuꞌ, madtu pa Misir mamī kakaun. Amu yadtu in tagnaan sin pagkadtu nila pa Misir. ");
INSERT INTO tsg_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ha waktu hikaruwa sin pagkadtu nila pa Misir, nagpakilā na hi Yusup ha manga taymanghud niya, iban piyahāti na hi Yusup in sultan pasal sin manga lahasiyaꞌ niya. ");
INSERT INTO tsg_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Hangkan tiyugun hi Yusup in amaꞌ niya hi Yaꞌkub iban sin katān lahasiyaꞌ niya pakawnun pa Misir. Awn kapituwan taglima in taud nila katān. ");
INSERT INTO tsg_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Na, limūd na hi Yaꞌkub iban sin manga kaanakan niya madtu pa Misir. Duun hi Yaꞌkub naghulaꞌ iban sin manga anak niya, amu in manga kamaasan natuꞌ sampay sila miyatay. ");
INSERT INTO tsg_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Na, in manga bangkay nila diyā ampa kiyubul nagbalik ha hulaꞌ Sikim (amu in bakas tagnaꞌ hulaan nila, ha waktu minīg na dayn ha Misir in manga kamaasan natuꞌ). Didtu in manga bangkay kiyubul ha lupaꞌ bakas binī hi Ibrahim dayn ha manga anak hi Hamur. ");
INSERT INTO tsg_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Na, manjari pagga sin masuuk na in waktu hirihil na sin Tuhan in bakas kiyajanjiꞌ niya kan Ibrahim, timaud na tuud in manga bangsa ta ha Misir. ");
INSERT INTO tsg_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Limugay mayan tuud awn na nagsultan ha Misir amu in wayruun pangingat pasal hi Yusup. ");
INSERT INTO tsg_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mangīꞌ in kasuddahan niya ha manga kamaasan natuꞌ. Iyakkalan niya sila iban liyugus niya sila hipabugit in manga anak nila ha supaya mapatay. ");
INSERT INTO tsg_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Na, sakali ha waktu yadtu amu isab in kapagꞌanak kan Musa, hambuuk bataꞌ-bataꞌ madurug tuud. Naipat siya sin inaꞌ-amaꞌ niya ha bāy nila ha lawm tū bulan. ");
INSERT INTO tsg_vpl VALUES ("AC7_21","074_7_21","ACT","7","21"