﻿USE sofia;
DROP TABLE IF EXISTS sofia.trq_vpl;
CREATE TABLE trq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES trq_vpl WRITE;
INSERT INTO trq_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nan huin ꞌngo̱ lista xiꞌí ni xi Jesucristo huin síꞌ daꞌníj xíꞌ David tsínj gane asi̱j ná. Ni̱ xi David huin Abraham tsínj gane asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ni̱ Abraham huin chrej tsínj gu̱ꞌnaj Isaac. Ni̱ Isaac huin chrej tsínj gu̱ꞌnaj Jacob. Ni̱ Jacob huin chrej ni jna̱nj tsínj gu̱ꞌnaj Judá. ");
INSERT INTO trq_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ni̱ Judá huin chrej Fares nga̱ tsínj gu̱ꞌnaj Zara. Ni̱ nni nu̱ngüej síꞌ huin Tamar. Ni̱ Fares huin chrej tsínj gu̱ꞌnaj Esrom. Ni̱ Esrom huin chrej tsínj gu̱ꞌnaj Aram. ");
INSERT INTO trq_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ni̱ Aram huin chrej tsínj gu̱ꞌnaj Aminadab. Ni̱ Aminadab huin chrej tsínj gu̱ꞌnaj Naasón. Ni̱ Naasón huin chrej tsínj gu̱ꞌnaj Salmón. ");
INSERT INTO trq_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ni̱ Salmón huin chrej tsínj gu̱ꞌnaj Booz. Ni̱ nni síꞌ huin yunꞌunj gu̱ꞌnaj Rahab. Ni̱ Booz huin chrej tsínj gu̱ꞌnaj Obed. Ni̱ nni síꞌ huin yunꞌunj gu̱ꞌnaj Rut. Ni̱ Obed huin chrej tsínj gu̱ꞌnaj Isaí. ");
INSERT INTO trq_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ni̱ Isaí huin chrej tsínj gu̱ꞌnaj David. Ni̱ David huin chrej tsínj gu̱ꞌnaj Salomón. Ni̱ nni Salomón huin nica̱ tsínj gu̱ꞌnaj Urías. ");
INSERT INTO trq_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ni̱ Salomón huin chrej tsínj gu̱ꞌnaj Roboam. Ni̱ Roboam huin chrej tsínj gu̱ꞌnaj Abías. Ni̱ Abías huin chrej tsínj gu̱ꞌnaj Asa. ");
INSERT INTO trq_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ni̱ Asa huin chrej tsínj gu̱ꞌnaj Josafat. Ni̱ Josafat huin chrej tsínj gu̱ꞌnaj Joram. Ni̱ Joram huin chrej tsínj gu̱ꞌnaj Uzías. ");
INSERT INTO trq_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ni̱ Uzías huin chrej tsínj gu̱ꞌnaj Jotam. Ni̱ Jotam huin chrej tsínj gu̱ꞌnaj Acaz. Ni̱ Acaz huin chrej tsínj gu̱ꞌnaj Ezequías. ");
INSERT INTO trq_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ni̱ Ezequías huin chrej tsínj gu̱ꞌnaj Manasés. Ni̱ Manasés huin chrej tsínj gu̱ꞌnaj Amón. Ni̱ Amón huin chrej tsínj gu̱ꞌnaj Josías. ");
INSERT INTO trq_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ni̱ Josías huin chrej ni jna̱nj tsínj gu̱ꞌnaj Jeconías ngaa ganꞌanj xa̱caj ni tsínj ma̱n xumanꞌ Babilonia ni ngüi̱ israelita ga̱nꞌanj ni sij xánj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ni̱ ngaa na̱nꞌ ni ngüi̱ israelita xánj ni sij ni̱ Jeconías huin chrej tsínj gu̱ꞌnaj Salatiel. Ni̱ Salatiel huin chrej tsínj gu̱ꞌnaj Zorobabel. ");
INSERT INTO trq_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ni̱ Zorobabel huin chrej tsínj gu̱ꞌnaj Abiud. Ni̱ Abiud huin chrej tsínj gu̱ꞌnaj Eliaquim. Ni̱ Eliaquim huin chrej tsínj gu̱ꞌnaj Azor. ");
INSERT INTO trq_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ni̱ Azor huin chrej tsínj gu̱ꞌnaj Sadoc. Ni̱ Sadoc huin chrej tsínj gu̱ꞌnaj Aquim. Ni̱ Aquim huin chrej tsínj gu̱ꞌnaj Eliud. ");
INSERT INTO trq_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ni̱ Eliud huin chrej tsínj gu̱ꞌnaj Eleazar. Ni̱ Eleazar huin chrej tsínj gu̱ꞌnaj Matán. Ni̱ Matán huin chrej tsínj gu̱ꞌnaj Jacob. ");
INSERT INTO trq_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ni̱ Jacob huin chrej tsínj gu̱ꞌnaj José. Ni̱ José huin nica̱ yunꞌunj gu̱ꞌnaj María. Ni̱ María huin nni Jesús gu̱ꞌnaj síꞌ Cristo. ");
INSERT INTO trq_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Hué dan ni̱ asi̱j tsínj gu̱ꞌnaj Abraham da gaꞌnga tsínj gu̱ꞌnaj David, ni̱ guisíj xiganꞌanj xi Jesucristo. Ni̱ asi̱j tsínj gu̱ꞌnaj David da nicaj ni tsínj ma̱n xumanꞌ Babilonia ni ngüi̱ israelita ganꞌanj ni sij xánj ni sij, ni̱ guisíj ango xiganꞌanj xi Jesucristo. Ni̱ asi̱j na̱nꞌ ni ngüi̱ israelita xánj ni sij da gaꞌnga manꞌan Jesucristo, ni̱ guisíj ango xiganꞌanj ni xi Jesucristo nej aj. ");
INSERT INTO trq_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ni̱ na̱anj gahuin ngaa achin do̱j gaꞌnga Jesucristo. Ni̱ hua gahuin yya ruhua José nga̱ María xacaj nu̱ngüej nej dugüiꞌ nej. Sani̱ ngaa achin ga̱ne nu̱guanꞌan nu̱ngüej nej, ni̱ xacaj María cuenta sisi̱ hua guiriꞌ unj lij, guiꞌyaj Espíritu Santo. ");
INSERT INTO trq_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ni̱ hua ni̱ca niman José huin sij nica̱ María. Ni̱ rian naꞌuej ruhua José ga̱ꞌmi gaquinꞌ sij xiꞌí si gahuin nga̱ María rian ni tsínj nicaj sun, ni̱ gani ruhua sij si du̱na hui̱ sij unj. ");
INSERT INTO trq_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ni̱ ngaa hué daj gani ruhua sij, ni̱ ne̱ꞌ ni̱ gurugüiꞌ ꞌngo̱ ángel gaꞌníj Yanꞌanj ngaa gaꞌninꞌ sij. Ngaa ni̱ gataj ángel daj gunun José: ―Gu̱nun so̱ꞌ si ga̱ꞌmī José huin so̱ꞌ daꞌníj David. Si̱ guxuꞌuiꞌ so̱ꞌ xa̱caj dugüiꞌ so̱ꞌ nga̱ María si Espíritu Santo guiꞌyaj si guiriꞌ unj ꞌngo̱ lij. ");
INSERT INTO trq_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ni̱ gu̱ruj María ꞌngo̱ lij snoꞌo. Ni̱ du̱guꞌnaj so̱ꞌ si-xugüi lij daj Jesús. Ni̱ hué daj gu̱ꞌnaj sij si hué sij ga̱huin tsínj gui̱ꞌyaj si ga̱nani ni ngüi̱ rian si-ga̱quinꞌ ni sij. ―Daj gataj ángel gunun José. ");
INSERT INTO trq_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ni̱ hué daj gahuin daranꞌ nuguanꞌ nan si gui̱sij ga̱huin yya si nataꞌ tsínj gaꞌmi si-nu̱guanꞌ Señor rian ni ngüi̱ asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ni̱ gataj síꞌ: Gui̱niꞌi a ni é re̱ꞌ sisi̱ gui̱riꞌ ꞌngo̱ yunꞌunj xa̱na ya̱n ꞌngo̱ lij. Ni̱ ga̱ꞌnga ꞌngo̱ lij snoꞌo. Ni̱ du̱guꞌnaj ni sij si-xugüi Emanuel. Daj gataj tsínj gaꞌmi si-nu̱guanꞌ Señor daj. Ni̱ Emanuel huin ruhuaj gata sisi̱ nne Yanꞌanj nga̱ néꞌ. ");
INSERT INTO trq_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ni̱ ngaa gananun ruhua José gaꞌninꞌ sij ni̱ guiꞌyaj sij da̱j rúnꞌ gataj si-ángel Señor gunun sij. Ni̱ xacaj sij María gahuin unj nica̱ sij. ");
INSERT INTO trq_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Sani̱ nun gatoj nu̱guanꞌan nu̱ngüej nica̱ sij asi̱j daꞌ gaꞌnga daꞌníj María. Ni̱ duguꞌna̱j José si-xugüi-íꞌ gahuin JESÚS. ");
INSERT INTO trq_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ni̱ gaꞌnga Jesús xumanꞌ Belén ngaa nicaj sun rey Herodes estado Judea. Ni̱ ma̱n ni tsínj diguiꞌyun da̱j hua mán yatiꞌ xataꞌ gaꞌna̱ꞌ ni síꞌ rian síj güi. Ni̱ guisíj ni síꞌ xumanꞌ Jerusalén. ");
INSERT INTO trq_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ni̱ nachínj snanꞌanj ni síꞌ ni tsínj ma̱n xumanꞌ Jerusalén. Ni̱ gataj ni sij: ―Ni̱ a̱ gaꞌnga si-rey ni tsínj israelita únj. Daj si guiniꞌi ni únj digyán yatiꞌ ne̱ꞌ rian síj güi sisi̱ gaꞌnga sij. Ni̱ gaꞌna̱ꞌ únj ga̱niquinꞌ ráj da̱coj únj rian lij gaꞌnga daj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ni̱ ngaa gunun rey Herodes nuguanꞌ daj, ni̱ ni̱nꞌ ruhua gahuin ruhua sij. Ni̱ hué daj gahuin ruhua daranꞌ ni tsínj mán xumanꞌ Jerusalén nej. ");
INSERT INTO trq_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ngaa ni̱ gaquínj rey daj ga̱ꞌnaꞌ daranꞌ chrej aꞌninꞌ nga̱ ni tsínj digyán ley rian ni ngüi̱ nej. Ni̱ nachínj snanꞌanj sij ni síꞌ ni̱ a̱ ga̱ꞌnga Cristo huin tsínj ga̱ꞌnaꞌ na̱caj ni ngüi̱, gui̱ꞌyaj Yanꞌanj xa̱ngaꞌ. ");
INSERT INTO trq_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ngaa ni̱ gataj ni síꞌ gunun sij: ―Ga̱ꞌnga Cristo xumanꞌ Belén xumanꞌ ngaj ne̱ꞌ estado Judea si hué daj garun tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj rian ni ngüi̱ asi̱j ná: ");
INSERT INTO trq_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Gu̱nun manꞌán so̱ꞌ xumanꞌ Belén huin xumanꞌ ngaj doꞌój Judá. Sé ꞌngo̱ xumanꞌ leꞌej huín so̱ꞌ scanij ni xumanꞌ ngaj estado Judea. Daj si ga̱hui ꞌngo̱ tsínj ga̱ꞌninꞌ xánj so̱ꞌ. Ni̱ du̱gumi sa̱ꞌ síꞌ ni ngüi̱ israelita huin ni ngüi̱ nicoꞌ manꞌānj. Daj gataj tsínj daj. ―Daj gataj ni sij gunun Herodes. ");
INSERT INTO trq_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ngaa ni̱ gaquínj hui̱ Herodes ga̱ꞌnaꞌ ni tsínj diguiꞌyun yatiꞌ. Ni̱ nachínj snanꞌanj sij ni síꞌ u̱n güi yya gurugüiꞌ yatiꞌ daj. ");
INSERT INTO trq_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ngaa ni̱ gaꞌníj Herodes ga̱nꞌanj ni síꞌ xumanꞌ Belén. Ni̱ gataj sij: ―Ga̱nꞌanj a ni é reꞌ yuꞌuj daj. Ni̱ na̱chinj snanꞌanj ꞌueé a ni é reꞌ xiꞌí lij daj. Ni̱ ngaa na̱riꞌ a ni é re̱ꞌ, ni̱ ga̱nataꞌ ni é reꞌ gu̱nūnj. Ni̱ ga̱nꞌān gui̱niquinꞌ ráj da̱cō rian ngaj lij daj nej. ―Daj gataj Herodes gunun ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ni̱ ngaa gunun ni sij si gataj rey, ni̱ ganꞌanj ni sij. Ni̱ hué yatiꞌ guiniꞌi sini ni sij rian síj güi, ni̱ digyán-ánꞌ chrej huaj ni sij. Ni̱ ꞌngo̱ ganiquinꞌ yatiꞌ daj digyán-ánꞌ rian ngaj lij daj gaꞌnga. ");
INSERT INTO trq_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ni̱ ngaa guiniꞌi ni tsínj daj yatiꞌ, ni̱ ni̱nꞌ ruhua gahuin nia̱ꞌ ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ni̱ ngaa gatúj ni sij chruhua hueꞌ, ni̱ guiniꞌi ni sij lij daj nga̱ nni María. Ni̱ ganiquinꞌ ráj da̱coj ni sij rian lij daj. Ngaa ni̱ naꞌnij ni sij rian chrúnj nicaj ni sij huaj ni sij. Ni̱ goꞌ ni sij gagaꞌ oro nga̱ siquíj sa̱ꞌ nej nga̱ ꞌngo̱ si guinꞌ da̱j nej rian lij. ");
INSERT INTO trq_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ni̱ ri̱an gataj nnej rian ni sij sisi̱ si̱ nanicaj ni sij rian nne rey Herodes, ngaa ni̱ nanica̱j ni sij ango chrej na̱nꞌ ni sij xánj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ni̱ ngaa guisíj na̱nꞌ ni tsínj daj, ngaa ni̱ gurugüiꞌ ꞌngo̱ si-ángel Yanꞌanj rian José ngaa gaꞌninꞌ sij ngaj sij atoj sij. Ni̱ gataj ángel daj: ―Na̱chica so̱ꞌ na̱caj so̱ꞌ nu̱ngüej nni lij aj. Ni̱ gu̱nánj so̱ꞌ ga̱nꞌanj so̱ꞌ yuꞌuj gu̱ꞌnaj Egipto yuꞌuj daj gu̱na so̱ꞌ da ga̱tā gu̱nun re̱ꞌ. Daj si rey Herodes na̱noꞌ da̱gahuiꞌ lij da aj. ―Daj gataj ángel gunun José. ");
INSERT INTO trq_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ngaa ni̱ nachica José nacaj sij nu̱ngüej nni lij. Ni̱ gahui sij ne̱ꞌ ni̱ ganꞌanj sij Egipto. ");
INSERT INTO trq_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ni̱ gane sij yuꞌuj daj daꞌ gahuiꞌ rey Herodes. Ni̱ hué na̱anj gahuin sisi̱ ga̱huin yya da̱j rúnꞌ gataj ꞌngo̱ tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj rian ni ngüi̱ asi̱j ná. Ni̱ gataj síꞌ: “Gaquīn daꞌnī ga̱hui sij Egipto ga̱ꞌnaꞌ sij.” Daj gataj Yanꞌanj, gataj tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ni̱ ngaa xacaj cuenta Herodes sisi̱ digyaꞌ yunꞌunj ni tsínj diguiꞌyun da̱j hua ni yatiꞌ manꞌan sij, ni̱ ni̱nꞌ ruhua gaꞌman ruhua sij. Ni̱ gaꞌninꞌ sij sun sisi̱ da̱gahuiꞌ ni snado daranꞌ ni lij snoꞌo da aꞌnga nga̱ ni lij guisíj hui̱j yoꞌ xumanꞌ Belén nga̱ daranꞌ ni xumanꞌ ngaj ni̱chrunꞌ nej. Ni̱ daj guiꞌyaj sij sisi̱ ga̱huiꞌ lij huin lij xi̱ꞌi nataꞌ ni tsínj diguiꞌyun daj hua yatiꞌ rian sij. ");
INSERT INTO trq_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ni̱ hué daj gahuin yya sayun da̱j rúnꞌ gataj tsínj gu̱ꞌnaj Jeremías huin síꞌ ꞌngo̱ tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. Ni̱ gataj síꞌ: ");
INSERT INTO trq_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Gunun ni ngüi̱ sisi̱ aco ꞌngo̱ yunꞌunj xa̱na riqui xumanꞌ Ramá. Ni̱ ni̱nꞌ ruhua nani ruhua únꞌ. Ni̱ aco ni̱nꞌ ruhua únꞌ nej. Yunꞌunj xa̱na gu̱ꞌnaj Raquel huin si aco xiꞌí daꞌníj únꞌ. Ni̱ naꞌue na̱huin nia̱ꞌ ruhua únꞌ nga̱ xiꞌí aco únꞌ. Daj si hua guisíj gahuiꞌ ni daꞌníj únꞌ. Daj gataj Jeremías asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Sani̱ ngaa guisíj gahuiꞌ Herodes, ngaa ni̱ gurugüiꞌ ꞌngo̱ si-ángel Señor rian José ne̱ꞌ ni̱ ngaa gaꞌninꞌ sij ngaj sij gane sij yuꞌuj gu̱ꞌnaj Egipto. ");
INSERT INTO trq_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ni̱ gataj ángel daj: ―Na̱chica so̱ꞌ, ni̱ na̱caj so̱ꞌ nu̱ngüej nni lij, ni̱ na̱nicaj so̱ꞌ ga̱nꞌanj so̱ꞌ yuꞌuj gu̱ꞌnaj Israel. Daj si hua guisíj gahuiꞌ ni tsínj ataj sisi̱ da̱gahuiꞌ ni sij lij da aj. ―Daj gataj ángel gunun José. ");
INSERT INTO trq_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ngaa ni̱ nachica José nacaj sij nu̱ngüej nni lij, ni̱ na̱nꞌ sij Israel. ");
INSERT INTO trq_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Sani̱ ngaa gunun José nuguanꞌ sisi̱ guinicaj sun Arquelao estado Judea natuj síꞌ rian chrej síꞌ, ngaa ni̱ guxuꞌuiꞌ sij ga̱nꞌanj sij yuꞌuj daj. Ni̱ ne̱ꞌ ni̱ gaꞌninꞌ ru̱huaꞌ yún sij. Ni̱ gataj Yanꞌanj si gui̱ꞌyaj sij. Ngaa ni ganꞌanj sij estado Galilea. ");
INSERT INTO trq_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ni̱ ngaa guisíj sij yuꞌuj daj, ni̱ ganꞌanj ga̱ne sij xumanꞌ Nazaret. Ni̱ hué daj gahuin sisi̱ ga̱huin da̱j rúnꞌ gataj ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná sisi̱ gu̱ꞌnaj Jesús ꞌngo̱ tsínj ꞌna̱ꞌ Nazaret. ");
INSERT INTO trq_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ni̱ ngaa daj, ni̱ gaꞌna̱ꞌ Juan quij quiꞌyanj naco̱ huin estado Judea. Ni̱ nataꞌ sij si-nu̱guanꞌ Yanꞌanj rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ni̱ gataj sij: ―Ga̱nani ruhua ni é re̱ꞌ xiꞌí si-ga̱quinꞌ ni é re̱ꞌ. Daj si ꞌna̱ꞌ ga̱huin ni̱chrunꞌ güi gui̱nicaj sun Yanꞌanj xa̱ngaꞌ rian ni ngüi̱ aj. ―Daj gataj Juan gunun ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ni̱ asi̱j ná gaꞌmi Isaías tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj xiꞌí Juan. Ni̱ gataj síꞌ: Unun néꞌ si-nane̱ ꞌngo̱ tsínj aꞌmi nucuaj riqui quij quiꞌyanj naco̱ aj. Ni̱ ataj síꞌ sisi̱ gui̱ꞌyaj xugüi néꞌ si-chrej manꞌan Señor. Daj si da̱j rúnꞌ naguiꞌyaj sa̱ꞌ néꞌ chrej ga̱ꞌnaꞌ ꞌngo̱ tsínj huin achij nico, ni̱ daꞌngaꞌ daj na̱guiꞌyaj néꞌ niman néꞌ aj. Hué daj gataj Isaías asij ná. ");
INSERT INTO trq_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ni̱ si-ganꞌ Juan huin to xucu gu̱ꞌnaj camello. Ni̱ nnij cinchru ꞌni̱j gatin sij. Ni̱ si xa sij huin xiriquíj nga̱ gatsiꞌ ma̱n riqui quij. ");
INSERT INTO trq_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ni̱ gahui ni ngüi̱ ma̱n xumanꞌ Jerusalén nga̱ ni ngüi̱ ꞌna̱ꞌ ni̱nꞌ ga̱chraꞌ estado Judea nga̱ ni ngüi̱ ꞌna̱ꞌ nu̱ngüej duꞌua xinéj nnee gu̱ꞌnaj Jordán ꞌna̱ꞌ ni sij rian nne Juan. ");
INSERT INTO trq_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ni̱ duguataꞌ nne Juan ni sij chruhua xinéj nnee daj. Ni̱ nataꞌ ni sij si-ga̱quinꞌ ni sij. Ngaa ni̱ gataꞌ nnee ni sij. ");
INSERT INTO trq_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Sani̱ ngaa guiniꞌi Juan sisi̱ ꞌna̱ꞌ nico ni tsínj fariseo nga̱ ni tsínj saduceo ga̱taꞌ nnee ni sij, ruhua ni sij, ni̱ gataj sij gunun ni síꞌ: ―Daꞌníj xucuáj huin ni é re̱ꞌ aj. Ni̱ u̱n tsínj gataj chru̱n rian ni é re̱ꞌ sisi̱ ga̱nani ni é re̱ꞌ rian castigo nico gui̱ꞌyaj Yanꞌanj únj. ");
INSERT INTO trq_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ga̱ ꞌueé gui̱ꞌyaj ni é re̱ꞌ aj. Hué dan ni̱ ga̱ꞌue gui̱niꞌi ni ngüi̱ sisi̱ hua yya nani ruhua ni é re̱ꞌ xiꞌí si-ga̱quinꞌ ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ni̱ si̱ gani ruhua manꞌan ni é re̱ꞌ: “Daꞌníj Abraham huin ni únj.” Sé daj ga̱ni ruhua ni é re̱ꞌ mánj. Daj si atā gu̱nun a ni é re̱ꞌ sisi̱ yej ngaj nan, ni̱ ga̱ꞌue gui̱ꞌyaj Yanꞌanj daꞌníj Abraham. ");
INSERT INTO trq_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","’Ni̱ a̱ hua chru̱n gagaꞌ hacha ga̱ꞌnij yaꞌa̱ siu̱ ni chrun. Ni̱ da̱j rúnꞌ ꞌyaj ꞌngo̱ tsínj nga̱ gagaꞌ hacha, ni̱ daꞌngaꞌ daj gui̱ꞌyaj Yanꞌanj nga̱ daranꞌ chrun nitaj si ayu chruj sa̱ꞌ chra̱. Ni̱ ga̱ꞌnij Yanꞌanj ni chrun daj ga̱ca-áꞌ rian yanꞌa̱n anj. Ni̱ da̱j rúnꞌ ꞌyaj ni chrun daj, ni daꞌngaꞌ daj ꞌyaj ni tsínj nun unun rian Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","’Xa̱ngaꞌ yya duguataꞌ nnee manꞌānj nga̱ nnee a ni é re̱ꞌ aj. Daj si nani ruhua ni é re̱ꞌ xiꞌí si-ga̱quinꞌ a ni é re̱ꞌ. Sani̱ ne̱ꞌ rucūj ga̱ꞌnaꞌ ꞌngo̱ tsínj nucuaj daj nga̱ manꞌānj. Ni̱ na̱ꞌaj yānj nicā ga̱nꞌān dacánj síꞌ aj. Daj si huin achij síꞌ daj nga̱ manꞌānj. Ni̱ du̱guataꞌ nnee síꞌ a ni é re̱ꞌ nga̱ Espíritu Santo nga̱ yanꞌa̱n nej. ");
INSERT INTO trq_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ni̱ hua guidaꞌa tsínj daj si-pala sij si na̱guiꞌyaj sa̱ꞌ sij riqui strigo. Ni̱ ga̱hui coj riqui strigo daj. Ni̱ na̱ra sa̱ꞌ sij strigo chruhua guru̱. Sani̱ ga̱ri yanꞌa̱n sij coj gahui riqui strigo ga̱ca-áꞌ ni̱ganj ni̱nꞌ. Ni̱ da̱j rúnꞌ hua strigo hua ni tsínj unun si ataj Yanꞌanj. Ni̱ da̱j rúnꞌ hua coj hua ni tsínj nun unun rian Yanꞌanj anj. ―Daj gataj Juan gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Hué dan ni̱ gahui Jesús estado Galilea ganꞌanj sij duꞌua xinéj nnee gu̱ꞌnaj Jordán rian nne Juan. Ni̱ huin ruhua sij sisi̱ du̱guataꞌ nnee Juan manꞌan sij. ");
INSERT INTO trq_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Sani̱ naꞌuej ruhua Juan, ni̱ gataj síꞌ: ―Hua nia̱n sisi̱ du̱guataꞌ nnee manꞌán re̱ꞌ manꞌānj. Ni̱ sé si sa̱ꞌ si du̱guataꞌ nnēj manꞌán re̱ꞌ mánj. ―Daj gataj Juan gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Sani̱ gataj Jesús gunun Juan: ―Ga̱ꞌninꞌ ruhuá re̱ꞌ yya̱j aj. Daj si hua nia̱n si ga̱huin yya daranꞌ nuguanꞌ ni̱ca gaꞌninꞌ Yanꞌanj sun riunꞌ. ―Daj gataj Jesús. Ngaa ni̱ garáj xina̱ Juan. ");
INSERT INTO trq_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ni̱ ngaa guisíj gataꞌ nnee Jesús, ni̱ ꞌngo̱ hora gahui sij chruhua nnee. Hué dan ni̱ naxiꞌni̱j xataꞌ. Ni̱ guiniꞌi Jesús sisi̱ ꞌna̱ꞌ guinij Espíritu Santo rian sij. Ni̱ da̱j rúnꞌ hua ꞌngo̱ xuꞌma̱n hua Espíritu Santo gaꞌna̱ꞌ rian sij. ");
INSERT INTO trq_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ni̱ gunun ni ngüi̱ ꞌngo̱ nane̱ ꞌna̱ꞌ xataꞌ gataj manꞌan Yanꞌanj xa̱ngaꞌ: ―Nan huin daꞌnī ꞌi̱ ruhuāj. Ni̱ hua nia̱ꞌ ruhuāj niꞌyā sij aj. ―Daj gataj Yanꞌanj gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Hué dan ni̱ nicaj Espíritu Santo Jesús ganꞌanj-ánꞌ riqui quij quiꞌyanj na̱co sisi̱ gui̱ꞌyaj fuerza sichre Satanás si gui̱ꞌyaj Jesús gaquinꞌ. ");
INSERT INTO trq_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ni̱ daꞌ guisíj hui̱j xia güi, ni̱ nun xa Jesús nugüi ni̱ganꞌ. Ni̱ ngaa guisíj daj achin xiꞌna̱ riqui sij. ");
INSERT INTO trq_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ngaa ni̱ gaꞌna̱ꞌ sichre Satanás di̱gyaꞌ yunꞌunj-únꞌ manꞌan Jesús. Ni̱ gataj sichre: ―Sisi̱ xa̱ngaꞌ re̱ꞌ huín re̱ꞌ daꞌníj Yanꞌanj, ngaa ni̱ na̱guiꞌyaj so̱ꞌ si ga̱nahuin yej ngaj nan chrachrúnj xa̱ so̱ꞌ stoj. ―Daj gataj sichre gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Sani̱ gataj Jesús: ―Gataj si-nu̱guanꞌ Yanꞌanj: “Sé urin chrachrúnj gui̱ꞌyaj si ga̱ ni̱ꞌnaꞌ ni ngüi̱ mánj. Sani̱ ga̱ ni̱ꞌnaꞌ xa̱ngaꞌ ni ngüi̱ gui̱ꞌyaj daranꞌ ni nuguanꞌ ꞌna̱ꞌ rian Yanꞌanj anj.” Daj gataj Yanꞌanj. ―Daj gataj Jesús gunun sichre. ");
INSERT INTO trq_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ngaa ni̱ nicaj sichre Satanás Jesús ganꞌanj-ánꞌ xumanꞌ hua sa̱ꞌ gu̱ꞌnaj Jerusalén. Ni̱ gahui Jesús chra̱ nuhui nico, guiꞌyaj sichre. Ngaa ni̱ gataj sichre gunun Jesús: ");
INSERT INTO trq_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","―Sisi̱ yya huín re̱ꞌ daꞌníj Yanꞌanj, ngaa ni̱ güe̱j re̱ꞌ ni̱caꞌ nánj. Daj si gataj si-nu̱guanꞌ Yanꞌanj: Ga̱ꞌninꞌ Yanꞌanj sun rian ni ángel sisi̱ ga̱ꞌnaꞌ du̱gumi ni síꞌ manꞌán so̱ꞌ aj. Ngaa ni̱ gui̱nij so̱ꞌ rian raꞌa ni ángel sisi̱ si̱ garij so̱ꞌ dacój so̱ꞌ gui̱ꞌyaj yej mánj. Daꞌngaꞌ daj gataj si-nu̱guanꞌ Yanꞌanj anj. ―Gataj sichre gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ngaa ni̱ gataj Jesús gunun sichre: ―Ni̱ hué daj hua ni̱ca si-nu̱guanꞌ Yanꞌanj nej: “Si̱ xacaj so̱ꞌ cuenta sisi̱ xa̱ngaꞌ si-nu̱guanꞌ Señor huin Danꞌanj so̱ꞌ mánj.” Hué daj gataj si-nu̱guanꞌ Yanꞌanj anj. ―Daj gataj Jesús gunun sichre. ");
INSERT INTO trq_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Hué dan ni̱ nicaj sichre Satanás Jesús ganꞌanj-ánꞌ ꞌngo̱ quij xa̱can. Ni̱ digyán sichre daranꞌ xumanꞌ ma̱n chruhua xungüi̱ rian Jesús. Ni̱ digyán sichre da̱j hua ꞌueé daranꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ngaa ni̱ gataj sichre gunun Jesús: ―Ri̱quīj daranꞌ nan rián re̱ꞌ sisi̱ gui̱niquinꞌ ráj da̱coj re̱ꞌ riānj. Ni̱ ga̱ꞌmi sa̱ꞌ re̱ꞌ riānj anj. ―Daj gataj sichre gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús gunun sichre Satanás: ―Gu̱xun so̱ꞌ manꞌán so̱ꞌ riānj huin so̱ꞌ Satanás. Daj si gataj si-nu̱guanꞌ Yanꞌanj: “Ga̱niquinꞌ ráj da̱coj néꞌ rian Señor huin Danꞌanj néꞌ. Ni̱ da̱gahuin néꞌ rian urin Yanꞌanj anj.” Hué daj gataj Yanꞌanj. ―Daj gataj Jesús gunun sichre. ");
INSERT INTO trq_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ngaa ni̱ gahuin anéj sichre rian Jesús. Ni̱ gaꞌna̱ꞌ chraquij yunꞌunj ni ángel Jesús. ");
INSERT INTO trq_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ni̱ ngaa gunun Jesús sisi̱ garij ni sij ducuagaꞌ Juan, ngaa ni̱ na̱nꞌ sij estado Galilea. ");
INSERT INTO trq_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ngaa ni̱ gahui sij xumanꞌ Nazaret ganꞌanj sij ga̱ne sij xumanꞌ Capernaum huin ꞌngo̱ xumanꞌ ngaj duꞌua laguna huin doꞌój ni da̱ꞌnij nu̱ngüej tsínj gu̱ꞌnaj Zabulón nga̱ Neftalí. ");
INSERT INTO trq_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ni̱ hué daj guiꞌyaj Jesús sisi̱ ga̱huin yya da̱j rúnꞌ gaꞌmi Isaías huin síꞌ tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ni̱ gataj síꞌ: Nan huin doꞌój Zabulón nga̱ doꞌój Neftalí. Ni̱ hué yuꞌuj nan ga̱che néꞌ gui̱sij néꞌ duꞌua laguna xxi. Ni̱ yuꞌuj nan huin anéj chrej duꞌua xinéj nnee gu̱ꞌnaj Jordán. Ni̱ gu̱ꞌnaj yuꞌuj nan estado Galilea rian ma̱n ni ngüi̱ ꞌna̱ꞌ anéj chrej aj. ");
INSERT INTO trq_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ni̱ ngüi̱ ma̱n rian hua ru̱miꞌ, ni̱ guiniꞌi ni sij ꞌngo̱ yanꞌa̱n xxi. Ni̱ guixigui̱n yanꞌa̱n daj rian ni ngüi̱ ruhua ga̱huiꞌ, guiꞌyaj Yanꞌanj. Hué daj garun Isaías asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ni̱ asi̱j güi daj, ni̱ gaxi̱ꞌi Jesús gaꞌmi sij rian ni ngüi̱. Ni̱ gataj sij: ―Ga̱nani ruhua a ni é re̱ꞌ xiꞌí si-ga̱quinꞌ a ni é re̱ꞌ. Daj si ꞌna̱ꞌ ga̱huin ni̱chrunꞌ güi gui̱nicaj sun Yanꞌanj nne xataꞌ rian án re̱ꞌ. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ni̱ ngaa gachéj Jesús duꞌua laguna xxi gu̱ꞌnaj Galilea, ni̱ guiniꞌi sij nu̱ngüej jna̱nj tsínj daj. Ni̱ ꞌngo̱ tsínj daj gu̱ꞌnaj Simón. Ni̱ hué daj gu̱ꞌnaj sij Pedro nej. Ni̱ jnánj sij gu̱ꞌnaj Andrés. Ni̱ aꞌníj nu̱ngüej sij nnánj chruhua nnee. Daj si tsínj riꞌ xucuaj huin nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ni̱ gataj Jesús gunun nu̱ngüej sij: ―Gui̱nicoꞌ nu̱ngüej é re̱ꞌ manꞌānj anj. Ngaa ni̱ da̱j rúnꞌ gui̱ꞌyā sisi̱ riꞌ ni é re̱ꞌ xucuaj, daꞌngaꞌ daj gui̱riꞌ a ni é re̱ꞌ ni tsínj gu̱xuman ruhua ni̱ꞌyaj manꞌānj. ―Daj gataj Jesús gunun nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Hué dan ni̱ ꞌngo̱ hora, ni̱ duna nu̱ngüej sij xinánj sij. Ni̱ guinicoꞌ nu̱ngüej sij Jesús. ");
INSERT INTO trq_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ni̱ ngaa huaj Jesús do̱j, ni̱ guiniꞌi sij yahuij jna̱nj tsínj daj. Ni̱ ꞌngo̱ sij huin Jacobo daꞌníj Zebedeo. Ni̱ jnánj sij huin Juan. Ni̱ ma̱n aninꞌ da̱ꞌnij Zebedeo chruhua ꞌngo̱ rio̱ achéj rian nnee. Ni̱ naguiꞌyaj sa̱ꞌ aninꞌ sij nnánj ri xucuaj. Ngaa ni̱ gaquínj Jesús ga̱ꞌnaꞌ nu̱ngüej jna̱nj sij. ");
INSERT INTO trq_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ngaa ni̱ ꞌngo̱ hora, ni̱ duna nu̱ngüej sij rio̱ nga̱ chrej nu̱ngüej sij. Ni̱ guinicoꞌ nu̱ngüej sij Jesús ganꞌanj nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Hué dan ni̱ gachéj Jesús ni̱nꞌ ga̱chraꞌ estado Galilea. Ni̱ digyán sij nuguanꞌ sa̱ꞌ chruhua si-nuhui ni tsínj ma̱n ni xumanꞌ daj. Ni̱ gaꞌmi sij nuguanꞌ sa̱ꞌ xiꞌí si nicaj sun Yanꞌanj rian néꞌ. Ni̱ guiꞌyaj sij sisi̱ ga̱nahuin daranꞌ ni ngüi̱ ranꞌ xiꞌi̱ nga̱ ni ngüi̱ aꞌnanꞌ nej. ");
INSERT INTO trq_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ngaa ni̱ ni̱nꞌ ga̱chraꞌ estado Siria gaꞌmi ni ngüi̱ xiꞌí si guiꞌyaj Jesús. Ngaa ni̱ nicaj ni sij daranꞌ ni ngüi̱ aꞌnanꞌ gaꞌi̱ rian xiꞌi̱ gaꞌna̱ꞌ ni sij rian Jesús. Ni̱ gaꞌna̱ꞌ ni ngüi̱ aꞌngaj nga̱ ni ngüi̱ nu̱n sichre niman nej, ni ngüi̱ sinúnj nej nga̱ ni ngüi̱ nareꞌ dacój nej. Ni̱ nahuin daranꞌ ni sij, guiꞌyaj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ni̱ nico ni ngüi̱ ꞌna̱ꞌ estado Galilea nga̱ ni ngüi̱ ꞌna̱ꞌ estado Decápolis nej, ni ngüi̱ ma̱n xumanꞌ Jerusalén nga̱ ni ngüi̱ ꞌna̱ꞌ estado Judea nej, ni ngüi̱ ꞌna̱ꞌ anéj chrej xinéj nnee gu̱ꞌnaj Jordán nicoꞌ ni sij Jesús gaꞌna̱ꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ni̱ ngaa guiniꞌi Jesús sisi̱ ꞌna̱ꞌ nico ni ngüi̱ rian sij, ngaa ni̱ gahui sij chra̱ ꞌngo̱ quij ganꞌanj ga̱ne sij. Ni̱ gaꞌna̱ꞌ ni tsínj nicoꞌ sij rian sij. ");
INSERT INTO trq_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ngaa ni̱ gaxi̱ꞌi sij digyán sij nuguanꞌ sa̱ꞌ rian ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ni̱ gataj Jesús: ―Hua ꞌueé rian ni tsínj niꞌi sisi̱ achin ga̱huin sa̱ꞌ ni sij rian Yanꞌanj. Daj si gui̱man xa̱ngaꞌ ni sij xataꞌ rian nicaj sun Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Ni̱ hua ꞌueé rian ni tsínj aco. Daj si na̱huin nia̱ꞌ ruhua ni sij, gui̱ꞌyaj Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Ni̱ hua ꞌueé rian ni tsínj aꞌmi na̱j. Daj si na̱huin raꞌa ni sij xungüi̱, gui̱ꞌyaj Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Ni̱ hua ꞌueé rian ni tsínj huin ruhua gui̱ꞌyaj ni̱ca. Ni̱ da̱j rúnꞌ huin róꞌ ngaa achin xiꞌna̱ riquíꞌ, asi̱ ngaa nagoꞌóꞌ nnee, ni̱ daꞌngaꞌ daj huin ruhua ni sij gui̱ꞌyaj ni̱ca ni sij. Ni̱ hua ꞌueé rian ni sij. Daj si ga̱huin sa̱ꞌ niman ni sij, gui̱ꞌyaj Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Ni̱ hua ꞌueé rian ni tsínj ani yaco ruhua niꞌyaj ango dugüiꞌ ni sij. Daj si ga̱ni yaco ruhua Yanꞌanj ni̱ꞌya ni sij aj. ");
INSERT INTO trq_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Ni̱ hua ꞌueé rian ni tsínj hua sa̱ꞌ niman. Daj si gui̱niꞌi ni sij manꞌan Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Ni̱ hua ꞌueé rian ni tsínj ꞌyaj sisi̱ na̱ꞌmi ni dugüiꞌ ni sij huin ni ngüi̱ ununꞌ. Daj si gu̱ꞌnaj ni sij daꞌníj Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Ni̱ hua ꞌueé rian ni tsínj ranꞌ sayun xiꞌí si ꞌyaj nica̱ ni sij rian Yanꞌanj. Daj si gui̱man xa̱ngaꞌ ni sij xataꞌ rian nicaj sun Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Ni̱ hua ꞌueé rian a ni é re̱ꞌ ngaa ga̱ꞌmi quij ni ngüi̱ rian án reꞌ xiꞌīj. Ni̱ chranꞌ yunꞌunj ni sij ni é re̱ꞌ nej. Ni̱ ga̱ꞌmi yya̱ ni sij daranꞌ nuguanꞌ quij hua rian ni é re̱ꞌ xiꞌí si nicaj dugüiꞌ a ni é re̱ꞌ ngāj. ");
INSERT INTO trq_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ga̱huin nia̱ꞌ ruhua ni é re̱ꞌ. Ni̱nꞌ ruhua ga̱huin nia̱ꞌ ruhua ni é re̱ꞌ aj. Daj si na̱huin raꞌa ni é re̱ꞌ premio xataꞌ. Ni̱ hué daj chranꞌ yunꞌunj ni sij ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná ngaa achin gui̱man a ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Rúnꞌ huin ya̱n huin a ni é re̱ꞌ chruhua xungüi̱ nan. Sani̱ sisi̱ nitaj si ꞌni̱nꞌ ya̱n daj, ni̱ nitaj da̱j gui̱ꞌyaj néꞌ sisi̱ na̱huin ꞌni̱nꞌ mánj. Nitaj si níꞌyan mánj. Maan si gue̱reꞌej néꞌ ne̱ꞌ chrej xe̱ꞌ sisi̱ gu̱run ni ngüi̱ ya̱n guereꞌ da aj. ");
INSERT INTO trq_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Hué a ni é re̱ꞌ huin yanꞌa̱n xigui̱n chruhua xungüi̱ nan. Ni̱ si̱ gaꞌue gui̱xij hui̱ ꞌngo̱ xumanꞌ ngaj chra̱ quij xa̱can mánj. ");
INSERT INTO trq_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ni̱ ngaa arúnꞌ yanꞌa̱n chra̱ ꞌngo̱ candil, ni̱ si̱ guneꞌ hui̱ꞌ candil riqui chrúnj ga̱nun yanꞌa̱n da mánj. Sani̱ gu̱toꞌ xataꞌ sisi̱ gui̱xiguin yanꞌa̱n daj rian daranꞌ ni ngüi̱ ma̱n chruhua hueꞌ, gui̱ꞌyaj candil daj aj. ");
INSERT INTO trq_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ni̱ hué ducuánj daj gui̱ꞌyaj ni é re̱ꞌ sisi̱ ga̱huin ni é re̱ꞌ ꞌngo̱ si xigui̱n rian ni ngüi̱. Ni̱ ngaa gui̱niꞌi ni sij si ꞌyaj sa̱ꞌ a ni é re̱ꞌ, ni̱ ga̱ꞌmi sa̱ꞌ ni sij rian chrej a ni é re̱ꞌ nne xataꞌ. ");
INSERT INTO trq_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Si̱ gani ruhua ni é re̱ꞌ sisi̱ gaꞌnāj ga̱ꞌnē si-ley Yanꞌanj nga̱ si digyán ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. Sé daj huin mánj. Sani̱ gaꞌnāj sisi̱ xa̱caj ni ngüi̱ cuenta da̱j ataj yya ni nuguanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Xa̱ngaꞌ yya atā gu̱nun a ni é re̱ꞌ sisi̱ da ga̱nahuij xataꞌ nga̱ yoꞌój, ni̱ a̱ ꞌngo̱ letra le, ni̱ a̱ ꞌngo̱ punto le si̱ guereꞌ rian si-ley Yanꞌanj mánj. Daj si hua nia̱n sisi̱ ga̱huin yya daranꞌanj da̱j rúnꞌ ataj rian si-ley Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Hué dan ni̱ u̱n tsínj naꞌuej ruhua da̱gahuin ꞌngo̱ nuguanꞌ leꞌej aꞌninꞌ Yanꞌanj sun riunꞌ, ni̱ hué daj di̱gyán sij si gui̱ꞌyaj ni dugüiꞌ sij, ngaa ni̱ ga̱huin sij ꞌngo̱ tsínj gui̱nicoꞌ da ru̱cu rian nicaj sun Yanꞌanj. Sani̱ tsínj da̱gahuin nuguanꞌ daj, ni̱ hué daj di̱gyán sij rian ni ngüi̱, ni̱ ga̱huin achij sij rian nicaj sun Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","’Daj si ataj snanꞌān gu̱nun ni é re̱ꞌ sisi̱ ꞌyaj ni̱ca ni tsínj digyán si-ley Yanꞌanj nga̱ ni tsínj fariseo, ruhua ni sij. Sani̱ sisi̱ si̱ guiꞌyaj ni̱ca ni é re̱ꞌ doj rian ni ngüi̱ da̱j rúnꞌ ꞌyaj ni tsínj daj, ngaa ni̱ nitaj a̱man ga̱tu a ni é re̱ꞌ rian nicaj sun Yanꞌanj mánj. ");
INSERT INTO trq_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Hua gunun a ni é re̱ꞌ si gataj ni sij rian ni xi ni é re̱ꞌ: “Si̱ dagahuíꞌ re̱ꞌ ngüi̱ mánj. Daj si tsínj da̱gahuiꞌ dugüiꞌ sij, ni̱ ga̱huin sij castigo, gui̱ꞌyaj Yanꞌanj anj.” Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Sani̱ ataj snanꞌanj manꞌānj gu̱nun a ni é re̱ꞌ sisi̱ u̱n tsínj ga̱ꞌman ruhua ni̱ꞌya dugüiꞌ sij, ni̱ ga̱huin sij castigo, gui̱ꞌyaj Yanꞌanj. Ni̱ sisi̱ ga̱ꞌmi quij ꞌngo̱ tsínj rian dugüiꞌ sij, ni̱ ga̱nꞌanj sij rian junta nico. Ni̱ sisi̱ ga̱taj ꞌngo̱ tsínj sisi̱ nuhuiꞌ staꞌngaꞌ dugüiꞌ sij nu̱n, ni̱ hua xiꞌí si ga̱nꞌanj sij rian yanꞌa̱n ga̱ca sij aj. ");
INSERT INTO trq_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Hué dan ni̱ sisi̱ nicáj re̱ꞌ ꞌngo̱ ofrenda huáj re̱ꞌ rian Yanꞌanj, ni̱ hué yuꞌuj daj ga̱nanun ruhuá re̱ꞌ sisi̱ guiꞌyáj re̱ꞌ ꞌngo̱ gaquinꞌ rian ꞌngo̱ dugüíꞌ re̱ꞌ, ");
INSERT INTO trq_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ngaa ni̱ hué gue̱ yuꞌuj daj du̱na re̱ꞌ si-ofrendá re̱ꞌ daj, ni̱ ga̱nꞌanj siní re̱ꞌ na̱ꞌmi re̱ꞌ nga̱ dugüíꞌ re̱ꞌ. Ngaa ni̱ na̱nicaj ru̱huaꞌ yún re̱ꞌ, ni̱ ga̱ꞌuiꞌ re̱ꞌ ofrenda daj rian Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Ni̱ ráꞌyanj ga̱ꞌmi ꞌueé re̱ꞌ nga̱ tsínj ununꞌ nga̱ re̱ꞌ ngaa huáj re̱ꞌ nacaj dugüíꞌ re̱ꞌ nga̱ sij chrej sisi̱ si̱ nagaꞌuiꞌ sij manꞌán re̱ꞌ rian güesi̱ mánj. Ngaa ni̱ sisi̱ si̱ naꞌmi nu̱ngüej é re̱ꞌ, ngaa ni̱ na̱gaꞌuiꞌ güesi̱ manꞌán re̱ꞌ rian caíde. Ni̱ ga̱ri caíde daj ducuagaꞌ manꞌán re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ni̱ ataj snanꞌān gu̱nun re̱ꞌ sisi̱ nitaj si huaj ga̱hui re̱ꞌ yuꞌuj daj da gui̱sij na̱ruꞌue re̱ꞌ daranꞌ sanꞌanj daꞌuí re̱ꞌ. Da ni ga̱hui re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Hua gunun a ni é reꞌ si gataj ni sij asi̱j ná: “Si̱ gaꞌmí re̱ꞌ nga̱ nica̱ dugüíꞌ re̱ꞌ mánj.” Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Sani̱ ataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ u̱n tsínj niꞌyaj rian ꞌngo̱ yunꞌunj xa̱na ngaa huin ruhua sij ni̱ꞌyaj sij rian unj, ni̱ hua gaꞌmi niman sij nga̱ unj. ");
INSERT INTO trq_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Hué dan ni̱ sisi̱ rundij rián re̱ꞌ ne̱ꞌ chrej raꞌá sa̱ꞌ re̱ꞌ huin ruhua gui̱ꞌyaj gaquinꞌ, ngaa ni̱ gui̱ri re̱ꞌ gue̱reꞌ re̱ꞌ aj. Na̱anj sa̱ꞌ huin sisi̱ gue̱reꞌ ꞌngo̱ rundij rián re̱ꞌ sisi̱ ga̱nꞌanj ga̱ca nnee̱ cúj re̱ꞌ rian yanꞌa̱n anj. ");
INSERT INTO trq_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ni̱ sisi̱ ne̱ꞌ chrej raꞌa sa̱ꞌ re̱ꞌ huin ruhua gui̱ꞌyaj gaquinꞌ, ngaa ni̱ ga̱ꞌninꞌ re̱ꞌ. Na̱anj sa̱ꞌ huin sisi̱ gue̱reꞌ anéj chrej raꞌá re̱ꞌ sisi̱ ga̱nꞌanj niꞌyá re̱ꞌ rian yanꞌa̱n anj. ");
INSERT INTO trq_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Ni̱ gataj ni sij asi̱j ná: “Ni̱ u̱n tsínj guereꞌej nica̱, ni̱ hua nia̱n na̱chi nicaj sij yanj ata na̱gaꞌuiꞌ sij raꞌa únꞌ.” Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Sani̱ ataj snanꞌanj manꞌānj gu̱nun a ni é re̱ꞌ sisi̱ u̱n tsínj gue̱reꞌej nica̱ ngaa sé xiꞌí si aꞌmi únꞌ nga̱ ango tsínj, ngaa ni̱ daꞌui únꞌ gaquinꞌ ngaa xa̱caj dugüiꞌ únꞌ nga̱ ango tsínj, guiꞌyaj sij. Ni̱ tsínj xa̱caj yunꞌunj xa̱na guereꞌej nica̱, ni̱ da̱j rúnꞌ ꞌyaj tsínj gaꞌmi nga̱ nica̱ ango tsínj, ꞌyaj sij aj. ");
INSERT INTO trq_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Ni̱ hua gunun ni é reꞌ sisi̱ gataj ni sij rian ni xi ni é re̱ꞌ: “Ni̱ si̱ duná re̱ꞌ si da̱gahuín re̱ꞌ nga̱ nuguanꞌ gutaꞌ ni̱ca yyá re̱ꞌ rian Señor mánj.” Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Sani̱ ataj snanꞌanj manꞌānj gu̱nun a ni é reꞌ sisi̱ si̱ gutaꞌ ni̱ca yya á re̱ꞌ mánj. Ni̱ si̱ gutaꞌ ni̱ca yya ni é re̱ꞌ rian xataꞌ si rian nicaj sun Yanꞌanj huin nej mánj. ");
INSERT INTO trq_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ni̱ si̱ gutaꞌ ni̱ca yya á re̱ꞌ rian xungüi̱ mánj. Daj si rian utaꞌ Yanꞌanj daco huin nánj. Ni̱ si̱ gutaꞌ ni̱ca yya ni é re̱ꞌ rian xumanꞌ Jerusalén mánj. Daj si Jerusalén huin rian nicaj sun Yanꞌanj xa̱ngaꞌ huin rey huin achij. ");
INSERT INTO trq_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni̱ si̱ gutaꞌ ni̱ca yya ni é re̱ꞌ rian chra̱ ni manꞌan ni é re̱ꞌ mánj. Daj si si̱ gaꞌue gui̱ꞌyaj ni é re̱ꞌ si ga̱ ga̱tsi, ni̱ ga̱ maru̱ urin hué chra̱ ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Maan si ga̱taj a ni é re̱ꞌ sisi̱ ga̱ꞌue, asi̱ si̱ gaꞌue mánj. Si̱ gutaꞌ ni é re̱ꞌ ango nuguanꞌ ga̱ꞌmi a ni é re̱ꞌ chra̱ nuguanꞌ da mánj. Daj si nuguanꞌ utaꞌ ni é re̱ꞌ ga̱ꞌmi ni é re̱ꞌ huin ꞌngo̱ nuguanꞌ xi̱ꞌi aj. ");
INSERT INTO trq_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Hua gunun a ni é re̱ꞌ sisi̱ gataj ni sij asi̱j ná: “Sisi̱ gue̱reꞌ rundij rián re̱ꞌ, gui̱ꞌyaj dugüíꞌ re̱ꞌ, ngaa ni̱ ga̱ꞌue gui̱ri re̱ꞌ rundij rian tsínj guiꞌyaj daj. Ni̱ sisi̱ güéj ꞌngo̱ yánꞌ re̱ꞌ, gui̱ꞌyaj dugüíꞌ re̱ꞌ, ngaa ni̱ ga̱ꞌue du̱güéj re̱ꞌ yanꞌ tsínj guiꞌyaj da aj.” Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Sani̱ ataj snanꞌanj manꞌānj gu̱nun a ni é re̱ꞌ: “Ga̱ꞌninꞌ ruhua a ni é re̱ꞌ nga̱ ꞌngo̱ tsínj chranꞌ yunꞌunj a ni é re̱ꞌ. Ni̱ sisi̱ ga̱ꞌuiꞌ ꞌngo̱ tsínj daj xiꞌníj rián re̱ꞌ ne̱ꞌ chrej sa̱ꞌ re̱ꞌ, ngaa ni̱ ga̱ꞌninꞌ ruhuá re̱ꞌ sisi̱ ga̱ꞌuiꞌ sij anéj re̱ꞌ nej.” Daj atā gu̱nun a ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ni̱ sisi̱ huin ruhua ꞌngo̱ tsínj daj gu̱nunꞌ nga̱ re̱ꞌ ga̱ꞌne sij si-gató re̱ꞌ, ngaa ni̱ ga̱ꞌninꞌ ruhuá re̱ꞌ sisi̱ ga̱ꞌne sij si-retó re̱ꞌ nej aj. ");
INSERT INTO trq_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ni̱ sisi̱ ga̱ꞌninꞌ ꞌngo̱ tsínj daj sun sisi̱ ga̱ta re̱ꞌ siꞌyaj sij gui̱nicaj re̱ꞌ ꞌngo̱ kilómetro, sani̱ güi̱j ni̱caj re̱ꞌ da hui̱j kilómetro aj. ");
INSERT INTO trq_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ni̱ ga̱ꞌuiꞌ re̱ꞌ rian go̱ꞌngo ni ngüi̱ achínj ꞌngo̱ rasu̱n rián re̱ꞌ. Ni̱ ga̱ꞌuiꞌ xiquínj re̱ꞌ rian go̱ꞌngo ni ngüi̱ achínj xiquínj rián re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ni̱ hué daj gunun a ni é re̱ꞌ sisi̱ gataj ni sij asi̱j ná: “Ga̱huin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ ni ngüi̱ nicaj dugüiꞌ nga̱ re̱ꞌ. Sani̱ si̱ gahuin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ ni ngüi̱ ununꞌ nga̱ re̱ꞌ mánj.” Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Sani̱ ataj snanꞌanj manꞌānj gu̱nun a ni é re̱ꞌ: “Ga̱huin ꞌi̱ ruhua ni é re̱ꞌ ni̱ꞌyaj ni é re̱ꞌ ni ngüi̱ ununꞌ nga̱ ni é re̱ꞌ. Ni̱ ga̱ꞌmi ꞌueé ni é re̱ꞌ rian ni tsínj aꞌmi quij rian ni é re̱ꞌ. Ni̱ gui̱ꞌyaj sa̱ꞌ ni é re̱ꞌ rian ni tsínj nun huin xa̱nꞌ ruhua niꞌyaj ni é re̱ꞌ. Ni̱ ga̱chinj jniꞌyaj ni é re̱ꞌ rian Yanꞌanj xiꞌí ni ngüi̱ aꞌmi quij rian án reꞌ aj.” Daj atā gunun a ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ngaa ni̱ ga̱huin ni é re̱ꞌ daꞌníj chrej ni é re̱ꞌ nne xataꞌ. Daj si hué manꞌan sij ꞌyaj si guixigui̱n güi rian ni ngüi̱ sa̱ꞌ nga̱ rian ni ngüi̱ nitaj si sa̱ꞌ. Ni̱ ꞌyaj manꞌan sij sisi̱ ꞌna̱ꞌ guma̱n rian ni ngüi̱ hua ni̱ca niman nga̱ rian ni ngüi̱ nitaj si hua ni̱ca niman nej. ");
INSERT INTO trq_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ni̱ sisi̱ ꞌi̱ ruhua ni é re̱ꞌ niꞌyaj ni é re̱ꞌ urin ni ngüi̱ ꞌi̱ ruhua niꞌyaj manꞌán re̱ꞌ, ngaa ni̱ si̱ gani ruhuá re̱ꞌ sisi̱ gui̱ꞌyaj sa̱ꞌ Yanꞌanj nga̱ re̱ꞌ mánj. Daj si hué daj ꞌyaj ni tsínj digyaꞌ yunꞌunj huin ni tsínj aꞌnej sanꞌanj güenda gobierno. ");
INSERT INTO trq_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ni̱ sisi̱ ga̱ꞌmi sa̱ꞌ ni é re̱ꞌ rian urin ni jnánj án re̱ꞌ, ni̱ nitaj si ꞌyaj sa̱ꞌ ni é re̱ꞌ daj nga̱ ango ni ngüi̱ mánj. Daj si hué daj ꞌyaj ni tsínj ꞌna̱ꞌ anéj chrej huin ni tsínj nun niꞌi da̱j hua Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ngaa ni̱ ga̱ sa̱ꞌ ni̱nꞌ niman án reꞌ da̱j rúnꞌ hua sa̱ꞌ ni̱nꞌ niman chrej ni é re̱ꞌ nne xataꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Ni du̱gumi a ni é re̱ꞌ manꞌan ni é re̱ꞌ ngaa ꞌyaj sa̱ꞌ ni é re̱ꞌ rian ni ngüi̱. Ni̱ sé daj gui̱ꞌyaj ni é re̱ꞌ xiꞌí si ga̱ni ruhua ni ngüi̱ sisi̱ sa̱ꞌ ni é re̱ꞌ mánj. Daj si sisi̱ hué daj gui̱ꞌyaj a ni é re̱ꞌ, ngaa ni̱ si̱ guiꞌyaj sa̱ꞌ Yanꞌanj nne xataꞌ rian ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Hué dan ni̱ ngaa huin ruhuá re̱ꞌ ga̱ꞌuiꞌ re̱ꞌ sanꞌanj rian ni ngüi̱ yaco ranꞌ, ni̱ si̱ guiꞌyaj nne̱ re̱ꞌ rian ni ngüi̱ mánj. Daj si hué daj ꞌyaj ni tsínj nne̱ sisi̱ ga̱ꞌmi sa̱ꞌ ni ngüi̱ xiꞌí ni sij, ruhua ni sij. Ni̱ hué daj ꞌyaj nne̱ ni sij chruhua nuhui nga̱ cayu nej. Xa̱ngaꞌ atā gu̱nun ni é re̱ꞌ sisi̱ ngaa ꞌyaj nne̱ ni sij rian ni ngüi̱, ni̱ hua ganacaj ni sij si-premio ni sij. Ni̱ a̱ ꞌngo̱ rin xicoꞌ si̱ naruꞌue Yanꞌanj rian ni sij mánj. ");
INSERT INTO trq_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Sani̱ ngaa chra̱cuij re̱ꞌ rian ni ngüi̱ yaco ranꞌ, ni̱ si̱ xacaj cuenta ne̱ꞌ chrej raꞌa rotsi̱ re̱ꞌ si ꞌyaj raꞌa sa̱ꞌ re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ngaa ni̱ chra̱quij hui̱ re̱ꞌ ngaa ga̱ꞌuiꞌ re̱ꞌ rian ni ngüi̱ yaco ranꞌ. Ngaa ni̱ gui̱ꞌyaj ꞌueé chréj re̱ꞌ nne xataꞌ nga̱ re̱ꞌ gui̱niꞌi daranꞌ ni ngüi̱ si niꞌi Yanꞌanj si ꞌyaj hui̱ re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Ni ngaa ga̱chinj jniꞌyaj a ni é re̱ꞌ rian Yanꞌanj, ni̱ si̱ guiꞌyaj á re̱ꞌ da̱j rúnꞌ ꞌyaj ni tsínj nne̱ mánj. Daj si aranꞌ ruhua ni sij gui̱niquinꞌ ni sij chruhua nuhui nga̱ cayu ga̱chinj jniꞌyaj ni sij sisi̱ gui̱niꞌi ni ngüi̱, ruhua ni sij. Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ nga̱ si ꞌyaj ni sij daj, ni̱ hua ganacaj ni sij si-premio ni sij. ");
INSERT INTO trq_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Sani̱ ngaa ga̱chinj jniꞌyaj manꞌán re̱ꞌ rian Yanꞌanj, ni̱ na̱tu urín re̱ꞌ chruhua ducuá re̱ꞌ. Ni̱ na̱ranj re̱ꞌ rian hueꞌ. Ngaa ni̱ ga̱chinj jniꞌyáj re̱ꞌ rian chréj re̱ꞌ nne yuꞌuj daj nga̱ re̱ꞌ huin Yanꞌanj. Ngaa ni̱ gui̱ꞌyaj ꞌueé chréj re̱ꞌ nga̱ re̱ꞌ si niꞌi-ínꞌ si ꞌyaj hui̱ re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ni̱ ngaa ga̱chinj jniꞌyaj a ni é re̱ꞌ rian Yanꞌanj, ni̱ si̱ nacáj re̱ꞌ raruhua ga̱ꞌmi re̱ꞌ nuguanꞌ nitaj si níꞌyanj da̱j rúnꞌ ꞌyaj ni ngüi̱ nicoꞌ ango yanꞌanj mánj. Daj si ani ruhua ni sij sisi̱ unun danꞌanj ni sij xiꞌí si aꞌmi xa̱can ni sij. ");
INSERT INTO trq_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ni̱ si̱ guiꞌyaj a ni é re̱ꞌ da̱j rúnꞌ ꞌyaj ni ngüi̱ da mánj. Daj si asi̱j achin ga̱chinj jniꞌyaj ni é re̱ꞌ rian chrej ni é re̱ꞌ huin Yanꞌanj, ni̱ hua niꞌi sij si achin rian ni é re̱ꞌ nánj. ");
INSERT INTO trq_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","’Ngaa ga̱chinj jniꞌyaj a ni é re̱ꞌ rian Yanꞌanj, ni̱ na̱anj ga̱taj ni é re̱ꞌ gu̱nun Yanꞌanj: Tata chréꞌ nne xataꞌ, huin ruhua únj si ga̱ꞌmi ꞌueé ni ngüi̱ si-xugüi manꞌán re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ni̱ huin ruhua únj sisi̱ ga̱ꞌnaꞌ re̱ꞌ gui̱nicaj re̱ꞌ sun rian xungüi̱ nan anj. Ni̱ da̱j rúnꞌ dagahuin sa̱ꞌ ni si mán xataꞌ rian manꞌán re̱ꞌ, ni̱ hué daj da̱gahuin sa̱ꞌ ni ngüi̱ mán ni̱caꞌ rian manꞌán re̱ꞌ, ruhua únj. ");
INSERT INTO trq_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ni̱ ri̱qui re̱ꞌ si xa̱ ni únj daꞌ go̱ꞌngo güi. ");
INSERT INTO trq_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ni̱ da̱j rúnꞌ guinicaj únj ꞌngo̱ niman nico rian ni tsínj guiꞌyaj gaquinꞌ rian únj, ni̱ daꞌngaꞌ daj gui̱nicaj re̱ꞌ ꞌngo̱ niman nico rian únj. ");
INSERT INTO trq_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ni̱ si̱ duná re̱ꞌ si di̱gyaꞌ yunꞌunj si quij ni únj mánj. Sani̱ ga̱ꞌni re̱ꞌ si ga̱ ni̱ni únj rian si quij hua daj. Daj si manꞌán re̱ꞌ nicaj daranꞌ sun. Ni̱ nicáj re̱ꞌ daranꞌ fuerza nej. Ni̱ hua ꞌueé ni̱nꞌ nné re̱ꞌ. Ni̱ hué daj ga̱huin re̱ꞌ ni̱ganj ni̱nꞌ, ruhua únj. Amén. Hué daj ga̱ꞌmi a ni é re̱ꞌ ngaa ga̱chinj jniꞌyaj á re̱ꞌ rian Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ni̱ sisi̱ gui̱nicaj a ni é re̱ꞌ ꞌngo̱ niman nico rian si-ga̱quinꞌ ni ngüi̱, ni̱ hué daj gui̱nicaj chrej ni é re̱ꞌ nne xataꞌ ꞌngo̱ niman nico rian si-ga̱quinꞌ ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Sani̱ sisi̱ si̱ gaꞌuej ruhua á re̱ꞌ gui̱nicaj á re̱ꞌ ꞌngo̱ niman nico rian si-ga̱quinꞌ ni ngüi̱, ngaa ni̱ si̱ guinicaj chrej ni é re̱ꞌ niman nico rian xiꞌí si-ga̱quinꞌ ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Ni si̱ guiꞌyaj yaco rian ni é re̱ꞌ ngaa ꞌyaj ni é re̱ꞌ ayuno da̱j rúnꞌ ꞌyaj ni tsínj nne̱ mánj. Xiꞌí si ꞌyaj ni sij daj, ni̱ gui̱niꞌi ni ngüi̱ si ꞌyaj ni sij ayuno, ruhua ni sij aj. Xa̱ngaꞌ atā gu̱nun ún re̱ꞌ sisi̱ nga̱ si ꞌyaj ni sij daj, ni̱ hua ganacaj ni sij si-premio ni sij aj. ");
INSERT INTO trq_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Sani̱ ngaa gui̱ꞌyaj manꞌán re̱ꞌ ayuno, ni̱ ga̱naꞌninꞌ re̱ꞌ rián re̱ꞌ. Ni̱ ga̱ri re̱ꞌ gasiti chra̱ re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ngaa ni̱ si̱ xacaj ni ngüi̱ cuenta si ꞌyáj re̱ꞌ ayuno mánj. Sani̱ urin chréj re̱ꞌ nne yuꞌuj daj nga̱ re̱ꞌ niꞌi nej aj. Ni̱ gui̱ꞌyaj ꞌueé-éꞌ nga̱ re̱ꞌ nánj. ");
INSERT INTO trq_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Ni̱ si̱ nara sa̱ꞌ ni é re̱ꞌ nico rasu̱n chruhua xungüi̱ nan mánj. Daj si xungüi̱ nan, ni̱ xij xucu rasu̱n daj. Ni̱ xa daqui yo gagaꞌ daj nej aj. Ni̱ atuj tsínj tu̱ hueꞌ nej. ");
INSERT INTO trq_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Sani̱ na̱ra sa̱ꞌ ni é re̱ꞌ rasu̱n sa̱ꞌ xataꞌ aj. Daj si yuꞌuj daj, ni̱ nitaj si xij xucu atsij mánj. Ni̱ nitaj si xa daqui yo ni gagaꞌ da mánj. Ni̱ nitaj si atuj tsínj tu̱ hueꞌ da mánj. ");
INSERT INTO trq_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Daj si rian nicaj ni é re̱ꞌ siꞌyaj ni é re̱ꞌ, ni̱ hué yuꞌuj daj na̱ni ruhua ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Rúnꞌ huin ꞌngo̱ yanꞌa̱n xigui̱n huin rundij rian néꞌ. Ni̱ ngaa xigui̱n sa̱ꞌ rundij rian néꞌ, ni̱ niꞌyaj sa̱ꞌ néꞌ. ");
INSERT INTO trq_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Sani̱ sisi̱ nitaj si xigui̱n sa̱ꞌ rundij rian néꞌ, ni̱ si̱ gaꞌue na̱riꞌ néꞌ ꞌngo̱ chrej sa̱ꞌ ga̱nꞌanj néꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Ni̱ a̱ ꞌngo̱ tsínj si̱ gaꞌue da̱gahuin rian hui̱j xuruꞌue mánj. Daj si nun huin xa̱nꞌ ruhua sij niꞌyaj sij ꞌngo̱ xuruꞌue. Ni̱ aranꞌ ruhua sij niꞌyaj sij ango xuruꞌue. Asi̱ gui̱nicaj dugüiꞌ sij nga̱ ꞌngo̱ xuruꞌue, ni̱ nun ga̱ꞌmi sa̱ꞌ sij nga̱ ango xuruꞌue mánj. ");
INSERT INTO trq_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Hué dan ni̱ ataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ si̱ gahuin ruhua á re̱ꞌ xiꞌí da̱j gui̱man án re̱ꞌ xa̱ á re̱ꞌ, ni̱ go̱ꞌo a ni é re̱ꞌ mánj. Ni̱ si̱ gahuin ruhua ni é re̱ꞌ nga̱ atsij gu̱nun nnee̱ cúj ni é re̱ꞌ mánj. Niꞌi ni é re̱ꞌ sisi̱ gahuin ni̱ꞌnaꞌ ni é re̱ꞌ, guiꞌyaj Yanꞌanj. Xiꞌí daj ni̱ huin nucuaj Yanꞌanj ri̱qui si xa̱ á re̱ꞌ nej. Ni̱ huin nucuaj Yanꞌanj ri̱qui si gu̱nun atsij nnee̱ cúj ni é re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","’Ni̱ꞌyaj ni é re̱ꞌ ni xataj mán xataꞌ. Nitaj si unu̱n xuj nnaa̱ nej mánj. Ni̱ nitaj si ri xuj nnaa̱ nej mánj. Ni̱ nitaj si nara sa̱ꞌ xuj chruhua guru̱ nej mánj. Sani̱ aꞌuiꞌ chrej ni é re̱ꞌ nne xataꞌ xa xuj. Ni̱ níꞌyanj ni̱nꞌ ruhua ni é re̱ꞌ daj nga̱ si níꞌyanj ni xataj daj. ");
INSERT INTO trq_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ni̱ ga̱ꞌue ga̱huin xa̱can ni é re̱ꞌ doj xiꞌí si ga̱nani nico ruhua ni é re̱ꞌ níꞌ. Si̱ gaꞌue mánj. ");
INSERT INTO trq_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Ni̱ u̱n sin huin ni̱ huin ruhua ni é re̱ꞌ niꞌyaj ni é re̱ꞌ xiꞌí si-ganꞌ ni é re̱ꞌ únj. Ni̱ꞌyaj ni é re̱ꞌ da̱j achij ꞌngo̱ yaj lirio riqui quij. Nitaj si ꞌyaj sun yaj da mánj. Ni̱ nitaj si huaꞌa yaj da yuꞌuej mánj. ");
INSERT INTO trq_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Sani̱ atā gu̱nun ni é re̱ꞌ sisi̱ hua nia̱ꞌ ni̱nꞌ ruhua yaj daj daj nga̱ si hua nia̱ꞌ rey Salomón ngaa gunu̱n sij ꞌngo̱ atsij sa̱ꞌ ni̱nꞌ ruhua. ");
INSERT INTO trq_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ni̱ dugumi Yanꞌanj nga̱ coj ma̱n riqui quij. Ni̱ yya̱j ni̱ ma̱n coj daj. Sani̱ aꞌyoj ni̱ ga̱ri yanꞌa̱n ni sij coj daj. Ni̱ sisi̱ hué daj riqui Yanꞌanj si-ganꞌ coj daj, ngaa ni̱ huaj ni̱nꞌ ruhua ri̱qui Yanꞌanj doj si-ganꞌ ni é re̱ꞌ huin ni é re̱ꞌ ni ngüi̱ xuman do̱j ruhua niꞌyaj Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","’Hué dan ni̱ si̱ gahuin ruhua ni é re̱ꞌ mánj. Ni̱ si̱ gataj ni é re̱ꞌ: “Ni̱ u̱n sin huin xo̱ꞌ. Ni̱ u̱n sin huin go̱ꞌoꞌ. Ni̱ u̱n atsij gu̱nunꞌ únj.” Sé si ga̱huin ruhua ni é re̱ꞌ nga̱ da mánj. ");
INSERT INTO trq_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Daj si ni tsínj nicoꞌ ango yanꞌanj nanoꞌ ni rasu̱n daj. Sani̱ niꞌi chrej ni é re̱ꞌ nne xataꞌ sisi̱ níꞌyanj ni é re̱ꞌ ni rasu̱n daj. ");
INSERT INTO trq_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hué dan ni̱ ga̱nahuij sini ruhua ni é re̱ꞌ nga̱ xiꞌí si nicaj sun Yanꞌanj rian ni é re̱ꞌ. Ni̱ hué daj ga̱nahuij ruhua ni é re̱ꞌ nga̱ si gui̱ꞌyaj ni̱ca ni é re̱ꞌ da̱j rúnꞌ aranꞌ ruhua Yanꞌanj anj. Ngaa ni̱ ga̱nahuin raꞌa ni é re̱ꞌ daranꞌ ni rasu̱n daj, gui̱ꞌyaj Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hué dan ni̱ si̱ gahuin ruhua ni é re̱ꞌ nga̱ si gui̱ranꞌ ni é re̱ꞌ aꞌyoj. Daj si aꞌyoj, ni̱ ga̱ꞌue ga̱ni ruhua ni é re̱ꞌ xiꞌí aꞌyoj. Da go̱ꞌngo güi, ni̱ hua si gui̱ranꞌ ni é re̱ꞌ xiꞌí daꞌ go̱ꞌngo güi daj. ");
INSERT INTO trq_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Si̱ gaꞌuiꞌ ni é re̱ꞌ gaquinꞌ dugüiꞌ ni é re̱ꞌ mánj. Ngaa ni̱ si̱ gaꞌuiꞌ Yanꞌanj gaquinꞌ ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Daj si da̱j rúnꞌ aꞌuiꞌ ni é re̱ꞌ gaquinꞌ dugüiꞌ ni é re̱ꞌ, ni̱ hué daj gui̱ꞌyaj Yanꞌanj nga̱ ni é re̱ꞌ aj. Ni̱ da̱j rúnꞌ ꞌyaj ni é re̱ꞌ nga̱ ni ngüi̱, ni̱ hué daj gui̱ꞌyaj Yanꞌanj nga̱ ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ni̱ u̱n sin huin ni̱ niꞌyaj ni é re̱ꞌ sisi̱ nu̱n daru̱ chrun rundij rian jnánj re̱ꞌ únj. Sani̱ nitaj si niꞌyáj re̱ꞌ si nu̱n ꞌngo̱ caj rundij rian manꞌán re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ni̱ da̱j ga̱ꞌue ga̱taj re̱ꞌ gu̱nun jnánj re̱ꞌ saj: “Gui̱niquinꞌ acuánꞌ re̱ꞌ, ni̱ gui̱rīj daru̱ chrun nu̱n rundij rián re̱ꞌ aj.” Sé daj ga̱taj re̱ꞌ sa mánj. Daj si nu̱n ꞌngo̱ caj rian manꞌán re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tsínj digyaꞌ yunꞌunj huín re̱ꞌ. Gui̱ri siní re̱ꞌ caj nu̱n rián re̱ꞌ aj. Ngaa ni̱ ga̱ꞌue gui̱niꞌyaj sa̱ꞌ re̱ꞌ gui̱ri re̱ꞌ daru̱ chrun nu̱n rundij rian jnánj re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Si̱ gaꞌuiꞌ ni é re̱ꞌ ꞌngo̱ rasu̱n ꞌna̱ꞌ rian Yanꞌanj rian ni tsínj quij hua mánj. Daj si rúnꞌ huin xuhue huin ni sij. Ni̱ si̱ gaꞌuiꞌ ni é re̱ꞌ ꞌngo̱ yej sa̱ꞌ gu̱ꞌnaj perla rian ni tsínj quij hua mánj. Daj si rúnꞌ ꞌyaj xacáj ꞌyaj ni sij. Ni̱ si ruhuaj ni̱ gu̱run dacój xuj. Ni̱ na̱nicaj xuj xa̱ xuj ni é re̱ꞌ. Ni̱ da̱j rúnꞌ ꞌyaj xucu daj daꞌngaꞌ daj ꞌyaj ni tsínj quij hua aj. ");
INSERT INTO trq_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Ga̱chinj ni é re̱ꞌ si achin rian án re̱ꞌ rian Yanꞌanj anj. Ni̱ ri̱qui Yanꞌanj rian ni é re̱ꞌ. Ni̱ na̱noꞌ ni é re̱ꞌ nuguanꞌ sa̱ꞌ. Ni̱ gui̱riꞌ ni é re̱ꞌ nej. Gui̱ꞌyaj ni é re̱ꞌ da̱j rúnꞌ ꞌyaj ꞌngo̱ tsínj ita raꞌa rian hueꞌ nga̱ Yanꞌanj, ngaa ni̱ na̱ꞌni Yanꞌanj rian hueꞌ ga̱tu ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Daj si daranꞌ ni ngüi̱ achínj rian Yanꞌanj, ni̱ na̱huin raꞌa ni sij nga̱ si achínj ni sij aj. Ni̱ ni ngüi̱ nanoꞌ, ni̱ na̱riꞌ ni sij. Ni̱ ni ngüi̱ ita raꞌa rian hueꞌ, ni̱ na̱ꞌni Yanꞌanj ga̱tu ni sij. ");
INSERT INTO trq_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ni̱ sisi̱ hua ꞌngo̱ ni é re̱ꞌ hua daꞌníj, ni̱ ga̱ꞌue ga̱ꞌuiꞌ ni é re̱ꞌ yej raꞌa ngaa achin chrachrúnj xa̱j níꞌ. Sé daj huin mánj. ");
INSERT INTO trq_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ni̱ ga̱ꞌue ga̱ꞌuiꞌ ni é re̱ꞌ ꞌngo̱ xucuáj raꞌa ngaa achin xucuaj níꞌ. Sé daj huin mánj. ");
INSERT INTO trq_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ni̱ sé si sa̱ꞌ niman ni é re̱ꞌ, sani̱ niꞌi ni é re̱ꞌ ni rasu̱n sa̱ꞌ ga̱ꞌuiꞌ ni é re̱ꞌ rian ni daꞌníj ni é re̱ꞌ aj. Hué dan ni̱ huaj ni̱nꞌ ruhua si ri̱qui chrej ni é re̱ꞌ nne xataꞌ nuguanꞌ sa̱ꞌ rian ni ngüi̱ achínj rian Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ngaa ni̱ da̱j rúnꞌ huin ruhua ni é re̱ꞌ gui̱ꞌyaj sa̱ꞌ ni ngüi̱ nga̱ ni é re̱ꞌ ni̱ daꞌngaꞌ daj gui̱ꞌyaj sa̱ꞌ ni é re̱ꞌ nga̱ ni sij. Daj si hué nan huin si ruhuaj gata si-ley Yanꞌanj nga̱ ni nuguanꞌ gataj ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná aj. ");
INSERT INTO trq_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Ga̱tu ni é re̱ꞌ rian hueꞌ chruj rian nne Yanꞌanj anj. Daj si garaꞌ rian hueꞌ atuj ni ngüi̱ ga̱ niꞌya. Ni̱ ganꞌa̱n chrej garaꞌ daj huin rian ga̱nꞌanj ga̱ niꞌya ni̱ganj ni sij aj. Ni̱ hua nico ni ngüi̱ huaj rian chrej garaꞌ daj. ");
INSERT INTO trq_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Sani̱ chruj rian hueꞌ atuj ni ngüi̱ ga̱ne ni̱ganj. Ni̱ chruj chrej huaj ni sij. Ni̱ do̱j ni ngüi̱ nariꞌ chrej chruj da aj. ");
INSERT INTO trq_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Ga̱ cuidado ni é re̱ꞌ nga̱ ni tsínj ataj sisi̱ aꞌmi ni sij si-nu̱guanꞌ Yanꞌanj. Sani̱ sé si xa̱ngaꞌ ni sij mánj. Daj si ꞌna̱ꞌ ni sij rian ni é re̱ꞌ rúnꞌ huin xachij huin ni sij nánj. Sani̱ ne̱ꞌ chru̱hua niman ni sij huin ni sij ꞌngo̱ xucu huee nánj. ");
INSERT INTO trq_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ni̱ ga̱ꞌue gui̱niꞌi ni é re̱ꞌ sisi̱ tsínj digyaꞌ yunꞌunj huin ni sij nga̱ si ꞌyaj ni sij. Gu̱ta néꞌ uva chra̱ ꞌngo̱ coj tanj níꞌ. Sé daj huin mánj. Ni̱ gu̱ta néꞌ higo chra̱ coj niꞌyo níꞌ. Sé daj huin mánj. ");
INSERT INTO trq_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Daj si daranꞌ chrun sa̱ꞌ, ni̱ ayu chruj sa̱ꞌ chra̱ aj. Sani̱ chrun nitaj hua sa̱ꞌ, ni̱ hué daj ayu chruj nitaj si hua sa̱ꞌ chraj. ");
INSERT INTO trq_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ni̱ chrun sa̱ꞌ si̱ gaꞌue ga̱yu chruj nitaj si hua sa̱ꞌ chraj nej mánj. Ni̱ chrun nitaj si hua sa̱ꞌ, ni̱ si̱ gaꞌue ga̱yu chruj hua sa̱ꞌ chraj nej mánj. ");
INSERT INTO trq_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Daranꞌ chrun naꞌue ga̱yu chruj sa̱ꞌ chra̱, ni̱ ga̱ꞌninꞌ ni sij, ni̱ ga̱ra sij rian yanꞌa̱n ga̱ca manꞌan. ");
INSERT INTO trq_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Hué ducuánj daj ga̱ꞌue gui̱niꞌi ni é re̱ꞌ nga̱ si ꞌyaj ni sij sisi̱ tsínj digyaꞌ yunꞌunj huin ni sij aj. ");
INSERT INTO trq_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Sé daranꞌ ni ngüi̱ ga̱taj gu̱nūnj: Señor, Señor, ga̱tu rian nicaj sun Yanꞌanj xataꞌ mánj. Sani̱ maan si ga̱tu ni ngüi̱ ꞌyaj si aranꞌ ruhua chrē nne xataꞌ nánj. ");
INSERT INTO trq_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ni̱ güi daj, ni̱ ga̱taj nico ni ngüi̱ gu̱nūnj: “Señor, Señor, gaꞌmi únj si-nu̱guanꞌ Yanꞌanj nga̱ si-xugüí re̱ꞌ. Ni̱ si-xugüí re̱ꞌ guiri únj nane̱ xi̱ꞌi niman ni ngüi̱ aj. Ni̱ si-xugüí re̱ꞌ guiꞌyaj únj nico si sa̱ꞌ rian ni ngüi̱ aj.” Daj ga̱ꞌmi ni ngüi̱ daj riānj güi ga̱nahuij xungüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Sani̱ ga̱taj manꞌānj gu̱nun ni sij: “Nitaj a̱man guiniꞌīnj ni é re̱ꞌ mánj. Gu̱xun ni é re̱ꞌ manꞌan án re̱ꞌ riānj anj.” Daj ga̱taj manꞌānj gu̱nun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Ngaa ni̱ da̱j rúnꞌ hua ꞌngo̱ tsínj niꞌi sa̱ꞌ ngaa uneꞌ sij daqui ducuá sij rian huej, ni̱ hué daj hua ꞌngo̱ tsínj unun ni nuguanꞌ nan anj. Ni̱ ráj xina sij si ataj manꞌānj rian sij aj. ");
INSERT INTO trq_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ngaa ni̱ gamanꞌ ꞌngo̱ guma̱n xxi. Ni̱ gara xinéj nnee. Ni̱ gaꞌna̱ꞌ nnee gaꞌuiꞌ rian ducuá sij. Ni̱ gahui nane̱ rian hueꞌ daj. Sani̱ nun gane hueꞌ daj. Daj si gahuin ran daqui hueꞌ daj rian huej. ");
INSERT INTO trq_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Sani̱ sisi̱ hua ꞌngo̱ tsínj unun nuguanꞌ nan, ni̱ nun da̱gahuin sij nuguanꞌ atā nan gu̱nun sij, ni̱ huin sij da̱j rúnꞌ huin ꞌngo̱ tsínj guiꞌyaj ducua rian yoꞌój chru. ");
INSERT INTO trq_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ngaa ni̱ gamanꞌ ꞌngo̱ guma̱n xxi. Ni̱ gara xinéj nnee. Ni̱ gaꞌna̱ꞌ gaꞌuiꞌ rian hueꞌ. Ni̱ gahui nane̱ rian hueꞌ. Ngaa ni̱ gane ducuá sij, ni̱ unyu̱n guereꞌej. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ni̱ ngaa guisíj nahuij gaꞌmi Jesús, ni̱ gahuin yanꞌanj ruhua daranꞌ ni ngüi̱ nga̱ nuguanꞌ gataj sij. Daj si sa̱ꞌ ni̱nꞌ ruhua digyán Jesús rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ni̱ nicaj sun nuguanꞌ digyán sij rian ni ngüi̱ daj. Ni̱ sé si digyán sij da̱j rúnꞌ digyán ni tsínj digyán si-ley Moisés rian ni ngüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ni̱ ngaa nanij Jesús chra̱ quij daj, ni̱ nicoꞌ nico ni ngüi̱ gaꞌna̱ꞌ nga̱ sij. ");
INSERT INTO trq_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ngaa ni̱ gahuin ni̱chrunꞌ ꞌngo̱ tsínj guiranꞌ xiꞌi̱ lepra. Ni̱ ganiqui̱nꞌ ráj da̱coj sij rian Jesús. Ni̱ gataj sij: ―Señor, sisi̱ ruhuá re̱ꞌ, ni̱ ga̱ꞌue gui̱ꞌyaj gonoꞌó re̱ꞌ yūnj, ni̱ xi̱ꞌne xiꞌi̱ aꞌnānj. ―Gataj tsínj aꞌnanꞌ daj rian Jesús. ");
INSERT INTO trq_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ngaa ni̱ gutaꞌ Jesús raꞌa sij, ni̱ gataj sij: ―Huin ruhuāj sisi̱ ga̱ sa̱ꞌ nnee̱ cúj re̱ꞌ. ―Daj gataj Jesús. Ngaa ni̱ ꞌngo̱ hora xiꞌnej xiꞌi̱ aꞌnanꞌ tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ngaa ni̱ gataj Jesús: ―Ga̱ cuidadó re̱ꞌ nga̱ manꞌán re̱ꞌ. Si̱ ganatáꞌ re̱ꞌ rian ni̱ a̱ ꞌngo̱ ni ngüi̱ mánj. Maan si ga̱nꞌanj re̱ꞌ di̱gyán re̱ꞌ manꞌán re̱ꞌ rian chrej. Ni̱ ni̱caj re̱ꞌ ꞌngo̱ ofrenda ga̱ꞌuiꞌ re̱ꞌ rian Yanꞌanj da̱j rúnꞌ gaꞌninꞌ Moisés sun güenda ga̱huin-ínꞌ ꞌngo̱ daꞌngaꞌ sisi̱ hua ganahuín re̱ꞌ. Ngaa ni̱ xa̱caj ni chrej cuenta sisi̱ hua ganahuín re̱ꞌ, guiꞌyaj manꞌānj. ―Daj gataj Jesús gunun tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ni̱ ngaa gatúj Jesús xumanꞌ Capernaum, ni̱ gaꞌna̱ꞌ ꞌngo̱ snado centurión rian Jesús. Ni̱ gaꞌmi yaco sij rian Jesús. ");
INSERT INTO trq_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ni̱ gataj sij: ―Señor, ngaj si-mosūj aꞌnanꞌ sij ducuāj. Ni̱ naꞌue gui̱siquiꞌ sij. Ni̱ aꞌngaj ni̱nꞌ ruhua sij. ―Daj gataj snado daj. ");
INSERT INTO trq_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ngaa ni̱ gataj Jesús: ―Gu̱chīj ni̱ ga̱nahuin sij, gui̱ꞌyā. ―Daj gataj Jesús gunun snado daj. ");
INSERT INTO trq_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ngaa ni̱ gataj snado centurión gunun Jesús: ―Señor, sé tsínj sa̱ꞌ huīnj sisi̱ ga̱tu re̱ꞌ chruhua ducuāj. Maan si ga̱ꞌninꞌ re̱ꞌ sun, ni̱ ga̱nahuin si-mosūj, gui̱ꞌyáj re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Daj si hua tsínj aꞌninꞌ sun riānj. Ni̱ huēj aꞌninꞌ sun rian ni snado nej. Ni̱ ngaa aꞌnī ꞌngo̱ snado ga̱nꞌanj síꞌ, ni̱ huanꞌanj síꞌ. Ni̱ ngaa atā ga̱ꞌnaꞌ ꞌngo̱ síꞌ, ni̱ ꞌna̱ꞌ síꞌ nej. Ni̱ ngaa aꞌnī si-mosūj gui̱ꞌyaj sun síꞌ, ni̱ hué daj gui̱ꞌyaj sun síꞌ nej. ―Daj gataj snado daj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ni̱ ngaa gunun Jesús si gataj tsínj daj, ni̱ ganꞌanj ruhua sij. Ni̱ gataj sij gunun ni tsínj nicoꞌ sij: ―Xa̱ngaꞌ atā gu̱nun ni é re̱ꞌ sisi̱ nun na̱riꞌīj a̱ ꞌngo̱ tsínj israelita xuman ruhua rúnꞌ xuman ruhua tsínj snado nan mánj. ");
INSERT INTO trq_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ni̱ atā gu̱nun ni é re̱ꞌ sisi̱ ga̱ꞌnaꞌ nico ni ngüi̱ ꞌna̱ꞌ ne̱ꞌ rian síj güi nga̱ rian atúj güi. Ni̱ ga̱ne ni sij nga̱ tsínj gu̱ꞌnaj Abraham nga̱ Isaac nga̱ Jacob rian nicaj sun Yanꞌanj xataꞌ. ");
INSERT INTO trq_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Sani̱ ni tsínj israelita ni tsínj hua nia̱n ga̱ne rian nicaj sun Yanꞌanj, sani̱ gue̱reꞌej Yanꞌanj ni sij ne̱ꞌ chrej xe̱ꞌ rian hua ru̱miꞌ. Ni̱ yuꞌuj daj ga̱co ni sij, ni̱ xa̱ ruj yanꞌ ni sij xiꞌí sayun gui̱ranꞌ ni sij. Daj si naꞌuej ruhua ni sij gu̱xuman ruhua ni sij ni̱ꞌyaj ni sij manꞌānj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ngaa ni̱ gataj Jesús gunun snado daj: ―Güi̱j na̱nꞌ ducuá re̱ꞌ, ni̱ da̱j rúnꞌ guxuman ruhuá re̱ꞌ niꞌyáj re̱ꞌ manꞌānj, ni̱ daꞌngaꞌ daj ga̱ aj. ―Daj gataj Jesús. Ni̱ hué ꞌngo̱ hora daj, ni̱ ganahuin moso daj. ");
INSERT INTO trq_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ngaa ni̱ gaꞌna̱ꞌ Jesús ducuá Pedro. Ni̱ guiniꞌi sij sisi̱ ngaj niche̱j síꞌ aꞌnanꞌ únꞌ rian nna. Ni̱ nu̱n gachiꞌ únꞌ. ");
INSERT INTO trq_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ni̱ ganun raꞌa Jesús raꞌa únꞌ. Ngaa ni̱ xiꞌnej gachiꞌ únꞌ. Ni̱ nachica únꞌ. Ni̱ guiꞌyaj sun únꞌ rian ni sij. ");
INSERT INTO trq_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ni̱ ngaa guini̱, ni̱ nicaj ni ngüi̱ nico ni dugüiꞌ ni sij nu̱n nane̱ xi̱ꞌi ganꞌanj ni sij rian Jesús. Ni̱ guiri Jesús nane̱ xi̱ꞌi nu̱n niman ni sij nga̱ si-nu̱guanꞌ sij. Ni̱ ganahuin daranꞌ ni ngüi̱ aꞌnanꞌ, guiꞌyaj sij nej. ");
INSERT INTO trq_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ni̱ hué daj gahuin sisi̱ ga̱huin yya da̱j rúnꞌ gataj tsínj gu̱ꞌnaj Isaías huin síꞌ tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. Ni̱ gataj síꞌ: “Gaꞌnej sij si-xi̱ꞌi néꞌ. Ni̱ guiranꞌ sij sayun sisi̱ ga̱nahuin sa̱ꞌ néꞌ xiꞌí ni xiꞌi̱ ranꞌ néꞌ.” Daj gataj Isaías xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ni̱ ngaa guiniꞌi Jesús sisi̱ ma̱n nico ni ngüi̱ ganica̱j xiꞌníj sij, ni̱ gaꞌninꞌ sij sun sisi̱ ga̱chin ni tsínj nicoꞌ sij nga̱ sij anéj chrej duꞌua laguna xxi daj. ");
INSERT INTO trq_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ngaa ni̱ gaꞌna̱ꞌ ꞌngo̱ tsínj digyán si-ley Moisés gaꞌna̱ꞌ sij rian Jesús. Ni̱ gataj síꞌ gunun Jesús: ―Maestro, huin ruhuāj gui̱nicōj manꞌán re̱ꞌ ni̱ a̱ ga̱nꞌanj re̱ꞌ aj. ―Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ngaa ni̱ gataj Jesús gunun síꞌ: ―Hua huej nu̱n xune aj. Ni̱ hua si-ga̱caꞌ xataj chréj xataꞌ nu̱n xúꞌ. Sani̱ nitaj rian gu̱na daꞌníj ni ngüi̱ huīnj mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ngaa ni̱ gataj ango tsínj nicoꞌ Jesús: ―Señor, du̱ná re̱ꞌ sisi̱ ga̱nꞌanj sinīj ga̱chīnj chrē aj. ―Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Sani̱ gataj Jesús gunun sij: ―Gui̱nicoꞌ re̱ꞌ manꞌānj. Ni̱ ga̱ꞌninꞌ ruhuá re̱ꞌ si ga̱chinꞌ ango ni sij níman. Daj si rúnꞌ huin níman huin ni sij. ―Daj gataj Jesús gunun sij. ");
INSERT INTO trq_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ngaa ni̱ gahui Jesús chruhua ꞌngo̱ rio̱ chréj rian nnee. Ni̱ hué daj guiꞌyaj ni tsínj nicoꞌ sij nej. ");
INSERT INTO trq_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Hué dan ni̱ naxu̱man ni̱nꞌ ruhua nnee guiꞌyaj ꞌngo̱ nane̱ nucuaj xxi. Ni̱ gachin nnee rian rio̱ nu̱n ni sij. Sani̱ gatoj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ngaa ni̱ ganꞌanj ni tsínj nicoꞌ Jesús jna̱chi ni sij síꞌ. Ni̱ gataj ni sij: ―Señor, ga̱nacaj re̱ꞌ manꞌan néꞌ. Daj si ruhua ga̱huiꞌ néꞌ. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ngaa ni̱ gataj Jesús: ―Ni̱ u̱n sin huin ni̱ xuꞌuiꞌ ni é re̱ꞌ únj. Do̱j xuman ruhua ni é re̱ꞌ niꞌyaj ni é re̱ꞌ manꞌānj. ―Daj gataj Jesús gunun ni sij. Ngaa ni̱ nachica sij. Ni̱ gaꞌmi huee sij rian nane̱ nga̱ rian nnee daj. Ngaa ni̱ gahuin dinꞌinj ruhua daranꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ngaa ni̱ ganꞌanj ruhua ni tsínj daj niꞌyaj ni sij Jesús. Ni̱ gataj ni sij: ―Ni̱ u̱n tsínj huin tsínj nan, ni̱ daꞌ nane̱ nga̱ nnee dagahuin si-nu̱guanꞌ sij únj. ―Daj gataj ni tsínj nicoꞌ Jesús rian dugüiꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ni̱ guisíj Jesús anéj chrej duꞌua laguna xxi rian huin doꞌój ni tsínj gadareno. Ni̱ gahui hui̱j tsínj nu̱n nane̱ xi̱ꞌi niman scanij rian achinꞌ ni níman gaꞌna̱ꞌ nu̱ngüej sij rian nne Jesús. Ni̱ huee ni̱nꞌ ruhua nu̱ngüej sij. Xiꞌí daj ni̱ naꞌue ga̱chin ni ngüi̱ chrej da mánj. ");
INSERT INTO trq_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ni̱ gaguáj nu̱ngüej sij rian Jesús. Ni̱ gataj nu̱ngüej sij: ―Nitaj si huaj si diguíj re̱ꞌ nga̱ nu̱ngüej únj Jesús huín re̱ꞌ daꞌníj Yanꞌanj xa̱ngaꞌ saj. Gaꞌna̱ꞌ re̱ꞌ nan ngaa achin güi gui̱ꞌyaj Yanꞌanj castigo nu̱ngüej únj. ―Daj gataj nu̱ngüej tsínj daj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ni̱ hua ga̱nꞌ xiꞌí quij mán ꞌngo̱ xiꞌninꞌ xxi ni xacáj xa xuj. ");
INSERT INTO trq_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ngaa ni̱ gaꞌmi yaco ni nane̱ xi̱ꞌi gunun Jesús. Ni̱ gataj ni sij: ―Sisi̱ gui̱ri re̱ꞌ únj niman nu̱ngüej tsínj nan, ni̱ ga̱ꞌnij re̱ꞌ ga̱nꞌanj únj ga̱tu únj niman ni xacáj daj. ―Daj gataj ni nane̱ xi̱ꞌi gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ngaa ni̱: ―Güi̱j ni é re̱ꞌ. ―Daj gataj Jesús. Hué dan ni̱ gahui ni nane̱ xi̱ꞌi daj niman nu̱ngüej tsínj daj. Ni̱ gatúj ni sij niman ni xacáj daj. Ngaa ni̱ ꞌngo̱ ganꞌanj gue̱ xiꞌninꞌ xacáj daj guinij xúꞌ chra̱ ꞌngo̱ huej. Ni̱ guinij ni xuj chruhua laguna daj. Ni̱ gahuiꞌ ni xuj chruhua nnee. ");
INSERT INTO trq_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ngaa ni̱ gunánj ni tsínj dugumi ni xacáj daj na̱nꞌ ni sij xánj ni sij. Ni̱ nataꞌ ni sij daranꞌ si gahuin nga̱ nu̱ngüej tsínj nu̱n nane̱ xi̱ꞌi chruhua niman. ");
INSERT INTO trq_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hué dan ni̱ gahui daranꞌ ni ngüi̱ ma̱n xumanꞌ daj ganꞌanj ni sij rian nne Jesús. Ni̱ ngaa guiniꞌi ni sij Jesús, ni̱ gaꞌmi yaco ni sij rian síꞌ sisi̱ ga̱hui síꞌ xánj ni sij ga̱nꞌanj síꞌ ango yuꞌuj. ");
INSERT INTO trq_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ngaa síj ni̱ gahui Jesús chruhua ꞌngo̱ rio̱. Ni̱ gachin sij anéj chrej duꞌua laguna xa̱chij daj. Ni̱ na̱nꞌ sij xánj sij. ");
INSERT INTO trq_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Hué dan ni̱ nicaj ni sij ꞌngo̱ tsínj nareꞌ dacój rian ꞌngo̱ chrun chréj gaꞌna̱ꞌ ni sij rian Jesús. Ni̱ ngaa guiniꞌi Jesús sisi̱ da̱j guxuman ruhua ni sij niꞌyaj ni sij síꞌ, ni̱ gataj sij rian tsínj aꞌnanꞌ daj: ―Ga̱huin nia̱ꞌ ruhuá re̱ꞌ jna̱nj. Daj si nicā ꞌngo̱ niman nico xiꞌí si-ga̱quinꞌ re̱ꞌ aj. ―Daj gataj Jesús gunun sij. ");
INSERT INTO trq_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ngaa ni̱ gani ruhua do̱j ni tsínj digyán ley niquinꞌ nga̱ Jesús: “Aꞌmi quij tsínj nan rian Yanꞌanj anj.” Hué daj gani ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Sani̱ guiniꞌi Jesús si gani ruhua ni sij. Ni̱ gataj síꞌ: ―Ni̱ u̱n sin huin ni̱ ani quij ruhua ni é re̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Hua hui̱j nuguanꞌ ga̱ꞌue ga̱tā gu̱nun tsínj nan. Asi̱ ga̱ꞌue ga̱tā gu̱nun sij: “Nicā ꞌngo̱ niman nico xiꞌí si-ga̱quinꞌ re̱ꞌ níꞌ.” Asi̱ ga̱ꞌue ga̱tā gu̱nun sij: “Na̱chica re̱ꞌ ga̱che re̱ꞌ sa̱ꞌ.” Ni̱ u̱n go̱ꞌngo nu̱ngüej nuguanꞌ nan cu doj, ruhua á re̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ni̱ huin ruhuāj sisi̱ xa̱caj ni é re̱ꞌ cuenta sisi̱ nicaj sūnj rian xungüi̱ nan huīnj daꞌníj ni ngüi̱. Ni̱ ga̱ꞌue gui̱nicā ꞌngo̱ niman nico xiꞌí si-ga̱quinꞌ ni ngüi̱ aj. ―Daj gataj Jesús gunun ni sij. Ngaa ni̱ gataj sij gunun tsínj nareꞌ dacój daj: ―Atā gu̱nun manꞌán re̱ꞌ sisi̱ na̱chica re̱ꞌ, ni̱ na̱caj re̱ꞌ chrun chréj daj. Ni̱ güi̱j na̱nꞌ ducuá re̱ꞌ nánj. ―Daj gataj Jesús gunun sij. ");
INSERT INTO trq_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ngaa ni̱ nachica tsínj aꞌnanꞌ dacój daj na̱nꞌ sij ducuá sij. ");
INSERT INTO trq_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ni̱ ngaa guiniꞌi ni ngüi̱ si gahuin, ni̱ ganꞌanj ruhua ni sij. Ni̱ gaꞌmi sa̱ꞌ ni sij rian Yanꞌanj. Daj si riqui Yanꞌanj sisi̱ ga̱nahuin ni ngüi̱, gui̱ꞌyaj Jesús huin síꞌ ꞌngo̱ tsínj. ");
INSERT INTO trq_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ni̱ ngaa gahui Jesús yuꞌuj daj, ni̱ guiniꞌi sij ꞌngo̱ tsínj gu̱ꞌnaj Mateo. Ni̱ nne síꞌ rian mesa aꞌnej síꞌ sanꞌanj güenda gobierno. Ngaa ni̱ gataj Jesús gunun síꞌ: ―Gui̱nicoꞌ so̱ꞌ yūnj gu̱nꞌ. ―Daj gataj Jesús. Ngaa ni̱ naxu̱man Mateo nicoꞌ síꞌ Jesús ganꞌanj síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ni̱ ngaa gane Jesús rian mesa chruhua ꞌngo̱ hueꞌ daj, ni̱ guxuman gaꞌi̱ ni tsínj aꞌnej sanꞌanj güenda gobierno nga̱ ni tsínj ꞌyaj gaquinꞌ. Ni̱ gane nu̱guanꞌan ni sij nga̱ Jesús nga̱ ni tsínj nicoꞌ Jesús nej. ");
INSERT INTO trq_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ni̱ ngaa guiniꞌi ni tsínj fariseo, ni̱ nachínj snanꞌanj ni sij ni tsínj nicoꞌ Jesús. Ni̱ gataj ni sij: ―Ni̱ u̱n sin ni̱ xa tsínj digyán rian ni é re̱ꞌ nga̱ ni tsínj aꞌnej sanꞌanj nga̱ ni tsínj ꞌyaj gaquinꞌ únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ni̱ ngaa gunun Jesús si gataj ni sij ni gataj síꞌ: ―Nitaj si níꞌyanj ni ngüi̱ hua sa̱ꞌ nga̱ ꞌngo̱ tsínj ꞌyaj go̱noꞌo mánj. Sani̱ ni ngüi̱ aꞌnanꞌ níꞌyanj ꞌngo̱ tsínj go̱noꞌo aj. ");
INSERT INTO trq_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ngaa ni̱ güi̱j ga̱huin chru̱n ni é re̱ꞌ u̱n sin huin nuguanꞌ nan ruhuaj gata: “Huin ruhuāj sisi̱ ga̱huin ꞌi̱ ruhua ni é re̱ꞌ gui̱niꞌyaj ni é re̱ꞌ ni dugüiꞌ ni é re̱ꞌ. Ni̱ nun huin ruhuāj si ri̱qui ni é re̱ꞌ xucu riānj mánj.” Hué daj gataj rian si-nu̱guanꞌ Yanꞌanj. Daj si sé si ꞌnāj ga̱quīn ni ngüi̱ hua sa̱ꞌ. Sani̱ ꞌnāj ga̱quīn ni ngüi̱ ꞌyaj gaquinꞌ sisi̱ ga̱nani ruhua ni sij xiꞌí si-ga̱quinꞌ ni sij aj. ―Daj gataj Jesús gunun ni tsínj fariseo daj. ");
INSERT INTO trq_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ngaa ni̱ gaꞌna̱ꞌ ni tsínj nicoꞌ Juan rian Jesús. Ni̱ gataj ni sij: ―Ni̱ u̱n sin ꞌyaj ni únj ayuno nga̱ ni tsínj fariseo. Ni̱ ni tsínj nicoꞌ manꞌán re̱ꞌ, ni̱ nitaj si ꞌyaj ni sij ayuno únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ngaa ni̱ gataj Jesús gunun ni sij: ―Da̱j rúnꞌ ꞌyaj ꞌngo̱ tsínj xacaj yunꞌunj xa̱na, daꞌngaꞌ daj ꞌyā. Ni̱ ngaa ga̱huin guiꞌyanj xa̱caj ꞌngo̱ tsínj daj yunꞌunj xa̱na, ni̱ si̱ ga̱ꞌue na̱ni ruhua ni tsínj ganꞌanj guiꞌyanj daj. Sani̱ hua ꞌngo̱ güi ngaa gui̱daꞌa ni tsínj quij tsínj xa̱caj yunꞌunj xa̱na daj. Ngaa ni̱ gui̱ꞌyaj ni tsínj nicoꞌ manꞌānj ayuno aj. ");
INSERT INTO trq_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Si̱ gaꞌue ga̱nara néꞌ ꞌngo̱ atsij na̱ca nga̱ atsij re̱ꞌe mánj. Daj si hué gue̱ atsij na̱ca naraj néꞌ daj, gui̱ꞌyaj sisi̱ tsi̱tsiꞌ atsij re̱ꞌe daj. Ni̱ ga̱nahuin xa̱chij rian naraj néꞌ. ");
INSERT INTO trq_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ni̱ da̱j rúnꞌ hua nnee vino hua si-nu̱guanꞌānj. Ni̱ si̱ gaꞌue ga̱ꞌnij néꞌ nnee vino na̱ca chruhua ꞌngo̱ nnij re̱ꞌe. Daj si tsi̱tsiꞌ nnij daj, gui̱ꞌyaj vino na̱ca daj. Hué dan ni̱ ꞌngo̱ gue̱reꞌ vino nga̱ nnij. Ngaa ni̱ hua nia̱n si ga̱ꞌnij néꞌ vino na̱ca chruhua nnij na̱ca. Ni̱ hué ducuánj daj ga̱ꞌue du̱gumi néꞌ vino daj nga̱ nnij nej. ―Daj gataj Jesús gunun ni tsínj nicoꞌ Juan. ");
INSERT INTO trq_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ni̱ ngaa gaꞌmi Jesús nuguanꞌ daj, ni̱ gaꞌna̱ꞌ ꞌngo̱ tsínj huin achij. Ni̱ ganiquinꞌ ráj da̱coj sij rian Jesús. Ni̱ gataj sij: ―Acuanꞌ gahuiꞌ daꞌni̱ xa̱nāj. Sani̱ ga̱nꞌanj néꞌ gu̱taꞌ re̱ꞌ raꞌá re̱ꞌ rian unj anj. Ngaa ni̱ ga̱ꞌue na̱huin ni̱ꞌnaꞌ unj. ―Daj gataj tsínj daj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ngaa ni̱ naxu̱man Jesús ganꞌanj sij nga̱ ni tsínj nicoꞌ sij nga̱ tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ngaa ni̱ gahuin ni̱chrunꞌ ꞌngo̱ yunꞌunj xa̱na aꞌnanꞌ rucu Jesús si guisíj xu̱huij yoꞌ uráj tun únꞌ. Ni̱ ganun chra̱ raꞌa únꞌ duꞌua si-ganꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Daj si gani ruhua únꞌ: “Urin si ga̱nūn chra̱ raꞌā duꞌua si-ganꞌ síꞌ, ngaa ni̱ na̱huīnj”, ruhua únꞌ. ");
INSERT INTO trq_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Sani̱ nanica̱j Jesús guiniꞌyaj sij rian únꞌ. Ni̱ gataj sij: ―Ga̱huin nia̱ꞌ ruhuá re̱ꞌ xicaꞌuī. Daj si ganahuín re̱ꞌ, guiꞌyaj si guxuman ruhuá re̱ꞌ niꞌyáj re̱ꞌ manꞌānj. ―Daj gataj Jesús gunun únꞌ. Ni̱ ꞌngo̱ hora ganahuin únꞌ. ");
INSERT INTO trq_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ni̱ ngaa gatúj Jesús chruhua ducuá tsínj huin achij daj, ni̱ guiniꞌi sij sisi̱ ma̱n ni tsínj aꞌyanj ria. Ni̱ guiniꞌi sij sisi̱ aguáj aco ni ngüi̱ mán ni sij. ");
INSERT INTO trq_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ngaa ni̱ gataj Jesús gunun ni sij: ―Ga̱hui ni é re̱ꞌ ga̱nꞌanj ni é re̱ꞌ ne̱ꞌ chrej xe̱ꞌ aj. Daj si sé si gahuiꞌ tsinꞌ xa̱na da mánj. Sani̱ si ato nánj. ―Daj gataj Jesús. Ni̱ gaꞌngaꞌ na̱co ni ngüi̱ guiniꞌi ni sij manꞌan Jesús. ");
INSERT INTO trq_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ni̱ ngaa guisíj gahui ni ngüi̱ ne̱ꞌ chrej xe̱ꞌ, guiꞌyaj ni sij, asíj ni̱ gatúj Jesús rian ngaj níman daj. Ni̱ guidaꞌa sij raꞌa únꞌ. Ngaa ni̱ nachica únꞌ. ");
INSERT INTO trq_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ni̱ gaxaꞌni̱ nuguanꞌ daj xiꞌí si guiꞌyaj Jesús ni̱nꞌ ga̱chraꞌ estado daj gunun ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ni̱ ngaa gahui Jesús yuꞌuj daj, ni̱ nicoꞌ hui̱j tsínj duri daj. Ni̱ gaguáj nucuaj nu̱ngüej tsínj daj Jesús aj. Ni̱ gataj nu̱ngüej sij: ―Ga̱nani yaco ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ nu̱ngüej únj huín re̱ꞌ daꞌníj David. ―Daj gataj nu̱ngüej tsínj duri rian Jesús. ");
INSERT INTO trq_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ni̱ ngaa gatúj Jesús chruhua hueꞌ, ni̱ gaꞌna̱ꞌ nu̱ngüej tsínj duri daj rian sij. Ni̱ gataj Jesús: ―Xuman ruhua nu̱ngüej é re̱ꞌ sisi̱ ga̱ꞌue ga̱nahuin nu̱ngüej é re̱ꞌ gui̱ꞌyā níꞌ. ―Daj gataj Jesús. ―Xuman ruhua nu̱ngüej únj, Señor. ―Gataj nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ngaa ni̱ ganun raꞌa Jesús rian nu̱ngüej tsínj duri daj. Ni̱ gataj sij: ―Ga̱ꞌue na̱huin sa̱ꞌ nu̱ngüej é re̱ꞌ da̱j rúnꞌ xuman ruhua nu̱ngüej é re̱ꞌ. ―Daj gataj Jesús gunun nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ngaa ni̱ naxigui̱n rian nu̱ngüej sij. Ni̱ gaꞌninꞌ Jesús nico sun rian nu̱ngüej sij. Ni̱ gataj sij: ―Ga̱ cuidado nu̱ngüej é re̱ꞌ sisi̱ si̱ guiniꞌi ni ngüi̱ si nahuin nu̱ngüej é re̱ꞌ, guiꞌyā. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Sani̱ dyaj guisíj gahui nu̱ngüej sij, ni̱ nataꞌ nu̱ngüej sij rian daranꞌ ni ngüi̱ ma̱n ni xumanꞌ daj si guiꞌyaj Jesús nga̱ nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ni̱ ngaa gahui nu̱ngüej tsínj daj, ni̱ hua ꞌngo̱ ni tsínj nicaj ꞌngo̱ tsínj yaꞌmi gaꞌna̱ꞌ ni sij rian Jesús. Ni̱ nu̱n nane̱ xi̱ꞌi niman síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ni̱ ngaa guiri Jesús nane̱ xi̱ꞌi niman síꞌ, ngaa ni̱ gaꞌue gaꞌmi síꞌ. Ni̱ gahuin yanꞌanj ruhua ni ngüi̱ xiꞌí si guiꞌyaj Jesús. Ni̱ gataj ni sij: ―Nitaj a̱man guiniꞌi ni ngüi̱ israelita ꞌngo̱ nuguanꞌ da̱j rúnꞌ guiꞌyaj Jesús nan mánj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Sani̱ gataj ni tsínj fariseo: ―Ri Jesús nane̱ xi̱ꞌi niman ni ngüi̱ si chraquij sichre huin achij. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ngaa ni̱ gachéj Jesús daranꞌ ni xumanꞌ nga̱ daranꞌ ni rancho. Ni̱ digyán sij nuguanꞌ chruhua si-nuhui ni tsínj israelita. Ni̱ ganataꞌ sij nuguanꞌ sa̱ꞌ xiꞌí si nicaj sun Yanꞌanj. Ni̱ guiꞌyaj sij sisi̱ ga̱nahuin daranꞌ ni ngüi̱ aꞌnanꞌ daranꞌ rian xiꞌi̱. ");
INSERT INTO trq_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ni̱ ngaa guiniꞌi Jesús sisi̱ gaꞌna̱ꞌ nico ni ngüi̱ rian sij, ni̱ nahuin ꞌi̱ ruhua sij niꞌyaj sij ni síꞌ. Daj si da̱j rúnꞌ huin xachij nitaj tsínj dugumi xuj, ni̱ hué daj huin ni sij. Ni̱ guiranꞌ ni sij sayun. Ni̱ nun xugüi ruhua ni sij si gui̱ꞌyaj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ngaa ni̱ gataj Jesús gunun ni tsínj nicoꞌ sij: ―Xa̱ngaꞌ ni̱ da̱j rúnꞌ huin strigo ganaco̱ ngaa guisíj hora ga̱ꞌninꞌ ni sij, daꞌngaꞌ daj huin ni sij. Ni̱ hua nico sun rian néꞌ. Sani̱ do̱j huin ni tsínj aꞌninꞌ strigo daj. ");
INSERT INTO trq_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ngaa ni̱ ga̱chinj jniꞌyaj ni é re̱ꞌ rian Yanꞌanj sisi̱ ga̱ꞌnij Yanꞌanj tsínj ga̱nꞌanj gui̱ꞌyaj sun ga̱ꞌninꞌ strigo daj. Daj si da̱j rúnꞌ huin tsínj do̱ꞌoj huin Yanꞌanj anj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ngaa ni̱ gaquínj Jesús ga̱ꞌnaꞌ ni xu̱huij ni tsínj nicoꞌ sij. Ni̱ gaꞌuiꞌ sij sun rian ni síꞌ sisi̱ gui̱nicaj ni síꞌ sun rian ni nane̱ xi̱ꞌi. Hué dan ni̱ ga̱ꞌue ga̱huin nucuaj ni síꞌ gui̱ri ni síꞌ nane̱ xi̱ꞌi chruhua niman ni ngüi̱. Ni̱ ga̱ꞌue gui̱ꞌyaj ni síꞌ sisi̱ ga̱nahuin ni ngüi̱ aꞌnanꞌ daranꞌ rian xiꞌi̱. ");
INSERT INTO trq_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ni̱ hué nan huin ni si-xugüi ni xu̱huij ni tsínj apóstol guneꞌ Jesús huin ni tsínj nataꞌ rian ni ngüi̱ xiꞌí síꞌ. Ni̱ ꞌngo̱ tsínj daj huin Simón. Ni̱ hué daj gu̱ꞌnaj sij Pedro nej. Ni̱ Andrés huin jnánj sij. Ni̱ ango sij huin Jacobo daꞌníj Zebedeo. Ni̱ jnánj Jacobo huin Juan. ");
INSERT INTO trq_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ni̱ ango sij huin Felipe nga̱ Bartolomé nej, Tomás nej, Mateo tsínj gaꞌnej sanꞌanj güenda gobierno nej, Jacobo daꞌníj Alfeo nej, Tadeo nej, ");
INSERT INTO trq_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón nej, gu̱ꞌnaj síꞌ cananita nej, nga̱ Judas Iscariote huin síꞌ tsínj nagaꞌuiꞌ Jesús rian ni tsínj nicaj sun. ");
INSERT INTO trq_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ngaa ni̱ gaꞌníj Jesús xu̱huij tsínj daj ga̱nꞌanj ni síꞌ. Ni̱ gataj sij gunun ni síꞌ: ―Si̱ ganꞌanj ni é re̱ꞌ ni xánj ni tsínj ꞌna̱ꞌ anéj chrej mánj. Ni̱ si̱ gatuj ni é re̱ꞌ xánj ni tsínj samaritano mánj. ");
INSERT INTO trq_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Sani̱ ga̱nꞌanj sa̱ꞌ ni é re̱ꞌ rian ma̱n ni tsínj israelita. Daj si da̱j rúnꞌ huin xachij ganiꞌya huin ni sij aj. ");
INSERT INTO trq_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ga̱nꞌanj ni é re̱ꞌ, ni̱ na̱taꞌ ni é re̱ꞌ rian ni ngüi̱. Ni̱ ga̱taj ni é re̱ꞌ: “Ruhua gui̱sij güi gui̱nicaj sun Yanꞌanj rian xungüi̱.” Daj ga̱taj á re̱ꞌ rian ni sij. ");
INSERT INTO trq_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ga̱nahuin ni ngüi̱ aꞌnanꞌ, gui̱ꞌyaj ni é re̱ꞌ. Ni̱ ga̱nahuin sa̱ꞌ ni ngüi̱ ranꞌ xiꞌi̱ lepra, gui̱ꞌyaj ni é re̱ꞌ nej. Ni̱ ga̱naꞌnij ni níman, gui̱ꞌyaj ni é re̱ꞌ aj. Ni̱ gui̱ri ni é re̱ꞌ nane̱ xi̱ꞌi niman ni ngüi̱ aj. Ni̱ da̱j rúnꞌ guiꞌyaj Yanꞌanj sinduj rian ni é re̱ꞌ, ni̱ daꞌngaꞌ daj gui̱ꞌyaj ni é re̱ꞌ nga̱ ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Si̱ nicaj ni é re̱ꞌ oro nga̱ plata nej, cobre nej, ga̱nꞌanj ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ni̱ ngaa huaj ni é re̱ꞌ chrej, ni̱ si̱ guinicaj ni é re̱ꞌ nnánj huaj á re̱ꞌ mánj. Maan si gui̱nicaj ni é re̱ꞌ urin atsij ga̱nꞌanj ni é re̱ꞌ. Ni̱ si̱ guinicaj ni é re̱ꞌ canj nga̱ corínj ga̱nꞌanj ni é re̱ꞌ mánj. Daj si hua si chrej ni tsínj ꞌyaj sun sisi̱ xa̱ ni sij aj. ");
INSERT INTO trq_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ni̱ ngaa huaj gui̱sij ni é re̱ꞌ ꞌngo̱ xumanꞌ asi̱ ꞌngo̱ rancho, ni̱ na̱noꞌ ni é re̱ꞌ ducuá ꞌngo̱ tsínj sa̱ꞌ gu̱na ni é re̱ꞌ. Ni̱ hué yuꞌuj da gu̱na ni é re̱ꞌ da gui̱sij güi ga̱nꞌanj ni é re̱ꞌ ango yuꞌuj aj. ");
INSERT INTO trq_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ni̱ ngaa huaj ga̱tu ni é re̱ꞌ chruhua hueꞌ daj, ni̱ ga̱ꞌmi a ni é re̱ꞌ nuguanꞌ sa̱ꞌ rian ni ngüi̱ ma̱n chruhua hueꞌ daj ga̱taj á re̱ꞌ sisi̱ dinꞌinj gui̱man ni sij. ");
INSERT INTO trq_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ni̱ sisi̱ ni ngüi̱ sa̱ꞌ huin ni ngüi̱ nne chruhua hueꞌ daj, ngaa ni̱ ga̱huin dinꞌinj ruhua ni sij da̱j rúnꞌ ga̱taj ni é re̱ꞌ gu̱nun ni sij. Sani̱ sisi̱ sé ni ngüi̱ sa̱ꞌ huin ni sij, ngaa ni̱ si̱ gahuin dinꞌinj ruhua ni sij mánj. Maan si ga̱ꞌninꞌ ruhua ni é re̱ꞌ nga̱ si-nu̱guanꞌ ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ni̱ sisi̱ hua ꞌngo̱ tsínj naꞌuej ruhua na̱huin raꞌa ni é re̱ꞌ, asi̱ naꞌuej ruhua sij gu̱nun sij si-nu̱guanꞌ ni é re̱ꞌ, ngaa ni̱ na̱gunanꞌ ni é re̱ꞌ yoꞌój chru̱ dacój ni é re̱ꞌ ngaa ga̱hui ni é re̱ꞌ chruhua hueꞌ daj, asi̱ xumanꞌ daj. Daꞌngaꞌ daj xa̱caj ni sij cuenta sisi̱ daꞌui ni sij gaquinꞌ xiꞌí si nun gunun ni sij si-nu̱guanꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Xa̱ngaꞌ atā gu̱nun ni é re̱ꞌ sisi̱ güi ga̱nahuij xungüi̱, ni̱ huaj ga̱huin castigo ni tsínj daj si ga̱huin castigo ni tsínj xi̱ꞌi guimán asi̱j ná xumanꞌ Sodoma nga̱ xumanꞌ Gomorra. ");
INSERT INTO trq_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Ni̱ꞌyaj ni é re̱ꞌ. Rúnꞌ huin xachij huin ni é re̱ꞌ aꞌnī ga̱nꞌanj ni é re̱ꞌ da̱ni ni xucu huee. Da̱j rúnꞌ hua yoo̱ xucuáj, ni̱ daꞌngaꞌ daj ga̱ yoo̱ ni é re̱ꞌ. Sani̱ da̱j rúnꞌ ꞌyaj sa̱ꞌ xuꞌman, ni̱ daꞌngaꞌ daj gui̱ꞌyaj sa̱ꞌ ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ni̱ ga̱ cuidado ni é re̱ꞌ nga̱ si gui̱ꞌyaj ni tsínj nga̱ ni é re̱ꞌ. Daj si na̱gaꞌuiꞌ ni sij rian ni tsínj nicaj sun ni é re̱ꞌ. Ni̱ du̱guayun ni sij chruhua nuhui ni é re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ni̱ ga̱nꞌanj ni é re̱ꞌ daꞌ rian ni gobernado nga̱ ni rey gui̱ꞌyaj ni sij xiꞌīj aj. Ngaa ni̱ ga̱huin ni é re̱ꞌ ni tsínj na̱taꞌ xiꞌīj rian ni sij nga̱ ni ngüi̱ ꞌna̱ꞌ anéj chrej aj. ");
INSERT INTO trq_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ni̱ ngaa na̱gaꞌuiꞌ ni sij ni é re̱ꞌ rian ni tsínj nicaj sun, ni̱ si̱ gahuin ruhua ni é re̱ꞌ nga̱ si ga̱ꞌmi ni é re̱ꞌ sisi̱ da̱j ga̱taj ni é re̱ꞌ gu̱nun ni sij mánj. Daj si ngaa ruhua gui̱sij hora ga̱ꞌmi ni é re̱ꞌ, ni̱ Espíritu Santo huin si ri̱qui nuguanꞌ ga̱ꞌmi ni é re̱ꞌ gu̱nun ni tsínj da aj. ");
INSERT INTO trq_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Daj si sé manꞌan ni é re̱ꞌ huin si ga̱ꞌmi mánj. Sani̱ Espíritu Santo gui̱ꞌyaj da ga̱ꞌmi ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Ni̱ na̱gaꞌuiꞌ ꞌngo̱ tsínj daj jnánj sij rian ni tsínj nicaj sun sisi̱ ga̱huiꞌ síꞌ. Ni̱ daꞌngaꞌ daj gui̱ꞌyaj ango sij nga̱ daꞌníj sij nej aj. Ni̱ na̱nicaj ango ni tsínj daj ga̱taj ru̱hua sij gui̱niꞌi sij chrej sij nga̱ nni sij. Ni̱ ga̱huiꞌ ni síꞌ, gui̱ꞌyaj ni sij nej. ");
INSERT INTO trq_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ni̱ si̱ gahuin xa̱nꞌ ruhua ni ngüi̱ gui̱niꞌi ni sij ni é re̱ꞌ xiꞌí si nicoꞌ ni é re̱ꞌ manꞌānj mánj. Sani̱ ni ngüi̱ ga̱ ni̱ca ruhua da ga̱nahuij ni sayun daj, ni̱ hué ni sij ga̱nacaj Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ni̱ sisi̱ gui̱ꞌyaj quij ni tsínj ma̱n ꞌngo̱ xumanꞌ nga̱ ni é re̱ꞌ, ngaa ni̱ gu̱nánj ni é re̱ꞌ ango xumanꞌ ga̱nꞌanj án re̱ꞌ aj. Xa̱ngaꞌ yya atā gu̱nun ni é re̱ꞌ sisi̱ nun gui̱sij ga̱che ni̱nꞌ ni é re̱ꞌ ni xumanꞌ rian ma̱n ni ngüi̱ israelita da ga̱ꞌnāj huīnj daꞌníj ni ngüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Sé si huin rian ꞌngo̱ tsínj ꞌna̱ꞌ ga̱huin chru̱n daj nga̱ tsínj digyán rian sij. Ni̱ sé si huin achij ꞌngo̱ tsínj ꞌyaj sun daj nga̱ si-xuruꞌue sij. ");
INSERT INTO trq_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Hua nia̱n si gui̱ranꞌ tsínj ꞌna̱ꞌ ga̱huin chru̱n da̱j rúnꞌ ranꞌ tsínj digyán rian sij. Ni̱ hua nia̱n si gui̱ranꞌ tsínj ꞌyaj sun da̱j rúnꞌ ranꞌ si-xuruꞌue sij. Ni̱ sisi̱ duguꞌna̱j ni sij sichre Beelzebú manꞌānj, ni̱ daꞌngaꞌ daj ga̱taj ni sij gu̱nun ni tsínj ꞌyaj sun riānj nej. Daj si da̱j rúnꞌ huin tsínj du̱cua, ni̱ daꞌngaꞌ daj huīnj. Ni̱ da̱j rúnꞌ huin ni tsínj nne nu̱guanꞌan nga̱ tsínj du̱cua, ni̱ hué daj huin ni tsínj ꞌyaj sun riānj anj. ");
INSERT INTO trq_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Hué dan ni̱ si̱ guxuꞌuiꞌ a ni é re̱ꞌ rian ni sij mánj. Daj si si̱ gaꞌue ga̱ri hui̱ ni ngüi̱ ꞌngo̱ nuguanꞌ mánj. Sani̱ hua ꞌngo̱ güi ni̱ na̱xiraꞌ daranꞌ nuguanꞌ aríj hui̱ ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ngaa ni̱ nuguanꞌ nan atā gu̱nun a ni é re̱ꞌ rian hua ránj, ni̱ na̱taꞌ á re̱ꞌ rian ni ngüi̱ ne̱ꞌ chrej xe̱ꞌ gu̱nun ni sij. Ni̱ ni nuguanꞌ aꞌmi huīj gunun a ni é re̱ꞌ ni̱ ga̱ꞌmi nucuaj á re̱ꞌ ne̱ꞌ chrej xe̱ꞌ chruhua ducua á re̱ꞌ gu̱nun ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","’Ni̱ si̱ guxuꞌuiꞌ a ni é re̱ꞌ rian ni tsínj ga̱ꞌue da̱gahuiꞌ nnee̱ cúj ni ngüi̱ mánj. Daj ni naꞌue da̱gahuiꞌ ni sij niman ni ngüi̱. Sani̱ gu̱xuꞌuiꞌ a ni é re̱ꞌ rian Yanꞌanj. Daj si ga̱ꞌue gui̱ꞌyaj Yanꞌanj sisi̱ ga̱ niꞌya ni̱ganj niman ni ngüi̱ nga̱ nnee̱ cúj ni sij rian yanꞌa̱n. ");
INSERT INTO trq_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Ni̱ xa̱ngaꞌ nij duꞌue hui̱j xataj le ꞌngo̱ moneda sanꞌanj. Sani̱ sisi̱ si̱ riqui chrej ni é re̱ꞌ nne xataꞌ permiso, ni̱ si̱ guinij ꞌngo̱ xuj daj rian yoꞌój mánj. ");
INSERT INTO trq_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ni̱ hua naya Yanꞌanj daꞌ go̱ꞌngo hué chra̱ á re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Xiꞌí daj ni̱ si̱ guxuꞌuiꞌ ni é re̱ꞌ mánj. Daj si huaj ga níꞌyanj án re̱ꞌ si níꞌyanj ni xataj ga aj. ");
INSERT INTO trq_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Hué dan ni̱ daranꞌ ni ngüi̱ na̱taꞌ sisi̱ nicoꞌ ni sij yūnj rian ni ngüi̱ hué daj ga̱ꞌmi saꞌāj xiꞌí ni sij rian chrē nne xataꞌ. ");
INSERT INTO trq_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Sani̱ daranꞌ ni ngüi̱ naꞌuej ruhua na̱taꞌ rian ni ngüi̱ sisi̱ nicoꞌ ni sij yūnj, ni̱ si̱ gaꞌmi saꞌāj rian xiꞌí ni sij rian chrē nne xataꞌ. ");
INSERT INTO trq_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Si̱ gani ruhua á re̱ꞌ sisi̱ gaꞌnāj chruhua xungüi̱ nan sisi̱ ga̱huin dinꞌinj ruhua ni ngüi̱. Sé daj huin mánj. Sé si gaꞌnāj sisi̱ ga̱huin dinꞌinj ruhua ni sij mánj. Sani̱ gu̱nunꞌ ni sij, ꞌyaj si gaꞌnāj. ");
INSERT INTO trq_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Daj si gaꞌnāj sisi̱ gu̱nunꞌ ꞌngo̱ tsínj daj nga̱ chrej sij. Ni̱ gu̱nunꞌ ꞌngo̱ yunꞌunj xa̱na nga̱ nni unj. Ni gu̱nunꞌ ꞌngo̱ yunꞌunj xa̱na daj nga̱ niche̱j unj. ");
INSERT INTO trq_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ni̱ ni ngüi̱ ma̱n ducuá ꞌngo̱ tsínj daj, ni̱ gu̱nunꞌ ni sij nga̱ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Sisi̱ ꞌi̱ ruhua ꞌngo̱ tsínj daj niꞌyaj sij chrej sij nga̱ nni sij daj nga̱ si ꞌi̱ ruhua sij niꞌyaj sij manꞌānj, ni̱ nun síj sij si gui̱nicaj dugüiꞌ sij nga̱ manꞌānj. Ni̱ sisi̱ hua ꞌngo̱ tsínj ꞌi̱ ruhua niꞌya daꞌni̱ snoꞌo sij nga̱ daꞌni̱ xa̱na sij daj nga̱ si ꞌi̱ ruhua sij niꞌyaj sij manꞌānj, ni̱ nun síj sij si gui̱nicaj dugüiꞌ sij ngāj. ");
INSERT INTO trq_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ni̱ u̱n tsínj naꞌuej ruhua gui̱ranꞌ sayun xiꞌí si nicoꞌ sij manꞌānj, ni̱ nun síj sij gui̱nicaj dugüiꞌ sij ngāj. ");
INSERT INTO trq_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ni̱ u̱n tsínj huin ruhua na̱caj manꞌan, ni̱ ga̱ niꞌya sij. Sani̱ u̱n tsínj ga̱ꞌuej ruhua ga̱huiꞌ xiꞌīj, ni̱ ga̱ ni̱ꞌnaꞌ ni̱ganj sij aj. ");
INSERT INTO trq_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Ni sisi̱ ga̱nahuin raꞌa ni ngüi̱ ni é re̱ꞌ, ni̱ daꞌngaꞌ daj ga̱nahuin raꞌa ni sij manꞌānj. Ni̱ tsínj ga̱nahuin raꞌa manꞌānj, ni̱ ga̱nahuin raꞌa sij tsínj gaꞌníj gaꞌnāj nej. ");
INSERT INTO trq_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ni̱ ngüi̱ ga̱nahuin raꞌa ꞌngo̱ tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj xiꞌí si ꞌna̱ꞌ síꞌ rian Yanꞌanj, ni̱ uyan ga̱nahuin raꞌa ni sij nga̱ tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj daj ngaa na̱ruꞌue Yanꞌanj rian ni ngüi̱. Ni̱ ni ngüi̱ ga̱nahuin raꞌa ꞌngo̱ tsínj sa̱ꞌ xiꞌí si sa̱ꞌ síꞌ, ni̱ uyan ga̱nahuin raꞌa ni sij nga̱ tsínj sa̱ꞌ daj ngaa na̱ruꞌue Yanꞌanj rian ni ngüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ni̱ da̱j hua tsínj ga̱ꞌuiꞌ ꞌngo̱ tasa nnee nuhuij go̱ꞌo ꞌngo̱ tsínj hua lij xiꞌí si nicoꞌ sij manꞌānj, ni̱ xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ gui̱ꞌyaj sa̱ꞌ Yanꞌanj nga̱ sij. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ni̱ ngaa guisíj ganahuij si digyán Jesús rian ni tsínj nicoꞌ sij, ni̱ gahui sij yuꞌuj daj ganꞌanj di̱gyán sij nuguanꞌ sa̱ꞌ rian ni ngüi̱ ma̱n ni xánj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ni̱ nu̱n Juan ducuaga̱ꞌ. Ni̱ ngaa gunun sij si guiꞌyaj Jesús, ni̱ gaꞌníj sij hui̱j tsínj nicoꞌ sij ga̱nꞌanj na̱chinꞌ snanꞌanj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ni̱ gataj nu̱ngüej sij: ―Hué re̱ꞌ huin tsínj ga̱ꞌnaꞌ na̱caj ni ngüi̱ níꞌ. Asi̱ ga̱naꞌuij únj si ga̱ꞌnaꞌ ango tsínj níꞌ. ―Daj gataj nu̱ngüej tsínj daj gunun Jesús, guiꞌyaj Juan. ");
INSERT INTO trq_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ngaa ni̱ gataj Jesús: ―Güi̱j nu̱ngüej é re̱ꞌ. Ni̱ na̱taꞌ nu̱ngüej é re̱ꞌ gu̱nun Juan si gunun nu̱ngüej é re̱ꞌ nga̱ si guiniꞌi nu̱ngüej é re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Daj si xigui̱n niꞌyaj ni tsínj duri. Ni̱ chéj ni tsínj yacuan. Ni̱ nahuin sa̱ꞌ ni ngüi̱ aꞌnanꞌ xiꞌi̱ nnij nej. Ni̱ naxiꞌníj chraquij ni tsínj soꞌo nej. Ni̱ ganáꞌnij ni níman gahuiꞌ nej. Ni̱ unun ni ngüi̱ yaco ranꞌ nuguanꞌ sa̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ni̱ ga̱hui sa̱ꞌ ꞌngo̱ tsínj nitaj si na̱nicaj ruhua ni̱ꞌyaj sij xiꞌīj. ―Daj gataj Jesús gunun nu̱ngüej tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ni̱ ngaa huaj na̱nꞌ nu̱ngüej sij rian Juan, ngaa ni̱ gaxi̱ꞌi Jesús gaꞌmi sa̱ꞌ síꞌ rian ni ngüi̱ xiꞌí Juan. Ni̱ gataj sij: ―Ni ngaa ganꞌanj ni é re̱ꞌ gunun ni é re̱ꞌ si-nu̱guanꞌ Juan quij quiꞌyanj na̱co, ni̱ da̱j hua sij guiniꞌi a ni é re̱ꞌ, ruhua á re̱ꞌ únj. Da̱j rúnꞌ ꞌyaj ria ngaa xinunj ꞌyaj nane̱, ni̱ daꞌngaꞌ daj ꞌyaj sij, ruhua á re̱ꞌ níꞌ. ");
INSERT INTO trq_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ni̱ sisi̱ sé daj ꞌyaj síꞌ, ni̱ u̱n sin huin ni̱ ganꞌanj ni̱ꞌyaj ni é re̱ꞌ rian huaj sij únj. Ganꞌanj ni̱ꞌyaj ni é re̱ꞌ ꞌngo̱ tsínj nu̱n atsij nia̱ꞌ níꞌ. Sani̱ sé daj huin sij mánj. Ni̱ niꞌi ni é re̱ꞌ sisi̱ ni tsínj nu̱n atsij nia̱ꞌ, ni̱ nne ni síꞌ ducuá rey. ");
INSERT INTO trq_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ni̱ u̱n sin huin ni̱ ganꞌanj ni̱ꞌyaj á re̱ꞌ rian nne sij únj. Asi̱ ꞌngo̱ tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj níꞌ. Xa̱ngaꞌ yya ni̱ hué daj huin sij aj. Ni̱ hua achij Juan daj nga̱ daranꞌ ango ni tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","’Ni̱ asi̱j ná ni̱ garun sa̱ꞌ ꞌngo̱ tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj xiꞌí Juan. Ni̱ gataj Yanꞌanj: Aꞌnī ꞌngo̱ tsínj gui̱nicaj nuguanꞌ gu̱chiꞌ sij. Ni̱ tsínj daj gui̱taj dian sini rián re̱ꞌ ga̱nꞌanj sij aj. Ni̱ gui̱ꞌyaj xugüi sij si-chréj re̱ꞌ. Daj gataj Yanꞌanj garun Isaías asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","’Ni̱ xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ scanij ni tsínj gaꞌnga, guiꞌyaj ni yunꞌunj xa̱na, ni̱ nitaj si rugüiꞌ ꞌngo̱ tsínj huin achij da̱j rúnꞌ huin achij manꞌan Juan tsínj duguataꞌ nnee. Sani̱ tsínj hua lij ni̱nꞌ huin achij sij rian nicaj sun Yanꞌanj daj nga̱ manꞌan Juan gaj. ");
INSERT INTO trq_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ni̱ asi̱j ngaa gaꞌna̱ꞌ Juan tsínj duguataꞌ nnee, ni̱ ꞌna̱ꞌ gahuin achij rian nicaj sun Yanꞌanj. Ni̱ hué daj hua da güi acuanꞌ. Ni̱ ni tsínj hua sa̱ꞌ niman, ni̱ huin ruhua ni sij sisi̱ ga̱huin achij Yanꞌanj niman ni sij aj. ");
INSERT INTO trq_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Daj si daranꞌ ni tsínj nataꞌ si-nu̱guanꞌ Yanꞌanj rian ni ngüi̱ asi̱j ná da manꞌan Juan, ni̱ gaꞌmi ni sij xiꞌí güi gui̱nicaj Yanꞌanj sun. Ni̱ daꞌngaꞌ daj aꞌmi si-ley Yanꞌanj nej. ");
INSERT INTO trq_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ni̱ sisi̱ huin ruhua á re̱ꞌ gu̱xuman ruhua á re̱ꞌ nga̱ nuguanꞌ nan, ni̱ Juan huin Elías tsínj ga̱ꞌnaꞌ da̱j rúnꞌ garun ni sij asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ni̱ tsínj nu̱n chraquij, ni̱ gu̱nun sij nuguanꞌ nan anj. ");
INSERT INTO trq_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Ni̱ da̱j u̱n sin huin gui̱ꞌyā gui̱riꞌ di̱gyānj rian án re̱ꞌ da̱j hua ni ngüi̱ mán acuanꞌ nan únj. Da̱j rúnꞌ ꞌyaj ni tsinꞌ ganꞌanj ga̱ne rian yuꞌue̱ ngaa ducuj, ni̱ agua ni dugüiꞌ, ni̱ hué daj huin ni sij. ");
INSERT INTO trq_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ni̱ ataj aninꞌinj: “Gaꞌyanj únj ria̱ rian án re̱ꞌ saj. Sani̱ nun gui̱ranꞌanj án re̱ꞌ mánj. Garaj ni únj chraꞌ stanga saj, ni̱ nun ga̱co a ni é re̱ꞌ mánj.” Hué daj ataj ni tsinꞌ rian ni dugüiꞌ ni tsinꞌ anj. ");
INSERT INTO trq_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Daj si gaꞌna̱ꞌ Juan, ni̱ nun xa̱ sij chrachrúnj, ni̱ nun go̱ꞌo sij nnee vino mánj. Sani̱ ataj ni ngüi̱ sisi̱ nu̱n nane̱ xi̱ꞌi niman sij aj. ");
INSERT INTO trq_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Asíj ni̱ gaꞌna̱ꞌ daꞌníj ni ngüi̱ huin manꞌānj. Ni̱ xāj, ni̱ goꞌōj aj. Ni̱ ataj ni ngüi̱ sisi̱ huīnj ꞌngo̱ tsínj xa na̱saꞌ goꞌo na̱saꞌ. Ni̱ huīnj ꞌngo̱ tsínj nicaj dugüiꞌ nga̱ ni ngüi̱ ꞌyaj gaquinꞌ nga̱ ni tsínj aꞌnej sanꞌanj, ataj ni sij xiꞌīj aj. Ni̱ sisi̱ xa̱caj ni ngüi̱ cuenta daj ꞌyaj nu̱ngüej únj Juan, ni̱ ga̱huin yya ruhua ni sij sisi̱ chru̱n nu̱ngüej únj. ");
INSERT INTO trq_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ngaa ni̱ gaxi̱ꞌi Jesús nataꞌ sij xiꞌí si-ga̱quinꞌ ni tsínj ma̱n ni xumanꞌ daj rian guiꞌyaj sij nico si sa̱ꞌ nga̱ si-fuerza sij. Ni̱ hué daj gaꞌmi sij xiꞌí si nun na̱nicaj ruhua ni síꞌ xiꞌí si-ga̱quinꞌ ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ni̱ gataj Jesús: ―Niqui ni̱nꞌ ruhua niman án re̱ꞌ huin ín re̱ꞌ ni tsínj ma̱n xumanꞌ Corazín nga̱ xumanꞌ Betsaida. Ni̱ nun guiꞌyā si sa̱ꞌ ꞌna̱ꞌ rian Yanꞌanj nga̱ si-fuerzāj xumanꞌ Tiro nga̱ xumanꞌ Sidón rúnꞌ guiꞌyā si sa̱ꞌ xumanꞌ Corazín nga̱ xumanꞌ Betsaida. Sani̱ sisi̱ hué daj guiꞌyā, ni̱ hua ganani ruhua ni tsínj ma̱n Tiro nga̱ Sidón xiꞌí si-ga̱quinꞌ ni sij asi̱j ná. Ni̱ hua gunu̱n ni sij atsij dachrinj digyán ni sij sisi̱ hua yya nanica̱j ruhua ni sij xiꞌí si-ga̱quinꞌ ni sij. Ni̱ hua gara ni sij yaj chra̱ ni sij aj. ");
INSERT INTO trq_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Sani̱ atā gu̱nun ún re̱ꞌ sisi̱ ngaa gui̱sij na̱guiꞌyaj Yanꞌanj nga̱ si-ga̱quinꞌ ni ngüi̱, ni̱ gui̱ranꞌ nico ni tsínj ma̱n xumanꞌ Corazín nga̱ xumanꞌ Betsaida castigo daj nga̱ si gui̱ranꞌ ni tsínj ma̱n xumanꞌ Tiro nga̱ xumanꞌ Sidón. ");
INSERT INTO trq_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","’Ni̱ atā gu̱nun ún re̱ꞌ huin ín re̱ꞌ ni tsínj ma̱n xumanꞌ Capernaum sisi̱ nne̱ ni̱nꞌ ruhua á re̱ꞌ. Xiꞌí daj ani ruhua á re̱ꞌ sisi̱ hua ꞌueé ni̱nꞌ ruhua xánj án re̱ꞌ rúnꞌ hua xataꞌ hua xánj án re̱ꞌ, ruhua á re̱ꞌ. Sani̱ ga̱nꞌanj án re̱ꞌ daꞌ daqui ni̱nꞌ ruhua rian hua ru̱miꞌ, gui̱ꞌyaj Yanꞌanj. Daj si sisi̱ nu̱n guiꞌyā si sa̱ꞌ ꞌna̱ꞌ rian Yanꞌanj nga̱ si-fuerzāj xumanꞌ Sodoma da̱j rúnꞌ guiꞌyā xánj án re̱ꞌ, ngaa ni̱ ga gue̱ ngaj xumanꞌ daj aj. ");
INSERT INTO trq_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Sani̱ atā gu̱nun ún re̱ꞌ sisi̱ güi ga̱ꞌnaꞌ na̱guiꞌyaj yya Yanꞌanj nga̱ si-ga̱quinꞌ ni ngüi̱, ni̱ gui̱ranꞌ ni é re̱ꞌ doj castigo rian si gui̱ranꞌ ni tsínj ma̱n xumanꞌ Sodoma. ―Daj gataj Jesús gunun ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ni̱ ngaa daj, ni̱ gataj Jesús gunun Yanꞌanj: ―Aꞌmi saꞌāj rián re̱ꞌ huín re̱ꞌ chrē nne xataꞌ. Ni̱ nicáj re̱ꞌ sun xataꞌ nga̱ rian yoꞌój nej aj. Ni̱ aꞌmi saꞌāj rián re̱ꞌ. Daj si digyán re̱ꞌ nuguanꞌ sa̱ꞌ nan rian ni tsínj nun huin achij. Ni̱ garij hui̱ re̱ꞌ nuguanꞌ nan rian ni tsínj niꞌi nico nga̱ ni tsínj chru̱n sa̱ꞌ ni nuguanꞌ nej. ");
INSERT INTO trq_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Daj si hué daj garanꞌ ruhuá re̱ꞌ si guiꞌyáj re̱ꞌ huín re̱ꞌ chrē aj. ―Daj gataj Jesús gunun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ngaa ni̱ gataj Jesús gunun ni ngüi̱: ―Nariqui chrē daranꞌ ni rasu̱n riānj anj. Ni̱ a̱ ꞌngo̱ ni ngüi̱ nun niꞌi da̱j hua daꞌníj Yanꞌanj mánj. Sani̱ urin chrē niꞌi manꞌānj. Ni̱ a̱ ꞌngo̱ ni ngüi̱ nun niꞌi da̱j hua manꞌan chrē nej mánj. Sani̱ urīnj niꞌi chrē si huēj huin daꞌníj Yanꞌanj anj. Ni̱ u̱n ngüi̱ ga̱ranꞌ ruhuāj di̱gyānj, ni̱ ga̱ꞌue di̱gyānj da̱j hua chrē rian nej. ");
INSERT INTO trq_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","’Ngaa ni̱ ga̱huaꞌ daranꞌ ni é re̱ꞌ ninaj ata ni rasu̱n yaꞌi̱ riānj. Ni̱ gui̱ꞌyā sisi̱ na̱ran ruhua ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ni̱ gui̱nicoꞌ ni é re̱ꞌ manꞌānj anj. Ni̱ ga̱huin chru̱n ni é re̱ꞌ nga̱ nuguanꞌ di̱gyānj rian ni é re̱ꞌ aj. Daj si rúnꞌ hua ꞌngo̱ xucu hua ni̱, ni̱ daꞌngaꞌ daj huāj aj. Ni̱ nitaj si yanꞌanj ruhuāj mánj. Ngaa ni̱ ga̱ꞌue na̱riꞌ ni é re̱ꞌ rian na̱ran ruhua ni é re̱ꞌ nej aj. ");
INSERT INTO trq_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Daj si sé si ꞌi̱ sisi̱ gui̱nicoꞌ ni é re̱ꞌ manꞌānj nej mánj. Ni̱ sé si ꞌi̱ sisi̱ ga̱che ni é re̱ꞌ si-chrē. ―Daj gataj Jesús gunun ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ni̱ ngaa daj ni̱ huaj Jesús da̱ni rian gunun ni sij strigo ꞌngo̱ güi naránj ruhua ni sij. Ni̱ gachin xiꞌna̱ riqui ni tsínj nicoꞌ sij. Ngaa ni̱ gaxi̱ꞌi ni sij rocoj ni sij ca strigo. Ni̱ xa ni sij. ");
INSERT INTO trq_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Sani̱ ngaa guiniꞌi ni tsínj fariseo, ni̱ gataj ni sij gunun Jesús: ―Ni̱ꞌyaj re̱ꞌ si ꞌyaj ni tsínj nicóꞌ re̱ꞌ aj. Daj si naꞌuej si-ley Yanꞌanj sisi̱ daꞌngaꞌ daj gui̱ꞌyaj ni sij güi naránj ruhua néꞌ mánj. ―Daj gataj ni tsínj fariseo gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ngaa ni̱ gataj Jesús: ―Hua gaya ni é re̱ꞌ si guiꞌyaj xíꞌ David níꞌ. Daj si ꞌngo̱ güi gachin xiꞌna̱ riqui ni du̱güiꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ni̱ gatúj sij chruhua ducuá Yanꞌanj. Ni̱ xa sij si-chra̱chrunj Yanꞌanj. Ni̱ naꞌuej si-ley Yanꞌanj sisi̱ xa ni du̱güiꞌ sij chrachrúnj daj. Sani̱ urin ni chrej xa chrachrúnj da aj. ");
INSERT INTO trq_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","’Ni̱ nun ga̱ya ni é re̱ꞌ si-ley Moisés nej míꞌ. Daj si ꞌyaj sun ni chrej chruhua si-nuhui Yanꞌanj güi naránj róꞌ aj. Sani̱ nitaj gaquinꞌ daꞌui ni sij nej mánj. ");
INSERT INTO trq_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ni̱ atā gu̱nun ni é re̱ꞌ sisi̱ nan niquinꞌ ꞌngo̱ tsínj huin achij daj nga̱ nuhui da aj. ");
INSERT INTO trq_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ni̱ gataj si-nu̱guanꞌ Yanꞌanj: “Huin ruhuāj sisi̱ ga̱huin ꞌi̱ ruhua ni é re̱ꞌ ni̱ꞌyaj ni é re̱ꞌ ni ngüi̱. Ni̱ nitaj si huin ruhuāj sisi̱ da̱gahuiꞌ ni é re̱ꞌ xucu riānj mánj.” Daj gataj si-nu̱guanꞌ Yanꞌanj. Ni̱ sisi̱ unun ni é re̱ꞌ u̱n sin huin ruhuaj nuguanꞌ nan gata, ni̱ si̱ gutaꞌ chre ni é re̱ꞌ gaquinꞌ ni ngüi̱ nun guiꞌyaj gaquinꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Daj si nicaj sūnj rian ni güi naránj róꞌ huīnj daꞌníj ni ngüi̱. ―Daj gataj Jesús gunun ni tsínj fariseo. ");
INSERT INTO trq_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ngaa ni̱ gahui Jesús yuꞌuj daj. Ni̱ gatúj sij chruhua si-nuhui ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ni̱ nne ꞌngo̱ tsínj hua na̱co raꞌa daj. Ngaa ni̱ nachínj snanꞌanj ni tsínj fariseo Jesús. Ni̱ gataj ni sij: ―Aꞌuej si-ley Yanꞌanj sisi̱ ga̱nahuin ꞌngo̱ tsínj aꞌnanꞌ, gui̱ꞌyaj néꞌ güi naránj ruhua néꞌ níꞌ. ―Daj gataj ni sij xiꞌí si huin ruhua ni sij ga̱ꞌmi gaquinꞌ ni sij xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ngaa ni̱ gataj Jesús: ―Sisi̱ gui̱nij ꞌngo̱ dan ni é re̱ꞌ xachij chruhua yuꞌuj güi naránj ruhua ni ngüi̱, ni̱ si̱ ganꞌanj gui̱ri ni é re̱ꞌ xuj chruhua yuꞌuj da míꞌ. ");
INSERT INTO trq_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ni̱ ni̱nꞌ ruhua níꞌyanj ꞌngo̱ tsínj daj si níꞌyanj ꞌngo̱ xachij da aj. Hué dan ni̱ sa̱ꞌ huin sisi̱ gui̱ꞌyaj sa̱ꞌ néꞌ güi naránj ruhua ni ngüi̱. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ngaa ni̱ gataj sij gunun tsínj aꞌnanꞌ raꞌa daj: ―Du̱cua re̱ꞌ raꞌá re̱ꞌ aj. ―Daj gataj Jesús. Ni̱ hué daj guiꞌyaj síꞌ, ni̱ ganahuin raꞌa síꞌ da̱j rúnꞌ hua anéj raꞌa síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Sani̱ gahui ni tsínj fariseo. Ni̱ dagaꞌmi dugüiꞌ ni sij da̱j ga̱ꞌue da̱gahuiꞌ ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sani̱ niꞌi Jesús si ani ruhua ni tsínj daj. Ngaa ni̱ gahui sij. Ni̱ ganꞌanj sij yuꞌuj daj. Ni̱ nicoꞌ nico ni ngüi̱ ganꞌanj ni sij. Ni̱ ganahuin daranꞌ ni ngüi̱ aꞌnanꞌ, guiꞌyaj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ni̱ gaꞌninꞌ sij sun sisi̱ si̱ nuna ni sij u̱n tsínj huin sij rian ni ngüi̱ mánj. ");
INSERT INTO trq_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ni̱ hué daj gahuin sisi̱ ga̱huin yya da̱j rúnꞌ garun Isaías asi̱j ná xiꞌí Yanꞌanj. Ni̱ gataj síꞌ: ");
INSERT INTO trq_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nan nne tsínj unánj guitsi riānj anj. Ni̱ hua ganacui manꞌānj sij nej. Ni̱ huin sij tsínj ꞌi̱ ruhuāj. Ni̱ huin nia̱ꞌ ruhuāj nga̱ sij nej. Ni̱ ga̱ꞌuīj Espíritu Santo ga̱ꞌnaꞌ niman sij nej. Ni̱ na̱taꞌ sij rian ni ngüi̱ ꞌna̱ꞌ anéj chrej sisi̱ ꞌueé na̱guiꞌyaj yyāj nga̱ xiꞌí si-ga̱quinꞌ ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ni̱ si̱ gununꞌ sij nga̱ ni ngüi̱ mánj. Ni̱ si̱ gaguáj sij mánj. Ni̱ si̱ gunun ni ngüi̱ si ga̱ꞌmi nucuaj sij chruhua chrej mánj. ");
INSERT INTO trq_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ni̱ si̱ gaquinꞌ sij yoo guyu huin ni tsínj guereꞌ ruhua, guiꞌyaj ni sayun ranꞌ ni sij. Ni̱ si̱ dunaꞌaj sij chra̱ candil naꞌue ganu̱n sa̱ꞌ yanꞌa̱n huin ni tsínj naꞌue xa̱caj sa̱ꞌ si-chrej Yanꞌanj. Hué dan ni̱ gui̱ꞌyaj gana nuguanꞌ xa̱ngaꞌ ga̱ꞌmi tsínj ꞌyaj sun riānj ngaa na̱guiꞌyaj yya sij si-ga̱quinꞌ ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ni̱ hué daj gui̱ꞌyaj sij da ga̱naꞌuij daranꞌ ni ngüi̱ ꞌna̱ꞌ anéj chrej si gui̱ꞌyaj sa̱ꞌ sij nga̱ si-xugüi sij. Daj gataj Yanꞌanj rian Isaías asi̱j hua ná. ");
INSERT INTO trq_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ngaa ni̱ nicaj ni sij ꞌngo̱ tsínj duri naꞌue ga̱ꞌmi gaꞌna̱ꞌ ni sij rian Jesús. Ni̱ nu̱n nane̱ xi̱ꞌi niman tsínj daj. Ni̱ ganahuin sij, guiꞌyaj Jesús. Ngaa ni̱ gaꞌue gaꞌmi sij. Ni̱ naxigui̱n rian sij nej. ");
INSERT INTO trq_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ni̱ gahuin yanꞌanj ruhua daranꞌ ni ngüi̱. Ni̱ nachínj snanꞌanj ni sij ni manꞌan ni dugüiꞌ ni sij. Ni̱ gataj ni sij: ―Hué sij huin daꞌníj tsínj gu̱ꞌnaj David, ruhua á re̱ꞌ níꞌ. ―Daj gataj ni sij xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Sani̱ ngaa gunun ni tsínj fariseo si gataj ni ngüi̱, ni̱ gataj ni sij: ―Xiꞌí si-fuerza manꞌan sichre Beelzebú, ni̱ gahuin nucuaj Jesús ri sij ni nane̱ xi̱ꞌi niman ni ngüi̱ aj. ―Daj gataj ni sij xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ni̱ niꞌi Jesús si ani ruhua ni tsínj fariseo daj. Ngaa ni̱ gataj sij: ―Sisi̱ ununꞌ ni du̱güiꞌ ꞌngo̱ ducuasun, ni̱ gue̱reꞌ xumanꞌ daj gui̱ꞌyaj ni manꞌan sij mán sij. Ni̱ sisi̱ ununꞌ ni du̱güiꞌ ni tsínj ma̱n ꞌngo̱ xumanꞌ, ngaa ni̱ gue̱reꞌ xánj ni sij, gui̱ꞌyaj sij. Ni̱ hué daj ga̱huin ngaa ununꞌ ꞌngo̱ tsínj daj nga̱ ni dugüiꞌ sij mán ducuá sij. ");
INSERT INTO trq_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ni̱ hué daj huin sisi̱ gui̱ri sichre Satanás manꞌan sichre Satanás niman ni ngüi̱, ni̱ huin ruhuaj gata sisi̱ hué gue̱ Satanás ununꞌ nga̱ Satanás. Ni̱ si̱ gaꞌue gu̱nucuaj rian nicaj sun sichre da mánj. ");
INSERT INTO trq_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ni̱ sisi̱ rīj sichre niman ni ngüi̱ nga̱ si-fuerza Beelzebú, ngaa ni̱ u̱n tsínj riqui sisi̱ gui̱ri ni tsínj nicoꞌ ni é re̱ꞌ sichre niman ni ngüi̱, ruhua á re̱ꞌ únj. Hué dan ni̱ di̱gyán ni síꞌ sisi̱ nitaj si hua ni̱ca ruhua ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Sani̱ sisi̱ hua yya rīj sichre niman ni ngüi̱, ꞌyaj Espíritu Santo, ngaa ni̱ huin ruhuaj gata sisi̱ gaꞌna̱ꞌ gui̱sij si gui̱nicaj sun Yanꞌanj scanij ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Si̱ gaꞌue ga̱tu ꞌngo̱ tsínj tu̱ chruhua ducuá ꞌngo̱ tsínj nucuaj, gui̱ꞌyaj tu̱ sij siꞌyaj síꞌ mánj. Sani̱ hua sini numi tsínj daj tsínj siꞌyaj, ngaa ni̱ ga̱ꞌue gui̱ꞌyaj tu̱ sij siꞌyaj síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Ni tsínj nitaj si nicaj dugüiꞌ ngāj, ni̱ ununꞌ ni sij ngāj. Ni tsínj nitaj si naranꞌ strigo ngāj, ni̱ reꞌej ni sij strigo. Ni̱ ꞌyaj ni sij sisi̱ naꞌue gui̱nicoꞌ ni ngüi̱ manꞌānj. ");
INSERT INTO trq_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Hué dan ni̱ atā gu̱nun ni é re̱ꞌ sisi̱ ga̱ꞌue gui̱nicaj Yanꞌanj niman nico xiꞌí daranꞌ gaquinꞌ ꞌyaj ni ngüi̱ nga̱ daranꞌ nuguanꞌ quij aꞌmi ni sij. Sani̱ daranꞌ ni ngüi̱ aꞌmi quij xiꞌí Espíritu Santo, ni̱ si̱ gaꞌue gui̱nicaj Yanꞌanj niman nico xiꞌí ni sij mánj. ");
INSERT INTO trq_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ga̱ꞌue gui̱nicaj Yanꞌanj ꞌngo̱ niman nico xiꞌí ni ngüi̱ aꞌmi quij rian daꞌníj ni ngüi̱ huin manꞌānj. Sani̱ si̱ gaꞌue gui̱nicaj Yanꞌanj ꞌngo̱ niman nico xiꞌí ni ngüi̱ aꞌmi quij xiꞌí Espíritu Santo mánj. Ni̱ xungüi̱ nan nga̱ xungüi̱ ga̱ꞌnaꞌ, ni̱ si̱ guinicaj Yanꞌanj niman nico xiꞌí ni sij mánj. ");
INSERT INTO trq_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Sisi̱ sa̱ꞌ ꞌngo̱ chrun daj, guiꞌyaj á re̱ꞌ, ni̱ ga̱yu chruj sa̱ꞌ chraj. Sani̱ sisi̱ xiꞌi̱ ꞌngo̱ chrun daj, guiꞌyaj á re̱ꞌ, ni̱ si̱ gayu chruj sa̱ꞌ chraj nej mánj. Daj si niꞌi néꞌ sisi̱ digyán chruj daj da̱j hua chrun ayu chruj daj. ");
INSERT INTO trq_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Daꞌníj xucuáj huin a ni é re̱ꞌ. Da̱j ga̱ꞌue ga̱ꞌmi ni é re̱ꞌ nuguanꞌ sa̱ꞌ ni̱ manꞌan ni é re̱ꞌ huin quij únj. Daj si duꞌua ni ngüi̱ aꞌmi nga̱ nuguanꞌ nu̱n chruhua niman ni sij. ");
INSERT INTO trq_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nga̱ tsínj sa̱ꞌ, ni̱ aꞌmi sij ni nuguanꞌ sa̱ꞌ. Daj si hua sa̱ꞌ niman sij. Ni̱ tsínj quij hua, ni̱ aꞌmi sij ni nuguanꞌ quij. Daj si quij hua niman sij aj. ");
INSERT INTO trq_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ni̱ atā gu̱nun a ni é re̱ꞌ sisi̱ daranꞌ ni é re̱ꞌ na̱gaꞌuiꞌ cuenta nga̱ daranꞌ ni nuguanꞌ nitaj si níꞌyanj rian Yanꞌanj güi na̱guiꞌyaj yya Yanꞌanj si-ga̱quinꞌ ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ni̱ ga̱taj Yanꞌanj sisi̱ sa̱ꞌ ni é re̱ꞌ asi̱ daꞌui ni é re̱ꞌ gaquinꞌ xiꞌí ni nuguanꞌ gaꞌmi ni é re̱ꞌ guimán ni é re̱ꞌ xungüi̱ nan. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Hué dan ni̱ gataj go̱ꞌngo ni tsínj digyán ley nga̱ ni tsínj fariseo gunun Jesús: ―Huin ruhua únj gui̱niꞌi únj gui̱ꞌyáj re̱ꞌ ꞌngo̱ si sa̱ꞌ nga̱ si-fuerzá re̱ꞌ. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ngaa ni̱ gataj Jesús: ―Huin ruhua ni tsínj xi̱ꞌi gui̱niꞌi ni sij sisi̱ gui̱ꞌyā ꞌngo̱ si sa̱ꞌ nga̱ si-fuerzāj aj. Daj si duna ni sij Yanꞌanj. Sani̱ si̱ guiꞌyā ꞌngo̱ si sa̱ꞌ nga̱ si-fuerzāj gui̱niꞌi ni sij mánj. Urin si guiranꞌ tsínj gu̱ꞌnaj Jonás huin si gui̱niꞌi ni sij. Ni̱ huin síꞌ ꞌngo̱ tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ni̱ da̱j rúnꞌ gunu̱n Jonás hua̱ꞌnij güi hua̱ꞌnij yanꞌ riqui xucuaj xxi, ni̱ daꞌngaꞌ daj gui̱ꞌnij daꞌníj ni ngüi̱ hua̱ꞌnij güi hua̱ꞌnij yanꞌ riqui yoꞌój. ");
INSERT INTO trq_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ni̱ güi ga̱nahuij xungüi̱ ngaa na̱guiꞌyaj Yanꞌanj xiꞌí si-ga̱quinꞌ ni ngüi̱, ni̱ ga̱niquinꞌ ni tsínj guimán xumanꞌ Nínive nga̱ ni tsínj ma̱n acuanꞌ. Ni̱ ga̱taj ni tsínj daj sisi̱ daꞌui ni tsínj ma̱n acuanꞌ gaquinꞌ. Daj si ganani ruhua ni tsínj guimán Nínive daj xiꞌí si-ga̱quinꞌ ni sij ngaa gunun ni sij si nataꞌ Jonás si-nu̱guanꞌ Yanꞌanj gunun ni sij. Ni̱ yuꞌuj nan niquinꞌ ꞌngo̱ tsínj huin achij daj nga̱ Jonás. ");
INSERT INTO trq_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ni̱ ngaa gui̱sij güi gui̱ꞌyaj yya Yanꞌanj nga̱ ni gaquinꞌ, ni̱ ga̱niquinꞌ reina ꞌna̱ꞌ ne̱ꞌ Sur ga̱taj únꞌ sisi̱ daꞌui ni ngüi̱ ma̱n yya̱j gaquinꞌ. Ni̱ ga̱huin ni sij castigo nej. Daj si gaꞌna̱ꞌ únꞌ daꞌ xiꞌí ni̱nꞌ xungüi̱ gu̱nun únꞌ si-nu̱guanꞌ tsínj gu̱ꞌnaj Salomón. Ni̱ chru̱n síꞌ si-nu̱guanꞌ Yanꞌanj anj. Sani̱ huin achij manꞌānj daj nga̱ Salomón rian ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Ni̱ ngaa gahui ꞌngo̱ nane̱ xi̱ꞌi niman ꞌngo̱ tsínj daj, ni̱ chéj nane̱ xi̱ꞌi daj ꞌngo̱ yuꞌuj hua na̱co nanoꞌ nane̱ daj ni̱ a̱ na̱ran ruhuaj. Sani̱ nun na̱riꞌ nane̱ daj rian na̱ran ruhuaj. ");
INSERT INTO trq_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ngaa ni̱: “Na̱nicaj ru̱huaꞌ yūnj ducuāj rian gahuī”, ataj nane̱ daj. Ni̱ ngaa nanica̱j nane̱ daj, ni̱ nariꞌ nane̱ ꞌngo̱ hueꞌ hua níꞌnij. Ni̱ hua nacaꞌ nej. Ni̱ naguiꞌyaj sa̱ꞌ nej hueꞌ daj. Ni̱ daꞌngaꞌ da̱j rúnꞌ huin hueꞌ daj hué daj huin niman tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ngaa ni̱ ganꞌanj nane̱ daj na̱noꞌ-óꞌ ango ichij nane̱ quij hua daj nga̱ manꞌan nane̱. Ni̱ daranꞌ ni nane̱ daj ga̱natu nu̱guanꞌan niman tsínj daj ru̱huaꞌ yún. Ni̱ gui̱ranꞌ sij nico sayun daj nga̱ si guiranꞌ sij asi̱j sini ya̱n. Ni̱ hué daj ga̱huin nga̱ ni ngüi̱ quij mán yya̱j. ―Daj gataj Jesús gunun ni tsínj digyán ley nga̱ ni tsínj fariseo. ");
INSERT INTO trq_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ni̱ ngaa hua gue̱ aꞌmi Jesús rian ni ngüi̱, ni̱ niquinꞌ nni sij nga̱ ni jnánj sij ne̱ꞌ chrej xe̱ꞌ hueꞌ daj. Ni̱ gataj ni sij sisi̱ huin ruhua ni sij ga̱ꞌmi ni sij nga̱ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ni̱ ganataꞌ ꞌngo̱ tsínj daj rian Jesús: ―Nní re̱ꞌ nga̱ ni jnánj re̱ꞌ anaꞌuij niquinꞌ ne̱ꞌ chrej xe̱ꞌ huin ruhua aninꞌ sij ga̱ꞌmi aninꞌ sij nga̱ re̱ꞌ. ―Daj gataj síꞌ rian Jesús. ");
INSERT INTO trq_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Sani̱ gataj Jesús gunun tsínj daj. ―Ni̱ u̱n ngüi̱ xa̱na huin nnī rian manꞌānj, ruhuá re̱ꞌ únj. Ni̱ u̱n tsínj huin jnān rian manꞌānj, ruhuá re̱ꞌ únj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ngaa ni̱ digyán sij raꞌa sij ne̱ꞌ mán ni tsínj nicoꞌ sij, ni̱ gataj sij: ―Hué nnī nga̱ ni jnān huin ni tsínj ma̱n nan. ");
INSERT INTO trq_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Daj si u̱n tsínj dagahuin si aranꞌ ruhua chrē nne xataꞌ, ni̱ hué ni sij huin jnān nga̱ xicaꞌuī nej, nnī nej aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ngaa ni̱ güi daj ni̱ gahui Jesús hueꞌ daj ganꞌanj ga̱ne sij duꞌua laguna xa̱chij. ");
INSERT INTO trq_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ni̱ ganahuin yuꞌ nico ni ngüi̱ rian sij. Ngaa ni̱ gatúj sij chruhua ꞌngo̱ rio̱ chéj rian nnee ganꞌanj ga̱ne sij. Ni̱ niquinꞌ daranꞌ ni ngüi̱ niꞌyaj ni sij duꞌua laguna daj. ");
INSERT INTO trq_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ni̱ nani sij gaꞌi̱ cuento digyán sij rian ni ngüi̱. Ni̱ gataj sij: ―Gahui ꞌngo̱ tsínj ganꞌanj da̱gamanꞌ ca̱n. ");
INSERT INTO trq_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ni̱ ngaa dagamanꞌ sij, ni̱ guinij do̱j ca̱n daj chruhua chrej aj. Ni̱ gaꞌna̱ꞌ gue̱ xataj, ni̱ xa xúꞌ ca̱n daj. ");
INSERT INTO trq_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ni̱ guinij do̱j ca̱n rian yoꞌój yej rian nitaj nico yoꞌój nu̱n. Ni̱ chiraꞌ yoo̱ ca̱n daj. Daj si nitaj si hua nico yoꞌój rian yej daj. ");
INSERT INTO trq_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Sani̱ ngaa gahui güi gurununj, ni̱ gaca coj daj, guiꞌyaj nnán. Daj si nitaj yaꞌa̱ siu̱. Ni̱ ganaco̱ ráꞌyanj coj daj. ");
INSERT INTO trq_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ni̱ gayu do̱j ca̱n scanij tanj. Ni̱ gachrij yoo̱ tanj. Hué dan ni̱ gane̱ coj daj, guiꞌyaj tanj. ");
INSERT INTO trq_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ni̱ gayu do̱j ca̱n ango yoꞌój sa̱ꞌ. Ni̱ gayu sa̱ꞌ ca̱n. Ni̱ ꞌngo̱ coj gahui ꞌngo̱ ciento ca̱n. Ni̱ ango coj gahui hua̱ꞌnij xia ca̱n. Ni̱ ángo coj gahui co̱ chiꞌ ca̱n daj. ");
INSERT INTO trq_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","’Sisi̱ nu̱n chraquíj re̱ꞌ, ni̱ gu̱nun re̱ꞌ nej aj. ―Daj gataj Jesús gunun ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Hué dan ni̱ gahuin ni̱chrunꞌ ni tsínj nicoꞌ Jesús rian síꞌ. Ni̱ nachínj snanꞌanj ni sij síꞌ. Ni̱ gataj ni sij: ―Ni̱ u̱n sin huin ni̱ naní re̱ꞌ cuento digyán re̱ꞌ rian ni ngüi̱ únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ngaa ni̱ gataj Jesús: ―Rian ni é re̱ꞌ riqui Yanꞌanj sisi̱ gui̱niꞌi ni é re̱ꞌ da̱j hua ni nuguanꞌ hui̱ rian nicaj sun Yanꞌanj. Sani̱ nun di̱gyán Yanꞌanj nuguanꞌ daj rian ango ni sij. ");
INSERT INTO trq_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Daj si tsínj unun, ni̱ ga̱ꞌuiꞌ nico Yanꞌanj rian síꞌ. Ni̱ gui̱niꞌi nico síꞌ. Sani̱ tsínj nitaj si unun, ni̱ ga̱ꞌne Yanꞌanj do̱j si unun síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Xiꞌí daj ni̱ nanīj ꞌngo̱ cuento digyānj rian ni ngüi̱. Ngaa ni̱ gui̱niꞌyaj ni sij. Sani̱ nun gui̱niꞌi ni sij. Ni̱ gu̱nun ni sij. Sani̱ naꞌue xa̱caj ni sij cuenta. ");
INSERT INTO trq_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ni̱ hué daj gahuin yya si gaꞌmi tsínj gu̱ꞌnaj Isaías tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná, ꞌyaj ni sij. Daj si gataj síꞌ: Gu̱nun chraquij ni é re̱ꞌ. Sani̱ si̱ gara daꞌngaꞌ ruhua ni é re̱ꞌ mánj. Gui̱niꞌyaj ni é re̱ꞌ. Sani̱ si̱ guiniꞌi ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Daj si tsi̱ niman ni ngüi̱ nan. Ni̱ hua ránj chraquij ni sij. Ni̱ adin rian ni sij nej. Ngaa ni̱ si̱ gaꞌue gui̱xiguin, gui̱ꞌyaj ni sij mánj. Ni̱ si̱ gaꞌue gu̱nun ni sij nej mánj. Ni̱ si̱ gaꞌue ga̱ra daꞌngaꞌ ruhua ni sij mánj. Ni̱ si̱ gaꞌue na̱nicaj ni sij ga̱ꞌnaꞌ ni sij riānj sisi̱ ga̱nahuin ni sij, gui̱ꞌyā mánj. Hué daj gataj Yanꞌanj gaꞌmi Isaías asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Sani̱ hua xiꞌí si ga̱huin nia̱ꞌ ruhua ni é re̱ꞌ. Daj si niꞌi rian ni é re̱ꞌ. Ni̱ unun chraquij ni é re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ni̱ xa̱ngaꞌ atā gu̱nun ni é re̱ꞌ sisi̱ asi̱j ná, ni̱ ni̱nꞌ ruhua gahuin ruhua nico ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj nga̱ nico ni tsínj hua sa̱ꞌ niman gui̱niꞌi ni sij da̱j rúnꞌ niꞌi ni é re̱ꞌ. Sani̱ nun gui̱niꞌi ni sij mánj. Ni̱ gahuin ruhua ni sij gu̱nun ni sij si unun ni é re̱ꞌ saj. Sani̱ si̱ gunun ni sij mánj. ");
INSERT INTO trq_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Ngaa ni̱ gu̱nun ni é re̱ꞌ u̱n sin huin ruhua cuento daj ga̱ta. ");
INSERT INTO trq_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ngaa naꞌue ga̱ra daꞌngaꞌ sa̱ꞌ ruhua ꞌngo̱ tsínj daj gunun sij nuguanꞌ sa̱ꞌ xiꞌí si nicaj sun Yanꞌanj, ni̱ ꞌna̱ꞌ sichre. Ni̱ ga̱naxun sichre nuguanꞌ sa̱ꞌ gunun sij. Ni̱ da̱j rúnꞌ huin ca̱n guinij duꞌua chrej, ni̱ daꞌngaꞌ daj huin tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ni̱ da̱j rúnꞌ huin ca̱n guinij scanij yoꞌój yej, ni̱ hué daj huin tsínj gunun si-nu̱guanꞌ Yanꞌanj. Ni̱ ꞌngo̱ hora nahuin raꞌa sij nuguanꞌ daj. Ni̱ gahuin nia̱ꞌ ruhua sij. ");
INSERT INTO trq_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Sani̱ ꞌyaj sij rúnꞌ ꞌyaj ꞌngo̱ coj nitaj nico yaꞌa̱ siu. Ni̱ ngaa ga̱ꞌnaꞌ ꞌngo̱ sayun chranꞌ yunꞌunj ango ni tsínj xiꞌí si-nu̱guanꞌ Yanꞌanj, ngaa ni̱ jna sij si-chrej Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ni̱ ca̱n guinij scanij tanj daj, ni̱ daꞌngaꞌ daj huin ango tsínj unun nuguanꞌ sa̱ꞌ. Sani̱ huin ruhua sij gui̱riꞌ sij rasu̱n ma̱n ruhua xungüi̱ nan. Ni̱ digyaꞌ yunꞌunj sanꞌanj sij si nahuij ruhua sij ga̱huin xuruꞌue sij. Ni̱ guereꞌ nuguanꞌ sa̱ꞌ ma̱n chruhua niman sij. Ni̱ nitaj si ꞌyaj sa̱ꞌ sij ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ni̱ ca̱n guinij rian yoꞌój sa̱ꞌ, ni̱ daꞌngaꞌ daj huin ango tsínj unun nuguanꞌ sa̱ꞌ. Ni̱ raj daꞌngaꞌ ruhua sij nuguanꞌ daj. Ni̱ ꞌyaj sa̱ꞌ sij. Ni̱ ꞌyaj ꞌngo̱ tsínj daj da̱j rúnꞌ ꞌyaj ꞌngo̱ coj ngaa ayu ꞌngo̱ ciento ca̱n. Hué daj ꞌyaj ni tsínj unun sa̱ꞌ si-nu̱guanꞌ Yanꞌanj. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Hué dan ni̱ nani Jesús ango cuento digyán sij rian ni síꞌ. Ni̱ gataj sij: ―Rúnꞌ huin ꞌngo̱ tsínj dagamanꞌ ca̱n sa̱ꞌ rian doꞌój sij, daꞌngaꞌ daj huin rian nicaj sun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Sani̱ ngaa atoj daranꞌ ni sij, ni̱ guisíj ꞌngo̱ tsínj ununꞌ nga̱ tsínj daj dagamanꞌ síꞌ ca̱n xi̱ꞌi riqui yoꞌój daj, ni̱ ganꞌanj síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ni̱ ngaa gachij strigo, ni̱ gani ca chraj. Ni̱ hué daj gurugüiꞌ ango coj nitaj si hua sa̱ꞌ scanij strigo daj. ");
INSERT INTO trq_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Hué dan ni̱ ganꞌanj ga̱taj ni tsínj ꞌyaj sun rian tsínj do̱ꞌoj. Ni̱ gataj ni sij: “Señor, sisi̱ hua sa̱ꞌ dagamánꞌ re̱ꞌ rian doꞌój re̱ꞌ, ni̱ ni̱ a̱ ꞌna̱ꞌ coj xi̱ꞌi nan únj.” Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ngaa ni̱: “Guiꞌyaj ꞌngo̱ tsínj ununꞌ ngāj”, ataj tsínj do̱ꞌoj gunun ni sij. Ngaa ni̱ nachínj snanꞌanj ni tsínj ꞌyaj sun rian síꞌ: “Ruhuá re̱ꞌ sisi̱ ga̱nꞌanj únj go̱rocoj únj coj xi̱ꞌi daj níꞌ”, ataj ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Sani̱ gataj tsínj do̱ꞌoj daj: “Si̱ gaꞌue go̱rocoj a ni é re̱ꞌ coj xi̱ꞌi daj nun sa̱ꞌ nun hué daj go̱rocoj a ni é re̱ꞌ strigo nej. ");
INSERT INTO trq_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Sani̱ sa̱ꞌ huin sisi̱ du̱na acuanꞌ án re̱ꞌ si da ga̱chij nu̱guanꞌanj, ngaa ni̱ ga̱ꞌnī ni tsínj ꞌyaj sun ga̱nꞌanj na̱ranꞌ sini ni sij coj xi̱ꞌi daj. Ngaa ni̱ nu̱mi ni sij rumi coj daj ga̱ꞌnij ni sij rian yanꞌa̱n ga̱ca-áꞌ. Asíj ni̱ na̱ra sa̱ꞌ ni sij strigo chruhua si-gurūj nánj”, ataj tsínj do̱ꞌoj rian ni sij. ―Daj gataj Jesús gunun ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ni̱ hué daj ganani Jesús ango cuento rian ni sij. Ni̱ gataj sij: ―Da̱j rúnꞌ hua ca̱n cuej nasa ngaa dagamanꞌ ꞌngo̱ tsínj daj rian doꞌój sij, ni̱ daꞌngaꞌ daj hua rian nicaj sun Yanꞌanj xataꞌ. ");
INSERT INTO trq_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ni̱ hué ca̱n daj huin ca̱n le nne nga̱ ango ni ca̱n. Sani̱ ngaa ga̱chi, ni̱ ga̱huin xacanj daj nga̱ ango ni coj. Ni̱ da̱j rúnꞌ huin chrun mán rian yoꞌój huin-ínꞌ. Ni̱ ꞌna̱ꞌ ni xataj ꞌyaj xúꞌ si-ga̱caꞌ xúꞌ chra̱ coj daj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ni̱ hué daj nani Jesús ango cuento. Ni̱ gataj sij: ―Da̱j rúnꞌ hua levadura, ni̱ hué daj hua rian nicaj sun Yanꞌanj xataꞌ. Ni̱ jnachej hui̱ ꞌngo̱ yunꞌunj xa̱na daj levadura scanij hua̱ꞌnij rio̱ nu̱n chru harina sisi̱ na̱huin nico quinj gui̱ꞌyaj levadura daj. ―Daj gataj Jesús digyán sij da̱j ga̱xaꞌni si-nu̱guanꞌ sij chruhua xungüi̱ nan. ");
INSERT INTO trq_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ni̱ xiꞌí cuento gaꞌmi Jesús daranꞌ ni nuguanꞌ nan rian ni ngüi̱. Ni̱ maan ni̱nanj cuento nani Jesús rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ni̱ hué na̱anj gaꞌmi Jesús sisi̱ ga̱huin yya da̱j rúnꞌ gataj tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. Ni̱ gataj síꞌ: Na̱nīj cuento rian ni ngüi̱. Ni̱ digyānj nuguanꞌ guixij hui̱ Yanꞌanj asi̱j ngaa gaxi̱ꞌi xungüi̱ nan. Daj gataj tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ngaa ni̱ ganaꞌníj Jesús na̱nꞌ ni ngüi̱. Ni̱ gatúj sij chruhua hueꞌ. Ni̱ gahuin ni̱chrunꞌ ni tsínj nicoꞌ sij. Ni̱ gataj ni síꞌ rian sij: ―Di̱gyán re̱ꞌ rian ni únj xiꞌí cuento coj xi̱ꞌi xiraꞌ riqui yoꞌój daj gu̱nun únj anj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ngaa ni̱ gataj Jesús: ―Tsínj dagamanꞌ ca̱n sa̱ꞌ daj, ni̱ hué sij huin daꞌníj ni ngüi̱ huin manꞌānj anj. ");
INSERT INTO trq_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ni̱ yoꞌój daj huin xungüi̱. Ni̱ ca̱n sa̱ꞌ daj huin ni ngüi̱ ga̱ne rian nicaj sun Yanꞌanj. Ni̱ ca̱n xi̱ꞌi daj huin ni ngüi̱ nicaj dugüiꞌ nga̱ sichre. ");
INSERT INTO trq_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ni̱ tsínj ununꞌ nga̱ tsínj do̱ꞌoj daj hué sij huin sichre dagamanꞌ ca̱n xi̱ꞌi daj rian yoꞌój. Ni̱ da̱j rúnꞌ guiꞌyaj ni sij ngaa ganaranꞌ ni sij, ni̱ daꞌngaꞌ daj ga̱huin ngaa ga̱nahuij xungüi̱ nan. Ni̱ ni tsínj ganaranꞌ daj huin ni ángel. ");
INSERT INTO trq_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ni̱ da̱j rúnꞌ gahuin ngaa ganaranꞌ ni sij coj xi̱ꞌi daj gaꞌníj ni sij rian yanꞌa̱n ga̱ca-áꞌ, ni̱ daꞌngaꞌ daj ga̱huin ngaa ga̱nahuij xungüi̱. ");
INSERT INTO trq_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Huēj huin daꞌníj ni ngüi̱ aj. Ni̱ ga̱ꞌnī ni ángel ga̱nꞌanj na̱ranꞌ daranꞌ ni tsínj digyán nuguanꞌ quij rian ni ngüi̱ nicoꞌ manꞌānj. Ni̱ daꞌngaꞌ daj gui̱ꞌyaj ni ángel nga̱ daranꞌ ni tsínj guiꞌyaj gaquinꞌ. Ni̱ gui̱ri ni ángel daranꞌ ni sij ne̱ꞌ chrej xe̱ꞌ rian nicaj sūnj anj. ");
INSERT INTO trq_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ngaa ni̱ ga̱ꞌnij ni ángel ni tsínj xi̱ꞌi daj rian gurúj yanꞌa̱n rian gu̱nun ni sij ga̱co ni sij aj. Ni̱ da̱ xaruj yanꞌ ni sij nej. ");
INSERT INTO trq_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ngaa ni̱ ni tsínj hua sa̱ꞌ, ni̱ gui̱xiguin ni sij da̱j rúnꞌ xigui̱n güi ga̱ne ni sij rian nicaj sun chrej ni sij. ’Hué dan ni̱ sisi̱ nu̱n chraquíj re̱ꞌ, ni̱ gu̱nun re̱ꞌ nej aj. ");
INSERT INTO trq_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Ni da̱j rúnꞌ hua ꞌngo̱ rasu̱n sa̱ꞌ ni̱nꞌ ruhua ngaa garij hui̱ ni ngüi̱ riqui yoꞌój da̱j hua rian nicaj sun Yanꞌanj anj. Ni̱ ganariꞌ ꞌngo̱ tsínj rasu̱n sa̱ꞌ daj. Ni̱ gahuin nia̱ꞌ ruhua sij ganariꞌ sij rasu̱n sa̱ꞌ daj. Ni̱ nanica̱j sij garíj hui̱ sij yuꞌuj daj. Ni̱ ganꞌanj sij gu̱duꞌuej sij daranꞌ ni rasu̱n ma̱n rian sij. Ni̱ guiránj sij yoꞌój daj. ");
INSERT INTO trq_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Ni da̱j rúnꞌ hua ꞌngo̱ tsínj duꞌuej rasu̱n, ni̱ daꞌngaꞌ daj hua rian nicaj sun Yanꞌanj. Daj si nanaꞌuiꞌ tsínj daj ꞌngo̱ yej sa̱ꞌ huin perla. ");
INSERT INTO trq_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ni̱ ngaa nariꞌ sij ꞌngo̱ yej perla duꞌue ni̱nꞌ ruhua daj, ngaa ni̱ ganꞌanj sij guduꞌuej sij daranꞌ ni rasu̱n ma̱n rian sij. Ni̱ guiránj sij yej perla daj. ");
INSERT INTO trq_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Ni da̱j rúnꞌ hua ꞌngo̱ nnánj gaꞌníj ni sij chruhua nnee ngaa daꞌa ni sij daranꞌ rian xucuaj, ni̱ daꞌngaꞌ daj hua rian nicaj sun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ni̱ ngaa gara nnánj daj, ni̱ guiri ni sij duꞌua nnee. Ni̱ ganꞌanj ga̱ne ni sij, ni̱ ganacui ni sij xucuaj hua sa̱ꞌ. Ni̱ gara ni sij chruhua xuguti. Ni̱ xucuaj nitaj si hua sa̱ꞌ guereꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ni̱ daꞌngaꞌ daj ga̱huin ngaa ga̱nahuij xungüi̱. Daj si gui̱ri ni̱ni ni ángel ni ngüi̱ xi̱ꞌi scanij ni ngüi̱ hua sa̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ni̱ ga̱ꞌnij ni ángel ni ngüi̱ xi̱ꞌi daj rian gurúj yanꞌa̱n rian gu̱nun ni sij ga̱co ni sij. Ni̱ da xa̱ruj yanꞌ ni sij. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ngaa ni̱ nachínj snanꞌanj Jesús ni sij. Ni̱ gataj sij: ―Gunun ni é re̱ꞌ daranꞌ ni nuguanꞌ nan gaꞌmī níꞌ. ―Gataj Jesús. Ngaa ni̱ gataj ni sij: ―Gunun ni únj, Señor. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ngaa ni̱ gataj Jesús: ―Ni̱ ngaa diguiꞌyun ꞌngo̱ tsínj digyán si-ley Yanꞌanj da̱j hua rian nicaj sun Yanꞌanj, ni̱ ꞌyaj sij da̱j rúnꞌ ꞌyaj ꞌngo̱ tsínj du̱cua. Ni̱ rian hua nara sa̱ꞌ sij siꞌyaj sij, ni̱ ga̱ꞌue gui̱ri sij ni rasu̱n naca̱, asi̱ ni rasu̱n guimán asi̱j ná. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ni̱ ngaa ganahuij ganani Jesús ni cuento digyán sij rian ni ngüi̱, ngaa ni̱ gahui sij yuꞌuj daj. ");
INSERT INTO trq_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ni̱ na̱nꞌ sij xánj sij. Ni̱ digyán sij chruhua si-nuhui ni tsínj israelita. Ngaa ni̱ ganꞌanj ruhua ni tsínj daj. Ni̱ gataj ni sij: ―Ni̱ a̱ gahuin chru̱n tsínj daj daranꞌ nuguanꞌ aꞌmi sij únj. Ni̱ da̱j ga̱ꞌue gui̱ꞌyaj sij si sa̱ꞌ ꞌna̱ꞌ rian Yanꞌanj únj. ");
INSERT INTO trq_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Sé daꞌníj tsínj acoj chrun huin sij, ni̱ huin duꞌua sij daj níꞌ. Ni̱ hué nni sij huin María nej aj. Ni̱ hué ni jnánj sij huin Jacobo nga̱ José nej, Simón nej, Judas nej aj. ");
INSERT INTO trq_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ni̱ nne ni xicaꞌuij sij scanij néꞌ aj. Ni̱ a̱ gaꞌna̱ꞌ ni nuguanꞌ daj gahuin chru̱n sij, ni̱ huin duꞌua sij daj nej únj. ―Daj gataj ni tsínj daj xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Xiꞌí daj ni̱ gahuin na̱co ruhua ni sij niꞌyaj ni sij síꞌ. Sani̱ gataj Jesús gunun ni sij: ―Nu̱n yanꞌanj ni ngüi̱ niꞌyaj ni sij ꞌngo̱ tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj u̱n yuꞌuj huaj síꞌ. Sani̱ ngaa na̱sij síꞌ xánj síꞌ rian ma̱n ni dugüiꞌ síꞌ, ni̱ nitaj si aꞌmi sa̱ꞌ ni dugüiꞌ síꞌ niꞌyaj ni sij síꞌ aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ni̱ nitaj si guiꞌyaj Jesús nico si sa̱ꞌ nga̱ si-fuerza sij yuꞌuj daj. Daj si nun gu̱xuman ruhua ni sij ni̱ꞌyaj ni sij síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ni̱ ngaa daj gunun gobernado gu̱ꞌnaj Herodes xiꞌí nuguanꞌ gaꞌmi ni ngüi̱ xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ngaa ni̱ gataj sij gunun ni tsínj ꞌyaj sun rian sij: ―Hué sij huin Juan tsínj duguataꞌ nnee ganáꞌnij sij scanij ni níman ganahuin sij Jesús aj. Xiꞌí daj ni̱ nucuaj sij ꞌyaj sij si sa̱ꞌ nga̱ si-fuerza sij, ruhuāj aj. ");
INSERT INTO trq_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Daj si hua gaꞌninꞌ Herodes sun sisi̱ gui̱daꞌa ni sij manꞌan Juan gu̱numi ni sij cadena, ni̱ ga̱ri ni sij ducuaga̱ꞌ síꞌ. Daꞌngaꞌ daj guiꞌyaj Herodes si hua xacaj sij Herodías huin unj nica̱ jnánj sij Felipe. ");
INSERT INTO trq_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ni̱ hua gataj Juan gunun Herodes sisi̱ si̱ gaꞌue xa̱caj sij xacoꞌ sij ga̱huin nica̱ sij mánj. ");
INSERT INTO trq_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ni̱ huin ruhua Herodes da̱gahuiꞌ sij Juan. Sani̱ xuꞌuiꞌ sij rian ni ngüi̱ aj. Daj si daranꞌ ni ngüi̱ gani ruhua sisi̱ Juan huin ꞌngo̱ tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Sani̱ ngaa gahuin guiꞌyanj ganasíj yoꞌ gaꞌnga Herodes, ni̱ gahuin guiꞌyanj, guiꞌyaj sij. Ni̱ guiranꞌanj daꞌni̱ xa̱na Herodías rian daranꞌ ni tsínj ma̱n nga̱ Herodes. Ni̱ garanꞌ ruhua Herodes niꞌyaj sij únꞌ. ");
INSERT INTO trq_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ni̱ gutaꞌ ni̱ca yya sij rian únꞌ sisi̱ u̱n rasu̱n ga̱ranꞌ ruhua únꞌ ga̱chinj únꞌ rian sij, ni̱ ga̱ꞌuiꞌ sij rian únꞌ. ");
INSERT INTO trq_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ni̱ hua gaꞌuiꞌ nni únꞌ ꞌngo̱ chrej da̱j ga̱ꞌmi únꞌ rian sij. Ngaa ni̱ gataj únꞌ gunun Herodes: ―Ruhuāj sisi̱ ri̱qui re̱ꞌ ꞌngo̱ goꞌo nu̱n chra̱ Juan tsínj duguataꞌ nnee riānj. ―Daj gataj únꞌ gunun Herodes, guiꞌyaj nni únꞌ. ");
INSERT INTO trq_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ngaa ni̱ ducu nani ruhua rey Herodes. Sani̱ ri̱an hua gutaꞌ ni̱ca yya sij rian yunꞌunj xa̱na daj ngaa mán ni tsínj nga̱ sij rian mesa, ni̱ gaꞌninꞌ sij sun sisi̱ ga̱ꞌuiꞌ ni sij chra̱ Juan rian únꞌ. ");
INSERT INTO trq_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ni̱ gaꞌníj sij tsínj ga̱nꞌanj ga̱ꞌnij chra̱ Juan chruhua ducuaga̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Asíj ni̱ nicaj síꞌ ꞌngo̱ goꞌo nu̱n chra̱ Juan gaꞌna̱ꞌ síꞌ gaꞌuiꞌ síꞌ rian yunꞌunj xa̱na da aj. Ni̱ nagaꞌuiꞌ únꞌ raꞌa nni únꞌ. ");
INSERT INTO trq_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ngaa ni̱ gaꞌna̱ꞌ ni tsínj nicoꞌ Juan. Ni̱ nicaj ni sij níman daj ganꞌanj gachinꞌ ni sij. Ni̱ daꞌ síj daj ganꞌanj ni sij nataꞌ ni sij rian Jesús. ");
INSERT INTO trq_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ni̱ ngaa gunun Jesús nuguanꞌ daj, ni̱ gatúj sij chruhua ꞌngo̱ rio̱ chéj rian nnee. Ni̱ gahui sij yuꞌuj daj ganꞌanj sij ꞌngo̱ yuꞌuj hua ni̱ni huin quij quiꞌyanj na̱co. Ni̱ ngaa gunun ni ngüi̱ si ganꞌanj Jesús, ni̱ gahui ni sij xánj ni sij. Ni̱ guinicoꞌ ni sij gachéj da̱coj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ni̱ ngaa nanij Jesús chruhua rio̱ daj, ni̱ guiniꞌi sij mán nico ni ngüi̱ aj. Ni̱ gahuin ꞌi̱ ruhua sij niꞌyaj sij ni síꞌ. Ni̱ ganahuin ni ngüi̱ aꞌnanꞌ, guiꞌyaj sij. ");
INSERT INTO trq_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ni̱ ngaa guini̱, ni̱ gaꞌna̱ꞌ ni tsínj nicoꞌ Jesús. Ni̱ gataj ni sij gunun síꞌ: ―Yuꞌuj nan hua níꞌnij nitaj ni ngüi̱ mán mánj. Ni̱ guisíj gahuin diꞌni̱. Ngaa ni̱ ga̱naꞌníj re̱ꞌ ni ngüi̱ ga̱nꞌanj ni síꞌ ni xumanꞌ daj sisi̱ gui̱ran ni síꞌ si xa̱ ni síꞌ. ―Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ngaa ni̱ gataj Jesús: ―Nitaj xiꞌí si ga̱nꞌanj ni sij. Ga̱ꞌuiꞌ ni é re̱ꞌ si xa̱ ni sij nan nánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ngaa ni̱: ―Maan si nicaj únj u̱nꞌunꞌ chrachrúnj nga̱ hui̱j gue̱ xucuaj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ngaa ni̱: ―Ni̱caj ni é re̱ꞌ ga̱ꞌnaꞌ ni é re̱ꞌ nan anj. ―Gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Hué dan ni̱ gaꞌninꞌ Jesús sun sisi̱ ga̱nꞌanj ga̱ne ni ngüi̱ rian chinꞌ. Ngaa ni̱ guidaꞌa sij u̱nꞌunꞌ chrachrúnj daj nga̱ hui̱j xucuaj. Ni̱ niꞌyaj sij xataꞌ. Ni̱ nagaꞌuiꞌ sij si guruhua Yanꞌanj. Ngaa ni̱ guraꞌ daꞌaj sij ni chrachrúnj gaꞌuiꞌ sij raꞌa ni tsínj nicoꞌ sij. Ni̱ nagaꞌuiꞌ ni sij raꞌa ni ngüi̱ daj. ");
INSERT INTO trq_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ni̱ xa daranꞌ ni sij. Ni̱ gara ran riqui ni sij. Ngaa ni̱ ganacaj ni sij si xitinꞌ gunáj nara ni sij chruhua xu̱huij xuguti. ");
INSERT INTO trq_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ni̱ guisíj ꞌngo̱ si u̱nꞌunꞌ mí ni tsínj xa daj. Ni̱ nini huin ni yunꞌunj xa̱na nga̱ ni tsinꞌ. ");
INSERT INTO trq_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Hué dan ni̱ guiꞌyaj Jesús sisi̱ ga̱tu ni tsínj nicoꞌ sij chruhua rio̱ chéj rian nnee ga̱chin sini ni sij anéj chrej duꞌua laguna xa̱chij daj. Ni̱ guna síꞌ. Ni̱ ganaꞌníj síꞌ ni ngüi̱ na̱nꞌ ni sij xánj sij. ");
INSERT INTO trq_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ni̱ ngaa guisíj naꞌníj síꞌ na̱nꞌ ni sij, ngaa ni̱ gahui urin síꞌ chra̱ ꞌngo̱ quij. Ni̱ ganꞌanj síꞌ gachínj jniꞌyaj síꞌ rian Yanꞌanj. Ni̱ ngaa guini̱, ni̱ nne urin Jesús yuꞌuj daj. ");
INSERT INTO trq_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ni̱ huaj guisíj rio̱ daj da da̱ni laguna xa̱chij. Ni̱ naxu̱man nnee, ni̱ xitinj rio̱ daj, guiꞌyaj nnee. Daj si ahui nane̱. Ni̱ aꞌuij rian ni sij. ");
INSERT INTO trq_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ni̱ ngaa ruhua guerenga̱ꞌ, ni̱ ganꞌanj Jesús gachéj sij rian nnee huaj sij nariꞌ dugüiꞌ sij nga̱ ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ni̱ ngaa guiniꞌi ni tsínj nicoꞌ sij chéj sij huaj sij rian nnee, ni̱ guxuꞌuiꞌ ni̱nꞌ ruhua ni sij. Ni̱ gataj ni sij: ―Hué ꞌngo̱ staꞌnaj huin. ―Daj gataj ni sij guiniꞌi ni sij Jesús. Ni̱ gaguáj ni sij si guxuꞌuiꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Sani̱ hora gaꞌmi Jesús rian ni sij. Ni̱ gataj sij: ―Ga̱ nucuaj niman ni é re̱ꞌ aj. Yūnj huin nánj. Si̱ guxuꞌuiꞌ ni é re̱ꞌ mánj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ngaa ni̱ gataj Pedro gunun Jesús: ―Señor, sisi̱ hué manꞌán re̱ꞌ ꞌna̱ꞌ, asíj ni̱ ga̱ꞌnij re̱ꞌ ga̱nꞌān ga̱chē rian nnee. Ngaa ni̱ gui̱sī rian niquínꞌ re̱ꞌ. ―Daj gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ngaa ni̱: ―Ga̱huaꞌ re̱ꞌ. ―Gataj Jesús. Ngaa ni̱ gananij Pedro chruhua rio̱ daj. Ni̱ gachéj sij rian nnee sisi̱ ga̱nꞌanj sij rian niquinꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Sani̱ ngaa guiniꞌi sij sisi̱ ahui ni̱nꞌ ruhua nane̱, ni̱ guxuꞌuiꞌ sij si ga̱nꞌanj sij. Ni̱ na̱naj huaj nagaꞌ sij chruhua nnee. Ngaa ni̱ gaguáj sij. Ni̱ gataj sij: ―Señor, na̱caj re̱ꞌ manꞌānj anj. ―Daj gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ngaa ni̱ ꞌngo̱ hora guidaꞌa Jesús raꞌa Pedro. Ni̱ gataj sij gunun síꞌ: ―Tsínj naꞌue gu̱xuman sa̱ꞌ ruhua niꞌyaj manꞌānj huín re̱ꞌ aj. Ni̱ u̱n sin huin ni̱ gahuin hui̱j nimán re̱ꞌ únj. ―Daj gataj Jesús rian síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ni̱ ngaa gahui nu̱ngüej sij chruhua rio̱, ni̱ ganiqui̱nꞌ nane̱. ");
INSERT INTO trq_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ngaa ni̱ gaꞌna̱ꞌ ni tsínj ma̱n chruhua rio̱ daj. Ni̱ ganiqui̱nꞌ ráj da̱coj ni sij rian Jesús. Ni̱ gataj ni sij: ―Xa̱ngaꞌ ni̱ hué re̱ꞌ huin daꞌníj Yanꞌanj anj. ―Daj gataj ni sij rian Jesús. ");
INSERT INTO trq_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ni̱ ngaa guisíj ni sij anéj duꞌua laguna xa̱chij daj, ni̱ guxuman ni sij ꞌngo̱ yuꞌuj gu̱ꞌnaj Genesaret. ");
INSERT INTO trq_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ni̱ ngaa gananiꞌi ni tsínj ma̱n yuꞌuj daj Jesús, ni̱ gaꞌníj ni sij nuguanꞌ ganica̱j ꞌngo̱ gue̱ yuꞌuj daj. Hué dan ni̱ nicaj ni sij daranꞌ ni ngüi̱ aꞌnanꞌ gaꞌna̱ꞌ ni sij rian Jesús. ");
INSERT INTO trq_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ni̱ gachínj jniꞌyaj ni sij sisi̱ ga̱ꞌuej síꞌ, ni̱ ga̱nun ni sij hué duꞌua si-ga̱nꞌ síꞌ. Ni̱ ganahuin daranꞌ ni ngüi̱ ganu̱n si-ga̱nꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Hué dan ni̱ ni tsínj fariseo nga̱ ni tsínj digyán ley nne xumanꞌ Jerusalén, ni̱ gaꞌna̱ꞌ ni sij rian Jesús. Ni̱ nachínj snanꞌanj ni sij Jesús. Ni̱ gataj ni sij: ");
INSERT INTO trq_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Ni̱ u̱n sin huin ni̱ naꞌue da̱gahuin ni tsínj nicoꞌ ru̱cu re̱ꞌ si-du̱cuanj ni xi únj únj. Daj si nun na̱niaꞌ ni sij ngaa xa ni sij chra. ―Daj gataj ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ngaa ni̱ gataj Jesús: ―Ni̱ u̱n sin ni̱ nun da̱gahuin ni é re̱ꞌ nuguanꞌ gaꞌninꞌ Yanꞌanj sun rian néꞌ únj. Ni̱ daꞌngaꞌ daj ꞌyaj ni é re̱ꞌ xiꞌí si dagahuin ni é re̱ꞌ nga̱ si-du̱cuanj manꞌan ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Daj si gataj Yanꞌanj: “Gui̱nun yanꞌánj re̱ꞌ chré re̱ꞌ nga̱ nní re̱ꞌ. Ni̱ u̱n tsínj aꞌmi quij rian chrej sij nga̱ nni sij, ni̱ ga̱huiꞌ sij nánj.” Daꞌngaꞌ daj gaꞌninꞌ Yanꞌanj sun rian néꞌ. ");
INSERT INTO trq_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Sani̱ ataj ni é re̱ꞌ sisi̱ ga̱ꞌue ga̱taj ꞌngo̱ tsínj daj gunun chrej sij nga̱ nni sij: “Huin ruhuāj ri̱quīj sanꞌanj nan rian nu̱ngüej é re̱ꞌ, sani̱ sanꞌanj nicā nan huin ofrenda güenda Yanꞌanj anj.” Hué daj ataj ni é re̱ꞌ. Hué dan ni̱ u̱n tsínj ga̱taj nuguanꞌ nan, ni̱ naꞌuej ruhua sij chra̱cuij sij chrej sij nga̱ nni sij. ");
INSERT INTO trq_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ni̱ xiꞌí si-du̱cuanj ni é re̱ꞌ, ni̱ ꞌyaj yu̱n ni é re̱ꞌ si-nu̱guanꞌ Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","’Tsínj digyaꞌ yunꞌunj huin ni é re̱ꞌ. Hua yya xa̱ngaꞌ si-nu̱guanꞌ xi néꞌ Isaías ngaa gaꞌmi sij si-nu̱guanꞌ Yanꞌanj xiꞌí ni é re̱ꞌ. Daj si gataj sij: ");
INSERT INTO trq_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nu̱n yanꞌanj ni ngüi̱ nan nga̱ duꞌua ni sij yūnj anj. Sani̱ ni̱ni huin niman ni sij nánj. ");
INSERT INTO trq_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nitaj si níꞌyanj si nicoꞌ ni sij yūnj mánj. Daj si nuguanꞌ digyán ni sij huin nuguanꞌ aꞌninꞌ ni tsínj sun anj. Ni̱ sé si digyán ni sij si-nu̱guanꞌānj mánj. Hué daj gataj Yanꞌanj garun Isaías asi̱j ná. ―Daj gataj Jesús gunun ni tsínj fariseo nga̱ ni tsínj digyán ley. ");
INSERT INTO trq_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Hué dan ni̱ gaquínj Jesús ga̱ꞌnaꞌ ni ngüi̱ rian sij. Ni̱ gataj sij: ―Gu̱nun ni é re̱ꞌ. Ni̱ ga̱ra daꞌngaꞌ ruhua ni é re̱ꞌ nej aj. ");
INSERT INTO trq_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nitaj si ga̱huin quij chruhua niman ꞌngo̱ tsínj daj, ꞌyaj rasu̱n atuj duꞌua sij mánj. Sani̱ ga̱huin quij chruhua niman sij, ꞌyaj nuguanꞌ ahui duꞌua sij. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ngaa ni̱ gahuin ni̱chrunꞌ ni tsínj nicoꞌ Jesús rian sij. Ni̱ ganachínj snanꞌanj ni síꞌ manꞌan Jesús. Ni̱ gataj ni síꞌ: ―Niꞌí re̱ꞌ sisi̱ nun ga̱ranꞌ ruhua ni tsínj fariseo nuguanꞌ gaꞌmí re̱ꞌ daj níꞌ. ―Daj gataj ni síꞌ gachínj snanꞌanj ni síꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ngaa ni̱ gataj Jesús: ―Go̱rocoj chrē daranꞌ coj nun gu̱nun chrē nne xataꞌ. Ni̱ da̱j rúnꞌ hua ni coj nitaj si níꞌyanj daj daꞌngaꞌ daj hua ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ga̱ꞌninꞌ ruhua á re̱ꞌ nga̱ ni sij. Daj si tsínj duri huin ni sij. Ni̱ huin ni sij ni tsínj daꞌa raꞌa ango ni tsínj duri. Ni̱ sisi̱ daꞌa ꞌngo̱ tsínj duri raꞌa tsínj duri nga̱ sij huaj nu̱ngüej sij, ni̱ gui̱nij nu̱ngüej sij chruhua yuꞌuj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ngaa ni̱ gataj Pedro gunun Jesús: ―Ga̱taj re̱ꞌ u̱n sin huin ruhua nuguanꞌ daj gata, ni̱ gu̱nun únj. ―Daj gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ngaa ni̱ gataj Jesús: ―Hua gue̱ naꞌue ga̱ra daꞌngaꞌ ruhua á re̱ꞌ níꞌ. ");
INSERT INTO trq_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Niꞌi sa̱ꞌ ni é re̱ꞌ sisi̱ daranꞌ rasu̱n atuj chruhua duꞌua ꞌngo̱ tsínj daj, ni̱ achin-ínꞌ riqui sij. Hué dan ni̱ ahui-íꞌ riꞌi sij. ");
INSERT INTO trq_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Sani̱ ni nuguanꞌ ahui duꞌua ꞌngo̱ tsínj daj, ni̱ ꞌna̱ꞌ ni nuguanꞌ daj niman sij. Ngaa ni̱ ga̱huin quij chruhua niman tsínj daj, ꞌyaj nuguanꞌ quij ahui chruhua niman sij. ");
INSERT INTO trq_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Daj si nan huin nuguanꞌ quij ahui chruhua niman ni ngüi̱: Ani quij ruhua ni sij. Ni̱ dagahuiꞌ ni sij níman nej. Ni̱ aꞌmi ni sij nga̱ nica̱ ango ni ngüi̱ nej. Ni̱ ꞌyaj squi̱raꞌ ni sij nga̱ ango ngüi̱ nej. Ni̱ ꞌyaj tu̱ ni sij nej. Ni̱ utaꞌ chre ni sij gaquinꞌ ni dugüiꞌ ni sij. Ni̱ aꞌmi quij ni sij xiꞌí ni dugüiꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ni̱ hué ni nuguanꞌ quij nan ꞌyaj sisi̱ ga̱huin quij niman ꞌngo̱ tsínj daj. Sani̱ sé si xa̱ngaꞌ sisi̱ ga̱huin quij niman sij ꞌyaj si nitaj si nania̱ꞌ sij ngaa xa sij chra. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Hué dan ni̱ gahui Jesús yuꞌuj daj ganꞌanj sij rian ngaj xumanꞌ Tiro nga̱ xumanꞌ Sidón. ");
INSERT INTO trq_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ngaa ni̱ gaꞌna̱ꞌ ꞌngo̱ yunꞌunj xa̱na nne estado Cananea. Ni̱ gaguáj únꞌ. Ni̱ gataj únꞌ gunun Jesús: ―Señor, na̱ni yaco ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ manꞌānj huín re̱ꞌ daꞌníj David. Daj si ranꞌ daꞌni̱ xa̱nāj sayun, ꞌyaj nane̱ xi̱ꞌi nu̱n niman únꞌ. ―Daj gataj únꞌ. ");
INSERT INTO trq_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Sani̱ ni̱ a̱ ꞌngo̱ nuguanꞌ nun ga̱taj Jesús gunun yunꞌunj xa̱na da̱ mánj. Ngaa ni̱ gahuin ni̱chrunꞌ ni tsínj nicoꞌ Jesús. Ni̱ gachínj jniꞌyaj ni sij rian síꞌ. Ni̱ gataj ni sij: ―Ga̱taj re̱ꞌ gu̱nun yunꞌunj xa̱na daj sisi̱ ga̱nꞌanj únꞌ. Daj si aguáj únꞌ nicoꞌ únꞌ ru̱cu únj anj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ngaa ni̱ gataj Jesús: ―Maan si gaꞌníj Yanꞌanj gaꞌnāj rian ni tsínj israelita sisi̱ huin ni sij da̱j rúnꞌ huin ni xachij ga niꞌya. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sani̱ gaꞌna̱ꞌ yunꞌunj xa̱na daj ganiqui̱nꞌ ráj da̱coj únꞌ rian Jesús. Ni̱ gataj únꞌ: ―Señor, chra̱cuij re̱ꞌ manꞌānj. ―Daj gataj únꞌ. ");
INSERT INTO trq_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ngaa ni̱ gataj Jesús: ―Nitaj si hua sa̱ꞌ si ga̱ꞌneꞌ si-chra̱chrunj ni tsinꞌ ga̱ꞌuiꞌ duꞌua ni xuhue mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ngaa ni̱ gataj únꞌ: ―Xa̱ngaꞌ Señor. Sani̱ daꞌ ni xuhue xa xúꞌ ni daru̱ chrachrúnj guinij duꞌua mesa nne tsínj huin dánj xúꞌ. ―Daj gataj únꞌ gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ni̱ gataj Jesús: ―Xuman nico ruhuá re̱ꞌ niꞌyáj re̱ꞌ manꞌānj. Xiꞌí daj ni̱ da̱j rúnꞌ achínj re̱ꞌ riānj, ni̱ hué daj ga̱huin. ―Daj gataj Jesús. Ni̱ hué hora daj ni ganahuin daꞌníj únꞌ. ");
INSERT INTO trq_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ngaa ni̱ gahui Jesús yuꞌuj daj ganꞌanj sij. Ni̱ guisíj sij ni̱chrunꞌ duꞌua laguna xa̱chij gu̱ꞌnaj Galilea. Ni̱ gahui sij chra̱ ꞌngo̱ quij ganꞌanj sij. Ni̱ ganꞌanj ga̱ne sij. ");
INSERT INTO trq_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ngaa ni̱ gahuin ni̱chrunꞌ nico ni ngüi̱ rian Jesús. Ni̱ nicaj ni sij ni ngüi̱ nareꞌ dacój nga̱ ni ngüi̱ duri nej, ni ngüi̱ ráꞌyanꞌ nej nga̱ ango ni ngüi̱ aꞌnanꞌ nicaj ni sij gaꞌna̱ꞌ ni sij rian nne Jesús. Ni̱ ganahuin ni sij, guiꞌyaj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Xiꞌí daj ni̱ ganꞌanj ruhua ni ngüi̱ gaꞌna̱ꞌ daj guiniꞌi ni sij sisi̱ gaꞌue gaꞌmi ni ngüi̱ ráꞌyanꞌ. Ni̱ ganahuin ni ngüi̱ yacuan nej. Ni̱ gaꞌue gache sa̱ꞌ ni ngüi̱ nareꞌ dacój nej. Ni̱ gaꞌue naxigui̱n rian ni ngüi̱ duri guiniꞌyaj ni sij nej. Ni̱ gaꞌmi sa̱ꞌ ni sij rian Yanꞌanj nicoꞌ ni tsínj israelita. ");
INSERT INTO trq_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ngaa ni̱ gaquínj Jesús gaꞌna̱ꞌ ni tsínj nicoꞌ sij. Ni̱ gataj sij: ―Nahuin ꞌi̱ ruhuāj niꞌyā daranꞌ ni ngüi̱ ma̱n nan. Daj si síj hua̱ꞌnij güi mán ni sij ngāj aj. Ni̱ nitaj si nicaj ni sij si xa̱ ni sij mánj. Ni̱ nitaj si huin ruhuāj na̱ꞌnī ni sij na̱nꞌ ni sij ngaa nitaj si nicaj ni sij si xa̱ ni sij si gui̱nichre ni sij huaj ni sij chruhua chrej si ruhuaj aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ngaa ni̱ gataj ni tsínj nicoꞌ Jesús: ―Ni̱ a̱ gui̱ran únj chrachrúnj gu̱numan riqui daranꞌ ni ngüi̱ nan ꞌngo̱ yuꞌuj quij quiꞌyanj na̱co únj. ―Daj gataj ni tsínj nicoꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ngaa ni̱ gataj Jesús: ―Ni̱ u̱ndaj chrachrúnj nicaj ni é re̱ꞌ únj. ―Daj gataj Jesús. ―Ichij chrachrúnj nicaj únj. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ngaa ni̱ gaꞌninꞌ Jesús sun sisi̱ ga̱nꞌanj ga̱ne ni ngüi̱ rian yoꞌój. ");
INSERT INTO trq_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ni̱ guidaꞌa sij ichij chrachrúnj nga̱ do̱j xucuaj daj raꞌa sij. Ni̱ nagoꞌ sij si guruhua Yanꞌanj. Ngaa ni̱ guraꞌ daꞌaj sij chrachrúnj daj nga̱ xucuaj gaꞌuiꞌ sij raꞌa ni tsínj nicoꞌ sij. Ni̱ daꞌngaꞌ ni síꞌ raꞌa ni ngüi̱ ma̱n anj. ");
INSERT INTO trq_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ni̱ xa daranꞌ ni sij. Ni̱ gara ran riqui ni sij. Ni̱ gara ichij xuguti, guiꞌyaj si xitinꞌ gunáj aj. ");
INSERT INTO trq_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ni̱ guisíj ga̱nꞌanj mí ni tsínj xa daj. Ni̱ nini huin ni yunꞌunj xa̱na nga̱ ni tsinꞌ. ");
INSERT INTO trq_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ngaa ni̱ naꞌníj Jesús na̱nꞌ ni ngüi̱. Ni̱ gahui sij chruhua ꞌngo̱ rio̱ chéj rian nnee. Ni̱ guisíj sij ꞌngo̱ yuꞌuj gu̱ꞌnaj Magdala. ");
INSERT INTO trq_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ngaa ni̱ gaꞌna̱ꞌ ni tsínj fariseo nga̱ ni tsínj saduceo rian Jesús si huin ruhua ni sij gui̱ꞌyaj ni sij ꞌngo̱ xiꞌ ga̱tu Jesús nga̱ si-nu̱guanꞌ síꞌ. Ni̱ gachínj ni sij sisi̱ gui̱ꞌyaj Jesús ꞌngo̱ si sa̱ꞌ ꞌna̱ꞌ rian Yanꞌanj di̱gyán sij sisi̱ ꞌna̱ꞌ sij rian Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Sani̱ gataj Jesús: ―Ataj ni é re̱ꞌ ngaa guini̱: “Gui̱xiguin sa̱ꞌ aꞌyoj. Daj si hua mare xataꞌ”, ataj ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ni̱ ne̱ꞌ ni̱ganꞌ ataj ni é re̱ꞌ: “Ga̱manꞌ, ni̱ ga̱hui nane̱. Daj si hua mare xataꞌ. Ni̱ nachej nga xataꞌ”, ataj ni é re̱ꞌ. Tsínj digyaꞌ yunꞌunj huin ni é re̱ꞌ. Niꞌi ni é re̱ꞌ da̱j hua xataꞌ. Sani̱ naꞌuej ruhua ni é re̱ꞌ gu̱nun ni é re̱ꞌ si digyán Yanꞌanj rian ni é re̱ꞌ xiꞌí si da̱j hua chruhua xungüi̱ ni güi nan. ");
INSERT INTO trq_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","’Huin ruhua ni ngüi̱ xi̱ꞌi ma̱n acuanꞌ gui̱niꞌi ni sij ꞌngo̱ si sa̱ꞌ ꞌna̱ꞌ rian Yanꞌanj. Sani̱ si̱ guiꞌyā ꞌngo̱ si sa̱ꞌ gui̱niꞌi ni é re̱ꞌ mánj. Maan si gui̱niꞌi ni é re̱ꞌ sisi̱ gui̱ranꞌānj da̱j rúnꞌ guiranꞌ tsínj gu̱ꞌnaj Jonás asi̱j ná. ―Daj gataj Jesús. Ngaa ni̱ dunáj Jesús ni sij. Ni̱ ganꞌanj síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ni̱ ngaa guisíj ni tsínj nicoꞌ Jesús anéj chrej duꞌua laguna xa̱chij daj, ni̱ xacaj ni sij cuenta sisi̱ guiniꞌyun ruhua ni sij guinica̱j ni sij chrachrúnj. ");
INSERT INTO trq_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ngaa ni̱ gataj Jesús gunun ni sij: ―Ga̱ cuidado ni é re̱ꞌ nga̱ manꞌan án re̱ꞌ. Ni̱ gu̱ruj a ni é re̱ꞌ nga̱ si-levadura ni tsínj fariseo nga̱ ni tsínj saduceo. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ni̱ gaꞌmi manꞌan ni sij gunun dugüiꞌ ni sij sisi̱ daꞌngaꞌ daj gaꞌmi Jesús xiꞌí si nitaj chrachrúnj nicaj ni sij gaꞌna̱ꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Sani̱ unun Jesús si gani ruhua ni sij. Ni̱ gataj síꞌ: ―Do̱j huin si xuman ruhua ni é re̱ꞌ niꞌyaj ni é re̱ꞌ manꞌānj nánj. Ni̱ u̱n sin huin ni̱ ani ruhua ni é re̱ꞌ sisi̱ nitaj chrachrúnj nicaj ni é re̱ꞌ gaꞌna̱ꞌ á re̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Hua gue̱ naꞌue gu̱nun ni é re̱ꞌ ga̱ꞌ. Nitaj si nu̱n ruhua ni é re̱ꞌ xiꞌí u̱nꞌunꞌ chrachrúnj xa u̱nꞌunꞌ mí ni tsínj daj. Ni̱ nitaj si nu̱n ruhua ni é re̱ꞌ u̱ndaj xuguti nara ni é re̱ꞌ dasu gunáj daj. ");
INSERT INTO trq_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ni̱ nitaj si nu̱n ruhua ni é re̱ꞌ xiꞌí ichij chrachrúnj xa ga̱nꞌanj mí ni tsínj daj. Ni̱ hué daj nitaj si nu̱n ruhua ni é re̱ꞌ u̱ndaj xuguti ganara ni é re̱ꞌ dasu gunáj. ");
INSERT INTO trq_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ni̱ u̱n sin huin ni̱ naꞌue ga̱ra daꞌngaꞌ ruhua ni é re̱ꞌ sisi̱ nitaj si aꞌmī xiꞌí chrachrúnj únj. Maan si aꞌmī sisi̱ ga̱ cuidado ni é re̱ꞌ nga̱ si gui̱ranꞌ ni é re̱ꞌ, gui̱ꞌyaj si-levadura ni tsínj fariseo nga̱ ni tsínj saduceo aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Hué dan ni̱ gara daꞌngaꞌ ruhua ni sij sisi̱ nun ga̱ꞌmi Jesús xiꞌí levadura ꞌni̱j chrachrúnj. Maan si naꞌuej ruhua síꞌ sisi̱ di̱gyaꞌ yunꞌunj si-nu̱guanꞌ ni tsínj fariseo nga̱ ni tsínj saduceo ni sij. ");
INSERT INTO trq_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ni̱ ngaa huaj gahuin ni̱chrunꞌ Jesús xumanꞌ Cesarea de Filipo, ni̱ gachínj snanꞌanj sij ni tsínj nicoꞌ sij. Ni̱ gataj sij rian ni síꞌ: ―Huēj huin daꞌníj ni ngüi̱ aj. Ni̱ u̱n tsínj huīnj ataj ni ngüi̱, ruhua ni é re̱ꞌ únj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ngaa ni̱ gataj ni sij: ―Ataj daꞌaj ni ngüi̱ sisi̱ hué re̱ꞌ huin Juan tsínj duguataꞌ nnee. Ni̱ ataj ango ni sij sisi̱ hué re̱ꞌ huin tsínj gu̱ꞌnaj Elías. Ni̱ ataj ángo ni sij sisi̱ hué re̱ꞌ huin tsínj gu̱ꞌnaj Jeremías, asi̱ ango tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j hua ná. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ngaa ni̱: ―Ni̱ u̱n tsínj huīnj ruhua manꞌan ni é re̱ꞌ únj. ―Gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ngaa ni̱ gataj Simón Pedro gunun Jesús: ―Hué re̱ꞌ huin Cristo daꞌníj Yanꞌanj hua ni̱ꞌnaꞌ aj. ―Daj gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ngaa ni̱ gataj Jesús: ―Hua ꞌueé rián re̱ꞌ Simón huín re̱ꞌ daꞌníj Jonás si ꞌngo̱ tsínj nitaj digyán nuguanꞌ nan rián re̱ꞌ mánj. Sani̱ urin chrē nne xataꞌ huin si digyán nuguanꞌ nan rián re̱ꞌ nánj. ");
INSERT INTO trq_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ni̱ atā gu̱nun re̱ꞌ sisi̱ so̱ꞌ gu̱ꞌnaj Pedro xiꞌí si da̱j rúnꞌ huin huej ngaj xiꞌí hueꞌ huín re̱ꞌ. Ni̱ da̱j rúnꞌ ꞌyaj ni sij uneꞌ ni sij hueꞌ xiráj huej, ni̱ daꞌngaꞌ daj guneꞌ manꞌānj ni tsínj nicoꞌ manꞌānj rian huej daj. Ni̱ a̱ do̱j si̱ gaꞌue gui̱ꞌyaj gana daranꞌ si-fuerza ni sichre rian ni tsínj da ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ni̱ ri̱quīj llave gui̱nicaj re̱ꞌ rian nicaj sun Yanꞌanj. Ni̱ sisi̱ gue̱ re̱ꞌ ꞌngo̱ nuguanꞌ chruhua xungüi̱, ni̱ daꞌngaꞌ daj gue̱ Yanꞌanj nuguanꞌ daj ne̱ꞌ xataꞌ nej aj. Ni̱ sisi̱ nitaj si gue̱ re̱ꞌ ꞌngo̱ nuguanꞌ chruhua xungüi̱, ni̱ daꞌngaꞌ daj nitaj si gue̱ Yanꞌanj nuguanꞌ daj ne̱ꞌ xataꞌ nej mánj. ―Daj gataj Jesús rian Pedro. ");
INSERT INTO trq_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ngaa ni̱ gaꞌninꞌ Jesús sun rian ni tsínj nicoꞌ sij sisi̱ si̱ nataꞌ ni síꞌ rian a̱ ꞌngo̱ ni ngüi̱ sisi̱ hué sij huin Cristo. ");
INSERT INTO trq_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Hué dan ni̱ asi̱j güi daj, ni̱ gaxi̱ꞌi Jesús gataj snanꞌanj sij rian ni tsínj nicoꞌ sij sisi̱ hua nia̱n ga̱nꞌanj sij xumanꞌ Jerusalén gui̱ranꞌ nico sij sayun, gui̱ꞌyaj ni tsínj huin achij nga̱ ni chrej huin rian nej nga̱ ni tsínj digyán ley nej. Ni̱ da̱gahuiꞌ ni síꞌ manꞌan sij. Sani̱ xiráj hua̱ꞌnij güi, ni̱ ga̱naꞌnij sij. ―Daj gataj Jesús xiꞌí manꞌan sij. ");
INSERT INTO trq_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ngaa ni̱ nicaj Pedro Jesús ganꞌanj anéj sij do̱j. Ni̱ gaxi̱ꞌi sij chranꞌ sij síꞌ. Ni̱ gataj sij: ―Ga̱huin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ manꞌán re̱ꞌ. Ni̱ a̱ ꞌngo̱ güi si̱ guiranꞌ re̱ꞌ daj, Señor. ―Daj gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Sani̱ nanica̱j Jesús gataj sij gunun Pedro: ―Gu̱xun re̱ꞌ manꞌán re̱ꞌ riānj, Satanás. Daj si hué re̱ꞌ huin ꞌngo̱ si naránj chrej huaj manꞌānj. Ni̱ nitaj si huin ruhuá re̱ꞌ rúnꞌ huin ruhua Yanꞌanj mánj. Rúnꞌ huin ruhua ni ngüi̱ huin ruhuá re̱ꞌ nánj. ―Daj gataj Jesús gunun Pedro. ");
INSERT INTO trq_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Hué dan ni̱ gataj Jesús gunun ni tsínj nicoꞌ sij: ―Sisi̱ hua ꞌngo̱ tsínj ruhua ni̱coꞌ yūnj, ngaa ni̱ du̱naj tsínj daj si-chrej manꞌan sij. Ngaa síj ni̱ ga̱ta sij rugutsi̱ gui̱nicoꞌ sij yūnj gui̱ranꞌ sij sayun ngāj aj. ");
INSERT INTO trq_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ni̱ tsínj naꞌuej ruhua ga̱huiꞌ ngāj, ni̱ ga̱ niꞌya sij. Sani̱ tsínj ga̱ꞌue ga̱huiꞌ xiꞌí manꞌānj nga̱ xiꞌí nuguanꞌ sa̱ꞌ aꞌmi manꞌānj, ngaa ni̱ ga̱ne ni̱ganj sij aj. ");
INSERT INTO trq_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ni̱ sisi̱ gui̱ꞌyaj gana ꞌngo̱ tsínj daj daranꞌ si ma̱n chruhua xungüi̱ ga̱huin siꞌyaj sij, ngaa ni̱ u̱n sin huin-ínꞌ sisi̱ ga̱ niꞌya niman sij, ruhua ni é re̱ꞌ únj. Nitaj si gui̱ꞌyaj gana sij mánj. Niqui niman tsínj guiꞌyaj gana nico chruhua xungüi̱ nan sisi̱ ga̱ niꞌya niman sij. Daj si naꞌue na̱huin sa̱ꞌ niman sij, gui̱ꞌyaj ni rasu̱n mánj. ");
INSERT INTO trq_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","’Daj si ga̱ꞌnāj nga̱ ni si-ángēl huīnj daꞌníj ni ngüi̱. Ni̱ ga̱huin ꞌuēj ni̱nꞌ ruhua, gui̱ꞌyaj chrē. Ngaa ni na̱ruꞌuē rian go̱ꞌngo ni ngüi̱ da̱j rúnꞌ guiꞌyaj go̱ꞌngo ni sij. ");
INSERT INTO trq_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Xa̱ngaꞌ atā gu̱nun ni é re̱ꞌ sisi̱ nitaj si ga̱huiꞌ daꞌaj ni ngüi̱ mán yuꞌuj nan daꞌ gui̱niꞌi ni sij ga̱ꞌnaꞌ manꞌānj gui̱nicaj sūnj huīnj daꞌníj ni ngüi̱. ―Daj gataj Jesús rian ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ni̱ ngaa gachin hua̱tanꞌ güi, ni̱ nicaj Jesús Pedro nga̱ Jacobo nga̱ Juan huin jnánj Jacobo ganꞌanj ni̱ni sij chra̱ ꞌngo̱ quij xa̱can. ");
INSERT INTO trq_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ni̱ ganahuin ꞌueé nnee̱ cúj Jesús ne̱ꞌ rian ni sij. Ni̱ xigui̱n rian Jesús rúnꞌ hua güi huaj. Ni̱ ganahuin gatsi̱ si-ganꞌ sij da̱j rúnꞌ hua si xigui̱n huaj. ");
INSERT INTO trq_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hué dan ni̱ gurugüiꞌ tsínj gu̱ꞌnaj Moisés nga̱ tsínj gu̱ꞌnaj Elías rian nne ni sij. Ni̱ gaꞌmi nu̱ngüej síꞌ nga̱ sij. ");
INSERT INTO trq_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ngaa ni̱ gataj Pedro gunun Jesús: ―Sa̱ꞌ mán néꞌ yuꞌuj nan Señor. Sisi̱ ga̱ranꞌ ruhuá re̱ꞌ, ni̱ gui̱ꞌyaj néꞌ hua̱ꞌnij hueꞌ recoj le aj. Ni̱ ngoj manꞌán re̱ꞌ. Ni̱ angoj Moisés. Ni̱ ángoj Elías. ―Daj gataj Pedro gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ni̱ ngaa hua gue̱ gaꞌmi Pedro, ni̱ nasíj ꞌngo̱ nga xigui̱n garan-ánꞌ rian ni sij. Ni̱ scanij nga daj gunun ni sij ꞌngo̱ nane̱ si gataj-áꞌ: ―Nan huin daꞌnī ꞌi̱ ruhuāj aj. Gu̱nun a ni é re̱ꞌ si ataj sij. ―Hué daj gataj Yanꞌanj gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ni̱ ngaa gunun ni tsínj nicoꞌ Jesús nuguanꞌ daj, ni̱ gaꞌ nitu ni sij rian yoꞌój. Daj si ducu guxuꞌuiꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ngaa ni̱ gahuin ni̱chrunꞌ Jesús ganun raꞌa síꞌ ni sij. Ni̱ gataj síꞌ: ―Ga̱naxuman ni é re̱ꞌ. Ni̱ si̱ guxuꞌuiꞌ ni é re̱ꞌ mánj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ni̱ ngaa nachica ni sij rian ni sij, ni̱ guiniꞌi ni sij niquinꞌ urin Jesús yuꞌuj daj. ");
INSERT INTO trq_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ni̱ ngaa huaj ni sij nanij ni sij chra̱ quij, ni̱ gaꞌninꞌ Jesús sun rian ni sij. Ni̱ gataj síꞌ: ―Si̱ gununa ni é re̱ꞌ si guiniꞌi ni é re̱ꞌ rian ni ngüi̱ mánj. Ni̱ daꞌ síj ga̱naꞌnij daꞌníj ni ngüi̱ huin manꞌānj, asíj ni̱ ga̱ꞌue na̱taꞌ ni é re̱ꞌ aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ngaa ni̱ nachínj snanꞌanj ni tsínj nicoꞌ Jesús manꞌan síꞌ. Ni̱ gataj ni sij: ―Ni̱ u̱n sin huin ataj ni tsínj digyán ley sisi̱ hua sini ga̱ꞌnaꞌ Elías únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ngaa ni̱ gataj Jesús: ―Xa̱ngaꞌ ga̱ꞌnaꞌ sini Elías. Ni̱ hué síꞌ na̱guiꞌyaj sa̱ꞌ daranꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ni̱ atā gu̱nun ni é re̱ꞌ sisi̱ hua gaꞌna̱ꞌ Elías. Sani̱ nun na̱niꞌi ni ngüi̱ manꞌan síꞌ mánj. Ni̱ guiꞌyaj quij ni sij daranꞌ si garanꞌ ruhua ni sij guiꞌyaj ni sij nga̱ síꞌ. Ni̱ da̱j rúnꞌ guiranꞌ síꞌ, ni̱ daꞌngaꞌ daj gui̱ranꞌ manꞌānj huīnj daꞌníj ni ngüi̱, gui̱ꞌyaj ni sij aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Hué dan ni̱ gara daꞌngaꞌ ruhua ni tsínj nicoꞌ Jesús sisi̱ aꞌmi síꞌ xiꞌí Juan tsínj duguataꞌ nnee. ");
INSERT INTO trq_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ni̱ ngaa guisíj ni sij rian ma̱n ni ngüi̱, ni̱ gaꞌna̱ꞌ ꞌngo̱ tsínj daj. Ni̱ ganiquinꞌ ráj da̱coj sij rian Jesús. ");
INSERT INTO trq_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ni̱ gataj sij: ―Señor, ga̱nani yaco ruhuá re̱ꞌ niꞌyáj re̱ꞌ do̱j daꞌnī si ahuiꞌ naꞌnij sij aj. Ni̱ ranꞌ ni̱nꞌ ruhua sij sayun. Ni̱ síj gaꞌi̱ natúj sij rian yanꞌa̱n an. Ni̱ síj gaꞌi̱ guinij sij chruhua nnee nej aj. ");
INSERT INTO trq_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ni̱ nicā gaꞌnāj rian ni tsínj nicoꞌ manꞌán re̱ꞌ aj. Sani̱ nun ga̱ꞌue ganahuin daꞌnī, guiꞌyaj ni sij mánj. ―Daj gataj tsínj daj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ngaa ni̱ gataj Jesús: ―Naꞌue gu̱xuman ruhua ni é re̱ꞌ huin ni é re̱ꞌ ni tsínj ma̱n yya̱j. Ni̱ xiꞌi̱ niman án re̱ꞌ. Ngaa ni̱ naꞌue ga̱ne nigān nga̱ á re̱ꞌ. Ni̱ si̱ gu̱nucuā si-chrej ni é re̱ꞌ ni̱ganj mánj. Ni̱caj ni é re̱ꞌ sij ga̱ꞌnaꞌ ni é re̱ꞌ riānj anj. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ngaa ni̱ gaꞌmi huee Jesús rian nane̱ xi̱ꞌi daj. Ni gahui-íꞌ chruhua niman tsinꞌ daj. Ni̱ ꞌngo̱ hora ganahuin sij, guiꞌyaj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ngaa ni̱ gaꞌna̱ꞌ urin ni tsínj nicoꞌ Jesús rian síꞌ. Ni̱ gataj ni sij: ―Ni̱ u̱n sin huin ni̱ nun gu̱nucuaj únj gui̱ri únj nane̱ xi̱ꞌi niman tsinꞌ daj únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ngaa ni̱ gataj Jesús: ―Daj si naꞌue gu̱xuman sa̱ꞌ ruhua ni é re̱ꞌ ni̱ꞌyaj ni é re̱ꞌ manꞌānj. Ni̱ xa̱ngaꞌ atā gu̱nun ni é re̱ꞌ sisi̱ gu̱xuman ruhua ni é re̱ꞌ ꞌngo̱ ritsin da̱j rúnꞌ hua ca̱n cuej nasa, ngaa ni̱ ga̱ꞌue ga̱taj ni é re̱ꞌ gu̱nun quij da aj: “Gu̱xun re̱ꞌ manꞌán re̱ꞌ yuꞌuj nan ga̱nꞌanj re̱ꞌ ango yuꞌuj.” Ni̱ daꞌngaꞌ daj ga̱huin sisi̱ gu̱xuman xa̱ngaꞌ ruhua ni é re̱ꞌ nánj. Ni̱ ga̱ꞌue gui̱ꞌyaj ni é re̱ꞌ daranꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Sani̱ ga̱ꞌue gui̱ri néꞌ ni nane̱ xiꞌi̱ nan urin si ga̱chinj jniꞌyaj néꞌ rian Yanꞌanj, ni̱ gui̱ꞌyaj néꞌ ayuno nej. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ni̱ ngaa mán ni sij estado Galilea, ni̱ gataj Jesús gunun ni sij: ―Huēj huin daꞌníj ni ngüi̱. Ni̱ na̱gaꞌuiꞌ ꞌngo̱ tsínj daj manꞌānj raꞌa ni tsínj. ");
INSERT INTO trq_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ni̱ da̱gahuiꞌ ni sij manꞌānj. Sani̱ xiráj hua̱ꞌnij güi, ni̱ ga̱naꞌnī nánj. ―Daj gataj Jesús gunun ni sij. Ni̱ ducu ganani ruhua ni sij, guiꞌyaj nuguanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ni̱ ngaa guisíj Jesús nga̱ ni tsínj nicoꞌ sij xumanꞌ Capernaum, ngaa ni̱ ganꞌanj ni̱ꞌyaj ni tsínj aꞌnej pesto güenda nuhui rian nne Pedro. Ngaa ni̱ nachínj snanꞌanj ni sij síꞌ. Ni̱ gataj ni sij: ―Si̱ gaꞌuiꞌ si-maestro ni é re̱ꞌ pesto xiꞌí nuhui nan ga̱ a̱ꞌ. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ngaa ni̱: ―Aꞌuiꞌ sij aj. ―Gataj Pedro gunun ni sij. Ngaa ni̱ ngaa gatúj Pedro chruhua hueꞌ, ni̱ gaꞌmi sini Jesús. Ni̱ gataj síꞌ: ―Da̱j huaj ruhuá re̱ꞌ, Simón. Ni̱ ni rey ma̱n chruhua xungüi̱ nan, ni̱ u̱n ngüi̱ aꞌnej ni sij sanꞌanj ruhuá re̱ꞌ únj. Aꞌnej ni sij sanꞌanj rian manꞌan daꞌníj ni sij níꞌ. Asi̱ aꞌnej ni sij sanꞌanj rian ango ni ngüi̱ sa̱ꞌ. Daꞌ ꞌyaj ni sij, ruhuá re̱ꞌ únj. ―Gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ngaa ni̱: ―Rian ango ni ngüi̱. ―Gataj Pedro. Ngaa ni̱ gataj Jesús: ―Hué dan ni̱ ni daꞌníj sij si̱ gaꞌuiꞌ ni sij pesto mánj. ");
INSERT INTO trq_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","’Sani̱ güenda sisi̱ si̱ gaꞌman ruhua ni sij, ni̱ güi̱j re̱ꞌ laguna xa̱chij, ni̱ di̱nij re̱ꞌ suelo chruhua nnee. Ni̱ xucuaj gui̱daꞌa sini suelo daj gui̱ri re̱ꞌ. Ni̱ duꞌua xuj na̱riꞌ re̱ꞌ ꞌngo̱ moneda huin sanꞌanj. Ni̱ huej gui̱sij ga̱ꞌuiꞌ re̱ꞌ xiꞌīj nga̱ xiꞌí manꞌán re̱ꞌ nej aj. ―Gataj Jesús gunun Pedro. ");
INSERT INTO trq_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ni̱ ngaa daj, ni̱ gaꞌna̱ꞌ ni tsínj nicoꞌ Jesús rian síꞌ. Ni̱ gataj ni sij: ―Ni̱ u̱n tsínj huin achij doj rian nicaj sun Yanꞌanj xataꞌ ruhuá re̱ꞌ únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ngaa ni̱ gaquínj Jesús ga̱ꞌnaꞌ ꞌngo̱ tsinꞌ gani sij da̱ni ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ni̱ gataj sij: ―Xa̱ngaꞌ atā gu̱nun ni é re̱ꞌ sisi̱ si̱ gaꞌue na̱duna ni é re̱ꞌ niman ni é re̱ꞌ, gui̱ꞌyaj ni é re̱ꞌ rúnꞌ ꞌyaj ni tsinꞌ, ngaa ni̱ si̱ gaꞌue ga̱tu ni é re̱ꞌ rian nicaj sun Yanꞌanj xataꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ni̱ u̱n tsínj gaꞌuej ruhua ga̱huin lij da̱j rúnꞌ huin lij tsinꞌ niquinꞌ nan, ni̱ hué sij ga̱huin achij rian nicaj sun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","’Ni̱ u̱n tsínj na̱huin raꞌa ꞌngo̱ tsinꞌ nan xiꞌí si nicaj dugüiꞌ sij ngāj, ngaa ni̱ na̱huin raꞌa sij manꞌānj nej. ");
INSERT INTO trq_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Ni̱ sisi̱ xuman ruhua ꞌngo̱ tsinꞌ nan niꞌyaj sij yūnj, ngaa ni̱ niqui ni̱nꞌ ruhua niman ꞌngo̱ tsínj daj sisi̱ di̱gyán sij gui̱ꞌyaj ꞌngo̱ tsinꞌ nan gaquinꞌ nánj. Sa̱ꞌ huin sisi̱ nu̱mi ni sij ꞌngo̱ to xxi xá tsínj daj, ngaa ni̱ ga̱ꞌnij ni sij ga̱nꞌanj síꞌ chruhua nnee yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Niqui ni̱nꞌ ruhua niman ni tsínj ma̱n chruhua xungüi̱ nan. Daj si digyán ni sij sisi̱ gui̱ꞌyaj dugüiꞌ ni sij gaquinꞌ. Ni̱ hua nia̱n sisi̱ daꞌngaꞌ daj ga̱huin. Sani̱ niqui ni̱nꞌ ruhua niman tsínj digyán chrej quij hua daj rian dugüiꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Hué dan ni̱ sisi̱ gui̱ꞌyáj re̱ꞌ ꞌngo̱ gaquinꞌ, gui̱ꞌyaj raꞌá re̱ꞌ, asi̱ gui̱ꞌyaj dacój re̱ꞌ gaquinꞌ, ngaa ni̱ ga̱ꞌninꞌ re̱ꞌ, ni̱ xa̱caj re̱ꞌ gue̱reꞌ re̱ꞌ. Daj ni ga̱ gundu raꞌa re̱ꞌ nga̱ dacój re̱ꞌ ga̱tu re̱ꞌ rian ga̱ne ni̱ganj re̱ꞌ nga̱ Yanꞌanj sisi̱ hui̱j raꞌá re̱ꞌ nga̱ hui̱j dacój re̱ꞌ, sani̱ ga̱ꞌnij Yanꞌanj manꞌán re̱ꞌ rian yanꞌa̱n aca ni̱ganj ni̱nꞌ. ");
INSERT INTO trq_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ni̱ sisi̱ gui̱ꞌyáj re̱ꞌ gaquinꞌ, gui̱ꞌyaj rundij rián re̱ꞌ, ngaa ni̱ gui̱ri re̱ꞌ, ni̱ xa̱caj re̱ꞌ gue̱reꞌ re̱ꞌ. Daj ni urin rundij rián re̱ꞌ ga̱tu re̱ꞌ rian ga̱ne ni̱ganj re̱ꞌ nga̱ Yanꞌanj sisi̱ hui̱j rundij rián re̱ꞌ, sani̱ ga̱ꞌnij Yanꞌanj manꞌán re̱ꞌ rian yanꞌa̱n aca ni̱ganj ni̱nꞌ. ");
INSERT INTO trq_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Si̱ gani ruhua ni é re̱ꞌ sisi̱ nitaj si níꞌyanj ni tsinꞌ hua lij mánj. Daj si ataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ dugumi sa̱ꞌ ni ángel ni tsinꞌ da aj. Ni̱ ni̱ganj ni̱nꞌ niquinꞌ ángel daj rian chrē nne ne̱ꞌ xataꞌ. Ni̱ unun chrē si nataꞌ ni ángel daj. ");
INSERT INTO trq_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Daj si gaꞌna̱ꞌ na̱cā ni ngüi̱ ga niꞌya si huīnj daꞌníj ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Ngaa ni̱ gu̱nun sa̱ꞌ a ni é re̱ꞌ si ga̱ꞌmī nan. Sisi̱ nicaj ꞌngo̱ tsínj daj ꞌngo̱ ciento xachij, ni̱ ga niꞌya ꞌngo̱ xuj, ni̱ da̱j daꞌngaꞌ gui̱ꞌyaj tsínj da̱n daj nga̱ dán sij, ruhua ni é re̱ꞌ únj. Ga̱ra sij ga̱nꞌanj xia xinunꞌ ga̱nꞌanj xachij daj riqui quij. Ni̱ ga̱nꞌanj na̱naꞌuiꞌ sij xachij ganꞌanj niꞌya daj dayun na̱riꞌ sij dán sij aj. ");
INSERT INTO trq_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ni̱ sisi̱ gu̱nucuaj sij na̱riꞌ sij xucu daj, ngaa ni̱ xa̱ngaꞌ yya atā gu̱nun ni é re̱ꞌ sisi̱ huaj ga̱huin nia̱ꞌ ruhua sij nga̱ xucu daj nga̱ ango ga̱nꞌanj xia xinunꞌ ga̱nꞌanj xucu nun ga niꞌya aj. ");
INSERT INTO trq_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hué ducuánj daj naꞌuej ruhua chrej ni é re̱ꞌ nne xataꞌ sisi̱ ga̱ niꞌya ni̱ a̱ ꞌngo̱ ni tsinꞌ nan mánj. ");
INSERT INTO trq_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Ni̱ sisi̱ guiꞌyaj ꞌngo̱ jnánj re̱ꞌ gaquinꞌ rián re̱ꞌ, ngaa ni̱ ga̱nꞌanj ga̱ꞌmi urín re̱ꞌ nga̱ sij xiꞌí gaquinꞌ daj. Ni̱ sisi̱ gu̱nun sij si ga̱taj re̱ꞌ, ngaa ni̱ ga̱naꞌmi sa̱ꞌ nu̱ngüej é re̱ꞌ nánj. ");
INSERT INTO trq_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ni̱ sisi̱ naꞌue gu̱nun sij si ga̱taj re̱ꞌ, ni̱ ga̱quinj re̱ꞌ ga̱nꞌanj ango tsínj yahuij tsínj nga̱ re̱ꞌ rian nne sij. Ni̱ sisi̱ ga̱nꞌanj hui̱j hua̱ꞌnij testigo daj, ni̱ ga̱huin yya ruhua ni é re̱ꞌ xiꞌí si hua hui̱j hua̱ꞌnij ni é re̱ꞌ gui̱niꞌi da̱j hua nuguanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Hué dan ni̱ sisi̱ naꞌue gu̱nun sij si ataj aninꞌ é re̱ꞌ, ngaa ni̱ na̱taꞌ aninꞌ é re̱ꞌ rian daranꞌ ni tsínj nicoꞌ Yanꞌanj. Ni̱ sisi̱ na̱ꞌue gu̱nun sij si ataj daranꞌ ni tsínj nicoꞌ Yanꞌanj, ngaa ni̱ ga̱ni ruhua ni é re̱ꞌ sisi̱ huin sij ꞌngo̱ tsínj ꞌna̱ꞌ anéj chrej, asi̱ huin sij ꞌngo̱ tsínj aꞌnej xa̱can pesto. ");
INSERT INTO trq_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Ngaa ni̱ xa̱ngaꞌ atā gu̱nun ni é re̱ꞌ sisi̱ si̱ gaꞌue ga̱ꞌninꞌ ruhua ni é re̱ꞌ nga̱ ꞌngo̱ nuguanꞌ hua chruhua xungüi̱ nan, ni̱ daꞌngaꞌ daj si̱ gaꞌue ga̱ꞌninꞌ ruhua Yanꞌanj nne xataꞌ nej. Ni̱ hué daj sisi̱ ga̱ꞌue ga̱ꞌninꞌ ruhua ni é re̱ꞌ nga̱ ꞌngo̱ nuguanꞌ chruhua xungüi̱ nan, ni̱ daꞌngaꞌ daj ga̱ꞌue ga̱ꞌninꞌ ruhua Yanꞌanj nne xataꞌ nej. ");
INSERT INTO trq_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ni̱ atā gu̱nun ni é re̱ꞌ sisi̱ uyan hua ruhua hui̱j ranꞌ ni é re̱ꞌ xiꞌí ꞌngo̱ nuguanꞌ chruhua xungüi̱ nan, ni̱ ga̱ꞌue ga̱chinj jniꞌyaj nu̱ngüej é re̱ꞌ rian chrē nne xataꞌ. Ni̱ ri̱qui xa̱ngaꞌ chrē si achínj nu̱ngüej é re̱ꞌ daj. ");
INSERT INTO trq_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Daj si rian hui̱j hua̱ꞌnij ranꞌ ni é re̱ꞌ nahuin yuꞌ ni é re̱ꞌ nga̱ si-xugüīj, ni̱ yuꞌuj daj nnēj da̱ni ni é re̱ꞌ aj. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ngaa ni̱ gahuin ni̱chrunꞌ Pedro nachínj snanꞌanj sij Jesús. Ni̱ gataj sij: ―Ni̱ u̱ndaj huin gui̱sij gui̱nicā niman nico nga̱ gaquinꞌ guiꞌyaj jnān riānj únj. Asi̱ da ichij níꞌ. ―Daj gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ngaa ni̱ gataj Jesús: ―Sé si atā gu̱nun re̱ꞌ sisi̱ da ichij mánj. Sani̱ da hua̱ꞌnij xia chiꞌ número nicaj ichij huin, ni̱ daꞌngaꞌ daj gui̱nicaj re̱ꞌ niman nico rian jnánj re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Ni da̱j rúnꞌ ꞌyaj ꞌngo̱ rey ngaa ruhua sij na̱guiꞌyaj sij cuenta rian ni tsínj ꞌyaj sun rian sij, ni̱ daꞌngaꞌ daj huin rian nicaj sun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ni̱ ngaa gaxi̱ꞌi naguiꞌyaj sij cuenta, ni̱ nicaj ni sij gaꞌna̱ꞌ sij ꞌngo̱ tsínj daꞌui gaꞌi̱ ni̱nꞌ ruhua millón huin sanꞌanj rian rey daj. ");
INSERT INTO trq_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ni̱ ri̱an naꞌue gu̱nucuaj sij na̱ruꞌue sij si daꞌui sij, ngaa ni̱ gaꞌninꞌ rey daj sun sisi̱ gu̱duꞌue ni sij nu̱ngüej nica̱ moso daj nga̱ daꞌníj sij nej, daranꞌ si mán rian sij nej. Asíj ni̱ gui̱riꞌ rey si daꞌui moso daj na̱ruꞌue sij. ");
INSERT INTO trq_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ngaa ni̱ ganiquinꞌ ráj da̱coj moso daj rian rey, ni̱ gaꞌmi yaco sij, gataj sij gunun rey: “Señor, ga̱nahuin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ do̱j yūnj, ngaa ni̱ na̱ruꞌue ni̱nꞌīnj rián re̱ꞌ aj.” Daj gataj sij gunun rey daj. ");
INSERT INTO trq_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ngaa ni̱ ganahuin ꞌi̱ ruhua rey daj niꞌyaj síꞌ sij. Ni̱ gaꞌninꞌ ruhua síꞌ nga̱ si daꞌui sij. Ni̱ naꞌníj síꞌ ga̱nꞌanj sij. ");
INSERT INTO trq_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Sani̱ ngaa gahui moso daj ganꞌanj sij, ni̱ nariꞌ dugüiꞌ sij nga̱ ango moso ꞌyaj sun nu̱guanꞌan nga̱ sij huin moso daꞌui do̱j sanꞌanj rian sij. Ngaa ni̱ guidaꞌa sij, ni̱ gani sij xá síꞌ. Ni̱ gataj sij: “Na̱ruꞌue so̱ꞌ si daꞌuí so̱ꞌ riānj anj.” Gataj sij gunun tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ngaa ni̱ ganiquinꞌ ráj da̱coj síꞌ rian sij. Ni̱ gaꞌmi yaco síꞌ rian sij. Ni̱ gataj síꞌ: “Ga̱nahuin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ yūnj, ngaa ni̱ na̱ruꞌue ninꞌīnj rián re̱ꞌ.” Gataj síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Sani̱ nun ga̱ꞌuej sij. Ni̱ garíj sij ducuaga̱ꞌ gunun síꞌ sisi̱ da na̱ruꞌue síꞌ daranꞌ si daꞌui síꞌ rian sij, ngaa ni̱ ga̱hui síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","’Ngaa ni̱ ngaa guiniꞌi ango ni moso ꞌyaj sun rian rey da̱j guiranꞌ moso daj, ni̱ ni̱nꞌ ruhua ganani ruhua ni sij. Ni̱ ganꞌanj na̱taꞌ ni sij daranꞌanj rian rey daj. ");
INSERT INTO trq_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ngaa ni̱ gaquínj rey ga̱ꞌnaꞌ moso daꞌui nico daj. Ni̱ gataj síꞌ rian sij: “Moso xi̱ꞌi huín re̱ꞌ. Gaꞌninꞌ ruhuāj nga̱ daranꞌ si daꞌuí re̱ꞌ xiꞌí si gaꞌmi yacó re̱ꞌ riānj saj. ");
INSERT INTO trq_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ni̱ da̱j rúnꞌ gahuin ꞌi̱ ruhuāj niꞌyā so̱ꞌ, ni̱ daꞌngaꞌ daj hua nia̱n ga̱huin ꞌi̱ ruhuá re̱ꞌ gui̱niꞌyaj re̱ꞌ dugüíꞌ re̱ꞌ saj.” Daj gataj rey rian si-moso sij. ");
INSERT INTO trq_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ngaa ni̱ ni̱nꞌ ruhua gaꞌman ruhua rey daj. Ni̱ nagoꞌ sij moso daj rian caíde dugumi rian ducuaga̱ꞌ sisi̱ ga̱huin síꞌ castigo da na̱ruꞌue síꞌ daranꞌ si daꞌui síꞌ rian rey aj. ");
INSERT INTO trq_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’Ni̱ da̱j rúnꞌ guiꞌyaj rey daj daꞌngaꞌ daj gui̱ꞌyaj chrē nne xataꞌ nga̱ ni é re̱ꞌ sisi̱ na̱ꞌue gui̱nicaj sa̱ꞌ ni é re̱ꞌ niman nico rian xiꞌí jnánj ni é re̱ꞌ nej aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ni̱ ngaa guisíj gaꞌmi Jesús ni nuguanꞌ nan, ni̱ gahui sij estado Galilea. Ni̱ guisíj sij anéj chrej duꞌua xinéj nnee gu̱ꞌnaj Jordán rian ngaj estado Judea. ");
INSERT INTO trq_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ni̱ nicoꞌ nico ni ngüi̱ sij. Ni̱ ganahuin ni ngüi̱ aꞌnanꞌ yuꞌuj daj, guiꞌyaj sij. ");
INSERT INTO trq_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ni̱ gaꞌna̱ꞌ ni tsínj fariseo. Ni̱ huin ruhua ni síꞌ ga̱ꞌuiꞌ ni síꞌ gaquinꞌ xiráj Jesús xiꞌí nuguanꞌ ga̱ꞌmi sij. Xiꞌí daj nachínj snanꞌanj ni síꞌ Jesús. Ni̱ gataj ni síꞌ: ―Ga̱ꞌuej si-ley Yanꞌanj sisi̱ du̱nóꞌ nico̱ꞌ xiꞌí daranꞌ ni nuguanꞌ níꞌ. ―Daj gataj ni tsínj fariseo rian Jesús. ");
INSERT INTO trq_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ngaa ni̱ gataj Jesús: ―Ani ruhuāj sisi̱ hua gaya ni é re̱ꞌ sisi̱ ngaa gaxi̱ꞌi daranꞌanj, ni̱ guiꞌyaj Yanꞌanj tsínj snoꞌo nga̱ yunꞌunj xa̱na. ");
INSERT INTO trq_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ni̱ gataj Yanꞌanj: “Xiꞌí daj du̱naj ꞌngo̱ tsínj daj chrej sij nga̱ nni sij. Ni̱ ga̱ne nu̱guanꞌan sij nga̱ nica̱ sij aj. Ni̱ nu̱ngüej nica̱ tsínj daj ga̱huin urin ngüi̱ aj.” Daj gataj Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ngaa ni̱ sé hui̱j nnee̱ cúj huin nu̱ngüej sij ga̱ mánj. Sani̱ urin nnee̱ cúj huin nu̱ngüej sij nánj. Ni̱ ngaa xa̱caj dugüiꞌ ꞌngo̱ tsínj daj nga̱ ꞌngo̱ yunꞌunj daj, gui̱ꞌyaj Yanꞌanj, ngaa ni̱ si̱ gaꞌue ga̱huin ni̱ni nu̱ngüej sij, gui̱ꞌyaj ni ngüi̱ mánj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ngaa ni̱ gataj ni tsínj fariseo: ―Ni̱ u̱n sin huin ni̱ gaꞌninꞌ Moisés sun sisi̱ gui̱ꞌyaj néꞌ yanj ata ga̱ꞌuiꞌ néꞌ raꞌa nica̱ néꞌ. Ngaa ni̱ du̱naj néꞌ nica̱ néꞌ, guiꞌyaj síꞌ únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ngaa ni̱ gataj Jesús: ―Xiꞌí si tsi̱ niman ni é re̱ꞌ, ni̱ riqui Moisés permiso sisi̱ du̱naj ni é re̱ꞌ nica̱ ni é re̱ꞌ. Sani̱ sé daj gahuin asi̱j sini ngaa guiꞌyaj Yanꞌanj ni ngüi̱ mánj. ");
INSERT INTO trq_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Hué dan ni̱ atā gu̱nun ni é re̱ꞌ sisi̱ tsínj gue̱reꞌej nica̱ daj, ni̱ ga̱nacaj sij ango ngüi̱, ni̱ da̱ꞌui sij gaquinꞌ anj. Sani̱ sé daj huin sisi̱ guiꞌyaj squi̱raꞌ nica̱ sij ango tsínj mánj. Ni̱ tsínj na̱caj yunꞌunj xa̱na guereꞌ daj, ni̱ da̱ꞌui sij gaquinꞌ nej aj. ―Daj gataj Jesús gunun ni tsínj fariseo. ");
INSERT INTO trq_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ngaa ni̱ gataj ni tsínj nicoꞌ Jesús: ―Sisi̱ daꞌngaꞌ daj huin nga̱ tsínj hua nica̱, ngaa ni̱ sa̱ꞌ huin sisi̱ si̱ xacaj néꞌ yunꞌunj xa̱na mánj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ngaa ni̱ gataj Jesús: ―Sé daranꞌ ni tsínj ga̱ꞌue ga̱ra daꞌngaꞌ ruhua nga̱ nuguanꞌ nan. Sani̱ sisi̱ ri̱qui Yanꞌanj, ni̱ ga̱ꞌue ga̱ra daꞌngaꞌ ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Hua ꞌngo̱ tsínj naꞌue ga̱ꞌmi nga̱ yunꞌunj xa̱na. Ni̱ daꞌngaꞌ daj hua ni sij asi̱j gaꞌnga ni sij. Ni̱ hua ango tsínj naꞌue ga̱ꞌmi nga̱ yunꞌunj xa̱na. Daj si daꞌngaꞌ daj hua nnee̱ cúj sij, guiꞌyaj ango ni tsínj. Ni̱ hua ángo tsínj naꞌuej ruhua ga̱ꞌmi nga̱ yunꞌunj xa̱na. Daj si huin ruhua sij gui̱ꞌyaj sun sij rian nicaj sun Yanꞌanj anj. Ngaa ni sisi̱ ga̱ꞌue ga̱ra xina ni é re̱ꞌ nga̱ nuguanꞌ nan, ni̱ daꞌngaꞌ daj gui̱ꞌyaj ni é re̱ꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ngaa ni̱ nicaj ni yunꞌunj xa̱na ni tsinꞌ le gaꞌna̱ꞌ ne rian Jesús sisi̱ gu̱taꞌ síꞌ raꞌa síꞌ. Ni̱ ga̱chinj jniꞌyaj síꞌ xiꞌí ni tsinꞌ-ínꞌ, ruhua ne. Sani̱ chranꞌ ni tsínj nicoꞌ Jesús ni yunꞌunj xa̱na nicaj gaꞌna̱ꞌ daj aj. ");
INSERT INTO trq_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Sani̱ gataj Jesús: ―Raꞌa ni é re̱ꞌ si ga̱ꞌnaꞌ ni tsinꞌ riānj. Ni̱ si̱ chranꞌ ni é re̱ꞌ si ga̱ꞌnaꞌ riānj nej mánj. Daj si rúnꞌ huin ni tsinꞌ le nan, ni̱ daꞌngaꞌ daj huin ni ngüi̱ ma̱n rian nicaj sun Yanꞌanj nne xataꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ngaa ni̱ gutaꞌ Jesús raꞌa sij rian ni tsinꞌ. Ni̱ gahui sij ganꞌanj sij. ");
INSERT INTO trq_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Hué dan ni̱ gaꞌna̱ꞌ ꞌngo̱ tsínj daj. Ni̱ gataj sij gunun Jesús: ―Maestro sa̱ꞌ, u̱n sun sa̱ꞌ gui̱ꞌyaj sūnj, ni̱ ga̱ꞌue ga̱ne nigān, ruhuá re̱ꞌ únj. ―Daj gataj sij aj. ");
INSERT INTO trq_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ngaa ni̱ gataj Jesús: ―Ni̱ u̱n sin huin ni̱ atáj re̱ꞌ sisi̱ sa̱ꞌ manꞌānj únj. Urin Yanꞌanj huin si sa̱ꞌ nánj. Sani̱ sisi̱ huin ruhuá re̱ꞌ ga̱ne ni̱ganj re̱ꞌ nga̱ Yanꞌanj, ngaa ni̱ da̱gahuín re̱ꞌ nuguanꞌ gaꞌninꞌ Yanꞌanj sun rian néꞌ. ―Daj gataj Jesús gunun sij. ");
INSERT INTO trq_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ngaa ni̱: ―Ni̱ u̱n nuguanꞌ da̱gahuin únj, ruhuá re̱ꞌ únj. ―Gataj tsínj daj gunun Jesús. Ngaa ni̱ gataj Jesús: ―Si̱ dagahuíꞌ re̱ꞌ níman mánj. Ni̱ si̱ guiꞌyaj tu̱ re̱ꞌ mánj. Ni̱ si̱ gaꞌmi re̱ꞌ nuguanꞌ nne̱ xiꞌí dugüíꞌ re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ni̱ gui̱nun yanꞌánj re̱ꞌ chréj re̱ꞌ nga̱ nní re̱ꞌ nej. Ni̱ ga̱huin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ dugüíꞌ re̱ꞌ da̱j rúnꞌ ꞌi̱ ruhuá re̱ꞌ niꞌyáj re̱ꞌ manꞌán re̱ꞌ aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ngaa ni̱ gataj tsínj daj gunun Jesús: ―Daranꞌ ni nuguanꞌ daj ráj xināj asi̱j hua lē aj. Ngaa ni̱ u̱n sin achin gui̱ꞌyā, ruhuá re̱ꞌ únj. ―Daj gataj sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ngaa ni̱ gataj Jesús gunun sij: ―Sisi̱ huin ruhuá re̱ꞌ ga̱huin sa̱ꞌ ni̱nꞌ re̱ꞌ, ngaa ni̱ güi̱j na̱nꞌ re̱ꞌ gu̱duꞌue re̱ꞌ daranꞌ siꞌyáj re̱ꞌ. Ni̱ sanꞌanj gui̱riꞌ re̱ꞌ daj ga̱ꞌuiꞌ re̱ꞌ rian ni ngüi̱ niqui. Hué dan ni̱ gui̱man nico siꞌyáj re̱ꞌ xataꞌ, gui̱ꞌyaj Yanꞌanj anj. Ngaa ni̱ ga̱ꞌnaꞌ re̱ꞌ gui̱nicoꞌ re̱ꞌ yūnj anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ni̱ ngaa gunun tsínj daj si gataj Jesús, ni̱ ganꞌanj sij nani ruhua sij. Daj si hua nico siꞌyaj sij. ");
INSERT INTO trq_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ngaa ni̱ gataj Jesús gunun ni tsínj nicoꞌ sij: ―Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ ꞌi̱ huaj ga̱tu ꞌngo̱ tsínj xuruꞌue rian nicaj sun Yanꞌanj xataꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ni̱ ga̱taj ru̱huaꞌ yūnj sisi̱ ꞌi̱ huaj ga̱tu ꞌngo̱ tsínj xuruꞌue rian nicaj sun Yanꞌanj daj nga̱ si ga̱chin ꞌngo̱ xucu camello yuꞌuj ta̱j cúj nuhua aj. Ni̱ xxi hua xúꞌ aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ngaa ni̱ ngaa gunun ni tsínj nicoꞌ Jesús nuguanꞌ daj, ni̱ ni̱nꞌ ruhua ganꞌanj ruhua ni sij. Ni̱ gataj ni sij: ―Sisi̱ hué daj huin, ni u̱n tsínj ga̱ꞌue na̱caj Yanꞌanj únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ngaa ni̱ niꞌyaj Jesús rian ni sij. Ni̱ gataj síꞌ: ―Si̱ gaꞌue na̱caj ni ngüi̱ manꞌan ni sij mánj. Sani̱ Yanꞌanj ga̱ꞌue gui̱ꞌyaj daranꞌ nuguanꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ngaa ni̱ gataj Pedro: ―Hua duna únj daranꞌ siꞌyaj únj anj. Ni̱ nicoꞌ únj manꞌán re̱ꞌ aj. Ngaa ni̱ u̱n sin huin na̱riqui Yanꞌanj rian únj, ruhuá re̱ꞌ únj. ―Daj gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ni̱ gataj Jesús gunun ni sij: ―Xa̱ngaꞌ atā gu̱nun ni é re̱ꞌ sisi̱ ngaa gui̱sij güi ga̱ne ꞌuēj rian chrun xila sa̱ꞌ ango xungüi̱ na̱ca, ni̱ ga̱ne xa̱ngaꞌ ni é re̱ꞌ rian ni xu̱huij chrun xila sa̱ꞌ gui̱nicaj ni é re̱ꞌ sun rian ni xu̱huij xiꞌninꞌ ni tsínj israelita. Ni̱ hué daj ga̱huin xiꞌí si guinicoꞌ ni é re̱ꞌ manꞌānj huīnj daꞌníj ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ni̱ danej gahuin a ni é re̱ꞌ dunáj á re̱ꞌ ducuá á re̱ꞌ nga̱ jnánj án re̱ꞌ nej, xocoꞌ a ni é re̱ꞌ nej, nga̱ chrej a ni é re̱ꞌ nej, nni a ni é re̱ꞌ nej, nga̱ daꞌníj ni é re̱ꞌ nej, doꞌój re̱ꞌ nej, ni̱ sisi̱ du̱naj á re̱ꞌ daranꞌ nan rian xiꞌīj, ngaa ni̱ na̱huin raꞌa ni é re̱ꞌ ꞌngo̱ ciento ni rasu̱n sa̱ꞌ nan. Ni̱ ga̱ne ni̱ganj án re̱ꞌ nga̱ Yanꞌanj, gui̱ꞌyaj Yanꞌanj nej aj. ");
INSERT INTO trq_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Sani̱ nico ni ngüi̱ huin achij chruhua xungüi̱ nan na̱nicoꞌ ni sij ne̱ꞌ ru̱cu ango xungüi̱ ga̱ꞌnaꞌ aj. Ni̱ nico ni ngüi̱ nicoꞌ ne̱ꞌ ru̱cu chruhua xungüi̱ nan ga̱huin achij ni sij ango xungüi̱ ga̱ꞌnaꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Ni̱ da̱j rúnꞌ ꞌyaj ꞌngo̱ xuruꞌue ngaa ahui sij ni̱ganꞌ acuanꞌ na̱naꞌuiꞌ sij ni tsínj ga̱nꞌanj gui̱ꞌyaj sun doꞌój sij rian ma̱n coj chruj uva, ni̱ daꞌngaꞌ daj ꞌyaj Yanꞌanj nga̱ néꞌ rian nicaj sun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ni̱ guiꞌyaj yya xuruꞌue daj nga̱ ni tsínj gui̱ꞌyaj sun u̱ndaj huin ga̱ꞌuiꞌ síꞌ duꞌue ni sij ꞌngo̱ güi daj. Ni̱ gaꞌmi síꞌ sisi̱ ga̱ꞌuiꞌ síꞌ ꞌngo̱ sanꞌanj denario rian ni sij. Ngaa ni̱ gaꞌníj síꞌ ga̱nꞌanj gui̱ꞌyaj sun ni sij riqui coj uva. ");
INSERT INTO trq_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","’Hué dan ni̱ gahui yún xuruꞌue daj ganꞌanj sij ga u̱n ni̱ganꞌ. Ni̱ guiniꞌi sij mán ango ni tsínj mán rian yuꞌue̱. Ni niquinꞌ yu̱n ni sij. ");
INSERT INTO trq_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ni̱ gataj sij: “Güi̱j gui̱ꞌyaj sun ni é re̱ꞌ si-sūnj anj. Ni̱ da̱j rúnꞌ gui̱ꞌyaj sun ni é re̱ꞌ, ni̱ ri̱quīj duꞌue ni é re̱ꞌ aj.” Daj gataj sij. Ni̱ ganꞌanj gui̱ꞌyaj sun ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","’Ngaa ni̱ gahui ru̱huaꞌ yún sij ganꞌanj sij ga xuj nej, ga hua̱ꞌnij diꞌni̱ nej. Ni̱ da̱j rúnꞌ guiꞌyaj sij ga u̱n, ni̱ daꞌngaꞌ daj guiꞌyaj ru̱huaꞌ yún sij. ");
INSERT INTO trq_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","’Ni̱ ganꞌanj ru̱huaꞌ yún sij rian yuꞌue̱ síj ꞌngo̱ si ga u̱nꞌunꞌ diꞌni̱. Ni̱ ganariꞌ sij ango ni tsínj mán manꞌan. Ni̱ ganachínj snanꞌanj sij ni síꞌ. Ni̱ gataj sij: “Ni̱ u̱n sin huin ni mán ni é re̱ꞌ nu̱n güi ni̱nꞌ yuꞌuj nan, ni̱ nitaj sun ꞌyaj sun ni é re̱ꞌ mán án re̱ꞌ yuꞌuj nan únj.” Gataj sij. ");
INSERT INTO trq_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ngaa ni̱: “Nitaj ꞌngo̱ tsínj ataj sisi̱ ga̱nꞌanj gui̱ꞌyaj sun ni únj mánj.” Gataj ni tsínj mán rian yuꞌue̱ daj rian sij. Ngaa ni̱ gataj xuruꞌue daj: “Güi̱j gui̱ꞌyaj sun ni é re̱ꞌ riqui coj uva. Ni̱ ri̱quīj duꞌue ni é re̱ꞌ da̱j rúnꞌ gui̱ꞌyaj sun a ni é re̱ꞌ aj.” Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Ni̱ ngaa guini̱, ni̱ gataj sij gunun tsínj nicaj yunꞌunj ni moso daj: “Ga̱quinj re̱ꞌ ga̱ꞌnaꞌ ni tsínj ꞌyaj sun nánj. Ni̱ na̱gaꞌuiꞌ re̱ꞌ duꞌue ni sij aj. Ga̱xiꞌi re̱ꞌ na̱ruꞌue re̱ꞌ rian ni tsínj nicoꞌ da ru̱cu guiꞌyaj sun aj. Ngaa ni̱ na̱ruꞌue re̱ꞌ rian ni tsínj gatúj asi̱j sini ya̱n.” Gataj xuruꞌue daj. ");
INSERT INTO trq_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","’Ngaa ni̱ guisíj ni tsínj gatúj da ga u̱nꞌunꞌ diꞌni̱ daj. Ni̱ da go̱ꞌngo ni sij ganahuin raꞌa chreꞌ gue̱ ni sij ꞌngo̱ sanꞌanj denario da aj. ");
INSERT INTO trq_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ni̱ ngaa guisíj ni tsínj guiꞌyaj sun sini, ngaa ni̱ gani ruhua ni sij sisi̱ xa̱can doj ga̱ꞌuiꞌ xuruꞌue daj duꞌue ni sij daj nga̱ si gaꞌuiꞌ síꞌ rian ni tsínj gatúj guiꞌyaj sun ga u̱nꞌunꞌ. Sani̱ ꞌngo̱ hua nahuin raꞌa daranꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ni̱ ngaa nahuin raꞌa ni sij, ni̱ gaxi̱ꞌi ni sij gaꞌmi gaquinꞌ ni sij xiꞌí xuruꞌue. ");
INSERT INTO trq_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ni̱ gataj ni sij: “Ni tsínj gatúj da ru̱cu daj, ni̱ guiꞌyaj sun ni sij urin hora. Sani̱ uyan naruꞌué re̱ꞌ rian ni sij nga̱ únj nánj. Ni̱ guiꞌyaj sun ni únj nu̱n güi ni̱nꞌ anj. Ni̱ nu̱n güi ni̱ ya̱nꞌan nej aj.” Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Sani̱ gataj tsínj doꞌój rian ꞌngo̱ ni sij: “Amigo, sé si digyaꞌ yunꞌūn go̱ꞌngo ni é re̱ꞌ mánj. Sani̱ hua guiꞌyaj yyá re̱ꞌ ngāj sisi̱ na̱ruꞌuē ꞌngo̱ sanꞌanj denario rian re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ga̱nacaj re̱ꞌ duꞌué re̱ꞌ, ni̱ güi̱j re̱ꞌ nánj. Da̱j rúnꞌ naruꞌuē rian re̱ꞌ, ni̱ daꞌngaꞌ daj huin ruhuāj na̱ruꞌuē rian tsínj nicoꞌ da ru̱cu nej. ");
INSERT INTO trq_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Sani̱ ga̱ꞌue gui̱ꞌyā da̱j rúnꞌ garanꞌ ruhuāj nga̱ si-sa̱nꞌān nánj. Xicoj ruhuá re̱ꞌ si guiꞌyā do̱j sinduj nga̱ dugüíꞌ re̱ꞌ níꞌ.” Daj gataj xuruꞌue daj gunun tsínj guiꞌyaj sun. ");
INSERT INTO trq_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","’Ngaa ni̱ ni ngüi̱ nicoꞌ da ru̱cu xungüi̱ nan, ni̱ ga̱huin rian ni sij ango xungüi̱ na̱ca. Ni̱ ni ngüi̱ huin rian xungüi̱ nan, sani̱ gu̱na da ru̱cu ni sij ango xungüi̱ daj. Daj si aquínj Yanꞌanj nico ni ngüi̱ ga̱nꞌanj rianj anj. Sani̱ do̱j ni sij huin si nacui Yanꞌanj nánj. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ni̱ ngaa huaj Jesús gahui sij dacan rian ngaj xumanꞌ Jerusalén, ni̱ gaquínj sij ni tsínj nicoꞌ sij ga̱ꞌnaꞌ nini ni síꞌ rian sij. Ni̱ gataj sij: ");
INSERT INTO trq_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Niꞌi ni é re̱ꞌ sisi̱ huaj néꞌ gui̱sij néꞌ xumanꞌ Jerusalén. Ni̱ hué yuꞌuj daj na̱gaꞌuiꞌ ꞌngo̱ tsínj daj manꞌānj rian ni chrej aꞌninꞌ nga̱ rian ni maestro digyán ley rian ni ngüi̱. Ni̱ huīnj daꞌníj ni ngüi̱. Ni̱ da̱gaꞌmi dugüiꞌ ni sij sisi̱ da̱gahuiꞌ ni sij manꞌānj. ");
INSERT INTO trq_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ngaa ni̱ na̱gaꞌuiꞌ ni sij yūnj rian ni tsínj ꞌna̱ꞌ anéj chrej sisi̱ ga̱ꞌmi ducu ni síꞌ xiꞌīj. Ni̱ du̱guayun ni síꞌ nneꞌ xirā aj. Ni̱ ga̱ri ni síꞌ gaquíj manꞌānj rian rugutsi̱ nej aj. Sani̱ xiráj hua̱ꞌnij güi, ni̱ ga̱naꞌnī nánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ngaa ni̱ gahuin ni̱chrunꞌ hui̱j da̱ꞌnij nica̱ tsínj gu̱ꞌnaj Zebedeo rian Jesús. Ni̱ ganiquinꞌ ráj da̱coj únꞌ rian Jesús. Ni̱ gachínj únꞌ ꞌngo̱ sinduj rian sij. ");
INSERT INTO trq_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ngaa ni̱ gataj Jesús: ―Ni̱ u̱n sin huin ruhuá re̱ꞌ únj. ―Gataj Jesús. Ni̱ gataj unj gunun sij: ―Ga̱ꞌninꞌ re̱ꞌ sun sisi̱ ngaa ga̱ne sún re̱ꞌ gui̱nicaj sún re̱ꞌ, ni̱ ga̱ne nu̱ngüej daꞌnī xiꞌníj re̱ꞌ, ꞌngo̱ sij ne̱ꞌ chrej raꞌa sa̱ꞌ re̱ꞌ, ni̱ ango sij ne̱ꞌ chrej raꞌa ro̱tsi re̱ꞌ, ruhuāj aj. ―Gataj unj. ");
INSERT INTO trq_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ngaa ni̱ gataj Jesús: ―Nun niꞌi nu̱ngüej é re̱ꞌ si achínj nu̱ngüej é re̱ꞌ mánj. Ga̱ꞌue gu̱nucuaj nu̱ngüej é re̱ꞌ gui̱ranꞌ nu̱ngüej é re̱ꞌ sayun da̱j rúnꞌ gui̱ranꞌ manꞌānj níꞌ. ―Daj gataj Jesús. ―Ga̱ꞌue aj. ―Daj gataj nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ngaa ni̱ gataj Jesús: ―Xa̱ngaꞌ gui̱ranꞌ nu̱ngüej é re̱ꞌ sayun ngāj aj. Sani̱ naꞌue ri̱qui manꞌānj sisi̱ ga̱ne nu̱ngüej é re̱ꞌ ꞌngo̱ ni é re̱ꞌ raꞌa sa̱ꞌāj, ni̱ ango ni é re̱ꞌ raꞌa ro̱tsīj mánj. Hua nacui chrē nu̱ngüej tsínj ga̱ne nu̱ngüej chrej xiꞌnī anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ni̱ ngaa gunun ango ichiꞌ ni tsínj nicoꞌ Jesús, ni̱ gaꞌman ruhua ni síꞌ niꞌyaj ni síꞌ nu̱ngüej tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Sani̱ gaquínj Jesús ga̱ꞌnaꞌ ni sij, ni̱ gataj sij: ―Niꞌi ni é re̱ꞌ da̱j ꞌyaj ni tsínj nicaj sun scanij ni tsínj ꞌna̱ꞌ anéj chrej. Ni̱ aranꞌ ruhua ni sij gui̱nicaj sun nico ni sij ga̱huin achij ni sij rian ni ngüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Sani̱ sé daj gui̱ꞌyaj ni é re̱ꞌ mánj. Tsínj ruhua ga̱huin achij scanij ni é re̱ꞌ, ngaa ni̱ ga̱huin sij si-moso ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ni̱ tsínj ruhua ga̱huin rian scanij ni é re̱ꞌ, ngaa ni̱ ga̱huin sij tsínj ꞌyaj sun rian ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Daj si sé si ꞌnāj ni̱ gui̱ꞌyaj sun ni ngüi̱ riānj, ruhuāj mánj. Ni̱ huīnj daꞌníj ni ngüi̱. Sani̱ ꞌnāj gui̱ꞌyaj sūnj rian ni ngüi̱ aj. Ni̱ ꞌnāj ga̱huīj na̱ruꞌuē rian si-ga̱quinꞌ nico ni ngüi̱ aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ni̱ ngaa gahui ni sij xumanꞌ Jericó, ni̱ gachéj ni̱nꞌ ruhua ni ngüi̱ ru̱cu Jesús. ");
INSERT INTO trq_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ni̱ nne hui̱j tsínj duri duꞌua chrej. Ni̱ ngaa gunun nu̱ngüej sij sisi̱ huaj Jesús yuꞌuj daj, ni̱ gaguáj nu̱ngüej sij. Ni̱ gataj nu̱ngüej sij: ―Señor, na̱huin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ nu̱ngüej únj huín re̱ꞌ daꞌníj David aán. ―Daj gaguáj nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ngaa ni̱ chranꞌ ni ngüi̱ sisi̱ dínj ga̱ne duꞌua nu̱ngüej sij. Sani̱ doj a̱ꞌ ganariꞌ nucuaj nu̱ngüej sij gaguáj nu̱ngüej sij. Ni̱ gataj nu̱ngüej sij: ―Señor, na̱huin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ nu̱ngüej únj huín re̱ꞌ daꞌníj David aán. ―Daj gataj nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ngaa ni̱ ganiquinꞌ Jesús. Ni̱ gaquínj sij ga̱ꞌnaꞌ nu̱ngüej síꞌ rian sij. Ni̱ gataj sij: ―Ni̱ u̱n sin huin ruhua nu̱ngüej é re̱ꞌ gui̱ꞌyā nga̱ nu̱ngüej é re̱ꞌ únj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ngaa ni̱ gataj nu̱ngüej sij: ―Señor, huin ruhua únj sisi̱ ga̱naxiguin rian nu̱ngüej únj, gui̱ꞌyáj re̱ꞌ, ruhua únj anj. ―Daj gataj nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ngaa ni̱ ganani yaco ruhua Jesús niꞌyaj síꞌ nu̱ngüej sij. Ni̱ ganun raꞌa síꞌ rian nu̱ngüej sij. Ni̱ ꞌngo̱ hora naxigui̱n rian nu̱ngüej tsínj duri daj. Ni̱ guinicoꞌ nu̱ngüej sij Jesús. ");
INSERT INTO trq_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ngaa ni̱ guisíj ni sij xumanꞌ Betfagé rian niquinꞌ ꞌngo̱ dacan gu̱ꞌnaj Olivos. Ni̱ ngaj ni̱chrunꞌ xumanꞌ Jerusalén nga̱ xumanꞌ Betfagé. Ngaa ni̱ gaꞌníj Jesús hui̱j tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ni̱ gataj sij: ―Ga̱nꞌanj nu̱ngüej é re̱ꞌ xumanꞌ ngaj ne̱ꞌ rian do̱j aj. Ni̱ ngaa huaj nu̱ngüej é re̱ꞌ, ni̱ na̱riꞌ ráꞌyanj nu̱ngüej é re̱ꞌ ꞌngo̱ urruj anumi nga̱ daꞌníj xúꞌ. Ni̱ ga̱nachi nu̱ngüej é re̱ꞌ ni̱caj re̱ꞌ ga̱ꞌnaꞌ re̱ꞌ riānj. ");
INSERT INTO trq_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ni̱ sisi̱ hua ꞌngo̱ ngüi̱ ga̱nachinj snanꞌanj rian nu̱ngüej é re̱ꞌ, ngaa ni̱ ga̱taj nu̱ngüej é re̱ꞌ gu̱nun ni sij: “Manꞌan Señor níꞌyanj xuj aj. Ni̱ hora ni̱ ga̱ꞌnaꞌ ni̱caj yún xuj, gui̱ꞌyaj síꞌ aj.” Daj ga̱taj nu̱ngüej é re̱ꞌ gu̱nun ni ngüi̱ aj. ―Daj gataj Jesús gunun nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ni̱ daꞌngaꞌ daj gahuin sisi̱ ga̱huin yya da̱j rúnꞌ gataj ꞌngo̱ tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. Ni̱ gataj síꞌ: ");
INSERT INTO trq_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ga̱taj ni é re̱ꞌ gu̱nun ni ngüi̱ ma̱n xumanꞌ Sión sisi̱ hué si-rey ni sij ꞌna̱ꞌ rian ma̱n ni sij. Ni̱ da̱j rúnꞌ huin xucu ni̱, ni̱ daꞌngaꞌ daj huin sij. Ni̱ ta̱j sij ꞌngo̱ urruj daꞌníj xucu ꞌyaj sun. Daj gataj tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ngaa ni̱ ganꞌanj nu̱ngüej tsínj nicoꞌ Jesús. Ni̱ guiꞌyaj nu̱ngüej sij da̱j rúnꞌ gaꞌninꞌ Jesús sun rian nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ngaa ni̱ nicaj nu̱ngüej sij nu̱ngüej da̱ꞌnij urruj daj gaꞌna̱ꞌ nu̱ngüej sij rian Jesús. Ngaa ni̱ gutaꞌ nu̱ngüej sij si-ganꞌ nu̱ngüej sij xiráj nu̱ngüej xúꞌ. Ngaa ni̱ guitáj Jesús xúꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ngaa ni̱ guruj nico ni ngüi̱ si-ganꞌ ni sij chruhua chrej. Ni̱ gaꞌninꞌ ango ni sij coj raꞌa chrun guruj ni sij chruhua chrej. ");
INSERT INTO trq_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ni ngüi̱ huaj ne̱ꞌ rian nej, nga̱ ni ngüi̱ nicoꞌ ne̱ꞌ ru̱cu Jesús aguáj ni sij. Ni̱ gataj ni sij: ―Hosanna, daꞌníj David huín re̱ꞌ. Hua nia̱ꞌ ꞌueé ruhua tsínj ꞌna̱ꞌ nga̱ si-xugüi manꞌan Señor. Ga̱ sa̱ꞌ ꞌueé xataꞌ aj. ―Gataj ni sij gaguáj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ni̱ ngaa gatúj Jesús chruhua xumanꞌ Jerusalén, ni̱ nun na̱riꞌ ruhua ni ngüi̱ u̱n sin gahuin mánj. Ni̱ gataj ni sij: ―Ni̱ u̱n tsínj huin nan únj. ―Daj gataj ni ngüi̱ ma̱n xumanꞌ Jerusalén. ");
INSERT INTO trq_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ngaa ni̱ gataj ango ni ngüi̱: ―Tsínj nan huin Jesús tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj. Ni̱ ꞌna̱ꞌ sij xumanꞌ Nazaret estado Galilea. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ngaa ni̱ gatúj Jesús chruhua si-nuhui Yanꞌanj. Ni̱ guiri sij ni tsínj mán duꞌuej rasu̱n nga̱ ni tsínj ránj rasu̱n nej. Ni̱ guru nitu sij ni mesa siꞌyaj ni tsínj naduna sanꞌanj. Ni̱ guru nitu Jesús ni chrun ruguechraꞌ siꞌyaj ni tsínj duꞌuej xuꞌma̱n anj. ");
INSERT INTO trq_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ni̱ gataj Jesús gunun ni sij: ―Gataj si-nu̱guanꞌ Yanꞌanj: “Ducuá Yanꞌanj huin rian ga̱chinj jniꞌyaj ni ngüi̱ rian Yanꞌanj. Sani̱ nuhui nan gahuin ꞌngo̱ huej ma̱n ni tsínj tu̱, ꞌyaj á re̱ꞌ nánj.” Gataj si-nu̱guanꞌ Yanꞌanj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ngaa ni̱ gatúj ni ngüi̱ duri nga̱ ni ngüi̱ nareꞌ dacój chruhua nuhui rian niquinꞌ Jesús. Ni̱ ganahuin ni sij, guiꞌyaj síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sani̱ gaꞌman ruhua ni chrej huin achij nga̱ ni tsínj digyán si-ley Moisés ngaa guiniꞌi ni sij si sa̱ꞌ guiꞌyaj Jesús. Ni̱ hué daj gaꞌman ruhua ni sij ngaa guiniꞌi ni sij sisi̱ gaꞌmi sa̱ꞌ ni tsinꞌ xiꞌí Jesús. Daj si gataj ni tsinꞌ daj: “Hosanna rian tsínj nan si huin síꞌ daꞌníj rey David”. Daj gataj aninꞌinj gaguáj aninꞌinj. ");
INSERT INTO trq_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ngaa ni̱ gataj ni sij gunun Jesús: ―Unun manꞌán re̱ꞌ si ataj ni tsinꞌ nan níꞌ. ―Daj gataj ni sij. Ni̱ gataj Jesús: ―Unūnj anj. Sani̱ nun ga̱ya ni é re̱ꞌ si-nu̱guanꞌ Yanꞌanj xiꞌí si ataj nuguanꞌ nan gunun ni é re̱ꞌ míꞌ. Daj si gataj si-nu̱guanꞌ Yanꞌanj: “Guiꞌyaj Yanꞌanj sisi̱ ga̱ꞌmi sa̱ꞌ ni lij nga̱ ni tsinꞌ utsi nuguanꞌ ga̱ranꞌ ruhua manꞌan Yanꞌanj gu̱nun”. Daj gataj si-nu̱guanꞌ Yanꞌanj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ngaa ni̱ dunáj Jesús ni sij. Ni̱ gahui sij xumanꞌ daj. Ni̱ ganꞌanj sij xumanꞌ Betania. Ni̱ gunáj sij yuꞌuj daj. ");
INSERT INTO trq_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ni̱ hua ni̱ganꞌ ango güi, ni̱ huaj Jesús nanica̱j sij xumanꞌ Jerusalén. Ni̱ achin xiꞌna̱ riqui sij. ");
INSERT INTO trq_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ni̱ guiniꞌi sij niquinꞌ ꞌngo̱ chrun gu̱ꞌnaj higuera duꞌua chrej. Ni̱ ganꞌanj nichi̱ sij rian niquinꞌ-ínꞌ. Sani̱ nun na̱riꞌ sij higo mánj. Maan coj raꞌa-áꞌ guiniꞌi sij nánj. Ngaa ni̱ gataj sij rian chrun daj: ―Ni̱ganj si̱ gayu chruj chra̱ re̱ꞌ ga̱ mánj. ―Daj gataj Jesús. Ni̱ ꞌngo̱ hora ganaco̱ chrun daj. ");
INSERT INTO trq_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ni̱ ngaa guiniꞌi ni tsínj nicoꞌ Jesús si guiranꞌ chrun daj, ni̱ gataj ni sij: ―Ni̱ u̱n sin ni̱ ꞌngo̱ hora ganacoj únj. ―Daj gataj ni sij ganꞌanj ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ngaa ni̱ gataj Jesús: ―Xa̱ngaꞌ atā gu̱nun ni é re̱ꞌ sisi̱ gu̱xuman ruhua ni é re̱ꞌ, ni̱ si̱ gani hui̱j ruhua ni é re̱ꞌ gui̱niꞌyaj ni é re̱ꞌ Yanꞌanj, ngaa ni̱ ga̱ꞌue gui̱ꞌyaj ni é re̱ꞌ si guiꞌyā nga̱ chrun higuera nan anj. Ni̱ sé urin nan ga̱ꞌue gui̱ꞌyaj ni é re̱ꞌ, sani̱ ga̱ꞌue ga̱taj ni é re̱ꞌ gu̱nun quij nan: “Gu̱xun re̱ꞌ manꞌán re̱ꞌ yuꞌuj nan ga̱nꞌanj re̱ꞌ ga̱natu re̱ꞌ chruhua nnee yanꞌanj anj.” Ngaa ni̱ hué daj ga̱huin. ");
INSERT INTO trq_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Hué dan ni̱ sisi̱ ga̱chinj jniꞌyaj ni é re̱ꞌ ꞌngo̱ nuguanꞌ rian Yanꞌanj ngaa guxuman yya ruhua ni é re̱ꞌ, ngaa ni̱ na̱huin raꞌa ni é re̱ꞌ nuguanꞌ da aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ni̱ ngaa gatúj Jesús chruhua nuhui digyán sij rian ni ngüi̱, ni̱ gahuin ni̱chrunꞌ ni chrej aꞌninꞌ nga̱ ni tsínj huin achij nej. Ni̱ nachínj snanꞌanj ni sij Jesús. Ni̱ gataj ni sij: ―Ni̱ u̱n sin huin sun ni̱ ꞌyáj re̱ꞌ nan únj. Ni̱ u̱n tsínj riqui sun, ni̱ ꞌyáj re̱ꞌ nan únj. ―Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ngaa ni̱ gataj Jesús: ―Ruhuāj ga̱nachinꞌ snanꞌanj ꞌngo̱ nuguanꞌ da manꞌan án re̱ꞌ aj. Ni̱ sisi̱ da̱nicaj ni é re̱ꞌ nuguanꞌ riānj, asíj ni̱ ga̱tā u̱n sun guiꞌyā nan gu̱nun ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ni̱ u̱n tsínj gaꞌninꞌ sun rian tsínj gu̱ꞌnaj Juan sisi̱ ga̱taꞌ nnee síꞌ ni ngüi̱ únj. Yanꞌanj gataj rian sij níꞌ. Asi̱ hua ango tsínj gataj rian sij sa̱ꞌ. ―Gataj Jesús. Ngaa ni̱ diguíj manꞌan ni sij nga̱ dugüiꞌ ni sij. Ni̱ gataj ni sij: ―Sisi̱ ga̱toꞌ sisi̱ Yanꞌanj gaꞌninꞌ sun rian Juan, ngaa ni̱ ga̱taj Jesús gu̱nun ni únj sisi̱ u̱n sin huin nun gu̱xuman ruhua ni únj ni̱ꞌyaj ni únj manꞌan sij únj. ");
INSERT INTO trq_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ni̱ sisi̱ ga̱taj únj sisi̱ ni tsínj gaꞌníj ga̱ꞌnaꞌ Juan, sani̱ xuꞌuiꞌ niꞌyaj únj rian ni ngüi̱ aj. Daj si gani ruhua daranꞌ ni ngüi̱ sisi̱ Juan gahuin ꞌngo̱ tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj anj. ―Daj gataj ni sij gunun ni dugüiꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ngaa ni̱ gataj ni sij gunun Jesús: ―Nun niꞌi únj mánj. ―Daj gataj ni sij gunun Jesús. Ngaa ni̱ gataj Jesús: ―Hué dan ni̱ si̱ gatā gu̱nun ni é re̱ꞌ u̱n sin huin sun ꞌyā aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ngaa ni̱ nachínj snanꞌanj Jesús ni tsínj daj. Ni̱ gataj sij: ―Da̱j ani ruhua ni é re̱ꞌ nga̱ nuguanꞌ nan únj. Hua hui̱j daꞌníj ꞌngo̱ tsínj daj. Ni̱ gataj sij rian ꞌngo̱ daꞌníj sij: “Daꞌnī, yya̱j ni̱ güi̱j gui̱ꞌyaj sún re̱ꞌ riqui coj uva aj.” Gataj tsínj daj gunun daꞌníj sij. ");
INSERT INTO trq_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","’Ngaa ni̱: “Si̱ ganꞌān mánj.” Gataj síꞌ rian chrej síꞌ. Sani̱ sa̱ꞌ sij, ni̱ xacaj sij ango ducuánj, ni̱ ganꞌanj gui̱ꞌyaj sun sij. ");
INSERT INTO trq_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Hué dan ni̱ ganꞌanj chrej sij rian nne ango daꞌníj sij. Ni̱ daꞌngaꞌ daj gataj sij gunun síꞌ. Ni̱: “Ga̱ꞌue ga̱nꞌān Señor.” Gataj síꞌ rian chrej síꞌ. Sani̱ nun ga̱nꞌanj gui̱ꞌyaj sun síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ni̱ u̱n tsínj yya guiꞌyaj si garanꞌ ruhua chrej sij, ruhua á re̱ꞌ únj. ―Daj gataj Jesús. Ngaa ni̱ gataj ni sij: ―Tsínj rian gataj sini ya̱n daj. Hué sij huin nánj. ―Daj gataj ni sij. Ngaa ni̱ gataj Jesús: ―Xa̱ngaꞌ atā gu̱nun ni é re̱ꞌ sisi̱ ga̱tu sini ya̱n ni tsínj aꞌnej xa̱can pesto nga̱ ni ngüi̱ xa̱na achéj manꞌan rian nicaj sun Yanꞌanj dan nga̱ si ga̱tu ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Daj si gaꞌna̱ꞌ Juan digyán síꞌ da̱j ga̱ꞌue gui̱man ni é re̱ꞌ gui̱ꞌyaj ni̱ca ni é re̱ꞌ. Sani̱ nun gu̱xuman ruhua ni é re̱ꞌ mánj. Sani̱ guxuman ruhua ni tsínj aꞌnej xa̱can pesto nga̱ ni ngüi̱ xa̱na achéj manꞌan. Ni̱ nu̱nj si guiniꞌi ni é re̱ꞌ daranꞌ nan, sani̱ nun na̱nicaj ruhua ni é re̱ꞌ xiꞌí si-ga̱quinꞌ ni é re̱ꞌ mánj. Ni̱ nun gu̱xuman ruhua ni é re̱ꞌ guiniꞌyaj ni é re̱ꞌ Juan nej mánj. ");
INSERT INTO trq_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Hué dan ni̱ gu̱nun ni é re̱ꞌ ango cuento nanīj. Ganarij ꞌngo̱ xuruꞌue daj nico coj uva unun sij aj. Ni̱ guiꞌyaj sij ꞌngo̱ xingá ganica̱j rian gunun sij. Ni̱ gánj sij yuꞌuj rian ga̱ni sij chruj uva, guiꞌyaj sij vino. Ni̱ guiꞌyaj sij ꞌngo̱ hueꞌ xa̱can xxi sisi̱ du̱gumi ni sij daranꞌ ni coj daj. Ni̱ nagaꞌuiꞌ sij si-coj sij coj chruj uva daj rian go̱ꞌngo ni tsínj sisi̱ du̱gumi ni síꞌ siꞌyaj sij. Ngaa ni ganꞌanj ga̱nꞌ sij ango xumanꞌ. ");
INSERT INTO trq_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ni̱ ngaa guisíj güi gane uva, ngaa ni̱ gaꞌníj sij si-moso sij ga̱nꞌanj ga̱chinj ni sij rian ni tsínj mán ꞌyaj sun daj chruj si huin siꞌyaj sij. ");
INSERT INTO trq_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Sani̱ guidaꞌa ni tsínj mán ꞌyaj sun daj ni si-moso sij. Ni̱ gaꞌuiꞌ ni síꞌ chrun xiráj ꞌngo̱ moso daj. Ni̱ dagahuiꞌ ni síꞌ ango moso. Ni̱ gaꞌuiꞌ ni síꞌ yej ango moso daj. ");
INSERT INTO trq_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ngaa ni̱ gaꞌníj ru̱huaꞌ yún tsínj do̱ꞌoj daj ango ni si-moso sij. Ni̱ hua gaꞌi̱ ni síꞌ daj nga̱ ni tsínj ganꞌanj sini. Ni̱ da̱j rúnꞌ guiꞌyaj ni tsínj dugumi daj, ni̱ daꞌngaꞌ daj guiꞌyaj ni sij nga̱ ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Hué dan ni̱ ne̱ꞌ ru̱cu ni̱ gaꞌníj sij manꞌan daꞌníj sij ga̱nꞌanj. Ni̱ gataj sij: “Ga̱ níꞌyanj ni síꞌ nga̱ manꞌan daꞌnī anj.” Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Sani̱ ngaa guiniꞌi ni síꞌ daꞌníj sij, ni̱ gataj ni síꞌ gunun ni dugüiꞌ síꞌ: “Tsínj nan gu̱nánj doꞌój chrej sij si sa̱ꞌ ga̱huiꞌ chrej síꞌ aj. Da̱gahuiꞌ néꞌ tsínj nan, ngaa ni gu̱nan néꞌ ga̱huin doꞌój néꞌ nánj.” Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ngaa ni̱ guidaꞌa ni sij tsínj daj. Ni̱ guereꞌej ni sij síꞌ chrej xe̱ꞌ duꞌua rian ma̱n coj uva daj. Ni̱ dagahuiꞌ ni sij síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Hué dan ni̱ ngaa ga̱ꞌnaꞌ tsínj do̱ꞌoj, ni̱ u̱n sin huin gui̱ꞌyaj sij nga̱ ni tsínj dugumi daj, ruhua á re̱ꞌ únj. ―Daj gataj Jesús gunun ni chrej aꞌninꞌ nga̱ ni tsínj huin achij. ");
INSERT INTO trq_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ngaa ni̱ gataj ni sij: ―Da̱gahuiꞌ sij ni tsínj xi̱ꞌi daj. Ni̱ si̱ ganahuin yaco ruhua sij ni̱ꞌyaj sij ni síꞌ ga̱ mánj. Ngaa ni̱ na̱gaꞌuiꞌ sij coj chruj uva daj huin si-coj sij rian ango ni tsínj sisi̱ du̱gumi ni síꞌ. Ni̱ ngaa ga̱ne chruj daj, ni̱ na̱gaꞌuiꞌ ni síꞌ rian tsínj do̱ꞌoj daj. ―Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ngaa ni̱ gataj Jesús: ―Ni̱ u̱n sin huin ni̱ nun ga̱ya ni é re̱ꞌ si gataj si-nu̱guanꞌ Yanꞌanj únj. Ni̱ gataj si-nu̱guanꞌ Yanꞌanj: Yej guereꞌej ni tsínj ꞌyaj sun hueꞌ, ni̱ ga̱huin-ínꞌ ꞌngo̱ yej sa̱ꞌ doj ga̱ne ran-ánꞌ du̱guꞌnunꞌ squina hueꞌ ni̱ganj ni aj. Hué manꞌan Señor guiꞌyaj nuguanꞌ nan. Ni̱ duguꞌna̱j ni̱nꞌ ruhua hua nuguanꞌ nan ruhua néꞌ aj. Daj gataj si-nu̱guanꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Hué dan ni̱ ga̱tā gu̱nun ni é re̱ꞌ sisi̱ ga̱ꞌne Yanꞌanj rian ga̱ne ni é re̱ꞌ rian nicaj sun Yanꞌanj. Ni̱ ga̱ꞌuiꞌ Yanꞌanj rian ango ni ngüi̱. Daj si gui̱ꞌyaj ni sij si huin ruhua Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ni̱ huēj huin yej daj. Ni̱ sisi̱ ga̱natu ꞌngo̱ ngüi̱ rian yej daj, ni̱ ga̱ranꞌ ni sij, gui̱ꞌyā. Ni̱ sisi̱ gui̱nij yej daj rian ꞌngo̱ ni ngüi̱, ni̱ gui̱xitinꞌ ni sij, gui̱ꞌyā nej aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ni̱ ngaa gunun ni chrej aꞌninꞌ nga̱ ni tsínj fariseo cuento ganani Jesús, ni̱ xacaj ni sij cuenta sisi̱ aꞌmi síꞌ xiꞌí manꞌan ni sij. ");
INSERT INTO trq_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ni̱ huin ruhua ni sij gui̱daꞌa ni sij síꞌ. Sani̱ xuꞌuiꞌ ni sij niꞌyaj ni sij rian ni ngüi̱. Daj si ani ruhua ni ngüi̱ sisi̱ tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj huin Jesús, ruhua ni sij aj. ");
INSERT INTO trq_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ngaa ni̱ gaꞌmi ru̱huaꞌ yún Jesús nani sij cuento. Ni̱ gataj sij: ");
INSERT INTO trq_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Da̱j rúnꞌ guiꞌyaj ꞌngo̱ rey ngaa guiꞌyaj sij guiꞌyanj xiꞌí si xa̱caj daꞌníj sij yunꞌunj xa̱na, ni̱ daꞌngaꞌ daj huin rian nicaj sun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ni̱ gaꞌníj rey daj si-moso sij ga̱nꞌanj ga̱quinj ni ngüi̱ sisi̱ ga̱ꞌnaꞌ ni sij xa̱ ni sij rian ga̱huin guiꞌyanj ducuá sij. Sani̱ nun ga̱ꞌuej ruhua ni sij ga̱ꞌnaꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ngaa ni̱ gaꞌníj ru̱huaꞌ yún sij ango ni moso daj ga̱nꞌanj ni síꞌ. Ni̱ gataj sij gunun ni síꞌ: “Ga̱taj ni é re̱ꞌ rian ni ngüi̱ ga̱ꞌnaꞌ daj sisi̱ hua chru̱n nia̱ ꞌyā. Ni̱ hua dagahuiꞌ ni sij ni dānj sicuj nga̱ ni xucu namij nej aj. Ni̱ hua chru̱n daranꞌanj. Ngaa ni̱ ga̱ꞌnaꞌ á re̱ꞌ xa̱ á re̱ꞌ nga̱ daꞌnī. Daj si xa̱caj sij yunꞌunj xa̱na.” Gataj rey daj gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","’Sani̱ nun xa̱caj ni ngüi̱ daj cuenta nga̱ nuguanꞌ gataj ni sij mánj. Ganꞌanj gui̱ꞌyaj sun ꞌngo̱ tsínj daj doꞌój sij. Ni̱ ganꞌanj ango sij, ganꞌanj gu̱duꞌue sij rasu̱n rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ni̱ guidaꞌa ango ni sij ni si-moso rey daj. Ni̱ guiꞌyaj xi̱ꞌi ni sij nga̱ ni síꞌ. Ni̱ dagahuiꞌ ni sij ni síꞌ nej. ");
INSERT INTO trq_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ngaa ni̱ ngaa gunun rey daj, ni̱ ni̱nꞌ ruhua gaꞌman ruhua sij. Ni̱ gaꞌníj sij si-snado sij ga̱nꞌanj da̱gahuiꞌ ni tsínj dagahuiꞌ ni si-moso sij daj. Ni̱ gari yanꞌa̱n ni síꞌ xánj ni tsínj daj. Ni̱ gaca xumanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","’Ngaa ni̱ gataj rey daj gunun si-moso sij: “Daranꞌanj hua chru̱n sisi̱ ga̱ꞌnaꞌ ni ngüi̱ xa̱ ni sij rian ga̱huin guiꞌyanj xa̱caj daꞌnī yunꞌunj xa̱na. Sani̱ nitaj si níꞌyanj ni ngüi̱ gaquīn ga̱ꞌnaꞌ da mánj. ");
INSERT INTO trq_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ngaa ni̱ ga̱nꞌanj ni é re̱ꞌ rian nacaj dugüiꞌ ni chrej. Ni̱ ga̱quinj ni é re̱ꞌ u̱n ngüi̱ ga̱huin ga̱ꞌnaꞌ ni sij guiꞌyanj ruhuāj aj.” Gataj rey daj. ");
INSERT INTO trq_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","’Ngaa ni̱ gahui ni moso daj ganꞌanj ni sij chruhua ni chrej. Ni̱ guiꞌyaj ni sij sisi̱ na̱huin chreꞌ daranꞌ ni ngüi̱ ganacaj dugüiꞌ nga̱ ni sij. Ni̱ gaꞌna̱ꞌ ni ngüi̱ sa̱ꞌ nga̱ ni ngüi̱ nitaj si hua sa̱ꞌ guiꞌyanj daj. Ni̱ gara chruhua hueꞌ rian gahuin guiꞌyanj xacaj daꞌníj rey daj yunꞌunj xa̱na, guiꞌyaj ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Ni̱ ngaa gatúj rey rian ma̱n ni ngüi̱ huaj guiꞌyanj daj, ni̱ guiniꞌi sij ꞌngo̱ tsínj nitaj nu̱n sij ꞌngo̱ atsij nu̱n ni tsínj raraꞌa. ");
INSERT INTO trq_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ngaa ni̱ gataj sij: “Amigo, u̱n sin ꞌyáj re̱ꞌ nan, ni̱ nitaj ꞌngo̱ atsij nanun so̱ꞌ raraꞌa so̱ꞌ únj.” Daj gataj rey daj. Sani̱ nun gui̱riꞌ ruhua tsínj daj si ga̱ꞌmi síꞌ. Ni̱ dínj nne síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ngaa ni̱ gataj rey gunun ni tsínj ꞌyaj sun rian mesa: “Nu̱mi ni é re̱ꞌ dacój sij nga̱ raꞌa sij. Ni̱ gue̱reꞌej a ni é re̱ꞌ sij rian ru̱miꞌ hua ne̱ꞌ xe̱ꞌ rian gu̱nun sij ga̱co sij nga̱ rian xa̱ ruj yanꞌ sij.” Daj gataj rey daj. ");
INSERT INTO trq_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Daj si nico ni ngüi̱ aquínj Yanꞌanj, sani̱ do̱j ni sij huin si nacui Yanꞌanj anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ngaa ni̱ ganꞌanj di̱gaꞌmi dugüiꞌ ni tsínj fariseo da̱j ga̱ꞌue ga̱ꞌuiꞌ ni sij gaquinꞌ rian xiꞌí Jesús xiꞌí ꞌngo̱ nuguanꞌ ga̱ꞌmi síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ngaa ni̱ gaꞌníj ni sij ni tsínj nicoꞌ ni sij nga̱ ni tsínj herodista nej, ganꞌanj ni síꞌ rian Jesús. Ni̱ gataj ni síꞌ gunun Jesús: ―Maestro, niꞌi ni únj sisi̱ aꞌmi xa̱ngaꞌ manꞌán re̱ꞌ. Ni̱ digyán xa̱ngaꞌ re̱ꞌ si-chrej Yanꞌanj. Ni̱ nitaj si gui̱ꞌyáj re̱ꞌ u̱n sin huin ni tsínj aꞌmi mánj. Daj si nitaj si niꞌyáj re̱ꞌ da̱j hua ni tsínj mánj. ");
INSERT INTO trq_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Hué dan ni̱ u̱n sin huin ani ruhuá re̱ꞌ. Sa̱ꞌ huin sisi̱ ga̱ꞌuiꞌ néꞌ sanꞌanj aꞌnej rey César, ruhuá re̱ꞌ. Ga̱ꞌuiꞌ néꞌ níꞌ. Asi̱ si̱ gaꞌuiꞌ néꞌ níꞌ. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Sani̱ guiniꞌi Jesús sisi̱ ani quij ruhua ni sij. Ngaa ni̱ gataj síꞌ gunun ni sij: ―Ni̱ u̱n sin huin ni̱ ruhua ni é re̱ꞌ gui̱ꞌyáj re̱ꞌ xiꞌ ngāj únj. Tsínj digyaꞌ yunꞌunj huin ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Di̱gyán ni é re̱ꞌ riānj ꞌngo̱ sanꞌanj naruꞌue ni ngüi̱ rian rey daj. ―Daj gataj Jesús. Ngaa ni̱ nicaj ni sij ꞌngo̱ sanꞌanj denario gaꞌna̱ꞌ ni sij rian síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ngaa ni̱ nachínj snanꞌanj Jesús ni sij. Ni̱ gataj síꞌ: ―Ni̱ u̱n tsínj ri̱an huin sanꞌanj nan únj. Ni̱ u̱n tsínj si-xugüi huin nan, ni̱ hua ni̱ca ni̱nꞌ huaj únj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ngaa ni̱: ―Hué rian César nga̱ si-xugüi síꞌ huin. ―Gataj ni sij. Ngaa ni̱ gataj Jesús: ―Ngaa ni̱ ga̱ꞌuiꞌ ni é re̱ꞌ siꞌyaj rey César daj rian César aj. Ni̱ ga̱ꞌuiꞌ ni é re̱ꞌ siꞌyaj Yanꞌanj rian Yanꞌanj anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ni̱ ngaa gunun ni sij nuguanꞌ gaꞌmi Jesús, ni̱ garáj yanꞌanj ruhua ni sij. Ni̱ dunáj ni sij síꞌ. Ni̱ ganꞌanj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ni̱ hué güi daj ni̱ gaꞌna̱ꞌ do̱j ni tsínj saduceo rian Jesús. Ni̱ ataj ni tsínj daj sisi̱ nitaj si ga̱naꞌnij ni níman mánj. Ni̱ nachínj snanꞌanj ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ni̱ gataj ni sij: ―Maestro, gataj Moisés: “Sisi̱ ga̱huiꞌ ꞌngo̱ tsínj nitaj daꞌníj, ngaa ni̱ na̱caj jnánj sij nica̱ sij. Ni̱ daꞌngaꞌ daj gui̱ꞌyaj síꞌ ga̱ꞌuiꞌ síꞌ si ga̱ꞌnga ꞌngo̱ lij na̱gane ya̱n duꞌua chre.” Daj gataj Moisés. ");
INSERT INTO trq_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Hué dan ni̱ gane ichij jna̱nj ꞌngo̱ tsínj daj scanij néꞌ. Ni̱ xacaj tsínj xa̱huaꞌ nica̱ sij. Ni̱ gahuiꞌ sij. Ni̱ nitaj daꞌníj sij nga̱ únꞌ. Ni̱ gunáj nica̱ sij rian jnánj sij xacaj síꞌ xacoꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Sani̱ gahuiꞌ tsínj nicoꞌ ru̱cu tsínj xa̱huaꞌ daj. Ni̱ xacaj ango jnánj síꞌ yunꞌunj xa̱na daj. Ni̱ daꞌngaꞌ daj xacaj ni ichij jna̱nj tsínj yunꞌunj xa̱na daj. ");
INSERT INTO trq_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Daꞌ guisíj daj gahuiꞌ manꞌan yunꞌunj daj nej aj. ");
INSERT INTO trq_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Hué dan ni̱ ngaa ga̱naꞌnij ni níman ngaa gui̱man ru̱huaꞌ yún ichij jnánj sij, ni̱ da̱j hua yya tsínj ga̱huin nica̱ yunꞌunj xa̱na daj, ruhuá re̱ꞌ únj. Daj si daranꞌ ni sij xacaj únꞌ nánj. ―Daj gataj ni tsínj saduceo gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ngaa ni̱ gataj Jesús: ―Nun na̱riꞌ ni é re̱ꞌ si nun niꞌi ni é re̱ꞌ da̱j gataj si-nu̱guanꞌ Yanꞌanj mánj. Ni̱ nun niꞌi ni é re̱ꞌ da̱j nucuaj Yanꞌanj nej mánj. ");
INSERT INTO trq_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Daj si ngaa ga̱naꞌnij ni níman, ni̱ si̱ xacaj ni tsínj ni yunꞌunj xa̱na mánj. Ni̱ da̱j ni̱ si̱ xacaj ni yunꞌunj xa̱na tsínj snoꞌo mánj. Daj si da̱j rúnꞌ nne ni ángel xataꞌ, daꞌngaꞌ daj ga̱ne ni sij aj. ");
INSERT INTO trq_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ngaa ni̱ ga̱tā gu̱nun a ni é re̱ꞌ da̱j gui̱niꞌi a ni é re̱ꞌ sisi̱ ga̱naꞌnij ni níman. Achin si ga̱ya ni é re̱ꞌ rian si-nu̱guanꞌ Yanꞌanj ga̱ꞌ di níꞌ. ");
INSERT INTO trq_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Daj si gataj Yanꞌanj: “Huēj huin Danꞌanj tsínj gu̱ꞌnaj Abraham nga̱ tsínj gu̱ꞌnaj Isaac nga̱ tsínj gu̱ꞌnaj Jacob nej aj.” Daj gataj Yanꞌanj asi̱j ná. Hué dan ni sé níman huin ni tsínj guinicoꞌ Yanꞌanj asi̱j ná mánj. Hua ni̱ꞌnaꞌ ni sij nánj. ―Daj gataj Jesús gunun ni tsínj saduceo. ");
INSERT INTO trq_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ni̱ ngaa gunun ni ngüi̱ si gataj Jesús, ni̱ garáj yanꞌanj ruhua ni sij nga̱ nuguanꞌ digyán sij rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ni̱ ngaa gunun ni tsínj fariseo sisi̱ dínj gahuin duꞌua ni tsínj saduceo, guiꞌyaj Jesús, ngaa ni̱ nahuin yuꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ni̱ ꞌngo̱ ni sij huin ꞌngo̱ tsínj digyán ley rian ni ngüi̱. Ni̱ huin ruhua síꞌ xa̱caj síꞌ cuenta da̱j na̱taꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ngaa ni̱ nachínj snanꞌanj síꞌ Jesús. Ni̱ gataj síꞌ: ―Maestro, u̱n sin huin nuguanꞌ nico doj rian daranꞌ nuguanꞌ aꞌninꞌ Yanꞌanj sun riunꞌ únj. ―Daj gataj tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ngaa ni̱ gataj Jesús: ―“Ga̱huin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ Señor huin Danꞌánj re̱ꞌ nga̱ nimán re̱ꞌ nej, ni̱nꞌ staꞌngáꞌ re̱ꞌ nej.” ");
INSERT INTO trq_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hué nan huin nuguanꞌ huin achij nga̱ nuguanꞌ sini rian daranꞌ ni nuguanꞌ aꞌninꞌ Yanꞌanj sun rian ni ngüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ni̱ da̱j rúnꞌ hua nuguanꞌ nan, ni̱ hua ango nuguanꞌ aꞌninꞌ Yanꞌanj sun rián re̱ꞌ nej. Ni̱ nuguanꞌ nan huin: “Ga̱huin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyáj re̱ꞌ dugüíꞌ re̱ꞌ rúnꞌ ꞌi̱ ruhuá re̱ꞌ niꞌyaj re̱ꞌ manꞌán re̱ꞌ aj.” ");
INSERT INTO trq_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ngaa ni̱ daranꞌ si-ley Yanꞌanj nga̱ daranꞌ si gaꞌmi ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná, ni̱ ꞌna̱ꞌ daranꞌ ni nuguanꞌ daj rian nu̱ngüej nuguanꞌ huin achij nan. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ngaa ni̱ ngaa nahuin yuꞌ ni tsínj fariseo, ni̱ nachínj snanꞌanj Jesús ni sij. ");
INSERT INTO trq_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ni̱ gataj Jesús: ―Ni̱ u̱n sin huin ani ruhua ni é re̱ꞌ xiꞌí Cristo únj. Ni̱ u̱n sin da̱ꞌnij huin síꞌ, ruhua ni é re̱ꞌ únj. ―Daj gataj Jesús. Ngaa ni̱: ―Daꞌníj David huin síꞌ. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ngaa ni̱ gataj Jesús: ―Ngaa ni̱ sisi̱ Cristo huin daꞌníj David, ni̱ u̱n sin huin, ni̱ gataj David sisi̱ Cristo huin Señor rian sij únj. Daj si hua ꞌngo̱ nuguanꞌ gataj David, guiꞌyaj Espíritu Santo: ");
INSERT INTO trq_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Yanꞌanj gataj gunun Señor nicaj sun riānj sisi̱ ga̱ne síꞌ chrej raꞌa sa̱ꞌ Yanꞌanj daꞌ gui̱sij gui̱ꞌyaj gana Yanꞌanj rian daranꞌ ni tsínj ununꞌ nga̱ Señor nicaj sun riānj.” Daj gataj Yanꞌanj gunun Señor, gataj xíꞌ David. ");
INSERT INTO trq_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Asa̱ꞌ ga̱ꞌue ga̱huin Cristo daꞌníj David sisi̱ duguꞌna̱j síꞌ Señor manꞌan Cristo únj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ni̱ nun riꞌ ruhua ni tsínj fariseo si ga̱ꞌmi ni sij. Ni̱ asi̱j güi daj, ni̱ nun gui̱sij ruhua ni sij na̱chinꞌ snanꞌanj ni sij Jesús ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ngaa guisíj ni̱ gaꞌmi Jesús rian ni ngüi̱ nga̱ rian ni tsínj nicoꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ni̱ gataj sij: ―Nicaj sun ni tsínj digyán ley nga̱ ni tsínj fariseo da̱j rúnꞌ guinicaj sun Moisés. ");
INSERT INTO trq_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yuꞌuj daj ni̱ da̱gahuin ni é re̱ꞌ rian ni sij. Ni̱ gui̱ꞌyaj ni é re̱ꞌ si ataj ni sij. Sani̱ si̱ gachej ni é re̱ꞌ chrej chéj ni sij. Daj si ataj ni sij ꞌngo̱ nuguanꞌ, ni̱ ꞌyaj ni sij ango nuguanꞌ. ");
INSERT INTO trq_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ni̱ da̱j rúnꞌ ꞌyaj ꞌngo̱ tsínj ngaa yaꞌi̱ ꞌngo̱ carga ga̱ta ꞌngo̱ dugüiꞌ síꞌ, ꞌyaj síꞌ, ni̱ daꞌngaꞌ daj ꞌyaj ni sij. Daj si ꞌyaj ni sij sisi̱ ga̱ta ni ngüi̱ carga yaꞌi̱ huin ni nuguanꞌ aꞌninꞌ ni sij sun rian ni síꞌ. Ni̱ utaꞌ ni sij carga daj dacan xicój ni síꞌ. Sani̱ a doj naꞌuej ruhua ni sij chra̱cuij ni sij chra̱ raꞌa ni sij nga̱ carga daj. ");
INSERT INTO trq_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ni̱ daranꞌ si ꞌyaj ni sij, ni̱ daꞌngaꞌ daj ꞌyaj ni sij sisi̱ gui̱niꞌi ni ngüi̱. Ni̱ naguiꞌyaj garaꞌ ni sij rian nu̱n si-nu̱guanꞌ Yanꞌanj nu̱n yo ni sij. Ni̱ hué daj naguiꞌyaj xe̱ꞌe ni sij yuꞌuej nicoꞌ duꞌua si-ganꞌ ni sij nej. ");
INSERT INTO trq_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ni̱ nanaꞌuiꞌ ni sij ꞌngo̱ yuꞌuj sa̱ꞌ ga̱ne ni sij rian ꞌyaj ni sij ꞌngo̱ guiꞌyanj. Ni̱ hué daj nanaꞌuiꞌ ni sij sisi̱ ga̱ne ni sij chrun xila sa̱ꞌ chruhua si-nuhui ni sij nej. ");
INSERT INTO trq_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ni̱ huin ruhua ni sij sisi̱ ga̱ꞌmi sa̱ꞌ ni ngüi̱ nga̱ ni sij ngaa chéj ni sij rian yuꞌue̱. Ni̱ hué daj huin ruhua ni sij sisi̱ du̱guꞌnaj ni tsínj “maestro” ni sij. ");
INSERT INTO trq_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Si̱ duna ni é re̱ꞌ si ga̱taj ni ngüi̱ sisi̱ “maestro” huin ni é re̱ꞌ mánj. Daj si ꞌngo̱ jna̱nj daranꞌ ni é re̱ꞌ. Ni̱ urin maestro huin Cristo rian ni é re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ni̱ si̱ duguꞌna̱j ni é re̱ꞌ “chrej” ꞌngo̱ tsínj ma̱n chruhua xungüi̱ mánj. Daj si urin chrej ni é re̱ꞌ huin Yanꞌanj xa̱ngaꞌ nne xataꞌ. ");
INSERT INTO trq_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ni̱ si̱ duna ni é re̱ꞌ si ga̱taj ni ngüi̱ sisi̱ nicoꞌ ni sij ni é re̱ꞌ mánj. Daj si urin Cristo huin tsínj gui̱nicoꞌ ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ni̱ tsínj huin achij scanij ni é re̱ꞌ, ni̱ daꞌui sij gu̱nánj guitsi sij rian ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Daj si u̱n tsínj huin ruhua ga̱huin achij, ni̱ gu̱naj sij ne̱ꞌ ru̱cu. Ni̱ u̱n tsínj huin ruhua gu̱naj ne̱ꞌ ru̱cu, ni̱ ga̱huin achij sij. ");
INSERT INTO trq_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Sani̱ niqui ni̱nꞌ ruhua niman ni é re̱ꞌ huin ni é re̱ꞌ tsínj digyán ley nga̱ ni tsínj fariseo nej. Daj si ga̱huin ni é re̱ꞌ nico castigo. Tsínj digyaꞌ yunꞌunj huin ni é re̱ꞌ. Daj si ránj ni é re̱ꞌ chrej rian nicaj sun Yanꞌanj. Ni̱ naꞌue ga̱tu ni ngüi̱, ꞌyaj ni é re̱ꞌ. Ni̱ naꞌuej ruhua ni é re̱ꞌ ga̱tu ni é re̱ꞌ. Ni̱ daꞌngaꞌ daj huin ruhua ni ngüi̱ ga̱tu, ni̱ naꞌuej ruhua ni é re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Niqui ni̱nꞌ ruhua niman ni é re̱ꞌ huin ni é re̱ꞌ ni tsínj digyán ley nga̱ ni tsínj fariseo nej. Tsínj digyaꞌ yunꞌunj huin ni é re̱ꞌ. Daj si aꞌnej ni é re̱ꞌ ducuá ngüi̱ xa̱na mmij. Ngaa ni̱ ná achínj jniꞌyaj ni é re̱ꞌ rian Yanꞌanj sisi̱ ga̱ni ruhua ni ngüi̱ sisi̱ sa̱ꞌ ni é re̱ꞌ. Xiꞌí nuguanꞌ nan, ni̱ ga̱huin ni é re̱ꞌ nico castigo. ");
INSERT INTO trq_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Niqui ni̱nꞌ ruhua niman ni é re̱ꞌ huin ni é re̱ꞌ ni tsínj digyán ley nga̱ ni tsínj fariseo nej. Daj si gui̱ranꞌ ni é re̱ꞌ nico castigo. Tsínj digyaꞌ yunꞌunj huin ni é re̱ꞌ. Daj si ni̱nꞌ ga̱chraꞌ achéj ni é re̱ꞌ. Ni̱ da ru̱cu nnee yanꞌanj huaj ni é re̱ꞌ sisi̱ xa̱caj urin tsínj si-chrej ni é re̱ꞌ, ruhua ni é re̱ꞌ. Ni̱ ngaa gui̱riꞌ ni é re̱ꞌ, ni̱ ga̱huin quij chruhua niman síꞌ si quij niman manꞌan ni é re̱ꞌ, ꞌyaj ni é re̱ꞌ. Ni̱ guita̱j diya̱n síꞌ ga̱nꞌanj síꞌ rian ni é re̱ꞌ ga̱nꞌanj daranꞌ ni é re̱ꞌ rian yanꞌa̱n. ");
INSERT INTO trq_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Niqui ni̱nꞌ ruhua niman ni é re̱ꞌ xiꞌí sayun gui̱ranꞌ ni é re̱ꞌ. Daj si ni tsínj duri digyán chrej rian ni ngüi̱ huin ni é re̱ꞌ. Ni̱ ataj ni é re̱ꞌ sisi̱ gu̱taꞌ ni̱ca yya ꞌngo̱ tsínj daj rian oro ma̱n chruhua nuhui, ngaa ni̱ níꞌyanj si ataj síꞌ. Ni̱ hua nia̱n gui̱ꞌyaj síꞌ si gataj síꞌ, ataj ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tsínj ni̱ꞌyun ni tsínj duri huin ni é re̱ꞌ nánj. Da̱j hua si huin achij, ruhua ni é re̱ꞌ únj. Oro níꞌ, asi̱ nuhui ꞌyaj sisi̱ sa̱ꞌ oro sa̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ni̱ hué daj ataj ni é re̱ꞌ sisi̱ gu̱taꞌ ni̱ca yaa ꞌngo̱ tsínj daj rian altar sisi̱ hua yya nuguanꞌ gaꞌmi síꞌ, ni̱ nitaj si níꞌyanj si ataj sij mánj. Sani̱ sisi̱ gu̱taꞌ ni̱ca yya ꞌngo̱ tsínj daj rian ofrenda ta̱j rian altar, ngaa ni̱ níꞌyanj si ataj sij, ni̱ hua nia̱n gui̱ꞌyaj síꞌ si gataj síꞌ, ataj ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tsínj ni̱ꞌyun ni̱ tsínj duri huin ni é re̱ꞌ. Da̱j hua si huin achij, ruhua ni é re̱ꞌ únj. Ofrenda níꞌ, asi̱ altar ꞌyaj sisi̱ sa̱ꞌ ofrenda daj sa̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tsínj gu̱taꞌ ni̱ca yya rian altar, ni̱ nitaj si gu̱taꞌ ni̱ca yya sij rian urin altar, sani̱ gu̱taꞌ ni̱ca yya sij rian daranꞌ si mán rian altar nej. ");
INSERT INTO trq_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ni̱ tsínj gu̱taꞌ ni̱ca yya rian nuhui, ni̱ sé rian urin nuhui gu̱taꞌ ni̱ca yya sij. Sani̱ gu̱taꞌ ni̱ca yya sij rian Yanꞌanj xa̱ngaꞌ nne chruhua nuhui nej. ");
INSERT INTO trq_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ni̱ tsínj gu̱taꞌ ni̱ca yya xataꞌ rian nne chrun xila sa̱ꞌ nne Yanꞌanj, ni̱ sé urin rian chrun xila sa̱ꞌ nne Yanꞌanj gu̱taꞌ ni̱ca yya sij mánj. Sani̱ hué daj gu̱taꞌ ni̱ca yya sij rian manꞌan Yanꞌanj si nne rian chrun xila sa̱ꞌ da nej. ");
INSERT INTO trq_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Ni̱nꞌ ruhua niqui niman ni é re̱ꞌ ni tsínj digyán ley nga̱ ni tsínj fariseo. Daj si gui̱ranꞌ a ni é re̱ꞌ nico castigo. Tsínj digyaꞌ yunꞌunj huin ni é re̱ꞌ. Daj si aya ni é re̱ꞌ rumi coj nun stila nga̱ coj xugune rian yoꞌój nej nga̱ coj comino nej. Ni̱ ngaa guisíj ichiꞌ rumi, ni̱ aꞌuiꞌ ni é re̱ꞌ ꞌngo̱ rumi rian Yanꞌanj. Sani̱ duna ni é re̱ꞌ nuguanꞌ huin rian chruhua si-ley Yanꞌanj nej. Daj si duna ni é re̱ꞌ si gui̱ꞌyaj ni̱ca ni é re̱ꞌ rian ni ngüi̱. Ni̱ duna ni é re̱ꞌ si ga̱huin ꞌi̱ ruhua ni é re̱ꞌ ni̱ꞌyaj á re̱ꞌ Yanꞌanj. Ni̱ duna ni é re̱ꞌ si gu̱xuman ruhua ni é re̱ꞌ ni̱ꞌyaj á re̱ꞌ Yanꞌanj. Daꞌui ni é re̱ꞌ gui̱ꞌyaj ni é re̱ꞌ ni nuguanꞌ nico nan. Sani̱ si̱ duna ni é re̱ꞌ nga̱ ango si ꞌyaj ni é re̱ꞌ da mánj. ");
INSERT INTO trq_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ni̱ huin ni é re̱ꞌ tsínj duri digyán chrej rian ni ngüi̱. Ni̱ aca ni é re̱ꞌ nnee ma̱n xucu xaꞌui sisi̱ na̱huin sa̱ꞌ nnee daj go̱ꞌo ni é re̱ꞌ. Sani̱ amánj gue̱ é re̱ꞌ xucu xa̱chij huin camello. ");
INSERT INTO trq_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Niqui ni̱nꞌ ruhua niman ni é re̱ꞌ huin ni é re̱ꞌ ni tsínj digyán ley nga̱ ni tsínj fariseo. Daj si gui̱ranꞌ ni é re̱ꞌ nico castigo nej aj. Tsínj digyaꞌ yunꞌunj huin ni é re̱ꞌ. Daj si ꞌyaj á re̱ꞌ da̱j rúnꞌ ꞌyaj ꞌngo̱ tsínj naꞌninꞌ xiráj tasa nga̱ xiráj goꞌo nej aj. Sani̱ nun na̱ꞌninꞌ sij chruhua tasa nga̱ chruhua goꞌo mánj. Ni̱ daꞌngaꞌ daj hua chru̱hua niman ni é re̱ꞌ. Ni̱ ma̱n ni̱nꞌ ruhua si quij hua. Daj si ꞌyaj tu̱ ni é re̱ꞌ. Ni̱ ꞌyaj quij ni é re̱ꞌ nga̱ ni ngüi̱ nej. ");
INSERT INTO trq_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Tsínj fariseo duri huin ni é re̱ꞌ. Hua sini na̱ꞌninꞌ sa̱ꞌ ni é re̱ꞌ chruhua tasa nga̱ goꞌo huin niman án re̱ꞌ. Asíj ni̱ ga̱ꞌue gui̱ꞌyaj sa̱ꞌ ni é re̱ꞌ gui̱niꞌi ni ngüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Niqui niman ni̱nꞌ ruhua ni é re̱ꞌ huin ni é re̱ꞌ ni tsínj digyán ley nga̱ ni tsínj fariseo. Daj si gui̱ranꞌ ni é re̱ꞌ nico sayun. Huin ni é re̱ꞌ ni tsínj digyaꞌ yunꞌunj. Daj si da̱j rúnꞌ hua chran gatsi̱ naránj ni sij rian achinꞌ níman, ni̱ daꞌngaꞌ daj hua ni é re̱ꞌ. Daj si xa̱ngaꞌ ni̱ hua nia̱ꞌ xiráj chran aráj ni sij daj. Sani̱ ne̱ꞌ chru̱hua yuꞌuj ni̱ ma̱n ni̱nꞌ ni cúj níman nga̱ daranꞌ si quij hua. ");
INSERT INTO trq_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ni̱ daꞌngaꞌ daj hua á re̱ꞌ. Daj si rúnꞌ hua tsínj ꞌyaj ni̱ca, ni̱ daꞌngaꞌ daj hua ni é re̱ꞌ rian ni ngüi̱. Sani̱ chruhua niman ni é re̱ꞌ, ni̱ ma̱n ni̱nꞌ ruhua nuguanꞌ digyaꞌ yunꞌunj nga̱ ni nuguanꞌ quij aj. ");
INSERT INTO trq_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Niqui ni̱nꞌ ruhua ni é re̱ꞌ huin ni é re̱ꞌ ni tsínj digyán ley nga̱ ni tsínj fariseo. Daj si ga̱huin ni é re̱ꞌ castigo nico. Tsínj digyaꞌ yunꞌunj huin ín re̱ꞌ. Daj si naránj án re̱ꞌ chran rian gachinꞌ ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. Ni̱ naguiꞌyaj nia̱ꞌ ni é re̱ꞌ xiráj chran rian gachinꞌ ni tsínj hua sa̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ni̱ ataj ni é re̱ꞌ: “Sisi̱ nu̱n gui̱man únj asi̱j ngaa guimán ni xíꞌ, ni̱ tsínj guimán asi̱j ná, ni̱ si̱ chracuij únj dagahuiꞌ ni sij ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj mánj.” Daꞌngaꞌ daj ataj ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sani̱ hué ducuánj daj digyán xa̱ngaꞌ a ni é re̱ꞌ sisi̱ hué ni é re̱ꞌ huin yya daꞌníj ni tsínj dagahuiꞌ ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Achin gui̱sij si guiꞌyaj quij ni xi a ni é re̱ꞌ. Sani̱ guiꞌyaj a ni é re̱ꞌ nga̱ si achin daj. ");
INSERT INTO trq_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Xucuáj huin ni é re̱ꞌ. Ni̱ daꞌníj xucuáj huin ni é re̱ꞌ aj. Ni̱ da̱j gui̱ꞌyaj ni é re̱ꞌ sisi̱ si̱ gahuin ni é re̱ꞌ castigo rian yanꞌa̱n únj. ");
INSERT INTO trq_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Xiꞌí daj ni̱ aꞌnī ni tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj nga̱ ni tsínj niꞌi sa̱ꞌ nej, nga̱ ni tsínj digyán si-nu̱guanꞌ Yanꞌanj rian ni ngüi̱. Ni̱ gui̱sij ni sij rian ma̱n ni é re̱ꞌ aj. Sani̱ hua go̱ꞌngo ni sij da̱gahuiꞌ ni é re̱ꞌ aj. Ni̱ do̱coꞌ ni é re̱ꞌ ni sij rian rugutsi̱. Ni̱ du̱guayun ni é re̱ꞌ ango ni sij chruhua si-nuhui ni é re̱ꞌ. Ni̱ gui̱nicoꞌ ni é re̱ꞌ ni sij daranꞌ xumanꞌ chra̱nꞌ yunꞌunj ni é re̱ꞌ ni sij nej. ");
INSERT INTO trq_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ngaa ni̱ xiꞌí daj daꞌui ni é re̱ꞌ si-ga̱quinꞌ daranꞌ ni tsínj dagahuiꞌ ni ngüi̱ hua sa̱ꞌ. Ni̱ asi̱j sini dagahuiꞌ tsínj gu̱ꞌnaj Caín jnánj sij Abel. Ni̱ hué síꞌ gahuin ꞌngo̱ tsínj guiꞌyaj ni̱ca. Ni̱ hué daj dagahuiꞌ ni xi ni é re̱ꞌ tsínj gu̱ꞌnaj Zacarías huin síꞌ daꞌníj Berequías. Ni̱ dagahuiꞌ ni sij síꞌ rian da̱ni altar nga̱ rian nne ducuá Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Xa̱ngaꞌ atāj yyāj gu̱nun a ni é re̱ꞌ sisi̱ gui̱ranꞌ ni du̱guiꞌ ni é re̱ꞌ castigo xiꞌí si-ga̱quinꞌ ni tsínj dagahuiꞌ daj. ―Daj gataj Jesús rian ni tsínj fariseo nga̱ ni tsínj digyán si-ley Moisés rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús: ―Nun na̱ni ducu ruhuāj xiꞌí ni é re̱ꞌ ni tsínj ma̱n xumanꞌ Jerusalén. Daj si dagahuiꞌ ni é re̱ꞌ ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj anj. Ni̱ gaꞌuiꞌ ni é re̱ꞌ yej ni tsínj nicaj nuguanꞌ huaj rian ni é re̱ꞌ huin ni sij tsínj gaꞌníj Yanꞌanj huaj rian a ni é re̱ꞌ. Síj u̱ndaj huin ruhuāj na̱guiꞌyaj yuꞌūj, ni̱ daꞌníj manꞌán re̱ꞌ huin ni tsínj ma̱n xumanꞌ Jerusalén. Ni̱ da̱j rúnꞌ ꞌyaj ꞌngo̱ xuchre ngaa naguiꞌyaj yuꞌuj xuj daꞌníj xuj riqui si-gachi xuj, ni̱ daꞌngaꞌ daj huin ruhuāj gui̱ꞌyā nga̱ ni daꞌníj re̱ꞌ. Sani̱ nun ga̱ranꞌ ruhua á re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yya̱j ni̱ ni̱ꞌyaj ni é re̱ꞌ. Gue̱reꞌ xánj ni é re̱ꞌ nga̱ ducuá ni é re̱ꞌ guna yya̱j aj. ");
INSERT INTO trq_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ni̱ ataj snanꞌān gu̱nun ni é re̱ꞌ sisi̱ si̱ guiniꞌi yún ni é re̱ꞌ yūnj da gui̱sij güi ga̱taj ni é re̱ꞌ nuguanꞌ nan: “Hua sa̱ꞌ ni̱nꞌ ruhua tsínj ꞌna̱ꞌ rian si-xugüi manꞌan Señor.” ―Daj gataj Jesús gunun ni ngüi̱ ma̱n xumanꞌ Jerusalén. ");
INSERT INTO trq_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ni̱ ngaa gahui Jesús chruhua nuhui nico ganꞌanj sij, ni̱ gahuin ni̱chrunꞌ ni tsínj nicoꞌ sij sisi̱ di̱gyán ni síꞌ da̱j hua ni hueꞌ huin nuhui daj rian Jesús. ");
INSERT INTO trq_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Sani̱ gataj Jesús gunun ni síꞌ: ―Gui̱niꞌyaj sa̱ꞌ ni é re̱ꞌ daranꞌ nan anj. Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ hua ꞌngo̱ güi, ni̱ si̱ gunáj ni a̱ ꞌngo̱ yej rian dugüiꞌ mánj. Du̱guane ni̱nꞌ ni sij daranꞌ nánj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ni̱ ngaa gane Jesús dacan gu̱ꞌnaj Olivos, ni̱ gaꞌna̱ꞌ urin ni tsínj nicoꞌ Jesús rian nne sij. Ni̱ gataj ni síꞌ: ―Ga̱taj re̱ꞌ gu̱nun únj a̱man ga̱huin yya ni nuguanꞌ nan. Ni̱ ga̱taj re̱ꞌ da̱j hua ꞌngo̱ daꞌngaꞌ gui̱niꞌi únj sisi̱ ga̱ꞌnaꞌ ru̱huaꞌ yún re̱ꞌ ngaa ga̱nahuij xungüi̱ nan. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ngaa ni̱ gataj Jesús: ―Ga̱ cuidado ni é re̱ꞌ sisi̱ nitaj ꞌngo̱ tsínj di̱gyaꞌ yunꞌunj ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Daj si ga̱ꞌnaꞌ nico ni tsínj rian si-xugüi manꞌānj anj. Ni̱ ga̱taj ni sij: “Hué manꞌānj huin Cristo aj.” Daj ga̱taj ni sij gu̱nun ni é re̱ꞌ. Ni̱ di̱gyaꞌ yunꞌunj ni sij nico ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","’Ni̱ gu̱nun ni é re̱ꞌ nuguanꞌ sisi̱ ununꞌ ꞌngo̱ xumanꞌ nga̱ ango xumanꞌ, ni̱ huin ruhua ꞌngo̱ xumanꞌ daj gu̱daꞌ nga̱ ango xumanꞌ. Sani̱ si̱ guxuꞌuiꞌ ni é re̱ꞌ mánj. Hua nia̱n si hué daj ga̱huin. Sani̱ achin ga̱nahuij ni̱nꞌ xungüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ni̱ gu̱nunꞌ nu̱ngüej xumanꞌ daj. Ni̱ gu̱nunꞌ ꞌngo̱ gobierno da nga̱ ango gobierno. Ni̱ ga̱ꞌnaꞌ xiꞌi̱ nga̱ xiꞌna̱ nej. Ni̱ ga̱ꞌnaꞌ yún go̱ꞌngo rian xungüi̱ nej. ");
INSERT INTO trq_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Daranꞌ nan ni̱ diaj gaxi̱ꞌi gui̱ranꞌ ni ngüi̱ sayun. ");
INSERT INTO trq_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Hué dan ni̱ na̱gaꞌuiꞌ ni sij ni é re̱ꞌ rian ni tsínj nicaj sun. Ni̱ gui̱ranꞌ ni é re̱ꞌ sayun nej. Ni̱ da̱gahuiꞌ ni sij ni é re̱ꞌ nej. Ni̱ si̱ gahuin sa̱ꞌ ruhua daranꞌ ni ngüi̱ gui̱niꞌyaj ni sij ni é re̱ꞌ xiꞌí si nicaj dugüiꞌ ni é re̱ꞌ ngāj. ");
INSERT INTO trq_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ngaa ni̱ ni güi daj, ni̱ nico ni ngüi̱ du̱na si-chrej Yanꞌanj. Ni̱ na̱gaꞌuiꞌ ni sij dugüiꞌ ni sij rian ni tsínj nicaj sun. Ni̱ si̱ gahuin sa̱ꞌ ruhua ni sij gui̱niꞌyaj ni sij go̱ꞌngo dugüiꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ni̱ ga̱ꞌnaꞌ nico ni tsínj di̱gyaꞌ yunꞌunj. Ni̱ ga̱taj ni sij sisi̱ aꞌmi ni sij si-nu̱guanꞌ Yanꞌanj. Ni̱ di̱gyaꞌ yunꞌunj ni sij nico ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ni̱ xiꞌí si ga̱huin nico gaquinꞌ, ni̱ du̱na nico ni sij si ga̱huin ꞌi̱ ruhua ni sij gui̱niꞌyaj ni sij ni dugüiꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Sani̱ ni ngüi̱ huaj nicoꞌ yya ni̱nꞌ si-chrej Yanꞌanj da güi ga̱nahuij xungüi̱, ni̱ ga̱nacaj Yanꞌanj ni sij aj. ");
INSERT INTO trq_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ni̱ ni̱nꞌ ga̱chraꞌ xungüi̱ ga̱nataꞌ ni sij nuguanꞌ sa̱ꞌ nan xiꞌí si nicaj sun Yanꞌanj. Ni̱ daꞌngaꞌ daj ga̱nataꞌ ni sij sisi̱ gui̱niꞌi daranꞌ ni ngüi̱ nga̱ nuguanꞌ sa̱ꞌ nan. Ngaa ni̱ gui̱sij, ni̱ ga̱nahuij daranꞌanj. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Hué dan ni̱ u̱n tsínj aya ni nuguanꞌ nan, ni̱ xa̱caj re̱ꞌ cuenta u̱n sin huin nuguanꞌ nan ruhuaj gata huin nuguanꞌ gaꞌmi Jesús xiꞌí si xi̱ꞌi. Ni̱ gataj Jesús: ―Ni̱ ngaa gui̱niꞌi ni é re̱ꞌ ni̱quinꞌ si quij hua rian hua sa̱ꞌ ni̱nꞌ ruhua da̱j rúnꞌ gataj tsínj gu̱ꞌnaj Daniel asi̱j ná ");
INSERT INTO trq_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ni gu̱nánj ni ngüi̱ mán estado Judea ga̱nꞌanj ni sij riqui quij. Ni̱ Daniel huin tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ni̱ tsínj ta̱j xataꞌ chra̱ ducuá sij, ni̱ si̱ nanij sij gui̱ri sij ꞌngo̱ rasu̱n ma̱n chruhua ducuá sij daj. ");
INSERT INTO trq_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ni̱ tsínj mán ꞌyaj sun riqui quij, ni̱ si̱ nanicaj sij ga̱ꞌnaꞌ na̱ranꞌ sij si-ganꞌ sij ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ni̱ niqui niman ni ngüi̱ xa̱na nu̱n riqui lij nga̱ ni ngüi̱ utsi gue̱ daꞌníj si ga̱huin ni güi nan anj. ");
INSERT INTO trq_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ga̱chinj jniꞌyaj ni é re̱ꞌ rian Yanꞌanj sisi̱ si̱ gaꞌna̱ꞌ sayun daj ni yahui̱ nuhuij nga̱ güi naránj ruhua ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Daj si ngaa daj, ni̱ gui̱ranꞌ ni ngüi̱ sayun nico. Ni̱ asi̱j ngaa guiꞌyaj Yanꞌanj xungüi̱, ni̱ nun gui̱niꞌi ni ngüi̱ ꞌngo̱ sayun da̱j rúnꞌ ga̱huin ne̱ꞌ rian ni güi ga̱nꞌanj nan. Ni̱ ne̱ꞌ rian ni güi daj, ni̱ nitaj si ga̱ꞌnaꞌ nico sayun rian ni ngüi̱ da̱j rúnꞌ gui̱ranꞌ ni ngüi̱ ngaa daj. ");
INSERT INTO trq_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ni̱ sisi̱ ga̱ nico güi ga̱ sayun daj, ni̱ si̱ gunucuaj ni ngüi̱ mánj. Sani̱ xiꞌí ni ngüi̱ ganacui Yanꞌanj, ni̱ ga̱niquinꞌ daꞌaj sij si ga̱huin sayun, gui̱ꞌyaj Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Ni̱ sisi̱ ngaa daj hua ꞌngo̱ tsínj ga̱taj: “Ni̱ꞌyaj re̱ꞌ. Nan niquinꞌ Cristo.” Asi̱: “Daꞌ mánj niquinꞌ Cristo aj.” Sisi̱ daꞌngaꞌ daj ga̱taj ni sij, ni̱ si̱ guxuman ruhuá re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Daj si ga̱ꞌnaꞌ ni tsínj ga̱taj sisi̱ hué ni sij huin Cristo, ga̱taj ni sij. Ni̱ ga̱ꞌnaꞌ ni tsínj ga̱taj sisi̱ hué ni sij huin tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj nej. Ni̱ tsínj digyaꞌ yunꞌunj huin ni sij. Ni̱ gui̱ꞌyaj chre ni sij. Ni̱ gui̱ꞌyaj ni sij ni rasu̱n nico güenda di̱gyaꞌ yunꞌunj ni sij ni ngüi̱. Ni̱ sisi̱ ga̱ꞌue ni̱ di̱gyaꞌ yunꞌunj ni sij manꞌan ni ngüi̱ nacui Yanꞌanj nej. ");
INSERT INTO trq_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Daranꞌanj hua gataj sinīj gunun ni é re̱ꞌ nej aj. ");
INSERT INTO trq_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ngaa ni̱ sisi̱ ga̱taj ni sij: “Ni̱ꞌyaj ni é re̱ꞌ. Hué Cristo niquinꞌ quij guiꞌyanj na̱co daj.” Sisi̱ daꞌngaꞌ daj ga̱taj ni sij, ni̱ si̱ ganꞌanj ni é re̱ꞌ mánj. Ni̱ sisi̱ ga̱taj ni sij: “Hué Cristo nne chruhua hueꞌ daj.” Ni̱ sisi̱ daꞌngaꞌ daj ga̱taj ni sij, ni̱ si̱ guxuman ruhua ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Daj si da̱j rúnꞌ yoo̱ ran ꞌyaj duꞌui ne̱ꞌ síj güi, ni̱ ꞌngo̱ xigui̱n ni̱nꞌ xataꞌ, ni̱ daꞌngaꞌ yoo̱ daj na̱nicaj daꞌníj ni ngüi̱ huin manꞌānj. ");
INSERT INTO trq_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Rian ngaj níman, ni̱ yuꞌuj daj na̱huin yuꞌ ni xarúj. ");
INSERT INTO trq_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Sani̱ si ga̱chin ni güi gui̱ranꞌ ni ngüi̱ sayun daj, ngaa ni̱ ráꞌyanj ga̱huin ru̱miꞌ rian güi. Ni̱ si̱ guixigui̱n rian yahui̱ mánj. Ni̱ ga̱yu ni yatiꞌ mán xataꞌ. Ni̱ na̱gunánj ni fuerza mán xataꞌ nej. ");
INSERT INTO trq_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ngaa ni̱ gu̱rugüiꞌ ꞌngo̱ daꞌngaꞌ gui̱ꞌyā xataꞌ huīnj daꞌníj ni ngüi̱. Hué dan ni̱ ni̱nꞌ ruhua ga̱nani ruhua daranꞌ ni xiꞌninꞌ huin ni ngüi̱ ma̱n chruhua xungüi̱. Ni̱ gui̱niꞌi ni sij ga̱ꞌnaꞌ manꞌānj rian ni nga huīnj daꞌníj ni ngüi̱. Ni̱ ga̱ꞌnāj nga̱ daranꞌ fuerza. Ni̱ na̱huin ꞌueé ni̱nꞌīnj ga̱ꞌnāj nej aj. ");
INSERT INTO trq_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ni̱ ga̱ꞌnī ni ángel ga̱nꞌanj nga̱ trompeta ga̱ꞌyanj nucuaj. Ni̱ na̱ranꞌ ni ángel daj ni ngüi̱ hua ganacui Yanꞌanj. Ni̱ ga̱naranꞌ ni ángel ni ngüi̱ daj mán ni̱nꞌ ga̱chraꞌ daꞌ xiꞌí ni̱nꞌ xungüi̱ nga̱ xataꞌ nej aj. ");
INSERT INTO trq_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Ni̱ ga̱huin chru̱n ni é re̱ꞌ xiꞌí nuguanꞌ huin chrun higuera. Ngaa ganahuin yaꞌnij raꞌa, ni̱ naxiraꞌ coj raꞌa, hué dan ni̱ niꞌi ni é re̱ꞌ si hua guisíj gahuin ni̱chrunꞌ yahui̱ ga̱huin ya̱nꞌan anj. ");
INSERT INTO trq_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ni̱ hué gue̱ ducuánj daj ngaa gui̱niꞌi ni é re̱ꞌ sisi̱ hua gahuin si atā gu̱nun ni é re̱ꞌ acuanꞌ, ngaa ni̱ gui̱niꞌi ni é re̱ꞌ sisi̱ hua niquinꞌ manꞌānj rian hueꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Xa̱ngaꞌ atā gu̱nun ni é re̱ꞌ sisi̱ si̱ gahuiꞌ ni ngüi̱ ma̱n yya̱j da ga̱huin yya daranꞌ ni nuguanꞌ nan anj. ");
INSERT INTO trq_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ga̱ niꞌya xataꞌ nga̱ yoꞌój. Sani̱ si-nu̱guanꞌānj nitaj a̱man ga̱nahuij mánj. ");
INSERT INTO trq_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Ni̱ nun niꞌi a̱ ꞌngo̱ ni ngüi̱ u̱n güi, ni̱ u̱n hora ga̱ꞌnaꞌ manꞌānj mánj. Ni̱ nun niꞌi ni ángel mán xataꞌ nej. Ni̱ nun niꞌi manꞌānj huīnj daꞌníj Yanꞌanj nej. Urin chrē niꞌi nánj. ");
INSERT INTO trq_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ni̱ da̱j rúnꞌ guiꞌyaj ni ngüi̱ ngaa gane tsínj gu̱ꞌnaj Noé asi̱j ná, ni̱ daꞌngaꞌ daj gui̱ꞌyaj ni ngüi̱ ngaa ga̱ꞌnaꞌ daꞌníj ni ngüi̱ huin manꞌānj. ");
INSERT INTO trq_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Daj si asi̱j ngaa nun ga̱ra nnee rian yoꞌój, ni̱ xa ni sij goꞌo ni sij. Ni̱ acaj ni sij yunꞌunj xa̱na. Ni̱ acaj yunꞌunj xa̱na tsínj snoꞌo nej. Ni̱ daꞌngaꞌ daj guiꞌyaj ni sij daꞌ güi gatúj Noé chruhua rio̱ achéj rian nnee. ");
INSERT INTO trq_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ni̱ nun ga̱ra daꞌngaꞌ ruhua ni sij da gara nnee rian yoꞌój guiꞌyaj guma̱n huee xxi. Ni̱ nicaj nnee daj daranꞌ ni sij ganꞌanj-ánꞌ. Ni̱ da̱j rúnꞌ gahuin ngaa daj, ni̱ daꞌngaꞌ daj nun ga̱ra daꞌngaꞌ ruhua ni ngüi̱ da ga̱ꞌnaꞌ ru̱huaꞌ yūnj. ");
INSERT INTO trq_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","’Ni̱ ngaa gui̱sij güi daj, ni̱ gu̱nun nu̱guanꞌan hui̱j tsínj riqui quij. Ni̱ nicā ga̱nꞌān ꞌngo̱ sij, ni̱ ango sij gu̱na. ");
INSERT INTO trq_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ni̱ gu̱nun nu̱guanꞌan hui̱j yunꞌunj xa̱na huáj unj. Ni̱ ꞌngo̱ unj nicā ga̱nꞌān, ni̱ ango unj gu̱na. ");
INSERT INTO trq_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Xiꞌí daj gui̱niꞌyaj sa̱ꞌ ni é re̱ꞌ. Daj si nun niꞌi ni é re̱ꞌ u̱n hora ga̱ꞌnāj huīnj Señor nicaj sun rian ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Gu̱nun sa̱ꞌ ni é re̱ꞌ. Sisi̱ gui̱niꞌi ꞌngo̱ tsínj du̱cua daj u̱n hora ne̱ꞌ yanꞌ ga̱ꞌnaꞌ ꞌngo̱ tsínj tu̱, ni̱ ga̱ne sij du̱gumi sij. Ni̱ si̱ gaꞌnij sij ga̱tu síꞌ ducuá sij, gui̱ꞌyaj tu̱ síꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Hué dan ni̱ ga̱ chru̱n gui̱man ni é re̱ꞌ nej. Daj si ga̱ꞌnaꞌ manꞌānj hué gue̱ hora nitaj si ani ruhua ni é re̱ꞌ huīnj daꞌníj ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Ngaa ni̱ ga̱huin ni é re̱ꞌ da̱j rúnꞌ huin ꞌngo̱ moso sa̱ꞌ. Ni̱ gui̱ꞌyaj ni é re̱ꞌ da̱j rúnꞌ ꞌyaj ꞌngo̱ tsínj nicaj yunꞌunj moso, guiꞌyaj xuruꞌue. Daj si aꞌuiꞌ sij si xa ni ango moso ngaa níꞌyanj ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ni̱ hua ꞌueé rian tsínj nicaj yunꞌunj daj sisi̱ hua ga̱cuij ꞌyaj sij ngaa hua ꞌna̱ꞌ niqui tsínj du̱cua na̱riꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ gui̱nicaj tsínj daj sun du̱gumi sij daranꞌ siꞌyaj tsínj du̱cua daj, gui̱ꞌyaj síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Sani̱ sisi̱ hua xi̱ꞌi niman tsínj daj, ni̱ ga̱ni ruhua sij sisi̱ ga̱huin ran ga̱ꞌnaꞌ niqui tsínj du̱cua daj. ");
INSERT INTO trq_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ni̱ gaxi̱ꞌi sij du̱guayun sij ango ni moso dugumi sij, ni̱ ga̱xiꞌi sij xa̱ na̱saꞌ sij, ni̱ go̱ꞌo sij nga̱ ni tsínj axini nej. ");
INSERT INTO trq_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ngaa ni̱ ga̱ꞌnaꞌ tsínj du̱cua daj hué gue̱ güi, ni̱ hué gue̱ hora nitaj si ani ruhua sij si ga̱ꞌnaꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ni̱ ga̱huin nico sij castigo gui̱ꞌyaj tsínj du̱cua. Ni̱ gui̱ranꞌ sij sayun nga̱ ni tsínj digyaꞌ yunꞌunj, gui̱ꞌyaj síꞌ. Ni̱ hué yuꞌuj daj ga̱co sij. Ni̱ da xa̱ruj yanꞌ sij ga̱huin sij castigo. ");
INSERT INTO trq_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Ni da̱j rúnꞌ ꞌyaj ichiꞌ ngüi̱ xa̱na yan, ni̱ daꞌngaꞌ daj ga̱huin rian nicaj sun Yanꞌanj xataꞌ. Daj si nicaj ni unj candil aca gasiti huaj unj na̱caj dugüiꞌ unj nga̱ tsínj xa̱caj nica̱. ");
INSERT INTO trq_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ni̱ u̱nꞌunꞌ unj huin yunꞌunj niꞌi sa̱ꞌ. Ni̱ yunꞌunꞌ unj huin yunꞌunj ni̱ꞌyun. ");
INSERT INTO trq_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ni̱ nicaj u̱nꞌunꞌ ni yunꞌunj ni̱ꞌyun nun niꞌi daj candil ganꞌanj unj. Sani̱ nun ni̱caj unj gasiti ganꞌanj unj. ");
INSERT INTO trq_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Sani̱ ni yunꞌunj niꞌi sa̱ꞌ daj, ni̱ nicaj unj gagaꞌ nu̱n gasiti ganꞌanj unj. Ni̱ nicaj unj candil nej aj. ");
INSERT INTO trq_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ni̱ ri̱an gahuin ran tsínj xa̱caj yunꞌunj xa̱na, ni̱ ganun nnej rian daranꞌ unj, ni̱ gatoj unj. ");
INSERT INTO trq_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Hué dan ni̱ yanꞌ sa̱ꞌ, ni̱ gunun unj si gaguáj ni sij. Ni̱ gataj ni sij: “Hua ꞌna̱ꞌ tsínj xa̱caj yunꞌunj xa̱na. Ga̱hui ni é re̱ꞌ ga̱nꞌanj na̱caj ni é re̱ꞌ tsínj daj.” Daꞌngaꞌ daj gaguáj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ngaa ni̱ nachica daranꞌ ni yunꞌunj xa̱na yan daj. Ni̱ gaxi̱ꞌi unj guiꞌyaj xugüi unj si-candil unj. ");
INSERT INTO trq_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ngaa ni̱ gataj aninꞌ yunꞌunj ni̱ꞌyun daj rian aninꞌ yunꞌunj a hua xugüi ꞌyaj: “Ri̱qui aninꞌ é re̱ꞌ do̱j si-gasiti aninꞌ é re̱ꞌ gui̱riꞌ unj. Daj si ruhua guina̱ꞌaj si-candil ni unj.” Daj gataj unj. ");
INSERT INTO trq_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Sani̱ gataj ni yunꞌunj niꞌi sa̱ꞌ daj: “Si̱ guisíj gasiti rian daranꞌ néꞌ sisi̱ ri̱qui unj rian ni é re̱ꞌ. Güi̱j ni̱ꞌyaj naj aninꞌ é re̱ꞌ rian mánj anéj, ni̱ gui̱ran aninꞌ é re̱ꞌ aj.” Daj gataj aninꞌ unj. ");
INSERT INTO trq_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Sani̱ ngaa huaj unj gui̱ran unj gasiti, ni̱ ganasíj tsínj xa̱caj yunꞌunj xa̱na daj. Ni̱ gatúj ni yunꞌunj a hua xugüi daj chruhua hueꞌ nga̱ tsínj xa̱caj yunꞌunj xa̱na daj. Ni̱ naránj ni sij rian hueꞌ daj nánj. ");
INSERT INTO trq_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Daꞌ síj da guinasíj ango daꞌaj ni yunꞌunj xa̱na yan daj. Ni̱ gataj unj: “Señor, señor, na̱ꞌni re̱ꞌ rian hueꞌ ga̱tu ni unj.” Daj gataj unj gunun síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Sani̱ gataj síꞌ: “Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ nun niꞌīnj ni é re̱ꞌ mánj.” Daj gataj síꞌ gunun ni yunꞌunj ni̱ꞌyun daj. ");
INSERT INTO trq_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","’Gui̱niꞌyaj sa̱ꞌ ni é re̱ꞌ si nun niꞌi ni é re̱ꞌ u̱n güi, ni̱ u̱n hora ga̱ꞌnaꞌ daꞌníj ni ngüi̱ huin manꞌānj. ");
INSERT INTO trq_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Daj si da̱j rúnꞌ ꞌyaj ꞌngo̱ xuruꞌue ganꞌanj ango yuꞌuj ga̱nꞌ, ni̱ hué daj ꞌyaj manꞌānj. Ni̱ gaquínj xuruꞌue daj si-moso sij. Ni̱ nagaꞌuiꞌ sij si-sanꞌanj sij rian ni síꞌ sisi̱ du̱gumi ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ni̱ gaꞌuiꞌ sij u̱nꞌunꞌ sanꞌanj gu̱ꞌnaj talento rian ꞌngo̱ si-moso sij. Ni̱ ꞌngo̱ talento daj huin ruhuaj gata sisi̱ guiꞌyaj gana ꞌngo̱ tsínj daj ngaa guisíj guiꞌyaj sun sij ꞌngo̱ si xinunꞌ yoꞌ. Daj si ni̱nꞌ ruhua duꞌue sanꞌanj huin talento daj. Ni̱ gaꞌuiꞌ sij hui̱j talento rian ango moso daj. Ni̱ gaꞌuiꞌ sij ꞌngo̱ talento rian ango moso daj. Ni̱ gaꞌuiꞌ sij rian go̱ꞌngo ni sij da̱j rúnꞌ ga̱ꞌue gui̱ꞌyaj gana ni sij. Hué dan ni̱ ganꞌanj ga̱nꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","’Ngaa ni̱ ꞌngo̱ hora ganꞌanj tsínj nahuin raꞌa u̱nꞌunꞌ talento daj. Ni̱ guiránj sij ni rasu̱n naduꞌuej sij. Ni̱ guiꞌyaj gana sij yunꞌunꞌ talento nga̱ sanꞌanj daj. ");
INSERT INTO trq_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ni̱ daꞌngaꞌ daj guiꞌyaj tsínj guiriꞌ hui̱j talento. Ni̱ guiꞌyaj gana sij yahuij talento. ");
INSERT INTO trq_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Sani̱ tsínj guiriꞌ ꞌngo̱ talento, ni̱ ganꞌanj sij ganj sij yuꞌuj. Ni̱ garíj hui̱ sij si-sanꞌanj si-xuruꞌue sij. ");
INSERT INTO trq_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Ni̱ ngaa gachin nico güi, ni̱ nasíj xuruꞌue daj. Ni̱ xacaj sij cuenta daj guiꞌyaj ni moso daj. ");
INSERT INTO trq_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ni̱ gaꞌna̱ꞌ tsínj guiriꞌ u̱nꞌunꞌ talento daj. Ni̱ nutaꞌ sij yunꞌunꞌ talento guiꞌyaj gana sij. Ni̱ gataj sij gunun xuruꞌue daj: “Señor, riquí re̱ꞌ u̱nꞌunꞌ talento riānj. Ni̱ guiꞌyaj ganāj yunꞌunꞌ talento ga̱huin siꞌyáj re̱ꞌ.” Daj gataj tsínj daj gunun xuruꞌue daj. ");
INSERT INTO trq_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ngaa ni̱ gataj síꞌ: “Duguꞌna̱j huaj guiꞌyáj re̱ꞌ huín re̱ꞌ ꞌngo̱ moso guiꞌyaj sa̱ꞌ sun. Ni̱ huín re̱ꞌ ꞌngo̱ tsínj gacuij. Xiꞌí si guiꞌyaj ꞌueé re̱ꞌ nga̱ do̱j sun, ngaa ni̱ gui̱ꞌyā sisi̱ gui̱nicaj re̱ꞌ nico sun. Ga̱huin nia̱ꞌ ruhuá re̱ꞌ ngāj huīnj tsínj nicaj sun rian re̱ꞌ.” Daj gataj síꞌ gunun sij. ");
INSERT INTO trq_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","’Ngaa ni̱ gaꞌna̱ꞌ tsínj guiriꞌ hui̱j talento daj. Ni̱ gataj síꞌ: “Señor, riquí re̱ꞌ hui̱j talento riānj. Ni̱ guiꞌyaj ganāj yahuij talento ga̱huin siꞌyáj re̱ꞌ.” Daj gataj síꞌ gunun sij. ");
INSERT INTO trq_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ngaa ni̱ gataj xuruꞌue gunun sij: “Duguꞌna̱j huaj guiꞌyáj re̱ꞌ huín re̱ꞌ moso guiꞌyaj sa̱ꞌ sun. Ni̱ huín re̱ꞌ ꞌngo̱ tsínj gacuij nánj. Xiꞌí si guiꞌyaj ꞌueé re̱ꞌ nga̱ do̱j sun, ni̱ gui̱ꞌyā sisi̱ gui̱nicaj re̱ꞌ nico sun. Ga̱huin nia̱ꞌ ruhuá re̱ꞌ ngāj huīnj tsínj nicaj sun rián re̱ꞌ.” Daj gataj sij gunun síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Sani̱ ngaa gaꞌna̱ꞌ tsínj guiriꞌ ꞌngo̱ talento daj, ni̱ gataj sij gunun síꞌ: “Señor, niꞌīnj sisi̱ huín re̱ꞌ ꞌngo̱ tsínj huee. Ni̱ nacaj re̱ꞌ strigo rian nun güin gunun re̱ꞌ. Ni̱ naranꞌ re̱ꞌ strigo rian naguiꞌyaj sa̱ꞌ ango ni sij strigo nej. ");
INSERT INTO trq_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Xiꞌí daj ni̱ guxuꞌuīj. Ni̱ ganꞌanj ga̱ri huīj si-sanꞌanj manꞌán re̱ꞌ riqui yoꞌój. Ngaa ni̱ nariquīj siꞌyáj re̱ꞌ na̱huin raꞌá re̱ꞌ.” Daj gataj tsínj daj gunun xuruꞌue. ");
INSERT INTO trq_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Hué dan ni̱ gataj xuruꞌue daj gunun sij: “Huín re̱ꞌ ꞌngo̱ moso xi̱ꞌi. Ni̱ ru̱mi re̱ꞌ nej. Ni̱ niꞌí re̱ꞌ sisi̱ nacā rian nun gu̱nūnj. Ni̱ niꞌí re̱ꞌ sisi̱ ganaranꞌānj strigo rian naguiꞌyaj sa̱ꞌ ango ni sij strigo nej. ");
INSERT INTO trq_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Hué dan ni̱ u̱n sin huin, ni̱ nun ni̱caj re̱ꞌ si-sanꞌān ga̱nꞌanj re̱ꞌ ga̱ꞌnij re̱ꞌ banco únj. Ngaa ni̱ ngaa na̱nicā, ni̱ na̱cā si-sanꞌān nga̱ sanꞌanj nataꞌ chra̱ banco sanꞌanj gaꞌníj re̱ꞌ chra̱ nej aj nej.” Daj gataj xuruꞌue gunun tsínj guiriꞌ ꞌngo̱ talento daj. ");
INSERT INTO trq_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","’Ngaa ni̱ gataj xuruꞌue daj gunun ni tsínj ma̱n yuꞌuj daj: “Ga̱ꞌne ni é re̱ꞌ sanꞌanj raꞌa sij. Ni̱ ga̱ꞌuiꞌ ni é re̱ꞌ raꞌa tsínj nicaj chiꞌ talento. ");
INSERT INTO trq_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Daj si tsínj nicaj ni̱ ga̱ꞌuīj nico raꞌa sij. Ni̱ ga̱huin nico si nicaj sij. Sani̱ tsínj nitaj si nicaj, ni̱ nu̱nj si do̱j nicaj sij, ni̱ ga̱ꞌnē si nicaj sij aj. ");
INSERT INTO trq_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ni̱ moso nitaj si níꞌyanj daj, ni̱ gue̱reꞌ ni é re̱ꞌ ne̱ꞌ chrej xe̱ꞌ rian hua ru̱miꞌ aj. Ni̱ hué yuꞌuj daj gu̱nun ga̱co sij. Ni̱ da xa̱ruj yanꞌ sij ga̱huin sij castigo.” Daj gataj xuruꞌue daj xiꞌí moso xi̱ꞌi daj. ");
INSERT INTO trq_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Ni̱ ngaa ga̱ꞌnaꞌ daꞌníj ni ngüi̱ huin manꞌānj nej, ni̱ ga̱nēj rian chrun xila hua ꞌueé sa̱ꞌ ni̱nꞌ. Ni̱ ga̱ꞌnāj nga̱ ni̱nꞌ ruhua fuerza. ");
INSERT INTO trq_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ngaa ni̱ na̱huin yuꞌ daranꞌ ni ngüi̱ mán chruhua xungüi̱ riānj. Ni̱ na̱ri ninīj ni sij da̱j rúnꞌ ꞌyaj tsínj dugumi xucu ngaa nari ni̱ni sij dán sij xachij nga̱ stane̱. Ni̱ daꞌngaꞌ daj gui̱ꞌyā na̱ri ninīj go̱ꞌngo ni sij aj. ");
INSERT INTO trq_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ngaa ni̱ gui̱ꞌyā sisi̱ gui̱man ni xachij ne̱ꞌ chrej raꞌa sa̱ꞌāj. Ni̱ gui̱man ni stane̱ ne̱ꞌ chrej raꞌa ro̱tsīj aj. ");
INSERT INTO trq_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","’Ni̱ huēj ga̱huin rey. Ni̱ ga̱tā gu̱nun ni ngüi̱ gui̱man ne̱ꞌ chrej raꞌa sa̱ꞌāj aj: “Ga̱huaꞌ ni é re̱ꞌ si hua guiꞌyaj sa̱ꞌ chrē nga̱ ni é re̱ꞌ aj. Ni̱ huin ruhuāj sisi̱ gui̱nicaj sun ni é re̱ꞌ rian nicaj sun Yanꞌanj. Daj si hua guiꞌyaj xugüi Yanꞌanj rian ga̱ne ni é re̱ꞌ asi̱j ngaa guiꞌyaj Yanꞌanj xungüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Daj si ngaa gachin xiꞌna̱ riquīj, ni̱ riqui ni é re̱ꞌ xāj. Ni̱ ngaa nagoꞌōj nnee, ni̱ riqui ni é re̱ꞌ goꞌōj nej. Ni̱ ngaa huīnj ꞌngo̱ tsínj ꞌna̱ꞌ ango rian xumanꞌ, ni̱ nahuin raꞌa á re̱ꞌ yūnj aj. ");
INSERT INTO trq_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ngaa nitaj si-ganꞌānj, ni̱ riqui ni é re̱ꞌ atsij gu̱nūnj. Ni̱ ngaa gaꞌnānj, ni̱ gaꞌna̱ꞌ niꞌyaj á re̱ꞌ yūnj. Ni̱ ngaa gunūnj ducuaga̱ꞌ, ni̱ gaꞌna̱ꞌ niꞌyaj ni é re̱ꞌ rian gunūnj anj.” Daj ga̱tā rian ni ngüi̱ gui̱man ne̱ꞌ chrej raꞌa sa̱ꞌāj. ");
INSERT INTO trq_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","’Ngaa ni̱ na̱chinj snanꞌanj ni ngüi̱ hua ni̱ca niman daj riānj: “Señor, a̱man guiniꞌi ni únj sisi̱ achin xiꞌna̱ riquí re̱ꞌ, ni̱ riqui ni únj si xá re̱ꞌ únj. Ni̱ a̱man guiniꞌi ni únj sisi̱ nagoꞌó re̱ꞌ nnee, ni̱ riqui ni únj si goꞌó re̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ni̱ a̱man guiniꞌi ni únj sisi̱ huín re̱ꞌ ꞌngo̱ tsínj ꞌna̱ꞌ rian ango xumanꞌ, ni̱ nahuin raꞌa ni únj manꞌán re̱ꞌ únj. Ni̱ a̱man guiniꞌi ni únj si nitaj si-gánꞌ re̱ꞌ, ni̱ riqui ni únj gunun re̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ni̱ a̱man guiniꞌi ni únj sisi̱ gaꞌnanꞌ re̱ꞌ, asi̱ gunu̱n re̱ꞌ ducuaga̱ꞌ nej, ni̱ gaꞌna̱ꞌ niꞌyaj ni únj únj.” Daj ga̱taj ni ngüi̱ daj gu̱nūnj aj. ");
INSERT INTO trq_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","’Ngaa ni̱ ga̱tā gu̱nun ni sij: “Xa̱ngaꞌ atā gu̱nun ni é re̱ꞌ sisi̱ daranꞌ si guiꞌyaj ni é re̱ꞌ rian ni jnān hua niqui, ni̱ hué ducuānj daj guiꞌyaj á re̱ꞌ riānj nej aj.” Daj ga̱tā gu̱nun ni ngüi̱ ꞌyaj sa̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Hué dan ni̱ ga̱tā gu̱nun ni ngüi̱ gui̱man ne̱ꞌ chrej raꞌa ro̱tsīj: “Gu̱xun anéj ni é re̱ꞌ manꞌán re̱ꞌ riānj. Hua gataj Yanꞌanj sisi̱ ga̱nꞌanj ni é re̱ꞌ rian yanꞌa̱n ga̱ca ni̱ganj ni̱nꞌ a ni é re̱ꞌ aj. Ni̱ hua guiꞌyaj xugüi Yanꞌanj yanꞌa̱n daj sisi̱ gu̱nun sichre nga̱ ni ángel nicoꞌ manꞌan sichre daj aj. ");
INSERT INTO trq_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Daj si ngaa gachin xiꞌna̱ riquīj, ni̱ nun ri̱qui ni é re̱ꞌ xāj. Ni̱ ngaa nagoꞌōj nnee, ni̱ nun ri̱qui ni é re̱ꞌ goꞌōj. ");
INSERT INTO trq_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ni̱ ngaa gahuīnj ꞌngo̱ tsínj ꞌna̱ꞌ ango rian xumanꞌ, ni̱ nun ga̱nahuin raꞌa ni é re̱ꞌ yūnj mánj. Ni̱ ngaa nitaj si-ganꞌānj, ni̱ nun ri̱qui ni é re̱ꞌ gunūnj mánj. Ni̱ ngaa gaꞌnānj, ni̱ nun ga̱ꞌnaꞌ ni̱ꞌyaj ni é re̱ꞌ yūnj mánj. Ni̱ ngaa gunūnj ducuaga̱ꞌ, ni̱ nun ga̱ꞌnaꞌ niꞌyaj ni é re̱ꞌ riānj nūnj mánj.” Daj ga̱tā gu̱nun ni ngüi̱ gui̱man ne̱ꞌ chrej raꞌa rotsīj daj. ");
INSERT INTO trq_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","’Ngaa ni̱ ga̱taj ni sij riānj: “Señor, a̱man guiniꞌi ni únj sisi̱ achin xiꞌna̱ riquí re̱ꞌ, ni̱ nagoꞌó re̱ꞌ nnee únj. Ni̱ a̱man gahuín re̱ꞌ ꞌngo̱ tsínj ꞌna̱ꞌ ango yuꞌuj únj. Ni̱ a̱man achin si-gánꞌ re̱ꞌ únj. Ni̱ a̱man aꞌnánꞌ re̱ꞌ si gunu̱n re̱ꞌ ducuaga̱ꞌ únj. Ni̱ a̱man nun chracuij ni únj manꞌán re̱ꞌ ngaa guiránꞌ re̱ꞌ ni sayun daj únj.” Daj ga̱taj ni sij riānj. ");
INSERT INTO trq_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","’Ni̱ ga̱tā gu̱nun ni sij: “Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ ngaa nun chra̱cuij ni é re̱ꞌ rian ni jnān hua niqui, ni̱ daꞌngaꞌ daj nun chra̱cuij a ni é re̱ꞌ rian manꞌānj.” Daj ga̱tā gu̱nun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","’Ni̱ ga̱nꞌanj ni sij gui̱ranꞌ ni sij castigo ni̱ganj ni̱nꞌ. Sani̱ ni ngüi̱ hua ni̱ca niman, ni̱ ga̱nꞌanj ga̱ne ni̱ganj ni sij nga̱ Yanꞌanj. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Hué dan ni̱ ngaa guisíj gaꞌmi Jesús ni nuguanꞌ daj, ni̱ gataj sij gunun ni tsínj nicoꞌ sij: ");
INSERT INTO trq_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Niꞌi ni é re̱ꞌ sisi̱ xiráj hui̱j güi, ni̱ ꞌna̱ꞌ ga̱huin guiꞌyanj pascua. Ni̱ na̱gaꞌuiꞌ ni sij manꞌānj rian ni tsínj ga̱ꞌuiꞌ gaquíj raꞌāj gui̱nicōj rian rugutsi̱ huīnj daꞌníj ni ngüi̱. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ngaa ni̱ nahuin yuꞌ ni chrej aꞌninꞌ nga̱ ni tsínj digyán ley nej, nga̱ ni tsínj huin achij scanij ni ngüi̱ nej. Ni̱ nahuin yuꞌ ni sij rian hueꞌ ducuá chrej huin achij ni̱nꞌ gu̱ꞌnaj síꞌ Caifás. ");
INSERT INTO trq_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ni̱ digaꞌmi dugüiꞌ ni sij da̱j ga̱ꞌue di̱gyaꞌ yunꞌunj ni sij manꞌan Jesús, ni̱ gui̱daꞌa hui̱ ni sij síꞌ. Daj si da̱gahuiꞌ ni sij, ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Sani̱ gataj ni sij: ―Si̱ guidoꞌóꞌ síꞌ güi ga̱huin guiꞌyanj nun sa̱ꞌ nun ga̱huin sayun, gui̱ꞌyaj ni ngüi̱ mánj. Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ni̱ ngaa gane Jesús xumanꞌ Betania, ni̱ gane sij ducuá ꞌngo̱ tsínj gu̱ꞌnaj Simón tsínj guiranꞌ xiꞌi̱ lepra. ");
INSERT INTO trq_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ni̱ ngaa nne Jesús rian mesa, ni̱ guisíj ꞌngo̱ yunꞌunj xa̱na rian nne sij. Ni̱ nicaj únꞌ ꞌngo̱ frasco yej gu̱ꞌnaj alabastro nu̱n gasiti guinꞌ da̱j ruhua-áꞌ nicaj únꞌ guisíj únꞌ. Ni̱ duꞌue ni̱nꞌ ruhua-áꞌ. Ni̱ garíj únꞌ gasiti daj chra̱ Jesús. ");
INSERT INTO trq_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Sani̱ ngaa guiniꞌi ni tsínj nicoꞌ Jesús, ni̱ gaꞌman ruhua ni sij. Ni̱ gataj ni sij: ―Ni̱ u̱n sin huin ni̱ gayanj yu̱n gasiti sa̱ꞌ da únj. ");
INSERT INTO trq_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ga̱ꞌue ga̱neꞌ gasiti daj. Ni̱ ga̱ꞌue gui̱riꞌ nico sanꞌanj ga̱ꞌuiꞌ néꞌ rian ni ngüi̱ niqui. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ni̱ ngaa gunun Jesús, ni̱ gataj síꞌ gunun ni sij: ―Si̱ chranꞌ yunꞌunj ni é re̱ꞌ yunꞌunj xa̱na nan mánj. Si ꞌyaj unj nan ngāj, ni̱ duguꞌna̱j huaj, ꞌyaj unj. ");
INSERT INTO trq_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yaꞌyoj nne ni ngüi̱ niqui nga̱ á re̱ꞌ. Sani̱ nitaj si ga̱ne ni̱ganj manꞌānj nga̱ ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Garíj únꞌ gasiti guinꞌ da̱j nnee̱ cū. Ni̱ daꞌngaꞌ daj ꞌyaj xugüi únꞌ nnee̱ cū. Daj si do̱j ni̱ gui̱sij güi ga̱chinꞌ ni sij yūnj. ");
INSERT INTO trq_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Xa̱ngaꞌ yya atā gu̱nun ni é re̱ꞌ sisi̱ daranꞌ yuꞌuj ga̱ꞌmi ni sij nuguanꞌ sa̱ꞌ rian xiꞌīj, ni̱ hué daj na̱taꞌ ni sij si guiꞌyaj yunꞌunj xa̱na daj riānj. Ngaa ni̱ na̱nun ruhua ni ngüi̱ xiꞌí únꞌ aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Hué dan ni̱ ganꞌanj ꞌngo̱ ni xu̱huij ni tsínj nicoꞌ Jesús rian ni chrej aꞌninꞌ. Ni̱ gu̱ꞌnaj síꞌ Judas Iscariote. ");
INSERT INTO trq_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ni̱ gataj síꞌ: ―Ni̱ u̱ndaj huin ri̱qui ni é re̱ꞌ riānj, ni̱ di̱gyānj rian nne Jesús, ni̱ gui̱daꞌa á re̱ꞌ únj. ―Daj gataj Judas gunun ni sij. Ngaa ni̱ gaꞌuiꞌ ni sij ico̱ chiꞌ sanꞌanj plata rian síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ni̱ asi̱j hora daj, ni̱ gaxi̱ꞌi síꞌ nanoꞌ síꞌ ꞌngo̱ ducuánj da̱j na̱gaꞌuiꞌ síꞌ Jesús raꞌa ni chrej aꞌninꞌ. ");
INSERT INTO trq_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ni̱ guisíj güi sini gahuin guiꞌyanj ngaa guiꞌyaj ni sij chrachrúnj nitaj si ꞌni̱j levadura xa ni sij. Ni̱ gaꞌna̱ꞌ ni tsínj nicoꞌ Jesús. Ni̱ gataj ni síꞌ gunun sij: ―Ni̱ a̱ huin ruhuá re̱ꞌ si gui̱ꞌyaj xugüi ni únj xa̱ stiꞌni̱ re̱ꞌ pascua únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ngaa ni̱ gataj Jesús: ―Güi̱j ga̱tu ni é re̱ꞌ xumanꞌ rian nne ꞌngo̱ tsínj daj. Ni̱ ga̱taj ni é re̱ꞌ gu̱nun síꞌ: “Ataj maestro sisi̱ gahuin ni̱chrunꞌ si gui̱sij si-hora sij. Ngaa ni̱ ga̱nꞌanj gui̱ꞌyaj sij guiꞌyanj pascua ducuá re̱ꞌ nga̱ ni tsínj nicoꞌ manꞌan sij.” Daꞌngaꞌ daj ga̱taj ni é re̱ꞌ gu̱nun síꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ngaa ni̱ guiꞌyaj ni sij da̱j rúnꞌ gaꞌninꞌ Jesús sun rian ni sij. Ni̱ guiꞌyaj xugüi ni sij sisi̱ xa̱ stiꞌni̱ ni sij xiꞌí guiꞌyanj pascua. ");
INSERT INTO trq_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ni̱ ngaa guini̱, ni̱ ganꞌanj ga̱ne Jesús rian mesa nga̱ ni xu̱huij ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ni̱ ngaa xa ni sij, ni̱ gataj Jesús gunun ni síꞌ: ―Xa̱ngaꞌ atā gu̱nun ni é re̱ꞌ sisi̱ na̱gaꞌuiꞌ ꞌngo̱ ni é re̱ꞌ manꞌānj rian ni tsínj ga̱ꞌnaꞌ gui̱daꞌa yūnj anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ngaa ni̱ ni̱nꞌ ruhua ganani ruhua ni sij. Ni̱ gaxi̱ꞌi ni sij nachínj snanꞌanj go̱ꞌngo ni sij Jesús. Ni̱ gataj ni sij: ―Señor, manꞌānj huin níꞌ. ―Gataj go̱ꞌngo ni sij. ");
INSERT INTO trq_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ngaa ni̱ gataj Jesús: ―Tsínj jniaj nu̱guanꞌan chrachrúnj chruhua goꞌo ngāj, hué sij huin tsínj na̱gaꞌuiꞌ manꞌānj rian ni tsínj gui̱daꞌa yūnj. ");
INSERT INTO trq_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ni̱ yūnj huin daꞌníj ni ngüi̱. Ni̱ rúnꞌ ataj si-nu̱guanꞌ Yanꞌanj rian xiꞌīj, ni̱ daꞌngaꞌ daj hua nia̱n gui̱ranꞌānj sayun. Sani̱ niqui niman ni̱nꞌ ruhua tsínj na̱gaꞌuiꞌ manꞌānj rian ni tsínj ga̱ꞌnaꞌ gui̱daꞌa yūnj. Daj si ga̱huin nico castigo gui̱ranꞌ síꞌ. Sa̱ꞌ huin sisi̱ nun gaꞌnga manꞌan síꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ngaa ni̱ nachínj snanꞌanj Judas tsínj nagaꞌuiꞌ Jesús rian ni tsínj nicaj sun. Ni̱ gataj sij gunun Jesús: ―Maestro, manꞌānj huin níꞌ. ―Daj gataj Judas. Ngaa ni̱ gataj Jesús: ―Daꞌngaꞌ daj gataj manꞌán re̱ꞌ. ―Daj gataj Jesús gunun Judas. ");
INSERT INTO trq_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ni̱ ngaa xa ni sij, ni̱ guidaꞌa Jesús chrachrúnj. Ni̱ nagaꞌuiꞌ sij si guruhua Yanꞌanj. Asíj ni̱ guraꞌ daꞌaj sij chrachrúnj daj, ni̱ gaꞌuiꞌ sij xa ni tsínj nicoꞌ sij. Ni̱ gataj sij: ―Gui̱daꞌa ni é re̱ꞌ xa̱ ni é re̱ꞌ. Chrachrúnj nan huin nnee̱ cū aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Hué dan ni̱ guidaꞌa Jesús tasa. Ni̱ ngaa nagaꞌuiꞌ sij si guruhua Yanꞌanj, ni̱ gaꞌuiꞌ sij go̱ꞌo ni síꞌ. Ni̱ gataj sij: ―Go̱ꞌo daranꞌ ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Daj si nnee nan huin si-tun manꞌānj. Ni̱ nga̱ tun nan, ni̱ guisíj gahuin yya nuguanꞌ guiꞌyaj yya Yanꞌanj nga̱ ni ngüi̱. Ni̱ xiꞌí tun ga̱yanj nan gui̱nicaj Yanꞌanj niman nico rian si-ga̱quinꞌ nico ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ni̱ atā gu̱nun a ni é re̱ꞌ sisi̱ nitaj si go̱ꞌo ru̱huaꞌ yūnj nnee uva nan daꞌ güi go̱ꞌōj nnee uva na̱ca nga̱ ni é re̱ꞌ rian nicaj sun chrē. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ni̱ ngaa guisíj garáj ni sij chraꞌ, ni̱ gahui ni sij ganꞌanj ni sij dacan gu̱ꞌnaj Olivos. ");
INSERT INTO trq_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ngaa ni̱ gataj Jesús gunun ni sij: ―Du̱na daranꞌ ni é re̱ꞌ yūnj yanꞌ yya̱j. Daj si ataj si-nu̱guanꞌ Yanꞌanj: “Ga̱ꞌuiꞌ Yanꞌanj tsínj dugumi xachij. Ngaa ni̱ gu̱nánj ni xuj. Ni̱ ga̱xaꞌni ni xuj.” Daꞌngaꞌ daj ataj si-nu̱guanꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Sani̱ ngaa ga̱naꞌnī, ngaa ni̱ ga̱nꞌān estado Galilea. Asíj ni̱ huaj ni é re̱ꞌ yuꞌuj da nej. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ngaa ni̱ gataj Pedro gunun Jesús: ―Nu̱nj si ga̱nꞌanj daranꞌ ni sij xiꞌí re̱ꞌ, sani̱ nitaj a̱man du̱naj manꞌānj manꞌán re̱ꞌ mánj. ―Daj gataj Pedro gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ngaa ni̱ gataj Jesús: ―Xa̱ngaꞌ atā gu̱nun re̱ꞌ sisi̱ asi̱j nun ga̱guaj doꞌloj ꞌngo̱ duꞌua xúꞌ yanꞌ nan, ni̱ ga̱taj re̱ꞌ hua̱ꞌnij sisi̱ nun niꞌí re̱ꞌ manꞌānj. ―Daj gataj Jesús gunun Pedro. ");
INSERT INTO trq_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ni̱ gataj Pedro: ―Nu̱nj si hua nia̱n ga̱huīj nga̱ re̱ꞌ, sani̱ si̱ gatā sisi̱ nun niꞌīnj manꞌán re̱ꞌ mánj. ―Daj gataj Pedro. Ni̱ daꞌngaꞌ daj gataj daranꞌ ni tsínj nicoꞌ Jesús nej. ");
INSERT INTO trq_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Hué dan ni̱ ganꞌanj Jesús nga̱ ni tsínj nicoꞌ sij ꞌngo̱ yuꞌuj gu̱ꞌnaj Getsemaní. Ni̱ gataj sij gunun ni síꞌ: ―Ga̱ne ni é re̱ꞌ nan si ga̱nꞌān yuꞌuj man ga̱chinj jniꞌyā rian Yanꞌanj. ―Daj gataj sij gunun ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ni̱ nicaj sij Pedro nga̱ nu̱ngüej daꞌníj Zebedeo ganꞌanj sij. Ni̱ ni̱nꞌ ruhua gaxi̱ꞌi sij ganani ruhua sij. Daꞌ huej ataꞌ niman sij. ");
INSERT INTO trq_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ni̱ gataj sij gunun aninꞌ síꞌ: ―Daꞌ níꞌ ni̱ a̱ ga̱nꞌanj nimānj ruhuāj, ꞌyaj si nani ruhuāj. Ni̱ ga̱huīj nga̱ nimānj ruhuāj. Gu̱na aninꞌ é re̱ꞌ nan gu̱nun ruhua á re̱ꞌ ngāj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Hué dan ni̱ ganꞌanj Jesús do̱j ne̱ꞌ chrej rian. Ni̱ ganiquinꞌ ráj da̱coj sij ganun rian sij rian yoꞌój. Ni̱ gachínj jniꞌyaj sij rian Yanꞌanj. Ni̱ gataj sij: ―Tata chréꞌ, sisi̱ ga̱ꞌue, ni̱ ga̱ꞌne re̱ꞌ sayun ranꞌānj nan. Sani̱ si̱ guiꞌyáj re̱ꞌ rúnꞌ huin ruhua manꞌānj. Maan si gui̱ꞌyáj re̱ꞌ rúnꞌ aranꞌ ruhua manꞌán re̱ꞌ. ―Daj gataj Jesús gunun manꞌan Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ngaa ni̱ nanica̱j Jesús rian ma̱n ni tsínj nicoꞌ sij. Ni̱ atoj ani̱nꞌ síꞌ nariꞌ sij. Ngaa ni̱ gataj sij gunun Pedro: ―Ni̱ si̱ gaꞌue ni̱ ꞌngo̱ hora gu̱nun ruhua ani̱nꞌ é re̱ꞌ ngāj ga̱ míꞌ. ");
INSERT INTO trq_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ga̱ gu̱nun ruhua aninꞌ é re̱ꞌ ga̱chinj jniꞌyaj aninꞌ é re̱ꞌ rian Yanꞌanj sisi̱ si̱ guinij aninꞌ é re̱ꞌ rian gaquinꞌ ngaa ga̱tsij sichre niman aninꞌ é re̱ꞌ. Huin ruhua nimán re̱ꞌ gui̱ꞌyaj sa̱ꞌ re̱ꞌ. Sani̱ nun ga̱huin nucuaj nnee̱ cúj aninꞌ é re̱ꞌ mánj. ―Daj gataj Jesús gunun ni hua̱ꞌnij tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ngaa ni̱ ganꞌanj ru̱huaꞌ yún Jesús. Ni̱ gachínj jniꞌyaj sij rian Yanꞌanj. Ni̱ gataj sij: ―Tata chréꞌ, sisi̱ si̱ gaꞌue ga̱nanī rian sayun nan, ngaa ni̱ gui̱ꞌyáj re̱ꞌ si ga̱ranꞌ ruhuá re̱ꞌ ngāj. ―Daj gataj Jesús gunun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ni̱ ngaa nanica̱j ru̱huaꞌ yún sij, ni̱ atoj ru̱huaꞌ yún ani̱nꞌ síꞌ nariꞌ sij. Daj si aꞌuij rian aninꞌ síꞌ, guiꞌyaj nnej. ");
INSERT INTO trq_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ngaa ni̱ gahui sij rian ni síꞌ. Ni̱ ganꞌanj ga̱chinj jniꞌyaj sij rian Yanꞌanj guisíj hua̱ꞌnij. Ni̱ hué gue̱ nuguanꞌ daj gataj ru̱huaꞌ yún sij rian Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ngaa ni̱ nanica̱j sij rian ma̱n ni tsínj nicoꞌ sij. Ni gataj sij: ―Ga̱ꞌue ga̱toj ani̱nꞌ é re̱ꞌ, ni̱ na̱ranj ruhua á re̱ꞌ aj. Guisíj hora ga̱ꞌnaꞌ tsínj na̱gaꞌuiꞌ manꞌānj raꞌa ni tsínj ꞌyaj gaquinꞌ huīnj daꞌníj ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Na̱chica ani̱nꞌ é re̱ꞌ ga̱nꞌanj néꞌ. Hua gahuin ni̱chrunꞌ tsínj ꞌna̱ꞌ na̱gaꞌuiꞌ yūnj rian ni tsínj nicaj sun. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Da aꞌmi gue̱ Jesús ngaa guisíj Judas huin síꞌ ꞌngo̱ ni xu̱huij ranꞌ ni tsínj nicoꞌ sij. Ni̱ nicaj dugüiꞌ síꞌ nga̱ nico ni tsínj guisíj síꞌ. Ni̱ ata ni sij espada nej, chrun nej, huaj ni sij. Ni̱ gaꞌníj ni chrej aꞌninꞌ nga̱ ni tsínj huin achij scanij ni ngüi̱ ga̱ꞌnaꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ni̱ hua digyán Judas ꞌngo̱ chrej da̱j gui̱niꞌi ni sij u̱n tsínj huin gui̱daꞌa ni sij. Ni̱ gataj síꞌ: ―Tsínj ga̱run duꞌuāj daj hué sij huin Jesús aj. Gui̱daꞌa ni é re̱ꞌ sij. ―Daj hua gataj Judas rian ni tsínj nicaj dugüiꞌ nga̱ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ngaa ni̱ ꞌngo̱ gahuin ni̱chrunꞌ Judas rian niquinꞌ Jesús. Ni̱: ―Hua sa̱ꞌ nné re̱ꞌ, maestro. ―Gataj sij gunun Jesús. Ni̱ garun duꞌua sij síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ngaa ni̱ gataj Jesús gunun síꞌ: ―Amigo, u̱n sin huin, ni̱ ꞌna̱ꞌ re̱ꞌ únj. ―Daj gataj Jesús gunun Judas. Hué dan ni̱ gahuin ni̱chrunꞌ ni sij, ni̱ guidaꞌa ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ngaa ni̱ guiri ꞌngo̱ tsínj niquinꞌ nga̱ Jesús si-espada sij. Ni̱ gaꞌuiꞌ sij tsínj ꞌyaj sun rian chrej huin achij ni̱nꞌ daj. Ni̱ güéj ni̱nꞌ chraquij síꞌ, guiꞌyaj sij. ");
INSERT INTO trq_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ngaa ni̱ gataj Jesús rian tsínj nicaj espada daj: ―Na̱ꞌnij re̱ꞌ si-espadá re̱ꞌ chruhua pena. Daj si daranꞌ ni tsínj gu̱nunꞌ nga̱ espada, ni̱ ga̱huiꞌ ni sij, gui̱ꞌyaj espada nej. ");
INSERT INTO trq_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nun niꞌí re̱ꞌ sisi̱ ga̱ꞌue ga̱chinj jniꞌyā rian chrē, ni̱ ga̱ꞌnij chrē hué hora nan xu̱huij xiꞌninꞌ ni ángel ga̱ꞌnaꞌ chra̱cuij yūnj níꞌ. ");
INSERT INTO trq_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Sani̱ sisi̱ daꞌngaꞌ daj gui̱ꞌyā, ni̱ naꞌue ga̱huin yya da̱j rúnꞌ ataj si-nu̱guanꞌ Yanꞌanj. Daj si ataj si-nu̱guanꞌ Yanꞌanj sisi̱ hua nia̱n gui̱ranꞌānj sayun nánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ni̱ hora daj ni̱ gataj Jesús gunun ni tsínj ꞌna̱ꞌ daj: ―Ni̱ u̱n sin huin ni̱ ata á re̱ꞌ espada nga̱ chrun nej ꞌna̱ꞌ gui̱daꞌa á re̱ꞌ yūnj únj. Huēj huin ꞌngo̱ tsínj tu̱ ruhua ni é re̱ꞌ níꞌ. Yaꞌyoj ganēj chruhua nuhui digyānj rian ni é re̱ꞌ. Ni̱ nun gui̱daꞌa ni é re̱ꞌ yūnj mánj. ");
INSERT INTO trq_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Sani̱ ranꞌānj sayun nan sisi̱ ga̱huin yya da̱j rúnꞌ gataj ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. ―Daj gataj Jesús. Ngaa ni̱ dunáj daranꞌ ni tsínj nicoꞌ Jesús manꞌan sij. Ni̱ gunánj ni síꞌ rian Jesús. ");
INSERT INTO trq_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ngaa ni̱ ni tsínj guidaꞌa Jesús, ni̱ nicaj ni sij síꞌ ganꞌanj ni sij rian tsínj gu̱ꞌnaj Caifás huin síꞌ chrej huin achij ni̱nꞌ. Ni̱ yuꞌuj daj hua nahuin yuꞌ ni tsínj digyán ley nga̱ ni tsínj huin achij nej. ");
INSERT INTO trq_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ni̱ ga̱nꞌ huaj Pedro nicoꞌ síꞌ huaj ru̱cu Jesús. Ni̱ guisíj sij rian ducuá chrej huin achij daj. Ni̱ ri̱an hua ta rian hueꞌ daj gatúj sij. Ni̱ ganꞌanj ga̱ne sij nga̱ ni snado mán yuꞌuj daj. Daj si huin ruhua sij gui̱niꞌi sij sisi̱ da̱j ga̱nahuij daranꞌ ni nuguanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ngaa ni̱ nanoꞌ ni chrej aꞌninꞌ nga̱ ni tsínj ꞌyaj junta daj nuguanꞌ nne̱ xiꞌí Jesús sisi̱ daꞌngaꞌ daj ga̱ꞌue da̱gahuiꞌ ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Sani̱ nun na̱riꞌ ni sij ꞌngo̱ nuguanꞌ nne̱ daj. Ni̱ nu̱nj si gaꞌna̱ꞌ nico ni tsínj gaꞌmi nne̱ xiꞌí Jesús, sani̱ nun na̱riꞌ ni sij ꞌngo̱ gaquinꞌ sisi̱ ga̱huiꞌ síꞌ. Hué dan ni̱ gaꞌna̱ꞌ hui̱j tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ni̱ gataj nu̱ngüej sij: ―Gataj tsínj nan sisi̱ ga̱ꞌue du̱guane sij ducuá Yanꞌanj. Ni̱ xiráj hua̱ꞌnij güi, ni̱ na̱guiꞌyaj sij ango nuhui. ―Daj gataj nu̱ngüej tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ngaa ni̱ naxu̱man chrej huin achij ni̱nꞌ. Ni̱ gataj sij gunun Jesús: ―Nitaj ꞌngo̱ nuguanꞌ na̱nicaj re̱ꞌ únj. Ni̱ u̱n sin huin si ataj nu̱ngüej tsínj daj xiꞌí re̱ꞌ únj. ―Daj gataj sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Sani̱ dínj guiniquinꞌ duꞌua Jesús nun gaꞌmi sij. Ngaa ni̱ gataj chrej huin achij ni̱nꞌ daj gunun Jesús: ―Aꞌnīj sun rián re̱ꞌ nga̱ si-xugüi Yanꞌanj hua ni̱ꞌnaꞌ sisi̱ ga̱taj yyá re̱ꞌ sisi̱ hué re̱ꞌ huin Cristo daꞌníj Yanꞌanj. ―Daj gataj sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Hué dan ni̱ gataj Jesús: ―Huēj huin da̱j rúnꞌ atáj re̱ꞌ nánj. Ni̱ atā gu̱nun ni é re̱ꞌ sisi̱ huēj huin daꞌníj ni ngüi̱. Ni̱ gui̱niꞌi ni é re̱ꞌ sisi̱ ga̱nēj ne̱ꞌ chrej raꞌa sa̱ꞌ Yanꞌanj nucuaj ni̱nꞌ nne xataꞌ. Ni̱ gui̱niꞌi ni é re̱ꞌ ga̱ꞌnāj rian nga xataꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ngaa ni̱ gutsiꞌ chrej huin achij ni̱nꞌ daj si-ganꞌ sij. Ni̱ gataj sij: ―Gaꞌmi quij síꞌ xiꞌí Yanꞌanj anj. Nitaj si gui̱ꞌyóꞌ ni testigo ga̱ mánj. Acuanꞌ gunun ni é re̱ꞌ si gaꞌmi quij sij xiꞌí Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Da̱j gui̱ꞌyaj néꞌ, ruhua ni é re̱ꞌ únj. ―Daj gataj chrej huin achij ni̱nꞌ gunun ni tsínj ganꞌanj junta daj. Ni̱: ―Daꞌui sij gaquinꞌ, ni̱ hua nia̱n ga̱huiꞌ yya sij. ―Daj gataj ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ngaa ni̱ gara staꞌnunj ni sij rian Jesús. Ni̱ gaꞌuiꞌ ni sij síꞌ nej. Ni̱ garaꞌui ango ni sij rian síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ni̱ gataj ni sij: ―Ga̱hui chra̱ re̱ꞌ sisi̱ u̱n tsínj gaꞌuíꞌ re̱ꞌ huín re̱ꞌ Cristo. ―Daj gataj ni sij gaꞌmi ducu ni sij rian Jesús. ");
INSERT INTO trq_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ni̱ nne Pedro ne̱ꞌ chrej xe̱ꞌ ta rian ducuá chrej huin achij ni̱nꞌ daj. Ni̱ gahuin ni̱chrunꞌ ꞌngo̱ yunꞌunj xa̱na ꞌyaj sun hueꞌ daj. Ni̱ gataj únꞌ: ―Hué re̱ꞌ nicaj dugüiꞌ nga̱ Jesús tsínj ꞌna̱ꞌ estado Galilea aj. ―Daj gataj únꞌ gunun Pedro. ");
INSERT INTO trq_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Sani̱ nun ga̱ꞌuej Pedro rian daranꞌ ni tsínj ma̱n yuꞌuj daj. Ni̱ gataj sij: ―Nun niꞌīnj u̱n si atáj re̱ꞌ mánj. ―Gataj Pedro gunun únꞌ. ");
INSERT INTO trq_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ngaa ni̱ gahui sij ne̱ꞌ chrej xe̱ꞌ ne̱ꞌ rian atúj ni ngüi̱. Ni̱ guiniꞌi ango yunꞌunj xa̱na ꞌyaj sun manꞌan sij. Ni̱ gataj únꞌ gunun ni tsínj mán yuꞌuj daj: ―Hué tsínj nan nicaj dugüiꞌ nga̱ Jesús, tsínj ꞌna̱ꞌ xumanꞌ Nazaret. ―Daj gataj únꞌ gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Sani̱ nun ga̱ꞌuej ru̱huaꞌ yún Pedro. Ni̱ gutaꞌ ni̱ca yya sij. Ni̱ gataj sij: ―Nun niꞌīnj tsínj da mánj. ―Daj gataj Pedro gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ngaa ni̱ ango hora leꞌ, ni̱ gahuin ni̱chrunꞌ ni tsínj mán yuꞌuj daj. Ni̱ gataj ni sij gunun Pedro: ―Xa̱ngaꞌ huín re̱ꞌ ꞌngo̱ ni tsínj daj. Daj si aꞌmí re̱ꞌ da̱j rúnꞌ aꞌmi ni sij. ―Daj gataj ni tsínj daj gunun Pedro. ");
INSERT INTO trq_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Hué dan ni̱ gaxi̱ꞌi sij gaꞌmi quij sij. Ni̱ gutaꞌ ni̱ca yya sij. Ni̱ gataj sij: ―Nun niꞌīnj tsínj da mánj. ―Daj gataj Pedro gunun ni sij. Ni̱ hué gue̱ hora daj gaguáj doꞌloj ꞌngo̱ duꞌua xúꞌ. ");
INSERT INTO trq_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ngaa ni̱ gananun ruhua Pedro si gataj Jesús gunun síꞌ: “Asi̱j nun ga̱guaj doꞌloj si ꞌngo̱ duꞌua xúꞌ, ni̱ ga̱taj re̱ꞌ si hua̱ꞌnij si nun niꞌí re̱ꞌ manꞌānj mánj.” Daꞌngaꞌ daj hua gataj Jesús gunun Pedro. Ngaa ni̱ gahui Pedro ganꞌanj sij ne̱ꞌ chrej xe̱ꞌ. Ni̱ gaco ni̱nꞌ ruhua sij. ");
INSERT INTO trq_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ni̱ ngaa guerengaꞌ, ni̱ digaꞌmi dugüiꞌ daranꞌ ni chrej aꞌninꞌ nga̱ ni tsínj huin achij scanij ni ngüi̱ sisi̱ na̱gaꞌuiꞌ ni sij Jesús ga̱huiꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ni̱ gumíj ni sij Jesús. Ni̱ nicaj ni sij síꞌ ganꞌanj ni sij nagaꞌuiꞌ ni sij síꞌ raꞌa Pilato huin síꞌ gobernado. ");
INSERT INTO trq_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ni̱ Judas huin tsínj nagaꞌuiꞌ Jesús rian ni tsínj nicaj sun. Ni̱ ngaa guiniꞌi Judas sisi̱ ga̱huiꞌ Jesús, gui̱ꞌyaj ni sij, ni̱ ducu ganani ruhua sij. Ni̱ nagaꞌuiꞌ sij ico̱ chiꞌ sanꞌanj plata daj rian ni chrej aꞌninꞌ nga̱ ni tsínj huin achij nej. ");
INSERT INTO trq_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ni̱ gataj sij: ―Daꞌuīj gaquinꞌ xiꞌí si nagaꞌuīj ga̱huiꞌ ꞌngo̱ tsínj nitaj ꞌngo̱ gaquinꞌ guiꞌyaj. ―Daj gataj Judas ngaa nani ruhua sij. Sani̱ gataj ni sij: ―Ni̱ u̱n si gui̱ꞌyaj únj únj. Si-ga̱quinꞌ manꞌán re̱ꞌ huin nan. ―Daj gataj ni sij gunun Judas. ");
INSERT INTO trq_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ngaa ni̱ dagamanꞌ Judas sanꞌanj huin plata daj chruhua nuhui. Ni̱ ganꞌanj do̱coꞌ sij manꞌan sij. Ni̱ gahuiꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Hué dan ni̱ naranꞌ ni chrej aꞌninꞌ sanꞌanj huin plata daj. Ni̱ gataj ni sij: ―Si̱ gaꞌue ga̱ꞌnij néꞌ sanꞌanj nan rian Yanꞌanj ga̱huin ofrenda xiꞌí si duꞌue tun ꞌngo̱ tsínj mánj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ngaa ni̱ uyan gaꞌmi ni sij sisi̱ gui̱ran ni sij sanꞌanj daj ꞌngo̱ doꞌój ꞌngo̱ tsínj ri chruj. Ni̱ daꞌngaꞌ daj guiꞌyaj ni sij sisi̱ gui̱riꞌ ni sij ꞌngo̱ yuꞌuj ga̱chinꞌ ni sij ni ngüi̱ ꞌna̱ꞌ ango rian xumanꞌ. ");
INSERT INTO trq_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Xiꞌí daj gu̱ꞌnaj yoꞌój daj daꞌ güi acuanꞌ yoꞌój tun. ");
INSERT INTO trq_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Hué daj gahuin yya da̱j rúnꞌ gaꞌmi Jeremías tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. Ni̱ gataj síꞌ: “Nacaj ni sij ico̱ chiꞌ sanꞌanj plata. Daj si daꞌngaꞌ daj huin duꞌue ꞌngo̱ tsínj daj da̱j rúnꞌ naruꞌue ni tsínj israelita. ");
INSERT INTO trq_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ni̱ sanꞌanj daj guiránj ni sij doꞌój tsínj ri chruj da̱j rúnꞌ gaꞌninꞌ Señor sun riānj.” ―Daj gataj Jeremías. ");
INSERT INTO trq_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ngaa ni̱ ganiquinꞌ Jesús rian gobernado. Ni̱ ganachínj snanꞌanj síꞌ Jesús. Ni̱: ―Hué re̱ꞌ huin si-rey ni ngüi̱ israelita níꞌ. ―Gataj gobernado. Ngaa ni̱: ―Hué re̱ꞌ ataj nánj. ―Gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sani̱ ngaa gaꞌmi gaquinꞌ ni chrej aꞌninꞌ nga̱ ni tsínj huin achij, ni̱ nun da̱nicaj Jesús ni̱ a̱ ꞌngo̱ nuguanꞌ rian ni sij. ");
INSERT INTO trq_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ngaa ni̱ gataj gobernado daj tsínj gu̱ꞌnaj Pilato gunun Jesús: ―Nunún re̱ꞌ u̱ndaj gaquinꞌ aꞌmi ni sij rian xiꞌí re̱ꞌ di míꞌ. ―Daj gataj Pilato gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Sani̱ ni̱ a̱ ꞌngo̱ nuguanꞌ nun ga̱taj Jesús gunun Pilato. Xiꞌí daj ni̱ ni̱nꞌ ruhua garáj yanꞌanj ruhua sij niꞌyaj sij Jesús. ");
INSERT INTO trq_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ni̱ daꞌ go̱ꞌngo yoꞌ, ni̱ hua ꞌngo̱ ducuánj nicoꞌ Pilato sisi̱ ri síꞌ ꞌngo̱ tsínj nu̱n ducuaga̱ꞌ go̱ꞌngo guiꞌyanj pascua. Tsínj ga̱ranꞌ ruhua ni ngüi̱, ni̱ gui̱ri sij síꞌ ducuaga̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ni̱ ngaa daj, ni̱ nu̱n ꞌngo̱ tsínj gu̱ꞌnaj Barrabás ducuaga̱ꞌ. Ni̱ niꞌi sa̱ꞌ ni ngüi̱ sisi̱ daꞌui sij nico gaquinꞌ. ");
INSERT INTO trq_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ngaa ni̱ nachínj snanꞌanj Pilato ni tsínj nahuin yuꞌ daj. Ni̱ gataj sij: ―Ni̱ u̱n tsínj ga̱ranꞌ ruhua á ni é re̱ꞌ sisi̱ gui̱rīj ducuaga̱ꞌ, ruhua á re̱ꞌ únj. Asi̱ gui̱rīj Barrabás níꞌ. Asi̱ gui̱rīj tsínj gu̱ꞌnaj Cristo sa̱ꞌ. ―Daj gataj Pilato gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Daj si xacaj Pilato cuenta sisi̱ nagaꞌuiꞌ ni sij Jesús rian xiꞌí si xicoj ruhua ni sij niꞌyaj ni sij manꞌan síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ni̱ ngaa gane Pilato rian naguiꞌyaj yya sij ni gaquinꞌ, ni̱ gaꞌníj nica̱ sij ꞌngo̱ nuguanꞌ ganꞌanj rian sij. Ni̱ gataj únꞌ gunun sij: ―Si̱ diguíj re̱ꞌ si-nu̱guanꞌ tsínj hua ni̱ca niman nan mánj. Daj si guiranꞌānj ꞌngo̱ sayun nico xiꞌí sij yya̱j ngaa gaꞌnīj aj. ―Daj gataj unj rian síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sani̱ guiꞌyaj fuerza ni chrej aꞌninꞌ nga̱ ni tsínj huin achij sisi̱ ga̱chinj ni ngüi̱ rian Pilato sisi̱ ga̱hui Barrabás ducuaga̱ꞌ. Ni̱ sisi̱ ga̱chinj ni ngüi̱ sisi̱ ga̱huiꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ngaa ni̱ gataj gobernado gunun ni ngüi̱: ―Da̱j hua yya tsínj gui̱rīj, ruhua ni é re̱ꞌ únj. ―Daj gataj sij gunun ni ngüi̱. Ngaa ni̱: ―Gui̱ri re̱ꞌ Barrabás. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ngaa ni̱ gataj Pilato gunun ni sij: ―Da̱j huin ruhua ni é re̱ꞌ u̱n sin huin gui̱ꞌyā nga̱ Jesús tsínj gu̱ꞌnaj Cristo únj. ―Daj gataj sij gunun ni ngüi̱. Ngaa ni̱: ―Ga̱ri re̱ꞌ gaquíj Jesús gui̱nicoꞌ sij rian rugutsi̱, ruhua únj. ―Daj gataj daranꞌ ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ngaa ni̱ gataj Pilato gunun ni sij: ―Da̱j hua gaquinꞌ guiꞌyaj sij únj. ―Daj gataj Pilato. Sani̱ na̱anj gaguáj ru̱huaꞌ yún ni sij: ―Ga̱ri re̱ꞌ gaquíj Jesús gui̱nicoꞌ sij rian rugutsi̱ aj. ―Daj gaguáj ni ngüi̱ daj. ");
INSERT INTO trq_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ni̱ guiniꞌi Pilato sisi̱ naꞌue ga̱naꞌman ruhua ni ngüi̱. Sani̱ huaj ni̱nꞌ ruhua gaꞌman ruhua ni sij. Ngaa ni̱ guidaꞌa sij nnee. Ni̱ nania̱ꞌ sij rian ni ngüi̱. Ni̱ gataj sij: ―Sé xiꞌīj huin si ga̱huiꞌ tsínj hua ni̱ca niman nan mánj. Güenda manꞌan ni é re̱ꞌ huin nánj. ―Daj gataj Pilato. ");
INSERT INTO trq_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ngaa ni̱ gataj ni ngüi̱ daj: ―Xiꞌí ni da̱ꞌnij únj ga̱huiꞌ tsínj nan anj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ngaa ni̱ guiri Pilato Barrabás rian ni ngüi̱. Ni̱ gaꞌuiꞌ ni sij nneꞌ xiráj Jesús, guiꞌyaj Pilato. Hué dan ni̱ nagaꞌuiꞌ Pilato Jesús rian ni sij sisi̱ ga̱ri ni sij gaquíj síꞌ gui̱nicoꞌ síꞌ rian rugutsi̱. ");
INSERT INTO trq_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ngaa ni̱ nicaj ni si-snado gobernado ganꞌanj ni sij Jesús ta rian palacio daj. Ni̱ ganahuin yuꞌ daranꞌ ango ni snado rian Jesús, guiꞌyaj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ni̱ guiri ni sij si-ganꞌ síꞌ. Ni̱ naꞌníj ni sij ꞌngo̱ atsij rian ru̱miꞌ mare xá Jesús gunu̱n síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ni̱ runꞌun ni sij ꞌngo̱ yaꞌa̱ tanj guiꞌyaj ni sij ꞌngo̱ corona gaꞌníj ni sij chra̱ Jesús. Ni̱ garíj ni sij ꞌngo̱ riuj raꞌa sa̱ꞌ síꞌ. Ngaa ni̱ ganiquinꞌ ráj da̱coj ni sij rian síꞌ. Ni̱ gaꞌngaꞌ na̱co ni sij. Ni̱ gaꞌmi ducu ni sij guiniꞌyaj ni sij Jesús. Ni̱ gataj ni sij: ―Hua ꞌueé ni̱nꞌ si-rey ni tsínj israelita. ―Daj gaguáj ni sij gaꞌmi ducu ni sij niꞌyaj ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ni̱ gara staꞌnunj ni sij rian Jesús nej. Ni̱ guidaꞌa ni sij riuj daj gaꞌuiꞌ ni sij chra̱ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ni̱ ngaa guisíj guiꞌyaj ducu ni sij, ni̱ guiri ni sij atsij daj. Ni̱ naꞌníj ni sij si-ganꞌ Jesús xá síꞌ ru̱huaꞌ yún. Hué dan ni̱ guiri ni sij manꞌan síꞌ ganꞌanj sij güenda ga̱ri ni sij gaquíj manꞌan síꞌ gui̱nicoꞌ síꞌ rian rugutsi̱. ");
INSERT INTO trq_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ni̱ ngaa gahui ni sij, ni̱ nacaj dugüiꞌ ni sij nga̱ ꞌngo̱ tsínj ꞌna̱ꞌ xumanꞌ gu̱ꞌnaj Cirene. Ni̱ gu̱ꞌnaj síꞌ Simón. Ni̱ chranꞌ yunꞌunj ni sij sisi̱ ga̱ta síꞌ si-ru̱gutsi Jesús. ");
INSERT INTO trq_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ngaa ni̱ guisíj ni sij ꞌngo̱ dacan gu̱ꞌnaj Gólgota. Ni̱ nuguanꞌ daj gata ruhuaj dacan cúj chra̱ níman. ");
INSERT INTO trq_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ni̱ gaꞌuiꞌ ni sij vino go̱ꞌo Jesús nachej dugüiꞌ-íꞌ nga̱ si-gai̱ꞌ xucu. Sani̱ ngaa goꞌo Jesús do̱j, ni̱ nun ga̱ꞌuej sij goꞌo sij ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ni̱ ngaa gari ni sij gaquíj Jesús docoꞌ ni sij síꞌ rian rugutsi̱, ni̱ ducu ni snado sisi̱ u̱n tsínj ga̱hui sa̱ꞌ ni̱caj sij si-ganꞌ síꞌ ga̱nꞌanj sij. Ni̱ daꞌngaꞌ daj gahuin guiꞌyaj ni sij sisi̱ ga̱huin yya da̱j rúnꞌ gataj tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. Ni̱ gataj síꞌ: “Guraꞌ daꞌaj ni sij si-ganꞌānj. Ni̱ ducu ni sij sisi̱ u̱n tsínj ga̱hui sa̱ꞌ, ni̱ ni̱caj síꞌ si-ganꞌānj ga̱nꞌanj.” Daj gataj tsínj daj asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ni̱ ganꞌanj ga̱ne ni sij yuꞌuj daj du̱gumi ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ni̱ garun ni sij letra chra̱ si-ru̱gutsi Jesús u̱n si xi̱ꞌi huin dagahuiꞌ ni sij. Ni̱ letra daj ataj: “Nan huin Jesús Si-Rey ni tsínj israelita.” Daꞌngaꞌ daj garun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ni̱ docoꞌ ni snado yahuij tsínj tu̱ rian yahuij rugutsi̱. Ni̱ nicoꞌ ꞌngo̱ sij raꞌa sa̱ꞌ Jesús, ni̱ ango sij chrej raꞌa ro̱tsi síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ni̱ gaꞌmi quij ni ngüi̱ gachin. Ni̱ dugunun ni sij chra̱ ni sij. ");
INSERT INTO trq_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ni̱ gataj ni sij: ―Hué re̱ꞌ huin si du̱guane nuhui nico, ni̱ hua̱ꞌnij gue̱ güi na̱guiꞌyaj ru̱huaꞌ yún re̱ꞌ, atáj re̱ꞌ níꞌ. Ngaa ni̱ ga̱nacaj re̱ꞌ manꞌán re̱ꞌ. Sisi̱ hué re̱ꞌ huin daꞌníj Yanꞌanj, ni̱ gui̱nanij re̱ꞌ rian rugutsi̱ aj. ―Hué daj gataj ni ngüi̱ gaꞌmi ducu ni sij rian Jesús. ");
INSERT INTO trq_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ni̱ hué ꞌngo̱ nuguanꞌ daj gaꞌmi ducu ni chrej aꞌninꞌ nga̱ ni maestro digyán ley nej, ni tsínj fariseo nej, nga̱ ni tsínj huin achij nej. Ni̱ gataj ni sij: ");
INSERT INTO trq_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Nacaj sij ango ni ngüi̱. Sani̱ naꞌue ga̱nacaj sij manꞌan sij. Sisi̱ hué si huin si-rey ni tsínj israelita, ngaa ni̱ na̱nij sij rian rugutsi̱ aj. Ngaa ni̱ gu̱xuman róꞌ ni̱ꞌyóꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Xuman ruhua sij niꞌyaj sij Yanꞌanj. Ngaa ni̱ sisi̱ ꞌi̱ ruhua Yanꞌanj niꞌya sij, ni̱ ga̱ꞌue ga̱nacaj Yanꞌanj sij yya̱j. Daj si ataj sij sisi̱ hué sij huin daꞌníj Yanꞌanj. ―Daj gaꞌmi quij ni sij rian Jesús. ");
INSERT INTO trq_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ni̱ da nu̱ngüej tsínj tu̱ nicoꞌ rian rugutsi̱ xiꞌníj Jesús gaꞌmi quij nu̱ngüej sij rian Jesús nej aj. ");
INSERT INTO trq_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ni̱ ngaa guisíj gaxu̱j, ni̱ gahuin ru̱miꞌ rian daranꞌ xungüi̱. Ni̱ gahuin ru̱miꞌ daꞌ ga hua̱ꞌnij diꞌni̱. ");
INSERT INTO trq_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ni̱ ꞌngo̱ si ga hua̱ꞌnij, ni̱ gaguáj nucuaj Jesús. Ni̱ gataj sij: ―Eli, Eli, lama sabactani. ―Daj gataj sij gaguáj sij. Ni̱ snanꞌanj manꞌan sij ruhuaj gata: Danꞌanj manꞌānj, Danꞌanj manꞌānj, u̱n sin huin, ni̱ duná re̱ꞌ urīnj únj. Daj gataj Jesús gunun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ni̱ gunun go̱ꞌngo ni tsínj niquinꞌ yuꞌuj daj si gataj Jesús. Ni̱ gataj ni sij: ―Aquínj sij ga̱ꞌnaꞌ tsínj gu̱ꞌnaj Elías aj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ngaa ni̱ hora gunánj ꞌngo̱ ni sij. Ni̱ guidaꞌa sij ꞌngo̱ gachij. Ni̱ gutáj sij nnee vino yu̱ rian gachij daj. Ni̱ gutaꞌ sij chra̱ ꞌngo̱ chrun rianj. Ni̱ dugüinꞌ sij gachij daj duꞌua Jesús sisi̱ go̱ꞌo síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Sani̱ gataj ango ni sij: ―Du̱na re̱ꞌ. Ni̱ gui̱niꞌíꞌ sisi̱ ga̱ꞌnaꞌ yya tsínj gu̱ꞌnaj Elías na̱caj síꞌ manꞌan sij. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ngaa ni̱ gaguáj nucuaj ru̱huaꞌ yún Jesús. Ni̱ gahuiꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ni̱ ꞌngo̱ tsitsiꞌ hui̱j dasu atsij nicoꞌ chruhua nuhui nico daꞌ chraj nga̱ daꞌ xiꞌij. Nga ni̱ nagunanꞌ yoꞌój. Ni̱ guisitsiꞌ huej. ");
INSERT INTO trq_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ni̱ naxiꞌníj rian gachinꞌ ni sij níman. Ni̱ ganáꞌnij nico nnee̱ cúj ni tsínj hua sa̱ꞌ niman gahuiꞌ. ");
INSERT INTO trq_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ni̱ ngaa ganáꞌnij Jesús, ni̱ gahui ni sij rian achinꞌ níman. Ni̱ gatúj ni sij chruhua xumanꞌ Jerusalén. Ni̱ guiniꞌi nico ni ngüi̱ ni sij. ");
INSERT INTO trq_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ni̱ guiniꞌi snado centurión nga̱ ango ni snado niquinꞌ dugumi Jesús. Ni̱ guiniꞌi ni sij gaꞌna̱ꞌ yún nga̱ daranꞌ si gahuin. Ngaa ni̱ ni̱nꞌ ruhua guxuꞌuiꞌ ni sij. Ni̱ gataj ni sij: ―Xa̱ngaꞌ, ni̱ hué tsínj nan huin daꞌníj Yanꞌanj anj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ni̱ ga̱nꞌ mán nico ni yunꞌunj xa̱na niꞌyaj ne Jesús. Ni̱ asi̱j gahui Jesús estado Galilea, ni̱ guinicoꞌ ni yunꞌunj xa̱na daj Jesús. Ni̱ guiꞌyaj sun ne rian manꞌan síꞌ. ");
INSERT INTO trq_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ni̱ scanij ne niquinꞌ María Magdalena nga̱ María nni Jacobo nga̱ José nej, nni nu̱ngüej daꞌníj Zebedeo nej. ");
INSERT INTO trq_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ni̱ ngaa guini̱ güi daj, ni̱ gaꞌna̱ꞌ ꞌngo̱ tsínj xuruꞌue ꞌna̱ꞌ síꞌ xumanꞌ gu̱ꞌnaj Arimatea. Ni̱ gu̱ꞌnaj síꞌ José. Ni̱ hué daj nicoꞌ síꞌ Jesús nej. ");
INSERT INTO trq_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ni̱ ganꞌanj sij rian nne Pilato gachínj sij níman Jesús. Ngaa ni̱ gaꞌninꞌ Pilato sun sisi̱ na̱gaꞌuiꞌ ni sij níman Jesús rian José. ");
INSERT INTO trq_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ngaa ni̱ nacaj José níman Jesús. Ni̱ chriꞌyanj sij atsij sa̱ꞌ xiráj níman daj. ");
INSERT INTO trq_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ni̱ gurúj sij níman chruhua ꞌngo̱ huej. Ni̱ na̱ca gayaꞌ sij huej daj nne rian doꞌój sij. Ni̱ ganaránj sij yej xxi rian huej daj. Ngaa ni̱ ganꞌanj sij. ");
INSERT INTO trq_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ni̱ yuꞌuj daj gane María Magdalena nga̱ ango María duꞌua yuꞌuj daj. ");
INSERT INTO trq_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ni̱ ango güi ngaa guisíj guiꞌyaj xugüi ni sij güi naránj ruhua ni sij, ni̱ nahuin yuꞌ ni chrej aꞌninꞌ nga̱ ni tsínj fariseo rian Pilato. ");
INSERT INTO trq_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ni̱ gataj ni sij gunun síꞌ: ―Señor, ga̱nanun ruhua únj sisi̱ ngaa ga ni̱ꞌnaꞌ tsínj digyaꞌ yunꞌunj daj, ni̱ gataj sij sisi̱ chra̱ hua̱ꞌnij güi, ni̱ ga̱naꞌnij sij. ");
INSERT INTO trq_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ngaa ni̱ ga̱ꞌninꞌ re̱ꞌ sun sisi̱ ga̱huin ran rian yuꞌuj achinꞌ níman daj da gui̱sij yaꞌnij güi nun sa̱ꞌ nun ga̱ꞌnaꞌ gui̱ꞌyaj tu̱ ni tsínj nicoꞌ sij ne̱ꞌ ni̱. Ni̱ ga̱taj ni sij rian ni ngüi̱ sisi̱ ganáꞌnij síꞌ scanij ni níman. Ni̱ ga̱huin quij nuguanꞌ digyaꞌ yunꞌunj daj daj nga̱ nuguanꞌ yya̱ gaꞌmi sini ya̱n sij. ―Daj gataj ni sij gunun Pilato. ");
INSERT INTO trq_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ngaa ni̱ gataj Pilato gunun ni sij: ―Yuꞌuj daj mán ꞌngo̱ xiꞌninꞌ snado. Ga̱nicaj ni é re̱ꞌ ga̱nꞌanj na̱guiꞌyaj ran ni é re̱ꞌ rian yuꞌuj achinꞌ níman daj. Niꞌi a ni é re̱ꞌ da̱j gui̱ꞌyaj á re̱ꞌ. ―Daj gataj Pilato gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ngaa ni̱ gahui ni sij ganꞌanj na̱guiꞌyaj xitinj ni sij rian yuꞌuj daj. Ni̱ garun ni sij si-sello ni sij rian yej guiránj ni sij. Ni̱ gani ni sij snado du̱gumi ni síꞌ rian achinꞌ níman daj. ");
INSERT INTO trq_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ni̱ gachin güi naránj ruhua ni sij. Ni̱ ngaa ruhua gue̱rengaꞌ güi gudungu, ni̱ gaꞌna̱ꞌ María Magdalena nga̱ ango María gui̱niꞌyaj nu̱ngüej unj rian huej rian gachinꞌ ni sij níman. ");
INSERT INTO trq_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ni̱ gaꞌna̱ꞌ nucuaj ꞌngo̱ yún. Daj si gaꞌna̱ꞌ ꞌngo̱ ángel xataꞌ gaꞌníj Señor. Ni̱ guisíj ángel daj rian yuꞌuj daj. Ni gaꞌnej ángel yej xxi hua ránj rian yuꞌuj gachinꞌ níman daj. Ni̱ ganꞌanj ga̱ne ángel rian yej daj. ");
INSERT INTO trq_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ni̱ ran ángel daj da̱j rúnꞌ ngaa ran ꞌyaj duꞌui. Ni̱ da̱j rúnꞌ hua ga̱tsi yuꞌueꞌ, ni̱ daꞌngaꞌ daj hua ga̱tsi si-ganꞌ ángel daj. ");
INSERT INTO trq_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ni̱ ducu guxuꞌuiꞌ ni snado dugumi daj. Ni̱ nagunánj ni sij, guiꞌyaj si xuꞌuiꞌ ni sij. Ni̱ guinij ru̱miꞌ ni sij. Ni̱ rúnꞌ hua níman hua ni sij. ");
INSERT INTO trq_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Sani̱ gataj ángel gunun nu̱ngüej yunꞌunj xa̱na daj: ―Si̱ guxuꞌuiꞌ nu̱ngüej é re̱ꞌ mánj. Daj si niꞌīnj sisi̱ nanoꞌ nu̱ngüej é re̱ꞌ Jesús tsínj guinicoꞌ rian rugutsi̱. ");
INSERT INTO trq_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nitaj si ngaj sij yuꞌuj nan ga̱ mánj. Daj si da̱j rúnꞌ gataj sij gunun ni é re̱ꞌ, ni̱ daꞌngaꞌ daj ganáꞌnij sij. Ga̱huaꞌ nu̱ngüej é re̱ꞌ gui̱niꞌi nu̱ngüej é re̱ꞌ rian gachinꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ni̱ güi̱j yoo̱ nu̱ngüej é re̱ꞌ ga̱taj snanꞌanj nu̱ngüej é re̱ꞌ rian ni tsínj nicoꞌ sij sisi̱ ganáꞌnij sij scanij ni níman. Ni̱ ga̱taj á re̱ꞌ sisi̱ ga̱nꞌanj sini sij estado Galilea. Ni̱ yuꞌuj daj gui̱niꞌi ni é re̱ꞌ manꞌan sij. Daj ga̱taj snanꞌanj nu̱ngüej é re̱ꞌ gu̱nun ni sij. Ni̱ huēj ataj gu̱nun nu̱ngüej é re̱ꞌ. ―Daj gataj ángel daj gunun nu̱ngüej yunꞌunj xa̱na daj. ");
INSERT INTO trq_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ngaa ni̱ gunánj yoo̱ nu̱ngüej únꞌ rian yuꞌuj daj. Ni̱ guxuꞌuiꞌ nu̱ngüej únꞌ. Sani̱ gahuin nia̱ꞌ ruhua nu̱ngüej únꞌ nej. Ni̱ gunánj nu̱ngüej únꞌ ganꞌanj nataꞌ únꞌ nuguanꞌ daj gunun ni tsínj nicoꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ni̱ ngaa huaj nu̱ngüej únꞌ chruhua chrej, ni̱ nacaj dugüiꞌ Jesús nga̱ nu̱ngüej únꞌ. Ni̱ gataj sij: Ga̱huin nia̱ꞌ ruhua nu̱ngüej é re̱ꞌ. Gataj sij. Ngaa ni̱ gahuin ni̱chrunꞌ nu̱ngüej únꞌ rian niquinꞌ Jesús. Ni̱ nanan nu̱ngüej únꞌ dacój Jesús. Ni̱ gaꞌmi sa̱ꞌ nu̱ngüej únꞌ rian sij. ");
INSERT INTO trq_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ngaa ni̱ gataj Jesús gunun nu̱ngüej únꞌ: ―Si̱ guxuꞌuiꞌ nu̱ngüej é re̱ꞌ mánj. Maan si ga̱nꞌanj ga̱taj snanꞌanj nu̱ngüej é re̱ꞌ rian ni jnān sisi̱ ga̱nꞌanj ni sij estado Galilea. Ni̱ yuꞌuj daj gui̱niꞌi ni sij manꞌānj. ");
INSERT INTO trq_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ni̱ ngaa huaj nu̱ngüej únꞌ chruhua chrej, ni̱ ganꞌanj go̱ꞌngo ni snado dugumi daj xumanꞌ daj. Ni̱ ganataꞌ ni sij daranꞌ si gahuin rian ni chrej aꞌninꞌ. ");
INSERT INTO trq_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ngaa ni̱ ganahuin yuꞌ ni tsínj daj nga̱ ni tsínj huin achij sisi̱ uyan ga̱ ruhua daranꞌ ni sij da̱j gui̱ꞌyaj ni sij. Ni̱ nico sanꞌanj gaꞌuiꞌ ni sij rian ni snado. ");
INSERT INTO trq_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ni̱ gataj ni sij gunun ni síꞌ: ―Ga̱taj ni é re̱ꞌ sisi̱ ngaa ne̱ꞌ ni̱, ni̱ gaꞌna̱ꞌ guiꞌyaj tu̱ ni tsínj nicoꞌ Jesús níman daj ngaa atoj ni únj anj. Daꞌngaꞌ daj ga̱taj ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ni̱ sisi̱ gu̱nun gobernado si guiꞌyaj néꞌ, ngaa ni̱ ga̱ꞌmi sa̱ꞌ únj nga̱ síꞌ. Ngaa ni̱ ga̱nacaj únj ni é re̱ꞌ. ―Daꞌngaꞌ daj gataj ni chrej aꞌninꞌ rian ni snado. ");
INSERT INTO trq_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ngaa ni̱ ganacaj ni snado sanꞌanj gaꞌuiꞌ ni sij daj. Ni̱ guiꞌyaj ni sij da̱j rúnꞌ gataj ni chrej aꞌninꞌ gunun ni sij. Ni̱ da̱j rúnꞌ gaꞌmi yya̱ ni snado daj daꞌngaꞌ daj aꞌmi ni tsínj israelita daꞌ güi acuanꞌ. ");
INSERT INTO trq_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Asíj ni̱ ganꞌanj xa̱n ni tsínj nicoꞌ Jesús estado Galilea rian quij hua gataj Jesús sisi̱ ga̱nꞌanj ni sij. ");
INSERT INTO trq_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ni̱ ngaa guiniꞌi ni sij Jesús, ni̱ ganiquinꞌ ráj da̱coj ni sij rian síꞌ gaꞌmi sa̱ꞌ ni sij. Sani̱ gani hui̱j ruhua go̱ꞌngo ni sij xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ngaa ni̱ gahuin ni̱chrunꞌ Jesús, ni̱ gataj sij: ―Riqui Yanꞌanj sisi̱ gui̱nicā daranꞌ sun ne̱ꞌ xataꞌ nga̱ chruhua xungüi̱ nej. ");
INSERT INTO trq_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Xiꞌí daj, ni̱ ga̱nꞌanj di̱gyán ni é re̱ꞌ nuguanꞌ sa̱ꞌ rian daranꞌ ni ngüi̱ ma̱n chruhua xungüi̱. Ni̱ gui̱nicoꞌ ni sij manꞌānj, gui̱ꞌyaj ni é re̱ꞌ. Ni̱ du̱guataꞌ nnee ni é re̱ꞌ ni sij nga̱ si-xugüi chrē nga̱ si-xugüi manꞌānj nej, si-xugüi Espíritu Santo nej aj. ");
INSERT INTO trq_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ni̱ di̱gyán ni é re̱ꞌ rian ni sij sisi̱ da̱gahuin ni sij daranꞌ ni nuguanꞌ gaꞌnīj sun rian ni é re̱ꞌ. Ni̱ gui̱niꞌi ni é re̱ꞌ sisi̱ daranꞌ ni güi achē nga̱ ni é re̱ꞌ da gui̱sij ga̱nahuij xungüi̱ aj. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij.");
INSERT INTO trq_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nan huin gaxi̱ꞌi nuguanꞌ sa̱ꞌ xiꞌí Jesucristo huin sij daꞌníj Yanꞌanj xa̱ngaꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Asi̱j ná ni̱ garun tsínj gu̱ꞌnaj Isaías ꞌngo̱ nuguanꞌ anj. Ni̱ manꞌan tsínj daj gaꞌmi si-nu̱guanꞌ Yanꞌanj. Ni̱ gataj sij: Aꞌnī ꞌngo̱ tsínj ga̱ꞌmi si-nu̱guanꞌānj. Ni̱ tsínj daj gui̱taj dian sini rián re̱ꞌ ga̱nꞌanj sij. Ni̱ gui̱ꞌyaj xugüi sij si-chréj re̱ꞌ ga̱nꞌanj re̱ꞌ. Daj gataj Yanꞌanj garun Isaías asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ni̱ garun Isaías ango nuguanꞌ nej gataj síꞌ: Unun néꞌ si-na̱ne ꞌngo̱ tsínj aꞌmi nucuaj ꞌngo̱ yuꞌuj quij guiꞌyanj na̱co aj. Ni̱ ataj sij sisi̱ gui̱ꞌyaj xugüi néꞌ si-chrej Señor. Ni̱ na̱guiꞌyaj ni̱ca néꞌ niman néꞌ xiꞌí si ga̱ꞌnaꞌ Señor rian néꞌ. Daj gataj Isaías asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Hué dan ni̱ duguataꞌ nnee tsínj gu̱ꞌnaj Juan ni ngüi̱ riqui quij quiꞌyanj na̱co. Ni̱ gataj sij sisi̱ ga̱nani ruhua ni sij xiꞌí si-ga̱quinꞌ ni sij. Ni̱ ga̱taꞌ nnee ni sij. Ngaa ni̱ ga̱ꞌue gui̱nicaj Yanꞌanj niman nico xiꞌí si-ga̱quinꞌ ni sij. Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ni̱ gahui nico ni ngüi̱ mán estado Judea nga̱ xumanꞌ gu̱ꞌnaj Jerusalén ganꞌanj ni sij rian nne Juan. Ni̱ duguataꞌ nnee Juan ni sij chruhua xinéj nnee gu̱ꞌnaj Jordán. Ni̱ ganataꞌ ni sij si-ga̱quinꞌ ni sij. Ngaa ni̱ gataꞌ nnee ni sij. ");
INSERT INTO trq_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ni̱ si-ganꞌ Juan huin to xucu gu̱ꞌnaj camello. Ni̱ nnij cinchru ꞌni̱j gatin sij. Ni̱ xa sij xiriquíj nga̱ gatsiꞌ mán riqui quij. ");
INSERT INTO trq_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ni̱ nataꞌ sij si-nu̱guanꞌ Yanꞌanj rian ni ngüi̱. Ni̱ gataj sij: ―Rucú manꞌānj ga̱ꞌnaꞌ ꞌngo̱ tsínj nicaj sun doj daj nga̱ manꞌānj. Ni̱ nucuaj ni̱nꞌ ruhua sij daj da na̱ꞌaj riānj gaꞌ ni̱tū nachīj nnij correa dacánj sij. ");
INSERT INTO trq_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ni̱ duguataꞌ nnee manꞌānj a ni é re̱ꞌ nga̱ nnee. Sani̱ ga̱ꞌnaꞌ sij, ni̱ ga̱ꞌnaꞌ Espíritu Santo rian án re̱ꞌ, gui̱ꞌyaj sij. ―Daj gataj Juan gunun ni ngüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ngaa ni̱ ni güi daj, ni̱ gahui Jesús xumanꞌ Nazaret huin xumanꞌ ngaj estado Galilea. Ni̱ duguataꞌ nnee Juan manꞌan Jesús xinéj nnee gu̱ꞌnaj Jordán. ");
INSERT INTO trq_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ni̱ ngaa gahui Jesús chruhua nnee, ni̱ guiniꞌi sij naxiꞌni̱j xataꞌ. Ni̱ guiniꞌi sij sisi̱ ꞌna̱ꞌ guinij Espíritu Santo rian manꞌan sij. Ni̱ da̱j rúnꞌ hua xuꞌma̱n hua Espíritu Santo gaꞌna̱ꞌ rian sij. ");
INSERT INTO trq_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ngaa ni̱ ne̱ꞌ xataꞌ gaꞌmi ꞌngo̱ nane̱ rian Jesús. Ni̱ gataj Yanꞌanj: ―Hué so̱ꞌ huin daꞌnī ꞌi̱ ruhuāj. Ni̱ hua nia̱ꞌ ruhuāj niꞌyā so̱ꞌ. ―Daj gataj Yanꞌanj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ngaa ni̱ ꞌngo̱ hora, ni̱ ganꞌanj Jesús quij quiꞌyanj na̱co, guiꞌyaj Espíritu Santo. ");
INSERT INTO trq_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Daꞌ yuꞌuj daj gane sij hui̱j xia güi. Ni̱ gane sij scanij ni xucu huue mán riqui quij quiꞌyanj daj. Ni̱ gatsij sichre niman Jesús guiꞌyaj-áꞌ fuerza sisi̱ gui̱ꞌyaj Jesús gaquinꞌ. Ni̱ gaꞌna̱ꞌ chracuij ni ángel si gachin rian Jesús. ");
INSERT INTO trq_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ngaa ni̱ ngaa guisíj garij ni sij ducuaga̱ꞌ manꞌan Juan, ni̱ ganꞌanj Jesús estado Galilea. Ni̱ nataꞌ Jesús si-nu̱guanꞌ Yanꞌanj nuguanꞌ sa̱ꞌ xiꞌí si nicaj sun Yanꞌanj rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ni̱ gataj Jesús: ―Hua guisíj gahuin ni̱chrunꞌ güi gui̱nicaj sun Yanꞌanj xungüi̱ nan. Xiꞌí daj ni̱ na̱nicaj ruhua á re̱ꞌ xiꞌí si-ga̱quinꞌ ni é re̱ꞌ. Ni̱ gu̱xuman ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ si-nu̱guanꞌānj huin nuguanꞌ sa̱ꞌ aj. ―Daj gataj Jesús rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ni̱ ngaa huaj Jesús gachéj sij duꞌua laguna xa̱chij gu̱ꞌnaj Galilea, ni̱ guiniꞌi sij ꞌngo̱ tsínj gu̱ꞌnaj Simón nga̱ jnánj síꞌ tsínj gu̱ꞌnaj Andrés. Hué nu̱ngüej sij huin tsínj daꞌa xucuaj. Ni̱ aꞌníj nu̱ngüej sij nnánj chruhua nnee. ");
INSERT INTO trq_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ni̱ gataj Jesús gunun nu̱ngüej sij: ―Gui̱nicoꞌ nu̱ngüej é re̱ꞌ manꞌānj. Ngaa ni̱ gui̱ꞌyā sisi̱ da̱j rúnꞌ daꞌa nu̱ngüej é re̱ꞌ xucuaj, ni̱ daꞌngaꞌ daj gui̱riꞌ nu̱ngüej é re̱ꞌ tsínj gu̱xuman ruhua ni̱ꞌyaj manꞌānj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ngaa ni̱ ꞌngo̱ hora duna nu̱ngüej sij xinánj sij. Ni̱ ganꞌanj nu̱ngüej sij nga̱ Jesús. ");
INSERT INTO trq_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ngaa ni̱ huaj Jesús ne̱ꞌ rian doj, ni̱ guiniꞌi sij tsínj gu̱ꞌnaj Jacobo daꞌníj Zebedeo nga̱ jnánj síꞌ tsínj gu̱ꞌnaj Juan. Ni̱ nne nu̱ngüej sij chruhua ꞌngo̱ rio̱ chéj rian nnee naguiꞌyaj sa̱ꞌ nu̱ngüej sij nnánj daꞌa nu̱ngüej sij xucuaj. ");
INSERT INTO trq_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ni̱ gaquínj Jesús nu̱ngüej sij sisi̱ gui̱nicoꞌ nu̱ngüej sij manꞌan síꞌ. Ni̱ duna nu̱ngüej sij chrej nu̱ngüej sij Zebedeo chruhua rio̱ nga̱ si-moso síꞌ. Asíj ni̱ guinicoꞌ nu̱ngüej sij Jesús. ");
INSERT INTO trq_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Hué dan ni̱ gatúj aninꞌ sij xumanꞌ Capernaum. Ni̱ güi naránj ruhua ni tsínj israelita, ni̱ gatúj Jesús chruhua si-nuhui ni tsínj daj. Ni̱ gaxi̱ꞌi sij digyán sij rian ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ni̱ ngaa gunun ni tsínj daj si gataj Jesús, ni̱ gahuin yanꞌanj ruhua ni sij. Daj si si-nu̱guanꞌ Jesús nicaj sun. Ni̱ sé rúnꞌ digyán Jesús da guiꞌyaj ni maestro digyán si-ley Yanꞌanj rian ni ngüi̱ mánj. ");
INSERT INTO trq_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ni̱ nne ꞌngo̱ tsínj nu̱n nane̱ xi̱ꞌi chruhua niman chruhua nuhui daj. Ni̱ gaguáj nucuaj síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ni̱ gataj síꞌ: ―Ni̱ u̱n sin diguíj re̱ꞌ nga̱ ni únj huín re̱ꞌ Jesús nazareno únj. Ni̱ ꞌna̱ꞌ re̱ꞌ du̱guaꞌ ni̱ꞌyaj re̱ꞌ únj níꞌ. Hua niꞌīnj re̱ꞌ si huín re̱ꞌ tsínj sa̱ꞌ ni̱nꞌ chruhua niman ꞌna̱ꞌ rian Yanꞌanj xa̱ngaꞌ. ―Daj gataj nane̱ xi̱ꞌi nu̱n chruhua niman tsínj daj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ngaa ni̱ gaꞌmi huee Jesús rian nane̱ xi̱ꞌi daj. Ni̱ gataj sij: ―Dínj ga̱ne duꞌuá so̱ꞌ. Ni̱ ga̱hui so̱ꞌ chruhua niman síꞌ. ―Daj gataj Jesús gunun nane̱ xi̱ꞌi daj. ");
INSERT INTO trq_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ngaa ni̱ ducu nagunánj tsínj daj, guiꞌyaj nane̱ xi̱ꞌi. Ni̱ ducu gaguáj nucuaj nane̱ xi̱ꞌi. Ni̱ gahui sij chruhua cúj niman tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ngaa ni̱ ganꞌanj ruhua daranꞌ ni sij. Ni̱ nachínj snanꞌanj ni sij rian dugüiꞌ ni sij, ni̱ gataj ni sij: ―Ni̱ u̱n sin huin nan únj. Ni̱ ꞌngo̱ ducuánj na̱ca huin si digyán sij níꞌ. Nicaj nucuaj tsínj nan sun. Daj si aꞌninꞌ sij sun rian ni nane̱ xi̱ꞌi. Ni̱ unun ni nane̱ xi̱ꞌi si ataj sij. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ni̱ ráꞌyanj gaxaꞌni̱ nuguanꞌ xiꞌí Jesús ni̱nꞌ ga̱chraꞌ estado gu̱ꞌnaj Galilea. ");
INSERT INTO trq_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ni̱ ngaa guisíj gahui ni sij chruhua nuhui, ngaa ni̱ gatúj Jesús ducuá Simón nga̱ Andrés. Ni̱ gatúj Jacobo nga̱ Juan nej. ");
INSERT INTO trq_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ni̱ nni chre̱j Simón táj rian nna. Ni̱ nu̱n gachiꞌ únꞌ. Ni̱ gataj ni sij rian Jesús si aꞌnanꞌ manꞌan únꞌ. ");
INSERT INTO trq_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Asíj ni̱ gahuin ni̱chrunꞌ Jesús rian ngaj únꞌ. Ni̱ guidaꞌa sij raꞌa únꞌ. Ni̱ nachi nicaj sij únꞌ. Ni̱ ꞌngo̱ hora xiꞌnej gachiꞌ únꞌ. Ni̱ gaxi̱ꞌi manꞌan únꞌ guiꞌyaj xugüi únꞌ si xa ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ni̱ ngaa gatúj güi, ni̱ nicaj ni ngüi̱ dugüiꞌ ni sij huin daranꞌ ni ngüi̱ aꞌnanꞌ nga̱ ni ngüi̱ nu̱n nane̱ xi̱ꞌi chruhua cúj niman ni sij. Ni̱ gaꞌna̱ꞌ ni sij rian nne Jesús. ");
INSERT INTO trq_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ni̱ daranꞌ ni ngüi̱ ma̱n xumanꞌ daj ꞌngo̱ nahuin yuꞌ rian hueꞌ rian nne Jesús. ");
INSERT INTO trq_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ni̱ ganahuin nico ni ngüi̱ ranꞌ gaꞌi̱ rian xiꞌi̱, guiꞌyaj Jesús. Ni̱ guiri sij nane̱ xi̱ꞌi niman ni ngüi̱. Ni̱ nun gaꞌuiꞌ sij permiso gaꞌmi ni nane̱ xi̱ꞌi daj si naniꞌi ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Achin gue̱rengaꞌ nachi Jesús hua ru̱miꞌ gue̱. Ni̱ gahui sij ne̱ꞌ xe̱ꞌ xumanꞌ daj ganꞌanj sij quij quiꞌyanj na̱co ga̱chinj jniꞌyaj sij rian Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ni̱ ganꞌanj na̱noꞌ Simón nga̱ ni dugüiꞌ síꞌ manꞌan Jesús. ");
INSERT INTO trq_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ngaa guisíj nariꞌ ni sij, ni̱ gataj ni sij gunun Jesús: ―Daranꞌ ni ngüi̱ nanoꞌ so̱ꞌ aj. ―Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Sani̱ gataj Jesús: ―Gu̱nꞌ ango ni xumanꞌ ngaj ni̱chrunꞌ. Ni̱ ga̱ꞌmī si-nu̱guanꞌānj rian ni ngüi̱ si hué sun da gahui gaꞌnāj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ngaa ni̱ gachéj Jesús ni̱nꞌ ga̱chraꞌ daranꞌ ni xumanꞌ ngaj riqui estado Galilea. Ni̱ nataꞌ sij si-nu̱guanꞌ Yanꞌanj chruhua si-nuhui ni tsínj israelita daꞌ go̱ꞌngo yuꞌuj. Ni̱ guiri sij ni nane̱ xi̱ꞌi niman ni ngüi̱ nej. ");
INSERT INTO trq_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ngaa ni̱ gaꞌna̱ꞌ ꞌngo̱ tsínj ranꞌ ꞌngo̱ xiꞌi̱ nnij sij gu̱ꞌnaj-áꞌ lepra. Ni̱ ganꞌanj ni̱chi sij rian Jesús ganiquinꞌ ráj da̱coj sij. Ni̱ gaꞌmi yaco sij rian Jesús. Ni̱ gataj sij: ―Sisi̱ huin ruhuá re̱ꞌ, ni̱ ga̱ꞌue na̱huin sa̱ꞌāj, gui̱ꞌyáj re̱ꞌ aj. ―Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ngaa ni̱ nani yaco ruhua Jesús niꞌyaj sij tsínj daj. Ni̱ gutaꞌ sij raꞌa sij síꞌ. Ni̱ gataj sij: ―Huin ruhuāj sisi̱ ga̱ sa̱ꞌ nnee̱ cúj re̱ꞌ aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ni̱ ngaa gataj Jesús daj, ni̱ ꞌngo̱ hora xiꞌnej xiꞌi̱ nahuin sa̱ꞌ tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ni̱ naꞌníj Jesús chrej na̱nꞌ síꞌ. Ni̱ gaꞌninꞌ sij sun rian manꞌan síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ni̱ gataj sij: ―Ga̱ cuidado nga̱ manꞌán re̱ꞌ si̱ ganataꞌ re̱ꞌ rian ni̱ a̱ ꞌngo̱ ni ngüi̱ mánj. Maan si ga̱nꞌanj re̱ꞌ di̱gyán re̱ꞌ manꞌán re̱ꞌ rian chrej. Ni̱ na̱gaꞌuiꞌ re̱ꞌ rian Yanꞌanj da̱j rúnꞌ gaꞌninꞌ Moisés sun xiꞌí si nahuín re̱ꞌ, guiꞌyaj Yanꞌanj. Ngaa ni̱ xa̱caj ni chrej cuenta sisi̱ hua nahuin sa̱ꞌ manꞌán re̱ꞌ, guiꞌyaj manꞌānj. ―Daj gataj Jesús gunun tsínj aꞌnanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Sani̱ gahui tsínj nahuin daj. Ni̱ gaxi̱ꞌi sij nataꞌ sij rian daranꞌ ni ngüi̱ si guiꞌyaj Jesús. Xiꞌí daj nun ga̱ꞌue ga̱tu re̱ngaꞌ Jesús chruhua ni xumanꞌ. Maan si gachéj sij quij quiꞌyanj na̱co rian nitaj ni ngüi̱ mánj. Sani̱ daranꞌ yuꞌuj gaꞌna̱ꞌ ni ngüi̱ nanoꞌ ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ni̱ ngaa gachin do̱j güi, ni̱ gatúj ru̱huaꞌ yún Jesús xumanꞌ Capernaum. Ni̱ gunun ni ngüi̱ sisi̱ nne sij ꞌngo̱ hueꞌ daj. ");
INSERT INTO trq_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ni̱ ꞌngo̱ hora nahuin yuꞌ nico ni ngüi̱ rian hueꞌ daj. Ni̱ nun ga̱ꞌue gui̱sij rian guima̱n ni sij. Ni̱ gaꞌmi Jesús nuguanꞌ sa̱ꞌ rian ni ngüi̱ nahuin yuꞌ daj. ");
INSERT INTO trq_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ni̱ nicaj ga̱nꞌanj ranꞌ tsínj daj ꞌngo̱ tsínj nareꞌ nnee̱ cúj gaꞌna̱ꞌ aninꞌ sij. Ni̱ naꞌue gui̱siquiꞌ síꞌ. Ni̱ gaꞌna̱ꞌ manꞌan ni sij rian nne Jesús. ");
INSERT INTO trq_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ni̱ ri̱an naꞌue gu̱nucuaj ni sij gui̱sij ni sij daꞌ rian nne Jesús, ꞌyaj ni ngüi̱, ngaa ni̱ gayaꞌ ni sij ꞌngo̱ yuꞌuj chra̱ hueꞌ xataꞌ rian niquinꞌ Jesús. Ngaa ni̱ na̱naj dinij ni sij huéj nu̱n tsínj aꞌnanꞌ daj rian niquinꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ni̱ ngaa guiniꞌi Jesús sisi̱ da̱j guxuman ruhua ni sij niꞌyaj ni sij síꞌ, ngaa ni̱ gataj síꞌ gunun tsínj aꞌnanꞌ daj: ―Nicā ꞌngo̱ niman nico xiꞌí si-ga̱quinꞌ so̱ꞌ nánj. ―Daj gataj sij gunun síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ni̱ ma̱n do̱j ni tsínj huin maestro digyán si-ley Moisés niꞌyaj ni sij. Ni̱ ani manꞌan ruhua ni sij nga̱ niman ni sij: ");
INSERT INTO trq_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Daj huin ruhua tsínj nan gaꞌmi sij nan únj. Quij ni̱nꞌ ruhua aꞌmi sij rian Yanꞌanj. Urin Yanꞌanj ga̱ꞌue gui̱nicaj ꞌngo̱ niman nico rian si-ga̱quinꞌ ni ngüi̱ aj.” Daj gataj ni sij chruhua niman ni sij. ");
INSERT INTO trq_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Sani̱ guiniꞌi manꞌan Jesús si ani ruhua ni sij. Ngaa ni̱ gataj síꞌ: ―Ni̱ u̱n sin huin ni̱ ani ruhua á re̱ꞌ nuguanꞌ nan únj. ");
INSERT INTO trq_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Hua hui̱j nuguanꞌ sa̱ꞌ ga̱ꞌue ga̱tā gu̱nun tsínj aꞌnanꞌ nan. Ga̱ꞌue ga̱tā gu̱nun sij: “Nicā ꞌngo̱ niman nico rian xiꞌí si-ga̱quinꞌ re̱ꞌ.” Asi̱ ga̱ꞌue ga̱tā gu̱nun sij: “Na̱chica re̱ꞌ na̱ranꞌ re̱ꞌ duhuéj re̱ꞌ, ni̱ ga̱che re̱ꞌ aj.” Daj ga̱ꞌue ga̱taj manꞌānj. ");
INSERT INTO trq_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Hué dan ni̱ huin ruhuāj sisi̱ xa̱caj á re̱ꞌ cuenta sisi̱ nicaj sūnj rian xungüi̱ nan huīnj daꞌníj ni ngüi̱. Ni̱ ga̱ꞌue gui̱nicā ꞌngo̱ niman nico xiꞌí si-ga̱quinꞌ ni ngüi̱. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ngaa ni̱ gataj sij rian tsínj nareꞌ dacój daj: ―Atā rian manꞌán re̱ꞌ sisi̱ na̱chica re̱ꞌ na̱ranꞌ re̱ꞌ duhuéj re̱ꞌ. Ni̱ güi̱j na̱nꞌ re̱ꞌ ducuá re̱ꞌ aj. ―Daj gataj Jesús gunun síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ni̱ ꞌngo̱ hora nachica tsínj aꞌnanꞌ daj. Ni̱ ganaranꞌ sij duhuéj sij. Ni̱ gahui sij ganꞌanj sij niꞌyaj daranꞌ ni ngüi̱ ma̱n chruhua hueꞌ daj. Ngaa ni̱ ganꞌanj ruhua daranꞌ ni sij. Ni̱ gataj ni sij sisi̱ sa̱ꞌ guiꞌyaj manꞌan Yanꞌanj. Ni̱ gataj ni sij: ―Ni̱ a̱ ꞌngo̱ yu̱n nun guiniꞌíꞌ ꞌngo̱ rasu̱n hua nan mánj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Daꞌ síj daj gahui ru̱huaꞌ yún Jesús ganꞌanj sij duꞌua laguna xa̱chij daj. Ni̱ ganꞌanj ni̱chi daranꞌ ni ngüi̱ rian sij. Ni̱ digyán manꞌan sij rian ni ngüi̱ daj. ");
INSERT INTO trq_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ni̱ ngaa huaj sij, ni̱ guiniꞌi sij ꞌngo̱ tsínj gu̱ꞌnaj Leví, daꞌníj tsínj gu̱ꞌnaj Alfeo. Ni̱ nne síꞌ rian mesa aꞌnej síꞌ pesto güenda gobierno. Ni̱ gataj Jesús gunun sij: ―Gui̱nicoꞌ so̱ꞌ gu̱nꞌ. ―Daj gataj Jesús. Ngaa ni̱ naxu̱man Leví, ni̱ guinicoꞌ síꞌ Jesús ganꞌanj síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ni̱ ngaa gane Jesús rian mesa chruhua ducuá tsínj gu̱ꞌnaj Leví, ni̱ guxuman gaꞌi̱ ni tsínj aꞌnej pesto, ꞌyaj gobierno nga̱ ni tsínj ꞌyaj gaquinꞌ nej. Ni̱ gane nu̱guanꞌan ni sij nga̱ Jesús nga̱ ni tsínj nicoꞌ Jesús nej. Daj si ma̱n nico ni sij nicoꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ni̱ ngaa guiniꞌi ni tsínj digyán ley nga̱ ni tsínj fariseo sisi̱ xa Jesús nga̱ ni tsínj aꞌnej pesto nga̱ ni tsínj ꞌyaj gaquinꞌ, ngaa ni̱ gataj ni sij gunun ni tsínj nicoꞌ Jesús: ―Ni̱ u̱n sin huin ni̱ xa si-maestro ni é re̱ꞌ, ni̱ goꞌo sij nga̱ ni tsínj aꞌnej pesto nej, ni tsínj ꞌyaj gaquinꞌ nej. ―Daj gataj ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ni̱ ngaa gunun Jesús si gataj ni síꞌ, ni̱ gataj sij: ―Nitaj si níꞌyanj ni ngüi̱ hua sa̱ꞌ nga̱ ꞌngo̱ tsínj ꞌyaj go̱noꞌo mánj. Sani̱ ni ngüi̱ aꞌnanꞌ níꞌyanj ꞌngo̱ tsínj go̱noꞌo aj. Sé si ꞌnāj ga̱quīn ni ngüi̱ hua sa̱ꞌ mánj. Sani̱ ꞌnāj ga̱quīn ni ngüi̱ ꞌyaj gaquinꞌ sisi̱ ga̱nani ruhua ni sij xiꞌí si-ga̱quinꞌ ni sij. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ni̱ ni tsínj nicoꞌ Juan nga̱ ni tsínj nicoꞌ ni tsínj fariseo, ni̱ guiꞌyaj ni sij ayuno. Ngaa ni̱ gaꞌna̱ꞌ go̱ꞌngo ni tsínj rian Jesús. Ni̱ nachínj snanꞌanj ni sij Jesús. Ni gataj ni sij: ―Ni̱ u̱n sin huin ni̱ ꞌyaj ayuno ni tsínj nicoꞌ Juan nga̱ ni tsínj nicoꞌ ni fariseo, sani̱ xa gue̱ ni tsínj nicoꞌ manꞌán re̱ꞌ únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ngaa ni̱ gataj Jesús gunun ni sij: ―Da̱j rúnꞌ ꞌyaj ꞌngo̱ tsínj xa̱caj yunꞌunj xa̱na daꞌngaꞌ daj ꞌyā. Ni̱ ngaa ga̱huin guiꞌyanj xa̱caj ꞌngo̱ tsínj daj yunꞌunj xa̱na, ni̱ si̱ gaꞌue gui̱ꞌyaj tsínj ga̱nꞌanj guiꞌyanj daj ayuno mánj. ");
INSERT INTO trq_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Sani̱ hua güi, ni̱ gui̱daꞌa ni tsínj quij tsínj xa̱caj yunꞌunj xa̱na daj. Ngaa ni̱ gui̱ꞌyaj ni tsínj nicoꞌ manꞌānj ayuno. ");
INSERT INTO trq_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Si̱ gaꞌue na̱nuoꞌ néꞌ ꞌngo̱ atsij na̱ca nga̱ ꞌngo̱ atsij re̱ꞌe mánj. Daj si hué gue̱ atsij na̱ca naráj néꞌ daj gui̱ꞌyaj sisi̱ tsitsiꞌ atsij re̱ꞌe daj. Ni̱ ga̱nahuin xa̱chij rian naráj néꞌ. ");
INSERT INTO trq_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ni̱ si̱ gaꞌue ga̱ꞌnij néꞌ nnee vino na̱ca chruhua nnij re̱ꞌe. Daj si tsitsiꞌ nnij daj, gui̱ꞌyaj vino na̱ca daj. Hué dan ni̱ ꞌngo̱ gue̱reꞌ vino nga̱ nnij nej. Xiꞌí daj huin ni̱ gaꞌnij néꞌ vino na̱ca chruhua nnij na̱ca aj. Ni̱ da̱j rúnꞌ huin vino na̱ca daj huin si-nu̱guanꞌānj. ―Daj gataj Jesús rian ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ni̱ ꞌngo̱ güi naránj ruhua ni sij, ni̱ huaj Jesús da̱ni nnaa̱ strigo. Ni̱ rocoj ni tsínj nicoꞌ sij ca strigo huaj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ngaa ni̱ gataj ni tsínj fariseo gunun Jesús: ―Ni̱ꞌyaj re̱ꞌ si ꞌyaj ni tsínj nicóꞌ re̱ꞌ. Daj si naꞌuej si-ley Yanꞌanj si daꞌngaꞌ daj gui̱ꞌyaj ni sij mánj. ―Daj gataj ni tsínj fariseo. ");
INSERT INTO trq_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Sani̱ gataj Jesús: ―Hua gaya ni é re̱ꞌ si guiꞌyaj xíꞌ David níꞌ. Daj si ꞌngo̱ güi ngaa gachin xiꞌna̱ riqui ni du̱güiꞌ sij, ");
INSERT INTO trq_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ni̱ gatúj sij chruhua ducuá Yanꞌanj ngaa gane ꞌngo̱ tsínj gu̱ꞌnaj Abiatar. Ni̱ hué síꞌ huin ꞌngo̱ chrej aꞌninꞌ. Ni̱ xa sij si-chra̱chrunj Yanꞌanj. Ni̱ urin chrej ga̱ꞌue xa chrachrúnj daj. Ni̱ gaꞌuiꞌ sij xa ni tsínj ma̱n nga̱ sij nej. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ni̱ gataj ru̱huaꞌ yún Jesús rian ni tsínj fariseo: ―Guiꞌyaj Yanꞌanj güi naránj ruhua néꞌ güenda néꞌ. Ni̱ sé si guiꞌyaj Yanꞌanj néꞌ güenda güi naránj ruhua néꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ni̱ nicaj sūnj rian ni güi naránj ruhua néꞌ huīnj daꞌníj ni ngüi̱. ―Hué daj gataj Jesús gunun ni tsínj fariseo. ");
INSERT INTO trq_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ngaa ni̱ gatúj ru̱huaꞌ yún Jesús chruhua si-nuhui ni tsínj israelita. Ni̱ chruhua nuhui daj nne ꞌngo̱ tsínj hua na̱co raꞌa. ");
INSERT INTO trq_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ni̱ nagaꞌna̱j ni sij Jesús niꞌyaj ni sij sisi̱ ga̱nahuin raꞌa tsínj daj güi naránj róꞌ, gui̱ꞌyaj Jesús. Daj si huin ruhua ni sij ga̱ꞌmi gaquinꞌ ni sij xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Hué dan ni̱ gataj Jesús rian tsínj hua raꞌa na̱co daj: ―Na̱xuman re̱ꞌ gui̱niquinꞌ re̱ꞌ da̱ni ni únj anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ngaa ni̱ nachínj snanꞌanj Jesús ni tsínj nagaꞌna̱j daj. Ni̱ gataj sij: ―Aꞌuej si-ley Yanꞌanj sisi̱ gui̱ꞌyaj sa̱ꞌ néꞌ güi naránj róꞌ níꞌ. Asi̱ sa̱ꞌ gui̱ꞌyaj quij néꞌ, ruhua á re̱ꞌ sa̱ꞌ. Ni̱ ga̱ꞌuej si-ley Yanꞌanj sisi̱ na̱coꞌ ꞌngo̱ tsínj ruhua ga̱huiꞌ níꞌ. Asi̱ sa̱ꞌ ga̱huiꞌ sij, ruhua á re̱ꞌ sa̱ꞌ. ―Daj gataj Jesús. Sani̱ dínj gane duꞌua ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Hué dan ni̱ gaꞌman ruhua Jesús. Ni̱ niꞌyaj sij ni tsínj daj. Ni̱ nani ruhua sij xiꞌí si tsi̱ niman ni síꞌ. Ngaa ni̱ gataj sij rian tsínj na̱co raꞌa daj: ―Du̱cuá re̱ꞌ raꞌá re̱ꞌ. ―Daj gataj Jesús. Ngaa ni̱ ducua síꞌ raꞌa síꞌ. Ni̱ nahuin sa̱ꞌ raꞌa síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ngaa ni̱ gahui ni tsínj fariseo. Ni̱ gaxi̱ꞌi ni sij dagaꞌmi dugüiꞌ ni sij nga̱ ni tsínj herodista. Ni̱ gaꞌmi ni sij xiꞌí Jesús si ruhua ni sij da̱gahuiꞌ ni sij manꞌan síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sani̱ gahui Jesús nga̱ ni tsínj nicoꞌ sij yuꞌuj daj. Ni̱ ganꞌanj sij duꞌua laguna xa̱chij. Ni̱ guinicoꞌ ni̱nꞌ ruhua ni ngüi̱ mán estado Galilea ");
INSERT INTO trq_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","nga̱ ni ngüi̱ ma̱n estado Judea nej, ni ngüi̱ ma̱n xumanꞌ Jerusalén nej, ni ngüi̱ ma̱n estado Idumea nej, ni ngüi̱ ꞌna̱ꞌ anéj chrej xinéj nnee gu̱ꞌnaj Jordán nej, ni ngüi̱ ma̱n xumanꞌ Tiro nej, nga̱ ni ngüi̱ ma̱n xumanꞌ Sidón nej. Ni̱ guinicoꞌ daranꞌ ni sij Jesús xiꞌí si gunun ni sij ni si sa̱ꞌ guiꞌyaj síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ngaa ni̱ garasu̱n Jesús ni tsínj nicoꞌ sij sisi̱ ga̱ chru̱n ni síꞌ nga̱ ꞌngo̱ rio̱ achéj rian nnee. Ngaa ni̱ si̱ guruꞌman nico ni ngüi̱ rian manꞌan sij. ");
INSERT INTO trq_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Daj si gaꞌi̱ nico ni ngüi̱ nahuin, guiꞌyaj manꞌan Jesús. Ni̱ guruꞌman dugüiꞌ ni ngüi̱ aꞌnanꞌ ganꞌanj ni sij rian síꞌ sisi̱ ga̱ꞌue ga̱nun raꞌa ni sij manꞌan síꞌ, ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ni̱ ma̱n ni tsínj nu̱n nane̱ xi̱ꞌi ruhua cúj niman ni sij. Ni̱ ngaa guiniꞌi ni sij Jesús, ni̱ guiniquinꞌ ráj da̱coj ni sij ne̱ꞌ rian manꞌan síꞌ. Ni̱ gaxi̱ꞌi ni sij gaguáj ni sij. Ni̱ gataj ni sij gunun Jesús: ―Hué re̱ꞌ huin yya daꞌníj Yanꞌanj anj. ―Daj gataj ni nane̱ xi̱ꞌi daj. ");
INSERT INTO trq_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Sani̱ gaꞌninꞌ nico Jesús sun rian ni nane̱ xi̱ꞌi daj sisi̱ si̱ nataꞌ ni sij u̱n tsínj huin síꞌ rian ni ngüi̱ mánj. ");
INSERT INTO trq_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ne̱ꞌ ru̱cu da gahui Jesús ganꞌanj sij chra̱ ꞌngo̱ quij. Ni̱ gaquínj sij ni tsínj huin ruhua sij ga̱ꞌnaꞌ rian sij. Ni̱ gaꞌna̱ꞌ ni síꞌ rian manꞌan sij. ");
INSERT INTO trq_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ni̱ guta sun Jesús xu̱huij ni tsínj guima̱n ni síꞌ nga̱ manꞌan sij. Ni̱ garasu̱n sij ni síꞌ sisi̱ ga̱nꞌanj ni síꞌ na̱taꞌ ni síꞌ si-nu̱guanꞌ sij rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ni̱ gaꞌuiꞌ Jesús sun rian ni tsínj daj sisi̱ ga̱nahuin ni ngüi̱ aꞌnanꞌ, gui̱ꞌyaj ni sij. Ni̱ gaꞌuiꞌ sij sun sisi̱ gui̱ri ni síꞌ ni nane̱ xi̱ꞌi chruhua niman ni ngüi̱ nej. ");
INSERT INTO trq_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ni̱ guta sun Jesús tsínj gu̱ꞌnaj Simón. Ni̱ duguꞌna̱j Jesús si-xugüi síꞌ gu̱ꞌnaj síꞌ Pedro. ");
INSERT INTO trq_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ni̱ guta sun Jesús Jacobo daꞌníj Zebedeo nga̱ jnánj Jacobo tsínj gu̱ꞌnaj Juan. Ni̱ duguꞌna̱j Jesús nu̱ngüej jna̱nj sij Boanerges. Ni̱ nuguanꞌ daj huin ruhuaj gata ni daꞌníj duꞌui. ");
INSERT INTO trq_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ni̱ guta sun Jesús ango tsínj gu̱ꞌnaj Andrés nga̱ Felipe nej, Bartolomé nej, Mateo nej, Tomás nej, Jacobo daꞌníj tsínj gu̱ꞌnaj Alfeo nej, Tadeo nej, Simón nicoꞌ xiꞌninꞌ gu̱ꞌnaj Cananita nej, ");
INSERT INTO trq_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote nej, huin síꞌ tsínj digyán chrej rian ni tsínj ga̱ꞌnaꞌ gui̱daꞌa Jesús. Ngaa ni̱ gatúj Jesús chruhua hueꞌ nga̱ ni tsínj nicoꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ngaa ni̱ ducu nahuin yuꞌ ru̱huaꞌ yún ni ngüi̱ rian Jesús. Xiꞌí daj ni̱ nun ga̱ꞌue xa̱ Jesús nga̱ ni tsínj nicoꞌ sij, guiꞌyaj ni ngüi̱ daj. ");
INSERT INTO trq_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ni̱ ngaa gunun ni dugüiꞌ Jesús nuguanꞌ daj, ni̱ gaꞌna̱ꞌ ni sij sisi̱ gui̱daꞌa ni sij síꞌ. Daj si gataj ni sij sisi̱ sinúnj manꞌan síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ni̱ gataj ni tsínj digyán ley huin ni tsínj ꞌna̱ꞌ xumanꞌ Jerusalén: ―Sichre huin achij rian ni sichre gu̱ꞌnaj Beelzebú nu̱n niman Jesús. Ni̱ xiꞌí si-fuerza manꞌan sichre daj, ni̱ gahuin nucuaj sij ri sij ni nane̱ xi̱ꞌi chruhua niman ni ngüi̱. ―Daj gataj ni tsínj digyán ley da aj. ");
INSERT INTO trq_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ngaa ni̱ gaquínj Jesús ga̱ꞌnaꞌ ni tsínj daj rian sij. Ni̱ nani sij ꞌngo̱ cuento rian ni síꞌ. Ni̱ gataj sij: ―Asa̱ꞌ ga̱ꞌue gui̱ri sichre Satanás ango sichre chruhua niman ni ngüi̱, ruhua ni é re̱ꞌ únj. Si̱ gaꞌue mánj. ");
INSERT INTO trq_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Sisi̱ ga̱huin hui̱j xiꞌninꞌ ni tsínj nicaj sun, ni̱ ununꞌ nu̱ngüej xiꞌninꞌ huin ducuasun daj, ngaa ni̱ si̱ gunucuaj ni sij ga̱ne ni sij mánj. ");
INSERT INTO trq_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ni̱ sisi̱ nne hui̱j xiꞌninꞌ ducuá ꞌngo̱ tsínj daj, ni̱ ununꞌ hui̱j xiꞌninꞌ daj, ngaa ni̱ si̱ gunucuaj ducuá sij ga̱ne sij mánj. ");
INSERT INTO trq_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ni̱ sisi̱ na̱xuman manꞌan sichre Satanás gu̱nunꞌ sij nga̱ ni dugüiꞌ manꞌan sij, ngaa ni̱ si̱ gaꞌue gu̱nucuaj sij ga̱ne sij mánj. Ni̱ ꞌngo̱ ga̱nahuij ni sichre daj. ");
INSERT INTO trq_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ni̱ a̱ ꞌngo̱ ni tsínj si̱ gaꞌue ga̱tu chruhua ducuá ꞌngo̱ tsínj nucuaj güenda gui̱ꞌyaj tu̱ sij siꞌyaj síꞌ mánj. Sani̱ hua sini nu̱mi tsínj siꞌyaj daj, gui̱ꞌyaj tsínj tu̱ daj, daꞌ ngaa ni̱ ga̱ꞌue gui̱ꞌyaj tu̱ sij siꞌyaj síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Xa̱ngaꞌ yya ni̱nꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ ga̱ꞌue gui̱nicaj Yanꞌanj niman nico xiꞌí daranꞌ gaquinꞌ guiꞌyaj ni ngüi̱ nga̱ daranꞌ nuguanꞌ quij gaꞌmi ni sij nej. ");
INSERT INTO trq_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Sani̱ daranꞌ ni ngüi̱ ga̱ꞌmi quij rian xiꞌí Espíritu Santo, ni̱ si̱ gaꞌue gui̱nicaj Yanꞌanj niman nico xiꞌí ni ngüi̱ da ga̱ mánj. Ni̱ ꞌngo̱ ni̱ganj ni̱nꞌ daꞌui ni sij gaquinꞌ nánj. ");
INSERT INTO trq_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","―Daj gataj Jesús xiꞌí si gataj ni maestro daj sisi̱ nu̱n sichre xi̱ꞌi chruhua cúj niman manꞌan sij. ");
INSERT INTO trq_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ngaa ni̱ guisíj nni Jesús nga̱ ni jnánj sij rian sij. Sani̱ gunáj ni sij ne̱ꞌ chrej xe̱ꞌ hueꞌ nne Jesús. Ni̱ gaꞌníj ni sij ꞌngo̱ nuguanꞌ rian Jesús sisi̱ ga̱hui síꞌ ga̱ꞌnaꞌ síꞌ yuꞌuj niquinꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ngaa ni̱ gataj ni ngüi̱ nne ganica̱j xiꞌníj Jesús: ―Nní re̱ꞌ nga̱ ni jnánj re̱ꞌ anaꞌuij niquinꞌ ne̱ꞌ chrej xe̱ꞌ nanoꞌ ni sij manꞌán re̱ꞌ. ―Daj gataj ni ngüi̱ daj. ");
INSERT INTO trq_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Sani̱ gataj manꞌan Jesús: ―Ni̱ u̱n ngüi̱ xa̱na huin nnī rian manꞌānj, ruhua ni é re̱ꞌ únj. Ni̱ u̱n tsínj huin jnān rian manꞌānj, ruhua á re̱ꞌ únj. ―Daj gataj síꞌ rian ni ngüi̱ daj. ");
INSERT INTO trq_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Hué dan ni̱ niꞌyaj Jesús ni ngüi̱ nne ganica̱j xiꞌníj sij. Ni̱ gataj sij: ―Hué nnī nga̱ ni jnān huin ni tsínj ma̱n nan. ");
INSERT INTO trq_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Daj si u̱n ngüi̱ da̱gahuin si aranꞌ ruhua Yanꞌanj, ni̱ hué ni sij huin jnān nej, xicaꞌuī nej, nga̱ nnī nej aj. ―Daj gataj Jesús gunun ni ngüi̱ daj. ");
INSERT INTO trq_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ngaa ni̱ gaxi̱ꞌi ru̱huaꞌ yún Jesús digyán sij si-nu̱guanꞌ sij rian ni ngüi̱ mán duꞌua laguna xa̱chij daj. Ni̱ nahuin yuꞌ nico ni ngüi̱ rian niquinꞌ manꞌan Jesús. Ngaa ni̱ gatúj sij chruhua ꞌngo̱ rio̱ chéj rian nnee. Ni̱ ganꞌanj ga̱ne sij chruhua rio̱ daj. Ni̱ niquinꞌ daranꞌ ni ngüi̱ niꞌyaj ni sij duꞌua laguna daj. ");
INSERT INTO trq_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ni̱ nani Jesús gaꞌi̱ cuento digyán sij rian ni ngüi̱. Ni̱ gataj sij: ");
INSERT INTO trq_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Gu̱nun sa̱ꞌ ni é re̱ꞌ nan anj: Gahui ꞌngo̱ tsínj ganꞌanj da̱gamanꞌ ca̱n anj. ");
INSERT INTO trq_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ni̱ ngaa dagamanꞌ sij, ni̱ guinij do̱j ca̱n daj chruhua chrej. Ni̱ gaꞌna̱ꞌ gue̱ xataj xa xuj ca̱n daj. ");
INSERT INTO trq_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ni̱ guinij do̱j ca̱n rian yoꞌój yej rian nitaj nico yoꞌój nu̱n. Ni̱ xiraꞌ yoo̱ ca̱n daj. Daj si nitaj si yoꞌój hua nico rian yej daj. ");
INSERT INTO trq_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Sani̱ ngaa gahui güi gurununj, ni̱ gaca coj daj, guiꞌyaj nnán. Daj si nitaj yaꞌa̱ siu̱ mánj. Ni̱ ganaco̱ ráꞌyanj coj daj. ");
INSERT INTO trq_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ni̱ gayu do̱j ca̱n scanij tanj. Ni̱ gachij tanj daj. Hué dan ni̱ gane̱ coj daj, guiꞌyaj tanj. Xiꞌí daj ni̱ nun ga̱ꞌue gayu ca̱n. ");
INSERT INTO trq_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ni̱ gayu do̱j ca̱n ango yoꞌój sa̱ꞌ. Ni̱ gayu sa̱ꞌ ca̱n. Ni̱ gachij manꞌan nnaa̱ daj. Ni̱ gayu sa̱ꞌ nnaa̱. Ni̱ ꞌngo̱ coj gahui co̱ chiꞌ ca̱n. Ni̱ ango coj gahui hua̱ꞌnij xia ca̱n daj. Ni̱ ángoj gahui ꞌngo̱ ciento ca̱n daj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús: ―Sisi̱ nu̱n chraquij a ni é re̱ꞌ, ni̱ gu̱nun a ni é re̱ꞌ nej aj. ―Daj gataj Jesús guisíj nani sij cuento. ");
INSERT INTO trq_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ni̱ ngaa gunáj urin Jesús nga̱ ni tsínj chéj nga̱ sij nga̱ ni xu̱huij ni tsínj nicoꞌ sij, ni̱ nachínj snanꞌanj ni síꞌ Jesús u̱n sin huin ruhua cuento daj gata gunun ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ngaa ni̱ gataj Jesús: ―Rian án re̱ꞌ riqui Yanꞌanj sisi̱ gui̱niꞌi ni é re̱ꞌ da̱j hua nuguanꞌ hui̱ rian nicaj sun Yanꞌanj. Sani̱ rian ni tsínj nitaj si chéj ngāj, ni̱ maan ni̱nanj cuento nanīj rian ni sij. ");
INSERT INTO trq_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Hué dan ni̱ gui̱niꞌyaj ni sij, sani̱ si̱ guiniꞌi ni sij mánj. Ni̱ gu̱nun chraquij ni sij, sani̱ si̱ gara daꞌngaꞌ ruhua sij mánj. Ni̱ hué dan ni̱ si̱ nanicaj ruhua ni sij. Ni̱ naꞌuej ruhua ni sij sisi̱ gui̱nicaj Yanꞌanj niman nico rian si-ga̱quinꞌ ni sij. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ni̱ gataj ru̱huaꞌ yún Jesús: ―Nun gunun a ni é re̱ꞌ cuento digyānj rian án re̱ꞌ nan míꞌ. Ni̱ asa̱ꞌ ga̱ꞌue gu̱nun a ni é re̱ꞌ ango ni cuento na̱nīj rian án re̱ꞌ, ruhua á re̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","’Tsínj dagamanꞌ ca̱n daj huin tsínj nataꞌ si-nu̱guanꞌ Yanꞌanj rian ni ngüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ni̱ ca̱n guinij chruhua chrej rúnꞌ huin go̱ꞌngo tsínj: gunun ni sij nuguanꞌ daj. Sani̱ gunun ni sij, ni̱ ꞌngo̱ hora ga̱ꞌnaꞌ sichre Satanás ga̱ꞌnej-éꞌ nuguanꞌ sa̱ꞌ gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","’Ni̱ ca̱n guinij rian yoꞌój yej, ni̱ rúnꞌ huin ango ni tsínj: gunun ni sij si-nu̱guanꞌ Yanꞌanj. Ni̱ ꞌngo̱ hora nahuin raꞌa ni sij nuguanꞌ daj. Ni̱ huin nia̱ꞌ ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Sani̱ ꞌyaj ni sij rúnꞌ ꞌyaj ꞌngo̱ coj nitaj nico yaꞌa̱ siu̱. Hué dan ni̱ ngaa ga̱ꞌnaꞌ ꞌngo̱ sayun chranꞌ yunꞌunj ango ni tsínj xiꞌí si-nu̱guanꞌ Yanꞌanj, ngaa ni̱ jna ni sij si-chrej Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","’Ni̱ ca̱n guinij scanij tanj daj rúnꞌ huin ango ni tsínj: gunun ni sij nuguanꞌ sa̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Sani̱ huin ruhua ni sij gui̱riꞌ ni sij ni rasu̱n ma̱n chruhua xungüi̱ nan anj. Ni̱ digyaꞌ yunꞌunj sanꞌanj ni sij si nahuij ruhua ni sij ga̱huin xuruꞌue ni sij. Ni̱ nanoꞌ ni sij ango ni rasu̱n nej. Xiꞌí daj ni̱ gue̱reꞌ nuguanꞌ sa̱ꞌ ma̱n chruhua niman ni sij. Ni̱ nitaj si ꞌyaj sa̱ꞌ ni sij ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","’Ni̱ ca̱n guinij rian yoꞌój sa̱ꞌ, ni̱ rúnꞌ huin ango ni tsínj gunun si-nu̱guanꞌ Yanꞌanj. Nacaj ni sij nuguanꞌ daj. Ni̱ dugumi sa̱ꞌ ni sij. Ni̱ ꞌyaj ꞌngo̱ sij rúnꞌ ꞌyaj ꞌngo̱ coj gayu co̱ chiꞌ ca̱n. Ni̱ ꞌyaj ango sij rúnꞌ ꞌyaj ango coj gayu hua̱ꞌnij xia ca̱n. Ni̱ ꞌyaj ango sij rúnꞌ ꞌyaj ango coj gayu ꞌngo̱ ciento ca̱n daj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús gunun ni sij: ―Ngaa ru̱miꞌ, ni̱ ga̱ri hui̱ꞌ candil ne̱ꞌ riqui chrúnj nga̱ riqui nna, ruhua ni é re̱ꞌ níꞌ. Sé daj huin mánj. Sisi̱ ru̱miꞌ, ni̱ gu̱toꞌ candil daj xataꞌ rian mesa. Ni̱ gui̱xiguin-ínꞌ. ");
INSERT INTO trq_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ngaa ni̱ go̱ꞌngo rasu̱n naránj ni ngüi̱ acuanꞌ, sani̱ daranꞌanj na̱rugüiꞌ. Ni̱ go̱ꞌngo nuguanꞌ guixíj hui̱ ni ngüi̱ acuanꞌ, sani̱ gui̱niꞌi daranꞌ ni ngüi̱ si guixíj hui̱ daj. ");
INSERT INTO trq_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Sisi̱ ta̱j chraquij a ni é re̱ꞌ, ni̱ gu̱nun a ni é re̱ꞌ nánj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús: ―Ni̱ꞌyaj á re̱ꞌ nuguanꞌ unun a ni é re̱ꞌ nan. Sisi̱ unun sa̱ꞌ á re̱ꞌ, ngaa ni̱ ga̱ gue̱ ri̱qui Yanꞌanj nuguanꞌ sa̱ꞌ rian án re̱ꞌ. Ni̱ ri̱qui Yanꞌanj doj rian án re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Daj si ga̱ꞌuiꞌ Yanꞌanj rian tsínj unun. Sani̱ ga̱ꞌne Yanꞌanj da gue̱ do̱j nicaj ni tsínj naꞌuej ruhua gu̱nun sa̱ꞌ aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús: ―Rúnꞌ huin ꞌngo̱ tsínj dagamanꞌ ca̱n rian yoꞌój daꞌngaꞌ daj huin rian nicaj sun Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ni̱ si nanun ruhua sij nej, si atoj sij nej, sani̱ xi̱raꞌ ca̱n, ni̱ achij nnaa̱ le daj ne̱ꞌ chrej ni̱ nej, si ne̱ꞌ chrej guníꞌyanj nej. Sani̱ nun niꞌi sij da̱j achi mánj. ");
INSERT INTO trq_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Achij manꞌan nnaa̱ rian yoꞌój. Hua sini xiraꞌ nnaa̱. Ni̱ ne̱ꞌ ru̱cu ga̱hui ca. Ngaa guisíj ni̱ xi̱raꞌ ca̱n chra̱ ca. ");
INSERT INTO trq_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ngaa guisíj gane ca̱n, ni̱ ga̱hui néꞌ ga̱nꞌanj na̱ranꞌ néꞌ. Daj si guisíj güi na̱ranꞌ néꞌ aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús: ―Da̱j huin rian nicaj sun Yanꞌanj, ruhua á re̱ꞌ únj. Da̱j hua cuento huin rúnꞌ huin rian nicaj sun Yanꞌanj únj. ");
INSERT INTO trq_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Rúnꞌ huin ꞌngo̱ ca̱n cuej staj unun néꞌ rian yoꞌój daꞌngaꞌ daj huin rian nicaj sun Yanꞌanj nej aj. Huéj huin ca̱n leꞌej doj rian daranꞌ ango ca̱n mán chruhua xungüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Sani̱ uyu̱n gu̱nun néꞌ, ni̱ ga̱chij coj daj. Asíj ni̱ ga̱huin xa̱canj daj nga̱ daranꞌ ni coj ma̱n anj. Ni̱ hua ga̱raꞌ raꞌa coj daj, ni̱ da nga̱ ni xataj chéj xataꞌ ga̱ꞌue na̱ran ruhua riqui si-ga̱xunꞌ raꞌa coj da aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ni̱ nga̱ ni cuento digyán Jesús si-nu̱guanꞌ sij rian ni ngüi̱. Ni̱ nani sij cuento da̱j da ga̱ꞌue gu̱nun ni ngüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ni̱ maan ni̱nanj cuento nani Jesús rian ni ngüi̱ aj. Sani̱ ngaa gane urin ni tsínj nicoꞌ sij, hué dan ni̱ digyán ni̱ca yya ni̱nꞌ sij rian ni síꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ni̱ ngaa ruhua guini̱ güi daj, ni̱ gataj Jesús rian ni tsínj nicoꞌ sij: ―Ga̱nꞌanj néꞌ anéj chrej duꞌua laguna. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ni̱ jna ni tsínj nicoꞌ Jesús ni ngüi̱ duꞌua laguna daj. Ni̱ nicaj ni sij Jesús ganꞌanj ni sij chruhua rio̱ hua nu̱n Jesús. Ni̱ hua nicaj dugüiꞌ ango ni rio̱ nga̱ ni sij ganꞌanj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ni̱ hora daj gahui ꞌngo̱ nane̱ nucuaj xxi. Ni̱ ducu naxu̱man nnee, guiꞌyaj nane̱ daj. Ni̱ gara nnee chruhua rio̱, guiꞌyaj nane̱ daj. Ni̱ ruhua gui̱nij rio̱ chruhua nnee, guiꞌyaj nane̱. ");
INSERT INTO trq_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Sani̱ ngaj Jesús atoj sij ne̱ꞌ ru̱cu rio̱ daj. Ni̱ chra̱ sij riguiyaꞌ, atoj sij aj. Ni̱ jnanun ruhua ni síꞌ Jesús. Ni̱ gataj ni síꞌ: ―Maestro, nitaj si huin ruhuá re̱ꞌ sisi̱ gui̱nij néꞌ chruhua laguna míꞌ. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ni̱ ganachica Jesús. Ni̱ gaꞌmi huee sij rian nane̱. Ni̱ gataj sij rian laguna daj: ―Dínj na̱gaꞌ re̱ꞌ aj. ―Daj gataj Jesús, ni̱ gahuin dinꞌinj ruhua daranꞌanj. ");
INSERT INTO trq_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Hué dan ni̱ gataj Jesús rian ni tsínj nicoꞌ sij: ―Ni̱ u̱n sin huin ni̱ xuꞌuiꞌ aninꞌ é re̱ꞌ únj. Hua nitaj si xuman ruhua aninꞌ é re̱ꞌ niꞌi aninꞌ é re̱ꞌ yūnj ga̱ míꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ngaa ni̱ ducu guxuꞌuiꞌ ni sij. Ngaa ni̱ gataj ni sij rian ni dugüiꞌ ni sij: ―Ni̱ u̱n tsínj huin tsínj nan, ni̱ daꞌ nane̱ nga̱ nnee dagahuin si-nu̱guanꞌ sij únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ni̱ guisíj ni sij anéj chrej duꞌua laguna rian gu̱ꞌnaj Gerasa. ");
INSERT INTO trq_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ni̱ ngaa gahui Jesús chruhua rio̱, ni̱ ganꞌanj ni̱chi ꞌngo̱ tsínj daj rian niquinꞌ Jesús ꞌna̱ꞌ síꞌ ꞌngo̱ yuꞌuj achinꞌ níman. Ni̱ nu̱n nane̱ xi̱ꞌi chruhua cúj niman síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ni̱ tsínj daj guꞌyun sij nne sij chruhua yuꞌuj rian achinꞌ níman. Ni̱ ni̱ a̱ ꞌngo̱ tsínj nun ga̱ꞌue gu̱mi ran agaꞌ nneꞌ tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ni̱ nu̱nj si gaꞌi̱ numij ni sij agaꞌ nu̱ngüej dacój sij nga̱ agaꞌ nneꞌ nu̱ngüej raꞌa sij, sani̱ dayu̱n xiꞌninꞌ agaꞌ nneꞌ, guiꞌyaj sij. Ni̱ gaꞌne sij agaꞌ anumi nu̱ngüej dacój sij. Ni̱ nun ga̱ꞌue gui̱daꞌa sa̱ꞌ ni síꞌ manꞌan sij ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ni̱ nugüi ni̱ganꞌ achéj tsínj daj aguáj sij riqui quij, ni̱ chruhua ni huej rian achinꞌ níman. Ni̱ guiranꞌ xi̱ꞌi manꞌan sij nga̱ yej, guiꞌyaj sij nej aj. ");
INSERT INTO trq_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ni̱ ngaa guiniꞌi ga̱nꞌ sij Jesús, ni̱ gunánj sij ganꞌanj ga̱ne ráj da̱coj sij rian manꞌan Jesús. ");
INSERT INTO trq_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ni̱ gaguáj sij rian Jesús. Ni̱ gataj sij: ―Nitaj si huaj si di̱guíj re̱ꞌ ngāj huín re̱ꞌ Jesús daꞌníj Yanꞌanj xa̱ngaꞌ saj. Aꞌmi acōj rián re̱ꞌ nga̱ si-xugüi Yanꞌanj sisi̱ si̱ gahuīnj castigo, gui̱ꞌyáj re̱ꞌ mánj. ―Daj gataj tsínj nun nane̱ xi̱ꞌi niman sij. ");
INSERT INTO trq_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Daꞌngaꞌ daj gaꞌmi nane̱ xi̱ꞌi daj xiꞌí si hua gataj Jesús gunun sij: “Gu̱xun re̱ꞌ manꞌán re̱ꞌ chruhua cúj niman tsínj da aj.” Daj hua gataj Jesús gunun nane̱ xi̱ꞌi daj. ");
INSERT INTO trq_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ni̱ nachínj snanꞌanj Jesús nane̱ xi̱ꞌi daj. Ni̱ gataj sij: ―Da̱j gu̱ꞌnaj re̱ꞌ únj. ―Daj gataj Jesús. Ni: ―Xiꞌninꞌ nico gu̱ꞌnā aj. Daj si gaꞌi̱ ni̱nꞌ ruhua únj. ―Daj gataj nane̱ xi̱ꞌi nu̱n chruhua tsínj daj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ni̱ gaꞌmi yaco nane̱ xi̱ꞌi rian Jesús sisi̱ si̱ gaꞌnij síꞌ ga̱nꞌanj ga̱nꞌ ni nane̱ xi̱ꞌi daj ango yuꞌuj mánj. ");
INSERT INTO trq_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ni̱ ni̱chrunꞌ xiꞌí quij mán ꞌngo̱ xiꞌninꞌ xxi ni xacáj xa xuj aj. ");
INSERT INTO trq_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ni̱ gaꞌmi yaco ni nane̱ xi̱ꞌi rian Jesús. Ni̱ gataj ni sij: ―Ga̱ꞌnij re̱ꞌ ga̱nꞌanj únj ga̱tu únj chruhua niman ni xacáj daj. ―Daj gataj ni nane̱ xi̱ꞌi daj. ");
INSERT INTO trq_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ngaa ni̱ gaꞌuej ruhua Jesús sisi̱ daꞌngaꞌ daj gui̱ꞌyaj ni nane̱ xi̱ꞌi. Ngaa ni̱ gahui ni nane̱ xi̱ꞌi chruhua cúj niman tsínj daj. Ngaa ni̱ gatúj ni sij chruhua niman ni xacáj daj. Ni̱ ma̱n ꞌngo̱ si hui̱j mí xacáj. Ngaa ni̱ ꞌngo̱ ganꞌanj gue̱ xiꞌninꞌ xacáj daj guinij ni xúꞌ chra̱ ꞌngo̱ huej. Ni̱ guinij ni xúꞌ chruhua laguna gahuiꞌ ni xúꞌ chruhua nnee aj. ");
INSERT INTO trq_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ni̱ gunánj ni tsínj dugumi ni xacáj daj na̱nꞌ ni sij xánj ni sij nga̱ rian ni tsínj nne riqui quij nej. Ni̱ nataꞌ ni sij da̱j gahuin guiranꞌ ni sij. Hué dan ni̱ gahui ni ngüi̱ daj ganꞌanj gui̱niꞌyaj ni sij u̱n sin huin guiranꞌ ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ni̱ ngaa guisíj ni ngüi̱ rian nne Jesús, ni̱ guiniꞌi ni sij tsínj gunu̱n nane̱ xi̱ꞌi niman daj. Sani̱ yya̱j ni̱ dínj nne sij nu̱n sij si-ganꞌ sij. Ni̱ hua sa̱ꞌ gaꞌue nani ruhua sij. Ni̱ guxuꞌuiꞌ ni ngüi̱ guisíj da aj. ");
INSERT INTO trq_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ni̱ ni tsínj guiniꞌi da̱j guiranꞌ tsínj gunu̱n nane̱ xi̱ꞌi niman daj nga̱ da̱j guiranꞌ ni xacáj nej, ni̱ ganani ni sij cuento daj rian ni ngüi̱ gaꞌna̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ngaa ni̱ gaxi̱ꞌi ni sij gaꞌmi yaco ni sij rian Jesús sisi̱ ga̱hui síꞌ ga̱nꞌanj síꞌ xánj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ni̱ ngaa gatúj Jesús chruhua rio̱ chéj rian nnee, ni̱ gaꞌmi yaco tsínj gunu̱n nane̱ xi̱ꞌi rian Jesús sisi̱ ga̱ꞌuej síꞌ gui̱nicaj dugüiꞌ síꞌ nga̱ sij ga̱nꞌanj nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Sani̱ nun gaꞌuej Jesús. Ni̱ gataj sij gunun tsínj daj: ―Güi̱j na̱nꞌ ducuá re̱ꞌ, ngaa ni̱ na̱taꞌ re̱ꞌ gu̱nun ni dugüíꞌ re̱ꞌ daranꞌ si sa̱ꞌ guiꞌyaj Yanꞌanj xiꞌí manꞌán re̱ꞌ. Ni̱ na̱taꞌ re̱ꞌ sisi̱ nahuin ꞌi̱ ruhua Yanꞌanj niꞌya manꞌán re̱ꞌ nej aj. ―Daj gataj Jesús gunun sij aj. ");
INSERT INTO trq_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ngaa ni̱ ganꞌanj tsínj daj gaxi̱ꞌi sij nataꞌ sij rian ni ngüi̱ mán ꞌngo̱ yuꞌuj gu̱ꞌnaj Decápolis daranꞌ si sa̱ꞌ guiꞌyaj Jesús xiꞌí sij. Ni̱ ganꞌanj ruhua daranꞌ ni ngüi̱ nga̱ nuguanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ni̱ nne Jesús chruhua rio̱ nanica̱j ru̱huaꞌ yún sij anéj chrej duꞌua laguna. Ni̱ ducu guisíj ni ngüi̱ rian nne sij. Ni̱ niquinꞌ ni̱chrunꞌ Jesús duꞌua nnee. ");
INSERT INTO trq_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ngaa ni̱ gaꞌna̱ꞌ ꞌngo̱ tsínj nicaj sun chruhua si-nuhui ni tsínj israelita gu̱ꞌnaj síꞌ Jairo. Ni̱ ngaa guiniꞌi síꞌ Jesús, ni̱ ganiquinꞌ ráj da̱coj síꞌ dacój Jesús. ");
INSERT INTO trq_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ni̱ gaꞌmi yaco ni̱nꞌ ruhua síꞌ rian Jesús. Ni̱ gataj sij: ―Ruhua ga̱huiꞌ daꞌni̱ xa̱nāj. Gu̱nꞌ ni gu̱taꞌ re̱ꞌ raꞌá re̱ꞌ rian únꞌ. Ni̱ ga̱nahuin únꞌ, gui̱ꞌyáj re̱ꞌ. Ngaa ni ga̱ne únꞌ. ―Daj gataj tsínj daj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ngaa ni̱ ganꞌanj Jesús nga̱ sij. Ni̱ nico ni̱nꞌ ruhua ni ngüi̱ nicoꞌ ganꞌanj. Ni̱ ducu guruꞌman ni ngüi̱ xiꞌníj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ni̱ scanij ni ngüi̱ huaj ruꞌman daj, ni̱ huaj ꞌngo̱ yunꞌunj xa̱na aꞌnanꞌ. Daj si uráj tun únꞌ yaꞌyoj guisíj da xu̱huij yoꞌ huaj únꞌ. ");
INSERT INTO trq_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ni̱ yaco guiranꞌ manꞌan únꞌ nga̱ gaꞌi̱ ni tsínj ꞌyaj go̱noꞌo. Ni̱ gutinꞌ únꞌ daranꞌ sanꞌanj hua rian únꞌ nga̱ ni tsínj ꞌyaj go̱noꞌo. Sani̱ ꞌngo̱ nun níꞌyanj-ánꞌ si ꞌyaj ni tsínj daj. Nna̱nj gaxi̱ꞌi xiꞌi̱ nga̱ únꞌ doj ga̱ aj. ");
INSERT INTO trq_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ngaa ni̱ ngaa gunun únꞌ aꞌmi ni ngüi̱ xiꞌí Jesús, ni̱ ganꞌanj ni̱chi únꞌ scanij ni ngüi̱ guisíj únꞌ ru̱cu Jesús. Ni̱ ganun únꞌ chra̱ raꞌa únꞌ duꞌua si-ganꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Daj si gani ruhua únꞌ: “Sisi̱ urin ga̱nūn chra̱ raꞌā duꞌua si-ganꞌ síꞌ, ngaa ni̱ na̱huīn.” Daj gani ruhua únꞌ. ");
INSERT INTO trq_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ngaa ni̱ ꞌngo̱ hora ganiquinꞌ si uráj tun. Ni̱ guiniꞌi únꞌ si guisíj ganahuin únꞌ, guiꞌyaj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ngaa ni̱ ꞌngo̱ hora xacaj Jesús cuenta sisi̱ hua guiꞌyaj go̱noꞌo sij ꞌngo̱ ngüi̱ daj nga̱ si-fuerza manꞌan sij. Hué dan ni̱ nanica̱j Jesús guiniꞌyaj sij. Ni̱ nachínj snanꞌanj sij. Ni̱ gataj sij: ―Da̱j hua á re̱ꞌ ganun raꞌa si-ganꞌānj únj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ngaa ni̱ gataj ni tsínj nicoꞌ sij: ―Ni̱ꞌyáj re̱ꞌ. Ma̱n ni̱nꞌ ruhua ni ngüi̱ xiꞌníj re̱ꞌ ruꞌman ni sij manꞌán re̱ꞌ. Ni̱ nachínj snanꞌanj re̱ꞌ: “Da̱j hua ni ngüi̱ ganun raꞌa manꞌān únj.” ―Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Sani̱ niꞌyaj Jesús xiꞌníj sij nánj sisi̱ u̱n ngüi̱ ganun raꞌa sij. ");
INSERT INTO trq_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Hué dan ni̱ guxuꞌuiꞌ yunꞌunj xa̱na daj. Ni̱ nagunánj únꞌ xiꞌí si niꞌi únꞌ sisi̱ nahuin manꞌan únꞌ. Ngaa ni̱ gaꞌna̱ꞌ únꞌ gane ráj da̱coj únꞌ rian Jesús. Ni̱ nataꞌ yya únꞌ daranꞌanj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ni̱ gataj Jesús: ―Xicaꞌuī, ganahuín re̱ꞌ, guiꞌyaj si guxuman ruhuá re̱ꞌ niꞌyáj re̱ꞌ manꞌānj. Ni̱ dínj ga̱huin nimán re̱ꞌ ga̱nꞌanj re̱ꞌ aj. Ni̱ gu̱nucuáj re̱ꞌ na̱huín re̱ꞌ rian xiꞌi̱ gaꞌnánꞌ re̱ꞌ. ―Gataj Jesús gunun únꞌ anj. ");
INSERT INTO trq_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ni̱ hua gue̱ aꞌmi sij, ni̱ gaꞌna̱ꞌ ni si-moso tsínj nicaj sun chruhua nuhui. Ni̱ gataj ni sij gunun Jairo: ―Guisíj gahuiꞌ daꞌni̱ xa̱na re̱ꞌ. Ni̱ u̱n sin huin ni̱ ga̱rasun re̱ꞌ rian maestro únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Sani̱ ngaa gunun Jesús si gataj ni tsínj daj, ni̱ gataj sij gunun tsínj nicaj sun chruhua nuhui daj: ―Si̱ guxuꞌuíꞌ re̱ꞌ mánj. Maan si gu̱xuman yya ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ manꞌānj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ni̱ nun ga̱ꞌuej ruhua Jesús sisi̱ ga̱nꞌanj ango tsínj nga̱ síꞌ. Sani̱ urin Pedro nga̱ Jacobo nej, Juan jnánj Jacobo nej, gaꞌuej Jesús ga̱nꞌanj nga̱ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ni̱ ngaa guisíj Jesús ducuá tsínj nicaj sun daj, ni̱ niꞌyaj síꞌ sisi̱ ducu aco ni ngüi̱. Ni̱ aguáj ne. ");
INSERT INTO trq_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ngaa ni̱ gatúj Jesús chruhua hueꞌ. Ni̱ gataj sij rian ni ngüi̱ daj: ―Ni̱ u̱n sin huin ꞌyaj á re̱ꞌ xingaꞌ, ni̱ aco a ni é re̱ꞌ únj. Daj si sé si gahuiꞌ tsinꞌ xa̱na mánj. Sani̱ si ato nánj. ―Daj gataj Jesús gunun ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ngaa ni̱ gaꞌngaꞌ na̱co ni sij guiniꞌi ni sij manꞌan Jesús. Sani̱ guiri Jesús daranꞌ ni ngüi̱ ne̱ꞌ chrej xe̱ꞌ. Ni̱ nicaj Jesús chre tsinꞌ xa̱na daj nga̱ nni nej, ni̱ tsínj huaj nga̱ sij nej, gatúj sij rian ngaj níman daj. ");
INSERT INTO trq_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ni̱ guidaꞌa sij raꞌa únꞌ. Ni̱ gataj sij si-nu̱guanꞌ sij: ―Talita cumi. ―Gataj Jesús. Ni̱ rian si-nu̱guanꞌ sij, ni̱ nuguanꞌ daj ruhuaj gata: Tsinꞌ xa̱na. Atā rián so̱ꞌ sisi̱ na̱chica so̱ꞌ. Daj huin ruhuaj gata nuguanꞌ gataj Jesús gunun únꞌ. ");
INSERT INTO trq_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ni̱ ꞌngo̱ hora nachica tsinꞌ xa̱na daj. Ni̱ gaxi̱ꞌi gache-éꞌ. Ni̱ tsinꞌ xa̱na daj huaj xu̱huij yoꞌ. Ni̱ ganꞌanj ruhua ni ngüi̱ guiniꞌi daj. ");
INSERT INTO trq_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Sani̱ gaꞌninꞌ nico Jesús sun rian ne sisi̱ si̱ nataꞌ ne nuguanꞌ daj rian ni̱ a̱ ꞌngo̱ ni ngüi̱ mánj. Ni̱ gataj sij sisi̱ ga̱ꞌuiꞌ ne si xa̱ tsinꞌ xa̱na da aj. ");
INSERT INTO trq_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ngaa ni̱ gahui Jesús yuꞌuj daj na̱nꞌ sij xánj sij. Ni̱ guinicoꞌ ni tsínj nicoꞌ sij nej aj. ");
INSERT INTO trq_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ni̱ güi naránj ruhua ni ngüi̱, ni̱ gaxi̱ꞌi sij digyán sij chruhua si-nuhui ni tsínj israelita. Ni̱ ganꞌanj ruhua ni sij ngaa gunun ni sij si-nu̱guanꞌ Jesús. Ni̱ gataj ni sij: ―Ni̱ a̱ gahuin chru̱n síꞌ daranꞌ nuguanꞌ nan únj. Ni̱ a̱ guiri síꞌ, ni̱ gahuin chru̱n síꞌ guiꞌyaj síꞌ sun sa̱ꞌ nan únj. ");
INSERT INTO trq_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Hué síꞌ huin tsínj acoj chrun. Ni̱ daꞌníj María huin sij. Ni̱ hué ni jnánj sij huin Jacobo nej, José nej, Judas nej, Simón nej. Ni̱ nne ni xicaꞌuij sij scanij néꞌ. ―Daj gataj ni tsínj ma̱n xánj Jesús. Xiꞌí da ni̱ gahuin na̱co ruhua ni sij niꞌyaj ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Sani̱ gataj Jesús: ―Nu̱n yanꞌanj ni ngüi̱ ꞌngo̱ tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj u̱n yuꞌuj huaj sij. Sani̱ ngaa nasíj sij xánj sij rian ma̱n ni dugüiꞌ sij, ngaa ni̱ nitaj si aꞌmi sa̱ꞌ ni dugüiꞌ sij niꞌyaj ni síꞌ xiꞌí sij mánj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ni̱ nun ga̱ꞌue guiꞌyaj sij ꞌngo̱ ni rasu̱n sa̱ꞌ scanij ni sij. Maan si gutaꞌ sij raꞌa sij rian do̱j ni tsínj aꞌnanꞌ. Ni̱ nahuin ni síꞌ, guiꞌyaj sij. ");
INSERT INTO trq_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ni̱ gahuin yanꞌanj ruhua Jesús xiꞌí si nun gu̱xuman ruhua ni sij ni̱ꞌyaj ni sij manꞌan síꞌ mánj. Ni̱ gachéj Jesús digyán sij si-nu̱guanꞌ sij ni xumanꞌ ngaj ni̱chrunꞌ daj. ");
INSERT INTO trq_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Hué dan ni̱ gaquínj Jesús xu̱huij ranꞌ ni tsínj nicoꞌ sij ga̱ꞌnaꞌ. Ngaa ni̱ gaxi̱ꞌi sij gaꞌníj sij hui̱j hui̱j ranꞌ ni síꞌ ga̱nꞌanj. Ni̱ gaꞌuiꞌ sij sun rian ni síꞌ sisi̱ gui̱nicaj ni síꞌ sun rian ni nane̱ xi̱ꞌi. ");
INSERT INTO trq_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ni̱ gaꞌninꞌ Jesús sun rian ni sij sisi̱ ga̱ yu̱n ni sij ga̱nꞌanj ni sij. Maan si urin rutsi̱ ni̱caj ni sij ga̱nꞌanj ni sij. Ni̱ si̱ gaꞌue ni̱caj ni sij xinánj ni sij nej, chrachrúnj nej, sanꞌanj nej, ga̱nꞌanj ni sij mánj. ");
INSERT INTO trq_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ga̱ꞌue gui̱ꞌnij ni sij dacánj ni sij, sani̱ si̱ gaꞌue gui̱nicaj ni sij atsij na̱duna ni sij ga̱nꞌanj ni sij mánj. ");
INSERT INTO trq_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ni̱ gataj Jesús: ―Ni̱ ngaa ga̱tu ni é re̱ꞌ chruhua ꞌngo̱ hueꞌ, ni̱ gu̱naj ni é re̱ꞌ hueꞌ daj da síj ga̱hui a ni é re̱ꞌ xumanꞌ daj ga̱nꞌanj án re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ni̱ sisi̱ hua ꞌngo̱ xumanꞌ naꞌuej ni sij na̱huin raꞌa ni sij a ni é re̱ꞌ, ni̱ naꞌuej ni sij gu̱nun ni sij si-nu̱guanꞌ a ni é re̱ꞌ, ngaa ni̱ na̱gunanꞌ ni é re̱ꞌ yoꞌój chru̱ dacój a ni é re̱ꞌ ngaa ga̱hui a ni é re̱ꞌ yuꞌuj daj. Ni̱ hué-éꞌ huin ꞌngo̱ ducuánj di̱gyán án re̱ꞌ rian ni tsínj daj sisi̱ nun guiꞌyaj sa̱ꞌ ni sij. Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ güi ga̱nahuij xungüi̱, ni̱ huaj ga̱huin doj castigo ni tsínj daj daj nga̱ si ga̱huin castigo ni tsínj xi̱ꞌi guimán asi̱j ná huin ni ngüi̱ guimán xumanꞌ Sodoma nga̱ xumanꞌ Gomorra. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ngaa ni̱ gahui ni sij ganꞌanj ni sij. Ni̱ gataj ni sij sisi̱ ga̱nani ruhua ni ngüi̱ xiꞌí si-ga̱quinꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ni̱ guiri nico ni sij nane̱ xi̱ꞌi chruhua niman ni ngüi̱ nej. Ni̱ garij ni sij gasiti rian nico ni ngüi̱ aꞌnanꞌ. Ni̱ ganahuin ni ngüi̱ daj, guiꞌyaj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Hué dan ni̱ gunun rey gu̱ꞌnaj Herodes da̱j guiꞌyaj Jesús. Daj si ni̱nꞌ ga̱chraꞌ gunun ni ngüi̱ xiꞌí Jesús. Ni̱ gataj Herodes: ―Hué sij huin Juan tsínj duguataꞌ nnee ganáꞌnij sij scanij ni níman ganahuin síꞌ Jesús. Xiꞌí daj ni̱ nucuaj sij ꞌyaj sij si sa̱ꞌ nga̱ si-fuerza sij. ―Daj gataj Herodes. ");
INSERT INTO trq_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Sani̱ gataj ango ni sij: ―Hué Jesús huin tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj gu̱ꞌnaj Elías gane síꞌ asi̱j ná. ―Daj gataj ni tsínj daj. Sani̱ gataj ango daꞌaj ni sij: ―Hué sij huin ango tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj rian ni ngüi̱ asi̱j ná aj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ni̱ ngaa gunun Herodes nuguanꞌ gaꞌmi ni ngüi̱, ni̱ gataj sij: ―Hué sij huin Juan tsínj chra̱ gaꞌnīj. Ni̱ yya̱j ni̱ ganáꞌnij sij ganahuin sij Jesús aj. ―Hué daj gataj Herodes nej aj. ");
INSERT INTO trq_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Daj si hua gaꞌninꞌ Herodes sun sisi̱ gui̱daꞌa ni sij manꞌan Juan gu̱mij ni sij cadena ga̱ri ni sij síꞌ duguaga̱ꞌ. Ni̱ daꞌngaꞌ daj guiꞌyaj Herodes si hua xacaj sij Herodías huin nica̱ jnánj sij tsínj gu̱ꞌnaj Felipe. ");
INSERT INTO trq_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ni̱ hua gataj Juan gunun Herodes: “Si̱ gaꞌue xa̱caj re̱ꞌ xacóꞌ re̱ꞌ ga̱huin nica̱ re̱ꞌ mánj.” Daj hua gataj Juan gunun Herodes. ");
INSERT INTO trq_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ni̱ xiꞌí daj ataj ru̱hua Herodías niꞌyaj únꞌ Juan huin ruhua únꞌ da̱gahuiꞌ únꞌ manꞌan Juan. Sani̱ nun ga̱ꞌue mánj. ");
INSERT INTO trq_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Daj si xuꞌuiꞌ Herodes niꞌyaj síꞌ manꞌan Juan. Ni̱ hua xacaj Herodes cuenta sisi̱ ꞌngo̱ tsínj hua ni̱ca niman huin Juan. Ni̱ ꞌngo̱ tsínj hua sa̱ꞌ ruhua niman huin sij nej. Ni̱ dugumi manꞌan Herodes Juan. Ni̱ nu̱nj si nun nariꞌ ruhua sij si gui̱ꞌyaj sij nga̱ si gataj Juan, sani̱ garanꞌ ruhua sij gunun sij si-nu̱guanꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hué dan ni̱ ꞌngo̱ güi, ni̱ guiꞌyaj ni sij ꞌngo̱ guiꞌyanj nico. Ni̱ hué güi daj huin güi ganasíj yoꞌ gaꞌnga rey Herodes. Ni̱ gaꞌuiꞌ sij xa ni tsínj nicaj sun nicoꞌ ru̱cu sij nga̱ ni tsínj general nej, ni tsínj huin achij ꞌna̱ꞌ estado Galilea nej. Ni̱ riqui guiꞌyanj daj, ni̱ gani ruhua Herodías sisi̱ da̱j ga̱ꞌue gui̱ꞌyaj únꞌ si ga̱huiꞌ Juan. ");
INSERT INTO trq_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ni̱ gatúj daꞌni̱ xa̱na Herodías riqui guiꞌyanj daj. Ni̱ guiranꞌanj únꞌ. Ni̱ ducu garanꞌ ruhua Herodes nga̱ ni tsínj mán nga̱ síꞌ rian mesa si guiꞌyaj únꞌ. Hué dan ni̱ gataj Herodes gunun yunꞌunj xa̱na daj: ―Ga̱chinj so̱ꞌ u̱n sin huin ga̱ranꞌ ruhuá so̱ꞌ riānj, ni̱ ri̱quīj nánj. ―Daj gataj Herodes. ");
INSERT INTO trq_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ni̱ gutaꞌ ni̱ca yya sij rian yunꞌunj xa̱na daj. Ni̱ gataj sij: ―Nu̱nj si ga̱chinj so̱ꞌ daꞌaj doꞌōj rian nicaj su̱nj sani̱ riquīj nánj. ―Daj gataj sij gunun yunꞌunj xa̱na daj. ");
INSERT INTO trq_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ni̱ gahui únꞌ nachínj snanꞌanj únꞌ nni únꞌ. Ni̱ gataj únꞌ: ―Ni̱ u̱n sin ga̱chīn ga̱huin siꞌyā ruhuá re̱ꞌ únj. ―Daj gataj únꞌ. Ngaa ni̱ gataj nni únꞌ: ―Ga̱chinj re̱ꞌ chra̱ Juan tsínj duguataꞌ nnee aj. ―Gataj Herodías gunun daꞌníj únꞌ. ");
INSERT INTO trq_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hué dan ni̱ daꞌ ráꞌyanj gatúj únꞌ rian nne rey. Ni̱ gataj únꞌ gunun síꞌ: ―Ruhuāj sisi̱ acuanꞌ ri̱qui re̱ꞌ ꞌngo̱ goꞌo nu̱n chra̱ Juan tsínj duguataꞌ nnee aj. ―Daj gataj únꞌ gunun rey aj. ");
INSERT INTO trq_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Hué dan ni̱ ducu ganani ruhua rey. Sani̱ ri̱an hua gutaꞌ ni̱ca yya sij rian yunꞌunj xa̱na daj ngaa mán ni tsínj nga̱ sij rian mesa, hué dan ni̱ nun ga̱ꞌuej ruhua sij si gue̱reꞌ nuguanꞌ gataj sij rian yunꞌunj da aj. ");
INSERT INTO trq_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ni̱ ꞌngo̱ hora gaꞌníj rey daj ꞌngo̱ snado ga̱nꞌanj na̱caj síꞌ chra̱ Juan anj. ");
INSERT INTO trq_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Hué dan ni̱ ganꞌanj snado ducuaga̱ꞌ gaꞌninꞌ sij chra̱ Juan nicaj sij gaꞌna̱ꞌ sij ꞌngo̱ goꞌo nu̱n chra̱ Juan. Ni̱ gaꞌuiꞌ sij raꞌa yunꞌunj xa̱na daj. Ni̱ nagaꞌuiꞌ únꞌ raꞌa nni únꞌ anj. ");
INSERT INTO trq_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ngaa ni̱ ngaa gunun ni tsínj nicoꞌ Juan, ngaa ni̱ gaꞌna̱ꞌ na̱caj ni sij níman daj nicaj ni sij ganꞌanj ga̱chinꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Hué dan ni̱ nahuin yuꞌ ni tsínj ganꞌanj ga̱ꞌmi nuguanꞌ sa̱ꞌ xiꞌí Jesús. Ni̱ nahuin yuꞌ ni sij nga̱ Jesús. Ni̱ nataꞌ ni sij daranꞌ si guiꞌyaj ni sij gunun Jesús. Ni̱ nataꞌ ni sij si digyán ni sij rian ni ngüi̱ nej. ");
INSERT INTO trq_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ngaa ni̱ gataj Jesús: ―Ga̱nꞌanj ni̱ni néꞌ na̱ran ruhua á re̱ꞌ do̱j quij quiꞌyanj na̱co aj. ―Daj gataj Jesús. Daj si gaꞌna̱ꞌ nico ni ngüi̱ rian Jesús. Ni̱ gahui ni sij nej. Xiꞌí daj, ni̱ naꞌue gui̱riꞌ Jesús nga̱ ni tsínj nicoꞌ sij xa̱ ni sij mánj. ");
INSERT INTO trq_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ngaa ni̱ gatúj ni sij chruhua ꞌngo̱ rio̱. Ni̱ ganꞌanj urin ni sij ꞌngo̱ quij quiꞌyanj na̱co. ");
INSERT INTO trq_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Sani̱ guiniꞌi nico ni ngüi̱ ganꞌanj ni sij. Ni̱ naniꞌi ni ngüi̱ Jesús. Ni̱ gunánj ni sij ganꞌanj ni sij rian ga̱nꞌanj ni du̱güiꞌ Jesús. Ni̱ ꞌna̱ꞌ ni ngüi̱ daj ni xumanꞌ ngaj ni̱chrunꞌ. Ni̱ guisíj sini ni sij anaꞌuij ni sij si ga̱ꞌnaꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ni̱ ngaa nanij Jesús chruhua rio̱, ngaa ni̱ guiniꞌi sij mán nico ni ngüi̱ aj. Ni̱ gahuin ꞌi̱ ruhua sij niꞌyaj sij ni síꞌ. Daj si rúnꞌ huin xachij nitaj tsínj dugumi huin ni sij. Ngaa ni̱ gaxi̱ꞌi sij digyán sij gaꞌi̱ nuguanꞌ rian ni ngüi̱ daj. ");
INSERT INTO trq_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ni̱ ngaa guisíj güi diꞌni̱, ni̱ gaꞌna̱ꞌ ni tsínj nicoꞌ Jesús. Ni̱ gataj ni sij: ―Yuꞌuj nan hua níꞌnij, nitaj ni ngüi̱ mán mánj. Ni̱ guisíj gahuin diꞌni̱. ");
INSERT INTO trq_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ngaa ni̱ na̱ꞌnij re̱ꞌ ni ngüi̱ ga̱nꞌanj ni sij rancho nga̱ ni xumanꞌ ngaj ni̱chrunꞌ sisi̱ gui̱ran ni sij si xa̱ ni sij. ―Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Sani̱ gataj Jesús: ―Ga̱ꞌuiꞌ a ni é re̱ꞌ si xa̱ ni sij nánj. ―Daj gataj Jesús. Ngaa ni̱ gataj ni tsínj daj: ―Ga̱nꞌanj ni únj gui̱ran ni únj hui̱j ciento denario chrachrúnj ga̱ꞌuiꞌ ni únj si xa̱ ni sij, ruhuá re̱ꞌ níꞌ. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ngaa ni̱ gataj Jesús: ―Ni̱ u̱ndaj chrachrúnj nicaj a ni é re̱ꞌ únj. Güi̱j a ni é re̱ꞌ ni̱ꞌyaj á re̱ꞌ aj. ―Daj gataj Jesús. Ni̱ ngaa guiniꞌi ni sij, ni̱ gataj ni sij: ―Ni̱ u̱nꞌunꞌ chrachrúnj nga̱ hui̱j gue̱ xucuaj nicaj ni únj anj. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ngaa ni̱ gaꞌninꞌ Jesús sun sisi̱ ga̱nꞌanj ga̱ne da xiꞌninꞌ ni ngüi̱ rian chrinꞌ mare̱ aj. ");
INSERT INTO trq_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ni̱ gane ni ngüi̱ da xiꞌninꞌ. Ni̱ nne ni xiꞌninꞌ huin ꞌngo̱ ciento ranꞌ ni ngüi̱ nej. Ni̱ nne ni xiꞌninꞌ huin hui̱j xia chiꞌ ranꞌ ni ngüi̱ nej. ");
INSERT INTO trq_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ngaa ni̱ guidaꞌa Jesús u̱nꞌunꞌ chrachrúnj nga̱ hui̱j xucuaj daj. Ni̱ niꞌyaj sij xataꞌ. Ni̱ nagaꞌuiꞌ sij si-guruhua Yanꞌanj. Ngaa ni̱ guraꞌ daꞌaj sij ni chrachrúnj gaꞌuiꞌ sij raꞌa ni tsínj nicoꞌ sij sisi̱ na̱gaꞌuiꞌ ni síꞌ raꞌa ni ngüi̱ aj. Ni̱ guraꞌ daꞌaj sij hui̱j xucuaj daj rian ni ngüi̱ nej aj. ");
INSERT INTO trq_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ngaa ni̱ xa daranꞌ ni sij. Ni̱ gara ran riqui ni sij. ");
INSERT INTO trq_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ngaa ni̱ ganacaj ni sij dasu gunáj daj nga̱ xucuaj nej. Ni̱ nara ni sij chruhua xu̱huij xuguti̱ chrachrúnj nga̱ xucuaj aj. ");
INSERT INTO trq_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ni̱ guisíj u̱nꞌunꞌ mí ni tsínj xa daj, guiꞌyaj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Hué dan ni̱ ꞌngo̱ hora guiꞌyaj Jesús sisi̱ ga̱tu ni tsínj nicoꞌ sij chruhua rio̱ chéj rian nnee gachin sini ni sij anéj chrej duꞌua laguna daꞌ xumanꞌ gu̱ꞌnaj Betsaida. Ni̱ gunáj Jesús. Ngaa ni̱ ganaꞌníj sij ni ngüi̱ na̱nꞌ ni síꞌ xánj ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ni̱ ngaa guisíj naꞌníj sij na̱nꞌ ni síꞌ, ngaa ni̱ gahui sij chra̱ ꞌngo̱ quij ganꞌanj sij ga̱chinj jniꞌyaj sij rian Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ni̱ ngaa guisíj guini̱, ni̱ huaj rio̱ daj da̱ni laguna xa̱chij da aj. Ni̱ gunáj urin Jesús rian yoꞌój. ");
INSERT INTO trq_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ni̱ guiniꞌi Jesús xun ni̱nꞌ ruhua ni sij nnee nga̱ chrun. Ni̱ ni̱naj ni sij. Daj si ꞌna̱ꞌ nucuaj nane̱ rian ni sij. Ni̱ ngaa chruhua gue̱rengaꞌ, ni̱ ganꞌanj Jesús gachéj sij rian nnee huaj sij na̱riꞌ dugüiꞌ sij nga̱ ni tsínj daj. Ni̱ huin ruhua sij ga̱chin sij ne̱ꞌ rian ni tsínj huaj da aj. ");
INSERT INTO trq_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ni̱ ngaa guiniꞌi ni tsínj nicoꞌ Jesús si chéj sij rian nnee, ni̱ gani ruhua ni síꞌ sisi̱ hué sij huin ꞌngo̱ staꞌnaj. Ni̱ xiꞌí daj gaguáj ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Daj si guiniꞌi daranꞌ ni síꞌ manꞌan sij. Ni̱ guxuꞌuiꞌ niman ni síꞌ. Hué dan ni̱ hora gataj Jesús gunun ni síꞌ: ―Ga̱ nucuaj niman án re̱ꞌ. Yūnj huin nánj. Si̱ guxuꞌuiꞌ a ni é re̱ꞌ mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ngaa ni̱ gahui Jesús chruhua rio̱ rian nu̱n ni sij. Ngaa ni̱ ganiquinꞌ nane̱. Ni̱ ganꞌanj ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Daj si nun xacaj cuenta ni sij xiꞌí si sa̱ꞌ guiꞌyaj Jesús ngaa guraꞌ daꞌaj síꞌ chrachrúnj. Ni̱ hua ru̱miꞌ gue̱ niman ni sij. Ni̱ nun ga̱ꞌue gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ni̱ ngaa guisíj ni sij anéj duꞌua laguna xa̱chij daj, ni̱ guisíj ni sij ꞌngo̱ yuꞌuj gu̱ꞌnaj Genesaret. Ni̱ numij ni sij rio̱ duꞌua laguna aj. ");
INSERT INTO trq_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ni̱ ngaa nanij ni sij chruhua rio̱, ngaa ni̱ ꞌngo̱ hora gananiꞌi ni ngüi̱ manꞌan Jesús. ");
INSERT INTO trq_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ni̱ gunánj daranꞌ ni ngüi̱ ꞌna̱ꞌ daꞌ daranꞌ xumanꞌ. Ni̱ gutaꞌ ni sij ni ngüi̱ aꞌnanꞌ rian chrun chéj nicaj ni sij gaꞌna̱ꞌ ni sij rian huaj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ni̱ daranꞌ xumanꞌ gatúj Jesús si xumanꞌ leꞌej nej, si xumanꞌ xa̱chij nej, si rancho nej, ni̱ gurúj ni sij ni ngüi̱ aꞌnanꞌ ne̱ꞌ cayu. Ni̱ gachínj jniꞌyaj ni sij sisi̱ ga̱ꞌuej síꞌ, ni̱ ga̱nun ni sij hué duꞌua si-ganꞌ síꞌ. Ni̱ ganahuin daranꞌ ni ngüi̱ ganun si-ganꞌ síꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ni̱ gahuin ni̱chrunꞌ ni tsínj fariseo nga̱ ni tsínj digyán si-ley Moisés rian nne Jesús. Ni̱ ꞌna̱ꞌ ni sij xumanꞌ Jerusalén. ");
INSERT INTO trq_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ni̱ guiniꞌi ni sij sisi̱ nitaj si nania̱ꞌ nico ni tsínj nicoꞌ Jesús raꞌa ni síꞌ ngaa xa ni síꞌ chrachrúnj. Ngaa ni̱ gaꞌmi quij ni sij gataj ni sij sisi̱ nun hua sa̱ꞌ si ꞌyaj ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Daj si nicaj ni tsínj fariseo nga̱ daranꞌ ni tsínj israelita ꞌngo̱ ducuánj si digyán xi ni sij rian ni sij. Ni̱ sisi̱ nitaj si nania̱ꞌ nico ni sij raꞌa ni sij, ngaa ni̱ si̱ xa ni sij, gataj ni xi ni sij. ");
INSERT INTO trq_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ni̱ ngaa nasíj ni sij huanꞌanj ni sij yuꞌue̱, ngaa ni̱ sisi̱ nitaj si nania̱ꞌ nico ni sij raꞌa ni sij, ni̱ si̱ xa ni sij nej mánj. Ni̱ hua ná ni̱ gaꞌninꞌ ni xi ni sij sun rian ni sij sisi̱ da̱j gui̱ꞌyaj ni sij. Hué dan ni̱ naꞌninꞌ ni sij vaso nej, siu̱ nej, chruj gagaꞌ nej, nga̱ nna nej aj. ");
INSERT INTO trq_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Xiꞌí daj gachínj snanꞌanj ni tsínj fariseo nga̱ ni tsínj digyán si-ley Moisés manꞌan Jesús. Ni̱ gataj ni sij: ―Ni̱ u̱n sin huin ni̱ nitaj si nicoꞌ ni tsínj nicoꞌ manꞌán re̱ꞌ dugumi ni sij si-du̱cuanj xi únj únj. Xa ni sij, sani̱ nitaj si nania̱ꞌ nico ni sij raꞌa ni sij mánj. ―Daj gataj ni tsínj daj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ngaa ni̱ gataj Jesús: ―Hué ni é re̱ꞌ huin tsínj digyaꞌ yunꞌunj. Hua yya xa̱ngaꞌ si-nu̱guanꞌ xíꞌ Isaías ngaa gaꞌmi sij si-nu̱guanꞌ Yanꞌanj xiꞌí ni é re̱ꞌ. Daj si gataj sij: Nu̱n yanꞌanj ni ngüi̱ nan nga̱ duꞌua ni sij yūnj anj. Sani̱ ni̱ni huin niman ni sij nánj. ");
INSERT INTO trq_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nitaj si níꞌyanj si nicoꞌ ni sij yūnj mánj. Daj si nuguanꞌ digyán ni sij huin nuguanꞌ aꞌninꞌ ni tsínj sun anj. Ni̱ sé si digyán ni sij si-nu̱guanꞌānj rian ni ngüi̱ mánj. Daj gataj si-nu̱guanꞌ xíꞌ Isaías. ");
INSERT INTO trq_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Daj si dunáj ni é re̱ꞌ nuguanꞌ gaꞌninꞌ Yanꞌanj sun rian néꞌ. Ni̱ daꞌa ni é re̱ꞌ si-du̱cuanj ni ngüi̱. Ngaa ni̱ naꞌninꞌ a ni é re̱ꞌ ni siu̱ nej, ni vaso nej. Ni̱ dagahuin ni é re̱ꞌ gaꞌi̱ ango nuguanꞌ nej. ―Gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ni̱ gataj Jesús nej: ―Hua dunáj gue̱ ni é re̱ꞌ nuguanꞌ gaꞌninꞌ Yanꞌanj sun rian néꞌ. Ni̱ dugumi ni é re̱ꞌ si-du̱cuanj ni manꞌan ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","’Ni̱ gataj Moisés: “Gui̱nun yanꞌánj re̱ꞌ chré re̱ꞌ nga̱ nní re̱ꞌ.” Ni̱: “Ni̱ u̱n tsínj aꞌmi quij rian chrej sij nga̱ nni sij, ngaa ni̱ ga̱huiꞌ sij nánj.” Daj gataj Moisés. ");
INSERT INTO trq_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Sani̱ ataj á re̱ꞌ sisi̱ ga̱ꞌue ga̱taj ꞌngo̱ tsínj daj gu̱nun chrej sij nga̱ nni sij: “Huin ruhuāj ri̱quīj sanꞌanj nan rian nu̱ngüej é re̱ꞌ. Sani̱ yya̱j ni̱ si̱ gaꞌue. Daj si sanꞌanj nicā nan huin corbán”, ataj ni é re̱ꞌ. Ni̱ corbán huin ruhuaj gata ofrenda güenda Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ni̱ sisi̱ daꞌngaꞌ daj ga̱taj ꞌngo̱ tsínj daj rian chrej sij nga̱ nni sij, ngaa ni̱ nun ga̱ꞌuej sij chra̱cuij sij chrej sij nga̱ nni sij, ꞌyaj ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ni̱ hué ducuánj daj ꞌyaj yu̱n ni é re̱ꞌ si-nu̱guanꞌ Yanꞌanj, digyán ni é re̱ꞌ si-chrej ni é re̱ꞌ rian ni ngüi̱. Ni̱ hué daꞌngaꞌ daj ꞌyaj ni é re̱ꞌ nga̱ ango ni nuguanꞌ nej. ―Daj gataj Jesús gunun ni fariseo nga̱ ni tsínj digyán ley rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Hué dan ni̱ gaquínj Jesús ga̱ꞌnaꞌ ni ngüi̱ rian sij. Ni̱ gataj sij: ―Gu̱nun daranꞌ ni é re̱ꞌ nuguanꞌ nan. Ni̱ ga̱ra daꞌngaꞌ ruhua á re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nitaj si gahuin quij chruhua niman ꞌngo̱ tsínj daj, ꞌyaj rasu̱n atuj duꞌua sij mánj. Sani̱ gahuin quij chruhua niman sij, ꞌyaj nuguanꞌ ahui chruhua niman sij aj. ");
INSERT INTO trq_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ni̱ ngüi̱ ta̱j chraquij, ni̱ gu̱nun ni sij aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ni̱ ngaa gahuin ni̱ni Jesús rian ni ngüi̱, ni̱ gatúj sij chruhua hueꞌ. Ngaa ni̱ nachínj snanꞌanj ni tsínj nicoꞌ sij xiꞌí nuguanꞌ digyán sij rian ni ngüi̱ daj. ");
INSERT INTO trq_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ngaa ni̱ gataj Jesús: ―Hua gue̱ naꞌue ga̱ra daꞌngaꞌ ruhua á re̱ꞌ míꞌ. Ni̱ nunun a ni é re̱ꞌ sisi̱ nitaj si ga̱huin quij chruhua niman ni ngüi̱ ꞌyaj rasu̱n atuj duꞌua ni sij míꞌ. ");
INSERT INTO trq_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Daj si nitaj si atuj-úꞌ nimúnꞌ. Sani̱ atuj-úꞌ riquíꞌ. Hué dan ni̱ ahui-íꞌ riꞌíꞌ. ―Daj gataj Jesús. Ni̱ nuguanꞌ nan huin ruhuaj gata sisi̱ daranꞌ si xa néꞌ hua sa̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ni̱ gataj Jesús nej: ―Gahuin quij ruhua niman ꞌngo̱ tsínj daj, ꞌyaj nuguanꞌ ahui chruhua niman sij aj. ");
INSERT INTO trq_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Daj si nan huin nuguanꞌ quij ahui chruhua niman ni ngüi̱. Ni̱ ani quij ruhua ni sij. Ni̱ aꞌmi ni sij nga̱ ango nica̱ ni ngüi̱ nej. Ni̱ ꞌyaj squi̱raꞌ ni sij nej. Ni̱ dagahuiꞌ ni sij níman nej. ");
INSERT INTO trq_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ni̱ ꞌyaj tu̱ ni sij nej. Ni̱ huin ruhua ni sij gui̱riꞌ ni sij siꞌyaj dugüiꞌ ni sij nej. Ni̱ ꞌyaj ni sij gaquinꞌ nej. Ni̱ digyaꞌ yunꞌunj ni sij nej. Ni̱ ꞌyaj quij ni sij nga̱ nnee̱ cúj ni sij nej. Ni̱ huin xicoj ruhua ni sij nej. Ni̱ aꞌmi yya̱ ni sij nej. Ni̱ nne̱ ni sij nej. Ni̱ ni̱ꞌyun aꞌmi ni sij nej. ");
INSERT INTO trq_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Hué daranꞌ nuguanꞌ quij nan ahui chruhua niman ni ngüi̱. Ni̱ hué ni nuguanꞌ nan huin gui̱ꞌyaj quij chruhua niman ni ngüi̱ nej. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Hué dan ni̱ naxu̱man Jesús gahui sij yuꞌuj daj ganꞌanj sij xumanꞌ Tiro nga̱ xumanꞌ Sidón. Ni̱ gatúj sij chruhua ꞌngo̱ hueꞌ. Ni̱ nitaj si huin ruhua sij sisi̱ na̱niꞌi ni ngüi̱ manꞌan sij. Sani̱ nun ga̱ꞌue gui̱xij hui̱ sij mánj. ");
INSERT INTO trq_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ni̱ ꞌngo̱ hora gunun ꞌngo̱ yunꞌunj xa̱na sisi̱ guisíj Jesús yuꞌuj daj. Ni̱ nu̱n nane̱ xi̱ꞌi chruhua niman daꞌníj únꞌ. Ni̱ ganꞌanj únꞌ ganiquinꞌ ráj da̱coj únꞌ dacój manꞌan Jesús. ");
INSERT INTO trq_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ni̱ yunꞌunj xa̱na sirofenicia aꞌmi snanꞌanj griego huin únꞌ. Ni̱ gaꞌmi yaco únꞌ sisi̱ gui̱ri Jesús nane̱ xi̱ꞌi nu̱n niman daꞌníj únꞌ. ");
INSERT INTO trq_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sani̱ gataj Jesús: ―Ga̱naꞌuij acuánꞌ re̱ꞌ si xa̱ ni tsinꞌ le, ni̱ ga̱ra sini riqui aninꞌinj. Nitaj si hua sa̱ꞌ si ga̱ꞌneꞌ si-chra̱chrunj ni tsinꞌ ga̱ꞌuiꞌ duꞌua ni xuhue mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ngaa ni̱ nanica̱j únꞌ gataj únꞌ: ―Xa̱ngaꞌ si atáj re̱ꞌ Señor. Sani̱ daꞌ ni xuhue ma̱n riqui mesa xa xúꞌ ni daru̱ chrachrúnj ayu xa ni tsinꞌ anj. ―Daj gataj únꞌ. ");
INSERT INTO trq_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ngaa ni̱ gataj Jesús: ―Xiꞌí nuguanꞌ gaꞌmí re̱ꞌ, ni̱ ga̱ꞌue ga̱nꞌanj re̱ꞌ. Daj si hua guisíj gahui nane̱ xi̱ꞌi chruhua niman daꞌni̱ xa̱na re̱ꞌ aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ni̱ ngaa nasíj unj ducua unj, ni̱ xacaj unj cuenta sisi̱ ngaj daꞌni̱ xa̱na unj hua ngaj únꞌ rian nna. Sani̱ hua guisíj gahui nane̱ xi̱ꞌi chruhua niman únꞌ. ");
INSERT INTO trq_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Hué dan ni̱ gahui ru̱huaꞌ yún Jesús yuꞌuj ngaj xumanꞌ gu̱ꞌnaj Tiro. Ni̱ gachin sij xumanꞌ Sidón ganꞌanj sij yuꞌuj ngaj xumanꞌ gu̱ꞌnaj Decápolis. Ni̱ guisíj sij duꞌua laguna xa̱chij gu̱ꞌnaj Galilea aj. ");
INSERT INTO trq_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ni̱ nicaj ni sij ꞌngo̱ tsínj hua soꞌo naꞌue ga̱ꞌmi sa̱ꞌ síꞌ gaꞌna̱ꞌ ni sij rian Jesús. Ni̱ gachínj jniꞌyaj ni sij rian Jesús sisi̱ gu̱taꞌ síꞌ raꞌa síꞌ chra̱ tsínj da aj. ");
INSERT INTO trq_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ni̱ nicaj Jesús tsínj daj ganꞌanj sij ꞌngo̱ yuꞌuj nitaj ngüi̱ mánj. Ni̱ diguíj Jesús chra̱ raꞌa sij chruhua chraquij tsínj daj. Ngaa ni̱ gara staꞌnunj sij do̱j, ni̱ ganu̱n raꞌa sij yya̱ tsínj daj nej aj. ");
INSERT INTO trq_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ngaa ni̱ niꞌyaj Jesús xataꞌ guchej sij. Ni̱ gataj sij: ―Efata. ―Gataj Jesús. Ni̱ nuguanꞌ daj huin ruhuaj gata: Ga̱ na̱xiꞌni anj. ");
INSERT INTO trq_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ni̱ hué ꞌngo̱ hora daj, ni̱ naxiꞌni̱j chraquij tsínj soꞌo daj. Ni̱ nahuin sa̱ꞌ yya̱ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ni̱ gaꞌninꞌ Jesús sun rian ni tsínj niquinꞌ yuꞌuj daj sisi̱ si̱ nuna ni sij rian ni ngüi̱ si guiꞌyaj sij mánj. Hué dan ni̱ ngaa doj naꞌuej Jesús nu̱na ni sij rian ni ngüi̱, sani̱ na̱anj nariꞌ nucuaj ni sij doj nuna ni sij aj. ");
INSERT INTO trq_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ni̱ ducu ganꞌanj ruhua ni ngüi̱ xiꞌí si guiꞌyaj Jesús. Ni̱ gataj ni sij: ―Hua ꞌueé ꞌyaj sij daranꞌanj. Daꞌ tsínj soꞌo unun, ꞌyaj sij. Ni̱ daꞌ tsínj ráꞌyanꞌ aꞌmi, ꞌyaj sij nej aj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ni̱ güi daj, ni̱ huaj nico ni ngüi̱ nga̱ Jesús. Ni̱ nitaj si nicaj ni sij si xa ni sij. Ngaa ni̱ gaquínj Jesús ga̱ꞌnaꞌ ni tsínj nicoꞌ sij. Ni̱ gataj sij: ");
INSERT INTO trq_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Nahuin ꞌi̱ ruhuāj niꞌyā daranꞌ ni ngüi̱ ma̱n nan. Daj si síj hua̱ꞌnij güi mán ni sij ngāj aj. Ni̱ nitaj si nicaj ni sij si xa ni sij mánj. ");
INSERT INTO trq_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Sisi̱ na̱ꞌnī ni sij na̱nꞌ ni sij ducuá ni sij ngaa nitaj si xa ni sij, ni̱ gui̱nichre ni sij huaj ni sij chruhua chrej, ruhuāj aj. Daj si hua daꞌaj ni sij ꞌna̱ꞌ ga̱nꞌ anj. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ni̱ gataj ni sij gunun síꞌ: ―Da̱j u̱n sin gui̱ꞌyóꞌ gui̱riꞌ ga̱ꞌuiꞌ xa̱ ni ngüi̱ ꞌngo̱ yuꞌuj nitaj mán nan únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ngaa ni̱ nachínj snanꞌanj Jesús ni sij. Ni̱ gataj síꞌ: ―Ni̱ u̱ndaj chrachrúnj nicaj a ni é re̱ꞌ únj. ―Gataj Jesús. ―Ichij chrachrúnj nicaj ni únj. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ngaa ni̱ gaꞌninꞌ Jesús sun sisi̱ ga̱nꞌanj ga̱ne ni ngüi̱ rian yoꞌój. Ngaa ni̱ guidaꞌa sij ichij chrachrúnj raꞌa sij. Ni̱ nagoꞌ sij si guruhua Yanꞌanj. Ngaa ni̱ guraꞌ daꞌaj sij chrachrúnj daj gaꞌuiꞌ sij raꞌa ni tsínj nicoꞌ sij. Ni̱ daꞌngaꞌ ni síꞌ raꞌa ni ngüi̱ ma̱n anj. ");
INSERT INTO trq_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ni̱ nicaj ni sij ꞌngo̱ si hui̱j xucuaj le. Ngaa ni̱ nagoꞌ Jesús si guruhua Yanꞌanj. Ni̱ gaꞌninꞌ sij sun rian ni síꞌ sisi̱ da̱ꞌngaꞌ ni síꞌ xucuaj daj rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ni̱ xa daranꞌ ni sij. Ni̱ gara ran riqui ni sij. Ngaa ni̱ gara ichij xuguti, guiꞌyaj si xitinꞌ gunáj aj. ");
INSERT INTO trq_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ni̱ guisíj ꞌngo̱ si ga̱nꞌanj mí ni tsínj xa aj. Ngaa ni naꞌníj Jesús na̱nꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ngaa ni̱ ꞌngo̱ hora gatúj Jesús nga̱ ni tsínj nicoꞌ sij chruhua rio̱ chéj rian nnee ganꞌanj ni sij ꞌngo̱ yuꞌuj gu̱ꞌnaj Dalmanuta. ");
INSERT INTO trq_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ngaa ni̱ gaꞌna̱ꞌ ni tsínj fariseo. Ni̱ gaxi̱ꞌi ni sij gani dugüiꞌ ni sij nga̱ Jesús. Ni̱ chruhua ni sij gui̱ꞌyaj ni sij ꞌngo̱ xi̱ꞌ ga̱tu Jesús. Ngaa ni̱ gachínj ni sij rian Jesús sisi̱ gui̱ꞌyaj síꞌ ꞌngo̱ si sa̱ꞌ ꞌna̱ꞌ rian Yanꞌanj. Ngaa ni̱ gui̱niꞌi ni sij sisi̱ ꞌna̱ꞌ síꞌ rian Yanꞌanj, ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ngaa ni̱ guchej ni̱nꞌ ruhua Jesús, ni̱ gataj sij: ―Ni̱ u̱n sin huin ni̱ achínj ni ngüi̱ ma̱n yya̱j ꞌngo̱ si sa̱ꞌ ꞌna̱ꞌ rian Yanꞌanj riānj únj. Xa̱ngaꞌ yya atā gu̱nun a ni é re̱ꞌ sisi̱ si̱ guiꞌyā ꞌngo̱ si sa̱ꞌ ꞌna̱ꞌ rian Yanꞌanj gui̱niꞌi ni é re̱ꞌ mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ngaa ni̱ dunáj Jesús ni tsínj daj. Ni̱ gatúj ru̱huaꞌ yún sij chruhua rio̱ ganꞌanj sij anéj chrej duꞌua laguna xa̱chij da aj. ");
INSERT INTO trq_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ni̱ guiniꞌyun ni tsínj nicoꞌ Jesús guinicaj ni sij chrachrúnj xa̱ ni sij. Ni̱ urin chrachrúnj nicaj ni sij huaj ni sij chruhua rio̱ aj. ");
INSERT INTO trq_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ngaa ni̱ gaꞌninꞌ Jesús sun rian ni sij. Ni̱ gataj síꞌ: ―Ga̱ cuidado a ni é re̱ꞌ nga̱ manꞌan án re̱ꞌ. Ni̱ gu̱ruj a ni é re̱ꞌ nga̱ si-levadura ni tsínj fariseo nga̱ rey Herodes nej aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ni̱ gaꞌmi manꞌan ni sij gunun dugüiꞌ ni sij. Ni̱ gataj ni sij: ―Daꞌngaꞌ daj gaꞌmi Jesús xiꞌí si nitaj chrachrúnj nicaj únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Sani̱ gunun Jesús si gataj ni sij. Ngaa ni̱ gataj síꞌ: ―Ni̱ u̱n sin huin ataj á re̱ꞌ sisi̱ nitaj chrachrúnj nicaj á re̱ꞌ gaꞌna̱ꞌ á re̱ꞌ únj. Hua gue̱ naꞌue gu̱nun a ni é re̱ꞌ ga̱ꞌ. Ni̱ nitaj si acaj á re̱ꞌ cuenta da ga̱ míꞌ. Hua ránj laquinj chra̱ ni é re̱ꞌ nan níꞌ. ");
INSERT INTO trq_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nu̱n rundij rian án re̱ꞌ, sani̱ nun xigui̱n niꞌyaj á re̱ꞌ mánj. Nu̱n chraquij a ni é re̱ꞌ, sani̱ nunun a ni é re̱ꞌ mánj. Nitaj si nu̱n ruhua ni é re̱ꞌ ga̱ míꞌ. ");
INSERT INTO trq_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ngaa daꞌngāj u̱nꞌunꞌ gue̱ chrachrúnj xa u̱nꞌunꞌ mí ni tsínj daj, ngaa ni̱ u̱ndaj xuguti gara si xitinꞌ nacaj ni é re̱ꞌ únj. ―Daj gataj Jesús. Ngaa ni̱: ―Xu̱huij gahuin anj. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús: ―Ni̱ ngaa daꞌngāj ichij gue̱ chrachrúnj xa ga̱nꞌanj mí ni tsínj daj, ngaa ni̱ u̱ndaj xuguti gara nacaj ni é re̱ꞌ únj. ―Gataj Jesús. Ngaa ni: ―Ichij gahuin anj. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Hué dan ni̱ gataj Jesús: ―Hua nunun ni é re̱ꞌ ga̱ míꞌ. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Hué dan ni̱ guisíj ni sij xumanꞌ gu̱ꞌnaj Betsaida. Ni̱ nicaj ni ngüi̱ ꞌngo̱ tsínj duri gaꞌna̱ꞌ ni sij rian Jesús. Ni̱ gaꞌmi yaco ni sij sisi̱ ga̱nun raꞌa Jesús tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ngaa ni̱ guidaꞌa Jesús raꞌa tsínj duri daj. Ni̱ guiri sij síꞌ ne̱ꞌ chrej xe̱ꞌ xumanꞌ daj. Ni̱ gutaꞌ sij dane staꞌnunj sij rundij rian síꞌ. Ngaa ni̱ gutaꞌ sij raꞌa sij rian manꞌan tsínj daj. Ni̱ nachínj snanꞌanj sij síꞌ sisi̱ xigui̱n niꞌyaj síꞌ do̱j aj. ");
INSERT INTO trq_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ngaa ni̱ niꞌyaj síꞌ. Ni̱ gataj síꞌ: ―Niꞌīnj ni tsínj. Ni̱ da̱j rúnꞌ hua ni chrun hua ni sij. Sani̱ chéj ni sij niꞌyā aj. ―Daj gataj tsínj duri daj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Hué dan ni̱ gutaꞌ ru̱huaꞌ yún Jesús raꞌa sij rundij rian tsínj daj. Ni̱ niꞌyaj sa̱ꞌ sij. Ni̱ ganahuin sij. Ni̱ rugüiꞌ sa̱ꞌ daranꞌ si niꞌyaj sij nej aj. ");
INSERT INTO trq_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ngaa ni̱ naꞌníj Jesús na̱nꞌ sij ducuá sij. Ni̱ gataj síꞌ gunun sij: ―Si̱ gatúj re̱ꞌ chruhua xumanꞌ. Ni̱ si̱ gatáj re̱ꞌ rian ni̱ a̱ ꞌngo̱ ni ngüi̱ ma̱n xumanꞌ mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ngaa ni̱ gahui Jesús nga̱ ni tsínj nicoꞌ sij ganꞌanj ni sij ni xumanꞌ le yuꞌuj gu̱ꞌnaj Cesarea de Filipo. Ni̱ chéj ni sij huaj ni sij, ni̱ nachínj snanꞌanj Jesús ni sij. Ni̱ gataj síꞌ: ―Ni̱ u̱n tsínj huīnj ataj ni ngüi̱, ruhua á re̱ꞌ únj. ―Daj gataj Jesús nachínj snanꞌanj sij aj. ");
INSERT INTO trq_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ngaa ni̱ gataj ni tsínj nicoꞌ sij: ―Ataj ꞌngo̱ ni sij sisi̱ hué re̱ꞌ huin tsínj gu̱ꞌnaj Elías. Ni̱ ataj ango ni sij sisi̱ hué re̱ꞌ huin ango tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ngaa ni̱ nachínj snanꞌanj Jesús ni sij. Ni̱ gataj sij: ―Ni̱ u̱n tsínj huīnj, ruhua manꞌan án re̱ꞌ únj. ―Gataj Jesús. Ngaa ni̱ gataj Pedro: ―Hué re̱ꞌ huin Cristo aj. ―Daj gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Sani̱ gaꞌninꞌ Jesús sun rian ni sij sisi̱ si̱ nataꞌ ni sij rian ni̱ a̱ ꞌngo̱ ni ngüi̱ u̱n tsínj huin síꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ngaa ni̱ gaxi̱ꞌi Jesús digyán sij rian ni tsínj nicoꞌ sij. Ni̱ gataj sij sisi̱ hua nia̱n gui̱ranꞌ nico sij sayun huin sij daꞌníj ni ngüi̱. Ni̱ gataj Jesús sisi̱ da̱nicaj ni tsínj huin achij manꞌan sij. Ni̱ daꞌngaꞌ daj gui̱ꞌyaj ni chrej huin rian nga̱ ni tsínj digyán ley nej. Ni̱ da̱gahuiꞌ ni síꞌ manꞌan sij nej. Sani̱ xiráj hua̱ꞌnij güi, ni̱ ga̱naꞌnij sij, gataj sij. ");
INSERT INTO trq_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ni̱ nataꞌ ni̱ca Jesús nuguanꞌ daj rian ni tsínj nicoꞌ sij. Ngaa ni̱ nicaj Pedro Jesús ganꞌanj anéj sij do̱j. Ni̱ gaxi̱ꞌi Pedro chranꞌ sij síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Sani̱ nanica̱j Jesús niꞌyaj sij ni tsínj nicoꞌ sij. Ni̱ gahuin huee Jesús gataj sij rian Pedro: ―Gu̱xun re̱ꞌ manꞌán re̱ꞌ riānj, Satanás. Nitaj si huin ruhuá re̱ꞌ rúnꞌ huin ruhua Yanꞌanj mánj. Rúnꞌ huin ruhua ni ngüi̱ huin ruhuá re̱ꞌ nánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ngaa ni̱ gaquínj Jesús ni ngüi̱ ga̱ꞌnaꞌ ni sij rian niquinꞌ síꞌ nga̱ ni tsínj nicoꞌ síꞌ nej. Ni̱ gataj Jesús: ―Sisi̱ hua ꞌngo̱ tsínj ruhua ni̱coꞌ yūnj, ngaa ni̱ du̱naj tsínj daj si-chrej manꞌan sij. Ngaa síj ni̱ ga̱ta sij rugutsi̱ gui̱nicoꞌ sij yūnj gui̱ranꞌ sij sayun ngāj aj. ");
INSERT INTO trq_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tsínj naꞌuej ruhua ga̱huiꞌ sij ngāj, ni̱ ga̱ niꞌya sij. Sani̱ tsínj ga̱ꞌue ga̱huiꞌ xiꞌí manꞌānj nga̱ xiꞌí nuguanꞌ sa̱ꞌ aꞌmi manꞌānj, ngaa ni̱ ga̱ne ni̱ganj sij aj. ");
INSERT INTO trq_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ni̱ sisi̱ gui̱ꞌyaj gana ꞌngo̱ tsínj daj daranꞌ si ma̱n chruhua xungüi̱ gahuin siꞌyaj sij, ngaa ni̱ u̱n sin huin-ínꞌ sisi̱ ga̱ niꞌya niman sij, ruhua á re̱ꞌ únj. Nitaj si guiꞌyaj gana sij mánj. ");
INSERT INTO trq_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ni̱ nu̱nj si gue̱reꞌ siꞌyaj ꞌngo̱ tsínj daj chruhua xungüi̱ nan, sani̱ ga̱ꞌue ga̱huin nia̱ꞌ ruhua sij sisi̱ ga̱ ni̱ꞌnaꞌ ni̱ganj ni̱nꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","’Ni̱ xungüi̱ nan ma̱n ni ngüi̱ dunáj Yanꞌanj. Ni̱ ma̱n ni ngüi̱ ꞌyaj gaquinꞌ nej. Ni̱ sisi̱ hua ꞌngo̱ tsínj na̱ꞌaj niꞌyaj yūnj nga̱ si-nu̱guanꞌānj rian ni ngüi̱ daj, ngaa ni̱ ga̱huin na̱ꞌā nga̱ sij ngaa ga̱ꞌnaꞌ yūnj nga̱ ni ángel sa̱ꞌ chruhua xungüi̱ nan. Ni̱ güi ga̱ꞌnaꞌ yūnj daj, ni̱ ga̱huin ꞌuēj ni̱nꞌ ruhua, gui̱ꞌyaj chrē huīnj daꞌníj ni ngüi̱ aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ni̱ gataj Jesús nej: ―Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ nitaj si ga̱huiꞌ daranꞌ ni ngüi̱ mán yuꞌuj nan daꞌ gui̱niꞌi ni sij ga̱ꞌnaꞌ gui̱daꞌa Yanꞌanj sun nucuaj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ni̱ ngaa gachin hua̱tanꞌ güi, ni̱ nicaj Jesús Pedro nga̱ Jacobo nej, Juan nej, gahui sij ganꞌanj ni̱ni sij chra̱ ꞌngo̱ quij xa̱can. Ni̱ ganahuin ꞌueé nnee̱ cúj Jesús ne̱ꞌ rian ni sij. ");
INSERT INTO trq_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ni̱ nahuin aca̱ si-ganꞌ sij da̱j rúnꞌ hua yuꞌueꞌ ga̱tsi ni̱nꞌ huaj. Ni̱ a̱ ꞌngo̱ ngüi̱ mán chruhua xungüi̱ si̱ gunucuaj ne gu̱nan ne si-ganꞌ ne da̱j rúnꞌ hua ga̱tsi si-ganꞌ manꞌan sij ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ni̱ gurugüiꞌ re̱ngaꞌ nu̱ngüej tsínj gu̱ꞌnaj Elías nga̱ Moisés aꞌmi nu̱ngüej síꞌ nga̱ Jesús. ");
INSERT INTO trq_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ngaa ni̱ gataj Pedro gunun Jesús: ―Maestro, duguꞌna̱j mán néꞌ yuꞌuj nan. Ngaa ni̱ gui̱ꞌyóꞌ hua̱ꞌnij hueꞌ recoj le. Ni̱ ꞌngo̱j manꞌán re̱ꞌ. Ni̱ angoj Moisés. Ni̱ ángoj Elías. ―Daj gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Daj si nun niꞌi sij nínꞌ u̱n sin huin ga̱ꞌmi sij xiꞌí si ducu guxuꞌuiꞌ ni tsínj nicoꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ngaa ni̱ nasíj ꞌngo̱ nga guiran-ánꞌ rian aninꞌ sij. Ni̱ scanij nga gunun aninꞌ sij ꞌngo̱ nane̱ si gataj-áꞌ: ―Nan huin daꞌnī ꞌi̱ ruhuāj. Gu̱nun a ni é re̱ꞌ si ataj síꞌ. ―Daj gataj Yanꞌanj gunun aninꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ni̱ ꞌngo̱ hora ngaa niꞌyaj aninꞌ sij xiꞌníj sij, ni̱ nitaj ꞌngo̱ tsínj niquinꞌ guiniꞌi aninꞌ sij. Urin Jesús niquinꞌ nga̱ sij. ");
INSERT INTO trq_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ni̱ ngaa huaj aninꞌ sij nanij sij chra̱ quij, ni̱ gaꞌninꞌ Jesús sun rian aninꞌ sij sisi̱ si̱ nuna ni sij rian ni̱ a̱ ꞌngo̱ tsínj si guiniꞌi aninꞌ sij mánj. Ni̱ ngaa gui̱sij ga̱naꞌnij daꞌníj ni ngüi̱ da, ni̱ ga̱ꞌue ga̱nataꞌ aninꞌ sij rian ni ngüi̱ si guiniꞌi ni sij, ataj Jesús gunun aninꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ni̱ dínj ga duꞌua aninꞌ sij xiꞌí si guiniꞌi sij. Sani̱ nachínj snanꞌanj aninꞌ sij dugüiꞌ sij u̱n sin huin ruhua Jesús gataj síꞌ sisi̱ ga̱naꞌnij síꞌ scanij ni níman. ");
INSERT INTO trq_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ni̱ nachínj snanꞌanj aninꞌ sij Jesús. Ni̱ gataj sij: ―Ni̱ u̱n sin huin ataj ni maestro digyán ley sisi̱ hua sini ga̱ꞌnaꞌ tsínj gu̱ꞌnaj Elías únj. ―Daj gataj aninꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ngaa ni̱ gataj Jesús: ―Xa̱ngaꞌ ga̱ꞌnaꞌ sini Elías. Ni̱ hué síꞌ na̱guiꞌyaj sa̱ꞌ daranꞌanj. Ni̱ u̱n sin huin ataj si-nu̱guanꞌ Yanꞌanj sisi̱ gui̱ranꞌ daꞌníj ni ngüi̱ sayun. Ni̱ si̱ garanꞌ ruhua ni ngüi̱ ni̱ꞌyaj ni sij manꞌan síꞌ, ruhua ni é re̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Sani̱ atā gu̱nun a ni é re̱ꞌ sisi̱ hua gaꞌna̱ꞌ Elías. Ni̱ guiꞌyaj quij ni sij daranꞌ si garanꞌ ruhua ni sij guiꞌyaj ni sij nga̱ síꞌ da̱j rúnꞌ hua gataj si-nu̱guanꞌ Yanꞌanj xiꞌí síꞌ aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ni̱ ngaa guisíj ni sij rian ma̱n ango ni tsínj nicoꞌ Jesús, ngaa ni̱ guiniꞌi ni sij ma̱n ni̱nꞌ ruhua ni ngüi̱ ganica̱j ni̱nꞌ xiꞌníj ni síꞌ. Ni̱ ma̱n ni maestro digyán si-ley Moisés gani dugüiꞌ ni sij nga̱ ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ni̱ ngaa guiniꞌi ni ngüi̱ manꞌan Jesús, ni̱ ganꞌanj ruhua ni sij. Ngaa ni̱ gunánj daranꞌ ni sij rian huaj síꞌ. Ni̱ gaꞌmi ni sij nga̱ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ngaa ni̱ nachínj snanꞌanj Jesús ni sij. Ni̱ gataj síꞌ: ―Da̱j hua nuguanꞌ gani dugüiꞌ ni é re̱ꞌ nga̱ ni tsínj da únj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ni̱ ꞌngo̱ ni tsínj mán yuꞌuj daj gataj: ―Maestro, nicā daꞌníj snoꞌōj ꞌnāj rián re̱ꞌ xiꞌí si nu̱n nane̱ xi̱ꞌi chruhua cúj niman sij. Ni̱ naꞌue ga̱ꞌmi sij mánj. ");
INSERT INTO trq_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ni̱ niaj diꞌyaj daꞌa nane̱ xi̱ꞌi sij, ni̱ natúj nane̱ xi̱ꞌi sij rian yoꞌój. Ni̱ ahui yatanꞌ duꞌua sij. Ni̱ xa ruj sij yanꞌ sij. Ni̱ ꞌngo̱ yu̱n guinichre ni̱nꞌ sij nej aj. Ni̱ gaꞌmī rian ni tsínj nicóꞌ re̱ꞌ sisi̱ gui̱ri ni sij nane̱ xi̱ꞌi daj. Sani̱ nun gu̱nucuaj ni sij guiri ni sij mánj. ―Daj gataj tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ngaa ni̱ gataj Jesús: ―Naꞌue gu̱xuman ruhua á re̱ꞌ huin ín re̱ꞌ ni tsínj ma̱n yya̱j. Naꞌue gu̱nucuā ga̱ne ni̱gān nga̱ á re̱ꞌ mánj. Ni̱ naꞌue gu̱nucuā si-chrej a ni é re̱ꞌ ni̱ganj mánj. Ni̱caj á re̱ꞌ sij ga̱ꞌnaꞌ ni é re̱ꞌ riānj anj. ―Gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ngaa ni̱ nicaj ni sij tsinꞌ daj guisíj ni sij rian Jesús. Ni̱ ngaa guiniꞌi nane̱ xi̱ꞌi daj manꞌan Jesús, ngaa ni guidaꞌa xiꞌi̱ yacuij manꞌan tsinꞌ daj. Ni̱ naxiruꞌ sij rian yoꞌój, guiꞌyaj nane̱ xi̱ꞌi daj. Ni̱ narumi sij na̱nj, ni̱ narumi sij na̱nj. Ni̱ ahui yatanꞌ duꞌua sij aj. ");
INSERT INTO trq_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ngaa ni̱ nachínj snanꞌanj Jesús chrej tsinꞌ daj. Ni̱ gataj sij: ―Ni̱ u̱ndaj güi huin si ranꞌ daꞌníj re̱ꞌ nan únj. ―Daj gataj Jesús. Ni̱ gataj chrej sij: ―Asi̱j hua le nánj. ");
INSERT INTO trq_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ni̱ naruhuaꞌ natúj sij rian yanꞌa̱n nga̱ rian nnee nej, ꞌyaj nane̱ xi̱ꞌi xiꞌí si ruhua nane̱ xi̱ꞌi da̱gahuij. Hué dan ni̱ sisi̱ ga̱ꞌue gui̱ꞌyaj manꞌán re̱ꞌ ꞌngo̱ si sa̱ꞌ hua, ngaa ni̱ na̱huin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ, ni̱ chra̱cuij re̱ꞌ ni únj anj. ―Daj gataj sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ngaa ni̱ gataj Jesús: ―Sa̱ꞌ sisi̱ ga̱ꞌue gu̱xuman ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ Yanꞌanj. Daj si ga̱ꞌue gui̱ꞌyaj Yanꞌanj daranꞌanj nga̱ ꞌngo̱ tsínj xuman ruhua niꞌyaj manꞌan Yanꞌanj anj. ―Daj gataj Jesús gunun sij. ");
INSERT INTO trq_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ngaa ni̱ ꞌngo̱ hora gaguáj chrej tsinꞌ daj. Ni̱ gataj sij: ―Xuman ruhuāj niꞌyā Yanꞌanj anj. Chra̱cuij re̱ꞌ manꞌānj gu̱xuman ruhuāj doj aj. ―Daj gataj sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ni̱ ngaa guiniꞌi Jesús sisi̱ unánj ni ngüi̱ nahuin yuꞌ ni sij rian niquinꞌ síꞌ, ngaa ni̱ gaꞌmi huee sij rian nane̱ xi̱ꞌi daj. Ni̱ gataj sij: ―Soꞌo ni ngüi̱, ni̱ huin ráꞌyanj ni sij, ꞌyáj re̱ꞌ huín re̱ꞌ nane̱ xi̱ꞌi. Manꞌānj aꞌninꞌ sun rián so̱ꞌ sisi̱ ga̱hui so̱ꞌ du̱naj so̱ꞌ tsinꞌ nan anj. Ni̱ si̱ gatuj ru̱huaꞌ yún so̱ꞌ chruhua niman tsinꞌ nan ga̱ mánj. ―Daj gataj Jesús gunun nane̱ xi̱ꞌi daj. ");
INSERT INTO trq_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Hué dan ni̱ gaguáj nane̱ xi̱ꞌi daj. Ni̱ guidaꞌa ru̱huaꞌ yún xiꞌi̱ yacuij tsinꞌ daj, guiꞌyaj nane̱ xi̱ꞌi daj. Hué dan ni̱ gahui nane̱ xi̱ꞌi tsinꞌ snoꞌo daj. Ni̱ ngaj sij rúnꞌ huin ꞌngo̱ níman huin sij ngaj sij aj. Ni̱ gataj ni ngüi̱ sisi̱ hua yya gahuiꞌ sij aj. ");
INSERT INTO trq_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sani̱ guidaꞌa Jesús raꞌa tsinꞌ daj. Ni̱ nachi nicaj síꞌ sij. Ni̱ nachica sij aj. ");
INSERT INTO trq_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ngaa ni̱ ngaa gatúj Jesús chruhua hueꞌ, ni̱ ngaa nne urin Jesús, ni̱ nachínj snanꞌanj ni tsínj nicoꞌ sij manꞌan sij. Ni̱ gataj ni sij: ―Ni̱ u̱n sin huin ni̱ nun gunucuaj únj guiri únj nane̱ xi̱ꞌi da únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ngaa ni̱ gataj Jesús: ―Si̱ gaꞌue gui̱ꞌyaj néꞌ ga̱hui ni nane̱ xi̱ꞌi nan niman ni ngüi̱ sisi̱ nun achínj jniꞌyaj néꞌ rian Yanꞌanj. Sani̱ sisi̱ achínj jniꞌyaj néꞌ rian Yanꞌanj, ni̱ gui̱ꞌyaj néꞌ ayuno, ngaa ni̱ ga̱ꞌue aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ngaa ni̱ gahui Jesús nga̱ ni tsínj nicoꞌ sij yuꞌuj daj. Ni̱ gachin ni sij estado Galilea. Ni̱ naꞌuej ruhua Jesús sisi̱ gui̱niꞌi ni ngüi̱ ne̱ꞌ huaj sij. ");
INSERT INTO trq_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Daj si digyán sij rian ni tsínj nicoꞌ sij. Ni̱ gataj sij gunun ni síꞌ: ―Na̱gaꞌuiꞌ ꞌngo̱ tsínj daj manꞌānj raꞌa ni tsínj huīnj daꞌníj ni ngüi̱. Ni̱ da̱gahuiꞌ ni sij manꞌānj. Sani̱ xiráj hua̱ꞌnij güi, ni̱ ga̱naꞌnī nánj. ―Gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Sani̱ nun gara daꞌngaꞌ ruhua ni sij si gataj síꞌ. Ni̱ xuꞌuiꞌ ni sij ga̱chinj snanꞌanj ni sij manꞌan síꞌ xiꞌí nuguanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ngaa ni̱ guisíj Jesús xumanꞌ gu̱ꞌnaj Capernaum. Hué dan ni̱ ngaa nne sij chruhua hueꞌ, ngaa ni̱ nachínj snanꞌanj sij ni tsínj nicoꞌ sij. Ni̱ gataj sij: ―Da̱j hua nuguanꞌ aꞌmi ni é re̱ꞌ ngaa huaj ni é re̱ꞌ chrej ununꞌ ni é re̱ꞌ scuaꞌa únj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Sani̱ dínj ganiquinꞌ duꞌua ni sij. Daj si gununꞌ ni sij huaj ni sij chrej sisi̱ da̱j hua tsínj huin achij scanij ni sij, ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Hué dan ni̱ ganꞌanj ga̱ne Jesús, ni̱ gaquínj sij ga̱ꞌnaꞌ ni xu̱huij tsínj nicoꞌ sij. Ni̱ gataj sij: ―Sisi̱ hua ꞌngo̱ a ni é re̱ꞌ huin ruhua ga̱huin achij, ngaa ni̱ gui̱nicoꞌ sij ne̱ꞌ ru̱cu. Ni̱ ga̱huin sij si-moso ni dugüiꞌ sij aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ngaa ni̱ nicaj Jesús ꞌngo̱ tsinꞌ gani sij dani ni sij. Ni̱ ganiꞌyan sij xicój lij daj. Ni̱ gataj sij: ");
INSERT INTO trq_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Ni̱ u̱n tsínj na̱huin raꞌa ꞌngo̱ tsinꞌ nan xiꞌí si nicaj dugüiꞌ sij ngāj, ngaa ni̱ na̱huin raꞌa sij manꞌānj nej. Ni̱ tsínj na̱huin raꞌa manꞌānj, ni̱ sé si na̱huin raꞌa sij manꞌānj, sani̱ na̱huin raꞌa sij tsínj gaꞌníj ga̱ꞌnāj nej aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ngaa ni̱ gataj Juan gunun Jesús: ―Maestro, guiniꞌi ni únj ꞌngo̱ tsínj aꞌmi si-xugüi manꞌán re̱ꞌ. Ni̱ xiꞌí da ri sij nane̱ xi̱ꞌi chruhua niman ni ngüi̱. Sani̱ nitaj si chéj sij nga̱ únj. Ngaa ni̱ xiꞌí daj ni̱ nun ga̱ꞌuej únj sisi̱ gui̱ꞌyaj sij daj. ―Daj gataj Juan gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ngaa ni̱ gataj Jesús: ―Ga̱ꞌninꞌ ruhua ni é re̱ꞌ sisi̱ da̱j gui̱ꞌyaj tsínj daj. Daj si sisi̱ gui̱ꞌyaj ꞌngo̱ tsínj daj ꞌngo̱ si sa̱ꞌ xiꞌí si-xugüīj, ngaa ni̱ si̱ gaꞌue nanica̱j sij ga̱ꞌmi quij sij xiꞌīj mánj. ");
INSERT INTO trq_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Daj si tsínj nitaj si ununꞌ ngo̱ꞌ, ni̱ chracuij sij yu̱nꞌ anj. ");
INSERT INTO trq_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Daj si u̱n tsínj ga̱huin ri̱qui ꞌngo̱ tasa nnee go̱ꞌo ni é re̱ꞌ xiꞌí si nicoꞌ ni é re̱ꞌ manꞌānj, ngaa ni̱ ga̱taj yyāj rian án re̱ꞌ sisi̱ na̱ruꞌue Yanꞌanj rian tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Ni sisi̱ xuman ruhua ꞌngo̱ tsinꞌ nan niꞌyaj sij yūnj, ngaa ni̱ niqui ni̱nꞌ ruhua niman ꞌngo̱ tsínj daj sisi̱ di̱gyán sij gui̱ꞌyaj ꞌngo̱ tsinꞌ nan gaquinꞌ nánj. Sa̱ꞌ huin sisi̱ nu̱mi ni sij ꞌngo̱ to xxi xá tsínj daj, ngaa ni̱ ga̱ꞌnij ni sij ga̱nꞌanj síꞌ chruhua nnee yanꞌanj, gui̱ꞌyaj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","’Ni̱ sisi̱ gui̱ꞌyaj ꞌngo̱ a ni é re̱ꞌ ꞌngo̱ gaquinꞌ, guiꞌyaj raꞌá re̱ꞌ, ngaa ni̱ ga̱ꞌninꞌ re̱ꞌ raꞌá re̱ꞌ daj. Sa̱ꞌ huin ga̱ gundu raꞌá re̱ꞌ ga̱tu re̱ꞌ rian ga̱ne ni̱ganj re̱ꞌ nga̱ Yanꞌanj sisi̱ hui̱j raꞌá re̱ꞌ, sani̱ ga̱nꞌanj re̱ꞌ rian yanꞌa̱n. ");
INSERT INTO trq_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ni̱ yuꞌuj daj nitaj si huaj ga̱huiꞌ xilúj xa ni ngüi̱ mán rian yanꞌa̱n da mánj. Ni̱ daj nga̱ yanꞌa̱n daj nitaj si huaj gui̱naꞌa mánj. ");
INSERT INTO trq_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","’Ni̱ sisi̱ gui̱ꞌyaj ꞌngo̱ a ni é re̱ꞌ ꞌngo̱ gaquinꞌ, gui̱ꞌyaj dacój re̱ꞌ, ngaa ni̱ ga̱ꞌninꞌ re̱ꞌ nánj. Sa̱ꞌ huin ga̱ gundu dacój re̱ꞌ ga̱tu re̱ꞌ rian ga̱ne ni̱ganj re̱ꞌ nga̱ Yanꞌanj sisi̱ ga̱ hui̱j dacój re̱ꞌ, sani̱ ga̱ꞌnij ni sij manꞌán re̱ꞌ rian yanꞌa̱n anj. ");
INSERT INTO trq_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ni̱ yuꞌuj daj nitaj si huaj ga̱huiꞌ xilúj xa ni ngüi̱ mán rian yanꞌa̱n da mánj. Ni̱ daj nga̱ yanꞌa̱n daj nitaj si huaj gui̱naꞌa mánj. ");
INSERT INTO trq_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","’Ni̱ sisi̱ gui̱ꞌyáj re̱ꞌ gaquinꞌ, gui̱ꞌyaj rundij rián re̱ꞌ, ngaa ni̱ gui̱ri re̱ꞌ nánj. Daj si urin rián re̱ꞌ ga̱tu re̱ꞌ rian ga̱ne ni̱ganj re̱ꞌ nga̱ Yanꞌanj sisi̱ hui̱j rundij rián re̱ꞌ, sani̱ ga̱ꞌnij ni sij manꞌán re̱ꞌ rian yanꞌa̱n aca ni̱ganj anj. ");
INSERT INTO trq_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ni̱ yuꞌuj daj nitaj si huaj ga̱huiꞌ xilúj xa ni ngüi̱ mán rian yanꞌa̱n da mánj. Ni̱ daj nga̱ yanꞌa̱n daj nitaj si huaj gui̱naꞌa mánj. ");
INSERT INTO trq_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Ni̱ gui̱ranꞌ daranꞌ ni ngüi̱ sayun, gui̱ꞌyaj Yanꞌanj. Ni̱ da̱j rúnꞌ nu̱n sa̱ꞌ nnee̱ ꞌngo̱ xucu nagaꞌuiꞌ ni sij rian Yanꞌanj ꞌyaj ya̱n, ni̱ daꞌngaꞌ daj ga̱huin sa̱ꞌ ni ngüi̱ ma̱n chruhua xungüi̱ nan, gui̱ꞌyaj Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","’Sa̱ꞌ huin ya̱n. Sani̱ sisi̱ nitaj si ꞌni̱nꞌ mán ga̱ mánj, sani̱ si̱ gaꞌue gui̱ꞌyóꞌ sisi̱ ga̱ ꞌni̱nꞌ ru̱huaꞌ yún ya̱n da mánj. Ngaa ni̱ da̱j rúnꞌ xa xa̱nꞌ chra ꞌyaj ya̱n, ni̱ daꞌngaꞌ daj gui̱ꞌyaj ni é re̱ꞌ. Ni̱ ga̱ dinꞌinj ruhua ni é re̱ꞌ nga̱ ni dugüiꞌ a ni é re̱ꞌ. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ngaa ni̱ gahui Jesús yuꞌuj daj ganꞌanj sij da anéj duꞌua xinéj nnee gu̱ꞌnaj Jordán huin estado Judea. Ngaa ni̱ nahuin yuꞌ ni ngüi̱ mán ni síꞌ rian Jesús. Ni̱ digyán ru̱huaꞌ yún sij rian ni síꞌ da̱j rúnꞌ uꞌyun sij ꞌyaj sij. ");
INSERT INTO trq_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ngaa ni̱ gaꞌna̱ꞌ ni tsínj fariseo rian Jesús. Ni̱ nachínj snanꞌanj ni sij síꞌ. Ni̱ gataj ni sij sisi̱ ga̱ꞌue si-ley Yanꞌanj sisi̱ du̱nóꞌ nicoꞌ. Ni̱ hué daj nachínj snanꞌanj ni sij xiꞌí si huin ruhua ni sij ga̱ꞌuiꞌ ni sij gaquinꞌ xiráj Jesús xiꞌí nuguanꞌ ga̱ꞌmi síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ngaa ni̱ gataj Jesús: ―Da̱j gaꞌninꞌ Moisés sun rian ni é re̱ꞌ únj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ngaa ni̱ gataj ni sij gunun síꞌ: ―Riqui Moisés permiso sisi̱ ga̱ꞌue gui̱ꞌyaj néꞌ yanj ata ga̱ꞌuiꞌ néꞌ nica̱ néꞌ, ngaa ni̱ ga̱ꞌue du̱naj néꞌ nica̱ néꞌ aj. ―Daj gataj ni sij aj. ");
INSERT INTO trq_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ngaa ni̱ gataj Jesús: ―Garun Moisés nuguanꞌ daj xiꞌí si soꞌo ni é re̱ꞌ nga̱ niman án re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Sani̱ ngaa sini ya̱n ngaa guiꞌyaj Yanꞌanj xungüi̱ nan, ni̱: “Guiꞌyaj Yanꞌanj tsínj snoꞌo nga̱ yunꞌunj xa̱na.” ");
INSERT INTO trq_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Xiꞌí daj ni̱ du̱naj ꞌngo̱ tsínj daj chrej sij nga̱ nni sij. Ngaa ni̱ ga̱ne nu̱guanꞌan sij nga̱ nica̱ sij aj. ");
INSERT INTO trq_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ni̱ nu̱ngüej nica̱ tsínj daj ga̱huin urin ngüi̱ aj. Ngaa ni̱ sé hui̱j nnee̱ cúj huin nu̱ngüej sij ga̱ mánj. Sani̱ urin nnee̱ cúj huin nu̱ngüej sij aj. ");
INSERT INTO trq_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ngaa ni̱ ngaa xa̱caj dugüiꞌ ꞌngo̱ tsínj daj nga̱ ꞌngo̱ yunꞌunj daj, gui̱ꞌyaj Yanꞌanj, ngaa ni̱ si̱ gaꞌue ga̱huin ni̱ni nu̱ngüej sij, gui̱ꞌyaj ni ngüi̱ mánj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ni̱ ngaa mán ni sij hueꞌ, ngaa ni̱ nachínj snanꞌanj ni tsínj nicoꞌ Jesús manꞌan síꞌ xiꞌí nuguanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ngaa ni̱ gataj Jesús: ―Tsínj gue̱reꞌe nica̱ daj, ni̱ ga̱nacaj sij ango ngüi̱, ni̱ daꞌui sij gaquinꞌ rian nica̱ sij yunꞌunj xa̱na xacaj sini sij daj. ");
INSERT INTO trq_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ni̱ sisi̱ yunꞌunj xa̱na daj gue̱reꞌe nica̱ únꞌ, ni̱ ga̱nacaj únꞌ ango tsínj, ni̱ ꞌyaj únꞌ gaquinꞌ nej aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ngaa ni̱ nicaj ni yunꞌunj xa̱na ni tsinꞌ le gaꞌna̱ꞌ ne rian Jesús sisi̱ gu̱taꞌ sij raꞌa sij. Sani̱ chranꞌ ni tsínj nicoꞌ Jesús ni yunꞌunj xa̱na nicaj gaꞌna̱ꞌ da aj. ");
INSERT INTO trq_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ni̱ ngaa guiniꞌi Jesús, ni̱ chranꞌ sij, ni̱ gataj sij: ―Raꞌa ni é re̱ꞌ si ga̱ꞌnaꞌ ni tsinꞌ riānj. Ni̱ si̱ chranꞌ ni é re̱ꞌ si gaꞌna̱ꞌ ne riānj mánj. Daj si rúnꞌ huin ni tsinꞌ le nan, ni̱ daꞌngaꞌ daj huin ni ngüi̱ ma̱n rian nicaj sun Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ni̱ xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ da̱j rúnꞌ ráꞌyanj xuman ruhua ni le daꞌngaꞌ da gui̱ꞌyaj ni é re̱ꞌ ráꞌyanj gu̱xuman ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ Yanꞌanj anj. Ni̱ sisi̱ sé daj gui̱ꞌyaj á re̱ꞌ, ngaa ni̱ si̱ gaꞌue ga̱tu ni é re̱ꞌ rian nicaj sun Yanꞌanj mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ngaa ni̱ ganan sij ni tsinꞌ daj. Ni̱ gutaꞌ sij raꞌa sij rian ni tsinꞌ. Ni̱ gachínj jniꞌyaj sij rian Yanꞌanj xiꞌí ni tsinꞌ daj. ");
INSERT INTO trq_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ni̱ ngaa gahui Jesús gachéj sij chrej, ngaa ni̱ gunánj ꞌngo̱ tsínj daj guisíj síꞌ rian Jesús. Ni̱ ganiquinꞌ ráj da̱coj síꞌ ne̱ꞌ rian Jesús. Ni̱ nachínj snanꞌanj síꞌ Jesús. Ni̱ gataj síꞌ: ―Maestro sa̱ꞌ, u̱n sun gui̱ꞌyaj sūnj, ni̱ ga̱ne ni̱gān, ruhuá re̱ꞌ únj. ―Daj gataj síꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ngaa ni̱ gataj Jesús: ―Ni̱ u̱n sin huin ni̱ atáj re̱ꞌ sisi̱ sa̱ꞌ manꞌānj únj. Urin Yanꞌanj huin si sa̱ꞌ nánj. ");
INSERT INTO trq_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Hua niꞌí re̱ꞌ ni nuguanꞌ aꞌninꞌ Yanꞌanj sun riunꞌ: “Si̱ gaꞌmí re̱ꞌ nga̱ nica̱ dugüíꞌ re̱ꞌ mánj. Ni̱ si̱ dagahuíꞌ re̱ꞌ níman mánj. Ni̱ si̱ guiꞌyaj tu̱ re̱ꞌ mánj. Ni̱ si̱ gaꞌmí re̱ꞌ nuguanꞌ nne̱ xiꞌí dugüíꞌ re̱ꞌ mánj. Ni̱ si̱ digyaꞌ yunꞌúnj re̱ꞌ dugüíꞌ re̱ꞌ xiꞌí sanꞌanj mánj. Ni̱ gui̱nun yanꞌánj re̱ꞌ chréj re̱ꞌ nga̱ nní re̱ꞌ aj.” ―Daj gataj Jesús gunun tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ngaa ni̱ gataj tsínj daj: ―Maestro, daranꞌ ni nuguanꞌ daj ráj xināj asi̱j hua lē aj. ―Daj gataj sij aj. ");
INSERT INTO trq_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Hué dan ni̱ niꞌyaj Jesús rian sij. Ni̱ nahuin ꞌi̱ ruhua síꞌ niꞌyaj síꞌ sij. Ni̱ gataj síꞌ: ―Achin urin rasu̱n gui̱ꞌyáj re̱ꞌ. Güi̱j na̱nꞌ re̱ꞌ gu̱duꞌue re̱ꞌ daranꞌ ni siꞌyáj re̱ꞌ. Ni̱ sanꞌanj gui̱riꞌ re̱ꞌ daj ga̱ꞌuiꞌ re̱ꞌ rian ni ngüi̱ niqui aj. Hué dan ni̱ gui̱man nico siꞌyáj re̱ꞌ xataꞌ, gui̱ꞌyaj Yanꞌanj. Ngaa ni̱ ga̱ꞌnaꞌ re̱ꞌ gui̱nicoꞌ re̱ꞌ yūnj anj. ―Daj gataj Jesús gunun tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ngaa ni̱ ducu gahuin ruhua tsínj daj gunun sij si gataj Jesús. Hué dan ni̱ ganꞌanj sij nani ruhua sij. Daj si hua nico siꞌyaj sij. ");
INSERT INTO trq_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ngaa ni̱ niꞌyaj Jesús xiꞌníj sij. Ni̱ gataj sij gunun ni tsínj nicoꞌ sij: ―Ni̱ ꞌi̱ huaj ga̱tu ꞌngo̱ tsínj xuruꞌue rian nicaj sun Yanꞌanj anj. ―Daj gataj Jesús aj. ");
INSERT INTO trq_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ngaa ni̱ ganꞌanj ruhua ni tsínj nicoꞌ Jesús xiꞌí nuguanꞌ gataj síꞌ. Sani̱ gataj ru̱huaꞌ yún Jesús gunun ni sij: ―Jnánj néꞌ, ni̱ ꞌi̱ huaj ga̱tu ꞌngo̱ tsínj xuruꞌue rian nicaj sun Yanꞌanj huin tsínj ꞌi̱ ruhua niꞌyaj sanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ni̱ ꞌi̱ huaj doj ga̱tu ꞌngo̱ tsínj xuruꞌue rian nicaj sun Yanꞌanj daj nga̱ si ga̱chin ꞌngo̱ xucu camello yuꞌuj táj cúj nuhua aj. Ni̱ xa̱chij hua xúꞌ da aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ni̱ ngaa gunun ni sij nuguanꞌ daj, ni̱ ducu ganꞌanj ruhua ni sij. Ni̱ nachínj snanꞌanj ni sij ni manꞌan dugüiꞌ ni sij. Ni̱ gataj ni sij: ―Sisi̱ hué daj huin, ni̱ u̱n tsínj ga̱ꞌue na̱caj Yanꞌanj únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ngaa ni niꞌyaj Jesús rian ni sij. Ni̱ gataj síꞌ: ―Si̱ gaꞌue gui̱ꞌyaj ni tsínj nuguanꞌ nan mánj. Sani̱ sé daj huin nga̱ Yanꞌanj mánj. Daj si daranꞌ nuguanꞌ ga̱ꞌue gui̱ꞌyaj Yanꞌanj anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Sani̱ gaxi̱ꞌi gataj Pedro: ―Hua duna únj daranꞌ siꞌyaj únj. Ni̱ nicoꞌ únj manꞌán re̱ꞌ aj. ―Daj gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ngaa ni̱ gataj Jesús: ―Xa̱ngaꞌ atā gunun a ni é re̱ꞌ sisi̱ danéj gahuin ꞌngo̱ tsínj dunáj ducuá sij, jnánj sij nej, xicaꞌuij sij nej, chrej sij nej, nni sij nej, nica̱ sij nej, daꞌníj sij nej, doꞌój sij nej, ni̱ sisi̱ dunáj sij daranꞌ nan rian xiꞌīj, ni̱ huin ruhua sij na̱taꞌ sij si-nu̱guanꞌānj rian ni ngüi̱, ");
INSERT INTO trq_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ni̱ xungüi̱ nan na̱huin raꞌa sij ꞌngo̱ ciento verta hueꞌ na̱huin raꞌa sij nga̱ jnánj sij nej, xigaꞌuij sij nej, nni sij nej, chrej sij nej, daꞌníj sij nej, doꞌój sij nej. Sani̱ gui̱ranꞌ sij sayun gui̱ꞌyaj ni ngüi̱ nun huin xa̱nꞌ ruhua niꞌyaj si-nu̱guanꞌānj. Ni̱ ango xungüi̱ ga̱ꞌnaꞌ, ni̱ ga̱ne ni̱ganj sij nga̱ Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Sani̱ nico ni ngüi̱ huin achij chruhua xungüi̱ nan, ni̱ na̱nicoꞌ ni sij ne̱ꞌ ru̱cu ango xungüi̱ ga̱ꞌnaꞌ aj. Ni̱ nico ni ngüi̱ nicoꞌ ne̱ꞌ ru̱cu chruhua xungüi̱ nan, ni̱ ga̱huin achij ni sij ango xungüi̱ ga̱ꞌnaꞌ aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ni̱ achéj ni sij huaj ni sij ahui ni sij xumanꞌ Jerusalén. Ni̱ ta̱j dian Jesús rian ni sij. Ni̱ garáj yanꞌanj ruhua ni tsínj nicoꞌ Jesús. Ni̱ xuꞌuiꞌ ni sij nicoꞌ ru̱cu ni sij síꞌ nej aj. Ngaa ni̱ gaquínj Jesús ni tsínj nicoꞌ sij ga̱ꞌnaꞌ ni̱ni ni sij rian síꞌ. Ni̱ gaxi̱ꞌi síꞌ gataj síꞌ si ga̱huin gui̱ranꞌ síꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ni̱ gataj síꞌ gunun ni sij: ―Hua niꞌi a ni é re̱ꞌ sisi̱ huaj néꞌ gui̱sij néꞌ xumanꞌ Jerusalén. Ni̱ hué yuꞌuj daj gui̱daꞌa ni sij manꞌānj na̱gaꞌuiꞌ ꞌngo̱ tsínj daj manꞌānj rian ni chrej aꞌninꞌ nga̱ rian ni maestro digyán ley rian ni ngüi̱. Ni̱ da̱gaꞌmi dugüiꞌ ni sij sisi̱ da̱gahuiꞌ ni sij manꞌānj huīnj daꞌníj ni ngüi̱. Ngaa ni̱ na̱gaꞌuiꞌ ni sij yūnj rian ni tsínj ꞌna̱ꞌ anéj chrej. ");
INSERT INTO trq_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ni̱ ga̱ꞌmi ducu ni sij xiꞌīj. Ni̱ ga̱raj staꞌnunj ni sij manꞌānj nej. Ni̱ du̱guayun ni sij nneꞌ xiráj aj. Ni̱ da̱gahuiꞌ ni sij manꞌānj nej. Sani̱ xiráj hua̱ꞌnij güi, ni̱ ga̱naꞌnī nánj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ngaa ni̱ gahuin ni̱chrunꞌ nu̱ngüej tsínj gu̱ꞌnaj Jacobo nga̱ Juan rian nne Jesús. Ni̱ nu̱ngüej sij huin daꞌníj Zebedeo. Ni̱ gataj nu̱ngüej sij: ―Maestro, ruhua nu̱ngüej únj sisi̱ gui̱ꞌyáj re̱ꞌ sinduj ga̱chinj nu̱ngüej únj rián re̱ꞌ anj. ―Daj gataj nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ngaa ni̱ nachínj snanꞌanj Jesús ni sij. Ni̱ gataj síꞌ: ―Ni̱ u̱n sin huin ruhua nu̱ngüej é re̱ꞌ sisi̱ gui̱ꞌyā nga̱ nu̱ngüej é re̱ꞌ únj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ni̱ gataj nu̱ngüej sij: ―Ngaa ga̱ne sún re̱ꞌ xataꞌ, ni̱ ga̱huin ꞌueé re̱ꞌ, ngaa ni ri̱qui re̱ꞌ si ga̱ne nu̱ngüej únj ꞌngo̱ únj raꞌa sa̱ꞌ re̱ꞌ, ni̱ ango únj raꞌa ro̱tsi re̱ꞌ, ruhua nu̱ngüej únj anj. ―Daj gataj nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ngaa ni̱ gataj Jesús: ―Nun niꞌi nu̱ngüej é re̱ꞌ si achínj nu̱ngüej é re̱ꞌ riānj mánj. Ga̱ꞌue gu̱nucuaj nu̱ngüej é re̱ꞌ gui̱ranꞌ nu̱ngüej é re̱ꞌ sayun da̱j rúnꞌ gui̱ranꞌ manꞌānj níꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ni̱ gataj nu̱ngüej sij: ―Gaꞌue aj. ―Gataj nu̱ngüej sij. Ngaa ni̱ gataj Jesús: ―Xa̱ngaꞌ gui̱ranꞌ nu̱ngüej é re̱ꞌ sayun ngāj aj. ");
INSERT INTO trq_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Sani̱ naꞌue ri̱qui manꞌānj sisi̱ ga̱ne nu̱ngüej é re̱ꞌ ꞌngo̱ é re̱ꞌ raꞌa sa̱ꞌāj, ni̱ ango é re̱ꞌ raꞌa ro̱tsīj mánj. Hua nacui Yanꞌanj nu̱ngüej tsínj ga̱ne nu̱ngüej chrej xiꞌnī anj. ―Daj gataj Jesús aj. ");
INSERT INTO trq_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ni̱ ngaa gunun ango ichiꞌ ni tsínj nicoꞌ Jesús, ni̱ gaꞌman ruhua ni síꞌ niꞌyaj ni síꞌ Jacobo nga̱ Juan. ");
INSERT INTO trq_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Sani̱ gaquínj Jesús ga̱ꞌnaꞌ ni sij. Ni̱ gataj síꞌ: ―Niꞌi ni é re̱ꞌ da̱j ꞌyaj ni tsínj nicaj sun scanij ni tsínj ꞌna̱ꞌ anéj chrej. Ni̱ aranꞌ ruhua ni sij gui̱nicaj sun nico ni sij ga̱huin achij ni sij rian ni ngüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Sani̱ sé daj gui̱ꞌyaj á re̱ꞌ mánj. Ni̱ tsínj ruhua ga̱huin achij scanij a ni é re̱ꞌ, ngaa ni̱ ga̱huin síꞌ si-moso ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ni̱ tsínj ruhua ga̱huin rian scanij ni é re̱ꞌ, ngaa ni̱ ga̱huin sij tsínj ꞌyaj sun rian án re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ni̱ sé si ꞌnāj sisi̱ gui̱ꞌyaj sun ni ngüi̱ riānj ruhuāj huīnj daꞌníj ni ngüi̱. Sani̱ ꞌnāj gui̱ꞌyaj sūnj rian ni ngüi̱ aj. Ni̱ ꞌnāj ga̱huīj na̱ruꞌuē rian si-ga̱quinꞌ nico ni ngüi̱ aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Hué dan ni̱ guisíj ni sij xumanꞌ Jericó. Ngaa ni̱ gahui Jesús nga̱ ni tsínj nicoꞌ sij xumanꞌ daj. Ni̱ nico ni ngüi̱ nicoꞌ huaj nej. Ni̱ duꞌua chrej nne ꞌngo̱ tsínj duri ꞌyaj caridad gu̱ꞌnaj síꞌ Bartimeo daꞌníj Timeo. ");
INSERT INTO trq_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ni̱ ngaa gunun tsínj duri daj sisi̱ hué Jesús Nazareno gachin chrej daj, ngaa ni̱ gaxi̱ꞌi sij gaguáj sij. Ni̱ gataj sij: ―Jesús, daꞌníj David, na̱huin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ yūnj aán. ―Daj gaguáj sij aj. ");
INSERT INTO trq_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ni̱ nico ni ngüi̱ chranꞌ sij sisi̱ dínj ga̱ne duꞌua sij. Sani̱ doj a̱ꞌ ganariꞌ nucuaj sij gaguáj sij. Ni̱ gataj ru̱huaꞌ yún sij: ―Daꞌníj David, na̱huin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ yūnj aán. ―Gataj sij aj. ");
INSERT INTO trq_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ngaa ni̱ ganiqui̱nꞌ Jesús. Ni̱ gataj sij gunun ni tsínj niquinꞌ nga̱ sij: ―Ga̱quinj a ni é re̱ꞌ ga̱ꞌnaꞌ tsínj daj. ―Gataj Jesús. Hué dan ni̱ ganꞌanj ga̱quinj ni sij tsínj duri daj. Ni̱ gataj ni sij: ―Ga̱huin nia̱ꞌ ruhuá re̱ꞌ. Na̱xuman re̱ꞌ gu̱nꞌ si aquínj sij ga̱ꞌnaꞌ re̱ꞌ aj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ngaa ni̱ dugüéj tsínj duri daj reto̱ sij. Ni̱ guéj sij ganꞌanj ni̱chi sij rian Jesús aj. ");
INSERT INTO trq_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ngaa ni̱ nachínj snanꞌanj Jesús sij. Ni̱ gataj síꞌ: ―Ni̱ u̱n sin huin ruhuá re̱ꞌ gui̱ꞌyā nga̱ re̱ꞌ, ruhuá re̱ꞌ únj. ―Daj gataj Jesús. Ngaa ni̱: ―Maestro, huin ruhuāj sisi̱ na̱xiguin riānj, gui̱ꞌyáj re̱ꞌ aj. ―Gataj tsínj duri daj. ");
INSERT INTO trq_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ngaa ni̱ gataj Jesús: ―Ga̱ꞌue ga̱nꞌanj re̱ꞌ nánj. Hua nahuín re̱ꞌ xiꞌí si guxuman ruhuá re̱ꞌ niꞌyáj re̱ꞌ manꞌānj anj. ―Daj gataj Jesús gunun sij aj. Ni̱ ꞌngo̱ hora naxigui̱n rian tsínj duri daj. Ni̱ guinicoꞌ sij Jesús ganꞌanj sij. ");
INSERT INTO trq_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ngaa ni̱ guisíj ni sij nu̱ngüej xumanꞌ gu̱ꞌnaj Betfagé nga̱ Betania rian niquinꞌ ꞌngo̱ dacan gu̱ꞌnaj Olivos. Ni̱ ngaj ni̱chrunꞌ xumanꞌ Jerusalén. Ni̱ gaꞌníj Jesús hui̱j tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ni̱ gataj sij: ―Ga̱nꞌanj nu̱ngüej é re̱ꞌ xumanꞌ ngaj ne̱ꞌ rian do̱j. Ni̱ ngaa huaj ga̱tu nu̱ngüej é re̱ꞌ, ni̱ na̱riꞌ ráꞌyanj nu̱ngüej é re̱ꞌ ꞌngo̱ urruj anumi. Ni̱ a̱ ꞌngo̱ tsínj nitaj si ta̱j mánj. Ni̱ na̱chi nu̱ngüej é re̱ꞌ ni̱caj á re̱ꞌ ga̱ꞌnaꞌ á re̱ꞌ riānj anj. ");
INSERT INTO trq_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ni̱ sisi̱ hua ngüi̱ ga̱nachinj snanꞌanj rian nu̱ngüej é re̱ꞌ u̱n sin ni̱ ꞌyaj á re̱ꞌ daj nga̱ urruj, ngaa ni̱ ga̱taj á re̱ꞌ gu̱nun ni sij: “Manꞌan Señor níꞌyanj xuj aj. Ni̱ hora ni̱ ga̱ꞌnaꞌ ni̱caj yún xuj, gui̱ꞌyaj síꞌ aj”, ga̱taj nu̱ngüej é re̱ꞌ gu̱nun ni sij. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Hué dan ni̱ ganꞌanj nu̱ngüej sij. Ni̱ nariꞌ nu̱ngüej sij xúꞌ hua numi xúꞌ chruhua chrej ga̱nꞌan ni̱chrunꞌ rian ꞌngo̱ hueꞌ. Ngaa ni̱ nachi nu̱ngüej sij xúꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Hué dan ni̱ nachínj snanꞌanj ni tsínj niquinꞌ yuꞌuj daj. Ni̱ gataj ni sij: ―Ni̱ u̱n sin ni̱ ꞌyaj nu̱ngüej é re̱ꞌ daj únj. Ni̱ u̱n sin huin nachi nu̱ngüej é re̱ꞌ urruj únj. ―Gataj ni tsínj daj gunun nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ni̱ gataj nu̱ngüej sij da̱j rúnꞌ gaꞌninꞌ Jesús sun rian nu̱ngüej sij. Ngaa ni̱ gaꞌninꞌ ruhua ni sij si ga̱nꞌanj urruj daj. ");
INSERT INTO trq_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ngaa ni̱ nicaj nu̱ngüej sij urruj gaꞌna̱ꞌ nu̱ngüej sij rian Jesús. Ni̱ gutaꞌ nu̱ngüej sij si-ganꞌ nu̱ngüej sij xiráj urruj. Ngaa ni̱ guitáj Jesús xúꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ni̱ gurúj nico ni ngüi̱ si-ganꞌ ni sij chruhua chrej. Ni̱ gurúj ango ni sij recoj gaꞌninꞌ ni sij riqui quij gurúj ni sij chruhua chrej rian huaj Jesús aj. ");
INSERT INTO trq_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ni̱ ni ngüi̱ huaj ne̱ꞌ rian nej, nga̱ ni ngüi̱ nicoꞌ ne̱ꞌ ru̱cu Jesús aguáj ni sij. Ni̱ gataj ni sij: ―Hua nia̱ꞌ ꞌueé rian tsínj ꞌna̱ꞌ nga̱ si-xugüi manꞌan Señor. ");
INSERT INTO trq_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Hua ꞌueé si-gobierno manꞌan tsínj ga̱huin achij da̱j rúnꞌ gahuin achij xi néꞌ tsínj gu̱ꞌnaj David. Ga̱ sa̱ꞌ ꞌueé xataꞌ aj. ―Daj gaguáj ni ngüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ngaa ni̱ gatúj Jesús chruhua nuhui nico nne xumanꞌ Jerusalén. Ni̱ guiniꞌyaj sij daranꞌ rasu̱n mán. Hué dan ni̱ xiꞌí si guisíj gahuin diꞌni̱, ni̱ ganꞌanj sij xumanꞌ Betania nga̱ xu̱huij ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ni̱ ango güi ngaa gahui ni sij xumanꞌ Betania, ni̱ achin xiꞌna̱ riqui Jesús aj. ");
INSERT INTO trq_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ni̱ guiniꞌi sij niquinꞌ ga̱nꞌ ꞌngo̱ chrun gu̱ꞌnaj higuera. Ni̱ nu̱n coj raꞌa chrun daj. Ni̱ ganꞌanj nichi sij rian niquinꞌ-ínꞌ niꞌyaj sij sisi̱ ayu chruj chra̱-áꞌ. Sani̱ nun nariꞌ sij higo mánj. Maan coj raꞌa-áꞌ guiniꞌi sij si achin gui̱sij güi ga̱yu chruj aj. ");
INSERT INTO trq_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ngaa ni̱ gataj Jesús gunun chrun daj: ―Ni̱ganꞌ si̱ xa ni̱ a̱ ꞌngo̱ ni ngüi̱ chruj ayu chra̱ manꞌán re̱ꞌ mánj. ―Daj gataj Jesús. Ni̱ gunun ni tsínj nicoꞌ sij nuguanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ngaa ni̱ guisíj ni sij xumanꞌ Jerusalén. Ni̱ gatúj Jesús chruhua nuhui nico. Ni̱ gaxi̱ꞌi sij guiri sij ni tsínj mán duꞌuej rasu̱n nga̱ ni tsínj ránj rasu̱n mán chruhua nuhui daj. Ni̱ guru nitu Jesús ni mesa siꞌyaj ni tsínj naduna sanꞌanj nej. Ni̱ guru nitu Jesús ni chrun ruguechraꞌ nne ni tsínj duꞌuej xuꞌma̱n anj. ");
INSERT INTO trq_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ni̱ nun gaꞌuiꞌ sij permiso ga̱ta ni ngüi̱ rasu̱n ga̱chin ni sij chruhua nuhui nico mánj. ");
INSERT INTO trq_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ni̱ gaxi̱ꞌi sij digyán sij rian ni tsínj mán daj. Ni̱ gataj sij: ―Gataj si-nu̱guanꞌ Yanꞌanj: “Ducuāj huin rian ga̱chinj jniꞌyaj daranꞌ ni ngüi̱ ma̱n chruhua xungüi̱ rian Yanꞌanj anj.” Gataj si-nu̱guanꞌ Yanꞌanj. Sani̱ nuhui nan gahuin ꞌngo̱ huej ma̱n ni tsínj tu̱, ꞌyaj á re̱ꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ni̱ gunun ni tsínj digyán si-ley Moisés nga̱ ni chrej aꞌninꞌ si gataj Jesús. Ni̱ gaxi̱ꞌi ni sij da̱j gui̱ꞌyaj ni sij da̱gahuiꞌ ni sij manꞌan síꞌ si xuꞌuiꞌ ni sij niꞌyaj sij síꞌ. Daj si garáj yanꞌanj ruhua daranꞌ ni ngüi̱ nga̱ nuguanꞌ digyán síꞌ rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Sani̱ ngaa guini̱, ni̱ gahui Jesús xumanꞌ daj ganꞌanj sij nga̱ ni tsínj nicoꞌ sij aj. ");
INSERT INTO trq_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ni̱ ni̱ganꞌ ango güi, ni̱ gachin ni̱chrunꞌ ni sij rian niquinꞌ chrun higuera daj. Ni̱ guiniꞌi ni sij sisi̱ ꞌngo̱ ganaco̱ yaꞌa̱ siu̱ chrun da aj. ");
INSERT INTO trq_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Hué dan ni̱ gananun ruhua Pedro nuguanꞌ gataj Jesús xiꞌí chrun daj. Ni̱ gataj sij gunun Jesús: ―Maestro, ni̱ꞌyaj re̱ꞌ rian chrun gaꞌmi quíj re̱ꞌ nan, ni̱ nacoj nánj. ―Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ngaa ni̱ gataj Jesús: ―Gu̱xuman ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","’Xa̱ngaꞌ ataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ u̱n tsínj ga̱huin ga̱taj gu̱nun quij nan: “Gu̱xun re̱ꞌ yuꞌuj daj, ni̱ ga̱ꞌnij re̱ꞌ manꞌán re̱ꞌ chruhua nnee yanꞌanj anj.” Ni̱ sisi̱ nitaj si xíj ruhua tsínj daj sisi̱ ga̱chin yya ni̱nꞌ quij daj, gui̱ꞌyaj Yanꞌanj, ngaa ni̱ xa̱ngaꞌ gui̱ꞌyaj Yanꞌanj si gataj tsínj da aj. ");
INSERT INTO trq_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Hué daj ni̱ atā gu̱nun a ni é re̱ꞌ sisi̱ ga̱chinj jniꞌyaj ni é re̱ꞌ ꞌngo̱ nuguanꞌ rian Yanꞌanj, ni̱ gu̱xuman ni̱nꞌ ruhua á re̱ꞌ sisi̱ hua guiriꞌ ni é re̱ꞌ nuguanꞌ daj, ni̱ xa̱ngaꞌ ga̱huin da̱j rúnꞌ gachínj jniꞌyaj ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ni̱ ngaa achínj jniꞌyaj á re̱ꞌ rian Yanꞌanj, ni̱ sisi̱ guiꞌyaj ꞌngo̱ dugüíꞌ re̱ꞌ gaquinꞌ rián re̱ꞌ, ni̱ gui̱nicaj á re̱ꞌ niman nico xiꞌí dugüíꞌ re̱ꞌ daj. Ngaa ni̱ ga̱ꞌue gui̱nicaj Yanꞌanj niman nico xiꞌí si-ga̱quinꞌ ni manꞌán re̱ꞌ nej nánj. ");
INSERT INTO trq_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Sani̱ sisi̱ si̱ gaꞌuej ruhua á re̱ꞌ gui̱nicaj á re̱ꞌ niman nico xiꞌí gaquinꞌ guiꞌyaj dugüíꞌ re̱ꞌ rián re̱ꞌ, ngaa ni̱ si̱ gaꞌue gui̱nicaj Yanꞌanj ꞌngo̱ niman nico xiꞌí si-ga̱quinꞌ a ni é re̱ꞌ nej mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ngaa síj ni̱ nanica̱j ni sij xumanꞌ Jerusalén. Ni̱ ngaa chéj Jesús chruhua nuhui, ni̱ gaꞌna̱ꞌ nichi ni chrej aꞌninꞌ nga̱ ni maestro digyán si-ley Moisés nej, ni tsínj huin achij nej. ");
INSERT INTO trq_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ni̱ nachínj snanꞌanj ni sij Jesús. Ni̱ gataj ni sij: ―Ni̱ u̱n sin huin sun, ni̱ ꞌyáj re̱ꞌ nan únj. Ni̱ u̱n tsínj riqui sun, ni̱ ꞌyáj re̱ꞌ nan únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ngaa ni̱ gataj Jesús: ―Ruhuāj ga̱nachinj snanꞌān ꞌngo̱ nuguanꞌ da manꞌan án re̱ꞌ aj. Ni̱ sisi̱ da̱nicaj á re̱ꞌ nuguanꞌ daj riānj, ni̱ ga̱tā u̱n sun guiꞌyā nan gu̱nun a ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ngaa ni̱ u̱n tsínj gaꞌninꞌ sun rian tsínj gu̱ꞌnaj Juan sisi̱ ga̱taꞌ nnee síꞌ ni ngüi̱ únj. Yanꞌanj gataj rian sij níꞌ. Asi̱ hua ango tsínj gataj rian sij sa̱ꞌ. Ga̱taj a ni é re̱ꞌ ꞌngo̱ nuguanꞌ riānj anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ngaa ni̱ gani guitsi ruhua ni dugüiꞌ ni sij nga̱ nuguanꞌ daj. Ni̱ gataj ni sij gunun dugüiꞌ ni sij: ―Sisi̱ ga̱toꞌ sisi̱ gaꞌninꞌ Yanꞌanj sun rian Juan, ngaa ni̱ ga̱taj Jesús gu̱nun néꞌ: “Ni̱ u̱n sin huin nun gu̱xuman ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ manꞌan sij únj”, ga̱taj síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ni̱ si̱ gaꞌue ga̱toꞌ sisi̱ gaꞌníj ni tsínj gaꞌna̱ꞌ sij mánj. ―Daj gataj ni sij xiꞌí si xuꞌuiꞌ ni sij niꞌyaj ni sij ni ngüi̱ aj. Daj si gani ruhua daranꞌ ni ngüi̱ sisi̱ Juan gahuin xa̱ngaꞌ ꞌngo̱ tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ngaa ni̱ gataj ni sij gunun Jesús: ―Nun niꞌi únj mánj. ―Daj gataj ni tsínj aꞌninꞌ daj. Ngaa ni̱ gataj Jesús: ―Hué dan ni̱ si̱ gatā gunun a ni é re̱ꞌ u̱n tsínj gaꞌninꞌ sun riānj, gui̱ꞌyā da̱j rúnꞌ ꞌyā mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ngaa ni̱ gaxi̱ꞌi Jesús nani sij cuento digyán sij rian ni ngüi̱. Ni̱ gataj sij: ―Ganarij ꞌngo̱ tsínj daj nico coj uva. Ni̱ guiꞌyaj sij ꞌngo̱ xingá ganica̱j rian gunun sij. Ni̱ gánj sij yuꞌuj rian ga̱ni sij chruj uva gui̱ꞌyaj sij vino. Ni̱ guiꞌyaj sij ꞌngo̱ hueꞌ xa̱can xxi sisi̱ du̱gumi ni tsínj du̱gumi daranꞌ ni coj daj. Ngaa ni̱ nagaꞌuiꞌ sij si-coj sij coj chruj uva daj rian ni tsínj sisi̱ du̱gumi ni síꞌ siꞌyaj sij. Ngaa ni̱ ganꞌanj ga̱nꞌ sij ango xumanꞌ. ");
INSERT INTO trq_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ni̱ ngaa guisíj güi gane uva, ngaa ni̱ gaꞌníj sij ꞌngo̱ si-moso sij ga̱nꞌanj ga̱chinj síꞌ rian ni tsínj mán ꞌyaj sun daj chruj si huin siꞌyaj sij. ");
INSERT INTO trq_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Sani̱ guidaꞌa ni tsínj mán ꞌyaj sun daj si-moso sij daj. Ni̱ gaꞌuiꞌ ni sij chrun síꞌ. Ni̱ naꞌníj ni sij na̱nꞌ yu̱n síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Hué dan ni̱ gaꞌníj ru̱huaꞌ yún tsínj daj ango si-moso sij. Sani̱ gaꞌuiꞌ ni sij yej síꞌ. Ni̱ guiranꞌ xi̱ꞌi chra̱ síꞌ. Ni̱ guiꞌyaj quij ni sij nga̱ síꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ngaa ni̱ gaꞌníj ru̱huaꞌ yún tsínj daj ángo si-moso sij. Sani̱ dagahuiꞌ gue̱ manꞌan ni sij síꞌ aj. Ni̱ gaꞌníj sij gaꞌi̱ doj moso ganꞌanj. Ni̱ gaꞌuiꞌ ni tsínj mán ꞌyaj sun daꞌaj ni síꞌ. Ni̱ dagahuiꞌ ni sij ango daꞌaj ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ni̱ gunáj ango rin tsínj rian tsínj do̱ꞌoj daj. Ni̱ tsínj gunáj daj huin daꞌníj sij. Ni̱ ꞌi̱ ruhua sij niꞌyaj sij daꞌníj sij. Ni̱ daꞌ síj daj gaꞌníj sij daꞌníj sij ga̱nꞌanj rian ni tsínj mán ꞌyaj sun daj. Ni̱ gataj sij gunun manꞌan sij: “Ga̱ níꞌyanj ni síꞌ nga̱ manꞌan daꞌnī aj”, ataj sij gunun manꞌan sij. Ngaa ni̱ gaꞌníj sij daꞌníj sij ga̱nꞌanj síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","’Sani̱ gataj ni tsínj ꞌyaj sun daj gunun dugüiꞌ ni sij: “Tsínj nan gu̱nánj doꞌój chrej sij si sa̱ꞌ ga̱huiꞌ chrej sij aj. Da̱gahuiꞌ néꞌ tsínj nan, ngaa ni̱ gu̱nan néꞌ ga̱huin doꞌój néꞌ nánj”, ataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ngaa ni̱ guidaꞌa ni sij dagahuiꞌ ni sij manꞌan síꞌ. Ni̱ guereꞌej ni sij níman daj chrej xe̱ꞌ duꞌua rian ma̱n coj uva da aj. ");
INSERT INTO trq_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’Hué dan ni̱ da̱j gui̱ꞌyaj tsínj do̱ꞌoj, ruhua á re̱ꞌ únj. Ga̱ꞌnaꞌ sij rian ngaj doꞌój sij. Ni̱ da̱gahuiꞌ sij ni tsínj ꞌyaj sun daj. Ngaa ni̱ na̱gaꞌuiꞌ sij coj uva huin si-coj sij rian ango ni tsínj sisi̱ du̱gumi ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ni̱ u̱n sin huin ni̱ nun gaya á re̱ꞌ si gataj si-nu̱guanꞌ Yanꞌanj únj: Yej guereꞌej ni tsínj ꞌyaj sun hueꞌ. Ni̱ ga̱huin-ínꞌ ꞌngo̱ yej sa̱ꞌ doj ga̱ne ran-ánꞌ du̱guꞌnunꞌ squina hueꞌ ni̱ganj ni̱nꞌ anj. ");
INSERT INTO trq_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Hué manꞌan Señor guiꞌyaj nuguanꞌ nan. Ni̱ duguꞌna̱j ni̱nꞌ ruhua hua nuguanꞌ nan, ruhua néꞌ aj. Daj gataj si-nu̱guanꞌ Yanꞌanj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ngaa ni̱ huin ruhua ni sij gui̱daꞌa ni sij manꞌan Jesús. Daj si xacaj ni sij cuenta sisi̱ nuna síꞌ cuento daj xiꞌí ni sij. Sani̱ xuꞌuiꞌ ni sij niꞌi ni sij ni ngüi̱. Ngaa ni̱ gaꞌninꞌ ruhua ni sij, ni̱ ganꞌanj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Hué dan ni̱ gaꞌníj ni sij ga̱nꞌanj do̱j ni tsínj fariseo nga̱ do̱j ni tsínj herodista rian Jesús. Ni̱ huin ruhua ni sij ga̱ꞌuiꞌ ni sij gaquinꞌ xiráj Jesús xiꞌí si-nu̱guanꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ngaa ni̱ gaꞌna̱ꞌ ni sij gataj ni sij gunun manꞌan Jesús: ―Maestro, niꞌi ni únj sisi̱ aꞌmi xa̱ngaꞌ manꞌán re̱ꞌ. Ni̱ nitaj si gui̱ꞌyáj re̱ꞌ u̱n sin huin ni tsínj aꞌmi mánj. Daj si nitaj si niꞌyáj re̱ꞌ da̱j hua ni tsínj mánj. Sani̱ digyán xa̱ngaꞌ re̱ꞌ sisi̱ da̱j gui̱ꞌyaj néꞌ gui̱nicoꞌ néꞌ Yanꞌanj. Ngaa ni̱ sa̱ꞌ huin sisi̱ ga̱ꞌuiꞌ néꞌ pesto aꞌnej rey César, ruhuá re̱ꞌ níꞌ. Ga̱ꞌuiꞌ néꞌ níꞌ. Asi̱ si̱ gaꞌuiꞌ néꞌ sa̱ꞌ. ―Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sani̱ xacaj Jesús cuenta sisi̱ tsínj digyaꞌ yunꞌunj huin ni sij. Ngaa ni̱ gataj síꞌ: ―Ni̱ u̱n sin huin ni̱ ruhua á re̱ꞌ gui̱ꞌyaj á re̱ꞌ xi̱ꞌ ngāj únj. Güi̱j xa̱caj á re̱ꞌ ꞌngo̱ sanꞌanj denario gui̱niꞌyā. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ngaa ni̱ nicaj ni sij sanꞌanj gaꞌna̱ꞌ ni sij digyán ni sij rian Jesús. Ni̱ gataj Jesús: ―Ni̱ u̱n tsínj rian nún rian sanꞌanj nan únj. Ni̱ u̱n tsínj si-xugüi nún rian sanꞌanj nan únj. ―Daj gataj Jesús. Ni̱ gataj ni sij: ―Hué rian rey huin anj. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ngaa ni̱ gataj Jesús: ―Ga̱ꞌuiꞌ a ni é re̱ꞌ siꞌyaj rey César rian sij aj. Ni̱ ga̱ꞌuiꞌ ni é re̱ꞌ siꞌyaj Yanꞌanj rian Yanꞌanj anj. ―Daj gataj Jesús. Ni̱ garáj yanꞌanj ruhua ni sij, guiꞌyaj si-nu̱guanꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hué dan ni̱ guisíj ni tsínj saduceo rian Jesús. Ni̱ ataj ni tsínj daj sisi̱ nitaj si ga̱naꞌnij ni níman mánj. Ni̱ nachínj snanꞌanj ni sij Jesús. Ni̱ gataj ni sij: ");
INSERT INTO trq_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, garun Moisés nuguanꞌ gunun néꞌ. Ni̱ ataj si-nu̱guanꞌ síꞌ sisi̱ ga̱huiꞌ ꞌngo̱ tsínj hua nica̱, ni̱ nitaj daꞌníj sij nga̱ nica̱ sij. Ngaa ni̱ na̱caj jnánj tsínj gahuiꞌ daj nica̱ stanga níman daj. Daꞌngaꞌ daj gui̱ꞌyaj sij ga̱ꞌuiꞌ sij si ga̱ꞌnga lij na̱gane-éꞌ ya̱n duꞌua chrej-éꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ni̱ hua ichij jna̱nj ni tsínj daj. Ni̱ xacaj tsínj xa̱huaꞌ nica̱ sij. Ngaa ni̱ gahuiꞌ sij. Ni̱ nitaj daꞌníj sij nga̱ únꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ni̱ nacaj ango jnánj sij tsínj gaꞌna̱ꞌ rian manꞌan sij nica̱ síꞌ. Ngaa ni̱ gahuiꞌ síꞌ. Ni̱ nitaj daꞌníj nu̱ngüej nica̱ síꞌ nej mánj. Hué daj nan guiranꞌ ango jnánj sij daꞌ guisíj hua̱ꞌnij jna̱nj sij aj. ");
INSERT INTO trq_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ni̱ hué daj guiranꞌ ichij jna̱nj sij. Ni̱ a̱ ꞌngo̱ lij nun gaꞌnga, guiꞌyaj ni sij nga̱ yunꞌunj xa̱na daj. Daꞌ guisíj daj gahuiꞌ manꞌan yunꞌunj daj nej aj. ");
INSERT INTO trq_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Hué dan ni̱ ngaa ga̱naꞌnij ni níman ngaa gui̱man ru̱huaꞌ yún ichij jnánj sij, ni̱ da̱j hua yya tsínj ga̱huin nica̱ yunꞌunj xa̱na daj, ruhuá re̱ꞌ únj. Daj si daranꞌ ni sij xacaj únꞌ nánj. ―Daj gataj ni tsínj saduceo gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ngaa ni̱ gataj Jesús: ―Nun na̱riꞌ ni é re̱ꞌ si nun niꞌi a ni é re̱ꞌ da̱j ataj si-nu̱guanꞌ Yanꞌanj mánj. Ni̱ nun niꞌi a ni é re̱ꞌ da̱j nucuaj Yanꞌanj nej mánj. ");
INSERT INTO trq_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Daj si ngaa ga̱naꞌnij ni níman, ni̱ si̱ xacaj ni tsínj yunꞌunj xa̱na mánj. Ni̱ si̱ xacaj ni yunꞌunj xa̱na tsínj snoꞌo mánj. Daj si da̱j rúnꞌ nne ni ángel xataꞌ, ni̱ daꞌngaꞌ daj ga̱ne ni sij aj. ");
INSERT INTO trq_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ngaa ni̱ ga̱tā gu̱nun a ni é re̱ꞌ da̱j gui̱niꞌi a ni é re̱ꞌ sisi̱ ga̱naꞌnij ni níman. Achin gaya a ni é re̱ꞌ rian si-nu̱guanꞌ Moisés xiꞌí ꞌngo̱ coj níꞌ. Ni̱ gataj Yanꞌanj gunun Moisés: “Huēj huin Danꞌanj tsínj gu̱ꞌnaj Abraham nga̱ tsínj gu̱ꞌnaj Isaac nej, tsínj gu̱ꞌnaj Jacobo nej aj”, daj gataj Yanꞌanj gunun Moisés. ");
INSERT INTO trq_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Hué dan ni̱ sé níman huin ni tsínj guinicoꞌ Yanꞌanj asi̱j ná mánj. Sani̱ hua ni̱ꞌnaꞌ ni sij nánj. Ni̱ nun nariꞌ ni é re̱ꞌ nga̱ nuguanꞌ nan mánj. ―Daj gataj Jesús gunun ni tsínj saduceo daj. ");
INSERT INTO trq_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ni̱ gunun ꞌngo̱ ni tsínj digyán si-ley Moisés sisi̱ danica̱j Jesús ꞌngo̱ nuguanꞌ sa̱ꞌ rian ni sij. Ngaa ni̱ ganꞌanj nichi sij rian Jesús. Ni̱ nachínj snanꞌanj sij síꞌ. Ni̱ gataj sij: ―Ni̱ u̱n nuguanꞌ huin nuguanꞌ nico doj rian daranꞌ nuguanꞌ aꞌninꞌ Yanꞌanj sun riunꞌ únj. ―Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ngaa ni̱ gataj Jesús: ―Nuguanꞌ nico doj rian daranꞌ ango nuguanꞌ huin nan: “Gu̱nun a ni é re̱ꞌ ni tsínj israelita. Señor huin Danꞌanj néꞌ huin urin Yanꞌanj nánj. ");
INSERT INTO trq_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ni̱ ga̱huin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ Señor huin Danꞌánj re̱ꞌ nga̱ ni̱nꞌ nimán re̱ꞌ nej, ni̱nꞌ staꞌngáꞌ re̱ꞌ nej, ni̱nꞌ si-fuerzá re̱ꞌ nej.” Hué nan huin nuguanꞌ huin achij yya aj. ");
INSERT INTO trq_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ni̱ hua ango nuguanꞌ aꞌninꞌ Yanꞌanj sun rián re̱ꞌ nej: “Ga̱huin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ ni dugüíꞌ re̱ꞌ da̱j rúnꞌ ꞌi̱ ruhuá re̱ꞌ niꞌyáj re̱ꞌ manꞌán re̱ꞌ aj.” Nitaj ango nuguanꞌ nico doj rian nu̱ngüej nuguanꞌ nan mánj. ―Gataj Jesús gunun tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ngaa ni̱ gataj tsínj digyán si-ley Moisés daj: ―Duguꞌna̱j atáj re̱ꞌ Maestro. Xa̱ngaꞌ huin si atáj re̱ꞌ sisi̱ hua urin Yanꞌanj. Ni̱ nitaj ango Yanꞌanj hua ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ni̱ sisi̱ ga̱huin ꞌi̱ ruhua néꞌ ni̱ꞌyaj néꞌ Yanꞌanj nga̱ ni̱nꞌ niman néꞌ nej, ni̱nꞌ staꞌngaꞌ néꞌ nej, ni̱nꞌ si-fuerza néꞌ nej, ni̱ sisi̱ ga̱huin ꞌi̱ ruhua néꞌ ni̱ꞌyaj néꞌ ni dugüiꞌ néꞌ da̱j rúnꞌ ꞌi̱ ruhua néꞌ niꞌyaj néꞌ manꞌan néꞌ, ni̱ sa̱ꞌ doj huin nu̱ngüej nuguanꞌ nan daj nga̱ si ga̱ꞌuiꞌ néꞌ gaꞌi̱ ni xucu gahuiꞌ rian Yanꞌanj nga̱ xucu ga̱ca ni̱nꞌ nej aj. ―Daj gataj tsínj digyán ley daj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ni̱ ngaa guiniꞌi Jesús sisi̱ danica̱j sa̱ꞌ tsínj digyán ley daj nuguanꞌ, ni̱ gataj sij: ―Do̱j ni̱ gui̱nicaj sun Yanꞌanj chruhua nimán re̱ꞌ. ―Daj gataj Jesús. Ngaa ni̱ ni̱ a̱ ꞌngo̱ ni tsínj nun na̱chinꞌ snanꞌanj Jesús ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Hué dan ni̱ ngaa digyán Jesús rian ni ngüi̱ chruhua nuhui, ni̱ nachínj snanꞌanj sij ni ngüi̱. Ni̱ gataj sij: ―Ni̱ u̱n sin huin ni̱ ataj ni tsínj digyán si-ley Moisés sisi̱ Cristo huin daꞌníj xíꞌ David, ruhua á re̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daj si manꞌan Espíritu Santo guiꞌyaj sisi̱ ga̱taj David: “Yanꞌanj gataj gunun Señor nicaj sun riānj sisi̱ ga̱né re̱ꞌ chrej raꞌa sa̱ꞌ Yanꞌanj daꞌ gui̱sij gui̱ꞌyaj gana Yanꞌanj rian ni tsínj ununꞌ nga̱ Señor nicaj sun riānj.” Daj gataj Yanꞌanj gunun Señor, gataj xíꞌ David. ");
INSERT INTO trq_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ngaa ni̱ asa̱ꞌ ga̱ꞌue ga̱huin Cristo daꞌníj David sisi̱ duguꞌna̱j David Señor manꞌan Cristo únj. ―Daj gataj Jesús. Ni̱ ma̱n ni̱nꞌ ruhua ni ngüi̱ gunun si-nu̱guanꞌ Jesús. Ni̱ garanꞌ ruhua ni sij niꞌyaj ni sij si-nu̱guanꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Hué dan ni̱ digyán Jesús si-nu̱guanꞌ sij rian ni ngüi̱. Ni̱ gataj sij: ―Ga̱ cuidado ni é re̱ꞌ sisi̱ si̱ guiꞌyaj á re̱ꞌ da̱j rúnꞌ ꞌyaj ni tsínj digyán si-ley Moisés. Daj si nia̱ꞌ ruhua ni sij ga̱che ni sij nga̱ atsij xa̱can nu̱n ni sij huin si-ganꞌ ni tsínj huin achij. Ni̱ huin ruhua ni sij sisi̱ ga̱ꞌmi sa̱ꞌ ni ngüi̱ nga̱ ni sij ngaa chéj ni sij rian yuꞌue̱ aj. ");
INSERT INTO trq_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ni̱ nanaꞌuiꞌ ni sij ꞌngo̱ chrun xila sa̱ꞌ doj ga̱ne ni sij chruhua nuhui. Ni̱ nanoꞌ ni sij ꞌngo̱ yuꞌuj sa̱ꞌ ga̱ne ni sij rian ꞌyaj ni sij ꞌngo̱ guiꞌyanj. ");
INSERT INTO trq_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ni̱ aꞌnej ni sij ducuá yunꞌunj xa̱na mmij. Ni̱ achínj jniꞌyaj ná ni sij rian Yanꞌanj sisi̱ sa̱ꞌ ꞌyaj ni sij ga̱ni ruhua ni ngüi̱, ruhua ni sij. Gui̱ranꞌ xa̱can ni sij castigo, gui̱ꞌyaj Yanꞌanj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ni̱ nne Jesús ne̱ꞌ rian ngaj chrúnj sanꞌanj rian aꞌníj ni ngüi̱ sanꞌanj ofrenda güenda nuhui aj. Ni̱ niꞌyaj sij sisi̱ da̱j aꞌníj ni ngüi̱ si-sanꞌanj ni sij aj. Ni̱ gaꞌi̱ ni xuruꞌue aꞌníj nico sanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ni̱ gaꞌna̱ꞌ ꞌngo̱ yunꞌunj mmij niqui. Ni̱ gaꞌníj únꞌ hui̱j sanꞌanj niqui chruhua chrúnj daj. ");
INSERT INTO trq_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ngaa ni̱ gaquínj Jesús ga̱ꞌnaꞌ ni tsínj nicoꞌ sij. Ni̱ gataj sij: ―Xa̱ngaꞌ ataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ yunꞌunj xa̱na niqui nan, sani̱ aꞌníj nico únꞌ doj sanꞌanj daj nga̱ daranꞌ ni ngüi̱ aꞌníj sanꞌanj nan anj. ");
INSERT INTO trq_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Daranꞌ ni ngüi̱ nan aꞌuiꞌ sanꞌanj gunáj rian ni sij. Sani̱ yunꞌunj niqui mmij nan aꞌuiꞌ únꞌ daranꞌ sanꞌanj nicaj únꞌ sanꞌanj gui̱ran únꞌ si xa̱ únꞌ nánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ni̱ ngaa gahui Jesús chruhua nuhui nico, ni̱ nachínj snanꞌanj ꞌngo̱ tsínj nicoꞌ sij. Ni̱ gataj síꞌ: ―Maestro, ni̱ꞌyaj re̱ꞌ da̱j hua yej xa̱chij, ni̱ da̱j hua ni hueꞌ xa̱chij nej. ―Daj gataj síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ngaa ni̱ gataj Jesús: ―Niꞌí re̱ꞌ ni hueꞌ xa̱chij nan níꞌ. Hua ꞌngo̱ güi, ni̱ si̱ gunáj ni̱ a̱ ꞌngo̱ yej rian dugüiꞌ mánj. Du̱guane ni̱nꞌ ni sij nuhui nan anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Hué dan ni̱ ganꞌanj ga̱ne Jesús chra̱ dacan gu̱ꞌnaj Olivos niꞌyaj sij nuhui nico. Ni̱ nachínj snanꞌanj ni̱ni Pedro nga̱ Jacobo nej, Juan nej, Andrés nej, manꞌan Jesús. ");
INSERT INTO trq_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ni̱ gataj ni síꞌ: ―Ni̱ u̱n güi ga̱huin yya ni nuguanꞌ nan únj. Ni̱ da̱j hua ꞌngo̱ daꞌngaꞌ ga̱ꞌnaꞌ gui̱niꞌi únj, ngaa ni̱ ga̱huin daranꞌ nuguanꞌ nan únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ngaa ni̱ gaxi̱ꞌi Jesús gataj sij: ―Ga̱ cuidado ni é re̱ꞌ sisi̱ nitaj ꞌngo̱ tsínj di̱gyaꞌ yunꞌunj ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Daj si ga̱ꞌnaꞌ nico ni tsínj rian si-xugüi manꞌānj anj. Ni̱ ga̱taj ni sij: “Hué manꞌānj huin Cristo aj”, daj ga̱taj ni sij gu̱nun a ni é re̱ꞌ. Ni̱ di̱gyaꞌ yunꞌunj ni sij nico ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Ni̱ ngaa gu̱nun a ni é re̱ꞌ sisi̱ ununꞌ ꞌngo̱ xumanꞌ nga̱ ango xumanꞌ, ni̱ huin ruhua ꞌngo̱ xumanꞌ gu̱daꞌ nga̱ ango xumanꞌ, ngaa ni̱ si̱ guxuꞌuiꞌ a ni é re̱ꞌ mánj. Hua nia̱n si hué daj ga̱huin. Sani̱ achin ga̱nahuij ni̱nꞌ xungüi̱ ga̱ aj. ");
INSERT INTO trq_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ni̱ gu̱nunꞌ ni ngüi̱ ma̱n ꞌngo̱ xumanꞌ nico nga̱ ni ngüi̱ ma̱n ango xumanꞌ nico. Ni̱ gu̱nunꞌ ꞌngo̱ gobierno daj nga̱ ango gobierno. Ni̱ ga̱ꞌnaꞌ ꞌngo̱ yún go̱ꞌngo rian xungüi̱ nej. Ni̱ ga̱ xiꞌna̱ nej. Daranꞌ nan ni diaj gaxi̱ꞌij gui̱ranꞌ ni ngüi̱ sayun. ");
INSERT INTO trq_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Sani̱ ga̱ cuidado ni é re̱ꞌ nga̱ ni manꞌan án re̱ꞌ. Daj si na̱gaꞌuiꞌ ni sij ni é re̱ꞌ raꞌa ni tsínj nicaj sun. Ni̱ du̱guayun ni sij a ni é re̱ꞌ chruhua si-nuhui ni tsínj israelita nej. Ni̱ gui̱niquinꞌ ni é re̱ꞌ rian ni gobernado nga̱ ni rey nej güenda xiꞌí manꞌānj. Daꞌngaꞌ daj ga̱huin, ni̱ na̱taꞌ ni é re̱ꞌ rian ni síꞌ xiꞌīj aj. ");
INSERT INTO trq_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ni̱ ngaa achin ga̱nahuij xungüi̱, ni̱ hua nia̱n na̱taꞌ ni é re̱ꞌ si-nu̱guanꞌānj nuguanꞌ sa̱ꞌ rian daranꞌ ni ngüi̱ ma̱n chruhua xungüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","’Ni̱ ngaa na̱gaꞌuiꞌ ni sij a ni é re̱ꞌ raꞌa ni tsínj nicaj sun, ngaa ni̱ si̱ gahuin ruhua á re̱ꞌ si ga̱taj á re̱ꞌ gu̱nun ni síꞌ mánj. Ni̱ si̱ gani ruhua á re̱ꞌ si ga̱ꞌmi a ni é re̱ꞌ. Sani̱ ga̱ꞌmi ni é re̱ꞌ si ri̱qui Espíritu Santo ga̱ꞌmi a ni é re̱ꞌ si sé a ni é re̱ꞌ ga̱huin ga̱ꞌmi mánj. Espíritu Santo ga̱ꞌmi aj. ");
INSERT INTO trq_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ni̱ na̱gaꞌuiꞌ ꞌngo̱ tsínj daj jnánj sij raꞌa ni tsínj nicaj sun sisi̱ da̱gahuiꞌ ni síꞌ jnánj sij. Ni̱ daꞌngaꞌ daj gui̱ꞌyaj ꞌngo̱ tsínj daj nga̱ daꞌníj sij nej. Ni̱ gu̱nunꞌ ni daꞌníj nu̱ngüej nica̱ ꞌngo̱ tsínj daj. Ni̱ da̱gahuiꞌ ni sij chrej ni sij nga̱ nni ni sij nej. ");
INSERT INTO trq_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ni̱ si̱ gahuin sa̱ꞌ ruhua daranꞌ ni ngüi̱ ni̱ꞌyaj ni sij ni é re̱ꞌ xiꞌí si nicaj dugüiꞌ ni é re̱ꞌ ngāj. Sani̱ ni ngüi̱ huaj nicoꞌ yya ni̱nꞌ si-chrej Yanꞌanj da güi ga̱nahuij xungüi̱, ni̱ ga̱nacaj Yanꞌanj ni sij aj. ");
INSERT INTO trq_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ni̱ ngaa gui̱niꞌi ni é re̱ꞌ gui̱niquinꞌ si quij hua ꞌngo̱ yuꞌuj nitaj si hua sa̱ꞌ gui̱niquinj da̱j rúnꞌ gaꞌmi tsínj gu̱ꞌnaj Daniel huin tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná ―ni̱ u̱n tsínj aya nuguanꞌ nan ni̱ xa̱caj re̱ꞌ cuenta un sin huin nuguanꞌ nan ruhuaj gata―, ngaa ni̱ gu̱nánj ni ngüi̱ mán estado Judea ga̱nꞌanj ni sij riqui quij. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ni̱ gataj Jesús: ―Ni̱ tsínj táj xataꞌ chra̱ ducuá sij, ni̱ si̱ nanij sij ga̱tu sij gui̱ri sij ni̱ a̱ ꞌngo̱ rasu̱n chruhua ducuá sij mánj. ");
INSERT INTO trq_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ni̱ tsínj mán ꞌyaj sun riqui quij, ni̱ si̱ nanica̱j sij ga̱ꞌnaꞌ na̱ranꞌ sij si-ganꞌ sij ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ni̱ niqui niman ni ngüi̱ xa̱na nu̱n riqui ꞌngo̱ lij nga̱ ni ngüi̱ utsi gue̱ daꞌníj si ga̱huin ni güi da aj. ");
INSERT INTO trq_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ni̱ ga̱chinj jniꞌyaj ni é re̱ꞌ rian Yanꞌanj sisi̱ si̱ gaꞌna̱ꞌ sayun daj rian án re̱ꞌ yahui̱ nuhuij. ");
INSERT INTO trq_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","’Ni̱ ni güi daj ni̱ gui̱ranꞌ ni ngüi̱ sayun nico. Ni̱ asi̱j ngaa guiꞌyaj Yanꞌanj xungüi̱, ni̱ nun guiniꞌi ni sij ꞌngo̱ sayun da̱j rúnꞌ ga̱huin ni güi daj. Ni̱ si̱ gaꞌna̱ꞌ ango sayun da̱j rúnꞌ ga̱huin ni sayun ga̱chin da aj. ");
INSERT INTO trq_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ni̱ sisi̱ ga̱ nico güi ga̱ sayun, ni̱ si̱ gunucuaj ni ngüi̱ mánj. Sani̱ xiꞌí ni ngüi̱ nacui Señor, ni̱ ga̱niquinꞌ daꞌaj sij si ga̱huin sayun, gui̱ꞌyaj Señor. ");
INSERT INTO trq_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Ni̱ ngaa daj sisi̱ hua ꞌngo̱ tsínj ga̱taj rian án re̱ꞌ ni güi daj: “Ni̱ꞌyaj á re̱ꞌ. Nan niquinꞌ Cristo aj.” Asi̱: “Ni̱ꞌyaj á re̱ꞌ, daꞌ mánj niquinꞌ Cristo aj.” Ngaa ni̱ sisi̱ daꞌngaꞌ daj ga̱taj ni sij, ni̱ si̱ guxuman ruhua á re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Daj si ga̱ꞌnaꞌ ni tsínj ga̱taj sisi̱ hué ni sij huin Cristo, ga̱taj ni sij. Ni̱ ga̱ꞌnaꞌ ni tsínj ga̱taj sisi̱ hué ni sij huin tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj nej. Ni̱ tsínj digyaꞌ yunꞌunj huin ni sij. Ni̱ gui̱ꞌyaj chre ni sij. Ni̱ gui̱ꞌyaj ni sij ni rasu̱n nico güenda di̱gyaꞌ yunꞌunj ni sij ni ngüi̱. Ni̱ sisi̱ ga̱ꞌue ni̱ di̱gyaꞌ yunꞌunj ni sij manꞌan ni ngüi̱ nacui Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Du̱gumi a ni é re̱ꞌ manꞌan án re̱ꞌ. Daranꞌanj hua gataj sinīj gunun a ni é re̱ꞌ nánj. ");
INSERT INTO trq_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Sani̱ ngaa ga̱chin ni güi gui̱ranꞌ ni ngüi̱ sayun daj, ngaa ni̱ ga̱huin ru̱miꞌ rian güi. Ni̱ si̱ guixiguin yahui̱ mánj. ");
INSERT INTO trq_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ni̱ ga̱yu ni yatiꞌ mán xataꞌ. Ni na̱gunanj ni fuerza mán xataꞌ nej. ");
INSERT INTO trq_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Asíj ni̱ gui̱niꞌi ni ngüi̱ ga̱ꞌnaꞌ manꞌānj rian ni nga huīnj daꞌníj ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ngaa ni̱ ga̱ꞌnī ni ángel ga̱nꞌanj na̱ranꞌ ni sij ni ngüi̱ hua ganacui Yanꞌanj. Ni̱ ga̱naranꞌ ni sij ni ngüi̱ daj mán ni̱nꞌ ga̱chraꞌ daꞌ xiꞌí ni̱nꞌ xungüi̱ nga̱ xataꞌ nej aj. ");
INSERT INTO trq_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Ni̱ ga̱huin chru̱n a ni é re̱ꞌ xiꞌí nuguanꞌ huin chrun higuera. Ngaa ga̱nahuin yaꞌni̱j raꞌa, ni̱ na̱xiraꞌ coj raꞌa, hué dan ni̱ niꞌi a ni é re̱ꞌ sisi̱ hua guisíj gahuin ni̱chrunꞌ yahui̱ ga̱huin ya̱nꞌan anj. ");
INSERT INTO trq_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ni̱ hué gue̱ ducuánj daj ngaa gui̱niꞌi a ni é re̱ꞌ sisi̱ gahuin yya si gatā gunun a ni é re̱ꞌ, ngaa ni̱ xa̱caj a ni é re̱ꞌ cuenta sisi̱ ga̱huin ni̱chrunꞌ ruhua gui̱sī gui̱niquīnj rian hueꞌ huīnj daꞌníj ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ si̱ gahuiꞌ ni ngüi̱ ma̱n yya̱j da ga̱huin yya daranꞌ ni nuguanꞌ nan anj. ");
INSERT INTO trq_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ga̱ niꞌya xataꞌ nga̱ yoꞌój. Sani̱ nitaj a̱man ga̱nahuij si-nu̱guanꞌānj mánj. ");
INSERT INTO trq_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Sani̱ nun niꞌi a̱ ꞌngo̱ ni ngüi̱ u̱n güi ni u̱n hora ga̱ꞌnaꞌ manꞌānj mánj. Ni̱ nun niꞌi ni ángel mán xataꞌ nej. Ni̱ nun niꞌi manꞌānj huīnj daꞌníj Yanꞌanj nej. Urin Chrē niꞌi nánj. ");
INSERT INTO trq_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ngaa ni̱ ni̱ꞌyaj sa̱ꞌ ni é re̱ꞌ. Ni̱ na̱nun ruhua á re̱ꞌ nej. Ni̱ ga̱chinj jniꞌyaj á re̱ꞌ rian Yanꞌanj si nun niꞌi a ni é re̱ꞌ a̱man ga̱huin sayun ni güi daj. ");
INSERT INTO trq_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ni̱ rúnꞌ ꞌyaj ꞌngo̱ tsínj nu̱n chrej ganꞌanj ga̱nꞌ ango xumanꞌ, ni̱ daꞌngaꞌ daj ꞌyaj manꞌānj. Ni̱ aꞌninꞌ tsínj daj sun rian ni si-moso sij sisi̱ ꞌueé du̱gumi ni síꞌ ducuá sij. Ni̱ aꞌuiꞌ sij sun rian go̱ꞌngo ni síꞌ. Ni̱ aꞌninꞌ sij sun rian tsínj naꞌnij rian hueꞌ sisi̱ du̱gumi sa̱ꞌ síꞌ ducuá sij aj. ");
INSERT INTO trq_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Xiꞌí daj ni̱ gui̱niꞌyaj sa̱ꞌ á re̱ꞌ. Daj si nun niꞌi a ni é re̱ꞌ u̱n güi na̱sij tsínj du̱cua daj sisi̱ ni̱ do̱j níꞌ, sisi̱ ya̱nꞌ sa̱ꞌ níꞌ, sisi̱ aguáj doꞌloj níꞌ, sisi̱ hua ni̱ganꞌ na̱sij sij níꞌ. ");
INSERT INTO trq_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ni̱ sisi̱ nasinu̱nj na̱sij sij, ni̱ du̱gumi a ni é re̱ꞌ sisi̱ si̱ nariꞌ sij a ni é re̱ꞌ ngaa ngaj á re̱ꞌ atoj a ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ni̱ nuguanꞌ atā gu̱nun a ni é re̱ꞌ nan, ni̱ hué daj atā gu̱nun daranꞌ ni ngüi̱ sisi̱ gui̱niꞌyaj sa̱ꞌ daranꞌ a ni é re̱ꞌ manꞌan án re̱ꞌ. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ni̱ achin yahuij güi ga̱huin guiꞌyanj pascua. Ni̱ guiꞌyanj daj xa ni tsínj israelita chrachrúnj nitaj si nachrej levadura. Ni̱ huin ruhua ni chrej aꞌninꞌ nga̱ ni tsínj digyán ley sisi̱ da̱j ga̱ꞌue di̱gyaꞌ yunꞌunj ni sij manꞌan Jesús, ni̱ gui̱daꞌa hui̱ ni sij síꞌ. Daj si da̱gahuiꞌ ni sij, ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Sani̱ gataj ni sij: ―Si̱ guidoꞌóꞌ síꞌ güi ga̱huin guiꞌyanj nun sa̱ꞌ nun, ni̱ ga̱huin sayun gui̱ꞌyaj ni ngüi̱ aj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ni̱ ngaa gane Jesús xumanꞌ Betania, ni̱ gane sij ducuá ꞌngo̱ tsínj gu̱ꞌnaj Simón, huin tsínj guiranꞌ xiꞌi̱ lepra. Ni̱ nne sij rian mesa. Ni̱ guisíj ꞌngo̱ yunꞌunj xa̱na rian nne Jesús. Ni̱ nicaj únꞌ ꞌngo̱ frasco yej gu̱ꞌnaj alabastro guisíj únꞌ rian Jesús. Ni̱ gara gue̱-éꞌ gasiti guinꞌ da̱j gu̱ꞌnaj nardo. Ni̱ duꞌue ni̱nꞌ ruhua-áꞌ. Ni̱ guraꞌ únꞌ frasco daj. Ni̱ garij únꞌ gasiti daj chra̱ Jesús. ");
INSERT INTO trq_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ni̱ gaꞌman ruhua daꞌaj ni tsínj mán daj. Ni̱ gataj ni sij gunun ni dugüiꞌ ni sij: ―Ni̱ u̱n sin huin ni̱ gayanj yu̱n yunꞌunj xa̱na daj gasiti sa̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ga̱ꞌue ga̱neꞌ gasiti daj. Ni̱ ga̱ꞌue gui̱riꞌ ꞌngo̱ si hua̱ꞌnij ciento táj doj denario sanꞌanj ga̱ꞌuiꞌ néꞌ rian ni ngüi̱ yaco ranꞌ anj. ―Daj gataj ni sij. Ni̱ chranꞌ ni sij yunꞌunj xa̱na daj. ");
INSERT INTO trq_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Sani̱ gataj Jesús gunun ni tsínj daj: ―Ga̱ꞌninꞌ ruhua á re̱ꞌ. Ni̱ u̱n sin huin ni̱ chranꞌ yunꞌunj ni é re̱ꞌ yunꞌunj xa̱na nan únj. Si ꞌyaj unj nan ngāj, ni̱ duguꞌna̱j huaj ꞌyaj unj. ");
INSERT INTO trq_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yaꞌyoj nne ni ngüi̱ yaco ranꞌ nga̱ ni é re̱ꞌ. Ni̱ ga̱ꞌue gui̱ꞌyaj ni é re̱ꞌ sinduj nga̱ ni ngüi̱ daj ngaa aranꞌ ruhua á re̱ꞌ. Sani̱ sé si ga̱ne ni̱gān nga̱ á re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yunꞌunj xa̱na nan guiꞌyaj ꞌngo̱ sinduj yūnj da̱j rúnꞌ gaꞌue guiꞌyaj unj. Ni̱ ngaa achin ga̱huīj, ni̱ garij unj gasiti guinꞌ da̱j nnee̱ cū. Daj si do̱j gui̱sij güi ga̱chinꞌ ni sij manꞌānj. ");
INSERT INTO trq_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Xa̱ngaꞌ yya atā gu̱nun a ni é re̱ꞌ sisi̱ daranꞌ yuꞌuj ga̱ꞌmi ni sij nuguanꞌ sa̱ꞌ rian xiꞌīj, ni̱ hué daj na̱taꞌ ni sij si guiꞌyaj yunꞌunj xa̱na daj riānj. Ngaa ni̱ na̱nun ruhua ni ngüi̱ xiꞌí unj anj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Hué dan ni̱ ganꞌanj tsínj gu̱ꞌnaj Judas Iscariote rian ni chrej aꞌninꞌ huin sij ꞌngo̱ ni xu̱huij ni tsínj nicoꞌ Jesús. Ni̱ huin ruhua sij na̱gaꞌuiꞌ sij Jesús rian ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ni̱ ngaa gunun ni chrej si gataj Judas, ni̱ gahuin nia̱ꞌ ruhua ni síꞌ. Ni̱ gaꞌníj duꞌua ni síꞌ ga̱ꞌuiꞌ ni síꞌ sanꞌanj rian Judas. Ngaa ni̱ gaxi̱ꞌi Judas nanoꞌ sij ꞌngo̱ ducuánj na̱gaꞌuiꞌ sij Jesús raꞌa ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ni̱ guisíj güi sini gahuin guiꞌyanj ngaa guiꞌyaj ni sij chrachrúnj nitaj si ꞌni̱j levadura xa ni sij. Ni̱ güi sini daj huin ngaa dagahuiꞌ ni sij xachij ꞌni̱j xiꞌí guiꞌyanj pascua. Ngaa ni̱ nachínj snanꞌanj ni tsínj nicoꞌ Jesús gataj ni sij: ―Ni̱ a̱ huin ruhuá re̱ꞌ si gui̱ꞌyaj xugüi ni únj xa̱ stiꞌni̱ re̱ꞌ pascua únj. ―Hué daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ngaa ni̱ gaꞌníj Jesús hui̱j tsínj nicoꞌ sij. Ni̱ gataj sij gunun nu̱ngüej síꞌ: ―Güi̱j ga̱tu nu̱ngüej é re̱ꞌ xumanꞌ. Ni̱ na̱riꞌ dugüiꞌ nu̱ngüej é re̱ꞌ nga̱ ꞌngo̱ tsínj ata cucuaj nu̱n nnee chruhua. Ni̱ gui̱nicoꞌ nu̱ngüej é re̱ꞌ sij aj. ");
INSERT INTO trq_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ni̱ ni̱ a̱ ga̱tu tsínj daj, ni̱ ga̱taj nu̱ngüej é re̱ꞌ rian tsínj du̱cua daj: “Nachínj snanꞌanj Maestro manꞌán re̱ꞌ u̱n cuarto huin xa̱ stiꞌni̱ sij nga̱ ni tsínj nicoꞌ sij xiꞌí guiꞌyanj pascua, ataj sij únj”, ga̱taj nu̱ngüej é re̱ꞌ gu̱nun tsínj du̱cua daj. ");
INSERT INTO trq_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ngaa ni̱ ga̱nꞌanj di̱gyán síꞌ chruhua ꞌngo̱ cuarto xa̱chij xataꞌ. Ni̱ a̱ hua chrun chruhua cuarto daj si niquinꞌ mesa nga̱ chrun xila rian gane ni sij xa ni sij. Yuꞌuj daj gui̱ꞌyaj xugüi nu̱ngüej é re̱ꞌ xa̱ stiꞌni̱ néꞌ ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ngaa ni̱ gahui nu̱ngüej tsínj nicoꞌ Jesús daj ganꞌanj nu̱ngüej sij xumanꞌ. Ni̱ nariꞌ nu̱ngüej sij daranꞌanj rúnꞌ gataj Jesús. Ni̱ guiꞌyaj xugüi nu̱ngüej sij sisi̱ xa̱ stiꞌni̱ ni sij xiꞌí guiꞌyanj pascua. ");
INSERT INTO trq_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Daꞌ ni̱ do̱j guisíj Jesús nga̱ xu̱huij ni tsínj nicoꞌ síꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ni̱ ngaa nne ni sij rian mesa xa ni sij, ngaa ni̱ gataj Jesús gunun ni sij: ―Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ na̱gaꞌuiꞌ ꞌngo̱ ni é re̱ꞌ mán xa ngāj manꞌānj rian ni tsínj ga̱ꞌnaꞌ gui̱daꞌa yūnj anj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ngaa ni̱ ganani ruhua ni sij. Ni̱ gaxi̱ꞌi ni sij nachínj snanꞌanj go̱ꞌngo ni sij síꞌ. Ni̱ gataj ni sij: ―Manꞌānj huin níꞌ. ―Gataj go̱ꞌngo ni sij. ");
INSERT INTO trq_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ngaa ni̱ gataj Jesús: ―Hué ꞌngo̱ xu̱huij ni é re̱ꞌ tsínj nicoꞌ yūnj, gui̱ꞌyaj da aj. Tsínj nne ni̱ jniaj sij chrachrúnj ngāj chruhua goꞌo hué síꞌ huin anj. ");
INSERT INTO trq_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ni̱ da̱j rúnꞌ ataj si-nu̱guanꞌ Yanꞌanj xiꞌīj, ni̱ hué daꞌngaꞌ daj hua nia̱n si gui̱ranꞌānj sayun. Sani̱ niqui niman ni̱nꞌ ruhua tsínj na̱gaꞌuiꞌ manꞌānj rian ni tsínj ga̱ꞌnaꞌ gui̱daꞌa yūnj. Daj si ga̱huin nico castigo gui̱ranꞌ síꞌ. Sa̱ꞌ huin sisi̱ si̱ gaꞌnga sij rúnꞌ huaj aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ni̱ ngaa xa ni sij, ni̱ guidaꞌa Jesús chrachrúnj. Ni̱ nagaꞌuiꞌ sij si guruhua Yanꞌanj. Asíj ni̱ guraꞌ daꞌaj sij chrachrúnj daj. Ni̱ gaꞌuiꞌ sij xa̱ ni tsínj nicoꞌ sij. Ni̱ gataj sij: ―Gui̱daꞌa ni é re̱ꞌ. Nan huin chrachrúnj huin nnee̱ cū aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Hué dan ni̱ guidaꞌa Jesús tasa. Ni̱ nagaꞌuiꞌ sij si guruhua Yanꞌanj. Asíj ni̱ gaꞌuiꞌ sij go̱ꞌo ni sij. Ni̱ goꞌo daranꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ni̱ gataj Jesús: ―Nnee nan huin si-tun manꞌānj. Ni̱ nga̱ tun nan, ni̱ guisíj gahuin yya nuguanꞌ guiꞌyaj yya Yanꞌanj nga̱ ni ngüi̱. Ni̱ ga̱yanj si-tun manꞌānj xiꞌí nico ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ni̱ xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ nitaj si go̱ꞌo ru̱huaꞌ yūnj nnee uva nan daꞌ güi go̱ꞌōj nnee uva na̱ca rian nicaj sun Yanꞌanj anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ni̱ ngaa guisíj garáj ni sij chraꞌ, ngaa ni̱ gahui ni sij ganꞌanj ni sij dacan gu̱ꞌnaj Olivos. ");
INSERT INTO trq_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ngaa ni̱ gataj Jesús: ―Du̱na daranꞌ ni é re̱ꞌ yūnj nánj. Daj si gataj si-nu̱guanꞌ Yanꞌanj: “Ga̱ꞌuiꞌ Yanꞌanj tsínj dugumi xachij. Hué dan ni̱ gu̱nánj ni xuj. Ni̱ ga̱xaꞌni ni xuj huin ín re̱ꞌ aj.” Daj gataj si-nu̱guanꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Sani̱ ngaa ga̱naꞌnī, ngaa ni̱ ga̱nꞌān estado Galilea. Asíj ni̱ huaj ni é re̱ꞌ yuꞌuj daj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ngaa ni̱ gataj Pedro gunun sij: ―Nu̱nj si du̱naj daranꞌ ni sij manꞌán re̱ꞌ, sani̱ nitaj a̱man du̱naj manꞌānj manꞌán re̱ꞌ mánj. ―Daj gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ngaa ni̱ gataj Jesús: ―Xa̱ngaꞌ atā gu̱nun re̱ꞌ sisi̱ asi̱j nun ga̱guaj doꞌloj hui̱j duꞌua xúꞌ ya̱nꞌ nan, ni̱ ga̱taj re̱ꞌ hua̱ꞌnij sisi̱ nun niꞌí re̱ꞌ manꞌānj, ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Sani̱ nucuaj gataj Pedro rian Jesús: ―Nu̱nj si hua nia̱n ga̱huīj nga̱ re̱ꞌ, sani̱ si̱ gatā sisi̱ nun niꞌīnj manꞌán re̱ꞌ mánj. ―Daj gataj Pedro. Ni̱ hué daj gataj daranꞌ ni sij nej. ");
INSERT INTO trq_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ngaa guisíj ni̱ ganꞌanj ni sij ꞌngo̱ yuꞌuj gu̱ꞌnaj Getsemaní. Ni̱ gataj Jesús gunun ni tsínj nicoꞌ sij: ―Ga̱ne a ni é re̱ꞌ nan, ngaa ni̱ ga̱chinj jniꞌyā rian Yanꞌanj anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ni̱ nicaj sij Pedro nga̱ Jacobo nej, Juan nej, ganꞌanj aninꞌ sij. Ni̱ ni̱nꞌ ruhua gaxi̱ꞌi sij ganani ruhua sij. Daꞌ huej ataꞌ niman sij. ");
INSERT INTO trq_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ni̱ gataj sij gunun aninꞌ síꞌ: ―Da̱j níꞌ ni̱ a̱ ga̱nꞌanj nimānj ruhuāj ꞌyaj si nani ruhuāj aj. Ni̱ ga̱huīj nga̱ nimānj ruhuāj. Ngaa ni̱ gu̱na aninꞌ é re̱ꞌ nan gu̱nun ruhua á re̱ꞌ ngāj aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Asíj ni̱ ganꞌanj Jesús do̱j ne̱ꞌ chrej rian. Ni̱ ganiquinꞌ ráj da̱coj sij ganun yo sij rian yoꞌój. Ni̱ gachínj jniꞌyaj sij rian Yanꞌanj sisi̱ ga̱ꞌue, ngaa ni̱ si̱ guiranꞌ sij sayun ranꞌ sij da aj. ");
INSERT INTO trq_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ngaa ni̱ gataj sij: ―Tata chréꞌ, ga̱ꞌue gui̱ꞌyaj manꞌán re̱ꞌ daranꞌanj. Ngaa ni̱ ga̱ꞌne re̱ꞌ sayun ranꞌānj nánj. Sani̱ si̱ guiꞌyáj re̱ꞌ rúnꞌ huin ruhua manꞌānj mánj. Maan si gui̱ꞌyáj re̱ꞌ rúnꞌ huin ruhua manꞌán re̱ꞌ aj. ―Daj gataj Jesús gunun manꞌan Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ngaa ni̱ nanica̱j Jesús rian ma̱n aninꞌ síꞌ. Ni̱ atoj ni síꞌ nariꞌ sij. Ngaa ni̱ gataj sij gunun Pedro: ―Simón, hua atoj jnān níꞌ. Ni̱ si̱ gaꞌue ni̱ ꞌngo̱ hora gu̱nun ruhuá so̱ꞌ ga̱ míꞌ. ");
INSERT INTO trq_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ga̱ gunun ruhuá re̱ꞌ ga̱chinj jniꞌyáj re̱ꞌ rian Yanꞌanj sisi̱ si̱ guinij aninꞌ é re̱ꞌ rian gaquinꞌ ngaa ga̱tsij sichre niman aninꞌ é re̱ꞌ. Huin ruhua niman aninꞌ é re̱ꞌ gui̱ꞌyaj sa̱ꞌ á re̱ꞌ. Sani̱ nun ga̱huin nucuaj nnee̱ cúj aninꞌ é re̱ꞌ mánj. ―Daj gataj Jesús gunun aninꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ngaa ni̱ ganꞌanj ru̱huaꞌ yún Jesús. Ni̱ gachínj jniꞌyaj sij rian Yanꞌanj. Ni̱ hué gue̱ nuguanꞌ daj gataj ru̱huaꞌ yún sij rian Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ni̱ ngaa nanica̱j ru̱huaꞌ yún sij, ni̱ atoj ru̱huaꞌ yún aninꞌ síꞌ nariꞌ sij. Daj si aꞌuij rian aninꞌ síꞌ, guiꞌyaj nnej. Ni̱ nun nariꞌ ruhua ni sij si ga̱taj ni sij gu̱nun Jesús. ");
INSERT INTO trq_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ni̱ nanica̱j Jesús síj hua̱ꞌnij. Ni̱ gataj sij: ―Ga̱ꞌue ga̱toj aninꞌ é re̱ꞌ, ni̱ na̱ranj ruhua á re̱ꞌ aj. Sani̱ yya̱j aj. Guisíj hora ga̱ꞌnaꞌ tsínj na̱gaꞌuiꞌ manꞌānj raꞌa ni tsínj ꞌyaj gaquinꞌ huīnj daꞌníj ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Na̱chica aninꞌ é re̱ꞌ ga̱nꞌanj néꞌ. Hua gahuin ni̱chrunꞌ tsínj ꞌna̱ꞌ na̱gaꞌuiꞌ yūnj rian ni tsínj nicaj sun. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Da aꞌmi gue̱ Jesús ngaa guisíj tsínj gu̱ꞌnaj Judas huin sij ꞌngo̱ xu̱huij ranꞌ ni tsínj nicoꞌ Jesús. Ni̱ nicaj dugüiꞌ sij nga̱ nico ni ngüi̱ guisíj sij. Ni̱ ata ni sij espada nej, chrun nej. Ni̱ gaꞌníj ni chrej aꞌninꞌ nga̱ ni maestro digyán ley nej, ni tsínj huin achij gaꞌna̱ꞌ ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ni̱ hua digyán Judas ꞌngo̱ chrej da̱j gui̱niꞌi ni síꞌ u̱n tsínj huin gui̱daꞌa ni síꞌ. Ni̱ gataj sij: ―Tsínj garun duꞌuāj daj hué sij huin Jesús aj. Gui̱daꞌa á re̱ꞌ ni̱caj á re̱ꞌ ga̱nꞌanj án re̱ꞌ. ―Daj hua gataj Judas gunun ni tsínj gaꞌna̱ꞌ nga̱ sij. ");
INSERT INTO trq_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ngaa ni̱ ꞌngo̱ gahuin ni̱chrunꞌ Judas rian Jesús. Ni̱ gataj sij: ―Maestro. ―Gataj Judas. Ni̱ garun duꞌua sij síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Hué dan ni̱ guidaꞌa ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Sani̱ guiri ꞌngo̱ tsínj niquinꞌ daj si-espada sij. Ni̱ gaꞌuiꞌ sij tsínj ꞌyaj sun rian chrej aꞌninꞌ. Ni̱ güéj gue̱ chraquij síꞌ, guiꞌyaj sij. ");
INSERT INTO trq_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ngaa ni̱ gachínj snanꞌanj Jesús ni ngüi̱ daj. Ni̱ gataj sij: ―Ni̱ u̱n sin huin ni̱ ata á re̱ꞌ espada nga̱ chrun nej, ꞌna̱ꞌ á re̱ꞌ gui̱daꞌa á re̱ꞌ yūnj únj. Huēj huin ꞌngo̱ tsínj tu̱ ruhua á re̱ꞌ níꞌ. ");
INSERT INTO trq_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yaꞌyoj ganēj chruhua nuhui digyānj rian án re̱ꞌ. Sani̱ nun guidaꞌa á re̱ꞌ yūnj mánj. Sani̱ hua nia̱n si ga̱huin yya da̱j rúnꞌ ataj si-nu̱guanꞌ Yanꞌanj xiꞌīj aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ngaa ni̱ duna daranꞌ ni tsínj nicoꞌ Jesús manꞌan sij. Ni̱ gunánj ni síꞌ rian Jesús. ");
INSERT INTO trq_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Sani̱ hua ꞌngo̱ tsínj hua ya̱n nicoꞌ Jesús. Ni̱ neque sij ꞌngo̱ atsij manta. Ni̱ guidaꞌa ni sij síꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Sani̱ dunáj síꞌ atsij manta daj raꞌa ni sij. Ni̱ hua nnee̱ síꞌ gunánj síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Hué dan ni̱ nicaj ni tsínj guidaꞌa Jesús ganꞌanj ni sij rian chrej huin achij ni̱nꞌ. Ni̱ nahuin yuꞌ daranꞌ ni chrej aꞌninꞌ nga̱ ni tsínj huin achij nej, ni maestro digyán ley nej. ");
INSERT INTO trq_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ni̱ ga̱nꞌ huaj Pedro nicoꞌ síꞌ rucú Jesús. Ni̱ guisíj sij ta rian ducuá chrej huin achij ni̱nꞌ daj. Ni̱ ganꞌanj ga̱ne sij nga̱ ni snado. Ni̱ nahuin gui̱n sij xiꞌníj yanꞌa̱n. ");
INSERT INTO trq_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ngaa ni̱ nanoꞌ ni chrej aꞌninꞌ nga̱ daranꞌ ni tsínj ꞌyaj junta daj ꞌngo̱ ducuánj sisi̱ na̱riꞌ ni sij gaquinꞌ gu̱taꞌ ni sij xiráj Jesús. Ngaa ni̱ da̱gahuiꞌ ni sij síꞌ, ruhua ni sij. Sani̱ nun nariꞌ ni sij ducuánj daj. ");
INSERT INTO trq_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Sani̱ nu̱nj si gutaꞌ yu̱n gaꞌi̱ ni sij gaquinꞌ xiráj Jesús, sani̱ nachrej si-nu̱guanꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ngaa ni̱ naxu̱man go̱ꞌngo ni sij. Ni̱ gutaꞌ yu̱n ni sij gaquinꞌ xiráj manꞌan Jesús. Ni̱ gataj ni sij: ");
INSERT INTO trq_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Gunun ni únj si gataj Jesús: “Du̱guanē nuhui nan huin nuhui guiꞌyaj raꞌa ni tsínj. Ni̱ xiráj hua̱ꞌnij güi gui̱ꞌyā ango nuhui aj. Sani̱ nitaj raꞌa ni tsínj gui̱ꞌyaj mánj”, ataj sij. ―Daj gataj ni tsínj nne̱ daj niꞌyaj ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Sani̱ hué na̱nj gachej nuguanꞌ gaꞌmi ni sij nej aj. ");
INSERT INTO trq_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ngaa ni̱ naxu̱man chrej huin achij ni̱nꞌ da̱ni daranꞌ ni sij. Ni̱ gataj sij gunun Jesús: ―Nitaj ꞌngo̱ nuguanꞌ na̱nicaj re̱ꞌ únj. Ni̱ u̱n sin huin si ataj ni sij xiꞌí re̱ꞌ únj. ―Daj gataj chrej daj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Sani̱ dínj ganiquinꞌ Jesús. Ni̱ a̱ ꞌngo̱ nuguanꞌ nun gaꞌmi sij mánj. Ngaa ni̱ nachínj snanꞌanj ru̱huaꞌ yún chrej huin achij daj. Ni̱ gataj sij: ―Hué re̱ꞌ huin Cristo daꞌníj Yanꞌanj níꞌ. ―Daj gataj sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ngaa ni̱ gataj Jesús: ―Huēj huin. Ni̱ atā gu̱nun a ni é re̱ꞌ sisi̱ huēj huin daꞌníj ni ngüi̱. Ni̱ gui̱niꞌi a ni é re̱ꞌ sisi̱ ga̱nēj ne̱ꞌ chrej raꞌa sa̱ꞌ Yanꞌanj nucuaj ni̱nꞌ ne̱ꞌ xataꞌ. Ni̱ gui̱niꞌi ni é re̱ꞌ sisi̱ ga̱ꞌnāj rian nga xataꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ngaa ni̱ gutsiꞌ chrej huin achij ni̱nꞌ daj si-ganꞌ sij. Ni̱ gataj sij gunun ni dugüiꞌ sij: ―Nitaj si gui̱ꞌyóꞌ ni testigo ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Hua gunun a ni é re̱ꞌ si gaꞌmi quij sij xiꞌí Yanꞌanj. Da̱j gui̱ꞌyaj néꞌ nga̱ sij, ruhua á re̱ꞌ únj. ―Daj gataj chrej huin achij ni̱nꞌ daj. Ngaa ni̱ uyan huin ruhua daranꞌ ni sij sisi̱ daꞌui Jesús gaquinꞌ, ni̱ ga̱huiꞌ síꞌ, gui̱ꞌyaj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ni̱ gaxi̱ꞌi go̱ꞌngo ni sij gara staꞌnunj ni sij rian Jesús. Ni̱ guiránj ni sij rian síꞌ. Ni̱ gaꞌuiꞌ ni sij síꞌ nej. Ni̱ gataj ni sij: ―Ga̱hui chra̱ re̱ꞌ sisi̱ u̱n tsínj gaꞌuiꞌ so̱ꞌ aj. ―Daj gataj ni sij gaꞌmi ducu ni sij rian Jesús. Ni̱ gaꞌuiꞌ ni snado dugumi nuhui rian Jesús nej. ");
INSERT INTO trq_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ni̱ nne Pedro ni̱caꞌ ta rian ducuá chrej huin rian daj. Ngaa ni̱ gaꞌna̱ꞌ ꞌngo̱ yunꞌunj xa̱na ꞌyaj sun rian chrej huin achij ni̱nꞌ da aj. ");
INSERT INTO trq_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ni̱ ngaa guiniꞌi únꞌ nne Pedro xiꞌníj yanꞌa̱n nahuin gui̱n síꞌ, ngaa ni̱ niꞌyaj sa̱ꞌ únꞌ niquinꞌ únꞌ manꞌan Pedro. Ni̱ gataj únꞌ: ―Hué re̱ꞌ nicaj dugüiꞌ nga̱ Jesús tsínj ꞌna̱ꞌ xumanꞌ Nazaret. ―Daj gataj yunꞌunj xa̱na daj gunun Pedro. ");
INSERT INTO trq_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Sani̱ nun ga̱ꞌuej Pedro. Ni̱ gataj sij: ―Nun niꞌīnj sij. Ni̱ nun niꞌīnj níꞌ u̱n sin huin aꞌmi re̱ꞌ mánj. ―Gataj Pedro gunun únꞌ. Ni̱ gahui sij ne̱ꞌ chrej xe̱ꞌ, ne̱ꞌ rian atuj ni ngüi̱. Ni̱ gaguáj doꞌloj duꞌua xúꞌ. ");
INSERT INTO trq_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ni̱ niꞌyaj ru̱huaꞌ yún yunꞌunj daj Pedro. Ni̱ gaxi̱ꞌi únꞌ gataj únꞌ gunun ni tsínj mán yuꞌuj daj: ―Tsínj nan huin dugüiꞌ ni tsínj nicaj dugüiꞌ nga̱ Jesús aj. ―Daj gataj únꞌ. ");
INSERT INTO trq_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Sani̱ naꞌuej ru̱huaꞌ yún Pedro sisi̱ guiniꞌi sij Jesús. Ni̱ ango hora le, ni̱ gataj ru̱huaꞌ yún ni tsínj ma̱n yuꞌuj daj rian Pedro: ―Xa̱ngaꞌ huín re̱ꞌ ꞌngo̱ ni tsínj daj. Daj si ꞌna̱ꞌ re̱ꞌ estado Galilea. Ni̱ aꞌmí re̱ꞌ da̱j rúnꞌ aꞌmi ni sij aj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ngaa ni̱ gaxi̱ꞌi Pedro gutaꞌ ni̱ca yya. Ni̱ gaꞌmi quij sij. Ni̱ gataj sij: ―Nun niꞌīnj tsínj xi̱ꞌi aꞌmi ni é re̱ꞌ mánj. ―Daj gataj Pedro gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ngaa ni̱ hué hora daj gaguáj doꞌloj si hui̱j duꞌua xúꞌ. Ngaa ni̱ nanun ruhua Pedro si gataj Jesús gunun sij: “Asi̱j nun ga̱guaj doꞌloj hui̱j duꞌua xúꞌ, ni̱ ga̱taj re̱ꞌ si hua̱ꞌnij si nun niꞌí re̱ꞌ manꞌānj.” Hué daj hua gataj Jesús gunun Pedro. Ni̱ ngaa xacaj Pedro cuenta si gataj Jesús gunun sij, ni̱ gaco sij. ");
INSERT INTO trq_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ni̱ ngaa gue̱rengaꞌ, ni̱ ꞌngo̱ nahuin yuꞌ ni chrej aꞌninꞌ nga̱ ni tsínj huin achij nej, ni̱ tsínj digyán ley nej. Ni̱ guiꞌyaj ni sij ꞌngo̱ junta nga̱ ango ni tsínj mán yuꞌuj daj nej. Ni̱ gumíj ni sij síꞌ. Ni̱ dagaꞌmi dugüiꞌ ni sij xiꞌí Jesús. Ni̱ nicaj ni sij ganꞌanj ni sij nagaꞌuiꞌ ni sij síꞌ raꞌa tsínj gu̱ꞌnaj Pilato. ");
INSERT INTO trq_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ngaa ni̱ nachínj snanꞌanj Pilato Jesús. Ni̱ gataj sij: ―Hué re̱ꞌ huin si-rey ni tsínj israelita níꞌ. ―Daj gataj Pilato. ―Hué re̱ꞌ ataj nánj. ―Daj gataj Jesús gunun Pilato. ");
INSERT INTO trq_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ni̱ ducu gaꞌmi gaquinꞌ ni chrej aꞌninꞌ xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ngaa ni̱ nachínj snanꞌanj ru̱huaꞌ yún Pilato Jesús. Ni̱ gataj sij: ―Nitaj ꞌngo̱ nuguanꞌ na̱nicaj re̱ꞌ únj. Ni̱ꞌyaj re̱ꞌ sisi̱ u̱ndaj gaquinꞌ aꞌmi ni sij rian xiꞌí manꞌán re̱ꞌ aj. ―Daj gataj Pilato rian Jesús. ");
INSERT INTO trq_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Sani̱ nun danica̱j Jesús ni̱ a̱ ꞌngo̱ nuguanꞌ rian Pilato mánj. Ni̱ xiꞌí daj garáj yanꞌanj ruhua Pilato niꞌyaj síꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ni̱ daꞌ go̱ꞌngo yoꞌ hua ꞌngo̱ ducuánj nicoꞌ Pilato sisi̱ ri síꞌ ꞌngo̱ tsínj nu̱n ducuaga̱ꞌ go̱ꞌngo guiꞌyanj pascua. Danej gahuin tsínj achínj jniꞌyaj ni ngüi̱ rian sij, ni̱ gui̱ri síꞌ ducuaga̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ni̱ nne ꞌngo̱ tsínj gu̱ꞌnaj Barrabás ducuaga̱ꞌ. Ni̱ gununꞌ ni du̱güiꞌ sij nga̱ ni tsínj nicaj sun. Ni̱ ngaa gununꞌ ni sij, ni̱ dagahuiꞌ ni sij níman. ");
INSERT INTO trq_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ngaa ni̱ guisíj ni ngüi̱ rian Pilato. Ni̱ gachínj ni sij gui̱ri Pilato ꞌngo̱ tsínj nu̱n ducuaga̱ꞌ da̱j rúnꞌ uꞌyun síꞌ ꞌyaj síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ngaa ni̱ gataj Pilato gunun ni sij: ―Ni̱ huin ruhua á re̱ꞌ sisi̱ gui̱rīj si-rey ni tsínj israelita níꞌ. ―Daj gataj Pilato. ");
INSERT INTO trq_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Daj gaꞌmi Pilato xiꞌí si xacaj sij cuenta sisi̱ nagaꞌuiꞌ ni chrej aꞌninꞌ Jesús rian sij xiꞌí si xicoj ruhua ni síꞌ niꞌyaj ni síꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Sani̱ ducu gahuin duꞌua ni ngüi̱, guiꞌyaj ni chrej aꞌninꞌ sisi̱ gui̱ri Pilato tsínj gu̱ꞌnaj Barrabás ducuaga̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ngaa ni̱ gataj Pilato gunun ni sij: ―Da̱j huin ruhua á re̱ꞌ u̱n sin huin gui̱ꞌyā nga̱ tsínj duguꞌna̱j ni é re̱ꞌ si-rey ni tsínj israelita únj. ―Daj gataj Pilato. ");
INSERT INTO trq_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ngaa ni̱ gaguáj ru̱huaꞌ yún ni sij. Ni̱ gataj ni sij: ―Ga̱ri re̱ꞌ gaquíj Jesús gui̱nicoꞌ sij rian rugutsi̱, ruhua únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Sani̱: ―Daj hua gaquinꞌ guiꞌyaj sij únj. ―Daj gataj Pilato. Sani̱ na̱anj gaguáj ru̱huaꞌ yún ni sij. Ni̱ gataj ni sij: ―Ga̱ri re̱ꞌ gaquíj Jesús gui̱nicoꞌ sij rian rugutsi̱ aj. ―Daj gaguáj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ni̱ ri̱an gahuin ruhua Pilato sisi̱ ga̱huin ꞌueé ruhua ni ngüi̱ ni̱ꞌyaj ni sij manꞌan síꞌ, ngaa ni̱ guiri síꞌ tsínj gu̱ꞌnaj Barrabás ducuaga̱ꞌ. Ngaa ni̱ gaꞌuiꞌ ni sij nneꞌ xiráj Jesús, guiꞌyaj Pilato. Hué dan ni̱ nagaꞌuiꞌ Pilato Jesús rian ni sij sisi̱ ga̱ri ni sij gaquíj síꞌ gui̱nicoꞌ síꞌ rian rugutsi̱. ");
INSERT INTO trq_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ngaa ni̱ nicaj ni snado Jesús ganꞌanj ni sij chruhua palacio daj. Ni̱ nahuin yuꞌ daranꞌ ango ni snado, guiꞌyaj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ni̱ gaꞌníj ni sij ꞌngo̱ atsij rian ru̱miꞌ mare xá Jesús gunun síꞌ. Ni̱ runꞌun ni sij ꞌngo̱ yaꞌa̱ tanj, guiꞌyaj ni sij ꞌngo̱ corona gaꞌníj ni sij chra̱ Jesús nej aj. ");
INSERT INTO trq_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ngaa ni̱ gaxi̱ꞌi ni sij gaguáj ni sij. Ni̱ gataj ni sij: ―Hua ꞌueé ni̱nꞌ si-rey ni tsínj israelita. ―Daj gaguáj ni sij gaꞌmi ducu ni sij niꞌyaj ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ngaa ni̱ gaꞌuiꞌ ni sij ꞌngo̱ rutsi̱ chra̱ Jesús. Ni̱ gara staꞌnunj ni sij rian síꞌ nej. Ni̱ ganiquinꞌ ráj da̱coj ni sij, ni̱ nanoꞌoj ni sij rian Jesús. ");
INSERT INTO trq_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ni̱ ngaa guisíj guiꞌyaj ducu ni sij, ngaa ni̱ guiri ni sij atsij hua rian ru̱miꞌ mare xá Jesús. Ngaa ni̱ naꞌníj ni sij si-ganꞌ Jesús xá manꞌan síꞌ. Hué dan ni̱ guiri ni sij manꞌan síꞌ güenda ga̱ri ni sij gaquíj manꞌan síꞌ gui̱nicoꞌ síꞌ rian rugutsi̱. ");
INSERT INTO trq_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ni̱ huaj tsínj gu̱ꞌnaj Simón Cirene huin síꞌ chrej nu̱ngüej tsínj gu̱ꞌnaj Alejandro nga̱ Rufo ꞌna̱ꞌ sij nasíj sij ducuá sij ganꞌanj sij quij. Ni̱ chranꞌ yunꞌunj ni snado sisi̱ ga̱ta síꞌ si-rugutsi̱ Jesús. ");
INSERT INTO trq_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ni̱ nicaj ni sij Jesús ganꞌanj ni sij ꞌngo̱ yuꞌuj gu̱ꞌnaj Gólgota. Ni̱ nuguanꞌ daj gata ruhuaj dacan cúj chra̱ níman. ");
INSERT INTO trq_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ni̱ gaꞌuiꞌ ni sij vino go̱ꞌo Jesús nachej dugüiꞌ-íꞌ nga̱ gonoꞌo yai̱ꞌ gu̱ꞌnaj mirra. Sani̱ nun ga̱ꞌuej Jesús go̱ꞌo sij mánj. ");
INSERT INTO trq_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Hué dan ni̱ gari ni sij gaquíj Jesús doco̱ꞌ ni sij síꞌ rian rugutsi̱. Ngaa ni̱ ducu ni snado sisi̱ u̱n tsínj ga̱hui sa̱ꞌ ni̱caj ni sij si-ganꞌ Jesús ga̱nꞌanj sij. ");
INSERT INTO trq_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ni̱ guisíj ga u̱n ni̱ganꞌ ngaa gari ni sij gaquíj Jesús doco̱ꞌ ni sij rian rugutsi̱ síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ni̱ garun ni sij letra chra̱ rugutsi̱ u̱n xi̱ꞌi huin dagahuiꞌ ni sij. Ni̱ letra daj ataj: “Si-rey ni tsínj israelita.” Daꞌngaꞌ daj garun ni sij. ");
INSERT INTO trq_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ni̱ doco̱ꞌ ni sij yahuij tsínj rian yahuij rugutsi̱. Ni̱ tsínj tu̱ huin nu̱ngüej síꞌ. Ni̱ nicoꞌ ngo̱j raꞌa sa̱ꞌ Jesús, ni̱ angoj raꞌa ro̱tsi sij. ");
INSERT INTO trq_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ngaa ni̱ gahuin yya da̱j rúnꞌ gataj si-nu̱guanꞌ Yanꞌanj: “Ni̱ gahuin sij da̱j rúnꞌ huin ꞌngo̱ tsínj ꞌyaj gaquinꞌ.” Daj gataj si-nu̱guanꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ni̱ gaꞌmi quij ni ngüi̱ gachin. Ni̱ dugunun ni sij chra̱ ni sij. Ni̱ gataj ni sij: ―Hué re̱ꞌ huin si du̱guane nuhui nico, ni̱ hua̱ꞌnij gue̱ güi na̱guiꞌyaj ru̱huaꞌ yún re̱ꞌ, atáj re̱ꞌ níꞌ. ");
INSERT INTO trq_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ga̱nacaj re̱ꞌ manꞌán re̱ꞌ. Ni̱ ga̱nanij re̱ꞌ rian rugutsi̱ aj. ―Hué daj gataj ni ngüi̱ rian Jesús. ");
INSERT INTO trq_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ni̱ hué ꞌngo̱ nuguanꞌ daj gaꞌmi ducu ni chrej aꞌninꞌ nga̱ ni maestro digyán ley. Ni̱ gataj ni sij: ―Nacaj sij ango ni ngüi̱. Sani̱ naꞌue ga̱nacaj sij manꞌan sij mánj. ");
INSERT INTO trq_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ni̱ hué sij huin Cristo níꞌ. Ni̱ hué sij huin si-rey ni tsínj israelita níꞌ. Na̱nij sij rian rugutsi̱, ni̱ gui̱niꞌi néꞌ. Ni̱ gu̱xuman ruhua néꞌ ni̱ꞌyaj néꞌ manꞌan sij. ―Daj gataj ni sij gaꞌmi ducu ni sij niꞌyaj sij manꞌan Jesús. Ni̱ da nu̱ngüej tsínj nicoꞌ rian rugutsi̱ xiꞌníj Jesús gaꞌmi quij nu̱ngüej sij rian Jesús nej aj. ");
INSERT INTO trq_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ni̱ ngaa guisíj gaxu̱j, ni̱ gahuin ru̱miꞌ rian daranꞌ xungüi̱. Ni̱ gahuin ru̱miꞌ daꞌ ga hua̱ꞌnij diꞌni̱. ");
INSERT INTO trq_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ni̱ hué hora daj ni̱ gaguáj nucuaj Jesús. Ni̱ gataj sij: ―Eloi, Eloi, lama sabactani ―ni̱ snanꞌanj manꞌan sij ruhuaj gata: Danꞌanj manꞌānj, Danꞌanj manꞌānj, u̱n sin huin, ni̱ dunáj re̱ꞌ urīnj únj. Daj huin ruhuaj gata nuguanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ni̱ gunun go̱ꞌngo ni tsínj niquinꞌ yuꞌuj daj si gataj Jesús. Ni̱ gataj ni sij: ―Ni̱ꞌyaj á re̱ꞌ. Aquínj sij ga̱ꞌnaꞌ tsínj gu̱ꞌnaj Elías aj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ngaa ni̱ gunánj ꞌngo̱ ni sij. Ni̱ gutáj sij nnee vino yu̱ rian gachij. Ni̱ gutaꞌ sij gachij daj chra̱ ꞌngo̱ chrun ria̱nj. Ni̱ dugüinꞌ sij gachij daj duꞌua Jesús sisi̱ go̱ꞌo síꞌ. Ni̱ gataj sij: ―Du̱naj á re̱ꞌ. Ni̱ gui̱niꞌíꞌ sisi̱ ga̱ꞌnaꞌ yya tsínj gu̱ꞌnaj Elías di̱nij síꞌ sij rian rugutsi̱ aj. ―Daj gataj tsínj daj. ");
INSERT INTO trq_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Sani̱ gaguáj nucuaj Jesús. Ni̱ gahuiꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ni̱ ꞌngo̱ tsitsiꞌ hui̱j dasu atsij nicoꞌ chruhua nuhui nico daꞌ chraj nga̱ daꞌ xiꞌij. ");
INSERT INTO trq_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ni̱ niquinꞌ ꞌngo̱ snado centurión dugumi sij ne̱ꞌ rian Jesús. Ni̱ ngaa guiniꞌi sij da̱j gahuin ngaa gahuiꞌ Jesús, ni̱ gataj sij: ―Xa̱ngaꞌ ni̱ hué tsínj nan huin daꞌníj Yanꞌanj anj. ―Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ni̱ niquinꞌ ga̱nꞌ gaꞌi̱ ni yunꞌunj xa̱na niꞌyaj ne Jesús. Ni̱ scanij ne niquinꞌ María Magdalena nej, María nni Jacobo tsínj da̱ni nej, nga̱ jnánj síꞌ José nej, Salomé nej. ");
INSERT INTO trq_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ni̱ ngaa gachéj Jesús yuꞌuj gu̱ꞌnaj Galilea, ni̱ guinicoꞌ ni yunꞌunj xa̱na daj ru̱cu síꞌ. Ni̱ chracuij ni yunꞌunj daj manꞌan síꞌ. Ni̱ niquinꞌ nico ango daꞌaj ni yunꞌunj xa̱na nej. Ni̱ guinicaj dugüiꞌ ne nga̱ Jesús ngaa ganꞌanj síꞌ xumanꞌ Jerusalén. ");
INSERT INTO trq_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ngaa ni̱ ruhua guini̱ güi daj güi ngaa guiꞌyaj xugüi ni ngüi̱ israelita xiꞌí aꞌyoj güi naránj ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ngaa ni̱ gaꞌna̱ꞌ ꞌngo̱ tsínj gu̱ꞌnaj José huin tsínj ꞌna̱ꞌ xumanꞌ Arimatea. Ni̱ hué sij huin ꞌngo̱ tsínj sa̱ꞌ. Ni̱ nicaj sun sij nne sij junta. Ni̱ anaꞌuij sij si ga̱ꞌnaꞌ Yanꞌanj gui̱nicaj sunj rian ni ngüi̱. Ngaa ni̱ guisíj ruhua sij ganꞌanj sij rian nne Pilato gachínj sij níman Jesús. ");
INSERT INTO trq_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ni̱ gara yanꞌanj ruhua Pilato sisi̱ hua gahuiꞌ Jesús. Ngaa ni̱ gaquínj sij ga̱ꞌnaꞌ snado centurión rian sij. Ni̱ nachínj snanꞌanj sij síꞌ sisi̱ hua yya gahuiꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ni̱ ngaa nataꞌ snado centurión sisi̱ hua gahuiꞌ Jesús, ngaa ni̱ nagaꞌuiꞌ Pilato níman Jesús raꞌa José. ");
INSERT INTO trq_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ni̱ guiránj José ꞌngo̱ atsij manta. Ni̱ nanij sij Jesús rian rugutsi̱. Ni̱ chriꞌyanj sij atsij daj xiráj níman Jesús. Ni̱ gurúj sij níman chruhua ꞌngo̱ huej rian achinꞌ ni sij níman. Daj si hua gayaꞌ ni sij huej daj. Ni̱ naránj sij yej xxi rian huej daj. ");
INSERT INTO trq_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ni̱ niꞌyaj María Magdalena nga̱ María nni José rian gurúj ni sij chruhua yuꞌuj níman Jesús. ");
INSERT INTO trq_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ni̱ ngaa gachin güi naránj ruhua ni tsínj israelita, ni̱ ganꞌanj María Magdalena nga̱ María nni Jacobo nej, Salomé nej, guiránj ne gasiti guinꞌ da̱j ga̱ri ne níman Jesús. ");
INSERT INTO trq_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ni̱ ngaa ruhua gue̱rengaꞌ ni̱ganꞌ acuanꞌ güi gudungu, ngaa ni̱ ganꞌanj ni yunꞌunj xa̱na daj rian yuꞌuj gachinꞌ ni sij níman. Ni̱ hua niquinꞌ güi. ");
INSERT INTO trq_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ni̱ gataj aninꞌ ne rian ni du̱güiꞌ ne: ―Ni̱ u̱n tsínj ga̱ꞌnej yej xxi hua ránj rian yuꞌuj únj. ―Daj gataj aninꞌ ne gunun ni du̱güiꞌ ne. ");
INSERT INTO trq_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Sani̱ ngaa niꞌyaj aninꞌ ne, ni̱ guiniꞌi ne sisi̱ nitaj si ngaj yej xxi daj rian ngaj ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ni̱ ngaa gatúj ne chruhua yuꞌuj daj, ni̱ guiniꞌi ne nne ꞌngo̱ tsínj ya̱n. Ni̱ nu̱n sij ꞌngo̱ atsij xa̱can ga̱tsi. Ni̱ nne sij ne̱ꞌ chrej raꞌa sa̱ꞌ ni ngüi̱ daj. Ni̱ guxuꞌuiꞌ ne. ");
INSERT INTO trq_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Sani̱ gataj manꞌan sij: ―Si̱ guxuꞌuiꞌ aninꞌ é re̱ꞌ mánj. Nanoꞌ aninꞌ é re̱ꞌ Jesús tsínj ꞌna̱ꞌ xumanꞌ Nazaret huin tsínj guinicoꞌ rian rugutsi̱. Hua ganáꞌnij sij. Nitaj si ngaj si yuꞌuj nan ga̱ mánj. Ni̱ꞌyaj aninꞌ é re̱ꞌ rian gachinꞌ ni sij síꞌ. ");
INSERT INTO trq_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ni̱ güi̱j ga̱taj snanꞌanj aninꞌ é re̱ꞌ gu̱nun ni tsínj nicoꞌ Jesús nga̱ Pedro nej: “Ga̱nꞌanj sini Jesús estado Galilea. Ni̱ yuꞌuj daj gui̱niꞌi ni é re̱ꞌ síꞌ da̱j rúnꞌ gataj síꞌ gunun ni é re̱ꞌ.” ―Daj gataj tsínj daj gunun ni yunꞌunj xa̱na. ");
INSERT INTO trq_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ngaa ni̱ gahui ni yunꞌunj xa̱na daj rian yuꞌuj. Ni̱ gunánj aninꞌ ne ganꞌanj ne xiꞌí si guxuꞌuiꞌ ne. Ni̱ driꞌi ne. Ni̱ nun gaꞌmi ne ni̱ a̱ ꞌngo̱ nuguanꞌ rian ni̱ a̱ ꞌngo̱ ni ngüi̱ xiꞌí si xuꞌuiꞌ ne. ");
INSERT INTO trq_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ni̱ ngaa ganáꞌnij Jesús ni̱ganꞌ güi gudungu, ngaa ni̱ narugüiꞌ sini ya̱n sij rian María Magdalena. Ni̱ hua guiri Jesús ichij nane̱ xi̱ꞌi chruhua cúj niman yunꞌunj xa̱na daj. ");
INSERT INTO trq_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ni̱ ganꞌanj na̱taꞌ únꞌ rian ni tsínj nicaj dugüiꞌ nga̱ Jesús. Ni̱ ma̱n ni tsínj daj nani ruhua ni sij. Ni̱ aco ni sij xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ni̱ ngaa gunun ni síꞌ sisi̱ hua ni̱ꞌnaꞌ Jesús guiniꞌi María Magdalena, sani̱ nun gu̱xuman ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ni̱ ne̱ꞌ ru̱cu do̱j, ni̱ ganahuin ni̱ni Jesús narugüiꞌ sij rian hui̱j tsínj nicoꞌ sij huaj nu̱ngüej síꞌ gui̱sij síꞌ quij. ");
INSERT INTO trq_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ni̱ ganꞌanj na̱taꞌ nu̱ngüej síꞌ rian ango ni tsínj nicoꞌ Jesús. Sani̱ nun gu̱xuman ruhua ni sij si gataj nu̱ngüej síꞌ nej. ");
INSERT INTO trq_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ni̱ ne̱ꞌ ru̱cu, ni̱ narugüiꞌ Jesús rian xa̱n ni tsínj nicoꞌ sij. Ni̱ nne ni tsínj daj rian mesa. Ni̱ chranꞌ Jesús ni sij xiꞌí si tsínj nun gu̱xuman ruhua huin ni sij. Daj si nun gu̱xuman ruhua ni sij si-nu̱guanꞌ ni tsínj hua guiniꞌi manꞌan síꞌ ngaa hua ganáꞌnij manꞌan síꞌ aj. ");
INSERT INTO trq_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ni̱ gataj Jesús gunun ni sij: ―Ga̱nꞌanj a ni é re̱ꞌ ni̱nꞌ ga̱chraꞌ chruhua xungüi̱. Ni̱ na̱taꞌ ni é re̱ꞌ si-nu̱guanꞌānj nuguanꞌ sa̱ꞌ rian daranꞌ ni ngüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ni̱ ni ngüi̱ gu̱xuman ruhua si-nu̱guanꞌānj, ni̱ ga̱taꞌ nnee ni sij, ngaa ni̱ na̱caj Yanꞌanj manꞌan ni sij. Sani̱ ni ngüi̱ na̱ꞌuej ruhua gu̱xuman ruhua si-nu̱guanꞌānj, ni̱ ga̱huin ni sij castigo ni̱ganj ni̱nꞌ, gui̱ꞌyaj Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ni̱ hué nan huin si sa̱ꞌ, gui̱ꞌyaj ni ngüi̱ gu̱xuman ruhua ni̱ꞌyaj manꞌānj. Gui̱ri ni sij nane̱ xi̱ꞌi niman ni ngüi̱ xiꞌí si ga̱ꞌmi ni sij si-xugüi manꞌānj. Ni̱ ga̱ꞌmi ni sij snanꞌanj na̱ca, snanꞌanj nun niꞌi manꞌan ni sij. ");
INSERT INTO trq_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ni̱ gui̱daꞌa ni sij xucuáj huee, sani̱ nitaj si gui̱ꞌyaj xúꞌ ni sij mánj. Ni̱ ga̱ꞌue si go̱ꞌo ni sij veneno, sani̱ nitaj si gui̱ranꞌ ni sij sayun mánj. Ni̱ gu̱taꞌ ni sij raꞌa ni sij xiráj ni ngüi̱ aꞌnanꞌ. Ni̱ na̱huin ni síꞌ nánj. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ni̱ ngaa guisíj gaꞌmi Señor Jesús nuguanꞌ daj, ni̱ ganahui sij xataꞌ na̱nꞌ sij. Ni̱ nahuin raꞌa Yanꞌanj sij. Ni̱ ganꞌanj ga̱ne sij chrej raꞌa sa̱ꞌ manꞌan Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ni̱ gahui ni tsínj nicoꞌ Jesús ganꞌanj ni sij daranꞌ ni xumanꞌ. Ni̱ nataꞌ ni sij nuguanꞌ sa̱ꞌ rian daranꞌ ni ngüi̱. Ni̱ chracuij Señor ni sij nataꞌ ni sij. Ni̱ xiꞌí si sa̱ꞌ nico guiꞌyaj ni sij, ni̱ xacaj ni ngüi̱ cuenta sisi̱ xa̱ngaꞌ si-nu̱guanꞌ Jesús. Amén.");
INSERT INTO trq_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Hua gaꞌi̱ ni tsínj gahuin ruhua ga̱run rian yanj xiꞌí si da̱j gahuin scanij néꞌ. ");
INSERT INTO trq_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ni̱ garun ni sij nuguanꞌ daj da̱j rúnꞌ digyán ni tsínj guiniꞌi daranꞌ si guiꞌyaj Jesús asi̱j sini ya̱n. Ni̱ gaꞌmi ni síꞌ si-nu̱guanꞌ Yanꞌanj rian ni ngüi̱, guiꞌyaj Jesús. Ni̱ gunun ni únj nuguanꞌ digyán ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hué dan ni̱ ganꞌanj xa̱caj sa̱ꞌ manꞌānj cuenta xiꞌí daranꞌ si gahuin asi̱j gaxi̱ꞌi si-nu̱guanꞌ Jesús. Ni̱ gani ruhuāj sisi̱ duguꞌna̱j huin ga̱rūnj ꞌngo̱ yanj ga̱ya re̱ꞌ huín re̱ꞌ Teófilo, tsínj sa̱ꞌ ni̱nꞌ ruhua. Ni̱ huin ruhuāj na̱taꞌ ni̱ca yyāj daꞌ go̱ꞌngo ni nuguanꞌ xiꞌí daranꞌ ni nuguanꞌ gahuin daj. ");
INSERT INTO trq_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ngaa ni̱ ga̱ꞌue ga̱huin yya ruhuá re̱ꞌ sisi̱ xa̱ngaꞌ nuguanꞌ digyán ni sij rián re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ni̱ ngaa gane rey Herodes estado Judea, ni̱ nne ꞌngo̱ chrej gu̱ꞌnaj Zacarías. Ni̱ nicoꞌ sij xiꞌninꞌ gu̱ꞌnaj Abías. Ni̱ nica̱ sij gu̱ꞌnaj Elisabet huin unj daꞌni̱ siꞌni̱ chrej Aarón gane síꞌ asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ni̱ hua ni̱ca niman nu̱ngüej nica̱ tsínj daj rian Yanꞌanj. Ni̱ dagahuin sa̱ꞌ nu̱ngüej nica̱ sij daranꞌ sun aꞌninꞌ Señor rian néꞌ. Ni̱ nitaj gaquinꞌ daꞌui nu̱ngüej sij mánj. ");
INSERT INTO trq_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Sani̱ nitaj daꞌníj nu̱ngüej sij si yatin Elisabet. Ni̱ achij nu̱ngüej sij nej. ");
INSERT INTO trq_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ni̱ ngaa natúj xiꞌninꞌ nicoꞌ Zacarías guiꞌyaj sun ni sij rian Yanꞌanj, ");
INSERT INTO trq_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ni̱ hua ꞌngo̱ güi guiriꞌ níꞌyanj Zacarías gatúj síꞌ chruhua si-nuhui Yanꞌanj gutinꞌ síꞌ siquíj ga̱ca-áꞌ. Daj si daꞌngaꞌ daj hua ducuánj nicaj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ni̱ da hua gue̱ aca siquíj daj, ni̱ achínj jniꞌyaj daranꞌ ni ngüi̱ rian Yanꞌanj mán ne̱ꞌ xe̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ngaa ni̱ gurugüiꞌ ꞌngo̱ ángel ꞌna̱ꞌ rian Señor rian Zacarías. Ni̱ niquinꞌ ángel daj ne̱ꞌ raꞌa sa̱ꞌ nna aca siquíj. ");
INSERT INTO trq_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ni̱ ngaa guiniꞌi Zacarías ángel daj, ni̱ ganꞌanj ruhua sij. Ni̱ ducu guxuꞌuiꞌ sij nej. ");
INSERT INTO trq_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Sani̱ gataj ángel: ―Zacarías, si̱ guxuꞌuíꞌ re̱ꞌ mánj. Daj si hua gunun Yanꞌanj nuguanꞌ gachínj jniꞌyáj re̱ꞌ rian sij. Ni̱ ga̱ꞌnga ꞌngo̱ daꞌníj re̱ꞌ gui̱nicaj nica̱ re̱ꞌ Elisabet. Ni̱ du̱guꞌnaj re̱ꞌ lij daj Juan. ");
INSERT INTO trq_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ni̱ ga̱huin nia̱ꞌ ruhua manꞌán re̱ꞌ. Ni̱ ngaa ga̱ꞌnga lij daj, ni̱ ga̱huin nia̱ꞌ ruhua nico ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ni̱ ga̱huin achij daꞌníj re̱ꞌ rian Yanꞌanj. Ni̱ si̱ goꞌo sij vino nga̱ nnee xunaj mánj. Ni̱ asi̱j nu̱n sij riqui nni sij, ni̱ ga̱ꞌnaꞌ Espíritu Santo rian sij. ");
INSERT INTO trq_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ni̱ ga̱nani ruhua nico ni tsínj israelita xiꞌí si-ga̱quinꞌ ni sij. Ni̱ na̱nicoꞌ ni sij Danꞌanj ni sij, gui̱ꞌyaj daꞌníj re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Hua sini daꞌníj re̱ꞌ táj dian sini ya̱n ga̱ꞌmi sij si-nu̱guanꞌ Yanꞌanj rian ni ngüi̱. Ni̱ da ru̱cu ga̱ꞌnaꞌ manꞌan Señor. Ni̱ da̱j rúnꞌ hua nucuaj si-nu̱guanꞌ tsínj gu̱ꞌnaj Elías asi̱j ná, ni̱ daꞌngaꞌ daj ga̱ꞌmi daꞌníj re̱ꞌ. Ni̱ ga̱nꞌanj na̱ꞌmi ru̱huaꞌ yún ni ngüi̱ nga̱ ni daꞌníj ni síꞌ, gui̱ꞌyaj sij. Ni̱ ga̱huin chru̱n ni ngüi̱ nunun. Ni̱ ga̱che ni síꞌ si-chrej ni ngüi̱ hua ni̱ca niman rian Yanꞌanj, gui̱ꞌyaj sij nej. Ni̱ hué ducuánj daj gui̱ꞌyaj xugüi sij rian ni ngüi̱ sisi̱ na̱huin raꞌa ni sij manꞌan Señor. ―Daj gataj ángel gunun Zacarías. ");
INSERT INTO trq_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ngaa ni̱ nachínj snanꞌanj Zacarías ángel. Ni̱ gataj sij: ―Da̱j ga̱huin yya ruhuāj xiꞌí si-nu̱guanꞌ re̱ꞌ si hua achī nga̱ nicāj nej. ―Gataj Zacarías rian ángel daj. ");
INSERT INTO trq_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ngaa ni̱ gataj ángel daj: ―Huēj huin Gabriel tsínj niquinꞌ rian Yanꞌanj. Ni̱ gaꞌníj manꞌan Yanꞌanj ga̱ꞌnāj ga̱ꞌmī nga̱ re̱ꞌ. Ni̱ ga̱tā nuguanꞌ sa̱ꞌ nan rián re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yya̱j ni̱ ri̱an nun gu̱xuman ruhuá re̱ꞌ nuguanꞌ gaꞌmī rián re̱ꞌ, ni̱ ga̱huín re̱ꞌ ꞌngo̱ tsínj si̱ gaꞌue ga̱ꞌmi da ga̱ꞌnga lij daj. Ni̱ ga̱huin yya da̱j rúnꞌ gatā gunún re̱ꞌ güi gani Yanꞌanj. ―Daj gataj ángel gunun Zacarías. ");
INSERT INTO trq_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Da hua gue̱ da ni̱ mán ni ngüi̱ xe̱ꞌ anaꞌuij ni sij si ga̱hui Zacarías chruhua nuhui. Ni̱ nachínj snanꞌanj ni sij manꞌan dugüiꞌ ni sij u̱n sin huin, ni̱ gahuin ran síꞌ ga̱hui síꞌ chruhua nuhui daj. ");
INSERT INTO trq_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ngaa ni̱ ngaa gahui sij xe̱ꞌ, ni̱ naꞌue ga̱ꞌmi sij nga̱ ni ngüi̱ mánj. Ngaa ni̱ xacaj ni ngüi̱ cuenta sisi̱ gurugüiꞌ ꞌngo̱ rasu̱n guiniꞌi sij chruhua nuhui, guiꞌyaj Yanꞌanj. Ni̱ maan si digyán raꞌa yu̱n sij si naꞌue ga̱ꞌmi sij. ");
INSERT INTO trq_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ngaa gachin güi guiꞌyaj sun Zacarías rian Yanꞌanj chruhua nuhui, ni̱ guina̱nꞌ sij ducuá sij. ");
INSERT INTO trq_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ngaa síj ni̱ guiriꞌ nica̱ sij Elisabet ꞌngo̱ lij. Ni̱ u̱nꞌunꞌ yahui̱ nun gahui unj ducuá unj. ");
INSERT INTO trq_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ni̱ gataj unj gunun manꞌan unj: “Ni̱ guiꞌyaj Yanꞌanj ꞌngo̱ sinduj riānj. Ni̱ güi yya̱j ni̱ si̱ guiriꞌīj si-na̱ꞌāj rian ni ngüi̱ ga̱ mánj.” Daj gani ruhua manꞌan unj. ");
INSERT INTO trq_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ngaa guisíj hua̱tanꞌ yahui̱ gunu̱n riqui Elisabet, ni̱ gaꞌníj Yanꞌanj ángel gu̱ꞌnaj Gabriel ganꞌanj síꞌ ꞌngo̱ xumanꞌ gu̱ꞌnaj Nazaret ngaj rian estado Galilea. ");
INSERT INTO trq_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ni̱ guisíj ángel daj rian nne ꞌngo̱ yunꞌunj xa̱na ya̱n gu̱ꞌnaj-áꞌ María. Ni̱ hua guisíj gahuin yya xa̱caj ꞌngo̱ tsínj gu̱ꞌnaj José manꞌan únꞌ. Ni̱ huin síꞌ daꞌníj daꞌni̱ siꞌni̱ rey David. ");
INSERT INTO trq_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ngaa ni̱ gatúj ángel daj rian nne únꞌ. Ni̱ gataj sij: ―Hua sa̱ꞌ nné re̱ꞌ níꞌ. Guiꞌyaj Yanꞌanj sinduj rián re̱ꞌ. Ni̱ achéj Señor nga̱ re̱ꞌ. Sa̱ꞌ manꞌán re̱ꞌ scanij ni yunꞌunj xa̱na, guiꞌyaj Yanꞌanj. ―Gataj ángel gunun María. ");
INSERT INTO trq_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Sani̱ ngaa guiniꞌi unj ángel, ni̱ gani hui̱j ruhua unj xiꞌí nuguanꞌ gaꞌmi síꞌ. Ni̱ nachínj snanꞌanj unj manꞌan unj u̱n sin huin ruhuaj gata nuguanꞌ daj únj. ");
INSERT INTO trq_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ngaa ni̱ gataj ángel: ―María, si̱ guxuꞌuíꞌ re̱ꞌ mánj. Gahuin nia̱ꞌ ruhua Yanꞌanj, guiꞌyáj re̱ꞌ. Ni̱ hua guiꞌyaj Yanꞌanj ꞌngo̱ sinduj rián re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yya̱j ni̱ gui̱riꞌ re̱ꞌ ꞌngo̱ lij gu̱nun riquí re̱ꞌ. Ni̱ ga̱ꞌnga ꞌngo̱ lij snoꞌo rián re̱ꞌ. Ni̱ du̱guꞌnaj re̱ꞌ lij daj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ni̱ ga̱huin sij ꞌngo̱ tsínj huin achij ni̱nꞌ ruhua. Ni̱ gu̱ꞌnaj sij daꞌníj Yanꞌanj achij nne xataꞌ. Ni̱ ga̱ꞌuiꞌ Yanꞌanj achij xa̱ngaꞌ daj sun gui̱nicaj sij rúnꞌ guinicaj sun xi sij David. ");
INSERT INTO trq_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ni̱ daꞌngaꞌ daj gui̱ꞌyaj Yanꞌanj sisi̱ gui̱nicaj ni̱ganj ni̱nꞌ sij sun rian ni daꞌníj Jacob, huin ni síꞌ ni tsínj israelita. Ni̱ nitaj si hua si ga̱nahuij sun nicaj sij mánj. ―Daj gataj ángel daj gunun María. ");
INSERT INTO trq_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ngaa ni̱ nachínj snanꞌanj María ángel. Ni̱ gataj unj: ―Asa̱ꞌ ga̱ꞌue gui̱riꞌ manꞌānj lij sisi̱ nitaj tsínj snoꞌo nne ngāj únj. ―Gataj María gunun ángel daj. ");
INSERT INTO trq_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ni̱ gataj ángel gunun María: ―Ga̱ꞌnaꞌ Espíritu Santo rián re̱ꞌ. Ni̱ ga̱ꞌnaꞌ si-fuerza Yanꞌanj achij rián re̱ꞌ. Xiꞌí daj gu̱ruj re̱ꞌ ꞌngo̱ lij sa̱ꞌ ni̱nꞌ. Ni̱ daꞌníj Yanꞌanj gu̱ꞌnaj lij gu̱ruj re̱ꞌ daj. ");
INSERT INTO trq_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ni̱ dugüíꞌ re̱ꞌ Elisabet huin ꞌngo̱ yunꞌunj achij. Sani̱ guisíj hua̱tanꞌ yahui̱ nu̱n riqui únꞌ. Ni̱ ataj ni ngüi̱ sisi̱ ꞌngo̱ yunꞌunj xa̱na yatin huin únꞌ. ");
INSERT INTO trq_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nitaj ꞌngo̱ si huaj sisi̱ si̱ gaꞌue gui̱ꞌyaj Yanꞌanj mánj. ―Gataj ángel daj gunun María. ");
INSERT INTO trq_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ngaa ni̱ gataj María: ―Huēj huin ꞌngo̱ yunꞌunj xa̱na ꞌyaj sun rian Señor. Xiꞌí daj ni̱ ga̱ꞌue gui̱ꞌyaj Yanꞌanj ngāj da̱j rúnꞌ gatáj re̱ꞌ gunūnj. ―Daj gataj María gunun ángel. Hué dan ni̱ gahui ángel daj rian María. ");
INSERT INTO trq_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ni̱ hué ni güi daj ni̱ naxu̱man María. Ni̱ gahui unj ganꞌanj yoo̱ unj ꞌngo̱ xumanꞌ ngaj estado Judea. Ni̱ hua dacuj rian gachin unj. ");
INSERT INTO trq_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ni̱ ganꞌanj unj ducuá Zacarías. Ni̱ gatúj unj chruhua hueꞌ. Ni̱ gataj unj gunun Elisabet: ―Hua sa̱ꞌ nné re̱ꞌ níꞌ. ―Daj gataj María. ");
INSERT INTO trq_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ni̱ ngaa gunun Elisabet nuguanꞌ gaꞌmi María, ngaa ni̱ güéj lij riqui únꞌ. Ngaa ni̱ gaꞌna̱ꞌ Espíritu Santo rian únꞌ. ");
INSERT INTO trq_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ni̱ nucuaj gaꞌmi únꞌ rian María. Ni̱ gataj únꞌ: ―Gahuin ꞌueé manꞌán re̱ꞌ scanij ni yunꞌunj xa̱na, guiꞌyaj Yanꞌanj. Ni̱ gahuin ꞌueé lij gu̱chruj re̱ꞌ, guiꞌyaj Yanꞌanj nej. ");
INSERT INTO trq_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ni̱ u̱n sin huīnj si gaꞌna̱ꞌ niꞌyaj nni Señor riānj huín re̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Daj si hué gue̱ hora gunūnj nuguanꞌ gaꞌmí re̱ꞌ riānj, ni̱ gahuin nia̱ꞌ ruhua lij nu̱n riquīj. Ni̱ güéj lij nej. ");
INSERT INTO trq_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ni̱ hua ꞌueé rián re̱ꞌ xiꞌí si guxuman ruhuá re̱ꞌ si-nu̱guanꞌ Yanꞌanj sisi̱ ga̱huin yya da̱j rúnꞌ gataj Yanꞌanj gunún re̱ꞌ aj. ―Daj gataj Elisabet rian María. ");
INSERT INTO trq_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ngaa ni̱ gataj María nuguanꞌ nan: Aꞌmi sa̱ꞌ ꞌueé nimānj rian Señor. ");
INSERT INTO trq_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ni̱ gahuin nia̱ꞌ ruhua nimānj niꞌi nimānj Yanꞌanj huin si nacaj manꞌānj. ");
INSERT INTO trq_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Daj si acaj Yanꞌanj cuenta xiꞌīj huīnj ꞌngo̱ yunꞌunj xa̱na niqui ꞌyaj sun rian Yanꞌanj. Ni̱ asi̱j güi yya̱j ni̱ ga̱ꞌmi sa̱ꞌ ni̱ganj ni ngüi̱ xiꞌí si hua ꞌueé riānj. ");
INSERT INTO trq_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Daj si guiꞌyaj Yanꞌanj nucuaj ꞌngo̱ nuguanꞌ nico ngāj. Ni̱ sa̱ꞌ ni̱nꞌ ruhua hua si-xugüi Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ni̱ ni̱ganj huin ꞌi̱ ruhua Yanꞌanj niꞌya daranꞌ ni ngüi̱ unun rianj. ");
INSERT INTO trq_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ni̱ guiꞌyaj sun nucuaj Yanꞌanj. Ni̱ gunucuaj guiꞌyaj gana Yanꞌanj rian ni tsínj nne̱. Ni̱ ganahuij nuguanꞌ gani nne̱ ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ni̱ guiri Yanꞌanj ni tsínj huin achij huin ni tsínj huin rey rian hua nucuaj nne ni síꞌ. Ni̱ gahuin achij ni tsínj niqui, guiꞌyaj Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ni̱ gara sa̱ꞌ riqui ni ngüi̱ achin xiꞌna̱, guiꞌyaj Yanꞌanj. Ni̱ rani Yanꞌanj ni xuruꞌue na̱nꞌ yu̱n ni sij. ");
INSERT INTO trq_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ni̱ chracuij Yanꞌanj ni tsínj israelita, huin ni sij ni tsínj unánj guitsi rianj. Ni̱ nun guiniꞌyun ruhua Yanꞌanj gahuin ꞌi̱ ruhuaj guiniꞌya ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ni̱ daꞌngaꞌ daj hua gataj yya Yanꞌanj gunun Abraham nga̱ ango xi néꞌ. Ni̱ xiꞌí daj huin ꞌi̱ ruhua Yanꞌanj niꞌya néꞌ ni̱ganj xiꞌí si huin néꞌ ni daꞌníj daꞌni̱ siꞌni̱ Abraham. Daj gataj María. ");
INSERT INTO trq_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ni̱ hua̱ꞌnij yahui̱ guna María ducuá Elisabet. Rúnꞌ síj ni̱ na̱nꞌ únꞌ ducuá únꞌ. ");
INSERT INTO trq_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ni̱ ngaa guisíj güi ga̱ꞌnga daꞌníj Elisabet, ni̱ gaꞌnga ꞌngo̱ lij snoꞌo, guiꞌyaj únꞌ. ");
INSERT INTO trq_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ni̱ ngaa gunun ni dugüiꞌ únꞌ sisi̱ ni̱nꞌ ruhua gahuin ꞌi̱ ruhua Yanꞌanj niꞌya únꞌ, ni̱ gahuin nia̱ꞌ ruhua ni sij xiꞌí únꞌ. ");
INSERT INTO trq_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ngaa guisíj lij itu̱nj güi, ni̱ gaꞌna̱ꞌ ni tsínj gu̱taꞌ daꞌngaꞌ nnee̱ lij daj. Ni̱ huin ruhua ni sij du̱guꞌnaj ni sij lij rúnꞌ gu̱ꞌnaj chre-éꞌ Zacarías. ");
INSERT INTO trq_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Sani̱ gataj nni lij daj: ―Si̱ gaꞌue mánj. Si-xugüi lij nan huin Juan. ―Daj gataj nni lij. ");
INSERT INTO trq_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ngaa ni̱ gataj ni sij: ―Ni̱ a̱ ꞌngo̱ ni dugüíꞌ re̱ꞌ nitaj si gu̱ꞌnaj da mánj. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ngaa ni̱ nachínj snanꞌanj raꞌa yu̱n ni sij chrej lij daj sisi̱ gui̱niꞌi ni sij da̱j du̱guꞌnaj síꞌ lij daj. ");
INSERT INTO trq_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ngaa ni̱ gachínj chrej lij daj ꞌngo̱ ruguechraꞌ le ga̱run síꞌ. Ni̱ garun síꞌ: “Juan gu̱ꞌnaj si-xugüi lij.” Daj garun síꞌ. Ni̱ gahuin yanꞌanj ruhua daranꞌ ni sij xiꞌí nuguanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ngaa ni̱ ꞌngo̱ hora ni̱ gaꞌue gaꞌmi Zacarías. Ni̱ gaxi̱ꞌi síꞌ gaꞌmi sa̱ꞌ ꞌueé síꞌ rian Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ni̱ gara yanꞌanj ruhua daranꞌ ni ngüi̱ nne ni̱chrunꞌ xiꞌí si guiranꞌ Zacarías. Ni̱ gunun daranꞌ ni ngüi̱ mán ni̱nꞌ ga̱chraꞌ ni dacan estado Judea xiꞌí ni nuguanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ni̱ gaꞌníj daranꞌ ni ngüi̱ gunun ni nuguanꞌ daj chruhua cúj niman ni sij. Ni̱ nachínj snanꞌanj ni sij ni manꞌan dugüiꞌ ni sij. Ni̱ gataj ni sij: “Ni̱ u̱n tsínj ga̱huin lij da únj.” Gataj ni sij. Daj duꞌua ni sij xiꞌí si guiꞌyaj sa̱ꞌ ꞌueé Yanꞌanj nga̱ lij daj. ");
INSERT INTO trq_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ni̱ gaꞌna̱ꞌ ꞌueé Espíritu Santo rian chrej lij daj huin tsínj gu̱ꞌnaj Zacarías. Ni̱ gataj sij: ");
INSERT INTO trq_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ga̱ꞌmi sa̱ꞌ néꞌ rian Señor huin Danꞌanj ni tsínj israelita. Daj si gaꞌna̱ꞌ ni̱ꞌyaj sij ni tsínj nicoꞌ sij. Ni̱ gaꞌna̱ꞌ na̱caj sij ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ni̱ gaꞌníj Yanꞌanj ꞌngo̱ tsínj nucuaj gaꞌna̱ꞌ na̱caj yu̱nꞌ huin síꞌ ꞌngo̱ daꞌni̱ siꞌni̱ David. Ni̱ David huin ꞌngo̱ tsínj gunánj guitsi rian Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ni̱ daꞌngaꞌ daj gataj ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj, guiꞌyaj Yanꞌanj asi̱j ngaa ná. ");
INSERT INTO trq_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ni̱ nacaj Yanꞌanj néꞌ rian ni tsínj ununꞌ nga̱ néꞌ nga̱ rian daranꞌ ni tsínj nun huin xa̱nꞌ ruhua niꞌyaj néꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ni̱ daꞌngaꞌ daj ga̱huin ꞌi̱ ruhua Yanꞌanj niꞌya ni xi néꞌ da̱j rúnꞌ gataj yya sij rian ni síꞌ. Ni̱ na̱nun ruhua Yanꞌanj da̱j guiꞌyaj yya sij nuguanꞌ sa̱ꞌ nga̱ ni síꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Ni̱ gaꞌmi ni̱ca yya Yanꞌanj rian xíꞌ Abraham sisi̱ ga̱huin níꞌnij néꞌ rian ni tsínj ununꞌ nga̱ néꞌ, gui̱ꞌyaj Yanꞌanj. Ngaa ni̱ si̱ guxuꞌuiꞌ néꞌ gui̱ꞌyaj sun néꞌ rian Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ni̱ ga̱huin sa̱ꞌ niman néꞌ rian Yanꞌanj. Ni̱ ga̱huin ni̱ca niman néꞌ daranꞌ güi gui̱man néꞌ. Daj gataj Zacarías. ");
INSERT INTO trq_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ngaa ni̱ gaxi̱ꞌi Zacarías gaꞌmi sij rian daꞌníj sij. Ni̱ gataj sij: Ni̱ ga̱huin so̱ꞌ ꞌngo̱ tsínj ga̱ꞌmi sini si-nu̱guanꞌ Yanꞌanj achij nne xataꞌ asi̱j nun ga̱ꞌnaꞌ manꞌan Señor. Ni̱ gui̱ꞌyaj xugüí re̱ꞌ si-chrej manꞌan Señor. ");
INSERT INTO trq_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ni̱ di̱gyán so̱ꞌ rian ni ngüi̱ nicoꞌ Señor sisi̱ nicaj sij niman nico xiꞌí si-ga̱quinꞌ ni síꞌ. Ngaa ni̱ ga̱ꞌue xa̱caj ni síꞌ cuenta sisi̱ na̱caj Yanꞌanj ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ni̱ daꞌngaꞌ daj ga̱huin si huin ꞌi̱ ni̱nꞌ ruhua Yanꞌanj niꞌya néꞌ. Ni̱ da̱j rúnꞌ xigui̱n ꞌyaj güi ne̱ꞌ ni̱ganꞌ, ni̱ daꞌngaꞌ daj gui̱xiguin chruhua niman néꞌ, gui̱ꞌyaj Yanꞌanj ngaa ga̱ꞌnaꞌ Señor ne̱ꞌ xataꞌ rian néꞌ aj. ");
INSERT INTO trq_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ni̱ gui̱xiguin rian ni ngüi̱ mán rian ru̱miꞌ huin ni ngüi̱ xuꞌuiꞌ xiꞌí si ga̱huiꞌ ni sij. Ngaa ni̱ ga̱huin dinꞌinj rian néꞌ ga̱che néꞌ, gui̱ꞌyaj Yanꞌanj. Daj gataj Zacarías rian daꞌníj sij. ");
INSERT INTO trq_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ngaa ni̱ gachij lij daj. Ni̱ gahuin nucuaj niman sij. Ni̱ gane sij quij quiꞌyanj na̱co daꞌ güi gaxi̱ꞌi sij nataꞌ sij si-nu̱guanꞌ Yanꞌanj rian ni tsínj israelita. ");
INSERT INTO trq_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Hué ni güi daj ni̱ gaꞌninꞌ rey gu̱ꞌnaj Augusto César sun rian ni tsínj mán ni̱nꞌ ga̱chraꞌ chruhua xungüi̱ sisi̱ na̱chi nicaj ni sij ꞌngo̱ yanj censo. ");
INSERT INTO trq_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ni̱ tsínj gu̱ꞌnaj Cirenio gahuin gobernado gane síꞌ estado Siria ngaa guiꞌyaj sini ya̱n ni sij yanj censo daj. ");
INSERT INTO trq_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ni̱ ganꞌanj daranꞌ ni ngüi̱ xánj ni sij gu̱taꞌ ni sij si-xugüi ni sij rian yanj. ");
INSERT INTO trq_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ngaa ni̱ gahui José xumanꞌ Nazaret xumanꞌ ngaj estado Galilea. Ni̱ gachin sij xumanꞌ Belén, xumanꞌ ngaj estado Judea huin rian gaꞌnga rey David. Daj si huin Jesús daꞌníj daꞌni̱ siꞌni̱ síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ni̱ ganꞌanj gu̱taꞌ nu̱guanꞌan sij si-xugüi sij nga̱ María rian yanj. Ni̱ huin ruhua nu̱ngüej sij xa̱caj nu̱ngüej sij dugüiꞌ sij. Ni̱ nu̱n riqui manꞌan únꞌ. ");
INSERT INTO trq_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ni̱ ngaa gane nu̱ngüej sij xumanꞌ Belén, ni̱ guisíj güi ga̱ꞌnga lij, gui̱ꞌyaj María. ");
INSERT INTO trq_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ni̱ gaꞌnga ꞌngo̱ lij xa̱huaꞌ, guiꞌyaj María huin-ínꞌ lij snoꞌo. Ni̱ chriꞌyanj únꞌ atsij lij daj. Ni̱ gaꞌníj únꞌ chruhua rio̱ xa xucu si nitaj si hua níꞌnij ꞌngo̱ lugua guna nu̱ngüej sij chruhua mesón. ");
INSERT INTO trq_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ni̱ ni̱chrunꞌ xumanꞌ Belén daj, ni̱ mán ni tsínj dugumi dán ni sij xachij. ");
INSERT INTO trq_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ngaa ni̱ gurugüiꞌ ꞌngo̱ si-ángel Yanꞌanj rian ni sij. Ni̱ guixigui̱n ꞌngo̱ yanꞌa̱n ganica̱j xiꞌníj ni sij, guiꞌyaj Yanꞌanj nej. Ni̱ ducu guxuꞌuiꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Sani̱ gataj ángel gunun ni sij: ―Si̱ guxuꞌuiꞌ ni é re̱ꞌ mánj. Daj si ni̱cā ꞌngo̱ nuguanꞌ sa̱ꞌ ꞌnāj rian ni é re̱ꞌ. Ni̱ ga̱huin nia̱ꞌ ni̱nꞌ ruhua daranꞌ ni ngüi̱, gui̱ꞌyaj nuguanꞌ nan. ");
INSERT INTO trq_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yya̱j ni̱ gaꞌnga ꞌngo̱ lij xánj David huin sij Cristo. Ni̱ ga̱nacaj sij ni ngüi̱. Ni̱ huin sij Señor nej. ");
INSERT INTO trq_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ni̱ hué nan huin ꞌngo̱ daꞌngaꞌ si da̱j ga̱ꞌue na̱riꞌ ni é re̱ꞌ lij daj. Ni̱ na̱riꞌ ni é re̱ꞌ lij daj chruhua rio̱ xa xucu. ―Gataj ángel gunun ni tsínj dugumi xachij daj. ");
INSERT INTO trq_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ni̱ hué ꞌngo̱ hora gue̱ daj, ni̱ gurugüiꞌ nico ni ángel mán xataꞌ ni̱chrunꞌ rian ángel daj. Ni̱ gaꞌmi sa̱ꞌ ni sij rian Yanꞌanj. Ni̱ gataj ni sij: ");
INSERT INTO trq_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ga̱ꞌmi sa̱ꞌ ꞌueé néꞌ rian Yanꞌanj achij nne xataꞌ. Ni̱ ga̱huin dinꞌinj chruhua ni ngüi̱ huin ni ngüi̱ hua sa̱ꞌ niman. Daj gataj ni ángel daj. ");
INSERT INTO trq_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ni̱ ngaa na̱nꞌ ni ángel xataꞌ, ni̱ gaxi̱ꞌi gaꞌmi ni tsínj dugumi xachij gataj ni sij gunun ni dugüiꞌ ni sij: ―Ga̱nꞌanj néꞌ xumanꞌ Belén gui̱niꞌi néꞌ si gahuin da̱j rúnꞌ gataj Señor gunun néꞌ. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Hué dan ni̱ ganꞌanj yoo̱ ni sij, ni̱ nariꞌ ni sij María nga̱ José. Ni̱ nariꞌ ni sij lij nu̱n-únꞌ chruhua rio̱ xa xucu. ");
INSERT INTO trq_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ni̱ ngaa guiniꞌi ni sij lij, ngaa ni̱ nataꞌ ni sij nuguanꞌ gaꞌníj Yanꞌanj rian ni sij xiꞌí lij rian ni ngüi̱ mán yuꞌuj daj. ");
INSERT INTO trq_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ni̱ gahuin yanꞌanj ruhua daranꞌ ni ngüi̱ gunun nuguanꞌ nataꞌ ni tsínj dugumi xachij daj. ");
INSERT INTO trq_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ni̱ gaꞌníj María daranꞌ nuguanꞌ daj chruhua cúj niman unj. Ni̱ gani sa̱ꞌ ruhua unj xiꞌí si guiꞌyaj sa̱ꞌ Yanꞌanj nga̱ unj. ");
INSERT INTO trq_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Hué dan ni̱ guina̱nꞌ ni tsínj dugumi xachij daj. Ni̱ gaꞌmi sa̱ꞌ ꞌueé ni sij rian Yanꞌanj xiꞌí daranꞌ ni nuguanꞌ gunun ni sij nga̱ si guiniꞌi ni sij. Daj si rúnꞌ gataj ángel, ni̱ daꞌngaꞌ daj gahuin daranꞌ anj. ");
INSERT INTO trq_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ni̱ ngaa gachin itu̱nj güi, ni̱ gutaꞌ ni sij daꞌngaꞌ nnee̱ lij daj. Ni̱ duguꞌna̱j ni sij lij Jesús si hua gataj ángel rian María sisi̱ daꞌngaꞌ daj gu̱ꞌnaj lij daj asi̱j nun gahuin guiriꞌ únꞌ lij daj. ");
INSERT INTO trq_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ni̱ ngaa guisíj ni güi ganahuin sa̱ꞌ María rúnꞌ ataj ni̱ca si-ley Moisés, ni̱ nicaj nu̱ngüej sij lij ganꞌanj sij xumanꞌ Jerusalén na̱gaꞌuiꞌ nu̱ngüej sij lij daj rian Señor. ");
INSERT INTO trq_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ni̱ daꞌngaꞌ daj guiꞌyaj nu̱ngüej sij si hua ni̱ca yya rian si-ley Señor sisi̱ go̱ꞌngo daꞌníj ni ngüi̱ israelita tsínj xa̱huaꞌ ga̱huin siꞌyaj Señor. ");
INSERT INTO trq_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ni̱ ganꞌanj ga̱ꞌuiꞌ nu̱ngüej sij xucu rian Yanꞌanj da̱j rúnꞌ gaꞌninꞌ si-ley Señor sun rian ni tsínj israelita. Ni̱ ga̱ꞌue ga̱ꞌuiꞌ ni sij hui̱j xuꞌma̱n, asi̱ ga̱ꞌue ga̱ꞌuiꞌ ni sij hui̱j gucu̱ nej. ");
INSERT INTO trq_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ni̱ ngaa daj nne ꞌngo̱ tsínj gu̱ꞌnaj Simeón xumanꞌ Jerusalén. Ni̱ ꞌngo̱ tsínj ꞌyaj ni̱ca huin sij. Ni̱ nicoꞌ ꞌueé sij Yanꞌanj nej. Ni̱ anaꞌuij sij si ga̱nani ni ngüi̱ israelita, gui̱ꞌyaj Yanꞌanj. Ni̱ nne Espíritu Santo nga̱ sij nej. ");
INSERT INTO trq_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ni̱ hua gataj Espíritu Santo rian tsínj daj sisi̱ si̱ gahuiꞌ sij da̱ gui̱niꞌi yya sij tsínj sa̱ꞌ ga̱ꞌnij Señor rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ni̱ gaꞌníj Espíritu Santo ga̱nꞌanj sij nuhui nico. Ni̱ nicaj José nga̱ María lij Jesús gatúj nu̱ngüej sij chruhua nuhui nej. Ni̱ huin ruhua nu̱ngüej sij gui̱ꞌyaj nu̱ngüej sij xiꞌí Jesús da̱j rúnꞌ gaꞌninꞌ si-ley Yanꞌanj sun rian ni tsínj israelita. ");
INSERT INTO trq_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ngaa ni̱ ganaꞌyanj Simeón lij Jesús. Ni̱ gaꞌmi sa̱ꞌ ꞌueé sij rian Yanꞌanj. Ni̱ gataj sij: ");
INSERT INTO trq_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Yya̱j ni̱ guisíj yya da̱j rúnꞌ gatáj re̱ꞌ riānj. Ngaa ni̱ ga̱ꞌue ri̱qui re̱ꞌ sisi̱ ga̱huiꞌ dinꞌīn huīnj ꞌngo̱ tsínj ꞌyaj sun rián re̱ꞌ, Señor. ");
INSERT INTO trq_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Daj si hua guiniꞌīnj sisi̱ gaꞌna̱ꞌ tsínj ga̱nacaj ni únj. ");
INSERT INTO trq_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ni̱ guiꞌyáj re̱ꞌ daj rian daranꞌ ni ngüi̱ ma̱n chruhua xungüi̱ nan. ");
INSERT INTO trq_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ni̱ da̱j rúnꞌ huin ꞌngo̱ yanꞌa̱n xigui̱n, daꞌngaꞌ daj ga̱huin lij nan rian ni ngüi̱ ꞌna̱ꞌ anéj chrej. Ni̱ ga̱ꞌmi sa̱ꞌ ni ngüi̱ xiꞌí ni únj, ni tsínj israelita, gui̱ꞌyaj sij nej. Daj si nicoꞌ ni únj manꞌán re̱ꞌ. Daj gataj Simeón gunun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ni̱ gahuin yanꞌanj ruhua José nga̱ María si gataj Simeón xiꞌí lij Jesús. ");
INSERT INTO trq_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ngaa ni̱ gachínj jniꞌyaj Simeón rian Yanꞌanj sisi̱ ga̱huin ꞌueé rian aninꞌ sij, gui̱ꞌyaj Yanꞌanj. Ni̱ gataj sij gunun María huin unj nni Jesús: ―Ngaa ga̱chij lij nan, ni̱ gu̱nunꞌ nico ni ngüi̱ israelita xiꞌí síꞌ. Ni̱ ga̱ niꞌya ni sij nej. Sani̱ gu̱xuman ruhua ango daꞌaj ni sij ni̱ꞌyaj ni sij síꞌ. Sani̱ ga̱ꞌmi xi̱ꞌi ni tsínj ununꞌ nga̱ síꞌ xiꞌí síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Daꞌngaꞌ daj ga̱ꞌue gui̱niꞌi néꞌ da̱j hua niman nico ni ngüi̱, gui̱ꞌyaj síꞌ. Ni̱ ducu gui̱ranꞌ niman manꞌán re̱ꞌ sayun xiꞌí sij nej. ―Gataj Simeón gunun María. ");
INSERT INTO trq_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ni̱ nne ꞌngo̱ yunꞌunj xa̱na achij gaꞌmi si-nu̱guanꞌ Yanꞌanj, gu̱ꞌnaj únꞌ Ana. Ni̱ huin únꞌ daꞌníj tsínj gu̱ꞌnaj Fanuel. Ni̱ huin síꞌ xiꞌninꞌ gu̱ꞌnaj Aser. Ni̱ achij ni̱nꞌ ruhua únꞌ. Ni̱ hua le xacaj únꞌ tsínj snoꞌo. Ni̱ gane nu̱ngüej nica̱ únꞌ ichi̱j yoꞌ, ni̱ gahuiꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ni̱ gahuin únꞌ yunꞌunj mmij ga̱nꞌanj xia ga̱nꞌanj yoꞌ. Ni̱ nitaj si ꞌyaj únꞌ gahui únꞌ chruhua nuhui. Ni̱ nugüi ni̱ganꞌ guiꞌyaj sun únꞌ rian Yanꞌanj. Ni̱ guiꞌyaj únꞌ ayuno. Ni̱ gachínj jniꞌyaj únꞌ rian Yanꞌanj nej. ");
INSERT INTO trq_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ni̱ hué gue̱ hora daj guisíj únꞌ. Ni̱ gaxi̱ꞌi únꞌ nagaꞌuiꞌ únꞌ si guruhua Yanꞌanj. Ni̱ gaꞌmi únꞌ xiꞌí lij Jesús rian daranꞌ ni ngüi̱ mán anaꞌuij sisi̱ na̱caj Yanꞌanj ni ngüi̱ mán xumanꞌ Jerusalén. ");
INSERT INTO trq_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ni̱ ngaa guisíj dagahuin nu̱ngüej nica̱ José daranꞌ si gaꞌninꞌ si-ley Señor rian ni ngüi̱ israelita, ngaa ni̱ na̱nꞌ nu̱ngüej sij xánj sij xumanꞌ Nazaret, huin xumanꞌ ngaj estado Galilea. ");
INSERT INTO trq_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ni̱ gachij lij Jesús. Ni̱ gahuin nucuaj sij. Ni̱ gahuin chru̱n sa̱ꞌ sij si si̱caꞌ chra̱ sij. Ni̱ guiꞌyaj Yanꞌanj sinduj rian sij. ");
INSERT INTO trq_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ni̱ daranꞌ yoꞌ huanꞌanj nu̱ngüej nica̱ José guiꞌyanj pascua xumanꞌ Jerusalén. ");
INSERT INTO trq_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ni̱ ngaa guisíj Jesús xu̱huij yoꞌ, ngaa ni̱ ganꞌanj aninꞌ sij guiꞌyanj daj si daꞌngaꞌ daj hua si-costumbre ni sij. ");
INSERT INTO trq_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ngaa guisíj gachin guiꞌyanj, ni̱ huaj na̱nꞌ José nga̱ María nasíj nu̱ngüej sij ducuá sij. Ni̱ gunáj tsinꞌ Jesús xumanꞌ Jerusalén. Sani̱ nun xacaj nu̱ngüej sij cuenta. ");
INSERT INTO trq_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ni̱ ri̱an gani ruhua nu̱ngüej sij sisi̱ huaj Jesús scanij ni dugüiꞌ sij, ni̱ gachéj nu̱ngüej sij nugüi. Hué dan ni̱ nanoꞌ nu̱ngüej sij scanij ni dugüiꞌij. ");
INSERT INTO trq_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ni̱ ngaa naꞌue na̱riꞌ nu̱ngüej sij Jesús, ni̱ nanica̱j ru̱huaꞌ yún sij Jerusalén nanoꞌ nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ni̱ gachin hua̱ꞌnij güi da nariꞌ nu̱ngüej sij Jesús chruhua nuhui, nne síꞌ da̱ni ni tsínj digyán ley unun síꞌ si aꞌmi ni sij. ");
INSERT INTO trq_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ni̱ gahuin yanꞌanj ruhua daranꞌ ni sij ngaa gunun ni sij nuguanꞌ sa̱ꞌ gaꞌmi Jesús. Daj si chru̱n sa̱ꞌ síꞌ, ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ni̱ ngaa guiniꞌi chre nga̱ nni, ni̱ ganꞌanj ruhua nu̱ngüej sij. Ni̱ gataj nni Jesús gunun síꞌ: ―Daꞌníꞌ, ni̱ u̱n sin huin, ni̱ ꞌyáj so̱ꞌ nánj únj. Chré so̱ꞌ nga̱ manꞌānj nanoꞌ únj so̱ꞌ. Ni̱ huéj taꞌ ataꞌ niman nu̱ngüej únj chré so̱ꞌ nanoꞌ únj so̱ꞌ aj. ―Daj gataj nni Jesús. ");
INSERT INTO trq_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Sani̱ gataj Jesús: ―Ni̱ u̱n sin huin ni̱ nanoꞌ nu̱ngüej é re̱ꞌ yūnj únj. Nun niꞌi nu̱ngüej é re̱ꞌ sisi̱ hua nia̱n gui̱ꞌyaj sūnj si-sun chrē a̱ꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Sani̱ nun gara daꞌngaꞌ ruhua nu̱ngüej nica̱ sij si gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ngaa ni̱ nanica̱j Jesús na̱nꞌ síꞌ nga̱ nu̱ngüej sij xumanꞌ Nazaret. Ni̱ dagahuin síꞌ daranꞌ si ataj nu̱ngüej sij. Ni̱ gaꞌníj nni Jesús ni nuguanꞌ sa̱ꞌ daj cúj niman unj. ");
INSERT INTO trq_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ni̱ gachij Jesús gahuin sij tsínj. Ni̱ gahuin chru̱n sa̱ꞌ sij. Ni̱ garanꞌ ruhua Yanꞌanj niꞌya sij. Ni̱ garanꞌ ruhua ni ngüi̱ niꞌyaj ni sij Jesús nej. ");
INSERT INTO trq_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ni̱ ngaa guisíj xi̱nunꞌ yoꞌ gaꞌninꞌ rey gu̱ꞌnaj Tiberio César sun, ni̱ huin tsínj gu̱ꞌnaj Poncio Pilato gobernado estado Judea. Ni̱ tsínj gu̱ꞌnaj Herodes gaꞌninꞌ sun estado Galilea. Ni̱ jnánj sij Felipe gaꞌninꞌ sun estado Iturea nga̱ Traconite. Ni̱ gaꞌninꞌ tsínj gu̱ꞌnaj Lisanias sun estado Abilinia. ");
INSERT INTO trq_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ni̱ nu̱ngüej chrej aꞌninꞌ huin Anás nga̱ Caifás. Ni̱ hué ni güi daj, ni̱ riqui Yanꞌanj si-nu̱guanꞌanj rian tsínj gu̱ꞌnaj Juan ngaa gachéj síꞌ riqui quij quiꞌyanj na̱co huin síꞌ daꞌníj Zacarías. ");
INSERT INTO trq_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ni̱ gachéj Juan daranꞌ yuꞌuj ngaj ni̱chrunꞌ duꞌua xinéj nnee gu̱ꞌnaj Jordán. Ni̱ gataj sij gunun ni ngüi̱ sisi̱ ga̱nani ruhua ni sij xiꞌí si-ga̱quinꞌ ni sij. Ni̱ na̱nicoꞌ ni sij Yanꞌanj. Ni̱ ga̱taꞌ nnee ni sij. Ngaa ni̱ ga̱ꞌue gui̱nicaj Yanꞌanj niman nico xiꞌí si-ga̱quinꞌ ni sij nej. Daj gataj Juan. ");
INSERT INTO trq_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ni̱ daꞌngaꞌ daj gahuin da̱j rúnꞌ ataj nuguanꞌ garun tsínj gu̱ꞌnaj Isaías ꞌngo̱ tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj xa̱ngaꞌ asi̱j ná. Ni̱ hué nan huin si garun síꞌ: Unun néꞌ si-na̱ne ꞌngo̱ tsínj aꞌmi nucuaj ꞌngo̱ yuꞌuj quiꞌyanj na̱co aj. Ni̱ ataj síꞌ sisi̱ na̱guiꞌyaj xugüi néꞌ si-chrej Señor. Ni̱ na̱guiꞌyaj ni̱ca néꞌ niman néꞌ xiꞌí si ga̱ꞌnaꞌ Señor rian néꞌ. ");
INSERT INTO trq_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ni̱ na̱guiꞌyaj ni̱ca néꞌ rian atúj gaꞌman. Ni̱ ga̱ꞌne néꞌ dacan sisi̱ na̱huin ni̱ca chrej daj. Ni̱ na̱guiꞌyaj ni̱ca néꞌ chrej cuyu̱ daj nej. Ni̱ na̱guiꞌyaj ta néꞌ rian chrej quij hua ta nej aj. ");
INSERT INTO trq_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ni̱ gui̱niꞌi daranꞌ ni ngüi̱ ma̱n chruhua xungüi̱ da̱j na̱caj Yanꞌanj néꞌ. Daj garun Isaías xiꞌí Juan asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ni̱ guisíj nico ni ngüi̱ rian Juan xiꞌí si huin ruhua ni sij ga̱taꞌ nnee ni sij, gui̱ꞌyaj Juan. Ni̱ gataj síꞌ gunun ni sij: ―Daꞌníj xucuáj huin a ni é re̱ꞌ aj. Ni̱ u̱n tsínj gataj chru̱n rian a ni é re̱ꞌ sisi̱ gu̱nánj a ni é re̱ꞌ, ni̱ ga̱nani a ni é re̱ꞌ rian castigo nico, gui̱ꞌyaj Yanꞌanj únj. ");
INSERT INTO trq_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sisi̱ hua yya gahuin sa̱ꞌ niman án re̱ꞌ, ngaa ni̱ ga̱nꞌanj gui̱ꞌyaj á re̱ꞌ da̱j rúnꞌ ꞌyaj ni ngüi̱ gahuin sa̱ꞌ niman anj. Ni̱ si̱ gani ruhua á re̱ꞌ sisi̱ xiꞌí si daꞌníj Abraham huin a ni é re̱ꞌ, ngaa ni̱ nitaj gaquinꞌ daꞌui a ni é re̱ꞌ mánj. Daj si atā gu̱nun a ni é re̱ꞌ sisi̱ yej ngaj nan, ni̱ ga̱ꞌue gui̱ꞌyaj Yanꞌanj daꞌníj Abraham. ");
INSERT INTO trq_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ni̱ a̱ hua chru̱n gagaꞌ hacha ga̱ꞌnij sij yaꞌa̱ siu̱ ni chrun. Ni̱ da̱j rúnꞌ ꞌyaj ꞌngo̱ tsínj nga̱ gagaꞌ hacha, ni̱ daꞌngaꞌ daj gui̱ꞌyaj Yanꞌanj nga̱ daranꞌ chrun nitaj si ayu chruj sa̱ꞌ chra̱. Ni̱ ga̱ꞌnij Yanꞌanj ni chrun daj ga̱ca-áꞌ rian yanꞌa̱n. ―Gataj Juan gunun ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ngaa ni̱ nachínj snanꞌanj ni ngüi̱ Juan. Ni̱ gataj ni sij: ―Da̱j gui̱ꞌyaj únj, ruhuá re̱ꞌ únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ni̱ gataj Juan: ―Tsínj nu̱n hui̱j atsij, ni̱ ga̱ꞌuiꞌ sij gu̱nun tsínj nitaj si-ganꞌ. Ni̱ tsínj nicaj si xa sij, ni̱ ga̱ꞌuiꞌ sij xa̱ tsínj nitaj si nicaj xa̱ aj. ―Daj gataj Juan. ");
INSERT INTO trq_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ni̱ gahuin ni̱chrunꞌ go̱ꞌngo ni tsínj aꞌnej sanꞌanj pesto si ga̱taꞌ nnee ni sij. Ni̱ nachínj snanꞌanj ni sij Juan. Ni̱ gataj ni sij: ―Maestro, da̱j gui̱ꞌyaj ni únj, ruhua á re̱ꞌ únj. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ni̱ gataj Juan: ―Si̱ gaꞌnej xa̱can ni é re̱ꞌ sanꞌanj mánj. Da̱j rúnꞌ aꞌninꞌ ley sun daꞌngaꞌ daj ga̱ꞌnej a ni é re̱ꞌ sanꞌanj rian ni ngüi̱ aj. ―Gataj Juan gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ni̱ hué daj nachínj snanꞌanj ni snado Juan nej. Ni̱ gataj ni sij: ―Da̱j gui̱ꞌyaj ni únj, ruhuá re̱ꞌ únj. ―Gataj ni sij. Ni̱ gataj Juan: ―Si̱ guiꞌyaj fuerza á re̱ꞌ sisi̱ ga̱ꞌuiꞌ ni ngüi̱ sanꞌanj rian án re̱ꞌ mánj. Ni̱ si̱ gaꞌuiꞌ yu̱n ni é re̱ꞌ gaquinꞌ ni ngüi̱ güenda si gui̱ri ni é re̱ꞌ siꞌyaj ni sij mánj. Ni̱ ga̱huin nia̱ꞌ ruhua á re̱ꞌ nga̱ duꞌue ni é re̱ꞌ nej. ―Daj gataj Juan gunun ni snado. ");
INSERT INTO trq_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ni̱ gani ruhua ni ngüi̱ sisi̱ si ruhuaj, ni̱ Juan huin Cristo. Xiꞌí daj ni̱ anaꞌuij ni sij sisi̱ ga̱taj Juan u̱n tsínj huin manꞌan síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Xiꞌí daj, ni̱ gataj Juan gunun daranꞌ ni ngüi̱ daj: ―Hua yya duguataꞌ nnee manꞌānj nga̱ nnee ni é re̱ꞌ. Sani̱ ga̱ꞌnaꞌ ango tsínj du̱guataꞌ nnee Espíritu Santo niman án re̱ꞌ, ni̱ nga̱ yanꞌa̱n nej. Hué tsínj daj nicaj sun nico daj nga̱ si nicaj sun manꞌānj. Ni̱ na̱ꞌaj yānj nachīj nnij correa ꞌni̱j dacánj sij xiꞌí si huin achij ni̱nꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ni̱ hua daꞌa sij pala si na̱guiꞌyaj sa̱ꞌ sij riqui strigo. Ni̱ ga̱hui coj riqui-íꞌ. Ni̱ na̱ra sa̱ꞌ sij strigo chruhua guru̱. Sani̱ ga̱ri yanꞌa̱n sij coj ga̱ca-áꞌ ni̱ganj ni̱nꞌ. Ni̱ strigo daj huin ni ngüi̱ sa̱ꞌ rian Yanꞌanj. Ni̱ coj daj huin ni ngüi̱ nun aráj xina̱ si-nu̱guanꞌ Yanꞌanj nej aj. ―Daj gataj Juan gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ni̱ hué ducuánj nan huin si gaꞌmi sa̱ꞌ Juan ango ni nuguanꞌ sa̱ꞌ ꞌna̱ꞌ rian Yanꞌanj gunun ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ni̱ chranꞌ Juan tsínj gu̱ꞌnaj Herodes huin síꞌ gobernado xiꞌí si xacaj síꞌ nica̱ jnánj síꞌ Felipe huin únꞌ Herodías. Ni̱ chranꞌ Juan Herodes xiꞌí ango rasu̱n quij guiꞌyaj síꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hué dan ni̱ nataꞌ manꞌan Herodes ango gaquinꞌ rian ni gaquinꞌ guiꞌyaj sij daj. Daj si garij sij Juan ducuaga̱ꞌ nej aj. ");
INSERT INTO trq_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ni̱ ngaa achin ga̱ri Herodes Juan ducuaga̱ꞌ, ni̱ gataꞌ nnee ni ngüi̱, guiꞌyaj Juan. Asíj ni̱ duguataꞌ nnee Juan manꞌan Jesús nej. Diaj hua gue̱ achínj jniꞌyaj Jesús rian Yanꞌanj, ni̱ naxiꞌníj xataꞌ. ");
INSERT INTO trq_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ni̱ ꞌna̱ꞌ guinij Espíritu Santo rian Jesús. Ni̱ rúnꞌ hua ꞌngo̱ xuꞌma̱n hua Espíritu Santo gaꞌna̱ꞌ rian sij. Ni̱ gunun ni sij gaꞌmi Yanꞌanj xataꞌ. Ni̱ gataj-áꞌ: ―Hué re̱ꞌ huin daꞌnī ꞌi̱ ruhuāj. Ni̱ hua nia̱ꞌ ruhuāj niꞌyā so̱ꞌ. ―Daj gataj Yanꞌanj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ni̱ ꞌngo̱ si yoꞌ ico̱ chiꞌ huaj Jesús ngaa gaxi̱ꞌi sij guiꞌyaj sun sij si-nu̱guanꞌ Yanꞌanj. Ni̱ Jesús huin daꞌníj José, ruhua ni ngüi̱. Ni̱ José huin daꞌníj Elí. ");
INSERT INTO trq_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ni̱ Elí huin daꞌníj Mataj. Ni̱ Mataj huin daꞌníj Leví. Ni̱ Leví huin daꞌníj Melqui. Ni̱ Melqui huin daꞌníj Jona. Ni̱ Jona huin daꞌníj José. ");
INSERT INTO trq_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ni̱ José huin daꞌníj Matías. Ni̱ Matías huin daꞌníj Amós. Ni̱ Amós huin daꞌníj Nahúm. Ni̱ Nahúm huin daꞌníj Esli. Ni̱ Esli huin daꞌníj Nagai. ");
INSERT INTO trq_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ni̱ Nagai huin daꞌníj Maat. Ni̱ Maat huin daꞌníj Matías. Ni̱ Matías huin daꞌníj Semei. Ni̱ Semei huin daꞌníj Josec. Ni̱ Josec huin daꞌníj Judá. ");
INSERT INTO trq_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ni̱ Judá huin daꞌníj Jonán. Ni̱ Jonán huin daꞌníj Resa. Ni̱ Resa huin daꞌníj Zorobabel. Ni̱ Zorobabel huin daꞌníj Salatiel. Ni̱ Salatiel huin daꞌníj Neri. ");
INSERT INTO trq_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ni̱ Neri huin daꞌníj Mequi. Ni̱ Mequi huin daꞌníj Adi. Ni̱ Adi huin daꞌníj Cosam. Ni̱ Cosam huin daꞌníj Elmadam. Ni̱ Elmadam huin daꞌníj Er. ");
INSERT INTO trq_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ni̱ Er huin daꞌníj Jesús. Ni̱ Jesús huin daꞌníj Eliezer. Ni̱ Eliezer huin daꞌníj Jorim. Ni̱ Jorim huin daꞌníj Matat. ");
INSERT INTO trq_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ni̱ Matat huin daꞌníj Leví. Ni̱ Leví huin daꞌníj Simeón. Ni̱ Simeón huin daꞌníj Judá. Ni̱ Judá huin daꞌníj José. Ni̱ José huin daꞌníj Jonam. Ni̱ Jonam huin daꞌníj Eliaquim. Ni̱ Eliaquim huin daꞌníj Melea. ");
INSERT INTO trq_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ni̱ Melea huin daꞌníj Mena. Ni̱ Mena huin daꞌníj Matata. Ni̱ Matata huin daꞌníj Natán. ");
INSERT INTO trq_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ni̱ Natán huin daꞌníj David. Ni̱ David huin daꞌníj Isaí. Ni̱ Isaí huin daꞌníj Obed. Ni̱ Obed huin daꞌníj Booz. Ni̱ Booz huin daꞌníj Sala. Ni̱ Sala huin daꞌníj Naasón. ");
INSERT INTO trq_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ni̱ Naasón huin daꞌníj Aminadad. Ni̱ Aminadad huin daꞌníj Amin. Ni̱ Amin huin daꞌníj Arni. Ni̱ Arni huin daꞌníj Esrom. Ni̱ Esrom huin daꞌníj Fares. Ni̱ Fares huin daꞌníj Judá. ");
INSERT INTO trq_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ni̱ Judá huin daꞌníj Jacob. Ni̱ Jacob huin daꞌníj Isaac. Ni̱ Isaac huin daꞌníj Abraham. Ni̱ Abraham huin daꞌníj Taré. Ni̱ Taré huin daꞌníj Nacor. ");
INSERT INTO trq_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ni̱ Nacor huin daꞌníj Serug. Ni̱ Serug huin daꞌníj Ragau. Ni̱ Ragau huin daꞌníj Peleg. Ni̱ Peleg huin daꞌníj Heber. Ni̱ Heber huin daꞌníj Sala. ");
INSERT INTO trq_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ni̱ Sala huin daꞌníj Cainán. Ni̱ Cainán huin daꞌníj Arfaxad. Ni̱ Arfaxad huin daꞌníj Sem. Ni̱ Sem huin daꞌníj Noé. Ni̱ Noé huin daꞌníj Lamec. ");
INSERT INTO trq_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ni̱ Lamec huin daꞌníj Matasalén. Ni̱ Matasalén huin daꞌníj Enoc. Ni̱ Enoc huin daꞌníj Jared. Ni̱ Jared huin daꞌníj Mahalaleel. Ni̱ Mahalaleel huin daꞌníj Cainán. Ni̱ Cainán huin daꞌníj Enós. ");
INSERT INTO trq_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ni̱ Enós huin daꞌníj Set. Ni̱ Set huin daꞌníj Adán. Ni̱ Adán huin daꞌníj Yanꞌanj xa̱ngaꞌ aj. ");
INSERT INTO trq_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ni̱ nara sa̱ꞌ Espíritu Santo niman Jesús. Ngaa ni̱ gahui sij duꞌua xinéj gu̱ꞌnaj Jordán. Ni̱ ganꞌanj sij quij quiꞌyanj na̱co, guiꞌyaj Espíritu Santo. ");
INSERT INTO trq_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ni̱ hui̱j xia yya güi guiꞌyaj fuerza sichre sisi̱ gui̱ꞌyaj Jesús gaquinꞌ. Ni̱ a̱ ꞌngo̱ xicoꞌ nun xa̱ sij ni güi daj. Ni̱ ngaa guisíj gunucuaj sij hui̱j xia güi daj, ni̱ achin xiꞌna̱ riqui sij aj. ");
INSERT INTO trq_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ngaa ni̱ gataj sichre gunun Jesús: ―Sisi̱ xa̱ngaꞌ re̱ꞌ huín re̱ꞌ daꞌníj Yanꞌanj, ni̱ na̱guiꞌyaj re̱ꞌ si ga̱nahuin yej nan chrachrúnj xa̱ re̱ꞌ stoj. ―Daj gataj sichre gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Sani̱ gataj Jesús: ―Ataj si-nu̱guanꞌ Yanꞌanj sisi̱ sé urin chrachrúnj gui̱ꞌyaj si ga̱ ni̱ꞌnaꞌ ni ngüi̱ mánj. Sani̱ ga̱ ni̱ꞌnaꞌ xa̱ngaꞌ ni ngüi̱ gui̱ꞌyaj daranꞌ ni nuguanꞌ ꞌna̱ꞌ rian Yanꞌanj. ―Daj gataj Jesús gunun sichre. ");
INSERT INTO trq_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Hué dan ni̱ nicaj sichre Jesús ganꞌanj-ánꞌ chra̱ ꞌngo̱ quij xa̱can. Ni̱ riqui urin hora digyán sichre daranꞌ xumanꞌ ngaj chruhua xungüi̱ rian Jesús. ");
INSERT INTO trq_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ni̱ gataj sichre gunun Jesús: ―Ri̱quīj daranꞌ ni sun nan gui̱nicaj manꞌán re̱ꞌ. Ni̱ ga̱huin ꞌueé ni̱nꞌ re̱ꞌ, gui̱ꞌyā xiꞌí si ga̱huin achíj re̱ꞌ rian daranꞌ ni xumanꞌ nan. Daj si hua nahuin raꞌāj daranꞌ nan, guiꞌyaj Yanꞌanj. Ni̱ u̱n tsínj ri̱an ga̱ranꞌ ruhuāj, ni̱ ga̱ꞌuīj daranꞌ nan anj. ");
INSERT INTO trq_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ngaa ni̱ sisi̱ gui̱niquinꞌ ráj da̱coj re̱ꞌ riānj, ni̱ gui̱nicóꞌ re̱ꞌ yūnj, ngaa ni̱ daranꞌ nan ga̱huin siꞌyáj re̱ꞌ, gui̱ꞌyā. ―Daj gataj sichre gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ni̱ gataj Jesús: ―Gu̱xun manꞌán re̱ꞌ riānj Satanás. Daj si gataj si-nu̱guanꞌ Yanꞌanj: Ga̱niquinꞌ ráj da̱coj néꞌ rian Señor huin Danꞌanj néꞌ. Ni̱ da̱gahuin néꞌ rian urin Yanꞌanj. Daꞌngaꞌ daj gataj si-nu̱guanꞌ Yanꞌanj. ―Daj gataj Jesús gunun sichre. ");
INSERT INTO trq_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Hué dan ni̱ nicaj sichre Jesús ganꞌanj-ánꞌ xumanꞌ Jerusalén. Ni̱ gahui Jesús chra̱ nuhui nico, guiꞌyaj sichre. Ni̱ gataj sichre: ―Sisi̱ yya huín re̱ꞌ daꞌníj Yanꞌanj, ngaa ni̱ güe̱j re̱ꞌ ni̱caꞌ nánj. ");
INSERT INTO trq_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Daj si gataj si-nu̱guanꞌ Yanꞌanj: Ga̱ꞌninꞌ Yanꞌanj sun rian ni ángel sisi̱ ga̱ꞌnaꞌ du̱gumi ni síꞌ manꞌán re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ngaa ni̱ gui̱nij re̱ꞌ rian raꞌa ni ángel sisi̱ si̱ garij re̱ꞌ dacój re̱ꞌ, gui̱ꞌyaj yej. Daꞌngaꞌ daj gataj si-nu̱guanꞌ Yanꞌanj. ―Gataj sichre gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ngaa ni̱ gataj Jesús: ―Gataj si-nu̱guanꞌ Yanꞌanj: “Si̱ xacaj so̱ꞌ cuenta sisi̱ xa̱ngaꞌ si-nu̱guanꞌ Señor huin Danꞌanj so̱ꞌ mánj.” Daj gataj si-nu̱guanꞌ Yanꞌanj. ―Gataj Jesús gunun sichre. ");
INSERT INTO trq_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ni̱ ngaa guisíj ganahuij gatsij sichre niman Jesús, ni̱ guxun-únꞌ manꞌan-ánꞌ rian Jesús ꞌngo̱ ni güi. ");
INSERT INTO trq_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Hué dan ni̱ nanica̱j Jesús ganꞌanj sij estado Galilea. Ni̱ gahuin nucuaj niman sij xiꞌí si-sun Yanꞌanj, guiꞌyaj Espíritu Santo. Ni̱ guisíj nuguanꞌ xiꞌí Jesús rian daranꞌ ni xumanꞌ ngaj yuꞌuj daj. ");
INSERT INTO trq_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ni̱ daꞌ go̱ꞌngo yuꞌuj huaj sij, ni̱ digyán sij rian ni ngüi̱ chruhua si-nuhui ni tsínj israelita. Ni̱ gaꞌmi sa̱ꞌ ꞌueé ni ngüi̱ xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ngaa ni̱ na̱nꞌ Jesús xumanꞌ Nazaret rian gachij sij. Ngaa ni̱ güi naránj ruhua ni ngüi̱, ni̱ gatúj sij chruhua nuhui da̱j rúnꞌ guꞌyun sij guiꞌyaj sij. Ni̱ ganiquinꞌ sij gaya sij si-nu̱guanꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ni̱ gaꞌuiꞌ ꞌngo̱ tsínj daj yanj garun tsínj gu̱ꞌnaj Isaías ga̱ya Jesús. Ni̱ Isaías huin ꞌngo̱ tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. Ni̱ naꞌníj sij rian yanj. Ni̱ nariꞌ sij ꞌngo̱ yuꞌuj rian aꞌmi ni̱ca yya si-nu̱guanꞌ Yanꞌanj: ");
INSERT INTO trq_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Nne Espíritu Santo ngāj. Ni̱ xiꞌí daj gaꞌninꞌ Yanꞌanj sun riānj sisi̱ ga̱nꞌanj ga̱ꞌmī nuguanꞌ sa̱ꞌ rian ni ngüi̱ yaco ranꞌ. Ni̱ gaꞌníj Yanꞌanj ga̱nꞌanj ga̱ꞌmī nga̱ ni tsínj nani ruhua sisi̱ ga̱huin nia̱ꞌ ruhua ni sij, gui̱ꞌyā. Ni̱ gaꞌníj Yanꞌanj ga̱nꞌanj ga̱ꞌmī nga̱ ni tsínj nu̱n ducuaga̱ꞌ. Ngaa ni̱ ga̱hui ni síꞌ. Ni̱ ga̱nꞌanj gui̱ꞌyā si na̱xiꞌni rian ni ngüi̱ duri. Ni̱ gaꞌníj Yanꞌanj ga̱nꞌanj gui̱ꞌyā si ga̱ níꞌnij rian ni ngüi̱ ranꞌ sayun ꞌyaj si quij hua. ");
INSERT INTO trq_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ni̱ gaꞌníj Yanꞌanj ga̱nꞌanj ga̱ꞌmī nuguanꞌ sa̱ꞌ rian ni ngüi̱ sisi̱ yoꞌ yya̱j, ni̱ huin nia̱ꞌ ruhua Yanꞌanj ga̱ꞌnaꞌ na̱caj-áꞌ ni ngüi̱ ma̱n chruhua xungüi̱. Daꞌngaꞌ daj gataj yanj daj gaya Jesús. ");
INSERT INTO trq_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ngaa ni̱ naránj Jesús rian yanj daj. Ni̱ gaꞌuiꞌ sij rian tsínj dugumi yanj chruhua nuhui. Ni̱ ganꞌanj ga̱ne sij. Ni̱ niꞌyaj sa̱ꞌ daranꞌ ni tsínj nne chruhua nuhui rian Jesús. ");
INSERT INTO trq_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ni̱ gaxi̱ꞌi sij gaꞌmi sij. Ni̱ gataj sij: ―Hué güi nan huin si guisíj gahuin yya nuguanꞌ garun Isaías si gayā rian ni é re̱ꞌ aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ngaa ni̱ gaꞌmi sa̱ꞌ daranꞌ ni sij xiꞌí Jesús. Ni̱ gahuin yanꞌanj ruhua ni sij nga̱ nuguanꞌ ꞌueé gaꞌmi síꞌ. Ni̱ nachínj snanꞌanj ni sij dugüiꞌ ni sij. Ni̱ gataj ni sij: ―Sé daꞌníj José huin síꞌ a̱ꞌ. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Xiꞌí daj ni̱ gataj Jesús: ―Xa̱ngaꞌ yya ga̱taj ni é re̱ꞌ nuguanꞌ nan gu̱nūnj: “Gui̱ꞌyaj gonoꞌó re̱ꞌ manꞌán re̱ꞌ huín re̱ꞌ tsínj ꞌyaj go̱noꞌo.” Ni̱ ga̱taj ni é re̱ꞌ sisi̱ da̱j rúnꞌ guiꞌyā si sa̱ꞌ nico xumanꞌ Capernaum, ni̱ daꞌngaꞌ daj gui̱ꞌyā xánj néꞌ nan nej aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús: ―Ataj yyāj gu̱nun a ni é re̱ꞌ sisi̱ nitaj si aꞌmi sa̱ꞌ ni tsínj rian ꞌngo̱ tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj sisi̱ huin ni sij ni tsínj xa̱nj. ");
INSERT INTO trq_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","’Ni̱ huin yya atā gu̱nun a ni é re̱ꞌ sisi̱ guimán nico ni ngüi̱ mmij rian nne ni tsínj israelita ni yoꞌ gane tsínj gu̱ꞌnaj Elías yuꞌuj daj asi̱j ná. Ni̱ nun gamanꞌ hua̱ꞌnij yoꞌ táj nej. Ni̱ ducu ga xiꞌna̱ ni̱nꞌ ga̱chraꞌ yuꞌuj daj. ");
INSERT INTO trq_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Sani̱ nun gaꞌníj Yanꞌanj ga̱nꞌanj Elías chra̱cuij síꞌ ni ngüi̱ mmij guimán Israel. Sani̱ ganꞌanj síꞌ ne̱ꞌ xe̱ꞌ rian ꞌngo̱ ngüi̱ mmij gane xumanꞌ Sarepta rian gu̱ꞌnaj Sidón. ");
INSERT INTO trq_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","’Ni̱ guimán nico ni ngüi̱ gaꞌnanꞌ xiꞌi̱ nnij scanij ni tsínj israelita ngaa gane Eliseo huin síꞌ ꞌngo̱ tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj yuꞌuj daj asi̱j ná. Sani̱ nun ganahuin ni̱ a̱ ꞌngo̱ ni sij mánj. Sani̱ ganahuin tsínj gu̱ꞌnaj Naamán huin sij ꞌngo̱ tsínj ꞌna̱ꞌ ango yuꞌuj gu̱ꞌnaj Siria, guiꞌyaj Eliseo. ―Daj gataj Jesús gunun ni tsínj ma̱n chruhua nuhui daj. ");
INSERT INTO trq_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ni̱ ngaa gunun ni sij nuguanꞌ gaꞌmi Jesús, ni̱ ducu gaꞌman ruhua ni sij niꞌyaj ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ni̱ naxu̱man ni sij guiri ni sij chruhua xumanꞌ Jesús. Ni̱ ganꞌanj ni sij chra̱ ꞌngo̱ quij xa̱can rian guiꞌyaj ni sij xánj ni sij. Ni̱ huin ruhua ni sij du̱güéj ni sij Jesús ne̱ꞌ ni̱caꞌ. ");
INSERT INTO trq_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Sani̱ gachin Jesús da̱ni ni sij ganꞌanj síꞌ nánj. ");
INSERT INTO trq_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Hué dan ni̱ ganꞌanj Jesús xumanꞌ Capernaum huin xumanꞌ ngaj estado Galilea. Ni̱ yuꞌuj daj gaxi̱ꞌi Jesús digyán sij rian ni ngüi̱ ni güi naránj ruhua ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Sani̱ gahuin yanꞌanj ruhua ni ngüi̱ da̱j digyán sij rian ni síꞌ. Daj si si-nu̱guanꞌ sij nicaj sun. ");
INSERT INTO trq_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ni̱ nne ꞌngo̱ tsínj nu̱n nane̱ xi̱ꞌi chruhua niman chruhua nuhui. Ni̱ gaguáj nucuaj síꞌ. Ni̱ gataj síꞌ: ");
INSERT INTO trq_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Du̱náj re̱ꞌ ni únj. Ni̱ u̱n sin huin ni̱ diguíj re̱ꞌ nga̱ ni únj huín re̱ꞌ Jesús Nazareno únj. Ni̱ ꞌna̱ꞌ re̱ꞌ du̱guanj niꞌyáj re̱ꞌ ni únj níꞌ. Ni̱ hua niꞌīnj re̱ꞌ si huín re̱ꞌ tsínj sa̱ꞌ ni̱nꞌ chruhua niman ꞌna̱ꞌ rian Yanꞌanj xa̱ngaꞌ nej aj. ―Gataj nane̱ xi̱ꞌi daj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ngaa ni̱ gaꞌmi huee Jesús rian nane̱ xi̱ꞌi daj. Ni̱ gataj sij: ―Dínj ga̱ne duꞌuá so̱ꞌ. Ni̱ ga̱hui so̱ꞌ chruhua niman síꞌ. ―Daj gataj Jesús. Ngaa ni̱ naxiruꞌ tsínj daj da̱ni ni ngüi̱, guiꞌyaj nane̱ xi̱ꞌi daj. Ni̱ gahui-íꞌ chruhua niman tsínj daj. Ni̱ nitaj ꞌngo̱ si gahuin guiꞌyaj nane̱ xi̱ꞌi tsínj daj ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ni̱ ganꞌanj ruhua daranꞌ ni sij. Ni̱ gataj ni sij gunun ni dugüiꞌ ni sij: ―Ni̱ u̱n nuguanꞌ huin nuguanꞌ nan únj. Nicaj nucuaj tsínj nan sun. Ni̱ aꞌninꞌ síꞌ sun rian ni nane̱ xi̱ꞌi. Ni̱ ahui-íꞌ chruhua niman ni ngüi̱, ꞌyaj síꞌ. ―Daj gataj ni sij nej aj. ");
INSERT INTO trq_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ni̱ nuna ni ngüi̱ ni̱nꞌ ga̱chraꞌ rian ni xumanꞌ xiꞌí Jesús si guiꞌyaj sa̱ꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ngaa ni̱ gahui Jesús chruhua nuhui daj. Ni̱ gatúj sij chruhua ducuá Simón. Ni̱ aꞌnanꞌ nni che̱j Simón. Ni̱ ducu nu̱n gachiꞌ únꞌ. Ni̱ gaꞌmi yaco ni sij xiꞌí yunꞌunj aꞌnanꞌ daj rian Jesús. ");
INSERT INTO trq_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ngaa ni̱ gaꞌ nitu Jesús rian yunꞌunj xa̱na daj. Ni̱ gaꞌninꞌ sij sun sisi̱ gu̱xun anéj xiꞌi̱ daj rian únꞌ. Ni̱ hué ꞌngo̱ hora daj, ni̱ xiꞌnej gachiꞌ daj nachica únꞌ. Ni̱ gaxi̱ꞌi manꞌan únꞌ guiꞌyaj xugüi únꞌ si xa ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ni̱ ngaa gatúj güi, ni̱ nicaj ni sij daranꞌ ni ngüi̱ aꞌnanꞌ gaꞌi̱ rian xiꞌi̱ gaꞌna̱ꞌ ni sij rian Jesús. Ni̱ gutaꞌ síꞌ raꞌa síꞌ rian daranꞌ ni ngüi̱ daj. Ni̱ nahuin daranꞌ ni sij, guiꞌyaj síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ni̱ gahui nane̱ xi̱ꞌi chruhua niman nico ni ngüi̱ aꞌnanꞌ daj. Ni̱ gaguáj ni nane̱ xi̱ꞌi gahui daj. Ni̱ gataj ni sij: ―Hué re̱ꞌ huin daꞌníj Yanꞌanj xa̱ngaꞌ. ―Daj gataj ni nane̱ xi̱ꞌi daj. Sani̱ gaꞌmi huee Jesús rian ni nane̱ xi̱ꞌi. Ni̱ nun ga̱ꞌuej ruhua sij ga̱ꞌmi ni nane̱ xi̱ꞌi daj. Daj si niꞌi-ínꞌ si hué Jesús huin Cristo, tsínj ꞌna̱ꞌ na̱caj ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ni̱ ngaa guixigui̱n ango güi, ni̱ gahui Jesús xumanꞌ daj ganꞌanj sij yuꞌuj rian nitaj ni ngüi̱ mán. Sani̱ nanoꞌ ni ngüi̱ sij. Ni̱ guisíj ni síꞌ rian nne sij. Ni̱ nun ga̱ꞌuej ni síꞌ sisi̱ ga̱nꞌanj Jesús rian ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Sani̱ gataj Jesús gunun ni síꞌ: ―Hua nia̱n ga̱nꞌān ango ni xumanꞌ ga̱ꞌmī nuguanꞌ sa̱ꞌ xiꞌí si nicaj sun Yanꞌanj rian ni ngüi̱ si daꞌngaꞌ daj gaꞌníj Yanꞌanj yūnj gaꞌnāj. ―Gataj Jesús gunun ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ngaa ni̱ huaj Jesús gaꞌmi sa̱ꞌ sij si-nu̱guanꞌ Yanꞌanj chruhua si-nuhui ni tsínj israelita nne estado Galilea. ");
INSERT INTO trq_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ni̱ ꞌngo̱ güi niquinꞌ Jesús duꞌua laguna xa̱chij gu̱ꞌnaj Genesaret. Ni̱ gadaꞌui ni ngüi̱ rian sij si huin ruhua ni síꞌ gu̱nun ni síꞌ si-nu̱guanꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ni̱ guiniꞌi Jesús niquinꞌ hui̱j rio̱ chéj rian nnee duꞌua laguna daj. Ni̱ hua gahui ni tsínj daꞌa xucuaj ruhua nu̱ngüe-éꞌ naꞌninꞌ ni síꞌ nnánj. ");
INSERT INTO trq_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ngaa ni̱ gatúj Jesús chruhua ꞌngo̱ rio̱ huin si-rio̱ Simón. Ni̱ gachínj sij rian Simón sisi̱ gu̱xun síꞌ do̱j rio̱ daj ga̱nꞌanj-ánꞌ doj rian laguna daj. Ngaa ni̱ ganꞌanj ga̱ne Jesús. Ni̱ hué asi̱j yuꞌuj daj gaxi̱ꞌi sij digyán sij nuguanꞌ sa̱ꞌ rian ni ngüi̱ mán duꞌua laguna daj. ");
INSERT INTO trq_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ni̱ ngaa guisíj gaꞌmi Jesús rian ni ngüi̱, ni̱ gataj sij gunun Simón: ―Ni̱caj re̱ꞌ rio̱ ga̱nꞌanj re̱ꞌ rian gu̱nun da̱ni nnee. Ni̱ di̱nij re̱ꞌ nnánj chruhua nnee gui̱daꞌá re̱ꞌ xucuaj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sani̱ gataj Simón: ―Maestro, hua guiꞌyaj sun ni únj ni̱ganꞌ. Sani̱ ni̱ a̱ ꞌngo̱ xucuaj nun ga̱ꞌue guidaꞌa únj mánj. Sani̱ xiꞌí si gataj manꞌán re̱ꞌ sisi̱ di̱nij ru̱huaꞌ yún únj nnánj, ni̱ daꞌngaꞌ daj gui̱ꞌyaj únj nánj. ―Daj gataj Simón. ");
INSERT INTO trq_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ni̱ ngaa guiꞌyaj ni sij daj, ni̱ ducu guidaꞌa ni sij xucuaj da̱ꞌ xiꞌninꞌ nnánj, guiꞌyaj xucuaj. ");
INSERT INTO trq_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ni̱ guiꞌyaj raꞌa ni sij dugüiꞌ ni sij, ni̱ tsínj ma̱n chruhua ango rio̱ sisi̱ ga̱ꞌnaꞌ ni síꞌ chra̱cuij ni síꞌ ni sij. Ni̱ gaꞌna̱ꞌ ni síꞌ. Ni̱ gara daranꞌ ni sij xucuaj chruhua nu̱ngüej rio̱. Sani̱ ducu gara chruhua nu̱ngüej-éꞌ da̱ꞌ do̱j, ni̱ nagaꞌ nu̱ngüej-éꞌ daqui nnee. ");
INSERT INTO trq_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ni̱ ngaa guiniꞌi Simón Pedro si gahuin, ni̱ ganiquinꞌ ráj da̱coj sij ne̱ꞌ rian Jesús. Ni̱ gataj sij: ―Gu̱xun anéj re̱ꞌ manꞌán re̱ꞌ riānj si huīnj ꞌngo̱ tsínj daꞌui gaquinꞌ. ―Gataj Pedro gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ni̱ hué daj guxuꞌuiꞌ daranꞌ ni du̱güiꞌ Simón si hua yya guidaꞌa ni sij nico xucuaj. ");
INSERT INTO trq_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ni̱ ganꞌanj ruhua nu̱ngüej tsínj gu̱ꞌnaj Jacobo nga̱ Juan huin nu̱ngüej síꞌ daꞌníj Zebedeo. Ni̱ huin nu̱ngüej síꞌ tsínj nicaj dugüiꞌ nga̱ Simón nej. Sani̱ gataj Jesús rian Simón: ―Si̱ guxuꞌuíꞌ re̱ꞌ mánj. Daj si asi̱j acuanꞌ ni̱ da̱j rúnꞌ guiꞌyáj re̱ꞌ guidaꞌá re̱ꞌ xucuaj, ni̱ daꞌngaꞌ daj gui̱ꞌyáj re̱ꞌ nga̱ ni ngüi̱ sisi̱ gui̱nicoꞌ sa̱ꞌ ni sij manꞌānj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ni̱ nicaj ni sij nu̱ngüej rio̱ gaꞌna̱ꞌ ni sij rian yoꞌój. Ni̱ ꞌngo̱ dunáj ni sij daranꞌanj. Ni̱ gaxi̱ꞌi ni sij guinicoꞌ ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ni̱ ꞌngo̱ güi nne Jesús ꞌngo̱ xumanꞌ. Ni̱ guisíj ꞌngo̱ tsínj aꞌnanꞌ xiꞌi̱ nnij rian sij. Ni̱ ngaa guiniꞌi síꞌ Jesús, ni̱ ganiquinꞌ ráj da̱coj síꞌ rian Jesús. Ni̱ gaꞌ rian síꞌ daꞌ rian yoꞌój. Ni̱ gaꞌmi yaco síꞌ rian Jesús. Ni̱ gataj síꞌ: ―Señor, sisi̱ huin ruhuá re̱ꞌ, ni̱ ga̱ꞌue gui̱ꞌyaj gonoꞌó re̱ꞌ yūnj, ni̱ xi̱ꞌne xiꞌi̱ aꞌnānj. ―Gataj tsínj aꞌnanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ngaa ni̱ gutaꞌ Jesús raꞌa sij chra̱ tsínj daj. Ni̱ gataj sij: ―Huin ruhuāj sisi̱ ga̱ sa̱ꞌ nnee̱ cúj re̱ꞌ aj. ―Daj gataj Jesús. Ngaa ni̱ ꞌngo̱ hora xiꞌnej xiꞌi̱ aꞌnanꞌ tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ngaa ni̱ gaꞌninꞌ Jesús sun rian síꞌ, ni̱ gataj sij: ―Si̱ ganataꞌ re̱ꞌ rian ni̱ a̱ ꞌngo̱ ni ngüi̱ mánj. Maan si ga̱nꞌanj re̱ꞌ di̱gyán re̱ꞌ manꞌán re̱ꞌ rian chrej. Ni̱ ni̱caj re̱ꞌ ꞌngo̱ xucu ga̱ꞌuiꞌ re̱ꞌ rian Yanꞌanj da̱j rúnꞌ gaꞌninꞌ Moisés sun güenda ga̱huin-ínꞌ ꞌngo̱ daꞌngaꞌ sisi̱ hua ganahuín re̱ꞌ. Ngaa ni̱ xa̱caj ni chrej cuenta sisi̱ hua ganahuín re̱ꞌ, guiꞌyaj manꞌānj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Sani̱ guixiꞌni̱ nuguanꞌ xiꞌí si sa̱ꞌ guiꞌyaj Jesús. Ni̱ nahuin yuꞌ nico ni ngüi̱ huin ruhua gu̱nun si-nu̱guanꞌ sij. Ni̱ ruhua ni sij si ga̱nahuin xiꞌi̱ aꞌnanꞌ ni sij, gui̱ꞌyaj Jesucristo nej. ");
INSERT INTO trq_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Sani̱ guxun anéj Jesús manꞌan sij rian ni ngüi̱. Ni̱ ganꞌanj sij ꞌngo̱ yuꞌuj nitaj ni ngüi̱ mán gachínj jniꞌyaj sij rian Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ni̱ ꞌngo̱ güi nne Jesús digyán sij rian ni ngüi̱. Ni̱ nne ni tsínj fariseo nga̱ ni tsínj digyán ley nga̱ sij nej. Ni̱ ꞌna̱ꞌ ni síꞌ ni xumanꞌ ngaj estado Galilea nga̱ estado Judea nej, xumanꞌ Jerusalén nej. Ni̱ ganahuin ni ngüi̱ aꞌnanꞌ, guiꞌyaj Jesús nga̱ si-fuerza manꞌan Señor huin Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Hué dan ni̱ guisíj go̱ꞌngo ni tsínj ata ni sij ꞌngo̱ tsínj nareꞌ dacoj rian ꞌngo̱ chrun xéj. Ni̱ nanoꞌ ni sij da̱j ga̱tu ni sij chruhua hueꞌ gu̱ruj ni sij tsínj aꞌnanꞌ daj rian Jesús. ");
INSERT INTO trq_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Sani̱ ri̱an ma̱n ni̱nꞌ ruhua ni ngüi̱, ni̱ nun ga̱ꞌue gui̱riꞌ ni sij rian ga̱chin ni sij nga̱ tsínj daj. Ngaa ni̱ gahui ni sij chra̱ hueꞌ. Ni̱ gaꞌnej ni sij teja. Ni̱ dunij ni sij na̱naj rian chrun xéj tsínj aꞌnanꞌ daj. Ni̱ gurúj ni sij tsínj daj da̱ni ni ngüi̱ rian Jesús. ");
INSERT INTO trq_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ni̱ ngaa guiniꞌi Jesús sisi̱ xuman ruhua ni sij niꞌyaj ni sij síꞌ, ni̱ gataj síꞌ gunun tsínj aꞌnanꞌ daj: ―Jnān, nicā ꞌngo̱ niman nico rian si-ga̱quinꞌ so̱ꞌ nánj. ―Gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ngaa ni̱ gaxi̱ꞌi gani ruhua ni tsínj fariseo nga̱ ni tsínj digyán ley nuguanꞌ nan nga̱ ni dugüiꞌ ni sij: ―Ni̱ u̱n sin huin tsínj nan, ni̱ aꞌmi quij sij rian Yanꞌanj únj. Urin Yanꞌanj ga̱ꞌue gui̱nicaj niman nico rian si-ga̱quinꞌ ni ngüi̱ aj. ―Daꞌngaꞌ daj gani ruhua ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Sani̱ xacaj Jesús cuenta da̱j gani ruhua ni sij. Ni̱ gataj sij: ―Ni̱ u̱n sin huin ni̱ ani ruhua á re̱ꞌ nuguanꞌ da únj. ");
INSERT INTO trq_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Hua hui̱j nuguanꞌ ga̱ꞌue ga̱tā gu̱nun tsínj nan. Asi̱ ga̱ꞌue ga̱tā gu̱nun sij: “Nicā ꞌngo̱ niman nico rian xiꞌí si-ga̱quinꞌ re̱ꞌ.” Asi̱ ga̱ꞌue ga̱tā gu̱nun sij: “Na̱chica re̱ꞌ ga̱che re̱ꞌ.” Nan huin hui̱j nuguanꞌ ga̱ꞌue ga̱tā gu̱nun sij. ");
INSERT INTO trq_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ni̱ huin ruhuāj sisi̱ xa̱caj á re̱ꞌ cuenta sisi̱ nicaj sūnj rian xungüi̱ nan huīnj daꞌníj ni ngüi̱. Ni̱ ga̱ꞌue gui̱nicā ꞌngo̱ niman nico xiꞌí si-ga̱quinꞌ ni ngüi̱ aj. ―Daj gataj Jesús gunun ni sij. Ngaa ni̱ gataj Jesús gunun tsínj nareꞌ dacój daj: ―Atā gu̱nun manꞌán re̱ꞌ sisi̱ na̱chica re̱ꞌ, ni̱ na̱caj re̱ꞌ chrun xéj. Ni̱ güi̱j na̱nꞌ ducuá re̱ꞌ nánj. ―Daj gataj Jesús gunun tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ni̱ ꞌngo̱ hora da ni̱ nachica tsínj daj rian daranꞌ ni ngüi̱. Ni̱ nacaj sij chrun xéj ta̱j sij daj. Ni̱ na̱nꞌ sij ducuá sij. Ni̱ gaꞌmi sa̱ꞌ ꞌueé sij rian Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ni̱ ganꞌanj ruhua ni ngüi̱ mán yuꞌuj daj gaꞌmi sa̱ꞌ ni sij rian Yanꞌanj. Ni̱ guxuꞌuiꞌ ni ngüi̱ daj. Ni̱ gataj ni sij: ―Yya̱j ni̱ guiniꞌi néꞌ ꞌngo̱ si sa̱ꞌ, guiꞌyaj Yanꞌanj. ―Daj gataj ni ngüi̱ daj gunun dugüiꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Hué dan ni̱ gahui Jesús ne̱ꞌ chrej xe̱ꞌ. Ni̱ guiniꞌi sij ꞌngo̱ tsínj aꞌnej pesto. Ni̱ gu̱ꞌnaj síꞌ Leví. Ni̱ nne síꞌ rian mesa aꞌnej síꞌ pesto. Ngaa ni̱ gataj Jesús gunun síꞌ: ―Gui̱nicoꞌ re̱ꞌ manꞌānj ga̱nꞌanj néꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Hué dan ni̱ naxu̱man síꞌ, ni̱ dunáj síꞌ daranꞌ si nicaj síꞌ. Ni̱ guinicoꞌ síꞌ Jesús ganꞌanj síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ngaa ni̱ guiꞌyaj Leví guiꞌyanj nico ducuá síꞌ xiꞌí Jesús. Ni̱ ma̱n nico ango ni tsínj aꞌnej pesto nga̱ ango ni ngüi̱ nej. Ni̱ nne daranꞌ ni sij rian mesa xa ni sij nga̱ Jesús. ");
INSERT INTO trq_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Sani̱ gaxi̱ꞌi gaꞌmi quij ni tsínj fariseo nga̱ ni tsínj digyán ley. Ni̱ gataj ni sij rian ni tsínj nicoꞌ Jesús: ―Ni̱ u̱n sin huin ni̱ xa ni é re̱ꞌ goꞌo ni é re̱ꞌ nga̱ ni tsínj ꞌyaj gaquinꞌ nej únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ngaa ni̱ gataj Jesús: ―Nitaj si níꞌyanj ni ngüi̱ hua sa̱ꞌ ꞌngo̱ tsínj ꞌyaj go̱noꞌo mánj. Sani̱ ni ngüi̱ aꞌnanꞌ níꞌyanj ꞌngo̱ tsínj go̱noꞌo aj. ");
INSERT INTO trq_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Sé si ꞌnāj ga̱quīn ni ngüi̱ hua sa̱ꞌ mánj. Sani̱ gaꞌnāj ga̱quīn ni ngüi̱ ꞌyaj gaquinꞌ sisi̱ ga̱nani ruhua ni sij xiꞌí si-ga̱quinꞌ ni sij. ―Gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ngaa ni̱ gataj ni sij gunun Jesús: ―Ni̱ u̱n sin huin ni̱ nico̱ꞌ huaj ꞌyaj ni tsínj nicoꞌ Juan ayuno únj. Ni̱ achínj jniꞌyaj ni̱nꞌ ruhua ni sij rian Yanꞌanj. Ni̱ hué daj ꞌyaj ni tsínj fariseo nej. Sani̱ ni tsínj nicoꞌ manꞌán re̱ꞌ, ni̱ yaꞌyoj xa ni sij goꞌo ni sij aj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ngaa ni̱ gataj Jesús: ―Da̱j rúnꞌ ꞌyaj ꞌngo̱ tsínj xa̱caj yunꞌunj xa̱na daꞌngaꞌ daj ꞌyā. Ni̱ ngaa ga̱huin guiꞌyanj xa̱caj ꞌngo̱ tsínj daj yunꞌunj xa̱na, ni̱ si̱ gaꞌue gui̱ꞌyaj tsínj ga̱nꞌanj guiꞌyanj daj ayuno mánj. ");
INSERT INTO trq_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Sani̱ hua ꞌngo̱ güi ngaa gui̱daꞌa ni tsínj quij tsínj xa̱caj yunꞌunj xa̱na daj. Hué dan ni̱ gui̱ꞌyaj ni tsínj nicoꞌ manꞌānj ayuno aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Hué dan ni̱ nani Jesús ꞌngo̱ nuguanꞌ digyán sij rian ni sij. Ni̱ gataj sij: ―Ni̱ a̱ ꞌngo̱ néꞌ si̱ gaꞌue ga̱ꞌninꞌ néꞌ duꞌua atsij na̱ca, ni̱ na̱ra néꞌ duꞌua atsij re̱ꞌe mánj. Sisi̱ daꞌngaꞌ daj gui̱ꞌyaj néꞌ, ni̱ gue̱reꞌ atsij na̱ca da, gui̱ꞌyaj néꞌ nánj. Ni̱ daꞌngaꞌ daj si̱ gaꞌue ga̱ ꞌueé atsij re̱ꞌe daj, gui̱ꞌyaj néꞌ nga̱ atsij na̱ca da mánj. ");
INSERT INTO trq_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ni̱ si̱ gaꞌue ga̱ꞌnij néꞌ vino na̱ca chruhua nnij re̱ꞌe. Daj si tsitsiꞌ nnij daj gui̱ꞌyaj vino na̱ca da nej. Hué dan ni̱ ꞌngo̱ gue̱reꞌ vino nga̱ nnij nej. ");
INSERT INTO trq_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Hué dan ni̱ hua nia̱n ga̱ꞌnij néꞌ vino na̱ca chruhua nnij na̱ca. Ngaa ni̱ ꞌngo̱ mán sa̱ꞌ vino nga̱ nnij. Ni̱ da̱j rúnꞌ huin vino na̱ca daj huin si-nu̱guanꞌānj. ");
INSERT INTO trq_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ni̱ ngaa goꞌo ni sij vino gachij, ni̱ nitaj si huin ruhua ni sij go̱ꞌo ni sij vino na̱ca. Daj si: “Vino gachij huin si sa̱ꞌ goꞌo ni sij”, ataj ni sij nej aj. Xiꞌí daj naꞌuej ruhua ni é re̱ꞌ gui̱nicoꞌ ni é re̱ꞌ si-du̱cuānj huin nuguanꞌ na̱ca. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ni̱ ꞌngo̱ güi naránj ruhua ni ngüi̱, ni̱ achéj Jesús riqui nnaa̱ strigo. Ngaa ni̱ rocoj ni tsínj nicoꞌ Jesús ca strigo. Ni̱ dixa raꞌa ni sij ca. Ni̱ gahui strigo, ni̱ xa ni sij. ");
INSERT INTO trq_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ngaa ni̱ nachínj snanꞌanj ni tsínj fariseo ni sij. Ni̱ gataj ni síꞌ: ―Ni̱ u̱n sin huin ni̱ ꞌyaj á re̱ꞌ da únj. Ni̱ naꞌuej si-ley Yanꞌanj sisi̱ gui̱ꞌyaj néꞌ sun daj güi naránj ruhua néꞌ mánj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ngaa ni̱ gataj Jesús: ―Hua gaya á re̱ꞌ si guiꞌyaj xíꞌ David níꞌ. Daj si ꞌngo̱ güi ngaa gachin xiꞌna̱ riqui ni du̱güiꞌ sij, ");
INSERT INTO trq_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ni̱ gatúj sij chruhua ducuá Yanꞌanj. Ni̱ xacaj sij si-chra̱chrunj Yanꞌanj. Ni̱ xa sij. Ni̱ gaꞌuiꞌ si xa ni tsínj ma̱n nga̱ sij nu̱nj si urin chrej gaꞌue xa̱ chrachrúnj daj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ni̱ gataj ru̱huaꞌ yún Jesús: ―Ni̱ nicaj sūnj rian ni güi naránj ruhua néꞌ huīnj daꞌníj ni ngüi̱. ―Gataj Jesús gunun ni tsínj fariseo. ");
INSERT INTO trq_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ango güi naránj ruhua ni ngüi̱, ni̱ gatúj Jesús chruhua si-nuhui ni tsínj israelita. Ni̱ gaxi̱ꞌi sij digyán sij rian ni tsínj daj. Ni̱ yuꞌuj daj ni̱ nne ꞌngo̱ tsínj hua naco̱ anéj chrej raꞌa sa̱ꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ni̱ nagaꞌnaj ni tsínj digyán ley nga̱ ni tsínj fariseo sisi̱ ga̱nahuin tsínj daj, gui̱ꞌyaj Jesús güi naránj ruhua ni ngüi̱. Daj si huin ruhua ni síꞌ ga̱ꞌmi gaquinꞌ ni síꞌ xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Sani̱ guiniꞌi Jesús si ani ruhua ni síꞌ. Ngaa ni̱ gataj Jesús rian tsínj daj: ―Na̱xuman so̱ꞌ, ni̱ gui̱niquinꞌ so̱ꞌ da̱ni ni únj. ―Daj gataj Jesús. Ngaa ni̱ naxu̱man tsínj daj. Ni̱ ganiquinꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ni̱ gataj Jesús gunun ni tsínj nagaꞌnaj daj: ―Nachínj snanꞌān ꞌngo̱ nuguanꞌ a ni é re̱ꞌ. Aꞌuej si-ley Yanꞌanj sisi̱ gui̱ꞌyaj sa̱ꞌ néꞌ güi naránj ruhua néꞌ níꞌ. Asi̱ sa̱ꞌ gui̱ꞌyaj quij néꞌ, ruhua á re̱ꞌ níꞌ. Ni̱ aꞌuej si-ley Yanꞌanj sisi̱ na̱caj néꞌ ꞌngo̱ tsínj ruhua ga̱huiꞌ níꞌ. Asi̱ sa̱ꞌ ga̱huiꞌ sij, ruhua á re̱ꞌ sa̱ꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ni̱ niꞌyaj Jesús rian daranꞌ ni tsínj mán ganica̱j xiꞌníj sij. Ni̱ gataj sij gunun tsínj daj: ―Du̱cua so̱ꞌ raꞌá so̱ꞌ. ―Gataj Jesús. Ni̱ ducua síꞌ raꞌa síꞌ. Ni̱ ganahuin raꞌa síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Sani̱ ducu gaꞌman ruhua ni tsínj nagaꞌnaj daj. Ni̱ gaxi̱ꞌi ni sij digaꞌmi dugüiꞌ ni sij sisi̱ da̱j gui̱ꞌyaj xi̱ꞌi ni sij nga̱ Jesús. ");
INSERT INTO trq_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ni̱ ꞌngo̱ ni güi daj ganꞌanj Jesús riqui ꞌngo̱ quij. Ni̱ gachínj jniꞌyaj sij ni̱ganꞌ ni̱nꞌ rian Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ni̱ ngaa guixigui̱n, ni̱ gaquínj sij ni tsínj nicoꞌ sij ga̱ꞌnaꞌ. Ni̱ nacui sij xu̱huij ni síꞌ. Ni̱ duguꞌna̱j sij ni tsínj daj apóstol. Ni̱ nuguanꞌ daj huin ruhuaj gata tsínj aꞌmi si-nu̱guanꞌ Jesús rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ni̱ ꞌngo̱ ni sij huin Simón. Ni̱ duguꞌna̱j Jesús Pedro síꞌ nej. Ni̱ ango síꞌ huin jnánj Pedro, tsínj gu̱ꞌnaj Andrés. Ni̱ ángo ni síꞌ huin Juan nej, Felipe nej, Bartolomé nej, ");
INSERT INTO trq_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo nej, Tomás nej, Jacobo, daꞌníj Alfeo nej. Ni̱ ángo síꞌ huin Simón huin síꞌ tsínj gu̱ꞌnaj Celote nej. ");
INSERT INTO trq_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ni̱ ángo síꞌ huin Judas, tsínj huin jnánj Jacobo. Ni̱ ángo síꞌ huin Judas, tsínj digyán chrej rian ni tsínj gaꞌna̱ꞌ gui̱daꞌa Jesús. ");
INSERT INTO trq_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ni̱ nanij Jesús riqui quij nga̱ xu̱huij ni apóstol. Ni̱ ganiquinꞌ sij rian hua ta. Ni̱ nahuin yuꞌ nico ni tsínj nicoꞌ rucu sij nga̱ nico ni ngüi̱ ꞌna̱ꞌ estado Judea nga̱ xumanꞌ Jerusalén nej, ni ngüi̱ ma̱n duꞌua nnee yanꞌanj huin nu̱ngüej xumanꞌ gu̱ꞌnaj Tiro nga̱ Sidón nej. Ni̱ guisíj ni ngüi̱ daj rian nne Jesús si gahuin ruhua ni sij gu̱nun ni sij si-nu̱guanꞌ síꞌ. Ni̱ gahuin ruhua ni sij ga̱nahuin ni sij sisi̱ xiꞌnej xiꞌi̱ aꞌnanꞌ ni sij, gui̱ꞌyaj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ni̱ ganahuin ni ngüi̱ yaco ranꞌ ꞌyaj ni nane̱ xi̱ꞌi, guiꞌyaj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ni̱ gahuin ruhua ni ngüi̱ ga̱nun raꞌa ni sij manꞌan Jesús xiꞌí si nicaj fuerza síꞌ. Ni̱ ganahuin daranꞌ ni sij, guiꞌyaj síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ngaa ni̱ nachica Jesús rian sij niꞌyaj sij ni tsínj nicoꞌ sij. Ni̱ gataj sij: ―Hua ꞌueé rian án re̱ꞌ si huin ni é re̱ꞌ ni ngüi̱ yaco ranꞌ. Daj si ga̱ne ni̱ganj ni é re̱ꞌ rian nicaj sun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Hua ꞌueé rian ni é re̱ꞌ si huin ni é re̱ꞌ ni ngüi̱ achin xiꞌna̱ riqui yya̱j. Daj si gui̱riꞌ a ni é re̱ꞌ si xa̱ nico ni é re̱ꞌ, gui̱ꞌyaj Yanꞌanj. ’Ni hua ꞌueé gui̱ꞌyaj Yanꞌanj rian án re̱ꞌ si huin a ni é re̱ꞌ ni ngüi̱ aco. Daj si ga̱ꞌngaꞌ ni é re̱ꞌ, gui̱ꞌyaj Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Ni hua ꞌueé rian án re̱ꞌ si nun huin xa̱nꞌ ruhua ni ngüi̱ ni̱ꞌyaj ni sij ni é re̱ꞌ, sisi̱ ri ni̱ni ni sij ni é re̱ꞌ nej, sisi̱ aꞌmi quij ni sij rian xiꞌí ni é re̱ꞌ nej, sisi̱ aꞌmi quij ni sij xiꞌí si-xugüi ni é re̱ꞌ xiꞌí si nicoꞌ ni é re̱ꞌ manꞌānj, huīnj daꞌníj ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ngaa ni̱ güi gui̱ranꞌ a ni é re̱ꞌ daj, ni̱ ducu ga̱huin nia̱ꞌ ruhua á re̱ꞌ. Ni̱ güe̱j a ni é re̱ꞌ ga̱huin nia̱ꞌ ruhua á re̱ꞌ xiꞌí si gui̱ꞌyaj sa̱ꞌ ꞌueé Yanꞌanj nga̱ á re̱ꞌ ngaa na̱nꞌ ni é re̱ꞌ xataꞌ. Ni̱ hué daj guiꞌyaj quij ni xi ni tsínj ꞌyaj quij daj nga̱ ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Sani̱ ducu niqui niman ni é re̱ꞌ huin ni é re̱ꞌ ni tsínj xuruꞌue. Daj si urin xungüi̱ nan gui̱riꞌ ni é re̱ꞌ si huin nia̱ꞌ ruhua ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Ni ducu niqui niman ni é re̱ꞌ ni tsínj gara ran riqui yya̱j. Sani̱ ne̱ꞌ ru̱cu ni̱ ga̱chin xiꞌna̱ riqui ni é re̱ꞌ. ’Ni̱ ducu niqui niman ni é re̱ꞌ ni tsínj aꞌngaꞌ acuanꞌ. Sani̱ ne̱ꞌ ru̱cu ni̱ na̱ni ruhua á re̱ꞌ. Ni̱ ga̱co ni é re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Ni ducu niqui niman ni é re̱ꞌ ngaa aꞌmi sa̱ꞌ ni ngüi̱ xiꞌí ni é re̱ꞌ. Ni̱ daꞌngaꞌ daj gaꞌmi ni xi ni ngüi̱ daj rian ni tsínj gataj sisi̱ aꞌmi ni síꞌ si-nu̱guanꞌ Yanꞌanj xa̱ngaꞌ. Sani̱ tsínj digyaꞌ yunꞌunj huin ni síꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ni̱ gataj ru̱huaꞌ yún Jesús: ―Sani̱ atā gu̱nun a ni é re̱ꞌ sisi̱ ga̱huin ꞌi̱ ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ ni ngüi̱ ununꞌ nga̱ á re̱ꞌ. Ni̱ gui̱ꞌyaj sa̱ꞌ á re̱ꞌ nga̱ ni tsínj nun huin xa̱nꞌ ruhua niꞌyaj á re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ni̱ ga̱ꞌmi sa̱ꞌ a ni é re̱ꞌ rian ni ngüi̱ aꞌmi nuguanꞌ quij rian án re̱ꞌ. Ni̱ ga̱chinj jniꞌyaj á re̱ꞌ rian Yanꞌanj sisi̱ gui̱ꞌyaj Yanꞌanj sinduj rian ni ngüi̱ aꞌmi quij rian án re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ni̱ sisi̱ hua ꞌngo̱ tsínj ga̱ꞌuiꞌ anéj chrej rián re̱ꞌ, ni̱ ga̱ꞌninꞌ ruhuá re̱ꞌ da̱nicaj re̱ꞌ ga̱ꞌuiꞌ síꞌ anéj chrej rián re̱ꞌ nej. Sisi̱ ga̱ꞌnej ꞌngo̱ tsínj si-re̱to re̱ꞌ, ni̱ ga̱ꞌninꞌ ruhuá re̱ꞌ si ga̱ꞌnej sij si-gató re̱ꞌ nánj. ");
INSERT INTO trq_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ga̱ra xiná re̱ꞌ ga̱ꞌuiꞌ re̱ꞌ si achínj ni ngüi̱ rián re̱ꞌ. Ni̱ sisi̱ ga̱ꞌnej ni ngüi̱ ꞌngo̱ siꞌyáj re̱ꞌ, ni̱ si̱ nachínj re̱ꞌ siꞌyáj re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ni̱ da̱j rúnꞌ huin ruhua ni é re̱ꞌ gui̱ꞌyaj sa̱ꞌ ni ngüi̱ nga̱ ni é re̱ꞌ, ni̱ daꞌngaꞌ daj gui̱ꞌyaj sa̱ꞌ manꞌan ni é re̱ꞌ nga̱ ni sij. ");
INSERT INTO trq_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Ni̱ sisi̱ ꞌi̱ ruhua ni é re̱ꞌ niꞌyaj ni é re̱ꞌ urin ni ngüi̱ ꞌi̱ ruhua niꞌyaj manꞌán re̱ꞌ, ngaa ni̱ si̱ gani ruhua á re̱ꞌ sisi̱ na̱ruꞌue Yanꞌanj rian án re̱ꞌ mánj. Daj si da ni tsínj ꞌyaj gaquinꞌ, ni̱ ꞌi̱ ruhua ni sij niꞌyaj ni sij ni tsínj ꞌi̱ ruhua niꞌya ni sij. ");
INSERT INTO trq_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ni̱ sisi̱ gui̱ꞌyaj sa̱ꞌ re̱ꞌ rian urin ni ngüi̱ ꞌyaj sa̱ꞌ nga̱ manꞌán re̱ꞌ, ngaa ni̱ u̱n sin huin ni̱ na̱ruꞌue Yanꞌanj rian án re̱ꞌ, ruhua á re̱ꞌ únj. Daj si ꞌyaj sa̱ꞌ ni ngüi̱ ꞌyaj gaquinꞌ rian ni dugüiꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ni̱ sisi̱ chra̱cuij re̱ꞌ sanꞌanj rian urin ni ngüi̱ ga̱ꞌue na̱ruꞌue rián re̱ꞌ, ngaa ni̱ sé ꞌngo̱ nuguanꞌ huin mánj. Ni̱ u̱n sin huin ni̱ na̱ruꞌue Yanꞌanj rian án re̱ꞌ, ruhua á re̱ꞌ únj. Daj si daꞌngaꞌ daj ꞌyaj ni tsínj ꞌyaj gaquinꞌ, chracuij ni sij sanꞌanj rian ni dugüiꞌ ni sij. Ni̱ anaꞌuij ni sij si na̱huin raꞌa ni sij. ");
INSERT INTO trq_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","’Hué dan ni̱ ga̱huin ꞌi̱ ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ ni ngüi̱ ununꞌ nga̱ á re̱ꞌ. Ni̱ gui̱ꞌyaj sa̱ꞌ á re̱ꞌ rian ni ngüi̱ nej. Ni̱ chra̱cuij a ni é re̱ꞌ rasu̱n ni ngüi̱. Ni̱ si̱ ganaꞌuij ni é re̱ꞌ si na̱riqui ru̱huaꞌ yún ni sij rian án re̱ꞌ mánj. Ngaa ni̱ manꞌan Yanꞌanj gui̱ꞌyaj ꞌueé ni̱nꞌ nga̱ á re̱ꞌ. Ni̱ ga̱huin a ni é re̱ꞌ daꞌníj Yanꞌanj achij nne xataꞌ. Daj si ꞌyaj sa̱ꞌ Yanꞌanj nga̱ ni ngüi̱ nitaj si acaj cuenta si ꞌyaj sa̱ꞌ Yanꞌanj rian ni sij. Ni̱ hué daj ꞌyaj sa̱ꞌ Yanꞌanj nga̱ ni ngüi̱ xi̱ꞌi nej. ");
INSERT INTO trq_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ni̱ ga̱huin ꞌi̱ ruhua ni é re̱ꞌ ni̱ꞌyaj á re̱ꞌ ni ngüi̱ da̱j rúnꞌ ꞌi̱ ruhua chrej ni é re̱ꞌ nne xataꞌ niꞌya yu̱nꞌ nej aj. ");
INSERT INTO trq_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Si̱ gaꞌuiꞌ a ni é re̱ꞌ gaquinꞌ dugüiꞌ a ni é re̱ꞌ mánj. Asíj ni̱ si̱ gaꞌuiꞌ Yanꞌanj gaquinꞌ a ni é re̱ꞌ. Ni̱ si̱ gataj ni é re̱ꞌ sisi̱ daꞌui dugüiꞌ ni é re̱ꞌ gaquinꞌ mánj. Ngaa ni̱ nitaj si ga̱taj Yanꞌanj si daꞌui manꞌan án re̱ꞌ gaquinꞌ nej. Gui̱nicaj ni é re̱ꞌ ꞌngo̱ niman nico rian ni dugüiꞌ ni é re̱ꞌ, ngaa ni̱ Yanꞌanj gui̱nicaj ꞌngo̱ niman nico rian xiꞌí manꞌan ni é re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ga̱ꞌuiꞌ ni é re̱ꞌ rian ni ngüi̱, ngaa ni̱ Yanꞌanj ri̱qui rian án re̱ꞌ nej. Ni̱ da̱j rúnꞌ ꞌyaj ꞌngo̱ tsínj sa̱ꞌ ruhua duꞌuej ꞌníj, ni̱ ara sa̱ꞌ sij rio̱, ni̱ daꞌngaꞌ daj gui̱riun sa̱ꞌ Yanꞌanj rio̱ riqui-íꞌ rian néꞌ ga̱ꞌnij néꞌ chruhua xinánj néꞌ. Ni̱ gui̱ꞌyaj ran Yanꞌanj rio̱. Ni̱ na̱gunanꞌ-ánꞌ rio̱ daj. Ni̱ ga̱ra sa̱ꞌ Yanꞌanj rio̱ daj nej. Ni̱ da̱j rúnꞌ ꞌyaj ni é re̱ꞌ nga̱ dugüiꞌ ni é re̱ꞌ, ni̱ daꞌngaꞌ daj gui̱ꞌyaj Yanꞌanj nga̱ ni é re̱ꞌ nej. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ngaa ni̱ nani Jesús ꞌngo̱ cuento digyán sij rian ni tsínj nicoꞌ sij. Ni̱ gataj sij: ―Ni̱ ga̱ꞌue di̱gyán tsínj duri daj chrej rian ango tsínj duri ga̱nꞌanj nu̱ngüej sij ruhua á re̱ꞌ níꞌ. Si̱ gaꞌue mánj. Ga̱nꞌanj nu̱ngüej sij, sani̱ gui̱nij nu̱ngüej sij chruhua ꞌngo̱ yuꞌuj nánj. ");
INSERT INTO trq_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nitaj si huin rian ꞌngo̱ tsínj ꞌna̱ꞌ ga̱huin chru̱n daj nga̱ tsínj digyán rian sij. Sani̱ sisi̱ ga̱huin chru̱n sa̱ꞌ sij, ngaa ni̱ ga̱huin sij rúnꞌ huin tsínj digyán rian sij. ");
INSERT INTO trq_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ni̱ u̱n sin huin ni̱ niꞌyáj re̱ꞌ sisi̱ nu̱n daru̱ chrun rundij rian jnánj re̱ꞌ únj. Sani̱ nitaj si niꞌyáj re̱ꞌ si nu̱n ꞌngo̱ caj rundij rian manꞌán re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ni̱ sisi̱ nitaj si acáj re̱ꞌ cuenta si nu̱n ꞌngo̱ caj rián re̱ꞌ, ni̱ asa̱ꞌ ga̱ꞌue ga̱taj re̱ꞌ rian jnánj re̱ꞌ: “Gui̱niquinꞌ acuánꞌ re̱ꞌ, ni̱ gui̱rīj daru̱ chrun rundij rián re̱ꞌ aj.” Ni̱ sisi̱ da̱j atáj re̱ꞌ, ni̱ tsínj digyaꞌ yunꞌunj huín re̱ꞌ. Gui̱ri siní re̱ꞌ caj nu̱n rian manꞌán re̱ꞌ aj. Ngaa ni̱ ga̱ꞌue gui̱niꞌyaj sa̱ꞌ re̱ꞌ gui̱ri re̱ꞌ daru̱ chrun rian jnánj re̱ꞌ aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ngaa ni gataj ru̱huaꞌ yún Jesús: ―Ni̱ chrun sa̱ꞌ, ni̱ si̱ gaꞌue ga̱yu chruj nitaj si hua sa̱ꞌ mánj. Ni̱ chrun nitaj si hua sa̱ꞌ, ni̱ si̱ gaꞌue ga̱yu chruj hua sa̱ꞌ chraj mánj. ");
INSERT INTO trq_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ngaa ni̱ꞌyaj néꞌ da̱j hua si ayu chra̱ ꞌngo̱ chrun daj, ni̱ niꞌi néꞌ u̱n chrun huin-ínꞌ. Si̱ gaꞌue ga̱ꞌne néꞌ higo riqui ni coj tanj mánj. Ni̱ si̱ gaꞌue na̱ranꞌ néꞌ uva riqui coj yatan mánj. ");
INSERT INTO trq_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ni̱ ꞌngo̱ tsínj sa̱ꞌ, ni̱ aꞌmi síꞌ nuguanꞌ sa̱ꞌ xiꞌí si nara sa̱ꞌ síꞌ nuguanꞌ hua sa̱ꞌ chruhua niman síꞌ. Sani̱ tsínj quij hua, ni̱ aꞌmi síꞌ nuguanꞌ quij xiꞌí si nara síꞌ nuguanꞌ quij chruhua niman síꞌ. Daranꞌ ni nuguanꞌ nara néꞌ chruhua nimúnꞌ, ni̱ hué ni nuguanꞌ daj ahui duꞌóꞌ aꞌmíꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús: ―Ni̱ u̱n sin huin ataj ni é re̱ꞌ sisi̱ Señor huīnj, sani̱ nitaj si dagahuin a ni é re̱ꞌ si atā gu̱nun a ni é re̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yya̱j ni̱ ga̱tā gu̱nun a ni é re̱ꞌ da̱j hua ꞌngo̱ tsínj ꞌna̱ꞌ riānj. Ni̱ unun síꞌ. Ni̱ dagahuin síꞌ si atā gu̱nun síꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Huin síꞌ rúnꞌ huin ꞌngo̱ tsínj gui̱ꞌyaj hueꞌ. Gánj gu̱nun sini ya̱n síꞌ gu̱nun ni̱nꞌ ruhua. Ni̱ guneꞌ síꞌ daqui hueꞌ-éꞌ rian huej. Hué dan ni̱ ducu gahui nane̱. Ni̱ gara xinéj nnee. Ni̱ gaꞌuiꞌ nucuaj nnee daj rian hueꞌ. Sani̱ nun guisiquiꞌ hueꞌ daj. Daj si gahuin ran sa̱ꞌ hueꞌ-éꞌ guneꞌ síꞌ rian huej. ");
INSERT INTO trq_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ni̱ hua ango tsínj unun si-nu̱guanꞌānj. Sani̱ nun di̱gahuin síꞌ si atā gu̱nun síꞌ. Ni̱ tsínj daj huin rúnꞌ huin ꞌngo̱ tsínj guiꞌyaj hueꞌ rian yoꞌój chru. Sani̱ nun ga̱nj gu̱nun síꞌ rian guneꞌ síꞌ daqui hueꞌ. Ngaa ni̱ gara xinéj nnee. Ni̱ gaꞌuiꞌ nucuaj nnee daj rian hueꞌ. Ngaa ni̱ ꞌngo̱ ganatúj óꞌ. Ni̱ ꞌngo̱ guereꞌ hueꞌ-éꞌ da aj. Daj hua tsínj nun unun si-nu̱guanꞌānj. ―Gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ngaa guisíj gaꞌmi Jesús rian ni ngüi̱ daj, ni̱ ganꞌanj sij xumanꞌ Capernaum. ");
INSERT INTO trq_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ni̱ yuꞌuj daj nne ꞌngo̱ snado centurión. Ni̱ aꞌnanꞌ ꞌngo̱ si-moso capitán daj. Ni̱ ruhua ga̱huiꞌ síꞌ. Ni̱ ꞌi̱ ruhua sij niꞌyaj sij si-moso sij. ");
INSERT INTO trq_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ni̱ ngaa gunun centurión daj si aꞌmi ni ngüi̱ xiꞌí Jesús, ni̱ gaꞌníj sij go̱ꞌngo ni tsínj huin achij ma̱n scanij ni tsínj israelita, ga̱nꞌanj ga̱chinj jniꞌyaj ni síꞌ rian Jesús sisi̱ ga̱ꞌnaꞌ gui̱ꞌyaj go̱noꞌo Jesús si-moso centurión daj. ");
INSERT INTO trq_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ni̱ ngaa guisíj ni sij rian Jesús, ni̱ gaꞌmi yaco ni sij. Ni̱ gataj ni sij: ―Hua nia̱n chra̱cuij re̱ꞌ centurión daj. ");
INSERT INTO trq_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Daj si ꞌi̱ ruhua sij niꞌyaj sij néꞌ huin néꞌ ni tsínj israelita. Ni̱ hué sij guiꞌyaj si-nuhui néꞌ nej. ―Gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ngaa ni̱ ganꞌanj Jesús nga̱ ni sij. Ni̱ ngaa ruhua ga̱huin ni̱chrunꞌ Jesús gui̱sij sij hueꞌ, ni̱ gaꞌníj centurión daj ga̱nꞌanj go̱ꞌngo ni tsínj nicaj dugüiꞌ nga̱ sij, ga̱taj ni síꞌ gu̱nun Jesús: ―Señor, si̱ gahuin ruhuá re̱ꞌ mánj. Daj si sé tsínj sa̱ꞌ huin tsínj daj, ataj sij. Xiꞌí daj ni̱ si̱ gatúj re̱ꞌ chruhua ducuá sij, ataj sij mánj. ");
INSERT INTO trq_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ni̱ xiꞌí si sé tsínj sa̱ꞌ huin sij ruhua sij, ni̱ nun gui̱sij ruhua sij gu̱chiꞌ sij rián re̱ꞌ, ataj sij. Maan si ga̱ꞌninꞌ re̱ꞌ sun, ni̱ ga̱nahuin si-moso sij, gui̱ꞌyáj re̱ꞌ, ataj sij. ");
INSERT INTO trq_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Daj si hua tsínj aꞌninꞌ sun rian sij. Ni̱ hué sij aꞌninꞌ sun rian ni snado nej. Ni̱ ngaa aꞌníj sij ꞌngo̱ snado ga̱nꞌanj síꞌ, ni̱ hua̱nꞌanj síꞌ. Ni̱ ngaa ataj sij ga̱ꞌnaꞌ ꞌngo̱ síꞌ, ni̱ ꞌna̱ꞌ síꞌ nej. Ni̱ ngaa aꞌníj sij si-moso sij gui̱ꞌyaj sun síꞌ, ni̱ hué daj gui̱ꞌyaj sun síꞌ nej. ―Daj gataj ni dugüiꞌ centurión daj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ni̱ ngaa gunun Jesús nuguanꞌ gataj tsínj daj, ni̱ ganꞌanj ruhua sij. Ni̱ guiniꞌyaj sij rian ni tsínj nicoꞌ sij. Ni̱ gataj sij: ―Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ nun nariꞌīj ꞌngo̱ tsínj israelita xuman ruhua rúnꞌ xuman ruhua tsínj centurión nan mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ni̱ ngaa nanica̱j ni tsínj nicaj dugüiꞌ nga̱ centurión daj ganꞌanj ni sij ducuá síꞌ, ni̱ xacaj ni sij cuenta sisi̱ hua ganahuin moso daj. ");
INSERT INTO trq_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Hué daj síj ni̱ ganꞌanj Jesús ꞌngo̱ xumanꞌ gu̱ꞌnaj Naín. Ni̱ huaj ni tsínj nicoꞌ sij nicaj dugüiꞌ ni síꞌ nga̱ nico ni ngüi̱ huaj ni síꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ni̱ ngaa huaj gui̱sij sij duꞌua xumanꞌ daj, ni̱ guiniꞌi sij si huaj ga̱chinꞌ ni ngüi̱ xa̱nj daj ꞌngo̱ níman. Ni̱ tsínj gahuiꞌ daj huin urin daꞌníj yunꞌunj mmij. Ni̱ huaj ni̱nꞌ ruhua ni ngüi̱ xa̱nj nga̱ yunꞌunj mmij da nej. ");
INSERT INTO trq_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ni̱ gani yaco ruhua Señor niꞌi sij yunꞌunj mmij daj. Ni̱ gataj sij: ―Si̱ gacó so̱ꞌ mánj. ―Gataj Jesús gunun únꞌ. ");
INSERT INTO trq_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ngaa ni̱ ganꞌanj nichi Jesús. Ni̱ ganun raꞌa sij chrun xéj. Ni̱ guiniquinꞌ ni tsínj ata níman. Ni̱ gataj Jesús gunun tsínj gahuiꞌ daj: ―Tsínj snoꞌo. Na̱chica re̱ꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ngaa ni̱ nachica tsínj gahuiꞌ daj gane síꞌ. Ni̱ gaxi̱ꞌi síꞌ gaꞌmi síꞌ. Ni̱ nagaꞌuiꞌ Jesús manꞌan síꞌ raꞌa nni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ni̱ ngaa guiniꞌi ni ngüi̱ si guiꞌyaj Jesús, ni̱ guxuꞌuiꞌ daranꞌ ni sij. Ni̱ gaxi̱ꞌi ni sij gaꞌmi sa̱ꞌ ni sij rian Yanꞌanj. Ni̱ gataj ni sij: ―Gurugüiꞌ ꞌngo̱ tsínj huin achij aꞌmi si-nu̱guanꞌ Yanꞌanj scanij néꞌ. ―Daj gataj ni sij. Ni̱ gataj ni sij nej: ―Ni̱ ꞌna̱ꞌ niꞌyaj Yanꞌanj ni ngüi̱ nicoꞌ manꞌan Yanꞌanj. ―Gataj ni sij gunun ni dugüiꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ni̱ gaxaꞌni̱ nuguanꞌ xiꞌí si guiꞌyaj Jesús ni̱nꞌ ga̱chraꞌ estado Judea nga̱ ango ni xumanꞌ ngaj ni̱chrunꞌ nga̱-áꞌ. ");
INSERT INTO trq_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ni̱ nataꞌ ni tsínj nicoꞌ Juan si guiꞌyaj Jesús gunun manꞌan síꞌ. Ngaa ni̱ gaquínj Juan hui̱j tsínj nicoꞌ síꞌ ga̱ꞌnaꞌ nu̱ngüej sij rian síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ngaa ni̱ gaꞌníj Juan ga̱nꞌanj nu̱ngüej sij na̱chinꞌ snanꞌanj nu̱ngüej sij Jesús. Ni̱ nan huin nuguanꞌ gaꞌníj Juan rian Jesús: ―Hué re̱ꞌ huin tsínj na̱caj ni ngüi̱ níꞌ. Asi̱ ga̱naꞌuij únj si ga̱ꞌnaꞌ ango tsínj sa̱ꞌ. ―Daꞌngaꞌ daj huin nuguanꞌ gaꞌníj Juan rian Jesús. ");
INSERT INTO trq_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Hué dan ni̱ guisíj nu̱ngüej sij rian Jesús. Ni̱ gataj nu̱ngüej sij: ―Gaꞌníj Juan, tsínj duguataꞌ nnee, ga̱ꞌnaꞌ na̱chinꞌ snanꞌanj nu̱ngüej únj manꞌán re̱ꞌ sisi̱ so̱ꞌ huin tsínj ga̱ꞌnaꞌ na̱caj ni ngüi̱ níꞌ. Asi̱ ga̱naꞌuij únj ango tsínj ga̱ꞌnaꞌ sa̱ꞌ. ―Gataj nu̱ngüej sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ni̱ hué gue̱ hora daj, ni̱ ganahuin nico ni ngüi̱ aꞌnanꞌ, guiꞌyaj Jesús. Ni̱ guiri sij nane̱ xi̱ꞌi niman ni ngüi̱ nej. Ni̱ naxigui̱n rian ni ngüi̱ duri, guiꞌyaj sij nej. ");
INSERT INTO trq_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Hué xiꞌí daj ni̱ gataj Jesús gunun nu̱ngüej sij: ―Güi̱j nu̱ngüej é re̱ꞌ. Ni̱ na̱taꞌ nu̱ngüej é re̱ꞌ gu̱nun Juan si guiniꞌi nu̱ngüej é re̱ꞌ nga̱ si gunun nu̱ngüej é re̱ꞌ nej. Daj si xigui̱n niꞌyaj ni ngüi̱ duri. Ni̱ chéj ni tsínj yacuan nej. Ni̱ nahuin sa̱ꞌ ni ngüi̱ aꞌnanꞌ xiꞌi̱ nnij nej. Ni̱ naxiꞌníj chraquij ni tsínj soꞌo nej. Ni̱ ganáꞌnij ni níman gahuiꞌ nej. Ni̱ unun ni ngüi̱ yaco ranꞌ nuguanꞌ sa̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ni̱ hua ꞌueé rian ꞌngo̱ tsínj nitaj si na̱nicaj ruhua ni̱ꞌyaj sij xiꞌīj. Daj ga̱taj nu̱ngüej é re̱ꞌ rian Juan. ―Daj gataj Jesús rian nu̱ngüej tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ni̱ ngaa nanica̱j nu̱ngüej síꞌ na̱nꞌ nu̱ngüej síꞌ rian Juan, ngaa ni̱ gaxi̱ꞌi gaꞌmi sa̱ꞌ Jesús rian ni ngüi̱ xiꞌí Juan. Ni̱ gataj síꞌ: ―Ni̱ ngaa ganꞌanj ni é re̱ꞌ gunun ni é re̱ꞌ si-nu̱guanꞌ Juan quij quiꞌyanj na̱co, ni̱ da̱j hua sij guiniꞌi ni é re̱ꞌ, ruhua ni é re̱ꞌ únj. Da̱j rúnꞌ ꞌyaj ria̱ ngaa xinunj ꞌyaj nane̱, ni̱ daꞌngaꞌ daj ꞌyaj sij, ruhua ni é re̱ꞌ níꞌ. ");
INSERT INTO trq_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ni̱ sisi̱ sé daj ꞌyaj sij, ni̱ u̱n sin huin ni̱ ganꞌanj ni̱ꞌyaj á re̱ꞌ rian huaj sij únj. Ganꞌanj niꞌyaj á re̱ꞌ ꞌngo̱ tsínj nu̱n atsij nia̱ꞌ níꞌ. Sani̱ sé daj huin sij mánj. Niꞌi ni é re̱ꞌ sisi̱ ni tsínj nu̱n atsij nia̱ꞌ nga̱ ni tsínj utinꞌ nico sanꞌanj, ni̱ nne ni síꞌ ducuá ni rey. ");
INSERT INTO trq_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ni̱ u̱n sin huin ni̱ ganꞌanj ni̱ꞌyaj á re̱ꞌ rian nne sij únj. Asi̱ ꞌngo̱ tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj níꞌ. Xa̱ngaꞌ ni̱ hué daj huin sij aj. Ni̱ hua achij Juan daj nga̱ daranꞌ ango ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","’Ni̱ asi̱j ná ni̱ garun sa̱ꞌ ꞌngo̱ tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj xiꞌí Juan. Ni̱ gataj Yanꞌanj: Aꞌnī ꞌngo̱ tsínj gui̱nicaj nuguanꞌ gu̱chiꞌ sij. Ni̱ tsínj daj gui̱taj dian sini rián re̱ꞌ ga̱nꞌanj sij. Ni̱ gui̱ꞌyaj xugüi sij si-chréj re̱ꞌ aj. Daj gataj si-nu̱guanꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","’Ni̱ atā gu̱nun a ni é re̱ꞌ sisi̱ scanij ni tsínj gaꞌnga, guiꞌyaj ni yunꞌunj xa̱na, ni̱ nitaj si rugüiꞌ ꞌngo̱ tsínj huin achij da̱j rúnꞌ huin manꞌan Juan tsínj duguataꞌ nnee. Sani̱ tsínj hua lij ni̱nꞌ, ni̱ huin achij sij rian nicaj sun Yanꞌanj daj nga̱ manꞌan Juan ga̱. ―Daj gataj Jesús gunun ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ni̱ ngaa gunun ni ngüi̱ nga̱ ni tsínj aꞌnej pesto si gataj Jesús, ni̱ gataj ni sij sisi̱ duguꞌna̱j huaj guiꞌyaj Yanꞌanj. Daj si hua gataꞌ nnee ni síꞌ, guiꞌyaj Juan. ");
INSERT INTO trq_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Sani̱ ni tsínj fariseo nga̱ ni tsínj digyán ley, ni̱ nun ga̱ꞌuej ruhua ni sij gu̱nun ni sij da̱j huin ruhua Yanꞌanj gui̱ꞌyaj Yanꞌanj xiꞌí ni sij mánj. Daj si nun gataꞌ nnee ni sij, guiꞌyaj Juan. ");
INSERT INTO trq_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ngaa ni̱ gataj Jesús: ―Da̱j u̱n sin huin gui̱ꞌyā gui̱riꞌ di̱gyānj rian án re̱ꞌ da̱j hua ni ngüi̱ mán acuanꞌ nan únj. ");
INSERT INTO trq_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Da̱j rúnꞌ ꞌyaj ni tsinꞌ ganꞌanj ga̱ne rian yuꞌue̱ ngaa ducuj, ni̱ agua ni dugüiꞌ, ni̱ hué daj huin ni sij. Ni̱ ataj aninꞌinj: “Aꞌyanj únj ria̱ rian án re̱ꞌ saj. Sani̱ nun gui̱ranꞌanj a ni é re̱ꞌ mánj. Garáj ni únj chraꞌ snanga. Sani̱ nun gaco ni é re̱ꞌ mánj.” Hué daj ataj ni tsinꞌ rian ni dugüiꞌ ni tsinꞌ anj. ");
INSERT INTO trq_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Daj si gaꞌna̱ꞌ Juan tsínj duguataꞌ nnee, ni̱ nun xa sij chrachrúnj, nun goꞌo sij nnee vino nej. Ni̱ xiꞌí daj ataj á re̱ꞌ sisi̱ nu̱n nane̱ xi̱ꞌi niman sij aj. ");
INSERT INTO trq_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Asíj ni̱ gaꞌna̱ꞌ daꞌníj ni ngüi̱ huin manꞌānj. Ni̱ xāj, ni̱ goꞌōj aj. Ni̱ ataj ni é re̱ꞌ sisi̱ huīnj ꞌngo̱ tsínj xa na̱saꞌ, goꞌo na̱saꞌ. Ni̱ huīnj ꞌngo̱ tsínj nicaj dugüiꞌ nga̱ ni ngüi̱ ꞌyaj gaquinꞌ nga̱ ni tsínj aꞌnej pesto nej, ataj á re̱ꞌ xiꞌīj nej. ");
INSERT INTO trq_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sani̱ sisi̱ ꞌyaj sa̱ꞌ ꞌngo̱ tsínj daj, ni̱ ga̱ꞌue gui̱niꞌi néꞌ sisi̱ tsínj niꞌi sa̱ꞌ huin sij. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ngaa ni̱ gaquínj ꞌngo̱ tsínj fariseo xa̱ Jesús nga̱ manꞌan síꞌ. Ngaa ni̱ gatúj Jesús ducuá síꞌ ganꞌanj ga̱ne sij rian mesa. ");
INSERT INTO trq_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ni̱ nne ꞌngo̱ yunꞌunj xa̱na ꞌyaj gaquinꞌ xumanꞌ daj. Ni̱ ngaa gunun únꞌ sisi̱ nne Jesús ducuá fariseo daj xa sij, ni̱ nicaj únꞌ ꞌngo̱ gagaꞌ alabastro nu̱n gasiti guinꞌ da̱j. ");
INSERT INTO trq_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ni̱ niquinꞌ únꞌ ne̱ꞌ xiꞌí Jesús. Ni̱ aco únꞌ. Ni̱ ayanj nnee rian únꞌ aco únꞌ daj dacój Jesús. Ni̱ ane-éꞌ dacój Jesús, ꞌyaj únꞌ. Ni̱ naruhui únꞌ huee chra̱ únꞌ dacój Jesús. Ni̱ jnaco̱ dacój síꞌ, ꞌyaj únꞌ. Ni̱ garun duꞌua únꞌ dacój Jesús. Ni̱ garij únꞌ gasiti guinꞌ da̱j dacój síꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ni̱ ngaa guiniꞌi tsínj fariseo, tsínj du̱cua daj si guiꞌyaj yunꞌunj xa̱na daj, ni̱ gani ruhua manꞌan síꞌ: “Sisi̱ xa̱ngaꞌ yya huin Jesús ꞌngo̱ tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj, ngaa ni̱ xa̱caj síꞌ cuenta sisi̱ yunꞌunj xa̱na ꞌyaj gaquinꞌ huin únꞌ, ni̱ atsi únꞌ manꞌan sij.” Daꞌngaꞌ daj gani ruhua tsínj fariseo daj xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ngaa ni̱ gataj Jesús gunun tsínj fariseo daj: ―Simón, nicā ꞌngo̱ nuguanꞌ ga̱tā gu̱nun re̱ꞌ. ―Gataj Jesús. ―Ga̱taj so̱ꞌ, Maestro. ―Gataj tsínj du̱cua daj. ");
INSERT INTO trq_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ni̱ gataj Jesús: ―Hui̱j ranꞌ tsínj daj daꞌui sanꞌanj rian ꞌngo̱ xuruꞌue. Ni̱ ꞌngo̱ sij ꞌyaj xiquínj u̱nꞌunꞌ ciento sanꞌanj denario. Ni̱ ango sij ꞌyaj xiquínj hui̱j xia chiꞌ sanꞌanj denario. ");
INSERT INTO trq_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ni̱ ri̱an nun guiriꞌ nu̱ngüej sij naruꞌue sij rian xuruꞌue daj, ni̱ gaꞌninꞌ ruhua síꞌ si daꞌui nu̱ngüej sij. Ngaa ni̱, da̱j hua go̱ꞌngo nu̱ngüej sij ga̱ranꞌ doj ruhua niꞌyaj xuruꞌue daj, ruhuá re̱ꞌ únj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","―Ani ruhuāj sisi̱ tsínj daꞌui nico daj, ni̱ garanꞌ doj ruhua sij niꞌyaj sij xuruꞌue. ―Daj gataj Simón. ―Hué dan huin xa̱ngaꞌ yya. ―Daj gataj Jesús gunun Simón huin tsínj fariseo daj. ");
INSERT INTO trq_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ngaa ni̱ nanica̱j Jesús niꞌyaj sij yunꞌunj xa̱na daj. Ni̱ gataj sij gunun Simón: ―Xa̱caj re̱ꞌ cuenta si guiꞌyaj yunꞌunj xa̱na nan níꞌ. Ngaa gatū chruhua ducuá re̱ꞌ, sani̱ nun riquí re̱ꞌ nnee naꞌnīj dacō mánj. Ni̱ yunꞌunj xa̱na nan, ni̱ nnee gaco únꞌ daj naꞌni únꞌ dacō. Ni̱ huee chra̱ únꞌ jnaco̱ únꞌ dacō nej. ");
INSERT INTO trq_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nun garun duꞌuá re̱ꞌ manꞌānj mánj. Sani̱ asi̱j gatū ducuá re̱ꞌ, ni̱ nun duna únꞌ si garun duꞌua únꞌ dacō. ");
INSERT INTO trq_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ni̱ nun garíj re̱ꞌ gasiti chrāj. Sani̱ yunꞌunj daj garij únꞌ gasiti guinꞌ da̱j dacō. ");
INSERT INTO trq_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Xiꞌí daj ni̱ atā gu̱nun re̱ꞌ sisi̱ daꞌui únꞌ nico gaquinꞌ. Sani̱ nicā ꞌngo̱ niman nico xiꞌí ni gaquinꞌ daꞌui únꞌ. Daj si ꞌi̱ ni̱nꞌ ruhua únꞌ niꞌyaj únꞌ yūnj. Sani̱ ngaa ani ruhua ꞌngo̱ tsínj daj sisi̱ do̱j huin gaquinꞌ daꞌui sij, ni̱ do̱j ꞌi̱ ruhua sij niꞌyaj sij yūnj. ―Daj gataj Jesús gunun Simón. ");
INSERT INTO trq_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ngaa ni̱ gataj Jesús gunun yunꞌunj xa̱na daj: ―Nicā ꞌngo̱ niman nico xiꞌí si-ga̱quinꞌ re̱ꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ni̱ nne ango ni tsínj rian mesa daj. Ni̱ gaxi̱ꞌi ni manꞌan ni sij nachínj snanꞌanj ni sij ni dugüiꞌ ni sij. Ni̱ gataj ni sij: ―Ni̱ u̱n tsínj huin tsínj nan, ni̱ ga̱ꞌue gui̱nicaj sij niman nico rian ni gaquinꞌ, ruhua á re̱ꞌ únj. ―Daj gataj ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sani̱ gataj Jesús rian yunꞌunj xa̱na daj: ―Hua nacaj Yanꞌanj manꞌán re̱ꞌ xiꞌí si guxuman ruhuá re̱ꞌ niꞌyáj re̱ꞌ yūnj. Ga̱huin dinꞌinj ruhuá re̱ꞌ na̱nꞌ re̱ꞌ ducuá re̱ꞌ. ―Daj gataj Jesús gunun únꞌ. ");
INSERT INTO trq_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ni̱ ngaa gachin do̱j ni̱ gachéj Jesús daranꞌ rian ni xumanꞌ nga̱ ni rancho nej gaꞌmi sa̱ꞌ sij xiꞌí si nicaj Yanꞌanj sun rian néꞌ. Ni̱ nicaj dugüiꞌ ni xu̱huij ni tsínj nicoꞌ sij nej. ");
INSERT INTO trq_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ni̱ huaj go̱ꞌngo yunꞌunj xa̱na nga̱ sij nej. Ni̱ hua guiri Jesús nane̱ xi̱ꞌi chruhua niman daꞌaj ni ngüi̱ daj. Ni̱ nahuin ango daꞌaj ni únꞌ, guiꞌyaj sij nej. Ni̱ scanij ni únꞌ, ni̱ huaj María gu̱ꞌnaj únꞌ Magdalena. Ni̱ hua guiri Jesús ichij nane̱ xi̱ꞌi chruhua niman únꞌ. ");
INSERT INTO trq_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ni̱ huaj yunꞌunj gu̱ꞌnaj Juana huin únꞌ nica̱ tsínj gu̱ꞌnaj Chuza huin síꞌ tsínj nicaj yunꞌunj ni moso ꞌyaj rey Herodes. Ni̱ huaj yunꞌunj gu̱ꞌnaj Susana nga̱ nico ango ni ngüi̱ xa̱na nej. Ni̱ chracuij ni únꞌ siꞌyaj ni únꞌ rasu̱n gachin rian Jesús. ");
INSERT INTO trq_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ni̱ gahui nico ni ngüi̱ ma̱n rian ni xumanꞌ ganꞌanj ni̱ꞌyaj ni sij Jesús. Ni̱ nahuin yuꞌ nico ni ngüi̱ rian Jesús. Hué dan ni̱ nani Jesús ꞌngo̱ cuento digyán sij rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ni̱ gataj sij: ―Gahui ꞌngo̱ tsínj dagamanꞌ ca̱n. Ni̱ ngaa dagamanꞌ sij, ni̱ guinij do̱j ca̱n chruhua chrej. Ni̱ gachin ni ngüi̱ gurun ni sij. Ni̱ naranꞌ ni xataj xa xuj. ");
INSERT INTO trq_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ni̱ guinij do̱j ca̱n daj rian yoꞌój yej rian nitaj nico yoꞌój. Ni̱ ngaa xiraꞌ ca̱n daj, ni̱ ganacoj. Daj si nitaj si hua ꞌyo yoꞌój daj. ");
INSERT INTO trq_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ni̱ gayu do̱j ca̱n scanij tanj. Ni̱ xiraꞌ nu̱guanꞌan ca̱n daj nga̱ tanj. Hué dan ni̱ gane̱ coj daj, guiꞌyaj tanj. ");
INSERT INTO trq_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ni̱ gayu do̱j ca̱n ango yoꞌój sa̱ꞌ. Ni̱ guixiraꞌ ca̱n daj. Ni̱ gachij manꞌan ca̱n. Ni̱ gayu sa̱ꞌ ca̱n. Ni̱ ꞌngo̱ coj daj gahui ꞌngo̱ ciento ca̱n. ―Daj gataj Jesús nani sij cuento rian ni ngüi̱ daj. Ngaa ni̱ gaꞌmi nucuaj Jesús. Ni̱ gataj sij: ―Sisi̱ nu̱n chraquij a ni é re̱ꞌ, ni̱ gu̱nun a ni é re̱ꞌ nej aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ngaa ni̱ nachínj snanꞌanj ni tsínj nicoꞌ Jesús. Ni̱ gataj ni sij gunun síꞌ: ―Ni̱ u̱n sin huin cuento nan ruhuaj gata únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ngaa ni̱ gataj Jesús: ―Rian ni é re̱ꞌ riqui Yanꞌanj sisi̱ gui̱niꞌi ni é re̱ꞌ da̱j hua rian nicaj sun Yanꞌanj. Sani̱ rian ni ngüi̱ nitaj si nicaj dugüiꞌ ngāj, ni̱ nanīj cuento hua ránj. Ngaa ni̱ gui̱niꞌyaj ni sij. Sani̱ nun gui̱niꞌi ni sij. Ni̱ gu̱nun chraquij ni sij. Sani̱ naꞌue ga̱ra daꞌngaꞌ ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Hué nan huin si ruhuaj gata cuento digyānj rian án re̱ꞌ. Da̱j rúnꞌ hua ca̱n daj, ni̱ daꞌngaꞌ daj hua si-nu̱guanꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ni̱ ca̱n guinij duꞌua chrej, ni̱ rúnꞌ hua ni ngüi̱ gunun nuguanꞌ huaj. Ni̱ gaꞌna̱ꞌ sichre. Ni̱ ri sichre nuguanꞌ sa̱ꞌ daj niman ni sij sisi̱ nun gu̱xuman ruhua ni sij ni̱ꞌyaj ni sij Yanꞌanj. Daj si naꞌuej ruhua sichre si na̱caj Yanꞌanj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ni̱ ca̱n guinij rian yoꞌój yej, ni̱ rúnꞌ hua ni ngüi̱ gunun nuguanꞌ huaj. Daj si ngaa gunun ni sij nuguanꞌ sa̱ꞌ daj, ni̱ nahuin raꞌa ni sij. Ni̱ gahuin nia̱ꞌ ruhua ni sij. Sani̱ ꞌyaj ni sij rúnꞌ ꞌyaj ꞌngo̱ coj nitaj nico yaꞌa̱ siu̱. Do̱j gue̱ güi xuman ruhua ni sij niꞌyaj ni sij Yanꞌanj. Daj si ngaa gui̱ranꞌ ni sij sayun, ni̱ ga̱huin ni̱ni ni sij rian Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ni̱ ca̱n guinij scanij tanj rúnꞌ hua ango ni ngüi̱ gunun nuguanꞌ huaj. Ni̱ huin ruhua ni sij gui̱riꞌ ni sij rasu̱n ma̱n chruhua xungüi̱ nan. Ni̱ digyaꞌ yunꞌunj sanꞌanj ni sij si nahuij ruhua ni sij ga̱huin xuruꞌue ni sij. Ngaa ni̱ nitaj si ꞌyaj sa̱ꞌ ni sij ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ni̱ ca̱n guinij rian yoꞌój sa̱ꞌ hué daj hua ango ni ngüi̱ gunun nuguanꞌ. Ni̱ ngaa gunun ni sij nuguanꞌ sa̱ꞌ daj, ni̱ ga̱huin ni̱ca ruhua ni sij nga̱ nuguanꞌ daj. Daj si hua sa̱ꞌ niman ni sij. Ni̱ hua ni̱ca niman ni sij nej. Ni̱ ꞌyaj sa̱ꞌ ni sij. Ni̱ nitaj si du̱na ni sij si-chrej Yanꞌanj mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús: ―Ni̱ ngaa arúnꞌ yanꞌa̱n chra̱ ꞌngo̱ candil, ni̱ si̱ guneꞌ hui̱ néꞌ riqui chru nga̱ riqui nna ganun yanꞌa̱n daj. Sani̱ gu̱toꞌ xataꞌ rian mesa sisi̱ gui̱xiguin yanꞌa̱n daj rian ni ngüi̱ ga̱tu chruhua hueꞌ gui̱niꞌi ni sij. ");
INSERT INTO trq_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ngaa ni̱ ni̱ a̱ ꞌngo̱ nuguanꞌ naránj ni ngüi̱ acuanꞌ, sani̱ daranꞌanj na̱rugüiꞌ. Ni̱ nitaj a̱ ꞌngo̱ nuguanꞌ guixíj hui̱ ni ngüi̱ acuanꞌ, sani̱ gui̱niꞌi daranꞌ ni ngüi̱ xigui̱n sa̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ngaa ni̱ ga̱ cuidado ni é re̱ꞌ da̱j unun ni é re̱ꞌ ni nuguanꞌ nan. Daj si ga̱ꞌuiꞌ Yanꞌanj rian tsínj unun. Sani̱ ga̱ꞌne Yanꞌanj da gue̱ nicaj ni tsínj naꞌuej ruhua gu̱nun sa̱ꞌ. Daj si ani ruhua ni sij sisi̱ niꞌi sa̱ꞌ ni sij. Sani̱ sé daj huin mánj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ngaa ni̱ guisíj nni Jesús nga̱ ni jnánj sij rian sij. Sani̱ nun ga̱ꞌue ga̱huin ni̱chrunꞌ aninꞌ nni síꞌ rian manꞌan sij. Daj si ma̱n ni̱nꞌ ruhua ni ngüi̱ rian Jesús. ");
INSERT INTO trq_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ngaa ni̱ nataꞌ ꞌngo̱ tsínj daj rian Jesús: ―Nní re̱ꞌ nga̱ ni jnánj re̱ꞌ anaꞌuij niquinꞌ ne̱ꞌ chrej xe̱ꞌ huin ruhua ni sij gui̱niꞌi ni sij manꞌán re̱ꞌ. ―Daj gataj tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ngaa ni̱ gataj Jesús: ―Nnī nga̱ ni jnān huin ni ngüi̱ unun si-nu̱guanꞌ Yanꞌanj. Ni̱ ꞌyaj ni sij si ataj nuguanꞌ daj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Hué dan ni̱ ꞌngo̱ güi daj, ni̱ gahui Jesús chruhua ꞌngo̱ rio̱ achéj rian nnee. Ni̱ gatúj ni tsínj nicoꞌ sij chruhua rio̱ nej. Ni̱ gataj Jesús gunun ni síꞌ: ―Ga̱nꞌanj néꞌ anéj chrej duꞌua laguna xa̱chij nan. ―Daj gataj Jesús. Ngaa ni̱ ganꞌanj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ni̱ ngaa huaj ni sij, ni̱ gatoj Jesús. Ni̱ gahui ꞌngo̱ nane̱ nucuaj xxi rian laguna daj. Ni̱ gara nnee chruhua rio̱. Ni̱ ruhua gui̱nij rio̱ daj chruhua nnee. ");
INSERT INTO trq_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ngaa ni̱ ganꞌanj ni sij na̱chica ni sij Jesús. Ni̱ gataj ni sij: ―Maestro, Maestro, ruhua ga̱huiꞌ néꞌ. ―Daj gataj ni sij gunun Jesús. Ngaa ni̱ nachica ni sij Jesús. Ni̱ gaꞌmi huee sij rian nane̱ nga̱ rian nnee. Ngaa ni̱ ganiquinꞌ daranꞌanj. Ni̱ gahuin dinꞌinj rian laguna daj, guiꞌyaj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ngaa ni̱ gataj Jesús gunun ni sij: ―Ni̱ u̱n sin huin ni̱ naꞌue gu̱xuman ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ manꞌānj únj. ―Daj gataj Jesús. Ngaa ni guxuꞌuiꞌ ni sij. Ni̱ ganꞌanj ruhua ni sij. Ni̱ gataj ni sij gunun ni dugüiꞌ ni sij: ―Ni̱ u̱n tsínj huin tsínj nan únj. Ni̱ ngaa aꞌninꞌ síꞌ sun, ni̱ daꞌ nane̱ nga̱ nnee dagahuin si-nu̱guanꞌ sij. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ngaa ni̱ guisíj ni sij doꞌój ni tsínj gadareno. Ni̱ ngaj yoꞌój daj anéj chrej duꞌua laguna xa̱chij daj rian estado Galilea. ");
INSERT INTO trq_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ni̱ nanij Jesús rio̱ daj. Ngaa ni̱ gaꞌna̱ꞌ ꞌngo̱ tsínj ꞌna̱ꞌ xumanꞌ daj rian Jesús. Ni̱ guisíj gaꞌi̱ yoꞌ nu̱n nane̱ xi̱ꞌi niman sij. Ni̱ nitaj si nu̱n sij atsij. Ni̱ nitaj si nne sij hueꞌ mánj. Sani̱ nne sij chruhua ni yuꞌuj rian gachinꞌ ni sij níman. ");
INSERT INTO trq_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ni̱ ngaa guiniꞌi sij Jesús, ni̱ gaguáj nucuaj sij. Ni̱ ganiquinꞌ ráj da̱coj sij rian Jesús. Ni̱ gataj sij gaguáj sij: ―Nitaj si huaj si di̱guíj re̱ꞌ ngāj huín re̱ꞌ Jesús daꞌníj Yanꞌanj achij nne xataꞌ mánj. Aꞌmi acōj rián re̱ꞌ sisi̱ si̱ guiꞌyáj re̱ꞌ castigo manꞌānj mánj. ―Daj gataj sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","(Ni̱ daꞌngaꞌ daj gataj sij daj si hua gaꞌninꞌ Jesús sun rian nane̱ xi̱ꞌi sisi̱ ga̱hui nane̱ xi̱ꞌi daj niman sij. Ni̱ hua guisíj gaꞌi̱ yoꞌ sisi̱ guidaꞌa nane̱ xi̱ꞌi tsínj daj. Ni̱ anumi cadena raꞌa sij nga̱ dacój sij, guiꞌyaj ni ngüi̱. Sani̱ xiꞌninꞌ cadena, guiꞌyaj sij. Ni̱ nicaj nane̱ xi̱ꞌi sij ganꞌanj-ánꞌ sij quij quiꞌyanj na̱co nej.) ");
INSERT INTO trq_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ngaa ni̱ nachínj snanꞌanj Jesús síꞌ. Ni̱ gataj sij: ―Da̱j gu̱ꞌnaj re̱ꞌ únj. ―Gataj Jesús. Ni̱ gataj manꞌan síꞌ: ―Xiꞌninꞌ nico gu̱ꞌnā aj. ―Daj gataj síꞌ xiꞌí si gaꞌi̱ nico nane̱ xi̱ꞌi gatúj chruhua niman síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ni̱ gaꞌmi yaco ni nane̱ xi̱ꞌi daj rian Jesús sisi̱ si̱ gaꞌnij síꞌ ga̱nꞌanj ni nane̱ xi̱ꞌi daj rian yanꞌa̱n mánj. ");
INSERT INTO trq_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ni̱ ni̱chrunꞌ xiꞌí quij mán ꞌngo̱ xiꞌninꞌ xxi xacáj xa xuj. Ni̱ gaꞌmi yaco ni nane̱ xi̱ꞌi rian Jesús sisi̱ ga̱ꞌnij síꞌ ga̱nꞌanj ga̱tu ni sij chruhua niman ni xacáj daj. Ngaa ni̱ gaꞌuej ruhua Jesús sisi̱ daꞌngaꞌ daj gui̱ꞌyaj ni nane̱ xi̱ꞌi daj. ");
INSERT INTO trq_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ngaa ni̱ gahui ni nane̱ xi̱ꞌi chruhua niman tsínj daj. Ni̱ ganꞌanj ga̱tu ni sij chruhua niman ni xacáj da aj. Ngaa ni̱ ꞌngo̱ ganꞌanj gue̱ xiꞌninꞌ xacáj daj guinij xúꞌ chra̱ ꞌngo̱ huej. Ni̱ guinij ni xuj chruhua laguna gahuiꞌ ni xúꞌ chruhua nnee aj. ");
INSERT INTO trq_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ni̱ ngaa guiniꞌi ni tsínj dugumi ni xacáj si guiranꞌ xúꞌ, ni̱ gunánj ni sij na̱nꞌ ni sij xánj ni sij nga̱ riqui quij. Ni̱ nataꞌ ni sij da̱j gahuin guiranꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Hué dan ni̱ gahui ni ngüi̱ daj ganꞌanj gui̱niꞌyaj ni sij u̱n sin huin guiranꞌ ni tsínj daj. Ni̱ ngaa guisíj ni sij rian nne Jesús, ni̱ guiniꞌi ni sij tsínj guinu̱n nane̱ xi̱ꞌi niman daj. Ni̱ yya̱j ni̱ nne sij xiꞌí Jesús nu̱n sij si-ganꞌ sij, hua sa̱ꞌ gaꞌue nani ruhua sij. Ni̱ guxuꞌuiꞌ ni ngüi̱ guisíj daj. ");
INSERT INTO trq_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ni̱ ni tsínj guiniꞌi da̱j gahuin, ni̱ ganani ni sij da̱j gahuin ngaa ganahuin sa̱ꞌ tsínj guinu̱n ni nane̱ xi̱ꞌi, guiꞌyaj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Hué dan ni̱ gachínj jniꞌyaj daranꞌ ni tsínj gadareno rian Jesús sisi̱ ga̱hui síꞌ ga̱nꞌanj síꞌ xánj ni sij. Daj si guxuꞌuiꞌ ni sij. Ngaa ni̱ gahui Jesús chruhua rio̱ achéj rian nnee. Ni̱ ganꞌanj sij anéj chrej duꞌua laguna daj. ");
INSERT INTO trq_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ngaa ni̱ gaꞌmi yaco tsínj gunu̱n ni nane̱ xi̱ꞌi rian Jesús sisi̱ ga̱ꞌuej síꞌ gui̱nicaj dugüiꞌ síꞌ nga̱ sij ga̱nꞌanj nu̱ngüej sij. Sani̱ gaꞌníj Jesús na̱nꞌ síꞌ ducuá síꞌ. Ni̱ gataj sij: ");
INSERT INTO trq_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Güi̱j na̱nꞌ ducuá re̱ꞌ, ngaa ni̱ na̱taꞌ re̱ꞌ gu̱nun ni dugüíꞌ re̱ꞌ daranꞌ si sa̱ꞌ guiꞌyaj Yanꞌanj xiꞌí manꞌán re̱ꞌ. ―Daj gataj Jesús gunun sij. Ngaa ni̱ ganꞌanj sij. Ni̱ nataꞌ sij rian daranꞌ ni ngüi̱ ma̱n xumanꞌ daj xiꞌí si sa̱ꞌ guiꞌyaj Jesús rian sij. ");
INSERT INTO trq_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ni̱ ngaa nanica̱j Jesús, ni̱ gahuin nia̱ꞌ ruhua ni ngüi̱ nahuin raꞌa ni sij manꞌan Jesús. Daj si anaꞌuij daranꞌ ni sij síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ngaa ni̱ gaꞌna̱ꞌ ꞌngo̱ tsínj huin achij chruhua nuhui rian nne Jesús, gu̱ꞌnaj síꞌ Jairo. Ni̱ ganiquinꞌ ráj da̱coj síꞌ xiꞌí Jesús. Ni̱ gaꞌmi yaco síꞌ rian Jesús sisi̱ ga̱nꞌanj sij ducuá síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Daj si hua urin daꞌni̱ xa̱na síꞌ. Ni̱ síj ꞌngo̱ si xu̱huij yoꞌ huaj únꞌ. Ni̱ do̱j ni̱ ga̱huiꞌ únꞌ. Ni̱ ngaa huaj Jesús, ni̱ ducu guruꞌman ni ngüi̱ xiꞌníj síꞌ ganica̱j ni sij rian huaj síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ni̱ scanij ni ngüi̱ daj, ni̱ niquinꞌ ꞌngo̱ yunꞌunj xa̱na aꞌnanꞌ si guisíj xu̱huij yoꞌ uráj tun únꞌ. Ni̱ gutinꞌ únꞌ daranꞌ si nicaj únꞌ nga̱ ni tsínj go̱noꞌo. Sani̱ nun ga̱ꞌue ga̱nahuin únꞌ, guiꞌyaj a̱ ꞌngo̱ ni sij. ");
INSERT INTO trq_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ngaa ni̱ ganꞌanj ni̱chi únꞌ scanij ni ngüi̱ guisíj únꞌ rucú Jesús. Ni̱ ganun únꞌ chra̱ raꞌa únꞌ duꞌua si-ganꞌ síꞌ. Ngaa ni̱ ꞌngo̱ hora, ni̱ ganiquinꞌ si uráj tun. ");
INSERT INTO trq_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ngaa ni̱ gataj Jesús: ―Da̱j hua á re̱ꞌ ganun raꞌa si-ganꞌānj únj. ―Daj gataj Jesús. Sani̱ ni̱ a̱ ꞌngo̱ ni sij nun ganun si-ganꞌ Jesús, ataj ni sij. Ngaa ni̱ gataj Pedro nga̱ ni tsínj ma̱n nga̱ sij: ―Ma̱n ni̱nꞌ ruhua ni ngüi̱ rián re̱ꞌ. Ni̱ chráj raꞌa daranꞌ ni sij manꞌán re̱ꞌ. Ngaa ni̱ u̱n sin huin ni̱ nachínj snanꞌanj re̱ꞌ: “Da̱j hua ngüi̱ ganun raꞌa manꞌān únj.” Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Sani̱ gataj Jesús: ―Ganun yya ꞌngo̱ ngüi̱ manꞌānj. Daj si niꞌīnj sisi̱ nahuin ngüi̱, guiꞌyā. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ni̱ ngaa guiniꞌi yunꞌunj xa̱na daj sisi̱ naꞌue gui̱xij hui̱ únꞌ, ni̱ nagunánj únꞌ gaꞌna̱ꞌ únꞌ ganiquinꞌ ráj da̱coj únꞌ rian Jesús. Ni̱ nataꞌ yya únꞌ gunun sij rian daranꞌ ni ngüi̱ u̱n xi̱ꞌi huin ganun raꞌa únꞌ si-ganꞌ Jesús. Ni̱ nataꞌ únꞌ sisi̱ ꞌngo̱ hora, ni̱ nahuin únꞌ, guiꞌyaj sij. ");
INSERT INTO trq_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ngaa ni̱ gataj Jesús gunun únꞌ: ―Xicaꞌuīj, ganahuín re̱ꞌ, guiꞌyaj si guxuman ruhuá re̱ꞌ niꞌyáj re̱ꞌ manꞌānj. Ni̱ dínj ga̱huin nimán re̱ꞌ ga̱nꞌanj re̱ꞌ aj. ―Daj gataj Jesús gunun únꞌ. ");
INSERT INTO trq_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ni̱ hua gue̱ aꞌmi Jesús, ni̱ gaꞌna̱ꞌ ꞌngo̱ tsínj ꞌyaj sun rian tsínj nicaj sun nuhui daj. Ni̱ gataj síꞌ gunun sij: ―Guisíj gahuiꞌ daꞌni̱ xa̱na re̱ꞌ. Ngaa ni̱ si̱ garasu̱n re̱ꞌ rian Maestro mánj. ―Daj gataj síꞌ gunun Jairo. ");
INSERT INTO trq_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Sani̱ gunun Jesús si gataj síꞌ. Ni̱ gataj sij: ―Si̱ guxuꞌuíꞌ re̱ꞌ mánj. Maan si gu̱xuman yya ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ manꞌānj. Ngaa ni̱ ga̱nahuin sa̱ꞌ daꞌníj re̱ꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ni̱ ngaa gatúj Jesús chruhua hueꞌ, ni̱ nun ga̱ꞌuej sij sisi̱ ga̱tu ni ngüi̱ nga̱ sij. Ni̱ maan Pedro nga̱ Jacobo nej, Juan nej, nu̱ngüej nica̱ Jairo nej, gaꞌuej Jesús ga̱tu chruhua hueꞌ nga̱ sij. ");
INSERT INTO trq_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ni̱ ducu aco ni ngüi̱. Ni̱ aguáj ni sij nej. Sani̱ gataj Jesús: ―Si̱ gaco ni é re̱ꞌ mánj. Sé si gahuiꞌ tsinꞌ xa̱na mánj. Sani̱ si ato nánj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Sani̱ gaꞌngaꞌ na̱co ni sij guiniꞌi ni sij manꞌan Jesús. Daj si guiniꞌi ni sij sisi̱ hua gahuiꞌ yya tsinꞌ daj. ");
INSERT INTO trq_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sani̱ guidaꞌa Jesús raꞌa tsinꞌ daj. Ni̱ gaꞌmi nucuaj sij. Ni̱ gataj sij: ―Tsinꞌ xa̱na, ataj snanꞌān gu̱nun so̱ꞌ sisi̱ na̱chica so̱ꞌ. ―Daj gataj Jesús gunun tsinꞌ daj. ");
INSERT INTO trq_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ngaa ni̱ ganáꞌnij tsinꞌ xa̱na daj. Ni̱ hué hora ꞌngo̱ nachica unj. Ni̱ gaꞌninꞌ Jesús sun sisi̱ ga̱ꞌuiꞌ ni ngüi̱ xa̱ tsinꞌ daj. ");
INSERT INTO trq_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ni̱ ducu ganꞌanj ruhua nu̱ngüej nica̱ Jairo. Sani̱ gaꞌninꞌ Jesús sun sisi̱ si̱ nataꞌ nu̱ngüej sij nuguanꞌ daj rian ni̱ a̱ ꞌngo̱ ngüi̱ mánj. ");
INSERT INTO trq_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Hué dan ni̱ gaquínj Jesús sisi̱ na̱huin yuꞌ ni xu̱huij ni tsínj nicoꞌ sij rian sij. Ni̱ gaꞌuiꞌ sij sun rian ni síꞌ sisi̱ gui̱nicaj ni síꞌ sun rian ni nane̱ xi̱ꞌi. Ni̱ hué daj gaꞌuiꞌ sij fuerza sisi̱ ga̱nahuin ni ngüi̱ aꞌnanꞌ, gui̱ꞌyaj ni síꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ni̱ gaꞌníj Jesús sisi̱ ga̱nꞌanj ga̱ꞌmi ni síꞌ nuguanꞌ sa̱ꞌ xiꞌí si nicaj sun Yanꞌanj rian ni ngüi̱. Ni̱ gataj Jesús sisi̱ ga̱nahuin ni ngüi̱ aꞌnanꞌ, gui̱ꞌyaj ni sij nej. ");
INSERT INTO trq_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ni̱ gataj Jesús: ―Ga̱yun ni é re̱ꞌ ga̱nꞌanj ni é re̱ꞌ. Ni̱ si̱ gaꞌue gui̱nicaj ni é re̱ꞌ rutsi̱ nej, xinánj nej, chrachrúnj nej, sanꞌanj nej, ganꞌanj ni é re̱ꞌ mánj. Ni̱ si̱ gaꞌue gui̱nicaj ni é re̱ꞌ atsij na̱duna ni é re̱ꞌ ga̱nꞌanj ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ni̱ ngaa ga̱tu ni é re̱ꞌ chruhua ꞌngo̱ hueꞌ, ngaa ni̱ gu̱naj ni é re̱ꞌ hueꞌ daj da síj ga̱hui ni é re̱ꞌ ga̱nꞌanj ni é re̱ꞌ xumanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ni̱ sisi̱ hua ꞌngo̱ yuꞌuj naꞌue ni sij na̱huin raꞌa ni sij a ni é re̱ꞌ, ngaa ni̱ na̱gunanꞌ a ni é re̱ꞌ yoꞌój chru̱ dacój ni é re̱ꞌ ngaa ga̱hui ni é re̱ꞌ yuꞌuj daj. Ni̱ hué-éꞌ huin ꞌngo̱ ducuánj di̱gyán ni é re̱ꞌ rian ni sij sisi̱ nun gui̱ꞌyaj sa̱ꞌ ni sij. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Hué dan ni̱ gahui ni tsínj nicoꞌ Jesús ganꞌanj ni sij daranꞌ ni xumanꞌ. Ni̱ nataꞌ ni sij nuguanꞌ sa̱ꞌ. Ni̱ ni̱nꞌ ga̱chraꞌ ganahuin ni ngüi̱ aꞌnanꞌ, guiꞌyaj ni sij nej. ");
INSERT INTO trq_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ni̱ gunun rey Herodes daranꞌ si guiꞌyaj Jesús. Ni̱ nun na̱riꞌ ruhua sij si gui̱ꞌyaj sij. Daj si gataj go̱ꞌngo ni ngüi̱ sisi̱ ganáꞌnij Juan scanij ni níman. ");
INSERT INTO trq_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ni̱ gataj ango ni sij sisi̱ hué Jesús huin tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj gu̱ꞌnaj Elías. Ni̱ gataj ango daꞌaj ni sij sisi̱ ganáꞌnij ꞌngo̱ tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj gane síꞌ asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ni̱ gataj rey Herodes: ―Gaꞌninꞌ ni sij chra̱ Juan, guiꞌyā. Ngaa ni̱ u̱n tsínj huin tsínj da únj. Daj si unūnj gaꞌi̱ nuguanꞌ xiꞌí sij. ―Daj gataj Herodes. Ni̱ huin ruhua Herodes gui̱niꞌi síꞌ manꞌan Jesús. ");
INSERT INTO trq_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ni̱ ngaa nanica̱j ni tsínj nicoꞌ Jesús, ni̱ gataj ni sij daranꞌ si guiꞌyaj ni sij rian Jesús. Hué dan ni̱ nicaj Jesús ni sij ganꞌanj síꞌ ꞌngo̱ quij quiꞌyanj na̱co ni̱chrunꞌ xumanꞌ Betsaida. ");
INSERT INTO trq_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ni̱ ngaa guiniꞌi ni ngüi̱, ni̱ guinicoꞌ ni sij manꞌan síꞌ. Ni̱ gaꞌmi sa̱ꞌ síꞌ nga̱ ni sij. Ni̱ gaꞌmi síꞌ rian ni sij sisi̱ da̱j nicaj sun Yanꞌanj rian ni sij. Ni̱ ganahuin ni ngüi̱ aꞌnanꞌ, guiꞌyaj síꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ni̱ ngaa ruhua guini̱, ni̱ gaꞌna̱ꞌ ni xu̱huij ni tsínj nicoꞌ Jesús. Ni̱ gataj ni sij: ―Ga̱naꞌnij re̱ꞌ ni ngüi̱ ga̱nꞌanj ni sij ni xumanꞌ nga̱ ni rancho ngaj ni̱chrunꞌ sisi̱ na̱riꞌ ni sij rian ga̱ne ni sij nga̱ si xa̱ ni sij. Daj si rian mán néꞌ nitaj ni ngüi̱ mán mánj. ―Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ngaa ni̱ gataj Jesús: ―Ga̱ꞌuiꞌ manꞌan án re̱ꞌ si xa̱ ni sij nánj. ―Daj gataj Jesús. Sani̱ gataj ni sij: ―Urin si nicaj únj huin u̱nꞌunꞌ chrachrúnj nga̱ hui̱j gue̱ xucuaj. Sani̱ nun niꞌi únj sisi̱ huin ruhuá re̱ꞌ ga̱nꞌanj gui̱ran únj si xa̱ daranꞌ ni ngüi̱ nan. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ni̱ síj ꞌngo̱ si u̱nꞌunꞌ mil tsínj mán yuꞌuj daj. Ngaa ni̱ gataj Jesús gunun ni tsínj nicoꞌ sij: ―Gui̱ꞌyaj á re̱ꞌ si ga̱ne ni ngüi̱ rian yoꞌój. Ni̱ na̱huin chreꞌ da hui̱j xia chiꞌ da hui̱j xia chiꞌ ngüi̱ ga̱ne go̱ꞌngo yuꞌuj, gui̱ꞌyaj á re̱ꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ni̱ daꞌngaꞌ daj guiꞌyaj ni sij. Ni̱ ganꞌanj ga̱ne daranꞌ ni ngüi̱, guiꞌyaj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ngaa ni̱ guidaꞌa Jesús u̱nꞌunꞌ chrachrúnj nga̱ hui̱j xucuaj daj. Ni̱ niꞌyaj sij xataꞌ. Ni̱ nagaꞌuiꞌ sij si guruhua Yanꞌanj. Ngaa ni̱ guraꞌ daꞌaj sij ni chrachrúnj gaꞌuiꞌ sij raꞌa ni tsínj nicoꞌ sij sisi̱ na̱gaꞌuiꞌ ni síꞌ raꞌa ni ngüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ni̱ xa daranꞌ ni ngüi̱. Ni̱ gara ran riqui ni sij. Ngaa ni̱ ganacaj ni sij daso gunaj. Ni̱ nara ni sij xu̱huij xuguti̱ nga̱ ni daso daj. ");
INSERT INTO trq_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ni̱ ꞌngo̱ güi ngaa achínj jniꞌyaj ni̱ni urin Jesús rian Yanꞌanj, ni̱ ma̱n ni tsínj nicoꞌ sij nga̱ manꞌan sij. Ngaa ni̱ nachínj snanꞌanj Jesús ni síꞌ. Ni̱ gataj sij: ―Ni̱ u̱n tsínj huīnj ataj ni ngüi̱, ruhua á re̱ꞌ únj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ngaa ni̱ gataj ni síꞌ: ―Ataj daꞌaj ni ngüi̱ sisi̱ hué re̱ꞌ huin Juan, tsínj duguataꞌ nnee. Ni̱ ataj ango ni sij sisi̱ hué re̱ꞌ huin tsínj gu̱ꞌnaj Elías. Ni̱ ataj ángo ni sij sisi̱ hué re̱ꞌ huin ꞌngo̱ tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. Ni̱ ganáꞌnij tsínj daj nahuin síꞌ manꞌán re̱ꞌ aj. ―Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ngaa ni̱ gataj Jesús: ―Ni̱ u̱n tsínj huīnj, ruhua manꞌan án re̱ꞌ únj. ―Daj gataj Jesús. Ngaa ni̱ gataj Pedro: ―Hué re̱ꞌ huin Cristo, tsínj ꞌna̱ꞌ rian Yanꞌanj anj. ―Daj gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sani̱ gaꞌninꞌ Jesús nico sun rian ni sij sisi̱ si̱ nataꞌ ni sij nuguanꞌ nan rian ni̱ a̱ ꞌngo̱ ni ngüi̱ mánj. ");
INSERT INTO trq_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ni̱ gataj síꞌ: ―Hua nia̱n sisi̱ gui̱ranꞌānj nico sayun, huīnj daꞌníj ni ngüi̱. Ni̱ da̱nicaj ni tsínj huin achij nej, ni chrej huin rian nej, ni tsínj digyán ley manꞌānj. Ni̱ da̱gahuiꞌ ni sij manꞌānj. Sani̱ xiráj hua̱ꞌnij güi, ni̱ ga̱naꞌnī. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ngaa ni̱ gataj Jesús gunun daranꞌ ni sij: ―Sisi̱ hua ꞌngo̱ tsínj huin ruhua nicoꞌ yūnj, ngaa ni̱ du̱naj sij si-chrej manꞌan sij. Ngaa síj ni̱ yaꞌyoj ga̱ta sij rugutsi̱ gui̱nicoꞌ sij yūnj anj. ");
INSERT INTO trq_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ni̱ tsínj naꞌuej ruhua ga̱huiꞌ sij ngāj, ni̱ ga̱ niꞌya sij. Sani̱ tsínj ga̱ꞌue ga̱huiꞌ xiꞌí manꞌānj, ni̱ ga̱ne ni̱ganj sij nga̱ Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ni̱ sisi̱ gui̱ꞌyaj gana ꞌngo̱ tsínj daj daranꞌ si ma̱n chruhua xungüi̱ ga̱huin siꞌyaj sij, ngaa ni̱ u̱n sin huin si huin-ínꞌ sisi̱ ga̱ niꞌya manꞌan sij únj. ");
INSERT INTO trq_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ni̱ sisi̱ hua ꞌngo̱ tsínj na̱ꞌaj niꞌyaj yūnj nga̱ si-nu̱guanꞌānj, ngaa ni̱ ga̱huin na̱ꞌā nga̱ sij ngaa ga̱ꞌnaꞌ yūnj nga̱ ni ángel sa̱ꞌ chruhua xungüi̱ nan. Ni̱ ga̱huin ꞌueé nu̱ngüej chrē. Ni̱ huīnj daꞌníj ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ni̱ xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ nitaj si ga̱huiꞌ daꞌaj ni ngüi̱ mán yuꞌuj nan daꞌ gui̱niꞌi ni sij ga̱ꞌnaꞌ gui̱nicaj sun Yanꞌanj anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ni̱ ngaa guisíj ꞌngo̱ si tu̱nj güi si gaꞌmi Jesús ni nuguanꞌ nan, ni̱ nicaj sij Pedro nga̱ Juan nej, Jacobo nej. Ni̱ gahui sij chra̱ ꞌngo̱ quij ga̱chinj jniꞌyaj sij rian Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ni̱ ngaa achínj jniꞌyaj sij, ni̱ naduna rian sij. Ni̱ nahuin gatsi̱ ni̱nꞌ si-ganꞌ sij. Ni̱ nahuin aca̱ si-ganꞌ sij nej. Ngaa ni̱ gurugüiꞌ hui̱j tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ni̱ gaꞌmi nu̱ngüej tsínj daj nga̱ sij huin nu̱ngüej síꞌ Moisés nga̱ Elías. ");
INSERT INTO trq_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ni̱ ꞌueé ni̱nꞌ ruhua gurugüiꞌ nu̱ngüej síꞌ. Ni̱ gaꞌmi nu̱ngüej síꞌ nga̱ Jesús xiꞌí si ga̱huiꞌ sij xumanꞌ Jerusalén ga̱hui sij chruhua xungüi̱ nan. ");
INSERT INTO trq_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ni̱ ꞌna̱ꞌ nnej rian ni du̱güiꞌ Pedro. Sani̱ nun ga̱toj ni sij. Ni̱ guiniꞌi ni sij sisi̱ xigui̱n si-ganꞌ Jesús. Ni̱ hué daj guiniꞌi ni sij nu̱ngüej tsínj niquinꞌ nga̱ Jesús nej. ");
INSERT INTO trq_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ni̱ ngaa gaxi̱ꞌi gahui anéj nu̱ngüej tsínj daj rian Jesús, ni̱ gataj Pedro gunun Jesús: ―Sa̱ꞌ mán néꞌ yuꞌuj nan Maestro. Ngaa ni̱ gui̱ꞌyaj únj hua̱ꞌnij hueꞌ recoj le. Ni̱ ꞌngo̱j manꞌán re̱ꞌ. Ni̱ angoj Moisés. Ni̱ ángoj Elías. ―Daj gataj Pedro. Sani̱ nun niꞌi sij si ataj sij mánj. ");
INSERT INTO trq_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ni̱ ngaa aꞌmi Pedro, ni̱ nasíj ꞌngo̱ nga guiran-ánꞌ rian ni sij. Ni̱ guxuꞌuiꞌ ni sij si ꞌngo̱ nasíj nga daj rian ni sij. ");
INSERT INTO trq_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ni̱ scanij nga daj gunun ni sij ꞌngo̱ nane̱ gataj-áꞌ: ―Tsínj nan huin daꞌnī ꞌi̱ ruhuāj. Gu̱nun a ni é re̱ꞌ si ataj síꞌ. ―Daj gataj Yanꞌanj gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ni̱ ngaa ganahuij gaꞌmi Yanꞌanj, ni̱ gunáj urin Jesús nga̱ ni tsínj nicoꞌ síꞌ. Ni̱ dínj gane duꞌua ni sij ni güi daj nun na̱taꞌ ni sij si guiniꞌi ni sij gunun ni̱ a̱ ꞌngo̱ ni ngüi̱ mánj. ");
INSERT INTO trq_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ni̱ ango güi ngaa nanij ni sij chra̱ quij, ni̱ mán ni̱nꞌ ruhua ni ngüi̱ ꞌna̱ꞌ na̱riꞌ dugüiꞌ nga̱ Jesús. ");
INSERT INTO trq_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ni̱ niquinꞌ ꞌngo̱ tsínj daj scanij ni ngüi̱. Ni̱ gaguáj síꞌ. Ni̱ gataj síꞌ: ―Maestro, achínj jniꞌyā rián re̱ꞌ sisi̱ gui̱niꞌyaj re̱ꞌ daꞌnī. Daj si urin sij nicā. ");
INSERT INTO trq_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ni̱ daꞌa ꞌngo̱ nane̱ xi̱ꞌi manꞌan sij. Ni̱ hora aguáj sij. Ni̱ guidaꞌa xiꞌi̱ yaquij, ꞌyaj nane̱ xi̱ꞌi daj da ahui yatanꞌ duꞌua sij. Ni̱ naꞌuej ruhua nane̱ xi̱ꞌi daj ga̱huin ane rian daꞌnī. ");
INSERT INTO trq_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ni̱ gaꞌmi yacōj rian ni tsínj nicóꞌ re̱ꞌ sisi̱ gui̱ri ni sij nane̱ xi̱ꞌi niman daꞌnī. Sani̱ nun gu̱nucuaj ni sij gui̱ri ni sij mánj. ―Daj gataj tsínj daj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ngaa ni̱ gataj Jesús: ―Ni ngüi̱ ma̱n yya̱j, ni̱ naꞌue gu̱xuman ruhua ni é re̱ꞌ ni̱ꞌyaj ni é re̱ꞌ manꞌānj. Ni̱ xiꞌi̱ niman án re̱ꞌ. Ni̱ naꞌue gu̱nucuā ga̱ne nigān nga̱ ni é re̱ꞌ mánj. Ni̱ naꞌue gu̱nucuā si-chrej ni é re̱ꞌ ni̱ganj mánj. Ni̱caj re̱ꞌ daꞌníj re̱ꞌ ga̱ꞌnaꞌ re̱ꞌ riānj anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ni̱ ngaa gahuin ni̱chrunꞌ tsinꞌ daj, ni̱ ganatúj sij, guiꞌyaj nane̱ xi̱ꞌi daj. Ni̱ guidaꞌa xiꞌi̱ yaquij, guiꞌyaj nane̱ xi̱ꞌi nej. Sani̱ gaꞌmi huee Jesús rian nane̱ xi̱ꞌi daj. Ni̱ ganahuin tsinꞌ, guiꞌyaj Jesús. Ni̱ nagaꞌuiꞌ Jesús tsinꞌ daj rian chrej sij. ");
INSERT INTO trq_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ni̱ gahuin yanꞌanj ruhua daranꞌ ni ngüi̱ xiꞌí da̱j hua nucuaj Yanꞌanj anj. Ni̱ ngaa hua gue̱ gahuin yanꞌanj ruhua ni sij, ni̱ gataj Jesús gunun ni tsínj nicoꞌ sij: ");
INSERT INTO trq_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Gu̱nun sa̱ꞌ á re̱ꞌ ni nuguanꞌ ga̱ꞌmī nan. Huēj huin daꞌníj ni ngüi̱. Ni̱ na̱gaꞌuiꞌ ni sij manꞌānj raꞌa ni tsínj. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Sani̱ naꞌue ga̱ra daꞌngaꞌ ruhua ni sij si gataj Jesús. Daj si naꞌue gu̱nun sa̱ꞌ ni sij, guiꞌyaj nuguanꞌ daj. Ni̱ xuꞌuiꞌ ni sij ga̱chinj snanꞌanj ni sij Jesús xiꞌí nuguanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ngaa ni̱ gaxi̱ꞌi ni tsínj nicoꞌ Jesús gaꞌmi ni sij u̱n tsínj huin achij scanij ni sij. ");
INSERT INTO trq_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ni̱ niꞌi Jesús da̱j ani ruhua niman ni sij. Ngaa ni̱ guidaꞌa Jesús raꞌa ꞌngo̱ tsinꞌ. Ni̱ gani sij tsinꞌ daj xiꞌníj sij. ");
INSERT INTO trq_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ni̱ gataj sij gunun ni síꞌ: ―Ni̱ u̱n tsínj na̱huin raꞌa tsinꞌ nan xiꞌí si nicaj dugüiꞌ sij ngāj, ni̱ na̱huin raꞌa sij manꞌānj nej. Ni̱ tsínj na̱huin raꞌa manꞌānj, ni̱ na̱huin raꞌa sij Yanꞌanj. Daj si Yanꞌanj huin si gaꞌníj gaꞌnāj. Ni̱ tsínj nicoꞌ da ru̱cu scanij ni é re̱ꞌ, ni̱ hué tsínj daj huin tsínj huin achij. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Hué dan ni̱ gataj Juan gunun Jesús: ―Maestro, guiniꞌi ni únj ꞌngo̱ tsínj aꞌmi si-xugüí re̱ꞌ. Ni̱ hué da guiri sij nane̱ xi̱ꞌi chruhua niman ni ngüi̱. Sani̱ nitaj si chéj sij nga̱ ni únj. Ngaa ni̱ xiꞌí daj nun ga̱ꞌuej únj sisi̱ gui̱ꞌyaj sij daj. ―Daj gataj Juan. ");
INSERT INTO trq_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ngaa ni̱ gataj Jesús: ―Ga̱ꞌninꞌ ruhuá re̱ꞌ sisi̱ hué daj gui̱ꞌyaj tsínj daj. Daj si tsínj nitaj si ununꞌ ngo̱ꞌ, ni̱ chracuij sij yu̱nꞌ anj. ―Daj gataj Jesús gunun Juan. ");
INSERT INTO trq_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ni̱ ngaa achin do̱j güi gui̱nanꞌ Jesús xataꞌ, ni̱ ꞌngo̱ gani ruhua sij ga̱nꞌanj sij xumanꞌ Jerusalén. ");
INSERT INTO trq_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ni̱ gaꞌníj sij go̱ꞌngo tsínj ga̱nꞌanj sini rian sij. Ni̱ ganꞌanj ni síꞌ xumanꞌ rian ma̱n ni tsínj samaritano sisi̱ gui̱ꞌyaj xugüi ni síꞌ rian gu̱na ni du̱güiꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sani̱ nun nahuin raꞌa ni tsínj samaritano Jesús. Daj si hua niꞌi ni síꞌ sisi̱ huaj Jesús xumanꞌ Jerusalén. ");
INSERT INTO trq_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ni̱ guiniꞌi hui̱j tsínj nicoꞌ Jesús si guiꞌyaj ni tsínj daj. Ni̱ gu̱ꞌnaj nu̱ngüej sij Jacobo nga̱ Juan. Ni̱ gataj nu̱ngüej sij gunun Jesús: ―Señor, huin ruhuá re̱ꞌ sisi̱ ga̱ꞌninꞌ nu̱ngüej únj yanꞌa̱n ga̱yu xataꞌ ga̱ca ni tsínj ma̱n nan da̱j rúnꞌ guiꞌyaj tsínj gu̱ꞌnaj Elías asi̱j ná níꞌ. ―Daj gataj nu̱ngüej sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Sani̱ nanica̱j Jesús chranꞌ síꞌ nu̱ngüej sij. Ni̱ gataj síꞌ: ―Nun niꞌi nu̱ngüej é re̱ꞌ da̱j hua niman nu̱ngüej é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Sé si ꞌnāj sisi̱ gue̱reꞌ niman ni ngüi̱ gui̱ꞌyā huīnj daꞌníj ni ngüi̱. Sani̱ ꞌnāj na̱cā ni sij. ―Daj gataj Jesús. Ngaa ni̱ ganꞌanj ni sij ango xumanꞌ. ");
INSERT INTO trq_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ni̱ ngaa huaj ni sij chrej, ni̱ gataj ꞌngo̱ tsínj daj gunun Jesús: ―Señor, huin ruhuāj gui̱nicōj manꞌán re̱ꞌ ni̱ a̱ ga̱nꞌanj re̱ꞌ aj. ―Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ngaa ni̱ gataj Jesús: ―Hua huej nu̱n xune aj. Ni̱ hua si-ga̱caꞌ xataj chéj xataꞌ nu̱n xúꞌ. Sani̱ nitaj ri̱an gu̱na daꞌníj ni ngüi̱ huīnj mánj. ―Daj gataj Jesús gunun tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ngaa ni̱ gataj Jesús gunun ango tsínj daj: ―Gui̱nicoꞌ re̱ꞌ manꞌānj. ―Daj gataj Jesús. ―Señor, du̱ná re̱ꞌ sisi̱ ga̱nꞌanj sinīj ga̱chīnj chrē aj. ―Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ngaa ni̱ gataj Jesús: ―Ga̱ꞌninꞌ ruhuá re̱ꞌ si ga̱chinꞌ ango ni sij níman. Daj si rúnꞌ huin níman huin ni sij. Sani̱ ga̱nꞌanj manꞌán re̱ꞌ ga̱ꞌmi re̱ꞌ nuguanꞌ sa̱ꞌ xiꞌí si nicaj sun Yanꞌanj rian néꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ngaa ni̱ gataj ango tsínj daj gunun Jesús: ―Señor, huin ruhuāj gui̱nicōj manꞌán re̱ꞌ, sani̱ du̱na siní re̱ꞌ sisi̱ ga̱nꞌanj ga̱tā gu̱nun ni dugüiꞌīj. ―Daj gataj sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Sani̱ gataj Jesús gunun sij: ―Nitaj si níꞌyanj tsínj daꞌa nne ngaa ni̱ꞌyaj sij rucú sij. Ni̱ daꞌngaꞌ daj naꞌue gui̱ꞌyaj sun sa̱ꞌ ꞌngo̱ tsínj rian nicaj sun Yanꞌanj ngaa ni̱ꞌyaj sij rucú sij. ―Daj gataj Jesús gunun tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Hué daj síj ni̱ nacui Señor yaꞌnij xia chiꞌ ranꞌ tsínj nicoꞌ sij. Ni̱ gaꞌníj sij hui̱j hui̱j ranꞌ ni síꞌ guita̱j dian sini ya̱n ga̱nꞌanj ni síꞌ go̱ꞌngo ni xumanꞌ daj nej. ");
INSERT INTO trq_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ni̱ gataj sij gunun ni tsínj daj: ―Rúnꞌ huin strigo huin ni ngüi̱ achin gu̱nun si-nu̱guanꞌ Yanꞌanj. Ni̱ rúnꞌ huin tsínj aꞌninꞌ strigo huin ni tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj. Nico ni̱nꞌ ruhua strigo ngaj achin ga̱ꞌninꞌ ni sij. Ngaa ni̱ ga̱chinj jniꞌyaj á re̱ꞌ rian Yanꞌanj sisi̱ ga̱ꞌnij manꞌan síꞌ ni tsínj gui̱ꞌyaj sun ga̱nꞌanj ga̱ꞌninꞌ ni sij si-strigo síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ni̱ aꞌnī ga̱nꞌanj ni é re̱ꞌ rúnꞌ ga̱nꞌanj ni xachij ꞌni̱j scanij ni stuj huee. ");
INSERT INTO trq_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ni̱ si̱ nicaj á re̱ꞌ nnánj nga̱ nnij nu̱n sanꞌanj nej, canj nej, ga̱nꞌanj án re̱ꞌ mánj. Ni̱ si̱ guiniquinꞌ a ni é re̱ꞌ ga̱ꞌmi a ni é re̱ꞌ nga̱ ni tsínj na̱riꞌ a ni é re̱ꞌ chrej nej mánj. ");
INSERT INTO trq_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","’Ni̱ ngaa ga̱tu a ni é re̱ꞌ ꞌngo̱ hueꞌ, ni̱ ga̱taj sini ya̱n ni é re̱ꞌ rian ni ngüi̱ nne chruhua hueꞌ daj: “Ga̱huin dinꞌinj ruhua ni é re̱ꞌ.” Daj ga̱taj ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ni̱ sisi̱ yuꞌuj daj nne ꞌngo̱ tsínj aꞌmi sa̱ꞌaj, ngaa ni̱ ga̱huin dinꞌinj ruhua sij da̱j huin ruhua ni é re̱ꞌ. Sani̱ sisi̱ nitaj ꞌngo̱ tsínj aꞌmi sa̱ꞌaj yuꞌuj daj, ngaa ni̱ na̱nicaj nuguanꞌ sa̱ꞌ gaꞌmi ni é re̱ꞌ rian án re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Gu̱nan án re̱ꞌ hueꞌ nne tsínj sa̱ꞌ daj. Ni̱ xa̱ á re̱ꞌ go̱ꞌo a ni é re̱ꞌ si ri̱qui ni ngüi̱ daj. Daj si ni tsínj ꞌyaj sun, ni̱ hua si-chrej ni sij si ga̱ duꞌue ni sij. Si̱ ganꞌanj án re̱ꞌ go̱ꞌngo ni hueꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ni̱ ngaa huaj gui̱sij a ni é re̱ꞌ ꞌngo̱ xumanꞌ rian ráj xina̱ ni ngüi̱ niꞌi ni sij a ni é re̱ꞌ, ni̱ xa̱ á re̱ꞌ si ri̱qui ni sij aj. ");
INSERT INTO trq_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Jna̱huin a ni é re̱ꞌ ni ngüi̱ aꞌnanꞌ si guima̱n ni sij yuꞌuj daj. Ni̱ ga̱taj á re̱ꞌ gu̱nun ni sij: “Hua gahuin ni̱chrunꞌ ga̱ꞌnaꞌ ni̱caj sun Yanꞌanj rian ni é re̱ꞌ.” Daj ga̱taj ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","’Sani̱ sisi̱ huaj gui̱sij a ni é re̱ꞌ ꞌngo̱ xumanꞌ, ni̱ nun ráj xina̱ ni ngüi̱ niꞌyaj ni sij a ni é re̱ꞌ, ngaa ni̱ ga̱hui a ni é re̱ꞌ chruhua cayu, ni̱ ga̱taj á re̱ꞌ gu̱nun ni ngüi̱ mán xumanꞌ daj: ");
INSERT INTO trq_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Nagunanꞌ ni únj yoꞌój yaj ma̱n xánj án re̱ꞌ guta dacój ni únj. Ni̱ daꞌngaꞌ daj ꞌyaj ni únj xiꞌí si naꞌue gu̱nun a ni é re̱ꞌ si-nu̱guanꞌ ni únj. Sani̱ gu̱nun sa̱ꞌ ni é re̱ꞌ sisi̱ hua gahuin ni̱chrunꞌ ga̱ꞌnaꞌ rian nicaj sun Yanꞌanj rian ni é re̱ꞌ.” Hué daj ga̱taj á re̱ꞌ gu̱nun ni ngüi̱ ma̱n xumanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ güi na̱guiꞌyaj yya Yanꞌanj si-ga̱quinꞌ ni ngüi̱, ngaa ni̱ huaj ga̱huin ni ngüi̱ xumanꞌ daj castigo si gui̱ranꞌ ni ngüi̱ xi̱ꞌi guimán xumanꞌ Sodoma asi̱j ná. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ngaa ni̱ gataj Jesús: ―Ducu niqui niman ni é re̱ꞌ ni ngüi̱ mán xumanꞌ Corazín nga̱ xumanꞌ Betsaida. Ni̱ nun guiꞌyā si sa̱ꞌ xumanꞌ Tiro nga̱ xumanꞌ Sidón rúnꞌ guiꞌyā xumanꞌ Corazín nga̱ xumanꞌ Betsaida. Sani̱ sisi̱ hua guiꞌyā si sa̱ꞌ daj, ni̱ hua nani ruhua ni ngüi̱ ma̱n Tiro nga̱ Sidón xiꞌí si-ga̱quinꞌ ni sij ná. Ni̱ hua gunun ni sij atsij nayaꞌ. Ni̱ hua gane ni sij rian yaj digyán ni sij sisi̱ hua yya nanica̱j ruhua ni sij xiꞌí si-ga̱quinꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Hué dan ni̱ güi na̱guiꞌyaj yya Yanꞌanj si-ga̱quinꞌ ni ngüi̱, ngaa ni̱ huaj gui̱ranꞌ ni é re̱ꞌ castigo si gui̱ranꞌ ni ngüi̱ xi̱ꞌi guimán xumanꞌ Tiro nga̱ xumanꞌ Sidón asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ni̱ atā gu̱nun a ni é re̱ꞌ huin a ni é re̱ꞌ ni ngüi̱ ma̱n xumanꞌ Capernaum sisi̱ nne̱ ni̱nꞌ ruhua ni é re̱ꞌ. Xiꞌí daj ani ruhua ni é re̱ꞌ sisi̱ hua ꞌueé ni̱nꞌ ruhua xánj án re̱ꞌ rúnꞌ hua xataꞌ hua xánj án re̱ꞌ, ruhua á re̱ꞌ. Sani̱ ga̱nꞌanj án re̱ꞌ rian ma̱n ni ngüi̱ gahuiꞌ, gui̱ꞌyā. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ngaa ni̱ gataj Jesús gunun ni tsínj nicoꞌ sij: ―Ni ngüi̱ unun si ataj á re̱ꞌ, ni̱ hué daj gu̱nun ni sij si-nu̱guanꞌānj nej. Sani̱ sisi̱ da̱nicaj ni ngüi̱ ni é re̱ꞌ, ni̱ hué daj da̱nicaj ni sij manꞌānj nej. Ni̱ ni ngüi̱ da̱nicaj manꞌānj, ni̱ hué daj da̱nicaj ni sij Yanꞌanj nej. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Hué dan ni̱ nanica̱j hua̱ꞌnij xia chiꞌ ni tsínj ganꞌanj daj. Ni̱ hua nia̱ꞌ ruhua ni sij. Ni̱ gataj ni sij gunun Jesús: ―Señor, ni̱ daꞌ ni nane̱ xi̱ꞌi dagahuin rian ni únj ngaa aꞌmi únj si-xugüi manꞌán re̱ꞌ. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ngaa ni̱ gataj Jesús: ―Da̱j rúnꞌ yoo̱ ahui duꞌui xataꞌ, ni̱ daꞌngaꞌ daj guiniꞌīnj ꞌna̱ꞌ guinij sichre Satanás xataꞌ aj. ");
INSERT INTO trq_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Hua riquīj si gahuin nucuaj á re̱ꞌ si gu̱run a ni é re̱ꞌ rian xucuáj nga̱ xiquin nej. Ni̱ si̱ guiꞌyaj xi̱ꞌi xúꞌ rian án re̱ꞌ mánj. Ni̱ ga̱ꞌue gui̱ꞌyaj gana ni é re̱ꞌ rian si-fuerza sichre Satanás. Ni̱ nitaj si gui̱ranꞌ a ni é re̱ꞌ, gui̱ꞌyaj a̱ ꞌngo̱ ni nuguanꞌ quij nan mánj. ");
INSERT INTO trq_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ni̱ hua yya dagahuin ni nane̱ xi̱ꞌi si ataj á re̱ꞌ. Sani̱ si̱ gahuin nia̱ꞌ ruhua ni é re̱ꞌ xiꞌí si unun ni nane̱ xi̱ꞌi si ataj á re̱ꞌ mánj. Sani̱ ga̱huin nia̱ꞌ ruhua á re̱ꞌ si hua ni̱ca si-xugüi a ni é re̱ꞌ ta rian yanj xataꞌ, ꞌyaj Yanꞌanj. ―Daj gataj Jesús rian hua̱ꞌnij xia chiꞌ ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Hué hora daj ni̱ gahuin nia̱ꞌ ruhua Jesús, guiꞌyaj Espíritu Santo. Ni̱ gataj sij gunun Yanꞌanj: ―Aꞌmi sa̱ꞌāj rián re̱ꞌ huín re̱ꞌ chrē nne xataꞌ. Ni̱ nicáj re̱ꞌ ni̱nꞌ sun xataꞌ nga̱ rian xungüi̱ ni̱caꞌ nej. Ni̱ aꞌmi sa̱ꞌāj rián re̱ꞌ xiꞌí si digyán re̱ꞌ nuguanꞌ sa̱ꞌ nan rian ni tsínj nitaj si huin achij. Ni̱ garij hui̱ re̱ꞌ nuguanꞌ sa̱ꞌ nan rian ni tsínj niꞌi sa̱ꞌ nga̱ ni tsínj chru̱n gaꞌi̱ nuguanꞌ nej. Ni̱ daꞌngaꞌ daj garanꞌ ruhuá re̱ꞌ guiꞌyáj re̱ꞌ huín re̱ꞌ chrē nne xataꞌ. ―Daj gataj Jesús gunun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ngaa ni̱ gataj Jesús gunun ni ngüi̱: ―Riqui chrē daranꞌ ni rasu̱n riānj. Ni̱ a̱ ꞌngo̱ ni ngüi̱ nun niꞌi da̱j hua manꞌānj huīnj daꞌníj Yanꞌanj. Sani̱ urin chrē niꞌi aj. Ni̱ ni̱ a̱ ꞌngo̱ ni ngüi̱ nun niꞌi da̱j hua chrē. Sani̱ urīnj niꞌi da̱j hua chrē si huīnj daꞌníj Yanꞌanj. Ni̱ u̱n ngüi̱ ri̱an ga̱ranꞌ ruhuāj digyānj, ni̱ ga̱ꞌue di̱gyānj rian ni sij da̱j hua chrē. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ngaa ni̱ niꞌyaj Jesús rian urin ni tsínj nicoꞌ sij. Ni̱ gataj sij: ―Hua ꞌueé rian ni tsínj acaj cuenta da̱j hua manꞌānj da̱j rúnꞌ acaj cuenta á re̱ꞌ niꞌyaj á re̱ꞌ rian xiꞌīj. ");
INSERT INTO trq_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Daj si asi̱j ná, ni̱ gahuin nico ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj nga̱ nico ni rey gahuin ruhua gui̱niꞌi ni síꞌ si niꞌi ni é re̱ꞌ acuanꞌ. Sani̱ nun gui̱niꞌi ni sij. Ni̱ gahuin ruhua ni sij gu̱nun ni sij si unun ni é re̱ꞌ. Sani̱ nun gunun ni sij mánj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ngaa ni̱ naxu̱man ꞌngo̱ tsínj digyán ley gaꞌmi sij nga̱ Jesús. Ni̱ gahuin ruhua sij xa̱caj sij cuenta xiꞌí si-nu̱guanꞌ Jesús. Ni̱ nachínj snanꞌanj sij Jesús. Ni̱ gataj sij: ―Maestro, da̱j gui̱ꞌyā, ni̱ ga̱ne ni̱gān nga̱ Yanꞌanj únj. ―Daj gataj sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ngaa ni̱ gataj Jesús: ―Da̱j ataj si-ley Yanꞌanj ayá re̱ꞌ únj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ni̱ gataj tsínj daj: ―“Ga̱huin ꞌi̱ ruhua néꞌ ni̱ꞌyaj néꞌ Señor huin Danꞌanj néꞌ nga̱ ni̱nꞌ niman néꞌ. Ni̱ ga̱huin ꞌi̱ ruhua néꞌ ni̱ꞌyaj néꞌ Yanꞌanj nga̱ daranꞌ si-fuerza néꞌ. Ni̱ ga̱huin ꞌi̱ ruhua néꞌ ni̱ꞌyaj néꞌ Yanꞌanj nga̱ ni̱nꞌ staꞌngaꞌ néꞌ. Ni̱ da̱j rúnꞌ ꞌi̱ ruhua néꞌ niꞌyaj néꞌ manꞌan néꞌ, ni̱ daꞌngaꞌ daj ga̱huin ꞌi̱ ruhua néꞌ ni̱ꞌyaj néꞌ ni dugüiꞌ néꞌ nej.” ―Daj gataj tsínj daj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ngaa ni̱ gataj Jesús: ―Duguꞌna̱j huaj atáj re̱ꞌ. Sisi̱ daꞌngaꞌ daj gui̱ꞌyáj re̱ꞌ, ni̱ ga̱ne ni̱ganj re̱ꞌ nga̱ Yanꞌanj nánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Sani̱ manꞌan tsínj daj, ni̱ gahuin ruhua sij sisi̱ gui̱niꞌi Jesús sisi̱ tsínj sa̱ꞌ huin sij. Xiꞌí daj ni̱ nachínj snanꞌanj sij Jesús. Ni̱ gataj sij: ―Ni̱ u̱n tsínj huin dugüiꞌīj únj. ―Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ngaa ni̱ nani Jesús ꞌngo̱ cuento gunun síꞌ. Ni̱ gataj sij: ―Gahui ꞌngo̱ tsínj daj xumanꞌ Jerusalén huaj sij chrej xumanꞌ Jericó. Ni̱ gahui ni tsínj tu̱. Ni̱ gaꞌnej ni síꞌ si-ganꞌ tsínj huaj daj. Ni̱ gaꞌuiꞌ ni síꞌ sij. Ni̱ guiranꞌ xi̱ꞌi sij, guiꞌyaj ni síꞌ. Ni̱ do̱j ni̱ gahuiꞌ sij ngaa ganꞌanj ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ngaa ni̱ huaj ꞌngo̱ chrej niquinꞌ rian ni tsínj israelita chrej daj. Sani̱ ngaa guiniꞌi sij ngaj tsínj guiranꞌ xi̱ꞌi daj, ni̱ gachin anéj sij rian síꞌ ganꞌanj sij. ");
INSERT INTO trq_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ni̱ huaj ꞌngo̱ tsínj levita chrej daj nej. Ni̱ ngaa guiniꞌi sij tsínj daj, ni̱ gachin anéj sij ganꞌanj sij nej. ");
INSERT INTO trq_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","’Sani̱ huaj ꞌngo̱ tsínj samaritano hué gue̱ chrej daj. Ni̱ tsínj ꞌna̱ꞌ anéj chrej huin síꞌ. Ni̱ ngaa guiniꞌi síꞌ tsínj ngaj daj, ni̱ gahuin ꞌi̱ ruhua síꞌ niꞌyaj síꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ni̱ gahuin ni̱chrunꞌ tsínj samaritano daj. Ni̱ guiꞌyaj go̱noꞌo sij gasiti nga̱ nnee vino tsínj guiranꞌ xi̱ꞌi daj. Ni̱ gumi sij atsij rian guiranꞌ xi̱ꞌi síꞌ. Ni̱ dagahui sij síꞌ xiráj dánj sij xucu. Ni̱ nicaj sij ganꞌanj sij mesón. Ni̱ dugumi sij manꞌan síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ngaa ni̱ ango güi ngaa huin ruhua sij ga̱nꞌanj sij, ni̱ guiri sij hui̱j sanꞌanj huin denario gaꞌuiꞌ sij raꞌa tsínj du̱cua huin mesón. Ni̱ gataj sij: “Du̱gumi re̱ꞌ tsínj nan. Ni̱ sisi̱ gu̱tinꞌ re̱ꞌ huaj, ni̱ manꞌānj na̱ruꞌue rián re̱ꞌ ngaa na̱nicā ru̱huaꞌ yún ga̱ꞌnāj.” ―Daj nani Jesús cuento rian tsínj digyán ley daj. ");
INSERT INTO trq_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ngaa ni̱ nachínj snanꞌanj Jesús síꞌ. Ni̱ gataj sij: ―Ngaa ni̱ da̱j hua yya ni hua̱ꞌnij tsínj gachin daj gahuin tsínj nicaj dugüiꞌ rian tsínj guiranꞌ xi̱ꞌi daj, ruhua manꞌán re̱ꞌ únj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ngaa ni̱ gataj tsínj daj: ―Hué tsínj gahuin ꞌi̱ ruhua niꞌya tsínj guiranꞌ xi̱ꞌi, ruhuāj aj. ―Daj gataj tsínj digyán ley daj. Ngaa ni: ―Güi̱j re̱ꞌ ni̱ daꞌngaꞌ daj gui̱ꞌyaj manꞌán re̱ꞌ nej. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ni̱ ngaa huaj Jesús chrej, ni̱ guisíj síꞌ ꞌngo̱ xumanꞌ rian nu̱n ꞌngo̱ yunꞌunj xa̱na gu̱ꞌnaj Marta. Ni̱ gunáj Jesús ducuá únꞌ, guiꞌyaj únꞌ. ");
INSERT INTO trq_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ni̱ hua ꞌngo̱ xugüiꞌij Marta gu̱ꞌnaj María. Ni̱ ganꞌanj ga̱ne María dacój Jesús unun únꞌ si ataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ni̱ da nahuij ruhua Marta ꞌyaj sun únꞌ. Ngaa ni̱ gahuin ni̱chrunꞌ únꞌ rian Jesús, ni̱ nachínj snanꞌanj únꞌ: ―Señor, u̱n sin huin ni̱ nitaj si nahuij ruhuá re̱ꞌ sisi̱ urīnj duna xugüiꞌīj rian daranꞌ ni rasu̱n ꞌyā nan únj. Ga̱taj re̱ꞌ gu̱nun unj si chra̱cuij unj yūnj anj. ―Daj gataj Marta gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ngaa ni̱ gataj Jesús: ―Marta, Marta, nahuij ruhuá re̱ꞌ nga̱ daranꞌ ni sun ꞌyáj re̱ꞌ. Ni̱ naꞌue ga̱huin dinꞌinj ruhuá re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Sani̱ hua urin nuguanꞌ sa̱ꞌ huin si níꞌyanj. Ni̱ hua nacui María nuguanꞌ sa̱ꞌ daj. Ni̱ ni̱ a̱ ꞌngo̱ ni ngüi̱ si̱ gaꞌue ga̱taj sisi̱ si̱ gunun María si-nu̱guanꞌānj mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ngaa ni̱ ꞌngo̱ yu̱n nne Jesús ꞌngo̱ yuꞌuj gachínj jniꞌyaj sij rian Yanꞌanj. Ni̱ ngaa ganahuij gachínj jniꞌyaj sij, ni̱ gataj ꞌngo̱ tsínj nicoꞌ sij: ―Señor, di̱gyán re̱ꞌ rian únj da̱j ga̱ꞌmi únj ngaa ga̱chinj jniꞌyaj ni únj rian Yanꞌanj da̱j rúnꞌ digyán Juan rian ni tsínj nicoꞌ síꞌ, ruhua únj. ―Daj gataj tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ngaa ni̱ gataj Jesús: ―Ngaa ga̱chinj jniꞌyaj á re̱ꞌ rian Yanꞌanj, ni̱ ga̱taj á re̱ꞌ: Chrej ni únj huín re̱ꞌ nné re̱ꞌ xataꞌ. Ni̱ huin ruhua únj si ga̱ꞌmi ꞌueé ni ngüi̱ xiꞌí si-xugüi manꞌán re̱ꞌ. Ni̱ huin ruhua únj si ga̱ꞌnaꞌ re̱ꞌ gui̱nicaj re̱ꞌ sun rian ni ngüi̱, ruhua ni únj. Ni̱ da̱j rúnꞌ dagahuin sa̱ꞌ ni ángel mán xataꞌ rian manꞌán re̱ꞌ, ni̱ daꞌngaꞌ daj da̱gahuin ni ngüi̱ mán ni̱caꞌ rian manꞌán re̱ꞌ, ruhua únj nej. ");
INSERT INTO trq_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ni̱ ri̱qui re̱ꞌ si xa̱ ni únj daꞌ go̱ꞌngo güi. ");
INSERT INTO trq_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ni̱ gui̱nicaj re̱ꞌ ꞌngo̱ niman nico xiꞌí si-ga̱quinꞌ únj si daꞌngaꞌ daj nicaj únj niman nico xiꞌí gaquinꞌ ꞌyaj dugüiꞌ únj rian únj nej. Ni̱ si̱ duná re̱ꞌ si ga̱tsij sichre niman ni únj mánj. Sani̱ ga̱ꞌni re̱ꞌ sisi̱ si̱ guiꞌyaj gana si quij rian únj. Daꞌngaꞌ daj ga̱taj á re̱ꞌ ngaa ga̱chinj jniꞌyaj á re̱ꞌ rian Yanꞌanj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ni̱ gataj ru̱huaꞌ yún Jesús: ―Gui̱ꞌyóꞌ cuenta sisi̱ hua ꞌngo̱ tsínj nicaj dugüiꞌ nga̱ ꞌngo̱ ni é re̱ꞌ. Ni̱ huaj sij yanꞌ sa̱ꞌ ducuá síꞌ. Ni̱ ga̱taj sij gu̱nun síꞌ: “Jna̱nj, chra̱cuij re̱ꞌ hua̱ꞌnij chrachrúnj xa̱ ꞌngo̱ dugüiꞌīj ꞌna̱ꞌ ducuāj. ");
INSERT INTO trq_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ni̱ huaj sij chrej, sani̱ nitaj si guiriꞌīj ga̱ꞌuīj xa̱ sij mánj.” Daj ga̱taj sij rian dugüiꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Sani̱ ga̱taj tsínj nne chruhua hueꞌ gu̱nun dugüiꞌ sij: “Si̱ gaꞌna̱ꞌ chranꞌ yunꞌúnj re̱ꞌ yūnj mánj. Hua ránj rian hueꞌ. Ni̱ ngā nga̱ ni daꞌnī rian nna. Si̱ gaꞌue na̱chicāj ri̱quīj rián re̱ꞌ mánj.” Daj ga̱taj sij, ruhua á re̱ꞌ únj. Sé daj ga̱taj sij mánj. ");
INSERT INTO trq_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ni̱ atā gu̱nun a ni é re̱ꞌ sisi̱ nu̱nj si naꞌuej sij na̱chica sij ga̱ꞌuiꞌ sij xiꞌí si nicaj dugüiꞌ tsínj daj nga̱ sij, sani̱ xiꞌí si ducu reque̱ síꞌ, ni̱ na̱chica sij ga̱ꞌuiꞌ sij daranꞌ si achínj síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","’Asíj ni̱ atā gu̱nun a ni é re̱ꞌ sisi̱ ga̱chinj jniꞌyaj á re̱ꞌ rian Yanꞌanj. Ni̱ ri̱qui Yanꞌanj rian án re̱ꞌ. Na̱noꞌ a ni é re̱ꞌ nuguanꞌ sa̱ꞌ, ni̱ na̱riꞌ a ni é re̱ꞌ. Ni̱ gui̱ꞌyaj á re̱ꞌ rúnꞌ ꞌyaj ꞌngo̱ tsínj ita raꞌa rian hueꞌ, ni̱ na̱ꞌni Yanꞌanj ga̱tu a ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Daj si daranꞌ ni ngüi̱ achínj, ni̱ riꞌ ni sij. Ni̱ ni ngüi̱ na̱noꞌ, ni̱ na̱riꞌ ni sij nej. Ni̱ ni ngüi̱ ita raꞌa rian hueꞌ, ni̱ na̱ꞌni Yanꞌanj ga̱tu ni sij nej. ");
INSERT INTO trq_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ni̱ sisi̱ daꞌníj ni é re̱ꞌ achínj chrachrúnj xaj, ni̱ ga̱ꞌue ga̱ꞌuiꞌ a ni é re̱ꞌ yej raꞌa níꞌ. Ni̱ ngaa achin ꞌngo̱ xucuaj, ni̱ ga̱ꞌue ga̱ꞌuiꞌ a ni é re̱ꞌ ꞌngo̱ xucuáj xa̱ sij níꞌ. Sé daj huin mánj. ");
INSERT INTO trq_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ni̱ ga̱ꞌue ga̱ꞌuiꞌ a ni é re̱ꞌ ꞌngo̱ xiquin raꞌa daꞌníj a ni é re̱ꞌ ngaa achin chruj níꞌ. Sé daj huin mánj. ");
INSERT INTO trq_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tsínj xi̱ꞌi huin a ni é re̱ꞌ. Sani̱ niꞌi a ni é re̱ꞌ si hua sa̱ꞌ ga̱ꞌuiꞌ ni é re̱ꞌ xa̱ ni daꞌníj ni é re̱ꞌ. Yuꞌuj daj ni̱ huaj ni̱nꞌ ruhua si ri̱qui yya chrej a ni é re̱ꞌ nne xataꞌ Espíritu Santo rian ni ngüi̱ achínj Espíritu Santo rian-ánꞌ. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ni̱ ꞌngo̱ güi ni̱ guiri Jesús ꞌngo̱ nane̱ xi̱ꞌi niman ꞌngo̱ tsínj naꞌue ga̱ꞌmi daj. Ni̱ gaxi̱ꞌi síꞌ gaꞌmi síꞌ. Ni̱ gahuin yanꞌanj ruhua ni ngüi̱ guiniꞌi ni sij si guiꞌyaj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Sani̱ gaꞌmi go̱ꞌngo ni sij xiꞌí Jesús. Ni̱ gataj ni sij: ―Xiꞌí si-fuerza manꞌan sichre gu̱ꞌnaj Beelzebú, ni̱ ri Jesús ni nane̱ xi̱ꞌi niman ni ngüi̱. ―Daj gataj daꞌaj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ni̱ gachínj ango daꞌaj ni sij sisi̱ gui̱ꞌyaj Jesús ꞌngo̱ si sa̱ꞌ ꞌna̱ꞌ xataꞌ. Daj si huin ruhua ni sij gu̱taꞌ ni sij gaquinꞌ xiráj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Sani̱ niꞌi Jesús si ani ruhua ni sij. Ngaa ni̱ gataj sij: ―Sisi̱ ununꞌ ni du̱güiꞌ ꞌngo̱ ducuasun, ni̱ gue̱reꞌ xumanꞌ daj, gui̱ꞌyaj ni manꞌan ni sij mán sij. Ni̱ sisi̱ ununꞌ ꞌngo̱ tsínj daj nga̱ ni dugüiꞌ sij mán ducuá sij, ni̱ gue̱reꞌ ni sij nej. ");
INSERT INTO trq_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Hué daj huin sisi̱ ununꞌ sichre Satanás nga̱ ni nane̱ xi̱ꞌi, ni̱ da̱j ga̱ꞌue gu̱nucuaj rian nicaj sun sichre Satanás, ruhua á re̱ꞌ únj. Ni̱ daꞌngaꞌ daj nachínj snanꞌān a ni é re̱ꞌ xiꞌí si ataj á re̱ꞌ si rīj nane̱ xi̱ꞌi chruhua niman ni ngüi̱ nga̱ si-fuerza Beelzebú. Sani̱ sé si xa̱ngaꞌ huin mánj. ");
INSERT INTO trq_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Sani̱ sisi̱ rīj ni nane̱ xi̱ꞌi niman ni ngüi̱ nga̱ si-fuerza Beelzebú, ngaa ni̱ u̱n tsínj riqui sisi̱ gui̱ri ni tsínj nicoꞌ ni é re̱ꞌ nane̱ xi̱ꞌi niman ni ngüi̱, ruhua á re̱ꞌ únj. Aꞌmi ni sij nga̱ ni nane̱ xi̱ꞌi, ruhua á re̱ꞌ níꞌ. Hué dan ni̱ digyán ni síꞌ sisi̱ nitaj si hua ni̱ca ruhua á re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Sani̱ sisi̱ hua yya rīj nane̱ xi̱ꞌi chruhua niman ni ngüi̱ ꞌyaj raꞌa manꞌan Yanꞌanj xa̱ngaꞌ, ngaa ni̱ huin ruhuaj gata sisi̱ gaꞌna̱ꞌ gui̱sij si guinicaj sun Yanꞌanj scanij a ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Gui̱ꞌyoꞌ cuenta da̱j ꞌyaj ꞌngo̱ tsínj hua nucuaj nne ducuaj. Ngaa hua xirúnj si chriaꞌ sij dugumi sij ducuá sij, ni̱ hua xitinj ruhua sij nne sij nga̱ daranꞌ si nara sa̱ꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Sani̱ ngaa ꞌna̱ꞌ ango tsínj nucuaj doj daj nga̱ manꞌan sij, ni̱ gui̱ꞌyaj gana síꞌ rian sij. Ni̱ ga̱ꞌnej síꞌ xirúnj si chriaꞌ sij nga̱ ango ni rasu̱n nara sa̱ꞌ sij. Ni̱ gu̱raꞌ daꞌaj síꞌ nga̱ ni dugüiꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Ni̱ tsínj nitaj si nicaj dugüiꞌ ngāj, ni̱ ununꞌ sij ngāj. Ni̱ tsínj nitaj si na̱ranꞌ strigo ngāj, ni̱ reꞌej sij strigo aj. Ni̱ ꞌyaj sij sisi̱ naꞌue gui̱nicoꞌ ni ngüi̱ manꞌānj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús: ―Ni̱ ngaa gahui nane̱ xi̱ꞌi niman ꞌngo̱ tsínj daj, ni̱ chéj nane̱ xi̱ꞌi ꞌngo̱ yuꞌuj hua na̱co nanoꞌ sij ni̱ a̱ na̱ranj ruhuaj. Sani̱ nun nariꞌ sij rian na̱ranj ruhuaj. Ngaa ni̱: “Na̱nicā ru̱huaꞌ yūnj ducuāj rian gahuī”, ataj nane̱ xi̱ꞌi daj. ");
INSERT INTO trq_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ni̱ ngaa nanica̱j nane̱ xi̱ꞌi daj, ni̱ nariꞌ sij ꞌngo̱ hueꞌ hua níꞌnij. Ni̱ hua nacaꞌ ne. Ni̱ naguiꞌyaj sa̱ꞌ ne hueꞌ daj. Ni̱ daꞌngaꞌ da̱j rúnꞌ huin hueꞌ daj, hué daj huin niman tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ngaa ni̱ ganꞌanj nane̱ xi̱ꞌi daj. Ni̱ na̱noꞌ-óꞌ ango ichij nane̱ xi̱ꞌi quij hua daj nga̱ manꞌan sij. Ni̱ daranꞌ ni nane̱ xi̱ꞌi daj ga̱natu nu̱guanꞌan niman tsínj daj ru̱huaꞌ yún ga̱ne-éꞌ. Ni̱ gui̱ranꞌ tsínj daj nico sayun daj nga̱ si guiranꞌ sij asi̱j sini ya̱n. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ni̱ diaj hua aꞌmi Jesús, ni̱ gaguáj ꞌngo̱ yunꞌunj xa̱na nne scanij ni ngüi̱. Ni̱ gataj únꞌ: ―Hua ꞌueé rian nní re̱ꞌ xiꞌí si guchruj únꞌ manꞌán re̱ꞌ. Ni̱ dugutsi únꞌ manꞌán re̱ꞌ nej. ―Daj gaguáj yunꞌunj xa̱na daj. ");
INSERT INTO trq_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sani̱ gataj Jesús: ―Hua ꞌueé rian ni ngüi̱ unun si-nu̱guanꞌ Yanꞌanj. Ni̱ ꞌyaj ni sij da̱j rúnꞌ ataj Yanꞌanj gunun ni sij nej. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ni̱ gahuin nico ni ngüi̱ nahuin yuꞌ xiꞌníj Jesús. Ngaa ni̱ gaxi̱ꞌi Jesús gaꞌmi sij. Ni̱ gataj sij: ―Sé ni ngüi̱ sa̱ꞌ huin ni ngüi̱ mán yya̱j. Achínj ni sij ꞌngo̱ si sa̱ꞌ ꞌna̱ꞌ xataꞌ, gui̱ꞌyā. Sani̱ si̱ guiꞌyā ꞌngo̱ si sa̱ꞌ gui̱niꞌi ni sij mánj. Urin si guiranꞌ tsínj gu̱ꞌnaj Jonás asi̱j ná huin si gui̱niꞌi ni sij aj. ");
INSERT INTO trq_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ni̱ da̱j rúnꞌ guiꞌyaj Yanꞌanj ꞌngo̱ si sa̱ꞌ nico nga̱ Jonás guiniꞌi ni ngüi̱ guimán xumanꞌ Nínive asi̱j ná, ni̱ daꞌngaꞌ daj gui̱ꞌyaj Yanꞌanj nga̱ manꞌānj gui̱niꞌi ni ngüi̱ mán yya̱j huīnj daꞌníj ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","’Ni̱ ngaa gui̱sij güi na̱guiꞌyaj yya Yanꞌanj nga̱ ni ngüi̱, ni̱ ga̱niquinꞌ reina ꞌna̱ꞌ ne̱ꞌ sur ga̱taj únꞌ sisi̱ daꞌui ni ngüi̱ mán yya̱j gaquinꞌ. Daj si gaꞌna̱ꞌ únꞌ daꞌ xiꞌí ni̱nꞌ xungüi̱ gunun únꞌ si-nu̱guanꞌ tsínj gu̱ꞌnaj Salomón. Ni̱ huin chru̱n síꞌ si-nu̱guanꞌ Yanꞌanj. Sani̱ huin achij manꞌānj daj nga̱ Salomón rian án re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ni̱ güi ga̱nahuij xungüi̱ ngaa na̱guiꞌyaj Yanꞌanj xiꞌí si-ga̱quinꞌ ni tsínj, ni̱ na̱xuman ni tsínj guimán xumanꞌ Nínive asi̱j ná nga̱ ni tsínj ma̱n acuanꞌ. Ni̱ ga̱taj ni tsínj daj sisi̱ daꞌui ni tsínj ma̱n acuanꞌ gaquinꞌ. Daj si ganani ruhua ni tsínj guimán Nínive daj xiꞌí si-ga̱quinꞌ ni sij ngaa gunun ni sij si nataꞌ Jonás si-nu̱guanꞌ Yanꞌanj gunun ni sij. Sani̱ huin achij manꞌānj daj nga̱ Jonás rian án re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ni̱ gataj ru̱huaꞌ yún Jesús: ―Ni̱ sé si ga̱ri hui̱ꞌ ꞌngo̱ candil ngaa arúnꞌ yanꞌa̱n chra̱-áꞌ. Ni̱ si̱ guneꞌ riqui chrúnj mánj. Sani̱ gu̱toꞌ xataꞌ sisi̱ gui̱xiguin rian ni ngüi̱ ga̱tu chruhua hueꞌ. ");
INSERT INTO trq_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","’Rúnꞌ huin ꞌngo̱ yanꞌa̱n xigui̱n, ni̱ daꞌngaꞌ daj huin rundij rian néꞌ. Ni̱ ngaa xigui̱n sa̱ꞌ rundij rian néꞌ, ni̱ niꞌyaj sa̱ꞌ néꞌ. Sani̱ sisi̱ nitaj si xigui̱n sa̱ꞌ rundij rian néꞌ, ni̱ naꞌue na̱riꞌ néꞌ ꞌngo̱ chrej sa̱ꞌ ga̱nꞌanj néꞌ. Daj si hua ru̱miꞌ rian néꞌ. ");
INSERT INTO trq_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ga̱ cuidado rian án re̱ꞌ sisi̱ xi̱guin sa̱ꞌ chruhua niman án re̱ꞌ. Ngaa ni̱ si̱ ga ru̱miꞌ rian nne ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ni̱ sisi̱ xigui̱n sa̱ꞌ chruhua niman néꞌ, ni̱ nitaj si hua ru̱miꞌ rian nne néꞌ mánj. Daj si xigui̱n sa̱ꞌ chruhua niman néꞌ niꞌyaj néꞌ da̱j rúnꞌ ꞌyaj ꞌngo̱ yanꞌa̱n xigui̱n. ―Daj gataj Jesús gunun ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ni̱ ngaa ganahuij gaꞌmi Jesús, ni̱ gaquínj ꞌngo̱ tsínj fariseo xa̱ Jesús ducuá síꞌ. Ni̱ gatúj Jesús ganꞌanj ga̱ne sij rian mesa. ");
INSERT INTO trq_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ni̱ gahuin yanꞌanj ruhua tsínj daj ngaa guiniꞌi sij sisi̱ nun nania̱ꞌ nico Jesús asi̱j ngaa achin xa̱ nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Sani̱ gataj Señor gunun sij: ―Ni tsínj fariseo huin ni é re̱ꞌ. Ni̱ naꞌninꞌ sa̱ꞌ á re̱ꞌ xiráj tasa nga̱ xiráj goꞌo nej. Sani̱ ne̱ꞌ chru̱hua niman án re̱ꞌ, ni̱ ma̱n ni̱nꞌ ruhua si quij hua. Daj si ꞌyaj tu̱ a ni é re̱ꞌ, ni̱ ꞌyaj quij a ni é re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tsínj nitaj si unun huin ín re̱ꞌ. Niꞌi a ni é re̱ꞌ sisi̱ guiꞌyaj Yanꞌanj nnee̱ cúj néꞌ. Ni̱ daꞌngaꞌ daj nun niꞌi a ni é re̱ꞌ sisi̱ guiꞌyaj Yanꞌanj niman néꞌ níꞌ. ");
INSERT INTO trq_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Sani̱ ga̱ꞌuiꞌ a ni é re̱ꞌ daꞌaj siꞌyaj á re̱ꞌ rian ni ngüi̱ niqui, ngaa ni̱ xa̱caj á re̱ꞌ cuenta sisi̱ hua sa̱ꞌ chrej chéj a ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Sani̱ ducu niqui niman án re̱ꞌ ni tsínj fariseo. Daj si gui̱ranꞌ ni é re̱ꞌ nico sayun. Aya á re̱ꞌ rumi coj nun stila nga̱ coj ruda nej, daranꞌ ni cuej nej. Ni̱ ngaa guisíj ichiꞌ rumi, ni̱ aꞌuiꞌ ni é re̱ꞌ ꞌngo̱ rumi rian Yanꞌanj. Sani̱ dunáj a ni é re̱ꞌ si gui̱ꞌyaj ni̱ca á re̱ꞌ rian dugüiꞌ a ni é re̱ꞌ. Ni̱ nitaj si ꞌi̱ ruhua á re̱ꞌ niꞌyaj á re̱ꞌ Yanꞌanj mánj. Sani̱ huin ruhua Yanꞌanj sisi̱ gui̱ꞌyaj á re̱ꞌ ni nuguanꞌ nico nan. Ni̱ naꞌuej ruhua Yanꞌanj sisi̱ du̱náj á re̱ꞌ nga̱ ango nuguanꞌ le mánj. ");
INSERT INTO trq_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Ducu niqui niman ni é re̱ꞌ tsínj fariseo. Gui̱ranꞌ ni é re̱ꞌ nico sayun. Daj si aranꞌ ruhua á re̱ꞌ ga̱ne a ni é re̱ꞌ chrun xila sa̱ꞌ doj niquinꞌ chruhua nuhui. Ni̱ aranꞌ ruhua ni é re̱ꞌ si ga̱run duꞌua ni ngüi̱ raꞌa ni é re̱ꞌ rian yuꞌue̱. ");
INSERT INTO trq_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Ni̱ ducu niqui niman án re̱ꞌ huin ín re̱ꞌ ni tsínj fariseo. Tsínj digyaꞌ yunꞌunj huin ín re̱ꞌ. Ni̱ rúnꞌ hua rian achinꞌ ni ngüi̱ níman daj huin ín re̱ꞌ. Ni̱ nun niꞌi ni ngüi̱. Ni̱ rúnꞌ huin ngaa xinga ni ngüi̱ a nun niꞌi ni sij ngaj níman, ni̱ run ni sij daꞌngaꞌ da huin ín re̱ꞌ. Daj si nun niꞌi ni sij sisi̱ quij ni̱nꞌ ruhua hua niman án re̱ꞌ. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ngaa ni̱ gataj ꞌngo̱ tsínj digyán ley rian Jesús: ―Maestro, ngaa aꞌmí re̱ꞌ daj, ni̱ aꞌmi quíj re̱ꞌ rian ni únj nej. ―Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Sani̱ gataj Jesús: ―Ducu niqui niman án re̱ꞌ tsínj digyán ley. Daj si gui̱ranꞌ ni é re̱ꞌ nico sayun. Ni̱ rúnꞌ ꞌyaj ni tsínj arun carga yaꞌi̱ xiráj ni xucu daj, ꞌyaj á re̱ꞌ nga̱ ni ngüi̱. Ni̱ yaꞌi̱ ni̱nꞌ ruhua carga daj. Ni̱ naꞌue gu̱nucuaj ni sij ga̱che ni sij. Ni̱ a̱ do̱j naꞌue chra̱cuij a ni é re̱ꞌ ni sij nga̱ urin raꞌa ni é re̱ꞌ ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Ni̱ ducu niqui niman án re̱ꞌ xiꞌí sayun gui̱ranꞌ án re̱ꞌ. Daj si ꞌyaj á re̱ꞌ ni chra̱n rian ngaj ni níman ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. Ni̱ dagahuiꞌ ni xi ni é re̱ꞌ ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ni̱ xiꞌí si ꞌyaj quij ni é re̱ꞌ, ni̱ daꞌngaꞌ daj digyán ni é re̱ꞌ sisi̱ ga ni̱ca ruhua á re̱ꞌ nga̱ si guiꞌyaj ni xi a ni é re̱ꞌ. Daj si hua yya dagahuiꞌ ni sij ni síꞌ. Sani̱ ꞌyaj ni é re̱ꞌ ni chra̱n rian achinꞌ ni sij aj. ");
INSERT INTO trq_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Ni̱ ri̱an niꞌi sa̱ꞌ Yanꞌanj, ni̱ gataj-áꞌ: “Ga̱ꞌnī ni tsínj ga̱ꞌmi si-nu̱guanꞌānj nga̱ ni tsínj gui̱ꞌyaj sun riānj nej. Ni̱ da̱gahuiꞌ ni sij go̱ꞌngo ni síꞌ. Ni̱ gui̱nicoꞌ ni sij ango ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ni̱ asi̱j guiꞌyaj Yanꞌanj xungüi̱, ni̱ dagahuiꞌ ni sij gaꞌi̱ ni̱nꞌ ruhua ni tsínj nataꞌ si-nu̱guanꞌ Yanꞌanj rian ni ngüi̱. Sani̱ daꞌui ni ngüi̱ mán yya̱j si-tun manꞌan ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ni̱ daꞌui sini ni sij si-tun manꞌan tsínj gu̱ꞌnaj Abel. Ni̱ ganahui daꞌ si-tun manꞌan Zacarías huin si daꞌui ni sij. Ni̱ dagahuiꞌ ni sij síꞌ da̱ni nna yej nga̱ ducuá Yanꞌanj.” Daꞌngaꞌ daj atā gu̱nun a ni é re̱ꞌ sisi̱ daꞌui ni ngüi̱ mán yya̱j gaquinꞌ, guiꞌyaj ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Ni̱ ducu niqui niman án re̱ꞌ ni tsínj digyán ley. Gui̱ranꞌ ni é re̱ꞌ nico sayun. Daj si aránj ni é re̱ꞌ si-chrej Yanꞌanj rian ni ngüi̱. Ni̱ nun ga̱ꞌue ga̱tu ni é re̱ꞌ chrej daj nej. Ni̱ ni tsínj huin ruhua ga̱tu, ni̱ naꞌuej ruhua á re̱ꞌ ga̱tu ni sij mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ni̱ ngaa gaꞌmi Jesús ni nuguanꞌ daj, ni̱ gaꞌman ni̱nꞌ ruhua ni tsínj digyán ley nga̱ ni tsínj fariseo. Ngaa ni̱ gaxi̱ꞌi ni sij nachínj snanꞌanj ni sij Jesús xiꞌí gaꞌi̱ rasu̱n. Ni̱ chranꞌ yunꞌunj ni sij síꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Daj si huin ruhua ni sij sisi̱ ga̱che duꞌua Jesús xiꞌí si ga̱ꞌmi síꞌ. Ngaa ni̱ ga̱ꞌmi gaquinꞌ ni sij xiꞌí síꞌ, ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Hué dan ni̱ nahuin yuꞌ gaꞌi̱ mil ni ngüi̱ rian huaj Jesús. Ni̱ da run ꞌngo̱ run ango ni sij. Ni̱ gaxi̱ꞌi Jesús gaꞌmi síꞌ. Ni̱ gataj sini síꞌ rian ni tsínj nicoꞌ síꞌ: ―Ga̱ cuidado ni é re̱ꞌ nga̱ si-levadura ni tsínj fariseo. Daj si tsínj digyaꞌ yunꞌunj huin ni sij. Nitaj si ꞌyaj ni sij da̱j rúnꞌ aꞌmi ni sij. ");
INSERT INTO trq_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Si̱ gaꞌue ga̱ri hui̱ ni ngüi̱ ꞌngo̱ ni nuguanꞌ mánj. Ni̱ si̱ gaꞌue ga̱ri hui̱ ni ngüi̱ si ꞌyaj ni sij mánj. Sani̱ hua ꞌngo̱ güi, ni̱ na̱xiraꞌ daranꞌ ni nuguanꞌ gari hui̱ ni ngüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hué dan ni̱ daranꞌ si gaꞌmi a ni é re̱ꞌ rian hua ru̱miꞌ, sani̱ gu̱nun ni ngüi̱ ni nuguanꞌ daj rian hua xigui̱n yanꞌa̱n. Ni̱ daranꞌ ni nuguanꞌ gaꞌmi hui̱ ni é re̱ꞌ ngaa naránj ni é re̱ꞌ rian ducuá re̱ꞌ ngaa gaꞌmi hui̱ ni é re̱ꞌ, ni̱ ga̱guaj ni sij xe̱ꞌ gu̱nun daranꞌ ni ngüi̱ aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ngaa ni̱ gataj Jesús gunun ni sij: ―Ni̱ huin ni é re̱ꞌ ni tsínj nicaj dugüiꞌ ngāj. Ni̱ ataj snanꞌān gu̱nun ni é re̱ꞌ sisi̱ si̱ guxuꞌuiꞌ ni é re̱ꞌ rian ni tsínj ga̱ꞌue da̱gahuiꞌ nnee̱ cúj néꞌ. Ngaa síj ni̱ nitaj ango si gui̱ꞌyaj ni sij nga̱ néꞌ ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Sani̱ ga̱tā gu̱nun a ni é re̱ꞌ u̱n sin ri̱an gu̱xuꞌuiꞌ ni é re̱ꞌ: Hué gu̱xuꞌuiꞌ ni é re̱ꞌ rian Yanꞌanj xa̱ngaꞌ. Daj si ngaa ga̱huiꞌ ni é re̱ꞌ, gui̱ꞌyaj Yanꞌanj, ni̱ ga̱taj Yanꞌanj u̱n ngüi̱ ga̱nꞌanj rian yanꞌa̱n. Ngaa ni̱ hua si xi̱ꞌi xuꞌuiꞌ ni é re̱ꞌ rian Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Xa̱ngaꞌ aneꞌ u̱nꞌunꞌ xataj le hui̱j sanꞌanj moneda aj. Sani̱ nitaj si ni̱ꞌyun ruhua Yanꞌanj go̱ꞌngo ni xuj mánj. ");
INSERT INTO trq_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hué daj nga̱ ni é re̱ꞌ, ni̱ aya Yanꞌanj daꞌ go̱ꞌngo hueé chra̱ ni é re̱ꞌ. Xiꞌí daj ni̱ si̱ guxuꞌuiꞌ ni é re̱ꞌ mánj. Daj si huaj níꞌyanj ni é re̱ꞌ rian ni xataj aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ngaa ni gataj Jesús: ―Ataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ daranꞌ ni tsínj na̱taꞌ sisi̱ nicoꞌ ni sij yūnj rian ni ngüi̱, ngaa ni̱ na̱tāj rian ni ángel nne nga̱ Yanꞌanj sisi̱ tsínj nicoꞌ manꞌānj huin ni sij. ");
INSERT INTO trq_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Sani̱ daranꞌ ni tsínj naꞌuej ruhua na̱taꞌ rian ni ngüi̱ si nicoꞌ ni sij manꞌānj, ni̱ naꞌue na̱tāj rian ni ángel nne nga̱ Yanꞌanj sisi̱ tsínj nicoꞌ manꞌānj huin ni sij mánj. ");
INSERT INTO trq_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Ga̱ꞌue gui̱nicaj Yanꞌanj ꞌngo̱ niman nico xiꞌí ni ngüi̱ ga̱ꞌmi quij rian daꞌníj ni ngüi̱ huin manꞌānj. Sani̱ si̱ gui̱nicaj Yanꞌanj niman nico xiꞌí ni ngüi̱ ga̱ꞌmi quij xiꞌí Espíritu Santo mánj. ");
INSERT INTO trq_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Ni̱ ngaa ni̱caj ni sij ni é re̱ꞌ ga̱nꞌanj án re̱ꞌ si-nuhui ni tsínj israelita nga̱ rian güesi̱ nga̱ rian ni tsínj nicaj sun, ngaa ni̱ si̱ gahuin ruhua á re̱ꞌ si da̱j ga̱taj á re̱ꞌ ngaa na̱chinj snanꞌanj ni sij ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Daj si ngaa gui̱sij hora ga̱ꞌmi a ni é re̱ꞌ, ni̱ di̱gyán manꞌan Espíritu Santo si ga̱ꞌmi a ni é re̱ꞌ rian ni síꞌ. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ngaa ni̱ gataj ꞌngo̱ tsínj niquinꞌ scanij ni ngüi̱ gunun Jesús: ―Maestro, ga̱taj re̱ꞌ gu̱nun jnān si gu̱raꞌ daꞌaj sij si dunáj chrej nu̱ngüej únj. ―Daj gataj tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ngaa ni̱ gataj Jesús: ―Jnánj néꞌ, u̱n sin huin ani ruhuá re̱ꞌ sisi̱ ga̱huin manꞌānj tsínj gui̱ꞌyaj yya scanij ni é re̱ꞌ únj. Ni̱ u̱n sin huin ni̱ ga̱ꞌmī xiꞌí rasu̱n hua rian nu̱ngüej jnánj re̱ꞌ, ruhuá re̱ꞌ únj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ngaa ni̱ gataj Jesús gunun ni ngüi̱: ―Ga̱ cuidado ni é re̱ꞌ sisi̱ si̱ gahuin xicoj ruhua ni é re̱ꞌ nga̱ ni rasu̱n mán chruhua xungüi̱ nan mánj. Sisi̱ gui̱riꞌ néꞌ nico ni rasu̱n ga̱huin siꞌyaj néꞌ, ni̱ sé ni rasu̱n daj gui̱ꞌyaj si xa̱caj néꞌ ꞌngo̱ chrej sa̱ꞌ mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ngaa ni̱ nani Jesús ꞌngo̱ cuento si digyán sij rian ni ngüi̱. Ni̱ gataj sij: ―Hua ꞌngo̱ tsínj xuruꞌue. Ni̱ sa̱ꞌ ni̱nꞌ ruhua gaꞌuej xina̱ sij. ");
INSERT INTO trq_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ngaa ni̱ gani ruhua tsínj xuruꞌue daj: “Da̱j gui̱ꞌyā, ni̱ nitaj rian na̱ra sa̱ꞌāj ni rasu̱n nan mánj.” Daꞌngaꞌ daj gani ruhua sij. ");
INSERT INTO trq_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Hué dan ni̱ gataj sij gunun manꞌan sij: “Hua niꞌīnj da̱j gui̱ꞌyā. Ga̱ꞌnē ni si-gu̱rūj, ni̱ na̱guiꞌyaj xa̱chij ru̱huaꞌ yūnj angoj. Ni̱ na̱ra sa̱ꞌāj daranꞌ ni si gui̱riꞌīj nga̱ daranꞌ ni rasu̱n mán nej. ");
INSERT INTO trq_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Hué dan ni̱ ga̱tā gu̱nun nimānj sisi̱ ma̱n nico ni rasu̱n daj riānj. Ni̱ gui̱si gaꞌi̱ yoꞌ. Ni̱ ga̱ꞌue na̱ranj ruhuāj, ni̱ xa̱j, ni̱ go̱ꞌōj nej. Ni̱ ga̱ꞌue ga̱huin nia̱ꞌ ruhuāj nej. Daj ga̱tā gu̱nun nimānj.” Daj gani ruhua tsínj xuruꞌue daj. ");
INSERT INTO trq_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Sani̱ gataj Yanꞌanj gunun sij: “Tsínj ni̱ꞌyun huín re̱ꞌ. Hué gue̱ ni̱ nan ga̱huiꞌ re̱ꞌ. Ni̱ u̱n sin siꞌyaj ga̱huin si nara sa̱ꞌ re̱ꞌ, ruhuá re̱ꞌ únj.” Daj gataj Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Daꞌngaꞌ daj ga̱huin gui̱ranꞌ tsínj riꞌ nico ni rasu̱n ngaa huin-ínꞌ güenda urin manꞌan sij. Ni̱ niqui niman sij rian Yanꞌanj si nitaj ni rasu̱n sa̱ꞌ nicaj sij güenda Yanꞌanj mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Hué dan ni̱ gataj Jesús gunun ni tsínj nicoꞌ sij: ―Xiꞌí daj ga̱tā gu̱nun a ni é re̱ꞌ sisi̱ si̱ gahuin ruhua ni é re̱ꞌ nga̱ si xa̱ ni é re̱ꞌ gui̱man ni é re̱ꞌ mánj. Ni̱ si̱ gahuin ruhua á re̱ꞌ nga̱ atsij gu̱nun ni é re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Niꞌi ni é re̱ꞌ sisi̱ hua ni̱ꞌnaꞌ néꞌ, guiꞌyaj Yanꞌanj. Ni̱ sisi̱ hué daj huin, ni̱ nucuaj Yanꞌanj gui̱ꞌya sisi̱ hua si xa̱ néꞌ nej. Ni̱ guiꞌyaj Yanꞌanj nnee̱ cúꞌ. Ni̱ sisi̱ nucuaj Yanꞌanj guiꞌya nnee̱ cúꞌ, ni̱ ga̱ꞌue ri̱qui sisi̱ hua si-ganꞌ néꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","’Ni̱ꞌyaj ni é re̱ꞌ ni xaca̱. Nitaj si unu̱n xuj nna̱. Ni̱ nitaj si ri xuj nna̱ nej. Ni̱ nitaj si-gu̱ru xuj nej. Sani̱ aꞌuiꞌ Yanꞌanj si xa xuj. Ni̱ níꞌyanj doj ni é re̱ꞌ daj nga̱ ni xataj nej aj. ");
INSERT INTO trq_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ni̱ ga̱ꞌue ga̱huin xa̱can ni é re̱ꞌ doj xiꞌí si na̱ni ruhua ni é re̱ꞌ níꞌ. Si̱ gaꞌue mánj. ");
INSERT INTO trq_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Hué dan ni̱ sisi̱ si̱ gaꞌue gui̱ꞌyaj á re̱ꞌ nuguanꞌ le doj, ni̱ da̱j ga̱ꞌue gui̱ꞌyaj á re̱ꞌ nuguanꞌ nico doj, ruhua á re̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Ni̱ꞌyaj á re̱ꞌ da̱j achij yaj lirio. Nitaj si ꞌyaj sun yaj. Ni̱ nitaj si huaꞌa yaj yuꞌuej nej. Sani̱ atā gu̱nun ni é re̱ꞌ sisi̱ hua nia̱ꞌ ni̱nꞌ ruhua yaj daj, daj nga̱ tsínj gu̱ꞌnaj Salomón ngaa gunu̱n síꞌ atsij sa̱ꞌ ni̱nꞌ ruhua. ");
INSERT INTO trq_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ni̱ yya̱j ni̱ ma̱n coj riqui quij. Ni̱ aꞌyoj ga̱ri yanꞌa̱n ni sij coj daj. Ni̱ ga̱ca-áꞌ. Ni̱ sisi̱ Yanꞌanj ꞌyaj sisi̱ hua nia̱ꞌ ni coj, ni̱ huaj ni̱nꞌ ruhua riqui-íꞌ si-ganꞌ ni é re̱ꞌ nej. Sani̱ huin ni é re̱ꞌ ni tsínj xuman do̱j ruhua niꞌyaj Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","’Hué dan ni̱ si̱ gahuin ruhua á re̱ꞌ nga̱ si xa̱ á re̱ꞌ nga̱ si go̱ꞌo ni é re̱ꞌ mánj. Ni̱ si̱ guiriun ruhuá re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Daj si hué xiꞌí ni rasu̱n nan huin si nani ruhua ni ngüi̱ nitaj si xuman ruhua niꞌyaj Yanꞌanj. Sani̱ niꞌi chrej ni é re̱ꞌ u̱n rasu̱n achin rian án re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Sani̱ na̱noꞌ sini a ni é re̱ꞌ sisi̱ ni̱caj Yanꞌanj sun niman án re̱ꞌ. Hué dan ni̱ ri̱qui Yanꞌanj daranꞌ rasu̱n nan rian án re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Rúnꞌ huin ꞌngo̱ xiꞌninꞌ xachij dugumīj da̱j huin ni é re̱ꞌ. Yuꞌuj daj si̱ guxuꞌuiꞌ ni é re̱ꞌ mánj. Do̱j ni é re̱ꞌ huin, sani̱ hua ani ruhua chrej ni é re̱ꞌ ri̱quij rian nicaj sun-únꞌ ga̱ne ni é re̱ꞌ nga̱-áꞌ. ");
INSERT INTO trq_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","’Gu̱duꞌue ni é re̱ꞌ siꞌyaj ni é re̱ꞌ. Ni̱ ga̱ꞌuiꞌ ni é re̱ꞌ rian ni ngüi̱ yaco ranꞌ. Ngaa ni̱ ga̱ꞌue gui̱riꞌ a ni é re̱ꞌ ꞌngo̱ nnij sa̱ꞌ rian ga̱ra sa̱ꞌ á re̱ꞌ si-sanꞌanj ni é re̱ꞌ. Ni̱ nitaj si xutu̱ nnij da mánj. Ni̱ sanꞌanj daj huin sanꞌanj nara sa̱ꞌ ni é re̱ꞌ xataꞌ rian nitaj si síj tsínj tu̱. Ni̱ nitaj si na̱huij sanꞌanj da mánj. ");
INSERT INTO trq_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Daj si rian nara sa̱ꞌ ni é re̱ꞌ siꞌyaj ni é re̱ꞌ, ni̱ hué yuꞌuj daj na̱ni ruhua niman ni é re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Da̱j rúnꞌ nanun chru̱n ꞌngo̱ tsínj daj si-ganꞌ sij, ni̱ daꞌngaꞌ daj ga̱ chru̱n ni é re̱ꞌ nej. Ni̱ da̱j rúnꞌ arun ꞌngo̱ tsínj daj yanꞌa̱n chra̱ candil sisi̱ xigui̱n chrej huaj sij, ni̱ daꞌngaꞌ daj gui̱ꞌyaj á re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ga̱naꞌuij a ni é re̱ꞌ da̱j rúnꞌ ꞌyaj ni si-moso ꞌngo̱ tsínj xuruꞌue. Anaꞌuij ni sij si nu̱man síꞌ ganꞌanj síꞌ rian xacaj ꞌngo̱ tsínj yunꞌunj xa̱na. Ni̱ anaꞌuij ni moso daj sisi̱ na̱ꞌni yoo̱ ni sij rian hueꞌ ngaa gui̱ta raꞌa síꞌ na̱tu síꞌ chruhua hueꞌ. ");
INSERT INTO trq_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ni̱ hua ꞌueé rian ni moso daj ngaa nu̱n ruhua ni sij anaꞌuij ni sij ꞌna̱ꞌ niqui tsínj du̱cua daj. Xa̱ngaꞌ ataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ ga̱ne ni sij rian mesa gui̱ꞌyaj síꞌ. Ni̱ gui̱ꞌyaj sun síꞌ rian ni sij ga̱ꞌuiꞌ síꞌ si xa̱ ni sij. ");
INSERT INTO trq_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ni̱ hua ꞌueé rian ni moso daj sisi̱ nu̱n ruhua ni sij anaꞌuij sij mán ni sij si ya̱nꞌ sa̱ꞌ si guere̱ngaꞌ si ꞌna̱ꞌ niqui tsínj du̱cua daj. ");
INSERT INTO trq_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Gu̱nun sa̱ꞌ á re̱ꞌ nan. Sisi̱ gui̱niꞌi ꞌngo̱ tsínj ꞌdu̱cua daj u̱n hora ga̱ꞌnaꞌ ꞌngo̱ tsínj tu̱, ni̱ du̱gumi sa̱ꞌ sij ducuá sij. Ni̱ si̱ gaꞌnij sij na̱ꞌni síꞌ ga̱tu síꞌ ducuá sij, gui̱ꞌyaj tu̱ síꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ni̱ daꞌngaꞌ daj gui̱ꞌyaj a ni é re̱ꞌ ga̱ chru̱n gui̱man án re̱ꞌ. Daj si ga̱ꞌnaꞌ manꞌānj hué gue̱ hora nitaj si ani ruhuá re̱ꞌ huīnj daꞌníj ni ngüi̱. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ngaa ni̱ nachínj snanꞌanj Pedro Jesús. Ni̱ gataj sij: ―Señor, naní re̱ꞌ cuento nan urin rian ni únj níꞌ. Asi̱ rian daranꞌ ni ngüi̱ sa̱ꞌ. ―Daj gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ngaa ni̱ gataj Señor: ―Ni̱ hua ꞌngo̱ tsínj nicaj yunꞌunj moso. Ni̱ dugumi sij ni moso daj, guiꞌyaj xuruꞌue. Ni̱ aꞌuiꞌ sa̱ꞌ sij si xa ni síꞌ ngaa ruhua gui̱sij hora xa ni síꞌ. Ni̱ sisi̱ da̱gahuin sa̱ꞌ tsínj daj si-sun sij, ni̱ da̱j gui̱ꞌyaj xuruꞌue daj nga̱ sij, ruhua á re̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ni̱ ga̱ ꞌueé rian tsínj nicaj yunꞌunj moso daj sisi̱ hua ga̱cuij sij ngaa ꞌna̱ꞌ niqui xuruꞌue na̱riꞌ síꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ gui̱nicaj tsínj daj sun du̱gumi sij daranꞌ siꞌyaj xuruꞌue daj, gui̱ꞌyaj síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Sani̱ sisi̱ ga̱ni ruhua tsínj nicaj yunꞌunj moso daj sisi̱ ga̱huin ran ꞌna̱ꞌ niqui si-xu̱ruꞌue sij, ni̱ gaxi̱ꞌi sij ga̱ꞌuiꞌ sij ni tsínj nga̱ ni yunꞌunj xa̱na dugumi sij, ni̱ gaxi̱ꞌi sij xa na̱saꞌ sij, ni̱ goꞌo na̱saꞌ sij da̱ꞌ gaxini sij. ");
INSERT INTO trq_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ni̱ xiꞌí si nun anaꞌuij sij ga̱ꞌnaꞌ si-xu̱ruꞌue sij, ni̱ ga̱ꞌnaꞌ síꞌ hué gue̱ hora nitaj si ani ruhua sij si ga̱ꞌnaꞌ síꞌ. Ni̱ ducu gui̱ꞌyaj síꞌ castigo sij. Ni̱ gui̱ranꞌ sij sayun da̱j rúnꞌ gui̱ranꞌ ni tsínj nitaj si ꞌyaj ga̱cuij, gui̱ꞌyaj síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Ni̱ hua tsínj nicaj yunꞌunj niꞌi si huin ruhua si-xu̱ruꞌue sij gui̱ꞌyaj sij. Sani̱ nun gui̱ꞌyaj sij. Ni̱ nitaj hua xugüi ꞌyaj sij ga̱ꞌnaꞌ síꞌ. Yuꞌuj daj ni̱ ducu du̱guayun síꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Sani̱ hua ango tsínj nicaj yunꞌunj. Ni̱ nun niꞌi sij si huin ruhua si-xu̱ruꞌue sij gui̱ꞌyaj sij. Ni̱ sisi̱ gui̱ꞌyaj sij rasu̱n nun ga̱ꞌuej ruhua si-xu̱ruꞌue sij gui̱ꞌyaj sij, sani̱ do̱j ga̱yun sij, gui̱ꞌyaj síꞌ xiꞌí si nun niꞌi sij. ’Ni̱ sisi̱ aꞌuiꞌ nico Yanꞌanj rian ꞌngo̱ tsínj daj, ni̱ huin ruhua Yanꞌanj sisi̱ gui̱ꞌyaj ꞌueé sij nga̱ si gaꞌuiꞌ-íꞌ rian sij. Tsínj nicaj sun nico dugumi sij siꞌyaj Yanꞌanj, ni̱ na̱chinꞌ Yanꞌanj cuenta rian sij sisi̱ du̱gumi sa̱ꞌ ꞌueé sij siꞌyaj síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Yūnj ꞌna̱ꞌ ga̱rūn yanꞌa̱n chruhua xungüi̱ nan. Ni̱ ducu huin ruhuāj sisi̱ hua aca yanꞌa̱n daj. ");
INSERT INTO trq_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Hua nia̱n si gui̱ranꞌānj ꞌngo̱ sayun nico. Ni̱ ducu ani guitsi ruhua nimānj da gui̱sij gui̱ranꞌānj sayun daj. ");
INSERT INTO trq_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Gani ruhua á re̱ꞌ sisi̱ ga̱ dinꞌinj rian ni ngüi̱ ngaa gaꞌnāj chruhua xungüi̱, ruhua á re̱ꞌ níꞌ. Sé daj huin mánj. Sani̱ atā gu̱nun a ni é re̱ꞌ sisi̱ gu̱nunꞌ ni tsínj nga̱ dugüiꞌ ni sij, gui̱ꞌyaj si-nu̱guanꞌānj. ");
INSERT INTO trq_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ni̱ asi̱j yya̱j ni̱ gu̱nunꞌ u̱nꞌunꞌ ranꞌ ni du̱güiꞌ ꞌngo̱ tsínj daj. Ni̱ gu̱nunꞌ hua̱ꞌnij ranꞌ tsínj nga̱ yahuij ranꞌ tsínj. Ni̱ gu̱nunꞌ hui̱j ranꞌ tsínj nga̱ yaꞌnij ranꞌ tsínj. ");
INSERT INTO trq_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ni̱ xiꞌí si-nu̱guanꞌānj, ni̱ gu̱nunꞌ nu̱ngüej chrej tsínj daj. Ni̱ gu̱nunꞌ nu̱ngüej daꞌníj síꞌ nej. Ni̱ gu̱nunꞌ nu̱ngüej nni yunꞌunj xa̱na daj. Ni̱ gu̱nunꞌ nu̱ngüej daꞌníj unj nej. Ni̱ gu̱nunꞌ nu̱ngüej nni chre̱j ꞌngo̱ yunꞌunj xa̱na daj. Ni̱ gu̱nunꞌ nu̱ngüej xacoꞌ unj nej. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ngaa ni̱ gataj Jesús gunun ni ngüi̱: ―Niꞌi sa̱ꞌ á re̱ꞌ da̱j xacaj ni é re̱ꞌ cuenta. Daj si ngaa guiniꞌi a ni é re̱ꞌ sisi̱ nasíj nga rian atuj güi, ni̱ ataj á re̱ꞌ sisi̱ do̱j, ni̱ ga̱manꞌ. Ni̱ daꞌngaꞌ daj amanꞌ yya. ");
INSERT INTO trq_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ni̱ ngaa ahui nane̱ ne̱ꞌ sur, ni̱ ataj á re̱ꞌ sisi̱ do̱j, ni̱ ga̱huin ya̱nꞌan. Ni̱ daꞌngaꞌ daj ga̱huin ya̱nꞌan. ");
INSERT INTO trq_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tsínj digyaꞌ yunꞌunj huin a ni é re̱ꞌ. Sa̱ꞌ á re̱ꞌ ruhua á re̱ꞌ, sani̱ ani quij ruhua á re̱ꞌ. Niꞌi a ni é re̱ꞌ xa̱caj á re̱ꞌ cuenta da̱j hua xataꞌ nga̱ da̱j hua rian yoꞌój. Sani̱ nun niꞌi a ni é re̱ꞌ da̱j ꞌyaj Yanꞌanj scanij a ni é re̱ꞌ yya̱j mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ni̱ gataj Jesús: ―Ni̱ u̱n sin huin ni̱ naꞌue xa̱caj a ni é re̱ꞌ cuenta u̱n nuguanꞌ hua ni̱ca yya únj. ");
INSERT INTO trq_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ni̱ sisi̱ hua ꞌngo̱ tsínj ununꞌ nga̱ so̱ꞌ, ni̱ nicaj sij so̱ꞌ ga̱nꞌanj sij ducuasun, sani̱ hué gue̱ chruhua chrej ngaa diaj huaj nu̱ngüej é re̱ꞌ daj, ni̱ hué yuꞌuj daj na̱guiꞌyaj yya nu̱ngüej é re̱ꞌ xiꞌí nuguanꞌ ununꞌ nu̱ngüej é re̱ꞌ. Ni̱ sisi̱ si̱ guiꞌyaj yya nu̱ngüej é re̱ꞌ, ngaa ni̱ ni̱caj síꞌ manꞌán re̱ꞌ rian güesi̱. Ni̱ na̱gaꞌuiꞌ güesi̱ manꞌán re̱ꞌ rian caíde. Ni̱ ga̱ri caíde manꞌán re̱ꞌ ducuaga̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ni̱ ataj snanꞌān gu̱nun re̱ꞌ sisi̱ nitaj si huaj ga̱hui re̱ꞌ yuꞌuj daj da gui̱sij ga̱nahuij na̱ruꞌue re̱ꞌ daranꞌ gaquinꞌ guiꞌyáj re̱ꞌ, da ni̱ ga̱hui re̱ꞌ aj. ―Daj gataj Jesús gunun ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ni̱ hué güi daj ni̱ niquinꞌ ꞌngo̱ ni tsínj rian nne Jesús. Ni̱ nataꞌ ni síꞌ da̱j guiranꞌ go̱ꞌngo ni tsínj ꞌna̱ꞌ estado Galilea rian Jesús. Daj si dagahuiꞌ tsínj gu̱ꞌnaj Pilato. Ni̱ nachej Pilato si-tun manꞌan ni tsínj daj nga̱ si-tun ni xucu dagahuiꞌ ni sij gaꞌuiꞌ ni sij rian Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ngaa ni̱ gataj Jesús rian ni tsínj niquinꞌ daj: ―Xiꞌí si daꞌngaꞌ daj guiranꞌ ni tsínj daj, ni̱ daꞌui ni sij doj gaquinꞌ daj nga̱ ango ni ngüi̱ nne estado Galilea, ruhua ni é re̱ꞌ níꞌ. ");
INSERT INTO trq_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Sé daj huin mánj. Ni̱ atā gu̱nun a ni é re̱ꞌ sisi̱ nitaj si na̱nicaj ruhua ni é re̱ꞌ na̱nicoꞌ a ni é re̱ꞌ Yanꞌanj, ni̱ daꞌngaꞌ daj gui̱ranꞌ a ni é re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","’Ni̱ hua gunun ni é re̱ꞌ sisi̱ gahuiꞌ xi̱nunꞌ hua̱ꞌnij ranꞌ ni ngüi̱ ngaa gane ꞌngo̱ hueꞌ xxi xa̱can gataj xiráj ni ngüi̱ daj xumanꞌ Siloé. Ni̱ daꞌui ni sij doj gaquinꞌ daj nga̱ ni ngüi̱ ma̱n xumanꞌ Jerusalén, ruhua á re̱ꞌ níꞌ. ");
INSERT INTO trq_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Sé daj huin mánj. Ni̱ atā gu̱nun a ni é re̱ꞌ sisi̱ nitaj si na̱nicaj ruhua á re̱ꞌ na̱nicoꞌ a ni é re̱ꞌ Yanꞌanj, ni̱ daꞌngaꞌ daj gui̱ranꞌ a ni é re̱ꞌ nej. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ngaa ni̱ nani Jesús ꞌngo̱ cuento digyán sij rian ni ngüi̱. Ni̱ gataj sij: ―Nicaj ꞌngo̱ tsínj daj ꞌngo̱ chrun ayu higo mán riqui doꞌój sij rian ma̱n coj uva. Ni̱ ganꞌanj ni̱ꞌyaj sij sisi̱ ayu higo chra̱-áꞌ. Sani̱ a̱ ꞌngo̱-óꞌ nun guiriꞌ sij mánj. ");
INSERT INTO trq_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ngaa ni̱ gataj sij gunun tsínj dugumi coj uva daj: “Ni̱ꞌyaj re̱ꞌ síj hua̱ꞌnij yoꞌ ꞌnāj ꞌna̱ꞌ naꞌuīj chruj higo, sani̱ a̱ ꞌngo̱ nun guirīj mánj. Ga̱ꞌninꞌ náj re̱ꞌ si ꞌyaj chru niquinj rian doꞌój aj.” Daj gataj sij gunun síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Sani̱ gataj tsínj dugumi yoꞌój daj: “Señor, du̱náj acuánꞌ re̱ꞌ si gui̱niquinꞌ acuanj ango yoꞌ nan. Ni̱ na̱chē yoꞌój, ngaa ni̱ ga̱rāj yoꞌój yaꞌnduj xiꞌij aj. ");
INSERT INTO trq_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ni̱ sisi̱ gui̱niquinj ga̱yu higo chraj, ni̱ duguꞌna̱j huaj. Ni̱ sisi̱ nitaj ga̱yu chraj, ni̱ ga̱ꞌninꞌ náj re̱ꞌ nánj.” Daj gataj moso daj gunun tsínj do̱ꞌoj. ―Daj gataj Jesús digyán sij rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Hué dan ni̱ ꞌngo̱ güi naránj ruhua ni ngüi̱ israelita, ni̱ digyán Jesús rian ni ngüi̱ ma̱n chruhua si-nuhui ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ni̱ nne ꞌngo̱ yunꞌunj xa̱na aꞌnanꞌ, guiꞌyaj ꞌngo̱ nane̱ xi̱ꞌi. Ni̱ guisíj xi̱nunꞌ hua̱ꞌnij yoꞌ achéj nitu únꞌ, ꞌyaj nane̱ xi̱ꞌi daj. Ni̱ naꞌue nu̱cua xiráj únꞌ ga̱che únꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ni̱ ngaa guiniꞌi Jesús yunꞌunj daj, ni̱ gaquínj sij únꞌ. Ni̱ gataj sij: ―Guisíj nahuín re̱ꞌ, ꞌyaj xiꞌi̱ aꞌnánꞌ re̱ꞌ yya̱j, xicaꞌuīj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ngaa ni̱ gutaꞌ Jesús raꞌa sij rian únꞌ. Ni̱ ꞌngo̱ hora daj, ni̱ nahuin ni̱ca xiráj únꞌ. Ni̱ gaxi̱ꞌi únꞌ gaꞌmi sa̱ꞌ únꞌ rian Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sani̱ gaꞌman ruhua tsínj aꞌninꞌ chruhua nuhui xiꞌí si nahuin yunꞌunj xa̱na daj ꞌngo̱ güi naránj ruhua ni sij, guiꞌyaj Jesús. Ni̱ gataj tsínj daj gunun ni ngüi̱: ―Hua hua̱tanꞌ güi gui̱ꞌyaj sun néꞌ go̱ꞌngo semana. Ngaa ni̱ ga̱ꞌnaꞌ á re̱ꞌ ni güi daj na̱huin a ni é re̱ꞌ. Ni̱ sé güi naránj ruhua néꞌ ga̱ꞌnaꞌ ni é re̱ꞌ na̱huin a ni é re̱ꞌ mánj. ―Daj gataj tsínj aꞌninꞌ daj. ");
INSERT INTO trq_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ngaa ni̱ gataj Señor Jesús: ―Sa̱ꞌ á re̱ꞌ, ruhua á re̱ꞌ. Sani̱ ani quij ruhua á re̱ꞌ. Tsínj digyaꞌ yunꞌunj huin a ni é re̱ꞌ. Nitaj si na̱chi go̱ꞌngo ni é re̱ꞌ dán re̱ꞌ sicuj nga̱ dán re̱ꞌ urruj yuꞌuj numi xuj ga̱nꞌanj do̱goꞌo a ni é re̱ꞌ nnee xuj güi naránj ruhua á re̱ꞌ míꞌ. ");
INSERT INTO trq_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ni̱ yunꞌunj xa̱na nan huin daꞌníj xíꞌ gu̱ꞌnaj Abraham. Ni̱ síj xi̱nunꞌ hua̱ꞌnij yoꞌ numij sichre Satanás únꞌ. Ni̱ nu̱nj si güi naránj ruhua néꞌ huin güi yya̱j, sani̱ daꞌui néꞌ jna̱chri néꞌ manꞌan únꞌ raꞌa sichre Satanás. ―Daj gataj Jesús gunun tsínj aꞌninꞌ daj. ");
INSERT INTO trq_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ni̱ ngaa guisíj gaꞌmi sij daj, ni̱ gahuin na̱ꞌaj ni tsínj ununꞌ nga̱ sij. Sani̱ gahuin nia̱ꞌ ruhua daranꞌ ni ngüi̱ ngaa guiniꞌi ni sij ni si sa̱ꞌ ꞌna̱ꞌ xataꞌ, guiꞌyaj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ngaa ni̱ gataj Jesús: ―Da̱j hua rian nicaj sun Yanꞌanj, ruhua á re̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Hué dan ni̱ da̱j rúnꞌ achij ca̱n cuej nasa huaj. Ni̱ dagamanꞌ ꞌngo̱ tsínj daj riqui yoꞌój. Ni̱ xi̱raꞌ ca̱n daj. Ni̱ ga̱chi ga̱huin ꞌngo̱ chrun. Ni̱ ꞌna̱ꞌ ni xataj chéj xataꞌ gui̱ꞌyaj xúꞌ si-ga̱caꞌ xúꞌ chra̱ coj daj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús: ―Da̱j hua rian nicaj sun Yanꞌanj, ruhua á re̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Hué dan ni̱ da̱j rúnꞌ levadura huaj. Ni̱ nachéj hui̱ ꞌngo̱ yunꞌunj xa̱na levadura daj scanij chru harina si na̱chej-éꞌ, gui̱ꞌyaj unj chrachrúnj. Ni̱ gari unj quinj daj chruhua hua̱ꞌnij rio̱. Ngaa ni̱ nara nane̱ riqui quinj daj, ꞌyaj levadura. Ni̱ da̱j rúnꞌ ꞌyaj levadura daj, daꞌngaꞌ daj gaxaꞌni̱ si-nu̱guanꞌ Yanꞌanj ni̱nꞌ ga̱chraꞌ xungüi̱ nej. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ni̱ gachin Jesús ni xumanꞌ nico nga̱ ni rancho ngaa huaj sij ganꞌanj sij xumanꞌ Jerusalén. Ni̱ digyán sij si-nu̱guanꞌ sij rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ni̱ nachínj snanꞌanj ꞌngo̱ tsínj daj Jesús. Ni̱ gataj sij: ―Ni̱ do̱j ni ngüi̱ ga̱ꞌue gui̱nani, gui̱ꞌyaj Yanꞌanj níꞌ. ―Daj gataj sij. Ngaa ni̱ gataj Jesús: ");
INSERT INTO trq_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Gui̱ꞌyaj fuerza á re̱ꞌ ga̱tu a ni é re̱ꞌ rian hueꞌ chruj huin rian nicaj sun Yanꞌanj. Ataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ ga̱huin nico ni ngüi̱ ga̱huin ruhua ga̱tu yuꞌuj daj. Sani̱ si̱ gaꞌue ga̱tu ni sij mánj. ");
INSERT INTO trq_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ngaa guisíj naxu̱man tsínj du̱cua naránj sij rian ducuá sij, ni̱ gaxi̱ꞌi ni é re̱ꞌ ga̱quinj ni é re̱ꞌ mán xe̱ꞌ. Ni̱ ga̱taj ni é re̱ꞌ gu̱nun sij: “Señor, na̱ꞌni re̱ꞌ ga̱tu ni únj.” Ga̱taj á re̱ꞌ. Sani̱ ga̱taj tsínj du̱cua daj gu̱nun a ni é re̱ꞌ: “Nun niꞌīnj ni̱ a̱ ꞌna̱ꞌ ni é re̱ꞌ mánj.” Daj ga̱taj Señor daj huin manꞌānj. ");
INSERT INTO trq_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ngaa ni̱ ga̱xiꞌi ni é re̱ꞌ ga̱taj á re̱ꞌ gu̱nūnj: “Xa ni únj, goꞌo ni únj nga̱ manꞌán re̱ꞌ. Ni̱ digyán re̱ꞌ nuguanꞌ gaꞌmí re̱ꞌ rian ni únj rian yuꞌue̱.” Ga̱taj á re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Sani̱ ga̱taj manꞌānj rian án re̱ꞌ: “Nun niꞌīnj ni̱ a̱ ꞌna̱ꞌ ni é re̱ꞌ. Gu̱xun anéj daranꞌ ni é re̱ꞌ riānj si huin ni é re̱ꞌ tsínj ꞌyaj gaquinꞌ.” Daj ga̱tā gu̱nun a ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","’Ni̱ yuꞌuj daj gui̱man ni é re̱ꞌ. Ni̱ ducu ga̱co ni ngüi̱ ma̱n yuꞌuj daj. Ni̱ da xa̱ ruj yanꞌ ni ngüi̱ nej. Ni̱ gui̱niꞌi ni é re̱ꞌ ni xi a ni é re̱ꞌ tsínj gu̱ꞌnaj Abraham nej, tsínj gu̱ꞌnaj Isaac nga̱ tsínj gu̱ꞌnaj Jacob nej, daranꞌ ango ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj. Ni̱ gui̱niꞌi ni é re̱ꞌ sisi̱ nne ni síꞌ rian nicaj sun Yanꞌanj. Sani̱ guiri Yanꞌanj ne̱ꞌ xe̱ꞌ gui̱man ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ni̱ ga̱ꞌnaꞌ ni ngüi̱ mán ne̱ꞌ síj güi nga̱ ni ngüi̱ mán ne̱ꞌ rian atuj güi nej, ni ngüi̱ mán ne̱ꞌ norte nej, nga̱ ni ngüi̱ mán ne̱ꞌ sur nej. Ni̱ ga̱ne ni ngüi̱ daj xa̱ ni sij rian mesa rian nicaj sun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ni̱ hua ni ngüi̱ nun gahuin achij xungüi̱ nan. Ni̱ hué ni sij ga̱huin achij ango xungüi̱ ga̱nahuin na̱ca. Ni̱ hua ni ngüi̱ gahuin achij xungüi̱ nan. Ni̱ hué ni sij ni̱coꞌ ne̱ꞌ ru̱cu ango xungüi̱ ga̱nahuin na̱ca daj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ni̱ güi daj guisíj go̱ꞌngo ni tsínj fariseo rian nne Jesús. Ni̱ gataj ni síꞌ gunun sij: ―Hué yuꞌuj nan gu̱xun re̱ꞌ manꞌán re̱ꞌ si huin ruhua rey Herodes da̱gahuiꞌ so̱ꞌ aj. ―Daj gataj ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ngaa ni̱ gataj Jesús: ―Güi̱j ni̱ ga̱taj á re̱ꞌ gu̱nun xune daj: “Ni̱ꞌyaj re̱ꞌ, yya̱j nga̱ aꞌyoj rīj nane̱ xi̱ꞌi chruhua niman ni ngüi̱. Ni̱ nahuin ni ngüi̱ aꞌnanꞌ, ꞌyā nej. Ni̱ xiráj hua̱ꞌnij güi, ni̱ na̱huij si-sūnj, gui̱ꞌyā.” ");
INSERT INTO trq_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Sani̱ hua nia̱n si ga̱huī ga̱nꞌān yya̱j nga̱ aꞌyoj nga̱ ataj nej si nitaj si huaj ga̱huiꞌ ꞌngo̱ tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj ne̱ꞌ xe̱ꞌ xumanꞌ Jerusalén mánj. ");
INSERT INTO trq_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Ducu nani ruhuāj xiꞌí a ni é re̱ꞌ ni tsínj ma̱n xumanꞌ Jerusalén. Daj si gahuiꞌ ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj, guiꞌyaj á re̱ꞌ. Ni̱ aꞌuiꞌ ni é re̱ꞌ yej ni tsínj nicaj nuguanꞌ huaj gaꞌníj Yanꞌanj rian án re̱ꞌ. Síj u̱ndaj huin ruhuāj na̱guiꞌyaj yu̱ꞌūj ni é re̱ꞌ du̱gumīj ni é re̱ꞌ. Ni̱ da̱j rúnꞌ ꞌyaj ꞌngo̱ xuchre naguiꞌyaj yuꞌuj xuj daꞌníj xuj riqui si-gachi xuj, ni̱ daꞌngaꞌ daj ruhuāj gui̱ꞌyā nga̱ á re̱ꞌ. Sani̱ nun ga̱ꞌuej ruhua á re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ni̱ꞌyaj á re̱ꞌ. Daj si gue̱reꞌ xánj án re̱ꞌ nga̱ ducuá á re̱ꞌ. Ni̱ ataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ si̱ guiniꞌi ru̱huaꞌ yún ni é re̱ꞌ yūnj da gui̱sij ga̱ꞌnaꞌ ru̱huaꞌ yūnj chruhua xungüi̱ nan. Ni̱ ga̱taj ni é re̱ꞌ: “Hua ꞌueé tsínj ꞌna̱ꞌ rian si-xugüi Señor.” Ga̱taj ni é re̱ꞌ aj. ―Daj gataj Jesús gunun ni tsínj ma̱n xumanꞌ Jerusalén. ");
INSERT INTO trq_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Hué dan ni̱ ꞌngo̱ güi naránj ruhua ni sij, ni̱ gatúj Jesús chruhua ducuá ꞌngo̱ tsínj fariseo aꞌninꞌ. Ni̱ xa síꞌ nga̱ ni sij. Ni̱ nagaꞌna̱ꞌ ango ni tsínj fariseo Jesús si gui̱ꞌyaj síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ni̱ nne ꞌngo̱ tsínj ꞌni̱j guꞌma̱n rian Jesús. ");
INSERT INTO trq_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ni̱ nachínj snanꞌanj Jesús ni tsínj digyán ley nga̱ ni tsínj fariseo. Ni̱ gataj sij: ―Aꞌuej si-ley Yanꞌanj sisi̱ na̱huin ni ngüi̱ aꞌnanꞌ, gui̱ꞌyaj néꞌ güi naránj ruhua néꞌ, ruhua á re̱ꞌ níꞌ. ―Daj gataj Jesús. Sani̱ dínj gahuin duꞌua ni sij. ");
INSERT INTO trq_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ngaa ni̱ guidaꞌa Jesús tsínj daj. Ni̱ nahuin síꞌ, guiꞌyaj sij. Ni̱ naꞌníj sij na̱nꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ngaa ni̱ gataj sij gunun ni tsínj fariseo: ―Sisi̱ gui̱nij ꞌngo̱ dán án re̱ꞌ urruj, asi̱ ꞌngo̱ dán án re̱ꞌ sicuj gui̱nij chruhua pozo nnee nu̱nj huin si güi naránj ruhua néꞌ, ni̱ si̱ ganꞌanj gui̱ri yoo̱ ni é re̱ꞌ xucu guinij chruhua nnee da ga̱ míꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ni̱ nun ga̱ꞌue danica̱j ni sij nuguanꞌ rian Jesús ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ni̱ ngaa guiniꞌi Jesús da̱j nanoꞌ ni tsínj ꞌna̱ꞌ ducuá tsínj fariseo daj chrun xila niquinꞌ ne̱ꞌ rian ga̱ne ni sij rian mesa, ngaa ni̱ nani sij ꞌngo̱ cuento digyán sij rian ni síꞌ. Ni̱ gataj sij: ");
INSERT INTO trq_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Ngaa ga̱quinj ꞌngo̱ tsínj daj ga̱nꞌanj re̱ꞌ rian ga̱huin ꞌngo̱ guiꞌyanj na̱raꞌa ne, ni̱ si̱ gané re̱ꞌ chrun xila niquinꞌ ne̱ꞌ chrej rian mánj. Ga̱ꞌue si gui̱sij ango tsínj huin achij doj daj nga̱ manꞌán re̱ꞌ ga̱ aj. ");
INSERT INTO trq_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ni̱ ga̱ꞌue si ga̱ꞌnaꞌ tsínj ga̱quinj nu̱ngüej é re̱ꞌ, ni̱ ga̱taj síꞌ gu̱nun re̱ꞌ: “Ga̱ꞌuiꞌ re̱ꞌ chrun xila nan ga̱ne tsínj nan anj.” Ga̱taj síꞌ si ruhuaj. Ngaa ni̱ ga̱huin na̱ꞌaj re̱ꞌ, ni̱ ga̱nꞌanj ga̱né re̱ꞌ chrun xila niquinꞌ da ru̱cu. ");
INSERT INTO trq_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Hué dan ni̱ ngaa gaquínj sij ga̱ꞌnaꞌ re̱ꞌ, ni̱ ga̱né re̱ꞌ da ru̱cu. Hué dan ni̱ ngaa ga̱ꞌnaꞌ tsínj ga̱quinj re̱ꞌ, ni̱ ga̱taj sij gu̱nún re̱ꞌ: “Amigo, ga̱chin ga̱né re̱ꞌ chrun xila niquinꞌ ne̱ꞌ rian.” Ga̱taj sij. Ngaa ni̱ ga̱huin ꞌueé re̱ꞌ rian ni tsínj nne rian mesa nga̱ re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Daj si u̱n tsínj huin ruhua ga̱huin rian, ni̱ gu̱na sij da ne̱ꞌ ru̱cu. Sani̱ u̱n tsínj ga̱ꞌuej ruhua gu̱na da ne̱ꞌ ru̱cu, ni̱ ga̱huin rian sij. ―Daj gataj Jesús gunun ni tsínj ma̱n ducuá tsínj fariseo daj. ");
INSERT INTO trq_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ngaa ni̱ gataj Jesús gunun tsínj gaquínj ga̱ꞌnaꞌ sij ducuá síꞌ: ―Ngaa gui̱ꞌyáj re̱ꞌ ꞌngo̱ nún ducuá re̱ꞌ, ni̱ ga̱ꞌuiꞌ re̱ꞌ xa̱ ni ngüi̱, ni̱ si̱ gaquínj re̱ꞌ ga̱ꞌnaꞌ ni tsínj nicaj dugüiꞌ nga̱ re̱ꞌ nga̱ ni jnánj re̱ꞌ nej, ni tsínj xuruꞌue mán riqui xumanꞌ nej. Daj si ga̱ꞌue ga̱quinj ni sij manꞌán re̱ꞌ xa̱ re̱ꞌ nga̱ ni sij. Ni̱ daꞌngaꞌ daj na̱ruꞌue ni sij rián re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sani̱ ngaa gui̱ꞌyáj re̱ꞌ ꞌngo̱ guiꞌyanj ducuá re̱ꞌ, ni̱ ga̱quinj re̱ꞌ ga̱ꞌnaꞌ ni ngüi̱ niqui nga̱ ni ngüi̱ nachranꞌ raꞌa nej, ni ngüi̱ yacuan nej, ni ngüi̱ duri nej. ");
INSERT INTO trq_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ngaa ni̱ ga̱ ꞌueé rián re̱ꞌ. Daj si si̱ gaꞌue na̱ruꞌue ni ngüi̱ daj rián re̱ꞌ. Sani̱ na̱ruꞌue sa̱ꞌ Yanꞌanj rián re̱ꞌ ngaa ga̱naꞌnij ni níman huin ni sij ni ngüi̱ hua ni̱ca niman. ―Daj gataj Jesús gunun tsínj gaquínj daj. ");
INSERT INTO trq_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ni̱ ngaa gunun ꞌngo̱ ni tsínj nne nga̱ Jesús rian mesa, ni̱ gataj síꞌ gunun Jesús: ―Hua ꞌueé rian tsínj ga̱nꞌanj nún rian nicaj sun Yanꞌanj. ―Daj gataj síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ngaa ni̱ gataj Jesús gunun síꞌ: ―Ni̱ guiꞌyaj ꞌngo̱ xuruꞌue ꞌngo̱ nún nico ducuá sij. Ni̱ gaquínj sij ga̱ꞌnaꞌ nico ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ni̱ ngaa síj gahuin chru̱n si xa̱ ni ngüi̱, ꞌyaj sij, ni̱ gaꞌníj sij ꞌngo̱ moso ga̱nꞌanj ga̱taj síꞌ rian ni ngüi̱ daj: “Ga̱ꞌnaꞌ a ni é re̱ꞌ si a̱ hua chru̱n si xa̱ á re̱ꞌ.” Daj gataj moso daj gunun ni ngüi̱, guiꞌyaj xuruꞌue. ");
INSERT INTO trq_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Sani̱ gaxi̱ꞌi ni sij gataj ni sij rian moso daj sisi̱ si̱ gaꞌue gui̱sij ni sij xa̱ ni sij. Ni̱ gataj ꞌngo̱ tsínj daj: “Guirān ꞌngo̱ yoꞌój, ni̱ hua nia̱n si ga̱nꞌanj niꞌyā. Achínj jniꞌyā rián re̱ꞌ si gui̱nicaj re̱ꞌ ꞌngo̱ niman nico ngāj si si̱ gaꞌue ga̱nꞌān nga̱ re̱ꞌ mánj.” Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ni̱ gataj ango sij: “Guirān u̱nꞌunꞌ inta sicúj, ni̱ ga̱nꞌanj xa̱cāj cuenta sisi̱ a̱ hua xuj gui̱ꞌyaj sun xuj. Ni̱ gui̱nicaj re̱ꞌ ꞌngo̱ niman nico ngāj xiꞌí si nun ga̱ꞌue ga̱nꞌān nga̱ re̱ꞌ mánj.” Daj gataj síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ni̱ gataj ango sij: “Da guisíj xacā ꞌngo̱ yunꞌunj xa̱na, ni̱ si̱ gaꞌue ga̱nꞌān mánj.” Daj gataj hua̱ꞌnij ranꞌ tsínj gunun moso daj. ");
INSERT INTO trq_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","’Ngaa ni̱ nanica̱j si-moso tsínj du̱cua daj. Ni̱ nataꞌ sij nuguanꞌ gaꞌmi go̱ꞌngo ni síꞌ gunun xuruꞌue daj. Hué dan ni̱ gaꞌman ruhua xuruꞌue daj. Ni̱ gataj sij gunun moso: “Ga̱nꞌanj yoo̱ re̱ꞌ rian yuꞌue̱ nga̱ chruhua chrej ma̱n riqui xumanꞌ nan. Ni̱ ni̱caj re̱ꞌ ni ngüi̱ niqui nga̱ ni ngüi̱ nachranꞌ raꞌa nej, ni ngüi̱ yacuan nej, ni ngüi̱ duri nej ga̱ꞌnaꞌ re̱ꞌ.” Daj gataj xuruꞌue daj gunun moso. ");
INSERT INTO trq_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ngaa ni̱ gataj moso daj gunun xuruꞌue: “Señor, hua síj guiꞌyā si gaꞌníj re̱ꞌ yūnj. Sani̱ hua luga ga̱ꞌ aj.” Daj gataj moso daj. ");
INSERT INTO trq_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ngaa ni̱ gataj xuruꞌue daj gunun moso: “Güi̱j re̱ꞌ chruhua chrej ga̱nꞌan nga̱ chrej gatin nej. Ni̱ gui̱ꞌyaj fuerzá re̱ꞌ si ga̱ꞌnaꞌ ni ngüi̱ ga̱tu ni sij chruhua ducuāj ga̱ra gui̱man ni sij. ");
INSERT INTO trq_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Daj si xa̱ngaꞌ atā gu̱nun re̱ꞌ sisi̱ si̱ gahuin stiꞌnīj nga̱ ni̱ a̱ ꞌngo̱ ni ngüi̱ gaquínj sinīj mánj.” Gataj xuruꞌue daj gunun si-moso sij. ―Daj gataj Jesús gunun tsínj nne rian mesa nga̱ sij. ");
INSERT INTO trq_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ni̱ huaj nico ni ngüi̱ nga̱ Jesús. Ni̱ nanica̱j sij gataj sij gunun ni síꞌ: ");
INSERT INTO trq_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Sisi̱ hua ꞌngo̱ tsínj daj huin ruhua ga̱ꞌnaꞌ riānj, ni̱ hua nia̱n si ga̱huin ꞌi̱ ruhua sij niꞌyaj sij yūnj daj nga̱ si ꞌi̱ ruhua sij niꞌyaj sij chrej sij nga̱ nni sij nej, manꞌan sij nej. Ni̱ sisi̱ naꞌuej ruhua sij daj, ni̱ si̱ gaꞌue ga̱huin sij tsínj gui̱nicoꞌ manꞌānj mánj. ");
INSERT INTO trq_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ni̱ sisi̱ naꞌuej ruhua ꞌngo̱ tsínj daj ga̱ta sij rugutsi̱ gui̱ranꞌ sij sayun ngāj, ni̱ si̱ gaꞌue ga̱huin sij tsínj gui̱nicoꞌ manꞌānj mánj. ");
INSERT INTO trq_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","’Ni̱ sisi̱ huin ruhua ꞌngo̱ ni é re̱ꞌ gui̱ꞌyaj ꞌngo̱ hueꞌ xxi nataꞌ, ni̱ na̱ni sini ruhua tsínj daj ni̱ꞌyaj sij u̱ndaj gu̱tinꞌ sij duꞌue hueꞌ daj. Ngaa ni̱ xa̱caj sij cuenta sisi̱ gui̱sij si-sanꞌanj sij. ");
INSERT INTO trq_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ni̱ sisi̱ nitaj si nani sini ruhua sij, hué dan ni̱ ngaa gu̱ruj sij daqui hueꞌ, ni̱ na̱ꞌue gui̱si-íꞌ, gui̱ꞌyaj sij. Ni̱ ga̱xiꞌi ni ngüi̱ ga̱ꞌmi ducu ni sij xiꞌí sij. ");
INSERT INTO trq_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ni̱ ga̱taj ni sij: “Gaxi̱ꞌi tsínj nan guiꞌyaj sij hueꞌ. Sani̱ nun gu̱nucuaj sij gui̱si, gui̱ꞌyaj sij mánj.” Daj ga̱taj ni ngüi̱ daj. ");
INSERT INTO trq_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","’Ni̱ sisi̱ hua ꞌngo̱ rey nicaj ichiꞌ mil snado, ni̱ huaj sij ga̱nꞌanj gu̱nunꞌ sij nga̱ ango rey ꞌna̱ꞌ nga̱ co̱ mí snado, ngaa ni̱ ga̱nꞌanj ga̱ne sij xa̱caj sij cuenta sisi̱ ga̱ꞌue gu̱nucuaj sij gui̱ꞌyaj gana sij rian ango rey nicaj co̱ mil snado daj. ");
INSERT INTO trq_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ni̱ sisi̱ ani ruhua sij sisi̱ naꞌue gu̱nucuaj sij gu̱nunꞌ sij nga̱ ango rey, ni̱ ngaa hua ga̱nꞌ ꞌna̱ꞌ ango rey, ni̱ aꞌníj sij ni tsínj nicaj nuguanꞌ ga̱nꞌanj ga̱taj snanꞌanj ni síꞌ sisi̱ na̱ꞌmi nu̱ngüej rey daj. ");
INSERT INTO trq_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","’Ni̱ hué ducuánj daj tsínj naꞌuej ruhua du̱na daranꞌ si nicaj sij, ngaa ni̱ si̱ gaꞌue ga̱huin sij tsínj gui̱nicoꞌ manꞌānj mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ni̱ gataj ru̱huaꞌ yún Jesús: ―Hua sa̱ꞌ ya̱n. Ni̱ da̱j rúnꞌ huin ya̱n, ni̱ daꞌngaꞌ daj huin a ni é re̱ꞌ chruhua xungüi̱. Sani̱ sisi̱ nitaj si ꞌni̱nꞌ ya̱n daj, ni̱ si̱ gaꞌue gui̱ꞌyaj néꞌ na̱huin ꞌni̱nꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ni̱ nitaj si níꞌyanj ya̱n daj rian yoꞌój. Ni̱ nitaj si níꞌyan ga̱huin yoꞌój yaꞌnduj nej. Sani̱ gue̱reꞌej ne̱ꞌ xe̱ꞌ ya̱n daj. Hué dan ni̱ tsínj nu̱n chraquij, ni̱ hua nia̱n si gu̱nun sij nuguanꞌ nan anj. ");
INSERT INTO trq_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ngaa ni̱ nahuin yuꞌ daranꞌ ni tsínj aꞌnej pesto nga̱ ni ngüi̱ ꞌyaj gaquinꞌ rian Jesús gu̱nun ni sij si ga̱taj síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ngaa ni̱ gaꞌmi hui̱ ni tsínj fariseo nga̱ ni tsínj digyán ley xiꞌí si guiꞌyaj Jesús. Ni̱ gataj ni síꞌ: ―Aꞌninꞌ ruhua tsínj daj nicaj dugüiꞌ sij nga̱ ni tsínj ꞌyaj gaquinꞌ. Ni̱ xa nu̱guanꞌan sij nga̱ ni síꞌ nej. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ngaa ni̱ nani Jesús ꞌngo̱ cuento digyán sij rian ni síꞌ. Ni̱ gataj sij: ");
INSERT INTO trq_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Ni̱ sisi̱ ni̱caj ꞌngo̱ dugüiꞌ ni é re̱ꞌ ꞌngo̱ ciento xachij, ni̱ ga̱nꞌanj niꞌya ꞌngo̱ xuj, ni̱ da̱j gui̱ꞌyaj tsínj da̱n daj, ruhua ni é re̱ꞌ únj. Ga̱ra sij ga̱nꞌanj xia xi̱nunꞌ ga̱nꞌanj xachij riqui quij. Ni̱ ga̱nꞌanj na̱naꞌuiꞌ sij xachij ganꞌanj niꞌya daj. Ni̱ dayun nariꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ni̱ ngaa nariꞌ sij, ni̱ nia̱ꞌ ruhua sij gutaꞌ sij dacan xicój sij. ");
INSERT INTO trq_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ni̱ ngaa nasíj sij ducuá sij, ni̱ naranꞌ sij ni tsínj nicaj dugüiꞌ nga̱ sij nga̱ ni tsínj nne xánj sij. Ni̱ gataj sij gunun ni síꞌ: “Ga̱huin nia̱ꞌ ruhua á re̱ꞌ ngāj si hua nariꞌīj xachij ganꞌanj niꞌya daj.” Daj gataj tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ni̱ ataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ nia̱ꞌ ruhua ni tsínj mán xataꞌ niꞌyaj ni sij ꞌngo̱ tsínj ꞌyaj gaquinꞌ ngaa nani ruhua síꞌ xiꞌí si-ga̱quinꞌ síꞌ. Ni̱ ga̱huin nia̱ꞌ ruhua ni sij ni̱ꞌyaj ni sij doj nga̱ tsínj daj, daj nga̱ ango ga̱nꞌanj xia xi̱nunꞌ ga̱nꞌanj ni tsínj naꞌuej ruhua si ga̱nani ruhua ni sij xiꞌí si-ga̱quinꞌ ni sij. Daj si hua ni̱ca niman ni sij, ruhua ni sij. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús: ―Ni̱ sisi̱ nicaj ꞌngo̱ yunꞌunj xa̱na ichiꞌ moneda sanꞌanj, ni̱ ga̱nꞌanj niꞌya ꞌngo̱ moneda daj, ni̱ da̱j gui̱ꞌyaj únꞌ, ruhua á re̱ꞌ únj. Ga̱run únꞌ yanꞌa̱n candil. Ni̱ na̱caꞌ únꞌ chruhua hueꞌ. Ni̱ na̱naꞌuiꞌ ꞌueé únꞌ da nariꞌ únꞌ. ");
INSERT INTO trq_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ni̱ ngaa na̱riꞌ únꞌ, ni̱ ga̱quínj únꞌ ni ngüi̱ nicaj dugüiꞌ nga̱ únꞌ nga̱ ni dugüiꞌ únꞌ ma̱n xánj únꞌ nej. Ni̱ ga̱taj únꞌ: “Ga̱huin nia̱ꞌ ruhua á re̱ꞌ ngāj si hua nariꞌīj moneda ganꞌanj niꞌya daj.” Daj ga̱taj únꞌ gu̱nun ne. ");
INSERT INTO trq_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ni̱ ataj snanꞌān gu̱nun ni é re̱ꞌ sisi̱ da̱j rúnꞌ gahuin nia̱ꞌ ruhua únꞌ, ni̱ daꞌngaꞌ daj hua nia̱ꞌ ruhua si-ángel Yanꞌanj niꞌyaj-áꞌ ngaa nanica̱j ruhua ꞌngo̱ tsínj xiꞌí si-ga̱quinꞌ sij. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ni̱ gataj ru̱huaꞌ yún Jesús: ―Hua hui̱j daꞌníj ꞌngo̱ tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ni̱ gataj daꞌníj sij tsínj hua lij doj gunun chrej sij: “Tata chréꞌ, huin ruhuāj sisi̱ gu̱raꞌ daꞌáj re̱ꞌ siꞌyáj re̱ꞌ. Ni̱ ri̱qui re̱ꞌ daꞌaj siꞌyáj re̱ꞌ ga̱huīnj.” Daj gataj sij gunun chrej sij. Ngaa ni̱ guraꞌ daꞌaj chrej sij siꞌyaj síꞌ gaꞌuiꞌ síꞌ rian nu̱ngüej daꞌníj síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Do̱j güi gachin ni̱ naranꞌ tsínj hua lij daj daranꞌ siꞌyaj sij. Ni̱ gahui sij ganꞌanj ga̱nꞌ sij ango xumanꞌ. Ni̱ ganahuij si-sanꞌanj sij gutinꞌ yu̱n sij da̱j rúnꞌ garanꞌ ruhua sij. ");
INSERT INTO trq_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ni̱ ngaa ganahuij gutinꞌ sij sanꞌanj nicaj sij, ni̱ ducu gahuin xiꞌna̱ xumanꞌ daj. Ni̱ gaꞌnaj gachin xiꞌna̱ riqui sij. ");
INSERT INTO trq_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ngaa ni̱ ganꞌanj ga̱chinj sij sun gui̱ꞌyaj sun sij rian ꞌngo̱ tsínj nne yuꞌuj daj. Ni̱ gaꞌníj síꞌ ga̱nꞌanj sij quij ga̱nꞌanj du̱gumi sij dán síꞌ xacáj. ");
INSERT INTO trq_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ni̱ huin ruhua sij ga̱ra riqui sij nga̱ si xa xacáj. Sani̱ a̱ ꞌngo̱ ni síꞌ nun ga̱ꞌuiꞌ ni síꞌ si xa̱ sij mánj. ");
INSERT INTO trq_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","’Ngaa ni̱ nanica̱j ruhua sij, ni̱ gataj sij gunun manꞌan sij: “Ni̱ moso mán ꞌyaj sun rian chrē, ni̱ hua nico si xa ni sij. Ni̱ yuꞌuj nan nnēj. Ni̱ ga̱huīj, gui̱ꞌyaj xiꞌna̱. ");
INSERT INTO trq_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Na̱nicā na̱nꞌānj ducuá chrē, ni̱ ga̱tā gu̱nun síꞌ: Tata chréꞌ, guiꞌyā gaquinꞌ rian Yanꞌanj nga̱ rian manꞌán re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nitaj hua si-chrej si ga̱taj re̱ꞌ si daꞌníj re̱ꞌ huīnj ga̱ mánj. Maan si gui̱ꞌyáj re̱ꞌ si ga̱huīnj ꞌngo̱ tsínj ꞌyaj sun rián re̱ꞌ, ga̱tā gu̱nun chrē.” Daj gataj sij gunun manꞌan sij. ");
INSERT INTO trq_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","’Hué dan ni̱ naxu̱man sij, ni̱ nanica̱j sij na̱nꞌ sij ducuá chrej sij. Ni̱ ngaa guiniꞌi chrej sij huaj sij ga̱nꞌ, ni̱ ducu gahuin yaco ruhua síꞌ niꞌyaj síꞌ sij. Ni̱ gunánj síꞌ ganꞌanj síꞌ rian huaj daꞌníj sij. Ni̱ gananan síꞌ manꞌan sij. Ni̱ garun duꞌua síꞌ manꞌan sij nej. ");
INSERT INTO trq_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ngaa ni̱ gataj sij gunun síꞌ: “Tata chréꞌ, guiꞌyā gaquinꞌ rian Yanꞌanj nga̱ rian manꞌán re̱ꞌ nej. Ni̱ nitaj hua si-chrej si ga̱taj re̱ꞌ si daꞌníj re̱ꞌ huīnj ga̱ mánj.” Daj gataj sij gunun chrej sij. ");
INSERT INTO trq_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Sani̱ gataj chrej sij gunun ni si-moso síꞌ: “Güi̱j xa̱caj yoo̱ ni é re̱ꞌ atsij sa̱ꞌ. Ni̱ ga̱ꞌnij a ni é re̱ꞌ xa̱ sij gu̱nun sij. Ni̱ ga̱ꞌnij ni é re̱ꞌ ꞌngo̱ seꞌej raꞌa sij. Ni̱ na̱ri ni é re̱ꞌ zapato dacój sij nej. ");
INSERT INTO trq_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ni̱ ni̱caj á re̱ꞌ sicuj namij ga̱ꞌnaꞌ á re̱ꞌ. Ni̱ da̱gahuiꞌ a ni é re̱ꞌ nej. Ni̱ gui̱ꞌyaj néꞌ guiꞌyanj ga̱huin nia̱ꞌ ruhua néꞌ. ");
INSERT INTO trq_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Daj si rúnꞌ ganáꞌnij ꞌngo̱ níman, daꞌngaꞌ daj nasíj ru̱huaꞌ yún daꞌnī riānj. Hua ganiꞌya sij. Sani̱ nariꞌ ru̱huaꞌ yún sij.” Daj gataj chrej sij. Ni̱ gaxi̱ꞌi ni sij gahuin nia̱ꞌ ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Ni̱ daꞌníj sij tsínj xa̱huaꞌ, ni̱ hua ganꞌanj síꞌ riqui quij. Ni̱ ngaa nanica̱j síꞌ, ni̱ gahuin ni̱chrunꞌ síꞌ rian hueꞌ. Ni̱ gunun síꞌ sisi̱ ma̱n ni tsínj aꞌyanj nga̱ ni ngüi̱ chranꞌanj nej. ");
INSERT INTO trq_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ngaa ni̱ gaquínj síꞌ ꞌngo̱ ni tsínj ꞌyaj sun rian chrej sij. Ni̱ nachínj snanꞌanj síꞌ moso daj u̱n sin gahuin nga̱ guiꞌyanj daj. ");
INSERT INTO trq_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","’Ngaa ni̱ gataj moso daj: “Hua nasíj jnánj re̱ꞌ. Ni̱ gaꞌníj chréj re̱ꞌ sun sisi̱ da̱gahuiꞌ ni únj sicuj hua namij. Daj si nucuaj sij nasíj sa̱ꞌ sij.” Daj gataj moso gunun tsínj xa̱huaꞌ daj. ");
INSERT INTO trq_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","’Sani̱ gaꞌman ruhua tsínj xa̱huaꞌ daj. Ni̱ nun ga̱ꞌuej sij ga̱tu sij chruhua hueꞌ. Xiꞌí daj, ni̱ gahui chrej nu̱ngüej tsínj daj. Ni̱ gaꞌmi yaco síꞌ si ga̱tu sij chruhua hueꞌ. ");
INSERT INTO trq_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ni̱ gataj sij gunun chrej sij: “Niꞌi manꞌán re̱ꞌ u̱ndaj yoꞌ síj ꞌyaj sūnj rián re̱ꞌ. Ni̱ dagahuin sa̱ꞌāj rián re̱ꞌ. Ni̱ nitaj a̱man riquí re̱ꞌ ꞌngo̱ stane̱ leꞌej gui̱ꞌyā guiꞌyanj nga̱ ni tsínj nicaj dugüiꞌ ngāj mánj. ");
INSERT INTO trq_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Sani̱ ngaa nasíj daꞌníj re̱ꞌ nan gutinꞌ sij si-sanꞌánj re̱ꞌ nga̱ ni yunꞌunj xa̱na achéj manꞌan, ni̱ dagahuíꞌ re̱ꞌ sicuj namij xiꞌí sij.” Daj gataj tsínj xa̱huaꞌ gunun chrej sij. ");
INSERT INTO trq_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’Ngaa ni̱ gataj chrej sij gunun sij: “Daꞌnī huín re̱ꞌ. Ni̱ yaꞌyoj nné re̱ꞌ ngāj. Ni̱ daranꞌ si ma̱n riānj huin siꞌyáj re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Sani̱ hua nia̱n si gui̱ꞌyaj néꞌ guiꞌyanj ga̱huin nia̱ꞌ ruhua néꞌ si nasíj jnánj re̱ꞌ. Ni̱ rúnꞌ huin ꞌngo̱ níman gahuin sij riānj. Sani̱ ganáꞌnij sij. Ni̱ ga niꞌya sij. Sani̱ nariꞌīj sij nánj.” Daj gataj chrej sij gunun sij. ―Ni̱ daꞌngaꞌ daj gataj Jesús nani sij cuento rian ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Hué dan ni̱ nani Jesús ꞌngo̱ cuento digyán sij rian ni tsínj nicoꞌ sij. Ni̱ gataj sij: ―Hua ꞌngo̱ tsínj xuruꞌue. Ni̱ rian síꞌ nu̱n ꞌngo̱ tsínj dugumi siꞌyaj síꞌ. Ngaa ni̱ ganꞌanj ga̱ꞌmi gaquinꞌ ango ni tsínj rian xuruꞌue sisi̱ ducu gutinꞌ tsínj daj siꞌyaj síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ngaa ni̱ gaquínj xuruꞌue daj si ga̱ꞌnaꞌ sij. Ni̱ gataj síꞌ: “Ni̱ u̱n sin huin nan si aꞌmi ni sij xiꞌí re̱ꞌ únj. Na̱riqui re̱ꞌ cuenta da̱j guiꞌyaj sún re̱ꞌ riānj dugumí re̱ꞌ siꞌyā si naꞌuej ruhuāj si ga̱huín re̱ꞌ tsínj du̱gumi siꞌyā riānj ga̱ mánj.” Daj gataj xuruꞌue daj. ");
INSERT INTO trq_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","’Ngaa ni̱ gataj tsínj daj gunun manꞌan síꞌ: “Ni̱ u̱n sin huin gui̱ꞌyā yya̱j, ni̱ gaꞌnej si-patrōnj sun riānj únj. Daj si nitaj fuerza gui̱ꞌyaj sūnj rian yoꞌój. Ni̱ huin na̱ꞌā gui̱ꞌyā caridad nej. ");
INSERT INTO trq_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yya̱j ni̱ hua niꞌīnj si gui̱ꞌyā. Ngaa ni̱ ga̱ꞌue chra̱cuij ni sij ducuá ni sij ga̱nēj ngaa nitaj sun gui̱ꞌyaj sūnj.” Daꞌngaꞌ daj gani ruhua sij. ");
INSERT INTO trq_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","’Ngaa ni̱ gaquínj sij ga̱ꞌnaꞌ go̱ꞌngo ni tsínj daꞌui rian xuruꞌue daj. Ni̱ gataj sij rian tsínj gaꞌna̱ꞌ sini daj: “Ni u̱ndaj huin si daꞌuíj re̱ꞌ rian si-patrōnj únj.” Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ngaa ni̱ gataj síꞌ: “Daꞌuīj ꞌngo̱ ciento tambo gasiti rian si-patrón re̱ꞌ aj.” Daj gataj síꞌ. Ngaa ni̱ gataj tsínj daj: “Ni̱caj re̱ꞌ dánj re̱ꞌ yanj rí re̱ꞌ cuenta. Ni̱ ga̱ne yoo̱ re̱ꞌ ga̱run re̱ꞌ hui̱j xia chiꞌ gue̱ aj.” Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ngaa ni̱ gataj sij gunun ango síꞌ: “Ni̱ u̱ndaj huin daꞌui manꞌán so̱ꞌ únj.” Daj gataj sij. Ni̱: “Daꞌuīj ꞌngo̱ ciento nnánj strigo aj.” Daj gataj síꞌ gunun sij. Ngaa ni̱ gataj síꞌ: “Ni̱caj re̱ꞌ dánj re̱ꞌ yanj rí re̱ꞌ cuenta nan. Ni̱ ga̱run re̱ꞌ rian yanj sisi̱ daꞌuíj re̱ꞌ ga̱nꞌanj xia gue̱ aj.” Daj gataj sij gunun síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","’Hué dan ni̱ xacaj xuruꞌue daj cuenta sisi̱ guiꞌyaj xi̱ꞌi tsínj daj xiꞌí síꞌ. Sani̱ gaꞌmi sa̱ꞌ síꞌ xiꞌí sij. Daj si naguiꞌyaj yoo̱ sij nuguanꞌ xiꞌí manꞌan sij. Ni̱ ni tsínj ma̱n xungüi̱ gaquinꞌ nan, ni̱ hua yoo̱ ni sij ngaa naguiꞌyaj ni sij ꞌngo̱ nuguanꞌ nga̱ ni dugüiꞌ ni sij. Ni̱ hua yoo̱ ni sij doj daj nga̱ ni tsínj achéj rian xigui̱n hua. ");
INSERT INTO trq_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Ngaa ni̱ ga̱taj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ ga̱ꞌuiꞌ ni é re̱ꞌ rasu̱n ma̱n rian án re̱ꞌ raꞌa ni ngüi̱. Ngaa ni̱ ga̱huin ni ngüi̱ daj ni ngüi̱ gui̱nicaj dugüiꞌ nga̱ ni é re̱ꞌ. Daj si rasu̱n ma̱n rian xungüi̱ nan, ni̱ nun hua sa̱ꞌ nico. Hué dan ni̱ ngaa ga̱nahuij ni rasu̱n ma̱n rian ni é re̱ꞌ, ngaa ni̱ xataꞌ na̱huin raꞌa ni sij ni é re̱ꞌ ga̱ne ni̱ganj ni é re̱ꞌ nga̱ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ni̱ u̱n tsínj hua gacuij, ni̱ dugumi sa̱ꞌ sij do̱j rasu̱n, ni̱ hué daj hua gacuij sij ngaa du̱gumi sij nico rasu̱n nej. Ni̱ u̱n tsínj ꞌyaj xi̱ꞌi dugumi sij do̱j rasu̱n, ni̱ gui̱ꞌyaj xi̱ꞌi sij ngaa du̱gumi sij nico rasu̱n nej. ");
INSERT INTO trq_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ni̱ hué ducuánj daj sisi̱ nitaj si hua gacuij ni é re̱ꞌ dugumi a ni é re̱ꞌ ni rasu̱n xi̱ꞌi ma̱n chruhua xungüi̱ gaquinꞌ nan, ngaa ni̱ nitaj tsínj ga̱huin ruhua ri̱qui ni rasu̱n yya rian án re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ni̱ sisi̱ nitaj si ga̱ gacuij ni é re̱ꞌ du̱gumi ni é reꞌ ni rasu̱n sé siꞌyaj ni é re̱ꞌ huin ni rasu̱n ma̱n rian xungüi̱ nan, ngaa ni̱ u̱n tsínj ga̱huin ruhua ri̱qui rasu̱n ga̱huin siꞌyaj ni é re̱ꞌ ne̱ꞌ xataꞌ, ruhua á re̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Ni̱ nitaj ꞌngo̱ tsínj ga̱huin nucuaj da̱gahuin rian hui̱j xuruꞌue mánj. Sisi̱ gui̱ꞌyaj sun néꞌ rian hui̱j xuruꞌue, ni̱ nun huin xa̱nꞌ ruhua néꞌ niꞌyaj néꞌ ꞌngo̱ xuruꞌue daj. Ni̱ ga̱huin ꞌi̱ ruhua néꞌ ni̱ꞌyaj néꞌ ango síꞌ. Ni̱ huin ruhua néꞌ gui̱nicaj dugüiꞌ néꞌ nga̱ ꞌngo̱ xuruꞌue daj. Sani̱ nitaj si aꞌmi sa̱ꞌ néꞌ nga̱ ango síꞌ. Hué ducuánj daj, ni̱ sisi̱ ducu aranꞌ ruhua néꞌ niꞌyaj néꞌ ni rasu̱n ma̱n chruhua xungüi̱, ni̱ na̱ꞌue da̱gahuin néꞌ rian Yanꞌanj mánj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ni̱ ducu garanꞌ ruhua ni tsínj fariseo niꞌyaj ni sij sanꞌanj. Ni̱ ngaa gunun ni sij nuguanꞌ daj, ni̱ gaꞌmi ducu ni sij niꞌyaj ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ngaa ni̱ gataj Jesús gunun ni sij: ―Ni̱ ꞌyaj ni é re̱ꞌ sisi̱ tsínj sa̱ꞌ huin a ni é re̱ꞌ rian ni ngüi̱. Sani̱ niꞌi Yanꞌanj niman ni é re̱ꞌ. Ni̱ nuguanꞌ níꞌyanj nico rian ni ngüi̱, sani̱ nuguanꞌ xi̱ꞌi huin rian Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Ni̱ asi̱j ná ni̱ digyán Moisés si-ley Yanꞌanj rian ni ngüi̱. Ni̱ digyán ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj rian ni ngüi̱. Sani̱ ngaa guisíj gaꞌna̱ꞌ Juan, ni̱ unun ni ngüi̱ nuguanꞌ sa̱ꞌ xiꞌí si nicaj sun Yanꞌanj rian néꞌ. Ni̱ daranꞌ ni sij ꞌyaj fuerza si ga̱tu ni sij rian nicaj sun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ni̱ ga̱ꞌue sisi̱ ga̱nahuij xataꞌ nga̱ xungüi̱. Sani̱ si̱ gaꞌue ga̱nahuij ni̱ a̱ ꞌngo̱ nuguanꞌ leꞌej ꞌna̱ꞌ rian si-ley Yanꞌanj mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ngaa ni̱ gataj Jesús: ―Ni̱ sisi̱ hua ꞌngo̱ tsínj guereꞌej nica̱, ni̱ na̱caj sij ango yunꞌunj xa̱na, ni̱ daꞌui sij gaquinꞌ. Ni̱ sisi̱ na̱caj ango tsínj yunꞌunj xa̱na guereꞌ daj, ni̱ daꞌui síꞌ gaquinꞌ nej. ―Daj gataj Jesús gunun ni tsínj fariseo. ");
INSERT INTO trq_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ngaa ni̱ nani Jesús ꞌngo̱ cuento. Ni̱ gataj sij: ―Ni̱ hua ꞌngo̱ tsínj xuruꞌue. Ni̱ nu̱n sij atsij sa̱ꞌ duꞌue. Ni̱ yaꞌyoj guiꞌyaj sij ꞌngo̱ nún nico ducuá sij. ");
INSERT INTO trq_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ni̱ hua ꞌngo̱ tsínj yaco ranꞌ gu̱ꞌnaj síꞌ Lázaro. Ni̱ ngaj síꞌ rian yoꞌój rian ducuá xuruꞌue daj. Ni̱ ma̱n siqui ni̱nꞌ ga̱chraꞌ nnee cúj síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ni̱ huin ruhua tsínj daj ga̱ra riqui sij nga̱ si ayu rian mesa, ꞌyaj xuruꞌue daj. Ni̱ ꞌna̱ꞌ xuhue ahui xuj rian siqui daj. ");
INSERT INTO trq_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","’Hué dan ni̱ ꞌngo̱ güi, ni̱ gahuiꞌ tsínj niqui daj. Ni̱ nicaj ni ángel ganꞌanj-ánꞌ sij rian nne tsínj gu̱ꞌnaj Abraham xataꞌ. Ni̱ nanan Abraham manꞌan sij. Ni̱ gahuiꞌ xuruꞌue nej. Ni̱ ganꞌanj ga̱chinꞌ ni sij síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ni̱ ngaa ranꞌ xuruꞌue daj sayun nico rian ganꞌanj ni níman, ni̱ nachi nicaj sij rian sij guiniꞌi sij sisi̱ ga̱nꞌ nne Abraham. Ni̱ yuꞌuj daj nanan Abraham tsínj gu̱ꞌnaj Lázaro. ");
INSERT INTO trq_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ngaa ni̱ gaguáj sij: “Tata chréꞌ Abraham, na̱huin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ manꞌānj. Ni̱ ga̱ꞌnij re̱ꞌ Lázaro ga̱ꞌnaꞌ síꞌ yuꞌuj nan. Ni̱ ga̱ꞌnij síꞌ chra̱ raꞌa síꞌ chruhua nnee. Ni̱ gu̱taꞌ síꞌ nnee daj rian yyāj si yaco ranꞌānj nūnj rian yanꞌa̱n nan.” Daj gataj xuruꞌue gunun Abraham. ");
INSERT INTO trq_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","’Sani̱ gataj Abraham gunun xuruꞌue: “Daꞌníꞌ, ga̱nanun ruhuá re̱ꞌ sisi̱ ngaa gané re̱ꞌ chruhua xungüi̱, ni̱ nicáj re̱ꞌ nico rasu̱n sa̱ꞌ rián re̱ꞌ. Ni̱ nicaj Lázaro ni rasu̱n xi̱ꞌi. Yya̱j ni̱ nahuin nia̱ꞌ ruhua sij yuꞌuj nan. Ni̱ ranꞌ manꞌán re̱ꞌ sayun nu̱n re̱ꞌ yuꞌuj daj. ");
INSERT INTO trq_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ango nuguanꞌ huin sisi̱ hua ꞌngo̱ xinéj xa̱chij da̱ni nu̱ngüeꞌ. Ni̱ si̱ gaꞌue ga̱chin ni ngüi̱ mán yuꞌuj nan gui̱sij ni sij rian nné re̱ꞌ. Ni̱ naꞌue ga̱chin ni ngüi̱ mán yuꞌuj daj nga̱ re̱ꞌ ga̱ꞌnaꞌ ni sij yuꞌuj nan mánj.” Daj gataj Abraham gunun síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’Ngaa ni̱ gataj xuruꞌue daj: “Achínj jniꞌyā rián re̱ꞌ tata chréꞌ Abraham sisi̱ na̱ꞌnij re̱ꞌ Lázaro na̱nꞌ sij ducuá chrē ");
INSERT INTO trq_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","rian hua u̱nꞌunꞌ jnān. Ni̱ ga̱nꞌanj sij na̱taꞌ sij rian ni síꞌ sisi̱ si̱ gaꞌna̱ꞌ ni síꞌ rian hua sayun nico nan mánj.” Daj gataj xuruꞌue. ");
INSERT INTO trq_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ngaa ni̱ gataj Abraham: “Hua nicaj ni síꞌ si garun Moisés nga̱ ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. Ga̱ꞌue gu̱nun sa̱ꞌ ni síꞌ ni nuguanꞌ daj.” Daj gataj Abraham. ");
INSERT INTO trq_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ngaa ni̱ gataj xuruꞌue: “Tata chréꞌ Abraham, xa̱ngaꞌ ni si̱ gunun ni síꞌ. Sani̱ sisi̱ ga̱naꞌnij ꞌngo̱ níman gu̱rugüiꞌ scanij ni síꞌ, ngaa ni̱ na̱nicaj ruhua ni síꞌ xiꞌí si-ga̱quinꞌ ni síꞌ, ruhuāj aj.” Daj gataj xuruꞌue. ");
INSERT INTO trq_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","’Sani̱ gataj Abraham: “Sisi̱ nun gu̱nun ni síꞌ si gataj Moisés nga̱ ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná, ngaa ni̱ si̱ guxuman ruhua ni síꞌ ni̱ꞌyaj ni síꞌ si-nu̱guanꞌ ꞌngo̱ tsínj ganáꞌnij scanij ni níman mánj.” Daj gataj Abraham gunun xuruꞌue daj. ―Ni̱ hué daj huin cuento nani Jesús rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ngaa ni̱ gataj Jesús gunun ni tsínj nicoꞌ sij: ―Xungüi̱ nan, ni̱ hua nico ni rasu̱n ꞌyaj sisi̱ gui̱nicoꞌ ni ngüi̱ chrej xi̱ꞌi. Sani̱ niqui niman ꞌngo̱ tsínj aꞌuiꞌ ꞌngo̱ chrej xi̱ꞌi riqui dugüiꞌ sij. Daj si gui̱ranꞌ sij castigo, gui̱ꞌyaj Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ni̱ asi̱j nun gaꞌuiꞌ sij ꞌngo̱ chrej xi̱ꞌi riqui dugüiꞌ sij, ni̱ du̱güej naj ni sij ꞌngo̱ yej to anumi xá sij ga̱nꞌanj sij chruhua nnee yanꞌanj nga̱ a̱ꞌ. Daj si quij ꞌyaj ꞌngo̱ tsínj ngaa aꞌuiꞌ sij ꞌngo̱ chrej xi̱ꞌi riqui ꞌngo̱ tsínj ngaa na̱ca natu síꞌ si-chrej Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","’Ga̱ cuidado a ni é re̱ꞌ da̱j gui̱ꞌyaj ni é re̱ꞌ. Sisi̱ gui̱ꞌyaj jnánj re̱ꞌ gaquinꞌ rián re̱ꞌ, ngaa ni̱ na̱taꞌ re̱ꞌ si-ga̱quinꞌ sij rian manꞌan sij. Ni̱ sisi̱ na̱ni ruhua sij xiꞌí si-ga̱quinꞌ sij, ngaa ni̱ ni̱caj re̱ꞌ ꞌngo̱ niman nico nga̱ sij. ");
INSERT INTO trq_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ni̱ nu̱nj si gui̱ꞌyaj jnánj re̱ꞌ ichij gaquinꞌ rián re̱ꞌ ꞌngo̱ güi, ni̱ hua nia̱n si ni̱caj re̱ꞌ ꞌngo̱ niman nico nga̱ sij sisi̱ ga̱ꞌnaꞌ na̱taꞌ sij yu̱n yu̱n rián re̱ꞌ sisi̱ si̱ guiꞌyaj sij gaquinꞌ da ga̱ mánj. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ngaa ni̱ gataj ni tsínj apóstol gunun Señor Jesús huin ni tsínj gaꞌmi si-nu̱guanꞌ Jesús rian ni ngüi̱: ―Ri̱qui re̱ꞌ sisi̱ gu̱xuman nico ruhua ni̱ꞌyaj ni únj Yanꞌanj anj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ngaa ni̱ gataj Señor Jesús: ―Ni sisi̱ gu̱xuman ruhua ni é re̱ꞌ da̱j rúnꞌ ꞌyaj ꞌngo̱ ca̱n cuej nasa, ngaa ni̱ ga̱ꞌue ga̱taj á re̱ꞌ gu̱nun chrun nan sisi̱ gu̱xun manꞌan ga̱nꞌanj-ánꞌ chruhua nnee yanꞌanj. Ni̱ gu̱nun chrun rian án re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Ni̱ ngaa ga̱nꞌanj si-moso ꞌngo̱ ni é re̱ꞌ quij na̱chej sij doꞌój re̱ꞌ si du̱gumi sij dán re̱ꞌ xucu, ni̱ da̱j ga̱taj re̱ꞌ gu̱nun sij ngaa ꞌna̱ꞌ niqui sij ganꞌanj sij quij únj. Atáj re̱ꞌ rian sij sisi̱ ga̱chin sij ga̱ne sij rian mesa xa̱ sij níꞌ. Sé daj huin atáj re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Sani̱ atáj re̱ꞌ gu̱nun sij: “Gui̱ꞌyaj xugüí re̱ꞌ ga̱huin stiꞌni̱ manꞌānj. Gui̱ꞌyaj sun acuánꞌ re̱ꞌ riānj si xāj, ni̱ goꞌōj. Asíj ni̱ xa̱, ni̱ go̱ꞌo manꞌán re̱ꞌ nej.” Daj atáj re̱ꞌ rian sij nánj. ");
INSERT INTO trq_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ni̱ ngaa dagahuin si-mosó re̱ꞌ daranꞌ si aꞌnínꞌ re̱ꞌ sun rian sij, ni̱ ga̱taj re̱ꞌ si guruhua rian moso daj níꞌ. Sé daj huin ga̱taj re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ni̱ daꞌngaꞌ daj gui̱ꞌyaj á re̱ꞌ nga̱ Yanꞌanj. Ni̱ ngaa ga̱nahuij gui̱ꞌyaj á re̱ꞌ daranꞌ nuguanꞌ aꞌninꞌ Yanꞌanj sun rian án re̱ꞌ, ngaa ni̱ ga̱taj á re̱ꞌ: “Nitaj si níꞌyanj ni únj si maan si guiꞌyaj únj rúnꞌ hua si-sun ni únj.” Daj ga̱taj á re̱ꞌ. ―Gataj Jesús gunun ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ni̱ ngaa huaj Jesús ganꞌanj sij xumanꞌ Jerusalén, ni̱ gachin sij rian ata dugüiꞌ estado Samaria nga̱ estado Galilea. ");
INSERT INTO trq_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ni̱ guisíj sij ꞌngo̱ rancho rian gahui ichiꞌ tsínj ranꞌ xiꞌi̱ nnij. Ni̱ ga̱nꞌ ganiquinꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ni̱ gaguáj ni sij gataj ni sij: ―Jesús, Maestro, ga̱huin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ ni únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ni̱ ngaa guiniꞌi Jesús ni síꞌ, ni̱ gataj sij: ―Güi̱j di̱gyán ni é re̱ꞌ manꞌan án re̱ꞌ rian ni chrej. ―Daj gataj Jesús. Hué dan ni̱ ngaa huaj ni sij chruhua chrej, ni̱ ganahuin sa̱ꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ni̱ ngaa guiniꞌi ꞌngo̱ tsínj daj sisi̱ ganahuin sa̱ꞌ sij, ni̱ nanica̱j sij gaꞌmi nucuaj sij si hua ꞌueé guiꞌyaj Yanꞌanj nga̱ sij. ");
INSERT INTO trq_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ni̱ ganiquinꞌ ráj da̱coj sij rian Jesús. Ni̱ ga̱ꞌ rian sij rian yoꞌój. Ni̱ nagaꞌuiꞌ sij guruhua Jesús. Ni̱ tsínj daj huin ꞌngo̱ tsínj samaritano. ");
INSERT INTO trq_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ngaa ni̱ gataj Jesús: ―Sé ichiꞌ ranꞌ ni é re̱ꞌ huin si ganahuin sa̱ꞌ, guiꞌyā a̱ꞌ. Ni̱ a̱ ganꞌanj ango u̱n ranꞌ ni sij únj. ");
INSERT INTO trq_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Urin tsínj ꞌna̱ꞌ anéj chrej nan nanica̱j gaꞌmi sa̱ꞌ rian Yanꞌanj níꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ngaa ni̱ gataj Jesús gunun tsínj daj: ―Na̱chica re̱ꞌ, ni̱ ga̱nꞌanj re̱ꞌ xiꞌí si guxuman ruhuá re̱ꞌ niꞌyáj re̱ꞌ manꞌānj, ni̱ nahuín re̱ꞌ aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ngaa ni̱ nachínj snanꞌanj ni tsínj fariseo Jesús a̱man gui̱nicaj Yanꞌanj sun rian ni ngüi̱. Ni̱ gataj Jesús: ―Nitaj si níꞌyanj sisi̱ ducu ni̱ꞌyaj ni é re̱ꞌ. Daj si si̱ gaꞌue gui̱niꞌi ni ngüi̱ ngaa ga̱ꞌnaꞌ gui̱nicaj sun Yanꞌanj mánj. ");
INSERT INTO trq_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ni̱ nitaj si ga̱taj ni ngüi̱: “Nan huin rian nicaj sun Yanꞌanj, asi̱ yuꞌuj daj huin rian nicaj sun Yanꞌanj.” Sé daj huin mánj. Daj si hua gaꞌna̱ꞌ guinicaj sun Yanꞌanj scanij ni é re̱ꞌ aj. ―Daj gataj Jesús rian ni tsínj fariseo. ");
INSERT INTO trq_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ngaa ni̱ gataj Jesús gunun ni tsínj nicoꞌ sij: ―Gui̱sij ꞌngo̱ güi ngaa ga̱huin ruhua ni é re̱ꞌ gui̱niꞌi ni é re̱ꞌ güi nan ngaa huaj manꞌānj scanij a ni é re̱ꞌ huīnj daꞌníj ni ngüi̱. Sani̱ si̱ guiniꞌi ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ni̱ ga̱taj go̱ꞌngo ni ngüi̱ gu̱nun a ni é re̱ꞌ: “Nan nne Cristo aj.” Asi̱ ga̱taj ni sij: “Yuꞌuj daj nne Cristo aj.” Ga̱taj ni ngüi̱ gu̱nun a ni é re̱ꞌ. Sani̱ si̱ ganꞌanj án re̱ꞌ mánj. Ni̱ si̱ guinicoꞌ a ni é re̱ꞌ ni tsínj da mánj. ");
INSERT INTO trq_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Daj si da̱j rúnꞌ huin ngaa ra̱n ꞌyaj duꞌui, ni̱ ꞌngo̱ xigui̱n ni̱nꞌ rian xungüi̱, ni̱ daꞌngaꞌ daj yoo̱ ga̱huin güi na̱nicaj daꞌníj ni ngüi̱ huin manꞌānj. ");
INSERT INTO trq_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Sani̱ hua nia̱n sisi̱ gui̱ranꞌānj sini nico sayun. Ni̱ hua nia̱n si da̱nicaj ni ngüi̱ ma̱n chruhua xungüi̱ nan manꞌānj nej. ");
INSERT INTO trq_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","’Ni̱ da̱j rúnꞌ guiꞌyaj ni ngüi̱ yoꞌ gane tsínj gu̱ꞌnaj Noé, ni̱ daꞌngaꞌ daj gui̱ꞌyaj ni ngüi̱ güi ngaa ga̱ꞌnaꞌ daꞌníj ni ngüi̱ huin manꞌānj. ");
INSERT INTO trq_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Daj si ngaa gane Noé, ni̱ xa ni sij goꞌo ni sij. Ni̱ xacaj ni sij yunꞌunj xa̱na. Ni̱ ni̱nanj daj guiꞌyaj ni sij da̱ꞌ güi gatúj Noé chruhua rio̱ chéj rian nnee. Ngaa ni̱ ꞌngo̱ gamanꞌ guma̱n huee xxi nu̱n güi ni̱ganꞌ. Ni̱ gara ni̱nꞌ nnee ni̱nꞌ ga̱chraꞌ chruhua xungüi̱. Ni̱ gahuiꞌ daranꞌ ni ngüi̱, guiꞌyaj nnee. ");
INSERT INTO trq_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ni̱ da̱j rúnꞌ guiꞌyaj ni ngüi̱ ngaa gane tsínj gu̱ꞌnaj Lot, ni̱ daꞌngaꞌ daj gui̱ꞌyaj ni ngüi̱ güi ga̱ꞌnaꞌ manꞌānj. Daj si ránj ni sij rasu̱n nej, guduꞌuej ni sij rasu̱n nej, gunun ni sij nna̱ nej, guiꞌyaj ni sij hueꞌ nej aj. ");
INSERT INTO trq_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sani̱ ngaa gahui tsínj gu̱ꞌnaj Lot xumanꞌ Sodoma ganꞌanj sij, ni̱ guinij yanꞌa̱n nga̱ yoꞌój sufre xataꞌ. Ni̱ gahuiꞌ daranꞌ ni ngüi̱ mán xumanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ni̱ da̱j rúnꞌ nun xacaj ni ngüi̱ daj cuenta si gui̱ranꞌ ni sij sayun, ni̱ daꞌngaꞌ daj ga̱huin güi gu̱rugüiꞌ daꞌníj ni ngüi̱ huin manꞌānj. ");
INSERT INTO trq_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Ni̱ sisi̱ ta̱j re̱ꞌ chra̱ hueꞌ güi daj, ni̱ si̱ nanij re̱ꞌ gui̱ri re̱ꞌ siꞌyáj re̱ꞌ chruhua ducuá re̱ꞌ mánj. Ni̱ sisi̱ nu̱n ꞌngo̱ tsínj quij ꞌyaj sun sij, ni̱ si̱ nanica̱j sij ducuá sij mánj. ");
INSERT INTO trq_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ni̱ ga̱nanun ruhua á re̱ꞌ da̱j guiranꞌ nica̱ tsínj gu̱ꞌnaj Lot asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","’Ni̱ u̱n tsínj huin ruhua na̱caj manꞌan sij, ni̱ ga̱huiꞌ sij. Sani̱ u̱n tsínj ga̱ꞌue ga̱huiꞌ rian xiꞌīj, ni̱ na̱caj sij manꞌan sij. ");
INSERT INTO trq_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Ataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ ꞌngo̱ ni̱ daj, ni̱ ga̱toj nu̱ngüej nica̱ ꞌngo̱ tsínj daj rian nna. Hué dan ni̱ nicā ga̱nꞌān ꞌngo̱ nu̱ngüej sij. Ni̱ ango nu̱ngüej sij gu̱na. ");
INSERT INTO trq_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ni̱ gu̱nun nu̱guanꞌan hui̱j yunꞌunj xa̱na gaj únꞌ. Ni̱ nicā ꞌngo̱ únꞌ ga̱nꞌān. Ni̱ ango únꞌ gu̱na. ");
INSERT INTO trq_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ni̱ gu̱nun hui̱j tsínj gui̱ꞌyaj sun riqui quij. Ni̱ nicā ga̱nꞌān ꞌngo̱ sij. Ni̱ ango sij gu̱na. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ngaa ni̱ nachínj snanꞌanj ni sij Jesús. Ni̱ gataj ni sij: ―Ni̱ a̱ huin ga̱huin daj Señor. ―Daj gataj ni sij. Ni̱ gataj Jesús: ―Rian ngaj ni níman yuꞌuj daj nahuin yuꞌ ni xarúj. ―Daj gataj Jesús rian ni sij. ");
INSERT INTO trq_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ngaa ni̱ nani Jesús ꞌngo̱ cuento digyán sij rian ni tsínj nicoꞌ sij sisi̱ ni̱ganj ga̱chinj jniꞌyaj ni sij rian Yanꞌanj. Ni̱ si̱ gahuin nichre ni sij mánj. ");
INSERT INTO trq_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ni̱ gataj Jesús: ―Ni̱ hua ꞌngo̱ güesi̱ nicaj sun nne riqui ꞌngo̱ xumanꞌ daj. Ni̱ nitaj si xuꞌuiꞌ sij rian Yanꞌanj. Ni̱ nitaj si níꞌyanj sij rian ni ngüi̱ nej. ");
INSERT INTO trq_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ni̱ hué riqui xumanꞌ daj nne ꞌngo̱ yunꞌunj mmij. Ni̱ aꞌníj ꞌngo̱ tsínj letu nga̱ únꞌ. Ni̱ ganꞌanj únꞌ rian güesi̱ nicaj sun daj sisi̱ gui̱ꞌyaj yya síꞌ si-ga̱quinꞌ únꞌ nga̱ tsínj ununꞌ nga̱ únꞌ daj. ");
INSERT INTO trq_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ni̱ gachin güi ni̱ nun ga̱ꞌuej ruhua güesi̱ daj gui̱ꞌyaj yya sij nga̱ gaquinꞌ daj. Ngaa ni̱ nani ruhua sij, ni̱ gataj sij gunun manꞌan sij: “Nu̱nj si nitaj si xuꞌuīj rian Yanꞌanj, ni̱ nitaj si niꞌyān rian ni ngüi̱ nej, ");
INSERT INTO trq_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","sani̱ ri̱an nun dunáj yunꞌunj mmij daj si chranꞌ yunꞌunj únꞌ yūnj, ni̱ ga̱nꞌanj gui̱ꞌyaj yyāj nga̱ gaquinꞌ daj. Ngaa ni̱ si̱ gaꞌna̱ꞌ chra̱nꞌ yunꞌunj únꞌ yūnj ga̱ mánj. Daj si sisi̱ nitaj, ni̱ gui̱nanꞌ ruhuāj niꞌyā únꞌ nánj.” Daj gataj tsínj daj gunun manꞌan sij. ―Gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ngaa ni̱ gataj Señor Jesús rian ni sij: ―Xa̱caj á re̱ꞌ cuenta da̱j gaꞌmi güesi̱ xi̱ꞌi daj. ");
INSERT INTO trq_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ngaa achínj jniꞌyaj ni ngüi̱ rian Yanꞌanj huin ni sij ni ngüi̱ hua nacui Yanꞌanj, ni̱ huin ruhua ni sij sisi̱ gui̱ꞌyaj yya Yanꞌanj ꞌngo̱ gaquinꞌ, ni̱ si̱ guiꞌyaj yya Yanꞌanj nga̱ ni sij ga̱ a̱ꞌ. Ga̱huin ran Yanꞌanj, ruhua á re̱ꞌ níꞌ. Sé daj huin mánj. ");
INSERT INTO trq_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ni̱ ataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ ráꞌyanj gui̱ꞌyaj yya Yanꞌanj nga̱ ni ngüi̱ daj. Sani̱ ngaa ga̱ꞌnaꞌ yūnj huīnj daꞌníj ni ngüi̱, ni̱ níꞌ si na̱riꞌīj ni ngüi̱ xuman ruhua niꞌyaj Yanꞌanj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ngaa ni̱ nani Jesús ango cuento digyán sij rian go̱ꞌngo ni tsínj daj. Daj si ani ruhua ni síꞌ sisi̱ hua ni̱ca niman ni síꞌ. Sani̱ aꞌmi quij ni síꞌ xiꞌí ni ngüi̱. Ngaa ni̱ gataj Jesús: ");
INSERT INTO trq_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Ganꞌanj hui̱j ranꞌ tsínj daj gatúj nu̱ngüej sij chruhua nuhui nico ga̱chinj jniꞌyaj nu̱ngüej sij rian Yanꞌanj. Ni̱ ꞌngo̱ sij daj huin tsínj fariseo. Ni̱ ango sij huin tsínj aꞌnej pesto. ");
INSERT INTO trq_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","’Ni̱ niquinꞌ tsínj fariseo daj achínj jniꞌyaj sij. Ni̱ gataj sij rian Yanꞌanj: “Hué re̱ꞌ huin Yanꞌanj. Ni̱ guruhua re̱ꞌ sisi̱ nitaj si huīnj da̱j rúnꞌ huin ango ni ngüi̱. Daj si ꞌyaj tu̱ ni sij. Ni̱ ꞌyaj xi̱ꞌi ni sij. Ni̱ aꞌmi ni sij nga̱ nica̱ ꞌngo̱ dugüiꞌ ni sij nej. Ni̱ guruhuá re̱ꞌ sisi̱ nitaj si ꞌyā da̱j rúnꞌ ꞌyaj tsínj aꞌnej pesto nan mánj. ");
INSERT INTO trq_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Hui̱j ꞌyā ayuno da nan síj semana. Ni̱ aꞌnē ichiꞌ rian go̱ꞌngo ciento daranꞌ si ꞌyaj ganāj riquīj rián re̱ꞌ.” Daj gataj tsínj fariseo daj gunun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","’Sani̱ gunáj tsínj aꞌnej pesto daj ga̱nꞌ niquinꞌ sij. Ni̱ xiꞌí si na̱ꞌaj sij a̱ do̱j nun ga̱ꞌuej ruhua sij na̱chi nicaj sij rian sij niꞌyaj sij xataꞌ. Maan sij guita raꞌa sij xíꞌyanj sij. Ni̱ gataj sij gunun Yanꞌanj: “Yanꞌanj, na̱huin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ yūnj si huīnj ꞌngo̱ tsínj ꞌyaj gaquinꞌ.” Daj gataj tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","’Ni̱ ataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ ngaa na̱nꞌ tsínj aꞌnej pesto daj ducuá sij, ni̱ hua guinicaj Yanꞌanj ꞌngo̱ niman nico xiꞌí si-ga̱quinꞌ sij. Sani̱ nun gui̱nicaj Yanꞌanj niman nico xiꞌí ango tsínj daj. Daj si u̱n tsínj huin ruhua ga̱huin achij rian dugüiꞌ sij, ni̱ gu̱naj sij da ru̱cu. Sani̱ u̱n tsínj huin ruhua gu̱naj da ru̱cu, ni̱ ga̱huin achij sij. ―Daj gataj Jesús rian ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ngaa ni̱ nicaj ni yunꞌunj xa̱na ni tsinꞌ gaꞌna̱ꞌ ne rian Jesús sisi̱ gu̱taꞌ síꞌ raꞌa síꞌ. Sani̱ ngaa guiniꞌi ni tsínj nicoꞌ Jesús, ni̱ gaxi̱ꞌi ni sij chranꞌ ni sij ni yunꞌunj xa̱na nicaj gaꞌna̱ꞌ da aj. ");
INSERT INTO trq_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ngaa ni̱ gaquínj Jesús si ga̱ꞌnaꞌ ni tsinꞌ rian sij. Ni̱ gataj sij: ―Raꞌa á re̱ꞌ si ga̱ꞌnaꞌ ni tsinꞌ da riānj. Ni̱ si̱ chranꞌ án re̱ꞌ si ga̱ꞌnaꞌ ni tsinꞌ riānj mánj. Daj si rúnꞌ huin ni tsinꞌ le nan, ni̱ daꞌngaꞌ daj huin ni ngüi̱ ma̱n rian nicaj sun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ naꞌuej ruhua ꞌngo̱ tsínj daj si gui̱nicaj sun Yanꞌanj niman sij da̱j rúnꞌ ꞌyaj ni tsinꞌ, ni̱ si̱ gaꞌue ga̱tu sij rian nicaj sun Yanꞌanj mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ngaa ni̱ nachínj snanꞌanj ꞌngo̱ tsínj aꞌninꞌ rian ni ngüi̱ Jesús. Ni̱ gataj sij: ―Maestro sa̱ꞌ. Ni̱ u̱n sun gui̱ꞌyā, ni̱ ga̱ꞌue ga̱ne ni̱gān, ruhuá re̱ꞌ únj. ―Daj gataj sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ngaa ni̱ gataj Jesús: ―Ni̱ u̱n sin huin ni̱ atáj re̱ꞌ sisi̱ sa̱ꞌ manꞌānj únj. Urin Yanꞌanj huin si sa̱ꞌ nánj. ");
INSERT INTO trq_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Hua niꞌí re̱ꞌ ni nuguanꞌ gaꞌninꞌ Yanꞌanj sun rián re̱ꞌ: “Si̱ gaꞌmi re̱ꞌ nga̱ nica̱ dugüíꞌ re̱ꞌ mánj. Ni̱ si̱ dagahuíꞌ re̱ꞌ ngüi̱ mánj. Si̱ guiꞌyaj tu̱ re̱ꞌ mánj. Si̱ gaꞌmi re̱ꞌ nuguanꞌ snanꞌanj xiꞌí dugüíꞌ re̱ꞌ mánj. Gui̱nun yanꞌanj re̱ꞌ chréj re̱ꞌ nga̱ nní re̱ꞌ nej.” Nan huin ni nuguanꞌ da̱gahuín re̱ꞌ. ―Daj gataj Jesús gunun sij. ");
INSERT INTO trq_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ngaa ni̱ gataj tsínj daj: ―Daranꞌ ni nuguanꞌ daj ráj xināj asi̱j hua lī. ―Daj gataj sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ni̱ ngaa gunun Jesús si gataj sij, ni̱ gataj síꞌ: ―Achin ꞌngo̱ nuguanꞌ rián re̱ꞌ rúnꞌ huaj. Gu̱duꞌue re̱ꞌ daranꞌ siꞌyáj re̱ꞌ. Ni̱ sanꞌanj gui̱riꞌ re̱ꞌ daj ga̱ꞌuiꞌ re̱ꞌ rian ni ngüi̱ niqui ranꞌ. Hué dan ni̱ gui̱man nico siꞌyáj re̱ꞌ xataꞌ gui̱ꞌyaj Yanꞌanj anj. Ngaa ni̱ ga̱ꞌnaꞌ re̱ꞌ gui̱nicoꞌ re̱ꞌ yūnj anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Sani̱ ngaa gunun tsínj daj si gataj Jesús, ni̱ nani nico ruhua sij. Daj si hua nico sanꞌanj rian sij. ");
INSERT INTO trq_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ngaa guiniꞌi Jesús si nani nico ruhua sij, ni̱ gataj síꞌ: ―Ni̱ ꞌi̱ huaj ga̱tu ꞌngo̱ tsínj xuruꞌue rian nicaj sun Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ni̱ ꞌi̱ huaj ga̱tu ꞌngo̱ tsínj xuruꞌue rian nicaj sun Yanꞌanj daj nga̱ si ga̱chin ꞌngo̱ xucu camello yuꞌuj ta̱j cúj nuhua aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ngaa ni̱ nachínj snanꞌanj ni tsínj gunun si gataj Jesús. Ni̱ gataj ni sij: ―Sisi̱ hué daj huin ni̱ u̱n tsínj ga̱ꞌue na̱caj manꞌan sij sisi̱ ga̱tu sij rian nicaj Yanꞌanj sun únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ngaa ni̱ gataj Jesús: ―Yanꞌanj ga̱ꞌue gui̱ꞌyaj si naꞌue gui̱ꞌyaj ni ngüi̱. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ngaa ni̱ gataj Pedro gunun Jesús: ―Hua duna únj daranꞌ siꞌyaj únj. Ni̱ nicoꞌ únj manꞌán re̱ꞌ aj. ―Daj gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Hué dan ni̱ gataj Jesús: ―Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ u̱n tsínj dunáj ducuá sij, nica̱ sij nej, jnánj sij nej, daꞌníj sij nej, chrej sij nej, nni sij nej, ngaa ni̱ gui̱ꞌyaj sa̱ꞌ Yanꞌanj nga̱ tsínj daj ngaa daꞌngaꞌ daj ꞌyaj sij xiꞌí sun nicaj Yanꞌanj rian néꞌ. ");
INSERT INTO trq_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Ni̱ ni tsínj dunáj daranꞌ ni rasu̱n daj, ni̱ xungüi̱ nan na̱huin raꞌa sij doj daj nga̱ daranꞌ si dunáj sij. Ni̱ ango xungüi̱ ga̱ꞌnaꞌ, ni̱ ga̱ne ni̱ganj sij nga̱ Yanꞌanj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ni̱ gaquínj Jesús xu̱huij ni tsínj nicoꞌ sij. Ni̱ gataj sij: ―Yya̱j ni̱ ga̱nꞌanj néꞌ xumanꞌ Jerusalén. Ni̱ da̱j rúnꞌ garun ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná xiꞌí manꞌānj huīnj daꞌníj ni ngüi̱, ni̱ daꞌngaꞌ daj gui̱ranꞌānj nánj. ");
INSERT INTO trq_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ni̱ na̱gaꞌuiꞌ ni sij yūnj rian ni tsínj ꞌna̱ꞌ anéj chrej. Ni̱ ga̱ꞌmi ducu ni sij xiꞌīj. Ni̱ ga̱ꞌmi quij ni sij riānj nej. Ni̱ ga̱ra staꞌnunj ni sij manꞌānj nej. ");
INSERT INTO trq_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ni̱ du̱guayun ni sij nneꞌ xirā. Ni̱ da̱gahuiꞌ ni sij manꞌānj nej. Sani̱ xiráj hua̱ꞌnij güi, ni̱ ga̱naꞌnī aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Sani̱ nun gunun ni sij si gataj Jesús. Ni̱ nun xacaj cuenta ni sij si gaꞌmi síꞌ. Daj si aꞌmi síꞌ nuguanꞌ naꞌue ga̱ra daꞌngaꞌ ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ni̱ ngaa huaj gui̱sij Jesús ni̱chrunꞌ xumanꞌ Jericó, ni̱ nne ꞌngo̱ tsínj duri duꞌua chrej ꞌyaj sij caridad. ");
INSERT INTO trq_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ni̱ ngaa gunun sij gachin nico ni ngüi̱, ni̱ nachínj snanꞌanj sij u̱n sin huin si gahuin. ");
INSERT INTO trq_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ngaa ni̱ gataj ni tsínj daj sisi̱ Jesús nazareno huin si gachin. ");
INSERT INTO trq_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ngaa ni̱ gaguáj nucuaj sij. Ni̱ gataj sij: ―Jesús, daꞌníj David huín re̱ꞌ. Na̱huin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ yūnj anj. ―Daj gataj tsínj duri daj. ");
INSERT INTO trq_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sani̱ ni ngüi̱ hua ne̱ꞌ rian, ni̱ chranꞌ yunꞌunj sisi̱ dínj ga̱ne duꞌua sij. Sani̱ ganariꞌ nucuaj sij doj gaguáj sij. Ni̱ gataj sij: ―Daꞌníj David, na̱huin ꞌi̱ ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ yūnj anj. ―Daj gaguáj sij. ");
INSERT INTO trq_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ngaa ni̱ guiniquinꞌ Jesús. Ni̱ gaꞌninꞌ sij sun sisi̱ ni̱caj ni síꞌ ga̱ꞌnaꞌ ni síꞌ sij. Ni̱ ngaa gahuin ni̱chrunꞌ sij, ni̱ nachínj snanꞌanj Jesús sij. ");
INSERT INTO trq_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Ni̱ gataj síꞌ: ―Ni̱ u̱n sin huin ruhuá re̱ꞌ si gui̱ꞌyā nga̱ re̱ꞌ únj. ―Daj gataj Jesús. Ngaa ni̱ gataj tsínj duri daj: ―Señor, huin ruhuāj sisi̱ na̱xiguin riānj, gui̱ꞌyáj re̱ꞌ aj. ―Gataj tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ngaa ni̱ gataj Jesús: ―Hua naxigui̱n rián re̱ꞌ xiꞌí si guxuman ruhuá re̱ꞌ niꞌyáj re̱ꞌ yūnj anj. ―Daj gataj Jesús gunun tsínj duri daj. ");
INSERT INTO trq_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ni̱ ꞌngo̱ hora daj naxigui̱n rian sij. Ni̱ guinicoꞌ sij Jesús. Ni̱ gaꞌmi sa̱ꞌ ꞌueé sij rian Yanꞌanj. Ni̱ daranꞌ ni ngüi̱ guiniꞌi si guiꞌyaj Jesús, ni̱ gaꞌmi sa̱ꞌ ni sij rian Yanꞌanj nej. ");
INSERT INTO trq_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ni̱ gatúj Jesús xumanꞌ Jericó. Ni̱ huaj sij gachin sij xumanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ni̱ yuꞌuj daj nne ꞌngo̱ xuruꞌue gu̱ꞌnaj Zaqueo. Ni̱ huin síꞌ ꞌngo̱ tsínj aꞌninꞌ rian ni tsínj aꞌnej pesto. ");
INSERT INTO trq_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ni̱ gahuin ruhua sij gui̱niꞌi sij Jesús. Sani̱ ri̱an huaj nico ni ngüi̱ nga̱ síꞌ, ni̱ nun ga̱ꞌue gui̱niꞌi sij síꞌ. Daj si chreꞌ Zaqueo daj. ");
INSERT INTO trq_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Xiꞌí daj ni̱ gunánj sij ganꞌanj sij da rian si huin ruhua sij gui̱sij sij gui̱niꞌi sij Jesús. Ni̱ gahui sij chra̱ ꞌngo̱ chrun gu̱ꞌnaj sicómoro rian ga̱chin Jesús. ");
INSERT INTO trq_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ni̱ ngaa huaj gachin Jesús yuꞌuj daj, ni̱ niꞌyaj síꞌ chra̱ chrun xataꞌ. Ni̱ gataj síꞌ: ―Zaqueo, na̱nij yoo̱ re̱ꞌ si acuanꞌ nan huin si gu̱nā ducuá re̱ꞌ, ruhuāj aj. ―Daj gataj Jesús gunun Zaqueo. ");
INSERT INTO trq_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ngaa ni̱ nanij yoo̱ sij. Ni̱ gahuin nia̱ꞌ ruhua sij si gu̱xuman Jesús ducuá sij. ");
INSERT INTO trq_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ni̱ ngaa guiniꞌi ni ngüi̱ si guiꞌyaj Jesús, ni̱ gaxi̱ꞌi ni sij gaꞌmi quij ni sij xiꞌí Jesús. Ni̱ gataj ni sij: ―Ni̱ u̱n sin huin ni̱ gatúj Jesús ducuá ꞌngo̱ tsínj ꞌyaj gaquinꞌ guna síꞌ únj, ataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ngaa ni̱ naxu̱man Zaqueo, ni̱ gataj sij gunun Señor Jesús: ―Ni̱ꞌyaj re̱ꞌ Señor. Yya̱j ni̱ ga̱ꞌuīj daꞌaj siꞌyā rian ni ngüi̱ yaco ranꞌ. Ni̱ ngaa gaꞌnej xa̱cānj sanꞌanj rian ni ngüi̱, ni̱ na̱ruꞌuē yacuanꞌanj peso chra̱ go̱ꞌngo peso gaꞌnej xa̱cānj anj. ―Daj gataj Zaqueo. ");
INSERT INTO trq_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ngaa ni̱ gataj Jesús: ―Guisíj Yanꞌanj ꞌna̱ꞌ na̱ca ni du̱cua tsínj nan yya̱j. Daj si tsínj nan huin ꞌngo̱ daꞌníj Abraham nej. ");
INSERT INTO trq_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ni̱ gaꞌna̱ꞌ daꞌníj ni ngüi̱ huin manꞌānj. Ni̱ ꞌna̱ꞌ nanaꞌuīj ni tsínj ga niꞌya. Ni̱ ga̱nacā ni sij, ruhuāj aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ni̱ gunun ni ngüi̱ si gataj Jesús. Ni̱ hua guisíj sij ni̱chrunꞌ duꞌua xumanꞌ Jerusalén. Ni̱ gani ruhua ni ngüi̱ sisi̱ ga̱ꞌnaꞌ yoo̱ Yanꞌanj gui̱nicaj sun-únꞌ chruhua xungüi̱ nan gui̱niꞌi ni sij, ruhua ni sij. Xiꞌí daj nani Jesús ꞌngo̱ cuento digyán sij rian ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ngaa ni̱ gataj Jesús: ―Ni̱ hua ꞌngo̱ tsínj huin achij ga̱nꞌanj ꞌngo̱ xumanꞌ ngaj ga̱nꞌ si ga̱rij sun ni sij ga̱huin síꞌ rey xánj síꞌ. Daꞌ síj da na̱nicaj síꞌ xánj síꞌ, ruhua síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ngaa ni̱ gaquínj tsínj daj ga̱ꞌnaꞌ ichiꞌ ranꞌ tsínj ꞌyaj sun rian sij. Ni̱ gaꞌuiꞌ sij ꞌngo̱ sanꞌanj gu̱ꞌnaj mina rian go̱ꞌngo ni síꞌ. Ni̱ ducu duꞌuej sanꞌanj gu̱ꞌnaj mina daj. Ni̱ gataj snanꞌanj sij gunun ni síꞌ: “Gui̱ꞌyaj gana á re̱ꞌ nga̱ sanꞌanj nan da na̱nicā.” Daj gataj sij. Ni̱ ganꞌanj sij. ");
INSERT INTO trq_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","’Sani̱ nun huin xa̱nꞌ ruhua ni tsínj xa̱nj daj niꞌyaj ni síꞌ sij. Xiꞌí daj gaꞌníj ni síꞌ ni tsínj nicaj sun ganꞌanj ga̱taj snanꞌanj rian tsínj huin achij daj sisi̱ nun aranꞌ ruhua ni síꞌ niꞌyaj ni síꞌ sij. Ni̱ si̱ gaꞌue ga̱huin sij tsínj aꞌninꞌ rian ni sij xánj ni sij ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Sani̱ ngaa guisíj ganacaj sij sun daj, ni̱ nanica̱j sij xánj sij. Ngaa nasíj sij xánj sij, ni̱ gaꞌninꞌ sij sun sisi̱ ga̱ꞌnaꞌ ni tsínj ꞌyaj sun rian sij huin ni tsínj ri̱an gaꞌuiꞌ sij sanꞌanj daj. Ni̱ huin ruhua sij gui̱niꞌi sij u̱ndaj guiꞌyaj gana go̱ꞌngo síꞌ nga̱ sanꞌanj daj. ");
INSERT INTO trq_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","’Ngaa ni̱ gataj tsínj guisíj sini rian sij: “Señor, riquí re̱ꞌ ꞌngo̱ sanꞌanj mina riānj. Ni̱ nga̱ mina daj ni̱ guiꞌyaj ganāj ichiꞌ mina aj.” Daj gataj tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ngaa ni̱ gataj rey daj gunun síꞌ: “Duguꞌna̱j guiꞌyáj re̱ꞌ. Huín re̱ꞌ ꞌngo̱ tsínj ꞌyaj sun sa̱ꞌ. Ni̱ ri̱an hua gacuíj re̱ꞌ nga̱ do̱j rasu̱n nan, ni̱ ga̱huín re̱ꞌ tsínj aꞌninꞌ rian ichiꞌ xumanꞌ gui̱ꞌyā.” Daj gataj tsínj huin achij daj. ");
INSERT INTO trq_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","’Ngaa ni̱ gaꞌna̱ꞌ ango tsínj daj. Ni̱ gataj síꞌ: “Señor, riquí re̱ꞌ ꞌngo̱ sanꞌanj mina riānj. Ni̱ nga̱ mina daj ni̱ guiꞌyaj ganāj yu̱nꞌunꞌ mina aj.” Daj gataj síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ni̱ gataj tsínj huin achij daj gunun síꞌ: “Ga̱huín re̱ꞌ tsínj aꞌninꞌ rian u̱nꞌunꞌ xumanꞌ, gui̱ꞌyā.” Daj gataj sij rian ango tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Ngaa ni̱ guisíj ángo tsínj daj. Ni̱ gataj síꞌ: “Nan ꞌna̱ꞌ niqui si-sanꞌánj re̱ꞌ. Naꞌníj sa̱ꞌāj chruhua ꞌngo̱ paño. ");
INSERT INTO trq_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Daj si xuꞌuīj niꞌyā re̱ꞌ si huín re̱ꞌ ꞌngo̱ tsínj huee. Ni̱ nacáj re̱ꞌ si sé siꞌyáj re̱ꞌ huin. Ni̱ ri̱an unun ango tsínj daj ca̱n, ni̱ hué yuꞌuj daj rí re̱ꞌ nnaa̱.” Daj gataj tsínj ꞌyaj sun rian tsínj huin achij daj. ");
INSERT INTO trq_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","’Ngaa ni̱ gataj tsínj huin achij gunun tsínj ꞌyaj sun daj: “Ni̱ ꞌngo̱ moso xi̱ꞌi huín re̱ꞌ. Si-nu̱guanꞌ manꞌán re̱ꞌ ataj sisi̱ daꞌuí re̱ꞌ gaquinꞌ. Hua guiniꞌí re̱ꞌ sisi̱ huīnj ꞌngo̱ tsínj huee. Ni̱ guiniꞌí re̱ꞌ sisi̱ nacā si sé siꞌyā huin. Ni̱ guiniꞌí re̱ꞌ sisi̱ ri manꞌānj nnaa̱ rian nun gunūnj nej. ");
INSERT INTO trq_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","’Xiꞌí daj ni̱ u̱n sin huin nun nicáj re̱ꞌ si-sanꞌān ga̱nꞌanj re̱ꞌ banco únj. Ngaa ni̱ ngaa na̱nicā, ni̱ na̱cā si-sanꞌān nga̱ sanꞌanj nu̱taꞌ chra̱ banco nej únj.” Daj gataj tsínj aꞌninꞌ rian moso daj. ");
INSERT INTO trq_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ngaa ni̱ gataj sij rian ni tsínj niquinꞌ nga̱ sij: “Ga̱ꞌne a ni é re̱ꞌ sanꞌanj raꞌa síꞌ. Ni̱ ga̱ꞌuiꞌ a ni é re̱ꞌ raꞌa tsínj guiꞌyaj gana ichiꞌ mina chra̱ go̱ꞌngo mina aj.” Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Sani̱ hua nicaj síꞌ ichiꞌ mina.” Gataj ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ngaa ni̱: “Ataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ tsínj nicaj, ni̱ ga̱ꞌuiꞌ néꞌ nico rian sij. Ni̱ tsínj nitaj si nicaj, ni̱ nu̱nj si do̱j nicaj sij, sani̱ ga̱ꞌne néꞌ aj.” Daj gataj tsínj huin achij daj. ");
INSERT INTO trq_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ngaa ni̱ gataj ru̱huaꞌ yún sij: “Ni tsínj ununꞌ ngāj huin ni sij ni tsínj naꞌuej ruhua sisi̱ ga̱huin achī rian ni sij. Sani̱ gui̱nicaj ni é re̱ꞌ ni sij ga̱ꞌnaꞌ á re̱ꞌ nan da̱gahuiꞌ ni é re̱ꞌ riānj.” Daj gataj tsínj huin achij daj. ―Ni̱ hué daj guisíj cuento nani Jesús. ");
INSERT INTO trq_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ngaa guisíj nani Jesús cuento daj, ni̱ huaj sij gui̱sij sij xumanꞌ Jerusalén. Ni̱ táj dian sij rian ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ni̱ huaj sij gui̱sij sij xumanꞌ Betfagé nga̱ xumanꞌ Betania. Ni̱ ngaj nu̱guanꞌan nu̱ngüej xumanꞌ daj ni̱chrunꞌ dacan gu̱ꞌnaj Olivos. Ni̱ gaꞌníj sij hui̱j tsínj nicoꞌ sij ga̱nꞌanj nu̱ngüej síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ni̱ gataj sij gunun nu̱ngüej síꞌ: ―Ga̱nꞌanj nu̱ngüej é re̱ꞌ xumanꞌ ngaj ne̱ꞌ rian do̱j aj. Ni̱ ngaa huaj ga̱tu nu̱ngüej é re̱ꞌ, ni̱ na̱riꞌ nu̱ngüej é re̱ꞌ ꞌngo̱ urruj anumi. Ni̱ a̱ ꞌngo̱ tsínj nitaj si ta̱j mánj. Hué dan ni̱ na̱chi nu̱ngüej é re̱ꞌ xúꞌ ni̱caj á re̱ꞌ ga̱ꞌnaꞌ á re̱ꞌ riānj. ");
INSERT INTO trq_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ni̱ sisi̱ hua tsínj na̱chinj snanꞌanj rian nu̱ngüej é re̱ꞌ u̱n sin ni̱ na̱chi nu̱ngüej é re̱ꞌ urruj daj, ngaa ni̱ ga̱taj nu̱ngüej é re̱ꞌ gu̱nun sij: “Manꞌan Señor níꞌyanj xuj aj.” Daj gataj Jesús gunun nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ngaa ni̱ ganꞌanj nu̱ngüej sij xumanꞌ daj. Ni̱ nariꞌ nu̱ngüej sij urruj daj da̱j rúnꞌ gataj snanꞌanj Jesús gunun nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ni̱ ngaa nachi nu̱ngüej sij urruj, ni̱ gataj ni tsínj da̱n xucu daj rian nu̱ngüej sij: ―Ni̱ u̱n sin huin ni̱ nachi nu̱ngüej é re̱ꞌ urruj daj únj. ―Daj gataj ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ngaa ni̱ gataj nu̱ngüej sij: ―Níꞌyanj Señor xuj. ―Daj gataj nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Hué dan ni̱ nicaj nu̱ngüej sij urruj gaꞌna̱ꞌ nu̱ngüej sij rian Jesús. Ni̱ gutaꞌ nu̱ngüej sij si-ganꞌ nu̱ngüej sij xiráj urruj. Ngaa ni̱ guitáj Jesús xuj, guiꞌyaj nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ni̱ gurúj ni ngüi̱ si-ganꞌ ni sij chruhua chrej ne̱ꞌ huaj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ni̱ ngaa huaj gahuin ni̱chrunꞌ ni sij gui̱sij ni sij dacuj dacan Olivos, ni̱ gaxi̱ꞌi gahuin nia̱ꞌ ruhua daranꞌ ni tsínj nicoꞌ Jesús xiꞌí daranꞌ si sa̱ꞌ guiniꞌi ni sij, guiꞌyaj Jesús. Ni̱ gaguáj ni sij. Ni̱ gaꞌmi sa̱ꞌ ni sij rian Yanꞌanj nej. ");
INSERT INTO trq_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ni̱ gataj ni sij: ―Hua ꞌueé rian rey ꞌna̱ꞌ nga̱ si-xugüi manꞌan Señor. Ga̱huin dinꞌinj ni si mán xataꞌ. Ni̱ ga̱ sa̱ꞌ ꞌueé xataꞌ aj. ―Daj gaguáj ni sij xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ngaa ni̱ gataj go̱ꞌngo ni tsínj fariseo ma̱n scanij ni ngüi̱ gunun Jesús: ―Maestro, ga̱taj re̱ꞌ rian ni tsínj nicóꞌ re̱ꞌ sisi̱ dínj gui̱niquinꞌ duꞌua ni sij. ―Daj gataj ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Sani̱ gataj Jesús: ―Sisi̱ dínj gui̱niquinꞌ duꞌua ni sij, ni̱ ga̱guaj ni yej ngaj rian yoꞌój aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ni̱ ngaa huaj guisíj Jesús ni̱chrunꞌ xumanꞌ Jerusalén, ni̱ guiniꞌi sij xumanꞌ daj. Ni̱ gaco sij xiꞌí xumanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ni̱ gataj sij: ―Maan si huin ruhuāj sisi̱ gui̱niꞌi ni é re̱ꞌ yya̱j da̱j gui̱ꞌyaj á re̱ꞌ, ngaa ni̱ ga̱huin dinꞌinj rian án re̱ꞌ aj. Sani̱ hua ránj rian án re̱ꞌ, ni̱ naꞌue ga̱ra daꞌngaꞌ ruhua á re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ni̱ gui̱sij ꞌngo̱ güi, ni̱ gui̱ranꞌ án re̱ꞌ sayun. Daj si ga̱ꞌnaꞌ ni tsínj ununꞌ nga̱ á re̱ꞌ. Ni̱ gui̱ꞌyaj ni sij ꞌngo̱ xingá ga̱nicaj ni̱nꞌ xiꞌníj ni é re̱ꞌ. Ni̱ si̱ gaꞌue ga̱hui ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ni̱ du̱guane ni sij daranꞌ ni hueꞌ ma̱n xánj án re̱ꞌ. Ni̱ da̱gahuiꞌ ni sij ni ngüi̱ nej. Ni̱ ni̱ a̱ ꞌngo̱ yej si̱ dunáj ni sij rian dugüiꞌ ni yej ga̱ mánj. Hué daj gui̱ranꞌ ni é re̱ꞌ si nun xacaj á re̱ꞌ cuenta ngaa gaꞌna̱ꞌ Yanꞌanj ga̱nacaj á re̱ꞌ mánj. ―Daj gataj Jesús rian ni ngüi̱ ma̱n xumanꞌ Jerusalén. ");
INSERT INTO trq_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Hué daj síj ni̱ gatúj Jesús chruhua nuhui nico. Ni̱ gaxi̱ꞌi sij guiri sij ne̱ꞌ chrej xe̱ꞌ ni tsínj duꞌuej rasu̱n mán yuꞌuj daj. ");
INSERT INTO trq_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ni̱ gataj sij: ―Gataj si-nu̱guanꞌ Yanꞌanj: “Ducuāj huin ri̱an ga̱chinj jniꞌyaj ni ngüi̱ rian Yanꞌanj anj. Sani̱ nuhui nan gahuin ꞌngo̱ huej ma̱n ni tsínj tu̱, ꞌyaj á re̱ꞌ aj.” Daj gataj si-nu̱guanꞌ Yanꞌanj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ni̱ daranꞌ ni güi digyán Jesús rian ni ngüi̱ chruhua nuhui daj. Sani̱ ni chrej aꞌninꞌ nga̱ ni tsínj digyán ley nga̱ ni tsínj huin achij chruhua xumanꞌ daj, ni̱ nanaꞌuiꞌ ni sij da̱j da̱gahuiꞌ ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Sani̱ nun riꞌ ruhua ni sij da̱j gui̱ꞌyaj ni sij si ga̱huiꞌ Jesús. Daj si daranꞌ ni ngüi̱ mán unun sa̱ꞌ da̱j digyán Jesús rian ni sij. ");
INSERT INTO trq_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ni̱ ꞌngo̱ güi ngaa nne Jesús chruhua nuhui nico, ni̱ digyán sij rian ni ngüi̱. Ni̱ gaꞌmi sij nuguanꞌ sa̱ꞌ rian ni sij. Ngaa ni̱ guisíj ni chrej aꞌninꞌ nga̱ ni tsínj digyán ley nej, ni tsínj huin achij nej. ");
INSERT INTO trq_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ngaa ni̱ gataj ni sij gunun Jesús: ―Ga̱taj re̱ꞌ gu̱nun únj u̱n sun huin sun nicáj re̱ꞌ, ni̱ ꞌyáj re̱ꞌ nan únj. Ni̱ u̱n tsínj riqui sun, ni̱ ꞌyáj re̱ꞌ nan únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ngaa ni̱ gataj Jesús gunun ni sij: ―Hué daj ruhuāj ga̱nachinꞌ snanꞌān ꞌngo̱ nuguanꞌ da manꞌan án re̱ꞌ. Ni̱ ga̱taj á re̱ꞌ riānj, ruhuāj aj. ");
INSERT INTO trq_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ni̱ u̱n tsínj gaꞌníj sun rian tsínj gu̱ꞌnaj Juan sisi̱ ga̱taꞌ nnee síꞌ ni ngüi̱ únj. Yanꞌanj gataj rian sij níꞌ. Asi̱ hua ango tsínj gataj rian sij sa̱ꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ngaa ni̱ gani guitsi ruhua ni dugüiꞌ ni sij. Ni̱ gataj ni sij: ―Sisi̱ ga̱taj néꞌ sisi̱ Yanꞌanj gaꞌninꞌ sun rian Juan, ngaa ni̱ ga̱taj Jesús gu̱nun néꞌ: “Ni̱ u̱n sin huin nun gu̱xuman ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ manꞌan sij únj.” ");
INSERT INTO trq_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ni̱ sisi̱ ga̱taj néꞌ sisi̱ ni tsínj gaꞌníj gaꞌna̱ꞌ Juan, sani̱ ga̱ꞌuiꞌ daranꞌ ni ngüi̱ yej yu̱nꞌ. Daj si hua ni̱ca ruhua daranꞌ ni ngüi̱ mán nan sisi̱ Juan gahuin ꞌngo̱ tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj anj. ―Daj gataj ni sij gani guitsi ruhua ni dugüiꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ngaa ni̱ gataj ni sij gunun Jesús sisi̱ nun guiniꞌi ni sij u̱n tsínj gaꞌninꞌ sun rian Juan gataꞌ nnee síꞌ ni ngüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ngaa ni̱ gataj Jesús: ―Ngaa ni̱ si̱ gatā gu̱nun a ni é re̱ꞌ u̱n sin huin sun ꞌyā aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ngaa ni̱ gaxi̱ꞌi Jesús nani sij ꞌngo̱ cuento digyán sij rian ni ngüi̱. Ni̱ gataj sij: ―Hua ꞌngo̱ xuruꞌue gunun coj uva. Ngaa ni̱ nagaꞌuiꞌ sij si-coj sij coj chruj uva rian go̱ꞌngo ni tsínj daj sisi̱ du̱gumi ni síꞌ siꞌyaj sij. Ni̱ gahui sij ganꞌanj sij ga̱nꞌ gaꞌi̱ yahui̱. ");
INSERT INTO trq_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ni̱ ngaa guisíj güi gane uva daj, ni̱ gaꞌníj sij si-moso sij ga̱nꞌanj ga̱chinj síꞌ rian ni tsínj mán ꞌyaj sun daj chruj si huin siꞌyaj sij. Sani̱ gaꞌuiꞌ ni síꞌ chrun tsínj daj. Ni̱ naꞌníj ni síꞌ na̱nꞌ yu̱n sij. ");
INSERT INTO trq_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Hué dan ni̱ gaꞌníj ru̱huaꞌ yún tsínj do̱ꞌoj daj ango si-moso sij. Sani̱ gaꞌuiꞌ ni tsínj daj síꞌ nej. Ni̱ guiꞌyaj quij ni sij nga̱ síꞌ. Ni̱ naꞌníj ni sij na̱nꞌ yu̱n síꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ngaa ni̱ gaꞌníj ru̱huaꞌ yún tsínj do̱ꞌoj daj ango si-moso sij. Sani̱ guiranꞌ xi̱ꞌi síꞌ, guiꞌyaj ni sij. Ni̱ guiri ni sij síꞌ ne̱ꞌ chrej xe̱ꞌ rian ma̱n coj uva daj. ");
INSERT INTO trq_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Ngaa ni̱ gataj xuruꞌue daj gunun manꞌan sij: “Ni̱ u̱n sin gui̱ꞌyā únj. Ga̱ꞌnī daꞌnī ꞌi̱ ruhuāj ga̱nꞌanj. Ga̱ níꞌyanj ni sij nga̱ manꞌan daꞌnī aj.” Daj gataj xuruꞌue daj gunun manꞌan sij. Ni̱ gaꞌníj sij daꞌníj sij ga̱nꞌanj síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Sani̱ ngaa guiniꞌi ni tsínj daj daꞌníj sij, ni̱ gataj ni sij gunun ni dugüiꞌ ni sij: “Tsínj nan gu̱nánj doꞌój chrej sij si sa̱ꞌ ga̱huiꞌ chrej sij. Da̱gahuiꞌ néꞌ tsínj nan, ngaa ni̱ gu̱na néꞌ ga̱huin doꞌój néꞌ nan anj.” Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ngaa ni̱ guereꞌej ni sij síꞌ chrej xe̱ꞌ duꞌua rian ma̱n coj uva daj. Ni̱ dagahuiꞌ ni sij síꞌ. Hué dan ni̱ da̱j gui̱ꞌyaj tsínj do̱ꞌoj daj nga̱ ni tsínj dugumi daj, ruhua ni é re̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ga̱ꞌnaꞌ sij rian ngaj doꞌój sij. Ni̱ da̱gahuiꞌ sij ni tsínj ꞌyaj sun daj. Ngaa ni̱ na̱gaꞌuiꞌ sij coj chruj uva daj huin si-coj sij rian ango ni tsínj sisi̱ du̱gumi ni síꞌ siꞌyaj sij. ―Daj gataj Jesús gunun ni ngüi̱. Ni̱ ngaa gunun ni ngüi̱ nuguanꞌ daj, ni̱ gataj ni sij: ―Sé daj huin ruhua únj si gui̱ꞌyaj Yanꞌanj mánj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Sani̱ guiniꞌyaj Jesús rian ni sij. Ni̱ gachínj snanꞌanj síꞌ ni sij gataj síꞌ: ―Un sin huin ni̱ garun ni sij nuguanꞌ nan asi̱j ná, ruhua á re̱ꞌ únj: Yej guereꞌej ni tsínj ꞌyaj sun hueꞌ, gahuin-ínꞌ ꞌngo̱ yej sa̱ꞌ doj ga̱ne, ni̱ ran-ánꞌ duguꞌnunꞌ squina hueꞌ ni̱ganj ni̱nꞌ anj. Daꞌngaꞌ daj garun ni sij rian libro huin si-nu̱guanꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ni̱ huēj huin yej daj. Ni̱ sisi̱ ga̱natu ꞌngo̱ ngüi̱ rian yej daj, ni̱ ga̱ranꞌ ni sij, gui̱ꞌyā. Ni̱ sisi̱ gui̱nij yej daj rian ꞌngo̱ ni ngüi̱, ni̱ gui̱xitinꞌ ni sij, gui̱ꞌyā. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ngaa ni̱ hué gue̱ hora daj huin ruhua ni chrej huin achij nga̱ ni tsínj digyán ley gui̱daꞌa ni sij Jesús. Daj si xacaj ni sij cuenta sisi̱ nuna Jesús cuento daj xiꞌí manꞌan ni sij. Sani̱ xuꞌuiꞌ ni sij rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ngaa ni̱ niꞌyaj ni sij Jesús. Ni̱ gaꞌníj ni sij ni tsínj ga̱nꞌanj na̱gaꞌnaj. Ni̱ guiꞌyaj ni síꞌ sisi̱ tsínj ꞌyaj ni̱ca huin ni síꞌ. Daj si huin ruhua ni síꞌ sisi̱ ga̱che ga̱ꞌmi Jesús. Ngaa ni̱ ga̱ꞌue na̱gaꞌuiꞌ ni síꞌ Jesús rian gobernado, ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ngaa ni̱ gachínj snanꞌanj ni tsínj digyaꞌ yunꞌunj daj Jesús. Ni̱ gataj ni sij: ―Maestro, niꞌi ni únj sisi̱ aꞌmí re̱ꞌ nuguanꞌ ni̱ca. Ni̱ xa̱ngaꞌ digyán ni̱ca re̱ꞌ rian ni ngüi̱ nej. Ni̱ nitaj si gui̱ꞌyáj re̱ꞌ sisi̱ tsínj huin rian, asi̱ tsínj ga niqui huin ꞌngo̱ tsínj daj. Ni̱ digyán xa̱ngaꞌ re̱ꞌ sisi̱ da̱j gui̱ꞌyaj néꞌ gui̱nicoꞌ néꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ngaa ni̱: Sa̱ꞌ huin sisi̱ ga̱ꞌuiꞌ néꞌ sanꞌanj aꞌnej rey César, ruhuá re̱ꞌ níꞌ. Ga̱ꞌuiꞌ néꞌ níꞌ. Asi̱ si̱ gaꞌuiꞌ néꞌ sa̱ꞌ. ―Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Sani̱ xacaj Jesús cuenta sisi̱ ani quij ruhua ni sij. Ngaa ni̱ gataj síꞌ gunun ni sij: ―Ni̱ u̱n sin huin ni̱ huin ruhua á re̱ꞌ gui̱ꞌyáj re̱ꞌ xi̱ꞌ ngāj únj. ");
INSERT INTO trq_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Di̱gyán án re̱ꞌ ꞌngo̱ sanꞌanj denario riānj. Ni̱ u̱n tsínj ri̱an nu̱n rian sanꞌanj nan únj. Ni̱ u̱n tsínj si-xugüi nu̱n rian sanꞌanj nan únj. ―Daj gataj Jesús gunun ni sij. Ngaa ni̱: ―Hué César huin. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Hué dan ni̱ gataj Jesús: ―Ngaa ni̱ ga̱ꞌuiꞌ a ni é re̱ꞌ siꞌyaj rey César rian sij. Ni̱ ga̱ꞌuiꞌ ni é re̱ꞌ siꞌyaj Yanꞌanj rian Yanꞌanj anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ngaa ni̱ nun ga̱ꞌue gui̱ꞌyaj ni sij sisi̱ ga̱che ruhua Jesús ga̱ꞌmi síꞌ rian ni ngüi̱. Sani̱ garáj yanꞌanj ruhua ni sij nga̱ nuguanꞌ gataj Jesús gunun ni sij. Ni̱ dínj ganiquinꞌ duꞌua ni sij. ");
INSERT INTO trq_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Hué dan ni̱ guisíj go̱ꞌngo ni tsínj saduceo rian nne Jesús. Ni̱ ni tsínj saduceo daj ataj sisi̱ nitaj si ga̱naꞌnij ni níman mánj. ");
INSERT INTO trq_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ni̱ nachínj snanꞌanj ni sij Jesús. Ni̱ gataj ni sij: ―Maestro, garun Moisés nuguanꞌ gunun néꞌ. Ni̱ gataj si-nu̱guanꞌ síꞌ sisi̱ gahuiꞌ ꞌngo̱ tsínj hua nica̱, ni̱ nitaj daꞌníj sij nga̱ nica̱ sij, ngaa ni̱ na̱caj jnánj tsínj gahuiꞌ daj nica̱ níman daj. Daꞌngaꞌ daj gui̱ꞌyaj sij ga̱ꞌuiꞌ sij si ga̱ꞌnga lij na̱gane-éꞌ yan duꞌua chrej-éꞌ. Daj gataj Moisés. ");
INSERT INTO trq_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ni̱ hua ichij jna̱nj ꞌngo̱ tsínj daj. Ni̱ xacaj tsínj xa̱huaꞌ nica̱ sij. Ni̱ gahuiꞌ sij. Ni̱ nitaj daꞌníj sij nga̱ únꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ni̱ nacaj ango jnánj sij tsínj gaꞌna̱ꞌ rian manꞌan sij nica̱ sij. Ni̱ hué daj gahuiꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ni̱ hué dan nan guiranꞌ ango jnánj sij síj hua̱ꞌnij jna̱nj sij aj. Ni̱ hué daj guiranꞌ ichij jna̱nj sij. Ni̱ a̱ ꞌngo̱ lij nun ga̱ꞌnga, guiꞌyaj ni sij nga̱ yunꞌunj xa̱na daj. Ni̱ gahuiꞌ daranꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Daꞌ guisíj daj gahuiꞌ manꞌan yunꞌunj xa̱na da nej. ");
INSERT INTO trq_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Hué dan ni̱ ngaa ga̱naꞌnij ni níman ngaa gui̱man ru̱huaꞌ yún ichij jnánj sij, ni̱ da̱j hua yya tsínj ga̱huin nica̱ yunꞌunj xa̱na daj, ruhuá re̱ꞌ únj. Daranꞌ ni sij xacaj únꞌ nánj. ―Daꞌngaꞌ daj gataj ni tsínj saduceo gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ngaa ni̱ gataj Jesús gunun ni sij: ―Ni tsínj ma̱n xungüi̱ nan, ni̱ acaj ni sij ni ngüi̱ xa̱na. Ni̱ hué daj hua nica̱ ni ngüi̱ xa̱na nej. ");
INSERT INTO trq_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Sani̱ ni̱ni gui̱ꞌyaj ni ngüi̱ gui̱man xungüi̱ na̱ca. Ni̱ ga̱naꞌnij ni sij ga̱ne ni sij xataꞌ xiꞌí si niꞌi Yanꞌanj sisi̱ hua ni̱ca niman ni sij. Ni̱ ngaa ga̱ne ni sij xataꞌ, ni̱ si̱ xacaj ni tsínj ni yunꞌunj xa̱na mánj. Ni̱ si̱ ga nica̱ ni yunꞌunj xa̱na mánj. ");
INSERT INTO trq_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Daj si si̱ gaꞌue ga̱huiꞌ ni ngüi̱ xataꞌ mánj. Ni̱ uyan huin ni sij nga̱ ni ángel. Ni̱ huin ni sij daꞌníj Yanꞌanj xiꞌí si ganáꞌnij ni sij scanij ni níman. ");
INSERT INTO trq_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","’Ni̱ garun Moisés xiꞌí ꞌngo̱ coj anun. Ni̱ xiꞌí daj digyán sij sisi̱ ga̱naꞌnij xa̱ngaꞌ ni níman. Daj si aꞌmi sij sisi̱ Señor huin Danꞌanj tsínj gu̱ꞌnaj Abraham nga̱ tsínj gu̱ꞌnaj Isaac nga̱ tsínj gu̱ꞌnaj Jacob nej. ");
INSERT INTO trq_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Hué dan ni̱ sé níman huin ni tsínj guinicoꞌ Yanꞌanj asi̱j ná mánj. Hua ni̱ꞌnaꞌ ni sij nánj. Daj si hua ni̱ꞌnaꞌ daranꞌ ni ngüi̱ rian Yanꞌanj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","0 Ngaa ni̱ gataj go̱ꞌngo ni tsínj digyán ley gunun Jesús: ―Maestro, duguꞌna̱j huaj gatáj re̱ꞌ. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ni̱ nun gui̱sij ruhua ni sij ga̱chinj snanꞌanj ni sij rian Jesús ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ngaa ni̱ gataj Jesús gunun ni sij: ―Ni̱ u̱n sin huin ni̱ ataj ni sij sisi̱ Cristo huin daꞌníj xíꞌ David únj. ");
INSERT INTO trq_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Daj si gataj David rian libro gu̱ꞌnaj Salmos: “Yanꞌanj gataj gunun Señor nicaj sun riānj sisi̱ ga̱ne síꞌ chrej raꞌa sa̱ꞌ Yanꞌanj daꞌ gui̱sij gui̱ꞌyaj gana Yanꞌanj rian ni tsínj ununꞌ nga̱ Señor nicaj sun riānj.” Daj gataj Yanꞌanj gunun Señor. Gataj xíꞌ David. ");
INSERT INTO trq_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ngaa ni̱ asa̱ꞌ ga̱ꞌue ga̱huin Cristo daꞌníj David sisi̱ duguꞌna̱j síꞌ Señor manꞌan Cristo únj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ngaa ni̱ gataj Jesús gunun ni tsínj nicoꞌ sij. Ni̱ gunun daranꞌ ni ngüi̱ da̱j gataj sij: ");
INSERT INTO trq_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Ga̱gudadu a ni é re̱ꞌ sisi̱ si̱ guiꞌyaj á re̱ꞌ da̱j rúnꞌ ꞌyaj ni tsínj digyán ley. Daj si nia̱ꞌ ruhua ni sij ga̱che ni sij nga̱ atsij xa̱can nu̱n ni sij huin si-ganꞌ ni tsínj huin achij. Ni̱ huin ruhua ni sij sisi̱ ga̱ꞌmi sa̱ꞌ ni ngüi̱ nga̱ ni sij ngaa achéj ni sij rian yuꞌue̱. Ni̱ nanaꞌuiꞌ ni sij ꞌngo̱ chrun xila sa̱ꞌ doj ga̱ne ni sij chruhua nuhui. Ni̱ nanaꞌuiꞌ ni sij ꞌngo̱ yuꞌuj sa̱ꞌ ga̱ne ni sij rian ꞌyaj ni sij ꞌngo̱ guiꞌyanj. ");
INSERT INTO trq_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ni̱ aꞌnej ni sij ducuá yunꞌunj xa̱na mmij. Ni̱ achínj jniꞌyaj ná ni sij rian Yanꞌanj sisi̱ sa̱ꞌ ꞌyaj ni sij ga̱ni ruhua ni ngüi̱, ruhua ni sij. Xa̱can gui̱ranꞌ ni sij castigo, gui̱ꞌyaj Yanꞌanj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ngaa ni̱ niꞌyaj Jesús sisi̱ da̱j aꞌníj ni xuruꞌue sanꞌanj ofrenda chruhua chrúnj. ");
INSERT INTO trq_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ni̱ hué daj guiniꞌi sij sisi̱ gaꞌníj ꞌngo̱ yunꞌunj niqui mmij hui̱j sanꞌanj niqui chruhua chrúnj nej. ");
INSERT INTO trq_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ngaa ni̱ gataj sij: ―Xa̱ngaꞌ ataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ yunꞌunj xa̱na niqui nan, sani̱ aꞌníj nico únꞌ doj sanꞌanj daj nga̱ daranꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Daranꞌ ni ngüi̱ nan aꞌuiꞌ sanꞌanj gunáj rian ni sij. Sani̱ yunꞌunj niqui mmij nan aꞌuiꞌ únꞌ daranꞌ sanꞌanj nicaj únꞌ sanꞌanj gui̱ran únꞌ si xa̱ únꞌ nánj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Hué dan ni̱ gaꞌmi go̱ꞌngo ni tsínj daj sisi̱ ꞌueé hua nuhui. Daj si nne yej nia̱ꞌ. Ni̱ xa̱can gaꞌuiꞌ ni ngüi̱ ofrenda, ngaa ni̱ gaꞌue gahuin nia̱ꞌ nuhui daj. ");
INSERT INTO trq_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ngaa ni gataj Jesús gunun ni sij: ―Ni̱ꞌyaj á re̱ꞌ nuhui xa̱chij nan. Sani̱ hua ꞌngo̱ güi, ni̱ si̱ gunáj ni̱ a̱ ꞌngo̱ yej rian dugüiꞌ mánj. Du̱guane ni̱nꞌ ni sij nuhui nan anj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ngaa ni̱ nachínj snanꞌanj ni sij Jesús. Ni̱ gataj ni sij: ―Maestro, u̱n güi ga̱huin yya ni nuguanꞌ nan únj. Ni̱ u̱n daꞌngaꞌ daj hua ꞌngo̱ ga̱ꞌnaꞌ gui̱niꞌi únj, ngaa ni̱ ga̱huin daranꞌ nuguanꞌ nan únj. ―Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ngaa ni̱ gataj Jesús: ―Ga̱ cuidado ni é re̱ꞌ sisi̱ nitaj ꞌngo̱ tsínj di̱gyaꞌ yunꞌunj ni é re̱ꞌ. Daj si ga̱ꞌnaꞌ nico ni tsínj rian si-xugüi manꞌānj. Ni̱ ga̱taj ni sij: “Hué manꞌānj huin Cristo aj.” Ni̱: “Yya̱j guisíj güi ga̱ꞌnaꞌ Señor.” Ga̱taj ni sij. Sani̱ si̱ guinicoꞌ ni é re̱ꞌ ni tsínj da mánj. ");
INSERT INTO trq_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","’Ni̱ ngaa gunun a ni é re̱ꞌ nuguanꞌ sisi̱ hua guerra, ni̱ sisi̱ ununꞌ ni ngüi̱ nga̱ gobierno, ngaa ni̱ si̱ guxuꞌuiꞌ ni é re̱ꞌ mánj. Hua nia̱n si hué daj ga̱huin sini. Sani̱ achin ga̱nahuij ráꞌyanj xungüi̱ ga̱ aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ni̱ gataj ru̱huaꞌ yún Jesús: ―Gu̱nunꞌ ni ngüi̱ ma̱n ꞌngo̱ xumanꞌ nico nga̱ ni ngüi̱ ma̱n ango xumanꞌ nico. Ni̱ gu̱nunꞌ ꞌngo̱ gobierno daj nga̱ ango gobierno gaꞌi̱ yuꞌuj. ");
INSERT INTO trq_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ni̱ ga̱ꞌnaꞌ yún nucuaj. Ni̱ ga̱ xiꞌna̱ nej. Ni̱ ga̱ꞌnaꞌ xiꞌi̱ rian go̱ꞌngo xungüi̱ nej. Ni̱ gu̱xuꞌuiꞌ ni ngüi̱ xiꞌí si gui̱niꞌi ni sij daꞌngaꞌ xxi xataꞌ. ");
INSERT INTO trq_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Sani̱ hua sini ngaa nun güin ga̱huin ni nuguanꞌ nan, ni̱ gui̱daꞌa ni sij a ni é re̱ꞌ. Ni̱ chra̱nꞌ yunꞌunj ni sij ni é re̱ꞌ. Ni̱ na̱gaꞌuiꞌ ni sij ni é re̱ꞌ rian tsínj ma̱n chruhua nuhui nico nga̱ rian ducuaga̱ꞌ nej. Ni̱ ni̱caj ni sij ni é re̱ꞌ ga̱nꞌanj ni sij rian ni rey nga̱ rian ni gobernado xiꞌí si nicoꞌ ni é re̱ꞌ manꞌānj. ");
INSERT INTO trq_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ngaa ni̱ ga̱ꞌue ga̱ꞌmi a ni é re̱ꞌ nuguanꞌ sa̱ꞌ xiꞌīj rian ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ni̱ si̱ gani sini ruhua á re̱ꞌ da̱j ga̱ꞌmi ni é re̱ꞌ rian ni sij mánj. ");
INSERT INTO trq_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Daj si ri̱quīj nuguanꞌ ga̱ꞌmi ni é re̱ꞌ. Ni̱ ri̱quīj si ga̱huin chru̱n ni é re̱ꞌ ngaa ga̱ꞌmi ni é re̱ꞌ. Hué dan ni̱ si̱ gaꞌue na̱nicaj ni tsínj ununꞌ nga̱ ni é re̱ꞌ ga̱ꞌmi ni sij mánj. Daj si si̱ gahuin nucuaj ni sij gui̱ri ruhua ni sij si ga̱taj ni sij gu̱nun a ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ni̱ na̱gaꞌuiꞌ da chrej ni é re̱ꞌ manꞌan ni é re̱ꞌ rian tsínj nicaj sun. Ni̱ hué daj gui̱ꞌyaj jnánj ni é re̱ꞌ nga̱ dugüiꞌ ni é re̱ꞌ nej, ni tsínj nicaj dugüiꞌ nga̱ ni é re̱ꞌ nej. Ni̱ da̱gahuiꞌ ni sij daꞌaj á re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ni̱ si̱ gahuin sa̱ꞌ ruhua daranꞌ ni ngüi̱ ni̱ꞌyaj ni sij ni é re̱ꞌ xiꞌí si nicaj dugüiꞌ ni é re̱ꞌ ngāj. ");
INSERT INTO trq_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Sani̱ ni̱ a̱ ꞌngo̱ hué chra̱ ni é re̱ꞌ si̱ ga niꞌya mánj. ");
INSERT INTO trq_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Xiꞌí si nicoꞌ ran ni é re̱ꞌ manꞌānj, ni̱ ga̱ꞌue ga̱ne ni̱ganj ni é re̱ꞌ nga̱ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Sani̱ ngaa gui̱niꞌi a ni é re̱ꞌ si ga̱nicaj ni snado duꞌua xumanꞌ Jerusalén, ngaa ni̱ xa̱caj á re̱ꞌ cuenta sisi̱ gue̱reꞌ ráꞌyanj xumanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Hué dan ni̱ ngaa gui̱niꞌi ni é re̱ꞌ daj, ngaa ni̱ gu̱nánj ni ngüi̱ mán estado Judea ga̱nꞌanj ni sij riqui quij. Ni̱ ga̱hui ni ngüi̱ ma̱n chruhua xumanꞌ daj ga̱nꞌanj ni sij. Ni̱ ni ngüi̱ ma̱n riqui quij, ni̱ si̱ gatuj ni sij chruhua xumanꞌ da mánj. ");
INSERT INTO trq_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Daj si hué ni güi daj, ni̱ gui̱ꞌyaj Yanꞌanj castigo ni ngüi̱ sisi̱ ga̱huin yya da̱j rúnꞌ hua ni̱ca rian si-nu̱guanꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ni̱ niqui niman ni ngüi̱ xa̱na nu̱n riqui nga̱ ni ngüi̱ xa̱na utsi gue̱ daꞌníj si ga̱huin ni güi daj. Daj si gui̱ranꞌ ni ngüi̱ ma̱n chruhua xungüi̱ nico sayun. Ni̱ ga̱ꞌman ruhua Yanꞌanj niꞌya ni ngüi̱ ma̱n xumanꞌ nan. ");
INSERT INTO trq_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ni̱ ga̱huiꞌ gaꞌi̱ ni sij, gui̱ꞌyaj espada. Ni̱ gu̱numi ni síꞌ ango ni sij. Ni̱ ni̱caj ni síꞌ ni sij ga̱nꞌanj ni síꞌ ni̱nꞌ ga̱chraꞌ chruhua xungüi̱. Ni̱ gui̱ꞌyaj quij ni tsínj ꞌna̱ꞌ anéj chrej nga̱ xumanꞌ Jerusalén. Ni̱ hué daj gui̱ꞌyaj ni sij da gui̱sij güi ga̱ꞌne Yanꞌanj sun raꞌa ni sij. ");
INSERT INTO trq_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Ni̱ gui̱niꞌi ni ngüi̱ daꞌngaꞌ rian güi nga̱ rian yahui̱ nej, rian ni yatiꞌ nej. Ni̱ ducu gu̱xuꞌuiꞌ ni ngüi̱ ma̱n chruhua xungüi̱. Ni̱ nun gui̱riꞌ ruhua ni sij si gui̱ꞌyaj ni sij. Daj si gu̱nun ni sij si ga̱rin gui̱ꞌyaj nnee yanꞌanj. Ni̱ hué daj ga̱rin si na̱xuman nnee yanꞌanj, gui̱ꞌyaj nane̱. ");
INSERT INTO trq_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ni̱ ga̱huin nichre ni tsínj xiꞌí si ducu gu̱xuꞌuiꞌ ni sij. Ni̱ daꞌngaꞌ daj ga̱huin xiꞌí si nun niꞌi ni sij da̱j hua sayun ga̱ꞌnaꞌ xungüi̱ nan. Daj si na̱gunanj ni fuerza mán xataꞌ. ");
INSERT INTO trq_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Asíj ni̱ gui̱niꞌi ni ngüi̱ ga̱ꞌnaꞌ manꞌānj rian nga huīnj daꞌníj ni ngüi̱. Ni̱ ga̱ꞌnāj nga̱ daranꞌ fuerza. Ni̱ na̱huin ꞌueé ni̱nꞌīnj ga̱ꞌnāj nej aj. ");
INSERT INTO trq_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ngaa ni̱ ngaa hué daj ga̱xiꞌi ga̱huin, ni̱ du̱guachre rian án re̱ꞌ. Ni̱ na̱chica ni é re̱ꞌ chra̱ ni é re̱ꞌ nej. Daj si ga̱huin ni̱chrunꞌ güi na̱caj Yanꞌanj ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ngaa ni̱ nani Jesús ꞌngo̱ cuento digyán sij rian ni síꞌ. Ni̱ gataj sij: ―Ni̱ꞌyaj á re̱ꞌ da̱j ꞌyaj chrun higuero nga̱ daranꞌ ni chrun. ");
INSERT INTO trq_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ni̱ ngaa naxiraꞌ raꞌa coj niꞌyaj á re̱ꞌ, ni̱ niꞌi a ni é re̱ꞌ sisi̱ hua gahuin ni̱chrunꞌ yahui̱ ga̱huin ya̱nꞌan anj. ");
INSERT INTO trq_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ni̱ hué gue̱ ducuánj daj ngaa gui̱niꞌi a ni é re̱ꞌ sisi̱ hua gahuin yya daranꞌ nuguanꞌ nan, ngaa ni̱ gui̱niꞌi ni é re̱ꞌ sisi̱ ráꞌyanj ga̱ꞌnaꞌ gui̱nicaj sun Yanꞌanj rian án re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ si̱ gahuiꞌ ni ngüi̱ ma̱n yya̱j da ga̱huin yya daranꞌ ni nuguanꞌ nan anj. ");
INSERT INTO trq_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ga̱ niꞌya xataꞌ nga̱ yoꞌój. Sani̱ si-nu̱guanꞌānj nitaj a̱man ga̱nahuij mánj. ");
INSERT INTO trq_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Ni̱ ga̱ cuidado ni é re̱ꞌ nga̱ manꞌan án re̱ꞌ sisi̱ si̱ xa na̱saꞌ ni é re̱ꞌ. Ni̱ si̱ ga xi̱ni ni é re̱ꞌ. Ni̱ si̱ gahuin ruhua á re̱ꞌ nga̱ ni rasu̱n ma̱n chruhua xungüi̱ nan mánj. Daj si sisi̱ daꞌngaꞌ daj gui̱ꞌyaj ni é re̱ꞌ, ngaa ni̱ ꞌngo̱ hora ga̱ꞌnaꞌ güi ga̱ꞌnaꞌ manꞌānj. ");
INSERT INTO trq_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Daj si da̱j rúnꞌ naꞌman xe̱ꞌ, ni̱ daꞌngaꞌ daj ga̱ꞌnaꞌ güi daj rian daranꞌ ni ngüi̱ ma̱n chruhua xungüi̱ nan. ");
INSERT INTO trq_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ngaa ni̱ ꞌngo̱ ni̱ꞌyaj á re̱ꞌ. Ni̱ ni̱ganj ga̱chinj jniꞌyaj á re̱ꞌ rian Yanꞌanj. Ngaa ni̱ ga̱ꞌue ga̱taj Yanꞌanj sisi̱ si̱ guiranꞌ ni é re̱ꞌ sayun daj. Ni̱ ga̱ꞌue ga̱niquinꞌ a ni é re̱ꞌ rian daꞌníj ni ngüi̱ huin manꞌānj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ni̱ ne̱ꞌ guníꞌyanj digyán Jesús chruhua nuhui nico. Ngaa ni̱ ne̱ꞌ ni̱, ni̱ gahui sij xumanꞌ daj ganꞌanj gu̱naj sij dacan gu̱ꞌnaj Olivos. ");
INSERT INTO trq_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ni̱ hua ni̱ganꞌ acuanꞌ, ni̱ ganꞌanj daranꞌ ni ngüi̱ nuhui sisi̱ gu̱nun ni síꞌ si ga̱taj sij. ");
INSERT INTO trq_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ngaa ni̱ ꞌna̱ꞌ ga̱huin ni̱chrunꞌ ga̱huin guiꞌyanj ngaa xa ni sij chrachrúnj nitaj si nachrej levadura. Ni̱ pascua gu̱ꞌnaj guiꞌyanj daj. ");
INSERT INTO trq_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ni̱ nanoꞌ ni chrej aꞌninꞌ nga̱ ni tsínj digyán ley sisi̱ da̱j da̱gahuiꞌ ni sij Jesús. Daj si xuꞌuiꞌ ni sij rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ngaa ni̱ gatúj sichre Satanás chruhua niman tsínj gu̱ꞌnaj Judas gu̱ꞌnaj síꞌ Iscariote. Ni̱ huin sij ꞌngo̱ ni xu̱huij ni tsínj nicoꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ni̱ ganꞌanj sij ga̱ꞌmi sij nga̱ ni chrej aꞌninꞌ nga̱ ni snado huin achij rian ni snado dugumi nuhui sisi̱ da̱j gui̱ꞌyaj sij na̱gaꞌuiꞌ sij Jesús rian ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ngaa ni̱ gahuin nia̱ꞌ ruhua ni tsínj daj. Ni̱ gataj ni sij sisi̱ ga̱ꞌuiꞌ ni sij sanꞌanj rian Judas. ");
INSERT INTO trq_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ngaa ni̱ garáj xina̱ Judas. Ni̱ nanoꞌ sij hora sa̱ꞌ ga̱ꞌue na̱gaꞌuiꞌ sij Jesús rian ni síꞌ ngaa nitaj ni ngüi̱ mán. ");
INSERT INTO trq_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ngaa ni̱ guisíj güi gahuin guiꞌyanj ngaa guiꞌyaj ni sij chrachrúnj nitaj si ꞌni̱j levadura xa ni sij. Ni̱ hua nia̱n da̱gahuiꞌ ni sij xachij ꞌni̱j xiꞌí pascua guiꞌyanj daj. ");
INSERT INTO trq_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ni̱ gaꞌníj Jesús ga̱nꞌanj Pedro nga̱ Juan. Ni̱ gataj sij gunun nu̱ngüej síꞌ: ―Ga̱nꞌanj gui̱ꞌyaj xugüi nu̱ngüej é re̱ꞌ si xa̱ néꞌ güenda pascua aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ngaa ni̱ gataj nu̱ngüej sij: ―Ni̱ a̱ gui̱ꞌyaj xugüi nu̱ngüej únj si xa̱ néꞌ únj. ―Daj gataj nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ni̱ gataj Jesús: ―Ngaa ga̱tu nu̱ngüej é re̱ꞌ xumanꞌ, ni̱ na̱riꞌ dugüiꞌ nu̱ngüej é re̱ꞌ nga̱ ꞌngo̱ tsínj ata cucuaj nu̱n nnee chruhua. Ni̱ gui̱nicoꞌ nu̱ngüej é re̱ꞌ tsínj daj ga̱nꞌanj ga̱tu nu̱ngüej é re̱ꞌ hueꞌ ga̱tu síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ni̱ ga̱taj nu̱ngüej é re̱ꞌ gu̱nun tsínj du̱cua daj: “Nachínj snanꞌanj Maestro manꞌán re̱ꞌ u̱n cuarto huin xa̱ stiꞌni̱ sij pascua nga̱ ni tsínj nicoꞌ sij únj.” Daj ga̱taj nu̱ngüej é re̱ꞌ gu̱nun tsínj du̱cua daj. ");
INSERT INTO trq_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ngaa ni̱ ga̱nꞌanj di̱gyán síꞌ ꞌngo̱ cuarto xa̱chij xataꞌ niquinꞌ mesa nga̱ chrun xila chruhua cuarto daj. Ni̱ yuꞌuj daj gui̱ꞌyaj xugüi nu̱ngüej é re̱ꞌ xa̱ stiꞌni̱ néꞌ. ―Daj gataj Jesús gunun nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ngaa ni̱ ganꞌanj nu̱ngüej sij. Ni̱ nariꞌ nu̱ngüej sij da̱j rúnꞌ gataj Jesús gunun nu̱ngüej sij. Ni̱ guiꞌyaj xugüi nu̱ngüej sij si xa̱ stiꞌni̱ ni sij xiꞌí guiꞌyanj pascua. ");
INSERT INTO trq_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ni̱ ngaa guisíj hora daj, ni̱ gane Jesús nga̱ ni tsínj nicoꞌ sij rian mesa huin ni tsínj ganꞌanj ga̱ꞌmi si-nu̱guanꞌ sij rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ni̱ gataj Jesús gunun ni sij: ―Ni̱nꞌ ruhua gahuin ruhuāj xa̱ stiꞌnīj xiꞌí guiꞌyanj pascua nga̱ á re̱ꞌ ngaa achin gui̱ranꞌānj sayun. ");
INSERT INTO trq_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Daj si ataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ si̱ xa yūnj xiꞌí guiꞌyanj pascua nga̱ á re̱ꞌ da ga̱huin guiꞌyanj pascua na̱ca rian nicaj sun Yanꞌanj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ngaa ni̱ guidaꞌa sij tasa. Ni̱ nagaꞌuiꞌ sij si guruhua Yanꞌanj. Ngaa ni̱ gataj sij gunun ni síꞌ: ―Gui̱daꞌa á re̱ꞌ tasa nan. Ni̱ da̱ꞌngaꞌ á re̱ꞌ go̱ꞌo dugüiꞌ a ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ni̱ ataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ si̱ goꞌōj ru̱huaꞌ yūnj nnee uva nan da ga̱ꞌnaꞌ gui̱nicaj sun Yanꞌanj rian án re̱ꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ngaa ni̱ guidaꞌa sij chrachrúnj. Ni̱ nagaꞌuiꞌ sij si guruhua Yanꞌanj. Ngaa ni̱ guraꞌ daꞌaj sij. Ni̱ gaꞌuiꞌ sij xa ni síꞌ. Ni̱ gataj sij gunun ni síꞌ: ―Chrachrúnj nan huin nnee̱ cū aj. Ni̱ ga̱huīj xiꞌí si-ga̱quinꞌ a ni é re̱ꞌ. Ni̱ xa ni é re̱ꞌ chrachrúnj nan sisi̱ na̱nun ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ manꞌānj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ni̱ ngaa ganahuij gahuin stiꞌni̱ ni sij, ni̱ guidaꞌa Jesús tasa da̱j rúnꞌ guidaꞌa sij chrachrúnj. Ngaa ni̱ gataj sij gunun ni síꞌ: ―Hué nnee uva nan huin nuguanꞌ naguiꞌyaj na̱ca yya Yanꞌanj nga̱ á re̱ꞌ. Ni̱ ga̱yanj si-tun manꞌānj xiꞌí si-ga̱quinꞌ a ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Sani̱ ni̱ꞌyaj á re̱ꞌ sisi̱ ta̱j raꞌa tsínj na̱gaꞌuiꞌ manꞌānj rian ni tsínj nicaj sun rian mesa ngāj. ");
INSERT INTO trq_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ni̱ da̱j rúnꞌ ani ruhua Yanꞌanj, ni̱ daꞌngaꞌ daj gui̱ranꞌānj sayun huīnj daꞌníj ni ngüi̱. Sani̱ niqui niman ni̱nꞌ ruhua tsínj na̱gaꞌuiꞌ manꞌānj rian ni tsínj nicaj sun. Daj si ga̱huin nico castigo gui̱ranꞌ sij. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ngaa ni̱ gaxi̱ꞌi ni sij nachínj snanꞌanj ni sij go̱ꞌngo ni dugüiꞌ ni sij sisi̱ u̱n tsínj gui̱ꞌyaj daj, ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ni̱ gani guitsi ruhua ni du̱güiꞌ ni manꞌan ni sij sisi̱ da̱j hua tsínj ga̱huin achij scanij ni sij, ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ngaa ni̱ gataj Jesús gunun ni sij: ―Ni rey nicaj sun rian ni tsínj ꞌna̱ꞌ anéj chrej, ni̱ ducu aꞌninꞌ ni sij sun rian ni tsínj daj. Ni̱ ataj ni rey daj sisi̱ duguꞌna̱j ꞌyaj ni sij rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Sani̱ si̱ guiꞌyaj á re̱ꞌ da mánj. Sisi̱ hua ꞌngo̱ tsínj huin achij scanij ni é re̱ꞌ, ni̱ daꞌui sij gui̱ꞌyaj sij si hua lij sij. Ni̱ sisi̱ hua ꞌngo̱ tsínj aꞌninꞌ sun scanij a ni é re̱ꞌ, ni̱ daꞌui sij gui̱ꞌyaj sun sij rian ni dugüiꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ni̱ u̱n tsínj huin achij ruhua á re̱ꞌ únj. Tsínj nne rian mesa níꞌ. Asi̱ tsínj ꞌyaj sun rian tsínj nne rian mesa sa̱ꞌ. Sé tsínj nne rian mesa daj huin ruhuá re̱ꞌ a̱ꞌ. Sani̱ yūnj huin si niquinꞌ ꞌyaj sun rian án re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Sani̱ hué manꞌan án re̱ꞌ huin ni tsínj guinicaj dugüiꞌ ngāj ngaa guiranꞌānj sayun. ");
INSERT INTO trq_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ngaa ni̱ da̱j rúnꞌ riqui chrē nicaj sūnj, ni̱ daꞌngaꞌ daj ri̱quīj gui̱nicaj sun a ni é re̱ꞌ ngāj nej aj. ");
INSERT INTO trq_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ngaa ni̱ xa̱ á re̱ꞌ go̱ꞌo a ni é re̱ꞌ rian si-mesāj ngaa gui̱nicaj sūnj xungüi̱ ga̱ꞌnaꞌ. Ni̱ ga̱ne a ni é re̱ꞌ rian chrun xila sa̱ꞌ gui̱nicaj sun a ni é re̱ꞌ. Ni̱ na̱guiꞌyaj yya á re̱ꞌ rian xu̱huij ni xiꞌninꞌ ni tsínj israelita. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ngaa ni̱ gataj Señor Jesús gunun Simón Pedro: ―Simón, Simón, gu̱nún re̱ꞌ nuguanꞌ ga̱ꞌmī rián re̱ꞌ. Daj si gachínj sichre Satanás permiso sisi̱ chra̱nꞌ yunꞌunj sij a ni é re̱ꞌ da̱j rúnꞌ ꞌyaj ꞌngo̱ tsínj nagunanꞌ strigo sisi̱ ga̱hui yaco riqui strigo daj. Daꞌngaꞌ daj huin ruhua sichre Satanás. ");
INSERT INTO trq_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Sani̱ gachínj jniꞌyā rian Yanꞌanj xiꞌí re̱ꞌ sisi̱ si̱ gaꞌninꞌ ruhuá re̱ꞌ si gu̱xuman ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ manꞌānj mánj. Ni̱ ngaa na̱nicoꞌ re̱ꞌ manꞌānj, ni̱ chra̱cuij re̱ꞌ ni jnánj re̱ꞌ sisi̱ ga̱huin ni̱ca ruhua ni sij aj. ―Daj gataj Jesús gunun Simón Pedro. ");
INSERT INTO trq_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ngaa ni̱ gataj Pedro gunun Jesús: ―Señor, hua ruhuāj ga̱nꞌān nga̱ re̱ꞌ ducuaga̱ꞌ. Ni̱ daꞌngaꞌ daj hua ruhuāj ga̱huīj nga̱ re̱ꞌ nej. ―Daj gataj Pedro gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ngaa ni̱ gataj Jesús: ―Pedro, atā gu̱nún re̱ꞌ sisi̱ asi̱j nun ga̱guaj doꞌloj duꞌua xúꞌ ya̱nꞌ nan, ni̱ ga̱taj re̱ꞌ hua̱ꞌnij sisi̱ nun niꞌí re̱ꞌ manꞌānj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ngaa ni̱ nachínj snanꞌanj Jesús ni tsínj nicoꞌ sij. Ni̱ gataj sij: ―Ni̱ ngaa gaꞌnī ga̱nꞌanj án re̱ꞌ, ni̱ nitaj si nicaj á re̱ꞌ nnánj nga̱ nnij nu̱n sanꞌanj nej, canj nej, ganꞌanj án re̱ꞌ mánj. Ni̱ ngaa ganꞌanj án re̱ꞌ, ni̱ hua a̱ ꞌngo̱ rasu̱n gachin rian án re̱ꞌ níꞌ. ―Daj gataj Jesús gunun ni sij. ―Nitaj a̱ ꞌngo̱ rasu̱n gachin rian únj mánj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ngaa ni̱ gataj Jesús: ―Sani̱ yya̱j ni̱ sisi̱ nicaj á re̱ꞌ ꞌngo̱ nnánj, ni̱ ni̱caj á re̱ꞌ ga̱nꞌanj án re̱ꞌ nga̱ nnij nu̱n sanꞌanj nej. Ni̱ tsínj nitaj si nicaj espada, ni̱ gu̱duꞌue sij reto̱ nu̱n sij, ni̱ gui̱ran sij ꞌngo̱j aj. ");
INSERT INTO trq_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Atā gu̱nun a ni é re̱ꞌ sisi̱ da̱j rúnꞌ hua ni̱ca rian si-nu̱guanꞌ Yanꞌanj, ni̱ daꞌngaꞌ daj hua nia̱n da̱gahuīnj ni nuguanꞌ daj. Ni̱ ataj ꞌngo̱ nuguanꞌ daj: “Gutaꞌ ni sij si-xugüi síꞌ nga̱ si-xugüi ni tsínj ꞌyaj gaquinꞌ.” Daj ataj si-nu̱guanꞌ Yanꞌanj xiꞌí manꞌānj. Daranꞌanj hua ni̱ca rian xiꞌīj. Ni̱ hua nia̱n ga̱huin yya nánj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ngaa ni̱: ―Nan niquinꞌ hui̱j espada. ―Daj gataj ni sij gunun Jesús. ―Hué daj síj gaj. ―Gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ngaa ni̱ gahui Jesús ganꞌanj sij ꞌngo̱ dacan gu̱ꞌnaj Olivos da̱j rúnꞌ guꞌyun sij huanꞌanj sij. Ni̱ guinicoꞌ ni tsínj nicoꞌ sij ganꞌanj ni síꞌ nga̱ sij nej. ");
INSERT INTO trq_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ni̱ ngaa guisíj sij yuꞌuj daj, ni̱ gataj sij gunun ni síꞌ: ―Ga̱chinj jniꞌyaj á re̱ꞌ rian Yanꞌanj, ngaa ni̱ si̱ guinij a ni é re̱ꞌ rian gaquinꞌ ngaa ga̱tsij sichre a ni é re̱ꞌ mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ngaa ni̱ gahuin anéj sij. Ni̱ ganꞌanj ga̱nꞌ sij do̱j rúnꞌ ꞌyóꞌ ngaa ga̱ꞌuiꞌ ꞌngo̱ yej daj, guiꞌyaj sij guxun anéj sij manꞌan sij. Ni̱ guiniquinꞌ ráj da̱coj sij gachínj jniꞌyaj sij rian Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ni̱ gataj sij: ―Tata chréꞌ. Sisi̱ ga̱ꞌuej manꞌán re̱ꞌ, ni̱ ga̱ꞌne re̱ꞌ sayun ranꞌānj nan. Sani̱ si̱ guiꞌyáj re̱ꞌ rúnꞌ huin ruhua manꞌānj mánj. Maan si gui̱ꞌyáj re̱ꞌ rúnꞌ huin ruhua manꞌán re̱ꞌ aj. ―Daj gataj Jesús gunun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ngaa ni̱ gurugüiꞌ ꞌngo̱ ángel ꞌna̱ꞌ xataꞌ rian Jesús. Ni̱ nariꞌ fuerza Jesús, guiꞌyaj ángel daj. ");
INSERT INTO trq_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ni̱ ducu nani ruhua Jesús. Ni̱ nucuaj gachínj jniꞌyaj sij rian Yanꞌanj nej. Ni̱ daꞌ síj nico nia̱ sij achínj jniꞌyaj sij rian Yanꞌanj. Ni̱ nia̱ nicoꞌ rian sij daj nij rian yoꞌój. Ni̱ rúnꞌ hua tun hua nia̱ daj. ");
INSERT INTO trq_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ni̱ ngaa guisíj gachínj jniꞌyaj sij rian Yanꞌanj, ni̱ naxu̱man sij ganꞌanj sij rian ma̱n ni tsínj nicoꞌ sij. Ni̱ ma̱n ni síꞌ atoj ni síꞌ nariꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ni̱ gataj Jesús: ―Ni̱ u̱n sin huin ni̱ atoj ni é re̱ꞌ únj. Na̱chica á re̱ꞌ ga̱chinj jniꞌyaj á re̱ꞌ rian Yanꞌanj sisi̱ si̱ guinij ni é re̱ꞌ rian gaquinꞌ ngaa ga̱tsij sichre niman án re̱ꞌ mánj. ―Daj gataj Jesús gunun ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Daj aꞌmi gue̱ Jesús ngaa guisíj nico ni tsínj daj. Ni̱ digyán ꞌngo̱ tsínj gu̱ꞌnaj Judas chrej rian ni tsínj huaj nga̱ síꞌ. Ni̱ hué síꞌ huin ꞌngo̱ dugüiꞌ ni xu̱huij ranꞌ ni tsínj nicoꞌ Jesús. Ni̱ gahuin ni̱chrunꞌ Judas rian nne Jesús sisi̱ ga̱run duꞌua sij síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Sani̱ gataj Jesús gunun sij: ―Judas, huin ruhuá re̱ꞌ ga̱run duꞌuá re̱ꞌ manꞌānj huīnj daꞌníj ni ngüi̱ níꞌ. Ni̱ daꞌngaꞌ daj na̱gaꞌuiꞌ re̱ꞌ manꞌānj rian ni tsínj ꞌna̱ꞌ gui̱daꞌa yūnj, ruhuá re̱ꞌ níꞌ. ―Daj gataj Jesús gunun Judas. ");
INSERT INTO trq_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ni̱ ngaa guiniꞌi ni tsínj niquinꞌ nga̱ Jesús u̱n sin gahuin, ni̱ nachínj snanꞌanj ni sij Jesús. Ni̱ gataj ni sij: ―Señor, ga̱ꞌuiꞌ únj nga̱ espada, ruhuá re̱ꞌ níꞌ. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ngaa ni̱ gaꞌuiꞌ ꞌngo̱ tsínj daj tsínj ꞌyaj sun rian chrej aꞌninꞌ. Ni̱ güéj ni̱nꞌ chraquij síꞌ ne̱ꞌ chrej raꞌa sa̱ꞌ síꞌ, guiꞌyaj sij. ");
INSERT INTO trq_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ngaa ni̱ gataj Jesús: ―Ga̱ꞌninꞌ ruhua á re̱ꞌ yya̱j aj. ―Daj gataj sij. Ngaa ni̱ ganun raꞌa sij chraquij síꞌ. Ni̱ ganahuin chraquij síꞌ, guiꞌyaj sij. ");
INSERT INTO trq_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Hué dan ni̱ gataj Jesús gunun ni chrej aꞌninꞌ nga̱ ni snado huin achij dugumi rian nuhui nga̱ ni tsínj huin achij huin ni sij ni tsínj ꞌna̱ꞌ gui̱daꞌa Jesús. Ni̱ gataj Jesús: ―Ni̱ u̱n sin huin ni̱ ata á re̱ꞌ espada nga̱ chrun ꞌna̱ꞌ á re̱ꞌ gui̱daꞌa á re̱ꞌ yūnj únj. Huēj huin ꞌngo̱ tsínj tu̱ ruhua á re̱ꞌ níꞌ. ");
INSERT INTO trq_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yaꞌyoj niquīnj chruhua nuhui nga̱ á re̱ꞌ. Sani̱ nun guidaꞌa á re̱ꞌ manꞌānj mánj. Sani̱ yya̱j guisíj hora ga̱ꞌue gui̱ꞌyaj á re̱ꞌ da̱j rúnꞌ huin ruhua á re̱ꞌ. Daj si hora nan nicaj sun sichre huin si nne rian hua ru̱miꞌ. ―Daj gataj Jesús gunun ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ngaa ni̱ guidaꞌa ni sij Jesús. Ni̱ nicaj ni sij síꞌ ganꞌanj ni sij ducuá chrej huin achij ni̱nꞌ. Ni̱ nicoꞌ ga̱nꞌ huaj Pedro nicoꞌ síꞌ ru̱cu Jesús. ");
INSERT INTO trq_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ni̱ naranꞌ ni sij yanꞌa̱n rian hueꞌ daj. Ni̱ ma̱n ni sij ganica̱j ni sij xiꞌníj yanꞌa̱n daj. Ni̱ ganꞌanj ga̱ne Pedro scanij ni sij. ");
INSERT INTO trq_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ngaa ni̱ guiniꞌi ꞌngo̱ yunꞌunj xa̱na ꞌyaj sun daj nne Pedro xiꞌníj yanꞌa̱n. Ni̱ guiniꞌyaj sa̱ꞌ únꞌ rian sij. Ni̱ gataj únꞌ: ―Hué tsínj nan nicaj dugüiꞌ nga̱ Jesús. ―Daj gataj únꞌ. ");
INSERT INTO trq_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Sani̱ nun ga̱ꞌuej Pedro. Ni̱ gataj sij gunun únꞌ: ―Xicaꞌuī, nun niꞌīnj sij mánj. ―Daj gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ni̱ ngaa gachin do̱j, ni̱ guiniꞌi ango tsínj Pedro. Ni̱ gataj síꞌ: ―Hué re̱ꞌ huin ꞌngo̱ ni tsínj nicaj dugüiꞌ nga̱ Jesús aj. ―Daj gataj síꞌ. ―Jnān, sēj huin mánj. ―Gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ngaa ni̱ ango hora, ni̱ gataj ango tsínj daj: ―Xa̱ngaꞌ sisi̱ hué sij huin ꞌngo̱ tsínj nicaj dugüiꞌ nga̱ síꞌ. Daj si ꞌna̱ꞌ sij estado Galilea. ―Daj gataj síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Sani̱: ―Nun niꞌīnj u̱n sin xi̱ꞌi aꞌmí re̱ꞌ nan jna̱nj. ―Gataj Pedro. Ni̱ ngaa hua gue̱ aꞌmi Pedro, ni̱ gaguáj doꞌloj ꞌngo̱ duꞌua xúꞌ. ");
INSERT INTO trq_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ngaa ni̱ nanica̱j Señor niꞌyaj sij rian Pedro. Ngaa ni̱ nanun ruhua Pedro si gataj Señor gunun sij: “Asi̱j nun güin ga̱huin ga̱guaj doꞌloj ya̱nꞌ, ni̱ ga̱taj re̱ꞌ si hua̱ꞌnij si nun niꞌí re̱ꞌ manꞌānj.” Hué daj gataj Jesús gunun Pedro asi̱j sini ya̱n. ");
INSERT INTO trq_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ni̱ ducu gaco Pedro gahui sij xe̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ni̱ ni tsínj ma̱n dugumi Jesús, ni̱ gaꞌmi ducu ni sij rian síꞌ. Ni̱ gaꞌuiꞌ ni sij síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ni̱ guiránj ni sij rundij rian Jesús. Ngaa ni̱ gaꞌuiꞌ ni sij síꞌ. Ni̱ gataj ni sij: ―Yya̱j ni̱ ga̱taj so̱ꞌ u̱n tsínj gaꞌuiꞌ so̱ꞌ aj. ―Daj gataj ni sij gaꞌmi ducu ni sij. ");
INSERT INTO trq_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ni̱ daꞌngaꞌ daj gaꞌmi quij ni sij gaꞌi̱ ango nuguanꞌ rian Jesús nej. ");
INSERT INTO trq_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ni̱ ngaa guixigui̱n ni̱ nahuin yuꞌ ni tsínj huin achij rian ni tsínj israelita nga̱ ni tsínj aꞌninꞌ rian ni chrej nej, ni tsínj digyán ley nej. Ni̱ nicaj ni sij Jesús ganꞌanj ni sij rian junta daj. Hué dan ni̱ nachínj snanꞌanj ni sij Jesús. Ni̱ gataj ni sij: ");
INSERT INTO trq_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Sisi̱ hué re̱ꞌ huin Cristo, ni̱ ga̱taj yyá re̱ꞌ gu̱nun únj. ―Daj gataj ni sij gunun Jesús. Ngaa ni̱: ―Sisi̱ ga̱tā si huēj huin, sani̱ si̱ guxuman ruhua á re̱ꞌ si-nu̱guanꞌānj mánj. ");
INSERT INTO trq_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ni̱ sisi̱ na̱chinꞌ snanꞌān ꞌngo̱ nuguanꞌ ni é re̱ꞌ, sani̱ nitaj nu̱nj ga̱taj á re̱ꞌ gu̱nūnj mánj. Ni̱ naꞌuej ruhua á re̱ꞌ na̱chi ni é re̱ꞌ manꞌānj mánj. ");
INSERT INTO trq_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Sani̱ asi̱j acuanꞌ ni̱ ga̱nēj raꞌa sa̱ꞌ Yanꞌanj nucuaj nne xataꞌ huīnj daꞌníj ni ngüi̱. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ngaa ni̱ nachínj snanꞌanj daranꞌ ni sij Jesús. Ni̱ gataj ni sij: ―Hué yyá re̱ꞌ huin daꞌníj Yanꞌanj, ruhuá re̱ꞌ níꞌ. ―Daj gataj ni sij. Ngaa ni̱: ―Hué ni manꞌan án re̱ꞌ ataj sisi̱ huēj huin. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ngaa ni̱ gataj ni sij gunun ni dugüiꞌ ni sij: ―Nitaj si gui̱ꞌyóꞌ testigo ga̱ mánj. Ni̱ hua gunun chraquij ni manꞌan néꞌ si gataj sij xiꞌí gaquinꞌ daꞌui sij. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ngaa ni̱ naxu̱man daranꞌ ni sij. Ni̱ nicaj ni sij Jesús ganꞌanj ni sij rian Pilato. ");
INSERT INTO trq_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ngaa ni̱ gaxi̱ꞌi ni sij gaꞌmi gaquinꞌ ni sij xiꞌí Jesús. Ni̱ gataj ni sij: ―Hué tsínj nan huin ꞌngo̱ tsínj quij hua. Daj si ataj sij gunun ni ngüi̱ sisi̱ si̱ gaꞌuiꞌ néꞌ pesto rian rey César. Ni̱ ataj sij sisi̱ hué sij huin Cristo ꞌngo̱ rey, ataj sij. ―Daj gataj ni sij xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ngaa ni̱ nachínj snanꞌanj Pilato Jesús. Ni̱ gataj sij: ―Hué re̱ꞌ huin rey rian ni tsínj israelita níꞌ. ―Daj gataj Pilato. ―Hué re̱ꞌ ataj nánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ngaa ni̱ gataj Pilato rian ni tsínj aꞌninꞌ rian ni chrej nga̱ rian ni ngüi̱ nej: ―Güendāj ni̱ a̱ ꞌngo̱ gaquinꞌ nitaj daꞌui tsínj nan mánj. ―Daj gataj Pilato. ");
INSERT INTO trq_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Sani̱ ducu guiꞌyaj ni sij fuerza, ni̱ gataj ni sij: ―Ngaa digyán tsínj nan rian ni ngüi̱, ni̱ ga̱huin xaꞌue duꞌua daranꞌ ni ngüi̱. Ni̱ huaj sij digyán sij si-nu̱guanꞌ sij ni̱nꞌ ga̱chraꞌ estado Judea. Ni̱ gaxi̱ꞌi sij digyán sij estado Galilea. Ni̱ ꞌna̱ꞌ sij yuꞌuj nan digyán sij rian ni ngüi̱ nej. ―Daj gataj ni sij gunun Pilato. ");
INSERT INTO trq_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ni̱ ngaa gunun Pilato si gataj ni sij, ni̱ nachínj snanꞌanj síꞌ sisi̱ Jesús huin tsínj ꞌna̱ꞌ estado Galilea. ");
INSERT INTO trq_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ni̱ ngaa guiniꞌi Pilato sisi̱ ꞌna̱ꞌ Jesús estado Galilea, ni̱ gaꞌníj sij ga̱nꞌanj síꞌ rian rey gu̱ꞌnaj Herodes huin síꞌ gobernado nicaj sun ne̱ꞌ estado Galilea. Daj si nne síꞌ xumanꞌ Jerusalén ni güi daj. ");
INSERT INTO trq_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ni̱ ngaa guiniꞌi Herodes Jesús, ni̱ gahuin nia̱ꞌ ruhua sij si guisíj gaꞌi̱ güi huin ruhua sij gui̱niꞌi sij Jesús. Daj si gunun sij gaꞌmi ni ngüi̱ da̱j guiꞌyaj Jesús. Ni̱ gahuin ruhua sij sisi̱ gui̱ꞌyaj Jesús ꞌngo̱ si sa̱ꞌ nico gui̱niꞌi sij. ");
INSERT INTO trq_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ni̱ ducu nachínj snanꞌanj sij Jesús. Sani̱ ni̱ a̱ ꞌngo̱ nuguanꞌ nun danica̱j Jesús rian sij mánj. ");
INSERT INTO trq_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ni̱ ma̱n ni tsínj aꞌninꞌ rian ni chrej nga̱ ni tsínj digyán ley nej. Ni̱ ducu garun gaquinꞌ ni síꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ngaa ni̱ gaꞌmi quij Herodes rian Jesús. Ni̱ hué daj gaꞌmi ni snado niquinꞌ nga̱ sij nej. Ni̱ gaꞌníj ni sij atsij nia̱ꞌ xá Jesús gunu̱n síꞌ güenda gahuin ducu ruhua ni sij niꞌyaj ni sij síꞌ. Ni̱ rúnꞌ si-ganꞌ rey hua-áꞌ. Ngaa ni̱ gaꞌníj Herodes ru̱huaꞌ yún Jesús rian Pilato. ");
INSERT INTO trq_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Xiꞌí daj ni̱ naꞌmi Pilato nga̱ Herodes güi daj si asi̱j sini, ni̱ gununꞌ nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ngaa ni̱ nahuin yuꞌ ni tsínj aꞌninꞌ rian ni chrej nga̱ ni tsínj nicaj sun nga̱ ni ngüi̱ nej, guiꞌyaj Pilato. ");
INSERT INTO trq_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ni̱ gataj síꞌ gunun ni sij: ―Nicaj á re̱ꞌ tsínj nan gaꞌna̱ꞌ á re̱ꞌ nánj. Ni̱ ataj á re̱ꞌ sisi̱ digyán sij ꞌngo̱ chrej xi̱ꞌi rian ni ngüi̱. Ni̱ natāj rian án re̱ꞌ sisi̱ hua nachínj snanꞌān sij. Sani̱ nitaj ꞌngo̱ gaquinꞌ guiꞌyaj sij nariꞌīj xiꞌí si aꞌuiꞌ a ni é re̱ꞌ gaquinꞌ sij mánj. ");
INSERT INTO trq_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ni̱ gaꞌnī Jesús ga̱nꞌanj sij rian nne rey Herodes. Ni̱ nun nariꞌ Herodes gaquinꞌ daꞌui sij mánj. Nitaj nu̱nj guiꞌyaj sij si ga̱huiꞌ sij mánj. ");
INSERT INTO trq_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ngaa ni̱ gui̱ꞌyā castigo sij, asíj ni̱ na̱ꞌnij raꞌāj sij ga̱nꞌanj sij aj. ―Daj gataj Pilato. ");
INSERT INTO trq_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ni̱ hua nia̱n si gui̱ri Pilato ꞌngo̱ tsínj nu̱n ducuaga̱ꞌ go̱ꞌngo guiꞌyanj pascua si da̱j hua si-costumbre ni sij. ");
INSERT INTO trq_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Sani̱ gaxi̱ꞌi ni sij gaguáj nucuaj nu̱guanꞌan daranꞌ ni sij. Ni̱ gataj ni sij: ―Da̱gahuíꞌ re̱ꞌ tsínj nan. Ni̱ na̱ꞌnij raꞌá re̱ꞌ tsínj gu̱ꞌnaj Barrabás aj. ―Daj gataj ni sij gaguáj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ni̱ hué Barrabás huin ꞌngo̱ tsínj nu̱n ducuaga̱ꞌ si gununꞌ ni du̱güiꞌ síꞌ nga̱ ni tsínj nicaj sun chruhua xumanꞌ daj. Ni̱ dagahuiꞌ síꞌ ꞌngo̱ níman nej. ");
INSERT INTO trq_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ni̱ huin ruhua Pilato gui̱ri sij Jesús ga̱nꞌanj síꞌ. Xiꞌí daj ni̱ gaꞌmi ru̱huaꞌ yún sij rian ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Sani̱ gaguáj nucuaj ni sij. Ni̱ gataj ni sij: ―Ga̱ri re̱ꞌ gaquíj Jesús gui̱nicoꞌ sij rian rugutsi̱. Ga̱ri re̱ꞌ gaquíj Jesús gui̱nicoꞌ sij rian rugutsi̱. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ngaa ni̱ gataj Pilato guisíj hua̱ꞌnij: ―Da̱j hua gaquinꞌ guiꞌyaj sij únj. Nitaj gaquinꞌ guiꞌyaj sij nariꞌīj sisi̱ ga̱huiꞌ sij mánj. Gui̱ꞌyā castigo sij, asíj ni̱ na̱ꞌnij raꞌāj sij ga̱nꞌanj sij aj. ―Daj gataj Pilato. ");
INSERT INTO trq_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Sani̱ ni tsínj daj nga̱ ni chrej aꞌninꞌ guiꞌyaj fuerza ni sij gaguáj ni sij sisi̱ ga̱ri Pilato gaquíj Jesús gui̱nicoꞌ síꞌ rian rugutsi̱. Ni̱ ri̱an gaguáj nucuaj ni sij, ni̱ guiriꞌ ni sij si huin ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ni̱ gataj Pilato sisi̱ gui̱ꞌyaj ni sij si huin ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ngaa ni̱ guiri Pilato tsínj nu̱n ducuaga̱ꞌ daj huin síꞌ tsínj gununꞌ nga̱ ni tsínj nicaj sun. Ni̱ huin síꞌ tsínj dagahuiꞌ níman nej. Ngaa ni̱ nagaꞌuiꞌ Pilato manꞌan Jesús rian ni sij sisi̱ gui̱ꞌyaj ni sij si huin ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ni̱ ngaa nicaj ni sij Jesús ganꞌanj ni sij, ni̱ guidaꞌa ni sij ꞌngo̱ tsínj ꞌna̱ꞌ xumanꞌ Cirene gu̱ꞌnaj síꞌ Simón. Ni̱ ꞌna̱ꞌ niqui síꞌ ganꞌanj síꞌ rian sun. Ni̱ guiꞌyaj ni sij ga̱ta síꞌ rugutsi̱ gui̱nicoꞌ síꞌ rucú Jesús. ");
INSERT INTO trq_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ni̱ nicoꞌ nico ni ngüi̱ huaj ni sij rucú Jesús. Ni̱ ducu aco ni yunꞌunj xa̱na nicoꞌ huaj rucú sij. Ni̱ nani ruhua ne niꞌyaj ne xiꞌí sij. ");
INSERT INTO trq_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Sani̱ nanica̱j Jesús ni̱ gataj sij gunun ni yunꞌunj xa̱na daj: ―Gu̱nun ni é re̱ꞌ huin a ni é re̱ꞌ ni ngüi̱ ꞌna̱ꞌ xumanꞌ Jerusalén. Si̱ gaco ni é re̱ꞌ xiꞌīj mánj. Sani̱ ga̱co ni é re̱ꞌ xiꞌí manꞌan ni é re̱ꞌ nga̱ xiꞌí ni daꞌníj ni é re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Daj si ga̱ꞌnaꞌ ni güi gui̱ranꞌ ni é re̱ꞌ sayun. Ni̱ ga̱taj ni ngüi̱: “Hua ꞌueé rian ni ngüi̱ yatin nga̱ ni ngüi̱ nun riꞌ lij nej, ni ngüi̱ nun guinicoꞌ lij xíꞌyanj nej.” Daj ga̱taj ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Daj si güi daj ni̱ ga̱xiꞌi ni ngüi̱ ga̱taj sisi̱ ga̱ne ni quij, ni̱ na̱xij ni sij riqui quij gane daj, ga̱taj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ni̱ sisi̱ ranꞌ manꞌānj nico sayun ꞌyaj ni sij acuanꞌ, sani̱ ni güi ga̱ꞌnaꞌ, ni̱ ducu ga̱ꞌnaꞌ doj sayun rian ni sij aj. ―Daj gataj Jesús rian ni yunꞌunj daj. ");
INSERT INTO trq_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ni̱ hué daj nicaj ni sij hui̱j tsínj daꞌui gaquinꞌ ganꞌanj ni sij sisi̱ ga̱huiꞌ nu̱guanꞌan nu̱ngüej síꞌ nga̱ Jesús. ");
INSERT INTO trq_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ni̱ ngaa guisíj ni sij ꞌngo̱ yuꞌuj gu̱ꞌnaj cúj chra̱ níman, ni̱ gari ni sij gaquíj Jesús doco̱ꞌ ni sij rian rugutsi̱ síꞌ yuꞌuj daj. Ni̱ hué daj doco̱ꞌ ni sij hui̱j tsínj daꞌui gaquinꞌ daj rian yahuij rugutsi̱. Ni̱ nicoꞌ ꞌngo̱j raꞌa sa̱ꞌ Jesús, ni̱ angoj raꞌa ro̱tsi sij. ");
INSERT INTO trq_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Hué dan ni̱ gataj Jesús gunun Yanꞌanj: ―Tata chréꞌ, ni̱caj re̱ꞌ ꞌngo̱ niman nico nga̱ ni sij. Daj si nun niꞌi ni sij si ꞌyaj ni sij. ―Daj gataj Jesús gunun Yanꞌanj. Ni̱ ducu ni snado sisi̱ u̱n tsínj ga̱hui sa̱ꞌ ni̱caj ni sij si-ganꞌ Jesús ga̱nꞌanj sij. ");
INSERT INTO trq_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ni̱ niquinꞌ ni ngüi̱ niꞌyaj ni sij. Sani̱ guiꞌyaj ducu ni tsínj nicaj sun. Ni̱ gataj ni sij: ―Nacaj sij ango ni ngüi̱. Ngaa ni̱ sisi̱ hué sij huin Cristo tsínj nacui Yanꞌanj, ngaa ni̱ ga̱nacaj sij manꞌan sij nánj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ni̱ hué daj gaꞌmi ducu ni snado nej. Ni̱ gahuin ni̱chrunꞌ ni sij. Ni̱ reque̱ ni sij nnee yu̱ go̱ꞌo síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ni̱ gataj ni sij: ―Sisi̱ hué re̱ꞌ huin si-rey ni tsínj israelita, ni̱ ga̱nacaj re̱ꞌ manꞌán re̱ꞌ aj. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ni̱ garun ni sij letra chra̱ rugutsi̱. Ni̱ letra daj huin griego nga̱ latín nej, hebreo nej. Ni̱ letra daj gataj: “tsínj nan huin si-rey ni tsínj judíos.” Daj garun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ngaa ni̱ gaꞌmi quij ꞌngo̱ tsínj daꞌui gaquinꞌ daj gunun Jesús. Ni̱ gataj síꞌ: ―Sisi̱ hué re̱ꞌ huin Cristo, ni̱ ga̱nacaj re̱ꞌ manꞌán re̱ꞌ nga̱ nu̱ngüej únj nej. ―Daj gataj síꞌ gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Sani̱ chranꞌ yunꞌunj ango tsínj nicoꞌ yuꞌuj daj dugüiꞌ sij huin sij ꞌngo̱ tsínj daꞌui gaquinꞌ nej. Ni̱ gataj sij: ―Uyan huin si-castigo manꞌán re̱ꞌ nga̱ si-castigo tsínj nan nej. Ni̱ u̱n sin huin ni̱ nitaj si xuꞌuíꞌ re̱ꞌ niꞌyáj re̱ꞌ Yanꞌanj únj. ");
INSERT INTO trq_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ni̱ hua nia̱n xa̱ngaꞌ ranꞌ nu̱ngüej únj sayun xiꞌí si daꞌui nu̱ngüej únj gaquinꞌ. Sani̱ nitaj si daꞌui tsínj nan gaquinꞌ mánj. ―Daj gataj ango tsínj daꞌui gaquinꞌ gunun dugüiꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ngaa ni̱ gataj sij rian Jesús: ―Ga̱nanun ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ yūnj ngaa ga̱xiꞌi gui̱nicaj sún re̱ꞌ. ―Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ngaa ni̱: ―Xa̱ngaꞌ ataj yyāj gu̱nun re̱ꞌ sisi̱ asi̱j yya̱j, ni̱ hua nné re̱ꞌ ngāj xánj Yanꞌanj. ―Gataj Jesús gunun tsínj daꞌui gaquinꞌ daj. ");
INSERT INTO trq_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ni̱ ngaa guisíj gaxu̱j, ni̱ gahuin ru̱miꞌ rian daranꞌ xungüi̱. Ni̱ gahuin ru̱miꞌ daꞌ ga hua̱ꞌnij diꞌni̱. ");
INSERT INTO trq_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ni̱ gahuin ru̱miꞌ rian güi. Ni̱ tsitsiꞌ daꞌaj atsij nicoꞌ chruhua nuhui nico. ");
INSERT INTO trq_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ngaa ni̱ gaguáj nucuaj Jesús. Ni̱ gataj sij: ―Tata chréꞌ, nariquīj nimānj na̱huin raꞌá re̱ꞌ. ―Gataj Jesús. Ni̱ ngaa daꞌngaꞌ daj gataj sij, ni̱ gahuiꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ni̱ ngaa guiniꞌi snado centurión si gahuin, ni̱ gaꞌmi sa̱ꞌ sij rian Yanꞌanj. Ni̱ gataj sij: ―Xa̱ngaꞌ hua ni̱ca niman tsínj nan anj. ―Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ni̱ ngaa guiniꞌi daranꞌ ni ngüi̱ mán yuꞌuj daj da̱j gahuin, ni̱ nanica̱j ni sij na̱nꞌ ni sij ducuá ni sij. Ni̱ guita raꞌa ni sij niman ni sij si nun nariꞌ ruhua ni sij si gui̱ꞌyaj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ni̱ daranꞌ ni tsínj nicaj dugüiꞌ nga̱ Jesús nga̱ ni yunꞌunj xa̱na nicoꞌ Jesús asi̱j estado Galilea, ni̱ guna ga̱nꞌ ni sij niꞌyaj ni sij daranꞌ si gahuin. ");
INSERT INTO trq_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ni̱ hua ꞌngo̱ tsínj nne rian junta nico daj. Ni̱ gu̱ꞌnaj síꞌ José. Ni̱ ꞌna̱ꞌ sij xumanꞌ Arimatea xumanꞌ ngaj estado Judea. Ni̱ hua sa̱ꞌ niman sij. Ni̱ ꞌyaj ni̱ca sij nej. ");
INSERT INTO trq_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ni̱ anaꞌuij sij si ga̱ꞌnaꞌ gui̱nicaj sun Yanꞌanj rian néꞌ. Ni̱ nun ga̱ranꞌ ruhua sij si gaꞌmi ni tsínj ma̱n junta daj xiꞌí Jesús. Ni̱ hué daj nun ga̱ranꞌ ruhua sij si guiꞌyaj ni sij nga̱ síꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ni̱ ganꞌanj sij rian Pilato. Ni̱ gachínj sij níman Jesús. ");
INSERT INTO trq_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ngaa ni̱ nanij sij níman Jesús rian rugutsi̱. Ni̱ chriꞌyanj sij atsij xiráj níman daj. Ni̱ gurúj sij níman chruhua ꞌngo̱ huej. Sani̱ ni̱ a̱ ꞌngo̱ ni níman nun gachinꞌ ni sij riqui yuꞌuj da mánj. ");
INSERT INTO trq_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ni̱ güi daj huin güi ꞌyaj xugüi ni sij güi naránj ruhua ni sij. Ni̱ achin do̱j si gui̱sij güi naránj ruhua ni sij daj. ");
INSERT INTO trq_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ni̱ nicoꞌ ni yunꞌunj xa̱na gahui estado Galilea nga̱ Jesús rucú tsínj gu̱ꞌnaj José. Ni̱ guiniꞌi ne rian gachinꞌ ni sij níman Jesús. Ni̱ guiniꞌi ne da̱j gurúj ni sij níman daj chruhua yuꞌuj nej. ");
INSERT INTO trq_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ni̱ ngaa nanica̱j ne na̱nꞌ ne ducuá ne, ni̱ nachej ne gasiti guinꞌ da̱j nga̱ gonoꞌó guinꞌ da̱j. Ni̱ naránj ruhua ne güi naránj ruhua ni ngüi̱ israelita da̱j rúnꞌ aꞌninꞌ ley rian ni sij. ");
INSERT INTO trq_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ni̱ ngaa ruhua guere̱ngaꞌ ni̱ganꞌ acuanꞌ güi gudungu, ngaa ni̱ ganꞌanj ni yunꞌunj xa̱na daj rian yuꞌuj gachinꞌ ni sij níman. Ni̱ nicaj ne gasiti guinꞌ da̱j hua naguiꞌyaj ne ganꞌanj ne. Ni̱ ganꞌanj ango ni yunꞌunj xa̱na nga̱ ne nej. ");
INSERT INTO trq_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ni̱ nariꞌ ne sisi̱ nitaj si ngaj yej xa̱chij hua ránj rian huej daj. ");
INSERT INTO trq_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ni̱ gatúj ne chruhua huej. Sani̱ nun na̱riꞌ ne níman Señor Jesús mánj. ");
INSERT INTO trq_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ni̱ nun nariꞌ ruhua ne u̱n sin gahuin. Ngaa ni̱ niquinꞌ nu̱guanꞌan hui̱j tsínj rian ne. Ni̱ ran atsij nu̱n nu̱ngüej síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ni̱ guxuꞌuiꞌ ne. Ni̱ gaꞌ nitu rian ne rian yoꞌój. Xiꞌí daj ni̱ gataj nu̱ngüej tsínj daj gunun ne: ―Ni̱ u̱n sin huin ni̱ nanaꞌuiꞌ a ni é re̱ꞌ tsínj hua ni̱ꞌnaꞌ scanij ni níman únj. ");
INSERT INTO trq_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nitaj si ngaj sij yuꞌuj nan ga̱ mánj. Daj si hua ganáꞌnij sij. Na̱nun ruhua á re̱ꞌ si gataj sij rian án re̱ꞌ ngaa gane sij estado Galilea. ");
INSERT INTO trq_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ni̱ gataj sij gunun a ni é re̱ꞌ: “Hua nia̱n sisi̱ na̱gaꞌuiꞌ ni sij manꞌānj raꞌa ni tsínj ꞌyaj gaquinꞌ. Ni̱ ga̱ri ni sij gaquíj manꞌānj rian rugutsi̱. Ngaa ni̱ ga̱naꞌnī ngaa gui̱sij hua̱ꞌnij güi huīnj daꞌníj ni ngüi̱.” Hué daj gataj Jesús gunun a ni é re̱ꞌ. ―Daj gataj nu̱ngüej tsínj daj gunun ni yunꞌunj xa̱na. ");
INSERT INTO trq_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ngaa ni̱ nanun ruhua ne niꞌyaj ne nuguanꞌ gaꞌmi Jesús. ");
INSERT INTO trq_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ngaa ni̱ nanica̱j ne rian huej daj. Ni̱ nataꞌ ne ni nuguanꞌ daj rian ni xa̱n ni tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj nga̱ rian ango ni ngüi̱ nej. ");
INSERT INTO trq_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ni̱ ni yunꞌunj xa̱na daj huin María Magdalena nga̱ Juana nej, María nni Jacobo nej, ango ni yunꞌunj xa̱na nej. Ni̱ nataꞌ ne nuguanꞌ daj rian ni tsínj gaꞌmi si-nu̱guanꞌ Jesús rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Sani̱ ngaa gunun ni sij nuguanꞌ daj, ni̱ gani ruhua ni sij sisi̱ aꞌmi sinúnj ni yunꞌunj daj. Ni̱ nun gu̱xuman ruhua ni sij si gataj ne. ");
INSERT INTO trq_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Sani̱ naxu̱man Pedro gunánj sij ganꞌanj sij rian huej. Ni̱ gaꞌ nitu sij niꞌyaj sij chruhua yuꞌuj daj. Ni̱ ngaj urin atsij chruhua huej daj guiniꞌi sij. Ngaa ni̱ nanica̱j sij na̱nꞌ sij ducuá sij. Sani̱ nun riꞌ ruhua sij u̱n sin gui̱ꞌyaj sij nga̱ si guiniꞌi sij. ");
INSERT INTO trq_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ni̱ hué güi daj ni̱ huaj hui̱j tsínj nicoꞌ Jesús ganꞌanj nu̱ngüej sij ꞌngo̱ xumanꞌ gu̱ꞌnaj Emaús. Ni̱ huin ngaj-áꞌ xumanꞌ Jerusalén ꞌngo̱ si xa̱n kilómetro. ");
INSERT INTO trq_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ni̱ nari snanꞌanj nu̱ngüej sij huaj sij xiꞌí si gahuin guiranꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ni̱ diaj hua gue̱ aꞌmi nu̱ngüej sij, ni̱ gahuin ni̱chrunꞌ Jesús rian nu̱ngüej sij. Ni̱ chéj Jesús nga̱ nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Sani̱ nu̱nj si niꞌyaj nu̱ngüej sij manꞌan síꞌ, sani̱ nun gaꞌuiꞌ Yanꞌanj sisi̱ na̱niꞌi nu̱ngüej sij sisi̱ Jesús huin huaj nga̱ nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ngaa ni̱ nachínj snanꞌanj Jesús nu̱ngüej sij. Ni̱ gataj sij: ―Ni̱ u̱n sin huin si aꞌmi nu̱ngüej é re̱ꞌ huaj á re̱ꞌ chrej únj. Ni̱ u̱n sin huin ni̱ nani ruhua á re̱ꞌ únj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ngaa ni̱ gataj ꞌngo̱ tsínj daj ꞌngo̱ tsínj gu̱ꞌnaj Cleofas: ―Hua gaꞌi̱ tsínj ꞌna̱ꞌ anéj chrej nne xumanꞌ Jerusalén ni güi nan. Ni̱ u̱n sin huin ni̱ urin manꞌán re̱ꞌ nun niꞌi da̱j gahuin ni güi gachin nan únj. ―Daj gataj Cleofas. ");
INSERT INTO trq_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ngaa ni̱: ―Ni̱ u̱n sin gahuin únj. ―Gataj Jesús. Ngaa ni̱ gataj nu̱ngüej sij: ―Hué Jesús nazareno gahuin ꞌngo̱ tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj rian ni ngüi̱. Ni̱ guiꞌyaj sa̱ꞌ sij. Ni̱ ducu nucuaj si-nu̱guanꞌ sij rian Yanꞌanj nga̱ rian daranꞌ ni ngüi̱ nej. ");
INSERT INTO trq_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ni̱ gaꞌninꞌ sun ni chrej aꞌninꞌ nga̱ ni tsínj nicaj sun sisi̱ ga̱huiꞌ Jesús gui̱nicoꞌ sij rian rugutsi̱. ");
INSERT INTO trq_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ni̱ ganaꞌuij ni únj sisi̱ hué sij huin tsínj ꞌna̱ꞌ na̱caj ni ngüi̱ israelita. Sani̱ guiranꞌ sij sayun daj. Ni̱ yya̱j guisíj hua̱ꞌnij güi si gahuiꞌ sij. ");
INSERT INTO trq_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ni̱ guixigui̱n ganꞌanj go̱ꞌngo yunꞌunj xa̱na nicaj dugüiꞌ nga̱ ni únj rian gachinꞌ Jesús. Ni̱ gara yanꞌanj ruhua ni únj xiꞌí si gataj ne gunun únj. ");
INSERT INTO trq_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ni̱ ri̱an nun nariꞌ ne Jesús, ni̱ nanica̱j ne rian ni únj. Ni̱ nataꞌ ne gunun ni únj sisi̱ gurugüiꞌ hui̱j ángel rian ne. Ni̱ gataj nu̱ngüej ángel daj gunun ne sisi̱ hua ni̱ꞌnaꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Hué dan ni̱ ganꞌanj go̱ꞌngo ni dugüiꞌ ni únj rian gachinꞌ Jesús. Ni̱ nariꞌ aninꞌ sij da̱j rúnꞌ gataj ni yunꞌunj daj. Sani̱ nun guiniꞌi aninꞌ sij manꞌan Jesús mánj. ―Daj gataj nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ngaa ni̱ gataj Jesús gunun nu̱ngüej sij: ―Tsínj nun acaj cuenta huin nu̱ngüej é re̱ꞌ. Ni̱ naꞌue gu̱xuman yoo̱ ruhua nu̱ngüej é re̱ꞌ nga̱ si garun ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Sé si xa̱ngaꞌ si hua nia̱n gui̱ranꞌ Cristo sayun ngaa achin na̱tu sij rian hua ꞌueé xataꞌ ga̱ne sij únj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ngaa ni̱ gaxi̱ꞌi sij gaꞌmi sij xiꞌí si-nu̱guanꞌ Moisés nga̱ si-nu̱guanꞌ ango ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. Ni̱ gataj sij gunun nu̱ngüej síꞌ daranꞌ si ataj si-nu̱guanꞌ Yanꞌanj xiꞌí manꞌan sij. ");
INSERT INTO trq_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ni̱ ngaa guisíj nu̱ngüej sij xumanꞌ huaj nu̱ngüej sij, ni̱ guiꞌyaj Jesús sisi̱ ga̱taꞌ dian síꞌ ga̱nꞌanj síꞌ rian nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Sani̱ guereque̱ nu̱ngüej sij sisi̱ gu̱naj síꞌ. Ni̱ gataj nu̱ngüej sij: ―Gu̱ná re̱ꞌ nga̱ únj si hua gahuin diꞌni̱, ni̱ hua guini̱ nej. ―Gataj nu̱ngüej sij gunun Jesús. Ngaa ni̱ gatúj Jesús guna síꞌ nga̱ nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ni̱ ngaa nne Jesús rian mesa nga̱ nu̱ngüej sij, ni̱ guidaꞌa síꞌ chrachrúnj. Ni̱ gaꞌuiꞌ síꞌ si guruhua Yanꞌanj. Ni̱ guraꞌ daꞌaj síꞌ gaꞌuiꞌ síꞌ raꞌa nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ngaa ni̱ hué gue̱ hora daj xacaj cuenta nu̱ngüej sij guiniꞌi nu̱ngüej sij sisi̱ Jesús huin. Sani̱ hué hora daj ni̱ ganꞌanj niꞌya yanꞌanj síꞌ rian nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ngaa ni̱ nachínj snanꞌanj nu̱ngüej manꞌan sij dugüiꞌ sij. Ni̱ gataj nu̱ngüej sij: ―Xa̱ngaꞌ ni̱ gahuin nia̱ꞌ róꞌ ngaa gaꞌmi sij nga̱ néꞌ ngaa huaj néꞌ chruhua chrej. Ni̱ gahuin nia̱ꞌ ruhua néꞌ ngaa digyán sij si-nu̱guanꞌ Yanꞌanj riúnꞌ nej. ―Daj gataj nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ngaa ni̱ hué hora daj, ni̱ naxu̱man nu̱ngüej sij ganꞌanj nu̱ngüej sij xumanꞌ Jerusalén. Ni̱ nariꞌ nu̱ngüej sij xa̱n ni tsínj mán nahuin yuꞌ nga̱ ni dugüiꞌ ni síꞌ nej. ");
INSERT INTO trq_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ni̱ gataj ni síꞌ: ―Xa̱ngaꞌ ni̱ ganáꞌnij Señor. Ni̱ gurugüiꞌ sij rian Simón. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ngaa ni̱ nataꞌ nu̱ngüej sij da̱j gahuin guiniꞌi nu̱ngüej sij Jesús chruhua chrej. Ni̱ nataꞌ nu̱ngüej sij da̱j naniꞌi nu̱ngüej sij Jesús ngaa guraꞌ daꞌaj síꞌ chrachrúnj gaꞌuiꞌ síꞌ xa̱ nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ni̱ ngaa hua gue̱ aꞌmi ni sij nuguanꞌ daj, ni̱ gurugüiꞌ Jesús ganiquinꞌ sij scanij ni sij. Ni̱ gataj síꞌ gunun ni sij: ―Ga̱huin dinꞌinj ruhua á re̱ꞌ aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ngaa ni̱ ducu guxuꞌuiꞌ ni sij. Ni̱ gani ruhua ni sij sisi̱ guiniꞌi ni sij ꞌngo̱ staꞌnaj. ");
INSERT INTO trq_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Sani̱ gataj Jesús: ―Ni̱ u̱n sin huin ni̱ nani ruhua á re̱ꞌ únj. Ni̱ u̱n sin huin ni̱ nitaj si mán yya ruhua niman án re̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ni̱ꞌyaj á re̱ꞌ raꞌāj nga̱ dacō. Ni̱ xa̱caj á re̱ꞌ cuenta sisi̱ hué manꞌānj huin. Gui̱daꞌa á re̱ꞌ, ni̱ ni̱ꞌyaj á re̱ꞌ. Daj si ꞌngo̱ staꞌnaj nitaj nne̱ cúj da̱j rúnꞌ hua manꞌānj nan mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ni̱ ngaa guisíj gaꞌmi Jesús nuguanꞌ daj, ni̱ digyán sij raꞌa sij nga̱ dacój sij rian ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Sani̱ nun gu̱xuman ruhua ni sij xiꞌí si ducu huin nia̱ꞌ ruhua ni sij. Ni̱ garáj yanꞌanj ruhua ni sij nej. Ngaa ni̱ nachínj snanꞌanj Jesús ni sij. Ni̱ gataj síꞌ: ―Nicaj á re̱ꞌ si xo̱ꞌ níꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ngaa ni̱ gaꞌuiꞌ ni sij do̱j nnee̱ xucuaj nitin nga̱ do̱j gatsiꞌ xutan xa síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ni̱ guidaꞌa sij, ni̱ xa sij rian ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ngaa ni̱ gataj sij: ―Hué nan huin nuguanꞌ gaꞌmī nga̱ ni é re̱ꞌ ngaa ganēj nga̱ á re̱ꞌ. Ni̱ gatā gunun a ni é re̱ꞌ sisi̱ hua nia̱n ga̱huin yya ni nuguanꞌ xiꞌīj da̱j rúnꞌ garun Moisés nga̱ ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná nga̱ ni tsínj garun libro Salmo nej. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Hué dan ni̱ gara daꞌngaꞌ ruhua ni sij si ataj si-nu̱guanꞌ Yanꞌanj, guiꞌyaj Jesús. ");
INSERT INTO trq_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ni̱ gataj Jesús: ―Gataj si-nu̱guanꞌ Yanꞌanj sisi̱ gui̱ranꞌānj sayun, huīnj Cristo. Ni̱ ga̱huīj. Sani̱ ga̱naꞌnī chra̱ hua̱ꞌnij güi. ");
INSERT INTO trq_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ngaa ni̱ ga̱ꞌmi ni sij ni nuguanꞌ sa̱ꞌ xiꞌīj rian daranꞌ ni ngüi̱ ma̱n chruhua xungüi̱. Ngaa ni̱ ga̱nani ruhua ni sij xiꞌí si-ga̱quinꞌ ni sij na̱nicoꞌ ni sij Yanꞌanj. Hué dan ni̱ gui̱nicaj Yanꞌanj ꞌngo̱ niman nico xiꞌí si-ga̱quinꞌ ni sij. Ni̱ ga̱xiꞌi ni sij xumanꞌ Jerusalén na̱taꞌ ni sij nuguanꞌ da aj. ");
INSERT INTO trq_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ni̱ huin a ni é re̱ꞌ ni tsínj guiniꞌi daranꞌ si guiꞌyā. Ngaa ni̱ ga̱ꞌue gui̱niquinꞌ a ni é re̱ꞌ na̱taꞌ a ni é re̱ꞌ xiꞌí ni nuguanꞌ sa̱ꞌ nan. ");
INSERT INTO trq_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ngaa ni̱ ri̱quīj Espíritu Santo rian ni é re̱ꞌ da̱j rúnꞌ gataj yya chrē rian án re̱ꞌ. Sani̱ gu̱na á re̱ꞌ xumanꞌ Jerusalén nan da na̱huin raꞌa na̱riꞌ nucuaj niman án re̱ꞌ, gui̱ꞌyaj Yanꞌanj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ngaa ni̱ nicaj Jesús ni sij ganꞌanj síꞌ xumanꞌ Betania. Ngaa ni̱ nachi nicaj síꞌ raꞌa síꞌ. Ni̱ gachínj jniꞌyaj síꞌ rian Yanꞌanj sisi̱ gui̱ꞌyaj sa̱ꞌ Yanꞌanj nga̱ ni sij. ");
INSERT INTO trq_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ni̱ diaj hua gue̱ aꞌmi sa̱ꞌ síꞌ daj, ni̱ gahuin ni̱ni síꞌ rian ni sij. Ni̱ na̱nꞌ síꞌ xataꞌ, guiꞌyaj Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ngaa guisíj gaꞌmi sa̱ꞌ ꞌueé ni sij xiꞌí Jesús, ni̱ nanica̱j ni sij ganꞌanj ni sij xumanꞌ Jerusalén. Ni̱ ducu gahuin nia̱ꞌ ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ni̱ ni̱ganj mán ni sij nuhui nico gaꞌmi sa̱ꞌ ni sij rian Yanꞌanj. Ni̱ gataj ni sij sisi̱ sa̱ꞌ ꞌyaj Yanꞌanj anj. Amén.");
INSERT INTO trq_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Asi̱j sini ya̱n ni̱ nne tsínj gu̱ꞌnaj nuguanꞌ daj. Ni̱ nne síꞌ nga̱ Yanꞌanj xa̱ngaꞌ. Ni̱ huin síꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ni̱ nuguanꞌ daj nne asi̱j sini ya̱n nga̱ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ni̱ gaꞌninꞌ Yanꞌanj xa̱ngaꞌ sun sisi̱ gui̱ꞌyaj nuguanꞌ daj daranꞌ ni rasu̱n mán. Ni̱ sisi̱ nitaj nuguanꞌ daj, ni̱ a̱ ꞌngo̱ rasu̱n si̱ gaꞌue gui̱man mánj. ");
INSERT INTO trq_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ni̱ nuguanꞌ daj guiꞌyaj sisi̱ ga̱huin ni̱ꞌnaꞌ ni rasu̱n. Ni̱ xiꞌí si hua ni̱ꞌnaꞌ néꞌ, guiꞌyaj nuguanꞌ daj, ni̱ xigui̱n mán néꞌ. ");
INSERT INTO trq_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ni̱ yanꞌa̱n daj huin si xigui̱n rian ru̱miꞌ mán néꞌ. Ni̱ rian ru̱miꞌ daj nun ga̱ꞌue gui̱naꞌaj yanꞌa̱n da mánj. ");
INSERT INTO trq_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ni̱ gaꞌníj Yanꞌanj ga̱ꞌnaꞌ ꞌngo̱ tsínj gu̱ꞌnaj Juan. ");
INSERT INTO trq_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ni̱ gaꞌna̱ꞌ síꞌ gahuin síꞌ ꞌngo̱ tsínj nataꞌ xiꞌí yanꞌa̱n daj. Ngaa ni̱ gu̱xuman ruhua daranꞌ ni ngüi̱ ni̱ꞌyaj ni sij yanꞌa̱n daj xiꞌí nuguanꞌ nataꞌ síꞌ huin ruhua síꞌ na̱taꞌ síꞌ gu̱nun ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Sé Juan huin yanꞌa̱n xigui̱n da mánj. Sani̱ maan si gaꞌna̱ꞌ sij gahuin sij tsínj nataꞌ xiꞌí yanꞌa̱n daj. ");
INSERT INTO trq_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ni̱ yanꞌa̱n daj huin yanꞌa̱n xa̱ngaꞌ. Ni̱ gaꞌna̱ꞌ yanꞌa̱n daj xigui̱n rian daranꞌ ni ngüi̱ mán chruhua xungüi̱ nan anj. ");
INSERT INTO trq_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ni̱ tsínj huin yanꞌa̱n daj gane chruhua xungüi̱. Ni̱ nu̱nj si guiꞌyaj sij xungüi̱ nan, sani̱ nun na̱niꞌi ni ngüi̱ sij mánj. ");
INSERT INTO trq_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ni̱ gaꞌna̱ꞌ sij rian ma̱n ni dugüiꞌ sij, sani̱ nun nahuin raꞌa ni síꞌ sij mánj. ");
INSERT INTO trq_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Sani̱ daranꞌ ni ngüi̱ nahuin raꞌa sij, ni̱ gu̱xuman ruhua ni síꞌ ni̱ꞌyaj ni síꞌ si-xugui sij, ni riqui sij sisi ga̱huin ni síꞌ daꞌníj manꞌan Yanꞌanj xa̱ngaꞌ. ");
INSERT INTO trq_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ni̱ sé tun manꞌan nni ni síꞌ nga̱ chrej ni síꞌ gaꞌnga ni síꞌ mánj. Ni̱ sé xiꞌí si huin ruhua ꞌngo̱ tsínj, ni̱ gaꞌnga ni síꞌ mánj. Sani̱ Yanꞌanj guiꞌyaj sisi̱ ga̱huin ni síꞌ daꞌníj manꞌan Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ni̱ nuguanꞌ daj gahuin ꞌngo̱ tsínj gane scanij néꞌ. (Ni̱ guiniꞌi ni únj sisi̱ hua ꞌueé ni̱nꞌ ruhua sij nej. Daj si urin sij huin daꞌníj chrej sij.) Ni̱ ducu guiꞌyaj sij sinduj rian xiꞌí néꞌ. Ni̱ ni̱nanj nuguanꞌ xa̱ngaꞌ gaꞌmi sij nej. ");
INSERT INTO trq_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ni̱ gaꞌmi sa̱ꞌ Juan rian ni ngüi̱ xiꞌí sij. Ni̱ nucuaj gaꞌmi síꞌ. Ni̱ gataj síꞌ: ―Hua gataj snanꞌān gunun a ni é re̱ꞌ sisi̱ tsínj ꞌna̱ꞌ da rucūj, ni̱ gahuin achij sij rian manꞌānj. Daj si asi̱j achin gaꞌnga manꞌānj, ni̱ hua gane sij aj. ―Daj gataj Juan gunun ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ni̱nanj nuguanꞌ sa̱ꞌ nicaj sij gaꞌna̱ꞌ sij. Ni̱ nico̱ꞌ huaj ꞌyaj sij sinduj rian daranꞌ néꞌ. ");
INSERT INTO trq_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ni̱ gaꞌuiꞌ Moisés si-ley Yanꞌanj rian ni ngüi̱. Sani̱ gaꞌna̱ꞌ Jesucristo digyán síꞌ rian néꞌ da̱j huin sinduj ꞌyaj Yanꞌanj nga̱ néꞌ. Ni̱ digyán síꞌ rian néꞌ da̱j hua nuguanꞌ xa̱ngaꞌ nej. ");
INSERT INTO trq_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ni̱ a̱ ꞌngo̱ ni ngüi̱ nun gui̱niꞌi Yanꞌanj mánj. Ni̱ nne nu̱guanꞌan nu̱ngüej chrej Jesús huin Yanꞌanj. Ni̱ Jesús huin urin daꞌníj Yanꞌanj. Ni̱ hué Jesús huin si digyán rian néꞌ da̱j hua Yanꞌanj gui̱niꞌi néꞌ. ");
INSERT INTO trq_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ni̱ gaꞌníj ni tsínj israelita nne xumanꞌ Jerusalén go̱ꞌngo chrej nga̱ go̱ꞌngo ni tsínj levita ga̱nꞌanj ni síꞌ rian Juan. Ni̱ gachínj snanꞌanj ni síꞌ sij. Ni̱ gataj ni síꞌ: ―Ni̱ u̱n tsínj huín re̱ꞌ. ―Daj gataj ni síꞌ. Ni̱ gaꞌmi Juan ni nuguanꞌ nan rian ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ni̱ nun ga̱taj sij sisi̱ Cristo huin sij. Sani̱ gataj yya sij: ―Sēj huin Cristo mánj. ―Daj gataj Juan gunun ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ngaa ni̱ nachínj snanꞌanj ni tsínj daj sij. Ni̱ gataj ni sij: ―Ngaa ni̱ hué re̱ꞌ huin tsínj gu̱ꞌnaj Elías níꞌ. ―Daj gataj ni sij. ―Sēj huin mánj. ―Gataj Juan. ―Hué re̱ꞌ huin tsínj ga̱ꞌnaꞌ ga̱ꞌmi si-nu̱guanꞌ Yanꞌanj níꞌ. ―Gataj ni sij. ―Sēj huin mánj. ―Gataj Juan. ");
INSERT INTO trq_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ngaa ni̱: ―Ni̱ u̱n tsínj huin yyá re̱ꞌ únj. Daj si hua nia̱n na̱taꞌ ni únj gu̱nun ni tsínj gaꞌníj ga̱ꞌnaꞌ ni únj rián re̱ꞌ aj. Ni̱ u̱n sin huin atáj re̱ꞌ xiꞌí manꞌán re̱ꞌ únj. ―Daj gataj ni sij gunun Juan. ");
INSERT INTO trq_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ngaa ni̱ gataj Juan gunun ni sij: ―Huēj huin tsínj aꞌmi nucuaj quij quiꞌyanj na̱co. Ni̱ ataj manꞌānj gu̱nun ni ngüi̱: “Na̱guiꞌyaj ni̱ca á re̱ꞌ niman án re̱ꞌ xiꞌí si ga̱ꞌnaꞌ Señor rian án re̱ꞌ.” Daj si daꞌngaꞌ daj gataj Isaías, tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. ―Daj gataj Juan gunun ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ni̱ daꞌaj ni tsínj ganꞌanj ga̱ꞌmi nga̱ Juan huin tsínj fariseo. ");
INSERT INTO trq_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ni̱ nachínj snanꞌanj ni síꞌ Juan. Ni̱ gataj ni síꞌ: ―Sé re̱ꞌ huin Cristo. Ni̱ sé re̱ꞌ huin Elías. Ni̱ sé re̱ꞌ huin tsínj ga̱ꞌnaꞌ ga̱ꞌmi si-nu̱guanꞌ Yanꞌanj rian ni ngüi̱. Ngaa ni̱ u̱n sin huin ni̱ duguataꞌ nneé re̱ꞌ ni ngüi̱ únj. ―Daj gataj ni tsínj daj gunun Juan. ");
INSERT INTO trq_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ngaa ni̱ gataj Juan gunun ni sij: ―Duguataꞌ nnee manꞌānj ni ngüi̱ nga̱ nnee. Sani̱ scanij ni é re̱ꞌ niquinꞌ ꞌngo̱ tsínj nun niꞌi ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ni̱ hué sij huin tsínj ꞌna̱ꞌ da rucūj. Sani̱ huin achij sij daj nga̱ manꞌānj. Ni̱ xiꞌí si huin achij sij, ni̱ na̱ꞌaj yānj gui̱rīj dacánj sij ngaa ni̱naj sij. ―Daj gataj Juan gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ni̱ hué nan gahuin anéj chrej xinéj nnee gu̱ꞌnaj Jordán rian gu̱ꞌnaj Betábara. Daj si hué yuꞌuj daj duguataꞌ nnee Juan ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Hué dan ni̱ ango güi guiniꞌi Juan sisi̱ gaꞌna̱ꞌ Jesús rian sij. Ni̱ gataj Juan: ―Ni̱ꞌyaj á re̱ꞌ. Hué tsínj nan huin xachij ꞌni̱j ꞌna̱ꞌ rian Yanꞌanj sisi̱ ga̱ꞌne sij gaquinꞌ daꞌui ni ngüi̱ ma̱n chruhua xungüi̱. ");
INSERT INTO trq_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ni̱ gaꞌmī xiꞌí tsínj nan. Ni̱ gatā gunun ni é re̱ꞌ: “Da rucūj, ni̱ ga̱ꞌnaꞌ ꞌngo̱ tsínj huin achij daj nga̱ manꞌānj. Daj si hua nne sij asi̱j ngaa achin gaꞌngā. ");
INSERT INTO trq_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ni̱ nun gui̱niꞌīnj u̱n tsínj huin sij. Sani̱ gaꞌnāj du̱guataꞌ nnēj ni ngüi̱ sisi̱ gui̱niꞌi ni ngüi̱ israelita da̱j hua sij.” ―Daj gataj Juan gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ni̱ gataj ru̱huaꞌ yún Juan xiꞌí si guiniꞌi sij: ―Ni̱ guiniꞌīnj sisi̱ ꞌna̱ꞌ guinij Espíritu Santo xataꞌ. Ni̱ da̱j rúnꞌ hua ꞌngo̱ xuꞌma̱n hua-áꞌ guinij-íꞌ rian Jesús. Ni̱ gunáj-áꞌ nga̱ sij. ");
INSERT INTO trq_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ni̱ nun gui̱niꞌīnj u̱n tsínj huin sij. Sani̱ si gaꞌníj yūnj du̱guataꞌ nnēj ni ngüi̱, ni̱ gataj sij gunūnj: “Ngaa gui̱niꞌí re̱ꞌ ꞌna̱ꞌ gui̱nij Espíritu Santo gu̱na nga̱ ꞌngo̱ tsínj daj, ni̱ hué sij gui̱ꞌyaj si ga̱ꞌnaꞌ Espíritu Santo rian ni ngüi̱ aj.” Daj gataj Yanꞌanj gunūnj. ");
INSERT INTO trq_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ni̱ hua guiniꞌi yyāj sisi̱ guinij Espíritu Santo chra̱ sij. Ni̱ huēj huin testigo sisi̱ hué xa̱ngaꞌ sij huin daꞌníj Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ni̱ ango güi ni̱ niquinꞌ ru̱huaꞌ yún Juan yuꞌuj daj nga̱ hui̱j tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ni̱ ngaa guiniꞌi Juan gachin Jesús, ni̱ gataj sij: ―Ni̱ꞌyaj nu̱ngüej é re̱ꞌ. Hué tsínj daj huin xachij ꞌni̱j ꞌna̱ꞌ rian Yanꞌanj anj. ―Daj gataj Juan. ");
INSERT INTO trq_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ni̱ ngaa gunun nu̱ngüej tsínj nicoꞌ Juan si gataj síꞌ, ni̱ guinicoꞌ nu̱ngüej sij Jesús. ");
INSERT INTO trq_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ngaa ni̱ nanica̱j Jesús. Ni̱ ngaa guiniꞌi sij sisi̱ nicoꞌ nu̱ngüej síꞌ manꞌan sij, ni̱ gataj sij: ―Ni̱ u̱n sin nanoꞌ nu̱ngüej é re̱ꞌ únj. ―Gataj Jesús. Ngaa ni̱ gataj nu̱ngüej sij: ―Rabí, ni̱ a̱ nné re̱ꞌ únj. ―Gataj nu̱ngüej sij. (Ni̱ nuguanꞌ Rabí huin ruhuaj gata, Maestro.) ");
INSERT INTO trq_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ngaa ni̱ gataj Jesús: ―Gu̱nꞌ gui̱niꞌyaj nu̱ngüej é re̱ꞌ aj. ―Gataj Jesús. Ngaa ni̱ ganꞌanj ni̱ꞌyaj nu̱ngüej sij rian nne Jesús. Ni̱ gunáj nu̱ngüej sij nga̱ síꞌ güi daj. Daj si guisíj gaꞌ ga̱nꞌanj diꞌni̱. ");
INSERT INTO trq_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ni̱ tsínj gu̱ꞌnaj Andrés huin ꞌngo̱ tsínj gunun si gataj Juan. Ni̱ hué sij huin si guinicoꞌ Jesús. Ni̱ Andrés huin jnánj Simón Pedro. ");
INSERT INTO trq_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ngaa ni̱ hua sini nariꞌ Andrés jnánj sij Simón. Ni̱ gataj sij: ―Hua nariꞌ únj Mesías. ―Daj gataj Andrés. (Ni̱ nuguanꞌ Mesías huin ruhuaj gata, Cristo.) ");
INSERT INTO trq_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ngaa ni̱ nicaj Andrés jnánj sij ganꞌanj sij rian nne Jesús. Ni̱ ngaa guiniꞌi Jesús, ni̱ gataj síꞌ: ―Tsínj gu̱ꞌnaj Simón huín re̱ꞌ. Ni̱ daꞌníj Jonás huín re̱ꞌ nej. Sani̱ gu̱ꞌnaj re̱ꞌ Cefas. ―Daj gataj Jesús. (Ni̱ nuguanꞌ Cefas huin ruhuaj gata, Pedro.) ");
INSERT INTO trq_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ango güi ni̱ huin ruhua Jesús ga̱nꞌanj sij estado Galilea. Ni̱ nariꞌ sij Felipe. Ni̱ gataj sij gunun síꞌ: ―Gui̱nicóꞌ re̱ꞌ manꞌānj gu̱nꞌ. ―Daj gataj Jesús gunun Felipe. ");
INSERT INTO trq_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ni̱ ꞌna̱ꞌ Felipe xumanꞌ Betsaida rian huin xánj Andrés nga̱ Pedro nej. ");
INSERT INTO trq_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ngaa ni̱ nariꞌ Felipe tsínj gu̱ꞌnaj Natanael. Ni̱ gataj Felipe gunun síꞌ: ―Hua nariꞌ únj tsínj xi̱ꞌi garun Moisés rian si-ley Yanꞌanj asi̱j ná. Ni̱ hué daj garun ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná xiꞌí tsínj daj nej. Ni̱ hué tsínj daj huin Jesús daꞌníj José huin tsínj ꞌna̱ꞌ xumanꞌ Nazaret. ―Daj gataj Felipe gunun Natanael. ");
INSERT INTO trq_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ngaa ni̱ gataj Natanael: ―Nitaj tsínj sa̱ꞌ ꞌna̱ꞌ xumanꞌ Nazaret mánj. ―Gataj Natanael. Ngaa ni̱: ―Gu̱nꞌ gui̱niꞌí re̱ꞌ aj. ―Gataj Felipe. ");
INSERT INTO trq_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ni̱ ngaa guiniꞌi Jesús gahuin ni̱chrunꞌ Natanael, ni̱ gataj síꞌ: ―Nan ꞌna̱ꞌ ꞌngo̱ tsínj xa̱ngaꞌ yya huin tsínj israelita. Ni̱ nitaj tsínj digyaꞌ yunꞌunj huin sij mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ngaa ni̱ gataj Natanael gunun Jesús: ―Da̱j huin guiniꞌí re̱ꞌ manꞌānj únj. ―Gataj Natanael gunun Jesús. Ni̱ gataj Jesús: ―Asi̱j achin ga̱quinj Felipe ga̱ꞌnaꞌ re̱ꞌ riānj, ni̱ guiniꞌīnj ngaa nné re̱ꞌ riqui chrun ayu higo aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ngaa ni̱ gataj Natanael: ―Rabí, hué re̱ꞌ huin daꞌníj Yanꞌanj. Ni̱ hué re̱ꞌ huin si-rey ni ngüi̱ israelita nej. ―Daj gataj Natanael. ");
INSERT INTO trq_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ngaa ni̱ gataj Jesús gunun Natanael: ―Xuman ruhuá re̱ꞌ niꞌyáj re̱ꞌ yūnj urin si gatā gunún re̱ꞌ sisi̱ guiniꞌīnj nné re̱ꞌ riqui chrun ayu higo níꞌ. Sani̱ gui̱niꞌí re̱ꞌ si sa̱ꞌ nico daj nga̱ si sa̱ꞌ nan anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ni̱ gataj ru̱huaꞌ yún Jesús gunun sij: ―Xa̱ngaꞌ atā gu̱nun re̱ꞌ sisi̱ gui̱niꞌi a ni é re̱ꞌ sisi̱ na̱xiꞌni manꞌan xataꞌ. Ni̱ ga̱hui si-ángel Yanꞌanj. Ni̱ na̱nij-íꞌ riānj huīnj daꞌníj ni ngüi̱. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ni̱ ngaa guisíj gachin hua̱ꞌnij güi, ni̱ huin ꞌngo̱ guiꞌyanj naraꞌa ni ngüi̱ xumanꞌ Caná huin xumanꞌ ngaj estado Galilea. Ni̱ ganꞌanj nni Jesús guiꞌyanj daj. ");
INSERT INTO trq_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ni̱ gaquínj ni sij ga̱nꞌanj Jesús nga̱ ni tsínj nicoꞌ síꞌ guiꞌyanj da nej. ");
INSERT INTO trq_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ni̱ ngaa ganahuij vino, ni̱ gataj nni Jesús gunun síꞌ: ―Nitaj nnee vino rian ni sij ga̱ mánj. ―Daj gataj unj. ");
INSERT INTO trq_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ngaa ni̱ gataj Jesús rian nni sij: ―Ni̱ u̱n sin huin ni̱ gaꞌmí re̱ꞌ daj riānj únj. Achin gui̱sij güi ga̱xiꞌi si-sūnj anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ngaa ni̱ gataj únꞌ rian ni tsínj ma̱n ꞌyaj sun daj: ―Gui̱ꞌyaj á re̱ꞌ daranꞌ si ga̱taj sij rian án re̱ꞌ aj. ―Daj gataj nni Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ni̱ nne hua̱tanꞌ gucuaj yej arasu̱n ni tsínj israelita sisi̱ gui̱man nnee chruhua-áꞌ nania̱ꞌ ni sij da̱j rúnꞌ ataj si-du̱cuanj Moisés. Ni̱ daꞌ go̱ꞌngo gucuaj nicaj ga̱nꞌanj xia lichru nnee aj. ");
INSERT INTO trq_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ngaa ni̱ gataj Jesús gunun ni tsínj ma̱n ꞌyaj sun daj: ―Ga̱ra á re̱ꞌ nnee chruhua ni gucuaj nan anj. ―Daj gataj Jesús. Ngaa ni̱ ꞌngo̱ gara ni̱nꞌ rian ni gucuaj, guiꞌyaj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ngaa ni̱ gataj Jesús: ―Yya̱j ni̱ gui̱ri a ni é re̱ꞌ do̱j nnee ga̱ꞌuiꞌ a ni é re̱ꞌ rian tsínj aꞌninꞌ xiꞌí guiꞌyanj. ―Daj gataj Jesús. Ngaa ni̱ daꞌngaꞌ daj guiꞌyaj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ni̱ tsínj daj goꞌo do̱j. Ni̱ xacaj cuenta duꞌua sij sisi̱ hua sa̱ꞌ nnee ganahuin vino daj. Sani̱ nun niꞌi sij ni̱ a̱ ꞌna̱ꞌ aj. Urin ni tsínj ma̱n ꞌyaj sun niꞌi. Daj si hué ni sij huin ni tsínj ri nnee daj. Asíj ni̱ gaquínj tsínj aꞌninꞌ rian guiꞌyanj daj ga̱ꞌnaꞌ tsínj xacaj yunꞌunj xa̱na. ");
INSERT INTO trq_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ni̱ gataj sij gunun síꞌ: ―Daranꞌ ni ngüi̱ aꞌuiꞌ sini vino sa̱ꞌ. Ni̱ ngaa goꞌo nico ni tsínj ꞌna̱ꞌ guiꞌyanj, ni̱ aꞌuiꞌ ni sij vino nitaj si hua sa̱ꞌ. Sani̱ so̱ꞌ nara sa̱ꞌ vino sa̱ꞌ da yya̱j aj. ―Daj gataj tsínj daj. ");
INSERT INTO trq_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ni̱ hué daj gaxi̱ꞌi Jesús guiꞌyaj sij si sa̱ꞌ nico xumanꞌ Caná xumanꞌ ngaj estado Galilea. Xiꞌí daj ni̱ xacaj ni ngüi̱ cuenta sisi̱ tsínj sa̱ꞌ ni̱nꞌ ruhua huin Jesús. Ni̱ guxuman ruhua ni tsínj nicoꞌ sij guiniꞌi ni síꞌ sij. ");
INSERT INTO trq_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Asíj ni̱ ganꞌanj Jesús xumanꞌ Capernaum. Ni̱ ganꞌanj nni sij nej, ni jnánj sij nej, ni tsínj nicoꞌ sij nej. Ni̱ do̱j güi guimán ni sij yuꞌuj daj. ");
INSERT INTO trq_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ni̱ ngaa gahuin ni̱chrunꞌ ga̱huin guiꞌyanj pascua, guiꞌyaj ni tsínj israelita, ngaa ni̱ gahui Jesús ganꞌanj sij xumanꞌ Jerusalén. ");
INSERT INTO trq_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ni̱ chruhua nuhui nico, ni̱ nariꞌ Jesús ni tsínj mán duꞌuej sicuj nga̱ xachij nej, xuꞌma̱n nej. Ni̱ nariꞌ sij ni tsínj naduna sanꞌanj nne ni síꞌ ꞌyaj sun ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ngaa ni̱ guiꞌyaj Jesús ꞌngo̱ xuguati. Ni̱ guiri sij daranꞌ ni síꞌ ne̱ꞌ chrej xe̱ꞌ nuhui daj nga̱ ni xachij nej, ni sicuj nej. Ni̱ gayu si-sanꞌanj ni tsínj naduna sanꞌanj, guiꞌyaj sij. Ni̱ guru ni̱tu sij ni mesa siꞌyaj ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ni̱ gataj sij gunun ni tsínj duꞌuej xuꞌma̱n: ―Gu̱xun a ni é re̱ꞌ si ma̱n nan. Si̱ guiꞌyaj á re̱ꞌ yuꞌue̱ ducuá chrē mánj. ―Daj gataj Jesús gunun ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ngaa ni̱ nanun ruhua ni tsínj nicoꞌ Jesús si garun ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. Ni̱ gataj ni síꞌ: “Ducu huin ruhuāj si ga̱ sa̱ꞌ ducuá re̱ꞌ.” Daj garun ꞌngo̱ tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ni̱ ngaa guiniꞌi ni tsínj israelita si guiꞌyaj Jesús, ni̱ nachínj snanꞌanj ni síꞌ sij. Ni̱ gataj ni síꞌ: ―Da̱j hua daꞌngaꞌ di̱gyán re̱ꞌ rian ni únj gui̱niꞌi únj sisi̱ hua si-chréj re̱ꞌ guiꞌyáj re̱ꞌ da únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ngaa ni̱ gataj Jesús: ―Du̱guane ni é re̱ꞌ nuhui nan, ni̱ chra̱ hua̱ꞌnij güi, ni̱ na̱guiꞌyaj na̱ca ru̱huaꞌ yūnj. ―Gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ngaa ni̱ gataj ni tsínj israelita: ―Síj hui̱j xia hua̱tanꞌ yya yoꞌ guiꞌyaj sun ni sij nuhui nan. Ni̱ asa̱ꞌ ga̱ꞌue na̱guiꞌyáj re̱ꞌ nuhui nan chra̱ hua̱ꞌnij güi, ruhuá re̱ꞌ únj. ―Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sani̱ gaꞌmi Jesús xiꞌí nnee̱ cúj manꞌan sij sisi̱ hué-éꞌ huin ducuá Yanꞌanj, ataj sij. ");
INSERT INTO trq_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Xiꞌí daj ni̱ ngaa ganáꞌnij Jesús scanij ni níman, ni̱ gananun ruhua ni tsínj nicoꞌ sij sisi̱ daꞌngaꞌ daj gaꞌmi sij. Ngaa ni̱ guxuman ruhua ni sij nuguanꞌ ataj si-nu̱guanꞌ Yanꞌanj. Ni̱ guxuman ruhua ni sij nuguanꞌ gaꞌmi Jesús nej. ");
INSERT INTO trq_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ni̱ ngaa gane Jesús xumanꞌ Jerusalén gahuin guiꞌyanj pascua, ni̱ nico ni ngüi̱ guxuman ruhua niꞌyaj manꞌan sij ngaa guiniꞌi ni síꞌ si sa̱ꞌ guiꞌyaj sij. ");
INSERT INTO trq_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Sani̱ nun ga̱ꞌuej ruhua Jesús gui̱nicaj dugüiꞌ sij nga̱ ni síꞌ xiꞌí si hua niꞌi sij da̱j hua niman ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ni̱ nitaj si nanaꞌuiꞌ sij go̱ꞌngo ni tsínj ga̱taj rian sij da̱j hua niman ni ngüi̱ mánj. Daj si hua niꞌi sij da̱j hua niman ni ngüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ni̱ hua ꞌngo̱ tsínj fariseo gu̱ꞌnaj Nicodemo huin síꞌ ꞌngo̱ tsínj huin achij rian ni tsínj israelita. ");
INSERT INTO trq_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Hué dan ni̱ ne̱ꞌ ni̱, ni̱ gaꞌna̱ꞌ Nicodemo rian Jesús. Ni̱ gataj sij: ―Maestro, niꞌi ni únj sisi̱ gaꞌníj Yanꞌanj gaꞌna̱ꞌ re̱ꞌ digyán re̱ꞌ rian ni ngüi̱. Daj si ni̱ a̱ ꞌngo̱ tsínj si̱ gaꞌue ga̱huin nucuaj gui̱ꞌyaj sa̱ꞌ da̱j rúnꞌ ꞌyáj re̱ꞌ sisi̱ nitaj Yanꞌanj chracuij sij mánj. ―Daj gataj Nicodemo gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ngaa ni̱ gataj Jesús gunun síꞌ: ―Xa̱ngaꞌ yya atā gu̱nun re̱ꞌ sisi̱ tsínj si̱ gaꞌnga na̱ca ru̱huaꞌ yún, ni̱ si̱ gaꞌue ga̱huin nucuaj sij gui̱niꞌi sij rian nicaj sun Yanꞌanj mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ngaa ni̱ nachínj snanꞌanj Nicodemo Jesús. Ni̱ gataj sij: ―Sani̱ da̱j ga̱ꞌue gui̱ꞌyaj ꞌngo̱ tsínj achij na̱nicaj ru̱huaꞌ yún sij ga̱ꞌnga na̱ca sij únj. Asa̱ꞌ ga̱ꞌue na̱tu ru̱huaꞌ yún sij riqui nni sij, ni̱ ga̱ꞌnga ru̱huaꞌ yún sij únj. ―Gataj Nicodemo. ");
INSERT INTO trq_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ngaa ni̱ gataj Jesús: ―Xa̱ngaꞌ atā gu̱nun re̱ꞌ sisi̱ si̱ gaꞌnga ꞌngo̱ tsínj daj, gui̱ꞌyaj nnee nga̱ Espíritu Santo, ni̱ si̱ gaꞌue ga̱tu sij rian nicaj sun Yanꞌanj mánj. ");
INSERT INTO trq_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Gaꞌnga néꞌ nga̱ nnee̱ cúj néꞌ, guiꞌyaj nni néꞌ nga̱ chrej néꞌ. Sani̱ sisi̱ ga̱ꞌnga néꞌ, gui̱ꞌyaj Espíritu Santo, ni̱ hua ni̱ꞌnaꞌ niman néꞌ. ");
INSERT INTO trq_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Si̱ garáj yanꞌanj ruhuá re̱ꞌ si gatā gunún re̱ꞌ: “Hua nia̱n ga̱ꞌnga na̱ca ru̱huaꞌ yún a ni é re̱ꞌ.” Daj gatā gunún re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ni̱ aꞌuiꞌ nane̱ niaj diaj. Ni̱ nu̱nj si unún re̱ꞌ aꞌuiꞌ nane̱, sani̱ nun niꞌí re̱ꞌ ni̱ a̱ ꞌnaj ni̱ a̱ huanꞌan mánj. Ni̱ hué daj huin nga̱ daranꞌ ni ngüi̱ ga̱ꞌnga na̱ca ru̱huaꞌ yún, guiꞌyaj Espíritu Santo aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ngaa ni̱: ―Asa̱ꞌ ga̱ꞌue ga̱huin nan únj. ―Gataj Nicodemo. ");
INSERT INTO trq_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ngaa ni̱ gataj Jesús: ―Hué re̱ꞌ huin tsínj digyán rian ni tsínj israelita, ni̱ u̱n sin huin ni̱ nunún re̱ꞌ nuguanꞌ nan únj. ");
INSERT INTO trq_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Xa̱ngaꞌ atā gu̱nun re̱ꞌ sisi̱ aꞌmi ni únj nuguanꞌ niꞌi ni únj. Ni̱ hué ni únj nataꞌ rian ni ngüi̱ xiꞌí si guiniꞌi únj nej. Sani̱ nun xu̱man ruhua ni é re̱ꞌ nuguanꞌ aꞌmi ni únj mánj. ");
INSERT INTO trq_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ni̱ sisi̱ nun xu̱man ruhua á re̱ꞌ ngaa aꞌmī xiꞌí ni nuguanꞌ hua chruhua xungüi̱ nan, ni̱ da̱j ga̱ꞌue gu̱xuman ruhua ni é re̱ꞌ ngaa ga̱ꞌmī xiꞌí ni nuguanꞌ ꞌna̱ꞌ xataꞌ únj. ");
INSERT INTO trq_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ni̱ a̱ ꞌngo̱ ni tsínj nun gahui ganꞌanj xataꞌ. Urīnj huin tsínj gane xataꞌ. Ni̱ nanij manꞌānj xataꞌ gaꞌnāj chruhua xungüi̱ nan huīnj daꞌníj ni ngüi̱. Ni̱ xānj huin xataꞌ nej. ");
INSERT INTO trq_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ni̱ da̱j rúnꞌ guiꞌyaj tsínj gu̱ꞌnaj Moisés docoꞌ síꞌ xucuáj chra̱ chrun quij quiꞌyanj na̱co, ni̱ hué daj hua nia̱n gui̱ꞌyaj ni sij do̱coꞌ ni sij manꞌānj chra̱ ꞌngo̱ chrun huīnj daꞌníj ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ngaa ni̱ daranꞌ ni ngüi̱ xuman ruhua niꞌyaj manꞌānj, ni̱ ga̱ne ni̱ganj ni sij nga̱ Yanꞌanj. Ni̱ si̱ ganꞌanj niꞌya ni sij mánj. ―Daj gataj Jesús gunun tsínj gu̱ꞌnaj Nicodemo. ");
INSERT INTO trq_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ni̱ gataj ru̱huaꞌ yún Jesús gunun Nicodemo: ―Hué dan ni̱ ducu gahuin ꞌi̱ ruhua Yanꞌanj niꞌya ni ngüi̱ ma̱n chruhua xungüi̱. Ngaa ni̱ riqui Yanꞌanj urin daꞌni gaꞌna̱ꞌ síꞌ chruhua xungüi̱ nan. Ngaa ni̱ daranꞌ ni ngüi̱ guxuman ruhua niꞌyaj daꞌníj Yanꞌanj, ni̱ si̱ ga niꞌya ni sij mánj. Sani̱ ga̱ne ni̱ganj ni sij nga̱ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Daj si nun ga̱ꞌnij Yanꞌanj daꞌni gaꞌna̱ꞌ chruhua xungüi̱ sisi̱ gu̱taꞌ sij gaquinꞌ xiráj ni ngüi̱ mánj. Sani̱ gaꞌna̱ꞌ síꞌ si na̱caj síꞌ ni ngüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ni̱ ngüi̱ guxuman ruhua niꞌyaj daꞌníj Yanꞌanj, ni̱ nitaj castigo ga̱huin ni sij mánj. Sani̱ ni ngüi̱ nun xu̱man ruhua ni̱ꞌyaj síꞌ, ni̱ hua gahuin ni sij castigo, guiꞌyaj Yanꞌanj xiꞌí si nun xu̱man ruhua ni sij ni̱ꞌyaj ni sij tsínj huin urin daꞌníj Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","’Ni̱ ni ngüi̱ nun xu̱man ruhua daj, ni̱ ga̱huin ni sij castigo xiꞌí nuguanꞌ nan: Ngaa gaꞌna̱ꞌ yanꞌa̱n huin manꞌānj guixigui̱n chruhua xungüi̱, ni̱ garanꞌ ruhua ni sij ga̱che ni sij rian ru̱miꞌ. Ni̱ nun ga̱ranꞌ ruhua ni sij ga̱huin ni̱chrunꞌ ni sij rian yanꞌa̱n xigui̱n daj. Daj si quij ꞌyaj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Hué dan ni̱ daranꞌ ni ngüi̱ ꞌyaj quij, ni̱ nun huin xa̱nꞌ ruhua ni sij niꞌyaj ni sij yanꞌa̱n xigui̱n daj. Ni̱ nun ga̱huin ni̱chrunꞌ ni sij rian yanꞌa̱n si naꞌuej ruhua ni sij gu̱rugüiꞌ si quij ꞌyaj ni sij mánj. ");
INSERT INTO trq_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Sani̱ ni ngüi̱ ꞌyaj xa̱ngaꞌ, ni̱ huin ni̱chrunꞌ ni sij rian yanꞌa̱n xigui̱n daj. Ngaa ni̱ rugüiꞌ si ꞌyaj sa̱ꞌ ni sij. Ngaa ni̱ xacaj ango ni ngüi̱ cuenta sisi̱ ꞌyaj sa̱ꞌ ni sij, ꞌyaj Yanꞌanj anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Daꞌ síj ni̱ ganꞌanj Jesús nga̱ ni tsínj nicoꞌ sij estado Judea. Ni̱ gane ni sij nga̱ ni tsínj mán yuꞌuj daj. Ni̱ duguataꞌ nnee ni sij ni ngüi̱ daj. ");
INSERT INTO trq_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ni̱ hué daj duguataꞌ nnee Juan ni ngüi̱ xumanꞌ Enón. Ni̱ ni̱chrunꞌ ngaj xumanꞌ Esrón nga̱ xumanꞌ Salim. Ni̱ hua nico nnee yuꞌuj daj. Ni̱ huaj ni ngüi̱ gataꞌ nnee ni sij. ");
INSERT INTO trq_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ni̱ hué nan gahuin ngaa nun huin gahuin garij ni sij Juan ducuaga̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Hué dan ni̱ gaxi̱ꞌi gaꞌmi guitsi go̱ꞌngo ni tsínj nicoꞌ Juan nga̱ ni tsínj israelita xiꞌí da̱j ga̱huin sa̱ꞌ ni ngüi̱ rian Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ngaa ni̱ gaꞌna̱ꞌ ni sij rian manꞌan Juan. Ni̱ gataj ni sij: ―Rabí, ni̱ꞌyaj re̱ꞌ sisi̱ tsínj gachéj nga̱ re̱ꞌ anéj chrej xinéj gu̱ꞌnaj Jordán, huin tsínj xi̱ꞌi gaꞌmí re̱ꞌ cuanj. Ni̱ yya̱j ni̱ ataꞌ nnee sij ni ngüi̱. Ni̱ huaj daranꞌ ni ngüi̱ rian sij. ―Daj gataj ni sij gunun Juan. ");
INSERT INTO trq_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ngaa ni̱ gataj Juan: ―Ni̱ a̱ ꞌngo̱ tsínj si̱ gaꞌue na̱huin raꞌa ꞌngo̱ rasu̱n sisi̱ nitaj riqui Yanꞌanj mánj. ");
INSERT INTO trq_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Hua gunun a ni é re̱ꞌ nuguanꞌ gatā gunun a ni é re̱ꞌ: Sēj huin Cristo mánj. Sani̱ gaꞌníj Yanꞌanj ga̱ꞌnaꞌ sinīj rian síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ni̱ ngaa huin ꞌngo̱ guiꞌyanj xacaj ꞌngo̱ tsínj daj ꞌngo̱ yunꞌunj xa̱na, ni̱ hué síꞌ gahuin nica̱ únꞌ. Ni̱ niquinꞌ ꞌngo̱ tsínj nicaj dugüiꞌ nga̱ tsínj xacaj yunꞌunj xa̱na daj. Ni̱ ducu huin nia̱ꞌ ruhua síꞌ ngaa gunun síꞌ gaꞌmi tsínj xa̱caj yunꞌunj xa̱na daj. Ni̱ da̱j rúnꞌ ꞌyaj tsínj niquinꞌ nga̱ dugüiꞌ síꞌ, ni̱ daꞌngaꞌ daj ꞌyaj manꞌānj nej. Ni̱ huin nia̱ꞌ ruhuāj xiꞌí Cristo. ");
INSERT INTO trq_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ni̱ hua nia̱n si ga̱huin achij Cristo. Sani̱ manꞌānj gu̱na gui̱nicoꞌ ne̱ꞌ ru̱cu nánj. ―Daj gataj Juan gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ni̱ gataj ru̱huaꞌ yún Juan gunun ni sij: ―Tsínj ꞌna̱ꞌ xataꞌ, ni̱ huin rian sij rian daranꞌ rasu̱n. Ni̱ tsínj ꞌna̱ꞌ chruhua xungüi̱, ni̱ ni̱nanj aꞌmi sij nuguanꞌ ma̱n chruhua xungüi̱ xiꞌí si gaꞌnga sij xungüi̱ nan. Sani̱ tsínj ꞌna̱ꞌ xataꞌ, ni̱ huin achij sij rian daranꞌ anj. ");
INSERT INTO trq_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ni̱ aꞌmi sij xiꞌí nuguanꞌ guiniꞌi sij nga̱ nuguanꞌ gunun sij xataꞌ. Sani̱ naꞌue gu̱xuman ruhua ni ngüi̱ si ataj sij mánj. ");
INSERT INTO trq_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Sani̱ tsínj guxuman ruhua si-nu̱guanꞌ sij, ni̱ ataj síꞌ sisi̱ xa̱ngaꞌ si-nu̱guanꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tsínj gaꞌníj Yanꞌanj ga̱ꞌnaꞌ, ni̱ aꞌmi sij si-nu̱guanꞌ Yanꞌanj. Daj si aꞌuiꞌ ꞌueé Yanꞌanj Espíritu Santo rian sij. ");
INSERT INTO trq_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ni̱ ꞌi̱ ruhua Yanꞌanj niꞌya daꞌni. Ni̱ nagaꞌuiꞌ Yanꞌanj daranꞌ rasu̱n rian daꞌni nej. ");
INSERT INTO trq_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ni̱ ngüi̱ guxuman ruhua niꞌyaj daꞌníj Yanꞌanj, ni̱ ga̱ne ni̱ganj ni sij nga̱ Yanꞌanj. Sani̱ ni ngüi̱ naꞌuej ruhua gu̱nun si ataj daꞌníj Yanꞌanj, ni̱ si̱ gane ni sij nga̱ Yanꞌanj mánj. Sani̱ ꞌngo̱ gaꞌman ruhua Yanꞌanj niꞌya ni sij. ―Daj gataj Juan. ");
INSERT INTO trq_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Hué dan ni̱ xacaj Jesús cuenta sisi̱ gunun ni tsínj fariseo sisi̱ hua gahuin nico ni ngüi̱ nicoꞌ Jesús daj nga̱ Juan. Ni̱ nico doj ni ngüi̱ gataꞌ nnee, guiꞌyaj Jesús daj nga̱ Juan nej. ");
INSERT INTO trq_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Sani̱ sé Jesús huin si duguataꞌ nnee ni ngüi̱ mánj. Maan ni tsínj nicoꞌ sij duguataꞌ nnee ni ngüi̱ aj.) ");
INSERT INTO trq_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ni̱ ngaa xacaj Jesús cuenta sisi̱ gunun ni tsínj fariseo nuguanꞌ daj, ni̱ gahui sij estado Judea. Ni̱ gachin sij ganꞌanj sij estado Galilea. ");
INSERT INTO trq_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Sani̱ hua nia̱n si ga̱chin sij estado Samaria ga̱nꞌanj sij. ");
INSERT INTO trq_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ni̱ guisíj sij ꞌngo̱ xumanꞌ ngaj estado Samaria huin ꞌngo̱ xumanꞌ gu̱ꞌnaj Sicar. Ni̱ ni̱chrunꞌ ngaj xumanꞌ daj duꞌua yoꞌój gaꞌuiꞌ tsínj gu̱ꞌnaj Jacob rian daꞌníj síꞌ José ngaa ná. ");
INSERT INTO trq_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yuꞌuj daj nu̱n ꞌngo̱ pozo nnee ganj Jacob ngaa ná. Ni̱ guininaj Jesús huaj sij chrej. Ni̱ ganꞌanj ga̱ne sij naránj ruhua sij duꞌua pozo daj. Ni̱ síj gaxuj. ");
INSERT INTO trq_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ngaa ni̱ gaꞌna̱ꞌ ꞌngo̱ yunꞌunj xa̱na samaritana pozo daj gui̱ri únꞌ nnee. Ni̱ gataj Jesús rian únꞌ: ―Ri̱qui re̱ꞌ do̱j nnee go̱ꞌōj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ni̱ hua ganꞌanj ni tsínj nicoꞌ Jesús ganꞌanj gui̱ran ni síꞌ si xa̱ ni sij xumanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ngaa ni̱ gataj yunꞌunj xa̱na samaritana daj gunun Jesús: ―Tsínj israelita huín re̱ꞌ. Ni̱ u̱n sin huin ni̱ achínj re̱ꞌ nnee go̱ꞌo re̱ꞌ riānj huīnj ꞌngo̱ yunꞌunj xa̱na samaritana únj. ―Daj gataj únꞌ si nitaj si nicaj dugüiꞌ ni tsínj israelita nga̱ ni tsínj samaritana. ");
INSERT INTO trq_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ngaa ni̱ gataj Jesús: ―Sisi̱ xa̱caj re̱ꞌ cuenta xiꞌí sinduj gui̱ꞌyaj Yanꞌanj xiꞌí re̱ꞌ, ni̱ sisi̱ gui̱niꞌí re̱ꞌ u̱n tsínj achínj nnee rián re̱ꞌ, ngaa ni̱ ga̱chinj re̱ꞌ nnee rian sij, ni̱ ri̱qui sij nnee ꞌyaj si ga̱ ni̱ꞌnaꞌ ni̱ganj re̱ꞌ nga̱ Yanꞌanj anj. ―Gataj Jesús gunun únꞌ. ");
INSERT INTO trq_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ngaa ni̱ gataj yunꞌunj xa̱na daj: ―Ni̱ a̱ ꞌngo̱ rasu̱n nitaj nicáj re̱ꞌ gui̱ri re̱ꞌ nnee mánj. Ni̱ ducu gu̱nun pozo nan. Ni̱ ni̱ a̱ gui̱riꞌ re̱ꞌ ri̱qui re̱ꞌ nnee ꞌyaj si ga̱ ni̱ꞌnāj ni̱ganj nej únj. ");
INSERT INTO trq_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ni̱ xi néꞌ Jacob duna pozo nan rian ni únj. Ni̱ goꞌo ni da̱ꞌnij manꞌan síꞌ nnee nu̱n chruhua pozo nan nga̱ dán síꞌ xucu nej. Huin achíj re̱ꞌ doj daj nga̱ síꞌ ruhuá re̱ꞌ níꞌ. ―Daj gataj yunꞌunj xa̱na daj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ngaa ni̱ gataj Jesús gunun únꞌ: ―Daranꞌ ni ngüi̱ go̱ꞌo nnee nu̱n chruhua pozo nan, sani̱ na̱goꞌo ru̱huaꞌ yún ni sij nnee aj. ");
INSERT INTO trq_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Sani̱ tsínj go̱ꞌo nnee ga̱ꞌuiꞌ manꞌānj, ni̱ nitaj a̱man na̱goꞌo sij nnee ga̱ mánj. Ni̱ da̱j rúnꞌ huin ꞌngo̱ pozo rian nachi nita ꞌueé nnee, ni̱ daꞌngaꞌ daj ga̱huin chruhua niman ꞌngo̱ tsínj go̱ꞌo nnee ga̱ꞌuiꞌ manꞌānj. Ni̱ ga̱ ni̱ꞌnaꞌ ni̱ganj tsínj daj nga̱ Yanꞌanj, gui̱ꞌyaj nnee daj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ngaa ni̱ gataj yunꞌunj xa̱na daj: ―Señor, ri̱qui re̱ꞌ nnee daj go̱ꞌōj. Ngaa ni̱ si̱ nagoꞌo ru̱huaꞌ yūnj ga̱ mánj. Ni̱ si̱ gaꞌna̱ꞌ gui̱ri ru̱huaꞌ yūnj nnee pozo nan ga̱ mánj. ―Gataj únꞌ gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ngaa ni̱ gataj Jesús: ―Güi̱j ga̱quinj nica̱ re̱ꞌ, ni̱ ga̱ꞌnaꞌ nu̱ngüej é re̱ꞌ nan. ―Gataj Jesús gunun únꞌ. ");
INSERT INTO trq_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ngaa ni̱: ―Nitaj nicāj mánj. ―Gataj únꞌ. Ngaa ni̱ gataj Jesús: ―Duguꞌna̱j gaꞌmí re̱ꞌ gatáj re̱ꞌ sisi̱ nitaj nica̱ re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Daj si síj u̱nꞌunꞌ nica̱ re̱ꞌ. Ni̱ tsínj nne nga̱ re̱ꞌ acuanꞌ, ni̱ sé nica̱ re̱ꞌ huin mánj. Xa̱ngaꞌ yya aꞌmí re̱ꞌ aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ngaa ni̱ gataj únꞌ: ―Señor, xacaj cuentāj sisi̱ huín re̱ꞌ ꞌngo̱ tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ni̱ xi ni únj ni nicoꞌ ni síꞌ Yanꞌanj xiráj quij nan. Sani̱ ataj á re̱ꞌ huin ni é re̱ꞌ ni tsínj israelita sisi̱ urin xumanꞌ Jerusalén huin yuꞌuj ga̱ꞌue gui̱nicoꞌ néꞌ Yanꞌanj, ataj á re̱ꞌ. ―Gataj yunꞌunj xa̱na gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ngaa ni̱ gataj Jesús: ―Xicaꞌuīj, gu̱xuman ruhuá re̱ꞌ nuguanꞌ atā nan gu̱nun re̱ꞌ. Daj si hua ꞌngo̱ güi, ni̱ si̱ gahui a ni é re̱ꞌ chra̱ quij nan gui̱nicoꞌ a ni é re̱ꞌ chrej néꞌ. Ni̱ si̱ ganꞌanj án re̱ꞌ xumanꞌ Jerusalén gui̱nicoꞌ a ni é re̱ꞌ chrej néꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nun niꞌi ni é re̱ꞌ da̱j hua Yanꞌanj nicoꞌ a ni é re̱ꞌ mánj. Sani̱ niꞌi ni únj da̱j hua Yanꞌanj nicoꞌ ni únj. Daj si xiꞌí ni tsínj israelita ꞌna̱ꞌ na̱caj Yanꞌanj ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Sani̱ hua ꞌngo̱ güi sisi̱ ni ngüi̱ nicoꞌ xa̱ngaꞌ Yanꞌanj, ni̱ gui̱nicoꞌ ni sij Yanꞌanj ꞌngo̱ ducuánj na̱ca. Ni̱ yya̱j ni̱ ga̱xiꞌi ni ngüi̱ gui̱nicoꞌ xa̱ngaꞌ ni sij Yanꞌanj nga̱ niman ni sij. Daj si nanaꞌuiꞌ chrej néꞌ Yanꞌanj sisi̱ daꞌngaꞌ daj gui̱ꞌyaj néꞌ gui̱nicoꞌ néꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ni̱ u̱n yuꞌuj huaj néꞌ, ni̱ nne Yanꞌanj xa̱ngaꞌ yuꞌuj daj. Daj si da̱j rúnꞌ huin ꞌngo̱ nane̱ sa̱ꞌ huin Yanꞌanj. Ni̱ ni ngüi̱ nicoꞌ Yanꞌanj, ni̱ hua nia̱n gui̱nicoꞌ xa̱ngaꞌ ni sij Yanꞌanj nga̱ niman ni sij. ―Daj gataj Jesús gunun yunꞌunj xa̱na daj. ");
INSERT INTO trq_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ngaa ni̱ gataj yunꞌunj xa̱na daj: ―Niꞌīnj sisi̱ ga̱ꞌnaꞌ tsínj ga̱nacaj ni ngüi̱ huin tsínj gu̱ꞌnaj Cristo. Ni̱ ngaa ga̱ꞌnaꞌ síꞌ, ni̱ na̱taꞌ yya síꞌ daranꞌ nuguanꞌ rian néꞌ. ―Gataj únꞌ. ");
INSERT INTO trq_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ngaa ni̱: ―Hué manꞌānj huin Cristo tsínj aꞌmi nga̱ re̱ꞌ nánj. ―Gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ngaa ni̱ hora daj ni̱ guisíj ni tsínj nicoꞌ Jesús. Ni̱ gara yanꞌanj ruhua ni sij xiꞌí si aꞌmi Jesús nga̱ ꞌngo̱ yunꞌunj xa̱na. Sani̱ ni̱ a̱ ꞌngo̱ ni sij nun na̱chínj snanꞌanj u̱n sin xi̱ꞌi gaꞌmi síꞌ nga̱ únꞌ. ");
INSERT INTO trq_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ngaa ni̱ duna yunꞌunj xa̱na daj si-siu̱ unj. Ni̱ ganꞌanj ga̱taj unj rian ni tsínj ma̱n xumanꞌ daj: ");
INSERT INTO trq_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Ga̱nꞌanj néꞌ ni̱ gui̱niꞌi néꞌ ꞌngo̱ tsínj gataj gunūnj daranꞌ si guiꞌyā. Cristo huin sij, ruhua á re̱ꞌ níꞌ. ―Daj gataj yunꞌunj xa̱na daj. ");
INSERT INTO trq_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ngaa ni̱ gahui ni tsínj daj ganꞌanj ni̱ꞌyaj ni sij rian nne Jesús. ");
INSERT INTO trq_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ni̱ ngaa achin gui̱sij ni sij, ni̱ guiꞌyaj fuerza ni tsínj nicoꞌ Jesús sisi̱ xa̱ síꞌ. Ni̱ gataj ni sij gunun Jesús: ―Rabí, xa̱ re̱ꞌ aj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Sani̱ gataj Jesús gunun ni sij: ―Hua si xa riānj anj. Sani̱ nun niꞌi ni é re̱ꞌ da̱j hua-áꞌ. ―Gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ngaa ni̱ gaxi̱ꞌi ni tsínj nicoꞌ Jesús nachínj snanꞌanj ni sij dugüiꞌ ni sij. Ni̱ gataj ni sij: ―Hua ꞌngo̱ ngüi̱ gaꞌna̱ꞌ nicaj xa sij, ruhua á re̱ꞌ níꞌ. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Sani̱ gataj Jesús: ―Da̱j rúnꞌ chra xāj huin si gui̱ꞌyā si huin ruhua si gaꞌníj gaꞌnāj. Ni̱ daꞌngaꞌ daj huin ruhuāj ga̱nahuij si-sūnj, gui̱ꞌyā aj. ");
INSERT INTO trq_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ataj ni é re̱ꞌ: “Achin yacuanꞌanj yahui̱, ngaa ni ga̱ꞌninꞌ néꞌ strigo.” Daj ataj ni é re̱ꞌ. Sani̱ atā gu̱nun a ni é re̱ꞌ sisi̱ na̱chi nicaj á re̱ꞌ rian án re̱ꞌ gui̱niꞌyaj á re̱ꞌ ni ngüi̱ sisi̱ da̱j rúnꞌ hua nnaa̱ strigo hua ni ngüi̱. Daj si guisíj gamij nnaa̱ strigo ga̱ꞌninꞌ néꞌ. ");
INSERT INTO trq_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Tsínj ri nnaa̱ strigo daj, ni̱ na̱huin raꞌa sij duꞌue̱ sij. Ni̱ naguiꞌyaj chreꞌ sij ni ngüi̱ ga̱ne ni̱ganj nga̱ Yanꞌanj. Ngaa ni̱ uyan ga̱huin nia̱ꞌ ruhua tsínj unu̱n nga̱ tsínj aꞌninꞌ nej. ");
INSERT INTO trq_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Xa̱ngaꞌ si ataj ni ngüi̱: “Ni̱ni tsínj unu̱n, ni̱ ni̱ni tsínj aꞌninꞌ nej.” Daj ataj ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ni̱ gaꞌnī ga̱nꞌanj án re̱ꞌ sisi̱ ga̱ꞌmi a ni é re̱ꞌ nuguanꞌ sa̱ꞌ rian ni ngüi̱. Sani̱ ango ni tsínj hua ganꞌanj guiꞌyaj sun. Ni̱ rian guiꞌyaj sun nucuaj ni sij, ni̱ ráj xina̱ ni ngüi̱ ꞌyaj si-nu̱guanꞌ ni é re̱ꞌ. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ni̱ guxuman ruhua nico ni ngüi̱ ma̱n xumanꞌ Samaria niꞌyaj ni sij Jesús xiꞌí nuguanꞌ nataꞌ yunꞌunj xa̱na daj rian ni sij. Daj si nataꞌ unj rian ni sij: “Gataj Jesús daranꞌ si guiꞌyā.” Daj nataꞌ unj rian ni sij. ");
INSERT INTO trq_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Hué dan ni̱ guisíj ni tsínj samaritano rian nne Jesús. Ni̱ gachínj jniꞌyaj ni sij rian síꞌ sisi̱ gu̱na síꞌ nga̱ ni sij. Ngaa ni̱ gunáj síꞌ hui̱j güi xumanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ni̱ gahuin nico ni ngüi̱ guxuman ruhua gunun si-nu̱guanꞌ manꞌan Jesús. ");
INSERT INTO trq_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ni̱ gataj ni sij gunun yunꞌunj xa̱na daj: ―Sé urin si nataꞌ manꞌán re̱ꞌ rian ni únj ꞌyaj si guxuman ruhua ni únj niꞌyaj únj manꞌan sij mánj. Sani̱ yya̱j ni̱ gunun ni únj si gaꞌmi sij. Ni̱ niꞌi ni únj sisi̱ hué sij huin Cristo tsínj gui̱ꞌyaj ga̱nani ni ngüi̱ ma̱n chruhua xungüi̱. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ni̱ ngaa guisíj hui̱j güi, ni̱ gahui Jesús xumanꞌ daj ganꞌanj sij estado Galilea. ");
INSERT INTO trq_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Daj si hua gataj Jesús sisi̱ nitaj si aꞌmi sa̱ꞌ ni tsínj rian ꞌngo̱ tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj sisi̱ huin ni sij ni tsínj xa̱nj mánj. ");
INSERT INTO trq_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ni̱ ngaa gaꞌna̱ꞌ Jesús estado Galilea, ni̱ nahuin raꞌa sa̱ꞌ ni tsínj ma̱n estado daj manꞌan síꞌ xiꞌí si guiniꞌi ni sij si sa̱ꞌ nico guiꞌyaj síꞌ xumanꞌ Jerusalén. Daj si ganꞌanj ni sij guiꞌyanj da nej. ");
INSERT INTO trq_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ngaa ni̱ gaꞌna̱ꞌ ru̱huaꞌ yún Jesús xumanꞌ Caná huin xumanꞌ ngaj estado Galilea nej. Ni̱ xumanꞌ daj huin rian ganahuin nnee vino, guiꞌyaj sij aj. Ni̱ yuꞌuj daj nne ꞌngo̱ tsínj nicaj sun rian rey. Ni̱ aꞌnanꞌ daꞌníj snoꞌo sij. ");
INSERT INTO trq_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ni̱ ngaa gunun tsínj nicaj sun daj sisi̱ gahui Jesús estado Judea gaꞌna̱ꞌ sij estado Galilea, ni̱ ganꞌanj sij rian nne Jesús. Ni̱ gaꞌmi yaco sij rian síꞌ sisi̱ ga̱nꞌanj síꞌ ducuá sij. Ngaa ni̱ jna̱huin daꞌníj sij, gui̱ꞌyaj síꞌ si do̱j ni̱ ga̱huiꞌ daꞌníj síꞌ, ataj síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ngaa ni̱ gataj Jesús: ―Ngaa nun gui̱niꞌi a ni é re̱ꞌ si sa̱ꞌ nico ꞌyā, ni̱ nun gu̱xuman ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ yūnj mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Sani̱ gataj tsínj nicaj sun daj: ―Señor, ga̱nꞌanj néꞌ si ruhua ga̱huiꞌ daꞌnī aj. ―Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ngaa ni̱ gataj Jesús: ―Güi̱j na̱nꞌ ducuá re̱ꞌ si nne ni̱ꞌnaꞌ daꞌníj re̱ꞌ nánj. ―Daj gataj Jesús. Ni̱ guxuman ruhua tsínj daj nuguanꞌ gataj Jesús rian sij. Ni̱ na̱nꞌ sij ducuá sij. ");
INSERT INTO trq_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ni̱ ngaa huaj sij nasíj sij ducuá sij, ni̱ gahui ni tsínj ꞌyaj sun rian sij. Ni̱ gataj ni sij: ―Nne ni̱ꞌnaꞌ daꞌníj re̱ꞌ nánj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ngaa ni̱ nachínj snanꞌanj tsínj daj u̱n hora gaxi̱ꞌi nahuin daꞌníj sij. Ngaa ni̱ gataj ni sij: ―Gaꞌ ꞌngo̱ diꞌni̱ guqui ganiquinꞌ gachiꞌ. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ngaa ni̱ xacaj cuenta tsínj daj sisi̱ hué gue̱ hora daj huin si gataj Jesús gunun sij sisi̱ nne ni̱ꞌnaꞌ daꞌníj sij. Ngaa ni̱ guxuman ruhua ni du̱cua sij niꞌyaj ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ni̱ hué nan guisíj hui̱j si sa̱ꞌ nico guiꞌyaj Jesús ngaa gahui sij estado Judea ganꞌanj sij estado Galilea. ");
INSERT INTO trq_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Hué dan ni̱ gahuin ꞌngo̱ guiꞌyanj guiꞌyaj ni tsínj israelita. Ngaa ni̱ gahui Jesús ganꞌanj sij xumanꞌ Jerusalén. ");
INSERT INTO trq_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ni̱ Jerusalén nu̱n ꞌngo̱ laguna leꞌ gu̱ꞌnaj Betesda snanꞌanj aꞌmi ni tsínj israelita. Ni̱ ngaj ni̱chrunꞌ laguna daj rian atúj ni xachij xumanꞌ Jerusalén. Ni̱ hua u̱nꞌunꞌ corredo ganica̱j laguna daj. ");
INSERT INTO trq_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ni̱ yuꞌuj daj guimán nico ni ngüi̱ duri nga̱ ni ngüi̱ yacuan nej, ni ngüi̱ nareꞌ dacój nej. Ni̱ anaꞌuij ni sij sisi̱ gui̱siquiꞌ nnee. ");
INSERT INTO trq_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Daj si nanij ꞌngo̱ ángel gaꞌníj Señor rian laguna daj. Ni̱ disiquiꞌ ángel daj nnee. Sani̱ nun gui̱niꞌi ni sij u̱n hora gu̱xuman ángel. Ni̱ ngaa guisiquiꞌ nnee daj, ni̱ u̱n tsínj ga̱tu sini ya̱n chruhua nnee, ni̱ xiꞌnej xiꞌi̱ aꞌnanꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ni̱ ngaj ꞌngo̱ tsínj duꞌua nnee daj. Ni̱ síj ico̱ xi̱nunꞌ hua̱ꞌnij yya yoꞌ aꞌnanꞌ sij. ");
INSERT INTO trq_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ni̱ ngaa guiniꞌi Jesús sisi̱ síj nico yoꞌ ngaj sij aꞌnanꞌ sij, ngaa ni̱ nachínj snanꞌanj síꞌ sij. Ni̱ gataj síꞌ: ―Ruhuá re̱ꞌ na̱huin sa̱ꞌ re̱ꞌ níꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ngaa ni̱ gataj tsínj aꞌnanꞌ daj: ―Señor, nitaj ga̱nicaj yūnj chruhua nnee ngaa siquiꞌ nnee. Ngaa huin ruhuāj ga̱tū chruhua nnee, ni̱ hua si̱ni ango ni sij huin yoo̱ atuj. ―Daj gataj tsínj daj. ");
INSERT INTO trq_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ni̱ gataj Jesús gunun sij: ―Na̱chica ni̱ na̱caj re̱ꞌ duhuéj re̱ꞌ. Ni̱ ga̱che re̱ꞌ aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ngaa ni̱ ꞌngo̱ hora ganahuin tsínj daj. Ni̱ nacaj sij duhuéj sij. Ni̱ ganꞌanj sij. Ni̱ güi naránj ruhua ni ngüi̱ huin. ");
INSERT INTO trq_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ngaa ni̱ gataj ni tsínj israelita rian tsínj nahuin sa̱ꞌ daj: ―Yya̱j huin güi naránj ruhua néꞌ. Nitaj chrej hua si nicáj re̱ꞌ duhuéj re̱ꞌ ga̱nꞌanj re̱ꞌ mánj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ngaa ni̱ gataj tsínj daj: ―Tsínj guiꞌyaj ganahuīnj gataj gunūnj: “Na̱caj re̱ꞌ duhuéj re̱ꞌ, ni̱ ga̱che re̱ꞌ.” Gataj sij gunūnj. ―Daj gataj tsínj daj gunun ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ngaa ni̱ nachínj snanꞌanj ni síꞌ sij. Ni̱ gataj ni sij: ―Ni̱ u̱n tsínj gataj sisi̱ na̱caj re̱ꞌ duhuéj re̱ꞌ, ni̱ ga̱che re̱ꞌ únj. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Sani̱ nun niꞌi tsínj daj u̱n tsínj guiꞌyaj nahuin sa̱ꞌ sij. Daj si guxun Jesús manꞌan síꞌ scanij ni ngüi̱ mán yuꞌuj daj. ");
INSERT INTO trq_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Daꞌ síj da nariꞌ Jesús tsínj daj nuhui nico. Ni̱ gataj Jesús: ―Ni̱ꞌyaj re̱ꞌ. Hua ganahuin sa̱ꞌ yyá re̱ꞌ aj. Ni̱ si̱ nanica̱j re̱ꞌ gui̱ꞌyaj re̱ꞌ gaquinꞌ, sa̱ꞌ nu̱n ga̱ꞌnaꞌ ꞌngo̱ sayun nico doj rián re̱ꞌ aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ngaa ni̱ ganꞌanj tsínj daj. Ni̱ nataꞌ sij rian ni tsínj israelita sisi̱ Jesús guiꞌyaj ganahuin sa̱ꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Xiꞌí daj ni̱ chranꞌ yunꞌunj ni tsínj israelita Jesús. Ni̱ da̱gahuiꞌ ni sij síꞌ, ruhua ni sij. Daj si güi naránj ruhua ni ngüi̱ huin güi nahuin sa̱ꞌ tsínj daj, guiꞌyaj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Sani̱ gataj Jesús gunun ni sij: ―Ni̱ hua gue̱ ꞌyaj sun chrē. Ni̱ xiꞌí daj ꞌngo̱ ꞌyaj sun manꞌānj nej. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ni̱ xiꞌí ꞌngo̱ da̱j, ni̱ na̱anj huin ruhua ni tsínj israelita da̱gahuiꞌ ni sij Jesús. Daj si nun dagahuin síꞌ si gataj ni sij xiꞌí güi naránj ruhua ni ngüi̱. Ni̱ gataj Jesús sisi̱ Yanꞌanj huin chrej manꞌan sij nej. Ni̱ huin ruhuaj gata sisi̱ uyan huin manꞌan sij nga̱ Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ngaa ni̱ gataj Jesús gunun ni sij: ―Xa̱ngaꞌ yya ataj snanꞌān gu̱nun a ni é re̱ꞌ: Naꞌue gui̱ꞌyā ni sun da̱j rúnꞌ huin ruhua manꞌānj. Maan si niꞌīnj si ꞌyaj chrē. Ni̱ hué daj ꞌyā nej. Daj si huīnj daꞌníj Yanꞌanj. Ni̱ ꞌngo̱ ꞌyaj nu̱ngüej chrē únj daranꞌ anj. ");
INSERT INTO trq_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ni̱ ꞌi̱ ruhua chrē niꞌya-áꞌ manꞌānj xiꞌí si daꞌníj Yanꞌanj huīnj. Ni̱ digyán-ánꞌ daranꞌ si ꞌyaj-áꞌ riānj. Ni̱ ga̱ra yanꞌanj ruhua á re̱ꞌ gui̱ꞌyaj ni ango si sa̱ꞌ nico doj achin di̱gyán Yanꞌanj riānj. ");
INSERT INTO trq_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ni̱ naꞌnij ni níman ꞌyaj chrē. Ni̱ da̱j rúnꞌ hua ni̱ꞌnaꞌ ni sij ꞌyaj chrē, ni̱ hué daj ꞌyā nga̱ ni tsínj sisi̱ huin ruhuāj ga̱huin ni̱ꞌnaꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nitaj si naguiꞌyaj yya Yanꞌanj si-ga̱quinꞌ ni ngüi̱ mánj. Sani̱ gaꞌninꞌ Yanꞌanj sun riānj sisi̱ huēj huin si na̱guiꞌyaj yya nga̱ si-ga̱quinꞌ ni ngüi̱. Daj si manꞌānj huin daꞌníj Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ngaa ni̱ xiꞌí si huīnj daꞌníj Yanꞌanj, ni̱ gui̱nun yanꞌanj daranꞌ ni ngüi̱ riānj da̱j rúnꞌ nu̱n yanꞌanj ni sij rian manꞌan Yanꞌanj. Ni̱ daranꞌ ni ngüi̱ naꞌuej ruhua gui̱nun yanꞌanj riānj, ni̱ nitaj si nu̱n yanꞌanj ni sij rian manꞌan Yanꞌanj nej. Ni̱ Yanꞌanj huin si gaꞌníj gaꞌnāj. ");
INSERT INTO trq_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Xa̱ngaꞌ ataj snanꞌān gu̱nun a ni é re̱ꞌ: Tsínj unun si-nu̱guanꞌānj, ni̱ gu̱xuman ruhua sij ni̱ꞌyaj sij tsínj gaꞌníj gaꞌnāj, ngaa ni̱ ga̱ne ni̱ganj sij nga̱ Yanꞌanj. Ni̱ nitaj castigo ga̱huin sij, gui̱ꞌyaj Yanꞌanj mánj. Daj si rúnꞌ huin níman huin sij si hua ni̱ꞌnaꞌ niman sij, guiꞌyaj Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Xa̱ngaꞌ ataj snanꞌān gu̱nun a ni é re̱ꞌ: ꞌNa̱ꞌ gui̱sij güi ngaa gu̱nun ni níman si-nu̱guanꞌānj huīnj daꞌníj Yanꞌanj. Ni̱ yya̱j guisíj güi daj. Ni̱ ni ngüi̱ gu̱nun si-nu̱guanꞌānj, ni̱ ga̱ ni̱ꞌnaꞌ niman ni sij. ");
INSERT INTO trq_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Daj si da̱j rúnꞌ hua ni̱ꞌnaꞌ chrē, ni̱ daꞌngaꞌ daj riqui chrē sisi̱ hua ni̱ꞌnaꞌ manꞌānj huīnj daꞌníj-íꞌ. ");
INSERT INTO trq_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ni̱ riqui Yanꞌanj si na̱guiꞌyaj yyāj nga̱ si-ga̱quinꞌ ni ngüi̱ xiꞌí si huīnj daꞌníj ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","’Ni̱ si̱ gara yanꞌanj ruhua á re̱ꞌ xiꞌí nuguanꞌ nan mánj. Daj si ꞌna̱ꞌ gui̱sij güi ngaa gu̱nun daranꞌ ni níman ngaj riqui yuꞌuj si ga̱ꞌmī. ");
INSERT INTO trq_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ngaa ni̱ ga̱naꞌnij daranꞌ ni ngüi̱ guiꞌyaj sa̱ꞌ. Ni̱ ga̱ne ni̱ganj ni sij nga̱ Yanꞌanj. Ni̱ ga̱naꞌnij ni ngüi̱ guiꞌyaj quij. Sani̱ ga̱huin ni síꞌ castigo, gui̱ꞌyaj Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Ni̱ naꞌue ga̱huin nucuaj gui̱ꞌyā si aranꞌ ruhuāj. Sani̱ da̱j rúnꞌ aꞌninꞌ chrē sun riānj, ni̱ daꞌngaꞌ daj ꞌyaj yyāj rian ni ngüi̱. Ni̱ hua ni̱ca yya ꞌyaj yyāj. Ni̱ sé güenda manꞌānj ꞌyaj yyāj rian ni ngüi̱. Sani̱ ꞌyaj yyāj da̱j rúnꞌ aranꞌ ruhua chrē huin si gaꞌníj gaꞌnāj chruhua xungüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","’Sisi̱ huēj huin testigo xiꞌí manꞌānj, sani̱ nitaj si níꞌyanj si-nu̱guanꞌānj mánj. ");
INSERT INTO trq_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Sani̱ hua ango si huin testigo xiꞌí manꞌānj anj. Ni̱ niꞌīnj sisi̱ aꞌmi xa̱ngaꞌ Yanꞌanj xiꞌīj. ");
INSERT INTO trq_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","’Gaꞌníj a ni é re̱ꞌ ni tsínj ga̱nꞌanj na̱chinꞌ snanꞌanj Juan. Ni̱ xa̱ngaꞌ huin si gataj síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nitaj si hua nia̱n si ga̱ꞌmi sa̱ꞌ ni ngüi̱ xiꞌīj. Maan si atā nan rian án re̱ꞌ xiꞌí si huin ruhuāj sisi̱ ga̱nacaj Yanꞌanj a ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ni̱ da̱j rúnꞌ hua ꞌngo̱ yanꞌa̱n xigui̱n sa̱ꞌ rian ni ngüi̱, ni̱ daꞌngaꞌ daj rugüiꞌ sa̱ꞌ rian ni é re̱ꞌ, guiꞌyaj si-du̱cuanj Juan. Ni̱ do̱j ni güi gahuin nia̱ꞌ ruhua ni é re̱ꞌ nga̱ yanꞌa̱n daj. ");
INSERT INTO trq_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","’Sani̱ hua ango nuguanꞌ nico aꞌmi xiꞌīj daj nga̱ nuguanꞌ gaꞌmi Juan. Daj si gaꞌninꞌ chrē sun riānj si gui̱ꞌyā. Ni̱ xiꞌí sun ꞌyā daj ga̱ꞌue xa̱caj á re̱ꞌ cuenta sisi̱ gaꞌníj chrē gaꞌnāj chruhua xungüi̱ nan anj. ");
INSERT INTO trq_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ni̱ manꞌan chrē huin testigo aꞌmi xiꞌīj. Sani̱ nitaj a̱man gunun a ni é re̱ꞌ si gaꞌmi chrē. Ni̱ nitaj a̱man guiniꞌi a ni é re̱ꞌ da̱j hua chrē nej. ");
INSERT INTO trq_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ni̱ nun ga̱tu si-nu̱guanꞌ chrē chruhua niman a ni é re̱ꞌ. Daj si nun gu̱xuman ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ manꞌānj huin tsínj gaꞌníj chrē gaꞌna̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Diguiꞌyun ꞌueé a ni é re̱ꞌ si-nu̱guanꞌ Yanꞌanj sisi̱ ga̱ꞌue ga̱nariꞌ a ni é re̱ꞌ ga̱ne ni̱ganj ni é re̱ꞌ nga̱ Yanꞌanj anj. Sani̱ hué si-nu̱guanꞌ Yanꞌanj daj huin si aꞌmi xiꞌīj. ");
INSERT INTO trq_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Sani̱ naꞌuej ruhua á re̱ꞌ ga̱ꞌnaꞌ á re̱ꞌ riānj sisi̱ ga̱ne ni̱ganj án re̱ꞌ nga̱ Yanꞌanj, gui̱ꞌyā mánj. ");
INSERT INTO trq_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Nitaj si nanoꞌōj si ga̱ꞌmi sa̱ꞌ ni ngüi̱ xiꞌīj. ");
INSERT INTO trq_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Sani̱ niꞌīnj da̱j hua ruhua ni é re̱ꞌ sisi̱ nitaj si ꞌi̱ ruhua á re̱ꞌ niꞌyaj á re̱ꞌ Yanꞌanj mánj. ");
INSERT INTO trq_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Gaꞌnāj rian án re̱ꞌ nga̱ si-xugüi chrē. Sani̱ nun xu̱man ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ manꞌānj. Sani̱ sisi̱ hua ango tsínj ga̱ꞌnaꞌ nga̱ si-xugüi manꞌan sij, ngaa ni̱ gu̱xuman ruhua á re̱ꞌ si ga̱taj tsínj daj. ");
INSERT INTO trq_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Xiꞌí si huin ruhua á re̱ꞌ ga̱ꞌmi ꞌueé ni dugüiꞌ a ni é re̱ꞌ xiꞌí a ni é re̱ꞌ, ni̱ si̱ gaꞌue gu̱xuman ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ manꞌānj. Sani̱ nun nahuij ruhua á re̱ꞌ si ga̱ꞌmi ꞌueé Yanꞌanj xiꞌí a ni é re̱ꞌ mánj. Ni̱ nitaj ango Yanꞌanj mánj. ");
INSERT INTO trq_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Si̱ gahuin ruhua á re̱ꞌ sisi̱ manꞌānj huin si ga̱ꞌmi gaquinꞌ rian chrē xiꞌí a ni é re̱ꞌ mánj. Sani̱ tsínj gu̱ꞌnaj Moisés huin si ga̱ꞌmi gaquinꞌ xiꞌí a ni é re̱ꞌ. Ni̱ anaꞌuij a ni é re̱ꞌ sisi̱ ga̱hui sa̱ꞌ á re̱ꞌ rian Yanꞌanj, gui̱ꞌyaj síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Sisi̱ guxuman ruhua á re̱ꞌ niꞌyaj á re̱ꞌ Moisés, ni̱ gu̱xuman ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ manꞌānj nej. Daj si garun Moisés nuguanꞌ rian yanj xiꞌīj. ");
INSERT INTO trq_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Sani̱ sisi̱ nun xu̱man ruhua á re̱ꞌ si garun Moisés, ni̱ asa̱ꞌ ga̱ꞌue gu̱xuman ruhua á re̱ꞌ si ataj si-nu̱guanꞌānj únj. ―Daj gataj Jesús gunun ni tsínj huin achij rian ni tsínj israelita. ");
INSERT INTO trq_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Daꞌ síj da ni̱ ganꞌanj Jesús anéj chrej duꞌua laguna xa̱chij gu̱ꞌnaj Galilea. Ni̱ gu̱ꞌnaj laguna daj Tiberias nej. ");
INSERT INTO trq_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ni̱ nico ni ngüi̱ guinicoꞌ ganꞌanj sij. Daj si guiniꞌi ni síꞌ si sa̱ꞌ nico guiꞌyaj sij xiꞌí si ganahuin ni ngüi̱ aꞌnanꞌ, guiꞌyaj sij. ");
INSERT INTO trq_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ngaa ni̱ gahui Jesús chra̱ ꞌngo̱ quij ganꞌanj sij. Ni̱ ganꞌanj ga̱ne sij nga̱ ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ni̱ hua gahuin ni̱chrunꞌ guiꞌyanj pascua, guiꞌyaj ni tsínj israelita. ");
INSERT INTO trq_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ngaa ni̱ guiniꞌyaj Jesús sisi̱ ꞌna̱ꞌ nico ni ngüi̱ rian sij. Hué dan ni̱ gataj sij gunun tsínj gu̱ꞌnaj Felipe: ―Ni̱ a̱ gui̱runꞌ chrachrúnj sisi̱ xa̱ daranꞌ ni ngüi̱ nan, ruhuá re̱ꞌ únj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Sani̱ maan si huin ruhua Jesús xa̱caj sij cuenta da̱j ga̱taj Felipe. Daj si niꞌi sa̱ꞌ manꞌan Jesús si gui̱ꞌyaj sij. ");
INSERT INTO trq_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ngaa ni̱ gataj Felipe: ―Sisi̱ gui̱runꞌ hui̱j ciento denario chrachrúnj, sani̱ si̱ guisíj xa̱ daranꞌ ni ngüi̱ nan do̱j mánj. ―Daj gataj Felipe gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ni̱ niquinꞌ ꞌngo̱ tsínj nicoꞌ Jesús huin síꞌ jnánj Simón Pedro. Ni̱ Andrés gu̱ꞌnaj síꞌ. Ni̱ gataj síꞌ gunun Jesús: ");
INSERT INTO trq_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Nan niquinꞌ ꞌngo̱ tsinꞌ snoꞌo nicaj u̱nꞌunꞌ gue̱ chrachrúnj cebada nga̱ hui̱j xucuaj le. Sani̱ asa̱ꞌ gui̱sij do̱j nan xa̱ nico ni ngüi̱ nan únj. ―Daj gataj sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ngaa ni̱ gataj Jesús: ―Gui̱ꞌyaj á re̱ꞌ sisi̱ ga̱ne ni sij. ―Daj gataj Jesús. Ni̱ ma̱n ni̱nꞌ ruhua chinꞌ yuꞌuj daj. Ni̱ guisíj ꞌngo̱ si u̱nꞌunꞌ mil ni tsínj ganꞌanj gui̱man yuꞌuj daj. ");
INSERT INTO trq_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ngaa ni̱ guidaꞌa Jesús chrachrúnj daj. Ni̱ nagaꞌuiꞌ sij si guruhua Yanꞌanj. Ngaa ni̱ daꞌngaꞌ sij chrachrúnj daj rian ni tsínj nicoꞌ sij sisi̱ na̱gaꞌuiꞌ ni síꞌ raꞌa ni ngüi̱ mán yuꞌuj daj. Ni̱ hué daj guiꞌyaj sij nga̱ xucuaj nej. Ni̱ xa ni sij da̱j rúnꞌ garanꞌ ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ni̱ ngaa guisíj gara ran riqui ni sij, ni̱ gataj Jesús gunun ni tsínj nicoꞌ sij: ―Na̱ranꞌ ni é re̱ꞌ ni chrachrúnj xitinꞌ gunáj da sisi̱ si̱ guereꞌej aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ngaa ni̱ naranꞌ ni sij si gunáj daj. Ngaa ni̱ gara xu̱huij xuguti chrachrúnj xitinꞌ guna daj ngaa guisíj xa ni ngüi̱ u̱nꞌunꞌ chrachrúnj daj. ");
INSERT INTO trq_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ni̱ ngaa guiniꞌi ni tsínj daj si sa̱ꞌ guiꞌyaj sun Jesús, ni̱ gataj ni sij: ―Xa̱ngaꞌ ni̱ hué tsínj nan huin tsínj ga̱ꞌnaꞌ chruhua xungüi̱ huin síꞌ tsínj ga̱ꞌmi si-nu̱guanꞌ Yanꞌanj anj. ―Daj gataj ni sij xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ngaa ni̱ ri̱an xacaj Jesús cuenta sisi̱ huin ruhua ni sij gui̱daꞌa ni sij síꞌ ga̱huin síꞌ rey rian ni sij, ni̱ guxun anéj síꞌ manꞌan síꞌ ganꞌanj ru̱huaꞌ yún síꞌ chra̱ quij sisi̱ ga̱ne urin síꞌ yuꞌuj daj. ");
INSERT INTO trq_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ni̱ ngaa ruhua guini̱, ni̱ nanij ni tsínj nicoꞌ Jesús gaꞌna̱ꞌ ni sij duꞌua laguna xa̱chij daj. ");
INSERT INTO trq_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ni̱ gahui ni sij chruhua ꞌngo̱ rio̱ achéj rian nnee. Ni̱ huaj ni sij gui̱sij ni sij anéj chrej duꞌua laguna ne̱ꞌ xumanꞌ gu̱ꞌnaj Capernaum. Ni̱ huaj gahuin ru̱miꞌ. Ni̱ achin si na̱sij Jesús rian ma̱n ni sij. ");
INSERT INTO trq_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ni̱ ahui nane̱ nucuaj rian nnee daj. Ni̱ naxu̱man nnee, guiꞌyaj nane̱ nucuaj daj. ");
INSERT INTO trq_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ni̱ ngaa huaj ni sij gui̱sij ni sij ꞌngo̱ si u̱nꞌunꞌ hua̱tanꞌ kilómetro rian laguna daj, ni̱ guiniꞌi ni sij sisi̱ huaj ꞌna̱ꞌ Jesús achéj síꞌ rian nnee. Ni̱ gahuin ni̱chrunꞌ síꞌ rian rio̱ nu̱n ni sij. Ni̱ guxuꞌuiꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Sani̱ gataj Jesús gunun ni sij: ―Si̱ guxuꞌuiꞌ ni é re̱ꞌ si manꞌānj huin. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ngaa ni̱ gahuin nia̱ꞌ ruhua ni sij sisi̱ ga̱hui síꞌ chruhua rio̱ daj. Ni̱ hora guisíj rio̱ daj duꞌua yoꞌój rian huaj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Hué dan ni̱ ango güi ni̱ xacaj ni ngüi̱ ma̱n anéj duꞌua laguna daj cuenta sisi̱ ganꞌanj ni tsínj nicoꞌ Jesús chruhua urin rio̱ niquinꞌ yuꞌuj daj. Sani̱ guiniꞌi ni sij sisi̱ nun ganꞌanj Jesús nga̱ ni sij. ");
INSERT INTO trq_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Sani̱ gaꞌna̱ꞌ do̱j rio̱ gahui xumanꞌ Tiberias duꞌua laguna ni̱chrunꞌ rian xa ni ngüi̱ chrachrúnj ngaa nagaꞌuiꞌ señor Jesús si guruhua Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ni̱ ngaa guiniꞌi ni ngüi̱ sisi̱ nitaj Jesús niquinꞌ yuꞌuj daj, nga̱ ni tsínj nicoꞌ sij, ni̱ gahui ni sij chruhua rio̱ ganꞌanj na̱noꞌ ni sij Jesús xumanꞌ Capernaum. ");
INSERT INTO trq_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ni̱ ngaa guisíj ni sij anéj chrej duꞌua laguna daj, ni̱ nariꞌ ni sij Jesús. Ngaa ni̱ nachínj snanꞌanj ni sij síꞌ. Ni̱ gataj ni sij: ―Rabí, a̱man guisíj re̱ꞌ nan únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ngaa ni̱ gataj Jesús: ―Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ sé xiꞌí si guiniꞌi a ni é re̱ꞌ si sa̱ꞌ digyānj rian ni ngüi̱ huin si nanoꞌ ni é re̱ꞌ yūnj mánj. Sani̱ nanoꞌ ni é re̱ꞌ yūnj xiꞌí si xa ni é re̱ꞌ chrachrúnj daꞌ gara riqui ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","’Si̱ guiꞌyaj sun ni é re̱ꞌ xiꞌí ni̱nanj si gui̱riꞌ a ni é re̱ꞌ ni rasu̱n xa̱ á re̱ꞌ mánj. Daj si nahuij ráꞌyanj ni rasu̱n daj. Sani̱ gui̱ꞌyaj sun a ni re̱ꞌ sisi̱ ga̱ sa̱ꞌ niman án re̱ꞌ. Ngaa ni̱ ga̱ ni̱ꞌnaꞌ ni̱ganj yya niman ni é re̱ꞌ aj. Hué si sa̱ꞌ nan huin si riquīj rian án re̱ꞌ huīnj daꞌníj ni ngüi̱. Daj si gataj Yanꞌanj huin chrē sisi̱ ga̱ꞌue gui̱ꞌyā daj xiꞌí a ni é re̱ꞌ aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ngaa ni̱ gataj ni sij: ―Ni̱ u̱n sun gui̱ꞌyaj sun ni únj, ruhua Yanꞌanj únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ngaa ni̱ gataj Jesús: ―Nan huin sun huin ruhua Yanꞌanj gui̱ꞌyaj sun a ni é re̱ꞌ sisi̱ gu̱xuman ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ manꞌānj huīnj tsínj gaꞌníj Yanꞌanj gaꞌna̱ꞌ rian án re̱ꞌ aj. ―Gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ngaa ni̱ gataj ni sij: ―Ni̱ u̱n si sa̱ꞌ nico gui̱ꞌyáj re̱ꞌ gui̱niꞌi ni únj, ngaa ni̱ gu̱xuman ruhua ni únj ni̱ꞌyaj ni únj manꞌán re̱ꞌ únj. Daj hua si gui̱ꞌyáj re̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Xa xi ni únj si gu̱ꞌnaj maná ngaa gachéj ni sij riqui quij quiꞌyanj na̱co, guiꞌyaj Yanꞌanj asi̱j ná. Daj si ataj si-nu̱guanꞌ Yanꞌanj: “Gaꞌuiꞌ Yanꞌanj chrachrúnj ꞌna̱ꞌ xataꞌ xa ni sij.” Daj ataj si-nu̱guanꞌ Yanꞌanj. ―Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ngaa ni̱ gataj Jesús: ―Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ sé Moisés huin si riqui chrachrúnj ꞌna̱ꞌ xataꞌ xa ni é re̱ꞌ mánj. Sani̱ chrē huin si riqui chrachrúnj xa̱ngaꞌ ꞌna̱ꞌ xataꞌ xa̱ á re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Daj si chrachrúnj riqui Yanꞌanj rian án re̱ꞌ huin manꞌānj, tsínj ꞌna̱ꞌ xataꞌ. Ni̱ hua ni̱ꞌnaꞌ ni̱ganj niman ni ngüi̱, ꞌyaj manꞌānj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ngaa ni̱: ―Ni̱ganj ri̱qui re̱ꞌ chrachrúnj daj xa̱ ni únj, Señor. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ngaa ni̱ gataj Jesús: ―Huēj huin chrachrúnj ꞌyaj si hua ni̱ꞌnaꞌ ni ngüi̱. Ni̱ tsínj ꞌna̱ꞌ riānj, ni̱ nitaj a̱man ga̱chin xiꞌna̱ riqui sij mánj. Ni̱ tsínj xuman ruhua niꞌyaj manꞌānj, ni̱ nitaj a̱man na̱goꞌo sij nnee mánj. ");
INSERT INTO trq_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ni̱ hua gatā gunun a ni é re̱ꞌ sisi̱ nu̱nj si guiniꞌi a ni é re̱ꞌ manꞌānj, sani̱ nun gu̱xuman ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ manꞌānj mánj. ");
INSERT INTO trq_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Daranꞌ ni ngüi̱ riqui chrē riānj, ni̱ ga̱ꞌnaꞌ ni sij riānj. Ni̱ nitaj a̱man gui̱rīj xe̱ꞌ ni sij ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sé si ꞌnāj xataꞌ sisi̱ gui̱ꞌyā si aranꞌ ruhua manꞌānj. Sani̱ gui̱ꞌyā si aranꞌ ruhua chrē si gaꞌníj gaꞌnāj. ");
INSERT INTO trq_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ni̱ naꞌuej ruhua chrē sisi̱ ga̱ niꞌya ni̱ a̱ ꞌngo̱ ni ngüi̱ riquij riānj mánj. Sani̱ ga̱naꞌnij daranꞌ ni ngüi̱ daj, gui̱ꞌyā güi ga̱nahuij xungüi̱ nan. ");
INSERT INTO trq_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ni̱ nuguanꞌ nan huin si huin ruhua chrē: Sisi̱ ga̱ne ni̱ganj daranꞌ ni ngüi̱ xuman ruhua niꞌyaj manꞌānj huīnj daꞌníj Yanꞌanj. Ni̱ huēj gui̱ꞌyaj si ga̱naꞌnij ni sij güi ga̱nahuij xungüi̱ aj. ―Daj gataj Jesús gunun ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Hué xiꞌí daj ni̱ gaxi̱ꞌi gaꞌmi gaquinꞌ ni tsínj israelita xiꞌí Jesús. Daj si gataj sij: “Manꞌān huin chrachrúnj ꞌna̱ꞌ xataꞌ.” Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ngaa ni̱ gataj ni sij: ―Nitaj daꞌníj José huin Jesús míꞌ. Ni̱ niꞌi néꞌ chrej sij nga̱ nni sij nej. Ni̱ u̱n sin huin ataj sij sisi̱ ꞌna̱ꞌ sij xataꞌ únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ngaa ni̱ gataj Jesús: ―Si̱ gaꞌmi gaquinꞌ ni é re̱ꞌ scanij a ni é re̱ꞌ xiꞌīj mánj. ");
INSERT INTO trq_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ni̱ a̱ ꞌngo̱ ni ngüi̱ si̱ gaꞌue ga̱ꞌnaꞌ riānj sisi̱ nitaj si nicaj chrē ga̱ꞌnaꞌ sij riānj mánj. Ni̱ hué chrē huin si gaꞌníj gaꞌnāj. Ni̱ huēj gui̱ꞌyaj sisi̱ ga̱naꞌnij tsínj ꞌna̱ꞌ riánj güi ga̱nahuij xungüi̱ nan. ");
INSERT INTO trq_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ni̱ ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná, ni̱ garun ni sij nuguanꞌ nan rian yanj: “Yanꞌanj huin si di̱gyán rian daranꞌ ni ngüi̱.” Daj garun ni sij. Ni̱ huin ruhuaj gata sisi̱ daranꞌ ni ngüi̱ unun si ataj chrē, ni̱ nariꞌ si-nu̱guanꞌ chrē, ni̱ ꞌna̱ꞌ ni sij riānj. ");
INSERT INTO trq_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ni̱ a̱ ꞌngo̱ ni ngüi̱ nun gui̱niꞌi chrē. Urin manꞌānj tsínj ꞌna̱ꞌ rian chrē huēj huin si guiniꞌi chrē aj. ");
INSERT INTO trq_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","’Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ: Ni ngüi̱ xuman ruhua niꞌyaj manꞌānj, ni̱ ga̱ne ni̱ganj ni sij nga̱ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Huēj huin chrachrúnj ꞌyaj si ga̱ ni̱ꞌnaꞌ ni̱ganj niman án re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ni̱ xi ni é re̱ꞌ, sani̱ xa ni síꞌ maná ngaa gachéj ni síꞌ riqui quij quiꞌyanj na̱co asi̱j ná. Ngaa ni̱ gahuiꞌ ni sij nánj. ");
INSERT INTO trq_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Sani̱ aꞌmī xiꞌí chrachrúnj ꞌna̱ꞌ xataꞌ huin manꞌānj. ");
INSERT INTO trq_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Huēj huin chrachrúnj hua ni̱ꞌnaꞌ ꞌna̱ꞌ xataꞌ. Ni̱ ni tsínj xa̱ chrachrúnj da, ni̱ ga̱ne ni̱ganj ni sij. Ni̱ chrachrúnj ri̱quīj daj xa̱ á re̱ꞌ huin nnee̱ cū. Ni̱ ga̱ꞌue ga̱ ni̱ꞌnaꞌ ni ngüi̱ ma̱n chruhua xungüi̱, gui̱ꞌyaj nnee̱ cū aj. ―Daj gataj Jesús gunun ni tsínj israelita. ");
INSERT INTO trq_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ngaa ni̱ gaꞌman ruhua ni du̱güiꞌ ni tsínj israelita. Ni̱ gataj ni sij gunun ni dugüiꞌ ni sij: ―Asa̱ꞌ ga̱ꞌue gui̱ꞌyaj tsínj nan ri̱qui sij nnee̱ cúj sij xa̱ néꞌ únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ngaa ni̱ gataj Jesús: ―Xa̱ngaꞌ ataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ si̱ xa á re̱ꞌ nnee̱ cū, ni̱ sisi̱ si̱ goꞌo a ni é re̱ꞌ si-tun manꞌānj huīnj daꞌníj ni ngüi̱, ni̱ si̱ gaꞌue ga̱ ni̱ꞌnaꞌ niman ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tsínj xa nnee̱ cū, ni̱ goꞌo sij si-tun manꞌānj, ni̱ ga̱ne ni̱ganj niman sij, gui̱ꞌyā. Ni̱ huēj gui̱ꞌyā sisi̱ ga̱naꞌnij sij güi ga̱nahuij xungüi̱ nan. ");
INSERT INTO trq_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Daj si nnee̱ cū huin chrachrúnj xa̱ngaꞌ xa̱ á re̱ꞌ. Ni̱ si-tun manꞌānj huin nnee xa̱ngaꞌ go̱ꞌo a ni é re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ni̱ tsínj xa nnee̱ cū, ni̱ goꞌo si-tun manꞌānj, ni̱ nne nu̱guanꞌan sij ngāj. Ni̱ nnēj nu̱guanꞌan nga̱ sij nej. ");
INSERT INTO trq_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Hua ni̱ꞌnaꞌ chrē si gaꞌníj gaꞌnāj. Ni̱ hua ni̱ꞌnaꞌ manꞌānj, guiꞌyaj chrē. Ni̱ hué ducuánj da huin sisi̱ ga̱ ni̱ꞌnaꞌ niman tsínj xa manꞌānj, gui̱ꞌyā. ");
INSERT INTO trq_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ni̱ aꞌmī xiꞌí chrachrúnj ꞌna̱ꞌ xataꞌ huin manꞌānj: Ni̱ni huin maná xa ni xi a ni é re̱ꞌ ngaa ná. Ni̱ gahuiꞌ ni síꞌ. Sé daj huin chrachrúnj nan mánj. Ni̱ tsínj xa̱ chrachrúnj huin manꞌānj, ni̱ ga̱ne ni̱ganj niman sij nga̱ Yanꞌanj anj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ni̱ digyán Jesús ni nuguanꞌ nan rian ni ngüi̱ ngaa nahuin yuꞌ ni sij chruhua nuhui nico nne xumanꞌ Capernaum. ");
INSERT INTO trq_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ni̱ ngaa gunun ni tsínj nicoꞌ Jesús nuguanꞌ daj, ni̱ gataj daꞌaj ni sij: ―Cu hua nuguanꞌ aꞌmi sij. Da̱j hua ꞌngo̱ néꞌ ga̱ꞌue gu̱nun nuguanꞌ nan, ruhua á re̱ꞌ únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ngaa ni̱ xacaj Jesús cuenta sisi̱ aꞌmi hui̱ ni sij xiꞌí si gaꞌmi síꞌ. Ngaa ni̱ gataj síꞌ: ―Chranꞌ yunꞌunj nuguanꞌ nan gatā gunun a ni é re̱ꞌ níꞌ. ");
INSERT INTO trq_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Da̱j ga̱huin ruhua á re̱ꞌ sisi̱ gui̱niꞌi a ni é re̱ꞌ si ga̱hui manꞌānj gui̱nanꞌ manꞌānj rian gane sinīj huīnj daꞌníj ni ngüi̱ únj. ");
INSERT INTO trq_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Hua ni̱ꞌnaꞌ niman néꞌ ꞌyaj Espíritu Santo. Sé nnee̱ cúj néꞌ ꞌyaj si hua ni̱ꞌnaꞌ niman néꞌ mánj. Nuguanꞌ gaꞌmī rian án re̱ꞌ huin nuguanꞌ ꞌna̱ꞌ rian Espíritu Santo. Ni̱ ga̱ꞌue ga̱ ni̱ꞌnaꞌ niman án re̱ꞌ, gui̱ꞌyaj nuguanꞌ daj. ");
INSERT INTO trq_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Sani̱ hua daꞌaj ni é re̱ꞌ achin gu̱xuman ruhua ni̱ꞌyaj yūnj. ―Daj gataj Jesús. Daj si asi̱j sini ya̱n, ni̱ hua niꞌi Jesús ni tsínj nun gu̱xuman ruhua ni̱ꞌyaj manꞌan sij. Ni̱ hua niꞌi sij tsínj na̱gaꞌuiꞌ sij raꞌa ni tsínj nicaj sun. ");
INSERT INTO trq_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ngaa ni̱ gataj Jesús: ―Hué xiꞌí si nun gu̱xuman ruhua daꞌaj á re̱ꞌ, ni̱ hua gatā gunun a ni é re̱ꞌ sisi̱ ni̱ a̱ ꞌngo̱ ni ngüi̱ si̱ gaꞌue ga̱ꞌnaꞌ riānj sisi̱ nitaj si ni̱caj chrē ga̱ꞌnaꞌ ni sij riānj anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ni̱ asi̱j güi daj, ni̱ duna daꞌaj ni tsínj nicoꞌ Jesús si gachéj ni síꞌ nga̱ sij. ");
INSERT INTO trq_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ngaa ni̱ nachínj snanꞌanj Jesús ni xu̱huij ni tsínj nicoꞌ sij. Ni̱ gataj sij: ―Ni̱ hué daj huin ruhua á re̱ꞌ du̱na á re̱ꞌ manꞌānj níꞌ. ―Gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ngaa ni̱ gataj Simón Pedro: ―Ni̱ u̱n tsínj ri̱an ga̱nꞌanj ni únj únj. Si-nu̱guanꞌ manꞌán re̱ꞌ ꞌyaj si hua ni̱ꞌnaꞌ ni̱ganj ni únj rian Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ni̱ hua guxuman ruhua ni únj niꞌyaj ni únj manꞌán re̱ꞌ. Ni̱ niꞌi ni únj sisi̱ manꞌán re̱ꞌ huin Cristo huín re̱ꞌ daꞌníj Yanꞌanj xa̱ngaꞌ. ―Daj gataj Pedro gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ngaa ni̱ gataj Jesús: ―Sé si nacuīj ni xu̱huij ranꞌ ni é re̱ꞌ a̱ꞌ. Sani̱ ꞌngo̱ a ni é re̱ꞌ huin sichre aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ni̱ ngaa gataj Jesús nuguanꞌ daj, ni̱ gaꞌmi sij xiꞌí Judas daꞌníj tsínj gu̱ꞌnaj Simón Iscariote. Daj si Judas huin tsínj nagaꞌuiꞌ Jesús raꞌa ni tsínj nicaj sun. Ni̱ huin Judas ꞌngo̱ ni xu̱huij ni tsínj nicoꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Daꞌ síj da ni̱ gachéj Jesús estado Galilea. Ni̱ nun ga̱ꞌuej ruhua sij ga̱che sij estado Judea si nanoꞌ ni tsínj israelita manꞌan sij. Ni̱ da̱gahuiꞌ ni síꞌ sij, ruhua ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ni̱ gahuin ni̱chrunꞌ güi gui̱ꞌyaj ni tsínj israelita guiꞌyanj ngaa guiꞌyaj ni sij hueꞌ recoj. ");
INSERT INTO trq_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ngaa ni̱ gataj ni jnánj Jesús gunun sij: ―Güi̱j so̱ꞌ estado Judea. Ngaa ni̱ gui̱niꞌi ni tsínj nicoꞌ so̱ꞌ si sa̱ꞌ nico ꞌyaj so̱ꞌ jnánj. ");
INSERT INTO trq_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Sisi̱ huin ruhua ꞌngo̱ tsínj daj gui̱niꞌi ni ngüi̱ da̱j hua manꞌan sij, ngaa ni̱ nitaj si arij hui̱ sij si ꞌyaj sij mánj. Sisi̱ yya ꞌyáj re̱ꞌ si sa̱ꞌ nico, ngaa ni̱ gui̱ꞌyáj so̱ꞌ sun daj rian gui̱niꞌi daranꞌ ni ngüi̱ aj. ―Daj gataj ni jnánj Jesús gunun sij. ");
INSERT INTO trq_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Daj si da ni jnánj Jesús nun gu̱xuman ruhua ni̱ꞌyaj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ngaa ni̱ gataj Jesús gunun ni sij: ―Achin si gui̱sij güi gui̱ꞌyaj sūnj si-sun manꞌānj. Da̱j na̱nj ga̱huin güi ni̱ ga̱ꞌue gui̱ꞌyaj sun aninꞌ é re̱ꞌ si-sun aninꞌ é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nitaj xiꞌí ga̱ꞌmi quij ni tsínj ma̱n chruhua xungüi̱ gaquinꞌ nan xiꞌí a ni é re̱ꞌ mánj. Sani̱ nitaj si huin xa̱nꞌ ruhua ni sij niꞌyaj ni sij manꞌānj. Daj si ataj snanꞌān rian ni ngüi̱ sisi̱ nitaj si hua sa̱ꞌ si ꞌyaj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Güi̱j aninꞌ é re̱ꞌ guiꞌyanj daj. Achin si ga̱nꞌanj manꞌānj. Daj si achin gui̱sij güi gui̱ꞌyaj sūnj si-sun manꞌānj. ");
INSERT INTO trq_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","―Hué daj gataj Jesús gunun ni jnánj sij, ni̱ guna sij estado Galilea. ");
INSERT INTO trq_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Sani̱ ngaa guisíj gahui ni jnánj sij ganꞌanj ni síꞌ guiꞌyanj daj, ni̱ hué daj ganꞌanj manꞌan Jesús nej. Sani̱ nun digyán re̱ngaꞌ sij manꞌan sij rian ni ngüi̱ mánj. ");
INSERT INTO trq_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Sani̱ nanoꞌ ni tsínj israelita Jesús. Ni̱ gataj ni síꞌ gunun ni dugüiꞌ ni síꞌ: ―Ni̱ a̱ huaj tsínj da únj. ―Daj gataj ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ni̱ ducu gaꞌmi guitsi dugüiꞌ ni ngüi̱ xiꞌí Jesús. Ni̱ gataj daꞌaj ni sij: ―Tsínj sa̱ꞌ huin síꞌ. ―Gataj daꞌaj ni sij. Sani̱ gataj ango daꞌaj ni sij: ―Sé daj huin mánj. Tsínj digyaꞌ yunꞌunj ni ngüi̱ huin síꞌ. ―Gataj ango daꞌaj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Sani̱ ni̱ a̱ ꞌngo̱ ni ngüi̱ nun gaꞌmi re̱ngaꞌ xiꞌí Jesús. Daj si xuꞌuiꞌ ni sij niꞌyaj ni sij ni tsínj israelita. ");
INSERT INTO trq_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Huaj ganahuij daꞌaj guiꞌyanj, ni̱ gatúj Jesús chruhua nuhui nico. Ni̱ gaxi̱ꞌi sij digyán sij rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ni̱ gara yanꞌanj ruhua ni tsínj israelita nga̱ si-nu̱guanꞌ Jesús. Ni̱ gataj ni sij gunun ni dugüiꞌ ni sij: ―Da̱j gui̱ꞌyaj tsínj nan gahuin chru̱n sij, ni̱ nun diguiꞌyun sij mánj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ngaa ni̱ gataj Jesús: ―Sé si-nu̱guanꞌānj huin nuguanꞌ aꞌmī mánj. Sani̱ si-nu̱guanꞌ si gaꞌníj gaꞌnāj huin aj. ");
INSERT INTO trq_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Sisi̱ hua ꞌngo̱ tsínj huin ruhua da̱gahuin si aranꞌ ruhua Yanꞌanj, ni̱ xa̱caj sij cuenta sisi̱ nuguanꞌ aꞌmī nan huin nuguanꞌ ꞌna̱ꞌ rian Yanꞌanj. Ni̱ xa̱caj sij cuenta sisi̱ nitaj si aꞌmī güenda manꞌānj mánj. ");
INSERT INTO trq_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ni̱ tsínj aꞌmi güenda manꞌan sij, ni̱ huin ruhua sij sisi̱ ga̱ꞌmi sa̱ꞌ ni ngüi̱ xiꞌí manꞌan sij. Sani̱ tsínj huin ruhua sisi̱ ga̱ꞌmi sa̱ꞌ ni ngüi̱ xiꞌí si gaꞌníj ga̱ꞌnaꞌ síꞌ, ni̱ xa̱ngaꞌ si ataj síꞌ. Ni̱ nitaj si ꞌyaj xi̱ꞌi síꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Xa̱ngaꞌ riqui Moisés si-ley Yanꞌanj rian án re̱ꞌ. Sani̱ ni̱ a̱ ꞌngo̱ ni é re̱ꞌ nun dagahuin ley da mánj. Ni̱ u̱n sin huin ni̱ da̱gahuiꞌ ni é re̱ꞌ manꞌānj, ruhua á re̱ꞌ únj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ngaa ni̱ gataj ni sij: ―Nun nane̱ xi̱ꞌi nimán re̱ꞌ. Ni̱ u̱n tsínj huin ruhua da̱gahuiꞌ re̱ꞌ, ruhuá re̱ꞌ únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ni̱ gataj Jesús: ―Daranꞌ ni é re̱ꞌ gara yanꞌanj ruhua nga̱ urin si sa̱ꞌ nico, guiꞌyā. ");
INSERT INTO trq_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ni̱ gaꞌninꞌ Moisés sun rian án re̱ꞌ sisi̱ gu̱taꞌ ni é re̱ꞌ daꞌngaꞌ ni lij snoꞌo. Sani̱ sé rian Moisés gaxi̱ꞌi guiꞌyaj ni sij daj. Daj si daꞌngaꞌ daj guiꞌyaj ni xi néꞌ asi̱j ná snoꞌo. Ni̱ daꞌ güi naránj ruhua néꞌ, ni̱ utaꞌ á re̱ꞌ daꞌngaꞌ ni lij snoꞌo. ");
INSERT INTO trq_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ni̱ sisi̱ aꞌuej ruhua á re̱ꞌ sisi̱ gu̱taꞌ á re̱ꞌ daꞌngaꞌ ni lij snoꞌo güi naránj ruhua néꞌ xiꞌí si huin ruhua á re̱ꞌ da̱gahuin a ni é re̱ꞌ si-ley Moisés, ngaa ni̱ u̱n sin huin ni̱ aꞌman ruhua á re̱ꞌ niꞌyaj á re̱ꞌ manꞌānj xiꞌí si ganahuin sa̱ꞌ ꞌngo̱ tsínj, guiꞌyā güi naránj ruhua néꞌ únj. ");
INSERT INTO trq_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Si̱ gaꞌmi gaquinꞌ ni é re̱ꞌ xiꞌí dugüiꞌ ni é re̱ꞌ ngaa nun niꞌi yya ni é re̱ꞌ da̱j hua si ꞌyaj sij. Sani̱ ga̱ꞌmi ni̱ca yya ni é re̱ꞌ nga̱ xiꞌí si ꞌyaj sij aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Xiꞌí daj ni̱ gataj go̱ꞌngo ni tsínj nne xumanꞌ Jerusalén: ―Sé tsínj nan nanoꞌ ni sij da̱gahuiꞌ ni sij a̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Niquinꞌ síꞌ aꞌmi re̱ngaꞌ síꞌ rian ni ngüi̱. Ni̱ nitaj si chranꞌ yunꞌunj ni sij manꞌan síꞌ mánj. Ani ruhua ni tsínj nicaj sun sisi̱ hué tsínj nan huin Cristo níꞌ. ");
INSERT INTO trq_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Sani̱ niꞌi néꞌ ni̱ a̱ ꞌna̱ꞌ tsínj nan anj. Ni̱ ngaa ga̱ꞌnaꞌ Cristo, ni̱ a̱ ꞌngo̱ ni ngüi̱ nun gui̱niꞌi ni̱ a̱ ga̱ꞌnaꞌ síꞌ mánj. ―Daj gataj ni tsínj nne Jerusalén. ");
INSERT INTO trq_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ni̱ ngaa guiniquinꞌ Jesús chruhua nuhui, ni̱ gaꞌmi nucuaj sij digyán sij rian ni ngüi̱. Ni̱ gataj sij: ―Niꞌi a ni é re̱ꞌ manꞌānj. Ni̱ niꞌi a ni é re̱ꞌ ni̱ a̱ ꞌnāj nej. Sani̱ sé si ꞌnāj güenda manꞌānj. Yanꞌanj si xa̱ngaꞌ huin gaꞌníj gaꞌnāj. Sani̱ nun niꞌi a ni é re̱ꞌ Yanꞌanj mánj. ");
INSERT INTO trq_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Sani̱ niꞌīnj Yanꞌanj. Daj si hué rian Yanꞌanj ꞌnāj. Ni̱ Yanꞌanj huin si gaꞌníj gaꞌnāj nej. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ngaa ni̱ huin ruhua ni sij gui̱daꞌa ni sij Jesús. Sani̱ ni̱ a̱ ꞌngo̱ ni sij nun guidaꞌa síꞌ si achin gui̱sij güi ga̱ꞌue gui̱daꞌa ni sij síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ni̱ nico ni ngüi̱ guxuman ruhua niꞌyaj Jesús. Ni̱ gataj ni sij: ―Ni̱ ngaa ga̱ꞌnaꞌ Cristo ni̱ si̱ gaꞌue gui̱ꞌyaj síꞌ si sa̱ꞌ nico daj nga̱ si ꞌyaj tsínj nan mánj. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ngaa ni̱ gunun ni tsínj fariseo si gaꞌmi hui̱ ni ngüi̱ xiꞌí Jesús. Ngaa ni̱ gaꞌníj ni tsínj aꞌninꞌ rian ni chrej nga̱ ni tsínj fariseo ni tsínj policía ga̱nꞌanj gui̱daꞌa ni síꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ngaa ni̱ gataj Jesús: ―Do̱j ni güi ga̱nēj nga̱ á re̱ꞌ. Ngaa ni̱ na̱nicaj nanꞌānj rian si gaꞌníj gaꞌnāj. ");
INSERT INTO trq_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Na̱noꞌ ni é re̱ꞌ manꞌānj. Sani̱ si̱ nariꞌ a ni é re̱ꞌ mánj. Daj si si̱ gaꞌue ga̱huin nucuaj á re̱ꞌ ga̱nꞌanj án re̱ꞌ rian ga̱nꞌanj ga̱nēj mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ngaa ni̱ gaxi̱ꞌi ni tsínj israelita nachínj snanꞌanj ni sij ni du̱güiꞌ manꞌan ni sij. Ni̱ gataj ni sij: ―Ni̱ a̱ ga̱nꞌanj tsínj nan, ni̱ si̱ nariꞌ néꞌ sij únj. Ga̱nꞌanj sij rian ni dugüiꞌ néꞌ ni tsínj gaxaꞌni̱ scanij ni ngüi̱ griego níꞌ. Ni̱ di̱gyán sij si-nu̱guanꞌ sij rian ni ngüi̱ griego níꞌ. ");
INSERT INTO trq_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ni̱ gataj sij gunun néꞌ: “Na̱noꞌ a ni é re̱ꞌ manꞌānj. Sani̱ si̱ nariꞌ a ni é re̱ꞌ mánj. Daj si si̱ gaꞌue ga̱nꞌanj án re̱ꞌ rian ga̱nꞌanj ga̱nēj mánj.” Ni̱ u̱n sin huin ruhuaj gata nuguanꞌ daj, ruhua á re̱ꞌ únj. ―Daj gataj ni sij gunun ni dugüiꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ni̱ ngaa huaj ganahuij guiꞌyanj nico, guiꞌyaj ni sij huin güi gara nico ni ngüi̱, ni̱ ganiquinꞌ Jesús. Ni̱ gataj sij: ―Sisi̱ hua go̱ꞌngo a ni é re̱ꞌ nagoꞌo nnee, ni̱ ga̱ꞌnaꞌ á re̱ꞌ riānj. Ni̱ ri̱quīj nnee go̱ꞌo a ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tsínj xuman ruhua niꞌyaj manꞌānj, ni̱ ga̱ra nico nuguanꞌ sa̱ꞌ niman sij da̱j rúnꞌ ꞌyaj xinéj nnee chéj, ni̱ daꞌngaꞌ daj ga̱huin niman sij nga̱ nuguanꞌ sa̱ꞌ. Ni̱ ga̱ꞌue ga̱ ni̱ꞌnaꞌ niman sij, gui̱ꞌyā. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ni̱ hué daj gaꞌmi sij xiꞌí Espíritu Santo ga̱ꞌnaꞌ rian ni ngüi̱ guxuman ruhua niꞌyaj sij. Daj si achin si ga̱ꞌnaꞌ Espíritu Santo rian ni ngüi̱ si achin si ga̱nahuin na̱ca nnee̱ cúj sij. ");
INSERT INTO trq_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ni̱ ngaa gunun go̱ꞌngo ni ngüi̱ daj si-nu̱guanꞌ Jesús, ngaa ni̱ gataj ni sij: ―Xa̱ngaꞌ hué tsínj nan huin tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ni̱ gataj ango ni sij: ―Hué sij huin Cristo. ―Gataj ni sij. Sani̱ gataj ángo ni sij: ―Si̱ gaꞌna̱ꞌ Cristo estado Galilea mánj. ");
INSERT INTO trq_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Rian si-nu̱guanꞌ Yanꞌanj ataj sisi̱ Cristo ga̱huin daꞌni̱ siꞌni̱ rey David. Ni̱ xánj sij huin xumanꞌ Belén rian gane David asi̱j ná nej. ―Daj gataj ango ni ngüi̱ daj. ");
INSERT INTO trq_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Hué dan ni̱ gaꞌmi guitsi ni sij xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ni̱ gahuin ruhua go̱ꞌngo ni sij gui̱daꞌa ni sij Jesús. Sani̱ ni̱ a̱ ꞌngo̱ ni sij nun guidaꞌa ni sij mánj. ");
INSERT INTO trq_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ngaa ni̱ nanica̱j ni tsínj policía gaꞌna̱ꞌ yu̱n ni sij rian chrej aꞌninꞌ rian ni chrej nga̱ rian ni tsínj fariseo. Ni̱ nachínj snanꞌanj ni síꞌ ni policía. ");
INSERT INTO trq_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ngaa ni̱: ―Nitaj a̱man gaꞌmi ꞌngo̱ tsínj da̱j rúnꞌ aꞌmi sij mánj. ―Gataj ni policía. ");
INSERT INTO trq_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ngaa ni̱ gataj ni tsínj fariseo: ―Ni̱ gaꞌuej ruhua á re̱ꞌ si digyaꞌ yunꞌunj sij manꞌan ni é re̱ꞌ níꞌ. ");
INSERT INTO trq_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Daj si nun gu̱xuman ruhua ni̱ a̱ ꞌngo̱ ni tsínj aꞌninꞌ nga̱ ni tsínj fariseo ni̱ꞌyaj ni sij síꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Sani̱ ni ngüi̱ nan ni̱ nun niꞌi ni sij si-ley Moisés mánj. Ni̱ gui̱ranꞌ ni sij sayun, gui̱ꞌyaj Yanꞌanj. ―Daj gataj ni sij gunun ni policía. ");
INSERT INTO trq_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Hué dan ni̱ gaꞌmi Nicodemo. Ni̱ ꞌngo̱ dugüiꞌ ni sij huin síꞌ. Ni̱ tsínj ganꞌanj niꞌyaj rian nne Jesús ne̱ꞌ ni̱ huin síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Ni̱ gataj síꞌ: ―Ataj si-ley néꞌ sisi̱ si̱ gaꞌue ga̱huin ꞌngo̱ tsínj castigo, gui̱ꞌyaj néꞌ ngaa achin gu̱nun sini néꞌ si ga̱ꞌmi síꞌ. Ni̱ si̱ gahuin síꞌ castigo sisi̱ achin xa̱caj néꞌ cuenta u̱n sin guiꞌyaj síꞌ. ―Daj gataj Nicodemo. ");
INSERT INTO trq_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ngaa ni̱ gataj ni sij: ―Tsínj ꞌna̱ꞌ estado Galilea huín re̱ꞌ nga̱ sij níꞌ. Di̱guiꞌyún re̱ꞌ si-nu̱guanꞌ Yanꞌanj, ni̱ xa̱caj re̱ꞌ cuenta sisi̱ ni̱ a̱ ꞌngo̱ tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj nitaj ꞌna̱ꞌ estado Galilea mánj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ngaa ni̱ na̱nꞌ da go̱ꞌngo ni sij ducuá ni sij. ");
INSERT INTO trq_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ngaa ni̱ gahui Jesús ganꞌanj sij quij gu̱ꞌnaj Olivos. ");
INSERT INTO trq_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ni̱ ngaa guere̱ngaꞌ ango güi, ni̱ ganꞌanj ga̱tu ru̱huaꞌ yún sij chruhua nuhui nico. Ni̱ gaꞌna̱ꞌ daranꞌ ni ngüi̱ rian sij. Ngaa ni̱ ganꞌanj ga̱ne sij. Ni̱ digyán sij rian ni ngüi̱ gaꞌna̱ꞌ daj. ");
INSERT INTO trq_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ngaa ni̱ nicaj ni tsínj digyán si-ley Moisés nga̱ ni tsínj fariseo ꞌngo̱ yunꞌunj xa̱na gaꞌna̱ꞌ ni sij. Ni̱ gani ni sij unj da̱ni ni sij nga̱ Jesús. Ni̱ nariꞌ ni sij yunꞌunj xa̱na daj hué gue̱ hora ngaa gaꞌmi unj nga̱ ꞌngo̱ tsínj. Ni̱ sé nica̱ unj huin tsínj daj. ");
INSERT INTO trq_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ngaa ni̱ gataj ni sij gunun Jesús: ―Maestro, yunꞌunj nan ꞌyaj squi̱raꞌ nga̱ ango sij. Ni̱ daꞌngaꞌ daj ꞌyaj nu̱ngüej sij nariꞌ ni únj. ");
INSERT INTO trq_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ni̱ aꞌninꞌ si-ley Moisés sun sisi̱ ga̱ꞌuiꞌ néꞌ yej yunꞌunj xa̱na ꞌyaj daj. Ngaa ni̱ da̱j gui̱ꞌyaj néꞌ, ruhua manꞌán re̱ꞌ únj. ");
INSERT INTO trq_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","―Daj gataj ni sij xiꞌí si huin ruhua ni sij si ga̱ꞌmi Jesús ꞌngo̱ nuguanꞌ nun hua sa̱ꞌ xiꞌí si-ley Moisés. Ngaa ni̱ ga̱ꞌue ga̱ꞌmi gaquinꞌ ni sij xiꞌí Jesús, ruhua ni sij. Sani̱ nitu Jesús, ni̱ gaxi̱ꞌi sij garun sij rian yoꞌój nga̱ raꞌa sij. ");
INSERT INTO trq_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ni̱ ri̱an nico̱ꞌ huaj nachínj snanꞌanj ni síꞌ sij, ni̱ naxu̱man Jesús. Ni̱ gataj sij: ―Tsínj nitaj si daꞌui gaquinꞌ, ni̱ hué síꞌ ga̱ꞌuiꞌ sini yej unj. ―Daj gataj Jesús gunun ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ngaa ni̱ gaꞌ nitu ru̱huaꞌ yún Jesús. Ni̱ garun sij rian yoꞌój. ");
INSERT INTO trq_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ni̱ ngaa gunun ni tsínj daj si gataj Jesús, ni̱ gahuin na̱ꞌaj ni sij, guiꞌyaj si-nu̱guanꞌ síꞌ. Ngaa ni̱ gaxi̱ꞌi ni sij gahui ni sij ganꞌanj go̱ꞌngo ni sij. Asi̱j sini ganꞌanj ni tsínj achij. Ni̱ da ru̱cu ganꞌanj ni tsínj hua lij daj. ");
INSERT INTO trq_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ngaa ni̱ naxu̱man Jesús, ni̱ gataj sij gunun yunꞌunj daj: ―Xicaꞌuīj, ni̱ a̱ ganꞌanj ni tsínj gaꞌmi gaquinꞌ xiꞌí re̱ꞌ sisi̱ ga̱huín re̱ꞌ castigo, ataj ni sij únj. ―Gataj Jesús rian yunꞌunj xa̱na daj. ");
INSERT INTO trq_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ngaa ni̱ gataj yunꞌunj xa̱na daj: ―Ni̱ a̱ ꞌngo̱ tsínj nitaj si aꞌmi da Señor. ―Daj gataj unj. Ngaa ni̱ gataj Jesús: ―Ni̱ si̱ guiꞌyaj manꞌānj castigo manꞌán re̱ꞌ mánj. Güi̱j ni̱ si̱ nanica̱j ru̱huaꞌ yún re̱ꞌ gui̱ꞌyáj re̱ꞌ gaquinꞌ ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús gunun ni sij: ―Huēj huin ꞌngo̱ yanꞌa̱n xigui̱n chruhua xungüi̱ nan. Tsínj nicoꞌ manꞌānj, ni̱ si̱ gachej sij rian hua ru̱miꞌ mánj. Sani̱ xigui̱n sa̱ꞌ chruhua niman sij, gui̱ꞌyā. Ni̱ ga̱ne ni̱ganj sij nga̱ Yanꞌanj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ngaa ni̱ gataj ni tsínj fariseo gunun Jesús: ―Aꞌmí re̱ꞌ güenda xiꞌí manꞌán re̱ꞌ. Xiꞌí daj ni̱ nitaj si níꞌyanj si aꞌmí re̱ꞌ mánj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ngaa ni̱ gataj Jesús: ―Nu̱nj si aꞌmī güenda xiꞌí manꞌānj, sani̱ xa̱ngaꞌ níꞌyanj nuguanꞌ aꞌmī xiꞌīj. Daj si niꞌīnj ni̱ a̱ ꞌnāj, ni̱ niꞌīnj ni̱ a̱ ga̱nꞌān. Sani̱ nun niꞌi a ni é re̱ꞌ ni̱ a̱ ꞌnāj, ni̱ nun niꞌi a ni é re̱ꞌ ni̱ a̱ ga̱nꞌān nej. ");
INSERT INTO trq_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Sani̱ axa̱ꞌ ni é re̱ꞌ, ni̱ aꞌmi gaquinꞌ ni é re̱ꞌ rian ni ngüi̱ da̱j rúnꞌ ani ruhua ni ngüi̱ ma̱n chruhua xungüi̱ gaquinꞌ nan. Sani̱ nitaj si aꞌmi gaquinꞌ manꞌānj rian ni ngüi̱ mánj. ");
INSERT INTO trq_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ni̱ sisi̱ aꞌmī gaquinꞌ rian ni ngüi̱, ni̱ duguꞌna̱j hua si guiꞌyā. Daj si sé urīnj huin si guiꞌyā daj. Sani̱ chrē si gaꞌníj gaꞌnāj ꞌngo̱ ani ruhuaj ngāj. ");
INSERT INTO trq_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ni̱ ataj ni̱ca si-ley ni é re̱ꞌ sisi̱ uyan aꞌmi hui̱j testigo daj, ni̱ xa̱ngaꞌ si-nu̱guanꞌ nu̱ngüej síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Hué manꞌānj huin testigo xiꞌí manꞌānj. Ni̱ chrē si gaꞌníj gaꞌnāj huin ango testigo daj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ngaa ni̱ nachínj snanꞌanj ni sij Jesús. Ni̱ gataj ni sij: ―Ni̱ a̱ nne chréj re̱ꞌ únj. ―Gataj ni sij. Ngaa ni̱ gataj Jesús: ―Nun niꞌi a ni é re̱ꞌ manꞌānj. Ni̱ nun niꞌi a ni é re̱ꞌ chrē nej. Ni̱ sisi̱ guiniꞌi a ni é re̱ꞌ manꞌānj, ni̱ hué daj guiniꞌi ni é re̱ꞌ chrē nej aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Hué ni nuguanꞌ nan gaꞌmi Jesús ngaa digyán sij rian ni ngüi̱ ma̱n chruhua nuhui nico rian aꞌuiꞌ ni sij sanꞌanj rian Yanꞌanj. Sani̱ ni̱ a̱ ꞌngo̱ ni tsínj nun gui̱daꞌa síꞌ. Daj si achin gui̱sij güi gui̱daꞌa ni sij síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús rian ni tsínj israelita: ―Ga̱nꞌān nánj. Ni̱ na̱noꞌ a ni é re̱ꞌ manꞌānj. Ni̱ ga̱huiꞌ a ni é re̱ꞌ xiꞌí si daꞌui ni é re̱ꞌ gaquinꞌ. Rian ga̱nꞌān, sani̱ si̱ gaꞌue ga̱nꞌanj án re̱ꞌ mánj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ngaa ni̱ gataj ni tsínj israelita gunun ni dugüiꞌ ni sij: ―Asi̱ ani ruhua sij da̱gahuiꞌ sij manꞌan sij sisi̱ ataj sij sisi̱ si̱ gaꞌue ga̱nꞌanj néꞌ rian ga̱nꞌanj sij, ataj sij níꞌ. ―Daj gataj ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ngaa ni̱ gataj Jesús gunun ni sij: ―Ni tsínj ma̱n ni̱caꞌ nan huin a ni é re̱ꞌ. Sani̱ manꞌānj ꞌna̱ꞌ xataꞌ. Ni̱ tsínj ma̱n chruhua xungüi̱ huin a ni é re̱ꞌ. Sani̱ nitaj si huīnj chruhua xungüi̱ nan mánj. ");
INSERT INTO trq_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Hué xiꞌí daj gatā gunun a ni é re̱ꞌ sisi̱ ga̱huiꞌ ni é re̱ꞌ xiꞌí si daꞌui a ni re̱ꞌ gaquinꞌ. Daj si sisi̱ nun gu̱xuman ruhua ni é re̱ꞌ sisi̱ huēj huin Cristo, ni̱ hua nia̱n ga̱huiꞌ ni é re̱ꞌ ngaa ga gue̱ daꞌui a ni é re̱ꞌ gaquinꞌ. ―Daj gataj Jesús gunun ni tsínj israelita. ");
INSERT INTO trq_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ngaa ni̱ nachínj snanꞌanj ni sij Jesús. Ni̱ gataj ni sij: ―Ni̱ u̱n tsínj huín re̱ꞌ únj. ―Daj gataj ni sij. Ni̱ gataj Jesús: ―Asi̱j sini ya̱n ni̱ hua gatā gunun ni é re̱ꞌ u̱n tsínj huīnj. ");
INSERT INTO trq_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Hua nico nuguanꞌ ga̱tā gu̱nun ni é re̱ꞌ. Ni̱ hua nico nuguanꞌ natāj xiꞌí si-ga̱quinꞌ ni é re̱ꞌ nej. Aꞌmi xa̱ngaꞌ si gaꞌníj gaꞌnāj. Ni̱ si natāj gunun ni ngüi̱ ma̱n chruhua xungüi̱, ni̱ hué nuguanꞌ nan huin si unūnj rian si gaꞌníj gaꞌnāj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Sani̱ nun gara daꞌngaꞌ ruhua ni sij sisi̱ gaꞌmi Jesús xiꞌí chrej sij. ");
INSERT INTO trq_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Xiꞌí daj ni̱ gataj Jesús gunun ni sij: ―Ngaa do̱coꞌ a ni é re̱ꞌ xataꞌ manꞌānj huīnj daꞌníj ni ngüi̱, ni̱ gui̱niꞌi ni é re̱ꞌ sisi̱ huēj huin Cristo aj. Ni̱ gui̱niꞌi a ni é re̱ꞌ sisi̱ nitaj si ꞌyā güenda manꞌānj. Sani̱ maan si aꞌmī urin si digyán chrē riānj. ");
INSERT INTO trq_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nne si gaꞌníj gaꞌnāj ngāj. Nitaj si duna chrē urīnj mánj. Daj si yaꞌyoj ꞌyā si aranꞌ ruhua chrē. ―Gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ngaa gaꞌmi Jesús nuguanꞌ daj, ni̱ guxuman ruhua nico ni tsínj daj niꞌyaj ni sij síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ngaa ni̱ gataj Jesús gunun ni tsínj israelita guxuman ruhua niꞌi sij: ―Sisi̱ ꞌngo̱ da̱gahuin ni é re̱ꞌ si-nu̱guanꞌānj, ngaa ni̱ ga̱huin xa̱ngaꞌ a ni é re̱ꞌ ni tsínj nicoꞌ manꞌānj. ");
INSERT INTO trq_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ni̱ gui̱niꞌi ni é re̱ꞌ nuguanꞌ xa̱ngaꞌ. Ngaa ni̱ ga̱huin níꞌnij rian án re̱ꞌ, gui̱ꞌyaj nuguanꞌ xa̱ngaꞌ daj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ngaa ni̱ gataj ni sij: ―Hué ni únj huin daꞌni̱ siꞌni̱ tsínj gu̱ꞌnaj Abraham. Ni̱ nitaj a̱man guiꞌyaj sun yu̱n ni únj mánj. Da̱j huin si atáj re̱ꞌ sisi̱ si̱ guiꞌyaj sun yu̱n únj únj. ―Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ni̱ gataj Jesús: ―Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ daranꞌ ni ngüi̱ ꞌyaj gaquinꞌ, ni̱ naꞌue ga̱ꞌninꞌ ruhua ni sij si ꞌyaj ni sij gaquinꞌ. Ni̱ ꞌyaj sun yu̱n ni sij rian gaquinꞌ daj. ");
INSERT INTO trq_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ni̱ ꞌngo̱ tsínj ꞌyaj sun yu̱n rian xuruꞌue, ni̱ naꞌue ga̱ne ni̱ganj sij ducuá xuruꞌue mánj. Sani̱ tsínj huin daꞌníj xuruꞌue daj, ni̱ nne ni̱ganj síꞌ ducuá chrej síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Hué dan ni̱ sisi̱ riqui daꞌníj Yanꞌanj sisi̱ ga̱huin níꞌnij ni é re̱ꞌ rian gaquinꞌ, ngaa ni̱ hua yya xa̱ngaꞌ sisi̱ sé tsínj ꞌyaj sun yu̱n rian gaquinꞌ huin a ni é re̱ꞌ ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","’Ni̱ niꞌīnj sisi̱ ni é re̱ꞌ huin daꞌni̱ siꞌni̱ xíꞌ Abraham. Sani̱ huin ruhua ni é re̱ꞌ da̱gahuiꞌ ni é re̱ꞌ manꞌānj xiꞌí si naꞌuej ruhua á re̱ꞌ sisi̱ ga̱tu si-nu̱guanꞌānj chruhua niman án re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Aꞌmi manꞌānj sisi̱ guiniꞌīnj rian nne chrē. Sani̱ ꞌyaj ni é re̱ꞌ da̱j rúnꞌ gataj chrej a ni é re̱ꞌ rian án re̱ꞌ aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ngaa ni̱: ―Xi ni únj huin tsínj gu̱ꞌnaj Abraham. ―Gataj ni sij. Sani̱ gataj Jesús: ―Sisi̱ huin xa̱ngaꞌ á re̱ꞌ daꞌníj xíꞌ Abraham, ngaa ni̱ gui̱ꞌyaj á re̱ꞌ da̱j rúnꞌ guiꞌyaj síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Sani̱ nu̱nj si gatā gunun ni é re̱ꞌ nuguanꞌ xa̱ngaꞌ huin nuguanꞌ digyán Yanꞌanj riānj, sani̱ huin ruhua ni é re̱ꞌ da̱gahuiꞌ ni é re̱ꞌ yūnj. Sani̱ sé daj guiꞌyaj quij Abraham mánj. ");
INSERT INTO trq_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Uyan ꞌyaj ni é re̱ꞌ da̱j rúnꞌ ꞌyaj chrej a ni é re̱ꞌ. ―Daj gataj Jesús gunun ni sij. Xiꞌí daj ni̱ gataj ni sij: ―Sé ni únj huin daꞌníj gaquinꞌ mánj. Sani̱ hua urin chrej ni únj huin Yanꞌanj. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ngaa ni̱ gataj Jesús: ―Sisi̱ xa̱ngaꞌ Yanꞌanj huin chrej a ni é re̱ꞌ, ni̱ ga̱huin ꞌi̱ ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ yūnj. Daj si gahui manꞌānj rian nne Yanꞌanj. Ni̱ gaꞌnāj chruhua xungüi̱ nan. Sé si gaꞌnāj güenda manꞌānj. Sani̱ gaꞌnāj xiꞌí si Yanꞌanj gaꞌníj gaꞌnāj. ");
INSERT INTO trq_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","’Naꞌue ga̱ra daꞌngaꞌ ruhua á re̱ꞌ nuguanꞌ aꞌmī xiꞌí si naꞌuej ruhua á re̱ꞌ gu̱nun a ni é re̱ꞌ nuguanꞌ aꞌmī rian án re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Chrej ni é re̱ꞌ huin sichre. Ni̱ huin ruhua á re̱ꞌ gui̱ꞌyaj á re̱ꞌ da̱j rúnꞌ huin ruhua gui̱ꞌyaj chrej a ni é re̱ꞌ. Ni̱ asi̱j sini ya̱n ꞌngo̱ huin sichre ꞌngo̱ si dagahuiꞌ níman. Nitaj a̱man ga ni̱ca si-nu̱guanꞌ sichre mánj. Ni̱ nitaj a̱man gaꞌmi xa̱ngaꞌ sichre mánj. Ni̱ ngaa aꞌmi yya̱ sichre, ni̱ si-nu̱guanꞌ manꞌan sichre aꞌmi. Daj si snanꞌanj sichre daj. Ni̱ chrej ni ngüi̱ aꞌmi snanꞌanj huin sichre aj. ");
INSERT INTO trq_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","’Sani̱ ri̱an aꞌmi xa̱ngaꞌ manꞌānj, ni̱ nun xu̱man ruhua á re̱ꞌ si aꞌmī mánj. ");
INSERT INTO trq_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ni̱ a̱ ꞌngo̱ ni é re̱ꞌ si̱ gaꞌue ga̱taj sisi̱ daꞌuīj gaquinꞌ mánj. Ni̱ sisi̱ aꞌmi xangāj, ni̱ u̱n sin huin ni̱ naꞌue gu̱xuman ruhua á re̱ꞌ gui̱niꞌi a ni é re̱ꞌ si-nu̱guanꞌānj únj. ");
INSERT INTO trq_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ni̱ tsínj nicoꞌ Yanꞌanj, ni̱ unun yya sij si-nu̱guanꞌ Yanꞌanj. Sani̱ nitaj si nicoꞌ a ni é re̱ꞌ Yanꞌanj mánj. Xiꞌí daj naꞌuej ruhua á re̱ꞌ gu̱nun a ni é re̱ꞌ si-nu̱guanꞌ Yanꞌanj mánj. ―Daj gataj Jesús gunun ni tsínj israelita. ");
INSERT INTO trq_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ngaa ni̱ gataj ni sij: ―Xa̱ngaꞌ nuguanꞌ gaꞌmi ni únj sisi̱ huín re̱ꞌ ꞌngo̱ tsínj samaritano. Ni̱ nu̱n nane̱ xi̱ꞌi nimán re̱ꞌ nej. ―Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ngaa ni̱ gataj Jesús: ―Nitaj nane̱ xi̱ꞌi nu̱n nimānj mánj. Nu̱n yanꞌān chrē aj. Sani̱ nitaj si nun yanꞌanj án re̱ꞌ yūnj mánj. ");
INSERT INTO trq_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nitaj si ꞌyaj sūnj sisi̱ ga̱ꞌmi sa̱ꞌ ni ngüi̱ xiꞌīj. Sani̱ Yanꞌanj huin ruhua sisi̱ ga̱ꞌmi sa̱ꞌ ni ngüi̱ xiꞌīj aj. Ni̱ na̱guiꞌyaj yya Yanꞌanj xiꞌí ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ tsínj gu̱nun sa̱ꞌ si-nu̱guanꞌānj, ni̱ nitaj a̱man ga̱huiꞌ sij mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yuꞌuj daj gataj ni tsínj israelita gunun Jesús: ―Yya̱j ni̱ hua niꞌi yya ni únj sisi̱ nu̱n nane̱ xi̱ꞌi chruhua nimán re̱ꞌ. Daj si gahuiꞌ tsínj gu̱ꞌnaj Abraham nga̱ daranꞌ ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. Ni̱ atáj re̱ꞌ: “Sisi̱ gu̱nun sa̱ꞌ ꞌngo̱ tsínj daj si-nu̱guanꞌ re̱ꞌ, ni̱ si̱ gahuiꞌ sij mánj.” Daj atáj re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Asi̱ huin achíj re̱ꞌ daj nga̱ xi ni únj Abraham, ruhuá re̱ꞌ níꞌ. Gahuiꞌ síꞌ ni̱ hué daj gahuiꞌ ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj. Ni̱ u̱n tsínj huín re̱ꞌ, ruhuá re̱ꞌ únj. ―Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ngaa ni̱ gataj Jesús: ―Sisi̱ ga̱taj manꞌānj sisi̱ tsínj sa̱ꞌ huīnj, ni̱ nitaj si níꞌyanj si-nu̱guanꞌānj mánj. Sani̱ aꞌmi sa̱ꞌ chrē xiꞌīj. Ni̱ hué manꞌan án re̱ꞌ ataj sisi̱ Danꞌanj ni é re̱ꞌ huin chrē aj. ");
INSERT INTO trq_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Sani̱ nun niꞌi a ni é re̱ꞌ chrē mánj. Sani̱ manꞌānj ni̱ niꞌīnj chrē aj. Ni̱ sisi̱ ga̱tā sisi̱ nun niꞌīnj chrē, ni̱ huīnj ꞌngo̱ tsínj nne̱, da̱j rúnꞌ huin ni é re̱ꞌ. Sani̱ xa̱ngaꞌ niꞌīnj chrē. Ni̱ ꞌyā da̱j rúnꞌ ataj si-nu̱guanꞌ chrē aj. ");
INSERT INTO trq_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","’Gahuin nia̱ꞌ ruhua xi ni é re̱ꞌ tsínj gu̱ꞌnaj Abraham xiꞌí si ganaꞌuij síꞌ güi ga̱ꞌnaꞌ manꞌānj chruhua xungüi̱ nan. Ni̱ guiniꞌi síꞌ si gaꞌnāj. Ngaa ni̱ gahuin nia̱ꞌ yya ruhua sij aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ngaa ni̱ gataj ni sij: ―Achin gui̱sij re̱ꞌ hui̱j xia chiꞌ yoꞌ. Ni̱ asa̱ꞌ ga̱ꞌue ga̱taj re̱ꞌ sisi̱ hua guiniꞌí re̱ꞌ Abraham únj. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ni̱ gataj Jesús: ―Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ ngaa achin ga̱ꞌnga Abraham, ni̱ hua nnēj aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yuꞌuj daj ni̱ guidaꞌa ni sij yej ga̱ꞌuiꞌ ni sij Jesús, ruhua ni sij. Sani̱ guixíj hui̱ Jesús manꞌan sij. Ni̱ gahui síꞌ nuhui nico daj. Ni̱ gachin síꞌ scanij ni sij ganꞌanj síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ni̱ ngaa gachin Jesús ganꞌanj sij, ni̱ guiniꞌi sij ꞌngo̱ tsínj duri. Ni̱ duri síꞌ asi̱j gaꞌnga síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ngaa ni̱ nachínj snanꞌanj ni tsínj nicoꞌ Jesús gataj ni síꞌ: ―Maestro, u̱n sin huin ni̱ gaꞌnga duri tsínj nan únj. Asi̱ si-ga̱quinꞌ chrej sij guiꞌyaj níꞌ. Asi̱ si-ga̱quinꞌ manꞌan sij guiꞌyaj sa̱ꞌ. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ngaa ni̱ gataj Jesús: ―Sé xiꞌí si-ga̱quinꞌ sij huin mánj. Ni̱ sé xiꞌí si-ga̱quinꞌ chrej sij nga̱ nni sij huin mánj. Maan si huin ruhua Yanꞌanj sisi̱ gui̱niꞌi ni ngüi̱ da̱j ga̱ꞌue gui̱ꞌyaj sa̱ꞌ Yanꞌanj nga̱ sij. ");
INSERT INTO trq_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ne̱ꞌ guníꞌyanjan ni̱ hua nia̱n gui̱ꞌyaj néꞌ si-sun si gaꞌníj gaꞌnāj chruhua xungüi̱ nan. Daj si ngaa ꞌna̱ꞌ gui̱ni, ni̱ na̱ꞌue gui̱ꞌyaj sun ni̱ a̱ ꞌngo̱ néꞌ ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ni̱ ngaa nnēj chruhua xungüi̱ nan, ni̱ da̱j rúnꞌ huin ꞌngo̱ yanꞌa̱n xigui̱n huīnj chruhua xungüi̱ aj. ―Daj gataj Jesús rian ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ni̱ ngaa guisíj gaꞌmi Jesús nuguanꞌ daj, ni̱ garáj staꞌnunj sij rian yoꞌój. Ni̱ guiꞌyaj sij do̱j sigeꞌ nga̱ dane staꞌnunj sij. Ni̱ garun sij rian tsínj duri daj. ");
INSERT INTO trq_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ngaa ni̱ gataj Jesús gunun síꞌ: ―Güi̱j na̱ꞌninꞌ re̱ꞌ rián re̱ꞌ pozo nnee gu̱ꞌnaj Siloé. ―Daj gataj Jesús. (Ni̱ nuguanꞌ Siloé huin ruhuaj gata: Nnee ꞌna̱ꞌ anéj chrej, guiꞌyaj ni sij.) Ngaa ni̱ ganꞌanj na̱ꞌninꞌ tsínj duri daj rian sij chruhua nnee daj. Ni̱ ngaa nanica̱j sij, ni̱ hua gaꞌue niꞌyaj sij. ");
INSERT INTO trq_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ni̱ hua guiniꞌi ni ngüi̱ huin dugüiꞌ tsínj daj gane tsínj daj gachínj sij caridad. Ngaa ni̱ nachínj snanꞌanj ni sij ni dugüiꞌ ni sij. Ni̱ gataj ni sij: ―Ni̱ sé tsínj nan huin tsínj nne achínj caridad, ruhua á re̱ꞌ a̱ꞌ. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ngaa ni̱: ―Hué sij huin. ―Gataj go̱ꞌngo ni sij. Ni̱ gataj ango ni sij: ―Sé sij huin nu̱nj si hué daj hua sij. ―Gataj ango ni sij. Sani̱ gataj manꞌan tsínj daj: ―Huēj huin aj. ―Gataj síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ngaa ni̱ nachínj snanꞌanj ni sij síꞌ. Ni̱ gataj ni sij: ―Da̱j guiꞌyáj re̱ꞌ ni̱ gaꞌue naxíꞌnij rián re̱ꞌ únj. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ngaa ni̱ gataj tsínj daj: ―Tsínj gu̱ꞌnaj Jesús ni̱ guiꞌyaj síꞌ sigeꞌ. Ni̱ garun síꞌ riānj. Ni̱ gataj sij gunūn: “Ga̱nꞌanj na̱ꞌnij re̱ꞌ pozo nnee gu̱ꞌnaj Siloé.” Daj gataj sij gunūn. Ngaa ni̱ ngaa guisíj ganꞌanj naꞌníj riānj chruhua nnee daj, ngaa ni̱ naxíꞌnij riānj aj. ―Gataj tsínj daj gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ngaa ni̱ nachínj snanꞌanj ni sij síꞌ. Ni̱ gataj ni sij: ―Ni̱ a̱ nne tsínj daj únj. ―Gataj ni sij. ―Nun niꞌīnj ni̱ a̱ nne síꞌ. ―Gataj tsínj daj. ");
INSERT INTO trq_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Hué dan ni̱ nicaj ni sij tsínj ga duri daj ganꞌanj ni sij rian ni tsínj fariseo. ");
INSERT INTO trq_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ni̱ güi naránj ruhua ni ngüi̱ israelita huin ngaa guiꞌyaj Jesús sigeꞌ, ni̱ ganahuin tsínj duri daj. ");
INSERT INTO trq_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ni̱ nachínj snanꞌanj ni síꞌ da̱j guiꞌyaj sij nahuin rian sij. Ngaa ni̱ gataj sij: ―Garun ꞌngo̱ tsínj daj sigeꞌ riānj. Ni̱ ganꞌanj na̱ꞌnij riānj. Ni̱ yya̱j ni̱ xigui̱n niꞌyā nánj. ―Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ngaa ni̱ gataj go̱ꞌngo ni tsínj fariseo: ―Tsínj guiꞌyaj nan ni̱ sé rian Yanꞌanj ꞌna̱ꞌ sij mánj. Daj si nitaj si níꞌyanj sij nga̱ güi naránj ruhua néꞌ mánj. ―Daj gataj go̱ꞌngo ni sij. Sani̱ gataj ango ni sij: ―Si̱ gaꞌue gui̱ꞌyaj sij si sa̱ꞌ nico da sisi̱ huin sij tsínj daꞌui gaquinꞌ mánj. ―Daj gataj ango ni sij. Ngaa ni̱ gaꞌmi guitsi manꞌan ni sij xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Yuꞌuj daj gataj ru̱huaꞌ yún ni sij rian tsínj daj: ―Da̱j ga̱taj manꞌán re̱ꞌ xiꞌí tsínj guiꞌyaj naxiꞌníj rián re̱ꞌ únj. ―Daj gataj ni sij. Ngaa ni̱: ―Güendāj ni̱ hué sij huin ꞌngo̱ tsínj aꞌmi si-nu̱guanꞌ Yanꞌanj, ruhuāj aj. ―Gataj tsínj daj xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Sani̱ nun gu̱xuman ruhua ni tsínj israelita sisi̱ hua yya ga duri tsínj daj, ni̱ naxiꞌníj rian sij. Yuꞌuj daj ni̱ gaquínj ni síꞌ chrej sij nej, nni sij nej, ga̱ꞌnaꞌ nu̱ngüej nica̱ sij rian ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ni̱ nachínj snanꞌanj ni síꞌ. Ni̱ gataj ni síꞌ: ―Xa̱ngaꞌ daꞌníj nu̱ngüej é re̱ꞌ huin tsínj nan níꞌ. Ni̱ xa̱ngaꞌ gaꞌnga duri sij níꞌ. Asa̱ꞌ ga̱ꞌue ni̱ꞌyaj sa̱ꞌ sij, ruhua nu̱ngüej é re̱ꞌ únj. ―Daj gataj ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ngaa ni̱ gataj nu̱ngüej nica̱ sij: ―Niꞌi yya únj sisi̱ daꞌníj únj huin síꞌ. Ni̱ niꞌi yya únj sisi̱ gaꞌnga duri síꞌ nej. ");
INSERT INTO trq_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Sani̱ nun niꞌi únj u̱n sin guiꞌyaj, ni̱ niꞌyaj sa̱ꞌ sij yya̱j. Ni̱ nun niꞌi únj u̱n tsínj guiꞌyaj, ni̱ naxiꞌníj rian sij. Na̱chinj snanꞌanj ni é re̱ꞌ sij si achij sij. Ni̱ ga̱ꞌmi sij xiꞌí manꞌan sij. ―Daj gataj nu̱ngüej nica̱ sij. ");
INSERT INTO trq_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Hué daj gaꞌmi nu̱ngüej sij si xuꞌuiꞌ sij niꞌyaj sij ni tsínj israelita. Daj si uyan hua gaꞌmi ni tsínj israelita sisi̱ gui̱ri ni síꞌ ne̱ꞌ chrej xe̱ꞌ go̱ꞌngo tsínj ma̱n chruhua nuhui ga̱taj sisi̱ Jesús huin Cristo. ");
INSERT INTO trq_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Xiꞌí daj gataj chrej sij nga̱ nni sij: ―Na̱chinꞌ snanꞌanj ni é re̱ꞌ sij si hua achij sij. ―Daj gataj nu̱ngüej sij. ");
INSERT INTO trq_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ngaa ni̱ naquínj ru̱huaꞌ yún ni tsínj israelita tsínj gahuin duri daj. Ni̱ gataj ni sij: ―Ga̱taj ni̱ca yyá re̱ꞌ rian Yanꞌanj da̱j guiránꞌ re̱ꞌ. Daj si niꞌi ni únj sisi̱ tsínj daj huin ꞌngo̱ tsínj daꞌui gaquinꞌ. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ngaa ni̱ gataj tsínj gahuin duri daj: ―Nun niꞌīnj sisi̱ daꞌui sij gaquinꞌ. Urin si niꞌīnj sisi̱ durīj, ni̱ hua aꞌue niꞌyā ruhuāj nánj. ―Daj gataj sij. ");
INSERT INTO trq_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ngaa ni̱ nachínj snanꞌanj ru̱huaꞌ yún ni sij. Ni̱ gataj ni sij: ―Da̱j guiꞌyaj sij, ni̱ naxiꞌníj rián re̱ꞌ, guiꞌyaj sij únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ni̱ gataj sij: ―Hua gatā gunun ni é re̱ꞌ, sani̱ naꞌue gu̱nun ni é re̱ꞌ mánj. Ni̱ u̱n sin huin ruhua ni é re̱ꞌ, ni̱ na̱taꞌ ru̱huaꞌ yūnj gu̱nun a ni é re̱ꞌ, ruhua á re̱ꞌ únj. Ni̱ gui̱nicoꞌ ni é re̱ꞌ manꞌan sij, ruhua á re̱ꞌ níꞌ. ―Daj gataj tsínj daj. ");
INSERT INTO trq_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ngaa ni̱ gaꞌmi quij ni sij gataj ni sij gunun tsínj daj: ―Manꞌán re̱ꞌ nicoꞌ tsínj daj, sani̱ nicoꞌ ni únj Moisés. ");
INSERT INTO trq_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Niꞌi ni únj sisi̱ gaꞌmi Yanꞌanj nga̱ Moisés. Sani̱ nun niꞌi ni únj ni̱ a̱ ꞌna̱ꞌ tsínj da mánj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ngaa ni̱ gataj tsínj gahuin duri daj: ―Gahuin yanꞌanj ruhuāj niꞌyā si-nu̱guanꞌ ni é re̱ꞌ. Daj si nun niꞌi ni é re̱ꞌ ni̱ a̱ ꞌna̱ꞌ sij. Ni̱ hué sij guiꞌyaj naxiꞌníj riānj. ");
INSERT INTO trq_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Niꞌi sa̱ꞌ néꞌ sisi̱ nitaj si unun Yanꞌanj nuguanꞌ achínj jniꞌyaj ni ngüi̱ daꞌui gaquinꞌ rian Yanꞌanj mánj. Sani̱ sisi̱ nu̱n yanꞌanj néꞌ rian Yanꞌanj, ni̱ sisi̱ ꞌyaj néꞌ si huin ruhua Yanꞌanj, ni̱ unun Yanꞌanj si achínj jniꞌyaj néꞌ rian Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nitaj a̱man gunun néꞌ nuguanꞌ sisi̱ naxiꞌníj rian ꞌngo̱ tsínj gaꞌnga duri, guiꞌyaj ꞌngo̱ tsínj da mánj. ");
INSERT INTO trq_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ni̱ a̱ ꞌngo̱ rasu̱n sa̱ꞌ si̱ gaꞌue gui̱ꞌyaj tsínj daj sisi̱ sé rian Yanꞌanj ꞌna̱ꞌ sij mánj. ―Daj gataj tsínj ga duri daj. ");
INSERT INTO trq_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ngaa ni̱ gataj ni sij: ―Asi̱j gaꞌngá re̱ꞌ, ni̱ daꞌuí re̱ꞌ gaquinꞌ anj. Ngaa ni̱ huin ruhuá re̱ꞌ di̱gyán re̱ꞌ rian ni únj níꞌ. ―Daj gataj ni sij. Ngaa ni̱ guiri ni sij síꞌ chruhua nuhui. ");
INSERT INTO trq_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ngaa ni̱ gunun Jesús nuguanꞌ sisi̱ guiri ni sij tsínj daj chruhua nuhui. Ni̱ ngaa nacaj dugüiꞌ sij nga̱ síꞌ, ni̱ nachínj snanꞌanj sij síꞌ. Ni̱ gataj sij: ―Xuman ruhuá re̱ꞌ niꞌyáj re̱ꞌ daꞌníj Yanꞌanj níꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ngaa ni̱ gataj síꞌ: ―Señor, ga̱taj re̱ꞌ u̱n tsínj huin daꞌníj Yanꞌanj, ngaa ni̱ gu̱xuman ruhuāj ni̱ꞌyā manꞌan síꞌ. ―Daj gataj tsínj daj. ");
INSERT INTO trq_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ngaa ni̱ gataj Jesús: ―Hua guiniꞌí re̱ꞌ síꞌ si huēj huin síꞌ aꞌmī nga̱ re̱ꞌ aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ngaa ni̱ gataj tsínj daj: ―Xuman ruhuāj niꞌīnj so̱ꞌ, Señor. ―Daj gataj sij ni̱ ganiquinꞌ ráj da̱coj sij rian Jesús. ");
INSERT INTO trq_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ngaa ni̱ gataj Jesús: ―Gaꞌna̱ꞌ manꞌānj chruhua xungüi̱ nan sisi̱ na̱guiꞌyaj yyāj si-ga̱quinꞌ ni ngüi̱. Ni̱ xiꞌí ni tsínj nun niꞌi, ni̱ gui̱ꞌyā sisi̱ gui̱niꞌi ni sij. Daj si xacaj ni sij cuenta sisi̱ nun niꞌi ni sij. Ni̱ xiꞌí ni tsínj ataj sisi̱ niꞌi ni sij, sani̱ gui̱ꞌyā sisi̱ ga̱ránj rian ni sij. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ni̱ ngaa gunun go̱ꞌngo ni tsínj fariseo niquinꞌ yuꞌuj daj si gataj Jesús, ni̱ nachínj snanꞌanj ni sij síꞌ. Ni̱ gataj ni sij: ―Da̱j rúnꞌ hua tsínj aránj rian hua ni únj, ruhuá re̱ꞌ níꞌ. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ngaa ni̱ gataj Jesús: ―Sisi̱ nun niꞌi a ni é re̱ꞌ, ni̱ nitaj gaquinꞌ daꞌui a ni é re̱ꞌ mánj. Sani̱ ri̱an ataj ni é re̱ꞌ yya̱j sisi̱ niꞌi ni é re̱ꞌ, xiꞌí daj ꞌngo̱ daꞌui ni é re̱ꞌ gaquinꞌ. ―Daj gataj Jesús gunun ni tsínj fariseo. ");
INSERT INTO trq_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ngaa síj ni gataj Jesús: ―Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ: Sisi̱ u̱n tsínj ahui ne̱ꞌ chrej ru̱cu xingá ma̱n xachij atúj sij chruhua xingá, ni̱ hué sij huin tsínj tu̱. Daj si naꞌuej ruhua sij ga̱tu sij ne̱ꞌ rian xingá rian atúj néꞌ. ");
INSERT INTO trq_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Sani̱ tsínj atúj rian xingá, ni̱ hué sij huin tsínj da̱n xachij. Ni̱ dugumi sij. ");
INSERT INTO trq_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ni̱ naꞌníj tsínj dugumi rian xingá ga̱tu tsínj da̱n daj. Ni̱ aꞌmi sij si-xugüi go̱ꞌngo xuj. Ni̱ naniꞌi ni xuj si-na̱ne sij. Ni̱ gui̱ri sij xúꞌ chruhua xingá. ");
INSERT INTO trq_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ni̱ ngaa gahui ni xachij daj, ni̱ táj dian tsínj dugumi daj. Ni̱ nicoꞌ ni xuj rucú sij. Daj si hua niꞌi ni xuj si-na̱ne sij aj. ");
INSERT INTO trq_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Sani̱ si̱ guinicoꞌ ni xucu ango tsínj daj. Maan si gunánj xuj rian síꞌ. Daj si nun niꞌi xuj si-na̱ne ango tsínj da mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ni̱ da̱j rúnꞌ hua ꞌngo̱ cuento hua nuguanꞌ gaꞌmi Jesús rian ni sij. Sani̱ nun gara daꞌngaꞌ ruhua ni sij si gataj síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús: ―Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ da̱j rúnꞌ huin rian xingá rian atúj ni xachij, ni̱ hué daj huin manꞌānj. ");
INSERT INTO trq_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Daranꞌ ni tsínj gaꞌna̱ꞌ ngaa achin ga̱ꞌnaꞌ manꞌānj, ni̱ huin ni sij tsínj tu̱. Sani̱ nun gunun ni xuj si gaꞌmi ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Da̱j rúnꞌ huin rian xingá huin manꞌānj. Tsínj ꞌna̱ꞌ riānj, ni̱ ga̱tu sij chruhua xingá, ni̱ ga̱nani sij, gui̱ꞌyā. Ni̱ ga̱huin sij da̱j rúnꞌ huin xachij ngaa ahui natu xuj chruhua xingá na̱riꞌ xuj xa̱ xuj. ");
INSERT INTO trq_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Sani̱ maan si huin ruhua tsínj tu̱ daj gui̱ꞌyaj tu̱ síꞌ, ni̱ da̱gahuiꞌ síꞌ nej, ni̱ de̱reꞌ síꞌ ni xachij daj, huin ruhua síꞌ. Sani̱ gaꞌnāj xiꞌí si huin ruhuāj ga̱ ni̱ꞌnaꞌ ni xachij. Ni̱ ga̱ ni̱ꞌnaꞌ xa̱ngaꞌ ni xuj, ruhuāj aj. ");
INSERT INTO trq_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","’Huēj huin tsínj dugumi sa̱ꞌ ni xachij. Ni̱ ga̱huīj xiꞌí ni dānj. ");
INSERT INTO trq_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Tsínj huin moso, sani̱ sé tsínj da̱n xachij huin sij mánj. Tsínj ꞌyaj gana sanꞌanj huin sij aj. Ni̱ ngaa gui̱niꞌi sij ꞌngo̱ xáꞌyanj huee, ni̱ du̱náj sij ni xachij. Ni̱ gu̱nánj sij ga̱nꞌanj sij. Ngaa ni̱ gui̱daꞌa xáꞌyanj xachij daj. Ni̱ gaxaꞌni̱ daranꞌ ni xachij, gui̱ꞌyaj xáꞌyanj da aj. ");
INSERT INTO trq_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ni̱ unánj tsínj moso daj si nitaj si nahuij ruhua sij niꞌyaj sij ni xachij mánj. Maan si tsínj ꞌyaj gana sanꞌanj huin sij aj. ");
INSERT INTO trq_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Huēj huin tsínj dugumi sa̱ꞌ xachij. Ni̱ niꞌīnj ni dānj. Ni̱ niꞌi ni dānj manꞌānj nej. ");
INSERT INTO trq_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ni̱ niꞌi chrē manꞌānj. Ni̱ niꞌīnj chrē nej. Ni̱ da̱j rúnꞌ hua manꞌānj nga̱ chrē, ni̱ daꞌngaꞌ daj hua ni dānj ngāj. Ni̱ ga̱huīj xiꞌí ni dānj xachij nej. ");
INSERT INTO trq_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ni̱ ni̱cā ango ni dānj xachij. Ni̱ sé si nu̱n xuj chruhua xingá nan mánj. Ni̱ hua nia̱n gui̱nicā ango ni xúꞌ daj ga̱ꞌnāj. Ngaa ni̱ gu̱nun ni xúꞌ si-nu̱guanꞌānj. Ni̱ gui̱man ga̱huin chreꞌ ni xúꞌ nga̱ ni xucu mán asi̱j sini. Ngaa ni̱ manꞌānj du̱gumi daranꞌ ni xachij daj. ");
INSERT INTO trq_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Ni̱ gaꞌuej ruhuāj ga̱huīj. Ni̱ ga̱naꞌnī ru̱huaꞌ yūnj. Ni̱ xiꞌí si gaꞌuej ruhuāj ga̱huīj xiꞌí ni dānj, ni̱ xiꞌí daj ꞌi̱ ruhua chrē niꞌya manꞌānj. ");
INSERT INTO trq_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nitaj si gui̱ꞌyaj ango ni sij sisi̱ ga̱huīj. Sani̱ ga̱huīj güenda manꞌānj. Hua sun riānj ga̱tā sisi̱ ga̱huīj. Ni̱ hua sun riānj ga̱tā sisi̱ ga̱naꞌnij ru̱huaꞌ yūnj nej aj. Nan huin sun gaꞌninꞌ chrē riānj anj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ni̱ ngaa gunun ni tsínj israelita ni nuguanꞌ daj, ni̱ gaꞌmi guitsi ru̱huaꞌ yún ni sij. ");
INSERT INTO trq_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ni̱ gataj daꞌaj ni sij: ―Nu̱n nane̱ xi̱ꞌi niman sij. Ni̱ sinúnj sij nej. Ngaa ni̱ u̱n sin ni̱ unun a ni é re̱ꞌ si ataj sij únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Sani̱ gataj ango daꞌaj ni sij: ―Nitaj si aꞌmi ꞌngo̱ tsínj nu̱n nane̱ xi̱ꞌi niman nuguanꞌ hua nan mánj. Ni̱ si̱ gaꞌue na̱xiꞌni rian tsínj duri, gui̱ꞌyaj ꞌngo̱ nane̱ xi̱ꞌi mánj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ni̱ xumanꞌ Jerusalén, ni̱ guiꞌyaj ni sij guiꞌyanj xiꞌí si nasíj yoꞌ ngaa nagaꞌuiꞌ ni sij nuhui nico rian Yanꞌanj. Ni̱ ni yahui̱ nuhuij huin. ");
INSERT INTO trq_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ni̱ achéj Jesús chruhua nuhui chruhua ꞌngo̱ corredo gu̱ꞌnaj Salomón. ");
INSERT INTO trq_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ngaa ni̱ ganica̱j ni tsínj israelita xiꞌníj Jesús. Ni̱ nachínj snanꞌanj ni sij síꞌ. Ni̱ gataj ni sij: ―Ni̱ a̱man gui̱sij güi ga̱huin yya ruhua únj ni̱ꞌyaj únj manꞌán re̱ꞌ únj. Sisi̱ hué re̱ꞌ huin Cristo, ni̱ ꞌngo̱ yu̱n ga̱taj yyá re̱ꞌ gu̱nun únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ngaa ni̱ gataj Jesús: ―Hua gatā gunun a ni é re̱ꞌ, sani̱ nun gu̱xuman ruhua á re̱ꞌ mánj. Ni̱ si sa̱ꞌ nico ꞌyā xiꞌí chrē digyán yya rian án re̱ꞌ da̱j tsínj huīnj anj. ");
INSERT INTO trq_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Sani̱ nun gu̱xuman ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ manꞌānj. Daj si sé dānj xachij huin ni é re̱ꞌ mánj. Ni̱ hua gatā gunun a ni é re̱ꞌ nuguanꞌ nan. ");
INSERT INTO trq_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ni̱ unun ni dānj xachij si-nanēj. Ni̱ niꞌīnj ni xuj. Ni̱ nicoꞌ ni xuj rucūj. ");
INSERT INTO trq_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ni̱ aꞌuīj si gui̱man ni̱ganj ni xuj nga̱ Yanꞌanj. Ni̱ nitaj a̱man ga̱huiꞌ ni xuj. Ni̱ nitaj a̱ ꞌngo̱ ni tsínj ga̱ꞌue ga̱ꞌne ni xuj raꞌāj mánj. ");
INSERT INTO trq_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Riqui chrē ni xuj riānj. Ni̱ huin achij chrē daj nga̱ daranꞌ anj. Yuꞌuj daj ni̱ a̱ ꞌngo̱ ni tsínj si̱ gahuin nucuaj ga̱ꞌne ni xuj raꞌa chrē mánj. ");
INSERT INTO trq_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Rúnꞌ hua urin tsínj hua manꞌānj nga̱ chrē nánj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ngaa ni̱ guidaꞌa ru̱huaꞌ yún ni tsínj israelita yej ga̱ꞌuiꞌ ni sij Jesús, ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Sani̱ gataj Jesús: ―Guisíj guiꞌyā nico si sa̱ꞌ guiniꞌi a ni é re̱ꞌ. Ni̱ gahuin nucuāj guiꞌyā daj, guiꞌyaj chrē. Ni̱ xiꞌí u̱n si sa̱ꞌ daj huin ruhua á re̱ꞌ ga̱ꞌuiꞌ a ni é re̱ꞌ yej manꞌānj únj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ni̱ gataj ni sij: ―Sé xiꞌí ꞌngo̱ si sa̱ꞌ nico guiꞌyáj re̱ꞌ ga̱ꞌuiꞌ ni únj yéj re̱ꞌ mánj. Sani̱ ga̱ꞌuiꞌ únj yej manꞌán re̱ꞌ xiꞌí si aꞌmí re̱ꞌ ꞌngo̱ nuguanꞌ quij xiꞌí Yanꞌanj. Ni̱ maan si ꞌngo̱ tsínj huín re̱ꞌ. Ni̱ ꞌyáj re̱ꞌ sisi̱ huin manꞌán re̱ꞌ Yanꞌanj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ngaa ni̱ gataj Jesús: ―Hua ni̱ca si-du̱cuanj nicaj á re̱ꞌ. Ni̱ nuguanꞌ gaꞌmi manꞌan Yanꞌanj huin nuguanꞌ daj. Ni̱ gataj Yanꞌanj: “Gataj manꞌānj sisi̱ huin ni é re̱ꞌ yanꞌanj.” Hué daj gataj Yanꞌanj gunun ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Hué dan ni̱ sisi̱ manꞌan Yanꞌanj gataj sisi̱ ni tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj huin yanꞌanj, (ni̱ niꞌi yya néꞌ sisi̱ nuguanꞌ xa̱ngaꞌ huin si-nu̱guanꞌ Yanꞌanj), ");
INSERT INTO trq_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ngaa ni̱ sisi̱ gahuin ninīj, guiꞌyaj Yanꞌanj, ni̱ sisi̱ gaꞌníj Yanꞌanj gaꞌnāj chruhua xungüi̱, ngaa ni̱ asa̱ꞌ ga̱ꞌue ga̱taj á re̱ꞌ sisi̱ aꞌmi quī xiꞌí Yanꞌanj ngaa gatā gunun a ni é re̱ꞌ sisi̱ daꞌníj Yanꞌanj huīnj únj. ");
INSERT INTO trq_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ni̱ sisi̱ nitaj si ꞌyaj sūnj si-sun chrē, ngaa ni̱ si̱ guxuman ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ manꞌānj mánj. ");
INSERT INTO trq_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Sani̱ sisi̱ yya ꞌyaj sūnj si-sun chrē, ngaa ni̱ nu̱nj si nun xu̱man ruhua á re̱ꞌ ni̱ꞌyaj ni é re̱ꞌ manꞌānj, sani̱ hua xiꞌí gu̱xuman ruhua á re̱ꞌ si sa̱ꞌ nico guiꞌyā aj. Daꞌ síj, ngaa ni̱ xa̱caj á re̱ꞌ cuenta, ni̱ gui̱niꞌi a ni é re̱ꞌ sisi̱ nne chrē ngāj, ni̱ nnēj nga̱ chrē nej. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ngaa ni̱ gahuin ruhua ru̱huaꞌ yún ni sij gui̱daꞌa ni sij Jesús. Sani̱ guinani síꞌ rian ni sij. ");
INSERT INTO trq_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ngaa ni̱ gahui Jesús ganꞌanj ru̱huaꞌ yún sij anéj chrej xinéj nnee gu̱ꞌnaj Jordán. Ni̱ gunáj sij yuꞌuj daj rian duguataꞌ nnee sini Juan ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ni̱ gaꞌna̱ꞌ nico ni ngüi̱ rian Jesús. Ni̱ gataj ni sij: ―Xa̱ngaꞌ ni nun gui̱ꞌyaj Juan si sa̱ꞌ nico. Sani̱ gahuin yya daranꞌ si gataj sij xiꞌí Jesús. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ni̱ nico ni ngüi̱ guxuman ruhua niꞌyaj Jesús yuꞌuj daj. ");
INSERT INTO trq_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Hué dan ni̱ hua ꞌngo̱ tsínj aꞌnanꞌ gu̱ꞌnaj síꞌ Lázaro. Ni̱ nne síꞌ xumanꞌ Betania huin xánj yunꞌunj gu̱ꞌnaj María nga̱ xugüij únꞌ Marta. ");
INSERT INTO trq_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Ni̱ xicaꞌuij Lázaro huin María. Hué únꞌ huin si gayanj nnee quinꞌ da̱j dacój Jesús. Ni̱ naco̱ dacój síꞌ, guiꞌyaj únꞌ nga̱ hueé chra̱ únꞌ.) ");
INSERT INTO trq_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ngaa ni̱ gaꞌníj nu̱ngüej xicaꞌuij Lázaro ꞌngo̱ nuguanꞌ rian Jesús, gataj nu̱ngüej unj: ―Axa̱ꞌ tsínj ꞌi̱ ruhuá re̱ꞌ, sani̱ aꞌnanꞌ sij, Señor. ―Daj gataj nuguanꞌ gaꞌníj nu̱ngüej unj rian Jesús. ");
INSERT INTO trq_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ni̱ ngaa gunun Jesús nuguanꞌ daj, ni̱ gataj síꞌ: ―Sé si ga̱huiꞌ sij, gui̱ꞌyaj xiꞌi̱ da mánj. Sani̱ guiranꞌ sij sisi̱ ga̱ꞌmi sa̱ꞌ ni ngüi̱ xiꞌīj huīnj daꞌníj Yanꞌanj nej. ―Daj gataj Jesús gunun ni tsínj nataꞌ nuguanꞌ daj rian sij. ");
INSERT INTO trq_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ni̱ ꞌi̱ ruhua Jesús niꞌyaj síꞌ Marta nga̱ María nga̱ xicaꞌuij nu̱ngüej únꞌ Lázaro. ");
INSERT INTO trq_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Sani̱ gunáj síꞌ yahuij güi rian nne síꞌ ngaa gunun síꞌ sisi̱ aꞌnanꞌ Lázaro. ");
INSERT INTO trq_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ngaa síj ni̱ gataj Jesús gunun ni tsínj nicoꞌ sij: ―Ga̱nꞌanj ru̱huaꞌ yún néꞌ estado Judea aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ni̱ gataj ni tsínj nicoꞌ Jesús: ―Rabí, cuanj ni̱ gahuin ruhua ni tsínj israelita ma̱n yuꞌuj daj ga̱ꞌuiꞌ ni sij yej manꞌán re̱ꞌ. Ni̱ u̱n sin huin ni̱ huin ruhuá re̱ꞌ ga̱nꞌanj ru̱huaꞌ yún re̱ꞌ yuꞌuj daj únj. ―Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ngaa ni̱ gataj Jesús: ―Sé si xa̱ngaꞌ sisi̱ xu̱huij hora nicaj güi a̱ꞌ. Ni̱ sisi̱ chéj néꞌ ne̱ꞌ guniꞌyanj, ni̱ si̱ natuj néꞌ mánj. Daj si xigui̱n yanꞌa̱n xataꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Sani̱ sisi̱ chéj néꞌ ne̱ꞌ ni̱, ni̱ na̱tuj néꞌ xiꞌí si nitaj yanꞌa̱n xigui̱n mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ngaa guisíj gaꞌmi Jesús daj, ni̱ gataj ru̱huaꞌ yún sij: ―Atoj Lázaro tsínj nicaj dugüiꞌ nga̱ néꞌ. Ga̱nꞌān ga̱nꞌanj jnanun ruhuāj sij. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yuꞌuj daj gataj ni tsínj nicoꞌ Jesús: ―Señor, sisi̱ atoj sij, ni̱ ga̱nahuin sa̱ꞌ sij aj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ni̱ daꞌngaꞌ daj gataj Jesús si hua niꞌi síꞌ si Lázaro hua gahuiꞌ. Sani̱ gani ruhua ni tsínj nicoꞌ Jesús sisi̱ yya atoj Lázaro, gataj Jesús, ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ngaa ni̱ gaꞌmi ni̱ca Jesús rian ni sij. Ni̱ gataj síꞌ: ―Hua gahuiꞌ Lázaro aj. ");
INSERT INTO trq_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ni̱ huin nia̱ꞌ ruhuāj sisi̱ nun ganēj yuꞌuj daj ngaa gahuiꞌ síꞌ. Xiꞌí si gahuiꞌ síꞌ, ni̱ gu̱xuman doj ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ manꞌānj. Sani̱ ga̱nꞌanj néꞌ rian ngaj sij aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ngaa ni̱ gataj tsínj gu̱ꞌnaj Tomás, huin tsínj gu̱ꞌnaj Dídimo nej gunun ango ni tsínj nicoꞌ Jesús: ―Ga̱nꞌanj néꞌ ni̱ ga̱huiꞌ nu̱guanꞌan néꞌ nga̱ sij. ―Daj gataj Tomás. ");
INSERT INTO trq_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ni̱ ngaa guisíj Jesús yuꞌuj daj, ni̱ gataj ni ngüi̱ gunun sij sisi̱ guisíj ga̱nꞌanj güi gachinꞌ ni sij níman daj. ");
INSERT INTO trq_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ni̱ ni̱chrunꞌ ꞌngo̱ si hua̱ꞌnij kilómetro duꞌua xumanꞌ Betania ngaj xumanꞌ Jerusalén. ");
INSERT INTO trq_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ni̱ ganꞌanj ni̱ꞌyaj nico ni ngüi̱ israelita rian nne Marta nga̱ María sisi̱ na̱huin nia̱ꞌ ruhua nu̱ngüej xugüiꞌij unj. Daj si nani ruhua nu̱ngüej unj xiꞌí xicaꞌuij unj gahuiꞌ. ");
INSERT INTO trq_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ni̱ ngaa gunun Marta sisi̱ ꞌna̱ꞌ gui̱sij Jesús, ni̱ gahui unj na̱huin raꞌa unj Jesús. Sani̱ gunáj María chruhua hueꞌ. ");
INSERT INTO trq_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ngaa ni̱ gataj Marta gunun Jesús: ―Señor, sisi̱ nun gané re̱ꞌ cuanj, ni̱ si̱ gahuiꞌ xicaꞌuī sa mánj. ");
INSERT INTO trq_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Sani̱ niꞌīnj yya̱j sisi̱ daranꞌ si achínj jniꞌyáj re̱ꞌ rian Yanꞌanj, ni̱ ri̱qui Yanꞌanj anj. ―Daj gataj Marta. ");
INSERT INTO trq_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ngaa ni̱: ―Ga̱naꞌnij xicaꞌuíj re̱ꞌ aj. ―Gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ni̱: ―Niꞌīnj sisi̱ ga̱naꞌnij sij ngaa ga̱naꞌnij ni níman güi ga̱nahuij xungüi̱ aj. ―Gataj Marta gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ngaa ni̱ gataj Jesús: ―Huēj gui̱ꞌyaj si ga̱naꞌnij ni níman. Ni̱ ga̱ ni̱ꞌnaꞌ ni̱ganj ni sij nga̱ Yanꞌanj, gui̱ꞌyā. Ni̱ nu̱nj si hua gahuiꞌ ꞌngo̱ tsínj xuman ruhua niꞌyaj manꞌānj, sani̱ ga̱naꞌnij sij, gui̱ꞌyā aj. ");
INSERT INTO trq_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ni̱ daranꞌ ni ngüi̱ hua ni̱ꞌnaꞌ mán, ni̱ nitaj a̱man ga̱huiꞌ niman ni sij sisi̱ xuman ruhua ni sij niꞌyaj ni sij manꞌānj. Xuman ruhuá re̱ꞌ nuguanꞌ nan níꞌ. ―Daj gataj Jesús gunun Marta. ");
INSERT INTO trq_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ngaa ni̱ gataj Marta: ―Xuman ruhuāj sisi̱ hué re̱ꞌ huin Cristo daꞌníj Yanꞌanj. Ni̱ gaꞌnáꞌ re̱ꞌ chruhua xungüi̱ nan, Señor. ―Daj gataj Marta. ");
INSERT INTO trq_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ngaa guisíj gaꞌmi unj nuguanꞌ nan, ni̱ ganꞌanj ga̱quinj unj xugüiꞌij unj, María. Ni̱ gataj hui̱ unj gunun María: ―Niquinꞌ Maestro aquínj sij manꞌán re̱ꞌ aj. ―Daj gataj Marta gunun María. ");
INSERT INTO trq_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ni̱ ngaa gunun María nuguanꞌ daj, ni̱ naxu̱man yoo̱ unj ganꞌanj ni̱ꞌyaj unj rian niquinꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Sani̱ nun güin gahuin gatúj Jesús xumanꞌ daj. Hua gue̱ niquinꞌ sij rian nariꞌ Marta sij. ");
INSERT INTO trq_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ngaa ni̱ ni ngüi̱ israelita ma̱n chruhua hueꞌ, ni̱ ngüi̱ aꞌmi nga̱ María xiꞌí niman gahuiꞌ, ni̱ guiniꞌi ni sij sisi̱ naxu̱man yoo̱ únꞌ ganꞌanj únꞌ. Ni̱ gani ruhua ni sij sisi̱ ganꞌanj únꞌ ga̱co únꞌ, ruhua ni sij. Ni̱ guinicoꞌ ni sij ru̱cu únꞌ ganꞌanj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ni̱ ngaa guisíj María rian niquinꞌ Jesús, ni̱ guiniꞌi únꞌ manꞌan síꞌ. Ngaa ni ganiquinꞌ ráj da̱coj únꞌ rian síꞌ. Ni̱ gataj únꞌ: ―Señor, sisi̱ nun gané re̱ꞌ nan cuanj, ni̱ si̱ gahuiꞌ xicaꞌuī sa mánj. ―Gataj María gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ni̱ ngaa guiniꞌi Jesús sisi̱ aco María nga̱ ni ngüi̱ israelita gaꞌna̱ꞌ nga̱ únꞌ, ni̱ ducu ganani ruhua síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ngaa ni̱ gataj síꞌ: ―Ni̱ a gachinꞌ ni é re̱ꞌ únj. ―Daj gataj Jesús. Ngaa ni̱: ―Gu̱nꞌ ni̱ꞌyáj re̱ꞌ, Señor. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ngaa ni̱ gaco Jesús aj. ");
INSERT INTO trq_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yuꞌuj daj gataj ni ngüi̱ israelita: ―Ni̱ꞌyaj á re̱ꞌ si ducu ꞌi̱ ruhua sij niꞌyaj sij tsínj gahuiꞌ daj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Sani̱ gataj go̱ꞌngo ni sij: ―Hué tsínj nan guiꞌyaj naxíꞌnij rian ꞌngo̱ tsínj duri. Ni̱ sisi̱ hué daj nucuaj sij, ni̱ u̱n sin huin ni̱ gaꞌninꞌ ruhua sij sisi̱ gahuiꞌ Lázaro únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ngaa ni̱ ducu ganani ruhua Jesús. Ni̱ gahuin ni̱chrunꞌ sij rian gachinꞌ ni sij Lázaro huin ꞌngo̱ huej. Ni̱ hua ránj ꞌngo̱ yej xa̱chij rian yuꞌuj. ");
INSERT INTO trq_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ngaa ni̱: ―Gu̱xun a ni é re̱ꞌ yej aj. ―Gataj Jesús. Ngaa ni̱ gataj Marta xicaꞌuij tsínj gahuiꞌ daj gunun Jesús: ―Señor, sani̱ ga guinꞌ riꞌyuj sij si guisíj ga̱nꞌanj güi ngaj sij aj. ―Daj gataj Marta. ");
INSERT INTO trq_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ngaa ni̱ gataj Jesús gunun unj: ―Hua gatā gunún re̱ꞌ sisi̱ gu̱xuman ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ manꞌānj, ngaa ni̱ gui̱niꞌí re̱ꞌ sisi̱ nucuaj gui̱ꞌyaj Yanꞌanj anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ngaa ni̱ guxun ni sij yej rian gachinꞌ ni sij níman. Ni̱ guiniꞌyaj Jesús xataꞌ, ni̱ gataj síꞌ: ―Tata chréꞌ, guruhuá re̱ꞌ si gunún re̱ꞌ si-nu̱guanꞌānj. ");
INSERT INTO trq_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Niꞌīnj sisi̱ ni̱ganj unún re̱ꞌ nuguanꞌ aꞌmī. Sani̱ aꞌmī nuguanꞌ nan sisi̱ gu̱nun ni ngüi̱ mán yuꞌuj nan ngāj sisi̱ gu̱xuman ruhua ni sij si hué re̱ꞌ huin si gaꞌníj gaꞌnāj chruhua xungüi̱ nan. ―Daj gataj Jesús gunun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ngaa guisíj gataj Jesús nuguanꞌ daj, ni̱ nucuaj gaguáj sij. Ni̱ gataj sij: ―Lázaro, ga̱hui so̱ꞌ ga̱ꞌnaꞌ so̱ꞌ aj. ―Daj gataj Jesús gaguáj sij. ");
INSERT INTO trq_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ngaa ni̱ gahui tsínj gahuiꞌ daj. Ni̱ anumi raꞌa sij nga̱ dacój sij atsij da gahui sij. Ni̱ hua ránj rian sij ꞌngo̱ paño. Ngaa ni̱ gataj Jesús: ―Na̱chi a ni é re̱ꞌ atsij, ni̱ ga̱ꞌue ga̱nꞌanj sij aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ni̱ guiniꞌi ni ngüi̱ israelita ni ngüi̱ gaꞌna̱ꞌ nga̱ María si guiꞌyaj Jesús. Xiꞌí daj guxuman ruhua nico ni sij guiniꞌi ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Sani̱ ganꞌanj na̱taꞌ ango daꞌaj ni sij rian ni tsínj fariseo si guiꞌyaj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ngaa ni̱ nahuin yuꞌ ni tsínj fariseo nga̱ ni chrej aꞌninꞌ rian ni chrej, guiꞌyaj ni sij ꞌngo̱ junta. Ni̱ gataj ni sij: ―Ni̱ u̱n sin gui̱ꞌyaj néꞌ ruhua á re̱ꞌ únj. Daj si tsínj daj ꞌyaj nico si sa̱ꞌ digyán sij rian ni ngüi̱ aj. ");
INSERT INTO trq_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Sisi̱ ga̱ꞌninꞌ ruhua néꞌ, ni̱ gu̱xuman ruhua daranꞌ ni ngüi̱ gui̱niꞌyaj ni sij síꞌ. Hué dan ni̱ ga̱ꞌnaꞌ ni tsínj nicaj sun ni tsínj romano, ni̱ du̱guane ni sij si-nuhui néꞌ. Ni̱ jna̱hui ni sij xánj néꞌ nej. ―Daj gataj ni sij gunun ni dugüiꞌ ni sij. ");
INSERT INTO trq_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Sani̱ gaꞌmi ꞌngo̱ dugüiꞌ ni sij huin tsínj gu̱ꞌnaj Caifás, huin síꞌ chrej huin rian ni̱nꞌ yoꞌ daj. Ni̱ gataj síꞌ: ―Nun niꞌi a ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ni̱ nitaj si acaj ni é re̱ꞌ cuenta sisi̱ sa̱ꞌ ga̱huiꞌ urin tsínj daj xiꞌí ni ngüi̱. Ngaa ni̱ sé daranꞌ néꞌ ni tsínj israelita ga̱nahuij mánj. ―Daj gataj Caifás gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Sani̱ nun gataj Caifás nuguanꞌ daj güenda manꞌan sij. Sani̱ ri̱an huin síꞌ chrej huin rian ni̱nꞌ yoꞌ daj, ni̱ gaꞌmi síꞌ si-nu̱guanꞌ Yanꞌanj sisi̱ ga̱huiꞌ Jesús xiꞌí ni ngüi̱ israelita. ");
INSERT INTO trq_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ni̱ sé xiꞌí urin ni ngüi̱ israelita huin ga̱huiꞌ Jesús mánj. Sani̱ ga̱huiꞌ sij sisi̱ na̱huin chreꞌ daranꞌ ni ngüi̱ huin daꞌníj Yanꞌanj huin ni ngüi̱ gaxaꞌni̱ chruhua xungüi̱, gui̱ꞌyaj sij. ");
INSERT INTO trq_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ngaa ni̱ asi̱j güi daj, ni̱ dagaꞌmi dugüiꞌ ni sij sisi̱ da̱gahuiꞌ ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hué dan ni̱ nun ga̱che re̱ngaꞌ Jesús scanij ni ngüi̱ israelita ga̱ mánj. Sani̱ gahui sij estado Judea ganꞌanj sij ꞌngo̱ yuꞌuj ngaj ni̱chrunꞌ quij guiꞌyanj na̱co ꞌngo̱ xumanꞌ gu̱ꞌnaj Efraín. Ni̱ yuꞌuj daj gunáj sij nga̱ ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ngaa ni̱ gahuin ni̱chrunꞌ guiꞌyanj pascua guiꞌyaj ni tsínj israelita. Ni̱ gahui ni ngüi̱ mán go̱ꞌngo ni xumanꞌ ganꞌanj ni sij xumanꞌ Jerusalén. Daj si huin ruhua ni sij na̱guiꞌyaj sa̱ꞌ ni sij manꞌan ni sij rian Yanꞌanj da̱j rúnꞌ ataj si-ley Moisés ngaa achin ga̱huin guiꞌyanj pascua. ");
INSERT INTO trq_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ni̱ achéj ni sij nanoꞌ ni sij Jesús. Ni̱ nachínj snanꞌanj ni sij ni dugüiꞌ ni sij mán ni sij chruhua nuhui. Ni̱ gataj ni sij: ―Da̱j ani ruhua ni é re̱ꞌ únj. Ga̱ꞌnaꞌ sij guiꞌyanj nan níꞌ, asi̱ si̱ gaꞌna̱ꞌ sij sa̱ꞌ. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ni̱ hua gaꞌninꞌ ni tsínj fariseo nga̱ ni chrej aꞌninꞌ sun rian ni ngüi̱. Ni̱ gataj snanꞌanj ni sij rian ni síꞌ sisi̱ gui̱niꞌi ni síꞌ ni̱ a nne Jesús, ni̱ ga̱nꞌanj na̱taꞌ ni síꞌ rian ni sij. Ngaa ni ga̱ꞌue gui̱daꞌa ni sij Jesús, ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ni̱ ngaa achin yatanꞌ güi gahuin guiꞌyanj pascua, ni̱ ganꞌanj Jesús xumanꞌ Betania rian nne Lázaro tsínj ganáꞌnij scanij ni níman, guiꞌyaj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ni̱ gahuin stiꞌni̱ Jesús, guiꞌyaj ni sij. Ni̱ anica̱j Marta si xa ni sij. Ni̱ nne Lázaro rian mesa xa sij nga̱ Jesús. ");
INSERT INTO trq_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ngaa ni̱ nicaj María ꞌngo̱ gagaꞌ nu̱n gasiti guinꞌ da̱j gu̱ꞌnaj-áꞌ nardo gaꞌna̱ꞌ únꞌ rian nne Jesús. Ni̱ duꞌue ni̱nꞌ ruhua-áꞌ. Ni̱ garij únꞌ dacój Jesús. Ngaa ni̱ naruꞌui únꞌ nga̱ hueé chra̱ únꞌ. Ni̱ ga guinꞌ da̱j chruhua hueꞌ, guiꞌyaj gasiti daj. ");
INSERT INTO trq_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ngaa ni̱ nne Judas daꞌníj Simón huin síꞌ ꞌngo̱ tsínj nicoꞌ Jesús. Ni̱ tsínj na̱gaꞌuiꞌ Jesús rian ni tsínj nicaj sun huin síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Ni̱ gataj síꞌ: ―Ni̱ u̱n sin huin ni̱ nun ga̱neꞌ gasiti nan sisi̱ gui̱riꞌ néꞌ hua̱ꞌnij ciento denario sanꞌanj chra̱cuij néꞌ ni ngüi̱ niqui únj. ―Daj gataj Judas. ");
INSERT INTO trq_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Sani̱ nitaj si nahuij ruhua Judas niꞌyaj sij ni ngüi̱ niqui mánj. Maan si dugumi sij bolsa nu̱n si-sanꞌanj daranꞌ ni sij. Ni̱ guidaꞌa sij si-sanꞌanj ni síꞌ gutinꞌ sij. Daj si huin sij ꞌngo̱ tsínj tu̱. ");
INSERT INTO trq_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ngaa ni̱ gataj Jesús gunun Judas: ―Ga̱ꞌninꞌ ruhuá re̱ꞌ si hué daj ꞌyaj únꞌ nga̱ gasiti nan xiꞌí güi ga̱chinꞌ ni sij yūnj. ");
INSERT INTO trq_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ni̱ yaꞌyoj nne ni ngüi̱ niqui scanij ni é re̱ꞌ. Sani̱ sé si ga̱ne ni̱ganj manꞌānj nga̱ á re̱ꞌ mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ngaa ni̱ gunun nico ni ngüi̱ israelita sisi̱ nne Jesús xumanꞌ Betania. Ngaa ni̱ ganꞌanj ni sij xumanꞌ daj. Ni̱ sé urin Jesús ganꞌanj niꞌyaj ni sij. Sani̱ ganꞌanj niꞌyaj ni sij Lázaro huin tsínj ganáꞌnij scanij ni níman, guiꞌyaj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Sani̱ uyan dagaꞌmi dugüiꞌ ni chrej aꞌninꞌ sisi̱ da̱gahuiꞌ ni sij Lázaro nej. ");
INSERT INTO trq_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Daj si xiꞌí Lázaro huin sisi̱ gahuin ni̱ni nico ni ngüi̱ israelita sisi̱ gu̱xuman ruhua ni sij niꞌyaj ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ngaa ni̱ ango güi ni̱ gunun daranꞌ ni ngüi̱ gaꞌna̱ꞌ rian gahuin guiꞌyanj pascua sisi̱ ꞌna̱ꞌ Jesús chrej ga̱tu síꞌ xumanꞌ Jerusalén. ");
INSERT INTO trq_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ngaa ni̱ gaꞌninꞌ ni sij raꞌa yun. Ni̱ gahui ni sij duꞌua xumanꞌ ganꞌanj na̱caj ni sij Jesús. Ni̱ gaguáj ni sij. Ni̱ gataj ni sij: ―Ga̱ sa̱ꞌ hueé rian tsínj ꞌna̱ꞌ rian si-xugüi Señor. Sa̱ꞌ hueé huin si-rey ni tsínj israelita. ―Daj gataj ni sij gaguáj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ngaa ni̱ nariꞌ Jesús ꞌngo̱ urruj. Ni̱ guitáj sij xúꞌ. Daj si hué daj gataj rian si-nu̱guanꞌ Yanꞌanj: ");
INSERT INTO trq_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Si̱ guxuꞌuiꞌ ni é re̱ꞌ huin ín re̱ꞌ ni ngüi̱ ma̱n xumanꞌ Sión. Daj sij ꞌna̱ꞌ si-rey ni é re̱ꞌ táj sij ꞌngo̱ urruj daꞌníj urruj xa̱na. Hué daj gataj si-nu̱guanꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Asi̱j sini ni̱ nun gara daꞌngaꞌ ruhua ni tsínj nicoꞌ Jesús xiꞌí si guiranꞌ síꞌ. Sani̱ ngaa guisíj ganahuin ꞌueé Jesús, guiꞌyaj Yanꞌanj, ni̱ nanun ruhua ni sij sisi̱ hua garun ni síꞌ nuguanꞌ nan xiꞌí Jesús. Ni̱ nanun ruhua ni sij sisi̱ daꞌngaꞌ daj guiꞌyaj ni ngüi̱ nga̱ Jesús. ");
INSERT INTO trq_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ni̱ ni ngüi̱ guiniꞌi ngaa gaquínj Jesús Lázaro sisi̱ ga̱hui síꞌ chruhua yuꞌuj, ni̱ nataꞌ ni sij rian dugüiꞌ ni sij si guiniꞌi ni sij ngaa ganáꞌnij Lázaro scanij ni níman, guiꞌyaj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Xiꞌí si gunun ni ngüi̱ sisi̱ guiꞌyaj Jesús si sa̱ꞌ nico daj, ni̱ ganꞌanj na̱caj ni sij Jesús. ");
INSERT INTO trq_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Sani̱ gataj ni tsínj fariseo gunun ni dugüiꞌ ni sij: ―Ni̱ꞌyaj á re̱ꞌ. Ni̱ si̱ guiriꞌ néꞌ yya̱j ga̱ mánj si daranꞌ ni ngüi̱ huaj nga̱ sij. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ni̱ ganꞌanj go̱ꞌngo ni tsínj griego xumanꞌ Jerusalén rian gunu̱n guiꞌyanj daj. Ni̱ ga̱ꞌmi sa̱ꞌ ni sij rian Yanꞌanj, ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ni̱ gahuin ni̱chrunꞌ ni sij rian tsínj gu̱ꞌnaj Felipe huin síꞌ ꞌngo̱ tsínj ꞌna̱ꞌ xumanꞌ Betania ꞌngo̱ xumanꞌ ngaj estado Galilea. Ni̱ gachínj jniꞌyaj ni sij rian síꞌ. Ni̱ gataj ni sij: ―Señor, ruhua ni únj gui̱niꞌi únj Jesús. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ngaa ni̱ ganꞌanj Felipe gataj síꞌ nuguanꞌ daj rian tsínj gu̱ꞌnaj Andrés. Ngaa ni̱ ganꞌanj nu̱ngüej síꞌ ganꞌanj na̱taꞌ síꞌ rian Jesús. ");
INSERT INTO trq_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ngaa ni̱ gataj Jesús: ―Yya̱j guisíj güi sisi̱ ga̱nahuin ꞌueé daꞌníj ni ngüi̱ huin manꞌānj. ");
INSERT INTO trq_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Xa̱ngaꞌ atā rian án re̱ꞌ sisi̱ da̱j rúnꞌ hua ca̱n trigo huin néꞌ. Ni̱ sisi̱ si̱ guinij ꞌngo̱ ca̱n trigo riqui yoꞌój ga̱huiꞌ-íꞌ, ni̱ rúnꞌ hua ca̱n daj hué daj hua-áꞌ guna-áꞌ. Sani̱ sisi̱ ga̱huiꞌ-íꞌ, ni̱ xi̱raꞌ-áꞌ, ni̱ ayu nico ca̱n chra̱-áꞌ. ");
INSERT INTO trq_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Hué dan ni̱ tsínj na̱ꞌuej ruhua ga̱huiꞌ ngāj, ni̱ ga̱ niꞌya sij. Sani̱ tsínj ga̱ꞌuej ruhua ga̱huiꞌ xiꞌīj chruhua xungüi̱ nan, ni̱ ga̱ne ni̱ganj niman sij aj. ");
INSERT INTO trq_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ni̱ tsínj huin ruhua gui̱ꞌyaj sun riānj, ni̱ hua nia̱n gui̱nicoꞌ sij manꞌānj. Ni̱ rian ga̱nēj, ni̱ hué yuꞌuj daj ga̱ne tsínj ꞌyaj sun riānj nej. Ni̱ gui̱nun yanꞌanj chrē tsínj ꞌyaj sun riānj. ");
INSERT INTO trq_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Yya̱j ni̱ ducu nani ruhuāj. Ni̱ u̱n sin huin ga̱tā gu̱nun Yanꞌanj únj. Ga̱tā gu̱nun Yanꞌanj sisi̱ na̱caj Yanꞌanj manꞌānj rian sayun, ruhua á re̱ꞌ níꞌ. Sé da̱j ga̱tā gu̱nun Yanꞌanj mánj. Daj si xiꞌí si gui̱ranꞌānj sayun gaꞌnāj chruhua xungüi̱. ―Daj gataj Jesús gunun nu̱ngüej tsínj daj. ");
INSERT INTO trq_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ngaa ni̱ gataj Jesús gunun Yanꞌanj: ―Gui̱ꞌyáj re̱ꞌ sisi̱ ga̱ꞌmi sa̱ꞌ ꞌueé ni ngüi̱ xiꞌí si-xugüí re̱ꞌ huín re̱ꞌ chrē. ―Daj gataj Jesús. Ngaa ni̱ gunun ni ngüi̱ mán nga̱ Jesús si gaꞌmi Yanꞌanj xataꞌ. Ni̱ gataj Yanꞌanj: ―Hua nahuin ꞌueé si-xugüīj. ―Daj gataj Yanꞌanj gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ni̱ gataj ni ngüi̱ mán nga̱ Jesús sisi̱ gaguáj duꞌui gunun ni sij. Sani̱ gataj ango daꞌaj ni sij sisi̱ gaꞌmi ꞌngo̱ ángel rian Jesús. ");
INSERT INTO trq_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ngaa ni̱ gataj Jesús gunun ni sij: ―Sé xiꞌīj huin si gaꞌmi Yanꞌanj nuguanꞌ nan mánj. Sani̱ gaꞌmi Yanꞌanj sisi̱ ga̱ra daꞌngaꞌ ruhua á re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yya̱j ni̱ na̱guiꞌyaj yya Yanꞌanj nga̱ si-ga̱quinꞌ ni ngüi̱ ma̱n chruhua xungüi̱. Ni̱ yya̱j ni̱ gui̱ri anéj Yanꞌanj sichre huin achij chruhua xungüi̱ nan. ");
INSERT INTO trq_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Sani̱ ngaa go̱docoꞌ ni sij manꞌānj xataꞌ rian rugutsi̱, ngaa ni̱ ga̱ꞌnaꞌ daranꞌ ni ngüi̱ riānj, gui̱ꞌyā. ―Daj gataj Jesús gunun ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ni̱ xiꞌí nuguanꞌ daj digyán Jesús rian ni ngüi̱ da̱j ga̱huiꞌ síꞌ gui̱nicoꞌ síꞌ rian rugutsi̱. ");
INSERT INTO trq_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ngaa ni̱ gataj ni ngüi̱ gunun Jesús: ―Gataj rian si-ley Yanꞌanj sisi̱ ga̱ne ni̱ganj Cristo. Ngaa ni̱ u̱n sin huin ni̱ ataj manꞌán re̱ꞌ sisi̱ do̱coꞌ ni sij daꞌníj ni ngüi̱ xataꞌ únj. Ni̱ u̱n tsínj huin daꞌníj ni ngüi̱, ruhua á re̱ꞌ únj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Xiꞌí daj gataj Jesús: ―Doj güi ga̱ si gui̱xiguin yanꞌa̱n scanij ni é re̱ꞌ. Ngaa ni̱ ga̱che ni é re̱ꞌ rian xigui̱n hua. Ngaa ni̱ si̱ gachej ni é re̱ꞌ rian ru̱miꞌ mánj. Daj si tsínj achéj rian ru̱miꞌ, ni̱ nun niꞌi sij ni̱ a achéj sij mánj. ");
INSERT INTO trq_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ni̱ ngaa xigui̱n yanꞌa̱n rian án re̱ꞌ, ni̱ gu̱xuman ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ yanꞌa̱n daj. Ngaa ni̱ gui̱xiguin rian ga̱chej a ni é re̱ꞌ, gui̱ꞌyaj yanꞌa̱n daj. ―Daj gataj Jesús. Ni̱ ngaa guisíj gataj Jesús ni nuguanꞌ daj, ni̱ ganꞌanj gui̱xij hui̱ sij rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ni̱ nu̱nj si guiꞌyaj Jesús nico si sa̱ꞌ guiniꞌi ni ngüi̱ daj, sani̱ nun gu̱xuman ruhua ni sij guiniꞌyaj ni sij síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Daj si hua nia̱n ga̱huin yya si-nu̱guanꞌ Isaías tsínj gaꞌmi si-nu̱guanꞌ Yanꞌanj asi̱j ná. Ni̱ gataj síꞌ: Señor, u̱n sin huin ni̱ do̱j ni ngüi̱ guxuman ruhua nuguanꞌ nataꞌ ni únj gunun ni sij únj. Ni̱ u̱n sin huin ni̱ naꞌue ga̱ra daꞌngaꞌ ruhua ni sij da̱j nucuaj Señor únj. Daj gataj Isaías. ");
INSERT INTO trq_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ni̱ xiꞌí ango nuguanꞌ gataj Isaías, ni̱ naꞌue gu̱xuman ruhua ni tsínj israelita niꞌyaj ni sij Jesús. Ni̱ gataj Isaías: ");
INSERT INTO trq_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ni̱ garánj rian ni ngüi̱ xiꞌí si naꞌuej ruhua ni sij gunun ni sij. Ngaa ni̱ si̱ gaꞌue gui̱niꞌi ni sij mánj. Ni̱ nun ga̱ꞌue ga̱tu si-nu̱guanꞌānj niman ni sij mánj. Ni̱ naꞌue na̱nicaj ruhua ni sij. Ngaa ni̱ si̱ gaꞌue na̱huin sa̱ꞌ niman ni sij, gui̱ꞌyā mánj. Daj gataj Yanꞌanj garun tsínj gu̱ꞌnaj Isaías asi̱j ná. ");
INSERT INTO trq_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Hué daj gaꞌmi Isaías xiꞌí si guiniꞌi sij si hua sa̱ꞌ ꞌueé Jesús. Yuꞌuj daj gaꞌmi sij xiꞌí síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Sani̱ guxuman ruhua nico ni tsínj israelita ni tsínj huin achij guiniꞌi ni sij Jesús. Sani̱ nun gaꞌmi re̱ngaꞌ ni sij sisi̱ guxuman ruhua ni sij rian ni ngüi̱ xiꞌí si xuꞌuiꞌ ni sij niꞌyaj ni sij ni tsínj fariseo. Daj si sisi̱ gu̱nun ni síꞌ, ni̱ gui̱ri ni síꞌ ni sij chruhua nuhui, ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Daj si garanꞌ ruhua ni sij si ga̱ꞌmi sa̱ꞌ ni ngüi̱ xiꞌí ni sij daj nga̱ si ga̱ꞌmi sa̱ꞌ Yanꞌanj xiꞌí ni sij aj. ");
INSERT INTO trq_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ngaa ni̱ gaꞌmi nucuaj Jesús. Ni̱ gataj sij: ―Tsínj guxuman ruhua niꞌyaj manꞌānj, ni̱ sé urīnj guxuman ruhua sij. Sani̱ hué daj guxuman ruhua sij niꞌyaj sij chrē huin si gaꞌníj gaꞌnāj chruhua xungüi̱ nan. ");
INSERT INTO trq_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tsínj niꞌi manꞌānj, ni̱ hué daj niꞌi sij si gaꞌníj gaꞌnāj chruhua xungüi̱ nan nej. ");
INSERT INTO trq_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Huēj huin yanꞌa̱n gaꞌna̱ꞌ xigui̱n chruhua xungüi̱. Ngaa ni̱ daranꞌ ni ngüi̱ guxuman ruhua niꞌyaj manꞌānj, ni̱ si̱ gachej ni sij rian ru̱miꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","’Ni̱ hua ꞌngo̱ tsínj unun si-nu̱guanꞌānj. Sani̱ naꞌuej ruhua sij da̱gahuin sij si atā gu̱nun sij. Ngaa ni̱ sēj huin tsínj gu̱taꞌ gaquinꞌ rian tsínj da mánj. Daj si sé si gaꞌnāj gu̱taꞌ gaquinꞌ rian ni ngüi̱ ma̱n chruhua xungüi̱ mánj. Sani̱ gaꞌnāj sisi̱ ga̱nacā ni sij aj. ");
INSERT INTO trq_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tsínj da̱nicaj manꞌānj, ni̱ naꞌuej ruhua sij gu̱nun sij si-nu̱guanꞌānj, ni̱ a̱ hua si gui̱ꞌyaj castigo sij. Daj si xiꞌí si nun gunun sij nuguanꞌ gaꞌmī gunun sij, ni̱ ga̱huin castigo sij güi na̱guiꞌyaj yya Yanꞌanj si-ga̱quinꞌ ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ni̱ sé si aꞌmī güenda manꞌānj. Hué chrē si gaꞌníj gaꞌnāj chruhua xungüi̱ nan huin si gaꞌninꞌ sun riānj da̱j ga̱ꞌmī. ");
INSERT INTO trq_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ni̱ niꞌīnj sisi̱ si-nu̱guanꞌ chrē ꞌyaj sisi̱ ga̱ne ni̱ganj ni ngüi̱. Ngaa ni̱ da̱j rúnꞌ gaꞌninꞌ chrē sun riānj, ni̱ hué daj aꞌmī nej. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Hué dan ni̱ ngaa achin gui̱sij güi ga̱huin guiꞌyanj pascua, ni̱ hué niꞌi Jesús sisi̱ hua guisíj hora ga̱hui sij chruhua xungüi̱ nan na̱nꞌ sij rian nne chrej sij. Ni̱ ni̱ganj ꞌi̱ ruhua sij niꞌyaj sij ni tsínj guinicaj dugüiꞌ nga̱ sij chruhua xungüi̱ nan. Ni̱ hué daj guiꞌyaj sij da güi na̱nꞌ sij xataꞌ. ");
INSERT INTO trq_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ni̱ xa stiꞌni̱ Jesús nga̱ ni tsínj nicaj dugüiꞌ nga̱ sij. Ni̱ hua digaꞌmi sichre niman Judas daꞌníj Simón Iscariote sisi̱ na̱gaꞌuiꞌ síꞌ Jesús raꞌa ni tsínj nicaj sun da̱gahuiꞌ ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ni̱ niꞌi Jesús sisi̱ gaꞌuiꞌ chrej sij daranꞌ sun rian sij. Ni̱ niꞌi sij sisi̱ gaꞌna̱ꞌ manꞌan sij rian Yanꞌanj. Ni̱ niꞌi Jesús sisi̱ gui̱nanꞌ sij rian Yanꞌanj nej. ");
INSERT INTO trq_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Hué dan ni̱ ngaa guisíj xa stiꞌni̱ ni sij, ni̱ naxu̱man Jesús rian mesa. Ni̱ guiri sij si-gató sij. Ni̱ numij sij ꞌngo̱ atsij toalla gatin sij. ");
INSERT INTO trq_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ngaa ni̱ gara sij nnee chruhua guruj yoꞌój. Ni̱ gaxi̱ꞌi sij naꞌninꞌ sij dacój ni tsínj nicoꞌ sij. Ni̱ naruꞌui sij nga̱ toalla anumi gatin sij daj. ");
INSERT INTO trq_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Sani̱ ngaa huaj sij na̱ꞌninꞌ sij dacój Simón Pedro, ni̱ gataj síꞌ: ―Señor, ni̱ ga̱naꞌninꞌ manꞌán re̱ꞌ dacō, ruhuá re̱ꞌ níꞌ. ―Daj gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ngaa ni̱: ―Yya̱j ni̱ nun niꞌí re̱ꞌ si ꞌyā. Sani̱ ne̱ꞌ ru̱cu ni̱ ga̱ra daꞌngaꞌ ruhuá re̱ꞌ aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ngaa ni: ―Nitaj a̱man na̱ꞌninꞌ re̱ꞌ dacō mánj. ―Gataj Pedro. Ngaa ni̱ gataj Jesús: ―Sisi̱ si̱ naꞌnīj dacój re̱ꞌ, ni̱ si̱ gaꞌue ga̱huin re̱ꞌ tsínj gui̱nicaj dugüiꞌ ngāj mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ngaa ni̱: ―Sé urin dacō na̱ꞌninꞌ re̱ꞌ, sani̱ na̱ꞌninꞌ re̱ꞌ raꞌāj nga̱ chrāj nej. ―Daj gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ngaa ni̱ gataj Jesús: ―Ni̱ sisi̱ da guisíj gane néꞌ, ni̱ urin dacój néꞌ huin si naꞌninꞌ néꞌ mánj. Daj si hua sa̱ꞌ néꞌ. Ni̱ hua sa̱ꞌ niman án re̱ꞌ. Sani̱ sé si hua sa̱ꞌ niman daranꞌ ni é re̱ꞌ mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ni̱ hua niꞌi Jesús u̱n tsínj huin si na̱gaꞌuiꞌ sij raꞌa ni tsínj nicaj sun. Xiꞌí daj gataj Jesús: “Nun hua sa̱ꞌ niman daranꞌ ni é re̱ꞌ.” Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ngaa guisíj naꞌninꞌ Jesús dacój ni tsínj nicoꞌ sij, ni̱ nanun sij si-gató sij. Ni̱ ganꞌanj ga̱ne ru̱huaꞌ yún sij rian mesa. Ni̱ gataj sij gunun ni síꞌ: ―Niꞌi a ni é re̱ꞌ u̱n xiꞌí guiꞌyā daj nga̱ ni é re̱ꞌ níꞌ. ");
INSERT INTO trq_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Duguꞌna̱j ni é re̱ꞌ Maestro manꞌānj. Ni̱ ataj ni é re̱ꞌ sisi̱ Señor huīnj. Ni̱ duguꞌna̱j aꞌmi a ni é re̱ꞌ xa̱ngaꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ngaa ni̱ huīnj Maestro nga̱ Señor rian án re̱ꞌ. Sani̱ naꞌnīj dacój ni é re̱ꞌ. Ni̱ xiꞌí daj hua nia̱n si na̱ꞌninꞌ a ni é re̱ꞌ dacój dugüiꞌ ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ni̱ hué daj huin ꞌngo̱ daꞌngaꞌ digyānj rian án re̱ꞌ sisi̱ gui̱ꞌyaj ni é re̱ꞌ da̱j rúnꞌ guiꞌyā. ");
INSERT INTO trq_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ nitaj si huin achij ꞌngo̱ moso rian si-xuruꞌue sij. Ni̱ nitaj si huin achij tsínj ganꞌanj sun rian tsínj gaꞌníj ga̱nꞌanj sij. ");
INSERT INTO trq_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ni̱ hua gunun a ni é re̱ꞌ ni nuguanꞌ nan. Ngaa ni̱ sisi̱ gui̱ꞌyaj á re̱ꞌ ni nuguanꞌ nan, ni̱ ga̱huin ꞌueé rian án re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nitaj si aꞌmī xiꞌí daranꞌ ni é re̱ꞌ mánj. Daj si niꞌīnj u̱n si huin ganacuīj. Sani̱ hua nia̱n ga̱huin yya da̱j rúnꞌ gataj rian si-nu̱guanꞌ Yanꞌanj: “Tsínj xa chrachrúnj ngāj, ni̱ nanica̱j sij gununꞌ sij ngāj.” Hué daj gataj rian si-nu̱guanꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","’Asi̱j yya̱j atā gu̱nun a ni é re̱ꞌ ngaa achin ga̱huin nuguanꞌ daj. Ngaa ni̱ gu̱xuman ruhua á re̱ꞌ sisi̱ huēj huin Cristo ngaa gui̱niꞌi a ni é re̱ꞌ si gui̱ranꞌānj. ");
INSERT INTO trq_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Xa̱ngaꞌ atā rian án re̱ꞌ sisi̱ tsínj na̱huin raꞌa ꞌngo̱ tsínj gaꞌnī ga̱nꞌanj, ni̱ na̱huin raꞌa sij manꞌānj nej. Ni̱ tsínj na̱huin raꞌa manꞌānj, ni̱ na̱huin raꞌa sij si gaꞌníj ga̱ꞌnāj aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ngaa guisíj gataj Jesús nuguanꞌ daj, ni̱ ni̱nꞌ ruhua ganani ruhua sij. Ni̱ gataj sij gunun ni síꞌ: ―Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ ꞌngo̱ ni é re̱ꞌ huin si na̱gaꞌuiꞌ manꞌānj raꞌa ni tsínj ga̱ꞌnaꞌ gui̱daꞌa yūnj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ngaa ni̱ gaxi̱ꞌi ni tsínj nicoꞌ sij niꞌyaj ni síꞌ rian go̱ꞌngo dugüiꞌ ni síꞌ. Daj si nun riꞌ ruhua ni sij u̱n tsínj xi̱ꞌi gaꞌmi Jesús. ");
INSERT INTO trq_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ni̱ ꞌi̱ ruhua Jesús niꞌyaj sij ꞌngo̱ tsínj nicoꞌ sij. Ni̱ nne tsínj daj xiꞌníj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ngaa ni̱ digyán raꞌa Simón Pedro tsínj daj sisi̱ na̱chinꞌ snanꞌanj síꞌ u̱n tsínj rian aꞌmi Jesús. ");
INSERT INTO trq_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ngaa ni̱ ngaj síꞌ rian xiꞌyanj Jesús nachinꞌ snanꞌanj síꞌ Jesús. Ni̱ gataj síꞌ: ―Señor, u̱n tsínj huin únj. ―Daj gataj síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ngaa ni̱ gataj Jesús: ―Jniꞌyā do̱j chrachrúnj ga̱ꞌuij. Ni̱ hué tsínj rian ga̱ꞌuīj daj, hué sij huin nánj. ―Daj gataj Jesús. Hué dan ni̱ jniꞌyaj Jesús do̱j chrachrúnj. Ni̱ gaꞌuiꞌ sij rian tsínj gu̱ꞌnaj Judas daꞌníj Simón Iscariote. ");
INSERT INTO trq_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ni̱ ngaa guisíj guidaꞌa Judas chrachrúnj daj, ni̱ gatúj sichre Satanás chruhua niman sij. Ngaa ni̱: ―Ráꞌyanj gui̱ꞌyáj re̱ꞌ si huin ruhuá re̱ꞌ gui̱ꞌyáj re̱ꞌ nánj. ―Gataj Jesús gunun Judas. ");
INSERT INTO trq_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Sani̱ ni a̱ ꞌngo̱ ni tsínj nne rian mesa daj nun guiniꞌi u̱n sin gataj Jesús nuguanꞌ daj rian Judas. ");
INSERT INTO trq_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ni̱ Judas huin tsínj nicaj si-sa̱nꞌanj ni sij. Ngaa ni̱ gani ruhua go̱ꞌngo ni sij sisi̱ huin ruhua Jesús sisi̱ gui̱ran Judas ni rasu̱n gui̱riꞌ ni sij rian ga̱huin guiꞌyanj, asi̱ ga̱ꞌuiꞌ síꞌ do̱j rian ni ngüi̱ niqui. ");
INSERT INTO trq_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ngaa guisíj guidaꞌa Judas chrachrúnj daj, ni̱ gahui sij xe̱ꞌ hua ni̱ ganꞌanj sij. ");
INSERT INTO trq_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ngaa guisíj ganꞌanj Judas, ni̱ gataj Jesús gunun ango ni síꞌ: ―Yya̱j ni̱ gui̱niꞌi ni ngüi̱ sisi̱ sa̱ꞌ ni̱nꞌ ruhua ga̱nahuīnj huīnj daꞌníj ni ngüi̱. Ni̱ xiꞌí daj gui̱niꞌi ni ngüi̱ sisi̱ sa̱ꞌ ni̱nꞌ ruhua huin Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ni̱ sisi̱ gui̱niꞌi ni ngüi̱ sisi̱ sa̱ꞌ ni̱nꞌ ruhua huin Yanꞌanj, gui̱ꞌyā, ni̱ hué daj gui̱niꞌi ni ngüi̱ sisi̱ sa̱ꞌ ni̱nꞌ ruhua huin manꞌānj, gui̱ꞌyaj ráꞌyanj Yanꞌanj nej. ");
INSERT INTO trq_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Rúnꞌ huin daꞌnī huin a ni é re̱ꞌ riānj. Ni̱ yya̱j ni̱ do̱j ga̱nēj nga̱ á re̱ꞌ. Ni̱ na̱noꞌ a ni é re̱ꞌ yūnj. Ni̱ da̱j rúnꞌ gatā gunun ni tsínj israelita, ni̱ daꞌngaꞌ daj atā rian án re̱ꞌ yya̱j sisi̱ si̱ gaꞌue ga̱nꞌanj án re̱ꞌ rian ga̱nꞌān mánj. ");
INSERT INTO trq_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ni̱ aꞌnīj sun rian án re̱ꞌ huin ꞌngo̱ nuguanꞌ na̱ca sisi̱ ga̱huin ꞌi̱ ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ dugüiꞌ a ni é re̱ꞌ. Ni̱ da̱j rúnꞌ ꞌi̱ ruhuāj niꞌyā ni é re̱ꞌ, ni̱ daꞌngaꞌ daj gui̱ꞌyaj a ni é re̱ꞌ nga̱ dugüiꞌ a ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Sisi̱ ꞌi̱ ruhua ni du̱güiꞌ ni manꞌan án re̱ꞌ, ngaa ni̱ gui̱niꞌi daranꞌ ni ngüi̱ sisi̱ hué ni é re̱ꞌ huin ni tsínj nicoꞌ manꞌānj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ngaa ni̱ nachínj snanꞌanj Simón Pedro Jesús. Ni̱ gataj sij: ―Señor, ni̱ a ga̱nꞌanj re̱ꞌ únj. ―Gataj Pedro. Ngaa ni̱: ―Rian ga̱nꞌān ni̱ si̱ gahuin nucuáj re̱ꞌ ga̱nꞌanj re̱ꞌ ngāj mánj. Sani̱ da ru̱cu ni̱ ga̱ꞌue gui̱nicoꞌ re̱ꞌ manꞌānj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ngaa ni̱ gataj Pedro: ―Señor, u̱n sin huin ni̱ si̱ gahuin nucuā gui̱nicōj acuanꞌ so̱ꞌ únj. Hua ni̱ca ruhuāj ga̱huīj xiꞌí re̱ꞌ aj. ―Gataj Pedro gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ngaa ni̱ gataj Jesús: ―Hua ni̱ca xa̱ngaꞌ ruhuá re̱ꞌ ga̱huiꞌ re̱ꞌ xiꞌīj níꞌ. Xa̱ngaꞌ atā gu̱nun re̱ꞌ: Asi̱j nun ga̱guaj doꞌloj duꞌua xúꞌ, ni̱ ga̱taj re̱ꞌ hua̱ꞌnij sisi̱ nun niꞌí re̱ꞌ manꞌānj. ―Daj gataj Jesús gunun Pedro. ");
INSERT INTO trq_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ngaa ni̱ gataj Jesús gunun ni sij: ―Si̱ guiriun ruhua á re̱ꞌ mánj. Gu̱xuman ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ Yanꞌanj, ni̱ hué daj gu̱xuman ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ manꞌānj nej. ");
INSERT INTO trq_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ducuā chrē ni̱ hua ni̱nꞌ ruhua rian ga̱ne a ni é re̱ꞌ. Sisi̱ sé daj huin, ni̱ si̱ gataj snanꞌān gu̱nun a ni é re̱ꞌ sisi̱ ga̱nꞌān gui̱ꞌyaj xugüīj rian gui̱man án re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ngaa gui̱sij ga̱nꞌān gui̱ꞌyaj xugüīj rian gui̱man án re̱ꞌ, ni̱ ga̱ꞌnaꞌ yūnj. Ni̱ nicā ga̱nꞌān ni é re̱ꞌ sisi̱ ga̱ne nu̱guanꞌan néꞌ. ");
INSERT INTO trq_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ni̱ niꞌi ni é re̱ꞌ ni a ga̱nꞌān. Ni̱ niꞌi ni é re̱ꞌ chrej nej. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ngaa ni̱ gataj tsínj gu̱ꞌnaj Tomás. ―Señor, nun niꞌi ni únj ni̱ a ga̱nꞌanj re̱ꞌ. Ngaa ni̱ asa̱ꞌ ga̱ꞌue gui̱niꞌi ni únj chrej ga̱nꞌanj re̱ꞌ únj. ―Gataj Tomás gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ngaa ni̱ gataj Jesús: ―Huēj huin chrej daj. Ni̱ huēj huin nuguanꞌ xa̱ngaꞌ nej. Ni̱ huēj ꞌyaj si hua ni̱ꞌnaꞌ ni̱ganj ni ngüi̱. Sisi̱ si̱ gaꞌuej ruhua ꞌngo̱ tsínj daj gui̱nicoꞌ sij manꞌānj, ni̱ nitaj a̱man gui̱sij sij rian nne chrē mánj. ");
INSERT INTO trq_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Sisi̱ niꞌi ni é re̱ꞌ manꞌānj, ni̱ hué daj niꞌi ni é re̱ꞌ chrē nej. Asi̱j yya̱j ni̱ niꞌi ni é re̱ꞌ chrē. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ngaa ni̱ gataj tsínj gu̱ꞌnaj Felipe: ―Señor, di̱gyán re̱ꞌ chrej néꞌ gui̱niꞌi únj. Ngaa ni̱ ga̱huin yya ruhua únj. ―Gataj Felipe. ");
INSERT INTO trq_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ngaa ni̱ gataj Jesús: ―Felipe, u̱n sin huin ni̱ nun niꞌí re̱ꞌ yūnj, ni̱ hua ná nicaj dugüiꞌ nu̱guanꞌan néꞌ únj. Tsínj niꞌi manꞌānj, ni̱ niꞌi sij chrē nej. Asa̱ꞌ ga̱ꞌue ga̱taj re̱ꞌ si di̱gyānj chrē, ni̱ nne chrē nimānj níꞌ. ");
INSERT INTO trq_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nun niꞌí re̱ꞌ sisi̱ nnēj niman chrē, ni̱ nne chrē nimānj níꞌ. Ni̱ huin ruhuaj gata sisi̱ urin únj huin anj. Ni̱ ni nuguanꞌ aꞌmī gunun ni é re̱ꞌ sé si aꞌmī güenda manꞌānj. Sani̱ chrē nne ngāj huin si ꞌyaj sun daranꞌ sun ꞌyaj sūnj. ");
INSERT INTO trq_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Gu̱xuman ruhua á re̱ꞌ sisi̱ nnēj niman chrē, ni̱ nne chrē nimānj nej. Ni̱ sisi̱ nitaj, ni̱ gu̱xuman ruhua ni é re̱ꞌ ni̱ꞌyaj á re̱ꞌ manꞌānj xiꞌí sun ꞌyaj sūnj anj. ");
INSERT INTO trq_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Atā xa̱ngaꞌ rian án re̱ꞌ: Tsínj xuman ruhua niꞌyaj manꞌānj, ni̱ ga̱ꞌue gui̱ꞌyaj sun sij da̱j rúnꞌ ꞌyaj sun manꞌānj. Ni̱ ga̱ꞌue gui̱ꞌyaj sij si sa̱ꞌ doj daj nga̱ manꞌānj xiꞌí si na̱nꞌānj rian chrē. ");
INSERT INTO trq_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ni̱ gui̱ꞌyā daranꞌ si achínj jniꞌyaj ni é re̱ꞌ rian chrē xiꞌí si nicoꞌ ni é re̱ꞌ manꞌānj. Hué dan ni̱ ga̱ꞌmi sa̱ꞌ ni ngüi̱ xiꞌí Yanꞌanj, gui̱ꞌyā huīnj daꞌníj Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ni̱ gui̱ꞌyā daranꞌ si achínj jniꞌyaj ni é re̱ꞌ riānj xiꞌí si nicoꞌ ni é re̱ꞌ manꞌānj. ");
INSERT INTO trq_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Sisi̱ xa̱ngaꞌ ꞌi̱ ruhua á re̱ꞌ niꞌyaj á re̱ꞌ yūnj, ngaa ni̱ da̱gahuin a ni é re̱ꞌ ni nuguanꞌ aꞌnīj sun rian án re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ni̱ ga̱chinj jniꞌyā sisi̱ ga̱ꞌnij chrē ango si chra̱cuij a ni é re̱ꞌ. Ni̱ huej huin Espíritu Santo. Ni̱ ni̱ganj ga̱ne Espíritu Santo nga̱ á re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ni̱ ni̱nanj nuguanꞌ xa̱ngaꞌ di̱gyán Espíritu Santo rian ni ngüi̱ ma̱n chruhua xungüi̱ gaquinꞌ nan. Ni̱ si̱ gahuin nucuaj ni sij na̱huin raꞌa ni sij Espíritu Santo si naꞌue gui̱niꞌi ni sij síꞌ. Sani̱ niꞌi ni é re̱ꞌ síꞌ xiꞌí si nne Espíritu Santo nga̱ ni é re̱ꞌ. Ni̱ ga̱ne síꞌ niman ni é re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nitaj si dunā urin ni é re̱ꞌ mánj. Na̱nicaj ru̱huaꞌ yūnj ga̱ꞌnāj rian án re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Do̱j achin ni̱ si̱ guiniꞌi ni ngüi̱ ma̱n chruhua xungüi̱ gaquinꞌ nan manꞌānj mánj. Sani̱ gui̱niꞌi a ni é re̱ꞌ yūnj anj. Ni̱ ga̱ ni̱ꞌnaꞌ ni̱ganj án re̱ꞌ xiꞌí si hua ni̱ꞌnaꞌ ni̱ganj manꞌānj. ");
INSERT INTO trq_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ni̱ gui̱niꞌi a ni é re̱ꞌ manꞌānj. Ni̱ xa̱caj a ni é re̱ꞌ cuenta sisi̱ nnēj niman chrē. Ni̱ nne a ni é re̱ꞌ niman manꞌānj. Ni̱ nnēj niman ni é re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Tsínj nahuin raꞌa si-nu̱guanꞌānj, ni̱ da̱gahuin sij nej, ni̱ hué tsínj daj huin si digyán yya riānj sisi̱ ꞌi̱ ruhua sij niꞌyaj sij manꞌānj. Ni̱ ga̱huin ꞌi̱ ruhua chrē niꞌya tsínj ꞌi̱ ruhua niꞌyaj manꞌānj. Ni̱ huē daj ga̱ ꞌi̱ ruhuāj niꞌyā tsínj daj. Ni̱ di̱gyānj manꞌānj gui̱niꞌi sij. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ngaa ni̱ nachínj snanꞌanj Judas manꞌan Jesús. (Ni̱ sé Judas Iscariote huin síꞌ.) Ni̱ gataj síꞌ: ―Señor, u̱n sin huin di̱gyán re̱ꞌ manꞌán re̱ꞌ rian ni únj, ni̱ naꞌue di̱gyán re̱ꞌ manꞌán re̱ꞌ rian ni ngüi̱ ma̱n chruhua xungüi̱ únj. ―Daj gataj Judas. ");
INSERT INTO trq_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ngaa ni̱ gataj Jesús gunun síꞌ: ―Tsínj ꞌi̱ ruhua niꞌyaj manꞌānj, ni̱ da̱gahuin sij si-nu̱guanꞌānj. Ngaa ni̱ ga̱huin ꞌi̱ ruhua chrē ni̱ꞌya tsínj daj. Ni̱ ga̱ꞌnaꞌ nu̱ngüej chrej únj ga̱ne únj nga̱ sij. ");
INSERT INTO trq_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ni̱ tsínj nitaj si ꞌi̱ ruhua niꞌyaj manꞌānj, ni̱ nun da̱gahuin sij si-nu̱guanꞌānj. Ni̱ nuguanꞌ aꞌmī unun ni é re̱ꞌ, ni̱ sé si-nu̱guanꞌānj huin mánj. Sani̱ si-nu̱guanꞌ chrē si gaꞌníj gaꞌnāj huin nuguanꞌ aꞌmī aj. ");
INSERT INTO trq_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Ni̱ ga̱ꞌnij chrē ga̱ꞌnaꞌ Espíritu Santo rian án re̱ꞌ. Ni̱ ga̱ꞌmi síꞌ da̱j rúnꞌ aꞌmi manꞌānj. Ni̱ chra̱cuij síꞌ ni é re̱ꞌ nej. Ni̱ di̱gyán síꞌ daranꞌ ni nuguanꞌ rian án re̱ꞌ. Ni̱ gui̱ꞌyaj síꞌ si ga̱nanun ruhua á re̱ꞌ daranꞌ ni nuguanꞌ gaꞌmī gunun a ni é re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ni̱ ga̱ꞌnij chrē ga̱ꞌnaꞌ Espíritu Santo rian án re̱ꞌ. Ni̱ ga̱ꞌmi síꞌ da̱j rúnꞌ aꞌmi manꞌānj. Ni̱ chra̱cuij síꞌ ni é re̱ꞌ nej. Ni̱ di̱gyán síꞌ daranꞌ ni nuguanꞌ rian án re̱ꞌ. Ni̱ gui̱ꞌyaj síꞌ si ga̱nunun ruhua á re̱ꞌ daranꞌ ni nuguanꞌ gaꞌmī gunun a ni é re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Hué dan ni̱ ga̱ dinꞌinj ruhua á re̱ꞌ, gui̱ꞌyā. Ni̱ riquīj sisi̱ da̱j rúnꞌ hua dinꞌinj ruhua manꞌānj, ni̱ daꞌngaꞌ daj ga̱ dinꞌinj chruhua ni é re̱ꞌ nej. Sani̱ sé si riquīj da̱j rúnꞌ ꞌyaj ni ngüi̱ ma̱n chruhua xungüi̱ gaquinꞌ nan mánj. Si̱ guiriun ruhua á re̱ꞌ, ni̱ si̱ guxuꞌuiꞌ ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Hua gunun a ni é re̱ꞌ nuguanꞌ gaꞌmī sisi̱ ga̱nꞌān, ni̱ na̱nicaj ru̱huaꞌ yūnj ga̱ꞌnāj rian án re̱ꞌ. Ni̱ sisi̱ ꞌi̱ ruhua á re̱ꞌ niꞌyaj á re̱ꞌ manꞌānj, ngaa ni̱ gahuin nia̱ꞌ ruhua ni é re̱ꞌ gunun a ni é re̱ꞌ nuguanꞌ gatā sisi̱ na̱nꞌānj rian nne chrē. Daj si huin achij chrē doj daj nga̱ manꞌānj. ");
INSERT INTO trq_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","’Ni̱ gatā nuguanꞌ nan rian án re̱ꞌ da̱j gui̱ranꞌānj ngaa achin ga̱huin. Ngaa ni̱ ngaa guisíj gui̱ranꞌānj daj, ni̱ ga̱ꞌue gu̱xuman ruhua á re̱ꞌ ni̱ꞌyaj á re̱ꞌ manꞌānj. ");
INSERT INTO trq_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Si̱ gaꞌmī nicōj nga̱ ni̱ é re̱ꞌ ga̱ mánj. Daj si ꞌna̱ꞌ sichre, tsínj huin achij chruhua xungüi̱ nan. Sani̱ nitaj si nicaj-áꞌ fuerza riānj mánj. ");
INSERT INTO trq_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Sani̱ hua nia̱n si gui̱ꞌyā da̱j rúnꞌ gaꞌninꞌ chrē sun riānj. Ngaa ni̱ gui̱niꞌi ni ngüi̱ ma̱n chruhua xungüi̱ sisi̱ ꞌi̱ ruhuāj niꞌyā chrē. Na̱xuman án re̱ꞌ, ni̱ ga̱nꞌanj néꞌ ango yuꞌuj. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús: ―Da̱j rúnꞌ hua ꞌngo̱ yaꞌa̱ mmanj siu̱ coj uva xa̱ngaꞌ, ni̱ daꞌngaꞌ daj huin manꞌānj. Ni̱ hué chrē huin si dugumi coj uva daj. ");
INSERT INTO trq_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ni̱ sisi̱ nitaj si ayu uva chra̱ ꞌngo̱ yaꞌa̱ raꞌa coj daj, ni̱ ga̱ꞌninꞌ chrē yaꞌa̱ daj sisi̱ ga̱yu nico uva chra̱-áꞌ. ");
INSERT INTO trq_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yya̱j ni̱ hua sa̱ꞌ ni é re̱ꞌ, guiꞌyaj nuguanꞌ gaꞌmī rian án re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ni̱ganj gui̱nicaj dugüiꞌ ni é re̱ꞌ ngāj. Ngaa ni̱ gui̱nicaj dugüiꞌīj nga̱ ni é re̱ꞌ. Ni̱ sisi̱ nitaj si ni̱caj dugüiꞌ ꞌngo̱ yaꞌa̱ raꞌa coj uva daj nga̱ yaꞌa̱ mmanj siu̱, ni̱ si̱ gaꞌue ga̱yu uva chraj mánj. Ni̱ hué ducuánj daj, ni̱ naꞌue gui̱ꞌyaj á re̱ꞌ si-sun manꞌānj sisi̱ nitaj si nicaj dugüiꞌ ni é re̱ꞌ ngāj. ");
INSERT INTO trq_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Huēj huin yaꞌa̱ mmanj siu̱ coj uva daj. Ni̱ huin ni é re̱ꞌ yaꞌa̱ gatin ahui xiráj yaꞌa̱ mmanj daj. Tsínj ꞌngo̱ nicaj dugüiꞌ ngāj, ni̱ ga̱ꞌuej ruhua sij sisi̱ ni̱caj dugüiꞌīj nga̱ sij, ni̱ gui̱ꞌyaj sun sa̱ꞌ sij disūnj. Daj si sisi̱ nitaj si chra̱cuij manꞌānj, ni̱ si̱ gahuin nucuaj á re̱ꞌ gui̱ꞌyaj sun sa̱ꞌ á re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tsínj naꞌuej ruhua gui̱nicaj dugüiꞌ ngāj, ni̱ gui̱ranꞌ sij da̱j rúnꞌ ranꞌ ni raꞌa coj ngaa nacoj aj. Ni̱ nachránj ni sij ni raꞌa coj daj guereꞌej ni sij ne̱ꞌ chrej xe̱ꞌ. Ni̱ gari yanꞌa̱n ni sij. Hué daj gui̱ranꞌ tsínj naꞌuej ruhua gui̱nicaj dugüiꞌ ngāj. ");
INSERT INTO trq_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Ni̱ sisi̱ gui̱nicaj dugüiꞌ ni é re̱ꞌ ngāj, ni̱ ga̱ gue̱ da̱gahuin ni é re̱ꞌ si-nu̱guanꞌānj, ngaa ni̱ ga̱ꞌue ga̱chinj jniꞌyaj á re̱ꞌ si aranꞌ ruhua á re̱ꞌ riānj. Ngaa ni̱ ri̱quīj rian án re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ni̱ sisi̱ ꞌyaj sun sa̱ꞌ á re̱ꞌ si-sūnj, ni̱ aꞌmi sa̱ꞌ ni ngüi̱ xiꞌí chrē. Ngaa ni̱ ga̱huin ni é re̱ꞌ ni tsínj nicoꞌ xa̱ngaꞌ manꞌānj. ");
INSERT INTO trq_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ni̱ da̱j rúnꞌ ꞌi̱ ruhua chrē niꞌya manꞌānj, ni̱ daꞌngaꞌ daj ꞌi̱ ruhuāj niꞌyā ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ni̱ sisi̱ da̱gahuin ni é re̱ꞌ ni nuguanꞌ aꞌnīj sun rian án re̱ꞌ, ngaa ni̱ ni̱ganj ni̱guiꞌij ni é re̱ꞌ sisi̱ ꞌi̱ ruhuāj niꞌyā ni é re̱ꞌ. Daj si hué daj dagahuīnj ni nuguanꞌ aꞌninꞌ chrē sun riānj. Ni̱ ni̱ganj niguiꞌīj sisi̱ ꞌi̱ ruhua chrē niꞌya manꞌānj. ");
INSERT INTO trq_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Nuguanꞌ nan aꞌmī nga̱ ni é re̱ꞌ sisi̱ da̱j rúnꞌ huin nia̱ꞌ ruhuāj, ni̱ daꞌngaꞌ daj ga̱huin nia̱ꞌ ruhua ni é re̱ꞌ. Ni̱ huin ruhuāj sisi̱ hua yya ga̱huin nia̱ꞌ ruhua ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Aꞌnīj sun nan rian án re̱ꞌ: Ga̱ ꞌi̱ ruhua á re̱ꞌ gui̱niꞌyaj á re̱ꞌ ni dugüiꞌ a ni é re̱ꞌ da̱j rúnꞌ ꞌi̱ ruhuāj niꞌyā á re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ni̱ sisi̱ gu̱nucuaj ꞌngo̱ tsínj daj ga̱huiꞌ sij xiꞌí ꞌngo̱ tsínj nicaj dugüiꞌ nga̱ sij, ni̱ ꞌi̱ yya ruhua sij niꞌyaj sij aj. Ni̱ ꞌi̱ ruhua sij niꞌyaj sij ni dugüiꞌ sij daj nga̱ si ꞌi̱ ruhua ango ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ni̱ huin ni é re̱ꞌ ni tsínj nicaj dugüiꞌ ngāj sisi̱ da̱gahuin ni é re̱ꞌ si aꞌnīj sun rian ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ngaa ni̱ si̱ gatā sisi̱ huin ni é re̱ꞌ ni tsínj ꞌyaj sun riānj ga̱ mánj. Daj si nun niꞌi ꞌngo̱ tsínj ꞌyaj sun u̱n sin ꞌyaj tsínj huin achij rian sij. Sani̱ ga̱tā sisi̱ huin ni é re̱ꞌ ni tsínj nicaj dugüiꞌ ngāj. Daj si hua digyānj rian ni é re̱ꞌ ni nuguanꞌ gataj chrē riānj. ");
INSERT INTO trq_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Sé ni é re̱ꞌ nacui manꞌānj. Sani̱ na̱anj manꞌānj huin si nacui ni é re̱ꞌ. Ni̱ garasūnj sisi̱ ga̱nꞌanj ni é re̱ꞌ, gui̱ꞌyaj sa̱ꞌ ni é re̱ꞌ si-sūnj. Ni̱ si̱ guereꞌ si-sun ni é re̱ꞌ mánj. Ngaa ni̱ ri̱qui chrē rian án re̱ꞌ daranꞌ si achínj jniꞌyaj á re̱ꞌ xiꞌí si huin a ni é re̱ꞌ tsínj nicoꞌ manꞌānj. ");
INSERT INTO trq_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Hué nuguanꞌ nan huin si aꞌnīj sun rian án re̱ꞌ: Ga̱ ꞌi̱ ruhua á re̱ꞌ nga̱ ni dugüiꞌ ni é re̱ꞌ aj. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús: ―Ni̱ sisi̱ nun huin xa̱nꞌ ruhua ni ngüi̱ ma̱n chruhua xungüi̱ gaquinꞌ nan niꞌyaj ni sij ni é re̱ꞌ, ngaa ni̱ xa̱caj á re̱ꞌ cuenta sisi̱ hué daj guiꞌyaj sini ni sij nga̱ manꞌānj nej. ");
INSERT INTO trq_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sisi̱ xa̱caj ni é re̱ꞌ ducuánj ni ngüi̱ ma̱n chruhua xungüi̱ gaquinꞌ nan, ni̱ ga̱huin nia̱ꞌ ruhua ni sij ni̱ꞌyaj ni sij ni é re̱ꞌ. Sani̱ huēj huin si nacui ni é re̱ꞌ scanij ni sij sisi̱ du̱na á re̱ꞌ ducuánj daj. Xiꞌí daj ni̱ nun huin xa̱nꞌ ruhua ni sij niꞌyaj ni sij a ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","’Ga̱nanun ruhua ni é re̱ꞌ nuguanꞌ gatā gunun ni é re̱ꞌ: “Tsínj ꞌyaj sun rian xuruꞌue, ni̱ nitaj huin achij sij da̱j rúnꞌ achij si-xuruꞌue sij mánj.” Daj gatā gunun ni é re̱ꞌ. Ni̱ sisi̱ chranꞌ yunꞌunj ni ngüi̱ manꞌānj, ni̱ hué daj gui̱ꞌyaj ni sij chra̱nꞌ yunꞌunj ni sij ni é re̱ꞌ nej. Ni̱ xiꞌí si nun gunun ni sij si-nu̱guanꞌānj, ni̱ hué daj si̱ gunun ni sij si-nu̱guanꞌ ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ni̱ daranꞌ nan gui̱ꞌyaj ni sij nga̱ ni é re̱ꞌ xiꞌí si nicoꞌ ni é re̱ꞌ manꞌānj. Daj si nun niꞌi ni sij si gaꞌníj gaꞌnāj. ");
INSERT INTO trq_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ni̱ sisi̱ nitaj si gaꞌnāj gaꞌmī nuguanꞌ sa̱ꞌ gunun ni sij, ni̱ nitaj gaquinꞌ daꞌui ni sij mánj. Sani̱ yya̱j ni̱ si̱ gaꞌue ga̱taj ni sij sisi̱ nitaj gaquinꞌ daꞌui ni sij mánj. ");
INSERT INTO trq_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Daj si tsínj nun huin xa̱nꞌ ruhua sij niꞌyaj sij manꞌānj, ni̱ daꞌngaꞌ daj nun huin xa̱nꞌ ruhua sij niꞌyaj sij chrē nej. ");
INSERT INTO trq_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ni̱ huēj guiꞌyā si sa̱ꞌ nico scanij ni sij. Ni̱ nitaj a̱man guiniꞌi ni sij da̱j rúnꞌ guiꞌyā scanij ni sij. Ni̱ sisi̱ nun guiniꞌi ni sij si sa̱ꞌ nico guiꞌyā, ngaa ni̱ nitaj gaquinꞌ daꞌui ni sij mánj. Ni̱ nu̱nj si guiniꞌi ni sij si guiꞌyā, sani̱ nun huin xa̱nꞌ ruhua ni sij niꞌyaj ni sij nu̱ngüej chrej únj. ");
INSERT INTO trq_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ni̱ daꞌngaꞌ daj guiꞌyaj ni sij sisi̱ ga̱huin yya da̱j rúnꞌ gataj rian si-ley Moisés, huin nuguanꞌ aya ni sij: “Nitaj nu̱nj guiꞌyā, sani̱ nun huin xa̱nꞌ ruhua ni sij niꞌyaj ni sij manꞌānj.” Daj gataj si-ley Moisés. ");
INSERT INTO trq_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Ni̱ ga̱ꞌnī ga̱ꞌnaꞌ si chra̱cuij ni é re̱ꞌ huin Espíritu Santo tsínj aꞌmi nuguanꞌ xa̱ngaꞌ. Ni̱ Espíritu Santo daj ꞌna̱ꞌ rian chrē. Ni̱ huej huin si ga̱ꞌmi sa̱ꞌ nga̱ á re̱ꞌ xiꞌīj. ");
INSERT INTO trq_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ni̱ ga̱ꞌmi sa̱ꞌ ni é re̱ꞌ xiꞌīj nej. Daj si asi̱j sini nicaj dugüiꞌ ni é re̱ꞌ ngāj. ");
INSERT INTO trq_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Ni̱ hué nuguanꞌ nan aꞌmī nga̱ ni é re̱ꞌ sisi̱ si̱ gaꞌninꞌ ruhua ni é re̱ꞌ gui̱nicoꞌ a ni é re̱ꞌ manꞌānj mánj. ");
INSERT INTO trq_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ni̱ gui̱ri ni sij ni é re̱ꞌ chruhua nuhui nico. Ni̱ ga̱ꞌnaꞌ ꞌngo̱ güi ngaa ga̱ni ruhua ni sij sisi̱ ꞌyaj ni sij si-sun Yanꞌanj ngaa da̱gahuiꞌ ni sij ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ni̱ daꞌngaꞌ daj gui̱ꞌyaj ni sij si nun niꞌi ni sij nu̱ngüej chrej únj. ");
INSERT INTO trq_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ni̱ hué daj atā nuguanꞌ nan rian án re̱ꞌ sisi̱ ngaa gui̱sij güi daj, ni̱ ga̱nanun ruhua á re̱ꞌ nga̱ nuguanꞌ hua gataj yyāj gunun a ni é re̱ꞌ. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. Ngaa ni̱ gataj ru̱huaꞌ yún Jesús: ―Asi̱j sini ni̱ nun gatā nuguanꞌ nan gunun ni é re̱ꞌ xiꞌí si gachē nga̱ ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Sani̱ yya̱j ni̱ nanꞌānj rian si gaꞌníj gaꞌnāj. Ni̱ ni̱ a̱ ꞌngo̱ ni é re̱ꞌ nitaj si nachínj snanꞌanj ni̱ a̱ ga̱nꞌān mánj. ");
INSERT INTO trq_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Sani̱ nani ruhua á re̱ꞌ xiꞌí nuguanꞌ gatā gunun a ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Sani̱ ataj xa̱ngāj rian án re̱ꞌ: Sa̱ꞌ huin rian ni é re̱ꞌ xiꞌí si ga̱nꞌān. Ni̱ sisi̱ si̱ ganꞌān ni̱ si̱ gaꞌna̱ꞌ Espíritu Santo rian án re̱ꞌ mánj. Sani̱ sisi̱ ga̱nꞌān ni̱ ga̱ꞌnī ga̱ꞌnaꞌ síꞌ rian án re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ni̱ ngaa ga̱ꞌnaꞌ síꞌ, ni̱ xa̱caj ni ngüi̱ ma̱n chruhua xungüi̱ cuenta sisi̱ daꞌui ni sij gaquinꞌ, gui̱ꞌyaj síꞌ. Ni̱ xa̱caj ni sij cuenta sisi̱ achin xa̱caj ni sij chrej ni̱ca ga̱che ni sij. Ni̱ xa̱caj ni sij cuenta sisi̱ gui̱ꞌyaj Yanꞌanj castigo ni sij. Daj gui̱ꞌyaj Espíritu Santo ngaa ga̱ꞌnaꞌ síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ni̱ xa̱caj cuenta ni ngüi̱ da̱j hua si-ga̱quinꞌ ni sij xiꞌí si nun xu̱man ruhua ni sij ni̱ꞌyaj ni sij manꞌānj, gui̱ꞌyaj Espíritu Santo. ");
INSERT INTO trq_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ni̱ xa̱caj cuenta ni ngüi̱ da̱j hua ꞌngo̱ chrej ni̱ca xiꞌí si ga̱nꞌān rian nne chrē, gui̱ꞌyaj Espíritu Santo nej. Ni̱ si̱ guiniꞌi ni é re̱ꞌ manꞌānj ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ni̱ xiꞌí si hua gahuin castigo sichre, guiꞌyaj Yanꞌanj, ni̱ xa̱caj cuenta ni ngüi̱ da̱j ga̱huin castigo ni sij, gui̱ꞌyaj Espíritu Santo. Daj si hué sichre huin si aꞌninꞌ chruhua xungüi̱ nan. ");
INSERT INTO trq_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Hua nico doj nuguanꞌ huin ruhuāj ga̱tā gu̱nun a ni é re̱ꞌ, sani̱ si̱ gunucuaj á re̱ꞌ gu̱nun a ni é re̱ꞌ nuguanꞌ daj acuanꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Sani̱ ngaa ga̱ꞌnaꞌ Espíritu Santo, ni̱ di̱gyan-ánꞌ daranꞌ nuguanꞌ xa̱ngaꞌ rian ni é re̱ꞌ. Daj si urin nuguanꞌ xa̱ngaꞌ aꞌmi-íꞌ. Ni̱ si̱ gaꞌmi Espíritu Santo güenda manꞌan síꞌ. Sani̱ ga̱ꞌmi síꞌ daranꞌ nuguanꞌ ga̱taj Yanꞌanj gu̱nun síꞌ. Ni̱ di̱gyán síꞌ da̱j ga̱huin ni güi ga̱ꞌnaꞌ gui̱niꞌi ni é re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ni̱ ga̱ꞌmi sa̱ꞌ Espíritu Santo xiꞌīj. Ni̱ xiꞌí si nicaj síꞌ si-nu̱guanꞌānj, ni̱ di̱gyán síꞌ nuguanꞌ daj rian án re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nicaj manꞌānj daranꞌ si-ꞌyaj chrē. Ni̱ xiꞌí daj gatā gunun a ni é re̱ꞌ sisi̱ gui̱nicaj Espíritu Santo siꞌyā di̱gyán síꞌ rian a ni é re̱ꞌ. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús: ―Ga̱chin do̱j ni̱ si̱ guiniꞌi a ni é re̱ꞌ manꞌānj mánj. Sani̱ ngaa ga̱chin do̱j ru̱huaꞌ yún, ni̱ gui̱niꞌi ru̱huaꞌ yún ni é re̱ꞌ manꞌānj. Daj si na̱nꞌānj rian chrē. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yuꞌuj daj ni̱ nachínj snanꞌanj go̱ꞌngo ni tsínj nicoꞌ Jesús ni dugüiꞌ ni sij. Ni̱ gataj ni sij: ―Ni̱ u̱n sin huin ruhuaj gata nuguanꞌ aꞌmi sij rian néꞌ únj. Ataj sij: “Ga̱chin do̱j, ni̱ si̱ guiniꞌi néꞌ sij. Ni̱ ngaa ga̱chin do̱j ru̱huaꞌ yún, ni̱ gui̱niꞌi ru̱huaꞌ yún néꞌ sij xiꞌí si na̱nꞌ sij rian chrej sij”, ataj sij. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ngaa ni nachínj snanꞌanj ru̱huaꞌ yún ni sij ni dugüiꞌ ni sij: ―Ni̱ u̱n sin huin ruhuaj gata nuguanꞌ: “Ga̱chin do̱j”, únj. Naꞌue gu̱nun néꞌ si ataj sij mánj. ―Daj gataj ni tsínj nicoꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ni̱ guiniꞌi Jesús sisi̱ huin ruhua ni sij na̱chinj snanꞌanj ni sij síꞌ. Yuꞌuj daj gataj Jesús: ―Hua gatā gunun a ni é re̱ꞌ sisi̱ ga̱chin do̱j, ni̱ si̱ guiniꞌi ni é re̱ꞌ manꞌānj. Sani̱ ngaa ga̱chin do̱j ru̱huaꞌ yún, ni̱ gui̱niꞌi ru̱huaꞌ yún ni é re̱ꞌ manꞌānj níꞌ. ");
INSERT INTO trq_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ ga̱co ni é re̱ꞌ. Ni̱ ducu ga̱nani ruhua ni é re̱ꞌ nej. Sani̱ ga̱huin nia̱ꞌ ruhua ni ngüi̱ ma̱n chruhua xungüi̱ gaquinꞌ nan. Ni̱ nu̱nj si ducu ga̱nani ruhua á re̱ꞌ, sani̱ na̱huin nia̱ꞌ ru̱huaꞌ yún ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ngaa achin do̱j ga̱ꞌnga daꞌníj ꞌngo̱ yunꞌunj xa̱na, ni̱ ducu aꞌninꞌ riqui unj. Sani̱ ngaa guisíj gaꞌnga daꞌníj unj, ni̱ guiniꞌyun ruhua unj sayun guiranꞌ unj. Daj si huin nia̱ꞌ ruhua unj sisi̱ gaꞌnga ꞌngo̱ tsinꞌ chruhua xungüi̱, guiꞌyaj unj. ");
INSERT INTO trq_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ni̱ hué ducuánj daj nani ruhua ni é re̱ꞌ acuanꞌ. Sani̱ ga̱ꞌnaꞌ yūnj gui̱niꞌīnj ni é re̱ꞌ. Ngaa ni̱ ga̱huin nia̱ꞌ ruhua niman ni é re̱ꞌ. Ni̱ nitaj ꞌngo̱ tsínj ga̱ꞌne si huin nia̱ꞌ ruhua ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ni̱ güi daj ni̱ nitaj si huaj si na̱chinj snanꞌanj ni é re̱ꞌ manꞌānj ga̱ mánj. Xa̱ngaꞌ atā gu̱nun a ni é re̱ꞌ sisi̱ ri̱qui chrē rian án re̱ꞌ daranꞌ si ga̱chinj jniꞌyaj ni é re̱ꞌ nuguanꞌ rian Yanꞌanj nga̱ si-xugüīj. Ga̱chinj jniꞌyaj á re̱ꞌ, ni̱ gui̱riꞌ ni é re̱ꞌ. Ngaa ni̱ ga̱huin nia̱ꞌ xa̱ngaꞌ ruhua á re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Da acuanꞌ ni̱ nitaj si gachínj jniꞌyaj ni é re̱ꞌ nuguanꞌ rian Yanꞌanj nga̱ si-xugüīj. Ga̱chinj jniꞌyaj ni é re̱ꞌ, ni̱ gui̱riꞌ ni é re̱ꞌ. Ngaa ni̱ ga̱huin nia̱ꞌ xa̱ngaꞌ ruhua á re̱ꞌ aj. ―Gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús: ―Acuanꞌ ni̱ aꞌmi ru̱cūj gunun a ni é re̱ꞌ xiꞌí ni nuguanꞌ nan. Sani̱ ga̱ꞌnaꞌ ꞌngo̱ güi ngaa si̱ gaꞌmi rucūj gu̱nun a ni é re̱ꞌ mánj. Sani̱ ga̱ꞌmi ni̱ca yyāj xiꞌí chrē gu̱nun a ni é re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ni̱ güi daj ni̱ ga̱chinj jniꞌyaj á re̱ꞌ nuguanꞌ rian Yanꞌanj nga̱ si-xugüīj. Ni̱ nitaj si huaj sisi̱ ga̱chinj jniꞌyā rian chrē xiꞌí ni é re̱ꞌ mánj. ");
INSERT INTO trq_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Daj si ꞌi̱ ruhua manꞌan chrē niꞌya ni é re̱ꞌ xiꞌí si ꞌi̱ ruhua ni é re̱ꞌ niꞌyaj ni é re̱ꞌ manꞌānj. Ni̱ xuman ruhua ni é re̱ꞌ sisi̱ ꞌnāj rian Yanꞌanj anj. ");
INSERT INTO trq_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Gahuī rian chrē sisi̱ ga̱ꞌnāj chruhua xungüi̱ nan. Ngaa ni̱ ga̱huī ru̱huaꞌ yūnj chruhua xungüi̱ nan na̱nꞌānj rian chrē. ―Daj gataj Jesús gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ngaa ni̱ gataj ni tsínj nicoꞌ Jesús: ―Yya̱j ni̱ aꞌmi ni̱ca manꞌán re̱ꞌ rian únj. Ni̱ nitaj si aꞌmi ru̱cu re̱ꞌ rian únj mánj. ");
INSERT INTO trq_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Yya̱j ni̱ niꞌi ni únj sisi̱ niꞌí re̱ꞌ daranꞌ nuguanꞌ. Ni̱ nitaj si ruhuaj sisi̱ na̱chinꞌ snanꞌanj ni ngüi̱ manꞌán re̱ꞌ. Daj si hua niꞌí re̱ꞌ da̱j ani ruhua ni sij. Xiꞌí daj ni̱ xuman ruhua ni únj sisi̱ ꞌna̱ꞌ re̱ꞌ rian Yanꞌanj anj. ―Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ngaa ni̱ gataj Jesús: ―Xuman ruhua ni é re̱ꞌ yya̱j níꞌ. ");
INSERT INTO trq_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Hua ꞌna̱ꞌ gui̱sij güi. Ni̱ hué hua guisíj güi daj. Ni̱ ga̱xaꞌni daranꞌ ni é re̱ꞌ. Ni̱ ni̱ni yuꞌuj gu̱nánj go̱ꞌngo ni é re̱ꞌ ga̱nꞌanj án re̱ꞌ. Ni̱ du̱naj á re̱ꞌ urīnj. Sani̱ sé si gu̱naj urīnj mánj. Daj si niquinꞌ chrē ngāj aj. ");
INSERT INTO trq_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ni̱ nuguanꞌ nan gaꞌmī rian án re̱ꞌ sisi̱ ga̱huin dinꞌinj ruhua á re̱ꞌ xiꞌí si nicaj dugüiꞌ ni é re̱ꞌ ngāj. Ni̱ gui̱ranꞌ ni é re̱ꞌ sayun chruhua xungüi̱ gaquinꞌ nan. Sani̱ ga̱huin yya ruhua á re̱ꞌ si hua guiꞌyaj ganāj rian xungüi̱ gaquinꞌ nan anj. ―Daj gataj Jesús gunun ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ngaa guisíj gaꞌmi Jesús nuguanꞌ daj, ni̱ niꞌyaj sij xataꞌ. Ni̱ gataj sij: ―Tata chréꞌ, yya̱j guisíj hora daj. Ngaa ni̱ na̱huin ꞌuēj, gui̱ꞌyáj re̱ꞌ huīnj daꞌníj re̱ꞌ. Hué dan ni̱ ga̱ꞌmi sa̱ꞌ ni ngüi̱ xiꞌí re̱ꞌ, gui̱ꞌyā. ");
INSERT INTO trq_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Hué re̱ꞌ riqui sisi̱ gui̱nicaj sūnj rian daranꞌ ni ngüi̱ xiꞌí si huin ruhuá re̱ꞌ si ga̱ ni̱ꞌnaꞌ ni̱ganj daranꞌ ni ngüi̱ riquí re̱ꞌ riānj. ");
INSERT INTO trq_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Tsínj ga̱ ni̱ꞌnaꞌ ni̱ganj huin tsínj niꞌi manꞌán re̱ꞌ nga̱ manꞌānj. Ni̱ urín re̱ꞌ huin Yanꞌanj xa̱ngaꞌ. Ni̱ yūnj huin Jesucristo tsínj gaꞌníj re̱ꞌ gaꞌnāj chruhua xungüi̱ nan. ");
INSERT INTO trq_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ni̱ gaꞌmi sa̱ꞌ ni ngüi̱ ma̱n chruhua xungüi̱ nan xiꞌí re̱ꞌ xiꞌí si ganahuij guiꞌyaj sūnj si riquí re̱ꞌ riānj. ");
INSERT INTO trq_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tata chréꞌ, yya̱j ni̱ ri̱qui re̱ꞌ si na̱huin ꞌuēj rián re̱ꞌ da̱j rúnꞌ gahuīnj nga̱ re̱ꞌ asi̱j ngaa achin gahuin xungüi̱ nan. ");
INSERT INTO trq_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ni̱ hua digyānj rian ni tsínj ganacuí re̱ꞌ scanij ni ngüi̱ sisi̱ da̱j hua manꞌán re̱ꞌ. Ni̱ gahuin ni sij nga̱ manꞌán re̱ꞌ. Ni̱ riquí re̱ꞌ ni sij riānj. Ni̱ dagahuin sa̱ꞌ ni sij si-nu̱guanꞌ re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Yya̱j ni̱ niꞌi ni sij sisi̱ daranꞌ si riquí re̱ꞌ riānj ꞌna̱ꞌ rian manꞌán re̱ꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Daj si ni nuguanꞌ riquí re̱ꞌ riānj, ni̱ digyānj rian ni sij. Ni̱ garáj xina̱ ni sij. Ni̱ xacaj cuenta ni sij sisi̱ ꞌna̱ꞌ yyāj rián re̱ꞌ. Ni̱ guxuman ruhua ni sij sisi̱ gaꞌníj re̱ꞌ gaꞌnāj chruhua xungüi̱. ");
INSERT INTO trq_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Ni̱ achínj jniꞌyā rián re̱ꞌ xiꞌí ni sij. Nitaj si achínj jniꞌyā rián re̱ꞌ xiꞌí ni ngüi̱ ma̱n chruhua xungüi̱ gaquinꞌ nan mánj. Sani̱ achínj jniꞌyā rián re̱ꞌ xiꞌí ni tsínj riquí re̱ꞌ riānj. Daj si huin ni sij nga̱ re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Daranꞌ ni tsínj huin ngāj huin nga̱ re̱ꞌ nej. Ni̱ daranꞌ ni tsínj huin nga̱ re̱ꞌ, ni̱ hué ni sij huin ngāj nej. Ni̱ aꞌmi sa̱ꞌ ni ngüi̱ xiꞌīj, ꞌyaj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Yya̱j ni̱ si̱ ganēj chruhua xungüi̱ nan ga̱ mánj. Sani̱ gu̱na ni sij chruhua xungüi̱. Ni̱ nu̱cuīj rian nné re̱ꞌ ga̱nēj. Tata chréꞌ sa̱ꞌ ni̱nꞌ huín re̱ꞌ. Ngaa ni̱ du̱gumi sa̱ꞌ re̱ꞌ ni tsínj riquí re̱ꞌ riānj nga̱ si-fuerza manꞌán re̱ꞌ. Ni̱ hué daj du̱gumi re̱ꞌ ni sij sisi̱ uyan ga̱huin ni sij da̱j rúnꞌ huín re̱ꞌ nga̱ manꞌānj. ");
INSERT INTO trq_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ngaa ganēj nga̱ ni sij chruhua xungüi̱ nan, ni̱ dugumī ni sij nga̱ si-fuerza manꞌán re̱ꞌ. Ni̱ dugumī ni tsínj riquí re̱ꞌ riānj. Ni̱ a̱ ꞌngo̱ ni sij nun ga niꞌya mánj. Maan si ga niꞌya urin tsínj xi̱ꞌi daj sisi̱ ga̱huin yya da̱j rúnꞌ atáj re̱ꞌ rian si-nu̱guanꞌ re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Yya̱j ni̱ na̱cuīj rian nné re̱ꞌ. Sani̱ aꞌmī ni nuguanꞌ nan ngaa nnēj chruhua xungüi̱ sisi̱ ni̱nꞌ ruhua ga̱huin nia̱ꞌ ruhua ni sij da̱j rúnꞌ huin nia̱ꞌ ruhuāj. ");
INSERT INTO trq_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ni̱ hua digyānj si-nu̱guanꞌ re̱ꞌ rian ni sij. Sani̱ nun huin xa̱nꞌ ruhua ni tsínj ma̱n chruhua xungüi̱ niꞌyaj ni síꞌ ni sij. Daj si sé ni tsínj ma̱n chruhua xungüi̱ nan huin ni sij. Ni̱ sé daj huin manꞌānj nej. ");
INSERT INTO trq_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","’Sé si achínj jniꞌyā rián re̱ꞌ sisi̱ gui̱ri re̱ꞌ ni sij chruhua xungüi̱ nan mánj. Maan si huin ruhuāj si du̱gumi re̱ꞌ ni sij rian ni nuguanꞌ xi̱ꞌi. ");
INSERT INTO trq_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nitaj si huin ni sij nga̱ ni tsínj ma̱n chruhua xungüi̱ gaquinꞌ nan. Ni̱ daꞌngaꞌ daj nitaj si huīnj nga̱ ni tsínj ma̱n chruhua xungüi̱ nan mánj. ");
INSERT INTO trq_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gui̱ꞌyaj ni̱ni re̱ꞌ ni sij sisi̱ ga̱huin sa̱ꞌ ni sij nga̱ si-nu̱guanꞌ re̱ꞌ huin nuguanꞌ xa̱ngaꞌ. ");
INSERT INTO trq_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ni̱ da̱j rúnꞌ gaꞌníj re̱ꞌ gaꞌnāj scanij ni ngüi̱ ma̱n chruhua xungüi̱, ni̱ daꞌngaꞌ daj aꞌnī ni sij ga̱nꞌanj ni sij scanij ni ngüi̱ da nej. ");
INSERT INTO trq_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ni̱ ga̱huin ni̱ni manꞌānj gui̱ꞌyaj sūnj si-sún re̱ꞌ xiꞌí ni sij sisi̱ ga̱huin ni̱ni ni sij rian gaquinꞌ, gui̱ꞌyaj nuguanꞌ xa̱ngaꞌ. ");
INSERT INTO trq_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Ni̱ sé si achínj jniꞌyā rián re̱ꞌ xiꞌí urin ni sij. Sani̱ achínj jniꞌyā rián re̱ꞌ xiꞌí ni ngüi̱ gu̱xuman ruhua ni̱ꞌyaj manꞌānj xiꞌí nuguanꞌ na̱taꞌ ni sij gunun ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tata chréꞌ, achínj jniꞌyā rián re̱ꞌ sisi̱ uyan gui̱nicaj dugüiꞌ ni̱nꞌ daranꞌ ni sij. Ni̱ huin ruhuāj sisi̱ ga̱huin ni sij nga̱ nu̱ngüeꞌ da̱j rúnꞌ huin urīnj nga̱ re̱ꞌ, ni̱ da̱j rúnꞌ huin urín re̱ꞌ ngāj. Ni̱ ꞌngo̱ gui̱nicaj dugüiꞌ ni sij sisi̱ gu̱xuman ruhua ni tsínj ma̱n chruhua xungüi̱ sisi̱ gaꞌníj re̱ꞌ gaꞌnāj. ");
INSERT INTO trq_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ni̱ da̱j rúnꞌ gahuin sa̱ꞌ ꞌuēj, guiꞌyáj re̱ꞌ, ni̱ hué daj gahuin sa̱ꞌ ꞌueé ni sij guiꞌyā xiꞌí si uyan ga̱huin ni sij da̱j rúnꞌ hua nu̱ngüeꞌ. ");
INSERT INTO trq_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ni̱ da̱j rúnꞌ nné re̱ꞌ nimānj, ni̱ daꞌngaꞌ daj ga̱nēj niman ni sij, ruhuāj aj. Ngaa ni̱ gui̱sij ni sij ga̱huin urin ni sij. Ngaa ni̱ xa̱caj cuenta ni tsínj ma̱n chruhua xungüi̱ sisi̱ gaꞌníj re̱ꞌ gaꞌnāj. Ni̱ xa̱caj cuenta ni síꞌ sisi̱ ꞌi̱ ruhuá re̱ꞌ niꞌyáj re̱ꞌ ni tsínj riquí re̱ꞌ riānj, da̱j rúnꞌ ꞌi̱ ruhuá re̱ꞌ niꞌyáj re̱ꞌ manꞌānj. ");
INSERT INTO trq_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Tata chréꞌ, huin ruhuāj sisi̱ ga̱ne ni tsínj riquí re̱ꞌ riānj ngāj rian ga̱nēj. Ngaa ni̱ gui̱niꞌi ni sij da̱j hua sa̱ꞌ manꞌānj, guiꞌyáj re̱ꞌ. Daj si hua ꞌi̱ ruhuá re̱ꞌ niꞌyáj re̱ꞌ manꞌānj asi̱j achin guiꞌyáj re̱ꞌ xungüi̱ nan. ");
INSERT INTO trq_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ni̱ca yya ꞌyáj re̱ꞌ huín re̱ꞌ chrē. Ni̱ nun niꞌi ni ngüi̱ ma̱n chruhua xungüi̱ gaquinꞌ nan manꞌán re̱ꞌ. Sani̱ niꞌīnj manꞌán re̱ꞌ. Ni̱ niꞌi ni tsínj nan sisi̱ hué re̱ꞌ gaꞌníj gaꞌnāj. ");
INSERT INTO trq_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ni̱ digyānj rian ni sij da̱j hua manꞌán re̱ꞌ. Ni̱ daꞌngaꞌ daj di̱gyānj doj rian ni sij. Ngaa ni̱ da̱j rúnꞌ ꞌi̱ ruhuá re̱ꞌ niꞌyáj re̱ꞌ manꞌānj, ni̱ hué daj ga̱ ꞌi̱ ruhua ni sij gui̱niꞌi ni sij ni dugüiꞌ ni sij, gui̱ꞌyáj re̱ꞌ. Ni̱ ga̱ne manꞌānj niman ni sij, ruhuāj aj. ―Daj gataj Jesús gunun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ngaa ni̱ guisíj gaꞌmi Jesús ni nuguanꞌ daj, ni̱ gahui sij nga̱ ni tsínj nicoꞌ sij ganꞌanj ni sij anéj chrej xinéj gu̱ꞌnaj Cedrón rian ma̱n ꞌngo̱ nnaa̱ chrun. Ni̱ gatúj sij nga̱ ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ni̱ tsínj gu̱ꞌnaj Judas, huin tsínj nagaꞌuiꞌ Jesús rian ni tsínj nicaj sun, ni̱ guiniꞌi síꞌ yuꞌuj daj. Daj si síj gaꞌi̱ huanꞌanj Jesús yuꞌuj daj nahuin chreꞌ sij nga̱ ni tsínj nicoꞌ sij. ");
INSERT INTO trq_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ngaa ni̱ nicaj Judas ꞌngo̱ xiꞌninꞌ snado nga̱ go̱ꞌngo policía dugumi nuhui gaꞌna̱ꞌ ni síꞌ rian nne Jesús. Ni̱ gaꞌníj ni chrej aꞌninꞌ nga̱ ni tsínj fariseo ga̱ꞌnaꞌ ni síꞌ. Ni̱ nicaj ni síꞌ espada nga̱ candil nej, caꞌ nej, gaꞌna̱ꞌ ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Sani̱ ri̱an hua niꞌi Jesús daranꞌ si gui̱ranꞌ sij, ni̱ gahui sij nachínj snanꞌanj sij ni síꞌ. Ni̱ gataj sij: ―Ni̱ u̱n tsínj nanoꞌ a ni é re̱ꞌ únj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ngaa ni̱: ―Jesús nazareno nanoꞌ ni únj. ―Gataj ni síꞌ. Ngaa ni̱ gataj Jesús: ―Huēj huin Jesús. ―Gataj Jesús. Ni̱ niquinꞌ Judas nga̱ ni síꞌ yuꞌuj daj. Ni̱ huin sij tsínj nagaꞌuiꞌ Jesús rian ni tsínj nicaj sun. ");
INSERT INTO trq_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ni̱ ngaa gataj Jesús sisi̱ hué sij huin tsínj nanoꞌ ni síꞌ, ni̱ guxun ru̱cu ni síꞌ ni manꞌan ni síꞌ. Ni̱ ganatúj ni síꞌ rian yoꞌój. ");
INSERT INTO trq_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ngaa ni̱ nachínj snanꞌanj ru̱huaꞌ yún Jesús ni síꞌ. Ni̱ gataj sij: ―Ni̱ u̱n tsínj nanoꞌ a ni é re̱ꞌ únj. ―Gataj Jesús. Ngaa ni: ―Jesús nazareno nanoꞌ ni únj. ―Gataj ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ngaa ni̱ gataj Jesús: ―Hua gatā gunun a ni é re̱ꞌ sisi̱ huēj huin tsínj daj. Ni̱ sisi̱ nanoꞌ ni é re̱ꞌ manꞌānj, ngaa ni̱ du̱na á re̱ꞌ sisi̱ ga̱nꞌanj ni tsínj nan. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ni̱ daꞌngaꞌ daj gaꞌmi Jesús sisi̱ ga̱huin yya da̱j rúnꞌ hua gaꞌmi sij rian Yanꞌanj: “Nun ga̱ niꞌya ni̱ a̱ ꞌngo̱ ni tsínj riquí re̱ꞌ riānj.” Daj gaꞌmi Jesús gunun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ni̱ nicaj Simón Pedro ꞌngo̱ espada. Ni̱ gaꞌninꞌ sij tsínj ꞌyaj sun rian chrej aꞌninꞌ. Ni̱ güéj ni̱nꞌ chraquij síꞌ, guiꞌyaj sij huin síꞌ ꞌngo̱ tsínj gu̱ꞌnaj Malco. ");
INSERT INTO trq_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ngaa ni̱ gataj Jesús gunun Pedro: ―Na̱ꞌnij re̱ꞌ si-espadá re̱ꞌ chruhua pena. Sisi̱ riqui chrē si gui̱ranꞌānj sayun nan, ni̱ hua nia̱n sisi̱ hué daj gui̱ranꞌānj. ―Daj gataj Jesús gunun Pedro. ");
INSERT INTO trq_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ngaa ni̱ guidaꞌa ni snado nej, tsínj aꞌninꞌ rian ni snado nej, ni policía niquinꞌ rian ni tsínj israelita manꞌan Jesús. Ni̱ numíj ni sij síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ni̱ asi̱j sini nicaj ni sij Jesús ganꞌanj ni sij ducuá tsínj gu̱ꞌnaj Anás. Daj si huin síꞌ chre che̱j Caifás. Ni̱ Caifás huin chrej aꞌninꞌ yoꞌ daj. ");
INSERT INTO trq_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ni̱ hué Caifás daj huin tsínj gataj snanꞌanj rian ni tsínj israelita sisi̱ sa̱ꞌ huin si ga̱huiꞌ urin tsínj daj xiꞌí daranꞌ ni ngüi̱ israelita. ");
INSERT INTO trq_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ngaa ni̱ nicoꞌ Simón Pedro nga̱ ango tsínj nicoꞌ Jesús huaj nu̱ngüej sij nga̱ Jesús. Ni̱ hua niꞌi chrej aꞌninꞌ ango tsínj nicoꞌ Jesús daj. Xiꞌí daj ni̱ gatúj síꞌ rian hua ta rian hueꞌ daj nga̱ Jesús. ");
INSERT INTO trq_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Sani̱ gunáj Pedro ne̱ꞌ chrej xe̱ꞌ niquinꞌ sij rian hueꞌ. Ngaa ni̱ gahui ango tsínj nicoꞌ Jesús daj tsínj niꞌi chrej aꞌninꞌ ganꞌanj ga̱ꞌmi sij nga̱ yunꞌunj dugumi rian hueꞌ. Ni̱ gatúj Pedro, guiꞌyaj síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ngaa ni̱ nachínj snanꞌanj yunꞌunj dugumi rian hueꞌ daj Pedro. Ni̱ gataj únꞌ: ―Sé re̱ꞌ huin ꞌngo̱ tsínj nicoꞌ tsínj da a̱ꞌ. ―Daj gataj únꞌ gunun Pedro. Ngaa ni̱: ―Sēj huin mánj. ―Gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ni̱ niquinꞌ ni tsínj ꞌyaj sun nga̱ ni policía dugumi nuhui ne̱ꞌ naranꞌ ni sij yanꞌa̱n. Daj si nuhuij. Ni̱ ma̱n ni sij nahuin gui̱n ni sij xiꞌníj yanꞌa̱n daj. Ni̱ niquinꞌ Pedro nga̱ ni sij nahuin gui̱n síꞌ nga̱ ni sij nej. ");
INSERT INTO trq_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ngaa ni̱ gaxi̱ꞌi chrej aꞌninꞌ daj nachínj snanꞌanj síꞌ Jesús xiꞌí ni tsínj nicoꞌ sij nga̱ xiꞌí nuguanꞌ digyán sij rian ni ngüi̱ nej. ");
INSERT INTO trq_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ngaa ni̱ gataj Jesús: ―Gaꞌmi rengāj rian daranꞌ ni ngüi̱. Ni̱ ni̱ganj digyānj rian ni ngüi̱ chruhua si-nuhui ni é re̱ꞌ nga̱ chruhua nuhui nico rian naranꞌ ni tsínj israelita nej. Ni̱ nitaj si garij huīj nuguanꞌ gaꞌmī mánj. ");
INSERT INTO trq_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ni̱ u̱n sin huin ni̱ nachínj snanꞌánj re̱ꞌ yūnj únj. Na̱chinꞌ snanꞌánj re̱ꞌ ni ngüi̱ gunun si-nu̱guanꞌānj. Hué ni sij niꞌi yya u̱n nuguanꞌ gaꞌmī rian ni sij. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ni̱ ngaa gataj Jesús daj, ni̱ raꞌui raꞌa ꞌngo̱ policía dugumi nuhui rian Jesús. Ni̱ gataj síꞌ: ―Ni̱ hué daj ga̱ꞌmi re̱ꞌ rian chrej aꞌninꞌ níꞌ. ―Gataj síꞌ gaꞌmi huee síꞌ rian Jesús. ");
INSERT INTO trq_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ngaa ni̱: ―Sisi̱ gaꞌmī ꞌngo̱ nuguanꞌ quij, ni̱ ga̱taj re̱ꞌ u̱n nuguanꞌ quij huin gaꞌmī aj. Sani̱ sisi̱ gaꞌmī nuguanꞌ sa̱ꞌ, ni̱ u̱n sin huin ni̱ raꞌui raꞌá re̱ꞌ riānj únj. ―Daj gataj Jesús gunun tsínj daj. ");
INSERT INTO trq_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ni̱ anumi Jesús gaꞌníj Anás ga̱nꞌanj síꞌ rian Caifás huin síꞌ chrej aꞌninꞌ. ");
INSERT INTO trq_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ni̱ niquinꞌ Pedro nahuin gui̱n síꞌ scanij ni sij xiꞌníj yanꞌa̱n. Ngaa ni̱ gataj ni sij gunun Pedro: ―Sé re̱ꞌ huin ꞌngo̱ tsínj nicoꞌ tsínj da a̱ꞌ. ―Gataj ni sij. Ngaa ni̱: ―Sēj huin mánj. ―Gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ngaa ni̱ nachínj snanꞌanj ꞌngo̱ tsínj ꞌyaj sun rian chrej huin achij ni̱nꞌ Pedro. Ni̱ huin síꞌ dugüiꞌ tsínj gaꞌninꞌ Pedro chraquij. Ni̱ gataj síꞌ: ―Sé re̱ꞌ huin si guiniꞌīnj nga̱ Jesús riqui ni chrun da nej a̱ꞌ. ―Daj gataj síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ni: ―Sēj huin mánj. ―Gataj ru̱huaꞌ yún Pedro. Ni̱ ꞌngo̱ hora gaguáj doꞌloj duꞌua xúꞌ. ");
INSERT INTO trq_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ngaa ni̱ nicaj ni sij Jesús gahui ni sij ducuá Caifás. Ni̱ ganꞌanj ni sij ducuasun. Ni̱ ni̱ganꞌ acuanꞌ huin ni̱ nun ga̱ꞌue ga̱tu ni tsínj israelita chruhua ducuasun. Daj si nitaj chrej riqui si-ley ni sij sisi̱ ga̱tu ni sij güi huin guiꞌyanj. Ni̱ sisi̱ hué daj gui̱ꞌyaj ni sij, ni̱ si̱ gaꞌue xa̱ stiꞌni̱ ni sij guiꞌyanj pascua xiꞌí si ga̱huin xi̱ꞌi ni sij rian Yanꞌanj, gui̱ꞌyaj ducuasun daj, ataj si-ley ni sij. ");
INSERT INTO trq_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yuꞌuj daj ni̱ gahui Pilato gaꞌmi síꞌ nga̱ ni tsínj daj. Ni̱ gataj síꞌ: ―Ni̱ u̱n gaquinꞌ daꞌui tsínj nan, ni̱ aꞌmi gaquinꞌ ni é re̱ꞌ xiꞌí sij únj. ―Daj gataj Pilato. ");
INSERT INTO trq_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ngaa ni̱: ―Sisi̱ nitaj gaquinꞌ daꞌui sij, ni̱ si̱ nariqui ni únj rián re̱ꞌ mánj. ―Daj gataj ni tsínj israelita. ");
INSERT INTO trq_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ngaa ni̱ gataj Pilato: ―Ni̱caj ni é re̱ꞌ sij ga̱nꞌanj ni é re̱ꞌ. Ni̱ na̱guiꞌyaj yya ni é re̱ꞌ nga̱ sij da̱j rúnꞌ ataj si-ley ni é re̱ꞌ aj. ―Gataj Pilato. Ngaa ni̱ gataj ni sij: ―Sani̱ ni únj ni tsínj israelita, ni̱ nitaj chrej hua sisi̱ da̱gahuiꞌ ni únj a̱ ꞌngo̱ ni ngüi̱ mánj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ni̱ hué daj gataj ni sij sisi̱ ga̱huin yya da̱j rúnꞌ gataj Jesús sisi̱ da̱j ga̱huiꞌ sij. ");
INSERT INTO trq_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ngaa ni̱ natúj ru̱huaꞌ yún Pilato chruhua ducuasun. Ngaa ni̱ gaquínj sij ga̱ꞌnaꞌ Jesús. Ni̱ nachínj snanꞌanj sij síꞌ. Ni̱: ―Hué re̱ꞌ huin rey rian ni ngüi̱ israelita níꞌ. ―Daj gataj Pilato. ");
INSERT INTO trq_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ngaa ni̱ gataj Jesús: ―Ni̱ hué daj atáj re̱ꞌ güenda manꞌán re̱ꞌ níꞌ. Asi̱ hua ango tsínj nataꞌ rián re̱ꞌ xiꞌīj sa̱ꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ngaa ni̱ gataj Pilato: ―Asi̱ huēj huin ꞌngo̱ tsínj israelita, ruhuá re̱ꞌ níꞌ. Ni̱ dugüiꞌ manꞌán re̱ꞌ nga̱ ni chrej aꞌninꞌ hué ni sij nariqui manꞌán re̱ꞌ riānj. Ni̱ u̱n gaquinꞌ daꞌuí re̱ꞌ únj. ―Daj gataj Pilato. ");
INSERT INTO trq_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ngaa ni̱ gataj Jesús: ―Sé rian xungüi̱ gaquinꞌ nan huin rian nicaj sūnj mánj. Sisi̱ hué daj huin ni̱ gu̱nunꞌ ni tsínj nicoꞌ manꞌānj xiꞌīj. Ngaa ni̱ si̱ nagaꞌuiꞌ ni sij manꞌānj rian ni tsínj israelita mánj. Sani̱ sé rian xungüi̱ gaquinꞌ nan huin rian nicaj sūnj mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ngaa ni̱: ―Hué re̱ꞌ huin ꞌngo̱ rey níꞌ. ―Gataj Pilato. Ni̱: ―Hué manꞌán re̱ꞌ ataj sisi̱ huīnj ꞌngo̱ rey aj. Xiꞌí nan gaꞌngā chruhua xungüi̱. Ni̱ xiꞌí nan gaꞌnāj sisi̱ ga̱ꞌmī nuguanꞌ xa̱ngaꞌ gu̱nun ni ngüi̱. Ni̱ daranꞌ ni ngüi̱ ruhua gu̱nun nuguanꞌ xa̱ngaꞌ, ni̱ unun ni sij nuguanꞌ xa̱ngaꞌ aꞌmī. ―Daj gataj Jesús gunun Pilato. ");
INSERT INTO trq_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ngaa ni̱: ―Ni̱ u̱n sin huin nuguanꞌ xa̱ngaꞌ ruhuá re̱ꞌ únj. ―Gataj Pilato. Ngaa ni̱ gahui ru̱huaꞌ yún sij gaꞌmi sij nga̱ ni tsínj israelita. Ni̱ gataj sij: ―Ni̱ a̱ ꞌngo̱ gaquinꞌ naꞌue na̱riꞌīj xiꞌí tsínj da mánj. ");
INSERT INTO trq_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Sani̱ hué ꞌngo̱ ducuánj ni é re̱ꞌ huin sisi̱ go̱ꞌngo guiꞌyanj pascua, ni̱ gui̱rīj ꞌngo̱ tsínj nu̱n ducuaga̱ꞌ. Ngaa ni̱ huin ruhua ni é re̱ꞌ sisi̱ gui̱rīj tsínj nan tsínj huin si-rey ni tsínj israelita níꞌ. ―Daj gataj Pilato. ");
INSERT INTO trq_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ngaa ni̱ gaguáj ru̱huaꞌ yún ni sij. Ni̱ gataj ni sij: ―Si̱ guirí re̱ꞌ tsínj nan mánj. Sani̱ sa̱ꞌ huin sisi̱ na̱ꞌnij naj raꞌá re̱ꞌ Barrabás ga̱nꞌanj síꞌ. ―Daj gataj ni sij gaguáj ni sij rian Pilato. Ni̱ Barrabás huin ꞌngo̱ tsínj tu̱. ");
INSERT INTO trq_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Hué dan ni̱ gaꞌninꞌ Pilato sun sisi̱ ga̱ꞌuiꞌ ni sij nneꞌ xiráj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ngaa ni̱ runꞌun ni snado ꞌngo̱ yaꞌa̱ tanj, guiꞌyaj ni sij ꞌngo̱ corona gaꞌníj ni sij chra̱ Jesús. Ni̱ gaꞌníj ni sij ꞌngo̱ atsij rian ru̱miꞌ mare xá Jesús gunu̱n síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ngaa ni̱ gataj ni sij gunun Jesús: ―Hua ꞌueé ni̱nꞌ si-rey ni tsínj israelita. ―Daj gaguáj ni sij gaꞌmi ducu ni sij niꞌyaj ni sij Jesús. Ni̱ garaꞌui raꞌa ni sij rian Jesús nej. ");
INSERT INTO trq_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ngaa ni̱ gahui ru̱huaꞌ yún Pilato ne̱ꞌ chrej xe̱ꞌ. Ni̱ gataj sij gunun ni tsínj israelita: ―Ni̱ꞌyaj á re̱ꞌ. Yya̱j ni̱ ni̱cā sij ꞌnāj rian án re̱ꞌ. Ngaa ni̱ ga̱ꞌue xa̱caj á re̱ꞌ cuenta sisi̱ nitaj gaquinꞌ daꞌui sij nariꞌīj mánj. ―Daj gataj Pilato. ");
INSERT INTO trq_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ngaa ni̱ gahui Jesús xe̱ꞌ. Ni̱ nu̱n chra̱ síꞌ corona tanj. Ni̱ nu̱n síꞌ atsij rian ru̱miꞌ mare daj. Ni̱ gataj Pilato: ―Hué tsínj nan niquinꞌ rian án re̱ꞌ aj. ―Gataj Pilato. ");
INSERT INTO trq_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ni̱ ngaa guiniꞌi ni chrej aꞌninꞌ nga̱ ni policía dugumi nuhui, ni̱ gaguáj ni sij. Ni̱: ―Do̱coꞌ re̱ꞌ sij rian rugutsi̱. Do̱coꞌ re̱ꞌ sij rian rugutsi̱ aj. ―Daj gaguáj ni sij. Ngaa ni̱ gataj Pilato: ―Ni̱caj á re̱ꞌ ga̱nꞌanj án re̱ꞌ, ni̱ do̱coꞌ a ni é re̱ꞌ rian rugutsi̱ sij. Güendāj, sani̱ naꞌue na̱riꞌīj u̱n gaquinꞌ daꞌui sij mánj. ―Daj gataj Pilato. ");
INSERT INTO trq_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ngaa ni̱ gataj ni tsínj israelita: ―Nicaj ni únj ꞌngo̱ ley. Ni̱ ataj si-ley ni únj sisi̱ hua nia̱n ga̱huiꞌ sij. Daj si ataj sij sisi̱ huin sij daꞌníj Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ni̱ ngaa gunun Pilato nuguanꞌ daj, ni̱ na̱anj guxuꞌuiꞌ ni̱nꞌ ruhua sij. ");
INSERT INTO trq_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ngaa ni̱ gatúj ru̱huaꞌ yún sij chruhua ducuasun. Ni̱ nachínj snanꞌanj sij Jesús. Ni̱: ―Ni̱ a̱ ꞌna̱ꞌ re̱ꞌ únj. ―Gataj Pilato. Sani̱ a̱ ꞌngo̱ nuguanꞌ nun danica̱j Jesús mánj. ");
INSERT INTO trq_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ngaa ni̱ gataj Pilato: ―Ni̱ si̱ gaꞌmí re̱ꞌ ngāj ga̱ a̱ꞌ. Nun niꞌí re̱ꞌ sisi̱ nicaj sūnj sisi̱ ga̱ꞌue docōj rian rugutsi̱ so̱ꞌ ga̱ a̱ꞌ. Ni̱ ga̱ꞌue ga̱ níꞌnij rián so̱ꞌ, gui̱ꞌyā nej ga̱ a̱ꞌ. ―Daj gataj Pilato. ");
INSERT INTO trq_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ngaa ni̱ gataj Jesús: ―Sisi̱ nun riqui Yanꞌanj sun gui̱nicaj re̱ꞌ, ni̱ si̱ gunucuáj re̱ꞌ gui̱nicaj re̱ꞌ sun riānj mánj. Xiꞌí daj ni̱ tsínj nariqui manꞌānj rián re̱ꞌ, ni̱ daꞌui sij nico gaquinꞌ daj nga̱ manꞌán re̱ꞌ aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ngaa ni̱ asi̱j hora daj, ni̱ nanoꞌ Pilato da̱j gui̱ꞌyaj sij, ni̱ na̱ꞌni raꞌa sij Jesús. Sani̱ gaguáj ni tsínj israelita. Ni̱ gataj ni sij: ―Sisi̱ na̱ꞌnij raꞌá re̱ꞌ tsínj nan, ni̱ nitaj si nicaj dugüíꞌ re̱ꞌ nga̱ rey gu̱ꞌnaj César mánj. Daranꞌ ni tsínj ꞌyaj rey manꞌan, ni̱ ununꞌ ni sij nga̱ César. ―Daj gaguáj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ni̱ ngaa gunun Pilato nuguanꞌ daj, ni̱ guiri sij Jesús xe̱ꞌ. Ni̱ ganꞌanj ga̱ne sij rian mesa rian naguiꞌyaj yya sij ni gaquinꞌ. Ni̱ yuꞌuj daj gu̱ꞌnaj Gabata snanꞌanj hebreo. Ni̱ nuguanꞌ daj huin ruhuaj gata ꞌngo̱ yuꞌuj ngaj yej nia̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ni̱ ruhua gui̱sij ga xu̱huij güi ngaa guiꞌyaj xugüi ni ngüi̱ israelita xiꞌí guiꞌyanj pascua. Ngaa ni̱ gataj Pilato gunun ni tsínj israelita: ―Hué si-rey ni é re̱ꞌ niquinꞌ rian án re̱ꞌ nan. ―Daj gataj Pilato. ");
INSERT INTO trq_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Sani̱ gaguáj ni sij. Ni̱: ―Ni̱caj re̱ꞌ sij ga̱nꞌanj re̱ꞌ do̱coꞌ re̱ꞌ rian rugutsi̱ aj. ―Daj gataj ni sij. Ngaa ni̱ nachínj snanꞌanj Pilato ni sij, ni̱ gataj síꞌ: ―Asi̱ huin ruhua á re̱ꞌ sisi̱ do̱cōj si-rey ni é re̱ꞌ rian rugutsi̱, ruhua á re̱ꞌ níꞌ. ―Daj gataj Pilato. Ngaa ni̱: ―Urin rey gu̱ꞌnaj César huin rian ni únj. Nitaj ango mánj. ―Daj gataj ni chrej aꞌninꞌ gunun Pilato. ");
INSERT INTO trq_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ngaa ni̱ nagaꞌuiꞌ Pilato Jesús raꞌa ni sij sisi̱ ni̱caj ni sij Jesús ga̱nꞌanj do̱coꞌ ni sij síꞌ rian rugutsi̱. Hué dan ni̱ nicaj ni sij Jesús ganꞌanj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ngaa ni̱ gata manꞌan Jesús si-rugutsi̱ sij ganꞌanj sij chra̱ dacan gu̱ꞌnaj chra̱ cúj níman. Ni̱ snanꞌanj hebreo gu̱ꞌnaj Gólgota. ");
INSERT INTO trq_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ni̱ hué yuꞌuj daj gari ni sij gaquíj Jesús doco̱ꞌ ni sij rian rugutsi̱ síꞌ. Ni̱ doco̱ꞌ ni sij yahuij tsínj daj rian yahuij rugutsi̱. Ni̱ nicoꞌ Jesús da̱ni nu̱ngüej síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ngaa ni̱ gaꞌninꞌ Pilato sun sisi̱ ga̱run ni sij ꞌngo̱ ruguechra̱ꞌ chra̱ rugutsi̱ gui̱nun letra. Ni̱ gataj letra daj: “Jesús Nazareno huin síꞌ Rey rian ni ngüi̱ israelita.” Daj gataj letra daj. ");
INSERT INTO trq_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ni̱ nico ni tsínj israelita gaya letra daj si ni̱chrunꞌ duꞌua xumanꞌ Jerusalén huin doco̱ꞌ ni sij Jesús rian rugutsi̱. Ni̱ hua ni̱ca garun Pilato letra daj snanꞌanj hebreo nga̱ snanꞌanj latín nej, snanꞌanj griego nej. ");
INSERT INTO trq_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Xiꞌí daj ni̱ gataj ni chrej aꞌninꞌ rian Pilato: ―Si̱ garún re̱ꞌ sisi̱ si-rey ni ngüi̱ israelita huin sij mánj. Maan si ga̱run re̱ꞌ sisi̱ ataj manꞌan sij sisi̱ hué sij huin si-rey ni ngüi̱ israelita aj. ―Daj gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ni̱: ―Si hua garūnj ni̱ hué daj ga̱j. ―Gataj Pilato gunun ni síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ngaa guisíj doco̱ꞌ ni snado Jesús rian rugutsi̱, ni̱ nacaj ni sij si-ganꞌ Jesús. Ni̱ guraꞌ daꞌaj ni sij ga̱nꞌanj mando si-ganꞌ síꞌ. Ni̱ nacaj go̱ꞌngo ni snado daj daꞌaj atsij go̱ꞌngo sij. Ni̱ nacaj ni sij atsij manta gunun Jesús. Ni̱ sé atsij nanuhua ni sij huin-ínꞌ. Sani̱ atsij anánj ni sij huin. ");
INSERT INTO trq_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Xiꞌí daj ni gataj ni du̱güiꞌ ni snado: ―Sani̱ si̱ gutsiꞌ néꞌ mánj. Sani̱ du̱cu néꞌ sisi̱ da̱j hua néꞌ gui̱ꞌyaj gana na̱caj atsij nan. ―Daj gataj ni sij. Ni̱ hué daj gataj ni sij sisi̱ ga̱huin yya da̱j rúnꞌ gataj si-nu̱guanꞌ Yanꞌanj: Nuraꞌ daꞌaj ni sij si-ganꞌānj. Ni̱ ducu ni sij sisi̱ na̱caj ni sij mantāj. Hué daj gataj si-nu̱guanꞌ Yanꞌanj. Ni̱ daꞌngaꞌ daj guiꞌyaj ni snado daj. ");
INSERT INTO trq_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ni̱ niquinꞌ ni̱chrunꞌ nni Jesús rian rugutsi̱ nga̱ xugüij unj nej, María nica̱ Cleofas nej, María Magdalena nej. ");
INSERT INTO trq_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ni̱ ngaa guiniꞌi Jesús sisi̱ niquinꞌ nu̱guanꞌan nni sij nga̱ tsínj nicoꞌ sij huin síꞌ tsínj ꞌi̱ ruhua sij, ngaa ni̱ gataj sij gunun nni sij: ―Nnānj, tsínj niquinꞌ daj ga̱huin daꞌníj re̱ꞌ aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ngaa ni̱ gataj Jesús gunun tsínj nicoꞌ sij daj: ―Yunꞌunj xa̱na nan ga̱huin nní re̱ꞌ aj. ―Daj gataj Jesús. Ni̱ asi̱j hora daj ni̱ nahuin raꞌa tsínj daj nni Jesús sisi̱ ga̱ne únꞌ ducuá síꞌ du̱gumi síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ni̱ ngaa guisíj gataj Jesús nuguanꞌ daj, ni̱ guiniꞌi sij sisi̱ gahuin yya daranꞌ si gataj si-nu̱guanꞌ Yanꞌanj xiꞌí sij. Ngaa ni̱ gataj sij: ―Nagoꞌōj nnee aj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ni̱ nne ꞌngo̱ siu̱ nu̱n nnee vino yu̱ yuꞌuj daj. Ni̱ jniyaj ni sij vino daj chra̱ si rúnꞌ hua gachij daj. Ni̱ gutaꞌ ni sij gachij daj chra̱ ꞌngo̱ riuj. Ngaa ni̱ dugüinꞌ ni sij duꞌua Jesús. ");
INSERT INTO trq_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ni̱ ngaa guisíj goꞌo Jesús vino yu̱ daj, ni̱ gataj síꞌ: ―Ganahuij sun guiꞌyā. ―Daj gataj Jesús. Hué dan ni̱ guinicoꞌ ni̱j Jesús chra̱ sij, ni̱ gahuiꞌ sij. ");
INSERT INTO trq_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ni̱ huin diꞌni̱ güi ngaa ga̱huin guiꞌyanj pascua. Ni̱ naꞌuej ni tsínj israelita sisi̱ gui̱nicoꞌ aninꞌ hua̱ꞌnij níman rian rugutsi̱ güi naránj ruhua ni sij. (Daj si güi gue̱ huin ngaa naránj ruhua ni sij daj.) Hué daj ni̱ gachínj jniꞌyaj ni sij rian Pilato sisi̱ ga̱ꞌnij síꞌ ni snado ga̱nꞌanj du̱guaranꞌ ni síꞌ daꞌma̱n aninꞌ hua̱ꞌnij tsínj nicoꞌ rian ni rugutsi̱ daj. Ni̱ ni̱caj ni síꞌ ni níman daj ga̱nꞌanj ni síꞌ ango yuꞌuj, ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ngaa ni̱ ganꞌanj ni snado duguaranꞌ ni sij daꞌma̱n ꞌngo̱ tsínj daj. Ni̱ hué daj guiꞌyaj ni sij nga̱ ango tsínj nicoꞌ nu̱guanꞌan nga̱ Jesús. ");
INSERT INTO trq_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Sani̱ ngaa gaꞌna̱ꞌ ni sij rian nicoꞌ Jesús, ni̱ guiniꞌi ni sij sisi̱ hua gahuiꞌ síꞌ. Yuꞌuj daj ni̱ nun duguaranꞌ ni sij daꞌma̱n síꞌ ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sani̱ xaꞌuij ꞌngo̱ snado lanza gati̱n Jesús. Ni̱ ꞌngo̱ hora gahui tun hua nnee gati̱n síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ni̱ tsínj nataꞌ nuguanꞌ nan, ni̱ hué sij guiniꞌi daranꞌ si gahuin. Ni̱ xa̱ngaꞌ si-nu̱guanꞌ sij. Ni̱ nataꞌ sij nuguanꞌ nan sisi̱ gu̱xuman ruhua ni é re̱ꞌ gui̱niꞌi ni é re̱ꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ni̱ hué daj gahuin sisi̱ ga̱huin yya da̱j rúnꞌ gataj si-nu̱guanꞌ Yanꞌanj: “Ni̱ a̱ ꞌngo̱ cúj Jesús nun garanꞌ mánj.” Daj gataj si-nu̱guanꞌ Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ni̱ gataj ango si-nu̱guanꞌ Yanꞌanj: “Gui̱niꞌyaj ni sij tsínj xaꞌuij ni sij lanza.” Daj gataj ango si-nu̱guanꞌ Yanꞌanj xiꞌí Jesús. ");
INSERT INTO trq_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Hué dan ni̱ daꞌ síj ni̱ gaꞌna̱ꞌ ꞌngo̱ tsínj gu̱ꞌnaj José. Ni̱ nne sij ꞌngo̱ yuꞌuj gu̱ꞌnaj Arimatea. Ni̱ guinicoꞌ hui̱ sij Jesús. Daj si xuꞌuiꞌ sij niꞌyaj sij ni tsínj israelita. Ngaa ni̱ gachínj jniꞌyaj sij rian Pilato sisi̱ ga̱ꞌuej síꞌ gui̱nicaj sij níman ga̱nꞌanj sij. Ngaa ni̱ garáj xina̱ Pilato. Hué dan ni̱ gaꞌna̱ꞌ sij ni̱ nicaj sij níman Jesús ganꞌanj sij. ");
INSERT INTO trq_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ni̱ hué daj gaꞌna̱ꞌ tsínj gu̱ꞌnaj Nicodemo tsínj gaꞌmi nga̱ Jesús ne̱ꞌ ni̱ asi̱j ná. Ni̱ nicaj síꞌ gaꞌna̱ꞌ síꞌ ꞌngo̱ si hui̱j xia kilo si nachej dugüiꞌ mirra nga̱ aloé huin si quinꞌ da̱j. ");
INSERT INTO trq_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Hué dan ni̱ guidaꞌa nu̱ngüej sij níman Jesús. Ni̱ dutáj nu̱ngüej sij atsij manta sa̱ꞌ síꞌ. Ni̱ garij nu̱ngüej sij gonoꞌo guinꞌ da̱j riqui manta Jesús. Daj si hué daj huin ducuánj nicaj ni tsínj israelita ngaa achinꞌ ni sij níman. ");
INSERT INTO trq_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ni̱ ri̱an doco̱ꞌ ni sij Jesús rian rugutsi̱, ni̱ ngaj ꞌngo̱ nnaa̱ chrun. Ni̱ da̱ni nnaa̱ chrun daj táj ꞌngo̱ yuꞌuj huej. Ni̱ hua gayaꞌ ni sij yuꞌuj huej daj sisi̱ ga̱chinꞌ ni sij níman. Sani̱ a̱ ꞌngo̱ níman nun ga̱chinꞌ ni sij yuꞌuj da mánj. ");
INSERT INTO trq_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Hué dan ni̱ xiꞌí si ꞌyaj xugüi ni tsínj israelita sisi̱ ga̱huin guiꞌyanj pascua, ni̱ xiꞌí si ni̱chrunꞌ táj yuꞌuj daj, ni̱ ganꞌanj ga̱chinꞌ nu̱ngüej sij Jesús. ");
INSERT INTO trq_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ni̱ ngaa ruhua guere̱ngaꞌ ni̱ganꞌ acuanꞌ güi gudungu ngaa hua ru̱miꞌ, ni̱ ganꞌanj ni̱ꞌyaj María Magdalena rian gachinꞌ Jesús. Ni̱ guiniꞌi unj sisi̱ nitaj yej hua ránj rian yuꞌuj daj. ");
INSERT INTO trq_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Yuꞌuj daj gunánj unj ganꞌanj unj rian nne Simón Pedro nga̱ ango tsínj nicoꞌ Jesús huin síꞌ tsínj ꞌi̱ ruhua Jesús. Ngaa ni̱ gataj unj: ―Guiri ni sij Señor riqui yuꞌuj huej ganꞌanj ni sij. Sani̱ nun niꞌi únj ni̱ a̱ ganꞌanj nicaj ni sij mánj. ―Daj gataj María. ");
INSERT INTO trq_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ngaa ni̱ gahui Pedro nga̱ ango tsínj nicoꞌ Jesús ganꞌanj ni̱ꞌyaj nu̱ngüej sij rian yuꞌuj daj. ");
INSERT INTO trq_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ni̱ gunánj nu̱ngüej sij. Sani̱ gunánj yoo̱ doj ango tsínj daj daj nga̱ Pedro. Ni̱ guisíj sini sij rian yuꞌuj da guisíj Pedro. ");
INSERT INTO trq_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ni̱ gaꞌ ni̱tu sij niꞌyaj sij chruhua yuꞌuj daj. Ni̱ guiniꞌi sij rian ngaj atsij. Sani̱ nun ga̱tu sij mánj. ");
INSERT INTO trq_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ni̱ nicoꞌ Simón Pedro guisíj síꞌ ru̱cu sij. Ni̱ gatúj síꞌ guiniꞌyaj síꞌ. Ni̱ guiniꞌi síꞌ ni atsij ngaj nej. ");
INSERT INTO trq_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ni̱ hué daj guiniꞌi Pedro atsij ganiꞌyanj chra̱ Jesús. Sani̱ nitaj si ngaj nu̱guanꞌan-ánꞌ nga̱ ango atsij guiniꞌi sij daj. Sani̱ ngaj ni̱ni atsij daj narumi-íꞌ ngaj-áꞌ aj. ");
INSERT INTO trq_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ngaa ni̱ gatúj ango tsínj nicoꞌ Jesús tsínj guisíj sini daj. Ni̱ guiniꞌyaj síꞌ, ni̱ guxuman ruhua síꞌ sisi̱ ganáꞌnij Jesús. ");
INSERT INTO trq_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Daj si achin gara daꞌngaꞌ ruhua nu̱ngüej sij si ataj si-nu̱guanꞌ Yanꞌanj sisi̱ hua nia̱n ga̱naꞌnij Jesús scanij ni níman. ");
INSERT INTO trq_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ngaa ni̱ nanica̱j nu̱ngüej sij na̱nꞌ sij rian ni dugüiꞌ sij. ");
INSERT INTO trq_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ni̱ niquinꞌ María aco unj duꞌua yuꞌuj daj. Ni̱ aco María gaꞌ ni̱tu unj niꞌyaj unj chruhua yuꞌuj rian gachinꞌ Jesús. ");
INSERT INTO trq_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ni̱ guiniꞌi unj hui̱j ángel nu̱n atsij ga̱tsi nne rian gachinꞌ Jesús. Ni̱ ꞌngo̱ ángel nne rian guingaj chra̱ Jesús. Ni̱ ango-óꞌ nne rian guingaj dacój síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ngaa ni̱ nachínj snanꞌanj nu̱ngüej ángel María. Ni̱ gataj nu̱ngüej sij: ―Xicaꞌuíꞌ, u̱n sin huin ni̱ acó re̱ꞌ únj. ―Daj gataj nu̱ngüej sij. Ngaa ni̱ gataj María: ―Nicaj ni sij Señor nicoꞌ manꞌānj ganꞌanj ni sij. Sani̱ nun niꞌīnj ni̱ a̱ ganꞌanj nicaj ni sij mánj. ―Daj gataj María gunun nu̱ngüej ángel daj. ");
INSERT INTO trq_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ni̱ ngaa gataj unj nuguanꞌ daj, ni̱ nanica̱j unj niꞌyaj unj. Ni̱ guiniꞌi unj Jesús niquinꞌ síꞌ rian unj. Sani̱ nun na̱niꞌi unj sij. ");
INSERT INTO trq_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ngaa ni̱ gataj Jesús: ―Xicaꞌuīj, u̱n sin huin ni̱ acó re̱ꞌ únj. Ni̱ u̱n tsínj nanóꞌ re̱ꞌ únj. ―Daj gataj Jesús. Ni̱ gani ruhua unj sisi̱ tsínj dugumi nnaa̱ chrun huin sij. Yuꞌuj daj gataj unj: ―Señor, sisi̱ hué re̱ꞌ nicaj ganꞌanj sij, ngaa ni̱ ga̱taj re̱ꞌ sisi̱ ni̱ a̱ ganꞌanj nicáj re̱ꞌ sij. Ngaa ni̱ ga̱nꞌanj na̱cā sij. ―Daj gataj María. ");
INSERT INTO trq_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ngaa ni̱: ―María. ―Gataj Jesús. Ngaa ni̱ nanica̱j unj gataj unj snanꞌanj hebreo: ―Raboni. ―Gataj María. (Ni̱ Raboni huin ruhuaj gata Maestro). ");
INSERT INTO trq_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ngaa ni̱ gataj Jesús: ―Si̱ guidaꞌá re̱ꞌ manꞌānj si achin ga̱hui na̱nꞌānj rian chrē. Sani̱ güi̱j na̱taꞌ re̱ꞌ gu̱nun ni jnān sisi̱ na̱nꞌānj rian nne chrē huin chrē ni é re̱ꞌ nej. Danꞌān huin ni̱ Danꞌanj ni é re̱ꞌ huin nej. ―Daj gataj Jesús gunun María. ");
INSERT INTO trq_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ngaa ni̱ na̱nꞌ María Magdalena nataꞌ unj rian ni tsínj nicoꞌ Jesús sisi̱ guiniꞌi unj Señor. Ni̱ hué daj nataꞌ unj si gataj síꞌ gunun unj nej. ");
INSERT INTO trq_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ni̱ ngaa guini̱ güi gudungu daj, ni̱ naránj ni tsínj nicoꞌ Jesús rian hueꞌ mán ni sij. Daj si xuꞌuiꞌ ni sij niꞌyaj ni sij ni tsínj israelita. Ngaa ni̱ gurugüiꞌ Jesús ganiquinꞌ síꞌ scanij ni sij. Ni̱ gataj síꞌ: ―Ga̱huin dinꞌinj ruhua á re̱ꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ngaa guisíj gaꞌmi Jesús nuguanꞌ daj, ni̱ digyán sij raꞌa sij nga̱ gati̱n sij rian ni síꞌ. Ni̱ gahuin nia̱ꞌ ruhua ni síꞌ niꞌyaj síꞌ Señor. ");
INSERT INTO trq_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ngaa ni̱ gataj ru̱huaꞌ yún Jesús: ―Ga̱huin dinꞌinj ruhua ni é re̱ꞌ. Da̱j rúnꞌ gaꞌníj chrē gaꞌnāj, ni̱ daꞌngaꞌ daj aꞌnī ga̱nꞌanj ni é re̱ꞌ chruhua xungüi̱ nej. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Guisíj gaꞌmi Jesús daj, ni̱ gaꞌyanj sij rian ni síꞌ. Ni̱ gataj sij: ―Na̱huin raꞌa á re̱ꞌ Espíritu Santo nánj. ");
INSERT INTO trq_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Sisi̱ gui̱nicaj á re̱ꞌ niman nico xiꞌí gaquinꞌ ꞌyaj ni ngüi̱, ngaa ni̱ gui̱nicaj Yanꞌanj niman nico xiꞌí gaquinꞌ daj. Sani̱ sisi̱ si̱ guinicaj ni é re̱ꞌ niman nico xiꞌí gaquinꞌ ꞌyaj ni ngüi̱, ngaa ni̱ si̱ guinicaj Yanꞌanj niman nico nej mánj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ni̱ ꞌngo̱ ni xu̱huij dugüiꞌ ni tsínj nicoꞌ Jesús huin tsínj gu̱ꞌnaj Tomás gu̱ꞌnaj síꞌ Dídimo nej. Ni̱ nitaj Tomás nne ngaa gurugüiꞌ Jesús rian ango ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ngaa ni̱ gataj ango ni tsínj nicoꞌ Jesús gunun Tomás: ―Guiniꞌi ni únj, Señor. ―Daj gataj ni sij. Sani̱: ―Ni̱ sisi̱ si̱ guiniꞌīnj rian guiranꞌ xi̱ꞌi raꞌa sij guiꞌyaj gaquíj, ni̱ sisi̱ si̱ diguī chra̱ raꞌāj rian guiranꞌ xi̱ꞌi daj nga̱ gati̱n sij, ni̱ si̱ guxuman ruhuāj sisi̱ ganáꞌnij sij mánj. ―Daj gataj Tomás gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ni̱ ngaa gachin ango tu̱nj güi, ni̱ naranꞌ ru̱huaꞌ yún ni tsínj nicoꞌ Jesús chruhua hueꞌ. Ni̱ nne Tomás nga̱ ni sij. Ni̱ nu̱nj si hua ránj rian hueꞌ, sani̱ narugüiꞌ Jesús ganiquinꞌ síꞌ scanij ni sij. Ni̱: ―Ga̱huin dinꞌinj ruhua á re̱ꞌ. ―Gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ngaa ni̱ gataj Jesús gunun Tomás: ―Di̱guíj re̱ꞌ chra̱ raꞌá re̱ꞌ chruhua raꞌāj nan. Ni̱ ni̱ꞌyaj re̱ꞌ da̱j hua raꞌāj nánj. Ni̱ jnu̱cuá re̱ꞌ raꞌá re̱ꞌ, ni̱ di̱guíj re̱ꞌ raꞌá re̱ꞌ gatīnj. Ngaa ni̱ ga̱huin yya ruhuá re̱ꞌ sisi̱ ganáꞌnij manꞌānj. Ni̱ gu̱xuman ruhuá re̱ꞌ ni̱ꞌyaj re̱ꞌ manꞌānj. ―Daj gataj Jesús gunun Tomás. ");
INSERT INTO trq_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ngaa ni̱: ―Huín re̱ꞌ Señor nicōj aj. Ni̱ Danꞌān huín re̱ꞌ nej. ―Gataj Tomás gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ngaa ni̱ gataj Jesús: ―Xuman ruhuá re̱ꞌ niꞌyáj re̱ꞌ manꞌānj xiꞌí si guiniꞌí re̱ꞌ yūnj níꞌ. Hua ꞌueé rian ni ngüi̱ guxuman ruhua niꞌi manꞌānj ngaa achin guiniꞌi ni sij yūnj. ―Daj gataj Jesús gunun Tomás. ");
INSERT INTO trq_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ni̱ guiꞌyaj Jesús gaꞌi̱ ango si sa̱ꞌ nico guiniꞌi ni tsínj nicoꞌ sij. Sani̱ nitaj si hua ni̱ca ni nuguanꞌ daj rian libro nan mánj. ");
INSERT INTO trq_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Sani̱ ni nuguanꞌ nan hua ni̱ca rian libro nan sisi̱ gu̱xuman ruhua ni é re̱ꞌ sisi̱ Jesús huin Cristo daꞌníj Yanꞌanj. Ni̱ xiꞌí si xuman ruhua á re̱ꞌ niꞌyaj á re̱ꞌ sij, ni̱ ga̱ ni̱ꞌnaꞌ ni̱ganj niman án re̱ꞌ, gui̱ꞌyaj sij. ");
INSERT INTO trq_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ngaa ni̱ gachin do̱j ni̱ gurugüiꞌ ru̱huaꞌ yún Jesús rian ni tsínj nicoꞌ sij ngaa nne ni sij duꞌua laguna xa̱chij gu̱ꞌnaj Tiberias. Ni̱ nan huin si guiꞌyaj Jesús ngaa gurugüiꞌ sij rian ni síꞌ: ");
INSERT INTO trq_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ni̱ nne nu̱guanꞌan Simón Pedro nga̱ Tomás tsínj gu̱ꞌnaj Gemelo nej, Natanael tsínj ꞌna̱ꞌ xumanꞌ Caná huin xumanꞌ ngaj estado Galilea nej, nu̱ngüej daꞌníj Zebedeo nej, yahuij tsínj nicoꞌ Jesús nej. ");
INSERT INTO trq_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ngaa ni̱: ―Ga̱nꞌanj gui̱daꞌā xucuaj. ―Daj gataj Pedro. Ni̱: ―Hué daj ga̱nꞌanj ni únj nga̱ re̱ꞌ nej. ―Daj gataj ni tsínj nne nga̱ sij. Hué dan ni̱ ganꞌanj ni tsínj daj. Ni̱ gahui ni sij ꞌngo̱ rio̱ achéj rian nnee. Sani̱ ni̱ a̱ ꞌngo̱ xucuaj nun guidaꞌa ni sij ya̱nꞌ daj. ");
INSERT INTO trq_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ni̱ ngaa ruhua guixigui̱n, ni̱ niquinꞌ Jesús duꞌua laguna daj. Sani̱ nun na̱niꞌi ni tsínj nicoꞌ Jesús manꞌan síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ngaa ni̱ nachínj snanꞌanj Jesús ni sij. Ni̱ gataj síꞌ: ―Hua si xa á re̱ꞌ níꞌ. ―Gataj Jesús. ―Nitaj mánj. ―Gataj ni sij. ");
INSERT INTO trq_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ngaa ni̱ gataj Jesús: ―Du̱nij a ni é re̱ꞌ nnánj ne̱ꞌ chrej raꞌa sa̱ꞌ rio̱, ni̱ gui̱daꞌa á re̱ꞌ xuj aj. ―Daj gataj Jesús. Ngaa ni̱ guiꞌyaj ni sij da̱j rúnꞌ gataj Jesús. Hué dan ni̱ nun gahuin nucuaj ni sij guiri ni sij nnánj chruhua nnee xiꞌí si ducu gara xuj chruhua nnánj. ");
INSERT INTO trq_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ngaa ni̱ hua ꞌngo̱ tsínj nicoꞌ Jesús huin síꞌ tsínj ꞌi̱ ruhua niꞌi Jesús. Ni̱ gataj síꞌ gunun Pedro: ―Hué sij huin Señor. ―Daj gataj síꞌ. Ni̱ ngaa gunun Pedro sisi̱ Señor huin, ni̱ ꞌngo̱ hora gananun sij si-ganꞌ sij. (Daj si hua guiri sij si-ganꞌ sij.) Ni̱ güéj sij manꞌan sij chruhua nnee. ");
INSERT INTO trq_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ni̱ guisíj ango ni tsínj nicoꞌ Jesús duꞌua laguna daj nga̱ rio̱. Ni̱ anucuaj ni sij nnánj gara xucuaj daj. Daj si achin ango ciento metro gui̱sij ni sij duꞌua nnee daj. ");
INSERT INTO trq_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ni̱ ngaa nanij ni sij chruhua rio̱, ni̱ guiniꞌi ni sij anun yanꞌa̱n. Ni̱ ta̱j ꞌngo̱ xucuaj rian yanꞌa̱n. Ni̱ ma̱n chrachrúnj nej. ");
INSERT INTO trq_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ngaa ni̱ gataj Jesús gunun ni sij: ―Ni̱caj á re̱ꞌ do̱j xucuaj gui̱daꞌa ni é re̱ꞌ ga̱ꞌnaꞌ á re̱ꞌ. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ngaa ni̱ gahui Simón Pedro. Ni̱ ganucuaj sij nnánj gara xucuaj xxi guisíj sij rian yoꞌój. Ni̱ nu̱n ꞌngo̱ ciento táj hui̱j xia xa̱ꞌnij xucuaj chruhua nnánj daj. Ni̱ nu̱nj si nico xuj nu̱n, sani̱ nun xiꞌnij mánj. ");
INSERT INTO trq_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ngaa ni̱: ―Ga̱huaꞌ aninꞌ é re̱ꞌ ra̱ruhua aninꞌ é re̱ꞌ. ―Daj gataj Jesús. Ni̱ a̱ ꞌngo̱ ni tsínj nicoꞌ Jesús nun gui̱sij ruhua na̱chinj snanꞌanj síꞌ u̱n tsínj huin síꞌ. Daj si hua niꞌi ni sij sisi̱ Señor huin síꞌ. ");
INSERT INTO trq_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ngaa ni̱ gahuin ni̱chrunꞌ Jesús guidaꞌa sij chrachrúnj daj gaꞌuiꞌ sij rian ni síꞌ. Ni̱ hué daj guiꞌyaj sij nga̱ xucuaj nej. ");
INSERT INTO trq_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ni̱ hué nan guisíj hua̱ꞌnij gurugüiꞌ Jesús rian ni tsínj nicoꞌ sij ngaa guisíj ganáꞌnij sij scanij ni níman. ");
INSERT INTO trq_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ngaa guisíj ganahuij raruhua ni sij, ni̱ nachínj snanꞌanj Jesús Simón Pedro. Ni̱ gataj sij: ―Simón, daꞌníj Jonás. Ni̱ ꞌi̱ ruhuá re̱ꞌ niꞌyáj re̱ꞌ doj manꞌānj daj nga̱ ni tsínj nan ga̱ níꞌ. ―Daj gataj Jesús. Ngaa ni̱: ―Xa̱ngaꞌ niꞌí re̱ꞌ sisi̱ ꞌi̱ ruhuāj niꞌyā manꞌán re̱ꞌ Señor. ―Daj gataj Pedro. Ngaa ni̱: ―Ga̱ꞌuiꞌ re̱ꞌ si xa̱ ni dānj xachij ꞌni̱j. ―Gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ngaa ni̱ nachínj snanꞌanj ru̱huaꞌ yún Jesús Pedro. Ni̱ gataj sij: ―Simón, daꞌníj Jonás. Ni̱ ꞌi̱ ruhuá re̱ꞌ niꞌyáj re̱ꞌ manꞌānj níꞌ. ―Daj gataj Jesús. ―Xa̱ngaꞌ niꞌí re̱ꞌ sisi̱ ꞌi̱ ruhuāj niꞌyā manꞌán re̱ꞌ Señor. ―Gataj Pedro. Ngaa ni̱: ―Du̱gumi re̱ꞌ ni dānj xachij. ―Gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ngaa ni̱ síj hua̱ꞌnij nachínj snanꞌanj Jesús Pedro. Ni̱ gataj sij: ―Simón, daꞌníj Jonás. Ni̱ ꞌi̱ ruhuá re̱ꞌ niꞌyáj re̱ꞌ manꞌānj níꞌ. ―Daj gataj Jesús. Ngaa ni̱ ganani ruhua Pedro. Daj si síj hua̱ꞌnij nachínj snanꞌanj Jesús sij daj. Ngaa ni̱ gataj Pedro: ―Niꞌí re̱ꞌ daranꞌanj Señor. Ni̱ niꞌí re̱ꞌ sisi̱ ꞌi̱ ruhuāj niꞌyā manꞌán re̱ꞌ. ―Daj gataj Pedro. Ngaa ni̱: ―Ga̱ꞌuiꞌ re̱ꞌ si xa ni dānj xachij. ");
INSERT INTO trq_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Xa̱ngaꞌ atā gu̱nun re̱ꞌ sisi̱ ngaa hua lí re̱ꞌ, ni̱ ninún re̱ꞌ si-gánꞌ re̱ꞌ ganꞌánj re̱ꞌ ni̱ a̱ garanꞌ ruhuá re̱ꞌ ganꞌánj re̱ꞌ. Sani̱ ngaa ga̱chij re̱ꞌ ni̱ jnucuáj re̱ꞌ nu̱ngüej raꞌá re̱ꞌ. Ni̱ na̱ꞌnij ango sij si-gánꞌ re̱ꞌ xá re̱ꞌ. Ni̱ ni̱caj sij manꞌán re̱ꞌ ga̱nꞌanj sij rian naꞌuej ruhuá re̱ꞌ ga̱nꞌanj re̱ꞌ. ―Daj gataj Jesús gunun Pedro. ");
INSERT INTO trq_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ni̱ nga̱ ni nuguanꞌ daj ni̱ digyán Jesús rian Pedro da̱j gui̱ranꞌ síꞌ ga̱huiꞌ síꞌ. Ni̱ digyán sij da̱j ga̱ꞌmi sa̱ꞌ ni ngüi̱ xiꞌí Yanꞌanj ngaa gui̱niꞌi ni sij da̱j ga̱huiꞌ Pedro. Ngaa ni̱ gataj Jesús gunun Pedro: ―Gui̱nicóꞌ re̱ꞌ yūnj anj. ―Daj gataj Jesús. ");
INSERT INTO trq_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ngaa ni̱ nanica̱j Pedro. Ni̱ guiniꞌi sij nicoꞌ ango tsínj nicoꞌ Jesús huin síꞌ tsínj ꞌi̱ ruhua niꞌyaj Jesús. Ni̱ hué tsínj daj huin tsínj nne xiꞌníj Jesús ngaa xa stiꞌni̱ ni sij ngaa riqui. Ni̱ tsínj daj huin tsínj nachínj snanꞌanj Jesús u̱n tsínj huin si na̱gaꞌuiꞌ Jesús rian ni tsínj nicaj sun. ");
INSERT INTO trq_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ni̱ ngaa guiniꞌi Pedro tsínj nicoꞌ daj, ni̱ nachínj snanꞌanj sij Jesús. Ni̱ gataj sij: ―Señor, da̱j gui̱ranꞌ tsínj nan únj. ―Daj gataj Pedro. ");
INSERT INTO trq_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ngaa ni̱ gataj Jesús: ―Sisi̱ huin ruhuāj sisi̱ gu̱na sij da na̱nicaj ru̱huaꞌ yūnj ga̱ꞌnāj, ni̱ u̱n sin gui̱ꞌyáj re̱ꞌ únj. Gui̱nicoꞌ manꞌán re̱ꞌ manꞌānj. ―Daj gataj Jesús gunun Pedro. ");
INSERT INTO trq_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ngaa ni̱ gaxaꞌni̱ nuguanꞌ nan scanij ni tsínj xuman ruhua niꞌyaj Jesús. Ni̱ gani ruhua ni sij sisi̱ si̱ gahuiꞌ tsínj nicoꞌ Jesús daj. Sani̱ nun gataj Jesús sisi̱ si̱ gahuiꞌ tsínj da mánj. Maan si gataj sij nuguanꞌ nan: “Sisi̱ huin ruhuāj sisi̱ gu̱na sij da na̱nicaj ru̱huaꞌ yūnj, ni̱ u̱n sin gui̱ꞌyáj re̱ꞌ únj.” Hué daj gaꞌmi Jesús. ");
INSERT INTO trq_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ni̱ huēj huin tsínj nicoꞌ Jesús daj. Ni̱ huēj huin tsínj natāj ni nuguanꞌ nan rian ni ngüi̱. Ni̱ arūnj nuguanꞌ nan rian yanj nej. Ni̱ niꞌi néꞌ sisi̱ xa̱ngaꞌ si-nu̱guanꞌānj. ");
INSERT INTO trq_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ni̱ hua gaꞌi̱ ango ni rasu̱n guiꞌyaj Jesús nej. Ni̱ sisi̱ ga̱run ni sij go̱ꞌngo ni rasu̱n guiꞌyaj Jesús rian yanj, ngaa ni̱ si̱ gaꞌue gu̱nucuaj ni ngüi̱ na̱ra sa̱ꞌ ni sij ni libro sisi̱ nun garun ni sij mánj.");
INSERT INTO trq_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Hué dan ni̱ rian yanj carta garūnj asi̱j sini gayá re̱ꞌ huín re̱ꞌ tsínj gu̱ꞌnaj Teófilo, ni̱ gatā gunún re̱ꞌ daranꞌ si guiꞌyaj Jesús nga̱ daranꞌ si digyán sij rian ni ngüi̱ asi̱j sini ya̱n ");
INSERT INTO trq_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","da̱ꞌ güi guina̱nꞌ sij xataꞌ, guiꞌyaj Yanꞌanj. Ni̱ asi̱j achin na̱nꞌ sij xataꞌ, ni̱ ganacui sij ni tsínj gu̱ꞌnaj apóstol huin ni sij ni tsínj gaꞌmi si-nu̱guanꞌ sij rian ni ngüi̱. Ni̱ gaꞌninꞌ Jesús sun rian ni síꞌ da̱j rúnꞌ gataj Espíritu Santo rian sij. ");
INSERT INTO trq_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ni̱ ngaa guisíj gahuiꞌ Jesús rian rugutsi̱, ni̱ narugüiꞌ sij rian ni tsínj daj. Ni̱ daꞌngaꞌ daj digyán yya sij rian ni síꞌ sisi̱ hua ni̱ꞌnaꞌ yya sij. Hué dan ni̱ hui̱j xia güi guiniꞌi ni apóstol manꞌan Jesús. Ni̱ gaꞌmi sij nga̱ ni síꞌ xiꞌí da̱j nicaj Yanꞌanj sun rian néꞌ. ");
INSERT INTO trq_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ni̱ ꞌngo̱ güi ngaa nne nu̱guanꞌan Jesús nga̱ ni tsínj daj, ni̱ gaꞌninꞌ sij sun rian ni síꞌ sisi̱ si̱ gahui ni síꞌ xumanꞌ Jerusalén ga̱nꞌanj ni síꞌ. Ni̱ gataj sij gunun ni síꞌ: ―Ga̱ noꞌoj acuanꞌ án re̱ꞌ nan da güi ga̱ꞌnaꞌ Espíritu Santo rian án re̱ꞌ da̱j rúnꞌ gataj yya chrē rian án re̱ꞌ. Ni̱ hué daj gataj snanꞌanj manꞌānj gunun a ni é re̱ꞌ nej. ");
INSERT INTO trq_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Daj si xa̱ngaꞌ duguataꞌ nnee tsínj gu̱ꞌnaj Juan ni ngüi̱ nga̱ nnee. Sani̱ ga̱chin chra̱ do̱j güi, ni̱ ga̱ꞌnaꞌ Espíritu Santo ga̱tu ruhua niman án re̱ꞌ. ―Daj gataj Jesús gunun ni tsínj apóstol. ");
INSERT INTO trq_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Hué dan ni̱ ngaa nahuin yuꞌ ni sij, ni̱ nachínj snanꞌanj ni sij Jesús. Ni̱ gataj ni sij: ―Señor, hué hora nan huin si ga̱huin achij ni únj ni tsínj israelita rian ango ni ngüi̱, gui̱ꞌyáj re̱ꞌ níꞌ. ―Daj gataj ni sij gunun Jesús. ");
INSERT INTO trq_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ni̱ nanica̱j Jesús gataj sij: ―Sé si-sun a ni é re̱ꞌ huin si gui̱niꞌi a ni é re̱ꞌ da̱j daꞌngaꞌ ga̱ aj. Urin chréꞌ niꞌi u̱n güi gui̱ꞌyaj sij si huin ruhua sij. ");
INSERT INTO trq_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Sani̱ ngaa ga̱ꞌnaꞌ Espíritu Santo ga̱tu chruhua niman án re̱ꞌ, ni̱ ga̱huin nucuaj niman án re̱ꞌ xiꞌí si-sun manꞌan Yanꞌanj. Ni̱ ga̱huin a ni é re̱ꞌ ni tsínj ga̱ꞌmi xiꞌīj riqui xumanꞌ Jerusalén nga̱ daranꞌ ni xumanꞌ ngaj estado Judea nga̱ estado Samaria nej, ni̱ daꞌ ganu̱n ni̱nꞌ xungüi̱ nej. ―Daj gataj Jesús gunun ni tsínj daj. ");
INSERT INTO trq_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ngaa ni̱ hua gue̱ guimán ni sij guiniꞌyaj ni sij, ni̱ na̱nꞌ Jesús xataꞌ, guiꞌyaj Yanꞌanj. Ni̱ gaꞌna̱ꞌ ꞌngo̱ nga xataꞌ narán ni̱ a̱ ganꞌanj Jesús. Ni̱ nun ga̱ꞌue guiniꞌi ni sij rian Jesús ga̱ mánj. ");
INSERT INTO trq_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ni̱ ngaa guimán ni sij niꞌyaj ni sij ne̱ꞌ xataꞌ ni̱ a̱ huaj Jesús, ngaa ni̱ gurugüiꞌ hui̱j tsínj nu̱n atsij gatsi̱ guiniquinꞌ nu̱ngüej síꞌ xiꞌníj ni sij. ");
INSERT INTO trq_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ni̱ gataj nu̱ngüej síꞌ gunun ni sij: ―Ni̱ u̱n sin gahuin ni̱ niquinꞌ a ni é re̱ꞌ niꞌyaj á re̱ꞌ xataꞌ huin ín re̱ꞌ tsínj ꞌna̱ꞌ estado Galilea únj. Hué gue̱ Jesús gahui na̱nꞌ sij xataꞌ, guiꞌyaj Yanꞌanj. Ni̱ rúnꞌ gahuin ngaa na̱nꞌ sij xataꞌ, ni̱ daꞌngaꞌ daj ga̱huin ga̱ꞌnaꞌ ru̱huaꞌ yún sij aj. ―Daj gataj nu̱ngüej tsínj daj gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ngaa ni̱ nanij ni sij dacan gu̱ꞌnaj Olivos. Ni̱ ganꞌanj ni sij gatúj ni sij xumanꞌ Jerusalén. Ni̱ ngaj ni̱chrunꞌ xumanꞌ daj nga̱ dacan gu̱ꞌnaj Olivos. Ni̱ hué gue̱ ducuánj daj huin si gaꞌuiꞌ ley permiso si ga̱che ni sij ꞌngo̱ güi naránj ruhua ni sij. ");
INSERT INTO trq_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ni̱ ngaa nasíj ni sij xumanꞌ daj, ni̱ gahui ni sij ango chra̱ hueꞌ nataꞌ xataꞌ rian ma̱n ni sij. Ni̱ nne Pedro nga̱ Juan nej, Jacobo nej, Andrés nej, Felipe nej, Tomás nej, Bartolomé nej, Mateo nej, Jacobo daꞌníj Alfeo nej, Simón Zelote nej, Judas jnánj Jacobo nej. ");
INSERT INTO trq_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ni̱ ꞌngo̱ hua ruhua niman ni sij nahuin chreꞌ ni sij gachínj jniꞌyaj ni sij rian Yanꞌanj. Ni̱ daꞌngaꞌ daj guiꞌyaj ni yunꞌunj xa̱na nga̱ María huin unj nni Jesús nga̱ ni jnánj Jesús nej. ");
INSERT INTO trq_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ni̱ ni güi daj ni̱ naxu̱man Pedro guiniquinꞌ sij da̱ni ni tsínj nicaj dugüiꞌ nga̱ Jesús. (Ni̱ guimán ꞌngo̱ si ciento tá co̱ ni tsínj nahuin chreꞌ yuꞌuj daj.) ");
INSERT INTO trq_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ni̱ gataj Pedro gunun ni sij: ―Asi̱j hua ná ni̱ gaꞌmi Espíritu Santo rian xíꞌ David huin ín re̱ꞌ jnān. Ni̱ gaꞌmi David nuguanꞌ daj huin nuguanꞌ xiꞌí tsínj gu̱ꞌnaj Judas. Ni̱ hua nia̱n sisi̱ ga̱huin yya da̱j rúnꞌ gaꞌmi sij xiꞌí nuguanꞌ daj. Ni̱ hué Judas digyán ꞌngo̱ chrej gaꞌna̱ꞌ ni tsínj guidaꞌa Jesús nej aj. ");
INSERT INTO trq_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ni̱ asi̱j sini ni̱ guinicaj dugüiꞌ Judas nga̱ néꞌ. Ni̱ hué sij huin tsínj guiꞌyaj sun nga̱ néꞌ nej aj. ");
INSERT INTO trq_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","’Ni̱ sanꞌanj guiriꞌ sij guduꞌuej sij Jesús daj, ni̱ guiránj sij ꞌngo̱ yoꞌój. Hué dan ni̱ ganatúj Judas ganꞌanj sij rian yoꞌój nga̱ chra̱ sij. Ni̱ gahui xiriꞌ sij. ");
INSERT INTO trq_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ni̱ gunun daranꞌ ni tsínj mán xumanꞌ Jerusalén da̱j guiranꞌ Judas. Ni̱ duguꞌna̱j ni sij si-nu̱guanꞌ ni sij yoꞌój daj Acéldama. Ni̱ nuguanꞌ daj huin ruhuaj gata Yoꞌój Tun. ");
INSERT INTO trq_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Daj si gataj libro gu̱ꞌnaj Salmos huin si-nu̱guanꞌ Yanꞌanj: Gui̱sij na̱huin quij quiꞌyanj na̱co rian gane ducuá sij. Ni̱ a̱ ꞌngo̱ tsínj si̱ gane ruhuaj mánj. Gataj libro daj. Ni̱ gataj ru̱huaꞌ yún libro daj: Na̱caj ango síꞌ si-sun sij, ruhuāj aj. Daj gataj libro gu̱ꞌnaj Salmo aj. ");
INSERT INTO trq_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","’Ni̱ ma̱n ni tsínj nicaj dugüiꞌ nu̱guanꞌan nga̱ néꞌ daranꞌ ni güi gane Jesús scanij néꞌ asi̱j güi duguataꞌ nnee Juan Jesús, ni̱ da jnahuij sij na̱nꞌ sij xataꞌ, guiꞌyaj Yanꞌanj. Hué dan ni̱ daꞌui néꞌ na̱noꞌ néꞌ ꞌngo̱ tsínj guiniꞌi daranꞌ si guiꞌyaj Jesús, ga̱huin síꞌ ꞌngo̱ tsínj na̱taꞌ nga̱ néꞌ rian ni ngüi̱ xiꞌí si ganáꞌnij yya Jesús. ―Daj gataj Pedro gunun ni sij. ");
INSERT INTO trq_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ngaa ni̱ gaꞌmi ni sij si-xugüi hui̱j tsínj daj. Ni̱ gu̱ꞌnaj ꞌngo̱ sij José Barsabás. Ni̱ hué daj gu̱ꞌnaj sij Justo nej. Ni̱ ango sij gu̱ꞌnaj Matías. ");
INSERT INTO trq_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ngaa ni̱ gachínj jniꞌyaj daranꞌ ni sij rian Yanꞌanj. Ni̱ gataj ni sij: ―Señor, hué re̱ꞌ niꞌi da̱j hua niman daranꞌ ni ngüi̱. Xiꞌí daj di̱gyán re̱ꞌ u̱n go̱ꞌngo nu̱ngüej sij nacuí re̱ꞌ. ");
INSERT INTO trq_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Ngaa ni̱ ga̱nacaj sij sun nan ga̱huin sij ꞌngo̱ apóstol ga̱ꞌmi sij si-nu̱guanꞌ Jesucristo rian ni ngüi̱. Daj si guinij Judas rian si-ga̱quinꞌ manꞌan sij. Ni̱ ganꞌanj sij rian ganꞌanj niꞌya ni̱ganj ni̱nꞌ sij. ―Hué daj gaꞌmi ni sij gunun Yanꞌanj. ");
INSERT INTO trq_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ni̱ garun ni sij si-xugüi hui̱j tsínj daj. Ni̱ guiriꞌ ni sij si-xugüi tsínj gu̱ꞌnaj Matías. Ni̱ hué asi̱j hora daj guinicaj dugüiꞌ síꞌ nga̱ ango xa̱n tsínj apóstol huin ni tsínj gaꞌmi si-nu̱guanꞌ Jesucristo rian ni ngüi̱. ");
INSERT INTO trq_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ni̱ ngaa guisíj güi gahuin guiꞌyanj gu̱ꞌnaj Pentecostés, ni̱ nahuin chreꞌ daranꞌ ni sij ꞌngo̱ yuꞌuj. ");
INSERT INTO trq_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ni̱ nasi̱nunj gunun ni sij gaꞌna̱ꞌ xataꞌ huin gari̱n. Da̱j rúnꞌ ꞌyaj ꞌngo̱ nane̱ nucuaj daꞌngaꞌ daj gahuin aj. Ni̱ gahuin gari̱n ni̱nꞌ ga̱chraꞌ chruhua hueꞌ rian ma̱n ni sij. ");
INSERT INTO trq_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ni̱ gurugüiꞌ yanꞌa̱n. Ni̱ da̱j