﻿USE sofia;
DROP TABLE IF EXISTS sofia.trcNT_vpl;
CREATE TABLE trcNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES trcNT_vpl WRITE;
INSERT INTO trcNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yanj nihánj me taj xnaꞌanj cheꞌé nij xi̱i Jesucristó a. Veé xi̱i Jesucristó me síí cuꞌna̱j David síí cane ga̱a naá, ne̱ xi̱i David me síí cuꞌna̱j Abraham síí cane ga̱a naá ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Dan me se síí cuꞌna̱j Abraham me rej síí cuꞌna̱j Isaac, ne̱ Isaac me rej síí cuꞌna̱j Jacob, ne̱ Jacob me rej nij tinu̱j síí cuꞌna̱j Judá, ");
INSERT INTO trcNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ne̱ Judá me rej síí cuꞌna̱j Fares ga̱ síí cuꞌna̱j Zara, ne̱ chana̱ cuꞌna̱j Tamar me nii ro̱j soꞌ a. Ne̱ Fares me rej síí cuꞌna̱j Esrom, ne̱ Esrom me rej síí cuꞌna̱j Aram, ");
INSERT INTO trcNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ne̱ Aram me rej síí cuꞌna̱j Aminadab, ne̱ Aminadab me rej síí cuꞌna̱j Naasón, ne̱ Naasón me rej síí cuꞌna̱j Salmón, ");
INSERT INTO trcNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ne̱ Salmón me rej síí cuꞌna̱j Booz, ne̱ nii Booz me chana̱ cuꞌna̱j Rahab a. Ne̱ Booz me rej síí cuꞌna̱j Obed, ne̱ nii Obed me chana̱ cuꞌna̱j Rut a. Ne̱ Obed me rej síí cuꞌna̱j Isaí, ");
INSERT INTO trcNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ne̱ Isaí me rej síí cuꞌna̱j David, ne̱ síí cuꞌna̱j David roꞌ, me síí nica̱j suun rey uun chij rihaan nij yuvii̱ israelitá ga̱a cane soꞌ ado̱nj. Ne̱ David me rej síí cuꞌna̱j Salomón, ne̱ nii Salomón me nica̱ síí cuꞌna̱j Urías a. ");
INSERT INTO trcNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ne̱ Salomón me rej síí cuꞌna̱j Roboam, ne̱ Roboam me rej síí cuꞌna̱j Abías, ne̱ Abías me rej síí cuꞌna̱j Asa a. ");
INSERT INTO trcNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ne̱ Asa me rej síí cuꞌna̱j Josafat, ne̱ Josafat me rej síí cuꞌna̱j Joram, ne̱ Joram me rej síí cuꞌna̱j Uzías a. ");
INSERT INTO trcNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ne̱ Uzías me rej síí cuꞌna̱j Jotam, ne̱ Jotam me rej síí cuꞌna̱j Acaz, ne̱ Acaz me rej síí cuꞌna̱j Ezequías a. ");
INSERT INTO trcNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ne̱ Ezequías me rej síí cuꞌna̱j Manasés, ne̱ Manasés me rej síí cuꞌna̱j Amón, ne̱ Amón me rej síí cuꞌna̱j Josías a. ");
INSERT INTO trcNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ne̱ Josías me rej nij tinu̱j síí cuꞌna̱j Jeconías, ne̱ cayáán nij soꞌ yoꞌ quiꞌyaj canaán nij síí ma̱n Babilonia rihaan nij yuvii̱ israelitá, ne̱ caꞌanj nica̱j nij soꞌ man nij yuvii̱ israelitá chiháán nij soꞌ gu̱un nij yuvii̱ israelitá mozó rihaan nij soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Guun naá do̱j, ne̱ guun Jeconías rej síí cuꞌna̱j Salatiel, ne̱ Salatiel me rej síí cuꞌna̱j Zorobabel, ");
INSERT INTO trcNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ne̱ Zorobabel me rej síí cuꞌna̱j Abiud, ne̱ Abiud me rej síí cuꞌna̱j Eliaquim, ne̱ Eliaquim me rej síí cuꞌna̱j Azor, ");
INSERT INTO trcNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ne̱ Azor me rej síí cuꞌna̱j Sadoc, ne̱ Sadoc me rej síí cuꞌna̱j Aquim, ne̱ Aquim me rej síí cuꞌna̱j Eliud, ");
INSERT INTO trcNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ne̱ Eliud me rej síí cuꞌna̱j Eleazar, ne̱ Eleazar me rej síí cuꞌna̱j Matán, ne̱ Matán me rej síí cuꞌna̱j Jacob, ");
INSERT INTO trcNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ne̱ Jacob me rej síí cuꞌna̱j José, ne̱ José me síí xcaj man chana̱ cuꞌna̱j Mariá, ne̱ noꞌ me nii síí cuꞌna̱j Jesús, ne̱ síí caꞌnéé Diose̱ ti̱nanii man yuvii̱ ma̱n rihaan chumii̱ nihánj rihaan sayuun me Jesús ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Dan me se asi̱j síí cuꞌna̱j Abraham nda̱a síí cuꞌna̱j David síj xcaꞌa̱nj xi̱i síí cuꞌna̱j Jesucristó a. Ne̱ asi̱j síí cuꞌna̱j David nda̱a caꞌanj nica̱j nij síí ma̱n Babilonia man nij yuvii̱ israelitá chiháán nij soꞌ síj yoꞌó xcaꞌa̱nj xi̱i síí cuꞌna̱j Jesucristó a. Ne̱ asi̱j caꞌanj nica̱j nij síí ma̱n Babilonia man nij yuvii̱ israelitá chiháán nij soꞌ nda̱a caꞌngaa síí cuꞌna̱j Jesucristó, ne̱ síj yoꞌó xcaꞌa̱nj nij xi̱i Jesucristó uún ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ne̱ nihánj me se vaa guun asi̱j rque̱ ga̱a ataa caꞌnga̱a̱ Jesucristó a. Dan me se nii Jesucristó me chana̱ cuꞌna̱j Mariá a. Ga̱a asino ya̱a̱n guun ya̱ rá noꞌ ga̱ síí cuꞌna̱j José se vaa xca̱j tuviꞌ ro̱j soꞌ a. Tza̱j ne̱ ataa cunu̱u rcuaꞌa̱a̱n ro̱j soꞌ a. Tza̱j ne̱ xcaj noꞌ cuentá se vaa a̱j nariꞌ noꞌ neꞌej quiꞌyaj Nimán Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Dan me se síí cuꞌna̱j José me síí xca̱j man chana̱ cuꞌna̱j Mariá, ne̱ xcaj soꞌ cuentá se vaa a̱j nuû rque noꞌ neꞌej a. Cheꞌé dan nuchruj ra̱a̱ soꞌ, ne̱ guun rá soꞌ se vaa ta̱náj yuve̱ soꞌ man noꞌ ado̱nj. Dan me se si̱j vaa nica̱ nimán me soꞌ, ne̱ guun rá soꞌ cata̱j xnaꞌanj soꞌ rihaan nij síí nica̱j suun, tza̱j ne̱ guun vi̱j rá soꞌ, ne̱ ne caꞌve̱j rá soꞌ cuta̱ꞌ soꞌ cacunꞌ xráá chana̱ cuꞌna̱j Mariá rihaan nij síí nica̱j suun a. ");
INSERT INTO trcNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Dan me se nuchruj ra̱a̱ soꞌ da̱j quiꞌya̱j soꞌ, ga̱a ne̱ rej nii̱ caꞌmii nej rihaan soꞌ a. Dan me se cotoj soꞌ, ne̱ naquiꞌyaa rihaan soꞌ se vaa caꞌnaꞌ yoꞌo̱ se‑mo̱zó síí ꞌni̱j raꞌa man níꞌ, ne̱ cataj se‑mo̱zó síí ꞌni̱j raꞌa man níꞌ rihaan soꞌ a: ―Cu̱nó so̱ꞌ caꞌmi̱i̱ ꞌu̱nj, José. ꞌO̱ se taꞌnij siꞌno̱ síí cuꞌna̱j David síí cane ga̱a naá mé so̱ꞌ ado̱nj. Se̱ cuchuꞌvíꞌ so̱ꞌ xca̱j so̱ꞌ man chana̱ cuꞌna̱j Mariá maꞌ. Ne tumé noꞌ cacunꞌ maꞌ. Ma̱a̱n se nayón neꞌej rque noꞌ quiꞌyaj Nimán Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Dan me se cuchru̱j noꞌ neꞌej sno̱ꞌo cunii, ne̱ asa̱ꞌ cuchruj noꞌ neꞌej, ne̱ Jesús tu̱cuꞌnáj so̱ꞌ man neꞌej yoꞌ á. Da̱nj tu̱cuꞌnáj soj man soꞌ, cheꞌé se gu̱un soꞌ síí ti̱nanii man nij tuviꞌ soꞌ rihaan chrej chiꞌi̱i̱ uun chij nimán nij soꞌ ado̱nj. ―Da̱nj caꞌmii se‑mo̱zó síí ꞌni̱j raꞌa man níꞌ rihaan síí cuꞌna̱j José a. ");
INSERT INTO trcNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nu̱ꞌ nihánj me se vaa quiꞌyaj síí ꞌni̱j raꞌa man níꞌ a. Quiꞌyaj gue̱e̱ soꞌ nu̱ꞌ nana̱ cataj xnaꞌanj soꞌ ga̱a naá rihaan ꞌo̱ síí nataꞌ se‑na̱na̱ Diose̱ rihaan yuvii̱, ne̱ nihánj me nana̱ caꞌmii soꞌ rihaan síí nataꞌ se‑na̱na̱ Diose̱ yoꞌ a: ");
INSERT INTO trcNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Queneꞌe̱n soj se vaa quinari̱ꞌ ꞌo̱ chana̱ ya̱a̱n neꞌej, ne̱ cuchru̱j noꞌ neꞌej sno̱ꞌo cunii, ne̱ Emanuel cuꞌna̱j neꞌej ado̱nj”. Da̱nj caꞌmii síí ꞌni̱j raꞌa man níꞌ ga̱a naá rihaan síí nataꞌ se‑na̱na̱ Diose̱, ne̱ nana̱ “Emanuel” taj se vaa cane̱ maꞌa̱n Diose̱ ga̱ níꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Veé dan, ne̱ quinanuû rá síí cuꞌna̱j José, ne̱ quiꞌyaj soꞌ nu̱ꞌ nda̱a vaa cataj xnaꞌanj se‑mo̱zó síí ꞌni̱j raꞌa man níꞌ rihaan soꞌ, ne̱ xcaj soꞌ man chana̱ cuꞌna̱j Mariá a. ");
INSERT INTO trcNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tza̱j ne̱ ne coto̱j soꞌ ga̱ noꞌ nda̱a se quisíj cuchruj noꞌ neꞌej sno̱ꞌo cunii a. Ne̱ tucuꞌnáj José Jesús man neꞌej ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Dan me se caꞌngaa Jesucristó chumanꞌ Belén chumanꞌ na̱j estadó Judea, ne̱ síí cuꞌna̱j Herodes me síí nica̱j suun rey uun chij rihaan chumanꞌ rej caꞌngaa Jesucristó a. Quisíj caꞌngaa Jesucristó, ga̱a ne̱ caꞌnaꞌ nij síí tucuꞌyón ndoꞌo cheꞌé yatiꞌ chumanꞌ cuꞌna̱j Jerusalén, ne̱ nij síí cavii rej síj güii me nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ne̱ xnáꞌanj nij soꞌ man nij síí ma̱n Jerusalén, cataj nij soꞌ: ―Neꞌej gu̱un síí nica̱j suun rey gu̱un chij rihaan nij yuvii̱ israelitá roꞌ, me rej caꞌngaa soꞌ ga̱. Queneꞌen núj yatiꞌ taj xnaꞌanj yoꞌ se vaa caꞌngaa soꞌ na̱nj á. Cavii yatiꞌ yoꞌ xta̱ꞌ rej síj güii, ne̱ cheꞌé dan caꞌnaꞌ núj quinaꞌvi̱j núj rihaan soꞌ ado̱nj ―taj nij síí tucuꞌyón ndoꞌo cheꞌé yatiꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ga̱a ne̱ cuchiꞌ nana̱ rihaan síí nica̱j suun rey cuꞌna̱j Herodes se vaa xnáꞌanj ndoꞌo nij síí tucuꞌyón ndoꞌo cheꞌé yatiꞌ me rej caꞌngaa neꞌej yoꞌ, ga̱a ne̱ cuchuꞌviꞌ ndoꞌo soꞌ se vaa cachi̱j neꞌej yoꞌ, ne̱ caꞌne̱e̱ neꞌej yoꞌ se‑su̱u̱n soꞌ raꞌa soꞌ vaa güii, rá soꞌ a. Ne̱ cuchuꞌviꞌ ndoꞌo nij síí ma̱n chumanꞌ Jerusalén se vaa caxri̱i̱ yuva̱a̱ Herodes man maꞌa̱n nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Veé dan, ne̱ cunuu chre̱ꞌ taranꞌ nij xrej ata̱ suun noco̱o doj cunuu chre̱ꞌ nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan nij yuvii̱ cunuu chre̱ꞌ rihaan soꞌ, quiꞌyaj soꞌ, ne̱ xnáꞌanj Herodes man nij soꞌ me rej caꞌnga̱a̱ síí caꞌne̱j Diose̱ ti̱nanii man yuvii̱ ma̱n rihaan chumii̱ rihaan sayuun a. ");
INSERT INTO trcNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ga̱a ne̱ cataj nij soꞌ rihaan Herodes a: ―Caꞌnga̱a̱ soꞌ chumanꞌ Belén chumanꞌ na̱j estadó Judea a ―taj nij soꞌ rihaan síí nica̱j suun rey cuꞌna̱j Herodes a. Da̱nj caꞌmii nij soꞌ cheꞌé nana̱ nihánj nana̱ cachrón síí nataꞌ se‑na̱na̱ Diose̱ rihaan yanj a: ");
INSERT INTO trcNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Ne̱ ma̱ꞌán so̱ꞌ, chuma̱nꞌ Belén chuma̱nꞌ na̱j estadó Judea roꞌ, chumanꞌ sa̱ꞌ ndoꞌo ꞌni̱j raꞌa man tuviꞌ chumanꞌ na̱j estadó Judea mé so̱ꞌ á. Dan me se vaa síí gu̱un chiha̱nj mán so̱ꞌ, ne̱ gu̱un chij uxrá soꞌ, ne̱ uxrá cu̱tumé soꞌ man nij yuvii̱ israelitá yuvii̱ cunéꞌ ꞌu̱nj canoco̱ꞌ manj a”. Nihánj me nana̱ cachrón síí nataꞌ se‑na̱na̱ Diose̱ rihaan yanj ga̱a naá a. ");
INSERT INTO trcNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Cuno síí nica̱j suun Herodes nana̱ caꞌmii nij soꞌ, ga̱a ne̱ caꞌnéé yuve̱ soꞌ nana̱ rihaan nij síí tucuꞌyón ndoꞌo cheꞌé yatiꞌ se vaa caꞌna̱ꞌ nij soꞌ rihaan Herodes a. Ga̱a ne̱ xnáꞌanj Herodes man nij soꞌ me yavii curuviꞌ naca̱ yatiꞌ taj xnaꞌanj cheꞌé neꞌej yoꞌ, taj Herodes a. Ga̱a ne̱ cataj xnaꞌanj nij soꞌ rihaan Herodes a. ");
INSERT INTO trcNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ga̱a ne̱ caꞌnéé Herodes man nij soꞌ caꞌa̱nj nij soꞌ chumanꞌ Belén, ne̱ caꞌneꞌ Herodes suun rihaan nij soꞌ, ne̱ cataj Herodes: ―Nano̱ꞌ uxrá soj man neꞌej yoꞌ, ne̱ asa̱ꞌ nariꞌ soj man neꞌej, ne̱ cata̱j xnaꞌanj soj rihanj me rej ne neꞌej yoꞌ, ga̱a ne̱ caꞌa̱nj ma̱ꞌanj quinaꞌvi̱j ma̱ꞌanj rihaan neꞌej yoꞌ ado̱nj ―taj Herodes rihaan nij síí tucuꞌyón ndoꞌo cheꞌé yatiꞌ, caꞌmii ne̱ soꞌ rihaan nij síí tucuꞌyón ndoꞌo cheꞌé yatiꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Quisíj cuno nij soꞌ nana̱ cataj xnaꞌanj síí nica̱j suun rey rihaan nij soꞌ, ga̱a ne̱ curiha̱nj nij soꞌ, caꞌanj nij soꞌ, ga̱a ne̱ queneꞌen uún nij soꞌ man yatiꞌ yoꞌ a. Yatiꞌ a̱j queneꞌen nij soꞌ rej síj güii me yatiꞌ yoꞌ, ne̱ dan me se va̱j yatiꞌ yoꞌ, ne̱ yoꞌo̱ canocoꞌ nij soꞌ man yatiꞌ yoꞌ, nda̱a se canicunꞌ yatiꞌ yoꞌ rej xta̱ꞌ rej ya̱nj neꞌej yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ga̱a queneꞌen nij soꞌ man yatiꞌ yoꞌ, ga̱a ne̱ uxrá guun niha̱ꞌ rá nij soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ga̱a ne̱ catúj nij soꞌ rá veꞌ rej canicunꞌ yatiꞌ xta̱ꞌ, ga̱a ne̱ nariꞌ nij soꞌ man neꞌej ga̱ nii neꞌej chana̱ cuꞌna̱j Mariá, ga̱a ne̱ canicunꞌ ru̱j nij soꞌ, ne̱ quinaꞌvíj nij soꞌ rihaan neꞌej yoꞌ a. Veé dan, ga̱a ne̱ nuxraꞌ nij soꞌ se‑chru̱nj nij soꞌ, ga̱a ne̱ rqué ndoꞌo nij soꞌ rasu̱u̱n sa̱ꞌ rihaan neꞌej yoꞌ a. Dan me se agaꞌ oró míí do̱ꞌ, squíí cuꞌna̱j incienso do̱ꞌ, squíí cuꞌna̱j mirra do̱ꞌ, rqué u̱u̱n nij soꞌ rihaan neꞌej yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ne̱ rej nii̱ caꞌmii nej rihaan nij soꞌ, ne̱ cataj xnaꞌanj Diose̱ rihaan nij soꞌ se vaa se̱ canica̱j uún nij soꞌ caꞌa̱nj nij soꞌ rihaan síí nica̱j suun rey cuꞌna̱j Herodes, taj nej rihaan nij soꞌ a. Cheꞌé dan yoꞌó chrej canica̱j nij soꞌ quinanꞌ nij soꞌ chiháán nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Quisíj quinanꞌ nij síí tucuꞌyón ndoꞌo cheꞌé yatiꞌ, ga̱a ne̱ rej nii̱ caꞌmii nej rihaan síí cuꞌna̱j José a. Dan me se naquiꞌyaa yoꞌo̱ se‑mo̱zó síí ꞌni̱j raꞌa man níꞌ rihaan soꞌ, ne̱ cataj se‑mo̱zó síí ꞌni̱j raꞌa man níꞌ rihaan soꞌ a: ―Na̱xagaa so̱ꞌ, ne̱ ni̱caj so̱ꞌ man ro̱j ni̱i neꞌej, ne̱ cuna̱nj so̱ꞌ caꞌa̱nj so̱ꞌ rej cuꞌna̱j Egiptó, ne̱ ca̱yáán so̱ꞌ Egiptó nda̱a güii caꞌmi̱i̱ uún ꞌu̱nj rihaan so̱ꞌ á. ꞌO̱ se nano̱ꞌ ndoꞌo síí nica̱j suun rey cuꞌna̱j Herodes man neꞌej, ne̱ ticavi̱ꞌ soꞌ man neꞌej yoꞌ vaa taj soꞌ ado̱nj ―taj se‑mo̱zó síí ꞌni̱j raꞌa man níꞌ rihaan síí cuꞌna̱j José a. ");
INSERT INTO trcNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ga̱a ne̱ naxaga̱a̱ síí cuꞌna̱j José, ne̱ nica̱j soꞌ man ro̱j ni̱i neꞌej, ne̱ rej nii̱ cavii nij soꞌ caꞌanj nij re̱j soꞌ Egiptó, ");
INSERT INTO trcNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ne̱ cane nij soꞌ Egiptó yoꞌ nda̱a se caviꞌ síí nica̱j suun rey cuꞌna̱j Herodes a. Dan me se quisíj ya̱ nu̱ꞌ nana̱ nda̱a vaa cataj xnaꞌanj síí ꞌni̱j raꞌa man níꞌ rihaan ꞌo̱ síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá, se vaa cataj soꞌ: “Canacúún ꞌu̱nj man taꞌníj se vaa cavi̱i̱ soꞌ Egiptó caꞌna̱ꞌ soꞌ ado̱nj”. Da̱nj taj Diose̱ ga̱a naá cheꞌé taꞌníí soꞌ Jesucristó ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Quisíj caꞌanj nij re̱j Jesucristó rej cuꞌna̱j Egiptó, ga̱a ne̱ xcaj síí nica̱j suun rey cuꞌna̱j Herodes cuentá se vaa a̱j tihaꞌ yuꞌunj nij síí tucuꞌyón cheꞌé yatiꞌ man soꞌ, ga̱a ne̱ caꞌmaan ndoꞌo rá soꞌ, ne̱ cheꞌé dan caꞌneꞌ soꞌ suun rihaan tanuu se vaa ticavi̱ꞌ tanuu man nu̱ꞌ neꞌej sno̱ꞌo cunii ya̱nj nu̱ꞌ anica̱j chumanꞌ Belén a. Neꞌej va̱j vi̱j yoꞌ rej rque̱ roꞌ, cavi̱ꞌ, taj soꞌ a. Da̱nj quiꞌyaj soꞌ, ga̱a ne̱ cavi̱ꞌ neꞌej caꞌmii yatiꞌ cheꞌé taj nij síí tucuꞌyón cheꞌé yatiꞌ rihaan soꞌ, rá soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Da̱nj quiꞌyaj soꞌ, ne̱ quisíj ya̱ nu̱ꞌ nana̱ cataj xnaꞌanj síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá síí cuꞌna̱j Jeremías, se vaa cataj soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Cuno̱ nii taꞌve̱e ndoꞌo chana̱ ma̱n chumanꞌ cuꞌna̱j Ramá a. Ase vaa chana̱ cuꞌna̱j Raquel chana̱ cane ga̱a naá ga̱a̱ nij chana̱, taꞌve̱e ndoꞌo nij noꞌ cheꞌé taꞌníí nij noꞌ a. Ne̱ se̱ caꞌvej uxrá rá nij chana̱ naquiꞌya̱j niha̱ꞌ noꞌ nimán noꞌ, cheꞌé se navij taꞌníí nij noꞌ caviꞌ na̱nj ado̱nj”. Da̱nj caꞌmii síí cuꞌna̱j Jeremías ga̱a naá a. ");
INSERT INTO trcNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ga̱a quisíj caviꞌ síí nica̱j suun rey cuꞌna̱j Herodes, ga̱a ne̱ naquiꞌyaa uún yoꞌo̱ se‑mo̱zó síí ꞌni̱j raꞌa man níꞌ rihaan síí cuꞌna̱j José ga̱a yáán soꞌ Egiptó ga̱a otoj soꞌ rej nii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ne̱ cataj xnaꞌanj se‑mo̱zó síí ꞌni̱j raꞌa man níꞌ rihaan José a: ―Na̱xagaa so̱ꞌ, ne̱ ni̱caj so̱ꞌ ro̱j ni̱i neꞌej, ne̱ caꞌa̱nj so̱ꞌ rej cuꞌna̱j Israel á. ꞌO̱ se ya̱j me se caviꞌ nij síí me rá ticavi̱ꞌ man neꞌej ya̱j na̱nj ado̱nj ―taj se‑mo̱zó síí ꞌni̱j raꞌa man níꞌ rihaan síí cuꞌna̱j José a. ");
INSERT INTO trcNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ga̱a ne̱ naxaga̱a̱ síí cuꞌna̱j José, ne̱ nica̱j uún soꞌ ro̱j ni̱i neꞌej caꞌanj soꞌ rej cuꞌna̱j Israel a. ");
INSERT INTO trcNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ne̱ cuchiꞌ nana̱ rihaan soꞌ se vaa síí cuꞌna̱j Arquelao guun síí nica̱j suun rey uun chij rihaan estadó Judea a. Dan me se nayón síí cuꞌna̱j Arquelao rihaan rej soꞌ síí cuꞌna̱j Herodes a. Cheꞌé dan cuchuꞌviꞌ ndoꞌo síí cuꞌna̱j José caꞌa̱nj soꞌ estadó Judea, ga̱a ne̱ caꞌmii nej rihaan uún soꞌ se vaa se̱ caꞌanj soꞌ estadó Judea maꞌ. Cheꞌé dan caꞌanj soꞌ estadó Galilea, ");
INSERT INTO trcNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ne̱ cuchiꞌ soꞌ chumanꞌ Nazaret, ne̱ cayáán soꞌ chumanꞌ yoꞌ a. Dan me se cayáán nij soꞌ chumanꞌ Nazaret, ne̱ quisíj ya̱ nu̱ꞌ nana̱ cataj nij síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá, se vaa síí cavii Nazaret me síí caꞌne̱j Diose̱ ti̱nanii man yuvii̱ rihaan sayuun ado̱nj. Ina̱nj da̱nj caꞌmii nij síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Dan me se yoꞌo̱ yáán Jesucristó chumanꞌ Nazaret, ne̱ cavii síí cuꞌna̱j Juan tacaan estadó Judea, ne̱ caꞌmii natáj ndoꞌo soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","cataj soꞌ: ―Nuchra̱nꞌ nimán soj, ne̱ ta̱náj soj chrej chiꞌi̱i̱ ei. ꞌO̱ se nichru̱nꞌ gu̱un chij Diose̱ rihaan chumii̱ nihánj na̱nj ado̱nj ―taj soꞌ, aꞌmii natáj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Síí nataꞌ se‑na̱na̱ Diose̱ rihaan yuvii̱ ga̱a naá síí cuꞌna̱j Isaías roꞌ, cataj xnaꞌanj cheꞌé síí cuꞌna̱j Juan, cataj soꞌ: “Nucua̱j ndoꞌo caꞌmi̱i̱ natáj ꞌo̱ soꞌ rej tacaan, ne̱ cata̱j soꞌ se vaa nuchra̱nꞌnimán yuvii̱, ne̱ veꞌé caꞌmi̱i̱ nij yuvii̱ ga̱ síí ꞌni̱j raꞌa man níꞌ asa̱ꞌ caꞌnaꞌ soꞌ a”, taj síí cuꞌna̱j Isaías ga̱a naá a. ");
INSERT INTO trcNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Dan me se síí cuꞌna̱j Juan me se nu̱u̱ soꞌ yatzíj nuj xcuu camelló ne̱ ꞌni̱j catuu̱n soꞌ merque̱ nu̱j, ne̱ chá soꞌ ina̱nj rquíí, ne̱ catziꞌ xtaan ma̱n quij coꞌo soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ne̱ curiha̱nj ndoꞌo yuvii̱ ma̱n chumanꞌ Jerusalén do̱ꞌ, yuvii̱ ma̱n nu̱ꞌ estadó Judea do̱ꞌ, yuvii̱ ma̱n nij chumanꞌ na̱j tuꞌva chráá cuꞌna̱j Jordán do̱ꞌ, caꞌnaꞌ rihaan síí cuꞌna̱j Juan, ");
INSERT INTO trcNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ga̱a ne̱ cataꞌ ne nij yuvii̱ rá chráá cuꞌna̱j Jordán, quiꞌyaj Juan a. Dan me se nataꞌ ya̱ nij yuvii̱ cheꞌé nu̱ꞌ cacunꞌ tumé nij yuvii̱, ga̱a ne̱ cataꞌ ne nij yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ga̱a ne̱ queneꞌen síí cuꞌna̱j Juan se vaa caꞌnaꞌ ndoꞌo nij síí fariseo do̱ꞌ, nij síí saduceo do̱ꞌ, me rá nij soꞌ cuta̱ꞌ ne Juan man nij soꞌ a. Ga̱a ne̱ caꞌmii natáj soꞌ rihaan nij soꞌ, cataj soꞌ: ―Ase vaa xcuáá yuva̱a̱ vaa soj á. Me síí cataj xnaꞌanj rihaan soj cuna̱nj soj, ne̱ quinani̱i̱ soj rihaan sayuun quiꞌya̱j Diose̱ ga̱. Asa̱ꞌ caꞌve̱e quinani̱i̱ soj rihaan sayuun, quiꞌya̱j ina̱nj na cata̱ꞌ ne soj ga̱. ");
INSERT INTO trcNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sese ya̱ cunuu sa̱ꞌ nimán soj, ne̱ caꞌa̱nj soj quiꞌya̱j soj nda̱a vaa ꞌyaj yuvii̱ cunuu sa̱ꞌ nimán á. ");
INSERT INTO trcNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ne̱ tadó soj sese quisi̱j rá soj cata̱j soj se vaa taꞌníí taꞌnij siꞌno̱ síí cuꞌna̱j Abraham síí cane ga̱a naá me soj, ne̱ ne tumé soj cacunꞌ, cata̱j soj á. Se̱ caꞌmii soj daj chiha̱a̱ míj da̱nj maꞌ. Ma̱a̱n se cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa nuveé se yaꞌa̱nj tihaꞌ taꞌníí taꞌnij siꞌno̱ síí cuꞌna̱j Abraham me soj a̱ maꞌ. Ma̱a̱n se sese Diose̱ rá, ne̱ caꞌve̱e ni̱caj Diose̱ náá guun yahij na̱j rihaan yoꞌóó nihánj, ne̱ quiꞌya̱j Diose̱ man ꞌo̱ taꞌníí taꞌnij siꞌno̱ síí cuꞌna̱j Abraham ado̱nj. Cheꞌé dan canoco̱ꞌ ya̱ soj man Diose̱ á. ");
INSERT INTO trcNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","”ꞌO̱ se nichru̱nꞌ quiꞌya̱j Diose̱ sayuun man nij síí naꞌvej rá cuno̱ rihaan soꞌ na̱nj á. Ase vaa síí oro̱ꞌ agaꞌ aꞌneꞌ chruun, ne̱ oro̱ꞌ soꞌ agaꞌ caꞌne̱ꞌ soꞌ chruun roꞌ, da̱nj vaa Diose̱ cuano̱ ei. Cheꞌé dan ase vaa ꞌyaj nii man chruun roꞌ, taꞌngaꞌ da̱nj quiꞌya̱j Diose̱ man nij síí ne uno rihaan soꞌ a. Dan me se aꞌneꞌ nii chruun nuviꞌ chruj sa̱ꞌ raa̱, ne̱ araa nii man chruun yoꞌ rihaan yaꞌan a. Taꞌngaꞌ da̱nj quiꞌya̱j Diose̱ man nij síí naꞌvej rá canoco̱ꞌ chrej sa̱ꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","”ꞌU̱nj nihánj me síí cuta̱ꞌ ne u̱u̱n man soj si̱j nuchranꞌ nimán canocoꞌ chrej sa̱ꞌ a. Tza̱j ne̱ vaa yoꞌó síí caꞌna̱ꞌ, ne̱ si̱j sca̱ꞌ doj gu̱un soꞌ rihanj a. Cheꞌé dan me a̱j ne nó xcúnj na̱chej nuj correá ꞌni̱j tacanj soꞌ maꞌ. Ne̱ caꞌna̱ꞌ soꞌ, ne̱ caꞌna̱ꞌ Nimán Diose̱ ga̱ soꞌ, ne̱ caxri̱i̱ yaꞌan soꞌ man soj si̱j naꞌvej rá cuno̱ rihaan Diose̱, ne̱ caca̱a̱ soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Dan me se ase vaa síí oro̱ꞌ chruun palá vaa soꞌ cuano̱ ado̱nj. Dan me se síí nica̱j chruun palá roꞌ, rii nu̱ꞌ ꞌnúú trigó na̱j rihaan yoꞌóó, ne̱ naquiꞌyaj chre̱ꞌ soꞌ man ꞌnúú trigó sa̱ꞌ, ne̱ araa soꞌ man ꞌnúú trigó sa̱ꞌ rá veꞌ, ne̱ anica̱j soꞌ araa soꞌ squíj niꞌya xráá trigó rihaan yaꞌan a. Ne̱ ase vaa síí nica̱j palá ma̱n cuano̱ roꞌ, da̱nj quiꞌya̱j síí caꞌna̱ꞌ, ne̱ naquiꞌya̱j chre̱ꞌ soꞌ man cunuda̱nj nij síí cunuu sa̱ꞌ nimán, ne̱ cara̱a soꞌ man nij síí chiꞌi̱i̱ rihaan yaꞌan, ne̱ caca̱a̱ nij soꞌ nu̱ꞌ cavii nu̱ꞌ caꞌanj, ne̱ daj chiha̱a̱ míj se̱ quinaꞌáj yaꞌan yoꞌ a̱ man ado̱nj. ―Da̱nj caꞌmii síí cuꞌna̱j Juan rihaan nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ga̱a ne̱ curiha̱nj Jesucristó estadó Galilea caꞌanj soꞌ chráá cuꞌna̱j Jordán rihaan síí cuꞌna̱j Juan, ne̱ cuta̱ꞌ ne Juan man Jesucristó, rá soꞌ a. Dan me se cuchiꞌ Jesucristó rihaan síí cuꞌna̱j Juan, ");
INSERT INTO trcNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","tza̱j ne̱ veé dan me se ne caꞌve̱j rá síí cuꞌna̱j Juan cuta̱ꞌ ne soꞌ man Jesucristó maꞌ. Ma̱a̱n se cataj síí cuꞌna̱j Juan rihaan Jesucristó a: ―Me cheꞌé ꞌnáꞌ so̱ꞌ cuta̱ꞌ ne ꞌu̱nj mán so̱ꞌ ga̱. Tana̱nj ma̱ꞌán so̱ꞌ me síí vaa cheꞌé cuta̱ꞌ ne man ma̱ꞌanj na̱nj á. Tza̱j ne̱ xa̱ꞌ ꞌu̱nj me se ne nó xcúún ꞌu̱nj cuta̱ꞌ nej mán so̱ꞌ maꞌ ―taj síí cuꞌna̱j Juan rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Caꞌve̱j so̱ꞌ cuta̱ꞌ ne so̱ꞌ manj ei. Da̱nj quiꞌya̱j níꞌ, cheꞌé se no̱ xcúún níꞌ quiꞌya̱j níꞌ nu̱ꞌ se vaa me rá Diose̱ quiꞌya̱j níꞌ ado̱nj ―taj Jesucristó rihaan síí cuꞌna̱j Juan, ga̱a ne̱ caꞌvej rá soꞌ, ga̱a ne̱ cutaꞌ ne soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Quisíj cataꞌ ne Jesucristó, ga̱a ne̱ curiha̱nj soꞌ rá na, ga̱a ne̱ taj niꞌyón naxraꞌ rej xta̱ꞌ, ne̱ queneꞌen soꞌ se vaa nanij Nimán Diose̱ rej xta̱ꞌ, ne̱ ase vaa chaꞌaa̱n roꞌ, vaa Nimán Diose̱, curuviꞌ yoꞌ rej xta̱ꞌ nanij yoꞌ raa̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ga̱a ne̱ rej xta̱ꞌ caꞌmii Diose̱ rihaan Jesucristó, ne̱ cuno nij síí nicu̱nꞌ ga̱ Jesucristó nana̱ caꞌmii Diose̱, ne̱ dan me se cataj Diose̱ a: ―Taꞌníí ꞌu̱nj síí ꞌe̱e̱ ndoꞌo raj man mé so̱ꞌ, ne̱ niha̱ꞌ ndoꞌo raj niꞌya̱j ꞌu̱nj mán so̱ꞌ ado̱nj ―taj nana̱ cavii rej xta̱ꞌ caꞌmii Diose̱ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ga̱a ne̱ caꞌanj Jesucristó rej tacaan, quiꞌyaj Nimán Diose̱, cheꞌé rej caꞌve̱e gu̱un rá síí chre̱e tiha̱ꞌ yuꞌunj síí chre̱e man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ne̱ vi̱j chiha̱a̱ ya̱ güii quisíj Jesucristó tocoꞌ Jesucristó xꞌnaa man maꞌa̱n soꞌ cheꞌé se aráj gue̱e̱ soꞌ rihaan Diose̱, ga̱a ne̱ quinaꞌaan ndoꞌo rque Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Dan me se cuchiꞌ síí chre̱e rihaan Jesucristó, ga̱a ne̱ guun rá soꞌ tiha̱ꞌ yuꞌunj soꞌ man Jesucristó, cheꞌé se guun rá soꞌ canoco̱ꞌ Jesucristó man soꞌ ado̱nj. Cheꞌé dan cataj soꞌ rihaan Jesucristó, ne̱: ―Sese ya̱ ya̱ taꞌni̱j Diose̱ mé so̱ꞌ, ne̱ cata̱j so̱ꞌ rihaan yahij nihánj se vaa gu̱un yoꞌ rachrúún cha̱ so̱ꞌ á ―taj síí chre̱e rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ga̱a ne̱ cataj Jesucristó rihaan síí chre̱e a: ―Tza̱j ne̱ danj Diose̱ taj: “Nuveé ina̱nj se chá me se achiin rihaan yuvii̱, ne̱ caꞌve̱e ca̱yáán sa̱ꞌ yuvii̱ maꞌ. Tana̱nj achiin cunuda̱nj se‑na̱na̱ Diose̱ cuno̱ yuvii̱, ne̱ veꞌé ca̱yáán yuvii̱ ei”. Ina̱nj da̱nj taj danj Diose̱ ―taj Jesucristó rihaan síí chre̱e yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ga̱a ne̱ caꞌanj nica̱j síí chre̱e man Jesucristó chumanꞌ gue̱e̱ chumanꞌ Jerusalén, ne̱ tacavii soꞌ man Jesucristó raa̱ nuvií noco̱o, ");
INSERT INTO trcNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ne̱ cataj soꞌ rihaan soꞌ: ―Sese ya̱ taꞌni̱j Diose̱ mé so̱ꞌ, ne̱ güe̱j so̱ꞌ, ne̱ nani̱j gue̱e̱ so̱ꞌ rihaan yoꞌóó á. ꞌO̱ se danj Diose̱ taj: “Yoꞌo̱ aꞌneꞌ Diose̱ suun rihaan nij se‑mo̱zó soꞌ se vaa cu̱tumé nij soꞌ mán so̱ꞌ, ne̱ ca̱ráán raꞌa nij soꞌ mán so̱ꞌ, se̱ gaa na̱nj caco̱ꞌ cheꞌé so̱ꞌ yahij a”. Ina̱nj da̱nj aꞌmii danj Diose̱ ―taj síí chre̱e rihaan Jesucristó ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Tza̱j ne̱ ne nó xcúnj qui̱ꞌyáj da̱nj maꞌ. ꞌO̱ se taj uún danj Diose̱: “Se̱ guun qui̱riꞌyunj so̱ꞌ man Diose̱ síí ꞌni̱j raꞌa man níꞌ ne̱ ti̱háꞌ so̱ꞌ man soꞌ maꞌ”. Ina̱nj da̱nj aꞌmii danj Diose̱ rihaan níꞌ ado̱nj ―taj Jesucristó rihaan síí chre̱e a. ");
INSERT INTO trcNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ga̱a ne̱ nica̱j síí chre̱e man Jesucristó caꞌanj soꞌ raa̱ ꞌo̱ quij xca̱a̱n ndoꞌo uún a. Ne̱ tihaa̱n soꞌ man nu̱ꞌ chumanꞌ ma̱n rihaan cunu̱ꞌ chumii̱ rihaan Jesucristó, ne̱ tihaa̱n soꞌ rihaan Jesucristó se vaa veꞌé ndoꞌo vaa nu̱ꞌ chumanꞌ yoꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Dan me se cataj uún síí chre̱e rihaan Jesucristó a: ―Gu̱un chij so̱ꞌ rihaan cunuda̱nj chumanꞌ na̱j rihaan chumii̱, qui̱ꞌyáá ꞌu̱nj, sese canicu̱nꞌ ru̱j so̱ꞌ quinaꞌvi̱j so̱ꞌ rihaan ꞌu̱nj á ―taj síí chre̱e yoꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ga̱a ne̱ cataj xnaꞌanj Jesucristó rihaan síí chre̱e a: ―Naxu̱u̱n yaníj so̱ꞌ mán so̱ꞌ, Satanás. ꞌO̱ se danj Diose̱ taj: “Rihaan o̱rúnꞌ Diose̱ síí ꞌni̱j raꞌa man níꞌ canicu̱nꞌ ru̱j so̱ꞌ, ne̱ a̱ ꞌó rihaan tuvíꞌ so̱ꞌ se̱ caꞌvee naꞌvi̱j so̱ꞌ maꞌ”. Da̱nj taj danj Diose̱ ado̱nj ―taj Jesucristó rihaan síí chre̱e yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ga̱a ne̱ tanáj síí chre̱e man soꞌ, caꞌanj síí chre̱e yoꞌ, ga̱a ne̱ cuchiꞌ nij se‑mo̱zó Diose̱ rihaan Jesucristó, rqué nij soꞌ me maꞌa̱n se cachiin rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Cuchiꞌ nana̱ rihaan Jesucristó se vaa quitaꞌaa nij tanuu man síí cuꞌna̱j Juan, caxríj tanuu tagaꞌ man soꞌ, ne̱ cheꞌé dan caꞌanj Jesucristó estadó Galilea, ");
INSERT INTO trcNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","tza̱j ne̱ ne ca̱yáán soꞌ chumanꞌ Nazaret maꞌ. Cavii soꞌ chumanꞌ Nazaret yoꞌ, ne̱ caꞌanj soꞌ cayáán soꞌ chumanꞌ Capernaum chumanꞌ na̱j tuꞌva na lacuaná a. Chumanꞌ yoꞌ naj rihaan toꞌóó nij taꞌníí taꞌnij siꞌno̱ síí cuꞌna̱j Zabulón do̱ꞌ, síí cuꞌna̱j Neftalí do̱ꞌ, síí ma̱n ga̱a naá yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Dan me se da̱nj quiꞌyaj Jesucristó caꞌanj soꞌ rej yoꞌ, ga̱a ne̱ guun ya̱ nu̱ꞌ nda̱a vaa cataj síí cuꞌna̱j Isaías síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá se vaa cataj soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Toꞌóó nij taꞌníí taꞌnij siꞌno̱ Zabulón do̱ꞌ, toꞌóó nij taꞌníí taꞌnij siꞌno̱ Neftalí do̱ꞌ, me yoꞌóó na̱j tuꞌva na lacuaná rej rne̱j tuꞌva chráá cuꞌna̱j Jordán, ne̱ estadó Galilea estadó ya̱nj nij síí yaníj me uún yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ne̱ nij síí ma̱n rej yoꞌ roꞌ, guun queꞌe̱e̱ yoꞌ ne queneꞌe̱n uxrá nij soꞌ rasu̱u̱n cheꞌé Diose̱ maꞌ. Ma̱a̱n se ase vaa yuvii̱ ne̱ rej rmi̱ꞌ roꞌ, da̱nj vaa nij soꞌ ne̱ nij soꞌ na̱nj ado̱nj. ꞌO̱ se vaa güii, ne̱ cavi̱ꞌ u̱u̱n nij soꞌ, ne̱ da̱nj uun maꞌa̱n, rá nij soꞌ ado̱nj. Tza̱j ne̱ caꞌna̱ꞌ ꞌo̱ yaꞌan, ne̱ cuchugu̱u̱n rej ya̱nj nij soꞌ, quiꞌya̱j yaꞌan yoꞌ, ne̱ veꞌé ndoꞌo xca̱j nij soꞌ cuentá ado̱nj”. Yoꞌ me se vaa cataj síí cuꞌna̱j Isaías ga̱a naá a. ");
INSERT INTO trcNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ga̱a ne̱ guun cheꞌe̱ Jesucristó caꞌmii natáj soꞌ rihaan yuvii̱, ne̱ cataj soꞌ: ―Nuchra̱nꞌ nimán soj ei. ꞌO̱ se nichru̱nꞌ quisi̱j güii caꞌna̱ꞌ Diose̱ gu̱un chij Diose̱ rihaan chumii̱ nihánj na̱nj ado̱nj. ―Ina̱nj da̱nj caꞌmii natáj Jesucristó rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ꞌO̱ güii cachén Jesucristó tuꞌva na lacuaná cuꞌna̱j na Galilea, ne̱ queneꞌen soꞌ man ro̱j tinu̱j ro̱j soꞌ a. Yoꞌo̱ soꞌ me síí cuꞌna̱j Simón, ne̱ Pedró cuꞌna̱j yoꞌó se‑chuvi̱i síí cuꞌna̱j Simón yoꞌ a. Ne̱ tinúú soꞌ me síí cuꞌna̱j Andrés a. Dan me se ga̱a queneꞌen Jesucristó man ro̱j soꞌ, ne̱ nicu̱nꞌ ro̱j soꞌ tuꞌva na lacuaná, ne̱ tiguíj ro̱j soꞌ nanj rque na, ne̱ dan me se síí rii xcuaj me ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ne̱ cataj Jesucristó rihaan ro̱j soꞌ a: ―Canoco̱ꞌ ro̱j so̱j manj á. ꞌO̱ se síí naquiꞌyaj chre̱ꞌ xcuaj me ro̱j so̱j, tza̱j ne̱ rej riha̱a̱n níꞌ me se gu̱un ro̱j so̱j síí naquiꞌyaj chre̱ꞌ yuvii̱, qui̱ꞌyáj, ne̱ canoco̱ꞌ nij yuvii̱ manj a ―taj Jesucristó rihaan ro̱j tinu̱j ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ne̱ nu̱ꞌ canica̱j ro̱j soꞌ tanáj ro̱j soꞌ xnánj ro̱j soꞌ, ne̱ canocoꞌ ro̱j soꞌ man Jesucristó caꞌanj ro̱j soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Veé dan, ne̱ cachéé nij soꞌ doj, ne̱ queneꞌen Jesucristó man yavíj ro̱j tinu̱j ro̱j soꞌ a. Yoꞌo̱ soꞌ me síí cuꞌna̱j Jacobo, ne̱ tinúú soꞌ me síí cuꞌna̱j Juan, ne̱ taꞌníí síí cuꞌna̱j Zebedeo me ro̱j tinu̱j ro̱j soꞌ a. Dan me se nu̱u̱ ro̱j soꞌ rque rihoo chéé rihaan na ga̱ rej ro̱j soꞌ síí cuꞌna̱j Zebedeo, ne̱ naquiꞌyaj sa̱ꞌ nij soꞌ nanj rii xcuaj, ne̱ canacúún Jesucristó man ro̱j tinu̱j ro̱j soꞌ canoco̱ꞌ ro̱j soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Veé dan, ne̱ canica̱j ro̱j soꞌ tanáj ro̱j soꞌ rihoo do̱ꞌ, rej ro̱j soꞌ do̱ꞌ, ne̱ canocoꞌ ro̱j soꞌ man Jesucristó caꞌanj ro̱j soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Veé dan, ne̱ cachéé Jesucristó nu̱ꞌ estadó Galilea, ne̱ tucuꞌyón soꞌ se‑na̱na̱ Diose̱ man nij yuvii̱ nuu chre̱ꞌ rá veꞌ tucuꞌyón nij yuvii̱ israelitá se‑tucua̱nj Moisés, ne̱ caꞌmii natáj soꞌ nana̱ sa̱ꞌ rihaan nij yuvii̱ cheꞌé yan gu̱un chij Diose̱ rihaan chumii̱ nihánj me nana̱ sa̱ꞌ caꞌmii natáj soꞌ a. Ne̱ nahuun cunuda̱nj nij yuvii̱ ranꞌ do̱ꞌ, cunuda̱nj nij yuvii̱ ninaj do̱ꞌ, quiꞌyaj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ne̱ cuchiꞌ nana̱ cheꞌé soꞌ nu̱ꞌ estadó Siria, ga̱a ne̱ nica̱j ndoꞌo nij yuvii̱ tuviꞌ nij yuvii̱ síí ranꞌ ndoꞌo, caꞌanj nij yuvii̱ rej va̱j Jesucristó a. Dan me se nij yuvii̱ ranꞌ ndoꞌo quiꞌyaj chiꞌii̱ do̱ꞌ, nij yuvii̱ aꞌngaj ndoꞌo cúú man do̱ꞌ, nij yuvii̱ nu̱u̱ nana̱ chre̱e nimán do̱ꞌ, nij yuvii̱ snúú quiꞌyaj yavii do̱ꞌ, nij yuvii̱ naꞌvee cache̱e̱ do̱ꞌ, cuchiꞌ rihaan Jesucristó, quiꞌyaj tuviꞌ nij yuvii̱, ne̱ nahuun cunuda̱nj nij soꞌ, quiꞌyaj Jesucristó na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Veé dan, ne̱ canocoꞌ queꞌe̱e̱ ndoꞌo yuvii̱ man soꞌ, ne̱ dan me se yuvii̱ ma̱n estadó Galilea do̱ꞌ, yuvii̱ ma̱n rej cuꞌna̱j Chi̱ꞌ Chumanꞌ do̱ꞌ, yuvii̱ ma̱n chumanꞌ Jerusalén do̱ꞌ, yuvii̱ ma̱n estadó Judea do̱ꞌ, yuvii̱ ma̱n nda̱a rne̱j tuꞌva chráá cuꞌna̱j Jordán do̱ꞌ, canocoꞌ man soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Queneꞌen Jesucristó ma̱n ndoꞌo yuvii̱ nu̱ꞌ anica̱j xꞌnúú soꞌ, ne̱ cheꞌé dan cavii soꞌ caꞌanj soꞌ raa̱ ꞌo̱ quij, ne̱ nda̱a dan caꞌanj ca̱yáán soꞌ, ga̱a ne̱ cuchiꞌ nij síí tucuꞌyón se‑na̱na̱ soꞌ rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ga̱a ne̱ guun cheꞌe̱ Jesucristó tucuꞌyón Jesucristó rihaan nij soꞌ, cataj soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Cavi̱i̱ sa̱ꞌ taranꞌ nij síí vaa nica̱ꞌ nimán ado̱nj. ꞌO̱ se nij soꞌ me síí ca̱yáán ga̱ Diose̱ güii gu̱un chij Diose̱ rihaan chumii̱ nihánj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","”Cavi̱i̱ sa̱ꞌ taranꞌ nij síí nanó ndoꞌo rá ado̱nj. ꞌO̱ se gu̱un niha̱ꞌ nimán maꞌa̱n nij soꞌ, quiꞌya̱j Diose̱ vaa güii ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","”Cavi̱i̱ sa̱ꞌ taranꞌ nij síí niꞌya̱nj aꞌmii ado̱nj. ꞌO̱ se gu̱un toꞌóó maꞌa̱n nij soꞌ man nu̱ꞌ chumii̱ vaa güii ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","”Cavi̱i̱ sa̱ꞌ taranꞌ nij síí me ndoꞌo rá cunu̱u sa̱ꞌ nimán ado̱nj. ꞌO̱ se cunu̱u sa̱ꞌ maꞌa̱n nij soꞌ vaa güii, quiꞌya̱j Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","”Cavi̱i̱ sa̱ꞌ taranꞌ nij síí ꞌe̱e̱ rá man tuviꞌ ado̱nj. ꞌO̱ se cunu̱u ꞌe̱e̱ rá Diose̱ man maꞌa̱n nij soꞌ, ne̱ taj sayuun quira̱nꞌ nij soꞌ, quiꞌya̱j Diose̱ a̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","”Cavi̱i̱ sa̱ꞌ taranꞌ nij síí vaa sa̱ꞌ nimán ado̱nj. ꞌO̱ se queneꞌe̱n maꞌa̱n nij soꞌ man Diose̱ vaa güii ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","”Cavi̱i̱ sa̱ꞌ taranꞌ nij síí nacaj man síí me rá cunu̱ꞌ ado̱nj. ꞌO̱ se ase vaa Diose̱ roꞌ, da̱nj ga̱a̱ maꞌa̱n nij soꞌ vaa güii ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","”Cavi̱i̱ sa̱ꞌ taranꞌ nij síí ranꞌ sayuun ꞌyaj tuviꞌ cheꞌé se veꞌé ꞌyaj sa̱ꞌ nij soꞌ ado̱nj. ꞌO̱ se ca̱yáán maꞌa̱n nij soꞌ ga̱ Diose̱ güii gu̱un chij Diose̱ rihaan chumii̱ nihánj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","”Ne̱ cavi̱i̱ sa̱ꞌ ndoꞌo soj sese caꞌmi̱i̱ yuvii̱ nana̱ nij rihaan soj do̱ꞌ, sese quiꞌya̱j yuvii̱ sayuun man soj do̱ꞌ, sese caꞌmi̱i̱ ne̱ yuvii̱ cata̱j yuvii̱ se vaa tumé ndoꞌo soj cacunꞌ do̱ꞌ, cheꞌé se me soj síí noco̱ꞌ mán ꞌu̱nj ado̱nj. Ne̱ queneꞌe̱n soj se vaa ya̱ cavi̱i̱ sa̱ꞌ soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ga̱a ne̱ no̱ xcúún soj gu̱un niha̱ꞌ uxrá rá soj, cheꞌé se uxrá na̱ruꞌvee Diose̱ rihaan soj asa̱ꞌ nucuiꞌ soj rej xta̱ꞌ ado̱nj. ꞌO̱ se ase vaa ꞌyaj nii sayuun man soj roꞌ, taꞌngaꞌ da̱nj quiꞌyaj nii sayuun man nij síí nataꞌ se‑na̱na̱ Diose̱ rihaan yuvii̱ ga̱a naá uún ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","”Ase vaa yaan ga̱ chraa roꞌ, da̱nj vaa soj ga̱ chumii̱ nihánj ei. Dan me se sese ne ꞌne̱ꞌ chá yaan yoꞌ, ga̱a ne̱ taj se qui̱ꞌyáꞌ cunu̱u sa̱ꞌ yaan ga̱a̱ a̱ maꞌ. Taj se gúnꞌ man yaan yoꞌ ga̱a̱ maꞌ. Ma̱a̱n se quiriꞌi̱j nii man yaan yoꞌ xeꞌ, ne̱ cache̱e̱ u̱u̱n yuvii̱ xráá yaan yoꞌ na̱nj ei. Ne̱ da̱nj vaa uún soj ei. Sese taj se gúnꞌ man soj rihaan chumii̱ nihánj, ne̱ daj chiha̱a̱ míj se̱ cavii sa̱ꞌ soj a̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","”Ne̱ ase vaa yaꞌan vaa soj chuguu̱n soj rihaan chumii̱ nihánj a. Neꞌen soj se vaa sese na̱j ꞌo̱ chumanꞌ raa̱ tacaan, ne̱ queneꞌe̱n cunuda̱nj yuvii̱ naj chumanꞌ yoꞌ raa̱ tacaan ei. ");
INSERT INTO trcNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ne̱ ga̱a rmi̱ꞌ, ne̱ a̱ ꞌó yuvii̱ utaꞌ yaꞌan raa̱ agaꞌ yaꞌan ne̱ axríj yuve̱ nij soꞌ rque ꞌo̱ chrúún maꞌ. Sese rmi̱ꞌ, ne̱ achrón nii yaꞌan raa̱ agaꞌ yaꞌan ne̱ utaꞌ nii agaꞌ yoꞌ rej xta̱ꞌ, ne̱ daj a̱ nij yuvii̱ atúj rá veꞌ roꞌ, chuguu̱n niꞌya̱j nij soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ne̱ veé da̱nj vaa gue̱e̱ soj, ne̱ ase vaa agaꞌ yaꞌan roꞌ, vaa soj rihaan chumii̱ nihánj, ne̱ sese sa̱ꞌ quiꞌya̱j soj, ne̱ sa̱ꞌ doj xca̱j yuvii̱ cuentá, quiꞌya̱j soj ei. Cheꞌé dan se̱ guun naꞌa̱j soj queneꞌe̱n yuvii̱ da̱j vaa ꞌyaj soj maꞌ. Tana̱nj gu̱un niha̱ꞌ rá soj queneꞌe̱n yuvii̱ se vaa veꞌé ꞌyaj soj, ne̱ cheꞌé dan da̱nj na̱nj veꞌé caꞌmi̱i̱ nij yuvii̱ cheꞌé Rej níꞌ Diose̱, quiꞌya̱j soj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","”Se̱ guun rá soj se vaa caꞌnáꞌ ꞌu̱nj ti̱ríꞌ ꞌu̱nj se‑tucua̱nj Moisés tucuáán cuchruj soꞌ ga̱a naá maꞌ. Se̱ guun rá soj se vaa caꞌnáꞌ ꞌu̱nj ti̱ríꞌ ꞌu̱nj nana̱ caꞌmii natáj nij síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá maꞌ. Nuveé cheꞌe̱ yoꞌ caꞌnaj maꞌ. Tana̱nj caꞌnaj cheꞌé rej quinavi̱j quisi̱j nu̱ꞌ tucuáán yoꞌ, ga̱a ne̱ nari̱ꞌ nu̱ꞌ soj da̱j me rá Diose̱ quiꞌya̱j soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ya̱ uxrá cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa ga̱a ataa navi̱j chumii̱ nihánj do̱ꞌ, ga̱a ataa navi̱j xta̱ꞌ nihánj do̱ꞌ, ne̱ quiꞌya̱j Diose̱ nu̱ꞌ se vaa me rá Diose̱ quiꞌya̱j Diose̱ rihaan chumii̱ nihánj, ne̱ cheꞌé dan se̱ tanáj xco̱ níꞌ a̱ ꞌó nana̱ rqué Diose̱ rihaan níꞌ canoco̱ꞌ níꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Dan me se me maꞌa̱n ꞌo̱ síí tiri̱ꞌ ꞌo̱ nana̱ leꞌe̱j aꞌmij nihánj ne̱ ino̱ vaa nana̱ ti̱haa̱n soꞌ man nij tuviꞌ soꞌ, ne̱ asa̱ꞌ guun chij Diose̱, ne̱ gu̱un soꞌ síí leꞌe̱j uxrá rihaan Diose̱ na̱nj ado̱nj. Tza̱j ne̱ sese me maꞌa̱n ꞌo̱ síí ꞌyaj ya̱ nda̱a vaa taj ꞌu̱nj nihánj ne̱ ti̱haa̱n ya̱ soꞌ man tuviꞌ soꞌ nda̱a vaa taj ꞌu̱nj nihánj, ne̱ síí nihánj roꞌ, me síí gu̱un síí chij rej gu̱un chij Diose̱ vaa güii ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","”ꞌO̱ se cata̱j xnaꞌanj ꞌu̱nj rihaan soj, ne̱ sese nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ ga̱ nij síí fariseo me se ꞌyaj sa̱ꞌ nij soꞌ rihaan yuvii̱, rá nij soꞌ, tza̱j ne̱ sese se̱ quiꞌyaj sa̱ꞌ soj doj rihaan nij yuvii̱ nda̱a vaa ꞌyaj nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés ga̱ nij síí fariseo, ga̱a ne̱ daj chiha̱a̱ míj se̱ cayáán soj ga̱ Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj a̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","”A̱j neꞌen soj nana̱ nihánj nana̱ caꞌnaꞌ rihaan nij síí ma̱n ga̱a naá ei: “Se̱ ticaviꞌ soj man yuvii̱ maꞌ. Dan me se quiꞌya̱j Diose̱ sayuun man cunuda̱nj yuvii̱ ticaviꞌ tuviꞌ ado̱nj”, me nana̱ caꞌnaꞌ rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tza̱j ne̱ ꞌu̱nj nihánj me se cata̱j xnaꞌanj ꞌu̱nj, ne̱ a̱ me maꞌa̱n ꞌo̱ síí caꞌmaan rá niꞌya̱j man tinúú, ne̱ a̱j tumé soꞌ cacunꞌ rihaan Diose̱, ne̱ veé da̱nj quiꞌya̱j Diose̱ sayuun man soꞌ uún ado̱nj. Ne̱ a̱ me maꞌa̱n síí cata̱j rihaan tuviꞌ: “Síí snúú rmaꞌa̱n mé so̱ꞌ ei”, cata̱j soꞌ rihaan tinúú soꞌ, ne̱ a̱j tumé ndoꞌo soꞌ cacunꞌ rihaan Diose̱ na̱nj ado̱nj. Ne̱ a̱ me maꞌa̱n ꞌo̱ síí cata̱j rihaan tuviꞌ se vaa mayán tuviꞌ soꞌ me se vaa cheꞌé caꞌa̱nj maꞌa̱n soꞌ rihaan yaꞌan caca̱a̱ soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","”Cheꞌé dan me sese caꞌa̱nj ni̱caj so̱ꞌ rasu̱u̱n rihaan chraan altar, rque̱ so̱ꞌ rasu̱u̱n gue̱e̱ rihaan Diose̱, rá so̱ꞌ, ne̱ sese ninuj rá so̱ꞌ se vaa quiꞌyáá so̱ꞌ cacunꞌ man tinúú so̱ꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ne̱ se̱ guun go̱ꞌ so̱ꞌ rasu̱u̱n yoꞌ rihaan Diose̱ maꞌ. Ma̱a̱n se cuchru̱j so̱ꞌ rasu̱u̱n yoꞌ rihaan yoꞌóó, ne̱ caꞌa̱nj so̱ꞌ rej ya̱nj tinúú so̱ꞌ, ga̱a ne̱ naꞌmi̱i̱ sa̱ꞌ so̱ꞌ ga̱ soꞌ, ga̱a ne̱ ca̱nica̱j so̱ꞌ rej na̱j siꞌyáá so̱ꞌ, ga̱a ne̱ rque̱ so̱ꞌ siꞌyáá so̱ꞌ rihaan Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","”Ne̱ so̱ꞌ me se sese vaa síí taj se vaa nij quiꞌyáá so̱ꞌ rihaan soꞌ, ne̱ ga̱a tiha̱j vaj so̱ꞌ chrej ga̱ soꞌ, ne̱ veꞌé caꞌmi̱i̱ so̱ꞌ ga̱ soꞌ, cata̱j so̱ꞌ rihaan soꞌ se vaa: “Caꞌne̱ꞌ rá so̱ꞌ, ne̱ se̱ cutáꞌ so̱ꞌ cacunꞌ xráj maꞌ”, cata̱j so̱ꞌ, ne̱ veꞌé caꞌmi̱i̱ so̱ꞌ ga̱ soꞌ á. Ne̱ sese se̱ quiꞌyáá so̱ꞌ da̱nj veꞌé caꞌmi̱i̱ so̱ꞌ ga̱ soꞌ ga̱a tiha̱j vaj ro̱j so̱j chrej rihaan chumii̱ nihánj, ne̱ ni̱caj soꞌ mán so̱ꞌ caꞌa̱nj soꞌ rihaan cuese̱, ne̱ cuese̱ yoꞌ roꞌ, ta̱cuachén mán so̱ꞌ raꞌa síí tumé tagaꞌ, ne̱ soꞌ me síí caxri̱i̱ tagaꞌ mán so̱ꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ne̱ yoꞌ me se gu̱un ra̱a̱n ndoꞌo so̱ꞌ, ne̱ nda̱a navij na̱ruꞌvee so̱ꞌ nu̱ꞌ cacunꞌ quiꞌyáá so̱ꞌ, ga̱a ne̱ cu̱riha̱nj so̱ꞌ tagaꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","”A̱j neꞌen soj nana̱ nihánj a: “O̱rúnꞌ nica̱ soj coto̱j ga̱ soj á”, me nana̱ caꞌnaꞌ rihaan soj ga̱a naá a. ");
INSERT INTO trcNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ne̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa na̱j guun síí niꞌya̱j niꞌya̱j man yoꞌó chana̱, ne̱ cheꞌé rej gu̱un ndoꞌo rá soꞌ coto̱j soꞌ ga̱ noꞌ roꞌ, ase vaa nimán síí otoj ga̱ yoꞌó chana̱ roꞌ, taꞌngaꞌ da̱nj vaa nimán síí niꞌya̱j ndoꞌo man yoꞌó chana̱ yoꞌ na̱nj ado̱nj. Ne̱ tumé ya̱ soꞌ cacunꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Da̱nj na̱nj uún, ne̱ sese ꞌo̱ rlij rihaan so̱ꞌ rej nuva̱ꞌ so̱ꞌ me rá quiꞌya̱j cacunꞌ, ne̱ táá a̱ se quiri̱i̱ so̱ꞌ man yoꞌ, ne̱ taj se ꞌyaj maꞌ. Caꞌve̱e a̱ doj quiri̱ꞌ o̱rúnꞌ yoꞌ ne̱ se̱ cacaa nu̱ꞌ nee̱ mán so̱ꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Da̱nj na̱nj uún, ne̱ sese ꞌo̱ raꞌá so̱ꞌ rej nuva̱ꞌ so̱ꞌ me rá quiꞌya̱j cacunꞌ, ne̱ táá a̱ se caꞌne̱ꞌ so̱ꞌ man yoꞌ, ne̱ taj se ꞌyaj maꞌ. Caꞌve̱e a̱ doj caꞌa̱nj niꞌya̱ o̱rúnꞌ yoꞌ ne̱ se̱ caꞌanj niꞌya̱ cunuda̱nj nee̱ man ma̱ꞌán so̱ꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","”Ne̱ ga̱a naá me se caꞌnaꞌ nana̱ nihánj a: “Sese me rá yoꞌo̱ soꞌ quiriꞌi̱j soꞌ nica̱ soꞌ, ne̱ na̱xcaj soꞌ ꞌo̱ yanj cata̱j xnaꞌanj se vaa ya̱ quiriꞌíj soꞌ nica̱ soꞌ á”. Da̱nj vaa nana̱ caꞌnaꞌ rihaan nij yuvii̱ ei. ");
INSERT INTO trcNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ne̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa sese quiriꞌi̱j yoꞌo̱ soꞌ man nica̱ soꞌ, ne̱ sese nuviꞌ cacunꞌ tumé noꞌ se vaa cotoj noꞌ ga̱ yoꞌó chii, ne̱ maꞌa̱n síí riꞌíj man noꞌ quiꞌyaj tumé noꞌ cacunꞌ ga̱a̱ ei. Ne̱ cheꞌé se quiriꞌíj nica̱ chana̱ man noꞌ, cheꞌé dan xca̱j noꞌ yoꞌó snóꞌo, ne̱ ase vaa chana̱ otoj ga̱ na̱j guun snóꞌo roꞌ, da̱nj ga̱a̱ maꞌa̱n noꞌ, quiꞌyaj síí quiriꞌíj man noꞌ ado̱nj. Ne̱ síí xcaj man chana̱ quiriꞌíj nica̱ me se ase vaa síí otoj ga̱ nica̱ yoꞌó snóꞌo roꞌ, vaa uún soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","”Ne̱ a̱j neꞌen soj nana̱ nihánj nana̱ caꞌnaꞌ rihaan nij síí ma̱n ga̱a naá ado̱nj: “Sese cataꞌ tuꞌvá so̱ꞌ rihaan síí ꞌni̱j raꞌa man níꞌ se vaa qui̱ꞌyáá so̱ꞌ, ne̱ se̱ caꞌneꞌ rá so̱ꞌ qui̱ꞌyáá so̱ꞌ da̱nj maꞌ. Ma̱a̱n se ya̱ qui̱ꞌyáá so̱ꞌ nu̱ꞌ se vaa cataj xnaꞌanj so̱ꞌ rihaan soꞌ, ga̱a ne̱ caꞌve̱e na̱nj ado̱nj”. ");
INSERT INTO trcNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ne̱ cuano̱ nihánj roꞌ, cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa asa̱ꞌ caꞌmii soj ꞌo̱ nana̱ guun ya̱ ya̱ rá soj, ne̱ daj chiha̱a̱ míj se̱ cutaꞌ soj raa̱ xta̱ꞌ maꞌ. ꞌO̱ se xta̱ꞌ roꞌ, nicunꞌ maꞌa̱n Diose̱ ya̱ ya̱ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ne̱ raa̱ chumii̱ se̱ cutaꞌ soj maꞌ. ꞌO̱ se chumii̱ nihánj me rej ta̱j tacóó Diose̱ na̱nj ado̱nj. Ne̱ raa̱ chumanꞌ Jerusalén se̱ cutaꞌ soj maꞌ. Ése̱ chumanꞌ yoꞌ ne maꞌa̱n Diose̱ síí nica̱j yuꞌunj man níꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ne̱ raa̱ maꞌa̱n soj se̱ cutaꞌ soj maꞌ. ꞌO̱ se se̱ guun nucua̱j soj naquiꞌya̱j catzi̱i̱ soj yoꞌo̱ yuvé raa̱ soj, ne̱ se̱ guun nucua̱j soj naquiꞌya̱j maruu̱ soj yoꞌo̱ yuvé raa̱ soj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Veé dan, ne̱ sese ya̱ aꞌmii soj, rá soj, ne̱ cata̱j soj: “Ya̱ ei”. Ne̱ sese ne ya̱ vaa ꞌo̱ nana̱, rá soj, ne̱ cata̱j soj: “Ne ya̱ maꞌ”, cata̱j soj á. Ina̱nj da̱nj caꞌmi̱i̱ soj ei. Sese nano̱ꞌ soj yoꞌó nana̱, ne̱ chiꞌi̱i̱ vaa nimán soj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","”A̱j neꞌen soj nana̱ nihánj nana̱ caꞌnaꞌ ga̱a naá a: “Sese curiha̱nj rlij rihaan so̱ꞌ quiꞌyaj tuvíꞌ so̱ꞌ, ne̱ caꞌve̱e quiri̱i̱ so̱ꞌ rlij rihaan tuvíꞌ so̱ꞌ á. Ne̱ sese curiha̱nj cúú yánꞌ so̱ꞌ, quiꞌyaj tuvíꞌ so̱ꞌ, ne̱ caꞌve̱e quiri̱i̱ so̱ꞌ cúú yanꞌ tuvíꞌ so̱ꞌ á”. Da̱nj vaa nana̱ caꞌnaꞌ rihaan yuvii̱ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tza̱j ne̱ cuano̱ nihánj roꞌ, cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa se̱ quiꞌyaj soj sayuun man síí ꞌyaj sayuun man soj maꞌ. Tana̱nj sese vaa síí coxro ni̱chrej xruú so̱ꞌ, ga̱a ne̱ caꞌne̱ꞌ rá so̱ꞌ coxro̱ soꞌ níchrej xruú so̱ꞌ uún ei. ");
INSERT INTO trcNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ne̱ sese me rá yoꞌo̱ soꞌ cuta̱ꞌ soꞌ cacunꞌ xráá so̱ꞌ rihaan cuese̱ caꞌne̱e̱ soꞌ cotoó nu̱u̱ so̱ꞌ, ne̱ go̱ꞌ u̱u̱n so̱ꞌ cotoó yoꞌ do̱ꞌ, nda̱a se‑ro̱to̱ so̱ꞌ do̱ꞌ, go̱ꞌ so̱ꞌ man soꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ne̱ sese caꞌne̱ꞌ yoꞌo̱ soꞌ suun rihaan so̱ꞌ caꞌa̱nj ta̱náj so̱ꞌ siꞌyaj soꞌ yoꞌo̱ kilómetro, ne̱ caꞌve̱j so̱ꞌ caꞌa̱nj ta̱náj so̱ꞌ siꞌyaj soꞌ nda̱a vi̱j kilómetro ei. ");
INSERT INTO trcNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Sese achíín yoꞌo̱ soꞌ rasu̱u̱n mán so̱ꞌ, ne̱ go̱ꞌ so̱ꞌ se achiin man soꞌ ei. Ne̱ sese me rá yoꞌo̱ soꞌ ra̱cuíj so̱ꞌ saꞌanj man soꞌ, ne̱ se̱ cataj so̱ꞌ se vaa taj va̱j saꞌanj maꞌ. Ra̱cuíj so̱ꞌ man soꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","”A̱j neꞌen soj nana̱ nihánj nana̱ caꞌnaꞌ ga̱a naá a: “Ga̱a̱ ꞌe̱e̱ rá so̱ꞌ man tuvíꞌ so̱ꞌ, tza̱j ne̱ se̱ guun ga̱a̱ ꞌe̱e̱ rá so̱ꞌ man nij síí ta̱j riꞌyunj mán so̱ꞌ maꞌ”. Da̱nj vaa nana̱ caꞌnaꞌ ga̱a naá na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tza̱j ne̱ cuano̱ nihánj me cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa no̱ xcúún soj cunu̱u ꞌe̱e̱ rá soj ni̱ꞌyaj soj man nij síí ta̱j riꞌyunj man soj, ne̱ cachi̱nj niꞌya̱j soj rihaan Diose̱ cheꞌé nij síí ꞌyaj sayuun man soj á. ");
INSERT INTO trcNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ga̱a ne̱ gu̱un soj taꞌníí Rej soj Diose̱ síí nicu̱nꞌ xta̱ꞌ ei. ꞌO̱ se Diose̱ ꞌyaj síj güii, ne̱ oꞌ naán rihaan toꞌóó nij síí chiꞌi̱i̱ do̱ꞌ, rihaan toꞌóó nij síí sa̱ꞌ do̱ꞌ, ꞌyaj Diose̱, ne̱ amanꞌ rihaan toꞌóó nij síí ꞌyaj sa̱ꞌ do̱ꞌ, rihaan toꞌóó nij síí ꞌyaj chiꞌi̱i̱ do̱ꞌ, ꞌyaj uún Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ꞌO̱ se sese ꞌe̱e̱ rá soj man ina̱nj nij síí ꞌe̱e̱ rá man soj, ga̱a ne̱ me cheꞌé na̱ruꞌvee Diose̱ rihaan soj, rá soj ga̱. ꞌO̱ se neꞌen soj se vaa nda̱a nij síí tihaꞌ yuꞌunj man soj cheꞌé puextó roꞌ, ꞌe̱e̱ rá nij soꞌ man tuviꞌ maꞌa̱n nij soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Cheꞌé dan, sese veꞌé aꞌmii soj ga̱ ina̱nj tinúú soj, ne̱ sa̱ꞌ doj vaa soj rihaan yoꞌó nij yuvii̱, rá soj naꞌ. Taj maꞌ. Ne̱ nda̱a nij síí ne neꞌen da̱j vaa Diose̱ roꞌ, neꞌen soj se vaa ꞌe̱e̱ rá nij soꞌ man tuviꞌ maꞌa̱n nij soꞌ na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Cheꞌé dan sese nuveé si̱j tihaꞌ yuꞌunj do̱ꞌ, si̱j yaníj do̱ꞌ, me soj, ne̱ no̱ xcúún soj gu̱un soj síí vaa sa̱ꞌ ina̱nj nimán ado̱nj. Ne̱ ase vaa síí sa̱ꞌ ina̱nj me Diose̱ roꞌ, da̱nj ga̱a̱ maꞌa̱n soj, síí sa̱ꞌ ina̱nj gu̱un soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","”Ne̱ cu̱tumé soj man soj ga̱a ꞌyaj soj se sa̱ꞌ do̱ꞌ, se lu̱j do̱ꞌ á. Se̱ guun rá soj queneꞌe̱n yuvii̱ man soj ne̱ cata̱j nij yuvii̱ cheꞌé soj se vaa síí sa̱ꞌ ina̱nj me soj maꞌ. Sese da̱nj quiꞌya̱j soj, ne̱ daj chiha̱a̱ míj se̱ rqué Rej soj síí nicu̱nꞌ xta̱ꞌ a̱ doj rasu̱u̱n sa̱ꞌ man soj a̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Cheꞌé dan sese me rá so̱ꞌ rque̱ so̱ꞌ saꞌanj man nij síí nique̱, ne̱ se̱ guun rá so̱ꞌ caꞌya̱nj nii chruun aꞌyánj qui̱ꞌyáá so̱ꞌ, ne̱ ni̱ꞌyaj yuvii̱ go̱ꞌ so̱ꞌ saꞌanj man síí nique̱, ne̱ cata̱j nij yuvii̱ se vaa veꞌé quiꞌyáá so̱ꞌ maꞌ. ꞌO̱ se ina̱nj da̱nj ꞌyaj nij síí nucuiꞌ rá ga̱a va̱j nij soꞌ rá veꞌ tucuꞌyón níꞌ se‑tucua̱nj Moisés do̱ꞌ, rihaan nij callé do̱ꞌ, ne̱ uno cunuda̱nj yuvii̱, ꞌyaj nij soꞌ ado̱nj. Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa a̱j veꞌé caꞌmii yuvii̱ cheꞌé nij soꞌ, tza̱j ne̱ a̱ ꞌó rasu̱u̱n se̱ quiriꞌ uún nij soꞌ a̱ maꞌ. A̱ ꞌó xcoꞌ se̱ naruꞌvee Diose̱ rihaan nij soꞌ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tza̱j ne̱ so̱ꞌ roꞌ, sese me rá so̱ꞌ rque̱ so̱ꞌ saꞌanj man nij síí nique̱, ne̱ se̱ natáꞌ so̱ꞌ rihaan yuvii̱ da̱j ꞌyáá so̱ꞌ maꞌ. Dan me se daj chiha̱a̱ míj se̱ cataj xnaꞌanj so̱ꞌ rihaan raꞌá so̱ꞌ rej ni̱chruún so̱ꞌ se vaa rqué raꞌá so̱ꞌ rej nuva̱ꞌ so̱ꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Asa̱ꞌ quisíj rqué yuve̱ so̱ꞌ saꞌanj yoꞌ, ga̱a ne̱ o̱rúnꞌ Réé so̱ꞌ Diose̱ me síí queneꞌe̱n da̱j quiꞌyaj yuve̱ so̱ꞌ, ga̱a ne̱ soꞌ me síí na̱ruꞌvee rihaan so̱ꞌ queneꞌe̱n cunuda̱nj yuvii̱ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","”Ne̱ ga̱a achíín niꞌya̱j soj rihaan Diose̱, ne̱ se̱ quiꞌyaj soj se vaa ꞌyaj nij síí nucuiꞌ rá maꞌ. ꞌO̱ se niha̱ꞌ rá nij soꞌ canicu̱nꞌ nij soꞌ rá veꞌ tucuꞌyón yuvii̱ se‑tucua̱nj Moisés, ne̱ niha̱ꞌ rá nij soꞌ canicu̱nꞌ nij soꞌ rej nuná tuviꞌ chrej caꞌa̱a̱n noco̱o, ne̱ achíín niꞌya̱j nij soꞌ rihaan Diose̱, tza̱j ne̱ ina̱nj me rá nij soꞌ queneꞌe̱n yuvii̱ man nij soꞌ, ne̱ veꞌé caꞌmi̱i̱ yuvii̱ cheꞌé nij soꞌ, rá nij soꞌ ado̱nj. Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa a̱j veꞌé caꞌmii yuvii̱ cheꞌé nij soꞌ, ne̱ a̱j navij quiriꞌ nij soꞌ tuꞌvee nij soꞌ vaa, ne̱ a̱ ꞌó xcoꞌ se̱ naruꞌvee uún Diose̱ rihaan nij soꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tza̱j ne̱ so̱ꞌ roꞌ, ga̱a me rá so̱ꞌ cachi̱nj ni̱ꞌyáá so̱ꞌ rihaan Diose̱, ne̱ asino catu̱u̱ so̱ꞌ rá veꞌ, ga̱a ne̱ ca̱ráán so̱ꞌ taꞌyaa, ga̱a ne̱ cachi̱nj niꞌya̱j yuve̱ so̱ꞌ rihaan Rej níꞌ Diose̱ á. Ne̱ Rej níꞌ Diose̱ me síí neꞌen se vaa achíín niꞌya̱j niga̱nj so̱ꞌ rihaan soꞌ, ne̱ na̱ruꞌvee soꞌ rihaan so̱ꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ne̱ ga̱a achíín niꞌya̱j soj rihaan Diose̱, ne̱ se̱ quiꞌyaj soj se vaa ꞌyaj nij síí ne neꞌen da̱j vaa Diose̱ maꞌ. Dan me se aꞌmii rmaꞌa̱n ndoꞌo nij soꞌ nana̱, tza̱j ne̱ ne neꞌen nij soꞌ me taj nana̱ yoꞌ maꞌ. Ma̱a̱n cheꞌé se aꞌmii aꞌmii nij soꞌ, cheꞌé dan gu̱un niha̱ꞌ rá Diose̱ ne̱ cuno̱ Diose̱ nu̱ꞌ nana̱ aꞌmii nij soꞌ, rá nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Cheꞌé dan se̱ quiꞌyaj soj da̱nj maꞌ. ꞌO̱ se asi̱j ataa cachi̱nj niꞌya̱j soj rihaan Rej soj Diose̱, ne̱ a̱j neꞌen soꞌ nu̱ꞌ se vaa achiin man soj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","”Cheꞌé dan asa̱ꞌ achíín niꞌya̱j soj, ne̱ nihánj cata̱j soj á: “Ata̱j Chij síí nicu̱nꞌ xta̱ꞌ, me rá núj xca̱j yuvii̱ cuentá se vaa ina̱nj sa̱ꞌ ꞌyáá so̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ne̱ me rá núj quisi̱j güii gu̱un chij so̱ꞌ rihaan chumii̱ nihánj, ne̱ me rá núj quiꞌya̱j yuvii̱ nu̱ꞌ se vaa me rá so̱ꞌ quiꞌya̱j yuvii̱ a. Dan me se ase vaa ꞌyaj nij síí ma̱n xta̱ꞌ nu̱ꞌ se vaa me rá so̱ꞌ quiꞌya̱j nij soꞌ roꞌ, da̱nj ga̱a̱ quiꞌya̱j núj si̱j ma̱n rihaan chumii̱ nihánj nu̱ꞌ se vaa me rá so̱ꞌ quiꞌya̱j núj, rá núj a. ");
INSERT INTO trcNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ne̱ rque̱ so̱ꞌ nu̱ꞌ rasu̱u̱n achiin rihaan núj cha̱ núj cuanꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ne̱ cara̱a̱ xꞌnaa so̱ꞌ cheꞌé xcúún ta̱j xráá núj rihaan so̱ꞌ á. Dan me se ase vaa quiꞌyaj núj caráj xꞌnaa núj cheꞌé cacunꞌ quiꞌyaj tuviꞌ núj rihaan núj roꞌ, taꞌngaꞌ da̱nj qui̱ꞌyáá so̱ꞌ cheꞌé maꞌa̱n núj cara̱a̱ xꞌnaa so̱ꞌ rihaan núj á. ");
INSERT INTO trcNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Dan me se ca̱ráán raꞌá so̱ꞌ xráá núj rihaan chrej chiꞌi̱i̱ á. Ne̱ ti̱nanii so̱ꞌ man núj se̱ guun quiꞌya̱j núj cacunꞌ a”. Ina̱nj da̱nj caꞌmi̱i̱ soj cachi̱nj niꞌya̱j soj rihaan Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ꞌO̱ se sese cara̱a̱ xꞌnaa soj cheꞌé cacunꞌ quiꞌyaj tuviꞌ soj rihaan soj, ne̱ da̱nj quiꞌya̱j uún Rej soj síí nicu̱nꞌ xta̱ꞌ, ne̱ cara̱a̱ xꞌnaa soꞌ rihaan soj uún ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tza̱j ne̱ sese se̱ caꞌvej rá soj cara̱a̱ xꞌnaa soj cheꞌé cacunꞌ quiꞌyaj tuviꞌ soj rihaan soj, ne̱ daj chiha̱a̱ míj se̱ tinavij Rej soj Diose̱ cacunꞌ tumé maꞌa̱n soj a̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","”Ne̱ ga̱a tocoꞌ soj xꞌnaa man soj cheꞌé se aráj gue̱e̱ soj rihaan Diose̱, ne̱ se̱ quiꞌyaj soj nda̱a vaa ꞌyaj nij síí nucuiꞌ rá maꞌ. Dan me se ga̱a aráj gue̱e̱ nij soꞌ, ne̱ ase vaa rihaan síí nanó ndoꞌo rá roꞌ, vaa rihaan nij soꞌ, ꞌyaj nij soꞌ, ne̱ anó ndoꞌo nacaj rihaan nij soꞌ, ꞌyaj uún nij soꞌ, ne̱ me ina̱nj rá nij soꞌ queneꞌe̱n yuvii̱ man nij soꞌ da̱j ꞌyaj nij soꞌ ga̱a ne̱ xca̱j nij yuvii̱ cuentá se vaa aráj gue̱e̱ nij soꞌ rihaan Diose̱, rá nij soꞌ na̱nj ado̱nj. Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa a̱j quiriꞌ nij soꞌ tuꞌvee nij soꞌ vaa, ése̱ a̱j veꞌé caꞌmii yuvii̱ cheꞌé nij soꞌ na̱nj ado̱nj. Ne̱ a̱ ꞌó rasu̱u̱n se̱ quiriꞌ nij soꞌ rihaan Diose̱ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tza̱j ne̱ soj roꞌ, ino̱ quiꞌya̱j soj á. Ga̱a tocoꞌ soj xꞌnaa man maꞌa̱n soj cheꞌé se aráj gue̱e̱ soj rihaan Diose̱, ne̱ cana̱a̱n soj rihaan soj ne̱ caxri̱i̱ soj casté raa̱ soj á. ");
INSERT INTO trcNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Dan me se se̱ guun rá soj queneꞌe̱n yuvii̱ se vaa aráj gue̱e̱ soj a̱ maꞌ. Ne̱ caꞌve̱e se taj va̱j yuvii̱ queneꞌe̱n man soj aráj gue̱e̱ soj, tza̱j ne̱ queneꞌe̱n Rej soj Diose̱ da̱j ꞌyaj soj, ne̱ soꞌ me síí na̱ruꞌvee rihaan soj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","”Se̱ quiꞌyaj suun soj cuma̱n ndoꞌo siꞌyaj soj rihaan chumii̱ nihánj maꞌ. ꞌO̱ se rihaan chumii̱ nihánj mán ndoꞌo xcuu xlúú xíj rasu̱u̱n do̱ꞌ, tacunj yo̱o do̱ꞌ, chá siꞌyaj yuvii̱ nihánj a. Ne̱ vaa síí itu̱u̱ atúj rá veꞌ ne̱ ꞌyaj itu̱u̱ siꞌyaj tuviꞌ uún a. ");
INSERT INTO trcNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ꞌO̱ se taj cheꞌé naquiꞌya̱j ruꞌve̱e̱ soj man soj nihánj maꞌ. Tana̱nj quiꞌya̱j suun ndoꞌo soj cheꞌé yan cuma̱n siꞌyaj soj rej xta̱ꞌ á. Dan me se xta̱ꞌ roꞌ, taj se cha̱ siꞌyaj soj maꞌ. Ne̱ taj síí quiꞌya̱j itu̱u̱ siꞌyaj soj man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ne̱ sese ina̱nj cheꞌé rasu̱u̱n ma̱n rihaan chumii̱ nihánj quiꞌya̱j suun soj, ga̱a ne̱ veé ma̱a̱n rihaan chumii̱ nihánj quina̱j nimán soj ga̱a̱ na̱nj ado̱nj. Ne̱ sese ina̱nj cheꞌé rasu̱u̱n ma̱n xta̱ꞌ roꞌ, quiꞌya̱j suun soj, ga̱a ne̱ veé rej xta̱ꞌ roꞌ, caꞌa̱nj nimán soj na̱nj ado̱nj. Me rej maꞌa̱n araa sa̱ꞌ soj rasu̱u̱n, ne̱ veé rej da̱nj va̱j nimán soj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","”Rlij rihaan níꞌ me yaꞌan nica̱j yuꞌunj man níꞌ ei. Dan me se sese rlij rihaan níꞌ roꞌ, niꞌya̱j yoꞌ ne̱ nuu sa̱ꞌ rá yoꞌ, ga̱a ne̱ nu̱ꞌ nee̱ man níꞌ roꞌ, sa̱ꞌ vaa, ne̱ adi̱ꞌ se chuguu̱n agaꞌ yaꞌan roꞌ, da̱nj chuguu̱n man níꞌ ga̱a sa̱ꞌ rihaan níꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tza̱j ne̱ sese rlij rihaan níꞌ roꞌ, niꞌya̱j yoꞌ ne̱ ina̱nj uun chiꞌi̱i̱ rá yoꞌ, ga̱a ne̱ nu̱ꞌ nee̱ man níꞌ roꞌ, uun chiꞌi̱i̱ rá, ga̱a ne̱ adi̱ꞌ síí nicu̱nꞌ yan rmi̱ꞌ ne̱ cunuda̱nj man soꞌ roꞌ, rmi̱ꞌ, ne̱ da̱nj vaa síí uun chiꞌi̱i̱ rá, ne̱ rmi̱ꞌ uxrá nu̱ꞌ man soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","”Taj va̱j síí gu̱un nucua̱j quiꞌya̱j suun sa̱ꞌ rihaan vi̱j ruꞌvee maꞌ. Sese quiꞌya̱j suun ꞌo̱ soꞌ rihaan vi̱j ruꞌvee, ne̱ nachri̱ꞌ soꞌ ni̱ꞌyaj soꞌ man ꞌo̱ ruꞌvee yoꞌ, ne̱ cara̱nꞌ rá soꞌ ni̱ꞌyaj soꞌ man yoꞌó ruꞌvee yoꞌ a. Se̱ guun nucua̱j soꞌ cara̱nꞌ rá soꞌ ni̱ꞌyaj soꞌ man vi̱j ruꞌvee maꞌ. Ne̱ xa̱ꞌ soj, tza̱j ne̱ se̱ caꞌvee quiꞌya̱j suun soj cheꞌé Diose̱ ne̱ quiꞌya̱j suun soj cheꞌé nij rasu̱u̱n ma̱n rihaan chumii̱ nihánj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","”Cheꞌé dan cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa taj cheꞌé nano̱ ndoꞌo rá soj cheꞌé soj maꞌ. Ne̱ cheꞌé dan se̱ nanó rá soj cheꞌé se cha̱ soj do̱ꞌ, cheꞌé yan quiri̱ꞌ soj se ca̱ráán xráá soj do̱ꞌ, se̱ nanó rá soj maꞌ. Dan me se a̱j neꞌen soj vaa iꞌna̱ꞌ soj, quiꞌyaj Diose̱, ne̱ se̱ guun nucua̱j Diose̱ rque̱ Diose̱ se cha̱ soj, rá soj ga̱a̱ a̱ naꞌ. Daj chiha̱a̱ míj se̱ guun da̱nj rá soj maꞌ. Ne̱ Diose̱ me síí caꞌve̱e rque̱ se cha̱ soj ei. Ne̱ Diose̱ me síí quiꞌyaj nee̱ man soj, ne̱ se̱ guun nucua̱j Diose̱ rque̱ Diose̱ yatzíj ca̱ráán xráá soj, rá soj ga̱a̱ a̱ naꞌ. Daj chiha̱a̱ míj se̱ guun da̱nj rá soj maꞌ. Ne̱ Diose̱ me síí caꞌve̱e rque̱ se ca̱ráán xráá soj ei. ");
INSERT INTO trcNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","”Xca̱j soj cuentá da̱j ꞌyaj nij xtâj va̱j xta̱ꞌ, ne̱ ne unô nij xoꞌ ꞌnúú, ne̱ ne rii nij xoꞌ naa̱, ne̱ ne araa nij xoꞌ tanꞌ rá cuchruu̱, tza̱j ne̱ Rej soj síí nicu̱nꞌ xta̱ꞌ roꞌ, aꞌvee rqué se chá nij xoꞌ ei. Ne̱ táá a̱ soj, ne̱ sa̱ꞌ doj vaa soj rihaan xtâj neꞌen Diose̱ a̱ ado̱nj. Ya̱ sa̱ꞌ doj vaa soj chugua̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ne̱ nda̱ꞌ se nanó ndoꞌo rá soj cheꞌé yan chre̱ꞌ vaa soj, tza̱j ne̱ a̱ ꞌó xcoꞌ se̱ guun nucua̱j soj cachi̱j xca̱a̱n soj doj quiꞌya̱j maꞌa̱n soj maꞌ. Ma̱a̱n Diose̱ roꞌ, me síí neꞌen da̱j ga̱a̱ cachi̱j soj, ne̱ cheꞌé dan taj cheꞌé nano̱ rá soj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","”Ne̱ me cheꞌé nanó rá soj cheꞌé yatzíj ca̱ráán xráá soj ga̱. ꞌO̱ se xca̱j soj cuentá ni̱ꞌyaj soj nij yâj ma̱n tacaan se vaa veꞌé ndoꞌo vaa nij yâj ma̱n tacaan ei. Ne ꞌyaj suun nij yâj, tza̱j ne̱ maꞌa̱n Diose̱ roꞌ, me síí sa̱ꞌ ndoꞌo vaa quiꞌyaj man nij yâj ado̱nj. Ne̱ ne rii nij yâj yuꞌvej maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tza̱j ne̱ adi̱ꞌ se vaa síí ruꞌvee ne̱ sa̱ꞌ uxrá vaa saga̱nꞌ soꞌ roꞌ, vaa nij yatzíj nu̱u̱ nij yâj ado̱nj. Dan me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa síí cuꞌna̱j Salomón síí cane ga̱a naá, ne̱ veꞌé uxrá vaa yatzíj nu̱u̱ soꞌ, quiꞌyaj cunuda̱nj saꞌanj vaa rihaan soꞌ, tza̱j ne̱ nij doj vaa yatzíj nu̱u̱ soꞌ rihaan nij yâj ma̱n tacaan yoꞌ, quiꞌyaj Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Dan me se da̱nj na̱nj nij yâj ma̱n tacaan yoꞌ, tza̱j ne̱ sa̱ꞌ uxrá vaa nij yatzíj nu̱u̱ nij yâj yoꞌ, ꞌyaj Diose̱, ne̱ cuanꞌ roꞌ, mán nij yâj tacaan, tza̱j ne̱ aꞌyuj ne̱ caꞌne̱ꞌ nii man nu̱ꞌ coj do̱ꞌ, yâj do̱ꞌ, ma̱n tacaan, ne̱ cara̱a nii man yoꞌ rihaan yaꞌan, ne̱ caca̱a̱ nu̱ꞌ nij yâj yoꞌ na̱nj ado̱nj. Ne̱ a̱ doj yuꞌvee taj nó yâj yoꞌ a̱ maꞌ. Táá a̱ soj yuvi̱i̱, ne̱ se̱ nanó rá soj maꞌ. Diose̱ me síí rque̱ saga̱nꞌ soj ado̱nj. Tza̱j ne̱ ne gu̱un ya̱ sa̱ꞌ rá soj se vaa Diose̱ me síí ra̱cuíj ya̱ man soj man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","”Dan me se se̱ nanó ndoꞌo rá soj cata̱j soj: “Me se cha̱ níꞌ ga̱. Me se coꞌo̱ níꞌ ga̱. Me se ca̱ráán xráá níꞌ ga̱”. Se̱ guun rá soj da̱nj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ꞌO̱ se nij síí ne neꞌen da̱j vaa Diose̱ roꞌ, ina̱nj ꞌyaj suun ndoꞌo nij soꞌ cheꞌé rasu̱u̱n ma̱n rihaan chumii̱ nihánj ado̱nj. Tza̱j ne̱ nu̱ꞌ rasu̱u̱n achiin man soj roꞌ, a̱j neꞌen Rej soj síí nicu̱nꞌ xta̱ꞌ se vaa achiin nu̱ꞌ rasu̱u̱n yoꞌ man soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Cheꞌé dan nano̱ꞌ soj rej da̱j quiꞌya̱j soj ne̱ gu̱un chij Diose̱ nimán soj ne̱ cunu̱u sa̱ꞌ nimán soj, ga̱a ne̱ rque̱ Diose̱ nu̱ꞌ rasu̱u̱n yoꞌ man soj ei. ");
INSERT INTO trcNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Cheꞌé dan se̱ nanó rá soj cheꞌé se vaa cachi̱in rihaan soj aꞌyuj maꞌ. ꞌO̱ se vaa sayuun ꞌnaꞌ daj a̱ ꞌo̱ ꞌo̱ güii ado̱nj. Cheꞌé dan xca̱j soj cuentá da̱j quiꞌya̱j soj güii cuanꞌ, ne̱ se̱ nanó rá soj cheꞌé se vaa quiꞌya̱j soj güii aꞌyuj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","”Se̱ guun niha̱ꞌ rá soj cuta̱ꞌ soj cacunꞌ xráá tinúú soj, ga̱a ne̱ taj cacunꞌ cuta̱ꞌ Diose̱ xráá maꞌa̱n soj man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Dan me se sese gu̱un niha̱ꞌ rá soj cuta̱ꞌ soj cacunꞌ xráá tinúú soj, ne̱ cuta̱ꞌ Diose̱ cacunꞌ yoꞌ xráá maꞌa̱n soj ei. Ne̱ sese se̱ cutaꞌ soj cacunꞌ xráá tinúú soj, ne̱ cunu̱u ꞌe̱e̱ rá Diose̱ man maꞌa̱n soj uún na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Me cheꞌé guun chre̱e rá so̱ꞌ niꞌya̱j so̱ꞌ niꞌya nu̱u̱ rihaan tinúú so̱ꞌ ga̱. Ne̱ ne ni̱ꞌyaj so̱ꞌ chruun ma̱nj nu̱u̱ rihaan ma̱ꞌán so̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Asa̱ꞌ caꞌve̱e cata̱j so̱ꞌ rihaan tinúú so̱ꞌ, “rque̱ so̱ꞌ rihaan so̱ꞌ quiri̱i̱ ꞌu̱nj niꞌya á”. Se̱ guun a̱ doj cata̱j so̱ꞌ da̱nj ti̱háꞌ so̱ꞌ man tinúú so̱ꞌ maꞌ. ꞌO̱ se ni̱ꞌyaj so̱ꞌ, ne̱ chruun ma̱nj vaa gue̱e̱ nuû rihaan so̱ꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Síí nucuiꞌ rá mé so̱ꞌ ei. Asino quiri̱i̱ so̱ꞌ chruun ma̱nj nu̱u̱ rihaan so̱ꞌ, ga̱a ne̱ caꞌve̱e quiri̱i̱ so̱ꞌ niꞌya nu̱u̱ rihaan tinúú so̱ꞌ ado̱nj. Dan me se ase vaa aráán niꞌya rihaan yuvii̱ roꞌ, da̱nj vaa aráán rihaan yuvii̱ ꞌyaj cacunꞌ ata̱ yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","”Tza̱j ne̱ neꞌen soj se vaa ne nó xcúún soj go̱ꞌ soj rasu̱u̱n gue̱e̱ man chuvee maꞌ. Ne̱ se̱ caraa soj chruj perlá tuꞌve̱e̱ ndoꞌo rihaan xcáá maꞌ. ꞌO̱ se chuvee yoꞌ roꞌ, ca̱nica̱j ne̱ cha̱ man soj, ne̱ xcáá yoꞌ roꞌ, tu̱guáj cheꞌé xcáá man se sa̱ꞌ yoꞌ, ne̱ quinavi̱j nu̱ꞌ yoꞌ xtu̱nꞌ, quiꞌya̱j xcáá na̱nj ado̱nj. Ne̱ se sa̱ꞌ yoꞌ me chrej noco̱ꞌ níꞌ ado̱nj. Cheꞌé dan sese naꞌvej uxrá rá yuvii̱ cuno̱ yuvii̱ chrej nagoꞌ soj rihaan nij yuvii̱, ne̱ ase vaa xcáá do̱ꞌ, ase vaa chuvee do̱ꞌ, da̱nj vaa nij yuvii̱ ei. Ne̱ se̱ nagoꞌ soj doj chrej sa̱ꞌ man nij yuvii̱ ꞌyaj da̱nj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","”Cachi̱nj soj se vaa achiin man soj rihaan Diose̱, ne̱ soꞌ me síí rque̱ man soj, ne̱ nano̱ꞌ soj rasu̱u̱n achiin man soj, ne̱ nari̱ꞌ soj rasu̱u̱n yoꞌ, ne̱ ase vaa ꞌyaj síí ticaꞌmii taꞌyaa tucuá tuviꞌ roꞌ, da̱nj quiꞌya̱j soj ga̱ Diose̱, ne̱ caꞌnu̱u̱ Diose̱ taꞌyaa yoꞌ, ne̱ rque̱ Diose̱ rasu̱u̱n achiin man soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ꞌO̱ se síí achíín rasu̱u̱n rihaan Diose̱ roꞌ, quiri̱ꞌ soꞌ rasu̱u̱n achiin man soꞌ, ne̱ síí nanoꞌ rasu̱u̱n achiin man roꞌ, quiri̱ꞌ soꞌ rasu̱u̱n yoꞌ, ne̱ síí ticaꞌmii taꞌyaa rej ya̱nj Diose̱ roꞌ, caꞌnu̱u̱ Diose̱ taꞌyaa, ne̱ quiri̱ꞌ síí ticaꞌmii taꞌyaa rasu̱u̱n achiin man soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Xca̱j soj cuentá se vaa maꞌa̱n soj, na̱nj yuvii̱ me soj, tza̱j ne̱ sese achíín taꞌníí yoꞌo̱ soj chraa cha̱ yoꞌ man soj, ne̱ se̱ caꞌvee nano̱ꞌ soj yahij ne̱ caxri̱i̱ soj ston yoꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ne̱ sese achíín taꞌníí soj nee̱ xcuaj cha̱ yoꞌ man soj, ne̱ se̱ caꞌvee nano̱ꞌ soj xcuáá ne̱ caxri̱i̱ soj ston soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Dan me se da̱nj na̱nj soj, ne̱ síí chiꞌi̱i̱ nimán me soj, tza̱j ne̱ neꞌen soj rque̱ soj se sa̱ꞌ cha̱ taꞌníí soj ei. Cheꞌé dan táá a̱ Rej soj síí nicu̱nꞌ xta̱ꞌ, ne̱ si̱j sa̱ꞌ ina̱nj me soꞌ, ne̱ soꞌ me síí rque̱ ya̱ rasu̱u̱n sa̱ꞌ man nij síí achíín rasu̱u̱n man soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","”Dan me se da̱j se uun rá soj quiꞌya̱j sa̱ꞌ yuvii̱ rihaan soj roꞌ, taꞌngaꞌ da̱nj quiꞌya̱j sa̱ꞌ soj rihaan tuviꞌ soj á. Sese da̱nj quiꞌya̱j soj rihaan tuviꞌ soj, ne̱ síí uno nu̱ꞌ se‑tucua̱nj Moisés me soj, ne̱ síí uno nu̱ꞌ se‑na̱na̱ nij síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá me uún soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","”Ase vaa vi̱j chrej vaa rej vaa rihaan soj, ne̱ dan me se chrej caꞌa̱a̱n me yoꞌo̱ chrej yoꞌ, ne̱ caxra̱ꞌ ndoꞌo vaa rej nayón yuvii̱, ne̱ rihaan yaꞌan roꞌ, vaj chrej yoꞌ na̱nj ado̱nj. Ne̱ ma̱n uxrá yuvii̱ va̱j chrej yoꞌ ei. Se̱ caꞌanj soj chrej yoꞌ maꞌ. Na̱nj vaa chrej caꞌa̱nj soj ei. Chrej catu̱u̱n me chrej caꞌa̱nj soj, ");
INSERT INTO trcNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ne̱ chru̱j vaa rej nayón yuvii̱ a. Sayu̱u̱n ndoꞌo vaa va̱j yuvii̱ chrej yoꞌ, tza̱j ne̱ va̱j chrej yoꞌ rej ga̱a̱ iꞌna̱ꞌ yuvii̱ ca̱yáán yuvii̱ ga̱ Diose̱ nu̱ꞌ cavii nu̱ꞌ caꞌanj ado̱nj. Tza̱j ne̱ do̱j nij yuvii̱ nariꞌ chrej catu̱u̱n na̱nj ei. ");
INSERT INTO trcNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","”Vaa yuvii̱ taj se vaa me nij soꞌ síí nataꞌ se‑na̱na̱ Diose̱, tza̱j ne̱ ne ya̱ aꞌmii nij soꞌ maꞌ. Cu̱tumé soj man soj, se̱ gaa na̱nj quiꞌya̱j nij soꞌ sayuun man soj á. Dan me se vaa güii cuchi̱ꞌ nij soꞌ rihaan soj, ne̱ ase vaa matzinj roꞌ, da̱nj ga̱a̱ nij soꞌ cuchi̱ꞌ nij soꞌ rihaan soj, ne̱ niꞌya̱nj ndoꞌo caꞌmi̱i̱ nij soꞌ rihaan soj, tza̱j ne̱ nimán nij soꞌ roꞌ, ase vaa nimán xcaꞌyanj caꞌnu̱ꞌ roꞌ, ga̱a̱ nimán nij soꞌ, gu̱un rá nij soꞌ quiꞌya̱j nij soꞌ sayuun man soj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Cheꞌé dan xca̱j soj cuentá ni̱ꞌyaj soj man nij soꞌ da̱j quiꞌya̱j nij soꞌ, ga̱a ne̱ queneꞌe̱n nij soj da̱j vaa nimán nij soꞌ ei. Uta nii chruj chá raa̱ chruun tanj, rá soj naꞌ. Taj maꞌ. Ne̱ uta nii chruj chá raa̱ coj yâj yaꞌa̱a̱, rá soj naꞌ. Taj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Dan me se chruun sa̱ꞌ roꞌ, mán chruj chá raa̱ a. Ne̱ chruun tanj roꞌ, ma̱n chruj xna̱j raa̱ uún a. Sese cuchru̱u̱ chruun, ne̱ se̱ cumán chruj sa̱ꞌ raa̱ chruun yoꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Chruun sa̱ꞌ roꞌ, se̱ guun cuma̱n chruj nij raa̱ maꞌ. Ne̱ chruun nij roꞌ, se̱ guun cuma̱n chruj sa̱ꞌ raa̱ maꞌ. Ase vaa chruun yoꞌ roꞌ, da̱nj vaa nimán yuvii̱, ne̱ ase vaa chruj yoꞌ roꞌ, da̱nj vaa rasu̱u̱n ꞌyaj yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ne̱ sese nuviꞌ chruj sa̱ꞌ raa̱ ꞌo̱ chruun, ne̱ aꞌneꞌ nii man chruun yoꞌ, ne̱ axríj yaꞌan nii man chruun yoꞌ na̱nj ado̱nj. Ne̱ ase vaa ranꞌ chruun yoꞌ roꞌ, taꞌngaꞌ da̱nj quira̱nꞌ uún nij yuvii̱ ꞌyaj se chiꞌi̱i̱ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Dan me se sese xca̱j soj cuentá ni̱ꞌyaj soj man yuvii̱, ga̱a ne̱ queneꞌe̱n soj da̱j vaa nimán nij yuvii̱, ga̱a ne̱ queneꞌe̱n soj da̱j yuvi̱i̱ me nij soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","”Neꞌen soj se vaa ma̱n ndoꞌo yuvii̱ taj rihanj se vaa uno nij soꞌ rihanj, tza̱j ne̱ tuꞌva rmaꞌa̱n taꞌa̱j nij soꞌ na̱nj á. Nuveé cunuda̱nj nij síí taj neꞌen manj caꞌa̱nj ca̱yáán ga̱ Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj maꞌ. Tana̱nj o̱rúnꞌ me se ina̱nj nij síí uno rihaan Réé ꞌu̱nj síí nicu̱nꞌ xta̱ꞌ me síí ca̱yáán ga̱ soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ne̱ güii caꞌne̱ꞌ ꞌu̱nj cacunꞌ cheꞌé yuvii̱ me se cuma̱n ndoꞌo yuvii̱ cata̱j rihaan ꞌu̱nj: “Síí uno rihaan so̱ꞌ me núj, Señor. A̱j nataꞌ núj nana̱ rqué so̱ꞌ man núj rihaan yuvii̱ á. Ne̱ cataꞌ tuꞌva núj se‑chu̱vií so̱ꞌ, ne̱ quirii núj nana̱ chre̱e nimán yuvii̱ á. Ne̱ quiꞌyaj suun ndoꞌo núj suun sa̱ꞌ cheꞌé so̱ꞌ ado̱nj”. Da̱nj caꞌmi̱i̱ nij yuvii̱ yoꞌ rihaan ꞌu̱nj vaa güii na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ga̱a ne̱ cata̱j yá ꞌu̱nj rihaan nij yuvii̱ a: “A̱ ꞌó güii ne neꞌén ꞌu̱nj man soj maꞌ. Ma̱a̱n síí ꞌyaj ina̱nj cacunꞌ me soj na̱nj ado̱nj. Naxu̱u̱n soj man soj rihanj á”. Da̱nj cata̱j ꞌu̱nj rihaan nij síí ꞌyaj cacunꞌ vaa güii na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","”Dan me se a̱ me maꞌa̱n síí uno sa̱ꞌ nana̱ nihánj nana̱ cataj xnaꞌanj ꞌu̱nj rihaan soj ne̱ ꞌyaj soꞌ nda̱a vaa taj ꞌu̱nj, ne̱ ase vaa ꞌo̱ síí cuneꞌ veꞌ tucuá rihaan yuvej vaa soꞌ ei. Síí cuneꞌ veꞌ yoꞌ me se síí acaj ndoꞌo cuentá me soꞌ, ne̱ cuneꞌ soꞌ veꞌ yoꞌ rihaan ꞌo̱ yuvej ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ga̱a ne̱ caꞌnaꞌ maa̱n, ne̱ goꞌ ndoꞌo maa̱n raa̱ veꞌ, ne̱ cavii niꞌyo̱j chráá, ne̱ caꞌnaꞌ goꞌ tacóó veꞌ, ne̱ caꞌnaꞌ uxrá nana̱ yuva̱a̱, ne̱ goꞌ rihaan veꞌ yoꞌ a. Tza̱j ne̱ ne cane̱e̱ veꞌ yoꞌ a̱ maꞌ. ꞌO̱ se raan ina̱nj ne veꞌ yoꞌ rihaan yuvej na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tza̱j ne̱ síí naꞌvej rá cuno̱ nana̱ nihánj nana̱ cataj xnaꞌanj ꞌu̱nj rihaan soj me se ase vaa síí cuneꞌ veꞌ rihaan yoꞌóó vaa soꞌ ado̱nj. Ne̱ síí niꞌyo̱n rmi̱i̱ me soꞌ, ne̱ cuneꞌ soꞌ veꞌ rihaan yoꞌóó chru̱u̱, ");
INSERT INTO trcNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ne̱ veé dan, ga̱a caꞌnaꞌ uxrá maa̱n yuva̱a̱ goꞌ yoꞌ xráá veꞌ, ne̱ cavii niꞌyo̱j chráá, ne̱ caꞌnaꞌ na xe̱e̱ goꞌ na xe̱e̱ tacóó veꞌ, ne̱ caꞌnaꞌ uxrá nana̱ yuva̱a̱ ne̱ goꞌ xráá veꞌ yoꞌ a. Veé dan, ne̱ canee nu̱ꞌ veꞌ tucuá síí niꞌyo̱n yoꞌ na̱nj ado̱nj. Cheꞌé dan xca̱j soj cuentá, ne̱ veꞌé cuno̱ soj nana̱ nihánj, ne̱ se̱ quiranꞌ soj sayuun maꞌ. ―Ina̱nj nana̱ nihánj caꞌmii Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Veé dan, ne̱ quisíj tucuꞌyón Jesucristó nu̱ꞌ nana̱ nihánj rihaan nij yuvii̱, ga̱a ne̱ caráyaꞌa̱nj ndoꞌo nij yuvii̱ noco̱ꞌ man soꞌ cheꞌé nana̱ nihánj, nana̱ cataj xnaꞌanj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ꞌO̱ se xcaj nij yuvii̱ cuentá se vaa ase vaa aꞌmii ꞌo̱ síí nica̱j suun avii tuꞌva roꞌ, vaa aꞌmii Jesucristó, rá nij soꞌ a. Ne̱ cu̱u doj vaa se‑na̱na̱ soꞌ ga̱ se‑na̱na̱ nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés, rá nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ga̱a ne̱ nanij Jesucristó quij yoꞌ, ne̱ cachéé ndoꞌo yuvii̱ ga̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Dan me se cuchiꞌ yoꞌo̱ síí ranꞌ luj riꞌyuj rihaan Jesucristó, ne̱ canicunꞌ ru̱j soꞌ rihaan Jesucristó, ne̱ cataj soꞌ: ―Sese me rá so̱ꞌ, ne̱ caꞌve̱e caꞌne̱e̱ so̱ꞌ chiꞌii̱ xráj, Señor ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ga̱a ne̱ cutaꞌ Jesucristó raꞌa Jesucristó raa̱ síí ranꞌ, ne̱ cataj Jesucristó: ―Me raj qui̱ꞌyáj da̱nj ei. Na̱huún so̱ꞌ, qui̱ꞌyáj ado̱nj ―taj Jesucristó rihaan soꞌ a. Nu̱ꞌ da̱nj cataj Jesucristó, ne̱ nu̱ꞌ quinavij luj xráá síí ranꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Cu̱tumé so̱ꞌ mán so̱ꞌ se̱ cataj xnaꞌanj so̱ꞌ rihaan yuvii̱ cheꞌé se quiꞌyáá ꞌu̱nj cheꞌé so̱ꞌ maꞌ. Ma̱a̱n se cuchi̱ꞌ so̱ꞌ rihaan xrej, ne̱ ti̱haán so̱ꞌ mán so̱ꞌ rihaan xrej se vaa nahuún so̱ꞌ, ne̱ rque̱ so̱ꞌ rihaan Diose̱ se vaa cataj síí cuꞌna̱j Moisés ga̱a naá nda̱a vaa no̱ xcúún so̱ꞌ rque̱ so̱ꞌ rihaan Diose̱ á. Ga̱a ne̱ xca̱j nij xrej cuentá se vaa nahuún so̱ꞌ quiꞌyáj ado̱nj ―taj Jesucristó rihaan síí nahuun yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Dan me se cuchiꞌ Jesucristó chumanꞌ Capernaum, ne̱ catúj soꞌ chumanꞌ yoꞌ, ne̱ cuchiꞌ yoꞌo̱ tanuu capitán rihaan soꞌ a. Ne̱ soꞌ roꞌ, me síí rii taꞌngaꞌ rihaan ꞌo̱ cientó tanuu ado̱nj. Dan me se cachíín niꞌya̱j soꞌ rihaan Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","cataj soꞌ: ―Canó chiꞌii̱ man se‑mo̱zó ꞌu̱nj, Señor. Ne̱ ne nasquiꞌ soꞌ maꞌ. ꞌO̱ se yoꞌo̱ naj soꞌ rá veꞌ, ne̱ ranꞌ uxrá soꞌ sayuun, ꞌyaj chiꞌii̱ na̱nj á ―taj tanuu capitán yoꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ne̱ cataj Jesucristó rihaan soꞌ: ―Caꞌa̱nj níꞌ, ga̱a ne̱ nahu̱un soꞌ, qui̱ꞌyáj á ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ga̱a ne̱ cataj uún tanuu capitán yoꞌ: ―ꞌO̱ se nuveé si̱j sa̱ꞌ mé ꞌu̱nj maꞌ. Ne nó xcúún ꞌu̱nj catu̱u̱ so̱ꞌ rá veꞌ tucuaj qui̱ꞌyáj a̱ maꞌ. Ma̱a̱n se caꞌne̱ꞌ u̱u̱n so̱ꞌ suun se vaa nahu̱un se‑mo̱zó ꞌu̱nj, ga̱a ne̱ nahu̱un maꞌa̱n soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ꞌO̱ se vaa síí rii taꞌngaꞌ rihaan ꞌu̱nj, ne̱ rii taꞌngáꞌ ꞌu̱nj rihaan tanuu, ne̱ taj xnaꞌanj ꞌu̱nj rihaan tanuu se vaa caꞌa̱nj nij soꞌ, ne̱ ꞌanj nij soꞌ, ne̱ taj xnaꞌanj ꞌu̱nj rihaan nij soꞌ se vaa caꞌna̱ꞌ nij soꞌ, ne̱ ꞌnaꞌ nij soꞌ rihaan ꞌu̱nj, ne̱ taj xnaꞌanj ꞌu̱nj da̱j quiꞌya̱j nij soꞌ, ne̱ veé da̱nj ꞌyaj tanuu ado̱nj. Ne̱ neꞌén ꞌu̱nj se vaa ase vaa rii taꞌngáꞌ ꞌu̱nj rihaan nij tanuu noco̱ꞌ manj roꞌ, da̱nj rii taꞌngaꞌ gue̱e̱ so̱ꞌ rihaan chiꞌii̱ anó man yuvii̱ na̱nj á ―taj tanuu capitán yoꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Dan me se, ga̱a cuno Jesucristó nana̱ caꞌmii tanuu capitán yoꞌ, ne̱ caꞌanj rá Jesucristó, ne̱ cataj soꞌ rihaan nij síí noco̱ꞌ rej xco̱ soꞌ a: ―Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa taj va̱j a̱ ꞌó rej ne nari̱j man yoꞌo̱ síí israelitá síí cuchumán ndoꞌo rá nana̱ aꞌmii ꞌu̱nj nda̱a vaa amán rá tanuu capitán nihánj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ne̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa güii gu̱un chij Diose̱ rihaan chumii̱ nihánj roꞌ, caꞌna̱ꞌ ndoꞌo yuvii̱ ma̱n cunu̱ꞌ chumii̱, ne̱ ca̱yáán nij soꞌ rihaan se‑mesa̱ Diose̱, ne̱ cha̱ nij soꞌ chraa ga̱ síí cuꞌna̱j Abraham do̱ꞌ, ga̱ síí cuꞌna̱j Isaac do̱ꞌ, ga̱ síí cuꞌna̱j Jacob do̱ꞌ, ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ne̱ nij síí israelitá roꞌ, no̱ xcúún nij soꞌ cuchuma̱n rá nij soꞌ ni̱ꞌyaj nij soꞌ manj, ne̱ sese cuchuma̱n rá nij soꞌ ni̱ꞌyaj nij soꞌ manj, ne̱ caꞌve̱e cane̱ nij soꞌ uún ga̱ Diose̱ na̱nj á. Tza̱j ne̱ naꞌvej rá nij soꞌ a̱ man ado̱nj. Cheꞌé se naꞌvej rá nij soꞌ quiꞌya̱j nij soꞌ da̱nj, cheꞌé dan quiriꞌi̱j ga̱nꞌ ndoꞌo nii man nij soꞌ rej rmi̱ꞌ, ne̱ taꞌve̱e uxrá nij soꞌ, ne̱ nda̱a cha̱ ru̱j maꞌa̱n nij soꞌ cúú yanꞌ nij soꞌ na̱nj ado̱nj. Da̱nj quira̱nꞌ nij soꞌ cheꞌé se naꞌvej rá nij soꞌ cuchuma̱n rá nij soꞌ ni̱ꞌyaj nij soꞌ manj na̱nj á ―taj Jesucristó rihaan nij yuvii̱ canocoꞌ man soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Canica̱j uún Jesucristó cataj Jesucristó rihaan tanuu capitán: ―Caꞌve̱e caꞌa̱nj so̱ꞌ ya̱j a. Ya̱ cuchumán rá so̱ꞌ se vaa nahu̱un se‑mo̱zó so̱ꞌ qui̱ꞌyáj a. Ne̱ nahu̱un soꞌ ei ―taj Jesucristó rihaan soꞌ a. Ne̱ veé ma̱a̱n orá yoꞌ roꞌ, nahuun se‑mo̱zó tanuu capitán yoꞌ, quiꞌyaj Jesucristó ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ga̱a ne̱ caꞌanj Jesucristó tucuá síí cuꞌna̱j Pedró, ne̱ queneꞌen soꞌ se vaa na̱j nii che̱j Pedró ranꞌ noꞌ, ne̱ caxríj uxrá cachiꞌ man noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ne̱ quitaꞌaa Jesucristó raꞌa noꞌ, ga̱a ne̱ veé ma̱a̱n orá dan nahuun noꞌ, quiꞌyaj Jesucristó, ne̱ naxaga̱a̱ noꞌ, ne̱ quiꞌyaj chuvi̱i noꞌ cha̱ nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Rej caꞌanj güii cuchiꞌ yuvii̱ rihaan Jesucristó a. Dan me se nica̱j nij yuvii̱ man queꞌe̱e̱ uxrá síí nu̱u̱ nana̱ chre̱e nimán, cuchiꞌ nij yuvii̱ rihaan Jesucristó, ne̱ cataj xnaꞌanj u̱u̱n Jesucristó rihaan nij nana̱ chre̱e se vaa naxu̱u̱n nij soꞌ man nij soꞌ, ga̱a ne̱, veé dan, ne̱ curiha̱nj nij nana̱ chre̱e nimán nij yuvii̱, ga̱a ne̱ cunuu sa̱ꞌ nimán nij yuvii̱ yoꞌ cuaj na̱nj ado̱nj. Ne̱ quinahuun sa̱ꞌ cunuda̱nj nij síí ranꞌ, quiꞌyaj uún Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Dan me se quisíj ya̱ nu̱ꞌ nana̱ nihánj nana̱ caꞌmii síí cuꞌna̱j Isaías síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá, se vaa cataj soꞌ: “Ninaj níꞌ, ne̱ canó chiꞌii̱ man níꞌ, tza̱j ne̱ nahu̱un níꞌ, quiꞌya̱j síí caꞌna̱ꞌ vaa güii na̱nj ado̱nj”, taj síí cuꞌna̱j Isaías ga̱a nataꞌ soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Queneꞌen Jesucristó se vaa ma̱n ndoꞌo yuvii̱ anica̱j rej nicu̱nꞌ soꞌ niꞌya̱j man soꞌ a. Cheꞌé dan caꞌneꞌ soꞌ suun rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ se vaa caꞌa̱nj nij soꞌ ga̱ soꞌ nda̱a rne̱j na lacuaná cuꞌna̱j Galilea a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ga̱a ne̱ cuchiꞌ yoꞌo̱ soꞌ rihaan Jesucristó a. Soꞌ roꞌ, me síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ ado̱nj. Ne̱ cataj soꞌ rihaan Jesucristó a: ―Ca̱nocóꞌ ꞌu̱nj mán so̱ꞌ da̱j rej maꞌa̱n vaj so̱ꞌ, maestro ―cataj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ga̱a ne̱ cataj ya̱ Jesucristó se vaa ranꞌ soꞌ chéé soꞌ a: ―ꞌO̱ se nij chunee roꞌ, otoj sa̱ꞌ nij xoꞌ rá yuꞌuj ta̱j rque yoꞌóó, ne̱ nij xtâj chéé xta̱ꞌ roꞌ, vaa saca̱ꞌ nij xoꞌ a. Ne̱ xa̱ꞌ ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱, tza̱j ne̱ taj a̱ ꞌó rej qui̱náá ꞌu̱nj coto̱j ꞌu̱nj a̱ maꞌ ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ne̱ vaa yoꞌó síí tucuꞌyón se‑na̱na̱ Jesucristó cuchiꞌ rihaan soꞌ, ne̱ cataj soꞌ: ―Caꞌve̱j so̱ꞌ na̱nj tucuaj, ne̱ nda̱a caviꞌ réj, ga̱a ne̱ cachi̱nꞌ ꞌu̱nj man réj, ga̱a ne̱ ca̱nocóꞌ ꞌu̱nj mán so̱ꞌ, Señor ―taj yoꞌó soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tza̱j ne̱ cataj Jesucristó rihaan soꞌ a: ―Caꞌne̱ꞌ rá so̱ꞌ cachi̱nꞌ maꞌa̱n nij síí caviꞌ nimán man tuviꞌ soꞌ xnangá á. Tza̱j ne̱ cuano̱ nihánj roꞌ, no̱ xcúún so̱ꞌ yoꞌo̱ ca̱nocóꞌ so̱ꞌ manj ado̱nj ―taj Jesucristó rihaan yoꞌó soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ga̱a ne̱ catúj Jesucristó rque rihoo chéé rihaan na, ga̱a ne̱ catúj nij síí tucuꞌyón se‑na̱na̱ soꞌ rque rihoo ga̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Veé dan, ne̱ nasquiꞌ nucua̱j ndoꞌo rihaan na lacuaná, ne̱ me ndoꞌo rá na yoꞌ gu̱un nucua̱j yoꞌ ca̱ráán yoꞌ xráá rihoo a. Ne̱ veé dan vaj Jesucristó, ne̱ cotoj soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ga̱a ne̱ caꞌanj nij síí tucuꞌyón se‑na̱na̱ Jesucristó rej na̱j soꞌ cotoj soꞌ, ne̱ narii nij soꞌ nej rihaan soꞌ, ne̱ cataj nij soꞌ: ―Ti̱nanii so̱ꞌ man níꞌ se̱ caviꞌ nu̱ꞌ níꞌ, man Señor ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Dan me se maꞌa̱n Jesucristó cataj, ne̱: ―Me cheꞌé chuꞌviꞌ ndoꞌo nimán soj ga̱. Yoꞌ me rej ataa cuchuma̱n sa̱ꞌ rá soj ni̱ꞌyaj soj manj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. Ga̱a ne̱ canicunꞌ caya̱ soꞌ, ne̱ caxríj yuva̱a̱ soꞌ man na do̱ꞌ, man nana̱ do̱ꞌ a. Ga̱a ne̱ canicunꞌ dínj uxrá rihaan na lacuaná yoꞌ, quiꞌyaj Jesucristó na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ne̱ cuchuꞌviꞌ nij snóꞌo yoꞌ niꞌya̱j nij soꞌ man Jesucristó, cataj nij soꞌ: ―Da̱j si̱j me síí nihánj ga̱. ꞌO̱ se nda̱a nana̱ nda̱a na uno aꞌmii soꞌ aso̱n ―taj nij soꞌ rihaan tuviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ga̱a ne̱ cuchiꞌ Jesucristó nda̱a rne̱j na lacuaná yoꞌ rej ne̱ nij síí ma̱n chumanꞌ cuꞌna̱j Gadara a. Ne̱ vaa yuꞌuj yuvej, rej cachinꞌ nij yuvii̱ xnangá a. Dan me se cavii vi̱j snóꞌo yuꞌuj yuvej yoꞌ, ne̱ cuchiꞌ ro̱j soꞌ rihaan Jesucristó a. Ro̱j soꞌ me síí nu̱u̱ nana̱ chre̱e nimán, ne̱ yuva̱a̱ ndoꞌo ro̱j soꞌ ado̱nj. Cheꞌé ro̱j soꞌ naꞌvee cache̱n yuvii̱ rej yoꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Dan me se caguáj ro̱j soꞌ rihaan Jesucristó, cataj ro̱j soꞌ: ―Veé neꞌen núj se vaa taꞌni̱j Diose̱ mé so̱ꞌ á. Me cheꞌé caꞌnáꞌ so̱ꞌ rej ne̱ núj ga̱. Caꞌnáꞌ so̱ꞌ qui̱ꞌyáá so̱ꞌ sayuun man núj naꞌ. ꞌO̱ se ataa doj quisi̱j güii qui̱ꞌyáá so̱ꞌ sayuun man núj ado̱nj ―taj ro̱j soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Dan me se rej xco̱ ro̱j soꞌ roꞌ, va̱j queꞌe̱e̱ xcáá chá coj ma̱n tacaan a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ne̱ nij nana̱ chre̱e nu̱u̱ nimán ro̱j snóꞌo yoꞌ roꞌ, cachíín niꞌya̱j nij soꞌ rihaan Jesucristó, cataj nij soꞌ: ―Sese quiri̱i̱ so̱ꞌ man núj nimán ro̱j snóꞌo nihánj, ne̱ qui̱ꞌyáá so̱ꞌ se ndoꞌo caꞌne̱j so̱ꞌ man núj, catu̱u̱ núj nimán xcáá yoꞌ rugua̱nj ―taj nij nana̱ chre̱e yoꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","―Caꞌa̱nj soj cuaj á ―taj Jesucristó rihaan nij soꞌ a. Ga̱a ne̱ caꞌanj nij soꞌ catúj nij soꞌ nimán xcáá yoꞌ, ne̱ dan me se ruva̱a̱ uxrá tacaan nicu̱nꞌ tuꞌva na lacuaná rej va̱j nij xcáá yoꞌ, ne̱ ga̱a catúj nij nana̱ chre̱e nimán nij xcáá yoꞌ me se cunánj ndoꞌo nij xoꞌ caꞌanj xoꞌ, ne̱ veé da̱nj vaj nij xoꞌ, ne̱ quinij cunuda̱nj nij xoꞌ rque na, ne̱ canó xráá nij xoꞌ, quiꞌyaj na na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ne̱ nij síí tumé xcáá yoꞌ roꞌ, cunánj nij soꞌ caꞌanj nij soꞌ nda̱a chumanꞌ, ne̱ catúj nij soꞌ chumanꞌ, ne̱ cataj xnaꞌanj nij soꞌ rihaan nij síí ma̱n chumanꞌ yoꞌ nu̱ꞌ se vaa quiranꞌ ro̱j snóꞌo do̱ꞌ, nij xcáá do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ga̱a ne̱ curiha̱nj cunuda̱nj nij síí ma̱n chumanꞌ yoꞌ, guun rá nij soꞌ nari̱ꞌ nij soꞌ man Jesucristó a. Dan me se queneꞌen nij soꞌ man soꞌ, ne̱ cachíín niꞌya̱j nij soꞌ rihaan soꞌ se vaa cu̱riha̱nj soꞌ rej ya̱nj nij soꞌ caꞌa̱nj soꞌ rej yaníj a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ga̱a ne̱ cavii Jesucristó rihoo chéé rihaan na, ne̱ caꞌanj soꞌ chumanꞌ cayáán soꞌ, ne̱ catúj soꞌ chumanꞌ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ne̱ veé nica̱j nii man ꞌo̱ síí naꞌvee cache̱e̱ táá rihaan yuvéé, ne̱ caꞌnaꞌ nii rihaan Jesucristó a. Ne̱ queneꞌen Jesucristó se vaa cuchumán uxrá rá nij yuvii̱ se vaa nahu̱un sa̱ꞌ síí naꞌvee cache̱e̱ yoꞌ quiꞌya̱j soꞌ a. Cheꞌé dan cataj soꞌ rihaan síí ranꞌ yoꞌ a: ―No̱ xcúún so̱ꞌ gu̱un niha̱ꞌ rá so̱ꞌ cheꞌé se navij cacunꞌ xráá so̱ꞌ, na̱nj tinu̱j ―taj Jesucristó rihaan síí naꞌvee cache̱e̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Dan me se cane do̱j síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ rá veꞌ ga̱ Jesucristó, ne̱ cataj nij soꞌ rihaan tuviꞌ nij soꞌ a: ―Nij vaa nana̱ caꞌmii síí nihánj rihaan Diose̱ á. ꞌO̱ se o̱rúnꞌ Diose̱ no̱ xcúún cata̱j se vaa navij cacunꞌ xráá yuvii̱ á ―taj nij síí tucuꞌyón se‑tucua̱nj Moisés niꞌya̱j nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ne̱ queneꞌen Jesucristó me nana̱ guun rá nij soꞌ caꞌmi̱i̱ nij soꞌ, ne̱ cheꞌé dan cataj soꞌ: ―Me cheꞌé avii ndoꞌo nana̱ chiꞌi̱i̱ raa̱ soj ga̱. ");
INSERT INTO trcNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Tuꞌva ru̱maꞌán ꞌu̱nj se vaa navij cacunꞌ xráá síí nihánj, rá soj a̱ naꞌ. Caꞌve̱e cata̱j u̱u̱n níꞌ navij cacunꞌ xráá síí nihánj naꞌ. Ase caꞌve̱e doj cata̱j níꞌ na̱xagaa soꞌ, ne̱ cache̱e̱ soꞌ cuaj, cata̱j níꞌ xa̱ꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Dan me se me rá ꞌu̱nj xca̱j soj cuentá se vaa síí caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ mej ne̱ no̱ xcúún ꞌu̱nj ti̱navíí ꞌu̱nj cacunꞌ xráá nij yuvii̱ ma̱n rihaan chumii̱ nihánj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. Dan me se cataj Jesucristó rihaan síí naꞌvee cache̱e̱ a: ―Nacue̱ so̱ꞌ tuvéé so̱ꞌ, ne̱ na̱nꞌ so̱ꞌ tucuá so̱ꞌ á ―taj Jesucristó rihaan síí na̱j rihaan yuvéé yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ga̱a ne̱ naxaga̱a̱ soꞌ, ne̱ cavii soꞌ, ne̱ quinanꞌ soꞌ tucuá soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ne̱ queneꞌen nij yuvii̱ se vaa nahuun sa̱ꞌ soꞌ, quiꞌyaj Jesucristó, ne̱ cheꞌé dan cuchuꞌviꞌ nimán nij soꞌ, queneꞌen nij soꞌ Jesucristó, ne̱ veꞌé ndoꞌo caꞌmii nij soꞌ cheꞌé Diose̱, se vaa guun nucua̱j Jesucristó racuíj ndoꞌo Jesucristó man yuvii̱, quiꞌyaj Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ga̱a ne̱ cavii Jesucristó rej yoꞌ, ne̱ queneꞌen soꞌ man yoꞌo̱ síí ya̱nj ꞌo̱ veꞌ aꞌnéj nii puextó man yuvii̱ a. Mateo cuꞌna̱j síí ne̱ rej yoꞌ a. Dan me se cataj Jesucristó rihaan soꞌ, ne̱: ―Ca̱nocóꞌ so̱ꞌ manj, caꞌa̱nj níꞌ á ―taj Jesucristó rihaan soꞌ a. Ga̱a ne̱ naxuma̱a̱n soꞌ, ne̱ canocoꞌ soꞌ man Jesucristó, caꞌanj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Dan me se ꞌo̱ güii cayáán Jesucristó rá veꞌ, ne̱ caꞌnaꞌ ndoꞌo tuviꞌ soꞌ síí aꞌnéj puextó do̱ꞌ, yoꞌó nij síí tumé ndoꞌo cacunꞌ do̱ꞌ, ne̱ catúj nij soꞌ rá veꞌ, ne̱ caꞌanj ca̱yáán nij soꞌ ga̱ Jesucristó, ne̱ dan me se ma̱n rcuaꞌa̱a̱n nij síí tucuꞌyón se‑na̱na̱ Jesucristó do̱ꞌ, ne̱ chá cunuda̱nj nij soꞌ chraa a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ne̱ queneꞌen nij síí fariseo se vaa chá Jesucristó chraa ga̱ nij síí aꞌnéj puextó do̱ꞌ, ga̱ yoꞌó nij síí tumé ndoꞌo cacunꞌ do̱ꞌ, ne̱ xnáꞌanj nij soꞌ man nij síí tucuꞌyón se‑na̱na̱ Jesucristó, cataj nij soꞌ: ―Síí tucuꞌyón nana̱ rihaan soj roꞌ, me cheꞌé chá soꞌ chraa ga̱ nij síí aꞌnéj puextó do̱ꞌ, ga̱ yoꞌó nij síí tumé ndoꞌo cacunꞌ do̱ꞌ, rá núj a ―taj nij síí fariseo rihaan nij síí tucuꞌyón se‑na̱na̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ne̱ cuno Jesucristó nana̱ caꞌmii nij soꞌ, ne̱ cataj soꞌ rihaan nij soꞌ a: ―Síí vaa nucua̱j roꞌ, ne nanoꞌ nij soꞌ man doctor maꞌ. Ma̱a̱n síí ranꞌ roꞌ, me síí nanoꞌ man doctor ado̱nj. Ga̱a ne̱ ase vaa síí ranꞌ roꞌ, da̱nj vaa nij síí nihánj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ꞌO̱ se vaa cheꞌé caꞌa̱nj soj tu̱cuꞌyón soj da̱j taj nana̱ nihánj nana̱ no̱ rihaan danj Diose̱ á: “Ne uun niha̱ꞌ rá ꞌu̱nj niꞌya̱j ꞌu̱nj yuvii̱ nagoꞌ xcuu rihaan ꞌu̱nj maꞌ. Tana̱nj uun niha̱ꞌ rá ꞌu̱nj niꞌya̱j ꞌu̱nj yuvii̱ ꞌe̱e̱ rá man tuviꞌ ado̱nj”. Ina̱nj da̱nj me se‑na̱na̱ Diose̱ nana̱ tu̱cuꞌyón soj á. Dan me se xca̱j soj cuentá se vaa ne caꞌna̱ꞌ ꞌu̱nj canacu̱nj ꞌu̱nj man síí sa̱ꞌ maꞌ. Cheꞌé nij síí tumé cacunꞌ caꞌnaj se vaa canoco̱ꞌ nij soꞌ se‑na̱na̱j ado̱nj. Tza̱j ne̱ sese síí sa̱ꞌ me soj, rá soj, ne̱ nuveé si̱j canacu̱nj ꞌu̱nj man me soj maꞌ ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ga̱a ne̱ nij síí tucuꞌyón se‑na̱na̱ síí cuꞌna̱j Juan cuchiꞌ rihaan Jesucristó, ne̱ xnáꞌanj nij soꞌ man soꞌ, cataj nij soꞌ: ―Me cheꞌé, ne̱ tocoꞌ núj xꞌnaa man maꞌa̱n núj cheꞌé se aráj gue̱e̱ núj rihaan Diose̱, ne̱ tocoꞌ nij síí fariseo xꞌnaa man maꞌa̱n nij soꞌ uún, tza̱j ne̱ nij síí tucuꞌyón se‑na̱na̱ so̱ꞌ me se ne tocoꞌ nij soꞌ xꞌnaa man maꞌa̱n nij soꞌ ga̱ ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Ase vaa síí cuchruj saꞌanj vaa ꞌu̱nj, ne̱ asa̱ꞌ caꞌve̱e toco̱ꞌ nij síí ma̱n ga̱j xꞌnaa man maꞌa̱n nij soꞌ, rá soj ga̱. Ase vaa síí cataj xca̱j man chana̱ ne̱ ma̱n tuviꞌ soꞌ do̱ꞌ, da̱nj vaa nij síí ma̱n nihánj cuano̱, ne̱ anuû ndoꞌo chaꞌanj ma̱n nij soꞌ, ne̱ se̱ caꞌvee toco̱ꞌ nij soꞌ xꞌnaa man maꞌa̱n nij soꞌ maꞌ. Tza̱j ne̱ vaa güii, ne̱ gu̱un yaníj ꞌu̱nj rihaan nij soꞌ quiꞌya̱j yuvii̱, ga̱a ne̱ nano̱ rá nij síí nihánj, ga̱a ne̱ toco̱ꞌ nij soꞌ xꞌnaa man maꞌa̱n nij soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","”Tza̱j ne̱ ase vaa yatzíj sinꞌ vaa tucuáán nga̱ noco̱ꞌ soj, ne̱ se̱ guun naꞌne̱j níꞌ mantá naca̱ man yatzíj nga̱ yoꞌ maꞌ. ꞌO̱ se sese quiꞌya̱j níꞌ da̱nj, ne̱ güii quina̱nj yuvii̱ yatzíj yoꞌ, ga̱a ne̱ nagüe̱j mantá naca̱ yoꞌ, ne̱ sese cuxu̱u̱n yuvii̱ man yatzíj yoꞌ, ne̱ quisi̱nꞌ yoꞌ, ga̱a ne̱ cunu̱u xi̱j doj yuꞌuj a̱j ta̱j man yatzíj nga̱ yoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ne̱ dan me se ase vaa nuj nga̱ nuj araa nii na vinó vaa uún soj a. Ne̱ se̱ caꞌvee tu̱cuꞌyón ꞌu̱nj se‑tucua̱nj ꞌu̱nj rihaan soj maꞌ. ꞌO̱ se ase vaa na vinó naca̱ vaa nana̱ tucuꞌyón ꞌu̱nj, ne̱ se̱ guun cara̱a yuvii̱ na vinó naca̱ rque nuj nga̱ maꞌ. Sese da̱nj quiꞌya̱j yuvii̱, ne̱ cuya̱nj na vinó cunu̱u xe̱e̱ na vinó, ne̱ se̱ cacuá nuj nga̱ maꞌ. Cheꞌé dan canu̱u̱ yoꞌ, ne̱ caya̱nj na vinó rihaan yoꞌóó a. Cheꞌé dan araa nii na vinó naca̱ rque nuj naca̱, ne̱ ꞌo̱ mán sa̱ꞌ na vinó rque nuj yoꞌ a. Cheꞌé dan ina̱nj rihaan síí naca̱ síí ne nocoꞌ tucuáán nga̱ tu̱cuꞌyón ꞌu̱nj se‑na̱na̱j na̱nj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ síí cuꞌna̱j Juan yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Asi̱j caꞌmii Jesucristó nana̱ yoꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ síí cuꞌna̱j Juan, ne̱ cuchiꞌ ꞌo̱ síí nica̱j suun rihaan Jesucristó, ne̱ canicunꞌ ru̱j soꞌ, cachíín niꞌya̱j soꞌ rihaan Jesucristó, cataj soꞌ: ―Cuano̱ caviꞌ taꞌníj chala̱ cunii a. Tza̱j ne̱ qui̱ꞌyáá so̱ꞌ se ndoꞌo, caꞌa̱nj níꞌ, ne̱ cuta̱ꞌ so̱ꞌ raꞌá so̱ꞌ xráá noꞌ, ne̱ cunu̱u iꞌna̱ꞌ uún noꞌ na̱nj rugua̱nj ―taj soꞌ, cachíín niꞌya̱j soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ga̱a ne̱ naxuma̱a̱n Jesucristó, ne̱ canocoꞌ soꞌ do̱ꞌ, nij síí tucuꞌyón se‑na̱na̱ soꞌ do̱ꞌ, man síí nica̱j suun yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ga̱a ne̱ caꞌnaꞌ ꞌo̱ chana̱ rej xco̱ Jesucristó, ne̱ quisíj ꞌo̱ chuvi̱j yoꞌ xraꞌ ton man chana̱ yoꞌ, ne̱ canó raꞌa noꞌ do̱j tuꞌva saga̱nꞌ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ꞌO̱ se: “Sese cano̱ raꞌaj saga̱nꞌ Jesucristó, ne̱ nahu̱un sa̱ꞌ ꞌu̱nj na̱nj ado̱nj”, guun rá noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ga̱a ne̱ canica̱j Jesucristó queneꞌen Jesucristó man noꞌ, ne̱ cataj soꞌ: ―No̱ xcúún so̱ꞌ gu̱un niha̱ꞌ rá so̱ꞌ, nocoj. ꞌO̱ se cheꞌé se amán rá so̱ꞌ niꞌya̱j so̱ꞌ manj roꞌ, cheꞌé dan nahuun sa̱ꞌ so̱ꞌ á ―taj Jesucristó rihaan chana̱ yoꞌ a. Ne̱ veé ma̱a̱n orá dan nahuun sa̱ꞌ chana̱ yoꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ga̱a ne̱ caꞌanj Jesucristó veꞌ tucuá síí nica̱j suun yoꞌ, ne̱ catúj soꞌ rá veꞌ, ne̱ queneꞌen soꞌ se vaa ma̱n síí oꞌ chraꞌ man rihuu flauta, ne̱ queneꞌen soꞌ se vaa ma̱n ndoꞌo yuvii̱ rá veꞌ, ne̱ nanó ndoꞌo rá nij yuvii̱ cheꞌé se caviꞌ chala̱ cunii yoꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ga̱a ne̱ cataj soꞌ: ―Cu̱riha̱nj soj xeꞌ á. ꞌO̱ se ne cavi̱ꞌ chala̱ cunii nihánj maꞌ. Ma̱a̱n se otoj u̱u̱n noꞌ na̱nj á ―taj Jesucristó rihaan nij yuvii̱ ma̱n rá veꞌ yoꞌ a. Ga̱a ne̱ caꞌngaꞌ naco̱o̱ nij yuvii̱ niꞌya̱j nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ga̱a quisíj quirii Jesucristó man cunuda̱nj nij yuvii̱ xeꞌ, ne̱ catúj Jesucristó rej táá chala̱ cunii yoꞌ, ne̱ quitaꞌaa soꞌ raꞌa noꞌ, ne̱ cunuu iꞌna̱ꞌ uún chala̱ cunii, ne̱ naxaga̱a̱ noꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ne̱ cuchiꞌ nana̱ rihaan cunuda̱nj nij yuvii̱ ma̱n rej yoꞌ cheꞌé se vaa quiꞌyaj Jesucristó, se vaa cunuu iꞌna̱ꞌ chala̱ cunii yoꞌ quiꞌyaj soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Dan me se ga̱a cavii Jesucristó tucuá síí nica̱j suun yoꞌ, ne̱ canocoꞌ vi̱j síí tuchri̱i man soꞌ a. Ne̱ caguáj ro̱j soꞌ, cataj ro̱j soꞌ: ―Neꞌen rój se vaa tuviꞌ síí cuꞌna̱j David síí cane ga̱a naá mé so̱ꞌ á. Cheꞌé dan cunu̱u ꞌe̱e̱ rá so̱ꞌ man rój rugua̱nj ―taj ro̱j soꞌ, caguáj ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Dan me se catúj Jesucristó rá veꞌ, ne̱ cuchiꞌ ro̱j síí tuchri̱i yoꞌ rihaan soꞌ a. Ga̱a ne̱ cataj Jesucristó rihaan ro̱j soꞌ: ―A̱mán rá ro̱j so̱j se vaa gu̱un nu̱cuáj naxra̱ꞌ rihaan ro̱j so̱j qui̱ꞌyáj naꞌ ―taj Jesucristó, xnáꞌanj Jesucristó man ro̱j soꞌ a. ―Amán rá rój, Señor ―taj ro̱j soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ga̱a ne̱ cutaꞌ raꞌa Jesucristó rihaan ro̱j soꞌ, ne̱ cataj Jesucristó: ―Cheꞌé se amán rá ro̱j so̱j, ne̱ cheꞌé dan naxra̱ꞌ rihaan ro̱j so̱j ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Veé dan, ne̱ naxraꞌ rihaan ro̱j soꞌ na̱nj ado̱nj. Ga̱a ne̱ caxríj yuva̱a̱ Jesucristó rihaan ro̱j soꞌ, ne̱ cataj Jesucristó rihaan ro̱j soꞌ a: ―Cu̱tumé uxrá ro̱j so̱j man ro̱j so̱j, ne̱ a̱ ꞌó yuvii̱ se̱ cuno se vaa quiꞌyáá ꞌu̱nj cheꞌé ro̱j so̱j á. ―Dan me se nucua̱j ndoꞌo caꞌmii Jesucristó nana̱ yoꞌ rihaan ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tza̱j ne̱ curiha̱nj ro̱j soꞌ caꞌanj ro̱j soꞌ, ne̱ uxrá nataꞌ ro̱j soꞌ rihaan cunuda̱nj nij yuvii̱ ma̱n rej yoꞌ cheꞌé yan quiꞌyaj sa̱ꞌ Jesucristó cheꞌé ro̱j soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Dan me se tanáj ro̱j soꞌ man Jesucristó, ga̱a ne̱ caꞌanj Jesucristó, ga̱a ne̱ cuchiꞌ yuvii̱ rihaan soꞌ a. Dan me se nica̱j nij yuvii̱ man ꞌo̱ síí yaꞌmi̱i cuchiꞌ nij yuvii̱ rihaan Jesucristó a. Síí yaꞌmi̱i yoꞌ me se nana̱ chre̱e nuû nimán soꞌ, ne̱ cheꞌé dan ne caꞌmi̱i̱ soꞌ, quiꞌyaj nana̱ chre̱e yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Dan me se quirii Jesucristó man nana̱ chre̱e yoꞌ nimán soꞌ, ga̱a ne̱ guun cheꞌe̱ síí yaꞌmi̱i caꞌmii soꞌ na̱nj ado̱nj. Veé dan queneꞌen nij yuvii̱, ne̱ caráyaꞌa̱nj uxrá nij yuvii̱, ne̱ cataj nij soꞌ: ―Xa̱ꞌ níꞌ si̱j israelitá, tza̱j ne̱ a̱ ꞌó síí ꞌyaj da̱nj ne queneꞌe̱n níꞌ maꞌ ―taj nij yuvii̱ cheꞌé Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tza̱j ne̱ nij síí fariseo cataj me se: ―Guun nucua̱j soꞌ quirii soꞌ man nana̱ chre̱e, cheꞌé se aꞌmii soꞌ ga̱ maꞌa̱n síí chre̱e uun chij ado̱nj ―taj nij síí fariseo, caꞌmii ne̱ nij soꞌ cheꞌé Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ga̱a ne̱ caꞌanj Jesucristó nu̱ꞌ nij chumanꞌ noco̱o nu̱ꞌ nij chumanꞌ cunii nu̱ꞌ, ne̱ tucuꞌyón soꞌ rihaan nij yuvii̱ ma̱n rá veꞌ tucuꞌyón nij yuvii̱ israelitá se‑tucua̱nj Moisés, ne̱ caꞌmii natáj soꞌ nana̱ sa̱ꞌ cheꞌé güii gu̱un chij Diose̱ rihaan chumii̱ nihánj, ne̱ nahuun sa̱ꞌ taranꞌ nij síí ranꞌ do̱ꞌ, nij síí ninaj do̱ꞌ, quiꞌyaj uún soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ne̱ queneꞌen soꞌ man cunuda̱nj nij yuvii̱, ne̱ cunuu ꞌe̱e̱ rá soꞌ man nij yuvii̱ yoꞌ a. ꞌO̱ se queneꞌen soꞌ se vaa ase vaa matzinj va̱j maꞌa̱n vaa nij yuvii̱, nuviꞌ síí tumé man nij soꞌ, ne̱ a̱j quiranꞌ ndoꞌo nij soꞌ sayuun, ne̱ ninaj ndoꞌo nij soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ga̱a ne̱ cataj soꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a: ―Ya̱ uxrá, ne̱ vaa ndoꞌo suun rihaan níꞌ, ne̱ nij síí ꞌyaj suun me se do̱j nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ne̱ cachi̱nj niꞌya̱j níꞌ doj nij síí quiꞌya̱j suun rihaan Diose̱ síí uun chij ꞌni̱j raꞌa suun, ga̱a ne̱ caꞌne̱j soꞌ doj yuvii̱ quiꞌya̱j suun se‑su̱u̱n soꞌ ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ga̱a ne̱ canacúún Jesucristó man chuvi̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ cuchiꞌ nij soꞌ rihaan soꞌ, ne̱ goꞌ soꞌ rej nucua̱j man nij soꞌ, ga̱a ne̱ caꞌve̱e quiꞌya̱j canaán nij soꞌ rihaan nij nana̱ chre̱e a. Dan me se gu̱un nucua̱j nij soꞌ quiri̱i̱ nij soꞌ man nij nana̱ chre̱e nimán yuvii̱, ne̱ gu̱un nucua̱j nij soꞌ nahu̱un sa̱ꞌ yuvii̱ ranꞌ do̱ꞌ, yuvii̱ ninaj do̱ꞌ, quiꞌya̱j uún nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ne̱ nihánj me se‑chuvi̱i chuvi̱j nij apóstol cuneꞌ Jesucristó man nata̱ꞌ rihaan yuvii̱ cheꞌé soꞌ a. Yoꞌo̱ soꞌ me síí cuꞌna̱j Simón, ne̱ Pedró cuꞌna̱j yoꞌó se‑chuvi̱i síí cuꞌna̱j Simón a. Ne̱ yoꞌó soꞌ me tinúú Simón, síí cuꞌna̱j Andrés a. Ne̱ yoꞌó soꞌ me síí cuꞌna̱j Jacobo, ne̱ taꞌníí síí cuꞌna̱j Zebedeo me soꞌ a. Ne̱ yoꞌó soꞌ me tinúú Jacobo, síí cuꞌna̱j Juan a. ");
INSERT INTO trcNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ne̱ vaa síí cuꞌna̱j Felipé vaa síí cuꞌna̱j Bartolomé vaa síí cuꞌna̱j Tomás vaa a. Ne̱ yoꞌó soꞌ me síí cuꞌna̱j Mateo síí caꞌnéj puextó man yuvii̱ a. Ne̱ yoꞌó soꞌ me síí cuꞌna̱j Jacobo uún, ne̱ taꞌníí síí cuꞌna̱j Alfeo me soꞌ a. Ne̱ yoꞌó soꞌ me síí cuꞌna̱j Lebeo, ne̱ Tadeo cuꞌna̱j yoꞌó se‑chuvi̱i síí cuꞌna̱j Lebeo a. ");
INSERT INTO trcNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ne̱ yoꞌó soꞌ me síí cuꞌna̱j Simón uún, ne̱ soꞌ me tuviꞌ nij síí me rá cunu̱ꞌ ga̱ gobiernó ma̱n Romá a. Ne̱ yoꞌó soꞌ me síí cuꞌna̱j Judas Iscariote, ne̱ soꞌ me síí tacuachén man Jesucristó rihaan nij síí ta̱j riꞌyunj man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Dan me se caꞌnéé Jesucristó man chuvi̱j nij snóꞌo yoꞌ, ne̱ cataj xnaꞌanj soꞌ rihaan nij soꞌ da̱j quiꞌya̱j nij soꞌ a: ―Se̱ caꞌanj nij soj rej ma̱n nij síí yaníj maꞌ. Se̱ caꞌanj soj chiháán nij yuvii̱ samaritana maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Rihaan o̱rúnꞌ nij yuvii̱ israelitá caꞌa̱nj soj á. ꞌO̱ se ase vaa daán Diose̱ matzinj vaa nij soꞌ, tza̱j ne̱ caꞌanj niꞌya̱ nij soꞌ, ne̱ ne nocoꞌ sa̱ꞌ nij soꞌ man Diose̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Dan me se caꞌa̱nj soj, ne̱ caꞌmi̱i̱ natáj soj rihaan nij soꞌ, cata̱j soj: “Nichru̱nꞌ quisi̱j güii gu̱un chij Diose̱ rihaan chumii̱ nihánj ado̱nj”. Da̱nj cata̱j soj á. ");
INSERT INTO trcNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nahu̱un sa̱ꞌ nij síí ranꞌ, quiꞌya̱j soj, ne̱ cunu̱u iꞌna̱ꞌ uún nij síí caviꞌ, quiꞌya̱j soj, ne̱ nahu̱un sa̱ꞌ nij síí ranꞌ luj riꞌyuj, quiꞌya̱j uún soj, ne̱ quiri̱i̱ soj man nij nana̱ chre̱e nimán nij yuvii̱ á. Cuano̱ nihánj me rquej rej nucua̱j man soj quiꞌya̱j soj da̱nj a. Cheꞌé dan nihánj me cata̱j xnaꞌanj ꞌu̱nj rihaan soj se̱ caꞌnéj soj saꞌanj man nij yuvii̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","”Se̱ nanoꞌ soj agaꞌ oró míí do̱ꞌ, agaꞌ platá catzi̱i̱ do̱ꞌ, na̱j guun saꞌanj do̱ꞌ, cara̱a soj rque se‑caxra̱nꞌ soj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Se̱ nica̱j soj xnánj soj maꞌ. Se̱ caꞌanj vi̱j cotoó ga̱ soj maꞌ. Se̱ quiꞌnij tacóó soj canj maꞌ. Ne̱ chruun garroté se̱ coro̱ꞌ soj cache̱e̱ soj maꞌ. Ma̱a̱n se ga̱a̱ u̱u̱n soj caꞌa̱nj soj á. ꞌO̱ se no̱ xcúún yuvii̱ rque̱ yuvii̱ chraa cha̱ soj cheꞌé suun sa̱ꞌ ꞌyaj suun soj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Asa̱ꞌ catúj soj chumanꞌ noco̱o do̱ꞌ, chumanꞌ raꞌa̱ do̱ꞌ, ne̱ xna̱ꞌanj soj man nij yuvii̱ me síí ne̱ chumanꞌ yoꞌ me síí sa̱ꞌ, ga̱a ne̱ cuchi̱ꞌ soj tucuá síí sa̱ꞌ yoꞌ, ne̱ ca̱yáán soj tucuá soꞌ nda̱a se cavi̱i̱ uún soj caꞌa̱nj soj á. ");
INSERT INTO trcNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Asa̱ꞌ cuchiꞌ soj tucuá síí sa̱ꞌ yoꞌ, ne̱ veꞌé caꞌmi̱i̱ soj nana̱ sa̱ꞌ rihaan nij síí tucua̱ yoꞌ, cata̱j soj se vaa dínj ga̱a̱ cuma̱n nij soꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ne̱ sese ya̱ síí sa̱ꞌ me nij síí tucua̱ yoꞌ, ne̱ ya̱ dínj ga̱a̱ cuma̱n nij soꞌ, qui̱ꞌyáj a. Tza̱j ne̱ sese nuveé si̱j sa̱ꞌ me nij soꞌ, ne̱ ca̱nica̱j uún nana̱ sa̱ꞌ caꞌmii soj rihaan maꞌa̱n soj, qui̱ꞌyáj, tza̱j ne̱ se̱ cavii sa̱ꞌ nij síí tucua̱ yoꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ne̱ na̱j guun yuvii̱ se̱ caꞌmii sa̱ꞌ ga̱ soj do̱ꞌ, na̱j guun yuvii̱ se̱ caꞌvej rá cuno̱ nana̱ aꞌmii soj do̱ꞌ, cavi̱i̱ soj veꞌ tucuá soꞌ cavi̱i̱ soj chiháán soꞌ cavi̱i̱ soj, ne̱ nacuna̱nꞌ soj tacóó soj tucuayu̱u soj yoꞌóó tachru̱u̱ avii chumanꞌ yoꞌ rihaan yoꞌóó, ne̱ nda̱a dan, ga̱a ne̱ queneꞌe̱n yuvii̱ se vaa síí ma̱n chumanꞌ yoꞌ tumé cacunꞌ se vaa ne uno nij soꞌ rihaan Diose̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa güii caꞌne̱ꞌ ꞌu̱nj cacunꞌ cheꞌé nij yuvii̱, ga̱a ne̱ quira̱nꞌ yuvii̱ ma̱n chumanꞌ yoꞌ doj sayuun rihaan nij síí chiꞌi̱i̱ ma̱n chumanꞌ Sodoma do̱ꞌ, rihaan yuvii̱ ma̱n chumanꞌ Gomorra do̱ꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","”Dan me se caꞌne̱j ꞌu̱nj man soj rej ma̱n síí me rá quiꞌya̱j sayuun man soj a. Ase vaa matzinj va̱j rej ma̱n xcaꞌyanj caꞌnu̱ꞌ roꞌ, da̱nj ga̱a̱ soj ado̱nj. Cheꞌé dan ga̱a̱ cu̱u raa̱ soj á. Ase cacui̱j raa̱ xtaa roꞌ, da̱nj cacui̱j ga̱a̱ raa̱ soj á. Tza̱j ne̱ ase vaa taj va̱j cacunꞌ tumé chaꞌaa̱n roꞌ, da̱nj ga̱a̱ soj, se̱ cutumé soj cacunꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Cu̱tumé ndoꞌo soj man soj se̱ quiꞌyaj yuvii̱ sayuun man soj maꞌ. Dan me se caꞌa̱nj ni̱caj nij yuvii̱ man soj rihaan cuese̱, ne̱ go̱ꞌ ndoꞌo nij soꞌ vará xráá soj rá veꞌ tucuꞌyón nij soꞌ se‑tucua̱nj Moisés a. ");
INSERT INTO trcNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ne̱ caꞌa̱nj ni̱caj nij yuvii̱ man soj rihaan síí nica̱j suun do̱ꞌ, rihaan síí nica̱j suun rey do̱ꞌ, cheꞌé se me soj síí noco̱ꞌ manj a. Ne̱ cata̱j xnaꞌanj soj rihaan nij síí nica̱j suun do̱ꞌ, rihaan nij síí yaníj do̱ꞌ, cheꞌej a. ");
INSERT INTO trcNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Asa̱ꞌ tacuachén nij soꞌ man soj rihaan nij síí nica̱j suun, ne̱ se̱ nanó rá soj da̱j caꞌmi̱i̱ soj rihaan nij soꞌ maꞌ. Ma̱a̱n Nimán Diose̱ rque̱ nu̱ꞌ nana̱ caꞌmi̱i̱ soj ma̱a̱n orá yoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ꞌO̱ se nuveé maꞌa̱n soj me nij síí caꞌmi̱i̱ rihaan nij soꞌ maꞌ. ꞌO̱ se Nimán Rej níꞌ me síí rque̱ nana̱ caꞌmi̱i̱ soj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","”Dan me se caꞌa̱nj ni̱caj snóꞌo man tinúú snóꞌo rihaan yuvii̱, ne̱ ticavi̱ꞌ nii man tinúú snóꞌo yoꞌ, quiꞌya̱j maꞌa̱n soꞌ na̱nj ado̱nj. Ne̱ caꞌa̱nj ni̱caj snóꞌo man taꞌníí snóꞌo rihaan yuvii̱, ne̱ ticavi̱ꞌ nii man taꞌníí snóꞌo yoꞌ, quiꞌya̱j soꞌ ei. Ne̱ cunu̱ꞌ xnii ga̱ rej xnii, ne̱ caꞌa̱nj ni̱caj xnii man rej xnii rihaan yuvii̱, ne̱ ticavi̱ꞌ nii man rej xnii yoꞌ, quiꞌya̱j xnii ei. ");
INSERT INTO trcNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ne̱ quita̱j riꞌyunj cunuda̱nj yuvii̱ man soj cheꞌé se me soj síí noco̱ꞌ manj a. Tza̱j ne̱ síí yoꞌo̱ canoco̱ꞌ manj nda̱a se quisi̱j nu̱ꞌ sayuun yoꞌ roꞌ, veꞌé cavi̱i̱ sa̱ꞌ soꞌ rihaan Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ne̱ sese quiꞌya̱j nij síí ma̱n yoꞌo̱ chumanꞌ sayuun man soj, ne̱ cuna̱nj soj caꞌa̱nj soj yoꞌó chumanꞌ á. Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa se̱ canó cunuda̱nj nij chumanꞌ ma̱n nij yuvii̱ israelitá caꞌa̱nj soj, ne̱ caꞌna̱ꞌ uún ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ rihaan chumii̱ nihánj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","”Dan me se tucuꞌyón ꞌu̱nj se‑na̱na̱j rihaan soj, ne̱ noco̱ꞌ soj se‑na̱na̱j a. Ne̱ ase vaa uno mozó rihaan se‑ruꞌve̱e̱ mozó roꞌ, da̱nj vaa uno soj rihanj na̱nj á. Ne̱ neꞌen soj se vaa ase vaa ꞌyaj yuvii̱ man síí tucuꞌyón nana̱ rihaan tuviꞌ roꞌ, da̱nj quiꞌya̱j uún nij yuvii̱ man síí noco̱ꞌ nana̱ yoꞌ a. Ne̱ ase vaa ꞌyaj yuvii̱ man nij ruꞌvee roꞌ, da̱nj quiꞌya̱j uún nij yuvii̱ man se‑mo̱zó ruꞌvee yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Dan me se neꞌen síí noco̱ꞌ nana̱ neꞌen mozó neꞌen da̱j quiꞌya̱j yuvii̱ man maꞌa̱n soꞌ, tza̱j ne̱ me ina̱nj rá soꞌ gu̱un soꞌ nda̱a vaa síí tucuꞌyón nana̱ man soꞌ do̱ꞌ, nda̱a vaa se‑ruꞌve̱e̱ soꞌ do̱ꞌ a. Dan me se tucuꞌnáj nij yuvii̱ Beelzebú manj, cataj nij yuvii̱ se vaa síí chre̱e mej a. Ne̱ ase vaa rej soj vaa ꞌu̱nj a. Cheꞌé dan da̱nj caꞌmi̱i̱ nij yuvii̱ nana̱ vaa da̱nj cheꞌé maꞌa̱n soj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","”Cheꞌé dan se̱ cuchuꞌviꞌ soj ni̱ꞌyaj soj yuvii̱ me rá quiꞌya̱j sayuun man soj maꞌ. ꞌO̱ se nu̱ꞌ nana̱ caꞌmii yuve̱ nij yuvii̱ do̱ꞌ, nu̱ꞌ se vaa quiꞌyaj yuve̱ nij yuvii̱ do̱ꞌ, nu̱ꞌ yoꞌ roꞌ, nu̱riha̱nj queneꞌe̱n cunuda̱nj yuvii̱ vaa güii ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nana̱ aꞌmii yuve̱ ꞌu̱nj rihaan soj cuano̱ roꞌ, caꞌmi̱i̱ ranga̱ꞌ soj á. Ne̱ nu̱ꞌ se vaa aꞌmii ꞌu̱nj xréé soj roꞌ, cavi̱i̱ soj rej queneꞌe̱n yuvii̱ man soj, ne̱ caꞌmi̱i̱ natáj soj nana̱ yoꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","”Ne̱ se̱ cuchuꞌviꞌ soj queneꞌe̱n soj nij síí gu̱un nucua̱j ticavi̱ꞌ man ina̱nj nee̱ man soj maꞌ. ꞌO̱ se se̱ guun nucua̱j nij soꞌ ticavi̱ꞌ nij soꞌ man nimán soj a̱ maꞌ. Tza̱j ne̱ vaa cheꞌé cuchuꞌvi̱ꞌ soj ni̱ꞌyaj soj Diose̱ na̱nj á. ꞌO̱ se soꞌ me síí gu̱un nucua̱j quiꞌya̱j caca̱a̱ nimán soj caca̱a̱ nee̱ man soj caca̱a̱ rihaan yaꞌan ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","”Neꞌen soj da̱j vaa nij xtâj chri̱nꞌ se vaa vi̱j u̱nꞌ yoꞌ nó yoꞌo̱ saꞌanj nii cuartó a. Tza̱j ne̱ se̱ guun cavi̱ꞌ yoꞌo̱ xoꞌ quini̱j xoꞌ rihaan yoꞌóó, sese naꞌvej Rej soj síí nicu̱nꞌ xta̱ꞌ cavi̱ꞌ yoꞌo̱ xoꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ne̱ Diose̱ me se vaa cuentá yuvé raa̱ soj ꞌyaj soꞌ, ne̱ neꞌen soꞌ me daj yuvé raa̱ soj, ");
INSERT INTO trcNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ne̱ cheꞌé dan se̱ cuchuꞌviꞌ soj cheꞌé sayuun quiꞌya̱j yuvii̱ man soj maꞌ. ꞌO̱ se uxrá vaa yuꞌvee doj nó soj rihaan xtâj chri̱nꞌ yoꞌ, ꞌyaj Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","”Cheꞌé se tumé Diose̱ man soj, cheꞌé dan no̱ xcúún soj nata̱ꞌ ya̱ soj rihaan yuvii̱ se vaa me soj síí noco̱ꞌ manj, ne̱ nu̱ꞌ síí ꞌyaj da̱nj roꞌ, vaa güii, ne̱ nata̱ꞌ ꞌu̱nj rihaan Réé ꞌu̱nj síí nicu̱nꞌ xta̱ꞌ se vaa si̱j noco̱ꞌ manj me soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ne̱ síí taj xnaꞌanj rihaan yuvii̱ se vaa ne nocoꞌ soꞌ manj roꞌ, vaa güii, ne̱ cata̱j xnaꞌanj ꞌu̱nj rihaan Réé ꞌu̱nj síí nicu̱nꞌ xta̱ꞌ se vaa nuveé si̱j noco̱ꞌ manj me soꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","”Se̱ guun rá soj se vaa caꞌnáꞌ ꞌu̱nj rihaan chumii̱ nihánj cheꞌé rej dínj doj ca̱yáán nij yuvii̱ ma̱n rihaan chumii̱ nihánj ga̱ tuviꞌ yuvii̱ maꞌ. Ne qui̱ꞌyáj da̱nj maꞌ. ꞌO̱ se cheꞌé se caꞌnáꞌ ꞌu̱nj rihaan chumii̱ nihánj, cheꞌé dan cunu̱ꞌ ndoꞌo yuvii̱ ga̱ tuviꞌ yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ꞌO̱ se caꞌnáꞌ ꞌu̱nj cheꞌé rej nata̱ꞌ ꞌu̱nj se‑na̱na̱j rihaan yuvii̱, tza̱j ne̱ se̱ cuno cunuda̱nj nij yuvii̱ rihanj maꞌ. Cheꞌé dan cunu̱ꞌ snóꞌo ga̱ rej maꞌa̱n soꞌ, ne̱ xa̱ꞌ chana̱, tza̱j ne̱ cunu̱ꞌ noꞌ ga̱ nii noꞌ do̱ꞌ, ga̱ nii che̱j noꞌ do̱ꞌ, cheꞌej a. ");
INSERT INTO trcNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ne̱ nij tuviꞌ yuvii̱ síí ma̱n rá veꞌ tucuá yuvii̱ cunu̱ꞌ ga̱ yuvii̱ na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Sese gu̱un rá yoꞌo̱ soꞌ se vaa sa̱ꞌ doj vaa rej soꞌ do̱ꞌ, nii soꞌ do̱ꞌ, rihanj, ne̱ taj cheꞌé cata̱j soꞌ se vaa si̱j noco̱ꞌ manj me soꞌ maꞌ. Ne̱ sese gu̱un rá yoꞌo̱ soꞌ se vaa sa̱ꞌ doj vaa taꞌníí soꞌ rihanj, ne̱ taj cheꞌé cata̱j soꞌ se vaa si̱j noco̱ꞌ manj me soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ne̱ síí naꞌvej rá quira̱nꞌ sayuun cheꞌé se me soꞌ síí noco̱ꞌ manj roꞌ, taj cheꞌé cata̱j soꞌ se vaa me soꞌ síí noco̱ꞌ manj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Síí cavii sa̱ꞌ nimán rihaan chumii̱ nihánj roꞌ, cavi̱ꞌ nu̱ꞌ soꞌ a. Ne̱ síí caviꞌ cheꞌé se noco̱ꞌ soꞌ manj roꞌ, soꞌ me síí ga̱a̱ iꞌna̱ꞌ nimán nu̱ꞌ cavii nu̱ꞌ caꞌanj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","”Sese aꞌmii sa̱ꞌ yoꞌo̱ soꞌ ga̱ soj, ne̱ si̱j aꞌmii sa̱ꞌ ga̱j me soꞌ ado̱nj. Ne̱ sese aꞌmii sa̱ꞌ soꞌ ga̱j, ne̱ si̱j aꞌmii sa̱ꞌ ga̱ síí caꞌnéé manj rihaan chumii̱ nihánj me uún soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Sese aꞌmii sa̱ꞌ yoꞌo̱ soꞌ ga̱ ꞌo̱ síí nataꞌ se‑na̱na̱ Diose̱, cheꞌé se veꞌé ꞌyaj soꞌ nataꞌ soꞌ se‑na̱na̱ Diose̱, ne̱ rá se vaa maꞌa̱n síí nataꞌ se‑na̱na̱ Diose̱ vaa soꞌ uún ado̱nj. Dan me se ꞌo̱ cuya̱a̱n na̱ruꞌvee Diose̱ rihaan soꞌ ga̱ maꞌa̱n síí nataꞌ se‑na̱na̱ Diose̱ ei. Ne̱ sese aꞌmii sa̱ꞌ yoꞌo̱ soꞌ ga̱ yoꞌo̱ síí sa̱ꞌ ꞌyaj, ne̱ na̱ruꞌvee Diose̱ rihaan soꞌ uún ado̱nj. ꞌO̱ cuya̱a̱n na̱ruꞌvee Diose̱ rihaan soꞌ ga̱ maꞌa̱n síí sa̱ꞌ ꞌyaj ei. ");
INSERT INTO trcNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Dan me se a̱ me maꞌa̱n yoꞌo̱ síí rqué do̱j na acoj coꞌo̱ yoꞌo̱ nij síí noco̱ꞌ u̱u̱n nihánj cheꞌé se‑chu̱vií ꞌu̱nj, ne̱ ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa daj chiha̱a̱ míj se̱ quinavij se sa̱ꞌ na̱ruꞌvee Diose̱ rihaan síí rqué do̱j na yoꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Dan me se quisíj nana̱ yoꞌ nana̱ cataj xnaꞌanj Jesucristó rihaan chuvi̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ curiha̱nj Jesucristó rej yoꞌ, ne̱ caꞌanj soꞌ chiháán nij yuvii̱ israelitá tu̱cuꞌyón soꞌ rihaan nij soꞌ ne̱ caꞌmi̱i̱ natáj soꞌ rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Dan me se ꞌni̱j síí cuꞌna̱j Juan síí cutaꞌ ne man yuvii̱ tagaꞌ, ne̱ cuchiꞌ nana̱ rihaan soꞌ cheꞌé nu̱ꞌ se vaa quiꞌyaj Jesucristó a. Cheꞌé dan caꞌnéé soꞌ vi̱j tuviꞌ nij síí tucuꞌyón se‑na̱na̱ soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ne̱ nana̱ nihánj roꞌ, xnáꞌanj ro̱j soꞌ man Jesucristó, quiꞌyaj síí cuꞌna̱j Juan a: ―So̱ꞌ me síí caꞌna̱ꞌ ti̱nanii man yuvii̱ rihaan sayuun naꞌ. Ase na̱ꞌvi̱j níꞌ caꞌna̱ꞌ yoꞌó soꞌ xa̱ꞌ. ―Dan me nana̱ me rá síí cuꞌna̱j Juan xna̱ꞌanj ro̱j soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ga̱a ne̱ cataj xnaꞌanj Jesucristó rihaan ro̱j soꞌ a: ―Cavi̱i̱ ro̱j so̱j cuchi̱ꞌ uún ro̱j so̱j rihaan síí cuꞌna̱j Juan, ne̱ cata̱j xnaꞌanj ro̱j so̱j rihaan soꞌ nu̱ꞌ nana̱ cuno ro̱j so̱j do̱ꞌ, nu̱ꞌ se vaa queneꞌen ro̱j so̱j do̱ꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Dan me se nij síí tuchri̱i roꞌ, naxraꞌ rihaan, ne̱ nij síí naꞌvee cache̱e̱ roꞌ, chéé nij soꞌ, ne̱ nij síí ranꞌ luj riꞌyuj roꞌ, nahuun sa̱ꞌ, ne̱ nij síí soꞌo̱ roꞌ, nachuguu̱n xréé nij soꞌ, ne̱ nij síí caviꞌ roꞌ, cunuu iꞌna̱ꞌ uún, ne̱ nij síí nique̱ roꞌ, uno nij soꞌ nana̱ sa̱ꞌ a. Nu̱ꞌ nihánj cata̱j xnaꞌanj ro̱j so̱j rihaan síí cuꞌna̱j Juan yoꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ne̱ cata̱j uún ro̱j so̱j rihaan síí cuꞌna̱j Juan se vaa cavi̱i̱ sa̱ꞌ soꞌ quiꞌya̱j Diose̱, sese se̱ guun naꞌa̱j soꞌ ni̱ꞌyaj soꞌ manj a. Da̱nj caꞌmi̱i̱ ro̱j so̱j rihaan síí cuꞌna̱j Juan yoꞌ á ―taj Jesucristó rihaan ro̱j síí tucuꞌyón se‑na̱na̱ Juan yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Dan me se caꞌanj ro̱j soꞌ, ga̱a ne̱ guun cheꞌe̱ Jesucristó caꞌmii soꞌ rihaan cunuda̱nj nij yuvii̱ cheꞌé síí cuꞌna̱j Juan síí cutaꞌ ne man yuvii̱ a: ―Asi̱j caꞌanj soj rej tacaan queneꞌe̱n soj man síí cuꞌna̱j Juan roꞌ, ne̱ da̱j ga̱a̱ soꞌ queneꞌe̱n soj, rá soj ga̱. Ase vaa yoꞌo̱ rcoo̱ naa̱n ndoꞌo ꞌyaj nana̱ vaa soꞌ, rá soj naꞌ. Guun vi̱j nimán soꞌ cheꞌé tucuáán noco̱ꞌ soꞌ, rá soj naꞌ. Taj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ma̱a̱n se da̱j ga̱a̱ soꞌ rá soj, asi̱j caꞌanj soj queneꞌe̱n soj man soꞌ ga̱. Si̱j nu̱u̱ yatzíj laru̱u ndoꞌo me soꞌ, rá soj naꞌ. Taj maꞌ. ꞌO̱ se nij síí nu̱u̱ yatzíj laru̱u roꞌ, ya̱nj rá veꞌ tucuá síí nica̱j suun rey ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ma̱a̱n se da̱j ga̱a̱ síí cuꞌna̱j Juan rá soj, asi̱j caꞌanj soj queneꞌe̱n soj man soꞌ ga̱. Si̱j nataꞌ se‑na̱na̱ Diose̱ me soꞌ, rá soj naꞌ. Ya̱ uxrá ei. Ne̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa sa̱ꞌ doj vaa soꞌ rihaan cunuda̱nj nij síí nataꞌ se‑na̱na̱ Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","”ꞌO̱ se nana̱ nihánj nana̱ no̱ rihaan danj Diose̱ roꞌ, taj xnaꞌanj cheꞌé síí cuꞌna̱j Juan a: “Vaa síí caꞌa̱nj suun cheꞌé ꞌu̱nj, ne̱ caꞌne̱j ꞌu̱nj man soꞌ quita̱j ya̱a̱n soꞌ rihaan so̱ꞌ, ne̱ nuchra̱nꞌ nimán yuvii̱ veꞌé caꞌmi̱i̱ nij yuvii̱ ga̱ so̱ꞌ, quiꞌya̱j soꞌ a”. Da̱nj taj danj Diose̱ cheꞌé síí cuꞌna̱j Juan se vaa nuchra̱nꞌ nimán yuvii̱ veꞌé caꞌmi̱i̱ nij yuvii̱ ga̱ síí caꞌna̱ꞌ ti̱nanii man nij yuvii̱ rihaan sayuun, quiꞌya̱j síí cuꞌna̱j Juan, taj danj Diose̱, ne̱ da̱nj quiꞌyaj soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","”Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa si̱j sa̱ꞌ doj rihaan cunuda̱nj nij yuvii̱ ma̱n rihaan chumii̱ me síí cuꞌna̱j Juan síí cutaꞌ ne man yuvii̱ a. A̱ ꞌó yuvii̱ ne vaa sa̱ꞌ doj rihaan soꞌ maꞌ. Tza̱j ne̱ cuano̱ roꞌ, uun chij Diose̱ nimán yuvii̱ ma̱n rihaan chumii̱ nihánj, ne̱ na̱j guun yuvii̱ uun chij Diose̱ nimán roꞌ, me síí sa̱ꞌ doj rihaan síí cuꞌna̱j Juan a. ");
INSERT INTO trcNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Dan me se asi̱j tucuꞌyón síí cuꞌna̱j Juan rihaan yuvii̱ nda̱a cuano̱ me se naquiꞌyaj ino̱ ndoꞌo yuvii̱ se‑na̱na̱ Diose̱ se vaa gu̱un chij soꞌ rihaan chumii̱ nihánj, ne̱ vaa síí sca̱ꞌ ndoꞌo síí me ina̱nj rá cata̱j da̱j quiꞌya̱j Diose̱ asa̱ꞌ guun chij Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ꞌO̱ se nij síí nataꞌ se‑na̱na̱ Diose̱ rihaan yuvii̱ ga̱a naá do̱ꞌ, nu̱ꞌ se‑tucua̱nj Moisés do̱ꞌ, nda̱a maꞌa̱n síí cuꞌna̱j Juan do̱ꞌ, cataj xnaꞌanj ndoꞌo nij soꞌ cheꞌé güii gu̱un chij Diose̱ nimán yuvii̱ ma̱n rihaan chumii̱ nihánj na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Dan me se a̱j neꞌen soj se vaa síí cuꞌna̱j Elías síí nataꞌ se‑na̱na̱ Diose̱ rihaan yuvii̱ ga̱a naá roꞌ, caꞌna̱ꞌ uún soꞌ rihaan chumii̱ nihánj, taj danj Diose̱ a. Dan me se sese me rá soj gu̱un ya̱ rá soj cuno̱ soj nana̱ nihánj, ne̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa síí cuꞌna̱j Juan me síí ata̱ se‑su̱u̱n síí cuꞌna̱j Elías síí cane ga̱a naá yoꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Sese ta̱j yuꞌuj xréé soj, ne̱ cuno̱ soj nana̱ nihánj ei. ");
INSERT INTO trcNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","”Ne̱ da̱j vaa yuvii̱ ma̱n rihaan chumii̱ nihánj cuano̱, rá soj ga̱. Dan me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj á. Ase vaa xnii caꞌanj rihaan yuꞌvee ne̱ tico ga̱ tuviꞌ roꞌ, vaa nij yuvii̱ ma̱n rihaan chumii̱ nihánj ado̱nj. Dan me se yáán nij xnii yoꞌ rihaan yoꞌóó, ");
INSERT INTO trcNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ne̱ aguáj nij xnii rihaan tuviꞌ xnii, taj nij xnii: “Nica̱j núj taꞌánj núj, goꞌ núj chraꞌ choco̱ꞌ, tza̱j ne̱ me cheꞌé ne raꞌa̱nj soj ga̱. Ne̱ goꞌ núj chraꞌ xnangá, tza̱j ne̱ me cheꞌé ne taꞌve̱e soj ga̱. Me cheꞌé ne ꞌyaj soj nda̱a vaa me rá núj ga̱”, taj nij xnii rihaan tuviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ꞌO̱ se caꞌnaꞌ síí cuꞌna̱j Juan síí cutaꞌ ne man yuvii̱, ga̱a ne̱ ne cha̱ soꞌ do̱ꞌ, ne coꞌo̱ soꞌ do̱ꞌ, maꞌ. Ne̱ cheꞌé dan taj nij yuvii̱ se vaa nu̱u̱ nana̱ chre̱e nimán soꞌ, taj nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ne̱ caꞌnáꞌ ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱, ga̱a ne̱ niha̱ꞌ rá ꞌu̱nj chá ꞌu̱nj do̱ꞌ, coꞌo ꞌu̱nj do̱ꞌ, ga̱a ne̱ cheꞌé dan taj uún nij yuvii̱ se vaa síí cachén chá do̱ꞌ, síí cachén coꞌo do̱ꞌ, mé ꞌu̱nj, taj uún nij yuvii̱ a. Ne̱ taj uún nij soꞌ se vaa tuvíꞌ ꞌu̱nj me síí aꞌnéj puextó man yuvii̱ do̱ꞌ, yoꞌó nij síí tumé cacunꞌ do̱ꞌ, taj nii a. Da̱nj tuꞌva nij soꞌ, tza̱j ne̱ ne neꞌen uxrá nij soꞌ maꞌ. Sese xca̱j yuvii̱ cuentá da̱j vaa ꞌyaj rój, ne̱ gu̱un ya̱ rá nij yuvii̱ se vaa si̱j cu̱u raa̱ me rój ga̱ síí cuꞌna̱j Juan yoꞌ ado̱nj ―taj Jesucristó rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Síj, ga̱a ne̱ guun cheꞌe̱ Jesucristó cutaꞌ Jesucristó cacunꞌ xráá nij yuvii̱ ma̱n vaꞌnu̱j chumanꞌ a. Dan me se cutaꞌ soꞌ cacunꞌ xráá nij soꞌ se vaa guun nichra̱j nimán nij soꞌ a. Dan me se nda̱ꞌ se doj a̱ vaa suun sa̱ꞌ quiꞌyaj suun soꞌ chiháán nij soꞌ queneꞌen nij soꞌ rihaan suun sa̱ꞌ quiꞌyaj suun soꞌ yoꞌó chumanꞌ, tza̱j ne̱ ne ca̱nica̱j nimán nij soꞌ a̱ maꞌ, taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ne̱ nihánj me nana̱ caꞌmii Jesucristó cheꞌé nij yuvii̱ ma̱n nij chumanꞌ yoꞌ a: ―Nique̱ soj si̱j ma̱n chumanꞌ Corazín a. Nique̱ soj si̱j ma̱n chumanꞌ Betsaida a. ꞌO̱ se quira̱nꞌ uxrá soj sayuun na̱nj á. Dan me se nij síí ma̱n chumanꞌ Tiro do̱ꞌ, nij síí ma̱n chumanꞌ Sidón do̱ꞌ, me síí chiꞌi̱i̱ nimán na̱nj á. Tza̱j ne̱ sese caꞌanj ꞌu̱nj chiháán nij soꞌ ne̱ sese quiꞌyáj suun sa̱ꞌ noco̱o niꞌya̱j nij soꞌ, ga̱a ne̱ cuno nij soꞌ se‑na̱na̱j, ne̱ guun ya̱ rá nij soꞌ se vaa tumé nij soꞌ cacunꞌ, ne̱ canica̱j nimán nij soꞌ, ne̱ quinanó ndoꞌo rá nij soꞌ cheꞌé cacunꞌ tumé nij soꞌ, ne̱ nda̱a yatzíj yaꞌ cunuû nij soꞌ, ne̱ nda̱a yaj chruun acaa ruvaj caraa nij soꞌ raa̱ nij soꞌ, cheꞌé se quinanó rá nij soꞌ cheꞌé cacunꞌ tumé nij soꞌ asuun sa̱j ado̱nj. Nihánj, ne̱ ne caꞌa̱nj ꞌu̱nj maꞌ. Ma̱a̱n ina̱nj chiháán soj ꞌnaj, ne̱ quiꞌyáj suun sa̱ꞌ noco̱o queneꞌen maꞌa̱n soj, tza̱j ne̱ ne ca̱nica̱j nimán nij soj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Dan me se ya̱j cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa güii caꞌne̱ꞌ ꞌu̱nj cacunꞌ cheꞌé nij yuvii̱ roꞌ, doj a̱ ga̱a̱ sayuun quira̱nꞌ soj rihaan sayuun quira̱nꞌ nij síí chiꞌi̱i̱ ma̱n chumanꞌ Tiro do̱ꞌ, ma̱n chumanꞌ Sidón do̱ꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","”Ne̱ vaa soj si̱j ma̱n chumanꞌ Capernaum uún á. Ne̱ síí sa̱ꞌ ina̱nj me maꞌa̱n soj, rá soj naꞌ. Nuveé si̱j sa̱ꞌ me soj maꞌ. Síí caꞌa̱nj rihaan yaꞌan gu̱un soj á. Dan me se nij síí ma̱n chumanꞌ Sodoma roꞌ, me síí chiꞌi̱i̱ nimán a. Tza̱j ne̱ sese caꞌanj ꞌu̱nj chiháán nij soꞌ ne̱ sese quiꞌyáj suun sa̱ꞌ noco̱o niꞌya̱j nij soꞌ, ne̱ cuno nij soꞌ se‑na̱na̱j, ne̱ guun ya̱ rá nij soꞌ se vaa tumé nij soꞌ cacunꞌ, ne̱ canica̱j nimán nij soꞌ, ne̱ ne caca̱a̱ chiháán nij soꞌ maꞌ. Ne̱ na̱j chiháán nij soꞌ nda̱a cuano̱ asuun sa̱j a. Tza̱j ne̱ ne caꞌa̱nj ꞌu̱nj maꞌ. Ma̱a̱n se ina̱nj chiháán soj ꞌnaj, ne̱ quiꞌyáj suun sa̱ꞌ noco̱o yoꞌ queneꞌen maꞌa̱n soj, tza̱j ne̱ ne ca̱nica̱j nimán nij soj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Dan me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa güii caꞌne̱ꞌ ꞌu̱nj cacunꞌ cheꞌé nij yuvii̱ roꞌ, doj a̱ ga̱a̱ sayuun quira̱nꞌ soj rihaan sayuun quira̱nꞌ nij síí chiꞌi̱i̱ ma̱n chumanꞌ Sodoma yoꞌ ado̱nj ―taj Jesucristó cheꞌé nij yuvii̱ ne caꞌve̱j rá cuno̱ se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Dan me se güii yoꞌ cachíín niꞌya̱j Jesucristó rihaan Diose̱, cataj soꞌ: ―Síí ꞌni̱j raꞌa xta̱ꞌ do̱ꞌ, síí ꞌni̱j raꞌa chumii̱ do̱ꞌ, mé so̱ꞌ, Ata̱j Chij. Ne̱ sa̱ꞌ uxrá quiꞌyáá so̱ꞌ caráán so̱ꞌ rihaan nij síí avii raa̱ do̱ꞌ, rihaan nij síí acaj cuentá do̱ꞌ, se vaa se̱ cuno nij soꞌ se‑na̱na̱j maꞌ. Ma̱a̱n nij síí vaa nica̱ꞌ nimán roꞌ, veꞌé cuno nij soꞌ, quiꞌyáá so̱ꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Da̱nj ina̱nj quiꞌyáá so̱ꞌ, cheꞌé yan da̱nj me rá so̱ꞌ qui̱ꞌyáá so̱ꞌ, Ata̱j ―taj Jesucristó rihaan Rej soꞌ Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Canica̱j Jesucristó caꞌmii soꞌ rihaan nij yuvii̱, cataj soꞌ a: ―A̱j rqué Réé ꞌu̱nj Diose̱ cunuda̱nj rasu̱u̱n rihanj á. Ne̱ a̱ ꞌó síí ne neꞌen da̱j vaa ꞌu̱nj; ma̱a̱n o̱rúnꞌ Réj neꞌen a. ꞌO̱ se taꞌníí soꞌ mej ado̱nj. Ne̱ a̱ ꞌó yuvii̱ ne neꞌen da̱j vaa Réj maꞌ. Ma̱a̱n o̱rúnꞌ ꞌu̱nj neꞌen da̱j vaa soꞌ ado̱nj. Ne̱ sese me rá ꞌu̱nj cata̱j xnaꞌanj ꞌu̱nj rihaan yoꞌó nij yuvii̱ da̱j vaa Réj, ne̱ queneꞌe̱n yoꞌó nij soꞌ uún ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ne̱ sese vaa síí navij ndoꞌo rá cheꞌé yan nanoꞌ uxrá soꞌ tucuáán sa̱ꞌ do̱ꞌ, sese vaa síí nanó ndoꞌo rá cheꞌé yan ne gu̱un nucua̱j soꞌ quiꞌya̱j soꞌ nu̱ꞌ tucuáán sa̱ꞌ tucuáán noco̱ꞌ soꞌ do̱ꞌ, ne̱ caꞌna̱ꞌ nij síí vaa da̱nj rihanj á. ꞌO̱ se nara̱a̱n rá nij síí vaa da̱nj, qui̱ꞌyáj na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Dan me se canoco̱ꞌ soj manj, ne̱ quiꞌya̱j soj tucuáán tu̱cuꞌyón ꞌu̱nj man soj á. ꞌO̱ se síí vaa nica̱ꞌ nimán mej, ne̱ quinari̱ꞌ soj chrej quinara̱a̱n rá soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ꞌO̱ se ne sayu̱u̱n vaa tucuáán cuchruj ꞌu̱nj canoco̱ꞌ soj maꞌ. ꞌO̱ se gu̱un nucua̱j soj quiꞌya̱j soj cunuda̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Dan me se naca̱ caꞌmii Jesucristó nana̱ yoꞌ, ne̱ ꞌo̱ güii naránj rá nij yuvii̱ israelitá me yoꞌ, ne̱ va̱j Jesucristó rque ꞌo̱ naa̱ ꞌnúú trigó a. Va̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ ga̱ soꞌ a. Veé dan va̱j nij soꞌ, ne̱ naꞌaan rque nij soꞌ a. Cheꞌé dan me guun cheꞌe̱ nij soꞌ cuta nij soꞌ do̱j ꞌnúú trigó chá nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tza̱j ne̱ queneꞌen nij síí fariseo se vaa cuta nij soꞌ do̱j ꞌnúú trigó, ne̱ cataj nij soꞌ rihaan Jesucristó a: ―Ni̱ꞌyaj so̱ꞌ ei. Güii naránj rá yuvii̱ me güii cuanꞌ á. Ne nó xcúún nij síí tucuꞌyón se‑na̱na̱ so̱ꞌ cuta̱ nij soꞌ ꞌnúú trigó cuanꞌ a̱ maꞌ ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Me cheꞌé, ne̱ ne naya̱a̱ soj rihaan danj Diose̱ da̱j quiꞌyaj síí cuꞌna̱j David ga̱a naá a. Ga̱a quinaꞌaan rque nij tuvi̱ꞌ nij soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ga̱a ne̱ catúj nij tuvi̱ꞌ nij soꞌ rá nuvií, ne̱ chá nij soꞌ rachrúún ta̱j rihaan se‑mesa̱ Diose̱ a. Ne̱ ne nó xcúún nij soꞌ cha̱ nij soꞌ rachrúún yoꞌ; ma̱a̱n se o̱rúnꞌ nij xrej nó xcúún cha̱ rachrúún yoꞌ a. Tza̱j ne̱ ma̱a̱n cheꞌé se rque nij soꞌ naꞌaan uxrá, ga̱a ne̱ chá nij soꞌ rachrúún yoꞌ na̱nj ado̱nj. Tza̱j ne̱ ne cata̱j Diose̱ se vaa tumé síí cuꞌna̱j David cacunꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","”Ne̱ ne naya̱a̱ soj me taj se‑tucua̱nj Moisés cheꞌé nij xrej ꞌyaj suun nuvií naꞌ. ꞌO̱ se cheꞌé se‑su̱u̱n nij soꞌ, ꞌyaj nij soꞌ se vaa ne nó xcúún yuvii̱ quiꞌya̱j yuvii̱ güii naránj rá níꞌ si̱j israelitá maꞌ. Tza̱j ne̱ ne tumé nij soꞌ cacunꞌ cheꞌé se vaa ꞌyaj nij soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ne̱ cuano̱ nihánj me cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa vaa síí nicu̱nꞌ rihaan soj cuano̱, ne̱ sa̱ꞌ doj vaa soꞌ rihaan nuvií yoꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ne̱ vaa yoꞌó nana̱ no̱ rihaan danj Diose̱ taj: “Ne uun niha̱ꞌ rá ꞌu̱nj niꞌya̱j ꞌu̱nj síí rqué xcuu rihaan ꞌu̱nj maꞌ. ꞌO̱ se uun niha̱ꞌ rá ꞌu̱nj niꞌya̱j ꞌu̱nj yuvii̱ ꞌe̱e̱ rá man tuviꞌ ado̱nj”. Yoꞌ me se‑na̱na̱ Diose̱ nana̱ no̱ rihaan yanj yoꞌ a. Sese cuno soj me taj nana̱ yoꞌ, ne̱ ne cuta̱ꞌ soj cacunꞌ xráá nij síí nihánj sa̱j maꞌ. Ne̱ ne tumé nij síí nihánj cacunꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ꞌO̱ se síí caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ mej, ne̱ no̱ xcúnj quiri̱i̱ taꞌngaj da̱j quiꞌya̱j yuvii̱ güii naránj rá yuvii̱ ado̱nj ―taj Jesucristó rihaan nij síí fariseo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ga̱a ne̱ curiha̱nj Jesucristó rej na̱j naa̱ yoꞌ, ne̱ catúj soꞌ rá veꞌ tucuꞌyón nij síí ma̱n chumanꞌ yoꞌ se‑tucua̱nj Moisés a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Dan me se yáán ꞌo̱ síí nacoo̱ raꞌa rá veꞌ yoꞌ a. Ne̱ xnáꞌanj nij síí fariseo man Jesucristó sese no̱ xcúún yuvii̱ quiꞌya̱j conoꞌó yuvii̱ man tuviꞌ yuvii̱ güii naránj rá yuvii̱ a. Da̱nj tuꞌva nij soꞌ rihaan Jesucristó, cheꞌé yan me rá nij soꞌ cuta̱ꞌ nij soꞌ cacunꞌ xráá Jesucristó cheꞌé nana̱ caꞌmi̱i̱ Jesucristó ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Sese vaa daán yoꞌo̱ soj matzinj, ne̱ sese quini̱j xoꞌ rá yuꞌuj güii naránj rá yuvii̱, ne̱ cuxu̱u̱n síí da̱a̱n man xoꞌ quiri̱i̱ soꞌ man xoꞌ rque yuꞌuj yoꞌ, raj a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ne̱ sa̱ꞌ uxrá doj vaa yuvii̱ rihaan matzinj yoꞌ ado̱nj. Cheꞌé dan no̱ xcúún yuvii̱ ra̱cuíj yuvii̱ man tuviꞌ yuvii̱ güii naránj rá yuvii̱ á ―taj Jesucristó rihaan nij síí fariseo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Canica̱j Jesucristó cataj Jesucristó rihaan síí nacoo̱ raꞌa yoꞌ: ―Tu̱cuá so̱ꞌ raꞌá so̱ꞌ á ―taj Jesucristó rihaan soꞌ a. Ga̱a ne̱ tucuá soꞌ raꞌa soꞌ, ne̱ cunuu sa̱ꞌ raꞌa soꞌ, ne̱ ase vaa gue̱e̱ ni̱chrej raꞌa soꞌ rej vaa sa̱ꞌ roꞌ, da̱nj vaa gue̱e̱ níchrej raꞌa soꞌ uún a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Dan me se curiha̱nj nij síí fariseo rá veꞌ yoꞌ, ne̱ caꞌanj nij soꞌ rej yaníj, ne̱ guun rá taranꞌ nij soꞌ da̱j ga̱a̱ quiꞌya̱j nij soꞌ ne̱ cavi̱ꞌ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tza̱j ne̱ queneꞌen Jesucristó da̱j me rá nij síí fariseo quiꞌya̱j nij soꞌ man Jesucristó a. Cheꞌé dan cavii soꞌ rej yoꞌ, ne̱ caꞌanj ndoꞌo yuvii̱ ga̱ soꞌ, ne̱ nahuun cunuda̱nj nij síí ranꞌ va̱j ga̱ nij yuvii̱, quiꞌyaj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ne̱ caꞌneꞌ soꞌ suun rihaan nij yuvii̱ se vaa se̱ nataꞌ nij yuvii̱ rihaan tuviꞌ yuvii̱ cheꞌé yan vaa ꞌyaj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Da̱nj caꞌmii Jesucristó, ga̱a ne̱ quisíj ya̱ nu̱ꞌ nana̱ nihánj nana̱ cataj xnaꞌanj Diose̱ rihaan yuvii̱ ga̱a naá a. Dan me se caꞌmii Diose̱ nana̱ nihánj cuno síí cuꞌna̱j Isaías síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá, ne̱ nataꞌ síí cuꞌna̱j Isaías nana̱ nihánj rihaan yuvii̱ cheꞌé Diose̱ a. Nana̱ caꞌmii maꞌa̱n Diose̱, cataj xnaꞌanj Diose̱ cheꞌé Jesucristó me nana̱ nihánj a: ");
INSERT INTO trcNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Xca̱j soj cuentá se vaa síí nihánj me síí ꞌyaj suun rihanj a. Narii ꞌu̱nj man soꞌ cu̱nuû soꞌ rihanj, ne̱ ꞌe̱e̱ rá ꞌu̱nj man soꞌ, ne̱ aranꞌ raj niꞌya̱j ꞌu̱nj man soꞌ a. Caꞌne̱j ꞌu̱nj Nimanj nimán soꞌ, ne̱ nata̱ꞌ soꞌ rihaan nij síí yaníj se vaa veꞌé caꞌne̱ꞌ ꞌu̱nj cacunꞌ cheꞌé nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Se̱ cunuꞌ soꞌ ga̱ yuvii̱ maꞌ. Se̱ caguáj soꞌ rihaan yuvii̱ maꞌ. Se̱ canicunꞌ soꞌ chrej caꞌa̱a̱n caꞌmi̱i̱ natáj soꞌ rihaan yuvii̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ne̱ sese nari̱ꞌ soꞌ man yoꞌo̱ síí quiriꞌ rá síí ne uun nucua̱j noco̱ꞌ chrej sa̱ꞌ, ne̱ se̱ tiriꞌ nu̱ꞌ soꞌ man síí quiriꞌ rá yoꞌ maꞌ. ꞌO̱ se ra̱cuíj soꞌ man soꞌ ado̱nj. Dan me se caꞌve̱e se ase vaa rcoo̱ xtunꞌ do̱ꞌ, caꞌve̱e se ase vaa agaꞌ yaꞌan navij na acaa rque do̱ꞌ, vaa síí quiriꞌ rá yoꞌ, tza̱j ne̱ ra̱cuíj soꞌ man soꞌ, yan cunu̱u sa̱ꞌ soꞌ ado̱nj. Dan me se quiꞌya̱j canaán nana̱ ya̱ caꞌmi̱i̱ síí ꞌyaj suun rihanj ga̱a veꞌé caꞌne̱ꞌ soꞌ cacunꞌ cheꞌé yuvii̱ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ne̱ ga̱a̱ nucua̱j rá nij síí yaníj man soꞌ se vaa ra̱cuíj soꞌ man nij síí yaníj ado̱nj”, taj Diose̱ ga̱a naá a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Guun naá do̱j, ga̱a ne̱ caꞌnaꞌ yuvii̱ rihaan Jesucristó, ne̱ nica̱j nij yuvii̱ man ꞌo̱ síí yaꞌmi̱i aráán rihaan nu̱u̱ nana̱ chre̱e nimán a. Xa̱ꞌ síí nu̱u̱ nana̱ chre̱e nimán, tza̱j ne̱ caráán rihaan soꞌ, ne̱ yaꞌmi̱i soꞌ a. Ne̱ nahuun nu̱ꞌ soꞌ, quiꞌyaj Jesucristó, ne̱ naxraꞌ rihaan soꞌ, ne̱ caꞌmii soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Dan me se queneꞌen nij yuvii̱ se vaa nahuun sa̱ꞌ soꞌ quiꞌyaj Jesucristó, ne̱ guun niha̱ꞌ rá nij yuvii̱, ne̱ cataj nij yuvii̱: ―Síí nihánj me tuviꞌ síí cuꞌna̱j David ga̱a naá, rá soj naꞌ. Síí ti̱nanii man níꞌ rihaan sayuun me síí nihánj, rá soj naꞌ ―taj nij yuvii̱, xnáꞌanj nij yuvii̱ man tuviꞌ yuvii̱ me síí me Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tza̱j ne̱ cuno nij síí fariseo da̱j caꞌmii nij yuvii̱ cheꞌé Jesucristó, ne̱ cataj nij soꞌ: ―Nuveé maꞌa̱n síí nihánj rii nana̱ chre̱e maꞌ. Ma̱a̱n se aꞌmii soꞌ ga̱ síí chre̱e uun chij síí cuꞌna̱j Beelzebú, ne̱ cheꞌé dan rii soꞌ nij nana̱ chre̱e nimán yuvii̱ ado̱nj ―taj nij síí fariseo cheꞌé Jesucristó, caꞌmii ne̱ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Dan me se queneꞌen Jesucristó da̱j vaa nimán nij síí fariseo yoꞌ, ga̱a ne̱ caꞌmii soꞌ rihaan nij síí fariseo a: ―Neꞌen soj se vaa sese vaa ꞌo̱ nación, ne̱ sese xraꞌ taꞌa̱j nij síí uun chij rihaan nación yoꞌ ne̱ cunu̱ꞌ nij maꞌa̱n nij soꞌ ga̱ tuviꞌ nij soꞌ, ne̱ vaa güii, ne̱ nu̱ꞌ nación yoꞌ quiri̱ꞌ nu̱ꞌ na̱nj ado̱nj. Ne̱ sese cunu̱ꞌ taꞌa̱j nij yuvii̱ ma̱n maꞌa̱n chumanꞌ ga̱ tuviꞌ yuvii̱, ne̱ vaa güii quiri̱ꞌ nu̱ꞌ chiháán nij soꞌ, quiꞌya̱j nij soꞌ na̱nj ado̱nj. Ne̱ sese cunu̱ꞌ taꞌa̱j nij yuvii̱ ma̱n ꞌo̱ barrió ga̱ maꞌa̱n tuviꞌ yuvii̱ síí ma̱n maꞌa̱n barrió yoꞌ, ne̱ vaa güii quiri̱ꞌ nu̱ꞌ barrió yoꞌ, quiꞌya̱j nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Cheꞌé dan me sese racuíj síí chre̱e síí cuꞌna̱j Satanás manj rii ꞌu̱nj tuviꞌ soꞌ nana̱ chre̱e nimán nij yuvii̱, ga̱a ne̱ asa̱ꞌ caꞌve̱e gu̱un chij ndoꞌo soꞌ rihaan nij yuvii̱ ma̱n rihaan chumii̱ nihánj, rá soj ga̱. ");
INSERT INTO trcNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Dan me se sese rii ꞌu̱nj nana̱ chre̱e nimán nij yuvii̱, ꞌyaj síí chre̱e cuꞌna̱j Beelzebú, cheꞌé se aꞌmii ꞌu̱nj ga̱ soꞌ, rá soj a. Tza̱j ne̱ nij síí tucuꞌyón se‑na̱na̱ soj me se veé da̱nj rii uún nij soꞌ nij nana̱ chre̱e nimán yuvii̱ uún á. Ne̱ asa̱ꞌ aꞌvee ꞌyaj nij soꞌ da̱nj, rá soj ga̱. Ne̱ vaa nij soꞌ vaa, veé da̱nj aꞌmii nij soꞌ ga̱ síí chre̱e, rá soj ga̱a̱ naꞌ. Cheꞌé nana̱ caꞌmii soj me se maꞌa̱n nij síí tucuꞌyón se‑na̱na̱ soj cuta̱ꞌ cacunꞌ xráá soj se vaa caꞌmii ne̱ soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tza̱j ne̱ ꞌu̱nj me se ya̱ Nimán Diose̱ me síí racuíj manj rii ꞌu̱nj nana̱ chre̱e nimán yuvii̱ ado̱nj. Cheꞌé dan xca̱j soj cuentá se vaa a̱j guun cheꞌe̱ Diose̱ uun chij Diose̱ rihaan chumii̱ nihánj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","”Ne̱ sese me rá yoꞌo̱ soꞌ catu̱u̱ soꞌ rá veꞌ tucuá síí ruꞌvee quiꞌya̱j itu̱u̱ soꞌ siꞌyaj síí ruꞌvee yoꞌ, ne̱ asino nu̱míj soꞌ man síí ruꞌvee yoꞌ, ga̱a ne̱ ca̱nica̱j soꞌ catzi̱j soꞌ tucuá síí ruꞌvee yoꞌ ei. Ne̱ ase vaa ꞌyaj síí atúj tucuá síí ruꞌvee roꞌ, da̱nj ꞌyáj man síí chre̱e yoꞌ chugua̱nj. Dan me se numíj ꞌu̱nj man soꞌ, ne̱ cuano̱ nihánj aꞌnéj ꞌu̱nj man nu̱ꞌ nij síí ꞌni̱j raꞌa soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","”Na̱j guun síí naꞌvej rá quiꞌya̱j suun ga̱ ꞌu̱nj roꞌ, síí ta̱j riꞌyunj manj me soꞌ a. Ne̱ na̱j guun síí ne racuíj manj naquiꞌya̱j chre̱ꞌ ꞌu̱nj man yuvii̱ canoco̱ꞌ man Diose̱ roꞌ, soꞌ me síí tichaꞌnuu̱ man nij yuvii̱, ne̱ aráán soꞌ rihaan nij yuvii̱ se̱ canocoꞌ nij yuvii̱ man Diose̱ ei. ");
INSERT INTO trcNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Cheꞌé dan cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa nu̱ꞌ cacunꞌ tu̱mé yuvii̱ do̱ꞌ, nu̱ꞌ nana̱ chiꞌi̱i̱ caꞌmi̱i̱ yuvii̱ do̱ꞌ, caꞌve̱e tinavi̱j Diose̱ cacunꞌ yoꞌ cheꞌé nij yuvii̱ a. Tza̱j ne̱ sese nachri̱ꞌ yoꞌo̱ soꞌ ni̱ꞌyaj soꞌ man Nimán Diose̱, ne̱ daj chiha̱a̱ míj se̱ quinavij cacunꞌ yoꞌ xráá soꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Dan me se ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ roꞌ, caꞌve̱e se caꞌmi̱i̱ yoꞌo̱ soꞌ nana̱ chiꞌi̱i̱ cheꞌej, tza̱j ne̱ caꞌve̱e navi̱j cacunꞌ yoꞌ xráá soꞌ quiꞌya̱j Diose̱ ei. Tza̱j ne̱ sese caꞌmi̱i̱ chiꞌi̱i̱ yoꞌo̱ soꞌ cheꞌé Nimán Diose̱, ne̱ daj chiha̱a̱ míj se̱ tinavij Diose̱ cacunꞌ yoꞌ xráá soꞌ a̱ maꞌ. Dan me se caꞌve̱e se rihaan chumii̱ nihánj do̱ꞌ, caꞌve̱e se nda̱a cavi̱ꞌ soꞌ do̱ꞌ, tza̱j ne̱ se̱ quinavij cacunꞌ yoꞌ nu̱ꞌ cavii nu̱ꞌ caꞌanj xráá soꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","”Sese sa̱ꞌ vaa ꞌo̱ chruun ne̱ sa̱ꞌ vaa chruj ma̱n raa̱ chruun yoꞌ a. Sese chiꞌi̱i̱ vaa ꞌo̱ chruun ne̱ chiꞌi̱i̱ vaa chruj ma̱n raa̱ chruun yoꞌ a. Dan me se sese neꞌen yuvii̱ se vaa vaa sa̱ꞌ chruj ma̱n raa̱ chruun, ne̱ neꞌen yuvii̱ se vaa chruun sa̱ꞌ me yoꞌ a. Ne̱ sese neꞌen yuvii̱ se vaa vaa chiꞌi̱i̱ chruj ma̱n raa̱ chruun, ne̱ neꞌen uún yuvii̱ se vaa chruun chiꞌi̱i̱ me yoꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ꞌO̱ se ase vaa xcuáá yuva̱a̱ vaa soj ei. Chiꞌi̱i̱ vaa nimán soj, ne̱ chiꞌi̱i̱ vaa nana̱ aꞌmii soj ei. ꞌO̱ se ase vaa se ma̱n nimán yuvii̱ roꞌ, da̱nj vaa nana̱ avii tuꞌva yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dan me se síí sa̱ꞌ roꞌ, ma̱n ndoꞌo se sa̱ꞌ nimán soꞌ, ne̱ ina̱nj nana̱ sa̱ꞌ aꞌmii soꞌ ado̱nj. Síí chiꞌi̱i̱ roꞌ, ma̱n ndoꞌo se chiꞌi̱i̱ nimán soꞌ, ne̱ ina̱nj nana̱ chiꞌi̱i̱ aꞌmii soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ne̱ cuano̱ nihánj me cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa nu̱ꞌ nana̱ aꞌmii ne̱ nij yuvii̱ roꞌ, cata̱j xnaꞌanj nij yuvii̱ rihaan Diose̱ me cheꞌé caꞌmii nij yuvii̱ nana̱ vaa da̱nj asa̱ꞌ quisíj güii caꞌne̱ꞌ Diose̱ cacunꞌ cheꞌé cunuda̱nj nij yuvii̱ ma̱n rihaan chumii̱ nihánj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ꞌO̱ se sese sa̱ꞌ vaa nana̱ caꞌmii so̱ꞌ, ne̱ cata̱j Diose̱ se vaa ne tumé so̱ꞌ cacunꞌ maꞌ. Ne̱ sese chiꞌi̱i̱ vaa nana̱ caꞌmii so̱ꞌ, ne̱ cuta̱ꞌ Diose̱ cacunꞌ xráá so̱ꞌ ado̱nj ―taj Jesucristó rihaan nij síí fariseo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Cachén do̱j, ga̱a ne̱ caꞌnaꞌ uún do̱j síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés ga̱ do̱j síí fariseo rihaan Jesucristó, ne̱ cataj nij soꞌ: ―Qui̱ꞌyáá so̱ꞌ ꞌo̱ suun sa̱ꞌ noco̱o queneꞌe̱n núj, maestro. Ga̱a ne̱ gu̱un ya̱ rá núj se vaa ya̱ aꞌmii so̱ꞌ á ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Xa̱ꞌ soj si̱j ꞌnaꞌ ina̱nj rej chiꞌi̱i̱ do̱ꞌ, rej cacunꞌ do̱ꞌ, me se me rá ga̱a̱ soj qui̱ꞌyáj suun sa̱ꞌ noco̱o ni̱ꞌyaj soj, tza̱j ne̱ daj chiha̱a̱ míj se̱ quiꞌyáj nda̱a vaa me rá soj maꞌ. Ma̱a̱n se queneꞌe̱n soj se vaa ase vaa quiranꞌ síí cuꞌna̱j Jonás síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá roꞌ, da̱nj qui̱ránꞌ ꞌu̱nj, vaa güii, ni̱ꞌyaj soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ꞌO̱ se ase vaa cunuû síí cuꞌna̱j Jonás vaꞌnu̱j ya̱ güii rque xcuu xi̱j va̱j rque na yaꞌa̱nj roꞌ, taꞌngaꞌ da̱nj ga̱a̱ vaꞌnu̱j ya̱ güii nuvi̱i niga̱nꞌ qui̱náá ꞌu̱nj rque yoꞌóó queneꞌe̱n soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nij síí ma̱n chumanꞌ cuꞌna̱j Nínive roꞌ, canicu̱nꞌ nij soꞌ ga̱ maꞌa̱n soj si̱j vaa iꞌna̱ꞌ rihaan chumii̱ nihánj cuano̱ asa̱ꞌ quisíj güii caꞌne̱ꞌ Diose̱ cacunꞌ cheꞌé yuvii̱, ne̱ cuta̱ꞌ nij síí ma̱n chumanꞌ Nínive yoꞌ cacunꞌ xráá soj ado̱nj. Cuno nij soꞌ nana̱ caꞌmii natáj síí cuꞌna̱j Jonás, ne̱ nuchranꞌ nimán nij soꞌ, ne̱ canocoꞌ nij soꞌ man Diose̱ ado̱nj. Ne̱ xa̱ꞌ ꞌu̱nj si̱j nicu̱nꞌ rihaan soj cuano̱, tza̱j ne̱ sa̱ꞌ doj vaa ꞌu̱nj rihaan síí cuꞌna̱j Jonás yoꞌ, tza̱j ne̱ taj se qui̱ꞌyáꞌ nuchra̱nꞌ nimán soj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ne̱ güii caꞌne̱ꞌ Diose̱ cacunꞌ cheꞌé yuvii̱ roꞌ, cuchi̱ꞌ chana̱ nica̱j suun reiná guun chij rihaan chumanꞌ na̱j ga̱nꞌ ndoꞌo rej sur, ne̱ canicu̱nꞌ noꞌ rihaan soj, quiꞌya̱j Diose̱, ne̱ cuta̱ꞌ noꞌ cacunꞌ xráá soj ado̱nj. ꞌO̱ se ga̱nꞌ ndoꞌo cachéé noꞌ cuchi̱ꞌ noꞌ rihaan síí cuꞌna̱j Salomón, ne̱ cuno noꞌ nana̱ cu̱u tucuꞌyón Salomón man noꞌ ado̱nj. Ne̱ xa̱ꞌ ꞌu̱nj si̱j nicu̱nꞌ rihaan soj cuano̱, tza̱j ne̱ sa̱ꞌ doj vaa ꞌu̱nj rihaan síí cuꞌna̱j Salomón yoꞌ a̱ ado̱nj. Tza̱j ne̱ naꞌvej rá soj cuno̱ soj nana̱ aꞌmii ꞌu̱nj rihaan soj a̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","”Ne̱ ga̱a tiha̱j yu̱u̱n avii yoꞌo̱ nana̱ chre̱e nimán snóꞌo, ne̱ chéé rmaꞌa̱n nana̱ chre̱e yoꞌ nanoꞌ soꞌ rej ca̱yáán soꞌ, tza̱j ne̱ taj se qui̱ꞌyáꞌ quiri̱ꞌ nana̱ chre̱e yoꞌ rej ca̱yáán soꞌ, ga̱a ne̱ me rá uún nana̱ chre̱e yoꞌ ca̱nica̱j soꞌ rej cavii soꞌ ga̱a naá a. Dan me se taj nana̱ chre̱e yoꞌ: “Ca̱nica̱j uún ꞌu̱nj na̱nꞌ ꞌu̱nj rej cavii ꞌu̱nj a. Veꞌé na̱nj vaa tucuaj, ne̱ naruvii rá veꞌ tucuaj cuano̱, ne̱ uun yaj ya̱nj rá veꞌ tucuaj cuano̱ ado̱nj”, taj nana̱ chre̱e yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ga̱a ne̱ dan me se anica̱j uún nana̱ chre̱e yoꞌ nimán snóꞌo yoꞌ, ne̱ nanoꞌ nana̱ chre̱e yoꞌ yoꞌó chi̱j tuviꞌ nana̱ chre̱e yoꞌ síí chiꞌi̱i̱ doj, ne̱ ꞌnaꞌ nique uún soꞌ nimán snóꞌo yoꞌ, ga̱a ne̱ ca̱yáán taranꞌ nij nana̱ chre̱e yoꞌ a. Dan me se ga̱a naá ga̱a cayáán o̱rúnꞌ nana̱ chre̱e yoꞌ, ne̱ ma̱a̱n taꞌngaꞌ quij vaa nimán snóꞌo yoꞌ, tza̱j ga̱a namán yoꞌó chi̱j nana̱ chre̱e yoꞌ, ga̱a ne̱ doj a̱ tico nana̱ chre̱e man soꞌ, ne̱ doj a̱ quij vaa nimán snóꞌo yoꞌ, ꞌyaj nana̱ chre̱e yoꞌ a̱ ado̱nj. ”Ne̱ ase vaa ranꞌ snóꞌo yoꞌ roꞌ, taꞌngaꞌ da̱nj quira̱nꞌ soj si̱j israelitá si̱j naꞌvej rá cuno̱ se‑na̱na̱ ꞌu̱nj ei. ꞌO̱ se cheꞌé se natáꞌ ꞌu̱nj se‑na̱na̱j rihaan soj roꞌ, cheꞌé dan doj a̱ ga̱a̱ sayuun quira̱nꞌ soj rihaan sayuun quira̱nꞌ nij síí ataa cuno̱ se‑na̱na̱j ado̱nj ―taj Jesucristó rihaan nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés do̱ꞌ, rihaan nij síí fariseo do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ataa quisi̱j caꞌmii Jesucristó rihaan nij yuvii̱, ne̱ cuchiꞌ nii Jesucristó do̱ꞌ, tinúú Jesucristó do̱ꞌ, rihaan veꞌ a. Nanó rá nij soꞌ da̱j quiꞌya̱j nij soꞌ caꞌmi̱i̱ nij soꞌ ga̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ne̱ cataj yoꞌo̱ soꞌ rihaan Jesucristó a: ―Xeꞌ roꞌ, nicunꞌ nií so̱ꞌ nicunꞌ tinúú so̱ꞌ nicunꞌ, ne̱ me ndoꞌo rá nij soꞌ caꞌmi̱i̱ nij soꞌ ga̱ so̱ꞌ á ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ne̱ cataj uún Jesucristó rihaan síí cataj xnaꞌanj rihaan Jesucristó a: ―Me chana̱ me nií ꞌu̱nj rihaan ꞌu̱nj, rá so̱ꞌ ga̱. Me síí me tinúú ꞌu̱nj rihaan ꞌu̱nj, rá so̱ꞌ ga̱ ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ne̱ ticunꞌ soꞌ raꞌa soꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ cataj soꞌ: ―Ni̱ꞌyaj so̱ꞌ ei. Ase vaa nií ꞌu̱nj do̱ꞌ, ase vaa tinúú ꞌu̱nj do̱ꞌ, vaa nij síí nihánj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ꞌO̱ se yuvii̱ uno rihaan Réé ꞌu̱nj síí nicu̱nꞌ xta̱ꞌ roꞌ, ase vaa tinúú ꞌu̱nj do̱ꞌ, ase vaa raꞌvij ꞌu̱nj do̱ꞌ, ase vaa nií ꞌu̱nj do̱ꞌ, vaa nij soꞌ rihanj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Dan me se guun naá do̱j, ne̱ curiha̱nj Jesucristó rá veꞌ, ne̱ cane soꞌ tuꞌva na lacuaná, ");
INSERT INTO trcNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ne̱ caꞌnaꞌ ndoꞌo yuvii̱ rihaan soꞌ, ne̱ cheꞌé dan cavii soꞌ rque ꞌo̱ rihoo chéé rihaan na, ne̱ caꞌanj cane̱ soꞌ rque rihoo yoꞌ, ne̱ canicunꞌ nij yuvii̱ tuꞌva na lacuaná yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ne̱ nanó ndoꞌo Jesucristó cuentó rihaan nij yuvii̱, cataj soꞌ: ―Dan me se curiha̱nj ꞌo̱ síí me rá cuchru̱j naa̱ ꞌnúú trigó, ne̱ tixꞌnuu̱ soꞌ ꞌnúú trigó yoꞌ rihaan yoꞌóó, ");
INSERT INTO trcNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ne̱ cayuu do̱j ꞌnúú trigó yoꞌ rá chrej chéé yuvii̱, ne̱ caꞌnaꞌ xtâj chá xtâj man ꞌnúú trigó na̱j rá chrej yoꞌ, ne̱ dan me se navij nu̱ꞌ ꞌnúú trigó yoꞌ, quiꞌyaj nij xtâj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ne̱ yoꞌó taꞌa̱j ꞌnúú trigó yoꞌ roꞌ, cayuu rihaan yuvej rej ta̱j catu̱nꞌ yoꞌóó a. Cheꞌé dan cuaj xraꞌ stanj leꞌe̱j a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Veé dan, ne̱ quisíj güii, ne̱ cuchrii naa̱ leꞌe̱j, quiꞌyaj naán, cheꞌé se ne caꞌve̱e caꞌa̱nj ni̱j yáá naa̱ leꞌe̱j yoꞌ a̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ne̱ yoꞌó taꞌa̱j ꞌnúú trigó yoꞌ roꞌ, cayuu scaꞌnúj coj tanj, ne̱ dan me se yo̱o doj cachij coj tanj yoꞌ rihaan naa̱ leꞌe̱j, ne̱ quinavij nu̱ꞌ naa̱ leꞌe̱j, quiꞌyaj coj tanj yoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ne̱ yoꞌó taꞌa̱j ꞌnúú trigó yoꞌ roꞌ, cayuu rihaan yoꞌóó sa̱ꞌ, ne̱ naa̱ yoꞌ roꞌ, cachij sa̱ꞌ a. Dan me se rihaan taꞌa̱j yoꞌóó sa̱ꞌ yoꞌ cientó ya̱ ꞌnúú cavii, quiꞌyaj ꞌo̱ ꞌo̱ ꞌnúú leꞌe̱j nii quinij rihaan yoꞌóó sa̱ꞌ yoꞌ, ne̱ rihaan yoꞌó taꞌa̱j yoꞌóó sa̱ꞌ yoꞌ vaꞌnu̱j chiha̱a̱ ya̱ ꞌnúú cavii, quiꞌyaj ꞌo̱ ꞌo̱ ꞌnúú leꞌe̱j nii quinij rihaan yoꞌóó sa̱ꞌ yoꞌ, ne̱ rihaan yoꞌó taꞌa̱j yoꞌóó sa̱ꞌ yoꞌ ico̱ chi̱ꞌ ya̱ ꞌnúú trigó cavii, quiꞌyaj ꞌo̱ ꞌo̱ ꞌnúú leꞌe̱j nii quinij rihaan yoꞌóó sa̱ꞌ yoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","”Sese ta̱j yuꞌuj xréé soj, ne̱ cuno̱ soj nana̱ nihánj ei. ―Veé dan quisíj cuentó yoꞌ cuentó nanó Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ga̱a ne̱ quinichrunꞌ nij síí tucuꞌyón se‑na̱na̱ Jesucristó rihaan soꞌ, ne̱ xnáꞌanj nij soꞌ man Jesucristó a: ―Me cheꞌé nanó so̱ꞌ cuentó cheꞌé nij rasu̱u̱n rihaan nij yuvii̱ ga̱ ―taj nij soꞌ, xnáꞌanj nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Xa̱ꞌ soj, tza̱j ne̱ tihaa̱n Diose̱ nana̱ rihaan soj da̱j quiꞌya̱j Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj ado̱nj. Dan me se nana̱ ne neꞌen cunuda̱nj yuvii̱ me nana̱ tihaa̱n Diose̱ rihaan soj ado̱nj. Ne̱ ne ra̱cuíj Diose̱ man yoꞌó taꞌa̱j nij yuvii̱ queneꞌe̱n nij yuvii̱ da̱j quiꞌya̱j Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ꞌO̱ se síí a̱j nariꞌ nana̱ roꞌ, doj a̱ nari̱ꞌ uún soꞌ, ne̱ uxrá queneꞌe̱n ndoꞌo soꞌ, quiꞌya̱j Diose̱ na̱nj ado̱nj. Ne̱ síí naꞌvej rá nari̱ꞌ sa̱ꞌ nana̱ roꞌ, tana̱nj caꞌne̱e̱ Diose̱ do̱j nij nana̱ nariꞌ soꞌ man soꞌ, ne̱ quina̱j u̱u̱n soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Cheꞌé dan nanoj cuentó cheꞌé nij rasu̱u̱n rihaan nij yuvii̱ yoꞌ, cheꞌé se niꞌya̱j nij soꞌ do̱ꞌ, nanó xre̱j nij soꞌ do̱ꞌ, tza̱j ne̱ ne neꞌen nij soꞌ do̱ꞌ, ne acaj nij soꞌ cuentá do̱ꞌ, maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ne̱ ase vaa nana̱ nihánj nana̱ nataꞌ síí cuꞌna̱j Isaías cheꞌé Diose̱ ga̱a naá roꞌ, veé da̱nj vaa nij yuvii̱ ne̱ veé da̱nj ꞌyaj nij yuvii̱ cuano̱ ei: “Catu̱u̱ uxrá nana̱ xréé soj, tza̱j ne̱ se̱ xcaj soj cuentá maꞌ. Ne̱ ni̱ꞌyaj uxrá soj, tza̱j ne̱ se̱ queneꞌen soj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ꞌO̱ se caráán maꞌa̱n nij yuvii̱ nihánj rihaan nij soꞌ, cheꞌé rej naꞌvej rá nij soꞌ queneꞌe̱n maꞌa̱n nij soꞌ, ne̱ caráán nij soꞌ xréé nij soꞌ, cheꞌé rej naꞌvej rá nij soꞌ cuno̱ nij soꞌ uún a. Ne̱ ne atúj nana̱ nimán nij soꞌ, ꞌyaj nij soꞌ, cheꞌé yan naꞌvej rá nij soꞌ xca̱j nij soꞌ cuentá ne̱ ca̱nica̱j nimán nij soꞌ a̱ maꞌ. ꞌO̱ se naꞌvej uxrá rá nij soꞌ quinahu̱un sa̱ꞌ nimán nij soꞌ qui̱ꞌyáá ꞌu̱nj a̱ man ado̱nj”. Yoꞌ me se‑na̱na̱ Diose̱ nana̱ nataꞌ síí cuꞌna̱j Isaías cheꞌé maꞌa̱n Diose̱ ga̱a naá a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","”Tza̱j ne̱ vaa cheꞌé ga̱a̱ niha̱ꞌ rá soj cheꞌé rihaan soj do̱ꞌ, cheꞌé xréé soj do̱ꞌ ei. ꞌO̱ se a̱j queneꞌen soj se vaa quiꞌyáj, ne̱ a̱j cuno soj nana̱ caꞌmij á. ");
INSERT INTO trcNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa ma̱n ndoꞌo síí ma̱n ga̱a naá síí nataꞌ se‑na̱na̱ Diose̱ do̱ꞌ, síí sa̱ꞌ do̱ꞌ, guun rá queneꞌe̱n se vaa queneꞌen nij soj, tza̱j ne̱ ne queneꞌe̱n nij soꞌ maꞌ. Ne̱ guun rá nij soꞌ cuno̱ nij soꞌ se vaa uno soj, tza̱j ne̱ ne cuno̱ nij soꞌ man ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ga̱a ne̱ cataj uún Jesucristó: ―Cheꞌé dan cuno̱ maꞌa̱n soj, cata̱j xnaꞌanj ꞌu̱nj rihaan soj me taj cuentó cheꞌé ꞌnúú trigó tixꞌnuu̱ síí cuchruj naa̱ yoꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Cunuda̱nj yuvii̱ uno nana̱ cheꞌé da̱j quiꞌya̱j Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ roꞌ, sese ne acaj sa̱ꞌ nij soꞌ cuentá, ne̱ ꞌnaꞌ síí chre̱e, ne̱ aꞌnéj síí chre̱e nana̱ yoꞌ nimán yuvii̱ yoꞌ a. Dan me se ase vaa ꞌnúú trigó cayuu rá chrej chéé yuvii̱ vaa yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ne̱ ꞌnúú trigó cayuu rihaan yoꞌóó ta̱j rihaan yuvej roꞌ, ase vaa síí uno se‑na̱na̱ Diose̱ vaa yoꞌ, ne̱ cuaj uun niha̱ꞌ rá soꞌ canoco̱ꞌ soꞌ nana̱ yoꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","tza̱j ne̱ ataa xca̱j sa̱ꞌ soꞌ cuentá, ne̱ ga̱a uun cheꞌe̱ yuvii̱ ꞌyaj yuvii̱ sayuun man soꞌ cheꞌé nana̱ noco̱ꞌ soꞌ, ne̱ cuaj nu̱ꞌ uun naꞌa̱j soꞌ, ne̱ tanáj soꞌ nana̱ yoꞌ cuaj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ne̱ ꞌnúú trigó cayuu scaꞌnúj coj tanj roꞌ, ase vaa síí uno se‑na̱na̱ Diose̱ vaa yoꞌ, tza̱j ne̱ nanó ndoꞌo rá soꞌ cheꞌé rasu̱u̱n ma̱n rihaan chumii̱ nihánj, ne̱ me ndoꞌo rá soꞌ quiꞌya̱j canaán soꞌ saꞌanj, ne̱ cheꞌé dan tihaꞌ yuꞌunj soꞌ man maꞌa̱n soꞌ cheꞌé saꞌanj a. Cheꞌé dan me taj se ꞌyáꞌ canoco̱ꞌ sa̱ꞌ soꞌ nana̱ nariꞌ soꞌ, ne̱ ne nuu sa̱ꞌ nimán soꞌ rihaan Diose̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ne̱ ꞌnúú trigó cayuu rihaan yoꞌóó sa̱ꞌ roꞌ, ase vaa síí uno se‑na̱na̱ Diose̱ vaa yoꞌ, ne̱ xcaj sa̱ꞌ soꞌ cuentá, ne̱ nuu sa̱ꞌ nimán soꞌ rihaan Diose̱ a. Ne̱ sa̱ꞌ uxrá ꞌyaj taꞌa̱j nij soꞌ, ne̱ sa̱ꞌ do̱j ꞌyaj yoꞌó taꞌa̱j nij soꞌ, ne̱ sa̱ꞌ do̱j tzinꞌ ꞌyaj yoꞌó taꞌa̱j nij soꞌ na̱nj ado̱nj. ―Veé da̱nj quisíj nana̱ caꞌmii Jesucristó cheꞌé cuentó yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ne̱ nanó soꞌ yoꞌó cuentó nii rihaan nij soꞌ, cataj soꞌ: ―Ase vaa quiꞌyaj ꞌo̱ síí tixꞌnuu̱ ꞌnúú trigó sa̱ꞌ toꞌóó soꞌ roꞌ, da̱nj ga̱a̱ quiꞌya̱j Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Dan me se quisíj tixꞌnuu̱ soꞌ ꞌnúú trigó yoꞌ, ne̱ rej nii̱ orá otoj yuvii̱ catúj ꞌo̱ síí ta̱j riꞌyunj man soꞌ toꞌóó soꞌ, ne̱ tixꞌnuu̱ síí chiꞌi̱i̱ yoꞌ caân coj chiꞌi̱i̱ rihaan yoꞌóó na̱j ꞌnúú trigó yoꞌ, ne̱ veé dan me se caꞌanj uún soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ne̱ dan me se xraꞌ ꞌnúú trigó xraꞌ coj xraꞌ, ga̱a ne̱ quichihón caa raa̱ ꞌnúú trigó do̱ꞌ, raa̱ coj do̱ꞌ, ne̱ xcaj nij se‑mo̱zó síí toꞌo̱j yoꞌ cuentá se vaa nuveé ꞌnu̱j trigó me nu̱ꞌ naa̱ a. Ma̱a̱n se ma̱n uxrá coj rque naa̱ yoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Cheꞌé dan cuchiꞌ nij se‑mo̱zó síí toꞌo̱j yoꞌ rihaan síí toꞌo̱j, ne̱ cataj xnaꞌanj nij soꞌ rihaan soꞌ, cataj nij soꞌ: “Ya̱ ina̱nj ꞌnúú trigó sa̱ꞌ tixꞌnuú so̱ꞌ naꞌ. Me rej cavii coj chiꞌi̱i̱ nihánj ga̱, señor”, taj nij mozó rihaan síí toꞌo̱j yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ga̱a ne̱ cataj soꞌ rihaan nij se‑mo̱zó soꞌ a: “Síí ta̱j riꞌyunj manj me síí tixꞌnuu̱ caân coj chiꞌi̱i̱ rihaan toꞌój ei”, taj soꞌ rihaan nij se‑mo̱zó soꞌ a. “Ne̱ me rá so̱ꞌ quiriha̱a̱ núj coj ne̱ naquiꞌya̱j chre̱ꞌ núj coj naꞌ”, taj nij mozó rihaan ruꞌvee yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Taj cheꞌé quiꞌya̱j soj da̱nj maꞌ. Sese quiriha̱a̱ soj man coj yoꞌ, ga̱a ne̱ quiriha̱a̱ uún soj man taꞌa̱j ꞌnúú trigó yoꞌ ga̱a̱ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ma̱a̱n se caꞌne̱ꞌ rá soj cachi̱j rcuaꞌa̱a̱n coj yoꞌ ga̱ ꞌnúú trigó yoꞌ, ga̱a ne̱ yavii quiri̱i̱ níꞌ naa̱ trigó, ga̱a ne̱ cata̱j xnaꞌanj ꞌu̱nj rihaan nij síí quiri̱i̱ naa̱ se vaa asino naquiꞌya̱j chre̱ꞌ nij soꞌ coj yoꞌ, ga̱a ne̱ nu̱míj nij soꞌ coj yoꞌ, ga̱a ne̱ caca̱a̱ coj yoꞌ ado̱nj. Ga̱a ne̱ naquiꞌya̱j chre̱ꞌ nij soꞌ ꞌnúú trigó sa̱ꞌ, ga̱a ne̱ cara̱a sa̱ꞌ nij soꞌ man yoꞌ rá cuchruu̱ ado̱nj”, cataj síí toꞌo̱j rihaan se‑mo̱zó soꞌ a ―cataj Jesucristó rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ne̱ nihánj me yoꞌó cuentó nanó Jesucristó rihaan nij yuvii̱ a: ―Ase vaa achij caân cuêj mostazá xlá roꞌ, da̱nj ga̱a̱ gu̱un chij Diose̱ rihaan chumii̱ nihánj ado̱nj. Dan me se nica̱j yoꞌo̱ soꞌ man caân cuêj mostazá xlá, ne̱ axríj soꞌ caân yoꞌ rihaan toꞌóó soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Dan me se leꞌe̱j doj vaa caân cuêj mostazá xlá rihaan cunuda̱nj nij caân, tza̱j ne̱ asa̱ꞌ cachij yoꞌ, ne̱ xi̱j doj vaa yoꞌ rihaan nu̱ꞌ coj ma̱n tacaan, ne̱ ase vaa chruun vaa yoꞌ a. Dan me se ayuu nij xtâj va̱j rej xta̱ꞌ raa̱ cuêj yoꞌ, ne̱ ꞌyaj nij xoꞌ se‑sca̱ꞌ nij xoꞌ raa̱ cuêj yoꞌ ado̱nj. ―Da̱nj caꞌmii Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ne̱ nihánj me yoꞌó cuentó nanó Jesucristó rihaan nij yuvii̱ a: ―Dan me se naquiꞌya̱j níꞌ ꞌo̱ chana̱ caxríj yoꞌóó levadura rque cunj hariná ga̱a ꞌyaj noꞌ rachrúún a. Dan me se ase vaa ꞌo̱ chana̱, ne̱ cuxraꞌ taꞌa̱j noꞌ ꞌo̱ vaꞌnu̱j ya̱ agaꞌ yoꞌóó hariná, ne̱ caxríj ndoꞌo noꞌ yoꞌóó levadura, ne̱ caxríj yuve̱ noꞌ man yoꞌ nda̱a navij naraa ndoꞌo nana̱ rque yoꞌ a. Ase vaa uun chij yoꞌóó levadura rihaan cunj hariná roꞌ, da̱nj ga̱a̱ gu̱un chij Diose̱ rihaan chumii̱ nihánj ado̱nj. ―Da̱nj caꞌmii Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ina̱nj cuentó cheꞌé nij rasu̱u̱n nanó Jesucristó rihaan nij yuvii̱, ga̱a ne̱ aꞌvee nataꞌ soꞌ rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Da̱nj quiꞌyaj soꞌ, cheꞌé yan me rá soꞌ quiꞌya̱j soꞌ nu̱ꞌ se vaa cataj ꞌo̱ síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá, cataj soꞌ: “Ina̱nj cuentó cheꞌé nij rasu̱u̱n nano̱ ꞌu̱nj rihaan yuvii̱, ne̱ dan me se cata̱j xnaꞌanj ꞌu̱nj rihaan nij soꞌ cheꞌé se vaa quiꞌyaj Diose̱ asi̱j quiꞌyaj Diose̱ man nu̱ꞌ chumii̱ nihánj ado̱nj”. Da̱nj caꞌmii síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ga̱a ne̱ naꞌnéé Jesucristó chrej man nij yuvii̱, ne̱ catúj soꞌ rá veꞌ, ga̱a ne̱ cuchiꞌ nij síí tucuꞌyón se‑na̱na̱ soꞌ rihaan soꞌ a. Ne̱ xnáꞌanj nij soꞌ man soꞌ, cataj nij soꞌ: ―Cata̱j xnaꞌanj so̱ꞌ rihaan núj me taj cuentó cheꞌé coj cachij scaꞌnúj ꞌnúú trigó yoꞌ á ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ga̱a ne̱ cataj xnaꞌanj Jesucristó rihaan nij soꞌ, cataj soꞌ: ―Síí tixꞌnuu̱ ꞌnúú trigó sa̱ꞌ rihaan yoꞌóó roꞌ, ase vaa ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ vaa soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ne̱ ase vaa chumii̱ nihánj vaa yoꞌóó yoꞌ, ne̱ ꞌnúú trigó sa̱ꞌ roꞌ, ase vaa nij síí ca̱yáán ga̱ Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ vaa yoꞌ, ne̱ ase vaa coj chiꞌi̱i̱ yoꞌ roꞌ, vaa nij síí noco̱ꞌ man síí chre̱e, ");
INSERT INTO trcNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ne̱ ase vaa síí tixꞌnuu̱ caân coj chiꞌi̱i̱ rihaan yoꞌóó yoꞌ roꞌ, vaa maꞌa̱n síí chre̱e yoꞌ, ne̱ ase vaa güii caꞌne̱ꞌ Diose̱ cacunꞌ cheꞌé yuvii̱ ma̱n rihaan chumii̱ nihánj roꞌ, da̱nj vaa güii quiri̱i̱ nii naa̱ yoꞌ, ne̱ ase vaa nij se‑mo̱zó Diose̱ vaa nij síí quiri̱i̱ naa̱ yoꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Dan me se ase vaa naquiꞌya̱j chre̱ꞌ nii man coj yoꞌ ne̱ caca̱a̱ yoꞌ rihaan yaꞌan roꞌ, da̱nj ga̱a̱ quira̱nꞌ nij síí noco̱ꞌ man síí chre̱e güii caꞌne̱ꞌ Diose̱ cacunꞌ cheꞌé yuvii̱ ma̱n rihaan chumii̱ nihánj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Dan me se síí caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ mej, ne̱ güii dan caꞌne̱j ꞌu̱nj man nij se‑mo̱zó ꞌu̱nj, ne̱ nari̱i̱ nij soꞌ man nij síí chiꞌi̱i̱ ꞌni̱j scaꞌnúj nij yuvii̱ guun chij ꞌu̱nj rihaan a. Dan me se nu̱ꞌ síí tumé cacunꞌ do̱ꞌ, nu̱ꞌ síí naꞌvej rá cuno̱ rihaan Diose̱ do̱ꞌ, quiri̱i̱ nij se‑mo̱zó ꞌu̱nj man nij soꞌ rihaan chumii̱ nihánj, ");
INSERT INTO trcNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ne̱ caꞌne̱j nij soꞌ man nij síí chiꞌi̱i̱ rque chrúún acaa ndoꞌo na̱nj ado̱nj. Ne̱ yuvii̱ cuma̱n rej yoꞌ me se taꞌve̱e ndoꞌo nij soꞌ, ne̱ nda̱a cha̱ ru̱j maꞌa̱n nij soꞌ cúú yanꞌ nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ga̱a ne̱ cuchugu̱u̱n nij síí sa̱ꞌ yoꞌ ado̱nj. Dan me se ase vaa chuguu̱n güii roꞌ, da̱nj ga̱a̱ cuchugu̱u̱n nij soꞌ, ne̱ gu̱un chij Rej nij soꞌ síí nicu̱nꞌ xta̱ꞌ rihaan nij soꞌ ei. ”Dan me se sese ta̱j yuꞌuj xréé soj, ne̱ cuno̱ soj nana̱ nihánj ei. ");
INSERT INTO trcNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","”Ase vaa ꞌo̱ chrúún saꞌanj ꞌni̱j yuve̱ rque yoꞌóó vaa rej rihaan soj se vaa ca̱yáán soj ga̱ Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj ado̱nj. Dan me se nariꞌ ꞌo̱ snóꞌo man chrúún saꞌanj yoꞌ, ga̱a ne̱ naráán uún soꞌ yoꞌóó xráá yoꞌ, ne̱ guun niha̱ꞌ uxrá rá soꞌ cheꞌé chrúún saꞌanj nariꞌ soꞌ, ne̱ caꞌanj soꞌ cutuꞌvéj soꞌ nu̱ꞌ siꞌyaj soꞌ, ne̱ nica̱j soꞌ saꞌanj, caꞌanj soꞌ, quiránj soꞌ nu̱ꞌ yoꞌóó ꞌni̱j chrúún saꞌanj yoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","”Ne̱ ase vaa síí ne̱ tiendá ne̱ nanoꞌ chruj perlá tuꞌve̱e̱ ndoꞌo quira̱a̱n roꞌ, da̱nj vaa síí ca̱yáán ga̱ Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Dan me se nariꞌ síí ne̱ tiendá yoꞌ ꞌo̱ chruj perlá sa̱ꞌ uxrá doj rihaan yoꞌó perlá, ga̱a ne̱ caꞌanj soꞌ cutuꞌvéj soꞌ cunuda̱nj siꞌyaj soꞌ, ne̱ nica̱j soꞌ saꞌanj, quiránj soꞌ man chruj perlá sa̱ꞌ doj yoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","”Ne̱ ase vaa quiranꞌ xcuaj catúj rque nanj tiguíj nii rá na roꞌ, da̱nj ga̱a̱ quira̱nꞌ yuvii̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj ei. Dan me se tiguíj yuvii̱ man nanj yoꞌ rque na, ne̱ dan me se me maꞌa̱n xcuaj catúj rque nanj yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nda̱a síj ga̱a caraa nanj yoꞌ, ga̱a ne̱ cuxuun nij yuvii̱ man nanj yoꞌ nda̱a tuꞌva na yoꞌ, ga̱a ne̱ caꞌanj ca̱yáán nij soꞌ rihaan yoꞌóó, ga̱a ne̱ narii nij soꞌ man xcuaj sa̱ꞌ, ne̱ narii nij soꞌ man xcuaj nij uún a. Ga̱a ne̱ xcuaj sa̱ꞌ yoꞌ me se caraa nij soꞌ man xcuaj sa̱ꞌ yoꞌ rá scaa a. Tza̱j ne̱ xcuaj nij me se quiriꞌíj u̱u̱n nij soꞌ man yoꞌ na̱nj ei. ");
INSERT INTO trcNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ne̱ ase vaa quiranꞌ nij xcuaj yoꞌ roꞌ, da̱nj quira̱nꞌ yuvii̱ asa̱ꞌ caꞌneꞌ Diose̱ cacunꞌ cheꞌé yuvii̱, ne̱ cavi̱i̱ nij se‑mo̱zó Diose̱ ne̱ cuxra̱ꞌ taꞌa̱j nij soꞌ man nij síí chiꞌi̱i̱ ga̱ nij síí vaa sa̱ꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ne̱ quiriꞌi̱j nij soꞌ man nij síí chiꞌi̱i̱ yoꞌ rque chrúún yaꞌa̱an ndoꞌo, ga̱a ne̱ dan me se taꞌve̱e uxrá nij soꞌ, ne̱ nda̱a cha̱ ru̱j maꞌa̱n nij soꞌ cúú yanꞌ nij soꞌ na̱nj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ne̱ xnáꞌanj Jesucristó man nij síí tucuꞌyón se‑na̱na̱ soꞌ, cataj soꞌ: ―Cuno soj nu̱ꞌ cuentó nanó ꞌu̱nj cuano̱ naꞌ ―taj Jesucristó, xnáꞌanj soꞌ man nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ―Cuno núj nu̱ꞌ cuentó yoꞌ á ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Cheꞌé dan cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés me se sese nari̱ꞌ uún nij soꞌ nana̱ cheꞌé güii gu̱un chij Diose̱ rihaan chumii̱ nihánj, ne̱ síí neꞌen nu̱ꞌ nana̱ me nij soꞌ, ne̱ síí cu̱u raa̱ gu̱un nij soꞌ, quiꞌya̱j nu̱ꞌ nana̱ nariꞌ nij soꞌ ado̱nj. Dan me se ase vaa síí ruꞌvee ne̱ ma̱n rasu̱u̱n nga̱ do̱ꞌ, rasu̱u̱n naca̱ do̱ꞌ, rihaan roꞌ, da̱nj ga̱a̱ nij soꞌ, ne̱ cavi̱i̱ sa̱ꞌ uxrá nij soꞌ na̱nj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Dan me se quisíj nanó Jesucristó nu̱ꞌ cuentó nihánj rihaan yuvii̱, ne̱ curiha̱nj soꞌ rej yoꞌ, ne̱ caꞌanj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ga̱a ne̱ nucuiꞌ soꞌ rej chiháán soꞌ, ne̱ caꞌanj soꞌ veꞌ tucuꞌyón nij síí ma̱n chiháán soꞌ se‑tucua̱nj Moisés, ne̱ tucuꞌyón soꞌ man nij síí ma̱n rá veꞌ yoꞌ a. Dan me se caráyaꞌa̱nj nij soꞌ, ne̱ cataj nij soꞌ: ―Me rej nariꞌ síí nihánj nana̱ cu̱u avii raa̱ síí nihánj ga̱. Me rej nariꞌ soꞌ suun sa̱ꞌ ꞌyaj suun soꞌ ga̱. ");
INSERT INTO trcNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nuveé taꞌni̱j síí acój chruun síí ne̱ chiháán níꞌ me soꞌ naꞌ. Ne̱ nii soꞌ me chana̱ cuꞌna̱j Mariá á. Ne̱ tinúú soꞌ me síí cuꞌna̱j Jacobo do̱ꞌ, síí cuꞌna̱j José do̱ꞌ, síí cuꞌna̱j Simón do̱ꞌ, síí cuꞌna̱j Judas do̱ꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ne̱ nij raꞌvij soꞌ me chana̱ ne̱ chiháán níꞌ á. Tza̱j ne̱ ne neꞌenj me rej me nariꞌ soꞌ suun nihánj quiꞌyaj suun soꞌ maꞌ ―taj nij síí ma̱n chiháán Jesucristó rihaan tuviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ne̱ guun naco̱o̱ rá nij soꞌ niꞌya̱j nij soꞌ man Jesucristó a. Ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Me rej maꞌa̱n va̱j ꞌo̱ síí nataꞌ se‑na̱na̱ Diose̱, ne̱ aráj cochro̱j nij yuvii̱ rihaan soꞌ, tza̱j ne̱ nij yuvii̱ ma̱n chiháán soꞌ do̱ꞌ, nij tuviꞌ soꞌ síí ya̱nj tucuá soꞌ do̱ꞌ, naꞌvej rá cara̱a̱ cochro̱j rihaan soꞌ maꞌ ―taj Jesucristó rihaan nij síí ma̱n chiháán soꞌ chumanꞌ cuꞌna̱j Nazaret yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ne̱ do̱j vaa suun sa̱ꞌ quiꞌyaj suun Jesucristó chiháán soꞌ, cheꞌé se ne cuchuma̱n rá nij síí ma̱n chiháán soꞌ ni̱ꞌyaj nij soꞌ man soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Dan me se cachén do̱j güii, ga̱a ne̱ cuchiꞌ nana̱ rihaan síí nica̱j suun cuꞌna̱j Herodes cheꞌé nu̱ꞌ se vaa quiꞌyaj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ga̱a ne̱ cataj soꞌ rihaan nij se‑mo̱zó soꞌ a: ―Síí cuꞌna̱j Jesucristó roꞌ, ya̱ síí cuꞌna̱j Juan síí cutaꞌ ne man yuvii̱ me soꞌ á. Dan me se cunuu iꞌna̱ꞌ ya̱ uún síí cuꞌna̱j Juan, raj á. Ése̱ síí cuꞌna̱j Juan me síí guun nucua̱j quiꞌyaj nij suun sa̱ꞌ noco̱o yoꞌ na̱nj ado̱nj ―taj Herodes rihaan nij se‑mo̱zó soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Da̱nj caꞌmii síí cuꞌna̱j Herodes, cheꞌé se ga̱a rque̱ doj, ne̱ soꞌ me síí quiꞌyaj quitaꞌaa nij tanuu man síí cuꞌna̱j Juan, ne̱ numíj nij tanuu man síí cuꞌna̱j Juan, ne̱ caxríj síí cuꞌna̱j Herodes tagaꞌ man síí cuꞌna̱j Juan ga̱a rque̱ doj a. Da̱nj quiꞌyaj soꞌ cheꞌé chana̱ cuꞌna̱j Herodías nica̱ tinúú Herodes síí cuꞌna̱j Felipé a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Dan me se xcaj síí cuꞌna̱j Herodes man noꞌ, ne̱ cataj xnaꞌanj síí cuꞌna̱j Juan rihaan soꞌ se vaa ne nó xcúún soꞌ xca̱j soꞌ man choco̱ꞌ soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Cheꞌé se cataj síí cuꞌna̱j Juan rihaan soꞌ, ga̱a ne̱ guun ndoꞌo rá síí cuꞌna̱j Herodes cavi̱ꞌ síí cuꞌna̱j Juan yoꞌ a. Tza̱j ne̱ cuchuꞌviꞌ soꞌ se vaa caꞌma̱an rá nij yuvii̱ a. ꞌO̱ se síí nataꞌ se‑na̱na̱ Diose̱ me síí cuꞌna̱j Juan, rá nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Dan me se quisíj güii canuû se‑chaꞌa̱nj maꞌa̱n síí cuꞌna̱j Herodes, ga̱a ne̱ quiraꞌánj ndoꞌo taꞌníí chana̱ cuꞌna̱j Herodías niꞌya̱j cunuda̱nj nij síí caꞌnaꞌ a. Ne̱ guun niha̱ꞌ rá síí cuꞌna̱j Herodes queneꞌen soꞌ man chana̱ ya̱a̱n quiraꞌánj, ");
INSERT INTO trcNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ga̱a ne̱ cheꞌé dan cataꞌ tuꞌva soꞌ se vaa ya̱ uxrá rque̱ soꞌ rihaan noꞌ me maꞌa̱n rasu̱u̱n cachi̱nj noꞌ rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Dan me se cataj xnaꞌanj chana̱ cuꞌna̱j Herodías rihaan taꞌníí noꞌ da̱j caꞌmi̱i̱ noꞌ rihaan síí cuꞌna̱j Herodes, ga̱a ne̱ canicunꞌ chana̱ ya̱a̱n yoꞌ rihaan síí cuꞌna̱j Herodes, quiꞌyaj nii noꞌ chana̱ cuꞌna̱j Herodías a. Ne̱ cataj chana̱ ya̱a̱n yoꞌ: ―Caꞌne̱j so̱ꞌ cúú yave̱ síí cuꞌna̱j Juan rque agaꞌ rcoꞌo̱o, ne̱ rque̱ so̱ꞌ manj nihánj á ―taj chana̱ ya̱a̱n yoꞌ rihaan síí cuꞌna̱j Herodes, quiꞌyaj nii noꞌ chana̱ cuꞌna̱j Herodías a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ga̱a ne̱ quinanó ndoꞌo rá síí cuꞌna̱j Herodes yoꞌ ga̱a cuno soꞌ nana̱ yoꞌ a. Quinanó rá soꞌ se vaa cuno cunuda̱nj nij síí caꞌnaꞌ nana̱ caꞌmii soꞌ se vaa rque̱ soꞌ me maꞌa̱n rasu̱u̱n rihaan chana̱ ya̱a̱n yoꞌ a. Tza̱j ne̱ cataj xnaꞌanj soꞌ se vaa ni̱caj ya̱ chana̱ ya̱a̱n se vaa cachíín noꞌ rihaan soꞌ na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ne̱ caꞌneꞌ soꞌ suun rihaan tanuu caꞌa̱nj tanuu tagaꞌ caꞌne̱ꞌ tanuu cúú yave̱ síí cuꞌna̱j Juan yoꞌ a. Ne̱ da̱nj quiꞌyaj nij tanuu a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ne̱ caꞌnéé nij tanuu cúú yave̱ Juan rque agaꞌ rcoꞌo̱o, ne̱ caꞌanj nica̱j nij tanuu cúú yave̱ Juan rihaan chana̱ ya̱a̱n yoꞌ, ne̱ caxríj nij soꞌ man yoꞌ ston chana̱ ya̱a̱n yoꞌ a. Ne̱ caꞌanj nica̱j chana̱ ya̱a̱n yoꞌ man cúú yave̱ Juan rihaan nii noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ga̱a ne̱ cuchiꞌ nij síí tucuꞌyón se‑na̱na̱ Juan tagaꞌ, ne̱ caꞌanj naca̱j nij soꞌ cúú man síí cuꞌna̱j Juan, ne̱ cachinꞌ nij soꞌ man soꞌ rque yoꞌóó a. Ga̱a ne̱ caꞌanj nij soꞌ, cataj xnaꞌanj nij soꞌ rihaan Jesucristó se vaa caviꞌ síí cuꞌna̱j Juan yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Dan me se cuno Jesucristó da̱j cataj síí cuꞌna̱j Herodes cheꞌé soꞌ, ne̱ cheꞌé dan curiha̱nj Jesucristó rej yoꞌ, ne̱ dan me se cavii soꞌ rque rihoo chéé rihaan na, ne̱ caꞌanj soꞌ rej quij rej taj va̱j yuvii̱ mán a. Ne̱ cuno nij yuvii̱ nana̱ se vaa caꞌanj soꞌ rej quij yoꞌ a. Cheꞌé dan curiha̱nj nij yuvii̱ chiháán nij yuvii̱, ne̱ cachéé taco̱j nij yuvii̱ tuꞌva na lacuaná, ne̱ caꞌanj nij yuvii̱ rej caꞌanj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ne̱ nanij Jesucristó rá rihoo, ne̱ queneꞌen soꞌ se vaa a̱j mán uxrá yuvii̱, ne̱ cunuu ꞌe̱e̱ rá soꞌ man nij yuvii̱, ne̱ nahuun sa̱ꞌ taranꞌ nij síí ranꞌ caꞌnaꞌ, quiꞌyaj soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Dan me se cachén ndoꞌo orá, ne̱ nanij güii, ne̱ cuchiꞌ nij síí tucuꞌyón se‑na̱na̱ Jesucristó rihaan soꞌ, ne̱ cataj nij soꞌ: ―Rcoꞌ quij u̱u̱n me nihánj, ne̱ taj se chá cha̱ nij yuvii̱ nihánj, ne̱ cachén ndoꞌo orá na̱nj á. Qui̱ꞌyáá so̱ꞌ se ndoꞌo, ne̱ naꞌne̱j so̱ꞌ chrej man nij yuvii̱, caꞌa̱nj nij yuvii̱ chumanꞌ quira̱a̱n nij yuvii̱ se cha̱ nij yuvii̱ á ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","―Taj cheꞌé caꞌa̱nj nij yuvii̱ maꞌ. Ma̱a̱n se go̱ꞌ maꞌa̱n soj se chá cha̱ nij yuvii̱ á ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","―Tza̱j ne̱ taj se chá rihaan núj nihánj maꞌ. Ma̱a̱n o̱rúnꞌ ꞌu̱nꞌ rachrúún do̱ꞌ, vi̱j gue̱e̱ xcuaj do̱ꞌ, vaa rihaan núj na̱nj á ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","―Rque̱ soj man yoꞌ rihanj nihánj á ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ga̱a ne̱ caꞌneꞌ Jesucristó suun rihaan nij yuvii̱ caꞌa̱nj ca̱yáán nij yuvii̱ rihaan coj chri̱nꞌ, ga̱a ne̱ coro̱ꞌ soꞌ ꞌu̱nꞌ nij rachrúún ne̱ vi̱j ro̱j xcuaj, ne̱ niꞌya̱j soꞌ rej xta̱ꞌ, ne̱ nagoꞌ soꞌ graciá rihaan Diose̱, ga̱a ne̱ cuxraꞌ taꞌa̱j soꞌ man rachrúún yoꞌ, ne̱ caxríj soꞌ ston nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ caxríj nij soꞌ ston nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ga̱a ne̱ chá taranꞌ nij yuvii̱, ne̱ caraa rque cunuda̱nj nij soꞌ, ne̱ nda̱a quináj ndoꞌo se chá, quiꞌyaj nij yuvii̱ a. Ga̱a ne̱ naquiꞌyaj chre̱ꞌ nii man se quináj tuꞌva nij yuvii̱, ne̱ caraa yoꞌó chuvi̱j ya̱ scaa a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ne̱ nij snóꞌo rqué Jesucristó chraa me se ꞌu̱nꞌ míj snóꞌo me nij soꞌ, ne̱ ne quiꞌya̱j contá nii man chana̱ man xnii man chá se chá yoꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ga̱a ne̱ raꞌya̱nj caꞌneꞌ Jesucristó suun rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ se vaa cavi̱i̱ nij soꞌ rihoo chéé rihaan na caꞌa̱nj nij soꞌ rej xco̱ na lacuaná yoꞌ, quita̱j ya̱a̱n nij soꞌ rihaan Jesucristó, ne̱ dan me se maꞌa̱n Jesucristó naꞌne̱j chrej man nij yuvii̱, taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Dan me se caꞌanj nij soꞌ, ne̱ cataj Jesucristó rihaan nij yuvii̱ se vaa caꞌve̱e caꞌa̱nj nij yuvii̱ a. Ga̱a ne̱ cavii o̱rúnꞌ soꞌ raa̱ quij, ne̱ cachíín niꞌya̱j soꞌ rihaan Diose̱ a. Ne̱ da̱j doj cata̱ꞌ güii raa̱ quij, ne̱ soꞌ me se quináj soꞌ raa̱ quij yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Dan me se ga̱nꞌ uxrá va̱j rihoo nu̱u̱ nij síí tucuꞌyón se‑na̱na̱ Jesucristó rihaan na, ne̱ güéj ndoꞌo rihoo yoꞌ rihaan na, quiꞌyaj nana̱, cheꞌé se goꞌ nana̱ rej riha̱a̱n rihoo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Dan me se yanꞌ siꞌnu̱ꞌ caꞌanj Jesucristó rej va̱j nij soꞌ, chéé taco̱j u̱u̱n soꞌ rihaan na yoꞌ, va̱j soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ne̱ queneꞌen nij síí tucuꞌyón se‑na̱na̱ soꞌ man soꞌ se vaa chéé u̱u̱n soꞌ rihaan na, ne̱ cuchuꞌviꞌ ndoꞌo nimán nij soꞌ a. ―Taꞌnaj me yoꞌ ei ―taj nij soꞌ rihaan tuviꞌ nij soꞌ, ne̱ caguáj nij soꞌ, cheꞌé se cuchuꞌviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Veé dan, ne̱ nu̱ꞌ cataj Jesucristó rihaan nij soꞌ a: ―Naquiꞌya̱j nucua̱j soj nimán soj ei. ꞌU̱nj ꞌnaꞌ ei. Se̱ cuchuꞌviꞌ soj maꞌ ―taj soꞌ rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ga̱a ne̱ cataj Pedró rihaan soꞌ a: ―Sese ya̱ ya̱ veé so̱ꞌ ꞌnaꞌ, ne̱ qui̱ꞌyáá so̱ꞌ se ndoꞌo, ne̱ caꞌve̱e cache̱e̱ ꞌu̱nj rihaan na qui̱ꞌyáá so̱ꞌ, Señor ―taj Pedró rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","―Caꞌve̱e caꞌna̱ꞌ so̱ꞌ á ―taj Jesucristó rihaan Pedró a. Ne̱ nanij Pedró rá rihoo, ne̱ cachéé soꞌ rihaan na, ne̱ caꞌanj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tza̱j ne̱ niꞌya̱j soꞌ na se vaa cavii ndoꞌo nana̱ yoꞌ, ne̱ cuchuꞌviꞌ soꞌ, ne̱ guun cheꞌe̱ soꞌ caꞌanj ni̱j soꞌ rque na yoꞌ a. Cheꞌé dan caguáj soꞌ rihaan Jesucristó, cataj soꞌ: ―Ti̱nanii so̱ꞌ manj rihaan na, Señor ―taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Veé dan, ne̱ nu̱ꞌ quitaꞌaa Jesucristó raꞌa Pedró, ne̱ quirii Jesucristó man soꞌ rque na, ne̱ cataj Jesucristó: ―Do̱j amán rá so̱ꞌ niꞌya̱j so̱ꞌ manj á. Me cheꞌé guun vi̱j nimán so̱ꞌ ga̱ ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ga̱a ne̱ catúj ro̱j soꞌ rque rihoo chéé rihaan na, ga̱a ne̱ canicunꞌ nana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ga̱a ne̱ canicunꞌ ru̱j nij síí ma̱n rque rihoo rihaan Jesucristó, ne̱ cataj nij soꞌ: ―Ya̱ taꞌni̱j Diose̱ mé so̱ꞌ á ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ga̱a ne̱ cuchiꞌ nij soꞌ tuꞌva na lacuaná, ne̱ caꞌanj nij soꞌ rej cuꞌna̱j Genesaret a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ne̱ nuu ya̱a̱n nij síí ma̱n rej yoꞌ man Jesucristó, ne̱ caꞌnéé nij soꞌ nana̱ rihaan cunuda̱nj nij síí ya̱nj nu̱ꞌ anica̱j se vaa caꞌnaꞌ Jesucristó a. Ne̱ nica̱j nii man cunuda̱nj nij síí ranꞌ ya̱nj rej yoꞌ caꞌnaꞌ nii rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ne̱ cachíín niꞌya̱j uxrá nij yuvii̱ rihaan Jesucristó se vaa caꞌve̱j Jesucristó cano̱ raꞌa nij soꞌ do̱j tuꞌva saga̱nꞌ soꞌ a. Ne̱ nu̱ꞌ nij síí canó raꞌa do̱j tuꞌva saga̱nꞌ soꞌ roꞌ, nahuun sa̱ꞌ cunuda̱nj nij soꞌ cuaj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ga̱a ne̱ quinichrunꞌ síí fariseo do̱ꞌ, quinichrunꞌ síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés do̱ꞌ, rihaan Jesucristó, ne̱ síí cavii chumanꞌ Jerusalén me nij soꞌ a. Ne̱ xnáꞌanj nij soꞌ man Jesucristó, cataj nij soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Nij síí tucuꞌyón se‑na̱na̱ so̱ꞌ roꞌ, me cheꞌé ne uno nij soꞌ nana̱ cataj xnaꞌanj nij síí ma̱n ga̱a naá ga̱. ꞌO̱ se ne naꞌyaꞌ nij soꞌ ga̱a chá nij soꞌ chraa maꞌ ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Da̱nj na̱nj maꞌa̱n soj, ne̱ me cheꞌé ne uno maꞌa̱n soj se‑na̱na̱ Diose̱ ꞌyaj maꞌa̱n tucuáán noco̱ꞌ soj ga̱. ");
INSERT INTO trcNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ꞌO̱ se caꞌneꞌ Diose̱ suun se vaa: “Cara̱a̱ co̱chróó so̱ꞌ rihaan réé so̱ꞌ do̱ꞌ, rihaan nií so̱ꞌ do̱ꞌ á”. Ne̱: “Síí aꞌmii chre̱e rihaan rej do̱ꞌ, rihaan nii do̱ꞌ, me se va̱j soꞌ ne̱ nu̱ꞌ cheꞌe̱ cavi̱ꞌ soꞌ á”. Da̱nj vaa nana̱ cataj xnaꞌanj Diose̱ rihaan níꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tza̱j ne̱ taj soj se vaa sese cata̱j yoꞌo̱ soꞌ rihaan rej soꞌ do̱ꞌ, rihaan nii soꞌ do̱ꞌ, se vaa a̱j rqué soꞌ nu̱ꞌ siꞌyaj soꞌ rihaan Diose̱ ne̱ cheꞌé dan se̱ caꞌvee ra̱cuíj soꞌ man rej soꞌ do̱ꞌ, man nii soꞌ do̱ꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ne̱ daj chiha̱a̱ míj ne nó xcúún soꞌ ra̱cuíj soꞌ man rej soꞌ do̱ꞌ, man nii soꞌ do̱ꞌ, taj soj a. Dan me se da̱nj ina̱nj aꞌmii soj ga̱a tucuꞌyón soj se‑na̱na̱ nij síí ma̱n ga̱a naá, ne̱ axríj yuve̱ soj man se‑na̱na̱ Diose̱ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","”Dan me se síí tuꞌva rmaꞌa̱n me soj na̱nj á. Dan me se caꞌmii natáj síí cuꞌna̱j Isaías se‑na̱na̱ Diose̱ ga̱a naá, ne̱ cataj xnaꞌanj soꞌ da̱j si̱j me soj a. Cataj soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Yuvii̱ nihánj roꞌ, ase vaa nana̱ aꞌmii síí aráj cochro̱j rihanj vaa nana̱ aꞌmii nij soꞌ, tza̱j ne̱ tuꞌva rmaꞌa̱n nij soꞌ na̱nj á. Nimán nij soꞌ me se ino̱ vaa na̱nj ado̱nj. ꞌO̱ se ne nocoꞌ uxrá nimán nij soꞌ manj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Naꞌvíj rmaꞌa̱n nij soꞌ rihanj na̱nj á. ꞌO̱ se na̱nj se‑na̱na̱ yuvii̱ me nana̱ tucuꞌyón nij soꞌ na̱nj ado̱nj”. Dan me se‑na̱na̱ Diose̱ nana̱ aꞌmii cheꞌé soj á ―taj Jesucristó rihaan nij síí fariseo do̱ꞌ, rihaan nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ga̱a ne̱ canacúún Jesucristó man nij yuvii̱ caꞌna̱ꞌ nij yuvii̱ rihaan soꞌ a. Ga̱a ne̱ cataj soꞌ rihaan nij yuvii̱: ―Cuno̱ soj nana̱ nihánj, ne̱ xca̱j soj cuentá nedi̱ꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nuveé se̱ atúj tuꞌva yuvii̱ me se ꞌyaj chiꞌi̱i̱ man yuvii̱ maꞌ. Se avii tuꞌva yuvii̱ roꞌ, ꞌyaj chiꞌi̱i̱ man yuvii̱ ado̱nj ―taj Jesucristó rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ga̱a ne̱ cuchiꞌ nij síí tucuꞌyón se‑na̱na̱ Jesucristó rihaan Jesucristó, ne̱ cataj nij soꞌ: ―Neꞌén so̱ꞌ se vaa caꞌmaan rá nij síí fariseo cheꞌé nana̱ caꞌmii so̱ꞌ rihaan nij soꞌ naꞌ ―taj nij soꞌ, xnáꞌanj nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ga̱a ne̱ cataj Jesucristó: ―Xa̱ꞌ nij soꞌ, tza̱j ne̱ ase vaa coj xraꞌ maꞌa̱n vaa nij soꞌ do̱ꞌ, vaa nana̱ tucuꞌyón nij soꞌ do̱ꞌ ado̱nj. Nuveé si̱j tucuꞌyón se‑na̱na̱ Diose̱ me nij soꞌ maꞌ. Cheꞌé dan, ase vaa tiriꞌ nii man coj xraꞌ maꞌa̱n roꞌ, da̱nj ga̱a̱ tiri̱ꞌ Diose̱ man nij soꞌ ga̱ nana̱ tucuꞌyón maꞌa̱n nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ta̱náj nij soj man nij soꞌ á. Me rá nij soꞌ cata̱j xnaꞌanj nij soꞌ rihaan yuvii̱ da̱j quiꞌya̱j yuvii̱ á. Tza̱j ne̱ ase vaa síí aráán rihaan vaa nij soꞌ ado̱nj. Dan me se neꞌen soj se vaa sese gu̱un rá síí tuchri̱i ra̱cuíj soꞌ man yoꞌó síí tuchri̱i nari̱ꞌ soꞌ chrej caꞌa̱nj soꞌ, ne̱ quini̱j ro̱j síí tuchri̱i yoꞌ rá yuꞌuj na̱nj ei ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ga̱a ne̱ cataj Pedró rihaan soꞌ a: ―Cata̱j xnaꞌanj so̱ꞌ rihaan núj me taj nana̱ caꞌmii so̱ꞌ cheꞌé se atúj tuꞌva yuvii̱ á ―taj Pedró a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ga̱a ne̱ cataj Jesucristó: ―Vaa soj vaa, ne̱ ataa xca̱j maꞌa̱n soj do̱ꞌ cuentá a̱ naꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ne̱ neꞌen soj se vaa nu̱ꞌ se atúj tuꞌva yuvii̱ roꞌ, achén yoꞌ rque yuvii̱, ne̱ uriha̱nj yoꞌ ga̱a reꞌé yuvii̱ na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tza̱j ne̱ se uriha̱nj tuꞌva yuvii̱ roꞌ, yoꞌ me nana̱ avii nimán yuvii̱, ne̱ nana̱ yoꞌ me ꞌyaj chiꞌi̱i̱ ndoꞌo man yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ꞌO̱ se nihánj me se chiꞌi̱i̱ avii nimán yuvii̱ a: se chiꞌi̱i̱ do̱ꞌ, yan ticavi̱ꞌ man tuviꞌ do̱ꞌ, yan coto̱j ga̱ nica̱ tuviꞌ do̱ꞌ, cheꞌé yan quiꞌya̱j itu̱u̱ siꞌyaj tuviꞌ do̱ꞌ, cheꞌé yan caꞌmi̱i̱ ne̱ cheꞌé tuviꞌ do̱ꞌ, cheꞌé yan nachri̱ꞌ ni̱ꞌyaj man tuviꞌ do̱ꞌ, me nu̱ꞌ se avii nimán yuvii̱, ");
INSERT INTO trcNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ne̱ nu̱ꞌ yoꞌ me se vaa ꞌyaj chiꞌi̱i̱ man yuvii̱ na̱nj ado̱nj. Tza̱j ne̱ cheꞌé nu̱ꞌ se chá yuvii̱ me se caꞌve̱e se ne naꞌyaꞌ yuvii̱ ga̱a chá yuvii̱ chraa, tza̱j ne̱ se̱ quiꞌyaj chiꞌi̱i̱ yoꞌ man yuvii̱ maꞌ ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ga̱a ne̱ curiha̱nj Jesucristó rej yoꞌ, ne̱ caꞌanj soꞌ rej na̱j chumanꞌ cuꞌna̱j Tiro do̱ꞌ, chumanꞌ cuꞌna̱j Sidón do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ga̱a ne̱ curiha̱nj ꞌo̱ chana̱ cananea chana̱ ne̱ rej yoꞌ a. Ne̱ caguáj ndoꞌo noꞌ rihaan Jesucristó, cataj noꞌ: ―Neꞌenj se vaa tuviꞌ síí cuꞌna̱j David síí cane ga̱a naá mé so̱ꞌ, Señor. Cheꞌé dan cunu̱u ꞌe̱e̱ rá so̱ꞌ manj á. ꞌO̱ se canó uxrá nana̱ chre̱e man taꞌníj chala̱ cunii na̱nj á ―taj chana̱ yoꞌ, caguáj noꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tza̱j ne̱ a̱ ꞌó nana̱ ne caꞌmi̱i̱ Jesucristó rihaan noꞌ a. Ga̱a ne̱ cuchiꞌ nij síí tucuꞌyón se‑na̱na̱ Jesucristó rihaan soꞌ, ne̱ cachíín niꞌya̱j nij soꞌ rihaan soꞌ, cataj nij soꞌ: ―Qui̱ꞌyáá so̱ꞌ se ndoꞌo, ne̱ cata̱j xnaꞌanj so̱ꞌ rihaan chana̱ yoꞌ se vaa caꞌa̱nj chana̱ yoꞌ na̱nj rugua̱nj. ꞌO̱ se noco̱ꞌ uxrá noꞌ man níꞌ, ne̱ aguáj ndoꞌo noꞌ na̱nj asanj ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ga̱a ne̱ cataj soꞌ: ―Na̱nj chana̱ yaníj me noꞌ, ne̱ ina̱nj rihaan nij yuvii̱ israelitá caꞌnéé Diose̱ manj na̱nj á. ꞌO̱ se ase vaa daán Diose̱ matzinj roꞌ, vaa nij síí israelitá rihaan Diose̱, ne̱ a̱j caꞌanj niꞌya̱ uxrá nij soꞌ, ne̱ cheꞌé yan nano̱ꞌ ꞌu̱nj man síí caꞌanj niꞌya̱ ꞌnaj na̱nj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ga̱a ne̱ cuchiꞌ chana̱ yoꞌ rihaan Jesucristó, ne̱ canicunꞌ ru̱j noꞌ rihaan Jesucristó, ne̱: ―Ra̱cuíj so̱ꞌ manj, Señor ―taj noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ga̱a ne̱ cataj soꞌ: ―Dan me se neꞌén so̱ꞌ se vaa se̱ caꞌvee ca̱taꞌaa níꞌ coꞌoo ma̱n rihaan nij xnii ne̱ go̱ꞌ níꞌ cha̱ nij chuvee maꞌ. Cheꞌé dan ne nó xcúnj ra̱cuíj man soj si̱j yaníj a̱ man ado̱nj. Ma̱a̱n se ina̱nj maꞌa̱n nij yuvii̱ israelitá me no̱ xcúún ꞌu̱nj ra̱cuíj ꞌu̱nj na̱nj ado̱nj ―taj Jesucristó rihaan chana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ga̱a ne̱ cataj noꞌ: ―Veé da̱nj vaa gue̱e̱, Señor. Ne̱ nij chuvee roꞌ, chá nij xoꞌ tachruu̱ ayuu tuꞌva se‑xqui̱ꞌ nij xoꞌ na̱nj á. Ne̱ ase vaa chuvee chá tachruu̱ vaa ꞌu̱nj rihaan so̱ꞌ na̱nj ado̱nj. Cheꞌé dan me ndoꞌo raj ra̱cuíj so̱ꞌ do̱j manj, raj na̱nj ado̱nj ―taj chana̱ yoꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ga̱a ne̱ cataj Jesucristó: ―Cuchumán uxrá rá so̱ꞌ niꞌya̱j so̱ꞌ manj, nocoj. Cheꞌé dan qui̱ꞌyáj se vaa achíín so̱ꞌ rihanj na̱nj ei ―taj Jesucristó rihaan noꞌ a. Ne̱ veé ma̱a̱n orá dan nahuun sa̱ꞌ taꞌníí chana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ga̱a ne̱ curiha̱nj Jesucristó rej yoꞌ, ne̱ cachén soꞌ na lacuaná cuꞌna̱j Galilea, ga̱a ne̱ cavii soꞌ raa̱ ꞌo̱ quij, ne̱ caꞌanj ca̱yáán soꞌ rihaan yoꞌóó a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ne̱ cuchiꞌ uxrá yuvii̱ rihaan soꞌ, ne̱ caꞌnaꞌ nij yuvii̱ nica̱j nij yuvii̱ man tuviꞌ nij yuvii̱ síí ranꞌ rihaan soꞌ a. Dan me se síí chéé rengo̱ do̱ꞌ, síí tuchri̱i do̱ꞌ, síí yaꞌmi̱i do̱ꞌ, síí anó chiꞌii̱ do̱ꞌ, cuchiꞌ rihaan Jesucristó, quiꞌyaj nij yuvii̱, ne̱ cuchruj nij yuvii̱ man nij síí ranꞌ yoꞌ tacóó Jesucristó, ne̱ nahuun sa̱ꞌ nij soꞌ, quiꞌyaj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ne̱ caráyaꞌa̱nj ndoꞌo nij yuvii̱ queneꞌen nij yuvii̱ se vaa caꞌmii nij síí yaꞌmi̱i yoꞌ do̱ꞌ, se vaa cachéé sa̱ꞌ nij síí rengo̱ do̱ꞌ, se vaa nachuguu̱n rihaan nij síí tuchri̱i do̱ꞌ a. Ne̱ sa̱ꞌ uxrá caꞌmii nij yuvii̱ cheꞌé Diose̱ se vaa veꞌé ndoꞌo vaa Diose̱ síí noco̱ꞌ nij yuvii̱ israelitá man a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ga̱a ne̱ canacúún Jesucristó caꞌna̱ꞌ nij síí tucuꞌyón se‑na̱na̱ soꞌ rihaan soꞌ, ne̱ cataj soꞌ: ―Cunuu ꞌe̱e̱ raj man nij yuvii̱ nihánj na̱nj á. ꞌO̱ se quisíj vaꞌnu̱j güii mán nij soꞌ ga̱j, ne̱ taj yan va̱j se chá nij soꞌ a̱ maꞌ. Ne̱ naꞌvej raj caꞌne̱j ꞌu̱nj man nij soꞌ caꞌa̱nj nij soꞌ maꞌ. ꞌO̱ se va̱j nij soꞌ chrej, ne̱ naꞌaan rque nij soꞌ, ne̱ nina̱j nij soꞌ rá chrej, rá ꞌu̱nj na̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ne̱ cataj nij síí tucuꞌyón se‑na̱na̱ soꞌ rihaan soꞌ a: ―ꞌO̱ se rcoꞌ quij u̱u̱n me nihánj, ne̱ me rej quiri̱ꞌ níꞌ rachrúún cha̱ cunuda̱nj nij yuvii̱ nihánj ga̱ ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","―Me daj rachrúún vaa rihaan soj ga̱ ―taj Jesucristó, xnáꞌanj soꞌ man nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ―Da̱j ꞌo̱ chi̱j rachrúún ne̱ da̱j do̱j xcuaj leꞌe̱j nii ne̱, vaa rihaan núj na̱nj ado̱nj ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ga̱a ne̱ caꞌneꞌ Jesucristó suun rihaan nij yuvii̱ se vaa ca̱yáán nij yuvii̱ rihaan yoꞌóó a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ga̱a ne̱ nica̱j soꞌ chi̱j rachrúún yoꞌ ne̱ do̱j xcuaj, ne̱ nagoꞌ soꞌ graciá rihaan Diose̱, ga̱a ne̱ cuxraꞌ taꞌa̱j soꞌ man rachrúún yoꞌ do̱ꞌ, man nee̱ xcuaj yoꞌ do̱ꞌ, ne̱ caxríj soꞌ ston nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ rqué nij soꞌ rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ga̱a ne̱ chá cunuda̱nj nij yuvii̱, ne̱ nda̱a caraa rque nij soꞌ a. Ga̱a ne̱ naquiꞌyaj chre̱ꞌ nii se vaa quináj tuꞌva nij yuvii̱ yoꞌ, ne̱ quisíj ꞌo̱ cunu̱ꞌ chi̱j ya̱ scaa caraa quiꞌyaj se quináj tuꞌva nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Dan me se cunuda̱nj nij soꞌ chá, ne̱ quisíj nda̱a caꞌa̱nj míj nij snóꞌo chá, ne̱ ino̱ me se chá nij chana̱ do̱ꞌ, nij xnii do̱ꞌ, na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ga̱a ne̱ naꞌnéé Jesucristó chrej man nij yuvii̱, ne̱ cavii soꞌ rá rihoo chéé rihaan na, ne̱ caꞌanj soꞌ rej cuꞌna̱j Magadán a. ");
INSERT INTO trcNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ga̱a ne̱ cuchiꞌ nij síí fariseo cuchiꞌ nij síí saduceo cuchiꞌ rihaan Jesucristó, ne̱ me rá nij soꞌ queneꞌe̱n nij soꞌ sese ya̱ síí caꞌnéé Diose̱ me Jesucristó a. Cheꞌé dan cachíín niꞌya̱j nij soꞌ rihaan Jesucristó se vaa ra̱cuíj Diose̱ man Jesucristó, ne̱ quiꞌya̱j Jesucristó ꞌo̱ suun sa̱ꞌ noco̱o queneꞌe̱n nij soꞌ, ga̱a ne̱ gu̱un ya̱ rá nij soꞌ se vaa síí caꞌnéé ya̱ Diose̱ me Jesucristó, rá nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ga̱a ne̱ caꞌmii Jesucristó rihaan nij soꞌ, cataj soꞌ: ―Dan me se ga̱a ataꞌ güii, ne̱ niꞌya̱j soj xta̱ꞌ, ne̱ sese mare̱e vaa xta̱ꞌ, ne̱: “Xraj, ne̱ xꞌnu̱u̱ aꞌyuj”, taj soj á. ");
INSERT INTO trcNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ne̱ rej naꞌya̱a̱n niꞌya̱j soj xta̱ꞌ, ne̱ sese mare̱e vaa rej xta̱ꞌ, ne̱ sese aráán ndoꞌo ngaa rej xta̱ꞌ, ne̱: “Corá cama̱nꞌ uxrá maa̱n”, taj uún soj á. Dan me se neꞌen soj xca̱j soj cuentá cheꞌé se vaa neꞌen soj rej xta̱ꞌ, tza̱j ne̱ ne neꞌen soj xca̱j soj cuentá cheꞌé sayuun quira̱nꞌ soj si̱j ma̱n rihaan chumii̱ nihánj vaa güii a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","”Ma̱a̱n cheꞌé se yuvii̱ ꞌnaꞌ rej chiꞌi̱i̱ naꞌvej rá canoco̱ꞌ sa̱ꞌ man Diose̱ me soj si̱j israelitá, ne̱ cheꞌé dan me rá soj qui̱ꞌyáj suun sa̱ꞌ noco̱o á. Tza̱j ne̱ se̱ quiꞌyáj suun sa̱ꞌ noco̱o maꞌ. Ma̱a̱n se queneꞌe̱n soj se vaa ase vaa quiranꞌ síí cuꞌna̱j Jonás síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá roꞌ, da̱nj qui̱ránꞌ ꞌu̱nj, vaa güii na̱nj á ―taj Jesucristó rihaan nij síí fariseo do̱ꞌ, rihaan nij síí saduceo do̱ꞌ a. Ga̱a ne̱ tanáj Jesucristó man nij soꞌ, ne̱ caꞌanj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ga̱a ne̱ caꞌanj nij síí tucuꞌyón se‑na̱na̱ Jesucristó rej xco̱ na lacuaná, ga̱a ne̱ xcaj nij soꞌ cuentá se vaa quiniꞌyón nij soꞌ, ne ni̱caj nij soꞌ rachrúún cha̱ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Cu̱tumé soj man soj se̱ gaa na̱nj quira̱nꞌ soj sayuun, quiꞌya̱j se‑le̱vadura nij síí fariseo do̱ꞌ, nij síí saduceo do̱ꞌ á ―taj Jesucristó no nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ne̱ nuchruj ra̱a̱ ndoꞌo nij síí tucuꞌyón se‑na̱na̱ Jesucristó cheꞌé nana̱ caꞌmii soꞌ, ne̱: ―Cheꞌé se taj rachrúún nica̱j níꞌ, ne̱ cheꞌé dan aꞌmii soꞌ cheꞌé levadura se ꞌyaj naraa nana̱ rque rachrúún na̱nj ado̱nj ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ne̱ a̱j neꞌen Jesucristó da̱j uun nimán nij soꞌ, ne̱ cheꞌé dan cataj soꞌ: ―Me cheꞌé nanó ndoꞌo rá soj se vaa taj rachrúún rihaan soj ga̱. ꞌO̱ se do̱j amán rá soj neꞌen soj manj vaa ga̱a̱ na̱nj asan. ");
INSERT INTO trcNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Me cheꞌé ataa xca̱j soj cuentá ga̱. Ne̱ ne nuû rá soj ga̱a vaa da̱j ꞌo̱ ꞌu̱nꞌ gue̱e̱ rachrúún rihaan níꞌ tza̱j ne̱ quisíj chá cunu̱ꞌ ꞌu̱nꞌ míj snóꞌo, quiꞌyáj a. Ne̱ nda̱a queꞌe̱e̱ scaa se chá quináj tuꞌva yuvii̱ ga̱a naquiꞌyaj chre̱ꞌ soj a. ");
INSERT INTO trcNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ne̱ me cheꞌé quiniꞌyón soj cheꞌé chi̱j rachrúún ga̱. Ne nuû rá soj ga̱a vaa da̱j ꞌo̱ chi̱j gue̱e̱ rachrúún rihaan níꞌ tza̱j ne̱ quisíj chá cunu̱ꞌ caꞌa̱nj míj snóꞌo, quiꞌyáj a. Ne̱ nda̱a queꞌe̱e̱ scaa se chá quináj ga̱a naquiꞌyaj chre̱ꞌ uún soj a. ");
INSERT INTO trcNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Da̱j me cheꞌé ne̱ ne cuno̱ soj ga̱. Nuveé cheꞌe̱ na̱nj rachrúún caꞌmij rihaan soj maꞌ. Ma̱a̱n se cu̱tumé soj man soj se̱ gaa na̱nj quira̱nꞌ soj sayuun quiꞌya̱j se‑le̱vadura nij síí fariseo do̱ꞌ, nij síí saduceo do̱ꞌ ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ga̱a ne̱ xcaj nij soꞌ cuentá se vaa nuveé cheꞌe̱ na̱nj levadura se ꞌyaj naraa nana̱ rque rachrúún me cataj xnaꞌanj Jesucristó rihaan nij soꞌ se vaa cu̱tumé nij soꞌ man nij soꞌ; ma̱a̱n ne̱ ꞌo̱ se cheꞌe̱ se ne caꞌve̱j rá Jesucristó tiha̱ꞌ yuꞌunj nij síí fariseo do̱ꞌ, nij síí saduceo do̱ꞌ, man nij soꞌ ga̱ se‑na̱na̱ nij soꞌ roꞌ, cheꞌé dan caꞌmii Jesucristó nana̱ vaa da̱nj rihaan nij síí noco̱ꞌ man soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ga̱a ne̱ caꞌanj Jesucristó rej na̱j chumanꞌ cuꞌna̱j Cesarea de Filipo, ga̱a ne̱ xnáꞌanj soꞌ man nij síí tucuꞌyón se‑na̱na̱ soꞌ, cataj soꞌ: ―Da̱j taj nij yuvii̱ cheꞌé ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ ga̱. Ne̱ me síí mé ꞌu̱nj, taj nij yuvii̱ ga̱ ―taj Jesucristó, xnáꞌanj soꞌ man nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","―Vaa síí taj se vaa síí cuꞌna̱j Juan síí cutaꞌ ne man yuvii̱ mé so̱ꞌ ei. Ne̱ vaa síí taj uún se vaa síí cuꞌna̱j Elías síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá me uún so̱ꞌ chugua̱nj. Ne̱ vaa síí taj uún se vaa síí cuꞌna̱j Jeremías do̱ꞌ, yoꞌó síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá do̱ꞌ, me uún so̱ꞌ xa̱ꞌ. ꞌO̱ se da̱nj taj ꞌo̱ ꞌo̱ nij yuvii̱ cheꞌé so̱ꞌ na̱nj ado̱nj ―cataj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","―Ne̱ maꞌa̱n soj, ga̱a ne̱ me síí mé ꞌu̱nj, rá maꞌa̱n soj ga̱ ―taj Jesucristó, xnáꞌanj soꞌ man nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ga̱a ne̱ cataj síí cuꞌna̱j Simón Pedró: ―Síí caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun mé so̱ꞌ, ne̱ taꞌni̱j Diose̱ síí vaa iꞌna̱ꞌ ya̱ mé so̱ꞌ ei ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ga̱a ne̱ cataj Jesucristó rihaan Pedró a: ―Quiꞌyaj uxrá Diose̱ se lu̱j cheꞌé so̱ꞌ, Simón taꞌni̱j síí cuꞌna̱j Jonás á. ꞌO̱ se nuveé na̱na̱ cataj xnaꞌanj yuvii̱ rihaan so̱ꞌ me nana̱ caꞌmii so̱ꞌ cuano̱ maꞌ. ꞌO̱ se Réé ꞌu̱nj síí nicu̱nꞌ xta̱ꞌ me síí racuíj mán so̱ꞌ naríꞌ so̱ꞌ nana̱ yoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ne̱ cuano̱ nihánj me se cata̱j xnaꞌanj ꞌu̱nj rihaan so̱ꞌ se vaa ya̱ Pedró cuꞌna̱j so̱ꞌ, cheꞌé se ase vaa yuvej ne̱ tacóó veꞌ roꞌ, vaa so̱ꞌ, ne̱ síí nucua̱j ndoꞌo nimán mé so̱ꞌ ei. Cheꞌé dan, ase vaa ꞌyaj nii uneꞌ nii veꞌ xráá yuvej roꞌ, da̱nj ga̱a̱ qui̱ꞌyáj, cune̱ꞌ ꞌu̱nj man nij síí noco̱ꞌ manj, se vaa gu̱un nucua̱j rá nij soꞌ mán so̱ꞌ, ne̱ ni̱caj yuꞌunj so̱ꞌ man nij soꞌ, qui̱ꞌyáj na̱nj ado̱nj. Ne̱ se̱ caviꞌ nu̱ꞌ soj si̱j noco̱ꞌ manj a̱ maꞌ. ꞌO̱ se ga̱a̱ iꞌna̱ꞌ soj nu̱ꞌ cavii nu̱ꞌ caꞌanj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ne̱ cune̱ꞌ ꞌu̱nj mán so̱ꞌ se vaa guún so̱ꞌ síí quiꞌya̱j ca̱yáán yuvii̱ ga̱ Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj, ne̱ na̱j guun rasu̱u̱n cata̱j xnaꞌanj so̱ꞌ se vaa ne nó xcúún yuvii̱ quiꞌya̱j yuvii̱ me se veé da̱nj maꞌa̱n Diose̱ naꞌvej quiꞌya̱j yuvii̱ da̱nj maꞌ. Ne̱ na̱j guun rasu̱u̱n cata̱j xnaꞌanj so̱ꞌ se vaa caꞌve̱e quiꞌya̱j yuvii̱ me se veé da̱nj maꞌa̱n Diose̱ aꞌvej quiꞌya̱j yuvii̱ da̱nj ado̱nj. ―Ina̱nj da̱nj caꞌmii Jesucristó rihaan síí cuꞌna̱j Pedró a. ");
INSERT INTO trcNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ga̱a ne̱ cataj xnaꞌanj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ se vaa se̱ nataꞌ nij soꞌ rihaan a̱ ꞌó yuvii̱ se vaa síí caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun me soꞌ, taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Dan me se güii yoꞌ guun cheꞌe̱ Jesucristó cataj xnaꞌanj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ se vaa no̱ xcúún soꞌ cavi̱i̱ soꞌ chumanꞌ Jerusalén, ne̱ quira̱nꞌ ndoꞌo soꞌ sayuun quiꞌya̱j nij síí uun chij do̱ꞌ, nij xrej ata̱ suun noco̱o doj do̱ꞌ, nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan nij yuvii̱ do̱ꞌ a. Ne̱ ticavi̱ꞌ nii man soꞌ, ne̱ cache̱n vaꞌnu̱j güii, ga̱a ne̱ cunu̱u iꞌna̱ꞌ uún soꞌ, cataj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ga̱a ne̱ quirii yaníj síí cuꞌna̱j Pedró man Jesucristó, ne̱ guun cheꞌe̱ soꞌ cataj soꞌ se vaa ne nó xcúún Jesucristó caꞌmi̱i̱ Jesucristó da̱nj a. Ne̱ cataj Pedró: ―Cunu̱u ꞌe̱e̱ rá Diose̱ mán so̱ꞌ, Señor. Daj chiha̱a̱ míj se̱ quiránꞌ so̱ꞌ da̱nj maꞌ ―taj Pedró rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ga̱a ne̱ canica̱j Jesucristó, ne̱ caꞌmii soꞌ rihaan Pedró a: ―Naxu̱u̱n so̱ꞌ mán so̱ꞌ rihanj á. Naꞌvej raj que̱neꞌenj mán so̱ꞌ maꞌ. ꞌO̱ se ase tuꞌva síí chre̱e síí cuꞌna̱j Satanás roꞌ, da̱nj tuꞌvá so̱ꞌ, ne̱ aráán so̱ꞌ chrej rihanj cu̱noj rihaan Diose̱ ei. Da̱nj tuꞌvá so̱ꞌ, cheꞌé se ne acaj so̱ꞌ cuentá da̱j me rá Diose̱ ado̱nj. Ma̱a̱n se ina̱nj acaj so̱ꞌ cuentá da̱j me rá yuvii̱ na̱nj ado̱nj ―taj Jesucristó rihaan síí cuꞌna̱j Pedró yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ga̱a ne̱ cataj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a: ―Sese me rá yoꞌo̱ soꞌ canoco̱ꞌ soꞌ manj, ne̱ se̱ guun rá soꞌ quiꞌya̱j soꞌ se vaa me rá maꞌa̱n soꞌ quiꞌya̱j soꞌ maꞌ. Ne̱ caꞌve̱e se quira̱nꞌ uxrá soꞌ sayuun do̱ꞌ, caꞌve̱e se nda̱a cachro̱n nii man soꞌ rihaan rcutze̱ do̱ꞌ, tza̱j ne̱ yoꞌo̱ quiꞌya̱j suun soꞌ cheꞌej, ne̱ yoꞌo̱ canoco̱ꞌ raan soꞌ manj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tza̱j ne̱ sese vaa ꞌo̱ síí me rá ti̱nanii man maꞌa̱n rihaan sayuun, ne̱ vaa güii yoꞌo̱ cavi̱ꞌ nimán soꞌ ado̱nj. Tza̱j ne̱ sese cavi̱ꞌ yoꞌo̱ soꞌ cheꞌé se vaa me soꞌ síí noco̱ꞌ manj, ne̱ vaa güii cunu̱u iꞌna̱ꞌ uún soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ne̱ a̱ me se quiri̱i̱ ꞌo̱ soꞌ sese quiꞌya̱j canaán soꞌ nu̱ꞌ rasu̱u̱n ma̱n rihaan chumii̱ nihánj ne̱ caꞌa̱nj niꞌya̱ nimán soꞌ, rá soj ga̱. Daj chiha̱a̱ míj se̱ caꞌvee cavi̱i̱ sa̱ꞌ soꞌ, quiꞌya̱j rasu̱u̱n ma̱n rihaan chumii̱ nihánj a̱ maꞌ. Tza̱j ne̱ caꞌve̱e se navij nu̱ꞌ siꞌyaj yoꞌo̱ soꞌ rihaan chumii̱ nihánj, tza̱j ne̱ sese ga̱a̱ iꞌna̱ꞌ nimán soꞌ nu̱ꞌ cavii nu̱ꞌ caꞌanj, ne̱ quinano̱ rá soꞌ, rá soj naꞌ. Daj chiha̱a̱ míj se̱ quinanó rá soꞌ a̱ maꞌ. ꞌO̱ se cavi̱i̱ sa̱ꞌ uxrá soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","”ꞌO̱ se ya̱ ya̱ caꞌna̱ꞌ ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱, ne̱ uxrá veꞌé ga̱a̱ ꞌu̱nj, quiꞌya̱j Réé ꞌu̱nj, ne̱ caꞌna̱ꞌ nij se‑mo̱zó soꞌ ga̱ ꞌu̱nj na̱nj ado̱nj. Ga̱a ne̱ na̱ruꞌvee ꞌu̱nj rihaan ꞌo̱ ꞌo̱ soꞌ cheꞌé suun quiꞌyaj suun ꞌo̱ ꞌo̱ soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa xa̱ꞌ taꞌa̱j soj si̱j nicu̱nꞌ nihánj cuano̱ me se ga̱a ataa a̱ cavi̱ꞌ taꞌa̱j soj, ne̱ ya̱ queneꞌe̱n taꞌa̱j soj asa̱ꞌ caꞌnáꞌ ꞌu̱nj gu̱un chij ꞌu̱nj rihaan chumii̱ nihánj, ne̱ queneꞌe̱n taꞌa̱j soj manj na̱nj ado̱nj. Dan me se síí caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ mej na̱nj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Cachén vata̱nꞌ güii, ga̱a ne̱ nica̱j Jesucristó man síí cuꞌna̱j Pedró do̱ꞌ, síí cuꞌna̱j Jacobo do̱ꞌ, tinúú Jacobo síí cuꞌna̱j Juan do̱ꞌ, caꞌanj soꞌ raa̱ ꞌo̱ quij xca̱a̱n rej taj va̱j a̱ ꞌó yuvii̱ ne a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ga̱a ne̱ yoꞌo̱ cunuu ino̱ cunuda̱nj man Jesucristó niꞌya̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ dan me se chuguu̱n ndoꞌo rihaan soꞌ, ne̱ ase vaa chuguu̱n güii roꞌ, da̱nj chuguu̱n rihaan soꞌ na̱nj á. Ne̱ nuu catzi̱i̱ ndoꞌo saga̱nꞌ soꞌ, ne̱ ase vaa yaꞌan chuguu̱n vaa saga̱nꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ga̱a ne̱ naquiꞌyaa síí cuꞌna̱j Moisés síí cane ga̱a naá ga̱ síí cuꞌna̱j Elías síí cane ga̱a naá rihaan nij soꞌ, ne̱ nanó ro̱j soꞌ cuentó ga̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ga̱a ne̱ cataj Pedró rihaan Jesucristó a: ―Cuna̱j uxrá vaa mán núj nihánj ga̱ so̱ꞌ, Señor. Sese me rá so̱ꞌ, ne̱ qui̱ꞌyáá ꞌu̱nj vaꞌnu̱j veꞌ yacataj cane̱ soj na̱nj á. ꞌO̱ veꞌ ca̱né so̱ꞌ, ne̱ yoꞌó veꞌ cane̱ síí cuꞌna̱j Moisés, ne̱ yoꞌó veꞌ cane̱ síí cuꞌna̱j Elías ei ―taj Pedró rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ataa quisi̱j caꞌmii Pedró, ne̱ caꞌnaꞌ ꞌo̱ ngaa chuguu̱n ndoꞌo, ne̱ caráán ngaa chuguu̱n yoꞌ man taranꞌ nij soꞌ a. Ga̱a ne̱ Diose̱ roꞌ, caꞌmii nana̱ cuno nij soꞌ rque ngaa yoꞌ, ne̱ cataj Diose̱: ―Síí nihánj me taꞌníj ado̱nj. ꞌE̱e̱ raj man soꞌ, niha̱ꞌ raj niꞌya̱j ꞌu̱nj man soꞌ ado̱nj. Cuno̱ soj rihaan soꞌ ei ―taj Diose̱ cuno nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Dan me se cuno nij síí tucuꞌyón se‑na̱na̱ Jesucristó nana̱ yoꞌ, ga̱a ne̱ caꞌanj quina̱j nij soꞌ rihaan yoꞌóó, ne̱ cuchuꞌviꞌ ndoꞌo nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ga̱a ne̱ cuchiꞌ Jesucristó rihaan nij soꞌ, ne̱ cutaꞌ raꞌa soꞌ xráá nij soꞌ, ne̱ cataj soꞌ: ―Canicu̱nꞌ caya̱ soj, ne̱ se̱ cuchuꞌviꞌ soj maꞌ ―taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ga̱a ne̱ naxca̱j rihaan nij soꞌ niꞌya̱j nij soꞌ, ne̱ da̱j o̱rúnꞌ Jesucristó nicunꞌ, queneꞌen nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ga̱a ne̱ ga̱a nanij nij soꞌ tacóó quij yoꞌ me se caꞌneꞌ Jesucristó suun rihaan nij soꞌ, cataj soꞌ: ―Se̱ nataꞌ soj rihaan a̱ ꞌó yuvii̱ cheꞌé se vaa queneꞌen soj cuanꞌ maꞌ. Yoꞌo̱ dínj ga̱a̱ tuꞌva soj cheꞌé se vaa queneꞌen soj á. Nda̱a quisíj cavíꞌ ꞌu̱nj ne̱ cunuu iꞌna̱ꞌ uún ꞌu̱nj, ga̱a ne̱ caꞌve̱e nata̱ꞌ soj se vaa queneꞌen soj da̱j quiránꞌ ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ na̱nj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ga̱a ne̱ xnáꞌanj nij síí tucuꞌyón se‑na̱na̱ soꞌ man soꞌ, cataj nij soꞌ: ―Me cheꞌé taj nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ se vaa asino caꞌna̱ꞌ síí cuꞌna̱j Elías síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá, ga̱a ne̱ caꞌve̱e caꞌne̱ꞌ Diose̱ cacunꞌ cheꞌé yuvii̱ ga̱ ―taj nij síí tucuꞌyón se‑na̱na̱ Jesucristó, xnáꞌanj nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ga̱a ne̱ cataj Jesucristó: ―Ya̱ aꞌmii nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés, taj nij soꞌ se vaa asino caꞌna̱ꞌ síí cuꞌna̱j Elías, ga̱a ne̱ naquiꞌya̱j sa̱ꞌ soꞌ nu̱ꞌ rasu̱u̱n ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tza̱j ne̱ cuano̱ nihánj me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa a̱j caꞌnaꞌ síí cuꞌna̱j Elías yoꞌ, tza̱j ne̱ ne cuno̱ nij yuvii̱ rihaan soꞌ maꞌ. Ma̱a̱n se quiꞌyaj ya̱ nij yuvii̱ nda̱a vaa me rá maꞌa̱n nij yuvii̱ man soꞌ na̱nj ado̱nj. Ne̱ nda̱ꞌ se si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ mej, tza̱j ne̱ ase vaa quiranꞌ soꞌ sayuun quiꞌyaj nij yuvii̱ roꞌ, da̱nj ina̱nj qui̱ránꞌ ꞌu̱nj sayuun quiꞌya̱j uún nij yuvii̱ na̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ga̱a ne̱ xcaj nij síí tucuꞌyón se‑na̱na̱ Jesucristó cuentá se vaa caꞌmii Jesucristó cheꞌé síí cuꞌna̱j Juan síí cutaꞌ ne man yuvii̱ cataj Jesucristó se vaa síí nacaj se‑su̱u̱n síí cuꞌna̱j Elías me síí cuꞌna̱j Juan yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ga̱a ne̱ caꞌanj nij soꞌ rej va̱j ndoꞌo yuvii̱, ne̱ cuchiꞌ ꞌo̱ snóꞌo rihaan Jesucristó, ga̱a ne̱ canicunꞌ ru̱j soꞌ rihaan Jesucristó, ga̱a ne̱ cataj soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Cunu̱u ꞌe̱e̱ rá so̱ꞌ man taꞌníj, Señor. ꞌO̱ se quisnúú soꞌ, quiꞌyaj yavii, ne̱ ina̱nj naxruꞌ soꞌ rihaan yaꞌan, ne̱ ranꞌ ndoꞌo soꞌ sayuun na̱nj ado̱nj. Veé dan, ne̱ ina̱nj naxruꞌ soꞌ rque na uún, ne̱ ne niꞌya̱nj uxrá ranꞌ soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ne̱ caꞌanj nica̱j ꞌu̱nj man soꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ so̱ꞌ, tza̱j ne̱ taj se quiꞌyáꞌ nahu̱un sa̱ꞌ soꞌ, quiꞌyaj nij soꞌ maꞌ ―taj snóꞌo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ga̱a ne̱ cataj Jesucristó: ―Dan me se síí ne amán rá me soj si̱j ma̱n rihaan chumii̱ nihánj cuano̱, ne̱ chiꞌi̱i̱ vaa nimán soj, ne̱ a̱ me daj cache̱j ga̱ soj, ne̱ a̱ me daj ga̱a̱ naj nimanj ni̱ꞌyaj ꞌu̱nj man soj, ga̱a ne̱ caꞌve̱e quiꞌya̱j canaán soj ga̱. Ni̱caj soj man xnii caꞌna̱ꞌ soj rihanj cuaj á ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ga̱a ne̱ caꞌneꞌ Jesucristó suun rihaan nana̱ chre̱e nu̱u̱ nimán xnii se vaa ta̱náj soꞌ man xnii yoꞌ a. Ga̱a ne̱ curiha̱nj soꞌ nimán xnii, caꞌanj soꞌ, ne̱ veé ma̱a̱n orá dan nahuun sa̱ꞌ xnii yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ga̱a ne̱ cuchiꞌ ina̱nj nij maꞌa̱n nij síí tucuꞌyón se‑na̱na̱ Jesucristó rihaan Jesucristó, ne̱ xnáꞌanj nij soꞌ man soꞌ, cataj nij soꞌ: ―Me cheꞌé ne gu̱un nucua̱j núj caꞌve̱e quiri̱i̱ núj man nana̱ chre̱e yoꞌ nimán xnii ga̱ ―cataj nij soꞌ, xnáꞌanj nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ga̱a ne̱ cataj Jesucristó: ―Cheꞌé se do̱j amán rá soj, cheꞌé dan ne caꞌve̱e gu̱un nucua̱j soj ei. Tza̱j ne̱ neꞌen soj se vaa caân ma̱n raa̱ cuêj mostazá xlá, ne̱ nda̱ꞌ se tzinꞌ vaa yoꞌ, tza̱j ne̱ asa̱ꞌ achij yoꞌ, ne̱ ase vaa caân chruun chi̱i ndoꞌo roꞌ, vaa yoꞌ ei. Ne̱ ase vaa caân cuêj mostazá xlá yoꞌ roꞌ, da̱nj ga̱a̱ maꞌa̱n soj á. Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa sese ya̱ amán rá soj ne̱ sese cata̱j soj rihaan ꞌo̱ quij se vaa cu̱riha̱nj quij yoꞌ rej nicu̱nꞌ yoꞌ ne̱ natuna̱ quij yoꞌ rej nicu̱nꞌ quij yoꞌ, ne̱ sese ya̱ ya̱ cuchuma̱n rá soj se vaa caꞌa̱nj quij yoꞌ, ne̱ cavi̱i̱ quij yoꞌ rej nicu̱nꞌ yoꞌ, ne̱ caꞌa̱nj yoꞌ níchrej ei. Ne̱ gu̱un nucua̱j soj quiꞌya̱j soj cunuda̱nj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ne̱ nana̱ chre̱e vaa da̱nj roꞌ, se̱ caꞌvee quiꞌya̱j níꞌ cu̱riha̱nj nij soꞌ nimán yuvii̱ sese ne achíín niꞌya̱j ndoꞌo níꞌ rihaan Diose̱ ne̱ sese ne tocoꞌ níꞌ xꞌnaa man maꞌa̱n níꞌ cheꞌé se aráj gue̱e̱ níꞌ rihaan Diose̱ a ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Dan me se cunuu chre̱ꞌ uún taranꞌ nij soꞌ estadó Galilea, ga̱a ne̱ cataj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a: ―ꞌO̱ se síí caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ mej, ne̱ vaa güii nago̱ꞌ nii manj rihaan yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Dan me se ticavi̱ꞌ nij yuvii̱ manj, ga̱a ne̱ cache̱n vaꞌnu̱j güii, ga̱a ne̱ cunu̱u iꞌna̱ꞌ uún ꞌu̱nj na̱nj ado̱nj ―taj Jesucristó a. Ga̱a ne̱ quinanó ndoꞌo rá nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Catúj nij soꞌ chumanꞌ Capernaum, ga̱a ne̱ cuchiꞌ nij síí caꞌnéj puextó cheꞌé nuvií rihaan síí cuꞌna̱j Pedró, ne̱ xnáꞌanj nij soꞌ man Pedró, cataj nij soꞌ: ―Síí tucuꞌyón nana̱ rihaan soj roꞌ, oꞌ soꞌ puextó cheꞌé nuvií naꞌ ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","―Oꞌ soꞌ ei ―taj Pedró rihaan nij soꞌ a. Ga̱a ne̱ catúj Pedró rá veꞌ, tza̱j ne̱ a̱j neꞌen Jesucristó se vaa me rá Pedró xna̱ꞌanj Pedró sese ya̱ oꞌ Jesucristó puextó cheꞌé nuvií a. Cheꞌé dan asino Jesucristó xnáꞌanj man Pedró, cataj soꞌ: ―Da̱j uun rá so̱ꞌ, ga̱ Simónꞌ. Nij síí nica̱j suun rey uun chij rihaan yuvii̱ ma̱n rihaan chumii̱ nihánj me se me síí aꞌnéj nij soꞌ puextó rihaan ga̱. Rihaan maꞌa̱n taꞌníí nij soꞌ naꞌ. Ase rihaan yoꞌó yuvii̱ xa̱ꞌ ―taj Jesucristó, xnáꞌanj soꞌ man Pedró a. ");
INSERT INTO trcNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","―Rihaan yoꞌó yuvii̱ ado̱nj ―taj Pedró rihaan Jesucristó a. Ga̱a ne̱ cataj Jesucristó: ―Cheꞌé dan taj cheꞌé go̱ꞌ taꞌníí síí nica̱j suun puextó maꞌ. Ne̱ ase vaa síí nica̱j suun vaa Réé ꞌu̱nj Diose̱, ne̱ rii taꞌngaꞌ soꞌ rihaan nuvií, ne̱ cheꞌé dan ne nó xcúnj go̱j puextó cheꞌé nuvií maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","”Tza̱j ne̱ se̱ guun caꞌma̱an rá nij síí aꞌnéj puextó cheꞌé nuvií, quiꞌya̱j níꞌ maꞌ. Cheꞌé dan caꞌa̱nj so̱ꞌ tuꞌva na lacuaná, ne̱ ta̱güéj so̱ꞌ ꞌo̱ agaꞌ ataꞌaa xcuaj rque na, ne̱ qui̱taꞌaa so̱ꞌ xcuaj cano̱ agaꞌ asino ya̱a̱n á. Ga̱a ne̱ nuxra̱ꞌ so̱ꞌ tuꞌva xcuaj yoꞌ, ne̱ quiri̱ꞌ so̱ꞌ saꞌanj aga̱ꞌ estatero tuꞌva xcuaj yoꞌ, ne̱ go̱ꞌ so̱ꞌ saꞌanj yoꞌ cheꞌé níꞌ rihaan nij síí aꞌnéj puextó á ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Veé ma̱a̱n orá dan cuchiꞌ nij síí tucuꞌyón se‑na̱na̱ Jesucristó rihaan soꞌ, ne̱ xnáꞌanj nij soꞌ man soꞌ a: ―Ne̱ me síí me síí gu̱un chij doj asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj ga̱ ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ga̱a ne̱ canacúún Jesucristó caꞌna̱ꞌ ꞌo̱ neꞌej rihaan soꞌ, ne̱ cachrón soꞌ man neꞌej yoꞌ tanu̱u̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ne̱ cataj soꞌ: ―Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa no̱ xcúún soj nuchra̱nꞌ nimán soj, ne̱ ase vaa neꞌej nihánj roꞌ, da̱nj ga̱a̱ soj á. Sese naꞌvej rá soj quiꞌya̱j soj da̱nj, ne̱ daj chiha̱a̱ míj se̱ cayáán soj ga̱ Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Dan me se sese naquiꞌya̱j nica̱ꞌ yoꞌo̱ soꞌ nimán soꞌ, ne̱ sese ase vaa nimán neꞌej nihánj da̱nj ga̱a̱ nimán soꞌ, ne̱ soꞌ me síí gu̱un chij doj asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","”Ne̱ me maꞌa̱n ꞌo̱ síí aráj cochro̱j ne̱ aꞌmii sa̱ꞌ ga̱ ꞌo̱ neꞌej nihánj cheꞌej, ne̱ adi̱ꞌ ma̱ꞌanj me aráj cochro̱j ne̱ aꞌmii sa̱ꞌ soꞌ ga̱ vaa na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Dan me se me maꞌa̱n ꞌo̱ síí quiꞌya̱j chiꞌi̱i̱ nimán ꞌo̱ síí leꞌe̱j amán rá niꞌya̱j manj, ne̱ caꞌve̱e a̱ doj cavi̱i̱ sa̱ꞌ síí quiꞌyaj da̱nj sese toco̱ꞌ nii ꞌo̱ yuvej xi̱j váj ꞌnúú trigó gaán chihá soꞌ ne̱ ta̱güéj nii man soꞌ rque na yaꞌa̱nj na̱nj ado̱nj. Dan me se doj a̱ sayuun quira̱nꞌ soꞌ, sese quiꞌyaj chiꞌi̱i̱ soꞌ nimán ꞌo̱ síí leꞌe̱j amán rá niꞌya̱j manj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nique̱ ndoꞌo nij síí ma̱n rihaan chumii̱ nihánj, cheꞌé se vaa yaꞌnúj uxrá rihaan nij soꞌ canoco̱ꞌ nij soꞌ chrej chiꞌi̱i̱ ei. Ne̱ ina̱nj da̱nj vaa chumii̱ nihánj, ma̱n ndoꞌo chrej chiꞌi̱i̱ canoco̱ꞌ yuvii̱ ei. Tza̱j ne̱ nique̱ síí ꞌyaj anocoꞌ yuvii̱ chrej chiꞌi̱i̱ yoꞌ na̱nj ado̱nj. ꞌO̱ se daj chiha̱a̱ míj se̱ cavii sa̱ꞌ soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","”Dan me se sese raꞌá so̱ꞌ do̱ꞌ, tacóó so̱ꞌ do̱ꞌ, me rá quiꞌya̱j cacunꞌ, ne̱ táá a̱ se caꞌne̱ꞌ so̱ꞌ man yoꞌ, ga̱a ne̱ se̱ gaa na̱nj caꞌa̱nj so̱ꞌ rihaan yaꞌan quiꞌya̱j yoꞌ ei. Taj se ꞌyaj sese taj va̱j tacóó so̱ꞌ do̱ꞌ, raꞌá so̱ꞌ do̱ꞌ, tza̱j ne̱ caꞌve̱e ca̱yáán so̱ꞌ ga̱ Diose̱ ga̱a̱ ei. Tza̱j ne̱ sese quita̱j raꞌá so̱ꞌ do̱ꞌ, tacóó so̱ꞌ do̱ꞌ, ne̱ quiꞌyaj nij yoꞌ cacunꞌ, ne̱ caꞌa̱nj so̱ꞌ rihaan yaꞌan, quiꞌya̱j nij yoꞌ, ne̱ dan me se yoꞌ me se cu̱nuû so̱ꞌ nu̱ꞌ cavii nu̱ꞌ caꞌanj ei. ");
INSERT INTO trcNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Veé da̱nj uún sese me rá rlij rihaan so̱ꞌ quiꞌya̱j yoꞌ cacunꞌ, ne̱ táá a̱ se quiri̱i̱ so̱ꞌ man yoꞌ, ne̱ síí rihaan canuu̱ ga̱a̱ so̱ꞌ, tza̱j ne̱ caꞌve̱e ca̱yáán so̱ꞌ ga̱ Diose̱ ga̱a̱ ei. Tza̱j ne̱ sese cu̱nuû rlij rihaan so̱ꞌ ne̱ quiꞌyaj yoꞌ cacunꞌ, ne̱ caꞌa̱nj so̱ꞌ rihaan yaꞌan, quiꞌya̱j yoꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","”Cu̱tumé soj man soj se̱ cataj soj se vaa taj yuꞌvee nó yoꞌo̱ tuviꞌ soj síí nica̱ꞌ nimán ei. ꞌO̱ se cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa vaa se‑mo̱zó Réé ꞌu̱nj síí nicu̱nꞌ xta̱ꞌ tumé man ꞌo̱ ꞌo̱ nij soꞌ na̱nj ado̱nj. Ne̱ niga̱nj nicunꞌ nij soꞌ rihaan Réj, ne̱ uno Réj nu̱ꞌ nana̱ nataꞌ nij soꞌ rihaan Réj ei. ");
INSERT INTO trcNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ꞌO̱ se xa̱ꞌ ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱, tza̱j ne̱ caꞌnáꞌ ꞌu̱nj cheꞌé rej ti̱nanii ꞌu̱nj man nij síí caꞌanj niꞌya̱ rihaan sayuun a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","”Tumé Diose̱ man nij síí nica̱ꞌ nimán síí noco̱ꞌ man soꞌ, rá soj naꞌ. Nihánj me cata̱j xnaꞌanj ꞌu̱nj rihaan soj á. Neꞌen soj se vaa sese vaa ꞌo̱ cientó daán yoꞌo̱ soꞌ matzinj, ne̱ sese caꞌa̱nj niꞌya̱ o̱rúnꞌ matzinj yoꞌ, ne̱ ta̱náj síí da̱a̱n matzinj yoꞌ man caꞌa̱nj chiha̱a̱ xnu̱ꞌ caꞌa̱nj matzinj yoꞌ raa̱ quij, ne̱ caꞌa̱nj soꞌ nano̱ꞌ soꞌ matzinj caꞌanj niꞌya̱ yoꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ne̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa sese nari̱ꞌ soꞌ daán soꞌ matzinj, ne̱ gu̱un niha̱ꞌ uxrá rá soꞌ na̱nj ado̱nj. Do̱j tzinꞌ ga̱a̱ niha̱ꞌ rá soꞌ cheꞌé caꞌa̱nj chiha̱a̱ xnu̱ꞌ caꞌa̱nj nij matzinj ne caꞌa̱nj niꞌya̱ a. Tza̱j ne̱ cheꞌé matzinj nariꞌ uún soꞌ doj a̱ ga̱a̱ niha̱ꞌ rá soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Dan me se ase vaa naꞌvej rá soꞌ caꞌa̱nj niꞌya̱ o̱rúnꞌ daán soꞌ matzinj roꞌ, da̱nj vaa naꞌvej rá Rej níꞌ síí nicu̱nꞌ xta̱ꞌ caꞌa̱nj niꞌya̱ a̱ ꞌó síí nica̱ꞌ vaa nimán síí noco̱ꞌ man soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","”Ne̱ sese quiꞌya̱j tinúú so̱ꞌ cacunꞌ rihaan so̱ꞌ, ne̱ caꞌa̱nj o̱rúnꞌ so̱ꞌ rihaan soꞌ, ne̱ cata̱j xnaꞌanj so̱ꞌ rihaan soꞌ cheꞌé cacunꞌ tumé soꞌ á. Ne̱ sese cuno̱ soꞌ rihaan so̱ꞌ, ne̱ dan me se a̱j quiꞌyaj canaán so̱ꞌ, ne̱ yoꞌo̱ canoco̱ꞌ tinúú so̱ꞌ man Diose̱ ga̱ so̱ꞌ vaa ga̱a̱ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tza̱j ne̱ sese ne cuno̱ soꞌ rihaan so̱ꞌ ne̱ ni̱caj so̱ꞌ yoꞌó do̱ꞌ, yavíj do̱ꞌ, tinúú so̱ꞌ caꞌa̱nj so̱ꞌ rihaan tinúú so̱ꞌ síí tumé cacunꞌ yoꞌ, ne̱ nda̱a síj, ga̱a ne̱ canicu̱nꞌ vi̱j vaꞌnu̱j soj si̱j cuno̱ nana̱ caꞌmi̱i̱ soꞌ, ga̱a ne̱ gu̱un ya̱ rá soj a. Sese ꞌo̱ cuya̱a̱n ga̱a̱ nana̱ caꞌmi̱i̱ vi̱j vaꞌnu̱j síí queneꞌen, ne̱ ya̱ vaa nana̱ caꞌmii nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ne̱ sese ne cuno̱ síí tumé cacunꞌ rihaan vi̱j vaꞌnu̱j nij tinu̱j nij soj, ga̱a ne̱ caꞌa̱nj soj nata̱ꞌ soj rihaan taranꞌ nij síí noco̱ꞌ man Diose̱ ya̱nj chiháán soj á. Ne̱ sese ne cuno̱ soꞌ rihaan taranꞌ nij síí noco̱ꞌ man Diose̱, ga̱a ne̱ gu̱un yaníj soj rihaan soꞌ á. Dan me se ase vaa ꞌo̱ síí yaníj do̱ꞌ, ase vaa ꞌo̱ síí tihaꞌ yuꞌunj cheꞌé puextó do̱ꞌ, da̱nj ga̱a̱ soꞌ rihaan soj ei. ");
INSERT INTO trcNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","”Cuano̱ nihánj me cata̱j yá ꞌu̱nj rihaan soj se vaa a̱ me maꞌa̱n rasu̱u̱n se̱ caꞌvee quiꞌya̱j yuvii̱ rá soj, ne̱ veé da̱nj naꞌvej rá Diose̱ quiꞌya̱j yuvii̱ uún a. Ne̱ na̱j guun rasu̱u̱n cata̱j soj se vaa caꞌve̱e quiꞌya̱j yuvii̱, ne̱ veé da̱nj ga̱a̱ quiꞌya̱j yuvii̱, rá maꞌa̱n Diose̱ uún a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Dan me se cata̱j uún ꞌu̱nj rihaan soj, ne̱ sese vaa vi̱j soj me rá cachi̱nj niꞌya̱j rihaan Réj síí nicu̱nꞌ xta̱ꞌ, ne̱ cachi̱nj niꞌya̱j soj se vaa achiin rihaan soj, ne̱ rque̱ soꞌ man soj se vaa achiin man soj a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ése̱ me rej maꞌa̱n nuu chre̱ꞌ ꞌo̱ vi̱j síí noco̱ꞌ manj cachi̱nj niꞌya̱j nij soꞌ, ne̱ veé da̱nj nicu̱nꞌ ma̱ꞌanj ga̱ nij soꞌ a ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ga̱a ne̱ cuchiꞌ síí cuꞌna̱j Pedró rihaan Jesucristó, ne̱ xnáꞌanj soꞌ man soꞌ, cataj soꞌ: ―Me daj nó xcúnj cara̱a̱ xꞌnaj cheꞌé tinúj síí quiꞌyaj chiꞌi̱i̱ manj ga̱. Chi̱j ya̱ cara̱a̱ xꞌnaj naꞌ ―taj Pedró, xnáꞌanj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Ne neꞌen uxrá so̱ꞌ á. ꞌO̱ se na̱j guun cacunꞌ quiꞌyaj tinúú so̱ꞌ, ne̱ yoꞌo̱ cara̱a̱ xꞌnaa niga̱nj so̱ꞌ cheꞌé tinúú so̱ꞌ nu̱ꞌ cavii nu̱ꞌ caꞌanj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Dan me se ase vaa ꞌo̱ síí nica̱j suun rey roꞌ, da̱nj ga̱a̱ Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj ado̱nj. Dan me se síí nica̱j suun rey yoꞌ me se ꞌo̱ güii, ne̱ guun rá soꞌ nachi̱nꞌ soꞌ saꞌanj man nij se‑mo̱zó soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Dan me se guun cheꞌe̱ soꞌ caꞌne̱e̱ soꞌ saꞌanj vaa xcúún, ne̱ asino ya̱a̱n nica̱j nii man ꞌo̱ síí ꞌyaj xcúún queꞌe̱e̱ millón pesó caꞌnaꞌ nii rihaan síí nica̱j suun rey yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ne̱ taj yan va̱j a̱ doj saꞌanj nica̱j síí ꞌyaj xcúún yoꞌ narque̱ soꞌ rihaan rey a̱ maꞌ. Cheꞌé dan cataj xnaꞌanj síí nica̱j suun rey yoꞌ se vaa cane̱ꞌ mozó cane̱ꞌ nica̱ mozó cane̱ꞌ taꞌníí mozó cane̱ꞌ nu̱ꞌ siꞌyaj mozó cane̱ꞌ, ga̱a ne̱ nari̱ꞌ rey se‑saꞌa̱nj rey, taj rey a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ga̱a ne̱ canicunꞌ ru̱j mozó yoꞌ rihaan síí nica̱j suun rey yoꞌ, ne̱ cachíín niꞌya̱j uxrá soꞌ, cataj soꞌ: “Cara̱a̱ xꞌnaa uxrá so̱ꞌ do̱j, ne̱ vaa güii narque̱j cunuda̱nj saꞌanj mán so̱ꞌ, síí chij”, taj se‑mo̱zó soꞌ rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ga̱a ne̱ cunuu ꞌe̱e̱ rá síí nica̱j suun rey niꞌya̱j soꞌ man se‑mo̱zó soꞌ, ne̱ caꞌnéj soꞌ xcúún xráá mozó yoꞌ, ne̱ caꞌneꞌ rá soꞌ, caꞌanj u̱u̱n mozó yoꞌ, quiꞌyaj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","”Veé dan, ga̱a ne̱ curiha̱nj mozó yoꞌ, caꞌanj soꞌ, ga̱a ne̱ nariꞌ tuviꞌ soꞌ ga̱ yoꞌó mozó ꞌyaj suun rcuaꞌa̱a̱n ga̱ soꞌ, ga̱a ne̱ yoꞌó mozó yoꞌ me síí quiꞌyaj xcúún do̱j pesó rihaan mozó caráj xꞌnaa rey a. Ga̱a ne̱ quitaꞌaa soꞌ man tuviꞌ soꞌ mozó yoꞌ, ne̱ cataj soꞌ: “Narque̱ so̱ꞌ nu̱ꞌ se vaa ꞌyaj xcúún so̱ꞌ rihanj cuaj vij”, taj soꞌ rihaan tuviꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ga̱a ne̱ canicunꞌ ru̱j yoꞌó mozó yoꞌ rihaan tuviꞌ soꞌ síí nachinꞌ xcúún yoꞌ, ga̱a ne̱ cataj soꞌ: “Cara̱a̱ xꞌnaa so̱ꞌ, ne̱ vaa güii, ne̱ narque̱j saꞌanj mán so̱ꞌ ei”, taj mozó yoꞌ rihaan tuviꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tza̱j ne̱ ne caꞌve̱j rá soꞌ cara̱a̱ xꞌnaa soꞌ rihaan tuviꞌ soꞌ mozó yoꞌ a̱ maꞌ. Ma̱a̱n se caꞌanj soꞌ, ne̱ caxríj soꞌ tagaꞌ man tuviꞌ soꞌ, ne̱ nda̱a se narque̱ ya̱ tuviꞌ soꞌ nu̱ꞌ se vaa ꞌyaj xcúún yoꞌ rihaan soꞌ, ga̱a ne̱ caꞌne̱ꞌ rá soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","”Veé dan, ga̱a ne̱ queneꞌen yoꞌó nij se‑mo̱zó síí nica̱j suun rey da̱j quiꞌyaj síí caxríj tagaꞌ man tuviꞌ, ne̱ nanó ndoꞌo rá nij soꞌ cheꞌé síí ꞌni̱j tagaꞌ yoꞌ a. Cheꞌé dan cuchiꞌ nij soꞌ rihaan síí nica̱j suun rey yoꞌ, ne̱ nataꞌ nij soꞌ cunuda̱nj rihaan rey a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ga̱a ne̱ caꞌnéé síí nica̱j suun rey yoꞌ nana̱ rihaan mozó caxríj tagaꞌ man tuviꞌ se vaa caꞌna̱ꞌ soꞌ rihaan soꞌ a. Dan me se caꞌnaꞌ soꞌ rihaan rey, ga̱a ne̱ caꞌmii rey rihaan soꞌ a: “Mozó chiꞌi̱i̱ nimán mé so̱ꞌ ei. ꞌU̱nj me se caꞌnéj u̱u̱n ꞌu̱nj xcúún xráá so̱ꞌ, cheꞌé se cachíín ni̱ꞌyáá so̱ꞌ rihanj a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ne̱ ase vaa cunuu ꞌe̱e̱ raj mán so̱ꞌ roꞌ, da̱nj vaa no̱ xcúún so̱ꞌ cunu̱u ꞌe̱e̱ rá so̱ꞌ man tuvíꞌ so̱ꞌ mozó ꞌyaj suun ga̱ so̱ꞌ ado̱nj”, taj soꞌ rihaan se‑mo̱zó soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ga̱a ne̱ caꞌmaan ndoꞌo rá síí nica̱j suun, ne̱ tacuachén síí nica̱j suun man mozó yoꞌ rihaan síí ꞌni̱j raꞌa tagaꞌ, ne̱ naquiꞌyaj naca̱ síí nica̱j suun yoꞌ xcúún xráá mozó, ne̱ cataj xnaꞌanj soꞌ se vaa se̱ curiha̱nj mozó yoꞌ tagaꞌ nda̱a na̱ruꞌvee ya̱ soꞌ nu̱ꞌ se vaa quiꞌyaj xcúún soꞌ, ga̱a ne̱ cu̱riha̱nj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","”Ne̱ ase vaa quiꞌyaj síí nica̱j suun yoꞌ roꞌ, taꞌngaꞌ da̱nj quiꞌya̱j uún Réj síí nicu̱nꞌ xta̱ꞌ cheꞌé soj, sese naꞌvej rá soj cara̱a̱ xꞌnaa soj rihaan tinúú soj na̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ga̱a ne̱ quisíj caꞌmii Jesucristó nana̱ yoꞌ, ga̱a ne̱ curiha̱nj soꞌ estadó Galilea, ne̱ caꞌanj soꞌ nda̱a rne̱j tuꞌva chráá cuꞌna̱j Jordán, nda̱a estadó Judea a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ne̱ canocoꞌ uxrá yuvii̱ man soꞌ, ne̱ nahuun sa̱ꞌ nij síí ranꞌ, quiꞌyaj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ga̱a ne̱ cuchiꞌ do̱j síí fariseo rihaan Jesucristó, ne̱ me rá nij soꞌ cuta̱ꞌ nij soꞌ cacunꞌ xráá Jesucristó cheꞌé nana̱ caꞌmi̱i̱ Jesucristó a. Cheꞌé dan xnáꞌanj nij soꞌ man Jesucristó, cataj nij soꞌ: ―Sese ne chiha̱nꞌ ꞌyaj chana̱ nica̱ yoꞌo̱ snóꞌo, rá snóꞌo yoꞌ, ne̱ no̱ xcúún soꞌ quiriꞌi̱j soꞌ man noꞌ naꞌ ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ga̱a ne̱ cataj Jesucristó: ―A̱j nayaa soj nana̱ no̱ rihaan danj Diose̱ nana̱ taj se vaa asi̱j quiꞌyaj Diose̱ chumii̱, ne̱ quiꞌyaj Diose̱ snóꞌo, ne̱ quiꞌyaj Diose̱ chana̱, ne̱ vi̱j ro̱j soꞌ me yuvii̱, quiꞌyaj Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ne̱ vaa yoꞌó nana̱ taj: “Cheꞌé dan ta̱náj snóꞌo man rej soꞌ do̱ꞌ, man nii soꞌ do̱ꞌ, ne̱ veꞌé naca̱j snóꞌo man chana̱ nica̱ soꞌ, ne̱ ase vaa o̱rúnꞌ yuvii̱ roꞌ, da̱nj ga̱a̱ ro̱j soꞌ ado̱nj”. Da̱nj taj danj Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Dan me se nuveé vi̱j ranꞌ yuvii̱ me ro̱j soꞌ asi̱j xcaj tuviꞌ ro̱j soꞌ a̱ maꞌ. ꞌO̱ se ase vaa o̱rúnꞌ yuvii̱ roꞌ, vaa ro̱j soꞌ na̱nj ado̱nj. Dan me se maꞌa̱n Diose̱ quiꞌyaj xcaj tuviꞌ ro̱j soꞌ, ne̱ cheꞌé dan ne nó xcúún a̱ ꞌó yuvii̱ caꞌne̱ꞌ tanu̱u̱ yuvii̱ man ro̱j soꞌ maꞌ ―taj Jesucristó rihaan nij síí fariseo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ga̱a ne̱ cataj nij síí fariseo: ―Cheꞌé dan, me cheꞌé cataj xnaꞌanj Moisés se vaa na̱xcaj snóꞌo ꞌo̱ yanj cataj xnaꞌanj se vaa quiriꞌíj soꞌ chana̱ nica̱ soꞌ, ne̱ caꞌve̱e quiriꞌi̱j soꞌ man noꞌ ga̱ ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Cheꞌé se nichra̱j ndoꞌo nimán soj roꞌ, cheꞌé dan cataj xnaꞌanj Moisés rihaan soj se vaa na̱xcaj soj yanj yoꞌ, ne̱ quiriꞌi̱j soj nica̱ soj a. Tza̱j ne̱ asi̱j guun cheꞌe̱ Diose̱ quiꞌyaj Diose̱ man yuvii̱, ne̱ ne vaa da̱nj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Cuano̱ nihánj me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa sese ne coto̱j chana̱ nica̱ yoꞌo̱ soꞌ ga̱ yoꞌó chii, ne̱ sese riꞌíj rmaꞌa̱n soꞌ man chana̱ yoꞌ ne̱ xcaj soꞌ man yoꞌó chana̱, ne̱ síí tumé ndoꞌo cacunꞌ me maꞌa̱n soꞌ na̱nj ado̱nj. Veé ase vaa síí cotoj ga̱ na̱j guun chana̱ roꞌ, vaa soꞌ rihaan Diose̱ na̱nj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ga̱a ne̱ cataj nij síí tucuꞌyón se‑na̱na̱ Jesucristó rihaan soꞌ: ―Sese ne nó xcúún snóꞌo quiriꞌi̱j soꞌ man chana̱ nica̱ soꞌ, ne̱ taj cheꞌé xca̱j snóꞌo man chana̱ maꞌ. Ma̱a̱n se sa̱ꞌ doj cavi̱i̱ síí ne̱ u̱u̱n ado̱nj ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ga̱a ne̱ cataj Jesucristó: ―Nuveé tucua̱nj canoco̱ꞌ cunuda̱nj yuvii̱ me nana̱ caꞌmii soj maꞌ. Ma̱a̱n se do̱j vaa nij yuvii̱ canoco̱ꞌ tucuáán yoꞌ, quiꞌya̱j Diose̱ na̱nj ei. ");
INSERT INTO trcNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Dan me se vaa síí asi̱j caꞌngaa soꞌ, da̱nj naꞌvej rá soꞌ xca̱j soꞌ man chana̱, tza̱j ne̱ vaa yoꞌó soꞌ uún, ne̱ ga̱a me soꞌ xnii, ne̱ taꞌa̱j nij síí xco̱j ruva̱a̱ rá ne̱ maꞌa̱n nij soꞌ naquiꞌyaj capuú man taꞌa̱j xnii, ne̱ ga̱a achij xnii, ga̱a ne̱ naꞌvej rá soꞌ xca̱j soꞌ man chana̱ ga̱a̱ a̱ man ado̱nj. Dan me se vaa yoꞌó soꞌ uún, ne̱ caꞌve̱e na̱nj xca̱j soꞌ chana̱, tza̱j ne̱ ma̱a̱n se noco̱ꞌ ndoꞌo soꞌ man Diose̱, ne̱ me ndoꞌo rá soꞌ gu̱un chij Diose̱ rihaan chumii̱ nihánj, ne̱ ꞌyaj suun ndoꞌo soꞌ, ne̱ ne vaa yaꞌnúj rihaan soꞌ xca̱j soꞌ chana̱, rá soꞌ, ga̱a ne̱ cheꞌé dan naꞌvej ina̱nj rá maꞌa̱n soꞌ xca̱j soꞌ chana̱ a̱ man ado̱nj. Sese gu̱un nucua̱j yoꞌo̱ soꞌ canoco̱ꞌ soꞌ tucuáán yoꞌ, ne̱ veꞌé canoco̱ꞌ soꞌ tucuáán yoꞌ na̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ga̱a ne̱ nica̱j nij yuvii̱ man nij neꞌej caꞌnaꞌ nij yuvii̱ rihaan Jesucristó a. Me rá nij yuvii̱ cuta̱ꞌ Jesucristó raꞌa soꞌ raa̱ nij neꞌej, ne̱ cachi̱nj niꞌya̱j soꞌ rihaan Diose̱ cheꞌé nij neꞌej yoꞌ a. Tza̱j ne̱ cataj xnaꞌanj nij síí tucuꞌyón se‑na̱na̱ Jesucristó rihaan nij yuvii̱ se vaa ne nó xcúún nij neꞌej caꞌna̱ꞌ nij neꞌej rihaan Jesucristó, taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tza̱j ne̱ cataj Jesucristó: ―Caꞌne̱ꞌ rá soj caꞌna̱ꞌ nij neꞌej rihanj á. Se̱ caráán soj chrej rihaan nij neꞌej mei. ꞌO̱ se tucua̱ nij síí vaa da̱nj roꞌ, me rej ya̱nj Diose̱ uun chij Diose̱ na̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ga̱a ne̱ cutaꞌ soꞌ raꞌa soꞌ raa̱ nij neꞌej, ga̱a ne̱ curiha̱nj soꞌ rej yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Dan me se cuchiꞌ yoꞌo̱ síí tachru̱u̱ yoꞌ rihaan Jesucristó, ne̱ xnáꞌanj soꞌ man Jesucristó, cataj soꞌ: ―Me suun sa̱ꞌ quiꞌya̱j sunj, ne̱ caꞌve̱e ca̱yánj ga̱ Diose̱ nu̱ꞌ cavii nu̱ꞌ caꞌanj, ga̱ maestroꞌ ―taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ga̱a ne̱ cataj Jesucristó: ―Me cheꞌé xnáꞌanj so̱ꞌ manj cheꞌé se sa̱ꞌ ga̱. ꞌO̱ se o̱rúnꞌ Diose̱ vaa sa̱ꞌ á. Tza̱j ne̱ sese me rá so̱ꞌ ca̱yáán so̱ꞌ ga̱ Diose̱ nu̱ꞌ cavii nu̱ꞌ caꞌanj, ne̱ cu̱nó so̱ꞌ nij nana̱ noco̱o ya̱ ya̱ nana̱ cataj xnaꞌanj Diose̱ rihaan níꞌ á ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","―Me nana̱ ga̱ ―taj síí tachru̱u̱ yoꞌ, xnáꞌanj soꞌ man Jesucristó a. Ga̱a ne̱ cataj Jesucristó: ―Nana̱ nihánj a: “Se̱ ticavíꞌ so̱ꞌ yuvii̱ maꞌ. Se̱ cotoj so̱ꞌ ga̱ chana̱ nica̱ yoꞌó yuvii̱ maꞌ. Se̱ quiꞌyaj itu̱u̱ so̱ꞌ siꞌyaj yoꞌó yuvii̱ maꞌ. Se̱ nanó so̱ꞌ cuentó ne̱ cheꞌé yuvii̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Cara̱a̱ co̱chróó so̱ꞌ rihaan réé so̱ꞌ do̱ꞌ, rihaan nií so̱ꞌ do̱ꞌ á. Ase vaa ꞌe̱e̱ rá so̱ꞌ man ma̱ꞌán so̱ꞌ roꞌ, da̱nj ga̱a̱ ꞌe̱e̱ rá so̱ꞌ man tuvíꞌ so̱ꞌ á.” Yoꞌ me nana̱ cu̱nó so̱ꞌ ei ―taj Jesucristó rihaan síí tachru̱u̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","―Nu̱ꞌ nana̱ yoꞌ unoj ado̱nj. Vaa yoꞌó se vaa achiin qui̱ꞌyáj naꞌ ―taj síí tachru̱u̱ yoꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Sese me rá so̱ꞌ cunu̱u sa̱ꞌ ina̱nj nimán so̱ꞌ, ne̱ cavi̱i̱ so̱ꞌ caꞌa̱nj so̱ꞌ, ne̱ cutuꞌve̱e̱ so̱ꞌ nu̱ꞌ siꞌyáá so̱ꞌ, ne̱ saꞌanj quiri̱ꞌ so̱ꞌ roꞌ, caxri̱i̱ so̱ꞌ ston nij síí nique̱, ne̱ cuma̱n ndoꞌo siꞌyáá so̱ꞌ rej xta̱ꞌ, quiꞌya̱j Diose̱ na̱nj ei. Ne̱ dan me se caꞌna̱ꞌ so̱ꞌ, ne̱ ca̱nocóꞌ so̱ꞌ manj, caꞌa̱nj níꞌ á ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Dan me se cuno síí tachru̱u̱ yoꞌ nana̱ cataj xnaꞌanj Jesucristó rihaan soꞌ, ne̱ caꞌanj u̱u̱n soꞌ, ne̱ nanó ndoꞌo rá soꞌ a. ꞌO̱ se síí ruꞌvee me soꞌ, ne̱ vaa ndoꞌo siꞌyaj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ga̱a ne̱ caꞌmii Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ, cataj soꞌ: ―Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa sayu̱u̱n uxrá vaa quisi̱j síí ruꞌvee ca̱yáán síí ruꞌvee ga̱ Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Dan me se neꞌen soj se vaa sayu̱u̱n ndoꞌo vaa cache̱n xcuu camelló rihaan yuꞌuj ta̱j tacúún cúú nuvá, tza̱j ne̱ cuano̱ nihánj me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa caꞌve̱e a̱ doj cache̱n xcuu yoꞌ yuꞌuj ta̱j tacúún cúú nuvá, nda̱a rá se vaa síí ruꞌvee, ne̱ se̱ guun cache̱n soꞌ ca̱yáán soꞌ ga̱ Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj a̱ maꞌ ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Dan me se cuno nij síí tucuꞌyón se‑na̱na̱ Jesucristó nana̱ caꞌmii soꞌ, ne̱ caráyaꞌa̱nj uxrá nij soꞌ, cataj nij soꞌ: ―Cheꞌé dan me se me síí gu̱un nucua̱j quinani̱i̱ rihaan sayuun ga̱ ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Niꞌya̱j Jesucristó man nij soꞌ, ne̱ cataj soꞌ: ―Se̱ guun nucua̱j yuvii̱ quinani̱i̱ maꞌa̱n nij yuvii̱ rihaan sayuun maꞌ. Sayu̱u̱n uxrá vaa rihaan nij soꞌ na̱nj ado̱nj. Tza̱j ne̱ xa̱ꞌ Diose̱ me se ne sayu̱u̱n a̱ doj vaa rihaan soꞌ a̱ maꞌ. Canó rasu̱u̱n caꞌve̱e quiꞌya̱j soꞌ na̱nj ado̱nj ―taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ga̱a ne̱ cataj Pedró rihaan Jesucristó a: ―Ne̱ núj ga̱. A̱j tanáj núj nu̱ꞌ siꞌyaj núj, ne̱ canocoꞌ núj mán so̱ꞌ á. Da̱j quira̱nꞌ núj ga̱ ―taj Pedró, xnáꞌanj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ga̱a ne̱ cataj Jesucristó: ―Veé síí noco̱ꞌ manj me soj, ne̱ síí caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ mej ado̱nj. Ne̱ ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa asa̱ꞌ cunuu naca̱ chumii̱ nihánj, ne̱ asa̱ꞌ guun cheꞌe̱j cayánj gunj síí rii taꞌngaꞌ rihaan chumii̱ nihánj, ne̱ ca̱yáán chuvi̱j nij soj caꞌne̱ꞌ soj cacunꞌ cheꞌé chuvi̱j nij xꞌneꞌ nij yuvii̱ israelitá ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ne̱ síí tanáj veꞌ tucuá tanáj tinúú tanáj raꞌvij tanáj rej tanáj nii tanáj taꞌníí tanáj yoꞌóó tanáj canoco̱ꞌ soꞌ manj roꞌ, uxrá doj rasu̱u̱n quiri̱ꞌ uún soꞌ, ne̱ ca̱yáán soꞌ ga̱ Diose̱ nu̱ꞌ cavii nu̱ꞌ caꞌanj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tza̱j ne̱ queꞌe̱e̱ nij síí guun chij ndoꞌo rihaan chumii̱ nihánj roꞌ, gu̱un nij soꞌ síí noco̱ꞌ ei. Ne̱ queꞌe̱e̱ nij síí ne gu̱un chij rihaan chumii̱ nihánj me se gu̱un chij nij soꞌ, quiꞌya̱j Diose̱ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","”Ase vaa quiꞌyaj ꞌo̱ síí toꞌo̱j rej ma̱n ndoꞌo coj chruj uvá roꞌ, da̱nj quiꞌya̱j Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj ado̱nj. Dan me se síí toꞌo̱j yoꞌ roꞌ, rej taxre̱j curiha̱nj soꞌ nano̱ꞌ soꞌ síí quiꞌya̱j suun rihaan toꞌóó soꞌ rej ma̱n coj chruj uvá yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ga̱a ne̱ yoꞌo̱ caꞌmii soꞌ ga̱ nij síí quiꞌya̱j suun rihaan toꞌóó soꞌ, se vaa ꞌo̱ saꞌanj denario go̱ꞌ soꞌ cheꞌé suun quiꞌya̱j suun ꞌo̱ ꞌo̱ nij soꞌ ꞌo̱ güii, ne̱ caꞌnéé soꞌ man nij soꞌ, quiꞌya̱j suun nij soꞌ rihaan toꞌóó soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","”Ga̱a ne̱ agaꞌ u̱u̱n curiha̱nj uún síí toꞌo̱j yoꞌ, caꞌanj soꞌ rihaan yuꞌvee, ga̱a ne̱ queneꞌen soꞌ doj snóꞌo nicu̱nꞌ maꞌa̱n u̱u̱n rihaan yuꞌvee, ne̱ taj va̱j suun rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ga̱a ne̱ cataj soꞌ rihaan nij soꞌ: “Caꞌa̱nj soj quiꞌya̱j suun soj rihaan toꞌój ei. Na̱ruꞌvee ꞌu̱nj rihaan soj cheꞌé nu̱ꞌ suun quiꞌya̱j suun soj ei”, taj soꞌ rihaan nij mozó a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Dan me se caꞌanj nij snóꞌo yoꞌ quiꞌyaj suun nij soꞌ uún toꞌóó síí toꞌo̱j yoꞌ a. ”Ga̱a ne̱ caxu̱j do̱ꞌ, agaꞌ vaꞌnu̱j do̱ꞌ, curiha̱nj uún síí toꞌo̱j yoꞌ, ne̱ nariꞌ soꞌ doj síí quiꞌya̱j suun rihaan toꞌóó soꞌ, ne̱ caꞌnéé soꞌ man nij soꞌ quiꞌya̱j suun nij soꞌ rihaan toꞌóó soꞌ uún a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","”Ga̱a ne̱ agaꞌ ꞌu̱nꞌ curiha̱nj uún síí toꞌo̱j yoꞌ, ne̱ nariꞌ soꞌ doj síí nicu̱nꞌ maꞌa̱n rihaan yuꞌvee a. “Me cheꞌé nicunꞌ maꞌa̱n soj nu̱ꞌ güii nihánj ga̱. Taj va̱j suun quiꞌyaj suun soj á”, taj soꞌ, xnáꞌanj soꞌ man nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ma̱a̱n se taj síí rqué suun man núj quiꞌya̱j suun núj maꞌ”, taj nij soꞌ a. “Caꞌa̱nj soj quiꞌya̱j suun soj rihaan toꞌój ei”, taj soꞌ rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","”Veé dan, ga̱a ne̱ nichru̱nꞌ cata̱ꞌ güii tuꞌva quij, ga̱a ne̱ caꞌneꞌ síí toꞌo̱j yoꞌ suun rihaan se‑mo̱zó soꞌ síí tumé saꞌanj se vaa na̱ruꞌvee soꞌ saꞌanj rihaan nij síí quiꞌyaj suun rihaan toꞌóó soꞌ yoꞌ a. “Canacu̱nj so̱ꞌ caꞌna̱ꞌ nij síí quiꞌyaj suun yoꞌ, ne̱ na̱ruꞌvee so̱ꞌ rihaan nij soꞌ á. Asino ya̱a̱n na̱ruꞌvee so̱ꞌ rihaan nij síí catúj suun agaꞌ ꞌu̱nꞌ, ga̱a ne̱ na̱ruꞌvee so̱ꞌ rihaan nij síí catúj suun rej naꞌya̱a̱n á”, taj soꞌ rihaan síí tumé saꞌanj yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","”Dan me se asino ya̱a̱n caꞌnaꞌ nij síí catúj naa̱ agaꞌ ꞌu̱nꞌ rihaan síí tumé saꞌanj, ne̱ ꞌo̱ saꞌanj denario quiriꞌ ꞌo̱ ꞌo̱ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ga̱a ne̱ caꞌnaꞌ nij síí catúj suun rej naꞌya̱a̱n rihaan síí tumé saꞌanj yoꞌ a. Noco̱o doj saꞌanj quiri̱ꞌ nij soꞌ, rá nij soꞌ, tza̱j ne̱ veé da̱nj ꞌo̱ saꞌanj denario quiriꞌ ꞌo̱ ꞌo̱ nij soꞌ uún a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nica̱j nij soꞌ saꞌanj, ga̱a ne̱ guun cheꞌe̱ nij soꞌ caꞌmaan rá nij soꞌ niꞌya̱j nij soꞌ síí toꞌo̱j yoꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ga̱a ne̱ cataj nij soꞌ: “Síí nihánj me se o̱rúnꞌ orá gue̱e̱ quiꞌyaj suun nij soꞌ, tza̱j ne̱ ꞌo̱ cuya̱a̱n naruꞌvee so̱ꞌ rihaan nij soꞌ ga̱ núj, ne̱ quiꞌyaj suun núj nu̱ꞌ güii, ne̱ goꞌ uxrá naán xráá núj á”, taj nij soꞌ rihaan síí toꞌo̱j yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ga̱a ne̱ síí toꞌo̱j yoꞌ cataj rihaan yoꞌo̱ tuviꞌ nij mozó: “Ne ta̱ꞌyunj mán so̱ꞌ, man tinu̱j. Ma̱a̱n se a̱j caꞌmii níꞌ cheꞌé se vaa quiꞌya̱j suun so̱ꞌ cheꞌé ꞌo̱ saꞌanj denario cheꞌé ꞌo̱ güii a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Naca̱j so̱ꞌ saꞌanj quiꞌyaj canaán so̱ꞌ, caꞌa̱nj so̱ꞌ á. Ma̱a̱n se ina̱nj me raj cuya̱a̱n na̱ruꞌvej rihaan soj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ne nó xcúnj qui̱ꞌyáj se vaa rii nimanj, rá so̱ꞌ naꞌ. Xco̱j ruva̱a̱ rá so̱ꞌ, cheꞌé se quiꞌyáj se lu̱j rihaan tuvíꞌ so̱ꞌ naꞌ”, taj síí toꞌo̱j yoꞌ rihaan síí quiꞌyaj suun rihaan toꞌóó soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","”Dan me se ase vaa quiꞌyaj síí toꞌo̱j yoꞌ roꞌ, da̱nj quiꞌya̱j uún Diose̱ cheꞌé nij síí ꞌyaj suun cheꞌé Diose̱ na̱nj ado̱nj. Cheꞌé dan nij síí ne gu̱un chij rihaan chumii̱ nihánj me se xta̱ꞌ roꞌ, gu̱un chij nij soꞌ a. Ne̱ nij síí guun chij ndoꞌo rihaan chumii̱ nihánj me se xta̱ꞌ roꞌ, gu̱un nij soꞌ síí noco̱ꞌ, quiꞌya̱j Diose̱ na̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ga̱a ne̱ cavii Jesucristó caꞌanj soꞌ chumanꞌ Jerusalén, ne̱ caꞌanj chuvi̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ ga̱ soꞌ, quiꞌyaj soꞌ a. Veé asi̱j va̱j o̱rúnꞌ chaꞌnu̱j nij soꞌ ga̱ Jesucristó chrej, ne̱ caꞌmii Jesucristó rihaan nij soꞌ, cataj soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Nihánj me caꞌanj níꞌ chumanꞌ Jerusalén, ne̱ qui̱taꞌaa nii manj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱, ne̱ nago̱ꞌ nii manj rihaan nij xrej ata̱ suun noco̱o doj do̱ꞌ, rihaan nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ a. Ne̱ cuta̱ꞌ nij soꞌ cacunꞌ xráj, ne̱ cata̱j nij soꞌ se vaa cavi̱ꞌ ꞌu̱nj a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ga̱a ne̱ nago̱ꞌ nij soꞌ manj rihaan nij síí yaníj, ne̱ caꞌnga̱ꞌ naco̱o̱ nij síí yaníj queneꞌe̱n nij soꞌ manj, ne̱ go̱ꞌ nij soꞌ cuartá xráj, ne̱ cachro̱n nij soꞌ manj rihaan rcutze̱ a. Ga̱a ne̱ cache̱n vaꞌnu̱j güii, ga̱a ne̱ cunu̱u iꞌna̱ꞌ uún ꞌu̱nj, quiꞌya̱j Diose̱ ei ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ga̱a ne̱ cuchiꞌ nii síí cuꞌna̱j Jacobo do̱ꞌ, síí cuꞌna̱j Juan do̱ꞌ, rihaan Jesucristó, ne̱ taꞌníí síí cuꞌna̱j Zebedeo me uún ro̱j soꞌ a. Dan me se cuchiꞌ nij taꞌni̱j noꞌ rihaan Jesucristó, ga̱a ne̱ canicunꞌ ru̱j noꞌ rihaan Jesucristó, ne̱ cataj noꞌ se vaa vaa se cachi̱nj niꞌya̱j noꞌ rihaan soꞌ, rá noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","―Me se achiin mán so̱ꞌ ga̱ ―taj Jesucristó, xnáꞌanj soꞌ man noꞌ a. Ne̱ cataj noꞌ: ―Cata̱j xnaꞌanj so̱ꞌ se vaa asa̱ꞌ guun chij so̱ꞌ rihaan chumii̱ nihánj, ne̱ quita̱j ro̱j taꞌníj xꞌnúú so̱ꞌ, ne̱ ca̱ta̱ ro̱j soꞌ suun sa̱ꞌ doj qui̱ꞌyáá so̱ꞌ á. Dan me se yoꞌo̱ soꞌ ca̱yáán rej nuva̱ꞌ so̱ꞌ, ne̱ yoꞌó soꞌ ca̱yáán rej ni̱chruún so̱ꞌ, ne̱ quiri̱i̱ taꞌngaꞌ ro̱j soꞌ ga̱ so̱ꞌ, cata̱j so̱ꞌ, raj a ―taj chana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ga̱a ne̱ cataj Jesucristó rihaan ro̱j tinu̱j ro̱j soꞌ a: ―Ne neꞌen ro̱j so̱j me rasu̱u̱n cachíín niꞌya̱j ro̱j so̱j rihanj nihánj a̱ maꞌ. ꞌO̱ se gu̱un nucua̱j ro̱j so̱j quira̱nꞌ ro̱j so̱j sayuun nda̱a vaa qui̱ránꞌ ꞌu̱nj naꞌ ―taj Jesucristó, xnáꞌanj soꞌ a. ―Gu̱un nucua̱j rój na̱nj ado̱nj ―taj ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ga̱a ne̱ cataj Jesucristó: ―Ya̱ ya̱ quira̱nꞌ soj sayuun ga̱j na̱nj á. Tza̱j ne̱ ne nó xcúnj cata̱j xnaꞌanj ꞌu̱nj me síí ca̱yáán xꞌnúú ꞌu̱nj rej nuva̱ꞌ ꞌu̱nj do̱ꞌ, rej ni̱chrunj do̱ꞌ, maꞌ. O̱rúnꞌ Réj síí nicu̱nꞌ xta̱ꞌ cata̱j xnaꞌanj me síí quiri̱i̱ taꞌngaꞌ ga̱j na̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ga̱a ne̱ cuno yoꞌó chi̱ꞌ nij síí tucuꞌyón se‑na̱na̱ Jesucristó se vaa caꞌmii ro̱j tinu̱j ro̱j soꞌ rihaan Jesucristó, ne̱ caꞌmaan rá nij soꞌ niꞌya̱j nij soꞌ man ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ga̱a ne̱ canacúún Jesucristó man cunuda̱nj nij soꞌ se vaa caꞌna̱ꞌ nij soꞌ rihaan soꞌ, ne̱ cataj soꞌ: ―Neꞌen soj se vaa nij síí ata̱ suun ma̱n rihaan chumii̱ nihánj me se rii taꞌngaꞌ uxrá nij soꞌ rihaan tuviꞌ nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tza̱j ne̱ se̱ gaa da̱nj scaꞌnúj nij soj a̱ maꞌ. ꞌO̱ se sese me rá nij soj gu̱un chij nij soj rihaan tuviꞌ nij soj, ne̱ gu̱un nij soj síí quiꞌya̱j suun rihaan taranꞌ tuviꞌ nij soj, ");
INSERT INTO trcNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ne̱ ase vaa mozó roꞌ, da̱nj ga̱a̱ xa̱ꞌ nij soj rihaan taranꞌ tuviꞌ nij soj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Dan me se caꞌnéé Diose̱ manj ni̱caj yuꞌunj ꞌu̱nj man yuvii̱, tza̱j ne̱ ne caꞌna̱ꞌ ꞌu̱nj ne̱ gu̱un nij yuvii̱ mozó rihanj maꞌ. ꞌO̱ se caꞌnáꞌ ꞌu̱nj quiꞌya̱j suun ma̱ꞌanj rihaan nij yuvii̱ na̱nj ado̱nj. Ne̱ caꞌnáꞌ ꞌu̱nj nayo̱n ma̱ꞌanj rihaan yuvii̱ ne̱ cavi̱ꞌ ꞌu̱nj cheꞌé cacunꞌ ata̱ nij soꞌ, ga̱a ne̱ cavi̱i̱ sa̱ꞌ uxrá nij soꞌ, qui̱ꞌyáj na̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ga̱a ne̱ cavii nij soꞌ chumanꞌ Jericó, ne̱ cachéé ndoꞌo yuvii̱ xcó Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ne̱ vaa vi̱j síí tuchri̱i ne̱ tuꞌva chrej, ne̱ cuno ro̱j soꞌ cuentó se vaa cache̱n Jesucristó rej ne̱ ro̱j soꞌ a. Cheꞌé dan caguáj ro̱j soꞌ, cataj ro̱j soꞌ: ―Ya̱ ya̱ taꞌníí taꞌnij siꞌno̱ síí cuꞌna̱j David síí cane ga̱a naá mé so̱ꞌ, Señor. Cunu̱u ꞌe̱e̱ rá so̱ꞌ man rój ei ―taj ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tza̱j ne̱: ―Dínj tuꞌva ro̱j so̱j á ―taj nij yuvii̱ rihaan ro̱j soꞌ a. Tza̱j ne̱ doj a̱ nucua̱j caguáj ro̱j soꞌ, cataj ro̱j soꞌ: ―Taꞌníí taꞌnij siꞌno̱ síí cuꞌna̱j David síí cane ga̱a naá mé so̱ꞌ, Señor. Cunu̱u ꞌe̱e̱ rá so̱ꞌ man rój ei ―taj uún ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ga̱a ne̱ canicunꞌ Jesucristó, ne̱ canacúún Jesucristó man ro̱j soꞌ se vaa caꞌna̱ꞌ ro̱j soꞌ rihaan soꞌ, ne̱ cataj soꞌ: ―Da̱j qui̱ꞌyáj man ro̱j so̱j, rá ro̱j so̱j ga̱ ―taj Jesucristó, xnáꞌanj soꞌ man ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","―Cunu̱u sa̱ꞌ rihaan rój, rá rój, Señor ―cataj ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ga̱a ne̱ cunuu ꞌe̱e̱ rá Jesucristó man ro̱j soꞌ, ne̱ cutaꞌ Jesucristó raꞌa Jesucristó rihaan ro̱j soꞌ, ga̱a ne̱ veé ma̱a̱n orá dan cunuu sa̱ꞌ rihaan ro̱j soꞌ na̱nj ado̱nj. Ga̱a ne̱ caꞌanj ro̱j soꞌ ga̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ga̱a ne̱ cuchiꞌ Jesucristó cuchiꞌ nij síí tucuꞌyón se‑na̱na̱ soꞌ cuchiꞌ tuꞌva chumanꞌ cuꞌna̱j Betfagé a. Na̱j chumanꞌ yoꞌ tacóó quij cuꞌna̱j Quij ma̱n Chruun Olivó, ne̱ nichru̱nꞌ naj chumanꞌ Jerusalén ga̱ chumanꞌ cuꞌna̱j Betfagé yoꞌ a. Ga̱a ne̱ caꞌnéé Jesucristó man vi̱j tuviꞌ nij síí tucuꞌyón se‑na̱na̱ soꞌ caꞌa̱nj ro̱j soꞌ rque chumanꞌ yoꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ne̱ cataj soꞌ rihaan ro̱j soꞌ a: ―Catu̱u̱ ro̱j so̱j chumanꞌ nihánj, chumanꞌ na̱j rihaan níꞌ, ne̱ nari̱ꞌ nu̱ꞌ ro̱j so̱j yoꞌo̱ burró cha̱na̱ numi̱i, ne̱ vaa taꞌníí xoꞌ burró leꞌe̱j yaꞌa̱nj nicu̱nꞌ ga̱ xoꞌ ado̱nj. Nache̱ ro̱j so̱j man burró cha̱na̱ yoꞌ, ne̱ ni̱caj ro̱j so̱j man ro̱j xoꞌ caꞌna̱ꞌ ro̱j so̱j rihaan ꞌu̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ne̱ sese xna̱ꞌanj nii man ro̱j so̱j me cheꞌé nache ro̱j so̱j burró, ne̱ cata̱j ro̱j so̱j: “Síí ꞌni̱j raꞌa man níꞌ achiin xcuu nihánj rihaan chugua̱nj”, cata̱j ro̱j so̱j, ga̱a ne̱ nu̱ꞌ caꞌne̱j nij soꞌ man ro̱j xcuu caꞌna̱ꞌ ro̱j xcuu ga̱ ro̱j so̱j ei ―taj Jesucristó rihaan ro̱j so̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dan me se nu̱ꞌ yoꞌ quiꞌyaj Jesucristó, quiꞌyaj gue̱e̱ soꞌ nda̱a vaa taj síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá a. Ne̱ síí nataꞌ yoꞌ roꞌ, cataj soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Dan me se cata̱j xnaꞌanj soj rihaan nij síí ma̱n chumanꞌ Jerusalén se vaa xca̱j nij soꞌ cuentá se vaa caꞌna̱ꞌ síí gu̱un chij rihaan nij soꞌ ado̱nj. Dan me se síí nica̱ꞌ nimán me soꞌ, quita̱j soꞌ xráá burró a. Dan me se quita̱j soꞌ xráá taꞌníí xcuu ꞌyaj suun na̱nj ado̱nj”, taj síí nataꞌ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Dan me se caꞌanj ro̱j síí tucuꞌyón se‑na̱na̱ Jesucristó, ne̱ quiꞌyaj ro̱j soꞌ nu̱ꞌ nda̱a vaa cataj xnaꞌanj Jesucristó rihaan ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Dan me se nica̱j ro̱j soꞌ man ro̱j taꞌni̱j ro̱j burró cha̱na̱ yoꞌ caꞌanj ro̱j soꞌ rihaan Jesucristó, ne̱ cutaꞌ ro̱j soꞌ yatzíj xráá ro̱j xcuu, ne̱ cavii Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ne̱ queꞌe̱e̱ nij yuvii̱ cuchruj yatzíj saga̱nꞌ nij yuvii̱ rá chrej, ne̱ taꞌa̱j nij tuviꞌ nij soꞌ roꞌ, caꞌneꞌ raꞌa chruun, ne̱ caraa nij soꞌ rá chrej, cache̱e̱ ro̱j burró yoꞌ rihaan yatzíj do̱ꞌ, rihaan raꞌa chruun do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ne̱ ma̱n uxrá yuvii̱ quitáá ya̱a̱n rihaan Jesucristó, ne̱ ma̱n uxrá yuvii̱ noco̱ꞌ rej xco̱ Jesucristó a. Ne̱ caguáj nij yuvii̱, cataj nij yuvii̱: ―Cara̱a̱ gue̱e̱ níꞌ rihaan taꞌníí taꞌnij siꞌno̱ síí cuꞌna̱j David síí cane ga̱a naá na̱nj á. Cuna̱j ndoꞌo vaa caꞌnaꞌ síí caꞌnéé síí ꞌni̱j raꞌa man níꞌ ado̱nj. Se lu̱j ndoꞌo me ꞌyaj Diose̱ cheꞌé níꞌ á. Cara̱a̱ gue̱e̱ níꞌ rihaan Diose̱ síí nicu̱nꞌ xta̱ꞌ ei ―taj nij yuvii̱, caguáj nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Dan me se catúj Jesucristó chumanꞌ Jerusalén, ne̱ caráyaꞌa̱nj taranꞌ nij yuvii̱ ma̱n chumanꞌ yoꞌ, ne̱ cataj nij soꞌ: ―Me síí atúj chumanꞌ ga̱ ―cataj nij síí ma̱n chumanꞌ Jerusalén, xnáꞌanj nij soꞌ man nij yuvii̱ atúj chumanꞌ Jerusalén a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","―Síí nihánj me Jesucristó síí cavii chumanꞌ Nazaret chumanꞌ na̱j estadó Galilea, ne̱ síí nataꞌ se‑na̱na̱ Diose̱ me soꞌ ado̱nj ―taj nij yuvii̱ catúj chumanꞌ Jerusalén, niꞌya̱j nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ga̱a ne̱ catúj Jesucristó rá nuvií noco̱o, ga̱a ne̱ quirii soꞌ man taranꞌ nij síí tuꞌvéj rasu̱u̱n do̱ꞌ, man taranꞌ nij síí quiránj rasu̱u̱n ma̱n rá nuvií do̱ꞌ a. Ne̱ tiguíj raꞌa soꞌ nij chruun mesá natuná nii saꞌanj rihaan, ne̱ tiguíj raꞌa soꞌ chruun xlá ta̱j nij síí tuꞌvéj chaꞌaa̱n a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ga̱a ne̱ caꞌmii soꞌ rihaan nij soꞌ, cataj soꞌ: ―Danj Diose̱ taj se vaa tucuá Diose̱ rej naꞌvíj yuvii̱ rihaan Diose̱ me nihánj á. Tza̱j ne̱ guun tucua̱ síí itu̱u̱ man tucuá Diose̱ nihánj, quiꞌyaj soj na̱nj á ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ga̱a ne̱ catúj síí tuchri̱i catúj síí rengo̱ catúj rá nuvií, ne̱ nahuun sa̱ꞌ nij soꞌ, quiꞌyaj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ne̱ ma̱n xnii catúj rá nuvií, ne̱ caguáj nij xnii cataj nij xnii: ―Cara̱a̱ gue̱e̱ níꞌ rihaan síí nihánj taꞌníí taꞌnij siꞌno̱ síí cuꞌna̱j David síí cane ga̱a naá ei ―taj nij xnii a. Ne̱ vaa xrej ata̱ suun noco̱o doj vaa síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés vaa, ne̱ queneꞌen nij soꞌ nu̱ꞌ suun sa̱ꞌ quiꞌyaj Jesucristó rá nuvií, ne̱ cuno nij soꞌ nana̱ caguáj nij xnii a. Ga̱a ne̱ caꞌmaan rá nij soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ne̱ cataj nij soꞌ: ―Unó so̱ꞌ nana̱ aguáj xnii nihánj naꞌ. Me cheꞌé aꞌvej so̱ꞌ cagua̱j xnii da̱nj ga̱ ―taj nij soꞌ, xnáꞌanj nij soꞌ man Jesucristó a. Ne̱ cataj Jesucristó: ―Unó ꞌu̱nj ei. Me cheꞌé naꞌvej rá nij soj caꞌmi̱i̱ xnii da̱nj ga̱. Ne̱ ni̱ꞌyaj soj, ne̱ Diose̱ caꞌnéé nana̱ vaa da̱nj nimán xnii caꞌmi̱i̱ xnii da̱nj a. Me cheꞌé ne naya̱a̱ nij soj nana̱ no̱ rihaan danj Diose̱ ga̱. Ése̱ ga̱a naá, ne̱ caꞌmii yoꞌo̱ soꞌ rihaan Diose̱, cataj soꞌ se vaa veꞌé caꞌmii xnii do̱ꞌ, veꞌé caꞌmii neꞌej utzii too do̱ꞌ, rihaan Diose̱, quiꞌyaj maꞌa̱n Diose̱, taj nana̱ no̱ rihaan danj Diose̱ a ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ga̱a ne̱ tanáj Jesucristó man nij soꞌ, ne̱ curiha̱nj soꞌ chumanꞌ Jerusalén, ne̱ caꞌanj soꞌ chumanꞌ Betania, ne̱ caranꞌ soꞌ ꞌo̱ yanꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Rej ranga̱ꞌ cavii uún Jesucristó caꞌanj soꞌ chumanꞌ Jerusalén, ne̱ naꞌaan rque soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ga̱a ne̱ queneꞌen soꞌ ꞌo̱ chruun ma̱n chruj higó nicu̱nꞌ tuꞌva chrej, ne̱ caꞌanj soꞌ tacóó chruun yoꞌ, tza̱j ne̱ taj va̱j a̱ ꞌó chruj higó ne quiri̱ꞌ soꞌ a̱ maꞌ. Ma̱a̱n na̱nj coj u̱u̱n táá raa̱ chruun yoꞌ a. Ga̱a ne̱ caꞌmii soꞌ rihaan chruun yoꞌ, cataj soꞌ: ―Daj chiha̱a̱ míj se̱ cumán chruj raá so̱ꞌ maꞌ ―taj Jesucristó a. Ne̱ nu̱ꞌ caꞌmii soꞌ ga̱ chruun, ne̱ ma̱a̱n orá dan canacoo̱ chruun ma̱n chruj higó yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ga̱a ne̱ caráyaꞌa̱nj nij síí tucuꞌyón se‑na̱na̱ Jesucristó, queneꞌen nij soꞌ se vaa quiranꞌ chruun yoꞌ a. Ne̱ cataj nij soꞌ: ―Asa̱ꞌ caꞌvee nu̱ꞌ nacoo̱ chruun nihánj cuano̱ ga̱ ―taj nij soꞌ, caráyaꞌa̱nj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa sese se̱ guun vi̱j rá soj ne̱ yoꞌo̱ cuchuma̱n rá soj, ne̱ doj a̱ quiꞌya̱j soj vaa güii, se vaa quiꞌyáá ꞌu̱nj man chruun nihánj a̱ ado̱nj. Dan me se cata̱j xnaꞌanj nij soj rihaan quij xca̱a̱n yoꞌ se vaa cu̱riha̱nj quij rej nicu̱nꞌ quij ne̱ caꞌa̱nj ni̱j quij rque na yaꞌa̱nj, ne̱ ya̱ caꞌa̱nj ni̱j yoꞌ rque na yaꞌa̱nj, quiꞌya̱j soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ne̱ nu̱ꞌ se vaa cachi̱nj niꞌya̱j soj rihaan Diose̱ roꞌ, rque̱ Diose̱ rihaan soj, sese ya̱ ya̱ cuchuma̱n rá soj na̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ga̱a ne̱ catúj Jesucristó rá nuvií, ne̱ tucuꞌyón soꞌ nana̱ man nij síí ma̱n rá nuvií yoꞌ a. Ga̱a ne̱ cuchiꞌ nij xrej ata̱ suun noco̱o doj do̱ꞌ, nij síí uun chij rihaan nij yuvii̱ do̱ꞌ, rihaan soꞌ, ne̱ xnáꞌanj nij soꞌ man soꞌ, cataj nij soꞌ: ―Me síí caꞌneꞌ suun rihaan so̱ꞌ qui̱ꞌyáá so̱ꞌ nda̱a vaa ꞌyáá so̱ꞌ ga̱ ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Ne̱ vaa yoꞌo̱ nana̱ xna̱ꞌanj ꞌu̱nj man nij soj, ne̱ sese ya̱ cata̱j xnaꞌanj nij soj nana̱ yoꞌ rihanj, ne̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj me síí caꞌneꞌ suun rihanj a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Dan me se me síí caꞌneꞌ suun rihaan síí cuꞌna̱j Juan cuta̱ꞌ ne soꞌ man yuvii̱, rá soj ga̱. Maꞌa̱n Juan cavii raa̱ naꞌ. Ase Diose̱ cataj xnaꞌanj rihaan soꞌ xa̱ꞌ. Cata̱j xnaꞌanj nij soj rihanj á ―taj Jesucristó a. Ga̱a ne̱ nuchruj ra̱a̱ ndoꞌo nij soꞌ ga̱ tuviꞌ nij soꞌ, cataj nij soꞌ: ―Sese cata̱j níꞌ se vaa Diose̱ caꞌneꞌ suun rihaan síí cuꞌna̱j Juan cuta̱ꞌ ne soꞌ man yuvii̱, ne̱ cata̱j Jesucristó rihaan níꞌ me cheꞌé ne cuchuma̱n rá níꞌ nana̱ caꞌmii Juan, cata̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tza̱j ne̱ sese cata̱j níꞌ se vaa nuveé si̱j caꞌneꞌ Diose̱ suun rihaan me síí cuꞌna̱j Juan, ne̱ caꞌma̱an rá nij yuvii̱, ne̱ quira̱nꞌ níꞌ sayuun, quiꞌya̱j nij yuvii̱ na̱nj á. ꞌO̱ se nij yuvii̱ me se síí caꞌnéé Diose̱ nata̱ꞌ se‑na̱na̱ Diose̱ me síí cuꞌna̱j Juan, rá cunuda̱nj nij yuvii̱ na̱nj á ―taj nij soꞌ rihaan tuviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ga̱a ne̱ cataj nij soꞌ rihaan Jesucristó: ―Ne neꞌen núj me síí caꞌneꞌ suun rihaan síí cuꞌna̱j Juan cuta̱ꞌ ne soꞌ man yuvii̱ maꞌ ―taj nij soꞌ a. ―Cheꞌé dan se̱ cataj xnaꞌanj ꞌu̱nj rihaan nij soj me síí caꞌneꞌ suun rihanj qui̱ꞌyáj nda̱a vaa ꞌyáj maꞌ ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ga̱a ne̱ nanó Jesucristó cuentó nihánj cuno nij soꞌ a: ―Ne̱ da̱j vaa nana̱ nihánj nana̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj, rá soj ga̱. Vaa vi̱j taꞌníí ꞌo̱ soꞌ a. Ne̱ cuchiꞌ soꞌ rihaan yoꞌo̱ taꞌníí soꞌ, cataj soꞌ: “Cuanꞌ cavi̱i̱ so̱ꞌ quiꞌya̱j suun so̱ꞌ rque naa̱ chruj uvá, rej”, taj soꞌ rihaan taꞌníí soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Se̱ caꞌanj ꞌu̱nj maꞌ”, taj xnii yoꞌ rihaan rej soꞌ a. Tza̱j ne̱ orá nii doj naquiꞌyaj nica̱ꞌ soꞌ nimán soꞌ, ne̱ caꞌanj quiꞌya̱j suun soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ga̱a ne̱ cuchiꞌ rej xnii rihaan yoꞌó taꞌníí soꞌ, ne̱ cataj xnaꞌanj soꞌ se vaa caꞌa̱nj xnii yoꞌ, quiꞌya̱j suun yoꞌ a. “Caꞌa̱nj ꞌu̱nj, ata̱j”, taj soꞌ rihaan rej soꞌ a. Tza̱j ne̱ ne caꞌa̱nj soꞌ quiꞌya̱j suun soꞌ, ne̱ tihaꞌ soꞌ man rej soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ne̱ me taꞌníí snóꞌo yoꞌ cuno sa̱ꞌ rihaan soꞌ, rá soj ga̱ ―taj Jesucristó, xnáꞌanj Jesucristó man nij soꞌ a. ―Xnii caꞌanj quiꞌya̱j suun roꞌ, cuno ya̱ soꞌ rihaan rej soꞌ ei ―taj nij soꞌ rihaan Jesucristó a. Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan nij soj cuano̱ se vaa nij síí tihaꞌ yuꞌunj man yuvii̱ cheꞌé puextó do̱ꞌ, nij chana̱ niha̱ꞌ rá ga̱ chii do̱ꞌ, quita̱j ya̱a̱n rihaan soj catu̱u̱ nij soꞌ rihaan Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj, ne̱ quina̱j xco̱ nij soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ꞌO̱ se cuchiꞌ síí cuꞌna̱j Juan rihaan nij soj, ne̱ tucuꞌyón soꞌ rihaan nij soj da̱j quiꞌya̱j soj cuno̱ sa̱ꞌ soj rihaan Diose̱, tza̱j ne̱ ne cuchuma̱n rá nij soj nana̱ caꞌmii soꞌ maꞌ. Tza̱j ne̱ nij síí tihaꞌ yuꞌunj man yuvii̱ cheꞌé puextó do̱ꞌ, nij chana̱ niha̱ꞌ rá ga̱ chii do̱ꞌ, cuchumán rá nana̱ caꞌmii Juan na̱nj ado̱nj. Ne̱ queneꞌen soj se vaa cuchumán rá nij soꞌ, tza̱j ne̱ ne nuchra̱nꞌ nimán soj, ne̱ ne cuchuma̱n rá maꞌa̱n soj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","”Ne̱ cuno̱ uún nij soj yoꞌó cuentó nihánj á. Dan me se vaa yoꞌo̱ síí toꞌo̱j, ne̱ cuchruj soꞌ yoꞌo̱ naa̱ chruj uvá, ne̱ quiꞌyaj soꞌ chingá nu̱ꞌ anica̱j tuꞌva naa̱ yoꞌ, ga̱a ne̱ gáán soꞌ yuꞌuj rej xtu̱nꞌ chruj uvá ne̱ cavi̱i̱ na, ne̱ cuneꞌ soꞌ ꞌo̱ veꞌ nataꞌ ca̱yáán nij síí cu̱tumé naa̱ yoꞌ a. Ga̱a ne̱ tanáj soꞌ man naa̱ yoꞌ rihaan síí quiꞌya̱j suun naa̱ yoꞌ, ne̱ curiha̱nj soꞌ caꞌanj soꞌ ga̱nꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Cachén do̱j yavii, ne̱ quisíj yavii cuta̱ nii chruj uvá, ne̱ caꞌnéé síí xna̱a̱ yoꞌ man yoꞌó taꞌa̱j nij se‑mo̱zó soꞌ rihaan nij síí nu̱u̱ tumé xnaa̱ soꞌ a. Me rá soꞌ caꞌna̱ꞌ ni̱caj yoꞌó nij se‑mo̱zó soꞌ do̱j chruj uvá rihaan maꞌa̱n soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ga̱a ne̱ quitaꞌaa nij síí nu̱u̱ tumé naa̱ man yoꞌó nij mozó cuchiꞌ uún a. Dan me se goꞌ uxrá nij soꞌ chruun xráá yoꞌo̱ mozó yoꞌ, ne̱ ticaviꞌ nij soꞌ man yoꞌó mozó yoꞌ, ne̱ goꞌ uxrá nij soꞌ yahij man yoꞌó mozó yoꞌ ne̱ yu̱u̱n cheꞌe̱ caviꞌ soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ga̱a ne̱ caꞌnéé uún síí xna̱a̱ yoꞌ man yoꞌó da̱nj mozó caꞌa̱nj uún rej na̱j xnaa̱ soꞌ a. Tza̱j ne̱ nij síí nu̱u̱ tumé naa̱ roꞌ, yoꞌó da̱nj quiꞌyaj uún nij soꞌ man uún nij síí cuchiꞌ uún a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Veé dan, ga̱a ne̱ caꞌnéé síí xna̱a̱ yoꞌ taꞌníí soꞌ rej ma̱n nij síí nu̱u̱ tumé xnaa̱ soꞌ a. “Cara̱a̱ cochro̱j nij síí tumé naa̱ rihaan taꞌníj sese caꞌa̱nj taꞌníj saj xe̱e̱”, taj síí xna̱a̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tza̱j ne̱ queneꞌen nij síí tumé naa̱ man taꞌníí síí xna̱a̱, ne̱ cataj nij soꞌ: “Síí nihánj me síí gu̱un síí xna̱a̱ naa̱ nihánj vaa güii ei. Cheꞌé dan ticavi̱ꞌ níꞌ man soꞌ, ne̱ vaa güii, ne̱ gu̱un xna̱a̱ maꞌa̱n níꞌ man naa̱ nihánj chugua̱nj”, taj nij soꞌ rihaan tuviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ga̱a ne̱ quitaꞌaa nij soꞌ man taꞌníí síí xna̱a̱ yoꞌ, ne̱ quirii nij soꞌ xeꞌ, ne̱ ticaviꞌ nij soꞌ man taꞌníí síí xna̱a̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ne̱ vaa güii, ne̱ caꞌna̱ꞌ uún síí xna̱a̱ yoꞌ, ne̱ da̱j quiꞌya̱j soꞌ man nij síí nu̱u̱ tumé xnaa̱ soꞌ, rá nij soj ga̱ ―taj Jesucristó, xnáꞌanj soꞌ man nij xrej do̱ꞌ, man nij síí uun chij do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","―Quiꞌya̱j ndoꞌo síí xna̱a̱ yoꞌ sayuun man nij síí chiꞌi̱i̱ ꞌyaj suun xnaa̱ soꞌ, ticavi̱ꞌ soꞌ man nij soꞌ na̱nj á. Ne̱ ta̱cuachén soꞌ xnaa̱ soꞌ rihaan yoꞌó síí tu̱mé xnaa̱ soꞌ, ne̱ yavii cuta̱ nii chruj uvá roꞌ, veꞌé rque̱ nij soꞌ chruj yoꞌ rihaan síí xna̱a̱ yoꞌ na̱nj ado̱nj ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ga̱a ne̱ cataj Jesucristó: ―Me cheꞌé ne naya̱a̱ nij soj nana̱ nihánj nana̱ no̱ rihaan danj Diose̱ ga̱: “Yuvej quiriꞌíj nij síí cuneꞌ veꞌ roꞌ, guun yuvej sa̱ꞌ doj rihaan cunuda̱nj nij yuvej ma̱n tacóó veꞌ yoꞌ na̱nj ado̱nj. Maꞌa̱n síí ꞌni̱j raꞌa man níꞌ quiꞌyaj yoꞌ, ne̱ cuna̱j uxrá vaa yoꞌ, rá níꞌ á”, taj danj Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Cheꞌé dan cuano̱ nihánj me se cata̱j xnaꞌanj ꞌu̱nj rihaan nij soj se vaa caꞌne̱e̱ Diose̱ se‑su̱u̱n soj suun gu̱un chij ga̱ Diose̱ rihaan chumii̱ nihánj, ga̱a ne̱ cune̱ꞌ Diose̱ man yoꞌó yuvii̱ se vaa gu̱un chij yoꞌó nij yuvii̱ rihaan chumii̱ nihánj ga̱ soꞌ, ne̱ veꞌé quiꞌya̱j yoꞌó nij yuvii̱ yoꞌ nu̱ꞌ se vaa me rá Diose̱ quiꞌya̱j nij soꞌ na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ne̱ yuvej yoꞌ me se ase vaa yuvej yoꞌ vaa ꞌu̱nj, ne̱ ase vaa yuvii̱ tíxé yuvej yoꞌ vaa yuvii̱ naꞌvej rá cuno̱ rihaan ꞌu̱nj, ne̱ uxrá quira̱nꞌ nij soꞌ sayuun na̱nj ado̱nj. Ne̱ ase vaa yuvii̱ quinij yuvej yoꞌ xráá vaa nij yuvii̱ qui̱ꞌyáá ꞌu̱nj sayuun man, ne̱ yu̱u̱n cheꞌe̱ quinavi̱j nij soꞌ nu̱ꞌ cavii nu̱ꞌ caꞌanj na̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Dan me se cuno nij xrej ata̱ suun noco̱o doj cuno nij síí fariseo cuno cuentó nanó Jesucristó, ne̱ queneꞌen nij soꞌ se vaa cheꞌe̱ maꞌa̱n nij soꞌ me cuentó nanó Jesucristó a. Ase vaa nij síí nu̱u̱ tumé naa̱ vaa maꞌa̱n nij soꞌ niꞌya̱j Jesucristó, ne̱ queneꞌen nij soꞌ se vaa cheꞌé dan nanó Jesucristó cuentó yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ga̱a ne̱ nanó rá nij soꞌ da̱j ga̱a̱ qui̱taꞌaa nij soꞌ man Jesucristó, tza̱j ne̱ cuchuꞌviꞌ nij soꞌ niꞌya̱j nij soꞌ man nij yuvii̱ a. ꞌO̱ se síí nataꞌ se‑na̱na̱ Diose̱ me Jesucristó, rá nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ga̱a ne̱ caꞌmii uún Jesucristó, nanó soꞌ doj cuentó rihaan nij soꞌ, cataj soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Ase vaa quiꞌyaj yoꞌo̱ síí nica̱j suun rey roꞌ, da̱nj quiꞌya̱j uún Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj ei. Dan me se síí nica̱j suun rey yoꞌ me se quiꞌyaj soꞌ chaꞌanj cheꞌé taꞌníí soꞌ síí naraꞌa̱a, ");
INSERT INTO trcNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ne̱ vaa yuvii̱ navi̱j rá chaꞌanj ga̱ soꞌ, ne̱ caꞌnéé soꞌ se‑mo̱zó soꞌ caꞌa̱nj nij soꞌ rihaan nij yuvii̱, cata̱j xnaꞌanj se‑mo̱zó soꞌ rihaan nij yuvii̱ se vaa caꞌna̱ꞌ nij soꞌ tucuá soꞌ navi̱j rá nij soꞌ chaꞌanj naraꞌa̱a yoꞌ, tza̱j ne̱ ne caꞌve̱j nij yuvii̱ yoꞌ caꞌna̱ꞌ nij soꞌ tucuá síí nica̱j suun rey a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ga̱a ne̱ caꞌnéé uún soꞌ man doj se‑mo̱zó soꞌ rihaan nij síí navi̱j rá chaꞌanj ga̱ soꞌ, ne̱ caꞌnéé soꞌ nana̱ rihaan nij yuvii̱ yoꞌ se vaa a̱j quiꞌyaj chuvi̱i soꞌ cha̱ niꞌyánj nij soꞌ do̱ꞌ, se vaa a̱j ticaviꞌ soꞌ scúj a̱j ticaviꞌ soꞌ scúj leꞌe̱j rami̱i̱ ndoꞌo a̱j ticaviꞌ soꞌ do̱ꞌ, se vaa a̱j vaa chuvi̱i nu̱ꞌ rasu̱u̱n quiꞌyaj soꞌ a. Cheꞌé dan caꞌna̱ꞌ nij soꞌ, ne̱ navi̱j rá nij soꞌ chaꞌanj ga̱ soꞌ, ne̱ cheꞌé dan caꞌnéé soꞌ nana̱ rihaan nij síí navi̱j rá chaꞌanj ga̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","”Tza̱j ne̱ ne caꞌna̱ꞌ a̱ ꞌó nij soꞌ a̱ maꞌ. Ma̱a̱n se taꞌa̱j nij soꞌ caꞌanj quiꞌya̱j suun xnaa̱ nij soꞌ, ne̱ yoꞌó taꞌa̱j nij soꞌ caꞌanj cutuꞌve̱e̱ rasu̱u̱n rihaan yuvii̱ uún a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ne̱ yoꞌó nij soꞌ quitaꞌaa man nij se‑mo̱zó síí nica̱j suun rey, ne̱ quiꞌyaj chiꞌi̱i̱ nij soꞌ man mozó yoꞌ, ne̱ ticaviꞌ nij soꞌ man mozó nacúún man nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ga̱a ne̱ caꞌmaan ndoꞌo rá síí nica̱j suun rey yoꞌ, ne̱ caꞌnéé soꞌ man nij se‑tanu̱u soꞌ caꞌa̱nj ticavi̱ꞌ nij soꞌ man síí ticaviꞌ man se‑mo̱zó soꞌ a. Cuchiꞌ nij tanuu rihaan nij síí ticaviꞌ man mozó yoꞌ, ne̱ ticaviꞌ nij tanuu man nij soꞌ, ne̱ caxríj yaꞌan nij tanuu man se‑chuma̱nꞌ nij soꞌ, ne̱ cacaa nu̱ꞌ chumanꞌ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","”Ga̱a ne̱ caꞌmii síí nica̱j suun rey rihaan nij se‑mo̱zó soꞌ, cataj soꞌ: “Síj quiꞌyaj chuvi̱i níꞌ navi̱j rá níꞌ chaꞌanj, tza̱j ne̱ nij síí me rá ꞌu̱nj navi̱j rá chaꞌanj ga̱j me se nuveé si̱j sa̱ꞌ me nij soꞌ a̱ maꞌ. Ne nó xcúún nij soꞌ caꞌna̱ꞌ nij soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cheꞌé dan caꞌa̱nj soj rej nuná tuviꞌ chrej, ne̱ na̱j guun yuvii̱ nari̱ꞌ soj roꞌ, cata̱j xnaꞌanj soj rihaan yuvii̱ yoꞌ se vaa caꞌna̱ꞌ nij soꞌ navi̱j rá nij soꞌ chaꞌanj ga̱ níꞌ á”. Da̱nj caꞌmii soꞌ rihaan se‑mo̱zó soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ga̱a ne̱ curiha̱nj nij mozó, ne̱ naquiꞌyaj chre̱ꞌ nij soꞌ man cunuda̱nj nij yuvii̱ nariꞌ nij soꞌ rá chrej, ne̱ dan me se taꞌa̱j nij yuvii̱ yoꞌ me síí chiꞌi̱i̱, ne̱ taꞌa̱j nij yuvii̱ yoꞌ me síí sa̱ꞌ a. Dan me se quisíj caraa nu̱ꞌ veꞌ ca̱nuû chaꞌanj, ga̱a ne̱ caꞌanj ca̱yáán taranꞌ nij yuvii̱ rihaan mesá cha̱ niꞌyánj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","”Ga̱a ne̱ catúj síí nica̱j suun rey yoꞌ rá veꞌ chá niꞌyánj nij soꞌ, ne̱ queneꞌen soꞌ man yoꞌo̱ soꞌ, se vaa nuviꞌ yatzíj nu̱u̱ nij síí navij rá chaꞌanj naraꞌa̱a nuû soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ga̱a ne̱ caꞌmii síí nica̱j suun rey rihaan soꞌ, cataj soꞌ: “Me cheꞌé catúj so̱ꞌ rá veꞌ nihánj veꞌ anuû chaꞌanj, ne̱ nuviꞌ yatzíj naraꞌa̱a nuû so̱ꞌ, ga̱ tinu̱ꞌ”, taj soꞌ a. Ne̱ guun naꞌa̱j soꞌ, ne̱ ne caꞌmi̱i̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ga̱a ne̱ caꞌneꞌ síí nica̱j suun rey yoꞌ suun rihaan nij se‑mo̱zó soꞌ, cataj soꞌ: “Nu̱míj soj tacóó síí nihánj nu̱míj soj raꞌa síí nihánj nu̱míj soj, ne̱ quiriꞌi̱j soj man soꞌ xeꞌ caꞌa̱nj soꞌ rej rmi̱ꞌ á”, taj síí nica̱j suun rey yoꞌ a. Rej rmi̱ꞌ yoꞌ me se yoꞌ me rej taꞌve̱e ndoꞌo yuvii̱ ne̱ nda̱a cha̱ ru̱j yuvii̱ cúú yanꞌ yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ꞌO̱ se nacúún Diose̱ man uxrá yuvii̱ caꞌna̱ꞌ nij yuvii̱ ca̱yáán nij yuvii̱ ga̱ soꞌ, tza̱j ne̱ do̱j vaa nij yuvii̱ narii Diose̱ cane̱ ga̱ soꞌ na̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ga̱a ne̱ curiha̱nj nij síí fariseo, ne̱ nuchruj ra̱a̱ nij soꞌ ga̱ tuviꞌ nij soꞌ da̱j quiꞌya̱j nij soꞌ cuta̱ꞌ nij soꞌ cacunꞌ xráá Jesucristó cheꞌé nana̱ caꞌmi̱i̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ga̱a ne̱ caꞌnéé nij soꞌ man nij síí tucuꞌyón se‑na̱na̱ maꞌa̱n nij soꞌ do̱ꞌ, man nij síí noco̱ꞌ man síí cuꞌna̱j Herodes do̱ꞌ, cuchi̱ꞌ nij soꞌ rihaan Jesucristó a. Ne̱ cataj nij soꞌ rihaan Jesucristó a: ―Neꞌen núj se vaa nana̱ ya̱ ina̱nj aꞌmii so̱ꞌ, ne̱ ya̱ tucuꞌyón so̱ꞌ rihaan yuvii̱ da̱j quiꞌya̱j yuvii̱ canoco̱ꞌ yuvii̱ man Diose̱, maestro. Ne̱ ne chuꞌvíꞌ so̱ꞌ niꞌya̱j so̱ꞌ man nij yuvii̱ da̱j cata̱j yuvii̱ maꞌ. Ne̱ ꞌo̱ cuya̱a̱n vaa nu̱ꞌ yuvii̱ rihaan so̱ꞌ chugua̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Cheꞌé dan cata̱j xnaꞌanj so̱ꞌ rihaan núj da̱j quiꞌya̱j yuvii̱, rá so̱ꞌ á. No̱ xcúún yuvii̱ go̱ꞌ yuvii̱ puextó rihaan síí nica̱j suun cuꞌna̱j César naꞌ. Ase se̱ goꞌ yuvii̱ xa̱ꞌ ―taj nij soꞌ, xnáꞌanj nij soꞌ nana̱ tihaꞌ yuꞌunj man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tza̱j ne̱ queneꞌen Jesucristó se vaa me rá nij soꞌ quiꞌya̱j chiꞌi̱i̱ nij soꞌ man soꞌ a. Cheꞌé dan cataj soꞌ: ―Me cheꞌé me rá soj tiha̱ꞌ yuꞌunj soj manj ne̱ cuta̱ꞌ soj cacunꞌ xráj ga̱. ꞌO̱ se síí tihaꞌ yuꞌunj man yuvii̱ me soj, ne̱ quij vaa nimán soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ti̱haa̱n soj rihanj da̱j vaa saꞌanj oꞌ nii cheꞌé puextó á ―taj Jesucristó rihaan nij síí me rá tiha̱ꞌ yuꞌunj yoꞌ a. Ga̱a ne̱ nanoꞌ nij soꞌ saꞌanj aga̱ꞌ oꞌ yuvii̱ cheꞌé puextó, ne̱ tihaa̱n nij soꞌ saꞌanj aga̱ꞌ yoꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","―Me síí nó rihaan saꞌanj aga̱ꞌ nihánj ga̱. Ne̱ me síí se‑chuvi̱i nó rihaan saꞌanj aga̱ꞌ nihánj ga̱ ―taj Jesucristó, xnáꞌanj soꞌ man nij síí me rá tiha̱ꞌ yuꞌunj yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","―Síí nica̱j suun cuꞌna̱j César me nó rihaan saꞌanj aga̱ꞌ yoꞌ, ne̱ nó se‑chuvi̱i soꞌ rihaan saꞌanj ei ―taj nij soꞌ a. Ga̱a ne̱ cataj Jesucristó: ―Cheꞌé dan go̱ꞌ soj siꞌyaj síí nica̱j suun cuꞌna̱j César rihaan maꞌa̱n soꞌ, ne̱ rque̱ soj siꞌyaj Diose̱ rihaan Diose̱ á ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Dan me se cuno nij soꞌ nana̱ caꞌmii Jesucristó, ne̱ caꞌanj rá nij soꞌ, ne̱ tanáj nij soꞌ man Jesucristó, caꞌanj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ne̱ corá cuchiꞌ do̱j nij síí saduceo rihaan Jesucristó a. Nij síí saduceo roꞌ, aꞌmii nana̱ nihánj se vaa daj chiha̱a̱ míj se̱ cunuu iꞌna̱ꞌ uún yuvii̱ asa̱ꞌ caviꞌ yuvii̱, taj nij soꞌ a. Dan me se xnáꞌanj nij soꞌ man Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ne̱ cataj nij soꞌ nana̱ nihánj a: ―Cataj xnaꞌanj síí cuꞌna̱j Moisés nana̱ nihánj cuno̱ níꞌ a: “Sese caviꞌ yoꞌo̱ soꞌ, ne̱ sese taj va̱j taꞌníí soꞌ, ne̱ no̱ xcúún tinúú soꞌ xca̱j tinúú soꞌ man choco̱ꞌ soꞌ chana̱ quináj, ne̱ coto̱j tinúú síí caviꞌ ga̱ choco̱ꞌ soꞌ, ne̱ cuchru̱j noꞌ neꞌej, ne̱ gu̱un taꞌni̱j síí caviꞌ man neꞌej yoꞌ, ne̱ cu̱nuû neꞌej yoꞌ rihaan toꞌóó síí caviꞌ yoꞌ a”, taj síí cuꞌna̱j Moisés ga̱a naá, maestro. ");
INSERT INTO trcNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Dan me se vaa chi̱j nij tinu̱j ꞌo̱ nij soꞌ ne̱ ga̱ núj a. Síí chava̱ꞌ roꞌ, xcaj man chana̱, tza̱j ne̱ caviꞌ soꞌ, ne̱ taj va̱j neꞌej cuchruj chana̱ nica̱ soꞌ, quiꞌyaj soꞌ, ne̱ cheꞌé dan quináj u̱u̱n chana̱ yoꞌ, ne̱ cheꞌé dan xcaj scueꞌe̱e̱ síí caviꞌ yoꞌ man choco̱ꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tza̱j ne̱ caviꞌ soꞌ uún, ne̱ quináj u̱u̱n chana̱ xca̱j scueꞌe̱e̱ soꞌ uún, ne̱ veé dan me se xcaj chi̱j nij tinu̱j nij soꞌ man chana̱ yoꞌ, tza̱j ne̱ caviꞌ taranꞌ nij soꞌ na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Síj, ga̱a ne̱ caviꞌ maꞌa̱n chana̱ yoꞌ uún, ");
INSERT INTO trcNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ne̱ dan me se asa̱ꞌ cunuu iꞌna̱ꞌ uún nij síí caviꞌ, ga̱a ne̱ me nij tinu̱j nij soꞌ ni̱caj man chana̱ yoꞌ, rá so̱ꞌ ga̱. ꞌO̱ se ga̱a vaa iꞌna̱ꞌ nij soꞌ, ne̱ nica̱ taranꞌ nij tinu̱j nij soꞌ guun o̱rúnꞌ noꞌ a ―taj nij síí saduceo, xnáꞌanj nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Ne neꞌen uxrá soj maꞌ. ꞌO̱ se ne neꞌen soj me taj danj Diose̱, ne̱ ne neꞌen soj sese nucua̱j ndoꞌo Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ꞌO̱ se asa̱ꞌ cunuu iꞌna̱ꞌ uún nij síí caviꞌ, ne̱ se̱ xcaj tuviꞌ nij soꞌ a̱ maꞌ. ꞌO̱ se ase vaa yáán nij se‑mo̱zó Diose̱ rej xta̱ꞌ roꞌ, da̱nj ga̱a̱ ca̱yáán nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ga̱a ne̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj da̱j ga̱a̱ queneꞌe̱n soj se vaa ya̱ ya̱ cunu̱u iꞌna̱ꞌ uún yuvii̱ asa̱ꞌ caviꞌ yuvii̱ ei. Ataa naya̱a̱ soj nana̱ nihánj nana̱ caꞌmii maꞌa̱n Diose̱ naꞌ. Dan me se se‑na̱na̱ Diose̱ taj: ");
INSERT INTO trcNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Diose̱ síí noco̱ꞌ nij síí ma̱n ga̱a naá síí cuꞌna̱j Abraham do̱ꞌ, síí cuꞌna̱j Isaac do̱ꞌ, síí cuꞌna̱j Jacob do̱ꞌ, mej a.” Da̱nj caꞌmii Diose̱ cheꞌé nij síí ma̱n ga̱a naá yoꞌ a. Dan me se nuveé se‑Dio̱se̱ nij xnangá me Diose̱ maꞌ. Ina̱nj nij síí vaa iꞌna̱ꞌ aꞌvee nocoꞌ man Diose̱ na̱nj ado̱nj. Cheꞌé dan, nda̱ꞌ se síí cane ga̱a naá me vaꞌnu̱j nij soꞌ, tza̱j ne̱ vaa iꞌna̱ꞌ nij soꞌ rihaan Diose̱ na̱nj ei ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Dan me se cuno nij yuvii̱ nana̱ caꞌmii Jesucristó, ga̱a ne̱ guun niha̱ꞌ uxrá rá nij soꞌ se vaa veꞌé uxrá tucuꞌyón soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Dan me se cuchiꞌ nana̱ rihaan nij síí fariseo se vaa sa̱ꞌ uxrá caꞌmii Jesucristó rihaan nij síí saduceo ne̱ taj va̱j nana̱ nariꞌ nij síí saduceo caꞌmi̱i̱ uún nij soꞌ rihaan Jesucristó maꞌ. Ga̱a ne̱ cunuu chre̱ꞌ nij síí fariseo nuchruj ra̱a̱ nij soꞌ da̱j quiꞌya̱j maꞌa̱n nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ga̱a ne̱ xnáꞌanj yoꞌo̱ tuviꞌ nij soꞌ yoꞌo̱ nana̱ man Jesucristó, queneꞌe̱n soꞌ sese gu̱un nucua̱j Jesucristó cata̱j xnaꞌanj Jesucristó nana̱ yoꞌ a. Dan me se cataj soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Me nana̱ cataj xnaꞌanj Moisés me nana̱ noco̱o ndoꞌo nana̱ cuno̱ uxrá níꞌ ga̱ ―taj soꞌ, xnáꞌanj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ga̱a ne̱ cataj Jesucristó: ―“Nda̱a nimán yá so̱ꞌ gu̱un rá so̱ꞌ ni̱ꞌyaj so̱ꞌ man Diose̱ síí ꞌni̱j raꞌa man níꞌ, ne̱ yoꞌo̱ nda̱a cúú yave̱ mán so̱ꞌ cuchuma̱n rá ni̱ꞌyaj man Diose̱ na̱nj ado̱nj”. ");
INSERT INTO trcNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ne̱ nihánj me ya̱ nana̱ uun chij ya̱ na̱nj ei. ");
INSERT INTO trcNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ne̱ ase vaa nana̱ yoꞌ, da̱nj vaa yoꞌó nana̱ nihánj nana̱ me rá Diose̱ cuno̱ uún níꞌ a: “Adi̱ꞌ se ꞌe̱e̱ rá so̱ꞌ man ma̱ꞌán so̱ꞌ roꞌ, da̱nj ga̱a̱ ꞌe̱e̱ rá so̱ꞌ man tuvíꞌ so̱ꞌ á”. ");
INSERT INTO trcNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ꞌO̱ cuya̱a̱n aꞌmii ro̱j nana̱ nihánj ga̱ nu̱ꞌ tucuáán cuchruj síí cuꞌna̱j Moisés ga̱a naá do̱ꞌ, ga̱ nu̱ꞌ nana̱ nataꞌ nij síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá do̱ꞌ na̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Dan me se nuu chre̱ꞌ nij síí fariseo rihaan Jesucristó, ga̱a ne̱ xnáꞌanj Jesucristó man nij soꞌ, cataj soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―Da̱j si̱j me síí caꞌne̱j Diose̱ ti̱nanii man yuvii̱ rihaan sayuun, rá nij soj ga̱. Me síí tuvi̱ꞌ me soꞌ, rá soj ga̱ ―taj Jesucristó, xnáꞌanj soꞌ man nij síí fariseo a. ―Taꞌníí taꞌnij siꞌno̱ síí cuꞌna̱j David síí cane ga̱a naá me síí caꞌna̱ꞌ ti̱nanii man yuvii̱ rihaan sayuun na̱nj á ―taj nij síí fariseo a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ga̱a ne̱ cataj Jesucristó: ―Tza̱j ne̱ ga̱a cunuû Nimán Diose̱ nimán síí cuꞌna̱j David, ne̱ cataj David se vaa síí ꞌni̱j raꞌa man maꞌa̱n soꞌ me síí caꞌne̱j Diose̱ ti̱nanii man yuvii̱ rihaan sayuun na̱nj á. Dan me se cataj soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Caꞌmii Diose̱ síí ꞌni̱j raꞌa man níꞌ rihaan síí ꞌni̱j raꞌa manj, cataj soꞌ se vaa ca̱yáán síí ꞌni̱j raꞌa manj xꞌnúú Diose̱ rej nuva̱ꞌ Diose̱ nda̱a se quisi̱j quiꞌya̱j canaán Diose̱ rihaan taranꞌ nij síí ta̱j riꞌyunj man síí ꞌni̱j raꞌa manj ne̱ quiri̱i̱ taꞌngaꞌ síí ꞌni̱j raꞌa manj rihaan nij soꞌ na̱nj ado̱nj”, taj síí cuꞌna̱j David yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dan me se síí ꞌni̱j raꞌa man síí cuꞌna̱j David me síí caꞌne̱j Diose̱ ti̱nanii man yuvii̱ rihaan sayuun, taj síí cuꞌna̱j David yoꞌ a. Sese ꞌni̱j raꞌa soꞌ man David, ne̱ me cheꞌé taj soj se vaa na̱nj taꞌníí taꞌnij siꞌno̱ David me soꞌ ga̱. Taj cheꞌé cata̱j soj se vaa na̱nj yuvii̱ me soꞌ maꞌ ―taj Jesucristó rihaan nij síí fariseo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ne̱ a̱ ꞌó nij soꞌ ne gu̱un nucua̱j cata̱j xnaꞌanj ꞌo̱ nana̱ rihaan Jesucristó, ne̱ a̱ ꞌó nij soꞌ ne quisi̱j rá xna̱ꞌanj doj nana̱ man Jesucristó a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ga̱a ne̱ caꞌmii Jesucristó rihaan nij yuvii̱ do̱ꞌ, rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ do̱ꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","cataj soꞌ: ―Nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés do̱ꞌ, nij síí fariseo do̱ꞌ, ata̱ nij soꞌ se‑su̱u̱n síí cuꞌna̱j Moisés síí cane ga̱a naá a. ");
INSERT INTO trcNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Cheꞌé dan, na̱j guun nana̱ cata̱j nij soꞌ rihaan soj roꞌ, cuno̱ soj nu̱ꞌ nana̱ yoꞌ, ne̱ da̱nj quiꞌya̱j gue̱e̱ soj á. Tza̱j ne̱ se̱ quiꞌyaj soj nda̱a vaa ꞌyaj nij soꞌ a̱ maꞌ. ꞌO̱ se taj xnaꞌanj nij soꞌ da̱j quiꞌya̱j yuvii̱, tza̱j ne̱ ne ꞌyaj maꞌa̱n nij soꞌ se vaa taj nij soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ne̱ aꞌneꞌ uxrá nij soꞌ suun rihaan yuvii̱ da̱j quiꞌya̱j yuvii̱ canoco̱ꞌ yuvii̱ man Diose̱, ne̱ dan me se ase vaa yuvii̱ araa ndoꞌo rasu̱u̱n ꞌe̱e̱ xráá tuviꞌ vaa nij soꞌ, tza̱j ne̱ a̱ doj ne racuíj nij soꞌ man yuvii̱ ca̱ta̱ yuvii̱ rasu̱u̱n ꞌe̱e̱ yoꞌ a̱ maꞌ. A̱ ꞌó raa̱ raꞌa nij soꞌ ne racuíj nij soꞌ man yuvii̱ na̱nj man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Na̱j guun suun sa̱ꞌ ꞌyaj nij soꞌ roꞌ, tza̱j ne̱ ma̱a̱n cheꞌé rej me rá nij soꞌ queneꞌe̱n yuvii̱, ne̱ cheꞌé dan ꞌyaj nij soꞌ da̱nj na̱nj ado̱nj. ꞌO̱ se caxra̱ꞌ ndoꞌo vaa nij caxra̱nꞌ nu̱u̱ se‑na̱na̱ Diose̱ noco̱ꞌ rihaan nij soꞌ, ꞌyaj nij soꞌ, ne̱ xca̱a̱n ndoꞌo vaa yiquitzij noco̱ꞌ tuꞌva saga̱nꞌ nij soꞌ, ꞌyaj uún nij soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ne̱ niha̱ꞌ rá nij soꞌ nano̱ꞌ nij soꞌ rej sa̱ꞌ doj quita̱j nij soꞌ ga̱a ꞌanj nij soꞌ chaꞌanj, ne̱ niha̱ꞌ rá nij soꞌ nano̱ꞌ nij soꞌ chruun xlá sa̱ꞌ doj quita̱j nij soꞌ rá veꞌ tucuꞌyón yuvii̱ se‑tucua̱nj Moisés, ");
INSERT INTO trcNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ne̱ niha̱ꞌ rá nij soꞌ ga̱a veꞌé aꞌmii yuvii̱ ga̱ nij soꞌ ga̱a chéé nij soꞌ yuꞌvee, ne̱ niha̱ꞌ rá nij soꞌ cata̱j yuvii̱ “Síí guun chij” rihaan nij soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","tza̱j ne̱ maꞌa̱n soj roꞌ, se̱ guun cata̱j yuvii̱ “Síí guun chij” rihaan maꞌa̱n soj, quiꞌya̱j soj a̱ maꞌ. ꞌO̱ se vaa o̱rúnꞌ síí uun chij rihaan soj, ne̱ tinu̱j taranꞌ soj na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ne̱ se̱ guun cata̱j soj “Ata̱j chij” rihaan yuvii̱ ma̱n rihaan chumii̱ nihánj a̱ maꞌ. ꞌO̱ se vaa o̱rúnꞌ Rej soj síí nicu̱nꞌ xta̱ꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ne̱ se̱ guun cata̱j yuvii̱ se vaa noco̱ꞌ nij yuvii̱ man soj, quiꞌya̱j soj a̱ maꞌ. ꞌO̱ se o̱rúnꞌ síí caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun me síí canoco̱ꞌ soj man na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ne̱ me maꞌa̱n tuviꞌ soj síí ꞌyaj suun cheꞌé soj roꞌ, yoꞌ me síí sa̱ꞌ doj rihaan taranꞌ soj, ");
INSERT INTO trcNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ne̱ xa̱ꞌ síí me rá ti̱cavii sa̱ꞌ man maꞌa̱n, tza̱j ne̱ quiri̱ꞌ soꞌ, ne̱ gu̱un naꞌa̱j soꞌ, ne̱ xa̱ꞌ síí ꞌyaj nica̱ꞌ nimán, tza̱j ne̱ cavi̱i̱ sa̱ꞌ soꞌ ado̱nj ―taj Jesucristó rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ga̱a ne̱ canica̱j Jesucristó caꞌmii Jesucristó rihaan nij síí fariseo do̱ꞌ, rihaan nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ, cataj soꞌ: ―Nique̱ soj si̱j fariseo do̱ꞌ, si̱j naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ a. Quira̱nꞌ uxrá soj sayuun ado̱nj. Dan me se aꞌnéj nij soj veꞌ tucuá chana̱ caviꞌ nica̱, ne̱ yu̱u̱n cheꞌe̱ guun tucua̱ nij soj man veꞌ yoꞌ, ꞌyaj maꞌa̱n nij soj, ne̱ ra̱a̱n ndoꞌo achíín niꞌya̱j nij soj rihaan Diose̱, cheꞌé rej sa̱ꞌ doj gu̱un nucua̱j nij soj tiha̱ꞌ yuꞌunj soj man yuvii̱ a. Cheꞌé dan doj a̱ ga̱a̱ sayuun quira̱nꞌ soj quiꞌya̱j Diose̱, asa̱ꞌ caꞌneꞌ Diose̱ cacunꞌ cheꞌé yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","”Nique̱ soj si̱j fariseo do̱ꞌ, si̱j naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ a. Quira̱nꞌ uxrá nij soj sayuun na̱nj ado̱nj. Síí nucuiꞌ rá me nij soj ado̱nj. Dan me se aráán soj chrej catu̱u̱ yuvii̱ rihaan Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj á. ꞌO̱ se ne uun chij Diose̱ nimán soj, ꞌyaj soj maꞌ. Ne̱ nda̱a nij síí me rá gu̱un chij Diose̱ nimán roꞌ, aráán soj chrej cuno̱ nij soꞌ rihaan Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","”Nique̱ soj si̱j naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ, si̱j fariseo do̱ꞌ ei. Quira̱nꞌ uxrá nij soj sayuun na̱nj ado̱nj. Síí nucuiꞌ rá me nij soj á. Dan me se chéé soj nda̱a rej xco̱ tuꞌva na yaꞌa̱nj do̱ꞌ, nda̱a rej xco̱ quij do̱ꞌ, nanoꞌ soj yoꞌo̱ síí canoco̱ꞌ man soj, ga̱a ne̱ quisíj canocoꞌ yoꞌo̱ soꞌ man soj ꞌyaj soj, ga̱a ne̱ nuu chiꞌi̱i̱ doj nimán soꞌ rihaan nimán soj, ꞌyaj soj, ne̱ quita̱j ya̱a̱n soꞌ rihaan soj caꞌa̱nj taranꞌ nij soj rihaan yaꞌan ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","”Nique̱ soj cheꞌé sayuun quira̱nꞌ soj na̱nj á. Ase vaa síí tuchri̱i vaa soj, tza̱j ne̱ me rá soj ti̱haa̱n soj rihaan yuvii̱ da̱j ga̱a̱ quiꞌya̱j yuvii̱ a. Caꞌve̱e se cutaꞌ yoꞌo̱ soꞌ raa̱ nuvií noco̱o se vaa ya̱ vaa nana̱ caꞌmii soꞌ, tza̱j ne̱ taj se ꞌyaj sese caꞌmii ne̱ soꞌ maꞌ, taj soj a. Tza̱j ne̱ sese cutaꞌ yoꞌo̱ soꞌ raa̱ agaꞌ oró míí nu̱u̱ rá nuvií, ga̱a ne̱ cheꞌé dan ya̱ vaa nana̱ caꞌmii soꞌ, ne̱ no̱ xcúún soꞌ quiꞌya̱j soꞌ nu̱ꞌ nda̱a vaa cataj soꞌ, taj soj a. ");
INSERT INTO trcNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ase vaa síí niꞌyo̱n do̱ꞌ, ase vaa síí tuchri̱i do̱ꞌ, vaa soj ado̱nj. Me cheꞌé ne neꞌen soj se vaa nuvií noco̱o me se sa̱ꞌ doj vaa yoꞌ rihaan agaꞌ oró míí nu̱u̱ rque nuvií yoꞌ ga̱. ꞌO̱ se neꞌen soj se vaa cheꞌé maꞌa̱n nuvií noco̱o yoꞌ roꞌ, nuu gue̱e̱ agaꞌ oró míí yoꞌ rihaan Diose̱ á. ");
INSERT INTO trcNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ne̱ taj uún soj se vaa sese cutaꞌ yoꞌo̱ soꞌ raa̱ chraan altar acaa xcuu rqué yuvii̱ rihaan Diose̱ se vaa ya̱ vaa nana̱ caꞌmii soꞌ, ne̱ taj se ꞌyaj sese caꞌmii ne̱ soꞌ maꞌ, taj uún soj a. Tza̱j ne̱ sese cutaꞌ soꞌ raa̱ xcuu na̱j rihaan chraan altar yoꞌ, ne̱ no̱ xcúún soꞌ quiꞌya̱j soꞌ nu̱ꞌ nda̱a vaa cataj soꞌ, taj uún soj a. ");
INSERT INTO trcNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Dan me se ase vaa síí tuchri̱i vaa soj ado̱nj. Me cheꞌé ne neꞌen soj se vaa sa̱ꞌ doj vaa chraan altar yoꞌ rihaan xcuu na̱j rihaan yoꞌ ga̱. ꞌO̱ se cheꞌé maꞌa̱n chraan altar roꞌ, cheꞌé dan nuu gue̱e̱ xcuu yoꞌ rihaan Diose̱ na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Cheꞌé dan sese cutaꞌ yoꞌo̱ soꞌ raa̱ chraan altar yoꞌ, ne̱ nuveé ra̱a̱ chraan altar yoꞌ me se cutaꞌ soꞌ raa̱ maꞌ. ꞌO̱ se cutaꞌ soꞌ raa̱ chraan altar do̱ꞌ, raa̱ nu̱ꞌ se ta̱j rihaan chraan altar yoꞌ do̱ꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ne̱ sese cutaꞌ yoꞌo̱ soꞌ raa̱ nuvií noco̱o, ne̱ nuveé ina̱nj raa̱ nuvií noco̱o me se cutaꞌ soꞌ raa̱ maꞌ. ꞌO̱ se cutaꞌ soꞌ raa̱ nuvií noco̱o do̱ꞌ, raa̱ maꞌa̱n Diose̱ síí ya̱nj nuvií noco̱o do̱ꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ne̱ sese cutaꞌ yoꞌo̱ soꞌ raa̱ rej xta̱ꞌ, ne̱ nuveé ina̱nj rej xta̱ꞌ me se cutaꞌ soꞌ raa̱ maꞌ. ꞌO̱ se cutaꞌ soꞌ raa̱ rej xta̱ꞌ do̱ꞌ, raa̱ chruun xlá chruun ta̱j maꞌa̱n Diose̱ ga̱a rii taꞌngaꞌ Diose̱ do̱ꞌ, raa̱ maꞌa̱n Diose̱ síí ta̱j rihaan chruun xlá yoꞌ do̱ꞌ, cutaꞌ soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","”Nique̱ soj si̱j naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ, si̱j fariseo do̱ꞌ ei. Quira̱nꞌ uxrá soj sayuun ado̱nj. Síí nucuiꞌ rá me nij soj na̱nj á. Dan me se sese vaa nuu xlá do̱ꞌ, coj eneldo do̱ꞌ, coj cominó do̱ꞌ, rihaan soj, ne̱ rqué soj ꞌo̱ nánj coj rihaan Diose̱ rihaan daj a̱ chi̱ꞌ nánj coj yoꞌ a. Tza̱j ne̱ nana̱ noco̱o doj ne ꞌyaj soj maꞌ. Ne aꞌneꞌ nica̱ soj cacunꞌ cheꞌé tuviꞌ soj maꞌ. Ne ꞌe̱e̱ rá soj tuviꞌ soj maꞌ. Ne uun nucua̱j rá tuviꞌ soj man soj maꞌ. Tza̱j ne̱ Diose̱ roꞌ, me rá quiꞌya̱j soj nu̱ꞌ nana̱ noco̱o nihánj, ne̱ naꞌvej rá Diose̱ ta̱náj xco̱ soj a̱ yoꞌó nana̱ leꞌe̱j doj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Dan me se ase vaa síí tuchri̱i vaa soj, tza̱j ne̱ me rá soj ti̱haa̱n soj rihaan yuvii̱ da̱j quiꞌya̱j yuvii̱ ado̱nj. Ase vaa síí rii nda̱a ꞌo̱ yacoo̱ leꞌe̱j rque na coꞌo̱ roꞌ, vaa soj, tza̱j ne̱ chumánj u̱u̱n soj cunu̱ꞌ xcuu camelló vaa gue̱e̱ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","”Nique̱ soj si̱j naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ, si̱j fariseo do̱ꞌ a. Quira̱nꞌ uxrá nij soj sayuun ado̱nj. Síí nucuiꞌ rá me nij soj na̱nj á. Dan me se ase vaa rasu̱u̱n, ne̱ sa̱ꞌ uxrá naꞌnuꞌ nii xráá yoꞌ, tza̱j ne̱ rque yoꞌ roꞌ, me se vaa nacaj gue̱e̱ yoꞌ, taꞌngaꞌ da̱nj vaa gue̱e̱ soj, ne̱ xráá soj me se veꞌé naruvii, tza̱j ne̱ nimán soj me se quij vaa, ne̱ niha̱ꞌ uxrá rá soj caꞌne̱e̱ soj siꞌyaj tuviꞌ soj, ne̱ taj se ꞌyáꞌ caꞌne̱ꞌ rá soj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ase vaa síí tuchri̱i vaa soj si̱j fariseo ei. Ase vaa ꞌyaj yuvii̱ naꞌnuꞌ rque rasu̱u̱n roꞌ, da̱nj quiꞌya̱j uún soj, naquiꞌya̱j sa̱ꞌ soj nimán soj á. Nda̱a síj, ga̱a ne̱ sa̱ꞌ ina̱nj quiꞌya̱j soj queneꞌe̱n yuvii̱ ei. ");
INSERT INTO trcNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","”Nique̱ soj si̱j naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ, si̱j fariseo do̱ꞌ a. Quira̱nꞌ uxrá nij soj sayuun ado̱nj. Síí nucuiꞌ rá me nij soj na̱nj á. Dan me se ase vaa chraan na̱j xnangá rihaan santó roꞌ, vaa soj, ne̱ xráá soj roꞌ, vaa catzi̱i̱, ne̱ veꞌé ndoꞌo ruviꞌ man soj, tza̱j ne̱ nimán soj me se adi̱ꞌ se vaa cúú riꞌyuj roꞌ, vaa nimán soj, ne̱ chiꞌi̱i̱ vaa nu̱ꞌ nimán soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Dan me se ase vaa síí nica̱ nimán vaa soj chéé soj niꞌya̱j yuvii̱, tza̱j ne̱ ꞌyaj yuve̱ ndoꞌo soj se chiꞌi̱i̱, ne̱ ne uno uxrá soj rihaan Diose̱ a̱ maꞌ. Ina̱nj da̱nj vaa nimán soj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","”Nique̱ soj si̱j naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ, si̱j fariseo do̱ꞌ a. Quira̱nꞌ uxrá soj sayuun ado̱nj. Síí nucuiꞌ rá me nij soj na̱nj á. Dan me se veꞌé uneꞌ soj chraan yan na̱j cúú man nij síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá do̱ꞌ, man nij síí vaa sa̱ꞌ cane ga̱a naá do̱ꞌ, ne̱ veꞌé tumé soj man chraan yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ne̱ taj soj se vaa sese cayáán soj ga̱ xi̱i soj nij síí ma̱n ga̱a naá roꞌ, ne̱ ne ticavi̱ꞌ soj man nij síí nataꞌ se‑na̱na̱ Diose̱ nda̱a vaa quiꞌyaj maꞌa̱n xi̱i soj a̱ maꞌ. Da̱nj aꞌmii soj, ");
INSERT INTO trcNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","taj xnaꞌanj maꞌa̱n soj se vaa ya̱ tuviꞌ nij síí ticaviꞌ man nij síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá me maꞌa̱n soj na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ne̱ ataa quisi̱j cacunꞌ quiꞌyaj nij tuviꞌ soj nij síí ma̱n ga̱a naá yoꞌ a. Tza̱j ne̱ ti̱síj soj cacunꞌ yoꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","”Ase vaa xcuáá yuva̱a̱ vaa soj, ne̱ taj se qui̱ꞌyáꞌ quinani̱i̱ soj rihaan sayuun quiꞌya̱j Diose̱ man soj maꞌ. Caca̱a̱ soj rihaan yaꞌan ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Cheꞌé dan xa̱ꞌ soj, tza̱j ne̱ caꞌne̱j ꞌu̱nj síí nata̱ꞌ se‑na̱na̱ Diose̱ caꞌne̱j ꞌu̱nj síí caꞌmi̱i̱ nana̱ cu̱u caꞌne̱j ꞌu̱nj síí tu̱cuꞌyón se‑na̱na̱ Diose̱ caꞌne̱j ꞌu̱nj rihaan soj, ga̱a ne̱ ticavi̱ꞌ soj man taꞌa̱j nij soꞌ, ne̱ cachro̱n soj man taꞌa̱j nij soꞌ rihaan rcutze̱, ne̱ go̱ꞌ soj cuartá xráá taꞌa̱j nij soꞌ, ne̱ cuna̱nj nij soꞌ rihaan soj, cu̱riha̱nj nij soꞌ ꞌo̱ chumanꞌ, ne̱ canoco̱ꞌ uxrá soj man nij soꞌ nda̱a ꞌó chumanꞌ uún, quiꞌya̱j soj vaa güii na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nda̱a síj, ga̱a ne̱ nu̱ꞌ ton cayanj man nij síí sa̱ꞌ rihaan Diose̱ rihaan chumii̱ nihánj roꞌ, nu̱ꞌ cacunꞌ yoꞌ roꞌ, nata̱ꞌ xráá nij soj a. Dan me se asi̱j ton cayanj man síí sa̱ꞌ cuꞌna̱j Abel ne̱ nda̱a ton cayanj man síí cuꞌna̱j Zacarías taꞌníí síí cuꞌna̱j Berequías ga̱a caviꞌ soꞌ rihaan nuvií yan nicu̱nꞌ chraan altar roꞌ, nu̱ꞌ cacunꞌ yoꞌ roꞌ, nata̱ꞌ xráá nij soj a. ");
INSERT INTO trcNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa quira̱nꞌ maꞌa̱n nij tuvi̱ꞌ nij soj sayuun cheꞌé nu̱ꞌ cacunꞌ yoꞌ ado̱nj ―taj Jesucristó rihaan nij síí fariseo do̱ꞌ, rihaan nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ga̱a ne̱ cataj uún Jesucristó a: ―Nanó uxrá raj cheꞌé soj si̱j ma̱n chumanꞌ Jerusalén nihánj na̱nj á. Dan me se ticaviꞌ soj man nij síí nataꞌ se‑na̱na̱ Diose̱, ne̱ goꞌ soj yahij man nij síí caꞌnéé Diose̱ cuchi̱ꞌ rihaan soj á. Guun queꞌe̱e̱ ndoꞌo guun rá ꞌu̱nj naquiꞌya̱j chre̱ꞌ ꞌu̱nj man soj cu̱tumé ꞌu̱nj man soj, tza̱j ne̱ taj se quiꞌyáꞌ caꞌve̱e maꞌ. Dan me se ase vaa ꞌyaj chuchee naquiꞌyaj chre̱ꞌ chuchee man taꞌníí xoꞌ ca̱ráán xoꞌ xcóó xoꞌ xráá taꞌníí xoꞌ roꞌ, da̱nj guun raj qui̱ꞌyáj man soj, tza̱j ne̱ ne caꞌve̱j rá soj qui̱ꞌyáj da̱nj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ya̱j me se cu̱tumé maꞌa̱n soj man soj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ꞌO̱ se cuano̱ nihánj me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa rej rihaan níꞌ roꞌ, se̱ queneꞌen uún soj manj maꞌ. Tza̱j ne̱ nda̱a güii caꞌna̱ꞌ uún ꞌu̱nj rihaan chumii̱ nihánj queneꞌe̱n soj manj, ne̱ cata̱j soj: “Veꞌé uxrá ꞌnaꞌ síí aꞌnéé síí ꞌni̱j raꞌa man níꞌ á”, cata̱j soj a ―taj Jesucristó niꞌya̱j soꞌ man nij síí ma̱n Jerusalén yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ga̱a ne̱ curiha̱nj Jesucristó nuvií noco̱o, caꞌanj soꞌ, ne̱ cuchiꞌ nij síí tucuꞌyón se‑na̱na̱ soꞌ rihaan soꞌ a. Guun rá nij soꞌ queneꞌe̱n Jesucristó da̱j vaa nij veꞌ ma̱n nuvií noco̱o yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Dan me se neꞌen soj nu̱ꞌ veꞌ ma̱n nuvií noco̱o nihánj naꞌ. Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa vaa güii, ne̱ cane̱e̱ nu̱ꞌ nuvií noco̱o nihánj, ne̱ a̱ ꞌó yuvej se̱ quitáá xráá tuviꞌ yuvej nihánj a̱ maꞌ ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Dan me se caꞌanj ca̱yáán Jesucristó raa̱ quij cuꞌna̱j Quij ma̱n Chruun Olivó, ne̱ cuchiꞌ o̱rúnꞌ nij síí tucuꞌyón se‑na̱na̱ soꞌ rihaan soꞌ, ne̱ cataj nij soꞌ: ―Cata̱j xnaꞌanj so̱ꞌ rihaan núj aman cane̱e̱ nu̱ꞌ nuvií noco̱o yoꞌ do̱ꞌ, a̱ me rasu̱u̱n caꞌna̱ꞌ qui̱ꞌyáá so̱ꞌ asa̱ꞌ quisíj caꞌna̱ꞌ so̱ꞌ queneꞌe̱n núj ne̱ quinavi̱j nu̱ꞌ chumii̱ nihánj, maestro ―taj nij soꞌ, xnáꞌanj nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ga̱a ne̱ cataj Jesucristó: ―Cu̱tumé ndoꞌo soj man soj se̱ gaa na̱nj tiha̱ꞌ yuꞌunj yuvii̱ man soj á. ");
INSERT INTO trcNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ꞌO̱ se caꞌna̱ꞌ uxrá yuvii̱ cata̱j: “ꞌU̱nj me síí caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun”, cata̱j nij soꞌ, ne̱ dan me se tiha̱ꞌ yuꞌunj uxrá nij soꞌ man tuviꞌ nij soꞌ na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","”Dan me se vaa güii, ne̱ queneꞌe̱n soj se vaa cunu̱ꞌ uxrá chumanꞌ ga̱ tuviꞌ chumanꞌ a. Ne̱ cuno̱ uxrá soj nana̱ se vaa unuꞌ chumanꞌ ma̱n ga̱nꞌ ga̱ tuviꞌ chumanꞌ yoꞌ a. Cu̱tumé soj man soj se̱ cuchuꞌviꞌ nimán soj maꞌ. Ma̱a̱n se vaa cheꞌé gu̱un sayuun yoꞌ rihaan chumii̱ nihánj ado̱nj. Tza̱j ne̱ asa̱ꞌ quisíj guun da̱nj, ga̱a ne̱ se̱ caꞌanj niꞌya̱ chumii̱ nihánj nu̱ꞌ orá maꞌ. ꞌO̱ se quina̱j chumii̱ nihánj doj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dan me se cunu̱ꞌ uxrá yuvii̱ ma̱n chumanꞌ noco̱o ga̱ yoꞌó chumanꞌ noco̱o, ne̱ cunu̱ꞌ gobiernó ga̱ tuviꞌ gobiernó a. Ne̱ cache̱n xꞌnaa cache̱n yuún noco̱o cache̱n queꞌe̱e̱ chumanꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nu̱ꞌ sayuun nihánj roꞌ, ase vaa guun cheꞌe̱ ꞌo̱ chana̱ veꞌee̱ rque noꞌ cuchru̱j noꞌ neꞌej roꞌ, da̱nj ga̱a̱ nu̱ꞌ sayuun nihánj na̱nj ei. Dan me se nu̱ꞌ neꞌen chana̱ veꞌee̱ rque yoꞌ, ne̱ neꞌen noꞌ doj a̱ quira̱nꞌ noꞌ sayuun rej riha̱a̱n, ne̱ ase uun rá chana̱ yoꞌ, da̱nj gu̱un rá soj ga̱a caꞌna̱ꞌ sayuun yoꞌ, gu̱un rá soj se vaa da̱j doj gu̱un uxrá sayuun rihaan chumii̱ nihánj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","”Ga̱a ne̱ caꞌa̱nj ni̱caj yuvii̱ man taꞌa̱j soj rihaan nij síí nica̱j suun, ne̱ quira̱nꞌ taꞌa̱j soj sayuun ne̱ cavi̱ꞌ taꞌa̱j soj na̱nj á. Ne̱ nachri̱ꞌ cunuda̱nj nij síí yaníj ni̱ꞌyaj nij soꞌ man soj, cheꞌé se me soj síí noco̱ꞌ manj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ga̱a ne̱ ta̱náj queꞌe̱e̱ tinúú soj chrej sa̱ꞌ, ne̱ ta̱cuachén tinúú soj síí tanáj chrej sa̱ꞌ man yoꞌó tinúú soj rihaan síí nica̱j suun, ne̱ nachri̱ꞌ uún tinúú soj síí tanáj chrej sa̱ꞌ man taꞌa̱j soj si̱j noco̱ꞌ manj na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ga̱a ne̱ caꞌna̱ꞌ uxrá síí nata̱ꞌ rihaan yuvii̱ se vaa si̱j nataꞌ se‑na̱na̱ Diose̱ me nij soꞌ, cata̱j nij soꞌ, tza̱j ne̱ caꞌmi̱i̱ ne̱ u̱u̱n nij soꞌ, ne̱ tiha̱ꞌ yuꞌunj uxrá nij soꞌ man yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ga̱a ne̱ xnaꞌa̱nj ndoꞌo se chiꞌi̱i̱ quiꞌya̱j yuvii̱, ne̱ caꞌne̱ꞌ rá nij yuvii̱ ga̱ suun noco̱ꞌ se‑na̱na̱ Diose̱, ne̱ cheꞌé dan ta̱náj uxrá nij síí noco̱ꞌ manj chrej sa̱ꞌ chrej ꞌe̱e̱ rá man tuviꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tza̱j ne̱ síí noco̱ꞌ raan manj nda̱a se caꞌa̱nj niꞌya̱ chumii̱ nihánj roꞌ, soꞌ me síí quinani̱i̱ rihaan sayuun ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ne̱ caꞌmi̱i̱ natáj yuvii̱ nana̱ sa̱ꞌ nihánj nana̱ cheꞌé güii gu̱un chij Diose̱ rihaan chumii̱ nihánj cuno̱ yuvii̱ ma̱n cunuda̱nj chumanꞌ ma̱n rihaan chumii̱, ne̱ xca̱j nij yuvii̱ cuentá cheꞌej, ga̱a ne̱ gu̱un cheꞌe̱ chumii̱ nihánj quinavi̱j chumii̱ nihánj na̱nj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ne̱ soj si̱j naya̱a̱ nana̱ nihánj nana̱ cachro̱nj rihaan yanj nihánj roꞌ, xca̱j uxrá soj cuentá me taj nana̱ nihánj nana̱ caꞌmii Jesucristó cheꞌé se chiꞌi̱i̱ á. Dan me se cataj uún Jesucristó: ―A̱j neꞌen soj se vaa cataj xnaꞌanj síí cuꞌna̱j Daniel síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá cheꞌé yoꞌo̱ se chiꞌi̱i̱ quiꞌya̱j ndoꞌo sayuun man yuvii̱, ne̱ dan me se güii queneꞌe̱n soj se chiꞌi̱i̱ yoꞌ rej gue̱e̱, ");
INSERT INTO trcNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ne̱ yoꞌo̱ cuna̱nj nij síí ma̱n estadó Judea caꞌa̱nj nij soꞌ raa̱ quij á. ");
INSERT INTO trcNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ne̱ síí ta̱j xráá veꞌ tucuá roꞌ, se̱ catúj soꞌ rá veꞌ tucuá soꞌ quiri̱i̱ soꞌ siꞌyaj soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ne̱ síí ꞌyaj suun tacaan roꞌ, se̱ canica̱j soꞌ nano̱ꞌ soꞌ saga̱nꞌ soꞌ tanáj soꞌ rihaan yoꞌóó maꞌ. Se̱ guun ra̱a̱n nij soꞌ maꞌ. Ma̱a̱n se yoꞌo̱ cuna̱nj nij soꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nique̱ chana̱ nu̱u̱ rque do̱ꞌ, chana̱ vaa taꞌníí neꞌej utzii do̱ꞌ, güii caꞌna̱ꞌ sayuun yoꞌ a. ꞌO̱ se se̱ guun nucua̱j chana̱ yoꞌ cuna̱nj chana̱ yoꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Cachi̱nj niꞌya̱j soj rihaan Diose̱ se vaa se̱ caꞌnaꞌ sayuun yoꞌ güii ga̱a̱ maa̱n do̱ꞌ, güii no̱ xcúún yuvii̱ nara̱a̱n rá yuvii̱ do̱ꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ꞌO̱ se güii caꞌna̱ꞌ sayuun roꞌ, qui̱j ndoꞌo gu̱un na̱nj á. Qui̱j doj ga̱a̱ sayuun yoꞌ rihaan nu̱ꞌ nij sayuun quiranꞌ yuvii̱ ga̱a nu̱ꞌ caꞌnaꞌ, ne̱ daj chiha̱a̱ míj se̱ quiranꞌ uún yuvii̱ sayuun vaa da̱nj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Sese queꞌe̱e̱ uxrá güii gu̱un sayuun, ne̱ se̱ quinanii yuvii̱ rihaan sayuun yoꞌ maꞌ. Tza̱j ne̱ vaa güii quisi̱j sayuun, quiꞌya̱j Diose̱, cheꞌé rej quinani̱i̱ nij síí narii soꞌ canoco̱ꞌ man soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","”Ne̱ güii yoꞌ me se sese cata̱j yuvii̱ rihaan soj: “Ni̱ꞌyaj so̱ꞌ ei. Nihánj ꞌnaꞌ síí ti̱nanii man níꞌ rihaan sayuun á”, ne̱ se̱ cuchumán rá soj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ꞌO̱ se caꞌna̱ꞌ uxrá síí ne̱ síí cata̱j se vaa síí ti̱nanii man yuvii̱ rihaan sayuun me nij soꞌ, ne̱ caꞌna̱ꞌ uxrá síí ne̱ síí cata̱j se vaa nataꞌ nij soꞌ se‑na̱na̱ Diose̱, ne̱ quiꞌya̱j nij soꞌ suun sa̱ꞌ noco̱o, ne̱ tiha̱ꞌ yuꞌunj nij soꞌ man cunuda̱nj nij yuvii̱ ma̱n rihaan chumii̱ na̱nj ado̱nj. Nda̱a nij síí narii Diose̱ man roꞌ, sese taj va̱j Diose̱ tu̱mé man nij soꞌ, ne̱ cuchuma̱n rá nij soꞌ ni̱ꞌyaj nij soꞌ man nij síí tihaꞌ yuꞌunj yoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nihánj me se cataj xnaꞌanj ꞌu̱nj rihaan soj da̱j gu̱un rihaan chumii̱ nihánj na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Cheꞌé dan me sese cata̱j yuvii̱ rihaan soj se vaa va̱j ꞌu̱nj rej quij, ne̱ se̱ caꞌanj soj rej quij nano̱ꞌ soj manj maꞌ. Ne̱ sese cata̱j yuvii̱ rihaan soj se vaa yáán ꞌu̱nj rá ꞌo̱ veꞌ, ne̱ se̱ cuchumán rá soj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Dan me se nda̱a rá se uun ga̱a raa̱n rej síj güii ne̱ ꞌo̱ chuguu̱n nu̱ꞌ xta̱ꞌ nda̱a rej ataꞌ güii roꞌ, ne̱ neꞌen cunuda̱nj yuvii̱ se vaa raa̱n rihaan chumii̱ a. Ne̱ ase uun rá soj neꞌen soj ga̱a raa̱n roꞌ, da̱nj gu̱un rá soj asa̱ꞌ caꞌnáꞌ ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱, ne̱ yoꞌo̱ queneꞌe̱n nu̱ꞌ yuvii̱ ma̱n rihaan chumii̱ nihánj se vaa caꞌnáꞌ ꞌu̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","A̱j neꞌen soj da̱j ꞌyaj yachrúú va̱j rej xta̱ꞌ, ne̱ neꞌen maꞌa̱n xoꞌ me rej na̱j nee̱ cha̱ xoꞌ a. Taj síí nataꞌ rihaan xoꞌ me rej na̱j nee̱ yoꞌ maꞌ. Ne̱ ase uun rá yachrúú roꞌ, da̱nj gu̱un rá maꞌa̱n soj asa̱ꞌ caꞌnaꞌ uún ꞌu̱nj rihaan chumii̱ nihánj ado̱nj. Queneꞌe̱n maꞌa̱n soj si̱j ma̱n rihaan chumii̱ nihánj me rej caꞌna̱ꞌ ꞌu̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","”Síj quiranꞌ yuvii̱ sayuun yoꞌ, ga̱a ne̱ gu̱un rmi̱ꞌ güii gu̱un rmi̱ꞌ yavii gu̱un rmi̱ꞌ, ne̱ cayu̱u nij yatiꞌ xta̱ꞌ ne̱ quina̱a̱n taranꞌ nij rasu̱u̱n nucua̱j ma̱n rej xta̱ꞌ do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ga̱a ne̱ vaa se curuvi̱ꞌ rej xta̱ꞌ queneꞌe̱n soj, ne̱ queneꞌe̱n soj se vaa da̱j doj caꞌna̱ꞌ uún ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ a. Ga̱a ne̱ cunuda̱nj nij síí ma̱n rihaan chumii̱ nihánj roꞌ, quinano̱ ndoꞌo rá maꞌa̱n nij soꞌ, ga̱a ne̱ queneꞌe̱n nij soꞌ mán ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ á. Dan me se xráá ngaa quita̱j ꞌu̱nj caꞌna̱ꞌ ꞌu̱nj, ne̱ gu̱un nucua̱j ndoꞌoj quiri̱i̱ taꞌngaj, ne̱ veꞌé uxrá curuvi̱j caꞌna̱j á. ");
INSERT INTO trcNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ga̱a ne̱ caꞌya̱nj nii chruun aꞌyánj, qui̱ꞌyáj, ne̱ caꞌne̱j ꞌu̱nj man nij se‑mo̱zó ꞌu̱nj caꞌna̱ꞌ nij soꞌ rihaan chumii̱ nihánj, ne̱ naquiꞌya̱j chre̱ꞌ nij se‑mo̱zó ꞌu̱nj man nij síí narii Diose̱ man canoco̱ꞌ manj a. Dan me se cache̱e̱ nij se‑mo̱zó ꞌu̱nj rihaan nu̱ꞌ chumii̱ nihánj, nano̱ꞌ nij soꞌ taranꞌ nij síí cunu̱u chre̱ꞌ ga̱ ꞌu̱nj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","”Tu̱cuꞌyón soj nana̱ nihánj nana̱ cheꞌé chruun ma̱n chruj higó raa̱ á. Ga̱a quisíj guun laru̱u raꞌa chruun, ne̱ naca coj yaꞌli̱j raa̱ chruun, ne̱ neꞌen soj se vaa nichru̱nꞌ ꞌnaꞌ dió nama̱n maa̱n a. ");
INSERT INTO trcNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Dan me se xca̱j uún soj cuentá se vaa asa̱ꞌ queneꞌen soj nu̱ꞌ se vaa cataj xnaꞌanj ꞌu̱nj rihaan soj cuano̱, ne̱ nichru̱nꞌ caꞌna̱ꞌ uún ꞌu̱nj na̱nj ado̱nj. Dan me se ase vaa síí nicu̱nꞌ taꞌyaa roꞌ, ga̱a̱ ꞌu̱nj ei. ");
INSERT INTO trcNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ quisi̱j nu̱ꞌ rasu̱u̱n nihánj nu̱ꞌ se vaa cataj xnaꞌanj ꞌu̱nj rihaan soj cuano̱ ei. Ne̱ ya̱ queneꞌe̱n soj nu̱ꞌ nihánj ga̱a ataa cavi̱ꞌ soj ei. ");
INSERT INTO trcNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Vaa güii caꞌa̱nj niꞌya̱ yoꞌóó do̱ꞌ, xta̱ꞌ do̱ꞌ, tza̱j ne̱ se‑na̱na̱j me se daj chiha̱a̱ míj se̱ quinavij yoꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","”Nihánj me cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa a̱ ꞌó síí ne neꞌen me güii caꞌna̱ꞌ uún ꞌu̱nj rihaan chumii̱ nihánj maꞌ. Caꞌve̱e se nda̱a se‑mo̱zó Diose̱ ꞌyaj suun rej xta̱ꞌ, caꞌve̱e se nda̱a ma̱ꞌanj taꞌni̱j Diose̱, tza̱j ne̱ ne neꞌen núj me güii me yoꞌ maꞌ. O̱rúnꞌ Réj me síí neꞌen na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ase vaa quiꞌyaj yuvii̱ ga̱a cayáán síí cuꞌna̱j Noé rihaan chumii̱ roꞌ, da̱nj ga̱a̱ quiꞌya̱j uún yuvii̱ asa̱ꞌ caꞌna̱ꞌ uún ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ rihaan chumii̱ nihánj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Dan me se ga̱a cayáán síí cuꞌna̱j Noé, ne̱ da̱j doj ca̱ráán na yaꞌa̱nj rihaan chumii̱, tza̱j ne̱ chá yuvii̱ do̱ꞌ, coꞌo yuvii̱ do̱ꞌ, ne̱ xcaj tuviꞌ nij yuvii̱ do̱ꞌ; ina̱nj da̱nj quiꞌyaj nij yuvii̱ nda̱a quisíj güii catúj nij tuvi̱ꞌ síí cuꞌna̱j Noé rque rihoo xi̱j chéé rihaan na a. ");
INSERT INTO trcNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ne̱ ne xca̱j nij yuvii̱ cuentá sese ca̱ráán na yaꞌa̱nj xráá nij soꞌ maꞌ. Ma̱a̱n se nda̱a quisíj caráán na yaꞌa̱nj xráá cunuda̱nj nij soꞌ, ne̱ da̱nj gaa xcaj nij soꞌ cuentá na̱nj á. Ne̱ ase vaa ne xca̱j nij yuvii̱ ma̱n ga̱a naá cuentá se vaa quira̱nꞌ nij soꞌ sayuun roꞌ, da̱nj ga̱a̱ uún yuvii̱ asa̱ꞌ quisíj caꞌna̱ꞌ uún ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ rihaan chumii̱ nihánj ado̱nj. ꞌO̱ se nda̱a síj güii queneꞌe̱n nij soꞌ manj, ga̱a ne̱ xca̱j nij soꞌ cuentá na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","”Ne̱ asa̱ꞌ quisíj güii yoꞌ, ne̱ cu̱nuû vi̱j ro̱j snóꞌo quiꞌya̱j suun ro̱j soꞌ yoꞌóó, ne̱ naca̱j se‑mo̱zó Diose̱ man yoꞌo̱ soꞌ, ne̱ quina̱j yoꞌó soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ne̱ cu̱nuû vi̱j ro̱j chana̱ ga̱j ro̱j noꞌ ꞌnúú trigó, ne̱ naca̱j se‑mo̱zó Diose̱ man yoꞌo̱ noꞌ, ne̱ quina̱j yoꞌó noꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Cheꞌé dan cu̱tumé uxrá soj man soj á. ꞌO̱ se ne neꞌen soj me güii caꞌna̱ꞌ síí ꞌni̱j raꞌa man soj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Dan me se sese ꞌo̱ síí tucua̱ veꞌ roꞌ, a̱j neꞌen soꞌ me orá caꞌna̱ꞌ síí itu̱u̱ ne̱ quiꞌya̱j itu̱u̱ síí itu̱u̱ rasu̱u̱n ma̱n tucuá soꞌ, ne̱ uxrá cutumé soꞌ tucuá soꞌ, ne̱ se̱ quiꞌyaj itu̱u̱ síí itu̱u̱ tucuá soꞌ tza̱j maꞌ. Ma̱a̱n se ne neꞌen soj me orá caꞌna̱ꞌ síí itu̱u̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Dan me se taꞌngaꞌ da̱nj vaa gue̱e̱ ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱, ne̱ ne neꞌen soj me orá caꞌna̱ꞌ uún ꞌu̱nj man ado̱nj. Cheꞌé dan yoꞌo̱ ni̱ꞌyaj soj á. ");
INSERT INTO trcNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","”Cheꞌé dan me sese cuneꞌ síí tucua̱ yoꞌo̱ veꞌ man yoꞌo̱ se‑mo̱zó soꞌ se vaa cu̱tumé mozó yoꞌ man tuviꞌ mozó rque̱ soꞌ se chá rihaan nij soꞌ orá chá nij soꞌ chraa, ne̱ da̱j quiꞌya̱j mozó yoꞌ, rá soj ga̱. Sese ya̱ ya̱ si̱j veꞌé ꞌyaj suun me soꞌ do̱ꞌ, sese ya̱ ya̱ si̱j avii raa̱ me soꞌ do̱ꞌ, ne̱ da̱j quiꞌya̱j soꞌ, rá soj ga̱. ");
INSERT INTO trcNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ga̱a ne̱ güii nama̱n se‑ruꞌve̱e̱ mozó roꞌ, sese queneꞌe̱n se‑ruꞌve̱e̱ mozó se vaa veꞌé ꞌyaj suun mozó se‑su̱u̱n ruꞌvee, ne̱ cavi̱i̱ sa̱ꞌ uxrá mozó yoꞌ, quiꞌya̱j se‑ruꞌve̱e̱ mozó yoꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa cune̱ꞌ ruꞌvee yoꞌ man mozó yoꞌ gu̱un soꞌ síí tumé man cunuda̱nj siꞌyaj ruꞌvee yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tza̱j ne̱ sese vaa chiꞌi̱i̱ nimán mozó yoꞌ, ne̱ gu̱un rá soꞌ se vaa guun ra̱a̱n ndoꞌo se‑ruꞌve̱e̱ soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ga̱a ne̱ gu̱un cheꞌe̱ soꞌ go̱ꞌ soꞌ man tuviꞌ soꞌ mozó, ne̱ cha̱ soꞌ coꞌo̱ soꞌ, ne̱ gu̱un xno̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Dan me se ne neꞌen soꞌ aman nama̱n se‑ruꞌve̱e̱ soꞌ a. Ne naꞌvi̱j soꞌ caꞌna̱ꞌ ruꞌvee a. Tza̱j ne̱ síj güii síj orá síj, ne̱ caꞌna̱ꞌ maꞌa̱n se‑ruꞌve̱e̱ mozó yoꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ga̱a ne̱ caꞌne̱ꞌ nu̱ꞌ soꞌ man mozó yoꞌ ne̱ cata̱j soꞌ se vaa caꞌa̱nj mozó yoꞌ rihaan yaꞌan ga̱ yoꞌó nij síí nucuiꞌ rá a. Ne̱ yuvii̱ ma̱n rihaan yaꞌan yoꞌ roꞌ, taꞌvee uxrá, ne̱ nda̱a chá ru̱j maꞌa̱n nij yuvii̱ cúú yanꞌ yuvii̱ ei. ");
INSERT INTO trcNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","”Ne̱ asa̱ꞌ caꞌnaꞌ uún ꞌu̱nj rihaan chumii̱ nihánj, ne̱ ase vaa chi̱ꞌ chana̱ ya̱a̱n roꞌ, da̱nj ga̱a̱ nij yuvii̱ me rá catu̱u̱ rihaan Diose̱ asa̱ꞌ guun chij Diose̱ á. Dan me se nica̱j nij chana̱ ya̱a̱n yoꞌ saga̱ꞌ nij noꞌ agaꞌ yaꞌan, ne̱ caꞌanj na̱ꞌvi̱j nij noꞌ man síí naraꞌa̱a a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Dan me se ꞌu̱nꞌ nij chana̱ ya̱a̱n yoꞌ roꞌ, me chana̱ niꞌyo̱n, ne̱ yuꞌunꞌ nij chana̱ ya̱a̱n yoꞌ roꞌ, me chana̱ nica̱j cuentá a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ꞌO̱ se nij chana̱ niꞌyo̱n yoꞌ roꞌ, nica̱j nij noꞌ saga̱ꞌ nij noꞌ agaꞌ yaꞌan, tza̱j ne̱ taj va̱j casté acaa nica̱j nij noꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ne̱ nij chana̱ nica̱j cuentá roꞌ, nij noꞌ me se nica̱j nij noꞌ saga̱ꞌ nij noꞌ agaꞌ yaꞌan do̱ꞌ, agaꞌ nu̱u̱ casté acaa do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Dan me se guun ra̱a̱n síí naraꞌa̱a, ne̱ caꞌnaꞌ nej rihaan taranꞌ nij chana̱ ya̱a̱n yoꞌ, ne̱ cotoj taranꞌ nij noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Guun ya̱nꞌ, ne̱ caguáj yuvii̱ cataj yuvii̱: “ꞌNaꞌ síí naraꞌa̱a ga̱ chana̱ ya̱a̱n ei. Cuva̱ꞌ soj nari̱ꞌ tuviꞌ soj ga̱ soꞌ ei”, cataj yuvii̱ rihaan chi̱ꞌ nij chana̱ ya̱a̱n yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ga̱a ne̱ cuno nij chana̱ ya̱a̱n, ne̱ raꞌya̱nj naxaga̱a̱ taranꞌ nij noꞌ, ne̱ naquiꞌyaj sa̱ꞌ nij noꞌ saga̱ꞌ nij noꞌ agaꞌ yaꞌan a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ne̱ cataj nij chana̱ niꞌyo̱n rihaan nij chana̱ nica̱j cuentá, ne̱: “Quiꞌya̱j soj do̱j se ndoꞌo, rque̱ soj do̱j casté acaa rihaan núj rugua̱nj. Quinaꞌáj saga̱ꞌ núj agaꞌ yaꞌan na̱nj achugua̱nj”, taj nij chana̱ niꞌyo̱n yoꞌ rihaan tuviꞌ noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ga̱a ne̱ tuviꞌ noꞌ chana̱ nica̱j cuentá me se cataj: “Ma̱a̱n se se̱ quisíj casté acaa caca̱a̱ rihaan taranꞌ níꞌ maꞌ. Caꞌa̱nj soj rej aneꞌ casté acaa, ne̱ quira̱a̱n soj man yoꞌ á”, taj nij chana̱ nica̱j cuentá yoꞌ rihaan nij chana̱ niꞌyo̱n a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Veé dan, ne̱ caꞌanj nij chana̱ niꞌyo̱n yoꞌ quira̱a̱n nij noꞌ casté acaa, ne̱ caꞌnaꞌ síí naraꞌa̱a, ne̱ nij chana̱ nica̱j cuentá me se ne cachi̱in casté acaa rihaan nij noꞌ maꞌ. Cheꞌé dan catúj nij noꞌ rá veꞌ canuû chaꞌanj ga̱ síí naraꞌa̱a, ne̱ caráán nii taꞌyaa yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Cachén doj orá, ga̱a ne̱ caꞌnaꞌ nij chana̱ niꞌyo̱n uún, ne̱ cataj nij noꞌ: “Caꞌnu̱u̱ so̱ꞌ taꞌyaa catu̱u̱ núj, socoj”, cataj nij noꞌ rihaan síí naraꞌa̱a a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ne̱ cataj síí naraꞌa̱a yoꞌ: “Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa ne neꞌén ꞌu̱nj man soj maꞌ”, taj soꞌ rihaan nij chana̱ niꞌyo̱n yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","”Cheꞌé dan cu̱tumé uxrá nij soj man soj á. ꞌO̱ se ne neꞌen soj me güii caꞌna̱ꞌ ꞌu̱nj ne neꞌen soj me orá caꞌna̱ꞌ ꞌu̱nj ne neꞌen soj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","”ꞌO̱ se güii caꞌna̱ꞌ ꞌu̱nj me se ase vaa quiꞌyaj yoꞌo̱ ruꞌvee ga̱ se‑mo̱zó ruꞌvee roꞌ, da̱nj ga̱a̱ qui̱ꞌyáj ga̱ soj si̱j noco̱ꞌ manj ado̱nj. Dan me se guun rá ruꞌvee yoꞌ caꞌa̱nj soꞌ yoꞌó chumanꞌ, ne̱ canacúún soꞌ man nij se‑mo̱zó soꞌ, ne̱ racuíj soꞌ se‑saꞌa̱nj soꞌ rihaan nij mozó yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Dan me se rihaan yoꞌo̱ soꞌ racuíj soꞌ ꞌu̱nꞌ saꞌanj noco̱o uxrá cuꞌna̱j talento a. Rihaan yoꞌó soꞌ racuíj soꞌ vi̱j saꞌanj talento a. Ne̱ rihaan yoꞌó soꞌ racuíj soꞌ yoꞌo̱ saꞌanj talento a. Da̱nj quiꞌyaj soꞌ, racuíj soꞌ saꞌanj rihaan ꞌo̱ ꞌo̱ nij se‑mo̱zó soꞌ, ne̱ rihaan ꞌo̱ ꞌo̱ mozó yoꞌ racuíj soꞌ nda̱a vaa gu̱un nucua̱j mozó tinaca̱ mozó yoꞌ a. Dan me se me rá soꞌ quiꞌya̱j suun ꞌo̱ ꞌo̱ mozó tinaca̱ ꞌo̱ ꞌo̱ mozó saꞌanj rqué soꞌ rihaan mozó yoꞌ, ne̱ cheꞌé dan quiꞌyaj soꞌ da̱nj a. Ne̱ cavii soꞌ, caꞌanj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","”Síj caꞌanj soꞌ, ne̱ cavii síí nica̱j ꞌu̱nꞌ saꞌanj talento caꞌanj soꞌ, ne̱ quiꞌyaj suun soꞌ, ne̱ quisíj, ga̱a ne̱ quiꞌyaj canaán soꞌ yuꞌunꞌ saꞌanj talento ga̱ saꞌanj uún a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ne̱ ase vaa quiꞌyaj soꞌ roꞌ, da̱nj vaa quiꞌyaj síí nica̱j vi̱j saꞌanj talento uún, ne̱ quiꞌyaj canaán soꞌ yavíj saꞌanj talento uún a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tza̱j ne̱ síí quiriꞌ ꞌo̱ saꞌanj talento yoꞌ me se cavii soꞌ caꞌanj soꞌ, ne̱ gáán soꞌ ꞌo̱ yuꞌuj, ne̱ caxríj yuve̱ soꞌ man saꞌanj racuíj ruꞌvee rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","”Veé dan, ne̱ guun ra̱a̱n uxrá, ne̱ namán se‑ruꞌve̱e̱ vaꞌnu̱j nij mozó, ne̱ xnáꞌanj ruꞌvee man ꞌo̱ ꞌo̱ nij soꞌ da̱j quiꞌyaj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ne̱ cuchiꞌ síí nica̱j ꞌu̱nꞌ saꞌanj talento rihaan ruꞌvee, ne̱ rqué soꞌ chi̱ꞌ saꞌanj talento man se‑ruꞌve̱e̱ soꞌ, cataj soꞌ: “ꞌU̱nꞌ saꞌanj talento racuíj so̱ꞌ manj, señor. Ne̱ ya̱j roꞌ, nuu yoꞌ chi̱ꞌ saꞌanj talento, quiꞌyáj na̱nj á”, taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ne̱ cataj ruꞌvee yoꞌ rihaan se‑mo̱zó soꞌ: “Cuna̱j uxrá vaa quiꞌyáá so̱ꞌ ei. Mozó sa̱ꞌ mé so̱ꞌ, ne̱ ga̱a̱ nucua̱j raj mán so̱ꞌ ado̱nj. Veꞌé cutumé so̱ꞌ man do̱j siꞌyáj á. Cheꞌé dan, ne̱ ya̱j ca̱né so̱ꞌ tu̱mé so̱ꞌ noco̱o doj siꞌyáj á. Cuva̱ꞌ so̱ꞌ ca̱yáán so̱ꞌ ga̱ ꞌu̱nj, ne̱ veꞌé ca̱yáán níꞌ na̱nj ei”, taj soꞌ rihaan se‑mo̱zó soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","”Ga̱a ne̱ cuchiꞌ síí nica̱j vi̱j saꞌanj talento uún, ne̱ cataj soꞌ: “Racuíj so̱ꞌ vi̱j saꞌanj talento rihanj, señor. Ne̱ ya̱j, ne̱ nuu yoꞌ caꞌa̱nj saꞌanj talento, quiꞌyáj na̱nj á”, taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ne̱ cataj ruꞌvee yoꞌ rihaan soꞌ: “Cuna̱j uxrá vaa quiꞌyáá so̱ꞌ ei. Mozó sa̱ꞌ mé so̱ꞌ uún, ne̱ ga̱a̱ nucua̱j raj mán so̱ꞌ uún ado̱nj. Veꞌé cutumé so̱ꞌ man do̱j siꞌyáj, ne̱ cheꞌé dan ya̱j ca̱né so̱ꞌ tu̱mé so̱ꞌ noco̱o doj siꞌyáj ya̱ ei. Cuva̱ꞌ so̱ꞌ, ca̱yáán so̱ꞌ ga̱ ꞌu̱nj, ne̱ veꞌé ca̱yáán níꞌ ya̱ ei”, taj ruꞌvee yoꞌ rihaan yoꞌó se‑mo̱zó soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","”Veé dan, ne̱ cuchiꞌ síí nica̱j yoꞌo̱ saꞌanj talento uún rihaan se‑ruꞌve̱e̱ soꞌ, ne̱ cataj soꞌ: “Neꞌén ꞌu̱nj se vaa si̱j sca̱ꞌ ndoꞌo nimán mé so̱ꞌ, señor. Neꞌén ꞌu̱nj se vaa yoꞌó yuvii̱ unô ꞌnúú, ne̱ ma̱ꞌán so̱ꞌ me síí rii u̱u̱n naa̱ na̱nj ado̱nj. Ne̱ yoꞌó yuvii̱ narii squíj man ꞌnúú trigó, ꞌyáá so̱ꞌ, ne̱ ma̱ꞌán so̱ꞌ naranꞌ u̱u̱n man ꞌnúú trigó sa̱ꞌ yoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Cheꞌé dan cuchuꞌvíꞌ ꞌu̱nj, ne̱ caꞌanj ꞌu̱nj, ne̱ caxríj yuve̱ ꞌu̱nj se‑saꞌa̱nj so̱ꞌ rque yoꞌóó na̱nj ado̱nj. Dan me se naca̱j gue̱e̱ uún so̱ꞌ se‑saꞌa̱nj so̱ꞌ na̱nj ei”, taj mozó yoꞌ rihaan ruꞌvee a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ne̱ cataj ruꞌvee yoꞌ rihaan mozó: “Mozó chiꞌi̱i̱ nimán do̱ꞌ, mozó rmi̱i̱ do̱ꞌ, mé so̱ꞌ ei. Se da̱nj neꞌén so̱ꞌ se vaa yoꞌó yuvii̱ unô ꞌnúú, ne̱ ma̱ꞌanj rii naa̱, ne̱ neꞌén so̱ꞌ se vaa yoꞌó yuvii̱ narii squíj man ꞌnúú trigó, ne̱ ꞌu̱nj naranꞌ ꞌnúú trigó sa̱ꞌ yoꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ne̱ me cheꞌé ne ta̱cuachén so̱ꞌ se‑saꞌa̱nj ꞌu̱nj rihaan nij síí nutaꞌ raa̱ saꞌanj ga̱. Ga̱a ne̱ asa̱ꞌ ꞌnáꞌ ꞌu̱nj, ne̱ nica̱j ꞌu̱nj se‑saꞌa̱nj ꞌu̱nj ga̱ saꞌanj nataꞌ raa̱ yoꞌ ga̱”, taj ruꞌvee yoꞌ rihaan yoꞌó mozó yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","”Ne̱ caꞌmii uún ruꞌvee yoꞌ rihaan yoꞌó nij se‑mo̱zó soꞌ, cataj soꞌ: “Caꞌne̱e̱ soj saꞌanj nica̱j mozó chiꞌi̱i̱ nihánj, ne̱ ta̱cuachén soj rihaan síí nica̱j chi̱ꞌ saꞌanj talento á. ");
INSERT INTO trcNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ꞌO̱ se síí neꞌen sa̱ꞌ quiꞌya̱j suun rihanj me se vaa güii, ne̱ doj a̱ gu̱un nucua̱j soꞌ quiꞌya̱j suun soꞌ rihanj ado̱nj. Ne̱ síí ne neꞌen quiꞌya̱j suun rihanj me se caꞌne̱e̱ ꞌu̱nj suun leꞌe̱j nii ata̱ soꞌ, ne̱ quina̱j u̱u̱n soꞌ, qui̱ꞌyáj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ne̱ mozó chiꞌi̱i̱ yoꞌ me se taj se uun soꞌ rihanj maꞌ. Quiriꞌi̱j soj man soꞌ xeꞌ rej rmi̱ꞌ á. Ne̱ yuvii̱ ma̱n rej rmi̱ꞌ yoꞌ me se taꞌvee uxrá ne̱ nda̱a chá ru̱j maꞌa̱n nij yuvii̱ cúú yanꞌ nij soꞌ na̱nj ado̱nj”, taj ruꞌvee rihaan yoꞌó nij se‑mo̱zó soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","”Dan me se síí caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ mé ꞌu̱nj, ne̱ caꞌna̱ꞌ uún ꞌu̱nj rihaan chumii̱ nihánj, ne̱ veꞌé uxrá ga̱a̱ caꞌna̱ꞌ ꞌu̱nj, ne̱ caꞌna̱ꞌ cunuda̱nj nij se‑mo̱zó ꞌu̱nj, ne̱ asa̱ꞌ caꞌnáꞌ ꞌu̱nj, ne̱ quita̱j ꞌu̱nj rihaan xrúún ꞌu̱nj chruun xlá sa̱ꞌ, ne̱ caꞌne̱ꞌ ꞌu̱nj cacunꞌ cheꞌé yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dan me se naquiꞌya̱j chre̱ꞌ nij se‑mo̱zó ꞌu̱nj man cunuda̱nj nij yuvii̱ ma̱n rihaan chumii̱, ne̱ canicu̱nꞌ nij yuvii̱ rihaan ꞌu̱nj, ne̱ cuxra̱ꞌ taꞌa̱j ꞌu̱nj man nij yuvii̱, ne̱ dan me se ase vaa ꞌyaj síí tumé matzinj uxraꞌ taꞌa̱j soꞌ man nij matzinj ga̱ nij tana roꞌ, da̱nj ga̱a̱ qui̱ꞌyáá ꞌu̱nj, cuxra̱ꞌ taꞌa̱j ꞌu̱nj man nij yuvii̱ yoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Dan me se nij síí sa̱ꞌ roꞌ, ase vaa matzinj ga̱a̱ nij soꞌ rihanj, ne̱ cache̱n nij soꞌ canicu̱nꞌ nij soꞌ rej nuva̱ꞌ ꞌu̱nj, ne̱ nij síí chiꞌi̱i̱ roꞌ, ase vaa tana ga̱a̱ nij soꞌ rihanj, ne̱ cache̱n nij soꞌ canicu̱nꞌ nij soꞌ rej ni̱chruún ꞌu̱nj a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","”Ne̱ guún ꞌu̱nj síí nica̱j suun rey, quiri̱i̱ taꞌngáꞌ ꞌu̱nj rihaan nij soꞌ, ne̱ dan me se caꞌmi̱i̱ ꞌu̱nj rihaan nij síí nicu̱nꞌ rej nuva̱ꞌ ꞌu̱nj, cata̱j ꞌu̱nj: “Cuva̱ꞌ soj ei. Niha̱ꞌ uxrá rá Réé ꞌu̱nj niꞌya̱j soꞌ man soj á. Dan me se asi̱j quiꞌyaj Réé ꞌu̱nj man chumii̱ nihánj, ne̱ cachrón soꞌ güii gu̱un chij maꞌa̱n soj rihaan chumii̱ nihánj a. Cheꞌé dan caꞌna̱ꞌ soj, ne̱ naca̱j soj nu̱ꞌ se sa̱ꞌ quiꞌyaj Réj á. ");
INSERT INTO trcNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ꞌO̱ se ga̱a naá, ne̱ quinaꞌaan rquej, ne̱ rqué soj se chaj á. Ne̱ nacoó ꞌu̱nj na, ne̱ rqué soj na coꞌo̱j á. Ne̱ ase vaa síí ꞌnaꞌ yoꞌó chumanꞌ vaa ꞌu̱nj rihaan soj, tza̱j ne̱ veꞌé caꞌmii soj ga̱j a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tachrinj u̱u̱n vaa saga̱nꞌ ꞌu̱nj, tza̱j ne̱ rqué soj yatzíj manj á. Ne̱ canó chiꞌii̱ manj, ne̱ cuchiꞌ soj rej náj, ne̱ taj yaꞌanj soj manj á. Quiꞌnij ꞌu̱nj tagaꞌ, ne̱ cuchiꞌ soj tagaꞌ, ne̱ caꞌmii soj ga̱j ado̱nj”, cata̱j ꞌu̱nj rihaan nij síí nicu̱nꞌ rej nuva̱ꞌ ꞌu̱nj a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","”Ga̱a ne̱ caꞌmi̱i̱ nij síí sa̱ꞌ yoꞌ rihanj, cata̱j nij soꞌ: “Aman queneꞌen núj se vaa naꞌaan rqué so̱ꞌ, ne̱ rqué núj se chá so̱ꞌ, Señor. Aman queneꞌen núj se vaa nacoó so̱ꞌ na, ne̱ rqué núj na coꞌo so̱ꞌ ga̱. ");
INSERT INTO trcNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Aman ase vaa síí ꞌnaꞌ yoꞌó chumanꞌ vaa so̱ꞌ rihaan núj, ne̱ caꞌmii núj ga̱ so̱ꞌ ga̱. Aman queneꞌen núj se vaa tachrinj u̱u̱n vaa saga̱nꞌ so̱ꞌ, ne̱ rqué núj yatzíj cu̱nuû so̱ꞌ ga̱. ");
INSERT INTO trcNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Aman queneꞌen núj se vaa canó chiꞌii̱ mán so̱ꞌ do̱ꞌ, se vaa catúj so̱ꞌ tagaꞌ do̱ꞌ, ne̱ cuchiꞌ núj racuíj núj mán so̱ꞌ ga̱”, cata̱j nij síí sa̱ꞌ, xna̱ꞌanj nij soꞌ manj a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","”Ga̱a ne̱ cata̱j ꞌu̱nj rihaan nij soꞌ: “Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa racuíj ndoꞌo soj man nij tinúú ꞌu̱nj ga̱a quiranꞌ nij soꞌ sayuun vaa da̱nj á. Nda̱ꞌ se síí nica̱ꞌ ndoꞌo me taꞌa̱j nij soꞌ, tza̱j ne̱ racuíj ndoꞌo soj man nij soꞌ, ne̱ cheꞌé se racuíj ndoꞌo soj man tinúú ꞌu̱nj, ne̱ cheꞌé dan nuchruj ꞌu̱nj cuentá se vaa me soj síí racuíj man ma̱ꞌanj ado̱nj”, cata̱j ꞌu̱nj rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","”Ga̱a ne̱ cata̱j ꞌu̱nj rihaan nij síí nicu̱nꞌ rej ni̱chruún ꞌu̱nj a: “Naxu̱u̱n soj man soj rihanj ei. Ma̱a̱n se cataj ya̱ Diose̱ se vaa ina̱nj sayuun quira̱nꞌ soj, caꞌa̱nj soj rihaan yaꞌan, caca̱a̱ soj nu̱ꞌ cavii nu̱ꞌ caꞌanj na̱nj á. Dan me se quiꞌyaj Diose̱ yaꞌan yoꞌ caca̱a̱ síí chre̱e caca̱a̱ nij nana̱ chre̱e caca̱a̱, ne̱ caca̱a̱ nij soj caca̱a̱ ga̱ soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ꞌO̱ se quinaꞌaan rquej ga̱a naá, tza̱j ne̱ ne rque̱ soj a̱ doj se chá cha̱j maꞌ. Nacoó ꞌu̱nj na, tza̱j ne̱ ne rque̱ soj a̱ doj na coꞌo̱j maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ase vaa síí ꞌnaꞌ yoꞌó chumanꞌ vaa ꞌu̱nj rihaan soj, tza̱j ne̱ ne caꞌmi̱i̱ soj ga̱j maꞌ. Tachrinj u̱u̱n nuû ꞌu̱nj, tza̱j ne̱ ne rque̱ soj a̱ doj yatzíj maꞌ. Canó chiꞌii̱ manj do̱ꞌ, quiꞌnij ꞌu̱nj tagaꞌ do̱ꞌ, tza̱j ne̱ a̱ ꞌó güii ne cuchi̱ꞌ soj rihanj maꞌ”, cata̱j ꞌu̱nj rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","”Ga̱a ne̱ cata̱j maꞌa̱n nij síí chiꞌi̱i̱ yoꞌ: “Aman queneꞌen núj mán so̱ꞌ se vaa naꞌaan rqué so̱ꞌ do̱ꞌ, se vaa nacoó so̱ꞌ na do̱ꞌ, se vaa ase vaa síí caꞌnaꞌ yoꞌó chumanꞌ vaa so̱ꞌ do̱ꞌ, se vaa achiin yatzíj cu̱nuû so̱ꞌ do̱ꞌ, se vaa canó chiꞌii̱ mán so̱ꞌ do̱ꞌ, se vaa quiꞌnij so̱ꞌ tagaꞌ do̱ꞌ, ne̱ ne ra̱cuíj núj mán so̱ꞌ, Señor”, cata̱j nij soꞌ, xna̱ꞌanj nij soꞌ manj a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","”Ga̱a ne̱ cata̱j ꞌu̱nj rihaan nij soꞌ: “Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa a̱ ꞌó xcoꞌ ne ra̱cuíj soj man nij tinúú ꞌu̱nj ga̱a quiranꞌ nij soꞌ sayuun vaa da̱nj maꞌ. Ne̱ nda̱ꞌ se síí nica̱ꞌ ndoꞌo me taꞌa̱j nij soꞌ, tza̱j ne̱ no̱ xcúún nij soj ra̱cuíj soj man nij soꞌ ado̱nj. Ne̱ cheꞌé se ne ra̱cuíj soj man nij soꞌ roꞌ, cheꞌé dan nuchruj ꞌu̱nj cuentá se vaa nuveé si̱j racuíj manj me soj maꞌ”, cata̱j ꞌu̱nj rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","”Ga̱a ne̱ cavi̱i̱ nij soꞌ caꞌa̱nj nij soꞌ, ne̱ quira̱nꞌ ndoꞌo nij soꞌ sayuun nu̱ꞌ cavii nu̱ꞌ caꞌanj, tza̱j ne̱ nij síí sa̱ꞌ roꞌ, veꞌé ca̱yáán nij soꞌ ga̱ Diose̱ nu̱ꞌ cavii nu̱ꞌ caꞌanj na̱nj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Síj cataj xnaꞌanj Jesucristó nu̱ꞌ nana̱ yoꞌ, ga̱a ne̱ caꞌmii uún soꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ, cataj soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Neꞌen soj se vaa cache̱n vi̱j güii, ga̱a ne̱ ca̱nuû chaꞌanj pascuá, ne̱ ta̱cuachén nii manj rihaan nij síí cachro̱n manj rihaan rcutze̱ na̱nj ado̱nj. Da̱nj quiꞌya̱j nij soꞌ, cheꞌé se síí caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ mej a ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ga̱a ne̱ cunuu chre̱ꞌ nij xrej ata̱ suun noco̱o doj do̱ꞌ, nij síí uun chij do̱ꞌ, rihaan veꞌ xi̱j tucuá xrej ata̱ suun noco̱o doj síí cuꞌna̱j Caifás a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ne̱ ꞌo̱ guun rá cunuda̱nj nij soꞌ se vaa tiha̱ꞌ yuꞌunj nij soꞌ man Jesucristó, ne̱ qui̱taꞌaa yuve̱ nij soꞌ man Jesucristó, ne̱ cavi̱ꞌ Jesucristó, quiꞌya̱j nij soꞌ, rá nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tza̱j ne̱ cataj nij soꞌ: ―Se̱ quitaꞌaa níꞌ man soꞌ ga̱a aman anuû chaꞌanj maꞌ. Ma̱a̱n se sese da̱nj quiꞌya̱j níꞌ, ne̱ caꞌma̱an rá nij yuvii̱, ne̱ gu̱un sayuun, quiꞌya̱j nij yuvii̱ na̱nj ado̱nj ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Dan me se yáán Jesucristó chumanꞌ cuꞌna̱j Betania, ne̱ ne̱ soꞌ rá ꞌo̱ veꞌ tucuá síí cuꞌna̱j Simón síí canó luj riꞌyuj man, ");
INSERT INTO trcNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ne̱ yáán Jesucristó rihaan mesá, ne̱ cuchiꞌ yoꞌo̱ chana̱ rihaan soꞌ, ne̱ nica̱j chana̱ yoꞌo̱ agaꞌ catzi̱i̱ nu̱u̱ casté gunꞌ da̱j, ne̱ casté tuꞌve̱e̱ ndoꞌo me yoꞌ a. Ga̱a ne̱ caxríj chana̱ casté raa̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ne̱ caꞌmaan rá nij síí tucuꞌyón se‑na̱na̱ Jesucristó, ne̱ cataj nij soꞌ: ―Me cheꞌé tiriꞌ rmaꞌa̱n chana̱ nihánj casté sa̱ꞌ ga̱. ");
INSERT INTO trcNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Me cheꞌé ne cutuꞌve̱e̱ noꞌ casté, ne̱ quiri̱ꞌ uxrá noꞌ saꞌanj, ne̱ go̱ꞌ noꞌ saꞌanj yoꞌ man síí nique̱ ga̱ ―cataj nij soꞌ, niꞌya̱j nij soꞌ man chana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ne̱ queneꞌen Jesucristó da̱j vaa caꞌmii nij soꞌ, ne̱ cataj soꞌ rihaan nij soꞌ a: ―Me cheꞌé aꞌmii soj da̱nj niꞌya̱j soj man chana̱ ga̱. ꞌO̱ se veꞌé uxrá vaa quiꞌyaj noꞌ manj á. ");
INSERT INTO trcNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ꞌO̱ se síí nique̱ me se daj a̱ güii mán nij síí nique̱ ga̱ soj, ne̱ caꞌve̱e quiꞌya̱j soj da̱nj ga̱ síí nique̱ ei. Tza̱j ne̱ ꞌu̱nj me se vaa güii caꞌa̱nj ꞌu̱nj, ne̱ quina̱j u̱u̱n soj, ne̱ se̱ caꞌvee quiꞌya̱j soj se lu̱j cheꞌej maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Dan me se caxríj chana̱ nihánj casté raj, ne̱ cheꞌé dan neꞌen soj se vaa cachi̱nꞌ nii manj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa me rej maꞌa̱n caꞌmi̱i̱ natáj yuvii̱ se‑na̱na̱j nana̱ sa̱ꞌ rihaan nij yuvii̱ ma̱n rihaan nu̱ꞌ chumii̱ nihánj roꞌ, ne̱ cata̱j xnaꞌanj uún nij yuvii̱ rihaan tuviꞌ yuvii̱ cheꞌé se vaa quiꞌyaj chana̱ nihánj manj, ne̱ se̱ quiniꞌyón yuvii̱ man chana̱ nihánj maꞌ ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ga̱a ne̱ cavii síí cuꞌna̱j Judas Iscariote, caꞌanj soꞌ rihaan nij xrej ata̱ suun noco̱o doj a. Dan me se yoꞌo̱ tuviꞌ chuvi̱j nij síí tucuꞌyón se‑na̱na̱ Jesucristó me síí cuꞌna̱j Judas yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Dan me se cataj soꞌ rihaan nij xrej a: ―A̱ me se rque̱ soj manj, ne̱ ra̱cuíj ꞌu̱nj man soj ta̱cuachén ꞌu̱nj man Jesucristó rihaan soj ga̱ ―taj soꞌ, xnáꞌanj soꞌ man nij xrej a. Ne̱ goꞌ nij soꞌ ico̱ chi̱ꞌ saꞌanj platá catzi̱i̱ man síí cuꞌna̱j Judas yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ga̱a ne̱ guun cheꞌe̱ síí cuꞌna̱j Judas nuchruj ra̱a̱ soꞌ aman gu̱un nucua̱j soꞌ ra̱cuíj soꞌ man nij xrej ata̱ suun noco̱o doj, ta̱cuachén soꞌ man Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ne̱ güii canuû chaꞌanj pascuá roꞌ, cuchiꞌ nij síí tucuꞌyón se‑na̱na̱ Jesucristó rihaan Jesucristó, ne̱ xnáꞌanj nij soꞌ man soꞌ, cataj nij soꞌ: ―Me rej quiꞌya̱j chuvi̱i núj cha̱ xtiꞌno̱ níꞌ chaꞌanj pascuá, rá so̱ꞌ ga̱ ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ne̱ cataj xnaꞌanj Jesucristó rihaan nij soꞌ se vaa catu̱u̱ nij soꞌ chumanꞌ Jerusalén, ne̱ cuchi̱ꞌ nij soꞌ rihaan yoꞌo̱ soꞌ, ne̱ caꞌmi̱i̱ nij soꞌ nana̱ nihánj rihaan soꞌ a: “Taj xnaꞌanj maestró rihaan so̱ꞌ se vaa da̱j doj quisi̱j se‑ora̱ soꞌ a. Ne̱ cha̱ xtiꞌno̱ soꞌ do̱ꞌ, nij síí tucuꞌyón se‑na̱na̱ soꞌ do̱ꞌ, chaꞌanj pascuá tucuá so̱ꞌ á”, cata̱j nij soꞌ rihaan síí ne̱ chumanꞌ yoꞌ, taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Dan me se quiꞌyaj nij síí tucuꞌyón se‑na̱na̱ Jesucristó nda̱a vaa cataj xnaꞌanj Jesucristó rihaan nij soꞌ, ne̱ quiꞌyaj chuvi̱i nij soꞌ cha̱ xtiꞌno̱ nij soꞌ chaꞌanj pascuá a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ne̱ rej tiꞌnuu, ne̱ cayáán Jesucristó ga̱ chuvi̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ rihaan mesá a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ne̱ ga̱a chá nij soꞌ chraa, ne̱ cataj Jesucristó: ―Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa ta̱cuachén yoꞌo̱ tuviꞌ soj manj rihaan nij síí ta̱j riꞌyunj manj ei ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ga̱a ne̱ quinanó ndoꞌo rá nij síí tucuꞌyón se‑na̱na̱ Jesucristó, ne̱ guun cheꞌe̱ nij soꞌ nda̱a ꞌo̱ ꞌo̱ nij soꞌ xnáꞌanj man Jesucristó, cataj ꞌo̱ ꞌo̱ nij soꞌ: ―ꞌU̱nj me síí quiꞌya̱j da̱nj niꞌ, Señorꞌ ―taj ꞌo̱ ꞌo̱ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ga̱a ne̱ cataj Jesucristó: ―Síí tiguíj rachrúún ga̱ ꞌu̱nj rá coꞌoo roꞌ, soꞌ me síí ta̱cuachén manj rihaan nij síí ta̱j riꞌyunj manj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ꞌO̱ se taj danj Diose̱ se vaa caꞌa̱nj ꞌu̱nj cavi̱ꞌ ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ ne̱ ya̱ da̱nj qui̱ránꞌ ꞌu̱nj ado̱nj. Tza̱j ne̱ nique̱ ndoꞌo síí ta̱cuachén manj rihaan nij síí ta̱j riꞌyunj manj na̱nj á. Quira̱nꞌ uxrá soꞌ sayuun na̱nj á. Snóꞌo yoꞌ me se sese ne caꞌnga̱a̱ soꞌ, ne̱ cavii sa̱ꞌ soꞌ doj tza̱j ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ne̱ síí cuꞌna̱j Judas síí me rá ta̱cuachén man Jesucristó rihaan nij síí ta̱j riꞌyunj man Jesucristó me se xnáꞌanj soꞌ man Jesucristó, cataj soꞌ: ―ꞌU̱nj me síí quiꞌya̱j da̱nj niꞌ, maestroꞌ ―taj maꞌa̱n soꞌ, xnáꞌanj maꞌa̱n soꞌ man Jesucristó uún a. ―Ya̱ uxrá cataj so̱ꞌ, veé so̱ꞌ quiꞌya̱j da̱nj ei ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ne̱ ga̱a chá nij soꞌ chraa ne̱ quitaꞌaa Jesucristó yoꞌo̱ rachrúún, ne̱ nagoꞌ soꞌ graciá rihaan Diose̱, ne̱ cuxraꞌ taꞌa̱j soꞌ rachrúún, ne̱ rqué soꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ cataj soꞌ: ―Qui̱taꞌaa soj rachrúún nihánj, cha̱ soj man yoꞌ á. Nee̱ manj me rachrúún nihánj ei ―taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ga̱a ne̱ quitaꞌaa Jesucristó agaꞌ tazá nu̱u̱ na vinó, ne̱ nagoꞌ soꞌ graciá rihaan Diose̱, ne̱ tacuachén soꞌ agaꞌ nu̱u̱ na vinó rihaan nij soꞌ, ne̱ cataj soꞌ: ―Coꞌo̱ taranꞌ soj na vinó nihánj á. ");
INSERT INTO trcNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ꞌO̱ se ton manj me na nihánj, ne̱ cheꞌé ton manj roꞌ, rqué Diose̱ ꞌo̱ nana̱ rihaan soj da̱j quiꞌya̱j Diose̱ ga̱ soj a. Dan me se cheꞌé se caya̱nj ton manj roꞌ, cheꞌé dan me cara̱a̱ xꞌnaa Diose̱ ni̱ꞌyaj Diose̱ cacunꞌ tumé queꞌe̱e̱ yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ne̱ cuano̱ nihánj me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa veé do̱j nihánj me coꞌoj, ne̱ se̱ coꞌoj ya̱j a̱ maꞌ. Tza̱j ne̱ asa̱ꞌ quisíj güii gu̱un chij Réé ꞌu̱nj rihaan chumii̱ nihánj, ne̱ cunu̱u naca̱ chumii̱ nihánj, ne̱ coꞌo̱ níꞌ na vinó naca̱ ei ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ga̱a ne̱ cachráá taranꞌ nij soꞌ chraꞌ rihaan Diose̱, ne̱ cavii nij soꞌ, caꞌanj nij soꞌ quij cuꞌna̱j Quij ma̱n Chruun Olivó a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Danj Diose̱ taj se vaa go̱ꞌ Diose̱ man síí tumé matzinj, ne̱ cuna̱nj nij matzinj chaꞌnu̱u̱ nij xoꞌ a. Ne̱ ya̱ ase vaa daán ꞌu̱nj matzinj vaa soj, ne̱ nii̱ corá gu̱un naꞌa̱j taranꞌ soj, ne̱ se̱ canocoꞌ soj manj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tza̱j ne̱ asa̱ꞌ quisíj cunuu iꞌna̱ꞌ uún ꞌu̱nj, ne̱ quita̱j ya̱a̱n ꞌu̱nj rihaan soj caꞌa̱nj ꞌu̱nj estadó Galilea, ne̱ nari̱ꞌ tuviꞌ níꞌ estadó Galilea na̱nj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ga̱a ne̱ cataj síí cuꞌna̱j Pedró rihaan soꞌ a: ―Caꞌve̱e se ta̱náj taranꞌ nij soꞌ mán so̱ꞌ, tza̱j ne̱ daj chiha̱a̱ míj se̱ tanáj ꞌu̱nj mán so̱ꞌ maꞌ ―taj Pedró a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ne̱ cataj Jesucristó: ―Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan so̱ꞌ cuano̱ se vaa a̱j neꞌén ꞌu̱nj se vaa nii̱ corá ga̱a ataa cagua̱j toꞌloo, ne̱ vaꞌnu̱j ya̱ cata̱j so̱ꞌ rihaan yuvii̱ se vaa nuveé si̱j noco̱ꞌ manj mé so̱ꞌ a ―taj Jesucristó rihaan Pedró a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ne̱ cataj Pedró: ―Taj maꞌ. Caꞌve̱e se ticavi̱ꞌ yuvii̱ man níꞌ, tza̱j ne̱ daj chiha̱a̱ míj se̱ cataj ꞌu̱nj se vaa nuveé si̱j noco̱ꞌ mán so̱ꞌ mej maꞌ ―taj Pedró rihaan Jesucristó a. Ne̱ ase vaa cataj Pedró roꞌ, da̱nj cataj taranꞌ nij síí tucuꞌyón se‑na̱na̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ga̱a ne̱ caꞌanj Jesucristó ga̱ nij soꞌ nda̱a yoꞌó rej cuꞌna̱j Getsemaní, ne̱ cataj xnaꞌanj Jesucristó rihaan nij soꞌ: ―Cane̱ soj nihánj, na̱ꞌvi̱j soj mán ꞌu̱nj, ne̱ caꞌa̱nj ꞌu̱nj ga̱nꞌ do̱j tzinꞌ, ne̱ cachi̱nj ni̱ꞌyáj rihaan Réj a ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ne̱ nica̱j Jesucristó man Pedró do̱ꞌ, man ro̱j taꞌníí síí cuꞌna̱j Zebedeo do̱ꞌ, caꞌanj soꞌ, ne̱ guun cheꞌe̱ soꞌ quinanó ndoꞌo rá soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ga̱a ne̱ cataj soꞌ rihaan vaꞌnu̱j nij síí caꞌanj ga̱ soꞌ a: ―Nanó uxrá raj ado̱nj. Ma̱a̱n cheꞌé rej nanó ndoꞌo raj, quiꞌya̱j cavi̱ꞌ ꞌu̱nj, raj a. Quiꞌya̱j soj se ndoꞌo quina̱j soj nihánj, ne̱ se̱ cotoj soj maꞌ ―taj Jesucristó rihaan vaꞌnu̱j nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ga̱a ne̱ cavii soꞌ yaníj do̱j tzinꞌ, ne̱ caꞌanj ca̱yáán rno̱ soꞌ rihaan yoꞌóó, ne̱ cachíín niꞌya̱j soꞌ rihaan Diose̱, ne̱ cataj soꞌ rihaan Diose̱ a: ―Sese caꞌve̱e, ne̱ ca̱ráán raꞌá so̱ꞌ xráj, se̱ gaa na̱nj quira̱nꞌ uxrá ꞌu̱nj sayuun, tza̱j ne̱ sese ma̱ꞌán so̱ꞌ me rá qui̱ránꞌ ꞌu̱nj sayuun, ne̱ qui̱ꞌyáá so̱ꞌ nda̱a vaa me rá ma̱ꞌán so̱ꞌ, ne̱ se̱ quiꞌyáá so̱ꞌ nda̱a vaa me rá ma̱ꞌanj, man Ata̱j ―taj Jesucristó, cachíín niꞌya̱j soꞌ rihaan Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ga̱a ne̱ canica̱j uún soꞌ caꞌnaꞌ soꞌ rihaan vaꞌnu̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ queneꞌen soꞌ se vaa cotoj cunuda̱nj nij soꞌ a. Ga̱a ne̱ cataj soꞌ rihaan Pedró a: ―Dan me se xa̱ꞌ soj me se a̱ ꞌó orá ne gu̱un nucua̱j soj ni̱ꞌyaj soj ga̱j a̱ maꞌ. Ya̱ naꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ma̱a̱n se ni̱ꞌyaj soj, ne̱ cachi̱nj niꞌya̱j soj rihaan Diose̱ se vaa ca̱ráán Diose̱ rihaan síí chre̱e se̱ caxríj síí chre̱e chrej chiꞌi̱i̱ rque soj á. ꞌO̱ se niha̱ꞌ rá soj quiꞌya̱j soj se sa̱ꞌ, tza̱j ne̱ ne gu̱un nucua̱j soj maꞌ ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ga̱a ne̱ cavii uún soꞌ, ne̱ cachíín niꞌya̱j uún soꞌ rihaan Diose̱, cataj soꞌ: ―Sese se̱ caꞌvee quinani̱i̱ ꞌu̱nj rihaan sayuun ase vaa, ne̱ qui̱ꞌyáá so̱ꞌ nda̱a vaa me rá so̱ꞌ, Ata̱j ―taj Jesucristó, cachíín niꞌya̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ga̱a ne̱ canica̱j uún soꞌ caꞌnaꞌ soꞌ, ne̱ queneꞌen soꞌ se vaa cotoj uún vaꞌnu̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ꞌO̱ se caꞌnaꞌ ndoꞌo nej rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ga̱a ne̱ tanáj soꞌ man nij soꞌ, ne̱ cavii uún soꞌ, ne̱ cachíín niꞌya̱j uún soꞌ rihaan Diose̱, ne̱ ase vaa cachíín niꞌya̱j soꞌ ga̱a rque̱ roꞌ, da̱nj vaa cachíín niꞌya̱j uún soꞌ rihaan Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ga̱a ne̱ canica̱j uún soꞌ caꞌnaꞌ soꞌ rihaan vaꞌnu̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ cataj soꞌ: ―Caꞌve̱e coto̱j soj caꞌve̱e nara̱a̱n rá soj caꞌve̱e sese vaa yaꞌnúj rihaan soj á. Dan me se da̱j doj quisi̱j orá tu̱cuachén yoꞌo̱ soꞌ manj rihaan síí tumé ndoꞌo cacunꞌ, cheꞌé se mé ꞌu̱nj síí caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Na̱xagaa soj, caꞌa̱nj níꞌ na̱nj ei. Ni̱ꞌyaj soj nedi̱ꞌ. ꞌNaꞌ síí tu̱cuachén manj rihaan síí ta̱j riꞌyunj manj na̱nj chugua̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Dan me se nicu̱nꞌ Jesucristó caꞌmii soꞌ, ne̱ nu̱ꞌ caꞌnaꞌ síí cuꞌna̱j Judas yoꞌo̱ tuviꞌ chuvi̱j nij síí tucuꞌyón se‑na̱na̱ Jesucristó, ne̱ caꞌnaꞌ uxrá yuvii̱ ga̱ soꞌ, ne̱ nica̱j nij yuvii̱ neê espadá do̱ꞌ, chruun do̱ꞌ a. Dan me se nij yuvii̱ caꞌnéé nij xrej ata̱ suun noco̱o doj do̱ꞌ, nij yuvii̱ caꞌnéé nij síí uun chij rihaan nij yuvii̱ israelitá do̱ꞌ, me nij yuvii̱ caꞌnaꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ne̱ síí cuꞌna̱j Judas cataj xnaꞌanj rihaan nij yuvii̱ se vaa da̱j ga̱a̱ quiꞌya̱j soꞌ ga̱ Jesucristó, ga̱a ne̱ cunu̱u ya̱a̱n nij yuvii̱ man Jesucristó, ne̱ cataj soꞌ: ―Síí cachro̱n tuꞌvaj roꞌ, soꞌ me síí qui̱taꞌaa soj cuaj á ―taj síí cuꞌna̱j Judas a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ga̱a ne̱ nu̱ꞌ cuchiꞌ soꞌ cuaj rihaan Jesucristó, ne̱ cataj soꞌ: ―Caꞌnaꞌ uxraj, na̱nj maestro ―taj soꞌ rihaan Jesucristó a. Ga̱a ne̱ nu̱ꞌ cachrón tuꞌva̱ soꞌ xruu̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ga̱a ne̱ xnáꞌanj Jesucristó man Judas, cataj soꞌ: ―Me cheꞌé caꞌnáꞌ so̱ꞌ, ga̱ tinu̱ꞌ ―taj soꞌ rihaan Judas a. Ga̱a ne̱ cuchiꞌ nij yuvii̱ rihaan Jesucristó, ne̱ quitaꞌaa nij yuvii̱ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ne̱ yoꞌo̱ síí nicu̱nꞌ ga̱ Jesucristó me se quirii soꞌ taneê soꞌ neê espadá, ne̱ goꞌ soꞌ neê espadá yoꞌ raa̱ yoꞌo̱ se‑mo̱zó xrej ata̱ suun noco̱o doj, ne̱ veé dan güéj nu̱ꞌ xréé mozó yoꞌ, quiꞌyaj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ga̱a ne̱ cataj Jesucristó rihaan síí nica̱j neê espadá yoꞌ a: ―Naꞌne̱j so̱ꞌ taneê so̱ꞌ á. ꞌO̱ se nu̱ꞌ yuvii̱ nica̱j neê espadá roꞌ, veé neê espadá quiꞌya̱j cavi̱ꞌ nij yuvii̱ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ne̱ ne neꞌén so̱ꞌ se vaa gu̱un nu̱cuáj cachi̱nj ni̱ꞌyáj rihaan Réj, ne̱ caꞌna̱ꞌ queꞌe̱e̱ ndoꞌo se‑mo̱zó Réj rihanj cuano̱, ne̱ caꞌve̱e quiꞌya̱j cananj a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tza̱j ne̱ sese da̱nj qui̱ꞌyáj, ga̱a ne̱ asa̱ꞌ caꞌve̱e quiꞌya̱j níꞌ nu̱ꞌ nana̱ no̱ rihaan danj Diose̱ nana̱ taj xnaꞌanj da̱j ga̱a̱ qui̱ránꞌ ꞌu̱nj ga̱ ―taj Jesucristó rihaan síí nica̱j neê espadá yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ne̱ canica̱j Jesucristó, cataj Jesucristó rihaan nij yuvii̱ a: ―Me cheꞌé nica̱j soj neê espadá nica̱j soj chruun nica̱j soj, caꞌnaꞌ soj ga̱. Síí itu̱u̱ mé ꞌu̱nj, rá soj naꞌ. Ne̱ ꞌo̱ se guun queꞌe̱e̱ güii cayáán ꞌu̱nj rá nuvií noco̱o, tucuꞌyón ꞌu̱nj se‑na̱na̱j rihaan nij yuvii̱, tza̱j ne̱ ne qui̱taꞌaa soj manj a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tza̱j ne̱ nihánj me se qui̱ránꞌ ꞌu̱nj nu̱ꞌ se vaa taj nana̱ cachrón nij síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá rihaan yanj a ―taj Jesucristó a. Ga̱a ne̱ tanáj cunuda̱nj nij síí tucuꞌyón se‑na̱na̱ Jesucristó man soꞌ, ne̱ cunánj nij soꞌ, caꞌanj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Dan me se nij síí quitaꞌaa man Jesucristó me se nica̱j nij soꞌ man Jesucristó caꞌanj nij soꞌ rihaan síí cuꞌna̱j Caifás xrej ata̱ suun noco̱o doj a. Ne̱ a̱j mán chre̱ꞌ nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés do̱ꞌ, nij síí uun chij do̱ꞌ, rihaan síí cuꞌna̱j Caifás yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ne̱ ga̱nꞌ ga̱nꞌ canocoꞌ síí cuꞌna̱j Pedró xcó Jesucristó, ne̱ cuchiꞌ soꞌ rihaan chingá rej ya̱nj síí cuꞌna̱j Caifás yoꞌ, ne̱ catúj soꞌ rá chingá ne̱ caꞌanj ca̱yáán soꞌ ga̱ nij se‑mo̱zó xrej ma̱n rá chingá, queneꞌe̱n soꞌ da̱j quira̱nꞌ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Dan me se nanoꞌ nij xrej ata̱ suun noco̱o doj nanoꞌ nij cuese̱ nanoꞌ man yuvii̱ cata̱j xnaꞌanj cheꞌé cacunꞌ tumé Jesucristó a. Me rá nij soꞌ nari̱ꞌ nij soꞌ cacunꞌ rmi̱ꞌ cuta̱ꞌ nij soꞌ xráá Jesucristó ne̱ cavi̱ꞌ Jesucristó, rá nij soꞌ a. Tza̱j ne̱ taj va̱j a̱ ꞌó cacunꞌ tumé Jesucristó a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Cheꞌé dan nda̱ꞌ se cuchiꞌ uxrá síí ne̱ rihaan nij cuese̱ caꞌmii ne̱ nij soꞌ, tza̱j ne̱ taj va̱j cacunꞌ quiriꞌ nij soꞌ cuta̱ꞌ nij soꞌ xráá Jesucristó a̱ maꞌ. Veé dan, ne̱ cuchiꞌ vi̱j ro̱j soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ne̱ cataj ro̱j soꞌ: ―Síí nihánj cataj se vaa gu̱un nucua̱j soꞌ ta̱cuanee soꞌ nuvií noco̱o nuvií naꞌvíj níꞌ rihaan Diose̱, ne̱ rque vaꞌnu̱j güii cune̱ꞌ uún soꞌ nuvií yoꞌ, taj soꞌ ei ―taj ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ga̱a ne̱ canicunꞌ xrej ata̱ suun noco̱o doj, ne̱ xnáꞌanj soꞌ man Jesucristó, cataj soꞌ: ―Me cheꞌé ne aꞌmii so̱ꞌ ga̱. Da̱j vaa nana̱ nihánj nana̱ aꞌmii ro̱j síí nihánj cheꞌé so̱ꞌ ga̱ ―taj soꞌ, xnáꞌanj soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tza̱j ne̱ dínj táá Jesucristó a. Ga̱a ne̱ cataj uún xrej ata̱ suun noco̱o doj rihaan Jesucristó a: ―Ase vaa nana̱ taj xnaꞌanj maꞌa̱n Diose̱ rihaan so̱ꞌ roꞌ, da̱nj ga̱a̱ nana̱ nihánj nana̱ cata̱j xnaꞌanj ꞌu̱nj rihaan so̱ꞌ á. ꞌU̱nj me síí ya̱ ya̱ caꞌne̱ꞌ suun rihaan so̱ꞌ cata̱j xnaꞌanj so̱ꞌ sese ya̱ ya̱ mé so̱ꞌ taꞌníí Diose̱ síí ti̱nanii man yuvii̱ rihaan sayuun á ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Ya̱ vaa nana̱ caꞌmii ma̱ꞌán so̱ꞌ ei. Ne̱ vaj a̱ doj cata̱j xnaꞌanj ꞌu̱nj rihaan so̱ꞌ se vaa nda̱a ya̱j queneꞌe̱n soj se vaa síí caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ mej, ne̱ queneꞌe̱n soj se vaa ca̱yáán ꞌu̱nj rej nuva̱ꞌ Diose̱ síí nucua̱j ndoꞌo ei. Ne̱ queneꞌe̱n uún soj se vaa caꞌna̱ꞌ uún ꞌu̱nj rihaan chumii̱ nihánj, ne̱ quita̱j ꞌu̱nj xráá ngaa xta̱ꞌ caꞌna̱j ado̱nj ―taj Jesucristó rihaan xrej ata̱ suun noco̱o doj yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ga̱a ne̱ caꞌmaan rá xrej yoꞌ, ne̱ cutzinꞌ xrej yoꞌ saga̱nꞌ maꞌa̱n xrej, ne̱ cataj xrej rihaan tuviꞌ xrej a: ―Ni̱ꞌyaj soj vi̱j. Quij uxrá tuꞌva síí nihánj rihaan Diose̱ na̱nj ei. Se̱ cachiin doj síí caꞌna̱ꞌ cata̱j xnaꞌanj rihaan níꞌ cheꞌé cacunꞌ tumé síí nihánj a̱ maꞌ. Ma̱a̱n se cuano̱ nihánj me se cuno maꞌa̱n soj nana̱ quij caꞌmii soꞌ se vaa ca̱yáán maꞌa̱n soꞌ rej xꞌnu̱j Diose̱, taj soꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Da̱j quiꞌya̱j níꞌ man soꞌ, rá soj ga̱ ―taj xrej, xnáꞌanj xrej man nij tuviꞌ xrej a. ―Cavi̱ꞌ soꞌ ei ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ga̱a ne̱ quirii talúj nij soꞌ rihaan Jesucristó, ne̱ goꞌ nij soꞌ man Jesucristó a. Ne̱ coxro taꞌa̱j nij soꞌ xruu̱ Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ne̱ cataj nij soꞌ: ―Sese ya̱ ya̱ caꞌnéé Diose̱ mán so̱ꞌ ti̱nanii so̱ꞌ man yuvii̱ rihaan sayuun, ne̱ ra̱cuíj Diose̱ mán so̱ꞌ cata̱j xnaꞌanj so̱ꞌ rihaan núj me síí goꞌ mán so̱ꞌ vi̱j ―taj nij soꞌ, caꞌmii naco̱o nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Veé dan, ne̱ ne̱ Jesucristó ga̱ yoꞌó nij soꞌ rá veꞌ, ne̱ ne̱ síí cuꞌna̱j Pedró xeꞌ rá chingá a. Ne̱ cuchiꞌ yoꞌo̱ mozó cha̱na̱ rihaan soꞌ, ne̱ cataj noꞌ: ―Ne̱ so̱ꞌ me yoꞌo̱ síí cachéé ga̱ Jesucristó síí cavii estadó Galilea á ―taj mozó cha̱na̱ yoꞌ rihaan Pedró a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","―Taj maꞌ. Ne unó ꞌu̱nj me taj so̱ꞌ maꞌ ―taj Pedró cuno taranꞌ nij yuvii̱ cayáán ga̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ga̱a ne̱ curiha̱nj Pedró, ne̱ canicunꞌ soꞌ rej atúj yuvii̱ chingá a. Ga̱a ne̱ queneꞌen yoꞌó mozó cha̱na̱ man soꞌ, ne̱ caꞌmii noꞌ rihaan nij yuvii̱ nicu̱nꞌ rihaan veꞌ ga̱ Pedró, cataj noꞌ: ―Síí nihánj cachéé ga̱ Jesucristó síí cavii chumanꞌ Nazaret asuun asanj ―taj chana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ga̱a ne̱ nucua̱j ndoꞌo caꞌmii uún Pedró, cataj soꞌ: ―Taj maꞌ. A̱ doj ne neꞌenj man snóꞌo yoꞌ maꞌ ―taj Pedró yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ne̱ corá nii cuchiꞌ nij síí nicu̱nꞌ ga̱ Pedró rihaan Pedró, ne̱ cataj nij soꞌ: ―Ya̱ ya̱ yoꞌo̱ síí cachéé ga̱ Jesucristó mé so̱ꞌ ei. ꞌO̱ se ase vaa nana̱ aꞌmii nij síí cachéé ga̱ Jesucristó roꞌ, vaa nana̱ aꞌmii so̱ꞌ chugua̱nj ―taj nij soꞌ rihaan Pedró a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ga̱a ne̱ guun cheꞌe̱ Pedró nucua̱j doj caꞌmii Pedró, cataj Pedró se vaa caꞌve̱e quiꞌya̱j Diose̱ sayuun man soꞌ sese nuveé na̱na̱ ya̱ me nana̱ aꞌmii soꞌ, ne̱ cataj soꞌ: ―Ne neꞌenj man snóꞌo yoꞌ maꞌ ―taj uún Pedró, ga̱a ne̱ nu̱ꞌ caguáj toꞌloo a. ");
INSERT INTO trcNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ga̱a ne̱ ninuj rá Pedró nda̱a vaa cataj Jesucristó rihaan soꞌ quii se vaa ga̱a ataa cagua̱j toꞌloo, ne̱ vaꞌnu̱j cata̱j Pedró se vaa nuveé si̱j noco̱ꞌ man Jesucristó me maꞌa̱n Pedró maꞌ. Ga̱a ne̱ curiha̱nj Pedró xeꞌ, ne̱ uxrá taꞌvee Pedró a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Rej ranga̱ꞌ nuchruj ra̱a̱ taranꞌ nij xrej ata̱ suun noco̱o doj do̱ꞌ, nij síí uun chij do̱ꞌ, da̱j quiꞌya̱j nij soꞌ, ne̱ cavi̱ꞌ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ga̱a ne̱ numíj nij soꞌ man soꞌ, ne̱ nica̱j nij soꞌ man soꞌ caꞌanj nij soꞌ rihaan síí nica̱j suun gobernador cuꞌna̱j Pilato, ne̱ tacuachén nij soꞌ man Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Dan me se síí cuꞌna̱j Judas me síí tacuachén man Jesucristó rihaan nij síí ta̱j riꞌyunj man Jesucristó ga̱a asino ya̱a̱n, ne̱ xcaj soꞌ cuentá se vaa ya̱ ya̱ ticavi̱ꞌ nii man Jesucristó ne̱ maꞌa̱n soꞌ me síí tumé cacunꞌ se vaa cavi̱ꞌ Jesucristó a. Cheꞌé dan nanó ndoꞌo rá soꞌ, ne̱ me rá soꞌ narque̱ uún soꞌ ico̱ chi̱ꞌ saꞌanj platá catzi̱i̱ yoꞌ rihaan nij xrej ata̱ suun noco̱o doj do̱ꞌ, rihaan nij síí uun chij do̱ꞌ a. Dan me se cuchiꞌ soꞌ rihaan nij soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ne̱ cataj soꞌ: ―Tumé ꞌu̱nj cacunꞌ se vaa tacuachén ꞌu̱nj man yoꞌo̱ síí sa̱ꞌ ina̱nj rihaan soj á ―taj síí cuꞌna̱j Judas yoꞌ a. ―Nuveé se‑cacu̱nꞌ núj me cacunꞌ tumé so̱ꞌ maꞌ. Xca̱j ma̱ꞌán so̱ꞌ cuentá da̱j ga̱a̱ qui̱ꞌyáá so̱ꞌ ei ―taj nij soꞌ rihaan síí cuꞌna̱j Judas a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ga̱a ne̱ nica̱j soꞌ saꞌanj aga̱ꞌ yoꞌ, riꞌíj u̱u̱n soꞌ rá nuvií noco̱o, ne̱ cavii soꞌ caꞌanj soꞌ, ne̱ tocoꞌ va̱j maꞌa̱n soꞌ man soꞌ, ne̱ caviꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ga̱a ne̱ naranꞌ nij xrej ata̱ suun noco̱o doj man saꞌanj aga̱ꞌ yoꞌ, ne̱ cataj nij soꞌ: ―Ne nó xcúún níꞌ cara̱a níꞌ saꞌanj nihánj rá chrúún saꞌanj ta̱j rihaan Diose̱ maꞌ. ꞌO̱ se saꞌanj goꞌ níꞌ cheꞌé rej cavi̱ꞌ yoꞌo̱ yuvii̱ me saꞌanj nihánj á ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dan me se nuchruj ra̱a̱ nij soꞌ da̱j quiꞌya̱j nij soꞌ, ne̱ nica̱j nij soꞌ saꞌanj yoꞌ, ne̱ quiránj nij soꞌ toꞌóó síí rii xruj a. Ne̱ guun yoꞌóó yoꞌ santó cachinꞌ nii man náá guun yuvii̱ ꞌnaꞌ yoꞌó chumanꞌ yuvii̱ caviꞌ chumanꞌ Jerusalén a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Cheꞌé dan cuꞌna̱j yoꞌóó yoꞌ Yoꞌóó To̱n cuano̱ ei. ");
INSERT INTO trcNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Dan me se quisíj quiꞌyaj nij soꞌ nu̱ꞌ se vaa cataj síí cuꞌna̱j Jeremías síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá ga̱a cataj soꞌ: “Ga̱a ne̱ nica̱j nij soꞌ ico̱ chi̱ꞌ saꞌanj aga̱ꞌ a. Saꞌanj yoꞌ me saꞌanj no̱ yoꞌo̱ soꞌ, cataj nij yuvii̱ israelitá a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ne̱ nica̱j nij soꞌ saꞌanj yoꞌ quiránj nij soꞌ toꞌóó síí rii xruj, nda̱a vaa cataj xnaꞌanj síí ꞌni̱j raꞌa man níꞌ rihanj na̱nj ado̱nj”, taj síí cuꞌna̱j Jeremías a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Dan me se canicunꞌ Jesucristó rihaan síí nica̱j suun gobernador yoꞌ, ne̱ xnáꞌanj síí nica̱j suun yoꞌ man Jesucristó, cataj soꞌ: ―So̱ꞌ me síí nica̱j suun rey uun chij rihaan nij yuvii̱ israelitá naꞌ ―taj soꞌ, xnáꞌanj soꞌ man Jesucristó a. ―Vej ei ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ne̱ xnáꞌanj síí nica̱j suun gobernador yoꞌ man Jesucristó cheꞌé cacunꞌ cutaꞌ nij xrej ata̱ suun noco̱o doj do̱ꞌ, nij síí uun chij do̱ꞌ, xráá Jesucristó a. Tza̱j ne̱ ne caꞌmi̱i̱ Jesucristó a̱ ꞌó nana̱ rihaan soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ga̱a ne̱ xnáꞌanj uún síí nica̱j suun yoꞌ man Jesucristó, cataj soꞌ: ―A̱j cunó so̱ꞌ cataj nij soꞌ se vaa tumé so̱ꞌ cacunꞌ naꞌ. Me cheꞌé ne aꞌmii so̱ꞌ ga̱ ―taj soꞌ, xnáꞌanj soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tza̱j ne̱ yu̱u̱n cheꞌe̱ ne caꞌmi̱i̱ Jesucristó a̱ ꞌó nana̱ rihaan soꞌ cheꞌé cacunꞌ cutaꞌ nii xráá soꞌ a. Veé dan, ne̱ caráyaꞌa̱nj uxrá síí nica̱j suun gobernador yoꞌ cheꞌé yan quiꞌyaj soꞌ da̱nj a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ne̱ vaa yoꞌo̱ tucuáán noco̱ꞌ síí nica̱j suun gobernador se vaa rii soꞌ man yoꞌo̱ síí ꞌni̱j tagaꞌ ꞌo̱ ꞌo̱ chaꞌanj pascuá, ne̱ tinavij u̱u̱n soꞌ cacunꞌ tumé síí uriha̱nj tagaꞌ yoꞌ a. Me maꞌa̱n ꞌo̱ síí ꞌni̱j tagaꞌ aꞌmii nij yuvii̱ cheꞌé se vaa quiri̱i̱ soꞌ, ne̱ caꞌve̱e quiꞌya̱j soꞌ nda̱a vaa taj nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ne̱ veé yoꞌ yoꞌ roꞌ, ꞌni̱j yoꞌo̱ síí cuꞌna̱j Barrabás tagaꞌ, ne̱ queneꞌen cunuda̱nj nij yuvii̱ se vaa tumé ndoꞌo soꞌ cacunꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Dan me se nuu chre̱ꞌ nij yuvii̱ rihaan síí nica̱j suun gobernador cuꞌna̱j Pilato, ne̱ xnáꞌanj soꞌ man nij yuvii̱, cataj soꞌ: ―Me síí quiri̱i̱ ꞌu̱nj, rá soj ga̱. Síí cuꞌna̱j Barrabás naꞌ. Ase síí cuꞌna̱j Jesucristó xa̱ꞌ ―taj soꞌ, xnáꞌanj soꞌ man nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Da̱nj caꞌmii soꞌ, neꞌen soꞌ se vaa ma̱a̱n cheꞌé se guun xco̱j ruva̱a̱ rá nij xrej ata̱ suun noco̱o doj me tacuachén nij xrej man Jesucristó rihaan maꞌa̱n soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ne̱ asi̱j yáán síí cuꞌna̱j Pilato yoꞌ rihaan xrúún soꞌ chruun xlá, ne̱ caꞌnéé nica̱ soꞌ nana̱ cuchiꞌ rihaan soꞌ, taj noꞌ: ―Se̱ guun caꞌne̱ꞌ so̱ꞌ cacunꞌ cheꞌé síí sa̱ꞌ yoꞌ maꞌ. ꞌO̱ se asi̱j cuaꞌa̱a me se nanó ndoꞌo raj cheꞌé yan tucuaꞌnuꞌ snóꞌo yoꞌ manj ado̱nj ―taj nica̱ síí cuꞌna̱j Pilato rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tza̱j ne̱ cataj xnaꞌanj nij xrej ata̱ suun noco̱o doj do̱ꞌ, nij síí uun chij do̱ꞌ, rihaan nij yuvii̱ se vaa caꞌmi̱i̱ nij yuvii̱ cheꞌé síí cuꞌna̱j Barrabás rihaan síí cuꞌna̱j Pilato, ne̱ cata̱j nij yuvii̱ se vaa cavi̱ꞌ Jesucristó a. Ne̱ cuchumán rá nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ga̱a ne̱ xnáꞌanj síí nica̱j suun gobernador cuꞌna̱j Pilato man nij yuvii̱, cataj soꞌ: ―Me ya̱ ya̱ síí quiri̱j, rá soj ga̱ ―taj soꞌ, xnáꞌanj soꞌ man nij yuvii̱ a. ―Quiri̱i̱ so̱ꞌ man síí cuꞌna̱j Barrabás ei ―taj nij yuvii̱ rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","―Ne̱ me qui̱ꞌyáá ꞌu̱nj ga̱ síí cuꞌna̱j Jesucristó, rá soj ga̱ ―taj uún síí cuꞌna̱j Pilato, xnáꞌanj soꞌ man nij yuvii̱ a. ―Cavi̱ꞌ soꞌ rihaan rcutze̱, rá núj ei ―taj taranꞌ nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","―Tza̱j ne̱ me cacunꞌ tumé soꞌ ga̱ ―taj síí cuꞌna̱j Pilato, xnáꞌanj soꞌ man nij yuvii̱ a. Tza̱j ne̱ doj a̱ caguáj nij yuvii̱, cataj nij yuvii̱: ―Cavi̱ꞌ soꞌ rihaan rcutze̱ ei. ―Da̱nj ina̱nj caguáj nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Dan me se queneꞌen síí cuꞌna̱j Pilato se vaa taj se ꞌyáꞌ quinaꞌma̱a̱n rá nij yuvii̱, ne̱ ma̱a̱n se doj a̱ caꞌma̱an rá nij yuvii̱, ne̱ doj a̱ quiꞌya̱j nij yuvii̱ sayuun a. Cheꞌé dan nica̱j soꞌ na, ne̱ naꞌyaꞌ soꞌ niꞌya̱j nij yuvii̱ a. Ne̱ cataj soꞌ: ―Se̱ tumé ꞌu̱nj cacunꞌ sese cavi̱ꞌ síí nihánj a̱ maꞌ. ꞌO̱ se maꞌa̱n soj me síí quiꞌya̱j cavi̱ꞌ soꞌ ado̱nj ―taj síí cuꞌna̱j Pilato a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ga̱a ne̱ cataj nij yuvii̱ rihaan soꞌ a: ―Veé maꞌa̱n núj, maꞌa̱n taꞌníí núj do̱ꞌ, me síí tu̱mé cacunꞌ se vaa cavi̱ꞌ soꞌ ei ―taj nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ga̱a ne̱ quirii síí cuꞌna̱j Pilato man síí cuꞌna̱j Barrabás tagaꞌ cheꞌé nij yuvii̱, ne̱ goꞌ nij tanuu cuartá xráá Jesucristó, quiꞌyaj síí cuꞌna̱j Pilato, ne̱ tacuachén síí cuꞌna̱j Pilato man soꞌ rihaan nij tanuu se vaa cachro̱n nij tanuu man soꞌ rihaan rcutze̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ga̱a ne̱ caꞌanj nica̱j nij tanuu ꞌyaj suun rihaan síí nica̱j suun gobernador man Jesucristó rá veꞌ tucuá síí nica̱j suun gobernador yoꞌ a. Ne̱ naquiꞌyaj chre̱ꞌ nij tanuu man taranꞌ nij tuviꞌ tanu̱u nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ga̱a ne̱ quirii nij soꞌ saga̱nꞌ Jesucristó man Jesucristó, ne̱ naꞌnéé nij soꞌ saga̱nꞌ rey yatzíj mare̱e man Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ne̱ quiꞌyaj nij soꞌ cachriin tanj, ne̱ cutaꞌ nij soꞌ cachriin tanj raa̱ Jesucristó, ne̱ caxríj nij soꞌ yoꞌo̱ vará tico̱ u̱u̱n ston Jesucristó a. Ga̱a ne̱ canicunꞌ ru̱j nij tanuu rihaan Jesucristó, ne̱ caꞌngaꞌ naco̱o̱ nij soꞌ niꞌya̱j nij soꞌ man Jesucristó, ne̱ cataj nij soꞌ: ―Ya̱ ya̱ si̱j nica̱j suun rey rii taꞌngaꞌ rihaan nij yuvii̱ israelitá mé so̱ꞌ ei ―taj nij soꞌ tihaꞌ nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ga̱a ne̱ quirii talúj nij soꞌ man Jesucristó, ne̱ nacaj nij soꞌ vará noco̱ꞌ raꞌa Jesucristó, ne̱ goꞌ nij soꞌ vará raa̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Síj caꞌngaꞌ naco̱o̱ nij soꞌ niꞌya̱j nij soꞌ man Jesucristó, ga̱a ne̱ quirii uún nij soꞌ saga̱nꞌ rey yatzíj mare̱e nu̱u̱ Jesucristó, ne̱ naꞌnéé uún nij soꞌ saga̱nꞌ uún Jesucristó man uún soꞌ, ga̱a ne̱ nica̱j nij soꞌ man Jesucristó cavii nij soꞌ caꞌanj nij soꞌ yan cachro̱n nij soꞌ man Jesucristó rihaan rcutze̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Dan me se cavii nij soꞌ, ne̱ nariꞌ nij soꞌ man yoꞌo̱ síí ne̱ chumanꞌ Cirene, ne̱ soꞌ me síí cuꞌna̱j Simón a. Veé dan, ne̱ quiꞌyaj uxrá nij tanuu fuerzá man síí cuꞌna̱j Simón yoꞌ ca̱ta̱ soꞌ rcutze̱ cano̱ Jesucristó rihaan a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ga̱a ne̱ cuchiꞌ nij soꞌ tacaan cuꞌna̱j Gólgota, ne̱ Gólgota roꞌ, me rej cuꞌna̱j Tacaan Cúú Yave̱ Xnangá a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ga̱a ne̱ rqué nij tanuu do̱j na vinó nachej ga̱ na e̱ꞌ man Jesucristó coꞌo̱ soꞌ a. Ne̱ do̱j tzinꞌ tiguíj daa Jesucristó, ne̱ ne caꞌve̱j rá soꞌ coꞌo̱ soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Veé dan, ne̱ cachrón nij tanuu man Jesucristó rihaan rcutze̱, ne̱ tico tixaj nij soꞌ cheꞌé saga̱nꞌ Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ga̱a ne̱ caꞌanj cane̱ nij soꞌ rihaan yoꞌóó, ne̱ tumé nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ne̱ cachrón nij tanuu yoꞌo̱ rcuchra̱ꞌ raa̱ rcutze̱, ne̱ no̱ letrá rihaan rcuchra̱ꞌ yoꞌ, ne̱ taj xnaꞌanj letrá yoꞌ me cheꞌé caviꞌ Jesucristó, ne̱: “Síí nihánj me síí cuꞌna̱j Jesucristó, ne̱ síí nica̱j suun rey uun chij rihaan nij yuvii̱ israelitá me soꞌ a”, taj letrá yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ga̱a ne̱ cachrón nij tanuu man yavíj snóꞌo rihaan yavíj rcutze̱ yoꞌ, ne̱ yavíj ro̱j soꞌ me síí itu̱u̱ a. Dan me se nicu̱nꞌ yoꞌo̱ soꞌ rej nuva̱ꞌ Jesucristó, ne̱ nicu̱nꞌ yoꞌó soꞌ rej nichru̱un Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ga̱a ne̱ cachén yuvii̱ rej nicu̱nꞌ Jesucristó, ne̱ caꞌmii chiꞌi̱i̱ ndoꞌo nij soꞌ niꞌya̱j nij soꞌ man Jesucristó a. Dan me se tucunó nij yuvii̱ raa̱ nij yuvii̱, ");
INSERT INTO trcNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","cataj nij yuvii̱: ―Ta̱cuanee so̱ꞌ man nuvií noco̱o, ne̱ rque vaꞌnu̱j güii cune̱ꞌ so̱ꞌ yoꞌó nuvií noco̱o, rá so̱ꞌ naꞌ. Dan me se sese ya̱ ya̱ taꞌni̱j Diose̱ mé so̱ꞌ, ne̱ ti̱nanii so̱ꞌ mán so̱ꞌ rihaan rcutze̱, ne̱ nani̱j so̱ꞌ rihaan yoꞌóó ya̱j vi̱j ―taj nij yuvii̱ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ne̱ ase vaa quiꞌyaj nij yuvii̱ yoꞌ roꞌ, da̱nj quiꞌyaj uún nij xrej ata̱ suun noco̱o doj do̱ꞌ, nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés do̱ꞌ, nij síí uun chij do̱ꞌ, caꞌmii chiꞌi̱i̱ nij soꞌ, cataj nij soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Ti̱nanii síí nihánj man yoꞌó yuvii̱ rihaan sayuun, rá soꞌ, tza̱j ne̱ ne gu̱un nucua̱j soꞌ ti̱nanii soꞌ man maꞌa̱n soꞌ rihaan rcutze̱ danj. Sese ya̱ ya̱ si̱j nica̱j suun rey uun chij rihaan níꞌ si̱j israelitá me soꞌ, ne̱ nani̱j soꞌ cuano̱ rihaan yoꞌóó, ne̱ cuchuma̱n rá níꞌ ni̱ꞌyaj níꞌ man soꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Dan me se nucua̱j rá soꞌ man Diose̱ se vaa cavi̱i̱ sa̱ꞌ soꞌ, quiꞌya̱j Diose̱, rá soꞌ a. Caꞌve̱e ti̱nanii Diose̱ man soꞌ cuano̱, sese si̱j ꞌe̱e̱ rá Diose̱ man me soꞌ á. ꞌO̱ se maꞌa̱n soꞌ taj se vaa taꞌni̱j Diose̱ me maꞌa̱n soꞌ ado̱nj ―taj nij soꞌ, chiꞌi̱i̱ ndoꞌo caꞌmii nij soꞌ niꞌya̱j nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ne̱ ase vaa caꞌmii nij soꞌ roꞌ, da̱nj caꞌmii uún ro̱j síí itu̱u̱ noco̱ꞌ rihaan rcutze̱ rej xꞌnu̱j Jesucristó, caꞌmii ro̱j soꞌ nana̱ nij rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Veé dan, ne̱ caxu̱j, ne̱ yu̱u̱n cheꞌe̱ guun rmi̱ꞌ rihaan chumii̱, ne̱ yoꞌo̱ guun rmi̱ꞌ chumii̱ nda̱a quisíj agaꞌ vaꞌnu̱j rej anocoꞌ güii a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Veé dan, ne̱ quisíj agaꞌ vaꞌnu̱j, ga̱a ne̱ nucua̱j ndoꞌo caguáj Jesucristó, cataj soꞌ: ―Elí, Elí, lama sabactani ―taj soꞌ, caguáj soꞌ xnaꞌánj aꞌmii maꞌa̱n soꞌ, ne̱ nana̱ caguáj soꞌ taj: “Diose̱ noco̱ꞌ ꞌu̱nj mé so̱ꞌ á. Me cheꞌé tanáj u̱u̱n so̱ꞌ mán ꞌu̱nj ga̱”, taj nana̱ caguáj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ne̱ cuno taꞌa̱j nij síí nicu̱nꞌ rej xꞌnu̱j Jesucristó nana̱ caguáj soꞌ, tza̱j ne̱ ne cuno̱ nij soꞌ me taj Jesucristó maꞌ. Ma̱a̱n se: ―Nacúún síí nihánj man síí cuꞌna̱j Elías tado̱nj ―taj nij soꞌ rihaan tuviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ga̱a ne̱ nu̱ꞌ raꞌya̱nj cunánj yoꞌo̱ síí nicu̱nꞌ rej xꞌnu̱j Jesucristó, ne̱ nica̱j soꞌ yataa̱n esponja, ne̱ caraa soꞌ na vinó yu̱u̱ rque yataa̱n, ne̱ cutaꞌ soꞌ raa̱ yoꞌo̱ vará, ne̱ ruꞌmaan soꞌ yataa̱n tuꞌva Jesucristó, ne̱ coꞌo Jesucristó na yu̱u̱ yoꞌ, quiꞌyaj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tza̱j ne̱ caꞌmii yoꞌó nij yuvii̱, cataj nij soꞌ: ―Dínj qui̱ꞌyáá so̱ꞌ á. Queneꞌe̱n níꞌ sese caꞌna̱ꞌ síí cuꞌna̱j Elías ti̱nanii síí cuꞌna̱j Elías man soꞌ rihaan rcutze̱ ei ―taj nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ga̱a ne̱ sca̱ꞌ caguáj uún Jesucristó, ne̱ caviꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Veé dan, ne̱ quisinꞌ yatzíj mantá cortiná noco̱ꞌ rá nuvií noco̱o nda̱a rej ra̱a̱, ne̱ ꞌo̱ quinij caꞌanj nda̱a tacóó yoꞌ a. Dan me se cachén yuún, ne̱ quixraꞌ taꞌa̱j nij yuvej, ");
INSERT INTO trcNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ne̱ xꞌnúj rej cachinꞌ nii man nij síí caviꞌ, ne̱ cunuu iꞌna̱ꞌ uún queꞌe̱e̱ nij síí sa̱ꞌ caviꞌ asi̱j rque̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ne̱ ga̱a quisíj orá cunuu iꞌna̱ꞌ uún maꞌa̱n Jesucristó, ne̱ curiha̱nj nij síí cunuu iꞌna̱ꞌ uún yoꞌ, ne̱ catúj nij soꞌ chumanꞌ gue̱e̱ chumanꞌ Jerusalén, ne̱ queneꞌen uxrá yuvii̱ man nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Veé dan, ne̱ nicu̱nꞌ tanuu capitán nicu̱nꞌ yoꞌó nij tanuu nicu̱nꞌ cutumé man Jesucristó a. Ne̱ queneꞌen nij soꞌ cachén yuún, ne̱ queneꞌen nij soꞌ nu̱ꞌ se vaa guun, ne̱ cuchuꞌviꞌ ndoꞌo nij soꞌ, ne̱ nda̱a dan asuun ga̱a xcaj nij soꞌ cuentá se vaa ya̱ uxrá taꞌni̱j Diose̱ me Jesucristó, ne̱ dan me se cataj nij soꞌ: ―Ya̱ taꞌni̱j Diose̱ me síí nihánj tado̱nj ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ne̱ ga̱nꞌ doj nicunꞌ queꞌe̱e̱ chana̱, niꞌya̱j u̱u̱n nij chana̱ man Jesucristó a. Chana̱ cuno se‑na̱na̱ Jesucristó asi̱j cavii Jesucristó estadó Galilea me nij chana̱ yoꞌ, ne̱ quiꞌyaj suun nij chana̱ yoꞌ cheꞌé Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Yoꞌo̱ noꞌ me chana̱ cuꞌna̱j Mariá Magdalena, ne̱ yoꞌó noꞌ me chana̱ cuꞌna̱j Mariá nii síí cuꞌna̱j Jacobo ga̱ síí cuꞌna̱j José a. Ne̱ yoꞌó noꞌ me nii ro̱j taꞌníí síí cuꞌna̱j Zebedeo a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ne̱ rej ataꞌ güii caꞌnaꞌ yoꞌo̱ síí ruꞌvee síí ne̱ chumanꞌ Arimatea a. José cuꞌna̱j soꞌ, ne̱ soꞌ me síí tucuꞌyón se‑na̱na̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Dan me se caꞌanj soꞌ rihaan síí cuꞌna̱j Pilato, ne̱ cachíín niꞌya̱j soꞌ rihaan síí cuꞌna̱j Pilato se vaa caꞌve̱j síí cuꞌna̱j Pilato cachi̱nꞌ soꞌ man Jesucristó a. Ne̱ síí cuꞌna̱j Pilato roꞌ, cataj se vaa caꞌve̱e quiꞌya̱j soꞌ da̱nj a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ne̱ nica̱j síí cuꞌna̱j José man Jesucristó, ne̱ nacutáj soꞌ yatzíj mantá naruvii xráá Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ne̱ vaa yuꞌuj yuvej rihaan soꞌ, rej achinꞌ nii man nij síí caviꞌ, tza̱j ne̱ yuꞌuj naca̱ me yoꞌ a. Maꞌa̱n soꞌ me síí quiꞌyaj gáán nii yuꞌuj yoꞌ, ne̱ taj va̱j xnangá na̱j rque yuꞌuj maꞌ. Ne̱ caxríj soꞌ man Jesucristó rque yuꞌuj yoꞌ, ne̱ caráán soꞌ yuvej xi̱j tuꞌva yuꞌuj yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ne̱ cayáán chana̱ cuꞌna̱j Mariá Magdalena cayáán yoꞌó chana̱ cuꞌna̱j Mariá cayáán tuꞌva yuꞌuj yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Veé dan, ne̱ taxre̱j, ne̱ nda̱a quisíj quiꞌyaj chuvi̱i nij yuvii̱ israelitá cheꞌé güii nara̱a̱n rá nij soꞌ, ne̱ cunuu chre̱ꞌ nij xrej ata̱ suun noco̱o doj do̱ꞌ, nij síí fariseo do̱ꞌ, ne̱ caꞌanj nij soꞌ rihaan síí cuꞌna̱j Pilato, ");
INSERT INTO trcNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ne̱ cataj nij soꞌ: ―Nu̱u̱ rá núj da̱j cataj síí tihaꞌ yuꞌunj yoꞌ ga̱a gaa iꞌna̱ꞌ soꞌ, señor. Dan me se cataj soꞌ se vaa cache̱n vaꞌnu̱j güii, ga̱a ne̱ cunu̱u iꞌna̱ꞌ uún soꞌ, cataj soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Cheꞌé dan caꞌne̱ꞌ so̱ꞌ suun rihaan tanuu se vaa tu̱mé tanuu man yuꞌuj na̱j soꞌ nda̱a se quisi̱j vaꞌnu̱j güii yoꞌ rugua̱nj. Sese se̱ quiꞌyaj níꞌ da̱nj, ne̱ caꞌna̱ꞌ nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ quiri̱i̱ nij soꞌ man soꞌ, ne̱ cata̱j nij soꞌ rihaan nij yuvii̱ se vaa cunuu iꞌna̱ꞌ uún soꞌ na̱nj ado̱nj. Asa̱ꞌ quisíj, ga̱a ne̱ doj a̱ tiha̱ꞌ yuꞌunj uún nij soꞌ man nij yuvii̱ na̱nj ado̱nj ―taj nij soꞌ rihaan síí cuꞌna̱j Pilato a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ne̱ cataj síí cuꞌna̱j Pilato rihaan nij soꞌ a: ―Vaa tanuu rihaan soj ei. Ni̱caj soj man tanuu caꞌa̱nj soj cu̱tumé soj man yuꞌuj yoꞌ á. Neꞌen maꞌa̱n soj da̱j quiꞌya̱j soj á ―taj Pilato rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ga̱a ne̱ cavii nij soꞌ caꞌanj nij soꞌ tumé nij soꞌ man yuꞌuj yuvej yoꞌ a. Dan me se caꞌneꞌ nij soꞌ suun rihaan tanuu cu̱tumé tanuu yuꞌuj, ne̱ cachrón nij soꞌ yánj nichra̱j tuꞌva yuvej caráán tuꞌva yuꞌuj yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Dan me se caꞌanj güii cueta̱nꞌ güii naránj rá nij yuvii̱ israelitá, ne̱ naꞌya̱a̱n cotungó me yoꞌ, ne̱ da̱j doj quisi̱j güii a. Ne̱ caꞌnaꞌ chana̱ cuꞌna̱j Mariá Magdalena do̱ꞌ, yoꞌó chana̱ cuꞌna̱j Mariá do̱ꞌ, queneꞌe̱n ro̱j chana̱ yuꞌuj catúj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Veé dan, ne̱ cachén uxrá yuún, ne̱ cavii yoꞌo̱ se‑mo̱zó síí ꞌni̱j raꞌa man níꞌ rej xta̱ꞌ, caꞌnaꞌ soꞌ, nanij soꞌ tuꞌva yuꞌuj yoꞌ, ga̱a ne̱ quirii yaníj soꞌ yuvej aráán tuꞌva yuꞌuj yoꞌ, ne̱ caꞌanj cane̱ soꞌ xráá yuvej yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Da̱j se uun rá ro̱j noꞌ neꞌen ro̱j noꞌ ga̱a raa̱n roꞌ, da̱nj guun rá ro̱j noꞌ ga̱a curuviꞌ soꞌ a. Ne̱ da̱j se uun rá ro̱j noꞌ neꞌen ro̱j noꞌ yuꞌveꞌ catzi̱i̱ ndoꞌo roꞌ, da̱nj guun rá ro̱j noꞌ neꞌen ro̱j noꞌ saga̱nꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ga̱a ne̱ cuchuꞌviꞌ ndoꞌo nij tanuu ma̱n tumé tuꞌva yuꞌuj yoꞌ, ne̱ quiriꞌíj ndoꞌo man nij soꞌ a. Dan me se ase vaa mán síí caviꞌ vaa mán nij soꞌ rihaan yoꞌóó a. ");
INSERT INTO trcNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Veé dan, ne̱ cuchiꞌ ro̱j chana̱ yoꞌ rihaan se‑mo̱zó Diose̱, ne̱ cataj se‑mo̱zó Diose̱ rihaan ro̱j noꞌ a: ―Se̱ cuchuꞌviꞌ ro̱j so̱j maꞌ. ꞌO̱ se a̱j neꞌén ꞌu̱nj se vaa nanoꞌ ro̱j so̱j man Jesucristó síí caviꞌ rihaan rcutze̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Taj va̱j soꞌ naj nihánj a̱ maꞌ. ꞌO̱ se cunuu iꞌna̱ꞌ uún soꞌ, nda̱a vaa cataj xnaꞌanj soꞌ rihaan soj á. Catu̱u̱ ro̱j so̱j ni̱ꞌyaj ro̱j so̱j rej quinaj soꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ga̱a ne̱ raꞌya̱nj caꞌa̱nj ro̱j so̱j, cata̱j xnaꞌanj ro̱j so̱j rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ se vaa cunuu iꞌna̱ꞌ uún soꞌ á. Veé dan me se quita̱j ya̱a̱n soꞌ rihaan soj caꞌa̱nj soꞌ estadó Galilea, ne̱ caꞌa̱nj soj nda̱a yoꞌ, ne̱ queneꞌe̱n soj man soꞌ á. Da̱nj ga̱a̱ cata̱j xnaꞌanj soj rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ á. Veé dan me quisíj nana̱ cataj xnaꞌanj ꞌu̱nj rihaan soj a ―taj se‑mo̱zó Diose̱ rihaan ro̱j chana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Veé dan, ne curiha̱nj ro̱j chana̱ caꞌanj ro̱j noꞌ a. Veé ro̱j noꞌ cuchuꞌviꞌ, ne̱ veé ro̱j noꞌ guun niha̱ꞌ rá uún a. Veé dan me se cunánj ndoꞌo ro̱j noꞌ, cata̱j xnaꞌanj ro̱j noꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ Jesucristó nu̱ꞌ se vaa queneꞌen ro̱j noꞌ do̱ꞌ, nu̱ꞌ nana̱ cataj xnaꞌanj se‑mo̱zó Diose̱ rihaan ro̱j noꞌ do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ne̱ ma̱a̱n orá dan nariꞌ tuviꞌ maꞌa̱n Jesucristó ga̱ ro̱j chana̱ yoꞌ, ne̱ cataj soꞌ: ―Ga̱a̱ niha̱ꞌ nimán ro̱j so̱j á ―taj Jesucristó rihaan ro̱j noꞌ a. Ga̱a ne̱ cuchiꞌ ro̱j chana̱ yoꞌ rihaan Jesucristó, ne̱ caꞌanj canicu̱nꞌ ru̱j ro̱j noꞌ rihaan soꞌ, ne̱ quitaꞌaa ro̱j noꞌ tacóó Jesucristó, ne̱ naꞌvíj ro̱j noꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ga̱a ne̱ cataj Jesucristó rihaan ro̱j chana̱ a: ―Se̱ cuchuꞌviꞌ ro̱j so̱j maꞌ. Ma̱a̱n se caꞌa̱nj ro̱j so̱j cata̱j xnaꞌanj ro̱j so̱j rihaan nij tinúú ꞌu̱nj se vaa cavi̱i̱ nij soꞌ caꞌa̱nj nij soꞌ estadó Galilea, ne̱ nda̱a yoꞌ queneꞌe̱n nij soꞌ manj á ―taj Jesucristó rihaan ro̱j chana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ne̱ ga̱a quisíj caꞌanj ro̱j chana̱ yoꞌ, ne̱ dan me se cavii taꞌa̱j nij tanuu ma̱n tuꞌva yuꞌuj yoꞌ rque chumanꞌ, ne̱ cataj xnaꞌanj nij tanuu rihaan nij xrej ata̱ suun noco̱o doj nu̱ꞌ se vaa guun a. ");
INSERT INTO trcNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ne̱ cunuu chre̱ꞌ nij xrej ata̱ suun noco̱o doj ga̱ nij síí uun chij, ne̱ nuchruj ra̱a̱ nij soꞌ da̱j quiꞌya̱j nij soꞌ a. Ga̱a ne̱ goꞌ uxrá nij soꞌ saꞌanj rihaan nij tanuu yoꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ne̱ cataj nij soꞌ: ―Cata̱j soj se vaa rej nii̱ cotoj soj, ne̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ roꞌ, caꞌnaꞌ quirii man soꞌ a. Da̱nj cata̱j soj á. ");
INSERT INTO trcNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ne̱ sese cuchi̱ꞌ nana̱ yoꞌ rihaan síí nica̱j suun gobernador, ne̱ sese me rá soꞌ quiꞌya̱j soꞌ sayuun man soj, ne̱ maꞌa̱n núj ca̱ráán raꞌa sayuun xráá soj á ―taj nij soꞌ rihaan nij tanuu a. ");
INSERT INTO trcNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Dan me se guun ya̱ rá nij tanuu, ne̱ quitaꞌaa nij soꞌ saꞌanj yoꞌ, ne̱ quiꞌyaj nij soꞌ nu̱ꞌ se vaa cataj xnaꞌanj nij xrej ata̱ suun noco̱o doj do̱ꞌ, nij síí uun chij do̱ꞌ, rihaan nij soꞌ a. Ne̱ ase vaa nana̱ caꞌmii nij tanuu rihaan yuvii̱ roꞌ, taꞌngaꞌ da̱nj vaa nana̱ tichaꞌnuu̱ nij yuvii̱ israelitá rihaan yuvii̱ nda̱a yoꞌ ya̱j na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ga̱a ne̱ caꞌanj xa̱a̱n nij síí tucuꞌyón se‑na̱na̱ Jesucristó estadó Galilea, ne̱ cavii nij soꞌ raa̱ ꞌo̱ quij a. Da̱nj quiꞌyaj nij soꞌ, ése̱ cuno nij soꞌ nana̱ cataj xnaꞌanj Jesucristó rihaan nij soꞌ ga̱a rque̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ga̱a ne̱ queneꞌen nij soꞌ man Jesucristó, ne̱ naꞌvíj nij soꞌ rihaan soꞌ, tza̱j ne̱ ne gu̱un ya̱ rá taꞌa̱j nij soꞌ se vaa ya̱ ya̱ Jesucristó me soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ga̱a ne̱ cuchiꞌ Jesucristó rihaan nij soꞌ, ne̱ cataj soꞌ rihaan nij soꞌ: ―Ya̱j me se ꞌu̱nj me síí uun chij xta̱ꞌ do̱ꞌ, nu̱ꞌ rihaan yoꞌóó do̱ꞌ, quiꞌyaj Diose̱ ei. ");
INSERT INTO trcNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Cheꞌé dan caꞌa̱nj soj tu̱cuꞌyón soj se‑na̱na̱j rihaan nij yuvii̱ ma̱n ꞌo̱ ꞌo̱ chumanꞌ na̱j rihaan chumii̱, ne̱ canoco̱ꞌ nij yuvii̱ manj, quiꞌya̱j soj, ne̱ cuta̱ꞌ ne soj man nij soꞌ, ne̱ cata̱ꞌ tuꞌva soj se‑chuvi̱i Réé ꞌu̱nj Diose̱ do̱ꞌ, se‑chu̱vií ꞌu̱nj taꞌni̱j Diose̱ do̱ꞌ, se‑chuvi̱i Nimán Diose̱ do̱ꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ne̱ tu̱cuꞌyón soj rihaan nij yuvii̱ se vaa cuno̱ nij yuvii̱ nu̱ꞌ nana̱ cataj xnaꞌanj ꞌu̱nj rihaan soj á. Veé dan yu̱u̱n cheꞌe̱ cache̱e̱ ꞌu̱nj ga̱ soj nu̱ꞌ güii cache̱e̱ soj rihaan chumii̱ nihánj, nda̱a se quinavi̱j nu̱ꞌ chumii̱ nihánj na̱nj ado̱nj ―taj Jesucristó rihaan nij soꞌ a.");
INSERT INTO trcNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Na̱nj vaa guun cheꞌe̱ se‑na̱na̱ Jesucristó nana̱ sa̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Dan me se síí cuꞌna̱j Isaías síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá roꞌ, cachrón soꞌ nana̱ nihánj rihaan yanj, ne̱: “Vaa síí caꞌanj suun cheꞌé ꞌu̱nj, ne̱ caꞌne̱j ꞌu̱nj man soꞌ quita̱j ya̱a̱n soꞌ rihaan so̱ꞌ, ne̱ nuchra̱nꞌ nimán yuvii̱ veꞌé caꞌmi̱i̱ nij yuvii̱ ga̱ so̱ꞌ, quiꞌya̱j soꞌ a”, me se‑na̱na̱ Diose̱ nana̱ cachrón síí cuꞌna̱j Isaías rihaan yanj a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ne̱ yoꞌó nana̱ cachrón uún soꞌ me nana̱ nihánj, ne̱: “Nucua̱j ndoꞌo caꞌmi̱i̱ natáj ꞌo̱ soꞌ rej tacaan, ne̱ cata̱j soꞌ se vaa nuchra̱nꞌ nimán yuvii̱, ne̱ veꞌé caꞌmi̱i̱ nij yuvii̱ ga̱ síí ꞌni̱j raꞌa man níꞌ asa̱ꞌ caꞌnaꞌ soꞌ ado̱nj”, taj síí cuꞌna̱j Isaías ga̱a naá, ne̱ ase vaa cataj soꞌ roꞌ, taꞌngaꞌ da̱nj guun ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Dan me se cavii síí cuꞌna̱j Juan síí cutaꞌ ne man yuvii̱, ne̱ va̱j soꞌ rej tacaan, ne̱ caꞌmii natáj soꞌ rihaan nij yuvii̱, cataj soꞌ se vaa nuchra̱nꞌ nimán nij yuvii̱, ne̱ ta̱náj nij yuvii̱ chrej chiꞌi̱i̱, ne̱ caꞌve̱e tinavi̱j Diose̱ cacunꞌ tumé nij yuvii̱, taj Juan ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ne̱ dan me se curiha̱nj ndoꞌo nij yuvii̱ ma̱n estadó Judea do̱ꞌ, ma̱n maꞌa̱n chumanꞌ Jerusalén do̱ꞌ, caꞌnaꞌ nij yuvii̱ rihaan síí cuꞌna̱j Juan, ne̱ cataꞌ ne nij yuvii̱ rá chráá cuꞌna̱j Jordán, quiꞌyaj Juan a. Dan me se nataꞌ ya̱ nij yuvii̱ cheꞌé cacunꞌ tumé nij yuvii̱, ga̱a ne̱ cataꞌ ne nij yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Dan me se síí cuꞌna̱j Juan me se cachij ta̱j xráá xcuu camelló guun yatzíj nu̱u̱ soꞌ, ne̱ ꞌni̱j catuu̱n soꞌ ꞌo̱ nuj, ne̱ chá soꞌ rquíí chá soꞌ catziꞌ xtaan ma̱n quij chá soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ne̱ caꞌmii natáj soꞌ, ne̱ cataj soꞌ: ―Vaa ꞌo̱ síí sca̱ꞌ doj rihanj, ne̱ soꞌ me síí caꞌna̱ꞌ rej riha̱a̱n níꞌ, ne̱ ꞌu̱nj nihánj me se ne nó xcúnj na̱chej nuj correá ꞌni̱j tacanj soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ne̱ síí utaꞌ ne na u̱u̱n man soj mej, tza̱j ne̱ caꞌna̱ꞌ soꞌ, ne̱ caꞌna̱ꞌ Nimán Diose̱ rihaan soj, quiꞌya̱j soꞌ ado̱nj ―taj síí cuꞌna̱j Juan rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ne̱ güii yoꞌ ta̱ꞌ asuun me se cavii Jesucristó chumanꞌ Nazaret chumanꞌ na̱j estadó Galilea, ne̱ cataꞌ ne soꞌ rá chráá cuꞌna̱j Jordán, quiꞌyaj síí cuꞌna̱j Juan a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nu̱ꞌ curiha̱nj uún Jesucristó rque na, ne̱ nu̱ꞌ queneꞌen soꞌ se vaa naxraꞌ rej xta̱ꞌ, ne̱ queneꞌen soꞌ se vaa nanij Nimán Diose̱ raa̱ maꞌa̱n soꞌ, ne̱ ase vaa chaꞌaa̱n roꞌ, vaa Nimán Diose̱, curuviꞌ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ga̱a ne̱ rej xta̱ꞌ caꞌmii Diose̱ rihaan Jesucristó, ne̱ cuno nij síí nicu̱nꞌ ga̱ Jesucristó nana̱ caꞌmii Diose̱, ne̱ dan me se cataj Diose̱ a: ―Taꞌníí ꞌu̱nj síí ꞌe̱e̱ ndoꞌo raj man mé so̱ꞌ, ne̱ niha̱ꞌ ndoꞌo raj niꞌya̱j ꞌu̱nj mán so̱ꞌ ado̱nj ―taj nana̱ cavii rej xta̱ꞌ caꞌmii Diose̱ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ne̱ dan me se caꞌanj ndoꞌo Jesucristó rej tacaan, quiꞌyaj Nimán Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ne̱ vi̱j chiha̱a̱ güii va̱j soꞌ rej tacaan, ne̱ guun rá síí chre̱e tiha̱ꞌ yuꞌunj soꞌ man Jesucristó, ne̱ va̱j Jesucristó rej ma̱n xcuu yuva̱a̱, ne̱ rqué nij se‑mo̱zó Diose̱ me maꞌa̱n se cachiin rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Dan me se ga̱a quisíj quitaꞌaa nij tanuu man síí cuꞌna̱j Juan, ne̱ caꞌanj Jesucristó estadó cuꞌna̱j Galilea, ");
INSERT INTO trcNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ne̱ caꞌmii natáj soꞌ se‑na̱na̱ Diose̱ nana̱ sa̱ꞌ, ne̱ cataj soꞌ se vaa nichru̱nꞌ quisi̱j güii caꞌna̱ꞌ Diose̱ gu̱un chij Diose̱ rihaan chumii̱ nihánj, ne̱: ―Cheꞌé dan nuchra̱nꞌ nimán soj, ne̱ cuchuma̱n rá soj cuno̱ soj se‑na̱na̱j nana̱ sa̱ꞌ á ―taj soꞌ rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ꞌO̱ güii cachén Jesucristó tuꞌva na lacuaná cuꞌna̱j na Galilea, ne̱ queneꞌen soꞌ síí cuꞌna̱j Simón ga̱ tinúú Simón síí cuꞌna̱j Andrés, ne̱ dan me se nicu̱nꞌ ro̱j soꞌ tuꞌva na lacuaná, ne̱ tiguíj ro̱j soꞌ nanj rque na, ne̱ dan me se síí rii xcuaj me ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ga̱a ne̱ cataj Jesucristó rihaan ro̱j soꞌ a: ―Canoco̱ꞌ ro̱j so̱j manj á. ꞌO̱ se síí naquiꞌyaj chre̱ꞌ xcuaj me ro̱j so̱j, tza̱j ne̱ rej riha̱a̱n níꞌ me se gu̱un ro̱j so̱j síí naquiꞌyaj chre̱ꞌ yuvii̱, qui̱ꞌyáj, ne̱ canoco̱ꞌ nij yuvii̱ manj a ―taj Jesucristó rihaan ro̱j tinu̱j ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ne̱ nu̱ꞌ canica̱j ro̱j soꞌ tanáj ro̱j soꞌ xnánj ro̱j soꞌ, ne̱ canocoꞌ ro̱j soꞌ man Jesucristó, caꞌanj ro̱j soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Veé dan, ne̱ cachéé nij soꞌ doj, ga̱a ne̱ queneꞌen Jesucristó man síí cuꞌna̱j Jacobo taꞌníí síí cuꞌna̱j Zebedeo do̱ꞌ, man tinúú Jacobo síí cuꞌna̱j Juan do̱ꞌ a. Dan me se nu̱u̱ ro̱j soꞌ rque rihoo chéé rihaan na, ne̱ naquiꞌyaj sa̱ꞌ ro̱j soꞌ nanj rii xcuaj, ne̱ canacúún Jesucristó man ro̱j tinu̱j ro̱j soꞌ canoco̱ꞌ ro̱j soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Veé dan, ne̱ canica̱j ro̱j soꞌ, tanáj ro̱j soꞌ man rej ro̱j soꞌ síí cuꞌna̱j Zebedeo rá rihoo ga̱ nij se‑mo̱zó soꞌ, ga̱a ne̱ cavii ro̱j soꞌ canocoꞌ ro̱j soꞌ man Jesucristó, caꞌanj ro̱j soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Dan me se catúj nij soꞌ chumanꞌ Capernaum, ne̱ daj a̱ güii naránj rá nij yuvii̱ israelitá caꞌanj Jesucristó veꞌ tucuꞌyón nij soꞌ se‑tucua̱nj Moisés, ne̱ tucuꞌyón soꞌ se‑na̱na̱ Diose̱ man nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ne̱ caráyaꞌa̱nj nij yuvii̱ se‑na̱na̱ soꞌ, cheꞌé se cu̱u doj vaa se‑na̱na̱ soꞌ ga̱ se‑na̱na̱ nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés a. ꞌO̱ se ase vaa aꞌmii ꞌo̱ síí uun chij ndoꞌo roꞌ, da̱nj caꞌmii soꞌ rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ne̱ dan me se ꞌo̱ güii naránj rá nij yuvii̱ israelitá, ne̱ yáán ꞌo̱ síí nu̱u̱ nana̱ chre̱e nimán rá veꞌ yoꞌ, ne̱ caguáj soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ne̱ cataj soꞌ se vaa: ―Me cheꞌé raꞌyunj so̱ꞌ man núj, ga̱ Jesús Nazarenoꞌ. ꞌNa̱ꞌ so̱ꞌ ta̱ríꞌ so̱ꞌ man núj naꞌ. Neꞌenj mán so̱ꞌ se vaa síí gue̱e̱ cavii rihaan Diose̱ mé so̱ꞌ ado̱nj ―taj síí nu̱u̱ nana̱ chre̱e nimán rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ga̱a ne̱ canica̱j Jesucristó, caxríj yuva̱a̱ Jesucristó man nana̱ chre̱e nu̱u̱ nimán snóꞌo yoꞌ, ne̱ cataj soꞌ: ―Dínj tuꞌvá so̱ꞌ, cu̱riha̱nj so̱ꞌ cuaj nimán síí nihánj á ―taj Jesucristó rihaan nana̱ chre̱e yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nda̱a quisnúú maꞌa̱n snóꞌo yoꞌ, quiꞌyaj nana̱ chre̱e, ne̱ nucua̱j ndoꞌo caguáj nana̱ chre̱e, ne̱ curiha̱nj nana̱ chre̱e nimán snóꞌo yoꞌ, ne̱ nahuun sa̱ꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ga̱a ne̱ caꞌanj uxrá rá nij yuvii̱, ne̱ xnáꞌanj nij yuvii̱ man tuviꞌ nij yuvii̱, cataj nij yuvii̱: ―Asa̱ꞌ caꞌvee quiꞌyaj soꞌ da̱nj ga̱. Tucuáán naca̱ me nihánj chugua̱nj. ꞌO̱ se guun chij ndoꞌo síí nihánj, ne̱ nda̱a rihaan nij nana̱ chre̱e taj xnaꞌanj síí nihánj da̱j quiꞌya̱j nij soꞌ, ne̱ uno nij nana̱ chre̱e yoꞌ rihaan soꞌ ga̱ ―taj nij yuvii̱ rihaan tuviꞌ nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ga̱a ne̱ cuchiꞌ nana̱ cheꞌé Jesucristó rihaan cunuda̱nj nij yuvii̱ ma̱n nichru̱nꞌ estadó Galilea yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Dan me se curiha̱nj nij tuvi̱ꞌ Jesucristó rá veꞌ tucuꞌyón nii se‑tucua̱nj Moisés, ga̱a ne̱ catúj taranꞌ nij soꞌ rá veꞌ tucuá Simón ga̱ Andrés, ne̱ ꞌnaꞌ Juan ga̱ Jacobo ga̱ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Dan me se nii che̱j Simón roꞌ, ranꞌ noꞌ chiꞌii̱ nacaa yuva̱a̱, ne̱ na̱j noꞌ, ne̱ cataj xnaꞌanj yoꞌo̱ nij soꞌ rihaan Jesucristó se vaa ranꞌ uxrá noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ga̱a ne̱ cuchiꞌ Jesucristó rej na̱j noꞌ, ne̱ canó soꞌ raꞌa noꞌ, ne̱ naxca̱j soꞌ man noꞌ, ne̱ naxaga̱a̱ noꞌ, ne̱ nu̱ꞌ xꞌnéj chiꞌii̱ xráá noꞌ, quiꞌyaj Jesucristó a. Ne̱ veé ma̱a̱n orá dan quiꞌyaj chuvi̱i noꞌ cha̱ nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Dan me se cataꞌ güii, ne̱ tiꞌnuu, ne̱ nica̱j nij yuvii̱ cunuda̱nj tuviꞌ nij yuvii̱ síí ranꞌ do̱ꞌ, síí nu̱u̱ nana̱ chre̱e nimán do̱ꞌ, va̱j nij yuvii̱ rej ne̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ne̱ dan me se queꞌe̱e̱ nij yuvii̱ ma̱n chumanꞌ Capernaum yoꞌ nuu chre̱ꞌ rihaan taꞌyaa veꞌ ne̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ga̱a ne̱ nahuun queꞌe̱e̱ nij síí ranꞌ daj a̱ chiꞌii̱, quiꞌyaj Jesucristó, ne̱ quirii ndoꞌo soꞌ nana̱ chre̱e nimán nij yuvii̱, ne̱ caꞌneꞌ soꞌ suun rihaan nij nana̱ chre̱e se vaa se̱ caꞌmii nij nana̱ chre̱e a̱ doj nana̱ a. Dan me se ne caꞌve̱j rá Jesucristó cata̱j nij nana̱ chre̱e se vaa cunuu ya̱a̱n nij nana̱ chre̱e man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ga̱a ne̱ rej taxre̱j naxaga̱a̱ Jesucristó, ne̱ cavii soꞌ chumanꞌ Capernaum, ne̱ caꞌanj soꞌ rej tacaan cachi̱nj niꞌya̱j soꞌ rihaan Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ga̱a ne̱ canocoꞌ nij tuvi̱ꞌ Simón man soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ga̱a ne̱ nariꞌ nij soꞌ man soꞌ, ne̱ cataj nij soꞌ rihaan soꞌ se vaa: ―Cunuda̱nj nij yuvii̱ nanoꞌ mán so̱ꞌ á ―taj nij tuvi̱ꞌ Simón rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ: ―Cavi̱i̱ níꞌ rej nihánj, caꞌa̱nj níꞌ yoꞌó nij chumanꞌ na̱j nichru̱nꞌ, ne̱ caꞌmi̱i̱ natáj ꞌu̱nj rihaan nij yuvii̱ ma̱n yoꞌó nij chumanꞌ uún á. ꞌO̱ se cheꞌé dan caꞌnáꞌ ꞌu̱nj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ga̱a ne̱ caꞌanj soꞌ nu̱ꞌ nij chumanꞌ na̱j estadó Galilea, ne̱ caꞌmii natáj soꞌ rá veꞌ tucuꞌyón nij síí ma̱n nij chumanꞌ yoꞌ se‑tucua̱nj Moisés, ne̱ quirii soꞌ man nij nana̱ chre̱e nu̱u̱ nimán yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ga̱a ne̱ caꞌnaꞌ ꞌo̱ síí ranꞌ luj riꞌyuj, ne̱ canicunꞌ ru̱j soꞌ rihaan Jesucristó, ne̱ cachíín niꞌya̱j soꞌ rihaan Jesucristó, ne̱ cataj soꞌ se vaa: ―Sese me rá so̱ꞌ, ne̱ caꞌve̱e caꞌne̱e̱ so̱ꞌ chiꞌii̱ xráj á ―taj síí ranꞌ luj riꞌyuj yoꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ga̱a ne̱ cunuu ꞌe̱e̱ rá Jesucristó man soꞌ, ne̱ cutaꞌ Jesucristó raꞌa Jesucristó raa̱ soꞌ, ne̱ cataj Jesucristó: ―Me raj qui̱ꞌyáj da̱nj ei. Na̱huún so̱ꞌ qui̱ꞌyáj ado̱nj ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nu̱ꞌ da̱nj cataj Jesucristó, ne̱ nu̱ꞌ quinavij luj xráá síí ranꞌ, ne̱ nahuun sa̱ꞌ soꞌ cuaj a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ga̱a ne̱ caꞌmii yuva̱a̱ Jesucristó ga̱ soꞌ, ne̱ quirii Jesucristó man soꞌ rá veꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ne̱ cataj Jesucristó rihaan soꞌ: ―Se̱ guun cata̱j xnaꞌanj so̱ꞌ a̱ doj nana̱ rihaan a̱ ꞌó yuvii̱ maꞌ. Ma̱a̱n se caꞌa̱nj so̱ꞌ rihaan xrej, ne̱ ti̱haán so̱ꞌ mán so̱ꞌ rihaan xrej se vaa nahuún so̱ꞌ, quiꞌyaj Diose̱, ne̱ rque̱ so̱ꞌ rihaan Diose̱ nda̱a vaa cataj síí cuꞌna̱j Moisés ga̱a naá nda̱a vaa no̱ xcúún so̱ꞌ rque̱ so̱ꞌ rihaan Diose̱ cheꞌé yan nahuún so̱ꞌ ado̱nj. Ga̱a ne̱ xca̱j nij xrej cuentá se vaa nahuún so̱ꞌ quiꞌyáj ado̱nj ―taj Jesucristó rihaan síí nahuun yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tza̱j ne̱ curiha̱nj síí nahuun yoꞌ, ne̱ guun cheꞌe̱ soꞌ caꞌmii natáj ndoꞌo soꞌ, nda̱a síj, ga̱a ne̱ chaꞌnuu̱ ndoꞌo nana̱ se vaa nahuun soꞌ quiꞌyaj Jesucristó a. Ne̱ dan me se ne caꞌve̱e a̱ doj catu̱u̱ ranga̱ꞌ Jesucristó rá nij chumanꞌ, quiꞌyaj nij nana̱ yoꞌ, ne̱ ina̱nj rej tacaan va̱j soꞌ, ne̱ canó nij yuvii̱ cuchiꞌ rej va̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Dan me se cachén do̱j güii, ga̱a ne̱ catúj uún Jesucristó chumanꞌ Capernaum, ga̱a ne̱ cuchiꞌ nana̱ rihaan nij yuvii̱ se vaa ya̱nj soꞌ rá veꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ga̱a ne̱ cunuu chre̱ꞌ queꞌe̱e̱ ndoꞌo nij yuvii̱ rihaan veꞌ yoꞌ, ne̱ nda̱a raan maꞌa̱n mán nij yuvii̱, ne̱ nda̱a rihaan taꞌyaa veꞌ yoꞌ taj rej quisi̱j doj cuma̱n nij yuvii̱ a. Ne̱ nataꞌ Jesucristó se‑na̱na̱ soꞌ rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ne̱ dan me se caꞌnaꞌ doj yuvii̱ uún, ne̱ nij soꞌ me se nica̱j nij soꞌ yoꞌo̱ tuviꞌ nij soꞌ síí naꞌvee cache̱e̱, ne̱ táá chiha̱ caꞌa̱nj nij soꞌ man síí naꞌvee cache̱e̱ yoꞌ, ne̱ dan me se guun rá nij soꞌ cuchi̱ꞌ síí naꞌvee cache̱e̱ yoꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tza̱j ne̱ ne caꞌve̱e cuchi̱ꞌ síí naꞌvee cache̱e̱ yoꞌ rihaan Jesucristó, quiꞌyaj nij soꞌ a̱ maꞌ. ꞌO̱ se ma̱n uxrá yuvii̱, ne̱ ne caꞌve̱e cache̱n nij soꞌ a. Cheꞌé dan cavii nij soꞌ xráá veꞌ, ne̱ cayaꞌ nij soꞌ yuꞌuj xráá veꞌ rej nicu̱nꞌ Jesucristó rá veꞌ, ne̱ tananij nij soꞌ yuvéé táá síí naꞌvee cache̱e̱ yoꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Dan me se ga̱a queneꞌen Jesucristó se vaa cuchumán uxrá rá nij tuviꞌ síí naꞌvee cache̱e̱ yoꞌ se vaa caꞌve̱e nahu̱un soꞌ quiꞌya̱j Jesucristó, ga̱a ne̱ cataj soꞌ rihaan síí naꞌvee cache̱e̱ yoꞌ: ―Navij cacunꞌ xráá so̱ꞌ, na̱nj tinu̱j ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ne̱ ne̱ do̱j síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rá veꞌ yoꞌ ga̱ Jesucristó, ne̱ nuchruj ra̱a̱ nij soꞌ, ne̱ guun rá nij soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Me cheꞌé aꞌmii síí nihánj da̱nj ga̱. ꞌO̱ se aꞌmii soꞌ nana̱ vaa nij rihaan Diose̱ asan. O̱rúnꞌ Diose̱ gu̱un nucua̱j tinavi̱j cacunꞌ xráá yuvii̱ na̱nj á”, guun rá nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Dan me se queneꞌen maꞌa̱n Jesucristó se vaa guun rá nij soꞌ da̱nj, ne̱ cheꞌé dan cataj soꞌ: ―Me cheꞌé nuchruj ra̱a̱ soj nana̱ na̱nj ga̱. ");
INSERT INTO trcNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Tuꞌva rma̱ꞌán ꞌu̱nj se vaa navij cacunꞌ xráá síí nihánj, rá soj a̱ naꞌ. Caꞌve̱e cata̱j u̱u̱n níꞌ navij cacunꞌ xráá síí nihánj naꞌ. Ase caꞌve̱e doj cata̱j níꞌ na̱xagaa soꞌ, ne̱ nacue̱ soꞌ tuvéé soꞌ, ne̱ cache̱e̱ soꞌ cuaj, cata̱j níꞌ xa̱ꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Dan me se me rá ꞌu̱nj xca̱j soj cuentá se vaa síí caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ mej ne̱ no̱ xcúún ꞌu̱nj ti̱navíí ꞌu̱nj cacunꞌ xráá nij yuvii̱ ma̱n rihaan chumii̱ nihánj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. Dan me se cataj Jesucristó rihaan síí naꞌvee cache̱e̱ a: ");
INSERT INTO trcNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Rihaan so̱ꞌ si̱j naꞌvee cache̱e̱ taj ꞌu̱nj, ne̱ nacue̱ so̱ꞌ tuvéé so̱ꞌ, ne̱ na̱nꞌ so̱ꞌ tucuá so̱ꞌ á ―taj Jesucristó rihaan síí na̱j rihaan yuvéé yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ga̱a ne̱ naxaga̱a̱ síí naꞌvee cache̱e̱ yoꞌ, ne̱ nacué soꞌ tuvéé soꞌ, ga̱a ne̱ curiha̱nj soꞌ rá veꞌ, niꞌya̱j taranꞌ nij yuvii̱ ma̱n rá veꞌ a. Nda̱a síj, ga̱a ne̱ caꞌanj rá nij yuvii̱, ne̱ cataj nij yuvii̱ se vaa sa̱ꞌ uxrá quiꞌyaj Diose̱, ne̱: ―Daj chiha̱a̱ míj ne queneꞌe̱n níꞌ suun da̱nj a̱ man ado̱nj ―taj nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ga̱a ne̱ curiha̱nj uún Jesucristó, caꞌanj soꞌ tuꞌva na lacuaná, ga̱a ne̱ caꞌnaꞌ cunuda̱nj nij yuvii̱ rej va̱j soꞌ, ga̱a ne̱ tucuꞌyón soꞌ man nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Veé da̱nj vaj soꞌ, ne̱ queneꞌen soꞌ man síí cuꞌna̱j Leví taꞌníí síí cuꞌna̱j Alfeo, ne̱ dan me se ne̱ soꞌ ꞌo̱ veꞌ aꞌnéj nii puextó, ne̱ aꞌnéj soꞌ puextó man yuvii̱ a. Ga̱a ne̱ cataj Jesucristó rihaan soꞌ, ne̱: ―Ca̱nocóꞌ so̱ꞌ manj, caꞌa̱nj níꞌ á ―taj Jesucristó rihaan soꞌ a. Ga̱a ne̱ naxuma̱a̱n soꞌ, ne̱ canocoꞌ soꞌ man Jesucristó, caꞌanj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Dan me se ꞌo̱ güii yáán Jesucristó rá veꞌ tucuá síí cuꞌna̱j Leví yoꞌ, ne̱ caꞌnaꞌ ndoꞌo tuviꞌ soꞌ síí aꞌnéj puextó do̱ꞌ, yoꞌó nij síí tumé ndoꞌo cacunꞌ do̱ꞌ, ne̱ catúj nij soꞌ rá veꞌ, ne̱ caꞌanj ca̱yáán nij soꞌ ga̱ Jesucristó, ne̱ dan me se ma̱n rcuaꞌa̱a̱n nij síí tucuꞌyón se‑na̱na̱ Jesucristó do̱ꞌ, ne̱ chá cunuda̱nj nij soꞌ chraa a. ꞌO̱ se queꞌe̱e̱ ndoꞌo nij síí tumé cacunꞌ yoꞌ me canocoꞌ se‑na̱na̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ga̱a ne̱ nij síí fariseo naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ roꞌ, queneꞌen nij soꞌ se vaa chá Jesucristó chraa do̱ꞌ, coꞌo Jesucristó do̱ꞌ, ga̱ nij síí aꞌnéj puextó do̱ꞌ, ga̱ yoꞌó nij síí tumé ndoꞌo cacunꞌ do̱ꞌ, ga̱a ne̱ cataj nij soꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ Jesucristó, ne̱: ―Me cheꞌé chá síí nihánj chraa ne̱ coꞌo soꞌ na ga̱ nij síí aꞌnéj puextó do̱ꞌ, ga̱ yoꞌó nij síí tumé cacunꞌ do̱ꞌ, ga̱ ―taj nij soꞌ, xnáꞌanj nij soꞌ man nij síí tucuꞌyón se‑na̱na̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ne̱ cuno Jesucristó nana̱ caꞌmii nij soꞌ, ga̱a ne̱ cataj soꞌ rihaan nij soꞌ a: ―Síí vaa nucua̱j roꞌ, ne nanoꞌ nij soꞌ man doctor maꞌ. Ma̱a̱n síí ranꞌ roꞌ, me síí nanoꞌ man doctor ado̱nj. Ga̱a ne̱ ase vaa síí ranꞌ roꞌ, da̱nj vaa nij síí nihánj ado̱nj. Ne caꞌna̱ꞌ ꞌu̱nj canacu̱nj ꞌu̱nj man síí sa̱ꞌ maꞌ. Cheꞌé nij síí tumé cacunꞌ caꞌnaj se vaa canoco̱ꞌ nij soꞌ se‑na̱na̱j ado̱nj. Tza̱j ne̱ sese síí sa̱ꞌ me soj, rá soj, ne̱ nuveé si̱j canacu̱nj ꞌu̱nj man me soj maꞌ ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ne̱ dan me se tocoꞌ nij síí tucuꞌyón se‑na̱na̱ Juan do̱ꞌ, nij síí fariseo do̱ꞌ, xꞌnaa man maꞌa̱n nij soꞌ, ne̱ caꞌnaꞌ nij soꞌ rihaan Jesucristó, ne̱ xnáꞌanj nij soꞌ man Jesucristó, cataj nij soꞌ: ―Me cheꞌé, ne̱ tocoꞌ núj si̱j tucuꞌyón se‑na̱na̱ Juan do̱ꞌ, si̱j tucuꞌyón se‑na̱na̱ nij síí fariseo do̱ꞌ, xꞌnaa man maꞌa̱n núj cheꞌé se aráj gue̱e̱ núj rihaan Diose̱, tza̱j ne̱ nij síí tucuꞌyón se‑na̱na̱ so̱ꞌ me se ne tocoꞌ nij soꞌ xꞌnaa man maꞌa̱n nij soꞌ ga̱ ―taj nij soꞌ, xnáꞌanj nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Ase vaa síí cuchruj saꞌanj vaa ꞌu̱nj, ne̱ asa̱ꞌ caꞌve̱e toco̱ꞌ nij síí ma̱n ga̱j xꞌnaa man maꞌa̱n nij soꞌ, rá soj ga̱. Ase vaa síí cataj xca̱j man chana̱ ne̱ ma̱n tuviꞌ soꞌ do̱ꞌ, da̱nj vaa nij síí ma̱n nihánj cuano̱, ne̱ anuû ndoꞌo chaꞌanj man nij soꞌ, ne̱ se̱ caꞌvee toco̱ꞌ nij soꞌ xꞌnaa man maꞌa̱n nij soꞌ cuano̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tza̱j ne̱ vaa güii, ne̱ gu̱un yaníj ꞌu̱nj rihaan nij soꞌ, quiꞌya̱j yuvii̱, ga̱a ne̱ nano̱ rá nij síí nihánj, ga̱a ne̱ toco̱ꞌ nij soꞌ xꞌnaa man maꞌa̱n nij soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","”Tza̱j ne̱ ase vaa yatzíj sinꞌ vaa tucuáán nga̱ noco̱ꞌ soj, ne̱ se̱ guun naꞌne̱j níꞌ mantá naca̱ man yatzíj nga̱ yoꞌ maꞌ. ꞌO̱ se sese quiꞌya̱j níꞌ da̱nj, ne̱ güii quina̱nj yuvii̱ yatzíj yoꞌ, ga̱a ne̱ nagüe̱j mantá naca̱ yoꞌ, ne̱ sese cuxu̱u̱n yuvii̱ man yatzíj yoꞌ, ne̱ quisi̱nꞌ yoꞌ, ga̱a ne̱ cunu̱u xi̱j doj yuꞌuj ta̱j man yatzíj nga̱ yoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ne̱ dan me se ase vaa nuj nga̱ nuj araa nii na vinó vaa uún soj ei. Ne̱ se̱ caꞌvee tu̱cuꞌyón ꞌu̱nj se‑tucua̱nj ꞌu̱nj rihaan soj maꞌ. ꞌO̱ se ase vaa na vinó naca̱ vaa nana̱ tucuꞌyón ꞌu̱nj, ne̱ se̱ guun cara̱a yuvii̱ na vinó naca̱ rque nuj nga̱ maꞌ. Sese da̱nj quiꞌya̱j yuvii̱, ne̱ cuya̱nj na vinó cunu̱u xe̱e̱ na vinó, ne̱ se̱ cacuá nuj nga̱ maꞌ. Cheꞌé dan canu̱u̱ yoꞌ, ne̱ caya̱nj na vinó rihaan yoꞌóó a. Cheꞌé dan araa nii na vinó naca̱ rque nuj naca̱, ne̱ ꞌo̱ mán sa̱ꞌ na vinó rque nuj yoꞌ a. Cheꞌé dan ina̱nj rihaan síí naca̱ síí ne nocoꞌ tucuáán nga̱ tu̱cuꞌyón ꞌu̱nj se‑na̱na̱j na̱nj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ síí cuꞌna̱j Juan do̱ꞌ, rihaan nij síí tucuꞌyón se‑na̱na̱ nij síí fariseo do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ꞌO̱ güii naránj rá nij yuvii̱ israelitá cachén Jesucristó ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ rque ꞌo̱ naa̱ ꞌnúú trigó, ne̱ guun cheꞌe̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ va̱j nij soꞌ ne̱ cuta nij soꞌ do̱j caa trigó a. ");
INSERT INTO trcNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ga̱a ne̱ cataj nij síí fariseo rihaan Jesucristó a: ―Ni̱ꞌyaj so̱ꞌ ei. Me cheꞌé ꞌyaj nij síí tucuꞌyón se‑na̱na̱ so̱ꞌ da̱nj ga̱. Ne nó xcúún níꞌ quiꞌya̱j níꞌ da̱nj güii naránj rá maꞌ ―taj nij síí fariseo rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Me cheꞌé, ne̱ ne naya̱a̱ soj rihaan danj Diose̱ da̱j quiꞌyaj síí cuꞌna̱j David ga̱a naá a. Ga̱a quinaꞌaan rque nij tuvi̱ꞌ nij soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ga̱a ne̱ catúj soꞌ rá nuvií ga̱a cayáán síí cuꞌna̱j Abiatar xrej ata̱ suun noco̱o doj, ne̱ chá soꞌ rachrúún ta̱j rihaan se‑mesa̱ Diose̱ a. Ne̱ ne nó xcúún soꞌ cha̱ soꞌ rachrúún yoꞌ, ma̱a̱n o̱rúnꞌ nij xrej nó xcúún cha̱ rachrúún yoꞌ a. Ne̱ goꞌ uún síí cuꞌna̱j David yoꞌ chá nij tuviꞌ soꞌ uún a. Tza̱j ne̱ ne cata̱j Diose̱ se vaa tumé síí cuꞌna̱j David cacunꞌ maꞌ ―taj Jesucristó rihaan nij síí fariseo, ");
INSERT INTO trcNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ga̱a ne̱ cataj uún soꞌ rihaan nij síí fariseo a― Ma̱a̱n cheꞌé rej caꞌve̱e cavi̱i̱ sa̱ꞌ nij yuvii̱ me cuchruj Diose̱ güii naránj rá na̱nj á. Nuveé cheꞌe̱ rej ca̱ta̱ nij yuvii̱ suun navi̱j rá güii naránj rá me quiꞌyaj Diose̱ man nij yuvii̱ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Cheꞌé dan me, ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ roꞌ, no̱ xcúnj quiri̱i̱ taꞌngaj da̱j quiꞌya̱j yuvii̱ güii naránj rá na̱nj ado̱nj ―taj Jesucristó rihaan nij síí fariseo a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ga̱a ne̱ natúj Jesucristó rá veꞌ tucuꞌyón nij síí israelitá se‑tucua̱nj Moisés, ne̱ dan me se yáán ꞌo̱ snóꞌo nacoo̱ raꞌa rá veꞌ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ne̱ nij síí fariseo me se yáán nij soꞌ rá veꞌ yoꞌ, ne̱ tumé uxrá nij soꞌ man Jesucristó sese nahu̱un yuvii̱ quiꞌya̱j soꞌ ga̱a güii naránj rá nij yuvii̱ israelitá a. Da̱nj quiꞌyaj nij soꞌ cheꞌé rej guun rá nij soꞌ cuta̱ꞌ nij soꞌ cacunꞌ xráá Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ga̱a ne̱ cataj Jesucristó rihaan síí nacoo̱ raꞌa a: ―Na̱xuma̱a̱n so̱ꞌ canicu̱nꞌ ca̱yá so̱ꞌ scaꞌnúj núj á ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ga̱a ne̱ xnáꞌanj Jesucristó man nij síí fariseo yoꞌ, cataj soꞌ, ne̱: ―No̱ xcúún níꞌ ra̱cuíj níꞌ man tuviꞌ níꞌ güii naránj rá níꞌ naꞌ, ase no̱ xcúún níꞌ quiꞌya̱j chiꞌi̱i̱ níꞌ man tuviꞌ níꞌ xa̱ꞌ. Da̱j quiꞌya̱j níꞌ rá soj ga̱a güii naránj rá níꞌ ga̱. Ne nó xcúún níꞌ ti̱nanii níꞌ man tuviꞌ níꞌ rihaan sayuun ga̱a güii naránj rá ga̱a̱ a̱ naꞌ. Ni̱ꞌyaj u̱u̱n níꞌ cavi̱ꞌ soꞌ ga̱a güii naránj rá ga̱a̱ a̱ naꞌ. ―Da̱nj taj Jesucristó rihaan nij soꞌ a. Tza̱j ne̱ dínj tuꞌva nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ga̱a ne̱ caꞌmaan rá Jesucristó, ne̱ niꞌya̱j soꞌ man nij síí fariseo yoꞌ a. ꞌO̱ se nanó ndoꞌo rá soꞌ cheꞌé nij soꞌ se vaa síí nichra̱j ndoꞌo nimán me nij soꞌ a. Ga̱a ne̱ cataj Jesucristó rihaan síí nacoo̱ raꞌa yoꞌ a: ―Tu̱cuá so̱ꞌ raꞌá so̱ꞌ á ―taj Jesucristó rihaan soꞌ a. Ne̱ tucuá soꞌ raꞌa soꞌ, ne̱ cunuu sa̱ꞌ raꞌa soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ga̱a ne̱ curiha̱nj nij síí fariseo yoꞌ, ne̱ cunuu chre̱ꞌ nij soꞌ ga̱ nij síí noco̱ꞌ man síí cuꞌna̱j Herodes, ne̱ caꞌanj nij soꞌ rej yaníj, ne̱ guun rá taranꞌ nij soꞌ da̱j ga̱a̱ quiꞌya̱j nij soꞌ ne̱ cavi̱ꞌ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ga̱a ne̱ cavii Jesucristó ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ rej yoꞌ, ne̱ caꞌanj soꞌ tuꞌva na lacuaná a. Ne̱ canocoꞌ uxrá yuvii̱ man soꞌ a. Dan me se síí ma̱n estadó Galilea do̱ꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","síí ma̱n estadó Judea do̱ꞌ, síí ma̱n chumanꞌ Jerusalén do̱ꞌ, síí ma̱n estadó Idumea do̱ꞌ, síí ma̱n rej rne̱j chráá cuꞌna̱j Jordán do̱ꞌ, síí ma̱n chumanꞌ Tiro do̱ꞌ, síí ma̱n chumanꞌ Sidón do̱ꞌ, cuno nij soꞌ nana̱ da̱j quiꞌyaj Jesucristó cheꞌé nij síí ranꞌ, ne̱ cheꞌé dan caꞌnaꞌ ndoꞌo nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ga̱a ne̱ cataj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ se vaa quiꞌya̱j chuvi̱i nij soꞌ ꞌo̱ rihoo chéé rihaan na catu̱u̱ soꞌ, ga̱a ne̱ se̱ gaa na̱nj curuꞌma̱an nij yuvii̱ man soꞌ, taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ꞌO̱ se nahuun sa̱ꞌ uxrá yuvii̱, quiꞌyaj Jesucristó, nda̱a síj, ga̱a ne̱ taranꞌ nij síí ranꞌ roꞌ, canocoꞌ uxrá nij soꞌ man Jesucristó cheꞌé rej caꞌve̱e cano̱ raꞌa nij soꞌ man soꞌ ga̱a ne̱ nahu̱un sa̱ꞌ nij soꞌ, rá nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ne̱ nij síí nu̱u̱ nana̱ chre̱e nimán roꞌ, ga̱a queneꞌen nij soꞌ man Jesucristó, ne̱ caꞌanj quina̱j nij soꞌ rihaan yoꞌóó tacóó Jesucristó, ne̱ cataj nij nana̱ chre̱e se vaa: ―So̱ꞌ me taꞌníí Diose̱ ya̱ ado̱nj ―taj nij nana̱ chre̱e rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ga̱a ne̱ caꞌneꞌ ndoꞌo Jesucristó suun rihaan nij nana̱ chre̱e se vaa se̱ guun nata̱ꞌ nij soꞌ rihaan nij yuvii̱ cheꞌé soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ga̱a ne̱ cavii Jesucristó xráá quij, ne̱ canacúún soꞌ man nij síí me rá soꞌ caꞌna̱ꞌ rihaan soꞌ, ga̱a ne̱ cavii nij soꞌ, ne̱ cuchiꞌ nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ga̱a ne̱ quinarii Jesucristó man chuvi̱j nij soꞌ se vaa gu̱un nij soꞌ apóstol nata̱ꞌ rihaan yuvii̱ cheꞌé soꞌ a. ꞌO̱ se guun rá soꞌ se vaa cache̱e̱ chuvi̱j nij soꞌ ga̱ soꞌ, ne̱ guun rá soꞌ caꞌne̱j soꞌ man chuvi̱j nij soꞌ caꞌmi̱i̱ natáj nij soꞌ rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ne̱ guun rá soꞌ nago̱ꞌ soꞌ suun uun chij raꞌa nij soꞌ cheꞌé rej caꞌve̱e nahu̱un sa̱ꞌ nij síí ranꞌ ne̱ quiri̱i̱ nij soꞌ man nij nana̱ chre̱e nimán nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Dan me se cuneꞌ Jesucristó man síí cuꞌna̱j Simón, ne̱ tucuꞌnáj soꞌ Pedró man Simón a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ne̱ cuneꞌ soꞌ man síí cuꞌna̱j Jacobo taꞌníí síí cuꞌna̱j Zebedeo, ne̱ cuneꞌ soꞌ man tinúú Jacobo síí cuꞌna̱j Juan, ne̱ tucuꞌnáj soꞌ Boanerges man ro̱j soꞌ, ne̱ nana̱ “Boanerges” roꞌ, taj se vaa ase vaa taꞌníí yaꞌanj tuꞌvi̱i vaa ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ne̱ cuneꞌ soꞌ man síí cuꞌna̱j Andrés do̱ꞌ, man síí cuꞌna̱j Felipé do̱ꞌ, man síí cuꞌna̱j Bartolomé do̱ꞌ, man síí cuꞌna̱j Mateo do̱ꞌ, man síí cuꞌna̱j Tomás do̱ꞌ, man síí cuꞌna̱j Jacobo taꞌníí síí cuꞌna̱j Alfeo do̱ꞌ, man síí cuꞌna̱j Tadeo do̱ꞌ a. Ne̱ cuneꞌ soꞌ man yoꞌó síí cuꞌna̱j Simón, ne̱ tuviꞌ nij síí me rá cunu̱ꞌ ga̱ gobiernó ma̱n Romá me soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ne̱ cuneꞌ Jesucristó man síí cuꞌna̱j Judas Iscariote, ne̱ soꞌ me síí tacuachén man Jesucristó rihaan nij síí ta̱j riꞌyunj man Jesucristó a. Ga̱a ne̱ catúj Jesucristó rá veꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ga̱a ne̱ cunuu chre̱ꞌ ndoꞌo uún nij yuvii̱ rihaan soꞌ, ne̱ dan me se guun chru̱j ndoꞌo rihaan Jesucristó ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ, quiꞌyaj nij yuvii̱, ne̱ nda̱a ne ga̱a̱ yaꞌnúj rihaan Jesucristó ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ cha̱ nij soꞌ chraa, quiꞌyaj nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ga̱a ne̱ cuchiꞌ nana̱ rihaan nij tuviꞌ Jesucristó da̱j ranꞌ soꞌ ꞌyaj nij yuvii̱, ne̱ cheꞌé dan caꞌanj nij tuviꞌ Jesucristó qui̱taꞌaa nij soꞌ man Jesucristó a. ꞌO̱ se guun rá nij tuviꞌ Jesucristó se vaa guun snu̱j Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ga̱a ne̱ nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés síí cavii chumanꞌ Jerusalén roꞌ, cataj nij soꞌ se vaa síí chre̱e uun chij síí cuꞌna̱j Beelzebú nuû nimán Jesucristó, ne̱ cheꞌé dan guun nucua̱j Jesucristó quiri̱i̱ Jesucristó nana̱ chre̱e nimán yuvii̱ quiꞌyaj síí chre̱e uun chij yoꞌ, taj nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ga̱a ne̱ canacúún Jesucristó man nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés, ne̱ nanó soꞌ do̱j cuentó rihaan nij soꞌ, ne̱ dan me se cataj soꞌ, ne̱: ―Asa̱ꞌ caꞌve̱e quiri̱i̱ síí chre̱e síí cuꞌna̱j Satanás man maꞌa̱n tuviꞌ soꞌ nana̱ chre̱e nimán nij yuvii̱, rá nij soj ga̱. Daj chiha̱a̱ míj se̱ caꞌvee quiꞌya̱j soꞌ da̱nj a̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Neꞌen soj se vaa sese vaa ꞌo̱ nación, ne̱ sese xraꞌ taꞌa̱j nij síí uun chij rihaan nación yoꞌ ne̱ cunu̱ꞌ maꞌa̱n nij soꞌ ga̱ tuviꞌ nij soꞌ, ne̱ vaa güii, ne̱ nu̱ꞌ nación yoꞌ quiri̱ꞌ nu̱ꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ne̱ sese unuꞌ taꞌa̱j nij yuvii̱ ma̱n ꞌo̱ barrió ga̱ tuviꞌ yuvii̱ síí ma̱n maꞌa̱n barrió yoꞌ, ne̱ vaa güii, ne̱ quiri̱ꞌ nu̱ꞌ barrió yoꞌ, quiꞌya̱j nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Cheꞌé dan me sese unuꞌ síí chre̱e síí cuꞌna̱j Satanás ga̱ tuviꞌ maꞌa̱n soꞌ, ne̱ sese ra̱cuíj síí chre̱e mán ꞌu̱nj quiri̱i̱ ꞌu̱nj nana̱ chre̱e nimán nij yuvii̱, ne̱ se̱ caꞌvee gu̱un chij síí chre̱e yoꞌ sese navi̱j tuviꞌ soꞌ maꞌ. Ma̱a̱n se quiri̱ꞌ nu̱ꞌ soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","”Ne̱ sese me rá yoꞌo̱ soꞌ catu̱u̱ soꞌ rá veꞌ tucuá síí ruꞌvee quiꞌya̱j itu̱u̱ soꞌ siꞌyaj síí ruꞌvee yoꞌ, ne̱ asino nu̱míj soꞌ man síí ruꞌvee yoꞌ, ga̱a ne̱ ca̱nica̱j soꞌ catzi̱j soꞌ tucuá síí ruꞌvee yoꞌ ei. Ne̱ ase vaa ꞌyaj síí atúj tucuá síí ruꞌvee roꞌ, da̱nj ꞌyáj man síí chre̱e yoꞌ chugua̱nj. Dan me se numíj ꞌu̱nj man soꞌ, ne̱ cuano̱ nihánj aꞌnéj ꞌu̱nj man nu̱ꞌ nij síí ꞌni̱j raꞌa soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","”Cata̱j xnaꞌanj yá yá ꞌu̱nj rihaan soj cuano̱ se vaa nu̱ꞌ cacunꞌ tumé yuvii̱ do̱ꞌ, me maꞌa̱n nana̱ chiꞌi̱i̱ caꞌmi̱i̱ yuvii̱ do̱ꞌ, caꞌve̱e tinavi̱j Diose̱ cacunꞌ yoꞌ cheꞌé nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tza̱j ne̱ sese nachri̱ꞌ yoꞌo̱ soꞌ ni̱ꞌyaj soꞌ man Nimán Diose̱, ne̱ daj chiha̱a̱ míj se̱ quinavij cacunꞌ yoꞌ xráá soꞌ a̱ maꞌ. Tana̱nj quita̱j cacunꞌ yoꞌ xráá soꞌ nu̱ꞌ cavii nu̱ꞌ caꞌanj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","―Da̱nj cataj Jesucristó rihaan nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés, cheꞌé se a̱j cataj nij soꞌ se vaa nana̱ chre̱e nuû nimán soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ga̱a ne̱ caꞌnaꞌ nii Jesucristó do̱ꞌ, tinúú Jesucristó do̱ꞌ, ne̱ nicu̱nꞌ nij soꞌ xeꞌ rihaan veꞌ nu̱u̱ Jesucristó, ne̱ caꞌnéé nij soꞌ nana̱ rihaan Jesucristó se vaa cu̱riha̱nj soꞌ caꞌna̱ꞌ soꞌ rej nicu̱nꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ne̱ yáán ndoꞌo yuvii̱ nu̱ꞌ anica̱j rej ne̱ Jesucristó, ne̱ cataj nii rihaan Jesucristó a: ―Nicu̱nꞌ nií so̱ꞌ nicu̱nꞌ tinúú so̱ꞌ nicu̱nꞌ xeꞌ, ne̱ me rá nij soꞌ queneꞌe̱n nij soꞌ mán so̱ꞌ, Jesús ―taj nii rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ga̱a ne̱ cataj Jesucristó rihaan nij síí nataꞌ rihaan soꞌ se vaa: ―Me chana̱ me nií ꞌu̱nj, rá soj ga̱. Me síí me tinúú ꞌu̱nj, rá soj ga̱ ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ga̱a ne̱ niꞌya̱j Jesucristó man nij síí ya̱nj nu̱ꞌ anica̱j rej ne̱ soꞌ, ne̱ cataj soꞌ a: ―Ni̱ꞌyaj soj ei. Ase vaa nií ꞌu̱nj do̱ꞌ, ase vaa tinúú ꞌu̱nj do̱ꞌ, vaa nij síí nihánj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yuvii̱ uno rihaan Diose̱ roꞌ, ase vaa tinúú ꞌu̱nj do̱ꞌ, ase vaa raꞌvij ꞌu̱nj do̱ꞌ, ase vaa nií ꞌu̱nj do̱ꞌ, vaa nij soꞌ ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ga̱a ne̱ caꞌanj Jesucristó tuꞌva na lacuaná, ne̱ guun cheꞌe̱ soꞌ tucuꞌyón soꞌ se‑na̱na̱ soꞌ rihaan yuvii̱ tuꞌva na lacuaná a. Ne̱ dan me se caꞌnaꞌ ndoꞌo yuvii̱ rihaan soꞌ, ne̱ cheꞌé dan cavii soꞌ rque ꞌo̱ rihoo chéé rihaan na, ne̱ caꞌanj cane̱ soꞌ rque rihoo yoꞌ, ne̱ canicunꞌ nij yuvii̱ rihaan yoꞌóó tuꞌva na lacuaná yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ga̱a ne̱ tucuꞌyón soꞌ man nij yuvii̱, nanó ndoꞌo soꞌ cuentó rihaan nij yuvii̱, ne̱ dan me se cataj soꞌ rihaan nij yuvii̱ a: ");
INSERT INTO trcNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Cuno̱ soj caꞌmi̱j á. Dan me se curiha̱nj ꞌo̱ síí me rá cuchru̱j naa̱ ꞌnúú trigó, ne̱ tixꞌnuu̱ soꞌ ꞌnúú trigó yoꞌ rihaan yoꞌóó, ");
INSERT INTO trcNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ne̱ cayuu do̱j ꞌnúú trigó yoꞌ rá chrej chéé yuvii̱, ne̱ caꞌnaꞌ xtâj chá xtâj man ꞌnúú trigó na̱j rá chrej yoꞌ, ne̱ dan me se navij nu̱ꞌ ꞌnúú trigó yoꞌ, quiꞌyaj nij xtâj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ne̱ yoꞌó taꞌa̱j ꞌnúú trigó yoꞌ roꞌ, cayuu rihaan yuvej rej ta̱j catu̱nꞌ yoꞌóó a. Cheꞌé dan cuaj xraꞌ stanj leꞌe̱j a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Veé dan, ne̱ quisíj güii, ne̱ cuchrii naa̱ leꞌe̱j, quiꞌyaj naán, cheꞌé se ne caꞌve̱e caꞌa̱nj ni̱j yáá naa̱ leꞌe̱j yoꞌ a̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ne̱ yoꞌó taꞌa̱j ꞌnúú trigó yoꞌ roꞌ, cayuu scaꞌnúj coj tanj, ne̱ dan me se yo̱o doj cachij coj tanj yoꞌ rihaan naa̱ leꞌe̱j, ne̱ quinavij nu̱ꞌ naa̱ leꞌe̱j, quiꞌyaj coj tanj yoꞌ, ne̱ ne cavi̱i̱ sa̱ꞌ naa̱ yoꞌ a̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ne̱ yoꞌó taꞌa̱j ꞌnúú trigó yoꞌ roꞌ, cayuu rihaan yoꞌóó sa̱ꞌ, ne̱ naa̱ yoꞌ roꞌ, cachij sa̱ꞌ a. Dan me se rihaan taꞌa̱j yoꞌóó sa̱ꞌ yoꞌ ico̱ chi̱ꞌ ya̱ ꞌnúú cavii, quiꞌyaj ꞌo̱ ꞌo̱ ꞌnúú leꞌe̱j nii quinij rihaan yoꞌóó sa̱ꞌ yoꞌ, ne̱ rihaan yoꞌó taꞌa̱j yoꞌóó sa̱ꞌ yoꞌ vaꞌnu̱j chiha̱a̱ ya̱ ꞌnúú cavii, quiꞌyaj ꞌo̱ ꞌo̱ ꞌnúú leꞌe̱j nii quinij rihaan yoꞌóó sa̱ꞌ yoꞌ, ne̱ rihaan yoꞌó taꞌa̱j yoꞌóó sa̱ꞌ yoꞌ cientó ya̱ ꞌnúú trigó cavii, quiꞌyaj ꞌo̱ ꞌo̱ ꞌnúú leꞌe̱j nii cayuu rihaan yoꞌóó sa̱ꞌ yoꞌ uún na̱nj ado̱nj ―taj Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ga̱a ne̱ cataj uún soꞌ― Sese ta̱j yuꞌuj xréé soj, ne̱ cuno̱ soj nana̱ nihánj ei. ―Veé da̱nj quisíj cuentó yoꞌ cuentó nanó Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ga̱a ne̱ ga̱a guun yaníj soꞌ rihaan nij yuvii̱, ne̱ nij síí chéé ga̱ soꞌ do̱ꞌ, chuvi̱j nij apóstol cuneꞌ soꞌ man nata̱ꞌ rihaan yuvii̱ cheꞌé soꞌ do̱ꞌ, xnáꞌanj nij soꞌ man soꞌ cheꞌé nij cuentó nanó soꞌ rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Xa̱ꞌ soj, tza̱j ne̱ tihaa̱n Diose̱ nana̱ rihaan soj da̱j quiꞌya̱j Diose̱ ga̱a gu̱un chij Diose̱ rihaan chumii̱ nihánj ado̱nj. Dan me se nana̱ ne neꞌen cunuda̱nj yuvii̱ me nana̱ yoꞌ nana̱ tihaa̱n Diose̱ rihaan soj ado̱nj. Ne̱ rihaan yoꞌó nij yuvii̱ ma̱n rihaan chumii̱ me se ina̱nj cuentó cheꞌé nij rasu̱u̱n nanoj rihaan nij yuvii̱, ");
INSERT INTO trcNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ga̱a ne̱ ni̱ꞌyaj nij soꞌ do̱ꞌ, nano̱ xre̱j nij soꞌ do̱ꞌ, tza̱j ne̱ se̱ queneꞌen nij soꞌ do̱ꞌ, se̱ xcaj nij soꞌ cuentá do̱ꞌ, a̱ maꞌ. ꞌO̱ se naꞌvej uxrá rá nij soꞌ ca̱nica̱j nimán nij soꞌ ne̱ güe̱j cacunꞌ xráá nij soꞌ a̱ man ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ga̱a ne̱ cataj uún Jesucristó rihaan nij soꞌ a: ―Ne̱ ne neꞌen soj me taj cuentó nihánj cuentó cheꞌé ꞌnúú trigó tixꞌnuu̱ yoꞌo̱ soꞌ naꞌ. Ne̱ asa̱ꞌ caꞌve̱e xca̱j soj cuentá cheꞌé yoꞌó nij cuentó, rá soj ga̱. ");
INSERT INTO trcNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","”Dan me se síí tixꞌnuu̱ ꞌnúú trigó roꞌ, soꞌ me síí nataꞌ se‑na̱na̱ Diose̱ rihaan yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ne̱ ase vaa ꞌnúú cayuu rá chrej quiꞌyaj síí tixꞌnuu̱ ꞌnúú roꞌ, da̱nj vaa taꞌa̱j nij síí uno se‑na̱na̱ Diose̱, ne̱ dan me se uno nij soꞌ do̱j tzinꞌ, tza̱j ne̱ nu̱ꞌ cuno nij soꞌ, ne̱ nu̱ꞌ ꞌnaꞌ síí chre̱e síí cuꞌna̱j Satanás, ne̱ aꞌnéj síí chre̱e se‑na̱na̱ Diose̱ nana̱ cayuu rque nimán nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","”Ne̱ vaa taꞌa̱j ꞌnúú trigó cayuu rihaan yuvej uún, ne̱ ꞌnúú trigó yoꞌ roꞌ, ase vaa nij síí uno se‑na̱na̱ Diose̱ vaa yoꞌ, ne̱ cuaj uun niha̱ꞌ rá nij soꞌ canoco̱ꞌ nij soꞌ nana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tza̱j ne̱ ataa xca̱j sa̱ꞌ nij soꞌ cuentá, ne̱ ga̱a uun cheꞌe̱ yuvii̱ ꞌyaj yuvii̱ sayuun man nij soꞌ cheꞌé nana̱ noco̱ꞌ nij soꞌ, ne̱ cuaj nu̱ꞌ uun naꞌa̱j nij soꞌ, ne̱ tanáj nij soꞌ nana̱ yoꞌ cuaj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","”Ne̱ ase vaa nij ꞌnúú trigó cayuu scaꞌnúj coj tanj roꞌ, da̱nj vaa yoꞌó taꞌa̱j nij yuvii̱ uún, ne̱ dan me se uno nij soꞌ se‑na̱na̱ Diose̱, ");
INSERT INTO trcNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","tza̱j ne̱ nanó ndoꞌo rá nij soꞌ cheꞌé se ma̱n rihaan chumii̱ nihánj, ne̱ me ndoꞌo rá nij soꞌ quiꞌya̱j canaán nij soꞌ saꞌanj, don tihaꞌ yuꞌunj nij soꞌ man maꞌa̱n nij soꞌ cheꞌé saꞌanj, ne̱ me maꞌa̱n yoꞌó nij rasu̱u̱n nanoꞌ ndoꞌo nij soꞌ, ne̱ cheꞌé dan tanáj xco̱ nij soꞌ se‑na̱na̱ Diose̱, ne̱ ne ꞌyaj nij soꞌ se sa̱ꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","”Ne̱ ꞌnúú trigó cayuu rihaan yoꞌóó sa̱ꞌ roꞌ, ase vaa síí uno se‑na̱na̱ Diose̱ vaa yoꞌ, ne̱ uun niha̱ꞌ rá soꞌ uno soꞌ nana̱ yoꞌ, ne̱ nuu sa̱ꞌ nimán soꞌ rihaan Diose̱ a. Ne̱ sa̱ꞌ do̱j tzinꞌ ꞌyaj taꞌa̱j nij soꞌ, ne̱ sa̱ꞌ doj ꞌyaj yoꞌó taꞌa̱j nij soꞌ, ne̱ sa̱ꞌ uxrá doj ꞌyaj yoꞌó taꞌa̱j nij soꞌ uún na̱nj ado̱nj. ―Veé da̱nj quisíj nana̱ caꞌmii Jesucristó cheꞌé cuentó yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Ne̱ ga̱a rmi̱ꞌ me se achrón nii yaꞌan raa̱ agaꞌ yaꞌan, ne̱ axríj yuve̱ nii agaꞌ yaꞌan yoꞌ rque ꞌo̱ chrúún do̱ꞌ, rque yuvéé do̱ꞌ, rá soj naꞌ. Taj maꞌ. Sese rmi̱ꞌ, ne̱ utaꞌ nii agaꞌ yoꞌ rej xta̱ꞌ, ga̱a ne̱ cuchugu̱u̱n sa̱ꞌ ndoꞌo ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Dan me se a̱ ꞌó rasu̱u̱n caxríj yuve̱ yuvii̱ se̱ quiꞌnij yuve̱ maꞌ. Ya̱ nu̱riha̱nj yoꞌ vaa güii, ne̱ cunuda̱nj yuvii̱ queneꞌe̱n, vaa güii ado̱nj. Ne̱ cunuda̱nj rasu̱u̱n ꞌyaj yuve̱ yuvii̱ queneꞌe̱n daj a̱ yuvii̱ vaa güii ei. ");
INSERT INTO trcNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Sese ta̱j yuꞌuj xréé soj, ne̱ cuno̱ soj nana̱ nihánj ei ―taj Jesucristó rihaan nij soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ga̱a ne̱ cataj uún soꞌ se vaa― Nuchru̱j ra̱a̱ soj nana̱ caꞌmij nihánj ei. Sese quiꞌya̱j suun uxrá soj nari̱ꞌ soj nana̱ nihánj, ne̱ rque̱ ndoꞌo Diose̱ doj nana̱ nari̱ꞌ uún soj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ꞌO̱ se síí nariꞌ nana̱ roꞌ, doj a̱ nari̱ꞌ uún soꞌ, quiꞌya̱j Diose̱ na̱nj ado̱nj. Ne̱ síí naꞌvej rá nari̱ꞌ sa̱ꞌ nana̱ roꞌ, tana̱nj caꞌne̱e̱ Diose̱ do̱j nij nana̱ nariꞌ soꞌ man soꞌ, ne̱ quina̱j u̱u̱n soꞌ na̱nj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ga̱a ne̱ cataj Jesucristó: ―Dan me se ase vaa achij naa̱ cuchruj ꞌo̱ snóꞌo roꞌ, da̱nj ga̱a̱ gu̱un chij Diose̱ rihaan chumii̱ nihánj, ne̱ snóꞌo yoꞌ roꞌ, cunô soꞌ ꞌnúú rihaan yoꞌóó, ");
INSERT INTO trcNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ne̱ síj cunô soꞌ, ne̱ otoj soꞌ rej nii̱, ne̱ naxaga̱a̱ soꞌ, ne̱ da̱nj ꞌyaj soꞌ daj a̱ güii, ne̱ dan me se xraꞌ naa̱ leꞌe̱j, ne̱ achij naa̱ leꞌe̱j, ne̱ ne neꞌen uxrá snóꞌo me cheꞌé me xraꞌ naa̱ ne̱ achij naa̱ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Achij maꞌa̱n naa̱ rihaan yoꞌóó, ne̱ dan me se asino ya̱a̱n xraꞌ naa̱, ga̱a ne̱ anó tiha̱j, ga̱a ne̱ uun xíj yumíí naa̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ga̱a ne̱ ga̱a quisíj tanꞌ xráá naa̱, ne̱ aꞌnéé snóꞌo man nij síí quiri̱i̱ naa̱ na̱nj á. ꞌO̱ se quisíj tió quiri̱i̱ nii naa̱ na̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ga̱a ne̱ cataj uún Jesucristó: ―Da̱j ga̱a̱ gu̱un chij Diose̱ rihaan chumii̱ nihánj, rá soj ga̱. ");
INSERT INTO trcNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Dan me se ase vaa achij caân cuêj mostazá xlá roꞌ, da̱nj ga̱a̱ gu̱un chij Diose̱ rihaan chumii̱ nihánj ado̱nj. Dan me se axríj nii caân yoꞌ rihaan yoꞌóó, ne̱ caân yoꞌ me se caân leꞌe̱j nii doj vaa caân yoꞌ rihaan cunuda̱nj nij caân ma̱n rihaan chumii̱ nihánj, ");
INSERT INTO trcNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","tza̱j ne̱ dan me se ga̱a axríj nii caân yoꞌ rihaan yoꞌóó, ne̱ achij caân yoꞌ, ne̱ xi̱j doj uun yoꞌ rihaan cunuda̱nj nij coj ma̱n tacaan, ne̱ xca̱a̱n ndoꞌo vaa raꞌa cuêj yoꞌ, ne̱ aꞌvee ꞌyaj nij xtâj va̱j rej xta̱ꞌ saca̱ꞌ nij xoꞌ raa̱ cuêj yoꞌ, ne̱ aráán cachu̱nꞌ xráá nij xoꞌ, ꞌyaj cuêj mostazá xlá yoꞌ na̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Dan me se queꞌe̱e̱ cuentó vaa da̱nj cuentó cheꞌé nij rasu̱u̱n nanó Jesucristó rihaan nij yuvii̱, nataꞌ soꞌ se‑na̱na̱ Diose̱ rihaan nij yuvii̱, nda̱a vaa guun nucua̱j nij yuvii̱ cuno̱ nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Taj va̱j yoꞌó nana̱ nanó Jesucristó rihaan nij yuvii̱ a̱ maꞌ. Ma̱a̱n ina̱nj cuentó cheꞌé nij rasu̱u̱n nanó Jesucristó rihaan nij soꞌ, tza̱j ne̱ rihaan maꞌa̱n nij síí tucuꞌyón se‑na̱na̱ soꞌ me se ataj xnaꞌanj soꞌ cheꞌé nij cuentó yoꞌ rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ga̱a ne̱ rej tiꞌnuu güii yoꞌ me se cataj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱: ―Caꞌa̱nj níꞌ nda̱a yoꞌó níchrej tuꞌva na lacuaná á ―taj soꞌ rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ga̱a ne̱ nij síí tucuꞌyón se‑na̱na̱ Jesucristó me se caꞌanj rihoo nu̱u̱ nij soꞌ ga̱ Jesucristó, quiꞌyaj nij soꞌ, ne̱ quináj nij yuvii̱ tuꞌva na lacuaná, ne̱ vaa doj nij rihoo canocoꞌ xcó nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ga̱a ne̱ cavii uxrá nana̱ yuva̱a̱ rihaan na lacuaná, ne̱ quinaa̱n ndoꞌo rihaan na, ne̱ catúj uxrá na rque rihoo yoꞌ, ne̱ da̱j doj cara̱a nu̱ꞌ rque rihoo, quiꞌya̱j na a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ne̱ Jesucristó me se na̱j soꞌ rej sihu̱u̱ rihoo, ne̱ ꞌni̱j raa̱ soꞌ camá, otoj soꞌ a. Ga̱a ne̱ narii nij síí tucuꞌyón se‑na̱na̱ Jesucristó nej rihaan Jesucristó, ne̱ cataj nij soꞌ: ―Nihánj me se da̱j doj cavi̱ꞌ níꞌ, maestro, ne̱ me cheꞌé ne rihuun rá so̱ꞌ ga̱ ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ga̱a ne̱ canicunꞌ caya̱ Jesucristó, ne̱ caxríj yuva̱a̱ soꞌ man nana̱, ne̱ cataj soꞌ rihaan na lacuaná: ―Ga̱a̱ dínj rihaan so̱ꞌ, ne̱ se̱ quinaán so̱ꞌ maꞌ ―taj soꞌ, ga̱a ne̱ nu̱ꞌ canicunꞌ nana̱, ne̱ canicunꞌ dínj rihaan na lacuaná yoꞌ, quiꞌyaj Jesucristó na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ga̱a ne̱ cataj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a: ―Me cheꞌé chuꞌviꞌ ndoꞌo nimán soj ga̱. Ataa cuchuma̱n sa̱ꞌ rá soj ni̱ꞌyaj soj manj naꞌ ―taj soꞌ rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ga̱a ne̱ cuchuꞌviꞌ ndoꞌo nij soꞌ, ne̱ xnáꞌanj nij soꞌ man tuviꞌ nij soꞌ, cataj nij soꞌ: ―Da̱j si̱j me síí nihánj ga̱. Nda̱a nana̱ do̱ꞌ, nda̱a na do̱ꞌ, uno aꞌmii soꞌ aso̱n ―taj nij soꞌ rihaan tuviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ga̱a ne̱ caꞌanj nij soꞌ nda̱a níchrej tuꞌva na lacuaná yoꞌ, nda̱a rej ne̱ nij síí ma̱n chumanꞌ Gadara a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ne̱ rej yoꞌ me se ta̱j yuꞌuj yuvej rej achinꞌ nii xnangá a. Dan me se nanij Jesucristó ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ rque rihoo, ne̱ nu̱ꞌ curiha̱nj ꞌo̱ snóꞌo nu̱u̱ nana̱ chre̱e nimán rque yuꞌuj yuvej yoꞌ, ne̱ cuchiꞌ soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ne̱ síí nu̱u̱ nana̱ chre̱e nimán me se cuꞌyón soꞌ cayáán soꞌ rque yuꞌuj yuvej yoꞌ, ne̱ ne caꞌve̱e nu̱míj nij yuvii̱ ma̱n rej yoꞌ agaꞌ ne̱ꞌ man soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ꞌO̱ se a̱j uun queꞌe̱e̱ ndoꞌo numíj nij yuvii̱ neꞌ do̱ꞌ, agaꞌ ne̱ꞌ do̱ꞌ, man soꞌ, tza̱j ne̱ cuxraꞌ soꞌ agaꞌ ne̱ꞌ, ne̱ caꞌneꞌ soꞌ neꞌ do̱ꞌ, ne̱ a̱ ꞌó yuvii̱ taj quisíj naquiꞌyaj cama̱nj man soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ne̱ niga̱nj me se nuvi̱i niga̱nꞌ cayáán soꞌ rque nij yuꞌuj yuvej do̱ꞌ, vaj soꞌ xráá quij do̱ꞌ, ne̱ caguáj ndoꞌo soꞌ, ne̱ nica̱j soꞌ yahij siha̱a̱ caꞌneꞌ ndoꞌo soꞌ nee̱ man maꞌa̱n soꞌ uún a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Dan me se ga̱a queneꞌen soꞌ man Jesucristó se vaa ga̱nꞌ uxrá vaj Jesucristó, ne̱ cunánj soꞌ nda̱a rej va̱j Jesucristó, ne̱ naꞌvíj soꞌ rihaan Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ne̱ nucua̱j ndoꞌo caguáj soꞌ rihaan Jesucristó, ne̱ cataj soꞌ: ―A̱j neꞌén ꞌu̱nj se vaa taꞌni̱j Diose̱ síí sa̱ꞌ ndoꞌo mé so̱ꞌ, Jesús. Me cheꞌé ꞌnáꞌ so̱ꞌ rej né ꞌu̱nj ga̱. Cata̱j xnaꞌanj sa̱ꞌ ꞌu̱nj rihaan so̱ꞌ niꞌya̱j Diose̱ se vaa se̱ quiꞌyáá so̱ꞌ sayuun manj maꞌ ―taj síí nu̱u̱ nana̱ chre̱e nimán rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Da̱nj caꞌmii soꞌ rihaan Jesucristó cheꞌé se a̱j cataj Jesucristó rihaan soꞌ se vaa: “Rihaan so̱ꞌ na̱na̱ chre̱e nu̱u̱ nimán síí nihánj cata̱j xnaꞌanj ꞌu̱nj se vaa cu̱riha̱nj so̱ꞌ nimán síí nihánj á”, taj Jesucristó, tza̱j ne̱ ne gu̱un rá nana̱ chre̱e cu̱riha̱nj soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ga̱a ne̱ xnáꞌanj Jesucristó man nana̱ chre̱e, ne̱ cataj soꞌ: ―Da̱j cuꞌna̱j so̱ꞌ ga̱ ―taj Jesucristó rihaan soꞌ a. Ne̱: ―Xꞌneꞌ noco̱o ndoꞌo me núj, ne̱ queꞌe̱e̱ ndoꞌo núj á ―taj nana̱ chre̱e rihaan Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ne̱ cachíín niꞌya̱j nij nana̱ chre̱e yoꞌ rihaan Jesucristó se vaa se̱ caꞌnéé Jesucristó man nij nana̱ chre̱e nda̱a yoꞌó rej yaníj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Dan me se rej tacaan rej nicu̱nꞌ nij soꞌ me se chéé ꞌo̱ xꞌneꞌ noco̱o xcáá, chá nij xoꞌ coj, ");
INSERT INTO trcNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ga̱a ne̱ cachíín niꞌya̱j nij nana̱ chre̱e rihaan Jesucristó, cataj nij soꞌ: ―Caꞌne̱j so̱ꞌ man núj catu̱u̱ núj nimán nij xcáá á ―taj nij nana̱ chre̱e rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ga̱a ne̱ caꞌvej rá Jesucristó quiꞌya̱j nij soꞌ da̱nj, ga̱a ne̱ curiha̱nj nij soꞌ nimán snóꞌo yoꞌ, ga̱a ne̱ catúj nij soꞌ nimán nij xcáá, ne̱ dan me se ruva̱a̱ uxrá tacaan nicu̱nꞌ tuꞌva na lacuaná rej va̱j nij xcáá yoꞌ, ne̱ ga̱a catúj nij nana̱ chre̱e yoꞌ nimán nij xcáá yoꞌ, ga̱a ne̱ cunánj ndoꞌo nij xoꞌ, caꞌanj nij xoꞌ, ne̱ veé da̱nj vaj nij xoꞌ, ne̱ quinij nij xoꞌ rque na, ne̱ canó xráá nij xoꞌ na̱nj ado̱nj. Ne̱ dan me se vi̱j míj xcáá me nij xcáá canó xráá rque na a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","”Ne̱ nij síí tumé nij xcáá roꞌ, cunánj nij soꞌ caꞌanj cata̱j xnaꞌanj nij soꞌ rihaan nij yuvii̱ ma̱n chumanꞌ do̱ꞌ, rihaan nij yuvii̱ ma̱n tacaan do̱ꞌ a. Ga̱a ne̱ dan me se caꞌnaꞌ ni̱ꞌyaj nij yuvii̱ se vaa guun, ga̱a ne̱ caꞌnaꞌ nij soꞌ rihaan Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ga̱a ne̱ queneꞌen nij soꞌ man síí curiha̱nj nana̱ chre̱e nimán a. A̱j nanuû soꞌ saga̱nꞌ soꞌ, ne̱ dínj ne soꞌ rihaan Jesucristó a. Ne̱ a̱j tiꞌinj se snúú soꞌ, ne̱ nuu sa̱ꞌ soꞌ a. Ga̱a ne̱ cuchuꞌviꞌ ndoꞌo nij yuvii̱ se vaa quiꞌyaj Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ga̱a ne̱ cataj xnaꞌanj nij síí queneꞌen yoꞌ rihaan nij yuvii̱ da̱j quiꞌyaj Jesucristó cheꞌé síí nu̱u̱ nana̱ chre̱e nimán do̱ꞌ, ga̱ nij xcáá do̱ꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ga̱a ne̱ guun cheꞌe̱ nij yuvii̱ cachíín niꞌya̱j nij yuvii̱ rihaan Jesucristó se vaa cu̱riha̱nj soꞌ rej ya̱nj nij soꞌ caꞌa̱nj soꞌ rej yaníj a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","”Cheꞌé dan cavii Jesucristó rque rihoo chéé rihaan na, ga̱a ne̱ dan me se cachíín niꞌya̱j síí curiha̱nj nana̱ chre̱e nimán rihaan Jesucristó se vaa caꞌve̱j rá Jesucristó caꞌa̱nj soꞌ ga̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tza̱j ne̱ ne caꞌve̱j rá Jesucristó caꞌa̱nj soꞌ ga̱ Jesucristó a. Tana̱nj cataj Jesucristó rihaan soꞌ se vaa: ―Cavi̱i̱ so̱ꞌ nánꞌ so̱ꞌ veꞌ tucuá so̱ꞌ rej ya̱nj nij tuvíꞌ so̱ꞌ, ne̱ cata̱j xnaꞌanj so̱ꞌ rihaan nij soꞌ nu̱ꞌ se vaa quiꞌyaj síí ꞌni̱j raꞌa man níꞌ cheꞌé so̱ꞌ, ne̱ cata̱j so̱ꞌ se vaa cunuu ꞌe̱e̱ rá soꞌ niꞌya̱j soꞌ mán so̱ꞌ á ―taj Jesucristó rihaan síí curiha̱nj nana̱ chre̱e nimán a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ga̱a ne̱ caꞌanj síí curiha̱nj nana̱ chre̱e nimán, ne̱ guun cheꞌe̱ soꞌ caꞌmii natáj soꞌ rihaan nij yuvii̱ ma̱n rej cuꞌna̱j Chi̱ꞌ Chumanꞌ, ne̱ cataj xnaꞌanj soꞌ nu̱ꞌ se vaa quiꞌyaj Jesucristó cheꞌé soꞌ a. Ne̱ caꞌanj ndoꞌo rá cunuda̱nj nij yuvii̱ cuno se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Dan me se nu̱u̱ Jesucristó rque rihoo chéé rihaan na, ne̱ caꞌanj uún soꞌ nda̱a níchrej tuꞌva na lacuaná, ga̱a ne̱ cunuu chre̱ꞌ ndoꞌo yuvii̱ rihaan soꞌ, ne̱ va̱j soꞌ tuꞌva na lacuaná a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ga̱a ne̱ dan me se caꞌnaꞌ yoꞌo̱ nij síí ꞌni̱j raꞌa veꞌ tucuꞌyón nij yuvii̱ israelitá se‑tucua̱nj Moisés, ne̱ Jairo cuꞌna̱j soꞌ a. Dan me se queneꞌen síí cuꞌna̱j Jairo man Jesucristó, ga̱a ne̱ canicunꞌ ru̱j soꞌ rihaan Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ga̱a ne̱ cachíín niꞌya̱j uxrá soꞌ rihaan Jesucristó, ne̱ dan me se cataj soꞌ se vaa: ―Taꞌníj chala̱ cunii roꞌ, ranꞌ ndoꞌo noꞌ, ne̱ da̱j doj cavi̱ꞌ noꞌ, ne̱ me rá ꞌu̱nj cuchi̱ꞌ so̱ꞌ veꞌ tucuaj, ne̱ cuta̱ꞌ so̱ꞌ raꞌá so̱ꞌ raa̱ noꞌ, ne̱ nahu̱un sa̱ꞌ noꞌ, ne̱ se̱ caviꞌ noꞌ, qui̱ꞌyáá so̱ꞌ maꞌ ―taj síí cuꞌna̱j Jairo rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ga̱a ne̱ caꞌanj Jesucristó ga̱ soꞌ, ne̱ canocoꞌ uxrá yuvii̱ xcó ro̱j soꞌ, ne̱ nda̱a raan maꞌa̱n chrej va̱j yuvii̱ ga̱ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Dan me se scaꞌnúj nij soꞌ vaj ꞌo̱ chana̱ ranꞌ ndoꞌo, ne̱ quisíj chuvi̱j ya̱ yoꞌ xraꞌ ton man noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ne̱ a̱j quiranꞌ ndoꞌo noꞌ sayuun, quiꞌyaj queꞌe̱e̱ nij doctor, ne̱ a̱j cutunꞌ noꞌ cunuda̱nj saꞌanj vaa rihaan noꞌ, tza̱j ne̱ taj se quiꞌyáꞌ a̱ doj nahuun sa̱ꞌ noꞌ quiꞌyaj nij doctor yoꞌ a̱ maꞌ. Tana̱nj doj a̱ ranꞌ noꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ga̱a ne̱ a̱j cuchiꞌ nana̱ rihaan noꞌ cheꞌé nu̱ꞌ se vaa quiꞌyaj Jesucristó cheꞌé nij yuvii̱, ne̱ cheꞌé dan caꞌnaꞌ noꞌ scaꞌnúj nij yuvii̱ rej xco̱ Jesucristó, ga̱a ne̱ canó raꞌa noꞌ do̱j tuꞌva saga̱nꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ꞌO̱ se guun rá noꞌ se vaa: “Sese cano̱ raꞌaj saga̱nꞌ Jesucristó, ne̱ nahu̱un sa̱ꞌ ꞌu̱nj na̱nj ado̱nj”, guun rá noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Dan me se síj canó raꞌa noꞌ saga̱nꞌ Jesucristó, ga̱a ne̱ nu̱ꞌ canicunꞌ ton man noꞌ cuaj a. Ne̱ queneꞌen noꞌ se vaa nahuun sa̱ꞌ noꞌ, quiꞌyaj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Dan me se nu̱ꞌ canó raꞌa noꞌ saga̱nꞌ Jesucristó, ne̱ nu̱ꞌ xcaj Jesucristó cuentá se vaa nahuun yuvii̱ quiꞌyaj soꞌ a. Cheꞌé dan canica̱j soꞌ, ne̱ xnáꞌanj soꞌ, cataj soꞌ: ―Me síí canó raꞌa saga̱nꞌ ꞌu̱nj ga̱ ―taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ga̱a ne̱ cataj nij síí tucuꞌyón se‑na̱na̱ Jesucristó se vaa: ―Neꞌén so̱ꞌ se vaa raan ndoꞌo vaj nij yuvii̱ ga̱ so̱ꞌ, ne̱ me cheꞌé xnáꞌanj so̱ꞌ me síí canó raꞌa saga̱nꞌ so̱ꞌ ga̱ ―taj nij soꞌ, xnáꞌanj nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ga̱a ne̱ canica̱j Jesucristó, ne̱ queneꞌen soꞌ man chana̱ canó raꞌa tuꞌva saga̱nꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ne̱ dan me se cuchuꞌviꞌ ndoꞌo noꞌ ne̱ nda̱a riꞌíj man noꞌ, ne̱ a̱j neꞌen noꞌ se vaa nahuun sa̱ꞌ noꞌ a. Ga̱a ne̱ caꞌanj noꞌ, ne̱ canicunꞌ ru̱j noꞌ rihaan Jesucristó, ne̱ cataj ya̱ noꞌ rihaan Jesucristó nu̱ꞌ se vaa quiꞌyaj noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ga̱a ne̱ cataj Jesucristó rihaan noꞌ a: ―Nahuún so̱ꞌ cheꞌé se amán rá so̱ꞌ niꞌya̱j so̱ꞌ manj, nocoj. Veꞌé caꞌa̱nj so̱ꞌ, ne̱ dínj ga̱a̱ nimán so̱ꞌ caꞌa̱nj so̱ꞌ á. Ga̱a̱ nu̱cuáá so̱ꞌ, ne̱ a̱j xꞌnéj nu̱ꞌ chiꞌii̱ yoꞌ xráá so̱ꞌ na̱nj ei ―taj Jesucristó rihaan chana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ataa navi̱j caꞌmii Jesucristó, ne̱ caꞌnaꞌ ꞌo̱ síí cavii tucuá síí cuꞌna̱j Jairo, ne̱ cataj soꞌ rihaan Jairo a: ―A̱j caviꞌ taꞌníí so̱ꞌ, ne̱ taj cheꞌé cara̱a̱ chrúú so̱ꞌ rihaan maestró a̱ maꞌ ―taj síí ꞌnaꞌ cataj xnaꞌanj rihaan Jairo a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Dan me se cuno Jesucristó nana̱ caꞌmii síí caꞌnaꞌ, ga̱a ne̱ cataj soꞌ rihaan síí cuꞌna̱j Jairo a: ―Se̱ cuchuꞌvíꞌ so̱ꞌ maꞌ. Ma̱a̱n se cuchuma̱n ya̱ rá so̱ꞌ ni̱ꞌyaj so̱ꞌ manj á ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Dan me se ne caꞌve̱j rá Jesucristó canoco̱ꞌ a̱ doj nij yuvii̱ man soꞌ, ne̱ ma̱a̱n Pedró do̱ꞌ, Jacobo do̱ꞌ, Juan tinúú Jacobo do̱ꞌ, caꞌvej soꞌ canoco̱ꞌ man soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ga̱a ne̱ cuchiꞌ soꞌ rihaan veꞌ tucuá Jairo, ne̱ queneꞌen Jesucristó se vaa taꞌvee uxrá nij yuvii̱ ma̱n rá veꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ga̱a ne̱ catúj Jesucristó rá veꞌ, ne̱ cataj soꞌ rihaan nij yuvii̱ a: ―Me cheꞌé taꞌvee ndoꞌo nij soj ga̱. Ne cavi̱ꞌ chala̱ cunii nihánj maꞌ. Ma̱a̱n se otoj u̱u̱n noꞌ na̱nj á ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ga̱a ne̱ caꞌngaꞌ naco̱o̱ nij yuvii̱ niꞌya̱j nij yuvii̱ man Jesucristó a. Tza̱j ne̱ quirii Jesucristó man cunuda̱nj nij yuvii̱ xeꞌ, ga̱a ne̱ nica̱j soꞌ man rej chala̱ cunii do̱ꞌ, man nii chala̱ cunii do̱ꞌ, man vaꞌnu̱j nij síí caꞌnaꞌ ga̱ soꞌ do̱ꞌ, ne̱ catúj soꞌ rá cuartó na̱j chala̱ cunii yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ga̱a ne̱ quitaꞌaa Jesucristó raꞌa chala̱ cunii, ne̱ cataj soꞌ rihaan chala̱ cunii yoꞌ a: ―Talita, cumi ―taj soꞌ rihaan noꞌ xnaꞌánj aꞌmii maꞌa̱n soꞌ a. Ne̱ se‑na̱na̱ soꞌ taj: “Na̱xagaa so̱ꞌ, chala̱ cunii”, taj nana̱ caꞌmii Jesucristó rihaan chala̱ cunii yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nu̱ꞌ caꞌmii Jesucristó nana̱ dan, ne̱ nu̱ꞌ naxaga̱a̱ chala̱ cunii yoꞌ, chéé noꞌ cuaj a. Nahuun iꞌna̱ꞌ noꞌ a. Ne̱ chala̱ cunii va̱j chuvi̱j yoꞌ me noꞌ a. Ne̱ nij síí queneꞌen, tza̱j ne̱ caꞌanj ndoꞌo rá nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ga̱a ne̱ caꞌneꞌ uxrá Jesucristó suun rihaan nij soꞌ a: ―A̱ ꞌó yuvii̱ se̱ cataj xnaꞌanj nij soj rihaan da̱j quiꞌyáj cheꞌé chala̱ cunii maꞌ ―taj Jesucristó rihaan nij soꞌ, ne̱ cataj soꞌ se vaa rque̱ nii do̱j se chá cha̱ noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ga̱a ne̱ curiha̱nj Jesucristó veꞌ yoꞌ, ga̱a ne̱ namán soꞌ rej chiháán soꞌ, ne̱ canocoꞌ nij síí tucuꞌyón se‑na̱na̱ soꞌ man soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ne̱ güii naránj rá nij yuvii̱ israelitá me se caꞌanj soꞌ veꞌ tucuꞌyón nij síí ma̱n chiháán soꞌ se‑tucua̱nj Moisés, ne̱ guun cheꞌe̱ soꞌ tucuꞌyón soꞌ man nij síí ma̱n rá veꞌ yoꞌ a. Ne̱ caꞌanj ndoꞌo rá nij yuvii̱ ga̱a cuno nij yuvii̱ se‑na̱na̱ Jesucristó, ga̱a ne̱ cataj nij yuvii̱: ―Me rej nariꞌ síí nihánj nana̱ cu̱u avii raa̱ síí nihánj ga̱. Me rej nariꞌ soꞌ suun sa̱ꞌ ꞌyaj soꞌ ga̱. ");
INSERT INTO trcNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nuveé si̱j acój chruun síí ne̱ chiháán níꞌ me soꞌ naꞌ. Ne̱ taꞌníí chana̱ cuꞌna̱j Mariá me soꞌ á. Ne̱ tinúú síí cuꞌna̱j Jacobo do̱ꞌ, síí cuꞌna̱j José do̱ꞌ, síí cuꞌna̱j Judas do̱ꞌ, síí cuꞌna̱j Simón do̱ꞌ, me soꞌ á. Ne̱ nij raꞌvij soꞌ me chana̱ ne̱ chiháán níꞌ á ―taj nij síí ma̱n chiháán Jesucristó rihaan tuviꞌ nij soꞌ, ne̱ guun naco̱o̱ rá nij soꞌ niꞌya̱j nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Me rej maꞌa̱n va̱j ꞌo̱ síí nataꞌ se‑na̱na̱ Diose̱, ne̱ aráj cochro̱j nij yuvii̱ rihaan soꞌ, tza̱j ne̱ nij yuvii̱ ma̱n chiháán soꞌ do̱ꞌ, nij tuviꞌ soꞌ do̱ꞌ, nij síí ya̱nj tucuá soꞌ do̱ꞌ, naꞌvej rá cara̱a̱ cochro̱j rihaan soꞌ maꞌ ―taj Jesucristó rihaan nij síí ma̱n chiháán soꞌ chumanꞌ cuꞌna̱j Nazaret yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ne̱ ne gu̱un nucua̱j Jesucristó quiꞌya̱j soꞌ a̱ doj suun sa̱ꞌ noco̱o chiháán soꞌ, ma̱a̱n se do̱j síí ranꞌ me se cutaꞌ soꞌ raꞌa soꞌ raa̱ ne̱ nahuun sa̱ꞌ nij soꞌ, quiꞌyaj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ne̱ caráyaꞌa̱nj ndoꞌo soꞌ se vaa ne cuchuma̱n rá nij síí ma̱n chiháán soꞌ niꞌya̱j nij soꞌ man soꞌ a. Ne̱ cavii soꞌ caꞌanj soꞌ nij chumanꞌ na̱j nichru̱nꞌ, tucuꞌyón soꞌ se‑na̱na̱ soꞌ man nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ga̱a ne̱ canacúún Jesucristó man chuvi̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ cuchiꞌ nij soꞌ rihaan soꞌ, ga̱a ne̱ guun cheꞌe̱ soꞌ caꞌnéé soꞌ man vi̱j vi̱j nij soꞌ, ne̱ goꞌ soꞌ se nucua̱j man nij soꞌ, ga̱a ne̱ caꞌve̱e quiꞌya̱j canaán nij soꞌ rihaan nij nana̱ chre̱e a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ne̱ caꞌneꞌ soꞌ suun rihaan nij soꞌ se vaa a̱ doj rasu̱u̱n se̱ nica̱j nij soꞌ ga̱a va̱j nij soꞌ chrej; ma̱a̱n o̱rúnꞌ chruun garroté me se caꞌve̱e ni̱caj nij soꞌ, tza̱j ne̱ rachrúún do̱ꞌ, nanj do̱ꞌ, se̱ nica̱j nij soꞌ, ne̱ se̱ caꞌvee cu̱nuû saꞌanj rque se‑caxra̱nꞌ nij soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","tza̱j ne̱ qui̱ꞌnij tacóó nij soꞌ canj, ne̱ o̱rúnꞌ yatzíj quita̱j xráá nij soꞌ, taj Jesucristó rihaan nij soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ne̱: ―Me maꞌa̱n veꞌ cara̱nꞌ soj, ne̱ yoꞌo̱ ca̱yáán soj veꞌ yoꞌ nda̱a se cu̱riha̱nj soj chumanꞌ yoꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ne̱ me rej maꞌa̱n se̱ caꞌmii sa̱ꞌ nij yuvii̱ ga̱ soj do̱ꞌ, se̱ caꞌvej rá nij yuvii̱ cuno̱ nij yuvii̱ nana̱ aꞌmii soj do̱ꞌ, ne̱ asa̱ꞌ cavii soj rej yoꞌ, ne̱ nacuna̱nꞌ soj tacóó soj tucuayu̱u soj yoꞌóó tachru̱u̱ canó tacóó soj, ne̱ nda̱a dan, ga̱a ne̱ xca̱j nij síí ma̱n rej yoꞌ cuentá se vaa tumé ndoꞌo nij soꞌ cacunꞌ se vaa ne caꞌve̱j rá nij soꞌ cuno̱ nij soꞌ se‑na̱na̱ soj ado̱nj. Cata̱j xnaꞌanj yá yá ꞌu̱nj rihaan soj cuano̱ se vaa doj a̱ quira̱nꞌ nij soꞌ cacunꞌ rihaan nij yuvii̱ ma̱n chumanꞌ Sodoma ga̱ chumanꞌ Gomorra na̱nj ado̱nj ―taj Jesucristó rihaan chuvi̱j nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ga̱a ne̱ caꞌanj nij soꞌ, ga̱a ne̱ caꞌmii natáj nij soꞌ rihaan nij yuvii̱ se vaa ca̱nica̱j rá nij yuvii̱ canoco̱ꞌ nij yuvii̱ chrej sa̱ꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ne̱ quirii ndoꞌo nij soꞌ man nij nana̱ chre̱e nimán nij yuvii̱, ne̱ cutáj ndoꞌo nij soꞌ casté raa̱ nij síí ranꞌ, ne̱ nahuun sa̱ꞌ nij síí ranꞌ, quiꞌyaj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Dan me se cuchiꞌ nana̱ rihaan síí nica̱j suun rey cuꞌna̱j Herodes cheꞌé nu̱ꞌ se vaa quiꞌyaj nij síí tucuꞌyón se‑na̱na̱ Jesucristó, ne̱ nu̱ꞌ cachra̱ꞌ chaꞌnuu̱ ndoꞌo se‑na̱na̱ Jesucristó a. Ga̱a ne̱ cataj síí cuꞌna̱j Herodes se vaa: ―Cunuu iꞌna̱ꞌ ya̱ uún síí cuꞌna̱j Juan, raj á. Ése̱ síí cuꞌna̱j Juan me síí guun nucua̱j quiꞌyaj nij suun sa̱ꞌ noco̱o yoꞌ na̱nj ado̱nj ―taj síí cuꞌna̱j Herodes a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ne̱ yoꞌó taꞌa̱j nij yuvii̱ me se cataj se vaa síí cuꞌna̱j Elías síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá me Jesucristó, ne̱ yoꞌó taꞌa̱j nij yuvii̱ uún cataj se vaa yoꞌó nij síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá me Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Dan me se cuno síí cuꞌna̱j Herodes da̱j guun rá nij yuvii̱, ga̱a ne̱ cataj soꞌ: ―Síí cuꞌna̱j Juan síí caꞌneꞌ nij tanuu cúú yave̱ quiꞌyáj roꞌ, a̱j cunuu iꞌna̱ꞌ ya̱ soꞌ chugua̱nj ―taj Herodes a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ꞌO̱ se maꞌa̱n síí cuꞌna̱j Herodes me síí caꞌnéé man nij tanuu qui̱taꞌaa nij tanuu man síí cuꞌna̱j Juan asi̱j rque̱ doj, ne̱ numíj nij tanuu man síí cuꞌna̱j Juan, ne̱ caxríj síí cuꞌna̱j Herodes tagaꞌ man síí cuꞌna̱j Juan, cheꞌé chana̱ cuꞌna̱j Herodías nica̱ tinúú Herodes síí cuꞌna̱j Felipé a. ꞌO̱ se xcaj síí cuꞌna̱j Herodes man chana̱ Herodías yoꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ga̱a ne̱ cataj síí cuꞌna̱j Juan rihaan síí cuꞌna̱j Herodes se vaa: ―Ne nó xcúún so̱ꞌ xca̱j so̱ꞌ man choco̱ꞌ so̱ꞌ maꞌ ―taj Juan rihaan Herodes a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Cheꞌé dan nachriꞌ chana̱ cuꞌna̱j Herodías niꞌya̱j noꞌ man Juan, ne̱ guun ndoꞌo rá noꞌ cavi̱ꞌ Juan, tza̱j ne̱ ne caꞌve̱e maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ꞌO̱ se cuchuꞌviꞌ síí cuꞌna̱j Herodes niꞌya̱j soꞌ man Juan, cheꞌé se queneꞌen Herodes se vaa síí nica̱ rá síí sa̱ꞌ ina̱nj nimán rihaan Diose̱ me Juan, ne̱ cheꞌé dan caráán Herodes rihaan chiꞌii̱ cheꞌé Juan a. Dan me se ga̱a cuno Herodes se‑na̱na̱ Juan, ne̱ quinanó ndoꞌo rá soꞌ, tza̱j ne̱ guun niha̱ꞌ rá soꞌ caꞌmi̱i̱ Juan rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Dan me se quisíj ꞌo̱ güii caꞌve̱e quiꞌya̱j canaán chana̱ cuꞌna̱j Herodías yoꞌ, ne̱ dan me se se‑chaꞌa̱nj síí cuꞌna̱j Herodes me yoꞌ, ne̱ caꞌneꞌ soꞌ suun se vaa ca̱nuû se‑chaꞌa̱nj soꞌ, ne̱ canacúún soꞌ caꞌna̱ꞌ nij síí ꞌyaj suun ga̱ maꞌa̱n soꞌ do̱ꞌ, nij tanuu uun chij doj do̱ꞌ, nij síí uun chij rihaan estadó Galilea do̱ꞌ, caꞌna̱ꞌ cha̱ niꞌyánj nij soꞌ ga̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ga̱a ne̱ catúj taꞌníí chana̱ cuꞌna̱j Herodías rej anuû chaꞌanj, ne̱ raꞌánj noꞌ, ne̱ guun niha̱ꞌ uxrá rá Herodes ga̱ nij síí caꞌnaꞌ chaꞌanj yoꞌ niꞌya̱j taranꞌ nij soꞌ man taꞌníí Herodías a. Ga̱a ne̱ cataj Herodes rihaan chana̱ ya̱a̱n yoꞌ: ―Cuano̱ nihánj me se a̱ me maꞌa̱n rasu̱u̱n me rá so̱ꞌ cachi̱nj so̱ꞌ rihanj, ne̱ rque̱ ꞌu̱nj mán so̱ꞌ ei ―taj soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ga̱a ne̱ cataj uún soꞌ― Cuta̱ꞌ yá ꞌu̱nj raa̱ Diose̱ se vaa a̱ me maꞌa̱n rasu̱u̱n cachi̱nj so̱ꞌ rihanj, ne̱ rque̱ ꞌu̱nj mán so̱ꞌ á. Nda̱a yane̱j yoꞌóó uun chij ꞌu̱nj rihaan roꞌ, rque̱ ꞌu̱nj mán so̱ꞌ na̱nj ado̱nj ―taj Herodes rihaan chana̱ ya̱a̱n yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ga̱a ne̱ curiha̱nj chana̱ ya̱a̱n, ne̱ xnáꞌanj noꞌ man nii noꞌ chana̱ cuꞌna̱j Herodías, ne̱ cataj noꞌ: ―Me se cachi̱nj ꞌu̱nj, ga̱ nahiin ―taj noꞌ rihaan nii noꞌ a. Ga̱a ne̱ chana̱ cuꞌna̱j Herodías cataj: ―Cachi̱nj so̱ꞌ cúú yave̱ síí cuꞌna̱j Juan síí cutaꞌ ne man yuvii̱ á ―taj noꞌ rihaan taꞌníí noꞌ chana̱ ya̱a̱n yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ga̱a ne̱ nu̱ꞌ catúj raꞌya̱nj chana̱ ya̱a̱n yoꞌ rej ma̱n síí nica̱j suun rey cuꞌna̱j Herodes, ne̱ cachíín niꞌya̱j noꞌ rihaan soꞌ, cataj noꞌ: ―Me rá ꞌu̱nj se vaa ma̱a̱n orá cuano̱ roꞌ, caꞌne̱j so̱ꞌ cúú yave̱ síí cuꞌna̱j Juan síí cutaꞌ ne man yuvii̱ rque agaꞌ rcoꞌo̱o, ne̱ rque̱ so̱ꞌ rihanj cuaj á ―taj noꞌ rihaan Herodes a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ga̱a ne̱ nanó ndoꞌo rá síí nica̱j suun rey cuꞌna̱j Herodes yoꞌ cheꞌé se a̱j cutaꞌ soꞌ raa̱ Diose̱ ne̱ a̱j cuno taranꞌ nij síí ya̱nj rihaan mesá ga̱ soꞌ, ne̱ cheꞌé dan ne caꞌve̱j rá soꞌ tari̱ꞌ soꞌ se‑na̱na̱ soꞌ se vaa se̱ quiꞌyaj soꞌ nda̱a vaa taj chana̱ ya̱a̱n yoꞌ rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ga̱a ne̱ nu̱ꞌ caꞌnéé soꞌ man síí ticavi̱ꞌ man síí cuꞌna̱j Juan, ne̱ caꞌneꞌ soꞌ suun se vaa ni̱caj soꞌ cúú yave̱ Juan caꞌna̱ꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ga̱a ne̱ caꞌanj síí ticavi̱ꞌ man Juan tagaꞌ, ne̱ caꞌneꞌ soꞌ cúú yave̱ Juan, ne̱ caꞌnéé soꞌ cúú yave̱ Juan rque agaꞌ rcoꞌo̱o, nica̱j soꞌ, caꞌnaꞌ soꞌ, ne̱ rqué soꞌ man chana̱ ya̱a̱n, ne̱ nagoꞌ chana̱ ya̱a̱n yoꞌ man nii noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ga̱a ne̱ ga̱a cuchiꞌ nana̱ rihaan nij síí tucuꞌyón se‑na̱na̱ Juan se vaa caviꞌ Juan, ne̱ caꞌnaꞌ nij soꞌ, ne̱ nica̱j nij soꞌ cúú man Juan, cachinꞌ nij soꞌ rque yuꞌuj yuvej a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Dan me se nij síí caꞌnéé Jesucristó caꞌa̱nj nata̱ꞌ rihaan yuvii̱ cheꞌé soꞌ roꞌ, cunuu chre̱ꞌ nij soꞌ ga̱ Jesucristó, ne̱ nataꞌ nij soꞌ rihaan Jesucristó cheꞌé cunuda̱nj nij suun sa̱ꞌ noco̱o quiꞌyaj nij soꞌ do̱ꞌ, cheꞌé cunuda̱nj nij nana̱ tucuꞌyón nij soꞌ man nij yuvii̱ do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Caꞌa̱nj níꞌ do̱j rej tacaan rej taj va̱j yuvii̱ ne, ga̱a ne̱ caꞌve̱e nara̱a̱n rá nij soj do̱j á ―taj Jesucristó rihaan nij soꞌ a. ꞌO̱ se caꞌnaꞌ ndoꞌo yuvii̱ do̱ꞌ, caꞌanj ndoꞌo yuvii̱ do̱ꞌ, ne̱ ne vaa yaꞌnúj rihaan nij soꞌ cha̱ nij soꞌ a̱ doj chraa a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ga̱a ne̱ cavii nij soꞌ rque rihoo chéé rihaan na, ne̱ caꞌanj o̱rúnꞌ nij soꞌ rej tacaan a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tza̱j ne̱ queneꞌen ndoꞌo nij yuvii̱ se vaa caꞌanj nij soꞌ, ne̱ xcaj yuvii̱ cuentá se vaa caꞌanj nij soꞌ, quiꞌyaj nij síí queneꞌen, ga̱a ne̱ chéé taco̱j nij yuvii̱ ma̱n cunuda̱nj nij chumanꞌ na̱j rej yoꞌ, ne̱ cunánj nij yuvii̱, cunuu chre̱ꞌ nij yuvii̱ rej caꞌa̱nj nij tuvi̱ꞌ Jesucristó, ne̱ asino nij yuvii̱ cuchiꞌ, ne̱ naꞌvi̱j nij yuvii̱ caꞌna̱ꞌ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ne̱ nanij Jesucristó rá rihoo, ne̱ queneꞌen soꞌ se vaa a̱j mán uxrá yuvii̱, ne̱ cunuu ꞌe̱e̱ rá soꞌ man nij yuvii̱ a. ꞌO̱ se ase vaa matzinj nuviꞌ síí tumé man vaa nij yuvii̱, niꞌya̱j Jesucristó, ga̱a ne̱ guun cheꞌe̱ soꞌ tucuꞌyón ndoꞌo soꞌ se‑na̱na̱ soꞌ man nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Dan me se cachén ndoꞌo orá, ga̱a ne̱ caꞌnaꞌ nij síí tucuꞌyón se‑na̱na̱ Jesucristó rihaan Jesucristó, ga̱a ne̱ cataj nij soꞌ se vaa: ―Rcoꞌ quij u̱u̱n me nihánj, ne̱ taj se chá cha̱ nij yuvii̱ nihánj, ne̱ cachén ndoꞌo orá na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Qui̱ꞌyáá so̱ꞌ se ndoꞌo, ne̱ naꞌne̱j so̱ꞌ chrej man nij yuvii̱, caꞌa̱nj nij yuvii̱ chumanꞌ na̱j nichru̱nꞌ do̱ꞌ, nij rancho na̱j nichru̱nꞌ do̱ꞌ, quira̱a̱n nij yuvii̱ se chá cha̱ nij yuvii̱ na̱nj á ―taj nij síí tucuꞌyón se‑na̱na̱ Jesucristó rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Go̱ꞌ maꞌa̱n soj se chá cha̱ nij yuvii̱ á ―taj soꞌ a. Ga̱a ne̱ cataj nij soꞌ rihaan Jesucristó a: ―Caꞌa̱nj núj go̱ꞌ núj saꞌanj vaa tuꞌvee yuvii̱ ꞌyaj suun tu̱nj yavii ne̱ quira̱a̱n núj rachrúún, ne̱ rque̱ núj cha̱ nij yuvii̱, rá so̱ꞌ naꞌ ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Me da̱j rachrúún vaa rihaan soj ga̱. Cavi̱i̱ soj, ne̱ xca̱j soj cuentá á ―taj soꞌ a. Ga̱a ne̱ caꞌanj nij soꞌ quiꞌya̱j contá nij soꞌ rachrúún vaa rihaan nij soꞌ, ga̱a ne̱ canica̱j nij soꞌ, ne̱ cataj nij soꞌ: ―Vaa ꞌu̱nꞌ gue̱e̱ rachrúún ne̱ vi̱j gue̱e̱ xcuaj rihaan núj na̱nj á ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ga̱a ne̱ caꞌneꞌ Jesucristó suun rihaan nij yuvii̱ se vaa caꞌa̱nj ca̱yáán cunuda̱nj nij yuvii̱ rihaan coj chri̱nꞌ, ne̱ caꞌa̱nj cuma̱n xꞌneꞌ nij yuvii̱ rihaan coj chri̱nꞌ, taj Jesucristó rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ga̱a ne̱ naquiꞌyaj xꞌne̱ꞌ nij yuvii̱ man nij yuvii̱, ne̱ cayáán nij yuvii̱ rihaan coj chri̱nꞌ, ne̱ dan me se cientó yuvii̱ do̱ꞌ, vi̱j chiha̱a̱ chi̱ꞌ yuvii̱ do̱ꞌ, me ꞌo̱ ꞌo̱ xꞌneꞌ nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ga̱a ne̱ quitaꞌaa Jesucristó ꞌu̱nꞌ nij rachrúún ne̱ vi̱j ro̱j xcuaj, ga̱a ne̱ niꞌya̱j soꞌ rej xta̱ꞌ, ne̱ nagoꞌ soꞌ graciá rihaan Diose̱, ga̱a ne̱ cuxraꞌ taꞌa̱j soꞌ man rachrúún yoꞌ, ne̱ caxríj soꞌ ston nij síí tucuꞌyón se‑na̱na̱ soꞌ, cheꞌé rej caxri̱i̱ nij soꞌ ston nij yuvii̱ a. Ga̱a ne̱ cuxraꞌ taꞌa̱j soꞌ nee̱ xcuaj cha̱ cunuda̱nj nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ga̱a ne̱ chá taranꞌ nij yuvii̱, ne̱ caraa rque cunuda̱nj nij soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ne̱ nda̱a quináj ndoꞌo se chá, quiꞌyaj nij yuvii̱ a. Ga̱a ne̱ naquiꞌyaj chre̱ꞌ nii se vaa quináj tuꞌva yuvii̱, ne̱ caraa yoꞌó chuvi̱j ya̱ scaa, ne̱ taꞌa̱j rachrúún do̱ꞌ, taꞌa̱j nee̱ xcuaj do̱ꞌ, me se chá naquiꞌyaj chre̱ꞌ nii a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ne̱ nij snóꞌo rqué Jesucristó chraa me se ꞌu̱nꞌ míj snóꞌo me nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ga̱a ne̱ raꞌya̱nj caꞌneꞌ Jesucristó suun rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ se vaa cavi̱i̱ nij soꞌ rihoo chéé rihaan na caꞌa̱nj nij soꞌ rej xco̱ na lacuaná yoꞌ nda̱a chumanꞌ cuꞌna̱j Betsaida, quita̱j ya̱a̱n nij soꞌ rihaan Jesucristó, ne̱ dan me se maꞌa̱n Jesucristó naꞌne̱j chrej man nij yuvii̱, taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Dan me se caꞌanj nij soꞌ, ne̱ cataj Jesucristó rihaan nij yuvii̱ se vaa caꞌve̱e caꞌa̱nj nij yuvii̱ a. Ga̱a ne̱ cavii soꞌ raa̱ quij, ne̱ cachíín niꞌya̱j soꞌ rihaan Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Dan me se da̱j doj cata̱ꞌ güii raa̱ quij, ne̱ va̱j rihoo tanu̱u̱ rihaan na lacuaná, ne̱ o̱rúnꞌ Jesucristó me síí nicu̱nꞌ rihaan yoꞌóó a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ne̱ queneꞌen soꞌ man nij síí tucuꞌyón se‑na̱na̱ soꞌ se vaa güéj ndoꞌo rihoo yoꞌ rihaan na quiꞌyaj nana̱, cheꞌé se goꞌ nana̱ rej riha̱a̱n rihoo yoꞌ a. Dan me se yanꞌ siꞌnu̱ꞌ caꞌanj Jesucristó rej va̱j nij soꞌ, chéé taco̱j u̱u̱n soꞌ rihaan na yoꞌ, va̱j soꞌ na̱nj ado̱nj. Ne̱ guun rá soꞌ cache̱n soꞌ rej xꞌnu̱j nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ne̱ queneꞌen nij síí tucuꞌyón se‑na̱na̱ soꞌ man soꞌ se vaa chéé u̱u̱n soꞌ rihaan na, ne̱ guun rá nij soꞌ se vaa taꞌnaj me soꞌ, ne̱ cheꞌé dan caguáj ndoꞌo nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ꞌO̱ se queneꞌen cunuda̱nj nij soꞌ man soꞌ, ne̱ cuchuꞌviꞌ ndoꞌo nimán nij soꞌ a. Veé dan, ne̱ nu̱ꞌ cataj Jesucristó rihaan nij soꞌ a: ―Naquiꞌya̱j nucua̱j soj nimán soj ei. ꞌU̱nj ꞌnaꞌ ei. Se̱ cuchuꞌviꞌ soj maꞌ ―taj soꞌ rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ga̱a ne̱ catúj soꞌ rque rihoo rej nu̱u̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ, ga̱a ne̱ canicunꞌ nana̱ yoꞌ, ne̱ caꞌanj ndoꞌo rá nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ꞌO̱ se ne xca̱j sa̱ꞌ nij soꞌ cuentá cheꞌé se nucua̱j nica̱j Jesucristó ga̱a cuxraꞌ taꞌa̱j Jesucristó rachrúún chá nij yuvii̱ a. Ma̱a̱n se nichra̱j ndoꞌo nimán nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ga̱a ne̱ cuchiꞌ nij soꞌ tuꞌva na lacuaná rej cuꞌna̱j Genesaret, ne̱ numíj nij soꞌ rihoo tuꞌva na lacuaná a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ga̱a ne̱ nanij nij soꞌ rá rihoo, ne̱ nu̱ꞌ cunuu ya̱a̱n nij síí ma̱n rej yoꞌ man Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ne̱ yo̱o caꞌanj cunuda̱nj nij síí ya̱nj nu̱ꞌ anica̱j, ne̱ guun cheꞌe̱ nij soꞌ cuchruj nij soꞌ tuviꞌ nij soꞌ síí ranꞌ rihaan yuvéé, ne̱ quitáá chihá nij soꞌ nij síí ranꞌ yoꞌ, va̱j nij soꞌ me rej maꞌa̱n va̱j Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ne̱ me maꞌa̱n chumanꞌ raꞌa̱ do̱ꞌ, chumanꞌ noco̱o do̱ꞌ, rancho do̱ꞌ, catúj Jesucristó me se cuchruj nij yuvii̱ man nij síí ranꞌ rihaan yuꞌvee, ne̱ cachíín niꞌya̱j uxrá nij yuvii̱ rihaan Jesucristó se vaa caꞌve̱j rá Jesucristó cano̱ raꞌa nij soꞌ do̱j tuꞌva saga̱nꞌ soꞌ a. Ne̱ nu̱ꞌ nij síí canó raꞌa do̱j man soꞌ roꞌ, nahuun sa̱ꞌ cunuda̱nj nij soꞌ cuaj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ga̱a ne̱ quinichrunꞌ síí fariseo do̱ꞌ, quinichrunꞌ síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés do̱ꞌ, rihaan Jesucristó, ne̱ síí cavii chumanꞌ Jerusalén me nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ne̱ queneꞌen nij soꞌ se vaa ga̱a chá nij síí tucuꞌyón se‑na̱na̱ Jesucristó chraa, ne̱ ne naꞌya̱ꞌ nij soꞌ, ne̱ cheꞌé dan ne naruvi̱i̱ raꞌa nij síí tucuꞌyón se‑na̱na̱ Jesucristó niꞌya̱j Diose̱, rá nij síí fariseo do̱ꞌ, nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ꞌO̱ se xa̱ꞌ nij síí fariseo ga̱ cunuda̱nj yoꞌó nij síí israelitá, tza̱j ne̱ a̱ doj ne chá nij soꞌ chraa sese ataa naꞌya̱ꞌ nij soꞌ maꞌ. Da̱nj ꞌyaj nij soꞌ, cheꞌé se noco̱ꞌ nij soꞌ tucuáán cuchruj nij síí chij cayáán ga̱a naá a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ne̱ ga̱a ꞌnaꞌ nij soꞌ yuꞌvee, ne̱ ane nij soꞌ, ne̱ sese ataa cane̱ nij soꞌ, ne̱ ne chá nij soꞌ chraa a̱ maꞌ. Ne̱ vaa uxrá doj tucuáán nica̱j nij soꞌ, ne̱ nda̱a vaa tucuáán cheꞌé tazá do̱ꞌ, cheꞌé xruj do̱ꞌ, cheꞌé agaꞌ do̱ꞌ, da̱j quiꞌya̱j nij soꞌ ga̱a naꞌnuꞌ nij soꞌ man nij rasu̱u̱n vaa nacaj do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ga̱a ne̱ xnáꞌanj nij síí fariseo ga̱ nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés man Jesucristó, ne̱ cataj nij soꞌ, ne̱: ―Nij síí tucuꞌyón se‑na̱na̱ so̱ꞌ me se me cheꞌé ne nocoꞌ nij soꞌ tucuáán cuchruj nij síí chij cayáán ga̱a naá, ne̱ nihánj me se chá nij soꞌ chraa, ne̱ ne naruvi̱i̱ raꞌa nij soꞌ niꞌya̱j Diose̱ a̱ maꞌ ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Cuna̱j uxrá vaa nana̱ nataꞌ síí cuꞌna̱j Isaías ga̱a naá ga̱a caꞌmii soꞌ cheꞌé nij soj si̱j nucuiꞌ rá, ne̱ dan me se caꞌmii soꞌ se‑na̱na̱ Diose̱, ne̱ cataj soꞌ se vaa: “Yuvii̱ nihánj me se ga̱nꞌ uxrá nicunꞌ nimán nij soꞌ ga̱ ꞌu̱nj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Naꞌvíj rmaꞌa̱n nij soꞌ rihanj, ne̱ dan me se na̱nj se‑na̱na̱ nij síí ma̱n rihaan chumii̱ tucuꞌyón nij soꞌ rihaan tuviꞌ nij soꞌ, ne̱ taj nij soꞌ se vaa se‑na̱na̱j me se‑na̱na̱ nij yuvii̱ yoꞌ a”, taj se‑na̱na̱ Diose̱ nataꞌ síí cuꞌna̱j Isaías ga̱a naá a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","ꞌO̱ se a̱j tanáj xco̱ soj nana̱ cataj xnaꞌanj Diose̱ rihaan níꞌ, ne̱ na̱nj tucuáán cuchruj yuvii̱ u̱u̱n nocoꞌ soj na̱nj ei ―taj Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ne̱ cataj uún soꞌ se vaa― Cuna̱j uxrá vaa ꞌyaj soj, ne̱ utaꞌ yaníj soj nana̱ cataj xnaꞌanj Diose̱ rihaan níꞌ, cheꞌé rej caꞌve̱e canoco̱ꞌ soj se‑tucua̱nj maꞌa̱n soj asan. ");
INSERT INTO trcNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","”ꞌO̱ se caꞌneꞌ Moisés suun se vaa: “Cara̱a̱ co̱chróó so̱ꞌ rihaan réé so̱ꞌ do̱ꞌ, rihaan nií so̱ꞌ do̱ꞌ á”. Tza̱j ne̱: “Síí aꞌmii chre̱e rihaan rej do̱ꞌ, rihaan nii do̱ꞌ, me se va̱j soꞌ ne̱ nu̱ꞌ cheꞌe̱ cavi̱ꞌ soꞌ á”. Da̱nj vaa cataj xnaꞌanj Moisés rihaan níꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Tza̱j ne̱ taj soj se vaa sese cata̱j yoꞌo̱ soꞌ rihaan rej soꞌ do̱ꞌ, rihaan nii soꞌ do̱ꞌ, se vaa a̱j rqué soꞌ nu̱ꞌ siꞌyaj soꞌ rihaan Diose̱ ne̱ cheꞌé dan se̱ caꞌvee ra̱cuíj soꞌ man rej soꞌ do̱ꞌ, man nii soꞌ do̱ꞌ, taj soj a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ne̱ ne caꞌve̱j soj ra̱cuíj soꞌ man rej soꞌ do̱ꞌ, man nii soꞌ do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Dan me se da̱nj ina̱nj aꞌmii soj ga̱a tucuꞌyón soj se‑na̱na̱ nij síí ma̱n ga̱a naá, ne̱ axríj yuve̱ soj man se‑na̱na̱ Diose̱ na̱nj ado̱nj ―taj Jesucristó rihaan nij síí fariseo do̱ꞌ, rihaan nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ga̱a ne̱ canacúún uún Jesucristó man nij yuvii̱ caꞌna̱ꞌ nij yuvii̱ rihaan soꞌ, ga̱a ne̱ cataj soꞌ rihaan nij yuvii̱ a: ―Cuno̱ taranꞌ soj nana̱ nihánj, ne̱ xca̱j soj cuentá nedi̱ꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","A̱ doj rasu̱u̱n atúj tuꞌva yuvii̱ se̱ caꞌvee quiꞌya̱j chiꞌi̱i̱ man yuvii̱ maꞌ. Se avii tuꞌva yuvii̱ roꞌ, ꞌyaj chiꞌi̱i̱ man yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Sese ta̱j yuꞌuj xréé soj, ne̱ cuno̱ soj nana̱ nihánj ei ―taj Jesucristó rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Dan me se corá caꞌanj yaníj Jesucristó ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ rihaan nij yuvii̱, ne̱ catúj nij soꞌ rá veꞌ, ga̱a ne̱ xnáꞌanj nij síí tucuꞌyón se‑na̱na̱ Jesucristó man soꞌ me taj nana̱ caꞌmii soꞌ cheꞌé se atúj tuꞌva yuvii̱ ga̱a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Vaa soj vaa, ne̱ ne xca̱j maꞌa̱n soj do̱ꞌ cuentá a̱ naꞌ. Ne̱ neꞌen soj se vaa nu̱ꞌ se atúj tuꞌva yuvii̱ roꞌ, se̱ caꞌvee quiꞌya̱j chiꞌi̱i̱ yoꞌ man yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ꞌO̱ se ne atúj yoꞌ nda̱a nimán yuvii̱ maꞌ. Tana̱nj achén yoꞌ rque yuvii̱, ne̱ uriha̱nj yoꞌ ga̱a reꞌé yuvii̱ na̱nj á ―taj Jesucristó, ne̱ nana̱ yoꞌ taj se vaa caꞌve̱e cha̱ yuvii̱ me maꞌa̱n rasu̱u̱n ne̱ nuveé cacu̱nꞌ me yoꞌ rihaan Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ne̱ cataj uún soꞌ a― Tza̱j ne̱ se uriha̱nj tuꞌva yuvii̱ roꞌ, yoꞌ me nana̱ avii nimán yuvii̱, ne̱ nana̱ yoꞌ me ꞌyaj chiꞌi̱i̱ ndoꞌo man yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ꞌO̱ se nihánj me se chiꞌi̱i̱ avii nimán yuvii̱ a. Se chiꞌi̱i̱ do̱ꞌ, cheꞌé yan quiꞌya̱j itu̱u̱ siꞌyaj tuviꞌ do̱ꞌ, yan coto̱j ga̱ nica̱ tuviꞌ do̱ꞌ, yan ticavi̱ꞌ man tuviꞌ do̱ꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yan gu̱un rá ni̱caj siꞌyaj tuviꞌ do̱ꞌ, yan tiha̱ꞌ yuꞌunj man tuviꞌ do̱ꞌ, yan ni̱ꞌyaj ndoꞌo man yoꞌó chana̱ do̱ꞌ, yan gu̱un xco̱j ruva̱a̱ rá ni̱ꞌyaj tuviꞌ do̱ꞌ, cheꞌé yan nachri̱ꞌ ni̱ꞌyaj man tuviꞌ do̱ꞌ, yan caꞌmi̱i̱ xta̱ꞌ do̱ꞌ, yan quiꞌya̱j rmaꞌa̱n náá guun se nij do̱ꞌ, me nu̱ꞌ se avii nimán yuvii̱, ");
INSERT INTO trcNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ne̱ nu̱ꞌ yoꞌ me se avii nimán yuvii̱ ne̱ ꞌyaj chiꞌi̱i̱ man yuvii̱ na̱nj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ga̱a ne̱ canicunꞌ Jesucristó, ne̱ curiha̱nj soꞌ rej yoꞌ, ne̱ caꞌanj soꞌ rej na̱j chumanꞌ cuꞌna̱j Tiro a. Ne̱ catúj soꞌ rá ꞌo̱ veꞌ, ne̱ ne caꞌve̱j rá soꞌ queneꞌe̱n nij yuvii̱ me rej vaj soꞌ a. Tza̱j ne̱ ne caꞌve̱e qui̱ꞌnij yuve̱ soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tana̱nj raꞌya̱nj cuchiꞌ nana̱ rihaan ꞌo̱ chana̱ se vaa ya̱nj soꞌ, ne̱ taꞌníí chana̱ roꞌ, me níí nu̱u̱ nana̱ chre̱e nimán, ne̱ caꞌnaꞌ chana̱, ne̱ canicunꞌ ru̱j chana̱ yoꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Dan me se chana̱ sirofenicia aꞌmii xnaꞌánj griego me chana̱ yoꞌ, ne̱ cachíín niꞌya̱j noꞌ rihaan Jesucristó se vaa quiri̱i̱ Jesucristó nana̱ chre̱e nimán taꞌníí noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ga̱a ne̱ cataj Jesucristó rihaan noꞌ a: ―Dan me se ca̱nicúnꞌ so̱ꞌ do̱j, ne̱ cha̱ asino nij xnii tucua̱, ne̱ neꞌén so̱ꞌ se vaa se̱ caꞌvee ca̱taꞌaa níꞌ coꞌoo ma̱n rihaan nij xnii ne̱ go̱ꞌ níꞌ cha̱ nij chuvee maꞌ. Dan me se nda̱a síj chá nij xnii tucua̱, ga̱a ne̱ sese náj se chá tuꞌva nij xnii yoꞌ, ga̱a ne̱ caꞌve̱e go̱ꞌ cha̱ chuvee na̱nj ado̱nj. Cheꞌé dan ase vaa ne nó xcúún yuvii̱ caꞌne̱e̱ yuvii̱ rachrúún tuꞌva taꞌníí yuvii̱ go̱ꞌ yuvii̱ rachrúún yoꞌ cha̱ chuvee roꞌ, da̱nj vaa ne nó xcúnj ra̱cuíj man soj si̱j yaníj a̱ man ado̱nj. Ma̱a̱n ina̱nj maꞌa̱n nij yuvii̱ israelitá me no̱ xcúún ꞌu̱nj ra̱cuíj ꞌu̱nj na̱nj ado̱nj ―taj Jesucristó rihaan chana̱ yoꞌ a. Ga̱a ne̱ cataj noꞌ: ");
INSERT INTO trcNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","―Veé dan vaa gue̱e̱, Señor. Tza̱j ne̱ nij chuvee nicu̱nꞌ rque chruun mesá roꞌ, chá nij xoꞌ tachruu̱ ayuu tuꞌva nij xnii na̱nj á. Ne̱ ase vaa chuvee chá tachruu̱ vaa ꞌu̱nj rihaan so̱ꞌ na̱nj ado̱nj. Cheꞌé dan me ndoꞌo raj ra̱cuíj so̱ꞌ do̱j manj, raj na̱nj ado̱nj ―taj chana̱ yoꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ga̱a ne̱ cataj Jesucristó: ―Cheꞌé nana̱ caꞌmii so̱ꞌ nihánj roꞌ, caꞌve̱e cavi̱i̱ so̱ꞌ caꞌa̱nj so̱ꞌ, ne̱ a̱j curiha̱nj nana̱ chre̱e nimán taꞌníí so̱ꞌ na̱nj ei ―taj soꞌ rihaan noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ga̱a ne̱ caꞌanj chana̱, catúj chana̱ rá veꞌ tucuá chana̱, ne̱ queneꞌen chana̱ se vaa dínj naj taꞌníí chana̱ rihaan yuvéé, ne̱ a̱j curiha̱nj nana̱ chre̱e nimán taꞌníí chana̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ga̱a ne̱ curiha̱nj uún Jesucristó rej na̱j chumanꞌ Tiro, ne̱ cachén soꞌ scaꞌnúj chumanꞌ cuꞌna̱j Sidón, caꞌanj uún soꞌ tuꞌva na lacuaná cuꞌna̱j Galilea, ne̱ cachén soꞌ scaꞌnúj rej cuꞌna̱j Chi̱ꞌ Chumanꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ne̱ nica̱j nij yuvii̱ man ꞌo̱ síí soꞌo̱ yaꞌmi̱i caꞌnaꞌ nij yuvii̱ rihaan Jesucristó, ne̱ cachíín niꞌya̱j uxrá nij yuvii̱ rihaan Jesucristó se vaa cuta̱ꞌ raꞌa Jesucristó xráá síí soꞌo̱ yaꞌmi̱i yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ga̱a ne̱ nica̱j Jesucristó man síí soꞌo̱ yaꞌmi̱i caꞌanj yaníj soꞌ rihaan yoꞌó nij yuvii̱, ga̱a ne̱ tucuaꞌanj Jesucristó raꞌa Jesucristó yuꞌuj xréé síí soꞌo̱ yaꞌmi̱i, ga̱a ne̱ quirii talúj Jesucristó raꞌa Jesucristó, ne̱ canó raꞌa Jesucristó daa síí soꞌo̱ yaꞌmi̱i yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ga̱a ne̱ niꞌya̱j Jesucristó rej xta̱ꞌ, ga̱a ne̱ caráchej Jesucristó, ne̱ cataj Jesucristó: ―Efata ―taj Jesucristó, ne̱ nana̱ “Efata” taj: “Nachugu̱u̱n xréé so̱ꞌ á”, me nana̱ caꞌmii Jesucristó rihaan síí soꞌo̱ yaꞌmi̱i yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ga̱a ne̱ nachuguu̱n xréé soꞌ, ne̱ nahuun sa̱ꞌ daa soꞌ, ga̱a ne̱ caꞌmii sa̱ꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ga̱a ne̱ caꞌneꞌ Jesucristó suun rihaan nij síí queneꞌen da̱j quiꞌyaj Jesucristó cheꞌé síí soꞌo̱ yaꞌmi̱i se vaa se̱ guun cata̱j xnaꞌanj nij soꞌ rihaan a̱ ꞌó yuvii̱ a. Dan me se doj a̱ naꞌvej rá Jesucristó cata̱j xnaꞌanj nij soꞌ rihaan tuviꞌ nij soꞌ, tza̱j ne̱ doj a̱ nataꞌ nij soꞌ rihaan tuviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ga̱a ne̱ caꞌanj uxrá rá nij yuvii̱ xcaj cuentá da̱j quiꞌyaj Jesucristó, ne̱ cataj nij yuvii̱ se vaa sa̱ꞌ uxrá vaa nu̱ꞌ se vaa quiꞌyaj Jesucristó, ne̱ nda̱a nachuguu̱n xréé nij síí soꞌo̱ do̱ꞌ, nda̱a aꞌmii sa̱ꞌ nij síí yaꞌmi̱i do̱ꞌ, ꞌyaj Jesucristó, taj nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ne̱ güii dan me se va̱j uún queꞌe̱e̱ yuvii̱ ga̱ Jesucristó, ne̱ nuviꞌ uún se chá rihaan nij yuvii̱, ga̱a ne̱ canacúún Jesucristó man nij síí tucuꞌyón se‑na̱na̱ soꞌ se vaa caꞌna̱ꞌ nij soꞌ rihaan soꞌ, ga̱a ne̱ cataj soꞌ rihaan nij soꞌ a: ");
INSERT INTO trcNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―ꞌE̱e̱ rá ꞌu̱nj man nij yuvii̱ nihánj, ne̱ nihánj me se síj vaꞌnu̱j ya̱ güii ꞌo̱ vaj nij yuvii̱ ga̱ ꞌu̱nj, ne̱ taj va̱j se chá rihaan nij yuvii̱ cuano̱ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ne̱ sese naꞌne̱j ꞌu̱nj chrej man nij yuvii̱ cuano̱ quina̱nꞌ nij soꞌ ga̱a naꞌaan rque nij soꞌ, ne̱ nina̱j nij soꞌ rá chrej, ne̱ dan me se taꞌa̱j nij soꞌ me síí ya̱nj rej ga̱nꞌ ndoꞌo na̱nj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ga̱a ne̱ cataj nij soꞌ rihaan Jesucristó a: ―Tza̱j ne̱ rej tacaan u̱u̱n me nihánj, ne̱ nuviꞌ rachrúún nihánj go̱ꞌ níꞌ cha̱ nij yuvii̱ a̱ maꞌ ―taj nij síí tucuꞌyón se‑na̱na̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ga̱a ne̱ xnáꞌanj Jesucristó man nij soꞌ, cataj soꞌ: ―Me da̱j rachrúún vaa rihaan soj ga̱ ―taj soꞌ, xnáꞌanj soꞌ man nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ―Chi̱j rachrúún vaa rihaan núj na̱nj á ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ga̱a ne̱ caꞌneꞌ Jesucristó suun rihaan nij yuvii̱ se vaa caꞌa̱nj ca̱yáán nij yuvii̱ rihaan yoꞌóó a. Ga̱a ne̱ nica̱j soꞌ chi̱j nij rachrúún, ne̱ nagoꞌ soꞌ graciá rihaan Diose̱, ga̱a ne̱ cuxraꞌ taꞌa̱j soꞌ rachrúún yoꞌ, ne̱ caxríj soꞌ ston nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ tu̱cuachén nij soꞌ rihaan nij yuvii̱, ne̱ dan me se rqué nij soꞌ rachrúún yoꞌ rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ne̱ nica̱j Jesucristó do̱j xcuaj leꞌe̱j uún, ne̱ nagoꞌ soꞌ graciá rihaan Diose̱ cheꞌé nij xcuaj leꞌe̱j, ne̱ cataj soꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ se vaa tu̱cuachén nij soꞌ nee̱ xcuaj leꞌe̱j uún rihaan nij yuvii̱ uún a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ga̱a ne̱ chá cunuda̱nj nij yuvii̱, ne̱ nda̱a caraa rque nij soꞌ a. Ga̱a ne̱ naquiꞌyaj chre̱ꞌ nii se vaa quináj tuꞌva nij yuvii̱, ne̱ quisíj ꞌo̱ cunu̱ꞌ chi̱j ya̱ scaa caraa quiꞌyaj se quináj tuꞌva nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Dan me se cunuda̱nj nij soꞌ chá, ne̱ quisíj nda̱a caꞌa̱nj míj yuvii̱ chá na̱nj ado̱nj. Ga̱a ne̱ naꞌnéé Jesucristó chrej man nij yuvii̱, ");
INSERT INTO trcNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ga̱a ne̱ nu̱ꞌ cavii Jesucristó ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ rá rihoo chéé rihaan na, ne̱ caꞌanj nij soꞌ rej cuꞌna̱j Dalmanuta a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Dan me se curiha̱nj do̱j nij síí fariseo, ga̱a ne̱ guun cheꞌe̱ nij soꞌ canó tuviꞌ nij soꞌ ga̱ Jesucristó, ne̱ dan me se cachíín niꞌya̱j nij soꞌ rihaan Jesucristó se vaa ra̱cuíj Diose̱ man Jesucristó, ne̱ quiꞌya̱j Jesucristó ꞌo̱ suun sa̱ꞌ noco̱o queneꞌe̱n nij soꞌ, ga̱a ne̱ gu̱un ya̱ rá nij soꞌ se vaa síí caꞌnéé ya̱ Diose̱ me Jesucristó, rá nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ga̱a ne̱ nucua̱j ndoꞌo caráchej Jesucristó, ne̱ cataj soꞌ rihaan nij soꞌ a: ―Ne̱ me cheꞌé me rá soj si̱j israelitá qui̱ꞌyáj suun sa̱ꞌ noco̱o queneꞌe̱n soj ga̱. Dan me se daj chiha̱a̱ míj se̱ quiꞌyáj suun sa̱ꞌ noco̱o cheꞌé soj a̱ maꞌ ―taj Jesucristó rihaan nij síí fariseo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ga̱a ne̱ tanáj Jesucristó man nij soꞌ, ga̱a ne̱ cavii uún soꞌ rque rihoo chéé rihaan na, ne̱ caꞌanj soꞌ rej xco̱ na lacuaná a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Dan me se quiniꞌyón nij síí tucuꞌyón se‑na̱na̱ Jesucristó ni̱caj nij soꞌ rachrúún cha̱ nij soꞌ, ne̱ vaa o̱rúnꞌ rachrúún rá rihoo va̱j ga̱ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ga̱a ne̱ caꞌneꞌ Jesucristó suun rihaan nij soꞌ, cataj Jesucristó: ―Cu̱tumé soj man soj se̱ gaa na̱nj quira̱nꞌ soj sayuun, quiꞌya̱j se‑le̱vadura nij síí fariseo do̱ꞌ, síí cuꞌna̱j Herodes do̱ꞌ á ―taj Jesucristó no nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ne̱ nuchruj ra̱a̱ ndoꞌo nij síí tucuꞌyón se‑na̱na̱ Jesucristó cheꞌé nana̱ caꞌmii soꞌ, ne̱: ―Cheꞌé se taj rachrúún nica̱j níꞌ, ne̱ cheꞌé dan aꞌmii soꞌ cheꞌé levadura se ꞌyaj naraa nana̱ rque rachrúún na̱nj ado̱nj ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ne̱ a̱j neꞌen Jesucristó da̱j uun nimán nij soꞌ, ne̱ cheꞌé dan cataj soꞌ: ―Me cheꞌé nanó ndoꞌo rá soj se vaa taj rachrúún rihaan soj ga̱. Me cheꞌé ataa xca̱j soj cuentá ga̱. ꞌO̱ se vaa nichra̱j ndoꞌo nimán soj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ꞌO̱ se vaa rlij rihaan soj, tza̱j ne̱ ne niꞌya̱j soj a̱ maꞌ. Vaa xréé soj, tza̱j ne̱ ne uno soj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ne̱ ne nuû rá soj ga̱a vaa da̱j ꞌo̱ ꞌu̱nꞌ gue̱e̱ rachrúún cuxraꞌ taꞌa̱j ꞌu̱nj tza̱j ne̱ quisíj chá cunu̱ꞌ ꞌu̱nꞌ míj snóꞌo, quiꞌyáj a. Ne̱ me da̱j scaa se chá quináj tuꞌva yuvii̱ naquiꞌyaj chre̱ꞌ soj, rá soj ga̱ ―taj Jesucristó, xnáꞌanj Jesucristó man nij soꞌ a. Ga̱a ne̱: ―Chuvi̱j a ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ga̱a ne̱ cataj uún Jesucristó: ―Ne̱ ne nuû rá soj ga̱a vaa da̱j ꞌó chi̱j gue̱e̱ rachrúún cuxraꞌ taꞌa̱j ꞌu̱nj tza̱j ne̱ quisíj chá cunu̱ꞌ caꞌa̱nj míj yuvii̱, quiꞌyáj a. Ne̱ me da̱j scaa se chá quináj tuꞌva yuvii̱ naquiꞌyaj chre̱ꞌ soj, rá soj ga̱ ―xnáꞌanj uún Jesucristó man nij soꞌ a. Ga̱a ne̱: ―Chi̱j a ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Ne̱ me cheꞌé me ataa xca̱j soj cuentá se vaa caꞌve̱e rque̱ ꞌu̱nj nu̱ꞌ se vaa achiin man soj ne̱ nuveé ina̱nj cheꞌé rej nano̱ rá soj cheꞌé rachrúún me caꞌmij rihaan soj cheꞌé se‑le̱vadura nij síí fariseo do̱ꞌ, síí cuꞌna̱j Herodes do̱ꞌ maꞌ ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ga̱a ne̱ catúj Jesucristó ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ rá chumanꞌ cuꞌna̱j Betsaida a. Ga̱a ne̱ nica̱j yuvii̱ ꞌo̱ síí tuchri̱i caꞌnaꞌ nij yuvii̱ rihaan Jesucristó, ne̱ cachíín niꞌya̱j nij yuvii̱ rihaan Jesucristó se vaa cuta̱ꞌ Jesucristó raꞌa Jesucristó raa̱ síí tuchri̱i cheꞌé rej naxra̱ꞌ rihaan síí tuchri̱i yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ga̱a ne̱ quitaꞌaa Jesucristó raꞌa síí tuchri̱i yoꞌ, ne̱ curiha̱nj soꞌ rej tuꞌva chumanꞌ ga̱ síí tuchri̱i, ne̱ quirii talúj Jesucristó rihaan síí tuchri̱i yoꞌ, ne̱ cutaꞌ raꞌa Jesucristó xráá soꞌ, ga̱a ne̱ xnáꞌanj Jesucristó man soꞌ a: ―Ruviꞌ rihaan so̱ꞌ naꞌ ―taj Jesucristó, xnáꞌanj soꞌ man síí tuchri̱i yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ga̱a ne̱ niꞌya̱j síí tuchri̱i yoꞌ do̱j, ga̱a ne̱ cataj soꞌ: ―Neꞌén ꞌu̱nj nij snóꞌo, ne̱ ase vaa chruun vaa nij soꞌ, tza̱j ne̱ chéé nij soꞌ niꞌya̱j ꞌu̱nj na̱nj asanj ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ga̱a ne̱ cutaꞌ raꞌa uún Jesucristó rihaan síí tuchri̱i yoꞌ, ga̱a ne̱ niꞌya̱j niꞌya̱j síí tuchri̱i, ne̱ dan me se nahuun sa̱ꞌ nu̱ꞌ rlij rihaan soꞌ, ne̱ curuviꞌ sa̱ꞌ cunuda̱nj rasu̱u̱n niꞌya̱j soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ga̱a ne̱ caꞌnéé Jesucristó man soꞌ quina̱nꞌ soꞌ, tza̱j ne̱ cataj Jesucristó rihaan soꞌ se vaa: ―A̱ doj se̱ catúj so̱ꞌ rá chumanꞌ, ne̱ se̱ cataj so̱ꞌ rihaan a̱ ꞌó nij yuvii̱, ga̱a ne̱ se̱ gaa na̱nj xca̱j nij yuvii̱ cuentá da̱j quiꞌyáj cheꞌé so̱ꞌ á ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ga̱a ne̱ curiha̱nj Jesucristó ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ chumanꞌ Betsaida yoꞌ, ne̱ caꞌanj nij soꞌ nij chumanꞌ raꞌa̱ noco̱ꞌ man chumanꞌ cuꞌna̱j Cesarea de Filipo do̱ꞌ a. Dan me se va̱j nij soꞌ, ne̱ xnáꞌanj Jesucristó man nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ cataj soꞌ: ―Da̱j taj nij yuvii̱ cheꞌé ꞌu̱nj ga̱. Ne̱ me síí mé ꞌu̱nj, taj nij yuvii̱ ga̱ ―taj Jesucristó, xnáꞌanj soꞌ man nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","―Vaa síí taj se vaa síí cuꞌna̱j Juan síí cutaꞌ ne man yuvii̱ mé so̱ꞌ ei. Ne̱ vaa síí taj uún se vaa síí cuꞌna̱j Elías síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá me uún so̱ꞌ chugua̱nj. Ne̱ vaa síí taj uún se vaa yoꞌó síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá me uún so̱ꞌ chiha̱ꞌ. ꞌO̱ se da̱nj taj ꞌo̱ ꞌo̱ nij yuvii̱ cheꞌé so̱ꞌ na̱nj ado̱nj ―cataj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","―Ne̱ maꞌa̱n soj, ga̱a ne̱ me síí mé ꞌu̱nj, rá maꞌa̱n soj ga̱ ―taj Jesucristó, xnáꞌanj soꞌ man nij síí tucuꞌyón se‑na̱na̱ soꞌ a. Ga̱a ne̱ cataj síí cuꞌna̱j Pedró: ―Síí caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun mé so̱ꞌ ei ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ga̱a ne̱ cataj xnaꞌanj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ se vaa se̱ nataꞌ nij soꞌ rihaan a̱ ꞌó yuvii̱ me síí me soꞌ, taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ga̱a ne̱ guun cheꞌe̱ Jesucristó tucuꞌyón soꞌ man nij síí tucuꞌyón se‑na̱na̱ soꞌ se vaa cheꞌé se síí caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ me soꞌ roꞌ, cheꞌé dan no̱ xcúún soꞌ quira̱nꞌ ndoꞌo soꞌ sayuun, quiꞌya̱j nij síí uun chij do̱ꞌ, nij xrej ata̱ suun noco̱o doj do̱ꞌ, nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan nij yuvii̱ do̱ꞌ, ne̱ nachri̱ꞌ nij soꞌ ni̱ꞌyaj nij soꞌ man soꞌ, ne̱ ticavi̱ꞌ nii man soꞌ, ne̱ cache̱n vaꞌnu̱j güii, ga̱a ne̱ cunu̱u iꞌna̱ꞌ uún soꞌ, cataj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ne̱ nucua̱j ndoꞌo nataꞌ soꞌ nana̱ yoꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. Ga̱a ne̱ quirii yaníj síí cuꞌna̱j Pedró man Jesucristó, ne̱ guun cheꞌe̱ soꞌ cataj soꞌ se vaa ne nó xcúún Jesucristó caꞌmi̱i̱ Jesucristó nana̱ vaa da̱nj a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ga̱a ne̱ canica̱j Jesucristó, ne̱ niꞌya̱j soꞌ man nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ cataj soꞌ rihaan Pedró se vaa ne nó xcúún uxrá maꞌa̱n Pedró caꞌmi̱i̱ Pedró da̱nj, ne̱ cataj soꞌ: ―Naxu̱u̱n so̱ꞌ mán so̱ꞌ rihanj á. Naꞌvej raj que̱neꞌenj mán so̱ꞌ a̱ maꞌ. ꞌO̱ se ase tuꞌva síí chre̱e síí cuꞌna̱j Satanás roꞌ, da̱nj tuꞌvá so̱ꞌ ei. Da̱nj tuꞌvá so̱ꞌ, cheꞌé se ne acaj so̱ꞌ cuentá da̱j me rá Diose̱ ado̱nj. Ma̱a̱n se ina̱nj acaj so̱ꞌ cuentá da̱j me rá yuvii̱ na̱nj ado̱nj ―taj Jesucristó rihaan síí cuꞌna̱j Pedró a. ");
INSERT INTO trcNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ga̱a ne̱ canacúún Jesucristó man nij yuvii̱ caꞌna̱ꞌ nij yuvii̱ rej nicu̱nꞌ soꞌ ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ, ga̱a ne̱ cataj soꞌ rihaan taranꞌ nij soꞌ a: ―Sese me rá yoꞌo̱ soꞌ canoco̱ꞌ soꞌ manj, ne̱ se̱ guun rá soꞌ quiꞌya̱j soꞌ se vaa me rá maꞌa̱n soꞌ quiꞌya̱j soꞌ maꞌ. Ne̱ caꞌve̱e se quira̱nꞌ uxrá soꞌ sayuun do̱ꞌ, caꞌve̱e se nda̱a cachro̱n nii man soꞌ rihaan rcutze̱ do̱ꞌ, tza̱j ne̱ yoꞌo̱ quiꞌya̱j suun soꞌ cheꞌej, ne̱ yoꞌo̱ canoco̱ꞌ raan soꞌ manj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tza̱j ne̱ sese vaa ꞌo̱ síí me rá ti̱nanii man maꞌa̱n rihaan sayuun, ne̱ vaa güii, ne̱ yoꞌo̱ cavi̱ꞌ nimán soꞌ ado̱nj. Tza̱j ne̱ sese cavi̱ꞌ yoꞌo̱ soꞌ cheꞌé se vaa me soꞌ síí noco̱ꞌ manj do̱ꞌ, cheꞌé se nataꞌ soꞌ se‑na̱na̱j nana̱ sa̱ꞌ do̱ꞌ, ne̱ vaa güii, ne̱ cunu̱u iꞌna̱ꞌ uún soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ne̱ a̱ me se quiri̱ꞌ ꞌo̱ soꞌ sese quiꞌya̱j canaán soꞌ nu̱ꞌ rasu̱u̱n ma̱n rihaan chumii̱ nihánj ne̱ caꞌa̱nj niꞌya̱ nimán soꞌ, rá soj ga̱. Daj chiha̱a̱ míj se̱ caꞌvee cavi̱i̱ sa̱ꞌ soꞌ, quiꞌya̱j rasu̱u̱n ma̱n rihaan chumii̱ nihánj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tza̱j ne̱ caꞌve̱e se navij nu̱ꞌ siꞌyaj yoꞌo̱ soꞌ rihaan chumii̱ nihánj, tza̱j ne̱ sese ga̱a̱ iꞌna̱ꞌ nimán soꞌ nu̱ꞌ cavii nu̱ꞌ caꞌanj, ne̱ quinano̱ rá soꞌ, rá soj naꞌ. Daj chiha̱a̱ míj se̱ quinanó rá soꞌ a̱ maꞌ. ꞌO̱ se cavi̱i̱ sa̱ꞌ uxrá soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","”Dan me se xa̱ꞌ síí uun naꞌa̱j niꞌya̱j manj ne̱ uun naꞌa̱j niꞌya̱j se‑na̱na̱j roꞌ, ase vaa nij síí chiꞌi̱i̱ tumé ndoꞌo cacunꞌ ma̱n rihaan chumii̱ nihánj cuano̱ vaa soꞌ ado̱nj. Ne̱ vaa güii gu̱un naꞌa̱j ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ ni̱ꞌyaj ꞌu̱nj man soꞌ asa̱ꞌ caꞌnaꞌ uún ꞌu̱nj rihaan chumii̱ nihánj, ne̱ dan me se uxrá veꞌé ga̱a̱ ꞌu̱nj, quiꞌya̱j Réé ꞌu̱nj, ne̱ caꞌna̱ꞌ nij se‑mo̱zó soꞌ ga̱ ꞌu̱nj asa̱ꞌ caꞌnáꞌ ꞌu̱nj na̱nj ado̱nj ―taj Jesucristó rihaan nij soꞌa. ");
INSERT INTO trcNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ga̱a ne̱ cataj uún soꞌ se vaa: ―Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa xa̱ꞌ taꞌa̱j soj si̱j nicu̱nꞌ nihánj cuano̱, me se ga̱a ataa a̱ cavi̱ꞌ taꞌa̱j soj, ne̱ ya̱ queneꞌe̱n taꞌa̱j soj asa̱ꞌ guun cheꞌe̱ Diose̱ nucua̱j ndoꞌo guun chij Diose̱ rihaan chumii̱ nihánj na̱nj ado̱nj ―taj Jesucristó rihaan taranꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Cachén vata̱nꞌ güii, ga̱a ne̱ nica̱j Jesucristó man síí cuꞌna̱j Pedró do̱ꞌ, síí cuꞌna̱j Jacobo do̱ꞌ, síí cuꞌna̱j Juan do̱ꞌ, caꞌanj soꞌ raa̱ ꞌo̱ quij xca̱a̱n rej taj va̱j a̱ ꞌó yuvii̱ ne a. Ga̱a ne̱ yoꞌo̱ cunuu ino̱ cunuda̱nj man Jesucristó niꞌya̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ne̱ dan me se cunuu catzi̱i̱ ndoꞌo saga̱nꞌ soꞌ, ne̱ nda̱a raa̱n lá maꞌa̱n saga̱nꞌ soꞌ niꞌya̱j nij soꞌ a. Ne̱ taj vaj a̱ yoꞌó síí ma̱n rihaan chumii̱ nihánj caꞌve̱e quiꞌya̱j catzi̱i̱ yatzíj nda̱a rá se vaa saga̱nꞌ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ne̱ niꞌya̱j vaꞌnu̱j nij soꞌ, ne̱ dan me se naquiꞌyaa síí cuꞌna̱j Elías síí cane ga̱a naá ga̱ síí cuꞌna̱j Moisés rihaan nij soꞌ, ne̱ nanó ro̱j soꞌ cuentó ga̱ Jesucristó niꞌya̱j nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ga̱a ne̱ cataj Pedró rihaan Jesucristó a: ―Cuna̱j uxrá vaa mán núj nihánj ga̱ so̱ꞌ, maestro. Ne̱ quiꞌya̱j núj vaꞌnu̱j veꞌ yacataj cane̱ soj na̱nj á. ꞌO̱ veꞌ ca̱né so̱ꞌ, ne̱ yoꞌó veꞌ cane̱ síí cuꞌna̱j Moisés, ne̱ yoꞌó veꞌ cane̱ síí cuꞌna̱j Elías ei ―taj Pedró rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ꞌO̱ se ne queneꞌe̱n uxrá Pedró da̱j me cheꞌé caꞌmii soꞌ rihaan Jesucristó da̱nj a̱ maꞌ. ꞌO̱ se cuchuꞌviꞌ ndoꞌo vaꞌnu̱j nij soꞌ cheꞌé se vaa queneꞌen nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ga̱a ne̱ caꞌnaꞌ ꞌo̱ ngaa, ne̱ caráán ngaa man taranꞌ nij soꞌ a. Ga̱a ne̱ Diose̱ roꞌ, caꞌmii nana̱ cuno nij soꞌ rque ngaa yoꞌ, ne̱ cataj Diose̱ a: ―Síí nihánj me taꞌníj ado̱nj. ꞌE̱e̱ raj man soꞌ ado̱nj. Cuno̱ soj rihaan soꞌ ei ―taj Diose̱ cuno nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ga̱a ne̱ nu̱ꞌ niꞌya̱j nij soꞌ, ne̱ da̱j o̱rúnꞌ Jesucristó nicu̱nꞌ ga̱ nij soꞌ, queneꞌen nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ga̱a ne̱ ga̱a nanij nij soꞌ tacóó quij yoꞌ me se caꞌneꞌ Jesucristó suun rihaan nij soꞌ se vaa se̱ nataꞌ nij soꞌ rihaan a̱ doj yuvii̱ cheꞌé se vaa queneꞌen nij soꞌ a. Yoꞌo̱ dínj ga̱a̱ tuꞌva nij soꞌ cheꞌé rasu̱u̱n queneꞌen nij soꞌ a. Nda̱a quisíj caviꞌ soꞌ ne̱ cunuu iꞌna̱ꞌ uún soꞌ, ga̱a ne̱ caꞌve̱e nata̱ꞌ nij soꞌ se vaa queneꞌen nij soꞌ da̱j quiranꞌ soꞌ síí caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱, taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ne̱ yoꞌo̱ nuû rá nij soꞌ nana̱ yoꞌ, ne̱ xnáꞌanj ndoꞌo nij soꞌ man tuviꞌ maꞌa̱n nij soꞌ me cheꞌé me cataj Jesucristó se vaa cavi̱ꞌ soꞌ ne̱ cunu̱u iꞌna̱ꞌ uún soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ga̱a ne̱ xnáꞌanj nij soꞌ man Jesucristó, cataj nij soꞌ: ―Me cheꞌé taj nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ se vaa asino caꞌna̱ꞌ síí cuꞌna̱j Elías síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá, ga̱a ne̱ caꞌve̱e caꞌne̱ꞌ Diose̱ cacunꞌ cheꞌé yuvii̱ ga̱ ―taj nij síí tucuꞌyón se‑na̱na̱ Jesucristó, xnáꞌanj nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Ya̱ aꞌmii nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés, taj nij soꞌ se vaa asino caꞌna̱ꞌ síí cuꞌna̱j Elías, ga̱a ne̱ naquiꞌya̱j sa̱ꞌ soꞌ nu̱ꞌ rasu̱u̱n ado̱nj. Ne̱ me cheꞌé taj danj Diose̱ se vaa síí caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ me se quira̱nꞌ ndoꞌo soꞌ sayuun ne̱ nachri̱ꞌ nij yuvii̱ ni̱ꞌyaj nij yuvii̱ man soꞌ, rá soj ga̱. ");
INSERT INTO trcNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Tza̱j ne̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa a̱j caꞌnaꞌ ya̱ síí cuꞌna̱j Elías, tza̱j ne̱ quiꞌyaj ya̱ yuvii̱ nda̱a vaa me rá maꞌa̱n nij yuvii̱ man soꞌ nda̱a vaa taj danj Diose̱ cheꞌé soꞌ na̱nj ado̱nj. Cheꞌé dan caꞌve̱e xca̱j soj cuentá da̱j qui̱ránꞌ ꞌu̱nj quiꞌya̱j uún nij yuvii̱ ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Dan me se cuchiꞌ nij soꞌ rej nicu̱nꞌ yoꞌó nij síí tucuꞌyón se‑na̱na̱ Jesucristó, ne̱ queneꞌen nij soꞌ se vaa mán queꞌe̱e̱ yuvii̱ anica̱j rej nicu̱nꞌ nij soꞌ, ne̱ nicu̱nꞌ do̱j nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés, ne̱ caꞌmii cunuꞌ uxrá nij soꞌ ga̱ nij síí tucuꞌyón se‑na̱na̱ Jesucristó yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ne̱ nu̱ꞌ queneꞌen nij yuvii̱ man Jesucristó, ne̱ nu̱ꞌ caꞌanj ndoꞌo rá nij yuvii̱, ne̱ cunánj nij yuvii̱ nda̱a rej va̱j Jesucristó caꞌmi̱i̱ nij soꞌ ga̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ga̱a ne̱ xnáꞌanj Jesucristó man nij yuvii̱ a: ―Me cheꞌé me caꞌmii cunuꞌ nij soj ga̱ nij síí tucuꞌyón se‑na̱na̱j ga̱ ―taj soꞌ rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ga̱a ne̱ yoꞌo̱ nij yuvii̱ cataj rihaan Jesucristó a: ―ꞌU̱nj me se nica̱j ꞌu̱nj taꞌníj caꞌnáꞌ ꞌu̱nj nano̱ꞌ ꞌu̱nj mán so̱ꞌ, maestro. Ne̱ taꞌníj me se yaꞌmi̱i soꞌ cheꞌé se nu̱u̱ nana̱ chre̱e nimán soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ne̱ me rej maꞌa̱n me rá nana̱ chre̱e qui̱taꞌaa nana̱ chre̱e man soꞌ, ne̱ caganꞌ nana̱ chre̱e man soꞌ rihaan yoꞌóó, ne̱ avii yatanꞌ tuꞌva soꞌ, ne̱ chá ru̱j soꞌ cúú yanꞌ soꞌ, ne̱ nuu chrúnj nu̱ꞌ soꞌ na̱nj ado̱nj. Ne̱ cataj ꞌu̱nj rihaan nij síí tucuꞌyón se‑na̱na̱ so̱ꞌ se vaa quiri̱i̱ nij soꞌ man nana̱ chre̱e nimán taꞌníj, tza̱j ne̱ ne caꞌve̱e quiꞌya̱j canaán nij soꞌ maꞌ ―taj snóꞌo yoꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ga̱a ne̱ cataj Jesucristó rihaan nij yuvii̱ a: ―Dan me se síí ne amán rá me soj si̱j ma̱n rihaan chumii̱ nihánj cuano̱, ne̱ a̱ me daj cache̱j ga̱ soj, ne̱ a̱ me daj ga̱a̱ naj nimanj ni̱ꞌyaj ꞌu̱nj man soj, ga̱a ne̱ caꞌve̱e quiꞌya̱j canaán soj ga̱. Ni̱caj soj man xnii caꞌna̱ꞌ soj rihanj cuaj á ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ga̱a ne̱ nica̱j nij yuvii̱ man xnii caꞌnaꞌ nij yuvii̱ rihaan Jesucristó a. Ne̱ dan me se ga̱a queneꞌen nana̱ chre̱e man Jesucristó, ne̱ nu̱ꞌ snúú xnii, ne̱ naxruꞌ xnii, quiꞌyaj nana̱ chre̱e yoꞌ, ne̱ natúj rmi̱i̱ xnii, ne̱ cavii yatanꞌ tuꞌva xnii a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ga̱a ne̱ xnáꞌanj Jesucristó man rej xnii, cataj Jesucristó: ―Me da̱j güii ranꞌ taꞌníí so̱ꞌ da̱nj ga̱ ―taj Jesucristó rihaan rej xnii a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ga̱a ne̱ cataj rej xnii: ―Da̱nj ranꞌ soꞌ asi̱j neꞌej me soꞌ, ne̱ queꞌe̱e̱ ndoꞌo caganꞌ nana̱ chre̱e man soꞌ rihaan yaꞌan do̱ꞌ, rihaan na do̱ꞌ, quiꞌyaj nana̱ chre̱e, cheꞌé rej me rá nana̱ chre̱e cavi̱ꞌ soꞌ, tza̱j ne̱ sese caꞌve̱e, ne̱ cunu̱u ꞌe̱e̱ rá so̱ꞌ manj ne̱ ra̱cuíj so̱ꞌ man núj rugua̱nj ―taj rej xnii yoꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Taj cheꞌé cata̱j so̱ꞌ nana̱ “sese caꞌve̱e” maꞌ. ꞌO̱ se síí amán rá niꞌya̱j man Diose̱ roꞌ, caꞌve̱e quiꞌya̱j soꞌ cunuda̱nj na̱nj ado̱nj ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nu̱ꞌ caꞌmii Jesucristó da̱nj, ne̱ nu̱ꞌ caguáj rej xnii, cataj soꞌ: ―Amán rá ꞌu̱nj niꞌya̱j ꞌu̱nj Diose̱ á. Ra̱cuíj so̱ꞌ manj cuchuma̱n raj doj, Señor ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Dan me se queneꞌen Jesucristó se vaa cunánj ndoꞌo yuvii̱ caꞌna̱ꞌ nij yuvii̱ rej nicu̱nꞌ soꞌ, ne̱ cheꞌé dan caꞌneꞌ Jesucristó suun rihaan nana̱ chre̱e yoꞌ, ne̱ cataj Jesucristó: ―Rihaan so̱ꞌ na̱na̱ chre̱e quiꞌyaj yaꞌmi̱i ne̱ quiꞌyaj soꞌo̱ man xnii nihánj aꞌmij, ne̱ cata̱j xnaꞌanj ꞌu̱nj rihaan so̱ꞌ se vaa cu̱riha̱nj so̱ꞌ cuaj nimán soꞌ cuano̱, ne̱ daj chiha̱a̱ míj se̱ catúj uún so̱ꞌ nimán soꞌ mei ―taj Jesucristó rihaan nana̱ chre̱e yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ga̱a ne̱ caguáj nana̱ chre̱e, ne̱ guun snu̱j ndoꞌo xnii naxruꞌ xnii, quiꞌyaj nana̱ chre̱e, ne̱ dan me se curiha̱nj nana̱ chre̱e nimán xnii yoꞌ a. Ga̱a ne̱ ase vaa síí caviꞌ roꞌ, da̱nj vaa xnii, na̱j xnii rihaan yoꞌóó, ne̱ cataj nij yuvii̱ se vaa ya̱ ya̱ caviꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tza̱j ne̱ quitaꞌaa Jesucristó raꞌa xnii, ne̱ naxca̱j Jesucristó man xnii, ne̱ naxaga̱a̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Dan me se corá catúj Jesucristó rá veꞌ, ne̱ ina̱nj nij maꞌa̱n nij síí tucuꞌyón se‑na̱na̱ soꞌ roꞌ, ma̱n rá veꞌ ga̱ soꞌ, ne̱ xnáꞌanj nij soꞌ man soꞌ, ne̱ cataj nij soꞌ: ―Me cheꞌé ne gu̱un nucua̱j núj quiri̱i̱ núj man nana̱ chre̱e yoꞌ ga̱ ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ se vaa: ―Xa̱ꞌ nana̱ chre̱e vaa da̱nj roꞌ, se̱ caꞌvee quiꞌya̱j níꞌ cu̱riha̱nj nij soꞌ nimán yuvii̱ sese ne achíín niꞌya̱j ndoꞌo níꞌ rihaan Diose̱ maꞌ. Dan me se cachi̱nj niꞌya̱j uxráꞌ, ne̱ cara̱a̱ gue̱e̱ ndoꞌoꞌ, ga̱a ne̱ caꞌve̱e ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ga̱a ne̱ cavii Jesucristó ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ rej yoꞌ, ne̱ caꞌanj nij soꞌ estadó Galilea, ne̱ ne caꞌve̱j rá Jesucristó xca̱j nij yuvii̱ cuentá me rej va̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ꞌO̱ se tucuꞌyón soꞌ man nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ dan me se cataj soꞌ rihaan nij soꞌ se vaa: ―ꞌO̱ se síí caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ mej, ne̱ vaa güii, ne̱ nago̱ꞌ nii manj rihaan yuvii̱ ado̱nj. Dan me se ticavi̱ꞌ nij yuvii̱ manj, ga̱a ne̱ cache̱n vaꞌnu̱j güii, ga̱a ne̱ cunu̱u iꞌna̱ꞌ uún ꞌu̱nj na̱nj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tza̱j ne̱ ne cuno̱ nij soꞌ nana̱ caꞌmii Jesucristó, ne̱ chuꞌviꞌ nij soꞌ xna̱ꞌanj nij soꞌ man Jesucristó me taj nana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ga̱a ne̱ catúj Jesucristó ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ chumanꞌ cuꞌna̱j Capernaum a. Dan me se ga̱a mán nij soꞌ rá veꞌ, ne̱ xnáꞌanj Jesucristó man nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ cataj soꞌ: ―Me cheꞌé me canó tuviꞌ nij soj ga̱a va̱j níꞌ chrej asi̱j cuaꞌa̱a ga̱ ―taj Jesucristó, xnáꞌanj soꞌ man nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ga̱a ne̱ cunuu dínj tuꞌva nij soꞌ a. ꞌO̱ se ga̱a va̱j nij soꞌ chrej, ne̱ canó tuviꞌ nij soꞌ ga̱ maꞌa̱n tuviꞌ nij soꞌ se vaa cataj nij soꞌ me nij soꞌ me síí gu̱un chij doj a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ga̱a ne̱ caꞌanj quita̱j Jesucristó chruun xlá, ne̱ canacúún soꞌ man chuvi̱j nij soꞌ se vaa caꞌna̱ꞌ nij soꞌ rihaan soꞌ, ga̱a ne̱ cataj soꞌ rihaan nij soꞌ a: ―Me maꞌa̱n ꞌo̱ síí me rá gu̱un chij doj, ne̱ soꞌ me síí gu̱un síí noco̱ꞌ, ne̱ nda̱a gu̱un soꞌ mozó rihaan daj a̱ tuviꞌ soꞌ ado̱nj ―taj Jesucristó rihaan chuvi̱j nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ga̱a ne̱ nica̱j Jesucristó man ꞌo̱ neꞌej, ne̱ cachrón soꞌ man neꞌej yoꞌ tanu̱u̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ naꞌya̱a̱n soꞌ man neꞌej, ne̱ cataj soꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a: ");
INSERT INTO trcNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Me maꞌa̱n ꞌo̱ síí aráj cochro̱j ne̱ aꞌmii sa̱ꞌ soꞌ ga̱ ꞌo̱ neꞌej nihánj cheꞌej, ne̱ adi̱ꞌ ma̱ꞌanj me aráj cochro̱j ne̱ aꞌmii sa̱ꞌ soꞌ ga̱ vaa na̱nj ado̱nj. Dan me se síí aꞌmii sa̱ꞌ ga̱ ꞌu̱nj me se nuveé o̱rúnꞌ ꞌu̱nj me aꞌmii sa̱ꞌ soꞌ ga̱ maꞌ. Ma̱a̱n Diose̱ ya̱ síí caꞌnéé mán ꞌu̱nj rihaan chumii̱ nihánj me aráj cochro̱j ya̱ soꞌ ne̱ aꞌmii sa̱ꞌ ya̱ soꞌ ga̱ vaa na̱nj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Cataj síí cuꞌna̱j Juan rihaan Jesucristó a: ―Queneꞌen núj man ꞌo̱ síí ataꞌ tuꞌva se‑chu̱vií so̱ꞌ, ne̱ uriha̱nj nana̱ chre̱e nimán nij yuvii̱, ꞌyaj soꞌ, na̱nj maestro. Tza̱j ne̱ caráán núj chrej caꞌmi̱i̱ soꞌ ne̱ se̱ quiꞌyaj soꞌ da̱nj, cheꞌé se nuveé si̱j chéé ga̱ níꞌ me soꞌ, taj núj, na̱nj maestro ―taj Juan rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ga̱a ne̱ cataj Jesucristó rihaan chuvi̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ a: ―Caꞌne̱ꞌ sa̱ꞌ gue̱e̱ rá soj quiꞌya̱j maꞌa̱n soꞌ da̱nj ei. ꞌO̱ se taj a̱ ꞌó síí ataꞌ tuꞌva se‑chu̱vií ꞌu̱nj ne̱ quiꞌyaj soꞌ suun sa̱ꞌ noco̱o cheꞌé se‑chu̱vií ꞌu̱nj, ne̱ síj, ga̱a ne̱ ca̱nica̱j soꞌ ne̱ caꞌmi̱i̱ chre̱e soꞌ cheꞌé ꞌu̱nj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ꞌO̱ se xa̱ꞌ síí ne unuꞌ ga̱ níꞌ, tza̱j ne̱ tuviꞌ níꞌ me soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ꞌO̱ se a̱ me maꞌa̱n yoꞌo̱ síí rqué do̱j na coꞌo̱ nij soj cheꞌé se‑chu̱vií ꞌu̱nj, ne̱ ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa daj chiha̱a̱ míj se̱ quinavij se sa̱ꞌ na̱ruꞌvee Diose̱ rihaan síí rqué do̱j na yoꞌ coꞌo soj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","”Dan me se me maꞌa̱n ꞌo̱ síí quiꞌya̱j chiꞌi̱i̱ nimán ꞌo̱ síí leꞌe̱j amán rá niꞌya̱j manj, ne̱ caꞌve̱e a̱ doj cavi̱i̱ sa̱ꞌ síí quiꞌyaj da̱nj sese toco̱ꞌ nii ꞌo̱ yuvej xi̱j váj ꞌnúú trigó gaán chihá soꞌ ne̱ ta̱güéj nii man soꞌ rque na yaꞌa̱nj na̱nj ado̱nj. Dan me se doj a̱ sayuun quira̱nꞌ soꞌ, sese quiꞌyaj chiꞌi̱i̱ soꞌ nimán ꞌo̱ síí leꞌe̱j amán rá niꞌya̱j manj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","”Dan me se sese raꞌá so̱ꞌ me rá quiꞌya̱j cacunꞌ, ne̱ táá a̱ se caꞌne̱ꞌ so̱ꞌ man yoꞌ, ga̱a ne̱ se̱ gaa na̱nj caꞌa̱nj so̱ꞌ rihaan yaꞌan quiꞌya̱j yoꞌ ei. Taj se ꞌyaj se nu̱j se taj yan vaj raꞌá so̱ꞌ, tza̱j ne̱ caꞌve̱e ca̱yáán so̱ꞌ ga̱ Diose̱ ga̱a̱ ei. Tza̱j ne̱ sese quita̱j raꞌá so̱ꞌ ne̱ quiꞌyaj yoꞌ cacunꞌ, ne̱ caꞌa̱nj so̱ꞌ rihaan yaꞌan, quiꞌya̱j yoꞌ, ne̱ dan me se yaꞌan yoꞌ me se daj chiha̱a̱ míj se̱ quinaꞌáj yaꞌan yoꞌ nuvi̱i niga̱nꞌ a̱ mei. ");
INSERT INTO trcNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ne̱ nij síí ma̱n rihaan yaꞌan yoꞌ me se se̱ caꞌvee cavi̱ꞌ xlúú chá man nij soꞌ, ne̱ daj chiha̱a̱ míj se̱ quinaꞌáj yaꞌan rej cu̱nuû nij soꞌ caca̱a̱ nij soꞌ a̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","”Ne̱ sese tacóó so̱ꞌ me rá quiꞌya̱j cacunꞌ, ne̱ táá a̱ se caꞌne̱ꞌ so̱ꞌ man yoꞌ, ga̱a ne̱ se̱ gaa na̱nj caꞌa̱nj so̱ꞌ rihaan yaꞌan quiꞌya̱j yoꞌ na̱nj ei. Taj se ꞌyaj se nu̱j se taj yan vaj tacóó so̱ꞌ, tza̱j ne̱ caꞌve̱e ca̱yáán so̱ꞌ ga̱ Diose̱ ei. Tza̱j ne̱ sese quita̱j tacóó so̱ꞌ ne̱ quiꞌyaj yoꞌ cacunꞌ, ne̱ caꞌa̱nj so̱ꞌ rihaan yaꞌan, quiꞌya̱j yoꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ne̱ nij síí ma̱n rihaan yaꞌan yoꞌ me se se̱ caꞌvee cavi̱ꞌ xlúú chá man nij soꞌ, ne̱ daj chiha̱a̱ míj se̱ quinaꞌáj yaꞌan rej cu̱nuû nij soꞌ caca̱a̱ nij soꞌ a̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","”Veé da̱nj uún sese me rá rlij rihaan so̱ꞌ quiꞌya̱j yoꞌ cacunꞌ, ne̱ táá a̱ se quiri̱i̱ so̱ꞌ man yoꞌ, ne̱ síí rihaan canuu̱ ga̱a̱ so̱ꞌ, tza̱j ne̱ caꞌve̱e catu̱u̱ so̱ꞌ rej gu̱un chij Diose̱ ei. Tza̱j ne̱ sese cu̱nuû rlij rihaan so̱ꞌ ne̱ quiꞌyaj yoꞌ cacunꞌ, ne̱ caꞌa̱nj so̱ꞌ rihaan yaꞌan, quiꞌya̱j yoꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ne̱ nij síí ma̱n rihaan yaꞌan yoꞌ me se se̱ caꞌvee cavi̱ꞌ xlúú chá man nij soꞌ, ne̱ daj chiha̱a̱ míj se̱ quinaꞌáj yaꞌan rej cuma̱n nij soꞌ caca̱a̱ nij soꞌ a̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","”ꞌO̱ se vaa sayuun quira̱nꞌ cunuda̱nj nij rasu̱u̱n ma̱n rihaan chumii̱ nihánj, quiꞌya̱j Diose̱, ne̱ dan me se ase vaa nuu sa̱ꞌ nee̱ ꞌyaj yaan roꞌ, da̱nj ga̱a̱ cunu̱u sa̱ꞌ nij síí ma̱n rihaan chumii̱ nihánj, quiꞌya̱j yaꞌan ei. ");
INSERT INTO trcNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","”Ne̱ ase vaa yaan ga̱ chraa roꞌ, da̱nj vaa nij soj si̱j tucuꞌyón se‑na̱na̱j ga̱ chumii̱ nihánj, ne̱ vaa se uun ndoꞌo yaan ei. Dan me se sese ne ꞌne̱ꞌ chá yaan yoꞌ, ga̱a ne̱ taj se qui̱ꞌyáꞌ cunu̱u sa̱ꞌ yaan ga̱a̱ a̱ maꞌ. Cheꞌé dan, ase vaa yaan ꞌne̱ꞌ sa̱ꞌ roꞌ, da̱nj ga̱a̱ soj, ne̱ dínj ca̱yáán soj ga̱ tuviꞌ soj, ne̱ caꞌve̱e cunu̱u sa̱ꞌ chumii̱ nihánj quiꞌya̱j soj na̱nj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ga̱a ne̱ curiha̱nj Jesucristó rej yoꞌ, ne̱ caꞌanj soꞌ nda̱a rne̱j tuꞌva chráá cuꞌna̱j Jordán, nda̱a estadó Judea a. Ga̱a ne̱ cunuu chre̱ꞌ uún queꞌe̱e̱ yuvii̱ rihaan soꞌ, ne̱ tucuꞌyón uún soꞌ se‑na̱na̱ soꞌ rihaan nij yuvii̱, nda̱a vaa uꞌyón soꞌ ꞌyaj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ga̱a ne̱ caꞌnaꞌ do̱j síí fariseo rihaan soꞌ, ne̱ xnáꞌanj nij soꞌ man Jesucristó sese no̱ xcúún snóꞌo quiriꞌi̱j snóꞌo man nica̱ soꞌ a. Da̱nj cataj nij síí fariseo, cheꞌé se guun rá nij soꞌ cuta̱ꞌ nij soꞌ cacunꞌ xráá Jesucristó cheꞌé nana̱ caꞌmi̱i̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Ne̱ da̱j cataj síí cuꞌna̱j Moisés quiꞌya̱j soj ga̱ ―taj Jesucristó, xnáꞌanj soꞌ man nij síí fariseo a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ga̱a ne̱ cataj nij soꞌ se vaa: ―Caꞌneꞌ síí cuꞌna̱j Moisés suun se vaa na̱xcaj yuvii̱ yanj rihaan nij síí nica̱j suun, ne̱ caꞌve̱e quiriꞌi̱j yuvii̱ man nica̱ yuvii̱ á ―taj nij síí fariseo a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Ma̱a̱n cheꞌé se síí nichra̱j ndoꞌo rá me nij soj roꞌ, cheꞌé dan cachrón Moisés nana̱ yoꞌ rihaan yanj cuno̱ soj a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tza̱j ne̱ asi̱j quiꞌyaj Diose̱ chumii̱, ne̱ quiꞌyaj Diose̱ snóꞌo, ne̱ quiꞌyaj Diose̱ chana̱, ne̱ vi̱j ro̱j soꞌ me yuvii̱, quiꞌyaj Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Cheꞌé dan ta̱náj snóꞌo man rej soꞌ, man nii soꞌ do̱ꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ne̱ ase vaa o̱rúnꞌ yuvii̱ roꞌ, da̱nj ga̱a̱ snóꞌo ga̱ nica̱ snóꞌo, taj danj Diose̱ a. Dan me se nuveé vi̱j ranꞌ yuvii̱ me ro̱j soꞌ asi̱j xcaj tuviꞌ ro̱j soꞌ a̱ maꞌ. ꞌO̱ se ase vaa o̱rúnꞌ yuvii̱ roꞌ, vaa ro̱j soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Dan me se Diose̱ me síí quiꞌyaj xcaj tuviꞌ ro̱j soꞌ, ne̱ cheꞌé dan ne nó xcúún a̱ ꞌó yuvii̱ caꞌne̱ꞌ tanu̱u̱ yuvii̱ man ro̱j soꞌ maꞌ ―taj Jesucristó rihaan nij síí fariseo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Dan me se ga̱a ma̱n nij síí tucuꞌyón se‑na̱na̱ Jesucristó rá ꞌo̱ veꞌ ga̱ soꞌ, ga̱a ne̱ xnáꞌanj nij soꞌ man soꞌ cheꞌé nana̱ caꞌmii soꞌ rihaan nij síí fariseo a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Me maꞌa̱n ꞌo̱ síí riꞌíj man nica̱ ne̱ xcaj soꞌ man yoꞌó chana̱, ne̱ tumé ndoꞌo soꞌ cacunꞌ, ne̱ nij quiꞌyaj soꞌ rihaan nica̱ soꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tza̱j ne̱ sese cuna̱nj chana̱ rihaan nica̱ noꞌ, ne̱ xca̱j noꞌ man yoꞌó chii, ne̱ tumé ndoꞌo noꞌ cacunꞌ uún ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ga̱a ne̱ nica̱j nij yuvii̱ man nij neꞌej caꞌnaꞌ nij yuvii̱ rihaan Jesucristó, cheꞌé rej cuta̱ꞌ Jesucristó raꞌa soꞌ raa̱ nij neꞌej a. Tza̱j ne̱ nij síí tucuꞌyón se‑na̱na̱ Jesucristó me se cataj xnaꞌanj nij soꞌ rihaan nij yuvii̱ se vaa ne nó xcúún nij neꞌej caꞌna̱ꞌ nij neꞌej rihaan Jesucristó, taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tza̱j ne̱ xcaj Jesucristó cuentá da̱j quiꞌyaj nij síí tucuꞌyón se‑na̱na̱ soꞌ, ga̱a ne̱ caꞌmaan rá Jesucristó, ne̱ cataj soꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a: ―Caꞌne̱ꞌ rá soj caꞌna̱ꞌ nij neꞌej rihanj á. Se̱ caráán soj chrej rihaan nij neꞌej mei. ꞌO̱ se tucua̱ nij síí vaa da̱nj roꞌ, me rej ya̱nj Diose̱ uun chij Diose̱ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa me maꞌa̱n ꞌo̱ síí naꞌvej rá gu̱un chij Diose̱ nimán, nda̱a vaa uun chij Diose̱ nimán neꞌej, ne̱ daj chiha̱a̱ míj se̱ caꞌvee ca̱yáán soꞌ ga̱ Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj maꞌ ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ga̱a ne̱ naꞌya̱a̱n Jesucristó man nij neꞌej, ne̱ utaꞌ soꞌ raꞌa soꞌ raa̱ nij neꞌej, ne̱ achíín niꞌya̱j soꞌ rihaan Diose̱ cheꞌé nij neꞌej a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Dan me se ga̱a nayón Jesucristó chrej, ne̱ dan me se cunánj ꞌo̱ síí tachru̱u̱ yoꞌ caꞌnaꞌ soꞌ rihaan Jesucristó, ne̱ canicunꞌ ru̱j síí tachru̱u̱ yoꞌ rihaan Jesucristó, ne̱ xnáꞌanj soꞌ man Jesucristó, cataj soꞌ, ne̱: ―Maestro. Síí sa̱ꞌ uxrá mé so̱ꞌ ado̱nj. Da̱j qui̱ꞌyáj ne̱ caꞌve̱e ca̱yánj ga̱ Diose̱ nu̱ꞌ cavii nu̱ꞌ caꞌanj ga̱ ―taj síí tachru̱u̱ yoꞌ, xnáꞌanj soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Me cheꞌé cataj so̱ꞌ se vaa síí sa̱ꞌ uxrá mej ga̱. ꞌO̱ se o̱rúnꞌ Diose̱ me síí sa̱ꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ne̱ a̱j neꞌén so̱ꞌ nij nana̱ noco̱o ya̱ ya̱ nana̱ cataj xnaꞌanj Diose̱ se vaa canoco̱ꞌ níꞌ á. Dan me se taj nana̱ yoꞌ: “Se̱ ticavíꞌ so̱ꞌ yuvii̱ maꞌ. Se̱ cotoj so̱ꞌ ga̱ chana̱ nica̱ yoꞌó yuvii̱ maꞌ. Se̱ quiꞌyaj itu̱u̱ so̱ꞌ siꞌyaj yoꞌó yuvii̱ maꞌ. Se̱ nanó so̱ꞌ cuentó ne̱ cheꞌé yuvii̱ maꞌ. Se̱ tihaꞌ yuꞌunj so̱ꞌ man yuvii̱ cheꞌé saꞌanj maꞌ. Cara̱a̱ co̱chróó so̱ꞌ rihaan réé so̱ꞌ do̱ꞌ, rihaan nií so̱ꞌ do̱ꞌ á” ―taj Jesucristó rihaan síí tachru̱u̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","―Asi̱j ga̱a mej xnii me veꞌé unó ꞌu̱nj nu̱ꞌ nij nana̱ yoꞌ, na̱nj maestro ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ga̱a ne̱ niꞌya̱j uxrá Jesucristó man soꞌ, ne̱ cunuu ꞌe̱e̱ rá Jesucristó man soꞌ, ne̱ cataj Jesucristó rihaan soꞌ a: ―Da̱j o̱rúnꞌ rasu̱u̱n achiin ya̱ mán so̱ꞌ na̱nj ei. Cavi̱i̱ so̱ꞌ caꞌa̱nj so̱ꞌ, ne̱ cutuꞌve̱e̱ so̱ꞌ nu̱ꞌ siꞌyáá so̱ꞌ, ne̱ saꞌanj quiri̱ꞌ so̱ꞌ roꞌ, caxri̱i̱ so̱ꞌ ston nij síí nique̱, ne̱ cuma̱n ndoꞌo siꞌyáá so̱ꞌ rej xta̱ꞌ, quiꞌya̱j Diose̱ na̱nj ei. Ne̱ dan me se caꞌna̱ꞌ so̱ꞌ, ne̱ ca̱nocóꞌ so̱ꞌ manj, caꞌa̱nj níꞌ á ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ga̱a ne̱ quiriꞌ ndoꞌo rá síí tachru̱u̱, quiꞌyaj se‑na̱na̱ Jesucristó, ne̱ caꞌanj u̱u̱n soꞌ, ne̱ nanó ndoꞌo rá soꞌ a. ꞌO̱ se síí ruꞌvee me soꞌ, ne̱ vaa ndoꞌo siꞌyaj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ga̱a ne̱ niꞌya̱j Jesucristó, ne̱ cataj soꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a: ―Sayu̱u̱n uxrá vaa quisi̱j nij síí vaa ndoꞌo saꞌanj rihaan ca̱yáán ga̱ Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj na̱nj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ga̱a ne̱ caꞌanj ndoꞌo rá nij soꞌ ga̱a cuno nij soꞌ nana̱ yoꞌ nana̱ caꞌmii Jesucristó a. Ga̱a ne̱ cataj uún Jesucristó rihaan nij soꞌ a: ―Sayu̱u̱n uxrá vaa quisi̱j yuvii̱ ca̱yáán nij yuvii̱ ga̱ Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj na̱nj chugua̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Dan me se neꞌen soj se vaa sayu̱u̱n ndoꞌo vaa cache̱n xcuu camelló rihaan yuꞌuj ta̱j tacúún cúú nuvá, tza̱j ne̱ cuano̱ nihánj me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa caꞌve̱e a̱ doj cache̱n xcuu yoꞌ yuꞌuj ta̱j tacúún cúú nuvá, nda̱a rá se vaa síí ruꞌve̱e̱, ne̱ se̱ guun cache̱n soꞌ ca̱yáán soꞌ ga̱ Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj a̱ maꞌ ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ga̱a ne̱ caꞌanj ndoꞌo rá nij soꞌ, ne̱ cataj nij soꞌ rihaan Jesucristó a: ―Cheꞌé dan me se me síí gu̱un nucua̱j quinani̱i̱ rihaan sayuun ga̱ ―taj nij soꞌ, xnáꞌanj nij soꞌ man soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Niꞌya̱j Jesucristó man nij soꞌ, ne̱ cataj soꞌ: ―Se̱ guun nucua̱j yuvii̱ quinani̱i̱ maꞌa̱n nij yuvii̱ rihaan sayuun maꞌ. Sayu̱u̱n uxrá vaa rihaan nij soꞌ na̱nj ado̱nj. Tza̱j ne̱ xa̱ꞌ rihaan Diose̱ me se ne sayu̱u̱n a̱ doj vaa rihaan soꞌ a̱ maꞌ. Canó rasu̱u̱n caꞌve̱e quiꞌya̱j soꞌ na̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ga̱a ne̱ guun cheꞌe̱ Pedró cataj Pedró: ―A̱j tanáj núj nu̱ꞌ siꞌyaj núj, ne̱ canocoꞌ núj mán so̱ꞌ á ―taj Pedró rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ga̱a ne̱ cataj Jesucristó: ―Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan nij soj se vaa síí tanáj veꞌ tucuá tanáj tinúú tanáj raꞌvij tanáj nii tanáj rej tanáj taꞌníí tanáj toꞌóó tanáj cheꞌé se me rá soꞌ canoco̱ꞌ soꞌ manj ne̱ nata̱ꞌ soꞌ se‑na̱na̱j nana̱ sa̱ꞌ rihaan yuvii̱, ");
INSERT INTO trcNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ne̱ cientó doj a̱ rasu̱u̱n quiri̱ꞌ uún soꞌ ga̱a vaa iꞌna̱ꞌ soꞌ rihaan chumii̱ nihánj cuano̱ ado̱nj. Dan me se cuma̱n queꞌe̱e̱ veꞌ tucuá soꞌ do̱ꞌ, tinúú soꞌ do̱ꞌ, raꞌvij soꞌ do̱ꞌ, nii soꞌ do̱ꞌ, taꞌníí soꞌ do̱ꞌ, toꞌóó soꞌ do̱ꞌ, rihaan soꞌ ga̱a vaa iꞌna̱ꞌ soꞌ rihaan chumii̱ nihánj, tza̱j ne̱ vaa sayuun quira̱nꞌ soꞌ cheꞌé ꞌu̱nj ado̱nj. Ne̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj me se yoꞌo̱ ca̱yáán soꞌ ga̱ Diose̱ nu̱ꞌ cavii nu̱ꞌ caꞌanj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tza̱j ne̱ queꞌe̱e̱ nij síí guun chij ndoꞌo rihaan chumii̱ nihánj roꞌ, gu̱un nij soꞌ síí noco̱ꞌ ei. Ne̱ queꞌe̱e̱ nij síí ne gu̱un chij rihaan chumii̱ nihánj me se gu̱un chij nij soꞌ, quiꞌya̱j Diose̱ na̱nj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Dan me se va̱j nij soꞌ chrej avii nij soꞌ chumanꞌ Jerusalén, ne̱ táá ya̱a̱n Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ maꞌanj ndoꞌo rá nij soꞌ, ne̱ nij síí noco̱ꞌ xcó nij soꞌ me se cuchuꞌviꞌ ndoꞌo nij soꞌ a. Dan me se narii Jesucristó man chuvi̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ guun cheꞌe̱ soꞌ cataj xnaꞌanj soꞌ rihaan nij soꞌ da̱j quira̱nꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Dan me se cataj Jesucristó rihaan nij soꞌ, ne̱: ―Nihánj me caꞌanj níꞌ chumanꞌ Jerusalén, ne̱ qui̱taꞌaa nii manj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱, ne̱ nago̱ꞌ nii manj rihaan nij xrej ata̱ suun noco̱o doj do̱ꞌ, rihaan nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ a. Ne̱ cuta̱ꞌ nij soꞌ cacunꞌ xráj, ne̱ cata̱j nij soꞌ se vaa cavi̱ꞌ ꞌu̱nj a. Ga̱a ne̱ nago̱ꞌ nij soꞌ manj rihaan nij síí yaníj, ");
INSERT INTO trcNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ne̱ caꞌnga̱ꞌ naco̱o̱ nij síí yaníj queneꞌe̱n nij soꞌ manj, ne̱ quiri̱i̱ talúj nij soꞌ rihanj, ne̱ go̱ꞌ nij soꞌ cuartá xráj, ne̱ ticavi̱ꞌ nij soꞌ manj a. Ga̱a ne̱ cache̱n vaꞌnu̱j güii, ga̱a ne̱ cunu̱u iꞌna̱ꞌ uún ꞌu̱nj, quiꞌya̱j Diose̱ ei ―taj Jesucristó rihaan chuvi̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ga̱a ne̱ cuchiꞌ síí cuꞌna̱j Jacobo do̱ꞌ, síí cuꞌna̱j Juan do̱ꞌ, rihaan Jesucristó, ne̱ taꞌníí síí cuꞌna̱j Zebedeo me ro̱j soꞌ a. Ga̱a ne̱ cataj ro̱j soꞌ rihaan Jesucristó a: ―Me rá rój se vaa qui̱ꞌyáá so̱ꞌ nda̱a vaa cachi̱nj niꞌya̱j rój rihaan so̱ꞌ cheꞌé rój, maestro ―taj ro̱j soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ga̱a ne̱ cataj Jesucristó rihaan ro̱j soꞌ a: ―Da̱j qui̱ꞌyáj cheꞌé ro̱j so̱j, rá ro̱j so̱j ga̱ ―taj soꞌ, xnáꞌanj soꞌ man ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ga̱a ne̱ cataj ro̱j soꞌ rihaan Jesucristó a: ―Cata̱j xnaꞌanj so̱ꞌ se vaa asa̱ꞌ guun chij so̱ꞌ rihaan chumii̱ nihánj, ne̱ quita̱j rój xꞌnúú so̱ꞌ, ne̱ ca̱ta̱ rój suun sa̱ꞌ doj, qui̱ꞌyáá so̱ꞌ á. Dan me se yoꞌo̱ rój ca̱yáán rej nuva̱ꞌ so̱ꞌ, ne̱ yoꞌó rój ca̱yáán rej ni̱chruún so̱ꞌ, ne̱ quiri̱i̱ taꞌngaꞌ rój ga̱ so̱ꞌ, cata̱j so̱ꞌ, rá rój a ―taj ro̱j síí cuꞌna̱j Jacobo ga̱ Juan rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ga̱a ne̱ cataj Jesucristó rihaan ro̱j tinu̱j ro̱j soꞌ a: ―Ne neꞌen ro̱j so̱j me rasu̱u̱n cachíín niꞌya̱j ro̱j so̱j rihanj nihánj a̱ maꞌ. ꞌO̱ se gu̱un nucua̱j ro̱j so̱j quira̱nꞌ ro̱j so̱j sayuun nda̱a vaa qui̱ránꞌ ꞌu̱nj naꞌ ―taj Jesucristó, xnáꞌanj Jesucristó man ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","―Gu̱un nucua̱j rój ei ―taj ro̱j soꞌ a. Ga̱a ne̱ cataj Jesucristó rihaan ro̱j soꞌ a: ―Ya̱ ya̱ quira̱nꞌ ro̱j so̱j sayuun ga̱j na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tza̱j ne̱ ne nó xcúnj cata̱j xnaꞌanj ꞌu̱nj me síí ca̱yáán xꞌnúú ꞌu̱nj rej nuva̱ꞌ ꞌu̱nj do̱ꞌ, rej ni̱chrunj do̱ꞌ, maꞌ. O̱rúnꞌ Diose̱ me síí cata̱j xnaꞌanj me síí quiri̱i̱ taꞌngaꞌ ga̱j na̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ga̱a ne̱ cuno yoꞌó chi̱ꞌ nij síí tucuꞌyón se‑na̱na̱ Jesucristó se vaa caꞌmii ro̱j síí cuꞌna̱j Jacobo ga̱ Juan rihaan Jesucristó, ga̱a ne̱ guun cheꞌe̱ nij soꞌ caꞌmaan rá nij soꞌ niꞌya̱j nij soꞌ man ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ga̱a ne̱ canacúún Jesucristó man cunuda̱nj nij soꞌ se vaa caꞌna̱ꞌ nij soꞌ rihaan soꞌ a. Ne̱ cataj soꞌ: ―Neꞌen soj se vaa nij síí ata̱ suun ma̱n rihaan chumii̱ nihánj me se rii taꞌngaꞌ uxrá nij soꞌ rihaan tuviꞌ nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tza̱j ne̱ se̱ gaa da̱nj se a nu̱j níꞌ quiꞌya̱j níꞌ maꞌ. ꞌO̱ se sese me rá níꞌ gu̱un chij níꞌ rihaan tuviꞌ níꞌ, ne̱ gu̱un níꞌ síí quiꞌya̱j suun rihaan taranꞌ tuviꞌ níꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ne̱ ase vaa mozó roꞌ, da̱nj ga̱a̱ xa̱ꞌ níꞌ rihaan tuviꞌ níꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Dan me se caꞌnéé Diose̱ manj ni̱caj yuꞌunj ꞌu̱nj man yuvii̱, tza̱j ne̱ ne caꞌna̱ꞌ ꞌu̱nj ne̱ gu̱un nij yuvii̱ mozó rihanj maꞌ. ꞌO̱ se caꞌnáꞌ ꞌu̱nj quiꞌya̱j suun ma̱ꞌanj rihaan nij yuvii̱ na̱nj ado̱nj. Ne̱ caꞌnáꞌ ꞌu̱nj nayo̱n ma̱ꞌanj rihaan yuvii̱ ne̱ cavi̱ꞌ ꞌu̱nj cheꞌé cacunꞌ ata̱ nij soꞌ, ga̱a ne̱ cavi̱i̱ sa̱ꞌ uxrá nij soꞌ, qui̱ꞌyáj na̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ga̱a ne̱ catúj nij soꞌ chumanꞌ Jericó a. Ga̱a ne̱ curiha̱nj Jesucristó do̱ꞌ, nij síí tucuꞌyón se‑na̱na̱ soꞌ do̱ꞌ, queꞌe̱e̱ yuvii̱ do̱ꞌ, chumanꞌ Jericó, ne̱ dan me se yáán ꞌo̱ síí tuchri̱i cuꞌna̱j Bartimeo tuꞌva chrej, ne̱ taꞌníí síí cuꞌna̱j Timeo me soꞌ, ne̱ síí achíín caridad me soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ga̱a ne̱ xcaj soꞌ cuentá se vaa Jesucristó síí cavii chumanꞌ Nazaret me síí cache̱n rej ne̱ soꞌ, ne̱ cheꞌé dan guun cheꞌe̱ soꞌ caguáj soꞌ, ne̱ cataj soꞌ: ―Ya̱ ya̱ taꞌníí taꞌnij siꞌno̱ síí cuꞌna̱j David síí cane ga̱a naá mé so̱ꞌ, Jesús. Cunu̱u ꞌe̱e̱ rá so̱ꞌ manj ei ―taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tza̱j ne̱: ―Dínj tuꞌvá so̱ꞌ á ―taj queꞌe̱e̱ nij yuvii̱ rihaan soꞌ a. Tza̱j ne̱ doj a̱ nucua̱j caguáj soꞌ, cataj soꞌ: ―Taꞌníí taꞌnij siꞌno̱ síí cuꞌna̱j David síí cane ga̱a naá ei. Cunu̱u ꞌe̱e̱ rá so̱ꞌ manj ei ―taj uún soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ga̱a ne̱ canicunꞌ Jesucristó, ne̱ caꞌneꞌ Jesucristó suun rihaan nij síí nicu̱nꞌ ga̱ soꞌ se vaa caꞌa̱nj naca̱j nij soꞌ man síí tuchri̱i yoꞌ ne̱ caꞌna̱ꞌ soꞌ rihaan Jesucristó a. Ga̱a ne̱ caꞌanj canacu̱nj nij soꞌ man síí tuchri̱i, ne̱ cataj nij soꞌ: ―Yoꞌo̱ caꞌne̱j nucuaj nimán so̱ꞌ ei. Nacúún soꞌ mán so̱ꞌ, ne̱ na̱xuma̱a̱n so̱ꞌ, caꞌa̱nj níꞌ á ―taj nij soꞌ rihaan síí tuchri̱i cuꞌna̱j Bartimeo a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ga̱a ne̱ tanáj soꞌ yatzíj ta̱j xráá soꞌ, ne̱ güéj soꞌ, ne̱ caꞌnaꞌ soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ga̱a ne̱ xnáꞌanj Jesucristó man soꞌ, cataj Jesucristó: ―Da̱j qui̱ꞌyáj mán so̱ꞌ, rá so̱ꞌ ga̱ ―taj Jesucristó a. Ne̱: ―Cunu̱u sa̱ꞌ rihanj, raj, maestro ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Caꞌve̱e caꞌa̱nj so̱ꞌ á. Ma̱a̱n cheꞌé se amán rá so̱ꞌ niꞌya̱j so̱ꞌ manj roꞌ, cheꞌé dan cunuu sa̱ꞌ rihaan so̱ꞌ ei ―taj Jesucristó rihaan soꞌ a. Nu̱ꞌ caꞌmii Jesucristó da̱nj, ne̱ nu̱ꞌ curuviꞌ rihaan síí tuchri̱i yoꞌ, ne̱ caꞌanj soꞌ ga̱ Jesucristó chrej va̱j Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ga̱a ne̱ quinichrunꞌ Jesucristó ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ ro̱j chumanꞌ cuꞌna̱j Betfagé ga̱ Betania, ne̱ ro̱j chumanꞌ yoꞌ roꞌ, naj nichru̱nꞌ tuꞌva chumanꞌ Jerusalén, ne̱ tacóó quij cuꞌna̱j Quij ma̱n Chruun Olivó naj ro̱j chumanꞌ yoꞌ a. Ga̱a ne̱ caꞌnéé Jesucristó man vi̱j tuviꞌ nij síí tucuꞌyón se‑na̱na̱ soꞌ caꞌa̱nj rque chumanꞌ Betfagé yoꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ne̱ cataj soꞌ rihaan ro̱j soꞌ a: ―Cavi̱i̱ ro̱j so̱j caꞌa̱nj soj, ne̱ catu̱u̱ ro̱j so̱j chumanꞌ nihánj chumanꞌ na̱j rihaan níꞌ, ne̱ nu̱ꞌ catúj ro̱j so̱j, ne̱ nu̱ꞌ nari̱ꞌ ro̱j so̱j man yoꞌo̱ burró leꞌe̱j yaꞌa̱nj numi̱i a. Dan me se nache̱ ro̱j so̱j man xoꞌ, ne̱ ni̱caj ro̱j so̱j caꞌna̱ꞌ ro̱j so̱j rihanj nihánj á. ");
INSERT INTO trcNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ne̱ sese xna̱ꞌanj nii man ro̱j so̱j me cheꞌé ꞌyaj ro̱j so̱j da̱nj ga̱ burró, ne̱ cata̱j ro̱j so̱j: “Síí ꞌni̱j raꞌa man níꞌ achiin xcuu nihánj rihaan chugua̱nj. Ne̱ nu̱ꞌ navij suun rihaan burró nihánj, ne̱ nu̱ꞌ caꞌne̱j uún soꞌ man núj caꞌna̱ꞌ ta̱náj uún núj man burró nihánj ei”, cata̱j ro̱j so̱j á ―taj Jesucristó rihaan ro̱j síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Dan me se caꞌanj ro̱j soꞌ, ne̱ catúj ro̱j soꞌ chumanꞌ, ne̱ nariꞌ ro̱j soꞌ man burró leꞌe̱j, ne̱ nicu̱nꞌ xoꞌ rá ꞌo̱ callé rihaan taꞌyaa, ne̱ numi̱i xoꞌ a. Dan me se nache ro̱j soꞌ man xoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ne̱ nicu̱nꞌ do̱j nij yuvii̱ rej yoꞌ, ne̱ xnáꞌanj nij soꞌ man ro̱j soꞌ, ne̱ cataj nij soꞌ: ―Me cheꞌé nache ro̱j so̱j burró ga̱ ―taj nij síí nicu̱nꞌ rej yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ne̱ caꞌmii ro̱j síí tucuꞌyón se‑na̱na̱ Jesucristó nda̱a vaa caꞌneꞌ Jesucristó suun rihaan ro̱j soꞌ, ga̱a ne̱ caꞌvej rá nij síí nicu̱nꞌ rej yoꞌ ni̱caj ro̱j soꞌ burró caꞌna̱ꞌ ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Dan me se nica̱j ro̱j soꞌ burró caꞌnaꞌ uún ro̱j soꞌ rej nicu̱nꞌ Jesucristó, ne̱ cutaꞌ ro̱j soꞌ saga̱nꞌ ro̱j soꞌ xráá burró, ne̱ cavii Jesucristó xráá burró yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Dan me se uchruj ndoꞌo nij yuvii̱ yatzíj saga̱nꞌ nij soꞌ rá chrej, ne̱ achén Jesucristó ga̱ burró yoꞌ rihaan yatzíj a. Ne̱ yoꞌó taꞌa̱j nij yuvii̱ roꞌ, aꞌneꞌ nij soꞌ rcoj raꞌa chruun do̱ꞌ, coj ma̱n tacaan do̱ꞌ, uchruj nij soꞌ rá chrej, ne̱ achén Jesucristó ga̱ burró leꞌe̱j a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ne̱ va̱j yuvii̱ ta̱j ya̱a̱n rihaan Jesucristó, ne̱ ꞌnaꞌ yuvii̱ noco̱ꞌ rej xco̱ Jesucristó, ne̱ caguáj nij yuvii̱, cataj nij yuvii̱: ―Cara̱a̱ gue̱e̱ níꞌ rihaan Diose̱ ei. ꞌNaꞌ síí caꞌnéé síí ꞌni̱j raꞌa man níꞌ ei. Se lu̱j ndoꞌo me ꞌyaj Diose̱ cheꞌé níꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Cuna̱j uxrá vaa ꞌnaꞌ síí gu̱un chij nda̱a vaa guun chij xi̱i níꞌ síí cuꞌna̱j David ga̱a naá ei. Cara̱a̱ gue̱e̱ níꞌ rihaan Diose̱ síí nicu̱nꞌ xta̱ꞌ ei ―taj nij yuvii̱ yoꞌ, caguáj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ga̱a ne̱ catúj taranꞌ nij soꞌ rihaan nuvií noco̱o ne̱ chumanꞌ Jerusalén, ne̱ niꞌya̱j Jesucristó man cunuda̱nj nij rasu̱u̱n ma̱n anica̱j rihaan nuvií noco̱o, ne̱ ma̱a̱n cheꞌé se nichru̱nꞌ gu̱un rmi̱ꞌ, ne̱ cheꞌé dan curiha̱nj uún Jesucristó ga̱ chuvi̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ nanica̱j soꞌ caꞌanj soꞌ chumanꞌ Betania a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ne̱ yoꞌó güii me se curiha̱nj uún nij soꞌ chumanꞌ Betania, ne̱ naꞌaan rque Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ga̱a ne̱ ga̱nꞌ nicunꞌ ꞌo̱ chruun ma̱n chruj higó queneꞌen Jesucristó, ne̱ ta̱j coj raa̱ chruun yoꞌ a. Ne̱ cuchiꞌ soꞌ tacóó chruun, ne̱ niꞌya̱j soꞌ, ne̱ taj va̱j a̱ doj chruj ma̱n raa̱ chruun a. Ma̱a̱n na̱nj coj u̱u̱n táá raa̱ chruun yoꞌ a. ꞌO̱ se nuveé tio̱ ma̱n chruj higó me yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ga̱a ne̱ cataj Jesucristó rihaan chruun a: ―Daj chiha̱a̱ míj se̱ cumán chruj raá so̱ꞌ cha̱ yuvii̱ a̱ maꞌ ―taj soꞌ rihaan chruun ma̱n chruj higó yoꞌ a. Ne̱ cuno nij síí tucuꞌyón se‑na̱na̱ soꞌ se vaa caꞌmii soꞌ da̱nj rihaan chruun yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ga̱a ne̱ catúj Jesucristó ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ chumanꞌ Jerusalén, ga̱a ne̱ catúj Jesucristó rá nuvií noco̱o, ga̱a ne̱ guun cheꞌe̱ soꞌ quirii soꞌ man nu̱ꞌ nij síí tuꞌvéj rasu̱u̱n do̱ꞌ, man nij síí quiránj rasu̱u̱n ma̱n rá nuvií noco̱o do̱ꞌ a. Ne̱ tiguíj raꞌa soꞌ nij chruun mesá natuná nii saꞌanj rihaan, ne̱ tiguíj raꞌa soꞌ chruun xlá ta̱j nij síí tuꞌvéj chaꞌaa̱n a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ne̱ caráán soꞌ chrej se̱ cata̱ nij yuvii̱ rasu̱u̱n ꞌe̱e̱ cache̱n nij soꞌ rque nuvií a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ga̱a ne̱ tucuꞌyón soꞌ man nij síí ma̱n rihaan nuvií, ne̱ cataj soꞌ: ―Ya̱ uxrá danj Diose̱ taj se vaa tucuá Diose̱ rej naꞌvíj nda̱a nij yuvii̱ yaníj rihaan Diose̱ me nihánj á. Tza̱j ne̱ guun tucua̱ síí itu̱u̱ man tucuá Diose̱ nihánj, quiꞌyaj soj na̱nj á ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ne̱ cuno nij xrej do̱ꞌ, nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ, se‑na̱na̱ Jesucristó, ga̱a ne̱ nanoꞌ uxrá nij soꞌ da̱j quiꞌya̱j nij soꞌ ne̱ caꞌve̱e cavi̱ꞌ Jesucristó a. ꞌO̱ se chuꞌviꞌ nij soꞌ niꞌya̱j nij soꞌ man Jesucristó, cheꞌé se caꞌanj ndoꞌo rá cunuda̱nj nij yuvii̱ cuno nij yuvii̱ nana̱ tucuꞌyón Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tza̱j ne̱ caꞌanj güii, ne̱ nichru̱nꞌ gu̱un rmi̱ꞌ, ne̱ curiha̱nj uún Jesucristó ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ chumanꞌ Jerusalén caꞌanj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ga̱a ne̱ rej naꞌya̱a̱n yoꞌó güii me se va̱j Jesucristó ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ chrej, ne̱ cachén nij soꞌ rej nicu̱nꞌ chruun higó caꞌmii Jesucristó rihaan ga̱a güii quii, ne̱ dan me se yoꞌo̱ nacoo̱ nda̱a yáá nu̱ꞌ chruun yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Dan me se nanuj rá síí cuꞌna̱j Pedró da̱j caꞌmii Jesucristó rihaan chruun yoꞌ, ne̱ cheꞌé dan cataj soꞌ rihaan Jesucristó a: ―Ni̱ꞌyaj so̱ꞌ, maestro. Nacoo̱ nu̱ꞌ chruun caꞌmii chreé so̱ꞌ rihaan ga̱a quii na̱nj á ―taj Pedró rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ga̱a ne̱ cataj Jesucristó rihaan taranꞌ nij soꞌ a: ");
INSERT INTO trcNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","―Cuchuma̱n rá soj ni̱ꞌyaj soj Diose̱ ei. Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa me maꞌa̱n ꞌo̱ síí cata̱j rihaan nda̱a quij xca̱a̱n yoꞌ se vaa cu̱riha̱nj quij rej nicu̱nꞌ quij ne̱ caꞌa̱nj ni̱j quij rque na yaꞌa̱nj, ne̱ sese se̱ guun vi̱j rá soꞌ ne̱ cuchuma̱n ya̱ rá soꞌ se vaa gu̱un nu̱ꞌ nda̱a vaa cataj soꞌ, ne̱ ya̱ gu̱un nda̱a vaa cataj soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Cheꞌé dan cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa nu̱ꞌ se vaa cachi̱nj niꞌya̱j soj rihaan Diose̱ roꞌ, sese cuchuma̱n rá soj se vaa a̱j quiꞌyaj Diose̱ da̱nj cheꞌé soj, ne̱ ya̱ ya̱ gu̱un nda̱a vaa cachíín niꞌya̱j soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ne̱ ga̱a nicu̱nꞌ soj achíín niꞌya̱j soj rihaan Diose̱, ne̱ sese vaa cacunꞌ quiꞌyaj yoꞌo̱ soꞌ rihaan soj, ne̱ cara̱a̱ xꞌnaa soj cheꞌé cacunꞌ tumé tuviꞌ soj, ga̱a ne̱ caꞌve̱e cara̱a̱ xꞌnaa Rej soj síí nicu̱nꞌ xta̱ꞌ ni̱ꞌyaj soꞌ cacunꞌ tumé maꞌa̱n soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tza̱j ne̱ sese se̱ caꞌvej rá soj cara̱a̱ xꞌnaa soj cheꞌé cacunꞌ quiꞌyaj tuviꞌ soj rihaan soj, ne̱ daj chiha̱a̱ míj se̱ tinavij Rej soj síí nicu̱nꞌ xta̱ꞌ cacunꞌ tumé maꞌa̱n soj a̱ maꞌ ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ga̱a ne̱ catúj uún Jesucristó ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ rque chumanꞌ Jerusalén, ga̱a ne̱ chéé Jesucristó rá nuvií noco̱o, ne̱ cuchiꞌ nij xrej ata̱ suun noco̱o doj do̱ꞌ, nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ, nij síí uun chij rihaan nij yuvii̱ do̱ꞌ, rihaan soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ga̱a ne̱ cataj nij soꞌ rihaan soꞌ a: ―Me síí caꞌneꞌ suun rihaan so̱ꞌ qui̱ꞌyáá so̱ꞌ nda̱a vaa ꞌyáá so̱ꞌ ga̱ ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Ne̱ vaa yoꞌo̱ nana̱ xna̱ꞌanj ꞌu̱nj man nij soj, ne̱ sese ya̱ cata̱j xnaꞌanj nij soj nana̱ yoꞌ rihanj, ne̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj me síí caꞌneꞌ suun rihanj a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Dan me se me síí caꞌneꞌ suun rihaan síí cuꞌna̱j Juan cuta̱ꞌ ne soꞌ man yuvii̱, rá soj ga̱. Maꞌa̱n Juan cavii raa̱ naꞌ. Ase Diose̱ cataj xnaꞌanj rihaan soꞌ xa̱ꞌ. Cata̱j xnaꞌanj nij soj rihanj á ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ga̱a ne̱ nuchruj ra̱a̱ ndoꞌo nij soꞌ ga̱ tuviꞌ nij soꞌ, ne̱ cataj nij soꞌ: ―Sese cata̱j níꞌ se vaa Diose̱ caꞌneꞌ suun rihaan síí cuꞌna̱j Juan cuta̱ꞌ ne soꞌ man yuvii̱, ne̱ cata̱j Jesucristó rihaan níꞌ me cheꞌé ne cuchuma̱n rá níꞌ nana̱ caꞌmii Juan, cata̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tza̱j ne̱ daj chiha̱a̱ míj se̱ caꞌvee cata̱j níꞌ se vaa maꞌa̱n Juan cavii raa̱ quiꞌya̱j da̱nj maꞌ ―taj nij soꞌ rihaan tuviꞌ nij soꞌ, cheꞌé se cuchuꞌviꞌ nij soꞌ niꞌya̱j nij soꞌ man nij yuvii̱ a. ꞌO̱ se nij yuvii̱ me se síí caꞌnéé Diose̱ nata̱ꞌ se‑na̱na̱ Diose̱ rihaan yuvii̱ me ya̱ síí cuꞌna̱j Juan, rá cunuda̱nj nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ga̱a ne̱ cataj nij soꞌ rihaan Jesucristó a: ―Ne neꞌen núj me síí caꞌneꞌ suun rihaan síí cuꞌna̱j Juan cuta̱ꞌ ne soꞌ man yuvii̱ maꞌ ―taj nij soꞌ a. ―Cheꞌé dan se̱ cataj xnaꞌanj ꞌu̱nj rihaan nij soj me síí caꞌneꞌ suun rihanj qui̱ꞌyáj nda̱a vaa ꞌyáj maꞌ ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ga̱a ne̱ guun cheꞌe̱ Jesucristó nanó soꞌ cuentó rihaan nij soꞌ a: ―Dan me se cuchruj yoꞌo̱ soꞌ naa̱ chruj uvá, ne̱ quiꞌyaj soꞌ chingá nu̱ꞌ anica̱j tuꞌva naa̱ yoꞌ, ga̱a ne̱ gáán soꞌ yuꞌuj rej xtu̱nꞌ chruj uvá ne̱ cavi̱i̱ na, ne̱ cuneꞌ soꞌ ꞌo̱ veꞌ nataꞌ ca̱yáán nij síí cu̱tumé naa̱ yoꞌ a. Ga̱a ne̱ tanáj soꞌ naa̱ yoꞌ rihaan síí quiꞌya̱j suun naa̱ yoꞌ, ne̱ curiha̱nj soꞌ caꞌanj soꞌ ga̱nꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Cachén do̱j yavii, ne̱ quisíj yavii cuta̱ nii chruj uvá, ne̱ caꞌnéé síí xna̱a̱ yoꞌ man yoꞌo̱ se‑mo̱zó soꞌ rihaan nij síí nu̱u̱ tumé xnaa̱ soꞌ a. Me rá soꞌ caꞌna̱ꞌ ni̱caj se‑mo̱zó soꞌ do̱j chruj uvá rihaan maꞌa̱n soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ga̱a ne̱ quitaꞌaa nij síí nu̱u̱ tumé naa̱ man se‑mo̱zó síí xna̱a̱, ne̱ goꞌ uxrá nij soꞌ chruun xráá soꞌ, ne̱ caꞌnéé nij soꞌ man soꞌ rihaan síí xna̱a̱ a. Tza̱j ne̱ a̱ doj chruj uvá ne ni̱caj soꞌ caꞌanj soꞌ, quiꞌyaj nij soꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ga̱a ne̱ caꞌnéé síí xna̱a̱ man yoꞌó mozó rihaan nij síí nu̱u̱ tumé xnaa̱ soꞌ uún a. Tza̱j ne̱ goꞌ nij soꞌ raa̱ soꞌ, ne̱ quiꞌyaj chiꞌi̱i̱ nij soꞌ man soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ga̱a ne̱ caꞌnéé síí xna̱a̱ yoꞌó mozó uún, ne̱ ticaviꞌ nij síí nu̱u̱ tumé naa̱ man soꞌ, ne̱ queꞌe̱e̱ doj mozó caꞌnéé uún síí xna̱a̱, ne̱ taꞌa̱j nij soꞌ goꞌ nij síí nu̱u̱ tumé naa̱ xráá, ne̱ yoꞌó taꞌa̱j nij soꞌ ticaviꞌ nij síí nu̱u̱ tumé naa̱, ");
INSERT INTO trcNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ne̱ da̱j o̱rúnꞌ soꞌ quináj, ne̱ síí quináj me taꞌníí síí xna̱a̱, ne̱ ꞌe̱e̱ ndoꞌo rá síí xna̱a̱ man taꞌníí soꞌ a. Tza̱j ne̱ caꞌnéé síí xna̱a̱ yoꞌ man taꞌníí soꞌ rihaan nij síí tumé xnaa̱ soꞌ a. “Cara̱a̱ cochro̱j nij síí tumé naa̱ rihaan taꞌníj sese caꞌa̱nj taꞌníj saj xe̱e̱”, taj síí xna̱a̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","”Tza̱j ne̱ cataj nij síí tumé naa̱ rihaan tuviꞌ nij soꞌ: “Síí nihánj me síí gu̱un xna̱a̱ naa̱ nihánj vaa güii ei. Cheꞌé dan ticavi̱ꞌ níꞌ man soꞌ, ne̱ vaa güii, ne̱ gu̱un xna̱a̱ maꞌa̱n níꞌ man naa̱ nihánj chugua̱nj”, taj nij soꞌ niꞌya̱j nij soꞌ man taꞌníí síí xna̱a̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ga̱a ne̱ quitaꞌaa nij soꞌ man taꞌníí síí xna̱a̱ yoꞌ, ne̱ ticaviꞌ nij soꞌ man soꞌ, ne̱ quiriꞌíj nij soꞌ man soꞌ xeꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","”Ne̱ da̱j quiꞌya̱j síí xna̱a̱ man nij síí tumé xnaa̱ soꞌ, rá soj ga̱. Dan me se caꞌna̱ꞌ soꞌ, ne̱ ticavi̱ꞌ soꞌ man nij soꞌ, ne̱ tu̱cuachén soꞌ xnaa̱ soꞌ rihaan yoꞌó síí tu̱mé xnaa̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ne̱ me cheꞌé ne naya̱a̱ nij soj nana̱ nihánj nana̱ no̱ rihaan danj Diose̱ ga̱: “Yuvej quiriꞌíj nij síí cuneꞌ veꞌ roꞌ, guun yuvej sa̱ꞌ doj rihaan cunuda̱nj nij yuvej ma̱n tacóó veꞌ yoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Maꞌa̱n síí ꞌni̱j raꞌa man níꞌ quiꞌyaj yoꞌ, ne̱ cuna̱j uxrá vaa yoꞌ, rá níꞌ á”, taj danj Diose̱ a ―taj Jesucristó rihaan nij síí uun chij rihaan nij yuvii̱ israelitá a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ga̱a ne̱ nanó rá nij soꞌ da̱j ga̱a̱ qui̱taꞌaa nij soꞌ man Jesucristó, tza̱j ne̱ cuchuꞌviꞌ nij soꞌ niꞌya̱j nij soꞌ man nij yuvii̱ a. Ése̱ cheꞌe̱ maꞌa̱n nij soꞌ me cuentó nanó Jesucristó a. Ase vaa nij síí nu̱u̱ tumé naa̱ vaa maꞌa̱n nij soꞌ niꞌya̱j Jesucristó, ne̱ queneꞌen nij soꞌ se vaa cheꞌé dan nanó Jesucristó cuentó yoꞌ a. Ga̱a ne̱ tanáj nij soꞌ man Jesucristó, ne̱ caꞌanj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ga̱a ne̱ caꞌnéé nij síí uun chij yoꞌ do̱j síí fariseo do̱ꞌ, do̱j síí noco̱ꞌ man síí cuꞌna̱j Herodes do̱ꞌ, rihaan Jesucristó, cheꞌé rej cuta̱ꞌ nij soꞌ cacunꞌ xráá Jesucristó cheꞌé nana̱ caꞌmi̱i̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Dan me se cuchiꞌ nij síí tihaꞌ yuꞌunj yoꞌ rihaan Jesucristó, ne̱ cataj nij soꞌ rihaan soꞌ a: ―Neꞌen núj se vaa nana̱ ya̱ ina̱nj aꞌmii so̱ꞌ, maestro. Ne̱ ne chuꞌvíꞌ so̱ꞌ niꞌya̱j so̱ꞌ man nij yuvii̱ da̱j cata̱j nij yuvii̱ maꞌ. Ne̱ ꞌo̱ cuya̱a̱n vaa nu̱ꞌ yuvii̱ rihaan so̱ꞌ chugua̱nj. Ma̱a̱n se ya̱ tucuꞌyón so̱ꞌ rihaan yuvii̱ da̱j quiꞌya̱j yuvii̱ canoco̱ꞌ yuvii̱ man Diose̱ ado̱nj. Ne̱ no̱ xcúún yuvii̱ go̱ꞌ yuvii̱ puextó rihaan síí nica̱j suun gobiernó naꞌ. Ase se̱ goꞌ yuvii̱ xa̱ꞌ. Dan me se go̱ꞌ núj naꞌ. Se̱ goꞌ núj xa̱ꞌ ―taj nij soꞌ, xnáꞌanj nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Dan me se a̱j neꞌen Jesucristó se vaa síí nucuiꞌ rá me nij síí xnáꞌanj nana̱ yoꞌ man soꞌ, ne̱ cheꞌé dan cataj soꞌ rihaan nij soꞌ a: ―Me cheꞌé me rá soj tiha̱ꞌ yuꞌunj soj manj ne̱ cuta̱ꞌ soj cacunꞌ xráj ga̱. Ti̱haa̱n soj ꞌo̱ saꞌanj aga̱ꞌ rihanj ni̱ꞌyaj á ―taj Jesucristó rihaan nij síí me rá tiha̱ꞌ yuꞌunj man soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ne̱ tihaa̱n nij soꞌ ꞌo̱ saꞌanj aga̱ꞌ rihaan soꞌ, ne̱ xnáꞌanj soꞌ man nij soꞌ, cataj soꞌ: ―Me síí nó rihaan saꞌanj aga̱ꞌ nihánj ga̱. Ne̱ me síí se‑chuvi̱i nó rihaan saꞌanj aga̱ꞌ nihánj ga̱ ―taj Jesucristó, xnáꞌanj soꞌ man nij síí me rá tiha̱ꞌ yuꞌunj yoꞌ a. ―Síí nica̱j suun gobiernó me nó rihaan saꞌanj aga̱ꞌ yoꞌ, ne̱ nó se‑chuvi̱i soꞌ rihaan saꞌanj ei ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ga̱a ne̱ cataj Jesucristó: ―Go̱ꞌ soj siꞌyaj síí nica̱j suun rihaan maꞌa̱n soꞌ, ne̱ rque̱ soj siꞌyaj Diose̱ rihaan Diose̱ á ―taj Jesucristó a. Ga̱a ne̱ caꞌanj ndoꞌo rá nij síí me rá tiha̱ꞌ yuꞌunj yoꞌ niꞌya̱j nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ga̱a ne̱ cuchiꞌ do̱j síí saduceo rihaan Jesucristó a. Nij síí saduceo roꞌ, aꞌmii nana̱ nihánj se vaa daj chiha̱a̱ míj se̱ cunuu iꞌna̱ꞌ uún yuvii̱ asa̱ꞌ caviꞌ yuvii̱, taj nij soꞌ a. Dan me se xnáꞌanj nij soꞌ man Jesucristó, ne̱ cataj nij soꞌ nana̱ nihánj a: ");
INSERT INTO trcNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Cachrón síí cuꞌna̱j Moisés nana̱ nihánj rihaan yanj cuno̱ níꞌ a: “Sese caviꞌ yoꞌo̱ soꞌ, ne̱ sese quináj u̱u̱n nica̱ soꞌ, ne̱ sese taj va̱j taꞌníí soꞌ, ne̱ no̱ xcúún tinúú soꞌ xca̱j tinúú soꞌ man choco̱ꞌ soꞌ chana̱ quináj, ne̱ coto̱j tinúú síí caviꞌ ga̱ choco̱ꞌ soꞌ, ne̱ cuchru̱j noꞌ neꞌej, ne̱ gu̱un taꞌni̱j síí caviꞌ man neꞌej yoꞌ ne̱ cu̱nuû neꞌej yoꞌ rihaan toꞌóó síí caviꞌ yoꞌ a”, me nana̱ cachrón síí cuꞌna̱j Moisés rihaan yanj ga̱a naá, maestro. ");
INSERT INTO trcNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Dan me se vaa chi̱j nij tinu̱j ꞌo̱ nij soꞌ, ne̱ síí chava̱ꞌ me se xcaj soꞌ chana̱, ga̱a ne̱ caviꞌ soꞌ, ne̱ taj va̱j neꞌej cuchruj chana̱ nica̱ soꞌ, quiꞌyaj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ga̱a ne̱ xcaj scueꞌe̱e̱ síí caviꞌ man choco̱ꞌ soꞌ chana̱ caviꞌ nica̱, ga̱a ne̱ caviꞌ soꞌ uún, ne̱ taj va̱j neꞌej cuchruj chana̱ yoꞌ, quiꞌyaj soꞌ, ne̱ veé da̱nj xcaj scueꞌe̱e̱ soꞌ uún man chana̱, ne̱ soꞌ caviꞌ uún, ne̱ veé da̱nj quiꞌyaj cunuda̱nj chi̱j nij tinu̱j nij soꞌ, ne̱ xcaj cunuda̱nj nij soꞌ man o̱rúnꞌ chana̱ yoꞌ, tza̱j ne̱ caviꞌ cunuda̱nj nij soꞌ, ne̱ taj va̱j a̱ ꞌó neꞌej cuchruj chana̱ yoꞌ a̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nda̱a síj, ga̱a ne̱ caviꞌ maꞌa̱n chana̱ uún, ");
INSERT INTO trcNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ne̱ dan me se asa̱ꞌ cunuu iꞌna̱ꞌ uún nij síí caviꞌ, ga̱a ne̱ me tuviꞌ nij soꞌ ni̱caj man chana̱ yoꞌ, rá so̱ꞌ ga̱. ꞌO̱ se ga̱a vaa iꞌna̱ꞌ nij soꞌ, ne̱ nica̱ taranꞌ nij tinu̱j nij soꞌ guun o̱rúnꞌ noꞌ a ―taj nij síí saduceo, xnáꞌanj nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Ne neꞌen uxrá soj maꞌ. ꞌO̱ se ne neꞌen soj me taj danj Diose̱, ne̱ ne neꞌen soj sese nucua̱j ndoꞌo Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ꞌO̱ se asa̱ꞌ cunuu iꞌna̱ꞌ uún nij síí caviꞌ, ne̱ se̱ xcaj tuviꞌ nij soꞌ a̱ maꞌ. ꞌO̱ se ase vaa yáán nij se‑mo̱zó Diose̱ rej xta̱ꞌ roꞌ, da̱nj ga̱a̱ ca̱yáán nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ga̱a ne̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj da̱j ga̱a̱ queneꞌe̱n soj se vaa ya̱ ya̱ cunu̱u iꞌna̱ꞌ uún yuvii̱ asa̱ꞌ caviꞌ yuvii̱ ei. Ataa naya̱a̱ soj nana̱ nihánj nana̱ no̱ rihaan danj Moisés nana̱ cheꞌé coj acoꞌ yaꞌan raa̱ naꞌ. Ne̱ dan me se ga̱a queneꞌen Moisés coj yoꞌ, ne̱ cataj Diose̱ rihaan Moisés: “Diose̱ síí noco̱ꞌ nij síí ma̱n ga̱a naá síí cuꞌna̱j Abraham do̱ꞌ, síí cuꞌna̱j Isaac do̱ꞌ, síí cuꞌna̱j Jacobo do̱ꞌ, mej a”. Da̱nj cataj Diose̱ cheꞌé nij síí ma̱n ga̱a naá yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dan me se nuveé se‑Dio̱se̱ nij xnangá me Diose̱ maꞌ. Ina̱nj nij síí vaa iꞌna̱ꞌ aꞌvee noco̱ꞌ man Diose̱ na̱nj ado̱nj. Cheꞌé dan, nda̱ꞌ se síí cane ga̱a naá me vaꞌnu̱j nij soꞌ, tza̱j ne̱ vaa iꞌna̱ꞌ nij soꞌ rihaan Diose̱ na̱nj ei. Ne neꞌen uxrá soj a̱ maꞌ ―taj Jesucristó rihaan nij síí saduceo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ga̱a ne̱ yoꞌo̱ nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés cuchiꞌ rihaan Jesucristó, ne̱ soꞌ roꞌ, me síí cuno da̱j caꞌmii Jesucristó ga̱ nij síí saduceo yoꞌ, ne̱ queneꞌen soꞌ se vaa sa̱ꞌ uxrá caꞌmii Jesucristó, ne̱ cheꞌé dan xnáꞌanj soꞌ man Jesucristó, ne̱ cataj soꞌ: ―Me nana̱ me nana̱ noco̱o doj rihaan cunuda̱nj nij nana̱ cataj xnaꞌanj Diose̱ rihaan níꞌ cuno̱ níꞌ ga̱ ―taj soꞌ, xnáꞌanj soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Nana̱ noco̱o doj rihaan cunuda̱nj nij nana̱ cuno̱ níꞌ me nana̱ nihánj, ne̱: “Cuno̱ soj si̱j israelitá, ne̱ Diose̱ síí ꞌni̱j raꞌa man níꞌ me se o̱ruun soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ne̱ nda̱a nimán yá so̱ꞌ gu̱un rá so̱ꞌ ni̱ꞌyaj so̱ꞌ man Diose̱ síí ꞌni̱j raꞌa man níꞌ, ne̱ yoꞌo̱ nda̱a cúú yave̱ yá so̱ꞌ cuchuma̱n ya̱ rá ni̱ꞌyaj man Diose̱, ne̱ nda̱a nu̱ꞌ se nucua̱j yá so̱ꞌ cara̱a̱ cochro̱j rihaan Diose̱ na̱nj ado̱nj”. Ne̱ nihánj me ya̱ nana̱ uun chij ya̱ na̱nj ei. ");
INSERT INTO trcNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ne̱ vaa yoꞌó nana̱ nihánj nana̱ me rá Diose̱ cuno̱ uún níꞌ a: “Adi̱ꞌ se ꞌe̱e̱ rá so̱ꞌ man ma̱ꞌán so̱ꞌ roꞌ, da̱nj ga̱a̱ ꞌe̱e̱ rá so̱ꞌ man tuvíꞌ so̱ꞌ á”. Taj va̱j yoꞌó nana̱ noco̱o doj rihaan ro̱j nana̱ nihánj nana̱ cataj xnaꞌanj Diose̱ rihaan níꞌ a̱ man ado̱nj ―taj Jesucristó rihaan síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ga̱a ne̱ cataj síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés yoꞌ rihaan Jesucristó a: ―Cuna̱j uxrá caꞌmii so̱ꞌ, maestro, ne̱ ya̱ uxrá vaa nana̱ caꞌmii so̱ꞌ, se vaa o̱ruun Diose̱, ne̱ taj va̱j tuviꞌ Diose̱, ma̱a̱n se o̱ruun soꞌ nicunꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ne̱ ya̱ uxrá vaa nana̱ se vaa sese nda̱a nimán ya̱ níꞌ gu̱un rá níꞌ ni̱ꞌyaj níꞌ man Diose̱ do̱ꞌ, sese yoꞌo̱ cuchuma̱n rá nda̱a cúú yave̱ ya̱ níꞌ ni̱ꞌyaj níꞌ man Diose̱ do̱ꞌ, sese nda̱a nu̱ꞌ se nucua̱j man níꞌ cara̱a̱ cochro̱j rihaan Diose̱ do̱ꞌ, sese ga̱a̱ ꞌe̱e̱ rá níꞌ man tuviꞌ níꞌ nda̱a se ꞌe̱e̱ rá níꞌ man maꞌa̱n níꞌ do̱ꞌ, ne̱ sa̱ꞌ doj vaa tucuáán nihánj rihaan nu̱ꞌ tucuáán nago̱ꞌ queꞌe̱e̱ scúj caca̱a̱ rihaan Diose̱ na̱nj chugua̱nj ―taj síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés yoꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ga̱a ne̱ queneꞌen Jesucristó se vaa ya̱ cavii raa̱ síí caꞌmii da̱nj rihaan soꞌ, ne̱ cheꞌé dan cataj Jesucristó rihaan soꞌ: ―So̱ꞌ me se nichru̱nꞌ ya̱ gu̱un chij Diose̱ nimán so̱ꞌ na̱nj ei ―taj Jesucristó rihaan soꞌ a. Ne̱ taj va̱j síí quisíj rá xna̱ꞌanj yoꞌó nana̱ man Jesucristó a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Dan me se ga̱a tucuꞌyón Jesucristó se‑na̱na̱ soꞌ man nij yuvii̱ rá nuvií noco̱o, ne̱ cataj soꞌ: ―Nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ roꞌ, me cheꞌé taj nij soꞌ se vaa na̱nj taꞌníí taꞌnij siꞌno̱ síí cuꞌna̱j David síí cane ga̱a naá me síí caꞌna̱ꞌ ti̱nanii man yuvii̱ rihaan sayuun, rá soj ga̱. ");
INSERT INTO trcNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ꞌO̱ se nuû Nimán Diose̱ nimán síí cuꞌna̱j David, ne̱ cataj síí cuꞌna̱j David: “Caꞌmii Diose̱ síí ꞌni̱j raꞌa man níꞌ rihaan síí ꞌni̱j raꞌa manj, cataj soꞌ se vaa ca̱yáán síí ꞌni̱j raꞌa manj xꞌnúú Diose̱ rej nuva̱ꞌ Diose̱ nda̱a se quisi̱j quiꞌya̱j canaán Diose̱ rihaan taranꞌ nij síí ta̱j riꞌyunj man síí ꞌni̱j raꞌa manj ne̱ quiri̱i̱ taꞌngaꞌ síí ꞌni̱j raꞌa manj rihaan nij soꞌ na̱nj ado̱nj”, taj síí cuꞌna̱j David yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dan me se síí ꞌni̱j raꞌa man síí cuꞌna̱j David me síí caꞌne̱j Diose̱ ti̱nanii man yuvii̱ rihaan sayuun, taj síí cuꞌna̱j David yoꞌ a. Sese ꞌni̱j raꞌa soꞌ man David, ne̱ me cheꞌé taj nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés se vaa na̱nj taꞌníí taꞌnij siꞌno̱ David me soꞌ ga̱. Taj cheꞌé cata̱j nij soꞌ se vaa na̱nj yuvii̱ me soꞌ maꞌ ―taj Jesucristó rihaan nij yuvii̱ ma̱n rá nuvií noco̱o a. Queꞌe̱e̱ nij yuvii̱ cuno se‑na̱na̱ Jesucristó, ne̱ guun niha̱ꞌ rá nij soꞌ cuno̱ nij soꞌ se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Dan me se ga̱a tucuꞌyón Jesucristó se‑na̱na̱ soꞌ man nij yuvii̱, ne̱ cataj soꞌ: ―Xca̱j nij soj cuentá da̱j ꞌyaj nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱, ne̱ tu̱mé soj man soj se̱ gaa na̱nj quiꞌya̱j soj nda̱a vaa ꞌyaj nij soꞌ á. Dan me se niha̱ꞌ rá nij soꞌ cu̱nuû nij soꞌ yatzíj sa̱ꞌ xca̱a̱n cache̱e̱ nij soꞌ rej queneꞌe̱n yuvii̱ man nij soꞌ, ne̱ me rá nij soꞌ caꞌmi̱i̱ sa̱ꞌ yuvii̱ ga̱ nij soꞌ ga̱a chéé nij soꞌ rihaan yuꞌvee a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ne̱ uun rá nij soꞌ quita̱j nij soꞌ chruun xlá sa̱ꞌ doj ga̱a ꞌanj nij soꞌ veꞌ nuu chre̱ꞌ níꞌ tu̱cuꞌyón níꞌ se‑tucua̱nj Moisés do̱ꞌ, ga̱a ꞌanj nij soꞌ chaꞌanj do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ne̱ aꞌnéj nij soꞌ veꞌ tucuá chana̱ caviꞌ nica̱, ne̱ yu̱u̱n cheꞌe̱ guun tucua̱ nij soꞌ man veꞌ yoꞌ, ne̱ ꞌyaj xca̱a̱n ndoꞌo nij soꞌ cuentó achíín niꞌya̱j nij soꞌ rihaan Diose̱, cheꞌé rej sa̱ꞌ doj gu̱un nucua̱j nij soꞌ tiha̱ꞌ yuꞌunj nij soꞌ man yuvii̱ a. Xa̱ꞌ nij soꞌ, tza̱j ne̱ cheꞌé se vaa ꞌyaj nij soꞌ roꞌ, cheꞌé dan doj a̱ ga̱a̱ sayuun quira̱nꞌ nij soꞌ quiꞌya̱j Diose̱, asa̱ꞌ caꞌneꞌ Diose̱ cacunꞌ cheꞌé yuvii̱ ado̱nj ―taj Jesucristó rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Dan me se ta̱j Jesucristó rej ta̱j chrúún saꞌanj ta̱j rihaan nuvií noco̱o, ne̱ neꞌen soꞌ da̱j quiꞌyaj nij yuvii̱ ga̱a araa nij yuvii̱ saꞌanj aga̱ꞌ rque chrúún saꞌanj yoꞌ cheꞌé Diose̱, ne̱ dan me se ma̱n ndoꞌo síí ruꞌvee araa uxrá saꞌanj rque chrúún yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ne̱ dan me se caꞌnaꞌ ꞌo̱ chana̱ caviꞌ nica̱ chana̱ nique̱, ne̱ caraa noꞌ vi̱j gue̱e̱ saꞌanj aga̱ꞌ leꞌe̱j rque chrúún yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ga̱a ne̱ canacúún Jesucristó man nij síí tucuꞌyón se‑na̱na̱ soꞌ caꞌna̱ꞌ nij soꞌ rihaan soꞌ, ga̱a ne̱ cataj soꞌ rihaan nij soꞌ a: ―Cata̱j xnaꞌanj yá yá ꞌu̱nj rihaan nij soj cuano̱ se vaa xa̱ꞌ chana̱ caviꞌ nica̱ chana̱ nique̱ nihánj, tza̱j ne̱ doj a̱ caraa noꞌ saꞌanj rque chrúún yoꞌ rihaan saꞌanj caraa cunuda̱nj yoꞌó nij yuvii̱ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ꞌO̱ se nij soꞌ, da̱j doj saꞌanj quináj raa̱ se‑saꞌa̱nj nij soꞌ roꞌ, caraa nij soꞌ rque chrúún, ne̱ xa̱ꞌ noꞌ, tza̱j ne̱ nda̱ꞌ se achiin ndoꞌo saꞌanj rihaan noꞌ, tza̱j ne̱ rqué noꞌ rihaan Diose̱ cunuda̱nj saꞌanj nica̱j noꞌ saꞌanj quira̱a̱n noꞌ se cha̱ noꞌ na̱nj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ga̱a ne̱ curiha̱nj Jesucristó rá nuvií noco̱o, ga̱a ne̱ yoꞌo̱ tuviꞌ nij síí tucuꞌyón se‑na̱na̱ soꞌ cataj rihaan soꞌ a: ―Ni̱ꞌyaj so̱ꞌ, ne̱ yuvej sa̱ꞌ ina̱nj me yuvej guun nuvií noco̱o, ne̱ veꞌé ndoꞌo vaa nu̱ꞌ nij veꞌ ma̱n nuvií noco̱o, maestro ―taj yoꞌo̱ tuviꞌ nij síí tucuꞌyón se‑na̱na̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Neꞌén so̱ꞌ nu̱ꞌ nij veꞌ noco̱o ma̱n nuvií nihánj naꞌ. Vaa güii, ne̱ cane̱e̱ nu̱ꞌ nuvií noco̱o nihánj, ne̱ a̱ ꞌó yuvej se̱ quitáá xráá tuviꞌ yuvej nihánj a̱ maꞌ ―taj Jesucristó rihaan síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Dan me se caꞌanj ca̱yáán Jesucristó raa̱ quij cuꞌna̱j Quij ma̱n Chruun Olivó, ne̱ niꞌya̱j soꞌ nuvií noco̱o, ne̱ cuchiꞌ o̱rúnꞌ caꞌa̱nj nij síí cuꞌna̱j Pedró do̱ꞌ, Jacobo do̱ꞌ, Juan do̱ꞌ, Andrés do̱ꞌ, rihaan soꞌ, ne̱ xnáꞌanj nij soꞌ man soꞌ, cataj nij soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Cata̱j xnaꞌanj so̱ꞌ rihaan núj aman cane̱e̱ nu̱ꞌ nuvií noco̱o yoꞌ do̱ꞌ, a̱ me rasu̱u̱n caꞌna̱ꞌ qui̱ꞌyáá so̱ꞌ asa̱ꞌ quisíj caꞌna̱ꞌ nu̱ꞌ nij sayuun nda̱a vaa cataj xnaꞌanj so̱ꞌ rihaan núj, maestro ―taj caꞌa̱nj tuviꞌ nij síí tucuꞌyón se‑na̱na̱ Jesucristó rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ga̱a ne̱ guun cheꞌe̱ Jesucristó cataj xnaꞌanj Jesucristó rihaan nij soꞌ, ne̱: ―Cu̱tumé ndoꞌo soj man soj se̱ gaa na̱nj tiha̱ꞌ yuꞌunj yuvii̱ man soj á. ");
INSERT INTO trcNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ꞌO̱ se caꞌna̱ꞌ uxrá yuvii̱ cata̱j: “ꞌU̱nj me síí naꞌvi̱j soj, ne̱ Cristó mej á”, cata̱j nij soꞌ, ne̱ dan me se tiha̱ꞌ yuꞌunj uxrá nij soꞌ man tuviꞌ nij soꞌ na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","”Dan me se asa̱ꞌ queneꞌen soj se vaa unuꞌ uxrá chumanꞌ ga̱ tuviꞌ chumanꞌ, ne̱ asa̱ꞌ cuno uxrá soj nana̱ se vaa unuꞌ chumanꞌ ma̱n ga̱nꞌ ga̱ tuviꞌ chumanꞌ yoꞌ, ne̱ cu̱tumé soj man soj se̱ cuchuꞌviꞌ nimán soj maꞌ. Ma̱a̱n se vaa cheꞌé gu̱un sayuun yoꞌ rihaan chumii̱ nihánj ado̱nj. Tza̱j ne̱ asa̱ꞌ quisíj guun da̱nj, ga̱a ne̱ se̱ caꞌanj niꞌya̱ chumii̱ nihánj nu̱ꞌ orá maꞌ. ꞌO̱ se quina̱j chumii̱ nihánj doj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dan me se cunu̱ꞌ uxrá yuvii̱ ma̱n chumanꞌ noco̱o ga̱ yoꞌó chumanꞌ noco̱o, ne̱ cunu̱ꞌ gobiernó ga̱ tuviꞌ gobiernó a. Ne̱ cache̱n yuún noco̱o queꞌe̱e̱ chumanꞌ, ne̱ cache̱n ndoꞌo xꞌnaa uún a. Nu̱ꞌ sayuun nihánj roꞌ, ase vaa guun cheꞌe̱ ꞌo̱ chana̱ queꞌee̱ rque noꞌ cuchru̱j noꞌ neꞌej roꞌ, da̱nj ga̱a̱ nu̱ꞌ sayuun nihánj na̱nj ei. Dan me se nu̱ꞌ neꞌen chana̱ veꞌee̱ rque noꞌ, ne̱ neꞌen noꞌ doj a̱ quira̱nꞌ noꞌ sayuun rej rihaan noꞌ, ne̱ ase uun rá chana̱ yoꞌ, da̱nj gu̱un rá soj ga̱a caꞌna̱ꞌ sayuun yoꞌ, gu̱un rá soj se vaa da̱j doj gu̱un uxrá sayuun rihaan chumii̱ nihánj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","”Ne̱ tadó soj cheꞌé sayuun quira̱nꞌ maꞌa̱n soj ei. ꞌO̱ se ta̱cuachén nii man soj rihaan nij síí uun chij rihaan níꞌ si̱j israelitá, ne̱ ta̱cuachén nii man soj rihaan nij síí ma̱n rá veꞌ tucuꞌyón níꞌ se‑tucua̱nj Moisés, ne̱ ma̱a̱n yoꞌ go̱ꞌ nii cuartá xráá soj a. Ne̱ ta̱cuachén nii man soj canicu̱nꞌ soj rihaan síí nica̱j suun do̱ꞌ, rihaan síí nica̱j suun rey do̱ꞌ, cheꞌé se me soj síí noco̱ꞌ manj a. Ne̱ cata̱j xnaꞌanj soj rihaan nij síí nica̱j suun cheꞌej a. ");
INSERT INTO trcNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ne̱ asino caꞌmi̱i̱ natáj soj se‑na̱na̱j nana̱ sa̱ꞌ rihaan cunuda̱nj nij síí yaníj, ga̱a ne̱ caꞌve̱e quinavi̱j chumii̱ nihánj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","”Dan me se asa̱ꞌ caꞌa̱nj ni̱caj nii man soj rihaan nij síí nica̱j suun, ne̱ se̱ nanó rá soj da̱j caꞌmi̱i̱ soj rihaan nij soꞌ maꞌ. Ma̱a̱n Nimán Diose̱ rque̱ nu̱ꞌ nana̱ caꞌmi̱i̱ soj man orá yoꞌ na̱nj ado̱nj. ꞌO̱ se nuveé maꞌa̱n soj me nij síí caꞌmi̱i̱ rihaan nij soꞌ maꞌ. ꞌO̱ se Nimán Diose̱ me síí caꞌmi̱i̱ rihaan nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Dan me se caꞌa̱nj ni̱caj snóꞌo man tinúú snóꞌo rihaan yuvii̱, ne̱ ticavi̱ꞌ nii man tinúú snóꞌo yoꞌ, quiꞌya̱j maꞌa̱n soꞌ na̱nj ado̱nj. Ne̱ caꞌa̱nj ni̱caj snóꞌo man taꞌníí snóꞌo rihaan yuvii̱, ne̱ ticavi̱ꞌ nii man taꞌníí snóꞌo yoꞌ, quiꞌya̱j soꞌ ei. Ne̱ cunu̱ꞌ xnii ga̱ rej xnii, ne̱ caꞌa̱nj ni̱caj xnii man rej xnii rihaan yuvii̱, ne̱ ticavi̱ꞌ nii man rej xnii yoꞌ, quiꞌya̱j soꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ne̱ nachri̱ꞌ cunuda̱nj nij yuvii̱ ma̱n rihaan chumii̱ ni̱ꞌyaj nij soꞌ man soj, cheꞌé se me soj síí noco̱ꞌ manj ado̱nj. Tza̱j ne̱ síí noco̱ꞌ raan manj nda̱a se caꞌa̱nj niꞌya̱ chumii̱ nihánj roꞌ, soꞌ me síí quinani̱i̱ rihaan sayuun ado̱nj ―taj Jesucristó rihaan caꞌa̱nj tuviꞌ nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ne̱ soj si̱j nayaa nana̱ nihánj roꞌ, xca̱j uxrá soj cuentá me taj nana̱ nihánj nana̱ caꞌmii Jesucristó cheꞌé se chiꞌi̱i̱ á. Dan me se cataj uún Jesucristó: ―A̱j neꞌen soj se vaa vaa ꞌo̱ se chiꞌi̱i̱ quiꞌya̱j ndoꞌo sayuun man yuvii̱, ne̱ dan me se güii queneꞌe̱n soj man se chiꞌi̱i̱ yoꞌ rej ne nó xcúún yoꞌ nicu̱nꞌ yoꞌ, ne̱ yoꞌo̱ cuna̱nj nij síí ma̱n estadó Judea caꞌa̱nj nij soꞌ raa̱ quij á. ");
INSERT INTO trcNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ne̱ síí ta̱j xráá veꞌ tucuá roꞌ, se̱ catúj soꞌ rá veꞌ tucuá soꞌ quiri̱i̱ soꞌ siꞌyaj soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ne̱ síí ꞌyaj suun tacaan roꞌ, se̱ canica̱j soꞌ nano̱ꞌ soꞌ saga̱nꞌ soꞌ se vaa tanáj soꞌ rihaan yoꞌóó maꞌ. Se̱ guun ra̱a̱n nij soꞌ maꞌ. Ma̱a̱n se yoꞌo̱ cuna̱nj nij soꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nique̱ nij chana̱ nu̱u̱ rque do̱ꞌ, chana̱ vaa taꞌníí neꞌej utzii do̱ꞌ, güii caꞌna̱ꞌ sayuun yoꞌ a. ꞌO̱ se se̱ guun nucua̱j chana̱ yoꞌ cuna̱nj chana̱ yoꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Cachi̱nj niꞌya̱j soj rihaan Diose̱ se vaa se̱ caꞌnaꞌ sayuun yoꞌ güii ga̱a̱ maa̱n maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","”ꞌO̱ se güii yoꞌ me se caꞌna̱ꞌ uxrá sayuun, ne̱ quij doj ga̱a̱ sayuun yoꞌ rihaan nu̱ꞌ nij sayuun quiranꞌ yuvii̱ asi̱j quiꞌyaj Diose̱ chumii̱, ne̱ daj chiha̱a̱ míj se̱ quiranꞌ uún yuvii̱ sayuun vaa da̱nj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Sese queꞌe̱e̱ uxrá güii gu̱un sayuun, ne̱ se̱ quinanii yuvii̱ rihaan sayuun yoꞌ maꞌ. Tza̱j ne̱ vaa güii quisi̱j sayuun, quiꞌya̱j síí ꞌni̱j raꞌa man níꞌ, cheꞌé rej quinani̱i̱ nij síí narii soꞌ canoco̱ꞌ man soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","”Ne̱ güii yoꞌ me se sese cata̱j yuvii̱ rihaan soj: “Ni̱ꞌyaj soj ei. Nihánj ꞌnaꞌ síí ti̱nanii man níꞌ rihaan sayuun á”, ne̱ se̱ cuchumán rá soj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ꞌO̱ se caꞌna̱ꞌ uxrá síí ne̱ síí cata̱j se vaa síí ti̱nanii man yuvii̱ rihaan sayuun me nij soꞌ, ne̱ caꞌna̱ꞌ uxrá síí ne̱ síí cata̱j se vaa nataꞌ nij soꞌ se‑na̱na̱ Diose̱, ne̱ quiꞌya̱j nij soꞌ suun sa̱ꞌ noco̱o, ne̱ tiha̱ꞌ yuꞌunj nij soꞌ man cunuda̱nj nij yuvii̱ ma̱n rihaan chumii̱ na̱nj ado̱nj. Nda̱a nij síí narii Diose̱ man roꞌ, sese taj va̱j Diose̱ tumé man nij soꞌ, ne̱ cuchuma̱n rá nij soꞌ ni̱ꞌyaj nij soꞌ man síí tihaꞌ yuꞌunj yoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ta̱dó uxrá soj á. Nihánj me se cataj xnaꞌanj ꞌu̱nj rihaan soj da̱j gu̱un rihaan chumii̱ nihánj na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","”Tza̱j ne̱ güii yoꞌ me se asa̱ꞌ navij quisíj sayuun yoꞌ, ga̱a ne̱ gu̱un rmi̱ꞌ güii gu̱un rmi̱ꞌ yavii gu̱un rmi̱ꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ne̱ cayu̱u nij yatiꞌ xta̱ꞌ, ne̱ quina̱a̱n taranꞌ nij rasu̱u̱n nucua̱j ma̱n rej xta̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ga̱a ne̱ queneꞌe̱n nii mán ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ á. Dan me se xráá ngaa quita̱j ꞌu̱nj caꞌna̱ꞌ ꞌu̱nj, ne̱ gu̱un nucua̱j ndoꞌoj quiri̱i̱ taꞌngaj, ne̱ veꞌé uxrá curuvi̱j caꞌna̱j a. ");
INSERT INTO trcNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ga̱a ne̱ caꞌne̱j ꞌu̱nj man nij se‑mo̱zó ꞌu̱nj cuchi̱ꞌ nij soꞌ rihaan chumii̱ nihánj, ne̱ dan me se naquiꞌya̱j chre̱ꞌ ꞌu̱nj man nij síí narii Diose̱ man canoco̱ꞌ manj a. Dan me se cache̱e̱ nij se‑mo̱zó ꞌu̱nj rihaan nu̱ꞌ chumii̱ nihánj, nano̱ꞌ nij soꞌ taranꞌ nij síí cunu̱u chre̱ꞌ ga̱ ꞌu̱nj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","”Tu̱cuꞌyón soj nana̱ nihánj nana̱ cheꞌé chruun ma̱n chruj higó raa̱ á. Ga̱a quisíj guun laru̱u raꞌa chruun, ne̱ naca coj yaꞌli̱j raꞌa chruun, ne̱ neꞌen soj se vaa nichru̱nꞌ ꞌnaꞌ tió nama̱n maa̱n a. ");
INSERT INTO trcNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Dan me se xca̱j uún soj cuentá se vaa asa̱ꞌ queneꞌen soj nu̱ꞌ se vaa cataj xnaꞌanj ꞌu̱nj rihaan soj cuano̱, ne̱ nichru̱nꞌ caꞌna̱ꞌ uún ꞌu̱nj na̱nj ado̱nj. Dan me se ase vaa síí nicu̱nꞌ taꞌyaa roꞌ, ga̱a̱ ꞌu̱nj ei. ");
INSERT INTO trcNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa queneꞌe̱n taꞌa̱j soj si̱j vaa iꞌna̱ꞌ rihaan chumii̱ nihánj cuano̱ se vaa quisi̱j ya̱ ꞌunj nu̱ꞌ rasu̱u̱n nihánj nu̱ꞌ se vaa cataj xnaꞌanj ꞌu̱nj rihaan soj cuano̱ ei. Ne̱ ya̱ queneꞌe̱n soj nu̱ꞌ nihánj ga̱a ataa cavi̱ꞌ soj ei. ");
INSERT INTO trcNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Vaa güii caꞌa̱nj niꞌya̱ yoꞌóó do̱ꞌ, xta̱ꞌ do̱ꞌ, tza̱j ne̱ se‑na̱na̱j me se daj chiha̱a̱ míj se̱ quinavij yoꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","”Nihánj me cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa a̱ ꞌó síí ne neꞌen me güii caꞌna̱ꞌ uún ꞌu̱nj rihaan chumii̱ nihánj maꞌ. Caꞌve̱e se nda̱a se‑mo̱zó Diose̱ ꞌyaj suun rej xta̱ꞌ, caꞌve̱e se nda̱a ma̱ꞌanj taꞌni̱j Diose̱, tza̱j ne̱ ne neꞌen núj me güii me yoꞌ maꞌ. O̱rúnꞌ Réj me síí neꞌen na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yoꞌo̱ ni̱ꞌyaj soj, ne̱ se̱ guun coto̱j soj maꞌ. ꞌO̱ se ne neꞌen uxrá soj me güii me caꞌna̱j maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Dan me se ase vaa síí caꞌa̱nj yoꞌó chumanꞌ na̱j ga̱nꞌ vaa ꞌu̱nj, ne̱ a̱j tanáj ꞌu̱nj veꞌ tucuaj, ne̱ caꞌnéꞌ ꞌu̱nj suun rihaan ꞌo̱ ꞌo̱ nij mozó nu̱u̱ rihanj se vaa veꞌé cu̱tumé nij soꞌ nu̱ꞌ siꞌyáj, ne̱ ase vaa síí tumé taꞌyaa vaa nij soj, ne̱ a̱j cataj xnaꞌanj ꞌu̱nj rihaan nij soj se vaa ni̱ꞌyaj soj a. ");
INSERT INTO trcNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Cheꞌé dan tu̱mé uxrá soj man soj, ne̱ ni̱ꞌyaj soj á. ꞌO̱ se ne neꞌen soj aman caꞌna̱ꞌ ꞌu̱nj si̱j tucua̱ veꞌ maꞌ. Caꞌve̱e caꞌna̱j rej tiꞌnuu, caꞌve̱e rej ya̱nꞌ, caꞌve̱e orá aguáj toꞌloo caꞌve̱e rej naꞌya̱a̱n caꞌve̱e, ");
INSERT INTO trcNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ne̱ ta̱dó soj se̱ guun taj niꞌyón caꞌna̱j ne̱ nari̱ꞌ ꞌu̱nj man soj ne̱ xca̱j ꞌu̱nj cuentá se vaa otoj rmaꞌa̱n soj ei. ");
INSERT INTO trcNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ne̱ nana̱ nihánj nana̱ taj xnaꞌanj ꞌu̱nj rihaan nij soj roꞌ, veé nana̱ nihánj taj xnaꞌanj ꞌu̱nj rihaan cunuda̱nj nij yuvii̱, se vaa tu̱mé soj man soj se̱ gaa na̱nj coto̱j rmaꞌa̱n soj a ―taj Jesucristó rihaan caꞌa̱nj tuviꞌ nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Dan me se rque vi̱j güii ca̱nuû chaꞌanj pascuá chaꞌanj chá nij yuvii̱ israelitá chraa yoꞌóó trigó, ne̱ dan me se ꞌo̱ guun rá nij xrej ata̱ suun noco̱o doj ga̱ nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ se vaa tiha̱ꞌ yuꞌunj nij soꞌ man Jesucristó, ne̱ qui̱taꞌaa yuve̱ nij soꞌ man Jesucristó, ne̱ cavi̱ꞌ Jesucristó, quiꞌya̱j nij soꞌ, rá nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ne̱ cataj nij soꞌ: ―Se̱ quitaꞌaa níꞌ man soꞌ ga̱a aman anuû chaꞌanj maꞌ. Sese da̱nj quiꞌya̱j níꞌ, ne̱ caꞌma̱an rá nij yuvii̱, ne̱ gu̱un sayuun, quiꞌya̱j nij yuvii̱ na̱nj ado̱nj ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Dan me se yáán Jesucristó chumanꞌ cuꞌna̱j Betania, ne̱ ne soꞌ rá ꞌo̱ veꞌ tucuá síí cuꞌna̱j Simón síí canó luj riꞌyuj man, ne̱ yáán Jesucristó rihaan mesá, ne̱ cuchiꞌ yoꞌo̱ chana̱ rihaan soꞌ, ne̱ nica̱j chana̱ yoꞌo̱ agaꞌ catzi̱i̱ nu̱u̱ casté gunꞌ da̱j rii nii man coj cuꞌna̱j nardo, ne̱ casté tuꞌve̱e̱ ndoꞌo me yoꞌ a. Naxraꞌ chana̱ yoꞌ agaꞌ, ne̱ caxríj chana̱ casté raa̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ne̱ caꞌmaan rá taꞌa̱j nij síí queneꞌen, ne̱ cataj nij soꞌ rihaan tuviꞌ nij soꞌ: ―Me cheꞌé tiriꞌ rmaꞌa̱n chana̱ nihánj casté sa̱ꞌ ga̱. ");
INSERT INTO trcNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Me cheꞌé ne cutuꞌve̱e̱ noꞌ casté, ne̱ quiri̱ꞌ noꞌ saꞌanj ase vaa ꞌyaj canaán yuvii̱ rque ꞌo̱ yoꞌ, ne̱ go̱ꞌ noꞌ saꞌanj yoꞌ man nij síí nique̱ ga̱ ―taj nij soꞌ rihaan tuviꞌ nij soꞌ, ga̱a ne̱ guun cheꞌe̱ nij soꞌ caxríj yuva̱a̱ nij soꞌ man chana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Me cheꞌé aꞌmii soj da̱nj niꞌya̱j soj man chana̱ ga̱. Caꞌne̱ꞌ gue̱e̱ rá nij soj do̱j na̱nj á. ꞌO̱ se veꞌé uxrá quiꞌyaj noꞌ manj ei. ");
INSERT INTO trcNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ꞌO̱ se síí nique̱ me se daj a̱ güii mán nij síí nique̱ ga̱ soj, ne̱ me maꞌa̱n güii gu̱un rá soj, ne̱ caꞌve̱e quiꞌya̱j soj se lu̱j ga̱ nij síí nique̱ ei. Tza̱j ne̱ ꞌu̱nj me se vaa güii caꞌa̱nj ꞌu̱nj, ne̱ quina̱j u̱u̱n soj, ne̱ se̱ caꞌvee quiꞌya̱j soj se lu̱j cheꞌej maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ne̱ chana̱ nihánj me se quiꞌyaj maꞌa̱n noꞌ nu̱ꞌ nda̱a vaa caꞌvee quiꞌyaj noꞌ, ne̱ dan me se ga̱a ataa cavi̱ꞌ ꞌu̱nj ne̱ a̱j caxríj noꞌ casté gunꞌ da̱j manj cheꞌé rej xca̱j soj cuentá se vaa cachi̱nꞌ nii manj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ne̱ cata̱j yá yá ꞌu̱nj rihaan nij soj cuano̱ se vaa me rej maꞌa̱n caꞌmi̱i̱ natáj yuvii̱ se‑na̱na̱j nana̱ sa̱ꞌ rihaan nij yuvii̱ ma̱n rihaan nu̱ꞌ chumii̱ nihánj roꞌ, ne̱ cata̱j xnaꞌanj uún yuvii̱ rihaan tuviꞌ yuvii̱ cheꞌé se vaa quiꞌyaj chana̱ nihánj manj, ne̱ se̱ quiniꞌyón yuvii̱ man chana̱ nihánj maꞌ ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ga̱a ne̱ síí cuꞌna̱j Judas Iscariote yoꞌo̱ tuviꞌ chuvi̱j nij síí tucuꞌyón se‑na̱na̱ Jesucristó me se cavii soꞌ caꞌanj soꞌ rihaan nij xrej ata̱ suun noco̱o doj, cheꞌé rej ra̱cuíj soꞌ man nij soꞌ qui̱taꞌaa nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ne̱ ga̱a cuno nij xrej ata̱ suun noco̱o doj, ne̱ guun niha̱ꞌ uxrá rá nij soꞌ, ne̱ cataꞌ tuꞌva nij soꞌ se vaa nago̱ꞌ nij soꞌ saꞌanj man síí cuꞌna̱j Judas a. Ga̱a ne̱ guun cheꞌe̱ síí cuꞌna̱j Judas nuchruj ra̱a̱ soꞌ aman caꞌve̱e ra̱cuíj soꞌ man nij xrej ata̱ suun noco̱o doj qui̱taꞌaa nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Dan me se quisíj güii ya̱a̱n canuû chaꞌanj chá nij yuvii̱ israelitá chraa yoꞌóó trigó, ne̱ güii ticaviꞌ nij soꞌ matzinj leꞌe̱j cheꞌé Diose̱ me yoꞌ, ne̱ dan me se nij síí tucuꞌyón se‑na̱na̱ Jesucristó me se xnáꞌanj nij soꞌ man Jesucristó, cataj nij soꞌ: ―Me rej caꞌa̱nj núj quiꞌya̱j chuvi̱i núj cha̱ xtiꞌno̱ níꞌ chaꞌanj pascuá, rá so̱ꞌ ga̱ ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ga̱a ne̱ caꞌnéé Jesucristó man vi̱j tuviꞌ nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ cataj soꞌ rihaan ro̱j soꞌ a: ―Cavi̱i̱ ro̱j so̱j, ne̱ catu̱u̱ ro̱j so̱j chumanꞌ Jerusalén nihánj, ne̱ nari̱ꞌ tuviꞌ ro̱j so̱j ga̱ ꞌo̱ síí ata̱ ꞌo̱ cacuaj na, ");
INSERT INTO trcNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ne̱ canoco̱ꞌ ro̱j so̱j man soꞌ, ne̱ rihaan síí tucua̱ veꞌ catu̱u̱ soꞌ me se cata̱j soj: “Xnáꞌanj maestró mán so̱ꞌ se vaa me rej ne̱ veꞌ cha̱ xtiꞌno̱ maestró chraa ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ cheꞌé chaꞌanj pascuá, taj soꞌ a”, cata̱j ro̱j so̱j rihaan síí tucua̱ veꞌ yoꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ga̱a ne̱ ti̱haa̱n soꞌ ꞌo̱ veꞌ nataꞌ xi̱j rihaan ro̱j so̱j, ne̱ a̱j vaa chuvi̱i rá veꞌ yoꞌ, ne̱ ma̱n chruun mesá ma̱n chruun xlá ma̱n rá veꞌ yoꞌ a. Yoꞌ me rej quiꞌya̱j chuvi̱i ro̱j so̱j á ―taj Jesucristó rihaan ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ga̱a ne̱ curiha̱nj ro̱j síí tucuꞌyón se‑na̱na̱ Jesucristó, ne̱ catúj ro̱j soꞌ chumanꞌ Jerusalén, ne̱ nariꞌ ro̱j soꞌ nu̱ꞌ nda̱a vaa cataj xnaꞌanj Jesucristó rihaan ro̱j soꞌ, ga̱a ne̱ quiꞌyaj chuvi̱i ro̱j soꞌ cha̱ xtiꞌno̱ nij soꞌ chraa cheꞌé chaꞌanj pascuá a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ne̱ rej tiꞌnuu, ne̱ caꞌnaꞌ Jesucristó ga̱ yoꞌó chi̱ꞌ nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Dan me se yáán nij soꞌ rihaan mesá, chá nij soꞌ chraa, ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa yoꞌo̱ tuviꞌ nij soj me síí ta̱cuachén manj rihaan nij síí ta̱j riꞌyunj manj, ne̱ síí chá chraa ga̱ ꞌu̱nj cuano̱ me síí quiꞌya̱j da̱nj ei ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ga̱a ne̱ guun cheꞌe̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ quinanó ndoꞌo rá nij soꞌ, ne̱ guun cheꞌe̱ nij soꞌ nda̱a ꞌo̱ ꞌo̱ nij soꞌ xnáꞌanj man Jesucristó, cataj ꞌo̱ ꞌo̱ nij soꞌ: ―ꞌU̱nj me síí quiꞌya̱j da̱nj naꞌ ―taj ꞌo̱ ꞌo̱ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Yoꞌo̱ tuviꞌ chuvi̱j nij soj si̱j tucuꞌyón se‑na̱na̱j me síí ta̱cuachén manj rihaan nij síí ta̱j riꞌyunj manj, ne̱ síí tiguíj rachrúún ga̱ ꞌu̱nj rá coꞌoo me soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ꞌO̱ se taj danj Diose̱ se vaa caꞌa̱nj ꞌu̱nj cavi̱ꞌ ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱, ne̱ ya̱ da̱nj qui̱ránꞌ ꞌu̱nj ado̱nj. Tza̱j ne̱ nique̱ ndoꞌo síí ta̱cuachén manj rihaan nij síí ta̱j riꞌyunj manj na̱nj á. Quira̱nꞌ uxrá soꞌ sayuun na̱nj á. Snóꞌo yoꞌ me se sese ne caꞌnga̱a̱ soꞌ, ne̱ cavii sa̱ꞌ soꞌ doj tza̱j ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ne̱ ga̱a chá nij soꞌ chraa, ne̱ quitaꞌaa Jesucristó yoꞌo̱ rachrúún, ne̱ nagoꞌ soꞌ graciá rihaan Diose̱, ne̱ cuxraꞌ taꞌa̱j soꞌ rachrúún, ne̱ rqué soꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ cataj soꞌ: ―Qui̱taꞌaa soj rachrúún nihánj á. Nee̱ manj me rachrúún nihánj ei ―taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ga̱a ne̱ quitaꞌaa Jesucristó agaꞌ tazá nu̱u̱ na vinó, ne̱ nagoꞌ soꞌ graciá rihaan Diose̱, ne̱ tacuachén soꞌ agaꞌ nu̱u̱ na vinó rihaan nij soꞌ, ne̱ coꞌo cunuda̱nj nij soꞌ na vinó yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ga̱a ne̱ cataj soꞌ rihaan nij soꞌ a: ―Ton manj me na nihánj, ne̱ cheꞌé ton manj roꞌ, rqué Diose̱ ꞌo̱ nana̱ rihaan soj da̱j quiꞌya̱j Diose̱ ga̱ soj a. Dan me se caya̱nj ton manj cheꞌé queꞌe̱e̱ yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ne̱ cata̱j yá yá ꞌu̱nj rihaan soj cuano̱ se vaa veé do̱j nihánj me coꞌoj, ne̱ se̱ coꞌoj ya̱j a̱ maꞌ. Tza̱j ne̱ asa̱ꞌ quisíj güii gu̱un chij Diose̱ rihaan chumii̱ nihánj, ne̱ cunu̱u naca̱ chumii̱ nihánj, ga̱a ne̱ coꞌo̱j na vinó naca̱ ei ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ga̱a ne̱ cachráá taranꞌ nij soꞌ chraꞌ rihaan Diose̱, ne̱ cavii nij soꞌ, caꞌanj nij soꞌ quij cuꞌna̱j Quij ma̱n Chruun Olivó a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Danj Diose̱ taj se vaa go̱ꞌ Diose̱ man síí tumé matzinj, ne̱ cuna̱nj nij matzinj chaꞌnu̱u̱ nij xoꞌ a. Ne̱ ya̱ ase vaa daán ꞌu̱nj matzinj vaa soj, ne̱ gu̱un naꞌa̱j taranꞌ soj, ne̱ se̱ canocoꞌ soj manj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tza̱j ne̱ asa̱ꞌ quisíj cunuu iꞌna̱ꞌ uún ꞌu̱nj, ne̱ quita̱j ya̱a̱n ꞌu̱nj rihaan soj caꞌa̱nj ꞌu̱nj estadó Galilea, ne̱ nari̱ꞌ tuviꞌ níꞌ estadó Galilea na̱nj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ga̱a ne̱ cataj síí cuꞌna̱j Pedró rihaan soꞌ a: ―Caꞌve̱e se ta̱náj taranꞌ nij soꞌ mán so̱ꞌ, tza̱j ne̱ daj chiha̱a̱ míj se̱ tanáj ꞌu̱nj mán so̱ꞌ maꞌ ―taj Pedró a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ne̱ cataj Jesucristó: ―Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan so̱ꞌ cuano̱ se vaa a̱j neꞌén ꞌu̱nj se vaa nii̱ cuanꞌ ga̱a ataa quisi̱j vi̱j caguáj toꞌloo, ne̱ vaꞌnu̱j ya̱ cata̱j so̱ꞌ rihaan yuvii̱ se vaa nuveé si̱j noco̱ꞌ manj mé so̱ꞌ a ―taj Jesucristó rihaan Pedró a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ga̱a ne̱ nucua̱j uxrá cataj Pedró rihaan Jesucristó, ne̱: ―Taj maꞌ. Caꞌve̱e se ticavi̱ꞌ yuvii̱ man níꞌ, tza̱j ne̱ daj chiha̱a̱ míj se̱ cataj ꞌu̱nj se vaa nuveé si̱j noco̱ꞌ mán so̱ꞌ mej maꞌ ―taj Pedró rihaan Jesucristó a. Ne̱ ase vaa cataj Pedró roꞌ, da̱nj cataj taranꞌ nij síí tucuꞌyón se‑na̱na̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ga̱a ne̱ caꞌanj Jesucristó ga̱ nij soꞌ nda̱a yoꞌó rej cuꞌna̱j Getsemaní, ne̱ cataj xnaꞌanj Jesucristó rihaan nij soꞌ a: ―Cane̱ soj nihánj, na̱ꞌvi̱j soj mán ꞌu̱nj, ne̱ caꞌa̱nj ꞌu̱nj, cachi̱nj ni̱ꞌyáj rihaan Réj a ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ne̱ nica̱j Jesucristó man Pedró do̱ꞌ, man Jacobo do̱ꞌ, man Juan do̱ꞌ, caꞌanj soꞌ, ne̱ guun cheꞌe̱ soꞌ quinanó ndoꞌo rá soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ga̱a ne̱ cataj soꞌ rihaan vaꞌnu̱j nij síí caꞌanj ga̱ soꞌ a: ―Nanó uxrá raj ado̱nj. Ma̱a̱n cheꞌé rej nanó ndoꞌo raj, quiꞌya̱j cavi̱ꞌ ꞌu̱nj, raj a. Quiꞌya̱j soj se ndoꞌo quina̱j soj nihánj, ne̱ se̱ cotoj soj maꞌ ―taj Jesucristó rihaan vaꞌnu̱j nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ga̱a ne̱ cavii soꞌ yaníj do̱j tzinꞌ, ne̱ caꞌanj ca̱yáán rno̱ soꞌ rihaan yoꞌóó, ne̱ cachíín niꞌya̱j soꞌ rihaan Diose̱ se vaa sese caꞌve̱e, ne̱ ca̱ráán raꞌa Diose̱ xráá soꞌ, se̱ gaa na̱nj quira̱nꞌ soꞌ sayuun a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Dan me se cataj soꞌ: ―Caꞌve̱e qui̱ꞌyáá so̱ꞌ cunuda̱nj, Ata̱j. Ca̱ráán raꞌá so̱ꞌ xráj, se̱ gaa na̱nj quira̱nꞌ uxrá ꞌu̱nj sayuun, tza̱j ne̱ sese ma̱ꞌán so̱ꞌ me rá qui̱ránꞌ ꞌu̱nj sayuun, ne̱ qui̱ꞌyáá so̱ꞌ nda̱a vaa me rá ma̱ꞌán so̱ꞌ, ne̱ se̱ quiꞌyáá so̱ꞌ nda̱a vaa me rá ma̱ꞌanj maꞌ ―taj Jesucristó, cachíín niꞌya̱j soꞌ rihaan Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ga̱a ne̱ canica̱j uún soꞌ caꞌnaꞌ soꞌ rihaan vaꞌnu̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ queneꞌen soꞌ se vaa cotoj cunuda̱nj nij soꞌ a. Ga̱a ne̱ cataj soꞌ rihaan Pedró a: ―Otoj so̱ꞌ, na̱nj Pedro. A̱ ꞌó orá ne gu̱un nu̱cuáá so̱ꞌ ni̱ꞌyaj so̱ꞌ a̱ maꞌ. Ya̱ naꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ma̱a̱n se ni̱ꞌyaj soj, ne̱ cachi̱nj niꞌya̱j soj rihaan Diose̱ se vaa ca̱ráán Diose̱ rihaan síí chre̱e se̱ caxríj síí chre̱e chrej chiꞌi̱i̱ rque soj á. ꞌO̱ se niha̱ꞌ rá soj quiꞌya̱j soj se sa̱ꞌ, tza̱j ne̱ ne uun nucua̱j soj maꞌ ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ga̱a ne̱ cavii uún Jesucristó, caꞌanj soꞌ, ne̱ cachíín niꞌya̱j uún soꞌ rihaan Diose̱, ne̱ cuya̱a̱n vaa nana̱ caꞌmii soꞌ rihaan Diose̱ ga̱ nana̱ caꞌmii soꞌ asi̱j cuaꞌa̱a doj a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ga̱a ne̱ canica̱j uún soꞌ caꞌnaꞌ soꞌ, ne̱ queneꞌen soꞌ se vaa cotoj uún vaꞌnu̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ꞌO̱ se caꞌnaꞌ ndoꞌo nej rihaan nij soꞌ a. Ne̱ ne nari̱ꞌ nij soꞌ nana̱ caꞌmi̱i̱ nij soꞌ rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ga̱a ne̱ corá me se caꞌnaꞌ uún soꞌ rej ma̱n vaꞌnu̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ cataj soꞌ: ―Caꞌve̱e coto̱j soj caꞌve̱e nara̱a̱n rá soj caꞌve̱e sese vaa yaꞌnúj rihaan soj á. Ni̱ꞌyaj soj, ne̱ nihánj me se quisíj orá tacuachén yoꞌo̱ soꞌ manj rihaan síí tumé ndoꞌo cacunꞌ, cheꞌé se mé ꞌu̱nj síí caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Na̱xagaa soj, caꞌa̱nj níꞌ na̱nj ei. Ni̱ꞌyaj soj nedi̱ꞌ. ꞌNaꞌ síí ta̱cuachén manj rihaan síí ta̱j riꞌyunj manj na̱nj chugua̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Dan me se nicu̱nꞌ Jesucristó caꞌmii soꞌ, ne̱ nu̱ꞌ caꞌnaꞌ síí cuꞌna̱j Judas yoꞌo̱ tuviꞌ chuvi̱j nij síí tucuꞌyón se‑na̱na̱ Jesucristó, ne̱ caꞌnaꞌ uxrá yuvii̱ ga̱ soꞌ, ne̱ nica̱j nij yuvii̱ neê espadá do̱ꞌ, chruun do̱ꞌ a. Dan me se nij yuvii̱ caꞌnéé nij xrej ata̱ suun noco̱o doj do̱ꞌ, nij yuvii̱ caꞌnéé nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés do̱ꞌ, nij yuvii̱ caꞌnéé nij síí uun chij rihaan nij yuvii̱ israelitá do̱ꞌ, me nij yuvii̱ caꞌnaꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ne̱ síí cuꞌna̱j Judas cataj xnaꞌanj rihaan nij yuvii̱ se vaa da̱j quiꞌya̱j soꞌ ga̱ Jesucristó, ga̱a ne̱ cunu̱u ya̱a̱n nij yuvii̱ man Jesucristó, ne̱ cataj soꞌ: ―Síí ru̱tuꞌvaj roꞌ, soꞌ me síí qui̱taꞌaa soj cuaj á. Raan cano̱ soj man soꞌ, caꞌa̱nj soj á ―taj síí cuꞌna̱j Judas a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ga̱a ne̱ nu̱ꞌ cuchiꞌ soꞌ cuaj rihaan Jesucristó, ne̱ cataj soꞌ: ―Maestro ―taj soꞌ, ne̱ nu̱ꞌ cachrón tuꞌva̱ soꞌ xruu̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ga̱a ne̱ cuchiꞌ nij yuvii̱ rihaan Jesucristó, ne̱ quitaꞌaa nij yuvii̱ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ne̱ yoꞌo̱ síí nicu̱nꞌ ga̱ Jesucristó me se quirii soꞌ taneê soꞌ neê espadá, ne̱ goꞌ soꞌ neê espadá yoꞌ raa̱ yoꞌo̱ se‑mo̱zó xrej ata̱ suun noco̱o doj, ne̱ veé dan güéj nu̱ꞌ xréé mozó yoꞌ, quiꞌyaj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ga̱a ne̱ cataj Jesucristó rihaan nij yuvii̱ a: ―Me cheꞌé nica̱j soj neê espadá nica̱j soj chruun nica̱j soj, caꞌnaꞌ soj ga̱. Síí itu̱u̱ mé ꞌu̱nj, rá soj naꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ne̱ ꞌo̱ se guun queꞌe̱e̱ güii cayáán ꞌu̱nj rá nuvií noco̱o, tucuꞌyón ꞌu̱nj se‑na̱na̱j rihaan soj, tza̱j ne̱ ne qui̱taꞌaa soj manj maꞌ. Tza̱j ne̱ nihánj me se qui̱ránꞌ ꞌu̱nj nu̱ꞌ se vaa taj nana̱ no̱ rihaan danj Diose̱ a ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ga̱a ne̱ tanáj cunuda̱nj nij síí tucuꞌyón se‑na̱na̱ Jesucristó man soꞌ, ne̱ cunánj nij soꞌ, caꞌanj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ne̱ vaa ꞌo̱ síí tachru̱u̱ noco̱ꞌ xcó Jesucristó, ne̱ o̱rúnꞌ yatzíj mantá nique̱e̱ soꞌ, ne̱ quitaꞌaa nij yuvii̱ man soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ga̱a ne̱ tanáj soꞌ yatzíj mantá raꞌa nij yuvii̱, cunánj soꞌ, ne̱ cánj u̱u̱n vaa soꞌ, cunánj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Dan me se nij síí quitaꞌaa man Jesucristó me se nica̱j nij soꞌ man Jesucristó caꞌanj nij soꞌ rihaan síí ya̱nj xrej ata̱ suun noco̱o doj, ga̱a ne̱ cunuu chre̱ꞌ yoꞌó nij xrej ata̱ suun noco̱o doj do̱ꞌ, nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan nij yuvii̱ do̱ꞌ, nij síí uun chij do̱ꞌ, rej mán nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ne̱ ga̱nꞌ ga̱nꞌ canocoꞌ síí cuꞌna̱j Pedró xcó Jesucristó, ne̱ cuchiꞌ soꞌ rihaan veꞌ ya̱nj xrej ata̱ suun noco̱o doj yoꞌ, ne̱ catúj soꞌ rá veꞌ, ne̱ caꞌanj ca̱yáán soꞌ ga̱ nij se‑mo̱zó xrej ma̱n rá veꞌ, ti̱naguu̱n soꞌ raꞌa soꞌ rihaan yaꞌan a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Dan me se nanoꞌ nij xrej ata̱ suun noco̱o doj nanoꞌ nij cuese̱ nanoꞌ man yuvii̱ cata̱j xnaꞌanj cheꞌé cacunꞌ tumé Jesucristó a. Me rá nij soꞌ nari̱ꞌ nij soꞌ cacunꞌ cuta̱ꞌ nij soꞌ xráá Jesucristó, ne̱ cavi̱ꞌ Jesucristó, rá nij soꞌ a. Tza̱j ne̱ nuviꞌ cacunꞌ tumé Jesucristó nariꞌ nij soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ꞌO̱ se cuchiꞌ uxrá síí ne̱ rihaan nij cuese̱ caꞌmii ne̱ nij soꞌ, tza̱j ne̱ ino̱ vaa nana̱ caꞌmii ꞌo̱ ꞌo̱ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ga̱a ne̱ canicunꞌ yoꞌó do̱j síí ne̱ uún, ne̱ guun rá nij soꞌ cuta̱ꞌ nij soꞌ cacunꞌ xráá Jesucristó, ne̱ dan me se cataj nij soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Cuno núj se vaa cataj Jesucristó se vaa: “ꞌU̱nj me síí ta̱cuanee nuvií noco̱o nihánj nuvií cuneꞌ yuvii̱, ne̱ rque vaꞌnu̱j güii cune̱ꞌ ꞌu̱nj yoꞌoj uún, tza̱j ne̱ nuveé nu̱vií cune̱ꞌ maꞌa̱n yuvii̱ me nuvií cune̱ꞌ ꞌu̱nj a̱ man ado̱nj”, taj Jesucristó cuno núj ei ―taj síí ne̱ niꞌya̱j nij soꞌ man Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","tza̱j ne̱ nda̱a se‑na̱na̱ nij soꞌ me se ne ꞌo̱ cuya̱a̱n vaa nana̱ caꞌmii ꞌo̱ ꞌo̱ nij soꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ga̱a ne̱ canicunꞌ xrej ata̱ suun noco̱o doj tanu̱u̱ yoꞌó nij síí ma̱n rá veꞌ yoꞌ, ne̱ xnáꞌanj soꞌ man Jesucristó, cataj soꞌ: ―Me cheꞌé ne aꞌmii so̱ꞌ ga̱. Da̱j vaa nana̱ nihánj nana̱ aꞌmii ro̱j síí nihánj cheꞌé so̱ꞌ ga̱ ―taj soꞌ, xnáꞌanj soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tza̱j ne̱ dínj táá Jesucristó, ne caꞌmi̱i̱ soꞌ a̱ doj nana̱ a. Ga̱a ne̱ xnáꞌanj uún xrej ata̱ suun noco̱o doj man Jesucristó, ne̱: ―So̱ꞌ me taꞌníí Diose̱ síí ti̱nanii man yuvii̱ rihaan sayuun naꞌ ―taj soꞌ, xnáꞌanj soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Veé da̱nj vaa ya̱ ei. Ne̱ queneꞌe̱n soj se vaa quita̱j ꞌu̱nj rej nuva̱ꞌ Diose̱ síí nucua̱j ndoꞌo á. Ne̱ queneꞌe̱n uún soj se vaa caꞌna̱ꞌ uún ꞌu̱nj rihaan chumii̱ nihánj, ne̱ quita̱j ꞌu̱nj xráá ngaa xta̱ꞌ caꞌna̱j ado̱nj ―taj Jesucristó rihaan xrej ata̱ suun noco̱o doj yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ga̱a ne̱ caꞌmaan rá xrej yoꞌ, ne̱ cutzinꞌ xrej yoꞌ saga̱nꞌ maꞌa̱n xrej, ne̱ cataj xrej rihaan tuviꞌ xrej a: ―Ni̱ꞌyaj soj vi̱j. Se̱ cachiin doj síí caꞌna̱ꞌ cata̱j xnaꞌanj rihaan níꞌ cheꞌé cacunꞌ tumé síí nihánj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ne̱ cuno soj nana̱ quij caꞌmii soꞌ se vaa quita̱j maꞌa̱n soꞌ rej xꞌnu̱j Diose̱ naꞌ. A̱j cuno soj chugua̱nj. Ne̱ da̱j quiꞌya̱j níꞌ man soꞌ, rá soj ga̱ ―taj xrej, xnáꞌanj xrej man nij tuviꞌ xrej a. Ga̱a ne̱ cunuda̱nj nij soꞌ cutaꞌ cacunꞌ xráá Jesucristó se vaa no̱ xcúún Jesucristó cavi̱ꞌ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ga̱a ne̱ guun cheꞌe̱ taꞌa̱j nij soꞌ quirii talúj nij soꞌ man Jesucristó, ne̱ caráán nij soꞌ yatzíj rihaan Jesucristó, ne̱ goꞌ nij soꞌ man Jesucristó, ne̱ cataj nij soꞌ: ―Ra̱cuíj Diose̱ mán so̱ꞌ cata̱j xnaꞌanj so̱ꞌ rihaan núj me síí goꞌ mán so̱ꞌ vi̱j ―taj nij soꞌ, tihaꞌ yuꞌunj nij soꞌ man Jesucristó a. Ne̱ nica̱j nij tanuu man soꞌ, ne̱ goꞌ nij tanuu chruun xráá soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Veé dan, ne̱ ya̱nj Jesucristó ga̱ yoꞌó nij soꞌ rá veꞌ, ne̱ ya̱nj síí cuꞌna̱j Pedró rej rque̱ doj rej rihaan veꞌ yoꞌ a. Ga̱a ne̱ caꞌnaꞌ yoꞌo̱ mozó cha̱na̱ nu̱u̱ rihaan xrej ata̱ suun noco̱o doj, ");
INSERT INTO trcNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ne̱ queneꞌen noꞌ man Pedró ga̱a tinaguu̱n Pedró raꞌa Pedró rihaan yaꞌan a. Ga̱a ne̱ niꞌya̱j uxrá mozó cha̱na̱ yoꞌ man Pedró, ga̱a ne̱ cataj noꞌ: ―Ne̱ ma̱ꞌán so̱ꞌ me yoꞌo̱ síí cachéé ga̱ Jesucristó síí cavii chumanꞌ Nazaret á ―taj mozó cha̱na̱ yoꞌ rihaan Pedró a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","―Taj maꞌ. Ne unó ꞌu̱nj me taj so̱ꞌ maꞌ ―taj Pedró rihaan mozó cha̱na̱, ga̱a ne̱ curiha̱nj soꞌ, ne̱ canicunꞌ soꞌ rihaan chingá a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ga̱a ne̱ queneꞌen mozó cha̱na̱ se vaa nicu̱nꞌ Pedró rihaan chingá, ne̱ guun cheꞌe̱ noꞌ caꞌmii noꞌ rihaan nij yuvii̱ nicu̱nꞌ rihaan chingá ga̱ Pedró, cataj noꞌ: ―Síí nihánj me yoꞌo̱ nij síí cachéé ga̱ Jesucristó asuun asán ―taj mozó cha̱na̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ga̱a ne̱ cataj uún Pedró se vaa ne neꞌen soꞌ man Jesucristó a. Dan me se corá nii me se cataj nij síí nicu̱nꞌ ga̱ Pedró rihaan Pedró a: ―Ya̱ ya̱ yoꞌo̱ síí cachéé ga̱ Jesucristó mé so̱ꞌ ei. ꞌO̱ se si̱j cavii estadó Galilea mé so̱ꞌ chugua̱nj ―taj nij soꞌ rihaan Pedró a. ");
INSERT INTO trcNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ga̱a ne̱ guun cheꞌe̱ Pedró nucua̱j doj caꞌmii Pedró, cataj Pedró se vaa caꞌve̱e quiꞌya̱j Diose̱ sayuun man soꞌ sese nuveé na̱na̱ ya̱ me nana̱ aꞌmii soꞌ, ne̱ cataj soꞌ: ―Ne neꞌenj man snóꞌo nihánj síí aꞌmii soj cheꞌé a̱ maꞌ ―taj uún Pedró, ");
INSERT INTO trcNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ga̱a ne̱ nu̱ꞌ quisíj vi̱j caguáj toꞌloo a. Ga̱a ne̱ nanuj rá Pedró nda̱a vaa cataj Jesucristó rihaan soꞌ quii se vaa ga̱a ataa quisi̱j vi̱j caguáj toꞌloo, ne̱ vaꞌnu̱j cata̱j Pedró se vaa nuveé si̱j noco̱ꞌ man Jesucristó me maꞌa̱n Pedró a. Ga̱a ne̱ guun cheꞌe̱ Pedró taꞌvee ndoꞌo Pedró a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ga̱a ne̱ rej ranga̱ꞌ cunuu chre̱ꞌ nij xrej ata̱ suun noco̱o doj do̱ꞌ, nij síí uun chij do̱ꞌ, nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés do̱ꞌ, cunuda̱nj nij cuese̱ do̱ꞌ, quiꞌyaj nij soꞌ juntá, ga̱a ne̱ numíj nij soꞌ man Jesucristó, ne̱ nica̱j nij soꞌ man Jesucristó caꞌanj nij soꞌ rihaan síí cuꞌna̱j Pilato, ne̱ tacuachén nij soꞌ man Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ga̱a ne̱ xnáꞌanj síí cuꞌna̱j Pilato man Jesucristó, cataj soꞌ: ―So̱ꞌ me síí nica̱j suun rey uun chij rihaan nij yuvii̱ israelitá naꞌ ―taj soꞌ, xnáꞌanj soꞌ man Jesucristó a. ―Vej ei ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ne̱ cutaꞌ ndoꞌo nij xrej ata̱ suun noco̱o doj cacunꞌ xráá Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ga̱a ne̱ xnáꞌanj uún síí cuꞌna̱j Pilato man Jesucristó, cataj soꞌ: ―Me cheꞌé ne aꞌmii so̱ꞌ ga̱. Nihánj me se utaꞌ uxrá nii cacunꞌ xráá so̱ꞌ ei ―taj síí cuꞌna̱j Pilato rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tza̱j ne̱ yu̱u̱n cheꞌe̱ ne caꞌmi̱i̱ Jesucristó a̱ doj nana̱ rihaan soꞌ, ne̱ caráyaꞌa̱nj uxrá síí cuꞌna̱j Pilato cheꞌé yan quiꞌyaj soꞌ da̱nj a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ne̱ vaa yoꞌo̱ tucuáán noco̱ꞌ síí cuꞌna̱j Pilato se vaa rii soꞌ man yoꞌo̱ yoꞌo̱ síí ꞌni̱j tagaꞌ ꞌo̱ ꞌo̱ chaꞌanj pascuá, ne̱ tinavij u̱u̱n soꞌ cacunꞌ tumé síí uriha̱nj tagaꞌ yoꞌ a. Me maꞌa̱n ꞌo̱ síí ꞌni̱j tagaꞌ achíín nij yuvii̱ se vaa quiri̱i̱ soꞌ, ne̱ caꞌve̱e quiꞌya̱j soꞌ nda̱a vaa taj nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Dan me se vaa ꞌo̱ síí cuꞌna̱j Barrabás ꞌni̱j tagaꞌ ga̱ yoꞌó nij síí guun rá cunu̱ꞌ ga̱ gobiernó, ne̱ nij soꞌ me se ga̱a cunuꞌ nij soꞌ ga̱ gobiernó ne̱ ticaviꞌ ndoꞌo nij soꞌ yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Dan me se cavii nij yuvii̱ israelitá, ne̱ guun cheꞌe̱ nij soꞌ cachíín nij soꞌ man síí cuꞌna̱j Pilato se vaa quiri̱i̱ soꞌ man ꞌo̱ síí ꞌni̱j tagaꞌ nda̱a vaa uꞌyón soꞌ ꞌyaj soꞌ cheꞌé nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ga̱a ne̱ xnáꞌanj síí cuꞌna̱j Pilato man nij yuvii̱, cataj soꞌ: ―Ne̱ me rá soj quiri̱i̱ ꞌu̱nj man síí nica̱j suun rey uun chij rihaan soj si̱j israelitá naꞌ ―taj soꞌ, xnáꞌanj soꞌ man nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Da̱nj caꞌmii soꞌ, neꞌen soꞌ se vaa ma̱a̱n cheꞌé se guun xco̱j ruva̱a̱ rá nij xrej ata̱ suun noco̱o doj me tacuachén nij xrej man Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tza̱j ne̱ nij xrej ata̱ suun noco̱o doj me se cataj xnaꞌanj nij soꞌ rihaan nij yuvii̱ se vaa quiri̱i̱ síí cuꞌna̱j Pilato man síí cuꞌna̱j Barrabás tagaꞌ quiꞌya̱j nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ga̱a ne̱ xnáꞌanj uún síí cuꞌna̱j Pilato man nij yuvii̱, cataj soꞌ: ―Cheꞌé se me rá soj quiri̱i̱ ꞌu̱nj man síí cuꞌna̱j Barrabás rihaan soj, ne̱ cheꞌé dan da̱j qui̱ꞌyáj man síí tu̱cuꞌnáj soj síí nica̱j suun rey uun chij rihaan soj ga̱ ―taj soꞌ, xnáꞌanj soꞌ man nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ga̱a ne̱ caguáj uún nij yuvii̱, cataj nij yuvii̱: ―Cavi̱ꞌ soꞌ rihaan rcutze̱, qui̱ꞌyáá so̱ꞌ ei ―taj nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","―Tza̱j ne̱ me cacunꞌ tumé soꞌ ga̱ ―taj síí cuꞌna̱j Pilato, xnáꞌanj soꞌ man nij yuvii̱ a. Tza̱j ne̱ doj a̱ caguáj nij yuvii̱, cataj nij yuvii̱: ―Cavi̱ꞌ soꞌ rihaan rcutze̱, qui̱ꞌyáá so̱ꞌ cuaj ei. ―Da̱nj ina̱nj caguáj nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ne̱ síí cuꞌna̱j Pilato me se guun rá soꞌ quiꞌya̱j soꞌ nda̱a vaa no̱ xcúún soꞌ quiꞌya̱j soꞌ cheꞌé nij yuvii̱, ne̱ cheꞌé dan quirii soꞌ man síí cuꞌna̱j Barrabás tagaꞌ cheꞌé nij yuvii̱, ne̱ goꞌ nij tanuu cuartá xráá Jesucristó, quiꞌyaj soꞌ, ne̱ tacuachén soꞌ man Jesucristó rihaan nij tanuu cheꞌé rej cachro̱n nij tanuu man Jesucristó rihaan rcutze̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ga̱a ne̱ caꞌanj nica̱j nij tanuu man Jesucristó rá veꞌ tucuá síí nica̱j suun gobernador, ga̱a ne̱ canacúún nij tanuu man taranꞌ nij tuviꞌ tanu̱u nij soꞌ cunu̱u chre̱ꞌ taranꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ga̱a ne̱ nanuû Jesucristó saga̱nꞌ rey yatzíj tintá, quiꞌyaj nij tanuu, ne̱ quiꞌyaj nij soꞌ cachriin tanj, cutaꞌ nij soꞌ raa̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ga̱a ne̱ guun cheꞌe̱ nij tanuu caguáj nij tanuu rihaan Jesucristó, cataj nij tanuu: ―Ya̱ ya̱ si̱j nica̱j suun rey rii taꞌngaꞌ rihaan nij yuvii̱ israelitá mé so̱ꞌ ei ―taj nij soꞌ, tihaꞌ nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ga̱a ne̱ goꞌ nij soꞌ vará raa̱ Jesucristó, ne̱ quirii talúj nij soꞌ man Jesucristó, ne̱ canicunꞌ ru̱j nij soꞌ rihaan Jesucristó, ne̱ quiꞌyaj nij soꞌ nda̱a vaa ꞌyaj yuvii̱ naꞌvíj rihaan yaꞌanj a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Síj caꞌngaꞌ naco̱o̱ nij soꞌ niꞌya̱j nij soꞌ man Jesucristó, ga̱a ne̱ quirii uún nij soꞌ saga̱nꞌ rey yatzíj tintá nu̱u̱ Jesucristó, ne̱ naꞌnéé uún nij soꞌ saga̱nꞌ uún Jesucristó man uún soꞌ, ga̱a ne̱ nica̱j nij soꞌ man Jesucristó cavii nij soꞌ caꞌanj nij soꞌ yan cachro̱n nij soꞌ man Jesucristó rihaan rcutze̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Dan me se ga̱a va̱j nij tanuu ga̱ Jesucristó, ne̱ ꞌnaꞌ nique yoꞌo̱ síí cuꞌna̱j Simón síí cavii chumanꞌ Cirene rej tacaan, ne̱ soꞌ me se rej ro̱j síí cuꞌna̱j Alejandro ga̱ Rufo me soꞌ, ne̱ dan me se quitaꞌaa nij tanuu man soꞌ, ne̱ quiꞌyaj uxrá nij tanuu fuerzá man síí cuꞌna̱j Simón yoꞌ ca̱ta̱ soꞌ rcutze̱ cano̱ Jesucristó rihaan a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Dan me se nica̱j nij tanuu man Jesucristó caꞌanj nij tanuu tacaan cuꞌna̱j Gólgota, ne̱ nana̱ “Gólgota” roꞌ, taj Tacaan Cúú Yave̱ Xnangá a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ga̱a ne̱ rqué nij tanuu do̱j na vinó nachej ga̱ na e̱ꞌ cuꞌna̱j mirra man Jesucristó coꞌo̱ soꞌ a. Tza̱j ne̱ ne coꞌo̱ soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Veé dan, ne̱ cachrón nij tanuu man Jesucristó rihaan rcutze̱, ne̱ tico tixaj nij soꞌ cheꞌé saga̱nꞌ Jesucristó me síí quiꞌya̱j canaán ꞌo̱ ꞌo̱ taꞌa̱j saga̱nꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Dan me se agaꞌ u̱u̱n rej xta̱ꞌ güii me cachrón nij tanuu man Jesucristó rihaan rcutze̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ne̱ cachrón nij tanuu letrá rihaan ꞌo̱ rcuchra̱ꞌ, ne̱ taj xnaꞌanj letrá yoꞌ me cheꞌé caviꞌ Jesucristó, ne̱: “Síí nihánj me síí nica̱j suun rey uun chij rihaan nij yuvii̱ israelitá a”, taj letrá yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ga̱a ne̱ cachrón nij tanuu man yavíj snóꞌo rihaan yavíj rcutze̱ yoꞌ, ne̱ yavíj ro̱j soꞌ me síí itu̱u̱ a. Dan me se nicu̱nꞌ yoꞌo̱ soꞌ rej nuva̱ꞌ Jesucristó, ne̱ nicu̱nꞌ yoꞌó soꞌ rej nichru̱un Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ne̱ veé da̱nj quisíj ya̱ nu̱ꞌ nana̱ no̱ rihaan danj Diose̱ nana̱ taj: “Guun rá nii se vaa yoꞌo̱ tuviꞌ nij síí tumé cacunꞌ me soꞌ, rá nii a”, taj se‑na̱na̱ Diose̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ga̱a ne̱ cachén yuvii̱ rej nicu̱nꞌ Jesucristó, ne̱ caꞌmii chiꞌi̱i̱ ndoꞌo nij yuvii̱ niꞌya̱j nij yuvii̱ man Jesucristó a. Dan me se tucunó nij yuvii̱ raa̱ nij yuvii̱, cataj nij yuvii̱: ―Nihánj táá so̱ꞌ si̱j guun rá ta̱cuanee man nuvií noco̱o ne̱ cune̱ꞌ yoꞌó nuvií noco̱o rque vaꞌnu̱j güii naꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ti̱nanii so̱ꞌ mán so̱ꞌ rihaan rcutze̱, ne̱ nani̱j so̱ꞌ rihaan yoꞌóó ya̱j vi̱j ―taj nij yuvii̱ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ne̱ ase vaa quiꞌyaj nij yuvii̱ roꞌ, da̱nj quiꞌyaj uún nij xrej ata̱ suun noco̱o doj do̱ꞌ, nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés do̱ꞌ, caꞌmii chiꞌi̱i̱ nij soꞌ rihaan tuviꞌ nij soꞌ niꞌya̱j nij soꞌ man Jesucristó, ne̱ cataj nij soꞌ: ―Ti̱nanii síí nihánj man yoꞌó yuvii̱ rihaan sayuun, rá soꞌ, tza̱j ne̱ ne gu̱un nucua̱j soꞌ ti̱nanii soꞌ man maꞌa̱n soꞌ rihaan rcutze̱ danj. ");
INSERT INTO trcNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Sese ya̱ ya̱ si̱j caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun me soꞌ do̱ꞌ, sese ya̱ ya̱ si̱j nica̱j suun rey uun chij rihaan níꞌ si̱j israelitá me soꞌ do̱ꞌ, ne̱ nani̱j soꞌ cuano̱ rihaan yoꞌóó, ne̱ queneꞌe̱n níꞌ, ne̱ cuchuma̱n rá níꞌ ni̱ꞌyaj níꞌ man soꞌ ado̱nj ―taj nij soꞌ, chiꞌi̱i̱ ndoꞌo caꞌmii nij soꞌ niꞌya̱j nij soꞌ man Jesucristó a. Ne̱ ro̱j síí itu̱u̱ nicu̱nꞌ rihaan rcutze̱ rej xꞌnu̱j Jesucristó me se caꞌmii ro̱j soꞌ nana̱ nij rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Veé dan, ne̱ caxu̱j, ne̱ yu̱u̱n cheꞌe̱ guun rmi̱ꞌ rihaan chumii̱, ne̱ yoꞌo̱ guun rmi̱ꞌ chumii̱ nda̱a quisíj agaꞌ vaꞌnu̱j rej anocoꞌ güii a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Veé dan, ne̱ quisíj agaꞌ vaꞌnu̱j, ga̱a ne̱ nucua̱j ndoꞌo caguáj Jesucristó, cataj soꞌ: ―Eloi, Eloi, lama sabactani ―taj soꞌ, caguáj soꞌ xnaꞌánj aꞌmii maꞌa̱n soꞌ a. Ne̱ nana̱ caguáj soꞌ taj: “Diose̱ síí noco̱ꞌ ꞌu̱nj mé so̱ꞌ á. Me cheꞌé tanáj u̱u̱n so̱ꞌ mán ꞌu̱nj ga̱”, taj nana̱ caguáj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ne̱ cuno taꞌa̱j nij síí nicu̱nꞌ rej xꞌnu̱j Jesucristó nana̱ caguáj soꞌ, tza̱j ne̱ ne cuno̱ nij soꞌ me taj Jesucristó a̱ maꞌ. Ma̱a̱n se: ―Ni̱ꞌyaj so̱ꞌ ei. Nacúún síí nihánj man síí cuꞌna̱j Elías tado̱nj ―taj nij soꞌ rihaan tuviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ga̱a ne̱ cunánj yoꞌo̱ soꞌ, ne̱ caraa soꞌ na vinó yu̱u̱ rque ꞌo̱ yataa̱n esponja, ne̱ cutaꞌ soꞌ raa̱ yoꞌo̱ vará, ne̱ ruꞌmaan soꞌ yataa̱n tuꞌva Jesucristó, ne̱ coꞌo Jesucristó na yu̱u̱ yoꞌ, quiꞌyaj soꞌ, ne̱ cataj síí quiꞌyaj da̱nj: ―Dínj quiꞌya̱j soj á. Queneꞌe̱n níꞌ sese caꞌna̱ꞌ síí cuꞌna̱j Elías ta̱nanij síí cuꞌna̱j Elías man soꞌ rihaan yoꞌóó ei ―taj soꞌ rihaan tuviꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ga̱a ne̱ sca̱ꞌ caguáj Jesucristó, ne̱ caviꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ga̱a ne̱ quisinꞌ yatzíj mantá cortiná noco̱ꞌ rá nuvií noco̱o yoꞌ nda̱a rej raa̱, ne̱ ꞌo̱ quinij caꞌanj nda̱a tacóó yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Veé dan, ne̱ nicu̱nꞌ tanuu capitán rihaan Jesucristó, ne̱ queneꞌen soꞌ nu̱ꞌ se vaa guun ga̱a caviꞌ Jesucristó, ne̱ nda̱a dan asuun ga̱a xcaj soꞌ cuentá se vaa ya̱ uxrá taꞌni̱j Diose̱ me Jesucristó, ne̱ dan me se cataj soꞌ: ―Ya̱ taꞌni̱j Diose̱ me snóꞌo nihánj tado̱nj ―taj tanuu capitán yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ne̱ ga̱nꞌ doj nicunꞌ queꞌe̱e̱ chana̱, niꞌya̱j u̱u̱n nij chana̱ man Jesucristó a. Yoꞌo̱ noꞌ me chana̱ cuꞌna̱j Mariá Magdalena, ne̱ yoꞌó noꞌ me chana̱ cuꞌna̱j Mariá nii síí cuꞌna̱j Jacobo Cuni̱j ga̱ síí cuꞌna̱j José a. Ne̱ yoꞌó noꞌ me chana̱ cuꞌna̱j Salomé a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Dan me se ga̱a va̱j Jesucristó estadó Galilea, ne̱ quiꞌyaj suun nij chana̱ cheꞌé Jesucristó a. Ne̱ vaa queꞌe̱e̱ doj chana̱ uún níí caꞌanj chumanꞌ Jerusalén ga̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Dan me se rej ataꞌ güii me yoꞌ, ne̱ güii no̱ xcúún nij yuvii̱ israelitá quiꞌya̱j chuvi̱i nij soꞌ cheꞌé güii aꞌyuj güii naránj rá nij soꞌ me yoꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ne̱ cheꞌé dan caꞌnaꞌ yoꞌo̱ síí cuꞌna̱j José síí ne̱ chumanꞌ Arimatea, ne̱ yoꞌo̱ síí sa̱ꞌ uun chij rihaan nij yuvii̱ israelitá me soꞌ, ne̱ síí me ndoꞌo rá gu̱un chij Diose̱ rihaan chumii̱ nihánj me uún soꞌ a. Dan me se quisíj rá soꞌ, ne̱ catúj soꞌ rihaan síí cuꞌna̱j Pilato, ne̱ cachíín niꞌya̱j soꞌ rihaan síí cuꞌna̱j Pilato se vaa caꞌve̱j síí cuꞌna̱j Pilato cachi̱nꞌ soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Dan me se caráyaꞌa̱nj ndoꞌo síí cuꞌna̱j Pilato nana̱ se vaa a̱j caviꞌ Jesucristó, ga̱a ne̱ canacúún soꞌ caꞌna̱ꞌ tanuu capitán rihaan soꞌ, ne̱ xnáꞌanj soꞌ man tanuu capitán sese ya̱ ya̱ caviꞌ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ga̱a ne̱ cataj tanuu capitán se vaa ya̱ ya̱ caviꞌ Jesucristó, ne̱ cheꞌé dan caꞌvej rá síí cuꞌna̱j Pilato ni̱caj síí cuꞌna̱j José man Jesucristó caꞌa̱nj cachi̱nj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ga̱a ne̱ xcaj síí cuꞌna̱j José yatzíj mantá, ga̱a ne̱ tananij soꞌ man Jesucristó, ne̱ nacutáj soꞌ yatzíj mantá xráá Jesucristó, ne̱ caxríj soꞌ man Jesucristó rque yuꞌuj gáán nii rque yuvej, ne̱ caráán soꞌ yuvej xi̱j tuꞌva yuꞌuj yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ne̱ queneꞌen chana̱ cuꞌna̱j Mariá Magdalena do̱ꞌ, chana̱ cuꞌna̱j Mariá nii síí cuꞌna̱j José do̱ꞌ, rej cachinꞌ soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ne̱ tiꞌnuu güii naránj rá nij yuvii̱ israelitá me se quiránj chana̱ cuꞌna̱j Mariá Magdalena do̱ꞌ, chana̱ cuꞌna̱j Mariá nii Jacobo do̱ꞌ, chana̱ cuꞌna̱j Salomé do̱ꞌ, yoꞌóó gunꞌ da̱j, cheꞌé rej caꞌa̱nj caxri̱i̱ nij noꞌ yoꞌóó gunꞌ da̱j man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ga̱a ne̱ taxre̱j cotungó me se caꞌanj vaꞌnu̱j nij chana̱ rej cachinꞌ nii man Jesucristó, ne̱ dan me se a̱j quisíj güii, ");
INSERT INTO trcNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ne̱ cataj nij chana̱ rihaan tuviꞌ chana̱, ne̱: ―Me síí quiri̱i̱ yaníj yuvej aráán tuꞌva yuꞌuj ga̱a ne̱ catu̱u̱ níꞌ ga̱ ―taj nij noꞌ, xnáꞌanj nij noꞌ man tuviꞌ nij noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ga̱a ne̱ niꞌya̱j nij chana̱, ne̱ queneꞌen nij chana̱ se vaa a̱j naj yaníj yuvej, ne̱ dan me se yuvej xi̱j ndoꞌo me yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ga̱a ne̱ catúj nij chana̱ rque yuꞌuj, ga̱a ne̱ queneꞌen nij chana̱ se vaa ya̱nj ꞌo̱ síí ya̱a̱n rej nuva̱ꞌ nij chana̱, ne̱ nuû soꞌ yatzíj xca̱a̱n catzi̱i̱, ne̱ caꞌanj ndoꞌo rá nij chana̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ga̱a ne̱ cataj síí ya̱a̱n rihaan nij chana̱ a: ―Taj cheꞌé caꞌa̱nj rá nij soj maꞌ. Nihánj me nanoꞌ nij soj man Jesucristó síí cavii chumanꞌ Nazaret síí cachrón nii rihaan rcutze̱, ne̱ soꞌ me se a̱j cunuu iꞌna̱ꞌ uún soꞌ ei. Ne̱ ni̱ꞌyaj soj rej cuchruj nii man soꞌ, ne̱ xca̱j soj cuentá se vaa nuviꞌ soꞌ naj nihánj a̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tana̱nj cavi̱i̱ soj cata̱j soj rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ do̱ꞌ, nda̱a rihaan Pedró do̱ꞌ, cata̱j soj: “Táá ya̱a̱n Jesucristó rihaan soj ꞌanj soꞌ estadó Galilea, ne̱ yoꞌ me rej queneꞌe̱n nij soj man soꞌ nda̱a vaa cataj maꞌa̱n soꞌ rihaan soj á”, cata̱j nij soj rihaan Pedró ga̱ yoꞌó nij síí tucuꞌyón se‑na̱na̱ soꞌ á ―taj síí ya̱a̱n rihaan vaꞌnu̱j nij chana̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ga̱a ne̱ curiha̱nj nij chana̱ rque yuꞌuj, ne̱ cunánj nij chana̱, caꞌanj nij noꞌ a. ꞌO̱ se caꞌanj ndoꞌo rá nij chana̱, ne̱ nda̱a riꞌíj man nij chana̱ a. Ne̱ ne caꞌve̱e caꞌmi̱i̱ nij noꞌ a̱ doj nana̱ rihaan a̱ ꞌó yuvii̱, cheꞌé se cuchuꞌviꞌ ndoꞌo nij noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Dan me se cunuu iꞌna̱ꞌ uún Jesucristó taxre̱j cotungó, ga̱a ne̱ curuviꞌ soꞌ asino ya̱a̱n rihaan chana̱ cuꞌna̱j Mariá Magdalena, ne̱ noꞌ me chana̱ quirii soꞌ chi̱j nana̱ chre̱e nimán asi̱j rque̱ doj a. ");
INSERT INTO trcNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Dan me se caꞌanj noꞌ rej ma̱n nij síí chéé ga̱ Jesucristó, ne̱ dan me se nanó ndoꞌo rá nij soꞌ, ne̱ taꞌvee nij soꞌ, ne̱ dan me se cataj xnaꞌanj noꞌ rihaan nij soꞌ se vaa vaa iꞌna̱ꞌ Jesucristó ne̱ queneꞌen noꞌ man Jesucristó, taj noꞌ, tza̱j ne̱ ne cuchuma̱n rá nij soꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Cachén doj, ga̱a ne̱ dan me se chéé vi̱j tuviꞌ nij síí tucuꞌyón se‑na̱na̱ Jesucristó rej tacaan, ne̱ curuviꞌ Jesucristó rihaan ro̱j soꞌ, tza̱j ne̱ ino̱ doj vaa soꞌ, ruviꞌ soꞌ, niꞌya̱j ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ga̱a ne̱ cavii ro̱j soꞌ uún, nataꞌ ro̱j soꞌ rihaan yoꞌó nij síí tucuꞌyón se‑na̱na̱ Jesucristó, tza̱j ne̱ nij soꞌ me se ne cuchuma̱n rá nij soꞌ se‑na̱na̱ ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Corá me se ga̱a yáán xa̱a̱n nij síí tucuꞌyón se‑na̱na̱ Jesucristó rihaan mesá, ne̱ curuviꞌ maꞌa̱n Jesucristó rihaan nij soꞌ, ne̱ cutaꞌ soꞌ cacunꞌ xráá nij soꞌ se vaa guun nichra̱j rá nij soꞌ ne̱ ne cuchuma̱n rá nij soꞌ se‑na̱na̱ nij síí queneꞌen man soꞌ ga̱a cunuu iꞌna̱ꞌ uún soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Caꞌa̱nj nij soj rihaan nu̱ꞌ cachra̱ꞌ chumii̱, ne̱ caꞌmi̱i̱ natáj soj se‑na̱na̱j nana̱ sa̱ꞌ rihaan cunuda̱nj nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ne̱ me maꞌa̱n ꞌo̱ síí cuchuma̱n rá se‑na̱na̱ soj ne̱ cata̱ꞌ ne, ne̱ soꞌ me síí quinani̱i̱ rihaan sayuun, tza̱j ne̱ síí naꞌvej rá cuchuma̱n rá se‑na̱na̱ soj me se quiꞌya̱j Diose̱ sayuun man soꞌ cheꞌé cacunꞌ tumé soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ne̱ nihánj me suun sa̱ꞌ noco̱o quiꞌya̱j nij síí cuchumán ya̱ rá niꞌya̱j manj, ne̱ dan me se quita̱j tuꞌva nij soꞌ se‑chu̱vií ꞌu̱nj, quiri̱i̱ nij soꞌ nana̱ chre̱e nimán yuvii̱, ne̱ caꞌmi̱i̱ nij soꞌ xnaꞌánj naca̱ xnaꞌánj ne neꞌen maꞌa̱n nij soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ne̱ maꞌa̱n raꞌa nij soꞌ qui̱taꞌaa nij soꞌ xcuáá yuva̱a̱, ne̱ caꞌve̱e se coꞌo̱ nij soꞌ se xna̱j, tza̱j ne̱ a̱ doj se̱ quiranꞌ nij soꞌ chiꞌii̱ maꞌ. Ne̱ cuta̱ꞌ raꞌa nij soꞌ xráá síí ranꞌ, ne̱ nahu̱un sa̱ꞌ nij síí ranꞌ yoꞌ a ―taj Jesucristó rihaan xa̱a̱n nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Dan me se quisíj caꞌmii Jesucristó nana̱ dan rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ, ga̱a ne̱ cavii soꞌ xta̱ꞌ, ga̱a ne̱ cayáán soꞌ rej nuva̱ꞌ Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ga̱a ne̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ me se caꞌanj caꞌmi̱i̱ natáj nij soꞌ se‑na̱na̱ soꞌ nu̱ꞌ nij chumanꞌ, ne̱ racuíj síí ꞌni̱j raꞌa man níꞌ man nij soꞌ, ne̱ dan me se cheꞌé suun sa̱ꞌ noco̱o quiꞌyaj nij soꞌ me se raan doj canocoꞌ nij yuvii̱ se‑na̱na̱ Jesucristó a. Veé da̱nj ga̱a̱ ya̱ ei.");
INSERT INTO trcNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Dan me se queꞌe̱e̱ uxrá yuvii̱ guun rá cachro̱n nica̱ nana̱ rihaan yanj cheꞌé nu̱ꞌ se vaa quiꞌyaj Jesucristó scaꞌnúj níꞌ asi̱j rque̱ doj a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Dan me se cachrón nij soꞌ nana̱ cataj xnaꞌanj nij síí queneꞌen cunuda̱nj se vaa quiꞌyaj Jesucristó asi̱j guun cheꞌe̱ soꞌ cayáán soꞌ rihaan chumii̱ nihánj, ne̱ nij síí queneꞌen roꞌ, me síí ata̱ suun nata̱ꞌ nana̱ yoꞌ rihaan nu̱ꞌ yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ne̱ ꞌu̱nj nihánj me síí tucuꞌyón uxrá, don caꞌvee narij cunuda̱nj rasu̱u̱n yoꞌ, ne̱ cheꞌé dan vaa cheꞌé cachro̱n nica̱ ꞌu̱nj cunuda̱nj se vaa quiꞌyaj Jesucristó rihaan yanj nihánj naya̱a̱ so̱ꞌ si̱j cuꞌna̱j Teófilo si̱j sa̱ꞌ ndoꞌo, raj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Na̱nj qui̱ꞌyáj, ga̱a ne̱ caꞌve̱e gu̱un ya̱ rá so̱ꞌ se vaa ya̱ vaa nu̱ꞌ nana̱ cataj xnaꞌanj nii rihaan so̱ꞌ cheꞌé Jesucristó ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ga̱a cayáán síí cuꞌna̱j Herodes síí nica̱j suun rey uun chij rihaan estadó Judea, ga̱a ne̱ ꞌo̱ xrej canicunꞌ rihaan yuvii̱ israelitá me ꞌo̱ síí cuꞌna̱j Zacarías, ne̱ cachéé soꞌ ga̱ ꞌo̱ taꞌa̱j nij xrej, ne̱ taꞌníí taꞌnij siꞌno̱ Abías me nij soꞌ a. Ne̱ nica̱ Zacarías me chana̱ cuꞌna̱j Elisabet, ne̱ taꞌni̱j ꞌo̱ xrej me noꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ne̱ síí ya̱nj sa̱ꞌ rihaan Diose̱ me ro̱j ni̱ca̱ ro̱j soꞌ, ne̱ sa̱ꞌ uxrá cuno ro̱j soꞌ nu̱ꞌ nij nana̱ me rá Diose̱ cuno̱ níꞌ, ne̱ nuviꞌ cacunꞌ tumé ro̱j soꞌ a̱ doj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tza̱j ne̱ taj va̱j taꞌníí ro̱j soꞌ, cheꞌé se chana̱ itu̱un me Elisabet ado̱nj. Ne̱ a̱j cachén ndoꞌo yoꞌ ne ro̱j ni̱ca̱ ro̱j soꞌ na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Dan me se ga̱a natúj nij taꞌníí taꞌnij siꞌno̱ Abías quiꞌya̱j suun nij soꞌ se‑su̱u̱n Diose̱, ");
INSERT INTO trcNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ne̱ ꞌo̱ güii quiriꞌ niꞌya̱j Zacarías catu̱u̱ soꞌ nuvií noco̱o cara̱a soꞌ squíí xlá rihaan yaꞌan a. ꞌO̱ se tucuáán noco̱ꞌ nij xrej me se daj a̱ güii tico tixaj nij soꞌ se‑chuvi̱i nij soꞌ, se vaa queneꞌe̱n nij soꞌ a̱ me síí quiri̱ꞌ niꞌya̱j cara̱a squíí rihaan yaꞌan a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Dan me se catúj Zacarías rque nuvií noco̱o, ne̱ xeꞌ nicunꞌ ꞌo̱ xꞌneꞌ yuvii̱, cachíín niꞌya̱j nij soꞌ rihaan Diose̱ ga̱a caraa Zacarías squíí rihaan yaꞌan a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Dan me se naquiꞌyaa ꞌo̱ se‑mo̱zó Diose̱ rihaan Zacarías, ne̱ nicu̱nꞌ soꞌ rej nuva̱ꞌ mesá altar acaa squíí a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Dan me se ga̱a queneꞌen Zacarías man se‑mo̱zó Diose̱, ga̱a ne̱ cuchuꞌviꞌ ndoꞌo soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tza̱j ne̱ cataj se‑mo̱zó Diose̱ rihaan soꞌ, ne̱: ―Se̱ cuchuꞌvíꞌ so̱ꞌ, man Zacarías. ꞌO̱ se a̱j cuno Diose̱ nana̱ cachíín ni̱ꞌyáá so̱ꞌ rihaan soꞌ, ne̱ cheꞌé dan cuchru̱j nica̱ so̱ꞌ Elisabet taꞌnij sno̱ꞌo so̱ꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Juan tu̱cuꞌnáj so̱ꞌ man soꞌ á. Gu̱un niha̱ꞌ ndoꞌo rá so̱ꞌ, ne̱ gu̱un niha̱ꞌ rá queꞌe̱e̱ yuvii̱ asa̱ꞌ caꞌngaa soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ꞌO̱ se taꞌníí so̱ꞌ me síí gu̱un síí sa̱ꞌ ndoꞌo rihaan Diose̱ na̱nj ado̱nj. Se̱ coꞌo soꞌ tziꞌ se̱ coꞌo soꞌ rinté se̱ coꞌo soꞌ maꞌ. Asi̱j güii ataa caꞌnga̱a̱ soꞌ, ne̱ gu̱un cheꞌe̱ Nimán Diose̱ yoꞌo̱ ca̱yáán Nimán Diose̱ ga̱ soꞌ na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ne̱ queꞌe̱e̱ síí israelitá ca̱nica̱j nimán canoco̱ꞌ uún man Diose̱ síí ꞌni̱j raꞌa man nij soꞌ, quiꞌya̱j taꞌníí so̱ꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Dan me se gu̱un soꞌ síí caꞌa̱nj suun rihaan Diose̱ ado̱nj. Asino taꞌníí so̱ꞌ gu̱un cheꞌe̱ caꞌmi̱i̱ natáj rihaan yuvii̱, ga̱a ne̱ caꞌmi̱i̱ síí caꞌne̱j Diose̱ man a. Da̱j se quiꞌyaj Nimán Diose̱, racuíj Nimán Diose̱ man síí cuꞌna̱j Elías ga̱a naá roꞌ, da̱nj quiꞌya̱j gue̱e̱ Nimán Diose̱, ra̱cuíj ndoꞌo soꞌ man taꞌníí so̱ꞌ a. Caꞌmi̱i̱ lu̱j yuvii̱ ga̱ taꞌníí yuvii̱, quiꞌya̱j soꞌ, natuna̱ nimán nij síí chiꞌi̱i̱ cuno̱ nij soꞌ rihaan Diose̱, quiꞌya̱j soꞌ na̱nj á. Juan me síí quiꞌya̱j, ne̱ cara̱yaꞌa̱nj nu̱ꞌ yuvii̱ cheꞌé se caꞌna̱ꞌ síí qui̱ꞌnij raꞌa man níꞌ ado̱nj. ―Nu̱ꞌ nana̱ nihánj cataj xnaꞌanj se‑mo̱zó Diose̱ rihaan Zacarías a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ga̱a ne̱ cataj Zacarías rihaan se‑mo̱zó Diose̱ a: ―Asa̱ꞌ caꞌve̱e cuchuma̱n raj se vaa ya̱ caꞌmii so̱ꞌ ga̱. Chii nga̱ mé ꞌu̱nj nihánj, ne̱ chana̱ chij me nica̱ ꞌu̱nj nihánj na̱nj á ―taj Zacarías rihaan se‑mo̱zó Diose̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ga̱a ne̱ cataj se‑mo̱zó Diose̱ rihaan Zacarías a: ―Gabriel síí nicu̱nꞌ rihaan Diose̱ mé ꞌu̱nj ado̱nj. Maꞌa̱n Diose̱ me síí caꞌnéé manj caꞌna̱j caꞌmi̱j ga̱ so̱ꞌ ado̱nj. Caꞌneꞌ soꞌ suun rihanj se vaa cata̱j xnaꞌanj ꞌu̱nj nana̱ sa̱ꞌ nihánj rihaan so̱ꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","tza̱j ne̱ ne cuchuma̱n rá so̱ꞌ nana̱ nihánj, ne̱ cheꞌé dan me gu̱un ya̱ꞌmií so̱ꞌ ado̱nj. A̱ ꞌó nana̱ se̱ caꞌvee caꞌmi̱i̱ so̱ꞌ nda̱a quisi̱j güii quisi̱j ya̱ nu̱ꞌ nana̱ nihánj nda̱a vaa cataj xnaꞌanj ꞌu̱nj rihaan so̱ꞌ ado̱nj. Ne̱ ya̱ quisi̱j nana̱ nihánj güii a̱j cachrón Diose̱ ado̱nj. ―Da̱nj cataj se‑mo̱zó Diose̱ rihaan Zacarías a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Dan me se xeꞌ mán nij yuvii̱, naꞌvi̱j nij yuvii̱ a̱ me orá cu̱riha̱nj Zacarías rque nuvií, ne̱ caráyaꞌa̱nj nij soꞌ se vaa guun ra̱a̱n soꞌ rque nuvií a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Dan me se ga̱a curiha̱nj soꞌ rque nuvií, ga̱a ne̱ ne caꞌve̱e caꞌmi̱i̱ soꞌ ga̱ nij soꞌ a̱ maꞌ. Cheꞌé dan xcaj nij soꞌ cuentá se vaa naquiꞌyaa ꞌo̱ rasu̱u̱n rihaan Zacarías, quiꞌyaj Diose̱, ga̱a nu̱u̱ soꞌ rque nuvií a. Da̱j doj raꞌa soꞌ tucunó soꞌ cheꞌé se yoꞌo̱ guun yaꞌmi̱i soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ga̱a cachén Zacarías se‑su̱u̱n Diose̱, ga̱a ne̱ quinanꞌ soꞌ tucuá soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Cachén do̱j güii, ga̱a ne̱ nariꞌ nica̱ soꞌ Elisabet ꞌo̱ neꞌej a. ꞌU̱nꞌ yavii cayáán noꞌ tucuá noꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ne̱ nuchruj ra̱a̱ noꞌ nana̱ nihánj a: “Ga̱ naá guun naꞌa̱j uxraj rihaan yuvii̱ cheꞌé se chana̱ itu̱un mej, tza̱j ne̱ nda̱a ya̱j racuíj Diose̱ manj á”. Da̱nj guun rá noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ga̱a quisíj vata̱nꞌ yavii cunuû rque Elisabet, ga̱a ne̱ caꞌnéé Diose̱ man se‑mo̱zó soꞌ síí cuꞌna̱j Gabriel caꞌa̱nj soꞌ nda̱a ꞌo̱ chumanꞌ na̱j rihaan estadó Galilea chumanꞌ cuꞌna̱j Nazaret a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ne̱ caꞌanj cata̱j xnaꞌanj soꞌ ꞌo̱ nana̱ rihaan ꞌo̱ chana̱ ya̱a̱n cuꞌna̱j Mariá a. A̱j guun ya̱ xca̱j ꞌo̱ síí cuꞌna̱j José man noꞌ, ne̱ ꞌo̱ taꞌníí taꞌnij siꞌno̱ síí guun chij ndoꞌo ga̱a naá síí cuꞌna̱j David me soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ga̱a ne̱ dan me se cuchiꞌ se‑mo̱zó Diose̱ rihaan Mariá, ne̱ cataj soꞌ: ―Ra̱cuíj Diose̱ mán so̱ꞌ á. ꞌO̱ se quiꞌyaj ndoꞌo Diose̱ se lu̱j cheꞌé so̱ꞌ, ne̱ yoꞌo̱ yáán Diose̱ ga̱ so̱ꞌ á. Sa̱ꞌ doj cavii uruún so̱ꞌ rihaan cunuda̱nj nij chana̱, quiꞌyaj Diose̱ a. ―Da̱nj cataj se‑mo̱zó Diose̱ rihaan Mariá a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tza̱j ne̱ caráyaꞌa̱nj Mariá nana̱ caꞌmii se‑mo̱zó Diose̱, ne̱ ne queneꞌe̱n noꞌ me cheꞌé caꞌmii soꞌ nana̱ vaa da̱nj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ga̱a ne̱ cataj uún se‑mo̱zó Diose̱ rihaan noꞌ a: ―Se̱ cuchuꞌvíꞌ so̱ꞌ, man María. Aranꞌ rá Diose̱ quiꞌya̱j Diose̱ se lu̱j cheꞌé so̱ꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nari̱ꞌ so̱ꞌ ꞌo̱ neꞌej, ne̱ cuchru̱j so̱ꞌ ꞌo̱ neꞌej sno̱ꞌo ado̱nj. Jesús tu̱cuꞌnáj so̱ꞌ man soꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Síí sa̱ꞌ ndoꞌo gu̱un soꞌ, ne̱ taꞌníí Diose̱ síí sa̱ꞌ ndoꞌo me soꞌ ado̱nj. Gu̱un soꞌ síí gu̱un chij rihaan níꞌ, quiꞌya̱j Diose̱ síí ꞌni̱j raꞌa man níꞌ a. Ase vaa guun chij xi̱i soꞌ síí cuꞌna̱j David rihaan soj si̱j israelitá ga̱a naá roꞌ, da̱nj quiꞌya̱j maꞌa̱n soꞌ gu̱un chij soꞌ rihaan soj nu̱ꞌ cavii nu̱ꞌ caꞌanj ado̱nj. ―Da̱nj cataj Gabriel rihaan Mariá a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ne̱ cataj Mariá rihaan se‑mo̱zó Diose̱, ne̱: ―Chana̱ ya̱a̱n mej á. Asa̱ꞌ caꞌve̱e cuchru̱j ꞌu̱nj neꞌej, rá so̱ꞌ ga̱ ―taj Mariá, xnáꞌanj noꞌ man se‑mo̱zó Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ga̱a ne̱ cataj se‑mo̱zó Diose̱ rihaan Mariá a: ―Ca̱yáán Nimán Diose̱ ga̱ so̱ꞌ, ne̱ ra̱cuíj Diose̱ síí nucua̱j ndoꞌo mán so̱ꞌ, ne̱ cheꞌé dan cuchru̱j so̱ꞌ neꞌej sa̱ꞌ rihaan Diose̱, ne̱ taꞌníí Diose̱ me neꞌej cuchru̱j so̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ne̱ xca̱j so̱ꞌ cuentá cheꞌé tuviꞌ cha̱na̱ so̱ꞌ Elisabet se vaa nda̱ꞌ se chana̱ itu̱un me noꞌ, taj nii, ne̱ nda̱ꞌ se chana̱ chij me noꞌ, tza̱j ne̱ a̱j quisíj vata̱nꞌ yavii nuû rque noꞌ cuano̱ na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Diose̱ me síí aꞌvee ꞌyaj cunuda̱nj a ―taj se‑mo̱zó Diose̱ rihaan Mariá a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ne̱ cataj Mariá rihaan se‑mo̱zó Diose̱ a: ―Dan me se na̱nj chana̱ ꞌyaj suun cheꞌé síí ꞌni̱j raꞌa man níꞌ mej, ne̱ caꞌve̱e quiꞌya̱j soꞌ nda̱a vaa cataj so̱ꞌ rihanj á ―taj Mariá rihaan se‑mo̱zó Diose̱ yoꞌ a. Ga̱a ne̱ naxuun se‑mo̱zó Diose̱ man soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Cachén do̱j güii, ga̱a ne̱ quiꞌyaj chuvi̱i Mariá siꞌyaj noꞌ, ne̱ yo̱o ndoꞌo caꞌanj noꞌ ꞌo̱ chumanꞌ na̱j estadó Judea, ꞌo̱ chumanꞌ na̱j rej xra̱j a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ne̱ caꞌanj noꞌ tucuá Zacarías, ne̱ catúj noꞌ rá veꞌ, ne̱ cataj noꞌ: “Vaa nu̱cuáá so̱ꞌ naꞌ”, taj noꞌ rihaan Elisabet a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nu̱ꞌ cuno Elisabet nana̱ caꞌmii Mariá, ne̱ nu̱ꞌ güéj neꞌej rque noꞌ a. Dan me se catúj Nimán Diose̱ nimán Elisabet, ");
INSERT INTO trcNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ne̱ nucua̱j caꞌmii noꞌ ga̱ Mariá, cataj noꞌ: ―Rqué Diose̱ xnaꞌanj niꞌya̱j uruún so̱ꞌ rihaan cunu̱ꞌ da̱nj chana̱ a. Ne̱ uxrá rque̱ Diose̱ xnaꞌanj niꞌya̱j neꞌej cuchru̱j so̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Veꞌé ndoꞌo quiránꞌ ꞌu̱nj se vaa caꞌnaꞌ ro̱j ni̱i síí qui̱ꞌnij raꞌa man níꞌ tucuaj a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nu̱ꞌ cunoj nana̱ cataj so̱ꞌ rihanj, ne̱ nu̱ꞌ guun niha̱ꞌ rá neꞌej, ne̱ nu̱ꞌ güéj neꞌej rquej a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Cavii sa̱ꞌ so̱ꞌ cheꞌé se amán rá so̱ꞌ se‑na̱na̱ Diose̱, se vaa quisi̱j ya̱ nu̱ꞌ nana̱ caꞌmii Diose̱ rihaan so̱ꞌ ado̱nj ―taj Elisabet rihaan Mariá a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","48","Ga̱a ne̱ cataj Mariá nana̱ nihánj a: ―Nda̱ꞌ se chana̱ ya̱nj rmaꞌa̱n mé ꞌu̱nj, tza̱j ne̱ cunuu ꞌe̱e̱ rá Diose̱ niꞌya̱j soꞌ manj a. Cheꞌé dan me da̱j cata̱j maꞌa̱n Diose̱, ne̱ caꞌve̱e qui̱ꞌyáj a. Nanuj rá Diose̱ manj, ne̱ cheꞌé dan sa̱ꞌ vaa Diose̱, rá nimanj, ne̱ guun niha̱ꞌ ndoꞌo rá nimanj niꞌya̱j nimanj man Diose̱ síí tinanii manj rihaan sayuun na̱nj ado̱nj. Ne̱ ya̱j cata̱j cunuda̱nj yuvii̱ se vaa chana̱ quiriꞌ ndoꞌo xnaꞌanj niꞌya̱j mej a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Da̱nj cata̱j nij soꞌ cheꞌé se sa̱ꞌ quiꞌyaj Diose̱ síí nucua̱j ndoꞌo cheꞌej a. Ne̱ síí vaa sa̱ꞌ ina̱nj me soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ꞌO̱ ꞌe̱e̱ rá soꞌ man taranꞌ nij síí uno rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Quiꞌyaj Diose̱ suun noco̱o uxrá a. Nu̱ꞌ nij síí xta̱ꞌ nimán roꞌ, quiꞌya̱j canaán Diose̱ rihaan nij soꞌ, ne̱ quinavi̱j se‑na̱na̱ nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nu̱ꞌ nij síí rii taꞌngaꞌ roꞌ, caꞌne̱e̱ Diose̱ suun raꞌa nij soꞌ, ne̱ gu̱un nij soꞌ síí noco̱ꞌ na̱nj ado̱nj. Ne̱ nu̱ꞌ nij síí noco̱ꞌ roꞌ, gu̱un nij soꞌ síí quiri̱i̱ taꞌngaꞌ naca̱, quiꞌya̱j Diose̱ na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nu̱ꞌ nij síí naꞌaan rque roꞌ, rque̱ Diose̱ chraa cha̱ nij soꞌ, ne̱ nu̱ꞌ nij ruꞌvee roꞌ, cunu̱u nique̱ nij soꞌ, quiꞌya̱j Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Quisíj ya̱ nu̱ꞌ nana̱ caꞌmii Diose̱ rihaan xi̱i níꞌ nij síí ma̱n ga̱a naá a. Racuíj soꞌ man níꞌ si̱j israelitá, cheꞌé se si̱j noco̱ꞌ man soꞌ me níꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Nanuj rá soꞌ nda̱a vaa cataj soꞌ rihaan xi̱i níꞌ síí cuꞌna̱j Abraham, ne̱ cheꞌé dan ꞌe̱e̱ rá soꞌ man níꞌ si̱j israelitá, cheꞌé se taꞌníí taꞌnij siꞌno̱ Abraham me níꞌ a. ―Nu̱ꞌ nana̱ nihánj me nana̱ cataj María a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ga̱a ne̱ vaꞌnu̱j yavii cayáán Mariá tucuá Elisabet, ga̱a ne̱ quinanꞌ noꞌ tucuá noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ga̱a quisíj güii caꞌnga̱a̱ taꞌníí Elisabet, ga̱a ne̱ dan me se cuchruj noꞌ ꞌo̱ neꞌej sno̱ꞌo cunii a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Cuno nij tuviꞌ noꞌ se vaa veꞌé uxrá quiꞌyaj Diose̱ ga̱ noꞌ, ne̱ guun niha̱ꞌ uxrá rá nij soꞌ cheꞌé noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ga̱a quisíj neꞌej tu̱nj güii, ga̱a ne̱ dan me se cuchiꞌ nij síí cuta̱ꞌ taꞌngaꞌ nee̱ man neꞌej veꞌ a. Ne̱ nij soꞌ me rá tu̱cuꞌnáj Zacarías man neꞌej cheꞌé se Zacarías cuꞌna̱j rej neꞌej, ");
INSERT INTO trcNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","tza̱j ne̱ ne caꞌve̱j rá nii neꞌej cuꞌna̱j neꞌej da̱nj maꞌ. ꞌO̱ se cataj noꞌ: ―Juan cuꞌna̱j se‑chuvi̱i taꞌníj á ―taj noꞌ rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tza̱j ne̱ cataj nij síí caꞌnaꞌ rihaan noꞌ a: ―Tza̱j ne̱ a̱ ꞌó tuviꞌ soj ne cuꞌna̱j Juan maꞌ ―taj nij soꞌ rihaan noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Cheꞌé dan xnáꞌanj nij soꞌ man rej neꞌej, da̱j doj raꞌa nij soꞌ tucunó nij soꞌ a. Guun rá nij soꞌ queneꞌe̱n nij soꞌ da̱j quina̱j se‑chuvi̱i neꞌej, quiꞌya̱j rej neꞌej, rá nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Cachíín Zacarías yanj ga̱ raꞌa soꞌ, ne̱ cachrón soꞌ letrá rihaan yanj yoꞌ, ne̱: “Juan cuꞌna̱j se‑chuvi̱i neꞌej”, taj letrá cachrón soꞌ rihaan yanj, ne̱ cheꞌé dan caráyaꞌa̱nj ndoꞌo nij síí caꞌnaꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nu̱ꞌ cachrón Zacarías letrá, ne̱ nu̱ꞌ caꞌvee caꞌmii uún soꞌ na̱nj ado̱nj. Ga̱a ne̱ guun cheꞌe̱ soꞌ cataj soꞌ se vaa veꞌé uxrá quiꞌyaj Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ne̱ caráyaꞌa̱nj nij síí ya̱nj nichru̱nꞌ se vaa quiranꞌ Zacarías se vaa guun yaꞌmi̱i soꞌ, ne̱ nda̱a taranꞌ nij síí ya̱nj quij nicu̱nꞌ estadó Judea roꞌ, cuno nda̱a vaa quiranꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Taranꞌ nij síí cuno roꞌ, nuchruj ra̱a̱, ne̱ xnáꞌanj nij soꞌ man tuviꞌ nij soꞌ me suun ca̱ta̱ Juan asa̱ꞌ cachij soꞌ a. Da̱nj tuꞌva nij soꞌ cheꞌé se queneꞌen nij soꞌ se vaa rqué ndoꞌo Diose̱ xnaꞌanj niꞌya̱j Juan a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Racuíj Nimán Diose̱ man rej Juan síí cuꞌna̱j Zacarías, ne̱ cataj soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","―Caꞌmi̱i̱ sa̱ꞌ níꞌ cheꞌé Diose̱ síí noco̱ꞌ níꞌ si̱j israelitá a. Ése̱ racuíj soꞌ man níꞌ si̱j noco̱ꞌ man soꞌ, ne̱ tinanii soꞌ man níꞌ rihaan sayuun a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Caꞌna̱ꞌ ꞌo̱ síí nucua̱j gu̱un soꞌ síí ti̱nanii sa̱ꞌ man níꞌ rihaan sayuun, quiꞌya̱j Diose̱ a. ꞌO̱ taꞌníí taꞌnij siꞌno̱ síí guun chij ga̱a naá síí cuꞌna̱j David gu̱un soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","nda̱a vaa cataj nij síí nataꞌ se‑na̱na̱ Diose̱, quiꞌyaj Diose̱ ga̱a naá, ");
INSERT INTO trcNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ne̱ dan me se caꞌna̱ꞌ síí nucua̱j ti̱nanii soꞌ man níꞌ rihaan nij síí ta̱j riꞌyunj man níꞌ, taj nij soꞌ, ne̱ se̱ guun nucua̱j nij síí ta̱j riꞌyunj man níꞌ quiꞌya̱j chiꞌi̱i̱ nij soꞌ man níꞌ maꞌ, taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Dan me se cunuu ꞌe̱e̱ rá soꞌ man níꞌ nda̱a vaa cataꞌ tuꞌva soꞌ rihaan xi̱i níꞌ, ne̱ yoꞌo̱ nuû rá soꞌ nu̱ꞌ se vaa cataj xnaꞌanj soꞌ se vaa quiꞌya̱j soꞌ cheꞌé níꞌ do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","”Dan me se cataj soꞌ rihaan xi̱i níꞌ síí cuꞌna̱j Abraham se vaa ya̱ ya̱ ti̱nanii soꞌ man níꞌ rihaan nij síí ta̱j riꞌyunj man níꞌ, ga̱a ne̱ se̱ cuchuꞌviꞌ níꞌ quiꞌya̱j suun níꞌ cheꞌé soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ne̱ ga̱a̱ nica̱ nimán níꞌ rihaan Diose̱ nu̱ꞌ güii ga̱a̱ iꞌna̱ꞌ níꞌ ado̱nj ―taj Zacarías, ga̱a ne̱ caꞌmii uún Zacarías rihaan maꞌa̱n taꞌníí soꞌ― ");
INSERT INTO trcNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ne̱ xa̱ꞌ ma̱ꞌán so̱ꞌ, tza̱j ne̱ guún so̱ꞌ síí nata̱ꞌ se‑na̱na̱ Diose̱, ne̱ Diose̱ me síí sa̱ꞌ ndoꞌo, rej. Asino so̱ꞌ gu̱un cheꞌe̱ caꞌmi̱i̱ natáj, ga̱a ne̱ caꞌna̱ꞌ síí qui̱ꞌnij raꞌa man níꞌ ei. Dan me se cunu̱u nica̱ nimán yuvii̱, qui̱ꞌyáá so̱ꞌ, ne̱ cara̱yaꞌa̱nj yuvii̱ man síí caꞌna̱ꞌ qui̱ꞌnij raꞌa man níꞌ, qui̱ꞌyáá so̱ꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ne̱ so̱ꞌ quiꞌya̱j xca̱j nij síí canoco̱ꞌ man Diose̱ cuentá se vaa caꞌve̱e quinavi̱j cacunꞌ tumé nij soꞌ quiꞌya̱j síí caꞌna̱ꞌ, ne̱ caꞌve̱e quinani̱i̱ nij soꞌ rihaan sayuun a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Da̱nj quiꞌya̱j Diose̱ cheꞌé nij soꞌ cheꞌé se ꞌe̱e̱ uxrá rá Diose̱ man nij soꞌ, ne̱ cheꞌé dan caꞌne̱j soꞌ man síí qui̱ꞌnij raꞌa man nij soꞌ asa̱ꞌ quisíj güii caꞌve̱e cavi̱i̱ sa̱ꞌ níꞌ quiꞌya̱j Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ga̱a ne̱ xa̱ꞌ tuviꞌ níꞌ síí ne acaj cuentá do̱ꞌ, xa̱ꞌ tuviꞌ níꞌ síí chuꞌviꞌ ndoꞌo se vaa cavi̱ꞌ nij soꞌ do̱ꞌ, tza̱j ne̱ cuchugu̱u̱n rihaan nimán nij soꞌ, ga̱a ne̱ xca̱j nij soꞌ cuentá, ga̱a ne̱ nari̱ꞌ taranꞌ níꞌ da̱j quiꞌya̱j níꞌ, ne̱ cunu̱u xe̱j nimán níꞌ ado̱nj ―taj Zacarías rihaan taꞌníí soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Dan me se cachij xnii cuꞌna̱j Juan, ne̱ guun soꞌ síí nucua̱j nimán, ne̱ ina̱nj rej tacaan yáán soꞌ nda̱a se quisíj güii guun cheꞌe̱ soꞌ nataꞌ soꞌ se‑na̱na̱ Diose̱ rihaan nij síí israelitá a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ma̱a̱n yoꞌ caꞌngaa Juan roꞌ, cayáán síí cuꞌna̱j Augusto síí nica̱j suun emperador, ne̱ caꞌnéé soꞌ nana̱ rihaan nij síí ma̱n taranꞌ nij chumanꞌ rii taꞌngaꞌ soꞌ rihaan se vaa me rá soꞌ na̱xcaj soꞌ ꞌo̱ yanj documento no̱ se‑chuvi̱i ꞌo̱ ꞌo̱ nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ne̱ cayáán síí cuꞌna̱j Cirenio síí nica̱j suun gobernador uun chij rihaan estadó Siria ga̱a naxaga̱a̱ yanj yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Dan me se caꞌanj cunuda̱nj nij yuvii̱ chumanꞌ chiháán xi̱i nij soꞌ, ga̱a ne̱ naxaga̱a̱ yanj no̱ se‑chuvi̱i nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Cavii síí cuꞌna̱j José chumanꞌ Nazaret chumanꞌ na̱j estadó Galilea, ne̱ caꞌanj soꞌ chumanꞌ Belén chumanꞌ na̱j estadó Judea a. Chumanꞌ caꞌngaa xi̱i soꞌ síí guun chij ga̱a naá síí cuꞌna̱j David me Belén, ne̱ cheꞌé dan caꞌanj José nda̱a Belén, cheꞌé se ꞌo̱ taꞌníí taꞌnij siꞌno̱ David me soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nica̱j soꞌ chana̱ cuꞌna̱j Mariá chana̱ a̱j guun ya̱ xca̱j soꞌ man, caꞌanj soꞌ cano̱ se‑chuvi̱i ro̱j soꞌ rihaan yanj a. Nu̱u̱ rque Mariá, ");
INSERT INTO trcNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ne̱ ga̱a caranꞌ ro̱j soꞌ Belén, ne̱ quisíj güii caꞌnga̱a̱ neꞌej a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Taj yan vaa yaꞌnúj cara̱nꞌ ro̱j soꞌ caꞌnga̱a̱ neꞌej a̱ maꞌ. Dan me se da̱j doj rej ma̱n scúj vaa yaꞌnúj cara̱nꞌ ro̱j soꞌ a. Ne̱ cuchruj noꞌ ꞌo̱ neꞌej sno̱ꞌo cunii taꞌníí noꞌ síí chava̱ꞌ a. Quiꞌyaj yanu̱ꞌ noꞌ man neꞌej, ne̱ caꞌnéé noꞌ man neꞌej rá rihoo yan nu̱u̱ coꞌyo̱o̱ chá scúj a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Dan me se mán síí tumé matzinj rej tacaan nichru̱nꞌ yáj tuꞌva chumanꞌ Belén, ne̱ nicunꞌ taꞌa̱j nij soꞌ xeꞌ tumé nij soꞌ daán nij soꞌ rej nii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ga̱a ne̱ dan me se naquiꞌyaa ꞌo̱ se‑mo̱zó Diose̱ rihaan nij soꞌ, ne̱ cuchuguu̱n uxrá rihaan nij soꞌ, quiꞌyaj Diose̱, ga̱a ne̱ cuchuꞌviꞌ ndoꞌo nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ga̱a ne̱ cataj se‑mo̱zó Diose̱ rihaan nij soꞌ a: ―Se̱ cuchuꞌviꞌ soj maꞌ. ꞌO̱ se caꞌnáꞌ ꞌu̱nj nata̱ꞌ ꞌu̱nj ꞌo̱ nana̱ sa̱ꞌ rihaan soj cheꞌé rasu̱u̱n quiꞌya̱j gu̱un niha̱ꞌ rá taranꞌ nij yuvii̱ ei. ");
INSERT INTO trcNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ꞌO̱ se cuanꞌ me se caꞌngaa ꞌo̱ neꞌej chumanꞌ chiháán David, ne̱ neꞌej yoꞌ roꞌ, me síí caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun, ne̱ síí qui̱ꞌnij raꞌa man níꞌ me soꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na̱nj vaa queneꞌe̱n soj se vaa ya̱ caꞌmij rihaan soj a. Caꞌa̱nj nij soj chumanꞌ Belén, ne̱ nari̱ꞌ soj ꞌo̱ neꞌej guun yanu̱ꞌ, ne̱ nu̱u̱ soꞌ rá rihoo chá xcuu coꞌyo̱o̱, ne̱ soꞌ me síí qui̱ꞌnij raꞌa man níꞌ a. ―Da̱nj cataj se‑mo̱zó Diose̱ rihaan nij síí tumé matzinj a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Dan me se nu̱ꞌ navij caꞌmii se‑mo̱zó Diose̱ ga̱ nij soꞌ, ga̱a ne̱ veé ma̱a̱n orá dan curuviꞌ queꞌe̱e̱ doj nij se‑mo̱zó Diose̱ uún, ne̱ veꞌé uxrá caꞌmii nij soꞌ cheꞌé Diose̱, cataj nij soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","―Sa̱ꞌ uxrá vaa Diose̱, síí nicu̱nꞌ xta̱ꞌ, ne̱ ga̱a̱ xe̱j nimán nij yuvii̱ si̱j sa̱ꞌ nimán a ―taj nij se‑mo̱zó Diose̱ rihaan nij síí tumé matzinj a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Dan me se quinanꞌ nij se‑mo̱zó Diose̱ xta̱ꞌ, ga̱a ne̱ cataj nij síí tumé matzinj rihaan tuviꞌ nij soꞌ a: ―Caꞌa̱nj níꞌ Belén queneꞌe̱n níꞌ da̱j guun se vaa cataj xnaꞌanj Diose̱ rihaan níꞌ ei ―taj nij soꞌ rihaan tuviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yo̱o caꞌanj nij soꞌ, ne̱ dan me se nu̱ꞌ cuchiꞌ nij soꞌ, ne̱ nu̱ꞌ quinariꞌ nij soꞌ man Mariá ga̱ José, ne̱ dan me se quinariꞌ nij soꞌ man neꞌej, nu̱u̱ neꞌej rá rihoo a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Dan me se ga̱a queneꞌen nij síí tumé matzinj man neꞌej, ga̱a ne̱ cataj xnaꞌanj nij soꞌ nana̱ caꞌnéé Diose̱ rihaan nij soꞌ cheꞌé neꞌej rihaan Mariá ga̱ José do̱ꞌ, rihaan nij síí ma̱n nichru̱nꞌ do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ga̱a ne̱ caráyaꞌa̱nj cunuda̱nj yuvii̱ cuno nana̱ caꞌmii nij síí tumé matzinj yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ne̱ Mariá me se caꞌnéé noꞌ cunuda̱nj nana̱ yoꞌ cúú yave̱ noꞌ, ne̱ nuchruj ra̱a̱ noꞌ cheꞌé nana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Dan me se quinanꞌ nij síí tumé matzinj, ga̱a ne̱ guun niha̱ꞌ uxrá rá nij soꞌ cheꞌé nu̱ꞌ nana̱ cuno nij soꞌ do̱ꞌ, cheꞌé nu̱ꞌ se vaa queneꞌen nij soꞌ do̱ꞌ, ne̱: “Sa̱ꞌ uxrá quiꞌyaj Diose̱ á”, taj nij soꞌ a. ꞌO̱ se ase vaa cataj xnaꞌanj se‑mo̱zó Diose̱ rihaan nij soꞌ roꞌ, veé da̱nj vaa guun a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Cachén ꞌo̱ tu̱nj güii ga̱a ne̱ cutaꞌ nii taꞌngaꞌ nee̱ man neꞌej, ne̱ Jesús cuꞌna̱j neꞌej, quiꞌyaj nii, nda̱a vaa cataj xnaꞌanj se‑mo̱zó Diose̱ ga̱a ataa nayo̱n soꞌ rque Mariá a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Cachén vi̱j chiha̱a̱ güii, ga̱a ne̱ quisíj güii cunu̱u sa̱ꞌ Mariá rihaan Diose̱ a. Cheꞌé dan nica̱j ro̱j soꞌ man neꞌej caꞌanj ro̱j soꞌ nuvií noco̱o ya̱nj chumanꞌ Jerusalén, ne̱ caxríj ro̱j soꞌ neꞌej ston Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ꞌO̱ se danj Diose̱ taj se vaa daj a̱ taꞌníí nij yuvii̱ israelitá síí chava̱ꞌ gu̱un siꞌyaj Diose̱, ne̱ cheꞌé dan quiꞌyaj ro̱j soꞌ da̱nj a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Dan me se caꞌanj ro̱j soꞌ caꞌanj go̱ꞌ ro̱j soꞌ xcuu rihaan Diose̱ nda̱a vaa taj danj Diose̱ a. Caꞌve̱e go̱ꞌ yuvii̱ vi̱j chaꞌaa̱n caꞌve̱e go̱ꞌ yuvii̱ vi̱j culuj caꞌve̱e, taj danj Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Dan me se cayáán ꞌo̱ chii nga̱ cuꞌna̱j Simeón chumanꞌ Jerusalén a. Si̱j vaa nica̱ nimán me soꞌ, ne̱ si̱j noco̱ꞌ uxrá man Diose̱ me uún soꞌ, ne̱ quisíj queꞌe̱e̱ yoꞌ naꞌvi̱j uxrá soꞌ se vaa ti̱nanii Diose̱ man nij yuvii̱ israelitá rihaan sayuun a. Cayáán Nimán Diose̱ ga̱ soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ne̱ a̱j cataj xnaꞌanj Nimán Diose̱ rihaan soꞌ se vaa se̱ caviꞌ soꞌ nda̱a se a̱j queneꞌen ya̱ soꞌ man síí caꞌne̱j Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Dan me se güii cuchiꞌ ro̱j ni̱ca̱ José chumanꞌ Jerusalén me se cataj xnaꞌanj Nimán Diose̱ rihaan Simeón se vaa caꞌa̱nj soꞌ nuvií noco̱o, ne̱ cheꞌé dan caꞌanj soꞌ catúj soꞌ rque nuvií a. Ga̱a ne̱ catúj ro̱j ni̱ca̱ José rque nuvií ga̱ neꞌej cheꞌé se guun rá ro̱j soꞌ quiꞌya̱j ro̱j soꞌ nda̱a vaa taj danj Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ga̱a ne̱ táraꞌa̱ síí cuꞌna̱j Simeón neꞌej, ne̱ nagoꞌ soꞌ graciá rihaan Diose̱ cheꞌé neꞌej a. Ne̱ nihánj me nana̱ caꞌmii soꞌ a: ");
INSERT INTO trcNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","―Quisíj ya̱ nu̱ꞌ nda̱a vaa cataj so̱ꞌ rihanj, ne̱ cheꞌé dan caꞌve̱e cavi̱j ya̱j, ne̱ ga̱a̱ xe̱j nimanj, Ata̱j Chij. ");
INSERT INTO trcNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Queneꞌen rihanj man síí caꞌnéé so̱ꞌ man ti̱nanii man núj rihaan sayuun, ");
INSERT INTO trcNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ne̱ queneꞌe̱n cunuda̱nj yuvii̱ se vaa caꞌnaꞌ soꞌ quiꞌyáá so̱ꞌ na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ase vaa yaꞌan chuguu̱n ga̱a̱ soꞌ ti̱haa̱n soꞌ se‑tucua̱nj so̱ꞌ rihaan nij yuvii̱ yaníj, ne̱ caꞌmi̱i̱ sa̱ꞌ nii cheꞌé núj si̱j israelitá, quiꞌya̱j uún soꞌ, ése̱ síí noco̱ꞌ mán so̱ꞌ me núj na̱nj ado̱nj ―taj Simeón rihaan Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Caráyaꞌa̱nj ro̱j ni̱ca̱ José se‑na̱na̱ síí cuꞌna̱j Simeón se vaa caꞌmii soꞌ cheꞌé neꞌej, ");
INSERT INTO trcNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ne̱ cachíín niꞌya̱j Simeón rihaan Diose̱ se vaa rque̱ Diose̱ xnaꞌanj niꞌya̱j ro̱j ni̱ca̱ José a. Ga̱a ne̱ cataj soꞌ rihaan Mariá a: ―Cuneꞌ Diose̱ man neꞌej nihánj quiꞌya̱j suun soꞌ rihaan Diose̱, ne̱ dan me se cavi̱i̱ sa̱ꞌ uxrá queꞌe̱e̱ tuviꞌ níꞌ si̱j israelitá, quiꞌya̱j soꞌ, tza̱j ne̱ queꞌe̱e̱ tuviꞌ níꞌ tuna̱, quiꞌya̱j uún soꞌ ado̱nj. Dan me se caꞌnéé Diose̱ man soꞌ cheꞌé rej xca̱j yuvii̱ cuentá cheꞌé Diose̱, tza̱j ne̱ caꞌmi̱i̱ chiꞌi̱i̱ nii ni̱ꞌyaj nii man soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ne̱ xa̱ꞌ so̱ꞌ, tza̱j ne̱ quinano̱ ndoꞌo rá ma̱ꞌán so̱ꞌ cheꞌé soꞌ vaa güii na̱nj á. Dan me se caꞌve̱e xca̱j níꞌ cuentá da̱j vaa nimán queꞌe̱e̱ yuvii̱, quiꞌya̱j soꞌ ado̱nj ―taj Simeón rihaan Mariá a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ne̱ yáán ꞌo̱ chana̱ chij cuꞌna̱j Ana, ne̱ níí nataꞌ se‑na̱na̱ Diose̱ me noꞌ, ne̱ taꞌníí síí cuꞌna̱j Fanuel me noꞌ, ne̱ taꞌníí taꞌnij siꞌno̱ síí cuꞌna̱j Aser me ro̱j re̱j ro̱j noꞌ a. Xcaj chii man noꞌ ga̱a naá, ne̱ nica̱j tuviꞌ ro̱j soꞌ chi̱j yoꞌ, ga̱a ne̱ caviꞌ nica̱ noꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ne̱ quináj noꞌ ne maꞌa̱n noꞌ, ne̱ quisíj noꞌ nda̱a caꞌa̱nj chiha̱a̱ caꞌa̱nj yoꞌ ga̱a caꞌngaa neꞌej cuꞌna̱j Jesús a. Chana̱ noco̱ꞌ uxrá man Diose̱ me noꞌ, ne̱ cheꞌé dan yoꞌo̱ cayáán noꞌ nuvií noco̱o, ne̱ niga̱nj ya̱j aꞌyuj caráj gue̱e̱ noꞌ, ne̱ cachíín niꞌya̱j noꞌ rihaan Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ma̱a̱n orá caꞌmii Simeón cheꞌé neꞌej roꞌ, veé ma̱a̱n orá dan va̱j chana̱ chij cuꞌna̱j Ana, ne̱ catúj noꞌ rque nuvií, ga̱a ne̱ nagoꞌ noꞌ graciá rihaan Diose̱ cheꞌé neꞌej, ne̱ cataj xnaꞌanj noꞌ cheꞌé neꞌej rihaan nij yuvii̱ ma̱n naꞌvi̱j güii ti̱nanii Diose̱ man nij síí ma̱n Jerusalén rihaan sayuun a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Dan me se ga̱a quisíj quiꞌyaj ro̱j ni̱ca̱ José se vaa taj se‑tucua̱nj Moisés, ga̱a ne̱ quinanꞌ ro̱j soꞌ estadó Galilea a. Quinanꞌ ro̱j soꞌ chiháán ro̱j soꞌ chumanꞌ Nazaret a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Cachij neꞌej guun soꞌ síí nucua̱j a. Xnii vaa chij rá me soꞌ, ne̱ rqué uxrá Diose̱ xnaꞌanj niꞌya̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Daj a̱ yoꞌ caꞌanj ro̱j ni̱ca̱ José chumanꞌ Jerusalén ga̱a canuû chaꞌanj pascuá, ");
INSERT INTO trcNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ése̱ da̱nj vaa tucuáán noco̱ꞌ nij síí israelitá a. Dan me se ga̱a quisíj Jesucristó chuvi̱j yoꞌ, ga̱a ne̱ caꞌanj ro̱j ni̱i soꞌ chaꞌanj ga̱ rej soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Cachén chaꞌanj, ga̱a ne̱ quinanꞌ ro̱j ni̱ca̱ ro̱j soꞌ, tza̱j ne̱ xnii roꞌ, quináj Jerusalén, ne̱ ne queneꞌe̱n ro̱j ni̱ca̱ ro̱j soꞌ se vaa quináj xnii a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Quinanꞌ xnii ga̱ tuviꞌ ro̱j soꞌ, rá ro̱j soꞌ, ne̱ cheꞌé dan caꞌanj ro̱j soꞌ a. Ga̱a ne̱ rej tiꞌnuu guun cheꞌe̱ ro̱j soꞌ nanoꞌ ro̱j soꞌ man xnii rihaan tuviꞌ ro̱j soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","tza̱j ne̱ nuviꞌ yan va̱j xnii a̱ maꞌ. Cheꞌé dan nanica̱j uún ro̱j soꞌ caꞌanj uún ro̱j soꞌ Jerusalén, ne̱ nanoꞌ uxrá ro̱j soꞌ man xnii a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Quisíj vaꞌnu̱j güii nanoꞌ ro̱j soꞌ man xnii, ga̱a ne̱ caꞌanj ro̱j soꞌ rque nuvií noco̱o ma̱n nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés, ne̱ ma̱a̱n dan ne xnii nanó xre̱j xnii nana̱ aꞌmii nij soꞌ, ne̱ achíín naꞌanj xnii nana̱ cu̱u man nij soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ne̱ caráyaꞌa̱nj daj a̱ nij síí cuno nana̱ caꞌmii xnii, ése̱ si̱j nica̱j uxrá cuentá me xnii, ne̱ sa̱ꞌ uxrá caꞌmii xnii, rá nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ne̱ caráyaꞌa̱nj ro̱j ni̱ca̱ ro̱j soꞌ ga̱a queneꞌen ro̱j soꞌ se vaa ne xnii scaꞌnúj nij sij a. Ga̱a ne̱ cataj nii soꞌ rihaan soꞌ a: ―Ne chiha̱nꞌ quiꞌyáá di̱ꞌ man núj, man rej. Nanó ndoꞌo rá réé di̱ꞌ do̱ꞌ, nanó ndoꞌo rá ꞌu̱nj do̱ꞌ, quiꞌyáá di̱ꞌ, cheꞌé se nuvi̱i nanoꞌ núj mán di̱ꞌ, rej ―taj nii soꞌ rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tza̱j ne̱ cataj Jesucristó rihaan ro̱j soꞌ a: ―Taj cheꞌé nano̱ꞌ ro̱j so̱j manj maꞌ. Me cheꞌé ne neꞌen ro̱j so̱j se vaa no̱ xcúún ꞌu̱nj quiꞌya̱j suun ꞌu̱nj se‑tucua̱nj Réj ga̱ ―taj xnii rihaan ro̱j ni̱ca̱ ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tza̱j ne̱ ne cuno̱ ro̱j soꞌ se‑na̱na̱ xnii se vaa no̱ xcúún soꞌ quiꞌya̱j suun soꞌ se‑chre̱j Rej soꞌ Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Dan me se quinanꞌ Jesucristó chumanꞌ Nazaret ga̱ ro̱j soꞌ, ne̱ yoꞌo̱ ya̱nj uno sa̱ꞌ soꞌ rihaan ro̱j soꞌ a. Ne̱ yoꞌo̱ nuû rá Mariá nu̱ꞌ nda̱a vaa guun cheꞌé soꞌ ga̱a caꞌngaa soꞌ do̱ꞌ, nu̱ꞌ nana̱ cu̱u sa̱ꞌ aꞌmii soꞌ do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Dan me se cachij Jesucristó guun soꞌ síí cu̱u raa̱, ne̱ caranꞌ rá Diose̱ niꞌya̱j Diose̱ man soꞌ, ne̱ caranꞌ rá yuvii̱ uún niꞌya̱j yuvii̱ man soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Yoꞌ xnu̱ꞌ cayáán síí cuꞌna̱j Tiberio síí nica̱j suun emperador roꞌ, ma̱a̱n yoꞌ dan me rqué Diose̱ se‑na̱na̱ Diose̱ rihaan síí cuꞌna̱j Juan taꞌníí Zacarías ga̱a cachéé soꞌ tacaan a. Veé ma̱a̱n yoꞌ caꞌmii Diose̱ rihaan Juan, dan me cayáán síí cuꞌna̱j Poncio Pilato síí nica̱j suun gobernador uun chij rihaan estadó cuꞌna̱j Judea a. Ne̱ veé ma̱a̱n yoꞌ dan cayáán síí cuꞌna̱j Herodes síí nica̱j suun tetrarca uun chij rihaan estadó cuꞌna̱j Galilea, ne̱ cayáán tinúú soꞌ síí cuꞌna̱j Felipé síí nica̱j suun tetrarca uun chij rihaan ro̱j estadó cuꞌna̱j Iturea ga̱ Traconite a. Ne̱ veé ma̱a̱n yoꞌ dan cayáán síí cuꞌna̱j Lisanias síí nica̱j suun tetrarca uun chij rihaan estadó cuꞌna̱j Abilinia, ne̱ cayáán ro̱j síí cuꞌna̱j Anás ga̱ Caifás xrej ata̱ suun noco̱o doj rihaan nij yuvii̱ israelitá a. Taranꞌ nij soꞌ me síí uun chij ga̱a cuchiꞌ se‑na̱na̱ Diose̱ rihaan Juan ga̱a cachéé soꞌ tacaan a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Dan me se cachéé Juan nu̱ꞌ rej na̱j nichru̱nꞌ tuꞌva chráá cuꞌna̱j Jordán, ne̱ guun cheꞌe̱ soꞌ caꞌmii natáj soꞌ rihaan yuvii̱ se vaa nuchra̱nꞌ nimán nij yuvii̱, ne̱ ta̱náj nij yuvii̱ chrej chiꞌi̱i̱, ne̱ caꞌve̱e tinavi̱j Diose̱ cacunꞌ tumé nij yuvii̱, taj Juan ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Dan me se quiꞌyaj Juan nu̱ꞌ nda̱a vaa taj nana̱ cachrón síí cuꞌna̱j Isaías síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá rihaan yanj, ne̱ nihánj me nana̱ cachrón soꞌ a: “Nucua̱j ndoꞌo caꞌmi̱i̱ natáj ꞌo̱ soꞌ rej tacaan, ne̱ cata̱j soꞌ se vaa nuchra̱nꞌ nimán yuvii̱, ne̱ veꞌé caꞌmi̱i̱ nij yuvii̱ ga̱ síí ꞌni̱j raꞌa man níꞌ asa̱ꞌ caꞌnaꞌ soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Dan me se se̱ caꞌvee quina̱j a̱ doj se chiꞌi̱i̱ nimán níꞌ ca̱ráán chrej rihaan síí ꞌni̱j raꞌa man níꞌ caꞌna̱ꞌ soꞌ maꞌ. Ma̱a̱n se quiri̱i̱ níꞌ nu̱ꞌ se chiꞌi̱i̱, ne̱ cara̱a níꞌ nu̱ꞌ se sa̱ꞌ cachi̱in man nimán níꞌ, ne̱ veꞌé ina̱nj cunu̱u nica̱ nimán níꞌ, quiꞌya̱j níꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ga̱a ne̱ queneꞌe̱n nu̱ꞌ nij síí ma̱n daj a̱ chumanꞌ se vaa caꞌve̱e ti̱nanii Diose̱ man yuvii̱ rihaan sayuun na̱nj á”. Dan me nana̱ cachrón síí cuꞌna̱j Isaías rihaan yanj ga̱a naá nana̱ taj xnaꞌanj cheꞌé síí cuꞌna̱j Juan a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Dan me se cuchiꞌ queꞌe̱e̱ ndoꞌo yuvii̱ rihaan Juan cheꞌé se guun rá nij soꞌ cuta̱ꞌ ne Juan man nij soꞌ a. Ga̱a ne̱ caxríj yuva̱a̱ Juan man nij soꞌ, cataj soꞌ: ―Ase vaa xcuáá yuva̱a̱ vaa soj á. Me síí cataj xnaꞌanj rihaan soj cuna̱nj soj, ne̱ quinani̱i̱ soj rihaan sayuun quiꞌya̱j Diose̱ ga̱. Asa̱ꞌ caꞌve̱e quinani̱i̱ soj rihaan sayuun, quiꞌya̱j na̱nj na cata̱ꞌ ne soj, rá soj ga̱. ");
INSERT INTO trcNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sese ya̱ cunuu sa̱ꞌ nimán soj, ne̱ caꞌa̱nj soj quiꞌya̱j soj nda̱a vaa ꞌyaj yuvii̱ cunuu sa̱ꞌ nimán ei. Ne̱ ta̱dó soj sese gu̱un cheꞌe̱ soj cata̱j soj se vaa taꞌníí taꞌnij siꞌno̱ síí cuꞌna̱j Abraham síí cane ga̱a naá me soj, ne̱ ne tumé soj cacunꞌ, cata̱j soj á. Se̱ caꞌmii soj daj chiha̱a̱ míj da̱nj maꞌ. Ma̱a̱n se cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa nuveé se̱ yaꞌa̱nj tihaꞌ taꞌníí taꞌnij siꞌno̱ síí cuꞌna̱j Abraham me soj a̱ maꞌ. Ma̱a̱n se sese Diose̱ rá, ne̱ caꞌve̱e ni̱caj Diose̱ náá guun yahij na̱j rihaan yoꞌóó nihánj, ne̱ quiꞌya̱j Diose̱ man ꞌo̱ taꞌníí taꞌnij siꞌno̱ síí cuꞌna̱j Abraham ado̱nj. Cheꞌé dan canoco̱ꞌ ya̱ soj man Diose̱ ei. ");
INSERT INTO trcNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ꞌO̱ se nichru̱nꞌ quiꞌya̱j Diose̱ sayuun man nij síí naꞌvej rá cuno̱ rihaan soꞌ na̱nj á. Ase vaa síí oro̱ꞌ agaꞌ aꞌneꞌ chruun, ne̱ oro̱ꞌ soꞌ agaꞌ caꞌne̱ꞌ soꞌ chruun roꞌ, da̱nj vaa Diose̱ cuano̱ ei. Cheꞌé dan ase vaa ꞌyaj nii man chruun roꞌ, taꞌngaꞌ da̱nj quiꞌya̱j Diose̱ man nij síí ne uno rihaan soꞌ a. Dan me se aꞌneꞌ nii chruun nuviꞌ chruj sa̱ꞌ raa̱, ne̱ araa nii man chruun yoꞌ rihaan yaꞌan a. Taꞌngaꞌ da̱nj quiꞌya̱j Diose̱ man nij síí naꞌvej rá canoco̱ꞌ chrej sa̱ꞌ ado̱nj. ―Da̱nj cataj Juan rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ga̱a ne̱ xnáꞌanj nij yuvii̱ man Juan, cataj nij yuvii̱: ―Da̱j quiꞌya̱j núj, rá so̱ꞌ ga̱ ―taj nij soꞌ rihaan Juan a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ga̱a ne̱ cataj Juan rihaan nij soꞌ a: ―Síí vaa vi̱j se‑co̱toó roꞌ, caxri̱i̱ u̱u̱n soꞌ ꞌo̱ cotoó ston síí nuviꞌ se‑co̱toó á. Ne̱ síí vaa se chá rihaan roꞌ, go̱ꞌ soꞌ do̱j se chá man nij síí nuviꞌ se chá rihaan á. ―Da̱nj cataj Juan rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Do̱j tuviꞌ nij síí aꞌnéj puextó roꞌ, caꞌnaꞌ rihaan Juan cheꞌé se guun rá nij soꞌ cuta̱ꞌ ne Juan man nij soꞌ a. Ne̱ xnáꞌanj nij soꞌ man Juan, cataj nij soꞌ: ―Da̱j quiꞌya̱j núj, rá so̱ꞌ, ga̱ maestroꞌ ―taj nij soꞌ rihaan Juan a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ne̱ cataj Juan rihaan nij soꞌ a: ―Ina̱nj saꞌanj no̱ xcúún soj caꞌne̱e̱ soj man yuvii̱ roꞌ, caꞌve̱e caꞌne̱e̱ soj á. Se̱ caꞌnéj soj doj saꞌanj man yuvii̱ maꞌ ―taj Juan rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ga̱a ne̱ xnáꞌanj do̱j tanuu man Juan a: ―Da̱j quiꞌya̱j núj, rá so̱ꞌ ga̱ ―taj nij soꞌ rihaan Juan a. Ne̱ cataj Juan rihaan nij soꞌ a: ―Se̱ quiꞌyaj soj fuerzá rque̱ yuvii̱ saꞌanj rihaan soj a̱ maꞌ. Se̱ caꞌmii ne̱ soj cheꞌé yuvii̱ ne̱ caꞌne̱e̱ soj saꞌanj man nij yuvii̱ a̱ maꞌ. Veé do̱j saꞌanj vaa tuꞌvee soj roꞌ, gu̱un niha̱ꞌ rá soj ni̱caj soj na̱nj á. ―Da̱nj cataj Juan rihaan nij tanuu a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Dan me se nuchruj nij yuvii̱ cuentá sese si̱j caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun me Juan, ne̱ cheꞌé dan naꞌvi̱j ndoꞌo nij yuvii̱ cata̱j xnaꞌanj maꞌa̱n síí cuꞌna̱j Juan da̱j si̱j me maꞌa̱n soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ne̱ cheꞌé dan cataj Juan rihaan nij soꞌ a: ―Síí utaꞌ ne na u̱u̱n man soj mej, tza̱j ne̱ caꞌna̱ꞌ yoꞌó síí gu̱un sca̱ꞌ doj rihanj a. Cheꞌé dan me a̱j ne nó xcúnj na̱chej nuj correá ꞌni̱j tacanj soꞌ maꞌ. Ne̱ caꞌna̱ꞌ soꞌ, ne̱ caꞌna̱ꞌ Nimán Diose̱ ga̱ soꞌ, ne̱ caxri̱i̱ yaꞌan soꞌ man soj si̱j naꞌvej rá cuno̱ rihaan Diose̱, ne̱ caca̱a̱ soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Dan me se ase vaa síí oro̱ꞌ chruun palá vaa soꞌ cuano̱ ado̱nj. Dan me se síí nica̱j chruun palá roꞌ, rii nu̱ꞌ ꞌnúú trigó na̱j rihaan yoꞌóó, ne̱ naquiꞌyaj chre̱ꞌ soꞌ man ꞌnúú trigó sa̱ꞌ, ne̱ araa soꞌ man ꞌnúú trigó sa̱ꞌ rá veꞌ, ne̱ anica̱j soꞌ araa soꞌ squíj niꞌya xráá trigó rihaan yaꞌan a. Ne̱ ase vaa síí nica̱j palá ma̱n cuano̱ roꞌ, da̱nj quiꞌya̱j síí caꞌna̱ꞌ, ne̱ naquiꞌya̱j chre̱ꞌ soꞌ man cunuda̱nj nij síí cunuu sa̱ꞌ nimán, ne̱ cara̱a soꞌ man nij síí chiꞌi̱i̱ rihaan yaꞌan, ne̱ caca̱a̱ nij soꞌ nu̱ꞌ cavii nu̱ꞌ caꞌanj, ne̱ daj chiha̱a̱ míj se̱ quinaꞌáj yaꞌan yoꞌ a̱ man ado̱nj. ―Da̱nj caꞌmii síí cuꞌna̱j Juan rihaan nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ne̱ vaa uxrá doj chrej sa̱ꞌ nagoꞌ soꞌ man nij yuvii̱, ne̱ veꞌé nataꞌ soꞌ se‑na̱na̱ Diose̱ nana̱ sa̱ꞌ rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Dan me se cataj Juan se vaa ne chiha̱nꞌ quiꞌyaj síí nica̱j suun rey síí cuꞌna̱j Herodes cheꞌé se caꞌnéj soꞌ nica̱ tinúú soꞌ chana̱ cuꞌna̱j Herodías ne̱ xcaj soꞌ man noꞌ do̱ꞌ, cheꞌé queꞌe̱e̱ ndoꞌo doj se chiꞌi̱i̱ quiꞌyaj Herodes do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Cheꞌé se nij ndoꞌo quiꞌyaj Herodes caꞌnéj soꞌ nica̱ tinúú soꞌ cataj Juan, ne̱ caꞌmaan ndoꞌo rá Herodes niꞌya̱j soꞌ man Juan, ne̱ caxríj soꞌ tagaꞌ man Juan na̱nj á. Ma̱a̱n taꞌngaꞌ doj vaa cacunꞌ tumé soꞌ ga̱a ataa caxri̱i̱ soꞌ tagaꞌ man Juan, tza̱j ne̱ ya̱j caxríj soꞌ tagaꞌ man Juan, ne̱ doj a̱ tumé soꞌ cacunꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Dan me se ga̱a ataa catu̱u̱ Juan tagaꞌ, ne̱ cataꞌ ne taranꞌ nij yuvii̱, quiꞌyaj Juan, ga̱a ne̱ cataꞌ ne Jesucristó, ne̱ nu̱ꞌ nagoꞌ Jesucristó graciá rihaan Diose̱, ga̱a ne̱ naxraꞌ rej xta̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ga̱a ne̱ nanij Nimán Diose̱ raa̱ Jesucristó, ne̱ ase vaa ruviꞌ ꞌo̱ chaꞌaa̱n roꞌ, da̱nj vaa curuviꞌ Nimán Diose̱ a. Ga̱a ne̱ caꞌmii Diose̱ síí nicu̱nꞌ xta̱ꞌ, cataj Diose̱: ―Taꞌníí ꞌu̱nj síí ꞌe̱e̱ ndoꞌo raj man mé so̱ꞌ, ne̱ niha̱ꞌ ndoꞌo raj niꞌya̱j ꞌu̱nj mán so̱ꞌ ado̱nj ―taj Diose̱ síí nicu̱nꞌ xta̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nda̱a quisíj Jesucristó ico̱ chi̱ꞌ yoꞌ ta̱ꞌ asuun, ga̱a ne̱ guun cheꞌe̱ soꞌ quiꞌyaj suun soꞌ se‑su̱u̱n soꞌ a. Dan me se guun re̱j Jesucristó man síí cuꞌna̱j José, ne̱ taꞌni̱j José me Jesucristó, rá nij yuvii̱ a. Ne̱ taꞌníí Elí me José a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Taꞌníí Matat me Elí, ne̱ taꞌníí Leví me Matat, ne̱ taꞌníí Melqui me Leví, ne̱ taꞌníí Jana me Melqui, ne̱ taꞌníí José me Jana a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Taꞌníí Matatías me José, ne̱ taꞌníí Amós me Matatías, ne̱ taꞌníí Nahum me Amós, ne̱ taꞌníí Esli me Nahum, ne̱ taꞌníí Nagai me Esli a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Taꞌníí Maat me Nagai, ne̱ taꞌníí Matatías me Maat, ne̱ taꞌníí Semei me Matatías, ne̱ taꞌníí José me Semei, ne̱ taꞌníí Judá me José a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Taꞌníí Joana me Judá, ne̱ taꞌníí Resa me Joana, ne̱ taꞌníí Zorobabel me Resa, ne̱ taꞌníí Salatiel me Zorobabel, ne̱ taꞌníí Neri me Salatiel a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Taꞌníí Melqui me Neri, ne̱ taꞌníí Adi me Melqui, ne̱ taꞌníí Cosam me Adi, ne̱ taꞌníí Elmodam me Cosam, ne̱ taꞌníí Er me Elmodam a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Taꞌníí Josué me Er, ne̱ taꞌníí Eliezer me Josué, ne̱ taꞌníí Jorim me Eliezer, ne̱ taꞌníí Matat me Jorim a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Taꞌníí Leví me Matat, ne̱ taꞌníí Simeón me Leví, ne̱ taꞌníí Judá me Simeón, ne̱ taꞌníí José me Judá, ne̱ taꞌníí Jonán me José, ne̱ taꞌníí Eliaquim me Jonán a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Taꞌníí Melea me Eliaquim, ne̱ taꞌníí Mainán me Melea, ne̱ taꞌníí Matata me Mainán, ne̱ taꞌníí Natán me Matata a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Taꞌníí David me Natán, ne̱ taꞌníí Isaí me David, ne̱ taꞌníí Obed me Isaí, ne̱ taꞌníí Booz me Obed, ne̱ taꞌníí Salmón me Booz, ne̱ taꞌníí Naasón me Salmón a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Taꞌníí Aminadab me Naasón, ne̱ taꞌníí Aram me Aminadab, ne̱ taꞌníí Esrom me Aram, ne̱ taꞌníí Fares me Esrom, ne̱ taꞌníí Judá me Fares a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Taꞌníí Jacob me Judá, ne̱ taꞌníí Isaac me Jacob, ne̱ taꞌníí Abraham me Isaac, ne̱ taꞌníí Taré me Abraham, ne̱ taꞌníí Nacor me Taré a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Taꞌníí Serug me Nacor, ne̱ taꞌníí Ragau me Serug, ne̱ taꞌníí Peleg me Ragau, ne̱ taꞌníí Heber me Peleg, ne̱ taꞌníí Sala me Heber a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Taꞌníí Cainán me Sala, ne̱ taꞌníí Arfaxad me Cainán, ne̱ taꞌníí Sem me Arfaxad, ne̱ taꞌníí Noé me Sem, ne̱ taꞌníí Lamec me Noé a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Taꞌníí Matusalén me Lamec, ne̱ taꞌníí Enoc me Matusalén, ne̱ taꞌníí Jared me Enoc, ne̱ taꞌníí Mahalaleel me Jared, ne̱ taꞌníí Cainán me Mahalaleel a. ");
INSERT INTO trcNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Taꞌníí Enós me Cainán, ne̱ taꞌníí Set me Enós, ne̱ taꞌníí Adán me Set a. Ne̱ Adán roꞌ, me síí quiꞌyaj maꞌa̱n Diose̱ man a. Nu̱ꞌ nij soꞌ me xi̱i Jesucristó cumán ga̱a naá a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Dan me se naraa Nimán Diose̱ nu̱ꞌ nimán Jesucristó, ga̱a ne̱ cavii Jesucristó tuꞌva chráá cuꞌna̱j Jordán, ne̱ caꞌanj soꞌ, va̱j soꞌ rej tacaan, quiꞌyaj Nimán Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ne̱ vi̱j chiha̱a̱ ya̱ güii guun rá síí chre̱e tiha̱ꞌ yuꞌunj síí chre̱e man Jesucristó, cheꞌé rej guun rá soꞌ canoco̱ꞌ Jesucristó man soꞌ a. Ne̱ a̱ ꞌó xcoꞌ chraa ne cha̱ Jesucristó cunu̱ꞌ vi̱j chiha̱a̱ güii maꞌ. Ga̱a quisíj nu̱ꞌ vi̱j chiha̱a̱ güii, ga̱a ne̱ quinaꞌaan ndoꞌo rque Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ga̱a ne̱ dan me se cataj síí chre̱e rihaan Jesucristó, ne̱: ―Sese ya̱ ya̱ taꞌni̱j Diose̱ mé so̱ꞌ, ne̱ cata̱j so̱ꞌ rihaan yahij nihánj se vaa gu̱un yoꞌ rachrúún cha̱ so̱ꞌ á ―taj síí chre̱e rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ, ne̱: ―Danj Diose̱ taj: “Nuveé ina̱nj se chá me se achiin rihaan yuvii̱, ne̱ caꞌve̱e ca̱yáán sa̱ꞌ yuvii̱ maꞌ”. Ina̱nj da̱nj taj danj Diose̱ ―taj Jesucristó rihaan síí chre̱e yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ga̱a ne̱ dan me se nica̱j síí chre̱e man Jesucristó cavii soꞌ ꞌo̱ rej xta̱ꞌ ndoꞌo, ga̱a ne̱ tihaa̱n soꞌ man cunuda̱nj nij chumanꞌ na̱j rihaan chumii̱ rihaan Jesucristó rque o̱rúnꞌ orá nii a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ga̱a ne̱ cataj soꞌ rihaan Jesucristó, ne̱: ―Rque̱ ꞌu̱nj nu̱ꞌ chumanꞌ nihánj do̱ꞌ, nu̱ꞌ se sa̱ꞌ ma̱n nij chumanꞌ nihánj do̱ꞌ, mán so̱ꞌ a. ꞌO̱ se a̱j caꞌvej Diose̱ gu̱un chij ꞌu̱nj rihaan nij chumanꞌ yoꞌ, ne̱ cheꞌé dan caꞌve̱e qui̱ꞌyáj gu̱un chij náá guun yuvii̱ rihaan chumanꞌ yoꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Cheꞌé dan sese canicu̱nꞌ ru̱j so̱ꞌ rihanj, ne̱ gu̱un si̱ꞌyáá so̱ꞌ man nu̱ꞌ nihánj, qui̱ꞌyáj ado̱nj. ―Da̱nj cataj síí chre̱e rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ne̱ canica̱j Jesucristó cataj Jesucristó rihaan síí chre̱e: ―Daj chiha̱a̱ míj se̱ canicunꞌ ru̱j ꞌu̱nj rihaan so̱ꞌ a̱ maꞌ. ꞌO̱ se danj Diose̱ taj nana̱ nihánj, se vaa: “Rihaan o̱rúnꞌ Diose̱ síí ꞌni̱j raꞌa man níꞌ canicu̱nꞌ ru̱j so̱ꞌ, ne̱ a̱ ꞌó rihaan tuvíꞌ so̱ꞌ se̱ caꞌvee naꞌvi̱j so̱ꞌ maꞌ”. Da̱nj taj danj Diose̱ ado̱nj ―taj Jesucristó rihaan síí chre̱e yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ga̱a ne̱ nica̱j síí chre̱e man Jesucristó caꞌanj soꞌ chumanꞌ Jerusalén, ne̱ tacavii soꞌ man Jesucristó raa̱ nuvií noco̱o, ");
INSERT INTO trcNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ne̱ cataj soꞌ rihaan soꞌ, ne̱: ―Sese ya̱ taꞌni̱j Diose̱ mé so̱ꞌ, ne̱ güe̱j so̱ꞌ, ne̱ nani̱j gue̱e̱ so̱ꞌ rihaan yoꞌóó á. ꞌO̱ se danj Diose̱ taj: “Caꞌne̱ꞌ Diose̱ suun rihaan nij se‑mo̱zó soꞌ se vaa cu̱tumé nij soꞌ mán so̱ꞌ a”, taj danj Diose̱, ne̱ taj uún yoꞌ: ");
INSERT INTO trcNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","“Ca̱ráán raꞌa nij soꞌ mán so̱ꞌ, se̱ gaa na̱nj cano̱ cheꞌé so̱ꞌ yahij maꞌ”. Da̱nj aꞌmii danj Diose̱ ―taj síí chre̱e rihaan Jesucristó ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ga̱a ne̱ cataj Jesucristó rihaan síí chre̱e a: ―Tza̱j ne̱ ne nó xcúnj qui̱ꞌyáj da̱nj maꞌ. ꞌO̱ se taj uún danj Diose̱ a: “Se̱ guun qui̱riꞌyunj so̱ꞌ man Diose̱ síí ꞌni̱j raꞌa man níꞌ, ne̱ ti̱háꞌ so̱ꞌ man soꞌ maꞌ”. Ina̱nj da̱nj aꞌmii danj Diose̱ rihaan níꞌ ado̱nj ―taj Jesucristó rihaan síí chre̱e a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Da̱nj quiꞌyaj síí chre̱e, tza̱j ne̱ a̱ doj ne cuchuma̱n rá Jesucristó a̱ man ado̱nj. Ga̱a ne̱ caꞌneꞌ rá síí chre̱e do̱j güii ga̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Dan me se nanꞌ Jesucristó estadó Galilea, ne̱ yoꞌo̱ racuíj ndoꞌo Nimán Diose̱ man soꞌ, ne̱ cuchiꞌ nana̱ cheꞌé soꞌ rihaan nij yuvii̱ ma̱n nu̱ꞌ nij chumanꞌ na̱j estadó Galilea a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Caꞌanj Jesucristó daj a̱ nij veꞌ tucuꞌyón nij yuvii̱ israelitá se‑tucua̱nj Moisés, ne̱ tucuꞌyón soꞌ se‑na̱na̱ Diose̱ man nij yuvii̱, ne̱ veꞌé uxrá caꞌmii taranꞌ nij yuvii̱ cheꞌé soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ga̱a ne̱ dan me se nucuiꞌ uún Jesucristó chiháán soꞌ chumanꞌ Nazaret rej cachij soꞌ a. Ga̱a quisíj güii naránj rá nij yuvii̱ israelitá, ne̱ catúj soꞌ rá veꞌ tucuꞌyón nij soꞌ se‑tucua̱nj Moisés, ése̱ da̱nj ina̱nj cuꞌyón soꞌ quiꞌya̱j soꞌ a. Ga̱a ne̱ canicunꞌ caya̱ soꞌ naya̱a̱ soꞌ danj Diose̱ rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Síí tumé yanj quirii yanj no̱ nana̱ cachrón síí cuꞌna̱j Isaías síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá, ne̱ caxríj soꞌ ston Jesucristó a. Nacuchraꞌ Jesucristó yanj, ne̱ nariꞌ soꞌ rej no̱ nana̱ nihánj a: ");
INSERT INTO trcNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ya̱nj Nimán Diose̱ ga̱ ꞌu̱nj, ne̱ cheꞌé dan narii Diose̱ manj caꞌa̱nj caꞌmi̱i̱ natáj ꞌu̱nj nana̱ sa̱ꞌ rihaan nij síí nique̱ a. Caꞌnéé Diose̱ manj caꞌmi̱i̱ natáj ꞌu̱nj rihaan nij síí ꞌni̱j tagaꞌ cata̱j ꞌu̱nj se vaa cu̱riha̱nj nij soꞌ cache̱e̱ yu̱u̱n nij soꞌ a. Ne̱ caꞌnéé Diose̱ manj ra̱cuíj ꞌu̱nj man nij síí tuchri̱i naxra̱ꞌ rihaan nij soꞌ, ne̱ caꞌnéé Diose̱ manj ra̱cuíj ꞌu̱nj man nij síí ranꞌ sayuun uún na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Caꞌnéé Diose̱ manj cata̱j xnaꞌanj ꞌu̱nj se vaa ya̱j roꞌ, me rá Diose̱ cavi̱i̱ sa̱ꞌ nij síí noco̱ꞌ man soꞌ quiꞌya̱j soꞌ ado̱nj.” ");
INSERT INTO trcNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nu̱ꞌ nihánj me nana̱ nayaa Jesucristó, ga̱a ne̱ nacué uún soꞌ yanj ne̱ nagoꞌ uún soꞌ man síí tumé yanj, ga̱a ne̱ caꞌanj quita̱j soꞌ chruun xlá a. Tza̱j ne̱ niꞌya̱j uxrá cunuda̱nj nij yuvii̱ ma̱n rque veꞌ yoꞌ man soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ne̱ cheꞌé dan caꞌmii uún soꞌ, cataj soꞌ: ―Veé cuano̱ nihánj me se a̱j quisíj ya̱ nu̱ꞌ nana̱ nihánj, ne̱ ꞌu̱nj si̱j nayaa nana̱ nihánj cuno soj me síí quiꞌya̱j nu̱ꞌ se vaa taj nana̱ nihánj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Sa̱ꞌ uxrá caꞌmii Jesucristó, cataj nij yuvii̱, ne̱ caráyaꞌa̱nj nij soꞌ cuno nij soꞌ se vaa veꞌé uxrá vaa nana̱ caꞌmii Jesucristó a. Ga̱a ne̱ dan me se xnáꞌanj nij soꞌ man tuviꞌ nij soꞌ sese nuveé taꞌni̱j José síí ne̱ chiháán níꞌ me soꞌ, xnáꞌanj nij soꞌ man tuviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Cheꞌé dan me caꞌmii Jesucristó nana̱ nihánj rihaan nij soꞌ a: ―Neꞌén ꞌu̱nj se vaa cata̱j soj nana̱ nihánj rihanj a: “Sese ya̱ si̱j ꞌyaj conoꞌó mé so̱ꞌ, ne̱ quiꞌya̱j conoꞌó so̱ꞌ man ma̱ꞌán so̱ꞌ á”, cata̱j soj rihanj cheꞌé se cuno soj se vaa queꞌe̱e̱ suun sa̱ꞌ noco̱o quiꞌyáj chumanꞌ Capernaum a. Ne̱ cata̱j soj rihanj se vaa qui̱ꞌyáj suun sa̱ꞌ noco̱o tuviꞌ yoꞌ chumanꞌ chiháán níꞌ nihánj uún a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Tza̱j ne̱ vaa nana̱ nihánj nana̱ cata̱j ma̱ꞌanj rihaan soj uún a: “Xa̱ꞌ síí nataꞌ se‑na̱na̱ Diose̱, tza̱j ne̱ ne amán rá tuviꞌ soꞌ niꞌya̱j nij soꞌ man soꞌ maꞌ”, me nana̱ taj ꞌu̱nj no soj a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","”Dan me se cuno̱ soj caꞌmi̱j á. Neꞌen soj se vaa ga̱a cayáán síí cuꞌna̱j Elías síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá, ne̱ cachén vaꞌnu̱j yoꞌ táá yanéé, ne̱ ne cama̱nꞌ, ne̱ cheꞌé dan guun uxrá xꞌnaa nu̱ꞌ chiháán nij síí israelitá, ne̱ yoꞌ dan me se cayáán queꞌe̱e̱ chana̱ caviꞌ nica̱ chiháán nij síí israelitá a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tza̱j ne̱ a̱ ꞌó chana̱ nique̱ cayáán chiháán nij síí israelitá roꞌ, ne caꞌne̱j Diose̱ man Elías rihaan noꞌ, ra̱cuíj soꞌ man noꞌ maꞌ. Ma̱a̱n se rihaan o̱rúnꞌ chana̱ nique̱ ne̱ chumanꞌ Sarepta chumanꞌ noco̱ꞌ man chumanꞌ Sidón caꞌnéé Diose̱ man Elías, ne̱ nda̱ꞌ se nuveé cha̱na̱ israelitá me noꞌ, tza̱j ne̱ racuíj Elías man noꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","”Ne̱ neꞌen soj se vaa queꞌe̱e̱ yuvii̱ quiranꞌ ndoꞌo luj riꞌyuj cayáán chiháán nij síí israelitá ga̱a cayáán síí cuꞌna̱j Eliseo síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá a. Tza̱j ne̱ a̱ ꞌó nij soꞌ ne nahu̱un maꞌ. Ma̱a̱n se o̱rúnꞌ síí cuꞌna̱j Naamán síí cavii rej yaníj cuꞌna̱j Siria nahuun, quiꞌyaj Eliseo ado̱nj. ―Da̱nj cataj Jesucristó rihaan nij síí ma̱n rá veꞌ tucuꞌyón nii se‑tucua̱nj Moisés veꞌ ne̱ chiháán nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Cuno nij yuvii̱ nda̱a vaa cavii sa̱ꞌ nij síí ma̱n chumanꞌ yaníj, ne̱ guun xco̱j ruva̱a̱ rá nij soꞌ, ga̱a ne̱ caꞌmaan rá nij soꞌ niꞌya̱j nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Naxuma̱a̱n nij soꞌ nica̱j nij soꞌ man Jesucristó caꞌanj nij soꞌ tuꞌva chumanꞌ a. Ne̱ dan me se chumanꞌ yoꞌ roꞌ, naj xráá ꞌo̱ tacaan ruva̱a̱ ndoꞌo a. Ne̱ nica̱j nij soꞌ man Jesucristó caꞌanj nij soꞌ rej ruva̱a̱, ne̱ guun rá nij soꞌ ta̱nij nij soꞌ man Jesucristó rej ruva̱a̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tza̱j ne̱ cachén Jesucristó scaꞌnúj nij yuvii̱, ne̱ caꞌanj soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ga̱a ne̱ caꞌanj Jesucristó chumanꞌ Capernaum chumanꞌ na̱j estadó Galilea, ne̱ güii naránj rá nij yuvii̱ israelitá caꞌanj Jesucristó veꞌ tucuꞌyón nij soꞌ se‑tucua̱nj Moisés, ne̱ tucuꞌyón soꞌ se‑na̱na̱ Diose̱ man nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ne̱ caráyaꞌa̱nj nij yuvii̱ se‑na̱na̱ soꞌ, cheꞌé rej ase vaa aꞌmii ꞌo̱ síí uun chij ndoꞌo roꞌ, da̱nj caꞌmii soꞌ rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ne̱ dan me se yáán ꞌo̱ síí nu̱u̱ nana̱ chre̱e nimán rá veꞌ yoꞌ, ne̱ nucua̱j ndoꞌo caguáj soꞌ, ne̱ cataj soꞌ se vaa: ");
INSERT INTO trcNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Me cheꞌé raꞌyunj so̱ꞌ man núj, ga̱ Jesús Nazarenoꞌ. ꞌNáꞌ so̱ꞌ ta̱ríꞌ so̱ꞌ man núj naꞌ. Neꞌenj mán so̱ꞌ se vaa síí gue̱e̱ cavii rihaan Diose̱ mé so̱ꞌ ado̱nj ―taj síí nu̱u̱ nana̱ chre̱e nimán rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ga̱a ne̱ canica̱j Jesucristó caxríj yuva̱a̱ soꞌ man nana̱ chre̱e nu̱u̱ nimán snóꞌo yoꞌ, ne̱ cataj soꞌ: ―Dínj tuꞌvá so̱ꞌ cu̱riha̱nj so̱ꞌ cuaj nimán síí nihánj á ―taj Jesucristó rihaan nana̱ chre̱e yoꞌ a. Nda̱a naxruꞌ maꞌa̱n snóꞌo rej tanu̱u̱ nij yuvii̱, quiꞌyaj nana̱ chre̱e, ga̱a ne̱ curiha̱nj nana̱ chre̱e nimán snóꞌo yoꞌ, ne̱ nahuun sa̱ꞌ soꞌ, taj a̱ doj chiꞌii̱ ranꞌ soꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ga̱a ne̱ caꞌanj uxrá rá nij yuvii̱, ne̱ xnáꞌanj nij soꞌ man tuviꞌ nij soꞌ, cataj nij soꞌ: ―Da̱j si̱j me síí aꞌmii nana̱ nihánj, ne̱ uun chij soꞌ rihaan nana̱ chre̱e, ne̱ uriha̱nj nij nana̱ chre̱e nimán yuvii̱ ꞌyaj síí nihánj ga̱ ―taj nij yuvii̱ niꞌya̱j nij yuvii̱ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ga̱a ne̱ cuchiꞌ nana̱ cheꞌé Jesucristó rihaan cunuda̱nj nij yuvii̱ ma̱n nichru̱nꞌ chumanꞌ Capernaum yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Dan me se curiha̱nj Jesucristó rá veꞌ tucuꞌyón nii se‑tucua̱nj Moisés, ne̱ caꞌanj soꞌ tucuá síí cuꞌna̱j Simón a. Ne̱ ranꞌ nii che̱j Simón chiꞌii̱ nacaa yuva̱a̱, ne̱ cheꞌé dan cachíín niꞌya̱j nii rihaan Jesucristó cheꞌé noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ga̱a ne̱ caꞌanj Jesucristó canicunꞌ soꞌ rej tuꞌva yuvéé na̱j noꞌ, ne̱ caꞌneꞌ soꞌ suun rihaan chiꞌii̱ se vaa quixꞌne̱e̱ chiꞌii̱ xráá noꞌ a. Ga̱a ne̱ nu̱ꞌ quixꞌnéj chiꞌii̱ xráá noꞌ, quiꞌyaj Jesucristó a. Ne̱ veé ma̱a̱n orá dan naxaga̱a̱ noꞌ, ne̱ quiꞌyaj chuvi̱i noꞌ cha̱ nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Cataꞌ güii, ne̱ nica̱j nij yuvii̱ cunuda̱nj tuviꞌ nij soꞌ síí ranꞌ, va̱j nij soꞌ rej ne̱ Jesucristó a. Queꞌe̱e̱ ndoꞌo chiꞌii̱ ranꞌ nij soꞌ a. Ne̱ caꞌanj Jesucristó, cutaꞌ soꞌ raꞌa soꞌ raa̱ nda̱a ꞌo̱ ꞌo̱ nij síí ranꞌ, ga̱a ne̱ nahuun taranꞌ nij soꞌ, quiꞌyaj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ne̱ queꞌe̱e̱ nij síí ranꞌ roꞌ, curiha̱nj nana̱ chre̱e nimán uún, ne̱ caguáj nij nana̱ chre̱e yoꞌ, ne̱ cataj nij soꞌ se vaa taꞌníí Diose̱ me Jesucristó a. Tza̱j ne̱ caxríj yuva̱a̱ Jesucristó man nij nana̱ chre̱e, ne̱ ne caꞌve̱j rá Jesucristó caꞌmi̱i̱ nij soꞌ nana̱ vaa da̱nj a. ꞌO̱ se queneꞌen nij soꞌ se vaa si̱j caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun me Jesucristó, ne̱ ne caꞌve̱j rá Jesucristó gu̱un cuentó cheꞌé soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Rej taxre̱j cavii Jesucristó chumanꞌ Capernaum caꞌanj soꞌ rej tacaan a. Ga̱a ne̱ nanoꞌ nij síí ma̱n Capernaum man soꞌ, ne̱ ga̱a nariꞌ nij soꞌ man Jesucristó, ga̱a ne̱ caráán nij soꞌ chrej rihaan Jesucristó, ne̱: ―Se̱ caꞌvee caꞌa̱nj so̱ꞌ rej yaníj maꞌ ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tza̱j ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Vaa ndoꞌo suun rihaan ꞌu̱nj caꞌa̱nj ꞌu̱nj yoꞌó nij chumanꞌ uún, ne̱ nata̱ꞌ ꞌu̱nj nana̱ sa̱ꞌ nihánj rihaan nij síí ne̱ yoꞌó chumanꞌ se vaa gu̱un chij Diose̱ rihaan chumii̱ nihánj ado̱nj. ꞌO̱ se cheꞌé nana̱ sa̱ꞌ nihánj me caꞌnéé Diose̱ manj caꞌna̱j rihaan chumii̱ nihánj caꞌmi̱i̱ natáj ꞌu̱nj rihaan cunuda̱nj nij yuvii̱ ado̱nj ―taj Jesucristó rihaan nij síí ma̱n Capernaum a. ");
INSERT INTO trcNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ga̱a ne̱ caꞌneꞌ rá nij soꞌ, ne̱ caꞌanj Jesucristó nu̱ꞌ nij veꞌ tucuꞌyón nij yuvii̱ israelitá se‑tucua̱nj Moisés veꞌ ya̱nj estadó Judea, ne̱ caꞌmii natáj soꞌ nana̱ sa̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Dan me se ꞌo̱ güii canicunꞌ Jesucristó tuꞌva na lacuaná cuꞌna̱j Genesaret, ne̱ cuchiꞌ uxrá yuvii̱ rej nicu̱nꞌ soꞌ, ne̱ cunuu chre̱ꞌ ndoꞌo nij soꞌ cheꞌé se guun rá nij soꞌ cuno̱ nij soꞌ se‑na̱na̱ Diose̱ a. Dan me se nda̱a raan maꞌa̱n mán nij soꞌ xꞌnúú Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Dan me se queneꞌen Jesucristó vi̱j rihoo na̱j tuꞌva na lacuaná, ne̱ síí uta xcuaj me nij síí siꞌya̱j rihoo yoꞌ, ne̱ tanáj nij soꞌ se‑riho̱o̱ nij soꞌ ꞌo̱ orá nii, ne̱ caꞌanj naꞌnu̱ꞌ nij soꞌ xnánj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Dan me se catúj Jesucristó rá ꞌo̱ rihoo, ne̱ se‑riho̱o̱ síí cuꞌna̱j Simón me yoꞌ, ne̱ cachíín niꞌya̱j Jesucristó rihaan Simón se vaa quiꞌya̱j soꞌ se ndoꞌo cuxu̱u̱n soꞌ rihoo caꞌa̱nj rihoo yoꞌ do̱j rihaan na a. Ga̱a ne̱ cayáán Jesucristó rque rihoo, ne̱ tucuꞌyón soꞌ se‑na̱na̱ Diose̱ man nij yuvii̱ ma̱n tuꞌva na a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Quisíj tucuꞌyón Jesucristó man nij yuvii̱, ga̱a ne̱ cataj soꞌ rihaan Simón, ne̱: ―Ni̱caj so̱ꞌ rihoo caꞌa̱nj so̱ꞌ rej cunu̱u̱ doj na, ga̱a ne̱ ti̱guíj soj nanj rá na á ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tza̱j ne̱ cataj Simón rihaan Jesucristó, ne̱: ―Niga̱nꞌ quiꞌyaj suun uxrá núj, tiguíj ndoꞌo núj nanj rá na, tza̱j ne̱ a̱ ꞌó xcuaj ne quiri̱ꞌ núj, man maestro. Tza̱j ne̱ ma̱a̱n cheꞌé se ma̱ꞌán so̱ꞌ cataj, ne̱ caꞌa̱nj ti̱guíj uún núj nanj rá na na̱nj á ―taj Simón rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Dan me se caꞌanj ti̱guíj uún nij tuvi̱ꞌ Simón nanj rá na, ne̱ quiriꞌ uxrá nij soꞌ xcuaj nda̱a quisinꞌ maꞌa̱n xnánj nij soꞌ, quiꞌyaj xcuaj a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Cheꞌé dan canacúún nij soꞌ man tuviꞌ nij soꞌ síí nu̱u̱ rque yoꞌó rihoo, cheꞌé rej guun rá nij soꞌ ra̱cuíj tuviꞌ nij soꞌ man nij soꞌ a. Dan me se caꞌnaꞌ nij tuviꞌ nij soꞌ yan nicu̱nꞌ nij soꞌ, ne̱ caraa uxrá nij soꞌ xcuaj rque ro̱j rihoo a. Ne̱ uxrá caraa ro̱j rihoo, ne̱ da̱j doj se caꞌanj ni̱j ro̱j rihoo rque na na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Dan me se queneꞌen Simón Pedró se vaa quiꞌyaj Jesucristó, ga̱a ne̱ caꞌanj canicu̱nꞌ ru̱j soꞌ rihaan Jesucristó, cataj soꞌ: ―Nuveé si̱j canicu̱nꞌ nichru̱nꞌ rihaan so̱ꞌ mej a̱ maꞌ. Si̱j ata̱ ndoꞌo cacunꞌ mej na̱nj á ―taj Simón rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Dan me se caꞌanj ndoꞌo rá nij tuvi̱ꞌ Simón se vaa quiriꞌ uxrá nij soꞌ xcuaj a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ne̱ caꞌanj rá síí cuꞌna̱j Jacobo do̱ꞌ, síí cuꞌna̱j Juan do̱ꞌ, cheꞌé xcuaj a. Ne̱ tuvi̱ꞌ Simón me ro̱j soꞌ, ne̱ taꞌníí síí cuꞌna̱j Zebedeo me ro̱j soꞌ a. Ne̱ dan me se cataj Jesucristó rihaan Simón, ne̱: ―Se̱ cuchuꞌvíꞌ so̱ꞌ maꞌ. ꞌO̱ se rej rihaan níꞌ me se guún so̱ꞌ síí naquiꞌya̱j chre̱ꞌ yuvii̱ canoco̱ꞌ yuvii̱ manj á ―taj Jesucristó rihaan Simón a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ga̱a ne̱ nica̱j nij soꞌ se‑riho̱o̱ nij soꞌ caꞌanj nij soꞌ nda̱a tuꞌva na a. Ga̱a ne̱ tanáj nij soꞌ cunuda̱nj nij rasu̱u̱n yoꞌ, ne̱ canocoꞌ nij soꞌ man Jesucristó, ne̱ caꞌanj nij soꞌ ga̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Dan me se ꞌo̱ güii caranꞌ Jesucristó ꞌo̱ chumanꞌ, ne̱ cuchiꞌ ꞌo̱ síí ranꞌ ndoꞌo luj riꞌyuj rihaan soꞌ a. Ga̱a queneꞌen síí ranꞌ yoꞌ man Jesucristó, ga̱a ne̱ canicunꞌ ru̱j soꞌ rihaan Jesucristó, ne̱ cachíín niꞌya̱j soꞌ rihaan Jesucristó, cataj soꞌ: ―Sese me rá so̱ꞌ, ne̱ caꞌve̱e caꞌne̱e̱ so̱ꞌ chiꞌii̱ xráj, Señor ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ga̱a ne̱ cutaꞌ Jesucristó raꞌa Jesucristó raa̱ síí ranꞌ, ne̱ cataj Jesucristó: ―Me raj qui̱ꞌyáj da̱nj ei. Na̱huún so̱ꞌ, qui̱ꞌyáj ado̱nj ―taj Jesucristó rihaan soꞌ a. Nu̱ꞌ da̱nj cataj Jesucristó, ne̱ nu̱ꞌ quinavij luj xráá síí ranꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Dan me se caꞌneꞌ Jesucristó suun rihaan síí nahuun yoꞌ, ne̱ se̱ cataj xnaꞌanj soꞌ rihaan a̱ ꞌó yuvii̱ cheꞌé se vaa quiranꞌ soꞌ maꞌ. Ga̱a ne̱ cataj uún Jesucristó rihaan soꞌ a: ―Caꞌa̱nj so̱ꞌ rihaan xrej, ne̱ ti̱haán so̱ꞌ mán so̱ꞌ rihaan xrej se vaa nahuún so̱ꞌ, ne̱ rque̱ so̱ꞌ rihaan Diose̱ se vaa cataj síí cuꞌna̱j Moisés ga̱a naá nda̱a vaa no̱ xcúún so̱ꞌ rque̱ so̱ꞌ rihaan Diose̱ cheꞌé yan nahuún so̱ꞌ ado̱nj. Ga̱a ne̱ xca̱j nij xrej cuentá se vaa nahuún so̱ꞌ quiꞌyáj ado̱nj ―taj Jesucristó rihaan síí nahuun yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tza̱j ne̱ chaꞌnuu̱ ndoꞌo nana̱ cheꞌé se vaa quiranꞌ síí nahuun yoꞌ, ne̱ cheꞌé dan cunuu chre̱ꞌ ndoꞌo nij yuvii̱ rej va̱j Jesucristó a. Guun rá nij soꞌ cuno̱ nij soꞌ se‑na̱na̱ Jesucristó, ne̱ guun rá nij síí ranꞌ xꞌne̱e̱ chiꞌii̱ xráá nij soꞌ uún a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tza̱j ne̱ naxuun Jesucristó man soꞌ rihaan nij yuvii̱, ne̱ caꞌanj soꞌ rej tacaan, ne̱ cachíín niꞌya̱j ndoꞌo soꞌ rihaan Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ꞌO̱ güii me se ne̱ Jesucristó rá ꞌo̱ veꞌ, ne̱ tucuꞌyón soꞌ se‑na̱na̱ Diose̱ man yuvii̱, ne̱ ne̱ do̱j síí fariseo ga̱ síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rá veꞌ yoꞌ, ne̱ mán síí cavii chumanꞌ Jerusalén do̱ꞌ, yoꞌó nij chumanꞌ na̱j estadó Judea do̱ꞌ, nij chumanꞌ na̱j estadó Galilea do̱ꞌ, mán ga̱ nij soꞌ rá veꞌ yoꞌ a. Ne̱ Diose̱ síí ꞌni̱j raꞌa man níꞌ roꞌ, racuíj ndoꞌo man Jesucristó, ne̱ nahuun ndoꞌo nij síí ranꞌ, quiꞌyaj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Dan me se táá ꞌo̱ síí naꞌvee cache̱e̱ rihaan yuvéé, ne̱ táá chiha̱ nii man soꞌ caꞌnaꞌ nii rihaan Jesucristó a. Tza̱j ne̱ ma̱n ndoꞌo yuvii̱ rá veꞌ ne̱ Jesucristó, ne̱ nanoꞌ nij soꞌ rej catu̱u̱ nij soꞌ rá veꞌ cuchru̱j nij soꞌ man síí ranꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tza̱j ne̱ taj se qui̱ꞌyáꞌ caꞌve̱e cache̱n nij soꞌ scaꞌnúj nij yuvii̱ a. Cheꞌé dan cavii nij soꞌ xráá veꞌ, ne̱ cayaꞌ nij soꞌ yuꞌuj xráá veꞌ, cheꞌé rej caꞌve̱e ti̱nanij nij soꞌ man síí ranꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ga̱a queneꞌen Jesucristó se vaa cuchumán uxrá rá nij tuvi̱ꞌ síí ranꞌ yoꞌ se vaa caꞌve̱e nahu̱un soꞌ quiꞌya̱j Jesucristó, ga̱a ne̱ cataj Jesucristó rihaan síí ranꞌ yoꞌ, ne̱: ―Navij cacunꞌ xráá so̱ꞌ, na̱nj tinu̱j ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ne̱ cuno nij síí fariseo cuno nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés cuno nana̱ caꞌmii Jesucristó, ga̱a ne̱ nuchruj ra̱a̱ nij soꞌ nana̱ nihánj ga̱ tuviꞌ nij soꞌ a: ―Da̱j si̱j me síí nihánj, ne̱ aꞌmii soꞌ nana̱ vaa nij rihaan Diose̱ ga̱. O̱rúnꞌ Diose̱ uun nucua̱j tinavi̱j cacunꞌ xráá yuvii̱ na̱nj á ―taj nij soꞌ ga̱ tuviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Queneꞌen Jesucristó da̱j nuchruj ra̱a̱ nij soꞌ, ne̱ cheꞌé dan cataj soꞌ rihaan nij soꞌ a: ―Me cheꞌé nuchruj ra̱a̱ soj nana̱ na̱nj ga̱. ");
INSERT INTO trcNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Tuꞌva rma̱ꞌán ꞌu̱nj se vaa navij cacunꞌ xráá síí nihánj, rá soj a̱ naꞌ. Caꞌve̱e cata̱j u̱u̱n níꞌ navij cacunꞌ xráá síí nihánj naꞌ. Ase caꞌve̱e doj cata̱j níꞌ na̱xagaa soꞌ, ne̱ cache̱e̱ soꞌ cuaj, cata̱j níꞌ xa̱ꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Dan me se me rá ꞌu̱nj xca̱j soj cuentá se vaa síí caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ mej ne̱ no̱ xcúún ꞌu̱nj ti̱navíí ꞌu̱nj cacunꞌ xráá nij yuvii̱ ma̱n rihaan chumii̱ nihánj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. Dan me se cataj Jesucristó rihaan síí naꞌvee cache̱e̱ a: ―Rihaan so̱ꞌ si̱j naꞌvee cache̱e̱ taj ꞌu̱nj, ne̱ nacue̱ so̱ꞌ tuvéé so̱ꞌ, ne̱ nánꞌ so̱ꞌ tucuá so̱ꞌ á ―taj Jesucristó rihaan síí na̱j rihaan yuvéé yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nu̱ꞌ da̱nj tuꞌva Jesucristó, ga̱a ne̱ nu̱ꞌ naxaga̱a̱ síí ranꞌ yoꞌ niꞌya̱j taranꞌ nij yuvii̱ a. Ga̱a ne̱ nacué soꞌ tuvéé soꞌ, ga̱a ne̱ nanꞌ soꞌ tucuá soꞌ, ne̱ veꞌé uxrá caꞌmii soꞌ cheꞌé Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Dan me se caꞌanj rá taranꞌ nij yuvii̱ ma̱n rá veꞌ yoꞌ, ne̱ cataj nij yuvii̱ se vaa veꞌé uxrá quiꞌyaj Diose̱ a. Ne̱ cuchuꞌviꞌ ndoꞌo nij yuvii̱, ne̱ cataj nij yuvii̱ se vaa: ―Niha̱ꞌ uxrá vaa suun sa̱ꞌ noco̱o queneꞌen níꞌ cuanꞌ ado̱nj ―taj nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Quisíj nahuun síí ranꞌ yoꞌ, ga̱a ne̱ curiha̱nj Jesucristó xeꞌ, ne̱ queneꞌen soꞌ man ꞌo̱ síí aꞌnéj puextó cuꞌna̱j Leví a. Ne̱ ne̱ síí cuꞌna̱j Leví ꞌo̱ veꞌ aꞌnéj nii puextó man yuvii̱ a. Ga̱a ne̱ cataj Jesucristó rihaan soꞌ, ne̱: ―Ca̱nocóꞌ so̱ꞌ manj, caꞌa̱nj níꞌ á ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ga̱a ne̱ tanáj Leví man cunuda̱nj rasu̱u̱n nica̱j soꞌ, ne̱ naxuma̱a̱n soꞌ, canocoꞌ soꞌ man Jesucristó, caꞌanj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ga̱a ne̱ canuû ndoꞌo chaꞌanj noco̱o tucuá Leví cheꞌé Jesucristó, quiꞌyaj Leví a. Ne̱ ma̱n queꞌe̱e̱ ndoꞌo tuviꞌ soꞌ síí aꞌnéj puextó do̱ꞌ, queꞌe̱e̱ yoꞌó yuvii̱ do̱ꞌ, mán tucuá Leví, ne̱ ne̱ nij soꞌ ga̱ nij tuvi̱ꞌ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Dan me se ma̱n nij síí fariseo do̱ꞌ, síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés noco̱ꞌ man nij síí fariseo do̱ꞌ, ga̱a ne̱ caꞌmii chiꞌi̱i̱ nij soꞌ cheꞌé Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ Jesucristó a. Dan me se cataj nij síí fariseo ga̱ nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés: ―Me cheꞌé chá soj chraa ne̱ ꞌo soj na ga̱ nij síí aꞌnéj puextó do̱ꞌ, ga̱ yoꞌó nij síí tumé cacunꞌ do̱ꞌ, ga̱ ―taj nij soꞌ, xnáꞌanj nij soꞌ man nij síí tucuꞌyón se‑na̱na̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ga̱a ne̱ dan me se cataj maꞌa̱n Jesucristó rihaan nij soꞌ a: ―Síí vaa nucua̱j roꞌ, ne nanoꞌ nij soꞌ man doctor maꞌ. Ma̱a̱n se síí ranꞌ roꞌ, me síí nanoꞌ man doctor ado̱nj. Ga̱a ne̱ ase vaa síí ranꞌ roꞌ, da̱nj vaa nij síí nihánj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ꞌO̱ se ne caꞌna̱ꞌ ꞌu̱nj canacu̱nj ꞌu̱nj man síí sa̱ꞌ maꞌ. Cheꞌe̱ nij síí tumé cacunꞌ caꞌnaj se vaa ca̱nica̱j nimán nij soꞌ ne̱ canoco̱ꞌ nij soꞌ se‑na̱na̱j ado̱nj. Tza̱j ne̱ sese síí sa̱ꞌ me soj, rá soj, ne̱ nuveé si̱j canacu̱nj ꞌu̱nj man me soj maꞌ ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ga̱a ne̱ nij síí fariseo ga̱ nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés me se cataj nij soꞌ rihaan Jesucristó a: ―Me cheꞌé, ne̱ nij síí tucuꞌyón se‑na̱na̱ Juan síí utaꞌ ne man yuvii̱ me se tocoꞌ nij soꞌ xꞌnaa man maꞌa̱n nij soꞌ do̱ꞌ, naꞌvíj nij soꞌ do̱ꞌ, ne̱ veé da̱nj ꞌyaj nij síí tucuꞌyón se‑na̱na̱ núj si̱j fariseo do̱ꞌ, tza̱j ne̱ nij síí tucuꞌyón se‑na̱na̱ so̱ꞌ me se ne tocoꞌ nij soꞌ xꞌnaa man maꞌa̱n nij soꞌ do̱ꞌ, ne naꞌvíj nij soꞌ do̱ꞌ, rihaan Diose̱ ga̱ ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ne̱ cataj Jesucristó rihaan nij soꞌ: ―Ase vaa síí cuchruj saꞌanj vaa ꞌu̱nj, ne̱ asa̱ꞌ caꞌve̱e toco̱ꞌ nij síí ma̱n ga̱j xꞌnaa man maꞌa̱n nij soꞌ, rá soj ga̱. Ase vaa síí cataj xca̱j man chana̱ ne̱ ma̱n tuviꞌ soꞌ do̱ꞌ, da̱nj vaa nij síí ma̱n nihánj cuano̱, ne̱ anuû ndoꞌo chaꞌanj man nij soꞌ, ne̱ se̱ caꞌvee toco̱ꞌ nij soꞌ xꞌnaa man maꞌa̱n nij soꞌ cuano̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tza̱j ne̱ vaa güii, ne̱ gu̱un yaníj ꞌu̱nj rihaan nij soꞌ, quiꞌya̱j yuvii̱, ga̱a ne̱ nano̱ rá nij síí nihánj, ga̱a ne̱ toco̱ꞌ nij soꞌ xꞌnaa man maꞌa̱n nij soꞌ ado̱nj ―taj Jesucristó rihaan nij síí fariseo ga̱ nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ga̱a ne̱ caꞌmii Jesucristó yoꞌó nana̱ rihaan nij soꞌ, cataj soꞌ: ―Ase vaa yatzíj sinꞌ vaa tucuáán nga̱ noco̱ꞌ soj, ne̱ se̱ guun cusi̱nꞌ níꞌ yatzíj naca̱ ne̱ naꞌne̱j níꞌ man yatzíj nga̱ maꞌ. Sese da̱nj quiꞌya̱j níꞌ, ga̱a ne̱ quiri̱ꞌ nu̱ꞌ yatzíj naca̱ yoꞌ, quiꞌya̱j yatzíj nga̱ na̱nj ado̱nj. Ga̱a ne̱ ino̱ uxrá ga̱a̱ yatzíj naca̱, quiꞌya̱j yatzíj nga̱ yoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ne̱ dan me se ase vaa nuj nga̱ nuj araa nii na vinó vaa uún soj a. Ne̱ se̱ caꞌvee tu̱cuꞌyón ꞌu̱nj se‑tucua̱nj ꞌu̱nj man soj maꞌ. ꞌO̱ se ase vaa na vinó naca̱ vaa nana̱ tucuꞌyón ꞌu̱nj, ne̱ se̱ guun cara̱a yuvii̱ na vinó naca̱ rque nuj nga̱ maꞌ. Sese da̱nj quiꞌya̱j yuvii̱, ne̱ cuya̱nj na vinó cunu̱u xe̱e̱ na vinó, ne̱ se̱ cacuá nuj nga̱ maꞌ. Cheꞌé dan canu̱u̱ yoꞌ, ne̱ caya̱nj na vinó rihaan yoꞌóó a. ");
INSERT INTO trcNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Cheꞌé dan araa nii na vinó naca̱ rque nuj naca̱, ne̱ ꞌo̱ mán sa̱ꞌ na vinó rque nuj yoꞌ a. Cheꞌé dan ina̱nj rihaan síí naca̱ síí ne nocoꞌ tucuáán nga̱ tu̱cuꞌyón ꞌu̱nj se‑na̱na̱j na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ne̱ taj síí gu̱un rá coꞌo̱ na vinó naca̱, sese a̱j coꞌo soꞌ na vinó nga̱ maꞌ. ꞌO̱ se sa̱ꞌ doj vaa na nga̱, cata̱j soꞌ na̱nj á. Ne̱ da̱nj vaa gue̱e̱ soj, ina̱nj tucuáán nga̱ nocoꞌ soj, ne̱ cheꞌé dan naꞌvej soj canoco̱ꞌ soj tucuáán naca̱ na̱nj ado̱nj. ―Da̱nj cataj Jesucristó rihaan nij síí fariseo do̱ꞌ, rihaan nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ꞌO̱ güii naránj rá nij yuvii̱ israelitá cachén Jesucristó ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ rque ꞌo̱ naa̱ ꞌnúú trigó a. Ne̱ cuta nij síí tucuꞌyón se‑na̱na̱ Jesucristó do̱j caa trigó, ne̱ tuguáj raꞌa nij soꞌ caa, ga̱a ne̱ chá nij soꞌ do̱j trigó a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ga̱a ne̱ xnáꞌanj taꞌa̱j síí fariseo man nij soꞌ, cataj nij soꞌ: ―Me cheꞌé ꞌyaj soj da̱nj ga̱. Ne nó xcúún níꞌ cuta̱ níꞌ trigó güii naránj rá maꞌ ―taj nij síí fariseo rihaan nij síí tucuꞌyón se‑na̱na̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tza̱j ne̱ cataj maꞌa̱n Jesucristó rihaan nij síí fariseo a: ―Me cheꞌé, ne̱ ne naya̱a̱ soj rihaan danj Diose̱ da̱j quiꞌyaj síí cuꞌna̱j David ga̱a naá a. Ga̱a quinaꞌaan rque nij tuvi̱ꞌ nij soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ga̱a ne̱ catúj soꞌ rá nuvií, ne̱ chá soꞌ rachrúún ta̱j rihaan se‑mesa̱ Diose̱ a. Ne̱ goꞌ uún soꞌ chá nij tuviꞌ soꞌ uún a. Ne̱ ne nó xcúún nij soꞌ cha̱ nij soꞌ rachrúún yoꞌ, ma̱a̱n se o̱rúnꞌ nij xrej nó xcúún cha̱ rachrúún yoꞌ a. Tza̱j ne̱ ma̱a̱n cheꞌé se rque nij soꞌ naꞌaan uxrá, ga̱a ne̱ chá nij soꞌ rachrúún yoꞌ na̱nj ado̱nj. Tza̱j ne̱ ne cata̱j Diose̱ se vaa tumé síí cuꞌna̱j David cacunꞌ maꞌ ―taj Jesucristó rihaan nij síí fariseo a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ga̱a ne̱ canica̱j soꞌ, cataj uún soꞌ a: ―Síí caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ mej, ne̱ no̱ xcúnj quiri̱i̱ taꞌngaj da̱j quiꞌya̱j yuvii̱ güii naránj rá yuvii̱ ado̱nj ―taj Jesucristó rihaan nij síí fariseo a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Dan me se yoꞌó güii naránj rá nij yuvii̱ israelitá roꞌ, catúj Jesucristó rque ꞌo̱ veꞌ tucuꞌyón nij soꞌ se‑tucua̱nj Moisés, ne̱ tucuꞌyón soꞌ se‑na̱na̱ Diose̱ man nij yuvii̱ a. Ne̱ dan me se yáán ꞌo̱ snóꞌo rá veꞌ yoꞌ, ne̱ nacoo̱ raꞌa soꞌ rej nuva̱ꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ne̱ nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ, nij síí fariseo do̱ꞌ, yáán nij soꞌ rá veꞌ, ne̱ tumé uxrá nij soꞌ man Jesucristó sese nahu̱un yuvii̱ quiꞌya̱j soꞌ ga̱a güii naránj rá nij soꞌ a. Da̱nj quiꞌyaj nij soꞌ cheꞌé rej guun rá nij soꞌ cuta̱ꞌ nij soꞌ cacunꞌ xráá Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tza̱j ne̱ queneꞌen Jesucristó se vaa guun rá nij soꞌ, ga̱a ne̱ cataj soꞌ rihaan síí nacoo̱ raꞌa a: ―Na̱xuma̱a̱n so̱ꞌ canicu̱nꞌ ca̱yá so̱ꞌ scaꞌnúj á ―taj Jesucristó rihaan soꞌ a. Ga̱a ne̱ naxuma̱a̱n soꞌ, ne̱ canicunꞌ caya̱ soꞌ scaꞌnúj nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ga̱a ne̱ cataj Jesucristó rihaan nij síí nanó chiꞌi̱i̱ rá a: ―Cuano̱ nihánj me se xnáꞌanj ꞌu̱nj man soj cheꞌé güii naránj rá xa̱ꞌ. No̱ xcúún níꞌ ra̱cuíj níꞌ tuviꞌ níꞌ naꞌ. Ase no̱ xcúún níꞌ quiꞌya̱j chiꞌi̱i̱ níꞌ man tuviꞌ níꞌ xa̱ꞌ. Da̱j quiꞌya̱j níꞌ rá soj ga̱a güii naránj rá níꞌ ga̱. Ne nó xcúún níꞌ ti̱nanii níꞌ man tuviꞌ níꞌ rihaan sayuun ga̱a güii naránj rá ga̱a̱ a̱ naꞌ. Ni̱ꞌyaj u̱u̱n níꞌ cavi̱ꞌ soꞌ ga̱a güii naránj rá ga̱a̱ a̱ naꞌ. ―Da̱nj taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ga̱a ne̱ niꞌya̱j Jesucristó man cunuda̱nj nij yuvii̱ ma̱n rque veꞌ yoꞌ, ga̱a ne̱ cataj soꞌ rihaan síí nacoo̱ raꞌa a: ―Tu̱cuá so̱ꞌ raꞌá so̱ꞌ á ―taj Jesucristó rihaan soꞌ a. Ne̱ tucuá soꞌ raꞌa soꞌ, ne̱ cunuu sa̱ꞌ raꞌa soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tza̱j ne̱ caꞌmaan ndoꞌo rá nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés ga̱ nij síí fariseo, ne̱ guun rá nij soꞌ ga̱ tuviꞌ nij soꞌ da̱j ga̱a̱ quiꞌya̱j chiꞌi̱i̱ nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Dan me se cachén do̱j güii, ga̱a ne̱ caꞌanj Jesucristó rej quij, caꞌanj cachi̱nj niꞌya̱j soꞌ rihaan Diose̱ a. Niga̱nꞌ quináj soꞌ quij cachíín niꞌya̱j soꞌ rihaan Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Rangaꞌ, ga̱a ne̱ canacúún Jesucristó man cunuda̱nj nij síí tucuꞌyón se‑na̱na̱ soꞌ caꞌna̱ꞌ nij soꞌ rihaan soꞌ, ga̱a ne̱ narii Jesucristó man chuvi̱j nij soꞌ gu̱un nij soꞌ apóstol nata̱ꞌ rihaan yuvii̱ cheꞌé soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ꞌO̱ soꞌ me síí cuꞌna̱j Simón, ne̱ tucuꞌnáj Jesucristó Pedró man soꞌ a. Yoꞌó soꞌ me tinúú Pedró síí cuꞌna̱j Andrés a. Yoꞌó nij soꞌ me Jacobo do̱ꞌ, Juan do̱ꞌ, Felipé do̱ꞌ, Bartolomé do̱ꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo do̱ꞌ, Tomás do̱ꞌ, Jacobo taꞌníí Alfeo do̱ꞌ a. Yoꞌó soꞌ uún me Simón, ne̱ tuviꞌ nij síí me rá cunu̱ꞌ ga̱ gobiernó ne̱ Romá me soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yoꞌó soꞌ me Judas tinúú Jacobo, ne̱ yoꞌó soꞌ uún me Judas Iscariote síí tacuachén man Jesucristó rihaan nij síí ta̱j riꞌyunj man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Dan me se nanij Jesucristó ga̱ chuvi̱j nij apóstol yoꞌ taa rque̱ doj, ne̱ cuchiꞌ nij soꞌ ꞌo̱ rej vaa ta̱a, ne̱ noco̱o doj síí tucuꞌyón se‑na̱na̱ soꞌ mán ga̱ soꞌ a. Ne̱ caꞌnaꞌ ndoꞌo yuvii̱ cavii chumanꞌ Jerusalén do̱ꞌ, yuvii̱ cavii yoꞌó nij chumanꞌ na̱j estadó Judea do̱ꞌ, yuvii̱ cavii rej tuꞌva na yaꞌa̱nj rej na̱j chumanꞌ Tiro ga̱ chumanꞌ Sidón do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ne̱ guun rá nij yuvii̱ cuno̱ nij soꞌ se‑na̱na̱ Jesucristó, ne̱ guun rá nij síí ranꞌ nahu̱un nij soꞌ a. Ne̱ vaa nij yuvii̱ nu̱u̱ nana̱ chre̱e nimán, ne̱ sayu̱u̱n ndoꞌo quiranꞌ nij yuvii̱, quiꞌyaj nana̱ chre̱e, tza̱j ne̱ quirii Jesucristó nana̱ chre̱e nu̱u̱ nimán nij soꞌ, ne̱ cunuu sa̱ꞌ nij soꞌ, quiꞌyaj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ga̱a ne̱ guun rá cunuda̱nj nij yuvii̱ cano̱ raꞌa nij soꞌ xráá Jesucristó cheꞌé se cavii ndoꞌo se nucua̱j man Jesucristó, ne̱ nahuun sa̱ꞌ cunuda̱nj nij yuvii̱, quiꞌyaj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ga̱a ne̱ naxca̱j Jesucristó rihaan soꞌ niꞌya̱j soꞌ man nij síí tucuꞌyón se‑na̱na̱ soꞌ, ga̱a ne̱ cataj soꞌ: ―Cavi̱i̱ sa̱ꞌ taranꞌ soj si̱j nique̱, ne̱ soj me síí ca̱yáán ga̱ Diose̱ ga̱a güii gu̱un chij Diose̱ rihaan chumii̱ nihánj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","”Cavi̱i̱ sa̱ꞌ taranꞌ soj si̱j naꞌaan rque cuano̱ ado̱nj. Vaa güii quiri̱ꞌ soj se cha̱ soj ado̱nj. ”Cavi̱i̱ sa̱ꞌ taranꞌ soj si̱j taꞌvee cuano̱ ado̱nj. Vaa güii caꞌnga̱ꞌ ndoꞌo soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","”Ne̱ cavi̱i̱ sa̱ꞌ ndoꞌo soj sese quita̱j riꞌyunj yuvii̱ man soj do̱ꞌ, sese quiri̱i̱ yaníj yuvii̱ man soj do̱ꞌ, sese caꞌmi̱i̱ yuvii̱ nana̱ nij rihaan soj do̱ꞌ, sese nachri̱ꞌ yuvii̱ ni̱ꞌyaj yuvii̱ man soj se vaa si̱j chiꞌi̱i̱ me soj do̱ꞌ, cheꞌé se me soj síí noco̱ꞌ manj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ ado̱nj. Ne̱ queneꞌe̱n soj se vaa ya̱ cavi̱i̱ sa̱ꞌ soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ga̱a ne̱ güii quira̱nꞌ soj da̱nj me se no̱ xcúún soj gu̱un niha̱ꞌ uxrá rá soj ne̱ güe̱j ndoꞌo soj, cheꞌé se uxrá na̱ruꞌvee Diose̱ rihaan soj asa̱ꞌ cuchiꞌ soj rej xta̱ꞌ ado̱nj. ꞌO̱ se ase vaa ꞌyaj nij yuvii̱ man soj roꞌ, taꞌngaꞌ da̱nj quiꞌyaj xi̱i nij yuvii̱ man nij síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá uún ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","”Tza̱j ne̱ nique̱ ndoꞌo soj si̱j ruꞌvee na̱nj á. Soj si̱j ruꞌvee me se a̱j quiriꞌ soj nu̱ꞌ se sa̱ꞌ ni̱caj soj, ne̱ taj va̱j doj se sa̱ꞌ rque̱ Diose̱ man soj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","”Nique̱ soj si̱j vaa raan rque cuano̱ na̱nj á. Vaa güii quinaꞌa̱an rque soj ado̱nj. ”Nique̱ soj si̱j aꞌngaꞌ cuano̱ na̱nj á. Vaa güii quinano̱ ndoꞌo rá soj do̱ꞌ, taꞌve̱e soj do̱ꞌ, ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","”Ne̱ nique̱ soj si̱j veꞌé ina̱nj aꞌmii cunuda̱nj yuvii̱ cheꞌé na̱nj á. ꞌO̱ se ase vaa veꞌé ina̱nj aꞌmii nij yuvii̱ cheꞌé soj roꞌ, taꞌngaꞌ da̱nj caꞌmii xi̱i nij yuvii̱ cheꞌé nij síí tihaꞌ yuꞌunj se vaa si̱j nataꞌ se‑na̱na̱ Diose̱ me nij soꞌ ga̱a naá a ―taj Jesucristó rihaan cunuda̱nj nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Canica̱j Jesucristó, cataj soꞌ a: ―Tza̱j ne̱ rihaan soj si̱j ma̱n nanó xre̱j roꞌ, cata̱j xnaꞌanj ꞌu̱nj se vaa ga̱a̱ ꞌe̱e̱ rá soj man nij síí ta̱j riꞌyunj niꞌya̱j man soj, ne̱ quiꞌya̱j soj se lu̱j cheꞌé nij síí nachriꞌ niꞌya̱j man soj ei. ");
INSERT INTO trcNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Veꞌé caꞌmi̱i̱ soj rihaan nij síí aꞌmii quij rihaan soj, ne̱ cachi̱nj niꞌya̱j soj rihaan Diose̱ cheꞌé nij síí ꞌyaj se nij man soj a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Sese vaa síí coxro ni̱chrej xruú so̱ꞌ, ne̱ caꞌne̱ꞌ rá so̱ꞌ coxro̱ soꞌ níchrej xruú so̱ꞌ uún a. Sese vaa síí caꞌnéj se‑ro̱to̱ so̱ꞌ, ne̱ caꞌne̱ꞌ rá so̱ꞌ caꞌne̱e̱ soꞌ se‑co̱toó so̱ꞌ uún a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ne̱ me maꞌa̱n yuvii̱ achíín niꞌya̱j rasu̱u̱n rihaan soj, ne̱ go̱ꞌ soj rasu̱u̱n yoꞌ man nij soꞌ ei. Sese vaa yuvii̱ caꞌnéj siꞌyaj soj, ne̱ se̱ nachinꞌ soj siꞌyaj soj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Dan me se da̱j se uun rá soj quiꞌya̱j sa̱ꞌ yuvii̱ rihaan soj roꞌ, taꞌngaꞌ da̱nj quiꞌya̱j sa̱ꞌ soj rihaan yuvii̱ á. ");
INSERT INTO trcNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","”Dan me se ga̱a̱ ꞌe̱e̱ rá soj man cunuda̱nj yuvii̱ ei. Sese ꞌe̱e̱ rá soj man ina̱nj nij síí ꞌe̱e̱ rá man soj, ga̱a ne̱ me cheꞌé na̱ruꞌvee Diose̱ rihaan soj, rá soj ga̱. ꞌO̱ se nda̱a nij síí chiꞌi̱i̱ roꞌ, ꞌe̱e̱ rá nij soꞌ man nij síí ꞌe̱e̱ rá man nij soꞌ na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ne̱ quiꞌya̱j soj se lu̱j rihaan cunuda̱nj yuvii̱ ei. ꞌO̱ se sese quiꞌya̱j soj se lu̱j rihaan ina̱nj síí ꞌyaj se lu̱j rihaan soj, ga̱a ne̱ me cheꞌé na̱ruꞌvee Diose̱ rihaan soj, rá soj ga̱. ꞌO̱ se nda̱a nij síí chiꞌi̱i̱ roꞌ, ꞌyaj nij soꞌ se lu̱j rihaan tuviꞌ nij soꞌ si̱j ꞌyaj se lu̱j rihaan nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Me maꞌa̱n yuvii̱ ra̱cuíj soj saꞌanj, ne̱ se̱ guun rá soj naca̱j uún soj se‑saꞌa̱nj soj maꞌ. Sese ra̱cuíj soj saꞌanj man ina̱nj síí na̱ruꞌvee rihaan soj, ga̱a ne̱ me cheꞌé na̱ruꞌvee Diose̱ rihaan soj, rá soj ga̱. ꞌO̱ se nda̱a maꞌa̱n nij síí chiꞌi̱i̱ roꞌ, racuíj nij soꞌ saꞌanj man nij tuviꞌ soꞌ si̱j na̱ruꞌvee rihaan soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","”Dan me se ga̱a̱ ꞌe̱e̱ rá soj man nij síí ta̱j riꞌyunj niꞌya̱j man soj, ne̱ quiꞌya̱j soj se lu̱j rihaan nij síí nachriꞌ man soj, ne̱ ra̱cuíj soj saꞌanj man yuvii̱, ne̱ se̱ guun rá soj naca̱j uún soj se‑saꞌa̱nj soj maꞌ. Ne̱ vaa güii, ne̱ narque̱ uxrá Diose̱ se sa̱ꞌ man soj, ne̱ taꞌníí Diose̱ síí sa̱ꞌ ndoꞌo me soj ga̱a̱ ado̱nj. ꞌO̱ se Diose̱ me síí ꞌyaj se lu̱j rihaan nda̱a síí ne neꞌen me se uun se lu̱j do̱ꞌ, rihaan nda̱a síí chiꞌi̱i̱ do̱ꞌ, ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ase vaa ꞌe̱e̱ rá Rej níꞌ Diose̱ man daj a̱ nij yuvii̱ roꞌ, da̱nj ga̱a̱ ꞌe̱e̱ rá soj man daj a̱ nij yuvii̱ uún ado̱nj. ―Da̱nj cataj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ne̱ canica̱j Jesucristó cataj soꞌ a: ―Se̱ guun niha̱ꞌ rá soj cuta̱ꞌ soj cacunꞌ xráá tinúú soj, ga̱a ne̱ taj cacunꞌ cuta̱ꞌ Diose̱ xráá maꞌa̱n soj man ado̱nj. Ma̱a̱n se cara̱a̱ xꞌnaa soj rihaan tinúú soj, ne̱ cara̱a̱ xꞌnaa Diose̱ rihaan maꞌa̱n soj uún ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Go̱ꞌ soj rasu̱u̱n man tuviꞌ soj, ne̱ Diose̱ me síí narque̱ rasu̱u̱n rihaan soj uún ado̱nj. Soꞌ me síí sa̱ꞌ ndoꞌo rá, ne̱ adi̱ꞌ se ꞌyaj síí sa̱ꞌ rá tuꞌvéj ꞌnúú ne̱ araa navii soꞌ rihaan tane̱j roꞌ, da̱nj quiꞌya̱j gue̱e̱ Diose̱ ga̱ soj, ne̱ doj a̱ narque̱ Diose̱ rasu̱u̱n sa̱ꞌ man soj ado̱nj. Ase vaa ꞌyaj gue̱e̱ soj ga̱ tuviꞌ soj roꞌ, da̱nj quiꞌya̱j gue̱e̱ Diose̱ ga̱ soj uún ado̱nj. ―Da̱nj cataj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ga̱a ne̱ nanó Jesucristó se‑cuento̱ ro̱j síí tuchri̱i rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a: ―Ne̱ caꞌve̱e ti̱haa̱n ꞌo̱ síí tuchri̱i chrej rihaan tuviꞌ tuchri̱i soꞌ, rá soj naꞌ. Taj maꞌ. Sese da̱nj quiꞌya̱j soꞌ, ga̱a ne̱ quini̱j ro̱j soꞌ rá yuꞌuj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Da̱nj na̱nj uún, ne̱ ꞌo̱ xnii tucuꞌyón se̱ guun nucua̱j soꞌ queneꞌe̱n soꞌ doj rihaan se‑maestro̱ soꞌ maꞌ. Ne̱ caꞌve̱e se uxrá tu̱cuꞌyón soꞌ, tza̱j ne̱ veé ase vaa neꞌen se‑maestro̱ soꞌ roꞌ, veé da̱nj queneꞌe̱n maꞌa̱n soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Me cheꞌé guun chre̱e rá so̱ꞌ niꞌya̱j so̱ꞌ niꞌya nu̱u̱ rihaan tinúú so̱ꞌ ga̱. Ne̱ ne niꞌya̱j so̱ꞌ chruun ma̱nj nu̱u̱ rihaan ma̱ꞌán so̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Asa̱ꞌ caꞌve̱e cata̱j so̱ꞌ rihaan tinúú so̱ꞌ: “Rque̱ so̱ꞌ rihaan so̱ꞌ quiri̱i̱ ꞌu̱nj niꞌya á”. Se̱ guun a̱ doj cata̱j so̱ꞌ da̱nj ti̱háꞌ so̱ꞌ man tinúú so̱ꞌ maꞌ. Asino quiri̱i̱ so̱ꞌ chruun ma̱nj nu̱u̱ rihaan so̱ꞌ, ga̱a ne̱ a̱j ruviꞌ sa̱ꞌ rihaan so̱ꞌ, ga̱a ne̱ caꞌve̱e quiri̱i̱ so̱ꞌ niꞌya nu̱u̱ rihaan tinúú so̱ꞌ ado̱nj. Dan me se ase vaa aráán niꞌya rihaan yuvii̱ roꞌ, da̱nj vaa aráán rihaan yuvii̱ ꞌyaj cacunꞌ ata̱ yuvii̱ ne̱ naꞌvee xca̱j sa̱ꞌ nij yuvii̱ cuentá man ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ga̱a ne̱ canica̱j Jesucristó, cataj soꞌ: ―Chruun sa̱ꞌ roꞌ, se̱ guun cuma̱n chruj nij raa̱ maꞌ. Ne̱ chruun nij roꞌ, se̱ guun cuma̱n chruj sa̱ꞌ raa̱ maꞌ. Ase vaa chruun yoꞌ roꞌ, da̱nj vaa nimán yuvii̱, ne̱ ase vaa chruj yoꞌ roꞌ, da̱nj vaa se vaa ꞌyaj nij yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ma̱a̱n chruj ma̱n raa̱ chruun roꞌ, ꞌyaj neꞌen níꞌ da̱j chru̱un me yoꞌ ado̱nj. Taj rutzi̱ꞌ mán raa̱ chruun tanj yangíj maꞌ. Ne̱ taj rcoo mán raa̱ chruun tanj xcua̱a maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Dan me se síí sa̱ꞌ roꞌ, ma̱n ndoꞌo se sa̱ꞌ nimán soꞌ, ne̱ aꞌmii soꞌ ina̱nj nana̱ sa̱ꞌ ado̱nj. Síí chiꞌi̱i̱ roꞌ, ma̱n ndoꞌo se quij nimán soꞌ, ne̱ aꞌmii soꞌ ina̱nj nana̱ chiꞌi̱i̱ ado̱nj. ꞌO̱ se ase vaa se ma̱n nimán yuvii̱ roꞌ, da̱nj vaa nana̱ aꞌmii yuvii̱ na̱nj á ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Canica̱j Jesucristó, cataj soꞌ nana̱ nihánj a: ―Me cheꞌé taj soj se vaa síí ꞌni̱j raꞌa man soj mej, tza̱j ne̱ ne uno soj rihanj ga̱. Ne chiha̱nꞌ ꞌyaj soj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Cuano̱ nihánj me cata̱j xnaꞌanj ꞌu̱nj rihaan soj da̱j si̱j me síí ꞌnaꞌ nanó xre̱j nana̱ aꞌmij, ne̱ ꞌyaj soꞌ nda̱a vaa taj se‑na̱na̱j a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ase vaa ꞌo̱ síí cuneꞌ veꞌ tucuá rihaan ꞌo̱ yuvej vaa soꞌ a. Cunu̱u̱ ndoꞌo váán soꞌ rej cuchru̱j soꞌ tacóó veꞌ, ne̱ raan ndoꞌo yáán veꞌ, ꞌyaj soꞌ a. Caꞌve̱e se maa̱n na̱na̱ yuva̱a̱ cu̱riha̱nj go̱ꞌ xráá veꞌ, ne̱ caꞌve̱e se cavi̱i̱ chráá, ne̱ caꞌna̱ꞌ na xe̱e̱ go̱ꞌ na xe̱e̱ tacóó veꞌ, tza̱j ne̱ se̱ naxruꞌ veꞌ, quiꞌya̱j na xe̱e̱ maꞌ. Da̱nj vaa síí uno se‑na̱na̱j a. ");
INSERT INTO trcNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tza̱j ne̱ ino̱ vaa síí nanó xre̱j nana̱ aꞌmij tza̱j ne̱ ne ꞌyaj nda̱a vaa taj se‑na̱na̱j maꞌ. Ase vaa ꞌo̱ síí ꞌyaj veꞌ nij vaa soꞌ a. Ne váán cunu̱u̱ soꞌ rej cuchru̱j soꞌ tacóó veꞌ rihaan yoꞌóó maꞌ. Cheꞌé dan yáán cuanꞌ u̱u̱n tucuá soꞌ a. Sese cu̱riha̱nj maa̱n na̱na̱ yuva̱a̱, ne̱ go̱ꞌ yoꞌ xráá veꞌ, ne̱ sese cavi̱i̱ chráá, ne̱ caꞌna̱ꞌ na xe̱e̱ go̱ꞌ na xe̱e̱ tacóó veꞌ, ga̱a ne̱ cane̱e̱ gue̱e̱ veꞌ na̱nj á. Nu̱ꞌ cane̱e̱ veꞌ yoꞌ, ne̱ daj chiha̱a̱ míj se̱ cunuu sa̱ꞌ yoꞌ a̱ maꞌ. Da̱nj vaa síí ne uno se‑na̱na̱j ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Quisíj caꞌmii Jesucristó nu̱ꞌ nana̱ yoꞌ cuno nij yuvii̱, ga̱a ne̱ caꞌanj soꞌ chumanꞌ Capernaum a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Dan me se yáán ꞌo̱ tanuu capitán chumanꞌ yoꞌ, ne̱ síí rii taꞌngaꞌ rihaan ꞌo̱ cientó tanuu me soꞌ a. Ne̱ vaa ꞌo̱ se‑mo̱zó soꞌ síí ꞌe̱e̱ uxrá rá soꞌ man, ne̱ ranꞌ uxrá mozó yoꞌ, ne̱ da̱j doj cavi̱ꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Dan me se cuno tanuu capitán se vaa caꞌnaꞌ Jesucristó chumanꞌ yoꞌ, ne̱ caꞌnéé soꞌ do̱j síí uun chij rihaan nij yuvii̱ israelitá cuchi̱ꞌ nij soꞌ rihaan Jesucristó, ne̱ cachi̱nj niꞌya̱j nij soꞌ rihaan Jesucristó se vaa caꞌna̱ꞌ soꞌ tinahu̱un soꞌ se‑mo̱zó tanuu capitán yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Dan me se cuchiꞌ nij síí uun chij yoꞌ rihaan Jesucristó, ga̱a ne̱ cachíín niꞌya̱j uxrá nij soꞌ rihaan Jesucristó, cataj nij soꞌ: ―Síí sa̱ꞌ me tanuu capitán yoꞌ, ne̱ cheꞌé dan vaa cheꞌé ra̱cuíj so̱ꞌ man soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ꞌE̱e̱ rá soꞌ man níꞌ si̱j israelitá, ne̱ maꞌa̱n soꞌ quiꞌyaj veꞌ nuu chre̱ꞌ núj tu̱cuꞌyón núj se‑tucua̱nj Moisés ado̱nj ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ne̱ caꞌanj Jesucristó ga̱ nij soꞌ, ne̱ da̱j doj cuchi̱ꞌ nij soꞌ veꞌ, ga̱a ne̱ caꞌnéé tanuu capitán man tuviꞌ soꞌ caꞌa̱nj cara̱nꞌ man Jesucristó, ne̱ cataj nij soꞌ: ―Se̱ caráya̱ꞌáán so̱ꞌ, man maestro. ꞌO̱ se nuveé si̱j sa̱ꞌ me soꞌ, taj soꞌ maꞌ. Ne nó xcúún soꞌ catu̱u̱ so̱ꞌ rá veꞌ tucuá soꞌ, taj soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Cheꞌé dan ne quisi̱j rá maꞌa̱n soꞌ caꞌna̱ꞌ soꞌ rihaan so̱ꞌ, taj soꞌ maꞌ. Ma̱a̱n se caꞌne̱ꞌ u̱u̱n so̱ꞌ suun se vaa nahu̱un se‑mo̱zó soꞌ, ga̱a ne̱ nahu̱un maꞌa̱n se‑mo̱zó soꞌ, taj soꞌ na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ne̱ cataj soꞌ se vaa vaa síí rii taꞌngaꞌ rihaan soꞌ, ne̱ rii taꞌngaꞌ soꞌ rihaan tanuu, ne̱ taj xnaꞌanj soꞌ rihaan tanuu se vaa caꞌa̱nj nij soꞌ, ne̱ ꞌanj nij soꞌ, ne̱ taj xnaꞌanj soꞌ rihaan nij tanuu se vaa caꞌna̱ꞌ nij soꞌ, ne̱ ꞌnaꞌ nij soꞌ rihaan soꞌ, ne̱ taj xnaꞌanj soꞌ da̱j quiꞌya̱j nij tanuu, ne̱ veé da̱nj ꞌyaj nij tanuu ado̱nj. Ne̱ neꞌen soꞌ se vaa ase vaa rii taꞌngaꞌ soꞌ rihaan nij tanuu noco̱ꞌ man soꞌ roꞌ, da̱nj rii taꞌngaꞌ gue̱e̱ so̱ꞌ rihaan chiꞌii̱ anó man yuvii̱, taj soꞌ na̱nj á ―taj nij tuviꞌ tanuu capitán rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Dan me se ga̱a cuno Jesucristó nana̱ caꞌmii tuviꞌ tanuu capitán yoꞌ, ne̱ caꞌanj rá Jesucristó, ne̱ canica̱j soꞌ cataj soꞌ rihaan nij síí noco̱ꞌ rej xco̱ soꞌ a: ―Cuano̱ nihánj me cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa taj va̱j a̱ ꞌó rej ne nari̱j man yoꞌo̱ síí israelitá síí cuchumán ndoꞌo rá nana̱ aꞌmii ꞌu̱nj nda̱a vaa amán rá tanuu capitán nihánj a̱ maꞌ ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Dan me se canica̱j uún nij tuviꞌ tanuu capitán caꞌanj nij soꞌ tucuá soꞌ, ne̱ ga̱a cuchiꞌ nij soꞌ, ne̱ a̱j nahuun se‑mo̱zó tanuu capitán yoꞌ, quiꞌyaj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Dan me se cachén do̱j güii, ga̱a ne̱ caꞌanj Jesucristó chumanꞌ cuꞌna̱j Naín ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ ga̱ ꞌo̱ xꞌneꞌ noco̱o yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Quinichrunꞌ nij soꞌ tuꞌva chumanꞌ, ga̱a ne̱ dan me se nariꞌ tuviꞌ Jesucristó ga̱ nij síí caꞌanj cachi̱nꞌ ꞌo̱ xnangá a. Ne̱ síí caviꞌ me se o̱rúnꞌ soꞌ me taꞌníí chana̱ caviꞌ nica̱, ne̱ va̱j ꞌo̱ xꞌneꞌ noco̱o yuvii̱ ma̱n chumanꞌ yoꞌ ga̱ nii soꞌ rihaan santó a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Dan me se queneꞌen Jesucristó man chana̱ yoꞌ, ga̱a ne̱ cunuu ꞌe̱e̱ rá soꞌ man noꞌ, ga̱a ne̱ cataj soꞌ: ―Se̱ taꞌveé so̱ꞌ maꞌ ―taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ga̱a ne̱ dan me se caꞌanj Jesucristó canó raꞌa soꞌ man chrúún ta̱j xnangá, ga̱a ne̱ canicunꞌ nij síí ta̱j chihá xnangá a. Ga̱a ne̱ cataj Jesucristó rihaan síí caviꞌ a: ―Cu̱nó so̱ꞌ aꞌmij, ne̱ na̱xagaa so̱ꞌ, xnii ―taj Jesucristó rihaan síí caviꞌ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ga̱a ne̱ cunuu iꞌna̱ꞌ ya̱ uún xnii, ne̱ naxaga̱a̱ soꞌ, ga̱a ne̱ guun cheꞌe̱ xnii caꞌmii soꞌ a. Ga̱a ne̱: ―Nihánj ꞌnaꞌ taꞌníí so̱ꞌ á ―taj Jesucristó rihaan nii xnii a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ga̱a ne̱ dan me se caꞌanj rá taranꞌ nij yuvii̱ se vaa quiꞌyaj Jesucristó, ga̱a ne̱ guun niha̱ꞌ rá nij soꞌ se vaa veꞌé quiꞌyaj Diose̱, ga̱a ne̱ canica̱j nij soꞌ cataj nij soꞌ se vaa caꞌnéé Diose̱ ꞌo̱ síí nataꞌ se‑na̱na̱ soꞌ rihaan nij soꞌ a. Ne̱ cataj uún nij soꞌ se vaa caꞌnaꞌ Diose̱ ra̱cuíj soꞌ man nij soꞌ si̱j noco̱ꞌ man Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ga̱a ne̱ cuchiꞌ nana̱ rihaan nij yuvii̱ ma̱n estadó Judea do̱ꞌ, rihaan nu̱ꞌ nij yuvii̱ ma̱n anica̱j estadó Judea cheꞌé se vaa quiꞌyaj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Dan me se cuno nij síí tucuꞌyón se‑na̱na̱ Juan nu̱ꞌ se vaa quiꞌyaj Jesucristó, ga̱a ne̱ cataj xnaꞌanj nij soꞌ rihaan Juan a. Ga̱a ne̱ canacúún Juan man vi̱j síí tucuꞌyón se‑na̱na̱ soꞌ caꞌna̱ꞌ ro̱j soꞌ rihaan soꞌ, ga̱a ne̱ dan me se caꞌnéé soꞌ man ro̱j soꞌ cuchi̱ꞌ ro̱j soꞌ rihaan síí ꞌni̱j raꞌa man níꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ne̱ nana̱ nihánj roꞌ, xna̱ꞌanj ro̱j soꞌ man Jesucristó, taj síí cuꞌna̱j Juan rihaan ro̱j soꞌ a: “So̱ꞌ me síí caꞌna̱ꞌ ti̱nanii man yuvii̱ rihaan sayuun naꞌ. Ase na̱ꞌvi̱j níꞌ caꞌna̱ꞌ yoꞌó soꞌ xa̱ꞌ”. Dan me nana̱ me rá síí cuꞌna̱j Juan xna̱ꞌanj ro̱j soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Dan me se cuchiꞌ ro̱j soꞌ rihaan Jesucristó, ne̱ cataj ro̱j soꞌ: ―Vi̱j ranꞌ rój me síí caꞌnéé Juan síí utaꞌ ne man yuvii̱ caꞌna̱ꞌ rihaan so̱ꞌ a. Me rá Juan queneꞌe̱n soꞌ sese ma̱ꞌán so̱ꞌ me síí caꞌna̱ꞌ ti̱nanii man yuvii̱ rihaan sayuun niꞌ, ase na̱ꞌvi̱j níꞌ caꞌna̱ꞌ yoꞌó soꞌ a ―taj ro̱j soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ga̱a ne̱ veé ma̱a̱n orá caꞌnaꞌ ro̱j síí caꞌnéé Juan man roꞌ, nahuun queꞌe̱e̱ ndoꞌo síí ranꞌ do̱ꞌ, curiha̱nj nana̱ chre̱e nimán queꞌe̱e̱ yuvii̱ do̱ꞌ, nachuguu̱n rihaan queꞌe̱e̱ síí tuchri̱i do̱ꞌ, quiꞌyaj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ga̱a ne̱ cataj xnaꞌanj Jesucristó rihaan ro̱j soꞌ a: ―Cavi̱i̱ ro̱j so̱j cuchi̱ꞌ uún ro̱j so̱j rihaan síí cuꞌna̱j Juan, ne̱ cata̱j xnaꞌanj ro̱j so̱j rihaan soꞌ nu̱ꞌ nana̱ cuno ro̱j so̱j do̱ꞌ, nu̱ꞌ se vaa queneꞌen ro̱j so̱j do̱ꞌ á. Dan me se nij síí tuchri̱i roꞌ, naxraꞌ rihaan, ne̱ nij síí naꞌvee cache̱e̱ roꞌ, chéé nij soꞌ, ne̱ nij síí ranꞌ luj riꞌyuj roꞌ, nahuun sa̱ꞌ, ne̱ nij síí soꞌo̱ roꞌ, nachuguu̱n xréé nij soꞌ, ne̱ nij síí caviꞌ roꞌ, cunuu iꞌna̱ꞌ uún, ne̱ nij síí nique̱ roꞌ, uno nij soꞌ nana̱ sa̱ꞌ a. Nu̱ꞌ nihánj cata̱j xnaꞌanj ro̱j so̱j rihaan síí cuꞌna̱j Juan yoꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ne̱ cata̱j uún ro̱j so̱j rihaan síí cuꞌna̱j Juan se vaa cavi̱i̱ sa̱ꞌ soꞌ quiꞌya̱j Diose̱, sese se̱ guun naꞌa̱j soꞌ ni̱ꞌyaj soꞌ manj a. Da̱nj caꞌmi̱i̱ ro̱j so̱j rihaan síí cuꞌna̱j Juan yoꞌ ei ―taj Jesucristó rihaan ro̱j síí tucuꞌyón se‑na̱na̱ Juan yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Dan me se ga̱a caꞌanj ro̱j síí caꞌanj suun cheꞌé Juan, ga̱a ne̱ guun cheꞌe̱ Jesucristó caꞌmii soꞌ rihaan cunuda̱nj nij yuvii̱ cheꞌé síí cuꞌna̱j Juan síí cutaꞌ ne man yuvii̱ a: ―Asi̱j caꞌanj soj rej tacaan queneꞌe̱n soj man síí cuꞌna̱j Juan roꞌ, ne̱ da̱j ga̱a̱ soꞌ queneꞌe̱n soj, rá soj ga̱. Ase vaa yoꞌo̱ rcoo̱ naa̱n ndoꞌo ꞌyaj nana̱ vaa soꞌ, rá soj naꞌ. Guun vi̱j nimán soꞌ cheꞌé tucuáán noco̱ꞌ soꞌ, rá soj naꞌ. Taj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ma̱a̱n se da̱j ga̱a̱ soꞌ rá soj, asi̱j caꞌanj soj queneꞌe̱n soj man soꞌ ga̱. Si̱j nu̱u̱ yatzíj laru̱u ndoꞌo me soꞌ, rá soj naꞌ. Taj maꞌ. ꞌO̱ se nij síí nu̱u̱ yatzíj sa̱ꞌ ndoꞌo do̱ꞌ, nij síí utunꞌ ndoꞌo saꞌanj do̱ꞌ, ya̱nj rá veꞌ tucuá síí nica̱j suun rey ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ma̱a̱n se da̱j ga̱a̱ síí cuꞌna̱j Juan rá soj, asi̱j caꞌanj soj queneꞌe̱n soj man soꞌ ga̱. Si̱j nataꞌ se‑na̱na̱ Diose̱ me soꞌ, rá soj naꞌ. Ya̱ uxrá ei. Ne̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa sa̱ꞌ doj vaa soꞌ rihaan cunuda̱nj nij síí nataꞌ se‑na̱na̱ Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","”ꞌO̱ se nana̱ nihánj nana̱ no̱ rihaan danj Diose̱ roꞌ, taj xnaꞌanj cheꞌé síí cuꞌna̱j Juan a: “Vaa síí caꞌanj suun cheꞌé ꞌu̱nj, ne̱ caꞌne̱j ꞌu̱nj man soꞌ quita̱j ya̱a̱n soꞌ rihaan so̱ꞌ, ne̱ nuchra̱nꞌ nimán yuvii̱ veꞌé caꞌmi̱i̱ nij yuvii̱ ga̱ so̱ꞌ, quiꞌya̱j soꞌ a”. Da̱nj taj danj Diose̱ cheꞌé síí cuꞌna̱j Juan se vaa nuchra̱nꞌ nimán yuvii̱ veꞌé caꞌmi̱i̱ nij yuvii̱ ga̱ síí caꞌna̱ꞌ ti̱nanii man nij yuvii̱ rihaan sayuun, quiꞌya̱j soꞌ a. Ne̱ da̱nj quiꞌyaj soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","”Cuano̱ nihánj me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa si̱j sa̱ꞌ doj rihaan cunuda̱nj nij yuvii̱ ma̱n rihaan chumii̱ me síí cuꞌna̱j Juan a. A̱ ꞌó yuvii̱ ne vaa sa̱ꞌ doj rihaan soꞌ maꞌ. Tza̱j ne̱ cuano̱ roꞌ, uun chij Diose̱ nimán yuvii̱ ma̱n rihaan chumii̱ nihánj, ne̱ na̱j guun yuvii̱ gu̱un chij Diose̱ nimán roꞌ, me síí sa̱ꞌ doj rihaan síí cuꞌna̱j Juan a. ―Da̱nj cataj Jesucristó rihaan nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Dan me se nu̱ꞌ nij yuvii̱ mán ne̱ nda̱a nij síí aꞌnéj puextó roꞌ, ga̱a cuno nij soꞌ se‑na̱na̱ Jesucristó, ne̱ cataj nij soꞌ se vaa sa̱ꞌ uxrá quiꞌyaj Diose̱ a. ꞌO̱ se si̱j cataꞌ ne quiꞌyaj Juan me nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ne̱ nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés do̱ꞌ, nij síí fariseo do̱ꞌ, ne caꞌve̱j rá nij soꞌ cuno̱ nij soꞌ da̱j me rá Diose̱ quiꞌya̱j Diose̱ cheꞌé nij soꞌ maꞌ. ꞌO̱ se nuveé si̱j cataꞌ ne quiꞌyaj Juan me nij síí naꞌvej rá maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ga̱a ne̱ cataj uún Jesucristó rihaan nij yuvii̱ a: ―Ne̱ da̱j vaa nij soj si̱j ma̱n rihaan chumii̱ nihánj cuano̱, rá soj ga̱. Dan me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj ei. ");
INSERT INTO trcNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ase vaa xnii caꞌanj rihaan yuꞌvee ne̱ tico ga̱ tuviꞌ roꞌ, vaa soj si̱j ma̱n rihaan chumii̱ nihánj ado̱nj. Dan me se yáán nij xnii yoꞌ rihaan yoꞌóó, ne̱ aguáj nij xnii rihaan tuviꞌ xnii, taj nij xnii: “Nica̱j núj rihuu núj, goꞌ núj chraꞌ choco̱ꞌ, tza̱j ne̱ me cheꞌé ne raꞌa̱nj soj ga̱. Ne̱ goꞌ núj chraꞌ xnangá, tza̱j ne̱ me cheꞌé ne taꞌve̱e soj ga̱. Me cheꞌé ne tico soj ga̱ núj ga̱”, taj nij xnii rihaan tuviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ꞌO̱ se caꞌnaꞌ Juan síí cutaꞌ ne man yuvii̱, ga̱a ne̱ ne cha̱ soꞌ chraa do̱ꞌ, ne coꞌo̱ soꞌ na vinó ga̱ tuviꞌ soꞌ do̱ꞌ, ga̱a ne̱ cheꞌé dan taj soj se vaa nu̱u̱ nana̱ chre̱e nimán soꞌ, taj soj a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ne̱ caꞌnáꞌ ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱, ga̱a ne̱ niha̱ꞌ rá ꞌu̱nj chá ꞌu̱nj do̱ꞌ, coꞌo ꞌu̱nj do̱ꞌ, ga̱a ne̱ cheꞌé dan taj uún soj se vaa síí cachén chá do̱ꞌ, síí cachén coꞌo do̱ꞌ, mé ꞌu̱nj, taj uún soj a. Ne̱ taj uún soj se vaa tuvíꞌ ꞌu̱nj me síí tihaꞌ yuꞌunj man yuvii̱ cheꞌé puextó do̱ꞌ, yoꞌó nij síí tumé cacunꞌ do̱ꞌ, taj soj a. Da̱nj tuꞌva soj, tza̱j ne̱ ne neꞌen uxrá soj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sese xca̱j soj cuentá da̱j vaa ꞌyaj rój, ne̱ gu̱un ya̱ rá soj se vaa si̱j cu̱u raa̱ me rój ga̱ síí cuꞌna̱j Juan yoꞌ ado̱nj ―taj Jesucristó rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Dan me se canacúún ꞌo̱ síí fariseo man Jesucristó cha̱ Jesucristó chraa tucuá soꞌ, ga̱a ne̱ caꞌanj ca̱yáán Jesucristó tucuá soꞌ cha̱ soꞌ chraa a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ne̱ dan me se yáán ꞌo̱ chana̱ niha̱ꞌ rá ga̱ chii chumanꞌ yoꞌ, ga̱a ne̱ cuno noꞌ nana̱ se vaa cuchiꞌ Jesucristó chá soꞌ chraa tucuá síí fariseo yoꞌ, ga̱a ne̱ cheꞌé dan nica̱j noꞌ ꞌo̱ agaꞌ catzi̱i̱ veꞌé ndoꞌo vaa nu̱u̱ casté gunꞌ da̱j, caꞌanj noꞌ tucuá síí fariseo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ga̱a ne̱ caꞌanj cane̱ ru̱j noꞌ nichru̱nꞌ tacóó Jesucristó, ne̱ taꞌvee uxrá noꞌ, ne̱ naꞌnuꞌ noꞌ na rihaan noꞌ tacóó Jesucristó a. Ga̱a ne̱ ma̱a̱n yuvé raa̱ noꞌ naꞌve noꞌ tacóó Jesucristó a. Cachrón tuꞌva̱ noꞌ tacóó Jesucristó, ga̱a ne̱ caxríj noꞌ casté gunꞌ da̱j tacóó soꞌ uún a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Dan me se ga̱a queneꞌen síí tucua̱ se vaa quiꞌyaj chana̱ man Jesucristó, ga̱a ne̱ guun rá soꞌ nana̱ nihánj niꞌya̱j soꞌ man Jesucristó a: “Sese ya̱ si̱j nataꞌ se‑na̱na̱ Diose̱ me síí nihánj, ne̱ a̱j neꞌen soꞌ da̱j cha̱na̱ me chana̱ nihánj, se vaa chana̱ ata̱ cacunꞌ me noꞌ, ne̱ ne caꞌve̱j rá soꞌ quiꞌya̱j noꞌ da̱nj ga̱ soꞌ tza̱j man ado̱nj”, guun rá síí tucua̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Vaa nana̱ me raj cata̱j ꞌu̱nj rihaan so̱ꞌ, Simón ―taj Jesucristó rihaan soꞌ a. ―Caꞌmi̱i̱ so̱ꞌ, maestro ―taj síí tucua̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ga̱a ne̱ nanó Jesucristó se‑cuento̱ vi̱j síí ꞌyaj xcúún a: ―Vi̱j síí ꞌyaj xcúún saꞌanj rihaan ꞌo̱ ruꞌvee me ro̱j soꞌ a. ꞌO̱ soꞌ roꞌ, ꞌyaj xcúún ꞌu̱nꞌ cientó saꞌanj denario, ne̱ yoꞌó soꞌ roꞌ, ꞌyaj xcúún vi̱j chiha̱a̱ chi̱ꞌ saꞌanj denario a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tza̱j ne̱ taj saꞌanj rihaan ro̱j soꞌ na̱ruꞌvee ro̱j soꞌ rihaan ruꞌvee, ga̱a ne̱ cheꞌé dan cunuu ꞌe̱e̱ rá ruꞌvee man ro̱j soꞌ, ne̱ quinavij u̱u̱n xcúún xráá ro̱j soꞌ, quiꞌyaj ruꞌvee a. Me tuviꞌ ro̱j soꞌ cara̱nꞌ doj rá ni̱ꞌyaj man ruꞌvee, rá so̱ꞌ ga̱ ―taj Jesucristó, xnáꞌanj soꞌ man síí cuꞌna̱j Simón yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","―Cara̱nꞌ doj rá síí navij noco̱o doj xcúún xráá ni̱ꞌyaj soꞌ man ruꞌvee, cheꞌé rej noco̱o doj se lu̱j quiꞌyaj ruꞌvee cheꞌé soꞌ, raj a ―taj síí cuꞌna̱j Simón yoꞌ a. ―Veé da̱nj vaa ya̱ ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ga̱a ne̱ canica̱j Jesucristó niꞌya̱j Jesucristó man chana̱, ga̱a ne̱ cataj soꞌ rihaan síí cuꞌna̱j Simón yoꞌ a: ―Xca̱j so̱ꞌ cuentá se vaa quiꞌyaj chana̱ nihánj ei. Caꞌnáꞌ ꞌu̱nj tucuá so̱ꞌ, tza̱j ne̱ taj na rqué so̱ꞌ naꞌnu̱j tacój maꞌ. Tza̱j ne̱ chana̱ nihánj me níí naꞌnuꞌ na rihaan noꞌ tacój, ne̱ ma̱a̱n yuvé raa̱ noꞌ naꞌve noꞌ tacój na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Caꞌnaj tucuá so̱ꞌ, tza̱j ne̱ ne cachro̱n tu̱ꞌvá so̱ꞌ raꞌaj maꞌ. Tza̱j ne̱ chana̱ nihánj roꞌ, nu̱ꞌ catúj ꞌu̱nj rá veꞌ, ne̱ nu̱ꞌ cachrón tuꞌva̱ noꞌ tacój, ne̱ veé ꞌo̱ achrón tuꞌva̱ noꞌ tacój na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Taj va̱j casté caxríj so̱ꞌ raj maꞌ. Tza̱j ne̱ chana̱ nihánj me níí caxríj casté gunꞌ da̱j tacój ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Cu̱nó so̱ꞌ caꞌmi̱j á. Ase vaa síí navij u̱u̱n xcúún ꞌu̱nꞌ cientó saꞌanj denario xráá roꞌ, da̱nj vaa noꞌ a. ꞌO̱ se nda̱ꞌ se níí tumé uxrá cacunꞌ me noꞌ, tza̱j ne̱ cheꞌé se caráyaꞌa̱nj ndoꞌo noꞌ niꞌya̱j noꞌ manj roꞌ, cheꞌé dan neꞌen níꞌ se vaa xꞌnéj nu̱ꞌ cacunꞌ xráá noꞌ na̱nj ado̱nj. Ne̱ xa̱ꞌ síí xꞌnéj do̱j cacunꞌ xráá, tza̱j ne̱ do̱j aráyaꞌa̱nj soꞌ niꞌya̱j soꞌ manj na̱nj ado̱nj ―taj Jesucristó rihaan síí cuꞌna̱j Simón yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ga̱a ne̱ cataj Jesucristó rihaan chana̱ yoꞌ a: ―Navij cacunꞌ tumé so̱ꞌ ei ―taj Jesucristó rihaan noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ga̱a ne̱ guun cheꞌe̱ nij síí chá chraa tucuá Simón caꞌmii nij soꞌ ga̱ tuviꞌ nij soꞌ, cataj nij soꞌ a: ―Da̱j si̱j me síí nihánj, ne̱ síj rá soꞌ cata̱j soꞌ se vaa navij cacunꞌ xráá yuvii̱, rá soj ga̱ ―taj nij soꞌ, xnáꞌanj nij soꞌ man tuviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tza̱j ne̱ canica̱j uún Jesucristó, cataj soꞌ rihaan chana̱ a: ―Quinani̱i̱ so̱ꞌ rihaan sayuun, cheꞌé se amán rá so̱ꞌ niꞌya̱j so̱ꞌ manj ado̱nj. Veꞌé caꞌa̱nj so̱ꞌ, ne̱ dínj ga̱a̱ nimán so̱ꞌ á ―taj Jesucristó rihaan chana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Dan me se cachén do̱j güii, ga̱a ne̱ caꞌanj Jesucristó queꞌe̱e̱ chumanꞌ, caꞌmii natáj soꞌ rihaan yuvii̱ cheꞌé güii gu̱un chij Diose̱ rihaan chumii̱ nihánj, ne̱ caꞌanj chuvi̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ ga̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ne̱ caꞌanj chana̱ nahuun sa̱ꞌ quiꞌyaj Jesucristó ga̱ nij soꞌ a. Dan me se taꞌa̱j noꞌ me níí nahuun quiꞌyaj Jesucristó, ne̱ yoꞌó taꞌa̱j noꞌ me níí curiha̱nj nana̱ chre̱e nimán quiꞌyaj Jesucristó a. Chana̱ cuꞌna̱j Mariá Magdalena me ꞌo̱ noꞌ, ne̱ noꞌ me níí curiha̱nj chi̱j nana̱ chre̱e nimán quiꞌyaj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ne̱ yoꞌó noꞌ roꞌ, me níí cuꞌna̱j Juana, ne̱ nica̱ noꞌ roꞌ, me síí cuꞌna̱j Chuza síí nicu̱nꞌ rihaan síí nica̱j suun rey cuꞌna̱j Herodes a. Ne̱ yoꞌó chana̱ caꞌanj ga̱ Jesucristó roꞌ, me níí cuꞌna̱j Susana a. Ne̱ vaa queꞌe̱e̱ doj nij chana̱ caꞌanj ga̱ nij soꞌ a. Nu̱ꞌ nij chana̱ nihánj roꞌ, me níí racuíj man nij tuvi̱ꞌ Jesucristó se vaa rqué nij noꞌ siꞌyaj nij noꞌ rasu̱u̱n cachiin man nij tuvi̱ꞌ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Dan me se cavii queꞌe̱e̱ ndoꞌo nij yuvii̱ daj a̱ chumanꞌ, caꞌanj ni̱ꞌyaj nij soꞌ man Jesucristó, ne̱ dan me se quisíj cunuu chre̱ꞌ nij yuvii̱, ga̱a ne̱ guun cheꞌe̱ Jesucristó nanó soꞌ se‑cuento̱ ꞌnúú trigó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Cataj Jesucristó nana̱ nihánj a: ―Dan me se curiha̱nj ꞌo̱ síí me rá cuchru̱j naa̱ ꞌnúú trigó, ne̱ tixꞌnuu̱ soꞌ ꞌnúú trigó rihaan yoꞌóó, ne̱ cayuu do̱j ꞌnúú trigó yoꞌ rá chrej chéé yuvii̱, ne̱ curuꞌmaan cheꞌé yuvii̱ man yoꞌ, ne̱ caꞌnaꞌ xtâj, chá xtâj man ꞌnúú trigó na̱j rá chrej yoꞌ, ne̱ dan me se navij nu̱ꞌ ꞌnúú trigó yoꞌ, quiꞌyaj nij xtâj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ne̱ yoꞌó taꞌa̱j ꞌnúú trigó yoꞌ roꞌ, cayuu rihaan yuvej rej ta̱j catu̱nꞌ yoꞌóó a. Xraꞌ ꞌnúú, tza̱j ne̱ cuchrii naa̱ leꞌe̱j cheꞌé se taj noco̱o ꞌyoo táá xráá yuvej yoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ne̱ yoꞌó taꞌa̱j ꞌnúú trigó yoꞌ roꞌ, cayuu scaꞌnúj coj tanj, ne̱ dan me se yo̱o doj cachij coj tanj yoꞌ rihaan naa̱ leꞌe̱j, ne̱ quinavij nu̱ꞌ naa̱ leꞌe̱j, quiꞌyaj coj tanj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ne̱ yoꞌó taꞌa̱j ꞌnúú trigó yoꞌ roꞌ, cayuu rihaan yoꞌóó sa̱ꞌ, ne̱ naa̱ yoꞌ roꞌ, cachij sa̱ꞌ, ne̱ cientó ya̱ ꞌnúú cavii, quiꞌyaj ꞌo̱ ꞌo̱ ꞌnúú leꞌe̱j nii quinij rihaan yoꞌóó sa̱ꞌ yoꞌ na̱nj ado̱nj. ―Da̱nj cataj Jesucristó rihaan nij soꞌ a. Ga̱a ne̱ guun cheꞌe̱ soꞌ caꞌmii nucua̱j soꞌ, cataj soꞌ: ―Sese ta̱j yuꞌuj xréé soj, ne̱ cuno̱ soj nana̱ nihánj ei ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ga̱a ne̱ xnáꞌanj nij síí tucuꞌyón se‑na̱na̱ Jesucristó man soꞌ me cheꞌé nanó soꞌ cuentó cheꞌé ꞌnúú trigó yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Xa̱ꞌ soj, tza̱j ne̱ tihaa̱n Diose̱ nana̱ rihaan soj da̱j quiꞌya̱j Diose̱ ga̱a gu̱un chij Diose̱ rihaan chumii̱ nihánj ado̱nj. Tza̱j ne̱ rihaan yoꞌó nij yuvii̱ me se ina̱nj cuentó cheꞌé nij rasu̱u̱n nanó ꞌu̱nj rihaan nij soꞌ, ga̱a ne̱ ni̱ꞌyaj nij soꞌ do̱ꞌ, nano̱ xre̱j nij soꞌ do̱ꞌ, tza̱j ne̱ se̱ queneꞌen nij soꞌ do̱ꞌ, se̱ xcaj nij soꞌ cuentá do̱ꞌ, a̱ man ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Canica̱j Jesucristó, cataj soꞌ: ―Nihánj me cata̱j xnaꞌanj ꞌu̱nj cheꞌé se‑cuento̱ ꞌnúú trigó, ne̱ ase vaa ꞌnúú trigó yoꞌ roꞌ, da̱nj vaa se‑na̱na̱ Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ne̱ ase vaa ꞌnúú cayuu rá chrej roꞌ, da̱nj vaa taꞌa̱j nij síí uno se‑na̱na̱ Diose̱, ne̱ dan me se uno nij soꞌ do̱j tzinꞌ, tza̱j ne̱ ꞌnaꞌ síí chre̱e, ne̱ aꞌnéj síí chre̱e se‑na̱na̱ Diose̱ nimán nij soꞌ cheꞌé se naꞌvej rá síí chre̱e cuchuma̱n rá nij soꞌ ne̱ quinani̱i̱ nij soꞌ rihaan sayuun quiꞌya̱j Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ne̱ ase vaa taꞌa̱j ꞌnúú trigó cayuu rihaan yuvej roꞌ, da̱nj vaa yoꞌó taꞌa̱j nij síí uno se‑na̱na̱ Diose̱, ne̱ uun niha̱ꞌ rá nij soꞌ, ne̱ do̱j orá nii ga̱a̱ chumán xa̱ꞌ rá nij soꞌ, tza̱j ne̱ nu̱ꞌ ꞌnaꞌ sayuun rihaan nij soꞌ, ne̱ nu̱ꞌ tanáj nij soꞌ se‑na̱na̱ Diose̱, ne̱ ne nocoꞌ raan nij soꞌ se‑na̱na̱ Diose̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ne̱ ase vaa taꞌa̱j ꞌnúú cayuu scaꞌnúj tanj roꞌ, da̱nj vaa yoꞌó taꞌa̱j nij síí uno se‑na̱na̱ Diose̱ uún, ne̱ dan me se achén güii, ga̱a ne̱ anica̱j nij soꞌ niga̱nj nanó rá nij soꞌ cheꞌé rasu̱u̱n achiin man nij soꞌ do̱ꞌ, cheꞌé saꞌanj do̱ꞌ, cheꞌé se niha̱ꞌ ndoꞌo vaa rasu̱u̱n ma̱n rihaan chumii̱ nihánj rá nij soꞌ do̱ꞌ, ne̱ cheꞌé dan me tanáj xco̱ nij soꞌ se‑na̱na̱ Diose̱, ne̱ ne ꞌyaj nij soꞌ se sa̱ꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ne̱ yoꞌó taꞌa̱j nij síí uno se‑na̱na̱ Diose̱ me se ase vaa ꞌnúú cayuu rihaan yoꞌóó sa̱ꞌ ne̱ sa̱ꞌ uxrá cachij yoꞌ roꞌ, da̱nj vaa síí sa̱ꞌ uno se‑na̱na̱ Diose̱, ne̱ sa̱ꞌ uxrá vaa nij soꞌ, ne̱ veꞌé nanó xre̱j nij soꞌ se‑na̱na̱ Diose̱, ne̱ noco̱ꞌ raan nij soꞌ se‑na̱na̱ Diose̱, ne̱ ina̱nj se sa̱ꞌ ꞌyaj nij soꞌ, ne̱ ne aꞌneꞌ rá nij soꞌ ga̱ se‑na̱na̱ Diose̱ maꞌ ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Dan me se guun cheꞌe̱ Jesucristó cataj soꞌ: ―Nuviꞌ a̱ ꞌó síí achrón yaꞌan raa̱ agaꞌ yaꞌan, ne̱ axríj yuve̱ soꞌ agaꞌ rque xruj do̱ꞌ, rque yuvéé do̱ꞌ maꞌ. Tana̱nj tocoꞌ nii agaꞌ yaꞌan rej xta̱ꞌ, ga̱a ne̱ chugu̱u̱n yoꞌ rihaan cunuda̱nj nij síí atúj rá veꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Dan me se a̱ ꞌó rasu̱u̱n caxríj yuve̱ yuvii̱ se̱ quiꞌnij yuve̱ maꞌ. Ya̱ nu̱riha̱nj yoꞌ, vaa güii, ne̱ cunuda̱nj yuvii̱ queneꞌe̱n, vaa güii ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Cheꞌé dan nuchru̱j ra̱a̱ soj nana̱ caꞌmij nihánj ei. ꞌO̱ se síí nariꞌ nana̱ roꞌ, doj a̱ nari̱ꞌ soꞌ, quiꞌya̱j Diose̱, ne̱ síí naꞌvej rá nari̱ꞌ sa̱ꞌ nana̱ roꞌ, tana̱nj doj a̱ caꞌne̱e̱ Diose̱ nana̱ nariꞌ soꞌ man soꞌ, ne̱ quina̱j u̱u̱n soꞌ na̱nj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Dan me se cuchiꞌ nii Jesucristó cuchiꞌ nij tinúú Jesucristó cuchiꞌ nda̱a rej va̱j Jesucristó, tza̱j ne̱ ne caꞌve̱e quinichru̱nꞌ nij soꞌ rihaan Jesucristó, cheꞌé se ma̱n ndoꞌo yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ne̱ cataj ꞌo̱ soꞌ rihaan Jesucristó a: ―Nicu̱nꞌ nií so̱ꞌ nicu̱nꞌ tinúú so̱ꞌ nicu̱nꞌ xeꞌ, ne̱ me rá nij soꞌ queneꞌe̱n nij soꞌ mán so̱ꞌ, Jesús ―taj soꞌ, cataj xnaꞌanj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tza̱j ne̱ cataj Jesucristó rihaan nij yuvii̱ a: ―Ase vaa nií ꞌu̱nj do̱ꞌ, ase vaa tinúú ꞌu̱nj do̱ꞌ, vaa nij síí nihánj ado̱nj. ꞌO̱ se nanó xre̱j nij soꞌ se‑na̱na̱ Diose̱, ne̱ ꞌyaj nij soꞌ nda̱a vaa taj nana̱ yoꞌ ado̱nj ―taj Jesucristó rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Dan me se ꞌo̱ güii catúj Jesucristó rque ꞌo̱ rihoo ga̱ cunuda̱nj nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ cataj Jesucristó rihaan nij soꞌ se vaa caꞌa̱nj cunuda̱nj nij soꞌ nda̱a yoꞌó níchrej tuꞌva na lacuaná a. Ga̱a ne̱ guun cheꞌe̱ rihoo chéé rihoo rihaan na, quiꞌyaj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Do̱j caꞌanj rihoo, ne̱ cotoj Jesucristó a. Cachén ꞌo̱ orá nii, ga̱a ne̱ guun cheꞌe̱ nana̱ yuva̱a̱ cavii uxrá yoꞌ goꞌ ndoꞌo yoꞌ rihaan na, ne̱ dan me se catúj ndoꞌo na rque rihoo, ne̱ da̱j doj caꞌa̱nj ni̱j rihoo rque na a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ga̱a ne̱ guun cheꞌe̱ nij síí tucuꞌyón se‑na̱na̱ Jesucristó narii nij soꞌ nej rihaan soꞌ, ne̱: ―Da̱j doj cavi̱ꞌ níꞌ, na̱nj maestro ―taj nij soꞌ rihaan Jesucristó a. Ga̱a ne̱ canicunꞌ caya̱ soꞌ, ne̱ caxríj yuva̱a̱ soꞌ man nana̱ do̱ꞌ, man na do̱ꞌ a. Ga̱a ne̱ canicunꞌ nana̱ canicunꞌ na do̱ꞌ, ne̱ canicunꞌ dínj rihaan na lacuaná yoꞌ, quiꞌyaj Jesucristó na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ga̱a ne̱ xnáꞌanj Jesucristó man nij síí tucuꞌyón se‑na̱na̱ soꞌ, cataj soꞌ: ―Me cheꞌé ne amán rá soj niꞌya̱j soj man Diose̱ ga̱ ―taj soꞌ rihaan nij soꞌ a. Tza̱j ne̱ caꞌanj rá nij soꞌ, ne̱ cuchuꞌviꞌ nij soꞌ, ne̱ cataj nij soꞌ rihaan tuviꞌ nij soꞌ: ―Da̱j si̱j me síí nihánj ga̱. Nda̱a rihaan nana̱ do̱ꞌ, nda̱a rihaan na do̱ꞌ, aꞌneꞌ soꞌ suun, ne̱ uno ro̱j yoꞌ aꞌmii soꞌ aso̱n ―taj nij soꞌ rihaan tuviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Dan me se guun ga̱nꞌ rihoo nu̱u̱ Jesucristó ga̱ estadó Galilea, ne̱ cachén yoꞌ caꞌanj yoꞌ nda̱a níchrej tuꞌva na lacuaná yoꞌ, nda̱a rej ne̱ nij síí ma̱n chumanꞌ Gadara a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Cuchiꞌ nij soꞌ yoꞌóó yoꞌ, ne̱ nanij Jesucristó rihoo, ga̱a ne̱ nariꞌ tuviꞌ soꞌ ga̱ ꞌo̱ síí chiha̱nj chumanꞌ yoꞌ, ne̱ soꞌ me síí nu̱u̱ nana̱ chre̱e nimán, ne̱ taj yatzíj nu̱u̱ soꞌ do̱ꞌ, naꞌvej rá soꞌ ca̱yáán soꞌ veꞌ tucuá soꞌ do̱ꞌ, ina̱nj rihaan santó ne soꞌ do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Dan me se caꞌneꞌ Jesucristó suun rihaan nana̱ chre̱e se vaa cu̱riha̱nj nana̱ chre̱e nimán soꞌ a. ꞌO̱ se quisíj queꞌe̱e̱ canó nana̱ chre̱e man soꞌ a. Dan me se nda̱a agaꞌ ne̱ꞌ numíj nii raꞌa soꞌ do̱ꞌ, tacóó soꞌ do̱ꞌ, tza̱j ne̱ xuun soꞌ, ne̱ xꞌneꞌ yoꞌ, quiꞌyaj soꞌ, ga̱a ne̱ nica̱j nana̱ chre̱e man soꞌ caꞌanj nij soꞌ quij na̱nj ado̱nj. Dan me se ga̱a queneꞌen soꞌ man Jesucristó, ne̱ caguáj soꞌ, ne̱ canicunꞌ ru̱j soꞌ rihaan Jesucristó, ne̱ nucua̱j caꞌmii soꞌ, cataj soꞌ: ―Veé neꞌén ꞌu̱nj se vaa taꞌni̱j Diose̱ síí sa̱ꞌ ndoꞌo mé so̱ꞌ, Jesús. Me cheꞌé ꞌnáꞌ so̱ꞌ rej né ꞌu̱nj ga̱. Cata̱j xnaꞌanj sa̱ꞌ ꞌu̱nj rihaan so̱ꞌ se vaa se̱ quiꞌyáá so̱ꞌ sayuun manj maꞌ ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ga̱a ne̱ xnáꞌanj Jesucristó man nana̱ chre̱e yoꞌ, cataj soꞌ: ―Da̱j cuꞌna̱j so̱ꞌ ga̱ ―taj Jesucristó, xnáꞌanj soꞌ man nana̱ chre̱e a. Ne̱ dan me se cataj nana̱ chre̱e yoꞌ: ―Xꞌneꞌ noco̱o me núj á ―taj nij soꞌ cheꞌé rej a̱j catúj queꞌe̱e̱ ndoꞌo nij soꞌ nimán snóꞌo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ga̱a ne̱ cachíín niꞌya̱j nij nana̱ chre̱e rihaan Jesucristó se̱ gaa na̱nj caꞌne̱j soꞌ man nij soꞌ rej cunu̱u̱ rej nu̱u̱ yaꞌan, ne̱: ―Achíín niꞌya̱j ndoꞌo núj rihaan so̱ꞌ se̱ caꞌnéé so̱ꞌ man núj rej nu̱u̱ yaꞌan, man Jesús ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ne̱ dan me se chéé ꞌo̱ xꞌneꞌ noco̱o xcáá rej tacaan rej yoꞌ, chá nij xoꞌ coj, ne̱ dan me se cachíín niꞌya̱j nij nana̱ chre̱e rihaan Jesucristó se vaa caꞌve̱j rá Jesucristó catu̱u̱ nij soꞌ nimán xcáá, ne̱ ca̱yáán nij soꞌ nimán xcáá a. Ne̱ caꞌvej rá Jesucristó catu̱u̱ nij soꞌ nimán xcáá a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Cheꞌé dan me curiha̱nj nij nana̱ chre̱e nimán snóꞌo, ne̱ catúj nij soꞌ nimán xcáá, ne̱ dan me se ruva̱a̱ uxrá tacaan nicu̱nꞌ tuꞌva na lacuaná rej va̱j nij xcáá yoꞌ, ne̱ ga̱a catúj nij nana̱ chre̱e nimán xcáá yoꞌ, ga̱a ne̱ cunánj ndoꞌo nij xoꞌ caꞌanj nij xoꞌ, ne̱ veé da̱nj vaj nij xoꞌ, ne̱ quinij nij xoꞌ rque na, ne̱ canó xráá nij xoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Dan me se queneꞌen nij síí tumé xcáá se vaa guun, ga̱a ne̱ cunánj nij soꞌ caꞌanj cata̱j xnaꞌanj nij soꞌ rihaan nij yuvii̱ ma̱n chumanꞌ do̱ꞌ, rihaan nij yuvii̱ ma̱n tacaan do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ga̱a ne̱ dan me se caꞌnaꞌ ni̱ꞌyaj nij yuvii̱ se vaa guun, ga̱a ne̱ caꞌnaꞌ nij soꞌ rej nicu̱nꞌ Jesucristó, ga̱a ne̱ queneꞌen nij soꞌ man síí curiha̱nj nana̱ chre̱e nimán a. A̱j nanuû soꞌ saga̱nꞌ soꞌ, ne̱ dínj ne soꞌ rihaan Jesucristó a. Ne̱ a̱j tiꞌinj se snúú soꞌ, ne̱ nuu sa̱ꞌ soꞌ a. Ga̱a ne̱ cuchuꞌviꞌ ndoꞌo nij yuvii̱ se vaa quiꞌyaj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ga̱a ne̱ cataj xnaꞌanj nij síí queneꞌen rihaan nij yuvii̱ da̱j quiꞌyaj Jesucristó ne̱ nahuun sa̱ꞌ síí nu̱u̱ nana̱ chre̱e nimán a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Cheꞌé dan cuchuꞌviꞌ ndoꞌo nij síí ma̱n chumanꞌ Gadara, ne̱ cheꞌé dan cachíín niꞌya̱j taranꞌ nij soꞌ rihaan Jesucristó se vaa caꞌa̱nj yaníj Jesucristó rihaan nij soꞌ a. Ga̱a ne̱ dan me se catúj Jesucristó rque rihoo, ne̱ canica̱j soꞌ caꞌanj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ga̱a ne̱ dan me se cachíín niꞌya̱j síí nahuun sa̱ꞌ rihaan Jesucristó se vaa caꞌve̱j rá Jesucristó caꞌa̱nj soꞌ ga̱ Jesucristó, tza̱j ne̱ ne caꞌve̱j rá Jesucristó maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Ca̱nica̱j so̱ꞌ nánꞌ so̱ꞌ tucuá so̱ꞌ, ne̱ cata̱j xnaꞌanj so̱ꞌ rihaan tuvíꞌ so̱ꞌ cheꞌé se sa̱ꞌ ndoꞌo quiꞌyaj Diose̱ cheꞌé so̱ꞌ á ―taj Jesucristó rihaan soꞌ a. Ga̱a ne̱ canica̱j síí nahuun sa̱ꞌ yoꞌ quinanꞌ soꞌ, ne̱ caꞌmii natáj soꞌ rihaan taranꞌ nij yuvii̱ ya̱nj chumanꞌ yoꞌ cheꞌé se sa̱ꞌ quiꞌyaj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nanica̱j Jesucristó, namán uún soꞌ tuꞌva na lacuaná a. Ga̱a ne̱ ma̱n ndoꞌo yuvii̱ naꞌvi̱j man soꞌ, ne̱ guun niha̱ꞌ rá nij yuvii̱ se vaa namán uún soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ga̱a ne̱ dan me se caꞌnaꞌ ꞌo̱ soꞌ rihaan Jesucristó, ne̱ Jairo cuꞌna̱j soꞌ, ne̱ soꞌ me síí ꞌni̱j raꞌa ꞌo̱ veꞌ tucuꞌyón nij yuvii̱ israelitá se‑tucua̱nj Moisés, ne̱ dan me se canicunꞌ ru̱j soꞌ rihaan Jesucristó, ne̱ cachíín niꞌya̱j soꞌ rihaan Jesucristó se vaa caꞌa̱nj Jesucristó tucuá soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ne̱ o̱rúnꞌ ra̱a̱ taꞌnij cha̱na̱ soꞌ chala̱ cunii va̱j chuvi̱j yoꞌ, tza̱j ne̱ ranꞌ ndoꞌo yoꞌ, ne̱ da̱j doj cavi̱ꞌ yoꞌ, ne̱ cheꞌé dan guun rá soꞌ caꞌa̱nj Jesucristó tucuá soꞌ a. Veé dan me caꞌanj Jesucristó ga̱ soꞌ, ne̱ caꞌanj ndoꞌo yuvii̱ ga̱ soꞌ, ne̱ nda̱a raan maꞌa̱n chrej va̱j yuvii̱ ga̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Dan me se scaꞌnúj nij soꞌ vaj ꞌo̱ chana̱ ranꞌ ndoꞌo, ne̱ quisíj chuvi̱j ya̱ yoꞌ xraꞌ ton man noꞌ, ne̱ cutunꞌ noꞌ cunuda̱nj saꞌanj vaa rihaan noꞌ, tza̱j ne̱ taj va̱j a̱ ꞌó síí guun nucua̱j quiꞌyaj nahuun sa̱ꞌ noꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Dan me se quinichrunꞌ noꞌ rej xco̱ Jesucristó, ne̱ canó raꞌa noꞌ do̱j tuꞌva saga̱nꞌ soꞌ a. Dan me se nu̱ꞌ canó raꞌa noꞌ tuꞌva saga̱nꞌ soꞌ, ne̱ nu̱ꞌ canicunꞌ se xraꞌ ton man noꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ga̱a ne̱ xnáꞌanj Jesucristó se vaa me síí canó raꞌa saga̱nꞌ soꞌ, tza̱j ne̱ a̱ ꞌó nij yuvii̱ ne cano̱ raꞌa saga̱nꞌ soꞌ maꞌ, taj nu̱ꞌ nij yuvii̱ a. Ga̱a ne̱ cataj Pedró rihaan Jesucristó: ―Ma̱a̱n cheꞌé se raan va̱j nij yuvii̱, ne̱ canó rmaꞌa̱n raꞌa ꞌo̱ soꞌ saga̱nꞌ so̱ꞌ, maestro ―taj Pedró rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tza̱j ne̱ cataj Jesucristó rihaan soꞌ a: ―Vaa ꞌo̱ yuvii̱ canó raꞌa saga̱nꞌ ꞌu̱nj ado̱nj. Neꞌenj se vaa nahuun yuvii̱ quiꞌyáj ado̱nj ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ga̱a ne̱ xcaj chana̱ cuentá se vaa queneꞌen Jesucristó se vaa quiꞌyaj noꞌ, ga̱a ne̱ riꞌíj man noꞌ, ne̱ caꞌnaꞌ noꞌ, ne̱ canicunꞌ ru̱j noꞌ rihaan soꞌ, ga̱a ne̱ cataj xnaꞌanj noꞌ rihaan nu̱ꞌ nij yuvii̱ se vaa ma̱a̱n se canó raꞌa noꞌ saga̱nꞌ Jesucristó, ne̱ nu̱ꞌ ma̱a̱n orá dan nahuun sa̱ꞌ noꞌ ne̱ canicunꞌ se xraꞌ ton man noꞌ, taj noꞌ rihaan cunuda̱nj nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ga̱a ne̱ cataj Jesucristó rihaan noꞌ, ne̱: ―Nahuún so̱ꞌ cheꞌé se amán rá so̱ꞌ niꞌya̱j so̱ꞌ manj, nocoj. Veꞌé caꞌa̱nj so̱ꞌ, ne̱ dínj ga̱a̱ nimán so̱ꞌ caꞌa̱nj so̱ꞌ á ―taj Jesucristó rihaan noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ataa navi̱j caꞌmi̱i̱ Jesucristó, ne̱ caꞌnaꞌ ꞌo̱ síí cavii tucuá Jairo, ne̱ cataj soꞌ rihaan Jairo a: ―A̱j caviꞌ taꞌníí so̱ꞌ, ne̱ taj cheꞌé cara̱a̱ chrúú so̱ꞌ rihaan maestró a̱ maꞌ ―taj síí ꞌnaꞌ cataj xnaꞌanj rihaan Jairo a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Dan me se cuno Jesucristó nana̱ caꞌmii síí caꞌnaꞌ, ga̱a ne̱ cataj soꞌ rihaan síí cuꞌna̱j Jairo a: ―Se̱ cuchuꞌvíꞌ so̱ꞌ maꞌ. Ma̱a̱n se cuchuma̱n ya̱ rá so̱ꞌ ni̱ꞌyaj so̱ꞌ manj, ne̱ quinahu̱un taꞌníí so̱ꞌ na̱nj ado̱nj ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Dan me se cuchiꞌ Jesucristó tucuá Jairo, ne̱ ne caꞌve̱j Jesucristó catu̱u̱ nij yuvii̱ rá veꞌ ga̱ soꞌ, ne̱ ma̱a̱n Pedró do̱ꞌ, Juan do̱ꞌ, Jacobo do̱ꞌ, ro̱j ni̱ca̱ Jairo do̱ꞌ, caꞌvej soꞌ catu̱u̱ rá veꞌ ga̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Dan me se taꞌvee ndoꞌo nij síí cunuu chre̱ꞌ rá veꞌ cheꞌé chala̱ cunii caviꞌ, ne̱ nanó uxrá rá nij soꞌ, ne̱ goꞌ nij soꞌ cuxruꞌ rucua̱a̱ nij soꞌ a. Tza̱j ne̱ cataj Jesucristó rihaan nij soꞌ: ―Se̱ taꞌvee soj maꞌ. ꞌO̱ se ne cavi̱ꞌ noꞌ maꞌ. Ma̱a̱n se otoj u̱u̱n noꞌ na̱nj á ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ga̱a ne̱ caꞌngaꞌ naco̱o̱ nij soꞌ niꞌya̱j nij soꞌ man Jesucristó cheꞌé se a̱j queneꞌen nij soꞌ se vaa a̱j caviꞌ ya̱ noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tza̱j ne̱ catúj Jesucristó rá cuartó na̱j noꞌ, ne̱ quitaꞌaa soꞌ raꞌa noꞌ, ne̱ nacúún soꞌ man noꞌ, cataj soꞌ: ―Na̱xagaa so̱ꞌ, chala̱ cunii ―taj soꞌ rihaan noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ne̱ cunuu iꞌna̱ꞌ uún noꞌ, ga̱a ne̱ nu̱ꞌ naxaga̱a̱ noꞌ, ne̱ nu̱ꞌ caꞌneꞌ Jesucristó suun rihaan ro̱j ni̱ca̱ Jairo se vaa go̱ꞌ ro̱j soꞌ do̱j se chá cha̱ chala̱ cunii, taj Jesucristó rihaan ro̱j ni̱ca̱ Jairo a. ");
INSERT INTO trcNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Dan me se caꞌanj rá ro̱j soꞌ se vaa quiꞌyaj Jesucristó, ga̱a ne̱ cataj Jesucristó rihaan ro̱j soꞌ a: ―A̱ ꞌó yuvii̱ se̱ cataj xnaꞌanj ro̱j so̱j rihaan da̱j quiꞌyáj cheꞌé chala̱ cunii maꞌ ―taj Jesucristó rihaan ro̱j ni̱ca̱ ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Dan me se canacúún Jesucristó man chuvi̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ cunuu chre̱ꞌ nij soꞌ, ne̱ goꞌ soꞌ se nucua̱j man nij soꞌ, ga̱a ne̱ caꞌve̱e quiꞌya̱j canaán nij soꞌ rihaan me maꞌa̱n nana̱ chre̱e do̱ꞌ, caꞌve̱e caꞌne̱e̱ nij soꞌ chiꞌii̱ xráá síí ranꞌ do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ga̱a ne̱ caꞌnéé soꞌ man nij soꞌ caꞌa̱nj caꞌmi̱i̱ natáj nij soꞌ cheꞌé güii gu̱un chij Diose̱ rihaan chumii̱ nihánj, ne caꞌne̱e̱ nij soꞌ chiꞌii̱ xráá nij síí ranꞌ do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ne̱ cataj soꞌ rihaan nij soꞌ a: ―A̱ ꞌó rasu̱u̱n se̱ nica̱j soj caꞌa̱nj soj maꞌ. Chruun garroté do̱ꞌ, nanj do̱ꞌ, se chá do̱ꞌ, saꞌanj do̱ꞌ, se̱ nica̱j soj maꞌ. O̱rúnꞌ nique̱e̱ yatzíj nu̱u̱ soj caꞌa̱nj ga̱ soj á. ");
INSERT INTO trcNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ne̱ me maꞌa̱n veꞌ cuchiꞌ soj ne̱ caꞌvej ꞌo̱ soꞌ cane̱ soj roꞌ, ne̱ veé veꞌ yoꞌ yoꞌo̱ cane̱ soj ne̱ veé veꞌ yoꞌ cavi̱i̱ soj caꞌa̱nj soj caꞌmi̱i̱ natáj soj se‑na̱na̱ Diose̱ á. ");
INSERT INTO trcNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ne̱ me maꞌa̱n ꞌo̱ chumanꞌ se̱ caꞌvej rá nij síí chiha̱nj cuno̱ nij soꞌ se‑na̱na̱ soj, ta̱náj soj chumanꞌ yoꞌ, ne̱ cavi̱i̱ soj tuꞌva chumanꞌ yoꞌ, ne̱ nacuna̱nꞌ soj tacóó soj cayu̱u yoꞌóó tachru̱u̱ ma̱n chumanꞌ yoꞌ tacóó soj á. Nda̱a dan, ga̱a ne̱ xca̱j nij síí chiha̱nj yoꞌ cuentá se vaa tumé nij soꞌ cacunꞌ se vaa ne caꞌve̱j rá nij soꞌ cuno̱ nij soꞌ se‑na̱na̱ soj man ado̱nj ―taj Jesucristó rihaan chuvi̱j nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ga̱a ne̱ dan me se caꞌanj nij soꞌ nij chumanꞌ, ne̱ caꞌmii natáj nij soꞌ se‑na̱na̱ Diose̱ nana̱ sa̱ꞌ, ne̱ me rej maꞌa̱n va̱j nij soꞌ caꞌnéj nij soꞌ chiꞌii̱ xráá nij síí ranꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Dan me se cuno síí nica̱j suun cuꞌna̱j Herodes nu̱ꞌ se vaa quiꞌyaj Jesucristó, ga̱a ne̱ guun rá Herodes queneꞌe̱n soꞌ me síí me Jesucristó a. ꞌO̱ se taꞌa̱j yuvii̱ cataj se vaa cunuu iꞌna̱ꞌ uún Juan síí cutaꞌ ne man yuvii̱, ");
INSERT INTO trcNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ne̱ yoꞌó taꞌa̱j yuvii̱ cataj se vaa curuviꞌ uún síí cuꞌna̱j Elías síí cayáán ga̱a naá, ne̱ yoꞌó taꞌa̱j uún yuvii̱ cataj se vaa cunuu iꞌna̱ꞌ uún ꞌo̱ síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tza̱j ne̱ maꞌa̱n síí cuꞌna̱j Herodes cataj, ne̱: ―A̱j caviꞌ Juan, ne̱ xꞌneꞌ chihá Juan, quiꞌyáj a. Tza̱j ne̱ ne neꞌenj me yuvii̱ me síí nihánj, ne̱ tuꞌva nii da̱nj cheꞌé soꞌ rihanj maꞌ ―taj Herodes a. Ga̱a ne̱ guun uxrá rá Herodes queneꞌe̱n soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Dan me se namán chuvi̱j nij síí tucuꞌyón se‑na̱na̱ Jesucristó rihaan Jesucristó, ne̱ nataꞌ nij soꞌ rihaan Jesucristó cheꞌé nu̱ꞌ nij suun sa̱ꞌ noco̱o quiꞌyaj suun nij soꞌ rej caꞌanj nij soꞌ a. Ga̱a ne̱ nica̱j Jesucristó man taranꞌ nij soꞌ, caꞌanj nij soꞌ nda̱a tuꞌva chumanꞌ cuꞌna̱j Betsaida rej yaníj a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tza̱j ne̱ queneꞌen ꞌo̱ xꞌneꞌ noco̱o yuvii̱ rej caꞌanj Jesucristó, ga̱a ne̱ canocoꞌ nij soꞌ man Jesucristó, caꞌanj nij soꞌ a. Ga̱a ne̱ veꞌé caꞌmii Jesucristó ga̱ xꞌneꞌ noco̱o yuvii̱ canocoꞌ man soꞌ, ne̱ caꞌmii natáj soꞌ cheꞌé güii gu̱un chij Diose̱ rihaan chumii̱ nihánj, ne̱ quinahuun nij síí ranꞌ, quiꞌyaj soꞌ do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Dan me se nichru̱nꞌ cata̱ꞌ güii, ne̱ dan me se quinichrunꞌ chuvi̱j nij síí tucuꞌyón se‑na̱na̱ Jesucristó rihaan soꞌ, ne̱ cataj nij soꞌ: ―Qui̱ꞌyáá so̱ꞌ se ndoꞌo, ne̱ naꞌne̱j so̱ꞌ chrej man nij yuvii̱, caꞌa̱nj nij soꞌ rej chumanꞌ noco̱o chumanꞌ raꞌa̱ do̱ꞌ, ga̱a ne̱ ma̱n veꞌ cara̱nꞌ nij soꞌ do̱ꞌ, ma̱n se chá quiri̱ꞌ nij soꞌ cha̱ nij soꞌ do̱ꞌ a. Tza̱j ne̱ rej ma̱n níꞌ nihánj me se rcoꞌ quij me nihánj, ne̱ taj rej cara̱nꞌ nij soꞌ, taj se chá cha̱ nij soꞌ do̱ꞌ, nihánj maꞌ ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Tza̱j ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Go̱ꞌ maꞌa̱n soj se chá cha̱ nij yuvii̱ ei ―taj Jesucristó rihaan nij soꞌ a. ―Tza̱j ne̱ taj se chá rihaan núj maꞌ. Ma̱a̱n se o̱rúnꞌ ꞌu̱nꞌ rachrúún ne̱ vi̱j gue̱e̱ xcuaj ne̱, vaa rihaan núj na̱nj á. Tza̱j ne̱ caꞌve̱e caꞌa̱nj núj, ne̱ quira̱a̱n núj se chá cha̱ cunuda̱nj nij yuvii̱ nihánj na̱nj á ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Dan me se ꞌu̱nꞌ míj snóꞌo mán rej yoꞌ ta̱ꞌ asuun, ne̱ ino̱ me chana̱ ga̱ xnii ado̱nj. Tza̱j ne̱ cataj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a: ―Ca̱yáán nij yuvii̱ rihaan yoꞌóó, quiꞌya̱j soj, ne̱ dan me se cunu̱u chre̱ꞌ ꞌo̱ vi̱j chiha̱a̱ chi̱ꞌ vi̱j chiha̱a̱ chi̱ꞌ yuvii̱ cane̱ ꞌo̱ ꞌo̱ rej, quiꞌya̱j soj á ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ne̱ veé da̱nj quiꞌyaj nij soꞌ, ne̱ caꞌanj cane̱ cunuda̱nj nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ga̱a ne̱ dan me se quitaꞌaa Jesucristó ꞌu̱nꞌ nij rachrúún ga̱ ro̱j xcuaj yoꞌ, ga̱a ne̱ niꞌya̱j soꞌ rej xta̱ꞌ, ne̱ nagoꞌ soꞌ graciá rihaan Diose̱ cheꞌé se chá yoꞌ, ga̱a ne̱ cuxraꞌ taꞌa̱j soꞌ rachrúún do̱ꞌ, nee̱ xcuaj do̱ꞌ, ne̱ caxríj soꞌ ston nij síí tucuꞌyón se‑na̱na̱ soꞌ, cheꞌé rej caxri̱i̱ nij soꞌ ston nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ga̱a ne̱ chá taranꞌ nij yuvii̱, ne̱ caraa rque nij soꞌ ne̱ nda̱a quináj ndoꞌo se chá a. Ga̱a ne̱ naquiꞌyaj chre̱ꞌ nij soꞌ nu̱ꞌ se quináj tuꞌva yuvii̱, ne̱ caraa nij soꞌ yoꞌó cunu̱ꞌ chuvi̱j scaa a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Dan me se ꞌo̱ güii caꞌanj Jesucristó ꞌo̱ rej yaníj cachíín niꞌya̱j soꞌ rihaan Diose̱, ne̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ roꞌ, mán rej yoꞌ ga̱ soꞌ, ne̱ xnáꞌanj soꞌ man nij soꞌ, cataj soꞌ, ne̱: ―Me si̱j mé ꞌu̱nj, taj nij yuvii̱ ga̱ ―taj Jesucristó, xnáꞌanj soꞌ man nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","―Vaa síí taj se vaa síí cuꞌna̱j Juan síí cutaꞌ ne man yuvii̱ mé so̱ꞌ ei. Ne̱ vaa síí taj uún se vaa síí cuꞌna̱j Elías síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá me uún so̱ꞌ chugua̱nj. Ne̱ vaa síí taj uún se vaa yoꞌó síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá me uún so̱ꞌ xa̱ꞌ. Da̱nj taj ꞌo̱ ꞌo̱ taꞌa̱j nij yuvii̱ na̱nj á ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ: ―Ne̱ maꞌa̱n soj, ga̱a ne̱ me si̱j mé ꞌu̱nj, rá soj uún ga̱ ―taj Jesucristó, xnáꞌanj soꞌ man nij síí tucuꞌyón se‑na̱na̱ soꞌ a. Ga̱a ne̱ cataj Pedró: ―Síí caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun mé so̱ꞌ ei ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ga̱a ne̱ cataj xnaꞌanj Jesucristó rihaan nij soꞌ a: ―Se̱ cataj nij soj nana̱ vaa da̱nj rihaan a̱ ꞌó nij yuvii̱ maꞌ ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ga̱a ne̱ cataj uún Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a: ―Xa̱ꞌ ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱, tza̱j ne̱ no̱ xcúún ꞌu̱nj quira̱nꞌ ndoꞌo ꞌu̱nj sayuun quiꞌya̱j nij síí uun chij do̱ꞌ, quiꞌya̱j nij xrej ata̱ suun noco̱o doj do̱ꞌ, quiꞌya̱j nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ, ne̱ nachri̱ꞌ ndoꞌo nij soꞌ ni̱ꞌyaj nij soꞌ mán ꞌu̱nj, ne̱ ticavi̱ꞌ nii mán ꞌu̱nj, ne̱ cache̱n vaꞌnu̱j güii, ga̱a ne̱ cunu̱u iꞌna̱ꞌ uún ꞌu̱nj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ga̱a ne̱ dan me se cataj soꞌ rihaan cunuda̱nj nij yuvii̱ a: ―Sese me rá yoꞌo̱ soꞌ canoco̱ꞌ soꞌ manj, ne̱ se̱ guun rá soꞌ quiꞌya̱j soꞌ se vaa me rá maꞌa̱n soꞌ quiꞌya̱j soꞌ maꞌ. Ne̱ caꞌve̱e se quira̱nꞌ uxrá soꞌ sayuun do̱ꞌ, caꞌve̱e se nda̱a cachro̱n nii man soꞌ rihaan rcutze̱ do̱ꞌ, tza̱j ne̱ daj a̱ ꞌo̱ ꞌo̱ güii me se yoꞌo̱ quiꞌya̱j suun soꞌ cheꞌej, ne̱ yoꞌo̱ canoco̱ꞌ raan soꞌ manj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tza̱j ne̱ sese vaa ꞌo̱ síí me rá ti̱nanii man maꞌa̱n rihaan sayuun, ne̱ vaa güii yoꞌo̱ cavi̱ꞌ nimán soꞌ ado̱nj. Tza̱j ne̱ sese cavi̱ꞌ yoꞌo̱ soꞌ cheꞌé se me soꞌ síí noco̱ꞌ manj, ne̱ vaa güii cunu̱u iꞌna̱ꞌ uún soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ne̱ a̱ me se quiri̱ꞌ ꞌo̱ soꞌ sese quiꞌya̱j canaán soꞌ nu̱ꞌ rasu̱u̱n ma̱n rihaan chumii̱ nihánj, ne̱ caꞌa̱nj niꞌya̱ nimán maꞌa̱n soꞌ, rá soj ga̱. Daj chiha̱a̱ míj se̱ caꞌvee cavi̱i̱ sa̱ꞌ soꞌ, quiꞌya̱j rasu̱u̱n ma̱n rihaan chumii̱ nihánj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Dan me se xa̱ꞌ síí uun naꞌa̱j niꞌya̱j manj ne̱ uun naꞌa̱j niꞌya̱j se‑na̱na̱j, tza̱j ne̱ vaa güii gu̱un naꞌa̱j ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ ni̱ꞌyaj ꞌu̱nj man soꞌ asa̱ꞌ caꞌnaꞌ uún ꞌu̱nj rihaan chumii̱ nihánj ado̱nj. Ne̱ güii yoꞌ me se veꞌé ndoꞌo gu̱un chij ꞌu̱nj, quiꞌya̱j Réj Diose̱, ne̱ cavi̱i̱ sa̱ꞌ ꞌu̱nj, quiꞌya̱j se‑mo̱zó Diose̱ nij síí gue̱e̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nihánj me se cata̱j yá ꞌu̱nj rihaan soj se vaa xa̱ꞌ taꞌa̱j soj si̱j nicu̱nꞌ nihánj cuano̱ me se ga̱a ataa a̱ cavi̱ꞌ taꞌa̱j soj, ne̱ ya̱ queneꞌe̱n taꞌa̱j soj asa̱ꞌ guun cheꞌe̱ Diose̱ guun chij Diose̱ rihaan chumii̱ nihánj na̱nj ado̱nj ―taj Jesucristó rihaan cunuda̱nj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Quisíj caꞌmii Jesucristó nana̱ vaa da̱nj, ga̱a ne̱ cachén ꞌo̱ tu̱nj güii ta̱ꞌ asuun, ga̱a ne̱ nica̱j Jesucristó man Pedró ga̱ Juan ga̱ Jacobo, ne̱ cavii soꞌ raa̱ ꞌo̱ quij xca̱a̱n, caꞌanj cachi̱nj niꞌya̱j soꞌ rihaan Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ga̱a cachíín niꞌya̱j soꞌ rihaan Diose̱, ne̱ yoꞌo̱ cunuu ino̱ rihaan soꞌ, ne̱ yu̱u̱n cheꞌe̱ cunuu catzi̱i̱ saga̱nꞌ soꞌ, ne̱ nda̱a raa̱n lá maꞌa̱n saga̱nꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ga̱a ne̱ dan me se naquiꞌyaa vi̱j snóꞌo rihaan nij soꞌ, ne̱ nanó ro̱j soꞌ cuentó ga̱ Jesucristó, ne̱ Moisés do̱ꞌ, Elías síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá do̱ꞌ, me ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Dan me se veꞌé ndoꞌo curuviꞌ ro̱j soꞌ, ne̱ caꞌmii ro̱j soꞌ ga̱ Jesucristó cheꞌé se vaa quira̱nꞌ Jesucristó chumanꞌ Jerusalén, ne̱ cavi̱i̱ soꞌ chumii̱ nihánj, nda̱a vaa guun rá Diose̱ quiꞌya̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Dan me se caꞌnaꞌ ndoꞌo nej rihaan nij tuvi̱ꞌ Pedró, tza̱j ne̱ ne coto̱j nij soꞌ maꞌ. Queneꞌen nij soꞌ nda̱a vaa chuguu̱n saga̱nꞌ Jesucristó do̱ꞌ, nda̱a vaa chuguu̱n saga̱nꞌ ro̱j síí nicu̱nꞌ ga̱ soꞌ do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ga̱a ne̱ dan me se guun cheꞌe̱ ro̱j síí nicu̱nꞌ ga̱ Jesucristó caꞌanj yaníj ro̱j soꞌ ga̱ Jesucristó, ga̱a ne̱ cataj Pedró rihaan Jesucristó: ―Cuna̱j uxrá vaa mán núj nihánj ga̱ so̱ꞌ, maestro. Ne̱ quiꞌya̱j núj vaꞌnu̱j veꞌ yacataj cane̱ soj na̱nj á. ꞌO̱ veꞌ ca̱né so̱ꞌ, ne̱ yoꞌó veꞌ cane̱ síí cuꞌna̱j Moisés, ne̱ yoꞌó veꞌ cane̱ síí cuꞌna̱j Elías ei ―taj Pedró rihaan Jesucristó, tza̱j ne̱ ne queneꞌe̱n uxrá soꞌ da̱j me cheꞌé caꞌmii soꞌ rihaan Jesucristó da̱nj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Quisíj caꞌmii soꞌ nana̱ vaa da̱nj, ga̱a ne̱ caꞌnaꞌ ꞌo̱ ngaa rej xta̱ꞌ, ne̱ caráán ngaa xráá nij soꞌ ne̱ naxíj nij soꞌ rque ngaa, ne̱ cuchuꞌviꞌ vaꞌnu̱j nij síí tucuꞌyón se‑na̱na̱ Jesucristó yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ga̱a ne̱ Diose̱ roꞌ, caꞌmii nana̱ cuno nij soꞌ rque ngaa yoꞌ a. Ne̱ cataj Diose̱: ―Síí nihánj me taꞌníj síí ꞌe̱e̱ raj ado̱nj. Cuno̱ soj rihaan soꞌ ei ―taj Diose̱ cuno nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Quisíj caꞌmii Diose̱, ga̱a ne̱ ta̱j o̱rúnꞌ Jesucristó nicunꞌ, queneꞌen nij soꞌ a. Tza̱j ne̱ yoꞌo̱ caráán tuꞌva nij soꞌ se vaa queneꞌen nij soꞌ, ne̱ güii guun da̱nj me se a̱ ꞌó yuvii̱ ne cata̱j xnaꞌanj nij soꞌ rihaan a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Dan me se cachén ꞌo̱ yanꞌ, ne̱ quisíj güii, ga̱a ne̱ caꞌanj Jesucristó ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ rej rque̱ a. Ga̱a ne̱ nariꞌ tuviꞌ nij soꞌ ga̱ ꞌo̱ xꞌneꞌ noco̱o yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ga̱a ne̱ dan me se nucua̱j ndoꞌo caꞌmii yoꞌo̱ síí ꞌnaꞌ scaꞌnúj nij yuvii̱ rihaan Jesucristó, ne̱ cataj soꞌ: ―Achíín ni̱ꞌyáj rihaan so̱ꞌ se vaa cunu̱u ꞌe̱e̱ rá so̱ꞌ ni̱ꞌyaj so̱ꞌ taꞌníj cheꞌé se o̱rúnꞌ ra̱a̱ soꞌ me taꞌníj, maestro ―taj soꞌ rihaan Jesucristó, ne̱― ");
INSERT INTO trcNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Dan me se naruviꞌ nana̱ chre̱e nimán taꞌníj, ne̱ taj niꞌyón snúú soꞌ, ne̱ aguáj soꞌ, ne̱ avii yatanꞌ tuꞌva soꞌ, ꞌyaj nana̱ chre̱e yoꞌ, ne̱ ꞌyaj chiꞌi̱i̱ ndoꞌo nana̱ chre̱e yoꞌ man taꞌníj, ne̱ sayu̱u̱n uxrá cu̱riha̱nj nana̱ chre̱e yoꞌ nimán taꞌníj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ne̱ dan me se cachíín ni̱ꞌyáj rihaan nij síí tucuꞌyón se‑na̱na̱ so̱ꞌ se vaa quiri̱i̱ nij soꞌ nana̱ chre̱e nimán taꞌníj, tza̱j ne̱ ne caꞌve̱e quiri̱i̱ nij soꞌ nana̱ chre̱e nimán taꞌníj maꞌ. ―Da̱nj cataj snóꞌo yoꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ga̱a ne̱ cataj Jesucristó a: ―Dan me se síí ne amán rá me soj si̱j ma̱n rihaan chumii̱ nihánj cuano̱, ne̱ chiꞌi̱i̱ vaa nimán soj, ne̱ a̱ me daj cache̱j ga̱ soj, ne̱ a̱ me daj ga̱a̱ naj nimanj ni̱ꞌyaj ꞌu̱nj man soj, ga̱a ne̱ caꞌve̱e quiꞌya̱j canaán soj ga̱. Ni̱caj so̱ꞌ man xnii caꞌna̱ꞌ so̱ꞌ rihanj cuaj á ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Dan me se ga̱a ꞌnaꞌ xnii, ne̱ nu̱ꞌ snúú xnii, ne̱ naxruꞌ xnii, quiꞌyaj nana̱ chre̱e yoꞌ, tza̱j ne̱ caꞌneꞌ Jesucristó suun rihaan nana̱ chre̱e se vaa cu̱riha̱nj soꞌ nimán xnii, ne̱ dan me se curiha̱nj nana̱ chre̱e yoꞌ nimán xnii, ne̱ nahuun sa̱ꞌ xnii, quiꞌyaj Jesucristó, ne̱ nagoꞌ Jesucristó man xnii rihaan rej xnii a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ga̱a ne̱ queneꞌen nij yuvii̱ se vaa nucua̱j ndoꞌo Diose̱ síí quiꞌyaj suun sa̱ꞌ noco̱o yoꞌ, ne̱ caráyaꞌa̱nj nu̱ꞌ nij soꞌ a. Dan me se caráyaꞌa̱nj cunuda̱nj yuvii̱ se vaa quiꞌyaj Jesucristó a. Ga̱a ne̱ cataj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a: ");
INSERT INTO trcNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―A̱ ꞌó xcoꞌ se̱ quiniꞌyón soj nana̱ nihánj nana̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ maꞌ. Dan me se ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ me se vaa güii nago̱ꞌ nii mán ꞌu̱nj rihaan yuvii̱ ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tza̱j ne̱ ne cuno̱ nij soꞌ nana̱ caꞌmii Jesucristó, ne̱ ne caꞌve̱j rá Diose̱ xca̱j nij soꞌ cuentá maꞌ. Ne̱ cuchuꞌviꞌ nij soꞌ xna̱ꞌanj nij soꞌ man Jesucristó cheꞌé nana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Dan me se guun cheꞌe̱ nij síí tucuꞌyón se‑na̱na̱ Jesucristó caꞌmii cunuꞌ nij soꞌ me nij soꞌ gu̱un chij doj a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tza̱j ne̱ xcaj Jesucristó cuentá da̱j vaa nimán nij soꞌ, ne̱ cheꞌé dan quitaꞌaa soꞌ raꞌa ꞌo̱ neꞌej, ne̱ nica̱j soꞌ cachrón soꞌ xꞌnúú soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Me maꞌa̱n ꞌo̱ síí aráj cochro̱j ne̱ aꞌmii sa̱ꞌ soꞌ ga̱ ꞌo̱ neꞌej nihánj cheꞌej, ne̱ adi̱ꞌ ma̱ꞌanj me aráj cochro̱j ne̱ aꞌmii sa̱ꞌ soꞌ ga̱ vaa na̱nj ado̱nj. Dan me se síí aꞌmii sa̱ꞌ ga̱ ꞌu̱nj me se nuveé o̱rúnꞌ ꞌu̱nj me aꞌmii sa̱ꞌ soꞌ ga̱ maꞌ. Ma̱a̱n Diose̱ ya̱ síí caꞌnéé mán ꞌu̱nj me aráj cochro̱j ya̱ soꞌ ne̱ aꞌmii sa̱ꞌ ya̱ soꞌ ga̱ vaa na̱nj ado̱nj. ꞌO̱ se síí nica̱ꞌ doj rihaan taranꞌ soj roꞌ, me síí sa̱ꞌ doj rihaan taranꞌ soj a ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ga̱a ne̱ cataj síí cuꞌna̱j Juan rihaan Jesucristó a: ―Queneꞌen núj man ꞌo̱ síí ataꞌ tuꞌva se‑chu̱vií so̱ꞌ, ne̱ uriha̱nj nana̱ chre̱e nimán yuvii̱, ꞌyaj soꞌ, na̱nj maestro. Tza̱j ne̱ caráán núj chrej caꞌmi̱i̱ soꞌ ne̱ se̱ quiꞌyaj soꞌ da̱nj, cheꞌé se nuveé si̱j chéé ga̱ níꞌ me soꞌ, taj núj, na̱nj maestro ―taj Juan rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tza̱j ne̱ cataj Jesucristó rihaan soꞌ a: ―Caꞌne̱ꞌ sa̱ꞌ gue̱e̱ rá soj quiꞌya̱j maꞌa̱n soꞌ da̱nj ei. ꞌO̱ se xa̱ꞌ síí ne unuꞌ ga̱ soj, tza̱j ne̱ tuviꞌ soj me soꞌ ado̱nj ―taj Jesucristó rihaan Juan do̱ꞌ, rihaan yoꞌó nij síí tucuꞌyón se‑na̱na̱ soꞌ do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Dan me se ga̱a nichru̱nꞌ güii quina̱nꞌ Jesucristó xta̱ꞌ, ga̱a ne̱ yoꞌo̱ caꞌnéé nucua̱j nimán soꞌ caꞌa̱nj soꞌ chumanꞌ Jerusalén a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Dan me se caꞌneꞌ soꞌ suun rihaan do̱j síí chéé ga̱ soꞌ quita̱j ya̱a̱n nij soꞌ nano̱ꞌ nij soꞌ veꞌ cara̱nꞌ nij tuvi̱ꞌ nij soꞌ, ga̱a ne̱ caꞌanj nij síí caꞌanj suun, ne̱ cuchiꞌ nij soꞌ ꞌo̱ chumanꞌ ya̱nj nij síí samaritano a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tza̱j ne̱ quiraꞌaan nij síí samaritano veꞌ tucuá nij soꞌ rihaan Jesucristó, cheꞌé se guun rá soꞌ caꞌa̱nj soꞌ chumanꞌ Jerusalén a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Dan me se ga̱a queneꞌen ro̱j síí tucuꞌyón se‑na̱na̱ Jesucristó ro̱j síí cuꞌna̱j Jacobo ga̱ Juan, se vaa quiraꞌaan nij síí samaritano veꞌ, ga̱a ne̱ xnáꞌanj ro̱j soꞌ man Jesucristó, cataj ro̱j soꞌ: ―Me rá so̱ꞌ cachi̱nj niꞌya̱j núj rihaan Diose̱, ne̱ caꞌne̱j Diose̱ yaꞌan, ne̱ caca̱a̱ nij síí samaritano naꞌ ―taj ro̱j soꞌ, xnáꞌanj ro̱j soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tza̱j ne̱ niꞌya̱j Jesucristó man ro̱j soꞌ, ne̱ caxríj yuva̱a̱ Jesucristó man ro̱j soꞌ, ne̱ cataj Jesucristó a: ―Ne neꞌen soj da̱j si̱j me soj ne̱ guun da̱nj rá soj a. Xa̱ꞌ ꞌu̱nj, tza̱j ne̱ ne caꞌna̱ꞌ ꞌu̱nj ti̱cavíꞌ ꞌu̱nj man yuvii̱ maꞌ. Cheꞌé yan ti̱nanii ꞌu̱nj man yuvii̱ rihaan sayuun caꞌnáꞌ ꞌu̱nj ado̱nj ―taj Jesucristó rihaan ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ga̱a ne̱ caꞌanj nij tuvi̱ꞌ Jesucristó yoꞌó chumanꞌ caranꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ga̱a va̱j nij soꞌ chrej, ga̱a ne̱ caꞌnaꞌ ꞌo̱ soꞌ, caꞌmii soꞌ ga̱ Jesucristó a: ―Ca̱nocóꞌ ꞌu̱nj mán so̱ꞌ da̱j rej maꞌa̱n vaj so̱ꞌ ei ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ga̱a ne̱ cataj ya̱ Jesucristó se vaa ranꞌ soꞌ chéé soꞌ a: ―ꞌO̱ se nij chunee roꞌ, otoj sa̱ꞌ nij xoꞌ rá yuꞌuj ta̱j rque yoꞌóó, ne̱ nij xtâj chéé xta̱ꞌ roꞌ, vaa saca̱ꞌ nij xoꞌ a. Ne̱ xa̱ꞌ ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱, tza̱j ne̱ taj a̱ doj rej qui̱náá ꞌu̱nj coto̱j ꞌu̱nj a̱ maꞌ ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ne̱ dan me se cataj Jesucristó rihaan yoꞌó soꞌ a: ―Ca̱nocóꞌ so̱ꞌ manj caꞌa̱nj níꞌ á ―taj Jesucristó rihaan soꞌ a. ―Caꞌve̱j so̱ꞌ nanj tucuaj, ne̱ nda̱a cavi̱ꞌ réj, ga̱a ne̱ cachi̱nꞌ ꞌu̱nj man réj, ga̱a ne̱ ca̱nocóꞌ ꞌu̱nj mán so̱ꞌ ei ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tza̱j ne̱ cataj Jesucristó rihaan soꞌ a: ―Caꞌne̱ꞌ rá so̱ꞌ cachi̱nꞌ maꞌa̱n nij síí caviꞌ nimán man tuviꞌ soꞌ xnangá á. Ne̱ caꞌa̱nj so̱ꞌ, caꞌmi̱i̱ natáj so̱ꞌ cheꞌé güii gu̱un chij Diose̱ rihaan chumii̱ nihánj ei ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ne̱ dan me se cataj yoꞌó soꞌ uún rihaan Jesucristó a: ―Me raj ca̱nocoj mán so̱ꞌ, Señor. Tza̱j ne̱ asino caꞌve̱j so̱ꞌ caꞌa̱nj cata̱j xnaꞌanj ꞌu̱nj rihaan nij tuvij, ga̱a ne̱ caꞌna̱j, ne̱ caꞌa̱nj níꞌ ei ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tza̱j ne̱ cataj Jesucristó rihaan soꞌ a: ―Síí oro̱ꞌ nee niꞌya̱j rej xco̱ roꞌ, daj chiha̱a̱ míj se̱ cavii nica̱ tucuáán quiꞌya̱j soꞌ maꞌ. Ne̱ síí me rá canoco̱ꞌ manj me se se̱ guun ca̱nica̱j uún soꞌ rej xco̱ soꞌ maꞌ. Ne̱ sese da̱nj quiꞌya̱j soꞌ, ne̱ daj chiha̱a̱ míj se̱ caꞌvee gu̱un chij Diose̱ nimán soꞌ maꞌ. Ne̱ ase vaa síí oro̱ꞌ nee rii tucuáán roꞌ, vaa síí me rá canoco̱ꞌ manj ado̱nj ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Cachén doj, ga̱a ne̱ narii Jesucristó man yaꞌnúj chiha̱a̱ chi̱ꞌ snóꞌo, ne̱ caꞌnéé soꞌ man vi̱j vi̱j nij soꞌ quita̱j ya̱a̱n nij soꞌ rihaan Jesucristó caꞌa̱nj nij soꞌ daj a̱ chumanꞌ cache̱n Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Ya̱ uxrá, ne̱ vaa ndoꞌo suun rihaan níꞌ, ne̱ nij síí ꞌyaj suun me se do̱j nij soꞌ na̱nj ado̱nj. Ne̱ cachi̱nj niꞌya̱j níꞌ doj nij síí quiꞌya̱j suun rihaan Diose̱ síí uun chij ꞌni̱j raꞌa suun, ga̱a ne̱ caꞌne̱j soꞌ doj yuvii̱ quiꞌya̱j suun se‑su̱u̱n soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Dan me se caꞌa̱nj caꞌmi̱i̱ natáj soj rihaan nij yuvii̱, tza̱j ne̱ xca̱j soj cuentá se vaa caꞌna̱ꞌ sayuun rihaan soj ei. ꞌO̱ se ase vaa matzinj va̱j rej ma̱n xcaꞌyanj caꞌnu̱ꞌ roꞌ, da̱nj ga̱a̱ soj chugua̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Se̱ nica̱j soj vitó nu̱u̱ saꞌanj se̱ nica̱j soj nanj se̱ nica̱j soj yoꞌó taco̱j canj se̱ nica̱j soj caꞌa̱nj soj maꞌ. ꞌO̱ rej caꞌa̱nj soj, ne̱ ꞌo̱ rej ca̱nica̱j soj, ne̱ se̱ canicunꞌ soj nano̱ soj cuentó ga̱ yuvii̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","”Asa̱ꞌ catúj soj rá ꞌo̱ veꞌ, ne̱ asino cata̱j soj rihaan nij síí ya̱nj rá veꞌ yoꞌ se vaa dínj ga̱a̱ cuma̱n nij soꞌ, quiꞌya̱j Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ne̱ sese ya̱nj ꞌo̱ síí ca̱yáán sa̱ꞌ ga̱ Diose̱ rá veꞌ yoꞌ, ga̱a ne̱ ya̱ veꞌé ca̱yáán soꞌ, quiꞌya̱j Diose̱ a. Tza̱j ne̱ sese nuviꞌ síí ca̱yáán sa̱ꞌ ga̱ Diose̱ yáán rá veꞌ yoꞌ, ne̱ ca̱nica̱j uún nana̱ sa̱ꞌ caꞌmii soj rihaan maꞌa̱n soj, quiꞌya̱j Diose̱, tza̱j ne̱ se̱ cavii sa̱ꞌ nij síí tucua̱ yoꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Cara̱nꞌ soj veꞌ ya̱nj síí sa̱ꞌ yoꞌ, ne̱ me maꞌa̱n se rque̱ síí ya̱nj yoꞌ, ne̱ cha̱ soj coꞌo̱ soj do̱ꞌ, ne̱ no̱ xcúún yuvii̱ rque̱ yuvii̱ chraa cha̱ soj cheꞌé suun sa̱ꞌ ꞌyaj suun soj a. Se̱ caꞌanj soj cara̱nꞌ soj yoꞌó yoꞌó veꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Asa̱ꞌ cuchiꞌ soj ꞌo̱ chumanꞌ, ne̱ sese veꞌé caꞌmi̱i̱ nij síí ma̱n chumanꞌ yoꞌ ga̱ soj, ga̱a ne̱ cha̱ soj me maꞌa̱n se chá rque̱ nij soꞌ man nij soj a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Caꞌne̱e̱ soj chiꞌii̱ xráá nij síí ranꞌ ma̱n chumanꞌ yoꞌ, ne̱ caꞌmi̱i̱ natáj soj rihaan yuvii̱ se vaa nichru̱nꞌ gu̱un chij Diose̱ chiháán nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","”Tza̱j ne̱ asa̱ꞌ cuchiꞌ soj ꞌo̱ chumanꞌ, ne̱ sese ne caꞌve̱j rá nij yuvii̱ cuno̱ nij yuvii̱ se‑na̱na̱ soj, ga̱a ne̱ canicu̱nꞌ soj tanu̱u̱ rá callé chumanꞌ, ga̱a ne̱ cata̱j soj rihaan nij yuvii̱ ma̱n chumanꞌ yoꞌ a: ");
INSERT INTO trcNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Asa̱ꞌ curiha̱nj núj chumanꞌ nihánj, ne̱ nacuna̱nꞌ núj tacóó núj, ne̱ tucuayu̱u núj yoꞌóó tachru̱u̱ avii chiháán soj tacóó núj cayu̱u yoꞌ rihaan maꞌa̱n soj a. Ga̱a ne̱ xca̱j soj cuentá se vaa guun rá Diose̱ gu̱un chij Diose̱ chiháán soj, tza̱j ne̱ ne caꞌve̱j rá soj a”. Da̱nj cata̱j soj rihaan nij síí naꞌvej rá cuno̱ nana̱ caꞌmii soj a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ne̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa vaa güii caꞌne̱ꞌ ꞌu̱nj cacunꞌ cheꞌé nij yuvii̱, ga̱a ne̱ quira̱nꞌ nij yuvii̱ ma̱n chumanꞌ yoꞌ doj sayuun rihaan nij síí chiꞌi̱i̱ ma̱n chumanꞌ Sodoma ado̱nj ―taj Jesucristó rihaan nij síí caꞌnéé soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ga̱a ne̱ dan me se cataj uún Jesucristó a: ―Nique̱ soj si̱j ma̱n chumanꞌ Corazín a. Nique̱ soj si̱j ma̱n chumanꞌ Betsaida a. ꞌO̱ se quira̱nꞌ uxrá soj sayuun na̱nj á. Dan me se nij síí ma̱n chumanꞌ Tiro do̱ꞌ, nij síí ma̱n chumanꞌ Sidón do̱ꞌ, me síí chiꞌi̱i̱ nimán na̱nj á. Tza̱j ne̱ sese caꞌanj ꞌu̱nj chiháán nij soꞌ, ne̱ sese quiꞌyáj suun sa̱ꞌ noco̱o niꞌya̱j nij soꞌ, ne̱ cuno nij soꞌ se‑na̱na̱j ne̱ guun ya̱ rá nij soꞌ se vaa tumé nij soꞌ cacunꞌ, ne̱ canica̱j nimán nij soꞌ, ne̱ quinanó ndoꞌo rá nij soꞌ cheꞌé cacunꞌ tumé nij soꞌ, ne̱ nda̱a yatzíj yaꞌ cunuû nij soꞌ, ne̱ nda̱a yaj chruun acaa ruvaj caraa nij soꞌ raa̱ nij soꞌ, cheꞌé yan quinanó rá nij soꞌ cheꞌé cacunꞌ tumé nij soꞌ asuun sa̱j ado̱nj. Nihánj, ne̱ ne caꞌa̱nj ꞌu̱nj maꞌ. Ma̱a̱n se ina̱nj chiháán soj ꞌnaj, ne̱ quiꞌyáj suun sa̱ꞌ noco̱o queneꞌen maꞌa̱n soj, tza̱j ne̱ ne ca̱nica̱j nimán nij soj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Dan me se güii caꞌne̱ꞌ ꞌu̱nj cacunꞌ cheꞌé nij yuvii̱ roꞌ, doj a̱ ga̱a̱ sayuun quira̱nꞌ soj rihaan sayuun quira̱nꞌ nij síí chiꞌi̱i̱ ma̱n chumanꞌ Tiro do̱ꞌ, ma̱n chumanꞌ Sidón do̱ꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ne̱ vaa soj si̱j ma̱n chumanꞌ Capernaum uún a. Ne̱ síí sa̱ꞌ ina̱nj me maꞌa̱n soj, rá soj naꞌ. Nuveé si̱j sa̱ꞌ me soj maꞌ. Síí caꞌa̱nj rihaan yaꞌan gu̱un soj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ne̱ cataj uún Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a: ―Síí nanó xre̱j se‑na̱na̱ soj roꞌ, soꞌ me síí nanó xre̱j se‑na̱na̱ ma̱ꞌanj a. Tza̱j ne̱ síí uun naco̱o̱ rá niꞌya̱j man soj roꞌ, soꞌ me síí uun naco̱o̱ rá niꞌya̱j man nda̱a ma̱ꞌanj a. Ne̱ síí uun naco̱o̱ rá niꞌya̱j man ma̱ꞌanj roꞌ, soꞌ me síí uun naco̱o̱ rá niꞌya̱j man Diose̱ síí caꞌnéé manj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Quisíj quiꞌyaj vaꞌnu̱j chiha̱a̱ chi̱ꞌ nij soꞌ nda̱a vaa cataj Jesucristó, ga̱a ne̱ namán uún nij soꞌ a. Niha̱ꞌ rá nij soꞌ, ne̱ cataj nij soꞌ rihaan Jesucristó a: ―Nda̱a nij nana̱ chre̱e uno rihaan núj, Señor. Cheꞌé se se‑chu̱vií so̱ꞌ táá tuꞌva núj, ne̱ uriha̱nj nij soꞌ nimán yuvii̱ na̱nj á ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Neꞌen yaj cayuu se nucua̱j nica̱j Satanás, ne̱ ase uun raa̱n roꞌ, me cayuu se nucua̱j nica̱j Satanás ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Cuno̱ soj caꞌmi̱j á. ꞌU̱nj roꞌ, me síí quiꞌya̱j gu̱un nucua̱j soj quiꞌya̱j canaán soj rihaan daj a̱ se chiꞌi̱i̱ a. Caꞌve̱e se ruꞌma̱an cheꞌé soj ꞌo̱ xcuáá do̱ꞌ, ꞌo̱ xcuun do̱ꞌ, tza̱j ne̱ taj se quiꞌya̱j xoꞌ man soj maꞌ. Quiꞌya̱j canaán soj rihaan nu̱ꞌ se nucua̱j nica̱j Satanás síí ta̱j riꞌyunj niꞌya̱j man níꞌ, ne̱ a̱ ꞌó xcoꞌ se̱ quiꞌyaj chiꞌi̱i̱ a̱ ꞌó rasu̱u̱n man soj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tza̱j ne̱ taj cheꞌé gu̱un niha̱ꞌ rá soj cheꞌé se uno nij nana̱ chre̱e rihaan soj maꞌ. Gu̱un niha̱ꞌ rá soj, tza̱j ne̱ cheꞌé se a̱j cachrón Diose̱ se‑chuvi̱i soj rej xta̱ꞌ roꞌ, cheꞌé dan gu̱un niha̱ꞌ rá soj á ―taj Jesucristó rihaan vaꞌnu̱j chiha̱a̱ chi̱ꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ma̱a̱n güii yoꞌ roꞌ, guun niha̱ꞌ rá Jesucristó, quiꞌyaj Nimán Diose̱, ne̱ cataj Jesucristó rihaan Diose̱ a: ―Síí ꞌni̱j raꞌa chumii̱ do̱ꞌ, síí ꞌni̱j raꞌa xta̱ꞌ do̱ꞌ, mé so̱ꞌ, Ata̱j Chij. Ne̱ sa̱ꞌ uxrá quiꞌyáá so̱ꞌ caráán so̱ꞌ rihaan nij síí avii raa̱ do̱ꞌ, rihaan nij síí acaj cuentá do̱ꞌ, se vaa se̱ cuno nij soꞌ se‑na̱na̱j maꞌ. Ma̱a̱n nij síí vaa nica̱ꞌ nimán roꞌ, veꞌé cuno nij soꞌ, quiꞌyáá so̱ꞌ a. Da̱nj ina̱nj quiꞌyáá so̱ꞌ, cheꞌé yan da̱nj me rá so̱ꞌ qui̱ꞌyáá so̱ꞌ, Ata̱j ―taj Jesucristó rihaan Rej soꞌ Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Canica̱j Jesucristó, caꞌmii soꞌ rihaan nij yuvii̱, cataj soꞌ a: ―A̱j rqué Réé ꞌu̱nj Diose̱ cunuda̱nj rasu̱u̱n rihanj á. Ne̱ a̱ ꞌó síí ne neꞌen da̱j vaa ꞌu̱nj, ma̱a̱n se o̱rúnꞌ Réj neꞌen a. ꞌO̱ se taꞌníí soꞌ mej ado̱nj. Ne̱ a̱ ꞌó síí ne neꞌen da̱j vaa Réj maꞌ. Ma̱a̱n se o̱rúnꞌ ꞌu̱nj neꞌen da̱j vaa soꞌ ado̱nj. Ne̱ sese me rá ꞌu̱nj cata̱j xnaꞌanj ꞌu̱nj rihaan yoꞌó nij yuvii̱ da̱j vaa Réj, ne̱ queneꞌe̱n yoꞌó nij soꞌ uún ado̱nj ―taj Jesucristó rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ga̱a ne̱ niꞌya̱j Jesucristó man nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ cataj soꞌ rihaan ina̱nj maꞌa̱n nij soꞌ a: ―Vaa cheꞌé ga̱a̱ niha̱ꞌ rá soj cheꞌé rihaan soj á. ꞌO̱ se a̱j queneꞌen soj se vaa quiꞌyáj na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ꞌO̱ se cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa ma̱n ndoꞌo síí ma̱n ga̱a naá síí nataꞌ se‑na̱na̱ Diose̱ do̱ꞌ, síí nica̱j suun rey do̱ꞌ, guun rá queneꞌe̱n se vaa queneꞌen nij soj, tza̱j ne̱ ne queneꞌe̱n nij soꞌ maꞌ. Ne̱ guun rá nij soꞌ cuno̱ nij soꞌ se vaa cuno nij soj, tza̱j ne̱ ne cuno̱ nij soꞌ a̱ man ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ga̱a ne̱ dan me se canicunꞌ caya̱ ꞌo̱ síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱, ne̱ xnáꞌanj soꞌ ꞌo̱ nana̱ man Jesucristó, cheꞌé rej guun rá soꞌ quiri̱ꞌ soꞌ rej cara̱a soꞌ cacunꞌ xráá Jesucristó a. ―Da̱j qui̱ꞌyáj, ga̱a ne̱ caꞌve̱e ca̱yánj ga̱ Diose̱ nu̱ꞌ cavii nu̱ꞌ caꞌanj, ga̱ maestroꞌ ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Neꞌén so̱ꞌ me nana̱ no̱ rihaan yanj no̱ se‑tucua̱nj Moisés naꞌ. Da̱j taj yanj yoꞌ nayaa so̱ꞌ ga̱ ―taj Jesucristó, xnáꞌanj Jesucristó man soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ga̱a ne̱ cataj soꞌ rihaan Jesucristó a: ―“Nda̱a nimán yá so̱ꞌ gu̱un rá so̱ꞌ ni̱ꞌyaj so̱ꞌ man Diose̱ síí ꞌni̱j raꞌa man níꞌ, ne̱ nda̱a nu̱ꞌ se nucua̱j yá so̱ꞌ cara̱a̱ cochro̱j rihaan Diose̱, ne̱ yoꞌo̱ nda̱a cúú yave̱ mán so̱ꞌ cuchuma̱n rá ni̱ꞌyaj man Diose̱ na̱nj ado̱nj.” Ne̱, “Adi̱ꞌ se ꞌe̱e̱ rá so̱ꞌ man ma̱ꞌán so̱ꞌ roꞌ, da̱nj ga̱a̱ ꞌe̱e̱ rá so̱ꞌ man tuvíꞌ so̱ꞌ á”, taj se‑tucua̱nj Moisés ado̱nj ―taj síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Ya̱ uxrá aꞌmii so̱ꞌ á. Da̱nj qui̱ꞌyáá so̱ꞌ, ga̱a ne̱ ca̱yáán so̱ꞌ ga̱ Diose̱ nu̱ꞌ cavii nu̱ꞌ caꞌanj na̱nj á ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tza̱j ne̱ síí sa̱ꞌ ina̱nj me síí tucuꞌyón se‑tucua̱nj Moisés, rá maꞌa̱n soꞌ a. Cheꞌé dan xnáꞌanj soꞌ nana̱ nihánj man Jesucristó a: ―Me síí me tuvíꞌ ꞌu̱nj ga̱ ―taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ga̱a ne̱ canica̱j Jesucristó, nanó soꞌ se‑cuento̱ síí samaritano a: ―Dan me se cavii ꞌo̱ síí israelitá chumanꞌ Jerusalén, caꞌanj soꞌ chumanꞌ Jericó a. Va̱j soꞌ chrej, ga̱a ne̱ caráán síí itu̱u̱ man soꞌ chrej, ne̱ goꞌ uxrá nij síí itu̱u̱ man soꞌ, ne̱ quirii nij síí itu̱u̱ saga̱nꞌ soꞌ, ne̱ da̱j doj se caviꞌ soꞌ, ga̱a ne̱ tanáj nij síí itu̱u̱ man soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ga̱a ne̱ dan me se va̱j ꞌo̱ xrej nicu̱nꞌ rihaan níꞌ si̱j israelitá chrej yoꞌ a. Queneꞌen soꞌ man síí quiranꞌ chiꞌii̱ na̱j tuꞌva chrej, tza̱j ne̱ cachén yaníj soꞌ caꞌanj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ga̱a ne̱ dan me se va̱j ꞌo̱ taꞌníí taꞌnij siꞌno̱ Leví síí racuíj man xrej uún a. Queneꞌen soꞌ man síí quiranꞌ chiꞌii̱ yoꞌ, tza̱j ne̱ cachén yaníj soꞌ caꞌanj soꞌ uún a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","”Ga̱a ne̱ dan me se caꞌnaꞌ ꞌo̱ síí samaritano uún a. Nuveé si̱j israelitá me soꞌ maꞌ. Si̱j yaníj avii rej Samaria me soꞌ a. Queneꞌen soꞌ man síí quiranꞌ chiꞌii̱ yoꞌ, ga̱a ne̱ cunuu ꞌe̱e̱ rá soꞌ man síí quiranꞌ chiꞌii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Caꞌanj soꞌ quiꞌyaj conoꞌó soꞌ man síí quiranꞌ chiꞌii̱ yoꞌ, ne̱ cutaꞌ soꞌ rmedió rej quiranꞌ chiꞌii̱, ne̱ nacutáj soꞌ mantá rej quiranꞌ chiꞌii̱ yoꞌ a. Ga̱a ne̱ cutaꞌ síí samaritano yoꞌ man síí quiranꞌ chiꞌii̱ yoꞌ xráá daán soꞌ xcuu va̱j ga̱ soꞌ, ne̱ caꞌanj ro̱j soꞌ veꞌ aranꞌ yuvii̱ chéé chrej, ne̱ taj yaꞌanj síí samaritano yoꞌ man síí quiranꞌ chiꞌii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Cachén ꞌo̱ yanꞌ, ne̱ yoꞌó güii me se guun rá síí samaritano caꞌa̱nj soꞌ, ne̱ quirii soꞌ vi̱j saꞌanj denario, ne̱ caxríj soꞌ ston síí tucua̱ veꞌ se vaa ta̱j yaꞌanj soꞌ man síí ranꞌ, ga̱a ne̱ cataj soꞌ rihaan síí tucua̱: “Asa̱ꞌ caꞌnaꞌ uún ꞌu̱nj, ne̱ na̱ruꞌvee ꞌu̱nj me daj maꞌa̱n saꞌanj me ga̱a̱ tuꞌvee so̱ꞌ, rá so̱ꞌ”, taj síí samaritano rihaan síí tucua̱ a. ―Veé da̱nj síj cuentó nanó Jesucristó rihaan síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ga̱a ne̱ xnáꞌanj Jesucristó nana̱ nihánj man síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés yoꞌ a: ―Vaꞌnu̱j nij síí va̱j rá chrej yoꞌ, ga̱a ne̱ me soꞌ me tuviꞌ síí quiranꞌ chiꞌii̱ yoꞌ, rá so̱ꞌ ga̱ ―taj Jesucristó, xnáꞌanj Jesucristó man soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","―Síí cunuu ꞌe̱e̱ rá man soꞌ roꞌ, me tuviꞌ soꞌ, raj a ―taj síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan Jesucristó a. Ne̱ cataj uún Jesucristó rihaan soꞌ a: ―Ase vaa quiꞌyaj síí cunuu ꞌe̱e̱ rá man síí quiranꞌ chiꞌii̱ yoꞌ roꞌ, veé da̱nj quiꞌya̱j gue̱e̱ so̱ꞌ, caꞌa̱nj so̱ꞌ ei ―taj Jesucristó rihaan síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Dan me se va̱j Jesucristó chrej ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ cuchiꞌ soꞌ ꞌo̱ chumanꞌ, ne̱ dan me se caꞌvej rá ꞌo̱ chana̱ cuꞌna̱j Marta ya̱nj chumanꞌ yoꞌ cara̱nꞌ Jesucristó tucuá noꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ne̱ yáán chuꞌvij noꞌ chana̱ cuꞌna̱j Mariá ga̱ noꞌ, ne̱ dan me se caꞌanj ca̱yáán chuꞌvij noꞌ Mariá tacóó Jesucristó, ne̱ nanó xre̱j noꞌ se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Tza̱j ne̱ Marta roꞌ, daj a̱ suun caráyaꞌa̱nj noꞌ a. Dan me se quinichrunꞌ Marta rihaan Jesucristó, ne̱ cataj noꞌ rihaan soꞌ a: ―Me cheꞌé ne rihuun rá so̱ꞌ se vaa dínj ne chuꞌvij ꞌu̱nj, ne̱ o̱rúnꞌ ma̱ꞌanj ꞌyaj chuvi̱i, ga̱ Señorꞌ. Cata̱j so̱ꞌ rihaan noꞌ se vaa ra̱cuíj noꞌ manj á ―taj Marta rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tza̱j ne̱ cataj Jesucristó rihaan noꞌ a: ―Xa̱ꞌ cheꞌé suun ma̱n rihaan chumii̱ nihánj, tza̱j ne̱ taj cheꞌé cara̱yaꞌáán so̱ꞌ nda̱a vaa ꞌyáá so̱ꞌ, man Marta. Snúú rá so̱ꞌ, ꞌyaj suun vaa rihaan so̱ꞌ á. ꞌO̱ se taj cheꞌé cara̱yaꞌa̱nj níꞌ rasu̱u̱n ma̱n rihaan chumii̱ nihánj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ꞌO̱ se doj a̱ vaa suun achiin quiꞌya̱j níꞌ, ne̱ vaa o̱rúnꞌ suun sa̱ꞌ ya̱ ya̱ achiin rihaan níꞌ na̱nj á. Ne̱ Mariá nihánj, tza̱j ne̱ cuna̱j ꞌyaj noꞌ se vaa me rá noꞌ cuno̱ noꞌ se‑na̱na̱j, ne̱ taj cheꞌé cata̱j níꞌ se vaa nij ꞌyaj noꞌ uno noꞌ se‑na̱na̱j maꞌ ―taj Jesucristó rihaan Marta a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ga̱a ne̱ dan me se cachíín niꞌya̱j Jesucristó rihaan Diose̱ ꞌo̱ güii, ne̱ ga̱a quisíj cachíín niꞌya̱j soꞌ rihaan Diose̱, ga̱a ne̱ cataj ꞌo̱ síí tucuꞌyón se‑na̱na̱ soꞌ rihaan soꞌ a: ―Tu̱cuꞌyón so̱ꞌ man núj da̱j caꞌmi̱i̱ núj ga̱a cachi̱nj niꞌya̱j núj rihaan Diose̱, Señor. ꞌO̱ se xa̱ꞌ síí cuꞌna̱j Juan síí cutaꞌ ne man yuvii̱, tza̱j ne̱ tucuꞌyón soꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ da̱j caꞌmi̱i̱ nij soꞌ ga̱a cachi̱nj niꞌya̱j nij soꞌ rihaan Diose̱, ne̱ da̱nj ina̱nj qui̱ꞌyáá so̱ꞌ cheꞌé núj, rá núj a ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ga̱a ne̱ dan me se caꞌmii Jesucristó nana̱ nihánj rihaan nij soꞌ a: ―Na̱nj cata̱j soj ga̱a cachi̱nj niꞌya̱j soj rihaan Diose̱ á: “Ata̱j Chij, me rá núj xca̱j yuvii̱ cuentá se vaa ina̱nj sa̱ꞌ ꞌyáá so̱ꞌ a. Ne̱ me rá núj quisi̱j güii gu̱un chij so̱ꞌ rihaan chumii̱ nihánj a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ne̱ ꞌo̱ ꞌo̱ güii me se rque̱ so̱ꞌ nu̱ꞌ rasu̱u̱n achiin man núj cha̱ núj á. ");
INSERT INTO trcNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ne̱ cara̱a̱ xꞌnaa so̱ꞌ cheꞌé cacunꞌ ta̱j xráá núj á. ꞌO̱ se maꞌa̱n núj me síí aráj xꞌnaa cheꞌé cacunꞌ ꞌyaj tuviꞌ núj rihaan núj na̱nj ado̱nj. Dan me se ca̱ráán raꞌá so̱ꞌ xráá núj rihaan chrej chiꞌi̱i̱ á”. Da̱nj cata̱j soj ga̱a cachi̱nj niꞌya̱j soj rihaan Diose̱ ei ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ga̱a ne̱ canica̱j Jesucristó, nanó soꞌ ꞌo̱ se‑cuento̱ síí cachíín rasu̱u̱n rihaan tuviꞌ rej nii̱ a: ―Dan me se cata̱j níꞌ, ne̱ cuchi̱ꞌ ꞌo̱ soꞌ tucuá tuviꞌ soꞌ ya̱nꞌ, ne̱ cata̱j soꞌ rihaan tuviꞌ soꞌ: “Qui̱ꞌyáá so̱ꞌ se ndoꞌo, ne̱ ra̱cuíj so̱ꞌ vaꞌnu̱j chraa manj, tinu̱j. ");
INSERT INTO trcNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Caꞌnaꞌ ꞌo̱ tuvij síí achén chrej, ne̱ caranꞌ soꞌ tucuaj, tza̱j ne̱ taj va̱j chraa rihanj go̱j cha̱ soꞌ maꞌ”, cata̱j soꞌ rihaan tuviꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ne̱ da̱j cata̱j tuviꞌ soꞌ rihaan soꞌ, rá soj ga̱. Cata̱j tuviꞌ soꞌ: “Se̱ narii so̱ꞌ nej rihanj, man tinu̱j. A̱j naquiꞌyaj raan ꞌu̱nj taꞌyaa, ne̱ a̱j otoj nij taꞌni̱j núj, ne̱ rmi̱j na̱xagaj rque̱j chraa mán so̱ꞌ ei”, cata̱j tuviꞌ soꞌ rihaan soꞌ, rá soj naꞌ. Daj chiha̱a̱ míj se̱ caꞌmii soꞌ da̱nj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Dan me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa síí otoj yoꞌ roꞌ, nda̱ꞌ se naꞌvej rá soꞌ na̱xagaa soꞌ go̱ꞌ soꞌ chraa man tuviꞌ soꞌ, tza̱j ne̱ cheꞌé se ne uun naꞌa̱j tuviꞌ soꞌ achíín achíín soꞌ chraa, ne̱ cheꞌé dan gu̱un rmi̱i̱ xréé síí na̱j otoj, ga̱a ne̱ na̱xagaa soꞌ, ne̱ go̱ꞌ soꞌ me maꞌa̱n rasu̱u̱n achiin man síí nicu̱nꞌ taꞌyaa yoꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","”Ne̱ ꞌu̱nj nihánj me síí cata̱j xnaꞌanj rihaan soj se vaa cachi̱nj soj se vaa achiin man soj rihaan Diose̱, ne̱ soꞌ me síí rque̱ man soj, ne̱ nano̱ꞌ soj rasu̱u̱n achiin man soj, ne̱ nari̱ꞌ soj rasu̱u̱n yoꞌ, ne̱ ase vaa ꞌyaj síí ticaꞌmii taꞌyaa tucuá tuviꞌ roꞌ, da̱nj quiꞌya̱j soj ga̱ Diose̱, ne̱ caꞌnu̱u̱ Diose̱ taꞌyaa yoꞌ, ne̱ rque̱ Diose̱ rasu̱u̱n achiin man soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ꞌO̱ se síí achíín rasu̱u̱n rihaan Diose̱ roꞌ, quiri̱ꞌ soꞌ rasu̱u̱n achiin man soꞌ, ne̱ síí nanoꞌ rasu̱u̱n achiin man roꞌ, quiri̱ꞌ soꞌ rasu̱u̱n yoꞌ, ne̱ síí ticaꞌmii taꞌyaa rej ya̱nj Diose̱ roꞌ, caꞌnu̱u̱ Diose̱ taꞌyaa, ne̱ quiri̱ꞌ síí ticaꞌmii taꞌyaa rasu̱u̱n achiin man soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Xca̱j soj cuentá se vaa maꞌa̱n soj, na̱nj yuvii̱ me soj, tza̱j ne̱ sese achíín taꞌníí yoꞌo̱ tuviꞌ soj chraa cha̱ yoꞌ man soj, ne̱ se̱ caꞌvee nano̱ꞌ soj yahij ne̱ caxri̱i̱ soj ston yoꞌ maꞌ. Ne̱ sese achíín taꞌníí soj nee̱ xcuaj cha̱ yoꞌ man soj, ne̱ se̱ caꞌvee nano̱ꞌ soj xcuáá ne̱ caxri̱i̱ soj ston yoꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ne̱ sese achíín taꞌníí soj xrúú chuchee cha̱ yoꞌ man soj, ne̱ se̱ caꞌvee nano̱ꞌ soj xcuun ne̱ caxri̱i̱ soj ston yoꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Dan me se da̱nj na̱nj soj, ne̱ síí chiꞌi̱i̱ nimán me soj, tza̱j ne̱ neꞌen soj rque̱ soj se sa̱ꞌ cha̱ taꞌníí soj ei. Cheꞌé dan táá a̱ Rej soj síí nicu̱nꞌ xta̱ꞌ, ne̱ si̱j sa̱ꞌ ina̱nj me soꞌ, ne̱ soꞌ me síí rque̱ ya̱ Nimán man nij síí achíín Nimán Diose̱ rihaan soꞌ na̱nj ado̱nj. ―Da̱nj cataj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Dan me se ꞌo̱ güii quirii Jesucristó yoꞌo̱ nana̱ chre̱e nimán ꞌo̱ síí yaꞌmi̱i, ne̱ dan me se yaꞌmi̱i soꞌ, quiꞌyaj nana̱ chre̱e yoꞌ, tza̱j ne̱ curiha̱nj nana̱ chre̱e nimán soꞌ, ne̱ guun cheꞌe̱ soꞌ caꞌmii soꞌ ado̱nj. Ne̱ caráyaꞌa̱nj uxrá nij yuvii̱ queneꞌen nij soꞌ se vaa quiꞌyaj Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ne̱ taꞌa̱j nij yuvii̱ cataj se vaa aꞌmii Jesucristó ga̱ síí chre̱e cuꞌna̱j Beelzebú síí uun chij rihaan nij nana̱ chre̱e, ne̱ cheꞌé dan rii soꞌ man nij nana̱ chre̱e nimán yuvii̱, taj taꞌa̱j nij yuvii̱, niꞌya̱j nij yuvii̱ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ne̱ yoꞌó taꞌa̱j nij yuvii̱ guun rá cuta̱ꞌ cacunꞌ xráá Jesucristó, ne̱ cheꞌé dan cachíín niꞌya̱j nij soꞌ rihaan Jesucristó se vaa quiꞌya̱j soꞌ ꞌo̱ suun sa̱ꞌ noco̱o ꞌnaꞌ rej xta̱ꞌ ni̱ꞌyaj nij soꞌ, taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Dan me se queneꞌen maꞌa̱n Jesucristó da̱j vaa nimán nij yuvii̱, ne̱ cheꞌé dan cataj soꞌ: ―Neꞌen soj se vaa sese vaa ꞌo̱ nación, ne̱ sese xra̱ꞌ taꞌa̱j nij síí uun chij rihaan nación yoꞌ ne̱ cunu̱ꞌ maꞌa̱n nij soꞌ ga̱ tuviꞌ nij soꞌ, ne̱ vaa güii, ne̱ nu̱ꞌ nación yoꞌ quiri̱ꞌ nu̱ꞌ na̱nj ado̱nj. Ne̱ sese cunu̱ꞌ taꞌa̱j nij yuvii̱ ma̱n ꞌo̱ barrió ga̱ tuviꞌ yuvii̱ síí ma̱n maꞌa̱n barrió yoꞌ roꞌ, ne̱ vaa güii, ne̱ quiri̱ꞌ nu̱ꞌ barrió yoꞌ, quiꞌya̱j nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Cheꞌé dan me sese racuíj síí chre̱e síí cuꞌna̱j Satanás manj rii ꞌu̱nj man tuviꞌ soꞌ nana̱ chre̱e nimán nij yuvii̱, ga̱a ne̱ asa̱ꞌ caꞌve̱e gu̱un chij ndoꞌo soꞌ rihaan nij yuvii̱ ma̱n rihaan chumii̱ nihánj, rá soj ga̱. Nana̱ nihánj xnáꞌanj ꞌu̱nj man soj cheꞌé se me rá soj cata̱j soj se vaa síí chre̱e cuꞌna̱j Beelzebú roꞌ, me síí racuíj manj rij man nana̱ chre̱e nimán nij yuvii̱, rá soj vaa na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Dan me se rii ꞌu̱nj man nij nana̱ chre̱e nimán nij yuvii̱, ꞌyaj síí chre̱e cuꞌna̱j Beelzebú, cheꞌé se aꞌmii ꞌu̱nj ga̱ soꞌ, rá soj a. Tza̱j ne̱ nij síí tucuꞌyón se‑na̱na̱ soj me se veé da̱nj rii uún nij soꞌ man nij nana̱ chre̱e nimán nij yuvii̱ uún ei. Ne̱ asa̱ꞌ aꞌvee ꞌyaj nij soꞌ da̱nj, rá soj ga̱. Ne̱ vaa nij soꞌ vaa, veé da̱nj aꞌmii nij soꞌ ga̱ síí chre̱e, rá soj ga̱a̱ naꞌ. Cheꞌé nana̱ caꞌmii soj me se maꞌa̱n nij síí tucuꞌyón se‑na̱na̱ soj cuta̱ꞌ cacunꞌ xráá soj se vaa caꞌmii ne̱ soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tza̱j ne̱ ꞌu̱nj me se ya̱ maꞌa̱n raꞌa Diose̱ racuíj manj rii ꞌu̱nj man nij nana̱ chre̱e nimán nij yuvii̱ ado̱nj. Cheꞌé dan xca̱j soj cuentá se vaa a̱j guun cheꞌe̱ Diose̱ guun chij Diose̱ rihaan chumii̱ nihánj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","”Dan me se sese ꞌo̱ síí ruꞌvee ya̱nj rá veꞌ me se vaa agaꞌ siha̱a̱ do̱ꞌ, vaa mixté do̱ꞌ, rihaan soꞌ, ne̱ tumé soꞌ siꞌyaj soꞌ yáán soꞌ, ne̱ taj síí caꞌne̱e̱ siꞌyaj soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tza̱j ne̱ sese caꞌna̱ꞌ yoꞌó síí vaa doj fuerzá rihaan, ga̱a ne̱ quiꞌya̱j canaán soꞌ rihaan síí ya̱nj raan, ga̱a ne̱ caꞌne̱e̱ soꞌ nu̱ꞌ saga̱ꞌ soꞌ do̱ꞌ, nu̱ꞌ siꞌyaj soꞌ do̱ꞌ, ne̱ cuxra̱ꞌ taꞌa̱j soꞌ ga̱ tuviꞌ soꞌ na̱nj ado̱nj. Taꞌngaꞌ da̱nj ꞌyáá ꞌu̱nj ga̱ síí chre̱e, ne̱ ꞌyaj canaán ꞌu̱nj man soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","”Na̱j guun síí naꞌvej rá quiꞌya̱j suun ga̱ ꞌu̱nj roꞌ, síí ta̱j riꞌyunj manj me soꞌ a. Ne̱ na̱j guun síí ne racuíj manj naquiꞌya̱j chre̱ꞌ ꞌu̱nj man yuvii̱ canoco̱ꞌ man Diose̱ roꞌ, soꞌ me síí tichaꞌnuu̱ man nij yuvii̱, ne̱ aráán soꞌ rihaan nij yuvii̱ se̱ canocoꞌ nij yuvii̱ man Diose̱ ei ―taj Jesucristó rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","25","Ga̱a ne̱ cataj uún Jesucristó rihaan nij yuvii̱ a: ―Ne̱ ga̱a tiha̱j avii yu̱u̱n yoꞌo̱ nana̱ chre̱e nimán snóꞌo, ne̱ chéé rmaꞌa̱n nana̱ chre̱e yoꞌ nanoꞌ soꞌ rej ca̱yáán soꞌ, tza̱j ne̱ taj se qui̱ꞌyáꞌ quiri̱ꞌ nana̱ chre̱e yoꞌ rej ca̱yáán soꞌ, ga̱a ne̱ me rá uún nana̱ chre̱e yoꞌ ca̱nica̱j soꞌ rej cavii soꞌ ga̱a naá a. Dan me se taj nana̱ chre̱e yoꞌ: “Ca̱nica̱j uún ꞌu̱nj nánꞌ ꞌu̱nj rej cavii ꞌu̱nj a. Veꞌé na̱nj vaa tucuaj, ne̱ naruvii rá veꞌ tucuaj cuano̱, ne̱ uun yâj ya̱nj rá veꞌ tucuaj cuano̱ ado̱nj”, taj nana̱ chre̱e yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ga̱a ne̱ dan me se anica̱j uún nana̱ chre̱e yoꞌ nimán snóꞌo yoꞌ, ne̱ nanoꞌ nana̱ chre̱e yoꞌ yoꞌó chi̱j tuviꞌ nana̱ chre̱e yoꞌ síí chiꞌi̱i̱ doj, ne̱ ꞌnaꞌ nique uún soꞌ nimán snóꞌo yoꞌ, ga̱a ne̱ ca̱yáán taranꞌ nij nana̱ chre̱e yoꞌ a. Dan me se ga̱a naá ga̱a cayáán o̱rúnꞌ nana̱ chre̱e yoꞌ, ga̱a ne̱ ma̱a̱n taꞌngaꞌ quij vaa nimán snóꞌo yoꞌ, tza̱j ga̱a namán yoꞌó chi̱j nana̱ chre̱e yoꞌ, ga̱a ne̱ doj a̱ tico nana̱ chre̱e man soꞌ, ne̱ doj a̱ quij vaa nimán snóꞌo yoꞌ, ꞌyaj nana̱ chre̱e yoꞌ a̱ ado̱nj ―taj Jesucristó rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Dan me se ga̱a caꞌmii Jesucristó nana̱ vaa da̱nj, ga̱a ne̱ nucua̱j caꞌmii ꞌo̱ chana̱ nicu̱nꞌ scaꞌnúj nij yuvii̱, cataj noꞌ: ―Cavi̱i̱ sa̱ꞌ nií so̱ꞌ, cheꞌé se cuchruj noꞌ mán so̱ꞌ, ne̱ tucutzii noꞌ mán so̱ꞌ á ―taj chana̱ yoꞌ, caguáj noꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Tza̱j ne̱ cataj Jesucristó a: ―Síí cavi̱i̱ sa̱ꞌ ya̱ roꞌ, me síí uno se‑na̱na̱ Diose̱ ne̱ ꞌyaj nda̱a vaa taj nu̱ꞌ nana̱ yoꞌ ado̱nj ―taj Jesucristó rihaan nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Dan me se cunuu chre̱ꞌ doj yuvii̱ rihaan Jesucristó, ne̱ cheꞌé dan guun cheꞌe̱ soꞌ caꞌmii soꞌ nana̱ nihánj a: ―Ina̱nj cheꞌé se yuvii̱ vaa chiꞌi̱i̱ nimán me soj roꞌ, cheꞌé dan me rá soj qui̱ꞌyáj suun sa̱ꞌ noco̱o á. Tza̱j ne̱ se̱ quiꞌyáj suun sa̱ꞌ noco̱o cheꞌé soj maꞌ. Ma̱a̱n se queneꞌe̱n soj se vaa ase vaa quiranꞌ síí cuꞌna̱j Jonás ga̱a naá roꞌ, da̱nj qui̱ránꞌ ꞌu̱nj, vaa güii na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Dan me se quiꞌyaj Diose̱ suun sa̱ꞌ noco̱o ga̱ síí cuꞌna̱j Jonás queneꞌen nij síí ma̱n chumanꞌ Nínive ga̱a naá, ne̱ da̱nj ina̱nj quiꞌya̱j uún Diose̱ ga̱ ꞌu̱nj si̱j caꞌnéé soꞌ ni̱caj yuꞌunj man yuvii̱, queneꞌe̱n soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","”Ne̱ güii caꞌne̱ꞌ Diose̱ cacunꞌ cheꞌé yuvii̱ roꞌ, cuchi̱ꞌ chana̱ nica̱j suun reiná guun chij rihaan chumanꞌ na̱j ga̱nꞌ ndoꞌo rej sur, ne̱ canicu̱nꞌ noꞌ rihaan soj, quiꞌya̱j Diose̱, ne̱ cuta̱ꞌ noꞌ cacunꞌ xráá soj ado̱nj. ꞌO̱ se ga̱nꞌ ndoꞌo cachéé noꞌ cuchi̱ꞌ noꞌ rihaan síí cuꞌna̱j Salomón, ne̱ cuno noꞌ nana̱ cu̱u tucuꞌyón Salomón man noꞌ ado̱nj. Ne̱ xa̱ꞌ ꞌu̱nj si̱j nicu̱nꞌ rihaan soj cuano̱, tza̱j ne̱ sa̱ꞌ doj vaa ꞌu̱nj rihaan síí cuꞌna̱j Salomón yoꞌ ado̱nj. Tza̱j ne̱ naꞌvej rá soj cuno̱ soj nana̱ aꞌmii ꞌu̱nj rihaan soj a̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ne̱ nij síí ma̱n chumanꞌ Nínive roꞌ, canicu̱nꞌ nij soꞌ ga̱ maꞌa̱n soj si̱j vaa iꞌna̱ꞌ rihaan chumii̱ nihánj cuano̱ asa̱ꞌ quisíj güii caꞌne̱ꞌ Diose̱ cacunꞌ cheꞌé yuvii̱, ne̱ cuta̱ꞌ nij síí ma̱n chumanꞌ Nínive yoꞌ cacunꞌ xráá soj ado̱nj. Cuno nij soꞌ nana̱ caꞌmii natáj síí cuꞌna̱j Jonás, ne̱ nuchranꞌ nimán nij soꞌ, ne̱ canocoꞌ nij soꞌ man Diose̱ ado̱nj. Ne̱ xa̱ꞌ ꞌu̱nj si̱j nicu̱nꞌ rihaan soj cuano̱, tza̱j ne̱ sa̱ꞌ doj vaa ꞌu̱nj rihaan síí cuꞌna̱j Jonás yoꞌ, tza̱j ne̱ taj se qui̱ꞌyáꞌ naquiꞌya̱j sa̱ꞌ soj nimán soj maꞌ ―taj Jesucristó rihaan nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ne̱ cataj uún Jesucristó rihaan nij soꞌ a: ―Ga̱a rmi̱ꞌ, ne̱ a̱ ꞌó yuvii̱ ne utaꞌ yaꞌan raa̱ agaꞌ yaꞌan ne̱ axríj yuve̱ nij soꞌ rque ꞌo̱ chrúún maꞌ. Sese rmi̱ꞌ, ne̱ achrón nii yaꞌan raa̱ agaꞌ yaꞌan ne̱ utaꞌ nii agaꞌ yoꞌ rej xta̱ꞌ, ne̱ daj a̱ nij yuvii̱ atúj rá veꞌ roꞌ, chuguu̱n niꞌya̱j nij soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","”Rlij rihaan níꞌ me yaꞌan nica̱j yuꞌunj man níꞌ ei. Dan me se sese rlij rihaan níꞌ roꞌ, niꞌya̱j yoꞌ ne̱ uun sa̱ꞌ rá yoꞌ, ga̱a ne̱ nu̱ꞌ nee̱ man níꞌ roꞌ, sa̱ꞌ vaa, ne̱ adi̱ꞌ se chuguu̱n agaꞌ yaꞌan roꞌ, da̱nj chuguu̱n man níꞌ ga̱a sa̱ꞌ rihaan níꞌ ado̱nj. Tza̱j ne̱ sese rlij rihaan níꞌ roꞌ, niꞌya̱j yoꞌ ne̱ ina̱nj uun chiꞌi̱i̱ rá yoꞌ, ga̱a ne̱ nu̱ꞌ nee̱ man níꞌ roꞌ, uun chiꞌi̱i̱ rá, ga̱a ne̱ adi̱ꞌ síí nicu̱nꞌ yan rmi̱ꞌ ne̱ cunuda̱nj man soꞌ roꞌ, rmi̱ꞌ, ne̱ da̱nj vaa síí uun chiꞌi̱i̱ rá ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Xca̱j ndoꞌo soj cuentá se̱ gaa na̱nj quinaꞌa̱j yaꞌan nica̱j yuꞌunj man soj ne̱ gu̱un soj ꞌo̱ se rmi̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Dan me se sese cunuda̱nj man níꞌ nuû yaꞌan, ga̱a ne̱ taj a̱ doj se rmi̱ꞌ nu̱u̱ man níꞌ, ga̱a ne̱ cunuda̱nj man níꞌ roꞌ, chuguu̱n, ne̱ adi̱ꞌ ga̱a oꞌ cachu̱nꞌ yaꞌan xráá nii ne̱ chuguu̱n nu̱ꞌ man nii roꞌ, da̱nj vaa níꞌ ado̱nj ―taj Jesucristó rihaan nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Dan me se ga̱a caꞌmii Jesucristó rihaan nij yuvii̱, ne̱ canacúún ꞌo̱ síí fariseo man soꞌ cha̱ soꞌ chraa tucuá síí fariseo yoꞌ, ga̱a ne̱ dan me se caꞌanj ca̱yáán ro̱j soꞌ rihaan mesá a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Dan me se xcaj síí fariseo yoꞌ cuentá se vaa ne nocoꞌ Jesucristó se‑tucua̱nj nij síí fariseo se vaa ne naꞌyaꞌ soꞌ ga̱a cha̱ soꞌ chraa, ga̱a ne̱ caráyaꞌa̱nj ndoꞌo síí fariseo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Cheꞌé dan cataj síí ꞌni̱j raꞌa man níꞌ rihaan soꞌ: ―Xa̱ꞌ soj si̱j fariseo, tza̱j ne̱ ase vaa rasu̱u̱n, ne̱ sa̱ꞌ uxrá naꞌnuꞌ nii xráá yoꞌ, tza̱j ne̱ rque yoꞌ roꞌ, me se vaa nacaj gue̱e̱ yoꞌ, taꞌngaꞌ da̱nj vaa gue̱e̱ soj, ne̱ xráá soj me se veꞌé naruvi̱i̱, tza̱j ne̱ nimán soj me quij vaa, ne̱ niha̱ꞌ uxrá rá soj caꞌne̱e̱ soj siꞌyaj tuviꞌ soj, ne̱ noco̱ꞌ ndoꞌo soj chrej chiꞌi̱i̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nuveé si̱j acaj cuentá me soj a̱ maꞌ. Neꞌen soj se vaa Diose̱ roꞌ, me síí quiꞌyaj raꞌa soj, ne̱ naꞌyaꞌ ndoꞌo soj, ne̱ veé soꞌ me síí quiꞌyaj nimán soj uún a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Dan me se go̱ꞌ soj taꞌa̱j se chá do̱ꞌ, taꞌa̱j saꞌanj do̱ꞌ, man nij síí nique̱, ga̱a ne̱ xca̱j soj cuentá se vaa síí sa̱ꞌ nimán me soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","”Tza̱j ne̱ nique̱ soj si̱j fariseo na̱nj á. ꞌO̱ se quira̱nꞌ uxrá soj sayuun na̱nj ado̱nj. ꞌO̱ se sese vaa nuu xlá do̱ꞌ, coj ruda do̱ꞌ, me maꞌa̱n cuêj do̱ꞌ, rihaan soj, ne̱ rqué soj ꞌo̱ nánj rasu̱u̱n yoꞌ rihaan Diose̱ cheꞌé ꞌo̱ ꞌo̱ chi̱ꞌ nánj rasu̱u̱n vaa rihaan soj na̱nj á. Tza̱j ne̱ ne aꞌneꞌ nica̱ soj cacunꞌ cheꞌé tuviꞌ soj maꞌ. Ne aráj cochro̱j soj rihaan Diose̱ maꞌ. Tza̱j ne̱ me rá Diose̱ quiꞌya̱j soj nu̱ꞌ nana̱ noco̱o nihánj, ne̱ naꞌvej rá Diose̱ ta̱náj xco̱ soj yoꞌó nana̱ leꞌe̱j doj yoꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","”Nique̱ soj si̱j fariseo na̱nj á. Quira̱nꞌ uxrá nij soj sayuun ado̱nj. ꞌO̱ se niha̱ꞌ rá soj quita̱j soj chruun xlá sa̱ꞌ doj nicu̱nꞌ rá veꞌ tucuꞌyón níꞌ se‑tucua̱nj Moisés, ne̱ niha̱ꞌ rá soj cara̱yaꞌa̱nj yuvii̱ man soj ga̱a chéé soj yuꞌvee a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","”Nique̱ soj cheꞌé sayuun quira̱nꞌ soj á. Ne̱ ase vaa chraan na̱j xnangá rihaan santó roꞌ, vaa soj, ne̱ xráá soj roꞌ, vaa catzi̱i̱, tza̱j ne̱ nimán soj me se adi̱ꞌ se vaa cúú riꞌyuj roꞌ, vaa nimán soj ado̱nj. Ne̱ vaa chraan na̱j xnangá rihaan santó, ne̱ xráá yoꞌ me se sa̱ꞌ uxrá vaa yoꞌ, ne̱ rque yoꞌ me se cúú riꞌyuj ina̱nj ma̱n rque yoꞌ, ne̱ nij yuvii̱ me se chéé nij yuvii̱ yoꞌ xráá chraan, ne̱ taj nij soꞌ se vaa sa̱ꞌ ndoꞌo vaa chraan yoꞌ, taj nij soꞌ, tza̱j ne̱ ne neꞌen nij soꞌ se vaa ina̱nj cúú riꞌyuj ma̱n rque yoꞌ a̱ man ado̱nj. Taꞌngaꞌ da̱nj vaa gue̱e̱ soj ado̱nj ―taj Jesucristó rihaan nij síí fariseo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ga̱a ne̱ caꞌmii ꞌo̱ síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱, ne̱ cataj soꞌ rihaan Jesucristó a: ―Tza̱j ne̱ nachríꞌ so̱ꞌ niꞌya̱j so̱ꞌ man maꞌa̱n núj ga̱a aꞌmii so̱ꞌ nana̱ vaa da̱nj á ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Ne̱ nique̱ maꞌa̱n soj si̱j naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ a. Maꞌa̱n soj uún quira̱nꞌ uxrá sayuun na̱nj ado̱nj. ꞌO̱ se aꞌneꞌ uxrá soj suun rihaan yuvii̱ da̱j quiꞌya̱j nij yuvii̱ canoco̱ꞌ nij yuvii̱ man Diose̱, tza̱j ne̱ dan me se ase vaa yuvii̱ araa ndoꞌo rasu̱u̱n ꞌe̱e̱ xráá tuviꞌ vaa nij soj, ne̱ a̱ doj ne racuíj soj man yuvii̱ ca̱ta̱ yuvii̱ rasu̱u̱n ꞌe̱e̱ yoꞌ a̱ maꞌ. A̱ ꞌó raa̱ raꞌa nij soj ne racuíj soj man yuvii̱ a̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","”Nique̱ soj cheꞌé sayuun quira̱nꞌ soj a. Veꞌé uneꞌ soj chraan yan na̱j cúú man nij síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá, tza̱j ne̱ maꞌa̱n xi̱i soj roꞌ, me síí ticaviꞌ man nij soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Dan me se cheꞌé se neꞌen níꞌ se vaa ꞌyaj maꞌa̱n soj, ne̱ cheꞌé dan xcaj níꞌ cuentá se vaa ꞌo̱ vaa rá soj ga̱ xi̱i soj síí ma̱n ga̱a naá, ne̱ cuya̱a̱n ꞌyaj soj ga̱ xi̱i soj ado̱nj. Dan me se nij soꞌ roꞌ, ticaviꞌ man nij síí nataꞌ se‑na̱na̱ Diose̱, ne̱ soj roꞌ, uneꞌ chraan yan na̱j cúú man nij soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","”Cheꞌé dan cavii ꞌo̱ nana̱ cu̱u raa̱ Diose̱, cataj Diose̱: “Xa̱ꞌ yuvii̱ nihánj, tza̱j ne̱ caꞌne̱j ꞌu̱nj síí nata̱ꞌ se‑na̱na̱j rihaan nij soꞌ a. Dan me se ticavi̱ꞌ nij soꞌ man taꞌa̱j nij síí caꞌne̱j ꞌu̱nj, ne̱ yoꞌó taꞌa̱j nij soꞌ me se me rej maꞌa̱n vaj nij soꞌ, ne̱ quita̱j riꞌyunj uxrá nij soꞌ man nij síí caꞌne̱j a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nda̱a síj, ga̱a ne̱ nu̱ꞌ ton cayanj man nij síí nataꞌ se‑na̱na̱ Diose̱ asi̱j ga̱a guun cheꞌe̱ chumii̱ roꞌ, nu̱ꞌ cacunꞌ yoꞌ roꞌ, nata̱ꞌ xráá nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Dan me se asi̱j ton cayanj man síí cuꞌna̱j Abel ne̱ nda̱a ton cayanj man síí cuꞌna̱j Zacarías ga̱a caviꞌ soꞌ rihaan nuvií yan nicu̱nꞌ mesá altar xi̱j roꞌ, nu̱ꞌ cacunꞌ yoꞌ roꞌ, nata̱ꞌ xráá nij soꞌ a”, taj Diose̱ a. Dan me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa quira̱nꞌ maꞌa̱n nij tuvi̱ꞌ nij soj sayuun cheꞌé nu̱ꞌ cacunꞌ yoꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","”Nique̱ soj si̱j naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ a. Quira̱nꞌ uxrá soj sayuun ado̱nj. Taj se qui̱ꞌyáꞌ xca̱j yuvii̱ cuentá, ꞌyaj soj maꞌ. Dan me se maꞌa̱n soj roꞌ, naꞌvej rá catu̱u̱ se‑tucua̱nj Diose̱, ne̱ nij síí me rá catu̱u̱ me se aráán soj chrej rihaan nij soꞌ, ne̱ naꞌvej rá soj catu̱u̱ nij soꞌ a̱ man ado̱nj ―taj Jesucristó rihaan nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Dan me se curiha̱nj Jesucristó veꞌ yoꞌ, ne̱ guun cheꞌe̱ nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés do̱ꞌ, nij síí fariseo do̱ꞌ, táá riꞌyunj uxrá nij soꞌ man Jesucristó, ne̱ guun cheꞌe̱ nij soꞌ xnáꞌanj nij soꞌ man soꞌ cheꞌé queꞌe̱e̱ rasu̱u̱n a. ");
INSERT INTO trcNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Dan me se nanó xre̱j uxrá nij soꞌ nana̱ caꞌmii Jesucristó cheꞌé rej guun ndoꞌo rá nij soꞌ cuta̱ꞌ nij soꞌ cacunꞌ xráá Jesucristó cheꞌé nana̱ tuꞌva soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Dan me se cunuu chre̱ꞌ uxrá yuvii̱ rej va̱j Jesucristó, ne̱ uxrá chru̱j nij soꞌ, ne̱ nda̱a tiguíj tuviꞌ maꞌa̱n nij soꞌ a. Ga̱a ne̱ guun cheꞌe̱ Jesucristó caꞌmii soꞌ asino ya̱a̱n ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ, cataj soꞌ: ―Cu̱tumé soj man soj se̱ gaa na̱nj quira̱nꞌ soj sayuun, quiꞌya̱j se‑le̱vadura nij síí fariseo á. Dan me se taj nij soꞌ, ne̱ ina̱nj nana̱ sa̱ꞌ aꞌmii nij soꞌ, taj nij soꞌ, tza̱j ne̱ taj maꞌ. Tuꞌva rmaꞌa̱n nij soꞌ na̱nj ado̱nj. Nuveé na̱na̱ sa̱ꞌ aꞌmii nij soꞌ maꞌ. Ina̱nj nana̱ nucuiꞌ rá aꞌmii nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tza̱j ne̱ dan me se nu̱ꞌ nana̱ caꞌmii yuve̱ nij soꞌ do̱ꞌ, nu̱ꞌ rasu̱u̱n ꞌyaj yuve̱ nij soꞌ do̱ꞌ, nu̱ꞌ yoꞌ roꞌ, nu̱riha̱nj queneꞌe̱n cunuda̱nj yuvii̱ vaa güii ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Cheꞌé dan nu̱ꞌ nana̱ caꞌmii soj rej rmi̱ꞌ roꞌ, vaa güii nu̱riha̱nj yoꞌ rej chuguu̱n, ne̱ nu̱ꞌ nana̱ caꞌmii soj xréé tuviꞌ soj rej rá veꞌ, ne̱ nu̱riha̱nj yoꞌ vaa güii nda̱a patio rihaan veꞌ ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ga̱a ne̱ cataj uún Jesucristó a: ―Dan me se tuvíꞌ ꞌu̱nj me soj, ne̱ cheꞌé dan cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa se̱ cuchuꞌviꞌ soj queneꞌe̱n soj nij síí ticavi̱ꞌ man nee̱ man soj maꞌ. ꞌO̱ se asa̱ꞌ quiꞌyaj nij soꞌ da̱nj, ga̱a ne̱ taj va̱j doj se chiꞌi̱i̱ quiꞌya̱j nij soꞌ man soj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tza̱j ne̱ nihánj me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj me síí cuchuꞌvi̱ꞌ soj ni̱ꞌyaj soj man a. Dan me se vaa cheꞌé cuchuꞌvi̱ꞌ soj ni̱ꞌyaj soj Diose̱ ado̱nj. Asa̱ꞌ quisíj ticaviꞌ nii man soj, ga̱a ne̱ soꞌ me síí caꞌne̱j man soj rihaan yaꞌan caca̱a̱ soj sese tumé soj cacunꞌ ado̱nj. Cheꞌé dan taj ꞌu̱nj rihaan soj se vaa vaa cheꞌé cuchuꞌvi̱ꞌ soj ni̱ꞌyaj soj man soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","”Neꞌen soj da̱j vaa nij xtâj chri̱nꞌ se vaa ꞌu̱nꞌ ya̱ xoꞌ nó chi̱ꞌ gue̱e̱ chaꞌaa a. Tza̱j ne̱ taj yaꞌanj uxrá Diose̱ man ꞌo̱ ꞌo̱ nij xoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ne̱ Diose̱ me se vaa cuentá yuvé raa̱ soj ꞌyaj soꞌ, ne̱ neꞌen soꞌ me daj yuvé raa̱ soj, ne̱ cheꞌé dan se̱ cuchuꞌviꞌ soj cheꞌé sayuun quiꞌya̱j yuvii̱ man soj maꞌ. ꞌO̱ se uxrá vaa yuꞌvee doj nó soj rihaan xtâj chri̱nꞌ yoꞌ, ꞌyaj Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ne̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa no̱ xcúún soj nata̱ꞌ ya̱ soj rihaan yuvii̱ se vaa me soj síí noco̱ꞌ manj, ne̱ nu̱ꞌ síí ꞌyaj da̱nj roꞌ, vaa güii, ne̱ ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ roꞌ, nata̱j rihaan nij se‑mo̱zó Diose̱ se vaa si̱j noco̱ꞌ manj me soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ne̱ síí taj xnaꞌanj rihaan yuvii̱ se vaa nuveé si̱j noco̱ꞌ manj me soꞌ roꞌ, vaa güii, ne̱ cata̱j xnaꞌanj yá ꞌu̱nj rihaan nij se‑mo̱zó Réé ꞌu̱nj se vaa nuveé si̱j noco̱ꞌ manj me soꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","”Dan me se ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ roꞌ, caꞌve̱e se caꞌmi̱i̱ yoꞌo̱ soꞌ nana̱ chiꞌi̱i̱ cheꞌej, ne̱ caꞌve̱e navi̱j cacunꞌ xráá soꞌ quiꞌya̱j Diose̱, tza̱j ne̱ sese caꞌmi̱i̱ chiꞌi̱i̱ yoꞌo̱ soꞌ cheꞌé Nimán Diose̱, ne̱ daj chiha̱a̱ míj se̱ tinavij Diose̱ cacunꞌ yoꞌ xráá soꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","”Dan me se asa̱ꞌ tucuatúj nii man soj rá veꞌ tucuꞌyón níꞌ si̱j israelitá se‑tucua̱nj Moisés ne̱ canicu̱nꞌ soj rihaan nij síí uun chij, ne̱ se̱ nanó rá soj da̱j caꞌmi̱i̱ soj cheꞌé soj rihaan nij soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ꞌO̱ se orá yoꞌ roꞌ, maꞌa̱n Nimán Diose̱ roꞌ, tu̱cuꞌyón man soj da̱j caꞌmi̱i̱ soj rihaan nij soꞌ ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Dan me se cataj yoꞌo̱ tuviꞌ nij yuvii̱ yoꞌ rihaan Jesucristó a: ―Cata̱j so̱ꞌ rihaan tinúú ꞌu̱nj, ne̱ cuxra̱ꞌ taꞌa̱j soꞌ yoꞌóó do̱ꞌ, rasu̱u̱n do̱ꞌ, ga̱j, maestro ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ga̱a ne̱: ―Me cheꞌé guun rá so̱ꞌ se vaa guún ꞌu̱nj síí aꞌneꞌ cacunꞌ cheꞌé soj ga̱. Me cheꞌé caꞌmi̱i̱ ꞌu̱nj cheꞌé rasu̱u̱n vaa rihaan ro̱j tinu̱j soj, rá so̱ꞌ, ga̱ tinu̱ꞌ ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ga̱a ne̱ cataj Jesucristó rihaan nij yuvii̱ a: ―Tu̱mé uxrá soj man soj rihaan nij rasu̱u̱n xco̱j ruva̱a̱ rá a. Nuveé ra̱su̱u̱n ma̱n rihaan níꞌ quiꞌya̱j cavi̱i̱ sa̱ꞌ nimán níꞌ maꞌ ―taj Jesucristó rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ga̱a ne̱ dan me se nanó Jesucristó ꞌo̱ se‑cuento̱ ꞌo̱ síí ruꞌvee rihaan nij yuvii̱ a: ―ꞌO̱ síí ruꞌvee me ꞌo̱ soꞌ, ne̱ cavii ndoꞌo xnaa̱ soꞌ, ne̱ ma̱n ndoꞌo rasu̱u̱n rihaan soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ne̱ dan me se taj soꞌ: “A̱ me se qui̱ꞌyáj ga̱ rasu̱u̱n ma̱n rihanj ne̱ taj rej ca̱raj man rasu̱u̱n yoꞌ ga̱”, taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ga̱a ne̱: “Aan a. A̱j neꞌenj me se qui̱ꞌyáj á. Tu̱cuanee ꞌu̱nj man nij cuchruu̱ nii, ne̱ qui̱ꞌyáj doj veꞌ xi̱j, ne̱ yoꞌo̱ cara̱a chre̱ꞌ ꞌu̱nj man nij rasu̱u̱n, ne̱ ti̱navii ꞌu̱nj man nij yoꞌ rá nij veꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ga̱a ne̱ cata̱j ꞌu̱nj rihaan nimanj se vaa ma̱n ndoꞌo rasu̱u̱n rihaan níꞌ cha̱ níꞌ, ne̱ se̱ nanó rá níꞌ, ma̱a̱n se veꞌé cha̱ níꞌ do̱ꞌ, veꞌé coꞌo̱ níꞌ do̱ꞌ, veꞌé ca̱yáán níꞌ do̱ꞌ, veꞌé coto̱j níꞌ do̱ꞌ a. Da̱nj cata̱j rihaan nimanj cheꞌé nij rasu̱u̱n cuma̱n rihanj”, taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tza̱j ne̱ Diose̱ caꞌmii rihaan soꞌ, cataj Diose̱: “Síí niꞌyo̱n mé so̱ꞌ á. ꞌO̱ se nii̱ corá me se cavi̱ꞌ so̱ꞌ, ne̱ xa̱ꞌ rasu̱u̱n caraa sa̱ꞌ so̱ꞌ, tza̱j ne̱ me se gu̱un yoꞌ rihaan so̱ꞌ, rá so̱ꞌ ga̱”, taj Diose̱ rihaan ruꞌvee yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Da̱nj quira̱nꞌ síí araa sa̱ꞌ rasu̱u̱n cheꞌé maꞌa̱n da̱nj, ne̱ taj va̱j a̱ doj rasu̱u̱n sa̱ꞌ nica̱j soꞌ, niꞌya̱j Diose̱ a̱ maꞌ ―taj Jesucristó rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ga̱a ne̱ cataj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a: ―Cheꞌé dan cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa taj cheꞌé nano̱ ndoꞌo rá soj cheꞌé soj maꞌ. Ne̱ cheꞌé se cha̱ soj do̱ꞌ, ne̱ cheꞌé yan quiri̱ꞌ soj se ca̱ráán xráá soj se̱ nanó rá soj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","A̱j neꞌen soj se vaa a̱j vaa iꞌna̱ꞌ soj, quiꞌyaj Diose̱, ne̱ se̱ guun nucua̱j Diose̱ rque̱ Diose̱ cha̱ soj, rá soj ga̱a̱ a̱ naꞌ. Daj chiha̱a̱ míj se̱ guun da̱nj rá soj maꞌ. Ne̱ Diose̱ me síí caꞌve̱e rque̱ se cha̱ soj ei. Ne̱ Diose̱ me síí quiꞌyaj nee̱ man soj, ne̱ se̱ guun nucua̱j Diose̱ rque̱ Diose̱ yatzíj ca̱ráán xráá soj, rá soj ga̱a̱ a̱ naꞌ. Daj chiha̱a̱ míj se̱ guun da̱nj rá soj maꞌ. Ne̱ Diose̱ me síí caꞌve̱e rque̱ se ca̱ráán xráá soj ei. ");
INSERT INTO trcNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","”Xca̱j soj cuentá da̱j ꞌyaj nij xcaa, ne̱ ne unô nij xoꞌ ꞌnúú, ne̱ ne rii nij xoꞌ naa̱, ne̱ taj se‑cuchru̱u̱ nij xoꞌ, tza̱j ne̱ Diose̱ roꞌ, rqué se chá nij xoꞌ ado̱nj. Ne̱ sa̱ꞌ doj vaa soj rihaan xcaa niꞌya̱j Diose̱ ado̱nj. Ya̱ sa̱ꞌ doj vaa soj chugua̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ne̱ nda̱ꞌ se nanó ndoꞌo rá soj cheꞌé yan chre̱ꞌ vaa soj, tza̱j ne̱ a̱ ꞌó xcoꞌ se̱ guun nucua̱j soj cachi̱j xca̱a̱n soj doj quiꞌya̱j maꞌa̱n soj maꞌ. Ma̱a̱n se Diose̱ roꞌ, me síí neꞌen da̱j ga̱a̱ cachi̱j soj, ne̱ cheꞌé dan taj cheꞌé nano̱ rá soj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Dan me se sese se̱ caꞌvee quiꞌya̱j soj rasu̱u̱n leꞌe̱j doj, ne̱ asa̱ꞌ caꞌve̱e quiꞌya̱j soj rasu̱u̱n noco̱o doj, rá soj ga̱. Cheꞌé dan taj cheꞌé nano̱ ndoꞌo rá soj cheꞌé nij rasu̱u̱n noco̱o doj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","”ꞌO̱ se xca̱j soj cuentá ni̱ꞌyaj soj nij yâj se vaa veꞌé ndoꞌo vaa nij yâj a. Ne ꞌyaj suun nij yâj, tza̱j ne̱ maꞌa̱n Diose̱ roꞌ, me síí sa̱ꞌ ndoꞌo vaa quiꞌyaj man nij yâj ado̱nj. Ne̱ ne rii nij yâj yuꞌvej maꞌ. Tza̱j ne̱ adi̱ꞌ se vaa síí rii yuꞌvej ne̱ sa̱ꞌ uxrá vaa saga̱nꞌ soꞌ roꞌ, vaa nij yatzíj nu̱u̱ nij yâj ado̱nj. Dan me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa síí cuꞌna̱j Salomón síí cane ga̱a naá, ne̱ veꞌé uxrá vaa yatzíj nu̱u̱ soꞌ, quiꞌyaj cunuda̱nj saꞌanj vaa rihaan soꞌ, tza̱j ne̱ nij doj vaa yatzíj nu̱u̱ soꞌ rihaan nij yâj ma̱n tacaan yoꞌ, quiꞌyaj Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Dan me se da̱nj na̱nj nij yâj ma̱n tacaan yoꞌ, tza̱j ne̱ sa̱ꞌ uxrá vaa nij yatzíj nu̱u̱ nij yâj yoꞌ, ꞌyaj Diose̱, tza̱j ne̱ aꞌyuj caꞌne̱ꞌ nii man nu̱ꞌ coj do̱ꞌ, yâj do̱ꞌ, ne̱ cara̱a nii man yoꞌ rihaan yaꞌan, ne̱ caca̱a̱ nu̱ꞌ nij yâj yoꞌ na̱nj ado̱nj. Ne̱ a̱ doj yuꞌvee taj nó yâj yoꞌ a̱ maꞌ. Táá a̱ soj yuvi̱i̱, ne̱ se̱ nanó rá soj maꞌ. Diose̱ me síí rque̱ saga̱nꞌ soj ado̱nj. Tza̱j ne̱ ne gu̱un ya̱ sa̱ꞌ rá soj se vaa Diose̱ me síí ra̱cuíj ya̱ man soj man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","”Ne̱ xa̱ꞌ soj, tza̱j ne̱ se̱ nanoꞌ ndoꞌo soj se cha̱ soj do̱ꞌ, se coꞌo̱ soj do̱ꞌ maꞌ. Ne̱ se̱ nanó ndoꞌo rá soj cheꞌé nij yoꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ꞌO̱ se nij síí ma̱n rihaan chumii̱ nihánj síí ne neꞌen da̱j vaa Diose̱ roꞌ, ina̱nj ꞌyaj suun ndoꞌo nij soꞌ cheꞌé rasu̱u̱n ma̱n rihaan chumii̱ nihánj ado̱nj. Tza̱j ne̱ nu̱ꞌ rasu̱u̱n achiin man soj roꞌ, a̱j neꞌen Rej soj Diose̱ se vaa achiin rasu̱u̱n yoꞌ man soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Tza̱j ne̱ nano̱ꞌ soj rej da̱j quiꞌya̱j soj, ne̱ gu̱un chij Diose̱ nimán soj, ga̱a ne̱ rque̱ Diose̱ rasu̱u̱n yoꞌ rihaan soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","”Se̱ cuchuꞌviꞌ soj maꞌ. Ase vaa daán Diose̱ matzinj vaa soj, ne̱ Diose̱ tumé man soj, ne̱ a̱j guun rá Rej soj Diose̱ se vaa gu̱un chij soj rihaan chumii̱ nihánj ga̱ soꞌ vaa güii a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","”Cutuꞌve̱e̱ soj siꞌyaj soj, ne̱ go̱ꞌ soj saꞌanj man nij síí nique̱ á. Ga̱a ne̱ vaa güii quiri̱ꞌ soj ꞌo̱ nanj caraa nu̱ꞌ saꞌanj rque, ne̱ xa̱ꞌ nanj yoꞌ, tza̱j ne̱ daj chiha̱a̱ míj se̱ xtuu̱ nanj yoꞌ, ne̱ xa̱ꞌ saꞌanj yoꞌ, tza̱j ne̱ daj chiha̱a̱ míj se̱ navij saꞌanj yoꞌ a. Yoꞌ me se quiri̱ꞌ soj rej xta̱ꞌ, ne̱ rej xta̱ꞌ roꞌ, taj va̱j síí itu̱u̱ maꞌ. Ne̱ taj va̱j xlúú chá rasu̱u̱n maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ne̱ sese ina̱nj cheꞌé rasu̱u̱n ma̱n rihaan chumii̱ nihánj quiꞌya̱j suun soj, ga̱a ne̱ veé ma̱a̱n rihaan chumii̱ nihánj quina̱j nimán soj ga̱a̱ na̱nj ado̱nj. Ne̱ sese ina̱nj cheꞌé rasu̱u̱n ma̱n xta̱ꞌ roꞌ, quiꞌya̱j suun soj, ga̱a ne̱ veé rej xta̱ꞌ roꞌ, caꞌa̱nj nimán soj na̱nj ado̱nj. Me rej maꞌa̱n araa soj rasu̱u̱n, ne̱ veé rej da̱nj vaj nimán soj na̱nj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ne̱ cataj uún Jesucristó rihaan nij soꞌ a: ―Ase vaa síí ꞌni̱j raan nuj catuu̱n roꞌ, da̱nj ga̱a̱ soj ei. Ase vaa síí nica̱j agaꞌ chuguu̱n acoꞌ yaꞌan roꞌ, da̱nj ga̱a̱ soj ei. ");
INSERT INTO trcNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Dan me se quiꞌya̱j soj nda̱a vaa ꞌyaj mozó naꞌvi̱j soꞌ nama̱n se‑ruꞌve̱e̱ soꞌ ga̱a caꞌanj se‑ruꞌve̱e̱ soꞌ chaꞌanj naraꞌa̱a ei. Dan me se asa̱ꞌ namán ruꞌvee ne̱ nu̱ꞌ ta̱raꞌa soꞌ taꞌyaa, ne̱ nu̱ꞌ caꞌnu̱u̱ mozó yoꞌ taꞌyaa, ga̱a ne̱ gu̱un niha̱ꞌ rá se‑ruꞌve̱e̱ mozó yoꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ne̱ cavi̱i̱ sa̱ꞌ uxrá nij mozó ꞌyaj da̱nj, cheꞌé se ne coto̱j nij soꞌ ga̱a namán se‑ruꞌve̱e̱ nij soꞌ a. Dan me se queneꞌe̱n ya̱ soꞌ se vaa ne coto̱j nij soꞌ maꞌ. Cata̱j yá ꞌu̱nj rihaan soj cuano̱ se vaa maꞌa̱n ruꞌvee yoꞌ roꞌ, naquiꞌya̱j sa̱ꞌ soꞌ man soꞌ, ca̱yáán se‑mo̱zó soꞌ rihaan mesá, quiꞌya̱j soꞌ, ne̱ quiꞌya̱j chuvi̱i maꞌa̱n soꞌ cha̱ nij se‑mo̱zó soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Dan me se caꞌve̱e se rej ya̱nꞌ nama̱n soꞌ niꞌ, caꞌve̱e se rej taxre̱j nama̱n soꞌ niꞌ, tza̱j ne̱ a̱j neꞌen soꞌ se vaa veꞌé ina̱nj naꞌvi̱j nij mozó yoꞌ man soꞌ, ne̱ cavi̱i̱ sa̱ꞌ uxrá nij mozó yoꞌ ado̱nj. Cheꞌé dan quiꞌya̱j soj nda̱a vaa ꞌyaj nij mozó yoꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Dan me se sese ꞌo̱ síí tucua̱ veꞌ roꞌ, a̱j neꞌen soꞌ me orá caꞌna̱ꞌ síí itu̱u̱ ne̱ quiꞌya̱j itu̱u̱ síí itu̱u̱ rasu̱u̱n ma̱n tucuá soꞌ, ne̱ uxrá cu̱tumé soꞌ tucuá soꞌ, ne̱ se̱ quiꞌyaj itu̱u̱ síí itu̱u̱ tucuá soꞌ tza̱j maꞌ. Ma̱a̱n se ne neꞌen soꞌ me orá caꞌna̱ꞌ síí itu̱u̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Dan me se taꞌngaꞌ da̱nj vaa gue̱e̱ ꞌu̱nj si̱j nica̱j yuꞌunj man yuvii̱, ne̱ ne neꞌen soj me orá caꞌna̱ꞌ uún ꞌu̱nj man ado̱nj. Cheꞌé dan yoꞌo̱ ni̱ꞌyaj soj á ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ga̱a ne̱ xnáꞌanj síí cuꞌna̱j Pedró man Jesucristó, cataj soꞌ a: ―Señor. Cheꞌé maꞌa̱n núj me nanó so̱ꞌ cuentó yoꞌ naꞌ. Ase cheꞌé cunuda̱nj yuvii̱ xa̱ꞌ ―taj Pedró, xnáꞌanj soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ga̱a ne̱ cataj síí ꞌni̱j raꞌa man níꞌ a: ―Cheꞌé dan me sese cuneꞌ síí tucua̱ yoꞌo̱ veꞌ man yoꞌo̱ se‑mo̱zó soꞌ se vaa cu̱tumé mozó yoꞌ man tuviꞌ mozó rque̱ soꞌ se chá rihaan nij soꞌ orá chá nij soꞌ chraa, ne̱ da̱j quiꞌya̱j mozó yoꞌ, rá soj ga̱. Sese ya̱ ya̱ si̱j veꞌé ꞌyaj suun me soꞌ do̱ꞌ, sese ya̱ ya̱ si̱j avii raa̱ me soꞌ do̱ꞌ, ne̱ da̱j quiꞌya̱j soꞌ, rá soj ga̱. ");
INSERT INTO trcNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ga̱a ne̱ güii nama̱n se‑ruꞌve̱e̱ mozó roꞌ, sese queneꞌe̱n se‑ruꞌve̱e̱ mozó se vaa veꞌé ꞌyaj suun mozó se‑su̱u̱n ruꞌvee, ne̱ cavi̱i̱ sa̱ꞌ uxrá mozó yoꞌ, quiꞌya̱j se‑ruꞌve̱e̱ mozó yoꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa cune̱ꞌ ruꞌvee yoꞌ man mozó yoꞌ gu̱un soꞌ síí tumé man cunuda̱nj siꞌyaj ruꞌvee yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tza̱j ne̱ sese gu̱un rá mozó yoꞌ se vaa guun ra̱a̱n ndoꞌo se‑ruꞌve̱e̱ soꞌ, ga̱a ne̱ gu̱un cheꞌe̱ soꞌ go̱ꞌ soꞌ man yoꞌó nij mozó do̱ꞌ, man nij mozó cha̱na̱ do̱ꞌ, ne̱ cha̱ soꞌ coꞌo̱ soꞌ ne̱ gu̱un xno̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Dan me se ne neꞌen soꞌ aman nama̱n se‑ruꞌve̱e̱ soꞌ a. Ne naꞌvi̱j soꞌ caꞌna̱ꞌ ruꞌvee a. Tza̱j ne̱ síj güii síj orá síj, ne̱ caꞌna̱ꞌ maꞌa̱n se‑ruꞌve̱e̱ mozó yoꞌ, ga̱a ne̱ caꞌne̱ꞌ nu̱ꞌ soꞌ man mozó yoꞌ, ne̱ cata̱j soꞌ se vaa caꞌa̱nj mozó yoꞌ rihaan yaꞌan ga̱ yoꞌó nij síí ne amán rá niꞌya̱j man Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","”Dan me se xa̱ꞌ mozó neꞌen da̱j me rá se‑ruꞌve̱e̱ soꞌ quiꞌya̱j soꞌ, tza̱j ne̱ sese se̱ quiꞌyaj soꞌ da̱nj, ne̱ quiꞌya̱j soꞌ ina̱nj se vaa rii nimán maꞌa̱n soꞌ quiꞌya̱j soꞌ, ne̱ cayu̱u̱n uxrá soꞌ vaa güii ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ne̱ xa̱ꞌ síí ne neꞌen da̱j me rá se‑ruꞌve̱e̱ soꞌ quiꞌya̱j soꞌ, ne̱ quiꞌyaj soꞌ rasu̱u̱n naꞌvej rá se‑ruꞌve̱e̱ soꞌ quiꞌya̱j soꞌ, tza̱j ne̱ ma̱a̱n cheꞌé se ne neꞌen soꞌ ne̱ quiꞌyaj soꞌ rasu̱u̱n chiꞌi̱i̱ roꞌ, ma̱a̱n cheꞌé dan do̱j cayu̱u̱n soꞌ ado̱nj. ”Ne̱ síí ata̱ suun noco̱o doj ꞌyaj Diose̱ roꞌ, doj a̱ gu̱un rá Diose̱ quiꞌya̱j suun soꞌ a. Ne̱ síí tumé doj rasu̱u̱n cheꞌé Diose̱ roꞌ, doj a̱ ga̱a̱ rasu̱u̱n nachi̱nꞌ Diose̱ rihaan soꞌ na̱nj ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ga̱a ne̱ cataj uún Jesucristó a: ―Caꞌnáꞌ ꞌu̱nj rihaan chumii̱ nihánj cheꞌé rej guun rá ꞌu̱nj ta̱cuacoj yaꞌan nimán yuvii̱, ne̱ gu̱un niha̱ꞌ rá nij yuvii̱ canoco̱ꞌ nij yuvii̱ man Diose̱ ado̱nj. Ne̱ me ndoꞌo raj se vaa raꞌya̱nj caco̱ꞌ yaꞌan yoꞌ nimán nij yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tza̱j ne̱ rej rihaan níꞌ me se vaa uxrá sayuun qui̱ránꞌ ꞌu̱nj, se vaa nata̱ꞌ nu̱ꞌ sayuun yoꞌ xráj na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Dan me se caꞌnáꞌ ꞌu̱nj cheꞌé rej dínj doj ca̱yáán nij yuvii̱ ma̱n rihaan chumii̱ nihánj ga̱ tuviꞌ yuvii̱, rá soj naꞌ. Taj maꞌ. Cuano̱ nihánj me cata̱j ꞌu̱nj rihaan soj se vaa caꞌnáꞌ ꞌu̱nj cheꞌé rej nata̱ꞌ ꞌu̱nj se‑na̱na̱j rihaan yuvii̱, tza̱j ne̱ se̱ cuno cunuda̱nj nij yuvii̱ rihanj maꞌ. Cheꞌé dan cunu̱ꞌ yuvii̱ ga̱ tuviꞌ yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Dan me se rej rihaan níꞌ me se, sese ca̱yáán ꞌu̱nꞌ yuvii̱ rá ꞌo̱ veꞌ, ne̱ cunu̱ꞌ vaꞌnu̱j nij soꞌ ga̱ yavíj nij soꞌ, ne̱ cunu̱ꞌ vi̱j nij soꞌ ga̱ yaꞌnúj nij soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Dan me se cunu̱ꞌ snóꞌo ga̱ taꞌnij sno̱ꞌo soꞌ, ne̱ cunu̱ꞌ taꞌnij sno̱ꞌo soꞌ ga̱ maꞌa̱n soꞌ, ne̱ cunu̱ꞌ chana̱ ga̱ taꞌnij cha̱na̱ noꞌ, ne̱ cunu̱ꞌ taꞌnij cha̱na̱ noꞌ ga̱ maꞌa̱n noꞌ ado̱nj. Ne̱ cunu̱ꞌ chana̱ ga̱ choco̱ꞌ noꞌ, ne̱ cunu̱ꞌ choco̱ꞌ noꞌ ga̱ maꞌa̱n noꞌ, cheꞌé se‑na̱na̱j ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ga̱a ne̱ cataj Jesucristó rihaan nij yuvii̱ a: ―Dan me se soj me se sa̱ꞌ uxrá neꞌen soj xca̱j soj cuentá ado̱nj. Nu̱ꞌ neꞌen soj se vaa ga̱a avii ngaa rej ataꞌ güii, ne̱ nu̱ꞌ taj soj se vaa cama̱nꞌ uxrá maa̱n, taj soj, ne̱ veé da̱nj ꞌyaj gue̱e̱ xa̱ꞌ maa̱n, ne̱ amanꞌ ndoꞌo yoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ne̱ nu̱ꞌ neꞌen uún soj se vaa avii nana̱ yuva̱a̱ rej rque̱ rej sur, ne̱ nu̱ꞌ taj soj se vaa da̱j doj caꞌna̱ꞌ ndoꞌo cachiꞌ taj soj, ne̱ veé da̱nj ꞌyaj xa̱ꞌ cachiꞌ, ne̱ maan ndoꞌo na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Dan me se xa̱ꞌ soj si̱j nucuiꞌ rá me se síí sa̱ꞌ me soj taj soj, tza̱j ne̱ tuꞌva rmaꞌa̱n soj na̱nj ado̱nj. ꞌO̱ se neꞌen soj xca̱j soj cuentá cheꞌé se vaa rihaan chumii̱ do̱ꞌ, cheꞌé se vaa rej xta̱ꞌ do̱ꞌ, tza̱j ne̱ ne neꞌen soj xca̱j soj cuentá cheꞌé sayuun quira̱nꞌ soj si̱j ma̱n rihaan chumii̱ nihánj vaa güii maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","”Ne̱ me cheꞌé naꞌvee xca̱j maꞌa̱n soj cuentá cheꞌé se vaa no̱ xcúún soj quiꞌya̱j maꞌa̱n soj ga̱. ");
INSERT INTO trcNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ne̱ so̱ꞌ me se sese vaa síí me rá cuta̱ꞌ cacunꞌ xráá so̱ꞌ rihaan nij síí nica̱j suun, ne̱ ga̱a tiha̱j vaj so̱ꞌ chrej ga̱ soꞌ, ne̱ veꞌé caꞌmi̱i̱ so̱ꞌ ga̱ soꞌ, cata̱j so̱ꞌ rihaan soꞌ se vaa: “Caꞌne̱ꞌ rá so̱ꞌ, ne̱ se̱ cutáꞌ so̱ꞌ cacunꞌ xráj maꞌ”, cata̱j so̱ꞌ, ne̱ veꞌé caꞌmi̱i̱ so̱ꞌ ga̱ soꞌ ei. Ne̱ sese se̱ quiꞌyáá so̱ꞌ da̱nj caꞌmi̱i̱ sa̱ꞌ so̱ꞌ ga̱ soꞌ ga̱a tiha̱j vaj ro̱j so̱j chrej rihaan chumii̱ nihánj, ne̱ ni̱caj soꞌ mán so̱ꞌ caꞌa̱nj soꞌ rihaan cuese̱, ne̱ cuese̱ yoꞌ roꞌ, ta̱cuachén mán so̱ꞌ raꞌa síí tumé tagaꞌ, ne̱ soꞌ me síí caxri̱i̱ tagaꞌ mán so̱ꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ne̱ yoꞌ me se gu̱un ra̱a̱n ndoꞌo so̱ꞌ, ne̱ nda̱a navij na̱ruꞌvee so̱ꞌ nu̱ꞌ cacunꞌ quiꞌyáá so̱ꞌ, ga̱a ne̱ cu̱riha̱nj so̱ꞌ tagaꞌ na̱nj ado̱nj ―taj Jesucristó rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Güii dan me se mán taꞌa̱j nij yuvii̱, ne̱ nataꞌ nij soꞌ rihaan Jesucristó cheꞌé da̱j quiranꞌ taꞌa̱j nij síí ma̱n estadó Galilea ga̱a mán nij soꞌ ticaviꞌ nij soꞌ xcuu rihaan Diose̱ ga̱a ne̱ curiha̱nj nij tanuu ꞌyaj suun rihaan síí cuꞌna̱j Pilato, ne̱ ticaviꞌ nij tanuu man nij síí ma̱n estadó Galilea yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ga̱a ne̱ canica̱j Jesucristó cataj soꞌ rihaan nij yuvii̱ nataꞌ nana̱ yoꞌ a: ―Cheꞌé yan quiranꞌ nij soꞌ da̱nj, ne̱ cheꞌé dan si̱j tumé doj cacunꞌ rihaan cunuda̱nj yoꞌó nij síí ne̱ estadó Galilea me nij soꞌ, rá soj naꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Taj maꞌ. Tza̱j ne̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa sese se̱ canica̱j nimán soj ta̱náj soj chrej chiꞌi̱i̱, ne̱ vaa güii quiri̱ꞌ nu̱ꞌ soj ne̱ quira̱nꞌ soj nda̱a vaa quiranꞌ nij soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","”Ne̱ xa̱ꞌ xnu̱ꞌ vaꞌnu̱j nij síí caviꞌ ga̱a canee veꞌ nataꞌ xca̱a̱n cuꞌna̱j Siloé xráá nij soꞌ, ga̱a ne̱ si̱j tumé doj cacunꞌ rihaan cunuda̱nj nij síí ma̱n chumanꞌ Jerusalén me nij soꞌ, rá soj ga̱a̱ naꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Taj maꞌ. Tza̱j ne̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa sese se̱ canica̱j nimán soj ta̱náj soj chrej chiꞌi̱i̱, ne̱ vaa güii quiri̱ꞌ nu̱ꞌ soj ne̱ quira̱nꞌ soj nda̱a vaa quiranꞌ nij soꞌ ado̱nj ―taj Jesucristó rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ga̱a ne̱ nanó Jesucristó cuentó nihánj a: ―Dan me se ꞌo̱ snóꞌo me se na̱j ꞌo̱ xnaa̱ soꞌ naa̱ chruj uvá, ne̱ nicu̱nꞌ ꞌo̱ chruun higó rque naa̱ uvá yoꞌ, tza̱j ne̱ ꞌnaꞌ soꞌ nanoꞌ soꞌ chruj raa̱ yoꞌ cha̱ soꞌ, tza̱j ne̱ a̱ ꞌó chruj ne quiri̱ꞌ soꞌ cha̱ soꞌ raa̱ chruun yoꞌ, ne̱ cheꞌé dan quiriꞌ rá soꞌ niꞌya̱j soꞌ chruun yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Cheꞌé dan cataj soꞌ rihaan síí ꞌyaj suun rque xnaa̱ soꞌ: “Ni̱ꞌyaj so̱ꞌ ei. Síj vaꞌnu̱j ya̱ yoꞌ ꞌnáꞌ ꞌu̱nj nanóꞌ ꞌu̱nj chruj higó raa̱ chruun nihánj, tza̱j ne̱ a̱ ꞌó chruj nuviꞌ raa̱ chruun nihánj cha̱ꞌ maꞌ. Caꞌne̱ꞌ so̱ꞌ man yoꞌ, ne̱ taj cheꞌé canicu̱nꞌ rmaꞌa̱n yoꞌ rihaan toꞌój a̱ maꞌ”, taj soꞌ rihaan síí ꞌyaj suun rque naa̱ uvá yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tza̱j ne̱ síí ꞌyaj suun rque naa̱ uvá yoꞌ roꞌ, cataj rihaan soꞌ a: “Qui̱ꞌyáá so̱ꞌ se ndoꞌo, ne̱ da̱j o̱rúnꞌ gue̱e̱ yoꞌ cuano̱ ta̱náj níꞌ man chruun nihánj, ne̱ cana̱a̱ ꞌu̱nj nu̱ꞌ anica̱j tacóó chruun yoꞌ, ne̱ ca̱raá ꞌu̱nj yaꞌluj tacóó chruun yoꞌ, señor. ");
INSERT INTO trcNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Xraj, ne̱ sese yoꞌ natu̱u̱ roꞌ, ne̱ cuma̱n chruj raa̱ chruun yoꞌ, ne̱ quina̱j chruun yoꞌ, quiꞌya̱j níꞌ a. Se taj, ne̱ caꞌne̱ꞌ cachri̱j níꞌ man chruun yoꞌ ei”, taj síí ꞌyaj suun naa̱ uvá yoꞌ rihaan síí siꞌya̱j chruun yoꞌ a. ―Dan me cuentó nanó Jesucristó rihaan nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Dan me se ꞌo̱ güii naránj rá nij yuvii̱ israelitá me se tucuꞌyón Jesucristó rihaan nij yuvii̱ cunuu chre̱ꞌ rá veꞌ tucuꞌyón nii se‑tucua̱nj Moisés, ");
INSERT INTO trcNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ne̱ dan me se rá veꞌ yoꞌ roꞌ, nicu̱nꞌ ꞌo̱ chana̱ guun lacu̱u xráá, ne̱ nana̱ chre̱e ya̱nj nimán noꞌ roꞌ, me quiꞌyaj guun lacu̱u xráá noꞌ a. Ne̱ a̱j quisíj xnu̱ꞌ vaꞌnu̱j yoꞌ quiranꞌ noꞌ da̱nj a. Dan me se ne caꞌve̱e canicu̱nꞌ caya̱ noꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Dan me se queneꞌen Jesucristó man noꞌ, ne̱ canacúún soꞌ man noꞌ, cataj soꞌ: ―Cuano̱ nihánj me xꞌne̱e̱ chiꞌii̱ xráá so̱ꞌ, nocoj ―taj Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ne̱ cutaꞌ soꞌ raꞌa soꞌ xráá noꞌ a. Nu̱ꞌ xcaj chana̱ cuentá se vaa nahuun sa̱ꞌ noꞌ, ne̱ nu̱ꞌ guun cheꞌe̱ noꞌ cataj noꞌ se vaa sa̱ꞌ uxrá quiꞌyaj Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tza̱j ne̱ caꞌmaan rá síí ꞌni̱j raꞌa veꞌ tucuꞌyón nii se‑tucua̱nj Moisés, cheꞌé se güii naránj rá nij yuvii̱ israelitá me güii quiꞌyaj conoꞌó Jesucristó man chana̱ yoꞌ a. Cheꞌé dan cataj síí ꞌni̱j raꞌa veꞌ yoꞌ rihaan nij yuvii̱ a: ―Vata̱nꞌ güii me güii no̱ xcúún níꞌ quiꞌya̱j suun níꞌ ꞌo̱ ꞌo̱ smaná a. Caꞌna̱ꞌ soj güii yoꞌ, ne̱ nahu̱un sa̱ꞌ soj ei. Se̱ caꞌnaꞌ soj nahu̱un sa̱ꞌ soj güii naránj rá níꞌ maꞌ ―taj soꞌ rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ga̱a ne̱ cataj síí ꞌni̱j raꞌa man níꞌ rihaan nij tuvi̱ꞌ síí ꞌni̱j raꞌa veꞌ a: ―Quij ndoꞌo vaa nimán soj, ne̱ síí nucuiꞌ ndoꞌo rá me soj ado̱nj. ꞌO̱ se taranꞌ soj me se ne nache soj daán soj scúj do̱ꞌ, daán soj burró do̱ꞌ, rej numi̱i xoꞌ, ne̱ nica̱j soj man xoꞌ ꞌanj soj rej coꞌo̱ xoꞌ na güii naránj rá níꞌ ga̱a̱ naꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ne̱ nihánj me nicu̱nꞌ chana̱ nihánj, ne̱ taꞌníí taꞌnij siꞌno̱ xi̱i níꞌ síí cuꞌna̱j Abraham me noꞌ, ne̱ nihánj me quisíj xnu̱ꞌ vaꞌnu̱j yoꞌ numíj síí cuꞌna̱j Satanás man noꞌ, ne̱ caꞌve̱e se güii naránj rá níꞌ me güii cuanꞌ, tza̱j ne̱ vaa cheꞌé ndoꞌo nache̱ níꞌ man noꞌ raꞌa síí cuꞌna̱j Satanás ado̱nj ―taj Jesucristó rihaan síí ꞌni̱j raꞌa veꞌ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ne̱ ga̱a quisíj caꞌmii soꞌ da̱nj, ga̱a ne̱ guun naꞌa̱j cunuda̱nj nij síí guun rá cunu̱ꞌ ga̱ soꞌ, ga̱a ne̱ guun niha̱ꞌ rá cunuda̱nj nij yuvii̱ cheꞌé cunuda̱nj nij suun sa̱ꞌ noco̱o quiꞌyaj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Cheꞌé dan cataj Jesucristó a: ―Da̱j ga̱a̱ gu̱un chij Diose̱ rihaan chumii̱ nihánj, rá soj ga̱. ");
INSERT INTO trcNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Dan me se ase vaa achij caân cuêj mostazá xlá roꞌ, da̱nj ga̱a̱ gu̱un chij Diose̱ rihaan chumii̱ nihánj ado̱nj. Dan me se nica̱j yoꞌo̱ soꞌ man caân cuêj mostazá xlá ne̱ caxríj soꞌ caân yoꞌ rque toꞌóó soꞌ, ne̱ dan me se xraꞌ caân yoꞌ, ne̱ cachij yoꞌ, ne̱ asa̱ꞌ cachij yoꞌ, ne̱ ase vaa ꞌo̱ chruun roꞌ, da̱nj vaa yoꞌ a. Ga̱a ne̱ cayuu nij xtâj va̱j rej xta̱ꞌ raa̱ cuêj yoꞌ, ne̱ quiꞌyaj nij xoꞌ saca̱ꞌ nij xoꞌ raa̱ cuêj yoꞌ ado̱nj. ―Da̱nj caꞌmii Jesucristó rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ga̱a ne̱ cataj uún Jesucristó a: ―Da̱j ga̱a̱ ꞌo̱ rasu̱u̱n naquiꞌya̱j níꞌ rihaan soj, ga̱a ne̱ queneꞌe̱n soj da̱j ga̱a̱ gu̱un chij Diose̱ rihaan chumii̱ nihánj, rá soj ga̱. ");
INSERT INTO trcNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Dan me se naquiꞌya̱j níꞌ ꞌo̱ chana̱ caxríj yoꞌóó levadura rque cunj hariná ga̱a ꞌyaj noꞌ rachrúún a. Dan me se ase vaa ꞌo̱ chana̱, ne̱ cuxraꞌ taꞌa̱j noꞌ ꞌo̱ vaꞌnu̱j ya̱ agaꞌ yoꞌóó hariná, ne̱ caxríj ndoꞌo noꞌ yoꞌóó levadura, ne̱ caxríj yuve̱ noꞌ man yoꞌ nda̱a navij naraa ndoꞌo nana̱ rque yoꞌ a. Ase vaa uun chij yoꞌóó levadura yoꞌ rihaan cunj hariná roꞌ, da̱nj ga̱a̱ gu̱un chij Diose̱ rihaan chumii̱ nihánj ado̱nj. ―Da̱nj caꞌmii Jesucristó rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ga̱a ne̱ va̱j Jesucristó cachén soꞌ nij chumanꞌ noco̱o do̱ꞌ, nij chumanꞌ raꞌa̱ do̱ꞌ, ne̱ tucuꞌyón soꞌ se‑na̱na̱ soꞌ rihaan nij yuvii̱ a. Ne̱ da̱nj na̱nj nichrunꞌ soꞌ nichrunꞌ soꞌ chumanꞌ Jerusalén a. ");
INSERT INTO trcNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ne̱ xnáꞌanj yoꞌo̱ soꞌ man Jesucristó, cataj soꞌ: ―Ne̱ do̱j nij síí caꞌve̱e quinani̱i̱ rihaan sayuun, quiꞌya̱j Diose̱ a̱ naꞌ ―taj soꞌ, xnáꞌanj soꞌ man Jesucristó a. Ga̱a ne̱ cataj Jesucristó rihaan nij yuvii̱ a: ");
INSERT INTO trcNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Ase vaa taꞌyaa chru̱j ndoꞌo vaa rej cache̱n yuvii̱ catu̱u̱ yuvii̱ rihaan Diose̱ ado̱nj. Quiꞌya̱j nucua̱j soj nimán soj cheꞌé rej catu̱u̱ soj rej yoꞌ ei. Cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa gu̱un ndoꞌo rá nij yuvii̱ catu̱u̱ nij soꞌ rej yoꞌ, tza̱j ne̱ se̱ guun nucua̱j nij soꞌ catu̱u̱ nij soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ne̱ asa̱ꞌ quisíj canicunꞌ caya̱ síí tucua̱ veꞌ yoꞌ ne̱ caráán soꞌ taꞌyaa, ga̱a ne̱ soj roꞌ, canicu̱nꞌ xeꞌ, ne̱ gu̱un cheꞌe̱ soj ti̱caꞌmii soj taꞌyaa, ne̱ cata̱j soj: “Naꞌnu̱u̱ so̱ꞌ taꞌyaa catu̱u̱ núj, Señor”, cata̱j soj, ga̱a ne̱ cata̱j ꞌu̱nj rihaan soj: “Ne neꞌen uxraj me rej cavii soj a̱ maꞌ”, cata̱j ꞌu̱nj rihaan soj ga̱a̱ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ga̱a ne̱ gu̱un cheꞌe̱ soj cata̱j soj: “Chá núj chraa do̱ꞌ, coꞌo núj na ga̱ so̱ꞌ do̱ꞌ, ne̱ tucuꞌyón so̱ꞌ se‑na̱na̱ so̱ꞌ chiháán núj na̱nj á”, cata̱j soj rihanj á. ");
INSERT INTO trcNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ga̱a ne̱ cata̱j uún ꞌu̱nj rihaan soj: “Ne neꞌen uxraj me rej cavii cunuda̱nj soj si̱j ꞌyaj ina̱nj cacunꞌ a̱ maꞌ. Naxu̱u̱n soj man soj rihanj á”, cata̱j ꞌu̱nj rihaan soj a. ");
INSERT INTO trcNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","”Ne̱ rej caꞌa̱nj soj me se rej taꞌve̱e ndoꞌo yuvii̱ me yoꞌ, ne̱ nda̱a cha̱ ru̱j maꞌa̱n yuvii̱ cúú yanꞌ yuvii̱, ne̱ queneꞌe̱n soj man síí cuꞌna̱j Abraham do̱ꞌ, man síí cuꞌna̱j Isaac do̱ꞌ, man síí cuꞌna̱j Jacob do̱ꞌ, man cunuda̱nj nij síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá do̱ꞌ, se vaa ca̱yáán nij soꞌ ga̱ Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj, ne̱ xa̱ꞌ soj, tza̱j ne̱ queneꞌe̱n soj se vaa a̱j quiriꞌíj nii man soj xeꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ne̱ güii gu̱un chij Diose̱ rihaan chumii̱ nihánj roꞌ, caꞌna̱ꞌ ndoꞌo yuvii̱ ma̱n cunu̱ꞌ chumii̱, ne̱ ca̱yáán nij soꞌ rihaan se‑mesa̱ Diose̱, ne̱ cha̱ nij soꞌ chraa ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ne̱ nij síí ne gu̱un chij rihaan chumii̱ nihánj me se xta̱ꞌ roꞌ, gu̱un chij nij soꞌ a. Ne̱ nij síí guun chij ndoꞌo rihaan chumii̱ nihánj me se rej xta̱ꞌ roꞌ, gu̱un nij soꞌ síí noco̱ꞌ, quiꞌya̱j Diose̱ na̱nj ado̱nj ―taj Jesucristó rihaan nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ne̱ güii dan me se cuchiꞌ do̱j nij síí fariseo rihaan Jesucristó, ne̱ cataj nij soꞌ a: ―Cu̱riha̱nj so̱ꞌ estadó nihánj caꞌa̱nj so̱ꞌ, ne̱ síí nica̱j suun rey cuꞌna̱j Herodes me se me ndoꞌo rá soꞌ ticavi̱ꞌ soꞌ mán so̱ꞌ á ―taj nij síí fariseo rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Ase vaa chunee avii ndoꞌo raa̱ quiꞌya̱j sayuun vaa síí cuꞌna̱j Herodes yoꞌ, ne̱ caꞌa̱nj soj, ne̱ cata̱j soj rihaan soꞌ se vaa ꞌu̱nj me se rii ꞌu̱nj nana̱ chre̱e nimán nij yuvii̱, ne̱ naquiꞌyaj sa̱ꞌ ꞌu̱nj man nij síí ranꞌ, ne̱ ꞌo̱ güii cuanꞌ ne̱ ꞌo̱ güii aꞌyuj ne̱ rque vaꞌnu̱j gue̱e̱ güii quiꞌya̱j suun ꞌu̱nj se‑su̱nj, ne̱ veé da̱nj quisi̱j se‑su̱nj, qui̱ꞌyáj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tza̱j ne̱ vaa cheꞌé quiꞌya̱j suun ꞌu̱nj cuanꞌ ne̱ aꞌyuj ne̱ yataj, ne̱ rque vaꞌnu̱j güii quiꞌya̱j suun ꞌu̱nj cheꞌé xrej ꞌu̱nj, ga̱a ne̱ cu̱riha̱nj ꞌu̱nj estadó nihánj ei. ꞌO̱ se taj cheꞌé cavi̱ꞌ ꞌo̱ síí nataꞌ se‑na̱na̱ Diose̱ rej yaníj yoꞌó chumanꞌ, ne̱ veé chumanꞌ Jerusalén cavi̱ꞌ soꞌ ga̱a caꞌve̱e ado̱nj ―taj Jesucristó rihaan nij síí fariseo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ga̱a ne̱ cataj uún Jesucristó a: ―Nanó uxrá raj cheꞌé soj si̱j ma̱n chumanꞌ Jerusalén nihánj na̱nj á. Dan me se ticaviꞌ soj man nij síí nataꞌ se‑na̱na̱ Diose̱, ne̱ goꞌ soj yahij man nij síí caꞌnéé Diose̱ cuchi̱ꞌ rihaan soj a. Guun queꞌe̱e̱ ndoꞌo guun rá ꞌu̱nj naquiꞌya̱j chre̱ꞌ ꞌu̱nj man soj cu̱tumé ꞌu̱nj man soj, tza̱j ne̱ taj se quiꞌyáꞌ caꞌvee maꞌ. Dan me se ase vaa ꞌyaj chuchee naquiꞌyaj chre̱ꞌ chuchee man taꞌníí xoꞌ ca̱ráán xoꞌ xcóó xoꞌ xráá taꞌníí xoꞌ roꞌ, da̱nj guun raj qui̱ꞌyáj man soj, tza̱j ne̱ ne caꞌve̱j rá soj qui̱ꞌyáj da̱nj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ya̱j me se cu̱tumé maꞌa̱n soj man soj na̱nj ado̱nj. ꞌO̱ se cuano̱ nihánj me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa rej rihaan níꞌ roꞌ, se̱ queneꞌen uún soj manj maꞌ. Tza̱j ne̱ nda̱a güii caꞌna̱ꞌ uún ꞌu̱nj rihaan chumii̱ nihánj queneꞌe̱n soj manj, ne̱ cata̱j soj: “Veꞌé uxrá ꞌnaꞌ síí aꞌnéé síí ꞌni̱j raꞌa man níꞌ ei”, cata̱j soj a ―taj Jesucristó niꞌya̱j soꞌ man nij síí ma̱n Jerusalén yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Dan me se ꞌo̱ güii naránj rá nij yuvii̱ israelitá me se catúj Jesucristó rá veꞌ tucuá ꞌo̱ síí uun chij rihaan nij síí fariseo cha̱ soꞌ chraa, ne̱ nij síí fariseo roꞌ, tumé uxrá man soꞌ da̱j quiꞌya̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ne̱ veé da̱nj nicu̱nꞌ ꞌo̱ síí quixíj cuꞌmaan man rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ga̱a ne̱ xnáꞌanj Jesucristó man nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ, man nij síí fariseo do̱ꞌ, cataj soꞌ: ―No̱ xcúún níꞌ caꞌne̱e̱ níꞌ chiꞌii̱ xráá síí ranꞌ güii naránj rá níꞌ, rá soj naꞌ. Ase ne nó xcúún níꞌ xa̱ꞌ ―taj Jesucristó, xnáꞌanj Jesucristó man nij soꞌ a. Tza̱j ne̱ guun dínj tuꞌva nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ga̱a ne̱ quitaꞌaa Jesucristó man síí ranꞌ yoꞌ, ne̱ nahuun sa̱ꞌ soꞌ, quiꞌyaj Jesucristó, ga̱a ne̱ naꞌnéé Jesucristó chrej man soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ga̱a ne̱ niꞌya̱j Jesucristó rihaan nij síí fariseo yoꞌ, cataj soꞌ a: ―Ne̱ sese quini̱j taꞌníí ꞌo̱ tuviꞌ soj do̱ꞌ, ꞌo̱ daán soj scúj do̱ꞌ, rá cuxruj na güii naránj rá níꞌ, ne̱ raꞌya̱nj quiri̱i̱ soj man taꞌníí soj do̱ꞌ, man daán soj do̱ꞌ, rá ꞌu̱nj ei ―taj Jesucristó rihaan nij síí fariseo a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Veé dan me se a̱ ꞌó nana̱ ne quiri̱i̱ nij soꞌ caꞌmi̱i̱ nij soꞌ rihaan Jesucristó maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Dan me se queneꞌen Jesucristó se vaa nij síí ꞌnaꞌ tucuá síí fariseo yoꞌ roꞌ, nanoꞌ ndoꞌo nij soꞌ rej sa̱ꞌ doj quita̱j nij soꞌ, ga̱a ne̱ cheꞌé dan tucuꞌyón Jesucristó nana̱ nihánj man nij soꞌ, cataj soꞌ a: ");
INSERT INTO trcNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Asa̱ꞌ canacúún taꞌa̱j nii mán so̱ꞌ caꞌa̱nj so̱ꞌ chaꞌanj naraꞌa̱a, ne̱ se̱ caꞌanj quita̱j so̱ꞌ chruun xlá sa̱ꞌ doj maꞌ. ꞌO̱ se ne neꞌén so̱ꞌ sese canacu̱nj nii man yoꞌó síí sa̱ꞌ doj rihaan so̱ꞌ ne̱ quita̱j soꞌ chruun xlá ta̱j so̱ꞌ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ne̱ síí ꞌyaj chaꞌanj roꞌ, cata̱j soꞌ rihaan so̱ꞌ: “Rque̱ so̱ꞌ chruun yoꞌ quita̱j síí nihánj á”, cata̱j soꞌ rihaan so̱ꞌ, ga̱a ne̱ gu̱un naꞌa̱j so̱ꞌ, ne̱ chruun xlá nij doj caꞌa̱nj quita̱j so̱ꞌ, quiꞌya̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Dan me se asa̱ꞌ canacúún nii mán so̱ꞌ, ne̱ asa̱ꞌ cuchíꞌ so̱ꞌ rej ca̱nuû chaꞌanj, ne̱ rej nij doj roꞌ, quita̱j so̱ꞌ ei. Ga̱a ne̱ asa̱ꞌ caꞌnaꞌ síí canacúún mán so̱ꞌ, ga̱a ne̱ cata̱j soꞌ rihaan so̱ꞌ: “Cavi̱i̱ so̱ꞌ quita̱j so̱ꞌ rej sa̱ꞌ doj nihánj, tinu̱j”, cata̱j soꞌ rihaan so̱ꞌ, ga̱a ne̱ cara̱yaꞌa̱nj uxrá cunuda̱nj nij síí ꞌnaꞌ chaꞌanj yoꞌ ni̱ꞌyaj nij soꞌ mán so̱ꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ꞌO̱ se xa̱ꞌ síí me rá ti̱cavii sa̱ꞌ man maꞌa̱n, tza̱j ne̱ quiri̱ꞌ soꞌ, ne̱ gu̱un naꞌa̱j soꞌ ado̱nj. Ne̱ xa̱ꞌ síí ꞌyaj nica̱ꞌ nimán, tza̱j ne̱ cavi̱i̱ sa̱ꞌ soꞌ ado̱nj ―taj Jesucristó rihaan nij síí fariseo do̱ꞌ, rihaan nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ga̱a ne̱ cataj Jesucristó rihaan síí canacúún man soꞌ cha̱ soꞌ chraa a: ―Asa̱ꞌ guun rá so̱ꞌ caꞌna̱ꞌ yuvii̱ cha̱ yuvii̱ chraa veꞌ tucuá so̱ꞌ, ne̱ se̱ canacúún so̱ꞌ man tuvíꞌ so̱ꞌ do̱ꞌ, man tinúú so̱ꞌ do̱ꞌ, man nij síí ruꞌvee ma̱n chiháán so̱ꞌ do̱ꞌ maꞌ. Dan me se sese canacu̱nj so̱ꞌ man ina̱nj maꞌa̱n nij soꞌ, ga̱a ne̱ vaa güii canacu̱nj nij soꞌ mán so̱ꞌ cha̱ so̱ꞌ chraa ga̱ nij soꞌ, ga̱a ne̱ dan me se a̱j naruꞌvee nij soꞌ nu̱ꞌ se chá rihaan so̱ꞌ da̱nj rá se vaa ga̱a̱ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tza̱j ne̱ asa̱ꞌ canuû chaꞌanj qui̱ꞌyáá so̱ꞌ, ne̱ canacu̱nj so̱ꞌ man nij síí nique̱ do̱ꞌ, man nij síí rengo̱ do̱ꞌ, man nij síí tuchri̱i do̱ꞌ, cha̱ nij soꞌ chraa ei. ");
INSERT INTO trcNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Da̱nj qui̱ꞌyáá so̱ꞌ, ga̱a ne̱ nij soꞌ me se taj rasu̱u̱n rihaan nij soꞌ na̱ruꞌvee nij soꞌ rihaan so̱ꞌ maꞌ. Ga̱a ne̱ asa̱ꞌ cunuu iꞌna̱ꞌ uún nij síí sa̱ꞌ rihaan Diose̱, ne̱ maꞌa̱n Diose̱ na̱ruꞌvee rihaan so̱ꞌ, ga̱a ne̱ cavi̱i̱ sa̱ꞌ uxrá so̱ꞌ ado̱nj ―taj Jesucristó rihaan síí canacúún man soꞌ cha̱ soꞌ chraa a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Dan me se cuno yoꞌo̱ síí chá chraa ga̱ Jesucristó nana̱ caꞌmii Jesucristó, ga̱a ne̱ cheꞌé dan cataj soꞌ rihaan Jesucristó a: ―Cavi̱i̱ sa̱ꞌ cunuda̱nj nij síí cha̱ chraa ga̱ Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj na̱nj ei ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Síí navij rá chaꞌanj noco̱o ndoꞌo me soꞌ, ne̱ nacúún soꞌ caꞌna̱ꞌ queꞌe̱e̱ yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ga̱a ne̱ dan me se ma̱a̱n orá cha̱ nij soꞌ chraa me caꞌnéé síí navij rá chaꞌanj man se‑mo̱zó soꞌ caꞌa̱nj cata̱j mozó yoꞌ rihaan nij síí caꞌna̱ꞌ se vaa caꞌna̱ꞌ nij soꞌ chaꞌanj cha̱ nij soꞌ chraa a. “A̱j quisíj guun chuvi̱i, ne̱ caꞌa̱nj níꞌ cha̱ nij soj chraa ei”, taj mozó yoꞌ rihaan nij síí caꞌna̱ꞌ chaꞌanj yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ga̱a ne̱ guun cheꞌe̱ nij soꞌ cataj ꞌo̱ ꞌo̱ nij soꞌ rihaan mozó yoꞌ se vaa se̱ caꞌvee cuchi̱ꞌ nij soꞌ cha̱ nij soꞌ chraa a. Dan me se yoꞌo̱ soꞌ cataj: “Tza̱j ne̱ ꞌu̱nj me se tiha̱j quiránj ꞌu̱nj ꞌo̱ yoꞌóó, ne̱ vaa cheꞌé ndoꞌo caꞌa̱nj ꞌu̱nj que̱neꞌén ꞌu̱nj yoꞌóó yoꞌ a. Ne̱ qui̱ꞌyáá so̱ꞌ se ndoꞌo, cata̱j so̱ꞌ se vaa se̱ caꞌvee cuchi̱ꞌ ꞌu̱nj maꞌ”, taj soꞌ rihaan mozó yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ga̱a ne̱ yoꞌó soꞌ cataj: “Ma̱a̱n se ꞌu̱nj me se ꞌu̱nꞌ yuntá scúj quiránj ꞌu̱nj, ne̱ cuano̱ nihánj me se caꞌa̱nj ꞌu̱nj que̱neꞌén ꞌu̱nj da̱j vaa scúj quiránj sese scúj sa̱ꞌ me xoꞌ a. Ne̱ cheꞌé dan qui̱ꞌyáá so̱ꞌ se ndoꞌo cata̱j so̱ꞌ se vaa se̱ caꞌvee cuchi̱ꞌ ꞌu̱nj maꞌ”, taj soꞌ rihaan mozó yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ne̱ yoꞌó soꞌ roꞌ, cataj uún rihaan mozó yoꞌ a: “ꞌU̱nj me se tiha̱j xcaj ꞌu̱nj chana̱, ne̱ cheꞌé dan se̱ caꞌvee cuchi̱ꞌ ꞌu̱nj maꞌ”, taj soꞌ rihaan se‑mo̱zó síí navij rá chaꞌanj yoꞌ a. Ne̱ veé da̱nj caꞌmii cunuda̱nj nij síí a̱j quiriꞌ niꞌya̱j caꞌa̱nj chaꞌanj yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","”Dan me se namán mozó, ne̱ nataꞌ mozó nu̱ꞌ se vaa caꞌmii ꞌo̱ ꞌo̱ nij soꞌ rihaan se‑ruꞌve̱e̱ mozó a. Ga̱a ne̱ caꞌmaan ndoꞌo rá síí navij rá chaꞌanj yoꞌ ga̱a cuno soꞌ se‑na̱na̱ se‑mo̱zó soꞌ, ne̱ cataj soꞌ rihaan se‑mo̱zó soꞌ: “Raꞌya̱nj cavi̱i̱ so̱ꞌ caꞌa̱nj so̱ꞌ daj a̱ nij callé, ne̱ ni̱caj so̱ꞌ man nij síí nique̱ do̱ꞌ, man nij síí chéé rengo̱ do̱ꞌ, man nij síí tuchri̱i do̱ꞌ, caꞌna̱ꞌ so̱ꞌ nihánj, ne̱ cha̱ nij soꞌ chraa ga̱ níꞌ ei”, taj soꞌ rihaan se‑mo̱zó soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Veé da̱nj quiꞌyaj se‑mo̱zó soꞌ, ne̱ cuchiꞌ uún mozó yoꞌ rihaan se‑ruꞌve̱e̱ soꞌ, ne̱ cataj soꞌ: “A̱j quiꞌyáj nu̱ꞌ se vaa cataj so̱ꞌ rihanj, señor. Tza̱j ne̱ vaa rej quisi̱j catu̱u̱ doj yuvii̱ uún a”, taj mozó yoꞌ rihaan se‑ruꞌve̱e̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ga̱a ne̱ cataj ruꞌvee yoꞌ rihaan mozó a: “Cavi̱i̱ so̱ꞌ caꞌa̱nj so̱ꞌ nu̱ꞌ nij chrej caꞌa̱a̱n do̱ꞌ, nu̱ꞌ nij chrej catu̱u̱n do̱ꞌ, ne̱ qui̱ꞌyáá so̱ꞌ fuerzá man nij yuvii̱ se vaa caꞌna̱ꞌ nij soꞌ á. Ga̱a ne̱ cara̱a nu̱ꞌ veꞌ tucuaj ei. ");
INSERT INTO trcNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ꞌO̱ se cuano̱ nihánj me se cata̱j xnaꞌanj ꞌu̱nj rihaan so̱ꞌ se vaa xa̱ꞌ nij síí canacúún níꞌ asino ya̱a̱n, tza̱j ne̱ a̱ ꞌó nij soꞌ se̱ caꞌvee caꞌna̱ꞌ cha̱ chraa ga̱ níꞌ a̱ man ado̱nj”, taj soꞌ rihaan se‑mo̱zó soꞌ a. ―Veé da̱nj quisíj cuentó nanó Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Dan me se queꞌe̱e̱ uxrá yuvii̱ vaj ga̱ Jesucristó, ne̱ canica̱j soꞌ, cataj soꞌ rihaan nij yuvii̱ a: ");
INSERT INTO trcNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Sese me rá ꞌo̱ soꞌ caꞌna̱ꞌ soꞌ rihanj, ne̱ sese gu̱un rá soꞌ se vaa sa̱ꞌ doj vaa rej soꞌ do̱ꞌ, nii soꞌ do̱ꞌ, nica̱ soꞌ do̱ꞌ, taꞌníí soꞌ do̱ꞌ, tinúú soꞌ do̱ꞌ, raꞌvij soꞌ do̱ꞌ, nda̱a nimán maꞌa̱n soꞌ do̱ꞌ, rihanj, ne̱ se̱ caꞌvee gu̱un soꞌ ꞌo̱ síí tucuꞌyón se‑na̱na̱j a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ne̱ síí naꞌvej rá quira̱nꞌ sayuun cheꞌé se me soꞌ síí noco̱ꞌ manj roꞌ, se̱ caꞌvee gu̱un soꞌ ꞌo̱ síí tucuꞌyón se‑na̱na̱j a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","”Dan me se soj, tza̱j ne̱ sese gu̱un rá yoꞌo̱ tuviꞌ soj cune̱ꞌ yoꞌo̱ soj veꞌ nataꞌ xca̱a̱n, ne̱ síí quiꞌya̱j veꞌ yoꞌ me se asino nuchru̱j ra̱a̱ soꞌ cuentá sese quisi̱j se‑saꞌa̱nj soꞌ quisi̱j nu̱ꞌ veꞌ yoꞌ, raj a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ne̱ sese se̱ quiꞌyaj soꞌ da̱nj nuchru̱j soꞌ cuentá asino ya̱a̱n, ga̱a ne̱ asa̱ꞌ cuchruj soꞌ tacóó veꞌ, ga̱a ne̱ se̱ guun nucua̱j soꞌ quiꞌya̱j soꞌ nu̱ꞌ veꞌ a̱ maꞌ. Ne̱ nij síí neꞌen se vaa quiꞌyaj soꞌ roꞌ, caꞌnga̱ꞌ naco̱o̱ nij soꞌ ni̱ꞌyaj nij soꞌ man soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ne̱ cata̱j nij soꞌ: “Síí nihánj me se guun cheꞌe̱ soꞌ cuneꞌ soꞌ veꞌ, tza̱j ne̱ ne gu̱un nucua̱j soꞌ quisi̱j nu̱ꞌ veꞌ quiꞌya̱j soꞌ a̱ maꞌ”, cata̱j nij soꞌ ni̱ꞌyaj nij soꞌ man síí guun cheꞌe̱ veꞌ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","”Ne̱ dan me se sese vaa ꞌo̱ síí nica̱j suun rey vaa chi̱ꞌ míj tanuu rihaan, ne̱ sese caꞌna̱ꞌ yoꞌó síí nica̱j suun rey vaa ico̱ míj tanuu rihaan cunu̱ꞌ ga̱ soꞌ, ga̱a ne̱ asino ya̱a̱n xca̱j soꞌ cuentá sese gu̱un nucua̱j soꞌ quiꞌya̱j canaán soꞌ rihaan síí vaa ico̱ míj tanuu rihaan yoꞌ, ne̱ sese gu̱un nucua̱j soꞌ rá soꞌ, ne̱ cavi̱i̱ soꞌ cunu̱ꞌ soꞌ ga̱ nij síí ꞌnaꞌ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tza̱j ne̱ sese se̱ guun nucua̱j soꞌ quiꞌya̱j canaán soꞌ rá soꞌ, ga̱a ne̱ caꞌne̱j soꞌ síí caꞌanj suun caꞌmi̱i̱ ga̱ síí ꞌnaꞌ yoꞌ nda̱a vaa se̱ guun cunu̱ꞌ nij soꞌ a. Da̱nj cata̱j soꞌ ga̱a tiha̱j ꞌnaꞌ síí cunu̱ꞌ ga̱ soꞌ ga̱nꞌ a. Ga̱a ne̱ cachi̱nj niꞌya̱j síí caꞌanj suun yoꞌ rihaan síí ꞌnaꞌ, nda̱a vaa caꞌne̱ꞌ rá soꞌ ga̱ suun cunu̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","”Dan me se ase vaa xcaj síí cune̱ꞌ veꞌ do̱ꞌ, síí cunu̱ꞌ ga̱ tuviꞌ do̱ꞌ, cuentá sese gu̱un nucua̱j ro̱j soꞌ quiꞌya̱j ro̱j soꞌ da̱nj roꞌ, veé da̱nj quiꞌya̱j gue̱e̱ soj si̱j me rá canoco̱ꞌ manj ei. Ne̱ sese se̱ guun rá soj ta̱náj xco̱ soj nu̱ꞌ siꞌyaj soj do̱ꞌ, nu̱ꞌ tuviꞌ soj do̱ꞌ, canoco̱ꞌ soj manj, ne̱ se̱ caꞌvee gu̱un soj síí tucuꞌyón se‑na̱na̱j a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","”ꞌO̱ se ase vaa yaan ga̱ chraa roꞌ, da̱nj vaa nij síí tucuꞌyón se‑na̱na̱j ga̱ chumii̱ nihánj, ne̱ vaa se uun ndoꞌo yaan na̱nj á. Dan me se sese ne ꞌne̱ꞌ chá yaan yoꞌ, ga̱a ne̱ taj se qui̱ꞌyáꞌ cunu̱u sa̱ꞌ yaan ga̱a̱ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Taj se gu̱un yaan yoꞌ rihaan toꞌóó níꞌ cunu̱u sa̱ꞌ toꞌóó níꞌ maꞌ. Taj se gu̱un yaan yoꞌ rihaan yaꞌluj se vaa cunu̱u sa̱ꞌ doj yaꞌluj maꞌ. A̱ doj rasu̱u̱n se̱ cavii sa̱ꞌ, quiꞌya̱j yaan yoꞌ maꞌ. Ma̱a̱n se riꞌi̱j u̱u̱n nii man yaan vaa da̱nj xeꞌ a. ”Dan me se sese ta̱j yuꞌuj xréé soj, ne̱ cuno̱ soj nana̱ nihánj ei ―taj Jesucristó rihaan nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Dan me se cuchiꞌ queꞌe̱e̱ síí aꞌnéj puextó do̱ꞌ, queꞌe̱e̱ síí tumé cacunꞌ do̱ꞌ, rihaan Jesucristó a. ꞌO̱ se guun rá nij soꞌ cuno̱ nij soꞌ se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ne̱ xa̱ꞌ nij síí fariseo do̱ꞌ, nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ, tza̱j ne̱ caꞌmaan rá nij soꞌ niꞌya̱j nij soꞌ man Jesucristó, ne̱ nij caꞌmii nij soꞌ cheꞌé soꞌ, cheꞌé rej veꞌé nica̱j tuviꞌ soꞌ ga̱ nij síí tumé cacunꞌ ne̱ chá soꞌ chraa ga̱ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ga̱a ne̱ nanó Jesucristó ꞌo̱ cuentó nihánj rihaan nij soꞌ a: ");
INSERT INTO trcNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Dan me se sese yoꞌo̱ tuviꞌ nij soj nica̱j ꞌo̱ cientó matzinj, ne̱ sese caꞌa̱nj niꞌya̱ o̱rúnꞌ gue̱e̱ daán soꞌ matzinj, ne̱ ta̱náj soꞌ yoꞌó caꞌa̱nj chiha̱a̱ xnu̱ꞌ caꞌa̱nj daán soꞌ matzinj rej tacaan, ne̱ cavi̱i̱ soꞌ caꞌa̱nj nano̱ꞌ soꞌ man o̱rúnꞌ daán soꞌ matzinj caꞌanj niꞌya̱ á. Ne̱ se̱ caꞌneꞌ rá soꞌ maꞌ. Tana̱nj ya̱ caꞌa̱nj soꞌ nano̱ꞌ soꞌ man daán soꞌ matzinj, ga̱a ne̱ uun da̱j nari̱ꞌ soꞌ man yoꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ne̱ asa̱ꞌ quisíj nariꞌ soꞌ man xoꞌ, ga̱a ne̱ cuta̱ꞌ soꞌ man xoꞌ tacaan xcóó soꞌ, ne̱ gu̱un niha̱ꞌ ndoꞌo rá soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ne̱ asa̱ꞌ namán soꞌ tucuá soꞌ, ga̱a ne̱ nacu̱nj soꞌ man nu̱ꞌ tuviꞌ soꞌ síí ne̱ chiháán soꞌ, ne̱ cata̱j soꞌ rihaan nij tuviꞌ soꞌ: “Gu̱un niha̱ꞌ rá soj ga̱j ei. ꞌO̱ se narij danj matzinj caꞌanj niꞌya̱ ei”, cata̱j soꞌ rihaan tuviꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ne̱ cuano̱ nihánj me cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa xta̱ꞌ rej ne̱ Diose̱ roꞌ, gu̱un niha̱ꞌ doj rá nij síí ma̱n yoꞌ ni̱ꞌyaj nij soꞌ man o̱rúnꞌ síí tumé cacunꞌ ga̱a canica̱j nimán soꞌ canocoꞌ soꞌ chrej sa̱ꞌ a. Tza̱j ne̱ se̱ caráyaꞌa̱nj nij soꞌ man caꞌa̱nj chiha̱a̱ xnu̱ꞌ caꞌa̱nj, ése̱ si̱j sa̱ꞌ me nij soꞌ, rá nij soꞌ maꞌ, ne̱ taj cheꞌé canoco̱ꞌ nij soꞌ tucuáán naca̱ narqué Diose̱, rá nij soꞌ maꞌ ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ne̱ cataj uún Jesucristó a: ―Ne̱ sese ni̱caj ꞌo̱ chana̱ chi̱ꞌ pesó xoo, ne̱ sese caꞌa̱nj niꞌya̱ o̱rúnꞌ pesó xoo yoꞌ, ne̱ tucuaco̱ꞌ noꞌ yaꞌan agaꞌ chuguu̱n, ne̱ naca̱ꞌ noꞌ nu̱ꞌ veꞌ tucuá noꞌ, ne̱ uxrá nano̱ꞌ noꞌ pesó xoo yoꞌ, ne̱ se̱ caꞌneꞌ rá noꞌ maꞌ. Tana̱nj uxrá nano̱ꞌ noꞌ man pesó xoo yoꞌ, uun da̱j nari̱ꞌ ya̱ noꞌ man yoꞌ, ga̱a ne̱ caꞌne̱ꞌ rá noꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ne̱ asa̱ꞌ quisíj nariꞌ noꞌ pesó xoo yoꞌ, ga̱a ne̱ canacu̱nj noꞌ man nu̱ꞌ tuviꞌ cha̱na̱ noꞌ níí ne̱ xꞌnúú veꞌ tucuá noꞌ, ne̱ cata̱j noꞌ rihaan nij tuviꞌ cha̱na̱ noꞌ: “Gu̱un niha̱ꞌ rá soj ga̱j á. ꞌO̱ se narij se‑saꞌa̱nj pesó xoo caꞌanj niꞌya̱ ei”, cata̱j noꞌ rihaan tuviꞌ cha̱na̱ noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Dan me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj a. Nda̱a rá se vaa guun rá chana̱ ga̱a nariꞌ noꞌ se‑saꞌa̱nj noꞌ roꞌ, da̱nj gu̱un niha̱ꞌ uxrá rá nij se‑mo̱zó Diose̱ ni̱ꞌyaj nij soꞌ man o̱rúnꞌ síí tumé cacunꞌ ga̱a canica̱j nimán soꞌ canocoꞌ soꞌ chrej sa̱ꞌ ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ga̱a ne̱ cataj uún Jesucristó a: ―ꞌO̱ síí vaa vi̱j taꞌníí me soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ne̱ cataj síí cuni̱j rihaan rej soꞌ a: “Me rá ꞌu̱nj cuxra̱ꞌ taꞌa̱j so̱ꞌ rasu̱u̱n rque̱ so̱ꞌ manj gu̱un siꞌyáj, ata̱j”, taj soꞌ rihaan rej soꞌ a. Ga̱a ne̱ cuxraꞌ taꞌa̱j snóꞌo yoꞌ nu̱ꞌ siꞌyaj soꞌ, ne̱ rqué soꞌ taꞌa̱j siꞌyaj soꞌ rihaan ꞌo̱ ꞌo̱ taꞌníí soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Dan me se cachén do̱j güii, ga̱a ne̱ naquiꞌyaj chre̱ꞌ síí cuni̱j yoꞌ nu̱ꞌ siꞌyaj soꞌ, ne̱ cavii soꞌ caꞌanj soꞌ chumanꞌ na̱j ga̱nꞌ, ne̱ quiꞌyaj ndoꞌo soꞌ se nij, ne̱ cutunꞌ rmaꞌa̱n soꞌ nu̱ꞌ se‑saꞌa̱nj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Quisíj cutunꞌ soꞌ nu̱ꞌ se‑saꞌa̱nj soꞌ, ga̱a ne̱ cachén ndoꞌo xꞌnaa chumanꞌ yoꞌ, ne̱ guun cheꞌe̱ soꞌ quiranꞌ ndoꞌo soꞌ sayuun, ne̱ quinaꞌaan ndoꞌo rque soꞌ, ne̱ taj va̱j a̱ doj se chá rihaan soꞌ cha̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Dan me se catúj soꞌ rihaan ꞌo̱ síí chiha̱nj chumanꞌ yoꞌ, ne̱ caꞌneꞌ síí chiha̱nj chumanꞌ yoꞌ suun rihaan soꞌ caꞌa̱nj soꞌ se‑rancho̱ síí chiha̱nj yoꞌ cu̱tumé soꞌ xcáá a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tza̱j ne̱ naꞌaan ndoꞌo rque soꞌ, ne̱ nda̱a guun rá soꞌ cha̱ soꞌ coj goꞌ nii cha̱ nij xcáá a. Tza̱j ne̱ ne rque̱ nii coj yoꞌ cha̱ soꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","”Dan me se ꞌo̱ güii ne̱ nahuun sa̱ꞌ raa̱ soꞌ, ne̱ guun cheꞌe̱ soꞌ xcaj soꞌ cuentá, ne̱ nanuj rá soꞌ rej soꞌ a. Ne̱ me rá soꞌ: “Nij se‑mo̱zó réj, tza̱j ne̱ ma̱n ndoꞌo se chá rihaan réj, ne̱ ma̱n ndoꞌo se chá rihaan se‑mo̱zó réj a. Ne̱ nihánj me cavi̱ꞌ ꞌu̱nj quiꞌya̱j xꞌnaa na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Na̱xuma̱a̱n ꞌu̱nj, ne̱ nánꞌ ꞌu̱nj rej ne̱ réj, cata̱j ꞌu̱nj rihaan réj: Tumej cacunꞌ rihaan Diose̱, ne̱ tumej cacunꞌ rihaan so̱ꞌ, ata̱j. ");
INSERT INTO trcNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Taj cheꞌé cata̱j so̱ꞌ se vaa taꞌníí so̱ꞌ mej cuano̱ a̱ maꞌ. Ma̱a̱n se qui̱ꞌyáá so̱ꞌ se ndoꞌo, ne̱ guún ꞌu̱nj mozó rihaan so̱ꞌ, qui̱ꞌyáá so̱ꞌ, rugua̱nj, cata̱j ꞌu̱nj rihaan réj”, guun rá síí cuni̱j yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","”Ga̱a ne̱ cavii soꞌ caꞌanj soꞌ rej ne̱ rej soꞌ a. Dan me se ga̱nꞌ ndoꞌo va̱j soꞌ chéé soꞌ, ne̱ queneꞌen rej soꞌ man soꞌ, ne̱ cunuu ꞌe̱e̱ ndoꞌo rá rej soꞌ man soꞌ, ne̱ cunánj rej soꞌ nda̱a rej va̱j soꞌ, ne̱ naꞌya̱a̱n rej soꞌ man soꞌ, ne̱ cachrón tuꞌva̱ rej soꞌ man soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ga̱a ne̱ cataj síí cuni̱j yoꞌ rihaan rej soꞌ a: “Tumej cacunꞌ rihaan Diose̱, ne̱ tumej cacunꞌ rihaan so̱ꞌ, ata̱j. Taj cheꞌé cata̱j so̱ꞌ se vaa taꞌníí so̱ꞌ mej cuano̱ a̱ maꞌ. Ma̱a̱n se qui̱ꞌyáá so̱ꞌ se ndoꞌo, ne̱ guún ꞌu̱nj mozó rihaan so̱ꞌ, qui̱ꞌyáá so̱ꞌ, rugua̱nj”, taj soꞌ rihaan rej soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tza̱j ne̱ caꞌmii rej soꞌ rihaan nij mozó ma̱n rihaan rej soꞌ, cataj rej soꞌ: “Raꞌya̱nj ni̱caj soj yatzíj sa̱ꞌ ndoꞌo caꞌna̱ꞌ soj cu̱nuû taꞌníj, ne̱ caꞌna̱ꞌ seꞌej sa̱ꞌ cu̱nuû raꞌa taꞌníj, ne̱ caꞌna̱ꞌ canj naca̱ qui̱ꞌnij tacóó soꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ne̱ ticavi̱ꞌ soj man scúj leꞌe̱j ramii ndoꞌo, ne̱ quiꞌya̱j chuvi̱i soj, ne̱ cha̱ níꞌ, ne̱ quiꞌya̱j níꞌ chaꞌanj, ne̱ gu̱un niha̱ꞌ uxrá rá níꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ꞌO̱ se taꞌníj nihánj me se ase vaa síí caviꞌ gaa soꞌ rihanj, tza̱j ne̱ nihánj me se cunuu iꞌna̱ꞌ uún soꞌ rihanj, ne̱ ase vaa síí caꞌanj niꞌya̱ gaa soꞌ, tza̱j ne̱ nihánj me se narij man soꞌ na̱nj ado̱nj”, taj rej soꞌ, ne̱ guun cheꞌe̱ nij soꞌ guun niha̱ꞌ uxrá rá nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","”Tza̱j ne̱ vaa síí chava̱ꞌ uún, ne̱ ꞌyaj suun soꞌ se‑rancho̱ rej soꞌ a. Dan me se ꞌnaꞌ nique síí chava̱ꞌ yoꞌ, ne̱ ga̱a quinichrunꞌ soꞌ veꞌ, ne̱ cuno soꞌ se vaa goꞌ ndoꞌo misca̱ chraꞌ do̱ꞌ, se vaa raꞌánj ndoꞌo yuvii̱ do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ga̱a ne̱ canacúún síí chava̱ꞌ yoꞌ man ꞌo̱ mozó, ne̱ caꞌnaꞌ yoꞌo̱ mozó rihaan soꞌ, ne̱ xnáꞌanj soꞌ man mozó, ne̱: “Me cheꞌé ꞌyaj nii nu̱ꞌ chaꞌanj ga̱”, taj soꞌ rihaan mozó yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ga̱a ne̱ cataj mozó rihaan soꞌ a: “Namán tinúú so̱ꞌ, ne̱ caviꞌ scúj leꞌe̱j ramii ndoꞌo, quiꞌyaj réé so̱ꞌ, cheꞌé se nariꞌ uún soꞌ taꞌníí soꞌ ne̱ vaa nucua̱j taꞌníí soꞌ nariꞌ soꞌ a”, taj mozó rihaan síí chava̱ꞌ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","”Dan me se caꞌmaan rá síí chava̱ꞌ, ne̱ naꞌvej uxrá rá soꞌ catu̱u̱ soꞌ rá veꞌ a. Tza̱j ne̱ curiha̱nj rej soꞌ, ga̱a ne̱ canacúún rej soꞌ man soꞌ caꞌna̱ꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tza̱j ne̱ cataj soꞌ rihaan rej soꞌ a: “ꞌU̱nj nihánj me se a̱j quisíj queꞌe̱e̱ yoꞌ quiꞌyaj suun ꞌu̱nj rihaan so̱ꞌ nihánj, ne̱ cunuda̱nj nij nana̱ cataj xnaꞌanj so̱ꞌ rihanj veꞌé cunoj a. Ne̱ a̱ ꞌó güii ne rque̱ so̱ꞌ a̱ ꞌó tana leꞌe̱j rihanj ne̱ quiꞌya̱j chu̱vií ꞌu̱nj ne̱ cha̱j ga̱ nij tuvij a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tza̱j ne̱ nihánj me se namán taꞌníí so̱ꞌ síí chá nu̱ꞌ siꞌyáá so̱ꞌ ga̱a chéé soꞌ ga̱ nij chana̱ niha̱ꞌ rá, ne̱ ticavíꞌ so̱ꞌ scúj leꞌe̱j ramii cheꞌé soꞌ a”, taj síí chava̱ꞌ yoꞌ rihaan rej soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","”Ga̱a ne̱ cataj rej soꞌ rihaan soꞌ a: “Ma̱a̱n se so̱ꞌ me se ꞌo̱ né so̱ꞌ ga̱ ꞌu̱nj nihánj, rej. Ne̱ nu̱ꞌ rasu̱u̱n siꞌyáj me siꞌyáá so̱ꞌ, rej. ");
INSERT INTO trcNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tza̱j ne̱ vaa cheꞌé gu̱un niha̱ꞌ rá níꞌ ga̱a namán tinúú so̱ꞌ, rej. ꞌO̱ se tinúú so̱ꞌ roꞌ, ase vaa ꞌo̱ síí caviꞌ gaa soꞌ rihanj, tza̱j ne̱ nihánj me cunuu iꞌna̱ꞌ uún soꞌ, ne̱ ase vaa ꞌo̱ síí caꞌanj niꞌya̱ gaa soꞌ rihanj, tza̱j ne̱ cuano̱ nihánj me se a̱j narij man soꞌ na̱nj ado̱nj”, taj rej soꞌ rihaan síí chava̱ꞌ yoꞌ a. ―Veé da̱nj quisíj cuentó nanó Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ga̱a ne̱ cataj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a: ―Síí ruꞌvee me yoꞌo̱ soꞌ, ne̱ nu̱u̱ ꞌo̱ mayordomo rihaan soꞌ síí tumé nu̱ꞌ siꞌyaj soꞌ a. Dan me se cutaꞌ nii cacunꞌ xráá mayordomo yoꞌ rihaan ruꞌvee se vaa cutunꞌ ndoꞌo soꞌ siꞌyaj ruꞌvee a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ga̱a ne̱ canacúún ruꞌvee man mayordomo, ne̱ caꞌnaꞌ mayordomo rihaan soꞌ, ne̱ cataj soꞌ rihaan mayordomo yoꞌ a: “A̱j caꞌnaꞌ nana̱ rihanj se vaa cutunꞌ ndoꞌo so̱ꞌ siꞌyáj, ne̱ ne neꞌen uxraj me cheꞌé quiꞌyáá so̱ꞌ da̱nj a̱ maꞌ. Tza̱j ne̱ cata̱j xnaꞌanj so̱ꞌ rihanj da̱j quiꞌyáá so̱ꞌ ga̱a cutumé so̱ꞌ siꞌyáj á. ꞌO̱ se se̱ caꞌvee cu̱nuû so̱ꞌ doj rihanj cu̱tumé so̱ꞌ siꞌyáj a̱ maꞌ”, taj ruꞌvee rihaan mayordomo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","”Dan me se curiha̱nj mayordomo, ne̱ guun rá soꞌ a: “Nihánj me se da̱j qui̱ꞌyáj, ne̱ caꞌne̱e̱ se‑ruꞌve̱e̱ ꞌu̱nj suun raꞌaj, ne̱ da̱j qui̱ꞌyáj cuano̱, raj a. ꞌU̱nj me se se̱ guun nu̱cuáj quiꞌya̱j suun ꞌu̱nj suun ꞌe̱e̱, ne̱ naꞌa̱j ꞌu̱nj cachi̱nj ꞌu̱nj caridad, naꞌa̱j ꞌu̱nj cache̱e̱ rma̱ꞌanj na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aan a. Nihánj me qui̱ꞌyáj na̱nj á. Ga̱a ne̱ asa̱ꞌ caꞌnéj ruꞌvee suun raꞌaj ga̱a ne̱ nuviꞌ rej caꞌa̱nj ꞌu̱nj, ga̱a ne̱ canacu̱nj yoꞌó nij soꞌ manj caꞌa̱nj ꞌu̱nj tucuá yoꞌó nij soꞌ ca̱yánj a”, guun rá soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","”Ga̱a ne̱ canacúún soꞌ man nij síí quiꞌyaj xcúún rihaan se‑ruꞌve̱e̱ soꞌ, ne̱ caꞌnaꞌ ꞌo̱ ꞌo̱ nij soꞌ rihaan soꞌ a. Ga̱a ne̱ rihaan síí ta̱j ya̱a̱n rihaan yoꞌó nij soꞌ cataj soꞌ: “Me daj quiꞌyaj xcúún so̱ꞌ rihaan se‑ruꞌve̱e̱ ꞌu̱nj ga̱”, taj soꞌ, xnáꞌanj soꞌ man síí ta̱j ya̱a̱n yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ga̱a ne̱ soꞌ cataj: “ꞌO̱ cientó tambo casté quiꞌyaj xcúnj rihaan se‑ruꞌve̱e̱ so̱ꞌ a”, taj soꞌ rihaan mayordomo yoꞌ a. Ga̱a ne̱ cataj mayordomo yoꞌ rihaan soꞌ: “Ni̱caj so̱ꞌ dáán so̱ꞌ yanj cuentá nihánj, ti̱ríꞌ so̱ꞌ man yoꞌ, ne̱ raꞌya̱nj ca̱yáán so̱ꞌ, ne̱ qui̱ꞌyáá so̱ꞌ yoꞌó yanj naca̱, ne̱ cachro̱n so̱ꞌ rihaan yanj naca̱ se vaa vi̱j chiha̱a̱ chi̱ꞌ gue̱e̱ tambo quiꞌyaj xcúún so̱ꞌ á”, taj mayordomo yoꞌ rihaan síí ta̱j ya̱a̱n yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ga̱a ne̱ xnáꞌanj soꞌ man yoꞌó soꞌ, cataj soꞌ: “Ne̱ so̱ꞌ ga̱. Me daj quiꞌyaj xcúún so̱ꞌ rihaan se‑ruꞌve̱e̱ ꞌu̱nj ga̱”, taj soꞌ, xnáꞌanj soꞌ man yoꞌó soꞌ yoꞌ a. “ꞌO̱ cientó nanj ꞌnúú trigó a”, taj yoꞌó soꞌ a. “Ni̱caj so̱ꞌ dáán so̱ꞌ yanj cuentá nihánj, ti̱ríꞌ so̱ꞌ man yoꞌ, ne̱ qui̱ꞌyáá so̱ꞌ yoꞌó yanj naca̱, ne̱ caꞌa̱nj chiha̱a̱ gue̱e̱ nanj cachro̱n so̱ꞌ rihaan yanj naca̱ yoꞌ á”, taj mayordomo rihaan yoꞌó soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","”Dan me se xcaj se‑ruꞌve̱e̱ mayordomo yoꞌ cuentá se vaa quiꞌyaj chiꞌi̱i̱ ndoꞌo mayordomo yoꞌ rihaan soꞌ, tza̱j ne̱ caꞌmii sa̱ꞌ ruꞌvee cheꞌé mayordomo cataj ruꞌvee se vaa si̱j avii ndoꞌo raa̱ me mayordomo yoꞌ ado̱nj. Da̱nj na̱nj nij síí ma̱n rihaan chumii̱ nihánj cuano̱, tza̱j ne̱ ga̱a ꞌyaj suun nij soꞌ ga̱ tuviꞌ maꞌa̱n nij soꞌ, ne̱ doj a̱ avii raa̱ nij soꞌ rihaan nij síí noco̱ꞌ se‑na̱na̱ Diose̱ na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","”Ga̱a ne̱ cuano̱ nihánj me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa nij rasu̱u̱n ma̱n rihaan chumii̱ nihánj, tza̱j ne̱ ꞌyaj ndoꞌo nij yuvii̱ cacunꞌ cheꞌé rej quiꞌya̱j canaán nij yuvii̱ rasu̱u̱n ma̱n rihaan chumii̱ nihánj, ne̱ soj roꞌ, vaa cheꞌé ni̱caj soj siꞌyaj soj rasu̱u̱n ma̱n rihaan chumii̱ nihánj, ne̱ go̱ꞌ soj man yuvii̱ ga̱a ne̱ gu̱un tuvi̱ꞌ soj ga̱ nij yuvii̱, quiꞌya̱j rasu̱u̱n yoꞌ a. Ne̱ güii navi̱j nu̱ꞌ rasu̱u̱n ma̱n rihaan chumii̱ nihánj me se a̱j quiriꞌ ndoꞌo soj tuviꞌ soj síí ca̱yáán ga̱ soj, ga̱a ne̱ veꞌé ndoꞌo ca̱yáán soj ga̱ nij tuviꞌ soj ga̱ Diose̱ rej xta̱ꞌ nu̱ꞌ cavii nu̱ꞌ caꞌanj a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ꞌO̱ se síí veꞌé tumé do̱j tzinꞌ rasu̱u̱n roꞌ, soꞌ me síí gu̱un nucua̱j cu̱tumé noco̱o rasu̱u̱n, ne̱ síí ꞌyaj chiꞌi̱i̱ ga̱ do̱j rasu̱u̱n roꞌ, chiꞌi̱i̱ doj quiꞌya̱j soꞌ ga̱ noco̱o rasu̱u̱n ei. ");
INSERT INTO trcNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Cheꞌé dan sese ne gu̱un nucua̱j soj cu̱tumé sa̱ꞌ soj nij rasu̱u̱n chiꞌi̱i̱ ma̱n rihaan chumii̱ nihánj, ga̱a ne̱ me síí gu̱un rá rque̱ nij rasu̱u̱n ya̱ rihaan soj cu̱tumé soj, rá soj ga̱. Taj va̱j síí gu̱un rá quiꞌya̱j da̱nj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ne̱ nuveé siꞌya̱j maꞌa̱n ya̱ soj me nij rasu̱u̱n ma̱n rihaan chumii̱ nihánj a̱ man ado̱nj. Ne̱ sese ne gu̱un nucua̱j soj cu̱tumé sa̱ꞌ soj nij rasu̱u̱n ma̱n rihaan chumii̱ nihánj, ne̱ me síí gu̱un rá rque̱ rihaan soj rasu̱u̱n gu̱un siꞌya̱j maꞌa̱n ya̱ soj rej xta̱ꞌ, rá soj ga̱. Taj síí gu̱un rá quiꞌya̱j da̱nj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","”Taj va̱j síí gu̱un nucua̱j cu̱tumé sa̱ꞌ siꞌyaj vi̱j ruꞌvee maꞌ. Sese quiꞌya̱j suun níꞌ rihaan vi̱j ruꞌvee, ne̱ nachri̱ꞌ níꞌ ni̱ꞌyaj níꞌ man ꞌo̱ ruꞌvee yoꞌ, ne̱ cara̱nꞌ rá níꞌ ni̱ꞌyaj níꞌ man yoꞌó ruꞌvee yoꞌ a. Se̱ guun nucua̱j níꞌ cara̱nꞌ rá níꞌ ni̱ꞌyaj níꞌ man vi̱j ruꞌvee maꞌ. Ne̱ xa̱ꞌ soj, tza̱j ne̱ se̱ caꞌvee quiꞌya̱j suun soj cheꞌé Diose̱ ne̱ quiꞌya̱j suun soj cheꞌé nij rasu̱u̱n ma̱n rihaan chumii̱ nihánj a̱ maꞌ ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Dan me se nij síí fariseo roꞌ, me síí aranꞌ ndoꞌo rá niꞌya̱j saꞌanj, ne̱ ga̱a cuno nij soꞌ cunuda̱nj se‑na̱na̱ Jesucristó nana̱ cheꞌé rasu̱u̱n ma̱n rihaan chumii̱ nihánj, ga̱a ne̱ caꞌngaꞌ naco̱o̱ nij soꞌ niꞌya̱j nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Xa̱ꞌ soj, tza̱j ne̱ nuviꞌ cacunꞌ tumé soj niꞌya̱j yuvii̱, ꞌyaj soj maꞌ. Tza̱j ne̱ Diose̱ roꞌ, me síí neꞌen da̱j vaa nimán soj ado̱nj. ꞌO̱ se sa̱ꞌ uxrá vaa ꞌyaj yuvii̱, rá tuviꞌ yuvii̱, tza̱j ne̱ chiꞌi̱i̱ ndoꞌo ꞌyaj nij yuvii̱, rá Diose̱ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","”ꞌO̱ se ga̱a ataa caꞌna̱ꞌ síí cuꞌna̱j Juan síí cutaꞌ ne man yuvii̱ me se cuno yuvii̱ rihaan ina̱nj se‑tucua̱nj Moisés do̱ꞌ, rihaan nij síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá do̱ꞌ, tza̱j ne̱ ya̱j me se uno ndoꞌo yuvii̱ nana̱ sa̱ꞌ nana̱ cheꞌé güii gu̱un chij Diose̱ nimán yuvii̱ ma̱n rihaan chumii̱ nihánj, ne̱ me ina̱nj rá cunuda̱nj nij yuvii̱ cata̱j maꞌa̱n nij yuvii̱ da̱j quiꞌya̱j Diose̱ asa̱ꞌ guun chij Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tza̱j ne̱ ne nó xcúún níꞌ ta̱náj níꞌ a̱ ꞌó nana̱ rqué Diose̱ rihaan níꞌ canoco̱ꞌ níꞌ maꞌ. ꞌO̱ se caꞌve̱e a̱ doj quinavi̱j rej xta̱ꞌ do̱ꞌ, caꞌve̱e a̱ doj quinavi̱j chumii̱ nihánj do̱ꞌ, tza̱j ne̱ se̱ caꞌvee quinavi̱j a̱ doj nana̱ rqué Diose̱ rihaan níꞌ canoco̱ꞌ níꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Dan me se sese quiriꞌi̱j yoꞌo̱ soꞌ man nica̱ soꞌ, ne̱ sese xca̱j soꞌ man yoꞌó chana̱, ne̱ cu̱tumé soꞌ cacunꞌ, ne̱ sese xca̱j yoꞌo̱ soꞌ man chana̱ quiriꞌíj chii man, ne̱ cu̱tumé soꞌ cacunꞌ uún ado̱nj ―taj Jesucristó rihaan nij síí fariseo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ga̱a ne̱ nanó Jesucristó cuentó nihánj a: ―Ruꞌvee me yoꞌo̱ soꞌ, ne̱ yatzíj sa̱ꞌ ina̱nj cunuû soꞌ, ne̱ daj a̱ güii uun ndoꞌo nihaa sa̱ꞌ tucuá soꞌ, ne̱ guun niha̱ꞌ uxrá rá soꞌ rihaan chumii̱ nihánj a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ne̱ na̱j ꞌo̱ síí nique̱ cuꞌna̱j Lázaro rihaan yoꞌóó taꞌyaa veꞌ tucuá ruꞌvee yoꞌ, ne̱ mán ndoꞌo luj xráá síí nique̱ yoꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ne̱ guun rá síí cuꞌna̱j Lázaro cha̱ soꞌ se quinij rihaan yoꞌóó rej chá ruꞌvee yoꞌ chraa, tza̱j ne̱ da̱j doj chuvee caꞌnaꞌ chavé luj xráá soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","”Dan me se ga̱a quisíj güii caviꞌ síí nique̱ yoꞌ, ga̱a ne̱ nica̱j nij se‑mo̱zó Diose̱ man soꞌ caꞌanj soꞌ rej sa̱ꞌ, ne̱ naꞌya̱a̱n síí cuꞌna̱j Abraham man soꞌ a. Ne̱ caviꞌ ruꞌvee uún, ne̱ cachinꞌ nii man soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Dan me se caꞌanj soꞌ rihaan yaꞌan, ne̱ quiranꞌ uxrá soꞌ sayuun rihaan yaꞌan yoꞌ, ga̱a ne̱ naxca̱j soꞌ rihaan soꞌ, ne̱ queneꞌen soꞌ se vaa ga̱nꞌ ndoꞌo ne síí cuꞌna̱j Abraham, ne̱ naꞌya̱a̱n Abraham man síí cuꞌna̱j Lázaro yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ga̱a ne̱ canacúún soꞌ man síí cuꞌna̱j Abraham, cataj soꞌ: “Cunu̱u ꞌe̱e̱ rá so̱ꞌ manj, ata̱j Abraham. Ne̱ caꞌne̱j so̱ꞌ man síí cuꞌna̱j Lázaro se vaa caꞌna̱ꞌ soꞌ ne̱ ti̱guíj soꞌ raa̱ raꞌa soꞌ rque na, ne̱ tu̱cuachree soꞌ raꞌa soꞌ daa ꞌu̱nj, ga̱a ne̱ cunu̱u cui̱j do̱j raj quiꞌya̱j soꞌ, ata̱j. ꞌO̱ se naꞌaan ndoꞌo manj, ꞌyaj yaꞌan nihánj na̱nj á”, taj ruꞌvee yoꞌ rihaan síí cuꞌna̱j Abraham a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","”Tza̱j ne̱ cataj Abraham rihaan soꞌ: “Tza̱j ne̱ nanu̱j rá so̱ꞌ, taꞌni̱j, se vaa ga̱a gaa iꞌna̱ꞌ so̱ꞌ rihaan chumii̱ ne̱ nica̱j so̱ꞌ ina̱nj rasu̱u̱n sa̱ꞌ, ne̱ Lázaro me se ina̱nj rasu̱u̱n chiꞌi̱i̱ nica̱j soꞌ na̱nj á. Ne̱ cuano̱ nihánj me se uun niha̱ꞌ nimán soꞌ, ne̱ ma̱ꞌán so̱ꞌ me se ranꞌ sayuun a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ne̱ da̱nj ina̱nj uún, ne̱ nu̱u̱ ꞌo̱ yuꞌuj cunu̱u̱ ndoꞌo rej ne̱ níꞌ, ne̱ veé da̱nj se̱ caꞌvee cuchi̱ꞌ yuvii̱ ma̱n nihánj nda̱a rej ne̱ nij soj yoꞌ, ne̱ síí ma̱n yoꞌ se̱ caꞌvee caꞌna̱ꞌ rej nihánj a̱ maꞌ”, taj Abraham rihaan ruꞌvee yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","”Ne̱ cataj ruꞌvee yoꞌ rihaan Abraham a: “Cheꞌé dan qui̱ꞌyáá so̱ꞌ se ndoꞌo, ata̱j, ne̱ caꞌne̱j so̱ꞌ man síí cuꞌna̱j Lázaro caꞌa̱nj soꞌ tucuá réj, ");
INSERT INTO trcNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ne̱ vaa ꞌu̱nꞌ tinúj, ne̱ me rá ꞌu̱nj cata̱j xnaꞌanj soꞌ rihaan nij soꞌ da̱j ránꞌ ꞌu̱nj nihánj, ne̱ se̱ caꞌnaꞌ nij soꞌ uún rej ránꞌ ꞌu̱nj sayuun nihánj a̱ maꞌ”, taj ruꞌvee rihaan Abraham a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ga̱a ne̱ cataj Abraham rihaan soꞌ a: “Vaa se‑na̱na̱ síí cuꞌna̱j Moisés do̱ꞌ, se‑na̱na̱ nij síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá do̱ꞌ, nica̱j nij soꞌ á. Caꞌve̱e cuno̱ nij soꞌ nana̱ yoꞌ ei”, taj Abraham rihaan ruꞌvee a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Se̱ cuno nij soꞌ, man ata̱j Abraham. Tza̱j ne̱ sese caꞌa̱nj ꞌo̱ síí caviꞌ rihaan nij soꞌ, ga̱a ne̱ ca̱nica̱j nimán nij soꞌ canoco̱ꞌ nij soꞌ chrej sa̱ꞌ, raj a”, taj ruꞌvee rihaan Abraham a. ");
INSERT INTO trcNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","”Tza̱j ne̱ cataj Abraham rihaan soꞌ a: “Sese se̱ caꞌvej rá nij soꞌ cuno̱ nij soꞌ rihaan síí cuꞌna̱j Moisés do̱ꞌ, rihaan nij síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá do̱ꞌ, ne̱ caꞌve̱e se cunu̱u iꞌna̱ꞌ uún ꞌo̱ síí caviꞌ, tza̱j ne̱ se̱ cuchumán rá nij soꞌ ni̱ꞌyaj nij soꞌ man soꞌ a̱ maꞌ”, taj Abraham rihaan ruꞌvee yoꞌ a. ―Veé da̱nj quisíj cuentó nanó Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ga̱a ne̱ cataj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a: ―Xa̱ꞌ chumii̱ nihánj, tza̱j ne̱ ma̱n ndoꞌo chrej chiꞌi̱i̱ canoco̱ꞌ yuvii̱, ne̱ vaa yaꞌnúj uxrá rihaan nij yuvii̱ canoco̱ꞌ nij yuvii̱ chrej chiꞌi̱i̱ ado̱nj. Tza̱j ne̱ nique̱ síí ꞌyaj anocoꞌ yuvii̱ chrej chiꞌi̱i̱ yoꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Daj chiha̱a̱ míj se̱ cavii sa̱ꞌ soꞌ maꞌ. Neꞌen soj se vaa sese tocoꞌ vaj nii yuvej xi̱j váj ꞌnúú trigó man chihá yoꞌo̱ soꞌ, ne̱ sese tagüéj nii man soꞌ rque na yaꞌa̱nj, ne̱ nij uxrá vaa ranꞌ síí ꞌanj ni̱j rque na yaꞌa̱nj yoꞌ na̱nj ado̱nj. Tza̱j ne̱ nij doj quira̱nꞌ síí quiꞌyaj chiꞌi̱i̱ nimán yoꞌo̱ tuviꞌ soj síí nica̱ꞌ nimán na̱nj á. ꞌO̱ se quira̱nꞌ soꞌ sayuun nu̱ꞌ cavii nu̱ꞌ caꞌanj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","”Tu̱mé uxrá soj man soj da̱j quiꞌya̱j soj á. Sese quiꞌyaj tinúú so̱ꞌ cacunꞌ, ne̱ cata̱j so̱ꞌ rihaan soꞌ se vaa nij ndoꞌo quiꞌyaj soꞌ, ne̱ sese ca̱nica̱j nimán soꞌ ta̱náj soꞌ chrej chiꞌi̱i̱, ne̱ cara̱a̱ xꞌnaa so̱ꞌ cheꞌé cacunꞌ tumé soꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Dan me se caꞌve̱e se chi̱j ya̱ quiꞌya̱j soꞌ cacunꞌ rihaan so̱ꞌ rque o̱rúnꞌ güii, tza̱j ne̱ sese chi̱j cuchi̱ꞌ soꞌ rihaan so̱ꞌ ne̱ cata̱j soꞌ se vaa canica̱j nimán soꞌ ne̱ nij vaa cacunꞌ quiꞌyaj soꞌ rá soꞌ, ne̱ cara̱a̱ xꞌnaa so̱ꞌ rihaan soꞌ ei ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ga̱a ne̱ nij apóstol cuneꞌ Jesucristó man roꞌ, cataj chuvi̱j nij soꞌ rihaan maꞌa̱n Jesucristó si̱j ꞌni̱j raꞌa man níꞌ a: ―Cata̱j xnaꞌanj so̱ꞌ rihaan núj da̱j quiꞌya̱j núj, ga̱a ne̱ doj a̱ cuchuma̱n rá núj ni̱ꞌyaj núj Diose̱ á ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ga̱a ne̱ cataj síí ꞌni̱j raꞌa man níꞌ rihaan nij soꞌ a: ―Sese da̱j se ꞌo̱ snii̱ cuchuma̱n rá soj ni̱ꞌyaj soj man Diose̱, ne̱ sese ase vaa caân cuêj mostazá xlá ga̱a̱ cuchuma̱n rá soj, ne̱ cata̱j soj rihaan chruun se vaa cu̱riha̱nj chruun yoꞌóó rej nicu̱nꞌ chruun ne̱ caꞌa̱nj chruun canicu̱nꞌ chruun rque na yaꞌa̱nj, ne̱ cuno̱ chruun rihaan soj ei ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ga̱a ne̱ cataj uún Jesucristó rihaan nij apóstol cuneꞌ soꞌ a: ―Sese vaa mozó nu̱u̱ rihaan ꞌo̱ tuviꞌ soj, ne̱ sese ꞌyaj suun uxrá mozó uxraꞌ mozó yoꞌ yoꞌóó do̱ꞌ, sese tumé mozó yoꞌ daán soj xcuu do̱ꞌ, ne̱ da̱j cata̱j soj rihaan mozó nu̱u̱ rihaan soj asa̱ꞌ namán mozó yoꞌ caꞌanj quiꞌya̱j suun mozó tacaan ga̱. Ne̱ se̱ cataj soj rihaan mozó yoꞌ se vaa nu̱ꞌ nama̱n mozó ne̱ nu̱ꞌ ca̱yáán mozó cha̱ mozó chraa maꞌ. Daj chiha̱a̱ míj se̱ tuꞌva soj da̱nj a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ma̱a̱n se cata̱j soj: “Quiꞌya̱j chu̱vií so̱ꞌ cha̱ ꞌu̱nj chraa, ne̱ cuta̱ꞌ so̱ꞌ chraa do̱ꞌ, na do̱ꞌ, rihaan mesá rej cha̱ ꞌu̱nj chraa, ne̱ rque̱ so̱ꞌ nij rasu̱u̱n achiin manj, ne̱ asa̱ꞌ quisíj chaj chraa ga̱a ne̱ caꞌve̱e cha̱ so̱ꞌ chraa ne̱ coꞌo̱ so̱ꞌ na á”. Da̱nj caꞌmi̱i̱ soj rihaan se‑mo̱zó soj na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ne̱ se̱ caráyaꞌa̱nj soj man mozó sese quiꞌyaj suun ndoꞌo mozó yoꞌ suun caꞌneꞌ soj rihaan mozó yoꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ne̱ ase vaa mozó nu̱u̱ rihaan Diose̱ vaa soj, ne̱ cheꞌé dan asa̱ꞌ quisíj quiꞌyaj suun soj nu̱ꞌ suun caꞌneꞌ Diose̱ rihaan soj, ne̱ cata̱j soj se vaa mozó rmi̱i̱ me soj, ne̱ ina̱nj do̱ꞌ suun ataj Diose̱ rihaan soj quiꞌyaj suun soj na̱nj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Dan me se va̱j Jesucristó chrej caꞌanj chumanꞌ Jerusalén, ne̱ cachéé soꞌ chrej uun ra̱nꞌ estadó Samaria ga̱ estadó Galilea, ");
INSERT INTO trcNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ne̱ dan me se da̱j doj catu̱u̱ soꞌ ꞌo̱ chumanꞌ, ne̱ nariꞌ tuviꞌ soꞌ ga̱ chi̱ꞌ síí ranꞌ luj riꞌyuj a. Ne̱ ga̱nꞌ canicunꞌ nij soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ne̱ nucua̱j canacúún nij soꞌ man Jesucristó, ne̱ cataj nij soꞌ: ―Cunu̱u ꞌe̱e̱ rá so̱ꞌ man núj, maestró Jesucristó ―taj nij soꞌ, caguáj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ga̱a ne̱ queneꞌen Jesucristó man nij soꞌ, ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Cavi̱i̱ soj caꞌa̱nj soj, ne̱ ti̱haa̱n soj man soj rihaan nij xrej á ―taj Jesucristó rihaan nij soꞌ a. Dan me se cuno nij soꞌ nana̱ caꞌmii Jesucristó, ne̱ cavii nij soꞌ, caꞌanj nij soꞌ, ne̱ ga̱a va̱j nij soꞌ chrej, ne̱ nahuun sa̱ꞌ cunuda̱nj nij soꞌ taꞌa̱j chrej a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ne̱ yoꞌo̱ tuviꞌ nij soꞌ roꞌ, xcaj cuentá se vaa nahuun sa̱ꞌ soꞌ, ga̱a ne̱ canica̱j soꞌ caꞌanj soꞌ rej va̱j Jesucristó, ne̱ nucua̱j ndoꞌo caguáj soꞌ cataj soꞌ se vaa sa̱ꞌ uxrá quiꞌyaj Diose̱ ga̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ne̱ ga̱a cuchiꞌ soꞌ rihaan Jesucristó, ga̱a ne̱ canicunꞌ ru̱j soꞌ ne̱ nagoꞌ soꞌ graciá rihaan Jesucristó a. Ne̱ síí samaritano síí yaníj ga̱ nij yuvii̱ israelitá me soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ga̱a ne̱ cataj Jesucristó rihaan nij síí chéé ga̱ soꞌ a: ―Chi̱ꞌ ya̱ yuvii̱ nahuun sa̱ꞌ, quiꞌyáj, raj a. Ne̱ me rej va̱j yoꞌó u̱u̱n nij síí nahuun sa̱ꞌ, rá soj ga̱. ");
INSERT INTO trcNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ne̱ a̱ ꞌó nij soꞌ ne ca̱nica̱j cata̱j se vaa sa̱ꞌ uxrá quiꞌyaj Diose̱ cheꞌé soꞌ a̱ maꞌ. O̱rúnꞌ síí yaníj nihánj me síí guun rá cata̱j da̱j quiꞌyaj Diose̱ ga̱ soꞌ naꞌ ―taj Jesucristó, xnáꞌanj soꞌ man nij yuvii̱ chéé ga̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ga̱a ne̱ canica̱j Jesucristó cataj Jesucristó rihaan síí samaritano yoꞌ: ―Na̱xuma̱a̱n so̱ꞌ, ne̱ caꞌa̱nj so̱ꞌ á. Cheꞌé se amán rá so̱ꞌ niꞌya̱j so̱ꞌ Diose̱ roꞌ, cheꞌé dan a̱j nahuun sa̱ꞌ so̱ꞌ ei ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Dan me se xnáꞌanj nij síí fariseo man Jesucristó me güii gu̱un chij Diose̱ rihaan chumii̱ nihánj a. Ga̱a ne̱ cataj soꞌ rihaan nij síí fariseo a: ―Taj cheꞌé ni̱ꞌyaj ndoꞌo soj maꞌ. Caꞌve̱e se gu̱un chij Diose̱ rihaan chumii̱ nihánj, tza̱j ne̱ se̱ queneꞌen yuvii̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ne̱ se̱ cataj nii: “Ni̱ꞌyaj so̱ꞌ ei. Nihánj me guun chij Diose̱ á. Yoꞌ me rej guun chij Diose̱ á”. Se̱ caꞌmii yuvii̱ da̱nj maꞌ. ꞌO̱ se scaꞌnúj maꞌa̱n soj va̱j ꞌo̱ síí ꞌyaj uun chij Diose̱ ado̱nj ―taj Jesucristó rihaan nij síí fariseo a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ga̱a ne̱ canica̱j Jesucristó cataj soꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a: ―Vaa güii gu̱un ndoꞌo rá soj queneꞌe̱n soj güii nihánj güii va̱j ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ rihaan chumii̱ nihánj, tza̱j ne̱ se̱ caꞌvee queneꞌe̱n soj manj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ga̱a ne̱ cata̱j yuvii̱ rihaan soj: “Ni̱ꞌyaj so̱ꞌ ei. Yoꞌ me rej va̱j Jesucristó ei”. Ne̱ cata̱j uún yuvii̱: “Ni̱ꞌyaj so̱ꞌ ei. Nihánj me rej va̱j Jesucristó ei”, cata̱j yuvii̱ rihaan soj a. Tza̱j ne̱ se̱ cavii soj nano̱ꞌ soj manj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Dan me se nda̱a rá se uun ga̱a raa̱n rihaan chumii̱ nihánj, ne̱ ꞌo̱ chuguu̱n nu̱ꞌ rihaan chumii̱ nihánj roꞌ, ne̱ neꞌen cunuda̱nj yuvii̱ se vaa raa̱n rihaan chumii̱ á. Ne̱ ase uun rá soj neꞌen soj ga̱a raa̱n roꞌ, da̱nj gu̱un rá soj asa̱ꞌ caꞌnáꞌ ꞌu̱nj si̱j ni̱caj yuꞌunj man yuvii̱, ne̱ queneꞌe̱n nu̱ꞌ yuvii̱ ma̱n rihaan chumii̱ nihánj se vaa caꞌnáꞌ ꞌu̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tza̱j ne̱ vaa cheꞌé qui̱ránꞌ ꞌu̱nj queꞌe̱e̱ sayuun asino ya̱a̱n, ga̱a ne̱ vaa cheꞌé nachri̱ꞌ nij síí ma̱n rihaan chumii̱ nihánj ni̱ꞌyaj nij soꞌ manj a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","”Ne̱ ase vaa quiꞌyaj yuvii̱ ga̱a cayáán síí cuꞌna̱j Noé rihaan chumii̱ roꞌ, da̱nj ga̱a̱ quiꞌya̱j uún yuvii̱ asa̱ꞌ caꞌna̱ꞌ uún ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ rihaan chumii̱ nihánj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Dan me se chá yuvii̱ do̱ꞌ, coꞌo yuvii̱ do̱ꞌ, ne̱ xcaj tuviꞌ nij yuvii̱ do̱ꞌ, ina̱nj da̱nj quiꞌyaj nij yuvii̱ nda̱a quisíj güii catúj nij tuvi̱ꞌ síí cuꞌna̱j Noé rque rihoo xi̱j chéé rihaan na a. Ga̱a ne̱ taj niꞌyón camanꞌ ndoꞌo, ne̱ caꞌnaꞌ na yaꞌa̱nj, ne̱ caráán na yaꞌa̱nj xráá cunuda̱nj nij soꞌ, ne̱ caviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ne̱ ase vaa quiꞌyaj nij yuvii̱ ma̱n chumanꞌ cuꞌna̱j Sodoma ga̱a cayáán síí cuꞌna̱j Lot roꞌ, da̱nj quiꞌya̱j uún yuvii̱ asa̱ꞌ caꞌna̱ꞌ uún ꞌu̱nj rihaan chumii̱ nihánj ado̱nj. Dan me se chá nij soꞌ do̱ꞌ, coꞌo nij soꞌ do̱ꞌ, quiránj nij soꞌ rasu̱u̱n cutuꞌvéj nij soꞌ do̱ꞌ, cunô nij soꞌ naa̱ do̱ꞌ, cuneꞌ nij soꞌ veꞌ do̱ꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ne̱ nu̱ꞌ curiha̱nj síí cuꞌna̱j Lot chumanꞌ Sodoma, ne̱ nu̱ꞌ cavii yaꞌan rej xta̱ꞌ ga̱ yoꞌóó azufre, cayuu yoꞌ rihaan chumanꞌ yoꞌ, ne̱ cacaa nu̱ꞌ chumanꞌ yoꞌ, ne̱ caviꞌ cunuda̱nj nij síí ma̱n chumanꞌ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ne̱ ase vaa ne xca̱j nij yuvii̱ ma̱n ga̱a naá cuentá se vaa quira̱nꞌ nij soꞌ sayuun roꞌ, da̱nj ga̱a̱ uún yuvii̱ asa̱ꞌ quisíj caꞌna̱ꞌ uún ꞌu̱nj si̱j ni̱caj yuꞌunj man yuvii̱ rihaan chumii̱ nihánj ado̱nj. ꞌO̱ se nda̱a síj güii queneꞌe̱n nij soꞌ manj, ga̱a ne̱ xca̱j nij soꞌ cuentá a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","”Ne̱ güii gu̱un da̱nj me se xa̱ꞌ síí ta̱j xráá veꞌ tucuá me se se̱ caꞌvee catu̱u̱ soꞌ rá veꞌ tucuá soꞌ quiri̱i̱ soꞌ siꞌyaj soꞌ maꞌ. Ne̱ síí nu̱u̱ tacaan ꞌyaj suun tacaan roꞌ, se̱ canica̱j soꞌ nano̱ꞌ soꞌ siꞌyaj soꞌ maꞌ. Ma̱a̱n se yoꞌo̱ cuna̱nj nij soꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Vaa cheꞌé nanu̱j rá soj da̱j quiranꞌ nica̱ síí cuꞌna̱j Lot ga̱a canica̱j noꞌ niꞌya̱j noꞌ rej xco̱ noꞌ, ne̱ caviꞌ noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","”Síí chuꞌviꞌ ndoꞌo cavi̱ꞌ rihaan chumii̱ nihánj roꞌ, cavi̱ꞌ nu̱ꞌ soꞌ, ne̱ síí caviꞌ roꞌ, soꞌ me síí ga̱a̱ iꞌna̱ꞌ nimán nu̱ꞌ cavii nu̱ꞌ caꞌanj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","”Cuano̱ nihánj me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj a: Ne̱ güii gu̱un da̱nj me se rej nii̱ roꞌ, quita̱j ro̱j ni̱ca̱ ro̱j soꞌ coto̱j ro̱j soꞌ, ne̱ naca̱j se‑mo̱zó Diose̱ man yoꞌo̱ soꞌ, ne̱ quina̱j yoꞌó soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ne̱ cu̱nuû vi̱j ro̱j chana̱ ga̱j ro̱j noꞌ ꞌnúú trigó, ne̱ naca̱j se‑mo̱zó Diose̱ man yoꞌo̱ noꞌ, ne̱ quina̱j yoꞌó noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ne̱ cu̱nuû vi̱j ro̱j snóꞌo quiꞌya̱j suun ro̱j soꞌ yoꞌóó, ne̱ naca̱j se‑mo̱zó Diose̱ man yoꞌo̱ soꞌ, ne̱ quina̱j yoꞌó soꞌ na̱nj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ga̱a ne̱ xnáꞌanj nij síí tucuꞌyón se‑na̱na̱ Jesucristó man soꞌ, ne̱: ―Ne̱ me rej caꞌna̱ꞌ so̱ꞌ, ga̱ Señor ―taj nij soꞌ, xnáꞌanj nij soꞌ a. Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―A̱j neꞌen soj da̱j ꞌyaj yachrúú va̱j rej xta̱ꞌ, ne̱ neꞌen maꞌa̱n xoꞌ me rej naj nee̱ cha̱ xoꞌ a. Taj síí nataꞌ rihaan xoꞌ me rej naj nee̱ yoꞌ maꞌ. Ne̱ ase uun rá yachrúú roꞌ, da̱nj gu̱un rá maꞌa̱n soj asa̱ꞌ caꞌnaꞌ uún ꞌu̱nj rihaan chumii̱ nihánj ado̱nj. Queneꞌe̱n maꞌa̱n soj si̱j ma̱n rihaan chumii̱ nihánj me rej caꞌna̱ꞌ ꞌu̱nj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ne̱ nanó Jesucristó cuentó nihánj rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ, cheꞌé rej guun rá soꞌ xca̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ cuentá se vaa no̱ xcúún nij soꞌ niga̱nj cachi̱nj niꞌya̱j nij soꞌ rihaan Diose̱, ne̱ se̱ guun rmi̱i̱ nij soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Dan me se cataj Jesucristó a: ―ꞌO̱ cuese̱ cayáán rque ꞌo̱ chumanꞌ me yoꞌo̱ soꞌ, ne̱ nuveé si̱j amán rá niꞌya̱j man Diose̱ do̱ꞌ, nuveé si̱j aráj cochro̱j rihaan yuvii̱ do̱ꞌ, me cuese̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ne̱ yáán ꞌo̱ chana̱ caviꞌ nica̱ chumanꞌ yoꞌ, ne̱ guun cheꞌe̱ noꞌ cachíín niꞌya̱j noꞌ rihaan soꞌ se vaa quiꞌya̱j soꞌ sayuun man síí quiꞌyaj sayuun man noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ne̱ a̱ doj ne caꞌve̱j rá soꞌ ra̱cuíj soꞌ man noꞌ a. Tza̱j ne̱ ꞌo̱ güii me se guun rá maꞌa̱n cuese̱ yoꞌ, ne̱: “Caꞌve̱e se ne amán raj niꞌya̱j ꞌu̱nj Diose̱ do̱ꞌ, caꞌve̱e se ne aráj co̱chrój rihaan yuvii̱ do̱ꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tza̱j ne̱ cheꞌé se guun rmi̱i̱ ndoꞌoj ꞌyaj chana̱ caviꞌ nica̱ nihánj, ne̱ cheꞌé dan caꞌne̱ꞌ ca̱chríí ꞌu̱nj cacunꞌ cheꞌé síí ꞌyaj sayuun man noꞌ, ne̱ caꞌve̱e a. Se taj, ne̱ gu̱un rmi̱i̱ xréé ꞌu̱nj, quiꞌya̱j noꞌ vaa güii ado̱nj”, guun rá cuese̱ yoꞌ a ");
INSERT INTO trcNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","―taj síí ꞌni̱j raꞌa man níꞌ, ne̱ cataj uún soꞌ― Xca̱j soj cuentá da̱j caꞌmii cuese̱ vaa quij nimán yoꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ne̱ dan me se táá a̱ nij síí narii Diose̱, ne̱ nuvi̱i niga̱nꞌ aguáj ndoꞌo nij soꞌ, achíín niꞌya̱j nij soꞌ rihaan Diose̱, ne̱ Diose̱, tza̱j ne̱ se̱ caꞌneꞌ Diose̱ cacunꞌ cheꞌé nij síí ꞌyaj sayuun man nij soꞌ, rá soj naꞌ. Gu̱un ra̱a̱n ndoꞌo Diose̱ caꞌne̱ꞌ soꞌ cacunꞌ, rá soj naꞌ. Se̱ guun da̱nj rá soj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ꞌO̱ se cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa raꞌya̱nj uxrá caꞌne̱ꞌ Diose̱ cacunꞌ cheꞌé nij síí ꞌyaj sayuun man nij síí narii soꞌ man ado̱nj. Tza̱j ne̱ dan me se asa̱ꞌ caꞌnaꞌ uún ꞌu̱nj si̱j ni̱caj yuꞌunj man yuvii̱ rihaan chumii̱ nihánj, ne̱ me daj yuvii̱ amán rá niꞌya̱j man Diose̱ nari̱j ga̱ ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ga̱a ne̱ nanó Jesucristó cuentó nihánj rihaan taꞌa̱j yuvii̱ guun rá se vaa si̱j sa̱ꞌ ina̱nj me maꞌa̱n nij soꞌ ne̱ nachriꞌ nij soꞌ niꞌya̱j nij soꞌ man yoꞌó yuvii̱ a: ");
INSERT INTO trcNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Canicunꞌ vi̱j snóꞌo rá nuvií noco̱o, cachíín niꞌya̱j ro̱j soꞌ rihaan Diose̱ a. Yoꞌo̱ soꞌ roꞌ, me síí fariseo, ne̱ yoꞌó soꞌ roꞌ, me síí tihaꞌ yuꞌunj man yuvii̱ cheꞌé puextó a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","”Dan me se canicunꞌ síí fariseo yoꞌ, ne̱ cachíín niꞌya̱j soꞌ, ne̱ cataj soꞌ nana̱ nihánj rihaan Diose̱ a. ꞌO̱ se ne caꞌmi̱i̱ nucua̱j soꞌ maꞌ. Ma̱a̱n se rihaan maꞌa̱n soꞌ caꞌmii soꞌ, cataj soꞌ: “Guun niꞌya̱j uxrá níꞌ, Ata̱j Diose̱. Guun niꞌya̱j uxrá níꞌ se vaa ne ꞌyáá ꞌu̱nj nda̱a vaa ꞌyaj yoꞌó nij yuvii̱ maꞌ. Dan me se xa̱ꞌ nij soꞌ, tza̱j ne̱ si̱j tihaꞌ yuꞌunj do̱ꞌ, si̱j tumé cacunꞌ do̱ꞌ, si̱j otoj ga̱ nica̱ yoꞌó yuvii̱ do̱ꞌ, me nij soꞌ, ne̱ ne ꞌyáá ꞌu̱nj da̱nj maꞌ. Ne̱ guun niꞌya̱j níꞌ se vaa ne ꞌyáá ꞌu̱nj nda̱a vaa ꞌyaj síí nihánj síí tihaꞌ yuꞌunj man yuvii̱ cheꞌé puextó a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ne̱ vi̱j ya̱ aráj gue̱e̱ ꞌu̱nj cheꞌé se chá ꞌo̱ ꞌo̱ tu̱nj güii, ne̱ rqué ꞌu̱nj ꞌo̱ pesó rihaan daj a̱ chi̱ꞌ pesó ꞌyaj canaán ꞌu̱nj rihaan so̱ꞌ ei”, taj síí fariseo yoꞌ rihaan Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","”Ne̱ ga̱nꞌ do̱j tzinꞌ nicunꞌ síí aꞌnéj puextó man yuvii̱ yoꞌ, ne̱ guun naꞌa̱j ndoꞌo soꞌ niꞌya̱j soꞌ man soꞌ rihaan Diose̱, ne̱ ne caꞌve̱j rá soꞌ na̱xcaj soꞌ rihaan soꞌ ni̱ꞌyaj soꞌ rej nicu̱nꞌ Diose̱ a. Tza̱j ne̱ goꞌ soꞌ se‑cuxru̱ꞌ soꞌ rucua̱a̱ maꞌa̱n soꞌ, ne̱ cataj soꞌ: “Cunu̱u ꞌe̱e̱ rá so̱ꞌ ni̱ꞌyaj so̱ꞌ manj, Ata̱j Diose̱. ꞌO̱ se si̱j tumé cacunꞌ mej ado̱nj”, taj soꞌ rihaan Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","”Ne̱ cuano̱ nihánj me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa ga̱a quinanꞌ síí tihaꞌ yuꞌunj man yuvii̱ cheꞌé puextó yoꞌ tucuá soꞌ, ga̱a ne̱ a̱j cunuu sa̱ꞌ soꞌ rihaan Diose̱ na̱nj á. Tza̱j ne̱ yoꞌó soꞌ roꞌ, taj maꞌ. ꞌO̱ se xa̱ꞌ síí me rá ta̱cavii sa̱ꞌ man maꞌa̱n, tza̱j ne̱ quiri̱ꞌ soꞌ, ne̱ gu̱un naꞌa̱j soꞌ a. Ne̱ xa̱ꞌ síí naquiꞌyaj nica̱ꞌ nimán, tza̱j ne̱ cavi̱i̱ sa̱ꞌ ndoꞌo soꞌ ado̱nj ―taj Jesucristó rihaan nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ga̱a ne̱ nica̱j nij yuvii̱ man nij neꞌej caꞌnaꞌ nij yuvii̱ rihaan Jesucristó a. ꞌO̱ se me rá nij yuvii̱ cuta̱ꞌ Jesucristó raꞌa soꞌ raa̱ nij neꞌej cheꞌé rej quiri̱ꞌ neꞌej xnaꞌanj niꞌya̱j neꞌej a. Tza̱j ne̱ queneꞌen nij síí tucuꞌyón se‑na̱na̱ Jesucristó da̱j quiꞌyaj nij yuvii̱, ga̱a ne̱ cataj xnaꞌanj nij soꞌ rihaan nij yuvii̱ se vaa ne nó xcúún nij neꞌej caꞌna̱ꞌ nij neꞌej rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tza̱j ne̱ canacúún Jesucristó man nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Caꞌne̱ꞌ rá soj caꞌna̱ꞌ nij neꞌej rihanj á. Se̱ caráán soj chrej rihaan nij neꞌej mei. ꞌO̱ se tucua̱ nij síí vaa da̱nj roꞌ, me rej ya̱nj Diose̱ uun chij Diose̱ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa síí naꞌvej rá gu̱un chij Diose̱ nimán, nda̱a vaa aꞌvej rá neꞌej gu̱un chij Diose̱ nimán neꞌej roꞌ, daj chiha̱a̱ míj se̱ cayáán soꞌ ga̱ Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj maꞌ ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Dan me se xnáꞌanj ꞌo̱ síí nica̱j suun yoꞌ man Jesucristó, cataj soꞌ rihaan Jesucristó a: ―Maestro. Síí sa̱ꞌ uxrá mé so̱ꞌ ado̱nj. Da̱j qui̱ꞌyáj, ne̱ caꞌve̱e ca̱yánj ga̱ Diose̱ nu̱ꞌ cavii nu̱ꞌ caꞌanj ga̱ ―taj síí nica̱j suun yoꞌ, xnáꞌanj soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Me cheꞌé cataj so̱ꞌ se vaa síí sa̱ꞌ uxrá mej ga̱. ꞌO̱ se o̱rúnꞌ Diose̱ me síí sa̱ꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ne̱ a̱j neꞌén so̱ꞌ nij nana̱ noco̱o ya̱ ya̱ nana̱ cataj xnaꞌanj Diose̱ se vaa canoco̱ꞌ níꞌ á. Dan me se taj nana̱ yoꞌ: “Se̱ cotoj so̱ꞌ ga̱ chana̱ nica̱ yoꞌó yuvii̱ maꞌ. Se̱ ticavíꞌ so̱ꞌ yuvii̱ maꞌ. Se̱ quiꞌyaj itu̱u̱ so̱ꞌ siꞌyaj yoꞌó yuvii̱ maꞌ. Se̱ nanó so̱ꞌ cuentó ne̱ cheꞌé yuvii̱ maꞌ. Cara̱a̱ co̱chróó so̱ꞌ rihaan réé so̱ꞌ do̱ꞌ, rihaan nií so̱ꞌ do̱ꞌ á”. Yoꞌ me nana̱ cu̱nó so̱ꞌ ei ―taj Jesucristó rihaan síí nica̱j suun yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","―Asi̱j ga̱a mej xnii me veꞌé unó ꞌu̱nj nu̱ꞌ nij nana̱ yoꞌ na̱nj á ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Da̱j o̱rúnꞌ rasu̱u̱n achiin ya̱ mán so̱ꞌ na̱nj ei. Dan me se cutuꞌve̱e̱ so̱ꞌ cunuda̱nj siꞌyáá so̱ꞌ, ne̱ saꞌanj quiri̱ꞌ so̱ꞌ roꞌ, caxri̱i̱ so̱ꞌ ston nij síí nique̱, ne̱ cuma̱n ndoꞌo siꞌyáá so̱ꞌ rej xta̱ꞌ, quiꞌya̱j Diose̱ na̱nj ei. Ne̱ dan me se caꞌna̱ꞌ so̱ꞌ, ne̱ ca̱nocóꞌ so̱ꞌ manj, caꞌa̱nj níꞌ á ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Dan me se cuno síí nica̱j suun yoꞌ nana̱ nihánj, ga̱a ne̱ quinanó ndoꞌo rá soꞌ a. ꞌO̱ se síí ruꞌvee ndoꞌo me soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Dan me se niꞌya̱j Jesucristó man soꞌ, ne̱ cataj Jesucristó: ―Sayu̱u̱n uxrá vaa quisi̱j nij síí vaa ndoꞌo saꞌanj rihaan ca̱yáán nij soꞌ ga̱ Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Dan me se neꞌen soj se vaa sayu̱u̱n ndoꞌo vaa cache̱n xcuu camelló yuꞌuj ta̱j tacúún cúú nuvá, tza̱j ne̱ caꞌve̱e a̱ doj cache̱n xcuu yoꞌ yuꞌuj ta̱j tacúún cúú nuvá, nda̱a rá se vaa síí ruꞌvee, ne̱ se̱ guun cache̱n maꞌa̱n síí ruꞌvee ca̱yáán soꞌ ga̱ Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj a̱ maꞌ ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ga̱a ne̱ xnáꞌanj nij síí cuno nana̱ nihánj man Jesucristó, cataj nij soꞌ: ―Cheꞌé dan me se me síí gu̱un nucua̱j quinani̱i̱ rihaan sayuun ga̱ ―taj nij soꞌ, xnáꞌanj nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Xa̱ꞌ rasu̱u̱n naꞌvee quiꞌya̱j maꞌa̱n ina̱nj yuvii̱, tza̱j ne̱ Diose̱ me síí uun nucua̱j quiꞌya̱j nu̱ꞌ rasu̱u̱n yoꞌ ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ga̱a ne̱ cataj Pedró rihaan soꞌ a: ―Ne̱ núj ga̱. A̱j tanáj núj nu̱ꞌ siꞌyaj núj, ne̱ canocoꞌ núj mán so̱ꞌ á ―taj Pedró rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Cuano̱ nihánj me se cata̱j yá ꞌu̱nj rihaan soj se vaa síí tanáj veꞌ tucuá tanáj nica̱ tanáj tinúú tanáj tuviꞌ tanáj taꞌníí tanáj, cheꞌé rej gu̱un chij Diose̱ rihaan chumii̱ nihánj roꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","uxrá doj a̱ rasu̱u̱n quiri̱ꞌ uún soꞌ ga̱a vaa iꞌna̱ꞌ soꞌ rihaan chumii̱ nihánj, ne̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj me se yoꞌo̱ ca̱yáán soꞌ ga̱ Diose̱ nu̱ꞌ cavii nu̱ꞌ caꞌanj na̱nj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Dan me se nica̱j Jesucristó chuvi̱j nij síí tucuꞌyón se‑na̱na̱ soꞌ caꞌanj soꞌ, ne̱ cataj soꞌ rihaan nij soꞌ: ―Nihánj me caꞌanj níꞌ chumanꞌ Jerusalén, ne̱ asa̱ꞌ cuchiꞌ níꞌ, ne̱ quisi̱j ya̱ nu̱ꞌ nana̱ cataj xnaꞌanj nij síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá cheꞌé ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱, ");
INSERT INTO trcNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ne̱ dan me se ta̱cuachén nii manj rihaan nij síí yaníj, ne̱ caꞌnga̱ꞌ naco̱o̱ nij soꞌ queneꞌe̱n nij soꞌ manj, ne̱ quiꞌya̱j chiꞌi̱i̱ nij soꞌ manj, ne̱ quiri̱i̱ talúj nij soꞌ manj, ");
INSERT INTO trcNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ne̱ go̱ꞌ nij soꞌ cuartá xráj, ga̱a ne̱ ticavi̱ꞌ nij soꞌ manj a. Ga̱a ne̱ cache̱n vaꞌnu̱j güii, ga̱a ne̱ cunu̱u iꞌna̱ꞌ uún ꞌu̱nj, quiꞌya̱j Diose̱ ei ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ne̱ ne queneꞌe̱n uxrá nij soꞌ me cheꞌé caꞌmii Jesucristó da̱nj maꞌ. ꞌO̱ se ne caꞌve̱e xca̱j nij soꞌ cuentá cheꞌé nana̱ yoꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Dan me se ga̱a quinichrunꞌ Jesucristó chumanꞌ Jericó, ne̱ yáán ꞌo̱ síí tuchri̱i tuꞌva chrej, ne̱ achíín soꞌ caridad rihaan yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Dan me se cuno síí tuchri̱i yoꞌ se vaa cachén ndoꞌo yuvii̱ chrej rej ne̱ soꞌ, ne̱ cheꞌé dan xnáꞌanj soꞌ man yuvii̱ cheꞌé rej va̱j ndoꞌo yuvii̱ chrej yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ga̱a ne̱ cataj xnaꞌanj nii rihaan soꞌ se vaa Jesucristó síí cavii chumanꞌ Nazaret me síí achén rej ne̱ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ga̱a ne̱ dan me se caguáj síí tuchri̱i yoꞌ, cataj soꞌ: ―Ya̱ ya̱ taꞌníí taꞌnij siꞌno̱ síí cuꞌna̱j David síí cane ga̱a naá mé so̱ꞌ, Jesús. Cunu̱u ꞌe̱e̱ rá so̱ꞌ manj ei ―taj soꞌ, caguáj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ga̱a ne̱ cataj nij síí racuíj man soꞌ chéé soꞌ se vaa se̱ tuꞌva soꞌ da̱nj, ma̱a̱n se: ―Dínj ga̱a̱ tuꞌvá so̱ꞌ á ―taj nij soꞌ rihaan síí tuchri̱i, tza̱j ne̱ doj a̱ nucua̱j caguáj soꞌ, cataj soꞌ: ―Taꞌníí taꞌnij siꞌno̱ síí cuꞌna̱j David mé so̱ꞌ ei. Cunu̱u ꞌe̱e̱ rá so̱ꞌ manj ei ―taj soꞌ, caguáj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Canicunꞌ Jesucristó, ne̱ canacúún Jesucristó man síí tuchri̱i se vaa ra̱cuíj nii man soꞌ caꞌna̱ꞌ soꞌ rihaan Jesucristó a. Ne̱ ga̱a quinichrunꞌ síí tuchri̱i yoꞌ rihaan Jesucristó, ne̱ xnáꞌanj Jesucristó man soꞌ, cataj Jesucristó rihaan soꞌ a: ");
INSERT INTO trcNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―Da̱j qui̱ꞌyáj mán so̱ꞌ, rá so̱ꞌ ga̱ ―taj Jesucristó, xnáꞌanj Jesucristó man soꞌ a. ―Curuvi̱ꞌ rihanj raj, Señor ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ: ―Caꞌve̱e curuvi̱ꞌ rihaan so̱ꞌ á. Ma̱a̱n cheꞌé se amán rá so̱ꞌ niꞌya̱j so̱ꞌ manj roꞌ, cheꞌé dan nahuun sa̱ꞌ so̱ꞌ ei ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ne̱ nu̱ꞌ curuviꞌ rihaan soꞌ, ga̱a ne̱ canocoꞌ soꞌ xcó Jesucristó, ne̱ nataꞌ soꞌ se vaa sa̱ꞌ uxrá quiꞌyaj Diose̱ ga̱ soꞌ a. Ne̱ nu̱ꞌ nij yuvii̱ queneꞌen da̱j quiranꞌ soꞌ cataj se vaa sa̱ꞌ uxrá quiꞌyaj Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Dan me se catúj Jesucristó chumanꞌ Jericó, ne̱ cachén soꞌ chumanꞌ yoꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ne̱ yáán ꞌo̱ síí cuꞌna̱j Zaqueo chumanꞌ yoꞌ, ne̱ soꞌ me síí uun chij rihaan nij síí tihaꞌ yuꞌunj man yuvii̱ cheꞌé puextó, ne̱ ruꞌve̱e̱ ndoꞌo soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Dan me se guun rá soꞌ queneꞌe̱n soꞌ me síí me Jesucristó, tza̱j ne̱ ne caꞌve̱e queneꞌe̱n soꞌ, cheꞌé se ma̱n ndoꞌo yuvii̱, ne̱ síí chre̱ꞌ nii vaa síí cuꞌna̱j Zaqueo a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Cheꞌé dan yo̱o cunánj soꞌ quitáá ya̱a̱n soꞌ rihaan nij yuvii̱, ga̱a ne̱ cavii soꞌ raa̱ ꞌo̱ chruun ma̱n chruj higó raa̱, cheꞌé yan me rá soꞌ queneꞌe̱n soꞌ man Jesucristó a. ꞌO̱ se cache̱n Jesucristó tacóó chruun yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Dan me se ga̱a cuchiꞌ Jesucristó tacóó chruun ta̱j Zaqueo, ne̱ niꞌya̱j Jesucristó raa̱ chruun, ne̱ cataj soꞌ rihaan Zaqueo a: ―Nani̱j so̱ꞌ cuaj rihaan yoꞌóó, Zaqueo. ꞌO̱ se vaa cheꞌé ndoꞌo ca̱ránꞌ ꞌu̱nj veꞌ tucuá so̱ꞌ cuanꞌ á ―taj Jesucristó rihaan Zaqueo a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ga̱a ne̱ yo̱o nanij Zaqueo rihaan yoꞌóó, ne̱ guun niha̱ꞌ uxrá rá soꞌ se vaa cara̱nꞌ Jesucristó tucuá soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Dan me se cuno nij yuvii̱ da̱j cataj Jesucristó, ga̱a ne̱ nij caꞌmii nij yuvii̱ niꞌya̱j nij soꞌ man Jesucristó a. Ne̱ cataj nij soꞌ cheꞌé Jesucristó a: ―Nihánj me se cara̱nꞌ soꞌ tucuá ꞌo̱ síí tumé ndoꞌo cacunꞌ ado̱nj ―taj nij yuvii̱ niꞌya̱j nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tza̱j ne̱ canicunꞌ maꞌa̱n Zaqueo, cataj soꞌ rihaan síí ꞌni̱j raꞌa man níꞌ a: ―Cuano̱ nihánj me se rque̱ ꞌu̱nj yane̱j siꞌyáj rihaan nij síí nique̱, ne̱ nij síí tihaꞌ yuꞌunj ꞌu̱nj man, tza̱j ne̱ na̱quiꞌyáj ꞌó cunu̱ꞌ caꞌa̱nj narque̱ ꞌu̱nj rihaan nij soꞌ se vaa caꞌnéj ꞌu̱nj man nij soꞌ, Señor ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Cuanꞌ me se a̱j cavii sa̱ꞌ nij tucua̱ síí nihánj, nda̱a rá se vaa ꞌo̱ taꞌníí síí cuꞌna̱j Abraham ga̱a naá roꞌ, da̱nj vaa maꞌa̱n soꞌ cuano̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ꞌO̱ se caꞌnáꞌ ꞌu̱nj si̱j nica̱j yuꞌunj man yuvii̱ cheꞌé rej caꞌve̱e nano̱ꞌ ꞌu̱nj man nij síí caꞌanj niꞌya̱, ne̱ cavi̱i̱ sa̱ꞌ nij soꞌ qui̱ꞌyáj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Dan me se cuno nij síí ma̱n chumanꞌ Jericó se‑na̱na̱ Jesucristó, tza̱j ne̱ guun rá nij soꞌ se vaa cheꞌé se nichrunꞌ Jesucristó chumanꞌ Jerusalén, cheꞌé dan raꞌya̱nj gu̱un chij Diose̱ rihaan chumii̱ nihánj ado̱nj, rá nij soꞌ, ne̱ cheꞌé dan guun cheꞌe̱ Jesucristó naquiꞌyaj Jesucristó yoꞌo̱ cuentó nihánj, ga̱a ne̱ caꞌve̱e xca̱j nij yuvii̱ cuentá a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Dan me se cataj soꞌ a: ―Yoꞌo̱ síí xnaꞌa̱nj ruꞌvee guun rá quina̱j suun uun chij chiháán, ne̱ guun rá soꞌ caꞌa̱nj soꞌ chumanꞌ ra̱a̱ ne̱ na̱ta̱ suun soꞌ suun gu̱un chij chiháán soꞌ, ga̱a ne̱ ca̱nica̱j soꞌ nama̱n soꞌ chiháán soꞌ, rá soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ga̱a ne̱ canacúún soꞌ man chi̱ꞌ nij se‑mo̱zó soꞌ caꞌna̱ꞌ rihaan soꞌ, ga̱a ne̱ rqué soꞌ ꞌo̱ saꞌanj mina rihaan ꞌo̱ ꞌo̱ nij soꞌ, ne̱ cataj xnaꞌanj soꞌ rihaan nij soꞌ se vaa quiꞌya̱j suun nij soꞌ ga̱ saꞌanj, ne̱ tanaca̱ nij soꞌ man saꞌanj, ne̱ nda̱a quisi̱j güii nama̱n uún soꞌ, ga̱a ne̱ nuchru̱j nij soꞌ cuentá, taj soꞌ a. Da̱nj caꞌmii soꞌ, ga̱a ne̱ cavii soꞌ caꞌanj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","”Tza̱j ne̱ nij síí ma̱n chiháán soꞌ roꞌ, quitáá riꞌyunj man soꞌ, ne̱ cheꞌé dan caꞌnéé nij soꞌ síí caꞌanj suun caꞌanj cata̱j xnaꞌanj rihaan síí nica̱j suun rej caꞌanj síí xnaꞌa̱nj ruꞌvee yoꞌ se vaa ne caꞌve̱j rá nij soꞌ gu̱un chij síí xnaꞌa̱nj ruꞌvee yoꞌ rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","”Dan me se ya̱ quiꞌyaj canaán síí xnaꞌa̱nj ruꞌvee yoꞌ guun chij soꞌ chiháán soꞌ, ga̱a ne̱ ga̱a namán soꞌ, ne̱ cataj xnaꞌanj soꞌ se vaa nacu̱nj nii man chi̱ꞌ nij se‑mo̱zó soꞌ nij síí rqué soꞌ saꞌanj rihaan a. ꞌO̱ se guun rá soꞌ xca̱j soꞌ cuentá me daj saꞌanj quiꞌyaj canaán nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","”Dan me se síí caꞌnaꞌ asino ya̱a̱n rihaan soꞌ roꞌ, cataj: “Xa̱ꞌ saꞌanj mina rqué so̱ꞌ manj, tza̱j ne̱ quiꞌyaj canaán ꞌu̱nj ꞌó chi̱ꞌ saꞌanj mina uún, quiꞌyaj saꞌanj yoꞌ, señor”, taj soꞌ rihaan síí xnaꞌa̱nj ruꞌvee yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ga̱a ne̱ cataj síí xnaꞌa̱nj ruꞌvee yoꞌ rihaan mozó yoꞌ: “Cuna̱j uxrá quiꞌyáá so̱ꞌ á. Mozó sa̱ꞌ ina̱nj mé so̱ꞌ ei. Cheꞌé dan gu̱un chij so̱ꞌ rihaan chi̱ꞌ ya̱ chumanꞌ, qui̱ꞌyáj a”, taj síí xnaꞌa̱nj ruꞌvee rihaan mozó sa̱ꞌ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","”Dan me se caꞌnaꞌ uún yoꞌó mozó, cataj soꞌ: “Xa̱ꞌ saꞌanj mina rqué so̱ꞌ manj, tza̱j ne̱ quiꞌyaj canaán ꞌu̱nj yuꞌunꞌ saꞌanj mina uún, quiꞌyaj saꞌanj yoꞌ, señor”, taj soꞌ rihaan síí xnaꞌa̱nj ruꞌvee yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ne̱ cataj síí xnaꞌa̱nj rihaan soꞌ: “Ga̱a ne̱ gu̱un chij so̱ꞌ rihaan ꞌu̱nꞌ ya̱ chumanꞌ na̱nj ei”, taj soꞌ rihaan yoꞌó mozó yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","”Dan me se caꞌnaꞌ yoꞌó soꞌ uún, ne̱ cataj soꞌ: “Nihánj me naca̱j so̱ꞌ se‑saꞌa̱nj so̱ꞌ, señor. ꞌO̱ se caraa sa̱ꞌ ꞌu̱nj man yoꞌ rque ꞌo̱ vitó, ");
INSERT INTO trcNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ne̱ cuchuꞌvíꞌ ꞌu̱nj niꞌya̱j ꞌu̱nj mán so̱ꞌ, cheꞌé se si̱j sca̱ꞌ ndoꞌo nimán mé so̱ꞌ, ne̱ naxca̱j so̱ꞌ rasu̱u̱n rej nuviꞌ rasu̱u̱n cutáꞌ so̱ꞌ, ne̱ yoꞌó yuvii̱ unô caân, ne̱ so̱ꞌ me se, ne̱ ma̱ꞌán so̱ꞌ, ne̱ rii so̱ꞌ naa̱ ado̱nj”, taj mozó yoꞌ rihaan síí xnaꞌa̱nj ruꞌvee yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","”Ga̱a ne̱ cataj síí xnaꞌa̱nj ruꞌvee rihaan mozó yoꞌ: “Mozó chiꞌi̱i̱ nimán mé so̱ꞌ ei. Cuta̱ꞌ ꞌu̱nj cacunꞌ xráá so̱ꞌ cheꞌé nana̱ tuꞌva ma̱ꞌán so̱ꞌ á. ꞌO̱ se queneꞌén so̱ꞌ se vaa si̱j sca̱ꞌ ndoꞌo nimán mej, ne̱ queneꞌén so̱ꞌ se vaa naxca̱j ꞌu̱nj rasu̱u̱n rej nuviꞌ rasu̱u̱n cutaj, ne̱ queneꞌén so̱ꞌ se vaa yoꞌó yuvii̱ unô caân ne̱ ꞌu̱nj rii naa̱ na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Cheꞌé dan me cheꞌé ne ta̱cuachén so̱ꞌ se‑saꞌa̱nj ꞌu̱nj rihaan nij síí nutaꞌ saꞌanj ga̱. Ga̱a ne̱ ga̱a caꞌnáꞌ ꞌu̱nj, ne̱ nacaj ꞌu̱nj se‑saꞌa̱nj ꞌu̱nj ga̱ saꞌanj nataꞌ raa̱ yoꞌ ga̱”, taj síí xnaꞌa̱nj ruꞌvee yoꞌ rihaan mozó rmi̱i̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ga̱a ne̱ cataj soꞌ rihaan yoꞌó nij síí nicu̱nꞌ ga̱ soꞌ a: “Caꞌne̱e̱ soj saꞌanj nica̱j mozó chiꞌi̱i̱ nihánj, ne̱ ta̱cuachén soj rihaan síí nica̱j chi̱ꞌ saꞌanj mina yoꞌ á”, taj síí xnaꞌa̱nj ruꞌvee yoꞌ rihaan yoꞌó nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Tza̱j ne̱ a̱j nica̱j soꞌ ꞌo̱ chi̱ꞌ vaa gue̱e̱ á”, cataj nij soꞌ rihaan síí xnaꞌa̱nj ruꞌvee yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Taj se ꞌyaj maꞌ. Cuano̱ nihánj me se cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa síí neꞌen sa̱ꞌ quiꞌya̱j suun rihanj roꞌ, ne̱ vaa güii, ne̱ doj a̱ gu̱un nucua̱j soꞌ quiꞌya̱j suun soꞌ ado̱nj. Ne̱ síí ne neꞌen quiꞌya̱j suun rihanj roꞌ, caꞌne̱e̱ ꞌu̱nj suun leꞌe̱j nii ata̱ soꞌ, ne̱ quina̱j u̱u̱n soꞌ ado̱nj”, taj síí xnaꞌa̱nj ruꞌvee yoꞌ rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ga̱a ne̱ cataj uún soꞌ: “Tza̱j ne̱ xa̱ꞌ nij síí ta̱j riꞌyunj manj síí ne caꞌve̱j rá gu̱un chij ꞌu̱nj rihaan, tza̱j ne̱ ni̱caj soj man nij soꞌ caꞌna̱ꞌ soj rihanj, ga̱a ne̱ ticavi̱ꞌ soj man nij soꞌ rihanj nihánj ei”, taj uún soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","―Veé da̱nj quisíj cuentó nanó Jesucristó a. Ga̱a ne̱ cavii soꞌ caꞌanj soꞌ chumanꞌ Jerusalén, ne̱ táá ya̱a̱n soꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Dan me quinichrunꞌ Jesucristó ro̱j chumanꞌ cuꞌna̱j Betfagé ga̱ Betania a. Na̱j ro̱j chumanꞌ yoꞌ tacóó quij cuꞌna̱j Quij ma̱n Chruun Olivó a. Ga̱a ne̱ caꞌnéé Jesucristó man vi̱j tuviꞌ nij síí tucuꞌyón se‑na̱na̱ soꞌ caꞌa̱nj rque chumanꞌ Betfagé, ");
INSERT INTO trcNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ne̱ cataj soꞌ rihaan ro̱j soꞌ a: ―Cavi̱i̱ ro̱j so̱j caꞌa̱nj soj, ne̱ catu̱u̱ ro̱j so̱j chumanꞌ nihánj chumanꞌ na̱j rihaan níꞌ, ne̱ asa̱ꞌ catúj ro̱j so̱j, ne̱ nari̱ꞌ ro̱j so̱j man yoꞌo̱ burró leꞌe̱j yaꞌa̱nj numi̱i a. Dan me se nache̱ ro̱j so̱j man xoꞌ, ne̱ ni̱caj ro̱j so̱j caꞌna̱ꞌ ro̱j so̱j rihanj nihánj á. ");
INSERT INTO trcNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ne̱ sese xna̱ꞌanj nii man ro̱j so̱j me cheꞌé nache ro̱j so̱j burró, ne̱ cata̱j ro̱j so̱j: “Síí ꞌni̱j raꞌa man níꞌ achiin xcuu nihánj rihaan chugua̱nj”, cata̱j ro̱j so̱j á ―taj Jesucristó rihaan ro̱j síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Dan me se caꞌanj ro̱j soꞌ, ne̱ catúj ro̱j soꞌ chumanꞌ yoꞌ, ne̱ nariꞌ ro̱j soꞌ man burró leꞌe̱j, nda̱a vaa cataj xnaꞌanj Jesucristó rihaan ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ne̱ ga̱a nache ro̱j soꞌ man burró, ne̱ xnáꞌanj nij síí da̱a̱n burró man ro̱j soꞌ a: ―Me cheꞌé nache soj burró ga̱ ―taj nij soꞌ, xnáꞌanj nij soꞌ man ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ga̱a ne̱ cataj ro̱j soꞌ rihaan nij síí da̱a̱n burró a: ―Síí ꞌni̱j raꞌa man níꞌ achiin xcuu nihánj rihaan chugua̱nj ―taj ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ga̱a ne̱ nica̱j ro̱j soꞌ xcuu caꞌnaꞌ ro̱j soꞌ rihaan Jesucristó, ne̱ cutaꞌ ro̱j soꞌ saga̱nꞌ ro̱j soꞌ xráá burró, ne̱ tacavii ro̱j soꞌ man Jesucristó xráá burró yoꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ne̱ ga̱a va̱j Jesucristó, ne̱ cuchruj ndoꞌo nij yuvii̱ yatzíj saga̱nꞌ nij soꞌ rá chrej, ne̱ achén Jesucristó ga̱ burró yoꞌ rihaan yatzíj a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Dan me se quinichrunꞌ Jesucristó chumanꞌ Jerusalén, ne̱ va̱j soꞌ tacóó Quij ma̱n Chruun Olivó rej va̱j ni̱j chrej, ne̱ guun cheꞌe̱ queꞌe̱e̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ guun niha̱ꞌ rá nij soꞌ, ne̱ aguáj nij soꞌ, caꞌmii sa̱ꞌ nij soꞌ cheꞌé Diose̱ cheꞌé nu̱ꞌ nij suun sa̱ꞌ noco̱o quiꞌyaj Jesucristó queneꞌen nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Dan me se cataj nij soꞌ: ―Cuna̱j uxrá vaa caꞌnaꞌ síí caꞌnéé síí ꞌni̱j raꞌa man níꞌ ei. Síí nica̱j suun rey uun chij rihaan níꞌ me soꞌ ei. Veꞌé ca̱yáán Diose̱ síí nicu̱nꞌ xta̱ꞌ á. Cuna̱j uxrá ꞌyaj soꞌ ei ―taj nij yuvii̱, caguáj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Dan me se taꞌa̱j nij síí chéé ga̱ Jesucristó me síí fariseo, ne̱ taꞌa̱j nij soꞌ cataj rihaan Jesucristó a: ―Cata̱j xnaꞌanj so̱ꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ so̱ꞌ se vaa caꞌne̱ꞌ rá nij soꞌ ga̱ nana̱ vaa da̱nj á ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ga̱a ne̱ cataj soꞌ rihaan nij soꞌ a: ―Cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa sese dínj ga̱a̱ tuꞌva nij síí aguáj nana̱ vaa da̱nj, ne̱ maꞌa̱n nij yahij na̱j rihaan yoꞌóó nihánj cagua̱j nana̱ vaa da̱nj asuun na̱nj ado̱nj ―taj Jesucristó rihaan nij síí fariseo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ne̱ ga̱a quinichrunꞌ Jesucristó chumanꞌ Jerusalén yoꞌ, ne̱ taꞌvee Jesucristó cheꞌé chumanꞌ yoꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ne̱ cataj soꞌ: ―Güii cuanꞌ me se me ina̱nj raj queneꞌe̱n soj si̱j ma̱n chumanꞌ Jerusalén da̱j quiꞌya̱j soj ne̱ caꞌve̱e dínj ca̱yáán soj, tza̱j ne̱ cuano̱ nihánj me se se̱ caꞌvee xca̱j soj cuentá maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Dan me se quisi̱j ya̱ güii, ne̱ caꞌna̱ꞌ nij síí ta̱j riꞌyunj man soj, ne̱ cune̱ꞌ nij soꞌ chingá nu̱ꞌ anica̱j chiháán soj, ne̱ tucuachri̱in nij soꞌ man soj, ne̱ se̱ caꞌvee cu̱riha̱nj soj, quiꞌya̱j nij soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ne̱ tu̱cuanee nij soꞌ nu̱ꞌ chiháán soj, ne̱ cavi̱ꞌ soj, ne̱ a̱ ꞌó yuvej se̱ quitáá xráá tuviꞌ yuvej, quiꞌya̱j nij soꞌ maꞌ. Da̱nj quira̱nꞌ soj, cheꞌé se ga̱a guun rá Diose̱ ra̱cuíj Diose̱ man soj, ne̱ ne xca̱j soj cuentá maꞌ ―taj Jesucristó niꞌya̱j soꞌ man nij síí ma̱n chumanꞌ Jerusalén yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ga̱a ne̱ catúj Jesucristó rá nuvií noco̱o, ga̱a ne̱ guun cheꞌe̱ soꞌ quirii soꞌ man nu̱ꞌ nij yuvii̱ tuꞌvéj rasu̱u̱n ma̱n rá nuvií noco̱o a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ne̱ cataj soꞌ rihaan nij soꞌ a: ―Danj Diose̱ taj se vaa tucuá Diose̱ me rej naꞌvíj yuvii̱ rihaan Diose̱ á. Tza̱j ne̱ guun tucua̱ síí itu̱u̱ man tucuá Diose̱ nihánj, quiꞌyaj soj na̱nj á ―taj Jesucristó rihaan nij yuvii̱ quirii soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ne̱ dan me se daj a̱ güii nicunꞌ Jesucristó rá nuvií noco̱o, tucuꞌyón Jesucristó se‑na̱na̱ soꞌ rihaan yuvii̱, tza̱j ne̱ nij xrej ata̱ suun noco̱o doj do̱ꞌ, nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ, nij síí uun chij rihaan nij yuvii̱ israelitá do̱ꞌ, nanoꞌ uxrá nij soꞌ da̱j quiꞌya̱j nij soꞌ ga̱a ne̱ caꞌve̱e cavi̱ꞌ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tza̱j ne̱ ne nari̱ꞌ nij soꞌ da̱j quiꞌya̱j nij soꞌ cavi̱ꞌ Jesucristó maꞌ. ꞌO̱ se guun niha̱ꞌ uxrá rá nij yuvii̱ cuno nij soꞌ se‑na̱na̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Dan me se ꞌo̱ güii nicu̱nꞌ Jesucristó rá nuvií noco̱o, tucuꞌyón Jesucristó rihaan yuvii̱, ne̱ nataꞌ soꞌ se‑na̱na̱ soꞌ nana̱ sa̱ꞌ, ne̱ nicu̱nꞌ xrej ata̱ suun noco̱o doj nicu̱nꞌ síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés nicu̱nꞌ síí uun chij nicu̱nꞌ rej tucuꞌyón Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ga̱a ne̱ cataj nij soꞌ rihaan Jesucristó a: ―Me síí caꞌneꞌ suun rihaan so̱ꞌ qui̱ꞌyáá so̱ꞌ nda̱a vaa ꞌyáá so̱ꞌ ga̱ ―taj nij soꞌ, xnáꞌanj nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Ne̱ vaa yoꞌo̱ nana̱ me raj xna̱ꞌanj ꞌu̱nj man nij soj, ne̱ cata̱j soj rihanj á. ");
INSERT INTO trcNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Dan me se me síí caꞌneꞌ suun rihaan síí cuꞌna̱j Juan cuta̱ꞌ ne soꞌ man yuvii̱, rá soj ga̱. Maꞌa̱n Juan cavii raa̱ naꞌ. Ase Diose̱ cataj xnaꞌanj rihaan soꞌ xa̱ꞌ. Cata̱j xnaꞌanj nij soj rihanj ei ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ga̱a ne̱ nuchruj ra̱a̱ ndoꞌo nij soꞌ ga̱ tuviꞌ nij soꞌ a: ―Ne̱ sese cata̱j níꞌ se vaa Diose̱ caꞌneꞌ suun rihaan síí cuꞌna̱j Juan cuta̱ꞌ ne soꞌ man yuvii̱, ne̱ cata̱j Jesucristó rihaan níꞌ me cheꞌé ne cuchuma̱n rá níꞌ nana̱ caꞌmii Juan, cata̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tza̱j ne̱ sese cata̱j níꞌ se vaa nuveé si̱j caꞌneꞌ Diose̱ suun rihaan me síí cuꞌna̱j Juan, ne̱ go̱ꞌ cunuda̱nj nij yuvii̱ yahij man níꞌ a. ꞌO̱ se cuchumán rá nij yuvii̱ se vaa síí nataꞌ se‑na̱na̱ Diose̱ me síí cuꞌna̱j Juan a ―cataj nij soꞌ ga̱ tuviꞌ maꞌa̱n nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ga̱a ne̱ cataj nij soꞌ rihaan Jesucristó se vaa ne neꞌen nij soꞌ me síí caꞌneꞌ suun rihaan síí cuꞌna̱j Juan cuta̱ꞌ ne soꞌ man yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Cheꞌé dan se̱ cataj xnaꞌanj ꞌu̱nj rihaan nij soj me síí caꞌneꞌ suun rihanj qui̱ꞌyáj nda̱a vaa ꞌyáj maꞌ ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ga̱a ne̱ guun cheꞌe̱ Jesucristó nanó soꞌ cuentó nihánj rihaan nij yuvii̱ a. ―Dan me se cuchruj yoꞌo̱ soꞌ yoꞌo̱ naa̱ chruj uvá a. Ga̱a ne̱ tanáj soꞌ man naa̱ yoꞌ rihaan síí quiꞌya̱j suun naa̱ yoꞌ, ne̱ curiha̱nj soꞌ caꞌanj soꞌ ga̱nꞌ queꞌe̱e̱ yavii a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ne̱ ꞌo̱ güii caꞌnéé soꞌ man yoꞌó se‑mo̱zó soꞌ caꞌa̱nj soꞌ rihaan nij síí nu̱u̱ tumé xnaa̱ soꞌ a. ꞌO̱ se me rá soꞌ rque̱ nij síí nu̱u̱ tumé naa̱ do̱j chruj uvá rihaan yoꞌó mozó yoꞌ, tza̱j ne̱ a̱ doj chruj ne rque̱ nij síí nu̱u̱ tumé naa̱ rihaan yoꞌó mozó yoꞌ maꞌ. Ma̱a̱n se goꞌ ndoꞌo nij soꞌ xráá soꞌ, ne̱ quirii nij soꞌ man soꞌ rque naa̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Cheꞌé dan caꞌnéé síí toꞌo̱j naa̱ yoꞌ man yoꞌó mozó uún, tza̱j ne̱ nij síí nu̱u̱ tumé naa̱ roꞌ, goꞌ uún nij soꞌ xráá mozó uún, ne̱ nij uxrá quiꞌyaj nij soꞌ man soꞌ, ne̱ quirii nij soꞌ man soꞌ rque naa̱, ne̱ a̱ doj chruj ne rque̱ nij soꞌ man mozó yoꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ga̱a ne̱ caꞌnéé uún síí xna̱a̱ yoꞌ yoꞌó mozó uún, tza̱j ne̱ quiranꞌ chiꞌii̱ ndoꞌo soꞌ, quiꞌyaj nij síí nu̱u̱ tumé naa̱, ne̱ quirii nij soꞌ man soꞌ xeꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","”Ga̱a ne̱ guun rá síí xna̱a̱ yoꞌ: “Da̱j qui̱ꞌyáj ya̱j ga̱. ꞌO̱ se caꞌne̱j ꞌu̱nj maꞌa̱n taꞌníj síí ꞌe̱e̱ raj man á. Cara̱a̱ cochro̱j nij soꞌ rihaan taꞌníj sese caꞌa̱nj taꞌníj saj xe̱e̱”, guun rá síí xna̱a̱, ne̱ caꞌnéé soꞌ man taꞌníí maꞌa̱n soꞌ caꞌa̱nj a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Dan me se queneꞌen nij síí nu̱u̱ tumé naa̱ se vaa ꞌnaꞌ taꞌníí síí xna̱a̱, ga̱a ne̱ nuchruj ra̱a̱ nij soꞌ ga̱ tuviꞌ nij soꞌ da̱j quiꞌya̱j nij soꞌ, taj nij soꞌ a: “Síí nihánj me síí gu̱un xna̱a̱ man naa̱ nihánj vaa güii ei. Cheꞌé dan ticavi̱ꞌ níꞌ man soꞌ, ne̱ vaa güii, ne̱ gu̱un xna̱a̱ maꞌa̱n níꞌ man naa̱ nihánj chugua̱nj”, taj nij soꞌ rihaan tuviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ga̱a ne̱ quirii nij soꞌ man taꞌníí síí xna̱a̱ yoꞌ xeꞌ, ne̱ ticaviꞌ nij soꞌ man taꞌníí síí siꞌya̱j naa̱ na̱nj ado̱nj. Cheꞌé dan da̱j quiꞌya̱j síí siꞌya̱j naa̱ yoꞌ man nij síí nu̱u̱ tumé xnaa̱ soꞌ, rá nij soj ga̱. ");
INSERT INTO trcNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ꞌO̱ se caꞌna̱ꞌ soꞌ vaa güii, ne̱ ticavi̱ꞌ soꞌ man nij síí nu̱u̱ tumé naa̱ yoꞌ, ne̱ ta̱cuachén soꞌ xnaa̱ soꞌ rihaan yoꞌó síí tu̱mé man xnaa̱ soꞌ na̱nj ado̱nj ―taj Jesucristó rihaan nij yuvii̱ a. Ga̱a cuno nij yuvii̱ nana̱ nihánj, ne̱ cuchuꞌviꞌ ndoꞌo nij soꞌ, ne̱ cataj nij soꞌ: ―O̱rúnꞌ ra̱a̱ Diose̱ me síí naca̱j man núj rihaan sayuun yoꞌ na̱nj chugua̱nj ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ga̱a ne̱ niꞌya̱j Jesucristó man nij soꞌ, ne̱ xnáꞌanj Jesucristó man nij soꞌ a: ―Cheꞌé dan me se me cheꞌé nó nana̱ nihánj rihaan danj Diose̱, rá nij soj ga̱: “Yuvej quiriꞌíj nij síí cuneꞌ veꞌ roꞌ, guun yuvej sa̱ꞌ doj rihaan cunuda̱nj nij yuvej ma̱n tacóó veꞌ yoꞌ na̱nj ado̱nj”, taj danj Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ne̱ yuvej yoꞌ me se ase vaa yuvej yoꞌ vaa ꞌu̱nj, ne̱ ase vaa yuvii̱ tíxé yuvej yoꞌ vaa yuvii̱ naꞌvej rá cuno̱ rihaan ꞌu̱nj, ne̱ uxrá quira̱nꞌ nij soꞌ sayuun na̱nj ado̱nj. Ne̱ ase vaa yuvii̱ quinij yuvej yoꞌ xráá vaa nij yuvii̱ qui̱ꞌyáá ꞌu̱nj sayuun man, ne̱ yu̱u̱n cheꞌe̱ quinavi̱j nij soꞌ nu̱ꞌ cavii nu̱ꞌ caꞌanj na̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ga̱a ne̱ guun rá nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ guun rá nij xrej ata̱ suun noco̱o doj guun rá qui̱taꞌaa raꞌya̱nj man Jesucristó, tza̱j ne̱ chuꞌviꞌ nij soꞌ niꞌya̱j nij soꞌ man nij yuvii̱ a. Queneꞌen nij soꞌ se vaa cheꞌe̱ maꞌa̱n nij soꞌ me cuentó nanó Jesucristó a. Ase vaa nij síí nu̱u̱ tumé naa̱ vaa maꞌa̱n nij soꞌ rihaan Jesucristó, ne̱ queneꞌen nij soꞌ se vaa cheꞌé dan nanó Jesucristó cuentó yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Dan me se cutumé ndoꞌo nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ, nij xrej ata̱ suun noco̱o doj do̱ꞌ, man Jesucristó da̱j caꞌmi̱i̱ soꞌ a. Ne̱ goꞌ nij soꞌ saꞌanj rihaan do̱j tuviꞌ nij soꞌ síí tihaꞌ yuꞌunj cuchi̱ꞌ nij soꞌ rihaan Jesucristó, ne̱ quiꞌya̱j nij soꞌ nda̱a vaa ꞌyaj síí vaa sa̱ꞌ síí me rá xna̱ꞌanj nana̱ man soꞌ a. ꞌO̱ se guun rá nij soꞌ cuta̱ꞌ nij soꞌ cacunꞌ xráá Jesucristó cheꞌé nana̱ caꞌmi̱i̱ soꞌ, ga̱a ne̱ caꞌve̱e ta̱cuachén nij soꞌ man Jesucristó rihaan síí nica̱j suun procurador a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Dan me se xnáꞌanj nij síí tihaꞌ yuꞌunj yoꞌ man Jesucristó a: ―Neꞌen núj se vaa nana̱ nica̱ ina̱nj aꞌmii so̱ꞌ ne̱ tucuꞌyón so̱ꞌ do̱ꞌ, maestro. Ne̱ ꞌo̱ cuya̱a̱n vaa cunuda̱nj yuvii̱ rihaan so̱ꞌ chugua̱nj. Ne̱ ya̱ tucuꞌyón so̱ꞌ rihaan yuvii̱ da̱j quiꞌya̱j yuvii̱ canoco̱ꞌ yuvii̱ man Diose̱, maestro. ");
INSERT INTO trcNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Dan me se nó xcúún níꞌ go̱ꞌ níꞌ puextó rihaan síí nica̱j suun gobiernó naꞌ. Ase se̱ goꞌ níꞌ xa̱ꞌ ―taj nij síí tihaꞌ yuꞌunj, xnáꞌanj nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tza̱j ne̱ caxríj rá Jesucristó se vaa me rá nij soꞌ tiha̱ꞌ yuꞌunj nij soꞌ man soꞌ a. Cheꞌé dan cataj Jesucristó nana̱ nihánj rihaan nij soꞌ a: ");
INSERT INTO trcNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―Ti̱haa̱n soj saꞌanj aga̱ꞌ ni̱ꞌyaj níꞌ á ―taj Jesucristó rihaan nij soꞌ a. Ga̱a ne̱ ga̱a tihaa̱n nij soꞌ saꞌanj aga̱ꞌ yoꞌ rihaan Jesucristó, ga̱a ne̱ cataj Jesucristó: ―Me síí nó rihaan saꞌanj aga̱ꞌ nihánj ga̱. Ne̱ me síí se‑chuvi̱i nó rihaan saꞌanj aga̱ꞌ nihánj ga̱ ―taj Jesucristó, xnáꞌanj soꞌ man nij síí me rá tiha̱ꞌ yuꞌunj yoꞌ a. ―Síí nica̱j suun gobiernó me nó rihaan saꞌanj aga̱ꞌ yoꞌ, ne̱ nó se‑chuvi̱i soꞌ rihaan saꞌanj ei ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Cheꞌé dan go̱ꞌ soj siꞌyaj síí nica̱j suun gobiernó rihaan maꞌa̱n soꞌ, ne̱ rque̱ soj siꞌyaj Diose̱ rihaan Diose̱ á ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ga̱a ne̱ ne gu̱un nucua̱j nij síí tihaꞌ yuꞌunj yoꞌ cuta̱ꞌ nij soꞌ cacunꞌ xráá Jesucristó cheꞌé se‑na̱na̱ soꞌ maꞌ. ꞌO̱ se cuno cunuda̱nj nij yuvii̱ da̱j caꞌmii nij soꞌ, ga̱a ne̱ caꞌanj ndoꞌo rá nij yuvii̱ cuno nij soꞌ se‑na̱na̱ Jesucristó, ne̱ caꞌneꞌ rá nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Dan me se cuchiꞌ do̱j nij síí saduceo rihaan Jesucristó a. Nij síí saduceo roꞌ, aꞌmii nana̱ nihánj se vaa daj chiha̱a̱ míj se̱ cunuu iꞌna̱ꞌ uún yuvii̱ asa̱ꞌ caviꞌ yuvii̱, taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Dan me se xnáꞌanj nij soꞌ man Jesucristó, ne̱ cataj nij soꞌ nana̱ nihánj a: ―Cachrón síí cuꞌna̱j Moisés nana̱ nihánj rihaan yanj, cheꞌé rej cuno̱ níꞌ nana̱ nihánj a: “Sese caviꞌ yoꞌo̱ síí vaa nica̱, ne̱ sese taj va̱j taꞌníí soꞌ, ne̱ no̱ xcúún tinúú soꞌ xca̱j tinúú soꞌ man choco̱ꞌ soꞌ chana̱ quináj, ne̱ coto̱j tinúú síí caviꞌ ga̱ choco̱ꞌ soꞌ, ne̱ cuchru̱j noꞌ neꞌej, ne̱ gu̱un taꞌni̱j síí caviꞌ man neꞌej yoꞌ, ne̱ cu̱nuû neꞌej yoꞌ rihaan toꞌóó síí caviꞌ yoꞌ a”, taj síí cuꞌna̱j Moisés ga̱a naá, maestro. ");
INSERT INTO trcNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Dan me se vaa chi̱j nij tinu̱j ꞌo̱ nij soꞌ a. Síí chava̱ꞌ roꞌ, xcaj man chana̱, tza̱j ne̱ caviꞌ soꞌ, ne̱ taj va̱j neꞌej cuchruj chana̱ nica̱ soꞌ, quiꞌyaj soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ne̱ cheꞌé dan xcaj scueꞌe̱e̱ síí caviꞌ yoꞌ man choco̱ꞌ soꞌ chana̱ quináj, tza̱j ne̱ caviꞌ soꞌ uún, ne̱ xcaj scueꞌe̱e̱ soꞌ uún man chana̱, tza̱j ne̱ caviꞌ soꞌ uún, ");
INSERT INTO trcNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ne̱ dan me se quisíj xcaj nu̱ꞌ chi̱j nij tinu̱j nij soꞌ man o̱rúnꞌ chana̱ yoꞌ, tza̱j ne̱ taj va̱j a̱ ꞌó neꞌej cuchruj chana̱ yoꞌ, quiꞌyaj nij soꞌ maꞌ. Ne̱ caviꞌ taranꞌ nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Síj, ga̱a ne̱ caviꞌ maꞌa̱n chana̱ yoꞌ uún, ");
INSERT INTO trcNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ne̱ dan me se asa̱ꞌ cunuu iꞌna̱ꞌ uún nij síí caviꞌ, ga̱a ne̱ me nij tinu̱j nij soꞌ ni̱caj man chana̱ yoꞌ, rá so̱ꞌ ga̱. ꞌO̱ se ga̱a vaa iꞌna̱ꞌ nij soꞌ, ne̱ nica̱ taranꞌ nij tinu̱j nij soꞌ guun o̱rúnꞌ noꞌ a ―taj nij síí saduceo, xnáꞌanj nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Xa̱ꞌ nij yuvii̱ ma̱n rihaan chumii̱ nihánj cuano̱, tza̱j ne̱ uchruj nij soꞌ saꞌanj do̱ꞌ, xcaj tuviꞌ nij soꞌ do̱ꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","tza̱j ne̱ ino̱ quiꞌya̱j nij yuvii̱ cunu̱u iꞌna̱ꞌ uún ca̱yáán ga̱ Diose̱ asa̱ꞌ cunuu naca̱ uún chumii̱ nihánj na̱nj á. ꞌO̱ se rej ya̱nj Diose̱ me se taj yan va̱j síí xcaj tuviꞌ yoꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ꞌO̱ se da̱nj na̱nj uún, ne̱ taj yan va̱j síí cavi̱ꞌ uún rej yoꞌ maꞌ. ꞌO̱ se ase vaa nij se‑mo̱zó Diose̱ roꞌ, da̱nj ga̱a̱ nij soꞌ, ne̱ cuya̱a̱n ga̱a̱ nij soꞌ ga̱ nij se‑mo̱zó Diose̱, ése̱ taꞌni̱j Diose̱ me nij soꞌ, ne̱ si̱j a̱j caviꞌ ne̱ cunuu iꞌna̱ꞌ uún me nij soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","”Ne̱ maꞌa̱n síí cuꞌna̱j Moisés me síí cataj xnaꞌanj asino ya̱a̱n se vaa caꞌve̱e cunu̱u iꞌna̱ꞌ uún nij síí caviꞌ nda̱a vaa nariꞌ soꞌ ga̱a canicunꞌ soꞌ rihaan yan nicu̱nꞌ ꞌo̱ coj acoꞌ yaꞌan raa̱ a. Dan me se cataj soꞌ se vaa síí ꞌni̱j raꞌa man níꞌ roꞌ, me Diose̱ síí noco̱ꞌ nij síí ma̱n ga̱a naá síí cuꞌna̱j Abraham do̱ꞌ, síí cuꞌna̱j Isaac do̱ꞌ, síí cuꞌna̱j Jacobo do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dan me se nuveé se‑Dio̱se̱ nij xnangá me Diose̱ maꞌ. Ina̱nj nij síí vaa iꞌna̱ꞌ aꞌvee noco̱ꞌ man Diose̱ na̱nj ado̱nj. Cheꞌé dan, nda̱ꞌ se síí cane ga̱a naá me vaꞌnu̱j nij soꞌ, tza̱j ne̱ vaa iꞌna̱ꞌ nij soꞌ rihaan Diose̱ na̱nj ei. ꞌO̱ se vaa iꞌna̱ꞌ cunuda̱nj yuvii̱ niꞌya̱j Diose̱ na̱nj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ga̱a ne̱ taꞌa̱j nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ roꞌ, cataj rihaan Jesucristó a: ―Cuna̱j uxrá caꞌmii so̱ꞌ, maestro ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ꞌO̱ se ne quisi̱j rá nij soꞌ xna̱ꞌanj nij soꞌ doj nana̱ man Jesucristó a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Me cheꞌé taj nij soj se vaa na̱nj taꞌníí taꞌnij siꞌno̱ síí cuꞌna̱j David síí cane ga̱a naá me síí caꞌne̱j Diose̱ ti̱nanii man yuvii̱ rihaan sayuun ga̱. ");
INSERT INTO trcNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ꞌO̱ se nó se‑na̱na̱ maꞌa̱n síí cuꞌna̱j David rihaan yanj no̱ chraꞌ quiꞌyaj soꞌ, se vaa cataj soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","“Caꞌmii Diose̱ síí ꞌni̱j raꞌa man níꞌ rihaan síí ꞌni̱j raꞌa manj, cataj soꞌ se vaa ca̱yáán síí ꞌni̱j raꞌa manj xꞌnúú Diose̱ rej nuva̱ꞌ Diose̱ nda̱a se quisi̱j quiꞌya̱j canaán Diose̱ rihaan taranꞌ nij síí ta̱j riꞌyunj man síí ꞌni̱j raꞌa manj ne̱ quiri̱i̱ taꞌngaꞌ síí ꞌni̱j raꞌa manj rihaan nij soꞌ ado̱nj”, taj síí cuꞌna̱j David yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dan me se síí ꞌni̱j raꞌa man síí cuꞌna̱j David me síí caꞌne̱j Diose̱ ti̱nanii man yuvii̱ rihaan sayuun, taj síí cuꞌna̱j David yoꞌ a. Sese ꞌni̱j raꞌa soꞌ man David, ga̱a ne̱ me cheꞌé taj soj se vaa na̱nj taꞌníí taꞌnij siꞌno̱ David me soꞌ ga̱. Taj cheꞌé cata̱j soj se vaa na̱nj yuvii̱ me soꞌ maꞌ ―taj Jesucristó rihaan nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ga̱a ne̱ caꞌmii soꞌ nana̱ nihánj rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ cuno cunuda̱nj nij yuvii̱ da̱j caꞌmii soꞌ a: ");
INSERT INTO trcNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Xca̱j nij soj cuentá da̱j ꞌyaj nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱, ne̱ tu̱mé soj man soj se̱ gaa na̱nj quiꞌya̱j soj nda̱a vaa ꞌyaj nij soꞌ á. Dan me se niha̱ꞌ rá nij soꞌ cu̱nuû nij soꞌ yatzíj sa̱ꞌ xca̱a̱n cache̱e̱ nij soꞌ rej queneꞌe̱n yuvii̱ man nij soꞌ, ne̱ aranꞌ rá nij soꞌ se vaa caꞌmi̱i̱ sa̱ꞌ yuvii̱ ga̱ nij soꞌ ga̱a chéé nij soꞌ rihaan yuꞌvee a. Ne̱ uun rá nij soꞌ quita̱j nij soꞌ chruun xlá sa̱ꞌ doj ga̱a ꞌanj nij soꞌ veꞌ nuu chre̱ꞌ níꞌ tu̱cuꞌyón níꞌ se‑tucua̱nj Moisés do̱ꞌ, ga̱a ꞌanj nij soꞌ chaꞌanj do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ne̱ aꞌnéj nij soꞌ veꞌ tucuá chana̱ caviꞌ nica̱, ne̱ yu̱u̱n cheꞌe̱ guun tucua̱ nij soꞌ man veꞌ yoꞌ, ne̱ ꞌyaj xca̱a̱n ndoꞌo nij soꞌ cuentó achíín niꞌya̱j nij soꞌ rihaan Diose̱, cheꞌé rej sa̱ꞌ doj gu̱un nucua̱j nij soꞌ tiha̱ꞌ yuꞌunj nij soꞌ man yuvii̱ a. Xa̱ꞌ nij soꞌ, tza̱j ne̱ cheꞌé se vaa ꞌyaj nij soꞌ roꞌ, cheꞌé dan doj a̱ ga̱a̱ sayuun quira̱nꞌ nij soꞌ quiꞌya̱j Diose̱, asa̱ꞌ caꞌneꞌ Diose̱ cacunꞌ cheꞌé yuvii̱ ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Dan me se niꞌya̱j Jesucristó, ne̱ queneꞌen soꞌ se vaa araa ndoꞌo nij síí ruꞌvee saꞌanj rque chrúún ta̱j rihaan nuvií noco̱o cheꞌé Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ne̱ queneꞌen soꞌ ꞌo̱ chana̱ caviꞌ nica̱ chana̱ nique̱ se vaa caraa noꞌ vi̱j gue̱e̱ saꞌanj aga̱ꞌ leꞌe̱j rque chrúún yoꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ne̱ cataj soꞌ: ―Cata̱j xnaꞌanj yá yá ꞌu̱nj rihaan nij soj cuano̱ se vaa xa̱ꞌ chana̱ caviꞌ nica̱ chana̱ nique̱ nihánj, tza̱j ne̱ doj a̱ caraa noꞌ saꞌanj rque chrúún yoꞌ rihaan saꞌanj caraa cunuda̱nj yoꞌó nij yuvii̱ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ꞌO̱ se nij soꞌ, da̱j doj saꞌanj quináj raa̱ se‑saꞌa̱nj nij soꞌ roꞌ, caraa nij soꞌ rque chrúún, ne̱ xa̱ꞌ noꞌ, tza̱j ne̱ nda̱ꞌ se achiin ndoꞌo saꞌanj rihaan noꞌ, tza̱j ne̱ rqué noꞌ rihaan Diose̱ cunuda̱nj saꞌanj nica̱j noꞌ saꞌanj quira̱a̱n noꞌ se cha̱ noꞌ na̱nj ado̱nj ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Dan me se cataj taꞌa̱j yuvii̱ se vaa xa̱ꞌ nuvií noco̱o, tza̱j ne̱ yuvej sa̱ꞌ ina̱nj me yuvej guun nuvií noco̱o, ne̱ me do̱j uxrá saꞌanj goꞌ nij yuvii̱ rihaan Diose̱ cheꞌé rej caꞌve̱e cune̱ꞌ nii nuvií noco̱o yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Xa̱ꞌ nu̱ꞌ nuvií noco̱o niꞌya̱j soj nihánj, tza̱j ne̱ vaa güii cane̱e̱ nu̱ꞌ nuvií noco̱o nihánj, ne̱ a̱ ꞌó yuvej se̱ quitáá xráá tuviꞌ yuvej nihánj a̱ maꞌ ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Dan me se xnáꞌanj nii man Jesucristó, ne̱ cataj nii rihaan soꞌ a: ―Cheꞌé dan cata̱j xnaꞌanj so̱ꞌ rihaan núj aman cane̱e̱ nu̱ꞌ nuvií noco̱o nihánj do̱ꞌ, a̱ me rasu̱u̱n caꞌna̱ꞌ qui̱ꞌyáá so̱ꞌ asa̱ꞌ quisíj caꞌna̱ꞌ sayuun yoꞌ, señor ―taj nii, xnáꞌanj nii man soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ga̱a ne̱ cataj soꞌ rihaan nii: ―Tu̱mé ndoꞌo soj man soj se̱ gaa na̱nj tiha̱ꞌ yuꞌunj yuvii̱ man soj á. ꞌO̱ se caꞌna̱ꞌ uxrá yuvii̱ cata̱j: “ꞌU̱nj me síí naꞌvi̱j soj, ne̱ Cristo mej á”, cata̱j nij yuvii̱, ne̱ cata̱j uún nij yuvii̱: “A̱j quisíj güii caꞌa̱nj niꞌya̱ chumii̱ na̱nj á”, cata̱j uún nij yuvii̱ rihaan soj a. Tza̱j ne̱ se̱ cuchumán rá soj, ne̱ se̱ canocoꞌ soj man yuvii̱ aꞌmii da̱nj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","”Dan me se caꞌve̱e se cuno̱ soj nana̱ se vaa unuꞌ uxrá chumanꞌ ga̱ tuviꞌ chumanꞌ do̱ꞌ, caꞌve̱e se cuno̱ soj nana̱ se vaa tucuáá ndoꞌo yuvii̱ rihaan gobiernó do̱ꞌ, tza̱j ne̱ se̱ cuchuꞌviꞌ soj maꞌ. Ma̱a̱n se vaa cheꞌé gu̱un sayuun yoꞌ rihaan chumii̱ nihánj asino ya̱a̱n ado̱nj. Tza̱j ne̱ asa̱ꞌ quisíj guun da̱nj, ga̱a ne̱ se̱ caꞌanj niꞌya̱ chumii̱ nihánj nu̱ꞌ orá maꞌ. ꞌO̱ se quina̱j chumii̱ nihánj doj ado̱nj ―taj soꞌ rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ga̱a ne̱ cataj uún Jesucristó rihaan nij soꞌ a: ―Dan me se cunu̱ꞌ uxrá yuvii̱ ma̱n chumanꞌ noco̱o ga̱ yoꞌó chumanꞌ noco̱o, ne̱ cunu̱ꞌ gobiernó ga̱ tuviꞌ gobiernó a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ne̱ cache̱n ndoꞌo yuún noco̱o, ne̱ queꞌe̱e̱ chumanꞌ me se cache̱n ndoꞌo chiꞌii̱ cache̱n ndoꞌo xꞌnaa cache̱n ndoꞌo a. Ne̱ queneꞌe̱n ndoꞌo yuvii̱ rasu̱u̱n noco̱o nij ndoꞌo rej xta̱ꞌ, ne̱ cuchuꞌvi̱ꞌ nij yuvii̱, quiꞌya̱j rasu̱u̱n yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","”Tza̱j ne̱ asa̱ꞌ ataa gu̱un nu̱ꞌ sayuun yoꞌ, ne̱ quita̱j riꞌyunj nii man soj, ne̱ qui̱taꞌaa nii man soj, ne̱ canoco̱ꞌ nii man soj quiꞌya̱j nii sayuun man soj, ne̱ ta̱cuachén nii man soj rihaan nij síí ma̱n rá veꞌ nuu chre̱ꞌ níꞌ tu̱cuꞌyón níꞌ se‑tucua̱nj Moisés, ne̱ caxri̱i̱ nii tagaꞌ man soj, ne̱ ta̱cuachén nii man soj rihaan nij síí nica̱j suun, cheꞌé se si̱j noco̱ꞌ manj me soj a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Síj, ga̱a ne̱ quiri̱ꞌ soj cata̱j xnaꞌanj soj rihaan nij soꞌ cheꞌé ꞌu̱nj a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ne̱ asa̱ꞌ nicunꞌ soj rihaan nij soꞌ, ne̱ yoꞌo̱ caꞌne̱j nimán soj se̱ nanó rá soj cheꞌé nana̱ caꞌmi̱i̱ maꞌa̱n soj rihaan nij soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ꞌO̱ se ma̱ꞌanj me síí rque̱ nana̱ cu̱u cavi̱i̱ tuꞌva soj na̱nj á. Ne̱ taj síí gu̱un nucua̱j quiꞌya̱j canaán rihaan se‑na̱na̱ soj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Dan me se nda̱a maꞌa̱n rej soj do̱ꞌ, nda̱a maꞌa̱n tuviꞌ soj do̱ꞌ, nda̱a maꞌa̱n tinúú soj do̱ꞌ, nda̱a maꞌa̱n nij síí ma̱n chiháán soj do̱ꞌ, me nij síí ta̱cuachén man soj rihaan nij síí quiꞌya̱j sayuun man soj, ga̱a ne̱ ticavi̱ꞌ nii man taꞌa̱j soj, ");
INSERT INTO trcNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ne̱ nachri̱ꞌ cunuda̱nj nij yuvii̱ ma̱n rihaan chumii̱ ni̱ꞌyaj nij soꞌ man soj, cheꞌé se me soj síí noco̱ꞌ manj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tza̱j ne̱ daj chiha̱a̱ míj se̱ caꞌanj niꞌya̱ a̱ doj yuvé raa̱ soj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ꞌO̱ se cheꞌé se noco̱ꞌ raan soj manj roꞌ, cheꞌé dan yoꞌo̱ ga̱a̱ iꞌna̱ꞌ soj nu̱ꞌ cavii nu̱ꞌ caꞌanj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","”Dan me se asa̱ꞌ queneꞌen soj se vaa tucuachriin tanuu nu̱ꞌ chumanꞌ Jerusalén, ne̱ xca̱j soj cuentá se vaa da̱j doj quiri̱ꞌ nu̱ꞌ chumanꞌ yoꞌ, ne̱ quinavi̱j nu̱ꞌ chumanꞌ yoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ne̱ güii dan me se yoꞌo̱ cuna̱nj nij síí ma̱n estadó Judea caꞌa̱nj nij soꞌ raa̱ quij, ne̱ nij síí va̱j rque chumanꞌ Jerusalén me se raꞌya̱nj cu̱riha̱nj nij soꞌ, ne̱ nij síí va̱j rej tacaan me se se̱ catúj nij soꞌ chumanꞌ yoꞌ daj chiha̱a̱ míj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ꞌO̱ se yoꞌ me güii na̱ruꞌvee Diose̱ sayuun rihaan nij síí ne̱ estadó Judea yoꞌ cheꞌé cacunꞌ tumé nij soꞌ, ne̱ ya̱ da̱nj gu̱un, ga̱a ne̱ quisi̱j ya̱ nu̱ꞌ nana̱ no̱ rihaan danj Diose̱ cheꞌé nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nique̱ chana̱ nu̱u̱ rque do̱ꞌ, chana̱ vaa taꞌníí neꞌej utzii do̱ꞌ, güii caꞌna̱ꞌ sayuun yoꞌ a. ꞌO̱ se se̱ guun nucua̱j chana̱ yoꞌ cuna̱nj chana̱ yoꞌ maꞌ. ꞌO̱ se gu̱un ndoꞌo sayuun rej yoꞌ, ne̱ caxri̱i̱ yuva̱a̱ Diose̱ man yuvii̱ yoꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ne̱ cavi̱ꞌ queꞌe̱e̱ nij soꞌ raa̱ neê espadá, ne̱ qui̱taꞌaa nii man queꞌe̱e̱ nij soꞌ caꞌa̱nj ni̱caj nii rej ne̱ nij síí yaníj a. Ne̱ cache̱e̱ nij síí yaníj xráá nu̱ꞌ chumanꞌ Jerusalén, nda̱a se quisi̱j güii caꞌne̱e̱ Diose̱ suun raꞌa nij soꞌ a ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ne̱ cataj uún Jesucristó a: ―Ga̱a ne̱ queneꞌe̱n yuvii̱ se vaa cunu̱u ino̱ güii do̱ꞌ, yavii do̱ꞌ, nij yatiꞌ do̱ꞌ, ne̱ rihaan maꞌa̱n chumii̱ me se cuchuꞌvi̱ꞌ ndoꞌo cunuda̱nj nij yuvii̱ cuno̱ nij soꞌ da̱j ga̱a̱ ca̱ri̱i̱n ndoꞌo na yaꞌa̱nj do̱ꞌ, queneꞌe̱n nij soꞌ da̱j ga̱a̱ quina̱a̱n rihaan na yaꞌa̱nj do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ne̱ cuchuꞌvi̱ꞌ ndoꞌo nij yuvii̱, cheꞌé yan quinano̱ rá nij soꞌ da̱j ga̱a̱ quira̱nꞌ nu̱ꞌ chumii̱ nihánj a. Ne̱ quina̱a̱n taranꞌ nij rasu̱u̱n nucua̱j ma̱n rej xta̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ga̱a ne̱ queneꞌe̱n nij soꞌ mán ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ á. Dan me se xráá ngaa quita̱j ꞌu̱nj caꞌna̱ꞌ ꞌu̱nj, ne̱ gu̱un nucua̱j ndoꞌoj quiri̱i̱ taꞌngaj, ne̱ veꞌé uxrá curuvi̱j caꞌna̱j ei. ");
INSERT INTO trcNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Dan me se asa̱ꞌ guun cheꞌe̱ nu̱ꞌ rasu̱u̱n nihánj gu̱un yoꞌ da̱nj, ne̱ canicu̱nꞌ soj, ne̱ ni̱ꞌyaj soj xta̱ꞌ, ne̱ da̱j doj naca̱j ꞌu̱nj man soj rihaan chumii̱ nihánj ga̱a̱ na̱nj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ga̱a ne̱ nanó Jesucristó cuentó nihánj a: ―Xca̱j soj cuentá da̱j ꞌyaj chruun ma̱n chruj higó raa̱ do̱ꞌ, da̱j ꞌyaj me maꞌa̱n chruun do̱ꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ga̱a naca coj yaꞌli̱j raꞌa nij chruun, ne̱ niꞌya̱j soj man nij chruun, ne̱ neꞌen soj se vaa da̱j doj ꞌnaꞌ tió nama̱n maa̱n a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Dan me se xca̱j uún soj cuentá se vaa asa̱ꞌ queneꞌen soj nu̱ꞌ se vaa cataj xnaꞌanj ꞌu̱nj rihaan soj cuano̱, ne̱ da̱j doj gu̱un cheꞌe̱ Diose̱ gu̱un chij Diose̱ rihaan chumii̱ nihánj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa queneꞌe̱n taꞌa̱j soj si̱j vaa iꞌna̱ꞌ rihaan chumii̱ nihánj cuano̱ quisi̱j nu̱ꞌ rasu̱u̱n nihánj nu̱ꞌ se vaa cataj xnaꞌanj ꞌu̱nj rihaan soj cuano̱ ei. Ne̱ ya̱ queneꞌe̱n soj nu̱ꞌ nihánj ga̱a ataa cavi̱ꞌ soj ei. ");
INSERT INTO trcNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Vaa güii caꞌa̱nj niꞌya̱ yoꞌóó do̱ꞌ, xta̱ꞌ do̱ꞌ, tza̱j ne̱ se‑na̱na̱j me se daj chiha̱a̱ míj se̱ quinavij yoꞌ maꞌ ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ne̱ cataj uún Jesucristó a: ―Dan me se cu̱tumé soj man soj se̱ gaa na̱nj yoꞌo̱ gu̱un rá soj rasu̱u̱n ma̱n rihaan chumii̱ nihánj, ne̱ gu̱un rá soj gu̱un xno̱ soj do̱ꞌ, gu̱un rá soj caꞌmi̱i̱ sca̱ꞌ soj do̱ꞌ, gu̱un rá soj gu̱un siꞌya̱j soj nu̱ꞌ rasu̱u̱n ma̱n rihaan chumii̱ nihánj do̱ꞌ a. Se quiꞌya̱j soj da̱nj, tóse̱ taj niꞌyón caꞌna̱j, ne̱ se̱ queneꞌen soj caꞌna̱j a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ꞌO̱ se nda̱a rá se vaa ꞌo̱ lazo neꞌ taꞌaa man nii roꞌ, da̱nj ga̱a̱ caꞌna̱ꞌ xráá cunuda̱nj chumii̱ nihánj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Cheꞌé dan yoꞌo̱ ni̱ꞌyaj soj, ne̱ xca̱j soj cuentá nu̱ꞌ güii, ne̱ ina̱nj cachi̱nj niꞌya̱j soj rihaan Diose̱ se vaa caꞌve̱e quinani̱i̱ soj rihaan nu̱ꞌ sayuun nihánj asa̱ꞌ gu̱un da̱nj rihaan chumii̱ nihánj, ga̱a ne̱ caꞌve̱e canicu̱nꞌ soj rihaan ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ ei ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Dan me se rej ranga̱ꞌ roꞌ, ne̱ Jesucristó rá nuvií noco̱o, ne̱ tucuꞌyón soꞌ man nij yuvii̱, ne̱ rej tiꞌnuu me se curiha̱nj soꞌ, ne̱ rej cuꞌna̱j Quij ma̱n Chruun Olivó aranꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ne̱ taxre̱j uchiꞌ cunuda̱nj nij yuvii̱ cuno̱ nij soꞌ se‑na̱na̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Dan me se da̱j doj ca̱nuû chaꞌanj pascuá chaꞌanj chá nij yuvii̱ israelitá chraa yoꞌóó trigó a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ne̱ nanoꞌ nij xrej ata̱ suun noco̱o doj do̱ꞌ, nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan yuvii̱ do̱ꞌ, da̱j quiꞌya̱j nij soꞌ ne̱ cavi̱ꞌ Jesucristó, cheꞌé se ma̱n ndoꞌo yuvii̱ noco̱ꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ne̱ catúj síí chre̱e cuꞌna̱j Satanás nimán síí cuꞌna̱j Judas Iscariote, ne̱ soꞌ me se yoꞌo̱ tuviꞌ maꞌa̱n chuvi̱j nij síí tucuꞌyón se‑na̱na̱ Jesucristó me soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Dan me se cavii soꞌ caꞌanj soꞌ, ne̱ caꞌmii soꞌ ga̱ nij xrej ata̱ suun noco̱o doj do̱ꞌ, ga̱ tanuu uun chij rihaan nij tanuu tumé nuvií do̱ꞌ, ga̱a ne̱ cataj soꞌ da̱j quiꞌya̱j soꞌ ne̱ ta̱cuachén soꞌ man Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ga̱a ne̱ guun niha̱ꞌ rá nij soꞌ ga̱a cuno nij soꞌ se‑na̱na̱ Judas, ne̱ guun ya̱ caꞌmii nij soꞌ ga̱ Judas se vaa rque̱ nij soꞌ saꞌanj man Judas a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Dan me se cataꞌ tuꞌva síí cuꞌna̱j Judas se vaa ta̱cuachén soꞌ man Jesucristó rihaan nij soꞌ, ga̱a ne̱ nuchruj ra̱a̱ Judas aman caꞌve̱e ta̱cuachén soꞌ man Jesucristó rihaan nij soꞌ, ga̱a ne̱ se̱ gaa na̱nj queneꞌe̱n nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Dan me se quisíj güii canuû chaꞌanj chá nii chraa yoꞌóó trigó, ne̱ güii dan me güii ticaviꞌ nij yuvii̱ israelitá matzinj leꞌe̱j cheꞌé Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Dan me se caꞌnéé Jesucristó man Pedró do̱ꞌ, man Juan do̱ꞌ, ne̱ cataj soꞌ rihaan ro̱j soꞌ: ―Caꞌa̱nj ro̱j so̱j quiꞌya̱j chuvi̱i ro̱j so̱j cha̱ níꞌ ne̱ navi̱j rá níꞌ chaꞌanj pascuá ei ―taj soꞌ rihaan ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ga̱a ne̱ xnáꞌanj ro̱j soꞌ man Jesucristó a: ―Me rej quiꞌya̱j chuvi̱i núj cha̱ níꞌ ga̱ ―taj ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ga̱a ne̱ cataj Jesucristó rihaan ro̱j soꞌ a: ―Cuno̱ ro̱j so̱j nana̱ nihánj, se vaa asa̱ꞌ catúj ro̱j so̱j chumanꞌ yoꞌ, ne̱ nari̱ꞌ tuviꞌ ro̱j so̱j ga̱ ꞌo̱ síí táá chiha̱ ꞌo̱ cacuaj na, ne̱ canoco̱ꞌ ro̱j so̱j man soꞌ, catu̱u̱ ro̱j so̱j rá veꞌ catu̱u̱ soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ne̱ cata̱j ro̱j so̱j rihaan síí tucua̱ veꞌ yoꞌ: “Xnáꞌanj maestró mán so̱ꞌ se vaa me rej ne̱ veꞌ cha̱ xtiꞌno̱ maestró chraa ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ cheꞌé chaꞌanj pascuá, taj soꞌ a”, cata̱j ro̱j so̱j rihaan síí tucua̱ veꞌ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ga̱a ne̱ ti̱haa̱n soꞌ ꞌo̱ veꞌ nataꞌ xi̱j rihaan ro̱j so̱j, ne̱ a̱j vaa chuvi̱i rá veꞌ yoꞌ, ne̱ ma̱n chruun mesá ma̱n chruun xlá ma̱n rá veꞌ yoꞌ a. Yoꞌ me rej quiꞌya̱j chuvi̱i ro̱j so̱j á ―taj Jesucristó rihaan ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dan me se cavii ro̱j soꞌ caꞌanj ro̱j soꞌ, ne̱ nariꞌ ro̱j soꞌ nu̱ꞌ nda̱a vaa cataj xnaꞌanj Jesucristó rihaan ro̱j soꞌ, ga̱a ne̱ quiꞌyaj chuvi̱i ro̱j soꞌ cha̱ xtiꞌno̱ nij soꞌ chraa cheꞌé chaꞌanj pascuá a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ne̱ quisíj orá cha̱ xtiꞌno̱ nij soꞌ, ne̱ caꞌnaꞌ Jesucristó ga̱ yoꞌó nij apóstol cuneꞌ soꞌ man nata̱ꞌ rihaan yuvii̱ cheꞌé soꞌ, ga̱a ne̱ caꞌanj ca̱yáán taranꞌ nij soꞌ rihaan mesá a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Guun ndoꞌo raj cha̱ xtiꞌno̱ ꞌu̱nj cheꞌé chaꞌanj pascuá nihánj ga̱ nij soj cuano̱ nihánj ga̱a ataa qui̱ránꞌ ꞌu̱nj sayuun a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ꞌO̱ se cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa se̱ chá xtiꞌno̱ uún ꞌu̱nj ga̱ soj a̱ ꞌó chaꞌanj nihánj nda̱a se quisi̱j güii ca̱nuû chaꞌanj pascuá naca̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj a̱ man ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ga̱a ne̱ nica̱j soꞌ ꞌo̱ agaꞌ tazá na vinó, ne̱ nagoꞌ soꞌ graciá rihaan Diose̱, ga̱a ne̱ cataj soꞌ: ―Qui̱taꞌaa soj na nihánj, cuxra̱ꞌ taꞌa̱j soj, ne̱ coꞌo̱ cunuda̱nj soj á. ");
INSERT INTO trcNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ꞌO̱ se cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa veé do̱j nihánj me coꞌo̱j, ne̱ se̱ coꞌoj ya̱j a̱ maꞌ. Tza̱j ne̱ asa̱ꞌ quisíj güii gu̱un chij Diose̱ rihaan chumii̱ nihánj, ne̱ coꞌo̱j ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ga̱a ne̱ nica̱j soꞌ rachrúún, ne̱ nagoꞌ soꞌ graciá rihaan Diose̱, ga̱a ne̱ cuxraꞌ soꞌ rachrúún, ne̱ rqué soꞌ man nij soꞌ, ne̱ cataj soꞌ: ―Nee̱ manj me rachrúún nihánj na̱nj á. Caꞌve̱j rá ꞌu̱nj cavi̱ꞌ nee̱ manj cheꞌé soj, ne̱ cha̱ soj man nihánj, ga̱a ne̱ yoꞌo̱ cu̱nuû rá soj manj ei ―taj soꞌ rihaan nij apóstol a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ga̱a ne̱ ase vaa quiꞌyaj soꞌ ga̱ rachrúún roꞌ, da̱nj quiꞌyaj uún soꞌ ga̱ agaꞌ nu̱u̱ na vinó ga̱a quisíj chá xtiꞌno̱ nij soꞌ, ne̱ cataj soꞌ: ―Na vinó nihánj roꞌ, me ton manj a. Cheꞌé ton manj roꞌ, rqué Diose̱ ꞌo̱ nana̱ rihaan soj da̱j quiꞌya̱j Diose̱ ga̱ soj a. Dan me se cheꞌé se caya̱nj ton manj roꞌ, cheꞌé dan me cara̱a̱ xꞌnaa Diose̱ ni̱ꞌyaj Diose̱ cacunꞌ tumé yuvii̱ na̱nj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ne̱ cataj uún Jesucristó a: ―Tza̱j ne̱ xca̱j soj cuentá se vaa vaa ꞌo̱ síí ta̱cuachén manj rihaan nij síí ta̱j riꞌyunj manj, ne̱ táá raꞌa soꞌ rihaan chruun mesá ta̱j raꞌaj nihánj cuano̱ ei. ");
INSERT INTO trcNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ꞌO̱ se xa̱ꞌ ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱, tza̱j ne̱ caꞌa̱nj ꞌu̱nj cavi̱ꞌ ꞌu̱nj nda̱a vaa cataj xnaꞌanj maꞌa̱n Diose̱ a. Tza̱j ne̱ nique̱ ndoꞌo síí ta̱cuachén manj rihaan nij síí ta̱j riꞌyunj manj na̱nj á. Quira̱nꞌ uxrá soꞌ sayuun ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ga̱a ne̱ guun cheꞌe̱ nij síí tucuꞌyón se‑na̱na̱ Jesucristó nuchruj ra̱a̱ nij soꞌ ga̱ tuviꞌ nij soꞌ me tuviꞌ nij soꞌ me síí quiꞌya̱j da̱nj man Jesucristó, rá nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ga̱a ne̱ caꞌmii cunuꞌ cunuda̱nj nij síí tucuꞌyón se‑na̱na̱ Jesucristó me tuviꞌ nij soꞌ me síí gu̱un chij doj a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Nij síí nica̱j suun rey uun chij rihaan nij yuvii̱ yaníj roꞌ, rii taꞌngaꞌ uxrá nij soꞌ rihaan tuviꞌ nij soꞌ, ne̱ tucuꞌnáj nii “síí ꞌni̱j raꞌa man níꞌ” man nij soꞌ na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tza̱j ne̱ se̱ guun soj síí vaa da̱nj maꞌ. Ma̱a̱n se tuviꞌ soj síí guun rá se vaa gu̱un chij soꞌ doj rihaan soj roꞌ, vaa cheꞌé gu̱un soꞌ síí noco̱ꞌ doj rihaan soj, ne̱ gu̱un soꞌ ase vaa ꞌo̱ se‑mo̱zó soj a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Dan me se me síí me síí uun chij doj, rá soj ga̱: síí anica̱j coꞌoo rihaan mesá naꞌ, ase síí ya̱nj rihaan mesá xa̱ꞌ. Veé síí ya̱nj rihaan mesá me síí uun chij doj, rá soj a. Tza̱j ne̱ nihánj me se va̱j ma̱ꞌán ꞌu̱nj scaꞌnúj nij soj, ne̱ a̱j guún ꞌu̱nj mozó rihaan soj vaa na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","”Ne̱ xa̱ꞌ soj, tza̱j ne̱ nij soj me nij síí cachéé ga̱ ꞌu̱nj ga̱a quiránꞌ ꞌu̱nj sayuun, ");
INSERT INTO trcNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ne̱ ase vaa cuneꞌ Réj Diose̱ manj se vaa gu̱un chij ꞌu̱nj roꞌ, da̱nj ga̱a̱ cune̱ꞌ ꞌu̱nj man soj cuano̱ ");
INSERT INTO trcNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","se vaa ca̱yáán soj rihaan xrúún ꞌu̱nj chruun mesá asa̱ꞌ guun chij ma̱ꞌanj, ne̱ cha̱ soj chraa ne̱ coꞌo̱ soj na ga̱ ꞌu̱nj ado̱nj. Ne̱ quita̱j soj chruun xlá sa̱ꞌ ndoꞌo, ne̱ caꞌne̱ꞌ soj cacunꞌ cheꞌé chuvi̱j nij xꞌneꞌ yuvii̱ israelitá ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ga̱a ne̱ cataj Jesucristó rihaan síí cuꞌna̱j Simón Pedró a: ―Cu̱nó so̱ꞌ nana̱ nihánj caꞌmi̱j rihaan so̱ꞌ, Simón. ꞌO̱ se a̱j cachíín niꞌya̱j síí cuꞌna̱j Satanás rihaan Diose̱ se vaa caꞌve̱j rá Diose̱ quiꞌya̱j soꞌ sayuun man nij soj a. Dan me se ase vaa ꞌyaj nii man ꞌnúú trigó ga̱a tixrinꞌ nii ꞌnúú trigó rihaan rcuaa roꞌ, da̱nj quiꞌya̱j síí chre̱e man soj, cheꞌé se guun rá soꞌ quiri̱ꞌ soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tza̱j ne̱ a̱j cachíín ni̱ꞌyáá ꞌu̱nj rihaan Diose̱ cheꞌé so̱ꞌ, se vaa se̱ caꞌneꞌ rá so̱ꞌ ga̱ suun amán rá niꞌya̱j manj a̱ maꞌ. Ga̱a ne̱ asa̱ꞌ nanica̱j nimán so̱ꞌ canocoꞌ uún so̱ꞌ manj roꞌ, ne̱ ra̱cuíj so̱ꞌ man nij tinúú so̱ꞌ se vaa cunu̱u sca̱ꞌ doj nimán nij soꞌ uún á ―taj Jesucristó rihaan síí cuꞌna̱j Simón Pedró yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ga̱a ne̱ cataj soꞌ rihaan Jesucristó a: ―Tza̱j ne̱ a̱j caꞌnéé nimanj yoꞌo̱ cache̱e̱ ꞌu̱nj ga̱ so̱ꞌ, Señor. Caꞌve̱e se caxri̱i̱ nii tagaꞌ mán so̱ꞌ caꞌve̱e se ticavi̱ꞌ nii mán so̱ꞌ caꞌve̱e se, tza̱j ne̱ se̱ tanáj xco̱ ꞌu̱nj mán so̱ꞌ maꞌ ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tza̱j ne̱ cataj Jesucristó rihaan Pedró a: ―Nihánj me cata̱j ꞌu̱nj rihaan so̱ꞌ da̱j qui̱ꞌyáá so̱ꞌ, Pedró. Neꞌén ꞌu̱nj se vaa asa̱ꞌ ataa cagua̱j toꞌloo nii̱ corá, ne̱ vaꞌnu̱j cata̱j so̱ꞌ se vaa ne neꞌén so̱ꞌ manj maꞌ ―taj Jesucristó rihaan Pedró a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ga̱a ne̱ cataj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a: ―Ga̱a caꞌnéé ꞌu̱nj man soj caꞌmi̱i̱ natáj soj se‑na̱na̱j rihaan nij yuvii̱ israelitá ne̱ taj nanj taj vitó taj canj taj caꞌanj nica̱j soj ga̱a caꞌanj soj, tza̱j ne̱ taj va̱j rasu̱u̱n cachiin man soj ga̱a caꞌanj soj, rá ꞌu̱nj a ―taj Jesucristó rihaan nij soꞌ a. ―Taj va̱j a̱ doj rasu̱u̱n ne cachi̱in man núj maꞌ ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Ya̱j me se sese vaa xnánj soj do̱ꞌ, se‑vito̱ soj do̱ꞌ, ne̱ ni̱caj soj caꞌa̱nj soj á. Ne̱ sese taj yan vaj neê espadá rihaan soj, ne̱ quira̱a̱n soj ꞌo̱ taneê soj neê espadá á. Ne̱ sese nuviꞌ saꞌanj rihaan yoꞌo̱ tuviꞌ soj, ne̱ vaa cheꞌé cutuꞌve̱e̱ soꞌ se‑ro̱to̱ soꞌ, ne̱ quira̱a̱n soꞌ neê espadá ei. ");
INSERT INTO trcNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ꞌO̱ se vaa nana̱ no̱ rihaan danj Diose̱ taj: “Cataj nii se vaa si̱j ꞌyaj cacunꞌ me soꞌ”, taj danj Diose̱ cheꞌé ꞌu̱nj, ne̱ vaa cheꞌé quisi̱j ya̱ nu̱ꞌ nana̱ yoꞌ cheꞌej a. ꞌO̱ se da̱j doj quinavi̱j se vaa ꞌyáá ꞌu̱nj rihaan chumii̱ nihánj na̱nj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ga̱a ne̱ cataj nij soꞌ rihaan Jesucristó a: ―Ni̱ꞌyaj so̱ꞌ ei. Vaa vi̱j neê espadá rihaan níꞌ nihánj, Señor ―taj nij soꞌ a. ―Veé da̱nj me se da̱nj na̱nj á ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ga̱a ne̱ cavii soꞌ caꞌanj soꞌ quij cuꞌna̱j Quij ma̱n Chruun Olivó, nda̱a vaa cuꞌyón ina̱nj soꞌ quiꞌya̱j soꞌ a. Ne̱ canocoꞌ nij síí tucuꞌyón se‑na̱na̱ soꞌ rej xco̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ne̱ ga̱a cuchiꞌ nij soꞌ rej yoꞌ, ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Cachi̱nj niꞌya̱j soj rihaan Diose̱ se vaa ca̱ráán Diose̱ chrej rihaan síí chre̱e se̱ gaa na̱nj gu̱un rá soj quiꞌya̱j soj cacunꞌ quiꞌya̱j síí chre̱e á ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ga̱a ne̱ naxuun soꞌ man soꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ caꞌanj soꞌ rej yaníj do̱j, ne̱ canicunꞌ ru̱j soꞌ, ne̱ cachíín niꞌya̱j soꞌ rihaan Diose̱, ");
INSERT INTO trcNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ne̱ cataj soꞌ rihaan Diose̱ a: ―Sese caꞌve̱e, ne̱ ca̱ráán raꞌá so̱ꞌ xráj, se̱ gaa na̱nj quira̱nꞌ uxrá ꞌu̱nj sayuun, tza̱j ne̱ sese ma̱ꞌán so̱ꞌ me rá qui̱ránꞌ ꞌu̱nj sayuun, ne̱ qui̱ꞌyáá so̱ꞌ nda̱a vaa me rá ma̱ꞌán so̱ꞌ, ne̱ se̱ quiꞌyáá so̱ꞌ nda̱a vaa me rá ma̱ꞌanj maꞌ ―taj Jesucristó, cachíín niꞌya̱j soꞌ rihaan Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ga̱a ne̱ curuviꞌ yoꞌo̱ se‑mo̱zó Diose̱ cavii rej xta̱ꞌ rihaan soꞌ, ne̱ nariꞌ nucuaj nimán soꞌ, quiꞌyaj se‑mo̱zó Diose̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ne̱ nanó ndoꞌo rá soꞌ, ne̱ nucua̱j ndoꞌo cachíín niꞌya̱j soꞌ rihaan Diose̱, ne̱ cavii ndoꞌo nihaa̱ rihaan soꞌ, ne̱ ase vaa ton vaa nihaa̱ cavii rihaan soꞌ cayanj rihaan yoꞌóó a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ne̱ canicunꞌ caya̱ soꞌ, ne̱ caꞌanj soꞌ rej ne̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ, tza̱j ne̱ queneꞌen soꞌ se vaa cotoj nu̱ꞌ nij soꞌ, cheꞌé se nanó ndoꞌo rá nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Me cheꞌé otoj soj ga̱. Na̱xuma̱a̱n soj cachi̱nj niꞌya̱j soj rihaan Diose̱ se̱ gaa na̱nj gu̱un rá soj quiꞌya̱j soj cacunꞌ quiꞌya̱j síí chre̱e á ―taj soꞌ rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Dan me se nicu̱nꞌ Jesucristó caꞌmii soꞌ, ne̱ nu̱ꞌ caꞌnaꞌ queꞌe̱e̱ yuvii̱, ne̱ síí cuꞌna̱j Judas yoꞌo̱ tuviꞌ chuvi̱j nij síí tucuꞌyón se‑na̱na̱ Jesucristó me síí táá ya̱a̱n rihaan nij yuvii̱, ne̱ quinichrunꞌ síí cuꞌna̱j Judas rihaan Jesucristó, cheꞌé rej guun rá soꞌ cachro̱n tuꞌva̱ soꞌ xruu̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ga̱a ne̱ cataj Jesucristó rihaan Judas a: ―Ne chiha̱nꞌ uxrá ꞌyáá so̱ꞌ, se vaa tacuachén so̱ꞌ manj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ ga̱a cachro̱n tu̱ꞌvá so̱ꞌ xruj, man Judas ―taj soꞌ rihaan Judas yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Dan me se queneꞌen nij síí nicu̱nꞌ ga̱ Jesucristó da̱j quiꞌya̱j nij yuvii̱ man Jesucristó, ne̱ cheꞌé dan xnáꞌanj nij soꞌ man Jesucristó a: ―Go̱ꞌ núj neê espadá raa̱ nij soꞌ, rá so̱ꞌ naꞌ ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ne̱ yoꞌo̱ tuviꞌ nij soꞌ roꞌ, goꞌ taneê soꞌ neê espadá raa̱ se‑mo̱zó xrej ata̱ suun noco̱o doj, ne̱ güéj nu̱ꞌ xréé yoꞌ rej nuva̱ꞌ yoꞌ, quiꞌyaj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Caꞌne̱ꞌ rá soj ga̱ suun ꞌyaj da̱nj á ―taj Jesucristó rihaan nij soꞌ a. Ga̱a ne̱ cutaꞌ Jesucristó raꞌa Jesucristó rej quiranꞌ chiꞌii̱ xréé mozó yoꞌ, ne̱ nu̱ꞌ orá nahuun sa̱ꞌ xréé mozó yoꞌ, quiꞌyaj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ga̱a ne̱ cataj Jesucristó rihaan nij xrej ata̱ suun noco̱o doj do̱ꞌ, rihaan tanuu uun chij rihaan nij tanuu tumé nuvií do̱ꞌ, rihaan nij síí uun chij rihaan nij yuvii̱ israelitá do̱ꞌ a: ―Me cheꞌé ꞌnaꞌ neê espadá ꞌnaꞌ chruun ꞌnaꞌ ga̱ soj ga̱. Síí itu̱u̱ mé ꞌu̱nj, rá soj naꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ꞌO̱ se daj a̱ güii yáán ꞌu̱nj ga̱ nij soj rá nuvií noco̱o, tza̱j ne̱ ne gu̱un rá soj qui̱taꞌaa soj mán ꞌu̱nj maꞌ. Tza̱j ne̱ cuano̱ nihánj me se a̱j quisíj orá caꞌve̱e quiꞌya̱j soj nda̱a vaa me rá soj quiꞌya̱j soj, ne̱ nihánj me se caꞌve̱e gu̱un nucua̱j soj si̱j va̱j rej rmi̱ꞌ a ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dan me se quitaꞌaa nij soꞌ man Jesucristó, ne̱ caꞌanj nica̱j nij soꞌ man Jesucristó rá veꞌ tucuá xrej ata̱ suun noco̱o doj, ne̱ ga̱nꞌ ga̱nꞌ canocoꞌ síí cuꞌna̱j Pedró rej xco̱ Jesucristó, ꞌnaꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Dan me se naranꞌ nii yaꞌan rá veꞌ, ne̱ yáán tacuachriin taranꞌ nii rihaan yaꞌan, ne̱ yáán síí cuꞌna̱j Pedró scaꞌnúj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Dan me se yáán soꞌ rej chuguu̱n yaꞌan rihaan nij tuviꞌ xrej, ne̱ queneꞌen yoꞌo̱ mozó cha̱na̱ man soꞌ, ne̱ niꞌya̱j uxrá chana̱ yoꞌ man soꞌ a. Ga̱a ne̱ cataj mozó cha̱na̱ yoꞌ rihaan tuviꞌ noꞌ síí ma̱n ga̱ noꞌ a: ");
INSERT INTO trcNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","―Síí nihánj roꞌ, me yoꞌo̱ síí cachéé ga̱ Jesucristó a ―taj chana̱ yoꞌ, niꞌya̱j yoꞌ man Pedró a. Ga̱a ne̱ cataj Pedró rihaan chana̱ yoꞌ a: ―Ne neꞌén ꞌu̱nj man soꞌ, man nocoj ―taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ne̱ yoꞌó orá nii me se queneꞌen yoꞌó soꞌ man Pedró uún a: ―Yoꞌo̱ tuviꞌ nij síí chéé ga̱ soꞌ mé so̱ꞌ ei ―taj soꞌ rihaan Pedró a. ―Taj maꞌ. Nuveé si̱j chéé ga̱ soꞌ mé ꞌu̱nj, man tinu̱j ―taj Pedró yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Dan me se cachén yoꞌó orá uún, ga̱a ne̱ nucua̱j caꞌmii yoꞌó soꞌ a: ―Ya̱ uxrá si̱j cachéé ga̱ Jesucristó me síí nihánj na̱nj ei. ꞌO̱ se si̱j cavii estadó Galilea me ro̱j soꞌ ga̱ Jesucristó chugua̱nj ―taj yoꞌó soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ga̱a ne̱ cataj Pedró rihaan síí tuꞌva da̱nj a: ―Ne uno uxraj me taj so̱ꞌ, man tinu̱j ―taj soꞌ rihaan nij soꞌ a. Ne̱ dan me se nu̱ꞌ caꞌmii soꞌ da̱nj, ne̱ nu̱ꞌ caguáj toꞌloo a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ga̱a ne̱ canica̱j síí ꞌni̱j raꞌa man níꞌ, ne̱ niꞌya̱j soꞌ man Pedró, ga̱a ne̱ nanuj rá Pedró se‑na̱na̱ síí ꞌni̱j raꞌa man níꞌ ga̱a cataj síí ꞌni̱j raꞌa man níꞌ rihaan soꞌ: “Neꞌén ꞌu̱nj se vaa asa̱ꞌ ataa cagua̱j toꞌloo nii̱ corá, ne̱ vaꞌnu̱j cata̱j so̱ꞌ se vaa ne neꞌén so̱ꞌ manj maꞌ”, cataj síí ꞌni̱j raꞌa man níꞌ rihaan soꞌ quii a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Dan me se ga̱a niꞌya̱j síí ꞌni̱j raꞌa man níꞌ man Pedró, ga̱a ne̱ curiha̱nj Pedró xeꞌ, ne̱ taꞌvee ndoꞌo soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ga̱a ne̱ nij síí quitaꞌaa man Jesucristó roꞌ, tihaꞌ ndoꞌo nij soꞌ man soꞌ, ne̱ goꞌ nij soꞌ xráá soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ne̱ ga̱a goꞌ nij soꞌ xráá soꞌ me se caráán nij soꞌ rihaan Jesucristó, ne̱ cataj nij soꞌ rihaan soꞌ a: ―Cata̱j so̱ꞌ rihaan núj me síí goꞌ mán so̱ꞌ á ―taj nij soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ne̱ queꞌe̱e̱ doj nana̱ nij aꞌmii uún nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ne̱ ga̱a quisíj güii, ne̱ cunuu chre̱ꞌ nij síí uun chij rihaan nij yuvii̱ israelitá, ne̱ dan me se nij xrej ata̱ suun noco̱o doj do̱ꞌ, nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés do̱ꞌ, cunuu chre̱ꞌ, ne̱ caꞌanj nica̱j nij soꞌ man Jesucristó rá veꞌ aꞌneꞌ nij soꞌ cacunꞌ cheꞌé yuvii̱ a. Ga̱a ne̱ xnáꞌanj nij soꞌ man Jesucristó, ne̱ cataj nij soꞌ: ");
INSERT INTO trcNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Sese ya̱ si̱j caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun mé so̱ꞌ, rá so̱ꞌ, ne̱ cata̱j xnaꞌanj so̱ꞌ rihaan núj á ―taj nij soꞌ a. Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Caꞌve̱e se cata̱j xnaꞌanj ꞌu̱nj rihaan soj, tza̱j ne̱ se̱ cuchumán rá soj se‑na̱na̱j maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ne̱ sese xna̱ꞌanj ꞌu̱nj ꞌo̱ nana̱ man soj, tza̱j ne̱ se̱ cataj xnaꞌanj soj rihanj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tza̱j ne̱ rej rihaan níꞌ me se xa̱ꞌ ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱, tza̱j ne̱ ca̱yáán ꞌu̱nj rej nuva̱ꞌ Diose̱ síí nucua̱j ndoꞌo a ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ga̱a ne̱ xnáꞌanj cunuda̱nj nij soꞌ man Jesucristó, cataj nij soꞌ: ―Cheꞌé dan me taꞌni̱j Diose̱ mé so̱ꞌ, rá so̱ꞌ naꞌ ―taj nij soꞌ rihaan soꞌ a. Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Veé ya̱ nda̱a vaa cataj soj roꞌ, veé da̱nj vaa na̱nj á ―taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ga̱a ne̱ cataj nij soꞌ rihaan tuviꞌ nij soꞌ a: ―Se̱ cachiin doj síí caꞌna̱ꞌ cata̱j xnaꞌanj rihaan níꞌ cheꞌé cacunꞌ tumé síí nihánj a̱ maꞌ. ꞌO̱ se maꞌa̱n níꞌ me síí cuno da̱j tuꞌva soꞌ nihánj na̱nj ado̱nj ―taj nij soꞌ rihaan tuviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Dan me se queꞌe̱e̱ nij soꞌ, ne̱ naxuma̱a̱n taranꞌ nij soꞌ, ne̱ caꞌanj nica̱j nij soꞌ man Jesucristó rihaan síí cuꞌna̱j Pilato a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ga̱a ne̱ cutaꞌ nij soꞌ cacunꞌ xráá soꞌ rihaan síí cuꞌna̱j Pilato, ne̱ cataj nij soꞌ rihaan síí cuꞌna̱j Pilato a: ―Síí nihánj roꞌ, me síí tucuꞌyón tucuáán ne̱ rihaan tuviꞌ núj si̱j israelitá, ne̱ cataj soꞌ se vaa se̱ goꞌ yuvii̱ puextó rihaan síí nica̱j suun cuꞌna̱j César, ne̱ taj soꞌ se vaa si̱j caꞌnéé Diose̱ gu̱un síí nica̱j suun rey me maꞌa̱n soꞌ, taj soꞌ ado̱nj ―taj nij soꞌ rihaan síí cuꞌna̱j Pilato, niꞌya̱j nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ga̱a ne̱ xnáꞌanj síí cuꞌna̱j Pilato man Jesucristó a: ―So̱ꞌ me síí nica̱j suun rey uun chij rihaan nij yuvii̱ israelitá naꞌ ―taj soꞌ, xnáꞌanj soꞌ man Jesucristó a. ―Vej á ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ga̱a ne̱ cataj síí cuꞌna̱j Pilato rihaan nij xrej ata̱ suun noco̱o doj do̱ꞌ, rihaan nij yuvii̱ do̱ꞌ a: ―Nuviꞌ cacunꞌ tumé síí nihánj narij maꞌ ―taj soꞌ a: ");
INSERT INTO trcNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tza̱j ne̱ nucua̱j doj caꞌmii nij soꞌ, cataj nij soꞌ: ―Tza̱j ne̱ queꞌe̱e̱ yuvii̱ uno se‑na̱na̱ soꞌ, ne̱ vaa güii quiꞌya̱j nij soꞌ sayuun na̱nj á. Ne̱ va̱j soꞌ tucuꞌyón soꞌ se‑na̱na̱ soꞌ nu̱ꞌ estadó Judea nihánj, ne̱ guun cheꞌe̱ soꞌ tucuꞌyón soꞌ se‑na̱na̱ soꞌ estadó Galilea, ne̱ ꞌnaꞌ soꞌ nda̱a nihánj tucuꞌyón soꞌ na̱nj ado̱nj ―taj nij soꞌ rihaan Pilato a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Dan me se cuno Pilato se‑na̱na̱ nij soꞌ, ga̱a ne̱ xnáꞌanj Pilato man nij soꞌ sese si̱j cavii estadó Galilea me Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ga̱a ne̱ queneꞌen soꞌ se vaa ya̱ cavii Jesucristó estadó Galilea rej uun chij síí cuꞌna̱j Herodes a. Cheꞌé dan cataj soꞌ se vaa caꞌa̱nj ni̱caj nij soꞌ man Jesucristó rihaan síí cuꞌna̱j Herodes yoꞌ a. ꞌO̱ se güii dan me se nuû maꞌa̱n síí cuꞌna̱j Herodes chumanꞌ Jerusalén a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ga̱a queneꞌen síí cuꞌna̱j Herodes man Jesucristó, ga̱a ne̱ guun niha̱ꞌ uxrá rá soꞌ a. ꞌO̱ se asi̱j rque̱ ndoꞌo me se guun rá soꞌ queneꞌe̱n soꞌ man Jesucristó, cheꞌé se a̱j cuchiꞌ nana̱ rihaan soꞌ da̱j ꞌyaj Jesucristó a. Ne̱ guun rá soꞌ se vaa quiꞌya̱j Jesucristó ꞌo̱ suun sa̱ꞌ noco̱o ni̱ꞌyaj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Dan me se xnáꞌanj ndoꞌo soꞌ nana̱ man Jesucristó, tza̱j ne̱ a̱ ꞌó nana̱ ne caꞌmi̱i̱ Jesucristó rihaan soꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tza̱j ne̱ nicu̱nꞌ nij xrej ata̱ suun noco̱o doj nicu̱nꞌ nij síí naquiꞌyaj cu̱u se‑tucua̱nj Moisés rihaan nij yuvii̱ nicu̱nꞌ, ne̱ nucua̱j ndoꞌo cutaꞌ nij soꞌ cacunꞌ xráá Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ga̱a ne̱ nachriꞌ Herodes do̱ꞌ, nij tanuu nu̱u̱ rihaan soꞌ do̱ꞌ, niꞌya̱j nij soꞌ man Jesucristó, ne̱ caꞌngaꞌ naco̱o̱ nij soꞌ niꞌya̱j nij soꞌ man Jesucristó a. Ga̱a ne̱ naꞌnéé nij soꞌ yatzíj sedá man Jesucristó quiꞌyaj Herodes, ne̱ veé dan naꞌnéé uún Herodes man soꞌ rihaan Pilato a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ne̱ güii dan me se guun cheꞌe̱ Herodes ga̱ Pilato naꞌmii sa̱ꞌ ro̱j soꞌ ga̱ tuviꞌ ro̱j soꞌ a. ꞌO̱ se asi̱j rque̱ doj me se si̱j ta̱j riꞌyunj man tuviꞌ me ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Dan me se canacúún síí cuꞌna̱j Pilato man nij xrej ata̱ suun noco̱o doj do̱ꞌ, man nij síí uun chij rihaan nij yuvii̱ israelitá do̱ꞌ, man maꞌa̱n nij yuvii̱ do̱ꞌ, se vaa caꞌna̱ꞌ nij soꞌ cunu̱u chre̱ꞌ nij soꞌ rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ga̱a ne̱ cataj Pilato rihaan nu̱ꞌ nij yuvii̱ a: ―Dan me se nica̱j soj man snóꞌo nihánj caꞌnaꞌ soj rihanj, ne̱ cataj soj se vaa soꞌ me síí me rá quiꞌya̱j nij yuvii̱ sayuun a. Ne̱ veé xnáꞌanj ꞌu̱nj man soꞌ cuno taranꞌ soj da̱j ꞌyaj soꞌ, ne̱ xa̱ꞌ cacunꞌ cutaꞌ soj xráá soꞌ, tza̱j ne̱ taj va̱j cacunꞌ vaa da̱nj tumé síí nihánj narij maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ne̱ síí cuꞌna̱j Herodes roꞌ, ne nari̱ꞌ soꞌ cacunꞌ tumé síí nihánj a̱ maꞌ. Ma̱a̱n se naꞌnéé u̱u̱n síí cuꞌna̱j Herodes man síí nihánj rihaan níꞌ na̱nj á. Ne̱ xca̱j soj cuentá se vaa taj cacunꞌ quiꞌyaj síí nihánj, ne̱ ne nó xcúún soꞌ cavi̱ꞌ soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Cheꞌé dan qui̱ꞌyáj do̱j sayuun man soꞌ, ne̱ caꞌa̱nj u̱u̱n soꞌ, quiꞌya̱j níꞌ na̱nj á ―taj Pilato rihaan taranꞌ nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ꞌO̱ se ma̱a̱n güii dan me se daj a̱ chaꞌanj pascuá naꞌnéé nij soꞌ man ꞌo̱ yuvii̱ ꞌni̱j tagaꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ga̱a ne̱ caguáj cunuda̱nj nij soꞌ, cataj nij soꞌ a: ―Ticavi̱ꞌ soj man síí nihánj ei. Ticavi̱ꞌ soj man síí nihánj ei. Ne̱ quiri̱i̱ so̱ꞌ man síí cuꞌna̱j Barrabás tagaꞌ cheꞌé núj á ―taj nij soꞌ, caguáj nij soꞌ rihaan Pilato a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ne̱ xa̱ꞌ síí cuꞌna̱j Barrabás, tza̱j ne̱ si̱j quiꞌyaj cunuꞌ nij yuvii̱ ma̱n chumanꞌ Jerusalén me soꞌ, ne̱ si̱j ticaviꞌ man yuvii̱ me soꞌ, ne̱ cheꞌé dan caxríj nii tagaꞌ man soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ga̱a ne̱ caꞌmii uún Pilato rihaan nij yuvii̱ a. ꞌO̱ se guun rá soꞌ quiri̱i̱ soꞌ man Jesucristó caꞌa̱nj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ga̱a ne̱ caguáj nu̱ꞌ nij yuvii̱, cataj nij soꞌ: ―Cano̱ ya̱ soꞌ rihaan rcutze̱ ei ―taj nij yuvii̱, caguáj nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ga̱a ne̱ quisíj vaꞌnu̱j cataj soꞌ rihaan nij yuvii̱: ―Tza̱j ne̱ taj va̱j se chiꞌi̱i̱ quiꞌyaj soꞌ maꞌ. Taj va̱j cacunꞌ tumé soꞌ, ne̱ ne nó xcúún soꞌ cavi̱ꞌ soꞌ maꞌ. Dan me se qui̱ꞌyáj do̱j sayuun man soꞌ, ne̱ caꞌa̱nj u̱u̱n soꞌ qui̱ꞌyáj na̱nj á ―taj uún Pilato rihaan nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tza̱j ne̱ caguáj ndoꞌo nij yuvii̱, ne̱ uxrá caꞌneꞌ nij yuvii̱ suun rihaan Pilato se vaa ya̱ cavi̱ꞌ Jesucristó rihaan rcutze̱ quiꞌya̱j soꞌ, ne̱ guun nucua̱j doj se‑na̱na̱ nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ga̱a ne̱ guun ya̱ rá Pilato se vaa quiꞌya̱j soꞌ nda̱a vaa cataj nij yuvii̱ rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Dan me se síí ꞌni̱j tagaꞌ tumé cacunꞌ se vaa cunuꞌ yuvii̱ quiꞌyaj do̱ꞌ, se vaa ticaviꞌ yuvii̱ do̱ꞌ, quirii Pilato man soꞌ caꞌa̱nj u̱u̱n soꞌ, nda̱a vaa cataj nij yuvii̱ a. Ne̱ Jesucristó roꞌ, caꞌvej rá Pilato quira̱nꞌ soꞌ nda̱a vaa guun rá nij yuvii̱ quira̱nꞌ soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Dan me se nica̱j nii man Jesucristó caꞌanj nii, ga̱a ne̱ quitaꞌaa nii man yoꞌo̱ síí cuꞌna̱j Simón síí cavii chumanꞌ Cirene ga̱a ꞌnaꞌ nique soꞌ rej tacaan, ne̱ cutaꞌ nii rcutze̱ xráá soꞌ ata̱ soꞌ rcutze̱ ꞌnaꞌ soꞌ rej xco̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ne̱ nocoꞌ queꞌe̱e̱ yuvii̱ man Jesucristó, ne̱ taꞌa̱j nij yuvii̱ me chana̱, ne̱ dan me se goꞌ nij chana̱ se‑cuxru̱ꞌ nij noꞌ rucua̱a̱ nij noꞌ, ne̱ taꞌvee ndoꞌo nij chana̱ niꞌya̱j nij chana̱ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ga̱a ne̱ canica̱j Jesucristó, cataj Jesucristó rihaan nij chana̱ yoꞌ: ―Cuno̱ soj cha̱na̱ taꞌni̱j chumanꞌ Jerusalén caꞌmi̱j á. Se̱ taꞌvee nij soj ni̱ꞌyaj soj mán ꞌu̱nj a̱ maꞌ. Tza̱j ne̱ taꞌve̱e soj ni̱ꞌyaj soj man maꞌa̱n soj do̱ꞌ, man maꞌa̱n taꞌníí soj do̱ꞌ á. ");
INSERT INTO trcNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ꞌO̱ se vaa güii cata̱j nii se vaa a̱j cavii sa̱ꞌ doj nij chana̱ itu̱un do̱ꞌ, nij chana̱ ne nari̱ꞌ neꞌej do̱ꞌ, nij chana̱ ne tucutzi̱i neꞌej do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ꞌO̱ se güii dan me se gu̱un cheꞌe̱ yuvii̱ nacu̱nj yuvii̱ nij quij se vaa cane̱e̱ nij quij ca̱ráán nij quij xráá maꞌa̱n nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ꞌO̱ se ase vaa chruun maree̱ vaa iꞌna̱ꞌ vaa ꞌu̱nj nihánj, tza̱j ne̱ da̱nj na̱nj ticavi̱ꞌ nii manj a. Táá a̱ nij síí ne̱ chumanꞌ Jerusalén, ne̱ ase vaa chruun naco̱o̱ caviꞌ vaa nij síí tumé cacunꞌ ne̱ chumanꞌ Jerusalén, ne̱ cheꞌé dan chiꞌi̱i̱ uxrá doj quira̱nꞌ nij soꞌ na̱nj ado̱nj ―taj Jesucristó rihaan nij chana̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ne̱ nica̱j nii man yavíj ro̱j síí tumé cacunꞌ, caꞌanj nii rej cavi̱ꞌ ro̱j soꞌ ga̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ne̱ ga̱a cuchiꞌ taranꞌ nij soꞌ rej cuꞌna̱j Tacaan Cúú Yave̱ Xnangá, ne̱ cachrón nii man Jesucristó ga̱ ro̱j síí tumé cacunꞌ rihaan vaꞌnu̱j rcutze̱, ne̱ dan me se yoꞌo̱ soꞌ roꞌ, cachrón nii rej nuva̱ꞌ Jesucristó, ne̱ yoꞌó soꞌ roꞌ, cachrón nii rej nichru̱un Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ga̱a ne̱ cachíín niꞌya̱j Jesucristó rihaan Diose̱, cataj soꞌ: ―Cara̱a̱ xꞌnaa so̱ꞌ, ne̱ se̱ quiꞌyáá so̱ꞌ sayuun man nij soꞌ, man Ata̱j Chij. ꞌO̱ se ne neꞌen nij soꞌ da̱j ꞌyaj nij soꞌ maꞌ ―taj soꞌ, cachíín niꞌya̱j soꞌ rihaan Rej soꞌ Diose̱ a. Ga̱a ne̱ tico tixaj nij tanuu cheꞌé saga̱nꞌ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ne̱ canicunꞌ queꞌe̱e̱ yuvii̱ niꞌya̱j da̱j quira̱nꞌ Jesucristó a. Dan me se caꞌngaꞌ naco̱o̱ nij síí uun chij, cataj nij soꞌ: ―A̱j tinanii soꞌ man yoꞌó yuvii̱ rihaan sayuun, rá soꞌ á. Caꞌve̱e ti̱nanii soꞌ man maꞌa̱n soꞌ ya̱j ei. Sese si̱j narii Diose̱ me soꞌ do̱ꞌ, sese si̱j caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun me soꞌ do̱ꞌ, ne̱ caꞌve̱e ti̱nanii maꞌa̱n soꞌ man soꞌ a ―taj nij síí uun chij niꞌya̱j nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ne̱ nij tanuu, tza̱j ne̱ caꞌngaꞌ naco̱o̱ uún nij tanuu niꞌya̱j nij tanuu man Jesucristó, ne̱ ruꞌmaan nij tanuu na vinó yu̱u̱ tuꞌva Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ne̱ cataj nij soꞌ: ―Sese so̱ꞌ me síí nica̱j suun rey uun chij rihaan nij yuvii̱ israelitá, ne̱ ti̱nanii so̱ꞌ man ma̱ꞌán so̱ꞌ rihaan sayuun ya̱j vij ―taj nij tanuu rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ne̱ vaa rcuchra̱ꞌ nó rihaan rcutze̱ yoꞌ, ne̱ nó nana̱ rihaan rcuchra̱ꞌ yoꞌ se vaa: “Si̱j nica̱j suun rey uun chij rihaan nij yuvii̱ israelitá me síí nihánj a”, taj nana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ne̱ yoꞌo̱ tuviꞌ ro̱j síí tumé cacunꞌ noco̱ꞌ rihaan rcutze̱ rej xꞌnu̱j Jesucristó roꞌ, nij caꞌmii soꞌ rihaan Jesucristó, cataj soꞌ: ―Si̱j caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun mé so̱ꞌ, rá so̱ꞌ naꞌ. Me cheꞌé ne tinanii so̱ꞌ man taranꞌ níꞌ ga̱ ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tza̱j ne̱ yoꞌó síí tumé cacunꞌ roꞌ, cataj soꞌ rihaan tuviꞌ soꞌ: ―Nihánj me se cuya̱a̱n vaa sayuun ranꞌ níꞌ ga̱ sayuun ranꞌ síí nihánj na̱nj á. Ne̱ me cheꞌé ne chuꞌvíꞌ so̱ꞌ a̱ doj niꞌya̱j so̱ꞌ Diose̱ ga̱. ");
INSERT INTO trcNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Dan me se xa̱ꞌ níꞌ, tza̱j ne̱ vaa cheꞌé cavi̱ꞌ níꞌ, ne̱ ranꞌ níꞌ sayuun cheꞌé cacunꞌ tumé níꞌ, tza̱j ne̱ xa̱ꞌ síí nihánj, tza̱j ne̱ taj va̱j a̱ doj se chiꞌi̱i̱ ne quiꞌya̱j síí nihánj a̱ maꞌ ―taj yoꞌó síí tumé cacunꞌ yoꞌ rihaan tuviꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ga̱a ne̱ cataj soꞌ rihaan Jesucristó a: ―Se̱ quiniꞌyón so̱ꞌ ra̱cuíj so̱ꞌ manj, asa̱ꞌ guun cheꞌe̱ so̱ꞌ guun chij so̱ꞌ a̱ maꞌ ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan so̱ꞌ cuano̱ se vaa güii cuanꞌ me se ca̱yáán so̱ꞌ ga̱ ꞌu̱nj rej sa̱ꞌ ndoꞌo rej ne̱ nij síí sa̱ꞌ rihaan Diose̱ ei ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Veé dan, ne̱ caxu̱j me yoꞌ, ne̱ guun rmi̱ꞌ rihaan nu̱ꞌ chumii̱, ne̱ yoꞌo̱ guun rmi̱ꞌ rihaan chumii̱ nda̱a quisíj agaꞌ vaꞌnu̱j rej anocoꞌ güii a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ne̱ guun rmi̱ꞌ rihaan güii, ne̱ sinꞌ nu̱ꞌ yatzíj cortiná noco̱ꞌ rá nuvií noco̱o a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ga̱a ne̱ nucua̱j ndoꞌo caguáj Jesucristó, cataj soꞌ: ―Naca̱j so̱ꞌ nimanj, Ata̱j Chij ―taj soꞌ, ne̱ veé dan caviꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Dan me se queneꞌen tanuu capitán se vaa guun, ga̱a ne̱ veꞌé uxrá caꞌmii soꞌ cheꞌé Diose̱, ne̱ cataj soꞌ: ―Xa̱ꞌ síí nihánj, tza̱j ne̱ ya̱ ya̱ síí sa̱ꞌ me soꞌ na̱nj á ―taj tanuu yoꞌ niꞌya̱j soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Dan me se queneꞌen taranꞌ nij yuvii̱ cunuu chre̱ꞌ rej yoꞌ se vaa guun, ga̱a ne̱ goꞌ nij soꞌ se‑cuxru̱ꞌ nij soꞌ rucua̱a̱ nij soꞌ cheꞌé se nanó ndoꞌo rá nij soꞌ, ga̱a ne̱ canica̱j nij soꞌ caꞌanj nij soꞌ chumanꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ne̱ canicunꞌ cunuda̱nj nij tuviꞌ Jesucristó rej ga̱nꞌ doj, ne̱ taꞌa̱j nij soꞌ me chana̱ cuno se‑na̱na̱ Jesucristó asi̱j cavii Jesucristó estadó Galilea a. Ne̱ niꞌya̱j taranꞌ nij soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ne̱ vaa ꞌo̱ síí cuꞌna̱j José, ne̱ yoꞌo̱ tuviꞌ nij síí uun chij rihaan nij yuvii̱ israelitá me soꞌ a. Ne̱ síí sa̱ꞌ me soꞌ, ne̱ síí nica̱ nimán me soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ne̱ ne vaa rá soꞌ da̱j se vaa rá yoꞌó nij síí uun chij rihaan nij yuvii̱ israelitá maꞌ. Ne gu̱un rá soꞌ quiꞌya̱j soꞌ nda̱a vaa quiꞌyaj yoꞌó nij soꞌ maꞌ. Ne̱ síí cavii chumanꞌ Arimatea yoꞌo̱ chumanꞌ na̱j estadó Judea me soꞌ a. Ne̱ soꞌ me síí me ndoꞌo rá gu̱un chij Diose̱ rihaan chumii̱ nihánj a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Dan me se caꞌanj soꞌ rihaan síí cuꞌna̱j Pilato, ne̱ cachíín niꞌya̱j soꞌ rihaan síí cuꞌna̱j Pilato se vaa caꞌve̱j rá síí cuꞌna̱j Pilato cachi̱nꞌ soꞌ man Jesucristó a. Dan me se caꞌvej síí cuꞌna̱j Pilato, ");
INSERT INTO trcNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ga̱a ne̱ caꞌanj síí cuꞌna̱j José, tinanij soꞌ man Jesucristó, ne̱ nacutáj soꞌ yatzíj mantá xráá Jesucristó, ne̱ caxríj soꞌ man Jesucristó rque yuꞌuj yuvej rej nuviꞌ a̱ ꞌó xnangá naj a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Veé da̱nj quiꞌyaj nij soꞌ güii ꞌyaj chuvi̱i nij yuvii̱ israelitá cheꞌé güii nara̱a̱n rá nij soꞌ, ne̱ veé da̱nj quisíj güii naránj rá nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ne̱ canocoꞌ nij chana̱ cavii estadó Galilea ga̱ Jesucristó rej xco̱ síí cuꞌna̱j José, ne̱ queneꞌen nij chana̱ yuꞌuj rej caxríj síí cuꞌna̱j José man Jesucristó, ");
INSERT INTO trcNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ga̱a ne̱ canica̱j nij chana̱ chumanꞌ Jerusalén, ne̱ quiꞌyaj chuvi̱i nij chana̱ yoꞌóó gunꞌ da̱j do̱ꞌ, squíí xlá mirra do̱ꞌ, caxri̱i̱ nij chana̱ man Jesucristó rá nij chana̱ a. Dan me se maꞌa̱n güii naránj rá nij yuvii̱ israelitá me se naránj rá nij chana̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ne̱ taxre̱j güii cotungó, ga̱a ataa doj quisi̱j güii, me se caꞌanj nij chana̱ rej ta̱j yuꞌuj, ne̱ nica̱j nij chana̱ nij rasu̱u̱n gunꞌ da̱j se vaa a̱j quiꞌyaj chuvi̱i nij noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ga̱a ne̱ queneꞌen nij chana̱ se vaa na̱j yaníj yuvej aráán tuꞌva yuꞌuj na̱j Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ne̱ ga̱a catúj nij chana̱ rá yuꞌuj, ne̱ ne nari̱ꞌ nij chana̱ man Jesucristó si̱j ꞌni̱j raꞌa man níꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Dan me se caráyaꞌa̱nj ndoꞌo nij chana̱, ne̱ nicunꞌ vi̱j snóꞌo rihaan nij chana̱, ne̱ ro̱j snóꞌo yoꞌ me se yatzíj chuguu̱n uxrá nuû ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Dan me se cuchuꞌviꞌ uxrá nij chana̱, ne̱ caꞌanj ca̱yáán ru̱j nij chana̱, ne̱ cuchruj nij chana̱ rihaan nij chana̱ rihaan yoꞌóó a. Ga̱a ne̱ cataj ro̱j snóꞌo rihaan nij noꞌ: ―Taj cheꞌé nano̱ꞌ soj man síí vaa iꞌna̱ꞌ rej na̱j nij síí caviꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ꞌO̱ se nuviꞌ soꞌ naj nihánj a̱ maꞌ. ꞌO̱ se cunuu iꞌna̱ꞌ uún soꞌ na̱nj á. Dan me se nanu̱j rá soj se vaa cataj soꞌ ga̱a va̱j nij soj estadó Galilea, ne̱ cataj xnaꞌanj soꞌ rihaan soj se vaa ");
INSERT INTO trcNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","xa̱ꞌ soꞌ si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱, tza̱j ne̱ vaa cheꞌé ta̱cuachén nii man soꞌ rihaan síí tumé cacunꞌ, ne̱ cachro̱n nij soꞌ man soꞌ rihaan rcutze̱, ne̱ cache̱n vaꞌnu̱j güii, ga̱a ne̱ cunu̱u iꞌna̱ꞌ uún soꞌ, taj soꞌ a ―taj ro̱j snóꞌo yoꞌ rihaan nij chana̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Dan me se nanuj rá nij chana̱ nana̱ caꞌmii Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ga̱a ne̱ curiha̱nj nij chana̱ yuꞌuj yuvej, ne̱ canica̱j nij chana̱ yoꞌ chumanꞌ Jerusalén, ne̱ cataj xnaꞌanj nij chana̱ nu̱ꞌ se vaa queneꞌen nij noꞌ rihaan xa̱a̱n nij apóstol cuneꞌ Jesucristó man do̱ꞌ, rihaan yoꞌó nij síí tucuꞌyón se‑na̱na̱ Jesucristó uún do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Dan me se vaꞌnu̱j nij chana̱ me níí cuꞌna̱j Mariá Magdalena do̱ꞌ, níí cuꞌna̱j Juana do̱ꞌ, níí cuꞌna̱j María nii Jacobo do̱ꞌ, ne̱ vaꞌnu̱j nij noꞌ ga̱ yoꞌó nij chana̱ roꞌ, cataj xnaꞌanj rihaan nij apóstol cheꞌé nu̱ꞌ se vaa queneꞌen nij noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ne̱ ga̱a cuno nij apóstol cuneꞌ Jesucristó man se‑na̱na̱ nij chana̱, ga̱a ne̱ nana̱ snúú rmaꞌa̱n me nana̱ yoꞌ, rá nij apóstol cuneꞌ Jesucristó man, ne̱ ne cuchuma̱n rá nij soꞌ se‑na̱na̱ nij chana̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tza̱j ne̱ naxuma̱a̱n síí cuꞌna̱j Pedró, ne̱ cavii soꞌ cunánj soꞌ caꞌanj soꞌ nda̱a yuꞌuj yoꞌ, niꞌya̱j soꞌ a. Dan me se canicunꞌ nitu̱u̱ soꞌ, niꞌya̱j soꞌ rque yuꞌuj, tza̱j ne̱ nuviꞌ Jesucristó naj rque yuꞌuj queneꞌen soꞌ a. Ma̱a̱n yatzíj mantá u̱u̱n naj, niꞌya̱j soꞌ a. Ga̱a ne̱ cavii soꞌ quinanꞌ soꞌ, ne̱ caráyaꞌa̱nj soꞌ cheꞌé nu̱ꞌ se vaa guun a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Dan me se vi̱j tuviꞌ nij síí tucuꞌyón se‑na̱na̱ Jesucristó roꞌ, va̱j ro̱j soꞌ chrej veé ma̱a̱n güii cotungó yoꞌ, caꞌanj ro̱j soꞌ nda̱a ꞌo̱ chumanꞌ na̱j xa̱a̱n kilómetro ga̱ chumanꞌ Jerusalén, ne̱ Emaús cuꞌna̱j chumanꞌ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ne̱ nanó ro̱j soꞌ cuentó cheꞌé nu̱ꞌ se vaa quiranꞌ nij tuvi̱ꞌ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Dan me se nanó ro̱j soꞌ cuentó, ne̱ nuchruj ra̱a̱ ro̱j soꞌ da̱j quiranꞌ Jesucristó, ga̱a ne̱ maꞌa̱n Jesucristó quinichrunꞌ rihaan ro̱j soꞌ, ne̱ chéé Jesucristó ga̱ ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tza̱j ne̱ ne caꞌve̱e cunu̱u ya̱a̱n ro̱j soꞌ man Jesucristó maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ga̱a ne̱ cataj Jesucristó rihaan ro̱j soꞌ a: ―Chéé ro̱j so̱j nanó ro̱j so̱j cuentó, ne̱ me cheꞌé nanó ro̱j so̱j cuentó ga̱ tuviꞌ ro̱j so̱j, ne̱ me cheꞌé nanó ndoꞌo rá ro̱j so̱j ga̱ ―taj soꞌ, xnáꞌanj soꞌ man ro̱j soꞌ a. Ne̱ dan me se canicunꞌ ro̱j soꞌ, ne̱ nanó ndoꞌo rá ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Dan me se yoꞌo̱ soꞌ me síí cuꞌna̱j Cleofas, ne̱ cataj soꞌ rihaan Jesucristó a: ―Cunuda̱nj nij síí aranꞌ chumanꞌ Jerusalén neꞌen da̱j vaa guun chumanꞌ Jerusalén güii cachén nihánj ei. Ne̱ me cheꞌé da̱j ꞌo̱ ruún so̱ꞌ me síí ne neꞌen da̱j vaa guun güii cachén nihánj ga̱ ―taj soꞌ, xnáꞌanj soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ga̱a ne̱: ―Da̱j guun chumanꞌ Jerusalén ga̱ ―taj Jesucristó, xnáꞌanj soꞌ man ro̱j soꞌ a. Ga̱a ne̱ cataj ro̱j soꞌ rihaan Jesucristó a: ―Nu̱ꞌ se vaa quiranꞌ Jesucristó síí cavii chumanꞌ Nazaret a. Ne̱ soꞌ me síí guun síí nataꞌ se‑na̱na̱ Diose̱ rihaan nij yuvii̱, ne̱ síí uun nucua̱j ndoꞌo quiꞌyaj suun me soꞌ, ne̱ síí cavii ndoꞌo nana̱ sa̱ꞌ cheꞌé Diose̱ tuꞌva me soꞌ rihaan cunuda̱nj nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ne̱ dan me se caꞌneꞌ nij xrej ata̱ suun noco̱o doj caꞌneꞌ nij síí nica̱j suun caꞌneꞌ suun se vaa cavi̱ꞌ soꞌ, ga̱a ne̱ cachrón nii man soꞌ rihaan rcutze̱, ");
INSERT INTO trcNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ne̱ dan me se guun rá núj se vaa soꞌ me síí ti̱nanii man níꞌ si̱j israelitá rihaan sayuun, tza̱j ne̱ quiranꞌ soꞌ cunuda̱nj, ne̱ nihánj me se síj vaꞌnu̱j güii caviꞌ soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Tza̱j ne̱ caráyaꞌa̱nj ndoꞌo núj, quiꞌyaj chana̱ tuviꞌ núj a. ꞌO̱ se taxre̱j cuanꞌ me se caꞌanj ni̱ꞌyaj nij chana̱ yuꞌuj cachinꞌ nii man soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","tza̱j ne̱ dan me se ne nari̱ꞌ nij chana̱ man soꞌ a̱ maꞌ. Cheꞌé dan caꞌnaꞌ uún nij chana̱ rihaan núj, ne̱ cataj nij chana̱ se vaa nda̱a vi̱j se‑mo̱zó Diose̱ naquiꞌyaa rihaan nij noꞌ, ne̱ cataj ro̱j se‑mo̱zó Diose̱ se vaa vaa iꞌna̱ꞌ Jesucristó, taj nij chana̱ rihaan núj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Dan me se cavii ꞌo̱ vi̱j tuviꞌ núj caꞌanj ni̱ꞌyaj ro̱j soꞌ yuꞌuj yoꞌ, tza̱j ne̱ queneꞌen ro̱j soꞌ nu̱ꞌ nda̱a vaa cataj xnaꞌanj nij chana̱ rihaan núj, tza̱j ne̱ ne nari̱ꞌ ro̱j soꞌ man maꞌa̱n Jesucristó a̱ maꞌ ―taj ro̱j soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ga̱a ne̱ maꞌa̱n Jesucristó cataj rihaan ro̱j soꞌ a: ―Dan me se síí ne acaj cuentá me soj, ne̱ síí ne niha̱ꞌ rá cuchuma̱n rá nu̱ꞌ se‑na̱na̱ nij síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá me soj na̱nj á. ");
INSERT INTO trcNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ꞌO̱ se ne neꞌen soj se vaa xa̱ꞌ síí caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun, tza̱j ne̱ vaa cheꞌé ndoꞌo quira̱nꞌ soꞌ sayuun ne̱ catu̱u̱ soꞌ rej gu̱un chij ndoꞌo soꞌ a ―taj Jesucristó rihaan ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ga̱a ne̱ dan me se guun cheꞌe̱ soꞌ caꞌmii soꞌ cheꞌé se‑na̱na̱ síí cuꞌna̱j Moisés do̱ꞌ, cheꞌé se‑na̱na̱ cunuda̱nj nij síí nataꞌ se‑na̱na̱ Diose̱ do̱ꞌ, ga̱a ne̱ cataj xnaꞌanj soꞌ rihaan ro̱j soꞌ da̱j taj nu̱ꞌ danj Diose̱ cheꞌé maꞌa̱n soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Dan me se quinichrunꞌ nij soꞌ tuꞌva chumanꞌ rej caꞌanj ro̱j soꞌ, ga̱a ne̱ Jesucristó me se nda̱a rá se ꞌyaj síí caꞌa̱nj chumanꞌ na̱j ga̱nꞌ doj roꞌ, quiꞌyaj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ga̱a ne̱ terquee̱ ro̱j soꞌ man Jesucristó a: ―Quina̱j ca̱chríí so̱ꞌ ga̱ rój, ne̱ a̱j caꞌanj güii, ne̱ vaj so̱ꞌ chrej, ne̱ gu̱un rmi̱ꞌ na̱nj á ―taj ro̱j soꞌ rihaan Jesucristó a. Ga̱a ne̱ quináj soꞌ ga̱ ro̱j soꞌ, ne̱ catúj soꞌ chumanꞌ cara̱nꞌ soꞌ ga̱ ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Dan me se yáán nij soꞌ cha̱ xtiꞌno̱ nij soꞌ, ne̱ nica̱j Jesucristó rachrúún, ne̱ nagoꞌ soꞌ graciá rihaan Diose̱ cheꞌé rachrúún, ga̱a ne̱ cuxraꞌ taꞌa̱j soꞌ rachrúún, rqué soꞌ cha̱ ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Dan me se caxríj rá ro̱j soꞌ, ne̱ cunuu ya̱a̱n ro̱j soꞌ man Jesucristó, ne̱ veé dan nu̱ꞌ caꞌanj niꞌya̱ Jesucristó rihaan ro̱j soꞌ, ne̱ ne caꞌve̱e queneꞌe̱n ro̱j soꞌ man soꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ga̱a ne̱ cataj ro̱j soꞌ rihaan tuviꞌ ro̱j soꞌ a: ―Veé ya̱ maꞌa̱n Jesucristó me yoꞌ asa̱n. ꞌO̱ se ga̱a caꞌmii soꞌ ga̱ níꞌ ga̱a va̱j níꞌ chrej do̱ꞌ, ga̱a cataj xnaꞌanj soꞌ cheꞌé danj Diose̱ do̱ꞌ, ga̱a ne̱ guun niha̱ꞌ uxrá nimán níꞌ, ne̱ nda̱a tiquisii maꞌa̱n nimán níꞌ, quiꞌyaj soꞌ a ―taj ro̱j soꞌ rihaan tuviꞌ ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ga̱a ne̱ ma̱a̱n orá dan naxuma̱a̱n ro̱j soꞌ, ne̱ canica̱j ro̱j soꞌ caꞌanj uún ro̱j soꞌ chumanꞌ Jerusalén, ga̱a ne̱ cuchiꞌ ro̱j soꞌ yoꞌ, ga̱a ne̱ a̱j cunuu chre̱ꞌ xa̱a̱n nij síí tucuꞌyón se‑na̱na̱ Jesucristó ga̱ yoꞌó tuviꞌ nij soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ne̱ nij soꞌ roꞌ, cataj rihaan ro̱j soꞌ se vaa ya̱ a̱j cunuu iꞌna̱ꞌ uún síí ꞌni̱j raꞌa man níꞌ, ne̱ síí cuꞌna̱j Simón me síí queneꞌen man soꞌ, taj nij soꞌ rihaan ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ga̱a ne̱ ro̱j soꞌ roꞌ, cataj xnaꞌanj da̱j guun ga̱a queneꞌen ro̱j soꞌ man Jesucristó ga̱a vaj ro̱j soꞌ chrej, ne̱ cataj xnaꞌanj ro̱j soꞌ se vaa nda̱a cuxraꞌ taꞌa̱j soꞌ rachrúún ga̱a cunuu ya̱a̱n ro̱j soꞌ man Jesucristó, taj ro̱j soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Dan me se ga̱a nanó nij soꞌ cuentó cheꞌé nu̱ꞌ rasu̱u̱n dan, ne̱ nu̱ꞌ curuviꞌ Jesucristó tanu̱u̱ scaꞌnúj nij soꞌ, ne̱: ―Dínj ga̱a̱ nimán soj á ―taj soꞌ rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ga̱a ne̱ cuchuꞌviꞌ ndoꞌo nij soꞌ, ne̱ taꞌnaj me síí nicu̱nꞌ rihaan nij soꞌ, rá nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Me cheꞌé nanó ndoꞌo rá soj, ne̱ me cheꞌé uun vi̱j rá soj ga̱. ");
INSERT INTO trcNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ni̱ꞌyaj soj raꞌaj ni̱ꞌyaj soj tacój ni̱ꞌyaj soj, ne̱ xca̱j soj cuentá se vaa ma̱ꞌanj me á. Xa̱ꞌ taꞌnaj, tza̱j ne̱ taj nee̱ man soꞌ do̱ꞌ, taj cúú man soꞌ do̱ꞌ maꞌ ―taj Jesucristó rihaan nij soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ne̱ tihaa̱n soꞌ raꞌa soꞌ do̱ꞌ, tacóó soꞌ do̱ꞌ, rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Dan me se ne caꞌve̱e cuchuma̱n rá nij soꞌ se vaa maꞌa̱n Jesucristó me a. ꞌO̱ se guun niha̱ꞌ uxrá rá nij soꞌ, ne̱ caꞌanj uxrá rá nij soꞌ a. Cheꞌé dan cataj Jesucristó rihaan nij soꞌ a: ―Vaa do̱j se chá rihaan soj naꞌ ―taj soꞌ, xnáꞌanj soꞌ man nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ga̱a ne̱ rqué nij soꞌ ꞌo̱ xcoꞌ nee̱ xcuaj riꞌya do̱ꞌ, do̱j scuu̱ xtaan do̱ꞌ, man soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ga̱a ne̱ nica̱j soꞌ, ne̱ chá soꞌ niꞌya̱j nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ga̱a ne̱ cataj soꞌ rihaan nij soꞌ a: ―Nihánj me nana̱ caꞌmii ꞌu̱nj rihaan nij soj ga̱a va̱j ꞌu̱nj ga̱ soj, se vaa cataj ꞌu̱nj vaa cheꞌé quisi̱j ya̱ ꞌunj nu̱ꞌ nana̱ aꞌmii cheꞌé ꞌu̱nj nana̱ no̱ rihaan yanj no̱ se‑tucua̱nj Moisés do̱ꞌ, yanj no̱ se‑na̱na̱ nij síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá do̱ꞌ, yanj no̱ nij chraꞌ salmo do̱ꞌ a ―taj soꞌ rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ga̱a ne̱ guun nucua̱j nij soꞌ xcaj nij soꞌ cuentá cheꞌé nu̱ꞌ danj Diose̱, quiꞌyaj soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ne̱ cataj soꞌ rihaan nij soꞌ: ―Veé da̱nj taj danj Diose̱ se vaa xa̱ꞌ ꞌu̱nj si̱j caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun, tza̱j ne̱ quira̱nꞌ ma̱ꞌanj sayuun, ne̱ cavi̱ꞌ ꞌu̱nj, ne̱ cache̱n vaꞌnu̱j güii, ga̱a ne̱ cunu̱u iꞌna̱ꞌ uún ꞌu̱nj a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ga̱a ne̱ caꞌmi̱i̱ natáj nii rihaan cunuda̱nj nij yuvii̱ ma̱n rihaan chumii̱ se vaa cheꞌé se vaa caꞌnáꞌ ꞌu̱nj roꞌ, cheꞌé dan sese ca̱nica̱j nimán nij yuvii̱ canoco̱ꞌ nij yuvii̱ chrej sa̱ꞌ, ga̱a ne̱ tinavi̱j Diose̱ cacunꞌ tumé nij soꞌ a. Dan me se asino caꞌmi̱i̱ natáj nii nana̱ dan chumanꞌ Jerusalén, ga̱a ne̱ caꞌmi̱i̱ natáj nii nu̱ꞌ rihaan chumii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ne̱ nij soj roꞌ, me nij síí queneꞌen nu̱ꞌ rasu̱u̱n quiꞌyáj ne̱ testigó gu̱un soj, ");
INSERT INTO trcNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ne̱ nihánj me se rque̱ ꞌu̱nj Nimán Diose̱ rihaan soj nda̱a vaa cataꞌ tuꞌva maꞌa̱n Diose̱ ga̱a naá a. Dan me se yoꞌo̱ ca̱yáán soj chumanꞌ Jerusalén nihánj nda̱a se nari̱ꞌ nucuaj nimán soj quiꞌya̱j Diose̱ á ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ga̱a ne̱ nica̱j Jesucristó man nij soꞌ, caꞌanj soꞌ nda̱a tuꞌva chumanꞌ Betania, ga̱a ne̱ naxca̱j soꞌ raꞌa soꞌ, ne̱ cachíín niꞌya̱j soꞌ rihaan Diose̱ se vaa veꞌé ra̱cuíj Diose̱ man nij soꞌ, ne̱ cavi̱i̱ sa̱ꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ne̱ nu̱ꞌ caꞌmii soꞌ da̱nj cheꞌé nij soꞌ, ne̱ nu̱ꞌ cavii soꞌ xta̱ꞌ caꞌanj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Dan me se naꞌvíj nij soꞌ rihaan soꞌ, ga̱a ne̱ canica̱j nij soꞌ caꞌanj uún nij soꞌ nda̱a chumanꞌ Jerusalén, ne̱ guun niha̱ꞌ uxrá rá nij soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ne̱ yoꞌo̱ caꞌanj nij soꞌ nuvií noco̱o, ne̱ nataꞌ nij soꞌ rihaan nij yuvii̱ se vaa sa̱ꞌ uxrá quiꞌyaj Diose̱ a. Veé da̱nj ga̱a̱ ya̱ ei.");
INSERT INTO trcNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Asi̱j ataa quiꞌya̱j Diose̱ chumii̱, ne̱ a̱j vaa se‑na̱na̱ Diose̱, ne̱ se‑na̱na̱ Diose̱ roꞌ, canicunꞌ soꞌ rihaan maꞌa̱n Diose̱, ne̱ Diose̱ me soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Dan me se asi̱j ataa quiꞌya̱j Diose̱ chumii̱, ne̱ canicunꞌ se‑na̱na̱ Diose̱ rihaan Diose̱, ");
INSERT INTO trcNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ne̱ caꞌneꞌ Diose̱ suun rihaan soꞌ quiꞌya̱j soꞌ nu̱ꞌ rasu̱u̱n a. Ne̱ sese taj se‑na̱na̱ Diose̱, ne̱ taj va̱j a̱ doj rasu̱u̱n mán nihánj cuano̱ ne gu̱un maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Soꞌ me síí quiꞌyaj cunuu iꞌna̱ꞌ rasu̱u̱n, ne̱ cheꞌé se cunuu iꞌna̱ꞌ yuvii̱ quiꞌyaj soꞌ, cheꞌé dan guun nucua̱j yuvii̱ xcaj yuvii̱ cuentá a. Dan me se ase vaa yaꞌan chuguu̱n vaa soꞌ rihaan yuvii̱, ");
INSERT INTO trcNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ne̱ quiꞌyaj soꞌ chuguu̱n rej rmi̱ꞌ rej ma̱n níꞌ si̱j ma̱n rihaan chumii̱ nihánj si̱j ataa xca̱j cuentá, ne̱ ne quiꞌya̱j canaán rej rmi̱ꞌ yoꞌ rihaan soꞌ a̱ man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ne̱ curiha̱nj yoꞌo̱ snóꞌo, ne̱ dan me se síí caꞌnéé Diose̱ me soꞌ, ne̱ Juan cuꞌna̱j soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ne̱ caꞌnaꞌ soꞌ cata̱j xnaꞌanj soꞌ cheꞌé yaꞌan chuguu̱n yoꞌ, ne̱ me rá soꞌ cuchuma̱n rá cunuda̱nj yuvii̱ ni̱ꞌyaj nij yuvii̱ man yaꞌan chuguu̱n yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nuveé maꞌa̱n soꞌ me yaꞌan chuguu̱n yoꞌ; ma̱a̱n se caꞌnaꞌ soꞌ cata̱j xnaꞌanj soꞌ cheꞌé yaꞌan chuguu̱n yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ne̱ yaꞌan chuguu̱n ya̱ yoꞌ roꞌ, yoꞌ me síí ꞌyaj chuguu̱n rihaan cunuda̱nj yuvii̱, cheꞌé rej gu̱un nucua̱j nij yuvii̱ xca̱j nij yuvii̱ cuentá a. Ne̱ caꞌnaꞌ soꞌ rihaan chumii̱ nihánj, ");
INSERT INTO trcNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ne̱ cayáán soꞌ rihaan chumii̱ nihánj, ne̱ maꞌa̱n soꞌ me síí quiꞌyaj chumii̱ nihánj, quiꞌyaj Diose̱, tza̱j ne̱ ne xca̱j nij síí ma̱n rihaan chumii̱ nihánj cuentá me síí me soꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nda̱a rihaan maꞌa̱n nij tuviꞌ soꞌ cuchiꞌ soꞌ, tza̱j ne̱ ne caꞌmi̱i̱ sa̱ꞌ nij soꞌ ga̱ soꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tza̱j ne̱ xa̱ꞌ taranꞌ nij síí caꞌmii sa̱ꞌ ga̱ soꞌ, tza̱j ne̱ síí amán rá niꞌya̱j man soꞌ me nij soꞌ, ne̱ da̱nj na̱nj rqué soꞌ guun nij soꞌ taꞌníí maꞌa̱n ya̱ Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ne̱ nij síí guun taꞌni̱j Diose̱ man, tza̱j ne̱ nuveé cheꞌe̱ se nayón nij soꞌ rque nii nij soꞌ me guun taꞌni̱j Diose̱ man nij soꞌ maꞌ. Ne̱ nuveé cheꞌe̱ se guun rá maꞌa̱n rej nij soꞌ nayo̱n nij soꞌ rque nii nij soꞌ me guun taꞌni̱j Diose̱ man nij soꞌ maꞌ. Nuveé cheꞌe̱ se guun rá rej nij soꞌ caꞌnga̱a̱ nij soꞌ me guun taꞌni̱j Diose̱ man nij soꞌ maꞌ. Ma̱a̱n se maꞌa̱n Diose̱ me síí quiꞌyaj guun taꞌni̱j Diose̱ man nij soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ga̱a ne̱ guun se‑na̱na̱ Diose̱ yoꞌ yuvii̱, ne̱ cayáán soꞌ ga̱ níꞌ, ne̱ queneꞌen núj se vaa veꞌé ina̱nj quiꞌyaj soꞌ, ne̱ dan me se taj va̱j yoꞌó taꞌníí Rej soꞌ Diose̱ maꞌ. Tana̱nj o̱rúnꞌ soꞌ me síí quiꞌyaj nda̱a vaa quiꞌyaj soꞌ, ne̱ se lu̱j ndoꞌo quiꞌyaj soꞌ cheꞌé níꞌ, ne̱ ina̱nj nana̱ ya̱ caꞌmii soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ne̱ síí cuꞌna̱j Juan me síí cataj xnaꞌanj rihaan yuvii̱ cheꞌé Jesucristó, ne̱ nucua̱j caꞌmii soꞌ, cataj soꞌ: ―Síí nihánj roꞌ, a̱j cataj xnaꞌanj ꞌu̱nj rihaan soj cheꞌé soꞌ ga̱a rque̱ á. Dan me se cataj xnaꞌanj ꞌu̱nj rihaan soj se vaa nda̱ꞌ se síí caꞌna̱ꞌ rej rihanj me soꞌ, tza̱j ne̱ ꞌo̱ se si̱j uun chij ndoꞌo doj me soꞌ rihanj na̱nj á. ꞌO̱ se asi̱j ataa caꞌnga̱a̱ ꞌu̱nj, ne̱ a̱j nicunꞌ soꞌ na̱nj ado̱nj ―taj síí cuꞌna̱j Juan yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Da̱nj caꞌmii síí cuꞌna̱j Juan cheꞌé se Jesucristó me síí nica̱j nu̱ꞌ rasu̱u̱n sa̱ꞌ, ne̱ soꞌ me síí rqué se sa̱ꞌ man taranꞌ níꞌ, ne̱ dan me se nuveé o̱rúnꞌ se lu̱j ꞌyaj soꞌ cheꞌé níꞌ maꞌ. ꞌO̱ se queꞌe̱e̱ se lu̱j ꞌyaj soꞌ cheꞌé níꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ꞌO̱ se rqué Diose̱ se‑tucua̱nj Moisés rihaan xi̱i níꞌ ga̱a naá, tza̱j ne̱ Jesucristó me síí tacuachén nana̱ lu̱j do̱ꞌ, nana̱ ya̱ do̱ꞌ, rihaan níꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ne̱ xa̱ꞌ Diose̱, tza̱j ne̱ taj va̱j a̱ doj síí neꞌen rihaan man Diose̱ maꞌ. Tza̱j ne̱ xa̱ꞌ Jesucristó, tza̱j ne̱ o̱rúnꞌ soꞌ me taꞌníí Diose̱, ne̱ nicu̱nꞌ soꞌ rihaan Diose̱, ne̱ soꞌ me síí tihaa̱n rihaan níꞌ da̱j vaa Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ne̱ nij síí uun chij rihaan nij yuvii̱ israelitá síí ma̱n chumanꞌ Jerusalén me se caꞌnéé nij soꞌ man xrej do̱ꞌ, man do̱j tuviꞌ síí cuꞌna̱j Leví síí cayáán ga̱a naá do̱ꞌ, se vaa caꞌa̱nj nij soꞌ xna̱ꞌanj nij soꞌ man síí cuꞌna̱j Juan me síí me Juan a. Dan me se caꞌanj nij soꞌ xnáꞌanj nij soꞌ man Juan, ga̱a ne̱ Juan yoꞌ roꞌ, caꞌmii soꞌ nana̱ nihánj rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Dan me se yoꞌo̱ cataj xnaꞌanj síí cuꞌna̱j Juan rihaan nij soꞌ da̱j si̱j me soꞌ, ne̱ ne caꞌmi̱i̱ ne̱ soꞌ maꞌ. ꞌO̱ se caꞌmii ya̱ soꞌ, cataj soꞌ: ―Nuveé si̱j caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun mé ꞌu̱nj maꞌ ―taj síí cuꞌna̱j Juan yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ga̱a ne̱ xnáꞌanj uún nij soꞌ man soꞌ, cataj nij soꞌ: ―Cheꞌé dan me síí mé so̱ꞌ ga̱. Síí cuꞌna̱j Elías síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá mé so̱ꞌ naꞌ ―taj uún nij soꞌ, xnáꞌanj nij soꞌ man Juan a. ―Taj maꞌ. Nuveé soꞌ mé ꞌu̱nj maꞌ ―taj uún síí cuꞌna̱j Juan yoꞌ a. ―Neꞌen núj se vaa vaa güii caꞌna̱ꞌ yoꞌo̱ síí nata̱ꞌ se‑na̱na̱ Diose̱, ne̱ si̱j nataꞌ yoꞌ mé so̱ꞌ naꞌ ―taj uún nij soꞌ, xnáꞌanj nij soꞌ man Juan a. ―Taj maꞌ ―taj síí cuꞌna̱j Juan yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Cheꞌé dan cataj nij soꞌ: ―Tza̱j ne̱ cata̱j yá so̱ꞌ me si̱j mé so̱ꞌ, ga̱a ne̱ caꞌve̱e cata̱j xnaꞌanj núj rihaan nij síí caꞌnéé man núj caꞌna̱ꞌ núj da̱j si̱j mé so̱ꞌ a. Me si̱j mé so̱ꞌ ga̱. Da̱j vaa yoꞌ, rá so̱ꞌ ga̱ ―taj uún nij soꞌ, xnáꞌanj nij soꞌ man Juan a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ne̱ cataj síí cuꞌna̱j Juan: ―Síí cuꞌna̱j Isaías síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá roꞌ, cataj xnaꞌanj soꞌ cheꞌé suun ꞌyaj sunj a. Dan me se ꞌu̱nj me síí nucua̱j ndoꞌo aꞌmii rej tacaan, ne̱ taj ꞌu̱nj rihaan yuvii̱ se vaa nuchra̱nꞌ nimán yuvii̱, ne̱ veꞌé caꞌmi̱i̱ nij yuvii̱ ga̱ síí ꞌni̱j raꞌa man níꞌ asa̱ꞌ caꞌnaꞌ soꞌ a ―taj síí cuꞌna̱j Juan yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ne̱ taꞌa̱j nij síí caꞌnaꞌ rihaan síí cuꞌna̱j Juan me síí fariseo, ");
INSERT INTO trcNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ne̱ cataj nij soꞌ rihaan síí cuꞌna̱j Juan a: ―Dan me se nuveé si̱j caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun mé so̱ꞌ maꞌ. Nuveé si̱j cuꞌna̱j Elías mé so̱ꞌ maꞌ. Nuveé si̱j nataꞌ se‑na̱na̱ Diose̱ yoꞌ mé so̱ꞌ maꞌ. Cheꞌé dan ne nó xcúún so̱ꞌ cuta̱ꞌ ne so̱ꞌ man yuvii̱ ―taj nij síí fariseo yoꞌ rihaan síí cuꞌna̱j Juan a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ne̱ cataj xnaꞌanj síí cuꞌna̱j Juan rihaan nij soꞌ, cataj soꞌ: ―ꞌU̱nj me síí utaꞌ ne u̱u̱n man yuvii̱ a. Tza̱j ne̱ vaa yoꞌó síí nicu̱nꞌ scaꞌnúj soj, ne̱ ne neꞌen soj man soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ne̱ soꞌ me síí ꞌnaꞌ rej xco̱j, ne̱ si̱j sa̱ꞌ uxrá doj me soꞌ rihanj, ne̱ daj chiha̱a̱ míj se̱ quisíj raj quiri̱j canj ꞌni̱j tacóó soꞌ maꞌ ―taj síí cuꞌna̱j Juan rihaan nij síí fariseo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Da̱nj guun rej Betania rej rne̱j tuꞌva chráá cuꞌna̱j Jordán, rej va̱j síí cuꞌna̱j Juan ga̱a cutaꞌ ne soꞌ man yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Dan me se yoꞌó güii, ne̱ queneꞌen síí cuꞌna̱j Juan se vaa caꞌnaꞌ Jesucristó rihaan soꞌ, ne̱ cataj soꞌ: ―Ni̱ꞌyaj soj ei. Ase vaa matzinj cavi̱ꞌ rihaan Diose̱ vaa síí nihánj, ne̱ dan me se síí nihánj me síí caꞌne̱e̱ cacunꞌ tumé yuvii̱ ma̱n rihaan chumii̱ nihánj, ");
INSERT INTO trcNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ne̱ síí nihánj roꞌ, cataj xnaꞌanj ꞌu̱nj rihaan soj cheꞌé soꞌ ga̱a rque̱, ne̱ cataj ꞌu̱nj se vaa caꞌve̱e se si̱j ꞌnaꞌ rej xco̱j me soꞌ, tza̱j ne̱ si̱j uun chij doj rihaan ꞌu̱nj me soꞌ a. ꞌO̱ se asi̱j ataa caꞌnga̱a̱ ꞌu̱nj, ne̱ a̱j nicunꞌ soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Dan me se ga̱a rque̱ roꞌ, ne queneꞌe̱n ma̱ꞌanj sese si̱j nihánj me soꞌ maꞌ. Tza̱j ne̱ ma̱a̱n cheꞌé se me rá ꞌu̱nj queneꞌe̱n nij yuvii̱ israelitá man soꞌ roꞌ, cheꞌé dan caꞌnáꞌ ꞌu̱nj, ne̱ cheꞌé dan cutaꞌ ne ꞌu̱nj man yuvii̱ na̱nj á ―taj síí cuꞌna̱j Juan yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ga̱a ne̱ cataj xnaꞌanj ya̱ síí cuꞌna̱j Juan cheꞌé se vaa queneꞌen maꞌa̱n soꞌ, cataj soꞌ: ―Queneꞌén ꞌu̱nj se vaa nanij Nimán Diose̱ rej xta̱ꞌ, ne̱ ase vaa ꞌo̱ chaꞌaa̱n vaa Nimán Diose̱ yoꞌ, ne̱ caꞌnaꞌ yoꞌ, quitáá yoꞌ raa̱ Jesucristó ei. ");
INSERT INTO trcNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ga̱a ne̱ nu̱ꞌ xcaj ꞌu̱nj cuentá se vaa maꞌa̱n soꞌ me síí caꞌnéé Diose̱ á. ꞌO̱ se síí caꞌnéé mán ꞌu̱nj cuta̱ꞌ ne ꞌu̱nj man yuvii̱ me se maꞌa̱n soꞌ cataj rihaan ꞌu̱nj se vaa sese que̱neꞌén ꞌu̱nj nani̱j Nimán Diose̱ raa̱ yoꞌo̱ soꞌ, ne̱ sese quita̱j Nimán Diose̱ yoꞌ raa̱ soꞌ, ne̱ soꞌ me síí caꞌnéé Diose̱, ne̱ ca̱yáán uxrá Nimán Diose̱ ga̱ yuvii̱, quiꞌya̱j soꞌ a, taj síí caꞌnéé manj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ga̱a ne̱ queneꞌen ma̱ꞌán ꞌu̱nj man Jesucristó nihánj, se vaa nanij Nimán Diose̱ raa̱ soꞌ, ne̱ a̱j cataj yá ꞌu̱nj rihaan soj se vaa taꞌni̱j Diose̱ me soꞌ ei ―taj síí cuꞌna̱j Juan yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Güii aꞌyuj me se canicunꞌ uún síí cuꞌna̱j Juan ga̱ vi̱j tuviꞌ nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ne̱ niꞌya̱j uxrá síí cuꞌna̱j Juan man Jesucristó ga̱a chéé Jesucristó, ne̱ cataj síí cuꞌna̱j Juan: ―Ni̱ꞌyaj ro̱j so̱j ei. Ase vaa matzinj cavi̱ꞌ rihaan Diose̱ vaa síí nihánj á ―taj síí cuꞌna̱j Juan a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Dan me se cuno ro̱j síí tucuꞌyón se‑na̱na̱ Juan nana̱ caꞌmii soꞌ, ne̱ canocoꞌ ro̱j soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ga̱a ne̱ canica̱j Jesucristó, ne̱ queneꞌen soꞌ se vaa canocoꞌ ro̱j soꞌ man soꞌ, ne̱ cataj Jesucristó rihaan ro̱j soꞌ a: ―Vaa se achiin man ro̱j so̱j naꞌ ―taj Jesucristó, xnáꞌanj Jesucristó man ro̱j soꞌ a. Ga̱a ne̱ xnáꞌanj ro̱j soꞌ, cataj ro̱j soꞌ: ―Me rej né so̱ꞌ, rabbí ―cataj ro̱j soꞌ, xnáꞌanj ro̱j soꞌ man Jesucristó, ne̱ nana̱ “rabbí” yoꞌ taj “maestró” a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ga̱a ne̱ cataj Jesucristó rihaan ro̱j soꞌ a: ―Caꞌa̱nj níꞌ, ne̱ queneꞌe̱n soj á ―taj Jesucristó a. Cheꞌé dan me caꞌanj ro̱j soꞌ, ne̱ queneꞌen ro̱j soꞌ rej ne̱ Jesucristó, ne̱ cunuû ro̱j soꞌ tucuá soꞌ cunu̱ꞌ güii yoꞌ a. Dan me se agaꞌ caꞌa̱nj rej anocoꞌ güii me orá caꞌmii ro̱j soꞌ ga̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Dan me se yoꞌo̱ tuviꞌ ro̱j síí cuno nana̱ caꞌmii síí cuꞌna̱j Juan ne̱ canocoꞌ man Jesucristó roꞌ, me síí cuꞌna̱j Andrés, ne̱ tinúú síí cuꞌna̱j Simón Pedró me uún soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Asino ya̱a̱n nariꞌ síí cuꞌna̱j Andrés man tinúú soꞌ síí cuꞌna̱j Simón, ne̱ cataj soꞌ rihaan tinúú soꞌ: ―Nariꞌ núj man Mesías ei ―taj soꞌ rihaan tinúú soꞌ a. Ne̱ nana̱ “Mesías” taj “síí caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun” a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ne̱ caꞌanj nica̱j soꞌ man tinúú soꞌ rihaan Jesucristó, ga̱a ne̱ niꞌya̱j uxrá Jesucristó man síí cuꞌna̱j Simón yoꞌ, ne̱ cataj soꞌ: ―Síí cuꞌna̱j Simón mé so̱ꞌ, ne̱ taꞌníí síí cuꞌna̱j Juan mé so̱ꞌ á. Tza̱j ne̱ nda̱a ya̱j, ne̱ Cefas cuꞌna̱j so̱ꞌ á ―taj Jesucristó rihaan soꞌ a. Ne̱ nana̱ “Cefas” roꞌ, xnaꞌánj hebreo me yoꞌ, ne̱ ꞌo̱ cuya̱a̱n vaa yoꞌ ga̱ nana̱ “Pedró”, ne̱ taj yoꞌ se vaa ase vaa ꞌo̱ yuvej vaa síí cuꞌna̱j Pedró, ne̱ sca̱ꞌ nimán soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Dan me se yoꞌó güii uún me rá Jesucristó cavi̱i̱ soꞌ caꞌa̱nj soꞌ estadó Galilea, ne̱ nariꞌ Jesucristó man síí cuꞌna̱j Felipé, ne̱ dan me se cataj Jesucristó rihaan soꞌ a: ―Ca̱nocóꞌ so̱ꞌ manj, caꞌa̱nj níꞌ á ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ne̱ Felipé roꞌ, me síí ne̱ chumanꞌ Betsaida, ne̱ Betsaida me chiháán síí cuꞌna̱j Andrés do̱ꞌ, síí cuꞌna̱j Pedró do̱ꞌ, uún a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Veé dan, ne̱ nariꞌ síí cuꞌna̱j Felipé yoꞌ man síí cuꞌna̱j Natanael, ne̱ cataj soꞌ: ―A̱j nariꞌ núj man síí caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun, ne̱ dan me se síí caꞌmii Moisés cheꞌé ga̱a cuchruj soꞌ se‑tucua̱nj soꞌ me soꞌ, ne̱ nij síí nataꞌ se‑na̱na̱ Diose̱ ga̱a naá roꞌ, nataꞌ uún nij soꞌ cheꞌé soꞌ na̱nj ado̱nj. Ne̱ dan me se Jesús taꞌníí síí cuꞌna̱j José, síí ne̱ chumanꞌ Nazaret me soꞌ ei ―taj Felipé rihaan Natanael yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ne̱ cataj Natanael yoꞌ: ―Taj va̱j síí sa̱ꞌ avii chumanꞌ Nazaret maꞌ ―taj Natanael yoꞌ a. Ne̱ cataj Felipé: ―Caꞌa̱nj níꞌ, que̱neꞌén so̱ꞌ man soꞌ, sese me rá so̱ꞌ á ―taj Felipé rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Veé dan, ne̱ queneꞌen Jesucristó se vaa caꞌnaꞌ Natanael rihaan soꞌ, ne̱ caꞌmii soꞌ ꞌo̱ nana̱ cheꞌé Natanael, cataj soꞌ: ―Ni̱ꞌyaj soj ei. Ya̱ si̱j israelitá me síí ꞌnaꞌ cuano̱ ei. Nica̱ aꞌmii soꞌ, ne aꞌmii soꞌ nana̱ tihaꞌ yuꞌunj maꞌ ―taj Jesucristó niꞌya̱j soꞌ man Natanael yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ga̱a ne̱ xnáꞌanj Natanael yoꞌ man Jesucristó, cataj soꞌ: ―Asa̱ꞌ aꞌvee neꞌén so̱ꞌ manj ga̱ ―taj soꞌ, xnáꞌanj soꞌ man Jesucristó a. Ne̱ cataj Jesucristó: ―Asi̱j ataa caꞌmi̱i̱ Felipé rihaan so̱ꞌ do̱ꞌ, asi̱j cayáán so̱ꞌ tacóó chruun ma̱n chruj higó raa̱ do̱ꞌ, ne̱ a̱j queneꞌén ꞌu̱nj mán so̱ꞌ ei ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ga̱a ne̱ cataj Natanael: ―Taꞌni̱j Diose̱ mé so̱ꞌ, maestro. Si̱j nica̱j suun rey uun chij rihaan níꞌ si̱j israelitá mé so̱ꞌ á ―taj Natanael a. ");
INSERT INTO trcNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ: ―Cheꞌé se cataj ꞌu̱nj rihaan so̱ꞌ se vaa queneꞌén ꞌu̱nj mán so̱ꞌ ga̱a cayáán so̱ꞌ tacóó chruun ma̱n chruj higó roꞌ, ma̱a̱n cheꞌé dan amán rá so̱ꞌ niꞌya̱j so̱ꞌ manj naꞌ. Tza̱j ne̱ que̱neꞌén so̱ꞌ queꞌe̱e̱ doj rasu̱u̱n noco̱o doj uún a̱ á. ");
INSERT INTO trcNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan nij soj cuano̱ se vaa queneꞌe̱n soj naxra̱ꞌ rej xta̱ꞌ, ne̱ queneꞌe̱n soj man nij se‑mo̱zó Diose̱, ne̱ cavi̱i̱ nij soꞌ xta̱ꞌ, ne̱ nani̱j uún nij soꞌ rihaan ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ ado̱nj ―taj Jesucristó rihaan taranꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Cachén yavíj güii, ga̱a ne̱ canuû chaꞌanj naraꞌa̱a chumanꞌ Caná chumanꞌ na̱j estadó Galilea, ne̱ caꞌanj nii Jesucristó chaꞌanj yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Dan me se nacúún nii man Jesucristó do̱ꞌ, man nij síí tucuꞌyón se‑na̱na̱ soꞌ do̱ꞌ, caꞌna̱ꞌ nij soꞌ chaꞌanj yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Veé dan, ne̱ navij na vinó man nij síí navij rá chaꞌanj yoꞌ, ne̱ cheꞌé dan cataj nii Jesucristó rihaan Jesucristó a: ―Taj va̱j na vinó rihaan nij síí navij rá chaꞌanj maꞌ ―taj noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ga̱a ne̱ cataj Jesucristó rihaan nii soꞌ a: ―Taj cheꞌé caꞌmi̱i̱ so̱ꞌ da̱nj rihanj maꞌ. Ni̱ꞌyaj so̱ꞌ, ne̱ ataa quisi̱j güii qui̱ꞌyáj suun sa̱ꞌ noco̱o á ―taj soꞌ no nii soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ga̱a ne̱ cataj xnaꞌanj nii Jesucristó rihaan nij mozó a: ―Cuno̱ nij soj nu̱ꞌ se vaa cata̱j xnaꞌanj taꞌníj rihaan soj, ne̱ quiꞌya̱j soj nu̱ꞌ se vaa cata̱j soꞌ á ―taj noꞌ rihaan nij mozó a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Veé dan, ne̱ ne̱ vata̱nꞌ xruj yahi̱j xi̱j a. Xruj nica̱j caꞌa̱nj chiha̱a̱ litró na me xruj yoꞌ, ne̱ xruj araa nij yuvii̱ israelitá na rásuun nij soꞌ naꞌya̱ꞌ nij soꞌ nda̱a vaa taj se‑tucua̱nj Moisés me xruj yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ne̱ caꞌneꞌ Jesucristó suun rihaan nij mozó, cataj soꞌ: ―Cara̱a soj na rque nij xruj yahi̱j yoꞌ á ―taj soꞌ rihaan nij mozó yoꞌ a. Ga̱a ne̱ caraa nij mozó na, ne̱ yoꞌo̱ caraa nda̱a tuꞌva xruj yoꞌ, quiꞌyaj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ga̱a ne̱ cataj xnaꞌanj uún Jesucristó rihaan nij mozó yoꞌ, cataj soꞌ: ―Ya̱j roꞌ, quiri̱i̱ soj do̱j na nu̱u̱ rque xruj, ne̱ caꞌa̱nj ni̱caj soj na yoꞌ rihaan síí uun chij rihaan nij mozó anica̱j coꞌoo rihaan nij yuvii̱ á ―taj Jesucristó a. Ne̱ da̱nj quiꞌyaj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Veé dan, ne̱ síí uun chij rihaan nij mozó anica̱j coꞌoo rihaan yuvii̱ me se coꞌo soꞌ do̱j tzinꞌ na yoꞌ, tza̱j ne̱ nuveé na̱ u̱u̱n me yoꞌ a̱ maꞌ. Nu̱ꞌ guun na yoꞌ na vinó na̱nj ado̱nj. Ne̱ ne queneꞌe̱n soꞌ me rej cavii na vinó yoꞌ a̱ maꞌ. ꞌO̱ se ma̱a̱n ina̱nj nij mozó quirii na yoꞌ rque xruj roꞌ, o̱rúnꞌ nij soꞌ me síí queneꞌen me rej cavii na yoꞌ a. Veé dan, ne̱ nacúún síí uun chij yoꞌ man síí naraꞌa̱a caꞌna̱ꞌ síí naraꞌa̱a rihaan soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ne̱ cataj soꞌ: ―Tucuáán ꞌyaj níꞌ roꞌ, me se na̱nj vaa yoꞌ na̱nj á. Asino ya̱a̱n go̱ꞌ níꞌ na vinó sa̱ꞌ doj coꞌo̱ nij síí tiha̱j ꞌnaꞌ chaꞌanj, ga̱a ne̱ nda̱a quisíj guun xno̱ yuvii̱ asuun, ga̱a ne̱ go̱ꞌ níꞌ na vinó nij doj coꞌo̱ nij soꞌ a. Tza̱j ne̱ so̱ꞌ me se ino̱ quiꞌyáá so̱ꞌ chugua̱nj. Dan me se nda̱a ya̱j quirii so̱ꞌ na vinó sa̱ꞌ doj yoꞌ asanj ―taj síí uun chij yoꞌ rihaan síí naraꞌa̱a yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nihánj me se guun cheꞌe̱ Jesucristó quiꞌyaj Jesucristó suun sa̱ꞌ noco̱o, ne̱ nu̱ꞌ nihánj me se vaa quiꞌyaj soꞌ chumanꞌ Caná chumanꞌ na̱j estadó Galilea a. Cheꞌé dan xcaj nij yuvii̱ cuentá se vaa si̱j sa̱ꞌ uxrá me soꞌ, quiꞌyaj soꞌ, ne̱ cuchumán rá nij síí tucuꞌyón se‑na̱na̱ soꞌ niꞌya̱j nij soꞌ man soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ga̱a quisíj canuû chaꞌanj naraꞌa̱a yoꞌ, ga̱a ne̱ caꞌanj Jesucristó do̱ꞌ, nii soꞌ do̱ꞌ, nij tinúú soꞌ do̱ꞌ, nij síí tucuꞌyón se‑na̱na̱ soꞌ do̱ꞌ, chumanꞌ Capernaum, ne̱ do̱j güii cayáán nij soꞌ chumanꞌ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Dan me se ataa doj quisi̱j chaꞌanj pascuá chaꞌanj navij rá nij yuvii̱ israelitá, ga̱a ne̱ cavii Jesucristó caꞌanj soꞌ chumanꞌ Jerusalén a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ga̱a ne̱ rá nuvií noco̱o roꞌ, naj ꞌo̱ yuꞌvee noco̱o ꞌyaj nij yuvii̱ israelitá, ne̱ ma̱a̱n dan mán nij soꞌ tuꞌvéj nij soꞌ scúj do̱ꞌ, matzinj do̱ꞌ, chaꞌaa̱n do̱ꞌ a. Ne̱ vaa síí ne̱ rihaan chruun mesá, ne̱ síí natuná saꞌanj cheꞌé yuvii̱ atúj rque nuvií me nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ga̱a ne̱ nica̱j Jesucristó neꞌ, quiꞌyaj soꞌ cuartá, goꞌ soꞌ man nij síí tuꞌvéj xcuu do̱ꞌ, man nij síí natuná saꞌanj do̱ꞌ, ne̱ quirii soꞌ xeꞌ man taranꞌ nij soꞌ a. Ne̱ rano soꞌ man nij scúj do̱ꞌ, man nij matzinj do̱ꞌ, quirii soꞌ xeꞌ a. Ne̱ tichaꞌnuu̱ soꞌ se‑saꞌa̱nj síí natuná saꞌanj rihaan yoꞌóó, ne̱ tinaxruꞌ soꞌ nij chruun mesá a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ga̱a ne̱ cataj soꞌ rihaan nij síí tuꞌvéj chaꞌaa̱n a: ―Quiri̱i̱ soj rasu̱u̱n nihánj xeꞌ cuaj ei. Se̱ guun quiꞌya̱j soj yuꞌvee tucuá Réj maꞌ ―taj soꞌ rihaan nij síí tuꞌvéj chaꞌaa̱n ma̱n rá nuvií yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ga̱a ne̱ ninuj rá nij síí tucuꞌyón se‑na̱na̱ Jesucristó se vaa nó nana̱ nihánj rihaan danj Diose̱ a: “Cheꞌé se ꞌe̱e̱ ndoꞌo raj veꞌ tucuá so̱ꞌ, cheꞌé dan caꞌnéé nimanj quiꞌya̱j sunj cheꞌé yoꞌ a”. Yoꞌ me nana̱ nó rihaan danj Diose̱ a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Queneꞌen nij síí uun chij rihaan nij yuvii̱ israelitá se vaa quiꞌyaj Jesucristó rá nuvií yoꞌ, ga̱a ne̱ cheꞌé dan cataj nij soꞌ rihaan Jesucristó a: ―Ne nó xcúún so̱ꞌ quiri̱i̱ so̱ꞌ man síí tuꞌvéj xcuu ma̱n rá nuvií noco̱o, rá núj maꞌ. Ma̱a̱n se qui̱ꞌyáá so̱ꞌ ꞌo̱ suun sa̱ꞌ noco̱o queneꞌe̱n núj, ga̱a ne̱ gu̱un ya̱ rá núj se vaa no̱ xcúún so̱ꞌ qui̱ꞌyáá so̱ꞌ da̱nj ei ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Tiri̱ꞌ soj man nuvií nihánj, ne̱ rque vaꞌnu̱j güii, ne̱ cunu̱u sa̱ꞌ uún nuvií nihánj, qui̱ꞌyáj ei ―taj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Cheꞌé dan cataj nij síí uun chij yoꞌ rihaan Jesucristó a: ―Vi̱j chiha̱a̱ vata̱nꞌ ya̱ yoꞌ quiꞌyaj suun nij síí cuneꞌ nuvií nihánj, tza̱j ne̱ asa̱ꞌ caꞌve̱e naquiꞌya̱j sa̱ꞌ so̱ꞌ nuvií nihánj rque vaꞌnu̱j güii, rá so̱ꞌ ga̱ ―taj nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tza̱j ne̱ ne caꞌmi̱i̱ Jesucristó cheꞌé ma̱a̱n nuvií noco̱o yoꞌ maꞌ. Ma̱a̱n se caꞌmii soꞌ cheꞌé maꞌa̱n yan cunu̱u iꞌna̱ꞌ uún soꞌ rque vaꞌnu̱j güii a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Cheꞌé dan, ga̱a quisíj caviꞌ soꞌ ne̱ cunuu iꞌna̱ꞌ uún soꞌ, ga̱a ne̱ nanuj rá nij síí tucuꞌyón se‑na̱na̱ soꞌ nana̱ nihánj nana̱ a̱j caꞌmii soꞌ, ne̱ cuchumán rá nij soꞌ nana̱ no̱ rihaan danj Diose̱ nana̱ taj xnaꞌanj da̱j quira̱nꞌ síí caꞌne̱j Diose̱ ti̱nanii man yuvii̱ rihaan sayuun, ne̱ cuchumán rá nij soꞌ nana̱ caꞌmii maꞌa̱n Jesucristó uún a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Dan me se nu̱ꞌ nihánj quiꞌyaj Jesucristó chumanꞌ Jerusalén ga̱a canuû chaꞌanj pascuá, ne̱ cheꞌé dan queꞌe̱e̱ ndoꞌo nij yuvii̱ cuchumán rá se vaa si̱j caꞌnéé Diose̱ me soꞌ a. ꞌO̱ se queneꞌen nij yuvii̱ nij suun sa̱ꞌ noco̱o quiꞌyaj suun soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Tza̱j ne̱ maꞌa̱n Jesucristó, ne ga̱a̱ nucua̱j rá soꞌ man nij yuvii̱ yoꞌ maꞌ. ꞌO̱ se soꞌ me síí neꞌen cunuda̱nj, ");
INSERT INTO trcNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ne̱ ne cachi̱in yoꞌo̱ síí cata̱j xnaꞌanj rihaan Jesucristó da̱j vaa nimán yuvii̱ maꞌ. ꞌO̱ se maꞌa̱n soꞌ me síí queneꞌen da̱j vaa nimán nu̱ꞌ nij yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Dan me se vaa yoꞌo̱ síí fariseo cuꞌna̱j Nicodemo, ne̱ síí uun chij rihaan nij yuvii̱ israelitá me soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Dan me se rej nii̱ caꞌnaꞌ soꞌ rihaan Jesucristó, ne̱ cataj soꞌ: ―Neꞌen núj se vaa si̱j caꞌnéé Diose̱ tu̱cuꞌyón man yuvii̱ mé so̱ꞌ, maestro. ꞌO̱ se sese nuviꞌ Diose̱ racuíj mán so̱ꞌ, ne̱ ne gu̱un nu̱cuáá so̱ꞌ qui̱ꞌyáá so̱ꞌ nda̱a vaa ꞌyáá so̱ꞌ nihánj cuano̱ asuun maꞌ ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan so̱ꞌ cuano̱ se vaa síí se̱ caꞌngaa naca̱ uún roꞌ, daj chiha̱a̱ míj se̱ guun nucua̱j soꞌ queneꞌe̱n soꞌ man Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj a̱ maꞌ ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Dan me se xnáꞌanj síí cuꞌna̱j Nicodemo man Jesucristó, cataj soꞌ: ―Asa̱ꞌ caꞌve̱e caꞌnga̱a̱ uún ꞌo̱ síí a̱j cachij ga̱. Caꞌve̱e xa̱ꞌ catu̱u̱ uún soꞌ rque nii soꞌ ne̱ caꞌnga̱a̱ naca̱ uún soꞌ ga̱a̱ a̱ naꞌ ―taj Nicodemo, xnáꞌanj soꞌ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ga̱a ne̱ cataj uún Jesucristó: ―Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan so̱ꞌ se vaa sese se̱ caꞌngaa yoꞌo̱ soꞌ quiꞌya̱j na ne̱ quiꞌya̱j Nimán Diose̱, ne̱ se̱ guun nucua̱j soꞌ catu̱u̱ soꞌ rihaan Diose̱ asa̱ꞌ guun chij Diose̱ rihaan chumii̱ nihánj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ꞌO̱ se sese na̱nj yuvii̱ quiꞌyaj caꞌngaa níꞌ, ne̱ na̱nj yuvii̱ ma̱n rihaan chumii̱ nihánj me níꞌ, tza̱j ne̱ sese caꞌnga̱a̱ níꞌ quiꞌya̱j Nimán Diose̱, ne̱ ase vaa sa̱ꞌ Nimán Diose̱ roꞌ, da̱nj ga̱a̱ sa̱ꞌ nimán níꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Se̱ caráyaꞌa̱nj tiháꞌ so̱ꞌ se vaa cataj ꞌu̱nj rihaan so̱ꞌ maꞌ. ꞌO̱ se no̱ xcúún nij soj caꞌnga̱a̱ ya̱ uún nij soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Dan me se xca̱j so̱ꞌ cuentá ni̱ꞌyaj so̱ꞌ nana̱ a. Avii nana̱ yoꞌ, ne̱ cayu̱j ꞌyaj yoꞌ, tza̱j ne̱ ne neꞌén so̱ꞌ me rej avii yoꞌ ꞌnaꞌ yoꞌ, ne̱ ne neꞌén so̱ꞌ me rej caꞌanj yoꞌ maꞌ. Ne̱ ase vaa nana̱ roꞌ, da̱nj vaa Nimán Diose̱, ne̱ dan me se sese cunuu sa̱ꞌ nimán yoꞌo̱ soꞌ quiꞌyaj Nimán Diose̱, ne̱ taj neꞌénꞌ asa̱ꞌ caꞌvee cunuu sa̱ꞌ nimán soꞌ quiꞌyaj Nimán Diose̱ maꞌ ―taj Jesucristó rihaan síí cuꞌna̱j Nicodemo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Veé dan, ne̱ xnáꞌanj síí cuꞌna̱j Nicodemo, cataj soꞌ: ―Asa̱ꞌ caꞌve̱e quiꞌya̱j yuvii̱ da̱nj ga̱ ―taj soꞌ, xnáꞌanj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ga̱a ne̱ xnáꞌanj uún Jesucristó man soꞌ, cataj Jesucristó: ―ꞌO̱ se me cheꞌé si̱j uun chij si̱j tucuꞌyón se‑na̱na̱ Diose̱ rihaan nij yuvii̱ israelitá mé so̱ꞌ, tza̱j ne̱ ne neꞌén so̱ꞌ nana̱ nihánj nana̱ cataj ꞌu̱nj rihaan so̱ꞌ ga̱. ");
INSERT INTO trcNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan so̱ꞌ se vaa xa̱ꞌ núj, tza̱j ne̱ cheꞌé ina̱nj se vaa neꞌen núj aꞌmii núj ne̱ cheꞌé se vaa queneꞌen núj nataꞌ núj ado̱nj. Tza̱j ne̱ ne amán rá nij soj nana̱ aꞌmii núj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Dan me se na̱nj cheꞌé rasu̱u̱n ma̱n rihaan chumii̱ nihánj cataj xnaꞌanj ꞌu̱nj rihaan soj, tza̱j ne̱ ne cuchuma̱n rá soj maꞌ. Asa̱ꞌ caꞌve̱e cuchuma̱n rá soj sese cata̱j xnaꞌanj ꞌu̱nj rihaan soj cheꞌé rasu̱u̱n ma̱n rej xta̱ꞌ ga̱. ");
INSERT INTO trcNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ꞌO̱ se taj va̱j síí cavii rej xta̱ꞌ nanij rihaan yoꞌóó cata̱j xnaꞌanj rihaan soj da̱j vaa nij rasu̱u̱n ma̱n rej xta̱ꞌ maꞌ. Ma̱a̱n o̱rúnꞌ ꞌu̱nj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ roꞌ, me síí ꞌnaꞌ rej xta̱ꞌ nanij rihaan yoꞌóó nihánj, ne̱ cheꞌé dan ma̱ꞌanj me síí gu̱un nucua̱j cata̱j xnaꞌanj rihaan soj cheꞌé rej xta̱ꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Dan me se ase vaa tacavii síí cuꞌna̱j Moisés xcuáá aga̱ꞌ raa̱ chruun rej tacaan roꞌ, da̱nj quiꞌya̱j nii manj si̱j caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱, ne̱ ta̱cavii nii manj raa̱ ꞌo̱ chruun, ");
INSERT INTO trcNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ne̱ nda̱a síj, ga̱a ne̱ taranꞌ nij síí cuchuma̱n rá ni̱ꞌyaj manj roꞌ, ca̱yáán nij soꞌ ga̱ Diose̱ nu̱ꞌ cavii nu̱ꞌ caꞌanj na̱nj ado̱nj ―taj Jesucristó rihaan síí cuꞌna̱j Nicodemo a. ");
INSERT INTO trcNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Dan me se ꞌe̱e̱ uxrá rá Diose̱ niꞌya̱j Diose̱ man níꞌ si̱j ma̱n rihaan chumii̱ nihánj, ne̱ nda̱ꞌ se o̱rúnꞌ taꞌníí Diose̱, tza̱j ne̱ rqué u̱u̱n Diose̱ taꞌníí soꞌ yoꞌ, caꞌna̱ꞌ taꞌníí soꞌ rihaan chumii̱ nihánj, ne̱ cataj Diose̱ se vaa nij yuvii̱ amán rá niꞌya̱j man taꞌníí soꞌ roꞌ, se̱ caviꞌ nij soꞌ daj chiha̱a̱ míj maꞌ. Tana̱nj cane̱ nij soꞌ ga̱ Diose̱ nu̱ꞌ cavii nu̱ꞌ caꞌanj na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ꞌO̱ se ne caꞌne̱j Diose̱ taꞌníí soꞌ cheꞌé rej cuta̱ꞌ taꞌníí soꞌ cacunꞌ xráá nij yuvii̱ ma̱n rihaan chumii̱ nihánj maꞌ. Tana̱nj caꞌnéé Diose̱ man taꞌníí soꞌ rihaan chumii̱ nihánj cheꞌé rej ti̱nanii taꞌníí soꞌ man nij yuvii̱ rihaan chrej chiꞌi̱i̱ uun chij nimán nij soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Níꞌ si̱j amán rá niꞌya̱j man taꞌníí Diose̱ me se taj va̱j sayuun quira̱nꞌ níꞌ maꞌ. Tza̱j ne̱ síí ne amán rá niꞌya̱j man soꞌ roꞌ, a̱j cataj Diose̱ se vaa ya̱ quira̱nꞌ soꞌ sayuun na̱nj á. Cheꞌé se ne cuchuma̱n ya̱ rá soꞌ niꞌya̱j soꞌ o̱rúnꞌ ya̱ taꞌníí Diose̱ roꞌ, cheꞌé dan quira̱nꞌ ya̱ soꞌ sayuun ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Dan me se nihánj me cacunꞌ tumé nij síí quira̱nꞌ sayuun yoꞌ a. ꞌO̱ se a̱j caꞌnaꞌ Jesucristó rihaan chumii̱ nihánj, ne̱ ase vaa ꞌo̱ yaꞌan chuguu̱n vaa soꞌ, tza̱j ne̱ caranꞌ ina̱nj rá nij síí ma̱n rihaan chumii̱ nihánj cache̱e̱ nij soꞌ rej rmi̱ꞌ, ne̱ ne caꞌve̱j rá nij soꞌ quinichru̱nꞌ nij soꞌ rihaan yaꞌan chuguu̱n yoꞌ a. ꞌO̱ se chiꞌi̱i̱ ndoꞌo vaa se quiꞌyaj nij soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Dan me se nu̱ꞌ yuvii̱ ꞌyaj se chiꞌi̱i̱ roꞌ, ta̱j riꞌyunj nij soꞌ niꞌya̱j nij soꞌ yaꞌan chuguu̱n yoꞌ, ne̱ ne ꞌnaꞌ nij soꞌ rihaan yaꞌan chuguu̱n yoꞌ maꞌ. ꞌO̱ se naꞌvej rá nij soꞌ curuvi̱ꞌ se vaa ꞌyaj nij soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tza̱j ne̱ nij síí me rá canoco̱ꞌ nana̱ ya̱ roꞌ, ꞌnaꞌ nij soꞌ rihaan yaꞌan chuguu̱n yoꞌ, ne̱ dan me se ga̱a ꞌyaj nij soꞌ da̱nj, ne̱ ruviꞌ se vaa ꞌyaj nij soꞌ, ne̱ síí noco̱ꞌ man Diose̱ me nij soꞌ, ne̱ Diose̱ racuíj man nij soꞌ nu̱ꞌ se vaa ꞌyaj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Dan me se ga̱a quisíj nu̱ꞌ se vaa quiꞌyaj Jesucristó chumanꞌ Jerusalén, ga̱a ne̱ curiha̱nj Jesucristó do̱ꞌ, nij síí tucuꞌyón se‑na̱na̱ soꞌ do̱ꞌ, chumanꞌ Jerusalén, ne̱ caꞌanj nij soꞌ ne̱ nij soꞌ chumanꞌ leꞌe̱j nii na̱j estadó Judea, ne̱ veé dan va̱j nij soꞌ cutaꞌ ne nij soꞌ man yuvii̱ do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ne̱ síí cuꞌna̱j Juan roꞌ, ne chumanꞌ cuꞌna̱j Enón, ne̱ utaꞌ ne soꞌ man yuvii̱ uún a. ꞌO̱ se nichru̱nꞌ naj chumanꞌ Enón ga̱ chumanꞌ Salim, ne̱ ma̱n uxrá na cata̱ꞌ ne yuvii̱ rej yoꞌ, ne̱ caꞌnaꞌ uxrá yuvii̱, ne̱ ataꞌ ne nij yuvii̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ꞌO̱ se ataa doj caxri̱i̱ nii tagaꞌ man síí cuꞌna̱j Juan yoꞌ ga̱a̱ ei. ");
INSERT INTO trcNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Veé dan, ne̱ guun cheꞌe̱ nij síí tucuꞌyón se‑na̱na̱ Juan caꞌmii cunuꞌ nij soꞌ ga̱ ꞌo̱ síí uun chij rihaan nij yuvii̱ israelitá cheꞌé nana̱ cataj xnaꞌanj síí cuꞌna̱j Moisés, se vaa da̱j quiꞌya̱j yuvii̱ naꞌya̱ꞌ yuvii̱, ga̱a ne̱ caꞌve̱e gu̱un niha̱ꞌ rá Diose̱ ni̱ꞌyaj Diose̱ man nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Veé dan, ne̱ cuchiꞌ nij síí tucuꞌyón se‑na̱na̱ Juan rihaan maꞌa̱n Juan, ne̱ cataj nij soꞌ: ―Síí chéé ga̱ so̱ꞌ ga̱a va̱j níꞌ rej rne̱j tuꞌva chráá cuꞌna̱j Jordán roꞌ, síí natáꞌ so̱ꞌ cheꞌé roꞌ, utaꞌ ne soꞌ man yuvii̱ cuano̱, ne̱ ꞌanj taranꞌ nij yuvii̱ rej va̱j soꞌ, maestro ―taj nij síí tucuꞌyón se‑na̱na̱ Juan rihaan Juan a. ");
INSERT INTO trcNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ga̱a ne̱ cataj Juan: ―A̱ ꞌó yuvii̱ naꞌvee canoco̱ꞌ daj chiha̱a̱ míj man soꞌ, sese nuveé Dio̱se̱ me síí caꞌvej rá maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ꞌO̱ se a̱j cuno maꞌa̱n soj nana̱ cataj xnaꞌanj ꞌu̱nj rihaan soj se vaa nuveé si̱j caꞌnéé Diose̱ ti̱nanii man yuvii̱ rihaan sayuun mej a. Ma̱a̱n se ꞌu̱nj me síí caꞌnéé Diose̱ caꞌna̱ꞌ asino ya̱a̱n rihaan síí ti̱nanii man yuvii̱ rihaan sayuun ei. ");
INSERT INTO trcNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ase vaa síí xcaj man chana̱ ne̱ naraꞌa̱a roꞌ, vaa soꞌ, ne̱ ase vaa tuviꞌ síí naraꞌa̱a roꞌ, da̱nj vaa ꞌu̱nj, ne̱ nicúnꞌ ꞌu̱nj unó ꞌu̱nj se vaa aꞌmii soꞌ, ne̱ uun niha̱ꞌ uxrá raj, ꞌyaj nana̱ aꞌmii síí naraꞌa̱a, ne̱ cheꞌé dan me uun niha̱ꞌ uxrá raj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ꞌO̱ se no̱ xcúún soꞌ gu̱un chij soꞌ doj, ne̱ ꞌu̱nj me se no̱ xcúnj gunj síí nica̱ꞌ doj rihaan soꞌ ado̱nj ―taj síí cuꞌna̱j Juan yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Síí nanij rihaan chumii̱ nihánj roꞌ, soꞌ me síí uun chij rihaan cunuda̱nj rasu̱u̱n ado̱nj. Nij síí ma̱n rihaan chumii̱ nihánj, tza̱j ne̱ cheꞌé ina̱nj rasu̱u̱n ma̱n rihaan chumii̱ nihánj aꞌmii nij soꞌ, ne̱ taj va̱j yoꞌó rasu̱u̱n neꞌen nij soꞌ maꞌ. Tza̱j ne̱ síí nanij rej xta̱ꞌ roꞌ, ");
INSERT INTO trcNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","soꞌ me síí aꞌmii cheꞌé se vaa queneꞌen soꞌ rej xta̱ꞌ do̱ꞌ, cheꞌé nana̱ cuno soꞌ rej xta̱ꞌ do̱ꞌ, ne̱ taj va̱j síí amán rá uno se‑na̱na̱ soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tza̱j ne̱ síí amán rá se‑na̱na̱ soꞌ roꞌ, soꞌ me síí taj se vaa nana̱ ya̱ me se‑na̱na̱ Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Síí caꞌnéé Diose̱ man roꞌ, me síí aꞌmii se‑na̱na̱ Diose̱ á. ꞌO̱ se rqué ndoꞌo Diose̱ Nimán Diose̱ rihaan soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ꞌE̱e̱ rá Rej soꞌ man soꞌ, cheꞌé yan taꞌni̱j Rej soꞌ me soꞌ, ne̱ rqué Rej soꞌ cunuda̱nj rasu̱u̱n man soꞌ, cheꞌé rej gu̱un chij soꞌ rihaan cunuda̱nj nij rasu̱u̱n yoꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Síí amán rá niꞌya̱j man taꞌníí Diose̱ roꞌ, soꞌ me síí veꞌé ca̱yáán ga̱ Diose̱ nu̱ꞌ cavii nu̱ꞌ caꞌanj, tza̱j ne̱ síí naꞌvej rá cuno̱ rihaan taꞌníí Diose̱ roꞌ, daj chiha̱a̱ míj se̱ cayáán soꞌ ga̱ Diose̱ maꞌ. Tana̱nj yoꞌo̱ caꞌma̱an rá Diose̱ ni̱ꞌyaj Diose̱ man soꞌ, ne̱ yoꞌo̱ quira̱nꞌ soꞌ sayuun, quiꞌya̱j Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Dan me se xcaj Jesucristó cuentá se vaa cuchiꞌ nana̱ rihaan nij síí fariseo se vaa doj a̱ vaa nij síí tucuꞌyón se‑na̱na̱ Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ Juan, ne̱ noco̱o doj nij yuvii̱ cataꞌ ne quiꞌyaj Jesucristó rihaan nij yuvii̱ cataꞌ ne quiꞌyaj Juan a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Tza̱j ne̱ nuveé maꞌa̱n Jesucristó me síí cutaꞌ ne man nij yuvii̱ maꞌ. Ma̱a̱n nij síí tucuꞌyón se‑na̱na̱ soꞌ cutaꞌ ne man nij yuvii̱ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Dan me se xcaj Jesucristó cuentá se vaa cuchiꞌ nana̱ yoꞌ rihaan nij síí fariseo, ga̱a ne̱ cavii soꞌ estadó Judea caꞌanj soꞌ estadó Galilea a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ꞌO̱ se ya̱ cache̱n soꞌ estadó Samaria yoꞌ, ");
INSERT INTO trcNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ne̱ cuchiꞌ soꞌ tuꞌva yoꞌo̱ chumanꞌ na̱j estadó Samaria, ne̱ Sicar cuꞌna̱j chumanꞌ yoꞌ a. Dan me se nichru̱nꞌ naj chumanꞌ yoꞌ tuꞌva yoꞌóó rqué síí cuꞌna̱j Jacob rihaan taꞌníí soꞌ síí cuꞌna̱j José ga̱a naá, ");
INSERT INTO trcNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ne̱ tuꞌva chumanꞌ yoꞌ nuû yoꞌo̱ na yuꞌuj quiꞌyaj síí cuꞌna̱j Jacob ga̱a naá a. Dan me se xeꞌ man Jesucristó cheꞌé yan cachéé uxrá soꞌ caꞌnaꞌ soꞌ chumanꞌ yoꞌ, ne̱ cheꞌé dan caꞌanj cane̱ soꞌ tuꞌva na yuꞌuj yoꞌ, ne̱ caxu̱j me yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Dan me se caꞌnaꞌ ꞌo̱ chana̱ samaritana na yuꞌuj quiri̱i̱ noꞌ na, ne̱ cataj Jesucristó rihaan chana̱ yoꞌ a: ―Qui̱ꞌyáá so̱ꞌ se ndoꞌo, ne̱ rque̱ so̱ꞌ do̱j na coꞌo̱j rugua̱nj ―taj Jesucristó no chana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ne̱ taj va̱j nij síí tucuꞌyón se‑na̱na̱ Jesucristó nicunꞌ ga̱ soꞌ ga̱a̱ maꞌ. ꞌO̱ se caꞌanj nij soꞌ chumanꞌ quira̱a̱n nij soꞌ se chá a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Veé dan, ne̱ cataj chana̱ samaritana yoꞌ rihaan Jesucristó a: ―Me cheꞌé cachíín so̱ꞌ na rihanj, coꞌo̱ so̱ꞌ, ne̱ ni̱ꞌyaj so̱ꞌ, ne̱ si̱j israelitá mé so̱ꞌ, ne̱ cha̱na̱ samaritana mej ga̱ ―taj chana̱ yoꞌ, xnáꞌanj noꞌ man Jesucristó a. ꞌO̱ se ne aꞌmii sa̱ꞌ nij síí israelitá ga̱ nij síí samaritano maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ga̱a ne̱ cataj Jesucristó rihaan noꞌ a: ―Sese xcaj so̱ꞌ cuentá cheꞌé se lu̱j quiꞌya̱j Diose̱ cheꞌé so̱ꞌ ne̱ sese queneꞌén so̱ꞌ me síí achíín na mán so̱ꞌ cuano̱, ne̱ cachíín so̱ꞌ na ꞌyaj vaa iꞌna̱ꞌ yuvii̱ man soꞌ coꞌo̱ so̱ꞌ, ne̱ rqué soꞌ na yoꞌ coꞌo so̱ꞌ sa̱j ado̱nj ―taj Jesucristó no chana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ga̱a ne̱ cataj chana̱ rihaan Jesucristó a: ―Tza̱j ne̱ taj va̱j sihuu̱ rihaan so̱ꞌ quiri̱i̱ so̱ꞌ na nihánj maꞌ. Ne̱ cunu̱u̱ ndoꞌo nuû na rá yuꞌuj nihánj, señor. Me rej quiri̱i̱ so̱ꞌ na ꞌyaj vaa iꞌna̱ꞌ yuvii̱ rque̱ so̱ꞌ coꞌo̱j ga̱. ");
INSERT INTO trcNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Dan me se xi̱i níꞌ síí cuꞌna̱j Jacob roꞌ, soꞌ me síí coꞌo na nu̱u̱ na yuꞌuj nihánj, ne̱ veé dan me coꞌo taꞌníí soꞌ do̱ꞌ, daán soꞌ xcuu do̱ꞌ, ne̱ rqué soꞌ na nihánj coꞌo̱ núj a. Ne̱ si̱j sa̱ꞌ doj rihaan soꞌ mé so̱ꞌ, rá so̱ꞌ naꞌ ―taj chana̱ yoꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ga̱a ne̱ cataj Jesucristó rihaan noꞌ: ―Cunuda̱nj nij síí coꞌo̱ na nu̱u̱ rá yuꞌuj nihánj roꞌ, canaco̱o̱ uún nij soꞌ na vaa güii, ne̱ caꞌna̱ꞌ uún nij soꞌ quiri̱i̱ nij soꞌ doj na a̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Tza̱j ne̱ síí coꞌo̱ na rque̱ ꞌu̱nj nihánj me se daj chiha̱a̱ míj se̱ canacoo̱ uún soꞌ na yoꞌ a̱ maꞌ. Ase vaa rej veꞌé uxrá avii na roꞌ, da̱nj ga̱a̱ nimán soꞌ, ne̱ cu̱nuû uxrá se lu̱j nimán soꞌ, ne̱ ga̱a̱ iꞌna̱ꞌ soꞌ ga̱ Diose̱ nu̱ꞌ cavii nu̱ꞌ caꞌanj, quiꞌya̱j na rque̱j ado̱nj ―taj Jesucristó rihaan chana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ne̱ cataj chana̱ rihaan soꞌ: ―Rque̱ so̱ꞌ do̱j na yoꞌ coꞌo̱j, señor. Ne̱ se̱ canacoó ꞌu̱nj na, ne̱ se̱ caꞌnaꞌ uún ꞌu̱nj quiri̱j na nihánj a̱ maꞌ ―taj chana̱ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ne̱ cataj Jesucristó rihaan noꞌ a: ―Caꞌa̱nj nacu̱nj so̱ꞌ man nica̱ so̱ꞌ, ne̱ caꞌna̱ꞌ so̱ꞌ nihánj á ―taj soꞌ rihaan noꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ne̱ cataj chana̱ rihaan soꞌ: ―Taj va̱j nica̱j maꞌ ―taj chana̱ yoꞌ a. Ne̱ cataj Jesucristó rihaan noꞌ a: ―Cuna̱j uxrá caꞌmii so̱ꞌ, cataj so̱ꞌ se vaa taj va̱j nica̱ so̱ꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ꞌO̱ se asi̱j rque̱ me se quisíj ya̱ ꞌu̱nꞌ snóꞌo xcaj so̱ꞌ, tza̱j ne̱ tanáj so̱ꞌ man nij soꞌ, ne̱ ya̱j nihánj me se nica̱j so̱ꞌ man ꞌó soꞌ, tza̱j ne̱ nuveé ni̱ca̱ so̱ꞌ me soꞌ maꞌ. Cheꞌé dan ya̱ uxrá caꞌmii so̱ꞌ ei ―taj Jesucristó no chana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ne̱ cataj chana̱ rihaan soꞌ: ―Cuano̱ nihánj xcaj ꞌu̱nj cuentá se vaa si̱j nataꞌ se‑na̱na̱ Diose̱ mé so̱ꞌ, señor. ");
INSERT INTO trcNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Dan me se xi̱i núj roꞌ, quinaꞌvíj nij soꞌ xráá quij nihánj, tza̱j ne̱ soj si̱j israelitá taj se vaa o̱rúnꞌ chumanꞌ Jerusalén me rej no̱ xcúún níꞌ naꞌvi̱j níꞌ rihaan Diose̱, taj soj ado̱nj ―taj chana̱ yoꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ga̱a ne̱ cataj Jesucristó rihaan chana̱ a: ―Cuchuma̱n rá so̱ꞌ nana̱ nihánj nana̱ cata̱j xnaꞌanj ꞌu̱nj rihaan so̱ꞌ, nocoj. Dan me se vaa güii, ne̱ se̱ cavii nij soj raa̱ quij nihánj do̱ꞌ, se̱ caꞌanj nij soj chumanꞌ Jerusalén do̱ꞌ, naꞌvi̱j soj rihaan Rej níꞌ Diose̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Dan me se ne neꞌen nij soj man síí naꞌvíj soj rihaan maꞌ. Tza̱j ne̱ xa̱ꞌ núj si̱j israelitá, tza̱j ne̱ neꞌen núj man síí naꞌvíj núj rihaan a. ꞌO̱ se núj si̱j israelitá me nij síí quiꞌya̱j quinani̱i̱ yuvii̱ rihaan sayuun a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tza̱j ne̱ vaa güii, ne̱ nij síí naꞌvíj sa̱ꞌ rihaan Rej níꞌ Diose̱ roꞌ, gu̱un ina̱nj rá nij soꞌ naꞌvi̱j nij soꞌ rihaan Diose̱, ne̱ me rej maꞌa̱n va̱j nij soꞌ naꞌvi̱j ya̱ nij soꞌ rihaan Diose̱ na̱nj ado̱nj. Ne̱ cuano̱ nihánj me a̱j guun cheꞌe̱ yuvii̱ quiꞌyaj yuvii̱ da̱nj ado̱nj. ꞌO̱ se me ndoꞌo rá Rej níꞌ Diose̱ naꞌvi̱j ya̱ yuvii̱ rihaan soꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dan me se me maꞌa̱n rej va̱j níꞌ nicunꞌ Diose̱, ne̱ cheꞌé dan níꞌ si̱j naꞌvíj rihaan Diose̱ roꞌ, me maꞌa̱n rej mán níꞌ, ne̱ no̱ xcúún níꞌ gu̱un niha̱ꞌ rá níꞌ naꞌvi̱j ya̱ níꞌ rihaan soꞌ ado̱nj ―taj Jesucristó rihaan chana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ga̱a ne̱ cataj chana̱ rihaan Jesucristó a: ―Neꞌén ꞌu̱nj se vaa vaa güii, ne̱ caꞌna̱ꞌ síí caꞌne̱j Diose̱ ti̱nanii man níꞌ rihaan sayuun, ne̱ asa̱ꞌ caꞌnaꞌ soꞌ, ne̱ cata̱j xnaꞌanj maꞌa̱n soꞌ cheꞌé cunuda̱nj rasu̱u̱n rihaan níꞌ na̱nj á ―taj chana̱ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ga̱a ne̱ canica̱j Jesucristó cataj Jesucristó rihaan noꞌ, ne̱: ―ꞌU̱nj si̱j aꞌmii rihaan so̱ꞌ cuano̱ nihánj roꞌ, me síí caꞌnéé Diose̱ ado̱nj ―taj Jesucristó rihaan chana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Veé dan, ne̱ nu̱ꞌ ꞌnaꞌ nique nij síí tucuꞌyón se‑na̱na̱ Jesucristó, ne̱ caráyaꞌa̱nj nij soꞌ se vaa caꞌmii Jesucristó ga̱ chana̱ yoꞌ a. Tza̱j ne̱ a̱ ꞌó nij soꞌ ne xna̱ꞌanj man soꞌ da̱j quiꞌyaj soꞌ do̱ꞌ, me cheꞌé caꞌmii soꞌ ga̱ chana̱ yoꞌ do̱ꞌ a̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ga̱a ne̱ tanáj chana̱ se‑sihu̱u̱ chana̱, ne̱ cavii chana̱ quinanꞌ chana̱ chumanꞌ, ga̱a ne̱ cataj chana̱ rihaan nij yuvii̱ ma̱n chumanꞌ a: ");
INSERT INTO trcNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Caꞌa̱nj níꞌ, ne̱ queneꞌe̱n soj ꞌo̱ snóꞌo síí cataj xnaꞌanj rihanj cheꞌé nu̱ꞌ se vaa quiꞌyáj ga̱a rque̱ á. Nuveé si̱j caꞌnéé Diose̱ ti̱nanii man níꞌ rihaan sayuun me soꞌ, rá soj naꞌ ―taj chana̱ rihaan nij snóꞌo ma̱n chumanꞌ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ga̱a ne̱ curiha̱nj nij soꞌ chumanꞌ, ne̱ caꞌnaꞌ nij soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Dan me se ga̱a caꞌmii chana̱ ga̱ nij síí ma̱n chumanꞌ yoꞌ, ne̱ guun cheꞌe̱ nij síí tucuꞌyón se‑na̱na̱ Jesucristó rquee̱ nij soꞌ chraa man Jesucristó, cataj nij soꞌ: ―Cha̱ so̱ꞌ do̱j chraa, maestro ―taj nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Tza̱j ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Vaa se chá rihanj, tza̱j ne̱ ne neꞌen soj maꞌ ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ga̱a ne̱ xnáꞌanj nij soꞌ man tuviꞌ nij soꞌ, cataj nij soꞌ: ―Vaa síí caꞌnaꞌ rqué se chá soꞌ, rá soj naꞌ ―taj nij soꞌ rihaan tuviꞌ nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Sese ꞌyáá ꞌu̱nj nda̱a vaa me rá síí caꞌnéé manj qui̱ꞌyáj, ne̱ sese navij quisíj suun caꞌneꞌ soꞌ rihanj, ne̱ ase vaa se chá vaa yoꞌ rihanj ado̱nj. Dan me se nuu xe̱j nimanj ga̱a ꞌyaj sunj suun yoꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Se̱ guun cata̱j soj se vaa cache̱n yoꞌó caꞌa̱nj yavii, ga̱a ne̱ quiri̱i̱ níꞌ naa̱, cata̱j soj maꞌ. Ma̱a̱n se cuano̱ nihánj cata̱j xnaꞌanj ꞌu̱nj rihaan soj se vaa na̱xcaj soj rihaan soj, ni̱ꞌyaj soj nij yuvii̱, se vaa ase vaa naa̱ ꞌnúú trigó vaa nij yuvii̱, ne̱ catzi̱i̱ ndoꞌo vaa naa̱ ꞌnúú trigó yoꞌ, cachij yoꞌ, ne̱ cuano̱ nihánj me se no̱ xcúún níꞌ quiri̱i̱ níꞌ ꞌnúú trigó yoꞌ ado̱nj. Dan me se a̱j guun cheꞌe̱ ");
INSERT INTO trcNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Diose̱ na̱ruꞌvee Diose̱ rihaan nij síí rii naa̱ yoꞌ, ne̱ naquiꞌyaj chre̱ꞌ ndoꞌo nij soꞌ man nij síí ca̱yáán ga̱ Diose̱ nu̱ꞌ cavii nu̱ꞌ caꞌanj, ne̱ rej riha̱a̱n gu̱un niha̱ꞌ rá síí cunô naa̱ ga̱ síí rii naa̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ꞌO̱ se ya̱ uxrá vaa nana̱ nihánj se vaa ino̱ vaa síí cunô naa̱ ga̱ síí rii naa̱, ");
INSERT INTO trcNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ne̱ a̱j caꞌnéé ꞌu̱nj man soj quiri̱i̱ soj naa̱ rej ne quiꞌya̱j suun soj maꞌ. Yoꞌó yuvii̱ me nij síí quiꞌyaj suun naa̱ yoꞌ ga̱a rque̱, ne̱ catúj soj quiꞌyaj suun soj ga̱ nij soꞌ ado̱nj ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Dan me se cheꞌé se nataꞌ chana̱ yoꞌ rihaan nij yuvii̱ samaritana ma̱n chumanꞌ yoꞌ se vaa cataj xnaꞌanj Jesucristó rihaan noꞌ nu̱ꞌ se vaa quiꞌyaj noꞌ ga̱a rque̱ roꞌ, cheꞌé dan me cuchumán rá queꞌe̱e̱ nij yuvii̱ ma̱n chumanꞌ yoꞌ niꞌya̱j nij yuvii̱ man Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Dan me se cuchiꞌ nij síí ma̱n chumanꞌ yoꞌ rihaan Jesucristó, ne̱ cachíín niꞌya̱j uxrá nij soꞌ rihaan soꞌ se vaa cara̱nꞌ soꞌ do̱j tucuá nij soꞌ, ne̱ cheꞌé dan vi̱j güii quináj soꞌ chumanꞌ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ne̱ guun ri̱i̱ doj nij síí cuchumán rá cuno se‑na̱na̱ Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ne̱ nij yuvii̱ amán rá niꞌya̱j man Jesucristó roꞌ, cataj nij soꞌ rihaan chana̱ yoꞌ a: ―Nuveé cheꞌe̱ do̱j nana̱ natáꞌ so̱ꞌ rihaan núj me cuchumán rá núj niꞌya̱j núj man soꞌ maꞌ. Ma̱a̱n se cuno maꞌa̱n núj se‑na̱na̱ soꞌ, ne̱ xcaj núj cuentá se vaa ya̱ síí ti̱nanii man yuvii̱ ma̱n rihaan chumii̱ nihánj rihaan sayuun me síí nihánj na̱nj ado̱nj ―taj nij soꞌ rihaan chana̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Dan me se quisíj vi̱j güii caranꞌ Jesucristó chumanꞌ yoꞌ, ga̱a ne̱ cavii soꞌ caꞌanj soꞌ estadó Galilea a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Dan me se maꞌa̱n Jesucristó me síí cataj xnaꞌanj se vaa nij síí ma̱n chiháán ꞌo̱ síí aꞌmii natáj se‑na̱na̱ Diose̱ me se ne aráj cochro̱j nij síí man maꞌa̱n dan rihaan soꞌ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ga̱a caꞌnaꞌ Jesucristó estadó Galilea, ga̱a ne̱ veꞌé uxrá caꞌmii nij síí ma̱n estadó yoꞌ cheꞌé suun sa̱ꞌ noco̱o quiꞌyaj soꞌ chaꞌanj canuû chumanꞌ Jerusalén a. ꞌO̱ se maꞌa̱n nij soꞌ caꞌanj chaꞌanj yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Dan me se caꞌanj uún soꞌ chumanꞌ Caná chumanꞌ na̱j estadó Galilea a. Chumanꞌ yoꞌ me chumanꞌ naquiꞌyaj soꞌ na vinó man na u̱u̱n ga̱a rque̱ a. Ne̱ chumanꞌ Capernaum roꞌ, ne yoꞌo̱ síí nica̱j suun rihaan rey a. Ne̱ canó chiꞌii̱ man taꞌníí soꞌ ꞌo̱ snóꞌo cunii a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Dan me se cuchiꞌ nana̱ rihaan síí nica̱j suun yoꞌ se vaa cavii Jesucristó estadó Judea caꞌnaꞌ Jesucristó estadó Galilea, ga̱a ne̱ caꞌanj soꞌ cuchiꞌ soꞌ rihaan Jesucristó, ne̱ cachíín niꞌya̱j uxrá soꞌ rihaan Jesucristó se vaa caꞌa̱nj Jesucristó quiꞌya̱j conoꞌó Jesucristó man taꞌníí soꞌ a. Dan me se da̱j doj cavi̱ꞌ taꞌníí soꞌ, taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ a: ―Sese se̱ quiꞌyáj suun sa̱ꞌ noco̱o queneꞌe̱n soj, ne̱ daj chiha̱a̱ míj se̱ cuchumán rá soj ni̱ꞌyaj soj manj maꞌ ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ga̱a ne̱ cataj síí nica̱j suun yoꞌ rihaan Jesucristó a: ―Da̱j doj cavi̱ꞌ taꞌníj, na̱nj señor. Qui̱ꞌyáá so̱ꞌ se ndoꞌo uxrá, ne̱ caꞌa̱nj níꞌ do̱j rugua̱nj ―taj soꞌ, cachíín niꞌya̱j soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ne̱ cataj Jesucristó rihaan soꞌ a: ―Caꞌve̱e caꞌa̱nj so̱ꞌ á. ꞌO̱ se a̱j nahuun sa̱ꞌ taꞌníí so̱ꞌ na̱nj ado̱nj ―taj Jesucristó rihaan soꞌ a. Ga̱a ne̱ cuchumán rá snóꞌo yoꞌ nana̱ cataj xnaꞌanj Jesucristó rihaan soꞌ, ne̱ cavii soꞌ caꞌanj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Veé dan, ne̱ tiha̱j nanꞌ soꞌ chrej, ne̱ caꞌanj cara̱nꞌ nij se‑mo̱zó soꞌ man soꞌ, ne̱ cataj xnaꞌanj nij yoꞌ rihaan soꞌ se vaa a̱j nahuun sa̱ꞌ taꞌníí soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Veé dan, ne̱ xnáꞌanj soꞌ man nij mozó yoꞌ: ―Me orá me guun cheꞌe̱ taꞌníj nahuun sa̱ꞌ yoꞌ ga̱ ―cataj soꞌ rihaan nij mozó yoꞌ a. Ga̱a ne̱ cataj nij mozo yoꞌ rihaan soꞌ: ―Quii agaꞌ ꞌo̱ me naꞌmaân cachiꞌ man xnii na̱nj á ―taj nij mozó yoꞌ rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Cheꞌé dan me xcaj snóꞌo yoꞌ cuentá se vaa ma̱a̱n orá cataj xnaꞌanj Jesucristó rihaan soꞌ se vaa nahuun sa̱ꞌ taꞌníí soꞌ roꞌ, ma̱a̱n orá dan me nahuun sa̱ꞌ ya̱ taꞌníí soꞌ a. Ga̱a ne̱ cuchumán rá nij tucua̱ soꞌ se vaa si̱j caꞌnéé Diose̱ me Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Dan me se quisíj vi̱j suun sa̱ꞌ noco̱o quiꞌyaj Jesucristó ga̱a quisíj cavii soꞌ estadó Judea caꞌanj soꞌ estadó Galilea a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Veé dan, ne̱ canuû chaꞌanj navij rá nij síí israelitá, ga̱a ne̱ cavii Jesucristó caꞌanj soꞌ chumanꞌ Jerusalén a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Dan me se chumanꞌ Jerusalén roꞌ, vaa ꞌo̱ na cuꞌna̱j Betesda xnaꞌánj aꞌmii nij síí israelitá a. Nichru̱nꞌ naj na yoꞌ ga̱ taꞌyaa atúj matzinj, ne̱ vaa ꞌu̱nꞌ veꞌ ne̱ nu̱ꞌ anica̱j tuꞌva na yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Rá veꞌ yoꞌ mán ndoꞌo síí ninaj do̱ꞌ, síí tuchri̱i do̱ꞌ, síí rengo̱ do̱ꞌ, síí nuu chrúnj raꞌa do̱ꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Dan me se nda̱a vaa orá nanij yoꞌo̱ se‑mo̱zó síí ꞌni̱j raꞌa man níꞌ rá na yoꞌ, ne̱ tanica̱j soꞌ na yoꞌ, taj nij yuvii̱ yoꞌ a. Ne̱ ga̱a anica̱j na yoꞌ, ne̱ síí nanij asino ya̱a̱n rque na roꞌ, o̱rúnꞌ soꞌ güe̱j na̱j guun chiꞌii̱ xráá, taj uún nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ne̱ na̱j yoꞌo̱ snóꞌo tuꞌva na yoꞌ, ne̱ síj ico̱ xnu̱ꞌ vaꞌnu̱j ya̱ yoꞌ ranꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Dan me se queneꞌen Jesucristó man soꞌ se vaa na̱j soꞌ rej yoꞌ, ne̱ a̱j queneꞌen Jesucristó se vaa guun queꞌe̱e̱ yoꞌ ranꞌ soꞌ, ne̱ xnáꞌanj Jesucristó man soꞌ, cataj Jesucristó a: ―Nahu̱un sa̱ꞌ so̱ꞌ, rá so̱ꞌ naꞌ ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ne̱ cataj síí ranꞌ yoꞌ rihaan Jesucristó a: ―Na̱huún ꞌu̱nj raj, tza̱j ne̱ taj va̱j tuvíꞌ ꞌu̱nj síí ti̱nanij mán ꞌu̱nj rá na ga̱a anica̱j na, man señor. Cheꞌé dan me ga̱a ꞌanj ꞌu̱nj tuꞌva na yoꞌ, ne̱ guun yucua̱nꞌ yoꞌó soꞌ, ne̱ asino soꞌ atúj rque na rihanj na̱nj ado̱nj ―taj soꞌ rihaan Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ga̱a ne̱ cataj Jesucristó rihaan soꞌ: ―Na̱xagaa so̱ꞌ, ne̱ na̱xcaj so̱ꞌ tuvéé so̱ꞌ, cache̱e̱ so̱ꞌ á ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ga̱a ne̱ nu̱ꞌ nahuun sa̱ꞌ snóꞌo yoꞌ, ne̱ naxca̱j soꞌ tuvéé soꞌ, ne̱ caꞌanj soꞌ a. Ne̱ güii nahuun sa̱ꞌ snóꞌo yoꞌ me güii naránj rá nij yuvii̱ israelitá a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Cheꞌé dan me nij síí uun chij rihaan nij yuvii̱ israelitá me se cataj nij soꞌ rihaan síí nahuun sa̱ꞌ yoꞌ: ―Güii naránj rá níꞌ me nihánj á. Ne nó xcúún so̱ꞌ ca̱tá so̱ꞌ tuvéé so̱ꞌ cuanꞌ maꞌ ―taj nij soꞌ rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ga̱a ne̱ cataj soꞌ rihaan nij soꞌ a: ―Tza̱j ne̱ síí quiꞌyaj nahuun sa̱ꞌ ꞌu̱nj roꞌ, soꞌ me síí caꞌneꞌ suun rihanj na̱xcaj ꞌu̱nj tuvéé ꞌu̱nj ne̱ cache̱e̱ ꞌu̱nj ado̱nj ―taj soꞌ rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ga̱a ne̱ xnáꞌanj nij soꞌ man soꞌ, cataj nij soꞌ: ―Me síí cataj rihaan so̱ꞌ na̱xcaj so̱ꞌ tuvéé so̱ꞌ ne̱ cache̱e̱ so̱ꞌ ga̱ ―taj nij soꞌ rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tza̱j ne̱ ne queneꞌe̱n síí nahuun sa̱ꞌ me síí quiꞌyaj da̱nj maꞌ. ꞌO̱ se ga̱a quisíj nahuun sa̱ꞌ soꞌ, ne̱ naxuun Jesucristó man maꞌa̱n soꞌ cachén Jesucristó scaꞌnúj nij yuvii̱ ma̱n anica̱j niꞌya̱j man síí nahuun sa̱ꞌ yoꞌ, caꞌanj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Veé dan, ne̱ nariꞌ Jesucristó man síí nahuun sa̱ꞌ yoꞌ rá nuvií noco̱o, ne̱ cataj Jesucristó rihaan soꞌ a: ―Ya̱ nahuun sa̱ꞌ so̱ꞌ á. Ta̱náj so̱ꞌ chrej chiꞌi̱i̱ á. Sese taj, ne̱ ca̱nica̱j uún chiꞌii̱ mán so̱ꞌ, ne̱ doj a̱ qui̱ránꞌ so̱ꞌ na̱nj ado̱nj ―taj Jesucristó rihaan soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Dan me se cavii snóꞌo yoꞌ, ne̱ nataꞌ soꞌ rihaan nij síí uun chij rihaan nij yuvii̱ israelitá se vaa Jesucristó me síí quiꞌyaj nahuun sa̱ꞌ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Cheꞌé dan guun rá nij síí uun chij yoꞌ quiꞌya̱j nij soꞌ sayuun man Jesucristó, cheꞌé se güii naránj rá nij soꞌ me güii nahuun snóꞌo yoꞌ, quiꞌyaj Jesucristó a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ga̱a ne̱ cataj Jesucristó rihaan nij soꞌ a: ―Réj me se ne anicunꞌ soꞌ ga̱ suun maꞌ. Cheꞌé dan yoꞌo̱ ꞌyaj suun ma̱ꞌanj ado̱nj ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Cheꞌé dan doj a̱ nanoꞌ nij soꞌ da̱j quiꞌya̱j nij soꞌ, ga̱a ne̱ caꞌve̱e cavi̱ꞌ Jesucristó a. ꞌO̱ se nuveé cheꞌe̱ ina̱nj tinavij Jesucristó tucuáán noco̱ꞌ nij soꞌ cheꞌé güii naránj rá nij soꞌ me guun rá nij soꞌ cavi̱ꞌ Jesucristó maꞌ. ꞌO̱ se cheꞌé se cataj soꞌ se vaa Rej maꞌa̱n soꞌ me Diose̱, cheꞌé dan guun doj rá nij soꞌ cavi̱ꞌ Jesucristó na̱nj ado̱nj. Dan me se ase vaa Diose̱ vaa maꞌa̱n soꞌ, taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Cheꞌé dan cataj Jesucristó rihaan nij soꞌ a: ―Dan me se cata̱j xnaꞌanj yá yá ꞌu̱nj rihaan soj a. Dan me se ase vaa xnii rihaan rej xnii roꞌ, da̱nj vaa ꞌu̱nj si̱j taꞌni̱j Diose̱ nihánj rihaan Réj Diose̱, ne̱ ne uun nu̱cuáá ꞌu̱nj ꞌyáá ꞌu̱nj se vaa rii nimán ma̱ꞌanj maꞌ. ꞌO̱ se ina̱nj ꞌyáá ꞌu̱nj nda̱a vaa ꞌyaj Réj Diose̱ neꞌenj a. Ne̱ ase vaa ꞌyaj gue̱e̱ soꞌ roꞌ, veé da̱nj vaa gue̱e̱ ꞌyáá ꞌu̱nj uún ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ꞌO̱ se ꞌe̱e̱ ndoꞌo rá Réj Diose̱ niꞌya̱j soꞌ manj cheꞌé se taꞌni̱j soꞌ mej, ne̱ tihaa̱n soꞌ manj nu̱ꞌ se vaa ꞌyaj soꞌ a. Ne̱ suun sa̱ꞌ doj rihaan suun sa̱ꞌ quiꞌyáj queneꞌen soj cuano̱ roꞌ, ti̱haa̱n soꞌ manj a. Yoꞌ me se doj a̱ cara̱yaꞌa̱nj soj ni̱ꞌyaj soj suun sa̱ꞌ yoꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Dan me se ase vaa nuu iꞌna̱ꞌ uún nij síí caviꞌ ꞌyaj Réj roꞌ, da̱nj qui̱ꞌyáá ꞌu̱nj uún ado̱nj. Dan me se cunu̱u iꞌna̱ꞌ uún na̱j guun yuvii̱ qui̱ꞌyáá ꞌu̱nj, sese gu̱un rá ꞌu̱nj cunu̱u iꞌna̱ꞌ uún nij soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Dan me se ne aꞌneꞌ Réj Diose̱ cacunꞌ cheꞌé a̱ doj yuvii̱ maꞌ. ꞌO̱ se a̱j caꞌneꞌ soꞌ suun rihanj si̱j taꞌni̱j soꞌ se vaa caꞌne̱ꞌ ma̱ꞌanj cacunꞌ cheꞌé cunuda̱nj yuvii̱, ");
INSERT INTO trcNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ne̱ ase vaa aráj cochro̱j yuvii̱ rihaan soꞌ roꞌ, da̱nj ga̱a̱ cara̱a̱ cochro̱j yuvii̱ rihanj ado̱nj. Dan me se síí naꞌvej rá cara̱a̱ cochro̱j rihanj si̱j taꞌni̱j Diose̱ me se soꞌ me síí se̱ guun rá cara̱a̱ cochro̱j rihaan nda̱a Réj Diose̱ síí caꞌnéé manj a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa síí uno se‑na̱na̱j ne̱ amán rá niꞌya̱j man síí caꞌnéé manj roꞌ, se̱ cutaꞌ Diose̱ cacunꞌ xráá soꞌ maꞌ. Dan me se daj chiha̱a̱ míj se̱ caviꞌ nu̱ꞌ soꞌ maꞌ. Tana̱nj ga̱a̱ iꞌna̱ꞌ soꞌ nu̱ꞌ cavii nu̱ꞌ caꞌanj ga̱ Diose̱ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ya̱ ya̱ cata̱j xnaꞌanj ꞌu̱nj rihaan soj cuano̱ se vaa vaa güii, ne̱ nij síí ma̱n rihaan chumii̱ nihánj nij síí cavi̱ꞌ vaa güii roꞌ, caꞌmi̱j si̱j taꞌni̱j Diose̱ rihaan nij soꞌ, ne̱ nu̱ꞌ nij síí cuno̱ nana̱ caꞌmi̱j roꞌ, cunu̱u iꞌna̱ꞌ ya̱ nimán nij soꞌ, ne̱ cuano̱ nihánj me güii aꞌmij rihaan nij soꞌ, sese me rá nij soꞌ cuno̱ nij soꞌ ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ꞌO̱ se ase vaa vaa iꞌna̱ꞌ maꞌa̱n Diose̱, ne̱ vaa iꞌna̱ꞌ taranꞌ nij rasu̱u̱n ꞌyaj Diose̱ roꞌ, da̱nj vaa vaa iꞌna̱ꞌ ma̱ꞌanj si̱j taꞌni̱j Diose̱ uún, ꞌyaj Diose̱, ne̱ cunu̱u iꞌna̱ꞌ yuvii̱, qui̱ꞌyáá ꞌu̱nj, ");
INSERT INTO trcNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ne̱ ꞌu̱nj me síí nica̱j suun, ne̱ caꞌne̱ꞌ ꞌu̱nj cacunꞌ cheꞌé yuvii̱, cheꞌé yan síí caꞌnéé Diose̱ ni̱caj yuꞌunj man yuvii̱ mej ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Se̱ caráyaꞌa̱nj soj nana̱ nihánj maꞌ. ꞌO̱ se vaa güii cuno̱ taranꞌ nij síí caviꞌ na̱j rihaan santó se‑na̱na̱j, ");
INSERT INTO trcNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ne̱ cu̱riha̱nj nij soꞌ rque yoꞌóó na̱nj ado̱nj. Dan me se, nij síí quiꞌyaj se sa̱ꞌ ga̱a vaa iꞌna̱ꞌ roꞌ, cu̱riha̱nj nij soꞌ, ne̱ cunu̱u iꞌna̱ꞌ uún nij soꞌ cane̱ nij soꞌ ga̱ Diose̱ ado̱nj. Tza̱j ne̱ nij síí quiꞌyaj se chiꞌi̱i̱ roꞌ, cu̱riha̱nj nij soꞌ, tza̱j ne̱ ꞌo̱ quira̱nꞌ ndoꞌo nij soꞌ sayuun cheꞌé cacunꞌ tumé nij soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Dan me se a̱ doj ne uun nucua̱j ma̱ꞌanj quiꞌya̱j sunj a̱ maꞌ. Ma̱a̱n se ase vaa taj xnaꞌanj Réj Diose̱ rihanj roꞌ, veé da̱nj vaa ꞌyáj ga̱a aꞌnéꞌ ꞌu̱nj cacunꞌ cheꞌé nij yuvii̱, ne̱ ꞌo̱ nica̱ aꞌnéꞌ ꞌu̱nj cacunꞌ cheꞌé nij yuvii̱ na̱nj ado̱nj. ꞌO̱ se ne ꞌyáj ina̱nj se me raj qui̱ꞌyáj maꞌ. Tana̱nj ina̱nj se ataj xnaꞌanj síí caꞌnéé manj me se vaa ꞌyáj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Sese o̱rúnꞌ ꞌu̱nj me síí cata̱j xnaꞌanj rihaan soj da̱j si̱j mej, ne̱ taj cheꞌé cata̱j soj se vaa ya̱ vaa se‑na̱na̱j maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Tza̱j ne̱ vaa yoꞌó síí cataj xnaꞌanj da̱j si̱j mej, ne̱ neꞌén ꞌu̱nj se vaa soꞌ me síí cataj xnaꞌanj ya̱ cheꞌé ꞌu̱nj ei. ");
INSERT INTO trcNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Dan me se caꞌnéé soj síí cuchiꞌ rihaan síí cuꞌna̱j Juan cheꞌé rej nari̱ꞌ nij soꞌ se‑na̱na̱ síí cuꞌna̱j Juan, ne̱ cataj xnaꞌanj soꞌ nana̱ ya̱ rihaan nij soj a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","(Dan me se caꞌve̱e se caꞌmi̱i̱ veꞌé yuvii̱ cheꞌej caꞌve̱e se se̱ caꞌmii veꞌé yuvii̱ cheꞌej, taj se ꞌyaj maꞌ. Ma̱a̱n se na̱nj taj ꞌu̱nj rihaan soj cheꞌé se me raj quinani̱i̱ soj rihaan sayuun na̱nj ado̱nj.) ");
INSERT INTO trcNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Dan me se síí cuꞌna̱j Juan roꞌ, ase vaa agaꞌ yaꞌan vaa soꞌ, ne̱ ase vaa ruviꞌ sa̱ꞌ rihaan yuvii̱ ga̱a chuguu̱n agaꞌ yaꞌan yoꞌ roꞌ, da̱nj vaa ruviꞌ sa̱ꞌ tucuáán ya̱ rihaan soj quiꞌyaj soꞌ na̱nj ado̱nj. Tza̱j ne̱ nij soj roꞌ, guun rá soj cuno̱ soj se‑na̱na̱ soꞌ ꞌo̱ orá nii, cheꞌé se guun rá soj gu̱un niha̱ꞌ rá soj, quiꞌya̱j se‑na̱na̱ soꞌ, tza̱j ne̱ quiꞌyaj rmaꞌa̱n soj do̱j tzinꞌ, ne̱ tanáj uún soj se‑na̱na̱ soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ne̱ xa̱ꞌ ꞌu̱nj nihánj, tza̱j ne̱ sa̱ꞌ doj vaa síí taj xnaꞌanj cheꞌé ꞌu̱nj rihaan síí cuꞌna̱j Juan a. Dan me se vaa suun caꞌneꞌ Réj rihanj se vaa ya̱ quisi̱j suun yoꞌ qui̱ꞌyáj, ne̱ cheꞌé dan me ꞌyaj suun ꞌu̱nj nij suun yoꞌ a. Cheꞌé maꞌa̱n suun sa̱ꞌ yoꞌ caꞌve̱e xca̱j soj cuentá se vaa si̱j caꞌnéé Réj Diose̱ mej ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ne̱ Réj síí caꞌnéé manj roꞌ, maꞌa̱n soꞌ cataj xnaꞌanj da̱j si̱j mej, tza̱j ne̱ taj se‑na̱na̱ soꞌ cuno soj maꞌ. Ne̱ ne neꞌen soj da̱j vaa Réj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ne̱ taj se‑na̱na̱ soꞌ nayón nimán soj a̱ maꞌ. Da̱nj vaa soj, cheꞌé yan ne cuchuma̱n rá soj ni̱ꞌyaj soj manj si̱j caꞌnéé soꞌ rihaan chumii̱ nihánj man ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Dan me se nayaa uxrá soj danj Diose̱, cheꞌé se me rá soj xca̱j soj cuentá da̱j quiꞌya̱j soj ne̱ caꞌve̱e ca̱yáán soj ga̱ Diose̱ nu̱ꞌ cavii nu̱ꞌ caꞌanj ei. Ne̱ veé maꞌa̱n danj Diose̱ ataj xnaꞌanj cheꞌé ꞌu̱nj a. ");
INSERT INTO trcNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tza̱j ne̱ naꞌvej rá soj caꞌna̱ꞌ soj rihanj, yan caꞌve̱e cane̱ soj ga̱ Diose̱ nu̱ꞌ cavii nu̱ꞌ caꞌanj qui̱ꞌyáj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Taj se ꞌyaj sese naꞌvej rá yuvii̱ caꞌmi̱i̱ yuvii̱ nana̱ sa̱ꞌ cheꞌej maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Tza̱j ne̱ neꞌén ꞌu̱nj da̱j vaa rá soj, se vaa ne niha̱ꞌ rá soj niꞌya̱j soj Diose̱ maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Dan me se caꞌnéé Réj manj caꞌna̱j rihaan chumii̱ nihánj caꞌmi̱j se‑na̱na̱ Réj Diose̱ rihaan soj, tza̱j ne̱ ne aranꞌ rá soj caꞌmi̱j rihaan soj maꞌ. Tza̱j ne̱ sese caꞌna̱ꞌ me maꞌa̱n yoꞌó soꞌ caꞌmi̱i̱ soꞌ nana̱ avii raa̱ maꞌa̱n soꞌ, ne̱ veꞌé cuno̱ soj se‑na̱na̱ soꞌ ei. ");
INSERT INTO trcNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Daj chiha̱a̱ míj se̱ guun nucua̱j soj cuchuma̱n rá soj ni̱ꞌyaj soj manj a̱ maꞌ. ꞌO̱ se me rá soj veꞌé caꞌmi̱i̱ nij tuviꞌ soj cheꞌé soj, tza̱j ne̱ ne nanó rá soj da̱j quiꞌya̱j soj, ne̱ veꞌé caꞌmi̱i̱ Diose̱ cheꞌé soj maꞌ. ");
INSERT INTO trcNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Se̱ guun rá soj se vaa ꞌu̱nj me síí cuta̱ꞌ cacunꞌ xráá soj rihaan Réj Diose̱ maꞌ. Ma̱a̱n se vaa síí cuꞌna̱j Moisés, ne̱ nucua̱j ndoꞌo rá soj man soꞌ se vaa caꞌve̱e cavi̱i̱ sa̱ꞌ soj rihaan Diose̱ quiꞌya̱j soꞌ, tza̱j ne̱ maꞌa̱n soꞌ me síí cuta̱ꞌ cacunꞌ xráá soj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ꞌO̱ se sese ya̱ amán rá soj niꞌya̱j soj man síí cuꞌna̱j Moisés, ne̱ cuchuma̱n rá uún soj ni̱ꞌyaj soj manj, ga̱a ne̱ caꞌve̱e ei. ꞌO̱ se soꞌ me síí cachrón nana̱ rihaan yanj nana̱ taj xnaꞌanj cheꞌé ꞌu̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tza̱j ne̱ sese ne amán rá soj nana̱ cachrón soꞌ rihaan yanj, ga̱a ne̱ asa̱ꞌ caꞌve̱e cuchuma̱n rá soj cuno̱ soj se‑na̱na̱j ga̱ ―taj Jesucristó rihaan nij síí uun chij rihaan nij yuvii̱ israelitá a. ");
INSERT INTO trcNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Veé dan, ne̱ cavii Jesucristó caꞌanj Jesucristó rej xco̱ na lacuaná cuꞌna̱j Galilea a. Tiberias cuꞌna̱j yoꞌó se‑chuvi̱i na lacuaná yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Dan me se ri̱i̱ uxrá yuvii̱ canocoꞌ rej xco̱ soꞌ, cheꞌé yan a̱j queneꞌen nij yuvii̱ nu̱ꞌ nij suun sa̱ꞌ noco̱o quiꞌyaj suun Jesucristó, se vaa nahuun sa̱ꞌ ndoꞌo síí ranꞌ, quiꞌyaj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Dan me se cavii soꞌ raa̱ quij, ne̱ caꞌanj cane̱ soꞌ rihaan yoꞌóó ga̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ, ");
INSERT INTO trcNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ne̱ dan me se da̱j doj güii achiin ca̱nuû chaꞌanj pascuá chaꞌanj navij rá nij yuvii̱ israelitá a. ");
INSERT INTO trcNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Dan me se naxca̱j Jesucristó rihaan Jesucristó, ne̱ queneꞌen soꞌ se vaa caꞌnaꞌ ndoꞌo yuvii̱ rihaan soꞌ, ne̱ cataj soꞌ rihaan síí cuꞌna̱j Felipé a: ―Me rej quira̱a̱n níꞌ rachrúún cha̱ taranꞌ nij yuvii̱ nihánj, rá so̱ꞌ ga̱ ―taj soꞌ, xnáꞌanj soꞌ man síí cuꞌna̱j Felipé yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Da̱nj caꞌmii soꞌ rihaan síí cuꞌna̱j Felipé, cheꞌé se me rá soꞌ queneꞌe̱n soꞌ da̱j cata̱j síí cuꞌna̱j Felipé a. Tza̱j ne̱ a̱j neꞌen soꞌ da̱j quiꞌya̱j maꞌa̱n soꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Dan me se cataj síí cuꞌna̱j Felipé rihaan Jesucristó: ―A̱ꞌ saꞌanj vaa tuꞌvee yuvii̱ ꞌyaj suun tu̱nj yavii se̱ quisíj quiri̱ꞌ nij soꞌ do̱j rachrúún cha̱ nij soꞌ a̱ maꞌ ―taj soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Dan me se ꞌo̱ síí tucuꞌyón se‑na̱na̱ soꞌ síí cuꞌna̱j Andrés tinúú síí cuꞌna̱j Simón Pedró me soꞌ a. Cataj soꞌ rihaan Jesucristó a: ");
INSERT INTO trcNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Nihánj me nicu̱nꞌ ꞌo̱ xnii, ne̱ nica̱j xnii nihánj ꞌu̱nꞌ gue̱e̱ rachrúún ꞌnúú cebada, ne̱ vi̱j gue̱e̱ xcuaj nica̱j soꞌ, tza̱j ne̱ asa̱ꞌ caꞌve̱e quisi̱j do̱j tzinꞌ nihánj cha̱ taranꞌ nij yuvii̱ nihánj ga̱ ―taj síí cuꞌna̱j Andrés yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ga̱a ne̱ cataj Jesucristó: ―Caꞌa̱nj cane̱ nij yuvii̱ rihaan coj chri̱nꞌ, quiꞌya̱j nij soj ei ―taj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a. Dan me se ma̱n uxrá coj chri̱nꞌ rej yoꞌ, ne̱ caꞌanj cane̱ nij yuvii̱ rihaan coj chri̱nꞌ yoꞌ, ne̱ ꞌu̱nꞌ míj snóꞌo me nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Dan me se quitaꞌaa Jesucristó rachrúún, ne̱ nagoꞌ soꞌ graciá rihaan Diose̱, ne̱ cuxraꞌ taꞌa̱j soꞌ rachrúún caxríj soꞌ ston nij síí tucuꞌyón se‑na̱na̱ soꞌ, ne̱ nij síí tucuꞌyón se‑na̱na̱ soꞌ roꞌ, rqué nij soꞌ cha̱ taranꞌ nij síí ne̱ rihaan coj chri̱nꞌ yoꞌ a. Ne̱ ase vaa quiꞌyaj soꞌ ga̱ rachrúún roꞌ, da̱nj quiꞌyaj uún soꞌ ga̱ nee̱ xcuaj yoꞌ, rqué soꞌ nu̱ꞌ se vaa me rá nij yuvii̱ cha̱ nij yuvii̱ yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ga̱a quisíj caraa rque nij yuvii̱, ne̱ cataj Jesucristó rihaan nij síí tucuꞌyón se‑na̱na̱ soꞌ a: ―Naquiꞌya̱j chre̱ꞌ nij soj se quináj tuꞌva nij yuvii̱, ne̱ se̱ guun quiri̱ꞌ u̱u̱n yoꞌ maꞌ ―taj Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Cheꞌé dan naquiꞌyaj chre̱ꞌ nij soꞌ nu̱ꞌ se quináj tuꞌva nij yuvii̱, ne̱ caraa cunu̱ꞌ chuvi̱j ya̱ scaa, quiꞌyaj nij xcoꞌ nii rachrúún quináj tuꞌva nij yuvii̱ ga̱a quisíj chá nij yuvii̱ yoꞌ ꞌu̱nꞌ rachrúún yoꞌ na̱nj ado̱nj. ");
INSERT INTO trcNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Dan me se ga̱a queneꞌen nij snóꞌo suun sa̱ꞌ noco̱o quiꞌyaj suun Jesucristó, ne̱ cataj nij soꞌ: ―Síí nihánj roꞌ, ya̱ uxrá síí nataꞌ se‑na̱na̱ Diose̱ me soꞌ, ne̱ síí naꞌvi̱j níꞌ caꞌna̱ꞌ ya̱ rihaan chumii̱ nihánj me soꞌ ei ―taj nij snóꞌo yoꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tza̱j ne̱ a̱j neꞌen Jesucristó se vaa caꞌna̱ꞌ nij soꞌ, ne̱ qui̱taꞌaa nij soꞌ man soꞌ, ne̱ cune̱ꞌ nij soꞌ man Jesucristó gu̱un soꞌ síí nica̱j suun rey gu̱un chij rihaan nij soꞌ, ne̱ cheꞌé dan naxuun soꞌ man soꞌ, ne̱ cavii uún o̱rúnꞌ soꞌ caꞌanj soꞌ quij a. ");
INSERT INTO trcNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Dan me se rej tiꞌnuu, ne̱ nanij nij síí tucuꞌyón se‑na̱na̱ Jesucristó tuꞌva na lacuaná, ");
INSERT INTO trcNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ga̱a ne̱ catúj nij soꞌ rihoo, ga̱a ne̱ cavii nij soꞌ caꞌanj nij soꞌ chumanꞌ Capernaum a. Dan me se quisíj guun rmi̱ꞌ rihaan na lacuaná yoꞌ, ne̱ ataa nama̱n Jesucristó rihaan nij soꞌ a. ");
INSERT INTO trcNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ne̱ cavii nana̱ yuva̱a̱, ne̱ uxrá nariꞌ nucuaj ndoꞌo na lacuaná yoꞌ, ");
INSERT INTO trcNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ne̱ dan me se ꞌu̱nꞌ kilómetro caꞌanj nij soꞌ, ga̱a ne̱ queneꞌen nij soꞌ se vaa chéé Jesucristó