﻿USE sofia;
DROP TABLE IF EXISTS sofia.tpz_vpl;
CREATE TABLE tpz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tpz_vpl WRITE;
INSERT INTO tpz_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ivaꞌih o vahutët va pa kën sipun e Ieesuꞌ Kristo. E Ieesuꞌ a teꞌ va po vuteꞌ va pe Devit. Ke Devit eꞌ a teꞌ va po vuteꞌ va pe Abraham. ");
INSERT INTO tpz_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ke Abraham e taman e Aësak. Ke Aësak e taman e Jekop, Ke Jekop e taman voh e Judaꞌ pe ra kën kea peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ke Judaꞌ e taman voh Perës, pen Sëraꞌ. Ke sinëëre pon ivëh e Temaꞌ. Ke Perës e taman e Hësron. Ke Hësron e taman e Rëm. ");
INSERT INTO tpz_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ke Rëm voh e taman e Aminadëp. Ke Aminadëp e taman e Nason. Ke Nason e taman voh e Salmon. ");
INSERT INTO tpz_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ke Salmon e taman e Boas. Ke sinan voh eah ivëh e Rehap. Ke Boas voh ivëh e taman e Obet. Ke sinan voh e Obet ivëh e Rut. Ke Obet voh e taman e Jësiꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ke Jësiꞌ voh e taman e a teꞌ sunön vëh e Devit. Ka teꞌ sunön vëh e Devit voh e taman e Solomon. Ke sinan voh e Solomon e köövo moaan voh pe Uraëaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ke Solomon e taman voh e Rëhoboam. Ke Rëhoboam voh e taman e Abaëiaꞌ. Ke Abaëiaꞌ voh e taman e Esaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ke Esaꞌ voh e taman e Jehosafat. Ke Jehosafat voh e taman Jehoram. Ke Jehoram voh e taman Usaëaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ke Usaëaꞌ voh e taman e Jotam. Ke Jotam e taman voh e Ehës. Ke Ehës voh e taman e Hesekaëaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ke Hesekaëaꞌ voh e taman e Manësaꞌ. Ke Manësaꞌ e taman voh e Emön. Ke Emön e taman voh e Josaëaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ke Josaëaꞌ voh e sipun ere Jehoiakin me ra ma vu kea peꞌ. Manih po poen pamëh no a nap vëvënsun va Babiron to me a napan va Israël, kee teꞌ va ne manih pa nap aun manih pa muhin va Babiron. ");
INSERT INTO tpz_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Taneo non po poen nee to teꞌ ne paan a matop va Babiron, E Jehoiakin he teꞌ non e taman e Siatiel. Ke Siatiel he teꞌ non e sipun e Serubabël. ");
INSERT INTO tpz_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ke Serubabël he teꞌ non e taman e Abiut. Ke Abiut teꞌ non e taman e Ilaëakim. Ke Ilaëakim teꞌ non e taman e Esor. ");
INSERT INTO tpz_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ke Esor he teꞌ varuꞌ non e taman e Sedok. Ke Sedok he teꞌ non e taman e Ekim. Ke Ekim teꞌ non e taman e Eriut. ");
INSERT INTO tpz_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ke Eriut he teꞌ non e taman e Eliesaꞌ. Ke Eliesaꞌ he teꞌ non e taman e Matan. Ke Matan he teꞌ non e taman e Jekop. ");
INSERT INTO tpz_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ke Jekop he teꞌ non e taman e Jeosëp manih pa poen pamëh ne Jeosëp to teꞌ non e voe manot pe Mariaꞌ. Ke Mariaꞌ pamëh to tavus voh e sinan e Ieesuꞌ vëh nee to popokaꞌ ne sih poë e Kristo. A teꞌ ne Sosoenën to vateꞌ voh marën a voen hah a ma hat pa ma napan kurus. ");
INSERT INTO tpz_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Taneo non pe Abraham pareꞌ nö ko öök non pe Devit, a pau pa napan va Israël to antoen ne o pöh havun me ro taanaꞌ manih pa kën sipuiire. Pareꞌ taneo non manih pe Devit ko öök non manuh pa ö no Babiron to matop non a napan va Israël, a pau pee to onöt avoeꞌ e ne po pöh havun me ro taanaꞌ manih pa kën sipuiire. Taneo hah non manih pa matop va Babiron pareꞌ öök non manih pe Ieesuꞌ Kristo, a pau pee kurus to onöt avoeꞌ e ne po pöh havun me ro taanaꞌ manih pa kën sipuiire. ");
INSERT INTO tpz_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ivaꞌih a ö no vahutët va pa ö ne Ieesuꞌ Kristo to koaꞌ vavoh maꞌ. E sinaneah, Mariaꞌ, nee to vaheꞌ voh rapoë pen e Jeosëp. Ivëhkëk, ee to hikta koroh vëtkin avoeꞌ ne pon. Ke Mariaꞌ nat en pa ö neꞌ to han koaꞌ en, no a Tuvuh Vasioꞌ to vateꞌ en pe koaꞌ manih pa komaneah. ");
INSERT INTO tpz_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ivëhkëk, e neseneah Jeosëp eꞌ a teꞌ no a taateꞌ peꞌ to totoopin keꞌ hikta iu vapoet non e köövo peꞌ Mariaꞌ manih pa matëëra nap peo, pareꞌ kehkeh koe aven e non peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","E Jeosëp to koman avoeꞌ e non pa ö neꞌ se këh en pe Mariaꞌ. Ka ankeroꞌ pe Sosoenën tavus poan manih po tatarep, pareꞌ soe ke poan pan, “Jeosëp, eën a teꞌ va po vuteꞌ pe Devit, koe a naöp in a me e Mariaꞌ, peꞌ e köövo pën, parën pënton nom, e koaꞌ vëh to teꞌ non manih pa komaneah no a Tuvuh Vasioꞌ to heꞌ poan. ");
INSERT INTO tpz_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","E Mariaꞌ se vahuh a koaꞌ oeteꞌ pamëh, kën vëhnan eah e Ieesuꞌ, suk ataeah, eꞌ se kon hah këh a napan peꞌ pa hat.” ");
INSERT INTO tpz_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ka ma moeh tah kurus poë varih se tanok marën a vamaaka a soe ne Sunön to soe tavus voh manih pa rivooro teꞌ vanënën soe. O teꞌ vanënën soe to soe voh pan, “Pënton öm! ");
INSERT INTO tpz_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","A pah köövo muriaknan se kiuk, pareꞌ kon a pah koaꞌ oeteꞌ. Kën vëhnan eah, “e Imanuel”, o ëhnan “Imanuel” to soe va non manih, “Sosoenën to teꞌ me e non pea.” ");
INSERT INTO tpz_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ke Jeosëp sun, ko me poꞌ en pe köövo peꞌ, vamanih pa ö no ankeroꞌ pe Sunön to soe ke poan po tatarep. ");
INSERT INTO tpz_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ivëhkëk, eꞌ to hikta koroh vëtkin avoeꞌ me non poan, keꞌ öök non na manuh po poen ne Mariaꞌ to vahuh e koaꞌ oeteꞌ pamëh. Ko vëhnan en peꞌ e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","E Ieesuꞌ to koaꞌ voh manih pa koman a vöön vëh Bëtrëhëm. A vöön pamëh to teꞌ non po komön o oeh va Jiutiaꞌ. Manih po poen pamëh ne Hëërot to sunön non nën. Pareꞌ matop non a muhin pamëh. Ko poen ne Mariaꞌ to vahuh vahik en pe koaꞌ Ieesuꞌ, ka ma teꞌ susunön taneꞌ maꞌ pa ö no potan to pepeah ke non maꞌ, pare vos ee Jerusalëm, ko hi ee pa napan pan, ");
INSERT INTO tpz_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“E koaꞌ sipoan pa napan va Israël teꞌ non nih? Emöm to ep maꞌ a vesun to vëknöm non poan to paapa ke non maꞌ manuh pa ö no a potan to pepeah ke non maꞌ. Emöm to vatet maꞌ a vesun pamëh marën a vataare a taateꞌ ta manih peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","E Hëërot to pënton a soe vaꞌih pareꞌ pah koman vaꞌnaöp en, me a napan to teꞌ ne Jerusalëm, ee me to pah koman vaꞌnaöp ee. ");
INSERT INTO tpz_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ivëh ke Hëërot ununun en po teꞌ ësës heꞌ susunön me ro teꞌ vavaasis varih to nat i ne o Vavaasis pe Mosës, pareꞌ hi rapoë pan, “E Kristo a teꞌ vëh ne Sosoenën se vanö maꞌ marën a kon hah a napan peꞌ varih Israël se tavus rakah pa vöön poanheh?” ");
INSERT INTO tpz_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kee piun poë pan, “Manih Bëtrëhëm, pa muhin va Jiutiaꞌ. A teꞌ vanënën soe to soe voh pan, ");
INSERT INTO tpz_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Bëtrëhëm, manih pa muhin va Jiutiaꞌ, eën se nat nom vasuksuk vatëh nom maꞌ a ma vöön apaꞌpuh varih to teꞌ ne manih Jiutiaꞌ. Suk ataeah, amot manih pën no a pah teꞌ sunön se tavus, pareꞌ matop non a napan peöꞌ varih Israël.’” ");
INSERT INTO tpz_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ivëh ke Hëërot vaoe aven en pa ma teꞌ varih to taneꞌ maꞌ manuh pa ö no a potan to pepeah ke non maꞌ, pan ee se nö maꞌ manih peꞌ. Keꞌ hi aven rapoë po poen poanheh no a vesun pamëh to taneo tavus voh maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Murin in o siꞌ ihoꞌ pamëh ne Hëërot to vanö en pee manuh Bëtrëhëm, pareꞌ soe ke rapoë pan, “Eöm se nö paröm vaiu vavih rakah këh e koaꞌ pamëh, paröm hah koe ke maꞌ manih ko soe vanat a neoꞌ, köꞌ sih nö varuꞌ, paröꞌ vasunön eah.” ");
INSERT INTO tpz_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","A ma teꞌ sunön poë varih to tënan vahik ee pa soe pe meh sunön pee, Hëërot, pare nö pet ee. Ee to ep hah ee pa vesun vëh nee to ep moaan voh ne maꞌ. Keꞌ vovoh nö ke non pee, pareꞌ nö ko pah teꞌ totoopin rakah e non manih pa iuun vëh ne koaꞌ to teꞌ non pen sinaneah Mariaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ko poen nee to ep in a ö no a vesun to teꞌ totoopin e non nën, ee to puh rakah ee po vaeö. ");
INSERT INTO tpz_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ee to ho ee manuh koman iuun, pare taum ee pe koaꞌ pen e sinaneah Mariaꞌ. Pare vapeoꞌ pasun ke poë, ko vatokon, pare kë a ëhnan e koaꞌ, ko pureꞌ a ma mon heꞌ pee, ko heꞌ ee peꞌ. Ee to heꞌ poë a gol me o tah a voavuh vih me o vanom a voavuh vih vëh o voen vapeah. ");
INSERT INTO tpz_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ivëhkëk, e Sosoenën to tavus o teꞌ poë varih manih po tatarep, pareꞌ soe ke rapoë pan, ee se nat ne koe hah ke manuh pe Hëërot. Ivëh kee koe ke pa meh hanan to nö hah non manuh pa muhin pee. ");
INSERT INTO tpz_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Vasuksuk in o poen no o teꞌ sunön to hah ee manuh pa muhin pee, ka ankeroꞌ pe Sunön tavus e Jeosëp po tatarep, pareꞌ soe ke poan pan, “Jeosëp! Sun ah! Parën rusin me a poa tom sinan pën manuh Isip. Paröm teꞌ nem nën, keꞌ antoen rakah non a ö nöꞌ se soe vanat hah oah a ö nën se hah maꞌ. Suk ataeah, e Hëërot to vavaiu vah non e koaꞌ pan eꞌ se ip vamët poan.” ");
INSERT INTO tpz_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ke Jeosëp sun, ko pön me en pa poa tom sinan peꞌ, kee nö ko vos ee manuh Isip. ");
INSERT INTO tpz_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ee to teꞌ ne nën keꞌ antoen po poen ne sunön va Jiutiaꞌ e Hëërot to mët. Keꞌ a tah pamëh to vapuh rakah en pa soe ne Sunön to soe ke voh o teꞌ vanënën soe pan, “Eöꞌ to vaoe nös e koaꞌ peöꞌ teꞌ tavus këh maꞌ a Isip.” ");
INSERT INTO tpz_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","E Hëërot to nat en pa ö no o teꞌ sunön varih to taneꞌ maꞌ manuh pa ö no a potan to pepeah koe ke non maꞌ to piuk in poë, ko kokoman peꞌ pah hat oah rakah en po heve, keꞌ taꞌ en pa ma nap vëvënsun peꞌ, kee nö ee manuh Bëtrëhëm, me pa ma siꞌ vöön to teꞌ vatët ne nën. Ee to nö pare ip vamët o koaꞌ oeteꞌ sosoneꞌ, taneo non po teꞌ o kon varuꞌ ko öök ne po teꞌ varih to teꞌ me ne a ma pöök kirismas. Eꞌ to nat e non peꞌ to pöök kirismas voh non ka ma teꞌ susunön soe ke poë a ö nee to ep a vesun. Ivëh, neꞌ to taꞌ suk a ma teꞌ vëvënsun peꞌ, pan ee se ip vamët a ma koaꞌ oeteꞌ sosoneꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","A tah pamëh to vapuh non a soe ne Sosoenën to soe ke voh a teꞌ vanënën soe peꞌ vëh e Jeremaëaꞌ. E Jeremaëaꞌ to soe voh pan. ");
INSERT INTO tpz_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Manih Remaꞌ, no a napan to pënton a vakoei, a napan to pënton o vaokook vatamak. E Resel to okook non o pus koaꞌ peꞌ, ka napan hikta onöt ne a vatö o kokoman peꞌ. Suk ataeah o pus koaꞌ peꞌ to mët vahik ee.” ");
INSERT INTO tpz_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Vasuksuk, ne Hëërot to mët en. Ka ankeroꞌ pe Sosoenën tavus e Jeosëp po tatarep manih Isip. ");
INSERT INTO tpz_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","A ankeroꞌ pe Sosoenën to soe ke Jeosëp pan, “Jeosëp! Sun ah! Parën me hah a poa tom sinan pën, köm hah manuh Israël, suk ataeah, o teꞌ varih to kehkeh ip vamët ne e koaꞌ to mët vahik ee.” ");
INSERT INTO tpz_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ivëh ke Jeosëp sun, pareꞌ me hah en pa poa tom sinan peꞌ, kee hah ee manuh Israël. ");
INSERT INTO tpz_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ivëhkëk, e Jeosëp to pënton hah a soe to soe non pan, e Akereas to kon a tasun pe tamaneah Hëërot, pareꞌ tavus a teꞌ apuh va Jiutiaꞌ. Ivëh, ke Jeosëp to nanaöp non a nö hah manuh Jiutiaꞌ. Ivëhkëk, e Sunön to tavus hahah kov en peꞌ po tatarep, pareꞌ soe ke poan a ö neꞌ se nö hah en manuh pa muhin va Galiliꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Eꞌ to me hah en pa poa tom sinan peꞌ, kee teꞌ e ne Nasarët. Ee to teꞌ ne nën marën a vapuh a soe voh po teꞌ vanënën soe to soe non pan, “A napan se popokaꞌ amot ne poë, a to Nasarët.” ");
INSERT INTO tpz_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Manih po poen pamëh ne Jon Tövapupui teꞌ to tavus maꞌ, pareꞌ teꞌ non pa moeh upin va Jiutiaꞌ. Eꞌ to taneo en pa vavaasis a napan varih to nö maꞌ manih peꞌ, pareꞌ soe ke rapoë pan, ");
INSERT INTO tpz_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Panih öm a ma taateꞌ hat peöm, paröm vatet a taateꞌ vih, suk ataeah, a Matop Vih va pa Vöön va Kin to öök vatët en maꞌ!” ");
INSERT INTO tpz_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","E Jon pamëh no a teꞌ vanënën soe vëh eꞌ Aisaëaꞌ, to soe suk voh pan, “Manih pa moeh upin no a pah teꞌ to vavaoe non maꞌ pan, ‘Vamatop öm a hanan pe Sunön, paröm vatotoopin a ma hanan peꞌ.’” ");
INSERT INTO tpz_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ko ohop ne Jon to ohop non nee to nok voh pa uvin këmol, pareꞌ voh non o voh to tavi non a vuvuhuneah, pareꞌ ënëën non sih o kokaꞌ, ko kakaaktön non po hun tankekvö va muhin. ");
INSERT INTO tpz_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Eꞌ to këh maꞌ a moeh upin, pareꞌ nö ko teꞌ non pa muhin to teꞌ non sinten a ruen Jödën, ka napan varih to nönö ne maꞌ manih peꞌ to tataneꞌ ne maꞌ manuh Jerusalëm me a ma ö kurus va Jiutiaꞌ me manih pa muhin vëh neꞌ to teꞌ non. ");
INSERT INTO tpz_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ee to nö maꞌ, pare soe tavus a ma hat pee, ke Jon pupui raoe manih pa ruen Jödën. ");
INSERT INTO tpz_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","E Jon to ep in o Jiuꞌ varih to vavatet vakis ne sih a taateꞌ pa kën sipun, me ro Sëdiusi to nö maꞌ manih peꞌ pan eꞌ se pupui rapoë, ivëhkëk, ee to hikta soe tavus momoaan a ma hat pee. Ke Jon soe ke raoe pan, “Eöm to teꞌ rakah va e nem manih po kuruꞌ to rurusin këh ne o suraꞌ. Eteh to kömköm a neöm, köm rurusin këh e nem po heve pe Sosoenën neꞌ to se vanö maꞌ? ");
INSERT INTO tpz_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Eöm se panih, paröm këh a ma taateꞌ hat, ko vataare a panih manih pa taateꞌ peöm. ");
INSERT INTO tpz_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Paröm nat nem soe vamanih pan, ‘E Abraham e sipuura, ivëh, ke Sosoenën hikta se vakmis a rora a ma vuteꞌ peꞌ.’ Eöꞌ to soe vaman rakah keoꞌ peöm, e Sosoenën to onöt e non pa vateꞌ a ma vös varih, kee tarih ee a ma pus koaꞌ pe Abraham. ");
INSERT INTO tpz_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","A ipoaꞌ pe Sosoenën to vamatop e non pa taka a ma aan in a ma naon kurus varih to hikta vovoaꞌ ne a ma voaꞌ vih, a ma naon poë varih se moes, ko vi ee po suraꞌ, kee ës ee. Ke tövaneah pa rak taka en pee, pareꞌ vi en pee po suraꞌ kee ës ee. E Sosoenën se nok va ka neöm nën.” ");
INSERT INTO tpz_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Eöꞌ to pupui a noꞌ neöm pa ruen to vëknöm e non peöm to panih em pa ma taateꞌ hat peöm. Ivëhkëk, a teꞌ vëh se suk a maꞌ neoꞌ, no o kikis peꞌ to teꞌ oah e non po teꞌ kikis peöꞌ. Eöꞌ to hikta vih onöt noꞌ a ihan këh eah o uris vëh pa poa suꞌ peꞌ. Eꞌ se pupui a neöm pa Tuvuh Vasioꞌ me o suraꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Eꞌ se nö maꞌ, ko pitöꞌ këh a kon hat manih pa kon vih peꞌ. Pareꞌ ununun a kon vih peꞌ manih pa iuun vavahoꞌ kon. Ko ës en pa kon hat manih po suraꞌ ësës tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Manih po poen pamëh ne Ieesuꞌ to këh maꞌ a muhin va Galiliꞌ, pareꞌ nö en manuh pa ruen Jödën. Eꞌ to nö manuh pe Jon pareꞌ iu non a ö ne Jon se pupui poan. ");
INSERT INTO tpz_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ivëhkëk, e Jon to punöꞌ poan teꞌ panih o kokoman peꞌ, pareꞌ hi poan pan, “Eꞌ to vih non pa ö nën se pupui varoe a neoꞌ. Vahvanih kën nö maꞌ parën taꞌ a neoꞌ a pupui a oah?” ");
INSERT INTO tpz_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ivëhkëk, e Ieesuꞌ to piun a soe pe Jon pareꞌ soe ke poan pan, “Koe ah, parën nok vamanih pa ö nöꞌ to sosoe va noꞌ. Ea se keh nok va nën, ea se vapuh rakah ee pa tah ne Sosoenën to iu non na se nok.” Ivëh, ke Jon vatet en pa soe pe Ieesuꞌ, pareꞌ pupui en peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","E Jon to pupui vahik en pe Ieesuꞌ, keꞌ tatakin nö non, pareꞌ ep in a akis to nö vakëh. Ka Tuvuh Vasioꞌ pe Sosoenën kunah va maꞌ manih pa panuh, ko atantön e non peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ka to taneꞌ maꞌ manuh pa vöön va kin to soe va non manih pan, “Ivaꞌih e koaꞌ peöꞌ nöꞌ to iu oah vi noꞌ eah, paröꞌ vaeö me noꞌ eah.” ");
INSERT INTO tpz_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Manih po poen pamëh no a Tuvuh Vasioꞌ to me en pe Ieesuꞌ manuh pa moeh upin, pan e susun po oraꞌ hat se punöꞌ poan. ");
INSERT INTO tpz_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Manih pa ma poen poë varih ne Ieesuꞌ to hikta ëën po 40 potan me o 40 poen. Ko vasuksuk neꞌ to maë vörep en. ");
INSERT INTO tpz_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ka teꞌ va pa punöꞌ o teꞌ nö maꞌ ko tavus en peꞌ, pareꞌ soe ke poan pan, “Eën se keh teꞌ nom pan eën e Koaꞌ pe Sosoenën, kën taꞌ a ma vös varih, kee panih, pare tarih varuꞌ ee a ma muꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ivëhkëk, e Ieesuꞌ to piun va in a soe pe susun po oraꞌ hat pamëh manih pan, “O Puk Vapenpen to soe ka rora sih pan, ‘O muꞌ to hikta onöt non a heꞌ o toꞌtoꞌ tamoaan manih pa napan, a ma soe varoe pe Sosoenën to antoen ne pa heꞌ a ra o toꞌtoꞌ pamëh.’” ");
INSERT INTO tpz_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","E Ieesuꞌ to soe va in poan manih, ke susun po oraꞌ hat me vos en peꞌ manuh Jerusalëm, ko me peah en peꞌ manuh pa ö noton in a Iuun Hinhin Apuh. ");
INSERT INTO tpz_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Pareꞌ soe ke poan pan, “Eën se nom teꞌ nom pan eën e Koaꞌ vamaman pe Sosoenën, kën surap taneꞌ manih, parën vuꞌ kunah eom na manuh po oeh. Suk o Puk Vapenpen to soe non pan, ‘E Sosoenën se soe ke ro ankeroꞌ peꞌ, kee ut vavih rakah e ne pën. O ankeroꞌ se öt ee pën pa ma koreere, ka hikta pah vös to onöt non a ruk a momah.’ ");
INSERT INTO tpz_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","E Ieesuꞌ to piun poan, pareꞌ soe, “O Puk Vapenpen to soe pet e non pan, ‘Eën se nat nom pupunöꞌ nom pa vöknah e Sunön pën e Sosoenën.’” ");
INSERT INTO tpz_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","E susun po oraꞌ hat to me peah hahah kov en peꞌ manuh pa tope a pah va kin vörep, pareꞌ vataare vahik rakah en peꞌ pa ma muhin kurus, me a ma moeh tah vihvih peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Pareꞌ soe ke poan pan, “Eën se keh vatokon, parën vapeoꞌ pasun ko vasunön a neoꞌ, a, eöꞌ se heꞌ vahik rakah eoꞌ pën pa ma moeh tah kurus varih.” ");
INSERT INTO tpz_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ke Ieesuꞌ piun varuꞌ va in a soe pe susun po oraꞌ hat pamëh vamanih pan, “Susun po oraꞌ hat, nö na, o Puk Vapenpen pe Sosoenën to soe non pan, ‘Eën se vasunön varoe ko e Sunön Sosoenën pën. Parën vatet varoe ko o iu peꞌ.’” ");
INSERT INTO tpz_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ivëh ke susun po oraꞌ hat këh en pe Ieesuꞌ, ko ankeroꞌ pe Sosoenën nö maꞌ, pare matop e ne peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","E Ieesuꞌ to pënton en pa soe va pa ö nee to vahoꞌ ee pe Jon pa nohnoh, pareꞌ hah en manuh pa muhin va Galiliꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Eꞌ to këh en pa vöön va Nasarët, pareꞌ nö ko teꞌ non manuh Kapaneam, a vöön pamëh no a napan to hikta teꞌ ne o Jiuꞌ to teꞌ ne. Eꞌ to teꞌ vatët non pa sinten a tonon va Galiliꞌ. Eꞌ a ö muhin pee Sebulun pen Naptaliꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","E Ieesuꞌ to nok a tah vaꞌih marën a vapuh a soe ne Sosoenën to to tavus voh manih pa rivon a teꞌ vanënën soe peꞌ, Aisaëaꞌ, ");
INSERT INTO tpz_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“A muhin va Sebulun, me a teꞌ muhin va Naptaliꞌ, to vënton ke ne tahiꞌ manih sinten a ruen Jödën. Manih Galiliꞌ no a napan to hikta teꞌ ne o Jiuꞌ to teꞌ ne nën. ");
INSERT INTO tpz_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","A napan poë varih to teꞌ ne sih pa popoen, ee se ep ee po maaka apuh. Ee to teꞌ ne pa ö to parin a popoen, ivëhkëk, o maaka se vaëman en pee.” ");
INSERT INTO tpz_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Manih po poen pamëh ne Ieesuꞌ to teꞌ avoeꞌ e non manih Kapaneam pareꞌ taneo en po vavaasis peꞌ manih pa napan. Eꞌ to soe ke rapoë pan, “Eöm se panih a ma taateꞌ hat peöm, paröm vatet a ma taateꞌ vih, suk ataeah, a Matop Vih va pa Vöön va Kin to öök vatët en maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","E Ieesuꞌ to ëhë nö non pa sinten a tonon va Galiliꞌ, pareꞌ ep a poa tom kea, e Saëmon, nee to pokaꞌ ne poë e Pitaꞌ pen e kea peꞌ Ëndruꞌ. Eꞌe pon to tatanaꞌ iian ne sih pa kë pee manih pa tonon va Galiliꞌ, ov in a vavoen. ");
INSERT INTO tpz_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ke Ieesuꞌ soe ke rapoë pan, “Suk a maꞌ neoꞌ öm pom, köꞌ sih vavaasis a neöm pa vaon a napan, kee hop maꞌ manih pa Matop Vih pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ka varuꞌ rakah vakomanih ne ee pon to këh ee maꞌ pa kë pee, pare vatet ee pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Eꞌ to hë en pa meh siꞌ ö, pareꞌ taum en pa meh poa tom kea, e Jëmis pen kea peꞌ Jon a poa koaꞌ oeteꞌ pe Sëbëdiꞌ, eꞌe to tok ne po paröꞌ ke tamëëre. Pare vunvun hah ne a kë pee to tökrus, ke Ieesuꞌ vaoe en na pee pon. ");
INSERT INTO tpz_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ka varuꞌ rakah vakomanih nee to këh ee maꞌ pe tamëëre me o paröꞌ, pare vatet ee pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","E Ieesuꞌ to vatvi vahik rakah en pa ma vöön varih to teꞌ ne pa muhin va Galiliꞌ. Pareꞌ vavaasis non a ma napan manih koman a ma iuun hinhin soneꞌ pee. Eꞌ to vavaasis non a soe va pa Matop Vih pe Sosoenën manih pa ma napan. Pareꞌ vavatoꞌ hah nö non a ma napan varih to haraꞌ ne a ma vu mët. ");
INSERT INTO tpz_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Manih Siriaꞌ no a napan to vavahutët suk vaviꞌ e ne pa ma tah ne Ieesuꞌ to nonok non, ko teꞌteꞌ kov e ne maꞌ po teꞌ to haraꞌ ne a ma vu mët, me a ma vu kamis. O teꞌ me varih no o oraꞌ hat to öt ne rapoë, me ro teꞌ mëtsioni me ro teꞌ kokonoh. Ke Ieesuꞌ vavatoꞌ vahik rakah en pee. ");
INSERT INTO tpz_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","A nap peo poë varih to taneꞌ maꞌ pa muhin va Galiliꞌ, me manih pa teꞌ muhin va Dekapolis, me manih Jerusalëm, me manih pa ma vöön to teꞌ ne pa koman a muhin va Jiutiaꞌ, me pa pap tonon vöh. Ee kurus to vatet ee pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","E Ieesuꞌ to ep in a nap peo rakah to teꞌ vaꞌpeh me ne poë, pareꞌ tok peah pa siꞌ ö tope, pareꞌ ihoꞌ non ka ma vamomhë peꞌ nö maꞌ manih peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Keꞌ taneo en pa vavaasis rapoë. ");
INSERT INTO tpz_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“A napan varih to koman ne pan, ee to kökööt ne pa ma taateꞌ pe Sosoenën. Ee se vaeö, suk ee a pap teꞌ poë varih se hop manih pa Matop Vih va pa Vöön va Kin.” ");
INSERT INTO tpz_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Ka napan varih to okook vatamak ne sih, ee se vaeö. Suk ataeah, e Sosoenën se vamö en pee.” ");
INSERT INTO tpz_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Ka napan varih to vöknah ne a ma taateꞌ pee, ee se vaeö. Suk ataeah, e Sosoenën se heꞌ en pee po oeh.” ");
INSERT INTO tpz_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“A napan varih to mamaë ne a vatet a taateꞌ totoopin, ee se vaeö rakah. Suk ataeah, e Sosoenën se makën vamhun en pee pataeah nee to iu ne.” ");
INSERT INTO tpz_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Ka napan varih to ururuan ne sih o upöm teꞌ, ee se vaeö. Suk ataeah, e Sosoenën se ururuan me en pee.” ");
INSERT INTO tpz_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Vaeö rakah pa napan varih no a ma kokoman pee to vivihan, ee se ep ee pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Vaeö rakah pa napan varih to vavahik hah nö ne a ma vapus, me a ma vaheheve. Amot nee se tavus ee o pus koaꞌ pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Vaeö rakah pa napan varih to tahinën suk a ma taateꞌ totoopin pe Sosoenën nee to vavatet ne. Varuꞌ vamanih, nee se vaneah avoes e ne pa Matop Vih va pa Vöön va Kin.” ");
INSERT INTO tpz_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","“Vaeö rakah peöm varih, no a napan to vateen a neöm pa ma soe hat, pare hinën ka neöm ko vakmis a neöm, ko ruk a neöm pa ma soe piuk, suk eöm to teꞌ nem a napan peöꞌ. Eꞌ a pah taateꞌ hat ko pamëh to tanok moaan voh manih po teꞌ vanënën soe varih to teꞌ vovoh voh ka no neöm. Ivëh, köm se vaeö rakah, peꞌ o voen vih peöm to anoeh e non maꞌ peöm manuh pa vöön va kin.” ");
INSERT INTO tpz_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","E Ieesuꞌ to toto avoeꞌ e non pareꞌ soe pan, “Eöm to teꞌ va nem manih pa sö va po oeh. O tetehean pa sö se keh hik këh en peꞌ, a hikta ö nöm se nok vah va in eah, keꞌ tetehean hah. Keꞌ vih non peöm se ru in na eah po oeh, paröm kom tötöön eah pa ma moeeneöm. ");
INSERT INTO tpz_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Eöm to teꞌ va nem manih po maaka va po oeh. A pah vöön apuh to teꞌ non maꞌ pa tope pareꞌ hikta antoen non a vakoaan. ");
INSERT INTO tpz_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","A napan to hikta antoen ne a vëkrea o ram pare kupkup po kove. Ahik! A napan to vëvëkrea ne sih o ram pare vahan manih pa ö hanhan peꞌ, suk a ö neꞌ se heꞌ non o maaka manih pa napan kurus varih koman iuun. ");
INSERT INTO tpz_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Eꞌ to teꞌ akuk va kov e non manih pa taateꞌ vih peöm, nöm se vataare a napan. Kee sih inan a ma taateꞌ vih nöm to nonok nem pare kë a ëhnan e Tamëneöm vöh pa vöön va kin.” ");
INSERT INTO tpz_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Eöm se nat nem koman nem pan eöꞌ to nö voh maꞌ marën a miröꞌ o Vavaasis pe Mosës me a Soe po Teꞌ Vanënën Soe. Ahik! Eöꞌ to hikta nö voh maꞌ pa miröꞌ, eöꞌ to nö ro voh maꞌ marën a vapuh a ma soe poë varih. ");
INSERT INTO tpz_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Eöꞌ to soe vaman rakah keoꞌ peöm, taneo non kuru pareꞌ öök non po poen no a akis me o oeh se hik, ahik rakah ta siꞌ pah ö kiun me ta siꞌ ö vëknöm va po Vavaasis pe Mosës se ro. O Vavaasis pamëh se teꞌ va kov e non manih ko antoen rakah manih po poen no o Vavaasis pamëh me a ma Soe po Teꞌ Vanënën Soe se tavus vaman. ");
INSERT INTO tpz_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ivëhkëk, ta pah teꞌ se keh pënton varo o vavaasis vaꞌih, pareꞌ vavaasis pet a ma upöm teꞌ pa taateꞌ vatösoe, a, eꞌ to hikta antoen non a kon o ëhnan apuh manih pa Matop Vih va pa Vöön va Kin. Ivëhpëhkëk, a teꞌ vëh to vavatet vakis non a taateꞌ pënton soe, pareꞌ vavaasis pet non a ma upöm teꞌ pa taateꞌ pamëh, eꞌ se kon o ëhnan apuh manuh pa vöön va kin. ");
INSERT INTO tpz_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Eöꞌ to soe vaman rakah keoꞌ peöm. Eöm se keh hikta vavatet vavih nem o iu pe Sosoenën, me a taateꞌ totoopin peöm se keh hikta teꞌ oah non a taateꞌ totoopin po Parësiꞌ, me ro teꞌ nat in o Vavaasis pe Mosës, a, eöm to hikta antoen nem a teꞌ hop manih pa Matop Vih va pa Vöön va Kin.” ");
INSERT INTO tpz_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","E Ieesuꞌ to toto avoeꞌ e non pareꞌ soe, “Eöm to pënton voh em pa ma soe no a kën sipuura to sosoe voh ne. Ee to sosoe voh ne pan, ‘Koe a ip vamët a meh teꞌ.’ Ta pah teꞌ se keh ip vamët a meh teꞌ, eꞌ se sun en manih po vahutët.” ");
INSERT INTO tpz_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","“Ivëhkëk, eöꞌ to soe keoꞌ peöm pan, a teꞌ to heve non e kea peꞌ, eꞌ se sun en po vahutët. Me eteh to vapöpöötan e kea peꞌ, eꞌ me se sun en pa matëëro Vakum Teꞌ Susunön po Jiuꞌ. Me eteh se keh veveot a meh teꞌ, eꞌ se tahinën rakah en po suraꞌ ësës tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ivëh, kën se kehkeh teꞌ nom maꞌ o heꞌ pën manih pa pok vapenpen, pan eën se heꞌ na e Sosoenën, parën koman antoen o vakihat peöm pom kea pën, ");
INSERT INTO tpz_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","eën se vahoꞌ voh o heꞌ pën manih pa sinten a pok vapenpen, ko hah voh manuh pe kea pën, köm vaöt koren vovoh voh maꞌ, parën hah poꞌ maꞌ ko heꞌ poꞌ na e Sosoenën o heꞌ pën.” ");
INSERT INTO tpz_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Eteh se kehkeh vahoꞌ a nom oah po vahutët, eën se vavih vëhöꞌ hah eah, eꞌ he meꞌ e non pa vahoꞌ a oah po vahutët. Eën tomeꞌ varëërë nom, keꞌ vahoꞌ en pën pa koren e tökiiki soe. Keꞌ heꞌ en pën po pirisman. Kee nohnoh ee pën. ");
INSERT INTO tpz_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Eöꞌ to soe vaman rakah keoꞌ pën, eën to hikta onöt rakah nom a këh tavus ohoꞌ maꞌ a iuun nohnoh, keꞌ antoen non a ö nën se voen vahik a moniꞌ no e tökiiki soe to vateꞌ ka oah.” ");
INSERT INTO tpz_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Moaan voh ne eöm to pënton voh em pa soe to soe non pan, ‘Eöm varih a nap vavaen, eöm se nat nem këh a ma köövo peöm, paröm nö manuh pa ma meh köövo ko koroh me raoe, eöm to miröꞌ em pa taateꞌ va po vaen.’ ");
INSERT INTO tpz_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ivëhkëk, eöꞌ to soe vaman rakah keoꞌ peöm. Ta pah teꞌ se keh ep ta pah köövo pareꞌ manin vahat poan manih po kupu peꞌ, eꞌ to teꞌ akuk va kov e non manih pa ö neꞌ to koroh me en peꞌ, eꞌ me a teꞌ pamëh to miröꞌ en pa taateꞌ va po vaen.” ");
INSERT INTO tpz_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“A papmatö vëh pa matömah se keh rëh a oah pa nok a taateꞌ hat, të kon eah ko vi na. Eꞌ to vih non pa ta pah ö va pa sioniumah se hikta teꞌ non, peꞌ to rëh e non pën pa nok a taateꞌ hat. Eꞌ to hat non pa ö no sioniumah se kamis manih po suraꞌ ësëës tamoaan. ");
INSERT INTO tpz_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ka papmatö pa koreomah se keh rëh a oah pa nok a taateꞌ hat. Moes kurus eah ko vi na. Eꞌ to vih non pa ta pah ö va pa sioniumah se hikta teꞌ non, peꞌ to rëh en pën pa nok a taateꞌ hat. Eꞌ to hat non pa ö no sioniumah se kamis manih po suraꞌ ësëës tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Moaan voh no a soe to soe non pan, ‘E voe teh to koman non a veo e köövo peꞌ, eꞌ se heꞌ momoaan voh o kiun to soe vanat non a ö neꞌ se kök en po vaen pee.’ ");
INSERT INTO tpz_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ivëhkëk, eöꞌ to soe vaman rakah keoꞌ peöm. E voe se keh veo akuk e köövo to hikta teꞌteꞌvaasiꞌ non, ke köövo nö pareꞌ me hah a meh voe, e köövo pamëh to kök pet me en pa taateꞌ va po vaen. Ka hat pamëh ne voe moaan peꞌ to nok tariuk ke poan. Ke voe teh to me hah e köövo vëh moaan voh ne voe peꞌ to veo poan, eꞌ me to nok en pa taateꞌ rëhrëh.” ");
INSERT INTO tpz_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Eöm to pënton voh em pa soe no a kën sipuura to sosoe voh ne pan, ‘Eën se nat nom piuk parën soe vaman na manuh kin pe Sunön. Eën se keh nonok nom ta pah tah parën soe vaman na manuh pe Sunön, eën se vatet vatotoopin rakah a soe pamëh.’ ");
INSERT INTO tpz_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Eöꞌ to soe rakah keoꞌ peöm. Eöm se nat nem soe vaman na manuh pa ëhnan a vöön va kin marën a vakikis a soe peöm. Suk ataeah, a vöön pamëh eꞌ a ö vöön pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Paröm koe a soe vaman manih po oeh, marën a vakikis a soe peöm, suk ataeah, o oeh eꞌ a ö vavakom pe Sosoenën. Paröm nat nem soe vaman manuh Jerusalëm marën a vakikis a soe peöm. Suk ataeah, a vöön pamëh eꞌ a vöön pe Sunön Sipoan. ");
INSERT INTO tpz_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Paröm nat nem soe vaman manih pa ma naineöm marën a vakikis a soe peöm. Suk ataeah, eën to hikta antoen nom a panih a uviumah keꞌ tavus kakaare, keꞌ eꞌ se tavus vapö. ");
INSERT INTO tpz_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Eöm se soe varoe kuru, oman, pa ö neꞌ se teꞌ non o man. Ka hik, pa ö neꞌ se teꞌ non a hik. Eën se keh kon pet a soe, eꞌ a soe ko pe susun po oraꞌ hat ipamëh.” ");
INSERT INTO tpz_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","E Ieesuꞌ to toto avoeꞌ e non pareꞌ soe pan, “Eöm to pënton voh em pa soe nee to soe voh ka neöm pan, ‘Ta pah teꞌ se keh miröꞌ a matan a meh teꞌ, a, eꞌ to vih non peöm se miröꞌ varuꞌ em pa teꞌ mataneah. Ka ta pah teꞌ se keh tös kök a riu rivon a meh teꞌ, a, eöm se tös kök varuꞌ em pa teꞌ riurivoneah.’ ");
INSERT INTO tpz_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Eöꞌ to soe vaman rakah keoꞌ peöm. Koe a piun a hat no a meh teꞌ to nok manih peöm. Ta pah teꞌ se keh tapan a panömah, a, tarih, parën heꞌ na a meh papan, keꞌ tapan. ");
INSERT INTO tpz_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ta pah teꞌ se keh vahoꞌ a oah manih po vahutët suk a ötop pën, kën se keh hikta onöt nom a piun a ötop pamëh, eën se heꞌ eom peꞌ po ohop vatonun pën. Parën vatok pet na po ohop voon pën, keꞌ kon. ");
INSERT INTO tpz_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","A pah teꞌ vëvënsun se keh iu non a ö nën se teꞌ a ma tah peꞌ pa paeh a kiromitaꞌ, a, eën se teꞌ a ma tah peꞌ pa poa kiromitaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ta pah teꞌ se keh hin a oah ta pah tah sën heꞌ eah, a, eën se heꞌ eom peꞌ. Me ta teꞌ se kehkeh ötop non manih pën, kën nat nom amun eah.” ");
INSERT INTO tpz_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","E Ieesuꞌ to toto avoeꞌ e non pareꞌ soe pan, “Moaan voh ne eöm to tënan voh em pa soe to soe non pan, ‘Eöm se iu a ma poëëneöm,’ ‘paröm rës o teꞌ varih to hat ka no neöm.’ ");
INSERT INTO tpz_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ivëhkëk, kuru nöꞌ to soe keoꞌ peöm pan, ‘Eöm se iu o teꞌ varih to vakihat me a no neöm, paröm hin na o vaꞌaus manuh pe Sosoenën, keꞌ ururuan o teꞌ varih to hihinën a no neöm. ");
INSERT INTO tpz_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Eöm se keh vatet a ma taateꞌ varih, eöm se tavus vamaman rakah em o pus koaꞌ pe Sosoenën e Tamëneöm va pa vöön va kin. Pareꞌ vavatvus non maꞌ sih a potan, keꞌ paapa non sih a napan varih to nonok ne a ma taateꞌ vih, me o teꞌ varih to nonok ne a ma taateꞌ hat. Pareꞌ soe ka uhön keꞌ nus maꞌ manih po teꞌ varih to nonok ne a ma taateꞌ totoopin, me ro teꞌ varih to hikta teꞌ totoopin ne manih po epep pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Eöm se keh iu varoe nem o teꞌ varih to iu a no neöm, keteh se poꞌ voen a neöm? A nap kokon takis to nonok e ne pa pah taateꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ke eöm se keh vih varoe ke nem a kën kea peöm, eöm se poꞌ vih oah vah va i ro upöm teꞌ nih? Suk ataeah, o teꞌ varih to hikta nat ne sih pe Sosoenën to vih me ke ne pa ma kën kea pee. ");
INSERT INTO tpz_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ka ma taateꞌ peöm sih teꞌ totoopin va ne manih pa ö no a taateꞌ pe Tamëneöm vöh pa vöön va kin to teꞌ totoopin va non.’” ");
INSERT INTO tpz_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Matop nem, eöm se nat nem nok a ma taateꞌ vaꞌaus peöm marën a ö no teꞌ se ep. Eöm se keh nonok va nem nën, eöm to hikta onöt nem a kon o voen vih peöm, manih pe Tamëneöm vöh pa vöön va kin. ");
INSERT INTO tpz_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Eën se kehkeh heꞌ nom ta tah pën manih po teꞌ arus, koe a piu vovoh a suvin vamanih pa ö no teꞌ möhmöh to nonok va ne sih manih pa ma koman iuun hinhin soneꞌ me manih pa ma hanan. Ee a pap teꞌ pikpiuk möhmöh poë varih to iu ne pan a napan se kë ne a ma ëhnëëre. Eöꞌ to soe vaman rakah keoꞌ peöm, a pap teꞌ poë varih to kon vahik voh ee pa ma voen pee. ");
INSERT INTO tpz_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Eën se kehkeh vaꞌaus nom o teꞌ arus, ka papkiruk nat non a nat pataeah no a papmatö pën to nonok non. ");
INSERT INTO tpz_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ivëh, ka taateꞌ vaꞌaus pën sih teꞌ vakoaan non, eën tomeꞌ teꞌ va nom manih pa teꞌ möhmöh. Ke Tamömah sih nat non a ma vaꞌaus pën a vakoaan, pareꞌ piun ken pën pa ma vaꞌaus poë varih.” ");
INSERT INTO tpz_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“O poen nöm to hinhin nem, eöm se nat nem nonok va nem pa ö no teꞌ mokoꞌ rivoe to nonok va ne sih, ee to iu rakah ne a ö nee se sun ne koman a ma iuun hinhin soneꞌ, me manih pa ma hanan. Pare hinhin ne pan a napan se inan ne pee o teꞌ va pa hin. Pare ta ne rapoë. Keöꞌ to soe rakah keoꞌ peöm, a pap teꞌ poë varih to kon vahik voh ee po voen pee. ");
INSERT INTO tpz_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“Ivëhkëk, eöm se kehkeh hin nem, eöm se ho manih pa koman a ö teꞌteꞌ peöm, paröm papanih maꞌ o hopaꞌ paröm hin na pe Tamëneöm vöh na to hikta epep no eah. Ke Tamëneöm pamëh to nat non pa inan a tah to tatanok vakoaan non. ");
INSERT INTO tpz_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ko poen nöm se hin, eöm se nat nem soe ta ma moeh soe peo, vamanih po teꞌ mokoꞌ rivoe, ee to sosoe akuk rakah e ne pa tah to hikta teꞌ non ta pusun eah. Ee to koman ne pan ee se nok ta ma soe peo ke Sosoenën sih pënton a ma hin pee. ");
INSERT INTO tpz_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Koe rakah a vatet a ma taateꞌ pee. Eöm se kehkeh hin nem ta pah tah manih pe Tamëneöm, e Tamëneöm to nat momoaan vur en pataeah nöm to kökööt e nem. ");
INSERT INTO tpz_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","O poen nöm se hin, eöm se soe vamanih pa hin peöm, ‘Tamamöm eën to teꞌ nom vöön va kin. Emöm to hin nem pan a ëhnöömah se teꞌ vasioꞌ tamoaan non. ");
INSERT INTO tpz_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","A Matop Vih pën se nö maꞌ. Kemöm sih vatet vavih o iu pën manih po oeh, vamanih pa ö nee to vavatet va ne sih manuh pa vöön va kin. ");
INSERT INTO tpz_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Heꞌ a maꞌ möm a taëën to onöt non a ma poen kurus. ");
INSERT INTO tpz_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ihan anoe a ma hat pemöm, vamanih pa ö nemöm to ihan anoe va voh in a ma hat no upöm teꞌ to nok ka möm. ");
INSERT INTO tpz_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Parën nat nom vaonöt a punöꞌ, keꞌ tavus manih pemöm, kon këh a möm a ma punöꞌ pe susun po oraꞌ hat.’” ");
INSERT INTO tpz_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Oman rakah! Eöm se keh ihan anoe a hat pa meh teꞌ neꞌ to nok manih peöm, ke Tamëneöm vöh pa vöön va kin me se ihan anoe en pa ma teꞌ hat peöm. ");
INSERT INTO tpz_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Eöm se keh hikta ihan anoe a ma hat po upöm teꞌ, e Tamëneöm me to hikta se ihan anoe non a ma teꞌ hat peöm.” ");
INSERT INTO tpz_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Eöm se keh vapenpen nem pa taëën, eöm se nat nem ep vatamak va nem po teꞌ mokoꞌ rivoe. Ee se ep vatamak ne pan a napan se ep ne rapoë to vapenpen ne pa taëën. Ivëh, köꞌ soe rakah keoꞌ peöm. Ee to kon vahik voh ee pa ma voen pee. ");
INSERT INTO tpz_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ivëhkëk, eöm se keh vapenpen rakah nem pa taëën, huip a uvineöm ko pupui a matëëneöm. ");
INSERT INTO tpz_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ivëh, ka napan sih ep ka no neöm pare koman ne pan eöm to hikta vapenpen nem pa taëën. E Tamëneöm vöh no a napan to hikta epep ne sih poë, eꞌ varoe a paeh to ep non, eꞌ ro ko to ep non pa tah vakoaan ko se piun ken peöm.” ");
INSERT INTO tpz_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","E Ieesuꞌ to toto avoeꞌ e non pareꞌ soe pan, “Eöm se nat nem ununun nem ta ma moeh tahkoek peöm manih po oeh vëh. Manih po oeh vëh no pui me o ratoꞌ to mimiröꞌ vi ne a ma moeh tah. A nap kakaveo to onöt rakah e ne pa kök a iuun peöm, ko kaveo vahik ee pa ma moeh tavahoꞌ peöm. ");
INSERT INTO tpz_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ivëhkëk, eöm se vatet a ma taateꞌ vih manih po oeh, a ma taateꞌ poë varih to ununun a tahkoek peöm manuh va pa vöön va kin. Suk ataeah, manuh va pa vöön va kin no o pui me o ratoꞌ to hikta teꞌ ne nën marën a miröꞌ a ma moeh tahkoek peöm. Me a nap kakaveo to hikta teꞌ ne nën marën a kök a iuun ko kaveo a ma moeh tahkoek peöm. ");
INSERT INTO tpz_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","A ö poanheh no a ma moeh tahkoek peöm to pet ne, no o kupu peöm se pah pet vakis e ne na nën.” ");
INSERT INTO tpz_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“O matan to teꞌ va non manih po ram va pa sionin. Ivëh, ka matömah se keh teꞌ maaka non, eën se ep vavih e nom, ka sioniumah teꞌ me e non po maaka. ");
INSERT INTO tpz_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ivëhkëk, a matömah se keh hat, eën hikta se ep vavih nom, ka sioniumah teꞌ me e non pa popoen. Ivëh, kën se matop nom, suk ataeah, eën se keh teꞌ me nom pa popoen, eën se miröꞌ suntan hah eo.” ");
INSERT INTO tpz_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“A hikta pah teꞌ to onöt non a matop a kiu pa poa torara, eꞌ se hat ke non pa paeh, pareꞌ iu e non pa meh. Eꞌ se pëpënton e non pa soe pa paeh, pareꞌ heꞌ tonun e non pa meh. Eöm to hikta onöt nem tavus a teꞌ kikiu pa poa teꞌ, e Sosoenën me a moniꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ke Ieesuꞌ sosoe avoeꞌ ke non pa ma vamomhë peꞌ pan, “Ivëh, köꞌ soe ka neöm, eöm se nat nem koman vörep nem o toꞌtoꞌ peöm, paröm soe vamanih pan, ‘Ea se ëën nös ataeah, keꞌ ea se kaak nös ataeah?’ Paröm nat nem koman vörep nem a sionineöm, paröm soe pan, ‘Ea se rara ataeah?’ A taateꞌ va pa vatet o iu pe Sunön ko teꞌ vavih oah e non pa taateꞌ va pa ëën vamhun. O toꞌtoꞌ to apuh oah rakah e non pa sioniumah me eꞌ to apuh oah e non pa tah ohop. ");
INSERT INTO tpz_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ep këk öm po növan varih to nönö vah ne sih, ee to hikta nepnep taëën ne sih, ko osoes ne. Pare hikta ununun taëën ne sih pa ta ma iuun vavahoꞌ taëën. Ivëhkëk, e Sosoenën to mamakën e non pee. Ke eöm varih o teꞌ eöm to apuh oah e nem po növan. ");
INSERT INTO tpz_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Eöm se nat nem karë vörep suk nem a ma tah varih po oeh, ee to hikta se varë pet ne a pop peöm. ");
INSERT INTO tpz_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Vahvanih köm koman vörep nem a ohop peo? Eöm se inan voh pa ö no a töpkaꞌ to pupu va ne manih pa ma supui. Ee tötöpkaꞌ vah va ne sih nih? Ee to hikta kikiu vëhvaꞌ ne sih pa vatëk hah rea. ");
INSERT INTO tpz_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ivëhkëk, eöꞌ to soe voh keoꞌ peöm, moaan voh e Solomon to ohop non a ma ohop mamatan vavih peꞌ, ivëhkëk, a matan vavih pa ma töpkaꞌ varih to matan vavih oah e ne pa ma ohop pe Solomon. ");
INSERT INTO tpz_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","E Sosoenën to vavatëk vavih e non po meon vëh. Ka sinup nee se puit ko vi ee po suraꞌ. Ko meon to teꞌ va non nën, e Sosoenën to rara non sih poan. Ivëh, köm se nat va nem manih pan, e Sosoenën to matop vavih oah e non peöm vamanih pa ö neꞌ to matop va i non o meon. O siꞌ vaman peöm to soneꞌ vörep. ");
INSERT INTO tpz_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Eöm se nat nem koman va nem manih pan, ‘Ea se ëën ataeah, para kaak ataeah, para ohop ataeah?’ ");
INSERT INTO tpz_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ahik, a napan varih to hikta teꞌ me ne o vaman to kokoman vörep ne a ma tah poë varih. Ivëhkëk, e Tamëneöm va pa vöön va kin to nat e non pa ö nöm to kökööt nem a ma tah poë varih. ");
INSERT INTO tpz_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ivëhkëk, a tah to apuh oah non pa ö nöm se iu nem a ma tah vih to heꞌ vaeö non e Sosoenën e Sunön peöm. Paröm vatet a taateꞌ totoopin peꞌ. Keꞌ se heꞌ a neöm a ma tah nöm to kökööt nem manih pa matop vih peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ivëh, köm se nat nem kokoman vörep nem ataeah se tavus sinup me pa ma papaeh poen. A ma poen poë varih to teꞌ me ne a ma punis koman pee.” ");
INSERT INTO tpz_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Eöm se nat nem kiiki a ma taateꞌ hat pa meh teꞌ. E Sosoenën me se hikta kiiki a ma teꞌ taateꞌ hat peöm. ");
INSERT INTO tpz_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","E Sosoenën se kiiki me en pa ma taateꞌ peöm, vamanih pa ö ne eöm to kiiki va i nem a ma teꞌ taateꞌ po upöm teꞌ. A ma tah varih nöm to heꞌheꞌ akuk nem sih o upöm teꞌ, eꞌ a ma tah poë varih ne Sosoenën se piun hah ken peöm. ");
INSERT INTO tpz_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Vahvanih kën kuteꞌ vaviꞌ nom a tapisik soneꞌ vëh to teꞌ non pa matan e kea pën, ivëhkëk, eën to hikta koman nom a tanaon apuh vëh to teꞌ non pa matömah? ");
INSERT INTO tpz_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Vahvanih, kën soe ke kea pën pan, ‘Kea köꞌ kan këh na a matömah pa tapisik vëh pa matömah.’ Ivëhkëk vamomoaan nën se inan hah voh eo, eën to teꞌ vanun e nom pa tanaon apuh vëh to teꞌ non pa teꞌ matömah. ");
INSERT INTO tpz_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Eën a teꞌ mokoꞌ rivon, kon momoaan a tanaon apuh vëh to teꞌ non pa matömah. Ko vasuksuk poꞌ nën se ep vamaaka nom, parën pah kan takin poꞌ a tapisik soneꞌ vëh to teꞌ non pa matan e kea pën. A pusun in a soe vaꞌih to soe va non manih pan, ‘Eën se ep momoaan voh pa hat pën, parën pah vatotoopin poꞌ e kea pën.’” ");
INSERT INTO tpz_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Koe a heꞌ o këh a tah vapenpen to vaneah non pe Sosoenën. O këh tomeꞌ tapiun maꞌ pare ëën ee peöm. Paröm nat nem vi ke na o kuꞌ a ma mök vihvih peöm. O kuꞌ to meꞌ kom tötöön i rapoë pa ma moeere.” ");
INSERT INTO tpz_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","E Ieesuꞌ to vavaato avoeꞌ e non pareꞌ soe pan, “Hin vakis rakah na manuh pe Sosoenën, keꞌ sih heꞌ a neöm ataeah ne eöm to kökööt nem. Me eöm se keh vavaiu vah nem e Sosoenën, eöm se taum em peꞌ. Me eöm se keh tekteok o hopaꞌ, ke Sosoenën se peret ken peöm. ");
INSERT INTO tpz_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Suk ataeah, o teꞌ varih to hinhin vakis ne pe Sosoenën, ee se kon ee pa ma taneah nee to kökööt e ne. Ko teꞌ varih to vaiu vah ne e Sosoenën, ee se taum ee peꞌ. Ko teꞌ varih to tekteok ne o hopaꞌ, e Sosoenën se peret ken pee. ");
INSERT INTO tpz_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Eöm se poꞌ nok vahvanih pa ö no ta pah koaꞌ peöm se keh hin e tamaneah to muꞌ, e tamaneah se kës heꞌ en peꞌ pa vös? Ahik. ");
INSERT INTO tpz_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Keꞌ e koaꞌ se keh hin e tamaneah ta iian, e tamaneah se kës heꞌ en peꞌ pa kuruꞌ? Eꞌ me ahik. ");
INSERT INTO tpz_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Eöm ro teꞌ hat, eöm to heꞌheꞌ nem sih a ma tah vihvih manih pa ma koaꞌ peöm. Ivëh, köm se nat vavih va nem manih pan, e Tamëneöm to teꞌ non manuh pa vöön va kin, eꞌ se heꞌ en maꞌ pa ma tah vihvih manih po teꞌ varih to hinhin ne poë.” ");
INSERT INTO tpz_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“A ma taateꞌ ne eöm to iu nem pan o upöm teꞌ se nok ka neöm, eꞌ a ma taateꞌ poë varih ne eöm se nok varuꞌ ke raoe. Ivaꞌih a pusun rakah in o Vavaasis pe Mosës, me o Vavaasis po Teꞌ Vanënën Soe.” ");
INSERT INTO tpz_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","E Ieesuꞌ to vavaato avoeꞌ e non pareꞌ soe pan, “Eöm se suk rakah a hanan kopih. Peꞌ a hanan to nö non manuh pa vöön va pa kon kamis to parin a papanöꞌ, pareꞌ tö rakah pa suk, ivëh, ka nap peo vavatet ne a hanan pamëh. Ivëhkëk, a teꞌ hanan vëh to koe ke non manih pa vöön va po toꞌtoꞌ tamoaan, to parin soneꞌ pareꞌ kopih. Keꞌ hivaꞌ rakah e non pa napan pa suk, ivëh, ka siꞌ nap keok akuk to vavatet ne a hanan pamëh. Ivëh, keöm se suk rakah a hanan pamëh.” ");
INSERT INTO tpz_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Eöm se vamatop vavih rakah nem po teꞌ vanënën soe pikpiuk. Ee to nat vi ne a nok a ma to marën a vamanman a neöm. Pare teꞌ va ne manih po këh poa to ohop maꞌ o peos sipsip ko huk vatët maꞌ po sipsip to not ta teꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Eöm se inan koe raoe manih pa taateꞌ hat nee to nonok ne. A taateꞌ vih to hikta antoen non a taneꞌ maꞌ manih pa nap hat. Eꞌ to teꞌ akuk va kov e non manih, po noꞌ voaën to hikta antoen non a pu taneꞌ maꞌ po komön o noꞌ uris toꞌtoꞌ, me o kakau to hikta antoen non a vaveoh taneꞌ maꞌ pa vu kensun. ");
INSERT INTO tpz_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Eꞌ to ep va kov e non manih, o nöꞌ vih to vovoaꞌ non sih o voaꞌ vih. Ko nöꞌ hat to vovoaꞌ non sih o voaꞌ hat. ");
INSERT INTO tpz_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","O naon vih to hikta onöt non a voaꞌ o voaꞌ hat. Ko naon hat hikta antoen non a voaꞌ o voaꞌ vih. ");
INSERT INTO tpz_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ka naon kurus varih to hikta vovoaꞌ vavih ne, no a napan se moes vi ko vi ee pee po suraꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Eöm se inan koe i ro teꞌ vanënën soe pikpiuk, manih pa ma taateꞌ pee.” ");
INSERT INTO tpz_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pan, “Eꞌ to hikta teꞌ non pan o teꞌ kurus to popokaꞌ a no neoꞌ pan, ‘Sunön, Sunön, eën e Sunön pemöm’, se hop manih pa Matop Vih va pa Vöön va Kin. O teꞌ varoe varih to vavatet ne a ma tah ne Tamön vöh pa vöön va kin to iu non se hop manih pa Matop Vih va pa Vöön va Kin. ");
INSERT INTO tpz_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Manih po poen ne Sosoenën se kiiki a ma taateꞌ pa napan, a nap peo rakah se soe ka neoꞌ pan, ‘Sunön, Sunön, eën e Sunön pemöm. Emöm to nonok nem a ma kiu vanënën soe manih pa ëhnöömah. Manih pa ëhnöömah nemöm to veveo tavus nem o oraꞌ hat, pamöm nonok nem a ma tah vatoksean.’ ");
INSERT INTO tpz_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Köꞌ se soe vamaaka rakah keoꞌ pee pan, ‘Këh a na neoꞌ öm, peöꞌ to hikta nat noꞌ peöm. Suk eöm o teꞌ va pa nok vatëh a ma taateꞌ hat.’” ");
INSERT INTO tpz_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“O teꞌ varih to pënton ne a ma tah nöꞌ to sosoe noꞌ pare vatet, ee to teꞌ va ne manih pa teꞌ natnat to eok a iuun peꞌ tonun a vös. ");
INSERT INTO tpz_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ka uhön nus ka ruen unat ka ivat ip maꞌ, pareꞌ kö en pa iuun. Ivëhkëk a iuun to hikta vuꞌ. Suk ataeah a teꞌ natnat to eok a iuun peꞌ tonun a vös. ");
INSERT INTO tpz_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ivëhkëk o teꞌ varih to pënton varo ne a soe nöꞌ to vavaasis noꞌ, pare hikta vatet, eꞌe to teꞌ va ne manih pa teꞌ papön to eok a iuun peꞌ pa tonun o kösan. ");
INSERT INTO tpz_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ka uhön nus suntan maꞌ, ka ruen unat maꞌ ka ivat ip pet en maꞌ, pareꞌ kö en pa iuun. Ka iuun takök, pareꞌ vuꞌ vakëkëh rakah en manih po oeh.” ");
INSERT INTO tpz_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","E Ieesuꞌ to sosoe vahik ko non a ma soe peꞌ ka napan töhkak vahat rakah ee po vavaasis peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","E Ieesuꞌ to hikta vavaasis va non manih po teꞌ nat in o Vavaasis pe Mosës. Ahik, eꞌ to vavaasis va non manih pa teꞌ to teꞌ me non a tasun. ");
INSERT INTO tpz_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","E Ieesuꞌ to kunah taneꞌ maꞌ manuh pa tope, ka nap peo rakah vatet poë. ");
INSERT INTO tpz_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ka pah teꞌ to teꞌ me non a mët töpaꞌ nö maꞌ manih pe Ieesuꞌ. Pareꞌ vatokon, ko soe ke poan pan, “Sunön, eën se keh iu nom kën vatoꞌ hah eom peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ke Ieesuꞌ vaket en peꞌ, pareꞌ soe pan, “Eöꞌ to iu e noꞌ. Voon ah.” Ka varuꞌ rakah vakomanih no a mët töpaꞌ to hik këh en pa sionineah. ");
INSERT INTO tpz_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ke Ieesuꞌ vuhvuh poan pareꞌ soe pan, “Eën se nat nom vavatët ta meh teꞌ a tah vaꞌih to tanok manih pa sioniumah. Ivëhkëk, eën se nö parën vataare varoe a sioniumah manuh pa teꞌ ësës heꞌ po Jiuꞌ, köm ip ta vönaꞌ paröm ës ke na e Sosoenën vamanih pa ö no Vavaasis pe Mosës to soe vavoh, ka tah pamëh se vataare non a napan a ö no mët pën to hik en, kën voon hah eom.” ");
INSERT INTO tpz_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","E Ieesuꞌ to nö en manuh pa vöön va Kapaneam. Ko poen neꞌ to vos nën ka pah teꞌ susun pa 100 teꞌ vëvënsun va Room nö en maꞌ manih peꞌ. Pareꞌ hin poan o vaꞌaus, ko soe pan, ");
INSERT INTO tpz_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Sunön a teꞌ kikiu peöꞌ to haraꞌ non a kamis pareꞌ koroh e non maꞌ iuun. Eꞌ to hikta onöt non a riu a sionineah. Me eꞌ to haraꞌ suntan e non po kamis.” ");
INSERT INTO tpz_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ke Ieesuꞌ soe ken pe susun pa nap vëvënsun pan, “Eöꞌ se nö eoꞌ nös paröꞌ vatoꞌ hah eoꞌ peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ivëhkëk, e susun pa nap vëvënsun to piun a soe pe Ieesuꞌ, pareꞌ soe pan, “Sunön sipoan, eöꞌ to hikta teꞌ vih onöt noꞌ a ö sën nö na pa iuun peöꞌ. Eën se soe varoe ko maꞌ ka teꞌ kikiu peöꞌ toꞌ hah. ");
INSERT INTO tpz_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Suk ataeah, eöꞌ me to teꞌ noꞌ paan in a teꞌ vëh to vovoh ka non eoꞌ pa heꞌ a neoꞌ a kiu. Eöꞌ koman to teꞌ me noꞌ po teꞌ vëvënsun to teꞌ ne paan. Eöꞌ se këh soe ke a teꞌ pamëh, ‘Nö ah,’ keꞌ nö en. Eöꞌ se keh soe ke a teꞌ pan, eꞌ se nö maꞌ, keꞌ se nö en maꞌ. Eöꞌ se keh taꞌ a teꞌ kikiu peöꞌ, ‘Nok a kiu vaꞌih’, eꞌ se pënton en pa soe peöꞌ. Pareꞌ nok en pa kiu pamëh.” ");
INSERT INTO tpz_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","E Ieesuꞌ to pënton a soe vaꞌih, pareꞌ pah kokoman vörep e non. Pareꞌ soe ke ra napan varih to teꞌ vaꞌpeh me ne poë pan, “O pöh man rakah, eöꞌ to soe ka neöm, manih pa muhin va Israël eöꞌ to hikta ep noꞌ ta pah teꞌ no vaman peꞌ to eh va non manih pa teꞌ susun pa nap vëvënsun vëh. ");
INSERT INTO tpz_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Eöꞌ to soe vaman rakah keoꞌ peöm, a nap peo rakah to hikta teꞌ ne ro Jiuꞌ se taneꞌ maꞌ manuh pa ö no a potan to pepeah ke non maꞌ. Me manih pa ö no a potan to kukunah koe ke non, ee se nö maꞌ pare ihoꞌ ko vaëën me Abraham, ke Aësak, ke Jekop, manih pa koman a Matop Vih va pa Vöön va Kin. ");
INSERT INTO tpz_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","O Jiuꞌ varih to koman vapiun ne pan ee se hop ee pa Matop Vih va pa Vöön va Kin, ivëhkëk, e Sosoenën se vateꞌ en pee pa vöön popoen. Ka manih pa vöön pamëh no a napan se okook kov e ne, ko vakuskus rivon me e ne po kamis o apuh rakah. ");
INSERT INTO tpz_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","E Ieesuꞌ to soe ken pe susun pa nap vëvënsun pan, “A teꞌ kikiu pën se toꞌ en, suk eën to vaman nom pan eꞌ se toꞌ hah en.” Ka varuꞌ vakomanih no a teꞌ kikiu to toꞌ en. ");
INSERT INTO tpz_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","E Ieesuꞌ to nö en manuh pa iuun pe Pitaꞌ, pareꞌ taum e köövo noan e Pitaꞌ to koroh non. Eꞌ to haraꞌ non a hiinana. ");
INSERT INTO tpz_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","E Ieesuꞌ to vaket pa koreneah ka hiinana pamëh hik këh en peꞌ, keꞌ sun ko vamatop ken pe Ieesuꞌ pa taëën. ");
INSERT INTO tpz_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pa matan poen no a napan to teꞌteꞌ kov e ne maꞌ po teꞌ öt po oraꞌ manih pe Ieesuꞌ. Ke Ieesuꞌ taꞌ o oraꞌ, kee këh ee po teꞌ. E Ieesuꞌ to vavahik a ma vu mët varih to öt ne a napan. ");
INSERT INTO tpz_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","E Ieesuꞌ to nok a ma tah vatoksean poë varih, marën a vapuh a to to tavus taneꞌ voh manih pa rivon a teꞌ vanënën soe vëh, e Aisaëaꞌ. Eꞌ to soe voh pan, “Eꞌ to teꞌ a ma kamis pea, pareꞌ vahik en pa ma vu mët pea.” ");
INSERT INTO tpz_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Manih Kapaneam e Ieesuꞌ to ep a napan to parin a peo vörep to tönun töön ne poë, pareꞌ soe ke ra ma vamomhë peꞌ pan, “Ea se pahan ee manuh pa pap tonon vöh.” ");
INSERT INTO tpz_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ivëhkëk, a pah teꞌ vavaasis to nat non o Vavaasis pe Mosës to nö maꞌ manih pe Ieesuꞌ, pareꞌ soe ke poan pan, “Apuh, a ma vöön kurus nën to nönö nom, ne eöꞌ se suk eoꞌ pën.” ");
INSERT INTO tpz_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ke Ieesuꞌ soe ke poan pan, “O këh poa to teꞌ me ne a ma koveꞌ teꞌteꞌ pee, ko növan teꞌ me ne pa ma heꞌ teꞌteꞌ pee. Ivëhkëk, eöꞌ e Koaꞌ Teꞌ pa Napan Kurus to hikta teꞌ me noꞌ ta ö ne eöꞌ se koroh ko vanot.” ");
INSERT INTO tpz_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ka meh teꞌ, eꞌ e vamomhë koman pe Ieesuꞌ to soe ke poan pan, “Topoan, vaonöt ka neoꞌ ah, köꞌ nö paröꞌ pe voh maꞌ e tamön.” ");
INSERT INTO tpz_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ivëhkëk, e Ieesuꞌ to piun poan pareꞌ soe pan, “Ahik, suk a maꞌ neoꞌ ah, parën koe o teꞌ varih to hikta kon avoeꞌ ne o toꞌtoꞌ tamoaan, kee nö, pare pe o upöm teꞌ mët pee.” ");
INSERT INTO tpz_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","E Ieesuꞌ to tok po paröꞌ me a ma vamomhë peꞌ, kee nö ee. ");
INSERT INTO tpz_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ka ivat ip maꞌ, ka supa susurap hop e non manih po komön o paröꞌ. Ivëhkëk, e Ieesuꞌ a koroh varo. ");
INSERT INTO tpz_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ka ma vamomhë nö, pare kunkuin poë, pare soe pan, “Topoan, Topoan, hehe a ra ah, a siꞌ ö hat, ko paröꞌ rokoꞌ me en pea.” ");
INSERT INTO tpz_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","E Ieesuꞌ to piun rapoë pareꞌ soe pan, “Eöm nanaöp suk nem ataeah? Eöm to teꞌ me nem o vaman to parin a soneꞌ.” Ke Ieesuꞌ sun, pareꞌ taꞌ a tuvuh me a supa, ka tuvuh tö en, ka supa hikta ririu hah non. ");
INSERT INTO tpz_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ka ma vamomhë peꞌ pah töhkak vahat ee, pare soe ee pan, “A teꞌ vëh, eꞌ rakah eteh? Ka tahiꞌ me a tuvuh tënan ee pa soe peꞌ?” ");
INSERT INTO tpz_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","E Ieesuꞌ to pahan pet en manuh pa pap tonon vöh, pareꞌ takin en pa muhin pa napan va Gadaraꞌ. Nën no a poa teꞌ no oraꞌ hat to teꞌ ne manih pee, to nö ee maꞌ pe Ieesuꞌ. A poa teꞌ poë varih to teꞌteꞌ ne sih po vapeepe. Ee pon to vavaꞌnaöp ne sih a napan. Ka napan hikta onöt ne a suk a hanan to koe ke non po vapeepe pamëh. ");
INSERT INTO tpz_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ee pon to nö maꞌ manih pe Ieesuꞌ, pare kokoeꞌ vakis rakah ee maꞌ pan, “Koaꞌ pe Sosoenën, eën se nok ataeah manih pemöm? Eën to nö pöꞌ maꞌ pa vakmis a möm, ha? O poen pën pa vakmis a möm to meꞌ avoeꞌ e non maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ee to teꞌ vatët ne pa ö no vasun kuꞌ peo to ënëën ne. ");
INSERT INTO tpz_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ko oraꞌ hat hin vakis ee pe Ieesuꞌ, pare soe maꞌ pan, “Eën se keh veo a möm, emöm se nö ko hop em po kuꞌ varuh.” ");
INSERT INTO tpz_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ke Ieesuꞌ soe ke rapoë. “Nö öm.” Ka ma oraꞌ hat poë varih këh ee pa poa teꞌ pare nö ko hop ee po kuꞌ poë varih. Ko vasun kuꞌ poë varih vavaveo kunah ee pa ö vaere, ko susurap ee na pa tonon, pare vuk, ko mët vahik ee. ");
INSERT INTO tpz_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ka napan varih to matop ne sih po vasun kuꞌ pamëh ep a tah vaꞌih, pare varurusin ee. Ee to vos manuh pa vöön apuh, pare vahutët ee pa ma taneah to tanok töön rapoë manih pa poa teꞌ poë varih. ");
INSERT INTO tpz_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ka napan kurus va pa vöön apuh pamëh nö ee pa ep këh e Ieesuꞌ. Ee to ep ee peꞌ, pare hin vakis poë, pan eꞌ se këh tavus a muhin pee, pareꞌ nö pa ta meh muhin. ");
INSERT INTO tpz_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","E Ieesuꞌ to peah en po paröꞌ, pareꞌ pahan hah en manuh pa pap tonon vöh. Ko vos en pa vöön koman peꞌ vëh Kapaneam. ");
INSERT INTO tpz_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ka ma pah teꞌ teꞌ ee maꞌ pa teꞌ tëtënkun to koroh non po pan peꞌ. Ke Ieesuꞌ inan o vaman pee, ivëh keꞌ soe ke a teꞌ tëtënkun pamëh pan, “Koaꞌ peöꞌ, vatö o kokoman pën, peöꞌ to ihan anoe eoꞌ pa ma hat pën.” ");
INSERT INTO tpz_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ko teꞌ vavaasis varih to nat ne sih o Vavaasis pe Mosës to pënton a soe pe Ieesuꞌ, pare vavasoe aven e ne pan, “A teꞌ vëh toto va non manih toh? Eꞌ to sosoe oꞌoah e non pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","E Ieesuꞌ to nat vahik en pa ma kokoman pee, ivëh, keꞌ soe ke rapoë pan, “Suk ataeah, köm teꞌ me nem o kokoman hat? ");
INSERT INTO tpz_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Eꞌ hikta teꞌ hivaꞌ non pa soe ke a teꞌ tëtënkun vëh pan, ‘A ma hat pën nöꞌ to ihan anoe eoꞌ’. Suk ataeah, o upöm teꞌ to hikta antoen ne a inan vamanih pan a ma hat peꞌ to hik ee. Ivëhkëk, eꞌ to hivaꞌ oah e non pa soe ke a teꞌ tëtënkun pan, ‘Eën se sun, ko nö eom’. Suk ataeah, a ma napan se ep ne, pan a teꞌ pamëh to toꞌ hah en. ");
INSERT INTO tpz_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ivëhkëk, eöꞌ se vamaaka ka neöm a pah tah, köm se vaman, ko nat ka neoꞌ e Koaꞌ Teꞌ pa Napan Kurus to teꞌ me noꞌ pa tasun manih po oeh marën a ihan anoe a ma hat. Ivëh, köꞌ taꞌ eoꞌ pa teꞌ tëtënkun pamëh pan, ‘Sun ah, parën kon o pan pën, ko nö eom manuh pa iuun pën.’” ");
INSERT INTO tpz_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ka varuꞌ rakah vakomanih no a teꞌ tëtënkun pamëh to sun, pareꞌ kon o pan peꞌ, ko nö en pa iuun peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ka napan varih to ep ne pa tah ne Ieesuꞌ to nok manih pa teꞌ tëtënkun pamëh töhkak rakah ee. Pare naöp ko pah kë ee pa ëhnan e Sosoenën. Suk ataeah, e Sosoenën varoe kuru to heꞌ o vu kikis vëh manih pa teꞌ va po oeh keꞌ nonok non a ma kiu to matan va ne manih. ");
INSERT INTO tpz_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","E Ieesuꞌ to këh a ö neꞌ to teꞌteꞌ non, pareꞌ ep a pah teꞌ kokon takis to ihoꞌ non pa iuun kokon takis. A ëhnaneah e Matiu. Ke Ieesuꞌ soe ke poan pan, “Suk a maꞌ neoꞌ ah.” Ke Matiu sun, pareꞌ vatet en peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Po poen ne Ieesuꞌ to ënëën non manih pa iuun pe Matiu, me a nap kokon takis, me ro teꞌ no a ma taateꞌ pee to hat, me a ma vamomhë peꞌ, ");
INSERT INTO tpz_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ko Parësiꞌ ep e Ieesuꞌ to ënëën vaꞌpeh me e non pa nap kokon takis, me ro teꞌ no a ma taateꞌ pee to hat, pare hi ee pa ma vamomhë pe Ieesuꞌ pan, “Vahvanih ke tövavaasis peöm ënëën vaꞌpeh me non pa nap kokon takis me ro teꞌ no a ma taateꞌ pee to hat?” ");
INSERT INTO tpz_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","E Ieesuꞌ to pënton a soe vaꞌih no Parësiꞌ to ihi ne a ma vamomhë peꞌ, pareꞌ soe ke rapoë pan, “O teꞌ varih to hikta haraꞌ ne a mët, eꞌe to hikta nönö ne pa ep e röktaꞌ. Ahik. A napan varoe varih to haraꞌ ne a mët to nönö ne pe röktaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Eöm se nö paröm kokoman këh a pusun a soe vaꞌih to kiun non po Puk Vapenpen to soe non pan, ‘Eöꞌ to iu oah noꞌ a taateꞌ iu teꞌ. Eꞌ a taateꞌ pamëh to apuh oah non a ö nöm to ip a vönaꞌ, paröm ës ke na e Sosoenën.’ Eöꞌ to hikta nö voh maꞌ pa vaꞌaus o teꞌ varih to koman ne pan ee ro totoopin. Ahik. Eöꞌ to nö voh maꞌ pa vaꞌaus o teꞌ varih to nat va ne manih pan ee ro teꞌ hat.” ");
INSERT INTO tpz_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Vasuksuk no a ma vamomhë pe Jon Tövapupui to nö maꞌ manih pe Ieesuꞌ, pare hi poë pan, “Vahvanih, kemöm me ro Parësiꞌ vavatet e nem pa taateꞌ vapenpen pa ëën? Ivëhkëk, a ma teꞌ vamomhë pën to kök ee pa taateꞌ pea, pare hikta vapenpen ne pa ëën a taëën.” ");
INSERT INTO tpz_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ke Ieesuꞌ piun rapoë pareꞌ heꞌ a soe vapipinoꞌ to vamaaka non a kiu peꞌ pareꞌ soe ke rapoë pan, “Eꞌ to vih pöꞌ non pa ma teꞌ pe voe tövaen vavoon se haraꞌ vatamak ne? Ahik. E voe tövaen vavoon se keh teꞌ vaꞌpeh me non raoe, ee hikta se haraꞌ vatamak ne. Suk ataeah, ee to vaeö me ne e voe tövaen vavoon. Ivëhkëk, a ma poen se tavus maꞌ no upöm teꞌ se me ke ee pe voe tövaen vavoon, keꞌ këh en pa ma teꞌ peꞌ. Manih po poen pamëh eꞌe se vapenpen ee pa taëën. Suk ataeah eꞌe to tamak e ne poë. Ivëh, ka peah hah pe Ieesuꞌ manuh kin to teꞌ va i non manih pe voe tövaen to këh a ma vamomhë peꞌ, kee vapenpen ne a taëën.” ");
INSERT INTO tpz_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","E Ieesuꞌ to sosoe vapipinoꞌ avoeꞌ e non, pareꞌ heꞌ o meoh pöök soe vapipinoꞌ to vamaaka non o vavaasis voon peꞌ, pareꞌ soe pan, “A hikta pah teꞌ to onöt non a kurus a ta rara voon pareꞌ kunpip a töhkoꞌ vëh to teꞌ non po ohop vamoaan. Eꞌ se keh nok va nën, pareꞌ pupui vatëh non o ohop pamëh, eꞌ se miröꞌ oah rakah en po ohop, ka ta rara vëh to kunpip non a töhkoꞌ tanunuꞌ ka töhkoꞌ pah tökrus vaꞌpuh oah en. ");
INSERT INTO tpz_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Me a hikta pah teꞌ to isu o voaën voon manih po pëk vamoaan nee to kun po kap sipsip. Eꞌ se keh isu en po voaën voon o voaën voon se kurus en po pëk vamoaan. Suk o pëk vamoaan to hikta onöt non a tëptot. Ivëh, ko pëk se tökrus en ko voaën takoꞌ en. Ahik. Eöm se isu o voaën voon manih po pëk voon nee to kun po kap sipsip.” Ivëh, ka se nat no öt vatös in o vavaasis moaan me o vavaasis voon pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","E Ieesuꞌ to vavaato avoeꞌ me e non pa ma vamomhë pe Jon Tövapupui, ka pah teꞌ to susun non pa iuun hinhin soneꞌ nö maꞌ, pareꞌ vatokon manih pa matan e Ieesuꞌ, pareꞌ soe pan, “Varuꞌ rakah vakomanih ne koaꞌ mon peöꞌ to mët en. Köꞌ iu noꞌ a ö nën se nö, parën hariun eah pa koreomah, keꞌ toꞌ hah.” ");
INSERT INTO tpz_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","E Ieesuꞌ me ra ma vamomhë peꞌ to sun, pare nö me ee pe susun va pa iuun hinhin soneꞌ manuh pa iuun peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ee to teꞌ avoeꞌ e ne manih hanan, ka pah köövo to vavahuh voh non o eraꞌ po pöh havun me ro pöök kirismas to huk vatët maꞌ tonun e Ieesuꞌ. Pareꞌ hariun a ö noton in o ohop peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Suk eꞌ to koman aven non manih po kokoman peꞌ pan, “Eöꞌ se keh hariun akuk o ohop peꞌ, ka mët vëh hik këh en peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ke Ieesuꞌ tarih, pareꞌ ep in e köövo pamëh, pareꞌ soe ke poan pan, “Vaeö rakah ah, koaꞌ peöꞌ. Eën to vaman nom neoꞌ, ka mët pën hik këh en pën.” Ka varuꞌ rakah vakomanih no eraꞌ to hikta nönö hah non maꞌ, keꞌ haraꞌ vavih en. ");
INSERT INTO tpz_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","E Ieesuꞌ to nö, pareꞌ tavus en manuh pa iuun pe susun pa iuun hinhin soneꞌ, eꞌ to ho pareꞌ taum en pa napan to vaokook ne. Ko upöm nonok ne a ma taokook. ");
INSERT INTO tpz_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ke Ieesuꞌ soe ke rapoë pan, “Sun öm, ko tavus, e koaꞌ mon vëh to hikta mët. Eꞌ to koroh varoe.” Ivëhkëk, a napan varih to okook ne to vapikpiuk e ne peꞌ, pare vavövöneꞌ suntan ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","E Ieesuꞌ to veo tavus vahik en pa napan, pareꞌ ho en manuh pa ö ne koaꞌ to pet non, pareꞌ öt a koreneah, keꞌ toꞌ hah en. ");
INSERT INTO tpz_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ko vahutët va pa tah ne Ieesuꞌ to nok nö vavah en manih pa koman a ö muhin pamëh. ");
INSERT INTO tpz_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ke Ieesuꞌ këh en pa iuun pamëh, pareꞌ nönö non ka poa teꞌ kehoꞌ suk maꞌ poë, pare taneo ee pa kokoeꞌ suk na poë pan, “Koaꞌ supnaiꞌ pe Devit uruan a möm ah.” ");
INSERT INTO tpz_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","E Ieesuꞌ to nö, pareꞌ ho en pa meh iuun. Ka poa teꞌ kehoꞌ poë varih vatet ho ee peꞌ. Ke Ieesuꞌ hi rapoë pan, “Eöm kës to vaman rakah e nem peöꞌ se kap hah eoꞌ pa ma matëëneöm?” Kee soe, “A, Topoan.” ");
INSERT INTO tpz_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ke Ieesuꞌ vaket en pa poa matëëre, pareꞌ soe ke rapoë pan, “Eöm to vaman em pa ö nöꞌ se nok vavih a neöm, ivëh, köm se ep vamaaka em.” ");
INSERT INTO tpz_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ka poa teꞌ poë varih maaka matan ee. E Ieesuꞌ to vuhvuh rakah en pee pan ee se nat ne hutët a tah vaꞌih to tanok manih pee pon pa ta meh teꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ivëhkëk, ee to këh e Ieesuꞌ, pare taneo ee pa hutët a ma taneah ne Ieesuꞌ to nok manih pa koman a siꞌ ö muhin pamëh. ");
INSERT INTO tpz_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","A poa teꞌ poë varih to këkëh ko ne e Ieesuꞌ ka napan teꞌ ee maꞌ pa meh teꞌ no a oraꞌ hat to vapapön non poan, keꞌ hikta onöt non a to. ");
INSERT INTO tpz_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","E Ieesuꞌ to taꞌ vakis rakah en pa oraꞌ pan, eꞌ se këh tavus a teꞌ pamëh, keꞌ vaato hah. Ka teꞌ papön pamëh taneo hah en pa to. Ka napan pah vatötöhkak ee, pare vasoe ee pan, “Ahik ta pah tah na to ep voh no to teꞌ va non manih Israël.” ");
INSERT INTO tpz_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ivëhkëk, o Parësiꞌ to soe pan, “E susun po oraꞌ hat to heꞌ kikis non sih poan, keꞌ veveo këh non a napan pa ma oraꞌ hat.” ");
INSERT INTO tpz_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ke Ieesuꞌ vavavih vah kov e non pa ma vöön apaꞌpuh me a ma siꞌ vöön sosoneꞌ, pareꞌ vavaasis non a napan pa ma koman iuun hinhin sosoneꞌ pee. Eꞌ to vavaasis non raoe pa Soe Vih va pa Matop Vih pe Sosoenën. Me eꞌ to vavatoꞌ hah non a ma napan varih to teꞌ me ne a ma vu mët me a ma vu kamis manih pa ma sioniire. ");
INSERT INTO tpz_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Eꞌ to ep a napan to peo vörep, pareꞌ pah uruan en pee, suk ataeah, a ma kokoman pee to nun, kee hikta nat ne peteh se vaꞌaus rapoë. Ee to teꞌ va i ne manih po sipsip varih no a hikta teꞌ to matop non rapoë. ");
INSERT INTO tpz_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ke Ieesuꞌ soe ke ra ma vamomhë peꞌ pan, “A napan o pöh peo to vamatop ne a vaman a neoꞌ pa ö söm vaꞌaus raoe. Ivëhkëk, a hikta nap peo pa vatvus ke raoe a Soe Vih. Ee to teꞌ va ne manih pa voaꞌ to vamatop manih koman a rak, ka hikta nap kiu peo pa oes a voaꞌ, ");
INSERT INTO tpz_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ivëh, köm se hinhin nem e Sosoenën, keꞌ se vamatop a ma napan peo, kee vaman a neoꞌ. Eöm se hinhin nem e Sosoenën, keꞌ vanö maꞌ a nap kiu peo manih pa rak.” ");
INSERT INTO tpz_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","E Ieesuꞌ to vaoe ununun en pa havun me ra poa vamomhë peꞌ, kee nö ee maꞌ. Keꞌ heꞌ rapoë a tasun peꞌ, marën a veo këh a napan po oraꞌ hat, me a vavahik a ma vu kamis, me ma vu mët. ");
INSERT INTO tpz_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ivaꞌih a ëhnëëra ma aposol pe Ieesuꞌ. A teꞌ a vamomoaan ivëh, e Saëmon a meh ëhnaneah e Pitaꞌ, ke kea peꞌ Ëndruꞌ. Ke Jëmis pen kea peꞌ Jon, ee a poa sunaiꞌ Sëbëdiꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ke Filip pen Batromioꞌ. Ke Tömas, ke Matiu vëh, a teꞌ kokon takis. Ke Jëmis e sunaiꞌ Apias, ke Tëdius. ");
INSERT INTO tpz_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ke Saëmon, a teꞌ vëh to taneꞌ voh maꞌ po kum nee to popokaꞌ ne Sërat. Ke Jiutas Iskariot, to taneꞌ maꞌ Kariot, eꞌ a teꞌ pamëh se vikuh e Ieesuꞌ manuh pa koreera napan varih to hat ov e ne poë. ");
INSERT INTO tpz_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","E Ieesuꞌ to haraꞌ vanö a havun me ra poa vamomhë peꞌ, pareꞌ soe ke rapoë pan, “Nat nem nö manuh pa napan to hikta teꞌ ne pan ee ro Jiuꞌ. Me pa ma vöön no napan va Samëriaꞌ to teꞌ ne. ");
INSERT INTO tpz_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Eöm se nö manuh pa napan va Israël, suk ee to teꞌ va ne manih po sipsip to ro këh a teꞌ to matop non rapoë. ");
INSERT INTO tpz_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Eöm se nö, ko vavaasis a tah vaꞌih, “A Matop Vih va pa Vöön va Kin to vatët en maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Eöm se nö paröm vavatoꞌ hah o teꞌ varih to haraꞌ ne a ma kamis, ko kunkuin hah o teꞌ mët, kee toꞌtoꞌ hah ee. Paröm vatoꞌ hah o teꞌ varih to teꞌ me ne a mët töpaꞌ manih pa sioniire, ko veo këh o teꞌ po oraꞌ hat. Eöꞌ to heꞌ akuk eoꞌ peöm po kikis vaꞌih, köm se nö ko vaꞌaus akuk o upöm teꞌ. Paröm nat nem hin raoe o voen. ");
INSERT INTO tpz_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Eöm se nat nem teꞌ ta moniꞌ vamanih pa gol, me a silvaꞌ, me a kopaꞌ manih pa ma kove peöm. ");
INSERT INTO tpz_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ko poen nöm to nö, eöm se nat nem teꞌ to kove, me to pöök ohop, me ta suꞌ, me to toknon. Suk ataeah, a teꞌ to kiu vakis non pa vaꞌaus a napan, a, a napan se heꞌ ee peꞌ pa taëën. ");
INSERT INTO tpz_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Pareꞌ soe pet ke rapoë pan, “Eöm se keh vos pa taꞌ vöön apuh, me ta siꞌ vöön soneꞌ. Eöm se inan vavih peteh va pa vöön pamëh no a taateꞌ peꞌ to vih, pareꞌ totoopin. Paröm teꞌ vaꞌpeh me nem eah pa iuun peꞌ, keꞌ antoen po poen nöm se këh a vöön pamëh. ");
INSERT INTO tpz_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Eöm se keh ho pa ta pah iuun, eöm se soe ke ra napan va pa iuun pamëh pan, ‘E Sosoenën se heꞌ a neöm a taateꞌ moomo.’ ");
INSERT INTO tpz_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kee se keh kamöꞌ ee peöm, këh maꞌ o kokoman tö me a soe vih peöm, kee teꞌ me ne. Ivëhkëk, ee se keh rës ee peöm manih pa iuun pee, kon hah këh raoe o kokoman tö me a soe vih peöm. ");
INSERT INTO tpz_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ka manih pa ma meh vöön no a napan se keh hikta vaoe a neöm pa ma iuun pee, pare hikta pënton a ma soe peöm. A, këh maꞌ a iuun me a vöön pamëh paröm susunuh o kusan vëh to teꞌ non pa ma moeeneöm. ");
INSERT INTO tpz_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Eöꞌ to soe vaman rakah keoꞌ peöm. Manih po poen ne Sosoenën se kiiki a taateꞌ hat pa napan varih po oeh, a napan va pa poa vöön varih Södom me Gomoraꞌ neꞌ se vakmis vasoneꞌ en pee. Ivëhkëk a napan va pa vöön pamëh to koe ee pa pënton a soe peöm. Ivëh, ke Sosoenën se vakmis oah en pee.” ");
INSERT INTO tpz_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Pënton öm, eöꞌ to vanö va ka neöm manih po sipsip to teꞌ ne topnin o këh poa. Ivëh, köm se nö, paröm teꞌ vaꞌpeh me nem raoe, paröm vataare raoe a taateꞌ totoopin me a taateꞌ natsean po kuruꞌ. Paröm vatet a taateꞌ po növan varih o panuh, suk ee to hikta nat ne pa miröꞌ a meh teꞌ, ka taateꞌ pee tö. ");
INSERT INTO tpz_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ko matop vavih nem po teꞌ se öt a neöm, pare vahoꞌ ee peöm po vahutët, ko ip ee peöm pa ma koman iuun hinhin soneꞌ pee. ");
INSERT INTO tpz_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ee se öt ee peöm, köm sun em pa matëëro teꞌ apaꞌpuh va pa kaman, me ro teꞌ susunön, suk eöm to vaman, paröm vavatet a nem neoꞌ. Köm soe tavus kem pee, me o teꞌ varih to hikta teꞌ ne pan ee ro Jiuꞌ a Soe Vih pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ee se öt ee peöm, pare vateꞌ ee peöm po vahutët, köm nat nem nanaöp nem raoe pan eöm se soe ke raoe a soe taeah, me eöm se piun raoe pa soe taeah. Manih po poen pamëh, no a Tuvuh Vasioꞌ pe Sosoenën se vataare en peöm pa soe taeah nöm se soe tavus ke raoe. ");
INSERT INTO tpz_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Eꞌ to hikta teꞌ non pan eöm koman ivarih se soe tavus a soe pamëh, ahik, a Tuvuh Vasioꞌ pe Tamëneöm ivëh, se vatvus maꞌ a soe manih pa ma kokoman peöm, köm vatvus pet ke raoe.” ");
INSERT INTO tpz_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“O teꞌ se heꞌ mët ee pa ma kea pee manih pa nap hat, kee ip vamët ee pee. Ka kën taman se nok va ee nën manih pa ma koaꞌ pee. Ka ma koaꞌ pee se hat ke ne pa ma tamëëre me ra ma sinëëre, pare ip vamët ee pee. ");
INSERT INTO tpz_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","A napan kurus se rës ee peöm, suk eöm to vaman, paröm vavatet a nem neoꞌ. Ivëhkëk, a napan varih to teꞌ vakis ne pa teꞌ a ma punis, pare öök na po poen no oeh se hik, e Sosoenën se hehe en pee. ");
INSERT INTO tpz_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Eöm se keh tahinën manih pa koman vöön pamëh, këh a vöön pamëh, paröm nö em pa ta meh vöön. Eöꞌ to soe vaman rakah keoꞌ peöm, eöm se meꞌ avoeꞌ e nem pa vahik a kiu peöm manih pa ma vöön va Israël, eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus he nö eoꞌ maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“E koaꞌ va pa siku to hikta antoen non a teꞌ oah e tövavaasis peꞌ. Ka teꞌ kikiu me to hikta antoen non a teꞌ oah e susun peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","E koaꞌ va pa siku se keh iu non a ö no a taateꞌ peꞌ se vatoe me non e tövavaasis peꞌ, eꞌ to vih e non. Ka teꞌ kikiu se keh iu non a ö no a taateꞌ peꞌ se vatoe me non e susun peꞌ, eꞌ to vih e non. Ivëh, ke eöꞌ a teꞌ to vovoh noꞌ po vuteꞌ se keh kon o ëhnan vëh Belsebu, a, o vuteꞌ avoes peöꞌ se kon ee pa ma ëhnan to teꞌ hat oah e ne po ëhnan pamëh.” ");
INSERT INTO tpz_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","E Ieesuꞌ to vavaato avoeꞌ e non pareꞌ soe pan, “Eöm se koe a naöp o teꞌ varih to kehkeh miröꞌ a ne neöm. Suk ataeah, a ma kokoman vakoaan va pa miröꞌ a neöm amot se teraꞌ ee, ka napan nat vahik ee pee.” ");
INSERT INTO tpz_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ka soe nöꞌ to sosoe aven ka noꞌ neöm, amot nöm se soe tavus eah pa matëëra napan. Ka soe nöꞌ to vavisvis ka noꞌ neöm, amot nöm se sun, ko vatvus eah pa napan. ");
INSERT INTO tpz_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Eöm se nat nem nanaöp nem o teꞌ varih se ip vamët a ma sionineöm, suk ee to hikta antoen ne a ip vamët a ma apeneöm. Eꞌ to teꞌ ro non a pah teꞌ vëh e Sosoenën nöm se nanaöp nem eah, suk eꞌ se miröꞌ en pa ma apeneöm me a ma sionineöm manih po suraꞌ ësës tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Eöm to nat e nem po növan sosoneꞌ to hikta voen vapeah ne. O voen pee to parin kunah, köm se voen em pa poa növan pa paeh a toeaꞌ ro. Ivëhkëk, a hikta paeh va po siꞌ növan poë varih se mët, e Tamëneöm vöh pa vöön va kin to koman e non pee. ");
INSERT INTO tpz_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Me eꞌ to ëh vahik voh en pa ma paꞌ uvin kurus neöm. ");
INSERT INTO tpz_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ivëh, köm se nat nem nanaöp nem pataeah no a ma napan se nok amot manih peöm, suk eöm to teꞌ oah rakah e nem po siꞌ növan sosoneꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","E Ieesuꞌ to vavaato avoeꞌ e non pareꞌ soe pan, “Ta pah teꞌ se keh vaman a no neoꞌ, ko vatvus a ëhnaneoꞌ manih pa matëëra ma napan, a, eöꞌ me se vatvus eoꞌ pa ëhnan a teꞌ pamëh manih pa matan e Tamön vöh pa vöön va kin. ");
INSERT INTO tpz_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ivëhkëk, a teꞌ se keh vonih en pan eꞌ to hikta nat a no neoꞌ pa matëëra ma napan, a, eöꞌ me se vonih eoꞌ peꞌ pan eöꞌ to hikta nat noꞌ peꞌ manih pa matan e Tamön vöh pa vöön va kin.” ");
INSERT INTO tpz_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","E Ieesuꞌ to vavaato avoeꞌ e non pareꞌ soe pan, “Eöm se nat nem koman nem pan eöꞌ to nö voh maꞌ pa vahik a ma vapus va po oeh vëh. Me eöꞌ to hikta nö voh maꞌ pa vahik a ma vaato vasukaꞌ, ahik, eöꞌ to teꞌ varoe maꞌ o rapis rë. ");
INSERT INTO tpz_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Eöꞌ to nö maꞌ to vateeraꞌ a taateꞌ va pa vakihat. E koaꞌ oeteꞌ se rës en pe tamaneah, suk e tamaneah to vaman en peöꞌ, ke koaꞌ mon se rës en pe sinaneah, suk eꞌ me to vaman en peöꞌ. e köövo muvaen se rës en pe köövo töveneah, suk e köövo töveneah to vaman en peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","O vuteꞌ pe voe se tarih, pare vahat koman hah me e ne peꞌ, suk e voe pamëh to vaman en peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“O teꞌ varih to iu oah ne a ma tamëëre, me a ma sinëëre, pare hikta iu vi a ne neoꞌ, ee to hikta onöt ne a tavus a ma vamomhë peöꞌ. Ko teꞌ varih to iu oah ne a ma koaꞌ oeteꞌ pee, me ra ma koaꞌ mon pee, pare hikta iu vi a ne neoꞌ, ee to hikta onöt ne a tavus a ma vamomhë peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Me a teꞌ vëh to hikta koman non a mët vaꞌpeh me a neoꞌ pa kuruse, eꞌ me to hikta onöt non a tavus a vamomhë peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ko teꞌ varih se keh matop tamoaan ne o toꞌtoꞌ pee, pare hikta vavatet a ne neoꞌ, o toꞌtoꞌ pee se ro amot ee. Ko teꞌ varih se keh koman a ne neoꞌ, pare mët suk a neoꞌ, a, amot ee se kon ee po toꞌtoꞌ tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","E Ieesuꞌ to toto avoeꞌ e non pareꞌ soe pan, “O teꞌ varih to öt a neöm pare vih ka neöm, ee to öt me ee peöꞌ. Me eteh to öt a neoꞌ, eꞌ to öt me en pe Sosoenën vëh to vanö voh a maꞌ neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","E Sosoenën se heꞌ vaeö en peteh to me a teꞌ vanënën soe ko matop non poan pa iuun peꞌ. Eꞌ se heꞌ en peꞌ po vaeö to vatoe me non po vaeö no a teꞌ vanënën soe to teꞌ me non. Eën se keh me a teꞌ no a taateꞌ peꞌ to totoopin manuh pa iuun pën, ko matop i nom eah, suk eꞌ a teꞌ to teꞌ me non a taateꞌ totoopin, e Sosoenën se heꞌ vaeö en pën pa ö neꞌ to heꞌ vaeö va in a teꞌ pamëh. ");
INSERT INTO tpz_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Eöꞌ to soe vaman rakah keoꞌ peöm, eteh to koman non a vaꞌaus a ma vamomhë peöꞌ, me o upöm teꞌ to vaman a no neoꞌ, pareꞌ heꞌ raoe a ruiꞌ tuvuh. A teꞌ pamëh ne Sosoenën se heꞌ en peꞌ po voen vëh to hikta antoen non a hik.” ");
INSERT INTO tpz_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","E Ieesuꞌ to soe vahik ken pa havun me ra poa vamomhë peꞌ pa soe neꞌ to vavaasis non rapoë. Pareꞌ këh en pa ö neꞌ to teꞌ non, ko nö en pa ma vöön va pa muhin va Galiliꞌ pa vavaasis me a vatvus a soe vih peꞌ manih pa ma napan. ");
INSERT INTO tpz_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Manih po poen pamëh ne Jon Tövapupui to teꞌ avoeꞌ e non pa nohnoh, pareꞌ tënan na a soe va pa ma kiu ne Ieesuꞌ to nonok non, eꞌ to vanö en pa ma pah vamomhë peꞌ manuh pe Ieesuꞌ. Kee hi poë pan. ");
INSERT INTO tpz_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Eën pöꞌ kove vëh a teꞌ to se voh nö maꞌ, keꞌ, emöm se anoeh nem ta meh teꞌ eh?” ");
INSERT INTO tpz_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ke Ieesuꞌ piun a soe pee, pareꞌ soe ke rapoë pan, “Eöm pom se nö hah na manuh pe Jon, paröm soe vanat eah a ma taneah nöm to pënton, paröm ep in. ");
INSERT INTO tpz_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Eöm se soe vanat eah pan, ‘O teꞌ kekehoꞌ to opoep hah ee. Me o teꞌ varih o hathat ma moe to nö vavavih hah ee. Ko teꞌ varih to teꞌ me ne a mët töpaꞌ, a ma sioniire to voon hah ee. Ko teꞌ papön tenë, tëtënan vavih hah ee. Ko teꞌ mët, toꞌtoꞌ hah ee, ko teꞌ arus pënton ee pa Soe Vih pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ko teꞌ varih to vaman a ne neoꞌ, me pa ma tah nöꞌ to nonok noꞌ, ee se nat ne haraꞌ vahat ne, ee se vaeö, suk e Sosoenën se tapui en pee.’” ");
INSERT INTO tpz_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","A ma vamomhë pe Jon Tövapupui to nönö hah ko ne, ke Ieesuꞌ taneo en pa vahutët ke ra napan a ma taateꞌ pe Jon. Pareꞌ soe rapoë pan, “Eöm nö voh nös pa moeh upin pa ep ataeah? A mëto no a tuvuh to taata non, ha? ");
INSERT INTO tpz_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Keꞌ, eöm to nö voh nös ko ep in pa ta teꞌ to ohop non o ohop matan vavih ih? Ahik. A napan to ohop ne a ma ohop ep vavih to teꞌ ne sih pa iuun pa teꞌ sunön. ");
INSERT INTO tpz_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Keꞌ, eöm nö poꞌ voh nös pa ep in ataeah, eöm to nö pöꞌ voh nös pa ep a teꞌ vanënën soe, ha? A, eöꞌ to soe vaman rakah keoꞌ peöm, a teꞌ vanënën soe vëh e Jon, no a tasun peꞌ to apuh oah e non pa ma teꞌ tasun po upöm teꞌ vanënën soe. ");
INSERT INTO tpz_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ke Jon ko pamëh no a soe to takiun suk voh manih po Puk pe Sosoenën to soe non pan, “Pënton ah, eöꞌ se vanö nös a teꞌ vëh se teꞌ vovoh nös a soe peöꞌ manem pën, eꞌ se vovoh ka oah, pareꞌ vamatop a hanan pën.” “Manih pa moeh upin no a pah teꞌ to vavaoe no maꞌ pan, ‘Vamatop öm a hanan pe Sunön, paröm vatotoopin a ma hanan peꞌ.’” ");
INSERT INTO tpz_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Eöꞌ to soe vaman rakah keoꞌ peöm, e Jon Tövapupui no tasun peꞌ to teꞌ oah e non pa ma teꞌ tasun po upöm teꞌ manih po oeh. Ivëhkëk, a teꞌ to teꞌ va non manih pa siꞌ koaꞌ soneꞌ manih pa Matop Vih va pa Vöön va Kin no a tasun peꞌ to apuh oah e non pa teꞌ tasun pe Jon. ");
INSERT INTO tpz_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Taneo non maꞌ po poen ne Jon to vavatvus non a soe peꞌ, pareꞌ öök non maꞌ manih kuru, a nap peo rakah to kehkeh hop ne manih pa Matop Vih va pa Vöön va Kin, vamanih pa napan to totoon ne o hopaꞌ to hop manih pa Matop Vih va pa Vöön va Kin. ");
INSERT INTO tpz_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","O Vavaasis po Teꞌ Vanënën Soe, me o teꞌ Vavaasis pe Mosës to vavatvus voh i ne a soe pe Sosoenën keꞌ öök maꞌ po poen ne sinan e Jon to vahuh poan. ");
INSERT INTO tpz_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Eöm se iu pënton nem a soe, eöm se pënton. O Puk pe Sosoenën to soe non pan a teꞌ vanënën soe vëh e Elaëjaꞌ se nö maꞌ. O puk pamëh to hikta sosoe voh non pan e Elaëjaꞌ koman ivëh se nö maꞌ, ahik, eꞌ to sosoe suk voh non e Jon vëh to nö voh en maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Eöm o teꞌ varih to teꞌ me nem a tenëneöm, eöm se pënton a soe vaꞌih! ");
INSERT INTO tpz_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Köꞌ se poꞌ vëknöm vah va in a taateꞌ pa napan vakuru nih, eöꞌ se nok ataeah to vëknöm non rapoë? Ee to teꞌ hutët e ne po siꞌ koaꞌ varih o pëpënton varo, to ihoꞌ ne pa ma ö totoaan, pare vavaasis piu ne, ivëhkëk, o meoh upöm pee to hikta vaëhëh ne. Kee varek ke raoe, pare soe pan, ");
INSERT INTO tpz_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Emöm to piu kem peöm po piu, ivëhkëk, eöm to hikta pinoꞌ. Kemöm vaëhëh kem peöm pa tah okook vatamak, ivëhkëk, eöm to hikta tamak to ook.’” ");
INSERT INTO tpz_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","E Ieesuꞌ to toto avoeꞌ e non, pareꞌ soe pan, “E Jon Tövapupui to nö voh maꞌ, pareꞌ hikta ënëën vörep non, ko hikta kakaak voaën non, vamanih po upöm teꞌ. Ivëhkëk, o upöm teꞌ to sosoe ne pan, ‘A oraꞌ hat to teꞌ non manih peꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus to nö voh maꞌ, paröꞌ ënëën e noꞌ, ko kakaak e noꞌ. Ka napan soe ee pan, ‘Ep këk öm pa teꞌ vëh, eꞌ a pah ënëën vörep, pareꞌ kakaak voaën suntan. Ke eꞌ e vamomhë pa nap kokon takis, me ra napan va pa nok a ma taateꞌ hat.’ Ivëhkëk, a napan to vavatet ne o nat vih pe Sosoenën, eꞌe to vataare e ne pa taateꞌ vih, eꞌ o nat vih rakah, suk eꞌe to vaman ne e Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe vakis rakah ken pee pan, “Varenan rakah pa napan va pa ma vöön apaꞌpuh varih nöꞌ to nok a ma tah vatoksean peo nën. Suk ataeah, ee to hikta panih voh a ma kokoman pee, pare vahik a nok vatëh a ma taateꞌ hat. ");
INSERT INTO tpz_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Varenan rakah peöm a napan va pa poa vöön varih Korasin, me Bëtsaëtaꞌ. A ma tah vatoksean varih nöꞌ to nok voh topniineöm se keh tanok voh pa napan va pa poa vöön varih Taëaꞌ, me Saëdon, a, a napan poë varih se voh panih vahik voh ee pa ma taateꞌ hat pee. Ee se voh ohop a ma ohop tatasi, pare vauh o ö to vataare non a ö nee to tamak ne a ma taateꞌ hat pee. Ivëhkëk, ee hikta panih a ma taateꞌ hat pee. ");
INSERT INTO tpz_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Eöꞌ to soe vaman rakah keoꞌ peöm, amot po poen ne Sosoenën se kiiki non a ma napan, a punis va Saëdon, me Taëaꞌ hikta se teꞌ apuh va non manih pa teꞌ punis vëh nöm se taum, suk eöm to ep voh em pa ma vëknöm nöꞌ to nonok voh noꞌ topniineöm, ivëhkëk, eöm to hikta panih, ko vaman. ");
INSERT INTO tpz_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ke eöm varih a napan va pa vöön vëh Kapaneam! Eöm se nat nem koman nem pan, e Sosoenën se ta a no neöm, suk eöm to ep voh e nem peöꞌ, ko pënton voh e nem peöꞌ. Ivëhpëhkëk, eꞌ se vi a neöm po suraꞌ ësës tamoaan. Suk a ma tah vatoksean varih nöꞌ to nok voh topniineöm se keh tanok voh manih Södom, a napan va pa vöön pamëh to hikta se nonok vatëh ne a ma taateꞌ hat. Ka kuru vaꞌih no a vöön pamëh se teꞌ non a vöön apuh rakah. ");
INSERT INTO tpz_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ivëhkëk, eöꞌ to soe keoꞌ peöm, manih po poen no a napan se tavus manih po vahutët apuh pe Sosoenën, a punis vëh to tavus voh manih pa vöön vëh Södom, to hikta teꞌ apuh va non manih pa teꞌ punis vëh nöm se taum.” ");
INSERT INTO tpz_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Manih po poen pamëh ne Ieesuꞌ to soe pan, “Tamön, eën e Sunön va pa vöön va kin me po oeh! Eöꞌ to vaeö rakah me nös oah, suk eën to koaan voh a ma tah varih manih pa nap natnat, me a nap natsean va po oeh. Ivëhkëk, eën to vataare eom peꞌ po teꞌ to teꞌ va ne manih po siꞌ koaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tamön, a ta vaꞌih to tanok, to suk e non po iu me o manin koman pën.” ");
INSERT INTO tpz_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","E Ieesuꞌ to hin vahik en, pareꞌ tarih maꞌ manih pa napan varih to pënton ne poë, pareꞌ soe pan, “E Tamön to heꞌ voh en peöꞌ pa ma moeh tah kurus. Ka hikta teꞌ to nat non pe Koaꞌ, e Taman varoe to nat non. Me a hikta teꞌ to nat non pe Tamön, e Koaꞌ varoe, me ro teꞌ varih ne Koaꞌ to iu vataare non raoe e Tamön, eꞌe me to nat e ne pe Tamön.” ");
INSERT INTO tpz_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Eöm varih a napan to kamis rakah nem sih pa teꞌ a ma vu punis, eöm se nö maꞌ peöꞌ, köꞌ sih heꞌ a neöm o vanot. ");
INSERT INTO tpz_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Öt öm o vavaasis peöꞌ, paröm kon o nat peöꞌ, suk eöꞌ a teꞌ kamöꞌ, paröꞌ teꞌ noꞌ paan a Tuvuh Vasioꞌ. Suk ataeah, eöꞌ to vöknah noꞌ sih o iu peöꞌ, ko hikta se heꞌ punis a noꞌ neöm, köm taum em po vanot. ");
INSERT INTO tpz_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ko vavaasis nöꞌ to heꞌ a neöm, eꞌ o tö rakah pa kon, ka teen nöꞌ to heꞌ a neöm, nöm se teꞌ, to parin are rakah.” ");
INSERT INTO tpz_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Keꞌ hikta teꞌ rë non, vasuksuk in a ö ne Ieesuꞌ to kömköm varuꞌ non a napan va Kapaneam. Manih po pöh Poen Apaapo eꞌ me a ma vamomhë peꞌ to nönö vah ne pa koman a rak vëh nee to nep voh a kon. Ka ma vamomhë peꞌ maë, pare kökök a ma voaꞌ kon, ko ëën ee. ");
INSERT INTO tpz_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ko Parësiꞌ ep in a tah vaꞌih no vamomhë pe Ieesuꞌ to nonok ne, pare soe va ee manih pan o vamomhë peꞌ to nok ee pa hat, suk o vaman pee to soepip i non pa öt taëën koman o Poen Apaapo, pare soe ke Ieesuꞌ pan, “Ieesuꞌ, a ma vamomhë pën to nonok e ne pa taateꞌ vëh to vapenpen e non pa nok vamanih po Poen Apaapo.” ");
INSERT INTO tpz_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ke Ieesuꞌ piun a soe pee pareꞌ soe pan, “Eöm hikta ëh pöꞌ voh pa soe va pataeah ne Devit to nok voh me ra ma vamomhë peꞌ to teꞌ vaꞌpeh me ne poë manih pa ö nee to maë voh, ha? ");
INSERT INTO tpz_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","E Devit me ra ma vamomhë peꞌ to ho voh pa koman a iuun vapenpen pe Sosoenën, pare ëën ee pa taëën vëh to supon non pa teꞌ akuk se ëën. O teꞌ ësës heꞌ varoe to soe vaonöt ne pa ëën a taëën pamëh. ");
INSERT INTO tpz_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Me eöm to ëh pöꞌ voh em pa soe to kiun non manih po Puk va po Vavaasis pe Mosës to soe non pan, manih po Poen Apaapo o teꞌ ësës heꞌ pee to teꞌ ne koman Iuun Hinhin Apuh, ee me to kök ee pa taateꞌ va po Poen Apaapo. Ivëhkëk, o teꞌ ësës heꞌ to hikta nok a hat pa ö nee to nonok ne a kiu pee. ");
INSERT INTO tpz_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Eöꞌ to soe vaman rakah keoꞌ peöm, a teꞌ to teꞌ non manih to apuh oah e non pa Iuun Hinhin Apuh. ");
INSERT INTO tpz_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","O Puk Vapenpen to soe non pan, ‘Eöꞌ to iu oah noꞌ a taateꞌ iu teꞌ. Eꞌ a taateꞌ pamëh to apuh oah non a ö nöm to ip a vönaꞌ paröm ës ke na e Sosoenën.’ Eöm to hikta nat vavih nem pa ö no a soe pamëh to soe va non. Eöm se keh nat vavih nem pa pusun in a soe pamëh, eöm hikta se kiiki nem a taateꞌ pa ma vamomhë peöꞌ, suk ee to hikta nok voh ta taateꞌ hat. ");
INSERT INTO tpz_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Suk ataeah, eöꞌ koman e Koaꞌ Teꞌ Pa Napan Kurus to Sunön ke noꞌ po Poen Apaapo.” ");
INSERT INTO tpz_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","E Ieesuꞌ to këh en pa rak vëh neꞌ to teꞌ non, pareꞌ nö ko vos en vöön, pareꞌ ho en pa siꞌ iuun hinhin soneꞌ va pa vöön pamëh. ");
INSERT INTO tpz_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Manih pa koman iuun hinhin soneꞌ pamëh no a pah teꞌ tënkun koren to teꞌ non nën. Ko upöm teꞌ to teꞌ ne koman iuun, to kehkeh ep këh ne ta hanan nee se öt koe e Ieesuꞌ, ivëh nee to hi suk poë pan, “Eꞌ vih kës e non pea pa vatoꞌ hah ta pah teꞌ to haraꞌ non a mët po Poen Apaapo, keꞌ ahik?” ");
INSERT INTO tpz_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ke Ieesuꞌ piun ko soe pan, “Ta paeh va peöm se keh teꞌ me non ta pah sipsip, ka sipsip pamëh vuꞌ hop pa koman a koveꞌ ruruvun po Poen Apaapo. E tövaneah antoen kës e non pa rëh peah hah a sipsip peꞌ po poen pamëh, keꞌ a hik? ");
INSERT INTO tpz_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Eöꞌ to soe vaman rakah keoꞌ peöm, a teꞌ to apuh oah e non pa sipsip! Ivëh, ka taateꞌ pea to vaonöt e non pea pa vaꞌaus a meh teꞌ po Poen Apaapo.” ");
INSERT INTO tpz_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ke Ieesuꞌ soe ken pa teꞌ tënkun koren pamëh pan, “Putot a koreomah.” Ke voe pamëh putot en pa koreneah, keꞌ totoopin, ko matan hah va en manih pa meh pap koren. ");
INSERT INTO tpz_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ko Parësiꞌ këh ee peꞌ, pare tönun ee, ko vavaiu vah këh e ne ta hanan nee se ip vamët koe in e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","E Ieesuꞌ to pënton en pa ö no Parësiꞌ to iu ip vamët ne poë, pareꞌ këh en pa vöön neꞌ to teꞌ non. Ka nap peo suk ee peꞌ keꞌ vavatoꞌ en po teꞌ kurus varih to haraꞌ ne a ma vu mët. ");
INSERT INTO tpz_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ke Ieesuꞌ vuhvuh en pee, pan ee se nat ne vatvus vateeraꞌ a ëhnaneah manih po upöm teꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Eꞌ to vatvus voh a soe pamëh marën a vapuh a soe ne Sosoenën to vatvus voh manih pa rivon a teꞌ vanënën soe peꞌ, Aisaëaꞌ. Ka soe pamëh to soe suk non a ma taateꞌ, me a kiu pe Ieesuꞌ, ");
INSERT INTO tpz_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ivaꞌih a teꞌ kikiu peöꞌ, eöꞌ to kon voh eah. Paröꞌ iu suntan rakah e noꞌ peꞌ. Ko kokoman peöꞌ vaeö rakah noꞌ poan. Paröꞌ vahoꞌ a Tuvuh Vasioꞌ peöꞌ manih peꞌ. Keꞌ se soe vatvus a soe vih va pa taateꞌ totoopin, me eꞌ se kiiki a ma taateꞌ pa napan kurus manih po oeh. Eꞌ se kiiki vatoe a ma taateꞌ pa napan varih to hikta teꞌ ne pan ee ro Jiuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ke eꞌ koman to hikta nat non pa to vasukaꞌ, pareꞌ hikta kë koman hah non a ëhnaneah. ");
INSERT INTO tpz_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Me eꞌ to hikta antoen non a miröꞌ o upöm teꞌ varih no vaman pee to hikta teꞌ kikis non. Eꞌ se kikiu vëhvaꞌ non keꞌ onöt pa ö neꞌ se vöknah a taateꞌ hat manih pa taateꞌ vih. ");
INSERT INTO tpz_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ka napan varih to hikta teꞌ ne ro Jiuꞌ se vaman poë, pare anoeh ne poë, se vaꞌaus rapoë.” ");
INSERT INTO tpz_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ka napan teꞌ ee maꞌ pa teꞌ kehoꞌ manih pe Ieesuꞌ. A teꞌ pamëh to hikta antoen non a ep a meh teꞌ, pareꞌ hikta onöt non a to. Suk ataeah a oraꞌ hat to vapapön e non peꞌ. Ke Ieesuꞌ veo këh en peꞌ pa oraꞌ hat, ka teꞌ papön pamëh toto hah en, pareꞌ opoep hah en. ");
INSERT INTO tpz_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","A napan kurus to töhkak, pare vaiihi koman e ne pan, “E Koaꞌ ko vëh eꞌ e Koaꞌ supnaiꞌ pe Devit, ha?” ");
INSERT INTO tpz_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","O Parësiꞌ to pënton a soe vaꞌih pare soe pan, “A teꞌ vëh to veveo këh non a napan po oraꞌ hat manih po kikis pe Belsebu, e susun pa ma oraꞌ hat.” ");
INSERT INTO tpz_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ke Ieesuꞌ nat en pa ma taneah no Parësiꞌ to koman ne manih peꞌ, ivëh neꞌ to soe suk va i rapoë manih pan, “A napan va pa pah muhin to teꞌ ne paan a matop pa paeh susun se keh taki vakëh, ko nok o pöök vuteꞌ, pare vapus koman hah, a, a muhin pamëh to hat rakah en. Eꞌ to vatoe me e non pa napan va pa pah vöön apuh, keꞌ o pöh vutom taman se keh taki vakëh, pare vapus koman hah, a vöön apuh pamëh, keꞌ o vutom taman pamëh hikta onöt rakah ne a teꞌ vakis. ");
INSERT INTO tpz_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Keꞌ teꞌ akuk va kov e non manih, pe susun po oraꞌ hat se keh veo o oraꞌ hat, ka nat ee po vakum pee se taki koman hah en. Ka matop peꞌ se poꞌ teꞌ vaeh vah va non nih? ");
INSERT INTO tpz_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Eöꞌ se keh veveo e noꞌ po oraꞌ hat po kikis pe Belsebu, keteh poꞌ to vavaꞌaus voh non a ma vamomhë peöm, kee veveo këh ne a napan po oraꞌ hat? Ivëh, ko vamomhë koman peöm to vataare ee pan a soe peöm to hikta teꞌ man non. ");
INSERT INTO tpz_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ivëhkëk, a Tuvuh Vasioꞌ pe Sosoenën se keh vaꞌaus a non neoꞌ, köꞌ veveo këh noꞌ a napan po oraꞌ hat, eꞌ to vataare e non pan a Matop Vih pe Sosoenën to teꞌ topnin e non peöm.” ");
INSERT INTO tpz_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","E Ieesuꞌ to toto avoeꞌ e non, pareꞌ soe suk e susun po oraꞌ hat, pareꞌ soe pan, “Ta pah teꞌ se kehkeh ho akuk manuh pa iuun pa teꞌ söë, pareꞌ kokon a ma tah peꞌ, eꞌ se këk nohnoh vavih momoaan a teꞌ söë po uris, pareꞌ pah kokon poꞌ a ma tah kurus va pa koman iuun peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“A teꞌ to hikta teꞌ non e vakamöꞌ peöꞌ, eꞌ e tövakihat peöꞌ. Ka teꞌ to hikta vaꞌaus a no neoꞌ pa ununun maꞌ a napan manih pe Sosoenën, eꞌ to veveo e non pa napan këh e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ivëh, nöꞌ to soe suk va ka neöm manih pan, e Sosoenën se ihan anoe en pa ma taateꞌ hat, me a ma soe viivi varih no a napan to nonok ne sih. Ivëhkëk, o teꞌ varih to soe viivi a Tuvuh Vasioꞌ ne Sosoenën hikta se ihan anoe non a hat pee. ");
INSERT INTO tpz_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Eteh to soe viivi a neoꞌ e Koaꞌ Teꞌ Pa Napan Kurus, e Sosoenën se ihan anoe en pa hat pa teꞌ pamëh. Ivëhkëk, a teꞌ vëh to soe viivi a Tuvuh Vasioꞌ, e Sosoenën hikta se a ihan anoe non a hat peꞌ kuru me amot.” ");
INSERT INTO tpz_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ea se keh iu no a voaꞌ vih, ea se matop vavih no o naon, ea se keh hikta matop vavih no o naon, eꞌ se voaꞌ vahat en, a napan to natnat koe ne sih o naon vih, keꞌ o naon hat manih po voaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","35","Eöm varih o Parësiꞌ, eöm o hat rakah, paröm teꞌ va e nem manih po kuruꞌ hat. Eöm se poꞌ soe vah va in ta soe vih nih? O teꞌ vihvih to teꞌ me ne a ma kokoman vih manih pa ma komëëre. Ivëh, nee to vavatvus suk ne sih a ma soe vih. Ivëhkëk, o teꞌ varih to teꞌ vatëh me ne a ma kokoman hat a taateꞌ hat to puh rakah non manih pa ma komëëre. Ivëh, nee to vavatvus suk ne sih a ma soe hat. Suk a rivon a teꞌ to vavatvus non sih a ma taneah to teꞌ ne manih pa komaneah.” ");
INSERT INTO tpz_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Eöꞌ to soe rakah keoꞌ peöm, manih po poen no a napan kurus se sun manih po vahutët pe Sosoenën, eꞌ se uhioꞌ vataare hah ken pea pa ma to pinpiun, na to tooto voh i no. ");
INSERT INTO tpz_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","A soe koman pën nën to soe voh, eꞌ ivëh se vahoꞌ a oah po vahutët, ko vataare a oah eën a teꞌ vih, keꞌ, eën a teꞌ hat.” ");
INSERT INTO tpz_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ivëhkëk, o teꞌ vavaasis varih to nat i ne o Vavaasis pe Mosës, me a ma to Parësiꞌ a pap teꞌ varih to vavatet vakis ne sih a taateꞌ pa kën sipun to nö maꞌ manih pe Ieesuꞌ, pare soe pan, “Topoan emöm to iu ep nem oah se nok ta pah tah vatoksean to vataare a no möm pan eën a teꞌ ne Sosoenën to vanö maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ke Ieesuꞌ piun a hi pee pareꞌ soe pan, “Eöm, a napan va kuru, eöm a napan o hat. Paröm heꞌ tonun in e Sosoenën. Eöm to iu ep nem a tah vatoksean. Ivëhkëk, eöꞌ hikta se vataare a noꞌ neöm. Eöꞌ se vataare varoe a neöm a tah vatoksean vëh to tavus voh manih pa teꞌ vanënën soe vëh e Jonaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","E Jonaꞌ to teꞌ voh o kukön potan me ro kukön poen manih pa koman a iian apuh. Eꞌ to teꞌ akuk va kov e non manih pa ö ne eöꞌ e Koaꞌ Teꞌ pa Napan Kurus se teꞌ noꞌ po kukön potan me a kukön poen manih pa koman a koveꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Ka manih po poen ne Sosoenën se vateꞌ a napan po vahutët, a napan va Ninivëꞌ se sun me a neöm a ma napan va kuru, pare vatvus a ma taateꞌ hat peöm. Suk a napan va Ninivëꞌ to tënan voh a soe ne Jonaꞌ to vatvus voh, ko panih ee pa ma taateꞌ hat pee. Ka kuru no a teꞌ to teꞌ apuh oah non e Jonaꞌ to teꞌ non topniineöm. Ivëhkëk, eöm to rës e nem pa pënton a soe peꞌ, ko panih a ma taateꞌ hat peöm. ");
INSERT INTO tpz_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Manih po poen va po vahutët ne Köövo Sunön va Saöt se sun vaꞌpeh me a neöm kurus, pareꞌ vavatët vahik en pa ma taateꞌ hat pa napan va kuru. Suk ataeah, e Köövo Sunön pamëh to taneꞌ varo rakah en maꞌ, pareꞌ nö maꞌ pa pënton o nat vih no a teꞌ sunön vëh e Solomon to vavatvus non. Ivëhkëk, a pah teꞌ to teꞌ non manih kuru to teꞌ apuh oah e non pe Solomon, nöm to pëpënton varo rakah e nem pa ma teꞌ soe peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","45","E Ieesuꞌ to tooto avoeꞌ e non pareꞌ nok a soe vapipinoꞌ to sosoe suk non a napan va Israël to teꞌ va ne manih pa teꞌ no a oraꞌ hat to teꞌ non manih peꞌ, pareꞌ soe pan, “A oraꞌ hat to teꞌ non manih pa pah teꞌ. Ka oraꞌ hat pamëh se keh këh tavus a teꞌ pamëh, eꞌ se nö, ko nönö vah no maꞌ pa moeh upin to vavaiu vah këh non ta ö vavanot. Ivëhkëk, eꞌ to hikta taum ta ö to vih non neꞌ se vanot. Ka oraꞌ hat pamëh soe en pan, ‘Eöꞌ se nö hah eoꞌ manuh pa iuun moaan voh peöꞌ.’ Ko poen neꞌ to hah maꞌ, eꞌ to taum en pa iuun to teꞌ upin avoeꞌ e non, nee to veveo tavus voh a noꞌ, keꞌ maaka, pare vatotoopin a ma tah. Ivëh keꞌ nö hah, ko me en maꞌ pa meh tönim me a poa oraꞌ hat to teꞌ hat oah rakah e ne peꞌ pa nok a taateꞌ hat. Kee nö maꞌ, ko ho ee pa koman iuun pamëh. Moaan voh no a taateꞌ pa teꞌ pamëh to teꞌ hat vatam voh e non, ivëhkëk, kuru no a taateꞌ peꞌ to pah hat oah rakah en. Eꞌ se vatoe me non pa napan nonok hat to teꞌ ne manih po oeh kuru.” ");
INSERT INTO tpz_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","E Ieesuꞌ to vavaato avoeꞌ me e non pa napan ke sinaneah me ra ma kea peꞌ, nö ee maꞌ. Ee to sun e ne maꞌ manuh mahën. Pare iu vaato me ne poë. ");
INSERT INTO tpz_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ka pah teꞌ nö, pareꞌ soe ke Ieesuꞌ pan, “E sinömah, me ra kën kea pën to teꞌ ne mahën, ee to iu vaato me ne oah.” ");
INSERT INTO tpz_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ivëhkëk, e Ieesuꞌ to piun a soe pa teꞌ pamëh pareꞌ soe pan, “Eteh e sinaneoꞌ, me eteh e kea peöꞌ?” ");
INSERT INTO tpz_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Eꞌ to huh na a ma vamomhë peꞌ pareꞌ soe pan, “Eöm ep e nem eh, o teꞌ varih, eꞌe to teꞌ va ne manih pe sinaneoꞌ, me a ma kea peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","A kën kea, me ra kën vamen, me e sinan vamaman peöꞌ, ivarih, o teꞌ to nonok ne a ma tah ne Tamön vöh pa vöön va kin to iu non sih.” ");
INSERT INTO tpz_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Manih pa potan avoeꞌ pamëh ne Ieesuꞌ to këh tavus en maꞌ pa iuun neꞌ to teꞌ non, pareꞌ nö ko ihoꞌ en sinten a tonon ko vavaasis en pa napan. ");
INSERT INTO tpz_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ka napan o pöh peo to tönun maꞌ pa havineah. Ivëh, keꞌ peah en po paröꞌ, pareꞌ ihoꞌ non nën. Ka napan teꞌ ne sinten tonon. ");
INSERT INTO tpz_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ke Ieesuꞌ vahoꞌ a ma tah peo pa soe peꞌ manih pa soe vapipinoꞌ, marën a vavaasis a napan. Eꞌ to soe ke rapoë pan, “A teꞌ poꞌpoꞌ kon to nö pa rak peꞌ, pareꞌ poꞌpoꞌ a kon peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Eꞌ to poꞌpoꞌ nö non a kon, ka ma meh voaꞌ kon vuꞌ ee manih po vaꞌpet taan, ko növan nö maꞌ, pare ëën vahik ee pee. ");
INSERT INTO tpz_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ka ma upöm voaꞌ vuꞌ ee manih pa moeh vösvös, pare pisiꞌ vëvëhöꞌ ee maꞌ, suk ataeah, o oeh to hikta teꞌ ru non, ivëh, nee to pisiꞌ ohoꞌ suk maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ivëhkëk, a potan to peah maꞌ, pareꞌ pa varak hah en pee, suk ee to hikta teꞌ aan vakis ne. ");
INSERT INTO tpz_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ka ma upöm voaꞌ kon vuꞌ ee manih po komön o noꞌ uris toꞌtoꞌ, ko uris toꞌtoꞌ pu maꞌ, ko kopös en pee, kee hikta pu vavih maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ivëhkëk, a ma upöm voaꞌ kon to vuꞌ manih po oeh vih, pare pu vavih ee maꞌ. Pare voaꞌ vavih ee, ka ma upöm vu kon voaꞌ ee po 30 voaꞌ, ka ma meh vu kon voaꞌ ee po 60 voaꞌ, ka ma meh vun voaꞌ ee po 100 voaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","A teꞌ to teꞌ me non a tenaneah se pënton a soe peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ka ma vamomhë nö ee maꞌ manih pe Ieesuꞌ, pare hi poë pan, “Eën vavaasis tamoaan suk nom sih a napan ataeah a ma soe pën manih pa soe vapipinoꞌ?” ");
INSERT INTO tpz_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ke Ieesuꞌ piun a hi pa ma vamomhë peꞌ, pareꞌ soe ke rapoë pan, “E Sosoenën to vaonöt voh ken peöm pa nat a pusun in a soe vakoaan va pa Matop Vih va pa Vöön va Kin. Ivëhkëk, o upöm teꞌ to hikta onöt ne a nat vavih pa pusun in a soe vakoaan pamëh. ");
INSERT INTO tpz_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","13","Ta pah teꞌ se keh kon voh o nat, pareꞌ maaka i non a soe pe Sosoenën, e Sosoenën se heꞌ vaꞌpuh oah en peꞌ po nat, keꞌ maaka vavih en. Ivëhkëk, a teꞌ se keh koaan o nat vëh ne Sosoenën to heꞌ voh poan, e Sosoenën se öt hah këh en peꞌ po nat pamëh. A napan se kuteꞌ e ne pataeah nöꞌ to nonok noꞌ, ivëhkëk, ee to hikta antoen ne a ep in ta pah tah. Pare tënan e ne pa ma soe nöꞌ to vavatvus noꞌ, ivëhkëk, ee to pënton varo e ne, ko hikta nat vavih ne, pare hikta maaka i ne a pusun in a ma soe poë varih. Eꞌ akuk kuru a pusun in a ö nöꞌ to vavatvus suk ke noꞌ a napan a ma soe peöꞌ manih pa soe vapipinoꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ivëh, kee ep ee pataeah no a teꞌ vanënën soe vëh e Aisaëaꞌ to sosoe suk voh non to tavus man en, eꞌ to soe voh pan, “Eöm se tënan em pa soe, ivëhkëk, eöm to hikta onöt nem a nat in a pusuneah, paröm kuteꞌ e nem, ko kuteꞌ kov e nem ivëhkëk, eöm to hikta onöt nem a inan ta pah tah. ");
INSERT INTO tpz_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Suk ataeah, a ma kokoman pee to nun, kee papanih a ma tenëëre, pare makus e ne. Suk, ee tomeꞌ nat in a tah nee to ep in pa ma matëëre, ko tënan a soe pa ma tenëëre. Ee to koman ne pan ee tomeꞌ nat a pusun in a soe pamëh, ko tapiun hah ke maꞌ manih peöꞌ, köꞌ vatoꞌ hah raoe.” ");
INSERT INTO tpz_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","E Ieesuꞌ to vavaato avoeꞌ me e non pa ma vamomhë peꞌ, pareꞌ soe pan, “Vaeö rakah peöm o teꞌ varih to ep in a ma tah nöꞌ to nonok noꞌ pa matëëneöm, paröm nat vamaaka a soe nöm to tënan pa tenëneöm. ");
INSERT INTO tpz_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Eöꞌ to soe vaman rakah keoꞌ peöm. O teꞌ vanënën soe o peo rakah, me ra nap totoopin, ee to iu ep voh ne a ma tah nöm to ep in kuru. Ivëhkëk, ee to hikta ep voh. Pare iu tënan rakah ne a soe pamëh. Ivëhkëk, ee to hikta tënan voh a soe pamëh.” ");
INSERT INTO tpz_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","E Ieesuꞌ to vavaato avoeꞌ me e non pa ma vamomhë peꞌ, pareꞌ soe pan, “Varuꞌ vakomanih söm pënton vavih pa pusun in a soe vapipinoꞌ va pa teꞌ vëh to poꞌpoꞌ a kon manih pa rak peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","A ma voaꞌ kon varih to vuꞌ manih po vaꞌpet taan to teꞌ va ne manih po teꞌ varih to tënan ee pa soe va pa Matop Vih pe Sosoenën, ivëhkëk, ee to hikta maaka vavih ne pa pusun in a soe pamëh. Ke susun po oraꞌ hat nö maꞌ, pareꞌ kon ke en pa soe vih vëh ne Sosoenën to poꞌpoꞌ manih pa koman a teꞌ pamëh. ");
INSERT INTO tpz_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ka ma teꞌ voaꞌ kon varih to vuꞌ manih pa moeh vösvös, ee to teꞌ va ne manih pa teꞌ to pënton en pa soe, pareꞌ kon vëvëhöꞌ rakah en peꞌ, pareꞌ vaeö e non peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ivëhkëk, o vaman to hikta aan vakis manih pa komaneah. Ko poen no a napan to kehkeh vöknah ne a soe pe Sosoenën, ee to heꞌ ee peꞌ pa punis, ko hinën ee peꞌ, ko vaman peꞌ kuꞌ vëhöꞌ en. ");
INSERT INTO tpz_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ka ma voaꞌ kon varih to vuꞌ manih po komön o noꞌ uris toꞌtoꞌ teꞌ vah vapoꞌ ne nih? Ee to teꞌ va ne manih po teꞌ to pënton ee pa soe, ivëhkëk, o kokoman pee to puh suk rakah non a ma tah peo va po oeh vëh. Pare koman vaviꞌ me e ne pa ununun vapeo a moniꞌ. Eꞌ a ma kokoman poë varih to kopös rakah ee pa soe pe Sosoenën. Ka soe pamëh hikta vovoaꞌ non. ");
INSERT INTO tpz_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ka ma teꞌ voaꞌ kon varih to vuꞌ manih po oeh vih, to teꞌ va e ne manih po teꞌ to pënton ee pa soe, pare nat vavih ee pa pusuneah. Ka soe pe Sosoenën vuꞌ manih po kokoman pa teꞌ, pareꞌ voaꞌ pet en manih po toꞌtoꞌ peꞌ. Ka ma paeh to voaꞌ ee po 100 voaꞌ, ka ma meh to voaꞌ ee po 60 voaꞌ, ka ma meh to voaꞌ ee po 30 voaꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pan, “A Matop Vih va pa Vöön va Kin to teꞌ va e non manih pa teꞌ to poꞌpoꞌ a ma voaꞌ kon manih pa koman a rak peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ivëhkëk, pa popoen no a napan to koroh vahik ee, ka teꞌ vëh to hat ov e non poan nö maꞌ, pareꞌ varapök pet en po meon hat manih pa koman a kiu kon, pareꞌ hah en. ");
INSERT INTO tpz_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Po vasuksuk no a kon to pisiꞌ ee maꞌ. Pare pu ee ko kehkeh voaꞌ poꞌ ne, ka nap kiu taum ee po meon hat to pisiꞌ en maꞌ manih pa kon. ");
INSERT INTO tpz_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ka nap kiu nö ee manuh pe tövaneah pa rak, pare soe ke poë pan, ‘Topoan, emöm to koman nem pan eën to poꞌpoꞌ vaviꞌ voh a kon manih pa rak pën, ivëhkëk, o meon hat tavus taneꞌ poꞌ maꞌ nih?’ ");
INSERT INTO tpz_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ke tövaneah pa rak soe ke rapoë pan, ‘O teꞌ varih to vakihat me a ne neoꞌ ivarih to varapök po meon hat manih pa rak peöꞌ. Ka nap kiu hi ee pe tövaneah pa rak pan. ‘Eën iu e nom pa ö se möm pö o meon hat vëh pa koman kon pën ëh?’ ");
INSERT INTO tpz_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ivëhkëk, e tövaneah pa rak to soe ke rapoë pan, ‘Ahik, eöm to meꞌ pöpö nem o meon hat, paröm pö vaꞌpeh me em pa kon. ");
INSERT INTO tpz_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Eöm se koe a pö o meon, keꞌ pu vaꞌpeh me en pa kon, keꞌ onöt po poen na se moes a kon. Manih po poen va pa moes a kon, eöꞌ se soe ka nap kiu peöꞌ pan, vamomoaan nee se pö o meon hat, pare nohnoh a ma noh, kee sih vamatop ne pa ës. Ka pah moes poꞌ a kon, para vahoꞌ raoe manih pa iuun vavahoꞌ taëën peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","E Ieesuꞌ to vavaato avoeꞌ me e non pa ma vamomhë peꞌ, pareꞌ soe ke rapoë pan, “A Matop Vih va pa Vöön va Kin to teꞌ va e non manih po voaꞌ naon nee to pokaꞌ ne o mastat no a teꞌ to nep pa koman a rak peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","O voaꞌ mastat to hikta teꞌ va non manih pa ma upöm voaꞌ naon. Ahik, eꞌ o siꞌ voaꞌ tah to parin soneꞌ varo, ivëhkëk, eꞌ se keh pu maꞌ, eꞌ to apuh oah en pa ma upöm nöꞌ nepnep, eꞌ se tavus rakah en o nöꞌ apuh, ko növan nö maꞌ, pare nok ee pa ma heꞌ pee manih pa ma peananeah.” ");
INSERT INTO tpz_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pan, “A Matop Vih va pa Vöön va Kin to teꞌ va e non manih po is no a köövo to ru manih pa tis praoaꞌ, pareꞌ rih ko is hovën o praoaꞌ. Ko vasuksuk no praoaꞌ to peah en maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","E Ieesuꞌ to vavatvus vaviꞌ non a ma soe peꞌ manih pa napan pa ma soe vapipinoꞌ, eꞌ to hikta soe vamaaka rakah ke ra napan ta pah soe, ahik, eꞌ to vavatvus vaviꞌ non a ma soe peꞌ manih pa ma soe vapipinoꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Eꞌ a tah pamëh neꞌ to nonok non marën a vapuh a soe no a teꞌ vanënën soe to soe suk voh pan, “Eöꞌ se vavatvus vaviꞌ ke noꞌ peöm pa ma soe vakoaan peöꞌ manih pa ma soe vapipinoꞌ. Eöꞌ se hutët a ma tah to vakoaan voh ne penai po poen no oeh to meꞌ voh e non pa tavus, pareꞌ öök non maꞌ manih kuru.” ");
INSERT INTO tpz_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","E Ieesuꞌ to këh en pa napan, pareꞌ ho en koman iuun, ka ma vamomhë peꞌ nö me ee peꞌ, pare hi poë pan, “Soe ka möm ah pa pusun in a soe vapipinoꞌ va po meon hat vëh to pokoꞌ manih pa rak.” ");
INSERT INTO tpz_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","E Ieesuꞌ to piun a hi pee, pareꞌ soe ke rapoë pan, “A teꞌ vëh to poꞌpoꞌ a voaꞌ vih manih pa koman a rak, eꞌ eöꞌ, e Koaꞌ Teꞌ pa Napan Kurus. ");
INSERT INTO tpz_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ka rak, eꞌ o oeh, ka voaꞌ vihvih, eꞌ a napan to teꞌ ne manih pa Matop Vih pe Sosoenën. Ko meon hat, eꞌ a napan to teꞌ ne manih pa papan pe susun po oraꞌ hat. ");
INSERT INTO tpz_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ka teꞌ vëh to vakihat me non e tövaneah pa kiu kon to poꞌpoꞌ o meon hat, eꞌ e susun po oraꞌ hat. Ko poen oes a voaꞌ poë varih, eꞌ o poen no oeh vëh se hik. Ko teꞌ kikiu, ee o ankeroꞌ pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Ko meon nee se pö, pare ës po suraꞌ, eꞌ to vataare non a ö ne Sosoenën se nok amot va, po poen no oeh vëh se hik. ");
INSERT INTO tpz_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Eöꞌ e Koaꞌ Teꞌ pa Napan Kurus se vanö maꞌ o ankeroꞌ peöꞌ, kee nö, pare veo tavus o teꞌ varih to taꞌtaꞌ ne a napan, kee mimiröꞌ ne a ma vaman pee, me o teꞌ varih to nonok vatëh ne a ma taateꞌ hat. Kee tavus këh a Matop Vih va pa Vöön va Kin. ");
INSERT INTO tpz_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","O ankeroꞌ se vi e na pee manuh po suraꞌ ësës tamoaan. Manih po suraꞌ pamëh no a napan se okook kov e ne, ko vakuskus rivon me ne po kamis o apuh rakah. ");
INSERT INTO tpz_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ka nap totoopin se ëman va ee manih pa potan koman a Matop Vih pe Tamëëre. A teꞌ to teꞌ me non a tenaneah se a pënton a soe peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“A Matop Vih va pa Vöön va Kin to teꞌ va e non manih pa pokis moniꞌ no a teꞌ to koaan manih pa koman a rak. Ka meh teꞌ nönö vah non manih pa koman a rak, pareꞌ taum en pa pokis moniꞌ pamëh. Pareꞌ koaan pet en. Eꞌ to pah vaeö suntan rakah en, pareꞌ nö ko vavoen vahik en pa ma moeh tah neꞌ to vaneah non, pareꞌ kon a moniꞌ ko voen en pa rak pamëh.” ");
INSERT INTO tpz_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pet en pan, “A Matop Vih va pa Vöön va Kin to teꞌ va i non manih pa teꞌ öt ö to iu voen non ta ma kuri mamatan vavih. ");
INSERT INTO tpz_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Eꞌ to taum en maꞌ po kuri o pöh voen vapeah rakah, pareꞌ nö ko vavoen vahik rakah en pa ma moeh tah peꞌ. Pareꞌ hah poꞌ ko voen en po kuri pamëh.” ");
INSERT INTO tpz_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pan, “A Matop Vih va pa Vöön va Kin to teꞌ va ennon manih pa kë nee to vöknah tahiꞌ, pare vaon a ma vu iian. ");
INSERT INTO tpz_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","A kë to puh ka nap tatanaꞌ iian rëh takin ee pa kë sinten tahiꞌ, pare ihoꞌ, ko pitöꞌ ee o iian, a ma teꞌ o vihvih nee to vahoꞌ po kove, ka ma teꞌ o hat nee to vi ee na pee. ");
INSERT INTO tpz_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Eꞌ to ep va i non nën po poen no oeh vëh se hik. O ankeroꞌ pe Sosoenën se nö maꞌ, pare pitöꞌ taneꞌ maꞌ a nap vatösoe manih pa nap tëtënan soe. ");
INSERT INTO tpz_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","O ankeroꞌ pe Sosoenën se vi kunah en pa nap vatösoe manih po suraꞌ ësës tamoaan. Manih po suraꞌ pamëh no a nap vatösoe se okook kov e ne, ko vakuskus rivon me e ne po kamis o apuh rakah.” ");
INSERT INTO tpz_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ke Ieesuꞌ hi en pa ma vamomhë peꞌ pan, “Eöm nat vavih kës e nem pa pusun in a soe vaꞌih?” Kee soe maꞌ pan, “A, emöm to nat kurus e nem pa ma soe poë varih.” ");
INSERT INTO tpz_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ke Ieesuꞌ soe ke rapoë pan, “O teꞌ vavaasis varih to nat voh ne o Vavaasis pe Mosës ee to nat vahik voh ee pa pusun in a soe va pa Matop Vih va pa Vöön va Kin. Eꞌ to teꞌ akuk va kov e non manih pe tövaneah pa iuun to ho koman iuun, pareꞌ teꞌ tavus maꞌ a ma tah voon me a ma teꞌ tah vamoaan, pareꞌ heꞌ en po upöm teꞌ. Ivëh, ke eöm a ma vamomhë peöꞌ se nö, paröm vatvus ke ra napan a soe va po ururuan vih pe Sosoenën me a Soe Vih va pa Matop Vih va pa Vöön va Kin.” ");
INSERT INTO tpz_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","E Ieesuꞌ to hutët vahik ke ra napan a ma soe vapipinoꞌ poë varih, pareꞌ këh en pa ö vëh neꞌ to teꞌ non. ");
INSERT INTO tpz_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Eꞌ to hah en pa vöön vëh neꞌ to apuh voh, pareꞌ vavatvus non a soe pe Sosoenën manih pa napan koman a iuun hinhin soneꞌ pee. Ka napan tënan a ma soe peꞌ, pare pah töhkak vahat rakah ee, pare vaiihi koman e ne pan, “A teꞌ vëh kon taneꞌ maꞌ o nat me o kikis vëh nih, marën a nok a ma tah vatoksean? ");
INSERT INTO tpz_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Eꞌ e koaꞌ poꞌ pa teꞌ ekeok toh, ke sinaneah e Mariaꞌ, ka ma kea peꞌ ivarih, e Jëmis, ke Jeosëp, ke Saëmon, ke Jiutas. ");
INSERT INTO tpz_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ka kën vameneah teꞌ vaꞌpeh me e ne pea manih, ka teꞌ vëh se poꞌ kon taneꞌ maꞌ o nat me o kikis vëh nih?” ");
INSERT INTO tpz_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Keꞌ ivëh, a tah no a napan va pa vöön peꞌ to heꞌ tonun suk poë. Ivëhkëk, e Ieesuꞌ to soe ke rapoë pan, “A teꞌ vanënën soe no a ma muhin kurus to ta e ne peꞌ. Ivëhkëk, manih pa vöön koman peꞌ, me manih pa kën poaneah, me manih pa tapaiuun koman peꞌ, ee to hikta ta ne poë, pare heꞌ tonun e ne peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ivëh, neꞌ to hikta nok suk voh ta ma tah vatoksean apuh nën. Suk ataeah, a napan to hikta vaman ne poë. ");
INSERT INTO tpz_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Manih po poen pamëh ne Ieesuꞌ to teꞌ avoeꞌ e non manih Nasarët, e Hëërot he sunön non manih pa muhin va Galiliꞌ. Eꞌ to pënton a ma vahutët va pe Ieesuꞌ, ");
INSERT INTO tpz_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","pareꞌ soe ke ra nap kiu peꞌ pan, “E Jon kës kovëh to pupui non sih a napan pa ruen to sun taneꞌ hah maꞌ po vapeepe? Ivëh, neꞌ to teꞌ suk me non o kikis va pa nok a ma tah vatoksean.” ");
INSERT INTO tpz_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Moaan voh ne Hëërot to öt e Jon, pareꞌ nohnoh poan po uris eh. Ko vahoꞌ poan pa iuun nohnoh, suk e Hëëroteas e köövo pe kea soneꞌ peꞌ, Filip. ");
INSERT INTO tpz_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","E Jon to soe ke Hëërot pan, “Manih pa taateꞌ pa kën sipuura, eꞌ to hat rakah e non pa ö nën to he e köövo pe kea pën Filip, parën me.” ");
INSERT INTO tpz_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","E Hëërot to pënton a soe pe Jon, pareꞌ kehkeh ip vamët e non peꞌ, ivëhkëk eꞌ to nanaöp non a napan, suk ee to vaman e ne e Jon a teꞌ vanënën soe. ");
INSERT INTO tpz_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Manih po poen ne sinan e Hëërot to vahuh voh poan, ne Hëërot to nok a taëën va po poen pamëh, pareꞌ vaoe na o upöm teꞌ susunön kee nö maꞌ pa vaeö me poë. Ke semon Hëëroteas pinoꞌ vamanin rakah en pe Hëërot. ");
INSERT INTO tpz_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","E Hëërot to vaeö suntan rakah, pareꞌ soe ke semon Hëëroteas a soe kikis neꞌ to hikta onöt non a kök hah. Eꞌ to soe pan, “E semon Hëëroteas se keh iu non tataeah, eöꞌ se heꞌ eoꞌ peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ke Hëëroteas soe ken pe semoneah pataeah neꞌ se nö, pareꞌ hin manih pe Hëërot. E semon Hëëroteas to nö pareꞌ soe ke Hëërot pan, “Heꞌ a neoꞌ o kahoꞌ pe Jon Tövapupui se pet non pa peret.” ");
INSERT INTO tpz_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","E Hëërot to pënton a soe vaꞌih, pareꞌ töhkak vahat rakah en, pareꞌ tamak. Ivëhkëk, a hikta tah neꞌ se nok hah, suk ataeah, eꞌ to soe vu ken pe semon e Hëëroteas pa soe kikis, o upöm teꞌ susunön neꞌ to vaoe na he pënton i ne pa soe pamëh. Ivëh, ke Hëërot taꞌ en pa nap vëvënsun peꞌ, kee vatet ee pa soe pe semon e Hëëroteas. ");
INSERT INTO tpz_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","E Hëërot to vanö en pa nap vëvënsun manuh pa iuun nohnoh, kee moes kurus ee maꞌ po kahoꞌ pe Jon. ");
INSERT INTO tpz_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ee to teꞌ ee maꞌ po kahoꞌ pe Jon to pet non pa peret, pare heꞌ ee pe koaꞌ sepeꞌ pamëh, keꞌ teꞌ, ko heꞌ en pe sinaneah. ");
INSERT INTO tpz_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ka ma vamomhë pe Jon nö maꞌ, pare teꞌ ee pa sionin e Jon, ko pe ee peꞌ, pare nö, ko hutët ke pe Ieesuꞌ pa tah to tanok manih pe Jon. ");
INSERT INTO tpz_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","E Ieesuꞌ to pënton o vahutët va pa tah to tanok manih pe Jon, pareꞌ tok vaꞌpeh me ra ma vamomhë peꞌ po paröꞌ, kee nö ee pa ö no a hikta teꞌ to teꞌ non. Ivëhkëk, a napan peo to pënton a soe va pa ö ne Ieesuꞌ to nö en, pare këh ee pa vöön vëh nee to teꞌ ne, ko vatet koe ee peꞌ manih hanan. ");
INSERT INTO tpz_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","E Ieesuꞌ to tatakin këh ko non o paröꞌ, pareꞌ ep a nap peo rakah to anoeh ne. Pareꞌ kamöꞌ en pee, ko vavatoꞌ en po teꞌ varih to haraꞌ ne a ma vu mët. ");
INSERT INTO tpz_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pa matanpoen no a ma vamomhë pe Ieesuꞌ to nö ee maꞌ manih peꞌ. Pare soe ke poë pan, “Ahikta napan to teꞌ ne manih pa muhin vaꞌih, keꞌ vih non pea se vanö hah a napan varih, kee nö, pare voen koman ta ma taëën pee manih pa ma vöön to teꞌ vatët ne.” ");
INSERT INTO tpz_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ke Ieesuꞌ piun rapoë, pareꞌ soe pan, “Ee se nö suk ataeah, eöm koman se makën raoe.” ");
INSERT INTO tpz_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ka ma vamomhë pe Ieesuꞌ soe ke poë pan, “Ea to teꞌ ro me no o tönim muꞌ me ra poa iian.” ");
INSERT INTO tpz_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ke Ieesuꞌ soe pan, “Teꞌ maꞌ öm o tönim muꞌ me ra poa iian poë varih.” ");
INSERT INTO tpz_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ke Ieesuꞌ taꞌ en pa napan, kee ihoꞌ ee pa karas, keꞌ kon o tönim muꞌ me ra poa iian, pareꞌ ta peah na kin, ko soe vavihvih ke na e Sosoenën pa taëën pamëh, pareꞌ kökök a ma muꞌ, ko ki ken pa ma vamomhë peꞌ, kee makën poꞌ ee pa napan. ");
INSERT INTO tpz_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","A napan to ëën, pare mahun vahik rakah ee, ka ma vamomhë pe Ieesuꞌ ununun o havun me ro pöök kove pa ma ö taëën varih no a napan to ëën këh. ");
INSERT INTO tpz_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","A napan to peo onöt ne a 5,000 teꞌ to ëën a taëën pamëh, ee to hikta ëh vaꞌpeh voh o köövo me ro koaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","E Ieesuꞌ to taꞌ en pa ma vamomhë peꞌ, kee vëvëhöꞌ peah ee manih po paröꞌ, pare vovoh pahan ee manuh pa pap tonon vöh. Ee to këh ee peꞌ to vavanö hah non a napan pa ma vöön pee. ");
INSERT INTO tpz_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Eꞌ to vanö vahik en pa napan, pareꞌ ëp en pa siꞌ ö tope pa hin. Eꞌ to teꞌ non nën ka muhin matanpoen en. ");
INSERT INTO tpz_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Manih po poen pamëh no paröꞌ to vahuk këh en pa sinten a tonon. Ka supa töstös kov e non po paröꞌ, suk a tuvuh to ipip koe ke non maꞌ nën. ");
INSERT INTO tpz_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Topnin a 3 kirök me a 6 kirök pa pöstakah ne Ieesuꞌ to nö maꞌ manih pa ma vamomhë peꞌ to tok ne po paröꞌ. Eꞌ to tet maꞌ a tonon. ");
INSERT INTO tpz_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","A ma vamomhë peꞌ to ep i na poë to tetet nö non maꞌ a tonon, pare rikrik rakah e ne po naöp. Pare pah tötö suntan e ne, suk ee to koman ne pan e Ieesuꞌ a oraꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ivëhkëk, e Ieesuꞌ to to vëvëhöꞌ ken pee, pareꞌ soe pan, “Teꞌ vaes nem, paröm koe a naöp, eöꞌ akuk kuru.” ");
INSERT INTO tpz_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ke Pitaꞌ soe ke Ieesuꞌ pan, “Sunön eꞌ se keh teꞌ non pan eën e Ieesuꞌ, kën soe ka maꞌ neoꞌ, köꞌ tet nös a tonon ko nö nös pën.” ");
INSERT INTO tpz_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ke Ieesuꞌ soe ke maꞌ e Pitaꞌ pan, “Maꞌ ah,” Ke Pitaꞌ këh en po paröꞌ, pareꞌ tet en pa tonon ko nö en manuh pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ivëhkëk, e Pitaꞌ to ep a tuvuh me a supa pareꞌ naöp en, ko taneo en pa rokoꞌ, pareꞌ kokoeꞌ ke na e Ieesuꞌ, ko soe pan, “Hehe a neoꞌ ah, Topoan!” ");
INSERT INTO tpz_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Varuꞌ rakah vakomanih ne Ieesuꞌ to öt a koreneah, pareꞌ soe pan, “Suk ataeah, kën koman vaponkiꞌ nom? O vaman pën to parin a soneꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Vasuksuk ne Ieesuꞌ pen Pitaꞌ to peah ee manih po paröꞌ, ka tuvuh hik en. ");
INSERT INTO tpz_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ka ma vamomhë varih to tok vu ne po paröꞌ vasunön e Ieesuꞌ, pare soe pan, “Oman, eën vamaman rakah e Koaꞌ pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","E Ieesuꞌ me ra ma vamomhë peꞌ to pahan ee pa tonon va Galiliꞌ, pare takin ee pa ö muhin va Gënesaret. ");
INSERT INTO tpz_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ka napan va pa muhin pamëh ep inan e Ieesuꞌ, pare vanö ee pa soe vanat pa ma siꞌ vöön to teꞌ vatët ne nën. Kee teꞌteꞌ ee maꞌ po teꞌ varih to haraꞌ ne a ma vu mët manih pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Pare hin vakis rakah ee pe Ieesuꞌ pan a napan varih to haraꞌ ne a ma mët se hariun ro o ohop peꞌ. Ka napan kurus varih to haraꞌ ne a ma vu mët to hariun ro ohop peꞌ, pare toꞌ vahik rakah ee. ");
INSERT INTO tpz_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","E Ieesuꞌ to teꞌ avoeꞌ e non manih Gënesaret, ko Parësiꞌ me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës taneꞌ maꞌ Jerusalëm, ee to nö maꞌ pa ep in e Ieesuꞌ, pare hi poë pan, ");
INSERT INTO tpz_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Vahvanih ka ma vamomhë pën hikta vavatet ne o vavaasis no a kën sipuura to soe voh ka ra pan ea se vavatet no? Ea se kehkeh ëën no, ea se pupui momoaan a ma koreera.” ");
INSERT INTO tpz_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ke Ieesuꞌ piun varuꞌ a soe pee, pareꞌ soe pan, “Vahvapoꞌnih köm vavatet vaviꞌ nem o vavaasis peöm, paröm hikta vavatet nem a teꞌ taateꞌ pe Sosoenën? ");
INSERT INTO tpz_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","E Sosoenën to soe voh ka ra pan, “Ta e tamömah pen e sinömah. Keteh se keh veveot e tamaneah pen e sinaneah, ea se ip vamët ee peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ivëhkëk, eöm to vavaasis nem sih pan ta pah teꞌ se keh soe ke tamaneah pen e sinaneah a ö neꞌ to teꞌ me e non a tah marën a vaꞌaus rapoë pon, ivëhkëk, eꞌ to hikta heꞌ raoe, suk eꞌ se heꞌ na e Sosoenën a tah pamëh. ");
INSERT INTO tpz_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Eöm o teꞌ o pöh mokoꞌ rivon, suk eöm to vavaasis nem a teꞌ pamëh pan eꞌ se nat non vaꞌaus e tamaneah pen e sinaneah. Paröm sosoe me nem pan eꞌ to nonok non a ma tah ne Sosoenën to sosoe non. Manih po vavaasis pamëh eöm to vöknah rakah e nem pa soe pe Sosoenën, paröm kë vaviꞌ rakah e nem pa taateꞌ nöm to kon taneꞌ maꞌ pa kën sipun. ");
INSERT INTO tpz_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","A soe pe Sosoenën to man rakah en, ne Aisaëaꞌ a teꞌ vanënën soe to vatvus suk voh a neöm o teꞌ teꞌteꞌ vapoꞌkan, pareꞌ soe vamanih pan, ");
INSERT INTO tpz_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“A napan varih to kë varoe ne sih a ëhnan neoꞌ pa rivoeere, ivëhkëk, manih pa ma kupu pee, ee to teꞌ varo rakah këh e ne peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Eꞌe to vavaasis varoe ne sih a taateꞌ po teꞌ va po oeh vëh, pare pikpiuk ne sih pan, ‘Ivaꞌih a taateꞌ pe Sosoenën’. Pare vasunön a ne sih peöꞌ po rivon varoe.” ");
INSERT INTO tpz_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","E Ieesuꞌ to vaoe a napan, kee tönun ee maꞌ manih peꞌ, keꞌ soe ke rapoë pan, “Eöm kurus varih se pënton a soe peöꞌ, paröm kokoman vavih. ");
INSERT INTO tpz_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","A tah nën to öt pa koreomah, parën hikta pupui, parën ëën, eꞌ to hikta miröꞌ non o toꞌtoꞌ pën, ahik, a tah nën to koman momoaan, parën to tavus eah manih pa rivomah, eꞌ a tah pamëh to miröꞌ e non po toꞌtoꞌ pën.” ");
INSERT INTO tpz_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","O Parësiꞌ to pënton a soe pe Ieesuꞌ, pare heve ov e ne peꞌ. Ka ma vamomhë peꞌ nö maꞌ pare hi poë pan, “Eën hikta nat nom o Parësiꞌ to heve ov e ne pën, suk a ma soe varih nën to vavatvus nom oh?” ");
INSERT INTO tpz_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","E Ieesuꞌ to piun a hi pa ma vamomhë peꞌ pareꞌ soe pan, “E Tamön vöh pa vöön va kin to vaneah non pa rak, ka ma tah kurus varih to teꞌ ne pa koman a rak, ne Tamön to hikta nep voh, eꞌ koman se tai vaꞌpeh me en pee pa ma aan. ");
INSERT INTO tpz_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Eöm se koe a koman vatëh o heve po Parësiꞌ, ee ro teꞌ o kekehoꞌ. Ta pah teꞌ kehoꞌ se keh meeme nö non a meh teꞌ kehoꞌ, ee vapöök pon se vuꞌ hop ee manih pa koman a koveꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ke Pitaꞌ hi e Ieesuꞌ pan, “Eën onöt e nom pa vamaaka ka möm a pusun in a soe vapipinoꞌ vëh nën to soe ke ra napan ah?” ");
INSERT INTO tpz_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ke Ieesuꞌ soe, “Eöm me to hikta nat vavih nem pa tah vëh to mimiröꞌ non sih po toꞌtoꞌ pa teꞌ, ha? ");
INSERT INTO tpz_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","A ma moeh tah kurus varih na to ënëën no sih se kunah manih pa komaara, ka pepeak vi ee pee. ");
INSERT INTO tpz_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ivëhkëk, a tah to teꞌ non manih po kokoman pa teꞌ, keꞌ to tavus in poan, eꞌ a tah ko pamëh to miröꞌ en pa apen a teꞌ ");
INSERT INTO tpz_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","A ma taateꞌ hat varih to tatavus taneꞌ ne maꞌ po kokoman pa teꞌ, ee ivarih, ip vamët a meh teꞌ, me e voe to nok a taateꞌ rëhrëh. Me e köövo to nok a taateꞌ teꞌteꞌvaasiꞌ, me a ma meh taateꞌ rëhrëh, me a taateꞌ kaveo, me a taateꞌ piuk, me a taateꞌ va pa vasoe aven a meh teꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ee ivarih a ma taateꞌ poë varih to vapö ne sih a apen a teꞌ manih po epep pe Sosoenën. Ka manih pa ö no a teꞌ to hikta pupui momoaan a koreneah, pareꞌ ëën, a taateꞌ pamëh to hikta vapö non a apen a teꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","E Ieesuꞌ to këh en pa vöön va Gënesaret vëh neꞌ to teꞌ non, pareꞌ nö en manuh pa ma vöön to teꞌ ne pa muhin va Taëaꞌ me Saëdon. ");
INSERT INTO tpz_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","A pah köövo to hikta teꞌ non pan eꞌ a mu Jiuꞌ, eꞌ a köövo va Keenan to teꞌ non sih pa muhin pamëh, eꞌ to nö maꞌ pe Ieesuꞌ, pareꞌ hin poan, pareꞌ soe pan, “Sunön, Koaꞌ supnaiꞌ pe Devit ururuan a neoꞌ ah, a oraꞌ hat to miröꞌ voh e semoneoꞌ, keꞌ kamis voh en pa ma tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ivëhkëk, e Ieesuꞌ to hikta piun avoeꞌ non a hin pe köövo pamëh. Ka ma vamomhë peꞌ nö maꞌ, pare soe ke poë pan, “Taꞌ e köövo vëh, keꞌ nö na. Eꞌ to kokoeꞌ suk avoeꞌ nö e non maꞌ pea.” ");
INSERT INTO tpz_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ke Ieesuꞌ piun a ma vamomhë peꞌ pareꞌ soe pan, “E Sosoenën to vanö voh a maꞌ neoꞌ, pan eöꞌ se vaꞌaus a napan va Israël, suk ee to teꞌ va ne manih po sipsip to nun.” ");
INSERT INTO tpz_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ke köövo pamëh hah en maꞌ manih pe Ieesuꞌ, pareꞌ vatokon manih pa mataneah, pareꞌ soe ke poan pan, “Sunön vaꞌaus a neoꞌ ah!” ");
INSERT INTO tpz_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ke Ieesuꞌ piun e köövo pareꞌ soe pan, “Eꞌ to hikta matan vavih non pa kon a taëën po koaꞌ, ko heꞌ ro këh.” E Ieesuꞌ to soe vamanih, suk o Jiuꞌ to koman ne pan o upöm teꞌ to teꞌ va e ne manih po këh. ");
INSERT INTO tpz_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ke köövo va Keenan pamëh soe varuꞌ ke Ieesuꞌ pan, “Oman Sunön, ivëhkëk, o këh to nat e ne pa ëën a ma ö kukuvun taëën, ëën këh pa kën poëëre to vuꞌvuꞌ taneꞌ ne maꞌ pa pok ënëën.” ");
INSERT INTO tpz_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","E Ieesuꞌ to pënton a soe pe köövo pamëh, pareꞌ soe va in poan manih pan, “Köövo o vaman pën to parin apuh, eöꞌ se nok eoꞌ pataeah nën to iu nom.” Ka varuꞌ vakomanih ne semoneah to toꞌ hah en. ");
INSERT INTO tpz_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","E Ieesuꞌ to këh en pa ö neꞌ to teꞌteꞌ non, pareꞌ hëhë nö non pa sinten a tonon va Galiliꞌ, pareꞌ ep in a siꞌ ö tope, pareꞌ nö ko ihoꞌ en nën. ");
INSERT INTO tpz_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ka nap peo rakah nö ee maꞌ manih pe Ieesuꞌ, ee to nö vaꞌpeh me maꞌ o teꞌ hathat ma moe, me ro teꞌ kekehoꞌ, me ro teꞌ tëtënkun, me ro teꞌ varih to hikta antoen ne a to. Me ro upöm teꞌ to haraꞌ ne a ma vu kamis. Pare vahoꞌ ee pee manih pa havin mon e Ieesuꞌ. Ke Ieesuꞌ vavatoꞌ vahik rakah en pee. ");
INSERT INTO tpz_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","A napan to ep in a nap hikta toto to vaato hah ee, ka nap tëtënkun to vihvih hah ee. Ko teꞌ hathat ma moe nö vavavih hah ee, me o teꞌ kekehoꞌ to opoep hah ee, pare toksean rakah ee. Ko kë ee pa ëhnan e Sosoenën pee. ");
INSERT INTO tpz_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","E Ieesuꞌ to vaoe a ma vamomhë peꞌ, kee nö maꞌ manih peꞌ, keꞌ soe ke rapoë pan, “Eöꞌ to kamöꞌ rakah e noꞌ pa napan varih, suk ee to teꞌ vaꞌpeh me a neoꞌ po kukön poen. Pare hikta teꞌ hah me ne ta ma taëën nee se ëën, suk a ma taëën pee to hik këh en pee. Köꞌ rës e noꞌ pa vanö maë hah raoe manuh pa ma vöön pee. Ee tomeꞌ tötöspan ee po maë, ko sunë këh ee pa nö hah manuh hanan.” ");
INSERT INTO tpz_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ka ma vamomhë peꞌ hi poë pan, “Ea to teꞌ varo rakah këh e no pa ma vöön apaꞌpuh, ka se poꞌ kon maꞌ ta taëën nih, para makën a nap peo varih?” ");
INSERT INTO tpz_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ke Ieesuꞌ hi poꞌ en pa ma vamomhë peꞌ pan, “O tovih muꞌ poꞌ nöm to teꞌ me nem?” Kee piun va ee manih pan, “O tönim me ro pöök muꞌ, me ra ma siꞌ iian.” ");
INSERT INTO tpz_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ke Ieesuꞌ taꞌ en pa napan, kee ihoꞌ ee manih po oeh. ");
INSERT INTO tpz_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ke Ieesuꞌ kon a tönim me ro pöök muꞌ, me a ma siꞌ iian, pareꞌ ta peah na kin ko soe vavihvih ke na e Sosoenën. Pareꞌ ki vakëkëh ke ra ma vamomhë peꞌ, kee makën poꞌ ee pa napan. ");
INSERT INTO tpz_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","A napan kurus to ëën, pare mahun vahik rakah ee, ka ma vamomhë pe Ieesuꞌ ununun o tönim me ro pöök kove pa ma ö taëën varih nee to mahun këh. ");
INSERT INTO tpz_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","A kën voe to peo onöt ne a 4,000 teꞌ, ee to hikta ëh vaꞌpeh me voh o köövo me ro koaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","E Ieesuꞌ to vanö vahik en pa napan, pareꞌ peah en po paröꞌ, ko taneꞌ manih pa muhin va Dekapolis, ko pahan a tonon, ko vos en manuh pa muhin vëh ne to popokaꞌ ne Magadan. ");
INSERT INTO tpz_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","O Parësiꞌ me ro Sëdiusi to nö maꞌ, pare kehkeh punöꞌ ne e Ieesuꞌ, pare soe ke poë pan, “Ieesuꞌ, nok ah ta tah vatoksean va pa vöön va kin to vataare a no möm a ö nën to nonok nom a kiu pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ivëhkëk, e Ieesuꞌ to piun rapoë pareꞌ soe pan, “Pa matanpoen nöm to sosoe nem sih pan, a akis se keh kakaaroen, ka nat ee pa muhin se poen vavih en nös. ");
INSERT INTO tpz_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Pa pöstakah nöm se keh ep a muhin to popoen, pareꞌ ep vasup non. A, eöm se nat em pa uhön se nus en nös. Eꞌ to teꞌ akuk va kov e non manih, peöm to inan vavih e nem sih po vëknöm va pa akis. Suk ataeah poꞌ, köm hikta inan vavih nem pa pusun in a ma tah nöꞌ to nonok noꞌ kuru. ");
INSERT INTO tpz_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Eöm a napan va kuru, eöm ro hat rakah. Paröm heꞌ tonun in e Sosoenën, eöm to kehkeh ep varoe nem ta tah vatoksean nöꞌ se nok. Ivëhkëk, eöm hikta se ep nem ta tah vatoksean. O pöh tah vatoksean varoe ko vëh nöm se ep, ivëh, pa ö no a iian apuh to orom voh e Jonaꞌ a teꞌ vanënën soe. Eꞌ to teꞌ voh non manih pa koman a iian pamëh pa kukön potan me ra kukön poen, pareꞌ teꞌ toꞌtoꞌ e non.” E Ieesuꞌ to soe vahik vakomanih, pareꞌ këh en pee to sun ne, ko nö en. ");
INSERT INTO tpz_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","E Ieesuꞌ me ra ma vamomhë peꞌ to taneꞌ maꞌ pa vöön ne to pokaꞌ ne Magadan, pare pahan ee pa pap tonon vöh, ko vos ee pa vöön va Bëtsaëtaꞌ. Ivëhkëk, ee to vanun ee pa teꞌ maꞌ ta taëën. ");
INSERT INTO tpz_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ke Ieesuꞌ soe ke rapoë pan, “Ut vavih nem paröm matop vavih nem pa taateꞌ hat po Parësiꞌ me ro Sëdiusi. Ee tomeꞌ vamahun a neöm po piuk vamanih po is na to hovën o praoaꞌ. Eöm se nat nem kon a taateꞌ piuk pee.” ");
INSERT INTO tpz_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","A ma vamomhë peꞌ to kokoman këh ne a pusun in a soe vaꞌih, pare vaiihi e ne pan, “Eꞌ to sosoe pöꞌ non a soe vaꞌih suk ea to hikta teꞌ vu maꞌ ta taëën.” ");
INSERT INTO tpz_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ke Ieesuꞌ nat en pataeah ne to vaiihi suk ne, ivëh, keꞌ hi en pee pan, “O vaman peöm to parin a soneꞌ varo, vahvanih köm vaiihi nem pan, ea to hikta teꞌ me no ta taëën? ");
INSERT INTO tpz_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Eöm hikta maaka avoeꞌ nem eh? Kokoman hah voh na öm po tönim muꞌ varih na to makën voh o teꞌ to peo oah e ne pa 5,000 teꞌ. O tovih kove ivarih na to vapuh hah pa ma ö taëën ëën këh? ");
INSERT INTO tpz_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Me eöm to vanun pöꞌ voh em pa tönim me ro pöök muꞌ varih na to makën voh a napan to peo oah e ne pa 4,000 teꞌ. O tovih kove ivarih na to vapuh hah pa ma ö taëën ëën këh? ");
INSERT INTO tpz_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Eöm hikta koman hah rakah ko nem eh? Eöꞌ to hikta koman voh noꞌ a taëën, paröꞌ sosoe noꞌ a soe vaꞌih, ahik, eöꞌ to kömköm voh a noꞌ neöm pan, eöm se matop vavih nem po is po Parësiꞌ me ro Sëdiusi. ");
INSERT INTO tpz_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ka ma vamomhë peꞌ nat poꞌ ee pataeah neꞌ to kömköm suk voh non rapoë, eꞌ to hikta sosoe ke voh non rapoë, pan ee se ut vavih ne po is vëh, nee to hohovën ne sih a praoaꞌ. Ahik, eꞌ to kömköm voh non rapoë, pan ee se matop vavih ne po vavaasis hat po Parësiꞌ me ro Sëdiusi. ");
INSERT INTO tpz_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","E Ieesuꞌ to nö en manuh pa vöön va Sisariaꞌ Filipaë. Pareꞌ hi en pa ma vamomhë peꞌ pan, “A napan popokaꞌ ne sih e Koaꞌ Teꞌ pa Napan Kurus, eteh?” ");
INSERT INTO tpz_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ka ma vamomhë peꞌ piun a hi peꞌ, pare soe pan, “A ma pöh teꞌ to popokaꞌ a nom oah sih pan eën e Jon Tövapupui, ka ma meh popokaꞌ a nom oah e Elaëjaꞌ, ko upöm popokaꞌ a nom oah e Jeremaëaꞌ, keꞌ, eën a pah teꞌ va pa nap vanënën soe to toꞌ hah maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ke Ieesuꞌ hi hah en pee pan, “Ke eöm koman poꞌ, eöm popokaꞌ poꞌ a nem neoꞌ, eteh?” ");
INSERT INTO tpz_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ke Saëmon a meh ëhnaneah e Pitaꞌ to piun a hi pe Ieesuꞌ, pareꞌ soe pan, “Eën e Kristo e Koaꞌ Teꞌ pe Sosoenën toꞌtoꞌ tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","E Ieesuꞌ to piun a soe pe Pitaꞌ, pareꞌ soe ke poan pan, “Saëmon sunaiꞌ Jonaꞌ, e Sosoenën to tapui a oah. A hikta pah teꞌ va po oeh vëh to vataare a oah a soe vaꞌih. E Tamön varoe ko vöh pa vöön va kin to vataare a oah a soe vaꞌih. ");
INSERT INTO tpz_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ke eöꞌ se soe vaman rakah keoꞌ pën, eën e Pitaꞌ. Ka pusun in a ëhnöömah to soe va non manih pan a vös. Köꞌ se vasun o vakum vivihan peöꞌ, manih pa tonun a vös pamëh. Ko kikis va pa mët hikta antoen non a vöknah o vakum vivihan pamëh. ");
INSERT INTO tpz_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ke eöꞌ se heꞌ a oah oꞌo kiꞌ va pa Matop Vih va pa Vöön va Kin. Ka tah nën to vaonöt manih po oeh, e Sosoenën me se vaonöt en maꞌ peꞌ manuh pa vöön va kin. Ka tah nën to hikta vaonöt manih po oeh, e Sosoenën se hikta vaonöt manuh pa vöön va kin.” ");
INSERT INTO tpz_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","E Ieesuꞌ to vuhvuh vakis rakah en pa ma vamomhë peꞌ pan ee se nat nee soe vanat tah meh teꞌ, pan eꞌ e Kristo, a Teꞌ ne Sosoenën to vanö voh maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Taneo non po poen pamëh ne Ieesuꞌ to soe ke ra ma vamomhë peꞌ, pan eꞌ se nö manuh Jerusalëm, pareꞌ kon o kamis apuh rakah manih pa koreera nap susunön po Jiuꞌ, me ro teꞌ susunön ësës heꞌ, me ro teꞌ vavaasis varih to nat i ne o Vavaasis pe Mosës. Ee se ip vamët poë, ko vakön poen neꞌ se sun taneꞌ hah en manih po vapeepe. ");
INSERT INTO tpz_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ke Pitaꞌ me ke en pe Ieesuꞌ, pareꞌ siröꞌ en peꞌ pan, “Eën se nat nom sosoe va nom manih, suk a ma tah kurus varih nën to sosoe nom se hikta tavus manih pën.” ");
INSERT INTO tpz_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ke Ieesuꞌ tarih pareꞌ piun a soe pe Pitaꞌ, pareꞌ soe pan, “Susun po oraꞌ hat, këh a na neoꞌ ah! Eën to hikta vavaꞌaus a nom neoꞌ! A soe pën to hikta teꞌ non pan a soe pe Sosoenën, ahik, a soe pën, eꞌ a soe pa teꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ke Ieesuꞌ soe ke ra ma vamomhë peꞌ pan, “Ta pah teꞌ se iu vatet a non neoꞌ, eꞌ se vöknah o iu koman peꞌ, pareꞌ teꞌ a kuruse peꞌ, pareꞌ teꞌ o kamis, ko vatet a maꞌ neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","O teꞌ varih to koman vakis ne a ma toꞌtoꞌ pee, pare hikta vavatet a ne neoꞌ, a, a ma toꞌtoꞌ pee se ro akuk ee. Ivëhkëk, o teꞌ varih to vavatet a ne neoꞌ, pare mët suk a neoꞌ, ee se kon ee po toꞌtoꞌ tamoaan. ");
INSERT INTO tpz_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","A napan se keh kon kurus a ma tah va po oeh, pare vanun ee po toꞌtoꞌ tamoaan, a ma tah kurus poë varih se poꞌ vaꞌaus vah va in o toꞌtoꞌ pee nih? Ahik rakah! Ahik ta pah tah no a napan to onöt ne a voen hah o toꞌtoꞌ pee. ");
INSERT INTO tpz_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Eöꞌ e Koaꞌ Teꞌ pa Napan Kurus se nö me maꞌ o maaka pe Sosoenën me ro ankeroꞌ peꞌ, paröꞌ heꞌ ra napan kurus o voen to onöt ro non a ma taneah nee to nonok ne. ");
INSERT INTO tpz_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Eöꞌ to soe vaman rakah keoꞌ peöm. A ma pöh teꞌ to sun ne manih kuru, se meꞌ avoeꞌ e ne pa mët, ee heh ep ee peöꞌ e Koaꞌ Teꞌ pa Napan Kurus se nö va maꞌ manih pa Teꞌ Sunön. ");
INSERT INTO tpz_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","O tönim me o pöh poen to oah ee, ke Ieesuꞌ, me e Pitaꞌ, me ra poa tom kea e Jëmis pen Jon. Ee varoe to peah pa tope a pah vakin. ");
INSERT INTO tpz_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ee to teꞌ ne nën ka sionin e Ieesuꞌ tarih, pareꞌ matan ke en. Ka mataneah ëman va e non manih pa potan. Ko ohop tarih, pareꞌ matan va e non manih po tëkrea. ");
INSERT INTO tpz_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ke Mosës pen Elaëjaꞌ tavus ee maꞌ, pare vavaato me e ne pe Ieesuꞌ. Ee to vaato vahik me ee peꞌ, ");
INSERT INTO tpz_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ke Pitaꞌ soe ke Ieesuꞌ pan, “Eeh, Sunön, eꞌ to vih non pea to teꞌ no manih kuru, kën se nom iu nom, köꞌ u eoꞌ pa kukön tanu manih. A teꞌ pën, me a teꞌ pe Mosës, me a teꞌ pe Elaëjaꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","E Pitaꞌ to toto avoeꞌ e non, ka unöh kakaare pöm en pee. Ka to taneꞌ maꞌ manuh pa koman a unöh to soe maꞌ pan, “Ivaꞌih e Koaꞌ vamaman rakah peöꞌ, eöꞌ to iu vi rakah e noꞌ peꞌ, paröꞌ vaeö noꞌ eah, köm se tënan eah, paröm vatet a ma soe peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","A kukön vamomhë pe Ieesuꞌ to pënton a to, to tataneꞌ non maꞌ pa koman a unöh, ko rikrik rakah e ne po naöp, pare vuꞌ ee manih po oeh. ");
INSERT INTO tpz_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ivëhkëk, e Ieesuꞌ to nö maꞌ manih pee, pareꞌ pöök rapoë, pareꞌ soe ke rapoë pan, “Sun öm! Paröm koe a naöp.” ");
INSERT INTO tpz_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","A kukön vamomhë to taꞌkë maꞌ, pare ep varoe ee pe Ieesuꞌ to teꞌ e non pehen, no ahikta meh teh to teꞌ me non poan. ");
INSERT INTO tpz_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ee to këh kunah hah ee maꞌ pa tope pamëh, ke Ieesuꞌ vuhvuh rapoë, pareꞌ soe ke rapoë pan, “Eöm se nat nem soe tavus a tah vaꞌih nöm to ep maꞌ manuh kin pa tope, keꞌ teꞌ non, ko antoen rakah po poen ne eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus se sun taneꞌ hah po vapeepe.” ");
INSERT INTO tpz_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ka kukön vamomhë peꞌ hi poë pan, “Suk ataeah ko teꞌ vavaasis to nat i ne o Vavaasis pe Mosës sosoe ne pan e Elaëjaꞌ se vovoh maꞌ?” ");
INSERT INTO tpz_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ke Ieesuꞌ piun rapoë, pareꞌ sosoe suk non e Jon Tövapupui, ko soe ke rapoë pan, “A soe pee a man, e Elaëjaꞌ to nö voh en maꞌ, pareꞌ vatotoopin vahik voh en pa ma moeh tah kurus. ");
INSERT INTO tpz_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Eꞌ to nö voh en maꞌ, ivëhkëk, a napan to hikta nat ne peꞌ, eteh. Ee to vavatet vaviꞌ e ne pa ma kokoman pee, pare nonok ne a ma vu taateꞌ hat manih peꞌ. A ma vu taateꞌ poë varih se tavus pet ee manih peöꞌ e Koaꞌ Teꞌ Pa Napan Kurus pö ne eöꞌ se teꞌ o kamis.” ");
INSERT INTO tpz_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","E Ieesuꞌ to soe vahik vakomanih ka ma vamomhë peꞌ nat poꞌ ee peꞌ to sosoe suk non e Jon Tövapupui. ");
INSERT INTO tpz_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","E Ieesuꞌ me ra kukön vamomhë peꞌ to hah ee maꞌ, pare tavus hah ee manih pa napan. Ka pah teꞌ nö maꞌ manih peꞌ, pareꞌ vapeoꞌ pasun manih pa mataneah, pareꞌ soe pan, ");
INSERT INTO tpz_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Sunön, eën onöt e nom pa uruan e koaꞌ oeteꞌ peöꞌ öh? Parën vaꞌaus eah. A ma tamoaan no a mët hat vëh a kokonoh se öt sih poan, keꞌ vuꞌ en po oeh, ka ma meh poen neꞌ se vuꞌ en po suraꞌ, me manih ruen. ");
INSERT INTO tpz_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Eöꞌ to me maꞌ eah manih pa ma vamomhë pën, kee hikta onöt ne a vatoꞌ poë.” ");
INSERT INTO tpz_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","E Ieesuꞌ to piun a soe peꞌ, pareꞌ soe pan, “Eöm varih, eöm to hikta vaman avoeꞌ rakah nem e Sosoenën se vatoꞌ en po teꞌ, eöm a nap hat. O tovih poen nöꞌ se teꞌ vaꞌpeh me a neöm, me o tovih poen nöꞌ se teꞌ a ma punis peöm? Me maꞌ öm e koaꞌ pamëh manih.” ");
INSERT INTO tpz_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","E Ieesuꞌ to siröꞌ a oraꞌ hat pamëh, pareꞌ soe pan, “Tavus këh mah e koaꞌ.” Ka oraꞌ hat pamëh këh tavus poꞌ en maꞌ pe koaꞌ, ka varuꞌ vakomanih no a kokonoh to hik këh en peꞌ, keꞌ vih hah en. ");
INSERT INTO tpz_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","E Ieesuꞌ to teꞌ non pehen, ka ma vamomhë peꞌ nö ee maꞌ manih peꞌ, pare hi poë pan, “Emöm hikta antoen nem a veo tavus a oraꞌ hat pamëh suk ataeah?” ");
INSERT INTO tpz_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","E Ieesuꞌ to piun a soe pa ma vamomhë peꞌ pareꞌ soe pan, “Eöm to hikta vaman nem a ö ne Sosoenën se vatoꞌ hah e koaꞌ pamëh. Ivëh, nöm to hikta onöt suk nem a veo tavus a oraꞌ hat pamëh. Eöꞌ to soe vaman rakah keoꞌ peöm, o vaman peöm se keh teꞌ va non manih po voaꞌ naon soneꞌ vëh o mastat. Eöm to antoen e nem pa taꞌ a tope vëh, keꞌ se sun taneꞌ manih, pareꞌ nö manuh. Eꞌ se sun, pareꞌ nö en. Ka hik poꞌ ta pah tah nöm se teꞌ toksean nem pa nok.” ");
INSERT INTO tpz_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","E Ieesuꞌ me ra ma vamomhë peꞌ to tönun hahah kov ee manih pa muhin va Galiliꞌ, keꞌ soe ke rapoë pan, “Eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus no a teꞌ se vikuh en peöꞌ manih pa koreera nap hat. ");
INSERT INTO tpz_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ee se ip vamët ee peöꞌ, pare pe ee peöꞌ, ko vakön poen ne eöꞌ se sun taneꞌ hah eoꞌ maꞌ po vapeepe.” A ma vamomhë peꞌ to pënton a soe vaꞌih, pare tamak rakah ee. ");
INSERT INTO tpz_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","E Ieesuꞌ me ra ma vamomhë peꞌ to nö, pare vos ee manuh pa vöön va Kapaneam, ka napan varih to kokon ne sih a takis moniꞌ va pa Iuun Hinhin Apuh nö ee maꞌ manih pe Pitaꞌ, pare hi poë pan, “E tövavaasis peöm se heꞌ kës en pa takis va pa Iuun Hinhin Apuh? ");
INSERT INTO tpz_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ke Pitaꞌ piun en pee, pareꞌ soe pan, “A,” ke Pitaꞌ ho en koman iuun pareꞌ hikta vaato avoeꞌ non, ke Ieesuꞌ hi en maꞌ peꞌ pan, “Saëmon, eën koman va nom nih? A nap susunön va po oeh vëh kokon ne a ma vu takis varih petereh? Manih po pus koaꞌ koman pee, keꞌ manih po upöm teꞌ?” ");
INSERT INTO tpz_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ke Pitaꞌ soe poꞌ en, “O upöm teꞌ ivarih to tatakis ne sih.” ");
INSERT INTO tpz_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ke Ieesuꞌ soe ke poꞌ poan pan, “Ea ro pus koaꞌ pe Sosoenën hikta se voen no a takis, ivëhkëk, ea to hikta iu vaheve no a nap kokon takis, ivëh, kën se nö manuh pa tonon, parën araꞌ maꞌ. Ka iian vëh nën se rëh momoaan, nën se kap a rivoneah, parën ep a moniꞌ to pet non nën. Parën teꞌ a moniꞌ pamëh parën heꞌ a nap kokon takis. Ka moniꞌ pamëh, eꞌ a takis moniꞌ pea poꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","E Ieesuꞌ me ra ma vamomhë peꞌ to teꞌ avoeꞌ e ne manih pa vöön va Kapaneam, ka ma vamomhë peꞌ nö maꞌ, pare hi poë pan, “Eteh se teꞌ non a tasun apuh oah manih pa Matop Vih va pa Vöön va Kin?” ");
INSERT INTO tpz_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ke Ieesuꞌ vaoe en na pa siꞌ koaꞌ soneꞌ, keꞌ nö en maꞌ manih peꞌ, keꞌ vasun en peꞌ manih po topnin in a ma vamomhë peꞌ, ");
INSERT INTO tpz_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","pareꞌ soe ke rapoë pan, “Eöꞌ to soe vamaman rakah keoꞌ peöm, eöm se keh hikta panih a ma taateꞌ hat peöm, paröm teꞌ va nem manih pe koaꞌ soneꞌ vaꞌih, eöm to hikta antoen nem a ho manih pa Matop Vih va pa Vöön va Kin. ");
INSERT INTO tpz_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","A teꞌ vëh to apuh non manih pa Matop Vih va pa Vöön va Kin, ivëh a teꞌ to vöknah non a taateꞌ peꞌ, pareꞌ teꞌ va non manih pe siꞌ koaꞌ vaꞌih, eꞌ kuru a teꞌ pamëh se teꞌ o ëhnan apuh manuh pa vöön va kin. ");
INSERT INTO tpz_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Keteh to koman non a kamöꞌ e koaꞌ soneꞌ to teꞌ va non manih pe siꞌ koaꞌ vaꞌih, eꞌ to kamöꞌ me en peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pan, “Ta pah teꞌ se keh koman non, pan eꞌ se rëh ke o vaman po pus koaꞌ varih to vaman voh ee peöꞌ, kee kuꞌ manih pa taateꞌ hat, eꞌ to vih rakah non pa vahan a vös apuh manih pa koꞌkoneah, ko vöknah eah manuh koman tahiꞌ, keꞌ mët këh a ö rih. ");
INSERT INTO tpz_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Varenan rakah pa napan varih po oeh vëh to nanansoe ne o upöm teꞌ, kee nonok ne a ma taateꞌ hat. Oman, a ma taateꞌ hat poë varih se tavus ee. Ivëhkëk, varenan oah rakah pa teꞌ vëh to vavatvus non a ma taateꞌ hat poë varih. ");
INSERT INTO tpz_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","A koreomah keꞌ a momah se keh vakuꞌ a oah manih pa taateꞌ hat, moes kurus eah, ko vi na. Eꞌ to vih oah non pö nën se teꞌ ro me nom o pöh koren, me o pöh mon, kën si kon o toꞌtoꞌ tamoaan. Peꞌ to hat non pën se teꞌ me nom o pöök koren me o pöök mon, ee tomeꞌ me ke ee pën manuh po suraꞌ ësës tamoaan. ");
INSERT INTO tpz_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Me a matömah se keh vakuꞌ a oah manih pa taateꞌ hat, të kon eah, parën vi na. Eꞌ to vih non pën se teꞌ me nom o pöh tök matan kën sih kon o toꞌtoꞌ tamoaan. Peꞌ to hat non pö nën se teꞌ me nom o pöök matan, kee rëh ke ee pën manuh po suraꞌ ësës tamoaan. ");
INSERT INTO tpz_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Matop vavih o siꞌ koaꞌ varih, pee to vaman voh ee peöꞌ, paröm nat nem koman nem, pan ee ro siꞌ tah pinpiun. Ahik, manuh pa vöön va kin no a ma ankeroꞌ pee to teꞌ tamoaan ne manih pa matan e Tamön. ");
INSERT INTO tpz_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pan, “Eöm koman va po nem nih pa ö no a pah teꞌ to teꞌ me non a 100 sipsip ka paeh ro. E tövaneah se kës këh en pa 99 to teꞌ ne pa ö tope ko ënëën ne a karas, pareꞌ nö en pa vaiu këh a teꞌ vëh to teꞌ varo non? ");
INSERT INTO tpz_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Eöꞌ to soe vaman rakah keoꞌ peöm, e tövaneah po sipsip se keh taum hah maꞌ a teꞌ vëh to ro non, eꞌ se pah vaeö suntan rakah en. A ma tamoaan neꞌ to haraꞌ vaeö suk e non pa 99 varih to hikta ro voh. Ivëhkëk, eꞌ se keh taum hah maꞌ a teꞌ vëh to ro voh, eꞌ se pah vaeö suntan oah rakah kov en. ");
INSERT INTO tpz_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Eꞌ to teꞌ akuk va kov e non manih pe Tamëneöm vöh pa vöön va kin to hikta iu non ta paeh va po pus koaꞌ varih po oeh vëh se ro, pare nö manuh po suraꞌ ësës tamoaan. ");
INSERT INTO tpz_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“E kea pën vëh to vatet a no neoꞌ se keh nok vahat a oah, nö ah manuh peꞌ, parën soe aven keah pan, ‘Kea, a hat vaꞌih eꞌ a hat koman pën nën to nok ka neoꞌ.’ Keꞌ se keh pënton en pa soe pën, a, eën to vaꞌaus eah, keꞌ tavus hah en e kea pën. ");
INSERT INTO tpz_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ivëhkëk, eꞌ se keh hikta pënton a soe pën, nö parën me maꞌ ta meh poa teꞌ, kee nö vaꞌpeh me maꞌ oah köm sih teꞌ nem a poa teꞌ keꞌ a kukön teꞌ marën a vavaꞌaus a soe keꞌ sih teꞌ eh non. ");
INSERT INTO tpz_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ka teꞌ pamëh se keh hikta pënton raoe, soe ke ra nap susunön varih to vovoh ne po rotuꞌ. Keꞌ se keh hikta pënton a soe pee, ep va in eah manih pa teꞌ kokon takis, keꞌ a teꞌ vëh to hikta vaman non e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Eöꞌ to soe vaman rakah keoꞌ peöm, a ma tah kurus nöm to hikta vaonöt manih po oeh, e Sosoenën me to hikta se vaonöt non maꞌ manuh pa vöön va kin. Ka ma tah kurus nöm to vaonöt manih po oeh, ne Sosoenën me se vaonöt en maꞌ pee manuh pa vöön va kin. ");
INSERT INTO tpz_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Eöꞌ to sosoe avoeꞌ ke noꞌ peöm pan, ta poa teꞌ va po vaman se keh vapöh kokoman suk ta pah tah, pare hin suk, a, e Tamön vöh pa vöön va kin se heꞌ en pee pon. ");
INSERT INTO tpz_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Eꞌ se keh teꞌ non ta poa teꞌ, keꞌ, a kukön teꞌ to tönun pa pah ö, pare hin manih pa ëhnaneoꞌ, a, eöꞌ to teꞌ e noꞌ manih pa topniire.” ");
INSERT INTO tpz_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ke Pitaꞌ huk vatët rakah en manih pe Ieesuꞌ, pareꞌ hi poan pan, “Sunön, a tovih tëëm ne kea peöꞌ se nok ka neoꞌ a hat köꞌ ihan anoe a hat peꞌ, o tönim me ro pöök tëëm ëh?” ");
INSERT INTO tpz_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ke Ieesuꞌ to piun poan, pareꞌ soe pan, “Eöꞌ to hikta soe a ö nën se ihan anoe a hat peꞌ po tönim me o pöök tëëm, ahik, eöꞌ to soe ka oah a ö nën se ihan anoe a hat peꞌ pa 490 tëëm. ");
INSERT INTO tpz_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","A Matop Vih va pa Vöön va Kin na se vëknöm va in eah manih pa teꞌ sunön to hinhin hah non a ma moniꞌ peꞌ varih no a nap kikiu peꞌ to ötop voh. ");
INSERT INTO tpz_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","O poen no a teꞌ sunön to taneo pa hin hah a ma moniꞌ peꞌ, ka napan me ee maꞌ pa teꞌ vëh to ötop voh a 10 milion kinaꞌ manih peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ivëhkëk, a teꞌ pamëh to hikta teꞌ me non ta moniꞌ marën a piun hah a ötop peꞌ manih pa teꞌ sunön. Ivëh, ka teꞌ sunön soe en pan, ‘Eöꞌ se vavoen a teꞌ kikiu vëh me ra kën tom sinan peꞌ me a ma moeh tah neꞌ to vaneah non. Köꞌ sih kon a moniꞌ nën, to piun non a ötop peꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ivëhkëk, a teꞌ kikiu pamëh to pënton a soe pa teꞌ sunön peꞌ, pareꞌ nö ko vatokon manih pa havin a poa moneah, pareꞌ soe ke poan pan, ‘Sunön, ururuan voh a neoꞌ ah, parën heꞌ voh a neoꞌ ta ma siꞌ poen. Eöꞌ se piun vahik eoꞌ pa ma moniꞌ varih nöꞌ to ötop voh manih pën.’ ");
INSERT INTO tpz_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ka teꞌ sunön pa teꞌ kikiu pamëh tamak poan, pareꞌ koe en pa vavoen poan ko ihan anoe en pa ötop peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ivëhkëk, a teꞌ kikiu pamëh to tavus pareꞌ taum a meh teꞌ kikiu to ötop voh a teꞌ moniꞌ peꞌ to onöt non a 10 kinaꞌ. Eꞌ to not poan pareꞌ nom vakmis rakah en po ororom peꞌ, pareꞌ soe ke poan pan, ‘Eën se piun vëvëhöꞌ rakah a moniꞌ peöꞌ nën to ötop voh.’ ");
INSERT INTO tpz_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ivëhkëk, a teꞌ kikiu pamëh to vuꞌ manih pa moneah, pareꞌ soe ke poan pan, ‘Kea, ururuan a neoꞌ ah, parën heꞌ a neoꞌ ta ma meh siꞌ poen, peöꞌ se piun vahik eoꞌ pa moniꞌ vëh nöꞌ to ötop voh manih pën.’ ");
INSERT INTO tpz_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ivëhkëk, a teꞌ kikiu vamomoaan vëh to hikta iu tamak non e meh peꞌ. Eꞌ to vateꞌ poan po vahutët, pareꞌ vahoꞌ en peꞌ pa nohnoh. Keꞌ teꞌ non nën, keꞌ onöt rakah pa ö neꞌ se piun hah a ötop peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ko upöm teꞌ kikiu to ep a tah vaꞌih to tanok, pare tamak ko heve rakah ee. Ee to nö hah ee manuh pe sunön pee, pare vavatët ee peꞌ pa ma taneah to tanok manih pa meh poa teꞌ kikiu pee. ");
INSERT INTO tpz_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ivëh, ka teꞌ sunön vaoe ho en na pa teꞌ kikiu peꞌ pamëh, pareꞌ soe ke poan pan, ‘Eën a teꞌ a pah hat rakah, eën to ook voh ka neoꞌ pan eöꞌ se ihan anoe a ötop pën. Köꞌ soe keoꞌ pën pan eën se nat nom piun a ötop pën. ");
INSERT INTO tpz_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Vamomoaan nöꞌ to ururuan voh eoꞌ pën, vahvapoꞌnih kën hikta ururuan e meh siꞌ teꞌ pën?’ ");
INSERT INTO tpz_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","A teꞌ sunön to pah heve suntan en, pareꞌ vahoꞌ en pa teꞌ pamëh pa iuun nohnoh, keꞌ teꞌ non nën ko antoen rakah en pa ö neꞌ se piun vahik a ötop peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ke Ieesuꞌ soe, “A teꞌ sunön vëh to nok en pa taateꞌ to vatoe me e non pa taateꞌ ne Tamön vöh pa vöön va kin se nok manih peöm pö nöm se keh hikta ihan anoe a ma hat pa ma kën kea peöm me ra ma kën vameneöm. ");
INSERT INTO tpz_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","E Ieesuꞌ to teꞌ avoeꞌ e non manih pa muhin va Galiliꞌ, pareꞌ vavaasis non a napan a ma soe peꞌ. Eꞌ to vavaasis vahik en pee, pareꞌ pahan en pa ruen vëh nee to pokaꞌ ne sih a Jödën, ko takin en manih pa muhin va Jiutiaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ka nap peo rakah vatet ee peꞌ nën, keꞌ vavahik këh en pee pa ma mët nee to haraꞌ ne. ");
INSERT INTO tpz_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ko Parësiꞌ nö ee maꞌ manih peꞌ, pare kehkeh punöꞌ ne poë, pare hi poë pan, “O Vavaasis pe Mosës soe vaonöt kës e non pe voe se kök o vaen, pareꞌ veo e köövo peꞌ manih po kokoman koman peꞌ?” ");
INSERT INTO tpz_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ke Ieesuꞌ piun a hi pee pareꞌ soe pan, “Vahvapoꞌnih köm pupunöꞌ e nem peöꞌ? Eöm to hikta ëh pöꞌ voh a soe vëh to kiun non manih po Puk Vapenpen to soe non pan, ‘Moaan rakah voh ne Sosoenën to nok o oeh me a ma moeh tah kurus, pareꞌ pah nok poꞌ a teꞌ, a teꞌ oeteꞌ, me e köövo.’” ");
INSERT INTO tpz_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","“Ivëh ne Sosoenën to soe suk vavoh manih pan, ‘E voe se këh maꞌ e sinaneah pen tamaneah, pareꞌ teꞌ vatös me e non pe köövo peꞌ, kee tavus ee pon a paeh.’” ");
INSERT INTO tpz_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","“Ivëh, ke ee pon to hikta se teꞌ hah ne a pöök. Ahik. Ee to tavus ee o pöh sionin. E Sosoenën to vatös voh en pee pon, ka hikta pah teꞌ to antoen non a ki vakëh hah raoe pon.” ");
INSERT INTO tpz_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ko Parësiꞌ hi hah ee pe Ieesuꞌ pan, “Eꞌ teꞌ vahvapoꞌ non nih, ke Mosës heꞌ voh en pa soe to soe vaonöt e non pa teꞌ se kiun o kiun marën a kök o vaen peꞌ, pareꞌ veo en pe köövo peꞌ?” ");
INSERT INTO tpz_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ke Ieesuꞌ piun en pa hi pee, pareꞌ soe ke rapoë pan, “E Mosës to vaonöt suk voh ka neöm a taateꞌ pamëh, suk eöm o teꞌ o pöh vatösoe rakah. Paröm hikta iu tënan nem a soe pe Sosoenën. Ivëhkëk, moaan voh ne Sosoenën to nok voh a ma moeh tah kurus, pareꞌ hikta nok voh a taateꞌ va pa kiun o kiun va pa kök o vaen. ");
INSERT INTO tpz_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ivëh, köꞌ se soe vaman rakah keoꞌ peöm. E voe se keh veo akuk e köövo to hikta teꞌteꞌvaasiꞌ non, pareꞌ me a meh köövo, a, e voe ko pamëh to nok en pa taateꞌ rëhrëh.” ");
INSERT INTO tpz_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","O vamomhë to pënton a soe vaꞌih pare soe ke Ieesuꞌ pan, “Eꞌ se keh teꞌ va non nën, ataeah poꞌ ne voe se veo suk pe köövo? Keꞌ vih non pa ö ne voe se nat non vaen.” ");
INSERT INTO tpz_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ke Ieesuꞌ soe ke rapoë pan, “O vavaasis va pa taateꞌ hikta vaen, eꞌ to hikta teꞌ non pan a napan kurus ivarih se vatet. Ahik, e Sosoenën to heꞌ ro a ma pah teꞌ marën a vatet a taateꞌ pamëh. ");
INSERT INTO tpz_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Eöm nat e nem eh? Eꞌ to teꞌ non a ma vu teꞌ to teꞌ ne to hikta onöt ne a vaen. Ka ma paeh va po vu teꞌ poë varih no a ma sinëëre to vahuh voh en pee no ma sioniire to hikta teꞌ vih ne pa tataman koaꞌ. Ko upöm to hikta onöt ne a tataman koaꞌ, suk a ma meh to pe a sioniire. Ko upöm to koman voh a nok a kiu manih pa Matop Vih va pa Vöön va Kin, pare soepip ee rea pa vaen. A teꞌ vëh to koman rakah non a ö neꞌ se hikta vaen, eꞌ se kon rakah o vavaasis va pa taateꞌ hikta vaen.” ");
INSERT INTO tpz_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ka napan meeme ee maꞌ po siꞌ koaꞌ sosoneꞌ manih pe Ieesuꞌ, pan eꞌ se vahoꞌ a koreneah manih pee, ko hin suk raoe. Ivëhkëk, a ma vamomhë peꞌ to siröꞌ ee pa napan poë varih. ");
INSERT INTO tpz_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ivëhkëk, e Ieesuꞌ to pënton, pareꞌ soe ke rapoë pan, “Eöm se koe a sunpip o siꞌ koaꞌ varih, paröm koe raoe, kee nö maꞌ peöꞌ. Suk ataeah, a Matop Vih va pa Vöön va Kin to teꞌ suk non o teꞌ to teꞌ va ne manih po siꞌ koaꞌ varih.” ");
INSERT INTO tpz_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","E Ieesuꞌ to vaket non po koaꞌ, pareꞌ tapui en pee, ko këh en pee, ko nö en. ");
INSERT INTO tpz_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ka pah teꞌ nö maꞌ manih pe Ieesuꞌ, pareꞌ hi poan pan, “Apuh, ataeah to vih non nöꞌ se nok, paröꞌ kon o toꞌtoꞌ tamoaan?” ");
INSERT INTO tpz_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ke Ieesuꞌ piun poan, pareꞌ soe pan, “Vahvanih kën hi a neoꞌ pan, ataeah to vih non? E Sosoenën varoe ko a paeh to vih non. Ivëhkëk, eën se iu kon nom o toꞌtoꞌ tamoaan, eën se vatet rakah a taateꞌ pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ka teꞌ pamëh hi en pe Ieesuꞌ pan, “A taateꞌ poanheh?” Ke Ieesuꞌ piun, pareꞌ soe pan, “Koe a ip vamët a meh teꞌ, koe a nok a taateꞌ rëhrëh, koe a kaveo, koe a piuk a meh teꞌ pën manih po vahutët, ");
INSERT INTO tpz_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","parën ta nom e tamömah pen e sinömah, ko iu a meh teꞌ vamanih pö nën to iu hah va ka nom.” ");
INSERT INTO tpz_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","A teꞌ pamëh to soe hah en pan, “A ma taateꞌ kurus varih nöꞌ to vavatet e noꞌ sih, ka meh taeah poꞌ nöꞌ se nok?” ");
INSERT INTO tpz_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ke Ieesuꞌ soe ke poꞌ poan pan, “Eën se keh iu kon nom o toꞌtoꞌ tamoaan, eën se nö, parën vavoen vahik a ma tah varih nën to vaneah nom, parën kon a moniꞌ, ko vaꞌaus o teꞌ arus. Eën se keh vatet rakah a ma taateꞌ varih nöꞌ to soe, parën suk a maꞌ neoꞌ. A, a ma tah kokoek pën nën se kon amot eom peꞌ manuh pa vöön va kin. ");
INSERT INTO tpz_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ka teꞌ pamëh pënton a soe pe Ieesuꞌ, pareꞌ pah tamak suntan en, suk eꞌ to vaneah non a ma tah to parin a peo vörep. ");
INSERT INTO tpz_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ke Ieesuꞌ soe ke ra ma vamomhë peꞌ pan, eöꞌ to soe vaman rakah keoꞌ peöm, “Eꞌ to hivaꞌ rakah ke non pa teꞌ öt ö pa ho manih pa koman a Matop Vih va pa Vöön va Kin, suk o toꞌtoꞌ peꞌ to pet vaviꞌ e non pa moniꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Eöꞌ se soe haha kuru, eꞌ to teꞌ tö rakah ke non pa këmol pa hop koe manih pa töhkoꞌ vëh to teꞌ non pa ni kunkun. Ivëhkëk, eꞌ to hivaꞌ oah rakah e non pa teꞌ öt ö to kehkeh hop non manih pa Matop Vih pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ka ma vamomhë peꞌ pënton a soe vaꞌih, pare pah töhkak ee pare soe pan, “Eꞌ se keh teꞌ va non nën, keteh se poꞌ kon o toꞌtoꞌ tamoaan?” ");
INSERT INTO tpz_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ke Ieesuꞌ ves rakah non manih pee, pareꞌ soe ke rapoë pan, “A ma tah varih no a napan to hikta onöt ne a nok, ivëhkëk, e Sosoenën to onöt e non pa nok a ma moeh tah kurus. ");
INSERT INTO tpz_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","E Ieesuꞌ to soe vamanih ke Pitaꞌ piun poan, pareꞌ soe pan, “Ep ah! Emöm se poꞌ kon ataeah manih pa ö nemöm to këh voh maꞌ a ma tah pemöm, pamöm suk maꞌ oah?” ");
INSERT INTO tpz_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ke Ieesuꞌ piun poan pareꞌ soe pan, “Eöꞌ to soe vaman rakah keoꞌ peöm. O poen no oeh me akis vëh se tavus vavoon hah, eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus se kon o ëhnan apuh, paröꞌ ihoꞌ pa ö ihihoꞌ peöꞌ, peöꞌ e Sunön. Ke eöm kurus varih to vatet voh a maꞌ neoꞌ, eöm se ihoꞌ me em pa havun me ra poa ö ihihoꞌ pa teꞌ sunön. Paröm matop e nem po havun me ro pöök vuteꞌ va Israël. ");
INSERT INTO tpz_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ka napan varih to vatet voh a maꞌ neoꞌ, pare këh maꞌ a ma iuun pee, me ra ma kën kea pee, me ra kën vameere, me a ma sinëëre, me ra ma tamëëre, me ra ma pus koaꞌ pee, me ra ma tökiu pee. Ee se kon oah rakah ee pa ma tah varih nee to këh voh maꞌ, pare kon me ee po toꞌtoꞌ tamoaan. ");
INSERT INTO tpz_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ivëhkëk, o teꞌ varih to vovoh ne kuru manih po oeh, amot nee se vasuksuk varuꞌ hah ne maꞌ, ko teꞌ varih to vasuksuk ne kuru, amot nee se vovoh varuꞌ ne.” ");
INSERT INTO tpz_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pan, “A Matop Vih va pa Vöön va Kin to teꞌ va non manih. Pa pöstakah rakah ne tövaneah pa tökiu voaën to nö pa kon ta ma teꞌ se nö maꞌ, pare kiu manih po tökiu peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","E tövaneah po tökiu to vaonöt ke ra nap kiu a ö nee se kiu keꞌ voen rapoë pa ma 1 kinaꞌ pa pah potan. Pareꞌ vanö en pee, kee nö ee pa kiu manuh po tökiu peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pa pöstakah avoeꞌ pamëh pa 9 kirök neꞌ to hah en manuh pa ö totoaan, pareꞌ taum o upöm teꞌ to susun pinpiun vah ne nën. ");
INSERT INTO tpz_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Eꞌ to soe ke rapoë pan, ‘Eöm se nö manuh po tökiu voaën peöꞌ, paröm kiu köꞌ voen antoen eoꞌ peöm pa ma kiu nöm to nok. ");
INSERT INTO tpz_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ee to nö ee pa kiu. Pa 12 kirök me pa 3 kirök pa matanpoen ne tövaneah po tökiu voaën to nö hah en pa ep këh ta ma meh teꞌ se nö maꞌ ko kiu manih po tökiu peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","A potan to vatët non pa 5 kirök neꞌ to hah en manuh pa ö totoaan. Pareꞌ taum o upöm teꞌ to susun pinpiun avoeꞌ vah e ne nën, pareꞌ soe ke rapoë pan, ‘Vahvanih köm susun pinpiun vah va nem manih pa potan avoes vëh?’ ");
INSERT INTO tpz_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Kee soe ke poë pan, ‘Suk ahikta teꞌ to kon a möm temöm kiu manih peꞌ.’ Keꞌ soe poꞌ ke rapoë pan, ‘A, eöm se nö manuh po tökiu voaën peöꞌ, paröm kiu nën.’ ");
INSERT INTO tpz_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Pa 6 kirök pa matanpoen e tövaneah po tökiu voaën to soe ke susun pa nap kiu peꞌ pan, ‘Vaoe na a nap kiu kee nö maꞌ kën voen raoe. Eën se taneo maꞌ manuh pa nap kiu suksuk, parën vahik manih pa nap kiu vovoh.’ ");
INSERT INTO tpz_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ko teꞌ varih to taneo kiu pa 5 kirök pa matanpoen to nö maꞌ, pare kon ee pa ma 1 kinaꞌ pee. ");
INSERT INTO tpz_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ko teꞌ teꞌ varih to kiu vovoh to nö maꞌ pare koman ne pan ee se kon vaꞌpuh. Ivëhkëk, ahik, ee me to kon ee pa ma 1 kinaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ee to kon vahik ee pa ma voen pee, pare taneo ee pa vaato vasukaꞌ me tövaneah po tökiu. ");
INSERT INTO tpz_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ee to soe ke poë pan, ‘O teꞌ varih to kiu suksuk, pare kiu ro a paeh aoaꞌ, ee to kon ee po voen nemöm to kon. Emöm to kiu rakah em pa potan avoes, taneo non pa pöstakah, pareꞌ öök non pa matanpoen, a potan to pa vakmis rakah en pemöm. Ivëhkëk, eën to voen va eom pee manih pa ö nën to voen va ka möm.’ ");
INSERT INTO tpz_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ivëhkëk, e tövaneah po tökiu to piun a pah teꞌ kikiu, pareꞌ soe ke poan pan, ‘Kea, eöꞌ to hikta nok vahat a neöm, ea to vaonöt pöꞌ vur ee pa 1 kinaꞌ nöm se kiu suk ko kon, keꞌ ataeah? ");
INSERT INTO tpz_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kon o voen pën, parën nö na vöön. O iu koman peöꞌ köꞌ voen eoꞌ po teꞌ varih to suk tavus maꞌ pa kiu po vu voen vëh nöm to kon. ");
INSERT INTO tpz_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Eꞌ kök kës e non pa taateꞌ pö nöꞌ to ki va in a moniꞌ peöꞌ manih po iu koman peöꞌ, keꞌ ataeah? Eöꞌ to kehkeh vataare noꞌ a taateꞌ vih peöꞌ manih pa napan kurus, kën heheve suk poꞌ nom ataeah?’ ");
INSERT INTO tpz_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ke Ieesuꞌ soe pan, “Eꞌ to teꞌ akuk va kov e non manih po teꞌ varih to vöknah ne a ma taateꞌ pee, amot ne Sosoenën se vahoꞌ en pee manih po vovoh. Ko teꞌ varih to kë koman hah a ne, amot ne Sosoenën se vahoꞌ rakah en maꞌ pee manuh po suksuk.” ");
INSERT INTO tpz_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","E Ieesuꞌ to soe vahik a soe vapipinoꞌ vaꞌih, pareꞌ nönö avoeꞌ nö e non manuh Jerusalëm, ko me en pa ma vamomhë peꞌ. Ee to nönö nö ne, keꞌ me ke en pa havun me ra poa vamomhë peꞌ, pareꞌ soe ke rapoë pan, ");
INSERT INTO tpz_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Pënton öm pa tah söꞌ soe ka neöm. Kuru na to nönö no Jerusalëm. Ka napan varih to hat ov a no neöꞌ e Koaꞌ Teꞌ pa Napan Kurus se heꞌ ee peöꞌ manih pa koreero teꞌ susunön ësës heꞌ, me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës. Kee vahoꞌ ee peöꞌ po vahutët, pare vaonöt ee pa ip vamët a neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ee se heꞌ a neoꞌ manih pa koreero upöm teꞌ to hikta teꞌ ne pan ee ro Jiuꞌ. Ko teꞌ poë varih se kö a neoꞌ, pare rëp a neoꞌ po uris. Pare ni ee peöꞌ pa kuruse. Ivëhkëk, po vakön poen ne eöꞌ se sun taneꞌ hah eoꞌ maꞌ po vapeepe.” ");
INSERT INTO tpz_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","E Ieesuꞌ to soe vahik ke ra ma vamomhë peꞌ a ma soe varih, ke köövo pe Sëbëdiꞌ nö vaꞌpeh me en maꞌ pa poa sunaiꞌeah, pareꞌ vatokon manih pa matan e Ieesuꞌ, pareꞌ hi poan a ö neꞌ se heꞌ a poa koaꞌ peꞌ ta tah. ");
INSERT INTO tpz_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ke Ieesuꞌ hi poan pan, “Eën iu nom ataeah?” Ke köövo pe Sëbëdiꞌ piun a hi peꞌ, pareꞌ soe pan, “Soe vaman rakah ka neoꞌ ah, amot nën se tavus a teꞌ sunön va Israël, ka poa koaꞌ peöꞌ teꞌ vaꞌpeh me a nom oah manih pa Matop Vih pën. A paeh se ihoꞌ non manih pa papmatö pën, ka meh ihoꞌ non manih pa papkiruk pën.” ");
INSERT INTO tpz_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ke Ieesuꞌ pënton a hi pamëh, pareꞌ tarih manih pe Jëmis pen Jon, ko soe ke rapoë pan, “Eöm to hikta nat vavih nem pataeah nöm to ihi nem pom. Eöm antoen kës e nem pa kaak pa kap vëh nöꞌ se kaak manih peꞌ. Paröm antoen kës e nem pa teꞌ o kamis vëh nöꞌ se teꞌ?” Kee soe ee pan, “A, emöm to onöt e nem.” ");
INSERT INTO tpz_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ke Ieesuꞌ piun rapoë, pareꞌ soe pan, “Oman, eöm to onöt e nem pa kaak taneꞌ manih pa kap peöꞌ. Ivëhkëk, eöꞌ to hikta teꞌ me noꞌ to kikis marën a kon eteh se ihoꞌ manih pa papmatö peöꞌ me a papkiruk peöꞌ. Ahik! E Tamön koman se heꞌ a poa ö ihihoꞌ poë varih manih pe retereh neꞌ to vamatop keon ke voh en pee. ");
INSERT INTO tpz_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","A meh havun vamomhë to pënton a soe vaꞌih, pare pah heve ov e ne pa poa tom mahin. ");
INSERT INTO tpz_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ivëhkëk, e Ieesuꞌ to vaoe ununun en pa ma vamomhë peꞌ, kee tönun ee maꞌ manih peꞌ, keꞌ soe ke rapoë pan, “Eöm nat e nem, po teꞌ susunön va po teꞌ varih to hikta teꞌ ne ro Jiuꞌ to hikta vaman ne e Sosoenën, pare matop vakis rakah e ne pa napan pee. Me o upöm teꞌ apaꞌpuh pee to kikis rakah ov e ne pa napan pee se vavatet ne a ma soe pee. ");
INSERT INTO tpz_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Köꞌ iu noꞌ a taateꞌ teꞌteꞌ vasusunön se nat non teꞌ non topniineöm. Ivëh, keteh to kehkeh tavus non a teꞌ sunön manih peöm, eꞌ se teꞌ non a teꞌ kikiu peöm kurus. ");
INSERT INTO tpz_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Keteh to kehkeh vovoh non manih peöm, eꞌ se tavus a teꞌ kikiu akuk manih peöm. ");
INSERT INTO tpz_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Eꞌ to teꞌ akuk va kov e non manih peöꞌ e Koaꞌ Teꞌ pa Napan Kurus to hikta nö voh maꞌ pan a napan se kiu vaꞌaus a ne neoꞌ. Ahik, eöꞌ to nö voh maꞌ pa vaꞌaus raoe, me eöꞌ se heꞌ o toꞌtoꞌ peöꞌ manih pa ö ne eöꞌ se mët marën a hehe a napan varih no a taateꞌ hat to nohnoh non rapoë.” ");
INSERT INTO tpz_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","E Ieesuꞌ me ra ma vamomhë peꞌ to këh ee pa vöön va Jerikoꞌ ka nap peo rakah suk ee maꞌ peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","A poa teꞌ kehoꞌ to ihoꞌ ne sinten hanan to pënton a soe to soe non pan e Ieesuꞌ to oꞌoah nö non. Ee to taneo ee pa kokoeꞌ suk na poë pan, “Koaꞌ supnaiꞌ pe Devit, ururuan a möm ah.” ");
INSERT INTO tpz_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","A napan to pënton rapoë pon to kokoeꞌ suk nö ne maꞌ, pare siröꞌ rapoë pon ko soe pan, “Vatotomin öm pom.” Ivëhkëk, ee pon to pah kokoeꞌ suntan avoeꞌ suk nö e ne maꞌ pan, “Sunön Koaꞌ supnaiꞌ pe Devit, ururuan a möm ah.” ");
INSERT INTO tpz_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","E Ieesuꞌ to sun en, pareꞌ vaoe en na pee pon, pareꞌ hi rapoë pan, “Eöm iu nem ataeah ne eöꞌ se nok manih peöm?” ");
INSERT INTO tpz_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kee soe maꞌ pan, “Sunön, emöm to iu nem a ö nën se kap hah a ma matanmöm.” ");
INSERT INTO tpz_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ke Ieesuꞌ tamak rakah en pee pon, pareꞌ vaket pa poa matëëre, ka varuꞌ rakah vakomanih, no a ma matëëre to takap hah ee, kee ep vavih hah ee. Pare vatet ee pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","E Ieesuꞌ me ra ma vamomhë peꞌ to këh ee maꞌ pa vöön va Jerikoꞌ, pare öök vatët ee manih Jerusalëm. Ee to vos momoaan ee pa vöön nee to pokaꞌ ne Bëtfes, a vöön pamëh to teꞌ non Tope Öliv. Ee to teꞌ ne nën, ke Ieesuꞌ vanö vovoh en pa poa vamomhë peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Pareꞌ soe ke rapoë pan, “Nö na manuh pa vöön vöh na to ep no na. Eöm se nö nën, paröm taum a tönkiꞌ nee to nohtöön poë po uris, keꞌ sun vaꞌpeh me non e koaꞌ peꞌ. Paröm ihan raoe, ko me maꞌ raoe manih peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ka ta pah teꞌ se keh hi a neöm ta hi, köm soe ke eah pan, ‘E Topoan to teꞌ me non a kiu manih pee.’ Eꞌ se heꞌ vëvëhöꞌ hah en maꞌ pee.” ");
INSERT INTO tpz_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Eꞌ a tah pamëh se tanok ko vapuh rakah a soe no a teꞌ vanënën soe to soe voh. Eꞌ to soe voh pan, ");
INSERT INTO tpz_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Soe ke ra napan va Jerusalëm, ‘E sunön peöm to nö en maꞌ. Eꞌ to nö va maꞌ manih pa teꞌ akuk to hikta teꞌ me non to ëhnan, pareꞌ tok maꞌ pa tönkiꞌ sekaꞌ.’” ");
INSERT INTO tpz_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","A poa vamomhë peꞌ to nö, pare taum va ee manih pö neꞌ to soe va i rapoë. ");
INSERT INTO tpz_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ee to me ee maꞌ pa sinan tönkiꞌ me e koaꞌ peꞌ, pare pan a ma ohop rë manih pa tonun a poa tönkiꞌ, ke Ieesuꞌ tok poꞌ en. ");
INSERT INTO tpz_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ka napan o pöh peo rakah to ihan a ma ohop rërë pee, pare panpan ee manih hanan. Ko upöm moes maꞌ a ma pea naon, ko vahoꞌ ee manih hanan. ");
INSERT INTO tpz_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ka napan varih to vovoh nö ke ne e Ieesuꞌ, me ro teꞌ varih to suksuk nö ne maꞌ poë. Ee to tataoa nö ne maꞌ, pare sosoe va ne manih pan, “Vaeö ke na e Kristo, e Koaꞌ supnaiꞌ pe Devit! E Sosoenën to tapui a oah, suk eën to nö maꞌ pa ëhnan e Sunön. Vaeö rakah, ko kë a ëhnan e Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","E Ieesuꞌ to vos manuh Jerusalëm ka napan töhkak, pare vaiihi e ne pan, “A teꞌ vëh eꞌ rakah eteh?” ");
INSERT INTO tpz_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ka napan varih to tataoa nö ne soe ke rapoë pan, “A teꞌ vaꞌih, eꞌ e Ieesuꞌ, ka muhin peꞌ ivëh Galiliꞌ, ka vöön peꞌ ivëh Nasarët. Eꞌ a teꞌ vanënën soe pamëh ne Sosoenën to heꞌ voh a ra.’ ");
INSERT INTO tpz_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","E Ieesuꞌ to vos manuh Jerusalëm, pareꞌ ho koman Iuun Hinhin Apuh, pareꞌ veo tavus en pa napan to vavavoen ne a ma tah pee, Eꞌ to koep en pa ma pok po teꞌ varih to papanih moniꞌ ne. Pareꞌ koep en pa ma ö ihihoꞌ po teꞌ varih to vavavoen ne o panuh. ");
INSERT INTO tpz_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","E Ieesuꞌ to soe ke rapoë pan. “Manih po Puk Vapenpen no a teꞌ vanënën soe e Aisaëaꞌ to kiun voh to soe va non manih pan, ‘A iuun peöꞌ eꞌ a iuun hinhin pa napan kurus.’ Ivëhkëk, eöm to rih a iuun pe Sosoenën, paröm nok em peꞌ “A ö vavakoaan po teꞌ kakaveo.” ");
INSERT INTO tpz_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","E Ieesuꞌ to teꞌ non koman Iuun Hinhin Apuh, ka nap kekehoꞌ, me ro teꞌ hathat ma moe nö ee maꞌ manih peꞌ, keꞌ vavatoꞌ hah en pee. ");
INSERT INTO tpz_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","O teꞌ susunön ësës heꞌ, me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës to ep a ma tah vatoksean ne Ieesuꞌ to nok nën, pare tënan pet ee po koaꞌ to tataoa ne koman Iuun Hinhin Apuh, pare sosoe va ne manih pan, “Kë a ëhnan e Ieesuꞌ, eꞌ e Kristo e koaꞌ pe Devit.” A ma taateꞌ poë varih to vaheve rakah ee po teꞌ susunön ësës heꞌ, me ro teꞌ vavaasis varih to nat ne sih o Vavaasis pe Mosës. ");
INSERT INTO tpz_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","O teꞌ susunön ësës heꞌ, me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës to nö ee manuh pe Ieesuꞌ, pare hi poë pan, “Eën nat kës e nom pa tah no koaꞌ varih to sosoe ne, ha?” Ke Ieesuꞌ piun rapoë, pareꞌ soe pan, “A, eöꞌ to pënton e noꞌ, paröꞌ nat e noꞌ pa tah nee to sosoe ne. Ke eöm poꞌ, eöm to hikta ëh pöꞌ voh a soe to kiun non manih po puk pe Sosoenën to soe non pan, ‘Eën koman to vavaasis voh o koaꞌ sosoneꞌ rakah, pa kë a ëhnöömah.’” ");
INSERT INTO tpz_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Manih pa po poen pamëh ne Ieesuꞌ to këh en po teꞌ susunön ësës heꞌ, me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, pareꞌ nö en manuh Bëtaniꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","A muhin to takah en, ke Ieesuꞌ taneꞌ hah maꞌ manuh Bëtaniꞌ, ko nönö hah nö non manuh Jerusalëm, pareꞌ haraꞌ en po maë. ");
INSERT INTO tpz_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Eꞌ to ep a vu naon nee to pokaꞌ ne o fik to sun non sinten hanan, pareꞌ nö manuh pa vu naon pamëh, ivëhkëk, eꞌ to hikta teꞌ voaꞌ non. A uvin varoe ko neah to teꞌ non. Ke Ieesuꞌ soe ke o naon pamëh pan, “Eën hikta se vovoaꞌ amot hah nom.” Ka uvin o naon pamëh rak vëvëhöꞌ rakah en. ");
INSERT INTO tpz_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ka ma vamomhë ep a tah ne Ieesuꞌ to nok, pare pah toksean rakah ee. Pare vaiihi e ne pan, “Vahvanih ko naon vëh rak vëvëhöꞌ vamanih, pa soe akuk pe Ieesuꞌ?” ");
INSERT INTO tpz_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ke Ieesuꞌ piun a soe pee, pareꞌ soe pan, “Eöꞌ to soe vaman rakah keoꞌ peöm, eöm se keh teꞌ rakah me nem o vaman, paröm hikta teꞌ me nem ta ma kokoman peo. A, eöm to onöt e nem pa nok a taateꞌ nöꞌ to nok manih pa vu naon vëh, me a ma meh taneah nöm to onöt e nem pa nok. Eöm to onöt e nem pa taꞌ a tope vëh pan, ‘Sun ah parën vi kunah koman hah keo manuh koman tahiꞌ.’ Eꞌ se pënton en pa soe peöm. ");
INSERT INTO tpz_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Eöm se keh teꞌ rakah me nem o vaman, paröm hin manuh pe Sosoenën, eöm se kon em pataeah nöm to hinhin suk nem.” ");
INSERT INTO tpz_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","E Ieesuꞌ to ho hah en manuh koman a Iuun Hinhin Apuh, pareꞌ vavaasis non a napan nën. Ko teꞌ susunön ësës heꞌ, me ro teꞌ susunön po Jiuꞌ nö maꞌ manih peꞌ, pare hi poë pan, “Soe ka möm ah. A tasun taeah nën to teꞌ me nom parën nonok nom a ma kiu varih? Eteh to heꞌ a oah a tasun pamëh?” ");
INSERT INTO tpz_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ke Ieesuꞌ piun rapoë pareꞌ soe pan, “Eöꞌ me se hi a neöm ta teꞌ hi, eöm se keh piun em peöꞌ, a, eöꞌ me se soe keoꞌ peöm peteh to heꞌ a neoꞌ a tasun, köꞌ nonok noꞌ a ma kiu varih. ");
INSERT INTO tpz_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Soe ka neoꞌ öm, a tasun vëh pa pupui a napan ne Jon Tövapupui to heꞌ voh, taneꞌ maꞌ pe Sosoenën, keꞌ, eꞌ taneꞌ maꞌ manih pa napan ah?” O teꞌ susunön ësës heꞌ, me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, to vaiihi koman suk e ne pa hi pe Ieesuꞌ, pare sosoe ne pan, “Ea se keh soe pan a kiu ne Jon to nonok non to taneꞌ maꞌ manuh pe Sosoenën, keꞌ soe en pan, ‘Vahvapoꞌnih ka hikta vaman no e Jon?’ ");
INSERT INTO tpz_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ka se keh soe ee pan, ‘Eꞌ a kiu pa teꞌ.’ A, ea se nanaöp e no pa napan se ip ee pea, suk ee to vaman e ne pe Jon a teꞌ vanënën soe.” ");
INSERT INTO tpz_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kee piun e Ieesuꞌ, pare soe pan, “Emöm to hikta nat nem.” Ivëh, ke Ieesuꞌ soe ke poꞌ rapoë pan, “Eöꞌ me hikta se soe ka noꞌ neöm peteh to heꞌ a neoꞌ a tasun vaꞌih köꞌ nonok noꞌ a ma kiu varih.” ");
INSERT INTO tpz_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe ke poꞌ o teꞌ susunön ësës heꞌ, me ro teꞌ susunön po Jiuꞌ va Israël pan, “Eöm koman va poꞌ nem nih pa ö no a pah teꞌ to teꞌ me non a poa koaꞌ oeteꞌ peꞌ. Ko pöh poen ne tamëëre to nö manuh pe koaꞌ vamomoaan, pareꞌ soe pan, ‘Koaꞌ peöꞌ, kuru nöꞌ to iu noꞌ a ö nën se nö manuh po tökiu voaën peöꞌ parën kiu maꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ke sunaiꞌeah vaꞌsik en. Pareꞌ teꞌ non, ko panih o kokoman peꞌ ko nö hah en pa kiu. ");
INSERT INTO tpz_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Vasuksuk ne tamëëre to nö en manuh pe meh sunaiꞌeah, pareꞌ soe ke poan pan, ‘Koaꞌ peöꞌ, kuru nöꞌ to iu noꞌ a ö nën se nö parën kiu maꞌ manuh po tökiu voaën peöꞌ.’ Ke sunaiꞌeah manat en, ivëhkëk, eꞌ to koe en, pareꞌ hikta nö pa kiu.” ");
INSERT INTO tpz_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ke Ieesuꞌ hi poꞌ en pee pan, “Eteh rakah pa poa koaꞌ varih to pënton a soe pe tamëëre?” Kee piun a soe pe Ieesuꞌ, pare soe pan, “E koaꞌ vamomoaan.” Ke Ieesuꞌ soe ke rapoë pan, “A, eöꞌ to soe vaman rakah keoꞌ peöm. A nap kokon takis, me ra nap rëhrëh se vovoh ke peöm manuh pa Matop Vih va pa Vöön va Kin, suk ee to tamak a ma taateꞌ hat pee, pare panih ee. ");
INSERT INTO tpz_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","E Jon to nö voh maꞌ pa vataare a neöm a taateꞌ totoopin, köm hikta vaman voh eah. Ivëhkëk, a nap kokon takis me ra nap rëhrëh to tënan voh a soe pe Jon, pare vaman e peꞌ. Eöm to pënton voh em po vavaasis pamëh, ivëhkëk, eöm to rës e nem pa panih a ma taateꞌ hat peöm, paröm vaman.” ");
INSERT INTO tpz_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","E Ieesuꞌ to vavaato avoeꞌ me e non po teꞌ susunön ësës heꞌ, me ro teꞌ susunön po Jiuꞌ, pareꞌ soe pan, “Eöm se pënton vavih rakah nem po vahutët vaꞌih nöꞌ se soe ka neöm. A pah teꞌ to nep voh a rak voaën, pareꞌ eean tavi poan. Pareꞌ een a koveꞌ marën a vahoꞌ a ma voaꞌ voaën nën, pareꞌ kom ko hun tavus maꞌ. Eꞌ to eok en pa iuun no a teꞌ se teꞌ non, pareꞌ ut non pa rak voaën pamëh. Pareꞌ heꞌ en po upöm teꞌ, kee kiu moniꞌ e ne manih peꞌ, eꞌ he nö varo en pa meh muhin. ");
INSERT INTO tpz_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Vasuksuk poꞌ no a voaꞌ to vamatop ee pa oes, ke tövaneah pa rak voaën vanö en maꞌ pa ma teꞌ kikiu peꞌ manih po teꞌ varih to matop ro ne pa rak voaën, pan ee se teꞌ ke poë ta ma teꞌ voaꞌ voaën va pa rak peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ivëhkëk, o teꞌ varih to vaneah ro ne pa nep voaën to öt a ma teꞌ kikiu pe tövaneah pa rak voaën, pare vakmis ee pee, ko ip vamët ee pa meh. Ka vakön teꞌ kikiu nee to tösvös poë, keꞌ mët en. ");
INSERT INTO tpz_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ke tövaneah pa rak voaën vanö hah en po upöm teꞌ kikiu peꞌ to peo oah e ne pa ma teꞌ varih neꞌ to vanö moaan manuh po teꞌ varih to matop ro ne a rak voaën. Ka napan varih to matop ro ne pa rak voaën nok va ee pee manih po teꞌ varih to vovoh moaan maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","E tövaneah pa rak voaën to koman en pa vanö maꞌ e koaꞌ koman peꞌ. Eꞌ to koman non pan a napan varih to matop ro ne pa rak voaën se ta e ne pe sunaiꞌeah. ");
INSERT INTO tpz_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ivëhkëk, a napan varih to matop ro ne pa rak voaën to ep i na e koaꞌ peꞌ to nö maꞌ, pare soe va ee manih pan, ‘Ivaꞌih e koaꞌ peꞌ. Ka rak voaën vaꞌih se vaneah amot e non peꞌ. Ea se keh ip vamët eah, ko vaneah varuꞌ e no pa rak voaën vaꞌih.’ ");
INSERT INTO tpz_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ivëh, ka napan varih to matop ro ne a rak voaën öt e koaꞌ pamëh, pare vi tavus këh ee peꞌ pa rak, ko ip vamët ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ke tövaneah pa rak voaën se poꞌ nok vah va i ra napan varih nih to matop ro ne a rak peꞌ pö neꞌ se hah ma?” ");
INSERT INTO tpz_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ko teꞌ susunön ësës heꞌ, me ro teꞌ susunön po Jiuꞌ soe ke Ieesuꞌ pan, “Eꞌ se ip vamët vahik rakah en po teꞌ hat poë varih. Pareꞌ heꞌ en pa rak voaën pamëh manih po upöm teꞌ, kee matop ro ne. Ko poen nee se oes a voaën, ee se heꞌ ee peꞌ a ma teꞌ voaꞌ voaën va pa rak pamëh.” ");
INSERT INTO tpz_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ke Ieesuꞌ soe ke rapoë pan, “Eöm to hikta ëh pöꞌ voh a soe vaꞌih to kiun non po Puk Vapenpen to soe suk voh non e Kristo, pareꞌ soe non pan, ‘A vös vaꞌih no a nap ekeok to vi tavus in, to tavus en a vös vamomoaan vëh to toon vakis non a iuun. E Sunön to nok a vös pamëh, keꞌ tavus en o toon to toon vakis non a iuun, pareꞌ paraꞌ ep vamanin manih pa mataara.’ ");
INSERT INTO tpz_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ivëh, köꞌ se soe rakah keoꞌ peöm, e Sosoenën se kon këh en peöm pa Matop Vih peꞌ, pareꞌ heꞌ en peꞌ manih pa napan varih to tëtënan ne a ma soe peꞌ, pare vavatet ne. ");
INSERT INTO tpz_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ka teꞌ to kuꞌ, pareꞌ vuꞌ na pa tonun vös pamëh eꞌ se takök vatam en. Ivëhkëk, a vös pamëh se keh vuꞌtöön na ta teꞌ. A teꞌ pamëh se kakaaroe rakah en.” ");
INSERT INTO tpz_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","O teꞌ susunön ësës heꞌ, me ro Parësiꞌ to pënton a soe vapipinoꞌ ne Ieesuꞌ to nonok non, pare nat ee pe Ieesuꞌ to huh e non pee pa soe vapipinoꞌ pamëh. ");
INSERT INTO tpz_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Eꞌe to kehkeh öt e ne pe Ieesuꞌ. Ivëhkëk, ee to nanaöp e ne pa napan, suk a napan to vaman e ne pe Ieesuꞌ a teꞌ vanënën soe. ");
INSERT INTO tpz_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","E Ieesuꞌ to vavaato avoeꞌ me e non pa napan, pareꞌ hutët hah ken pee po moeh vahutët pa soe vapipinoꞌ, eꞌ to soe ke rapoë pan, ");
INSERT INTO tpz_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“A Matop Vih va pa Vöön va Kin to teꞌ va non manih pa teꞌ sunön to vamatop o vaënëën va po vaen pe sunaiꞌeah. ");
INSERT INTO tpz_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Eꞌ to vamatop vahik en, pareꞌ vanö en po vipuh manuh pa napan varih se nö maꞌ manih pa taëën pamëh. Ko poen no a taëën to vamatop vahik en, keꞌ vanö en pa nap kiu peꞌ, kee nö ee ko vaoe ee maꞌ po teꞌ varih neꞌ to vanö voh o vipuh manih pee. Ivëhkëk, ee to koe ee pa nö maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Vasuksuk neꞌ to vanö en po upöm teꞌ kikiu peꞌ, pareꞌ soe ke rapoë pan, “Soe ke ro teꞌ varih na to vanö voh o vipuh manih pee, pan, “A taëën to vamatop vahik en. Emöm to ip em pa kaöꞌ vusvus, ka ma moeh tah kurus vamatop vahik ee. Ke sunön peöꞌ to iu non a ö söm nö maꞌ pa taëën va po vaen pe sunaiꞌeah.” ’ ");
INSERT INTO tpz_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ivëhkëk, a napan to hikta nö maꞌ. E tövaneah pa taëën to vanö voh o vipuh manih pa napan, kee pënton varo ee pa soe peꞌ, pare vanönö ee pa nok a ma kiu pee. A paeh to nö en po tökiu peꞌ. Ka meh nö en pa matop a sitoaꞌ peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ko upöm öt a ma teꞌ kikiu pe tövaneah pa taëën, pare ip naon rapoë, kee mëtmët ee. ");
INSERT INTO tpz_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","A teꞌ sunön to pënton a tah vaꞌih to tanok manih pa nap kiu peꞌ, pareꞌ pah heve suntan en. Eꞌ to vanö en pa nap vëvënsun peꞌ, kee ip vahik rakah ee pa napan varih to ip a nap kiu peꞌ, pare ës ee pa ma vöön pee. ");
INSERT INTO tpz_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ivëh, ka teꞌ sunön soe ke ra nap kiu peꞌ pan, ‘A taëën va po vaen pe koaꞌ peöꞌ to vamatop vahik en. Ivëhkëk, a napan varih nöꞌ to vanö o vipuh peöꞌ manih pee, ee to hikta vih onöt ne a nö maꞌ pa taëën pamëh. ");
INSERT INTO tpz_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ivëh, köꞌ iu noꞌ a ö nöm se nö manuh pa ma sinten hanan, paröm vaoe maꞌ ere tereh nöm to ep. Paröm soe ke raoe kee nö maꞌ pa taëën peöꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ka nap kiu pa teꞌ sunön suk ee pa ma hanan. Pare meeme ee maꞌ pere tereh nee to onöt ne a taum. O teꞌ vihvih me ro teꞌ o hathat, kee nö ee maꞌ ka iuun no a taëën va po vaen to teꞌ non puh rakah en pa napan. ");
INSERT INTO tpz_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ka teꞌ sunön ho en koman iuun pa ep pa napan varih to nö maꞌ, pareꞌ ep in a pah teꞌ to teꞌ non nën to hikta hop maꞌ to ohop va pa taëën va po vaen. ");
INSERT INTO tpz_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ka teꞌ sunön pamëh soe ka teꞌ pamëh pan, ‘Kea, eën ho vah va maꞌ nih manih? Eën to hikta ohop nom o ohop va pa taëën va po vaen.’ Ivëhkëk, a teꞌ pamëh to hikta soe ta tah. ");
INSERT INTO tpz_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ivëh, ka teꞌ sunön soe ke ra nap kiu peꞌ pan, ‘Öt öm a teꞌ vëh, paröm nohnoh a poa koreneah me a poa moneah, paröm vi tavus na eah manuh pa vöön popoen. Manih pa vöön popoen pamëh no a napan se vaokook kov e ne, pare vakuskus rivon kov e ne po kamis.’ ");
INSERT INTO tpz_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","E Ieesuꞌ to heꞌ vahik a soe vapipinoꞌ peꞌ, pareꞌ vamaaka en pa pusun in a soe pamëh, pareꞌ soe ke ra napan pan, “E Sosoenën to iu non sih a nap peo se nö maꞌ manih pa iuun peꞌ. Ivëhkëk, a ma siꞌ pah teꞌ ro to tënan o vipuh peꞌ, ee o teꞌ poë varih ne Sosoenën to pitöꞌ koman voh en pee.” ");
INSERT INTO tpz_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","O Parësiꞌ to këh ee pe Ieesuꞌ to vavaasis non a napan, pare nok ee po kokoman va pa ö nee se punöꞌ poë po vahutët, ko vahoꞌ poë po vahutët suk a ma soe koman peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ee to nö, pare vanö ee maꞌ pa ma teꞌ vamomhë koman pee, me ro teꞌ varih to vavatet ne sih o kum pe Hëërot. Kee nö maꞌ manih pe Ieesuꞌ, pare soe pan, “Apuh, emöm to nat e nem pën a teꞌ sosoe man rakah. Pamöm nat e nem pën to vavaasis nom sih a napan a taateꞌ pe Sosoenën. Parën hikta nat nom pa koman varoe ta pah teꞌ, ko hikta nat nom pa soe ta pah soe manih pa teꞌ hikto ëhnan, me a teꞌ to teꞌ me non o ëhnan. ");
INSERT INTO tpz_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Soe ka möm ah, eꞌ vih kës e non pea pa heꞌ a takis manih pe Sisaꞌ, keꞌ a hik?” ");
INSERT INTO tpz_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ivëhkëk, e Ieesuꞌ to nat momoaan en pa ma kokoman po teꞌ poë varih to kehkeh punöꞌ ne poë, ivëh, neꞌ to soe suk va i ra poë manih pan, “Eöm o teꞌ o pöh pikpiuk rakah, eöm pupunöꞌ suk a no neoꞌ ataeah? ");
INSERT INTO tpz_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Vataare suk voh a neoꞌ öm ta pah moniꞌ va pa moniꞌ vëh nöm to tatakis nem sih.” Kee vataare ee peꞌ po pöh voaꞌ moniꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ke Ieesuꞌ hi en pee pan, “A ëhnan me o kahoꞌ peteh ivëh to teꞌ non pa moniꞌ vëh?” ");
INSERT INTO tpz_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kee piun e Ieesuꞌ, pare soe pan, “Pe Sisaꞌ.” Ke Ieesuꞌ soe ke poꞌ rapoë pan, “A tah to vaneah non pe Sisaꞌ nöm se heꞌ e Sisaꞌ. Ka tah to vaneah non pe Sosoenën nöm se heꞌ e Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ee to pënton a soe pe Ieesuꞌ, pare töhkak vahat rakah ee, ko këh ee peꞌ, pare vanönö ee. ");
INSERT INTO tpz_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Manih po poen avoeꞌ pamëh o Sëdiusi to nö maꞌ manih pe Ieesuꞌ. O Sëdiusi, ee o kum teꞌ to hikta vaman ne pan, a nap mët se sun taneꞌ hah ee manih po vapeepe, to hi poë a hi, pare soe pan, ");
INSERT INTO tpz_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Apuh, e Mosës to soe voh ka ra pan, ‘Ta pah teꞌ se keh mët akuk eꞌ hikta vatvus ta pah koaꞌ manih pe köövo peꞌ, ke kea peꞌ me hah e köövo amop peꞌ, pareꞌ vatvus a koaꞌ se kon a ëhnan e kea peꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Eꞌ to teꞌ voh non a kën tom mahin, a tönim koaꞌ me ra pöök. Ka teꞌ apuh vaen en, pareꞌ hikta vatvus ta koaꞌ eꞌ he mët en. Ivëh, ke kea peꞌ me hah en pe köövo ne kea apuh peꞌ to mët këh. ");
INSERT INTO tpz_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ke vapöök kea peꞌ mët pet en. Eꞌ he hikta vatvus avoeꞌ non ta koaꞌ, ka vakön kea pee nok pet va en nën. Keꞌe kurus rakah to mët vahik akuk rakah ee. Ee hikta vatvus ta pah koaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ke köövo amop pamëh pah mët suk poꞌ en pee kurus. ");
INSERT INTO tpz_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ivëh, ka nat e no pa tönim me ra poa teꞌ to vameeme petpet voh e ne pa pah köövo. Ko poen no a nap mët se sun taneꞌ hah manih po vapeepe, eteh rakah poꞌ se vaneah totoopin non pe köövo vëh, no a kën tom mahin varih to me voh ne?” ");
INSERT INTO tpz_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ke Ieesuꞌ piun rapoë, pareꞌ soe pan, “Eöm o teꞌ o nun rakah to hikta nat vavih nem pataeah no Puk Vapenpen to sosoe non sih, paröm hikta nat vavih me nem po kikis pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","O poen no a nap mët se sun taneꞌ hah maꞌ po vapeepe, a napan kurus hikta se vavaen hah ne. Suk ataeah, eꞌe se teꞌ va e ne manih po ankeroꞌ manuh pa vöön va kin. ");
INSERT INTO tpz_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Eöm hikta ëh pöꞌ voh a soe ne Sosoenën to sosoe voh ka non neöm pan, a nap mët se toꞌtoꞌ hah, pare sun hah ee. ");
INSERT INTO tpz_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","E Abraham, ke Aësak, ke Jekop to mët moaan rakah voh ee po poen ne Sosoenën to soe voh pan, ‘Eöꞌ e Sosoenën pe Abraham, me eöꞌ e Sosoenën pe Aësak, me eöꞌ e Sosoenën pe Jekop.’ Ke Sosoenën pamëh, eꞌ hikta teꞌ non pan eꞌ e Sosoenën pa nap mët. Ahik. Eꞌ e Sosoenën pa nap toꞌtoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","A napan to pënton a soe vaꞌih, pare pah toksean rakah ee po vavaasis pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","O Parësiꞌ to pënton ee pa ö ne Ieesuꞌ to sunpip rakah en po Sëdiusi pa ma soe peꞌ. Ko Sëdiusi hikta onöt ne a soe ta tah, suk e Ieesuꞌ to nok raoe, kee nun rakah ee. Ivëh, ko Parësiꞌ tönun hah me ee pe Ieesuꞌ, ");
INSERT INTO tpz_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","manih pee to teꞌ non a pah teꞌ to nat suntan rakah non o Vavaasis Pe Mosës. Ka to Parësiꞌ pamëh to kehkeh punöꞌ non e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Pareꞌ soe pan, “Apuh, a taateꞌ taeah to apuh oah non manih po Vavaasis pe Mosës?” ");
INSERT INTO tpz_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ke Ieesuꞌ piun poan, pareꞌ soe pan, “Eöm se iu rakah nem e Sunön Sosoenën peöm manih pa ma kupu peöm, me manih pa ma apeneöm, me manih pa ma kokoman peöm.” ");
INSERT INTO tpz_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ee ivarih, a ma taateꞌ to apuh oah ne a ma meh taateꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ka vapöök taateꞌ to vatoe e non pa ma taateꞌ vamoaan to soe va ne manih pan, ‘Eën se iu nom a meh teꞌ vamanih pa ö nën to iu hah va ka nom.’ ");
INSERT INTO tpz_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","A poa taateꞌ poë varih, ee a pusun rakah kov in a ma Vavaasis kurus pe Mosës, me a ma Soe po Teꞌ Vanënën Soe.” ");
INSERT INTO tpz_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","O Parësiꞌ to teꞌ tönun avoeꞌ e ne, ke Ieesuꞌ hi rapoë a hi vaꞌih, ");
INSERT INTO tpz_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Eöm koman va nem nih pe Kristo, eꞌ e koaꞌ peteh?” Ko Parësiꞌ piun poë, pare soe pan, “E Kristo, eꞌ e koaꞌ pe Devit.” ");
INSERT INTO tpz_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ke Ieesuꞌ hi hah en pee pan, “Suk ataeah, ka Tuvuh Vasioꞌ heꞌ voh o kokoman manih pe Devit, keꞌ pokaꞌ en pa teꞌ pamëh e Sunön peöꞌ? E Devit to soe vavoh manih komön a Puk Vaëhëh vamanih pan, ");
INSERT INTO tpz_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘E Sosoenën to soe ke Devit pan, “E Kristo e Sunön pën.” ‘Ke Sosoenën sosoe avoeꞌ ke non pe Kristo pan,’ “Ihoꞌ ah manih pa papmatö peöꞌ, ko teꞌ nom nën keꞌ onöt po poen nöꞌ se vahoꞌ o teꞌ varih to vakihat me a nom oah manih paan a matop pën.’” ");
INSERT INTO tpz_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“E Devit to popokaꞌ non sih e Ieesuꞌ Kristo e Sunön, ivëh, ke Kristo hikta teꞌ varoe non pan eꞌ e koaꞌ pe Devit. Ahik! Eꞌ to teꞌ me e non e Sunön peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ahik rakah ta paeh va po Parësiꞌ to piun a soe pe Ieesuꞌ. Taneo rakah non po poen pamëh no a hikta pah teꞌ nat to onöt non a hi hah e Ieesuꞌ ta ma meh hi. ");
INSERT INTO tpz_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Vasuksuk ne Ieesuꞌ to soe ke ra napan me ra ma vamomhë peꞌ pan, ");
INSERT INTO tpz_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“O teꞌ vavaasis varih to nat ne sih o Vavaasis pe Mosës, me ro Parësiꞌ pare öt ne a tasun va pa vamaaka a pusun in o Vavaasis pe Mosës manih pa napan. ");
INSERT INTO tpz_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ivëh, köm se tënan ko vatet em pa ma taneah nee to soe ka neöm. Ivëhkëk, eöm se nat nem vatet a ma taateꞌ nee to nonok ne. Suk ataeah, eꞌe to hikta vavatet ne a ma tah nee to vavaasis ne. ");
INSERT INTO tpz_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ee to nok ka neöm a ma taateꞌ kikis, pan eöm se vavatet nem. Ivëhkëk, eꞌe koman to hikta iu ne a vaꞌaus a neöm pa vatet vavih a ma taateꞌ poë varih. ");
INSERT INTO tpz_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“A ma tah kurus nee to nonok ne pan a napan se ep. Pare nat ne rapoë ro teꞌ vivihan. Ivëh, kee öt ne a ma siꞌ voh no a ma pah ö soe pe Sosoenën to kiun ne, pare noh a ma voh poë varih manih pa ma naire, keꞌ pa ma koreere. Pare ohop ne a ma ohop rë. Pare nok a ma ohop vihvih nee to hinhin me ne sih, ko uris rë nee to kun tonun po ohop pamëh. ");
INSERT INTO tpz_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ka manih pa ma taëën apaꞌpuh nee to iu ihoꞌ vovoh rakah ne pa ma ö ihihoꞌ po teꞌ susunön, me manuh koman a ma iuun hinhin soneꞌ pee, nee to iu rakah ne a ihoꞌ po matan. ");
INSERT INTO tpz_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pare iu rakah ne pan a napan se ta ne rapoë pa ma ö totoaan, pare popokaꞌ ne rapoë o teꞌ apuh. ");
INSERT INTO tpz_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ivëhkëk, eöm se nat nem koman nem pan a napan se popokaꞌ a non neöm ‘a Tövavaasis’, suk ataeah, e Sosoenën varoe ko a paeh a Tövavaasis peöm. Ke eöm kurus varih a kën tom kea. ");
INSERT INTO tpz_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Paröm nat nem pokaꞌ ta pah teꞌ va po oeh vëh ‘e Tamön’, suk ataeah eöm to teꞌ varoe me ko nem a pah Tamëneöm to teꞌ non pa vöön va kin, ivëh e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Paröm nat nem koman nem pan a napan se pokaꞌ a non neöm ‘o Sunön’, suk ataeah, a pah Sunön ro ko peöm, ivëh e Kristo. ");
INSERT INTO tpz_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ka teꞌ to apuh non manih peöm, eꞌ a teꞌ kikiu, eꞌ to kiu non manih peöm. ");
INSERT INTO tpz_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ka teꞌ se keh kë koman hah a non, e Sosoenën se vöknah en peꞌ. Ka teꞌ se keh vöknah hah a non, e Sosoenën se kë en peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","E Ieesuꞌ to toto avoeꞌ e non, pareꞌ soe pan, “Varenan rakah peöm varih o teꞌ vavaasis to nat nem o Vavaasis pe Mosës, me eöm o Parësiꞌ, eöm o teꞌ o mokoꞌ rivon rakah. Paröm pikpiuk, eöm rakah ko varih to susunpip nem a napan pa nö manuh pa Matop Vih va pa Vöön va Kin. O upöm teꞌ to kehkeh nö ne nën köm sosoepip e nem pee. Suk eöm to hikta onöt nem a nö nën. ");
INSERT INTO tpz_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Varenan rakah peöm varih o teꞌ vavaasis to nat nem o Vavaasis pe Mosës, me ro Parësiꞌ, eöm o teꞌ o pöh mokoꞌ rivon, paröm pikpiuk. Eöm to vavatvi kov e nem sih po oeh me manih tahiꞌ pan eöm se ep këh maꞌ ta ma teꞌ, kee suk a taateꞌ hat peöm. O poen nöm to taum em po teꞌ poë varih, eöm to vanun em pee. Ivëh, ke eöm kurus se nö em po suraꞌ ësës tamoaan. ");
INSERT INTO tpz_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Varenan rakah peöm varih o teꞌ vavaasis to nat nem o Vavaasis pe Mosës, me o Parësiꞌ, eöm o kekehoꞌ. Eöm to kehkeh vovoh ke nem sih a napan pa matop raoe, ivëhkëk, eöm to hikta onöt nem. Eöm me to sosoe nem sih pan, ta pah teꞌ se keh nok a soe man peꞌ manuh pa Iuun Hinhin Apuh pe Sosoenën marën a vakikis a soe peꞌ, eöm se soe em pan, eꞌ se vaörakuk en pa soe man peꞌ. Ivëhkëk, ta pah teꞌ se keh nok rakah a soe man peꞌ pan a gol to pet non pa Iuun Hinhin Apuh pe Sosoenën, a, eöm se soe em pan, eꞌ se vatet rakah a soe man peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","E Ieesuꞌ to toto avoeꞌ e non, pareꞌ soe pan, “Eöm rakah varih to teꞌ va nem manih pa ö no teꞌ ponkiꞌ komë to teꞌ va ne sih, paröm teꞌ pet va e nem manih po teꞌ kekehoꞌ. Ataeah to apuh non manih po epep pe Sosoenën, a gol, keꞌ a Iuun Hinhin Apuh? A gol to pet non sih manih pa Iuun Hinhin Apuh, pareꞌ teꞌ non a tah vivihan. Suk eꞌ to pet non pa iuun pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Keteh to nok a soe man peꞌ, pareꞌ vakikis na a soe pamëh manuh pa pok vapenpen pe Sosoenën, köm soe kem peꞌ pan, eꞌ se vaörakuk en pa soe man peꞌ. Ivëhkëk, eꞌ se keh vakikis na a soe man pamëh manuh po heꞌ to tok non pa pok vapenpen pe Sosoenën, a, köm soe kem peꞌ pan, eꞌ se vatet rakah a soe man peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Eöm o kekehoꞌ, ataeah to apuh non po epep pe Sosoenën, o heꞌ, keꞌ a pok vapenpen? O heꞌ to tok non pa pok vapenpen, pareꞌ teꞌ non a tah vivihan. ");
INSERT INTO tpz_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ivëh, ka teꞌ to nok a soe man peꞌ, pareꞌ vakikis a soe man peꞌ manuh pa pok vapenpen, eꞌ to vakikis a soe pamëh manuh pa pok vapenpen me a ma tah to tok ne nën. ");
INSERT INTO tpz_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ka teꞌ to nok a soe man peꞌ, pareꞌ vakikis a soe man peꞌ manuh pa Iuun Hinhin Apuh, eꞌ to vakikis a soe pamëh manuh pa Iuun Hinhin Apuh me a ma tah to pet ne nën. ");
INSERT INTO tpz_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ka teꞌ to nok a soe man peꞌ, pareꞌ vakikis a soe man peꞌ manuh pa vöön va kin, eꞌ to vakikis a soe pamëh manuh pe Sosoenën me a ö ihoꞌ peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Varenan rakah peöm o teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, me ro Parësiꞌ, eöm o teꞌ o pöh mokoꞌ rivon, paröm pikpiuk. Eöm to kökök nö nem sih a ma tah na to hovën marën a vaninin vih a taëën, a ma tah poë varih nöm to nep, paröm ununun a havun ö tah, ko kon taneꞌ a pah ö tah nën, ko heꞌ na e Sosoenën. Ivëhkëk, eöm to vanun voh em pa ma meh taateꞌ to teꞌ apuh oah ne a taateꞌ heꞌheꞌ. A ma taateꞌ apuh poë varih to teꞌ ne manih komön o Vavaasis pe Mosës. Ee ivarih a ma taateꞌ poë varih, a taateꞌ va pa vaꞌaus a ma teꞌ arus no a napan to kehkeh miröꞌ ne rapoë, me a taateꞌ ururuan, me a taateꞌ va pa vaman e Sosoenën. Eöm se vavatet rakah nem a ma taateꞌ poë varih, paröm heꞌheꞌ nem na e Sosoenën a pah ö tah nöm to kon taneꞌ manih koman a ma tah nöm to nepnep nem. ");
INSERT INTO tpz_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Eöm varih to iu matop nem sih a napan, ivëhkëk, eöm o kekehoꞌ. Paröm vavatet vatëh nem a taateꞌ heꞌheꞌ, ko vanun em pa ma taateꞌ apaꞌpuh. Ivëh, köm teꞌ va e nem manih pa teꞌ to kon taneꞌ a kuvi manih po kaak peꞌ. Ivëhkëk, eꞌ to hikta ep pet non pa tampu to teꞌ non po kaak, pareꞌ kaak vaꞌpeh me en peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Varenan rakah peöm varih o teꞌ vavaasis to nat i nem o Vavaasis pe Mosës, me ro Parësiꞌ, eöm o teꞌ o pöh mokoꞌ rivon, paröm pikpiuk. Eöm to pupui vavoon varoe nem a tonun a ma kap me o peret. Ivëhkëk, manih pa komëneöm no a taateꞌ hat, me a taateꞌ kaveo to puh rakah e non. ");
INSERT INTO tpz_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ke eöm varih o Parësiꞌ, eöm o kekehoꞌ, vamomoaan nöm se pupui vavoon a koman a ma kap, me a ma peret, kee teꞌ voon ne, köm pah pupui vavoon poꞌ a ma ö tonun. Eꞌ to teꞌ akuk va kov e non manih peöm. Eöm se panih momoaan a ma taateꞌ hat peöm, paröm vovoh poꞌ ke nem a napan. ");
INSERT INTO tpz_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Varenan rakah peöm o teꞌ vavaasis to nat i nem o Vavaasis pe Mosës, me ro Parësiꞌ, eöm o teꞌ o pöh mokoꞌ rivon, paröm pikpiuk. Eöm to teꞌ va nem manih pa koveꞌ teꞌ mët, paröm ep vavih e nem manih mahën, ivëhkëk, manih pa komëneöm, a koveꞌ teꞌ mët to teꞌ e non, köm kakaun a tonun a koveꞌ pamëh po uh kakaare. Ivëh, ka manih tonun a koveꞌ pamëh to parin a matan vavih rakah pa ep. Ivëhkëk, manih pa koman a koveꞌ pamëh to puh rakah non pa ma soaꞌ teꞌ me a ma tah koa. ");
INSERT INTO tpz_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Eꞌ to vatoe akuk va kov e non manih peöm no a napan to ep ka ne neöm ko koman ne pan, eöm o teꞌ to nonok nem a ma taateꞌ totoopin. Ivëhkëk, manih pa ma komëneöm to puh rakah ne pa ma piuk me a ma taateꞌ hat. ");
INSERT INTO tpz_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Varenan rakah peöm o teꞌ vavaasis to nat i nem o Vavaasis pe Mosës, me ro Parësiꞌ, eöm o teꞌ o pöh mokoꞌ rivon rakah, paröm pikpiuk. Eöm to nok vavavih a ma koveꞌ no teꞌ vanënën soe to mët ko pe ne, paröm vatëk vavavih o koveꞌ po teꞌ varih to nonok ne a ma taateꞌ totoopin to mët ko pe ne. ");
INSERT INTO tpz_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Paröm sosoe nem sih pan eöm se keh teꞌ voh nem po poen voh pa kën sipun, eöm to hikta onöt nem a vaꞌaus raoe pa ip vamët o teꞌ vanënën soe. ");
INSERT INTO tpz_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ivëh, ka soe koman peöm ivëh to vataare en peöm ivarih o pus koaꞌ po teꞌ varih to ipip vamët voh ne po teꞌ vanënën soe. ");
INSERT INTO tpz_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ivëh, köm vapuh rakah em pa taateꞌ hat voh pa kën sipuineöm. ");
INSERT INTO tpz_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Eöm to teꞌ rakah va e nem manih po kuruꞌ, eöm to hikta onöt nem a rusin këh e Sosoenën pö neꞌ se vanö a neöm manuh po suraꞌ ësës tamoaan. ");
INSERT INTO tpz_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ivëh, köꞌ se soe keoꞌ peöm pa tah vaꞌih, eöꞌ se vanö ka nös neöm o teꞌ vanënën soe, me ro teꞌ varih to teꞌ me ne a ma kokoman vih, me ro tövavaasis. Ka ma pa paeh va pee nöm se ip vamët. Paröm ni em po upöm pee manih pa kuruse. Paröm öt o upöm pee, ko rëp raoe po uris koman a ma iuun hinhin soneꞌ peöm. Ko nö vavah pa vaiu raoe pa ma vöön peöm marën a vakmis raoe. ");
INSERT INTO tpz_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ivëh, ka hat va pa napan varih to ip vamët voh o teꞌ vanënën soe, me ro teꞌ varih to nonok ne a ma taateꞌ totoopin, ne eöm varih se teen rakah. O teꞌ varih ne sipuineöm to ip vamët voh to taneo non manih pe Ebel, a teꞌ totoopin, pare ipip vamët voh ne sih o teꞌ vih poë varih, ko hik non manih pa mët pe Sakarias sunaiꞌ Berekiaꞌ. E Sakarias, eꞌ a teꞌ ësës heꞌ sunön po Jiuꞌ nee to ip vamët voh poë manih topnin a iuun pe Sosoenën me a pok vapenpen peꞌ. A taateꞌ va pa ip vamët o teꞌ ësës heꞌ sunön po Jiuꞌ, ne Sosoenën to vateꞌ voh manih po teꞌ to teꞌ toꞌtoꞌ ne kuru se kon kamis suk a ma teꞌ poë varih. ");
INSERT INTO tpz_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Eöm me to nonok e nem pa taateꞌ pamëh, ivëh, köꞌ soe vaman rakah keoꞌ peöm, e Sosoenën se vateen a neöm o Jiuꞌ pa ma mët poë varih, pareꞌ vakmis suk en peöm.” ");
INSERT INTO tpz_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pan, “Jerusalëm, Jerusalëm, eöm a ma nap susunön to töstösvös nem sih a ma teꞌ vanënën soe ne Sosoenën to vanö nös manem peöm. A ma poen peo neöꞌ to iu ununun noꞌ sih a ma koaꞌ pën, vamanih pa ö ne toaꞌ sin to ununun va non sih a ma soneꞌ peꞌ manih pa paan a paknaneah. Ivëhkëk, eöm to hikta iu nem. ");
INSERT INTO tpz_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Pënton nem öm, eöꞌ e Sunön to këh voh eoꞌ pa vöön peöm me a Iuun Hinhin Apuh peöm. ");
INSERT INTO tpz_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Eöꞌ to soe va keoꞌ peöm manih pan, eöm hikta se ep hah a nem neoꞌ manih po oeh vëh, keꞌ onöt rakah pa ö söꞌ hah va maꞌ manih pe Sunön peöm, köm soe em pan, ‘E Sosoenën se tapui a teꞌ vëh to nö maꞌ pa ëhnan e Sunön.’” ");
INSERT INTO tpz_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","E Ieesuꞌ to këkëh ko non a sinten a Iuun Hinhin Apuh, ka ma vamomhë peꞌ nö ee maꞌ manih peꞌ. Ko vataare poë a ma iuun va pa Iuun Hinhin Apuh. ");
INSERT INTO tpz_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ivëhkëk, e Ieesuꞌ to soe ke rapoë pan, “Eöꞌ to soe vaman rakah keoꞌ peöm, a ma iuun kurus varuh na to ep no, ee kurus se tatakök ee. Ahikta pah vös to onöt non a tok pa tonun a meh. Ahik. Eꞌe se taru kunah kurus ee maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Vasuksuk ne Ieesuꞌ to ihoꞌ non Tope Öliv, ka ma vamomhë varoe peꞌ nö ee maꞌ manih peꞌ, pare hi poë pan, “Soe ka möm ah o poen poanheh no a ma tah poë varih se tavus. Me o vëknöm taeoh nemöm se inan suk to tavus maꞌ, pamöm nat poꞌ o poen hah pën me o poen no oeh vëh se hik.” ");
INSERT INTO tpz_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Ke Ieesuꞌ piun rapoë, pareꞌ soe pan, “Matop vavih nem, ta pah teꞌ tomeꞌ piuk ka neöm. A nap peo rakah se nö maꞌ, pare popokaꞌ ne a ëhnaneoꞌ, pare soe vamanih pan, ‘Eöꞌ ivëh e Kristo’, pare piuk ee pa napan. ");
INSERT INTO tpz_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Eöm se tënan o vapus me o vahutët va po vapus, to nönö non maꞌ. Ivëhkëk, eöm se koe a naöp. A ma tah kurus poë varih se tavus ee. Ivëhkëk, o poen no oeh se hik to meꞌ e non pa tavus maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","A napan va pa pah muhin se sun, pare vapus me ee pa napan va pa meh muhin. Ka matop vih pa pah teꞌ sunön se sun, pareꞌ vapus me en pa teꞌ matop vih pa meh teꞌ sunön. Ka manih pa ma meh muhin no o maë apuh se tavus, ka rikrik kö en. ");
INSERT INTO tpz_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","A ma tah poë varih se tavus momoaan vamanih pa ö ne köövo to haraꞌ o kamis va pa ö neꞌ to kehkeh vahuh non.” ");
INSERT INTO tpz_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“O teꞌ se öt a neöm, pare vakmis ee peöm ko ip vamët ee peöm. A ma muhin kurus se heve ov e ne peöm, suk eöm to vaman, paröm vatet a nem neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Manih po poen pamëh, a nap peo rakah to vaman voh ee peöꞌ se tarih, ko vikuh ee peöm pa nap hat. ");
INSERT INTO tpz_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ko teꞌ vanënën soe pikpiuk se tavus maꞌ, pare piuk a ma nap peo rakah. ");
INSERT INTO tpz_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ka napan heꞌ tonun ee pa taateꞌ vih vëh, a taateꞌ iu teꞌ, suk a taateꞌ hat to pupu vaꞌpuh nö e non maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ivëhkëk, o teꞌ varih to teꞌ vakis ne pa teꞌ a ma punis, pare öök na po poen no o oeh se hik, e Sosoenën se hehe en pee. ");
INSERT INTO tpz_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ka Soe Vih va pa Matop Vih Pe Sosoenën no a napan se vavaasis manih po oeh avoes, ka napan sih tenan voh, ko oeh pah hik poꞌ en.” ");
INSERT INTO tpz_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pan, “Eöm se ep rakah em pa Tah A Pah Hat Rakah no a teꞌ vanënën soe vëh e Dëniël to sosoe suk voh non. A Tah Hat pamëh to sun non pa iuun pe Sosoenën. Ka teꞌ to ëhëh non a soe, eꞌ se maaka vavih rakah non pa pusun in a soe pamëh. ");
INSERT INTO tpz_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Manih po poen no a Tah Hat pamëh se tavus maꞌ ka napan varih to teꞌ ne manih pa muhin va Jiutiaꞌ, ee se rusin ee manuh pa moeh totope. ");
INSERT INTO tpz_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ka ta pah teꞌ se keh tok non pa tonun iuun peꞌ, ka Tah Hat pamëh tavus eꞌ to hikta onöt non a kunah taneꞌ tonun iuun pa kokon tavus a ma tah peꞌ to pet ne koman iuun, eꞌ se rusin en. ");
INSERT INTO tpz_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ka teꞌ vëh to teꞌ non pa rak peꞌ, eꞌ to hikta onöt non a tapiun vos hah iuun pa kon ohop rë peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Varenan rakah po köövo kikiuk me ro teꞌ köövo varih to vasisiꞌ ne o koaꞌ pee manih po poen pamëh, suk ee to hikta onöt ne a rusin vëhöꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Manih po Poen Apaapo me o poen no a tuvuh apuh rakah se tavus maꞌ, eöm hikta onöt nem a rusin vëhöꞌ këh a punis apuh pamëh, ivëh, köm se hinhin vakis nem manih pe Sosoenën, keꞌ se vaꞌaus a neöm. ");
INSERT INTO tpz_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Manih po poen pamëh no a punis apuh rakah se tavus. Moaan voh po poen ne Sosoenën to nok voh o oeh, pareꞌ nö non maꞌ, ko tavus non manih kuru no a punis to matan va non manih to hikta tavus voh. Ka amot me no o vu punis pamëh to hikta onöt non a tavus hah. ");
INSERT INTO tpz_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ke Sosoenën se keh hikta moes a ma poen va pa ma punis poë varih, a napan kurus se ro vahik voh ee. Ivëhkëk, e Sosoenën to koman non a napan varih to vaman ne e Ieesuꞌ. Ivëh, neꞌ to vakökööt suk voh pa ma poen poë varih. ");
INSERT INTO tpz_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Manih pa ma poen poë varih, no teꞌ se keh soe ka neöm pan, ‘Ep këk öm, e Ieesuꞌ Kristo ivëh, keꞌ, eꞌ ivöh.’ Eöm se koe a vaman raoe. ");
INSERT INTO tpz_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Suk ataeah, o Kristo vapikpiuk, me ro teꞌ vanënën soe vapikpiuk se tavus maꞌ, pare vatvus a ma kiu apaꞌpuh me a ma tah vatoksean. Ee to hikta onöt ne a nok a ma tah poë varih manih pa napan ne Sosoenën to soe a ö neꞌ se kon hah raoe. Ee se piuk vahok ee pa napan. ");
INSERT INTO tpz_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kuru, nöꞌ to kömköm vovoh a noꞌ neöm a tah pamëh he meꞌ e non pa tanok. ");
INSERT INTO tpz_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ivëh, ka napan se keh soe ka neöm pan, e Kristo to teꞌ non manuh po meoh oeh, köm nat nem nö nën. Kee se keh soe ka neöm pan, eꞌ to teꞌ vakoaan non manuh, koe a vaman. ");
INSERT INTO tpz_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus se nö maꞌ, ka napan se ep a neoꞌ. Eꞌ se matan va non manih pa ö no a vakës to vavakës non manuh pa akis. Ka napan se ep a tah pamëh pa ma muhin kurus. ");
INSERT INTO tpz_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Manih pa ö poanheh no a tah koa to pët non, manih pa ö pamëh a ma növan ënëën tah koa to tötönun ne sih nën.” ");
INSERT INTO tpz_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe vamanih pan, “O poen no a ma punis poë varih to hik ee, ka ma teꞌ tah varih tanok pet, ‘A potan se popoen, ka sivö hikta se paapa non. O vesun se vuꞌvuꞌ taneꞌ ee maꞌ akis. Ko kikis vöh akis se panih, ko takö ee.’” ");
INSERT INTO tpz_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Manih po poen pamëh, eꞌ se teꞌ non o vëknöm se tavus manuh pa akis to vateeraꞌ a no neoꞌ e Koaꞌ Teꞌ Pa Napan Kurus se nö maꞌ, ka napan kurus va po oeh se vaokook. Ee se ep a neoꞌ e Koaꞌ Teꞌ Pa Napan Kurus se nö vaꞌpeh me maꞌ a unöh manuh pa akis. Eöꞌ se nö me maꞌ o kikis apuh me o maaka. ");
INSERT INTO tpz_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","A suvin se tanih, pareꞌ kopös rakah en po oeh kurus, ke eöꞌ se vanö maꞌ o ankeroꞌ peöꞌ, kee ununun taneꞌ maꞌ a napan ne Sosoenën to soe a ö neꞌ se kon hah raoe po taanaꞌ ö noton in o oeh.” ");
INSERT INTO tpz_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","E Ieesuꞌ to vavaato avoeꞌ e non, pare soe pan, “Eöm se kon taneꞌ o vavaasis manih po naon vëh o fik. A ma pean se keh koos maꞌ, pare pau vavoon hah maꞌ, a, köm nat em po poen no a potan se pa, to taneo en. ");
INSERT INTO tpz_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Keꞌ teꞌ akuk va kov e non manih pan, o poen ne eöm se ep in a ma tah poë varih se tavus, eöm se nat em po poen hah peöꞌ e Koaꞌ Teꞌ Pa Napan Kurus to öök vatët en maꞌ manih po hopaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Eöꞌ to soe vaman rakah keoꞌ peöm. A ma napan va kuru to hikta se mët vahik ne, ka ma tah poë varih se tavus ee maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","A akis me o oeh se hik ee, ivëhkëk, a soe peöꞌ to hikta se hik non, eꞌ se teꞌ tamoaan e non.” ");
INSERT INTO tpz_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ivëh, ka hikta pah teꞌ to nat non, po poen me a aoaꞌ ne eöꞌ to sosoe suk noꞌ. O ankeroꞌ va pa vöön va kin, me eöꞌ e koaꞌ pe Sosoenën, emöm to hikta nat nem po poen ne eöꞌ se hah maꞌ, e Tamön varoe to nat non. ");
INSERT INTO tpz_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","A ma taateꞌ varih to tanok voh manih po poen pe Noaꞌ se tanok pet ee manih po poen ne eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus se hah maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","O poen no a unat apuh to hikta tavus avoeꞌ voh non maꞌ, a napan to ënëën e ne ko kakaak e ne. Pare vavaen e ne, keꞌ antoen rakah po poen ne Noaꞌ to hop en po paröꞌ me ra kën tom sinan peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ee to posean voh ne pa ma taateꞌ varih, pare hikta nat ne pataeah se tavus manih pee. Ee to teꞌteꞌ pinpiun vah ne ka unat tavus maꞌ ko kopös rapoë, kee mëtmët vahik ee. A ma taateꞌ poë varih to se vatoe e non po poen ne eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus se nö maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Manih po poen pamëh no a poa teꞌ to kikiu ne pa rak, ke Sosoenën se me en pa paeh, ko këh en pa meh. ");
INSERT INTO tpz_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","A poa köövo se nonok praoaꞌ, ke Sosoenën se me en pa paeh, ka meh neꞌ to këh en. ");
INSERT INTO tpz_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ivëh, köm se ut vavih nem ko teꞌ vamatop nem, suk eöm to hikta nat nem po poen poanheh ne Sunön peöm Ieesuꞌ Kristo se hah maꞌ manih po oeh vëh. ");
INSERT INTO tpz_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Eöm se nat va nem manih pan, e tövaneah pa iuun se keh nat momoaan en po poen no a teꞌ kakaveo se nö maꞌ, eꞌ hikta se vatö ke non a teꞌ kakaveo a iuun, keꞌ kök, pareꞌ ho. ");
INSERT INTO tpz_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ivëh, köm se teꞌ vamatop nem pa ma poen kurus, suk eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus tomeꞌ vöhnun a maꞌ neöm.” ");
INSERT INTO tpz_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pan, “A teꞌ kikiu to teꞌ me pöꞌ e non po kokoman vih, pareꞌ matop vavih e non pa kiu peꞌ? E sunön koman peꞌ se kon poan e susun po teꞌ kikiu peꞌ, pareꞌ heꞌheꞌ non raoe a taëën po poen ne sunön to vateꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Amot no e sunön peꞌ se hah maꞌ, pareꞌ këh taum a teꞌ kikiu peꞌ to teꞌ avoeꞌ va e non pa ö neꞌ to soe va voh in poan, a, a teꞌ sunön se heꞌ poan o voen vih peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Eöꞌ to soe vaman rakah keoꞌ peöm, a teꞌ sunön se vahoꞌ en pa teꞌ kikiu peꞌ pa matop a ma tah kurus peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ivëhkëk, ataeah poꞌ se tavus pa ö no a teꞌ kikiu se keh teꞌ non a teꞌ kikiu hat, pareꞌ keh koman va non manih pan, ‘E sunön peöꞌ hikta se nö vëhöꞌ hah no maꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ivëh, ka teꞌ kikiu pamëh taneo en pa ip o upöm teꞌ kikiu, pareꞌ vavaëën me e non po teꞌ kakaak vatëh. ");
INSERT INTO tpz_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","A teꞌ sunön peꞌ se vöhnun maꞌ poan po poen neꞌ to hikta vamatop non, me a aoaꞌ neꞌ to hikta nat non. ");
INSERT INTO tpz_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ka teꞌ sunön se vakmis rakah en pa teꞌ kikiu pamëh. Pareꞌ veo en peꞌ, keꞌ nö ko teꞌ vaꞌpeh me non pa nap mokoꞌ rivon. Manuh nën no a napan se vaokook kov e ne, pare vakuskus rivon kov e ne po kamis. ");
INSERT INTO tpz_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pan, “Po poen ne eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus se tavus maꞌ, a Matop Vih va pa Vöön va Kin se matan va non manih po vahutët va pa havun köövo sepeꞌ to kon a ma ram pee, pare öhön ee pe voe tövaen manuh hanan. ");
INSERT INTO tpz_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Ka manih pee, a havun köövo sepeꞌ poë varih, no a tönim to papön, suk ee to kon a ma ram pee, ivëhkëk, ee to hikta teꞌ vaꞌpeh me maꞌ ta ma meh ö kompoꞌ ov in a ma ram. Ka meh tönim to natsean, pare kon a ma ram pee, ko isu a ma puto kompoꞌ, pare teꞌ vaꞌpeh me ee maꞌ pa ma teꞌ ram pee. ");
INSERT INTO tpz_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ivëhkëk, e voe tövaen to hikta nönö vëvëhöꞌ non maꞌ, ko köövo sesepeꞌ poë varih mët rakah ee po mamaasoe, pare koroh varo rakah ee. ");
INSERT INTO tpz_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pa topnin poen rakah no a napan to pënton a pah teꞌ to soe vamanih, ‘E voe tövaen to nö en maꞌ. Sun öm, paröm öhön eah. ");
INSERT INTO tpz_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ivëh, ka kën mon sesepeꞌ poë varih sun, pare vamatop ee pa ma ram pee. ");
INSERT INTO tpz_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ivëhkëk, a tönim sepeꞌ papön varih to sun, pare soe ke ra tönim natsean pan, ‘Heꞌ a möm ta ma teꞌ ö kompoꞌ, kemöm vapnih a ma teꞌ ram pemöm. A ma teꞌ ram pemöm to muteꞌ ee, suk o kompoꞌ to kit en.’ ");
INSERT INTO tpz_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ivëhkëk, a tönim köövo sepeꞌ natsean varih to piun rapoë, pare soe pan, ‘Ahik, o kompoꞌ vaꞌih to hikta antoen a rora kurus. Eꞌ to vih non peöm se nö, paröm voen maꞌ ta ma teꞌ ö kompoꞌ koman peöm.’ ");
INSERT INTO tpz_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","A tönim köövo sepeꞌ varih to posean vure pa nö pa vavoen kompoꞌ. Ke voe tövaen nö en maꞌ. Ka tönim köövo sepeꞌ natsean varih to teꞌ vamatop ne sih, nö vaꞌpeh me ee peꞌ manuh pa taëën va po vaen. Kee ho ee koman iuun, ko panih ee maꞌ po hopaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Vasuksuk no a meh tönim köövo to hah maꞌ, pare ep o hopaꞌ to papanih en, pare tekteok ne o hopaꞌ, pare sosoe ne pan, ‘Sunön, Sunön, peret ka nös möm ah.’ ");
INSERT INTO tpz_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ivëhkëk, e voe tövaen to soe maꞌ pan, ‘Eöꞌ to soe vaman rakah keoꞌ peöm, Eöꞌ to hikta nat noꞌ peöm.’” ");
INSERT INTO tpz_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ivëh, ke Ieesuꞌ soe ke poꞌ rapoë pan, “Eöm se teꞌ vamatop nem, suk ataeah, eöm to hikta nat nem po poen, me a aoaꞌ poanheh ne eöꞌ e Koaꞌ Teꞌ pa Napan Kurus se hah maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pan, “A Matop Vih va pa Vöön va Kin to teꞌ va e non manih pe torara to kehkeh nö non pa meh muhin, pareꞌ vaoe na a ma teꞌ kikiu peꞌ, kee nö maꞌ keꞌ heꞌ vakëkëh raoe a ma tah peꞌ te matop ne. ");
INSERT INTO tpz_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Eꞌ to heꞌ suk na o nat pa ma paeh teꞌ kikiu peꞌ. Eꞌ to heꞌ en pa pah teꞌ kikiu peꞌ pa K5,000.00, ka vapöök neꞌ to heꞌ a K2,000.00, ka vakön pa K1,000.00. Eꞌ to heꞌ vahik rapoë a moniꞌ peꞌ, pareꞌ nö poꞌ en pa meh muhin pa vavih. ");
INSERT INTO tpz_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ka teꞌ vëh to kon voh a K5,000.00, to vakiu vëvëhöꞌ rakah en pa K5,000.00 pamëh, pareꞌ kon en pa meh K5,000.00 to tok maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ka teꞌ vëh to kon voh a K2,000.00, to vakiu a K2,000.00 pamëh, pareꞌ kon a meh K2,000.00 to tok maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ivëhkëk, a teꞌ vëh to kon a K1,000.00, to teꞌ a moniꞌ pamëh, pareꞌ en a koveꞌ manih po oeh ko pe en pa moniꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","E torara pee to teꞌ varë vahik en, pareꞌ hah en maꞌ, pareꞌ hi en pa ma teꞌ kikiu peꞌ pa ö nee to nok vah va in a moniꞌ peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ka teꞌ kikiu vëh to kon voh a K5,000.00, to nö me en maꞌ pa meh K5,000.00. Pareꞌ soe ke torara peꞌ pan, ‘Torara peöꞌ, eën to vaman voh e nom peöꞌ se matop vavih noꞌ a K5,000.00 pën. Eöꞌ to vakiu voh a moniꞌ pën, paröꞌ kon eoꞌ pa meh K5,000.00 to tok maꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ke torara peꞌ soe ke poan pan, ‘Eën a teꞌ kikiu vih rakah. Eën to nok voh a kiu vih rakah, parën matop voh nom a siꞌ tah soneꞌ. Ivëh, köꞌ vaman e noꞌ pën se matop e nom pa ma tah peo peöꞌ. Nö mah, ko vaeö me a neoꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ka teꞌ kikiu vëh to kon a K2,000.00 nö me en maꞌ pa meh K2,000.00. Pareꞌ soe ke torara peꞌ pan, ‘Torara peöꞌ, eën to vaman voh e nom peöꞌ se matop vavih noꞌ a K2,000.00 pën. Eöꞌ to vakiu voh a moniꞌ pën, paröꞌ kon eoꞌ pa meh K2,000.00 to tok maꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ke torara peꞌ soe ke poan pan, ‘Eën a teꞌ kikiu vih rakah. Eën to nok voh a kiu vih rakah, parën matop voh nom a siꞌ tah soneꞌ. Ivëh, köꞌ vaman e noꞌ pën se matop e nom pa ma tah peo peöꞌ. Nö mah, ko vaeö me a neoꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ka teꞌ vëh to kon voh a K1,000.00 nö maꞌ, pareꞌ soe ke torara peꞌ pan, ‘Torara peöꞌ, eöꞌ to nat e noꞌ pën no a taateꞌ pën to parin a hivaꞌ. A ma taëën nën to ënëën nom sih, ee a ma taëën nën to hikta nep voh. Parën osoes nom a voaꞌ nën to hikta poꞌpoꞌ voh. ");
INSERT INTO tpz_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ivëh, nöꞌ to nanaöp suk voh noꞌ, paröꞌ nö ko koaan eoꞌ pa K1,000.00 pën manuh po oeh. Keꞌ ivaꞌih a moniꞌ pën.’ ");
INSERT INTO tpz_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ke torara peꞌ soe ke poan pan, ‘Eën a teꞌ hat rakah, parën karauh. Eën to soe ka neoꞌ pan, eën to nat e nom peöꞌ to enen noꞌ sih a ma tah nöꞌ to hikta nep voh. Me eöꞌ to osoes noꞌ a voaꞌ nöꞌ to hikta poꞌpoꞌ voh. ");
INSERT INTO tpz_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ivëh, kën hikta vahoꞌ suk poꞌ voh a moniꞌ peöꞌ ataeah pa benk, köꞌ se hah maꞌ, ko kon a moniꞌ peöꞌ me a teꞌ to teꞌ oah non.’ ");
INSERT INTO tpz_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ke torara soe ke a meh teꞌ kikiu pan, ‘Öt këh a teꞌ vëh a K1,000.00, parën heꞌ a teꞌ vëh to teꞌ me non a K10,000.00. ");
INSERT INTO tpz_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","O teꞌ varih to vaneah ne a ma siꞌ tah keok, eöꞌ se heꞌ oah eoꞌ pee pa ö nee to öt va ne. Ivëhkëk, o teꞌ varih to hikta vaneah ne a ma tah peo, eöꞌ se kon këh eoꞌ pee pa ma siꞌ tah nee to vaneah ne.’ ");
INSERT INTO tpz_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ke torara soe pan, ‘Vi na öm a teꞌ kikiu karauh vëh manuh pa vöön popoen. Manuh pa vöön pamëh no a napan se vaokook kov e ne, pare vakuskus rivon kov e ne po kamis.’ ");
INSERT INTO tpz_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pan, “Eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus se hah me maꞌ o kikis peöꞌ manih po oeh vamanih pa teꞌ Sunön me ro ankeroꞌ peöꞌ. Eöꞌ se tavus a teꞌ Sunön, paröꞌ ihoꞌ pa ö ihihoꞌ pa teꞌ sunön marën a kiiki a ma taateꞌ pa napan. ");
INSERT INTO tpz_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ka napan va po oeh kurus tönun maꞌ manih peöꞌ. Köꞌ ki vakëh eoꞌ pee po pöök kum. Keꞌ matan va non manih pa teꞌ mamatop sipsip to ki vakëh o sipsip me ro meemeꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Eöꞌ se vahoꞌ o teꞌ varih to nonok ne sih a ma taateꞌ totoopin manih pa papmatö peöꞌ. Ko teꞌ varih to hikta vavatet voh ne a soe peöꞌ pen Tamaneoꞌ Sosoenën se nö ee manuh pa papkiruk peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ke eöꞌ a teꞌ Sunön se soe va eoꞌ po teꞌ varih to teꞌ ne manih pa papmatö peöꞌ to nonok ne sih a ma taateꞌ totoopin pan, ‘Nö maꞌ öm, eöm varih ne Tamön to tapui voh en peöm. Nö maꞌ öm, paröm teꞌ nem manih pa Matop Vih ne Sosoenën to vamatop anoeh voh a neöm, taneo non maꞌ po poen ne Sosoenën to soe ko oeh tavus.’ ");
INSERT INTO tpz_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Suk ataeah, eöꞌ to maë, köm makën em peöꞌ, ko manoe, köm heꞌ em peöꞌ pa ruen, köꞌ kaak eoꞌ. Paröꞌ teꞌ varo këh noꞌ a vöön peöꞌ, köm me em peöꞌ pa ma iuun peöm. ");
INSERT INTO tpz_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ko poen nöꞌ to arus rara, köm rara em peöꞌ, köꞌ haraꞌ a hiinana, köm matop e nem peöꞌ, köꞌ teꞌ noꞌ pa nohnoh, köm nönö e nem na pa ep a neoꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ko teꞌ varih to nonok ne sih a ma taateꞌ totoopin se soe ee pan, ‘Sunön, o poen poanheh nemöm to ep ka oah to maë, pamöm makën a oah? Me o poen poanheh nemöm to ep ka oah to manoe, pamöm heꞌ oah a ruen kën kaak? ");
INSERT INTO tpz_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","O poen poanheh nemöm to ep ka oah to teꞌ varo këh nom a vöön pën, pamöm vaoe a oah pa ma iuun pemöm? Me o poen poanheh nemöm to ep ka oah to hikta teꞌ me nom to rara, pamöm heꞌ oah o rara kën rara? ");
INSERT INTO tpz_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","O poen poanheh nemöm to ep ka oah to haraꞌ nom a hiinana, me eën to teꞌ nom pa nohnoh, kemöm matop ka nom oah?’ ");
INSERT INTO tpz_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ke eöꞌ a teꞌ Sunön se piun rapoë, paröꞌ soe ke rapoë pan, ‘Eöꞌ to soe vaman rakah keoꞌ peöm, a ma moeh tah nöm to nok voh manih pa ma kea peöꞌ varih, eöm to nok me em manih peöꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ke eöꞌ a teꞌ Sunön se soe vahik vakomanih, paröꞌ soe ke poꞌ o teꞌ varih to teꞌ ne manih pa papkiruk peöꞌ to hikta nonok ne sih a ma taateꞌ totoopin pan, ‘Këh a na neoꞌ öm. E Sosoenën to soe voh en peöm varih se kon kamis. Eöm se nö manuh po suraꞌ vëh to hikta onöt non a muteꞌ. A suraꞌ pamëh to vamatop anoeh e non pe susun po oraꞌ hat, me ro ankeroꞌ peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Suk ataeah, eöꞌ to haraꞌ voh noꞌ o maë, köm hikta makën a neoꞌ. Ko manoe, köm hikta heꞌ a neoꞌ ta ruen, köꞌ kaak. ");
INSERT INTO tpz_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Paröꞌ teꞌ varo këh noꞌ a vöön peöꞌ, köm hikta vaoe a neoꞌ pa ma iuun peöm, ko hikta teꞌ me noꞌ to rara, köm hikta heꞌ a neoꞌ to rara. Paröꞌ haraꞌ noꞌ a hiinana, me eöꞌ to teꞌ noꞌ pa nohnoh, köm hikta nö maꞌ pa ep a neoꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ka napan poë varih to antoen e ne pa piun a neoꞌ pan, ‘Sunön, o poen poanheh nemöm to ep voh ka nom oah to teꞌ maë nom, parën teꞌ manoe nom? Me o poen poanheh nemöm to ep voh ka nom oah to teꞌ varo këh nom a vöön pën? Me o poen poanheh nemöm to ep ka oah to hikta teꞌ me nom to rara, me eën to teꞌ nom pa nohnoh? Emöm ep voh nem a ma tah varih nih, pamöm hikta vaꞌaus a oah?’ ");
INSERT INTO tpz_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ke eöꞌ a teꞌ Sunön se piun va in a soe pee manih pan, ‘Eöꞌ to soe vaman rakah keoꞌ peöm, a ma moeh tah kurus nöm to hikta nok voh manih pa ma teꞌ peöꞌ varih, eöm to hikta nok voh manih peöꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“O teꞌ varih to vatösoe voh ne, eöꞌ e Sunön se veo eoꞌ pee, kee nö ee pa vöön va po kamis teꞌteꞌ tamoaan. Ko teꞌ varih to nonok ne sih a ma taateꞌ totoopin, ne eöꞌ e Sunön se me eoꞌ pee manuh pa vöön va kin kee kon ee po toꞌtoꞌ tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","E Ieesuꞌ to vavaasis vahik a napan, pareꞌ soe ke ra ma vamomhë peꞌ pan, ");
INSERT INTO tpz_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Eöm nat e nem eh? O pöök poen to meꞌ avoeꞌ e ne, ka Taëën Apuh va po Pasovaꞌ se tavus en. Manih pa Taëën Apuh pamëh ne eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus, nee se vahoꞌ ee peöꞌ pa koreera napan varih to hat ov a ne neoꞌ, pare ni a neoꞌ, ko vahan ee peöꞌ pa kuruse.” ");
INSERT INTO tpz_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Manih po poen pamëh no teꞌ susunön ësës heꞌ, me o teꞌ apaꞌpuh po Jiuꞌ to tönun manih pa iuun pa Teꞌ Susun po Teꞌ Ësës Heꞌ, a ëhnaneah e Kaëfas. ");
INSERT INTO tpz_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Manih po ihoꞌ pamëh, nee to nok o kokoman va pa ö nee se öt koe e Ieesuꞌ, ko ip vamët poë. ");
INSERT INTO tpz_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ivëhkëk, ee to soe pan, “Ea se nat no nok a tah pamëh, ea se anoeh no ka Taëën Apuh va po Pasovaꞌ oah voh. Eꞌ to hat non pa ö no a napan se ep a tah vëh ko kunkuin to vapus.” ");
INSERT INTO tpz_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","E Ieesuꞌ to teꞌ non pa vöön nee to popokaꞌ ne Bëtaniꞌ. Eꞌ to teꞌ non pa iuun pe Saëmon vëh to teꞌ me voh non a mët töpaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Eꞌ to teꞌ non koman iuun ka köövo nö maꞌ manih peꞌ. Eꞌ to teꞌ maꞌ o puto vanom o pöh voen vapeah. Pareꞌ koꞌ o vanom pamëh manih pa pasun e Ieesuꞌ pa ö neꞌ to ënëën non. ");
INSERT INTO tpz_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","A ma vamomhë peꞌ to ep a tah to tanok manih pe Ieesuꞌ, pare pah haraꞌ vahat e ne, pare soe ee pan, “Vahvanih ke köövo koꞌ vakit akuk o vanom vëh? ");
INSERT INTO tpz_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ea se keh vavoen o vanom vëh, ea se kon a moniꞌ a pah apuh. Ka moniꞌ pamëh na se vaꞌaus o teꞌ arus.” ");
INSERT INTO tpz_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ivëhkëk, e Ieesuꞌ to nat en pataeah nee to sosoe suk ne, pareꞌ soe ke rapoë pan, “Suk ataeah, köm vatamak e köövo vëh, a tah neꞌ to nok manih peöꞌ to vih, pareꞌ matan vavih. ");
INSERT INTO tpz_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","A nap arus se teꞌ tamoaan me e ne peöm. Ivëhkëk, eöꞌ to hikta se teꞌ tamoaan me a noꞌ neöm. ");
INSERT INTO tpz_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","E köövo vëh to koꞌkoꞌ o vanom manih pa pasuneoꞌ, eꞌ to vamatop non a ö nöꞌ se mët, kee pe ee peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Eöꞌ to soe vamaman rakah keoꞌ peöm, manih po oeh avoes no a napan se keh vavatvus ne a Soe Vih pe Sosoenën. Ee se vavasoe suk vaviꞌ e ne pa tah ne köövo vëh to nok manih peöꞌ, ka napan sih koman hah ne poë.” ");
INSERT INTO tpz_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Manih po poen pamëh no a paeh va pa havun me ra poa vamomhë pe Ieesuꞌ to nö en manuh po teꞌ susunön ësës heꞌ, a ëhnaneah e Jiutas Iskariot. ");
INSERT INTO tpz_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","E Jiutas to nö, pareꞌ soe pan, “Eöm se poꞌ voen a neoꞌ pataeah pa ö nöꞌ seꞌ heꞌ a neöm e Ieesuꞌ? Kee heꞌ ee peꞌ po 30 voaꞌ moniꞌ silvaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Taneo non po poen pamëh ne Jiutas Iskariot to iu vah këh non ta hanan neꞌ se vikuh vah va in e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","O poen vamomoaan in a Taëën Apuh va pa Taëën Hikto Is vëh, o Pasovaꞌ to tavus en, ka a ma vamomhë nö ee manih pe Ieesuꞌ, pare hi poë pan, “Eën iu nöm a ö nemöm se vamatop a Taëën Apuh va po Pasovaꞌ nih?” ");
INSERT INTO tpz_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ke Ieesuꞌ soe ken pee pa pah teꞌ, pareꞌ soe pan “Eöm se nö na pa vöön va Jerusalëm, paröm nö manuh pa teꞌ vëh, paröm soe keah pan, ‘E Apuh to soe maꞌ pan, o poen mët peꞌ to öök vatët en, ke eꞌ me ra ma vamomhë peꞌ se ëën a Taëën Apuh va po Pasovaꞌ manih pa iuun pën.’” ");
INSERT INTO tpz_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","O vamomhë to nok va ee manih pa ö ne Ieesuꞌ to soe va i rapoë, pare vamatop ee pa taëën va pa Taëën Apuh va po Pasovaꞌ nën. ");
INSERT INTO tpz_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","A muhin to matanpoen en, ke Ieesuꞌ ihoꞌ, ko vaëën vaꞌpeh me ra ma vamomhë peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ee to ënëën ne ke Ieesuꞌ soe pan, “Eöꞌ to soe vaman rakah keoꞌ peöm, a paeh koman va peöm varih o vamomhë peöꞌ ivëh, se vikuh ka neoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","A soe vaꞌih to vatamak rakah en pa ma vamomhë peꞌ, kee taneo ee pa hi papaeh poë pan, “Sunön, eöꞌ pöꞌ, ha?” ");
INSERT INTO tpz_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ke Ieesuꞌ piun rapoë, pareꞌ soe pan, “Eöm se keh ep a teꞌ vëh to vahoꞌ vaꞌpeh a koreneah me a teꞌ koreneoꞌ manih pa hun taëën vëh pa tis, eꞌ ko a teꞌ pamëh se vikuh ka neoꞌ pa nap hat. ");
INSERT INTO tpz_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus se mët eoꞌ, vamanih pa ö no Puk Vapenpen to soe va non. Ivëhkëk, varenan rakah pa teꞌ vëh to vikuh ka neoꞌ po teꞌ varih to hat ov a no neoꞌ sih. Eꞌ to vih non pa ö no e sinan a teꞌ pamëh se hikta vahuh voh poan.” ");
INSERT INTO tpz_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ke Jiutas soe ke Ieesuꞌ pan, “Apuh, eöꞌ pöꞌ, ha?” Ke Ieesuꞌ piun poan, pareꞌ soe pan, “Eꞌ to teꞌ va i non nën.” ");
INSERT INTO tpz_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","E Ieesuꞌ me ra ma vamomhë peꞌ to ënëën ne, keꞌ kon a ö taëën, pareꞌ hin na e Sosoenën, ko soe vavihvih ke na eah, pareꞌ kök a ö taëën pamëh, ko ki vakëkëh ke ra ma vamomhë peꞌ, pareꞌ soe ke rapoë pan, “Kon öm a ö taëën vëh, ko ëën. A ö taëën vaꞌih eꞌ a sionineoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pareꞌ kon pet en na pa kap voaën, pareꞌ soe vavihvih ke na e Sosoenën, pareꞌ heꞌ raoe, ko soe pan, “Eöm kurus varih se kaak manih pa kap vaꞌih, ");
INSERT INTO tpz_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","eꞌ vaꞌih o eraꞌ peöꞌ, o eraꞌ pamëh to vataare non o vatompoan voon. O eraꞌ pamëh se takoꞌ marën a voen hah a neöm a ma napan kurus. Eꞌ to vataare non a napan pan e Sosoenën se ihan anoe en pa ma hat pa nap peo, vamanih pa ö neꞌ to soe vaman vavoh. ");
INSERT INTO tpz_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Eöꞌ to soe vamaman rakah keoꞌ peöm, eöꞌ hikta se kaak hah noꞌ o voaën vaꞌih keꞌ onöt non po poen nöꞌ se kaak vaꞌpeh me a neöm po voaën voon manuh pa Matop Vih Pe Tamön.” ");
INSERT INTO tpz_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kee nok ee po vaëhëh, ko no ee Tope Öliv. ");
INSERT INTO tpz_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","E Ieesuꞌ to soe ke ra ma vamomhë peꞌ pan, “Kuru po poen vëh, ne eöm kurus se rusin këh em peöꞌ, suk ataeah, o Puk Vapenpen pe Sosoenën to soe non pan, ‘E Sosoenën to se ip vamët en pa teꞌ utut sipsip, ko sipsip se rusin vakëkëh ee.’ ");
INSERT INTO tpz_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ivëhkëk, eöꞌ se sun taneꞌ hah po vapeepe, paröꞌ vovoh keoꞌ peöm manuh Galiliꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ke Pitaꞌ piun a soe peꞌ, pareꞌ soe pan, “O upöm vamomhë se keh ep ataeah to tavus manih pën, pare varurusin ee, suk o vaman pee to hikta teꞌ kikis non. Ivëhkëk, eöꞌ hikta onöt noꞌ a rusin këh a oah.” ");
INSERT INTO tpz_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ke Ieesuꞌ piun poan, pareꞌ soe pan, “Nös pa popoen e toaꞌ oeteꞌ se meꞌ avoeꞌ e non pa tötö, eën se kukön soe eom pan, eën to hikta nat nom peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ke Pitaꞌ soe ke Ieesuꞌ pan, “Eöꞌ hikta onöt rakah noꞌ a soe vamanih pan, ‘Eöꞌ to hikta nat noꞌ pën.’ Eꞌ to onöt e non pa napan se ip vamët ee peöꞌ, köꞌ mët vaꞌpeh me eoꞌ pën.” Ko upöm vamomhë soe kurus pet va ee nën. ");
INSERT INTO tpz_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","E Ieesuꞌ to nö vaꞌpeh me ra ma vamomhë peꞌ pa ö muhin va Gëtsëmaniꞌ. Pareꞌ soe ke ra ma vamomhë peꞌ pan, “Ihoꞌ nem manih. Köꞌ nö, ko hin manuh pa ö vöh.” ");
INSERT INTO tpz_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ke Ieesuꞌ me en pe Pitaꞌ, pen a poa sunaiꞌ Sëbëdiꞌ, e Jëmis pen Jon, kee nö vaꞌpeh me ee peꞌ. Eꞌ to tamak vörep rakah en, ko haraꞌ vapunis rakah e non. ");
INSERT INTO tpz_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Pareꞌ soe ke rapoë pan, “O kupu peöꞌ to puh rakah non po tamak, köꞌ haraꞌ ke noꞌ pan eöꞌ se mët eoꞌ. Teꞌ nem manih, paröm hinhin vaꞌpeh me a no neoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ke Ieesuꞌ huk amot këh en pee. Pareꞌ vahoꞌ rakah en pa pasuneah po oeh, pareꞌ hinhin va non manih pan, “Tamön eꞌ to vih non pën se nat nom heꞌ a neoꞌ o kamis vaꞌih. Ivëhkëk, Tamön eën se nat nom suk o iu peöꞌ, ahik, eën se vatet varoe o iu koman pën.” ");
INSERT INTO tpz_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Eꞌ to taneꞌ hah maꞌ pa ö neꞌ to hinhin non, pareꞌ ep in a ma vamomhë peꞌ to koroh, pareꞌ soe ke Pitaꞌ pan, “Eöm hikta onöt rakah ko nem a ut vaꞌpeh me voh a neoꞌ pa ta pah aoaꞌ, ha? ");
INSERT INTO tpz_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ut nem, paröm hinhin nem, eöm tomeꞌ kuꞌ em pa ö no a punöꞌ se tavus a neöm. O apen to iu e non pa vatet a ma taateꞌ vih, ivëhkëk, o sionin to susunë e non pa vatet.” ");
INSERT INTO tpz_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Eꞌ to hah en, pareꞌ vapöök hin va en manih pan, “Tamön, eꞌ to vih non pa ö söꞌ vaniu këh eoꞌ po kamis vaꞌih, keꞌ, eöꞌ se keh teꞌ eoꞌ po kamis pamëh. Köꞌ iu noꞌ ataeah nën to iu nom se tanok va en manih pa ö nën to iu va nom.” ");
INSERT INTO tpz_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","E Ieesuꞌ to hah taneꞌ maꞌ pa hin, pareꞌ nö en manuh pa ma vamomhë peꞌ. Pareꞌ taum raoe to koroh ne, suk ee to mët rakah ee po mamaasoe. ");
INSERT INTO tpz_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Eꞌ to këh hah en pee, pareꞌ hah ko vakön hin hahah kov en. Pa pah ta hin vëh neꞌ to nonok moaan non. ");
INSERT INTO tpz_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Vasuksuk neꞌ to hah en manuh pa ma vamomhë peꞌ, pareꞌ soe ke rapoë pan, “Eöm koroh vavuriah avoeꞌ e nem, ha? Pënton öm! O poen peöꞌ to tavus en no a napan se heꞌ ee peöꞌ e Koaꞌ Teꞌ Pa Napan Kurus manih pa koreera nap hat. ");
INSERT INTO tpz_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Sun öm, ka nö ee. A teꞌ vëh to vikuh a neoꞌ to nö en maꞌ pa öt a neoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","E Ieesuꞌ to vavaato avoeꞌ me non pa ma vamomhë peꞌ, ke Jiutas a paeh va pa havun me ra poa vamomhë peꞌ öök en maꞌ. Eꞌ to nö vaꞌpeh me maꞌ a nap peo rakah to teꞌ me ne a ma rapis rë, me a ma tanaon. O teꞌ susunön ësës heꞌ, me a nap susunön po Jiuꞌ to vanö maꞌ rapoë. ");
INSERT INTO tpz_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ke Jiutas a teꞌ vëh to vikuh in e Ieesuꞌ pa koreera nap hat, to heꞌ maꞌ o vëknöm manih pa napan pan, “A teꞌ vëh nöꞌ se keh umaꞌ eah, eꞌ kuru a teꞌ pamëh, söm öt eah.” ");
INSERT INTO tpz_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ka varuꞌ vakomanih ne Jiutas to tavus manih pe Ieesuꞌ, pareꞌ soe ke poan pan, “Poen avih, Apuh!” Pareꞌ umaꞌ en peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ke Ieesuꞌ soe ke poan pan, “Kea, nok vëvëhöꞌ a tah nën to nö maꞌ pa nok manih peöꞌ.” Ka napan varih to nö me maꞌ e Jiutas, öt poë, ko nohnoh ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ka pah teꞌ to teꞌ vaꞌpeh me non e Ieesuꞌ, eꞌ e vamomhë koman peꞌ to ep a tah to tanok manih pe Ieesuꞌ, pareꞌ rëh taneꞌ o rapis rë pa ö pepet peꞌ, ko moes kurus en pa tenan a teꞌ kikiu pa Teꞌ Susun po Teꞌ Ësës Heꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ke Ieesuꞌ soe ke vamomhë peꞌ pan, “Vahoꞌ hah o rapis rë pën manih pa ö pepet peꞌ. O teꞌ varih to vavapus me ne o rapis rë, o rapis rë pamëh se miröꞌ koman hah en pee. ");
INSERT INTO tpz_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Eöm to nat pöꞌ e nem, eöꞌ se keh hin e Tamön a ö neꞌ se heꞌ a maꞌ neoꞌ o pöh havun me ro pöök kum ankeroꞌ vëvënsun, kee vaꞌaus a neoꞌ, eꞌ se heꞌ en peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ivëhkëk, eöꞌ se keh nok va nën, a soe to kiun non po Puk pe Sosoenën to hikta onöt non a tavus vaman. O Puk pe Sosoenën to soe non pan, a ma tah kurus rakah poë varih se tavus ee manih peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ke Ieesuꞌ soe ke ra napan varih to nö maꞌ pa öt poë pan, “Eöm nö maꞌ pa öt a neoꞌ, paröm teꞌ em maꞌ pa ma rapis rëërë, me a ma tanaon ke pan, eöꞌ a teꞌ kakaveo toh? A ma poen kurus nöꞌ to teꞌ tamoaan e noꞌ koman a Iuun Hinhin Apuh, paröꞌ vavaasis noꞌ sih. Ivëhkëk, eöm hikta iu öt poꞌ voh a nem neoꞌ nën toh? ");
INSERT INTO tpz_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ivëh, ka ma tah poë varih tavus marën a vapuh a soe no a nap vanënën soe to kiun voh manih po Puk pe Sosoenën.” Ko vamomhë pe Ieesuꞌ varurusin këh ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","O teꞌ varih to öt e Ieesuꞌ to me ee peꞌ manuh pa iuun pa Teꞌ Susun po Teꞌ Ësës Heꞌ vëh e Kaëfas. A iuun pamëh no o teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, me ra nap susunön po Jiuꞌ to vatönun ne nën. ");
INSERT INTO tpz_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","E Pitaꞌ to suksuk amot nö e non maꞌ pa napan to meeme nö ne e Ieesuꞌ. Pareꞌ ho en koman a eean vëh to tavi non a iuun pa Teꞌ Susun po Teꞌ Ësës Heꞌ. Pareꞌ ihoꞌ vaꞌpeh me e non po teꞌ utut, suk eꞌ to kehkeh ep non pataeah se tavus manih peꞌ Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ko teꞌ susunön ësës heꞌ, me ro Kum Teꞌ Susunön po Jiuꞌ vaoe ee na pa ma meh teꞌ, kee nö ee maꞌ, pare vavaꞌaus ee pa vatvus maꞌ a ma soe piuk ov in a ma tah ne Ieesuꞌ to nok voh. Suk ee to kehkeh taum ne ta hanan nee se ip vamët koe vah va in poë. ");
INSERT INTO tpz_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ka nap peo rakah nö maꞌ, pare vapokaꞌ ee peꞌ pa ma piuk peo. Ivëhkëk, o Vakum Teꞌ Susunön po Jiuꞌ to hikta taum ta soe man to vih non nee se ip vamët suk poë. Ivëhkëk, a meh poa teꞌ to nö maꞌ, ");
INSERT INTO tpz_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","pare soe ee pan, “A teꞌ vëh to soe voh pan, ‘Eöꞌ se miröꞌ eoꞌ pa Iuun Hinhin Apuh pe Sosoenën, paröꞌ eok hah eoꞌ peꞌ po kukön poen.’” ");
INSERT INTO tpz_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ka Teꞌ Susun po Teꞌ Ësës Heꞌ sun, pareꞌ soe pan, “Eën hikta pinpiun suk nom a ma soe varih ataeah no a napan to popokaꞌ a nom oah?” ");
INSERT INTO tpz_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ivëhkëk, e Ieesuꞌ to hikta tooto non, ka Teꞌ Susun po Teꞌ Ësës Heꞌ hi hah en peꞌ pan, “Eöꞌ to soe rakah ka oah pa ëhnan e Sosoenën toꞌtoꞌ tamoaan, soe vaman rakah ka möm ah. Eën kov e Kristo Koaꞌ pe Sosoenën, ëh?” ");
INSERT INTO tpz_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ke Ieesuꞌ piun poan, pareꞌ soe pan, “A ma soe varih, ee ma soe koman pën, ivëhkëk, eöꞌ to soe vaman rakah keoꞌ peöm, amot nöm se ep ka neoꞌ e Koaꞌ Te Pa Napan Kurus se ihoꞌ noꞌ pa papmatö pe Sosoenën a Kikis Vi, paröꞌ kunah vaꞌpeh me maꞌ a unöh vöh pa akis.” ");
INSERT INTO tpz_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ka Teꞌ Susun po Teꞌ Ësës Heꞌ pënton a soe vaꞌih ne Ieesuꞌ to soe, pareꞌ töhkak rakah en, ko si en po ohop peꞌ, pareꞌ soe pan, “A teꞌ vaꞌih to sosoe oꞌoah e non pe Sosoenën. Ea hikta se vaiu hah no ta ma meh teꞌ se vatvus maꞌ ta ma meh soe, suk eöm to pënton koman e nem peꞌ to sosoe oꞌoah e non pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ka Teꞌ Susun po Teꞌ Ësës Heꞌ hi en po Vakum Teꞌ Susunön po Jiuꞌ pan, “Eöm koman poꞌ nem pan, ea se nok va in a teꞌ vëh nih?” Kee soe maꞌ pan, “Eꞌ to vih non peꞌ se mët rakah en.” ");
INSERT INTO tpz_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ka napan varih to teꞌ ne nën teteo ee pa matan e Ieesuꞌ, pare töstös ee peꞌ, ko upöm tatapan poë, ");
INSERT INTO tpz_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","pare soe ke poë pan, “Pokaꞌ oon ka möm ah. Eën poꞌ e Kristo toh! Eteh rakah ivëh to tös a oah?” ");
INSERT INTO tpz_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Manih po poen avoeꞌ pamëh ne Pitaꞌ to ihoꞌ non koman a eean pa ö pëpënton vahutët, ka pah köövo sepeꞌ to kiu non nën, nö maꞌ manih peꞌ, pareꞌ soe ke poan pan, “Eën me poꞌ kuru a meh teꞌ to teꞌ vaꞌpeh me voh nom e Ieesuꞌ va Galiliꞌ toh.” ");
INSERT INTO tpz_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ivëhkëk, e Pitaꞌ to vonih, pareꞌ soe pan, “Eöꞌ to hikta nat noꞌ pataeah nën to vavaato suk nom.” ");
INSERT INTO tpz_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Eꞌ to këh en pa ö pëpënton vahutët, pareꞌ nö en manuh po hopaꞌ va pa eean. Ka meh köövo kikiu ep poan, pareꞌ soe ke ra napan to sun vatët ne pan, “A teꞌ vëh to teꞌ vaꞌpeh me voh e non pe Ieesuꞌ va Nasarët.” ");
INSERT INTO tpz_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ke Pitaꞌ soe hahah kov en pan, “Eöꞌ to soe vamaman rakah eoꞌ, peöꞌ to hikta nat rakah noꞌ pa teꞌ vëh.” ");
INSERT INTO tpz_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ka meh siꞌ ö oah en ka napan varih to sun vatët ne nën to nö ee maꞌ manih pe Pitaꞌ, pare soe ke poë pan, “Oman rakah, eën a meh va pee, a to pën to vataare e non pën a meh va pee.” ");
INSERT INTO tpz_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Varuꞌ vakomanih ne Pitaꞌ to soe vakis rakah en pan, “Eöꞌ to hikta teꞌ vaꞌpeh me voh noꞌ eah, paröꞌ hikta nat rakah noꞌ pa teꞌ vëh. Oman rakah, e Sosoenën se vakmis en peöꞌ pa ö ne eöꞌ se keh hikta sosoe noꞌ, oman! Ka varuꞌ vakomanih no e toaꞌ oeteꞌ to tötö en. ");
INSERT INTO tpz_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ke Pitaꞌ koman hah poꞌ en pa soe ne Ieesuꞌ to soe ke voh poan pan, “Vamomoaan in a ö no e toaꞌ oeteꞌ se meꞌ avoeꞌ e non pa tötö, eën se kukön soe eom pan, eën to hikta nat nom peöꞌ.” Eꞌ to vamösru, ko tavus hah ken manih po hopaꞌ va pa eean pamëh, pareꞌ pah ook suntan rakah en. ");
INSERT INTO tpz_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pa pöstakah rakah no teꞌ susunön ësës heꞌ, me ro teꞌ susunön po Jiuꞌ to vaonöt ee po kokoman va pa ip vamët e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ee to nohnoh poë, pare me ee peꞌ, ko heꞌ ee peꞌ manuh pe susun pa kaman, vëh e Paëlat. ");
INSERT INTO tpz_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","E Jiutas a teꞌ vëh to vikuh in e Ieesuꞌ manih pa napan varih to hat ov e ne poë, to ep en pa napan poë varih to soe ee pa ip vamët poë, pareꞌ pah tamak suntan en pataeah neꞌ to nok manih pe Ieesuꞌ. Ivëh, keꞌ teꞌ hah en pa kukön havun voaꞌ moniꞌ silvaꞌ varih no teꞌ susunön ësës heꞌ, me ro teꞌ susunön po Jiuꞌ to heꞌ voh poë, ");
INSERT INTO tpz_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","pareꞌ soe pan, “Eöꞌ to nok a hat, eöꞌ to heꞌ voh a neöm a teꞌ vëh to hikta nok voh ta hat.” Ko teꞌ susunön poë varih piun poë, pare soe pan, “Eꞌ a tah pamëh to hikta teꞌ non pan eꞌ a tah pemöm, ahik, eꞌ a tah koman pën.” ");
INSERT INTO tpz_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","E Jiutas to pënton vakomanih, pareꞌ vi ho en na pa moniꞌ manuh pa koman a Iuun Hinhin Apuh, pareꞌ nö ko oot en. ");
INSERT INTO tpz_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ko teꞌ susunön ësës heꞌ kon ee pa moniꞌ pamëh, pare soe pan, “A moniꞌ vaꞌih eꞌ a moniꞌ to voen non o eraꞌ pa teꞌ ip, ka hikta se vahoꞌ vaꞌpeh me no a moniꞌ va pa Iuun Hinhin Apuh, suk ataeah, o Vavaasis pe Mosës to soepip e non pea pa öt o vu moniꞌ poë varih.” ");
INSERT INTO tpz_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ivëh, kee vaonöt ee pa soe va pa ö nee se voen ta ö oeh pa nap nonok nöh, a ö oeh pamëh nee to voen suk a pe o teꞌ va pa ma meh muhin to mët manih Jerusalëm. ");
INSERT INTO tpz_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ivëh, nee to popokaꞌ suk ne sih a ö oeh pamëh pan, “O Oeh Va Po Eraꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ivëh, kataeah no a teꞌ vanënën soe vëh e Jeremaëaꞌ to sosoe suk voh non to tavus vaman en. Eꞌ to soe voh pan, “Ee to kon a kukön havun voaꞌ moniꞌ silvaꞌ to voen non a teꞌ pamëh no a napan va Israël to vaonöt voh. ");
INSERT INTO tpz_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","E sunön to soe ka neoꞌ pan a moniꞌ pamëh nee to voen voh a ö oeh pa nap nonok nöh.” ");
INSERT INTO tpz_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","E Ieesuꞌ to nö, pareꞌ sun en pa matan e susun pa kaman vëh, e Ponsius Paëlat. Keꞌ hi poan pan, “Eën ko a teꞌ sunön po Jiuꞌ, ha?” Ke Ieesuꞌ soe ke poan pan, “Eën koman to soe va eom nën.” ");
INSERT INTO tpz_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","O teꞌ susunön ësës heꞌ, me ra nap susunön to pokaꞌ poë pa ma soe peo. Ivëhkëk, e Ieesuꞌ to hikta piun ta soe. ");
INSERT INTO tpz_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ke Paëlat hi hahah kov en peꞌ pan, “Eën hikta tënan nom pa ma soe varih no a napan to vavateen a nom oah, ha?” ");
INSERT INTO tpz_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ke Ieesuꞌ hikta piun ta pah soe pe Paëlat. Ivëh, ke Paëlat pah toksean rakah en. ");
INSERT INTO tpz_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pa ma kirismas kurus pa Taëën Apuh va po Pasovaꞌ, no a teꞌ susun pa kaman se vatvus taneꞌ maꞌ a pah teꞌ nohnoh no a napan koman to iu ne. ");
INSERT INTO tpz_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Manih po poen pamëh to teꞌ non a pah teꞌ to teꞌ non pa nohnoh, no a napan to nat ne poë no a taateꞌ peꞌ to parin hat rakah. Ka ëhnaneah e Barabas. ");
INSERT INTO tpz_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ivëh, ko poen pamëh no a napan to tönun maꞌ manih pa teꞌ susun vëh e Paëlat. Keꞌ hi a napan, pareꞌ soe pan, “Eöm iu nem eteh nöꞌ se vatvus këh nös eah pa nohnoh? E Barabas, keꞌ, e Ieesuꞌ vëh nee to popokaꞌ ne poë e Kristo?” ");
INSERT INTO tpz_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","E Paëlat to soe vamanih, suk eꞌ to nat e non pee to puhioꞌ ne e Ieesuꞌ, ivëh, nee to vahoꞌ suk maꞌ poë manih pa koreneah. ");
INSERT INTO tpz_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","O poen ne Paëlat to ihoꞌ non pa ö ihihoꞌ pa teꞌ susun pëpënton vahutët, ke köövo manot peꞌ vanö ken maꞌ peꞌ pa soe to soe non pan, “Koe a ip vamët a teꞌ maneom, suk ataeah, eꞌ a teꞌ to hikta teꞌ non pan eꞌ a teꞌ nonok hat. Pa poen pa popoen nöꞌ to ep o tatarep, paröꞌ haraꞌ vahat rakah e noꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","O teꞌ susunön ësës heꞌ, me ro teꞌ susunön pa napan to heꞌ kokoman ee pa napan pan, ee se hin vakis na e Paëlat, keꞌ vatvus këh maꞌ e Barabas pa nohnoh, ko ip vamët varoe e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ke Paëlat hi rapoë pan, “E Barabas pen e Ieesuꞌ to teꞌ ne manih, ke eöm iu nem eteh nöꞌ se vanö hah nös manem peöm?” Ka napan soe pan, “Emöm to iu nem e Barabas.” ");
INSERT INTO tpz_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ke Paëlat hi hah en pee pan, “Keöꞌ se nok poꞌ ataeah manih pe Ieesuꞌ vëh nee to popokaꞌ ne poë e Kristo?” Ka napan piun e Paëlat, pare soe pan, “Ni öm eah pa kuruse.” ");
INSERT INTO tpz_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ke Paëlat soe pan, “Suk ataeah, a hat taeah neꞌ to nok?” Ivëhkëk, a napan to taoa suntan rakah ee ko soe ke Paëlat pan, “Ni öm eah pa kuruse.” ");
INSERT INTO tpz_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","E Paëlat to nat en pa napan to hikta antoen ne a tënan poë. A siꞌ ö hat ko vapus tavus en. Ivëh, keꞌ pupui en pa koreneah pa ruen, pa matëëra napan, pareꞌ soe pan, “A mët pa teꞌ vëh, nöꞌ hikta se teen noꞌ, ahik, eöm koman se teen a mët pamëh.” ");
INSERT INTO tpz_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ka napan kurus poë varih soe maꞌ pan, “Emöm koman se teen a mët pa teꞌ vaꞌih me ra ma koaꞌ pemöm. ");
INSERT INTO tpz_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","E Paëlat to vanö toꞌtoꞌ hah en maꞌ pe Barabas. Ivëhkëk, eꞌ to heꞌ en pe Ieesuꞌ manih pa nap vëvënsun, pan ee se rëp poë po uris rëprëp teꞌ, pare ni poë pa kuruse. ");
INSERT INTO tpz_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ka nap vëvënsun pa teꞌ susun vëh e Paëlat to me ho ee pe Ieesuꞌ manuh pa koman iuun pa teꞌ susun, ka nap vëvënsun tönun töön ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ee to ihan këh ee peꞌ po ohop peꞌ, pareꞌ ohop varuꞌ poë po ohop rë ereraꞌ vamanih pa teꞌ sunön, ");
INSERT INTO tpz_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","pare nok o uvan po uris toꞌtoꞌ, ko uvan poë, ko vaöt a papmatö peꞌ po toknon, pare vatokon ke poë, ko kö poë, pare hinën poë, pare soe pan, “Potan avih Sunön po Jiuꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ee to teteo poë, pare kon o toknon, ko navuh ee pa pasuneah. ");
INSERT INTO tpz_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kee vahik kö poë, ko pureꞌ hah këh ee peꞌ po ohop rë vëh nee to ohop poë, pare ohop hah ee peꞌ po ohop koman peꞌ. Ko me ee peꞌ manuh pa ö nee se ni poë pa kuruse. ");
INSERT INTO tpz_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","A nap vëvënsun to këkëh tavus ne maꞌ a vöön va Jerusalëm, pare akeh a teꞌ va pa vöön va Saëriniꞌ, ka muhin peꞌ ivëh Afrikaꞌ. A ëhnan a teꞌ pamëh e Saëmon. Ee to toon poë pa teꞌ vaꞌaus e Ieesuꞌ pa kuruse. ");
INSERT INTO tpz_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ee to tavus ee pa tope nee to pokaꞌ ne a Gölgötaꞌ. A pusun in o ëhnan pamëh to soe va non manih pan, “A ö no a ma kahoꞌ teꞌ to pet ne.” ");
INSERT INTO tpz_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ee to tavus nën ka nap vëvënsun hovën ee po voaën pa ëtoꞌ vatö kamis, pare kehkeh ne pan eꞌ se kaak. Eꞌ to punöꞌ en, ivëhkëk, eꞌ to koe en pa ëtoꞌ pais pamëh. ");
INSERT INTO tpz_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","A nap vëvënsun to ni ee peꞌ pa kuruse, pare ki vakëkëh a ma ohop peꞌ manih topniire, pa ö nee to vi a saatuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ee to ihoꞌ ne nën, pare ut ne poë to han non pa kuruse. ");
INSERT INTO tpz_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pare kiun a soe vaꞌih nee to vahoꞌ suk voh poë po vahutët, pare ni manih pasun a kuruse peꞌ. A soe pamëh to soe va non manih pan, “IVAꞌIH E IEESUꞌ A TEꞌ SUNÖN PO JIUꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Manih pa havin e Ieesuꞌ nee to ni a meh poa teꞌ kakaveo, a paeh to han ke non pa papmatö peꞌ, ka meh han ke non pa papkiruk. ");
INSERT INTO tpz_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","A napan to vaoah ne, pare kökö ne e Ieesuꞌ, ko vaviivi pasun ko vavövöneꞌ poë, ");
INSERT INTO tpz_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","pare soe ee pan, “Eën to soe voh pan, eën se kök a Iuun Hinhin Apuh va Jerusalëm, parën eok hah eöm peꞌ po kukön poen ro, ha? Hehe koman hah voh eo ah, parën këh kunah maꞌ a kuruse mane, pö nën se keh teꞌ nom e Koaꞌ vamaman pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","O teꞌ susunön ësës heꞌ, me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, me o teꞌ susunön po Jiuꞌ. Ee me to vavövöneꞌ e ne pe Ieesuꞌ, ");
INSERT INTO tpz_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","pare sosoe ne pan, “Eꞌ to vavaꞌaus voh non o upöm teꞌ, ivëhkëk, eꞌ to hikta onöt non a vaꞌaus koman hah ea.” Pare sosoe me ne pan, ‘Eën se keh teꞌ nom pan eën a Teꞌ Sunön pa napan va Israël. Aeoh! Këh kunah mah a kuruse, kemöm sih vaman poꞌ a oah.’ ");
INSERT INTO tpz_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Eꞌ to vaman non e Sosoenën, pareꞌ sosoe non pan, eꞌ e Koaꞌ pe Sosoenën. Ke Sosoenën se keh iu non poan, eꞌ se vaꞌaus en peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","A poa teꞌ kakaveo varih nee to ni sinten a teꞌ kuruse pe Ieesuꞌ. Ee me to vavövöneꞌ e ne peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pa topnin potan pa 12 kirök no a popoen to kopös en pa muhin avoes, pareꞌ nö ko hik pa 3 kirök pa matanpoen. ");
INSERT INTO tpz_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Vatët non pa 3 kirök ne Ieesuꞌ to kokoeꞌ suntan rakah en, pareꞌ soe pan, “Eloi, Eloi, rama sapaktani.” Eꞌ to sosoe va non manih pan, “Sosoenën peöꞌ, Sosoenën peöꞌ, eën varakah ka neoꞌ toh?” ");
INSERT INTO tpz_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ka napan to sun vatët ne manih pa ö ne Ieesuꞌ to han non to pënton a ö neꞌ to sosoe va non, pare soe pan, “Eꞌ to vavaoe non e Elaëjaꞌ, pan eꞌ se vaꞌaus poan!” ");
INSERT INTO tpz_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ka pah teꞌ vavaveo, pareꞌ vahoꞌ na a ta tah rö ötöt ruen manih po vinikaꞌ, pareꞌ vakapis poan po noton a tanaon, pareꞌ heꞌ e Ieesuꞌ pan eꞌ se kaak. ");
INSERT INTO tpz_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ivëhkëk, o upöm to soe ke na poë pan, “Anoeh voh nom ah, ka ep voh no, e Elaëjaꞌ se pöꞌ nö en maꞌ pa vaꞌaus poan, keꞌ ahik.” ");
INSERT INTO tpz_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ke Ieesuꞌ pah tötö suntan en, ka apeneah këh en peꞌ, keꞌ mët en. ");
INSERT INTO tpz_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ko rara vëh to han non manih pa koman a Iuun Hinhin Apuh tasi taneꞌ maꞌ manuh pasun, pareꞌ öök en manih po kusin, pareꞌ tavus en a poa tan. Ka rikrik ip manih po oeh, ko vös tatapon ee. ");
INSERT INTO tpz_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Ko oeh vëh pa ma vapeepe tatapon ee. Ke Ieesuꞌ sun momoaan hah en, ka nap peo pe Sosoenën varih to mëtmët voh kon hah ee po toꞌtoꞌ, ko sun hah këh ee pa ma koveꞌ pee. Pare vos ee pa vöön apuh po Jiuꞌ vëh Jerusalëm. Ka nap peo rakah ep ee pee. ");
INSERT INTO tpz_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ke susun pa nap vëvënsun, me ra nap vëvënsun varih to ut ne pe Ieesuꞌ to ep a rikrik, me a ma meh tah varih to tanok, a mët pe Ieesuꞌ, me a muhin to popoen en, ko vös tatapon ee, pare pah naöp suntan ee, ko soe ee pan, “A teꞌ vëh eꞌ vamaman rakah e Koaꞌ pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","O köövo o pöh peo rakah to sun varo këh e ne maꞌ pa kuruse, pare ut ne pataeah se tanok manih pe Ieesuꞌ. O köövo poë varih to heꞌ voh poë a ma taneah neꞌ to kökööt non, ee to vatet taneꞌ voh maꞌ poë manuh pa muhin va Galiliꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Manih topnin o köövo poë varih, a paeh va pee ivëh e Mariaꞌ va pa vöön va Makdalaꞌ, me e Mariaꞌ sinan e Jëmis, pen kea peꞌ Jeosëp. Ka meh köövo, eꞌ e sinan a poa koaꞌ pe Sëbëdiꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Manih pa matanpoen pamëh no a pah teꞌ öt ö to taneꞌ maꞌ pa vöön va Arimatiaꞌ, a ëhnan a teꞌ pamëh e Jeosëp. Eꞌ me voh a meh vamomhë pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","E Jeosëp to nö manuh pe Paëlat, pareꞌ hin eah pan eꞌ se teꞌ a sionin e Ieesuꞌ ko pe. Ke Paëlat taꞌ a nap vëvënsun kee herep taneꞌ a sionin e Ieesuꞌ manih pa kuruse, ko heꞌ ee pe Joesëp. ");
INSERT INTO tpz_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Moaan voh e Jeosëp to taꞌ a nap kiu peꞌ kee top voh a vös. A top pamëh eꞌ o vapeepe koman peꞌ. Ke Jeosëp me ra ma vamomhë peꞌ teꞌ ee pa sionin e Ieesuꞌ, ko kupkup ee peꞌ po rara voon kakaare. Pare teꞌ a sionineah ko vahoꞌ ee peꞌ pa top pamëh. Ee to toon hah maꞌ a meh vös, keꞌ teꞌ va non manih po ipapanih to sunpip non a matan a top vös pamëh ne Ieesuꞌ to pet non, pare hah ee. ");
INSERT INTO tpz_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ka poa Mariaꞌ, a teꞌ Mariaꞌ va Makdalaꞌ, me a meh Mariaꞌ e sinan Jëmis, pen Jeosëp to ihoꞌ vatët ne po vapeepe, pare ut ne. ");
INSERT INTO tpz_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ko meoh poen, eꞌ o Poen Apaapo, no o teꞌ susunön ësës heꞌ, me ro Parësiꞌ to nö ee manuh pe Paëlat, ");
INSERT INTO tpz_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","pare soe ke poë pan, “Apuh, emöm to nat hah a soe no a teꞌ pikpiuk vëh e Ieesuꞌ to teꞌ toꞌtoꞌ voh non, pareꞌ soe pan, ‘O kukön poen se oah, köꞌ toꞌ hah eoꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ivëh, kën se soe vakis rakah ke ra nap vëvënsun varih to ut ne pa koveꞌ, kee ut vavih ne keꞌ öök po vakön poen. A ma vamomhë peꞌ tomeꞌ nö maꞌ, pare teꞌ aven ee pa sionin e Ieesuꞌ, pare soe ke ra napan pan, eꞌ to toꞌ ko sun taneꞌ hah en po vapeepe. Ee tomeꞌ nok to piuk voon to hat oah e non po teꞌ piuk vamoaan. O piuk vamoaan ivëh, ne Ieesuꞌ to soe voh pan, eꞌ e Kristo.” ");
INSERT INTO tpz_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ke Paëlat soe ke rapoë pan, “Kon ta ma teꞌ vëvënsun, kee nö ko ut ne po vapeepe. Eöm se nö, paröm nok a ma taneah nom to nat nem. ");
INSERT INTO tpz_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ivëh, kee nö kurus ee manuh pa ö ne Ieesuꞌ to pe non, pare nok vavavih rakah ee pa ma taneah to se sunpip non a nap kakaveo. Ee to vahoꞌ ee po supon manih pa vös vëh to sunpip non a matan a koveꞌ, pare vahoꞌ ee pa nap vëvënsun varih to ut ne. ");
INSERT INTO tpz_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","O Poen Apaapo to oah en, ka muhin takah en po poen vamomoaan in o meoh nënkikiu, ne Mariaꞌ va Makdalaꞌ, me e meh Mariaꞌ vëh e sinan e Jëmis pen e Jeosëp, to nö ee pon pa ep pa ö ne Ieesuꞌ to pe non. ");
INSERT INTO tpz_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ka varuꞌ rakah vakomanih no a rikrik to ip en. Ka ankeroꞌ pe Sosoenën taneꞌ maꞌ pa vöön va kin, pareꞌ nö ko vahuk en pa vös vëh to sunpip non a matan a top vëh ne Ieesuꞌ to pet non, ko ihoꞌ e non pa vös pamëh, ");
INSERT INTO tpz_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","pareꞌ ëman va e non manih pa vakës pa kara, ko ohop peꞌ kakaare va e non manih pa unöh kakaare. ");
INSERT INTO tpz_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ka nap vëvënsun varih to ut ne pa koveꞌ ep a ankeroꞌ, pare töhkak, ko naöp rakah ee, pare teꞌ ke ne pan a nap mët. ");
INSERT INTO tpz_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ka ankeroꞌ soe ke ra poa köövo pan, “Koe a naöp. Eöꞌ to nat e noꞌ peöm to nö maꞌ pa ep këh e Ieesuꞌ vëh, nee to ni voh poë pa kuruse. ");
INSERT INTO tpz_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Eꞌ to hikta pet non manih. Eꞌ to sun taneꞌ hah en po vapeepe vamanih pa ö neꞌ to soe vavoh. Nö maꞌ öm, paröm ep pa ö no a sionineah to pet voh non, ");
INSERT INTO tpz_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","paröm nö vëhöꞌ na manuh pa ma vamomhë peꞌ, ko soe ke raoe pan, ‘E Ieesuꞌ to sun taneꞌ hah en po vapeepe. Eꞌ se vovoh ken peöm manuh Galiliꞌ. Ke eöm se nö, paröm ep eah nën.’” A ankeroꞌ to vavaato avoeꞌ me e non pa poa köövo, pareꞌ soe pan, “Eöm se nat nem anoe a soe vëh nöꞌ to heꞌ a neöm kuru.” ");
INSERT INTO tpz_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ivëh, ka poa köövo poë varih këh vëvëhöꞌ rakah ee po vapeepe. Ee to karë, pare vaeö suntan rakah ee, ko nö ee pa soe vanat a ma vamomhë pe Ieesuꞌ pataeah to tavus vu. ");
INSERT INTO tpz_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","A poa köövo to vavaveo nö ne manuh pa ep pa ma vamomhë pe Ieesuꞌ. Ke Ieesuꞌ akeh rapoë, pareꞌ soe pan, “Pöstakah rakah.” Ka poa köövo huk vatët ee manih peꞌ, ko vaket ee pa moneah, pare kë ee pa ëhnaneah. ");
INSERT INTO tpz_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ke Ieesuꞌ soe ke rapoë pan, “Koe a naöp, ko nö, paröm soe ke ra ma vamomhë peöꞌ. Kee nö manuh pa muhin va Galiliꞌ, pare ep ka neoꞌ nën.” ");
INSERT INTO tpz_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","A poa köövo to nönö avoeꞌ nö e ne pa soe ke ra ma vamomhë pe Ieesuꞌ, ka ma meh teꞌ vëvënsun varih to ut ne pa koveꞌ vos ee manuh Jerusalëm pa soe vanat o teꞌ susunön ësës heꞌ pataeah to tanok. ");
INSERT INTO tpz_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ko teꞌ susunön ësës heꞌ tönun vaꞌpeh me ee po teꞌ susunön po Jiuꞌ, pare nok ee po kokoman vakoaan. Ee to voen a nap vëvënsun pa moniꞌ a pah apuh rakah, ");
INSERT INTO tpz_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","pare soe ke rapoë pan, “Soe vanat a napan a ö no a ma vamomhë pe Ieesuꞌ to nö maꞌ pa popoen, pare kaveo a sionineah, ko teꞌ varo ee peꞌ pa ö nöm to koroh varo. ");
INSERT INTO tpz_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","A teꞌ susun va pa kaman se keh pënton a ö no vamomhë pe Ieesuꞌ to kaveo a sionin e Ieesuꞌ pa ö nöm to koroh varo, emöm se vaato me em peꞌ, ko vatotoopin em pa tah pamëh. Köm hikta se teꞌ me nem ta punis.” ");
INSERT INTO tpz_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ivëh, ka nap vëvënsun öt ee pa moniꞌ no teꞌ susunön ësës heꞌ, me ro teꞌ susunön po Jiuꞌ to voen rapoë, pare vatet ee pa soe pee. Ko vahutët pamëh no o Jiuꞌ to nat avoeꞌ e ne peꞌ kuru. ");
INSERT INTO tpz_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","A havun me a pah vamomhë to nö ee Galiliꞌ. Ee to nö ee manuh pa tope vëh ne Ieesuꞌ to soe ke voh rapoë pan ee se nö. ");
INSERT INTO tpz_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pare ep ee e Ieesuꞌ manuh pa tope, ko kë ee pa ëhnaneah. Ivëhkëk, o upöm pee to hikta vaman tiroëꞌ ne pan eꞌ e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ke Ieesuꞌ huk vatët en maꞌ manih pee, pareꞌ soe ke rapoë pan, “E Sosoenën to heꞌ voh en peöꞌ pa tasun apuh va pa matop a vöön va kin, me o oeh. ");
INSERT INTO tpz_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ivëh, köm se nö, paröm vavaasis a napan pa ma ö kurus va po oeh. Kee tavus a ma vamomhë peöꞌ, paröm pupui raoe pa ëhnan e Taman, me Koaꞌ, me a Tuvuh Vasioꞌ. ");
INSERT INTO tpz_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Eöm se vavaasis raoe pa vatet a ma taateꞌ kurus nöꞌ to vavaasis voh a neöm. Eöꞌ to soe vamaman rakah ke eoꞌ peöm, eöꞌ se teꞌ vaꞌpeh tamoaan me e noꞌ peöm pa ma poen kurus, keꞌ onöt rakah këk po poen no oeh vëh se hik.” ");
INSERT INTO tpz_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ivaꞌih a soe man pe Ieesuꞌ Kristo, e koaꞌ pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","A soe man pamëh to taneo vavoh manih pa ö ne Aisaëaꞌ a teꞌ vanënën soe to kiun vavoh, pareꞌ soe vamanih pan, “Pënton ah, eöꞌ se vanö nös a teꞌ vëh se teꞌ vovoh nös a soe peöꞌ manem pën, eꞌ se vovoh ka oah, pareꞌ vamatop a hanan pën.” ");
INSERT INTO tpz_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Manih pa moeh upin a pah teꞌ to vavaoe no maꞌ pan, ‘Vamatop öm a hanan pe Sunön, paröm vatotoopin a ma hanan peꞌ.’” ");
INSERT INTO tpz_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","E Jon Tövapupui to teꞌ non pa moeh upin, pareꞌ vavatvus non a soe pe Sosoenën, pan a ma napan se pënton, ko panih a ma taateꞌ hat pee, pare pupui rea, ke Sosoenën se ihan anoe a ma hat pee. ");
INSERT INTO tpz_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","A ma napan va pa muhin va Jiutiaꞌ, me ra napan va Jerusalëm to nö kurus ee maꞌ pa tënan a soe pe Jon, pare soe tavus ee pa ma hat pee, ke Jon pupui en pee manih pa ruen Jödën. ");
INSERT INTO tpz_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","E Jon to ohop non o ohop nee to nok voh pa uvin këmol, pareꞌ voh non o voh to tavi non a vuvuhuneah, pareꞌ ënëën non sih o kokaꞌ, pareꞌ kakaak non o hun tankekvö va muhin. ");
INSERT INTO tpz_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","E Jon to vavatvus non a ma soe peꞌ manih pa napan, pareꞌ soe pan, “A teꞌ vëh se suk a maꞌ neoꞌ, no o kikis peꞌ to teꞌ oah e non po teꞌ kikis peöꞌ. Eöꞌ hikta vih onöt noꞌ a vatokon, paröꞌ ihan këh eah o uris vëh pa poa suꞌ peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Eöꞌ to pupui a noꞌ neöm pa ruen, ivëhkëk eꞌ se pupui a neöm pa Tuvuh Vasioꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","A ma siꞌ poen to oah ee, ke Ieesuꞌ këh maꞌ a vöön va Nasarët manuh pa muhin va Galiliꞌ, eꞌ to nö maꞌ ke Jon pupui poan manih pa ruen Jödën. ");
INSERT INTO tpz_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","E Ieesuꞌ to tatakin nö këh ko non maꞌ a ruen, pareꞌ ep in a akis to nö vakëh. Ka Tuvuh Vasioꞌ kunah maꞌ manih peꞌ vamanih pa panuh. ");
INSERT INTO tpz_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ka to taneꞌ maꞌ manuh pa vöön va kin pe Sosoenën, to soe va non manih pan, “Eën e koaꞌ rakah peöꞌ, eöꞌ to iu oah vi ka nom oah, paröꞌ vaeö me noꞌ oah.” ");
INSERT INTO tpz_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ka Tuvuh Vasioꞌ vanö vëvëhöꞌ en pe Ieesuꞌ manuh pa moeh upin. ");
INSERT INTO tpz_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","E Ieesuꞌ to teꞌ o 40 poen nën, ke susun po oraꞌ hat punöꞌ poan. Eꞌ to teꞌ vaꞌpeh me non o tah poa va pa moeh upin, ko ankeroꞌ matop e ne peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","E Ieesuꞌ to öök pa muhin va Galiliꞌ murin in a ö nee to vahoꞌ ee pe Jon Tövapupui pa nohnoh nën, suk eꞌ to rës e non pa taateꞌ hat ne sunön va Galiliꞌ to nonok non. Manih po poen pamëh ne Ieesuꞌ to taneo en pa vavaasis a soe man pe Sosoenën manuh Galiliꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","E Ieesuꞌ to soe ke ra napan pan, “O poen vih ne Sosoenën to vateꞌ voh to tavus en, a Matop Vih pe Sosoenën to öök vatët en maꞌ, söm panih a ma kokoman peöm, paröm vaman a soe man peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","E Ieesuꞌ to hëhë nö non pa sinten tonon va Galiliꞌ, pareꞌ ep in e Saëmon, pen e kea peꞌ Ëndruꞌ to tatanaꞌ iian ne pa kë pee, ee pon to tatanaꞌ iian ne sih pa kë pee manih pa tonon va Galiliꞌ, ov in a vavoen. ");
INSERT INTO tpz_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ke Ieesuꞌ soe ke rapoë pan, “Suk a maꞌ neoꞌ öm pom, köꞌ sih vavaasis a neöm pa vaon a napan, kee hop maꞌ manih pa Matop Vih pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ka varuꞌ rakah vakomanih ne ee pon to këh ee maꞌ pa kë pee, pare vatet ee pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Keꞌ hë a sih ö hat, pareꞌ ep in e Jëmis pen e kea peꞌ Jon, a poa koaꞌ oeteꞌ pe Sëbëdiꞌ to tok ne po paröꞌ, pare vunvun hah ne a kë pee to tökrus. ");
INSERT INTO tpz_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ke Ieesuꞌ vaoe vëvëhöꞌ rakah en na pee, kee këh ee maꞌ pe tamëëre Sëbëdiꞌ, me ra nap kiu peꞌ to tok ne po paröꞌ, ke Jëmis pen Jon vatet ee pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","E Ieesuꞌ me ra taanaꞌ vamomhë peꞌ to vos ee manuh Kapaneam. Po Poen Apaapo ne Ieesuꞌ to ho en pa iuun hinhin soneꞌ po Jiuꞌ, pareꞌ taneo en po vavaasis peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","A napan to pënton a ma vavaasis pe Ieesuꞌ, pare pah töhkak vahat ee. Eꞌ to hikta teꞌ va non manih po teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, ahik, eꞌ to vavaasis me non o kikis. ");
INSERT INTO tpz_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Manih po poen pamëh a pah teꞌ to teꞌ non koman iuun hinhin soneꞌ, no a pah oraꞌ hat to teꞌ non peꞌ, eꞌ to pah kokoeꞌ suntan en pareꞌ soe pan, ");
INSERT INTO tpz_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Koe ka möm ah, ataeah nën to iu nom manih pemöm, Ieesuꞌ va Nasarët, eën nö maꞌ pa miröꞌ a möm öh? Eöꞌ to nat e noꞌ pën a Teꞌ Vivihan pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","E Ieesuꞌ to siröꞌ a oraꞌ pamëh, ko soe pan, “Vatotomin ah! Parën këh tavus maꞌ a teꞌ manem.” ");
INSERT INTO tpz_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ka oraꞌ hat pah kö suntan en pa teꞌ pamëh, pareꞌ pah kokoeꞌ suntan en, ko këh tavus en peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ka napan vatötöhkak rakah ee, pare taneo ee pa vaiihi koman hah pan, “Ataeah rakah ivaꞌih? Eꞌ a ma vavaasis voon, to teꞌ me non o kikis o pöh apuh rakah, eꞌ se taꞌ o oraꞌ hat, kee tënan e pa soe peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ivëh, ko vahutët va pa ma tah apaꞌpuh ne Ieesuꞌ to nok voh nö vëhöꞌ rakah en pa ma ö kurus va pa muhin va Galiliꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","O poen nee to këh tavus maꞌ a iuun hinhin soneꞌ po Jiuꞌ, pare nö totoopin rakah ee manuh pa iuun pe Saëmon pen Ëndruꞌ, e Jëmis pen Jon to nö vaꞌpeh me raoe. ");
INSERT INTO tpz_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","E noan e Saëmon to koroh non tevan to haraꞌ non a hiinana, ka napan soe vëvëhöꞌ kee pe Ieesuꞌ pe noan e Saëmon. ");
INSERT INTO tpz_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ke Ieesuꞌ öök en manuh peꞌ, pareꞌ öt en pa koreneah, ko kë vasun en peꞌ, ka hiinana hik këh en peꞌ, keꞌ sun ko vamatop en pa taëën pee. ");
INSERT INTO tpz_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pa matanpoen no a potan to kunah en, ka napan teꞌteꞌ ee maꞌ pa napan varih to haraꞌ ne a ma mët, me ro teꞌ varih no a ma oraꞌ hat to teꞌ hop ne manih pee. ");
INSERT INTO tpz_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ka napan va pa vöön apuh pamëh tönun ee maꞌ manih pa matan in a iuun pamëh. ");
INSERT INTO tpz_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ke Ieesuꞌ vavatoꞌ hah en pa ma napan to teꞌ me ne a ma vu mët, pareꞌ veo vavah en po oraꞌ hat, ko oraꞌ hat poë varih nat e ne peꞌ e Ieesuꞌ, e koaꞌ pe Sosoenën, ivëh keꞌ soepip en po oraꞌ pa vaato. ");
INSERT INTO tpz_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pa pöstakah rakah ne Ieesuꞌ to sun, pareꞌ këh tavus en pa iuun, ko këh en pa vöön, ko nö en pa ö totomin no ahikta teꞌ to teꞌ non, pareꞌ hinhin e non nën. ");
INSERT INTO tpz_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","E Saëmon me ra ma upöm peꞌ to nö ee pa vaiu poë. ");
INSERT INTO tpz_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ee to taum poë, pare soe ke poë pan, “A nap peo rakah to vavaiu vah ka nom oah.” ");
INSERT INTO tpz_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ke Ieesuꞌ piun va in a soe pee manih pan, “Koe voh öm, ka nö voh pa ta ma meh vöön vatët manih, eöꞌ se vatvus pet a Soe Vih manih pee, suk ataeah, eꞌ a tah ne eöꞌ to nö suk voh maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Keꞌ nö vavah en manih pa ma ö muhin va Galiliꞌ, pareꞌ vavaasis non a ma napan manih koman a ma iuun hinhin soneꞌ, pareꞌ veo këh en po teꞌ po oraꞌ hat. ");
INSERT INTO tpz_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ka pah teꞌ to teꞌ me non a mët töpaꞌ nö maꞌ manih pe Ieesuꞌ, pareꞌ vatokon, ko ook marën e Ieesuꞌ se vaꞌaus poan, pareꞌ soe pan, “Eën se keh iu nom kën vatoꞌ hah eom peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","E Ieesuꞌ to uruan vörep a teꞌ pamëh, ko vaket poan, pareꞌ soe pan, “Eöꞌ to iu e noꞌ pa ö nën se voon hah. Voon ah.” ");
INSERT INTO tpz_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ka varuꞌ rakah vakomanih no a mët töpaꞌ to hik këh en peꞌ, keꞌ vih hah en. ");
INSERT INTO tpz_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ke Ieesuꞌ vuhvuh vakis poan, pareꞌ soe pan, “Matop nom ah. Eën se nat nom vavatët a tah vaꞌih to tanok pa sioniumah pa ta ma meh teꞌ. Ivëhkëk, eën se nö totoopin na manuh po teꞌ ësës heꞌ, ko vataare a sioniumah me o heꞌ pën. Ka teꞌ ësës heꞌ ës ke na e Sosoenën vamanih pa ö no Vavaasis pe Mosës to soe vavoh non. Ivëh, ka napan se nat ne a mët pën to hik en, kën voon hah eom.” ");
INSERT INTO tpz_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ivëhkëk, a teꞌ pamëh to këh e Ieesuꞌ, pareꞌ taneo en pa vahutët vavah a ö ne Ieesuꞌ to vatoꞌ hah poan manih pa ma ö kurus. Ivëh, ke Ieesuꞌ hikta onöt rakah non a vos vavah pa ma vöön pa matëëra napan. Ivëh, keꞌ teꞌ e non pa ö totomin no ahikta teꞌ to teꞌ non, ka napan nönö e ne maꞌ manih peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ka ma siꞌ poen oah ee, ke Ieesuꞌ vos hah en maꞌ manih Kapaneam, ka napan pënton a soe to soe non pan, e Ieesuꞌ to teꞌ non pa iuun kokoroh peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ka nap peo tönun maꞌ, ka koman iuun puh rakah en, ka hikta siꞌ ö to teꞌ akuk non, o matan hopaꞌ me o puh rakah, manih po poen ne Ieesuꞌ to vavaasis non raoe. ");
INSERT INTO tpz_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ka taanaꞌ teꞌ, teꞌ ee maꞌ pa teꞌ tëtënkun manih pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Suk ataeah, a napan to peo, ivëh, kee hikta antoen ne a teꞌ ho a teꞌ tëtënkun pamëh manuh pe Ieesuꞌ. Ivëh, kee teꞌ peah ee pa teꞌ tëtënkun pamëh manuh pa tonun iuun vëh ne Ieesuꞌ to teꞌ non. Pare tai ee pa ma si vös in a tonun iuun pamëh, pare vöknah totoopin ee na pa teꞌ pamëh to koroh non po pan peꞌ manuh pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","E Ieesuꞌ to inan o vaman pee, ivëh, keꞌ soe ke a teꞌ tëtënkun pamëh pan, “Koaꞌ peöꞌ, a ma hat pën nöꞌ to ihan anoe eoꞌ pee.” ");
INSERT INTO tpz_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ka ma teꞌ vavaasis to nat i ne o Vavaasis pe Mosës to pët ihoꞌ e ne nën, ka manih pa ma kokoman pee nee to koman aven e ne pan, ");
INSERT INTO tpz_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Eꞌ teꞌ vah va non nih, ka teꞌ vëh sosoe va non manih? A teꞌ vëh to sosoe oꞌoah e non pe Sosoenën, ahikta pah teꞌ to onöt non a ihan anoe a hat pa meh teꞌ. E Sosoenën varoe to antoen non a ihan anoe a ma hat po teꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","E Ieesuꞌ to nat ohoꞌ en na pa ma kokoman vakoaan pee, ivëh, keꞌ soe ke raoe pan, “Suk ataeah nöm to teꞌ me nem a ma vu kokoman varih? ");
INSERT INTO tpz_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Eꞌ hikta teꞌ hivaꞌ non pa soe ke a teꞌ tëtënkun pan, ‘A ma hat pën nöꞌ to ihan anoe’. Suk ataeah, o upöm teꞌ hikta antoen ne a inan vamanih pan a ma hat peꞌ to hik ee. Ivëhkëk, eꞌ to hivaꞌ oah e non pa soe ke a teꞌ tëtënkun pan, ‘Eën se sun, parën kon o pan pën, ko nö eom’. Suk ataeah, a ma napan se ep ne pan a teꞌ pamëh to toꞌ hah en. ");
INSERT INTO tpz_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ivëhkëk, eöꞌ se vamaaka ka neöm ta pah tah, köm se vaman, ko nat ka neoꞌ e Koaꞌ Teꞌ Pa Napan Kurus to teꞌ me noꞌ pa tasun manih po oeh marën a ihan anoe a ma hat.” ");
INSERT INTO tpz_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ivëh, keꞌ soe ke a teꞌ tëtënkun pamëh pan, “Eöꞌ to soe ka oah, sun ah, parën kon o pan pën, ko nö eom manuh pa iuun pën.” ");
INSERT INTO tpz_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Manih pa matëëra napan varih to ep ne, no a teꞌ tëtënkun pamëh to sun vëvëhöꞌ rakah en, pareꞌ kon o pan peꞌ ko nö en. Ka napan kurus varih to ep ne to pah töhkak vahat rakah ee. Ko kë ee pa ëhnan e Sosoenën, pare soe pan, “Ea to hikta ep moaan voh no ta ma meh tah to matan va ne manih!” ");
INSERT INTO tpz_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","E Ieesuꞌ to këh en maꞌ pa vöön va Kapaneam, pareꞌ hëhë vah non pa sinten a tonon va Galiliꞌ, ka nap peo nö ee maꞌ manih peꞌ, keꞌ taneo en pa vavaasis raoe. ");
INSERT INTO tpz_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ko poen neꞌ to nönö nö non, pareꞌ ep in a teꞌ kokon takis to ihoꞌ non pa iuun kokon takis. A ëhnaneah e Livaë, eꞌ e koaꞌ pe Apias. Ke Ieesuꞌ soe ke poan pan, “Suk a maꞌ neoꞌ ah.” Keꞌ sun, ko vatet en pe Ieesuꞌ ");
INSERT INTO tpz_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","O poen ne Ieesuꞌ to ënëën non pa koman iuun pe Livaë, a nap kokon takis o pöh peo rakah, me ro upöm teꞌ no a ma taateꞌ pee to hat, eꞌe to ënëën vaꞌpeh me ne Ieesuꞌ me ra ma teꞌ vamomhë peꞌ. Ee a ma napan poë varih to vavatet tamoaan vah ne e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","O teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, eꞌe o Parësiꞌ, ee to ep in e Ieesuꞌ, me ra napan no a ma taateꞌ pee to hat to ënëën vaꞌpeh me ne e Ieesuꞌ. Ivëh, kee hi a ma teꞌ vamomhë peꞌ pan, “Eꞌ teꞌ vah va non nih ke Ieesuꞌ ënëën vaꞌpeh me e non pa nap kokon takis, me ro teꞌ no a ma taateꞌ pee to hat?” ");
INSERT INTO tpz_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","E Ieesuꞌ to tënan a soe pe pareꞌ piun a soe pee ko soe pan, “O teꞌ varih to hikta haraꞌ ne a mët, eꞌe to hikta onöt ne a nönö pa ep e röktaꞌ. Ahik. A napan varoe varih to haraꞌ ne a mët to nönö ne sih pa ep pe röktaꞌ. Eöꞌ to hikta nö voh maꞌ pa vaꞌaus o teꞌ varih to koman ne pan ee ro totoopin. Ahik. Eöꞌ to nö voh maꞌ pa vaꞌaus o teꞌ varih to nat va ne manih pan ee ro teꞌ hat.” ");
INSERT INTO tpz_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","O pöh poen no a ma vamomhë pe Jon Tövapupui, me ro Parësiꞌ to vapenpen ne pa ëën. Ka ma pah to Parësiꞌ me a ma pah teꞌ vamomhë pe Jon Tövapupui to nö maꞌ pe Ieesuꞌ, ko hi poë pan, “Vahvanih, ko teꞌ vamomhë pe Jon Tövapupui me ro teꞌ vamomhë po Parësiꞌ vapenpen e ne pa ëën, ivëhkëk, o teꞌ vamomhë pën to kök ee pa taateꞌ pea, pare hikta vapenpen ne pa ëën a taëën, suk ataeah?” ");
INSERT INTO tpz_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ke Ieesuꞌ piun, ko soe ke raoe pan, “Eꞌ kës to vih e non pa ö no a ma teꞌ pe voe tövaen vavoon se vapenpen e ne pa ëën? Ahik rakah. E voe tövaen vavoon se keh teꞌ vaꞌpeh me non raoe, eꞌe hikta se vapenpen ne pa ëën. Suk ataeah, ee to vaeö me e ne pe voe tövaen vavoon. ");
INSERT INTO tpz_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ivëhkëk, a ma poen se tavus maꞌ no upöm teꞌ se me ke ee pe voe tövaen vavoon keꞌ këh en pa ma teꞌ peꞌ. Manih po poen pamëh eꞌe se vapenpen ee pa taëën. Suk ataeah, eꞌe to tamak e ne poë. ");
INSERT INTO tpz_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ke Ieesuꞌ heꞌ a meh poa soe manih koman a soe vapipinoꞌ, pareꞌ soe pan, “Manih po vavaasis vamoaan ea se nat no vahovën me no o vavaasis voon peöꞌ.” Pareꞌ soe pet en pan, “A teꞌ to hikta onöt non a ö seꞌ kon a ta rara voon marën a kun pip a töhkoꞌ vëh to teꞌ non po rara vamoaan. Eꞌ se keh nok va nën, o rara voon se kurus vaꞌpuh en pa töhkoꞌ va po rara vamoaan, suk o rara voon se soneꞌ en.” ");
INSERT INTO tpz_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ke Ieesuꞌ vavaato avoeꞌ e non pareꞌ soe pan, “A hikta teꞌ me se isu o voaën voon manih po pëk vamoaan nee to kun po kap sipsip. Eꞌ se keh isu en po voaën voon o voaën voon se kurus en po pëk vamoaan. Suk o pëk vamoaan to hikta onöt non a tëptot. Ivëh, ko pëk se tökrus en, ko voaën takoꞌ en. Ahik. Eöm se isu o voaën voon manih po pëk voon nee to kun po kap sipsip.” Ivëh, ka se nat no öt vatös in o vavaasis vamoaan me o vavaasis voon pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Po pöh Poen Apaapo ne Ieesuꞌ to nönö vah non manih pa koman a rak vëh nee to nep voh a kon. A ma vamomhë pe Ieesuꞌ to nönö vaꞌpeh vah me e ne peꞌ, ka ma vamomhë peꞌ kökök a ma voaꞌ kon pan ee se ëën. ");
INSERT INTO tpz_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ivëh, ko Parësiꞌ soe ke Ieesuꞌ pan, “Ep ah, a taateꞌ pea to vapenpen e non pa nok vamanih po Poen Apaapo. Eöm nonok suk va nem manih ataeah?” ");
INSERT INTO tpz_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “Eöm kës to ëh voh em po vahutët va pa tah ne Devit to nok voh me ra ma vamomhë peꞌ, pa ö nee to maë voh, ha? ");
INSERT INTO tpz_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","O poen neꞌ to ho voh pa koman iuun vapenpen pe Sosoenën, e Abaëataꞌ he teꞌ non e susun po teꞌ ësës heꞌ, pareꞌ ëën voh en pa taëën pamëh. E Devit to ëën a taëën pamëh no teꞌ ësës heꞌ varoe to ënëën ne, pareꞌ heꞌ me en pa ma vamomhë peꞌ to teꞌ me ne poë. A taëën pamëh nee to heꞌ voh ee na pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ke Ieesuꞌ soe ke rapoë pan, “E Sosoenën to hikta nok voh a napan marën a vaꞌaus o Poen Apaapo, ahik, eꞌ to nok voh o Poen Apaapo marën a vaꞌaus a napan. ");
INSERT INTO tpz_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ivëh, keöꞌ koman e Koaꞌ Teꞌ Pa Napan Kurus to Sunön ke noꞌ po Poen Apaapo.” ");
INSERT INTO tpz_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","E Ieesuꞌ to ho hah en pa iuun hinhin soneꞌ manuh pa ö no a pah teꞌ tënkun koren to teꞌ non nën. ");
INSERT INTO tpz_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","A napan to ut vavih rakah e ne pe Ieesuꞌ, pan eꞌ se nok vavih a teꞌ tënkun koren pamëh po Poen Apaapo, ivëh, kee se pokaꞌ poë pa hat, ko vahoꞌ poë po vahutët. ");
INSERT INTO tpz_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ke Ieesuꞌ soe ken pa teꞌ vëh no koreneah to tënkun pan, “Maꞌ ah manih.” ");
INSERT INTO tpz_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ivëh, ke Ieesuꞌ hi en pa napan pan, “Ea se nok a taateꞌ vih po Poen Apaapo, keꞌ ea se nok a taateꞌ hat? Eꞌ to vih pöꞌ e non pea se vaꞌaus ro teꞌ, kee teꞌ vavih ne, keꞌ ea se koe a vaꞌaus eah, keꞌ mët en?” Ivëhkëk a napan to hikta soe ta soe. ");
INSERT INTO tpz_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","E Ieesuꞌ to kuteꞌ i ra napan, ko pah heve en, ko tamak en pee, suk a ö nee to paraꞌ vatö vaasis, pare kokoman pinpiun. E Ieesuꞌ to taꞌ a teꞌ tënkun koren pamëh pan, “Putot a koreomah.” Keꞌ putot en pa koreneah, keꞌ totoopin, ko vih hah en. ");
INSERT INTO tpz_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ko Parësiꞌ këh ee pa iuun hinhin soneꞌ, pare tönun ohoꞌ me ee po teꞌ kum teꞌ pe Hëërot, kee vavaiu vah këh e ne ta hanan nee se ip vamët koe in e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ke Ieesuꞌ me a ma vamomhë peꞌ këh ee pa vöön nee to teꞌ ne, ko nö ee manuh pa sinten a tonon va Galiliꞌ, ka napan o pöh peo rakah to suk poë. A napan peo poë varih to taneꞌ maꞌ Galiliꞌ, Jiutiaꞌ, me manuh Jerusalëm, me ra napan va pa muhin va Itumiaꞌ, me manuh pa pap Jödën vöh, me a ma napan va pa poa vöön varih Taëaꞌ me Saëdon. A nap peo rakah to nö maꞌ pa pënton e Ieesuꞌ, suk eꞌe to tënan a ma kiu neꞌ to nonok non, no a hikta teꞌ akuk to antoen non a nok, e Ieesuꞌ varoe. ");
INSERT INTO tpz_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ke Ieesuꞌ taꞌ a ma vamomhë peꞌ pan, eꞌe se rëh vatët maꞌ to paröꞌ, keꞌ se tok, suk a napan to peo tomaꞌ tot vavah in poë. ");
INSERT INTO tpz_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","E Ieesuꞌ to vavatoꞌ a nap peo, ko teꞌ varih to teꞌ me ne a ma mët iu hariun ne e Ieesuꞌ. Ivëh, kee pipihih nö e ne maꞌ pa napan, suk eꞌe to iu hariun ne e Ieesuꞌ pan a ma mët pee se hik. ");
INSERT INTO tpz_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ka napan varih no oraꞌ hat to teꞌ hop ne pee, to ep i na e Ieesuꞌ, pare pah vatokon ee manih pa mataneah, pare sosoe ne pan, “Eën e Koaꞌ pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ke Ieesuꞌ vuhvuh vakis rakah en po oraꞌ hat pan, o oraꞌ hat poë varih se nat ne vatvus vateeraꞌ a ëhnaneah manih po upöm teꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","E Ieesuꞌ to peah en manuh pa tope, pareꞌ vaoe ununun koman en na pa ma teꞌ neꞌ to iu non. Ka ma teꞌ poë varih nö ee maꞌ manih peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ke Ieesuꞌ vateꞌ en po havun teꞌ me a pöök, pareꞌ vëhnan raoe o aposol. E Ieesuꞌ to soe ke raoe pan, “Eöꞌ to kon a neöm pan eöm se teꞌ vaꞌpeh me a no neoꞌ. Eöꞌ se vanö a neöm, köm vatvus a soe manuh pa ma napan.” ");
INSERT INTO tpz_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","E Ieesuꞌ to heꞌ raoe a tasun peꞌ, marën a nok a kiu va pa veo këh a napan po oraꞌ hat. ");
INSERT INTO tpz_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Eꞌe varih o havun teꞌ me a pöök neꞌ to vateꞌ, e Saëmon vëh ne Ieesuꞌ to vëhnan poan e Pitaꞌ, ");
INSERT INTO tpz_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ke Jëmis pen kea peꞌ Jon, ee a poa sunaiꞌ Sëbëdiꞌ, e Ieesuꞌ to vëhnan raoe pon e Poaanesis, a pusun in o ëhnan pamëh to teꞌ va non manih pan, “A poa koaꞌ to toto va ne manih pa kara”. ");
INSERT INTO tpz_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ke Ëndruꞌ, ke Filip, ke Batromioꞌ, ke Matiu, ke Tömas, ke Jëmis e sunaiꞌ Apias, ke Tëdius, ke Saëmon, a teꞌ vëh to taneꞌ voh maꞌ po kum nee to popokaꞌ ne o Sërat. ");
INSERT INTO tpz_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ke Jiutas Iskariot, to taneꞌ maꞌ Kariot, eꞌ a teꞌ pamëh se vikuh e Ieesuꞌ manuh pa koreera napan varih to hat ov e ne poë. ");
INSERT INTO tpz_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","E Ieesuꞌ to vos hah en Kapaneam, me ra ma vamomhë peꞌ. A nap peo rakah to tönun haha kov ee maꞌ, ke Ieesuꞌ me ra ma vamomhë peꞌ hikta onöt rakah ne a ëën, suk eꞌe to posean ne pa vaꞌaus a napan. ");
INSERT INTO tpz_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ka ma poan e Ieesuꞌ nat in a tah vaꞌih, pare nö ee maꞌ, pan eꞌe se me poë, suk ataeah, a napan to sosoe ne pan, “E Ieesuꞌ to papön.” ");
INSERT INTO tpz_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ka ma teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, to taneꞌ maꞌ Jerusalëm to sosoe ne pan, “Eꞌ to teꞌ me non e Belsebu, e susun po oraꞌ hat, ivëh to heꞌ kikis non poan, keꞌ veveo këh non o teꞌ po oraꞌ hat.” ");
INSERT INTO tpz_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ke Ieesuꞌ vaoe huk en maꞌ pa napan varih to nat ne pa taateꞌ, pareꞌ vahutët ken pee pa ma soe vapipinoꞌ. Eꞌ to soe ke raoe pan, “Eꞌ teꞌ vah va non nih ke susun po oraꞌ hat antoen e non pa veo e susun po oraꞌ hat? ");
INSERT INTO tpz_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ka ma napan to teꞌ ne paan a matop pa paeh susun, eꞌe se keh taki vakëh ko nok o pöök vuteꞌ, pare vapus koman hah, a matop pamëh hikta onöt rakah non a teꞌ vakis. ");
INSERT INTO tpz_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Keꞌ teꞌ pet me va e non manih po vutom taman varih to teꞌ ne sih koman a paeh iuun. Eꞌe se keh taki vakëh, pare vapus koman hah, o vutom taman poë varih to hikta se teꞌ kikis ne. ");
INSERT INTO tpz_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ivëh, ke susun po oraꞌ hat se keh vakihat koman hah me a non, ko kum peꞌ takök vakëkëh, kee hikta onöt ne a teꞌ vaꞌpeh tamoaan, eꞌe se hik rakah ee.” ");
INSERT INTO tpz_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe suk e susun po oraꞌ hat, pareꞌ soe pan, “A pah teꞌ to hikta onöt rakah non a ho akuk manuh pa iuun pa teꞌ söë, pareꞌ kokon a ma tah peꞌ, ahik, eꞌ se këk nohnoh vavih momoaan a teꞌ söë po uris, pareꞌ pah kokon poꞌ a ma tah kurus va pa koman iuun peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Eöꞌ se soe vaman rakah keoꞌ peöm, e Sosoenën se ihan anoe a ma hat me a ma soe viivi kurus rakah varih no a napan to nonok ne. ");
INSERT INTO tpz_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ivëhkëk, a teꞌ se keh soe viivi a Tuvuh Vasioꞌ, e Sosoenën to hikta se ihan anoe non a hat peꞌ, suk ataeah, eꞌ to nok en pa hat teꞌteꞌ tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","E Ieesuꞌ to soe va nën suk a ma teꞌ varih to nat ne pa taateꞌ, eꞌe to sosoe ne pan, “Eꞌ to teꞌ me non a oraꞌ hat.” ");
INSERT INTO tpz_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ke sinan me a ma kea pe Ieesuꞌ nö ee maꞌ. Ee to sun ne maꞌ mahën, pare vanö na a soe pan e Ieesuꞌ se nö maꞌ, eꞌe to iu ep i ne poë. ");
INSERT INTO tpz_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A napan o pöh peo rakah to ihoꞌ me ne e Ieesuꞌ ka napan poë varih soe kee peꞌ pan, “E sinömah, me a ma kea pën, me a ma vameomah, to teꞌ ne mahën, ee to iu ne maꞌ oah.” ");
INSERT INTO tpz_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “Eteh e sinaneoꞌ, me eteh e kea peöꞌ?” ");
INSERT INTO tpz_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Keꞌ kukuteꞌ en pa ma napan varih to ihoꞌ tatavi ne poë, pareꞌ soe pan, “A ma napan varih, eꞌe to teꞌ va e ne manih pe sinaneoꞌ, me a ma kea peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","A napan varih to nonok ne a ma tah ne Sosoenën to iu non sih, eꞌe a ma kea peöꞌ, me a ma vameneoꞌ, me e sinan vamaman neoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","E Ieesuꞌ to taneo hah en pa vavaasis a ma napan manih sinten a tonon va Galiliꞌ. Ka napan o pöh peo to tönun pa havin e Ieesuꞌ. Ivëh, keꞌ peah en po paröꞌ, pareꞌ ihoꞌ non, ko paröꞌ atan non pa tonon, ka napan teꞌ ne manih sinten tonon. ");
INSERT INTO tpz_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Keꞌ vavaasis e non pee pa ma tah peo manih koman a ma soe vapipinoꞌ, pareꞌ soe ke raoe pan, ");
INSERT INTO tpz_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Pënton öm, a pah teꞌ poꞌpoꞌ kon to nö pa rak peꞌ, pareꞌ poꞌpoꞌ a kon peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","A teꞌ pamëh to poꞌpoꞌ nö non a kon, ka ma meh voaꞌ kon vuꞌ ee manih po vaꞌpet taan, ko növan nö maꞌ, ko ëën vahik ee pee. ");
INSERT INTO tpz_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ka ma meh voaꞌ vuꞌ ee manih pa moeh vösvös. Ka ma voaꞌ kon pisiꞌ vëvëhöꞌ ee maꞌ, peꞌ o oeh to hikta teꞌ ru non, ivëh, nee to pisiꞌ ohoꞌ suk maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ivëh, ka potan peah maꞌ, pareꞌ pa varak hah en pee, suk ee to hikta teꞌ aan vakis ne. ");
INSERT INTO tpz_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ka ma meh voaꞌ kon vuꞌ manih po topnin o noꞌ uris toꞌtoꞌ, ka uris toꞌtoꞌ pu maꞌ, ko kopös en pee, kee hikta voaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ka ma meh voaꞌ kon vuꞌ ee manih po oeh vih, pare pu vavih ee maꞌ, ko voaꞌ vavih ee, ka ma meh vu kon voaꞌ ee po 30 voaꞌ, ka ma meh vu kon voaꞌ ee po 60 voaꞌ, ka ma meh vun voaꞌ ee po 100 voaꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ke Ieesuꞌ soe ke rapoë pan, “Eöm o teꞌ varih to teꞌ me nem a ma tenëneöm, eöm se pënton a soe vaꞌih.” ");
INSERT INTO tpz_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","E Ieesuꞌ to teꞌ non pehen, ko teꞌ varih to tënan voh ne sih a ma soe peꞌ to nö vaꞌpeh me ee maꞌ pa havun me a poa vamomhë peꞌ. Pare soe ke poë pan eꞌ se vamaaka rapoë pa pusun in a soe vapipinoꞌ pamëh. ");
INSERT INTO tpz_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ke Ieesuꞌ piun raoe, pareꞌ soe ke rapoë pan, “E Sosoenën to vataare voh en peöm pa pusun in a soe vakoaan va pa Matop Vih Peꞌ. Ivëhkëk, a napan varih to teꞌ tavus ne to pënton koe varoe ko ne sih a soe manih pa soe vapipinoꞌ. Eꞌ to vapuh e non, pa ö no a teꞌ vanënën soe vëh e Aisaëaꞌ to soe suk voh pan, ");
INSERT INTO tpz_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Ee se epep ne ko sih epep vatëh va kov e ne manih, ivëhkëk, ee hikta se nat i ne ta pah tah, ee se tëtënan ne ko sih tëtënan vatëh va kov e ne manih, ivëhkëk, ee hikta se maaka i ne a pusun in a soe pamëh. Ee se keh maaka i ne a pusun in a soe pamëh, ee se tarih ke na manuh pe Sosoenën, ke Sosoenën se ihan anoe en pa ma hat pee.’” ");
INSERT INTO tpz_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ke Ieesuꞌ hi raoe pan, “Eöm hikta nat rakah ko nem pa pusun in a soe vapipinoꞌ vëh, ha? Eöm se poꞌ nat vah va in a pusun a ma meh soe vapipinoꞌ varih nih? Eöm to hikta nat nem, eöꞌ se soe tavus keoꞌ peöm pa pusun in a soe vapipinoꞌ pamëh. ");
INSERT INTO tpz_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","A teꞌ vëh to poꞌpoꞌ o voaꞌ kon, eꞌ to teꞌ va non manih pa ö neꞌ to poꞌpoꞌ a soe pe Sosoenën manih pa komëëra napan. ");
INSERT INTO tpz_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","A soe to vuꞌ manih po vaꞌpet taan, eꞌ to teꞌ va non manih pa napan to tënan a soe, ko vasuksuk no e susun po oraꞌ hat to vëvëhöꞌ maꞌ, ko kon ke en pa soe vëh ne Sosoenën to poꞌpoꞌ manih pa komëëre. ");
INSERT INTO tpz_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ka ma upöm teꞌ to teꞌ va e ne manih pa ma voaꞌ kon to vuꞌ manih po oeh vösvös. Eꞌe to pënton ee pa soe, pare kon vëvëhöꞌ ee, pare vaeö e ne peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ivëhkëk, o vaman pee to hikta teꞌ aan vakis non manih pa komëëre. Ko poen no a napan to kehkeh vöknah ne a soe pe Sosoenën, ee to heꞌ ee pee pa punis, ko hinën ee pee, ko vaman pee kuꞌ vëhöꞌ en. ");
INSERT INTO tpz_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ka ma upöm teꞌ to teꞌ va e ne manih po voaꞌ kon to vuꞌ topnin o noꞌ uris toꞌtoꞌ. A pap teꞌ poë varih to pënton e ne sih pa soe pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ivëhkëk, ee to koman vaviꞌ e ne pa ma moeh tah va po oeh vëh, pare koman vaviꞌ me e ne pa ununun vörep a moniꞌ, ko teꞌ e ne pa manin pet na a ma meh tah. Ka ma tah poë varih kupkup e ne pa soe pe Sosoenën manih pa ma kokoman pee. Ka soe pamëh hikta vovoaꞌ non. ");
INSERT INTO tpz_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ivëhkëk, a ma meh voaꞌ kon to vuꞌ manih po oeh vih, to teꞌ va e ne manih po teꞌ to pënton a soe pe Sosoenën, pare kon ko ötöön e ne. Ka soe pamëh to voaꞌ pet manih po toꞌtoꞌ pee. Ka ma paeh to voaꞌ ee po 30 voaꞌ, ka ma meh to voaꞌ ee po 60 voaꞌ, ka ma meh to voaꞌ ee po 100 voaꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ke Ieesuꞌ soe ken pa napan me ra ma vamomhë peꞌ pa meh soe vapipinoꞌ, pareꞌ soe pan, “A napan onöt kës e ne pa teꞌ o ram, pare vahoꞌ hop manih paan o kove, keꞌ manih pa paan a tevan? Ahik, ee se vahan rakah manuh mahën pa ö vavahan ram. ");
INSERT INTO tpz_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","A ma tah kurus varih ne ea to kokoaan no, amot ne Sosoenën se vatvus en pee manih pa mahën. Ka ma tah kurus varih to kup ne, amot ne Sosoenën se pureꞌ en, pareꞌ vatvus vateeraꞌ en pee. ");
INSERT INTO tpz_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Pënton öm, a teꞌ to teꞌ me non a tenaneah, eꞌ se pënton a soe peöꞌ, ko inan, pareꞌ kokoman vatotoopin.” ");
INSERT INTO tpz_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ke Ieesuꞌ soe ken pee pan, “A ma soe varih nöm to pënton nem, ne eöm se kokoman vavih rakah nem. A ma tah varih nöm to heꞌheꞌ akuk nem sih o upöm teꞌ, eꞌ a ma tah poë varih ne Sosoenën se piun oah hah ken peöm. Pareꞌ vatok pet e na pa ma meh tah manih peöm. ");
INSERT INTO tpz_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","A teꞌ se keh kon voh o nat, pareꞌ maaka i non a soe pe Sosoenën, e Sosoenën se heꞌ vaꞌpuh oah en peꞌ po nat, keꞌ maaka vavih en. Ka teꞌ se keh koaan o nat vëh ne Sosoenën to heꞌ voh poan, e Sosoenën se öt hah këh en peꞌ po nat pamëh.” ");
INSERT INTO tpz_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ke Ieesuꞌ vavaato avoeꞌ e non, pareꞌ soe pan, “A Matop Vih pe Sosoenën to teꞌ va e non manih pa pah teꞌ to varapök a ma voaꞌ tah ënëën manih po oeh. ");
INSERT INTO tpz_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ka teꞌ pamëh koroh en pa popoen, ka pöstakah neꞌ to sun, pareꞌ nönö vah non, a ma voaꞌ tah ënëën poë varih he pisiꞌ ee maꞌ. Ivëhkëk, eꞌ to hikta nat non ee pisiꞌ vah va maꞌ nih. ");
INSERT INTO tpz_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","O oeh koman to kikiu non, ko vapisiꞌ en pa ma voaꞌ tah ënëën, kee pu maꞌ, pare voaꞌ ee. Vamomoaan no uvineah to tavus, ko vasuksuk no korom to tavus maꞌ, ko vahik ka ö ënëën tavus poꞌ maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ko poen no a voaꞌ to manot ee, ke voe pamëh taneo en pa moes a voaꞌ po rapis, suk ataeah, o poen va pa ëën a voaꞌ to öök en.” ");
INSERT INTO tpz_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ke Ieesuꞌ hi haha kov en pee pan, “Ea se vëknöm vah va in a Matop Vih pe Sosoenën nih? A soe vapipinoꞌ taeah to vih non pea se soe pet na marën a vamaaka ro teꞌ? ");
INSERT INTO tpz_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Eꞌ to teꞌ va non manih po voaꞌ naon nee to popokaꞌ ne o mastat, eꞌ o voaꞌ tah to parin a soneꞌ varo rakah, ka teꞌ kon, pareꞌ nep poan manih po oeh. ");
INSERT INTO tpz_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ivëhkëk, a vu mastat to pupu tamoaan e non maꞌ, pareꞌ tavus en a vu tah apuh oah manih pa koman a rak, pareꞌ teꞌ me non a ma pean apaꞌpuh, ko növan va kin nö maꞌ, pare ihihoꞌ ne pa ma peananeah.” ");
INSERT INTO tpz_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","O poen ne Ieesuꞌ to heꞌheꞌ voh non sih a ma soe peꞌ manih pa napan, eꞌ to heꞌheꞌ koe rakah non sih a ma soe peꞌ manih pa ma soe vapipinoꞌ. Ka ma soe vapipinoꞌ poë varih se teꞌ maaka onöt ne a ö no a napan se maaka ne a soe peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Eꞌ hikta soe vamaaka ke ra napan ta pah soe. Ahik. Eꞌ to vavatvus vaviꞌ non a ma soe peꞌ pa ma soe vapipinoꞌ. Ko poen no a ma vamomhë peꞌ se keh teꞌ vaꞌpeh varoe me ne poë, eꞌ to vamaaka ken pee pa pusun in a ma soe vapipinoꞌ poë varih. ");
INSERT INTO tpz_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Manih pa potan avoeꞌ pamëh pa matanpoen, ne Ieesuꞌ to soe ke ra ma vamomhë peꞌ pan, “Ka pahan ee manuh pa pap tonon vöh Galiliꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kee këh ee maꞌ pa nap peo, pare peah ee po paröꞌ vëh ne Ieesuꞌ to tok vovoh vu non. Ko vamomhë peah töön ee pe Ieesuꞌ, kee nö vaꞌpeh ee. Ee to këh ee pa ma meh paröꞌ nee to pët teꞌ vu ne. ");
INSERT INTO tpz_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ka ivat ip maꞌ, ka supa susurap hop e non maꞌ po komön o paröꞌ, ka siꞌ ö hat ka tahiꞌ puh en po paröꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","E Ieesuꞌ to teꞌ non manih po kusin o paröꞌ, pareꞌ koroh non ko vahipös non pa ta vahipös, ka ma vamomhë peꞌ kunkuin poë, pare soe pan, “Apuh, eën hikta koman a rora noman ah? A siꞌ ö hat poꞌ toh, ko paröꞌ rokoꞌ me en pea.” ");
INSERT INTO tpz_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ke Ieesuꞌ sun, pareꞌ taꞌ a tuvuh me a supa pan, “Moovi öm!” Kee moovi ee. ");
INSERT INTO tpz_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ke Ieesuꞌ soe ke ra ma vamomhë peꞌ pan, “Suk ataeah, köm nanaöp nem, eöm to hikta teꞌ avoeꞌ me nem to vaman manih peöꞌ, ha?” ");
INSERT INTO tpz_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kee pah töhkak vahat ee, pare vaiihi koman e ne pan, “A teꞌ rakah vëh eꞌ eteh? Ka tuvuh me a supa tënan rakah ee pa soe peꞌ?” ");
INSERT INTO tpz_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","E Ieesuꞌ me ra ma vamomhë peꞌ to pahan hah ee pa tonon va Galiliꞌ, pare takin ee pa muhin va Gerasaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Eꞌ to këkëh takin ko non maꞌ o paröꞌ, ka teꞌ to teꞌ me non a oraꞌ hat taneꞌ maꞌ po vapeepe nö en maꞌ pa ep peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","A teꞌ pamëh no a oraꞌ hat to teꞌ non manih peꞌ, keꞌ kokoroh non maꞌ sih po vapeepe, ahik ta pah teꞌ to onöt non a nohnoh poan po to uris eh. ");
INSERT INTO tpz_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","A ma poen peo no a napan to nohnoh a poa moneah me a poa koreneah pa sen. Ivëhkëk, a ma tamoaan neꞌ to kukurus këh a non pa sen pamëh. Eꞌ to parin a eh, ka hikta teꞌ to onöt non a ötöön poan. ");
INSERT INTO tpz_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pa ma potan me a ma popoen neꞌ to nönö vah non maꞌ sih manuh po vapeepe, me manuh pa topnin in a ma totope. Eꞌ to kokoeꞌ suntan tamoaan vah e non, pareꞌ viivi ruruvis koman hah a non sih po vös. ");
INSERT INTO tpz_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Eꞌ to teꞌ varo e non maꞌ, pareꞌ ep i na e Ieesuꞌ. Ivëh, keꞌ vaveo maꞌ, ko vuꞌ, pareꞌ vatokon en manih pa matan e Ieesuꞌ marën a kë a ëhnaneah. ");
INSERT INTO tpz_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ivëhkëk, a oraꞌ hat pamëh to kokoeꞌ tavus ke maꞌ pa rivon a teꞌ pamëh, pareꞌ soe maꞌ pan, “Ieesuꞌ, eën e Koaꞌ pe Sosoenën A Kikis Vi, eën se nok ataeah manih peöꞌ? Koe ka neoꞌ ah! Manih pa ëhnan e Sosoenën, eöꞌ to hi nös oah pan, eën se nat nom vakmis a neoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","A oraꞌ hat to soe va nën, suk e Ieesuꞌ to soe pan, “Oraꞌ hat, tavus këh mah a teꞌ maneom.” ");
INSERT INTO tpz_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ke Ieesuꞌ hi poan pan, “A ëhnöömah eteh?” Ka oraꞌ hat pamëh piun maꞌ, pareꞌ soe pan, “A ëhnaneoꞌ, ‘a Nap Peo’, suk emöm to peo to teꞌ hop nem pa teꞌ vëh.” ");
INSERT INTO tpz_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ka oraꞌ hat pamëh hin vakis en pe Ieesuꞌ pan eꞌ se nat non veo tavus raoe këh a muhin pamëh. ");
INSERT INTO tpz_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Manih pa poen pamëh no vasun kuꞌ peo to ënëën vatët ne pa sinten a siꞌ ö tope. ");
INSERT INTO tpz_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ko oraꞌ hat peo poë varih pah hin vakis ee pe Ieesuꞌ pan, “Vanö a möm ah manuh po kuꞌ varuh, kemöm hop manuh pee.” ");
INSERT INTO tpz_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ke Ieesuꞌ vaonöt rapoë, kee nö ee. Ee to tavus këh ee maꞌ pa teꞌ pamëh, pare hop ee po kuꞌ. O vasun kuꞌ to peo onöt ne o 2,000. Kee vavaveo kunah ee pa ö vaere, ko susurap ee na pa tonon, pare vuk, ko mët vahik ee. ");
INSERT INTO tpz_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ka napan varih to matop ne sih po vasun kuꞌ pamëh varurusin ee, pare vahutët vavah ee pa ma tah to tanok manih pa vöön apuh me ra ma vöön sosoneꞌ. Ka napan vanönö ee maꞌ pa ep pa ma taneah to tanok. ");
INSERT INTO tpz_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","A napan to nö maꞌ manih pe Ieesuꞌ, pare taum ee pa teꞌ pamëh no oraꞌ hat to teꞌ voh ne manih peꞌ to ihoꞌ non, eꞌ to rara hah en po rara, ko kokoman peꞌ maaka hah en, ka napan varih pah vananaöp ee. ");
INSERT INTO tpz_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ka napan varih to ep voh ne pa ma tah poë varih vahutët kee pee pataeah, to tavus voh manih pa teꞌ pamëh, me ro oraꞌ hat, me ro kuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ivëh, kee taneo ee pa hin vakis e Ieesuꞌ pan eꞌ se këh tavus a muhin pee. ");
INSERT INTO tpz_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","E Ieesuꞌ to pepeah hah nö non manuh po paröꞌ ka teꞌ vëh no a oraꞌ hat to teꞌ voh non manih peꞌ he nö maꞌ, pareꞌ hin vakis poan pan, “Eöꞌ to iu teꞌ vaꞌpeh me a noꞌ oah.” ");
INSERT INTO tpz_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ke Ieesuꞌ hikta vaonöt ke poan, ivëhkëk, eꞌ to soe ke poan pan, “Nö hah na manuh vöön pa ma teꞌ pën. Parën vatvus manih pee a ö ne Sunön to nök va vu ka oah, me o ururuan vëh neꞌ to nok vu manih pën.” ");
INSERT INTO tpz_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ivëh, keꞌ nö en pareꞌ hutët poꞌ en pa ma vahutët va pa ma tah ne Ieesuꞌ to nok manih po toꞌtoꞌ peꞌ, manih pa ma vöön to teꞌ ne pa muhin va Tekapolis, ka napan töhkak, ko puh rakah ee po kokoman. ");
INSERT INTO tpz_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","E Ieesuꞌ to tok pahan hahah kov en po paröꞌ me ra ma vamomhë peꞌ pa pap tonon vöh. Manuh pa pap tonon vöh, ee to takin, ka napan tönun vatët hahah kov ee maꞌ manih peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ivëh, ka pah teꞌ sunön to matop non sih a iuun hinhin soneꞌ po Jiuꞌ nö en maꞌ manih peꞌ. A ëhnaneah e Jaërus, eꞌ to ep in na e Ieesuꞌ, pareꞌ nö maꞌ ko vatokon manih pa havin a moneah. ");
INSERT INTO tpz_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ke Jaërus pah hin vakis rakah en pe Ieesuꞌ, pareꞌ soe pan, “Sunön, a siꞌ ö hat ke koaꞌ mon peöꞌ mët en, nö mah, parën hariun eah pa koreomah, keꞌ sih toꞌ hah, ko teꞌ toꞌtoꞌ non.” ");
INSERT INTO tpz_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ke Ieesuꞌ nö vaꞌpeh me en pe Jaërus me ra ma vamomhë peꞌ, ka nap peo rakah to suk raoe, pare vasusunpip nö e ne pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ivëh, ka pah köövo to teꞌ hop non pa napan poë varih, to vavahuh tamoaan non sih o eraꞌ. Eꞌ to teꞌ me voh non a mët pamëh po havun me ro pöök kirismas. ");
INSERT INTO tpz_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","O röktaꞌ o pöh peo to vavakmis voh ne sih poë. E köövo pamëh to vahik akuk rakah en pa ma moniꞌ peꞌ manih pee. Ivëhkëk, a mët peꞌ to apaꞌpuh vapiun nö e non, pareꞌ hikta hikhik non. ");
INSERT INTO tpz_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Eꞌ to pënton voh en pa ma vahutët va pe Ieesuꞌ. Pareꞌ soe aven koman en manih po kokoman peꞌ pan, “Eöꞌ se keh hariun ro o ohop peꞌ, eöꞌ se toꞌ hah eoꞌ, ka mët peöꞌ hik en.” Ivëh, keꞌ huk vatët maꞌ pa tonuneah, ko hariun en po ohop peꞌ, ");
INSERT INTO tpz_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ka varuꞌ rakah vakomanih no a mët peꞌ to hik en, keꞌ hikta vavahuh hah non o eraꞌ. Ka manih pa sionineah neꞌ to haraꞌ en pa ma kamis to hik këh ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ke Ieesuꞌ haraꞌ en pa ma kikis peꞌ to tavus këh ee peꞌ, ivëh, keꞌ tarih pareꞌ hi ra napan pan, “Eteh to hariun kuru o ohop peöꞌ?” ");
INSERT INTO tpz_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ka ma vamomhë peꞌ piun poë, pare soe ke poë pan, “Eën ep kov e nom pa napan to parin a peo, pare tönun töön rakah e ne pën, suk ataeah, kën hi pan, ‘Eteh to hariun a neoꞌ?’” ");
INSERT INTO tpz_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ivëhkëk, e Ieesuꞌ to vavaiu avoeꞌ e non peteh ivëh, to hariun vu o ohop peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ivëh, ke köövo pamëh nat e non pa tah to tanok vu manih peꞌ, pareꞌ nanaöp non ko rikrik e non, ivëh, keꞌ nö maꞌ ko vuꞌ ko vatokon pa matan e Ieesuꞌ, pareꞌ vavatët vahik en pa ma moeh kokoman me a ö ne Ieesuꞌ to vatoꞌ hah va in poan. ");
INSERT INTO tpz_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ke Ieesuꞌ soe ke poꞌ poan pan, “Koaꞌ peöꞌ, eën to vaman a neoꞌ, ka mët pën hik këh en pën. Eën se nö na me a taateꞌ moomo, peꞌ a mët pën to hik en.” ");
INSERT INTO tpz_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","E Ieesuꞌ to vaato avoeꞌ e non, ka ma teꞌ va pa iuun pe Jaërus nö ee maꞌ, pare soe ke poë pan, “E semomah to mët en. Koe a vatëh vörep e Apuh.” ");
INSERT INTO tpz_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ivëhkëk, e Ieesuꞌ to hikta iu pënton non a soe nee to sosoe ne. Ivëh, keꞌ soe ke Jaërus pan, “Eën se koe a naöp, parën vaman varoe a no neoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","E Ieesuꞌ to soepip en pa napan kurus, pareꞌ taꞌ varoe e Pitaꞌ, pen e Jëmis, me e Jon, ke Jaërus, ee ra taanaꞌ to nö vaꞌpeh me e Ieesuꞌ manuh pa iuun pe Jaërus, me ahikta meh teꞌ to nö vaꞌpeh me raoe. ");
INSERT INTO tpz_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ee to tavus ee manuh pa iuun pe Jaërus, ke Ieesuꞌ tënan a napan to vaokook suntan rakah e ne, ");
INSERT INTO tpz_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","suk e semon Jaërus to mët en. Ke Ieesuꞌ ho en koman a iuun pe Jaërus, pareꞌ hi a napan varih to vaokook ne pan, “Eöm okook heheve suk nem ataeah? E koaꞌ vëh to hikta mët, eꞌ to koroh varoe.” E Ieesuꞌ to soe vamanih, suk a ö neꞌ se vatoꞌ hah en nös pe koaꞌ pamëh. ");
INSERT INTO tpz_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ivëhkëk, a napan to vavövöneꞌ suntan rakah ee pe Ieesuꞌ, ke Ieesuꞌ veo tavus en pee, pareꞌ taꞌ e taman e koaꞌ pen e sinaneah me ra kukön vamomhë peꞌ, kee ho ee manuh pa ö vavahoꞌ teꞌ mët ne koaꞌ to pet non. ");
INSERT INTO tpz_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ke Ieesuꞌ öt a koreneah, pareꞌ soe pan, “Talita koum.” A pusun a soe vaꞌih to soe non pan, “Koaꞌ mon soneꞌ, eöꞌ to soe ka oah, sun ah.” ");
INSERT INTO tpz_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Varuꞌ rakah vakomanih neꞌ to sun en, ko taneo en pa nö vavah, e koaꞌ pamëh to onöt non o havun me ro pöök kirismas. Ka ma teꞌ varih to teꞌ ne koman iuun to ep in a tah vaꞌih, pare pah vatötöhkak suntan ee. ");
INSERT INTO tpz_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ke Ieesuꞌ vuhvuh vakis rakah en po teꞌ varih koman iuun pan, “Eöm se nat nem vavatët a tah vaꞌih manih pa ta meh teꞌ.” Pareꞌ soe ke ra poa manot pan, “Heꞌ öm eah ta taëën, keꞌ ëën.” ");
INSERT INTO tpz_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","E Ieesuꞌ to këh hah en pa vöön vëh Kapaneam, pareꞌ hah en manuh pa vöön peꞌ Nasaret, ka ma vamomhë peꞌ to nö vaꞌpeh me ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Eꞌ to taneo en pa vavaasis a napan a soe pe Sosoenën po Poen Apaapo manih pa iuun hinhin soneꞌ po Jiuꞌ. A nap peo rakah to pënton ne poë to vavaasis non, pare pah töhkak vahat ee. Pare soe vamanih pan, “A teꞌ vëh kon taneꞌ maꞌ a ma soe varih nih? Me o nat vëh neꞌ to kon taneꞌ maꞌ nih? Eꞌ nonok vah va in non a ma tah vatoksean nih? ");
INSERT INTO tpz_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","A teꞌ vëh, eꞌ a teꞌ ekeok, eꞌ e koaꞌ pe Mariaꞌ, pareꞌ teꞌ non e kea pe Jëmis, ke Jeosëp, ke Jiutas, ke Saëmon. A ma vameneah to teꞌ vaꞌpeh me e ne pea manih.” Keꞌ ivëh, a tah no a napan va pa vöön peꞌ to heꞌ tonun suk poë. ");
INSERT INTO tpz_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ke Ieesuꞌ piun raoe, pareꞌ soe ke rapoë pan, “Manih pa ma ö kurus me pa vöön apuh no a napan to ta e ne po teꞌ vanënën soe, ivëhkëk, manih pa vöön koman peꞌ me manih pa ma poaneah, me manih pa tapaiuun peꞌ, ee to hikta ta ne poë, ee to heꞌ tonun e ne peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ivëh, keꞌ hikta onöt non a nok ta pah tah vatoksean apuh manih pa vöön pamëh, ee to hikta vaman ne poë. Ivëhkëk, eꞌ to vatok varoe a koreneah pa ma pah teꞌ varih to haraꞌ ne a ma mët, ka ma mët pee hik këh en pee, kee toꞌtoꞌ hah ee. ");
INSERT INTO tpz_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Eꞌ to töhkak, suk a ma napan to hikta vaman ne poë. Ivëh, keꞌ vavih vah en pa ma meh vöön pa vavaasis a napan pa soe pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","E Ieesuꞌ vaoe ununun en pa havun me ra poa vamomhë peꞌ, pareꞌ vanö pöpöök raoe pa ma vöön, pareꞌ heꞌ en pee pa tasun peꞌ, marën a veo këh a napan po oraꞌ hat. ");
INSERT INTO tpz_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Pareꞌ soe ke rapoë pan, “Eöm se nat nem teꞌ vaꞌpeh ta ma meh tah manih pa nö peöm, eöm se nat nem teꞌ ta taëën, me to kove, paröm nat nem teꞌ to meoh ohop. Ivëhkëk, eöm se teꞌ varoe o toknon me a suꞌ peöm. Suk a napan se matop e ne peöm pa taëën me a ma meh ohop.” ");
INSERT INTO tpz_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Eꞌ to soe vamatop avoeꞌ ken pee pan, “Eöm se keh ho pa ta pah iuun, eöm se teꞌ nem nën pa iuun pamëh, keꞌ antoen po poen nöm se këh a vöön pamëh. ");
INSERT INTO tpz_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ka manih pa ma meh vöön no a napan se keh hikta vaoe a neöm pa ma iuun pee, pare hikta pënton a ma soe peöm. A, këh maꞌ a iuun me a vöön pamëh, paröm susunuh o kusan vëh to teꞌ non pa ma moeeneöm, paröm nö em pa meh vöön, ko nat nem vos amot koe hah maꞌ nën. Eꞌ a soe vanat va pa ö no a napan va pa vöön pamëh to hikta iu pënton ne a soe peöm. Ivëh, ke Sosoenën se vakmis raoe.” ");
INSERT INTO tpz_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ivëh, ko vamomhë peꞌ nö ee pa vavaasis a napan pan, ee se panih a ma kokoman me a ma taateꞌ hat pee. ");
INSERT INTO tpz_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pare veo tavus o oraꞌ hat këh a napan, pare hë o vanom manih pa napan varih to haraꞌ ne a ma mët. Kee vih hah ee. ");
INSERT INTO tpz_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","A teꞌ sunön vëh e Hëërot to pënton en pa ma tah varih, suk ataeah, a ëhnan e Ieesuꞌ to nö vavah en pa ma ö kurus. A ma paeh teꞌ to soe vamanih pan, “E Jon Tövapupui to sun taneꞌ hah maꞌ po vapeepe. Ivëh, neꞌ to teꞌ suk me non o kikis va pa nok a tah vatoksean.” ");
INSERT INTO tpz_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ka ma upöm teꞌ soe ee pan, “Eꞌ a teꞌ vanënën soe vëh e Elaëjaꞌ.” Ko upöm sosoe e ne pan, “Eꞌ a teꞌ vanënën soe to teꞌ va non manih pa ma teꞌ vanënën soe vamoaan voh.” ");
INSERT INTO tpz_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","E Hëërot to pënton a tah vaꞌih, pareꞌ soe pan, “E Jon Tövapupui nöꞌ to moes kurus voh eoꞌ pa koꞌkoneah. Ivëhkëk, kuru neꞌ to toꞌ hah en maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","E Hëërot koman voh to vanö a ma teꞌ peꞌ, kee öt e Jon, pare nohnoh poë po uris eh, ko vahoꞌ poë pa iuun nohnoh. E Hëërot to nok vamanih, suk eꞌ to me e töveneah, Hëëroteas, e köövo pe kea soneꞌ peꞌ, Filip. ");
INSERT INTO tpz_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ivëh, ke Jon Tövapupui soe ke voh e Hëërot pan, “Manih pa taateꞌ pa kën sipuura, eën se nat nom me e köövo pe kea pën pa tëëm neꞌ to teꞌ toꞌtoꞌ avoeꞌ e non.” ");
INSERT INTO tpz_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","E Hëëroteas to poet voh, ko heve non e Jon Tövapupui, pareꞌ iu ip vamët e non peꞌ. Ivëhkëk, eꞌ to hikta antoen non. Suk ataeah, e Hëërot to nanaöp e non pa ip vamët e Jon, suk eꞌ to nat e non pe Jon a teꞌ vih, no a taateꞌ peꞌ to totoopin rakah manih pa matan e Sosoenën, pareꞌ vivihan. Ivëh, keꞌ ut vavih e non peꞌ. Ko poen neꞌ to pënton a soe pe Jon, eꞌ to pah kokoman vörep e non, pareꞌ pah haraꞌ vapunis rakah e non. Ivëhkëk, eꞌ to pah iu rakah e non pa pënton a soe peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Po vasuksuk ne Hëëroteas to taum en pa hanan va pa ip vamët koe e Jon Tövapupui manih pa ö ne Hëërot to kehkeh nok non a taëën apuh, suk o poen ne sinaneah to vahuh voh poan. A ma vu susunön va pa muhin va Galiliꞌ, me ro teꞌ varih to vovoh ne manih pa nap vëvënsun, me o teꞌ varih to kiu ne pa kaman, ee ra ma teꞌ poë varih ne Hëërot to vaoe raoe marën a vaeö me poë pa taëën peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ke semon Hëëroteas nö maꞌ, pareꞌ pinoꞌ vamanin en pe Hëërot, me ra ma napan varih to ënëën vaꞌpeh me ne poë. Ivëh, ke Hëërot soe ke koaꞌ sepeꞌ pamëh pan, “Ataeah nën to iu nom. Eöꞌ se heꞌ eoꞌ pën.” ");
INSERT INTO tpz_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ke Hëërot soe en pa soe vaman kikis peꞌ manih pe koaꞌ sepeꞌ pamëh pan, “Man rakah non pe Sosoenën, eöꞌ se heꞌ eoꞌ pën pataeah nën to iu nom. Eën se keh iu nom a ö nöꞌ se kök vakëh a muhin nöꞌ to matop noꞌ, paröꞌ heꞌ a oah ta ö, a, eöꞌ se nok va eoꞌ nën.” ");
INSERT INTO tpz_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ke koaꞌ sepeꞌ pamëh tavus, pareꞌ hi en pe sinaneah pan, “Eöꞌ se hin ataeah manih pe Hëërot?” Ivëh, ke sinaneah Hëëroteas taum poꞌ en pa hanan va pa ö ne se ip vamët koe in e Jon Tövapupui, pareꞌ soe ke semoneah pan, “A, eën se nö hah manuh pe Hëërot, parën soe va in eah manih pan, ‘Eöꞌ to iu noꞌ o kahoꞌ pe Jon Tövapupui neꞌ se heꞌ maꞌ oah.’” ");
INSERT INTO tpz_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ke koaꞌ sepeꞌ pamëh vëvëhöꞌ hah rakah en manuh pe Hëërot, pareꞌ hin vakis rakah en pan, “Eöꞌ to iu noꞌ a ö nën se heꞌ ohoꞌ a neoꞌ o kahoꞌ pe Jon Tövapupui se pet non pa peret.” ");
INSERT INTO tpz_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ke Hëërot pënton a soe vaꞌih ko pah toksean rakah en, pareꞌ teꞌ me e non po tamak. Ivëhkëk, a hikta tah neꞌ se nok, suk ataeah, eꞌ to soe vu ken pe semon Hëëroteas pa soe kikis, o upöm teꞌ susunön neꞌ to vaoe na he pënton i ne pa soe pamëh. Ivëh, neꞌ hikta onöt suk non a kök hah a soe kikis neꞌ to soe ke vu e koaꞌ sepeꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ka teꞌ sunön pamëh veo ohoꞌ en pa teꞌ vëvënsun peꞌ, keꞌ nö en pa iuun nohnoh, pareꞌ moes kurus en maꞌ po kahoꞌ pe Jon. ");
INSERT INTO tpz_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Eꞌ to teꞌ maꞌ o kahoꞌ pe Jon to pet non pa peret, pareꞌ heꞌ en pe koaꞌ sepeꞌ pamëh, ke koaꞌ sepeꞌ pamëh teꞌ, ko heꞌ en pe sinaneah. ");
INSERT INTO tpz_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ka ma vamomhë pe Jon Tövapupui pënton a ö ne Jon to mët en, pare nö maꞌ, ko teꞌ ee pa sionin e Jon, ko pe ee peꞌ po vapeepe. ");
INSERT INTO tpz_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","A ma aposol pe Ieesuꞌ to hah ee maꞌ, pare tönun vaꞌpeh hah me ee pe Ieesuꞌ, pare vahutët ke poë a ma kiu me a ma soe nee to vavaasis ne maꞌ a ma napan. ");
INSERT INTO tpz_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","A nap peo rakah to nönö kov e ne maꞌ, ko upöm vaahah e ne, ke Ieesuꞌ me a ma vamomhë peꞌ hikta antoen ne a ëën. Ivëh, ke Ieesuꞌ soe ke rapoë pan, “Ep öm, ka nö ee pa ta ö ne ea se teꞌ varoe no, köm sih vanot, ko ëën ta taëën.” ");
INSERT INTO tpz_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Keꞌe varoe kuru to peah ee po paröꞌ, pare nö ee pa ö no a hikta teꞌ to teꞌ non. ");
INSERT INTO tpz_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ka ma napan ep i raoe to nönö ne, pare ep inan ohoꞌ ee pee. Ivëh, kee taneꞌ ee maꞌ pa ma vöön, ko vavaveo vovoh, pare tavus momoaan kee pe Ieesuꞌ, me a ma vamomhë peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","E Ieesuꞌ to tatakin këh ko non o paröꞌ, pareꞌ ep a napan peo rakah, ko pah uruan en pee, suk eꞌe to teꞌ va i ne manih po sipsip varih no ahikta teꞌ to matop non rapoë. Ivëh, keꞌ taneo en pa vavaasis raoe pa ma soe pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","A siꞌ ö hat ka muhin poen en, ka ma vamomhë peꞌ nö ee manuh peꞌ, pare soe ke poë pan, “A moeh hikta teꞌ ivëh. ");
INSERT INTO tpz_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ivëh, ka se ep, ko vanö hah a ma napan varih, kee nö, pare voen ta ma taëën pa ma vöön to teꞌ vatët ne manih, ko ëën.” ");
INSERT INTO tpz_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “Eöm koman se makën raoe.” Kee hi poë pan, “Eën to iu pöꞌ nom a ö nemöm se nö, ko voen maꞌ ta ma taëën pa ta moniꞌ to onöt va non manih po 200 voaꞌ moniꞌ, ha?” ");
INSERT INTO tpz_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ke Ieesuꞌ hi rapoë pan, “O tovih muꞌ ne eöm to öt nem? Nö öm ko hi voh na a napan.” Kee nö ko nat maꞌ, pare hah maꞌ ko soe ke poë pan, “O tönim muꞌ me a poa iian.” ");
INSERT INTO tpz_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ke Ieesuꞌ soe ke ra ma vamomhë peꞌ pan, “Eöm se soe ke ra napan, kee ihoꞌ pa ma kum manih pa karas.” ");
INSERT INTO tpz_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ka napan ihoꞌ nö ee pa ma kum to antoen ne a ma 50 teꞌ, ka ma meh pa ma 100 teꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ke Ieesuꞌ kon o tönim muꞌ me a poa iian, pareꞌ ta peah na kin, ko soe vavihvih ken na pe Sosoenën. Eꞌ to kökök a ma muꞌ, pareꞌ heꞌ a ma vamomhë peꞌ, pan ee se ki vakëkëh ke ra napan. Ka poa iian me neꞌ to kök, pareꞌ nok pet va en nën. ");
INSERT INTO tpz_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ka napan kurus ëën, ko mahun vahik rakah ee. ");
INSERT INTO tpz_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ko vamomhë pe Ieesuꞌ ununun o havun me o pöök kove pa ma ö muꞌ me a ma ö iian varih no a napan to ëën këh. ");
INSERT INTO tpz_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A napan varih to ëën a taëën pamëh to onöt voh ne o 5,000 teꞌ oeteꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ke Ieesuꞌ vëvëhöꞌ vapeah en pa ma vamomhë peꞌ manih po paröꞌ, kee vovoh pahan këh ee peꞌ manuh pa pap tonon va Bëtsaëtaꞌ. E Ieesuꞌ koman se vanö hah a ma napan manuh pa ma vöön pee. ");
INSERT INTO tpz_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","E Ieesuꞌ to vanö vahik en pa ma napan, pareꞌ peah en manuh pa tope pa hin nën. ");
INSERT INTO tpz_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pa matanpoen rakah no o paröꞌ to atan non manih pa tonon, ke Ieesuꞌ teꞌ varoe e non maꞌ pehen manuh sinten a tonon. ");
INSERT INTO tpz_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ke Ieesuꞌ ep in a ma vamomhë peꞌ to me ohoaꞌ o paröꞌ, suk a tuvuh to ipip koe ke non maꞌ nën. Pa pöstakah rakah topnin a 3 me 6 kirök, ne Ieesuꞌ to nö maꞌ manih pee. Eꞌ to tet maꞌ a tonon, ka siꞌ ö hat keꞌ oah en pee. ");
INSERT INTO tpz_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","A ma vamomhë peꞌ to ep i na poë to tetet nö non maꞌ a tonon, pare pah tötö suntan e ne, suk eꞌe to koman ne pan e Ieesuꞌ a oraꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ee kurus rakah to ep in poë pare pah rikrik e ne po naöp. Ivëhkëk, e Ieesuꞌ to vaato vëvëhöꞌ me en pee, pareꞌ soe ke raoe pan, “Teꞌ vaes nem, ko koe a naöp, eöꞌ akuk kuru.” ");
INSERT INTO tpz_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Ke Ieesuꞌ peah en po paröꞌ ko teꞌ me e non pee, ka tuvuh hik en. Ka ma vamomhë peꞌ pah töhkak ee, suk ataeah, ee to ep in a tuvuh to hik en me a ö nee to meꞌ avoeꞌ e ne pa nat vamaaka a ö ne Ieesuꞌ to makën a napan po tönim muꞌ me a poa iian. Suk, a ma kokoman pee to teꞌ nun avoeꞌ voh e ne. ");
INSERT INTO tpz_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ee to pahan ee pa tonon va Galiliꞌ, pare takin ee pa muhin va Gënesaret, pare noh töön ee po paröꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ee to këkëh tavus ko ne maꞌ o paröꞌ, ka napan inan vëvëhöꞌ rakah ee pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Ka napan va pa ma vöön kurus vëvëhöꞌ ee maꞌ pa pënton e Ieesuꞌ, ko upöm teꞌ teꞌteꞌ ee maꞌ po teꞌ varih to koroh ne pa ma tevan to haraꞌ ne a ma mët. Ka manih pa ma ö kurus ne Ieesuꞌ to vos manih pa ma vöön apaꞌpuh, ka napan teꞌteꞌ ne maꞌ o teꞌ varih to haraꞌ ne a ma mët manuh pa ö totoaan, pare hinhin vakis ne poë pan a napan varih to haraꞌ ne a ma mët se hariun ro o ohop peꞌ. Ka napan kurus varih to haraꞌ ne a ma vu mët to hariun ro ohop peꞌ, pare toꞌ vahik rakah ee. ");
INSERT INTO tpz_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ka ma upöm Parësiꞌ, me ro teꞌ vavaasis varih to nat i ne o Vavaasis pe Mosës, to taneꞌ maꞌ Jerusalëm, pare nö, ko tönun töön ee pe Ieesuꞌ marën a vahutët me poë. ");
INSERT INTO tpz_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","O Parësiꞌ, me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës to ep a ma vamomhë pe Ieesuꞌ to ënëën ne a taëën pee, a ma koreere he kukusan. Suk ataeah, eꞌe to hikta pupui momoaan a ma koreere vamanih pa ö no a taateꞌ pa kën sipun to soe va non. ");
INSERT INTO tpz_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","O Parësiꞌ, me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, se keh hikta pupui momoaan a ma koreere, eꞌe hikta antoen ne a ëën. ");
INSERT INTO tpz_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Me ee se keh hah taneꞌ maꞌ manuh po toaan, pare keh hikta pupui momoaan a ma tah varih, nee to teꞌ taneꞌ maꞌ manuh po toaan, ee hikta onöt ne a ëën a ma tah poë varih. Ee me to vavatet ne sih, a ma upöm taateꞌ to parin a peo, nee to kon taneꞌ voh maꞌ manuh pa kën sipuiire. Eꞌe to pupui ne sih o kap, sospen, me ro peret, me a ma tah vavahoꞌ taëën. ");
INSERT INTO tpz_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ivëh, ko Parësiꞌ me o teꞌ vavaasis varih to nat i ne o Vavaasis pe Mosës, to hi ee pe Ieesuꞌ pan, “Eꞌ teꞌ vah va non nih, ko vamomhë pën hikta vavatet ne a taateꞌ no a kën sipun to heꞌ voh a ra? Eꞌe to ënëën me e ne pa ma koreere to kukusan.” ");
INSERT INTO tpz_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ke Ieesuꞌ piun va in a soe pee manih pan, “A teꞌ vanënën soe vëh e Aisaëaꞌ to nat voh e non peöm o teꞌ teꞌteꞌ vapoꞌkan, eꞌ to vanënën vavoh in a soe to taneꞌ non maꞌ pe Sosoenën, to soe va non manih pan, “A napan varih to kë varoe ne sih a ëhnan neoꞌ po rivon, ivëhkëk, manih pa ma kupu pee, ee to teꞌ varo rakah këh e ne peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Eꞌe to vavaasis varoe ne sih a taateꞌ po teꞌ va po oeh vëh, pare pikpiuk ne sih pan, ‘Ivaꞌih a taateꞌ pe Sosoenën.’ Pare vasunön e ne sih peöꞌ po rivon varoe.” ");
INSERT INTO tpz_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Eöm to heꞌ tonun voh em pa taateꞌ vih pe Sosoenën, paröm vaman varoe ko nem a ma vavaasis po teꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ke Ieesuꞌ soe pet en pan, “Eöm to nat vavih rakah e nem pa taateꞌ pënton varo a taateꞌ pe Sosoenën. Ivëh, nöm to öt vakis suk nem o vavaasis koman peöm. ");
INSERT INTO tpz_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","E Mosës to kon taneꞌ voh a soe manuh pe Sosoenën, pareꞌ soe pan, “Ta e tamömah, pen e sinömah. Keteh se keh veveot e tamaneah pen e sinaneah, ea se ip vamët ee peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ivëhkëk, eöm to vavaasis nem pan, ta pah teꞌ se keh soe ke tamaneah pen e sinaneah pan, eꞌ to teꞌ me e non a tah marën a vaꞌaus raoe pon, ivëhkëk eꞌ to hikta heꞌ raoe, suk eꞌ se heꞌ na e Sosoenën a tah pamëh. ");
INSERT INTO tpz_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","A, a teꞌ pamëh to vamanman hah non e sinaneah pen e tamaneah, suk a ö neꞌ to piuk raoe, pan eꞌ se vaꞌaus raoe pon. ");
INSERT INTO tpz_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ivëh, nöm vavatet suk nem sih a taateꞌ nöm to kon taneꞌ voh maꞌ manuh pa kën sipuneöm, paröm vövöknah e nem sih pa soe pe Sosoenën. Me a ma meh taateꞌ to teꞌ ne nöm to nonok nem sih.” ");
INSERT INTO tpz_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ke Ieesuꞌ vaoe en na pa napan, kee nö maꞌ, ko tönun ee manih peꞌ, keꞌ soe ke rapoë pan, “Eöm kurus se pënton a soe peöꞌ, paröm kokoman vavih. ");
INSERT INTO tpz_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Ahik ta taëën se taneꞌ manih mahën, pareꞌ vapö a apen a teꞌ. Ahik. A tah varoe to taneꞌ maꞌ po kokoman pa teꞌ, ivëh, to vapö non a apen a teꞌ. A ma tah to teꞌ ne manih pa koman a teꞌ, keꞌ vavatvus non pa rivoneah, ee a ma tah poë varih to vapö e ne pa apen a teꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","E Ieesuꞌ to këh en maꞌ pa napan mahën, pareꞌ ho en koman iuun, ka ma vamomhë peꞌ hi ee peꞌ pa pusun in a soe vapipinoꞌ pamëh. ");
INSERT INTO tpz_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ke Ieesuꞌ hi varuꞌ en pee pan, “Eöm me to hikta nat rakah ko nem, ha? A ma tah kurus varih to teꞌ ne manih mahën se keh hop manih pa koman a teꞌ, ee hikta onöt ne a vapö a apen a teꞌ manih po epep pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Suk ataeah, eꞌ to hikta teꞌ hop non manih po kokoman peꞌ, eꞌ to nö varoe en manuh po kokea peꞌ. Keꞌ pepeak vi en peꞌ.” Manih pa soe vaꞌih ne Ieesuꞌ to sosoe non pan, a ma taëën kurus to vih e ne pa ëën manih po epep pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","E Ieesuꞌ to vatom pet en na pa soe peꞌ, pareꞌ soe vamanih pan, “A tah no a teꞌ to koman non, pareꞌ soe tavus taneꞌ manih po kokoman peꞌ. Eꞌ kuru a tah pamëh to mimiröꞌ non sih a apen a teꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","A ma tah to tavus taneꞌ maꞌ manih po kokoman pa teꞌ, to rëh e ne peꞌ manih po kokoman hat, ka ma taateꞌ poë varih, ivarih, taateꞌ rëhrëh, taateꞌ manin, taateꞌ va pa ip vamët a meh teꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Taateꞌ va pa miröꞌ o vaen, taateꞌ puhioꞌ, taateꞌ piuk, taateꞌ peat, taateꞌ möhmöh, soe vahat e Sosoenën, taateꞌ vatösoe, me a taateꞌ papön. ");
INSERT INTO tpz_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","A ma taateꞌ kurus varih to teꞌ ne sih manih po kokoman pa teꞌ. Pare tatavus ke ne maꞌ sih manih pa rivoneah, eꞌe to vapö e ne pa apen a teꞌ manih po epep pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","E Ieesuꞌ to këh maꞌ a muhin va Galiliꞌ, pareꞌ nö en manuh pa ma vöön to teꞌ ne pa muhin va Taëaꞌ me Saëdon. E Ieesuꞌ to ho en iuun, pareꞌ hikta iu non a ö no ta pah teꞌ se nat in poan to teꞌ non nën. Ivëhkëk, a napan to nat e ne pe Ieesuꞌ to teꞌ e non nën. ");
INSERT INTO tpz_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ka pah köövo no a oraꞌ hat to teꞌ non sih manih pe semoneah, to pënton a soe va pe Ieesuꞌ to teꞌ non nën, pareꞌ vëvëhöꞌ rakah en maꞌ manih peꞌ, pareꞌ vuꞌ vatët en manih pa moneah. ");
INSERT INTO tpz_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","E köövo pamëh to hikta teꞌ non pan e köövo va Israël. E sinaneah to vahuh voh poan manih pa siꞌ ö muhin va Fonisiaꞌ, a siꞌ ö muhin pamëh to teꞌ non koman a muhin va Siriaꞌ. Eꞌ to hin vakis rakah en pan e Ieesuꞌ se veo tavus këh e semoneah pa oraꞌ hat pamëh. ");
INSERT INTO tpz_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ivëh, ke Ieesuꞌ piun e köövo pamëh, pareꞌ soe vapipinoꞌ va in poan manih pan, “Eꞌ to hikta vih non pa kon a taëën po koaꞌ, ko heꞌ ro këh.” E Ieesuꞌ to soe vamanih, suk o Jiuꞌ to koman ne pan o upöm teꞌ to teꞌ va e ne manih po këh. ");
INSERT INTO tpz_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ivëh, ke köövo pamëh nat en pa pusun a soe vapipinoꞌ pe Ieesuꞌ ko vaman en, pareꞌ nat en peꞌ to hikta teꞌ non pan eꞌ a mu Jiuꞌ. Ivëhkëk, eꞌ to nat e non pe Ieesuꞌ se vaꞌaus en peꞌ. Ivëh, keꞌ soe vapipinoꞌ varuꞌ ke Ieesuꞌ pareꞌ soe pan, “Apuh, a soe pën to paraꞌ man. Ivëhkëk, o këh varih to teꞌ ne paan a pok ënëën se ëën ee po kukuvun taëën, ëën këh po koaꞌ to taru maꞌ paan a pok ënëën.” ");
INSERT INTO tpz_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ke Ieesuꞌ soe va in e köövo pamëh manih pan, “Eën to vataare eom peöꞌ po vaman pën, ivëh, kën se nö hah eom na manuh vöön me o vaeö, a oraꞌ hat to këh tavus vur en pe semomah.” ");
INSERT INTO tpz_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Eꞌ to vos hah en manuh vöön, pareꞌ ep en pe semoneah to koroh vatotomin e non tevan, pareꞌ nat en pa oraꞌ hat to këh tavus vur en peꞌ, keꞌ vih hah en. ");
INSERT INTO tpz_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","E Ieesuꞌ to taneꞌ hah en maꞌ manuh pa muhin va Taëaꞌ me Saëdon, ko koe ken Dekapolis, pareꞌ kunah en pa tonon va Galiliꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ka napan teꞌ ke maꞌ peꞌ pa pah teꞌ papön tenan, pareꞌ toto vövöꞌpë. Ee to hin vakis rakah e pe Ieesuꞌ pan, eꞌ se vahoꞌ a koreneah manih pa teꞌ pamëh. ");
INSERT INTO tpz_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ee Ieesuꞌ to me vakoaan ke këh en pe pa teꞌ pamëh, pareꞌ pöök a poa tenaneah pa poa kumis koreneah, pareꞌ teo a ma kumis koreneah ko pöök en pa meaneah. ");
INSERT INTO tpz_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ivëh, ke Ieesuꞌ ta peah en na manuh kin, pareꞌ pah vavuriah suntan rakah en, suk o kokoman peꞌ to puh rakah en po tamak, keꞌ soe pan, “Ëpapëta.” A soe pamëh to soe va non manih pan, “Takap ah.” ");
INSERT INTO tpz_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ka varuꞌ rakah vakomanih no a tenaneah to maaka en, keꞌ pënton vavih rakah en, ka tah vëh to sunpip non sih a meaneah ro en. Keꞌ taneo en pa vaato vavih hah. ");
INSERT INTO tpz_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ke Ieesuꞌ vuhvuh vakis rakah en pa napan, pan ee se nat ne vatvus a tah vaꞌih manih pa tah meh teꞌ. Eꞌ to vuhvuh raoe, ivëhkëk, ee to söë rakah ee, ko vatvus ee pa tah pamëh. ");
INSERT INTO tpz_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ka napan varih to pënton a tah vaꞌih ne Ieesuꞌ to nok pah töhkak vahat ee, pare soe ee pan, “Vahvanih ke Ieesuꞌ nok vavavih hah a ma teꞌ varih? Eꞌ to nok vavavih hah o teꞌ papön, kee tëtënan vavih hah ee pa to, me o teꞌ pos rivoe, kee vavaato hah ee!” ");
INSERT INTO tpz_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Manih po poen pamëh no a napan to tönun ha kov e maꞌ, ka manih po poen pamëh nee to hikta teꞌ me ne ta taëën, ke Ieesuꞌ vaoe ununun a ma vamomhë peꞌ, pareꞌ soe ke raoe pan, ");
INSERT INTO tpz_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Eöꞌ to uruan rakah e noꞌ pa napan varih. Suk ataeah, eꞌe to teꞌ vaꞌpeh me a neoꞌ po kukön poen, ka varuꞌ rakah vakomanih no ahikta taëën to teꞌ non, na se makën raoe. ");
INSERT INTO tpz_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ivëh, köꞌ se keh vanö maë hah eoꞌ pee manuh pa ma vöön pee, eöꞌ he hikta makën raoe, eꞌe se tötöspan rakah ee po maë manih pa ö nee to nönö hah ne, suk ataeah, a ma upöm pee to taneꞌ varo voh ee maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ka ma vamomhë peꞌ piun poë pare soe pan, “Manih pa moeh upin vëh na se kon taneꞌ maꞌ a taëën nih, to antoen non a ö na se makën a nap peo varih?” ");
INSERT INTO tpz_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ke Ieesuꞌ piun a soe pee, pareꞌ soe pan, “O tovih muꞌ ne eöm to teꞌ me nem?” Kee soe ke poë pan, “O tönim me ro pöök muꞌ ro.” ");
INSERT INTO tpz_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ke Ieesuꞌ soe ke ra napan, kee ihoꞌ ee po oeh, keꞌ kon o tönim me ro pöök muꞌ poë varih, pareꞌ soe vavihvih ke na e Sosoenën, pareꞌ kökök en pa ma muꞌ, pareꞌ ki vakëkëh ken pa ma vamomhë peꞌ, kee makën poꞌ ee pa napan. ");
INSERT INTO tpz_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ee to teꞌ me ee maꞌ pa ma siꞌ iian sosoneꞌ, ke Ieesuꞌ tapui raoe, pareꞌ soe vavih ke na e Sosoenën, pareꞌ soe ke ra ma vamomhë peꞌ, kee ki ke ra napan kurus a ma soneꞌ iian poë varih. ");
INSERT INTO tpz_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kee ëën ee, pare mahun vahik rakah ee, a napan to peo onöt ne a 4,000 teꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A napan to ëën vahik ee, ko vamomhë peꞌ ununun o tönim me o pöök kove manih pa ma ö taëën nee to ëën këh. Ke Ieesuꞌ vanö hah en pee pa ma vöön pee. ");
INSERT INTO tpz_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ka varuꞌ vakomanih ne Ieesuꞌ to peah hah en manuh po paröꞌ, me ra ma vamomhë peꞌ, kee nö ee manuh pa muhin va Dalmanuta. ");
INSERT INTO tpz_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ko Parësiꞌ nö ee maꞌ manih pe Ieesuꞌ, pare taneo ee pa vaato vasukaꞌ me poë. Pare kehkeh punöꞌ ne poë, ko hi ee peꞌ pan, eꞌ se nok a tah vatoksean va pa vöön va kin to vataare non, pan e Sosoenën to soe vaonöt ke non peꞌ pa nok a kiu pamëh. ");
INSERT INTO tpz_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Eꞌ to haraꞌ rakah en pa punis manih pa tuvuh peꞌ, pareꞌ soe en pan, “Vahvanih ka napan va kuru iu ep ne a tah vatoksean? Eöꞌ to soe vaman rakah keoꞌ peöm. Eöꞌ to hikta onöt rakah noꞌ a nok hah ka neöm to meoh tah vatoksean.” ");
INSERT INTO tpz_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","E Ieesuꞌ me ra ma vamomhë peꞌ to këh ee pa napan, pare peah ee po paröꞌ, ko taneo ee pa pahan hah pa pap tonon vöh, pa tonon va Galiliꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ko vamomhë peꞌ vanun ee pa teꞌ maꞌ ta ma taëën, ee to teꞌ varoe me ne a siꞌ pah ö taëën to pet non po paröꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ke Ieesuꞌ vakömköm va i raoe manih pa soe vapipinoꞌ peꞌ pan, “Ut vavih nem, paröm matop vavih nem pa taateꞌ hat po Parësiꞌ me a taateꞌ hat pe Hëërot. Ee tomeꞌ vamahun a neöm pa ma piuk pee vamanih po is na to hovën a praoaꞌ. Eöm se nat nem kon a taateꞌ piuk pee.” ");
INSERT INTO tpz_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ko vamomhë peꞌ taneo ee pa vaiihi koman pan, “Eꞌ to sosoe poꞌ va non manih pan ea to hikta teꞌ maꞌ ta taëën.” Ivëhkëk, ee to hikta nat vamaaka ne pa pusun in a soe vëh ne Ieesuꞌ to sosoe suk non. ");
INSERT INTO tpz_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ke Ieesuꞌ nat en pataeah nee to vaiihi suk ne, ivëh, keꞌ hi en pee pan, “Eöm vaiihi suk nem ataeah, ea hikta teꞌ vu maꞌ ta taëën ëh? Eöm hikta maaka avoeꞌ nem eh? A ma kupu peöm vösvös öh?” E Ieesuꞌ to soe va nën, suk ee to anoe voh ee pa taëën vëh ne Ieesuꞌ to makën voh o 4,000 teꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","E Ieesuꞌ to ihi avoeꞌ e non pee, pareꞌ soe pan, “Eöm to teꞌ me e nem pa matëëneöm, paröm hikta ep nem ta tah, ha? Me eöm to teꞌ me e nem pa tenëneöm, paröm hikta pënton nem, ha? ");
INSERT INTO tpz_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Vahvapoꞌnih po 5,000 teꞌ varih nöꞌ to makën voh raoe po tönim muꞌ? O tovih kove va pa ma ö taëën ëën këh to oah voh, nöm to ununun hah?” Ko vamomhë peꞌ piun poë, pare soe pan, “O havun me ro pöök.” ");
INSERT INTO tpz_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ke Ieesuꞌ hi hahah kov en pee pan, “Eöꞌ kökök voh o tönim me ro pöök muꞌ, paröꞌ makën o 4,000 teꞌ, köm ununun hah o tovih kove va pa ma ö taëën ëën këh varih to oah ne?” Ko vamomhë peꞌ piun va in poë manih pan, “O tönim me ro pöök kove.” ");
INSERT INTO tpz_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ke Ieesuꞌ hi raoe pan, “Eöm hikta ep inan avoeꞌ nem eh?” ");
INSERT INTO tpz_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","E Ieesuꞌ me a ma vamomhë peꞌ to nö, pare vos ee manuh Bëtsaëtaꞌ, ka napan teꞌ ee maꞌ pa teꞌ kehoꞌ manih pe Ieesuꞌ. Pare hin vakis ee peꞌ, pan eꞌ se vaket poan, keꞌ toꞌ hah. ");
INSERT INTO tpz_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","E Ieesuꞌ to öt a koreneah, pareꞌ kees këh en peꞌ pa vöön, pareꞌ teo pip a mataneah, ko hi poan pan, “Eën onöt e nom pa ep eh?” ");
INSERT INTO tpz_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ka teꞌ pamëh ta peah maꞌ, pareꞌ soe en, “A, eöꞌ to ep e noꞌ pa napan, ivëhkëk, eꞌe to matan ke ne pan, a naon to nönö vah ne.” ");
INSERT INTO tpz_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ke Ieesuꞌ vaket hahah kov en manih pa mataneah, keꞌ kap vaꞌpuh en pa mataneah, pareꞌ ep vamaaka hah en pa moeh tah kurus. ");
INSERT INTO tpz_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ke Ieesuꞌ vanö hah en peꞌ manuh iuun peꞌ, pareꞌ vuhvuh poan, pan eꞌ se nat non vos manuh pa vöön apuh. ");
INSERT INTO tpz_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","E Ieesuꞌ me a ma vamomhë peꞌ to këh e maꞌ pa vöön va Bëtsaëtaꞌ pare nö ee manuh pa ma siꞌ vöön to teꞌ vatët ne pa vöön apuh va Sisariaꞌ Filipaë. Manih po poen nee to nönö ne, ke Ieesuꞌ hi rapoë pan, “A ma napan popokaꞌ a no neoꞌ, eteh?” ");
INSERT INTO tpz_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kee soe ee pan, “E Jon Tövapupui, ka ma upöm popokaꞌ a nom oah e Elaëjaꞌ, keꞌ, eën a pah teꞌ va pa nap vanënën soe to toꞌ hah maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Keꞌ hi pet en pee pan, “Ke eöm koman poꞌ, eöm popokaꞌ poꞌ a nem neoꞌ, eteh?” Ke Pitaꞌ piun poan, pareꞌ soe pan, “Eën e Kristo.” ");
INSERT INTO tpz_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ke Ieesuꞌ vuhvuh vakis raoe pan, ee se nat ne soe ke ta meh teꞌ. “Eöꞌ a teꞌ ne Sosoenën to vateꞌ voh.” ");
INSERT INTO tpz_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","E Ieesuꞌ to taneo en pa vavaasis a ma vamomhë peꞌ pareꞌ soe pan, “Eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus se kon o kamis apuh rakah manih pa koreera nap susunön po Jiuꞌ, me ro teꞌ susunön ësës heꞌ, me ro teꞌ vavaasis varih to nat i ne o Vavaasis pe Mosës. pare ip vamët ee peöꞌ, ko vakön poen nöꞌ se sun taneꞌ hah eoꞌ manih po vapeepe.” ");
INSERT INTO tpz_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Eꞌ to soe a soe vaꞌih, keꞌ maaka rakah ke non pee. Ivëh, ke Pitaꞌ me ke poan, pareꞌ siröꞌ en peꞌ pan, “Eën se nat nom sosoe va nom manih.” ");
INSERT INTO tpz_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ke Ieesuꞌ tarih, pareꞌ kukuteꞌ o vamomhë peꞌ, pareꞌ siröꞌ e Pitaꞌ, ko soe pan, “Susun po oraꞌ hat, këh a na neoꞌ ah! A soe pën to hikta teꞌ non pan a soe pe Sosoenën, ahik, a soe pën, eꞌ a soe pa teꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","E Ieesuꞌ to vaoe ununun en na pa napan me ra ma vamomhë peꞌ kee tönun vatët rakah ee maꞌ manih pa havineah. Keꞌ soe ke rapoë pan, “Ta pah teꞌ se iu vatet a no neoꞌ, eꞌ se vöknah o iu koman peꞌ, pareꞌ teꞌ a kuruse peꞌ, pareꞌ teꞌ o kamis ko vatet a maꞌ neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ta pah teꞌ se keh matop tamoaan non o toꞌtoꞌ peꞌ, pareꞌ hikta vatet a neoꞌ, o toꞌtoꞌ peꞌ se ro amot en. Ka ta pah teꞌ se keh koman a no neoꞌ, pareꞌ mët suk a neoꞌ, me a Soe Vih peöꞌ, a, amot eꞌ se kon en po toꞌtoꞌ tamoaan. ");
INSERT INTO tpz_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ta pah teꞌ se keh kon en pa ma tah kurus va po oeh vëh, pareꞌ vanun en po toꞌtoꞌ tamoaan peꞌ, a ma tah poë varih se poꞌ vaꞌaus vah va in o toꞌtoꞌ peꞌ nih? Ahik rakah! ");
INSERT INTO tpz_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ahik ta pah tah no a teꞌ to onöt non a voen hah o toꞌtoꞌ peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","A napan va kuru to heꞌ tonun ne pe Sosoenën, ko nonok e ne pa ma taateꞌ hat. Ta pah teꞌ se keh haraꞌ vapoet a no neoꞌ, me o vavaasis peöꞌ, a, eöꞌ me e Koaꞌ Teꞌ Pa Napan Kurus se haraꞌ vapoet e noꞌ peꞌ po poen ne eöꞌ se nö vaꞌpeh me maꞌ o ankeroꞌ vivihan pe Sosoenën, me o maaka pe Tamön.” ");
INSERT INTO tpz_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ke Ieesuꞌ soe ke ra ma vamomhë peꞌ pan, “Eöꞌ to soe vaman rakah keoꞌ peöm, a ma pah teꞌ to sun ne manih kuru, se meꞌ avoeꞌ e ne pa mët, ee heh ep ee pa Matop Vih pe Sosoenën se tavus me maꞌ o kikis.” ");
INSERT INTO tpz_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","O tönim me o pöh poen to oah ee, ke Ieesuꞌ me e Pitaꞌ, me ra poa tom kea e Jëmis pen Jon. Ee varoe to peah pa tope a pah va kin. Ee varoe kuru to teꞌ vaꞌpeh me ne e Ieesuꞌ, ka sionin e Ieesuꞌ tarih, ko matan ke en. ");
INSERT INTO tpz_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ko ohop peꞌ kakaare oah rakah en pa ö no a teꞌ va po oeh to pupui o rara peꞌ, keꞌ teꞌ va non. ");
INSERT INTO tpz_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ke Elaëjaꞌ, pen e Mosës tavus ee maꞌ, pare vavaato me e ne pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ke Pitaꞌ soe ke Ieesuꞌ pan, “Eeh, Apuh, eꞌ to vih rakah e non pea to teꞌ no manih kuru, vaonöt ka möm ah, kemöm u a kukön tanu manih. A teꞌ pën, ka teꞌ pe Mosës, me a teꞌ pe Elaëjaꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","E Pitaꞌ me a meh poa vamomhë peꞌ to pah naöp vörep ee, ivëh, ke Pitaꞌ toksean en, pareꞌ hikta maaka vavih vi non pa soe neꞌ to soe. ");
INSERT INTO tpz_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ka unöh pöm en pee, ka to taneꞌ maꞌ manih pa koman a unöh to soe va non manih pan, “Eꞌ ivaꞌih e Koaꞌ peöꞌ, ne eöꞌ to iu oah vi noꞌ eah sih, ivëh, köm sih pënton vavih a soe peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ka varuꞌ rakah vakomanih nee to vaveves vah ko ne, pare hikta ep hah ne ta meh teꞌ. E Ieesuꞌ varoe a paeh to teꞌ vaꞌpeh me non raoe. ");
INSERT INTO tpz_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ee to këh kunah hah ee maꞌ pa tope pamëh, ke Ieesuꞌ vuhvuh raoe, ko soe ke rapoë pan, “A tah vaꞌih nöm to ep vu maꞌ manuh pa tope, ne eöm se nat nem soe tavus ke ta meh teꞌ, eꞌ se teꞌ non, ko onöt rakah po poen ne eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus se toꞌ hah maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ee to koaan vakis rakah e ne pa ma soe ne Ieesuꞌ to soe ke raoe pa ma kokoman pee. Ivëhkëk, manih koman pee, nee to vaiihi koman hah a ne pan, “A toꞌ hah maꞌ, soe non ataeah?” ");
INSERT INTO tpz_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ke Pitaꞌ, ke Jëmis pen kea peꞌ Jon hi ee pe Ieesuꞌ pan, “Suk ataeah ko teꞌ vavaasis to nat i ne o Vavaasis pe Mosës sosoe ne pan e Elaëjaꞌ se vovoh maꞌ?” ");
INSERT INTO tpz_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","E Ieesuꞌ to piun raoe, pareꞌ sosoe suk non e Jon Tövapupui, ko soe ke rapoë pan, “A soe pee a man, e Elaëjaꞌ to vovoh voh en maꞌ, pareꞌ vatotoopin vahik voh en pa ma moeh tah kurus. Eꞌ teꞌ vah va poꞌ non nih ko Puk Vapenpen soe va non manih pan, eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus to se teꞌ o kamis, kee heꞌ tonun a neoꞌ, pare miröꞌ a neoꞌ, ko ip vamët ee peöꞌ? ");
INSERT INTO tpz_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ivëh, köꞌ se soe keoꞌ peöm pan, a teꞌ vëh no a napan to koman voh ne pan e Elaëjaꞌ, eꞌ to nö voh en maꞌ. Ivëhkëk, a ma napan to vatet voh ee pa ma iu pee, pare nok a ma taateꞌ hat manih peꞌ, keꞌ tavus va en manih pa ö no Puk Vapenpen to soe va non.” ");
INSERT INTO tpz_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ke Ieesuꞌ me a kukön vamomhë tavus vatönun hah me ee maꞌ po upöm pee, pare ep i ra napan peo rakah to tönun maꞌ. O teꞌ vavaasis to nat i ne o Vavaasis pe Mosës to vavaato vasukaꞌ me ne a ma vamomhë pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","A napan to ep in e Ieesuꞌ to nö maꞌ, pare pah töhkak vahat ee, pare nö vëhöꞌ ee manuh pe Ieesuꞌ pare vaöt koren me ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ke Ieesuꞌ hi en pa ma vamomhë peꞌ pan, “Ataeah ne eöm to vavaato vasukaꞌ suk me nem o teꞌ vavaasis poë varih?” ");
INSERT INTO tpz_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ka pah teꞌ to teꞌ non topnin a napan poë varih piun maꞌ a soe pe Ieesuꞌ, pareꞌ soe maꞌ pan, “Apuh, eöꞌ to me vu maꞌ e koaꞌ oeteꞌ peöꞌ manih pa ma vamomhë pën, pan ee se veo këh poë pa oraꞌ hat to teꞌ non manih peꞌ, keꞌ hikta toto non. ");
INSERT INTO tpz_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","A ma poen kurus rakah no a oraꞌ hat sih öt sih poan ko vi en peꞌ manih po oeh. Ko poe kakaare tatavus ke non maꞌ manih pa rivoneah, keꞌ vakuskus rivon e non. Ke eöꞌ hin vu a ma vamomhë pën, pan ee se veo tavus a oraꞌ hat pamëh, ivëhkëk, ee hikta onöt ne a veo poë.” ");
INSERT INTO tpz_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ke Ieesuꞌ soe ke ra vamomhë peꞌ pan, “Eöm varih to hikta vaman avoeꞌ rakah nem e Sosoenën se vatoꞌ en po teꞌ, O tovih poen ne eöꞌ se teꞌ vaꞌpeh tamoaan me a noꞌ neöm? A tovih poen ne eöꞌ se teꞌ a ma punis peöm? Me maꞌ öm e koaꞌ manih peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kee me ee maꞌ pe koaꞌ pamëh manih pe Ieesuꞌ, ka oraꞌ hat pamëh ep in e Ieesuꞌ, pareꞌ pah kö suntan en pe koaꞌ, ke koaꞌ vuꞌ en po oeh ko vakuku vah e non, ko poe tavus ke maꞌ manih pa rivoneah. ");
INSERT INTO tpz_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ke Ieesuꞌ hi en pe tamaneah pan, “E koaꞌ haraꞌ varë vi voh en pa mët vëh ëh?” Ke tamaneah piun va en manih pan, “Eꞌ to taneo rakah voh en pa ö neꞌ to teꞌ non a koaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","A ma tamoaan rakah no a oraꞌ hat pamëh to kehkeh ip vamët e non sih peꞌ. Eꞌ to viivi non sih poan po suraꞌ me manih koman ruen. Ivëhkëk, eën se nom onöt nom a vatoꞌ hah e koaꞌ peöꞌ, kën ururuan a möm, parën vaꞌaus eom pemöm.” ");
INSERT INTO tpz_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ke Ieesuꞌ soe ke poan pan, “Eën se koe a soe vamanih pan, ‘Eën se nom onöt nom.’ Suk ataeah, eöꞌ to onöt rakah e noꞌ pa nok va nën po teꞌ varih to vaman a non neoꞌ sih.” ");
INSERT INTO tpz_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ivëhkëk, e taman e koaꞌ pamëh to hin vakis en maꞌ pan, “Eöꞌ to vaman e noꞌ pën. Ivëhkëk, o vaman peöꞌ hikta teꞌ apuh non, sën vaꞌaus a neoꞌ ko vaman peöꞌ sih apuh.” ");
INSERT INTO tpz_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","E Ieesuꞌ to ep a napan to vavahuk nö e ne maꞌ manih pee, ivëh, keꞌ siröꞌ a oraꞌ hat pamëh to teꞌ non sih pe koaꞌ, pareꞌ soe pan, “Papön, eöꞌ to taꞌ a nös oah, këh tavus maꞌ e koaꞌ manem, parën nat nom hah hop manih peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ka oraꞌ hat pamëh kokoeꞌ, pareꞌ vi en na pe koaꞌ manuh po oeh, ko këh tavus en pe koaꞌ, ke koaꞌ koroh ke non pan eꞌ to mët en. Ka nap peo soe e pan, “Eꞌ to mët en.” ");
INSERT INTO tpz_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ivëh, ke Ieesuꞌ öt pa koreneah ko kë vasun poan, keꞌ sun en pareꞌ toꞌ hah en. ");
INSERT INTO tpz_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Vasuksuk poꞌ ne Ieesuꞌ to nö en manuh iuun, pareꞌ teꞌ aven e non, ka ma vamomhë varoe peꞌ hi ee peꞌ pan, “Emöm hikta onöt suk nem a veo tavus a oraꞌ hat pamëh ataeah?” ");
INSERT INTO tpz_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “A hin varoe kuru to onöt non a veo tavus o vu oraꞌ hat to teꞌ va ne manih. Ahikta meh tah to onöt non.” ");
INSERT INTO tpz_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ke Ieesuꞌ me ra ma vamomhë peꞌ këh ee pa vöön vëh neꞌ to vatoꞌ hah e koaꞌ pamëh, pare teꞌ ne topnin a muhin va Galiliꞌ. Ke Ieesuꞌ rës rakah e non pa ta pah teꞌ se nat a ö neꞌ to teꞌ non. ");
INSERT INTO tpz_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Suk ataeah, eꞌ to vavaasis non a ma vamomhë peꞌ, pareꞌ soe ke raoe pan, “Eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus no a teꞌ se vikuh en peöꞌ manih pa koreera nap hat, kee sih ip vamët e peöꞌ, ka kukön poen sih oah, köꞌ toꞌ hah, ko sun hah eoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ivëhkëk, a ma vamomhë peꞌ to hikta maaka i ne a pusun in a soe pamëh, ivëh, kee nanaöp e ne pa hi poë. ");
INSERT INTO tpz_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kee vos hah ee manuh Kapaneam, pare ho e manuh iuun, ke Ieesuꞌ hi en pa ma vamomhë peꞌ pan, “Ataeah nöm to vavaasoe vasukaꞌ suk nö vu nem maꞌ manuh hanan?” ");
INSERT INTO tpz_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ivëhkëk, ee to hikta piun a hi pe Ieesuꞌ, suk ataeah, ee to poet suk a ö nee to vavaato vasukaꞌ nö vu ne maꞌ manuh hanan suk eteh se teꞌ non a tasun apuh oah manih pee. ");
INSERT INTO tpz_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ivëh, ke Ieesuꞌ ihoꞌ en, pareꞌ vaoe en na pa ma vamomhë peꞌ, pareꞌ soe ke raoe pan, “Ta pah teꞌ se keh iu non a tasun apuh oah manih pa matan e Sosoenën, eꞌ a teꞌ pamëh se vöknah hah ea, pareꞌ kikiu va non manih pa teꞌ to kiu akuk non pa napan.” ");
INSERT INTO tpz_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Ke Ieesuꞌ vaoe na a siꞌ koaꞌ soneꞌ, pareꞌ vasun poan manih pa topnin in a ma vamomhë peꞌ, pareꞌ vaket non peꞌ, ko soe ke raoe pan, “A teꞌ vëh to koman non a ëhnaneoꞌ, pareꞌ kamöꞌ non e koaꞌ soneꞌ to teꞌ va non manih pe siꞌ koaꞌ vaꞌih, eꞌ kuru to kamöꞌ me e non peöꞌ. Ka teꞌ to kamöꞌ a non neoꞌ, eꞌ to hikta kamöꞌ varoe a non neoꞌ, eꞌ to kamöꞌ me e non pe Tamön vëh to vanö voh a maꞌ neoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ke Jon soe ken pe Ieesuꞌ pan, “Apuh, emöm to ep in a pah teꞌ to veveo tavus non sih o oraꞌ hat këh o teꞌ manih pa ëhnöömah. Ivëh, kemöm soepip em peꞌ, suk eꞌ to hikta teꞌ non po kum pea.” ");
INSERT INTO tpz_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ivëhkëk, e Ieesuꞌ to soe ke raoe pan, “Eöm se nat nem soepip in eah, eꞌ se nonok e non pa tah vatoksean manih pa ëhnaneoꞌ, me o kikis peöꞌ. Suk ataeah, eꞌ to hikta sosoe vahat non a ëhnaneoꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","A teꞌ to hikta hat ka rora sih, eꞌ kuru a teꞌ pea. ");
INSERT INTO tpz_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pënton vavih nem pa soe vaꞌih, se röꞌ soe ka neöm, eteh se keh ep ka neöm, pareꞌ heꞌ a neöm a ruen kaak, suk eöm to vatös me a non neoꞌ, e Kristo. A teꞌ pamëh ne Sosoenën se heꞌ en peꞌ po voen vëh to hikta onöt non ahik.” ");
INSERT INTO tpz_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ivëhkëk, ta pah teꞌ se keh koman non pan, eꞌ se rëh ke o vaman pa ta siꞌ pah koaꞌ soneꞌ, keꞌ kuꞌ manih pa taateꞌ hat, eꞌ to vih rakah non pa vahan a vös topoan manih pa koꞌkoneah, ko varokoꞌ eah tahiꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ivëh, ka koreomah se keh vakuꞌ a oah manih pa taateꞌ hat, moes kurus eah! Eꞌ to vih oah non pa ö nën se teꞌ ro me nom ö pöh koren, kën sih kon o toꞌtoꞌ tamoaan. Peꞌ to hat non pa ö nën to teꞌ me nom o pöök koren, ee se rëh ke pën pa hat, kee vi ee na pën manuh po suraꞌ ësës tamoaan. Manuh pa vöön pamëh no ves sosoneꞌ to hikta onöt ne a mët, ka suraꞌ pamëh to hikta mumuteꞌ non sih. ");
INSERT INTO tpz_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ka momah se keh vakuꞌ a oah manih pa taateꞌ hat, moes kurus eah! Eꞌ to vih oah non pa ö nën se teꞌ me nom o pöh mon ro, kën sih kon o toꞌtoꞌ tamoaan. Peꞌ to hat non pa ö nën to teꞌ me nom o pöök mon, ee se rëh ke pën pa hat, kee vi ee na pën manuh po suraꞌ ësës tamoaan. ");
INSERT INTO tpz_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Ka matömah se keh vakuꞌ a oah manih pa taateꞌ hat, të kon eah, ko vi na! Eꞌ to vih non pa ö nën se teꞌ me nom o pöh matan varoe, kën sih teꞌ hop nom manih pa Matop pe Sosoenën. Eꞌ to hat non pa ö nën se teꞌ me nom o pöök tök matan, kee rëh ke pën pa hat, kee vi ee na pën manuh po suraꞌ ësës tamoaan. ");
INSERT INTO tpz_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Eöm se teꞌ a ma punis, paröm sun vakis ko vaman e Sosoenën, köm sih tavus o teꞌ totoopin manih pa matan e Sosoenën, vamanih pa gol ne to ës po suraꞌ keꞌ kakaare hah, pareꞌ voon en. ");
INSERT INTO tpz_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Me eöm to teꞌ va e nem manih pa sö tetehean, nee to sö a taëën keꞌ ninin vih. Ivëhkëk, o tetehean va pa sö pamëh se keh hikta teꞌ non, eꞌ se vaninin vih vah va in taëën pamëh nih? Eöm se teꞌ rakah vako nem manih pa sö tetehean, a ma kokoman peöm se teꞌ vatö ne, köm vakamöꞌ me ra ma upöm peöm.” ");
INSERT INTO tpz_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","E Ieesuꞌ me ra ma vamomhë peꞌ to sun, pare këh ee pa muhin va Galiliꞌ, pare pahan ee pa ruen vëh Jödën, ko tavus ee pa muhin va Jiutiaꞌ. Ka nap peo tönun hahah kov ee maꞌ manih peꞌ. Keꞌ vatet hahah kov en pa ma taateꞌ peꞌ. Eꞌ to vavaasis hahah kov en pee pa soe pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ko Parësiꞌ nö ee maꞌ manih pe Ieesuꞌ, pare punöꞌ poë pa ma soe, pare soe pan, “Soe ka möm mah. O Vavaasis pe Mosës soe vaonöt kës e non pe voe se kök o vaen, pareꞌ veo e köövo peꞌ, ha?” ");
INSERT INTO tpz_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ke Ieesuꞌ piun vaꞌpeh me a hi, pareꞌ soe pan, “A taateꞌ taeah ne Mosës to heꞌ voh a neöm?” ");
INSERT INTO tpz_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ko Parësiꞌ soe ke Ieesuꞌ pan, “E Mosës to vaonöt voh en pa teꞌ se kiun o kiun marën a kök o vaen peꞌ, pareꞌ veo en pe köövo peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ivëhkëk, e Ieesuꞌ to soe ke raoe pan, “E Mosës to kiun voh ka neöm a taateꞌ pamëh, suk ataeah, eöm o teꞌ o pöh vatösoe rakah. ");
INSERT INTO tpz_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ivëhkëk, manih pa taneo in a ma moeh tah, a soe to kiun non manih po Puk Vapenpen to soe non pan, “E Sosoenën to nok voh a teꞌ, a teꞌ oeteꞌ, me e köövo.” ");
INSERT INTO tpz_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ivëh, ne voe se këh suk maꞌ e tamaneah pen e sinaneah, pareꞌ teꞌ vatös me e non pe köövo peꞌ, kee tavus ee pon a paeh.’” ");
INSERT INTO tpz_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","“Ivëh, kee pon to hikta se teꞌ hah ne a pöök, Ahik. Ee to tavus ee o pöh sionin. ");
INSERT INTO tpz_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","E Sosoenën to vatös voh en pee pon, ka hikta pah teꞌ to onöt non a kök vakëh hah raoe pon.” ");
INSERT INTO tpz_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Vasuksuk, nee to ho hah ee koman iuun, ko vamomhë peꞌ hi hah ee peꞌ pa pusun in a tah pamëh. ");
INSERT INTO tpz_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ke Ieesuꞌ soe ke raoe pan, “Ta pah teꞌ se keh veo e köövo peꞌ, pareꞌ me a meh köövo, a teꞌ pamëh to nok rakah en pa taateꞌ rëhrëh, eꞌ to vöknah e non pe köövo vamomoaan peꞌ manih pa matan e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Manih pa paeh a taateꞌ pamëh, ne köövo se keh veo e voe peꞌ, pareꞌ me a meh voe, e köövo pamëh to nok rakah me en pa taateꞌ teꞌteꞌvaasiꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ka napan meeme ee maꞌ po koaꞌ sosoneꞌ manih pe Ieesuꞌ, pan eꞌ se vaket, ko tapui raoe. Ivëhkëk, o vamomhë peꞌ to siröꞌ ee pa napan poë varih. ");
INSERT INTO tpz_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ivëhkëk, e Ieesuꞌ to ep in a taateꞌ pamëh, pareꞌ heve en, pareꞌ soe ke ra ma vamomhë peꞌ pan, “Koe raoe, kee nö maꞌ manih peöꞌ, paröm koe a sunpip raoe. Suk ataeah, a Matop Vih pe Sosoenën to teꞌ suk non o teꞌ to teꞌ va ne manih po siꞌ koaꞌ varih. ");
INSERT INTO tpz_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Eöꞌ to soe vamaman rakah keoꞌ peöm, ta pah teꞌ se keh hikta kon a Matop Vih pe Sosoenën vamanih po siꞌ koaꞌ sosoneꞌ varih, eꞌ to hikta onöt rakah non a hop pa Matop Vih pamëh.” ");
INSERT INTO tpz_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","E Ieesuꞌ to pëtpët o siꞌ koaꞌ, pareꞌ vaket non po koaꞌ, ko tapui en pee. ");
INSERT INTO tpz_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ke Ieesuꞌ me ra ma vamomhë peꞌ taneo hahah kov ee pa suk a hanan, ka pah teꞌ vavaveo maꞌ manih peꞌ, pareꞌ vatokon en manih pa matan eah, ka teꞌ pamëh hi poan, pareꞌ soe pan, “Apuh vih, eöꞌ se nok ataeah, paröꞌ kon o toꞌtoꞌ tamoaan?” ");
INSERT INTO tpz_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ke Ieesuꞌ hi poan pan, “Vahvanih kën pokaꞌ a neoꞌ a vih? Ahikta pah teꞌ vih. E Sosoenën varoe a paeh a vih. ");
INSERT INTO tpz_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ke Ieesuꞌ soe ke poan pan, “Eën to nat e non pa ma taateꞌ ne Sosoenën to heꞌ voh e Mosës, ‘Koe a ip vamët a meh teꞌ, koe a nok a taateꞌ rëhrëh, koe a kaveo, koe a piuk in a meh teꞌ pën manih po vahutët, koe a piuk marën a öt akuk a tah pa meh teꞌ, parën ta non e tamömah pen e sinömah.” ");
INSERT INTO tpz_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ka teꞌ pamëh soe ke Ieesuꞌ pan, “Apuh, taneo voh non maꞌ po poen ne eöꞌ to teꞌ voh noꞌ a koaꞌ ko öök non kuru, eöꞌ to vavatet kurus voh e noꞌ pa ma taateꞌ varih.” ");
INSERT INTO tpz_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","E Ieesuꞌ to ves rakah non manih pa mataneah, pareꞌ pah iu rakah e non peꞌ, pareꞌ soe pan, “A pah tah ro ne eën to kökööt avoeꞌ nom ivëh, eën se nö, parën vavoen vahik rakah a ma tah kurus pën, parën kon a moniꞌ ko heꞌ o teꞌ varih o arus. Ivëh, kën sih teꞌ amot me nom a ma tah kokoek manuh pa vöön va kin, parën vatet poꞌ a maꞌ neoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","A teꞌ pamëh to pënton a soe vaꞌih ko pah ep vahat en, pareꞌ pah nö me en po tamak, suk ataeah, eꞌ to vaneah non a ma tah to parin a peo. ");
INSERT INTO tpz_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","E Ieesuꞌ to kukuteꞌ a ma vamomhë peꞌ, pareꞌ soe ke raoe pan, “Eꞌ to hivaꞌ rakah ke non po teꞌ öt ö pa hop manih pa Matop Vih pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ko vamomhë pe Ieesuꞌ pah töhkak vahat rakah ee pa soe pe Ieesuꞌ, ivëh, ke Ieesuꞌ soe ke raoe pan, “Pus koaꞌ peöꞌ, a teꞌ se kehkeh hop non manih pa Matop Vih pe Sosoenën, eꞌ to hivaꞌ rakah ke non peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Eꞌ to teꞌ tö rakah ke non pa këmol pa hop koe manih pa töhkoꞌ in a ni kunkun. Ivëhkëk, eꞌ to hivaꞌ oah rakah e non pa teꞌ öt ö to kehkeh hop non manih pa Matop Vih pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","A ma soe varih no a ma vamomhë to pënton, pare pah töhkak vahat ee, pare vaiihi koman hah e ne pan, “Eꞌ se keh teꞌ va non nën, keteh se poꞌ kon o toꞌtoꞌ tamoaan?” ");
INSERT INTO tpz_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","E Ieesuꞌ to ves rakah non manih pee, pareꞌ soe ke raoe pan, “A ma tah varih no a napan to hikta onöt ne a nok, Ivëhkëk, e Sosoenën onöt e non pa nok a ma moeh tah kurus.” ");
INSERT INTO tpz_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ke Pitaꞌ soe ke Ieesuꞌ pan, “Ep ah! Emöm to këh kurus voh em maꞌ pa ma tah pemöm, pamöm vatet em maꞌ pën.” ");
INSERT INTO tpz_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ke Ieesuꞌ soe ke raoe pan, ‘Eöꞌ to soe vamaman rakah keoꞌ peöm. A napan varih to koman voh a maꞌ neoꞌ, me a soe vih peöꞌ, pare këh maꞌ a ma iuun pee, me a ma kea pee, me a ma vameere, me a ma tamëëre, me a ma sinëëre, me a ma rak pee, ");
INSERT INTO tpz_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ee se kon oah ee pa ma 100 tah va pa ma tah nee to këh maꞌ. Ko poen nee se teꞌ avoeꞌ ne manih po oeh, ee se kon ee pa ma iuun peo, me ra ma kea peo, me ra ma sinan peo, me a ma vamen peo, me a ma pus koaꞌ peo, me a ma rak peo, me ee se kon ee o toꞌtoꞌ tamoaan. ");
INSERT INTO tpz_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ivëhkëk, o teꞌ varih to vovoh ne kuru manih po oeh, amot nee se vasuksuk varuꞌ hah ne maꞌ, ko teꞌ varih to vasuksuk ne kuru, amot nee se vovoh varuꞌ ne.” ");
INSERT INTO tpz_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ko poen nee to suksuk nö ne a hanan to nö non manuh Jerusalëm, ke Ieesuꞌ vëhöꞌ vovoh ken pee, ka ma vamomhë peꞌ pah naöp suntan ee. Ka napan me varih to suksuk nö ne raoe vananaöp pet ee, pare koman ne pan, ta pah tah hat se tavus raoe manuh Jerusalëm. Ke Ieesuꞌ me ke en pa havun me ra poa vamomhë peꞌ, pareꞌ soe vanat en pee pataeah se tavus manih peꞌ manuh Jerusalëm. ");
INSERT INTO tpz_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","E Ieesuꞌ to soe ke ra ma vamomhë peꞌ pan, “Pënton vavih nem, ea to ëpëp nö e no manuh Jerusalëm, ka pah teꞌ se heꞌ en peöꞌ e Koaꞌ Teꞌ Pa Napan Kurus manih pa koreero teꞌ susunön ësës heꞌ, me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës. Kee se vahoꞌ ee peöꞌ po vahutët, pare vaonöt ee pa ip vamët a neoꞌ. Ee se heꞌ a neoꞌ manih pa koreera napan varih to hikta teꞌ ne pan ee ro Jiuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ee se kö a neoꞌ, pare teteo a neoꞌ, ko rëp a neoꞌ, pare ip vamët a neoꞌ, köꞌ mët eoꞌ. Ko kukön poen sih oah, köꞌ toꞌ hah, paröꞌ sun taneꞌ hah eoꞌ maꞌ po vapeepe.” ");
INSERT INTO tpz_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","A poa sunaiꞌ Sëbëdiꞌ e Jëmis pen e Jon to nö maꞌ manih pe Ieesuꞌ, pare soe pan, “Apuh, emöm to iu nem a siꞌ pah tah, ne eën se nok manih pemöm.” ");
INSERT INTO tpz_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ke Ieesuꞌ hi raoe pan, “Eöm iu nem ataeah ne eöꞌ se nok manih peöm pom?” ");
INSERT INTO tpz_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ke Jëmis pen kea peꞌ Jon soe kee pe Ieesuꞌ pan, “Amot ne eën se kon a tasun apuh, kemöm iu nem ta paeh pemöm se ihoꞌ non manih pa papmatö pën ka meh ihoꞌ non pa papkiruk pën.” ");
INSERT INTO tpz_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ivëhkëk, e Ieesuꞌ to piun a soe pee pareꞌ soe pan, “Eöm to hikta nat vavih nem pataeah nöm to ihi a no neoꞌ pom. Eöm antoen kës e nem pa kaak pa kap vëh nöꞌ se kaak manih peꞌ? Paröm onöt kës e nem pa teꞌ o kamis vëh ne eöꞌ se teꞌ? Keꞌ eöm onöt e nem pa mët vamanih pa ö ne eöꞌ se mët vah ava manih pa kuruse ha?” ");
INSERT INTO tpz_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ke Jëmis pen e Jon piun ee pa soe pe Ieesuꞌ, pare soe pan, “Emöm to antoen e nem poꞌ pa nok a ma tah varih nën to sosoe nom.” Ke Ieesuꞌ soe varuꞌ ke raoe pon a soe vapipinoꞌ, pareꞌ soe pan, “Oman rakah! A kap vaꞌih ne eöꞌ se kaak manih peꞌ, ne eöm se kaak me em. Eöm me to onöt e nem pa mët vamanih pa ö ne eöꞌ se mët vah ava manih pa kuruse.” ");
INSERT INTO tpz_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","“Ivëhkëk, eöꞌ to hikta teꞌ me noꞌ to kikis marën a kon eteh se ihoꞌ manih pa papmatö peöꞌ, me a papkiruk peöꞌ. Ahik! E Sosoenën koman se heꞌ a poa ö ihihoꞌ poë varih manih pe retereh neꞌ to vamatop keon ke voh en pee.” ");
INSERT INTO tpz_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","A meh havun vamomhë to pënton a soe vaꞌih, pare pah heve ov ee pe Jëmis pen e Jon. ");
INSERT INTO tpz_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ivëh, ke Ieesuꞌ vaoe ununun en pa ma vamomhë peꞌ, kee tönun ee maꞌ manih peꞌ, keꞌ soe ke raoe pan, “Eöm nat e nem po teꞌ varih to hikta teꞌ ne pan ee ro Jiuꞌ, ee to matop vakis rakah e ne pa napan pee. Me o upöm teꞌ apaꞌpuh pee to kikis rakah ov e ne pa napan pee se vavatet ne a ma soe pee. ");
INSERT INTO tpz_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ivëhkëk, a taateꞌ teꞌteꞌ vasusunön to hikta se teꞌ non topnineöm. Ivëh, keteh to kehkeh tavus non a teꞌ sunön manih peöm eꞌ se teꞌ non a teꞌ kikiu peöm kurus. ");
INSERT INTO tpz_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ka teꞌ se keh vovoh ka no neöm, eꞌ se teꞌ rakah ko non a teꞌ to kiu akuk non manih pa napan kurus. ");
INSERT INTO tpz_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Suk ataeah, eöꞌ E Koaꞌ Teꞌ Pa Napan Kurus ne Sosoenën to hikta vanö voh maꞌ marën a napan se kiu vaꞌaus a ne neöꞌ. Ahik. eöꞌ to nö voh maꞌ pa vaꞌaus raoe, me eöꞌ se heꞌ o toꞌtoꞌ peöꞌ manih pa ö ne eöꞌ se mët marën a hehe a napan varih no a taateꞌ hat to nohnoh non rapoë.” ");
INSERT INTO tpz_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","E Ieesuꞌ me ra ma vamomhë peꞌ to vos ee manuh pa vöön va Jerikoꞌ. Pare oꞌoah nö e ne pa vöön pamëh, ka nap peo rakah nö vaꞌpeh me ee pee. Ke Batimeus eꞌ a teꞌ kehoꞌ, eꞌ e koaꞌ pe Timeus, eꞌ to ihoꞌ non sinten hanan, pareꞌ hinhin moniꞌ non sih a ma napan. ");
INSERT INTO tpz_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Eꞌ to pënton a napan to sosoe ne a ö ne Ieesuꞌ va Nasarët to nönö non maꞌ pareꞌ taneo en pa hin vakis na pan, “Ieesuꞌ Koaꞌ supnaiꞌ pe Devit, ururuan a neoꞌ ah.” ");
INSERT INTO tpz_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ka ma napan siröꞌ poë, pare soe pan, “Vatotomin ah.” Ivëhkëk, eꞌ to pah kokoeꞌ vakis oah en na pan, “Koaꞌ supnaiꞌ pe Devit, ururuan a neoꞌ ah.” ");
INSERT INTO tpz_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ke Ieesuꞌ sun en, pareꞌ soe pan, “Vaoe na öm eah, keꞌ nö maꞌ manih peöꞌ.” Kee vaoe ee na pe Batimeus a teꞌ kehoꞌ, pare soe ke poë pan, “Sun ah, parën vaeö, pe Ieesuꞌ to vaoe en maꞌ pën.” ");
INSERT INTO tpz_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ke Batimeus vi en po o hop vatonun peꞌ, pareꞌ sun vëvëhöꞌ rakah en, pareꞌ vaveo en manuh pe Ieesuꞌ, ke Ieesuꞌ hi poan pan, ");
INSERT INTO tpz_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","“Eën iu nom ataeah ne eöꞌ se nok manih pën?” Ka teꞌ kehoꞌ pamëh soe pan, “Apuh, eöꞌ to iu opoep hah noꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ke Ieesuꞌ soe ke poan pan, “Eën se nö hah na manuh pa vöön pën, o vaman pën to vatoꞌ hah en pën.” Ka varuꞌ rakah vakomanih no a mataneah to takap hah en, keꞌ ep vavih hah en, ko vatet en pe Ieesuꞌ manih hanan. ");
INSERT INTO tpz_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","E Ieesuꞌ me ra ma vamomhë peꞌ to vatët ee pa tavus manuh Jerusalëm, pa vöön va Bëtfes me Bëtaniꞌ, pare vatët ee sinten a Tope Öliv. Ke Ieesuꞌ vanö vovoh en pa poa vamomhë peꞌ. Kee vos e Bëtfes. ");
INSERT INTO tpz_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","E Ieesuꞌ to vanö me raoe a soe to teꞌ va non manih pan, “Eöm se nö manuh pa vöön to teꞌ vatët non manih. Eöm se tavus pa vöön pamëh, paröm ep ohoꞌ em pa tönkiꞌ sekaꞌ to nohtöön non, no ahikta pah teꞌ to tok avoeꞌ non manih peꞌ. Paröm ihan eah, ko me maꞌ eah manih peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ka ta pah teꞌ se keh hi a neöm pan, ‘Eöm nok suk vamanih ataeah?’ Köm soe keah pan, ‘E Topoan to iu non poan. Eꞌ se vanö ohoꞌ hah en maꞌ peꞌ.’” ");
INSERT INTO tpz_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ka poa vamomhë peꞌ nö ee, pare taum e pa tönkiꞌ sekaꞌ to nohtöön non manih po hopaꞌ in a iuun, pare ihan ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ka ma teꞌ varih to sun vatët ne pa sinten a iuun pamëh hi raoe pan, “Öm ihihan suk nem a tönkiꞌ sekaꞌ vëh ataeah?” ");
INSERT INTO tpz_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kee piun va ee manih pa ö ne Ieesuꞌ to soe va vu ke raoe pon, ka ma teꞌ varih to vaneah ne pa tönkiꞌ vaonöt ke pee pon pa me a tönkiꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ka poa vamomhë pe Ieesuꞌ me e maꞌ pa tönkiꞌ sekaꞌ manih pe Ieesuꞌ, pare pan e pa tonun a tönkiꞌ pa rara, ke Ieesuꞌ peah en pa tönkiꞌ, kee nö me ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ka napan o pöh peo rakah to ihan a ma ohop rërë pee, pare panpan ee manih hanan. Ko upöm moes maꞌ a ma pea naon, pare vahoꞌ ee manih hanan. ");
INSERT INTO tpz_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ka napan varih to vovoh nö ke ne e Ieesuꞌ, me ro teꞌ varih to suksuk nö ne maꞌ poë, ee to tataoa nö ne maꞌ, pare sosoe ne pan, “Vaeö ke na e Sosoenën! E Sosoenën se tapui a oah suk eën to nö maꞌ pa ëhnan e Sunön! ");
INSERT INTO tpz_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","E Sosoenën se tapui a matop vëh to nö maꞌ kuru, Eꞌ a matop pe sipuura Devit! Vaeö rakah, ko kë a ëhnan e Sosoenën!” ");
INSERT INTO tpz_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","E Ieesuꞌ to vos manuh Jerusalëm, pareꞌ ho en koman Iuun Hinhin Apuh, pareꞌ epep vah e non pa ma ta kurus va pa koman a Iuun Hinhin Apuh pamëh, ivëhkëk, a potan to kunah en, keꞌ këh en pa Jerusalëm, pareꞌ nö en manuh Bëtaniꞌ me a havun me ra poa vamomhë peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ka muhin takah en, ke Ieesuꞌ me ra ma vamomhë peꞌ taneꞌ hah ee maꞌ Bëtaniꞌ, pare vovos hah nö ne Jerusalëm, ke Ieesuꞌ haraꞌ en po maë. ");
INSERT INTO tpz_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","E Ieesuꞌ to ep varo en na pa pah vu naon nee to ënëën ne sih a ma voaꞌ i neꞌ, a ëhnaneah o fik no a uvineah to kupkup non poan. Ivëh, ke Ieesuꞌ nö en pa ep, pan eꞌ se ep këh to voaꞌ, ko ëën. Ivëhkëk, eꞌ to nö vatët pareꞌ ep in o uvin naon varoe, suk ataeah, eꞌ to hikta teꞌ non pan o poen voaꞌ po naon pamëh. ");
INSERT INTO tpz_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ivëh, ne Ieesuꞌ to soe suk ke a vu naon ënëën pamëh pan, “Ahikta teꞌ to se ëën taneꞌ hah non to voaꞌ naon manih pën” A ma vamomhë peꞌ to tënan e ne pa soe pamëh. ");
INSERT INTO tpz_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ee to nö ko vos hah e manuh Jerusalëm, ke Ieesuꞌ ho en pa Iuun Hinhin Apuh, pareꞌ taneo en pa veo tavus a napan varih to vavavoen ne a ma tah pee. Eꞌ to koep en pa pok pa nap papanih moniꞌ, pareꞌ koep en pa ma ö ihihoꞌ po teꞌ varih to vavavoen ne o panuh. ");
INSERT INTO tpz_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ivëh, keꞌ soepip raoe, pareꞌ soe pan, “Eöm se nat nem teꞌ koe hah ke maꞌ ta ma tah manih pa ö mahën va pa sinten Iuun Hinhin Apuh.” ");
INSERT INTO tpz_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ke Ieesuꞌ vavaasis non raoe, pareꞌ soe pan, “Manih po Puk Vapenpen no a teꞌ vanënën soe e Aisaëaꞌ to kiun voh, to soe va non manih pan, ‘A iuun peöꞌ eꞌ a iuun hinhin pa napan kurus.’ Ivëhkëk, eöm to rih eah, ko nok em peꞌ, “A ö vavakoaan po teꞌ kakaveo.” ");
INSERT INTO tpz_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","O teꞌ susunön ësës heꞌ, me ro o teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, to pënton a ma tah ne Ieesuꞌ to nonok non pare taneo ee pa vaiu këh ta hanan ne se ip vamët koe e Ieesuꞌ. Ee to nanaöp e ne pe Ieesuꞌ, suk a nap peo to iu e ne pa ma vavaasis peꞌ to teꞌ me non o kikis. ");
INSERT INTO tpz_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pa matanpoen ne Ieesuꞌ me a ma vamomhë peꞌ to këh ee pa Jerusalëm, pare nö ee. ");
INSERT INTO tpz_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pa pöstakah rakah ne Ieesuꞌ me ra ma vamomhë peꞌ to oꞌoah nö ne, pare ep hah ee pa vu fik pamëh. Eꞌ to rak taneꞌ maꞌ manuh pa uvineah, ko öök e non maꞌ pa ma aan. ");
INSERT INTO tpz_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","E Pitaꞌ to koman hah na a soe vaꞌih ne Ieesuꞌ to soe a teꞌ vavoh in a vu naon pamëh, ivëh, keꞌ soe ke Ieesuꞌ pan, “Ep këk ah, Apuh, po naon vëh nën to siröꞌ ateꞌ na nopoen to rak en.” ");
INSERT INTO tpz_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","24","Ivëh, ke Ieesuꞌ soe ke ra ma vamomhë peꞌ pan, “Ta pah teꞌ se keh teꞌ rakah me non o vaman manih pe Sosoenën, pareꞌ taꞌ a tope vëh pan, ‘Sun ah, parën vi kunah koman hah keoꞌ manuh koman tahiꞌ.’ Ivëh, ka teꞌ pamëh se keh teꞌ kikis rakah non po vaman me a hin, pareꞌ nat non susunë non po kokoman peꞌ. Eꞌ se keh hinhin suk non ta pah tah, pareꞌ vaman rakah non manih pa hin peꞌ, a, e Sosoenën se heꞌ en peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Eöm se keh sun pa hin, paröm koman a hat no a meh teꞌ to nok manih peöm, eöm se ihan anoe këh eah pa hat pamëh. Ivëh, ke Tamëneöm vöh pa vöön va kin se ihan anoe me en pa ma teꞌ hat peöm. ");
INSERT INTO tpz_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Eöm se keh hikta ihan anoe a ma hat po upöm teꞌ, e Tamëneöm vöh pa vöön va kin eꞌ me se hikta ihan anoe non a ma teꞌ hat peöm.” ");
INSERT INTO tpz_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","E Ieesuꞌ me ra ma vamomhë peꞌ to hah ee manuh Jerusalëm, ke Ieesuꞌ ho ko nönö vah non koman a Iuun Hinhin Apuh, ko teꞌ susunön ësës heꞌ, me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, me ro teꞌ susunön po Jiuꞌ to nö ee maꞌ manih pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Pare hi poë pan, “A tasun taeah nën to teꞌ me nom, parën nonok nom a ma kiu varih? Eteh to heꞌ a oah a tasun pamëh?” ");
INSERT INTO tpz_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “Eöꞌ me se hi voh a neöm a siꞌ pah hi ro, ke eöm se keh heꞌ em peöꞌ pa piun, eöꞌ me se soe tavus keoꞌ peöm pa tasun nöꞌ to teꞌ me noꞌ, paröꞌ nonok noꞌ a ma kiu apaꞌpuh varih. ");
INSERT INTO tpz_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Soe voh ka neoꞌ öm, a tasun vëh pa pupui a napan ne Jon Tövapupui to heꞌ voh, taneꞌ maꞌ pe Sosoenën, keꞌ, eꞌ taneꞌ maꞌ manih pa napan ah?” ");
INSERT INTO tpz_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ko teꞌ susunön ësës heꞌ, me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, me ro teꞌ susunön po Jiuꞌ to vavasoe koman e ne pan, “Ea se poꞌ soe ataeah, ea se keh soe pan eꞌ to taneꞌ maꞌ manuh pe Sosoenën, keꞌ soe en pan, ‘Vahvapoꞌnih ka hikta vaman no e Jon?’ ");
INSERT INTO tpz_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ke ea se keh soe pan, o kikis pamëh to taneꞌ maꞌ pa teꞌ, a, a soe pamëh hikta antoen non, suk ataeah, a napan kurus to vaman e ne pe Jon a teꞌ vanënën soe.” ");
INSERT INTO tpz_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ivëh, kee piun e Ieesuꞌ, pare soe pan, “Emöm to hikta nat nem.” Ke Ieesuꞌ soe ke raoe pan, “Eöꞌ me to hikta se soe tavus ka noꞌ neöm a tasun ne eöꞌ to teꞌ me noꞌ, ko nonok noꞌ a ma kiu varih.” ");
INSERT INTO tpz_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ke Ieesuꞌ vavaato avoeꞌ e non, pareꞌ nok a soe vapipinoꞌ to soe suk non a ö no a ma upöm teꞌ susunön po Jiuꞌ, me a ö no a napan to mimiröꞌ vavoh ne o teꞌ vanënën soe, pareꞌ soe pan, “A pah teꞌ to nep voh a nep voaën peꞌ, pareꞌ eean tavi poan, ko een a koveꞌ, pareꞌ vasun a nöhsun pa koman koveꞌ, marën a nus o hun voaën manih pa nöh pamëh, ko u a tanu vakin marën a ö no a teꞌ se ihoꞌ non, pareꞌ ut non pa nep voaën peꞌ. Pareꞌ heꞌ en pa nep voaën peꞌ manih po upöm teꞌ, kee kiu moniꞌ e ne manih peꞌ, eꞌ heh nö varo en pa meh muhin. ");
INSERT INTO tpz_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ko poen no a voaꞌ in a voaën to manot en, ke tövaneah pa rak voaën vanö en maꞌ pa teꞌ kikiu peꞌ pan, eꞌ se nö manuh po teꞌ varih to matop ne sih pa rak peꞌ. Eꞌ to iu non pan, ee se heꞌ na poë ta ma teꞌ voaꞌ voaën va pa rak pamëh. ");
INSERT INTO tpz_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ivëhkëk, a napan varuh to matop ne sih pa rak voaën pamëh, to öt a teꞌ pamëh pare pah ip vahat ee peꞌ, ko vanö akuk hah ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ivëh, ke tövaneah pa rak vanö en maꞌ pa meh teꞌ kikiu peꞌ manih pa napan varih to matop ne sih pa nep voaën peꞌ, kee öt poë, pare navuh hokoꞌ ee pa pasuneah, ko pah ip vapoet ee peꞌ, ko vanö akuk hah ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ke tövaneah pa rak voaën vanö hah en maꞌ pa meh teꞌ kikiu peꞌ, kee öt poë, pare ip vamët ee peꞌ, keꞌ mët en. Vasuksuk poꞌ neꞌ to vanö kurus en maꞌ pa nap kiu peꞌ, kee nö ee maꞌ. Ka napan varih to matop ne sih pa nep voaën ip vamët ee pa ma upöm, ee he rëp ee pa ma meh. ");
INSERT INTO tpz_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ke tövaneah pa rak teꞌ varoe me ko non a paeh a teꞌ ro neꞌ se vanö, eꞌ e koaꞌ koman rakah peꞌ, neꞌ to iu oah non sih poan. Eꞌ to vanö en peꞌ manuh pa napan varih to matop ne sih pa rak voaën peꞌ. Suk ataeah, e voe to koman non pan a napan se ta e ne pe sunaiꞌeah. ");
INSERT INTO tpz_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ivëhkëk, a napan varih to matop ne pa nep voaën to vavaasoe koman e ne pan, ‘Ivaꞌih e koaꞌ koman pe tövaneah pa rak voaën, ep öm, ka ip vamët ee peꞌ, ka ma tah varih to vaneah non pe tamaneah, sih vaneah varuꞌ e non manih pea.’ ");
INSERT INTO tpz_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ivëh, kee not poë, ko ip vamët ee peꞌ, pare vi tavus ee na peꞌ pa sinten a rak voaën pamëh.” ");
INSERT INTO tpz_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ke Ieesuꞌ hi en po teꞌ susun po Jiuꞌ, pareꞌ soe pan, “E tövaneah pa rak voaën se poꞌ nok vahvanih? Eꞌ se pöꞌ nö maꞌ, pareꞌ ip vamët a napan varih to matop ne pa rak, pareꞌ heꞌ varuꞌ en po upöm teꞌ ha? ");
INSERT INTO tpz_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Eöm to hikta ëh pöꞌ voh a soe vaꞌih to kiun non po Puk pe Sosoenën to soe suk voh non e Kristo, pareꞌ soe non pan, ‘A vös vaꞌih no a nap ekeok to vi tavus in, to tavus en a vös vamomoaan vëh to toon vakis non a iuun. ");
INSERT INTO tpz_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","E Sunön to nok a vös pamëh, keꞌ tavus en o toon to toon vakis non a iuun, pareꞌ paraꞌ ep vamanin manih pa mataara.’” ");
INSERT INTO tpz_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ka nap susunön po Jiuꞌ kehkeh öt e ne pe Ieesuꞌ. Suk ataeah, ee to nat e ne pe Ieesuꞌ to sosoe vapipinoꞌ suk e non pee. Ivëhkëk, ee to nanaöp e ne pa napan. Ivëhpëhkëk a nap susunön to vakëkëh ee pe Ieesuꞌ, pare vanönö ee. ");
INSERT INTO tpz_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ka ma nap susunön po Jiuꞌ vanö ee maꞌ po Parësiꞌ, me ro upöm va po kum teꞌ pe Hëërot, kee nö ee maꞌ manih pe Ieesuꞌ pa punöꞌ poë pa vaato. ");
INSERT INTO tpz_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ka nap susunön po Jiuꞌ, me a kën poan e Hëërot to nö maꞌ manih pe Ieesuꞌ, pare soe ke poë pan, “Apuh, eën a teꞌ pëpënton soe rakah, parën sosoe man, parën hikta nat nom pa koman varoe ta pah teꞌ, ko hikta nat nom pa soe ta pah soe manih pa teꞌ hikto ëhnan, me a teꞌ to teꞌ me non o ëhnan. Ahik. Manih pa soe man varoe sih nën to vavaasis nom a napan a soe man pe Sosoenën, eën koman vanom nih? Eꞌ vih kës e non pea pa heꞌ a takis manih pe Sisaꞌ, keꞌ a hik?” ");
INSERT INTO tpz_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ivëhkëk, e Ieesuꞌ to nat en po piuk pee, pareꞌ soe ke raoe pan, “Eöm pupunöꞌ a no neoꞌ, suk ataeah? Teꞌ maꞌ öm ta pah moniꞌ manih peöꞌ paröm vataare voh a neoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kee teꞌ ke maꞌ peꞌ po pöh voaꞌ moniꞌ, pare heꞌ ee peꞌ, keꞌ hi en pee pan, “A ëhnan me o kahoꞌ peteh ivëh to teꞌ non pa moniꞌ vëh?” Kee piun e Ieesuꞌ, pare soe pan, “Pe Sisaꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ke Ieesuꞌ piun a soe pee, pareꞌ soe pan, “A tah to vaneah non pe Sisaꞌ nöm se heꞌ e Sisaꞌ. Ka tah to vaneah non pe Sosoenën nöm se heꞌ e Sosoenën.” Kee pah töhkak vahat ee, suk e Ieesuꞌ to vaniu këh en pa punöꞌ pee. ");
INSERT INTO tpz_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ko Sëdiusi, ee o kum teꞌ to hikta vaman ne pan a nap mët se sun taneꞌ hah ee manih po vapeepe, to nö ee maꞌ manih pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Pare soe ee pan, “Apuh, e Mosës to kiun voh ka ra a soe to soe non pan, ‘Ta pah teꞌ se keh mët akuk eꞌ hikta vatvus ta pah koaꞌ manih pe köövo peꞌ, ke kea peꞌ me hah e köövo amop peꞌ, pareꞌ vatvus a koaꞌ se kon a ëhnan e kea peꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Eꞌ to teꞌ non a kën tom mahin to onöt ne a tönim me ra pöök, ka teꞌ a vamomoaan vaen en, pareꞌ teꞌ non ko mët akuk en, eꞌ he hikta vatvus avoeꞌ non ta koaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ke vapöök kea peꞌ me pet en pe köövo pamëh, pareꞌ mët en, eꞌ he hikta vatvus ta pah koaꞌ, ka vakön nok pet va en nën. ");
INSERT INTO tpz_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ka tönim me ra pöök kën tom mahin poë varih vameeme petpet voh e ne pa pah köövo pamëh, pare hikta vatvus ta pah koaꞌ. Ko poen nee to mët vahik ee, ko vasuksuk rakah ne köövo to mët pet en. ");
INSERT INTO tpz_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ivëh, ka amot rakah no a nap mët se sun hah ee, ko poen pamëh ne köövo pamëh se teꞌ rakah non e köövo peteh? Eën to nat e nom, peꞌ to me voh non a tönim me ra poa teꞌ, pareꞌ teꞌ voh e non e köövo manot pee.” ");
INSERT INTO tpz_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ke Ieesuꞌ soe ke ro Sëdiusi pan, “Eöm o teꞌ o nun rakah to hikta nat vavih nem pa soe va po Puk Vapenpen, paröm hikta nat me nem o kikis pe Sosoenën, ivëh köm vavaato pinpiun e nem. ");
INSERT INTO tpz_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Manih po poen no nap mët se sun taneꞌ hah maꞌ manih po vapeepe, a napan kurus hikta se vavaen hah ne, eꞌe se teꞌ va e ne manih po ankeroꞌ va pa vöön va kin. ");
INSERT INTO tpz_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ivëhkëk, manih pa soe va pa mët me a sun hah, eöm to hikta ëh pöꞌ voh a soe pe Sosoenën ne Mosës to kiun voh, o vahutët va po siꞌ naon soneꞌ to ës voh. Manih po vahutët pamëh ne Sosoenën to soe ke Mosës pan, ‘Eöꞌ e Sosoenën pe Abraham, me eöꞌ e Sosoenën pe Aësak, me eöꞌ e Sosoenën pe Jekop.’ ");
INSERT INTO tpz_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","E Sosoenën to hikta teꞌ non pan e Sosoenën pa nap mët. Ahik. Eꞌ e Sosoenën pa nap toꞌtoꞌ. A soe peöm a nun.” ");
INSERT INTO tpz_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","A pah teꞌ vavaasis to nat i non o Vavaasis pe Mosës to nö maꞌ, pareꞌ pënton raoe to vavaato vasukaꞌ ne, pareꞌ pënton en pe Ieesuꞌ to pinpiun vavih rakah e non pa ma soe po Sëdiusi, ivëh, keꞌ hi en pe Ieesuꞌ pan, “A taateꞌ taeah to teꞌ oah non a ma meh taateꞌ, pareꞌ vih oah non?” ");
INSERT INTO tpz_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ke Ieesuꞌ piun a soe peꞌ pareꞌ soe pan, “Ivaꞌih a taateꞌ vamomoaan. ‘Eöm varih a napan va Israël, eöm se pënton. E Sunön Sosoenën pea a paeh apuh ro.’ ");
INSERT INTO tpz_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","‘Eöm se iu rakah nem e Sunön e Sosoenën peöm manih pa ma kupu peöm, me manih pa ma apeneöm, me manih pa ma kokoman peöm, me manih pa ma kikis kurus rakah peöm.’” ");
INSERT INTO tpz_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","“Ka vapöök taateꞌ to teꞌ va non manih, ‘Eën se iu nom a meh teꞌ vamanih pa ö ne eën to iu hah va ka nom.’” “Ahikta meh taateꞌ to teꞌ apuh non, pareꞌ teꞌ oah non a poa taateꞌ varih.” ");
INSERT INTO tpz_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ka teꞌ vëh to nat non sih pa taateꞌ, soe va in e Ieesuꞌ manih pan, “Apuh! A soe pën a man rakah. E Sosoenën, eꞌ a paeh Apuh ro, a hikta meh. ");
INSERT INTO tpz_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ea se iu rakah no e Sosoenën manih pa ma kupu pea, me manih pa ma nat pea, me manih pa ma kikis kurus pea. Para iu va i no upöm teꞌ vamanih pa ö ne ea to iu hah va ka no. Ea se vavatet rakah no a poa taateꞌ apuh poë varih. E Sosoenën to iu rakah e non pee, suk ee to apuh oah rakah e ne pa ma heꞌ varih nee to ësës voh ke ne na e Sosoenën po suraꞌ. A poa taateꞌ poë varih to apuh oah e ne pa ma vu heꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","E Ieesuꞌ to pënton a teꞌ pamëh to pinpiun vavih e non pa soe peꞌ, vamanih pa teꞌ to teꞌ rakah me non o nat vih, ivëh ke Ieesuꞌ soe ke poan pan, “Eën to hikta teꞌ varo këh nom a Matop Vih pe Sosoenën, a siꞌ ö hat kën vaman a neoꞌ, ko hop eom maꞌ manih pa Matop Vih pe Sosoenën.” Ka ma upöm teꞌ naöp ee pa hi hah e Ieesuꞌ ta ma meh hi. ");
INSERT INTO tpz_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","O poen ne Ieesuꞌ to vavaasis non koman Iuun Hinhin Apuh, pareꞌ hi a napan a hi, pareꞌ soe pan, “Vahvanih ko teꞌ vavaasis to nat i ne o Vavaasis pe Mosës sosoe ne sih pan, e Kristo, eꞌ e koaꞌ pe Devit? ");
INSERT INTO tpz_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","A Tuvuh Vasioꞌ to heꞌ e Devit o kokoman, keꞌ soe vamanih pan, ‘E Sosoenën to soe ke Devit pan, “E Kristo e Sunön pën.” ‘Ke Sosoenën sosoe avoeꞌ ke non pe Kristo pan,’ “Ihoꞌ ah manih pa papmatö peöꞌ, ko teꞌ nom nën keꞌ onöt po poen nöꞌ se vahoꞌ o teꞌ varih to vakihat me a nom oah manih paan a matop pën.’” ");
INSERT INTO tpz_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Moaan voh e Devit koman to soe pan, ‘E Kristo e Sunön peöꞌ.’ E Kristo hikta teꞌ varoe non pan e koaꞌ pe Devit. Ahik. Eꞌ to teꞌ me va i non manih pe Sunön rakah pe Devit.” ");
INSERT INTO tpz_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","E Ieesuꞌ to vavaasis avoeꞌ e non pa napan, pareꞌ soe pan, “Eöm se matop rakah nem pa napan varih to matop ne sih pa taateꞌ, eꞌe to manin rakah nee a ö ne se ohop ne a ma ohop rëërë, pare nönö vah ne, ko iu rakah ne a napan se vaeö me ne raoe, pare ta ne raoe manih pa ma ö totoaan. ");
INSERT INTO tpz_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Pare iu rakah ne a ihoꞌ pa ma ö ihihoꞌ po teꞌ susunön manih pa ma koman iuun hinhin soneꞌ. Ee to iu suntan rakah ne sih a ihoꞌ vovoh pa ma taëën apaꞌpuh. ");
INSERT INTO tpz_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ee to vavakëën ne sih o köövo amop, pare kakaveo ne a ma moeh tah pee. Pare pikpiuk hah a ne pa nok a ma hin rë. Manih po poen nee se teꞌ po vahutët, a pap napan poë varih se kon o kamis o pöh apuh oah rakah.” ");
INSERT INTO tpz_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","E Ieesuꞌ to ihoꞌ vatët non manih pa pokis vavahoꞌ moniꞌ va pa Iuun Hinhin Apuh, pareꞌ ut non a napan to vavahoꞌ ne a ma moniꞌ pee manih pa pokis, a teꞌ öt ö to vahoꞌ a ma moniꞌ peo. ");
INSERT INTO tpz_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ka pah köövo amop arus nö maꞌ, pareꞌ vahoꞌ o siꞌ pöök voaꞌ moniꞌ to matan va ne manih pa poa toeaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ke Ieesuꞌ vaoe ununun a ma vamomhë peꞌ, pareꞌ soe ke raoe pan, “Eöꞌ to soe vamaman rakah keoꞌ peöm, e köövo amop arus vëh to vahoꞌ a moniꞌ to apuh oah e non pa ma moniꞌ no a napan to vavahoꞌ ne manih pa pokis moniꞌ va pa Iuun Hinhin Apuh, manih po epep pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ka napan varih to teꞌ me ne a ma moniꞌ peo, to vahoꞌ ro a ma paeh manih pa ö vavahoꞌ moniꞌ. Ivëhkëk, e siꞌ köövo vëh to kökööt rakah non pa moniꞌ to vahoꞌ vahik en pa siꞌ moniꞌ peꞌ, pareꞌ hikta teꞌ hah me non ta meh marën a voen a taëën.” ");
INSERT INTO tpz_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","E Ieesuꞌ me a ma vamomhë peꞌ to këh ee pa Iuun Hinhin Apuh, ka pah vamomhë peꞌ soe ke poan pan, “Ep këk na! Apuh, po iuun vihvih varuh nee to eok voh po vös ep vavih.” ");
INSERT INTO tpz_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ke Ieesuꞌ piun a soe peꞌ, pareꞌ soe vamanih pan, “Eën to ep me e nom na pa ma iuun apaꞌpuh varuh, ha? Ahikta pah vös to onöt non a tok pa tonun a meh. Ahik. Eꞌe se taru kunah kurus ee maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","E Ieesuꞌ to ihoꞌ non manuh pa Tope Öliv, pareꞌ ep non na a Iuun Hinhin Apuh va Jerusalëm to teꞌ non maꞌ manuh. E Pitaꞌ, ke Jëmis, ke Jon, ke Ëndruꞌ, ee varoe a taanaꞌ vamomhë to nö maꞌ manih pe Ieesuꞌ, pare hi poë pan, ");
INSERT INTO tpz_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Soe ka möm ah, o poen poanheh no a ma tah poë varih se tavus. Me o vëknöm taeoh se tavus momoaan maꞌ, kemöm se ep, pamöm nat a ma tah poë varih se tavus maꞌ?” ");
INSERT INTO tpz_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ke Ieesuꞌ piun a soe pee, pareꞌ soe ke rapoë pan, “Matop vavih nem, ta pah teꞌ tomeꞌ piuk ka neöm. ");
INSERT INTO tpz_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","A nap peo rakah se nö maꞌ, pare popokaꞌ ne a ëhnaneoꞌ, pare soe va ee manih pan, ‘Eöꞌ ivëh a teꞌ pamëh’, pare piuk ee pa napan. ");
INSERT INTO tpz_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Paröm koe a naöp pa ö ne eöm se pënton a ma paarak va pa ma vapus apuh, me eöm se keh pënton ta ma vaato vanövan va pa ma vapus apaꞌpuh to tavus manuh pa ma meh muhin. A, eöm se nat nem töhkak vahat, suk ataeah, a ma tah poë varih se tavus ee maꞌ. Ivëhkëk, o poen no oeh vëh se hik to meꞌ e non pa tavus maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","A napan va pa pah muhin se sun, pare vapus me ee pa napan va pa meh muhin. Ka matop vih pa pah teꞌ sunön se sun, pareꞌ vapus me en pa teꞌ matop vih pa meh teꞌ sunön. A rikrik se kö pa ma meh muhin, ko maë apuh tavus en. A ma tah poë varih se tavus momoaan vamanih pa ö ne köövo to haraꞌ o kamis va pa ö neꞌ to kehkeh vahuh non. ");
INSERT INTO tpz_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Eöm koman se matop vavih nem, a napan se öt a neöm, ko vahoꞌ ee peöm po vahutët, ko ip ee peöm manih koman a ma iuun hinhin soneꞌ pee. Eöm se sun em po vahutët matëëro teꞌ apaꞌpuh va pa kaman, me ro teꞌ susunön. Suk eöm to vaman, paröm vavatet a nem neoꞌ, paröm vatvus a Soe Vih peöꞌ manih pee. ");
INSERT INTO tpz_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","A ma napan kurus va po oeh vëh se pënton a teꞌ vëh to vatvus momoaan voh a Soe Vih peöꞌ. Ka amot no a ma tah poë varih se tavus poꞌ maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ee se vateꞌ e peöm po vahutët, suk a ö ne eöm to vaman a no neoꞌ. Eöm se nat nem nanaöp nem, paröm koe a karë vovoh ataeah nom se soe. Ahik. A ma soe kurus ne Sosoenën se heꞌ vëhöꞌ rakah en peöm, köm soe tavus em. Suk ataeah, eꞌ to hikta teꞌ non pan, eöm koman ivarih se vavatvus nem a ma soe poë varih. Ahik. A Tuvuh Vasioꞌ ivëh se vatvus a soe pamëh. ");
INSERT INTO tpz_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","O teꞌ se heꞌ mët ee pa ma kea pee manih pa nap hat, kee ip vamët ee pee. Ka kën taman se nok va ee nën manih pa ma koaꞌ pee. Ka ma koaꞌ pee se hat ke ne pa ma tamëëre me ra ma sinëëre, pare ip vamët ee pee. ");
INSERT INTO tpz_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","A napan se heve ov e ne peöm, suk eöm to vaman, paröm vavatet a nem neoꞌ. Ivëhkëk, o teꞌ varih to teꞌ vakis ne pa teꞌ a ma punis, pare öök na po poen no o oeh se hik, e Sosoenën se hehe en pee. ");
INSERT INTO tpz_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pet en pan, “Eöm se ep a Tah A Pah Hat rakah to sun non pa iuun pe Sosoenën.” Ka teꞌ to ëhëh non a soe, eꞌ se maaka vavih rakah non a pusun in a soe pamëh. Ivëh, ka napan varih to teꞌ ne manih pa muhin va Jiutiaꞌ ee se rusin ee manuh pa moeh totope. ");
INSERT INTO tpz_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ka teꞌ vëh to tok non tonun a iuun peꞌ, eꞌ to hikta onöt non a kunah maꞌ, ko ho koman iuun peꞌ, pareꞌ kokon maꞌ a ma tah peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ka teꞌ vëh to teꞌ non pa rak peꞌ, eꞌ to hikta onöt non a tapiun vos hah iuun pa kon ohop rë peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Varenan rakah po köövo kikiuk, me ro köövo varih to vasisiꞌ ne o koaꞌ sosoneꞌ manih po poen pamëh. ");
INSERT INTO tpz_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Eöm se hinhin vakis nem manuh pe Sosoenën, ka tah pamëh sih nat non tavus pa tëëm tuvuh. ");
INSERT INTO tpz_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Suk manih po poen pamëh a punis apuh rakah se tavus. Taneo non po poen ne Sosoenën to nok a ma moeh tah kurus, pareꞌ öök non maꞌ manih kuru, o vu punis to matan va non manih to hikta tavus avoeꞌ voh non. Pareꞌ hikta se tavus amot non. ");
INSERT INTO tpz_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ivëhkëk, e Sunön se keh hikta vakökööt voh a ma poen va pa ma punis poë varih, a napan kurus se ro vahik voh ee. Ivëhkëk, e Sosoenën to koman non a napan varih to vaman ne e Ieesuꞌ, neꞌ to vateꞌ voh, ivëh, neꞌ to vakökööt suk voh pa ma poen poë varih. ");
INSERT INTO tpz_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ivëh, ko poen pamëh no ta pah teꞌ se keh soe ka neöm pan, ‘Ep öm, eꞌ e Kristo, eꞌ ivëh to teꞌ non manih! Keꞌ, ep öm eꞌ ivöh to teꞌ non manuh.’ Koe rakah a vaman eah. ");
INSERT INTO tpz_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","O Kristo vapikpiuk, me ro teꞌ vanënën soe vapikpiuk se tavus maꞌ, pare vatvus a ma kiu apaꞌpuh me a ma tah vatoksean. Ee to hikta onöt ne a nok a ma tah poë varih manih pa napan ne Sosoenën to soe a ö neꞌ se kon hah raoe. Ee se piuk vahok ee pa napan. ");
INSERT INTO tpz_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ivëh, köm se matop vavih nem, eöꞌ to kömköm vovoh voh eoꞌ peöm pa ma punis poë varih se tavus amot ee maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ivëhkëk, a ma hat poë varih se hik ee, ‘A potan se popoen, ka sivö hikta se paapa non. ");
INSERT INTO tpz_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","O vesun se vuꞌvuꞌ taneꞌ ee maꞌ akis. Ko kikis vöh akis se panih, ko takö ee.’” ");
INSERT INTO tpz_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ko poen pamëh no a napan se ep a neoꞌ E Koaꞌ Teꞌ Pa Napan Kurus se nö me maꞌ o maaka me o kikis apuh manih pa koman a unöh. ");
INSERT INTO tpz_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Eöꞌ se vanö maꞌ o ankeroꞌ peöꞌ, kee nö maꞌ, pareꞌ ununun a ma napan varih neꞌ to kon voh vamanih pa ma teꞌ peꞌ. Eꞌ se ununun taneꞌ maꞌ raoe manuh po taanaꞌ ö noton in a ö no akis me o oeh to aton ne. ");
INSERT INTO tpz_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pet en pan, “Eöm se kon taneꞌ o vavaasis manih po naon fik. A ma pean se keh koos maꞌ, pare pau vavoon hah maꞌ, a, köm nat em po poen no a potan se pa, to taneo en. ");
INSERT INTO tpz_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Keꞌ teꞌ akuk va kov e non manih pan, o poen ne eöm se ep in a ma tah poë varih se tavus, eöm se nat em o poen hah peöꞌ e Koaꞌ Teꞌ Pa Napan Kurus to öök vatët en maꞌ manih po hopaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Eöꞌ to soe vaman rakah ka neöm. A ma napan va kuru to hikta se mët vahik ne, ka ma tah poë varih se tavus ee maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","A akis me o oeh se hik ee, ivëhkëk, a soe peöꞌ to hikta se hik non, eꞌ se teꞌ tamoaan e non.” ");
INSERT INTO tpz_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ivëh, ka hikta pah teꞌ to nat non, po poen me a aoaꞌ ne eöꞌ to sosoe suk noꞌ. O ankeroꞌ va pa vöön va kin, me eöꞌ e koaꞌ pe Sosoenën, emöm to hikta nat nem po poen ne eöꞌ se hah maꞌ, e Tamön varoe to nat non. ");
INSERT INTO tpz_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Eöm se teꞌ vamatop nem, suk ataeah, eöm to hikta nat nem po poen me a aoaꞌ poanheh ne eöꞌ e Sunön peöm Ieesuꞌ Kristo se hah maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Eꞌ se teꞌ va e non manih pa pah teꞌ to këh a vöön peꞌ, ko nö varo en pa vavih. Eꞌ to këh a ma teꞌ kikiu peꞌ to matop ne a ma tah peꞌ. Pareꞌ ki vakëkëh ken pee pa ma kiu, ko soe ke a teꞌ vëh to ut non po hopaꞌ, pan eꞌ se ut vavih non, suk eꞌ se hah en maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Ivëh, köm se ut vavih nem, ko teꞌ vamatop nem, suk eöm to hikta nat nem po poen poanheh ne eöꞌ se hah maꞌ vamanih pa ö ne tövaneah pa iuun se hah va maꞌ. Eöꞌ tomeꞌ nö eoꞌ maꞌ pa popoen, keꞌ pa topnin poen, keꞌ pa tö pe toaꞌ, keꞌ pa pöstakah, eöm to hikta nat nem. ");
INSERT INTO tpz_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Eꞌ to hat non, peöꞌ tomeꞌ vëvëhöꞌ hah maꞌ, ko vöhkak a neöm to koroh avoeꞌ e nem. ");
INSERT INTO tpz_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","A soe vaꞌih ne eöꞌ to soe ka neöm, eöꞌ to soe kurus rakah keoꞌ peöm a napan, pan eöm se teꞌ vamatop nem, ko ut vavih nem.” ");
INSERT INTO tpz_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","O pöök poen to meꞌ avoeꞌ e ne ko Poen Vapenpen va pa Taëën Hikto Is, me o poen va pa Taëën Apuh eꞌ o Pasovaꞌ se tavus en. O teꞌ susunön ësës heꞌ, me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës to vavaiu vah këh e ne ta hanan nee se öt vakoaan vah va in e Ieesuꞌ, pare ip vamët poë. ");
INSERT INTO tpz_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ee to soe pan, “Ea se nat no nok vamanih, eꞌ hikta teꞌ vih non pa ö ne ea se öt e Ieesuꞌ manih komön a ma poen va po Pasovaꞌ pa ö ne ea to vatötönun no pa Taëën Apuh pamëh. Suk ataeah, a nap peo varih tomeꞌ ep a tah na to nok, pare kunkuin ee po to vapus, ko vapus me ee pea.” ");
INSERT INTO tpz_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","E Ieesuꞌ to nö en manuh pa vöön va Bëtaniꞌ, pareꞌ tavus en pa iuun pe Saëmon, e Saëmon pamëh to teꞌ me voh non a mët vëh a töpaꞌ. E Ieesuꞌ to ënëën vaꞌpeh me non o upöm teꞌ, ka köövo teꞌ maꞌ o vanom o pöh voen vaꞌpuh rakah, pareꞌ teꞌ non po puto nee to nok voh pa vös nee to popokaꞌ ne a arapasta, e köövo to kon o vanom, pareꞌ puit ko koꞌkoꞌ en peꞌ manih pa pasun e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Eꞌ to nok vamanih marën a vasunön e Ieesuꞌ. Ivëhkëk, o upöm teꞌ to teꞌ ne nën to ep a tah vaꞌih, pare pah heve ee, ko vavasoe koman e ne pan, “Vahvanih ke köövo koꞌ vakit akuk o vanom vëh? ");
INSERT INTO tpz_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Eꞌ to vih non pea se vavoen o vanom pamëh, para kon a 300 voaꞌ moniꞌ, para heꞌ a moniꞌ pamëh manih pa nap arus.” ");
INSERT INTO tpz_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ivëh, ke Ieesuꞌ soe ke raoe pan, “Koe öm eah, eöm vatamak suk eah ataeah? Eꞌ to nok vu ka neoꞌ a tah to parin a vih vörep. ");
INSERT INTO tpz_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","A ma tamoaan no teꞌ arus se teꞌ vaꞌpeh me e ne peöm, ne eöm se vavaꞌaus tamoaan e nem pee. Ivëhkëk, eöꞌ hikta se teꞌ tamoaan me a noꞌ neöm. ");
INSERT INTO tpz_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","A tah neꞌ to onöt non a nok, neꞌ to nok vahik vur en peꞌ manih peöꞌ, eꞌ to uh a neoꞌ po vanom, to soe va non manih pan, eꞌ to vamatop non a ö nöꞌ se mët, kee pe ee peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Eöꞌ to soe vamaman rakah keoꞌ peöm, manih po oeh avoes no a napan se keh vavatvus ne a Soe Vih pe Sosoenën. Ee se vavasoe suk vaviꞌ e ne pa tah ne köövo vëh to nok manih peöꞌ, ka napan sih koman hah ne poë.” ");
INSERT INTO tpz_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Manih po poen pamëh ne Jiutas Iskariot, eꞌ a paeh va pa havun me ra poa vamomhë pe Ieesuꞌ, to nö en manuh po teꞌ susunön ësës heꞌ. Eꞌ to kehkeh vikuh non e Ieesuꞌ manih pee. ");
INSERT INTO tpz_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","O teꞌ susunön ësës heꞌ, me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, ee to pënton a soe vaꞌih, pare pah vaeö suntan rakah ee. Ko nok ee pa soe vaman pee pa ö nee se heꞌ poë ta ma moniꞌ. Ivëh, ke Jiutas iu vah këh e non ta hanan neꞌ se vikuh vah va in e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","O poen vamomoaan in a Taëën Apuh va pa Taëën Hikto Is va po Pasovaꞌ to tavus en, manih po poen pamëh nee to ipip a ma soneꞌ sipsip ov in a Taëën Apuh va po Pasovaꞌ. Ka ma vamomhë pe Ieesuꞌ hi ee peꞌ pan, “Eën iu nom a ö nemöm se vamatop maꞌ a Taëën Apuh va po Pasovaꞌ nih?” ");
INSERT INTO tpz_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ke Ieesuꞌ vanö en pa poa vamomhë peꞌ, pareꞌ soe ke rapoë pan, “Eöm pom se nö ko vos manuh Jerusalëm, paröm taum a pah teꞌ to teꞌteꞌ nö non a ruen to teꞌ non pa nöh. Eꞌ se vatatan me a neöm, köm vatet eah. ");
INSERT INTO tpz_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Manuh pa iuun neꞌ to ho, eöm soe va in e tövaneah pa iuun pamëh manih pan, ‘E Apuh to ihi no maꞌ oah pan, a piprom poanheh neöꞌ se vaënëën vaꞌpeh me a ma vamomhë peöꞌ a Taëën Apuh va po Pasovaꞌ?’ ");
INSERT INTO tpz_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ka teꞌ pamëh se vataare en peöm pom pa piprom apuh vöh kin to teꞌ me non a pok ënëën, me a ma ö ihihoꞌ to teꞌ vamatop keon e non. Köm vamatop maꞌ a taëën pea manih pa piprom apuh pamëh.” ");
INSERT INTO tpz_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ko vamomhë vos ee manuh Jerusalëm, pare taum ee pa ma tah vamanih pa ö ne Ieesuꞌ to soe a maꞌ, ko vamatop ee pa Taëën Apuh va po Pasovaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","A muhin to matanpoen vahik en, ke Ieesuꞌ nö vaꞌpeh me en maꞌ pa havun me ra poa vamomhë peꞌ. Kee ho ee koman iuun, pare taum e pa piprom nee se ëën a Taëën Apuh va po Pasovaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ee to ihoꞌ ee manih pa ma ö ihihoꞌ, pare ënëën poꞌ e ne, ke Ieesuꞌ soe ke rapoë pan, “Eöꞌ to soe vaman rakah keoꞌ peöm, a paeh koman va peöm varih o vamomhë peöꞌ ivëh se vikuh ka neoꞌ manih pa napan varih to hat ov a no neoꞌ, a teꞌ pamëh to ënëën vaꞌpeh me e non peöꞌ manih.” ");
INSERT INTO tpz_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","A soe vaꞌih to vatamak rakah en pa ma vamomhë peꞌ, kee taneo ee pa hi papaeh poë pan, “Eöꞌ pöꞌ, ha?” ");
INSERT INTO tpz_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ke Ieesuꞌ soe ke rapoë pan, “Eꞌ to teꞌ non a paeh va peöm varih a havun me a poa vamomhë koman peöꞌ. A teꞌ pamëh to se pët vahoꞌ hop vaꞌpeh me a neoꞌ a ö taëën manuh pa koman a tis. ");
INSERT INTO tpz_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Oman, eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus se mët eoꞌ, vamanih pa ö no Puk Vapenpen to soe va non. Ivëhkëk, varenan rakah pa teꞌ vëh to vikuh ka neoꞌ po teꞌ varih to hat ov a no neoꞌ sih. Eꞌ to vih non pa ö no e sinan a teꞌ pamëh se hikta vahuh voh poan.” ");
INSERT INTO tpz_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","O poen nee to ënëën ne, ke Ieesuꞌ kon a ö taëën, pareꞌ hin na e Sosoenën, ko soe vavihvih ke na eah, pareꞌ kök a ö taëën pamëh, ko ki vakëkëh ken po vamomhë peꞌ, pareꞌ soe ke rapoë pan, “Kon öm a ö taëën vëh. A ö taëën vaꞌih eꞌ a sionineoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pareꞌ kon pet en na pa kap voaën, pareꞌ soe vavihvih ke na e Sosoenën, pareꞌ heꞌ raoe, kee kaak kurus taneꞌ ee manih pa kap peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ke Ieesuꞌ soe ke rapoë pan, “Eꞌ ivaꞌih o eraꞌ peöꞌ, o eraꞌ pamëh to vataare non o vatompoan voon, o eraꞌ pamëh se takoꞌ marën a voen hah a neöm a ma napan kurus. ");
INSERT INTO tpz_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Eöꞌ to soe vamaman rakah keoꞌ peöm, eöꞌ to hikta onöt noꞌ a kaak hah o voaën vaꞌih, keꞌ onöt rakah non po poen ne eöꞌ se kaak o voaën voon manuh pa Matop Vih pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kee nok o vaëhëh, ko no ee Tope Öliv. ");
INSERT INTO tpz_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ke Ieesuꞌ soe ke rapoë pan, “Eöm kurus se rusin këh em peöꞌ, suk ataeah, manih pa soe pe Sosoenën, no a teꞌ vanënën soe vëh e Sakarias to kiun vavoh manih pan, ‘E Sosoenën se ip vamët en pa teꞌ utut sipsip, ko sipsip se rusin vakëkëh ee.’ ");
INSERT INTO tpz_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ivëhkëk, eöꞌ se sun taneꞌ hah po vapeepe, paröꞌ vovoh keoꞌ peöm manuh Galiliꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ivëh, ke Pitaꞌ soe ke Ieesuꞌ pan, “Eöꞌ to hikta onöt rakah noꞌ a rusin këh oah vamanih pa ö no upöm vamomhë pën se keh rusin këh oah.” ");
INSERT INTO tpz_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ke Ieesuꞌ soe ke Pitaꞌ pan, “Nös pa popoen e toaꞌ oeteꞌ se meꞌ avoeꞌ e non pa poa tö, eën se kukön soe eom pan, eën to hikta nat nom peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ivëh, ke Pitaꞌ soe vakis en pan, “Oman rakah, eöꞌ hikta onöt rakah noꞌ a soe vamanih pan, ‘Eöꞌ to hikta nat noꞌ pën.’ Eꞌ to onöt e non pa napan se ip vamët ee peöꞌ, köꞌ mët vaꞌpeh me eoꞌ pën.” Ka ma upöm vamomhë peꞌ pët soe va ee nën. ");
INSERT INTO tpz_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ke Ieesuꞌ me ra ma vamomhë peꞌ tavus ee manuh pa ö muhin va Gëtsëmaniꞌ, ke Ieesuꞌ soe ke ra ma vamomhë peꞌ pan, “Ihoꞌ nem manih. Köꞌ nö, ko hin.” ");
INSERT INTO tpz_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ke Ieesuꞌ me en pe Pitaꞌ, ke Jëmis ke Jon, kee nö vaꞌpeh ee, ko kokoman pe Ieesuꞌ punis rakah en. ");
INSERT INTO tpz_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ke Ieesuꞌ soe ke ra kukön vamomhë peꞌ pan, “O kupu peöꞌ to puh rakah non po tamak, köꞌ haraꞌ ke noꞌ pan eöꞌ se mët eoꞌ. Teꞌ nem manih, ko hinhin nem.” ");
INSERT INTO tpz_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Keꞌ nö a siꞌ ö, pareꞌ vuꞌ po oeh, ko hinhin non na e Tamaneah Sosoenën, pareꞌ soe vamanih pan, eꞌ se non iu non, ka punis vëh, oah en peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Eꞌ to hinhin va non manih pan, “Aba, Tamaneoꞌ, a ma tah kurus nën to onöt e nom pa nok, eöꞌ to iu noꞌ a ö ne eën se kon këh a neoꞌ po kamis vëh. Ivëhkëk, Tamön eën se nat nom suk o iu peöꞌ, ahik, eën se vatet varoe o iu koman pën.” ");
INSERT INTO tpz_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ke Ieesuꞌ taneꞌ hah maꞌ pa ö neꞌ to hinhin non, pareꞌ ep in a ma vamomhë peꞌ to koroh, pareꞌ soe ke Pitaꞌ pan, “Saëmon, eën a koroh oh? Eën hikta onöt rakah ko nom a ut pa ta pah aoaꞌ, ha?” ");
INSERT INTO tpz_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Eꞌ to soe ken pa kukön vamomhë peꞌ pan, “Ut nem, paröm hinhin nem, eöm tomeꞌ kuꞌ em pa ö no a punöꞌ se tavus a neöm. O apen to iu e non pa vatet a ma taateꞌ vih, ivëhkëk, o sionin to susunë e non pa vatet.” ");
INSERT INTO tpz_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ke Ieesuꞌ hah en, pareꞌ vapöök hin en. ");
INSERT INTO tpz_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Eꞌ to hah taneꞌ maꞌ pa hin, pareꞌ nö en manuh pa ma vamomhë peꞌ. Pareꞌ taum raoe to koroh ne, suk ee to mët rakah ee po mamaasoe. Ee to hikta nat ne pataeah nee se soe ke Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Vasuksuk poꞌ ne Ieesuꞌ to vakön hah en maꞌ manih pa kukön vamomhë peꞌ, pareꞌ soe ke rapoë pan, “Eöm koroh vavuriah avoeꞌ e nem, ha? Onöt en! Ep këk öm, o poen peöꞌ to tavus en no a napan se heꞌ ee peöꞌ e Koaꞌ Teꞌ Pa Napan Kurus manih pa koreera nap hat. ");
INSERT INTO tpz_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Sun öm, ka nö ee. A teꞌ vëh to vikuh a neoꞌ to nö en maꞌ pa öt a neoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","E Ieesuꞌ to vavaato avoeꞌ e non, ke Jiutas a paeh va pa ma vamomhë peꞌ öök en maꞌ. Eꞌ to me maꞌ a nap peo rakah to pët öt nö ne maꞌ a ma rapis rë, me a ma tanaon. O teꞌ sunön ësës heꞌ, me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, me ra ma teꞌ susunön po Jiuꞌ, to vanö maꞌ raoe. ");
INSERT INTO tpz_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ke Jiutas a teꞌ vëh to vikuh in e Ieesuꞌ pa koreera nap hat, to heꞌ maꞌ o vëknöm manih pa napan pan, “A teꞌ vëh, nöꞌ se keh umaꞌ eah, eꞌ kuru a teꞌ pamëh, söm öt eah.” ");
INSERT INTO tpz_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ke Jiutas öök maꞌ, pareꞌ nö vëvëhöꞌ en manuh pe Ieesuꞌ, pareꞌ soe pan, “Apuh!” Pareꞌ umaꞌ en peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ka nap hat nat ee peꞌ e Ieesuꞌ, ko nö maꞌ, pare öt ee peꞌ, ko nohnoh ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ivëhkëk, e Pitaꞌ a paeh va pa kukön teꞌ varih to sun vatët ne pe Ieesuꞌ to rëh taneꞌ o rapis rë pa ö pepet peꞌ, ko moes kurus en pa tenan a teꞌ kikiu pa Teꞌ Susun po Teꞌ Ësës Heꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ke Ieesuꞌ hi en pee pan, “Eöm nö maꞌ pa öt a neoꞌ, paröm teꞌ em maꞌ pa ma rapis rëërë, me a ma tanaon ke pan eöꞌ a teꞌ kakaveo, toh? ");
INSERT INTO tpz_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","A ma poen kurus ne eöꞌ to teꞌ me voh a noꞌ neöm, paröꞌ vavaasis a noꞌ neöm koman a Iuun Hinhin Apuh, köm hikta öt poꞌ voh a neoꞌ nën, toh? Ivëh, ka soe va po Puk Vapenpen puh en” ");
INSERT INTO tpz_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ka ma vamomhë pe Ieesuꞌ rusin këh ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ka pah teꞌ sekaꞌ to rara non o rara kakaare to suksuk nö non e Ieesuꞌ, kee kehkeh öt ne poë, ivëhkëk, ee to öt varoe ee po rara peꞌ, ");
INSERT INTO tpz_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","keꞌ rusin pehpeah en, ko këh en po rara peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ka nap hat me ee pe Ieesuꞌ manuh pa iuun pa Teꞌ Susun po Teꞌ Ësës Heꞌ, manih pa iuun pamëh no teꞌ susunön ësës heꞌ, me o teꞌ susunön po Jiuꞌ, me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, to teꞌ tönun e ne nën. ");
INSERT INTO tpz_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ke Pitaꞌ suksuk amot nö e non maꞌ pa napan to meeme nö ne e Ieesuꞌ. Eꞌ to nö, pareꞌ teꞌ e non pa havin in a iuun pa Teꞌ Susun po Teꞌ Ësës Heꞌ, pareꞌ ihoꞌ vaꞌpeh me e non po teꞌ utut, ko maꞌkis e non po suraꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ko teꞌ susunön ësës heꞌ, me ro Kum Teꞌ Susunön po Jiuꞌ vaoe ee na pa ma meh teꞌ, kee nö ee maꞌ, pare vavaꞌaus ee pa vatvus a ma tah ne Ieesuꞌ to nok voh. Suk ee to kehkeh taum ne ta hanan nee se ip vamët koe vah va in poë. Ivëhkëk, eꞌe to hikta taum ta pah hat manih pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","A nap peo rakah to pët heꞌ maꞌ a ma vahutët piuk manih pe Ieesuꞌ, ivëhkëk, a ma vahutët pee to hikta teꞌ man ne, pare nun. ");
INSERT INTO tpz_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ka ma upöm teꞌ sun, pare soe a ma soe piuk manih pe Ieesuꞌ, pare soe pan, ");
INSERT INTO tpz_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Emöm to pënton voh nem eah to soe pan, ‘Eöꞌ se miröꞌ eoꞌ pa Iuun Hinhin Apuh vëh no a napan to eok voh pa ma koreere, ko murin in o kukön poen, eöꞌ se eok hah a meh Iuun Hinhin Apuh na to hikta onöt no a eok pa koreera.’” ");
INSERT INTO tpz_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ivëhkëk, a ma vahutët nee to pokaꞌ e Ieesuꞌ to hikta teꞌ man rakah ne. ");
INSERT INTO tpz_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ka Teꞌ Susun po Teꞌ Ësës Heꞌ sun manih pa matëëre kurus pareꞌ hi e Ieesuꞌ pan, “Eën hikta pinpiun suk nom a ma soe varih ataeah no a napan to popokaꞌ a nom oah?” ");
INSERT INTO tpz_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ivëhkëk, e Ieesuꞌ to teꞌ vasup e non, pareꞌ hikta soe ta pah tah. Ka Teꞌ Susun po Teꞌ Ësës Heꞌ hi hah en peꞌ pan, “Eën kov e Kristo e Koaꞌ pe Sosoenën vëh na to kë no sih a ëhnaneah, ha?” ");
INSERT INTO tpz_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ke Ieesuꞌ soe pan, “Eöꞌ kuru ivëh. Amot nöm se ep ka neoꞌ e Koaꞌ Teꞌ Pa Napan Kurus to se ihoꞌ noꞌ pa papmatö pe Sosoenën a Kikis Vi. Paröꞌ nö vaꞌpeh me maꞌ a unöh va akis.” ");
INSERT INTO tpz_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ka Teꞌ Susun po Teꞌ Ësës Heꞌ sisi en po ohop peꞌ, pareꞌ soe pan, “Ea hikta se vaiu hah no ta ma meh teꞌ se vatvus maꞌ ta ma meh soe. ");
INSERT INTO tpz_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Suk ataeah, eöm to pënton koman e nem peꞌ to sosoe oꞌoah e non pe Sosoenën. O kokoman taeah poꞌ nöm to teꞌ me nem?” Ee kurus to pët soe vaonöt ee, pare soe pan, “Eꞌ to teꞌ me e non pa hat, ko se mët en.” ");
INSERT INTO tpz_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ka ma upöm pee taneo ee pa teteo e Ieesuꞌ, pare nohpip ee pa mataneah po rara, ko töstös ee peꞌ, pare hi poë pan, “Pokaꞌ oon voh ah, eteh to tös a oah?” Ko teꞌ utut me poë, pare tatapan ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Manih po poen avoeꞌ pamëh ne Pitaꞌ to ihoꞌ non manuh vakunah koman a eean, ka pah köövo kikiu po Teꞌ Susun po Teꞌ Ësës Heꞌ nö maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","E köövo pamëh to ep e Pitaꞌ to maꞌkis non po suraꞌ, pareꞌ ves rakah non pa matan e Pitaꞌ, pareꞌ soe pan, “Eën me poꞌ to teꞌ vaꞌpeh me voh nom e Ieesuꞌ va Nasarët toh?” ");
INSERT INTO tpz_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ivëhkëk, e Pitaꞌ to vonih en, pareꞌ soe pan, “Eöꞌ to hikta nat noꞌ, paröꞌ hikta maaka noꞌ pa tah nën to vavaato suk nom.” Eꞌ to piun va nën, pareꞌ tavus koe en po hopaꞌ, ka varuꞌ rakah vakomanih no a pah toaꞌ oeteꞌ to to tötö en. ");
INSERT INTO tpz_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ke köövo kikiu pamëh ep poan, pareꞌ soe ke ra napan to sun vatët ne pan, “A teꞌ vëh, eꞌ a meh va pee.” ");
INSERT INTO tpz_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ivëhkëk, e Pitaꞌ to soe hahah kov en pan, “Ahik.” Ka meh siꞌ ö oah en, ka napan varih to sun vatët ne pe Pitaꞌ soe ee pan, “O pöh man rakah, eën a meh va pee, eën hikta se vonih nom, suk ataeah, eën a teꞌ va Galiliꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ivëhkëk, e Pitaꞌ to vonih vakis rakah en, pareꞌ soe pan, “Oman rakah, e Sosoenën se vakmis en peöꞌ pa ö ne eöꞌ se keh hikta sosoe noꞌ, oman! Eöꞌ to hikta nat noꞌ pa teꞌ vëh nöm to vavaasoe suk nem!” ");
INSERT INTO tpz_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ka varuꞌ vakomanih ne toaꞌ oeteꞌ to vapöök tö en, ke Pitaꞌ koman hah poꞌ en pa ö ne Ieesuꞌ to soe vavoh ke poan pan, “Vamomoaan in a ö ne toaꞌ oeteꞌ se meꞌ avoeꞌ e non pa poa tö. Eën se kukön soe eom pan, eën to hikta nat nom peöꞌ. Ke Pitaꞌ vamösru, pareꞌ ook en, eꞌ to koman hah o piuk peꞌ, pareꞌ pah tamak en. ");
INSERT INTO tpz_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pa pöstakah rakah no o teꞌ susunön ësës heꞌ, me ro teꞌ susunön po Jiuꞌ, me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, to vatötönun me o Kum Teꞌ Susunön po Jiuꞌ. Ee to nohnoh poë, pare me e peꞌ manuh pe Paëlat. ");
INSERT INTO tpz_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ke Paëlat hi en peꞌ pan, “Eën kov e sunön po Jiuꞌ, ha?” Ke Ieesuꞌ piun a soe peꞌ, pareꞌ soe pan, “Eën koman to soe va eom nën.” ");
INSERT INTO tpz_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ko teꞌ susunön ësës heꞌ pokaꞌ poë pa ma soe peo. ");
INSERT INTO tpz_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ivëh, ke Paëlat hi hahha kov en peꞌ pan, “Eën hikta pinpiun nom ta pah soe toh? Ep e nom oh, ee to vateen e pën pa ma vu soe.” ");
INSERT INTO tpz_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ivëhkëk, e Ieesuꞌ to hikta piun ta pah soe. Ivëh, ke Paëlat pah toksean rakah en. ");
INSERT INTO tpz_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pa ma kirismas kurus manih pa Taëën Apuh va po Pasovaꞌ, ne Paëlat to vavatvus taneꞌ hah non sih a pah teꞌ manih pa nohnoh, pa ö no a napan se hin poë. ");
INSERT INTO tpz_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Manih pa ma poen poë varih nee to vahoꞌ voh a ma pah teꞌ manih pa nohnoh. Suk ataeah, a ma teꞌ poë varih to kunkuin voh o vapus, kee vapus me a kaman va Rom, ko ip vamët rakah ee pa ma pah teꞌ va Room. Ka paeh va pa napan poë varih to kunkuin o vapus ivëh, e Barabas. ");
INSERT INTO tpz_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","A nap peo to tavus maꞌ, pare taneo ee pa hin e Paëlat pan, eꞌ se nok vamanih pa ö neꞌ to nonok moaan vavoh non manih pee. Eꞌ to vavatvus taneꞌ voh non sih a ma pah teꞌ manih pa nohnoh. ");
INSERT INTO tpz_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ke Paëlat hi en pee pan, “Eöm iu nem a ö ne eöꞌ se vatvus nös e sunön po Jiuꞌ, ha?” ");
INSERT INTO tpz_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","E Paëlat to soe vamanih, suk eꞌ to nat e non po teꞌ susunön ësës heꞌ to puhioꞌ ne e Ieesuꞌ, ivëh, nee to vahoꞌ suk maꞌ poë manih pa koreneah. ");
INSERT INTO tpz_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ivëhkëk, o teꞌ susunön ësës heꞌ to kunkuin e ne pa ma kokoman pa napan, pan e Paëlat se vahah ke maꞌ raoe e Barabas, ke Ieesuꞌ mët varoe. ");
INSERT INTO tpz_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ke Paëlat hi hah en pee pan, “Keöꞌ se poꞌ nok ataeah manih pa teꞌ vëh ne eöm to popokaꞌ nem eah e sunön po Jiuꞌ?” ");
INSERT INTO tpz_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ka napan taoa maꞌ, pare pët soe maꞌ pan, “Ni öm eah pa kuruse.” ");
INSERT INTO tpz_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ke Paëlat hi hah en pee pan, “Suk ataeah, a hat taeah neꞌ to nok?” Ivëhkëk, a napan to taoa suntan rakah ee ko soe ke Paëlat pan, “Ni öm eah pa kuruse.” ");
INSERT INTO tpz_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","E Paëlat to kehkeh vamanman vah non a napan, ivëh, keꞌ vanö toꞌtoꞌ hah en maꞌ pe Barabas. Ivëhkëk, eꞌ to heꞌ e Ieesuꞌ manih pa nap vëvënsun, pan ee se rëp poë po uris rëprëp teꞌ, pare ni poë pa kuruse. ");
INSERT INTO tpz_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ka nap vëvënsun me ho ee pe Ieesuꞌ manuh pa ö vavahutët manuh pa iuun pa kaman, pare vaoe ununun na a ma meh pee, kee tönun ee maꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pare ohop ee pe Ieesuꞌ po ohop rë ereraꞌ, pare nok o uvan po uris toꞌtoꞌ, ko uvan ee peꞌ. Ee to nok va nën marën a hinën in poë, vamanih peꞌ e sunön. ");
INSERT INTO tpz_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pare taneo ee pa vaeö me a kë vapikpiuk poë, ee to soe pan, “Potan avih Sunön po Jiuꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ee to navuh ee pa pasuneah po toknon. Pare teteo poë, pare vatokon, ko vavövöneꞌ in poë. ");
INSERT INTO tpz_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kee vahik kö poë, pare ihan këh poë o ohop rë ereraꞌ vëh nee to ohop moaan vu poë, pare ohop hah ee peꞌ po ohop koman peꞌ, ko me ee peꞌ pan ee se ni poë manih pa kuruse. ");
INSERT INTO tpz_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Manuh hanan nee to akeh a pah teꞌ va Saëriniꞌ to vovos nö non Jerusalëm, to taneꞌ maꞌ muhin, a ëhnaneah e Saëmon eꞌ e taman, ere Alëksantaꞌ, pen e Rufus. Ka nap vëvënsun ep poë, pare toon vakis rakah ee peꞌ pan eꞌ se teꞌ vaꞌaus e Ieesuꞌ pa kuruse. ");
INSERT INTO tpz_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kee me ee pe Ieesuꞌ manuh pa tope nee to popokaꞌ ne a Gölgötaꞌ, a pusun in a ö soe pamëh to soe va non manih pan, “A ö no a ma kahoꞌ teꞌ to pet ne.” ");
INSERT INTO tpz_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Manuh nën nee to kehkeh vakaak ne e Ieesuꞌ po voaën nee to hovën pa ëtoꞌ vatö kamis, Ivëhkëk, e Ieesuꞌ to hikta kaak a ëtoꞌ pamëh. ");
INSERT INTO tpz_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ee to vahan ee pe Ieesuꞌ pa kuruse, pare ki vakëkëh a ma ohop peꞌ manih topniire, pare vi a saatuꞌ, ko ut ne peteh ivëh se kon a ma papaeh va pa ma ohop peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Pa 9 kirök pa pöstakah, nee to ni ee pe Ieesuꞌ pa kuruse. ");
INSERT INTO tpz_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ka manuh kin pa pasun in a kuruse ne Paëlat to kiun a soe to vataare non ataeah nee to vateꞌ suk voh poë pa hat. Eꞌ to kiun vavoh manih pan, “IVAꞌIH A TEꞌ SUNÖN PO JIUꞌ.” ");
INSERT INTO tpz_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Manih pa havin e Ieesuꞌ nee to ni a meh poa teꞌ kakaveo, a paeh to han ke non pa papmatö, ka meh han ke non pa papkiruk pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Keꞌ a tah pamëh to vapuh en pa pah soe va po Puk Vapenpen, keꞌ tavus vaman en. Ka soe pamëh, to teꞌ va non manih pan, “Ee to ëh vaꞌpeh me e Ieesuꞌ pa nap hat.” ");
INSERT INTO tpz_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ka napan to vaoah ne, pare vavövöneꞌ ne poë, ko vaviivi pasun, pare soe pan, “Hahah! Eën kov ivëh to sosoe voh nom pan, eën se kök a Iuun Hinhin Apuh, parën eok hah eom peꞌ po kukön poen ro, ha? ");
INSERT INTO tpz_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Varuꞌ rakah vakomanih sën këh kunah maꞌ a kuruse parën vaꞌaus koman hah eo.” ");
INSERT INTO tpz_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","O teꞌ susunön ësës heꞌ, me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, to vavövöneꞌ e ne pe Ieesuꞌ, pare vavaasoe aven e ne pan, “Eꞌ to vavaꞌaus voh non o upöm teꞌ, ivëhkëk, eꞌ to hikta onöt non a vaꞌaus koman hah ea. ");
INSERT INTO tpz_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ka ep voh no pe Kristo vëh e sunön pa napan va Israël, kuru neꞌ se këh kunah maꞌ a kuruse, ka ep, para vaman poꞌ eah.” A poa teꞌ kakaveo varih nee to ni sinten a teꞌ kuruse pe Ieesuꞌ. Ee me to vavövöneꞌ e ne peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pa topnin potan pa 12 kirök no a popoen to kopös avoes en pa muhin, ko hik pa 3 kirök pa matanpoen. ");
INSERT INTO tpz_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pa 3 kirök ne Ieesuꞌ to tötö suntan rakah va en manih pan, “Eloi, Eloi, rama sapaktani?” Eꞌ to sosoe va non manih pan, “Sosoenën peöꞌ, Sosoenën peöꞌ, eën varakah ka neoꞌ toh?” ");
INSERT INTO tpz_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ka napan to sun vatët ne manih pa ö ne Ieesuꞌ to han non to pënton a ö neꞌ sosoe va non, pare soe pan, “Eꞌ to vavaoe non e Elaëjaꞌ pan eꞌ se vaꞌaus poan.” ");
INSERT INTO tpz_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ka pah teꞌ vavaveo, pareꞌ vahoꞌ na ta tah rö ötöt ruen manih po vinikaꞌ, pareꞌ vakapis poan po noton a tanaon, pareꞌ heꞌ e Ieesuꞌ, pan eꞌ se kaak, ka teꞌ pamëh soe en pan, “Anoeh voh, ka ep voh no, e Elaëjaꞌ se pöꞌ ihan en peꞌ keꞌ këh kunah en maꞌ pa kuruse, keꞌ ahik.” ");
INSERT INTO tpz_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ke Ieesuꞌ pah tötö suntan en, ka apeneah këh en peꞌ, keꞌ mët en. ");
INSERT INTO tpz_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ko rara vëh to han non koman a Iuun Hinhin Apuh tasi taneꞌ maꞌ manuh po pasun, pareꞌ öök en manih po kusin, pareꞌ tavus en a poa tan. ");
INSERT INTO tpz_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ke susun pa nap vëvënsun to sun non matan in a kuruse ep in a ö ne Ieesuꞌ to mët vah ava, pareꞌ soe en pan, “A teꞌ vëh eꞌ vamaman rakah e Koaꞌ pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","A ma meh köövo me to sun varo amot e ne maꞌ, pare ut ne, ka paeh va pee ivëh, e Mariaꞌ va pa vöön va Makdalaꞌ, me Mariaꞌ e sinan e Jëmis, e kea soneꞌ pe Jeosëp, pen Salomeꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Moaan voh ne Ieesuꞌ to teꞌ voh non Galiliꞌ, ko köövo poë varih nönö vaꞌpeh vah me voh ne poë, pare vavaꞌaus ne poë, o köövo peo rakah me to teꞌ ne nën to nö vaꞌpeh me voh e Ieesuꞌ manuh Jerusalëm. ");
INSERT INTO tpz_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Pa matanpoen, po vatönim, eꞌ o poen nee to vamatop ne a ma taëën va po Poen Apaapo. ");
INSERT INTO tpz_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","E Jeosëp va Arimatiaꞌ, eꞌ a teꞌ va po Kum Teꞌ Susunön po Jiuꞌ no a napan to ta ne sih poë. Eꞌ me to anoeh non sih a Matop Vih pe Sosoenën, eꞌ to hikta nanaöp non, pareꞌ nö manuh pe Paëlat, ko hinhin non a sionin e Ieesuꞌ pan eꞌ se herep taneꞌ maꞌ pa kuruse. ");
INSERT INTO tpz_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","E Paëlat to pah kokoman vörep e non, pareꞌ hi e Jeosëp pan, “Eꞌ kës to mët en, ha?” Eꞌ to vaoe en na pa teꞌ susun pa nap vëvënsun, pareꞌ hi eah pan, “E Ieesuꞌ mët en, keꞌ ahik?” ");
INSERT INTO tpz_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","E Paëlat to tënan vahik en pa ma vahutët pa teꞌ susun po teꞌ vëvënsun, pareꞌ taꞌ en pe Jeosëp pan eꞌ se herep taneꞌ maꞌ a sionin e Ieesuꞌ manih pa kuruse. ");
INSERT INTO tpz_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","E Jeosëp to voen maꞌ o pöh rara kakaare, pareꞌ herep en pa sionin e Ieesuꞌ këh a kuruse, pareꞌ pöm poan po rara kakaare. Eꞌ to teꞌ hop en pa sionineah po vapeepe nee to top voh a pa vös apuh. Ke Jeosëp vahuk a meh vös to teꞌ va non manih po ipapanih, pareꞌ sunpip en pa matan a top pamëh ne Ieesuꞌ to pet non. ");
INSERT INTO tpz_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","E Mariaꞌ va Makdalaꞌ, me e Mariaꞌ sinan e Jeosëp, ee pon to ut me e ne, pare ep e ne pa ö vëh nee to vahoꞌ a sionin e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","O Poen Apaapo to oah en, ke Mariaꞌ va Makdalaꞌ, me a Mariaꞌ e sinan e Jëmis, ke Salomeꞌ to teꞌ maꞌ a ma vanom o voavuh vih marën a uh a sionin e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pa pöstakah rakah po poen vamomoaan in o nënkikiu, nee to nö ee manuh po vapeepe to teꞌ non pa top vös. ");
INSERT INTO tpz_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","O poen nee to nönö nö ne manuh hanan, ee vaiihi nö e ne pan, “Eteh rakah ivëh se vahuk ka ra a vös apuh vëh to sunpip non o hopaꞌ oho koe vëh pa top vös?” ");
INSERT INTO tpz_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kee ep peah na, pare ep vahik ee na pa vös to vahuk këh en po hopaꞌ in o vapeepe. ");
INSERT INTO tpz_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ee to hop ee manuh po vapeepe, pare ep in a pah teꞌ sekaꞌ to ihoꞌ non pa papmatö. Eꞌ to ohop non o ohop kakaare o pöh rë vörep, pare pah töhkak vahat ee. ");
INSERT INTO tpz_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ka teꞌ sekaꞌ pamëh soe ke raoe pan, “Koe öm a töhkak vahat, eöꞌ to nat e noꞌ peöm to nö maꞌ pa ep e Ieesuꞌ va Nasarët vëh nee to ni voh poë manih pa kuruse. Eꞌ to hikta teꞌ non manih, eꞌ to toꞌ en, ko sun hah voh en, ivaꞌih a ö nee to vahoꞌ voh poë. ");
INSERT INTO tpz_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Varuꞌ rakah vakomanih nöm se nö, paröm soe vanat a ma vamomhë peꞌ, paröm soe pet me ke Pitaꞌ pan, e Ieesuꞌ to vovoh ken peöm manuh Galiliꞌ, eꞌ to teꞌ non nën se röm nö paröm ep in eah nën. Vamanih pa ö neꞌ to soe vavoh ka neöm.” ");
INSERT INTO tpz_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ka kukön köövo tavus taneꞌ hah maꞌ manuh po vapeepe, pare vaveo taneꞌ maꞌ nën, suk ataeah, ee to pah naöp suntan ee, pare rikrik e ne, ko hikta vaato me ta meh teꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Pa pöstakah rakah po poen Apaapo ne Ieesuꞌ to sun taneꞌ hah po vapeepe, pareꞌ tavus momoaan e Mariaꞌ va Makdalaꞌ. E köövo pamëh ne Ieesuꞌ to veo taneꞌ voh a tönim me a poa oraꞌ hat manih peꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","E Mariaꞌ to nö en, pareꞌ soe vanat en po teꞌ varih to nönö vaꞌpeh vah me voh ne e Ieesuꞌ. O teꞌ poë varih to vaokook ne, pare tatamak ne e Ieesuꞌ to mët. ");
INSERT INTO tpz_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","E Mariaꞌ to soe ke rapoë pan, “E Ieesuꞌ to toꞌ hah en, köꞌ ep eoꞌ maꞌ peꞌ. Paröꞌ vaato me eoꞌ peꞌ.” Ivëhkëk, ee to pënton a soe vaꞌih, pare hikta vaman ne a soe pe Mariaꞌ. ");
INSERT INTO tpz_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Vasuksuk no a poa vamomhë to këh maꞌ a Jerusalëm, pare nönö nö ne maꞌ hanan, ke Ieesuꞌ panih ko matan ke e non, pareꞌ nö maꞌ ko tavus en pee. ");
INSERT INTO tpz_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ka poa vamomhë poë varih hah ee, pare sosoe ke ne a ma upöm vamomhë pe Ieesuꞌ, ivëhkëk, ee to hikta vaman a soe pee pon. ");
INSERT INTO tpz_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Vasuksuk in a ö ne Ieesuꞌ to sun taneꞌ hah po vapeepe, neꞌ to nö ko tavus hah en pa havun me a pah vamomhë peꞌ, po poen nee to ënëën nee. Pareꞌ pah siröꞌ suntan en pee, suk ee to hikta teꞌ me ne o vaman, me a ö nee to hikta vaman o teꞌ varih to ep in poë to toꞌ hah. ");
INSERT INTO tpz_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","E Ieesuꞌ to soe ke rapoë pan, “Eöm se nö manuh pa ma ö kurus manih po oeh ovoes vëh, paröm vavaasis a Soe Vih peöꞌ manih pa ma napan kurus. ");
INSERT INTO tpz_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ere tereh se vaman, köm pupui raoe, e Sosoenën se kon hah en pee. Ivëhkëk, ere tereh se keh hikta teꞌ me ne o vaman, ee se sun ee po vahutët apuh pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","E Sosoenën se heꞌ en po kikis manih po teꞌ varih to vaman a no neoꞌ, kee nok ee pa ma vu tah vatoksean. Pare veo tavus ee po oraꞌ hat manih pa ëhnaneoꞌ, ko vaato ee pa ma vu to voon varih to hikta teꞌ ne pan a ma to koman pee. ");
INSERT INTO tpz_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ee se keh öt ro ee pa kuruꞌ ënëën vamët teꞌ pa koreere, pare kaak ro ee pa ta ëtoꞌ vamëtmët, a ma tah poë varih to hikta onöt nee a miröꞌ raoe. Me ee se keh vahoꞌ a ma koreere manih po teꞌ varih to haraꞌ ne a ma vu mët, a ma mët pee se hik ee, kee haraꞌ vavih hah ee.” ");
INSERT INTO tpz_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","E Sunön pea e Ieesuꞌ Kristo to vatvus vahik ken pa ma vamomhë peꞌ pa ma soe, ke Sosoenën me peah hah en peꞌ manuh pa vöön va kin, keꞌ ihoꞌ e non pa papmatö pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ko vamomhë peꞌ tavus taneꞌ manih Jerusalëm, pare nö ee pa vavaasis a Soe Vih manih pa napan kurus va po oeh vëh. E Sunön to kiu vaꞌpeh me non raoe, kee nok a ma tah vatoksean marën a vataare a ma napan, pan a Soe Vih to teꞌ man e non. ");
INSERT INTO tpz_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Eën A Teꞌ Topoan Tiopiras, A napan peo to puta voh pa kiun vavih suk hah o vahutët vëh ne Ieesuꞌ Kristo to nok voh marën a vakikis o vaman pea. ");
INSERT INTO tpz_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ee to kiun suk hah voh o vahutët po teꞌ varih to ep momoaan voh ne pa ma tah poë varih, keꞌ ee voh ivarih to vatvus voh ka ra a kiu me o vavaasis pe Ieesuꞌ Kristo a teꞌ vëh ne Sosoenën to vateꞌ maꞌ, keꞌ nö maꞌ manih po oeh. ");
INSERT INTO tpz_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Eöꞌ e Luk to iu kiun meꞌ noꞌ o vahutët pamëh to vanö ka nös oah. Ko poen neöꞌ to kehkeh nat vavih noꞌ pa pusun in a soe pamëh, ka kuru neöꞌ se kiun suk hah va eoꞌ manih pa ö nea to pënton moaan vavoh no. ");
INSERT INTO tpz_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ivëh kën sih nat vavih eom pa soe vaꞌih nee to vavaasis voh ne oah a man rakah. ");
INSERT INTO tpz_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","O poen ne Hëërot to matop non a muhin va Jiutiaꞌ, keꞌ teꞌ voh non a teꞌ ësës heꞌ a ëhnaneah e Sëkaraëaꞌ. E Sëkaraëaꞌ voh a teꞌ ësës heꞌ va po vu teꞌ va pe Apaësaꞌ to taneꞌ maꞌ pe Aron. Ka ëhnan e köövo peꞌ e Lisabet, eꞌ me e köövo va po vuteꞌ va pe Aron. ");
INSERT INTO tpz_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ka manih pa matan e Sosoenën nee to pah teꞌ vavih rakah e ne pon, pare vavatet vavih rakah kov e ne pa ma taateꞌ pe Sunön, pare hikta teꞌ me ne ta siꞌ hat manih pa matan e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ivëhkëk, ee to hikta teꞌ me ne ta koaꞌ, suk ataeah, o ihoꞌpaeꞌ to pos voh en, keꞌ hikta onöt non a han koaꞌ. E Sëkaraëaꞌ pen e Lisabet to manot varo rakah voh ee. ");
INSERT INTO tpz_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","O poen no vakum teꞌ pe Sëkaraëaꞌ to vovoh ne pa matop a kiu va pa ës a tah avoavuh vih ke na e Sosoenën manih koman a Iuun Hinhin Apuh, ke Sëkaraëaꞌ nö pa ës a tah avoavuh vih vamanih peꞌ a teꞌ ësës heꞌ manih pa matan e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ka manih pa taateꞌ va po teꞌ ësës heꞌ, o teꞌ ësës heꞌ va po kum teꞌ pe Sëkaraëaꞌ to vi a saatuꞌ pa ep këh peteh se ho manuh pa koman a siꞌ piprom vasioꞌ, pareꞌ ës ke na e Sosoenën a tah avoavuh vih. Kee kon ee pe Sëkaraëaꞌ se ho. ");
INSERT INTO tpz_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ko poen no a tah avoavuh vih pamëh to ësës non, a nap peo rakah he hinhin ne manih mahën. ");
INSERT INTO tpz_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ka pah ankeroꞌ tavus e Sëkaraëaꞌ, pareꞌ sun non manih pa papmatö in a pok vëh no a tah avoavuh vih pamëh to ësës non. ");
INSERT INTO tpz_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ka ankeroꞌ to tavus maꞌ, ke Sëkaraëaꞌ ep in poan, pareꞌ pah töhkak ko naöp suntan en. ");
INSERT INTO tpz_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ivëhkëk, a ankeroꞌ to soe ke poan pan, “Sëkaraëaꞌ koe a naöp, Sosoenën to pënton en maꞌ pa hin pën. E köövo manot pën se han a pah koaꞌ oeteꞌ, kën vëhnan eah e Jon. ");
INSERT INTO tpz_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","O kokoman pën se vih vörep, me eën se puh rakah nom po vaeö. Amot no a napan se vaeö rakah po poen ne sinaneah se vahuh poan.” ");
INSERT INTO tpz_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","“Eꞌ se teꞌ rakah o ëhnan apuh manih pa matan e Sunön, pareꞌ hikta se kaak non to voaën me a ma ruiꞌ pais, pö ne sinaneah to han non poan ka Tuvuh Vasioꞌ to puh rakah non peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Eꞌ se kon hah maꞌ a napan va Israël, kee tarih hah maꞌ manih pe Sunön Sosoenën pee.” ");
INSERT INTO tpz_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","“Eꞌ se kon a taateꞌ me o kikis vëh ne Elaëjaꞌ to teꞌ me voh non, pareꞌ vovoh ke maꞌ e Sunön. Eꞌ se panih a ma kokoman po taman, kee tarih hah ke maꞌ manih pa ma koaꞌ pee, kee vapöh kokoman hah ee. Pareꞌ panih me en pa ma kokoman po teꞌ vatösoe, kee kon taneꞌ a taateꞌ me o kokoman natsean manih po teꞌ no a taateꞌ pee to teꞌ totoopin non sih manih pa matan e Sunön, pareꞌ vavaasis a napan pa taateꞌ vih, kee sih anoeh ne e Sunön, pare pënton a soe peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ke Sëkaraëaꞌ hi poan pan, “Eöꞌ se vaman vah va in a soe pën nih? Emöm poꞌ e köövo peöꞌ to pah manot varo em.” ");
INSERT INTO tpz_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ka ankeroꞌ piun poan, pareꞌ soe pan, “Eöꞌ e Gebriël, to sun noꞌ sih pa matan e Sosoenën. Eꞌ koman ivëh to vanö maꞌ neoꞌ köꞌ teꞌ maꞌ a soe vih vaꞌih manih pën. ");
INSERT INTO tpz_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","A ma soe peöꞌ se tavus vaman. Ivëhkëk, eën to hikta pënton a soe peöꞌ, parën hikta vaman nom, ivëh, kën se hikta vaato me ro upöm teꞌ, keꞌ onöt rakah po poen ne koaꞌ se tavus.” ");
INSERT INTO tpz_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Komön o poen pamëh ne Sëkaraëaꞌ to teꞌ non maꞌ manuh pa koman a piprom vapenpen pe Sosoenën, a nap peo to anoeh ne poë to pah kokoman vörep e ne pataeah to tavus vu peꞌ? ");
INSERT INTO tpz_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","E Sëkaraëaꞌ to tavus maꞌ, pareꞌ hikta onöt non a vaato me ra napan, pareꞌ vauhioꞌ koren me non raoe, ivëh, kee nat e ne peꞌ to ep vu maꞌ ta tah manuh koman a piprom vapenpen. ");
INSERT INTO tpz_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ka ma poen kiu peꞌ manih pa Iuun Hinhin Apuh hik ee, ke Sëkaraëaꞌ hah en manuh pa vöön peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ko vasuksuk ne köövo manot peꞌ to kiuk en, pareꞌ teꞌ varoe ko non iuun peꞌ pa tönim sivö. ");
INSERT INTO tpz_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ke Lisabet soe en pan, “Sunön to vaꞌaus a neoꞌ po poen vëh, pareꞌ vahik këh en peöꞌ po poet vëh manih pa matëëra ma napan, suk moaan voh eöꞌ to hikta han koaꞌ noꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","O kiuk pe Lisabet to onöt non a tönim sivö me a paeh, ke Sosoenën vanö hah en pe ankeroꞌ Gebriël manuh pa siꞌ vöön va pa muhin va Galiliꞌ, a ëhnaneah Nasarët. ");
INSERT INTO tpz_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ka ankeroꞌ teꞌ a soe manuh pa koaꞌ sepeꞌ a ëhnaneah e Mariaꞌ, nee to soe vaonöt voh, pan eꞌ se vaen pen e Jeosëp a teꞌ va po vuteꞌ pe sunön peꞌ e Devit. ");
INSERT INTO tpz_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ka ankeroꞌ tavus e Mariaꞌ, pareꞌ soe pan, “Potan avih Mariaꞌ, Sosoenën to ep vavih ko nom oah, ke Sunön to teꞌ vaꞌpeh me a nom oah.” ");
INSERT INTO tpz_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","E Mariaꞌ to pënton a soe pe Gebriël, pareꞌ pah töhkak vahat en, pareꞌ koman pan, “A soe vaꞌih, eꞌ a soe taeah?” ");
INSERT INTO tpz_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ka ankeroꞌ soe ke poan pan, “Mariaꞌ koe a naöp, o kokoman pe Sosoenën to vih vi rakah ka nom oah. ");
INSERT INTO tpz_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Pënton nom ah, eën se han koaꞌ, parën vahuh a pah koaꞌ oeteꞌ, parën vëhnan rakah eah e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Eꞌ se teꞌ rakah non a teꞌ Sunön, ka napan se popokaꞌ ne poë e Koaꞌ pe Sosoenën va pa vöön va kin. E Sunön Sosoenën se vateꞌ poan a teꞌ Sunön rakah vamanih pe sipun voh eah e Devit. ");
INSERT INTO tpz_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Eꞌ me se teꞌ tamoaan non e Sunön va po vuteꞌ va pe Jekop, ka Matop Vih peꞌ hikta onöt rakah non ahik.” ");
INSERT INTO tpz_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ke Mariaꞌ hi a ankeroꞌ pan, “A tah vaꞌih se tavus vahvanih? Eöꞌ to hikta vaen avoeꞌ noꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ka ankeroꞌ piun a soe pe Mariaꞌ, pareꞌ soe pan, “A Tuvuh Vasioꞌ se nö maꞌ manih pën, ko kikis pe Sosoenën se kopös a oah. E koaꞌ vivihan pamëh, nee se popokaꞌ ne poë, e Koaꞌ pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Eën to nat e nom e pömah Lisabet no a napan to sosoe voh ne pan, eꞌ to hikta onöt voh non a han koaꞌ. Ivëhkëk kuru vëh, a tönim sivö me a paeh to oah ee peꞌ to teꞌ me non o kiuk. ");
INSERT INTO tpz_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ahikta pah tah ne Sosoenën to hikta onöt non a nok.” ");
INSERT INTO tpz_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ke Mariaꞌ soe en pan, “Eöꞌ e köövo kikiu pe Sosoenën, ke Sosoenën se nok va en peöꞌ manih pa ö nën to soe ava.” Ka ankeroꞌ këh en pe Mariaꞌ ko hah en. ");
INSERT INTO tpz_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","A ma siꞌ poen to oah ee ke Mariaꞌ vamatop, pareꞌ vëhöꞌ en pa vöön to teꞌ non pa ma tope muhin va Jiutiaꞌ, pa ö ne Sëkaraëaꞌ pen Lisabet to teꞌ ne, pareꞌ ho en manuh pa iuun pee, pareꞌ not en pe Lisabet. ");
INSERT INTO tpz_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","E Mariaꞌ to not e Lisabet me o vaeö apuh, ke koaꞌ vëh ne Lisabet to teen non variu en maꞌ. E Lisabet to puh rakah non pa Tuvuh Vasioꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","E Lisabet to vaato vaꞌpuh en, ko soe pan, “Sosoenën to heꞌ a oah o vaeö apuh to oah e non po upöm köövo, pareꞌ heꞌ pet en po vaeö apuh pe koaꞌ vëh nën se vahuh.” ");
INSERT INTO tpz_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ke Lisabet soe pet en pan, “Suk ataeah, ke sinan e Sunön peöꞌ nö maꞌ pa ep peöꞌ? ");
INSERT INTO tpz_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Eöꞌ to pënton a soe vaeö pën, ke koaꞌ vëh to teꞌ non pa komaneoꞌ vaeö vörep, pareꞌ variu en maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ke Lisabet soe vamanih pan, “Eën to vaman vi voh eom, ivëh, kën se vaeö, amot ne Sosoenën se nok va en pën manih pa ö neꞌ to soe vaman va voh ka oah.” ");
INSERT INTO tpz_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","E Mariaꞌ to soe pan, “O kokoman peöꞌ to kë vakin rakah a ëhnan e Sunön. ");
INSERT INTO tpz_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ka apeneoꞌ vaeö rakah ke non pe Sosoenën to vaꞌaus a neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Eꞌ to koman non e köövo to teꞌ non pa taateꞌ teꞌ vöknah to kiu non peꞌ. Taneo non kuru no a napan va kuru me a napan se tavus amot maꞌ se soe pan, eöꞌ e köövo to teꞌ vaeö tamoaan noꞌ, Suk a tah apuh vëh ne Sosoenën kikis to nok manih peöꞌ ka ëhnaneah vivihan, ");
INSERT INTO tpz_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","A ma vu koaꞌ va kuru me a ma teꞌ se tavus amot maꞌ, se keh ta ne poë, ivëh, ko ururuan peꞌ teꞌ rakah non manih pee. ");
INSERT INTO tpz_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Eꞌ to vataare voh en po kikis peꞌ pa ma kiu apaꞌpuh neꞌ to nok voh. Ka nap vatösoe neꞌ to veo vavah voh en pee. ");
INSERT INTO tpz_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Eꞌ to vöknah en po teꞌ sipoan këh a ma tasun apaꞌpuh pee, pareꞌ kë varuꞌ en pa napan to teꞌ vöknah ne. ");
INSERT INTO tpz_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Eꞌ to makën vamhun en pa nap maë pa ma taëën vihvih. Ka napan varih to vaneah ne a ma tah peo neꞌ to kokon hah këh en pee. Ko vahah koraꞌ en pee. ");
INSERT INTO tpz_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ivëh, keꞌ soe ke voh a kën sipuura pan, ‘Eöꞌ se ururuan e Abraham me ro vuteꞌ peꞌ varih se tavus amot maꞌ, keꞌ nö ko tavus amot na manuh. Pareꞌ nat avoeꞌ e non po ururuan voh peꞌ. Eꞌ to nat e non pa soe vaman neꞌ to soe ke voh a kën sipuura, Ko vaꞌaus en pa napan peꞌ Israël.’” O vaëhëh pe Mariaꞌ to hik en. ");
INSERT INTO tpz_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Keꞌ teꞌ vaꞌpeh me Lisabet pa kukön sivö, pareꞌ hah en Nasarët. ");
INSERT INTO tpz_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ko poen vahuh pe Lisabet öök en, keꞌ vahuh en pa koaꞌ oeteꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ka ta vöön peꞌ me o vuteꞌ peꞌ tënan a ö ne Sunön to ururuan va in e Lisabet, ko heꞌ poan e koaꞌ, ivëh, kee pët vaeö me ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","E Jon to onöt non o pöh nënkikiu, kee pe ee pa ö kokoaan peꞌ, pare iu vëhnan ne poë e Sëkaraëaꞌ, pa ëhnan e tamaneah. ");
INSERT INTO tpz_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ivëhkëk, e Lisabet to soe pan, “Ahik, ea se vëhnan eah e Jon.” ");
INSERT INTO tpz_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ivëhkëk, a kën poan e Lisabet to soe ke poë pan, “Ahik voh ta pah teꞌ va po vuteꞌ pën to vëhnan voh non e Jon.” ");
INSERT INTO tpz_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ivëh, kee vauhioꞌ koren me e Sëkaraëaꞌ pan, “O ëhnan poanheh nën se vëhnan e sumuiꞌah?” ");
INSERT INTO tpz_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ke Sëkaraëaꞌ hin poꞌ a tah neꞌ se kiun, pareꞌ kiun vamanih pan, “A ëhnaneah e Jon.” Kee pah kokoman vörep rakah e ne. ");
INSERT INTO tpz_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ka varuꞌ rakah vakomanih e Sëkaraëaꞌ to vaato vavih hah en, pareꞌ taneo en pa kë a ëhnan e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ka kën poaneah pah vananaöp ee, ko vahutët va pa tah pamëh vatvi vëvëhöꞌ vavah en pa ma vöön kurus to teꞌ ne pa moeh totope va Jiutiaꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","A napan kurus to pënton o vahutët pamëh pah kokoman tamoaan e ne, pare vaiihi e ne pan, “Amot ne koaꞌ vaꞌih se teꞌ non a koaꞌ taeah?” Ee to nat e ne po kikis pe Sunön to teꞌ vaꞌpeh me non poan. ");
INSERT INTO tpz_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","E taman e Jon, e Sëkaraëaꞌ to puh rakah non pa Tuvuh Vasioꞌ ko soe vanënën pan, ");
INSERT INTO tpz_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ea se kë a ëhnan e Sunön Sosoenën va Israël, suk eꞌ to nö maꞌ pa vaꞌaus a ra a napan peꞌ, pareꞌ voen hah a ra. ");
INSERT INTO tpz_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Eꞌ to vanö maꞌ a pah teꞌ to öt non a tasun apuh va po vuteꞌ va pa teꞌ kikiu peꞌ, Devit, marën a voen hah a ra. ");
INSERT INTO tpz_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Vamanih pa ö neꞌ to soe vaman vavoh, manih pa rivoeero ro teꞌ vanënën soe voh peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Eꞌ to soe vaman voh en pan, eꞌ se kon taneꞌ hah a ra manih po teꞌ to vakihat me a rora, me manih po kikis po teꞌ varih to rës ka rora sih. ");
INSERT INTO tpz_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Eꞌ to ururuan a kën sipuura, pareꞌ vaꞌaus raoe, ko nat avoeꞌ e non po vatom poan vivihan, neꞌ to nok me voh e sipuura, Abraham. ");
INSERT INTO tpz_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ea hikta se naöp no po poen na to nonok no a kiu peꞌ, suk eꞌ se hehe hah këh a ra pa napan varih to vakihat me a rora. ");
INSERT INTO tpz_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ka sih teꞌ vivihan tamoaan no pa mataneah.” ");
INSERT INTO tpz_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Ke eën e Jon e koaꞌ peöꞌ, amot nee se popokaꞌ a nom oah a teꞌ vanënën soe pe Sosoenën va pa vöön va kin. Eën se vovoh ke Sunön, parën vamatop a hanan peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Eën se vavaasis a ma napan peꞌ, kee nat poë. Eꞌ se ihan anoe a ma hat pee, pareꞌ kon hah raoe. ");
INSERT INTO tpz_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Manih po ururuan apuh pe Sosoenën pea, eꞌ se nok vamanih, eꞌ se vanö maꞌ o maaka va pa vöön va kin, keꞌ kunah maꞌ manih pea. ");
INSERT INTO tpz_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Eꞌ se heꞌ a soe man maaka manih pa napan varih to teꞌ ne sih pa popoen, pare vapeaapen ne pa mët. Ko me a napan pa hanan totoopin, me a taateꞌ tö pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ke Jon apuh, ko natsean en, ka Tuvuh Vasioꞌ puh non manih peꞌ, keꞌ nö, pareꞌ teꞌ non pa moeh upin to anoeh non a ö neꞌ se vatvus a soe manih pa napan va Israël. ");
INSERT INTO tpz_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Manih po poen pamëh ne Jon to teꞌ koaꞌ voh non e Sisaꞌ Agastas to sunön non manih pa kaman va pa ma muhin va Room. Pareꞌ vahoꞌ a pah taateꞌ marën a ma napan kurus rakah va Room se vahoꞌ a ma ëhnëëre manih po puk pa kaman. ");
INSERT INTO tpz_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","O vahoꞌ ëhnan vëh to taneo po poen ne Kwirinius to teꞌ non a teꞌ susun paan e Sisaꞌ Agastas, pareꞌ matop non a muhin va Siriaꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ivëh, ka ma napan nö vakëkëh ee pa ma vöön pee marën a vahoꞌ a ma ëhnëëre manih pa vöön no a ma sipuiire to teꞌ voh ne. ");
INSERT INTO tpz_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","E Jeosëp a teꞌ va po vuteꞌ va pe Devit, ivëh, keꞌ këh en maꞌ pa vöön vëh neꞌ to teꞌ non Nasarët manih pa muhin va Galiliꞌ, pareꞌ nö en pa muhin va Jiutiaꞌ manih pa vöön pe Devit, a ëhnaneah Bëtrëhëm. ");
INSERT INTO tpz_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","E Jeosëp to nö pa vahoꞌ a ëhnaneah pen köövo peꞌ Mariaꞌ vëh, nee to soe vaman voh a ö se vaen pon. E Mariaꞌ he han e non pe koaꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ee to teꞌ avoeꞌ e ne manih Bëtrëhëm, ko poen ne Mariaꞌ se vahuh e koaꞌ vatët en. ");
INSERT INTO tpz_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ke Mariaꞌ vahuh en pa koaꞌ oeteꞌ vamomoaan peꞌ, pareꞌ mon poan po rara, ko vökroh poan pa koman a pokis ënëën taëën po purmakaöꞌ, suk a ma iuun ananoeh teꞌ to puh vahik ee. ");
INSERT INTO tpz_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Manih pa muhin pamëh no a ma pah teꞌ to matop ne o sipsip, ee to ut ne o sipsip pee pa popoen. ");
INSERT INTO tpz_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ka ankeroꞌ pe Sosoenën nö maꞌ manih pee, ke Sosoenën vanö maꞌ o maaka peꞌ, keꞌ kopös raoe, kee pah naöp vörep rakah ee. ");
INSERT INTO tpz_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ivëhkëk, a ankeroꞌ pe Sosoenën to soe ke rapoë pan, “Eöm se koe a naöp, paröm pënton, eöꞌ to teꞌ maꞌ a soe vih manih peöm, eꞌ se vavaeö a ma napan kurus, kee vaeö suntan rakah ee. ");
INSERT INTO tpz_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Manih po poen pamëh pa vöön apuh pe Devit no a pah köövo to vahuh a koaꞌ oeteꞌ, eꞌ a teꞌ marën a kon hah a neöm, e Sosoenën to vateꞌ maꞌ keꞌ nö maꞌ, eꞌ e Sunön. ");
INSERT INTO tpz_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ko vëknöm neöm se ep in to teꞌ va non manih, eöm se ep in a koaꞌ ne sinaneah to mon poan po rara, keꞌ koroh non koman a pokis ënëën taëën po purmakaöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","A ankeroꞌ to vaato vahik en, ka varuꞌ vakomanih, no o ankeroꞌ peo rakah va kin to tavus maꞌ, pare kë a ëhnan e Sosoenën vamanih pan, ");
INSERT INTO tpz_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Vaeö ko kë e Sosoenën vöh pa vöön va kin, vih rakah non po teꞌ varih ne Sosoenën to vaeö non a pop pee, ko heꞌ raoe o kokoman tö, pare teꞌ me ne a taateꞌ tö.” ");
INSERT INTO tpz_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","O ankeroꞌ to këh hah ee pee manuh pa vöön va kin, ka nap utut sipsip vavasoe koman e ne pan, “Aeoh! Nös öm, ka nö ee manuh vöön Bëtrëhëm, para ep voh pa tah pamëh to tavus kuru ne Sosoenën to soe ka ra manih pa ma rivoeero o ankeroꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ivëh, kee nö vëvëhöꞌ rakah ee, pare ep ee pe Mariaꞌ pen Jeosëp to teꞌ ne, ke koaꞌ koroh non pa ö ënëën taëën po purmakaöꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ee to taum ee pee, pare pah hutët poꞌ ee pa soe nee to pënton voh suk e koaꞌ pamëh. ");
INSERT INTO tpz_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ka ma napan kurus pënton a soe vaꞌih no a nap mamatop sipsip to vahutët ne, ko pah toksean ee, pare pah kokoman vörep e ne. ");
INSERT INTO tpz_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ivëh, ke Mariaꞌ ötöön e non pa ma soe poë varih po kokoman peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ka nap mamatop sipsip hah ee, pare kë rakah ee pa ëhnan e Sosoenën. Ee to vaeö ko kë e Sosoenën pa ma tah kurus nee to pënton, pare ep vamanih pa ö no a ankeroꞌ pe Sosoenën to soe ke voh maꞌ raoe. ");
INSERT INTO tpz_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ko tönim me o pöök poen to oah ee, kee pe ee pa ö kokoaan vëh pe koaꞌ, pare vëhnan poë e Ieesuꞌ. O ëhnan pamëh no a ankeroꞌ pe Sosoenën to vëhnan voh poan e sinaneah he meꞌ avoeꞌ e non pa han e koaꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","O poen to tavus en pa ö nee se vatet o Vavaasis pe Mosës pa uhu kokoe e Mariaꞌ keꞌ teꞌ voon non matan e Sosoenën. Ivëh, ke Jeosëp pen e Mariaꞌ me ee pe koaꞌ manuh Jerusalëm, pare heꞌ na poë manuh pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Eꞌ to teꞌ va non manih pa ö no Vavaasis pe Sosoenën to kiun va non, “A ma koaꞌ oeteꞌ vahuh vamomoaan, o koaꞌ poë varih ne eöm se heꞌ na e Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ee pon to iu heꞌ ne o heꞌ pee manuh pe Sosoenën vamanih pa ö no Vavaasis pe Sosoenën to soe va non, “A poa panuh apuh, ivëhkëk ee se keh hikta teꞌ me ne ta poa panuh apuh, ee se heꞌ a poa panuh soneꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","A pah teꞌ to teꞌ non manih Jerusalëm, to puh non pa Tuvuh Vasioꞌ, a ëhnaneah e Simeon. Eꞌ a teꞌ to ta non e Sosoenën, ka pop peꞌ manih po oeh to vih vörep, me eꞌ a teꞌ va pa hin. Eꞌ to anoeh voh non a teꞌ vëh se hehe a napan va Israël, suk ee to haraꞌ vapunis ne. ");
INSERT INTO tpz_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","A Tuvuh Vasioꞌ to soe voh kën peꞌ pan, eꞌ hikta se mët ohoꞌ non, eꞌ se ep momoaan voh in e Ieesuꞌ Kristo a teꞌ ne Topoan se vanö maꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ka Tuvuh Vasioꞌ kuin en po kokoman pe Simeon, keꞌ ho en manuh pa Iuun Hinhin Apuh. Ke Mariaꞌ pen Jeosëp me ee maꞌ pe Ieesuꞌ, pa heꞌ na manuh pe Sosoenën pa ö no Vavaasis pe Mosës to soe va non. ");
INSERT INTO tpz_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ke Simeon pët en pe koaꞌ, ko soe vavihvih ken pe Sosoenën va manih pan, ");
INSERT INTO tpz_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Varuꞌ vamanih Sunön Topoan sën varakah poꞌ ka neoꞌ ah, a teꞌ kikiu pën, köꞌ mët eoꞌ me o vaeö, vamanih pa ö nën to soe vaman vavoh. ");
INSERT INTO tpz_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Suk ataeah, a mataneoꞌ to ep en pa teꞌ nën to soe voh marën a hehe a möm. ");
INSERT INTO tpz_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Eën to vamatop voh a taateꞌ hehe a napan, ka taateꞌ pamëh tavus vamaaka en kuru. ");
INSERT INTO tpz_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Eꞌ o maaka pamëh, se heꞌ o ëman manih pa napan to hikta teꞌ ne ro Jiuꞌ, pareꞌ heꞌ non o ëhnan apuh manih pa napan pën varih, Israël.” ");
INSERT INTO tpz_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","E taman pen sinaneah to pah toksean e ne pa ma soe varih ne Simeon to sosoe ke non raoe suk e koaꞌ Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ke Simeon tapui en pa kën tom taman, pareꞌ soe ke Mariaꞌ pan, “Pënton ah, e koaꞌ vëh no a nap peo va Israël se keh koe in poë, ko ro ee. Ivëhkëk, o upöm teꞌ se keh vaman poë, keꞌ kon hah en pee. Eꞌ se teꞌ va non manih po vëknöm, suk eꞌ se vamaaka manih pa napan a ma tah to taneꞌ rakah maꞌ manih pe Sosoenën, ka nap peo se koe ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ivëh, ka ma kokoman vakoaan pa ma napan se tavus vateeraꞌ ee. Ko tamak o pöh apuh to teꞌ va non manih po rapis rë kakakni se ruk en po kupu pën.” ");
INSERT INTO tpz_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","38","Varuꞌ no a pah köövo vanënën soe to nö maꞌ, a ëhnaneah e Anaꞌ, eꞌ e koaꞌ mon pe Panuel, eꞌ to taneꞌ maꞌ po vuteꞌ pe Asaꞌ. Moaan voh eꞌ a vaen, ko teꞌ me voh non e voe peꞌ po tönim me o pöök kirismas. Ke voe peꞌ mët en, ke köövo teꞌ e non po 84 kirismas. E köövo to hikta këkëh tavus non sih a Iuun Hinhin Apuh. Eꞌ to vapenpen non a taëën, pareꞌ hinhin varoe non sih, pareꞌ nonok non a kiu pe Sosoenën pa popoen me pa potan. Eꞌ to soe vavihvih ke Sosoenën, pareꞌ vatvus a soe suk e Ieesuꞌ manih pa napan to anoeh voh ne e Sosoenën se hehe a napan va Israël këh a ma taateꞌ hat. ");
INSERT INTO tpz_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ee to nok vahik ee pa ma tah kurus vamanih pa ö no Vavaasis pe Sosoenën to soe va non, pare hah ee pa vöön pee Nasarët pa muhin va Galiliꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ke koaꞌ apuh vaeh en, pareꞌ natsean en. Ke Sosoenën vaeö me non poan, ko tapui en peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","E taman me sinan e Ieesuꞌ to nönö ne sih Jerusalëm pa ma kirismas kurus pa teꞌ vaꞌpeh me o upöm teꞌ po poen vapenpen vëh o Pasovaꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","E Ieesuꞌ to teꞌ non o havun me o pöök kirismas, kee pët nö ee Jerusalëm po poen vapenpen pamëh, pa ö neꞌ to teꞌ tamoaan va non. ");
INSERT INTO tpz_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ka ma poen va po Pasovaꞌ oah ee, ke Mariaꞌ pen Jeosëp taneo hah ee manuh Nasarët, ivëhkëk, e koaꞌ Ieesuꞌ to teꞌ avoeꞌ e non maꞌ manih Jerusalëm, ka poa manot hikta nat ne. ");
INSERT INTO tpz_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ee to koman e ne, pan e Ieesuꞌ to pët hah vaꞌpeh me en pa napan, ivëh, kee nö ee pa potan avoes, pare vavaiu vah e ne poë topnin a napan me a ma poëëre. ");
INSERT INTO tpz_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ee to me vavaiu poë, ivëh, kee hah ee manuh Jerusalëm pa vaiu. ");
INSERT INTO tpz_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","A poa manot to vavaiu ne poë, keꞌ onöt o kukön poen, pare ep in poë to teꞌ non koman a Iuun Hinhin Apuh, eꞌ to teꞌ topnin e non po teꞌ vavaasis to nat i ne o Vavaasis pe Mosës. Eꞌ to pënton non a ma soe pee, pareꞌ ihi non raoe a ma hi. ");
INSERT INTO tpz_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","A ma napan to pënton a ma soe peꞌ, pare töhkak in o nat me a ma soe peꞌ, me a ma piun neꞌ to pinpiun non raoe. ");
INSERT INTO tpz_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ka poa manot ep in poë, pare pah töhkak ee, ke sinaneah soe ke poan, “Eën nok va ka möm manih suk ataeah? E tamömah me eöꞌ to pah karë e nem, suk a ö nemöm to me iu vah ka oah.” ");
INSERT INTO tpz_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ke Ieesuꞌ piun raoe ko soe pan, “Eöm vaiu suk vah nem neoꞌ ataeah? Eöm hikta nat nem, a ö nöꞌ to teꞌ e noꞌ pa iuun pe Tamön, öh?” ");
INSERT INTO tpz_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ivëhkëk, a poa manot to hikta nat vamaaka ne pa pusun in a soe ne Ieesuꞌ to soe ke raoe. ");
INSERT INTO tpz_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ivëh, ke Ieesuꞌ hah me en pe sinan pen tamaneah manuh pa vöön pee Nasarët, eꞌ to vavatet rakah non a ma soe pe sinan pen tamaneah. Ke sinaneah ötöön kurus rakah e non pa ma tah manih po kupu peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ke Ieesuꞌ apuh en, ko nat vih peꞌ tavus vateeraꞌ rakah en, ke Sosoenën me a napan pah iu rakah e ne peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","O pöh havun me o tönim kirismas ne Taëberius Sisaꞌ to teꞌ non a teꞌ sunön pa matop a kaman va pa ma muhin kurus va Room. Ko va 16 kirismas peꞌ manih pa kaman e Ponsius Paëlat to teꞌ non a teꞌ susun va pa muhin va Jiutiaꞌ. Ke Hëërot to teꞌ non a teꞌ susun to matop non a muhin va Galiliꞌ. Ke kea peꞌ e Filip to teꞌ non a teꞌ susun to matop non a muhin va Ituriaꞌ me Trakonitis, ke Lisanias to teꞌ non a teꞌ susun to matop non a muhin va Abilene. ");
INSERT INTO tpz_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ke Anas pen Kaëfas to teꞌ nee o Teꞌ Susun po Teꞌ Ësës Heꞌ pa ö ne Jon e sunaiꞌ Sëkaraëaꞌ to teꞌ non pa moeh upin, ka soe pe Sosoenën nö maꞌ manih peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ivëh, ke Jon nö en pa ma ö kurus to teꞌ ne sinten a ruen Jödën, pareꞌ vavatvus non a soe pe Sosoenën, pan a ma napan se pënton, ko panih a ma taateꞌ hat, pare pupui rea, ke Sosoenën se ihan anoe rapoë pa ma hat pee. ");
INSERT INTO tpz_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Eꞌ to teꞌ va non manih pa ö no a teꞌ vanënën soe eꞌ Aisaëaꞌ to kiun vavoh po Puk pe Sosoenën pan, “Manih pa moeh upin a pah teꞌ to vavaoe no maꞌ pan, ‘Vamatop öm a hanan pe Sunön, paröm vatotoopin a ma hanan peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","A ma ö kokoveꞌ söm peepe kee totoopin, ko hohoe a ma tope apaꞌpuh me tope sosoneꞌ, kee riun, ka ma hanan kikirun neöm se vatotoopin. Ka ma ö puhpuh neöm se een variriun. ");
INSERT INTO tpz_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ka ma napan se ep in a kiu vih pe Sosoenën pa ö neꞌ se kon hah a ma napan kurus.’” ");
INSERT INTO tpz_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","A ma napan peo rakah to nö maꞌ manih pe Jon, pan e Jon se pupue raoe, ke Jon soe ke raoe pan, “Eöm to teꞌ rakah va e nem manih po kuruꞌ to rurusin këh ne o suraꞌ. Eteh to kömköm a neöm, köm rurusin këh e nem po heve pe Sosoenën neꞌ to se vanö maꞌ? ");
INSERT INTO tpz_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Eöm se panih, paröm këh a ma taateꞌ hat, ko vataare a panih manih pa taateꞌ peöm. Paröm nat nem soe vamanih pan, ‘E Abraham e sipuura, ivëh, ke Sosoenën hikta se vakmis a rora a ma vuteꞌ peꞌ.’ Eöꞌ to soe vaman rakah ka neöm, e Sosoenën to onöt e non pa vateꞌ a ma vös varih, kee tarih ee a ma pus koaꞌ pe Abraham. ");
INSERT INTO tpz_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","A ipoaꞌ pe Sosoenën to vamatop e non pa taka a ma naon manih pa ma aan in a ma naon kurus varih to hikta vovoaꞌ ne a ma voaꞌ vih, a ma naon poë varih se moes, ko vi po suraꞌ, kee ës.” ");
INSERT INTO tpz_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","E Jon to soe vamanih ka napan to teꞌ ne, hi poë pan, “Emöm se poꞌ nok ataeah, ko vaniu këh po vakmis vëh ne Sosoenën se nok manih po teꞌ hat?” ");
INSERT INTO tpz_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ke Jon piun raoe, pareꞌ soe pan, “A teꞌ to vaneah non o pöök ohop, eꞌ se heꞌ o paeh ohop manih pa teꞌ arus, ka teꞌ to öt non a taëën peo, eꞌ se aavë me a teꞌ to kökööt non.” ");
INSERT INTO tpz_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","A ma pah teꞌ kokon takis to nö maꞌ, pan e Jon se pupui raoe, pare hi e Jon pan, “Tövavaasis, emöm se poꞌ nok ataeah?” ");
INSERT INTO tpz_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ke Jon piun raoe, pareꞌ soe pan, “Eöm se kokon varoe nem a ma moniꞌ pa ö neꞌ to onöt va non, paröm koe a kon oah ta ma meh moniꞌ koman peöm.” ");
INSERT INTO tpz_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","A nap vëvënsun to teꞌ ne nën to hi poë pan, “Emöm poꞌ se nok ataeah?” Ke Jon piun raoe, pareꞌ soe pan, “Eöm se koe a piuk ro teꞌ ko vaꞌnaöp raoe ko kon akuk a ma moniꞌ pee. Eöm se teꞌ vaeö me nem po voen peöm.” ");
INSERT INTO tpz_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","A ma napan to anoeh tamoaan voh ne, pan e Kristo se nö maꞌ. Ivëh, kee ep ko pënton a ma tah ne Jon to nonok non pare kokoman vapiun e ne pan e Jon e Kristo, ko vaiihi koman e ne pan, “A teꞌ kovëh eꞌ e Kristo, oh?” ");
INSERT INTO tpz_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ivëh ke Jon piun raoe, pareꞌ soe pan, “Eöꞌ to pupui a noꞌ neöm pa ruen, ivëhkëk, amot a pah teꞌ se suk a maꞌ neoꞌ no o kikis peꞌ to teꞌ oah e non po teꞌ kikis peöꞌ. Eöꞌ to hikta teꞌ vih onöt noꞌ a ihan këh eah o uris vëh pa poa suꞌ peꞌ. Eꞌ se pupui a neöm pa Tuvuh Vasioꞌ me o suraꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Eꞌ se nö maꞌ, ko pitöꞌ këh a kon hat manih pa kon vih peꞌ. Pareꞌ ununun a kon vih manih pa iuun vavahoꞌ kon peꞌ. Ko ës en pa ma kon hat manih po suraꞌ ësës tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","E Jon to heꞌ a ma vavaasis peo pa vamaaka o kokoman pa napan, me a ma soe vih manih pa ma napan. ");
INSERT INTO tpz_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","22","A ma napan kurus varih to panih to nö maꞌ, ke Jon pupui vahik en pee. E Ieesuꞌ me ne Jon to pupui poan. Ke Ieesuꞌ to hinhin avoeꞌ e non ka akis nö vakëh. Ka Tuvuh Vasioꞌ kunah maꞌ manih pe Ieesuꞌ, vamanih pa panuh. Ka to taneꞌ maꞌ manuh pa vöön va kin to soe va non manih pan, “Eën e koaꞌ rakah peöꞌ, eöꞌ to iu oah vi ka nom oah, paröꞌ vaeö me nom oah.” E Jon to siröꞌ e Hëërot, a teꞌ susun to matop non a kaman va Galiliꞌ, suk e Hëërot to vaen pen e Hëëroteas e töveneah, e köövo pe kea soneꞌ peꞌ, Filip, me a ma meh tah hat peo neꞌ to nonok voh non sih. E Hëërot to nok voh a ma meh hat apaꞌpuh, ivëhkëk, a hat vëh pa ö neꞌ to vahoꞌ e Jon pa nohnoh to teꞌ apuh oah rakah e non. ");
INSERT INTO tpz_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","E Ieesuꞌ to taneo a kiu peꞌ eꞌ he teꞌ non o 30 kirismas. A ma napan to sosoe ne pan e Ieesuꞌ e koaꞌ pe Jeosëp, ke Jeosëp e koaꞌ pe Heliꞌ, ");
INSERT INTO tpz_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ke Heliꞌ e koaꞌ pe Matat, ke Matat e koaꞌ pe Livaë, ke Livaë e koaꞌ pe Mëlkiꞌ, ke Mëlkiꞌ e koaꞌ pe Janaëꞌ, ke Janaëꞌ e koaꞌ pe Jeosëp, ");
INSERT INTO tpz_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ke Jeosëp e koaꞌ pe Matatias, ke Matatias e koaꞌ pe Amos, ke Amos e koaꞌ pe Nahum, ke Nahum e koaꞌ pe Ësliꞌ, ke Ësliꞌ e koaꞌ pe Nagaëꞌ ");
INSERT INTO tpz_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ke Nagaëꞌ e koaꞌ pe Mat, ke Mat e koaꞌ pe Matatias, ke Matatias e koaꞌ pe Semen, ke Semen e koaꞌ pe Josëk, ke Josëk e koaꞌ pe Jodaꞌ, ke Jodaꞌ e koaꞌ pe Joanan, ");
INSERT INTO tpz_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ke Joanan e koaꞌ pe Resaꞌ, ke Resaꞌ e koaꞌ pe Serubabël, ke Serubabël e koaꞌ pe Sealtiël, ke Sealtiël e koaꞌ pe Neriꞌ ");
INSERT INTO tpz_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ke Neriꞌ e koaꞌ pe Mëlkiꞌ, ke Mëlkiꞌ e koaꞌ pe Adiꞌ, ke Adiꞌ e koaꞌ pe Kosam, ke Kosam e koaꞌ pe Elmadam, ke Elmadam e koaꞌ pe Er, ");
INSERT INTO tpz_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ke Er e koaꞌ pe Josuaꞌ, ke Josuaꞌ e koaꞌ pe Eliësaꞌ, ke Eliësaꞌ e koaꞌ pe Jorim, ke Jorim e koaꞌ pe Matat, ke Matat e koaꞌ pe Livaë, ");
INSERT INTO tpz_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ke Livaë e koaꞌ pe Simeon, ke Simeon e koaꞌ pe Judaꞌ, ke Judaꞌ e koaꞌ pe Jeosëp, ke Jeosëp e koaꞌ pe Jonam, ke Jonam e koaꞌ pe Eliakim, ke Eliakim e koaꞌ pe Meleaꞌ, ");
INSERT INTO tpz_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ke Meleaꞌ e koaꞌ pe Menaꞌ, ke Menaꞌ e koaꞌ pe Matataꞌ, ke Matataꞌ e koaꞌ pe Netan, ke Netan e koaꞌ pe Devit, ");
INSERT INTO tpz_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ke Devit e koaꞌ pe Jësiꞌ, ke Jësiꞌ e koaꞌ pe Obet, ke Obet e koaꞌ pe Boas, ke Boas e koaꞌ pe Salmon, ke Salmon e koaꞌ pe Nason, ");
INSERT INTO tpz_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ke Nason e koaꞌ pe Aminadëp, ke Aminadëp e koaꞌ pe Atmin, ke Atmin e koaꞌ pe Ani, ke Aniꞌ e koaꞌ pe Hësron, ke Hësron e koaꞌ pe Perës, ke Perës e koaꞌ pe Judaꞌ, ");
INSERT INTO tpz_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ke Judaꞌ e koaꞌ pe Jekop, ke Jekop e koaꞌ pe Aësak, ke Aësak e koaꞌ pe Abraham, ke Abraham e koaꞌ pe Tëraꞌ, ke Tëraꞌ e koaꞌ pe Nehöꞌ, ");
INSERT INTO tpz_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ke Nehöꞌ e koaꞌ pe Seruk, ke Seruk e koaꞌ pe Reuꞌ, ke Reuꞌ e koaꞌ pe Pelek, ke Pelek e koaꞌ pe Ibaꞌ, ke Ibaꞌ e koaꞌ pe Siraꞌ, ");
INSERT INTO tpz_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ke Siraꞌ e koaꞌ pe Kaënan, ke Kaënan e koaꞌ pe Apaksat, ke Apaksat e koaꞌ pe Siëm, ke Siëm e koaꞌ pe Noaꞌ, ke Noaꞌ e koaꞌ pe Lemëk, ");
INSERT INTO tpz_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ke Lemëk e koaꞌ pe Mëtusulaꞌ, ke Mëtusulaꞌ e koaꞌ pe Inök, ke Inök e koaꞌ pe Jërët, ke Jërët e koaꞌ pe Mahalalel, ke Mahalalel e koaꞌ pe Kenan, ");
INSERT INTO tpz_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ke Kenan e koaꞌ pe Inös, ke Inös e koaꞌ pe Sët, ke Sët e koaꞌ pe Adam, ke Adam e koaꞌ pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","E Ieesuꞌ to teꞌ avoeꞌ e non pa ruen Jödën pa ö ne Jon to pupui vahik poan, ka Tuvuh Vasioꞌ to puh rakah non manih peꞌ. Keꞌ hah taneꞌ maꞌ ruen Jödën, ko nönö non maꞌ, ka Tuvuh Vasioꞌ me en peꞌ pa moeh upin. ");
INSERT INTO tpz_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Manih pa ma poen poë varih neꞌ to hikta ënëën non. Ke susun po oraꞌ hat pupunöꞌ non poan po 40 poen. Ka ma poen varih to hik ee, keꞌ maë vörep. ");
INSERT INTO tpz_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ke susun po oraꞌ hat soe ke Ieesuꞌ pan, “Eën se keh teꞌ nom pan eën e Koaꞌ pe Sosoenën, kën taꞌ a vös vëh, keꞌ panih, pareꞌ tarih en o muꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ke Ieesuꞌ piun va in a soe pe susun po oraꞌ hat manih pan, “O Puk Vapenpen to soe ka rora sih pan, ‘A taëën varoe to hikta onöt non a heꞌ o toꞌtoꞌ tamoaan manih pa napan.’” ");
INSERT INTO tpz_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ke susun po oraꞌ hat me peah en pe Ieesuꞌ manuh pa tope vakin, pareꞌ vataare vëhöꞌ en peꞌ pa ma muhin kurus. ");
INSERT INTO tpz_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ke susun po oraꞌ hat soe ken pe Ieesuꞌ pan, “A ma kikis kurus varih me o ëhnan apuh nöꞌ to vaneah noꞌ, eöꞌ se heꞌ eoꞌ pa meh teꞌ pa ö söꞌ iu noꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Eën se keh vatokon, parën kë a ëhnaneoꞌ, eën se vaneah kurus e nom pa ma tah poë varih.” ");
INSERT INTO tpz_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ke Ieesuꞌ piun va in a soe pe susun po oraꞌ hat vamanih pan, “O Puk Vapenpen to soe va non manih pan, ‘Eën se kë varoe ko nom a ëhnan e Sunön Sosoenën pën. Parën vatet varoe ko nom o iu peꞌ.’” ");
INSERT INTO tpz_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ke susun po oraꞌ hat me e Ieesuꞌ manuh Jerusalëm, pareꞌ me peah en peꞌ manuh pa ö noton in a Iuun Hinhin Apuh, pareꞌ soe ke poan pan, “Eën se nom teꞌ nom, pan eën e Koaꞌ vamaman pe Sosoenën, kën surap taneꞌ manih, parën vuꞌ kunah eom na manuh po oeh. ");
INSERT INTO tpz_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Suk o Puk Vapenpen to soe non pan, ‘E Sosoenën se soe ke ro ankeroꞌ peꞌ, kee ut vavih rakah e ne pën.’” ");
INSERT INTO tpz_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","“Eꞌ to soe pet non pan, ‘O ankeroꞌ se öt ee pën pa ma koreere, ka hikta pah vös to onöt non a ruk a momah.’” ");
INSERT INTO tpz_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ke Ieesuꞌ piun poan, pareꞌ soe pan, “O Puk Vapenpen to soe pet e non pan, ‘Eën se nat nom pupunöꞌ nom pa vöknah e Sunön pën e Sosoenën.’” ");
INSERT INTO tpz_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","E susun po oraꞌ hat to punöꞌ vahik e Ieesuꞌ a ma vu punöꞌ, pareꞌ nö en, ko anoeh e non po meoh poen. ");
INSERT INTO tpz_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","E Ieesuꞌ to hah en manuh pa muhin va Galiliꞌ, ko kikis pa Tuvuh Vasioꞌ teꞌ vaꞌpeh me e non peꞌ. Ko vahutët va peꞌ nö vavah en pa ma ö muhin kurus va Galiliꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","A ma tamoaan ne Ieesuꞌ to vavaasis non sih pa ma koman iuun hinhin soneꞌ, ka napan kurus poë varih kë rakah e ne pa ëhnaneah. ");
INSERT INTO tpz_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","E Ieesuꞌ to hah en manuh vöön Nasarët. Pa vöön neꞌ to teꞌ voh non eꞌ he a koaꞌ. Po Poen Apaapo neꞌ to ho en pa iuun hinhin soneꞌ vamanih pa ö neꞌ to nonok tamoaan va non sih, eꞌ to sun pan, eꞌ se ëh a soe to teꞌ non po Puk Vapenpen manih pa napan. ");
INSERT INTO tpz_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ka teꞌ to matop non o puk heꞌ en peꞌ po puk to kiun non a ma soe voh pa teꞌ vanënën soe Aisaëaꞌ, ke Ieesuꞌ kap en po puk, pareꞌ taum en po vahutët to kiun va non manih pan, ");
INSERT INTO tpz_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“A Tuvuh pe Sunön to teꞌ non manih peöꞌ, pareꞌ vateꞌ a neoꞌ marën a vatvus a Soe Vih manih po teꞌ arus. Eꞌ to vanö a maꞌ neoꞌ, köꞌ nö maꞌ pa vatvus a soe to soe va non manih pan, ‘Eöm varih a napan to teꞌ nem sih manih pa nohnoh, Eöm se këh em pa nohnoh, paröm nö em, ke eöm varih a nap kekehoꞌ, eöm se opoep hah em. A Tuvuh pe Sosoenën to vanö a maꞌ neoꞌ, marën a vahik a ma punis po teꞌ, no a ma meh teꞌ to vöknah ne raoe. ");
INSERT INTO tpz_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Me a ö nöꞌ se vatvus a soe po poen vih vëh, ne Sunön se kon hah a napan peꞌ.’” ");
INSERT INTO tpz_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","E Ieesuꞌ to vakop hah o puk, pareꞌ heꞌ en pa teꞌ mamatop puk, pareꞌ ihoꞌ en, ka napan varih to teꞌ ne koman iuun hinhin soneꞌ vi matan rakah ee pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ke Ieesuꞌ taneo en pa vavaasis ra napan pan, “Kuru vaꞌih no a soe va po Puk Vapenpen to tavus vaman rakah en, köm pënton vahik voh em peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","A napan to vavaasin e ne poë, pare pah kokoman vörep e ne pa ma Soe Vih varih neꞌ to vatvus. Ivëhkëk, ee to soe pan, “Eꞌ pöꞌ kuru e koaꞌ pe Jeosëp?” ");
INSERT INTO tpz_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ke Ieesuꞌ soe ke raoe pan, “Eöm to pënton voh em pa soe to soe non pan, ‘Vataare a möm ah, pan eën e röktaꞌ pa ö sën vavih koman hah eöm pa sioniumah’. A pusun in a soe pamëh to soe vamanih pan, ‘Eën se keh teꞌ nom pan, eën e Kristo, a, eën se nok a ma tah vatoksean manih koman a vöön pea vamanih pa ö nemöm to pënton pan eën to nok vavoh manuh pa vöön va Kapaneam.’” ");
INSERT INTO tpz_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ke Ieesuꞌ vavaato avoeꞌ ke non pee, pareꞌ soe pan, “Eöꞌ to soe vaman rakah keoꞌ peöm, a teꞌ vanënën soe nee to hikta iu ne poë manih pa vöön koman peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pënton a neoꞌ öm, eꞌ to teꞌ moaan vavoh e non manih Israël, o köövo amop peo to teꞌ voh ne po poen ne Elaëjaꞌ to teꞌ voh non. Po poen voh pamëh no a uhön to hikta nus po kukön kirismas me a tönim sivö me a paeh. Pareꞌ teꞌ voh non o maë apuh rakah to tavus voh pa muhin avoes va Israël. ");
INSERT INTO tpz_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ivëhkëk, e Sosoenën to hikta vanö voh e Elaëjaꞌ manih pa ta paeh pee. Ahik, e Sosoenën to vanö varoe poan manuh pa köövo amop va Sarefat manih pa muhin va Saëdon. ");
INSERT INTO tpz_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Keꞌ teꞌ me voh va e non nën manih po poen voh pa teꞌ vanënën soe e Elaëjaꞌ. A nap peo va Israël to teꞌ me voh ne a mët vëh a töpaꞌ. Ivëhkëk, a hikta paeh va voh pee no a mët peꞌ to hik. E Naman va Siriaꞌ varoe kuru no a mët töpaꞌ peꞌ to hik.” ");
INSERT INTO tpz_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","A napan kurus varih to teꞌ ne koman iuun hinhin soneꞌ to pënton a soe vaꞌih, pare pah heve suntan rakah ee. ");
INSERT INTO tpz_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","A napan to sun, pare veo tavus ee pe Ieesuꞌ këh a vöön pee. A vöön pamëh to teꞌ non pa tope, ivëh, kee me ee pe Ieesuꞌ pa sinten in a tope vëh no a vöön pee to eok non. Pare kehkeh vi kunah ne na poë pa vaere. ");
INSERT INTO tpz_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ivëhkëk, e Ieesuꞌ to koe pa topniire, pareꞌ nö këh en pee. ");
INSERT INTO tpz_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","E Ieesuꞌ to kunah en Kapaneam, eꞌ a vöön to teꞌ non pa muhin va Galiliꞌ, ko Poen Apaapo neꞌ to vavaasis non a napan, ");
INSERT INTO tpz_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ka napan pënton a ma vavaasis peꞌ, pare töhkak vahat ee, suk a soe peꞌ to teꞌ rakah me non o kikis. ");
INSERT INTO tpz_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Manih pa koman a iuun hinhin soneꞌ no a pah teꞌ to teꞌ non no a oraꞌ hat to teꞌ non peꞌ, eꞌ to pah kokoeꞌ suntan rakah en pan, ");
INSERT INTO tpz_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ieesuꞌ va Nasarët, eën nö maꞌ pa nok ataeah manih pemöm? Eën to nö pöꞌ maꞌ pa miröꞌ a möm, eöꞌ to nat e noꞌ pën a Teꞌ Vivihan pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ivëhkëk, e Ieesuꞌ to siröꞌ a oraꞌ hat pamëh, pareꞌ soe pan, “Vatotomin ah! Parën këh tavus maꞌ a teꞌ manem.” Ka oraꞌ hat pamëh kö vörep en pa teꞌ, pareꞌ vi en peꞌ manih po oeh topniira napan, pareꞌ këh tavus en peꞌ, ko hikta mimiröꞌ hah non poan. ");
INSERT INTO tpz_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ka napan vatötöhkak rakah ee, pare taneo ee pa vaiihi koman hah pan, “O vu soe taeah rakah ivaꞌih? O kikis taeah no a teꞌ vëh to teꞌ me non, keꞌ taꞌ a oraꞌ hat, keꞌ tavus këh en pa teꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ivëh, ko vahutët va pa tah ne Ieesuꞌ to nok, nö vavah en pa ma ö kurus. ");
INSERT INTO tpz_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","E Ieesuꞌ to këh tavus maꞌ a iuun hinhin soneꞌ, pareꞌ nö en manuh pa iuun pe Saëmon. E noan Saëmon to haraꞌ suntan rakah non a hiinana, ivëh, ka napan vaoe na e Ieesuꞌ marën a vaꞌaus poan. ");
INSERT INTO tpz_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ke Ieesuꞌ nö maꞌ, pareꞌ sun pa havineah, pareꞌ siröꞌ a hiinana, ka hiinana hik rakah këh en peꞌ. Ivëh, ka varuꞌ rakah vakomanih ne köövo to sun ko vamatop en pa taëën pee. ");
INSERT INTO tpz_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","A potan to kunah en, ka napan me ee maꞌ pa ma poëëre to haraꞌ ne a ma vu mët, ke Ieesuꞌ vaket papaeh raoe, ka ma mët pee hik ee. ");
INSERT INTO tpz_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ko oraꞌ hat poë varih këkëh tavus e ne maꞌ pa napan, pare kokoeꞌ papaeh ne, ko sosoe ne pan, “Eën e Koaꞌ pe Sosoenën.” Ke Ieesuꞌ soepip raoe pa vaato, suk ee to nat e ne peꞌ e Kristo, a teꞌ vëh ne Sosoenën to vanö voh maꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Po meoh poen pa pöstakah rakah ne Ieesuꞌ to sun, ko këh en pa iuun, pareꞌ nö en pa ö totomin hikta teꞌ, ka napan taneo ee pa vaiu poë. Ko poen nee to taum poë, pare kehkeh amun ne poë pan eꞌ se nat non nö pa ta meh vöön. ");
INSERT INTO tpz_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ivëhkëk, e Ieesuꞌ to soe ke raoe pan, “Eöꞌ se nö pet pa vatvus a Soe Vih va pa Matop Vih pe Sosoenën manuh pa ma meh vöön. Peꞌ a tah nöꞌ to nö suk voh maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ivëh, ke Ieesuꞌ nö vavah en pa vavaasis a ma napan manih koman a ma iuun hinhin soneꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","O pöh poen ne Ieesuꞌ to sun non pa sinten a tonon va Gënesaret, ka napan peo rakah to tönun ko vatotot maꞌ marën a pënton a soe pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ke Ieesuꞌ ep o pöök paröꞌ to atan ne sinten a tonon, no o teꞌ tatanaꞌ iian to kunah këh ee po pöök paröꞌ, pare pupui ne a ma kë pee. ");
INSERT INTO tpz_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ke Ieesuꞌ peah en po pöh paröꞌ, eꞌ o paröꞌ pe Saëmon, ko soe ke Saëmon pan eꞌ se vapeah amot o paröꞌ manuh pa ö ruruvun. Ke Ieesuꞌ ihoꞌ non po paröꞌ, pareꞌ vavaasis non a ma napan. ");
INSERT INTO tpz_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","E Ieesuꞌ to vahik vaato pareꞌ soe ke Saëmon pan, “Hoaꞌ peah nös öm manuh pa ö ruruvun, ke eën me a ma upöm pën se vöknah a kë peöm ko rëh ta ma iian.” ");
INSERT INTO tpz_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ke Saëmon piun e Ieesuꞌ, pareꞌ soe pan, “Apuh, pa popoen rë vaꞌih ne möm to kiu vëhvaꞌ rakah em, ivëhkëk, emöm to hikta rëh ta pah iian. Ivëhkëk, peꞌ eën to soe ka möm, emöm se vöknah em pa kë.” ");
INSERT INTO tpz_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ee to vatet ee pa ö ne Ieesuꞌ to soe ava, pare rëh ee po iian o pöh peo rakah. Ka siꞌ ö hat ka ma kë pee tötökurus ee. ");
INSERT INTO tpz_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ivëh, kee vaoe o upöm pee po meoh paröꞌ, kee nö maꞌ ko vaꞌaus rapoë. Ee to nö maꞌ, pare rëh o iian o pöh peo vörep, pare vapuh o pöök paröꞌ ka siꞌ hat ö ko pöök paröꞌ rokoꞌ ee tahiꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ke Saëmon Pitaꞌ ep a tah vaꞌih, pareꞌ vatokon pa sinten mon e Ieesuꞌ, pareꞌ soe pan, “Apuh, këh na neoꞌ ah. Eöꞌ a teꞌ nonok hat.” ");
INSERT INTO tpz_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","E Saëmon Pitaꞌ me a ma upöm peꞌ to ep o iian peo varih nee to rëh, ko pah toksean ko vavamui e ne. ");
INSERT INTO tpz_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","A poa koaꞌ pe Sëbëdiꞌ, e Jëmis pen Jon, eꞌe a poa vakamöꞌ pe Saëmon to pah toksean ee. Ke Ieesuꞌ soe ke Saëmon, “Koe a naöp, taneo non kuru nën se me hop maꞌ a napan, kee vatet a neoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kee hoaꞌ takin hah ee manuh po kösan, pare këh ee pa ma tah kurus pee, pare vatet ee pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","E Ieesuꞌ to teꞌ non vöön, ka pah teꞌ to teꞌ me non a mët töpaꞌ nö maꞌ manih peꞌ, ko vatokon ko vuꞌ rakah manih po oeh, ko hin pan, “Apuh, eën se keh iu nom kën vatoꞌ hah eom peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ke Ieesuꞌ vaket poan, pareꞌ soe pan, “Eöꞌ to iu e noꞌ. Voon ah.” Ka varuꞌ vakomanih no a mët töpaꞌ to hik këh en peꞌ keꞌ toꞌ hah en. ");
INSERT INTO tpz_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ke Ieesuꞌ vuhvuh vakis poan pan, “Eën se nat nom vavatët ta meh teꞌ a tah vaꞌih to tanok manih pa sioniumah. Ivëhkëk, eën se nö ko vataare a sioniumah manih pa teꞌ ësës heꞌ, parën heꞌ o heꞌ pën. Ka napan se nat ne a ö no a mët pën to hik hah en, vamanih pa ö no Vavaasis pe Mosës to soe vavoh.” ");
INSERT INTO tpz_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ivëhkëk, o vahutët va pa ma tah ne Ieesuꞌ to nok nö vavah en pa ma ö kurus. Ka napan o pöh peo rakah to nö maꞌ manih peꞌ pa tënan o vavaasis peꞌ, me e Ieesuꞌ se vahik a ma mët pee. ");
INSERT INTO tpz_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ivëhkëk, e Ieesuꞌ to nönö tamoaan non pa moeh totomin, pareꞌ hinhin non nën. ");
INSERT INTO tpz_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","O pöh poen ne Ieesuꞌ to vavaasis non a napan ka ma Parësiꞌ, me ro teꞌ vavaasis to ihoꞌ ne. Ee to taneꞌ maꞌ pa ma vöön va pa muhin va Galiliꞌ, me a muhin va Jiutiaꞌ, me a vöön apuh pee Jerusalëm. Ko kikis pe Sosoenën teꞌ non manih peꞌ, marën a vahik a ma mët pa napan. ");
INSERT INTO tpz_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ka ma pah teꞌ, teꞌ ee maꞌ pa pah teꞌ to koroh non po pan peꞌ. A sionin a teꞌ pamëh to teꞌ me voh non a mët tëtënkun. Ee to iu teꞌ ho ne poë manuh koman iuun pa vahoꞌ poë pa havin e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Suk ataeah, a napan to peo kee hikta onöt ne a teꞌ ho a teꞌ. Ivëh, kee peah tonun iuun, pare tai ee pa ma pah si vös in a tonun iuun pamëh, pare vöknah poꞌ a teꞌ pamëh to koroh non po pan topnin a napan, pare vahoꞌ poë matan e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","E Ieesuꞌ to inan o vaman pee, pareꞌ soe pan, “Teꞌ peöꞌ, eöꞌ to ihan anoe eoꞌ pa ma hat pën.” ");
INSERT INTO tpz_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","O teꞌ vavaasis to nat i ne o Vavaasis pe Mosës me ro Parësiꞌ to ep a tah vaꞌih, pare vavasoe koman e ne pan, “A teꞌ rakah vëh eteh, pareꞌ sosoe oꞌoah e non pe Sosoenën? A hikta pah teꞌ rakah to onöt non a ihan anoe a hat pa meh teꞌ. E Sosoenën varoe to antoen non a ihan anoe a ma hat po teꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","E Ieesuꞌ to nat vahik vur en po kokoman pee, ivëh, keꞌ piun a soe pee, pareꞌ soe pan, “Eöm kokoman vakëkëh va nem manih suk ataeah? ");
INSERT INTO tpz_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Eꞌ hikta teꞌ hivaꞌ non pa soe ke a teꞌ tëtënkun pan, ‘A ma hat pën nöꞌ to ihan anoe’. Suk ataeah, o upöm teꞌ hikta antoen ne a inan vamanih pan a ma hat peꞌ to hik ee. Ivëhkëk, eꞌ to hivaꞌ oah e non pa soe ke a teꞌ tëtënkun pan, ‘Eën se sun, ko nö eom.’ Suk ataeah, a ma napan se ep ne pan a teꞌ pamëh to toꞌ hah en. ");
INSERT INTO tpz_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ivëhkëk, eöꞌ se vamaaka ka neöm ta pah tah, köm se vaman, ko nat ka neoꞌ e Koaꞌ Teꞌ Pa Napan Kurus to teꞌ me noꞌ pa tasun manih po oeh marën a ihan anoe a ma hat.” Ivëh, ke Ieesuꞌ soe ke a teꞌ tëtënkun pamëh pan, “Eöꞌ to soe ka oah, sun ah, parën kon o pan pën, parën nö eom manuh pa iuun pën.” ");
INSERT INTO tpz_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ka varuꞌ vakomanih a napan to ut ne a teꞌ pamëh to sun vëvëhöꞌ rakah en, pareꞌ kon o pan neꞌ to koroh vu non, ko nö en pa iuun peꞌ. Pareꞌ kë rakah en pa ëhnan e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ka ma napan varih to ut ne vatötöhkak rakah ee, pare kë rakah ee pa ëhnan e Sosoenën, ka ma kokoman pee nun, kee toksean rakah ee. Ee to soe, “Kuru, nea to ep a tah to matan ke rakah e non.” ");
INSERT INTO tpz_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Vasuksuk ne Ieesuꞌ to nö, pareꞌ ep in a pah teꞌ kokon takis to ihoꞌ non pa iuun kokon takis. A ëhnaneah e Livaë. E Ieesuꞌ to soe ke poan pan, “Suk a maꞌ neoꞌ ah.” ");
INSERT INTO tpz_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ke Livaë sun, pareꞌ këh en pa ma tah kurus peꞌ, ko vatet en pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","E Livaë to vamatop a taëën apuh pe Ieesuꞌ manih pa iuun peꞌ. A nap kokon takis peo me a ma upöm teꞌ, ee kurus to vavaëën me ne Ieesuꞌ pen Livaë. ");
INSERT INTO tpz_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ko Parësiꞌ, me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës to pah vavasoe vörep suk e ne pa ma vamomhë pe Ieesuꞌ pan, “Eöm vavaëën vaꞌpeh me nem a nap kokon takis, me ro teꞌ no a ma taateꞌ pee to hat, suk ataeah?” ");
INSERT INTO tpz_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ke Ieesuꞌ piun raoe va manih pan, “O teꞌ varih to hikta haraꞌ ne a mët, eꞌe to hikta nönö ne pa ep e röktaꞌ. Ahik. A napan varoe varih to haraꞌ ne a mët to nönö ne pe röktaꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Eöꞌ to hikta nö voh maꞌ pa vaꞌaus o teꞌ varih to koman ne pan ee ro totoopin. Ahik. Eöꞌ to nö voh maꞌ pa vaꞌaus o teꞌ varih to nat va ne manih pan ee ro teꞌ hat. Ivëh, kee se panih o kokoman me a taateꞌ pee.” ");
INSERT INTO tpz_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","A ma pah teꞌ to soe ke Ieesuꞌ va manih pan, “O vamomhë pe Jon to vapenpen ne a taëën, pare hinhin tamoaan rakah ne sih. Ko vamomhë po Parësiꞌ to vapenpen pet me e ne pa taëën. Ivëhkëk, a ma vamomhë pën to ënëën e ne, pare kakaak e ne.” ");
INSERT INTO tpz_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ke Ieesuꞌ heꞌ raoe a soe vapipinoꞌ, pareꞌ soe pan, “Eꞌ to vih pöꞌ e non pa ma teꞌ pe voe tövaen vavoon se vapenpen ne pa taëën? Ahik rakah. E voe tövaen vavoon se keh teꞌ vaꞌpeh me non raoe, ee hikta se vapenpen ne pa taëën. Suk ataeah, ee to vaeö me ne e voe tövaen vavoon. ");
INSERT INTO tpz_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ivëhkëk, a ma poen se tavus maꞌ no a ma meh teꞌ se me ke a teꞌ tövaen vavoon, keꞌ hikta teꞌ hah me non a ma teꞌ peꞌ. Manih pa ma poen poë varih eꞌe se vapenpen ee pa taëën. Suk ataeah, ee to tamak ne poë.” ");
INSERT INTO tpz_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ke Ieesuꞌ heꞌ raoe a meh soe vapipinoꞌ, pareꞌ soe pan, “A hikta pah teꞌ to onöt non a kurus a tah rara voon marën a kun pip a töhkoꞌ manih po rara vamoaan. Ta pah teꞌ se këh nok va nën eꞌ se miröꞌ en po rara voon, ko rara voon pamëh hikta se matan vatoe me non o rara vamoaan.” ");
INSERT INTO tpz_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","39","Eꞌ to vatoe me e non po pëk no a napan to kun po kap sipsip pa isu o voaën. Ahikta teꞌ se isu o voaën voon manih po pëk vamoaan nee to kun po kap sipsip. Eꞌ se keh isu en po voaën voon, o voaën voon se kurus en po pëk vamoaan. Suk o pëk vamoaan to hikta onöt non a tëptot. Ivëh, ko pëk se tökrus en ko voaën takoꞌ en. Ahik, eöm se isu o voaën voon manih po pëk voon nee to kun po kap sipsip. A napan hikta iu kaak ne o voaën voon, pee to atö voh ee pa kaak o voaën vamoaan. Suk ee to koman va ne manih pan, o voaën vamoaan to vih oah e non po voaën voon.” ");
INSERT INTO tpz_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","O pöh Poen Apaapo ne Ieesuꞌ me a ma vamomhë peꞌ to nönö nö ne topnin a rak vëh nee to nep voh a kon. Ee to kökök a ma voaꞌ kon, pare kakap, ko ëën ee. ");
INSERT INTO tpz_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ivëhkëk, a ma Parësiꞌ to soe pan, “A ma tah varih to vapenpen non po Poen Apaapo pea, eöm nok vamanih suk ataeah?” ");
INSERT INTO tpz_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ke Ieesuꞌ piun raoe, ko soe pan, “Eöm to ëh pöꞌ voh em po vahutët vëh ne Devit to nok voh pa ö neꞌ to maë voh me ra ma vamomhë peꞌ, ha? ");
INSERT INTO tpz_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","E Devit to ho voh pa iuun vapenpen pe Sosoenën, pareꞌ kon a taëën to teꞌ non pa matan e Sosoenën. A taëën pamëh no a hikta teꞌ akuk se ëën. O teꞌ ësës heꞌ varoe to onöt ne a ëën. E Devit me a ma vamomhë peꞌ to ëën ee pa taëën pamëh.” ");
INSERT INTO tpz_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ke Ieesuꞌ soe ken pa napan pan, “Eöꞌ koman e Koaꞌ Teꞌ Pa Napan Kurus to Sunön ke noꞌ po Poen Apaapo.” ");
INSERT INTO tpz_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","O meoh Poen Apaapo ne Ieesuꞌ to ho pa iuun hinhin soneꞌ, pareꞌ heꞌ a soe manih pa ma napan. A pah teꞌ to teꞌ non nën no a papmatö peꞌ to tëtënkun. ");
INSERT INTO tpz_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","O teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, me ro Parësiꞌ to ut ne e Ieesuꞌ se keh vavih hah a teꞌ tënkun koren pamëh po Poen Apaapo, keꞌ ahik. Ee to vaiu këh ne ta hanan nee se vateꞌ e Ieesuꞌ po vahutët. ");
INSERT INTO tpz_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ivëhkëk, e Ieesuꞌ to nat e non po kokoman pee, ivëh, keꞌ soe ke a teꞌ vëh no a koreneah to mët ko tënkun, “Maꞌ ah ko sun manih” Ka teꞌ pamëh sun en. ");
INSERT INTO tpz_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ke Ieesuꞌ soe ke raoe, “Eöꞌ to iu hi a noꞌ neöm a pah hi. Eꞌ to vih pöꞌ e non pea se vaꞌaus a meh teꞌ to haraꞌ non a mët po Poen Apaapo, keꞌ ea se koe ee pa vaꞌaus eah, keꞌ mët en?” ");
INSERT INTO tpz_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","E Ieesuꞌ to vatvi a mataneah manih pa napan, pareꞌ soe ke a teꞌ pamëh pan, “Putot a koreomah.” Eꞌ to putot a koreneah, keꞌ totoopin, ko vih hah en. ");
INSERT INTO tpz_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ivëh, ko teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, me ro Parësiꞌ pah heve suntan e ne pe Ieesuꞌ. Ko vavasoe koman e ne pan, “Ea se nok rakah ataeah manih pe Ieesuꞌ?” ");
INSERT INTO tpz_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Vasuksuk po pöh poen ne Ieesuꞌ to peah manuh pa tope pa hin. Pa popoen pamëh ne Ieesuꞌ to hinhin non manih pe Sosoenën ka muhin takah en. ");
INSERT INTO tpz_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pa pöstakah ne Ieesuꞌ to vaoe ununun en na pa ma vamomhë peꞌ. Ko vateꞌ en po havun teꞌ me a pöök ko vëhnan raoe o aposol peꞌ. Ivarih, a ma ëhnëëre, ");
INSERT INTO tpz_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","a paeh e Saëmon, e Ieesuꞌ to vëhnan poan e Pitaꞌ, ke kea peꞌ Ëndruꞌ, ke Jëmis, pen Jon, ke Filip, ke Batromioꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ke Matiu, ke Tömas, ke Jëmis e sunaiꞌ Apias, ke Saëmon a pah teꞌ va po vakum teꞌ varih nee to pokaꞌ ne ro Sërat. ");
INSERT INTO tpz_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ke Jiutas e sunaiꞌ Jëmis, ke Jiutas Iskariot, to taneꞌ maꞌ Kariot, eꞌ a teꞌ vaꞌih to vikuh e Ieesuꞌ manuh pa koren a nap hat. ");
INSERT INTO tpz_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ke Ieesuꞌ kunah en maꞌ pa moeh riun vaꞌpeh me a havun me a poa vamomhë peꞌ. A ma vamomhë peꞌ me a napan o pöh peo rakah, eꞌe va Jiutiaꞌ me Jerusalëm me manih sinten tahiꞌ pa poa vöön varih Taëaꞌ me Saëdon, ee me to teꞌ vaꞌpeh ne. ");
INSERT INTO tpz_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ee to nö maꞌ pa pënton a soe me e Ieesuꞌ se vavatoꞌ raoe. A ma napan varih no oraꞌ hat to miröꞌ voh, ee me ne Ieesuꞌ to vatoꞌ hah raoe. ");
INSERT INTO tpz_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","A ma napan peo to iu vaket ne e Ieesuꞌ, pan o kikis se taneꞌ maꞌ peꞌ ko vavatoꞌ a ma vu mët pee. ");
INSERT INTO tpz_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ke Ieesuꞌ kuteꞌ non a ma vamomhë peꞌ pareꞌ soe pan, “Eöm a ma napan arus, eöm se vaeö, suk eöm a pap teꞌ poë varih se hop manih pa Matop Vih va pa Vöön va Kin.” ");
INSERT INTO tpz_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Eöm a napan varih to mamaë nem kuru, eöm se vaeö. Suk ataeah, e Sosoenën se makën vamhun en peöm pataeah ne eöm to iu nem. Eöm a napan varih to inan a ma hat peöm ko okook vatamak nem, eöm se vaeö. Amot ne Sosoenën se tapui a napan to kokoman va ne nën. ");
INSERT INTO tpz_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Vaeö rakah peöm varih, no o teꞌ se ep ka no neöm to vavatet a nem neoꞌ E Koaꞌ Teꞌ Pa Napan Kurus, ee se heve e ne peöm, pare veveo vah e ne peöm, ko vateen a neöm pa ma soe hat, ko vëhnan ekeok a neöm, suk eöm to vavatet a nem neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ivëhkëk, eöm se pah teꞌ vaeö rakah e nem, suk o voen vih peöm to anoeh e non maꞌ peöm manuh pa vöön va kin. Ee se nok a ma tah hat manih peöm, ivëh köm se vaeö, suk ee to nonok vavoh e ne manih po teꞌ vanënën soe moaan voh pe Sosoenën. E Sosoenën se tapui a neöm vamanih pa ö neꞌ to tapui vavoh in a ma teꞌ vanënën soe peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ivëhkëk, varenan peöm o teꞌ to öt vapeo nem o moniꞌ, eöm to kon voh em pa ma tah to heꞌ vaeö nee a komëneöm. ");
INSERT INTO tpz_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Varenan peöm o teꞌ varih to ënëën vamhun nem kuru, amot eöm se maë. Varenan peöm o teꞌ varih to onon nem kuru, amot eöm se tamak paröm okook nem. ");
INSERT INTO tpz_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Varenan peöm o teꞌ varih no a ma napan to kë ne a ma ëhnëëneöm, moaan voh a ma sipuineöm to nonok va voh e ne nën, manih pa ma teꞌ vanënën soe pikpiuk.” ");
INSERT INTO tpz_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ivëhkëk, eöꞌ to soe ka neöm, o teꞌ varih to pënton nem a soe peöꞌ. Eöm se iu nem a ma teꞌ varih to vakihat ka ne neöm, ko nonok vavih nem raoe, paröm kamöꞌ nem raoe. ");
INSERT INTO tpz_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Eöm se hinhin ke nem o teꞌ varih to heꞌ punis a ne neöm. Eöm se hinhin nem pan, e Sosoenën se tapui raoe ko nok vavih raoe. ");
INSERT INTO tpz_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ta pah teꞌ se keh tapan a panömah, pah heꞌ a meh papan, keꞌ tapan. Ka teꞌ se keh kon o ohop vatonun pën, pah heꞌ me o siot pën, keꞌ kon. ");
INSERT INTO tpz_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ka teꞌ se keh hin ta pah tah manih pën, eën se heꞌ eah. Ka teꞌ se keh varo a tah pën, eën se koe a hin vakis eah pan eꞌ se piun hah maꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","A ma taateꞌ ne eöm to iu nem no a napan se nok manih peöm, eꞌ a ma taateꞌ poë varih nöm se nok manih pee. ");
INSERT INTO tpz_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Eöm se keh iu varoe nem o teꞌ varih to iu a ne neöm, eöm se kon a vih taeah nën? O teꞌ varih to teꞌ ne pa taateꞌ hat to iu me e ne pa napan se iu ne raoe. ");
INSERT INTO tpz_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ke eöm se keh nonok nem a taateꞌ vih manih po teꞌ varih to nonok vavih a ne neöm, a vih taeah nöm se kon nën? O teꞌ varih to teꞌ ne pa taateꞌ hat to nonok va e ne nën. ");
INSERT INTO tpz_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ke eöm se keh heꞌ ta pah tah manih po teꞌ paröm koman nem pan, ee se piun hah ka ne neöm, eöm se kon a vih taeah nën? O teꞌ varih to teꞌ ne pa taateꞌ hat to heꞌheꞌ me ne pa ma tah manih po teꞌ hat pan, eꞌe se kon hah a tah to vatoe me non a tah vëh nee to heꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ivëhkëk eöm se iu rakah nem a ma teꞌ to vakihat ka ne neöm, paröm nonok vavih nem raoe. Eöm se keh heꞌ a tah manih pa meh teꞌ, koe a iu a ö seꞌ piun hah ka neöm. Eöm se keh nok va nën, amot neöm se kon o voen apuh, paröm tavus vamaman rakah em o pus koaꞌ pe Sosoenën a Kikis Vi. E Sosoenën to ururuan kurus e non pa napan varih to hikta sosoe vavihvih ke ne poë me a nap nonok vahat. ");
INSERT INTO tpz_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Eöm se ururuan nem o teꞌ vamanih pa ö ne Tamön to ururuan va non. ");
INSERT INTO tpz_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Eöm se nat nem kiiki a ma taateꞌ hat pa meh teꞌ. Ke Sosoenën me se hikta kiiki a ma taateꞌ hat peöm. Eöm se nat nem vateen o upöm teꞌ pa hat, vamanih pa ö ne tökiiki vahutët to nonok va non, ivëh ke Sosoenën hikta se vateen a no neöm pa tah hat. Eöm se ihan anoe a ma hat po upöm teꞌ, ke Sosoenën me se ihan anoe a ma teꞌ hat peöm. ");
INSERT INTO tpz_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Eöm se heꞌ akuk a tah peöm manih po upöm teꞌ, ke Sosoenën se piun oah rakah ken peöm. A ma tah varih nöm to heꞌheꞌ akuk nem sih o upöm teꞌ, eꞌ a ma tah poë varih ne Sosoenën se piun hah ka neöm. Köm hikta onöt nem a öt.” ");
INSERT INTO tpz_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","E Ieesuꞌ to heꞌ o soe vapipinoꞌ vamanih pan, “A teꞌ kehoꞌ to onöt pöꞌ e non pa vataare a meh teꞌ kehoꞌ a hanan? Ahik. Eꞌe pon se ru ee pa koveꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","E koaꞌ va pa siku to hikta antoen non a teꞌ oah e tövavaasis peꞌ. Ahik. Eꞌ se siku pareꞌ kon o nat, ko pah vatoe me e tövavaasis peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Vahvanih kën kuteꞌ vaviꞌ nom a tapisik soneꞌ vëh to teꞌ non pa matan e kea pën, ivëhkëk, eën to hikta koman nom a tanaon apuh vëh to teꞌ non pa matömah? ");
INSERT INTO tpz_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Vahvanih kën se soe ke kea pën pan, ‘Kea, eöꞌ to iu kan këh nom oah pa tapisik vëh pa matömah,’ parën hikta ep momoaan voh pa tanaon apuh vëh to teꞌ non pa matömah? Eën a teꞌ mokoꞌ rivon, kon momoaan a tanaon apuh vëh to teꞌ non pa matömah. Ko vasuksuk poꞌ nën se ep vamaaka nom parën pah kan takin poꞌ a tapisik soneꞌ vëh to teꞌ non pa matan e kea pën. A pusun in a soe vaꞌih to soe va non manih pan, ‘Eën se ep momoaan voh pa hat pën, parën pah vatotoopin poꞌ e kea pën.’” ");
INSERT INTO tpz_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","O naon vih to hikta onöt non a voaꞌ a ma voaꞌ hat, keꞌ teꞌ pet va e non manih po naon hat to hikta onöt non a voaꞌ a ma voaꞌ vih. ");
INSERT INTO tpz_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","O teꞌ to iniinan taneꞌ ne sih o naon vih keꞌ o naon hat manih po voaꞌ. O teꞌ to hikta nönö ne pa oes o voaꞌ vetan manih po uris toꞌtoꞌ. A napan to hikta osoes ne sih o voaꞌ pöpöꞌraꞌ manih po karuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","O teꞌ vihvih to teꞌ me ne a ma kokoman vih manih pa ma komëëre. Ivëh, nee to vavatvus suk ne sih a ma soe vih. Ivëhkëk, o teꞌ varih to teꞌ vatëh me ne a ma kokoman hat a taateꞌ hat to puh rakah non manih pa ma komëëre. Ivëh, nee to vavatvus suk ne sih a ma soe hat. Suk a rivon a teꞌ to vavatvus non sih a ma taneah to teꞌ non manih pa komaneah. ");
INSERT INTO tpz_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Eöm to popokaꞌ a no neoꞌ e Sunön peöm, suk ataeah köm hikta vavatet poꞌ nem a soe peöꞌ? ");
INSERT INTO tpz_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","A pah teꞌ se këh nö maꞌ peöꞌ pareꞌ pënton a soe peöꞌ pareꞌ vatet, eöꞌ se vataare a neöm a ö neꞌ to teꞌ va non köm se nat nem. ");
INSERT INTO tpz_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","A teꞌ pamëh to teꞌ va non manih pa pah teꞌ to kehkeh eok non a iuun. Vamomoaan neꞌ to een varu a koveꞌ, ko varu na o toon ko totoon po vös. Pareꞌ vasun en pa iuun keꞌ teꞌ eh rakah e non. Ka unat nö maꞌ pareꞌ een këh en pa iuun, ko hikta onöt non a hoep a iuun, suk a iuun to totoon vaeh rakah e non. ");
INSERT INTO tpz_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ivëhkëk, a teꞌ to pënton en pa soe peöꞌ pareꞌ hikta vavatet non, eꞌ to teꞌ va non manih pa teꞌ to eok a iuun pareꞌ hikta varu o toon ko totoon po vös. Vasuksuk no a unat to een këh en pa iuun, ka iuun tahoep vëvëhöꞌ rakah en.” ");
INSERT INTO tpz_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","E Ieesuꞌ to heꞌ vahik en pa soe manih pa ma napan, pareꞌ nö en manuh pa vöön va Kapaneam. ");
INSERT INTO tpz_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","A pah teꞌ susun pa 100 teꞌ vëvënsun va Room to teꞌ non nën, eꞌ to teꞌ me non a pah teꞌ kikiu peꞌ. A teꞌ susun pamëh to iu rakah non a teꞌ kikiu peꞌ. Ivëhkëk, kuru no a teꞌ pamëh to haraꞌ non a moeh, ka siꞌ ö keꞌ mët en. ");
INSERT INTO tpz_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","A teꞌ susun to pënton a ö ne Ieesuꞌ to teꞌ non, ivëh keꞌ vanö na a ma teꞌ sunön po Jiuꞌ pan, ee se nö ko vaoe maꞌ e Ieesuꞌ keꞌ nö maꞌ ko vatoꞌ a teꞌ kikiu peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ee to tavus e Ieesuꞌ, pare hin vakis e Ieesuꞌ pan, “Eꞌ a teꞌ no a taateꞌ peꞌ to vih, eën antoen e nom pa ö nën se vaꞌaus keah a teꞌ kikiu pe, eh? ");
INSERT INTO tpz_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Eꞌ to iu rakah a rora o Jiuꞌ, pareꞌ eok voh ka ra a iuun hinhin soneꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","E Ieesuꞌ to nö vaꞌpeh me en pee, ko öök vatët en manih iuun. Ke susun pa nap vëvënsun vanö en pa ma vakamöꞌ peꞌ ke soe ke Ieesuꞌ pan, “Topoan, eën to meꞌ pak koraꞌ eom maꞌ, eöꞌ hikta teꞌ vih onöt noꞌ a ö nën se ho maꞌ pa iuun peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ivëh kö’ nat voh e noꞌ peöꞌ to hikta teꞌ noꞌ a teꞌ vih pa nö maꞌ pa ep ka oah. Eën se soe varoe ka teꞌ kikiu peöꞌ toꞌ hah. ");
INSERT INTO tpz_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Suk ataeah, eöꞌ me to teꞌ noꞌ paan in a teꞌ vëh to vovoh ka non eoꞌ pa heꞌ a neoꞌ a kiu. Eöꞌ koman to teꞌ me noꞌ po teꞌ vëvënsun to teꞌ ne paan. Eöꞌ se këh soe ke a teꞌ pamëh, ‘Nö ah,’ keꞌ nö en. Eöꞌ se keh soe ke a teꞌ pan, eꞌ se nö maꞌ, keꞌ se nö en maꞌ. Eöꞌ se keh taꞌ a teꞌ kikiu peöꞌ, ‘Nok a kiu vaꞌih, eꞌ se pënton en pa soe peöꞌ. Pareꞌ nok en pa kiu pamëh.” ");
INSERT INTO tpz_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","E Ieesuꞌ to pënton a soe vaꞌih, pareꞌ pah koman vörep e non pa teꞌ pamëh. Ke Ieesuꞌ tarih, pareꞌ soe ke a ma napan peo varih to vavatet vah ne poë pan, “Eöꞌ to soe ka neöm, manih pa muhin va Israël, eöꞌ to hikta ep noꞌ ta pah teꞌ no vaman peꞌ to eh va non manih pa teꞌ susun pa nap vëvënsun vëh.” ");
INSERT INTO tpz_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ka napan varih ne susun pa nap vëvënsun to vanö voh maꞌ hah ee iuun, pare taum ee pa teꞌ kikiu no a mët to hik këh en peꞌ, keꞌ vih hah en. ");
INSERT INTO tpz_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","A ma siꞌ poen to oah en ke Ieesuꞌ nö en pa vöön vëh ëhnaneah a Naën. A ma vamomhë peꞌ me a napan peo to nö vaꞌpeh me poë. ");
INSERT INTO tpz_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","E Ieesuꞌ me a napan to öök vatët ee maꞌ sinten o hopaꞌ in a vöön pamëh, ka napan teꞌ ee maꞌ pa teꞌ mët. E sinan a teꞌ mët pamëh, eꞌ a paeh koaꞌ oeteꞌ ro ko peꞌ. E voe pe köövo pamëh to mët voh en. A napan o pöh peo to nö vaꞌpeh me maꞌ e köövo pa pe e sunaiꞌeah. ");
INSERT INTO tpz_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","E Ieesuꞌ to ep e köövo pamëh, pareꞌ pah ururuan en peꞌ, pareꞌ soe ke köövo pan, “Koe a ook.” ");
INSERT INTO tpz_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","E Ieesuꞌ to nö vatët en pa pokis, pareꞌ vaket en pa pokis pamëh ka napan varih to teꞌteꞌ nö ne pa teꞌ mët sun ee. Ke Ieesuꞌ soe, “Teꞌ sekaꞌ, Eöꞌ to soe ka oah, ‘Sun ah!’” ");
INSERT INTO tpz_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ka teꞌ vëh to mët voh en sun hah en, pareꞌ ihoꞌ non ko taneo en pa vaato. Ke Ieesuꞌ vanö en peꞌ manih pe sinaneah. ");
INSERT INTO tpz_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ivëh ka ma napan kurus ta rakah e ne pe Ieesuꞌ, pare pah kë ee pa ëhnan e Sosoenën. Ee to soe pan, “A pah teꞌ vanënën soe to tavus topniira.” Pare soe pan, “E Sosoenën to nö voh en maꞌ marën a kon hah a ma napan peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ka ma napan vanat vavah ee po vahutët in a tah vëh ne Ieesuꞌ to nok manih pa muhin va Jiutiaꞌ me pa ma ö muhin to teꞌ vatët ne. ");
INSERT INTO tpz_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","A ma vamomhë pe Jon Tövapupui to soe ke peꞌ pa ma tah kurus ne Ieesuꞌ to nonok non. ");
INSERT INTO tpz_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ke Jon vaoe en pa poa vamomhë peꞌ, pareꞌ vanö en pee pon pa hi e Ieesuꞌ, “Eöm se nö ko hi pan, ‘Eën pöꞌ kov e vëh a teꞌ to se voh nö maꞌ, keꞌ, emöm se anoeh nem ta meh teꞌ eh?’” ");
INSERT INTO tpz_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Manih po poen pamëh e Ieesuꞌ to vatoꞌ hah a ma napan peo to teꞌ me ne a ma vu mët. Eꞌ to veo a ma oraꞌ hat, pareꞌ vavih hah a ma napan kehoꞌ ke opoep hah ee. Ka poa vamomhë pe Jon to tavus e Ieesuꞌ, pare soe pan, “E Jon Tövapupui to vanö maꞌ möm poꞌ manih pën, pa hi a oah pan, ‘Eën pöꞌ kov e vëh a teꞌ se nö voh maꞌ, keꞌ, emöm se anoeh nem ta meh teꞌ eh?’” ");
INSERT INTO tpz_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","E Ieesuꞌ to pënton a hi pamëh, pareꞌ piun ko soe pan, “Eöm pom se nö hah na manuh pe Jon, paröm vavatët eah a ma taneah nöm to ep, me pënton. O teꞌ varih o kehoꞌ to ep vavih hah ee, ko teꞌ varih o hathat ma moe to nö vavavih hah ee, ko teꞌ varih pa mët töpaꞌ a ma sioniire to voon hah ee. Ko teꞌ varih no a tenëre to hat ee to pënton hah ee, ko teꞌ mët, toꞌtoꞌ hah ee, ko teꞌ varih o arus to pënton ee pa Soe Vih pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","A ma napan varih no vaman pee manih peöꞌ, me pa ma tah nöꞌ to nonok noꞌ, ee se nat ne haraꞌ vahat ne, ee se vaeö. E Sosoenën se tapui raoe.” ");
INSERT INTO tpz_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ka poa vamomhë pe Jon Tövapupui nönö hah ko nee, ke Ieesuꞌ taneo en pa vahutët ke ra napan a ma taateꞌ pe Jon, pareꞌ to soe pan, “Moaan voh eöm to nö pa moeh upin pa ep pe Jon, keꞌ pa ep a mëto no a tuvuh to vataata non, keꞌ eöm koman voh nem a ep in ataeah? ");
INSERT INTO tpz_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Eöm to nö voh nös pa ep in a teꞌ to ohop non a ma ohop ep vavih? Ahik. A napan to ohop ne a ma ohop ep vavih, pare teꞌ me ne pa ma tah vih va po sionin. A pap teꞌ poë varih to teꞌ ne sih pa iuun pa teꞌ sunön. ");
INSERT INTO tpz_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Soe ka neoꞌ öm, eöm nö voh nös pa ep ataeah? Eöm to nö pöꞌ voh nös pa ep a teꞌ vanënën soe? A, eöꞌ to soe ka neöm, a teꞌ vanënën soe vëh e Jon, no a tasun peꞌ to apuh oah e non pa ma teꞌ tasun po upöm teꞌ vanënën soe. ");
INSERT INTO tpz_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","E Jon voh a teꞌ ko poan no Puk Vapenpen to sosoe suk voh non po kiun peꞌ. O kiun to soe non pan, “Pënton ah, eöꞌ se vanö nös a teꞌ vëh se teꞌ vovoh nös a soe peöꞌ manem pën, eꞌ se vovoh ka oah, pareꞌ vamatop a hanan pën.” ");
INSERT INTO tpz_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Eöꞌ to soe ka neöm, e Jon no a tasun peꞌ to teꞌ oah e non pa ma teꞌ tasun po upöm teꞌ manih po oeh. Ivëhkëk, a teꞌ to teꞌ va non manih pa siꞌ koaꞌ soneꞌ manih pa Matop Vih pe Sosoenën no tasun peꞌ to apuh oah e non pa teꞌ tasun pe Jon. ");
INSERT INTO tpz_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","A ma napan to pënton vahik ee pa ma soe, ka nap kokon takis soe pan, “A taateꞌ pe Sosoenën to totoopin rakah.” Ee to kon voh a tapui manih pe Jon Tövapupui. ");
INSERT INTO tpz_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ivëhkëk, o Parësiꞌ me o teꞌ vavaasis to nat i ne o Vavaasis pe Mosës eꞌe to hikta kon voh a tapui manih pe Jon suk, ee to heꞌ tonun voh ee pa hanan vih ne Sosoenën to vataare raoe. ");
INSERT INTO tpz_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ke Ieesuꞌ soe pan, “Eöꞌ se vëknöm vah va in a taateꞌ pa napan va kuru nih? Ee o teꞌ to teꞌ vah va ne nih? ");
INSERT INTO tpz_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ee to teꞌ va ne manih po koaꞌ to ihoꞌ ne pa ma ö totoaan, pare vavaasis piu ne, ivëhkëk o meoh upöm pee to hikta vaëhëh ne. Kee varek ke raoe, pare soe pan, ‘Emöm to piu kem peöm po piu, ivëhkëk, eöm to hikta pinoꞌ. Kemöm vaëhëh kem peöm pa ta okook vatamak, ivëhkëk eöm to hikta tamak to ook.’” ");
INSERT INTO tpz_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“E Jon Tövapupui to nö voh en maꞌ, pareꞌ vapenpen vapeo non pa ëën. Ko hikta kakaak voaën voh non, köm soe em pan, ‘A oraꞌ hat to teꞌ non manih peꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ivëhkëk kuru, eöꞌ E Koaꞌ Teꞌ Pa Napan Kurus to nö maꞌ, paröꞌ ënëën noꞌ ko kakaak noꞌ, köm soe em pan, ‘Ep öm, eꞌ a teꞌ ënëën vörep, ko kakaak voaën vörep, pareꞌ teꞌ e non e vakamöꞌ pa nap kokon takis me ra nap nonok a ma taateꞌ hat.’ ");
INSERT INTO tpz_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ivëhkëk, a napan to vatet ne o nat vih pe Sosoenën, eꞌe to vataare e ne a taateꞌ vih, eꞌ o nat vih rakah, suk eꞌe to vaman ne e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","A pah Parësiꞌ, to vaoe e Ieesuꞌ pa iuun peꞌ keꞌ nö maꞌ, kee ihoꞌ to ëën vaꞌpeh. ");
INSERT INTO tpz_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ka pah köövo teꞌteꞌvaasi to teꞌ non pa vöön pamëh, to pënton a ö ne Ieesuꞌ to ënëën non pa iuun pa to Parësiꞌ. Ivëh, ke köövo kon o puto vös vih no o vanom voen vapeah to isu non, ko nö maꞌ pa iuun vëh ne Ieesuꞌ to teꞌ non. ");
INSERT INTO tpz_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","E köövo to sun non pa havin mon pe Ieesuꞌ, pareꞌ okook non, ka hunun mataneah vuꞌvuꞌ non pa mon e Ieesuꞌ, keꞌ vaꞌnaꞌ pa uvineah. Eꞌ to umaꞌ vapeo a mon e Ieesuꞌ, pareꞌ uh a moneah po vanom. ");
INSERT INTO tpz_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ka to Parësiꞌ vëh to vaoe na e Ieesuꞌ ep in a tah vaꞌih, pareꞌ koman va non manih pan, “A teꞌ vëh se keh teꞌ e non a teꞌ vanënën soe vamaman, eꞌ se nat e non pa taateꞌ pe köövo vëh to vaket poan, eꞌ a köövo teꞌteꞌvaasiꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ke Ieesuꞌ nat e non po kokoman pe Saëmon, pareꞌ soe pan, “Eöꞌ to teꞌ me noꞌ a pah tah noꞌ to iu soe ka nom oah.” Ke Saëmon soe pan, “Tövavaasis, vatvus a soe pën.” ");
INSERT INTO tpz_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ke Ieesuꞌ soe, “A poa teꞌ to teꞌ me ne o ötop manih pa pah teꞌ. A paeh to teꞌ me non o K500.00, ka meh po K50.00. ");
INSERT INTO tpz_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ee pon to hikta onöt ne a piun a ma ötop pee, ivëh ka teꞌ vëh to heꞌ voh o ötop ururuan raoe, ko vanun en po ötop pee pon. Manih pee pon eteh se iu oah non a teꞌ vëh to heꞌ o ötop?” ");
INSERT INTO tpz_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ke Saëmon piun, pareꞌ soe vamanih pan, “Eöꞌ to koman noꞌ a teꞌ vëh to teꞌ me non o K500.00 se iu oah non a teꞌ vëh to heꞌ o ötop.” Ke Ieesuꞌ soe ke poan, “A piun pën to totoopin rakah.” ");
INSERT INTO tpz_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ke Ieesuꞌ tarih manuh pe köövo, pareꞌ soe ke Saëmon, “Eën ep e nom pe köövo vëh, ha? Eöꞌ to ho maꞌ pa iuun pën, kën hikta heꞌ a neoꞌ ta ruen köꞌ pupui a moneoꞌ. Ivëhkëk, a hunun mataneah to pupui a moneoꞌ, pareꞌ vaꞌnaꞌ pa uvineah. ");
INSERT INTO tpz_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Eën to hikta uumaꞌ a neoꞌ. Ivëhkëk kuru, eöꞌ to ho maꞌ ke köövo vëh to umaꞌ vapeo a moneoꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Eën to hikta uh a pasuneoꞌ po kompoꞌ to voen vöknah, ivëhkëk, e köövo vëh to uh a moneoꞌ po vanom voen vapeah. ");
INSERT INTO tpz_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ivëh, köꞌ soe ka oah, e köövo nonok vahat vëh no a pop peꞌ to hikta teꞌ vih voh non, to iu vi ka no neoꞌ. Ke Sosoenën to ihan anoe a ma hat peo peꞌ. Ivëhkëk, a teꞌ to nok a hat soneꞌ e Sosoenën se ihan anoe a hat soneꞌ peꞌ, ka teꞌ pamëh se iu vasoneꞌ e non pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ke Ieesuꞌ soe ke köövo, “Eöꞌ to ihan anoe eoꞌ pa ma hat pën.” ");
INSERT INTO tpz_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","A ma napan to ihoꞌ vaꞌpeh me ne e Ieesuꞌ to taneo ee pa varek koman pan, “A teꞌ vëh koman rakah non pan, eꞌ e Sosoenën, pareꞌ ihan anoe non pa ma hat, ha?” ");
INSERT INTO tpz_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ke Ieesuꞌ soe ke köövo pamëh, “O vaman pën manih pe Sosoenën to kon hah vur en pën kën teꞌ vaꞌpeh me nom peꞌ. Nö ah me o kokoman moomo.” ");
INSERT INTO tpz_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","A ma poen to oah ee, ke Ieesuꞌ vavavih vah en pa ma vöön apaꞌpuh me a ma siꞌ vöön sosoneꞌ. Eꞌ to vatvus a Soe Vih va pa Matop Vih pe Sosoenën manih pa ma napan. A havun me a poa vamomhë peꞌ to nönö vaꞌpeh vah me ne poë. ");
INSERT INTO tpz_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","A ma köövo varih moaan voh ne Ieesuꞌ to veo këh voh raoe pa ma oraꞌ hat, eꞌe me to nö vaꞌpeh me Ieesuꞌ. A paeh vëh e Mariaꞌ Makdalaꞌ. Moaan voh e Ieesuꞌ to veo këh poan a tönim me a poa oraꞌ hat to teꞌ ne manih peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ke Joanan, e köövo pa teꞌ to susun non pa iuun pe Hëërot, a ëhnaneah e Kusaꞌ, me Susanaꞌ, me a ma meh upöm köövo me, nee to pët nö vaꞌpeh. A ma köövo poë varih to vaꞌaus voh ne e Ieesuꞌ me a ma vamomhë peꞌ pa ma tah nee to vaneah ne. ");
INSERT INTO tpz_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","A napan o pöh peo to tönun voh maꞌ, a ma napan to taneꞌ maꞌ pa ma vöön apuh to nö maꞌ manih pe Ieesuꞌ. Ke Ieesuꞌ heꞌ raoe a pah soe vapipinoꞌ, eꞌ to soe pan, ");
INSERT INTO tpz_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“A pah teꞌ poꞌpoꞌ kon to nö pa rak peꞌ, pareꞌ poꞌpoꞌ a kon peꞌ. Eꞌ to poꞌpoꞌ nö non a kon, ka ma meh voaꞌ kon vuꞌ ee manih po vaꞌpet taan, ka napan komtötön ee pee, ko növan nö maꞌ, ko ëën vahik ee pa ma voaꞌ kon. ");
INSERT INTO tpz_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ka ma meh voaꞌ vuꞌ ee pa moeh vösvös, pare pisiꞌ ee maꞌ, ivëhkëk, a hikta ruen to teꞌ non komön o oeh, ivëh, ka ma voaꞌ kon rak ee. ");
INSERT INTO tpz_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ka ma meh voaꞌ kon vuꞌ ee po topnin o noꞌ uris toꞌtoꞌ, ka uris toꞌtoꞌ to pu maꞌ, ko kopös en pee, kee hikta pu vavih maꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ka ma meh voaꞌ kon vuꞌ ee manih po oeh vih, ko pisiꞌ vavih ee maꞌ, pare voaꞌ vavih ee, ka ma vu kon voaꞌ o 100 voaꞌ.” E Ieesuꞌ to soe va nën, pareꞌ vahik va in a soe peꞌ manih pan, “Eöm o teꞌ varih to teꞌ me ne a tenëneöm, eöm se pënton a soe vaꞌih.” ");
INSERT INTO tpz_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ka ma vamomhë peꞌ hi ee peꞌ pa pusun in a soe vapipinoꞌ vaꞌih pan e Ieesuꞌ se vamaaka ke raoe. ");
INSERT INTO tpz_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ke Ieesuꞌ soe, “E Sosoenën koman to vataare vahik voh en peöm pa pusun in a soe vakoaan in a Matop Vih Peꞌ. Ivëhkëk, a ma upöm teꞌ to pënton koe ne sih pa ma soe vapipinoꞌ. Ivaꞌih, ‘Kee ut ne, pare hikta ep in ta pah tah. Ee to tënan e ne, pare hikta maaka ne a pusun in a soe.’” ");
INSERT INTO tpz_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“A pusun in a soe vapipinoꞌ vaꞌih to soe va non manih pan, o voaꞌ kon to teꞌ va non manih pa soe pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","A ma voaꞌ kon varih to vuꞌ po vaꞌpet taan to teꞌ va e ne manih pa napan to pënton ee pa soe pe Sosoenën, ivëhkëk, e susun po oraꞌ hat to nö maꞌ, pareꞌ kon këh en pee pa soe vëh to teꞌ non pa ma komëëre. Eꞌ to koman non pan, eꞌe tomeꞌ vaman ne a soe pe Sosoenën, ke Sosoenën kon hah raoe. ");
INSERT INTO tpz_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","A ma meh voaꞌ kon to vuꞌ manih pa ö vösvös to teꞌ va ne manih po teꞌ to pënton ee pa soe, pare kon me o vaeö ko vaman. Ivëhkëk, o vaman to hikta aan vakis vi non manih pa komëëre. Ko poen no a punöꞌ eh to nö maꞌ manih pee, kee kuꞌ vëhöꞌ ee. ");
INSERT INTO tpz_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ka ma meh voaꞌ kon to vuꞌ manih topnin a uris toꞌtoꞌ to teꞌ va ne manih po teꞌ to pënton ee pa soe, pare vaman rakah ee, ka ma vu punis va pa ununun a moniꞌ peo, me o vaeö va po oeh to nö maꞌ, ko kupkup en pa soe pe Sosoenën. Ivëh, ka soe pamëh hikta vovoaꞌ non. ");
INSERT INTO tpz_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","A ma voaꞌ kon varih to vuꞌ manih po oeh vih to teꞌ va ne manih po teꞌ to pënton a soe pe Sosoenën, pare ötöön, ko vaman rakah ee. Ka soe pamëh to voaꞌ pet manih po toꞌtoꞌ pee. Pare vataare ne a ma taateꞌ totoopin pa ö nee to vavatet ne a ma soe pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“A teꞌ to vëkrea kës pöꞌ o ram, pareꞌ vahoꞌ hop poan po kove, keꞌ vahoꞌ o ram paan tevan, ah? Ahik, eꞌ se vahan o ram pa ö vavahan ram, keꞌ ëman ke non a napan se ho maꞌ manih iuun, kee sih ep ne o ëman pamëh. ");
INSERT INTO tpz_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","A ma soe kurus pe Sosoenën varih to vakoaan voh ne, kuru ee se tavus vamaaka ee. Ka ma soe pe Sosoenën moaan voh no a napan to hikta maaka ne, kuru nee se maaka ee. ");
INSERT INTO tpz_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ivëh, köm se pënton vavih ko matop nem. A teꞌ se keh kon voh o nat, pareꞌ maaka i non a soe pe Sosoenën, e Sosoenën se heꞌ vaꞌpuh oah en peꞌ po nat, keꞌ maaka vavih en. Ka teꞌ se keh koaan o nat vëh neꞌ to koman non pan e Sosoenën to heꞌ voh poan, e Sosoenën se öt hah këh en peꞌ po nat pamëh.” ");
INSERT INTO tpz_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Manih po poen pamëh ne sinan e Ieesuꞌ me a ma kea peꞌ to nö maꞌ pa ep poë. Ivëhkëk, a napan peo rakah to tönun maꞌ, kee hikta onöt ne a huk vatët manih peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","O upöm teꞌ to soe ke Ieesuꞌ pan, “E sinömah me a ma kea pën to teꞌ ne mahën, ee to iu ep ka nom oah.” ");
INSERT INTO tpz_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ivëhkëk, e Ieesuꞌ to piun raoe, pareꞌ soe, “A ma napan to pënton ne a ma soe pe Sosoenën, pare vavatet ne, eꞌe kuru e sinaneoꞌ, me a ma kea peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","O pöh poen ne Ieesuꞌ to peah po pöh paröꞌ, me a ma vamomhë peꞌ, pareꞌ soe ke raoe pan, “Ka pahan ee manuh pa pap tonon vöh.” ");
INSERT INTO tpz_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","O paröꞌ to nönö e non ke Ieesuꞌ koroh nö non komön o paröꞌ. Ka ivat ip maꞌ manih pa tonon, ka ruen oho e non komön o paröꞌ, ka siꞌ ö hat ko paröꞌ rokoꞌ en. ");
INSERT INTO tpz_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ko vamomhë pe Ieesuꞌ nö, pare kunkuin ee peꞌ, pare soe ke poë pan, “Apuh, Apuh, a siꞌ ö hat, ko paröꞌ rokoꞌ me en pea.” Ke Ieesuꞌ sun pareꞌ taꞌ a tuvuh me a supa pan, “Moovi öm!” Ka tuvuh tö en, ka supa hikta ririu hah non. ");
INSERT INTO tpz_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ke Ieesuꞌ soe ke raoe pan, “O vaman peöm heh?” Kee pah naöp ee, pare töhkak vahat ee, pare vavasoe koman va ne manih pan, “A teꞌ rakah vëh eteh, to taꞌ a tuvuh me a supa kee tënan ee pa soe peꞌ?” ");
INSERT INTO tpz_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Vasuksuk nee to tok po paröꞌ, pare tavus pa muhin va Gerasaꞌ. A muhin pamëh to teꞌ non maꞌ pa meh pap tonon va Galiliꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","31","E Ieesuꞌ to kukunah këh ko non o paröꞌ, ka pah teꞌ va pa vöön pamëh no oraꞌ hat to teꞌ ne manih peꞌ, nö en maꞌ manih pe Ieesuꞌ. Pa ma tamoaan no o oraꞌ hat to teꞌ ne pa teꞌ pamëh. A ma napan to matop ne poë, ko nohnoh ne sih poë po uris eh. Ivëhkëk, eꞌ to kukurus e non sih po uris eh me a ma meh tah. Pareꞌ nönö non pa moeh upin. O oraꞌ hat poë varih to teꞌ ne pa teꞌ pamëh, ka ma tamoaan neꞌ to hikta kokoroh non iuun, pareꞌ teꞌ pehpeah e non ko teꞌ non sih po vapeepe. Keꞌ nö maꞌ manih pe Ieesuꞌ, ke Ieesuꞌ hi poan, “A ëhnöömah eteh?” Ko oraꞌ hat soe pan, “A ëhnanmöm, ‘a Nap Peo’, suk emöm to peo to teꞌ hop nem pa teꞌ vëh.” Ko oraꞌ hat poë varih pah kokoeꞌ suntan kee pe Ieesuꞌ pan, “Eën se nat nom vanö a möm manuh po suraꞌ ësës tamoaan.” Ke Ieesuꞌ siröꞌ en po oraꞌ hat se tavus këh a teꞌ pamëh, ivëh, ko oraꞌ hat kokoeꞌ koe ee manih pa teꞌ pamëh, pare kokoeꞌ vaꞌpuh, ko soe pan, “Ieesuꞌ eën e Koaꞌ pe Sosoenën A Kikis Vi, eën se nok ataeah manih pemöm?” Ee to hin vakis e Ieesuꞌ, pare soe pan, “Ieesuꞌ, eën se nat nom vakmis a möm.” ");
INSERT INTO tpz_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","O vasun kuꞌ peo to ënëën vatët ne sinten a siꞌ ö tope, ivëh, ko oraꞌ hat poë varih hin vakis ee pe Ieesuꞌ pan, “Eën se vanö a möm manuh po kuꞌ.” Ke Ieesuꞌ pënton en pa soe pee, pareꞌ vaonöt ken pee pa hop manuh po vasun kuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ko oraꞌ hat tavus këh ee pa teꞌ, pare nö ko hop varuꞌ ee manuh po vasun kuꞌ. Ko kuꞌ surap kunah ee pa ö vaere, pare vuk ee pa tonon, ko mëtmët vahik rakah ee. ");
INSERT INTO tpz_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ka napan varih to matop ne sih po vasun kuꞌ pamëh ep a tah vaꞌih, pare naöp ko rusin ee. Ee to nö, pare vahutët a tah vaꞌih pa vöön apuh me ra ma vöön sosoneꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ka ma napan nö ee pa vavaköm pa ma tah to tanok. Ee to nö, ko tavus e Ieesuꞌ, pare taum ee pa teꞌ no oraꞌ hat to këh ee peꞌ, eꞌ to rara hah en ko kokoman peꞌ maaka en, keꞌ ihoꞌ non pa havin mon e Ieesuꞌ. A ma napan to ep a tah vaꞌih, pare pah vananaöp ee. ");
INSERT INTO tpz_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ka napan varih to ep voh ne pa ma tah poë varih, ee to vahutët ke ro upöm a tah ne Ieesuꞌ to nok manih pa teꞌ pamëh, keꞌ vih hah en. ");
INSERT INTO tpz_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ka ma napan va pa ma ö muhin va Gerasaꞌ to naöp vörep, pare hin vakis e Ieesuꞌ ko soe pan, “Eën se këh a na möm.” Ivëh, ke Ieesuꞌ me o vamomhë peꞌ peah ee po paröꞌ, pare vamatop ee pa hah. ");
INSERT INTO tpz_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ee to meꞌ e ne pa nö, ka teꞌ vëh no oraꞌ hat to këh poan, eꞌ to hin vakis e Ieesuꞌ pan, “Eöꞌ to iu teꞌ vaꞌpeh me nom oah.” Ivëhkëk, e Ieesuꞌ to vahah en peꞌ ko soe ke poan pan, ");
INSERT INTO tpz_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Eën se hah vos na vöön pën, parën vatvus a soe pa ma tah ne Sosoenën to nok manih pën.” Ivëh, ka teꞌ pamëh hah en vöön, pareꞌ vatvus ken pa ma napan pa ma tah kurus ne Ieesuꞌ to nok manih po toꞌtoꞌ peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","E Ieesuꞌ to këh hah maꞌ a pap tonon voh ka napan pah vaeö ee, suk eꞌe to anoeh voh ne poë. ");
INSERT INTO tpz_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ka pah teꞌ nö maꞌ, a ëhnaneah e Jaërus. Eꞌ a teꞌ to susun non pa iuun hinhin soneꞌ. A teꞌ susun pamëh to vatokon pa havin mon e Ieesuꞌ, pareꞌ hin vakis e Ieesuꞌ pan, e Ieesuꞌ se nö pa iuun peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Eꞌ to teꞌ me non a pah koaꞌ mon ro, a ma kirismas peꞌ to onöt non o havun me ro pöök. Eꞌ to haraꞌ non a mët apuh, ka siꞌ ö keꞌ mët en. E Ieesuꞌ to nönö vaꞌpeh nö me non e Jaërus, ka napan o pöh peo to vasusun pip nö e ne peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","A pah köövo to vavahuh tamoaan non sih o eraꞌ komön o havun me o pöök kirismas. A hikta pah röktaꞌ to onöt voh non a vahik këh poan pa mët. ");
INSERT INTO tpz_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","E köövo pamëh to huk vatët maꞌ tonun e Ieesuꞌ, pareꞌ hariun a ö noton in o ohop peꞌ. Eꞌ to nok va nën ka varuꞌ vakomanih no eraꞌ to anaꞌ vëvëhöꞌ rakah këh en peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ke Ieesuꞌ hi pan, “Eteh to hariun a neoꞌ?” Ee kurus to vonih ee. Ke Pitaꞌ soe, “Apuh, a napan o pöh peo rakah to tönun töön oah, ko vaket ee pën.” ");
INSERT INTO tpz_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ivëhkëk, e Ieesuꞌ to soe pan, “A pah teꞌ to vahoꞌ a koreneah manih peöꞌ. Eöꞌ to haraꞌ noꞌ o kikis to tavus këh a neoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","E köövo to nat en peꞌ to hikta vakoaan hah in non e Ieesuꞌ. Ivëh, keꞌ naöp ko rikrik e non ko nö maꞌ, pareꞌ vatokon pa matan e Ieesuꞌ pa matëëre ra napan kurus, pareꞌ vatvus a ö neꞌ to vaket suk e Ieesuꞌ. Ke köövo soe pan, “A mët peöꞌ to hik ohoꞌ rakah en pa ö nöꞌ to hariun e Ieesuꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ke Ieesuꞌ soe ke köövo pamëh pan, “Koaꞌ peöꞌ, eën to vaman a neoꞌ, ka mët pën hik këh en pën. Eën se nö na me a taateꞌ moomo. ");
INSERT INTO tpz_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","E Ieesuꞌ to vaato avoeꞌ e non, ka pah teꞌ va pa iuun pe Jaërus nö maꞌ, pareꞌ soe ke poan pan, “E semomah to mët en. Koe a vatëh vörep e Tövavaasis.” ");
INSERT INTO tpz_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","E Ieesuꞌ to pënton a ö ne koaꞌ to mët, pareꞌ soe ke Jaërus pan, “Eën se koe a naöp, eën se vaman varoe a nom neoꞌ, ke koaꞌ pën toꞌ hah en.” ");
INSERT INTO tpz_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ke Ieesuꞌ nö en pa iuun pe Jaërus, pareꞌ hikta vaonöt a nap peo pa ho koman iuun. Eꞌ to me ho varoe e Pitaꞌ, e Jon, me e Jëmis, me a poa manot. ");
INSERT INTO tpz_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","A ma napan kurus to vaokook ne e koaꞌ, ivëhkëk, e Ieesuꞌ to soe ke raoe pan, “Eöm se koe a ook, e koaꞌ to hikta mët, eꞌ to koroh varoe.” ");
INSERT INTO tpz_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ka napan varih to okook ne to vavövöneꞌ suntan e ne pe Ieesuꞌ. Suk ee to hikta vaman nee e Ieesuꞌ pa ö neꞌ to soe pan e koaꞌ to koroh. ");
INSERT INTO tpz_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ke Ieesuꞌ öt a koren e koaꞌ mon mët pamëh, pareꞌ soe pan, “Koaꞌ peöꞌ, sun ah.” ");
INSERT INTO tpz_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ka apen koaꞌ hah en maꞌ, ka varuꞌ vakomanih ne koaꞌ to sun hah en. Ke Ieesuꞌ soe ke ra poa manot pan, “Eöm se heꞌ eah ta taëën.” ");
INSERT INTO tpz_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kee vaeö, ko töhkak ee, ivëhkëk, e Ieesuꞌ to vuhvuh vakis ken pa poa manot pan, “Eöm pom se nat nem vavatët pet ta meh teꞌ a tah vaꞌih to tanok.” ");
INSERT INTO tpz_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","E Ieesuꞌ to vaoe en na po havun me a poa vamomhë peꞌ, kee nö ee maꞌ, keꞌ heꞌ en pee po kikis me a tasun peꞌ, marën a ö nee se veo këh a napan po oraꞌ hat, me a vahik a ma vu mët. ");
INSERT INTO tpz_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pareꞌ vanö en pee manih pa ma vöön pa vatvus a soe va pa Matop Vih pe Sosoenën, me a vavatoꞌ hah ro teꞌ to haraꞌ ne a ma mët. ");
INSERT INTO tpz_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Pareꞌ soe ke raoe pan, “Eöm se nat nem teꞌ a ma tah manih pa nö peöm vamanih po toknon, keꞌ o kove, keꞌ ta taëën, me a moniꞌ, me a ma ohop peo. ");
INSERT INTO tpz_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Eöm se keh ho pa ta pah iuun, a, eöm se teꞌ varoe nem pa iuun pamëh, keꞌ antoen non a ö nöm se këh hah a vöön pamëh. ");
INSERT INTO tpz_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ka napan se keh hikta vaoe a neöm pa ma iuun pee, a, eöm se këh em pa vöön pamëh, paröm sisinuh o kusan vëh to teꞌ non pa ma moeeneöm. Eꞌ a soe vanat va pa ö no a napan va pa vöön pamëh to hikta iu pënton ne a soe peöm. Ivëh, ke Sosoenën se vakmis raoe. ");
INSERT INTO tpz_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ivëh, kee nö ee pa ma vöön kurus, pare vatvus ee pa Soe Vih pe Ieesuꞌ, ko vavatoꞌ ee pa ma teꞌ to haraꞌ ne a ma mët. ");
INSERT INTO tpz_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","A teꞌ sunön va pa kaman manih Galiliꞌ e Hëërot to pënton a ma tah kurus ne Ieesuꞌ to nonok non, ivëh, ko kokoman peꞌ nun en, suk a ma meoh teꞌ to sosoe ne pan, “E Jon Tövapupui to sun taneꞌ hah po vapeepe.” ");
INSERT INTO tpz_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ka ma upöm sosoe ne pan, “E Elaëjaꞌ to tavus hah maꞌ.” Ko upöm sosoe e ne pan, “A teꞌ vanënën soe vamoaan to toꞌ hah maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ivëh, ke Hëërot soe en pan, “Eöꞌ to moes kurus voh o kahoꞌ pe Jon. Ka teꞌ vëh eteh, nöꞌ to pënton noꞌ to nonok non a ma tah varih?” Ke Hëërot vavaiu këh e non ta hanan pan, eꞌ ep e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ka ma aposol hah ee maꞌ, pare soe ke pe Ieesuꞌ pa ma tah kurus nee to nok voh maꞌ. Ke Ieesuꞌ me ke këh en pa ma napan pa vamomhë peꞌ, kee nö varoe ee pa meh vöön, ëhnaneah Bëtsaëtaꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ivëhkëk, a napan peo to nat ee pee to teꞌ ne Bëtsaëtaꞌ, pare vatet ee pee. A napan to nö maꞌ manih peꞌ, keꞌ pah vaeö en. Eꞌ to vatvus en pa soe vih va pa Matop Vih pe Sosoenën manih pee, pareꞌ vavatoꞌ en po teꞌ varih to haraꞌ ne a ma mët. ");
INSERT INTO tpz_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","A potan to kunah en, ka havun me a poa vamomhë pe Ieesuꞌ nö ee maꞌ peꞌ, pare soe ke poë pan, “Eën se vanö a napan, kee nö pa ma vöön to teꞌ vatët ne, pare ep këh ta taëën, ko ëën, suk a ö vëh na to teꞌ no, no a hikta teꞌ to teꞌ non.” ");
INSERT INTO tpz_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ivëhkëk, e Ieesuꞌ to soe ke raoe pan, “Eöm koman se makën raoe.” Kee soe pan, “Emöm to hikta öt nem ta ma taëën peo. O siꞌ tönim muꞌ me a poa iian varoe to teꞌ ne. Eën to iu pöꞌ nom pan emöm se voen a taëën pa napan peo varih, ha?” ");
INSERT INTO tpz_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","A napan to onöt ne a 5,000 teꞌ oeteꞌ rakah to teꞌ ne. Ke Ieesuꞌ soe ke ra ma vamomhë peꞌ pan, “Eöm se soe ke ra napan, kee tönun a ma 50 teꞌ, pare ihoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ko vamomhë peꞌ soe ke ra napan, kee ihoꞌ ee. ");
INSERT INTO tpz_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Keꞌ kon en po tönim muꞌ me a poa iian, pareꞌ ta peah na vöön va kin, ko soe vavihvih ke na e Sosoenën, pareꞌ kökök ko heꞌ a ma vamomhë peꞌ. Kee ki vakëkëh ke pa napan. ");
INSERT INTO tpz_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ka napan kurus ëën vamhun ee, ko vamomhë peꞌ ununun a ma ö taëën ëën këh, pare vapuh o havun me o pöök kove. ");
INSERT INTO tpz_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","O pöh poen ne Ieesuꞌ to hinhin non, ka ma vamomhë peꞌ teꞌ vaꞌpeh me ne poë. Ke Ieesuꞌ hin vahik en, pareꞌ hi raoe pan, “A ma napan popokaꞌ a no neoꞌ eteh?” ");
INSERT INTO tpz_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ko vamomhë peꞌ piun, pare soe pan, “E Jon Tövapupui, ka ma meh popokaꞌ e ne pën e Elaëjaꞌ. Ka ma upöm sosoe ne pan, eën a pah teꞌ va pa nap vanënën soe vamoaan to toꞌ hah maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ke Ieesuꞌ hi raoe, “Ke eöm koman poꞌ, eöm popokaꞌ a nem neoꞌ eteh?” Ke Pitaꞌ piun a soe peꞌ, pareꞌ soe pan, “Eën e Kristo, a teꞌ ne Sosoenën to vanö maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ke Ieesuꞌ vuhvuh vakis raoe se nat ne soe ke ta meh teꞌ a soe pamëh. ");
INSERT INTO tpz_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Pareꞌ soe pan, “Eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus se kon o kamis apuh rakah manih pa koreera nap susunön po Jiuꞌ, me ra ma teꞌ susunön ësës heꞌ, me ro teꞌ vavaasis to nat i ne o Vavaasis pe Mosës. Ee ip vamët a neoꞌ, ko vakön poen ne eöꞌ se sun taneꞌ hah eoꞌ manih po vapeepe.” ");
INSERT INTO tpz_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ke Ieesuꞌ soe ke ra ma vamomhë peꞌ pan, “Ta pah teꞌ se iu vatet a non neoꞌ, eꞌ se vöknah o iu koman peꞌ, pareꞌ teꞌ a kuruse peꞌ pa ma poen kurus, pareꞌ teꞌ o kamis, ko vatet a maꞌ neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ivëhkëk, a teꞌ se keh matop tamoaan non o toꞌtoꞌ peꞌ, pareꞌ hikta vatet a neoꞌ, o toꞌtoꞌ peꞌ se ro amot en. Ka ta pah teꞌ se keh koman a non neoꞌ, pareꞌ mët suk a neoꞌ, a, amot a teꞌ pamëh se kon o toꞌtoꞌ tamoaan. ");
INSERT INTO tpz_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ta pah teꞌ se keh vaneah kurus e non pa ma tah va po oeh vëh, pareꞌ vanun en po toꞌtoꞌ tamoaan peꞌ, a ma tah poë varih se poꞌ vaꞌaus vah va in o toꞌtoꞌ peꞌ nih? Ahik rakah! ");
INSERT INTO tpz_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kuru a pah teꞌ se keh poet ka no neoꞌ, me o vavaasis peöꞌ e Koaꞌ Teꞌ Pa Napan Kurus, a, amot po poen ne eöꞌ se hah me maꞌ o maaka peöꞌ, me o maaka pe Tamön, me o maaka po ankeroꞌ vivihan pe Sosoenën, eöꞌ se poet me e noꞌ pa teꞌ pamëh. ");
INSERT INTO tpz_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Eöꞌ to soe vaman ka neöm, a ma pah teꞌ to sun ne manih kuru, se meꞌ avoeꞌ ne pa mët ee he ep ee pa Matop Vih pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","O pöh nënkikiu to oah en pa ö ne Ieesuꞌ to soe a ma tah poë varih. Keꞌ me en pe Pitaꞌ, me ra poa tom kea e Jon, pen Jëmis. Kee peah ee pa tope pa hin. ");
INSERT INTO tpz_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ke Ieesuꞌ hinhin non, ka sionineah tarih, pareꞌ matan ke en, me o ohop peꞌ to tarih, ko kakaare oah rakah en vamanih pa unöh. ");
INSERT INTO tpz_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ka poa teꞌ tavus maꞌ, ko vavaato me e ne peꞌ, e Mosës pen Elaëjaꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","E Mosës pen Elaëjaꞌ to tavus me o maaka va pa vöön va kin, pare vavaato me e ne e Ieesuꞌ pa ö neꞌ se vapuh va in o iu pe Sosoenën pa ö neꞌ se mët manuh Jerusalëm. ");
INSERT INTO tpz_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","E Pitaꞌ me meh a poa vamomhë peꞌ to koroh, ivëhkëk, ee to sun ka matëëre maaka, kee ep ee po maaka pe Ieesuꞌ vaꞌpeh me a poa teꞌ neꞌ to vavaato me non. ");
INSERT INTO tpz_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","E Mosës pen Elaëjaꞌ se vakëh ee ke Ieesuꞌ, ke Pitaꞌ soe ke Ieesuꞌ pan, “Eeh, Apuh, eꞌ to parin vih pa ö na to teꞌ no manih, vaonöt ka möm ah, kemöm se eok a kukön këk, a paeh pën, ka teꞌ pe Mosës, me a teꞌ pe Elaëjaꞌ.” E Pitaꞌ to hikta maaka vavih vi non pa soe neꞌ to soe. ");
INSERT INTO tpz_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","E Pitaꞌ to vavaato avoeꞌ e non, ka unöh tavus maꞌ, ko pöm en pee, kee naöp rakah ee. ");
INSERT INTO tpz_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ka to taneꞌ maꞌ manih koman a unöh to soe non pan, “Eꞌ vaꞌih e Koaꞌ vateꞌ peöꞌ. Eöm se pënton, ko vatet a soe peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","A to pamëh to hik en, kee ep ee pe Ieesuꞌ pehen to sun non. Manih pa ma poen poë varih nee to hikta soe ke ta pah teꞌ a tah vaꞌih nee to ep in maꞌ, ee varoe a kukön to nat ne. ");
INSERT INTO tpz_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ka muhin takah en po meoh poen, kee këh ee maꞌ pa tope, pare hah kunah ee maꞌ. A napan o pöh peo to ep in e Ieesuꞌ manih hanan. ");
INSERT INTO tpz_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","A pah teꞌ to teꞌ non topnin a napan poë varih to toto suntan e non maꞌ pan, “Apuh, eöꞌ to okook rakah noꞌ nös oah se ep pa pah koaꞌ oeteꞌ ro peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","A oraꞌ hat to teꞌ non peꞌ, keꞌ kokoeꞌ suntan non, ko varikrik non poan, ko poë kakaare tatavus no maꞌ sih pa rivoneah. A oraꞌ hat to mimiroꞌ tamoaan e non peꞌ, ko hikta këkëh non poan. ");
INSERT INTO tpz_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Eöꞌ to hin vakis a ma vamomhë pën, pan ee se veo a oraꞌ hat pamëh, keꞌ këh e koaꞌ. Ivëhkëk eꞌe to hikta onöt ne.” ");
INSERT INTO tpz_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","E Ieesuꞌ to piun raoe, ko soe pan, “Eöm kurus varih to hikta vaman avoeꞌ rakah nem e Sosoenën se vatoꞌ en po teꞌ, eöm a nap hat. O tovih poen ne eöꞌ se teꞌ vaꞌpeh tamoaan me a noꞌ neöm? O tovih poen ne eöꞌ se teꞌ a ma punis peöm?” Ke Ieesuꞌ tarih na pe taman e koaꞌ, ko soe pan, “Me maꞌ e koaꞌ pën manih peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","E koaꞌ to nö maꞌ manih pe Ieesuꞌ, ka oraꞌ hat vi en pe koaꞌ manih po oeh, keꞌ rikrik e non. Ke Ieesuꞌ siröꞌ a oraꞌ hat, keꞌ këh en pe koaꞌ. E Ieesuꞌ to vatoꞌ en pe koaꞌ, pareꞌ heꞌ hah en pe tamaneah. ");
INSERT INTO tpz_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ka ma napan ep in o kikis pe Sosoenën, pare pah toksean rakah ee. A ma napan to pah kokoman vörep e ne pa ma tah kurus varih ne Ieesuꞌ to nonok non, keꞌ soe ke a ma vamomhë peꞌ pan, ");
INSERT INTO tpz_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Eöm se nat nem anoe in a soe natsean vaꞌih nöꞌ se soe ka neöm. Eꞌ hikta se teꞌ rë non, ka teꞌ se vikuh en peöꞌ e Koaꞌ Teꞌ Pa Napan Kurus pa koreera nap hat.” ");
INSERT INTO tpz_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ivëhkëk, e Sosoenën to koaan en pee pa pusun in a soe, kee hikta maaka ne a ma tah varih se tavus. Kee nanaöp e ne pa hi e Ieesuꞌ a pusun in a soe pamëh. ");
INSERT INTO tpz_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","O vamomhë to vaato vaheve koman ee, suk eteh se teꞌ non a tasun apuh oah manih pee. ");
INSERT INTO tpz_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ke Ieesuꞌ nat en po kokoman vakoaan pee, ivëh, keꞌ vaoe vatët maꞌ a siꞌ koaꞌ soneꞌ, ko vasun poan pa havineah, ");
INSERT INTO tpz_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","pareꞌ soe ke raoe pan, “Eteh to kamöꞌ e koaꞌ soneꞌ to teꞌ va non manih pa siꞌ koaꞌ vëh, eꞌ to kamöꞌ me en peöꞌ. Ka teꞌ to kamöꞌ a non neoꞌ, eꞌ to kamöꞌ me e non pe Tamön vëh to vanö voh a maꞌ neoꞌ. Eteh to vaꞌaus o teꞌ arus, ee a pap teꞌ poë varih ne Sosoenën to koman non pan, ee se teꞌ ne o teꞌ apaꞌpuh.” ");
INSERT INTO tpz_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ke Jon soe ke Ieesuꞌ pan, “Apuh, emöm to ep maꞌ a pah teꞌ to veveo oraꞌ hat non pa ëhnöömah, ko soepip em peꞌ, suk eꞌ to hikta teꞌ non po kum pea.” ");
INSERT INTO tpz_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","E Ieesuꞌ to soe kurus ke raoe pan, “Eöm se nat nem soepip eah. A teꞌ to hikta vakihat me a rora, eꞌ a teꞌ pea.” ");
INSERT INTO tpz_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","O poen ne Sosoenën se me peah hah e Ieesuꞌ manuh pa vöön va kin to öök vatet en. Ivëh, ke Ieesuꞌ nok en po kokoman kikis peꞌ pa nö manuh Jerusalëm. ");
INSERT INTO tpz_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ke Ieesuꞌ vanö vovoh a ma teꞌ se teꞌ a soe peꞌ. A ma teꞌ poë varih to nö ee, pare vos ee pa vöön va Samëriaꞌ, pare iu vamatop ne a nö pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ivëhkëk, a ma napan va pa vöön pamëh to nat in e Ieesuꞌ me a ma vamomhë peꞌ se nö manuh Jerusalëm, ivëh, kee hikta iu vaonöt ne e Ieesuꞌ me a ma vamomhë peꞌ pa nö manuh pa vöön pee. ");
INSERT INTO tpz_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","A poa vamomhë peꞌ, e Jëmis, pen e Jon to ep in a tah vaꞌih, pare soe ke Ieesuꞌ pan, “Apuh, eën se keh iu nom kemöm hin na a suraꞌ va pa vöön va kin, keꞌ ës ra napan varih?” ");
INSERT INTO tpz_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ivëhkëk, e Ieesuꞌ to tarih manih pee pon, pareꞌ siröꞌ raoe to vaato vapiun e ne. ");
INSERT INTO tpz_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kee nö pet ee pa meh vöön. ");
INSERT INTO tpz_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ee to nönö ne hanan, ka pah teꞌ soe ke Ieesuꞌ pan, “A ma vöön kurus nën to nönö nom ne eöꞌ se suk eoꞌ pën.” ");
INSERT INTO tpz_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ke Ieesuꞌ soe ke a teꞌ pamëh, “O këh poa to teꞌ me ne a ma koveꞌ teꞌteꞌ pee, ko növan teꞌ me ne pa ma heꞌ teꞌteꞌ pee. Ivëhkëk, eöꞌ e Koaꞌ Teꞌ pa Napan Kurus to hikta teꞌ me noꞌ ta ö ne eöꞌ se koroh ko vanot.” ");
INSERT INTO tpz_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Eꞌ to soe ke a meh teꞌ pan, “Suk a maꞌ neoꞌ ah.” Ivëhkëk, a teꞌ pamëh to soe, “Apuh eꞌ to vih non pën se vaonöt ka neoꞌ köꞌ nö ko pe voh maꞌ e tamön.” ");
INSERT INTO tpz_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ke Ieesuꞌ piun poan, pareꞌ soe, “Ahik, suk a maꞌ neoꞌ ah, parën koe o teꞌ varih to hikta kon avoeꞌ ne o toꞌtoꞌ tamoaan, kee nö, pare pe o upöm teꞌ mët pee. Ivëhkëk, eën se nö, parën vatvus a soe va pa Matop Vih pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ka meh teꞌ soe ke Ieesuꞌ pan, “Apuh, eöꞌ to iu vatet nom oah. Ivëhkëk, eën se vaonöt ka neoꞌ, köꞌ nö ko vaöt koren me voh maꞌ a tapaiuun peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ke Ieesuꞌ soe ke poan, “A teꞌ to taneo pa pënton, ko vatet a neoꞌ, ivëhkëk, eꞌ to vahahah non pa ma taateꞌ hat moaan voh peꞌ, eꞌ a teꞌ pamëh to hikta onöt non a ho pa koman a Matop Vih pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ka vasuksuk ne Ieesuꞌ to vateꞌ o 72 vamomhë, ko vamatop raoe pa ma tah nee se nö, ko nok, pareꞌ vanö po pöök vovoh raoe pa ma vöön neꞌ se nö amot. ");
INSERT INTO tpz_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ee to meꞌ avoeꞌ e ne pa nö, ke Ieesuꞌ soe ke raoe pan, “A napan o pöh peo to vamatop ne a vaman a neoꞌ pa ö söm vaꞌaus raoe. Ivëhkëk, a hikta nap peo pa vatvus ke raoe a Soe Vih. Ee to teꞌ va ne manih pa voaꞌ to vamatop manih koman a rak, ka hikta nap kiu peo pa oes a voaꞌ. Ivëh, köm se hinhin nem e Sosoenën, keꞌ se vamatop a ma napan peo, kee vaman a neoꞌ. Eöm se hinhin nem e Sosoenën, keꞌ vanö maꞌ a nap kiu peo manih pa rak. ");
INSERT INTO tpz_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nö öm, eöꞌ to vanö va ka neöm manih po sipsip soneꞌ to teꞌ ne topnin o këh poa. ");
INSERT INTO tpz_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Eöm se nat nem teꞌ ta moniꞌ, me o kove, me ta meh poa suꞌ, ko nat nem vaato me a napan varih hanan. ");
INSERT INTO tpz_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Eöm se keh ho pa ta pah iuun, eöm se hin na e Sosoenën, ko soe vamanih pan, ‘E Sosoenën se heꞌ a taateꞌ moomo manih pa napan to teꞌ ne pa iuun pamëh.’ ");
INSERT INTO tpz_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ka pah teꞌ moomo koman se keh teꞌ non pa iuun nën to teꞌ nom e Sosoenën se heꞌ a taateꞌ moomo pa teꞌ pamëh, me a tapaiuun peꞌ. Ivëhkëk, eꞌ se keh hikta teꞌ non a teꞌ kamöꞌ manih iuun, e Sosoenën se kon hah këh poë pa taateꞌ moomo, me a tapaiuun peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Eöm se teꞌ varoe nem pa pah iuun, paröm ënëën nem a ma taëën nee to vamatop ka neöm. Suk ataeah, a teꞌ to kiu vakis non pa vaꞌaus a napan, a, a napan se heꞌ ee peꞌ po voen peꞌ. Eöm se nat nem oho totoën vah nem a ma meh iuun. ");
INSERT INTO tpz_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Eöm se keh vos pa ta pah vöön, ka napan vaeö me e ne peöm, eöm se ëën a taëën nee to heꞌ a neöm. ");
INSERT INTO tpz_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Eöm se vavatoꞌ ro teꞌ to teꞌ me ne a mët pa vöön pamëh, paröm soe ke raoe pan, ‘A Matop Vih pe Sosoenën to öök vatët en maꞌ manih peöm.’ ");
INSERT INTO tpz_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ivëhkëk, eöm se keh vos pa ta vöön, ka napan hikta kamöꞌ a neöm pa ma iuun pee, eöm se nö, ko sun manuh noton hanan in a vöön pamëh, paröm soe pan, ");
INSERT INTO tpz_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘O kusan va pa vöön peöm ivëh to taop non pa ma monmöm, ivëhkëk, emöm to vahah em nös peꞌ manih peöm. Pënton öm, eöm to koe em pe Sosoenën vamanih pa teꞌ sunön peöm. Ivëhkëk, a ma poen va pa Matop Vih pe Sosoenën to öök vatët ee maꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Eöꞌ to soe ka neöm, manih po poen ne Sosoenën se kiiki a napan varih po oeh, a napan va pa vöön Södom neꞌ se vakmis vasoneꞌ en pee. Ivëhkëk, a napan va pa vöön vëh to koe ka neoꞌ, e Sosoenën se vakmis oah raoe.” ");
INSERT INTO tpz_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Varenan rakah peöm a napan va pa poa vöön varih Korasin, me Bëtsaëtaꞌ. Ta pah teꞌ se keh nok voh ta tah vatoksean manih pa poa vöön varih Taëaꞌ, me Saëdon vamanih pa ö nöꞌ to nok vavoh topnineöm, a, a napan va Saëdon me Taëaꞌ to se panih vahik voh ee pa ma taateꞌ hat pee. Ko noh o rara pö va pa tamak, ko vauh o ö to vataare non a ö nee to tamak ne a ma taateꞌ hat pee. Ivëhkëk, ee hikta panih a ma hat pee. ");
INSERT INTO tpz_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Amot po poen ne Sosoenën se kiiki non a ma napan, a punis va Saëdon me Taëaꞌ hikta se teꞌ apuh va non manih pa punis vëh nöm se taum, suk eöm to ep voh em pa ma tah vatoksean nöꞌ to nok voh topnineöm, ivëhkëk eöm to hikta panih, ko vaman. ");
INSERT INTO tpz_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ke eöm a napan va Kapaneam, eöm se nat nem kokoman nem pan, e Sosoenën se ta a no neöm, suk eöm to ep voh e nem peöꞌ, ko pënton voh e nem peöꞌ. Ivëhpëhkëk, eꞌ se vi a neöm po suraꞌ ësës tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ke Ieesuꞌ tarih hah na po 72 vamomhë, pareꞌ soe ke raoe pan, “A teꞌ to pënton a soe peöm, eꞌ to pënton a soe peöꞌ. A teꞌ to heꞌ tonun a neöm, eꞌ to heꞌ tonun a neoꞌ. Ka teꞌ to heꞌ tonun a neoꞌ, eꞌ to heꞌ tonun me en pe Sosoenën vëh to vanö voh a maꞌ neoꞌ.” E Ieesuꞌ to heꞌ vahik a soe peꞌ manih po 72 vamomhë, kee nö poꞌ ee. ");
INSERT INTO tpz_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Vasuksuk no o 72 vamomhë varih ne Ieesuꞌ to vanö voh, to hah ee maꞌ, pare vaeö rakah. Ee to soe ke Ieesuꞌ pan, “Apuh, emöm to pokaꞌ a ëhnöömah pa vavatoꞌ o teꞌ to haraꞌ ne a mët, ivëh, ka ma oraꞌ hat koman me to pënton ee pa soe pemöm, ko tavus këh ee maꞌ po teꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ke Ieesuꞌ soe ke raoe pan, “Eöꞌ to ep e susun po oraꞌ hat to vuꞌ taneꞌ maꞌ pa vöön va kin vamanih po tëkrea va pa kara. ");
INSERT INTO tpz_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pënton öm, eöꞌ to heꞌ voh eoꞌ peöm po kikis marën a komtön o kuruꞌ, me o pipihkatan, me a ma taeah to mimiröꞌ a non neöm, ivëh, keöꞌ heꞌ a neöm o kikis to teꞌ oah e non po kikis pe susun po oraꞌ hat. Ka hikta pah tah to antoen non a miröꞌ a neöm. ");
INSERT INTO tpz_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ivëh, ke eöm se nat nem vaeö varoe, paröm soe vamanih pan, ‘A ma oraꞌ hat to vatet ee pa soe pemöm,’ ahik, eöm se vaeö suntan oah, suk e Sosoenën to kiun voh en pa ëhnëëneöm pa teꞌ vaꞌpeh tamoaan me eah manuh pa vöön va kin.” ");
INSERT INTO tpz_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Manih po poen pamëh no a Tuvuh Vasioꞌ to heꞌ vaeö suntan e Ieesuꞌ, keꞌ soe pan, “Tamön, eën e Sunön va pa vöön va kin me po oeh. Eöꞌ to vaeö rakah me nös oah, suk eën to koaan voh a ma tah varih pa nap nat me nap natsean va po oeh. Ivëhkëk, eën to vataare varoe o teꞌ to teꞌ va ne manih po siꞌ koaꞌ. Tamön, a tah vaꞌih to tanok suk e non po iu me o manin koman pën.” ");
INSERT INTO tpz_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","E Ieesuꞌ to hin vahik en, pareꞌ tarih maꞌ manih pa napan varih to pënton ne poë, pareꞌ soe pan, “E Tamön to heꞌ voh en peöꞌ pa ma moeh tah kurus. A hikta teꞌ to nat non pe Koaꞌ, e Tamön varoe kuru to nat non pe Koaꞌ, ka hikta pah teꞌ to nat non pe Tamön, e Koaꞌ varoe kuru to nat non pe Tamön. Ka napan ne Koaꞌ to iu vataare non raoe e Tamön, eꞌe me to nat e ne pe Tamön.” ");
INSERT INTO tpz_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","E Ieesuꞌ to tarih ko soe varoe ke a ma vamomhë peꞌ pan, “O teꞌ se ep in a ma tah nöm to ep, eꞌe se vaeö. ");
INSERT INTO tpz_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Eöꞌ to soe va ka neöm manih, suk moaan voh no a ma teꞌ vanënën soe, me o teꞌ sunön peo to iu ep voh ne a ma tah nöm to ep in kuru. Ivëhkëk, ee to hikta ep voh. Pare iu tënan rakah ne a soe pamëh. Ivëhkëk, ee to hikta tënan voh a soe pamëh.” ");
INSERT INTO tpz_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","A pah teꞌ vavaasis to nat non o Vavaasis pe Mosës to sun, ko iu punöꞌ non e Ieesuꞌ, pareꞌ hi pan, “Apuh, eöꞌ se nok ataeah, paröꞌ kon o toꞌtoꞌ tamoaan?” ");
INSERT INTO tpz_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ke Ieesuꞌ piun, ko soe pan, “A soe taeah to teꞌ non po Vavaasis pe Mosës, eën ëhëh, ko nat vah va e nom eah nih?” ");
INSERT INTO tpz_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ka teꞌ vavaasis pamëh piun, ko soe pan, “Eöm se iu rakah nom e Sunön Sosoenën peöm manih pa ma kupu peöm, me manih pa ma apeneöm, me manih pa ma kikis kurus rakah peöm, me manih pa ma kokoman peöm.” Me, “Eën se iu non a meh teꞌ vamanih pa ö nën to iu hah va ka nom.” ");
INSERT INTO tpz_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ke Ieesuꞌ soe ke poan, “A, eën to piun vatotoopin rakah eom maꞌ. Eën se nok va nën, kën se kon o toꞌtoꞌ tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ivëhkëk, a teꞌ vavaasis to nat non o Vavaasis pe Mosës to iu kë hah a non, ivëh, keꞌ hi e Ieesuꞌ pan, “Ka meh teꞌ peöꞌ eꞌ eteh, nöꞌ se kamöꞌ noꞌ eah?” ");
INSERT INTO tpz_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ke Ieesuꞌ piun a soe peꞌ pa soe vapipinoꞌ, ko soe pan, “A pah teꞌ to këh maꞌ a vöön Jerusalëm, pareꞌ kukunah nö non manuh pa vöön Jerikoꞌ, ka nap kakaveo ep in poë manih hanan, pare öt këh ee peꞌ pa ma tah peꞌ, pare ip suntan poë. Ee to ip poë, pare këh ee peꞌ to koroh non hanan, a siꞌ ö hat keꞌ mët en. ");
INSERT INTO tpz_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ka manih po poen pamëh no a pah teꞌ ësës heꞌ to suk kunah maꞌ a hanan pamëh. Pareꞌ ep in a teꞌ pamëh, pareꞌ keke, ko oah en, ko hikta vaꞌaus poan. ");
INSERT INTO tpz_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Keꞌ teꞌ pet va kov e non nën pa Livaë, to nö maꞌ, pareꞌ ep in a teꞌ pamëh, pareꞌ keke, ko oah pet en peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ivëhkëk, a teꞌ va Samëriaꞌ to suk kunah maꞌ a hanan, pareꞌ ep in a teꞌ pamëh, pareꞌ pah uruan suntan en peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Pareꞌ huk vatët en manuh peꞌ, pareꞌ koꞌkoꞌ en po vanom me o voaën manih pa ma takeo peꞌ, pareꞌ mon en, ko kë poan, ko vaihoꞌ poan pa tönkiꞌ koman peꞌ, ko me poan pa iuun ananoeh teꞌ, pareꞌ matop vavih e non peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Po meoh poen neꞌ to heꞌ en pe tövaneah pa iuun pa moniꞌ to antoen non a matop a teꞌ pamëh, pareꞌ soe ke tövaneah pa iuun pan, ‘Eën se matop nom a teꞌ vëh, ka ta ma meh moniꞌ peo pën se keh hik pa matop a teꞌ vëh, a, eöꞌ se hah maꞌ, ko piun hah ka oah.’” ");
INSERT INTO tpz_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ke Ieesuꞌ hi a teꞌ vavaasis to nat non o Vavaasis pe Mosës pan, “Eën koman va nom nih? Eteh rakah manih pa kukön teꞌ varih to iu suntan non a meh teꞌ, manih pa teꞌ vëh to takeo pa koreera ra nap kakaveo?” ");
INSERT INTO tpz_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ka teꞌ vavaasis to nat non o Vavaasis pe Mosës piun, ko soe pan, “A teꞌ vëh to uruan, pareꞌ vaꞌaus poan.” Ke Ieesuꞌ soe ke poan pan, “Eën se nö, parën nok pet va nën.” ");
INSERT INTO tpz_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","E Ieesuꞌ me a ma vamomhë peꞌ to nönö ne Jerusalëm, pare vos ee pa vöön pa köövo a ëhnaneah e Martaꞌ. E köövo pamëh to vaoe e Ieesuꞌ manuh pa iuun peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","E Martaꞌ to teꞌ non e kea peꞌ, e Mariaꞌ. Eꞌ to nö maꞌ, pareꞌ ihoꞌ pa havin e Ieesuꞌ, pareꞌ pënton non o vavaasis peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ivëhkëk, e Martaꞌ to kiu vëhvaꞌ rakah non pa vamatop a taëën. Ke Martaꞌ hikta teꞌ vaeö non pa ö ne Mariaꞌ to vapehen non poan. Ivëh, keꞌ nö manih pe Ieesuꞌ, pareꞌ soe, “Apuh, e kea peöꞌ to vapehen ka neoꞌ pa vamatop a taëën. Eën to hikta koman pöꞌ nom a tah pamëh, ha? Eën se soe keah, keꞌ nö maꞌ, ko vaꞌaus a neoꞌ, pa vamatop a taëën!” ");
INSERT INTO tpz_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ivëhkëk, e Ieesuꞌ to piun e Martaꞌ, pareꞌ soe, “Martaꞌ, pënton nom ah, eën to karë suntan nom a ma tah peo. ");
INSERT INTO tpz_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ivëhkëk, a siꞌ pah tah to apuh oah rakah non. E Mariaꞌ to iu kon non, o vavaasis peöꞌ to vih oah non, ivëh, keöꞌ hikta se kon hah këh noꞌ eah.” ");
INSERT INTO tpz_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","O pöh poen ne Ieesuꞌ to hinhin non pa siꞌ ö. Eꞌ to hin vahik en, ka pah vamomhë peꞌ soe ke poan pan, “Apuh, vavaasis a möm a ö hinhin ava manuh pe Sosoenën, vamanih pa ö ne Jon to vavaasis vavoh in a ma teꞌ vamomhë peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ke Ieesuꞌ soe ke raoe, pa ö nee se hinhin va ne, “Eöm se hin vamanih pan, ‘Tamamöm a ëhnöömah to teꞌ vasioꞌ tamoaan, A Matop Vih pën se nö maꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Heꞌ a maꞌ möm a taëën to onöt non a ma poen kurus, ");
INSERT INTO tpz_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ihan anoe a ma hat pemöm, suk emöm to ihan anoe voh a ma hat, no upöm teꞌ to nok ka möm. Parën nat nom vaonöt a punöꞌ, keꞌ tavus manih pemöm.’” ");
INSERT INTO tpz_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","E Ieesuꞌ to vavaasis vahik a ma vamomhë peꞌ a ö hinhin ava, pareꞌ heꞌ raoe a pah soe vapipinoꞌ va pa taateꞌ hin, ko soe pan, “Ta pah teꞌ se keh teꞌ me non ta vakamöꞌ peꞌ, ka topnin poen rakah no a teꞌ pamëh to nö, pareꞌ soe ke poan, ‘Heꞌ a neoꞌ ah ta kukön muꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","A siꞌ vakamöꞌ peöꞌ to nö maꞌ, pareꞌ tavus a maꞌ neoꞌ, köꞌ hikta taëën söꞌ makën eah.’ ");
INSERT INTO tpz_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ka teꞌ vëh to teꞌ non koman iuun piun a soe peꞌ, pareꞌ soe ke poan pan, ‘Eën se nat nom vëhvaꞌ a neoꞌ. O hopaꞌ to papanih vur en, keöꞌ me ro koaꞌ to koroh vur em. Eöꞌ to hikta onöt noꞌ a sun, paröꞌ heꞌ a oah ta tah.’ ");
INSERT INTO tpz_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Eöꞌ to soe ka neöm, e tövaneah pa iuun to hikta koman non e vakamöꞌ peꞌ, ivëh, keꞌ se heꞌ poan ta tah. Ahik, eꞌ to rës e non pa tënan vatëh a teꞌ vëh to hinhin non poan. Ivëh, keꞌ sun, pareꞌ heꞌ en peꞌ pa tah neꞌ to kökööt non.” ");
INSERT INTO tpz_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ivëh, köꞌ soe ka neöm, eöm se hinhin vakis nem na e Sosoenën, keꞌ se heꞌ a maꞌ neöm ta tah ne eöm to kökööt e nem. Eöm se keh vavaiu nem e Sosoenën, eöm se taum em peꞌ. Eöm se tekteok o hopaꞌ, ke Sosoenën se peret ka neöm. ");
INSERT INTO tpz_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Suk ataeah, o teꞌ varih to hinhin vakis ne pe Sosoenën, ee se kon ee pa ma taneah nee to kökööt e ne. Ko teꞌ varih to vaiu vah ne e Sosoenën, ee se taum ee peꞌ. Ko teꞌ varih to tekteok ne o hopaꞌ, e Sosoenën se peret ken pee. ");
INSERT INTO tpz_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ta pah taman teh manih peöm to heꞌ e koaꞌ peꞌ a kuruꞌ, pa ö neꞌ to hin a iian? Ahik. ");
INSERT INTO tpz_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ke koaꞌ se keh hin e tamaneah to tök toaꞌ, e tamaneah se heꞌ pöꞌ en pe koaꞌ pa pipihkatan? Eꞌ me ahik rakah. ");
INSERT INTO tpz_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","A, eöm ro teꞌ hat to heꞌheꞌ nem sih a ma tah vihvih manih pa ma koaꞌ peöm, ivëh, ka se nat rakah e no, e Tamön va pa vöön va kin, eꞌ se heꞌ en maꞌ pa Tuvuh Vasioꞌ manih po teꞌ to hinhin ne poë.” ");
INSERT INTO tpz_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","E Ieesuꞌ to veo a oraꞌ hat to vapapön voh non sih a teꞌ. A oraꞌ hat to tavus këh en peꞌ, ka teꞌ taneo vaato en. Ka ma napan pah vatötöhkak ee. ");
INSERT INTO tpz_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ivëhkëk, a ma pah teꞌ to soe ee pan, “Eꞌ to veveo këh non o oraꞌ hat po kikis pe Belsebu, e susun po oraꞌ hat.” ");
INSERT INTO tpz_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ka ma meh teꞌ iu punöꞌ ne Ieesuꞌ, pare soe pan, “Eën se nok a tah vatoksean va pa vöön va kin, kemöm se nat pan, e Sosoenën to vanö maꞌ oah.” ");
INSERT INTO tpz_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ivëhkëk, e Ieesuꞌ to nat e non pa ma kokoman pee, ivëh keꞌ soe ke raoe pan, “A napan va pa pah muhin to teꞌ ne paan a matop pa paeh susun se keh taki vakëh, ko nok o pöök vuteꞌ, pare vapus koman hah, a, a muhin pamëh to hat rakah en. Ka pah tapaiuun se keh vavapus vatëh ne, ee se nö vakëkëh ee, ko vavutom taman se hat en. ");
INSERT INTO tpz_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ka oraꞌ hat, ke susun po oraꞌ hat se keh taki koman hah, ka matop peꞌ se teꞌ vaeh vah va non nih? Eöꞌ to soe vamanih, suk eöm to sosoe nem pan eöꞌ to veveo noꞌ ro oraꞌ hat po kikis pe Belsebu. ");
INSERT INTO tpz_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ivëhkëk, eöꞌ se keh veveo e noꞌ po oraꞌ hat po kikis pe Belsebu, keteh poꞌ to vavaꞌaus voh non a ma vamomhë peöm, kee veveo këh ne a napan po oraꞌ hat? Ivëh, ko vamomhë koman peöm vataare ee pa soe peöm to hikta teꞌ man non. ");
INSERT INTO tpz_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ivëhkëk, e Sosoenën se keh vaꞌaus e non peöꞌ, köꞌ veveo këh e noꞌ pa napan po oraꞌ hat, eꞌ to vataare e non pa Matop Vih pe Sosoenën to teꞌ topnin e non peöm. ");
INSERT INTO tpz_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“A teꞌ eh se keh öt non a ma tah vavapus, pareꞌ ut vavih non a iuun peꞌ, a ma tah kurus peꞌ se teꞌ vavih e ne. ");
INSERT INTO tpz_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ivëhkëk, a teꞌ eh oah se keh tavus maꞌ, pareꞌ onoah a teꞌ pamëh po vapus, pareꞌ kokon këh en peꞌ pa ma tah vavapus peꞌ, pareꞌ ki a ma ta kurus varih neꞌ to kaveo këh a teꞌ eh manih pa ma napan. ");
INSERT INTO tpz_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“A teꞌ to hikta teꞌ non e vakamöꞌ peöꞌ, eꞌ a teꞌ to vakihat me a no neoꞌ. Ka teꞌ to hikta vaꞌaus a no neoꞌ pa ununun maꞌ a napan manih pe Sosoenën se matop non, eꞌ to veveo e non pa napan këh e Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“A oraꞌ hat se keh këh tavus a teꞌ, eꞌ se nö ko nönö vah no maꞌ pa moeh upin to vavaiu vah non ta ö vavanot. Eꞌ se keh hikta ep in ta ö vavanot, eꞌ se soe en pan, ‘Eöꞌ se nö hah eoꞌ pa iuun moaan voh peöꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ko poen neꞌ to hah maꞌ, eꞌ to taum en pa iuun to teꞌ upin avoeꞌ e non nee to veveo tavus voh a noꞌ, keꞌ maaka, pare vatotoopin a ma tah. ");
INSERT INTO tpz_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ivëh, keꞌ nö hah ko me en maꞌ pa meh tönim me a poa oraꞌ hat to teꞌ hat oah rakah e ne peꞌ pa nok a taateꞌ hat. Kee nö ko ho ee pa koman iuun pamëh. Moaan voh a teꞌ vëh no a taateꞌ peꞌ to hat, ivëhkëk kuru, no a taateꞌ peꞌ to panih, keꞌ se teꞌ vahat oah rakah e non.” ");
INSERT INTO tpz_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","E Ieesuꞌ to vavaato avoeꞌ me e non pa nap peo poë varih. Ka pah köövo to teꞌ non topnin ra napan vaato vaꞌpuh maꞌ, ko soe pan, “E köövo vëh to vahuh, pareꞌ vasisiꞌ voh a oah, eꞌ se vaeö rakah.” ");
INSERT INTO tpz_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","E Ieesuꞌ to piun ko soe pan, “Teꞌ man e non, ivëhkëk, a napan varih to pënton a soe pe Sosoenën, pare vatet eꞌe se vaeö vaꞌpuh oah rakah o vaeö vëh ne sinaneoꞌ to teꞌ me non.” ");
INSERT INTO tpz_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","A ma napan peo rakah to tötönun avoeꞌ e ne maꞌ, ke Ieesuꞌ soe ke raoe pan, “Eöm a napan va kuru eöm ra nap hat. Eöm to hinhin nem a ö neöm se ep in ta pah tah vatoksean. Ivëhkëk, eöꞌ to hikta se vataare noꞌ neöm ta pah tah vatoksean. A tah vatoksean voh pe Jonaꞌ varoe se vataare a neöm. ");
INSERT INTO tpz_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Moaan voh e Jonaꞌ to tavus voh a tah vatoksean ne Sosoenën to vataare voh a napan va Ninivëꞌ. Keꞌ teꞌ akuk va kov e non manih peöꞌ e Koaꞌ Teꞌ Pa Napan Kurus se teꞌ noꞌ peöm a napan va kuru, pa ö nöꞌ se teꞌ o kukön potan me o kukön poen manih pa koman a koveꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Amot po poen ne Sosoenën se kiiki a ma napan e Köövo Sunön va Saöt se sun vaꞌpeh me a neöm kurus, pareꞌ vavatët vahik en pa ma taateꞌ hat pa napan va kuru. Suk ataeah, e Köövo Sunön pamëh to taneꞌ varo rakah en maꞌ, pareꞌ nö maꞌ pa pënton o nat vih no a teꞌ sunön vëh e Solomon to vavatvus non. Ivëhkëk, a pah teꞌ to teꞌ non manih kuru to teꞌ apuh oah e non pe Solomon, nöm to pënton varo rakah e nem pa ma teꞌ soe peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","O poen ne Sosoenën se kiiki non a ma napan, a napan va Ninivëꞌ se sun me a neöm a ma napan va kuru, pare vatvus a ma taateꞌ hat peöm. Suk a napan va Ninivëꞌ to tënan voh a soe ne Jonaꞌ to vatvus voh, ko panih a ma taateꞌ hat pee. Ka kuru a teꞌ to teꞌ apuh oah e non pe Jonaꞌ to teꞌ non topnin neöm. Ivëhkëk, eöm to rës e nem pa pënton a soe peꞌ, ko panih a ma taateꞌ hat peöm.” ");
INSERT INTO tpz_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“A teꞌ to vëkrea kës pöꞌ o ram, pareꞌ vahoꞌ hop koman o kove, keꞌ manih koman a baket, eh? Ahik, eꞌ se vahan o ram manih pa ö vavahan ram, ko teꞌ se ho maꞌ iuun, ko ep in o ëman pamëh. ");
INSERT INTO tpz_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","A matömah to teꞌ va non manih po ram va pa sioniumah. A matömah se keh teꞌ maaka non eën se ep vavih e nom ka sioniumah to teꞌ me e non o ëman. Ivëhkëk, a matömah se keh hat, eën hikta se ep vavih nom. ");
INSERT INTO tpz_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ivëh, kën se ut vavih nom, pa tah nën to koman nom se teꞌ maaka non ko nat nom teꞌ nom pa popoen. ");
INSERT INTO tpz_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ivëh, ka sioniumah se keh teꞌ me e non po ëman, ka hikta pah ö manih peꞌ to popoen, eꞌ se pah teꞌ maaka kurus e non vamanih po ëman in o ram to ëman non manih pën. ");
INSERT INTO tpz_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","E Ieesuꞌ to vahik vaato en, ka pah to Parësiꞌ vaoe maꞌ e Ieesuꞌ pan, eꞌ se ëën vaꞌpeh me poan. Ke Ieesuꞌ ho ko ihoꞌ vamatop en pa ëën. ");
INSERT INTO tpz_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ka to Parësiꞌ ep in e Ieesuꞌ to ënëën non to hikta pupui momoaan a poa koreneah vamanih pa ö no a taateꞌ po Jiuꞌ to soe va non. ");
INSERT INTO tpz_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ivëhkëk, e Ieesuꞌ to soe ke poan pan, “Eöm ro Parësiꞌ, eöm to pupui vavoon varoe nem a tonun a ma kap me o peret. Ivëhkëk, manih pa komëneöm no a taateꞌ hat, me a taateꞌ kaveo to puh rakah non. ");
INSERT INTO tpz_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Eöm ro teꞌ o pöh papön rakah, e Sosoenën pöꞌ to nok varoe voh a ö tonun, ko hikta nok voh a ö koman in a ma tah, ha? ");
INSERT INTO tpz_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ivëhkëk, eöm to vavatet nem a taateꞌ nok koman peöm pa heꞌ vaeö e Sosoenën. Eöm hikta vaꞌaus nem a ma napan varih to arus ne a ma tah, eöm se vaꞌaus raoe me o vaeö. Eöm se keh nok vamanih, ka ma meh tah se teꞌ maaka ke ne peöm, ke Sosoenën ep vavih e non peöm. ");
INSERT INTO tpz_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Varenan rakah peöm o Parësiꞌ! Eöm to heꞌheꞌ nem sih a ma tah varih nöm to nep, paröm ununun a havun ö tah, ko kon taneꞌ a pah ö tah nën, ko heꞌ na e Sosoenën. Ivëhkëk, eöm to vanun voh em pa ma meh taateꞌ to teꞌ apuh oah ne a taateꞌ vaheꞌheꞌ. A ma taateꞌ varih pan, iu e Sosoenën, me nok a taateꞌ totoopin manih pa napan. Eöm se vavatet rakah nem a ma taateꞌ poë varih, paröm heꞌheꞌ nem na e Sosoenën a pah ö tah nöm to kon taneꞌ manih koman a ma tah nöm to nepnep nem.” ");
INSERT INTO tpz_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Varenan rakah peöm o Parësiꞌ! Eöm to iu rakah nem a ö nöm se ihoꞌ nem pa ma ö ihihoꞌ po teꞌ susunön manih pa koman a iuun hinhin soneꞌ, paröm iu rakah nem a napan se soe a potan avih manih peöm pa ma ö vatötönun. ");
INSERT INTO tpz_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Varenan rakah peöm! Eöm to ep vavih e nem manih mahën, ivëhkëk, manuh koman, a teꞌ mët to teꞌ non.” ");
INSERT INTO tpz_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ka pah teꞌ vavaasis to nat i non o Vavaasis pe Mosës piun, pareꞌ soe pan, “Apuh, o Vavaasis nën to heꞌ to huh rakah e non pe pemöm.” ");
INSERT INTO tpz_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ke Ieesuꞌ soe pan, “Eöm ro teꞌ vavaasis to nat nem o Vavaasis pe Mosës, varenan rakah peöm! Eöm to vavateꞌ nem sih a ma taateꞌ kikis no a napan se vavatet ne. Ivëhkëk, eöm koman to hikta vavatet nem, paröm hikta vavaꞌaus nem raoe pa vatet a ma taateꞌ varih, nöm to iu nem nee se vatet. ");
INSERT INTO tpz_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Varenan rakah peöm! Eöm to nonok vavih nem a ma koveꞌ no teꞌ vanënën soe to mët voh, ko pe ne, no a ma kën sipuineöm to ip vamët voh raoe. ");
INSERT INTO tpz_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Manih pa taateꞌ pa nok vavih o vapeepe, eꞌ to vataare e non peöm to vapöh kokoman me e nem pee pa ma tah hat no a kën sipuineöm to nok voh. ");
INSERT INTO tpz_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Ivëh ke Sosoenën nat voh e non po nat vih rakah, pareꞌ soe voh en pan, ‘Eöꞌ se vanö a ma teꞌ vanënën soe me o aposol, ka napan se ip vamët a ma paeh pee, pare vakmis ee o upöm.’ ");
INSERT INTO tpz_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ivëh, ka napan va kuru se teen a ma teꞌ vanënën soe varih to mët voh taneo no maꞌ po poen ne Sosoenën to nok voh o oeh. ");
INSERT INTO tpz_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Eꞌ to taneo no maꞌ pa mët voh pe Ebel, keꞌ öök ma pa mët pe Sakarias, eꞌ to mët voh topnin a pok vapenpen me a iuun pe Sosoenën. A, eöꞌ to soe ka neöm, o Jiuꞌ to teꞌ toꞌtoꞌ nem kuru se kon kamis suk a ma teꞌ poë varih.” ");
INSERT INTO tpz_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Eöm varih o teꞌ vavaasis to nat nem o Vavaasis pe Mosës, varenan rakah peöm! Eöm to sunpip voh em pa napan pa ho maꞌ po hopaꞌ pa kon o nat manih pe Sosoenën, eöm koman to hikta peret o hopaꞌ, paröm ho. Ivëh, ke eöm koman to hikta nat nem pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","E Ieesuꞌ to këh tavus en pa iuun, ko teꞌ vavaasis to nat ne po Vavaasis pe Mosës, me ro Parësiꞌ to heve rakah ee, ko ihi ne poë a ma vu hi pa vöknah a ma soe peꞌ. Pare iu vakëën ne poë pa ma piun neꞌ to pinpiun non a ma hi pee. ");
INSERT INTO tpz_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ee to iu öt rakah ne poë, ko vateꞌ po vahutët pa ö neꞌ se piun a soe hat. ");
INSERT INTO tpz_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","A napan peo rakah to tönun maꞌ to onöt e ne pa ö no upöm se komtön ee pa ma meh teꞌ. Manih po poen pamëh e Ieesuꞌ to soe momoaan ken pa ma vamomhë peꞌ pan, “Eöm se matop vavih nem pa nap mokoꞌ rivoe pikpiuk varih o Parësiꞌ, to vamahun e ne peöm po piuk vamanih po is na to hovën o praoaꞌ. Eöm se nat nem kon a taateꞌ piuk pee. ");
INSERT INTO tpz_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","A ma kokoman vakoaan va pa taateꞌ piuk, amot se teraꞌ ee, ka napan nat vahik ee pee. ");
INSERT INTO tpz_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ivëh, ka soe nöm to vavaasis vakoaan voh ke nem ro upöm teꞌ, amot nee se soe tavus eah pa matëëra napan. Ka soe neöm to vavisvis voh i em koman iuun, amot nee se sun, ko vatvus eah pa napan.” ");
INSERT INTO tpz_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ma vakamöꞌ peöꞌ, eöm se nat nem nanaöp nem o teꞌ se ip vamët o sionin varoe, ka amot nee to hikta onöt ne a ip vamët a ma apeneöm. ");
INSERT INTO tpz_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Eöꞌ se soe ka neöm, a teꞌ vëh nöm se nanaöp nem eah. Eöm se naöp varoe nem e Sosoenën vëh se ip vamët a neöm, ko vanö en pa apeneöm manuh po suraꞌ ësës tamoaan. ");
INSERT INTO tpz_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Eöm to nat e nem, a napan to vonvoen ne sih a tönim növan pa poa toeaꞌ. Ivëhkëk, a hikta pah soneꞌ növan ne Sosoenën se anoe. ");
INSERT INTO tpz_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Eꞌ to ëh vahik voh en pa ma paꞌ uvin kurus neöm. Ivëh, köm se nat nem nanaöp nem pataeah no a ma napan se nok amot manih peöm, suk eöm to teꞌ oah rakah e nem po siꞌ növan sosoneꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Eöꞌ to soe ka neöm, ta pah teꞌ se keh vaman a neoꞌ, ko vatvus a ëhnaneoꞌ manih pa matëëra ma napan, a, eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus me se vatvus eoꞌ pa ëhnan a teꞌ pamëh manih pa matëëra ma ankeroꞌ pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ivëhkëk, a teꞌ se keh vonih pan, eꞌ to hikta nat a non neoꞌ pa matëëra ma napan, a, eöꞌ me se vonih pan, eöꞌ to hikta nat noꞌ peꞌ manih pa matëëra ma ankeroꞌ pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ta pah teꞌ se keh soe viivi a neoꞌ e Koaꞌ Teꞌ Pa Napan Kurus, e Sosoenën se ihan anoe en pa hat pa teꞌ pamëh. Ivëhkëk, a teꞌ vëh to soe viivi a Tuvuh Vasioꞌ, e Sosoenën hikta se ihan anoe non a hat peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“A napan se keh me a neöm manih pa ma iuun hinhin soneꞌ, me pa matëëro teꞌ varih to vovoh ne, me a ma teꞌ susunön va pa kaman, a, eöm se nat nem nanaöp nem, paröm koman nem pan eöm se piun vah va in na soe nih? ");
INSERT INTO tpz_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","A Tuvuh Vasioꞌ se vavaasis en peöm pa soe nöm se piun ke raoe.” ");
INSERT INTO tpz_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","A pah teꞌ manih pa napan poë varih to soe ke Ieesuꞌ pan, “Tövavaasis, eöꞌ to iu noꞌ a ö nën se soe ke kea peöꞌ, keꞌ ki vakëh a ma tah ne tamön to mët këh, pareꞌ heꞌ a neoꞌ a papan peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ivëhkëk, e Ieesuꞌ to soe ke poan, “Eteh to vateꞌ voh a neoꞌ a teꞌ kiiki tah peöm?” ");
INSERT INTO tpz_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ke Ieesuꞌ soe ke raoe pan, “Eöm se ut vavih rakah nem, paröm koe a manin a ma moeh tah. A teꞌ to vaneah non a ma tah peo rakah eꞌ a ma tah poë varih hikta se vaꞌaus ne o toꞌtoꞌ peꞌ, pan eꞌ se vaeö tamoaan non ko teꞌ varë non manih po oeh.” ");
INSERT INTO tpz_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ke Ieesuꞌ heꞌ en po pöh soe vapipinoꞌ, pareꞌ soe pan, “A taëën pa teꞌ öt moniꞌ vörep to rereaꞌ en. ");
INSERT INTO tpz_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Manih po kokoman pa teꞌ öt ö pamëh, eꞌ to koman va non manih pan, ‘Eöꞌ se poꞌ nok vah vanih? Eöꞌ to hikta teꞌ noꞌ tah iuun to onöt non a ö noꞌ se ununun a ma taëën kurus peöꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pareꞌ soe pan, ‘Eöꞌ se nok vamanih, eöꞌ se kökök a ma iuun taëën kurus peöꞌ, paröꞌ eok vaꞌpuh a ma meh iuun taëën voon, ko ununun a ma taëën me a ma moeh tah vihvih kurus peöꞌ, manih pa ma iuun voon poë varih. ");
INSERT INTO tpz_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Eꞌ to soe koman hah kea pan, ‘A ma tah vihvih peo peöꞌ to se onöt a ma kirismas peo. Ivëh, köꞌ se vanot poꞌ, paröꞌ ënëën varoe noꞌ, ko teꞌ vaeö noꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ivëhkëk, e Sosoenën to soe ke poan pan, ‘Eën a teꞌ a pah papön rakah. Nös pa popoen sën mët eom. Ka ma tah kurus varih nën to ununun voh nom, eteh se kon?’ ");
INSERT INTO tpz_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Eꞌ to teꞌ akuk va kov e non manih po teꞌ varih to ununun vörep ne a ma tah peo koman pee, ivëhkëk, eꞌe to hikta ununun ne a ma tah vih ne Sosoenën to iu non.” ");
INSERT INTO tpz_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ke Ieesuꞌ tarih pareꞌ soe ke a ma vamomhë peꞌ pan, “Ivëh, köꞌ soe ka neöm, eöm se nat nem koman vörep nem o toꞌtoꞌ peöm, paröm soe vamanih pan, ‘Ea se ëën nös ataeah?’ Paröm nat nem koman vörep nem a sionineöm, paröm soe pan, ‘Ea se rara ataeah?’ ");
INSERT INTO tpz_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","A taateꞌ va pa vatet o iu pe Sunön, ko teꞌ vavih no to teꞌ oah e non pa taateꞌ va pa ëën vamhun. O toꞌtoꞌ to teꞌ oah rakah e non pa sioniumah, me eꞌ to teꞌ oah rakah e non pa tah ohop. ");
INSERT INTO tpz_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Eöm se ep po öꞌ, eꞌe to hikta nepnep taëën ne sih, ko osoes ne. Pare hikta ununun taëën ne sih. Eꞌe to hikta teꞌ me ne ta iuun vavahoꞌ taëën. Ivëhkëk, e Sosoenën to mamakën e non pee. Eöm a napan to teꞌ oah rakah e nem po öꞌ! ");
INSERT INTO tpz_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Eöm se nat nem karë vörep me nem a ma tah varih po oeh to hikta se varë pet non a pop peöm. ");
INSERT INTO tpz_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Köm se keh hikta onöt nem a nok ta siꞌ tah soneꞌ pa vaꞌaus a pop peöm manih po oeh, a, suk ataeah poꞌ, köm kokoman vörep nem a ma tah varih? ");
INSERT INTO tpz_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Eöm se inan vöh pa ö no a töpkaꞌ to pupu va ne. Ee tötöpkaꞌ vah va ne sih nih? Ee to hikta kikiu vëhvaꞌ ne sih manih pa vatëk hah rea. Ivëhkëk, eöꞌ to soe voh keoꞌ peöm, moaan voh e Solomon to ohop non a ma ohop mamatan vavih peꞌ, ivëhkëk, a matan vavih pa ma töpkaꞌ varih to matan vavih oah e ne pa ma ohop pe Solomon. ");
INSERT INTO tpz_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","A, o meon vëh to sun non koman a rak kuru, ka sinup nee se puit, ko vi ee po suraꞌ. Ko meon to teꞌ va non nën, ne Sosoenën to rara non sih poan. Ivëh, köm se nat me nem, e Sosoenën se matop vavih oah e non peöm pa ö neꞌ to matop va i non o meon. O siꞌ vaman peöm to soneꞌ vörep. ");
INSERT INTO tpz_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ivëh, köm se nat nem kokoman vörep hah a nem, pan eöm se ëën ataeah, paröm kaak ataeah. Eöm se nat nem kokoman vapunis nem. ");
INSERT INTO tpz_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","O teꞌ varih to hikta nat ne e Tamaara, eꞌe to kokoman vörep ne sih a ma tah varih po oeh, pare iu kon ne. Ivëhkëk, e Tamaara to nat e non pataeah na to kökööt no. Eöm se kon rakah em pa ma tah vih to teꞌ va non nën. ");
INSERT INTO tpz_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Eꞌ to vih oah rakah non pa ö nöm se iu nem a ma tah vih to heꞌ vaeö non e Sosoenën e Sunön peöm. Keꞌ se heꞌ a neöm a ma tah neöm kökööt nem me a matop vih peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Eöm ra ma teꞌ peöꞌ, eöm to teꞌ va nem manih po siꞌ kum sipsip se koe a naöp. E Tamëneöm vöh pa vöön va kin to iu rakah e non pa heꞌ a neöm a matop vih peꞌ manih peöm o vakum teꞌ keok. ");
INSERT INTO tpz_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Eöm se vavoen em pa ma pah tah peöm manih po teꞌ, ka moniꞌ nöm to kon, ne eöm se heꞌ pa vaꞌaus a nap arus. Ivëh, manih pa taateꞌ pamëh, eꞌ to teꞌ va non manih peöm to vahoꞌ a takoek manuh pa vöön va kin. Ka nap kakaveo hikta se kaveo ne me o kökörös hikta se ëën ne. ");
INSERT INTO tpz_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","A ö poanheh no a ma moeh takoek pën to pet ne, o kupu pën se pah pet vakis e non na nën.” ");
INSERT INTO tpz_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Eöm se vakökööt a ma rara peöm, paröm voh o voh, ko vëkrea o ram, paröm vamatop nem pa kiu manih pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Eöm se teꞌ rakah va nem manih po teꞌ to anoeh ne e sunön pee to hah taneꞌ maꞌ pa taëën va po vaen. Eꞌ se nö maꞌ, pareꞌ tekteok maꞌ o hopaꞌ, kee peret ohoꞌ o hopaꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","A teꞌ sunön se keh hah maꞌ, pareꞌ ep in a ma teꞌ kikiu peꞌ to hikta koroh ne, eꞌ se vaeö. Eöꞌ to soe vaman rakah ka neöm, e sunön koman se rara vamanih pa teꞌ kikiu, pareꞌ soe ke a ma teꞌ kikiu peꞌ pa ihoꞌ. Keꞌ koman ivëh se heꞌ raoe a taëën. ");
INSERT INTO tpz_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ke sunön se keh nö maꞌ pa topnin poen rakah, keꞌ manih pa tö vamomoaan pe toaꞌ, pareꞌ ep raoe to vamatop ne, to anoeh ne poë, e sunön se vaeö vaꞌpeh me en pee. ");
INSERT INTO tpz_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Eöm se nat va nem manih pan, e tövaneah pa iuun se keh nat momoaan en po poen no a teꞌ kakaveo se nö maꞌ, eꞌ se hikta vatö ke non a teꞌ kakaveo a iuun, keꞌ kök, pareꞌ ho. ");
INSERT INTO tpz_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ivëh, köm se teꞌ vamatop nem pa ma poen kurus, suk eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus tomeꞌ vöhnun a maꞌ neöm. ");
INSERT INTO tpz_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ke Pitaꞌ soe pan, “Sunön, eën to heꞌ varoe pöꞌ eom pemöm pa soe vapipinoꞌ vëh, keꞌ manih me pa ma napan kurus varih?” ");
INSERT INTO tpz_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ke Sunön piun, pareꞌ soe pan, “A teꞌ kikiu to teꞌ me pöꞌ e non po kokoman vih, pareꞌ matop vavih e non pa kiu peꞌ? E sunön koman peꞌ se kon poan e susun po teꞌ kikiu peꞌ, pareꞌ heꞌheꞌ non raoe a taëën po poen ne sunön to vateꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Amot no e sunön peꞌ se hah maꞌ, pareꞌ këh taum a teꞌ kikiu peꞌ to teꞌ avoeꞌ va e non pa ö neꞌ to soe va voh in poan, a, a teꞌ sunön se heꞌ poan o voen vih peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Eöꞌ to soe vaman rakah ka neöm, a teꞌ sunön se vahoꞌ en pa teꞌ kikiu peꞌ pa matop a ma tah kurus peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ivëhkëk, manih po kokoman pa teꞌ kikiu pamëh, eꞌ se keh koman va non manih pan, ‘E sunön peöꞌ hikta se nö vëhöꞌ hah no maꞌ.’ Ivëh, keꞌ taneo en pa ip o upöm teꞌ kikiu, me o köövo, pareꞌ ënëën non, ko kakaak vapapön varoe kov e non. ");
INSERT INTO tpz_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","A teꞌ sunön peꞌ se vöhnun maꞌ poan po poen neꞌ to hikta teꞌ vamatop non, me a aoaꞌ neꞌ to hikta nat non. E sunön se pah vakmis rakah en pa teꞌ kikiu pamëh, pareꞌ vahoꞌ vaꞌpeh me a napan varih to hikta vaman ne e Sunön. ");
INSERT INTO tpz_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","A teꞌ kikiu to nat vahik voh en pa tah ne sunön to iu non, ivëhkëk eꞌ to hikta vamatop ta pah tah, pareꞌ hikta vatet o iu pe sunön peꞌ, a teꞌ sunön se pah ip vahat rakah en peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ivëhkëk, a teꞌ kikiu to hikta nat non po iu pa teꞌ sunön, pareꞌ nonok e non pa taateꞌ to onöt e non pa ö neꞌ se kon vahat en, a teꞌ sunön se ip vatö en peꞌ. O teꞌ varih to kon a ma tah peo, eꞌe se heꞌ hah a ma tah peo. O teꞌ se keh heꞌ a ma tah peo manih pa pah teꞌ, eꞌe se hin poë a ma tah peo oah neꞌ se piun hah.” ");
INSERT INTO tpz_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Eöꞌ to nö voh maꞌ pa vamatop a hanan pe Sosoenën, keꞌ kiiki ko vakmis a ma napan varih to teꞌ ne pa taateꞌ hat vamanih po suraꞌ nöꞌ to vaës. Paröꞌ iu rakah noꞌ a ö no a suraꞌ pamëh se ës ohoꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ivëhkëk, eöꞌ se kon kamis, paröꞌ mët vovoh. Kuru o kokoman peöꞌ to punis rakah e non, suk eöꞌ tomeꞌ avoeꞌ e noꞌ pa kon kamis me pa mët. ");
INSERT INTO tpz_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Keꞌ, eöm to koman voh nem, pan eöꞌ to nö voh maꞌ pa vahik a ma vapus manih po oeh, eh? Ahik, eöꞌ to soe ka neöm, eöꞌ to nö maꞌ pa ki vakëh a ma napan. ");
INSERT INTO tpz_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Taneo non kuru me amot no a tönim teꞌ to teꞌ ne pa pah iuun, pare taki vakëh po pöök kum teꞌ, ka kukön teꞌ hat ke ne a poa teꞌ, ka pöök hat ke ne a kukön teꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kee se taki vakëh ee, ke taman se rës e non pe koaꞌ oeteꞌ peꞌ, ke koaꞌ oeteꞌ se rës e non pe tamaneah, ke köövo se rës e non pe semoneah, ke semoneah se rës e non pe sinaneah. Ke köövo töveneah se rës e non pe köövo muvaen peꞌ, ke köövo muvaen se rës e non pe köövo töveneah.” ");
INSERT INTO tpz_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","E Ieesuꞌ to soe ken pa ma napan pan, “Eöm to epep nem sih a unöh to peah maꞌ manuh pa tope, paröm soe ohoꞌ em pan, ‘A uhön se nus en.’ O pöh man rakah, ka uhön nus en maꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Paröm epep nem sih a tuvuh apuh to taneꞌ maꞌ tahiꞌ, ko soe em pan, ‘A potan se hivaꞌ rakah en.’ O pöh man rakah a potan hivaꞌ to tavus en. ");
INSERT INTO tpz_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Eöm ro teꞌ o pöh mokoꞌ rivon pikpiuk rakah! Eöm to iniinan vavih e nem sih po vëknöm va po oeh me a akis, ivëhkëk, eöm hikta iniinan vavih suk poꞌ nem o vëknöm va kuru ataeah?” ");
INSERT INTO tpz_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Suk ataeah, köm hikta kiiki vavih koman nem a taateꞌ to teꞌ totoopin non? ");
INSERT INTO tpz_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","O poen nën to iu vatotoopin nom a hat me a meh teꞌ vëh to kehkeh vahoꞌ a nom oah po vahutët, eöm se keh teꞌ avoeꞌ e nem hanan, eën se taneo eom pa vatotoopin a hat peöm. Eꞌ tomeꞌ me oah manuh pa koren e tökiiki vahutët, keꞌ vahoꞌ en pën manih pa koreero pirisman, ko pirisman vahoꞌ ee pën pa iuun nohnoh. ");
INSERT INTO tpz_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Eöꞌ se soe rakah ka oah, eën to hikta onöt rakah nom a këh tavus ohoꞌ maꞌ a iuun nohnoh, antoen non a ö nën se voen vahik a moniꞌ no a tökiiki vahutët to vateꞌ ka oah.” ");
INSERT INTO tpz_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Manih po poen pamëh no a ma pah teꞌ to teꞌ ne, pare vavatët e Ieesuꞌ a ö ne Paëlat to heꞌ voh o soe vaonöt manih po teꞌ vëvënsun va pa kaman va Room pa ip vamët voh a ma teꞌ va Galiliꞌ, ee he ësës heꞌ ne na manuh pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ke Ieesuꞌ piun a soe pee, pareꞌ soe pan, “Eöm to koman nem pan, a ma teꞌ va Galiliꞌ varih to nok vahat oah rakah pa ma upöm pee, ha? Ahik rakah! Eꞌ kuru a tah vaꞌih a pusun in a punis pee, ha? Ahik rakah! ");
INSERT INTO tpz_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ivëhkëk, eöm se keh hikta panih a ma taateꞌ hat peöm, eöm se ro rakah pet va kov em nën. ");
INSERT INTO tpz_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ka 18 teꞌ varih no a iuun rë va Siroam to ip vamët voh raoe. Eöm to koman nem pan, a hat pee to teꞌ oah e non pa ma teꞌ hat po teꞌ varih to teꞌ ne Jerusalëm, ha? ");
INSERT INTO tpz_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Eöꞌ to soe vaman rakah ka neöm, ahik rakah! Ivëhkëk, eöm se keh hikta panih a ma taateꞌ hat peöm, eöm se ro pet va kov em nën.” ");
INSERT INTO tpz_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ke Ieesuꞌ soe ken pee pa pah soe vapipinoꞌ pan, “A pah teꞌ to nep o naon vëh o fik koman a rak voaën peꞌ, vasuksuk neꞌ to nö maꞌ pa ep këh ta ma voaꞌ fik to ëën. Ivëhkëk, ahik. ");
INSERT INTO tpz_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ivëh, keꞌ soe ke a teꞌ vëh to matop non pa rak pan, ‘Ep ah, po kukön kirismas rakah neöꞌ to nönö noꞌ maꞌ sih pa ep këh ta ma voaꞌ fik to ëën, ivëhkëk, ahik. Ivëh, kën se taka eöm po naon vëh. Suk ataeah, o naon pamëh to ënëën vahik akuk e non po mona va po oeh.’ ");
INSERT INTO tpz_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ka teꞌ vëh to matop non pa rak, piun a soe peꞌ, pareꞌ soe pan, ‘Apuh, eën se koe ko anoeh voh nom, keꞌ teꞌ voh o siꞌ pöh kirismas vëh. Eöꞌ se een o oeh vëh po pusun o naon, paröꞌ vahoꞌ na a ma tairo purmakaöꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","O naon se pöꞌ voaꞌ en po kirismas vöh. Keꞌ se keh hikta voaꞌ, a, kën taka poꞌ eom peꞌ.’” ");
INSERT INTO tpz_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","O pöh Poen Apaapo ne Ieesuꞌ to vavaasis non a ma napan koman a iuun hinhin soneꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","A pah köövo to teꞌ non no a oraꞌ hat to teꞌ non peꞌ. A oraꞌ hat pamëh to heꞌ voh non e köövo a mët po 18 kirismas. Ke köövo hikta onöt rakah non a nö vatotoopin, suk ataeah, o soaꞌ topnin tonuneah to vapo voh en, keꞌ nönö vakonoꞌ non. ");
INSERT INTO tpz_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","E Ieesuꞌ to ep in poan, pareꞌ vaoe en peꞌ ko soe ke poan pan, “Köövo, eöꞌ to vahik eoꞌ pa mët pën.” ");
INSERT INTO tpz_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Pareꞌ vaket en pe köövo, ka varuꞌ vakomanih e köövo to sun vötpin en. Ke köövo taneo en pa kë rakah a ëhnan e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ivëhkëk, e susun va pa iuun hinhin soneꞌ to heve en pe Ieesuꞌ, suk a ö neꞌ to vatoꞌ e köövo po Poen Apaapo. Ivëh, ke susun soe ke a ma napan pan, “Eꞌ to teꞌ non o tönim me o pöh poen kikiu, eöm se keh iu nem o teꞌ se vahik a mët peöm, a, eöm se nö maꞌ po komön o nënkikiu. Paröm nat nem nö maꞌ po Poen Apaapo.” ");
INSERT INTO tpz_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ke Ieesuꞌ piun a soe peꞌ, pareꞌ soe pan. “Eöm ro teꞌ pikpiuk! Po Poen Apaapo ne eöm kurus to nönö nem pa iuun purmakaöꞌ me ro tönkiꞌ pa vakaak raoe pa ruen. Eöm to nonok e nem pa kiu pa ö nöm to nok va nën. ");
INSERT INTO tpz_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ivëhkëk, e köövo vaꞌih, eꞌ e köövo va po vuteꞌ pe Abraham. A oraꞌ hat to vaneah voh non poan po 18 kirismas. Vahvanih köꞌ veo këh eah pa mët vaꞌih to ötöön voh non poan, eꞌ kës to hikta antoen non a vatoꞌ a teꞌ po Poen Apaapo, ha?” ");
INSERT INTO tpz_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","E Ieesuꞌ to soe va nën ka ma napan varih to vakihat me ne poë pah poet rakah ee. Ka ma meh teꞌ peo to vaeö pa ma tah vihvih neꞌ to nonok non. ");
INSERT INTO tpz_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ke Ieesuꞌ soe hahah kov en pan, “A Matop Vih pe Sosoenën nöꞌ se vamaaka rakah va in eah nih? ");
INSERT INTO tpz_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Eꞌ to teꞌ va non manih po voaꞌ naon vëh ne ea to popokaꞌ no o mastat. A pah teꞌ to kon o voaꞌ mastat, pareꞌ nep poan pa rak peꞌ. Ko naon pu vaꞌpuh en, ko növan nö maꞌ, ko nok ee pa ma heꞌ pee manih pa ma peananeah.” ");
INSERT INTO tpz_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Pareꞌ soe hahah kov en pan, “Eöꞌ se vamaaka vah va in a Matop Vih pe Sosoenën nih? ");
INSERT INTO tpz_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Eꞌ to teꞌ va e non manih po is no a köövo to ru manih pa tis praoaꞌ, pareꞌ rih, ko is hovën o praoaꞌ. Ko vasuksuk no o praoaꞌ to peah en maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","E Ieesuꞌ to nö vavah en pa ma vöön apaꞌpuh me a ma meh vöön, eꞌ to vavaasis vah non a ma napan, pareꞌ iu nö koe non manuh Jerusalëm. ");
INSERT INTO tpz_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ka pah teꞌ hi poan pan, “Sunön, e Sosoenën se pöꞌ hehe a ma pöh teꞌ, ha?” Ke Ieesuꞌ soe ke raoe pan, ");
INSERT INTO tpz_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Eöm se punöꞌ vakis rakah, köm sih ho koe po siꞌ hopaꞌ soneꞌ. Eöꞌ to soe ka neöm a ma napan peo rakah to iu ho e ne, ivëhkëk, eꞌe to hikta antoen ne a ho. ");
INSERT INTO tpz_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Amot ne tövaneah pa iuun se papanih en po hopaꞌ in a iuun, köm se nönö nem maꞌ, ko sun e nem mahën paröm tekteok o hopaꞌ ko soe vamanih pan, ‘Sunön, peret ka nös möm o hopaꞌ.’ Keꞌ se piun maꞌ a neöm, pareꞌ soe pan, ‘Eöꞌ to hikta nat noꞌ peöm, eöm taneꞌ maꞌ pa vöön poanheh?’ ");
INSERT INTO tpz_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ivëh, köm se soe ke eah pan, ‘Emöm to vavaëën me voh e nem pën, kën sun voh nom hanan pemöm parën vavaasis a no möm.’ ");
INSERT INTO tpz_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ivëhkëk, eꞌ se soe hah maꞌ pan, ‘Eöꞌ to hikta nat noꞌ peöm, eöm taneꞌ maꞌ pa vöön poanheh? Eöm ro teꞌ nonok a ma taateꞌ hat, eöm se nö ke këh a na neoꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Köm se ep e Abraham, Aësak, me Jekop, me a ma teꞌ vanënën soe kurus varih to teꞌ hop ne pa Matop Vih pe Sosoenën. Ivëhkëk, eöm se nö paröm teꞌ nem maꞌ mahën. Eöm se pah okook suntan rakah e nem, paröm vakuskus rivon nem po kamis o apuh rakah. ");
INSERT INTO tpz_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ka ma napan se taneꞌ maꞌ manuh pa ö no potan to pepeah taneꞌ no maꞌ, me manuh pa ö no potan to kukunah koe non, me manuh pasun muhin me manuh kusin a muhin. Kee se ihoꞌ ne, pare ënëën vaꞌpeh e ne manih pa Matop Vih pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","A, ka ma meh teꞌ varih to suksuk ne, eꞌe se vovoh ee. Ka ma teꞌ varih to vovoh ne kuru, eꞌe se vasuksuk rakah varuꞌ ee maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Manih po poen avoeꞌ pamëh no a ma Parësiꞌ to nö maꞌ, pare soe ke Ieesuꞌ pan, “Eën se këh a vöön vëh, parën nö pa meh vöön, a teꞌ sunön vëh e Hëërot to iu ip vamët e non pën.” ");
INSERT INTO tpz_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ke Ieesuꞌ soe ke raoe pan, “Eöm se nö, paröm soe ke a teꞌ vavakëën vëh e Hëërot pan, ‘Kuru me sinup eöꞌ se veo tavus a ma oraꞌ hat, paröꞌ vavatoꞌ a ma teꞌ to haraꞌ ne a mët. Ko vakön poen ne eöꞌ se vahik a ma kiu peöꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ivëhkëk, kuru me sinup me a teꞌ sinup oah voh, eöꞌ se nönö e noꞌ, suk ataeah, eꞌ to hikta teꞌ vih non pa ip vamët a pah teꞌ vanënën soe pa meh vöön. Ahik. Eꞌe se ip vamët varoe poë manuh Jerusalëm. ");
INSERT INTO tpz_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalëm, Jerusalëm, eöm a ma nap susunön to töstösvös nem sih a ma teꞌ vanënën soe ne Sosoenën to vanö nös manih peöm. A ma poen peo neöꞌ to iu ununun noꞌ sih a ma koaꞌ pën, vamanih pa ö ne toaꞌ sin to ununun va non sih a ma soneꞌ peꞌ manih pa paan a paknaneah. Ivëhkëk, eöm to hikta iu nem. ");
INSERT INTO tpz_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Pënton öm. E Sosoenën to këh voh en pa vöön peöm me a Iuun Hinhin Apuh peöm. Eöꞌ to soe ka neöm, eöm se hikta ep ka neöꞌ, keꞌ onöt rakah o poen nöm se soe pan, ‘Ea se kë a ëhnan a teꞌ apuh vëh to taneꞌ maꞌ manuh pe Sosoenën.’” ");
INSERT INTO tpz_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","O pöh Poen Apaapo ne Ieesuꞌ to nö pa ëën pa iuun pe susun po Parësiꞌ. Ka napan ut rakah e ne peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","A pah teꞌ supsup sionin to teꞌ vatët non manih pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ke Ieesuꞌ hi a ma teꞌ vavaasis to nat ne o Vavaasis pe Mosës, me o Parësiꞌ pan, “A taateꞌ kës pea to vaonöt e non pa ö na se vatoꞌ hah a teꞌ koman o Poen Apaapo, keꞌ ahik?” ");
INSERT INTO tpz_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ivëhkëk, a ma teꞌ vavaasis to nat ne o Vavaasis pe Mosës, me o Parësiꞌ to teꞌ vasup e ne. Ke Ieesuꞌ vaket pa teꞌ pamëh, pareꞌ vavih hah poan, ko vanö hah en peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pareꞌ soe ke raoe pan, “Ta pah teꞌ manih peöm se keh teꞌ me non a pah koaꞌ oeteꞌ, keꞌ, a purmakaöꞌ, keꞌ vuꞌ hop pa koveꞌ ruen ruruvun, ka teꞌ pamëh to hikta onöt pöꞌ non a rëh peah vëhöꞌ hah poan po Poen Apaapo, ha?” ");
INSERT INTO tpz_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ivëhkëk, ee to hikta onöt ne a piun a soe pamëh. ");
INSERT INTO tpz_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","E Ieesuꞌ to inan a napan to nö maꞌ pa ëën a taëën, ko iu ihoꞌ rakah ne pa ma ö ihoꞌ vamomoaan. Ivëh, keꞌ heꞌ a pah soe vapipinoꞌ manih pee. Eꞌ to soe pan, ");
INSERT INTO tpz_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“A pah teꞌ se keh vaoe maꞌ oah pa nö po vaënëën apuh va po vaen, eën se nat nom ihoꞌ manih pa ö ihöꞌ pa nap apaꞌpuh. A teꞌ pamëh tomeꞌ vaoe a meh teꞌ no a ëhnaneah to teꞌ oah e non pa ëhnöömah. ");
INSERT INTO tpz_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Eꞌ se keh teꞌ va non nën, a, a teꞌ vëh to vaoe a neöm pom se nö maꞌ, pareꞌ soe ka oah pan, ‘Eën se heꞌ a ö ihoꞌ vamomoaan manih pa teꞌ vëh’. Kën se pah poet rakah eom ko nö, parën ihoꞌ e nom maꞌ manuh po vasuksuk rakah. ");
INSERT INTO tpz_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ivëh, ka teꞌ se keh vaoe maꞌ oah po to vaënëën, eën se nö, parën ihoꞌ manih pa ö ihoꞌ vasuksuk, a, ka teꞌ vëh to vaoe maꞌ oah se nö maꞌ, pareꞌ soe ka oah pan, ‘Vakamöꞌ peöꞌ, eën se nö maꞌ, parën ihoꞌ pa ö ihoꞌ vamomoaan.’ Eꞌ se nok va nën, kën kon o ëhnan apuh manih pa matëëra napan kurus to ënëën vaꞌpeh me ne oah. ");
INSERT INTO tpz_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","A, a teꞌ to kë koman hah non a ëhnaneah, e Sosoenën se vöknah rakah en peꞌ. Ivëhkëk, a teꞌ to vöknah koman hah a non, e Sosoenën se kë poan.” ");
INSERT INTO tpz_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ke Ieesuꞌ soe ke a teꞌ vëh to vaoe maꞌ poan po vaënëën pan. “Eën se keh nok to vaënëën, eën se nat nom vaoe a ma vakamöꞌ pën, kea pën, pömah, me a ta vöön pën varih o momoniꞌ. Suk ataeah, ee se piun ke pën pa taëën nën to vaëën me raoe. ");
INSERT INTO tpz_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ahik, eën se keh nok to vaënëën apuh, eën se vaoe a nap arus, me a napan varih no a sioniire to hat, me o teꞌ no a ma moeere to hat, me a nap kekehoꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","A pap teꞌ poë varih to hikta onöt ne a piun hah a taëën pën. Ivëh, kën se vaoe raoe, suk ataeah, amot ne Sosoenën se piun hah a taëën pën, pa ö no a nap totoopin se sun hah taneꞌ pa mët.” ");
INSERT INTO tpz_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","A pah teꞌ va pee to pënton a soe vëh, pareꞌ soe ke Ieesuꞌ pan, “A teꞌ se keh ënëën non koman a Matop Vih pe Sosoenën, eꞌ se vaeö rakah.” ");
INSERT INTO tpz_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ke Ieesuꞌ soe ke poan pan, “A pah teꞌ to kehkeh nok non o vaënëën apuh, ivëh, keꞌ vipuh a ma napan pa nö maꞌ po vaënëën peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","O poen vaënëën to öök vatët rakah en, keꞌ vavipuh en pa teꞌ kikiu peꞌ, keꞌ nö ko vaoe maꞌ a napan varih neꞌ to vipuh moaan voh na pa nö maꞌ. Eꞌ to nö, pareꞌ soe vamanih pan, ‘Nö kurus maꞌ öm, a ma taëën to vamatop vahik en.’ ");
INSERT INTO tpz_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ivëhkëk, ee papaeh to nö, pare soe pan, eꞌe to hikta onöt ne a nö maꞌ. A pah teꞌ to soe pan, ‘Eöꞌ to voen a rak, köꞌ se nö paröꞌ ep. Eöꞌ to hikta onöt noꞌ a nö nös.’ ");
INSERT INTO tpz_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ka meh teꞌ soe maꞌ pan, ‘Eöꞌ to voen maꞌ a havun purmakaöꞌ marën a nok a kiu, ivëh, köꞌ iu nö noꞌ pa kiu me raoe. Eöꞌ to hikta onöt noꞌ a nö nös.’ ");
INSERT INTO tpz_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ka vakön teꞌ soe maꞌ pan, ‘Kuru vaꞌih eöꞌ to vaen vavoon, ivëh, köꞌ hikta onöt noꞌ a nö nös.’ ");
INSERT INTO tpz_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ka teꞌ kikiu pamëh hah en, pareꞌ soe ke susun peꞌ a ma tah poë varih. Ke tövaneah pa iuun pah heve en, pareꞌ soe ke a teꞌ kikiu peꞌ, ‘Eën se nö vëvëhöꞌ pa ma hanan apaꞌpuh, me o hanan sosoneꞌ va pa vöön vëh, parën me maꞌ a nap arus, me a napan varih no a ma moeere to hat, me o teꞌ kekehoꞌ, me ro teꞌ varih no a ma sioniire to hat, parën me ho maꞌ raoe manih pa iuun peöꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ka vasuksuk no a teꞌ kikiu pamëh to soe pan, ‘Apuh, eöꞌ to vatet rakah eoꞌ pa soe pën, ivëhkëk, a ma meh ö ihoꞌ to hikta puh avoeꞌ ne.’ ");
INSERT INTO tpz_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ka teꞌ apuh soe ke a teꞌ kikiu peꞌ pan, ‘Eën se nö pa ma hanan apaꞌpuh parën suk a sinten a oro koman a rak, parën me ho maꞌ a ma napan. Eöꞌ to iu noꞌ a iuun peöꞌ se puh rakah. ");
INSERT INTO tpz_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Eöꞌ to soe ka neöm, a ma teꞌ kurus varih moaan voh nöꞌ to vipuh raoe, eꞌe to hikta onöt rakah ne a vaëën me a neoꞌ.’” ");
INSERT INTO tpz_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","A ma nap peo rakah to nönö vah me ne e Ieesuꞌ, keꞌ tarih, pareꞌ soe ke raoe pan, ");
INSERT INTO tpz_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ta pah teꞌ se keh nö maꞌ peöꞌ, ivëhkëk, eꞌ to hikta iu oah rakah a no neoꞌ pa ö neꞌ to iu va e non e tamaneah, sinaneah, köövo peꞌ, koaꞌ peꞌ, kea peꞌ, vameneah, me o toꞌtoꞌ koman peꞌ, a teꞌ pamëh to hikta teꞌ non e vamomhë rakah peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ka teꞌ to hikta koman non a mët vaꞌpeh me a neoꞌ pa kuruse, eꞌ me to hikta onöt non a tavus e vamomhë peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","A paeh va peöm se iu eok non ta pah iuun vakin rakah, eꞌ se ihoꞌ, pareꞌ kokoman vavih këh o voen in a iuun pamëh. Eꞌ to iu nat non pa tovih moniꞌ rakah neꞌ to öt non to onöt non a vahik a iuun. ");
INSERT INTO tpz_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Eꞌ se keh hikta kokoman vavih momoaan, ko vahoꞌ vahik o simen, pareꞌ hikta onöt non a vahik a iuun. A napan kurus se ep, pare vavovoeak ee pa teꞌ pamëh. ");
INSERT INTO tpz_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Eꞌe se soe pan, ‘A teꞌ vëh to taneo a iuun vëh, ivëhkëk, eꞌ to hikta onöt non a vahik.’ ");
INSERT INTO tpz_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ka teꞌ sunön se iu vapus me non a meh teꞌ sunön, eꞌ se ihoꞌ voh, pareꞌ kokoman vavih momoaan, pan eꞌ to teꞌ me non po 10,000 teꞌ vëvënsun peꞌ, ka meh teꞌ sunön nö me maꞌ po 20,000 teꞌ vëvënsun peꞌ. Ivëh, keꞌ iu nat momoaan non, pan eꞌ to onöt e non pa vapus me a meh teꞌ sunön peꞌ. Keꞌ ahik? ");
INSERT INTO tpz_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Eꞌ se keh nat non pan, eꞌ to hikta öt onöt non a nap vapus, ee se teꞌ varo avoeꞌ e ne maꞌ, keꞌ vanö a soe pan, ee se vaato ko vahik o kokoman va pa vapus. ");
INSERT INTO tpz_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Keꞌ teꞌ va kov e non manih peöm, ta paeh peöm se keh hikta heꞌ tonun a ma tah kurus peꞌ, ko vatet a neoꞌ, eꞌ to hikta onöt non a tavus e vamomhë peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“A sö a tah a pah vih rakah, ivëhkëk, o tetehean pa sö se keh hik këh en peꞌ, ea se nok vahvanih, keꞌ tetehean hah? ");
INSERT INTO tpz_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","A sö to teꞌ va non nën to hikta onöt non a nok a tah manih peꞌ. Ea se vi rakah ee peꞌ, suk o tetehean to hik këh en peꞌ. A teꞌ to teꞌ me non a tenaneah, eꞌ se pënton.” ");
INSERT INTO tpz_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","A ma teꞌ kokon takis me a ma teꞌ nonok vahat to huk vatet ee manuh pe Ieesuꞌ pa pënton a soe peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ka ma Parësiꞌ, me o teꞌ vavaasis to nat ne o Vavaasis pe Mosës to vaato vaheheve e ne pan, “A teꞌ vaꞌih to vakamöꞌ me non a ma teꞌ nonok vahat, pareꞌ vavaëën me non raoe.” ");
INSERT INTO tpz_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ivëh, ke Ieesuꞌ heꞌ raoe a soe vapipinoꞌ vëh, ");
INSERT INTO tpz_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ta pah teꞌ topnineöm se keh teꞌ me non a 100 sipsip ka paeh se keh ro, e tövaneah pa ma sipsip se këh en pa 99 sipsip to ënëën ne, pareꞌ nö en pa vaiu a paeh sipsip vëh to ro, keꞌ onöt rakah a ö neꞌ se taum poan. ");
INSERT INTO tpz_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","O poen neꞌ to taum hah poan, eꞌ to vatok poan pa koꞌkoneah, pareꞌ vaeö rakah, pareꞌ teꞌ hah en peꞌ manuh pa ö no 99 sipsip to teꞌ vavih ne. ");
INSERT INTO tpz_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ko tavus en iuun peꞌ, pareꞌ vaoe a ma vakamöꞌ me a ta vöön peꞌ, kee tönun maꞌ, keꞌ soe ke raoe pan, ‘Eöm se vaeö me a neoꞌ. A pah sipsip peöꞌ to ro köꞌ vaiu eah, paröꞌ taum hah eoꞌ peꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Eöꞌ to soe ka neöm, “Kuru vëh manuh pa vöön va kin, ee to vaeö e ne po 99 teꞌ totoopin to hikta teꞌ me ne ta ma taateꞌ hat nee se panih suk. Ivëhkëk, ta pah teꞌ nonok vahat se keh panih a ma taateꞌ hat peꞌ, a, o vaeö apuh oah se tavus manuh pa vöön va kin.” ");
INSERT INTO tpz_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ta pah köövo se keh teꞌ me non a K10.00 ka K1.00 ro, eꞌ se vëkrea o ram, pareꞌ vavaiu koman a iuun pareꞌ epep vavih, keꞌ onöt rakah a ö neꞌ se taum hah a moniꞌ vëh to ro. ");
INSERT INTO tpz_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","O poen neꞌ to taum hah poan, eꞌ se vaoe a ma vakamöꞌ me a ta vöön peꞌ, kee tönun maꞌ, keꞌ soe ke raoe pan, ‘Eöm se vaeö me a neoꞌ. A moniꞌ peöꞌ to ro voh, ivëhkëk, eöꞌ to taum hah eoꞌ peꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Eöꞌ to soe ka neöm, kuru vëh manuh pa vöön va kin a ma ankeroꞌ pe Sosoenën to vavaeö ne sih a pah teꞌ nonok vahat to panih a ma taateꞌ hat peꞌ, ko tarih hah maꞌ pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ke Ieesuꞌ vavaato avoeꞌ e non, pareꞌ soe pan, “A pah teꞌ to teꞌ me non a poa koaꞌ oeteꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ka vapöök koaꞌ soe ke tamëëre pan, ‘Tamön, eöꞌ to koman noꞌ a ma tah kurus nën to iu ki vakëh ka no möm a poa tom kea. A papan peöꞌ sën heꞌ eöm peöꞌ kuru. Ke tamëëre ki vakëh ken pee pa ma tah kurus peꞌ manih pee pon. ");
INSERT INTO tpz_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Keꞌ hikta teꞌ varë, ke vapöök koaꞌ ununun a ma tah kurus peꞌ, pareꞌ nö en ko teꞌ e non maꞌ pa meh muhin. Eꞌ to teꞌ non pa muhin pamëh, pareꞌ pah vi vahik en pa ma moniꞌ peꞌ, pa ma taateꞌ hat vatösoe neꞌ to nonok non. ");
INSERT INTO tpz_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Eꞌ to vi vahik rakah en pa ma tah peꞌ, ko maë apuh tavus pa muhin pamëh, keꞌ hikta teꞌ rakah me non ta moniꞌ seꞌ voen ta taëën, me ta tah ohop, pareꞌ pah mamaë rakah e non. ");
INSERT INTO tpz_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ivëh, keꞌ nö pareꞌ kiu non pa pah teꞌ va pa muhin pamëh. Ka teꞌ vanö en peꞌ manuh pa matop o pus kuꞌ peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","O kuꞌ to ënëën ne sih a ma voaꞌ pin, keꞌ pah iu rakah e non pa ëën a ma kap pin ëën këh po kuꞌ. Ivëhkëk, a hikta pah teꞌ to heꞌ poan a taëën neꞌ se ëën. ");
INSERT INTO tpz_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ka varuꞌ vamanih, eꞌ to kokoman vörep en pa ö neꞌ to teꞌ vahat va non, pareꞌ soe hah kea pan, ‘A ma teꞌ kikiu pe tamön to teꞌ me ne pa ma taëën peo rakah. Ivëhkëk, eöꞌ to teꞌ noꞌ manih, paröꞌ pah mamaë rakah e noꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Eöꞌ se nö hah eöꞌ manuh pe tamön, paröꞌ soe keah pan, ‘Tamön, eöꞌ to nok a hat manih pe Sosoenën me manih pën. ");
INSERT INTO tpz_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Eöꞌ to hikta teꞌ noꞌ a teꞌ vih to onöt noꞌ a ö nën se pokaꞌ a neoꞌ e koaꞌ pën. Eën se vateꞌ va ka neoꞌ manih pa teꞌ kikiu pën.’ ");
INSERT INTO tpz_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Keꞌ sun ko nö hah en manuh pe tamaneah. Ivëhkëk, eꞌ to teꞌ varo avoeꞌ këh e non maꞌ pa vöön ke tamaneah ep in na poan. E tamaneah to pah uruan vörep en peꞌ, ko vaeö, pareꞌ vaveo ko not poan, pareꞌ umaꞌ en peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ke koaꞌ soe ke tamaneah pan, ‘Tamön, eöꞌ to nok voh a hat manih pe Sosoenën me manih pën. Eöꞌ to hikta teꞌ vih onöt noꞌ a ö nën se pokaꞌ a neoꞌ e koaꞌ pën.’ ");
INSERT INTO tpz_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ivëhkëk, e tamaneah soe ke a ma teꞌ kikiu peꞌ pan, ‘Eöm se kon maꞌ o ohop rë vih oah peöꞌ, paröm teꞌ ohoꞌ maꞌ, paröm ohop eah. Paröm vahoꞌ a pë manih pa koreneah, ko ohop eah pa suꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Paröm nö ko teꞌ maꞌ a purmakaöꞌ sekaꞌ vëh a vusvus, paröm ip vamët. Ka se ëën para vaeö rakah. ");
INSERT INTO tpz_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Suk e koaꞌ peöꞌ vëh to mët voh en, ivëhkëk, eꞌ to toꞌ hah en. Eꞌ to ro voh en, ivëhkëk, ea to taum hah ee peꞌ.’ Ivëh, kee nok ee po vaënëën. ");
INSERT INTO tpz_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ivëhkëk, e koaꞌ vamomoaan to teꞌ no maꞌ pa rak. Eꞌ to hah maꞌ, ko öök vatët maꞌ iuun, pareꞌ tënan a napan to vaeö ne po pinoꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Pareꞌ vaoe na a pah teꞌ kikiu pareꞌ hi poan, ‘Eꞌe nonok ne ataeah?’ ");
INSERT INTO tpz_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ka teꞌ kikiu soe ke poan pan, ‘E kea pën to hah en maꞌ, ke tamëneöm ip a purmakaöꞌ sekaꞌ vusvus, suk eꞌ to taum hah en pe koaꞌ to teꞌ toꞌtoꞌ e non to hikta ro voh.’ ");
INSERT INTO tpz_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ivëhkëk, e koaꞌ vamomoaan to pah heve rakah en, ko hikta iu ho non manuh iuun. Ke tamaneah tavus maꞌ, pareꞌ heꞌ poan a soe vih pa vöknah o heve peꞌ, ko keh vakis rakah en peꞌ pan, eꞌ se ho maꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ivëhkëk, e koaꞌ to piun a soe pe tamëëre pareꞌ soe pan, ‘Pa ma kirismas peo rakah nöꞌ to matop voh noꞌ a kiu pën, vamanih pa teꞌ kikiu akuk. Eöꞌ to hikta pënton varo voh a oah. Ivëhkëk, eën to hikta heꞌ voh a neöꞌ ta pah soneꞌ meemeꞌ, köꞌ se ëën vaeö me voh a ma vakamöꞌ peöꞌ, ahik rakah. ");
INSERT INTO tpz_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ivëhkëk, e siꞌ koaꞌ pën to vahik voh en maꞌ pa ma tah kurus pën manih po köövo teꞌteꞌvaasiꞌ. Pareꞌ hah maꞌ, kën uruan eah parën ip keah a purmakaöꞌ sekaꞌ vusvus rakah na to teꞌ me no.’ ");
INSERT INTO tpz_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ke tamëëre soe ke poan pan, ‘Koaꞌ peöꞌ, a ma tamoaan voh ne ea to teꞌ vaꞌpeh e no. Ka ma tah kurus peöꞌ, eꞌe a ma tah pën. ");
INSERT INTO tpz_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ivëhkëk, kuru ea se vaeö ko kokoman pea se teꞌ vavih rakah non. Suk e kea pën vaꞌih to mët voh en, ivëhkëk, kuru eꞌ to toꞌtoꞌ hah en. Eꞌ to ro voh en, ivëhkëk, kuru ea to taum hah ee peꞌ.’” ");
INSERT INTO tpz_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ke Ieesuꞌ soe ke a ma vamomhë peꞌ pan, “A pah teꞌ öt ö to teꞌ me non a teꞌ susun to vakiu ke non poan a ma kiu peꞌ. Ka ma meh teꞌ nö maꞌ manih pa teꞌ öt ö, pare soe ke poë pan, ‘A teꞌ vëh to susun non to pah vi vahok en pa ma tah pën.’ ");
INSERT INTO tpz_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ka teꞌ sunön vaoe en pa teꞌ susun, pareꞌ soe ke poan pan, ‘A soe vaꞌih nöꞌ to pënton manih pën teꞌ vah va non nih? Eën se nö, parën kiun to soe vanat in a ma tah peöꞌ to teꞌ non manih pën. Eën hikta se teꞌ hah nom a teꞌ susun peöꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ka teꞌ susun pamëh pah kokoman vörep e non pan, ‘Eöꞌ se nok vah vanih? E sunön to kehkeh veo këh e non peöꞌ pa kiu vëh a teꞌ susun. Eöꞌ to hikta eh onöt noꞌ a een o oeh, paröꞌ poet e noꞌ pa hin a meh teꞌ a taëën. ");
INSERT INTO tpz_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ivëhkëk, eöꞌ to nat eoꞌ pa tah nöꞌ se nok. Eöꞌ se nok a tah no a ma napan se haraꞌ ne pa vaꞌaus a neoꞌ, ko me a neoꞌ pa ma iuun pee pa ö no a teꞌ sunön se veo këh a neoꞌ a kiu.’ ");
INSERT INTO tpz_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ivëh, ke susun vaoe papaeh o teꞌ varih to teꞌ me ne a ma ötop manih pa teꞌ sunön, kee nö ee maꞌ manih peꞌ. A paeh teꞌ to tavus momoaan maꞌ, ke susun hi poan pan, ‘Eën teꞌ me nom a tovih ötop manih pe sunön peöꞌ?’ ");
INSERT INTO tpz_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Keꞌ soe, ‘O 100 taram oer va po voaꞌ öliv.’ Ke susun soe ke poan pan, ‘Eën se öt o pëpaꞌ vëh to vëknöm non o ötop pën, ko ihoꞌ, parën kiun o 50 taram ro.’ ");
INSERT INTO tpz_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ka meh teꞌ suk en maꞌ, ke susun hi poan pan, ‘O tovih ötop pën?’ Keꞌ soe pan ‘O 100 pëk vuit.’ Keꞌ soe ke poan pan, ‘Ëën se öt o pëpaꞌ vëh to vëknöm non o ötop pën, parën kiun o 80 pëk ro.’ ");
INSERT INTO tpz_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ke sunön vaeö me e susun hat pamëh. Suk ataeah, eꞌ to nok a taateꞌ to teꞌ va non manih pa teꞌ to teꞌ me non o kokoman va pa matop vavih hah ea. O teꞌ va po oeh vëh to natnat oah e ne pa nok a ma kiu pee, ko teꞌ oah e ne po teꞌ varih to teꞌ ne po maaka.” ");
INSERT INTO tpz_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ke Ieesuꞌ sosoe avoeꞌ ke non pa ma vamomhë peꞌ pan, “Manih pa moniꞌ, eöm se vakamöꞌ me a ma napan. Ka amot no a moniꞌ se hik en, a, e Sosoenën se me a neöm pa iuun teꞌteꞌ tamoaan. ");
INSERT INTO tpz_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ta pah teꞌ se keh matop vavih non a ma siꞌ tah sosoneꞌ, a, eꞌ se matop vavih e non pa ma tah apaꞌpuh oah. Ka teꞌ to hikta kiu vatotoopin non pa tah soneꞌ, eꞌ se hikta kiu vatotoopin pa tah apuh me. ");
INSERT INTO tpz_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Eöm se keh hikta matop vavih nem a moniꞌ vëh po oeh. E Sosoenën me se keh heꞌ a neöm a tah kokoek va pa vöön va kin, eöm hikta onöt nem a matop vavih. ");
INSERT INTO tpz_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Eöm se keh hikta matop vavih nem a tah no a meh teꞌ to heꞌ a neöm, eöm me hikta onöt nem a matop a tah ne Sosoenën to heꞌ a neöm manih po oeh, keꞌ vatoe e non manuh pa vöön va kin. ");
INSERT INTO tpz_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“A hikta pah teꞌ kikiu to onöt non a matop a kiu pa poa torara, eꞌ se hat ke non a paeh, pareꞌ iu e non pa meh. Eꞌ se pëpënton e non pa soe pa paeh, pareꞌ heꞌ tonun e non pa meh. Eöm to hikta onöt nem a tavus a teꞌ kikiu pa poa teꞌ, e Sosoenën me a moniꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","O Parësiꞌ to iu rakah ne sih a moniꞌ to pënton a soe pe Ieesuꞌ, pare pah kö ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ivëhkëk, e Ieesuꞌ to soe ke raoe pan, “Eöm to teꞌteꞌ vapoꞌkan nem, pan eöm o teꞌ totoopin to vavatet nem a taateꞌ vih pa matëëra ma napan. Ivëhkëk, e Sosoenën to nat e non po kupu peöm. A ma tah no a napan to vaꞌpuh ne po kupu pee, eꞌe a ma tah hat po epep pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","O Vavaasis pe Mosës, me o Vavaasis po Teꞌ Vanënën Soe to teꞌ onöt rakah e non po poen ne Jon Tövapupui to tavus maꞌ, pareꞌ taneo en pa vatvus a soe va pa panih. Ivëhkëk, taneo no maꞌ pe Jon ko öök no maꞌ kuru, a Soe Vih va pa Matop Vih pe Sosoenën to tavus en maꞌ pa ma vöön kurus. Ka ma nap peo söë rakah ee pa hop manih pa Matop Vih pamëh. ");
INSERT INTO tpz_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Amot no akis me o oeh se hik en. Ivëhkëk a hikta siꞌ pah ö kiun va po Vavaasis pe Mosës to se panih.” ");
INSERT INTO tpz_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","E Ieesuꞌ to soe pan, “E voe to veo e köövo peꞌ ko me a meh köövo, eꞌ to nok a taateꞌ rëhrëh. Ka voe to me a köövo vëh moaan voh ne voe peꞌ to veo poan, eꞌ me to nok en pa taateꞌ rëhrëh.” ");
INSERT INTO tpz_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Moaan voh no a pah teꞌ öt ö to teꞌ non, ka ma poen kurus neꞌ to ohop non a ma ohop vihvih vörep me o ohop ereraꞌ vih. Ka ma poen kurus neꞌ to ënëën non a ma taëën vihvih rakah. ");
INSERT INTO tpz_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ka manih po sinten hopaꞌ in a iuun peꞌ, a pah teꞌ arus rakah to koroh non, a ëhnaneah e Lasarus. A sionin e Lasarus to puh rakah non po piꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ke Lasarus koman non a ö neꞌ se kon a ma ö taëën ëën këh to vuꞌ manih paan a ö ënëën pa teꞌ öt ö pamëh, pareꞌ ëën ko mahun. O këh to nönö e ne maꞌ, pare rëmrëm ne a ma piꞌ pe Lasarus. ");
INSERT INTO tpz_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","A teꞌ arus pamëh to mët en, ko ankeroꞌ pe Sosoenën nö maꞌ, pare teꞌ poë ko vahoꞌ vaꞌpeh me poë e Abraham. Ka teꞌ öt ö mët suk en. ");
INSERT INTO tpz_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ko nö en manuh po suraꞌ ësës tamoaan, ko teꞌ rakah me non o kamis o pöh apuh rakah. Eꞌ to ta peah, pareꞌ ep na e Abraham to teꞌ varo rakah e non maꞌ, ke Lasarus teꞌ vaꞌpeh me non poan. ");
INSERT INTO tpz_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ka teꞌ öt ö tötö ke na e Abraham, pareꞌ soe pan, ‘Tamön, eën se uruan a neoꞌ, parën vanö maꞌ e Lasarus, keꞌ varu a kumis koreneah manuh pa ruen, pareꞌ vatunuꞌ voh maꞌ a meaneoꞌ. Eöꞌ to pah haraꞌ suntan rakah e noꞌ po kamis manih po suraꞌ vëh!’ ");
INSERT INTO tpz_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ivëhkëk, e Abraham to soe pan, ‘Koaꞌ peöꞌ, kuru eën se kokoman voh a pah tah, moaan voh eën to teꞌ toꞌtoꞌ nom eën to kon voh a ma tah vihvih rakah, ke Lasarus kon voh a ma tah hat. Ivëhkëk, manih pa vöön vëh o kokoman moomo neꞌ to kon, ka hik to kamis neꞌ to kon, ke eën to pah kon eom po kamis o pöh hat rakah. ");
INSERT INTO tpz_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ka meh tah ivëh, manih topniira, e Sosoenën to vateꞌ voh o pöh een. Ivëh, ko teꞌ to teꞌ ne manih, to iu pahan ne o een vëh, ko nö nös manih peöm, eꞌe to hikta onöt ne. Ko teꞌ varem to hikta onöt ne a pahan maꞌ, pare nö maꞌ manih pemöm.’ ");
INSERT INTO tpz_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ka teꞌ öt ö soe vamanih pan, ‘Ivëh, köꞌ hi nös oah Tamön, eën se vanö e Lasarus keꞌ nö manuh pa iuun pe tamön. ");
INSERT INTO tpz_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Eöꞌ to teꞌ me noꞌ a tönim kea peöꞌ, ke Lasarus se nö, ko heꞌ raoe a soe va pa panih a ma taateꞌ hat pee, tomeꞌ eꞌe nö maꞌ manih pa vöön va pa kon o kamis apuh vëh.’ ");
INSERT INTO tpz_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ivëhkëk, e Abraham to soe maꞌ pan, ‘O Vavaasis pe Mosës me ro Vavaasis po Teꞌ Vanënën Soe to teꞌ e ne, ee se tënan ee pa ma Vavaasis poë varih, pare vatet ee.’” ");
INSERT INTO tpz_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ka teꞌ öt ö soe pan, ‘Ahik, Tamön Abraham, o Vavaasis varih to hikta onöt ne, suk ee se keh tënan a teꞌ vavaasis to nat non o Vavaasis pe Mosës, ee to hikta se vaman ne. Antoen rakah non a ö no a teꞌ se sun taneꞌ hah manih pa nap mët, ko heꞌ a soe, kee panih a ma taateꞌ hat pee. ");
INSERT INTO tpz_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ivëhkëk e Abraham to soe ke poan pan, ‘Eꞌe se keh hikta tënan o Vavaasis pe Mosës, me ro Vavaasis po Teꞌ Vanënën Soe, a, ka ta pah teꞌ se keh sun taneꞌ hah maꞌ pa nap mët, eꞌe to hikta onöt ne a vaman pet poë.’” ");
INSERT INTO tpz_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","E Ieesuꞌ to soe ke a ma vamomhë peꞌ, “A ma vu taateꞌ hat se tavus maꞌ, ko miröꞌ o kokoman pa ma napan, kee kuꞌ ee pa taateꞌ hat. Ivëhkëk, varenan rakah pa teꞌ to rëh a meh teꞌ pa nok a hat. ");
INSERT INTO tpz_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Eꞌ to vih rakah non pa ö nöm se vahan a vös apuh pa koꞌkoneah ko varu eah tahiꞌ, eꞌ he meꞌ e non pa rëh ke o vaman pa siꞌ koaꞌ soneꞌ, keꞌ kuꞌ manih pa taateꞌ hat.” ");
INSERT INTO tpz_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ivëh, ke eöm se matop koman hah a nem tomeꞌ eöm rëh ta meh teꞌ pa nok a hat. E kea pën se keh nok a hat manih pën, eën se soe keah, keꞌ panih a taateꞌ hat peꞌ, kën se ihan anoe këh eah a hat peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ke kea pën se keh nok a hat manih pën pa tönim me a poa tëëm koman a pah potan, pareꞌ hah maꞌ pën, ko soe vatamak ka oah pa tönim me a poa tëëm koman a pah potan, a, eën se ihan anoe këh eah a hat peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ka ma aposol soe ke Apuh pan, “Eën se nok vaꞌpuh o vaman pemöm keꞌ apuh rakah maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ke Apuh soe ke raoe pan, “O vaman peöm se keh teꞌ va non manih po voaꞌ naon soneꞌ vëh o voaꞌ mastat, eöm se taꞌ o meoh naon apuh vëh pan, ‘Tatai ah, parën nö, ko pu hah manuh tahiꞌ.’ Eꞌ se suk en pa soe peöm.” ");
INSERT INTO tpz_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ta pah teꞌ manih peöm, se keh teꞌ me non a teꞌ kikiu to eneen non sih o oeh manuh pa rak, keꞌ to matop non o sipsip. Vasuksuk neꞌ to hah en maꞌ iuun, ke susun peꞌ soe pöꞌ ke poan pan, ‘Vëvëhöꞌ ho poꞌ maꞌ parën ihoꞌ ko ëën.’ Eꞌ hikta se taꞌ non poan pa ihoꞌ ko ëën. ");
INSERT INTO tpz_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ahik, e susun se soe ke poan pan, ‘Eën se vamatop a taëën peöꞌ, parën voh o voh, ko hak a taëën peöꞌ parën teꞌ maꞌ. Eöꞌ se ëën, paröꞌ kaak vovoh, ko vasuksuk poꞌ nën se ëën ko kaak.’ ");
INSERT INTO tpz_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ke susun se pöꞌ soe vavihvih ken pa teꞌ kikiu vëh to vatet a soe peꞌ. Eꞌ me a hik. ");
INSERT INTO tpz_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ivëh, ke eöm me, eöm se keh nok vahik kurus em pa ma tah ne Sosoenën to soe ka neöm, a, eöm se soe vamanih pan, ‘Emöm o teꞌ kikiu varoe. A ma tah nemöm to nonok nem, eꞌ a kiu akuk ko pemöm. Ivëh, kemöm hikta iu nem a soe vavihvih.’” ");
INSERT INTO tpz_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","E Ieesuꞌ to suksuk nö non a hanan vëh to nö non Jerusalëm, pareꞌ koe topnin Samëriaꞌ me Galiliꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Eꞌ to vovos nö non pa pah vöön, ka havun teꞌ to teꞌ me ne a mët töpaꞌ to nönö nö ne maꞌ, ko sun varo avoeꞌ e ne maꞌ, ");
INSERT INTO tpz_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","pare vaoe suntan rakah ee pe Ieesuꞌ pan, “Ieesuꞌ, Apuh, ururuan a möm ah.” ");
INSERT INTO tpz_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ke Ieesuꞌ ep raoe, pareꞌ soe pan, “Eöm se nö ko vataare këm manuh po teꞌ ësës heꞌ, kee ep pan eöm to voon ko vih em.” Kee nönö avoeꞌ e ne ka ma sioniire vih ee ka mët töpaꞌ hik en. ");
INSERT INTO tpz_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ka paeh va pee ep in a sionineah to vih hah, ko hah en. Pareꞌ pah kë suntan rakah en pa ëhnan e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Pareꞌ vatokon pa havin mon e Ieesuꞌ, ko soe vavihvih ke poan. A teꞌ pamëh eꞌ a to Samëriaꞌ varoe to hah maꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ke Ieesuꞌ ep in a teꞌ pamëh, pareꞌ soe pan, “Eöꞌ to koman noꞌ pan, a havun teꞌ to vih hah. A meh tönim me a tanaꞌ poꞌ harih? ");
INSERT INTO tpz_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ahik pöꞌ ta meh teꞌ to hah maꞌ pa kë a ëhnan e Sosoenën, ha? A pah teꞌ ro va pa meh muhin to tavus vavih, to hah maꞌ pa soe vavihvih me a kë a ëhnan e Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ke Ieesuꞌ soe ke poan pan, “Eën se sun parën nö, o vaman pën to vavih hah en pën.” ");
INSERT INTO tpz_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ko Parësiꞌ hi e Ieesuꞌ pan, “O poen poanheh no a Matop Vih pe Sosoenën se nö maꞌ?” Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “O poen no a Matop Vih pe Sosoenën se nö maꞌ, a napan to hikta onöt ne a ep pa matëëre. ");
INSERT INTO tpz_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Eꞌe to hikta onöt ne a soe pan, ‘Ep öm a Matop Vih ivëh, keꞌ ivöh, suk ataeah a Matop Vih pe Sosoenën nöm to teꞌ me e nem.’” ");
INSERT INTO tpz_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ke Ieesuꞌ soe ke a ma vamomhë peꞌ pan, “Amot no o poen se tavus maꞌ ko kokoman peöm se pah iu rakah e non pa ep a neoꞌ e Koaꞌ Teꞌ Pa Napan Kurus po to pöh poen ro. Ivëhkëk, eöm to hikta se ep nem. ");
INSERT INTO tpz_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","A napan se soe va ka neöm manih pan, ‘Ep öm, eꞌ to teꞌ no maꞌ manuh, me ee se soe pan, eꞌ to teꞌ non manih.’ Ivëhkëk, eöm se sun vakis ko nat nem vatet raoe. ");
INSERT INTO tpz_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Eöm to nat e nem, o poen no a vakës se vakës maꞌ, o ëman se tavus pa ma ö kurus manih pa akis. Ivëh, ko poen ne eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus se nö hah maꞌ, eöꞌ se nö va maꞌ nën, ka ma napan kurus se ep a neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ivëhkëk, eöꞌ se teꞌ o kamis o pöh apuh po vamomoaan, ka napan va kuru se heꞌ tonun a neoꞌ me o vavaasis peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","A taateꞌ nee to nok voh pa ö ne Noaꞌ to teꞌ non, eꞌ to teꞌ akuk va kov e non manih pa ö nee se nok vamanih peöꞌ e Koaꞌ Teꞌ Pa Napan Kurus. ");
INSERT INTO tpz_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Eꞌe to ënëën ko kaak ne, pare vavaen ne keꞌ antoen rakah po poen ne Noaꞌ to hop en po paröꞌ me ra kën tom sinan peꞌ. Ka unat apuh ip vamët en pa ma napan kurus. ");
INSERT INTO tpz_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Eꞌ se teꞌ va non manih po poen voh pe Löt. A napan to ënëën voh ne ko kakaak ne, ko vonvoen tah ne ko vavoen tah ne manih pa napan, pare kikiu ne a ma rak pee ko ekeok iuun ne. ");
INSERT INTO tpz_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ivëhkëk, e Löt to këh a Södom manih po poen pamëh, ka suraꞌ me o vös vëh o sölpaꞌ to taneꞌ maꞌ manuh akis vamanih pa uhön, ko ip vahik voh en pa napan. ");
INSERT INTO tpz_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Keꞌ teꞌ va kov e non manih po poen ne eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus se tavus vateeraꞌ hah va maꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Manih po poen pamëh a pah teꞌ se keh tok no maꞌ tonun iuun peꞌ, ka ma tah peꞌ pet no maꞌ koman iuun, a, eꞌ to hikta onöt non a nö pa kon a ma tah peꞌ, ko rusin këh a hat. Keꞌ teꞌ va kov e non manih pa teꞌ to teꞌ no maꞌ pa rak peꞌ, eꞌ to hikta onöt non a up hah a ma tah peꞌ manuh iuun, ko rusin këh a hat. ");
INSERT INTO tpz_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Eöm se koman nem e köövo pe Löt to vatatarih hah voh no na pa vöön Södom, ke Sosoenën ip en peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ta pah teꞌ se keh iu ötöön non o toꞌtoꞌ peꞌ, a, o toꞌtoꞌ peꞌ se ro amot en. Ivëhkëk, a teꞌ se keh koman a non neoꞌ, pareꞌ mët suk a neoꞌ, a, amot a teꞌ pamëh se kon o toꞌtoꞌ tamoaan. ");
INSERT INTO tpz_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Eöꞌ to soe ka neöm, manih pa popoen pamëh a poa teꞌ to koroh ne pa pah tevan, e Sosoenën se me a paeh këh a meh to koroh non. ");
INSERT INTO tpz_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","A poa köövo se posean ne pa rih o praoaꞌ va pa peret, e Sosoenën se me en pa paeh, ka meh neꞌ se këh en. ");
INSERT INTO tpz_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","A poa teꞌ se keh teꞌ ne pa rak, e Sosoenën se me a paeh këh a meh se teꞌ non.” ");
INSERT INTO tpz_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ko vamomhë peꞌ pënton a soe vaꞌih, pare hi poë pan, “Apuh, a tah vaꞌih se tavus rakah nih?” Ke Ieesuꞌ soe ke raoe pan, “Manih pa ö poanheh no a tah koa to pët non, manih pa ö pamëh no o növan ënëën tah koa to tötönun ne sih nën.” ");
INSERT INTO tpz_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ke Ieesuꞌ heꞌ a pah soe vapipinoꞌ manih pee, marën a vavaasis raoe pan, eꞌe se teꞌ ne pa taateꞌ hin manuh pe Sosoenën pa ma poen kurus, pare koe a karauh. ");
INSERT INTO tpz_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","E Ieesuꞌ to heꞌ a soe vapipinoꞌ va pa taateꞌ hin vamanih pan, “Manih pa pah vöön apuh a pah tökiiki vahutët to teꞌ non. Eꞌ to hikta nanaöp non sih e Sosoenën, ko hikta koman non sih o upöm teꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ka pah köövo mahu teꞌ non pa vöön apuh pamëh. Pa ma tamoaan ne köövo to nönö non sih pa teꞌ pamëh, pareꞌ sosoe ke non sih poan pan, ‘A teꞌ vëh to vakihat me a neoꞌ, eꞌ to iu miröꞌ e non peöꞌ, eën se vaꞌaus a neoꞌ manih po vahutët.’ ");
INSERT INTO tpz_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Moaan voh neꞌ to hikta iu vaꞌaus voh non e köövo, ivëhkëk, vasuksuk neꞌ to koman vamanih pan, ‘Eöꞌ to hikta naöp noꞌ e Sosoenën, paröꞌ hikta koman vörep noꞌ a ma napan. ");
INSERT INTO tpz_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ivëhkëk, e köövo mahu vëh to pah vëhvaꞌ e non peöꞌ pa nö vatëh maꞌ. Rakah ah, köꞌ vaꞌaus momoaan eoꞌ peꞌ manih po vahutët. Eꞌ tomeꞌ vatëh sionin pa nö vatëh maꞌ manih peöꞌ.’” ");
INSERT INTO tpz_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ke Ieesuꞌ soe pan, “Eöm to pënton em pa soe pa tökiiki vahutët vëh no a taateꞌ peꞌ to hikta teꞌ totoopin non. ");
INSERT INTO tpz_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Keꞌ teꞌ vah va poꞌ non nih? A ma napan ne Sosoenën to vateꞌ voh a ma teꞌ peꞌ, ee to hinhin ne sih e Sosoenën o vaꞌaus pa potan me pa popoen. E Sosoenën to hikta se vaꞌaus pöꞌ non raoe po vahutët, ha? Ivëh, keꞌ anoeh non sih pa vaꞌaus raoe. ");
INSERT INTO tpz_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Eöꞌ to soe ka neöm, e Sosoenën se vaꞌaus vëvëhöꞌ rakah en pee. Ivëhkëk, amot ne eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus se nö maꞌ manih po poen pamëh, eöꞌ se nö maꞌ pa ep pa napan varih po oeh pan, ee to vaman rakah e ne, keꞌ ahik?” ");
INSERT INTO tpz_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","E Ieesuꞌ to heꞌ me a soe vapipinoꞌ vëh manih pa napan varih to vaman hah a ne pan, eꞌe ra nap totoopin rakah, ko upöm teꞌ to paraꞌ hat. Ivëh, ne Ieesuꞌ to heꞌ suk a soe vapipinoꞌ vaꞌih. ");
INSERT INTO tpz_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Eꞌ to soe pan, “A poa teꞌ to nö pa hin koman a Iuun Hinhin Apuh! A paeh a Parësiꞌ, ka meh a teꞌ kokon takis. ");
INSERT INTO tpz_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ka Parësiꞌ pamëh sun, ka manih po kokoman peꞌ eꞌ to hinhin va non manih pan, ‘Sosoenën, eöꞌ a teꞌ vih totoopin rakah, to hikta teꞌ va noꞌ manih po upöm teꞌ, ivëh, köꞌ soe vavihvih ka nös oah. Eöꞌ a teꞌ hikta kakaveo, nonok taateꞌ hat, me mimiröꞌ vaen. Me eöꞌ hikta teꞌ va noꞌ manih pa teꞌ kokon takis vöh. ");
INSERT INTO tpz_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Manih komön a ma nënkikiu kurus eöꞌ to vapenpen noꞌ sih pa taëën po pöök poen. Ka ma tah kurus nöꞌ to vaneah noꞌ, eöꞌ to kökök noꞌ sih a paeh va pa havun tah, paröꞌ heꞌheꞌ noꞌ nös oah a paeh.’ ");
INSERT INTO tpz_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ivëhkëk, a teꞌ kokon takis to sun varo varuꞌ e non maꞌ, pareꞌ hikta iu ta peah no na manuh kin. Ahik. Eꞌ to tös a poeneah to vataare non pan, eꞌ to teꞌ non a hat neꞌ to nok voh. Pareꞌ hinhin non e Sosoenën se ururuan varenan poan ko ihan anoe këh poan a ma hat peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Eöꞌ to soe ka neöm, a teꞌ kokon takis varoe, ne Sosoenën to pokaꞌ non poan a teꞌ totoopin rakah, keꞌ hah en pa iuun peꞌ. Ivëhkëk, a meh teꞌ ahik rakah. A hat peꞌ to teꞌ avoeꞌ e non. Eöꞌ se soe ka neöm, a teꞌ to kë koman hah a non e Sosoenën se vöknah rakah en peꞌ. Ka teꞌ to vöknah koman hah a non, e Sosoenën se kë poan.” ");
INSERT INTO tpz_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ka napan meeme ee maꞌ pa ma koaꞌ sosoneꞌ manih pe Ieesuꞌ, pan e Ieesuꞌ se vaket, ko tapui raoe. Ivëhkëk, o vamomhë peꞌ to ep a tah vaꞌih, pare siröꞌ ee pa napan poë varih. ");
INSERT INTO tpz_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ivëhkëk, e Ieesuꞌ to vaoe huk en na pa ma koaꞌ manih peꞌ, pareꞌ soe pan, “Eöm se koe a amun o koaꞌ, kee nö maꞌ manih peöꞌ. Suk ataeah, a Matop Vih pe Sosoenën to teꞌ suk non o teꞌ to teꞌ va ne manih po siꞌ koaꞌ varih. ");
INSERT INTO tpz_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Eöꞌ to soe vamaman rakah ka neöm, a teꞌ to hikta kon a Matop Vih pe Sosoenën vamanih pa siꞌ koaꞌ soneꞌ, eꞌ to hikta onöt rakah non a hop.” ");
INSERT INTO tpz_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ka pah teꞌ sunön po Jiuꞌ hi e Ieesuꞌ pan, “Apuh vih, eöꞌ se nok ataeah, paröꞌ kon o toꞌtoꞌ tamoaan?” ");
INSERT INTO tpz_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ke Ieesuꞌ soe ke poan pan, “Suk ataeah, kën pokaꞌ a neoꞌ a vih? Ahikta pah teꞌ vih. E Sosoenën varoe a paeh a vih. ");
INSERT INTO tpz_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Eën to nat voh eom pa ma taateꞌ ne Sosoenën to heꞌ voh e Mosës, “Koe a nok a taateꞌ rëhrëh, koe a ip va mët a meh teꞌ, koe a kaveo, koe a piuk a meh teꞌ pën manih po vahutët, parën ta nom e tamömah pen e sinömah.” ");
INSERT INTO tpz_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ka teꞌ susun pamëh soe ke Ieesuꞌ pan, “Taneo no maꞌ po poen ne eöꞌ to teꞌ voh noꞌ a koaꞌ, ko öök non kuru, eöꞌ to vavatet voh e noꞌ pa ma taateꞌ kurus varih.” ");
INSERT INTO tpz_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ke Ieesuꞌ pënton a soe vaꞌih, pareꞌ soe ke poan pan, “Eën to kökööt avoeꞌ nom a pah tah. Eën se vavoen a ma tah pën, parën heꞌ a moniꞌ manih pa nap arus. Kën se teꞌ nom a ma tah kokoek manuh pa vöön va kin. Parën vatet poꞌ maꞌ neoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ivëhkëk, a teꞌ susun pamëh to pënton a soe vaꞌih, ko pah tamak rakah en. Suk ataeah, eꞌ a teꞌ öt ö rakah. ");
INSERT INTO tpz_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","E Ieesuꞌ to ep in poan to haraꞌ vatamak non, pareꞌ soe pan, “Eꞌ to paraꞌ hivaꞌ rakah po teꞌ öt ö pa hop manih pa Matop Vih pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Eꞌ to teꞌ tö rakah ke non pa këmol pa hop koe manih pa töhkoꞌ in a ni kunkun. Ivëhkëk, eꞌ to hivaꞌ oah rakah e non pa teꞌ öt ö to kehkeh hop non manih pa Matop Vih pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","A ma napan to pënton a tah vaꞌih, pare soe pan, “Eꞌ se keh teꞌ va non nën, keteh se poꞌ kon o toꞌtoꞌ tamoaan?” ");
INSERT INTO tpz_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ke Ieesuꞌ piun raoe, ko soe pan, “A ma tah varih no a napan to hikta onöt ne a nok, e Sosoenën to onöt e non pa nok.” ");
INSERT INTO tpz_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ke Pitaꞌ soe pan, “Ep ah! Emöm to këh voh maꞌ a ma iuun pemöm, ko vatet maꞌ oah.” ");
INSERT INTO tpz_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ke Ieesuꞌ soe ke raoe pan, “Eöꞌ to soe vaman rakah ka neöm. A ma napan kurus to koman voh ne a Matop Vih pe Sosoenën, pare këh maꞌ a ma iuun pee, köövo, me a ma koaꞌ, kea pee, taman me sinëëre. ");
INSERT INTO tpz_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","E Sosoenën se piun oah pet ke raoe a ma teꞌ tah, nee to öt ne kuru, me o poen se tavus amot maꞌ, neꞌ se heꞌ raoe o toꞌtoꞌ tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ke Ieesuꞌ me ke a havun me a poa vamomhë peꞌ, pareꞌ soe ke raoe pan, “Ea se nö manuh Jerusalëm. Ka ma soe varih no o teꞌ vanënën soe pe Sosoenën to kiun suk voh a neoꞌ e Koaꞌ Teꞌ Pa Napan Kurus se tavus vaman en. ");
INSERT INTO tpz_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ee se heꞌ a neoꞌ pa koreera napan to hikta teꞌ ne pan ee ro Jiuꞌ, ee se kö a neoꞌ, ko nok vahat a neoꞌ, me ee se teteo a neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ee se rëp a neoꞌ, pare ip vamët a neoꞌ. Ivëhkëk, o vakön poen eöꞌ se sun taneꞌ hah eoꞌ maꞌ po vapeepe.” ");
INSERT INTO tpz_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ivëhkëk, a ma vamomhë peꞌ to hikta maaka vavih ne pa pusun in a soe vakoaan, me ee to hikta maaka ne pa tah neꞌ to sosoe ke non raoe. ");
INSERT INTO tpz_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","E Ieesuꞌ to vos vatet en manuh Jerikoꞌ, ka pah teꞌ kehoꞌ to ihoꞌ non sinten hanan, pareꞌ hinhin moniꞌ non a ma napan. ");
INSERT INTO tpz_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Eꞌ to tënan a napan o pöh peo rakah to oꞌoah nö nee, pareꞌ hi a ma meh teꞌ pan, “Ee nonok ne ataeah?” ");
INSERT INTO tpz_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kee soe ke poë pan, “E Ieesuꞌ va Nasarët to nönö nö no maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","A, keꞌ pah kokoeꞌ suntan en pan, “Ieesuꞌ Koaꞌ supnaiꞌ pe Devit, ururuan a neoꞌ ah.” ");
INSERT INTO tpz_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ka napan varih po vovoh siröꞌ poë, pare soe pan, “Vatotomin ah.” Ivëhkëk, eꞌ to kokoeꞌ vakis oah en, pareꞌ soe pan, “Koaꞌ supnaiꞌ pe Devit, ururuan a neoꞌ ah.” ");
INSERT INTO tpz_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ke Ieesuꞌ nö maꞌ pareꞌ sun en ko soe ke raoe pan, “Me maꞌ öm eah manih peöꞌ.” Ka teꞌ kehoꞌ huk vatët en maꞌ, ke Ieesuꞌ hi poan pan, ");
INSERT INTO tpz_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Eën iu nom ataeah ne eöꞌ se nok manih pën?” Keꞌ piun, pareꞌ soe pan, “Apuh, eöꞌ to iu opoep hah noꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ke Ieesuꞌ soe ke poan pan, “A matömah se opoep hah en. O vaman pën to vatoꞌ hah en pën.” ");
INSERT INTO tpz_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ivëh, ka varuꞌ rakah vakomanih no a mataneah to takap hah en, keꞌ ep vavih hah en, ko vatet en pe Ieesuꞌ, kee pet nö ee. Keꞌ kë ko vavihvih rakah en pa ëhnan e Sosoenën. Ka napan ep a tah pamëh to tavus, pare pët kë ee pa ëhnan e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","E Ieesuꞌ to vos manuh Jerikoꞌ, pareꞌ iu nö oah e non. ");
INSERT INTO tpz_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ka pah teꞌ a ëhnaneah e Sakias, eꞌ a teꞌ susun pa nap kokon takis, me eꞌ a teꞌ öt ö. ");
INSERT INTO tpz_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Eꞌ to iu ep rakah non pe Ieesuꞌ eteh, ivëhkëk, a ma napan peo to teꞌ ne. E Sakias a teꞌ kökööt rakah, ivëh, keꞌ hikta onöt non a ep e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","E Sakias to vaveo vovoh, pareꞌ peah en po naon vëh o fik, eꞌ to iu ep non e Ieesuꞌ. Eꞌ to nat e non e Ieesuꞌ se suk maꞌ a hanan pamëh. ");
INSERT INTO tpz_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ke Ieesuꞌ öök maꞌ pa ö pamëh ko ta peah, pareꞌ soe ke poan pan, “Sakias, vëhöꞌ kunah maꞌ, kuru eöꞌ se teꞌ noꞌ nös pa iuun pën.” ");
INSERT INTO tpz_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ivëh, ke Sakias kunah vëhöꞌ rakah këh en maꞌ po naon, suk o kokoman peꞌ to vaeö rakah, keꞌ me en pe Ieesuꞌ manuh pa iuun peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ka ma napan kurus ep a tah vaꞌih, pare vakukunun e ne pan, “Ep öm, e Ieesuꞌ to nö en pa iuun pa teꞌ nonok hat vöh.” ");
INSERT INTO tpz_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","E Sakias pen e Ieesuꞌ to teꞌ ne koman iuun ke Sakias sun, pareꞌ soe ke Ieesuꞌ pan, “Apuh, pënton nom ah, kuru eöꞌ to iu kiiki noꞌ a ma tah peöꞌ po topnin rakah, paröꞌ heꞌ a meh papan manih pa nap arus. Köꞌ se keh piuk voh ta pah teꞌ, paröꞌ kaveo voh ta pah tah peꞌ, eöꞌ se piun hah keah a taanaꞌ tah to oah non.” ");
INSERT INTO tpz_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ke Ieesuꞌ soe ke poan pan, “Kuru ne Sosoenën to kon hah vur en pa tapaiuun varih, suk a teꞌ vëh, eꞌ me e koaꞌ supnaiꞌ pe Abraham. ");
INSERT INTO tpz_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","A soe pamëh to man rakah, suk eöꞌ e Koaꞌ Teꞌ pa Napan Kurus to nö voh maꞌ pa vaiu a napan varih to ro voh pa taateꞌ hat, paröꞌ kon hah raoe.” ");
INSERT INTO tpz_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","A napan to pënton a soe vaꞌih, ke Ieesuꞌ heꞌ raoe a soe vapipinoꞌ. Suk eꞌ to öök vatët en Jerusalëm, ka napan koman ne pan, varuꞌ vakomanih no a Matop Vih pe Sosoenën to tavus vamhën en. ");
INSERT INTO tpz_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ke Ieesuꞌ soe ke raoe pan, “A pah teꞌ sunön to iu nö non pa vöön varo, pan ee se vateꞌ poë a teꞌ sunön. Ko vasuksuk neꞌ to hah en maꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Vamomoaan in a nö pa teꞌ sunön, eꞌ to vaoe a havun teꞌ kikiu peꞌ, pareꞌ heꞌ vakëkëh raoe a ma moniꞌ to onöt non o 100 potan nee to se kiu, pareꞌ soe ke raoe pan, ‘Eöm se vakiu nem a ma moniꞌ varih, keꞌ öök po poen söꞌ hah maꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ivëhkëk, a tavöön peꞌ to pah heve rakah e ne peꞌ, ivëh, keꞌ nö en kee vanö suk ee pa ma teꞌ kee suk ee peꞌ, pare soe pan, ‘Emöm to rës rakah e nem pa teꞌ vëh se tavus a teꞌ sunön pemöm.’ ");
INSERT INTO tpz_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ivëhkëk, ee to vateꞌ ee peꞌ a teꞌ sunön pee. Po poen neꞌ to hah maꞌ, eꞌ to vaoe a ma teꞌ kikiu varih moaan voh neꞌ to heꞌ voh raoe a ma moniꞌ. Eꞌ to iu nat non pa tovih moniꞌ to oah non pa ma moniꞌ neꞌ to heꞌ pa paeh voh raoe. ");
INSERT INTO tpz_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ka teꞌ vamomoaan nö vovoh en maꞌ, pareꞌ soe pan, ‘Apuh, eöꞌ to vakiu a moniꞌ pën, paröꞌ kon oah a havun moniꞌ to oah non pa moniꞌ nën to heꞌ voh a neoꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ka teꞌ sunön soe ke poan pan, ‘Eën a teꞌ kikiu vih to nok voh a kiu vih rakah, eën to matop vavih nom a tah soneꞌ. Ivëh, köꞌ vateꞌ a oah se susun ke nom a havun vöön.’ ");
INSERT INTO tpz_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ka va pöök teꞌ kikiu nö en maꞌ, pareꞌ soe pan, ‘Apuh, eöꞌ to vakiu a moniꞌ pën, paröꞌ kon oah a tönim to oah non pa moniꞌ nën to heꞌ voh a neoꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ka teꞌ sunön soe ke poan pan, ‘Eöꞌ to vateꞌ a oah se susun ke nom a tönim vöön.’ ");
INSERT INTO tpz_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ka meh teꞌ kikiu nö en maꞌ, pareꞌ soe pan, ‘Apuh, a ma moniꞌ kurus pën ivarih nën to heꞌ voh a neoꞌ nöꞌ se heꞌ hah a oah. Eöꞌ to mon voh po ankesep, paröꞌ koaan. ");
INSERT INTO tpz_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Suk ataeah, eöꞌ to ep e noꞌ pën a teꞌ vavakiu vëhvaꞌ teꞌ, paröꞌ naöp e noꞌ pën. A ma tah no a ma meh teꞌ to vahoꞌ ne, eën to kokon nom sih, ka ma taëën pa napan eꞌ me nën to kokon nom.’ ");
INSERT INTO tpz_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ka teꞌ sunön soe ke a teꞌ kikiu pamëh pan, ‘Eën a teꞌ kikiu hat rakah, manih pa soe koman pën, eöꞌ se vateꞌ a oah po vahutët. Eën to nat e nom peöꞌ a teꞌ vavakiu vëhvaꞌ teꞌ, ka ma tah no teꞌ to vahoꞌ ne nöꞌ to kokon këh noꞌ raoe, ha? Ka ma taëën no a napan to nepnep ne eöꞌ to kokon noꞌ sih, ha? ");
INSERT INTO tpz_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Suk ataeah poꞌ, kën hikta vahoꞌ voh a moniꞌ peöꞌ manuh pa iuun vavahoꞌ moniꞌ, köꞌ se hah maꞌ, paröꞌ kon ta moniꞌ to teꞌ oah non?’ ");
INSERT INTO tpz_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ka teꞌ sunön soe ke a ma teꞌ varih to sun vatët ne pan, ‘Eöm se öt këh eah a moniꞌ, paröm heꞌ a teꞌ kikiu vëh to öt non a havun moniꞌ to oah non.’ ");
INSERT INTO tpz_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ivëhkëk, ee to hikta teꞌ vaeö ne ko soe ke poë pan, ‘Apuh, eꞌ to vih pöꞌ e non pea se heꞌ a moniꞌ pamëh manih pa teꞌ to öt e non pa havun moniꞌ to teꞌ oah non, ha?’ ");
INSERT INTO tpz_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ka teꞌ sunön piun raoe, pareꞌ soe pan, ‘A napan varih se keh kon voh a ma tah ne Sosoenën to heꞌ raoe, pare vaꞌaus ne a meh teꞌ, e Sosoenën se heꞌ vaꞌpuh oah en pee pa ma meh tah. Ivëhkëk, a teꞌ se keh koaan a tah vëh ne Sosoenën to heꞌ voh poan, e Sosoenën se öt hah këh en peꞌ pa tah pamëh. ");
INSERT INTO tpz_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","‘Ivëhkëk, a ma teꞌ varih to vakihat me a no neoꞌ, pare hikta iu ne a ö nöꞌ se teꞌ noꞌ a teꞌ sunön pee, eöm se me maꞌ raoe, paröm ip vamët manih pa mataneoꞌ.’” ");
INSERT INTO tpz_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","E Ieesuꞌ to soe vahik en pa soe vaꞌih, pareꞌ nö pet en manuh Jerusalëm. ");
INSERT INTO tpz_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Eꞌ to öök vatët en vöön Bëtfes me manuh vöön Bëtaniꞌ manih pa ö vëh nee to pokaꞌ ne sih Tope Öliv. Pareꞌ vanö vovoh en pa poa vamomhë peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","E Ieesuꞌ to soe ke raoe pan, “Eöm se nö pa vöön to teꞌ no maꞌ manuh. Eöm se vos pa vöön pamëh, paröm ep in a tönkiꞌ sekaꞌ to nohtöön non no a hikta teꞌ to tok voh manih peꞌ. Eöm se ihan eah, ko me maꞌ eah manih peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ta pah teꞌ se keh hi a neöm pan, ‘Suk ataeah, köm ihihan nem a tönkiꞌ manem?’ Eöm se soe keah pan, ‘E Topoan to teꞌ me non a kiu manih peꞌ.’” ");
INSERT INTO tpz_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","E Ieesuꞌ to vanö raoe pon, kee nö, ko taum ee pa ma tah kurus vamanih pa ö ne Ieesuꞌ to soe va i raoe. ");
INSERT INTO tpz_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ee to ihihan ne o uris to nohtöön non a tönkiꞌ sekaꞌ, ke tövaneah hi ee maꞌ pee pan, “Suk ataeah, köm ihihan nem a tönkiꞌ sekaꞌ maneom?” ");
INSERT INTO tpz_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kee soe ee pan, “E Topoan to teꞌ me non a kiu manih peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","A poa vamomhë pe Ieesuꞌ to me ee maꞌ pa tönkiꞌ sekaꞌ manih pe Ieesuꞌ, pare pan e pa tonun a tönkiꞌ pa rara, ke Ieesuꞌ peah en pa tönkiꞌ, kee nö me ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Eꞌ to tok nö non pa tönkiꞌ, ka napan panpan ee pa ma ohop rërë pee manih hanan. ");
INSERT INTO tpz_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","E Ieesuꞌ to öök vatët en maꞌ pa hanan vëh to kunah non pa Tope Öliv, ko vamomhë peo peꞌ taneo ee pa vaeö me kë e Sosoenën. Ee to koman hah a ma tah vatoksean varih nee to ep voh, pare kë rakah ee pa ëhnan e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ee to soe pan, “E Sosoenën se tapui e Sunön suk eën to nö maꞌ pa ëhnan e Sunön. Manuh pa vöön va kin to teꞌ non a taateꞌ moomo me o ëhnan apuh pe Sosoenën!” ");
INSERT INTO tpz_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ka ma pah Parësiꞌ to teꞌ vaꞌpeh me ne a napan poë varih to soe ke Ieesuꞌ pan, “Tövavaasis, eën se siröꞌ a ma vamomhë pën, kee koe a soe a ma tah poë varih.” ");
INSERT INTO tpz_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “Eöꞌ se soe ka neöm, ee se keh vatotomin, o vös se taoa ee maꞌ pa kë a ëhnaneoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ke Ieesuꞌ öök vatët en manuh Jerusalëm, pareꞌ ep in a vöön, pareꞌ ook en pa vöön Jerusalëm. ");
INSERT INTO tpz_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Eꞌ to soe vamanih pan, “Eöm se keh nat nem pa taateꞌ tö me a taateꞌ teꞌ amot po poen vëh kuru, eꞌ to parin a vih, e Sosoenën se heꞌ a neöm. Ivëhkëk, kuru a ma tah to vakoaan e non pa matëëneöm. ");
INSERT INTO tpz_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Amot o pöh poen se tavus maꞌ no a napan varih to vakihat ka no neöm se nö maꞌ, pare ununun o taioeh to sunpip a neöm pa tavus, ko vapus me a neöm. Pare pah sunpip rakah ee peöm manih pa ma ö kurus. ");
INSERT INTO tpz_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ee se pah miröꞌ rakah ee peöm, me a ma koaꞌ peöm varih to teꞌ vaꞌpeh me a no neöm. Ee se hikta koe ta pah vös peöm se teꞌ non tonun a meh vös. Ivëh, ka vöön apuh peöm Jerusalëm nee se miröꞌ vahik rakah ee peꞌ. Suk ataeah, eöm to hikta inan nem po poen ne Sosoenën to nö maꞌ pa vaꞌaus a neöm.” ");
INSERT INTO tpz_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ke Ieesuꞌ ho en pa ö vëh mahën manuh koman Iuun Hinhin Apuh, pareꞌ taneo en pa veo tavus a ma napan varih to vavoen ne a ma tah pee. ");
INSERT INTO tpz_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","E Ieesuꞌ to soe ke raoe pan, “Manih po Puk Vapenpen no a teꞌ vanënën soe e Aisaëaꞌ to kiun voh, to soe va non manih pan, ‘A iuun peöꞌ eꞌ a iuun hinhin pa napan kurus.’ Ivëhkëk, eöm to rih eah, ko nok em peꞌ, “A ö vavakoaan po teꞌ kakaveo.” ");
INSERT INTO tpz_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ka ma poen kurus rakah ne Ieesuꞌ to vavaasis non a ma napan manih koman a Iuun Hinhin Apuh. Ko teꞌ susunön ësës heꞌ, me ro teꞌ vavaasis to nat ne o Vavaasis pe Mosës, me ro teꞌ sunön va vöön, eꞌe to vavaiu vah këh ne ta hanan nee se ip vamët vah va in e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ivëhkëk, a ma napan kurus to pah iu rakah e ne pa pënton a ma soe pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","O pöh poen ne Ieesuꞌ to vavaasis non a ma napan varih to vaman ne poë, eꞌ he vatvus non a Soe Vih manih koman a Iuun Hinhin Apuh pa ö vëh mahën. Ko teꞌ susunön ësës heꞌ, me ro teꞌ vavaasis to nat ne o Vavaasis pe Mosës, me ro teꞌ susunön po Jiuꞌ nö ee maꞌ manih peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Pare soe ke Ieesuꞌ pan, “Soe ka möm ah, a tasun taeah nën to teꞌ me nom parën nonok nom a ma kiu varih? Eteh to heꞌ a oah a tasun pamëh?” ");
INSERT INTO tpz_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ke Ieesuꞌ piun a soe pee, pareꞌ soe pan, “Eöꞌ me se hi voh a neöm a siꞌ pah hi ro, soe ka neoꞌ öm, ");
INSERT INTO tpz_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","a tasun vëh pa pupui a napan ne Jon Tövapupui to heꞌ voh, taneꞌ maꞌ pe Sosoenën, keꞌ, eꞌ taneꞌ maꞌ manih pa napan ah?” ");
INSERT INTO tpz_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kee vaiihi koman e ne pan, “Ea se poꞌ soe ataeah? Ea se keh soe pan, ‘Eꞌ to taneꞌ maꞌ pe Sosoenën,’ eꞌ se soe en pan, ‘Vahvapoꞌ nih ka hikta vaman no e Jon?’ ");
INSERT INTO tpz_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ka se keh soe pan, ‘Eꞌ to taneꞌ maꞌ pa napan, a napan kurus varih se tösvös ee pea, suk ataeah, ee to vaman rakah voh ee pe Jon a teꞌ vanënën soe.” ");
INSERT INTO tpz_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ivëh, kee piun va in a soe pe Ieesuꞌ manih pan, “Emöm to hikta nat nem, a pupui vëh pe Jon taneꞌ voh maꞌ peteh?” ");
INSERT INTO tpz_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ke Ieesuꞌ soe ke raoe pan, “Eöꞌ me to hikta se vatët a noꞌ neöm a tasun nöꞌ to teꞌ me noꞌ pa nok a ma tah varih.” ");
INSERT INTO tpz_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ke Ieesuꞌ heꞌ a soe vapipinoꞌ manih pa napan, pareꞌ soe pan, “A pah teꞌ to nep a voaën manuh pa rak peꞌ. Pareꞌ heꞌ a napan varih to iu kiu moniꞌ ne, kee matop ke ne poë, eꞌ hehnö ko teꞌ varë e non maꞌ pa vöön varo. ");
INSERT INTO tpz_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ko poen no a voaꞌ to vamatop e ne pa oes, ke tövaneah pa rak vanö en maꞌ pa pah teꞌ kikiu peꞌ, keꞌ nö en manuh pa napan varih to matop ne pa rak voaën. Eꞌ to iu non a ö nee se heꞌ maꞌ poë ta ma teꞌ voaꞌ voaën va pa rak pamëh. Ivëhkëk, a ma teꞌ kikiu va pa rak to ip a teꞌ pamëh, pare vanö akuk hah ee maꞌ peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Keꞌ vanö hah en pa meh teꞌ kikiu peꞌ. Eꞌ me no a nap kiu varih pa rak to ip vapoet ee peꞌ, pare vanö akuk hah ee maꞌ peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Keꞌ vanö en pa vakön teꞌ kikiu manih pee. Ivëhkëk, ee to ip vahat poë, pare veo tavus ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ivëh, ke tövaneah pa rak soe en pan, ‘Eöꞌ se nok poꞌ ataeah? E sunaiꞌneoꞌ nöꞌ to iu oah noꞌ eah, eöꞌ se vanö eah. Eꞌe se pöꞌ tënan poë pare ta e ne peꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ivëhkëk, a napan varih to kiu ne pa rak to ep in e koaꞌ oeteꞌ peꞌ pare vasoe ee pan, ‘A teꞌ vëh eꞌ se vaneah amot a ma tah pe tamaneah. Ep öm ka ip eah, para vaneah varuꞌ e no pa rak vëh.’ ");
INSERT INTO tpz_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kee öt poë, pare vi tavus këh ee maꞌ peꞌ pa rak voaën, pare ip vamët ee peꞌ. Ke tövaneah pa rak voaën se poꞌ nok ataeah manih pa napan varih to ip e koaꞌ peꞌ? ");
INSERT INTO tpz_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","E tövaneah pa rak voaën se nö maꞌ, pareꞌ ip vamët a napan varih to matop ne pa rak, pareꞌ heꞌ a rak voaën manih po upöm teꞌ.” A napan to pënton a tah vaꞌih, pare soe pan, “E Sosoenën to hikta se vaonöt non a tah pamëh se tavus.” ");
INSERT INTO tpz_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ivëhkëk e Ieesuꞌ to kuteꞌ rakah non pee pareꞌ soe pan, “A pusun in a soe vapipinoꞌ vaꞌih to teꞌ non komön o Puk Vaëhëh, to teꞌ va non manih pan, ‘A vös vaꞌih no a nap ekeok to vi tavus in, to tavus en a vös vamomoaan vëh to toon vakis non a iuun.’ ");
INSERT INTO tpz_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","A teꞌ se keh vuꞌ po toon pamëh eꞌ se tatape rakah en, ko toon se keh vuꞌtöön ta pah teꞌ, eꞌ se kakaaroe rakah en.” ");
INSERT INTO tpz_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ko teꞌ vavaasis to nat ne o Vavaasis pe Mosës me ro teꞌ susunön ësës heꞌ to nat e ne pe Ieesuꞌ to heꞌ a soe vapipinoꞌ vëh to huh rakah e non pee. Ivëh, kee kehkeh öt e ne pe Ieesuꞌ, ivëhkëk, ee to nanaöp e ne pa napan. ");
INSERT INTO tpz_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ko teꞌ vavaasis to nat ne o vavaasis pe Mosës, me ro teꞌ susunön ësës heꞌ to ut ne e Ieesuꞌ, pare vanö maꞌ a ma meh teꞌ kee ut aven ne e Ieesuꞌ. A ma teꞌ poë varih to piuk pan ee ro teꞌ vih. Ee to kehkeh punöꞌ ne e Ieesuꞌ pa soe peꞌ, pan eꞌeꞌ se soe vapiun ta tah, kee se öt poë ko me manuh pa koreero teꞌ apaꞌpuh va pa kaman ko vateꞌ poë po vahutët. ");
INSERT INTO tpz_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Pare hi poë pan, “Apuh, emöm to nat e nem a soe me a tah nën to vavaasis nom sih to totoopin manih pa ma napan. Parën hikta nat nom pa naöp manih pa ëhnan apuh pa teꞌ, ahik, eën to vavaasis nom sih a ma napan a soe vih pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Soe ka möm ah, eꞌ vih kës e non pea pa heꞌ a takis manih pe Sisaꞌ, keꞌ a hik?” ");
INSERT INTO tpz_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ivëhkëk e Ieesuꞌ to nat vur en po vakëën nee to nok manih peꞌ, ivëh keꞌ soe ke raoe pan, ");
INSERT INTO tpz_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Vataare a neoꞌ öm ta pah moniꞌ. A ëhnan me o kahoꞌ peteh vëh to teꞌ non pa moniꞌ vëh?” Kee piun e Ieesuꞌ, pare soe pan, “Pe Sisaꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ke Ieesuꞌ soe ke raoe pan, “A tah to vaneah non pe Sisaꞌ nöm se heꞌ e Sisaꞌ. Ka tah to vaneah non pe Sosoenën nöm se heꞌ e Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ivëh, kee hikta onöt ne a öt poë manih pa matëëra napan. Ee to pah kokoman vörep e ne pa soe ne Ieesuꞌ to piun raoe, ko pah vasup rakah ee. ");
INSERT INTO tpz_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ko Sëdiusi, ee o kum teꞌ to hikta vaman ne pan a nap mët se sun taneꞌ hah ee manih po vapeepe, to nö ee maꞌ manih pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Pare hi e Ieesuꞌ pan, “Apuh, e Mosës to kiun voh ka ra a taateꞌ to soe va non manih pan, ‘Ta pah teꞌ se keh mët akuk eꞌ hikta vatvus ta pah koaꞌ manih pe köövo peꞌ, ke kea peꞌ me hah e köövo amop peꞌ, pareꞌ vatvus a koaꞌ se kon a ëhnan e kea peꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","A tönim kën tom mahin me a pöök to teꞌ voh ne. A teꞌ a vamomoaan to vaen, pareꞌ mët en a hikta koaꞌ peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ka vapöök me en pe köövo, ");
INSERT INTO tpz_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ko vasuksuk no a vakön kea pee to nok va en nën, ivëh ka tönim me ra pöök kën tom mahin vameeme petpet voh e ne pe köövo pamëh, pare mët ee a hikta koaꞌ nee to vataman. ");
INSERT INTO tpz_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Po vasuksuk ne köövo pamëh to mët pet en. ");
INSERT INTO tpz_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ko poen no a nap mët se sun hah, e köövo pamëh se teꞌ poꞌ non e köövo rakah peteh? A kën tom mahin to me voh poë vamanih pe köövo pee.” ");
INSERT INTO tpz_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “O teꞌ oeteꞌ me o köövo va kuru to vavaen e ne. ");
INSERT INTO tpz_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ivëhkëk, a napan varih ne Sosoenën to soe a ö nee to onöt e ne pa sun hah ko kon o toꞌtoꞌ va amot, o teꞌ poë varih hikta se vavaen hah ne. ");
INSERT INTO tpz_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ee to teꞌ va ne manih po ankeroꞌ pe Sosoenën, pare hikta onöt ne a mët. E Sosoenën to kuin taneꞌ hah raoe po vapeepe, ivëh, kee teꞌ e ne a ma koaꞌ pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","E Mosës me to vataare voh en pea pan a nap mët to susun hah e ne, manih po vahutët vëh neꞌ to kiun suk voh a ö no suraꞌ to ësës non o naon, pareꞌ soe pan, ‘E Sunön, eꞌ e Sosoenën pe Abraham, me eꞌ e Sosoenën pe Aësak, me eꞌ e Sosoenën pe Jekop.’ ");
INSERT INTO tpz_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ivëh, ke Sosoenën hikta teꞌ non pan, eꞌ e Sosoenën pa nap mët. Ahik. Eꞌ e Sosoenën pa nap toꞌtoꞌ. Manih peꞌ, a napan kurus to teꞌ toꞌtoꞌ ne.” ");
INSERT INTO tpz_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","E Ieesuꞌ to soe va nën, ka ma teꞌ vavaasis to nat ne o Vavaasis pe Mosës piun a soe peꞌ pan, “Apuh, a soe pën to paraꞌ vih.” ");
INSERT INTO tpz_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kee naöp e ne pa hi hah e Ieesuꞌ ta ma meh hi. ");
INSERT INTO tpz_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ivëh, ke Ieesuꞌ soe ke raoe pan, “Vahvanih kee sosoe ne pan, e Kristo e koaꞌ pe Devit? ");
INSERT INTO tpz_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ka manih po Puk Vahëh, e Devit koman to soe vavoh manih, ‘E Sosoenën to soe ke Devit pan, “E Kristo e Sunön pën.” ‘Ke Sosoenën sosoe avoeꞌ ke non pe Kristo pan, “Ihoꞌ ah manih pa papmatö peöꞌ, ");
INSERT INTO tpz_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ko teꞌ nom nën keꞌ onöt po poen nöꞌ se vahoꞌ o teꞌ varih to vakihat me a nom oah manih paan a matop pën.” ’ ");
INSERT INTO tpz_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","E Devit to popokaꞌ non sih e Ieesuꞌ Kristo e Sunön, ivëh, ke Kristo hikta teꞌ varoe non pan eꞌ e koaꞌ pe Devit. Ahik! Eꞌ to teꞌ me e non e Sunön peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","A ma napan kurus rakah varih to teꞌ ne to pënton ne a soe pe Ieesuꞌ. Keꞌ soe ke ro vamomhë peꞌ pan, ");
INSERT INTO tpz_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Eöm se matop vavih nem po teꞌ vavaasis to nat ne o Vavaasis pe Mosës. Ee to iu rakah ne o ohop rë vih ne se ohop, pare nönö vah me ne. Ee to iu rakah ne pan a napan se soe potan avih manih pee pa ma ö totoaan. Pare iu rakah ne a ihoꞌ pa ma ö ihihoꞌ po teꞌ susunön manih koman a ma iuun hinhin soneꞌ, ko iu rakah ne a ö ihihoꞌ vavoh manih po vaënëën apuh. ");
INSERT INTO tpz_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ee to vavakëën ne sih o köövo amop, pare kakaveo ne a ma moeh tah pee. Pare pikpiuk ne sih pa nok a ma hin rë. Manih po poen nee se teꞌ po vahutët, a pap napan poë varih se kon o kamis o pöh apuh oah rakah.” ");
INSERT INTO tpz_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","E Ieesuꞌ to teꞌ non koman a Iuun Hinhin Apuh ko epep vah non, pareꞌ ep in a ma teꞌ öt ö to vahoꞌ a ma heꞌ pee manih pa pokis vavahoꞌ moniꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Pareꞌ ep in e köövo amop arus to nö maꞌ, pareꞌ vahoꞌ o siꞌ pöök voaꞌ moniꞌ to matan va non manih pa poa toeaꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ke Ieesuꞌ soe pan, “Eöꞌ to soe vaman rakah ka neöm, e köövo amop vëh to heꞌ oah rakah a moniꞌ to apuh oah e non pa ma napan. ");
INSERT INTO tpz_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ka napan varih to teꞌ me ne a ma moniꞌ peo, to vahoꞌ ro a ma paeh manih pa ö vavahoꞌ moniꞌ. Ivëhkëk, e köövo vëh to kökööt rakah non pa moniꞌ, eꞌ to heꞌ vahik rakah en pa siꞌ moniꞌ neꞌ to öt non, pareꞌ hikta teꞌ hah me non ta meh moniꞌ marën a voen taëën.” ");
INSERT INTO tpz_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","A ma pah vamomhë pe Ieesuꞌ to vavasoe suk ne a Iuun Hinhin Apuh, ko soe pan, “O teꞌ to kon voh o vös ep vavih me a ma heꞌ no a napan to heꞌ manuh pe Sosoenën, pare vatëk vavih a iuun vëh.” Ke Ieesuꞌ soe ke raoe pan, ");
INSERT INTO tpz_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“A ma tah varih kuru nöm to ep nem, o poen se tavus maꞌ no a hikta pah vös to onöt non a tok pa tonun a meh. Ahik. Eꞌe se taru kunah kurus ee maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kee hi e Ieesuꞌ pan, “Apuh, o poen poanheh no a tah vëh se tavus? O vëknöm taeah se tavus momoaan maꞌ kemöm se nat nem a tah pamëh to öök vatët en maꞌ?” ");
INSERT INTO tpz_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ke Ieesuꞌ soe pan, “Eöm se matop vavih nem, o upöm teꞌ tomeꞌ piuk ka neöm. A nap peo rakah se nö maꞌ, pare popokaꞌ ne a ëhnaneoꞌ, pare soe vamanih pan, ‘Eöꞌ a teꞌ pamëh’, me ‘O poen to öök vatët en’, ivëhkëk, eöm se koe a vaman raoe. ");
INSERT INTO tpz_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ka amot nöm se pënton a soe va po vapus, o vapus o pöh apuh rakah, a, paröm nat nem töhkak. A ma tah kurus varih se tavus momoaan ee, ivëhkëk, o poen hik po oeh to hikta se tavus ohoꞌ no maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Pareꞌ soe pet ke raoe pan, “A napan va pa pah muhin se sun, pare vapus me ee pa napan va pa meh muhin. Ka matop vih pa pah teꞌ sunön se sun, pareꞌ vapus me en pa teꞌ matop vih pa meh teꞌ sunön. ");
INSERT INTO tpz_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","A rikrik se kö en pa ma meh muhin, ko maë apuh tavus en, me a ma nën mët apuh se tavus maꞌ pa ma pah muhin. Ka manih pa akis eöm se ep in a ma vëknöm apuh vaꞌnaöp me a ma moeh tah se tavus maꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ivëhkëk, a ma tah kurus poë varih se meꞌ avoeꞌ e ne pa tavus ee he öt a neöm ko pah miröꞌ rakah ee peöm. Ee se vateꞌ a neöm po vahutët koman a ma iuun hinhin soneꞌ, ko vahoꞌ a neöm pa nohnoh. Ee to iu vöknah ne a ëhnaneoꞌ, pare me a neöm pa matëëro teꞌ susunön me manuh pa matëëra ma vu susunön va pa kaman, suk eöm to vaman paröm vavatet a nem neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ka tah vaꞌih se vataare non a hanan nöm se vatvus ke raoe a Soe Vih peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ivëh, köm se nat nem karë vovoh nem ataeah nöm se piun ke raoe, ");
INSERT INTO tpz_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","eöꞌ koman se heꞌ a soe manih peöm, paröꞌ heꞌ a neöm o nat vih. Ko teꞌ varih nöm to vakihat me nem hikta antoen ne a pënton varo a soe peöm, me vöknah a soe vëh nöꞌ to heꞌ a neöm. ");
INSERT INTO tpz_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","A ma teꞌ to vatët ne peöm vamanih pe tamëneöm, me sinaneöm, teꞌ poëëneöm, me kea peöm, me ra ma vamomhë peöm, ee se heꞌ a neöm manih pa ma teꞌ varih nöm to vakihat me nem. Ee se ip vamët a ma paeh peöm. ");
INSERT INTO tpz_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Amot no a ma napan peo se heve ov e ne peöm, suk eöm to vaman, paröm vatet a nem neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ivëhkëk, ahik rakah ta paeh peöm no apeneah se ro. ");
INSERT INTO tpz_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Eöm se keh vaman vakis nem ko vatös me nem e Sosoenën, eöm se kon em po toꞌtoꞌ tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“O poen nöm to ep in a vöön Jerusalëm no a nap vëvënsun to tavi poë, eöm se nat em, o poen taseök pa vöön to öök vatët en. ");
INSERT INTO tpz_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","A napan varih to teꞌ ne manih pa muhin va Jiutiaꞌ ee se rusin manuh pa moeh totope. Ka napan varih to teꞌ ne koman vöön Jerusalëm ee se tavus këh maꞌ a vöön, ka napan varih to teꞌ tavus ne se koe a vos varuꞌ manih pa vöön pamëh. ");
INSERT INTO tpz_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","O poen pamëh ne Sosoenën se piun hah a ma hat, ivëh, ka ma soe varih to teꞌ ne po puk vapenpen se tavus vaman. ");
INSERT INTO tpz_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Varenan rakah po köövo kikiuk me o köövo to vasisiꞌ ne ro koaꞌ sosoneꞌ! Manih po poen pamëh a punis o pöh apuh rakah se tavus manih po oeh. Suk o vakmis pe Sosoenën se nö maꞌ pa ma napan va Israël. ");
INSERT INTO tpz_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","A nap peo se mët po rapis rë, ka ma meh nee se me varo pa meh muhin pa nohnoh, ko teꞌ varih to hikta teꞌ ne ro Jiuꞌ se miröꞌ a vöön, pare vaneah varuꞌ e ne pa vöön Jerusalëm, keꞌ onöt po poen vateꞌ pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","E Ieesuꞌ to soe pan, “A ma vëknöm se tavus maꞌ manih pa potan, me sivö me po vesun. Manih pa ma muhin kurus a napan se karë, pare naöp pa ö no a tahiꞌ to susupa va non. ");
INSERT INTO tpz_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","A ma napan kurus se kokoman vörep e ne pa ep a ma tah varih se tavus maꞌ. Ka ma napan se vavito matan, suk ee to ep vaꞌnaöp a ma tah varih pa akis se vuꞌvuꞌ maꞌ suk e Sosoenën se kö o kikis vöh akis. ");
INSERT INTO tpz_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","A ma tah varih se tavus, ka napan se ep a neoꞌ e Koaꞌ Teꞌ pa Napan Kurus se nö me maꞌ o kikis me o maaka apuh manih pa koman a unöh. ");
INSERT INTO tpz_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ka amot no a ma tah poë varih se taneo pa tavus. Manih po poen pamëh eöm se sun, paröm ta peah na. Suk o poen ne Sosoenën se hehe a neöm to öök vatët en maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ke Ieesuꞌ heꞌ raoe a soe vapipinoꞌ, pareꞌ soe pan, “Eöm se ep po naon vëh o fik me a ma meh naon. ");
INSERT INTO tpz_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Eöm se keh ep a ma naon to töpkaꞌ vavoon, eöm se nat em, a parëm potan to taneo en. ");
INSERT INTO tpz_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Keꞌ teꞌ akuk va kov e non manih pa ö nöm se ep a ma tah varih se tavus maꞌ, eöm se nat em a Matop Vih pe Sosoenën to öök vatët en maꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Eöꞌ to soe vaman rakah ka neöm. A ma napan va kuru to hikta se mët vahik ne, ka ma tah poë varih se tavus ee maꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","A akis me o oeh se hik ee, ivëhkëk, a soe peöꞌ to hikta se hik non, eꞌ se teꞌ tamoaan e non.” ");
INSERT INTO tpz_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ke Ieesuꞌ soe pan, “Eöm se matop vavih rakah nem, tomeꞌ eöm kakaak vah nem ko sipak, paröm kokoman vörep nem a ma tah va po sionin. A vu taateꞌ pamëh se keh vöknah a neöm, köꞌ hah vöhkak a maꞌ neöm ko öt va ka neöm manih po vasuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","O poen pamëh se tavus manih pa napan kurus rakah varih to teꞌ ne manih po oeh. ");
INSERT INTO tpz_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Eöm se teꞌ vamatop tamoaan rakah nem, paröm hinhin nem pa ma poen kurus, ke Sosoenën se heꞌ a neöm o kikis. Ivëh, köm se vaniu këh a ma tah varih to se tavus maꞌ, ivëh köm se sun pa mataneoꞌ e Koaꞌ Teꞌ pa Napan Kurus.” ");
INSERT INTO tpz_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Pa ma potan kurus ne Ieesuꞌ to vavaasis non a ma napan manih mahën koman a Iuun Hinhin Apuh. Pa vameomin matan pa ma poen kurus ne Ieesuꞌ to nönö non manuh pa Tope Öliv. ");
INSERT INTO tpz_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ka ma pöstakah kurus no a napan to nönö ne maꞌ ko tötönun ne manih mahën koman a Iuun Hinhin Apuh pa tënan o vavaasis peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","O Poen Apuh Va Pa Taëën Hikto Is vëh nee to pokaꞌ ne o Pasovaꞌ to se tavus en. ");
INSERT INTO tpz_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","O teꞌ susunön ësës heꞌ, me o teꞌ vavaasis to nat i ne o Vavaasis pe Mosës to nanaöp e ne pa napan, suk a napan to se vaꞌaus ee pe Ieesuꞌ pa ö no o teꞌ susunön se keh öt ee pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ke susun po oraꞌ hat hop en manih po kokoman pe Jiutas Iskariot. Eꞌ a teꞌ va pa vöön va Kariot, eꞌ a paeh va pa havun me a poa vamomhë pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Eꞌ to nö, pareꞌ vahutët me maꞌ o teꞌ susunön ësës heꞌ, me o teꞌ susun po teꞌ utut manih pa Iuun Hinhin Apuh. Eꞌ to vavaiu vah këh non ta hanan neꞌ se vikuh vah va in e Ieesuꞌ manih pa koreere. ");
INSERT INTO tpz_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ivëh, kee vaeö rakah ee, pare soe vaonöt pan, eꞌe se voen poë pa moniꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ke Jiutas vaonöt en pa soe pee, ivëh, keꞌ iu vah këh e non ta hanan neꞌ se vikuh vah va in e Ieesuꞌ, pareꞌ heꞌ o teꞌ susunön ësës heꞌ pa ö no a napan kurus hikta nat ne. ");
INSERT INTO tpz_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","A Taëën Apuh va pa Taëën Hikto Is va po Pasovaꞌ to tavus en. Manih po poen pamëh nee se ip a soneꞌ sipsip, pare nöh ko ëën manih po poen nee to popokaꞌ ne o Pasovaꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ivëh, ke Ieesuꞌ vanö en pe Pitaꞌ pen e Jon, pareꞌ soe ke raoe pan, “Nö öm pom paröm vamatop maꞌ a taëën pea va pa Taëën Apuh vëh o Pasovaꞌ, ka se ëën.” ");
INSERT INTO tpz_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ka poa vamomhë hi e Ieesuꞌ pan, “Eën iu nom a ö nemöm se vamatop maꞌ a taëën nih?” ");
INSERT INTO tpz_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ke Ieesuꞌ soe ke raoe pan, “Eöm se vos manuh pa vöön va Jerusalëm, ka pah teꞌ vatatan me a neöm, to teꞌteꞌ nö non a nöh ruen, eöm se vatet eah manuh pa iuun neꞌ se ho. ");
INSERT INTO tpz_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Eöm pom se soe ke tövaneah pa iuun pamëh manih pan, ‘E Apuh to ihi no maꞌ oah pan, a piprom poanheh neöꞌ se vaënëën vaꞌpeh me a ma vamomhë peöꞌ a Taëën Apuh va po Pasovaꞌ?’ ");
INSERT INTO tpz_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ka teꞌ pamëh se vataare en peöm pom pa piprom apuh vakin to teꞌ me non a pok ënëën me a ma ö ihihoꞌ to teꞌ vamatop keon e non. Köm se vamatop maꞌ a taëën pea manih pa piprom apuh pamëh.” ");
INSERT INTO tpz_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","A, kee nö ee, pare taum ee pa ma tah vamanih pa ö ne Ieesuꞌ to soe a maꞌ, ko vamatop ee pa Taëën Apuh va po Pasovaꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","A aoaꞌ to tavus en ke Ieesuꞌ ihoꞌ pa ö ënëën to ëën vaꞌpeh me a ma aposol peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Pareꞌ soe ke raoe pan, “Eöꞌ to iu ëën vaꞌpeh rakah me noꞌ neöm pa taëën vëh o Pasovaꞌ. Ka vasuksuk nöꞌ se teꞌ o kamis o pöh apuh rakah. ");
INSERT INTO tpz_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Eöꞌ to soe vaman rakah keoꞌ peöm, eöꞌ hikta se ëën hah rakah noꞌ a ö taëën vëh keꞌ onöt rakah po poen ne Sosoenën se kon hah a ma napan peꞌ manih pa Matop Vih peꞌ pa ö neꞌ se tavus a teꞌ Sunön va po oeh kurus.” ");
INSERT INTO tpz_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ke Ieesuꞌ kon a kap voaën, pareꞌ soe vavihvih ke na e Sosoenën, pareꞌ soe, “Eöm se kon a kap voaën vëh ko pët kaak vaꞌpeh. ");
INSERT INTO tpz_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Eöꞌ to soe vaman rakah keoꞌ peöm, kuru me amot nöꞌ hikta se kaak hah noꞌ o voaën keꞌ onöt rakah manih po poen no a Matop Vih pe Sosoenën se tavus maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Keꞌ kon a ö taëën, pareꞌ soe vavihvih ke na e Sosoenën, pareꞌ kök a ö taëën pamëh, ko ki vakëkëh po vamomhë peꞌ, pareꞌ soe ke rapoë pan, “Eꞌ vaꞌih a sionineoꞌ, nöꞌ to heꞌ marën a vaꞌaus a neöm. Eöm se nonok va nem manih marën a kokoman hah a neoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ee to ëën vahik ee keꞌ nok pet va en nën manih pa kap voaën neꞌ to kon, pareꞌ soe pan, “Eꞌ vaꞌih a kap voaën va po vatompoan voon va po eraꞌ koman peöꞌ nöꞌ to koꞌ marën a vaꞌaus a neöm. ");
INSERT INTO tpz_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ivëhkëk, ep öm, a teꞌ vëh se vikuh ka neoꞌ manih pa koreera nap hat, eꞌ to teꞌ vaꞌpeh me non peöꞌ manih. ");
INSERT INTO tpz_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Eöꞌ, e Koaꞌ Teꞌ Pa Napan Kurus se suk o manin pe Sosoenën pa ö nöꞌ se mët. Ivëhkëk, varenan rakah pa teꞌ vëh to vikuh ka neoꞌ manih pa koreera nap hat.” ");
INSERT INTO tpz_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","E Ieesuꞌ to soe va nën, kee vaiihi koman va i ne manih pan, “Eteh vëh se nok pa taateꞌ pamëh?” ");
INSERT INTO tpz_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ko vamomhë vaato vaheve koman hah ee, suk eteh e sunön pee. ");
INSERT INTO tpz_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ke Ieesuꞌ soe ke raoe pan, “A ma teꞌ sunön varih to hikta teꞌ ne pan ee ro Jiuꞌ to teꞌ me ne po kikis apuh marën a matop a ma napan, pare soe pan, ee to vavaꞌaus e ne pa napan poë varih. ");
INSERT INTO tpz_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ivëhkëk, eöm se koe a nok va nën, a teꞌ se susun ka non eöm, a teꞌ pamëh se tavus a teꞌ vasuksuk rakah. Ka teꞌ se susun ka no neöm eꞌ se teꞌ va non manih pa teꞌ kikiu marën a vaꞌaus a neöm. ");
INSERT INTO tpz_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Eteh e sunön? A teꞌ pöꞌ vëh to ihoꞌ non, pareꞌ ënëën non, ha, keꞌ a teꞌ vëh to hak a taëën pareꞌ teꞌ maꞌ, ah? A teꞌ vëh to ihoꞌ non eꞌ kuru eꞌ e sunön. Ivëhkëk, eöꞌ to teꞌ noꞌ topnineöm, eöꞌ to teꞌ va noꞌ manih pa teꞌ kikiu marën a vaꞌaus a neöm, ivëh, ke eöm se ep ko vatet a taateꞌ pamëh. ");
INSERT INTO tpz_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","O poen no a ma punöꞌ to tavus voh a neoꞌ, eöm to teꞌ vaꞌpeh me e nem peöꞌ, paröm hikta rusin këh a neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","E Tamön to heꞌ voh en peöꞌ pa matop vih, keꞌ teꞌ va kov e non manih peöꞌ to heꞌ a neöm a matop vih. ");
INSERT INTO tpz_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ka manih pa matop vih peöꞌ, eöm se ëën, paröm kaak em manih pa tevo, paröm ihoꞌ pa ma ö ihihoꞌ pa teꞌ sunön, ko matop nem o havun me o pöök vuteꞌ va Israël.” ");
INSERT INTO tpz_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ke Ieesuꞌ soe pan, “Saëmon, pënton no mah. E susun po oraꞌ hat to kon en pa soe vaonöt manih pe Sosoenën pa ö neꞌ se punöꞌ o vaman peöm, vamanih pa ö no a teꞌ kikiu to pitöꞌ va in a ma kuma uriꞌ këh a ma teꞌ a vihvih. ");
INSERT INTO tpz_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ivëhkëk, eöꞌ to hinhin suk a noꞌ oah e Saëmon, ko vaman pën manih peöꞌ se nat non kuꞌ vahik. Ka amot no vaman pën se teꞌ kikis hah non kën se tarih hah maꞌ manih peöꞌ, ko se vaꞌaus a ma kea pën.” ");
INSERT INTO tpz_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ke Pitaꞌ soe ke Ieesuꞌ pan, “Apuh, eöꞌ to vamatop e noꞌ pa nohnoh me mët vaꞌpeh me oah.” ");
INSERT INTO tpz_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ke Ieesuꞌ soe ke Pitaꞌ pan, “Eöꞌ to soe ka oah, nös pa popoen no e toaꞌ oeteꞌ se meꞌ avoeꞌ e non pa tö, kën kukön soe eom pan, eën to hikta nat nom peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ke Ieesuꞌ soe ke ra ma vamomhë peꞌ pan, “Moaan voh nöꞌ to vanö a neöm köm hikta teꞌ voh nös ta moniꞌ, me to kove, me ta meh poa suꞌ. Ka manih po poen pamëh eöm to kökööt pöꞌ voh nem ta pah tah, keꞌ ahik?” Kee soe pan, “Ahik!” ");
INSERT INTO tpz_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ke Ieesuꞌ kokoman non a ma tah se tavus amot manih pa ma vamomhë peꞌ, pareꞌ soe ke raoe pan, “Kuru vëh a teꞌ se keh öt non ta moniꞌ me to kove eꞌ se kon en. Ka teꞌ a hikto rapis rë, eꞌ se vavoen to ohop peꞌ ka moniꞌ neꞌ to kon eꞌ se voen to rapis rë. ");
INSERT INTO tpz_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Eꞌ to kiun non po puk pe Sosoenën pan, ‘Ee to ep vavoh e ne poë manih pa teꞌ hat.’ A ma napan se nok a ma tah hat manih peöꞌ, keꞌ vapuh en pa ö no a soe pe Sosoenën to kiun va non.” ");
INSERT INTO tpz_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kee soe pan, “Apuh, ep ah, emöm to teꞌ me nem po pöök rapis rë manih!” Ke Ieesuꞌ soe ke raoe pan, “Eꞌ to onöt en, koe a vaato suk o rapis rë.” ");
INSERT INTO tpz_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","E Ieesuꞌ to tavus këh en pa piprom vakin vëh nee to teꞌ ne manih pa vöön va Jerusalëm, pareꞌ nö en manuh Tope Öliv, vamanih pa ö neꞌ to nonok tamoaan va non. Ka ma vamomhë peꞌ nö vaꞌpeh me ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ee to öök ee pa ö pamëh ke Ieesuꞌ soe ke raoe pan, “Eöm se hinhin nem, ka punöꞌ se nat non a vöknah o vaman peöm.” ");
INSERT INTO tpz_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ke Ieesuꞌ këh huk amot en pee, pareꞌ vatokon ko taneo en pa hin vamanih pan, ");
INSERT INTO tpz_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tamön, eën se nom iu rakah nom kën kon këh a neoꞌ o kamis vëh. Ivëhkëk, Tamön eën se nat nom suk o iu peöꞌ, ahik, eën se vatet varoe o iu koman pën.” ");
INSERT INTO tpz_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ka ankeroꞌ pe Sosoenën nö maꞌ ko vasöë poan. ");
INSERT INTO tpz_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","E Ieesuꞌ to haraꞌ rakah e non pa punis ko hin vakis oah rakah en. Ko hikiꞌ tavus va en manih po eraꞌ manih pa sionineah ko totopoꞌ e non manih po oeh. ");
INSERT INTO tpz_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","E Ieesuꞌ to hin vahik en, pareꞌ nö maꞌ manih pa ma vamomhë peꞌ. Pareꞌ ep i ra raoe to koroh. O kokoman pee to punis, ivëh, nee to koroh taneꞌ ne. ");
INSERT INTO tpz_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Pareꞌ soe ke raoe pan, “Eöm koroh suk nem ataeah? Eöm se sun, paröm hinhin nem, ka punöꞌ se nat non a vöknah o vaman peöm.” ");
INSERT INTO tpz_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","E Ieesuꞌ to vavaato avoeꞌ e non, ka napan o pöh peo to nö ee maꞌ. A teꞌ vëh e Jiutas a paeh va po havun me a poa vamomhë, eꞌ to vamatan nö no maꞌ. Eꞌ to huk vatët maꞌ manih pe Ieesuꞌ, pareꞌ uumaꞌ en peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","E Ieesuꞌ to soe ke Jiutas pan, “A taateꞌ uumaꞌ to vëknöm non a vakamöꞌ vaꞌpeh me e Koaꞌ Teꞌ Pa Napan Kurus, Ivëhkëk, eën to uumaꞌ a neoꞌ pa heꞌ a neoꞌ pa koreero teꞌ to vakihat me a ne neoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ko vamomhë varih to sun vatët ne pe Ieesuꞌ ep in a tah to kehkeh tavus non, pare soe pan, “Apuh, eën iu nom a ö möm se ip raoe po rapis rë ha?” ");
INSERT INTO tpz_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ka paeh moes kurus en pa pap tenan matö pa teꞌ kikiu pa Teꞌ Susun po Teꞌ Ësës Heꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ivëhkëk, e Ieesuꞌ to ep in a tah vaꞌih, pareꞌ soe pan, “Antoen en.” Ke Ieesuꞌ vaket pa tenaneah keꞌ vih hah en. ");
INSERT INTO tpz_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ke Ieesuꞌ soe ke ro teꞌ susunön ësës heꞌ, me ro teꞌ susun po teꞌ utut manih pa Iuun Hinhin Apuh, me ro teꞌ susunön po Jiuꞌ varih to nö maꞌ pa öt poë. Eꞌ to soe ke raoe pan, “Eöm nö maꞌ pa öt a neoꞌ, ko teꞌ em maꞌ pa ma rapis rërë, me a ma tanaon ke pan, eöm to nö maꞌ pa öt a teꞌ kakaveo, toh? ");
INSERT INTO tpz_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","A ma poen kurus nöꞌ to teꞌ me voh e noꞌ peöm manih pa Iuun Hinhin Apuh. Ivëhkëk, eöm to hikta vahoꞌ a korem manih peöꞌ. Ivëhkëk, o poen vëh eꞌ o poen peöm. Kuru o kikis va pa popoen to onoah en.” ");
INSERT INTO tpz_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ka napan öt ee pe Ieesuꞌ, pare me ee peꞌ manuh pa iuun pa Teꞌ Susun po Teꞌ Ësës Heꞌ. E Pitaꞌ to suksuk amot nö e non maꞌ pa napan to meeme nö ne e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","A suraꞌ nee to vaës havin a iuun ko maꞌkis ne, ke Pitaꞌ to ihoꞌ vaꞌpeh me non raoe. ");
INSERT INTO tpz_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","A pah köövo kikiu to ep in e Pitaꞌ to maꞌkis non, pareꞌ soe pan, “A teꞌ me vëh to teꞌ vaꞌpeh me voh no maꞌ e Ieesuꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ivëhkëk, e Pitaꞌ to vonih pareꞌ soe pan, “Köövo, eöꞌ to hikta nat noꞌ pa teꞌ vëh.” ");
INSERT INTO tpz_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","A siꞌ ö to oah en ka meh teꞌ ep in e Pitaꞌ pareꞌ soe pan, “Eën me a meh teꞌ va po vakum peꞌ.” Ivëhkëk, e Pitaꞌ to vonih rakah en pareꞌ soe pan “Voe, eöꞌ ahik!” ");
INSERT INTO tpz_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","A siꞌ ö keꞌ pah aoaꞌ en, ka meh teꞌ soe pan, “Pöh man rakah, a teꞌ vëh to teꞌ vaꞌpeh me voh non poan, suk eꞌ a teꞌ va Galiliꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ivëhkëk, e Pitaꞌ to vonih vakis pareꞌ soe pan, “Pöh man rakah, eöꞌ to hikta nat noꞌ pa tah nöm to sosoe nem.” Varuꞌ vakomanih e toaꞌ oeteꞌ to tö en. ");
INSERT INTO tpz_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ke Apuh tarih, pareꞌ kuteꞌ na e Pitaꞌ, keꞌ koman hah a soe ne Apuh to soe vu ke maꞌ poan pan, “Manih po poen vëh e toaꞌ se meꞌ e non pa tö, kën kukön soe eom pan, eöꞌ to hikta nat noꞌ peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ke Pitaꞌ puh rakah en po tamak, pareꞌ tavus, ko pah ook suntan rakah en. ");
INSERT INTO tpz_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ka nap utut varih to öt e Ieesuꞌ, pare vavovoeak poë ko töstös ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ee to kupkup a mataneah po rara, pare hi poë pan, “Pokaꞌ oon voh ah, eteh to tös a oah?” ");
INSERT INTO tpz_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Pare pah soe ee pa ma soe hat to vöknah e ne peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pa pöstakah rakah no a ma Kum Teꞌ Susunön po Jiuꞌ to vakum ee. Ee o teꞌ varih, o teꞌ susunön ësës heꞌ, me o teꞌ vavaasis to nat ne o Vavaasis pe Mosës, me a ma meh teꞌ susunön po Jiuꞌ to vatötönun, pare me e Ieesuꞌ manuh po vakum pee. ");
INSERT INTO tpz_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kee hi poë pan, “Soe ka möm ah, eën kuru e Kristo, oh?” Ke Ieesuꞌ soe ke raoe pan, “Eöꞌ se keh soe ka neöm, eöm hikta se vaman nem neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Köꞌ se keh hi a neöm ta hi, eöm hikta onöt nem a piun a hi peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ivëhkëk, kuru me amot eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus se ihoꞌ noꞌ pa papmatö pe Sosoenën A Kikis Vi.” ");
INSERT INTO tpz_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ivëh keꞌe kurus, hi poë pan, “Eën e Koaꞌ pe Sosoenën, ha?” Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “Eöm to soe koman em. Eöꞌ kuru, ivëh.” ");
INSERT INTO tpz_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kee soe ee pan, “Ea to hikta iu pënton no ta ma meh soe to taneꞌ po upöm teꞌ pa vateen eah pa hat. Eꞌ a ma soe koman peꞌ ivarih na to pënton moaan voh ee to antoen e ne pa vateen eah pa hat.” ");
INSERT INTO tpz_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ko Kum Teꞌ Susunön po Jiuꞌ poë varih to me ee pe Ieesuꞌ manuh pe Ponsius Paëlat. ");
INSERT INTO tpz_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pare taneo ee pa vateꞌ e Ieesuꞌ po vahutët. Ee to soe pan, “Emöm to taum a teꞌ vëh to me vapiun a napan pemöm. Me eꞌ to soepip a möm pa heꞌ a takis moniꞌ manih pe Sisaꞌ, pareꞌ sosoe non sih pan, eꞌeꞌ e Mesaëaꞌ se tavus en, eꞌ a teꞌ Sunön. ");
INSERT INTO tpz_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ke Paëlat hi e Ieesuꞌ pan, “Eën e sunön po Jiuꞌ, ha?” Ke Ieesuꞌ piun a soe pe Paëlat, pareꞌ soe pan, “Eën koman to soe va nën.” ");
INSERT INTO tpz_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ke Paëlat soe ke ro teꞌ susunön ësës heꞌ, me a napan pan, “Eöꞌ to hikta taum ta pah hat manih pa teꞌ vëh.” ");
INSERT INTO tpz_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ivëhkëk, ee to soe vakis ee maꞌ pan, “Eꞌ to heꞌheꞌ soe non pa vaheve a napan varih pa muhin va Jiutiaꞌ, pan ee se pënton varo a kaman va Room. Eꞌ to taneo voh maꞌ pa muhin va Galiliꞌ ko öök maꞌ manih. Eꞌ to kunkuin o kokoman pa ma napan po vavaasis peꞌ, kee heve ko pënton varo a kaman.” ");
INSERT INTO tpz_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","E Paëlat to pënton a tah vaꞌih, pareꞌ hi raoe pan, “A teꞌ vaꞌih eꞌ a teꞌ va Galiliꞌ, ha?” ");
INSERT INTO tpz_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","A napan to soe pan, e Ieesuꞌ a teꞌ va Galiliꞌ, pa ö oeh ne Hëërot to matop non. Ivëh, ke Paëlat vanö en pe Ieesuꞌ manuh pe Hëërot, suk e Hëërot me to teꞌ non manih Jerusalëm. ");
INSERT INTO tpz_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","E Hëërot to ep in e Ieesuꞌ ko pah vaeö rakah en. Suk eꞌ to pënton voh non sih a ma soe va peꞌ manih po upöm teꞌ. Ivëh, keꞌ iu ep voh non e Ieesuꞌ se nok ta pah tah vatoksean keꞌ ep pa mataneah. ");
INSERT INTO tpz_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ivëh, ke Hëërot hi en pe Ieesuꞌ pa ma hi peo, ivëhkëk, eꞌeꞌ to hikta piun ta pah hi pe Hëërot. ");
INSERT INTO tpz_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ko teꞌ susunön ësës heꞌ, me ro teꞌ vavaasis to nat ne o Vavaasis pe Mosës to huk vatët ee maꞌ, pare vateꞌ vakis ee pe Ieesuꞌ po vahutët. ");
INSERT INTO tpz_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","E Hëërot me a ma nap vëvënsun peꞌ to pah kö ee pe Ieesuꞌ, pare soe vavahat ee peꞌ. Ko kon o ohop o pöh vih, pare ohop e Ieesuꞌ ko vanö hah ee peꞌ manuh pe Paëlat. ");
INSERT INTO tpz_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Moaan voh e Hëërot pen e Paëlat to vakihat ne, ivëhkëk, po poen pamëh ee pon to tavus ee a poa vakamöꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ke Paëlat vaoe o teꞌ susunön ësës heꞌ, me ra nap susunön, me a ma napan, kee vatönun maꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Keꞌ soe ke raoe pan, “Eöm to me maꞌ a teꞌ vëh manih peöꞌ, paröm soe ka neoꞌ pan, eꞌ to vapiun a taateꞌ pa napan. Köꞌ ihi noꞌ eah a ma soe poë varih pa matëëneöm. Eöꞌ to hikta taum ta pah hat manih pa teꞌ vëh pa ma tah varih nöm to vateꞌ suk eah po vahutët. ");
INSERT INTO tpz_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","E Hëërot me to hikta taum ta pah hat manih peꞌ, ivëh, neꞌ to vahah taneꞌ maꞌ poan manih pea. A teꞌ vaꞌih to hikta nok ta pah hat neꞌ se mët suk. ");
INSERT INTO tpz_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ivëh köꞌ se rëp eah, paröꞌ vahah eoꞌ peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Manih koman a ma kirismas kurus po Pasovaꞌ a taateꞌ to soe non pan, e Paëlat se vatvus hah a pah teꞌ këh a nohnoh keꞌ hah manuh pa napan. ");
INSERT INTO tpz_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ivëh ka napan kurus rakah pët taoa, pare soe maꞌ pan, “Ip vamët a teꞌ manem, ko vahah maꞌ e Barabas manih pemöm.” ");
INSERT INTO tpz_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","E Barabas to taneo voh o vapus me a kaman manih Jerusalëm, pareꞌ ip vamët voh a teꞌ. Ivëh, kee vanö poë pa nohnoh. ");
INSERT INTO tpz_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","E Paëlat to iu vahah vavih e non pe Ieesuꞌ, ivëh, keꞌ hi a napan. ");
INSERT INTO tpz_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ivëhkëk, a napan to pët taoa pare soe maꞌ pan, “Ni öm eah pa kuruse! Ni öm eah pa kuruse!” ");
INSERT INTO tpz_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ke Paëlat vakön hi en pee pan, “Suk ataeah, a hat taeah neꞌ to nok?” Eöꞌ to hikta taum ta pah hat manih peꞌ to onöt non a ö na se ip vamët suk eah. Ivëh, köꞌ se rëp eah, paröꞌ vahah nös eah.” ");
INSERT INTO tpz_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ivëhkëk, ee to taoa suntan rakah ee pan, e Paëlat se ni e Ieesuꞌ pa kuruse. A soe kikis pee to vöknah en po kokoman pe Paëlat. ");
INSERT INTO tpz_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ivëh, ke Paëlat vatet en pa soe pa napan, pa ni e Ieesuꞌ pa kuruse. ");
INSERT INTO tpz_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","E Paëlat to vahah en pe Barabas a teꞌ to nö voh pa nohnoh, suk eꞌ a teꞌ ipip teꞌ, me eꞌ to taneo voh o vapus. E Paëlat to vatet en po iu pa napan, ivëh, keꞌ varakah ke na e Ieesuꞌ manuh pa koreera nap vëvënsun peꞌ pan, ee se ip vamët poë. ");
INSERT INTO tpz_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ka nap vëvënsun meeme nö ne e Ieesuꞌ ko ep in e Saëmon a teꞌ va Saëriniꞌ to vovos nö non Jerusalëm, to taneꞌ maꞌ muhin. Ka nap vëvënsun taꞌ vakis e Saëmon pan, eꞌ se vatok a kuruse pe Ieesuꞌ ko suksuk nö me non poan. ");
INSERT INTO tpz_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ka napan me ro köövo o pöh peo to vavatet nö ne e Ieesuꞌ pa ö vöh nee se ni poë. Ee to tamak ko okook ne poë. ");
INSERT INTO tpz_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ivëhkëk, e Ieesuꞌ to nat e non pan a vöön va Jerusalëm se hat amot en. Ivëh, keꞌ tarih hah maꞌ, ko soe ke raoe pan, “Eöm o köövo va Jerusalëm, eöm se nat nem okook varoe a nem neoꞌ, eꞌ to vih non peöm se ook hah ëm me a ma koaꞌ peöm. ");
INSERT INTO tpz_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Suk, amot o poen se tavus maꞌ no a napan se soe pan, ‘O köövo vavavihi me o köövo varih to hikta vasisiꞌ ne o koaꞌ, eꞌe se vaeö rakah, suk ee ro hikto koaꞌ!’ ");
INSERT INTO tpz_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Manih po poen pamëh, ‘Nee se soe ke ra ma tope apapuh, “Eöm se tatahoe töön maꞌ möm”, me a ma tope sosoneꞌ, “Eöm se kopös a möm!” Kemöm mët vëhöꞌ këh a ma punis varih.’ ");
INSERT INTO tpz_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kuru nee to nok ee pa taateꞌ vëh manih po naon to teꞌ non o hunun, ivëh, kee se nok poꞌ ataeah manih po naon to rak en?” ");
INSERT INTO tpz_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","A nap vëvënsun to me ee maꞌ pa poa teꞌ hëkhëk to ip vaꞌpeh me e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ee to tavus ee pa tope nee to popokaꞌ ne a ö to matan va non manih po Kahoꞌ In A Teꞌ Mët, pare ni ee pe Ieesuꞌ nën. Pare ni pet me ee pa poa teꞌ kakaveo pa ö pamëh. A paeh pa papmatö, ka meh pa papkiruk pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ke Ieesuꞌ soe pan, “Tamön, ihan anoe a ma hat pee, suk ee to hikta nat ne pataeah nee to nonok ne.” Ka nap vëvënsun vi a saatuꞌ to ko ut ne peteh ivëh, se kon a ma papaeh va pa ma ohop pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ka ma nap vavaaköm me o teꞌ susunön to sun ne, pare ut ne ko vavövöneꞌ ne e Ieesuꞌ pan, “Eꞌ to vaꞌaus voh a ma upöm teꞌ, eꞌ se keh teꞌ man e non pan, eꞌ e Kristo, a Teꞌ ne Sosoenën to vateꞌ maꞌ, a, eꞌ se vaꞌaus hah ea ko kunah këh maꞌ a kuruse.” ");
INSERT INTO tpz_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","A nap vëvënsun me to vavövöneꞌ e ne pe Ieesuꞌ pa ö nee to nö vatët manih peꞌ, pare heꞌ poë o voaën voen vöknah. ");
INSERT INTO tpz_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Pare soe vamanih pan, “Eën se keh teꞌ vamaman e nom pan, eën e sunön po Jiuꞌ, a, eën se vaꞌaus hah eo.” ");
INSERT INTO tpz_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","O kiun to teꞌ no maꞌ pasun a kuruse to soe va non manih pan, “IVAꞌIH A TEꞌ SUNÖN PO JIUꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","A paeh va pa poa teꞌ kakaveo poë varih to vavövöneꞌ me ne pe Ieesuꞌ, pareꞌ soe pan, “Eën kov e Kristo, a teꞌ ne Sosoenën to vateꞌ maꞌ, ha? Havoh kën vaꞌaus hah eo, me emöm.” ");
INSERT INTO tpz_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ivëhkëk, a meh peꞌ to pënton a soe vaꞌih, pareꞌ siröꞌ poan ko soe pan, “Teꞌ o kamis pën vamanih pa ö ne Ieesuꞌ to teꞌ va in o kamis. Eën hikta naöp nom e Sosoenën, ha? ");
INSERT INTO tpz_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Eꞌ to teꞌ vih e non pa ö nee se ip vamët a ra poꞌ, suk a ma taateꞌ hat pea. Ivëhkëk, a teꞌ vaꞌih to hikta nok voh ta pah hat.” ");
INSERT INTO tpz_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ka teꞌ pamëh soe ke Ieesuꞌ pan, “Ieesuꞌ, koman a no maꞌ neoꞌ ah, pa ö sën tavus e Sunön pa Matop Vih va pa Vöön va Kin!” ");
INSERT INTO tpz_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ke Ieesuꞌ soe ke poan pan, “Eöꞌ to soe vaman rakah ka oah, kuru eën se teꞌ vaꞌpeh me e nom peöꞌ manuh pa Vöön va Kin.” ");
INSERT INTO tpz_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Pa topnin potan, pa 12 kirök no a popoen to kopös avoes en pa muhin, pareꞌ nö ko hik pa 3 kirök pa matanpoen Ko rara apuh vëh to han non manih pa Iuun Hinhin Apuh tasi topnin en pa poa tan. ");
INSERT INTO tpz_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ke Ieesuꞌ pa tötö suntan en ko soe pan, “Tamön, eöꞌ to vahoꞌ nös o toꞌtoꞌ peöꞌ manem pa koreomah.” Eꞌ to soe vahik va ko nën, ko mët en. ");
INSERT INTO tpz_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","E susun pa nap vëvënsun to ep in a tah vaꞌih, pareꞌ kë rakah en pa ëhnan e Sosoenën ko soe pan, “Pöh man rakah, a pop pa teꞌ vëh to paraꞌ totoopin.” ");
INSERT INTO tpz_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ka nap vavaaköm ep in a ma tah varih to tanok manih pe Ieesuꞌ, ko tamak suntan rakah pare vos ee vöön. ");
INSERT INTO tpz_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ka ma vakamöꞌ me a ma köövo varih to vatet taneꞌ voh maꞌ e Ieesuꞌ manuh Galiliꞌ to sun varo e ne maꞌ, pare ep e ne na pa ma tah to tanok manih pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","E Jeosëp a teꞌ va Arimatiaꞌ no a pop peꞌ to vih. Eꞌ voh a meh teꞌ to teꞌ hop non po Kum Teꞌ Susunön po Jiuꞌ. Eꞌ to hikta vapöh kokoman me voh non o upöm, pan ee se ip e Ieesuꞌ, pareꞌ anoeh voh non a Matop Vih pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","E Jeosëp to nö manuh pe Paëlat ko hin poan pan eꞌ se herep a sionin e Ieesuꞌ këh a kuruse. Keꞌ vaonöt ken peꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ivëh, keꞌ herep en pa sionin e Ieesuꞌ ko pöm vavih en pa sionineah po rara kakaare, pareꞌ teꞌ en manuh pa top vös nee to hikta vahoꞌ moaan voh ta meh teꞌ pa top vös pamëh. ");
INSERT INTO tpz_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","O poen pamëh eꞌ o Vatönim, eꞌ o Poen Vamatop in o Poen Apaapo to taneo en. ");
INSERT INTO tpz_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ko köövo varih to vatet taneꞌ voh maꞌ e Ieesuꞌ manuh Galiliꞌ, to pët nö me ee pe Jeosëp manuh pa top vös ko ep e ne pa ö neꞌ to vahoꞌ e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ee to ep vahik ee, pa ö neꞌ to vahoꞌ a sionin e Ieesuꞌ, ko vos hah ee vöön, pare vamatop ee pa ma tah avoavuh vih marën a uh a sionin e Ieesuꞌ. Ee to vanot ne po Poen Apaapo vamanih pa ö no Vavaasis pe Mosës to soe va non. ");
INSERT INTO tpz_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ka manih po poen vamomoaan in o nënkikiu, pa pöstakah rakah no köövo to nö po vapeepe to teꞌ non pa top vös. Ee to teꞌ nö ne a ma vanom ovoavuh vih varih nee to vamatop voh. ");
INSERT INTO tpz_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pare taum ee pa vös nee to vahuk këh ee po hopaꞌ in o vapeepe. ");
INSERT INTO tpz_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pare ho ee, ivëhkëk, ee to hikta ep in a sionin e Sunön Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ee to sun ko kokoman vörep e ne pa tah pamëh, to nun rakah ee, pare ep in a poa teꞌ to sun vatët ne, a ma ohop pee pon to kötköt rakah e ne maꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","A kën köövo to naöp vörep ko ves e ne po oeh. Ivëhkëk, a poa teꞌ poë varih to soe ke raoe pan, “Suk ataeah, köm vavaiu vah e nem pa teꞌ to teꞌ toꞌtoꞌ e non manih pa ö teꞌteꞌ pa nap mët? ");
INSERT INTO tpz_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Eꞌ to hikta teꞌ non manih, eꞌ to sun hah en. Eöm se koman hah na a soe vaꞌih neꞌ to heꞌ voh a neöm pa ö neꞌ to teꞌ voh non maꞌ Galiliꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Eꞌ to soe voh ka neöm pan, ‘Ee se heꞌ e Koaꞌ Teꞌ Pa Napan Kurus manih pa koreera nap hat kee ni poë pa kuruse, ko vakön poen neꞌ se toꞌ ko sun hah en.’” ");
INSERT INTO tpz_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ko köövo nat hah poꞌ ee pa soe vëh ne Ieesuꞌ to soe voh ke raoe. ");
INSERT INTO tpz_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","10","A ma köövo poë varih to hah taneꞌ maꞌ po vapeepe, ivarih, e Mariaꞌ va Makdalaꞌ, ke Joanan, ke Mariaꞌ sinan e Jëmis. A ma meh köövo to teꞌ vaꞌpeh me voh ne raoe to vahutët ke ra havun me a paeh me a ma meh aposol a ma tah kurus varih to tanok. ");
INSERT INTO tpz_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ivëhkëk, o aposol pe Ieesuꞌ to koman ne pan, o köövo to vavaakö e ne, ivëh, kee hikta vaman ne a soe pee. ");
INSERT INTO tpz_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ivëhkëk, e Pitaꞌ to vavaveo rakah en manuh po vapeepe, pareꞌ kop ko ves hop na ko ep in a ma rara varoe to pet ne. E Pitaꞌ to hah en iuun, ko pah kokoman vörep e non pa tah vëh to tanok. ");
INSERT INTO tpz_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ka manih po poen avoeꞌ pamëh a poa teꞌ va pee to nönö ne pa siꞌ vöön nee to pokaꞌ ne Ëmeus. A hanan pamëh to taneꞌ non Jerusalëm, ko vos non Ëmeus to varo va non manih pa havun me a paeh kiromitaꞌ. ");
INSERT INTO tpz_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ee pon to nönö nö ne, pare vavahutët suk nö ne a ma tah kurus varih to tanok. ");
INSERT INTO tpz_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ee pon to vaiihi nö ne, ke Ieesuꞌ nö maꞌ, ko nönö nö me e non pee pon. ");
INSERT INTO tpz_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ee to nönö nö e ne, ivëhkëk, ee to hikta nat ne eꞌ eteh, suk e Sosoenën to vapopoen e non pa matëëre, kee hikta inan ne poë. ");
INSERT INTO tpz_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ke Ieesuꞌ hi raoe pon, “Eöm vavahutët nö nem ataeah no man?” Eꞌ to soe vamanih kee sun ee, no kokoman pee to punis, kee ep vatamak e ne. ");
INSERT INTO tpz_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","A paeh va pee pon a ëhnaneah e Kliopas to piun a soe peꞌ, ko hi poan pan, “Eën varoe rakah kuru a pah teꞌ va Jerusalëm to hikta nat nom pa ma tah varih to tavus pa ma poen varih to oah, ha?” ");
INSERT INTO tpz_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","E Kliopas to soe va nën ke Ieesuꞌ hi raoe pan, “A ma taneah poë varih?” Kee to piun poë, pare soe pan, “A ma tah varih to tavus manih pe Ieesuꞌ va Nasarët. Eꞌ a teꞌ vanënën soe pamëh ne Sosoenën to vaonöt voh poan pan eꞌ se öt a kiu va pa teꞌ vanënën soe, me a ma tah kurus neꞌ to nonok non. Ivëh, ka napan to nat ne poë ko ep ne peꞌ to teꞌ me non o kikis va pa nok a ma tah kurus. ");
INSERT INTO tpz_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ko teꞌ susunön ësës heꞌ, me ro teꞌ susunön pea o Jiuꞌ to vateꞌ poë pa koren a kaman, pan eꞌ se mët. Ka kaman vaonöt in a ö nee se ni poë pa kuruse. ");
INSERT INTO tpz_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Moaan voh emöm to vaman nem pan, eꞌ kuru a teꞌ vëh ne Sosoenën to vateꞌ voh maꞌ se hehe a napan va Israël. Kuru eꞌ o vakön poen pa ö no a tah pamëh to tavus. ");
INSERT INTO tpz_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","A meh tah me, vu pa pöstakah no köövo va po vakum pemöm to vatoksean a möm pa ö ne to nö pa ep pa top vös. ");
INSERT INTO tpz_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Pare hikta ep in a sionin e Ieesuꞌ, pare hah maꞌ ko soe vamanih pan, ‘Eöm to ep maꞌ o ankeroꞌ pe Sosoenën, kee soe ka möm pan, e Ieesuꞌ to teꞌ toꞌtoꞌ e non.’ ");
INSERT INTO tpz_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ka ma upöm teꞌ va po vakum pemöm nö ee manuh pa top vös, pare ep va ee maꞌ manih pa ö no köövo to soe ava. Ivëhkëk, ee to hikta ep in a sionin e Ieesuꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ke Ieesuꞌ soe ke raoe pan, “Eöm pom to hikta maaka voh nem pa soe no teꞌ vanënën soe to soe voh. A komëneöm to ponkiꞌ avoeꞌ e non. ");
INSERT INTO tpz_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Eꞌ teꞌ vah va non nih? Eöm pom to hikta nat pöꞌ nem pa ö ne Kristo se teꞌ o kamis po vamomoaan, ka amot e Sosoenën se kunkuin taneꞌ hah poan pa nap mët, ko kë a ëhnaneah manuh pa vöön va kin.” ");
INSERT INTO tpz_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ke Ieesuꞌ vamaaka ken pee pa ma soe to teꞌ suk koman hah e non peꞌ, taneo no maꞌ po Vavaasis pe Mosës, me o Vavaasis po Teꞌ Vanënën Soe. ");
INSERT INTO tpz_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kee öök vatët ee maꞌ pa vöön vaꞌih nee to nönö ne pon, ke Ieesuꞌ nok va manih pan, eꞌ to iu oah e non. ");
INSERT INTO tpz_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ivëhkëk, ee pon to soepip ee pe Ieesuꞌ, ko soe pan, “Eën se teꞌ vaꞌpeh me a no nös möm. A potan to kunah en, ka siꞌ ö hat keꞌ poen en.” Ivëh, ke Ieesuꞌ vos en vöön, ko teꞌ vaꞌpeh me e non pee iuun. ");
INSERT INTO tpz_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kee ihoꞌ ee to ëën, ke Ieesuꞌ kon a taëën, pareꞌ soe vavihvih ke na e Sosoenën ko kökök ko heꞌ raoe se ëën. ");
INSERT INTO tpz_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Eꞌ to nok va nën ka poa matëëre maaka rakah, kee inan poꞌ poë eꞌ e Ieesuꞌ, keꞌ pah ro këh en pee. ");
INSERT INTO tpz_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kee vavaasoe koman e ne pan, “Ea to vavarion nö vu no maꞌ hanan, keꞌ heꞌ en pea pa ma soe, pareꞌ vatvus rakah ken pea pa pusun in a soe va po Puk Vapenpen. Ivëh, ka ma kupu pea pah vaeö suntan rakah ee.” ");
INSERT INTO tpz_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Varuꞌ vakomanih ee pon to sun ko nö hah ee manuh Jerusalëm. Pare taum ee po havun me a paeh vamomhë, me a ma vakamöꞌ pee, kee teꞌ tönun e ne. ");
INSERT INTO tpz_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Kee soe ke raoe pan, “Pöh man rakah, e Sunön Ieesuꞌ to sun hah en, eꞌ to tavus en pe Saëmon.” ");
INSERT INTO tpz_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ivëh, kee vamaaka ke pa ma meh pee pa ma tah kurus to tavus maꞌ manuh hanan. Ee to soe pan, “E Ieesuꞌ to kökök a taëën kemöm inan eah.” ");
INSERT INTO tpz_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","O vamomhë to vaiihi suk avoeꞌ e ne pa ma tah poë varih ke Ieesuꞌ koman to nö maꞌ, pareꞌ sun topnin e non pee. Pareꞌ soe ke raoe pan, “A komëneöm se teꞌ moomo non.” ");
INSERT INTO tpz_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ivëhkëk, eꞌe to töhkak ko naöp rakah ee, ko koman ne pan, eꞌ a apen a teꞌ to mët voh, ivëh nee to ep in. ");
INSERT INTO tpz_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ke Ieesuꞌ soe ke raoe pan, “Suk ataeah, köm töhkak ka komëneöm ponkiꞌ? ");
INSERT INTO tpz_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ep koman öm pa koreneoꞌ me a moneoꞌ vaꞌih. Vaket öm manih peöꞌ paröm nat. A apen a teꞌ to mët voh to hikta teꞌ me non to sionin me to soaꞌ vamanih pa ö nöm to ep va ka nem neoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Eꞌ to soe vamanih pareꞌ vataare en pa koren me a moneah manih pee. ");
INSERT INTO tpz_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ee to pah vaeö suntan rakah ee pa ö nee to ep in e Ieesuꞌ, ivëhkëk, eꞌe to hikta vaman avoeꞌ ne. Ee to pah kokoman vörep e ne, ke Ieesuꞌ hi raoe pan, “Eöm to teꞌ me pöꞌ e nem ta ma taëën to pet non, ha?” ");
INSERT INTO tpz_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kee heꞌ ee peꞌ pa ö iian makah. ");
INSERT INTO tpz_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ke Ieesuꞌ öt a ö iian makah ko ëën en, ee he ep ne. ");
INSERT INTO tpz_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Keꞌ soe ke raoe pan, “Moaan voh eöꞌ to teꞌ vaꞌpeh me voh a noꞌ neöm ko soe voh keoꞌ peöm. A ma tah kurus nee to kiun suk voh a neoꞌ manih po Vavaasis pe Mosës me manih po puk Vavaasis po Teꞌ Vanënën Soe me manih pa ma Vaëhëh, a ma tah kurus poë varih se tavus vaman rakah ee.” ");
INSERT INTO tpz_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Keꞌ vöhioꞌ ko vamaaka ken pee pa pusun in a soe pe Sosoenën to kiun non manih po Puk Vapenpen. ");
INSERT INTO tpz_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Pareꞌ soe ke raoe pan, “O Puk Vapenpen to soe va non manih pan, E Kristo se teꞌ o kamis ko vakön poen neꞌ se toꞌ taneꞌ hah pa nap mët. ");
INSERT INTO tpz_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ka manih po ëhnan pamëh o vavaasis va pa taateꞌ panih no a napan varih po oeh kurus se vatet, ke Sosoenën se ihan anoe a ma hat pee. Eöm se taneo o vavaasis pamëh manih Jerusalëm. ");
INSERT INTO tpz_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Paröm vatvus rakah a ma tah vamanih pa ö nöm to ep vavoh. ");
INSERT INTO tpz_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Eöꞌ koman se vanö maꞌ manih peöm a Tuvuh Vasioꞌ, moaan voh ne Tamön to soe vaman voh. Ivëhkëk, eöm se teꞌ anoeh rakah nem pa vöön vëh keꞌ onöt a ö no o kikis va manuh pa vöön va kin se nö maꞌ manih peöm.” ");
INSERT INTO tpz_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ke Ieesuꞌ me en pa ma vamomhë peꞌ manuh sinten Bëtaniꞌ, pareꞌ kë a koreneah ko tapui raoe. ");
INSERT INTO tpz_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","E Ieesuꞌ to tatapui non raoe, e Sosoenën he me peah en peꞌ manuh pa vöön va kin. ");
INSERT INTO tpz_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kee vaeö rakah ko kë ee pa ëhnaneah ko vos hah ee manuh Jerusalëm. ");
INSERT INTO tpz_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Pa ma poen kurus rakah nee to teꞌ vaꞌpeh ne pa Iuun Hinhin Apuh pa kë tamoaan a ëhnan e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Po taneo rakah voh, pö no a ma moeh tah kurus to meꞌ avoeꞌ voh e ne pa tavus, a Soe he teꞌ voh e non. A Soe pamëh to teꞌ vaꞌpeh me voh e non pe Sosoenën, ka Soe pamëh eꞌ koman voh e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ka Soe pamëh to teꞌ vaꞌpeh me voh e non pe Sosoenën pa taneo in a ma moeh tah kurus. ");
INSERT INTO tpz_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ka ma moeh tah kurus poë varih, no a Soe pamëh to nok voh manih po kikis ne Sosoenën to heꞌ poan, a hikta pah tah to tavus ke maꞌ pa ta meh hanan. Ahik, a ma moeh tah kurus poë varih to tanok voh no a Soe to soe kee tavus. ");
INSERT INTO tpz_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Manih peꞌ no a ma tah kurus to kon taneꞌ voh o toꞌtoꞌ, ka Soe pamëh to tavus va en manih po maaka, marën a vaasis a napan a soe vëh a man rakah. ");
INSERT INTO tpz_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Eꞌ o Maaka pamëh to vamaaka non a popoen, ka popoen hikta onöt non a kopös poan. ");
INSERT INTO tpz_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","E Sosoenën to vanö voh maꞌ a pah teꞌ teꞌteꞌ soe. A ëhnaneah e Jon Tövapupui. ");
INSERT INTO tpz_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Eꞌ to nö maꞌ pa vatvus a soe va po Maaka pamëh manih pa napan. Ka napan tënan a soe, pare vaman ee. ");
INSERT INTO tpz_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","E Jon koman to hikta teꞌ non pan eꞌ o Maaka pamëh. Ahik, eꞌ to nö maꞌ pa vatvus a soe va po Maaka pamëh manih pa napan. ");
INSERT INTO tpz_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","O Maaka man pamëh to nönö nö non maꞌ manih po oeh pa vamaaka a napan. ");
INSERT INTO tpz_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","A Soe varoe to teꞌ voh non manih po oeh, ko oeh pamëh ne Sosoenën to nok koe voh manih peꞌ, ivëhkëk, a napan to teꞌ ne po oeh pamëh to hikta inan ne poë. ");
INSERT INTO tpz_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Eꞌ to nö voh manih pa napan va pa muhin koman peꞌ, ivëhkëk, a napan poë varih to hikta haraꞌ vaeö ne, pare hikta öt poë. ");
INSERT INTO tpz_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ivëhkëk, o teꞌ varih to öt poë, pare vaman poë, neꞌ to heꞌ en pee pa tasun, kee tavus ee o pus koaꞌ pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","A napan poë varih to hikta tavus voh o pus koaꞌ pe Sosoenën manih po eraꞌ pe taman pen sinan, keꞌ manih po haharaꞌ va po sionin, me manih po haharaꞌ pa teꞌ. Ahik, ee to panih a ma taateꞌ hat pee ke Sosoenën kon raoe kee tavus ee o pus koaꞌ peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","A Soe pamëh to tavus teꞌ en, pareꞌ nö maꞌ ko teꞌ vaꞌpeh me e non pemöm. Kemöm ep em pa tasun apuh peꞌ. Ka tasun pamëh, eꞌ a tasun to vatoe me e non pa tasun pe Sosoenën. Ka tasun peꞌ to vataare a no möm pan, eꞌ a paeh ro a Koaꞌ ne Tamön to vanö maꞌ. Ke Koaꞌ pamëh to pah iu rakah e non pemöm, pareꞌ vataare vamaaka rakah en pemöm pa soe man to taneꞌ maꞌ manuh pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","E Jon to vavatvus non a soe, pareꞌ soe pan, “Ivaꞌih a teꞌ nöꞌ to sosoe suk voh noꞌ, paröꞌ soe pan, ‘A teꞌ vëh se suk a maꞌ neoꞌ no a tasun peꞌ to teꞌ oah e non pa teꞌ tasun peöꞌ. Suk ataeah, eꞌ to teꞌ momoaan voh ke non peöꞌ.’” ");
INSERT INTO tpz_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Eꞌ to vih kurus ka rora, suk eꞌ to iu rakah a rora, ivëh, neꞌ se heꞌ suk a ra a ma tah vihvih va kuru me a ma teꞌ tah vihvih va amot. ");
INSERT INTO tpz_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","E Sosoenën to heꞌ a ra o Vavaasis peꞌ manih pe Mosës. Ivëhkëk, e Sosoenën koman to vataare a ra o iu peꞌ, pareꞌ vakoe ke maꞌ a soe man va peꞌ manih pe Ieesuꞌ Kristo. ");
INSERT INTO tpz_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ahik voh ta pah teꞌ to ep in e Sosoenën. Ahik rakah, a pah Koaꞌ ro pe Sosoenën vëh, eꞌ koman e Sosoenën, to teꞌ vatët tamoaan non sih manih peꞌ, pareꞌ vataare a ra a taateꞌ pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","O teꞌ susunön po Jiuꞌ to vanö taneꞌ a ma pah teꞌ ësës heꞌ, me o Livaë po Jiuꞌ manuh Jerusalëm kee nö ee manih pe Jon, pare hi poë pan, “Eën eteh?” ");
INSERT INTO tpz_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ke Jon hikta naöp, eꞌ he soe vamaaka rakah ken pee pan, “Eöꞌ to hikta teꞌ noꞌ pan eöꞌ a teꞌ vëh ne Sosoenën to vateꞌ maꞌ keꞌ nö maꞌ, ivëh, no a napan to popokaꞌ ne sih poë e Kristo. ");
INSERT INTO tpz_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ka ma pah teꞌ ësës heꞌ me o Livaë hi hahah kov ee peꞌ pan, “Eën poꞌ eteh? Eën kës e Elaëjaꞌ?” Keꞌ piun ra poë, pareꞌ soe pan, “Ahik!” Kee hi hahah kov ee peꞌ, “Keꞌ eën a teꞌ vanënën soe eh?” Keꞌ piun en, “Ahik!” ");
INSERT INTO tpz_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ivëh, kee hi hahah kov ee peꞌ pan, “Ke eën rakah poꞌ eteh? Heꞌ a möm ah tapiun kemöm sih hah ko soe vanat o teꞌ varih to vanö a maꞌ möm. Eën se soe vamaaka ka möm eën eteh? ");
INSERT INTO tpz_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ke Jon piun raoe, pareꞌ vahoꞌ a soe peꞌ manih pa soe voh pa teꞌ vanënën soe vëh e Aisaëaꞌ, pareꞌ soe pan, “Manih pa moeh upin a rivoneoꞌ to teꞌ va non manih pa rivon a pah teꞌ to vavaoe non maꞌ pan, ‘Vatotoopin öm a hanan pe Sunön.’” ");
INSERT INTO tpz_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ka ma teꞌ varih no Parësiꞌ to vanö maꞌ, hi ee pe Jon pan, ");
INSERT INTO tpz_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Eën se keh hikta teꞌ nom pan, eën e Kristo, me eën se keh hikta teꞌ nom pan, eën e Elaëjaꞌ, keꞌ a teꞌ vanënën soe, vahvapoꞌnih kën pupui nom a napan pa ruen? ");
INSERT INTO tpz_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ke Jon piun raoe, pareꞌ soe pan, “Eöꞌ to pupui noꞌ sih a napan pa ruen, ivëhkëk, eꞌ to teꞌ non a pah teꞌ to teꞌ vaꞌpeh me e non peöm manih, nöm to hikta nat nem peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Keꞌ eꞌ a teꞌ ko pamëh to suk a maꞌ neoꞌ. Eöꞌ to hikta vih onöt noꞌ a ihan këh eah o uris vëh pa suꞌ peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","A ma soe varih ne Jon to soe pa pap Jödën vöh manih pa vöön va Bëtaniꞌ. Manih pa vöön pamëh ne Jon to pupui non a napan pa ruen. ");
INSERT INTO tpz_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ka muhin takah po meoh poen, ke Jon ep i na e Ieesuꞌ to nö maꞌ pa ep peꞌ, pareꞌ soe vamanih pan, “Ep këk öm, ivaꞌuh a Soneꞌ Sipsip pe Sosoenën to nö en maꞌ. Eꞌ se vahik a ma hat pa napan kurus va po oeh vëh. ");
INSERT INTO tpz_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ivaꞌih, a teꞌ pamëh nöꞌ to sosoe suk voh noꞌ, paröꞌ soe pan, ‘A teꞌ vëh se suk a maꞌ neoꞌ, eꞌ to vih oah e non peöꞌ, suk ataeah, eꞌ to teꞌ vovoh voh ke non peöꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Eöꞌ koman to hikta nat voh noꞌ peꞌ eteh. Ko poen nöꞌ to nonok noꞌ a kiu va pa pupui a napan, pan eöꞌ se vataare a napan va Israël kee ep pare maaka poꞌ e Ieesuꞌ eteh.” ");
INSERT INTO tpz_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ivëh, ne Jon to soe suk vamanih pan, “Eöꞌ to ep in a Tuvuh Vasioꞌ to kunah taneꞌ maꞌ pa akis to matan va non manih pa panuh, pareꞌ atantön non poan. ");
INSERT INTO tpz_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Eöꞌ koman to hikta nat voh noꞌ peꞌ etieh. Ivëhkëk e Sosoenën vëh to vanö voh a maꞌ neoꞌ köꞌ pupui noꞌ a napan pa ruen to soe ka neoꞌ pan, ‘Eën se keh ep in a Tuvuh Vasioꞌ to kunah taneꞌ maꞌ pa akis, pareꞌ atantön non ta pah teꞌ, eën se nat eom pa teꞌ ko pamëh se pupui a napan pa Tuvuh Vasioꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Eöꞌ to ep voh a tah vëh to tavus, paröꞌ soe vaman rakah keoꞌ peöm pan, a teꞌ vaꞌih eꞌ e Koaꞌ vamaman rakah pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","A muhin to takah en po meoh poen ke Jon sun vaꞌpeh me non a poa vamomhë peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","E Jon to ep i na e Ieesuꞌ to oꞌoah nö non, pareꞌ soe ke ra poa vamomhë peꞌ pan, “Ep këk na öm, a Soneꞌ Sipsip pe Sosoenën ivöh.” ");
INSERT INTO tpz_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ka poa vamomhë pënton e Jon to sosoe va non manih, pare vatet ee pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ke Ieesuꞌ tarih maꞌ, pareꞌ ep i raoe to suksuk nö ne poë, pareꞌ hi rapoë pan, “Eöm iu nem ataeah pom?” Kee piun poë, pare soe, “Rabaëꞌ, eën teꞌ nom pa iuun poanheh?” O ëhnan “Rabaëꞌ” to soe non pan “Tövavaasis”, manih po to pa napan va Hibru. ");
INSERT INTO tpz_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Keꞌ piun a poa vamomhë pe Jon, pareꞌ soe, “Nö maꞌ öm, paröm ep.” Ivëh, ka poa vamomhë poë varih nö vaꞌpeh me ee pe Ieesuꞌ, pare ep ee pa ö neꞌ to teꞌteꞌ non sih, ko teꞌ vaꞌpeh me e ne peꞌ pa potan pamëh. Suk ataeah, a potan to matan va non manih pa 4 kirök pa matanpoen. ");
INSERT INTO tpz_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","E Ëndruꞌ, kea pe Saëmon Pitaꞌ a paeh va pa poa vamomhë poë varih to pënton a soe pe Jon, pareꞌ vatet en pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ka tah vamomoaan rakah ne Ëndruꞌ to nok ivaꞌih, eꞌ to këh e Ieesuꞌ, pareꞌ nö en pa ep këh e kea peꞌ Saëmon Pitaꞌ, pareꞌ soe ke poan pan, “Emöm to taum em pe Mesaëaꞌ.” Ka pusun in o ëhnan Mesaëaꞌ to soe va non manih pan, “Kristo.” ");
INSERT INTO tpz_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Vasuksuk poꞌ ne Ëndruꞌ to me en pe Saëmon manuh pe Ieesuꞌ. Ke Ieesuꞌ ep poan, pareꞌ soe pan, “Eën e Saëmon sunaiꞌ Jon. Amot no a napan se popokaꞌ a nom oah e Sifas.” Ko ëhnan “Sifas” to teꞌ akuk va kov e non manih pan, “Pitaꞌ”, ka pusun in o ëhnan Pitaꞌ to soe va non manih pan, “A vös”. ");
INSERT INTO tpz_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","A muhin to takah po meoh poen ke Ieesuꞌ kehkeh nö non pa muhin va Galiliꞌ. Eꞌ to nönö nö non, pareꞌ taum e Filip, pareꞌ soe ke poan pan, “Filip, suk a maꞌ neoꞌ ah.” ");
INSERT INTO tpz_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","E Filip, eꞌ a teꞌ va pa vöön va Bëtsaëtaꞌ, a vöön pamëh ne Ëndruꞌ pen Pitaꞌ to teꞌ ne sih. ");
INSERT INTO tpz_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","E Filip to taum pet e Nataniel, pareꞌ soe ke poan pan, “Nataniel! Emöm to taum em pa teꞌ vëh ne Mosës to kiun suk voh manih po Vavaasis peꞌ. O teꞌ vanënën soe me to kinkiun suk voh ne poë. Eꞌ e Ieesuꞌ e koaꞌ pe Jeosëp, ka vöön peꞌ ivëh Nasarët.” ");
INSERT INTO tpz_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ivëhkëk e Nataniel to hi e Filip pan, “Eën kës to koman nom pan ta tah vih se tavus manih Nasarët?” Ke Filip soe pan, “Maꞌ ah, ka nö, para ep.” ");
INSERT INTO tpz_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ke Ieesuꞌ ep i na e Nataniel to nönö nö non maꞌ manih peꞌ, pareꞌ soe pan, “Ivaꞌuh a to Israël vamaman rakah, ahik to pöh piuk to teꞌ non manih peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ke Nataniel hi varuꞌ e Ieesuꞌ, pareꞌ soe pan, “Eën nat vah va ka nom neoꞌ nih?” Ke Ieesuꞌ soe ke poan pan, “Vamomoaan ne Filip to hikta vaoe avoeꞌ voh a nom oah, eöꞌ he ep e noꞌ pën to sun nom po pusun in o naon nee to popokaꞌ ne o fik.” ");
INSERT INTO tpz_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ke Nataniel piun poan, pareꞌ soe pan, “Tövavaasis, eën vavaman rakah e Koaꞌ pe Sosoenën. Me eën e Sunön pa napan va Israël.” ");
INSERT INTO tpz_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ke Ieesuꞌ piun en pe Nataniel, pareꞌ soe pan, “Eën to vaman suk pöꞌ a ö nöꞌ to soe pan, eöꞌ to ep voh ka oah po pusun in o naon vëh o fik. Ivëhkëk, amot nën se ep in a ma meh tah to apuh oah e ne pa ma teꞌ tah nën to ep in kuru.” ");
INSERT INTO tpz_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ke Ieesuꞌ soe ke rapoë pan, “Eöꞌ to soe vaman rakah keoꞌ peöm pom, eöm se ep a vöön va kin se taperet, ko ankeroꞌ pe Sosoenën se pepeah kov e ne, pare kukunah kov e ne maꞌ manih peöꞌ e Koaꞌ Teꞌ Pa Napan Kurus.” ");
INSERT INTO tpz_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","E Ieesuꞌ to vaoe vahik en pe Filip pen Nataniel ko pöök poen oah ee. Ka pah teꞌ vaen en manih pa vöön va Keenan, a vöön pamëh to teꞌ non manih pa muhin va Galiliꞌ. Ke sinan e Ieesuꞌ nö en po vaen pamëh. ");
INSERT INTO tpz_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Kee vaoe me ee maꞌ pe Ieesuꞌ me ra ma vamomhë peꞌ, pan ee se nö pa taëën va po vaen pamëh. ");
INSERT INTO tpz_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","O voaën to hik rakah en, ke sinan e Ieesuꞌ soe ke sunaiꞌeah pan, “O voaën to hik këh en pa napan.” ");
INSERT INTO tpz_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ke Ieesuꞌ piun a soe pe sinaneah pareꞌ soe pan, “Sisiꞌ, eꞌ a tah koman pën, eꞌ to hikta teꞌ non pan, eꞌ a tah peöꞌ. A aoaꞌ nöꞌ se vataare o kikis peöꞌ to meꞌ avoeꞌ e non pa tavus maꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ke sinaneah Mariaꞌ soe ke ra nap kiu pan, “Eꞌ se keh soe ka neöm a nok ta taeah, eöm se nok suk a ö neꞌ se soe va ka neöm.” ");
INSERT INTO tpz_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Manih pa koman a iuun vëh no a napan to teꞌ ne pa taëën va po vaen, to teꞌ non a tönim nöh me a paeh nee to nok voh pa vös no o Jiuꞌ to vavahu ne sih pa ma poen va pa taateꞌ vahu. A ma papaeh nöh to onöt ne a vapuh a 100 ritaꞌ pa ruen. ");
INSERT INTO tpz_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ke Ieesuꞌ soe ke ra nap kiu pan, “Isisu a ruen manih pa ma nöh varih.” Kee isisu a ma nöh poë varih kee puh rakah ee pa ruen. ");
INSERT INTO tpz_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Keꞌ soe ke poꞌ en pee pan, “Kan taneꞌ a ruen manih pa ma nöh ruen varih paröm teꞌ ke na e susun pa taëën va po vaen.” Ivëh, kee koꞌ ee pa ruen, pare teꞌ ee manuh pe susun pa taëën. ");
INSERT INTO tpz_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ke susun pa taëën va po vaen punöꞌ en pa ruen, eꞌ to puta en pa ruen to ninin va i non manih po voaën. Pareꞌ hikta nat non o voaën pamëh taneꞌ maꞌ nih. Ivëhkëk, a nap kiu varih to teꞌ maꞌ a ruen to nat e ne. Ke susun pa taëën vaoe en na pe tövaen. ");
INSERT INTO tpz_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Pareꞌ soe ke poan pan, “A ma tamoaan no a napan to vavovoh ne sih o voaën vih manih pa napan to teꞌ ne pa taëën va po vaen. Vasuksuk no a napan se keh kaak vaonöt ee, kee heꞌ poꞌ maꞌ o teꞌ voaën vëh to hikta teꞌ vih tiroëꞌ non. Ivëhkëk, varuꞌ vakomanih nën to heꞌ maꞌ o voaën vih, no a napan sih vu kaak momoaan!” ");
INSERT INTO tpz_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Manih Keenan pa muhin va Galiliꞌ ne Ieesuꞌ to nok a tah vatoksean vamomoaan peꞌ nën. Manih pa vöön pamëh neꞌ to vataare o kikis peꞌ ko vamomhë peꞌ ep, pare vaman poë. ");
INSERT INTO tpz_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","E Ieesuꞌ to nok vahik a ma tah varih manih Keenan, pareꞌ nö vaꞌpeh me en pe sinaneah manih pa vöön nee to pokaꞌ ne a Kapaneam. Eꞌ to nö vaꞌpeh me en pa ma kea peꞌ me ra ma vamomhë peꞌ, kee teꞌ e ne nën pa ma siꞌ poen. ");
INSERT INTO tpz_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","A siꞌ ö hat ko poen va po Pasovaꞌ tavus en. Ivëh, ke Ieesuꞌ nö en manuh Jerusalëm. ");
INSERT INTO tpz_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Manih pa koman a Iuun Hinhin Apuh neꞌ to taum a napan to vavavoen ne o purmakaöꞌ, me ro sipsip, me ro panuh. Ko upöm vonvoen ne marën a ës ke na e Sosoenën. Eꞌ to ep en po upöm to ihoꞌ ne pa ma pok ko papanih ne a ma vu moniꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","E Ieesuꞌ to kon o opëꞌ, pareꞌ nok opëꞌ rëprëp teꞌ, pareꞌ veo tavus en po purmakaöꞌ me ro sipsip. Kee këh tavus ee pa Iuun Hinhin Apuh, eꞌ to kopkoep en pa ma pok po teꞌ varih to papanih moniꞌ ne, ka ma moniꞌ pee tataru ee manih po oeh. ");
INSERT INTO tpz_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","E Ieesuꞌ soe ke ro teꞌ varih to vavavoen ne o panuh pan, “Kokon öm a ma tah varih, paröm teꞌteꞌ tavus këh na a iuun pe Tamön, paröm koe a nok a ö totoaan peöm manih koman a iuun Peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ka ma vamomhë peꞌ ep in a ma tah varih to tanok, pare koman hah a soe to kiun non po puk pe Sosoenën to soe non pan, “Eöꞌ to iu rakah noꞌ a iuun pën se teꞌ vavih non, ivëh, köꞌ koman vëhvaꞌ rakah e noꞌ pa matop vavih a iuun pamëh.” ");
INSERT INTO tpz_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ko Jiuꞌ soe ke Ieesuꞌ pan, “Vataare a möm ah, ta tah vatoksean to vataare a nom oah to teꞌ me nom o kikis va pa nok a ma kiu varih nën to nonok nom.” ");
INSERT INTO tpz_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “Eöm se kök a Iuun Hinhin Apuh vëh, köꞌ eok hah eoꞌ peꞌ po kukön poen ro.” ");
INSERT INTO tpz_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ko Jiuꞌ piun poë pare soe pan, “O 46 Kirismas to kon voh a möm pa eok a Iuun Hinhin Apuh vëh. Eën onöt rakah kës e nöm pö nën se eok hah a Iuun Hinhin Apuh pamëh po kukön poen ro, ha?” ");
INSERT INTO tpz_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ivëhkëk, a Iuun Hinhin Apuh vëh ne Ieesuꞌ to koman voh non ivëh, a sionineah, eꞌ se mët ko vakön poen neꞌ se sun taneꞌ hah en manih po vapeepe. ");
INSERT INTO tpz_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","E Ieesuꞌ to sun taneꞌ hah manih po vapeepe, ka ma vamomhë peꞌ koman hah a soe neꞌ to soe voh, pare vaman rakah ee pa soe peꞌ, me a ma soe to kiun non po Puk pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","E Ieesuꞌ to teꞌ avoeꞌ e non Jerusalëm ko poen va po Pasovaꞌ tavus en. Ka nap peo ep a ma tah vatoksean neꞌ to nonok non, pare vaman ee peꞌ a teꞌ vëh ne Sosoenën to vateꞌ maꞌ, keꞌ nö maꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ivëhkëk, e Ieesuꞌ to hikta vaman non raoe, suk eꞌ to nat vavih e non pa ma taateꞌ pee. ");
INSERT INTO tpz_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Eꞌ to hikta iu non ta teꞌ se soe vanat poan o kokoman po upöm teꞌ. Suk ataeah, eꞌ to nat vahik e non pa ma kokoman pee. ");
INSERT INTO tpz_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Eꞌ to teꞌ voh non a pah teꞌ a ëhnaneah e Nikodimus, e Nikodimus koman eꞌ a to Parësiꞌ. Eꞌ me a teꞌ va po Vakum Teꞌ Susunön po Jiuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","O pöh poen pa popoen neꞌ to nö maꞌ manih pe Ieesuꞌ, pareꞌ soe pan, “Tövavaasis, emöm to nat e nem pën a Tövavaasis ne Sosoenën to vanö maꞌ, suk ataeah, a hikta meh teꞌ to onöt non a nok a ma tah vatoksean varih nën to nonok nom pa ö ne Sosoenën se keh hikta teꞌ vaꞌpeh me non eah.” ");
INSERT INTO tpz_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ke Ieesuꞌ piun poan, pareꞌ soe pan, “Eöꞌ to soe vamaman rakah keöꞌ pën, a teꞌ se keh hikta tavus vavoon, eꞌ to hikta antoen non a teꞌ manih pa koman a Matop Vih Pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ke Nikodimus soe varuꞌ ke Ieesuꞌ pan, “Ivëhkëk. a teꞌ se keh manot voh en eꞌ se tavus vavoon vahvanih? Eꞌ kës to onöt e non pa hop hah manuh pa koman e sinaneah ke sinaneah vapöök vahuh hah poan?” ");
INSERT INTO tpz_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","E Ieesuꞌ to piun poan, pareꞌ soe pan, “Eöꞌ to soe vamaman rakah keoꞌ pën, a Tuvuh Vasioꞌ me a ruen se keh hikta vatvus o toꞌtoꞌ voon manih pa teꞌ, a teꞌ pamëh hikta antoen non a teꞌ hop manih pa Matop Vih Pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","A tah no sionin to nok keꞌ tavus, eꞌ a tah va po sionin, ka tah no a Tuvuh Vasioꞌ to nok eꞌ a tah koman pa Tuvuh Vasioꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Eën se nat nom töhkak in a soe vaꞌih nöꞌ to soe ka oah pan, ‘Eöm se panih ko tavus vavoon.’ ");
INSERT INTO tpz_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","A tuvuh to tata suk non sih o iu peꞌ, ka tënan ro no a tanih peꞌ. Para hikta nat no eꞌ tataneꞌ non maꞌ nih, pareꞌ nönö non nih. Eꞌ to vatoe akuk va kov e non manih pa teꞌ to panih, pareꞌ tavus vavoon manih pa Tuvuh Vasioꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ke Nikodimus hi hah en pe Ieesuꞌ pan, “A tah pamëh nën to sosoe nom se tavus vahvanih?” ");
INSERT INTO tpz_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ke Ieesuꞌ piun, pareꞌ soe ke poan pan, “Vahvanih kën hikta maaka i nom a tah vaꞌih. Eën poꞌ a tövavaasis pa napan va Israël toh? ");
INSERT INTO tpz_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Eöꞌ to soe vaman rakah keoꞌ pën, eöꞌ to sosoe e noꞌ pa tah nöꞌ to nat noꞌ. Paröꞌ sosoe tavus e noꞌ pa tah nöꞌ to ep voh. Ivëhkëk, eöm to tarih ke voh em pa soe pamëh. ");
INSERT INTO tpz_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Eöꞌ to soe vahik ke voh eoꞌ peöm pa ma tah kurus to teꞌ ne manih po oeh vëh. Ivëhkëk, eöꞌ to sosoe ka noꞌ neöm sih a ma tah va pa vöön va kin köm hikta vaman nem a soe peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ahik voh ta teꞌ to peah avoeꞌ voh non manuh pa vöön va kin. A paeh ro a teꞌ to kunah taneꞌ maꞌ nën, ivëh eöꞌ, e Koaꞌ Teꞌ Pa Napan Kurus. ");
INSERT INTO tpz_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moaan voh manih pa moeh upin ne Mosës to vahan a kuruꞌ nee to nok po bras manih po naon. Ka tah pamëh to vataare non a ö no a napan kurus va po oeh vëh se vahan va in e Koaꞌ Teꞌ Pa Napan Kurus manih po naon. ");
INSERT INTO tpz_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ka napan kurus varih to vaman a ne neoꞌ, ee se kon ee po toꞌtoꞌ tamoaan. ");
INSERT INTO tpz_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","E Sosoenën to iu rakah non a napan va po oeh vëh, ivëh keꞌ vanö maꞌ a pah Koaꞌ ro peꞌ pan etereh se vaman poë, ee se kon taneꞌ o toꞌtoꞌ tamoaan manih peꞌ, pare hikta se ro ne. ");
INSERT INTO tpz_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","E Sosoenën to hikta vanö voh maꞌ e Koaꞌ peꞌ manih po oeh marën a vateꞌ a napan pa punis. Ahik, eꞌ to vanö voh maꞌ poan marën a ö neꞌ se voen hah raoe. ");
INSERT INTO tpz_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","A napan varih to vaman ne e Koaꞌ pe Sosoenën ee hikta se teen ne a punis. Ivëhkëk, o teꞌ varih to hikta vaman ne e Koaꞌ pamëh, ee se teen ee a punis. Suk ataeah, ee to hikta vaman ne e Koaꞌ pe Sosoenën a paeh ro. ");
INSERT INTO tpz_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ka pusun in a teꞌ pa napan po vahutët ivëh pan, o maaka to taneꞌ maꞌ manuh pa vöön va kin to nö voh maꞌ manih po oeh. Ivëhkëk, a napan to hikta iu vaman ne o maaka pamëh. Ee to iu teꞌ vaviꞌ rakah e ne pa popoen. Suk eꞌe to iu nok ne a ma taateꞌ hat. ");
INSERT INTO tpz_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","O teꞌ varih to nonok ne sih a ma taateꞌ hat, ee to hikta iu ne o maaka, pare hikta iu teꞌ me ne po maaka. Suk ataeah, o maaka pamëh to meꞌ vataare en pa ma taateꞌ hat pee, ka ma taateꞌ hat poë varih nee se kon kamis suk ee. ");
INSERT INTO tpz_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ivëhkëk, o teꞌ varih to vavatet ne a soe man, a napan poë varih to kon ee po maaka, ivëh, ka napan inan ee pee to nonok ne a ma kiu pee po kikis pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Po meoh poen ne Ieesuꞌ to vaato vahik me en pe Nikodimus, pareꞌ nö vaꞌpeh me en pa ma vamomhë peꞌ, kee nö ee pa ö muhin nee to pokaꞌ ne a Jiutiaꞌ, pare teꞌ e ne nën. Ka napan nönö kov e ne pee, ke Ieesuꞌ me ra vamomhë peꞌ pupui kov e ne pee pa ruen. ");
INSERT INTO tpz_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","E Jon to pupui non a napan pa ö neꞌ to teꞌ non pa vöön va Aënon, a vöön pamëh to teꞌ vatët non pa teꞌ vöön va Salim. Suk ataeah, a ma ruen peo to teꞌ ne nën. Ka napan nönö kov e ne maꞌ manih pe Jon, keꞌ pupui e non pee pa ruen. ");
INSERT INTO tpz_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","A ma tah kurus poë varih to tatanok ne e Hëërot he meꞌ avoeꞌ e non pa vahoꞌ e Jon manih pa nohnoh. ");
INSERT INTO tpz_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","A ma meh vamomhë pe Jon to vaato vasukaꞌ me a pah to Jiuꞌ. Ee to vaato vasukaꞌ suk ne a taateꞌ no a napan se suksuk ne manih pa taateꞌ vahu, ke Sosoenën sih inan raoe to tavus vavoon manih po epep peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ivëh, ko vamomhë nö ee manuh pe Jon, pare soe ke poë pan, “Tövavaasis, eën nat kës e nom pa teꞌ vëh to teꞌ vaꞌpeh me voh a rora manuh pa pap ruen vöh nee to pokaꞌ ne sih a Jödën. A teꞌ pamëh nën to sosoe suk voh nom to pupui non a napan pa ruen, ka napan nönö kov e ne manuh peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","E Jon to piun a ma vamomhë peꞌ, pareꞌ soe pan, “A teꞌ se kon en pa taeah ne Sosoenën se heꞌ poan.” ");
INSERT INTO tpz_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Eöm koman to pënton voh em peöꞌ to soe ka neöm pan, “Eöꞌ to hikta teꞌ noꞌ pan eöꞌ e Kristo, ahik. Eöꞌ a teꞌ ne Sosoenën to vavovoh maꞌ pan eöꞌ se vatotoopin a hanan neꞌ se suk maꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","A pah tövaen se keh me ta köövo, e köövo pamëh to tavus en e köövo peꞌ. E vamomhë pe tövaen pamëh se sun non, pareꞌ vaeö rakah en pa tënan a soe pa teꞌ tövaen. Eꞌ to teꞌ akuk va kov e non manih pa ö no vaeö to puh non manih pa komaneoꞌ, suk eöꞌ e vamomhë pe tövaen. ");
INSERT INTO tpz_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ka ëhnaneah tavus en a teꞌ sunön, ka teꞌ ëhnaneoꞌ tavus en a siꞌ tah pinpiun.” ");
INSERT INTO tpz_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“A teꞌ to taneꞌ maꞌ pa vöön va kin to apuh oah e non pa ma moeh tah kurus. Ka teꞌ to teꞌ non manih po oeh vëh, eꞌ to vavaato suk ro non a ma tah va po oeh. Ivëhkëk, a teꞌ to taneꞌ maꞌ pa vöön va kin eꞌ to apuh oah e non pa ma moeh tah kurus va po oeh vëh. ");
INSERT INTO tpz_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Eꞌ to vavatvus non a tah neꞌ to ep, pareꞌ tënan voh, manih pe Tamaneah. Ivëhkëk, manih pea no a hikta pah teꞌ to pënton, pareꞌ kon a tah ne Sosoenën to sosoe non. ");
INSERT INTO tpz_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Eteh to kon a soe pe Sosoenën, pareꞌ öt vakis ko vaman a soe pamëh, eꞌ to vataare en pan, ‘E Sosoenën eꞌ a sosoe man.’ ");
INSERT INTO tpz_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","A teꞌ vëh ne Sosoenën to vanö maꞌ ivëh e Ieesuꞌ, eꞌ to vavatvus non a soe peꞌ, suk ataeah, e Sosoenën to heꞌ avoes voh en peꞌ pa Tuvuh Vasioꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","E Tamön to iu rakah non e Koaꞌ peꞌ, pareꞌ heꞌ poan a tasun to apuh oah e non pa ma moeh tah kurus. ");
INSERT INTO tpz_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","O teꞌ varih to vaman ne e Koaꞌ pe Sosoenën, ee to kon ee po toꞌtoꞌ tamoaan. Ivëhkëk, o teꞌ varih to hikta vaman ne a soe pe Koaꞌ pe Sosoenën, ee to hikta antoen ne a kon o toꞌtoꞌ tamoaan. Ahik, e Sosoenën se veo en pee manuh po suraꞌ ësës tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","O Parësiꞌ to pënton ee pan e Ieesuꞌ to pupui a nap peo, ka nap peo poë varih tavus ee o vamomhë peꞌ. Kee peo oah ee pa ma teꞌ vamomhë pe Jon. Ivëhkëk, eꞌ to hikta teꞌ non pan e Ieesuꞌ ivëh to pupui non a napan, ahik, o vamomhë koman peꞌ ivarih to pupui ne pa napan pa ruen. Ke Ieesuꞌ nat poꞌ en po Parësiꞌ to pënton ee pa nap peo rakah to tavus ee o vamomhë peꞌ. Ivëh, neꞌ to këh suk a muhin va Jiutiaꞌ, pareꞌ hah en pa muhin va Galiliꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ivëhkëk, a hanan neꞌ to suk to koe ke non manih pa muhin va Samëriaꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Manih pa koman a muhin va Samëriaꞌ ne Ieesuꞌ to nö, pareꞌ vos en manih pa vöön nee to pokaꞌ ne Sikar. A vöön pamëh to teꞌ vatët non po oeh ne Jekop to heꞌ voh e sunaiꞌeah Jeosëp. ");
INSERT INTO tpz_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","A tah to matan va non manih pa 12 kirök pa topnin potan ne Ieesuꞌ to me nönö nö, pareꞌ pak ko ihoꞌ en pa sinten a koveꞌ ruen pamëh. Ka koveꞌ ruen pamëh eꞌ a koveꞌ ruen ne Jekop to een voh. ");
INSERT INTO tpz_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","E Ieesuꞌ teꞌ non nën, ka köövo va Samëriaꞌ nö en maꞌ pa isu a ruen manih pa koveꞌ ruen pamëh. Ke Ieesuꞌ soe ke poan pan, “Eöꞌ to manoe, heꞌ a neoꞌ ah ta ruen köꞌ kaak.” ");
INSERT INTO tpz_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","A tah pamëh to tavus pa ö no ma vamomhë peꞌ to nö vöön pa vavoen taëën. ");
INSERT INTO tpz_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","E köövo va Samëriaꞌ to soe ke Ieesuꞌ pan, “Eën to vatoksean a neoꞌ pa ö nën to hin a neoꞌ a ruen to kaak. Suk eën a to Jiuꞌ ke eöꞌ a köövo va Samëriaꞌ.” E köövo to soe suk vamanih, a napan va Israël to hikta vamomhë me ne sih a napan va Samëriaꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ke Ieesuꞌ piun a soe pe köövo va Samëriaꞌ, pareꞌ soe pan, “Eën nat e nom po heꞌ pe Sosoenën ëh? Eën nat me e nom pa teꞌ vëh to hinhin ruen a nom oah to kaak, ha? Eën se hin eah a ruen keꞌ heꞌ en pën pa ruen va po toꞌtoꞌ tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ke köövo soe ke Ieesuꞌ pan, “Eën se kon taneꞌ maꞌ a ruen va po toꞌtoꞌ tamoaan nih? A koveꞌ ruen vëh to parin a ruruvun, kën hikta teꞌ me nom ta tah nën se kan taneꞌ na a ruen manuh pa koman a koveꞌ ruen pamëh. ");
INSERT INTO tpz_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","A tasun pën apuh oah kës e non pa teꞌ tasun pe sipuura Jekop? E Jekop to heꞌ voh en pemöm pa koveꞌ ruen vëh. A koveꞌ ruen vëh nee to kakaak voh ne me ro pus koaꞌ peꞌ, me ra ma tah mamakën pee.” ");
INSERT INTO tpz_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ke Ieesuꞌ piun a soe pe köövo pamëh, pareꞌ soe pan, “A napan kurus to kakaak taneꞌ ne sih manih pa koveꞌ ruen vaꞌih, ee se haharaꞌ avoeꞌ e ne po manoe. ");
INSERT INTO tpz_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ivëhkëk, ta pah teꞌ se keh kaak a ruen vëh nöꞌ se heꞌ eah, eꞌ to hikta onöt non a haraꞌ hah o manoe. Ka ruen vëh nöꞌ se heꞌ eah, eꞌ se tavus en a ruen to vuvu non manih pa komaneah. Ka ruen pamëh se puh tamoaan e non manih pa komaneah, ko heꞌ e non peꞌ po toꞌtoꞌ tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ke köövo pamëh soe ke Ieesuꞌ pan, “Sunön, heꞌ a neoꞌ ah a ruen pamëh, köꞌ kakaak noꞌ ko hikta se haraꞌ hah noꞌ o manoe, me eöꞌ hikta se nönö vatëh noꞌ maꞌ pa isisu ruen manih.” ");
INSERT INTO tpz_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ke Ieesuꞌ soe ke köövo pamëh pan, “Vos ah vöön parën vaoe maꞌ e voe manot pën köm nö maꞌ manih pom.” ");
INSERT INTO tpz_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ke köövo soe ke Ieesuꞌ pan, “Eöꞌ to hikta teꞌ me noꞌ ta voe.” Ke Ieesuꞌ soe ke poan pan, “A soe pën a man, pö nën to soe ka neoꞌ pan eën to hikta teꞌ me nom ta voe. ");
INSERT INTO tpz_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","A soe pën to teꞌ man e non, suk ataeah, moaan voh nën to me voh nom a tönim voe. Ka teꞌ voe vëh nën to teꞌ me nom kuru, eꞌ to hikta teꞌ non pan eꞌ e voe vamaman pën.” ");
INSERT INTO tpz_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ke köövo soe pan, “Sunön, kuru eöꞌ to nat eoꞌ pën a teꞌ vanënën soe. ");
INSERT INTO tpz_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","A kën sipunmöm to tötönun ne sih pa tope vëh, ko vasunön ne e Sosoenën. Ivëhkëk, eöm varih a napan va Israël to sosoe nem sih pan, a ö tötönun pea ivöh Jerusalëm pa vasunön e Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ke Ieesuꞌ soe ke köövo pamëh pan, “Köövo, vaman a neoꞌ ah. Eꞌ to teꞌ non o pöh poen se tavus amot maꞌ ne eöm hikta antoen nem a tönun pa tope vëh, paröm vasunön e Tamön. Eöm me to hikta antoen nem a nö manuh Jerusalëm pa vasunön eah nën”. ");
INSERT INTO tpz_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ke eom varih a napan va Samëriaꞌ, eöm to vasunön nem a teꞌ ne eöm to hikta nat vavih nem eah. Kemöm varih a napan va Israël, emöm to nat e nem peteh nemöm to vasunön nem eah sih. Suk ataeah, emöm a napan va Israël, emöm to onöt e nem pa vamaaka ke ra napan a ö ne Sosoenën se kon taneꞌ hah raoe manih pa taateꞌ hat. ");
INSERT INTO tpz_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ivëhkëk, kuru no o poen to tavus vahik en. Ka napan varih to kehkeh vasunön ne e Tamön, ee se teꞌ rakah me ne o kikis pa Tuvuh Vasioꞌ, ko vasunön ne poë, pare vavatet ne a soe peꞌ. E Tamön to taum en pa pap teꞌ to teꞌ va ne nën se vasunön ne poë. ");
INSERT INTO tpz_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","E Sosoenën a Tuvuh, ko teꞌ varih to vasunön ne eah, ee se vasunön rakah eah manih po kikis pa Tuvuh Vasioꞌ, suk ataeah, eꞌ e Sosoenën vamaman.” ");
INSERT INTO tpz_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ke köövo soe en pan, “Eöꞌ to nat e noꞌ pa teꞌ vëh na to popokaꞌ no eah e Mesaëaꞌ, eꞌ e Kristo, eꞌ to nö voh maꞌ ne Sosoenën to vanö maꞌ poan. Ka teꞌ pamëh se vavaasis a ra pa ma moeh tah.” ");
INSERT INTO tpz_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ke Ieesuꞌ piun a soe pe köövo ko soe pan, “Eöꞌ akuk kuru ivëh e Kristo, a teꞌ ne Sosoenën to vanö voh maꞌ to vavaato me e noꞌ pën” ");
INSERT INTO tpz_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","A ma vamomhë peꞌ to taneꞌ hah maꞌ vöön, ko toksean rakah ee pö nee to ep in e Ieesuꞌ to vavaato me non e köövo pamëh. Ivëhkëk, ahikta paeh va pee to hi va in e Ieesuꞌ manih pan, “Eën iu nom ataeah?”, keꞌ, “Eën vavaato suk me nom e köövo vëh ataeah?” ");
INSERT INTO tpz_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ivëh, ke köövo pamëh këh en pa nöh isisu ruen peꞌ to pet non pa koveꞌ ruen, pareꞌ vos en vöön ko soe ke ra napan pan, ");
INSERT INTO tpz_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Nö kurus maꞌ öm paröm ep pa teꞌ vëh to vavatët vahik rakah en peöꞌ pa ma tah nöꞌ to nonok voh noꞌ sih. Eꞌ pöꞌ e Kristo a teꞌ vëh ne Sosoenën to soe voh pan eꞌ se vanö maꞌ poan, ha?” ");
INSERT INTO tpz_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ka napan tënan vakomanih, pare këh ee pa vöön pamëh ko nö ee pa ep e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Manih pa poen pamëh no a ma vamomhë peꞌ to soe ke poë pan, “Tövavaasis, ëën voh ah.” ");
INSERT INTO tpz_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ivëhkëk, e Ieesuꞌ to piun rapoë, pareꞌ soe en, “Eöꞌ to teꞌ me e noꞌ pa taëën nöꞌ se ëën, nöm to hikta nat nem.” ");
INSERT INTO tpz_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ivëh, ka ma vamomhë peꞌ vaiihi koman e ne pan, “Eꞌ to teꞌ pöꞌ non ta teꞌ to teꞌ ke vu maꞌ poan ta ma taëën?” ");
INSERT INTO tpz_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ke Ieesuꞌ soe ke raoe pan, “A taëën peöꞌ ivëh pan, eöꞌ se nok voh a kiu pa Teꞌ vëh to vanö voh a maꞌ neoꞌ, keꞌ hik vavih voh. ");
INSERT INTO tpz_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Eöm koman to sosoe nem sih pan, ‘A taanaꞌ sivö to meꞌ avoeꞌ e ne pa tavus maꞌ, ko poen oes a voaꞌ tavus en.’ Eöꞌ to soe vaman rakah keoꞌ peöm pan, kuru a voaꞌ to vamatop ee pa oes, ivëh, köm se iniinan vavih voh manih pa koman a rak. ");
INSERT INTO tpz_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","A ma teꞌ varih to kiu ne pa oes a voaꞌ ee se kon ee po voen pee. Ko voen pa ma teꞌ poë varih, ivaꞌih, ee se rëh o kokoman pa napan, kee kon ee po toꞌtoꞌ tamoaan. Ivëh, ka teꞌ vëh to nep a voaꞌ me a teꞌ vëh to oes, ee pon se vaeö rakah. ");
INSERT INTO tpz_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","A soe vaꞌih a man, ‘A pah teꞌ to nep a rak, ka meh teꞌ ivëh to oes.’ ");
INSERT INTO tpz_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Eöꞌ to vanö a neöm pa oes a voaꞌ varih po tökiu vëh nöm to hikta kiu voh. O upöm teꞌ to vamatop momoaan a ma kupu pa napan, köm suk maꞌ ko vamaaka a napan poë varih a hanan va pa kon o toꞌtoꞌ tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","A nap peo va pa vöön va Samëriaꞌ to tënan a soe pe köövo, pare vaman rakah ee pa soe pe Ieesuꞌ. Suk e köövo to soe ke ra napan a ö ne Ieesuꞌ to vavatët vahik en peꞌ pa ma taateꞌ neꞌ to nonok voh non. ");
INSERT INTO tpz_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","O poen no a napan va Samëriaꞌ to nö maꞌ manih pe Ieesuꞌ, ee to hi poë pan, eꞌ se teꞌ vaꞌpeh me voh raoe pa ma siꞌ poen, ke Ieesuꞌ teꞌ me en pee po pöök poen nën. ");
INSERT INTO tpz_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","A nap peo rakah to pënton a soe pe Ieesuꞌ, pare vaman poë. ");
INSERT INTO tpz_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ee to soe ke köövo pan, “Vamomoaan nemöm to pënton a soe pën, pamöm vaman em pe Ieesuꞌ. Ivëhkëk, varuꞌ vakomanih nemöm to vaman suk emöm koman to pënton em peꞌ. Pamöm nat em peꞌ a teꞌ se kon këh a napan va po oeh vëh pa hat.” ");
INSERT INTO tpz_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","O pöök poen to oah ee, ke Ieesuꞌ këh en pa muhin va Samëriaꞌ, pareꞌ nö en manuh pa muhin va Galiliꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Manih pa koman a muhin va Galiliꞌ ne Ieesuꞌ to soe voh pan, “A teꞌ vanënën soe to nö, ka tavöön koman peꞌ heꞌ tonun ee peꞌ, pare hikta ta ne poë.” ");
INSERT INTO tpz_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","O poen neꞌ to tavus hah manuh pa muhin va Galiliꞌ, ka napan va pa muhin pamëh vaeö suntan rakah ee peꞌ. Ee to vaeö suk ne poë pa ö nee to ep voh a ma tah vatoksean neꞌ to nonok voh non manuh Jerusalëm po poen apuh va po Pasovaꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","E Ieesuꞌ to vos en manuh pa vöön va Kenaꞌ a vöön pamëh to teꞌ non koman a muhin va Galiliꞌ. A vöön pamëh neꞌ to rih voh a ruen keꞌ tavus en o voaën, ka pah teꞌ susun pa teꞌ sunön to teꞌ non pa vöön va Kapaneam ne sunaiꞌeah to haraꞌ suntan a hivaꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","A teꞌ susun pamëh to pënton a soe to soe non pan e Ieesuꞌ to taneꞌ maꞌ pa muhin va Jiutiaꞌ, pareꞌ nönö non maꞌ manih Galiliꞌ. Eꞌ to nö manuh pe Ieesuꞌ, pareꞌ soe ke poan pan, eꞌ se nö maꞌ Kapaneam ko vatoꞌ hah e sunaiꞌeah. Suk ataeah, a siꞌ ö hat keꞌ mët en. ");
INSERT INTO tpz_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ke Ieesuꞌ soe ke poan pan, “Eöm varih se keh hikta ep in ta tah vatoksean me to vëknöm, eöm to hikta onöt nem a vaman.” ");
INSERT INTO tpz_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ka teꞌ susun pa teꞌ sunön soe va in e Ieesuꞌ manih pan, “Sunön, vëvëhöꞌ mah, a siꞌ ö hat ke koaꞌ peöꞌ mët en.” ");
INSERT INTO tpz_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ke Ieesuꞌ soe ke poan pan, “Hah na, e sumuiꞌah se toꞌ hah en.” Ka teꞌ susun pa teꞌ sunön vaman en pa soe pe Ieesuꞌ, pareꞌ hah en manuh pa vöön peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","A teꞌ susun pa teꞌ sunön to teꞌ avoeꞌ e non hanan ka ma pah teꞌ kikiu peꞌ nö maꞌ, pare akeh poë manih hanan, pare soe ke poë pan, “E koaꞌ pën to toꞌ hah en.” ");
INSERT INTO tpz_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ka teꞌ susun pa teꞌ sunön hi a ma teꞌ kikiu peꞌ pan, “A potan teꞌ rakah non nih ke koaꞌ peöꞌ vih hah?” Kee piun ko soe pan, “Nopoen pa 1 kirök no a kamis pasun to hik këh poan.” ");
INSERT INTO tpz_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ke tamaneah nat hah en pa tëëm totoopin rakah pamëh ne Ieesuꞌ to soe ke poan pan, “E sumuiꞌah se toꞌ hah en.” Ivëh, ka teꞌ susun pa teꞌ sunön me ra napan kurus varih to teꞌ ne koman iuun, ee kurus to vaman ee pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ivaꞌih a vapöök tah vatoksean neꞌ to nok manih pa ö neꞌ to këh maꞌ a muhin va Jiutiaꞌ, pareꞌ teꞌ non manih pa muhin va Galiliꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Vasuksuk ne Ieesuꞌ to vatoꞌ vahik en pe koaꞌ pa teꞌ susun pa teꞌ sunön, pareꞌ nö en manuh Jerusalëm. Eꞌ o poen apuh pa napan va Israël ipamëh nee se nö pa hin. ");
INSERT INTO tpz_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Manih pa koman a vöön va Jerusalëm eꞌ to teꞌ non a koveꞌ ruen nee to pokaꞌ ne a Bëtsaëtaꞌ po to va Hibru. A koveꞌ ruen pamëh to teꞌ vatët non po hopaꞌ nee to pokaꞌ ne pan o Hopaꞌ po Sipsip. A tönim këk vös to eok tatavi ne a koveꞌ ruen pamëh. ");
INSERT INTO tpz_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Manih koman a ma këk vös poë varih no a napan to haraꞌ ne a ma vu mët to koroh ne sih. O teꞌ poë varih no a ma moeere to mëtmët, me ro teꞌ kekehoꞌ, me ro teꞌ o tëtënkun. ");
INSERT INTO tpz_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","A pah teꞌ to koroh non koman a këk vös pamëh, to haraꞌ voh non a mët po 38 kirismas. ");
INSERT INTO tpz_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ke Ieesuꞌ ep in a teꞌ pamëh to koroh non, pareꞌ nat en peꞌ to haraꞌ moaan rakah voh en pa mët pamëh. Ivëh, keꞌ hi en peꞌ pan, “Eën iu vih hah nom, ha?” ");
INSERT INTO tpz_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ka teꞌ vëh to haraꞌ tamoaan non sih a mët, piun poan pareꞌ soe pan, “A, Topoan, eöꞌ to iu vih hah e noꞌ. Ivëhkëk, ahikta meh teꞌ se vaꞌaus a neoꞌ köꞌ nö manuh pa koveꞌ ruen pa ö no a ruen se riu. Eöꞌ se kehkeh nö noꞌ ruen, ivëhkëk, o upöm to vovoh këh ee peöꞌ, pare vuꞌ momoaan ee na pa koveꞌ ruen ko toꞌ hah ee.” ");
INSERT INTO tpz_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ke Ieesuꞌ soe ke poꞌ poan pan, “Sun ah, parën kon o pan pën, parën nö eom vöön.” ");
INSERT INTO tpz_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ka varuꞌ rakah vakomanih no a teꞌ pamëh to vih hah en, pareꞌ sun, ko kon o pan peꞌ, ko nö en. O poen pamëh, eꞌ o Poen Apaapo. ");
INSERT INTO tpz_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ivëh, ka nap susunön po Jiuꞌ ep a teꞌ vëh to haraꞌ vöꞌpë voh a mët to vih hah en, pare soe ke poë pan, “O Poen Apaapo pea a napan va Israël ivëh kuru, eꞌ to kök e non pa taateꞌ pea, pa ö nën to teꞌteꞌ nö nom o pan pën.” ");
INSERT INTO tpz_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ka teꞌ vëh to toꞌ hah soe ken pee pan, “Ivëhkëk, a teꞌ vëh to vatoꞌ a neoꞌ to taꞌ en peöꞌ pan eöꞌ se kon o pan peöꞌ paröꞌ nö eoꞌ vöön.” ");
INSERT INTO tpz_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ka napan hi hah ee peꞌ pan, “Eteh rakah ipamëh to taꞌ a oah a kon o pan pën ko nö vöön?” ");
INSERT INTO tpz_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ka teꞌ pamëh to hikta piun raoe suk e Ieesuꞌ to këh en pa ö vëh neꞌ to teꞌ vu non, pareꞌ nö en. Ivëh, ka teꞌ vëh ne Ieesuꞌ to vatoꞌ hah poan to hikta nat non peteh vëh to vatoꞌ hah poan, suk ataeah a napan to parin a peo to teꞌ ne nën. ");
INSERT INTO tpz_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Po vasuksuk ne Ieesuꞌ to taum hah en pa teꞌ pamëh koman a Iuun Hinhin Apuh, pareꞌ soe ke poan pan, “Eën to toꞌ hah voh eom, eën se koe poꞌ a nok vatëh hah a ma taateꞌ hat. Eën tomeꞌ taum amot ta teꞌ hat to apuh oah e non pa teꞌ hat oah e non pa teꞌ hat vaꞌih.” ");
INSERT INTO tpz_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ka teꞌ pamëh këh en pe Ieesuꞌ, pareꞌ nö ko taum en pa nap susunön po Jiuꞌ, pareꞌ soe ke raoe pan, “A teꞌ vëh to vatoꞌ hah voh a neoꞌ, eꞌ e Ieesuꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ivëh, ka nap susunön po Jiuꞌ taneo ee pa nok vavahat e Ieesuꞌ manih pa ma soe pee, suk e Ieesuꞌ to nonok e non pa ma taateꞌ to kök e ne pa taateꞌ va po Poen Apaapo pee. ");
INSERT INTO tpz_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ivëhkëk, e Ieesuꞌ to piun a soe pee, pareꞌ soe pan, “E Tamön to hikta vavanot non sih eꞌ to kikiu va kov e non sih manih. Eöꞌ me to kikiu va kov e noꞌ manih.” ");
INSERT INTO tpz_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","A nap susunön po Jiuꞌ to pënton a soe vaꞌih, pare vaiu vëhvaꞌ rakah këh ee pa ta hanan nee se ip vamët koe e Ieesuꞌ. Suk ataeah, eꞌ to hikta kök varoe a taateꞌ va po Poen Apaapo. Ahik. Eꞌ to soe pet en pan e Sosoenën eꞌ e tamaneah. Ka soe vaꞌih to teꞌ va non manih pan, a tasun peꞌ to vatoe me e non pa teꞌ tasun pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ke Ieesuꞌ sunpip rakah ea pa ma soe varih, pareꞌ soe pan, “Eöꞌ se soe vaman rakah keoꞌ peöm, eöꞌ e Koaꞌ Teꞌ Pe Sosoenën to hikta onöt noꞌ a nok ta kiu po kokoman koman peöꞌ. Ahik, eöꞌ to nonok noꞌ sih a ma kiu ne eöꞌ to ep noꞌ ne Tamaneoꞌ to nonok non sih. A tah ne Taman to nonok non, ne eöꞌ e Koaꞌ to ep suk paröꞌ nok suk. ");
INSERT INTO tpz_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","E Tamön to iu rakah non sih a neoꞌ e Koaꞌ peꞌ, pareꞌ vataare en peöꞌ pa ma tah ne eöꞌ se nonok noꞌ. Ivëh, ke Tamön vataare en peöꞌ pa ma meh kiu to teꞌ apaꞌpuh oah e ne pa ma teꞌ kiu varih ne eöꞌ e Koaꞌ to nonok noꞌ. Ka ma kiu poë varih nöm se ep paröm toksean rakah em. ");
INSERT INTO tpz_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","E Tamön to kunkuin hah non sih a nap mët pareꞌ heꞌ en pee po toꞌtoꞌ. Ka tah pamëh to vatoe akuk va kov e non manih peöꞌ e Koaꞌ to se heꞌ en po toꞌtoꞌ tamoaan manih po teꞌ varih ne eöꞌ to iu noꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","E Tamön to hikta onöt non a vahoꞌ ta pah teꞌ manih po vahutët. Ahik, a ma kiu kurus varih pa pëpënton vahutët, neꞌ to heꞌ vahik voh en peöꞌ e Koaꞌ peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ivëh, ka napan kurus rakah se kë a ëhnaneoꞌ e Koaꞌ pamëh, vamanih pa ö nee to kë va voh in a ëhnan e Tamön. Etereh to hikta kë ne sih a ëhnaneoꞌ e Koaꞌ, ee to hikta kë me ne a ëhnan e Tamön vëh to vanö voh a maꞌ neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Eöꞌ to soe vaman rakah keoꞌ peöm, etereh to tënan a soe peöꞌ, pare vaman e Sosoenën vëh to vanö a maꞌ neoꞌ, köꞌ nö maꞌ, ee se kon ee po toꞌtoꞌ tamoaan. Ka napan poë varih to hikta onöt ne a teꞌ manih po vahutët. Ee to këh ee maꞌ pa mët pare kon ee po toꞌtoꞌ tamoaan. ");
INSERT INTO tpz_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Eöꞌ to soe vaman rakah keoꞌ peöm, kuru no o poen to tavus vahik en, ka napan varih to teꞌ va ne manih pa nap mët, ee se tënan ee pa soe peöꞌ e Koaꞌ pe Sosoenën. Ko teꞌ varih to tënan a soe pamëh pare vatet, ee se kon ee po toꞌtoꞌ tamoaan. ");
INSERT INTO tpz_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","O toꞌtoꞌ tamoaan pamëh to taneꞌ maꞌ manuh pe Tamön, e Tamön koman to heꞌ en peöꞌ e Koaꞌ pa tasun pamëh, ke eöꞌ e Koaꞌ pamëh to teꞌ me e noꞌ po toꞌtoꞌ tamoaan. ");
INSERT INTO tpz_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","E Koaꞌ pamëh, eöꞌ e E Koaꞌ Teꞌ Pa Napan Kurus, ivëh, ke Sosoenën heꞌ en peöꞌ pa tasun marën a kiiki a napan manih po vahutët. ");
INSERT INTO tpz_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Eöm se koe a koman vörep in a soe vaꞌih nöꞌ to sosoe ka noꞌ neöm. O poen se tavus maꞌ no a napan kurus varih to pee ne po vapeepe se tënan a to peöꞌ e Koaꞌ, ");
INSERT INTO tpz_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","pare këh tavus ee maꞌ pa ma vapeepe. Ko teꞌ varih to nonok ne sih a ma taateꞌ vih, ee se kon ee po toꞌtoꞌ tamoaan. Ko teꞌ varih to nonok ne sih a ma taateꞌ hat, ee se sun ee po vahutët, pare nö ee manuh po suraꞌ ësës tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pan “Eöꞌ to hikta onöt noꞌ a nok ta pah tah po kokoman koman peöꞌ peheoꞌ. Ahik, eöꞌ to vavatet noꞌ a soe nöꞌ to kon taneꞌ manuh pe Sosoenën, paröꞌ kiiki noꞌ a ma taateꞌ pa napan. Ka vahoꞌ a napan manih po vahutët, eꞌ a totoopin. E Sosoenën to soe vaonöt ka neoꞌ, köꞌ kiiki no a ma taateꞌ pa napan. Ivëh, ka taateꞌ kiiki peöꞌ to totoopin e non manih po iu pe Sosoenën. Suk ataeah, eöꞌ to hikta suksuk noꞌ o iu koman peöꞌ. Ahik, eöꞌ to suksuk ro noꞌ o iu pe Sosoenën vëh to vanö voh a maꞌ neoꞌ köꞌ nö maꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Eꞌ se keh teꞌ non pan eöꞌ varoe to sosoe tavus noꞌ a ma kiu me a ma taateꞌ nöꞌ to nonok noꞌ, a napan kurus to hikta onöt ne a vaman a ma soe nöꞌ to vavatvus noꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ivëhkëk, eꞌ to teꞌ non a meh teꞌ, ivëh, e Sosoenën to vavatvus non a soe va pa ma kiu me a ma taateꞌ peöꞌ. Köꞌ nat e noꞌ pa ma soe neꞌ to vavatvus non, ee a ma soe a man rakah. ");
INSERT INTO tpz_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","O poen nöm to vanö a ma pah teꞌ, kee nö ee manuh pe Jon, pan eꞌ se soe ke raoe ta soe to soe suk a no neoꞌ e Koaꞌ pe Sosoenën, ka soe pamëh, eꞌ a soe man. ");
INSERT INTO tpz_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ivëhkëk, eöꞌ to hikta koman noꞌ ataeah no a napan to koman suk va ne manih peöꞌ. Ivëh, köꞌ iu noꞌ a ö nöm se koman hah a soe ne Jon to sosoe suk voh non a kiu me a taateꞌ peöꞌ. Eöm se keh öt vakis nem a soe pamëh, e Sosoenën se kon hah en peöm. ");
INSERT INTO tpz_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","E Jon to teꞌ vavoh non manih po ram to tëtëkrea non, pareꞌ heꞌ non a napan o maaka, ka siꞌ poen kökööt akuk rakah nöm to haraꞌ o vaeö, suk o maaka neꞌ to heꞌ a neöm. ");
INSERT INTO tpz_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Oman e Jon to vavatvus non a soe to soe suk a non neoꞌ, eöꞌ eteh. Ivëhkëk, eꞌ to teꞌ non a pah tah to vih oah non a soe pe Jon to vataare non eöꞌ eteh. Eꞌ a kiu pamëh ne Tamön to heꞌ a neoꞌ, söꞌ nok, paröꞌ vahik. Ka ma kiu varih nöꞌ to nonok noꞌ, to vataare vavih rakah e ne pa napan, pa ö ne Tamön to vanö voh a maꞌ neoꞌ, köꞌ nö maꞌ manih po oeh vëh. ");
INSERT INTO tpz_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","38","E Tamön to vanö voh a maꞌ neoꞌ, köꞌ nö maꞌ manih po oeh. Ke eꞌ koman ivëh to soe tavus voh ka neoꞌ manih pa napan. Ivëh, no a soe pe Tamön to hikta teꞌ suk non manih pa ma kokoman peöm. Eöm to hikta iu pënton nem a soe pe Tamön pa ma tenëneöm, paröm hikta iu ep nem a ma kiu nöꞌ to nonok noꞌ pa ma matëëneöm. Suk ataeah, eöm to hikta vaman nem a soe me a kiu peöꞌ a teꞌ vëh ne Tamön to vanö voh maꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Eöm koman kës nem pan, a soe vëh to pet non manih po Puk pe Sosoenën to onöt e non pa heꞌ a neöm o toꞌtoꞌ tamoaan? A ma tamoaan nöm to ëhëh nem a soe to kiun non po Puk pe Sosoenën, paröm kiiki em pa ma soe to kiun ne po komön o Puk pamëh. A ma soe to kiun ne po Puk pamëh to teꞌ suk e ne peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ivëhkëk, eöm to rës e nem pa nö maꞌ manih peöꞌ pa kon o toꞌtoꞌ tamoaan. ");
INSERT INTO tpz_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Eöꞌ to sosoe noꞌ a soe vaꞌih, paröꞌ hikta koman noꞌ a ö no a napan se kë ne a ëhnaneoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ahik, eöꞌ to nat e noꞌ peöm to hikta teꞌ me nem o iu pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Eöꞌ to taneꞌ voh maꞌ manuh pe Tamön, paröꞌ vavatvus noꞌ a soe manih peöm, köm hikta kokon ro nem a soe peöꞌ. Ivëhkëk, ta pah teꞌ se keh nö maꞌ pa ëhnan komaneah, eöm se tënan em pa soe peꞌ, paröm vaman em peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","A pap teꞌ to teꞌ va ne manih peöm to hikta onöt ne a vaman a neoꞌ. Ahik rakah! Suk ataeah, eöm to koman varoe nem a kon o ëhnan apuh manih pa topnineöm. Ivëh, nöm to hikta iu kon suk nem o ëhnan apuh vëh ne Sosoenën a paeh ro to heꞌheꞌ non sih. ");
INSERT INTO tpz_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Eöm se nat nem koman nem pan, eöꞌ ivëh se sun manih pa matan e Tamön, paröꞌ kiiki a ma taateꞌ peöm, paröꞌ soe pan eöm o hat. Ahik, a teꞌ vëh se soe pan eöm o teꞌ hat ivëh e Mosës. Ke eꞌ a teꞌ pamëh nöm to koman voh nem pan eꞌ se vaꞌaus a neöm. ");
INSERT INTO tpz_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Eöm se keh vaman rakah nem a ma soe pe Mosës, a, eöm to vaman me e nem pa teꞌ soe peöꞌ. Suk ataeah, e Mosës ivëh to kiun suk voh a neoꞌ manih po Puk pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ivëhkëk, eöꞌ to nat eoꞌ peöm to hikta onöt rakah nem a vaman a ma soe pe Mosës, keꞌ ep va e non manih peöm to hikta onöt me nem a vaman a ma teꞌ soe peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","E Ieesuꞌ to vaato vahik me en pa napan, pareꞌ pahan en pa tonon va Galiliꞌ. A tonon pamëh no a napan to pokaꞌ ne sih a meh ëhnaneah pan, a Taëberius. ");
INSERT INTO tpz_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","A nap peo rakah to vatet e Ieesuꞌ, suk ataeah, ee to ep in a ma tah vatoksean neꞌ to nonok non pa vavatoꞌ hah o teꞌ varih to haraꞌ ne a ma vu mët. ");
INSERT INTO tpz_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","E Ieesuꞌ to ëp en pa siꞌ ö tope, ko ihoꞌ vaꞌpeh me e non pa ma vamomhë peꞌ nën. ");
INSERT INTO tpz_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ka siꞌ ö hat ka Taëën Apuh po Jiuꞌ nee to pokaꞌ ne o Pasovaꞌ tavus en. ");
INSERT INTO tpz_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ke Ieesuꞌ vatatarih vah ko non, pareꞌ ep in a nap peo rakah to nö maꞌ manih peꞌ, pareꞌ hi en pe Filip pan, “Ea se voen maꞌ ta ma taëën nih, para makën a napan varih?” ");
INSERT INTO tpz_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","E Ieesuꞌ to sosoe va non manih, suk eꞌ to pupunöꞌ non o vaman pe Filip. Suk ataeah, eꞌ koman to nat e non pataeah neꞌ se heꞌ a napan kee ëën. ");
INSERT INTO tpz_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ke Filip piun a hi pe Ieesuꞌ, pareꞌ soe ke poan pan, “Ea se keh voen a taëën pa moniꞌ to antoen non o 200 voaꞌ moniꞌ, a taëën pamëh hikta se antoen non a vamahun a napan varih. Suk ataeah, a napan to parin a peo vörep. Ee se kës kon ro ta ma siꞌ pah ö.” ");
INSERT INTO tpz_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ivëhkëk, a paeh a vamomhë koman pe Ieesuꞌ, ivëh e Ëndruꞌ, e kea pe Saëmon Pitaꞌ to soe ke Ieesuꞌ pan, ");
INSERT INTO tpz_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Eꞌ to teꞌ non a pah koaꞌ to teꞌ non manih to teꞌ me non o tönim muꞌ me a poa iian. Ivëhkëk, a napan to teꞌ ne manih to parin a peo. A ma siꞌ iian varih me ro tönim muꞌ varih se poꞌ vaꞌaus vah va in a nap peo varih nih?” ");
INSERT INTO tpz_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ke Ieesuꞌ soe ke ra ma vamomhë peꞌ pan, “Soe ke ra napan, kee ihoꞌ.” A ö no a napan se ihoꞌ to parin a kakaras vörep. Ka napan to peo onöt ne a 5,000 teꞌ oeteꞌ to teꞌ ne nën, ee to hikta ëh vaꞌpeh o köövo me ro koaꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ke Ieesuꞌ kon a ma muꞌ, pareꞌ soe vavihvih ke na e Sosoenën, ko heꞌ a ma vamomhë peꞌ, kee ki vakëkëh ke pa napan to ihoꞌ ne nën. E Ieesuꞌ to nok pet va en nën manih pa poa iian. A napan kurus to ëën a ma muꞌ me ra ma iian ko mahun rakah ee. ");
INSERT INTO tpz_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","A napan to ëën ko mahun vahik ee, ke Ieesuꞌ soe ke ra ma vamomhë peꞌ pan, “Ununun öm a ma ö taëën varih no a napan to ëën këh, ee tomeꞌ hat akuk.” ");
INSERT INTO tpz_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ivëh, ka ma vamomhë peꞌ ununun ee maꞌ pa ma ö taëën no a napan to mahun këh. Pare vapuh hah o havun kove me ro pöök pa ma ö taëën no a napan to mahun këh. ");
INSERT INTO tpz_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","A napan to ep in a tah vatoksean ne Ieesuꞌ to nok, pare taneo ee pa soe pan, “O pöh man rakah, a teꞌ pöꞌ kovëh, eꞌ a teꞌ vanënën soe ne Sosoenën to soe voh pan, eꞌ se vanö maꞌ manih po oeh vëh.” ");
INSERT INTO tpz_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","E Ieesuꞌ to nat en pa napan to nok ee po kokoman va pa ö nee se öt poë ko vateꞌteꞌ poë, keꞌ tavus en a teꞌ Sunön pee. Ivëh, keꞌ këh en pa ö neꞌ to teꞌteꞌ non, pareꞌ ëp en tope pehen. ");
INSERT INTO tpz_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pa matanpoen po poen avoeꞌ pamëh no a ma vamomhë peꞌ to nö, pare anoeh e ne maꞌ peꞌ manuh sinten a tonon. ");
INSERT INTO tpz_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","A muhin to poen en e Ieesuꞌ he meꞌ avoeꞌ e non pa tavus maꞌ manih pa ma vamomhë peꞌ. O vamomhë to peah ee po paröꞌ, pare pahan ee pa tonon va Galiliꞌ. Ee to kehkeh nö ne Kapaneam. ");
INSERT INTO tpz_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","A tonon to sup, suk a tuvuh to pah ip suntan rakah en maꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ee to hoaꞌ o paröꞌ, ko teꞌ varo va e ne maꞌ manuh pa tönim, keꞌ, a tönim me a paeh kiromitaꞌ, pare ep na e Ieesuꞌ to tet maꞌ a tonon. Ee to ep na poë to tet maꞌ a tonon, pare pah naöp suntan rakah ee. ");
INSERT INTO tpz_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ivëhkëk, e Ieesuꞌ to soe ken pee pan, “Koe öm a naöp, eöꞌ akuk kuru.” ");
INSERT INTO tpz_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kee pah vaeö suntan poꞌ ee pa ep poë manih po paröꞌ. Ka varuꞌ vakomanih no paröꞌ to tavus en pa ö nee to nönö ne. ");
INSERT INTO tpz_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","A muhin to takah en po meoh poen a napan he sun avoeꞌ e ne sinten tonon va Galiliꞌ. Ee to nat e ne pan, nopoen no pöh paröꞌ ro to teꞌ non nën. E Ieesuꞌ to hikta tok vaꞌpeh me ra ma vamomhë peꞌ po paröꞌ pamëh. A ma vamomhë varoe to tok po paröꞌ, pare pahan ee pa tonon. ");
INSERT INTO tpz_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ivëhkëk, a ma paröꞌ to taneꞌ maꞌ pa vöön va Taëberius to koe vatët ke maꞌ manih pa ö muhin vëh ne Ieesuꞌ to makën voh a napan pa taëën neꞌ to soe vavihvih ke voh na e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ivëh, ka napan ep vahik ee pe Ieesuꞌ me ra ma vamomhë peꞌ to hikta teꞌ ne nën. Ee to tok ee pa ma paröꞌ poë varih, pare vatet pahan ee pee manuh pa pap tonon vöh, ko vos ee pa vöön nee to pokaꞌ ne a Kapaneam, pan ee se ep in e Ieesuꞌ nën me ra ma vamomhë peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","A napan to taum poë manuh pa pap tonon vöh, pare hi poë pan, “Tövavaasis, eën nö vah va maꞌ nih, parën tavus maꞌ manih?” ");
INSERT INTO tpz_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “Eöꞌ to soe vaman rakah keoꞌ peöm, eöm to hikta vaiu a maꞌ neoꞌ, suk a ma tah vatoksean varih nöꞌ to nok voh. Ahik, eöm to vaiu a maꞌ neoꞌ, suk eöm to ëën voh a taëën nöꞌ to heꞌ a neöm, köm ëën ko mahun. ");
INSERT INTO tpz_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Eöm se nat nem kikiu suk varoe nem a taëën vëh se koa en, pareꞌ hikta onöt non a heꞌ a neöm o toꞌtoꞌ tamoaan. Ahik, eöm se kiu suk varoe o vu taëën vëh se heꞌ o toꞌtoꞌ tamoaan manih pa napan. Keꞌ o vu taëën pamëh ne eöꞌ e Koaꞌ Teꞌ Pa Napan Kurus se heꞌ a neöm. Ke Tamön vëh, e Sosoenën, to heꞌ voh en peöꞌ pa tasun va pa nok va nën.” ");
INSERT INTO tpz_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ka napan hi poꞌ ee pe Ieesuꞌ pan, “Ataeah poꞌ to vih non na se nok, para nok a kiu ne Sosoenën to iu non?” ");
INSERT INTO tpz_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ke Ieesuꞌ piun, pareꞌ soe pan, “Ivaꞌih a kiu ne Sosoenën to iu non a ö nöm se nok, eöm se vaman a neoꞌ a teꞌ ne Sosoenën to vanö voh maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kee hi hah ee pe Ieesuꞌ pan, “O vu vëknöm taeah nën se nok to vataare a no möm, kemöm vaman poꞌ a ma tah nën to nonok nom? ");
INSERT INTO tpz_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","A kën sipuura to ëën voh o manaꞌ manih pa moeh upin vamanih pa ö no o Puk pe Sosoenën to soe va non, ‘Eꞌ to heꞌ voh a napan a taëën va pa vöön va kin, kee ëën ee.’” ");
INSERT INTO tpz_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ivëhkëk, e Ieesuꞌ to soe ke raoe pan, “Eöꞌ to soe vaman rakah keoꞌ peöm, eꞌ to hikta teꞌ non pan e Mosës ivëh to heꞌ voh a napan pa taëën va pa vöön va kin. Ahik, E Tamön vöh pa vöön va kin to heꞌ voh a neöm a taëën pamëh. Eꞌ se heꞌheꞌ avoeꞌ e non peöm pa taëën man. ");
INSERT INTO tpz_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","A taëën man pe Sosoenën ivëh, a teꞌ vëh to kunah taneꞌ voh maꞌ manuh pa vöön va kin, pareꞌ heꞌ o toꞌtoꞌ peꞌ manih po oeh vëh.” ");
INSERT INTO tpz_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Kee piun a soe pe Ieesuꞌ, pare soe pan, “Topoan, taneo non kuru nën se heꞌheꞌ tamoaan va kov e nom pemöm manih pa taëën pamëh.” ");
INSERT INTO tpz_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ke Ieesuꞌ piun raoe pareꞌ soe pan, “Eöꞌ koman a taëën va po toꞌtoꞌ tamoaan. Eteh se keh nö maꞌ peöꞌ, ko vaman a non neoꞌ, pareꞌ vavatet rakah non a soe peöꞌ, eꞌ se kon en po toꞌtoꞌ tamoaan, pareꞌ hikta se haraꞌ hah non o maë me o manoe. ");
INSERT INTO tpz_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Eöꞌ to soe moaan ke voh eoꞌ peöm, eöm to ep voh em peöꞌ a taëën to taneꞌ maꞌ pa vöön va kin, ivëhkëk, eöm to hikta iu vaman a nem neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","A napan kurus rakah varih ne Tamön to heꞌ vahik voh en pee peöꞌ, kee nö ee maꞌ manih peöꞌ. A teꞌ to nö maꞌ peöꞌ, eöꞌ to hikta antoen noꞌ a veo eah. Ahik, eöꞌ se öt eoꞌ peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Suk ataeah, eöꞌ to taneꞌ voh maꞌ manuh pa vöön va kin, paröꞌ hikta onöt noꞌ a suk o iu koman peöꞌ. Eöꞌ to taneꞌ voh maꞌ pa vöön va kin marën a suk o iu pa teꞌ vëh to vanö voh a maꞌ neoꞌ köꞌ nö maꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ko iu pa teꞌ vëh to vanö a maꞌ neoꞌ, köꞌ kunah taneꞌ maꞌ pa vöön va kin to teꞌ va non manih, eöꞌ to hikta se varakah noꞌ ta pah teꞌ va pa napan varih neꞌ to heꞌ voh a neoꞌ. Eöꞌ se kunkuin eoꞌ pee po poen no oeh se hik. Ee se sun kurus ee po vahutët pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ko iu pe Tamön to teꞌ va non manih, a napan varih to ep voh ee peöꞌ e Koaꞌ peꞌ, pare vaman a soe peöꞌ, ee to kon ee po toꞌtoꞌ tamoaan. Ko poen no oeh se hik, eöꞌ se kunkuin hah eoꞌ pee, kee toꞌtoꞌ hah ee.” ");
INSERT INTO tpz_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","O Jiuꞌ to pënton e Ieesuꞌ to soe pan eꞌ a taëën va pa vööv va kin to kunah maꞌ manih po oeh, pare heve ov ee peꞌ ko vaato me ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Pare soe ee pan, “A teꞌ vaꞌih e Ieesuꞌ e koaꞌ pe Jeosëp, ke ea varih to nat vavih rakah e no pe tamaneah pen sinaneah. Vahvapoꞌnih keꞌ soe pan eꞌ to taneꞌ maꞌ pa vöön va kin?” ");
INSERT INTO tpz_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ke Ieesuꞌ piun a soe pee, pareꞌ soe pan, “Suk öm a soe peöꞌ, paröm koe a vakihkiuh me a neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","E Tamön a paeh ro to vanö voh a maꞌ neoꞌ köꞌ nö maꞌ. Ka hikta pah teꞌ to onöt non a nö maꞌ manih peöꞌ po kokoman koman peꞌ. Ahik, e Tamön se heꞌ eah o kokoman, pareꞌ me maꞌ eah manih peöꞌ. Ko poen no oeh se hik, eöꞌ se kunkuin taneꞌ hah eoꞌ peꞌ po vapeepe, keꞌ kon en po toꞌtoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","A soe to kiun non manih po Vavaasis po Teꞌ Vanënën Soe to teꞌ va non manih pan, ‘E Sosoenën se vavaasis a napan kurus’, kee pënton a soe peꞌ, pare nat in poë, pare nö poꞌ maꞌ manih peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","A hikta pah teꞌ to ep voh non pe Tamön, a teꞌ varoe kovëh to teꞌ me voh non poan to nö voh en maꞌ, eꞌ varoe kuru to nat non poan. A teꞌ pamëh ivëh, eöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Eöꞌ to soe vaman rakah keoꞌ peöm, eteh to teꞌ me non o vaman, pareꞌ vaman a no neoꞌ, eꞌ to kon en po toꞌtoꞌ tamoaan. ");
INSERT INTO tpz_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Eöꞌ koman rakah a taëën va po toꞌtoꞌ tamoaan. ");
INSERT INTO tpz_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","A kën sipuineöm to ëën voh o manaꞌ manuh pa moeh upin, ivëhkëk, ee to mëtmët voh ee. ");
INSERT INTO tpz_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ivëh ka taëën vëh to kunah taneꞌ voh maꞌ pa vöön va kin, etereh to ëën a taëën pamëh, ee to hikta antoen ne a mët. ");
INSERT INTO tpz_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Eöꞌ a taëën va po toꞌtoꞌ tamoaan to kunah taneꞌ voh maꞌ pa vöön va kin. Etereh to ëën a taëën pamëh ee to hikta onöt ne a mët, ee se kon ee po toꞌtoꞌ tamoaan. Ka taëën pamëh eꞌ a sionineoꞌ nöꞌ se heꞌ a napan kurus va po oeh vëh, kee kon taneꞌ o toꞌtoꞌ tamoaan manih peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ko Jiuꞌ pënton a soe vaꞌih, pare taneo ee pa vaato vasukaꞌ me e Ieesuꞌ, pare to soe ee pan, “Vahvanih ka teꞌ vëh se makën a ra pa sionineah?” ");
INSERT INTO tpz_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “Eöꞌ to soe vaman rakah keoꞌ peöm, eöm se keh hikta ëën a sionineoꞌ e Koaꞌ Te Pa Napan Kurus, me eöm se keh hikta kaak o eraꞌ peöꞌ, eöm hikta onöt nem a kon o toꞌtoꞌ vamaman. ");
INSERT INTO tpz_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","O teꞌ varih to ëën a sionineoꞌ, pare kaak o eraꞌ peöꞌ ee to kon ee po toꞌtoꞌ tamoaan. Ko poen no oeh vëh se hik, eöꞌ se kunkuin hah eoꞌ pee, kee kon hah ee pa ma toꞌtoꞌ pee. ");
INSERT INTO tpz_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","A sionineoꞌ eꞌ a taëën vamaman, ko eraꞌ peöꞌ eꞌ o kaak vamaman. ");
INSERT INTO tpz_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ko teꞌ varih to ëën a sionineoꞌ, ko kaak o eraꞌ peöꞌ, ee to teꞌ e ne manih peöꞌ, köꞌ teꞌ e noꞌ manih pee. ");
INSERT INTO tpz_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","E Tamön toꞌtoꞌ tamoaan vëh e Sosoenën, to vanö voh a maꞌ neoꞌ köꞌ teꞌ me noꞌ o toꞌtoꞌ tamoaan manih po kikis peꞌ. Ivëh, keteh to ëën a sionineoꞌ, eꞌ se kon en po toꞌtoꞌ tamoaan manih po kikis peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Eöꞌ to hikta teꞌ va noꞌ manih, pa taëën vëh no a kën sipuineöm to ënëën voh ne pa moeh upin. Ee to ëën voh a taëën pamëh, ivëhkëk, ee to mëtmët ee. Ke eöꞌ vaꞌih, eöꞌ a taëën to kunah taneꞌ maꞌ manuh pa vöön va kin. Ketereh to ëën a taëën pamëh ee se kon ee po toꞌtoꞌ tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Manih pa koman a vöön va Kapaneam ne Ieesuꞌ to teꞌ non nën, pareꞌ vavaasis non a napan pa ma soe poë varih pa koman a iuun hinhin soneꞌ po Jiuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","O vamomhë peo to pënton a soe pe Ieesuꞌ ka ma upöm soe va ee manih pan, “O vavaasis vaꞌih to parin a hivaꞌ. Eteh to onöt non a pënton a soe vaꞌih, ko nat vamaaka a pusuneah, pareꞌ vatet?” ");
INSERT INTO tpz_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ivëhkëk, e Ieesuꞌ to nat en pa ma vamomhë peꞌ to vaiihi suk e ne pa soe peꞌ. Ivëh neꞌ to soe suk ke raoe pan, “O vavaasis vëh miröꞌ kës e non pa ma vaman peöm? ");
INSERT INTO tpz_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Eꞌ se poꞌ teꞌ vah va non nih pa ö nöm se ep a neoꞌ e Koaꞌ Teꞌ Pa Napan Kurus se peah hah manuh pa vöön neꞌ to taneꞌ voh maꞌ? ");
INSERT INTO tpz_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","A Tuvuh Vasioꞌ ivëh to heꞌheꞌ non sih a napan o toꞌtoꞌ tamoaan. Ko sionin hikta onöt non a heꞌ o toꞌtoꞌ tamoaan manih pa teꞌ. Manih pa soe nöꞌ to vavaasis a noꞌ neöm, a Tuvuh Vasioꞌ koman to vakikis non o vavaasis peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ivëhkëk, a ma papaeh teꞌ to teꞌ nö ne manih peöm, ee to hikta vaman a ne neoꞌ.” Manih po poen ne Ieesuꞌ to taneo en pa vavaasis a napan, eꞌ to nat voh en pe retereh ivarih to hikta vaman ne poë, me a teꞌ vëh se vikuh in poan manih po teꞌ varih to hat ov e ne poë. ");
INSERT INTO tpz_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ivëh, ne Ieesuꞌ to soe suk va i raoe manih pan “Ivaꞌih a tah nöꞌ to koman voh noꞌ, paröꞌ soe pan, ‘Ahikta pah teꞌ to antoen non a nö maꞌ manih peöꞌ, pa ö ne Tamön se keh hikta vanö maꞌ poan, keꞌ nö maꞌ peöꞌ.’” ");
INSERT INTO tpz_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","E Ieesuꞌ to sosoe va ko non manih, ko upöm vamomhë peo peꞌ nö vakëkëh këh ee peꞌ, pare hikta teꞌ vaꞌpeh hah me ne poë. ");
INSERT INTO tpz_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","E Ieesuꞌ to hi en pa havun me ra poa vamomhë peꞌ pan, “Eöm me kuru to kehkeh këh e nem peöꞌ oh?” ");
INSERT INTO tpz_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ke Saëmon Pitaꞌ piun a soe peꞌ, pareꞌ soe pan, “Topoan, emöm se keh këh a oah pamöm nö ko teꞌ vaꞌpeh me poꞌ nem eteh? Emöm to hikta iu këh a nom oah, suk ataeah, a soe varoe ko pën ivëh to heꞌ a no möm o toꞌtoꞌ tamoaan. ");
INSERT INTO tpz_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Emöm to vaman e nem pën, pamöm nat e nem pën a Teꞌ a Vivihan to taneꞌ voh maꞌ manuh pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ke Ieesuꞌ piun a havun me ra poa vamomhë peꞌ, pareꞌ soe ke raoe pan, “Eöꞌ to kon voh eoꞌ peöm a havun me ra poa vamomhë peöꞌ, vahvapoꞌnih ka paeh va peöm tavus en a oraꞌ hat?” ");
INSERT INTO tpz_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","E Ieesuꞌ to sosoe non a soe vaꞌih suk e sunaiꞌ e Saëmon va Iskariot vëh e Jiutas. E Jiutas eꞌ a paeh va pa havun me ra poa vamomhë peꞌ. Amot neꞌ se vikuh en pe Ieesuꞌ manih pa koreera napan varih to hat ov e ne poë, kee ip vamët ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","E Ieesuꞌ to vaasis vahik en pa napan pa soe va po toꞌtoꞌ tamoaan, pareꞌ vavatvi vah kov e non pa muhin va Galiliꞌ. Eꞌ to hikta koman non a nö manuh pa muhin va Jiutiaꞌ. Suk ataeah, a ma pah teꞌ susunön po Jiuꞌ to kehkeh ip vamët ne poë. ");
INSERT INTO tpz_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","A ma poen vivihan po Jiuꞌ to vatët ee. ");
INSERT INTO tpz_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ivëh, ka ma kea pe Ieesuꞌ soe ke poë pan, “Vahvanih kën hikta këh a muhin vaꞌih parën nö manuh pa muhin va Jiutiaꞌ ko nok ta ma tah vatoksean nën, ka ma vamomhë pën me ra napan ep? ");
INSERT INTO tpz_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ta pah teꞌ se keh iu non, pan a napan se nat vavih poë, eꞌ se nat non nonok vakoaan non a ma kiu peꞌ. Eën se keh iu nok rakah nom a ma kiu poë varih, eën se sun vateeraꞌ rakah manih pa matëëra napan kurus.” ");
INSERT INTO tpz_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","A kën kea koman peꞌ to hikta vaman ne poë, ivëh, nee to soe suk vamanih. ");
INSERT INTO tpz_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ke Ieesuꞌ piun a ma soe pee pareꞌ soe ke ra poë pan, “O poen nöꞌ se nö manuh Jerusalëm to hikta öök avoeꞌ non maꞌ. Ivëhkëk, a ma poen kurus peöm pa nö nën to tavus vahik voh ee. ");
INSERT INTO tpz_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","A napan va po oeh vëh to hikta onöt ne a rës a neöm. Ivëhkëk, ee to rës e ne peöꞌ, suk eöꞌ to sosoe tavus noꞌ a ma taateꞌ hat nee to nonok ne sih. ");
INSERT INTO tpz_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ivëh, köm se nö ko tönun vaꞌpeh me a ma upöm peöm manuh Jerusalëm pa ma poen vivihan po Jiuꞌ. Ivëhkëk, o poen nöꞌ se nö Jerusalëm pa vakum me a napan pa ma poen vivihan poë varih to hikta öök avoeꞌ non maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","E Ieesuꞌ to soe vakomanih, pareꞌ teꞌ e non manih pa muhin va Galiliꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","O poen no a ma kën kea peꞌ to nö vahik ee manuh Jerusalëm pa ma poen vivihan poë varih, ke Ieesuꞌ me to nö en. Ivëhkëk, eꞌ to nö aven en pareꞌ hikta iu non a ö no a napan se inan poë. ");
INSERT INTO tpz_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Manih pa ma poen vivihan poë varih no a nap susunön po Jiuꞌ to vavaiu vah kov e ne peꞌ, ko vaiihi vah kov e ne pan, “A teꞌ vëh e Ieesuꞌ teꞌ non nih?” ");
INSERT INTO tpz_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Manih pa topniira nap peo poë varih, ee to vavisvis ke ne pa ma upöm pee, suk e Ieesuꞌ. A ma upöm pee to sosoe ne pan, “Eꞌ a teꞌ no a taateꞌ peꞌ to parin a vih.” Ko upöm soe ee pan, “Eꞌ a teꞌ pikpiuk to pikpiuk non sih a napan.” ");
INSERT INTO tpz_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ivëhkëk, a hikta paeh va pa napan poë varih to sun pa matëëra napan, pareꞌ soe tavus o kokoman peꞌ manih pa napan. Suk ataeah, ee to nanaöp e ne po teꞌ susunön po Jiuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Po topnin rakah in a ma poen vivihan po Jiuꞌ, ne Ieesuꞌ to ho en koman Iuun Hinhin Apuh, pareꞌ taneo en pa vavaasis a napan. ");
INSERT INTO tpz_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ko teꞌ susunön po Jiuꞌ pënton o vavaasis peꞌ, pare vatötöhkak rakah ee, pare soe ee pan, “A teꞌ vëh kon taneꞌ maꞌ o nat vëh nih, eꞌ hikta nö voh pa ta siku?” ");
INSERT INTO tpz_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “O vavaasis vaꞌih nöꞌ to vavaasis a noꞌ neöm, eꞌ to hikta teꞌ non pan o vavaasis koman peöꞌ. Ahik, o vavaasis vaꞌih nöꞌ to vavaasis noꞌ, eꞌ o vavaasis pe Sosoenën a teꞌ vëh to vanö voh a maꞌ neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ta pah teꞌ se keh vavatet rakah non a soe pe Sosoenën, eꞌ se maaka rakah va non manih pan, o vavaasis nöꞌ to vavaasis noꞌ, eꞌ o vavaasis pamëh to taneꞌ rakah maꞌ manuh pe Sosoenën, pareꞌ hikta taneꞌ maꞌ manih peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ka teꞌ vëh to vavaasis non a napan po kokoman koman peꞌ, a, a teꞌ pamëh to iu kë koman hah non a ëhnaneah. Ivëhkëk, a teꞌ vëh to vavaasis non a napan, pareꞌ kë non a ëhnan a teꞌ vëh to vanö voh maꞌ poan, a, a teꞌ pamëh eꞌ a teꞌ no a taateꞌ peꞌ to totoopin, me eꞌ a hikta pikpiuk. ");
INSERT INTO tpz_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moaan voh ne Mosës to heꞌ voh en peöm po Vavaasis peꞌ, ivëhkëk, eöm to hikta iu nem a vatet o Vavaasis pamëh. Vahvapoꞌnih köm kehkeh ip vamët e nem peöꞌ? ");
INSERT INTO tpz_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ka napan to teꞌ vatët ne peꞌ piun poë, pare soe pan, “A oraꞌ hat to teꞌ non pën, emöm to hikta kehkeh ip vamët a nom oah.” ");
INSERT INTO tpz_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ke Ieesuꞌ vavaato avoeꞌ me e non po teꞌ susunön po Jiuꞌ, pareꞌ soe ke ra poë pan, “Eöm kurus varih to ep voh em pa tah vatoksean nöꞌ to nok voh manih pa koveꞌ ruen va Bëtsaëtaꞌ, paröm töhkak ko haraꞌ vahat rakah em, suk eöꞌ to vatoꞌ a teꞌ manih pa koman o Poen Apaapo pea. ");
INSERT INTO tpz_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","E Mosës to heꞌ voh en peöm po vavaasis va pa pe a ö kokoaan pa ma pus koaꞌ oeteꞌ peöm. Eꞌ to hikta teꞌ non pan e Mosës ivëh to heꞌ voh o vavaasis pamëh. Ahik, o vavaasis pamëh to taneꞌ voh en maꞌ manuh pa kën sipun. Ivëhkëk, komön o Poen Apaapo nöm to peepe e nem pa ma ö kokoaan pa ma pus koaꞌ oeteꞌ peöm, ivëh, köm kök em po Vavaasis pe Mosës. ");
INSERT INTO tpz_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Eöm to kehkeh vatet vavih rakah nem sih o Vavaasis pe Mosës. O Vavaasis pe Mosës to soe non pan, eöm se pe em pa ma ö kokoaan pa ma pus koaꞌ oeteꞌ peöm. Ivëh, ko poen va pa pe raoe se keh tavus maꞌ po Poen Apaapo, eöm se nok em. Eöm heheve suk poꞌ nem ataeah pa ö nöꞌ se vatoꞌ hah ta pah teꞌ po Poen Apaapo pea? ");
INSERT INTO tpz_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Eöm se koe a kiiki a ma moeh tah po matan varoe, paröm kokoman vavih voh, ko kiiki poꞌ a ma moeh tah nöꞌ to nonok noꞌ manih pa taateꞌ totoopin.” ");
INSERT INTO tpz_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","A napan to teꞌ ne manih Jerusalëm to pënton e Ieesuꞌ to vavaato va non manih, pare vaiihi e ne pan, “A teꞌ ko vëh no o teꞌ susunön pea to kehkeh ip vamët ne, ha? ");
INSERT INTO tpz_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ep këk öm, eꞌ to vavaato rakah e non pa matëëra napan. Ka hikta pah teꞌ sunön to onöt non a soe ta pah soe manih peꞌ. A nap susunön pea to nat pöꞌ e ne peꞌ e Kristo? ");
INSERT INTO tpz_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ivëhkëk, ea to nat e no pa vöön peꞌ, ko poen ne Kristo vamaman se keh nö maꞌ, ka hikta pah teꞌ to onöt non a nat in a vöön peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","E Ieesuꞌ to vavaasis non a napan koman a Iuun Hinhin Apuh, pareꞌ soe ke raoe pan, “Oman, eöm to nat e nem peöꞌ, paröm koman nem pan eöm to nat e nem pa vöön nöꞌ to taneꞌ maꞌ, ivëhkëk, eöm to hikta nat nem. Eöꞌ to hikta nö voh maꞌ manih po kikis koman peöꞌ. Ahik, e Tamön vöh to vanö voh a maꞌ neoꞌ no a taateꞌ peꞌ a man rakah, neöm to hikta nat nem peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Eöꞌ to nat e noꞌ peꞌ, suk eöꞌ to taneꞌ maꞌ manuh peꞌ, ke eꞌ koman ivëh to vanö voh a maꞌ neoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","E Ieesuꞌ to soe vakomanih ka ma upöm teꞌ to teꞌ vatët ne peꞌ, kehkeh öt e ne peꞌ, marën a vahoꞌ poë pa nohnoh. Ivëhkëk, a hikta paeh va pee to onöt non a vaket eah. Suk ataeah, o poen neꞌ se taum a punis me eꞌ se haraꞌ o kamis to meꞌ e non pa tavus maꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ko teꞌ varih to vaman voh e Ieesuꞌ to vavaasoe e ne, pare soe pan, “O poen ne Kristo se nö maꞌ eꞌ se kës nok en ta ma tah vatoksean to apuh oah e ne pa ma teꞌ tah vatoksean no a teꞌ vëh to nonok non?” ");
INSERT INTO tpz_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","A ma meh Parësiꞌ to tënan a soe no a napan to vavisvis suk ne a ma tah ne Ieesuꞌ to nonok non. Ivëh, ko teꞌ susunön ësës heꞌ, me ro Parësiꞌ vanö ee maꞌ pa ma to pirisman koman pee to ut ne sih pa Iuun Hinhin Apuh, kee nö ee maꞌ to öt e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ke Ieesuꞌ soe ke ra napan pan, “Eöꞌ hikta se teꞌ varë me a noꞌ neöm manih po oeh vëh. Suk ataeah, eöꞌ se nö hah eoꞌ manuh pe Tamön. E Tamön vëh to vanö voh a maꞌ neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ke eöm se iu ep e nem peöꞌ, ivëhkëk, eöm to hikta onöt nem a taum a neoꞌ. Paröm hikta onöt me nem a vos pa vöön nöꞌ se teꞌ noꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ka nap susunön po Jiuꞌ vaiihi koman e ne pan, “A teꞌ vëh se nö nih, ka hikta onöt no a taum eah? Eꞌ se kës nö manuh pa ma vöön apaꞌpuh varuh Grik no o upöm pea to teꞌ ne, pareꞌ vavaasis a napan varih to hikta teꞌ ne pan ee ro Jiuꞌ, ha? ");
INSERT INTO tpz_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ataeah neꞌ to koman non, pareꞌ soe suk vamanih pan, ‘Eöm se iu ep e nem peöꞌ, ivëhkëk, eöm hikta onöt nem a taum a neoꞌ paröm hikta onöt me nem a nö pa vöön nöꞌ se teꞌ noꞌ.’” ");
INSERT INTO tpz_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","O poen apuh vëh to vahik non a ma poen vivihan po Jiuꞌ to tavus en, ke Ieesuꞌ sun ko vavaoe suntan rakah en, pareꞌ soe pan, “Koe o teꞌ varih to haraꞌ ne o manoe kee nö maꞌ manih peöꞌ, köꞌ heꞌ raoe a ruen kee kaak. ");
INSERT INTO tpz_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","O Puk Vapenpen pe Sosoenën to soe ka rora pan, ‘Etereh to vaman ne a ma soe peöꞌ, a ruen va po toꞌtoꞌ tamoaan se nönö va kov e non maꞌ manih pa ma kupu pee.’” ");
INSERT INTO tpz_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","E Ieesuꞌ to sosoe suk voh non a Tuvuh Vasioꞌ, pareꞌ soe pan, a Tuvuh Vasioꞌ to hikta nö avoeꞌ voh non maꞌ, suk ataeah, e Ieesuꞌ to hikta mët avoeꞌ non to kon o ëhnan apuh. Ivëhkëk, amot no teꞌ varih to vaman ne e Ieesuꞌ, ee se kon ee pa Tuvuh Vasioꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","A napan to tënan a ma soe pe Ieesuꞌ, ka ma papaeh pee soe ee pan, “A teꞌ vaꞌih eꞌ a teꞌ vanënën soe vamaman rakah.” ");
INSERT INTO tpz_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ka ma meh pee soe ee pan, “A teꞌ vaꞌih eꞌ e Kristo, a teꞌ ne Sosoenën to vanö voh maꞌ.” Ivëhkëk, o upöm to sosoe avoeꞌ e ne pan, “Ahik, a teꞌ vëh ne Sosoenën se vanö maꞌ pa kon hah a napan peꞌ, eꞌ to hikta antoen non a koaꞌ manih pa muhin va Galiliꞌ, ");
INSERT INTO tpz_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","suk ataeah, o Puk Vapenpen pe Sosoenën to soe non pan, ‘E Kristo se koaꞌ manih po vuteꞌ pe Devit. E koaꞌ pamëh se koaꞌ manih pa vöön pe Devit, ka ëhnan a vöön vëh neꞌ se tavus, ivëh Bëtrëhëm.’” ");
INSERT INTO tpz_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ivëh, ka napan hikta vapöh kokoman suk ta pah soe. A ma papaeh pee to koman ne pan e Ieesuꞌ eꞌ e Kristo, ko upöm sosoe ne pan, “Ahik.” ");
INSERT INTO tpz_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ko upöm pee kehkeh öt e ne pe Ieesuꞌ, ivëhkëk, a hikta paeh pee to vaket manih peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ko pirisman varih to nö pa öt e Ieesuꞌ, ee to hah akuk ee manih po teꞌ susunön ësës heꞌ, me ro Parësiꞌ. Kee hi ee pee pan, “Eöm hikta me suk maꞌ e Ieesuꞌ ataeah?” ");
INSERT INTO tpz_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ko pirisman piun raoe, pare soe pan, “A soe no a teꞌ vëh e Ieesuꞌ to vavatvus non, no a hikta pah teꞌ na to pënton voh, to vavaasis va non nën.” ");
INSERT INTO tpz_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ko Parësiꞌ piun o pirisman, pare hi raoe pan, “Eꞌ kës to vapikpiuk me en maꞌ peöm? ");
INSERT INTO tpz_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Eöm to ep voh e nem pemöm o Parësiꞌ no a hikta paeh pemöm to vaman voh eah. ");
INSERT INTO tpz_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ivëhkëk, a napan varih to vaman ne Ieesuꞌ ee to hikta nat ne o Vavaasis pe Mosës. Ivëh, ne Sosoenën se vakmis amot suk raoe.” ");
INSERT INTO tpz_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","E Nikodimus a teꞌ vëh to nö voh pa ep e Ieesuꞌ pa popoen, ke Nikodimus koman a teꞌ to teꞌ non komön o kum teꞌ pamëh, to to vasukaꞌ ke ro upöm peꞌ, pareꞌ soe pan, ");
INSERT INTO tpz_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“A taateꞌ pea soe vaonöt kës e non pea pa vahoꞌ akuk ta pah teꞌ po vahutët pa ö na to hikta pënton avoeꞌ no a soe peꞌ para nat poꞌ in ataeah neꞌ to nok to hat non?” ");
INSERT INTO tpz_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Ko teꞌ susunön po Jiuꞌ, me ro Parësiꞌ to pënton a soe pe Nikodimus, pare hi poë pan, “Eën me kës a to Galiliꞌ, ha? Inan vavih voh ah pa soe to kiun non po Puk pe Sosoenën, parën nat vamanih pan ahikta pah teꞌ vanënën soe se tavus manih pa muhin va Galiliꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","A napan to këh ee pa Iuun Hinhin Apuh, pare vahah ee pa ma vöön pee. Ivëhkëk, e Ieesuꞌ to nö en manuh pa Tope Öliv. ");
INSERT INTO tpz_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pa pöstakah ne Ieesuꞌ to taneꞌ hah maꞌ nën, pareꞌ hah en manuh pa Iuun Hinhin Apuh. Ka napan nö ee maꞌ manih peꞌ, ko tönun töön poë, keꞌ ihoꞌ, pareꞌ taneo en pa vavaasis raoe. ");
INSERT INTO tpz_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ko teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, me ro Parësiꞌ, me ee maꞌ pa pah köövo nee to nat ne sih poë, pan eꞌ a köövo teꞌteꞌvaasiꞌ, pare vasun poë manih pa matëëra napan, ");
INSERT INTO tpz_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ko soe ke Ieesuꞌ pan, “Tövavaasis, e köövo vëh to teꞌteꞌ me non sih a meh voe, e voe pamëh hikta teꞌ non pan e voe koman peꞌ, ahik. ");
INSERT INTO tpz_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Eën koman va poꞌ nom nih, o Vavaasis pe Mosës to soe ka rora sih pan, ea se tösvös ee po köövo to nonok ne a ma taateꞌ to matan va ne manih?” ");
INSERT INTO tpz_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ee to nok a soe vaꞌih pan ee se ep këh ta hanan nee se vahoꞌ koe e Ieesuꞌ po vahutët. Ivëhkëk, e Ieesuꞌ to ihoꞌ vaseak, pareꞌ kinkiun en po oeh pa kumis koreneah. ");
INSERT INTO tpz_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kee ihi avoeꞌ e ne peꞌ pa ma hi. Ivëh, ke Ieesuꞌ takëp taꞌtaꞌ maꞌ, pareꞌ soe ke raoe pan, “Etereh varih peöm to teꞌ nem manih kuru to hikta nat ne pa nok a taateꞌ hat, ee se sun, ko vi na a vös vamomoaan manih pe köövo pamëh.” ");
INSERT INTO tpz_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","E Ieesuꞌ to ihoꞌ vaseak hah, pareꞌ kinkiun hahah kov en po oeh pa kumis koreneah. ");
INSERT INTO tpz_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ko teꞌ varih to tënan ne a soe ne Ieesuꞌ to sosoe non, taneo ee pa nö veveahih. Ee to taneo manih pa nap mamanot, pareꞌ öök non pa napan kurus. Ee to vakëkëh tavus ee pe Ieesuꞌ me e köövo pamëh to sun non pa mataneah. ");
INSERT INTO tpz_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","E Ieesuꞌ to taꞌkë maꞌ, pareꞌ hi e köövo pamëh pan, “A napan varih to teꞌ ko ne manih nö nih? Ahikta paeh pee to teꞌ non manih se vahoꞌ a oah po vahutët.” ");
INSERT INTO tpz_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ke köövo pamëh soe ke Ieesuꞌ pan, “Topoan, ee to vanönö vahik vur ee.” Ivëh, ke Ieesuꞌ soe ke poꞌ en pe köövo pamëh pan, “Eöꞌ me to hikta se vahoꞌ a noꞌ oah po vahutët. Eën se nö na, parën nat nom nok amot hah a taateꞌ hat pamëh.” ");
INSERT INTO tpz_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Vasuksuk in a ö no teꞌ vavaasis to nat ne o Vavaasis pe Mosës, me ro Parësiꞌ to pupunöꞌ ne e Ieesuꞌ. Ke Ieesuꞌ vavaato avoeꞌ me non pa napan, pareꞌ soe ke raoe pan, “Eöꞌ to teꞌ va noꞌ manih po ëman va po oeh vëh, ka teꞌ vëh to vavatet non a taateꞌ vih me a ma soe peöꞌ, eꞌ to hikta antoen non a teꞌ manih pa popoen, eꞌ se kon en po ëman vëh se heꞌ poan o toꞌtoꞌ tamoaan.” ");
INSERT INTO tpz_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","O Parësiꞌ to tënan ee pa soe ne Ieesuꞌ to vavaasis non, pare soe ke poë pan, “A ma tamoaan nën to vavaato vaviꞌ suk hah a nom sih me a ma kiu nën to nonok nom, keꞌ ivëh, a tah no a napan to hikta onöt ne a vaman suk a oah.” ");
INSERT INTO tpz_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “Oman, eöꞌ to vavatvus noꞌ sih a soe to soe suk koman e non peöꞌ. Ivëhkëk, eöꞌ to hikta pikpiuk a no neöm pa ma soe poë varih, ahik, a ma soe poë varih ee a ma soe man. Suk ataeah, eöꞌ to nat e noꞌ pa vöön nöꞌ to taneꞌ voh maꞌ, paröꞌ nat me e noꞌ pa vöön nöꞌ to nönö hah noꞌ. Ivëhkëk, eöm to hikta nat nem pa vöön peöꞌ, paröm hikta nat me nem pa vöön poanheh nöꞌ to nönö hah noꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Eöm to kiiki nem sih a taateꞌ pa teꞌ pa taateꞌ va po oeh vëh, peöꞌ to hikta kiiki noꞌ a taateꞌ pa ta pah teꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ivëhkëk, eöꞌ se keh nok a taateꞌ kiiki teꞌ, a taateꞌ kiiki teꞌ peöꞌ a man. Suk ataeah, eꞌ to hikta teꞌ non pan eöꞌ varoe to nonok noꞌ a taateꞌ pamëh, ahik. E Tamön vëh to vanö voh a maꞌ neoꞌ to teꞌ vaꞌpeh me e non peöꞌ, köꞌ kiiki noꞌ a taateꞌ pa teꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","O Vavaasis pe Mosës to soe non pan, ta poa teꞌ se keh soe ta pah tah, pare vapöh kokoman a soe pamëh, ea se vaman ee pataeah nee to soe. ");
INSERT INTO tpz_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ivëh, ke eöꞌ koman peheoꞌ to vavatvus noꞌ sih a soe to soe suk koman e non peöꞌ, ke Tamön vöh pa vöön va kin to vanö voh a maꞌ neoꞌ to vavaꞌaus me e non pa ma soe peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","E Ieesuꞌ to sosoe va non manih, ko Parësiꞌ hi hah ee peꞌ pan, “E tamömah vëh nën to tooto suk nom teꞌ non nih?” Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “Eom to hikta nat rakah nem peöꞌ poꞌ Tamön. Eöm se keh nat e nem peöꞌ, a, eöm to nat me e nem pe Tamön.” ");
INSERT INTO tpz_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","E Ieesuꞌ to sosoe non a soe vaꞌih pa ö neꞌ to vavaasis non a napan koman A Iuun Hinhin Apuh pa ö neꞌ to sun vatët non pa ö no a napan to vavahoꞌ ne sih a ma heꞌ pee. Ivëhkëk, a hikta teꞌ to öt poan, suk ataeah o poen neꞌ se taum a punis me o kamis to meꞌ avoeꞌ e non pa tavus maꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","E Ieesuꞌ to soe hah ke raoe pan, “Eöꞌ se nö eoꞌ, köm hikta onöt nem a ep hah a neoꞌ. Eöm se mët vaꞌpeh me em pa ma hat peöm. Eöm to hikta antoen nem a nö pa vöön nöꞌ to nönö noꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ivëh, ko teꞌ susunön po Jiuꞌ vaiihi e ne, pare soe pan, “A teꞌ vëh se kës ip vamët hah ea, peꞌ to sosoe va non manih pan, ‘Eöm to hikta onöt nem nö pa vöön nöꞌ to nönö noꞌ’?” ");
INSERT INTO tpz_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ke Ieesuꞌ soe ke raoe pan, “Eöm varih, eöm a napan va vakunah, peöꞌ a te va pa vöön va kin, eöm varih a napan va po oeh vëh, peöꞌ a teꞌ to hikta teꞌ noꞌ pan eöꞌ a teꞌ va po oeh vëh. ");
INSERT INTO tpz_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ivëh, nöꞌ to soe suk voh ka neöm manih pan, eöm se mët vaꞌpeh me em pa ma hat peöm. Oman, eöm se keh hikta vaman a non neoꞌ pan, Eöꞌ Kove Vëh, Eöꞌ! Ka ma hat peöm se teꞌ e ne, köm mët vaꞌpeh me em pee.” ");
INSERT INTO tpz_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ko teꞌ susunön po Jiuꞌ hi hah ee peꞌ pan, “Soe ka möm ah, eën poꞌ eteh?” Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “Po taneo nöꞌ to soe voh keoꞌ peöm peöꞌ eteh. ");
INSERT INTO tpz_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Eöꞌ to teꞌ me noꞌ a ma soe nöꞌ se vahoꞌ rakah manih pa ma taateꞌ peöm. Eöꞌ se iniinan a ma taateꞌ peöm vamanih pa tökiiki teꞌ. Ivëhkëk, eöꞌ se soe varoe ka neöm a ma napan va po oeh vëh, pataeah nöꞌ to pënton manuh pa Teꞌ vëh to vanö voh a maꞌ neoꞌ. Ka Teꞌ pamëh, eꞌ a sosoe man.” ");
INSERT INTO tpz_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","O teꞌ susunön po Jiuꞌ to hikta nat ne pe Ieesuꞌ to sosoe vanat e non pee pe Tamaneah, Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Eꞌ to soe ke raoe pan, “A poen nöm se kë a neoꞌ e Koaꞌ Teꞌ Pa Napan Kurus manih po naon, eöm se nat va poꞌ em manih pan, Eöꞌ Kove Vëh, Eöꞌ! Eöm me se nat va e nem manih pan a ma tah kurus nöꞌ to nonok noꞌ, nöꞌ to hikta nonok noꞌ pa tasun me o kokoman koman peöꞌ. Ahik, a ma tah kurus varih nöꞌ to nonok noꞌ sih, eꞌ a ma tah ne Tamön vöh pa vöön va kin to vataare voh a neoꞌ köꞌ nonok noꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","E Tamön vöh pa vöön va kin to vanö voh a maꞌ neoꞌ, pareꞌ teꞌ vaꞌpeh tamoaan me e non peöꞌ. Ka ma tah nöꞌ to nonok noꞌ sih, ee a ma tah to heꞌ vaeö ne sih poë, keꞌ hikta onöt non a anoe a neoꞌ pa ta pah poen.” ");
INSERT INTO tpz_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","E Ieesuꞌ to sosoe va ko non nën, ka nap peo vaman ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","E Ieesuꞌ to soe ke ra napan va Israël varih to vaman poë pan, “Eöm se keh vatet vavih rakah a soe peöꞌ, paröm öt vakis o vaman me o vavaasis peöꞌ, eöm se tavus rakah em o vamomhë peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Paröm nat va nem manih pan a ma soe peöꞌ ee a ma man rakah, ka ma soe man poë varih se me hah ee peöm manih pa taateꞌ teꞌ vavih.” ");
INSERT INTO tpz_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ka napan varih to tënan ne a soe pe Ieesuꞌ piun poë, pare soe pan, “Emöm to nat e nem pemöm ö pus koaꞌ pe Abraham, ka hikta paeh pemöm to tavus voh a teꞌ kikiu akuk manih pa ta meh teꞌ. Vahvanih kën soe kamöm pan, ‘Emöm se tavus vavih hah?’” ");
INSERT INTO tpz_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ke Ieesuꞌ piun a soe pee, pareꞌ soe pan, “Eöꞌ to soe vaman rakah ke voh eoꞌ peöm, o teꞌ varih to nonok ne sih a ma taateꞌ hat, ee o teꞌ to kiu akuk ne manih paan a taateꞌ hat. ");
INSERT INTO tpz_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","O teꞌ kikiu akuk to hikta a onöt ne a teꞌ manih pa iuun pa kën tom taman varih to matop ne raoe. Ahik, o koaꞌ varoe to antoen ne a teꞌ tamoaan manih pa iuun pee ra kën tom taman. ");
INSERT INTO tpz_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ivëh, keöꞌ e Koaꞌ pe Sosoenën se keh vaꞌaus a neöm, köm tavus këh maꞌ a taateꞌ hat, a, eöm se teꞌ tamoaan nem manih pa taateꞌ teꞌ vavih. ");
INSERT INTO tpz_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Eöꞌ to nat e noꞌ peöm o pus koaꞌ pe Abraham. Ivëhkëk, eöꞌ to nat e noꞌ peöm to kehkeh ip vamët e nem peöꞌ. Suk eöm to hikta iu tënan nem a soe peöꞌ, paröm öt vakis. ");
INSERT INTO tpz_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Eöꞌ to sosoe ke noꞌ peöm pa ma taneah ne Tamön to soe voh ka neoꞌ. Ivëhkëk, eöm to nonok e nem pa ma taateꞌ nöm to kon taneꞌ voh manih pe tamëneöm.” ");
INSERT INTO tpz_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","O teꞌ susunön po Jiuꞌ to pënton a soe pe Ieesuꞌ, pare soe ee pan, “E tamamöm e Abraham.” Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “Eöm se keh teꞌ vamaman voh nem pan eöm a pus koaꞌ pe Abraham, eöm se nonok e nem pa ma tah ne Abraham to nonok voh non. ");
INSERT INTO tpz_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Eöꞌ to sosoe ke noꞌ peöm pa ma soe man, nöꞌ to tënan manuh pe Sosoenën. Ivëhkëk, eöm to pupunöꞌ e nem pa ip vamët a neoꞌ. E Abraham to hikta nok voh ta tah to matan va non manih pa ma taateꞌ nöm to nonok nem. Ahik. ");
INSERT INTO tpz_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","A ma taateꞌ varih nöm to nonok nem, eꞌ a ma taateꞌ nonok voh pe tamëneöm.” Ivëhkëk, o teꞌ susunön po Jiuꞌ to soe ee pan, “Emöm to hikta teꞌ va nem manih po koaꞌ varih to hikta nat ne pe tamëëre. Emöm to teꞌ ro me nem a pah Tamamöm, ivëh e Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ke Ieesuꞌ soe ke raoe pan, “E Sosoenën se keh teꞌ vamaman non pan eꞌ e Tamaneöm, köm onöt e nem pa iu a neoꞌ. Suk ataeah, eöꞌ to taneꞌ voh maꞌ manuh peꞌ, paröꞌ teꞌ noꞌ manih kuru. Eöꞌ to hikta nö voh maꞌ manih pa tasun me o kikis koman peöꞌ. Ahik, e Sosoenën koman to vanö voh a maꞌ neoꞌ, köꞌ nö maꞌ manih po oeh vëh. ");
INSERT INTO tpz_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Eöm to hikta iniinan vavih pataeah nöꞌ to sosoe noꞌ sih, suk eöm to hikta iu tënan nem o vavaasis peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Eöm o pus koaꞌ vamaman rakah pe susun po oraꞌ hat. Eöm to iu nok rakah nem a ma taateꞌ neꞌ to iu non. Moaan voh po taneo neꞌ to hinën a napan pa ip vamët raoe. Pareꞌ teꞌ non pa vapikpiuk a soe man. Suk ataeah, a soe man to hikta teꞌ non manih peꞌ. Ko poen neꞌ se nok o piuk, ko piuk pamëh vateeraꞌ en peꞌ, eꞌ e taman rakah in a taateꞌ piuk. ");
INSERT INTO tpz_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Eöꞌ to sosoe vatëh ke noꞌ sih peöm pa taateꞌ man, ivëhkëk, eöm to hikta vaman nem a tah nöꞌ to sosoe noꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Eteh rakah va peöm to nat non a hat nöꞌ to nok voh? Eöꞌ to vavaasis a noꞌ neöm sih pa soe man. Eöm hikta vaman suk poꞌ nem a soe peöꞌ ataeah? ");
INSERT INTO tpz_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","A teꞌ to kon a soe pe Sosoenën, eꞌ a teꞌ pe Sosoenën. Ivëhkëk, eöm varih o teꞌ to hikta tënan nem a soe ne Sosoenën to sosoe non, eöm to hikta teꞌ nem pan eöm o pus koaꞌ pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ko teꞌ susunön po Jiuꞌ piun a soe pe Ieesuꞌ, pare soe pan, “A tuvuh hat to teꞌ non pën, suk eën a to Samëriaꞌ. A soe kës pemöm a man, keꞌ ataeah?” ");
INSERT INTO tpz_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “Ahikta oraꞌ hat to teꞌ non manih peöꞌ, eöꞌ to kë varoe ko noꞌ sih e Tamön. Ivëhkëk, eöm to hikta iu kë nem sih a teꞌ ëhnaneoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Eöꞌ to hikta kehkeh noꞌ pan, ta teꞌ se kë ëhnaneoꞌ, ahik, eꞌ to teꞌ ro non a pah tökiiki Teꞌ ivëh e Sosoenën se kë a ëhnaneoꞌ. Köm inan, paröm nat poꞌ a soe peöꞌ a man. ");
INSERT INTO tpz_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Eöꞌ to soe vaman rakah keoꞌ peöm, etereh to vaman ne o vavaasis peöꞌ ee to hikta onöt ne a mët.” ");
INSERT INTO tpz_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ko teꞌ susunön po Jiuꞌ piun poë, pare soe pan, “Kuru emöm to nat vavih em pën no a oraꞌ hat to teꞌ non manih pën. O teꞌ vanënën soe ke Abraham to mëtmët vahik voh ee. Ivëhkëk, eën to sosoe avoeꞌ e nom pan, ‘Etereh to vaman ne o vavaasis pën, ee hikta se mët ne.’ ");
INSERT INTO tpz_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Eën koman kës nom pan a tasun pën to apuh oah e non pa teꞌ tasun pe tamaara Abraham, me ro teꞌ vanënën soe varih to mët voh, eën koman nom pan eën eteh?” ");
INSERT INTO tpz_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ke Ieesuꞌ piun a soe pee, pareꞌ soe pan, “Eöꞌ se keh ta koman hah a noꞌ, a, a taateꞌ ta hah öꞌ, se teꞌ e non a tah akuk. Ka Teꞌ vëh to kë non a ëhnaneoꞌ, eꞌ e Tamaneoꞌ. Ivëhkëk, eöm to sosoe nem pan, ‘Eꞌ e Sosoenën peöm.’ ");
INSERT INTO tpz_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Eöm to hikta nat vavih rakah nem peꞌ. Eöꞌ se keh soe ka neöm pan eöꞌ to hikta nat vavih rakah noꞌ eah, eöꞌ se tavus rakah eoꞌ a teꞌ pikpiuk vamanih peöm. Ivëhkëk, eöꞌ to nat vavih rakah e noꞌ peꞌ e Tamön, paröꞌ tënan vavih rakah e noꞌ pa ma taneah neꞌ to sosoe ka no neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","E sipuineöm Abraham to haraꞌ suntan rakah voh e non po vaeö pa poen nöꞌ to nö maꞌ. Eꞌ to ep vahik voh en po poen pamëh nöꞌ to nö maꞌ ko kokoman peꞌ puh rakah e non po vaeö.” ");
INSERT INTO tpz_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ko teꞌ susunön po Jiuꞌ soe pan, “Eën to hikta ep avoeꞌ voh nom pe Abraham, suk ataeah, eën to hikta manot onöt avoeꞌ nom to 50 kirismas.” ");
INSERT INTO tpz_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “Eöꞌ to soe vamaman rakah ke voh eoꞌ peöm, moaan voh ne sinan e Abraham to meꞌ avoeꞌ voh e non pa vahuh poan, eöꞌ to teꞌ momoaan voh e noꞌ, paröꞌ teꞌ avoeꞌ va e noꞌ manih kuru.” ");
INSERT INTO tpz_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","E Ieesuꞌ to soe vakomanih, ka napan kokon ee po vös to tösvös in poë, ivëhkëk, eꞌ to ro këh en pee, kee hikta ep hah ne poë to këh tavus en pa Iuun Hinhin Apuh. ");
INSERT INTO tpz_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","E Ieesuꞌ to nönö nö non, pareꞌ ep a pah teꞌ kehoꞌ to teꞌ non ne sinaneah to vahuh voh poan a kehoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ka ma vamomhë peꞌ hi poë pan, “Tövavaasis, a hat peteh ivëh to nok voh a teꞌ vëh ke sinaneah vahuh voh poan a kehoꞌ? A hat peꞌ, keꞌ, a hat pe sinaneah pen tamaneah?” ");
INSERT INTO tpz_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “Eꞌ to hikta teꞌ non pan a hat voh pa teꞌ vëh pen sinaneah, ke tamaneah, nee to nok voh ka teꞌ vëh tavus a teꞌ kehoꞌ. Ahik, A teꞌ vëh to tavus kehoꞌ voh, pan a napan se ep a kiu me o kikis pe Sosoenën se tavus vateeraꞌ manih peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kuru no a potan to teꞌ avoeꞌ e non ka se kikiu avoeꞌ e no pa ma kiu pe Sosoenën vëh, a Teꞌ to vanö voh a maꞌ neoꞌ. A muhin se poen ka hikta teꞌ to antoen non a nok hah ta kiu. ");
INSERT INTO tpz_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kuru nöꞌ to teꞌ noꞌ manih po oeh vëh, eöꞌ to teꞌ va e noꞌ manih po ëman va po oeh.” ");
INSERT INTO tpz_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","E Ieesuꞌ to soe vahik vakomanih, pareꞌ teo en manih po oeh. Ko vapuputoꞌ en pa siꞌ ö oeh, pareꞌ kon ko vahoꞌ en pa ö putoꞌ pamëh manih pa matan a teꞌ kehoꞌ pamëh. ");
INSERT INTO tpz_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Pareꞌ soe ke poan pan, “Nö ah, parën pupui a matömah manuh pa koveꞌ ruen va Siroam.” A pusun in a ö soe vëh Siroam to soe va non manih pan, “Vanö eah. Keꞌ nö.” Ivëh, ka teꞌ pamëh nö ko pupui a mataneah pa koveꞌ ruen pamëh. Ka mataneah vih en, keꞌ ep vavih en. ");
INSERT INTO tpz_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ivëhkëk, a ma meh peꞌ me ro upöm teꞌ to inan poë a teꞌ vëh to hinhin tah voh non a napan, pare soe pan, “Eꞌ kës ko vëh a teꞌ vëh to ihoꞌ voh non sinten hanan, pareꞌ hinhin tah non sih a ma napan, ha?” ");
INSERT INTO tpz_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ko upöm soe maꞌ pan, “A, eꞌ akuk kës kuru a teꞌ pamëh.” Ivëhkëk, o upöm to soe ee pan, “Ahik, a meh teꞌ ivëh to matan ro va non manih peꞌ.” Ka teꞌ pamëh soe koman ken pa napan poë varih pan, “Ahik, eöꞌ akuk kuru a teꞌ pamëh.” ");
INSERT INTO tpz_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ka napan poë varih hi ee peꞌ pan, “A matömah vih vahvanih?” ");
INSERT INTO tpz_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Keꞌ piun raoe, pareꞌ soe pan, “A teꞌ vëh nee to popokaꞌ ne poë e Ieesuꞌ to vapuputoꞌ o oeh, pareꞌ vahoꞌ manih pa mataneoꞌ. Pareꞌ soe ka neoꞌ pan, eöꞌ se nö ko pupui a mataneoꞌ manuh pa koveꞌ ruen va Siroam. Ivëh, köꞌ nö ko pupui eoꞌ pa mataneoꞌ nën, ka mataneoꞌ vih en, köꞌ ep vavih eoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Kee hi hah ee peꞌ pan, “Ka teꞌ pamëh teꞌ poꞌ non nih?” Keꞌ piun raoe, pareꞌ soe ke raoe pan, “Eöꞌ to hikta nat noꞌ peꞌ me a ö neꞌ to teꞌ non.” ");
INSERT INTO tpz_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ka napan me ee maꞌ pa teꞌ voh vëh a kehoꞌ manih po Parësiꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","O poen ne Ieesuꞌ to nok vavih hah voh a matan a teꞌ pamëh, eꞌ o Poen Apaapo. ");
INSERT INTO tpz_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ivëh, ko Parësiꞌ hi ee pa teꞌ pamëh pan, “A matömah vih vahvanih?” Ka teꞌ pamëh piun raoe, pareꞌ soe pan, “A teꞌ pamëh to vahoꞌ a ö putoꞌ manih pa mataneoꞌ. Köꞌ pupui eah pa koveꞌ ruen va Siroam, ka varuꞌ vakomanih no a mataneoꞌ to takap en, köꞌ ep vavih eoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ivëhkëk, a ma meh to Parësiꞌ to soe pan, “A teꞌ vëh e Ieesuꞌ to hikta vavatet vavih non a taateꞌ va po Poen Apaapo pea.” Ivëhkëk, o upöm Parësiꞌ to soe pan, “A teꞌ vatösoe va pa nok vatëh a ma taateꞌ hat to hikta onöt non a nok a ma tah vatoksean varih.” O Parësiꞌ to hikta vapöh kokoman me ne o upöm pee. ");
INSERT INTO tpz_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ko Parësiꞌ hi hahah kov ee pa teꞌ pamëh pan, “Eën koman va nom nih pa teꞌ vëh to nok vavih pa matömah?” Ka teꞌ pamëh piun raoe, pareꞌ soe pan, “Eöꞌ to koman noꞌ pan eꞌ a teꞌ vanënën soe.” ");
INSERT INTO tpz_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Oman! Moaan voh no a teꞌ pamëh to teꞌ kehoꞌ voh e non. Ivëhkëk kuru no a mataneah to vih en. O teꞌ susunön po Jiuꞌ to hikta vaman ne a soe pa teꞌ pamëh, pare vaoe ee na pe sinaneah pen tamaneah, kee nö ee maꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","A poa manot to nö ee maꞌ, ko teꞌ susunön po Jiuꞌ hi ee pee pan, “E koaꞌ ko peöm ivëh ne eöm to sosoe nem pan eꞌ to tavus voh e koaꞌ a kehoꞌ, ha? Vahvapoꞌnih no matan e koaꞌ peöm to vih hah?” ");
INSERT INTO tpz_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ka poa manot piun raoe, pare soe pan, “Emöm to nat rakah e nem pe koaꞌ vaꞌih, eꞌe koaꞌ pemöm to koaꞌ voh en maꞌ a koaꞌ kehoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ivëhkëk, emöm to hikta nat nem a mataneah vih vahvanih, hi öm eah, peꞌ to apuh onöt e non pa vaato koman.” ");
INSERT INTO tpz_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","E tamaneah pen sinaneah to soe vamanih, suk ee to nanaöp e ne po teꞌ susunön po Jiuꞌ. O teꞌ poë varih to noh ee pa soe to soe non pan, eteh se keh pokaꞌ e Ieesuꞌ e Kristo a teꞌ ne Sosoenën to vanö maꞌ, ee se veo tavus këh ee peꞌ pa iuun hinhin soneꞌ pee. ");
INSERT INTO tpz_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Eꞌ akuk kuru a ö no a poa manot to soe suk vamanih pan, “Hi öm eah, peꞌ to apuh onöt e non pa vaato koman.” ");
INSERT INTO tpz_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ivëh, ko teꞌ susunön po Jiuꞌ vapöök vaoe ee na pa teꞌ pamëh, pare soe ke poë pan, “Eën se kë rakah a ëhnan e Sosoenën pa ö nën se nok a soe kikis pën, a man. Emöm to nat vahik voh em pa teꞌ vëh nën to sosoe suk nom. Eꞌ a teꞌ va pa nok vatëh a ma taateꞌ hat.” ");
INSERT INTO tpz_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ka teꞌ vëh to koaꞌ voh maꞌ a kehoꞌ soe en pan, “Eöꞌ to hikta nat vavih noꞌ peꞌ, eꞌ a teꞌ nonok hat, keꞌ ahik. A pah tah ro ko nöꞌ to nat noꞌ ivëh, moaan voh eöꞌ a kehoꞌ, ka kuru neꞌ to nok vavih hah en pa mataneoꞌ köꞌ ep vavih eoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ko teꞌ susunön po Jiuꞌ hi hahah kov ee peꞌ pan, “Eꞌ nok vah va ka oah nih? Ka matömah vih hah?” ");
INSERT INTO tpz_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Keꞌ soe ke raoe pan, “Eöꞌ to soe vahik ke vur eoꞌ peöm, eöm to hikta pënton vavih pöꞌ vu nem. Eöm kehkeh nat vavih suk nem ataeah? Eöm to kehkeh tavus me pöꞌ nem o vamomhë peꞌ, ha?” ");
INSERT INTO tpz_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ko teꞌ susunön po Jiuꞌ vavovoeak poë, pare soe pan, “Eën me poꞌ pöꞌ a meh vamomhë peꞌ, toh? Pemöm varih, emöm o vamomhë pe Mosës. ");
INSERT INTO tpz_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Emöm to nat e nem pe Sosoenën to vavaato me voh non sih e Mosës. Ivëhkëk, emöm to hikta nat rakah nem a teꞌ vëh to vavih hah a matömah, taneꞌ maꞌ nih.” ");
INSERT INTO tpz_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ka teꞌ voh vëh a kehoꞌ piun raoe, pareꞌ soe pan, “Eöm to nok a soe vaꞌih a vatoksean rakah, paröm soe pet em pan, eöm to hikta nat nem a teꞌ pamëh taneꞌ maꞌ nih. Pareꞌ nok vavih a mataneoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ea kurus to nat e no pe Sosoenën to hikta onöt non a pënton a soe pa teꞌ vëh to nonok vatëh non a ma taateꞌ hat. Ivëhkëk, eꞌ se pënton varoe a hin po teꞌ varih to pënton ne a soe peꞌ, pare vavatet ne. ");
INSERT INTO tpz_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Moaan voh, pareꞌ öök non manih kuru, na to hikta tënan voh no ta pah teꞌ ne sinaneah to vahuh voh poan a kehoꞌ ka meh teꞌ nok vavih hah a mataneah, keꞌ ep vavih hah. ");
INSERT INTO tpz_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","E Sosoenën se keh hikta vanö voh maꞌ a teꞌ pamëh, keꞌ hikta onöt non a nok ta pah tah.” ");
INSERT INTO tpz_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ko teꞌ susunön po Jiuꞌ piun a soe pa teꞌ voh vëh a kehoꞌ, pare soe, “E sinömah to vahuh voh oah, no a hat to puh rakah non manih pën. Eën kehkeh vavaasis a no möm öh?” Ee to soe vahik vakomanih, pare veo tavus këh ee peꞌ pa iuun hinhin soneꞌ pee. Keꞌ nö en. ");
INSERT INTO tpz_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","E Ieesuꞌ to pënton en pa ma soe va pa ö no teꞌ susunön po Jiuꞌ to veo ee pa teꞌ voh vëh a kehoꞌ. Ke Ieesuꞌ taum poan, pareꞌ soe ke poan pan, “Eën vaman kës e nom pe Koaꞌ Teꞌ pa Napan Kurus?” ");
INSERT INTO tpz_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ka teꞌ voh vëh a kehoꞌ pamëh piun a soe pe Ieesuꞌ, pareꞌ soe pan, “Topoan, eteh e Koaꞌ Teꞌ Pa Napan Kurus, nöꞌ se vaman eah?” ");
INSERT INTO tpz_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ke Ieesuꞌ piun poan, pareꞌ soe pan, “Eën to ep voh eom peꞌ, eꞌ e Koaꞌ Teꞌ Pa napan Kurus ivëh to vavaato me a no moah.” ");
INSERT INTO tpz_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ka teꞌ pamëh piun, pareꞌ soe pan, “Topoan, eöꞌ to vaman e noꞌ pën.” Ka varuꞌ vakomanih neꞌ to vatokon ko kë en pa ëhnan e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ke Ieesuꞌ soe pan, “Eöꞌ to nö maꞌ manih po oeh vëh, to kiiki a taateꞌ pa ma napan, me eöꞌ to nö voh maꞌ pan, o teꞌ kekehoꞌ se opoep hah. Ko teꞌ varih to opoep voh ne se tavus varuꞌ o teꞌ kekehoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Eꞌ to teꞌ non a ma pah teꞌ susunön po Jiuꞌ to sun vatët ne to pënton a ma soe varih ne Ieesuꞌ to sosoe non, pare hi poë pan, “Eën kës to sosoe nom pan emöm me o kekehoꞌ, ha?” ");
INSERT INTO tpz_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “Eöm se keh teꞌ vavoh nem manih po teꞌ kekehoꞌ, eöm to hikta onöt nem a teen ta hat. Ivëhkëk, kuru eöm to sosoe nem pan, ‘A ma matanmöm to opoep e ne.’ Ivëh, no a ma hat peöm se teꞌ tamoaan suk ne.” ");
INSERT INTO tpz_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","E Ieesuꞌ to vavaato avoeꞌ me non pa napan, pareꞌ soe ke raoe pan, “Eöꞌ to soe vamaman rakah keoꞌ peöm. A teꞌ to hikta ho koe ke maꞌ manih po hopaꞌ oho koe ke po sipsip, eꞌ a teꞌ kakaveo, me a teꞌ vëh to vaꞌnaöp a meh teꞌ pareꞌ kon akuk a ma tah peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ivëhkëk, a teꞌ vëh to ho koe ke maꞌ manih po hopaꞌ oho koe ke po sipsip, eꞌ a teꞌ pamëh to matop non sih o sipsip. ");
INSERT INTO tpz_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ka teꞌ vëh to matop non sih po hopaꞌ, peret ken pa teꞌ pamëh keꞌ ho en maꞌ. Ko sipsip tënan inan ee pa to peꞌ, keꞌ vaoe en pa ëhnëëro sipsip koman peꞌ, pareꞌ me tavus en pee. ");
INSERT INTO tpz_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Eꞌ to me tavus en po sipsip, pareꞌ vovoh nö ke non pee, kee suksuk nö e ne peꞌ, suk ataeah, ee to tënan inan e ne pa to peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ivëhkëk, o sipsip to hikta onöt ne a suk a meh teꞌ, ee se rusin këh ee peꞌ, suk ataeah, ee to hikta tënan inan ne a to pa teꞌ pamëh.” ");
INSERT INTO tpz_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","E Ieesuꞌ to soe vahik ken pa napan pa soe vapipinoꞌ pamëh, ivëhkëk, a napan to hikta nat ne pa pusun in o vahutët pamëh. ");
INSERT INTO tpz_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ivëh, ke Ieesuꞌ soe hahah kov en pan, “Eöꞌ to soe vamaman rakah keoꞌ peöm. Eöꞌ koman e Ieesuꞌ Kristo, eöꞌ to teꞌ va e noꞌ manih po hopaꞌ oho koe ke po sipsip. ");
INSERT INTO tpz_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Eöꞌ to hikta teꞌ va noꞌ manih pa napan varih to vovoh voh ka maꞌ neoꞌ, ahik, ee to teꞌ va e ne manih po teꞌ kakaveo me ro teꞌ varih to vaꞌnaöp o upöm teꞌ, pare kon akuk a ma tah pee. Ivëh, no sipsip man peöꞌ varih a napan, to hikta tënan inan suk ne raoe. ");
INSERT INTO tpz_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Eöꞌ koman to teꞌ va e noꞌ manih po hopaꞌ, keteh to koe ke maꞌ manih peöꞌ e Sosoenën se hehe en peꞌ. A teꞌ pamëh, se keh koe ke maꞌ manih peöꞌ, pareꞌ oah koe manih peöꞌ. Eꞌ se taum en pa taëën, pareꞌ hikta antoen non a taum ta hat. ");
INSERT INTO tpz_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","A teꞌ kakaveo to hikta nö maꞌ pa nok ta meh tah, ahik, eꞌ to nö ro ko maꞌ pa kaveo o sipsip, me ip vamët, me a miröꞌ raoe. Ivëhkëk eöꞌ koman, eöꞌ to nö voh maꞌ pa heꞌ o toꞌtoꞌ tamoaan peöꞌ manih pee, ko toꞌtoꞌ tamoaan pamëh puh rakah non manih pee, kee teꞌ vavih e ne. ");
INSERT INTO tpz_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Eöꞌ koman rakah a teꞌ a pah mamatop sipsip vavih. Ka teꞌ vëh to matop vavih non sih o sipsip ivëh, to heꞌ o toꞌtoꞌ peꞌ marën a vaꞌaus o sipsip peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ka teꞌ vëh to kiu moniꞌ varoe non eꞌ to hikta koman tiroëꞌ non a matop vavih o sipsip. Suk ataeah, eꞌ to hikta vaneah non po sipsip poë varih. Ko poen neꞌ to ep o këh poa to nö maꞌ, eꞌ to rusin këh en po sipsip, ko këh poa poë varih ëën ee pee ko veo vavah ee po upöm. ");
INSERT INTO tpz_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","A teꞌ kikiu se rusin en, suk eꞌ to kiu moniꞌ varoe ko non. Eꞌ to hikta iu matop vavih non o sipsip. ");
INSERT INTO tpz_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Eöꞌ koman a teꞌ to matop vavih noꞌ sih o sipsip. Eöꞌ to nat vavih rakah e noꞌ po sipsip peöꞌ vamanih pa ö ne Tamön vöh kin to nat vavih va ka non neoꞌ. Ko sipsip peöꞌ to nat vavih e ne peöꞌ vamanih pa ö nöꞌ to nat vavih va i noꞌ sih e Tamaneoꞌ Sosoenën. Keöꞌ koman se heꞌ o toꞌtoꞌ peöꞌ marën a vaꞌaus a napan, ka napan ip vamët a neoꞌ, köꞌ mët marën a vaꞌaus o sipsip peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Eöꞌ to vaneah noꞌ o upöm sipsip, ko sipsip poë varih to teꞌ tavus këh e ne pa panis sipsip peöꞌ, eöꞌ to kehkeh me ho noꞌ maꞌ o sipsip poë varih pa panis peöꞌ. Kee sih tënan ne a to peöꞌ keꞌ teꞌ non a pah teꞌ ro to ut non po sipsip poë varih pa koman a pah panis. ");
INSERT INTO tpz_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","E Tamön to iu suntan rakah e non peöꞌ, suk ataeah, eöꞌ to nat e noꞌ, peöꞌ se heꞌ o toꞌtoꞌ peöꞌ pa mët, paröꞌ kon hah eoꞌ po toꞌtoꞌ pamëh. ");
INSERT INTO tpz_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","E Tamön to soe vakis voh ka neoꞌ a nok vamanih, ka hikta pah teꞌ to onöt non a kon këh a neoꞌ po toꞌtoꞌ peöꞌ. Eöꞌ koman to teꞌ me noꞌ o kikis va pa heꞌ o toꞌtoꞌ peöꞌ manih pa mët. Paröꞌ teꞌ me e noꞌ po kikis va pa kon hah o toꞌtoꞌ pamëh.” ");
INSERT INTO tpz_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","O teꞌ susunön po Jiuꞌ to pënton a soe vaꞌih ne Ieesuꞌ to nok ko taki vakëh ee, pare hikta vapöh kokoman hah ne. ");
INSERT INTO tpz_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ko upöm teꞌ peo va po teꞌ susunön po Jiuꞌ soe ee pan, “A oraꞌ hat to teꞌ non manih pa teꞌ vëh. A oraꞌ pamëh to vapapön non poan, keꞌ tooto pinpiun non. Eöm pëpënton suk nem a soe peꞌ ataeah?” ");
INSERT INTO tpz_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ko upöm pee soe ee pan, “A teꞌ no a oraꞌ hat se keh teꞌ non peꞌ keꞌ tooto pinpiun non, eꞌ to hikta antoen non a soe ta soe to matan va non manih, a oraꞌ hat onöt kës e non pa kap hah a matan a teꞌ kehoꞌ, keꞌ ep vavih hah?” ");
INSERT INTO tpz_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Manih pa ma poen tutuvuh no a napan to tönun manih Jerusalëm, pare vaeö ne o poen nee to peret voh a Iuun Hinhin Apuh pee. ");
INSERT INTO tpz_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ke Ieesuꞌ koe ke maꞌ pa vo nee to popokaꞌ ne a vo pe Solomon. A vo pamëh to teꞌ non koman a Iuun Hinhin Apuh va Jerusalëm. ");
INSERT INTO tpz_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ko teꞌ susunön po Jiuꞌ nö maꞌ, pare tönun töön poë. Pare hi poë pan, “Soe kamöm ah, o poen poanheh nën se soe vamaaka kamöm, eën eteh, eën se keh teꞌ nom pan eën e Kristo? Soe vamaaka poꞌ ka möm ah.” ");
INSERT INTO tpz_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “Eöꞌ to soe vamaaka ke voh eoꞌ peöm, ivëhkëk, eöm to hikta vaman voh nem a soe peöꞌ. A ma tah vatoksean nöꞌ to nonok voh noꞌ manih pa ëhnan e Tamön, to vataare e ne peöꞌ eteh. ");
INSERT INTO tpz_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ivëhkëk, eöm to hikta iu vaman nem, suk ataeah, eöm to hikta teꞌ nem pan eöm o sipsip peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","O sipsip peöꞌ to tënan inan e ne pa to peöꞌ. Köꞌ nat e noꞌ pee, kee suksuk vah e ne sih peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Eöꞌ to heꞌ voh eoꞌ pee po toꞌtoꞌ tamoaan peöꞌ, kee hikta onöt ne a ro, ka hikta pah teꞌ to onöt non a he taneꞌ raoe manih pa koreneoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","E Tamön to heꞌ voh en peöꞌ po sipsip. Eꞌ to apuh oah e non pa ma moeh tah kurus, ka hikta pah teꞌ to onöt non a he taneꞌ o sipsip peöꞌ manih pa koreneah. ");
INSERT INTO tpz_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Emöm poꞌ Tamön, to teꞌ tamoaan e nem a paeh a teꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ivëh, ko teꞌ susunön po Jiuꞌ pënton a soe vaꞌih, pare kokon o vös, ko kehkeh tösvös e ne pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ivëh, ne Ieesuꞌ to soe suk va i raoe manih pan, “Eöꞌ to nok voh a ma kiu vihvih va pe Tamön, ka ma kiu vihvih poë varih nöm to ep voh em. A hat taeah poꞌ nöꞌ to nok köm kehkeh ip vamët suk a nem neöꞌ?” ");
INSERT INTO tpz_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ivëhkëk, o teꞌ susunön po Jiuꞌ to piun poë pare soe pan, “Emöm to hikta iu ip vamët a nom oah suk eën to nonok nom a ma kiu vihvih, ahik, a tah nemöm to kehkeh ip vamët suk a nom oah ivëh, eën to teꞌ me ennom po sionin, parën tooto oꞌoah e nom pe Sosoenën pa ö nën to sosoe nom pan eën to vatoe me e nom peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “O vavaasis peöm to teꞌ non koman o Puk Vapenpen ne Sosoenën to sosoe non pan, ‘Eöm o teꞌ to teꞌ me nem o sionin, eöm kurus o sosoenën.’ ");
INSERT INTO tpz_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","“Ka soe to kiun non manih po Puk pe Sosoenën pamëh to soe non pan, o teꞌ varih to kon a soe pe Sosoenën, ‘Ee ro sosoenën.’ “A soe to kiun non manih po Puk pamëh, eꞌ a soe man, pareꞌ hikta onöt non a panih. ");
INSERT INTO tpz_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Vahvanih köm sosoe nem pan eöꞌ to toto oꞌoah noꞌ e Sosoenën, suk eöꞌ to sosoe ka noꞌ neöm sih pan, ‘Eöꞌ e Koaꞌ pe Sosoenën.’ Keöꞌ a teꞌ ne Sosoenën to vateꞌ voh, pareꞌ vanö maꞌ, köꞌ nö maꞌ manih po oeh vëh.” ");
INSERT INTO tpz_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Eöꞌ se keh hikta nonok noꞌ a ma kiu ne Tamön to nonok non, a, eöm to hikta se vaman nem a ma soe nöꞌ to sosoe noꞌ sih. ");
INSERT INTO tpz_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Eöm se keh rës e nem pa vaman a soe peöꞌ, koe öm keꞌ teꞌ non, paröm koe a vaman eah, ivëhkëk, eöꞌ se keh nok eoꞌ pataeah ne Tamön to nonok non, a, vaman varoe a ma tah me a ma kiu nöꞌ to nonok noꞌ. Suk ataeah, eöꞌ to iu rakah noꞌ pan eöm se nat vavih, paröm kokoman vavih vamanih pan, E Tamön to teꞌ non manih peöꞌ, köꞌ teꞌ varuꞌ e noꞌ peꞌ, kemöm poꞌ to teꞌ tamoaan e nem a paeh a teꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ko Jiuꞌ kehkeh öt hah e ne pe Ieesuꞌ, ivëhkëk, eꞌ to ro aven këh en pee, pareꞌ nö en. ");
INSERT INTO tpz_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","E Ieesuꞌ to ro aven këh o Jiuꞌ, pareꞌ pahan en pap ruen vöh pa ruen nee to popokaꞌ ne a Jödën. Eꞌ to nö, pareꞌ tavus en pa ö vëh ne Jon Tövapupui to taneo voh pa pupui a napan, pareꞌ teꞌ e non nën. ");
INSERT INTO tpz_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ka nap peo rakah nö ee maꞌ manih peꞌ, pare vavaasoe koman e ne pan, “E Jon to hikta nok voh ta tah vatoksean, ivëhkëk, a ma tah neꞌ to sosoe suk voh non pa teꞌ vaꞌih e Ieesuꞌ to tavus vaman ee.” ");
INSERT INTO tpz_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","E Ieesuꞌ to teꞌ non manih pa ö pamëh ka nap peo rakah vaman ee pa soe peꞌ, me a ma tah neꞌ to nonok non. Ivëh, kee nat ee pan, e Ieesuꞌ, eꞌ e Kristo. ");
INSERT INTO tpz_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","A teꞌ nee to popokaꞌ ne e Lasarus to haraꞌ vahat rakah e non pa kamis. Pareꞌ teꞌ non pa vöön nee to popokaꞌ ne Bëtaniꞌ. A vöön pamëh ne Mariaꞌ pen kea peꞌ Martaꞌ to teꞌ ne sih. ");
INSERT INTO tpz_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","E köövo vëh e Mariaꞌ, eꞌ to koꞌ voh a mon e Ieesuꞌ po kompoꞌ, pareꞌ varak o kompoꞌ pamëh pa uvineah, e vameneah Lasarus to haraꞌ non a kamis. ");
INSERT INTO tpz_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ke Mariaꞌ pen Martaꞌ taꞌ ee pa pah teꞌ keꞌ teꞌ en pa soe pee manuh pe Ieesuꞌ, pareꞌ soe ke poë pan, “Topoan, a teꞌ nën to iu vörep nom sih to haraꞌ non a kamis.” ");
INSERT INTO tpz_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","E Ieesuꞌ to pënton a soe vaꞌih, pareꞌ soe pan, “A kamis ne Lasarus to haraꞌ non to hikta teꞌ non pan a kamis neꞌ se mët oah. Ahik, a kamis neꞌ to haraꞌ non eꞌ a kamis to se vataare a napan o kikis pe Sosoenën me a napan se kë a ëhnaneah, ka manih pa hanan pamëh ne Koaꞌ pe Sosoenën se kon suk po ëhnan apuh manih pa napan.” ");
INSERT INTO tpz_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","E Ieesuꞌ to iu vörep rakah non sih a poa tom kea e Martaꞌ pen Mariaꞌ ke vameere Lasarus. ");
INSERT INTO tpz_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","E Ieesuꞌ to nat en pa soe, pareꞌ hikta nö vëvëhöꞌ manuh pa ep e Lasarus. E Ieesuꞌ to teꞌ en po meoh pöök poen manih pa ö neꞌ to teꞌ non. ");
INSERT INTO tpz_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","O pöök poen poë varih to oah ee ke Ieesuꞌ taꞌ en pa ma vamomhë peꞌ, pareꞌ soe pan, “Nös öm ka nö ee manuh pa muhin va Jiutiaꞌ manuh pa vöön pe Lasarus.” ");
INSERT INTO tpz_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ka ma vamomhë peꞌ soe ke poë pan, “Topoan, varuꞌ no Jiuꞌ to kehkeh ip vamët a nom oah po vös nën. Ka kuru nën to kehkeh hah e nom nën, ha?” ");
INSERT INTO tpz_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ke Ieesuꞌ piun rapoë, pareꞌ soe pan, “A havun me ra poa aoaꞌ to te non pa paeh a potan, ha? Ta pah teꞌ se keh nönö vah non pa potan, eꞌ to hikta onöt non a kuꞌ, suk ataeah, eꞌ to ep vavih e non po maaka va po oeh vëh. ");
INSERT INTO tpz_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ivëhkëk, a teꞌ pamëh se keh pönpön vah non pa popoen, eꞌ se kuꞌ en. Suk ataeah, eꞌ to hikta teꞌ non to maaka se vaꞌaus poan keꞌ ep vavih non.” ");
INSERT INTO tpz_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","E Ieesuꞌ to nok a soe vapipinoꞌ vaꞌih, pareꞌ soe pan, “E vamomhë pea Lasarus to koroh varo rakah en. Varuꞌ vakomanih na se nö, köꞌ kunkuin hah eoꞌ peꞌ, keꞌ sun hah en.” ");
INSERT INTO tpz_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ko vamomhë soe ke poë pan, “Ivëhkëk, Topoan, eꞌ se keh koroh varoe non, a kamis se hik këh en peꞌ, keꞌ haraꞌ vavih hah en.” ");
INSERT INTO tpz_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","O vamomhë pe Ieesuꞌ to hikta nat ne pe Ieesuꞌ to sosoe ke non pee pan, e Lasarus to mët vahik en. Ee to koman ne pan e Ieesuꞌ to sosoe ke non raoe pan e Lasarus to koroh akuk e non. ");
INSERT INTO tpz_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ivëh, ke Ieesuꞌ soe vamaaka ke poꞌ en pee pan, “E Lasarus to mët vahik en. ");
INSERT INTO tpz_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Eöꞌ to ep a noꞌ neöm, paröꞌ teꞌ vaeö noꞌ. Suk eöꞌ to hikta teꞌ vaꞌpeh me voh noꞌ eah manih pa poen neꞌ to haraꞌ non a kamis. Ivëh, ko poen nöꞌ se kunkuin taneꞌ hah eah pa mët, köm ep, paröm vaman poꞌ em peöꞌ. Aeoh, nös öm ka nö ee pa ep eah.” ");
INSERT INTO tpz_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","E Ieesuꞌ to sosoe va ko non manih, ke Tömas vëh a meh ëhnaneah e Didimus, soe ke ro upöm vamomhë peꞌ pan, “Aeoh, ka nö vaꞌpeh me e Ieesuꞌ ka napan sih ip vamët a ra, ka mët vaꞌpeh me eah.” ");
INSERT INTO tpz_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","E Ieesuꞌ me ra ma vamomhë peꞌ to nö, pare öök vatët ee manih pa vöön va Bëtaniꞌ, ke Ieesuꞌ nat en pe Lasarus to mët en ko vataanaꞌ poen peꞌ ivëh neꞌ to pet manih koman a top vös. ");
INSERT INTO tpz_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","A hanan to taneꞌ non pa vöön va Bëtaniꞌ, ko vos non Jerusalëm, to onöt non a kukön kiromitaꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","O Jiuꞌ peo to nö maꞌ pa ep pe Martaꞌ pen kea peꞌ Mariaꞌ, to teꞌ vamö koman ne raoe, suk e vameere Lasarus to mët. ");
INSERT INTO tpz_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","E Martaꞌ to pënton en pa soe to soe non pan, e Ieesuꞌ to nö en maꞌ. Eꞌ to sun, pareꞌ tavus këh en pe Mariaꞌ to teꞌ non koman iuun me ra napan, pareꞌ nö en pa ep pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","E Martaꞌ to nö ko ep en pe Ieesuꞌ, pareꞌ soe, “Topoan, eën se keh teꞌ voh nom manih, e vameneoꞌ Lasarus to hikta se mët non, suk eën to teꞌ me nom o kikis va pa vatoꞌ hah o teꞌ varih to haraꞌ ne a ma kamis. ");
INSERT INTO tpz_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ivëhkëk, kuru nöꞌ to nat e noꞌ pe Sosoenën se heꞌ en pën pataeah nën to iu nom, parën hin eah.” ");
INSERT INTO tpz_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ke Ieesuꞌ piun a soe pe Martaꞌ pareꞌ soe pan, “Martaꞌ, e vameomah Lasarus se sun taneꞌ hah en pa mët, pareꞌ kon hah en po toꞌtoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ke Martaꞌ piun a soe pe Ieesuꞌ, pareꞌ soe pan, “Eöꞌ to nat e noꞌ peꞌ se toꞌ hah en po poen no a ma napan kurus se sun taneꞌ hah pa mët me manih po poen no oeh vëh se hik.” ");
INSERT INTO tpz_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ke Ieesuꞌ soe ke poan pan, “Eöꞌ a hanan va pa sun hah pa nap mët, me eöꞌ o toꞌtoꞌ tamoaan. A napan varih to vaman a no neoꞌ, pare mët. Ee se kon ee po toꞌtoꞌ tamoaan. ");
INSERT INTO tpz_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ka napan varih to teꞌ toꞌtoꞌ ne, pare vaman ne a ma soe peöꞌ, ee me hikta se mët ne. Suk ataeah, ee se kon me ee po toꞌtoꞌ tamoaan. Martaꞌ, eën vaman e nom pa soe vaꞌih, keꞌ ahik?” ");
INSERT INTO tpz_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ke Martaꞌ soe pan, “A, Topoan, eöꞌ to vaman e noꞌ pa soe pën, peꞌ eën e Kristo me eën e Koaꞌ pe Sosoenën. Eën a teꞌ ne Sosoenën to soe voh pan eꞌ se vanö maꞌ, keꞌ nö maꞌ manih po oeh marën a kon hah a napan peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","E Martaꞌ to soe vahik va ko manih pe Ieesuꞌ, pareꞌ nö hah en iuun, pareꞌ soe aven ke kea peꞌ Mariaꞌ pan, “E Tövavaasis to nö en maꞌ, pareꞌ teꞌ e non manih, eꞌ to iu non pan eën se nö ko ep in eah.” ");
INSERT INTO tpz_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","E Mariaꞌ to pënton vakomanih, pareꞌ sun ko vëvëhöꞌ rakah en pa ep e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","E Ieesuꞌ to meꞌ avoeꞌ e non pa vos manuh vöön. Eꞌ to teꞌ avoeꞌ e non manih pa ö ne Martaꞌ to ep vu non maꞌ poan. ");
INSERT INTO tpz_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","O Jiuꞌ varih to teꞌ vaꞌpeh me ne e Mariaꞌ koman iuun to vatö ne o kokoman peꞌ, ee to ep in e Mariaꞌ to sun, pareꞌ vëhöꞌ tavus këh en pee, pare vatet ee peꞌ. Suk ataeah, ee to koman ne pan e Mariaꞌ to nö non pa ook manuh po vapeepe. ");
INSERT INTO tpz_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ivëhkëk, e Mariaꞌ to nö ko tavus en pa ö ne Ieesuꞌ to teꞌ non. Mariaꞌ to ep e Ieesuꞌ ko vuꞌ rakah en manih pa moneah, pareꞌ soe ke poan pan, “Topoan, eën se keh teꞌ voh nom manih, e vameneoꞌ Lasarus hikta se mët non.” ");
INSERT INTO tpz_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","E Ieesuꞌ to ep in e Mariaꞌ to okook non me ra napan varih to nö vaꞌpeh me maꞌ poë to okook me ne, pareꞌ haraꞌ vapunis rakah en manih po kupu peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Pareꞌ hi en pee pan, “Eöm vahoꞌ maꞌ a sionineah nih?” Ka napan soe ee pan, “Sunön, maꞌ ah parën ep.” ");
INSERT INTO tpz_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ke Ieesuꞌ vauhunun matan en. ");
INSERT INTO tpz_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ivëh, ko Jiuꞌ varih to teꞌ ne po mët ep e Ieesuꞌ to okook non, pare soe ee pan, “Ep öm, eꞌ to iu suntan rakah e non pa teꞌ vëh.” ");
INSERT INTO tpz_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ivëhkëk o upöm to soe ee pan, “Moaan voh neꞌ to nok vavavih hah a teꞌ kehoꞌ, keꞌ ep vavih hah en, vahvapoꞌnih keꞌ hikta vaꞌaus e Lasarus, keꞌ nat non mët?” ");
INSERT INTO tpz_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","E Ieesuꞌ to haraꞌ vapunis rakah en. Pareꞌ nö en manuh pa top vös. A top vös pamëh to teꞌ non no a meh vös apuh to pet non nee se teꞌ hop a teꞌ mët koman a top vös, pare vahoꞌ pip hah a matan a top vös pamëh. ");
INSERT INTO tpz_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ke Ieesuꞌ soe ke ra napan pan, “Vahuk öm a vös manem.” Ivëhkëk, e Martaꞌ e vamen e Lasarus to soe ke Ieesuꞌ pan, “Sunön, kuru eꞌ o vataanaꞌ poen ne Lasarus to pet manih koman a top vös. Eꞌ to avuh hat en.” ");
INSERT INTO tpz_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ivëhkëk, e Ieesuꞌ to piun poan, pareꞌ soe ke poan pan, “Eöꞌ to soe moaan ke voh eoꞌ pën, eën se keh vaman a nom neoꞌ. Eën to onöt e nom pa ep po kikis pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ivëh, ka napan vahuk ke ee pa vös apuh vëh to sunpip non o hopaꞌ oho koe vëh pa top vös vëh ne Lasarus to pet non. Ke Ieesuꞌ ta peah na kin, pareꞌ soe pan, “Tamön, eöꞌ to soe vavihvih nös oah, suk eën to tënan vahik eom pa hin peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ke eöꞌ koman to nat e noꞌ, a ma tamoaan nën to tëtënan nom sih a ma soe peöꞌ. Ivëhkëk, kuru ne eöꞌ to soe vatvus rakah eöꞌ pa tah vaꞌih, pan a napan varih to kum ne manih, se pënton, pare ep, ko vaman a ö nën to vanö a maꞌ neoꞌ, köꞌ nö maꞌ manih po oeh vëh.” ");
INSERT INTO tpz_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","E Ieesuꞌ to soe vahik vakomanih, pareꞌ vaoe vakis rakah en na pan, “Lasarus, tavus mah.” ");
INSERT INTO tpz_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ke Lasarus tavus këh en maꞌ pa top vös. A poa koreneah me ra poa moneah me a mataneah to pöm avoeꞌ e ne po rara. Ka varuꞌ vakomanih ne Ieesuꞌ to soe ke ra napan pan, “Pureꞌ këh öm eah po rara vëh to pöm non poan, keꞌ nö en.” ");
INSERT INTO tpz_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","A nap peo varih to nö maꞌ po mët, pare tamak vaꞌpeh me e Mariaꞌ to ep a tah ne Ieesuꞌ to nok manih pe Lasarus, pare vaman ee pe Ieesuꞌ, eꞌ e Kristo. ");
INSERT INTO tpz_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ivëhkëk, o upöm to ep a tah ne Ieesuꞌ to nok manih pe Lasarus, pare nö ee manuh po Parësiꞌ, ko uhioꞌ ke pee pa ma taeah neꞌ to nok ee he ep ne. ");
INSERT INTO tpz_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ivëh, ko teꞌ sunön ësës heꞌ, me ro Parësiꞌ vaoe ee po Kum Teꞌ Susunön po Jiuꞌ, kee nö maꞌ, kee ihoꞌ ko vahutët suk ee pa ö nee se nok vah va in e Ieesuꞌ, pare soe pan, “Ea se nok va in a teꞌ vëh nih to nonok vatëh non o tah vatoksean o pöh peo? ");
INSERT INTO tpz_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ea se keh ep akuk no eah, keꞌ nonok avoeꞌ nö e non pa taateꞌ vaꞌih. A napan kurus va pea se vaman poë ko vatet poë, ka nap vavapus va Room nö maꞌ, ko miröꞌ ee pa Iuun Hinhin Apuh pea me ra napan pea.” ");
INSERT INTO tpz_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ivëhkëk, eꞌ to teꞌ non a pah teꞌ to teꞌ non po komön o kum pamëh, a ëhnaneah e Kaëfas. Manih po kirismas pamëh ne Kaëfas to teꞌ non a Teꞌ Susun po Teꞌ Ësës Heꞌ. E Kaëfas to soe ke raoe pan, “Eöm kurus varih po kum vëh, eöm to hikta teꞌ me nem to kokoman. ");
INSERT INTO tpz_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Eöm to hikta nat kës ko nem pa taateꞌ to vaꞌaus a rora to soe va non manih pan, eꞌ to vih non pa pah teꞌ se kon a tasun pa napan pea varih Israël, pareꞌ mët. Peꞌ to hikta vih non pa napan pea se ro kurus manih pa koreera nap vëvënsun va Room.” ");
INSERT INTO tpz_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","E Kaëfas to soe a soe vaꞌih, eꞌ hikta koman hah a non. Manih po kirismas pamëh neꞌ to teꞌ non eꞌ a Teꞌ Susun po Teꞌ Ësës Heꞌ. Eꞌ to vanënën a soe to soe non pan, e Ieesuꞌ se mët, pareꞌ vaꞌaus a napan va Israël. ");
INSERT INTO tpz_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","A mët pe Ieesuꞌ to hikta se vaꞌaus varoe non a napan va Israël. Ahik, a mët peꞌ eꞌ a mët marën a ununun a napan kurus, kee tönun, pare tavus ee o pöh kum teꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Taneo non po poen pamëh no a nap susunön po Jiuꞌ to nok ee po kokoman va pa ip vamët e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ivëh, ne Ieesuꞌ to hikta nönö vateeraꞌ suk vah non topniira napan va Jiuꞌ. Eꞌ to këh en pa vöön nee to teꞌ ne. Eꞌ to nö, pareꞌ teꞌ non pa vöön nee to popokaꞌ ne Efraëm. A vöön pamëh to teꞌ vatët non manih pa moeh upin, pareꞌ teꞌ vaꞌpeh me non o vamomhë peꞌ nën. ");
INSERT INTO tpz_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Eꞌ to öök vatët en po poen va pa taëën apuh po Jiuꞌ nee to popokaꞌ ne o Pasovaꞌ. Ka nap peo va Israël to nö ee Jerusalëm pa nok a ma taneah nee se ës ke na e Sosoenën. Ka ma tah poë varih ës, kee tavus ee o teꞌ vivihan vamanih pa ö no Vavaasis pe Mosës to soe va non. ");
INSERT INTO tpz_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","O Jiuꞌ to kiu vëhvaꞌ rakah ee pa ep këh e Ieesuꞌ, ee to sun ne koman a Iuun Hinhin Apuh. Pare ihi ne o upöm pee pan, “Eöm koman kës nem pan, eꞌ se nö en maꞌ manih po poen apuh va pa hin pea, keꞌ ahik?” ");
INSERT INTO tpz_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","O teꞌ susunön ësës heꞌ, me ro Parësiꞌ to soe ke ra napan pan, ta pah teꞌ se keh nat non pa ö ne Ieesuꞌ to teꞌ non, eꞌ se soe vanat rapoë kee nö, pare öt poë ko vahoꞌ poë pa nohnoh. ");
INSERT INTO tpz_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","O tönim me o pöh poen to meꞌ avoeꞌ e ne pa tavus ka taëën apuh va po Pasovaꞌ tavus en. Ke Ieesuꞌ nö en pa vöön ne Lasarus to teꞌ non. A ëhnan a vöön pamëh nee to popokaꞌ ne a Bëtaniꞌ. Ke Lasarus, eꞌ a teꞌ ne Ieesuꞌ to kunkuin taneꞌ hah voh poan pa nap mët. ");
INSERT INTO tpz_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Manih pa vöön pamëh nee to nöhnöh ke Ieesuꞌ a taëën, a taëën pamëh to makah vahik en, ke Martaꞌ kunkun non a taëën e Lasarus heh ihoꞌ vaꞌpeh me non a napan varih to ënëën me ne e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ke Mariaꞌ kea pe Martaꞌ teꞌ en maꞌ po siꞌ puto vanom o pöh voen vaꞌpuh rakah. O vanom pamëh nee to nok voh po tah nee to popokaꞌ ne o naat. Pareꞌ koꞌ manih pa mon e Ieesuꞌ, ko varak o vanom pamëh pa uvineah. Ko avuh vih va po vanom pamëh puh rakah en pa koman iuun nee to ënëën ne. ");
INSERT INTO tpz_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ivëhkëk, a paeh a vamomhë koman pe Ieesuꞌ ivëh e Jiutas va Iskariot, eꞌ a teꞌ pamëh se vikuh amot e Ieesuꞌ manih po teꞌ varih to hat o ve ne poë to soe pan, ");
INSERT INTO tpz_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Vahvanih ke köövo vëh to hikta vavoen o vanom manih po upöm teꞌ, ka kon a 300 voaꞌ moniꞌ koman pea, para vaꞌaus o teꞌ arus?” ");
INSERT INTO tpz_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ivëhkëk, e Jiutas to hikta koman tiroëꞌ non a nap arus. Ahik, eꞌ to soe a soe vaꞌih, suk eꞌ a teꞌ kakaveo. Keꞌ eꞌ me a teꞌ pamëh to matop non sih a moniꞌ pee, pareꞌ kakaveo tamoaan non sih a moniꞌ to pet non po kove moniꞌ pamëh. ");
INSERT INTO tpz_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ke Ieesuꞌ pënton a soe ne Jiutas to sosoe non, pareꞌ soe ke poan pan, “Koe e köövo vëh, keꞌ öt non o vanom vëh keꞌ onöt po poen nöꞌ se mët, köm pe a neoꞌ po vapeepe. ");
INSERT INTO tpz_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","A nap arus to teꞌ tamoaan me e ne sih peöm, peöꞌ to hikta se teꞌ tamoaan me a noꞌ neöm.” ");
INSERT INTO tpz_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","A nap peo va Israël to tënan a soe to soe non pan, e Ieesuꞌ to teꞌ non manih pa vöön va Bëtaniꞌ. Ivëh, nee to nö suk ee nën, ee to hikta nö varoe pa ep e Ieesuꞌ. Ahik, ee to nö me ee pa ep pa teꞌ vëh ne Ieesuꞌ to kunkuin taneꞌ hah voh poan pa nap mët, ivëh e Lasarus. ");
INSERT INTO tpz_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ko teꞌ susunön ësës heꞌ nok ee po kokoman vakoaan va pa ip vamët me e Lasarus. ");
INSERT INTO tpz_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Suk ataeah, a nap peo va Israël to kokoman hah a tah ne Ieesuꞌ to nok voh pö neꞌ to kunkuin taneꞌ hah e Lasarus pa nap mët. Ee to heꞌ tonun ee po teꞌ ësës heꞌ, pare vaman vaviꞌ e ne pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ko meoh poen, no a nap peo varih to vaman ne e Ieesuꞌ, to nö ee Jerusalëm, ko poen pamëh eꞌ o poen apuh va po Pasovaꞌ. Ee to pënton a soe va pa ö ne Ieesuꞌ to nönö nö non maꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ivëh, kee kon a ma pea vito, pare öhön poë manih hanan. Ee to akeh poë, pare haraꞌ vaeö rakah, pare tataoa ne, pare sosoe ne pan, “Vaeö ke na e Sosoenën! E Sosoenën se tapui a oah Suk eën to nö maꞌ pa ëhnan e Sunön, Pareꞌ tapui e Sunön va Israël.” ");
INSERT INTO tpz_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","E Ieesuꞌ to kon a tönkiꞌ, pareꞌ tok pa tonuneah, ka tah vaꞌih ne Ieesuꞌ to nok pö neꞌ to tok pa tonun a tönkiꞌ sekaꞌ to vapuh rakah en pa soe to kiun non po Puk pe Sosoenën no a teꞌ vanënën soe vëh e Sëkaraëaꞌ to kiun voh, ka soe pamëh to soe va non manih pan, ");
INSERT INTO tpz_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Koe a naöp, ta Israël, a teꞌ sunön peöm to nö en maꞌ. Pareꞌ ihoꞌ non pa tonun tönkiꞌ sekaꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Po vamomoaan no ma vamomhë peꞌ to hikta nat vamaaka ne pa pusun in a soe vaꞌih. Ivëhkëk, murin in o poen ne Ieesuꞌ to sun taneꞌ hah pa mët, pareꞌ kon o ëhnan apuh. O vamomhë peꞌ to maaka man poꞌ ee pa pusun in a soe pamëh to takiun non manih po Puk pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","A nap peo rakah to teꞌ vaꞌpeh me voh ne e Ieesuꞌ po poen neꞌ to vatoꞌ hah e Lasarus, ko vavoe tavus këh na eah pa ö vëh nee to pe voh poë. Ivëh, ka napan varih to ep voh ne pa tah ne Ieesuꞌ to nok manih pe Lasarus, to vavatët pet ee po upöm pee pataeah to tanok. ");
INSERT INTO tpz_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","A nap peo to pënton a soe va pa ö ne Ieesuꞌ to kunkuin taneꞌ hah e Lasarus pa nap mët, to nö ee pa ep peꞌ manih hanan. ");
INSERT INTO tpz_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ko Parësiꞌ vavaasoe koman e ne pan, “Ep këk öm! A napan kurus to vataruin suk ee pa teꞌ vëh, ka tah na to kehkeh nok no pa sunpip a napan pa vatet e Ieesuꞌ to hikta onöt non a man.” ");
INSERT INTO tpz_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Eꞌ to teꞌ me voh non a ma pah to Grik to nö maꞌ manih Jerusalëm pa vasunön e Sosoenën po poen va pa Taëën Apuh va po Pasovaꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","A ma to Grik poë varih to nö ee pa ep e Filip, e Filip eꞌ a teꞌ va Bëtsaëtaꞌ, ka muhin peꞌ ivëh Galiliꞌ. Ka ma to Grik poë varih to soe ke poë pan, “Topoan, emöm to kehkeh ep nem pe Ieesuꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ke Filip soe ke Ëndruꞌ, kee nö ee pon pa soe ke Ieesuꞌ a ö no a ma to Grik to kehkeh ep ne poë. Ee to nö pare tavus manih pe Ieesuꞌ, pare soe ke poë pan, “A ma to Grik to kehkeh ep ne pën.” ");
INSERT INTO tpz_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ke Ieesuꞌ piun va in a soe pee manih pan, “O poen ne Sosoenën se kon o ëhnan apuh manih peöꞌ e Koaꞌ Teꞌ pa Napan Kurus to öök en. Manih pa ö nöꞌ se mët ko sun taneꞌ hah pa mët, paröꞌ hah eoꞌ pa vöön va kin. ");
INSERT INTO tpz_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Eöꞌ to soe vamaman rakah keoꞌ peöm, o voaꞌ kon vëh ne ea to poꞌpoꞌ eah manih po oeh, se pisiꞌ maꞌ, pareꞌ voaꞌ vapeo en. Ivëhkëk, eꞌ se keh hikta pisiꞌ momoaan, eꞌ se teꞌ avoeꞌ e non o pöh voaꞌ kon ro. ");
INSERT INTO tpz_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Eꞌ to teꞌ akuk va kov e non manih pan ta pah teꞌ se keh iu suntan non o toꞌtoꞌ peꞌ manih po oeh vëh, o toꞌtoꞌ peꞌ se ro amot en. Ivëhkëk, a teꞌ vëh to heꞌ tonun o toꞌtoꞌ peꞌ manih po oeh. Eꞌ se kon en po toꞌtoꞌ tamoaan. ");
INSERT INTO tpz_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","A teꞌ vëh to nonok non sih a ma kiu peöꞌ, eꞌ se vavatet rakah non a soe me a taateꞌ peöꞌ. Ka vöön nöꞌ to teꞌ noꞌ, no o teꞌ kikiu peöꞌ se teꞌ vaꞌpeh me e ne peöꞌ. Ka teꞌ vëh to nonok non a ma a kiu peöꞌ, e Tamön vöh pa vöön va kin se kë en peꞌ, pareꞌ heꞌ en peꞌ po ëhnan apuh. ");
INSERT INTO tpz_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","E Ieesuꞌ to vavaato avoeꞌ me e non pa nap susunön po Jiuꞌ, pareꞌ soe pan, “Kuru nöꞌ to haraꞌ vahat rakah eoꞌ, ko kokoman peöꞌ punis rakah en, köꞌ koman pinpiun eoꞌ. Keöꞌ koman se poꞌ soe vahvanih? Eöꞌ se pöꞌ soe eoꞌ pan, ‘Tamön, kuru eöꞌ to iu noꞌ a ö nën se kon këh a neoꞌ pa punis vaꞌih to kehkeh tavus non peöꞌ. Ivëhkëk ahik, suk ataeah, eꞌ akuk kuru a pusun in a ö nöꞌ to nö suk voh maꞌ manih po oeh vëh. ");
INSERT INTO tpz_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tamön, eën koman se vataare o kikis apuh pën!’” E Ieesuꞌ to sosoe va ko non manih, ka to kunah taneꞌ maꞌ pa vöön va kin to soe vanon manih pan, “Eöꞌ to vataare voh eoꞌ po kikis peöꞌ, köꞌ se nok hah va eoꞌ nën.” ");
INSERT INTO tpz_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","A napan to sun vatët ne nën to tënan a to pamëh to kunah taneꞌ maꞌ pa vöön va kin, pare koman ne pan, a kara to kukuruh non, ko upöm to koman ne pan a ankeroꞌ to vavaato me non maꞌ poan. ");
INSERT INTO tpz_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ke Ieesuꞌ piun a soe pee, pareꞌ soe pan, “A to vaꞌih nöm to pënton nem, eꞌ a to marën a vaꞌaus a neöm, eꞌ to hikta teꞌ non pan, eꞌ se vaꞌaus a neoꞌ. Ahik. Eꞌ marën a vaꞌaus a neöm. ");
INSERT INTO tpz_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kuru eꞌ o poen ne Sosoenën se kiiki a taateꞌ pa napan va po oeh vëh. Ka kuru me, ne Sosoenën se veo kunah en pa teꞌ susun vëh to matop non a ma taateꞌ hat manih po oeh vëh. ");
INSERT INTO tpz_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kuru ne eöꞌ to teꞌ noꞌ manih po oeh vëh. Ivëhkëk amot, no a napan va po oeh vëh se vahan ee peöꞌ köꞌ han noꞌ pa kuruse. Manih pa poen pamëh nöꞌ se peret ke ra napan kurus a hanan, kee nö ee maꞌ peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","A soe vaꞌih ne Ieesuꞌ to sosoe non, eꞌ a soe neꞌ to sosoe vanat non a napan a ö neꞌ se mët vah ava. ");
INSERT INTO tpz_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ka napan piun a soe peꞌ pare soe ke poë pan, “Emöm to pënton taneꞌ voh a soe vaꞌih manih po Vavaasis pe Mosës. O Vavaasis pe Mosës to soe non pan e Kristo se teꞌ tamoaan non manih po oeh. Vahvapoꞌnih kën soe pan, ‘A napan se vahan e Koaꞌ Teꞌ Pa Napan Kurus to han non manih pa kuruse?’ Eteh poꞌ, E Koaꞌ Teꞌ Pa Napan Kurus?” ");
INSERT INTO tpz_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ke Ieesuꞌ soe ke raoe pan, “O maaka pamëh se teꞌ vaꞌpeh me a no neöm pa siꞌ poen kökööt akuk, eꞌ hikta se teꞌ varë me a no neöm. Ivëh, ko maaka pamëh se teꞌ vaꞌpeh me a no neöm, köm nönö vah nem, peꞌ to hat non peöm se pönpön vah nem pa popoen. A teꞌ vëh to pönpön vah non pa popoen eꞌ to hikta nat non eꞌ nönö non nih. ");
INSERT INTO tpz_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kuru no maaka pamëh to teꞌ vaꞌpeh avoeꞌ me non peöm. Ivëh, köm se vaman rakah o maaka pamëh pa ö neꞌ to teꞌ avoeꞌ me a no neöm manih po oeh, köm sih tavus o pus koaꞌ va po maaka pamëh.” Eꞌ to soe vahik vakomanih, pareꞌ aven këh en pee pareꞌ nö en. ");
INSERT INTO tpz_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","A nap peo rakah to ep voh ne a ma tah vatoksean ne Ieesuꞌ to nonok non, ivëhkëk, ee to hikta vaman ne poë. ");
INSERT INTO tpz_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Keꞌ a tah pamëh to vamaaka rakah en pa soe no a teꞌ vanënën soe vëh e Aisaëaꞌ to sosoe suk voh non, pareꞌ soe pan, “Sunön, etereh to vaman ne a soe na to sosoe ke voh no raoe poꞌ? Me etereh to inan ne pa ma kiu eh varih ne Sunön to nonok non po kikis peꞌ?” ");
INSERT INTO tpz_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Keꞌ ivaꞌih a pusun in a ö no a napan va Israël to hikta onöt ne a vaman suk e Ieesuꞌ, e Aisaëaꞌ to kuin voh a soe to soe non pan, ");
INSERT INTO tpz_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“E Sosoenën to kekehoꞌ en pee, pareꞌ vavanun en pa ma kokoman pee. Suk ee tomeꞌ ep in ta kiu apuh pa matëëre, pare nat ee pa pusun in a soe pamëh, pare panih a ma kokoman pee, pare nö maꞌ peöꞌ köꞌ vatoꞌ hah raoe.” ");
INSERT INTO tpz_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","E Aisaëaꞌ to nok a soe vaꞌih, suk eꞌ to tata o kikis apuh to teꞌ non manih pe Ieesuꞌ, pareꞌ sosoe suk non poan pa soe vaꞌih. ");
INSERT INTO tpz_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","A nap peo, me ra nap apaꞌpuh po Jiuꞌ to vaman e ne pe Ieesuꞌ. Ivëhkëk, ee to nanaöp e ne po Parësiꞌ. Pare hikta onöt ne a vatvus o vaman pee. Ee to nanaöp ne pan o Parësiꞌ tomeꞌ veo tavus këh ee pee pa ma iuun hinhin soneꞌ pee. ");
INSERT INTO tpz_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ee to iu ne pan, a napan se kë varoe ne a ma ëhnëëre, pare nat ne kë ne a teꞌ ëhnan e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","E Ieesuꞌ to tooto suntan rakah e non, pareꞌ soe pan, “Eteh to vaman a non neoꞌ eꞌ to hikta vaman varoe a no neoꞌ eꞌ to vaman me e non pa Teꞌ vëh to vanö voh a maꞌ neoꞌ köꞌ nö maꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Keteh to ep a non neoꞌ, eꞌ to ep me non pa Teꞌ vëh to vanö voh a maꞌ neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Eöꞌ to nö vavoh maꞌ manih po maaka va po oeh vëh. Ivëh, ketereh to vaman ne a ma soe peöꞌ, ee to hikta onöt ne a teꞌ pa popoen. ");
INSERT INTO tpz_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Etereh to tënan ne a soe peöꞌ, pare hikta vaman ne a soe pamëh, a, eöꞌ to hikta se kiiki noꞌ raoe vamanih pe tökiiki. Suk eöꞌ to nö voh maꞌ pa kon hah a napan va po oeh vëh. ");
INSERT INTO tpz_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Eꞌ to teꞌ non a tökiiki teꞌ, pe retereh to heꞌ tonun a neoꞌ pare hikta kon a ma soe peöꞌ. Ka soe nöꞌ to sosoe noꞌ, eꞌ a soe ko pamëh se kiiki o teꞌ poë varih po poen no oeh vëh se hik. ");
INSERT INTO tpz_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ka tah nöꞌ to sosoe noꞌ, eꞌ to hikta teꞌ non pan, eꞌ a soe koman peöꞌ. Ahik, e Tamön vëh to vanö voh a maꞌ neoꞌ to soe ka neoꞌ a tah nöꞌ se soe me a tah nöꞌ se vavaasis. ");
INSERT INTO tpz_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ivëh, köꞌ nat e noꞌ po toꞌtoꞌ tamoaan to taneꞌ non maꞌ manuh pa soe pe Tamön. Ka tah nöꞌ to sosoe no, eꞌ a tah ne Tamön to soe voh ka neoꞌ, köꞌ sosoe noꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","A siꞌ ö hat ko poen va pa Taëën Apuh va po Pasovaꞌ tavus en, ke Ieesuꞌ nat en po poen neꞌ se këh hah o oeh vëh, pareꞌ nö hah en manuh pe Tamaneah to öök en. Eꞌ to iu non a ma vamomhë peꞌ varih to teꞌ ne sih manih po oeh, keꞌ onöt rakah po poen neꞌ se mët. ");
INSERT INTO tpz_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pa matanpoen ne Ieesuꞌ me ra ma vamomhë peꞌ to ënëën ne, ke susun po oraꞌ hat heꞌ en pe sunaiꞌ Saëmon va Kariot e Jiutas po kokoman hat, keꞌ heꞌ tonun e Ieesuꞌ ko vikuh en peꞌ manih po teꞌ varih to vakihat me ne poë. ");
INSERT INTO tpz_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","E Ieesuꞌ to nat e non pe Tamaneah to vahoꞌ vahik voh en pa ma moeh tah kurus manih pa koreneah, pareꞌ nat me e non peꞌ to taneꞌ voh maꞌ manuh pe Sosoenën. Eꞌ to nat me e non peꞌ se hah en manuh pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ivëh, keꞌ sun taneꞌ maꞌ manih pa pok vëh no a ma taëën to tok ne, pareꞌ ihan o ohop rë peꞌ, ko kon o taöör pareꞌ voh tavi manih pa vuvuhuneah. ");
INSERT INTO tpz_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Eꞌ to koꞌ a ruen pa kepaꞌ ko pupui en pa ma moeera ma vamomhë peꞌ, ko varak en pee po taöör neꞌ to voh non. ");
INSERT INTO tpz_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Eꞌ to öök maꞌ manih pe Saëmon Pitaꞌ, keꞌ hi poan pan, “Sunön, eën se pupui me eom pa moneoꞌ oh?” ");
INSERT INTO tpz_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ke Ieesuꞌ piun a soe pe Pitaꞌ pareꞌ soe ke poan pan, “Eën to hikta nat nom pataeah nöꞌ to nonok kuru, ivëhkëk, eën se nat amot eom pataeah ipamëh” ");
INSERT INTO tpz_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ke Pitaꞌ piun a soe pe Ieesuꞌ pareꞌ soe pan, “Ahik, eën se nat rakah nom pupui a moneoꞌ.” Ivëhkëk, e Ieesuꞌ to piun a soe peꞌ pareꞌ soe pan, “Eöꞌ se keh hikta pupui a momah, eën hikta se teꞌ nom e vamomhë peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ke Pitaꞌ soe ke Ieesuꞌ pan, “Sunön, koe a pupui varoe a moneoꞌ. Eën se pupui me eom pa koreneoꞌ me a pasuneoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","E Ieesuꞌ to soe ke poan pan, “A teꞌ vëh to uhu vahik voh eꞌ to hikta onöt non a uhu hah. Suk ataeah, eꞌ to voon vahik voh en, pareꞌ onöt varoe ko non a pupui a moneah. Eöm kurus varih to voon vahik voh em, ivëhkëk, a paeh va peöm to hikta teꞌ voon non.” ");
INSERT INTO tpz_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","E Ieesuꞌ to nat vahik en pa teꞌ vëh se heꞌ tonun poan, pareꞌ vikuh in poan manih po teꞌ to vakihat me ne poë, ivëh, neꞌ to soe suk vamanih pan, “Eöm kurus o voon vahik, ivëhkëk, a paeh va peöm to hikta teꞌ voon non.” ");
INSERT INTO tpz_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","E Ieesuꞌ to pupui vahik a ma moera ma vamomhë peꞌ, ko ohop hah en po ohop rë peꞌ, pareꞌ nö ko ihoꞌ hah en pa ö ihihoꞌ peꞌ, pareꞌ hi raoe pan, “Eöm nat poꞌ pöꞌ e nem pa tah nöꞌ to nok manih peöm, toh? ");
INSERT INTO tpz_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Eöm to popokaꞌ e nem sih peöꞌ, e Sunön, e Tövavaasis. Keꞌ vih e non pa ö nöm se popokaꞌ va e nem peöꞌ nën, suk ataeah, eöꞌ to teꞌ va kov e noꞌ nën. ");
INSERT INTO tpz_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Eöꞌ se keh teꞌ vamaman e noꞌ e Sunön, e Tövavaasis peöm, to pupui a ma moeeneöm, a, eöm pet me se pupui a ma moeero upöm teꞌ pea. ");
INSERT INTO tpz_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Eöꞌ to nok a tah vaꞌih manih peöm vamanih po vëknöm, eꞌ marën a vataare a neöm a taateꞌ nöm se vavatet amot nem. ");
INSERT INTO tpz_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Eöꞌ toꞌ soe vamaman rakah keoꞌ peöm. A teꞌ kikiu to hikta antoen non a teꞌ oah e susun peꞌ, ka teꞌ teꞌteꞌ soe eꞌ me to hikta se teꞌ oah non a teꞌ vëh to vanö poan. ");
INSERT INTO tpz_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Eöm se keh nat vavih nem po pus kokoman va pa tah vaꞌih nöꞌ to nok manih peöm, eöm se haraꞌ vaeö rakah e nem pa nok pet a taateꞌ pamëh. Ivëh, ne Sosoenën se vaeö suk pet me a no neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Eöꞌ to hikta sosoe suk a noꞌ neöm kurus, ahik! Eöꞌ to nat e noꞌ pe retereh nöꞌ to kon raoe kee tavus ee o teꞌ peöꞌ, ivëh köꞌ nat e noꞌ pa soe to pet non po Puk pe Sosoenën to tavus vaman en. O Puk pe Sosoenën to soe non pan, ‘A teꞌ vëh to ënëën vaꞌpeh me a no neoꞌ a taëën vëh, eꞌ kuru a teꞌ ko pamëh se kë a moneah, pareꞌ kom tötöön en peöꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Eöꞌ to soe vovoh ke voh eoꞌ peöm pa tah pamëh, eꞌ he meꞌ avoeꞌ e non pa tavus maꞌ. Amot no a tah pamëh se tavus, köm ep paröm vaman poꞌ em peöꞌ e Kristo. ");
INSERT INTO tpz_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Eöꞌ to soe vamaman rakah keoꞌ peöm, eteh to öt a teꞌ kikiu nöꞌ to vanö nös, pareꞌ matop vavih non poan, eꞌ to öt me en peöꞌ, pareꞌ nok vavih me en peöꞌ. Me eteh to öt a neoꞌ, eꞌ to öt me en pe Sosoenën vëh to vanö voh a maꞌ neoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","E Ieesuꞌ to soe vahik vakomanih, ko kokoman peꞌ puh rakah en po tamak keꞌ pah soe suntan en pan, “Eöꞌ to soe vaman rakah keoꞌ peöm, a paeh koman va peöm varih o vamomhë peöꞌ ivëh, se vikuh ka neoꞌ manih pa napan varih to vakihat me a ne neoꞌ sih.” ");
INSERT INTO tpz_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","E Ieesuꞌ to sosoe va ko non manih ka ma vamomhë peꞌ va kukuteꞌ matan ee, suk ataeah, ee to hikta nat ne peteh ivëh, neꞌ to sosoe suk non. ");
INSERT INTO tpz_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","A paeh a vamomhë ne Ieesuꞌ to iu suntan non sih poan to teꞌ vatët non manih peꞌ pa ö ënëën pee. ");
INSERT INTO tpz_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ke Saëmon Pitaꞌ vaviivi pasun ke vamomhë vëh to teꞌ vatët non pe Ieesuꞌ, pareꞌ soe ke poan pan, “Hi a neah, eꞌ sosoe suk non eteh?” ");
INSERT INTO tpz_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ke vamomhë vëh to vahoꞌ na pasuneah manih pe Ieesuꞌ to hi poan pan, “Sunön, eën sosoe suk nom eteh?” ");
INSERT INTO tpz_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ke Ieesuꞌ piun a hi peꞌ, pareꞌ soe ke raoe pan, “Eöꞌ se vahoꞌ a ö taëën manih pa hiroꞌ, paröꞌ heꞌ a teꞌ pamëh. Eꞌ akuk kuru a teꞌ pamëh se vikuh ka neoꞌ.” E Ieesuꞌ to vavaato vahik va ko non manih, pareꞌ vahoꞌ en pa ö taëën manih pa hiroꞌ, pareꞌ heꞌ en pe Jiutas, sunaiꞌ e Saëmon va Kariot. ");
INSERT INTO tpz_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","E Jiutas to ëën vahik en pa ö taëën pamëh, ke susun po oraꞌ hat hop en peꞌ ko heꞌ en peꞌ po kokoman hat. Ke Ieesuꞌ soe ke poꞌ en peꞌ pan, “A tah nën to kehkeh nok nom nën se nok vëvëhöꞌ rakah.” ");
INSERT INTO tpz_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","A hikta pah teꞌ to teꞌ non manih pa ö ënëën to nat non pa pusun in a soe vaꞌih ne Ieesuꞌ to sosoe ke non e Jiutas. ");
INSERT INTO tpz_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","E Jiutas to matop non sih a pokis moniꞌ, ivëh, ka ma meh vamomhë koman ne pan e Ieesuꞌ to sosoe ke non poan a ö neꞌ se voen ta meh taëën va pa taëën apuh va po Pasovaꞌ. Me a ö nee to koman ne pan e Ieesuꞌ to taꞌtaꞌ non e Jiutas teꞌ heꞌ o teꞌ arus ta ma tah. ");
INSERT INTO tpz_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","E Jiutas to öt a ö taëën ne Ieesuꞌ to heꞌ poan, ko tavus vëvëhöꞌ rakah en. A muhin he poen en. ");
INSERT INTO tpz_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","E Jiutas to tavus en, ke Ieesuꞌ soe ke ra ma vamomhë peꞌ pan, “Kuru neöꞌ e Koaꞌ Teꞌ pa Napan Kurus se vataare eoꞌ po kikis apuh peöꞌ. E Sosoenën me se vataare en po kikis apuh peꞌ manih peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","E Sosoenën se keh vataare o kikis apuh peꞌ manih peöꞌ e Koaꞌ Teꞌ Peꞌ, a, e Sosoenën koman se vataare a napan o kikis me a vih peöꞌ e Koaꞌ Teꞌ pa Napan Kurus. ");
INSERT INTO tpz_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Pus koaꞌ peöꞌ, eöꞌ hikta se teꞌ varë hah me a noꞌ neöm. Eöm se ruꞌ em peöꞌ, ivëhkëk kuru, nöꞌ to soe keoꞌ peöm pa ö nöꞌ to soe moaan vavoh in o teꞌ susunön po Jiuꞌ. Ka vöön nöꞌ to nönö noꞌ, nöm to hikta onöt nem a nö nën. ");
INSERT INTO tpz_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ivëh, ka kuru, eöꞌ to heꞌ eoꞌ peöm pa taateꞌ voon, ka taateꞌ voon pamëh to soe va non manih pan, ‘Iu a ma meh peöm.’ Eöm se iu nem a ma meh peöm vamanih pa ö nöꞌ to iu va ka noꞌ neöm sih. ");
INSERT INTO tpz_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Eöm se keh iu nem a ma meh peöm, a, a napan kurus se nat ee peöm a ma vamomhë peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ke Saëmon Pitaꞌ hi e Ieesuꞌ pan, “Sunön, eën nönö nom nih?” Ke Ieesuꞌ piun a hi peꞌ, pareꞌ soe ke poan pan, “A vöön nöꞌ to nö noꞌ nën to hikta antoen nom a suk a neöꞌ parën nö nën. Ivëhkëk, amot ne eën se suk eom maꞌ peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ke Pitaꞌ hi hah e Ieesuꞌ, pareꞌ soe pan, “Sunön, vahvanih, köꞌ hikta onöt noꞌ a suk a oah pa vöön nën to nönö nom? Kuru eöꞌ to antoen e noꞌ pa mët pa kon a tasun pën.” ");
INSERT INTO tpz_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ke Ieesuꞌ piun e Pitaꞌ, pareꞌ soe pan, “Eën antoen e nom pa mët pa kon a tasun peöꞌ, ha? Eöꞌ to soe vamaman rakah keoꞌ pën, e toaꞌ oeteꞌ se meꞌ avoeꞌ e non pa tö, kën kukön soe eom pan, eën to hikta nat nom peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","E Ieesuꞌ to vavaato avoeꞌ me e non pa ma vamomhë peꞌ, pareꞌ soe ke raoe pan, “Eöm se koe a heꞌ ëm o tamak me o punis, paröm vaman varoe e Sosoenën ko vatet eah, paröm vaman me a neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Manuh pa vöön va kin pa iuun pe Tamön a ma ö teꞌteꞌ peo rakah to teꞌ ne nën. Keöꞌ se vovoh manuh, paröꞌ vamatop maꞌ a ma ö teꞌteꞌ peöm. A soe peöꞌ se keh hikta teꞌ va non nën, eöꞌ to hikta onöt noꞌ a soe vanat a neöm a tah pamëh. ");
INSERT INTO tpz_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Keöꞌ se vovoh, paröꞌ vamatop maꞌ a ma ö teꞌteꞌ peöm, paröꞌ hah maꞌ ko me a na neöm, ka nö, para teꞌ vaꞌpeh no pa vöön pamëh. Ivëh, ka vöön poanheh nöꞌ se teꞌ noꞌ, eꞌ a vöön ko pamëh na se pët teꞌ vaꞌpeh tamoaan no nën. ");
INSERT INTO tpz_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Eöm to nat e nem pa hanan to nö non pa vöön nöꞌ to nönö noꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ivëhkëk, e Tömas to soe ke Ieesuꞌ pan, “Topoan, emöm to hikta nat nem pa ö nën to nönö nom. Emöm se poꞌ nat vah va in a hanan vëh nih nën to suksuk nom?” ");
INSERT INTO tpz_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ke Ieesuꞌ piun a soe pe Tömas, pareꞌ soe pan, “Eöꞌ koman a hanan, me eöꞌ koman a pusun in a soe man, me eöꞌ koman o toꞌtoꞌ tamoaan. A pah hanan ro ko vëh to nö non pe Tamön, ivëh, eöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Eöm se keh nat vavih e nem peöꞌ eteh, eöm se nat vavih me e nem pe Tamön eteh. Ivëhkëk kuru, neöm to nat em pe Tamön. Paröm inan vahik em peꞌ, suk eöm to ep e nem peöꞌ to matan va e noꞌ manih peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ke Filip soe ke Ieesuꞌ pan, “Sunön, a tah rakah nemöm to iu nem ivëh, vataare a möm ah, e Tamön.” ");
INSERT INTO tpz_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ke Ieesuꞌ piun a soe pe Filip pareꞌ soe ke poan pan, “Filip a tëëm rë rakah neöꞌ to teꞌ vaꞌpeh me voh eoꞌ peöm, ivëhkëk, eöm hikta nat avoeꞌ nem peöꞌ eteh. Eteh to inan a non neoꞌ, eꞌ to inan me en pe Tamön, vahvapoꞌnih köm soe ka neoꞌ pan, ‘Eöꞌ se vataare a neöm e Tamön?’ ");
INSERT INTO tpz_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Eën to hikta vaman pöꞌ ko nom pan e Tamön to teꞌ vaꞌpeh me non peöꞌ. Köꞌ teꞌ vaꞌpeh me e noꞌ peꞌ. A soe nöꞌ to sosoe ka noꞌ neöm sih, nöꞌ to hikta kokon taneꞌ noꞌ po kokoman koman peöꞌ. Ahik, e Tamön to teꞌ vaꞌpeh tamoaan me e non sih peöꞌ, pareꞌ vavatvus ke non a ma kiu peꞌ manih peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Vaman a neoꞌ öm to sosoe ka noꞌ neöm sih pan, eöꞌ to teꞌ vaꞌpeh me noꞌ pe Tamön. Ke Tamön teꞌ vaꞌpeh me e non peöꞌ. Eöm se keh hikta vaman nem a soe vaꞌih, eöm se kokoman hah a ma kiu apaꞌpuh me a ma tah vatoksean nöꞌ to nonok noꞌ sih. Ivëh, ka ma tah poë varih se kunkuin o vaman manih pa ma kokoman peöm. ");
INSERT INTO tpz_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Eöꞌ to soe vamaman rakah keoꞌ peöm, etereh to vaman a ne neoꞌ me a ma soe peöꞌ, ee se nok ee pa ma kiu varih nöꞌ to nonok noꞌ sih. Ee me se nok pet ee pa ma teꞌ kiu to teꞌ apaꞌpuh oah e ne pa ma teꞌ kiu varih nöꞌ to nonok voh noꞌ. Suk ataeah, eöꞌ se nö eoꞌ manuh pe Tamön, paröꞌ vanö maꞌ a Tuvuh Vasioꞌ manih peöm. ");
INSERT INTO tpz_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Eöm se keh hin ta ma taneah manih pa ëhnaneoꞌ, eöꞌ se pënton eoꞌ pa hin peöm, paröꞌ nok eoꞌ pataeah nöm to hinhin suk nem. Eöꞌ se nonok va noꞌ nën, pan e Tamön se vataare o kikis apuh peꞌ manih pa ma kiu neöꞌ e Sunaiꞌeah to nonok noꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","A, a ma tah kurus nöm se hin manih pa ëhnaneoꞌ. Eöꞌ se pënton eoꞌ pa hin peöm, ko nok keoꞌ peöm pataeah nöm to iu nem. ");
INSERT INTO tpz_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pan, “Eöm se keh iu e nem peöꞌ, a, eöm se vatet vavih rakah a ma soe apuh peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Eöꞌ se hin e Tamön, keꞌ heꞌ en peöm pa meh Teꞌ Va Pa Vaꞌaus, keꞌ teꞌ vaꞌpeh tamoaan me e non peöm. ");
INSERT INTO tpz_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ka teꞌ pamëh, eꞌ a Tuvuh va pa soe a soe man. A napan va po oeh vëh to hikta onöt ne a öt poë, suk ee to hikta ep i ne eah, pare nat i ne poë. Ivëhkëk eöm to nat e nem pa teꞌ pamëh, suk eꞌ to teꞌ me e non peöm, ka amot me kuru neꞌ se teꞌ vaꞌpeh tamoaan avoeꞌ me e non peöm. ");
INSERT INTO tpz_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Eöꞌ to hikta onöt noꞌ a këh akuk va ka neöm manih po siꞌ koaꞌ nök. Ahik, eöꞌ se hah eoꞌ ma pa ep peöm. ");
INSERT INTO tpz_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","A siꞌ ö hat ka napan va po oeh vëh hikta se ep hah a ne neöꞌ. Ivëhkëk, eöm se ep em peöꞌ, suk eöꞌ se mët, paröꞌ sun hah eoꞌ. Ivëh, ke eöm me se sun taneꞌ hah em pa nap mët ko kon hah em po toꞌtoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Manih po poen pamëh nöꞌ se sun taneꞌ hah pa nap mët ko kon hah eoꞌ po toꞌtoꞌ. Köm nat em peöꞌ to teꞌ vaꞌpeh me noꞌ pe Tamön, kemöm tavus em poꞌ a paeh a teꞌ. Ke eöm se teꞌ vaꞌpeh me e nem peöꞌ, köꞌ teꞌ vaꞌpeh me e noꞌ peöm, ka tavus ee a paeh a teꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","O teꞌ varih to kon a soe apuh peöꞌ, pare vavatet ne, ee ko a napan poë varih to iu a ne neoꞌ. Ke Tamön iu me e non po teꞌ poë varih, keöꞌ me se iu e noꞌ pee. Paröꞌ vataare öꞌ manih pa ma papaeh pee.” ");
INSERT INTO tpz_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ke Jiutas, a teꞌ vëh to hikta teꞌ non pan e Jiutas va Iskariot, to hi va in e Ieesuꞌ manih pan, “Ivëhkëk, Sunön, vahvanih kën koman nom a vataare varoe eo manih pemöm, eën he hikta vataare eo manih pa napan kurus va po oeh vëh?” ");
INSERT INTO tpz_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ke Ieesuꞌ piun poan, pareꞌ soe pan, “Etereh to iu a ne neoꞌ, ee se vavatet ne o vavaasis peöꞌ, ke Tamön iu e non pee. Kemöm poꞌ Tamön nö vapöök em manih pee, pamöm nok em pa ö teꞌteꞌ pemöm poꞌ manih pa ma kupu pee. ");
INSERT INTO tpz_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","O teꞌ varih to hikta iu a ne neoꞌ, pare hikta iu vatet ne o vavaasis peöꞌ. Ko vavaasis vaꞌih nöm to tënan nem sih, eꞌ to hikta teꞌ non pan, o vavaasis koman peöꞌ. Ahik, o vavaasis vaꞌih eꞌ o vavaasis koman pe Tamön vëh to vanö voh a maꞌ neoꞌ, köꞌ nö maꞌ manih po oeh vëh. ");
INSERT INTO tpz_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ko poen nöꞌ to teꞌ avoeꞌ me e noꞌ peöm, paröꞌ sosoe ka noꞌ neöm a ma tah poë varih. ");
INSERT INTO tpz_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ivëhkëk a Teꞌ Vavaꞌaus Teꞌ vëh a Tuvuh Vasioꞌ ne Tamön se vanö amot maꞌ pa ëhnaneoꞌ, keꞌ vavaasis a neöm a ma moeh tah kurus. Pareꞌ kunkuin a ma kokoman peöm, köm nat hah a ma taneah nöꞌ to vavaasis voh a noꞌ neöm. ");
INSERT INTO tpz_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Eöꞌ se këh ka neöm a taateꞌ teꞌ vakamöꞌ, me o kokoman tö. Ka taateꞌ kamöꞌ peöꞌ nöꞌ se këh ka neöm. Ka taateꞌ vakamöꞌ pamëh nöꞌ to hikta heꞌ va ka neöm manih pa ö no a napan va po oeh to heꞌ va i ro upöm teꞌ pa taateꞌ pamëh. Ivëh, köꞌ iu noꞌ a ö söm koe a tamak, paröm koe a naöp suk a tah pamëh se tavus maꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Eöm to pënton voh em peöꞌ to soe keoꞌ peöm pan, ‘Eöꞌ se nö eoꞌ manuh pa vöön va kin, paröꞌ hah eoꞌ maꞌ manih peöm.’ Eöm se keh iu rakah e nem peöꞌ, eöm se haraꞌ vaeö rakah suk e nem peöꞌ to hah eoꞌ manuh pe Tamön, suk ataeah, a tasun peꞌ to apuh oah e non pa teꞌ tasun peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","A ma tah kurus poë varih to meꞌ avoeꞌ e ne pa tavus maꞌ, köꞌ soe vahik ke voh eoꞌ peöm. Suk ataeah, amot nöm se ep in a tah pamëh to tavus, paröm vaman poꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Eöꞌ to hikta se vaato varë hah me a noꞌ neöm, suk ataeah, a teꞌ to matop non sih o oeh vëh to nö en maꞌ. Eꞌ to hikta teꞌ me non to kikis to nok ta pah tah manih peöꞌ. Ivëhkëk, eöꞌ se vaonöt keah keꞌ nok en pataeah neꞌ to kehkeh nok non. ");
INSERT INTO tpz_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ivëhkëk, eöꞌ se nok vavih eoꞌ pa ma tah ne Tamön to taꞌ a neoꞌ a nok. Ivëh, ka napan va po oeh vëh se nat va ne manih pan, eöꞌ to iu rakah e noꞌ pe Tamön.” Ke Ieesuꞌ tooto avoeꞌ e non, pareꞌ soe pan, “Maꞌ poꞌ öm ka këh a muhin vëh.” ");
INSERT INTO tpz_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","E Ieesuꞌ to vavaato avoeꞌ me e non pa ma vamomhë peꞌ, pareꞌ soe ke rapoë pan, “Eöꞌ koman, eöꞌ to teꞌ va noꞌ manih pa vu voaën, ke Tamön vöh pa vöön va kin, eꞌ to teꞌ va e non manih pa teꞌ to vaneah non pa rak. ");
INSERT INTO tpz_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","E Tamön to moes vi en pa ma meh pean va peöꞌ varih to hikta vovoaꞌ vavih ne. Eꞌ to vehveoh vavih rakah en pa ma pean ovineoꞌ varih to vovoaꞌ vavih ne, suk a ö nee se ep vamhën ne pare voaꞌ suntan. ");
INSERT INTO tpz_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","E Tamön to vavoon vahik voh en peöm. Suk ataeah, a soe nöꞌ to heꞌ voh a neöm to nok a neöm, köm voon vahik em. ");
INSERT INTO tpz_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Eöm se teꞌ tamoaan nem manih peöꞌ, köꞌ teꞌ varuꞌ noꞌ manih peöm, ka vatös tamoaan no, para tavus ee a paeh a teꞌ. O pea voaën se keh hikta pu taneꞌ voh maꞌ pa vu voaën, eꞌ to hikta onöt non a voaꞌ. Eꞌ to teꞌ akuk va kov e non manih peöm o vamomhë peöꞌ. Eöm se keh hikta vatös vavih me a nem neoꞌ eöm me to hikta antoen nem a voaꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Eöꞌ to teꞌ va noꞌ manih po rumun in o voaën, ke eöm to teꞌ va e nem manih pa ma pean. Ta pah teꞌ se keh teꞌ vaꞌpeh tamoaan me a no neöꞌ. A, eöꞌ se teꞌ tamoaan varuꞌ e noꞌ manih peꞌ. Eꞌ se vovoaꞌ vavih va kov e non manih. Ivëhkëk eöm se keh hikta teꞌ vaꞌpeh me a nem neoꞌ, eöm to hikta antoen nem a nok ta pah tah to onöt non a kë a ëhnan e Tamön. ");
INSERT INTO tpz_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ta pah teꞌ se keh hikta vatös me a non neoꞌ, eꞌ to teꞌ va e non manih pa ma pea nöꞌ hat ne tövaneah pa rak to moes vi, pareꞌ ununun raoe, kee rak, ka napan vi raoe po suraꞌ, ko suraꞌ ës en pee. ");
INSERT INTO tpz_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Eöm se keh nok vamanih, eöm se vatös vavih tamoaan me e nem peöꞌ, paröm heꞌ rakah a ma kokoman peöm manih po vavaasis peöꞌ. Ivëh, köm se keh hin e Sosoenën ta tah nöm to iu nem, eꞌ se heꞌ en peöm. ");
INSERT INTO tpz_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Eöm se teꞌ va nem manih po pea voaën to voaꞌ vörep. Ka napan se inan va ka ne neöm manih, pa ma vamomhë peöꞌ. Ka tah pamëh to vataare non o kikis pe Tamön. ");
INSERT INTO tpz_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Eöꞌ to iu rakah e noꞌ peöm o vamomhë peöꞌ, vamanih pa ö ne Tamön to iu va ka non neoꞌ sih. Ka ma poen kurus nöꞌ to iu noꞌ pan, eöm se teꞌ tamoaan nem manih po iu peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Eöm se keh vavatet vavih rakah nem o vavaasis peöꞌ, me a soe peöꞌ, a, eöm se teꞌ tamoaan e nem manih pa taateꞌ iu peöꞌ. Eöm se teꞌ va e nem manih pa ö nöꞌ to vavatet vavoh noꞌ o vavaasis me a soe pe Tamön. Ivëh, nöꞌ to teꞌ tamoaan suk noꞌ sih manih po iu peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Eöꞌ to soe ke voh eoꞌ peöm, pa tah vaꞌih. Ivëh, nöꞌ to iu suk noꞌ a ö nöm se puh rakah nem po vaeö. Ko vaeö peöm puh oah en maꞌ manih pa ma kokoman peöm. Ivëh, ko vaeö peöꞌ se puh rakah non manih pa ma kokoman peöm, keꞌ ivaꞌih a tah nöꞌ to soe suk vavoh ka neöm nën. ");
INSERT INTO tpz_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Keꞌ ivaꞌih, a soe apuh peöꞌ. Iu a meh teꞌ vamanih pa ö nöꞌ to iu va ka noꞌ neöm sih. ");
INSERT INTO tpz_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ta pah teꞌ se keh iu suntan rakah non a ma vamomhë peꞌ, eꞌ se heꞌ o toꞌtoꞌ peꞌ manih po upöm teꞌ kee ip vamët poë marën a vaꞌaus raoe. Eꞌ to teꞌ akuk va kov e non manih po vu iu nöꞌ to soe voh ka neöm. ");
INSERT INTO tpz_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ke eöm varih se keh nok voh a ma tah varih nöꞌ to soe voh ka neöm, eöm se tavus em a ma vamomhë peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Eöꞌ to hikta popokaꞌ hah a noꞌ neöm o teꞌ kikiu. Suk ataeah, o teꞌ kikiu to hikta nat ne pataeah ne torara pee to nonok non. Eöꞌ se pokaꞌ eoꞌ peöm o vamomhë peöꞌ, suk ataeah, a ma soe kurus nöꞌ to kon taneꞌ manuh pe Tamön, ne eöꞌ to soe pet ke voh eoꞌ peöm. ");
INSERT INTO tpz_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Eöm to hikta kon voh a neoꞌ pan, eöꞌ se teꞌ vaꞌpeh me a noꞌ neöm. Ahik, eöꞌ to kon voh a neöm paröꞌ heꞌ eoꞌ peöm pa kiu vëh, eöm se nö paröm vapu pet a soe peöꞌ, keꞌ voaꞌ manih pa napan vamanih pa ö no naon to vovoaꞌ va non. Ke eöm se keh hin ta pah tah manih pa ëhnaneoꞌ, e Tamön se heꞌ en peöm. ");
INSERT INTO tpz_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Keꞌ ivaꞌih, a soe peöꞌ. Iu a meh teꞌ pö nën to iu hah va ka nom.” ");
INSERT INTO tpz_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pan, “A napan va po oeh vëh se keh rës ka neöm, a, eöm se nat va nem manih pan, ee to rës me voh e ne peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ivëh, köm se keh teꞌ nem pan, eöm a napan va po oeh vëh, a napan va po oeh vëh se iu e ne peöm a ma meh pee. Ivëhkëk, eöꞌ to kon ke voh eoꞌ peöm, köm këh em maꞌ pa ma taateꞌ hat pa napan va po oeh. Ivëh, köm hikta teꞌ hah nem pan, eöm o teꞌ va po oeh vëh. Keꞌ ivaꞌih, a tah no a napan va po oeh vëh to rës suk ka no neöm. ");
INSERT INTO tpz_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Eöm se koman hah voh a soe vëh nöꞌ to soe voh ka neöm. A soe pamëh to soe va non manih pan, ‘A teꞌ kikiu to hikta antoen non a teꞌ oah e susun peꞌ’. A napan se keh hinën e ne peöꞌ, a, kuru me nee se hinën e ne peöm. Kuru vaꞌih nee se tënan ee po vavaasis peöꞌ, ee se keh tënan ee po vavaasis pamëh ee to tënan me ee peöm. ");
INSERT INTO tpz_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","A napan va po oeh vëh se hinën ee peöm, suk eöm a ma vamomhë peöꞌ. Ee se hinën a neöm, suk ee to hikta nat vavih ne pe Tamön vëh to vanö voh a maꞌ neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Eöꞌ se keh hikta nö voh maꞌ paröꞌ vatvus a soe peöꞌ manih pa ma napan va po oeh vëh, ee hikta onöt ne a taum ta hat, suk a ma taateꞌ hat pee. Ivëhkëk, kuru nee to hikta teꞌ me ne ta hanan nee se koaan vah va in a ma taateꞌ hat pee. ");
INSERT INTO tpz_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Etereh to rës a ne neoꞌ. Ee to rës me e ne pe Tamön. ");
INSERT INTO tpz_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Eöꞌ se keh hikta teꞌ vaꞌpeh me voh noꞌ raoe, paröꞌ nonok noꞌ a ma kiu apaꞌpuh varih, no a hikta meh teꞌ to antoen non a nok, a hikta tah nee se taum suk ta hat. Ivëhkëk, ee to ep ee pa ma kiu nöꞌ to nonok noꞌ, pare rërës avoeꞌ e ne pemöm poꞌ Tamön. ");
INSERT INTO tpz_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ivëhkëk, a ma taateꞌ poë varih to tanok marën a vapuh a soe to kiun non pa taateꞌ pee to soe non pan, ‘A hikta pusun in a tah nee to rës suk a ne neoꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Eöꞌ se vanö ka nös neöm a Teꞌ Vavaꞌaus Teꞌ, ivëh a Tuvuh Vasioꞌ, keꞌ nö nös peöm. A Tuvuh pamëh se taneꞌ maꞌ pe Tamön. Keꞌ, a Tuvuh va pa soe man. O poen neꞌ se nö nös peöm, eꞌ se vamaaka ken peöm pa ma kiu me a ma taateꞌ peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Eöm me se vatvus pet a soe peöꞌ manih pa napan, suk eöm to teꞌ vaꞌpeh me voh e nem peöꞌ po poen nöꞌ to taneo maꞌ a nok a kiu peöꞌ, keꞌ öök non maꞌ manih kuru. ");
INSERT INTO tpz_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Eöꞌ to soe vavoh ka neöm manih pan, eöm se nat nem vanun o vaman peöm. ");
INSERT INTO tpz_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Oman, a napan se veo tavus këh ee peöm pa ma iuun hinhin soneꞌ pee. Ivëhkëk, amot no o poen pamëh se keh tavus maꞌ, kee ip vamët ee peöm. O poen nee se ip vamët a neöm, ee se koman ne pan, ee to nonok e ne pa kiu vih pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ee to nonok va ne manih peöm, suk ee to hikta nat ne pe Tamön, me eöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kuru nöꞌ to soe momoaan keoꞌ peöm a tah pamëh he meꞌ avoeꞌ e non pa tavus maꞌ. Amot no a napan se nok a taateꞌ pamëh manih peöm, köm koman hah em na pa soe nöꞌ to soe voh ka neöm. E Ieesuꞌ to vavaato avoeꞌ me e non pa napan, pareꞌ soe ke rapoë pan, “Moaan voh nöꞌ to teꞌ vaꞌpeh me voh e noꞌ peöm, ivëhkëk, eöꞌ to hikta soe vanat voh a neöm a ma tah poë varih. ");
INSERT INTO tpz_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kuru vaꞌih nöꞌ to nö hah eoꞌ manuh pa teꞌ vëh to vanö voh a maꞌ neoꞌ. Ivëhkëk, a hikta pah teꞌ va peöm to hi a neoꞌ pan, ‘Eën nönö nom nih?’ ");
INSERT INTO tpz_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","A ma kokoman peöm to puh rakah e ne po tamak, suk eöꞌ to soe vanat eoꞌ peöm pa ö nöꞌ se hah eoꞌ manuh pe Tamön, a teꞌ vëh to vanö voh a maꞌ neoꞌ. A meh tah to vatamak a non neöm, ivëh, a soe peöꞌ to teꞌ va non manih pan, a napan se veo tavus këh ee peöm pa ma iuun hinhin soneꞌ pee, pare ip vamët ee peöm. ");
INSERT INTO tpz_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Eöꞌ to soe vamaman rakah keoꞌ peöm, eꞌ to vih rakah non peöm pa nat a neoꞌ, se nö hah eoꞌ manuh pe Tamön. Eöꞌ se keh hikta nö hah manuh peꞌ, a, a teꞌ vëh se kunkuin o kokoman peöm to hikta onöt non a nö maꞌ manih peöm. Eöꞌ se nö hah eoꞌ manuh peꞌ, paröꞌ vanö maꞌ a teꞌ pamëh, keꞌ kunkuin en pa ma kokoman peöm. ");
INSERT INTO tpz_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ko poen no a teꞌ pamëh se kunkuin a ma kokoman peöm se tavus, keꞌ nö maꞌ, eꞌ se vamaaka rakah ken pa napan va po oeh pa ö nee to teen ne a hat, suk a ma taateꞌ hat nee to nonok ne. Eꞌ se vamaaka o kokoman nun no a napan to teꞌ me ne manih pa taateꞌ totoopin, me a taateꞌ kiiki teꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Eꞌ se vataare en pa napan pa ö nee to koman vapiun va ne manih pa pusun in a taateꞌ hat. Ka pusun in a taateꞌ hat pamëh, ivëh, ee to hikta vaman a ne neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ee to koman vapiun va ne manih pan, a pusun in a taateꞌ totoopin, ivëh, pö nöꞌ se hah eoꞌ manuh pe Tamön, köm hikta onöt nem a ep hah ka neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","A teꞌ vavaꞌaus teꞌ se vataare en pee pa ö no kokoman pee to nun suk non, manih po vahutët pe Sosoenën. Ee to koman vapiun ne pan, a teꞌ sunön vëh to matop non sih o oeh vëh, eꞌ e susun po oraꞌ hat, pareꞌ tok vahik voh en po vahutët.” ");
INSERT INTO tpz_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Eöꞌ to teꞌ rakah me noꞌ a ma meh soe nöꞌ se soe ka neöm, ivëhkëk, eöm to hikta onöt nem a maaka in a soe pamëh kuru. ");
INSERT INTO tpz_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ivëh, ko poen no a Tuvuh sosoe man se nö maꞌ manih peöm o vamomhë, eꞌ se vamaaka rakah en pa ma kokoman peöm. Köm nat em pa ma soe kurus poë varih, ee a ma soe man. Eꞌ to hikta onöt non a soe a soe, neꞌ to kon taneꞌ manih po kokoman koman peꞌ. Ahik, a soe neꞌ to tënan manuh pe Tamön, eꞌ a soe varoe ko pamëh neꞌ se soe tavus ka neöm, me a ma taneah se tavus amot. ");
INSERT INTO tpz_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Eꞌ se kon taneꞌ a soe manih peöꞌ, pareꞌ vatvus manih peöm. Ka tah pamëh neꞌ to nok, eꞌ to vataare rakah en po kikis apuh peöꞌ manih peöm. ");
INSERT INTO tpz_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","A ma tah kurus ne Tamön to vaneah non, eꞌ a ma tah kurus poë varih, ee a ma tah peöꞌ. Eꞌ kuru a ö nöꞌ to soe suk voh pan, a Tuvuh sosoe man se soe ken peöm pa soe taeah neꞌ to pënton manih peöꞌ, pareꞌ vateeraꞌ poꞌ ka neöm.” ");
INSERT INTO tpz_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","E Ieesuꞌ to vavaato avoeꞌ e non, pareꞌ soe pan, “A siꞌ ö hat köm hikta se ep hah ka no neoꞌ. Me a siꞌ ö hat akuk ne eöm se ep hah em peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ko upöm vamomhë peꞌ vaiihi koman e ne pan, “A soe vaꞌih teꞌ vah va non nih? Eꞌ to sosoe ka rora pan, ‘A siꞌ ö hat ka hikta se ep hah no eah, me a siꞌ ö hat na se ep hah ee peꞌ.’ Eꞌ me to soe en pan, ‘A pusun in a soe vaꞌih to teꞌ va non manih, eöꞌ se nö eoꞌ manuh pe Tamön.’” ");
INSERT INTO tpz_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","A ma vamomhë peꞌ to vaiihi e ne pan, “A soe vaꞌih, ‘A siꞌ ö hat’, eꞌ ataeah? Ea to hikta nat no pataeah neꞌ to sosoe suk va non manih.” ");
INSERT INTO tpz_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","E Ieesuꞌ to nat en pa ma vamomhë peꞌ to kehkeh hi ne poë a pusun in a soe vaꞌih, ivëh, neꞌ to soe suk va i raoe manih pan, “‘A siꞌ ö hat köm hikta se ep ka no neoꞌ, me a siꞌ ö hat ne eöm se ep hah em peöꞌ.’ Eꞌ akuk kuru a tah nöm to vaiihi suk nem. ");
INSERT INTO tpz_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Eöꞌ to soe vamaman rakah keoꞌ peöm, eöm se vaokook suntan rakah em, a napan kurus he haraꞌ vaeö rakah e ne. Eöm se haraꞌ em po tamak, ivëhkëk, o tamak peöm se nönö non ko tarih ko tavus en o vaeö, köm pah haraꞌ vaeö suntan em. ");
INSERT INTO tpz_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Eöꞌ se vapipinoꞌ va in a soe pamëh manih, o poen no e köövo to kehkeh vahuh non a koaꞌ, eꞌ to haraꞌ vahat rakah en po kamis, suk eꞌ to nat e non peꞌ se kon en pe koaꞌ. Ivëhkëk, o poen ne koaꞌ to vuꞌ en, e köövo se vanun en po kamis vëh neꞌ to haraꞌ non, suk e koaꞌ peꞌ to tavus en maꞌ manih po oeh. ");
INSERT INTO tpz_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Eꞌ to teꞌ akuk va kov e non manih peöm. Kuru nöm to haraꞌ nem o tamak, ivëhkëk, eöꞌ se hah maꞌ ko ep ka neöm, köm pah vaeö suntan rakah em. O vu vaeö pamëh no a hikta pah teꞌ to onöt non a kon tavus këh a ma kokoman peöm. ");
INSERT INTO tpz_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Manih po poen pamëh, nöm hikta se hi a nem neoꞌ ta pah tah. Eöꞌ to soe vamaman rakah keoꞌ peöm, e Tamön se heꞌ en peöm pa ma taneah nöm to hin suk manih pa ëhnaneoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Moaan voh, ko öök non maꞌ manih kuru, eöm to hikta hinhin voh nem ta ma taneah manih pa ëhnaneoꞌ, ivëhkëk kuru, eöm se hin em pataeah manih pa ëhnaneoꞌ, eöm se kon em pataeah nöm to hinhin suk nem, ko poen nöm to kon vahik a tah pamëh, a ma kokoman peöm se puh rakah ee po vaeö.” ");
INSERT INTO tpz_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","E Ieesuꞌ to tooto avoeꞌ e non, pareꞌ soe pet en pan, “Eöꞌ to vavatvus noꞌ a ma soe peöꞌ pa ma soe vapipinoꞌ, ivëhkëk, o poen to meꞌ avoeꞌ e non pa tavus maꞌ, nöꞌ hikta se vatvus amot hah noꞌ ta meh soe pa soe vapipinoꞌ manih pa soe nöꞌ to sosoe ka no neöm. Eöꞌ se soe vatotoopin rakah keoꞌ peöm pa ö ne Tamön to teꞌ va non sih. ");
INSERT INTO tpz_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Manih pa hanan pamëh nöm se hin koe in a tah nën, eöm se vakoe a hin peöm manih pa ëhnaneoꞌ. Peꞌ eöꞌ koman, eöꞌ hikta se hi hah noꞌ e Tamön a ö seꞌ vaꞌaus a neöm. ");
INSERT INTO tpz_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Suk ataeah, e Tamön koman to iu e non peöm, eꞌ to iu a non neöm, suk eöm to iu e nem peöꞌ. Paröm vaman e nem peöꞌ to taneꞌ maꞌ manuh peꞌ. Ivëh, neꞌ se piun suk a ma hin peöm. ");
INSERT INTO tpz_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Eöꞌ to taneꞌ voh maꞌ manuh pe Tamön, paröꞌ nö maꞌ manih po oeh vëh. Ka kuru vaꞌih, nöꞌ to kehkeh këh hah e noꞌ po oeh vëh, paröꞌ hah eoꞌ manuh pe Tamön.” ");
INSERT INTO tpz_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ka ma vamomhë peꞌ soe ke poꞌ ee peꞌ pan, “Sunön, varuꞌ vakomanih nën to soe vamaaka ke eom pemöm pa ma soe pën, eën to hikta nonok hah ka no möm ta soe manih pa soe vapipinoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kuru nemöm to nat em pën a teꞌ to nat nom sih a ma moeh tah kurus. Ko antoen e nom pa piun a hi pa teꞌ, eꞌ he meꞌ avoeꞌ e non pa hi a oah a hi peꞌ. Keꞌ ivëh, a tah to vataare a no möm, kemöm vaman e nem pën to taneꞌ maꞌ pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ke Ieesuꞌ piun raoe, pareꞌ soe ke raoe pan, “Eöm vaman kov em eh? ");
INSERT INTO tpz_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pënton poꞌ nem pa taꞌ nöꞌ se soe ka neöm, o poen to vatët en, pa tavus. Ahik, eꞌ to tavus vahik voh en, a napan varih to hat ov a ne neoꞌ se veo vavah ee peöm, köm tapeat em, ko nö vakëkëh em pa ma vöön peöm, ko këh em peöꞌ peheoꞌ. Ivëhkëk, eöꞌ to hikta teꞌ noꞌ peheoꞌ, ahik, e Tamön to teꞌ vaꞌpeh me e non peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ke Ieesuꞌ vavaato avoeꞌ ke non pee, pareꞌ soe ke rapoë pan, “Eöꞌ to soe keoꞌ peöm pa tah vaꞌih, eöm se vatös me a neoꞌ, paröm teꞌ nem pa taateꞌ kamöꞌ vamanih pa ö nöꞌ to soe vavoh ka neöm. Ko poen nöm to teꞌ nem manih po oeh vëh, eöm se taum a ma punis me o tamak. Eöm se sun vakis rakah nem, suk eöꞌ to vöknah vahik voh eoꞌ po kikis va po oeh vëh.” ");
INSERT INTO tpz_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","E Ieesuꞌ to vavaasis vahik en pa ma vamomhë peꞌ pa ma soe peꞌ, pareꞌ ta peah na manuh pa vöön va kin, pareꞌ soe vamanih pan, “Tamön, o poen peöꞌ to tavus en, kuru nën se vatvus ke ra napan o kikis apuh peöꞌ e Koaꞌ teꞌ pën, vamanih pa ö nöꞌ se vatvus varuꞌ ke ra napan o teꞌ kikis apuh pën. ");
INSERT INTO tpz_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Suk ataeah, eën to heꞌ voh eom peöꞌ pa tasun va pa matop a napan kurus. Köꞌ onöt e noꞌ pa heꞌ o toꞌtoꞌ tamoaan manih pa napan nën to heꞌ voh a neoꞌ, kee tavus ee a napan peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ka manih po toꞌtoꞌ tamoaan pamëh, no a napan se nat va ka no moah manih pan, eën e Sosoenën vamaman rakah, pare nat me a ne neoꞌ, e Ieesuꞌ Kristo, a teꞌ nën to vanö voh maꞌ. Köꞌ nö maꞌ manih po oeh vëh. ");
INSERT INTO tpz_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Eöꞌ to nok vahik voh eoꞌ pa ma kiu nën to vanö suk voh a maꞌ neoꞌ, pan eöꞌ se nok. Ivëh, ka manih pa ma kiu poë varih ne eöꞌ to vataare vahik eoꞌ po kikis apuh pën manih pa napan. ");
INSERT INTO tpz_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tamön, taneo non po poen no oeh vëh to meꞌ avoeꞌ voh e non pa tavus maꞌ, eöꞌ to teꞌ vaꞌpeh me voh e noꞌ pën, paröꞌ teꞌ me voh e noꞌ po kikis apuh. Kuru nöꞌ to iu noꞌ a ö nën se heꞌ hah a neoꞌ o kikis apuh pamëh, köꞌ se teꞌ vaꞌpeh me a nom oah. ");
INSERT INTO tpz_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Eöꞌ to vatvus vateeraꞌ voh eoꞌ pa ëhnöömah manih pa napan varih, nën to heꞌ voh a neoꞌ manih po oeh vëh, a napan pën poë varih to teꞌ moaan voh e ne manih pën. Ee to këh voh maꞌ a ma taateꞌ hat va po oeh, pare vavatet vavih rakah e ne pa ma soe pën. ");
INSERT INTO tpz_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kuru nee to nat vavih rakah e ne pa ma moeh tah kurus nën to heꞌ voh a neoꞌ, to taneꞌ vaviꞌ voh ee maꞌ manih pa koreomah. ");
INSERT INTO tpz_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Suk ataeah, a ma soe kurus nën to heꞌ voh a neoꞌ, nöꞌ to soe vahik ke voh eoꞌ pee, kee kon ee. Ee to nat vavih rakah e ne peöꞌ to taneꞌ voh maꞌ pën. Pare vaman e ne pën to vanö voh a maꞌ neoꞌ, köꞌ nö maꞌ manih po oeh vëh. ");
INSERT INTO tpz_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Eöꞌ to hinhin noꞌ oah pan, eën se vaꞌaus raoe, eöꞌ to hikta hinhin noꞌ pan, eën se vaꞌaus a napan varih nën to hikta vaoe voh. Ahik, eöꞌ to hinhin noꞌ pan, eën se vaꞌaus varoe a napan varih nën to heꞌ voh a neoꞌ, suk ee ra napan pën. ");
INSERT INTO tpz_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","A napan kurus nöꞌ to vaneah noꞌ, ee ra ma teꞌ kurus pën. Ka ma teꞌ kurus nën to vaneah nom, ee a ma teꞌ kurus me peöꞌ. A ma taateꞌ vih pa napan poë varih to vataare ne a ö no a taateꞌ nenes peöꞌ to teꞌ va non. ");
INSERT INTO tpz_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Ka kuru, nöꞌ to nö eoꞌ nös pën. Eöꞌ to hikta se teꞌ varë hah noꞌ manih po oeh vëh. Ee to hikta onöt ne a nö vaꞌpeh me a nös neoꞌ maneom, ee se teꞌ e ne manih po oeh. Ivëh Tamön, eën a vivihan. Eën no a hikta pah teꞌ to teꞌ va non manih pën. Manih po kikis va pa ëhnöömah, eën se matop vavih e nom pee. Ka manih po ëhnan pamëh, nën to heꞌ voh eom peöꞌ. Ivëh, kee se tavus paeh ee vamanih pa ö na to tavus paeh vavoh. ");
INSERT INTO tpz_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Po poen neöꞌ to teꞌ vaꞌpeh me voh noꞌ raoe, eöꞌ to matop noꞌ raoe po kikis va pa ëhnöömah. Ko ëhnan pamëh nën to heꞌ pet me voh eom peöꞌ. Köꞌ matop e noꞌ pee, ka hikta paeh va pee to ro. A paeh ro va pee to ro voh, ivëh, a teꞌ vëh nën to vamatop keon voh, pan eën se miröꞌ eah. Eꞌ ivëh, se vapuh pa soe to kiun non po Puk Vapenpen pën, keꞌ tavus vaman. ");
INSERT INTO tpz_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Kuru nöꞌ to nö e noꞌ nös pën, paröꞌ nonok noꞌ a soe vaꞌih pa ö nöꞌ to teꞌ noꞌ manih po oeh vëh, eöꞌ to iu rakah noꞌ o vaeö peöꞌ se puh non manih pa ma kupu pee. ");
INSERT INTO tpz_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Eöꞌ to heꞌ vahik eoꞌ pee po vavaasis pën, ivëhkëk a napan va po oeh vëh to hat ov e ne pee. Suk ataeah, a napan peöꞌ to hikta teꞌ ne pan, ee ra napan va po oeh vëh. Eꞌ to teꞌ akuk va kov e non manih peöꞌ to hikta teꞌ noꞌ pan, eöꞌ a teꞌ va po oeh vëh. ");
INSERT INTO tpz_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Eöꞌ to hikta hinhin noꞌ nös oah pan, eën se kon këh raoe po oeh vaꞌih. Ahik, eöꞌ to hinhin a noꞌ nös oah pan, eën se matop vavih nom raoe, ke susun po oraꞌ hat nat non miröꞌ raoe. ");
INSERT INTO tpz_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ee to vavatet a nom oah sih, pare teꞌ va e ne manih peöꞌ. Ee to hikta teꞌ ne pan, ee ro teꞌ va po oeh vëh, vamanih peöꞌ me to hikta teꞌ noꞌ pan, eöꞌ a teꞌ va po oeh vëh. ");
INSERT INTO tpz_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ahik, eën se nok raoe kee tavus a napan pën, köꞌ iu noꞌ pan, a soe man pën se kiu manih pa ma kokoman pee, kee tavus o teꞌ vivihan manih pa soe man pamëh, eꞌ a soe a man rakah. ");
INSERT INTO tpz_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Moaan voh nën to vanö voh a maꞌ neoꞌ, köꞌ nö maꞌ, paröꞌ teꞌ noꞌ topniira napan va po oeh vëh. Eꞌ to vatoe akuk va kov e non manih pa ö nöꞌ to vanö o teꞌ varih, nën to heꞌ voh a neoꞌ, kee nö, pare teꞌ vaꞌpeh me ne a napan va po oeh vëh. ");
INSERT INTO tpz_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ka manih pa vaꞌaus raoe, eöꞌ to heꞌ vahik rakah eoꞌ pën po toꞌtoꞌ peöꞌ. Ivëh, keꞌ man rakah e non pee se tavus ee a napan pën, pare nonok ne a ma kiu pën. ");
INSERT INTO tpz_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ivëhkëk, Tamön, eöꞌ to hikta hinhin noꞌ pan, eën se vaꞌaus varoe a napan varih to teꞌ vaꞌpeh me a ne neoꞌ, ahik, eöꞌ to hinhin noꞌ a oah a ö nën se vaꞌaus o teꞌ varih se tënan amot a soe pee, pare vaman a neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tamön, eöꞌ to hin noꞌ nös oah pan, eën se nok raoe, kee tavus paeh vamanih pa ö na to teꞌ va no sih poꞌ. Eën to teꞌ nom sih manih peöꞌ, köꞌ teꞌ noꞌ manih pën. Eöꞌ to hin me noꞌ nös pan, eën se nok raoe kee vapöh kokoman me a ra poꞌ. Ivëh, ka napan va po oeh vëh ep, pare vaman ne a ö nën to vanö voh a maꞌ neoꞌ, köꞌ nö maꞌ ko tavus manih po oeh vëh. ");
INSERT INTO tpz_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Eën to heꞌ vahik voh eom peöꞌ pa taateꞌ nenes, eöꞌ me to heꞌ vahik voh eoꞌ po teꞌ varih nën to heꞌ voh a neoꞌ pa taateꞌ pamëh. Ivëh, köꞌ iu noꞌ a ö nee se vapöh kokoman, pare tavus vamanih pa ö na to vapöh kokoman va no sih poꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Oman, eöꞌ to teꞌ noꞌ manih pee, kën teꞌ e nom manih peöꞌ, ka manih pa taateꞌ pamëh, nöꞌ to iu noꞌ a ö nee se vapöh kokoman rakah. Ka napan va po oeh se nat va ne manih pan, eën e Sosoenën to vanö voh a maꞌ neoꞌ, köꞌ nö maꞌ manih po oeh. Ee me se nat va e ne manih pën to iu e nom pa ma teꞌ peöꞌ, keꞌ vatoe akuk va ko ve non manih pa ö nën to iu va ka nom neoꞌ sih. ");
INSERT INTO tpz_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tamön, eöꞌ to iu noꞌ a napan varih nën to heꞌ voh a neoꞌ, se teꞌ vaꞌpeh me a ne neoꞌ manih pa vöön nöꞌ to teꞌ noꞌ. Eöꞌ to iu noꞌ a ö nee se ep in o maaka me a tasun apuh peöꞌ. Ko poen no oeh vëh to meꞌ avoeꞌ voh e non pa tavus maꞌ, eën to iu voh e nom peöꞌ, ivëh, nën to heꞌ suk voh eom peöꞌ po maaka me a tasun apuh. ");
INSERT INTO tpz_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tamön, eën a Totoopin rakah. A napan va po oeh vëh to hikta nat vavih ne pën, ivëhkëk, eöꞌ koman to nat e noꞌ pën. Ko kum teꞌ varih nën to heꞌ a neoꞌ, ee me to nat e ne pën a teꞌ vëh to vanö maꞌ neoꞌ manih po oeh vëh. ");
INSERT INTO tpz_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Eöꞌ to vatvus a ëhnöömah manih pee, köꞌ se vavatvus avoeꞌ ke noꞌ pee pa ëhnöömah, kee sih kon a taateꞌ iu teꞌ vamanih pa ö nën to iu va ka nom neoꞌ sih. Keöꞌ me se teꞌ e noꞌ manih pee. ");
INSERT INTO tpz_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","E Ieesuꞌ to nok vahik en pa hin peꞌ. Pareꞌ pahan en pa siꞌ ruen soneꞌ nee to popokaꞌ ne a Kidron, eꞌ me ra ma vamomhë peꞌ. Manuh pa pap ruen vöh, eꞌ to teꞌ voh non a rak nën, ne Ieesuꞌ me ra ma vamomhë peꞌ to nönö vah ne pa koman a rak pamëh. ");
INSERT INTO tpz_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ke Jiutas vëh a teꞌ se vikuh e Ieesuꞌ manih po teꞌ varih to hat ov e ne poë, to nat vavih e non pa ö pamëh. Suk ataeah, a ma tamoaan ne Ieesuꞌ me ra ma vamomhë peꞌ to tötönun ne sih nën. ");
INSERT INTO tpz_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ivëh, ke Jiutas me en maꞌ pa nap vëvënsun va Room me a ma pah teꞌ varih to ut ne sih a Iuun Hinhin Apuh, no teꞌ susunön ësës heꞌ, me ro Parësiꞌ to heꞌ poë. Kee nö ee manih pa ö ne Ieesuꞌ to teꞌteꞌ non me ra ma vamomhë peꞌ. A nap vëvënsun to teꞌ nö ne maꞌ a ma tah vavapus me. Ee to öt nö ne maꞌ a ma ram me a ma vauꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ivëhkëk, e Ieesuꞌ to nat momoaan en pa ma taneah to kehkeh tanok ne manih peꞌ. Ivëh, keꞌ huk vatët en manih pee. Pareꞌ hi raoe pan, “Eöm vavaiu vah nem eteh?” ");
INSERT INTO tpz_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ka nap vëvënsun piun poë, pare soe pan, “Emöm to kehkeh ep nem pe Ieesuꞌ va Nasarët.” Ke Ieesuꞌ piun raoe, pareꞌ soe pan, “Eöꞌ ivaꞌih.” Ke Jiutas a teꞌ vëh to vikuh e Ieesuꞌ manih pa korera napan varih to hat ov i ne poë to sun vaꞌpeh me e non pee. ");
INSERT INTO tpz_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ke Ieesuꞌ soe vakomanih, “Eöꞌ ivaꞌih.” Kee tahoak hah ko vuꞌ ee po oeh. ");
INSERT INTO tpz_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ke Ieesuꞌ hi hahah kov en na pee pan, “Eöm vaiu maꞌ eteh?” Kee soe ke poë pan, “E Ieesuꞌ va Nasarët.” ");
INSERT INTO tpz_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ke Ieesuꞌ piun hahah kov en pee, pareꞌ soe pan, “Eöꞌ to soe vu keoꞌ peöm, eöꞌ akuk ko vi vëh. Eöm se keh iu ep ka no neoꞌ koe a ma teꞌ varih, kee hah na.” ");
INSERT INTO tpz_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","A tah pamëh se tavus, ko vapuh a soe ne Ieesuꞌ to soe moaan voh, pareꞌ soe pan, “Ahikta paeh va pa napan varih nën to heꞌ voh a neoꞌ se ro.” ");
INSERT INTO tpz_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","E Saëmon Pitaꞌ to teꞌ me non o rapis rë. Eꞌ to rëh o rapis rë pamëh, ko moes kurus en pa pap tenan matö pa teꞌ kikiu pa Teꞌ Susun po Teꞌ Ësës Heꞌ. A ëhnan a teꞌ kikiu pamëh e Malkus. ");
INSERT INTO tpz_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ivëhkëk, e Ieesuꞌ to soe ke Pitaꞌ pan, “Vahoꞌ hah na o rapis rë pën manih pa ö pepet peꞌ. Eën koman kës nom pan eöꞌ to hikta onöt noꞌ a kaak manih pa kap va po kamis vëh ne Tamön to heꞌ voh a neoꞌ?” ");
INSERT INTO tpz_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","E Ieesuꞌ to sosoe vahik va ko non manih, ka nap vëvënsun, me a teꞌ vaꞌih to vovoh ke non sih raoe, me ro teꞌ varih to ut ne sih pa Iuun Hinhin Apuh, to öt ee pe Ieesuꞌ, pare nohnoh ee peꞌ po uris eh. ");
INSERT INTO tpz_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ee to me vovoh ee peꞌ manuh pe Anas. E Anas e nomanih e Kaëfas. Po kirismas pamëh ne Kaëfas to teꞌ non a Teꞌ Susun po Teꞌ Ësës Heꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Keꞌeꞌ rakah ko a teꞌ pamëh to soe vanat voh ken po teꞌ susunön po Jiuꞌ pan, “Eꞌ to vih rakah non pa ta pah teꞌ se kon a tasun pea a napan va Israël, pareꞌ mët. Peꞌ to hikta vih non pa napan pea se ro kurus manih pa koreera nap vëvënsun va Room.” ");
INSERT INTO tpz_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","E Saëmon Pitaꞌ pen a meh vamomhë to suksuk amamot nö e ne pe Ieesuꞌ. E Susun po Teꞌ Ësës Heꞌ to nat vavih rakah e non pa meh vamomhë pamëh. Ivëh, neꞌ to ho vaꞌpeh suk me e Ieesuꞌ manuh koman a kiikin va mahën vëh to teꞌ non pa iuun pa Teꞌ Susun po Teꞌ Ësës Heꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ivëhkëk, e Pitaꞌ to sun avoeꞌ e non maꞌ manuh mahën po sinten o hopaꞌ. Ka teꞌ vamomhë vëh no a Teꞌ Susun po Teꞌ Ësës Heꞌ to nat vavih non sih poan to nö, pareꞌ soe vanat e koaꞌ mon vëh to ut non po hopaꞌ, pareꞌ me ho en maꞌ peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ke köövo vëh to ut non po hopaꞌ to inan e Pitaꞌ, pareꞌ soe ke poan pan, “Eën me poꞌ ko toh a meh vamomhë pa teꞌ pamëh?” Ke Pitaꞌ vonih, pareꞌ soe pan, “Ahik, eöꞌ to hikta teꞌ noꞌ, pan eöꞌ e vamomhë pa teꞌ pamëh.” ");
INSERT INTO tpz_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","A muhin to parin a tutuvuh vörep. Ka nap kiu me ro teꞌ utut vaës ee pa suraꞌ, ko maꞌkis e ne. E Pitaꞌ me to teꞌ vaꞌpeh me e non nën, pareꞌ maꞌkis me e non pa suraꞌ pamëh. ");
INSERT INTO tpz_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ka poa vamomhë pe Ieesuꞌ sun avoeꞌ e ne mahën, ka Teꞌ Susun po Teꞌ Ësës Heꞌ ihi e non pe Ieesuꞌ pa ma hi suk a ma vamomhë peꞌ, me a ma soe varih neꞌ to vavaasis non sih a napan. ");
INSERT INTO tpz_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ke Ieesuꞌ piun a hi pe Susun po Teꞌ Ësës Heꞌ, pareꞌ soe ke poan pan, “Eöꞌ to vavaasis voh noꞌ sih a napan a ma soe peöꞌ manih mahën, me manih koman a ma iuun hinhin soneꞌ peöm, me manih koman a Iuun Hinhin Apuh, me manih pa ma ö tötönun pa napan va Israël. Eöꞌ to hikta vavaasis vakoaan voh noꞌ a napan, ahik. ");
INSERT INTO tpz_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Eën hi suk va ka neoꞌ manih ataeah pa ma soe nöꞌ to vavaasis noꞌ sih? Eën se keh iu nat vavih nom, eën se nö, parën hi a napan varih to tënan voh ne a ma soe peöꞌ. Ee me to nat vavih e ne pa ma tah nöꞌ to vavaasis voh noꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","E Ieesuꞌ to sosoe va ko non nën, ka teꞌ vëh to ut non sih a Iuun Hinhin Apuh to sun non manih pa havineah, tapan en peꞌ, pareꞌ soe pan, “Eꞌ ko vëh a ö nën se piun va in a soe pe Susun po Teꞌ Ësës Heꞌ eh? ");
INSERT INTO tpz_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ke Ieesuꞌ piun a soe pa teꞌ utut pamëh, pareꞌ soe ke poan pan, “Eöꞌ se keh nok voh eoꞌ pa ta pah soe hat, soe ka neoꞌ ah a soe pamëh. Ivëhkëk, eöꞌ to sosoe ke noꞌ sih a napan a ma soe man vaviꞌ, ataeah nën to tapan suk poꞌ a neoꞌ?” ");
INSERT INTO tpz_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","E Anas to vanö en pe Ieesuꞌ manuh pe Kaëfas. Ee to hikta pureꞌ avoeꞌ këh ne poë po uris vëh no teꞌ utut to nohnoh maꞌ poë. ");
INSERT INTO tpz_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","E Pitaꞌ to sun avoeꞌ e non po sinten suraꞌ, pareꞌ maꞌkis non, ka ma meh teꞌ nee to pët maꞌkis ne inan poë, pare hi ee peꞌ pan, “Eh, eën me poꞌ ko toh a meh vamomhë pe Ieesuꞌ?” Ivëhkëk, e Pitaꞌ to vonih en, pareꞌ soe ke raoe pan, “Ahik, eöꞌ to hikta teꞌ noꞌ pan, eöꞌ e vamomhë peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ivëhkëk, eꞌ to teꞌ non a pah teꞌ kikiu pe Susun po Teꞌ Ësës Heꞌ to maꞌkis me eꞌ non manih po suraꞌ, a teꞌ pamëh eꞌ to vatompoan me non a teꞌ vëh ne Pitaꞌ to moes kurus voh maꞌ a tenaneah, to soe ke maꞌ e Pitaꞌ pan, “Eh, eöꞌ to ep vaꞌpeh me pöꞌ voh e noꞌ maꞌ pën, me e Ieesuꞌ manuh pa koman a rak.’ ");
INSERT INTO tpz_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","E Pitaꞌ to soe hah ken pee pan, “Ahik.” Eꞌ to sosoe va kon non nën, ke toaꞌ oeteꞌ tötö en. ");
INSERT INTO tpz_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pa pöstakah rakah no teꞌ susunön po Jiuꞌ to taꞌ o teꞌ utut pan, ee se me taneꞌ maꞌ e Ieesuꞌ manuh pa iuun pe Kaëfas, pare me poë manuh pa iuun pa teꞌ susun va Room vëh e Paëlat. Ivëhkëk, ee to hikta ho vaꞌpeh me poë manuh koman iuun. Suk ataeah, ee to koman ne pan, ee tomeꞌ tavus o teꞌ hat manih pa matan e Sosoenën, pare hikta onöt ne a nö manuh pa Taëën Apuh va po Pasovaꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ivëh, ka napan poë varih anoeh e ne mahën, ke Paëlat tavus taneꞌ hah en maꞌ koman iuun, pareꞌ hi raoe pan, “Eöm kehkeh vahoꞌ suk nem a teꞌ vëh ataeah po vahutët?” ");
INSERT INTO tpz_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ka napan poë varih piun va in a soe pe Paëlat manih pan, “A teꞌ vëh se keh teꞌ non pan, eꞌ a teꞌ hikta nonok hat, emöm to hikta onöt nem a me maꞌ eah manih pën.” ");
INSERT INTO tpz_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ke Paëlat piun va in a soe pee manih pan, “Eöm koman se me eah, paröm vahoꞌ eah po vahutët vamanih pa ö no a taateꞌ peöm to teꞌ va non, peöꞌ to hikta nat noꞌ ta tah se röꞌ vahoꞌ suk eah po vahutët. Ivëhkëk, o Jiuꞌ to piun a soe pe Paëlat, pare soe ke poë pan, “Emöm to hikta teꞌ me nem ta soe vaonöt va pa ip vamët ta pah teꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ka ma tah varih se keh tanok ee, ka nat ee pa tah ne Ieesuꞌ to sosoe suk voh non to tavus vaman en. Eꞌ to sosoe suk voh non a ö neꞌ se mët vah ava manih pa kuruse. ");
INSERT INTO tpz_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","E Paëlat to ho hah en koman iuun, pareꞌ vaoe en na pe Ieesuꞌ, keꞌ nö en maꞌ manih peꞌ, keꞌ hi poan pan, “Eën ko a teꞌ sunön po Jiuꞌ, ha?” ");
INSERT INTO tpz_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ke Ieesuꞌ piun a hi pe Paëlat, pareꞌ soe ke poan pan, “A hi koman pën ivëh, keꞌ, a ma meh teꞌ to soe ka oah, pan eöꞌ eteh?” ");
INSERT INTO tpz_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ke Paëlat piun a hi pe Ieesuꞌ, pareꞌ soe ke poan pan, “Eën koman to nat e nom peöꞌ to hikta teꞌ noꞌ a to Jiuꞌ. A napan koman pën ivarih me ro teꞌ sunön ësës heꞌ ivarih to vahoꞌ a oah manih pa koreneoꞌ. Eöꞌ to kehkeh nat noꞌ a hat taeah nën to nok voh, kee vahoꞌ suk a oah po vahutët?” ");
INSERT INTO tpz_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ke Ieesuꞌ piun a hi pe Paëlat, pareꞌ soe pan, “A matop vih peöꞌ to hikta teꞌ non pan, eꞌ a tah va po oeh vëh. Ahik, a matop vih peöꞌ se keh teꞌ non pan, eꞌ a tah va po oeh vëh, a ma teꞌ kikiu peöꞌ to onöt e ne pa vapus pip ka neoꞌ, ka hikta pah teꞌ to antoen non a heꞌ a neoꞌ manih pa koreera napan va Israël.” ");
INSERT INTO tpz_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ke Paëlat hi hahah kov en pe Ieesuꞌ pan, “Eën kës kuru a teꞌ sunön, ha?” Ke Ieesuꞌ piun a hi pe Paëlat, pareꞌ soe ke poan pan. “A, eën koman to soe eom pan, eöꞌ e sunön, keꞌ, a tah akuk ko pamëh ne sisiꞌ to kon suk voh a neoꞌ. Köꞌ nö maꞌ manih po oeh vëh. Eöꞌ to nö maꞌ to soe tavus ke ra napan va po oeh vëh a soe man peöꞌ. Ka napan varih to vavatet ne sih a soe man, ee to tënan e ne pa soe peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ke Paëlat hi hahah kov en pe Ieesuꞌ pan, “Ataeah ivëh a soe man?” E Paëlat to soe vahik vakomanih, pareꞌ tavus hah en maꞌ manih pa napan varih to anoeh ne mahën. Pareꞌ soe ke raoe pan, “Eöꞌ to hikta taum ta hat manih pa teꞌ vaꞌih. ");
INSERT INTO tpz_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ivëhkëk, manih pa taateꞌ peöm a napan va Israël, eöm to sosoe nem sih pan, eꞌ to vih non pa Taëën Apuh va po Pasovaꞌ na se ihan taneꞌ ta pah teꞌ manih pa nohnoh. Eöm iu poꞌ nem eteh na se ihan hah eah? Eöm iu nem e sunön po Jiuꞌ, keꞌ, eteh?” ");
INSERT INTO tpz_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kee piun e Paëlat, pare taoa ko soe na pan, “Ahik, eꞌ to hikta teꞌ non pan a teꞌ maneom. Emöm to iu varoe ko nem e Barabas.” E Barabas, eꞌ a teꞌ to vavapus me voh non a nap vëvënsun va Room. ");
INSERT INTO tpz_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ke Paëlat taꞌ a nap vëvënsun, kee rëp poë po uris rëprëp teꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Vasuksuk in a ö nee to rëp vahik poë, ka nap vëvënsun kon o uris toꞌtoꞌ, pare nok o tah to matan va non manih po uvan, pare vahoꞌ manih pa pasuneah. Pare nok ohop to matan va non manih po ohop rë ereraꞌ pa teꞌ sunön. ");
INSERT INTO tpz_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","A ma tëëm peo rakah nee to nönö ne maꞌ manih peꞌ, pare sosoe va ne manih pan, “Potan avih Sunön po Jiuꞌ.” Ee to sosoe vahik va ko ne manih, pare tatapan ee peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","E Paëlat to tavus hah en maꞌ, pareꞌ soe ke ra napan pan, “Ep këk öm, eöꞌ to me tavus hah eoꞌ maꞌ peꞌ manih peöm, to vataare a neöm, peöꞌ to hikta taum ta hat manih peꞌ, na se vahoꞌ suk eah po vahutët. ");
INSERT INTO tpz_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ke Ieesuꞌ tavus taneꞌ hah en maꞌ manuh pa iuun pe Paëlat. Ee to uvan maꞌ poë po uvan nee to nok po uris toꞌtoꞌ, pareꞌ ohop non o ohop rë ereraꞌ. Ke Paëlat soe va maꞌ manih pan, “Ep öm, ivaꞌih a teꞌ pamëh.” ");
INSERT INTO tpz_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","O teꞌ susunön ësës heꞌ, me ro teꞌ utut to ep in e Ieesuꞌ, pare taoa ko soe pan, “Ni öm eah pa kuruse, ni eah öm pa kuruse.” Ke Paëlat soe ken pee pan, “Eöm koman se öt eah, paröm ni eah pa kuruse, peöꞌ to hikta taum ta hat manih peꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ko Jiuꞌ soe ke na e Paëlat pan, “Ea to teꞌ me no a taateꞌ to soe non pan, a teꞌ vëh eꞌ se mët rakah. Suk ataeah, eꞌ to soe voh pan, ‘Eöꞌ E Koaꞌ Pe Sosoenën.’” ");
INSERT INTO tpz_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","E Paëlat to pënton a napan to soe a soe vaꞌih, ko pah naöp suntan rakah en. ");
INSERT INTO tpz_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","E Paëlat to ho hah en manuh pa iuun pa kaman, pareꞌ hi en pe Ieesuꞌ pan, “Eën a teꞌ va pa vöön poanheh?” Ivëhkëk, e Ieesuꞌ to hikta piun hah poan. ");
INSERT INTO tpz_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ke Paëlat hi hahah kov en peꞌ pan, “Eën rës rakah e nom pa piun a soe peöꞌ öh? Eën nat poꞌ e nom peöꞌ to teꞌ me e noꞌ po kikis va pa ö nöꞌ se vahah toꞌtoꞌ eoꞌ pën toh, me eöꞌ to onöt e noꞌ pa soe, kee ni ee pën pa kuruse.” ");
INSERT INTO tpz_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","E Ieesuꞌ to piun a soe peꞌ, pareꞌ soe pan, “E Sosoenën vöh pa vöön va kin se keh hikta heꞌ voh a oah o kikis vaꞌih, eën to hikta onöt nom a vöknah a neoꞌ. Ivëh, ka teꞌ vëh to vahoꞌ voh a neoꞌ manih pa koreomah, a hat pa teꞌ pamëh to apuh oah e non pa teꞌ hat pën. ");
INSERT INTO tpz_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","E Paëlat to pënton a soe vaꞌih, pareꞌ punöꞌ vakis rakah en pa ep këh ta hanan neꞌ se amun vah va in e Ieesuꞌ, kee nat ne ip vamët poë. Ivëhkëk, a napan va Israël to tënan a soe vaꞌih, pare taoa suntan rakah ee, pare soe na pan, “Eën se keh vahah toꞌtoꞌ maꞌ a teꞌ vaꞌih, eën to hikta onöt nom a ö sën teꞌ hah nom e vamomhë pe Sisaꞌ. Etereh to koman ne a tavus o teꞌ sunön, ee o teꞌ poë varih ne Sisaꞌ to hat ov e non pee.” ");
INSERT INTO tpz_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","E Paëlat to tënan a soe vaꞌih, pareꞌ me tavus en maꞌ pe Ieesuꞌ, pareꞌ ihoꞌ en pa ö ihihoꞌ pa teꞌ pëpënton vahutët. Manih pa ö pamëh, nee to pokaꞌ ne pan, “a moeh vösvös”, po to po Jiuꞌ o ëhnan pamëh to teꞌ va non manih Gabataꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","A tah to matan va non manih pa topnin potan va po Vatönim. O Vatönim eꞌ o poen va pa vamatop a ma tah va po nënkikiu va po Pasovaꞌ, ko poen pamëh, eꞌ o Poen Apaapo. Ke Paëlat soe ke ro Jiuꞌ pan, “Ep öm, eꞌ ivaꞌih a teꞌ sunön peöm.” ");
INSERT INTO tpz_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ka napan taoa, ko pët soe maꞌ pan, “Ip vamët öm eah, ip vamët öm eah! Ni öm eah pa kuruse.” Ke Paëlat hi hahah kov en pee pan, “Eöm iu nem a ö söꞌ ni e sunön peöm pa kuruse, ha?” Ko teꞌ susunön ësës heꞌ piun maꞌ Paëlat, pare soe pan, “Emöm to hikta teꞌ me nem ta meh teꞌ sunön, e Sisaꞌ varoe a paeh.” ");
INSERT INTO tpz_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ke Paëlat heꞌ en pe Ieesuꞌ pan ee se ni poë pa kuruse. A nap vëvënsun to me ee pe Ieesuꞌ, ");
INSERT INTO tpz_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","pare heꞌ poë a kuruse vëh, nee se ni poë, keꞌ teꞌ en. Ee to këh ee pa vöön, pare tavus ee pa tope nee to popokaꞌ ne a ö to matan va non manih po Kahoꞌ In A Teꞌ Mët. Manih po to Hibru nee to pokaꞌ ne pan, a Gölgötaꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Manih Gölgötaꞌ nee to ni ee pe Ieesuꞌ pa kuruse me ra meh poa teꞌ. E Ieesuꞌ to han non pa teꞌ kuruse peꞌ po topnin, ka meh poa teꞌ to han vakëh ne. ");
INSERT INTO tpz_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","E Paëlat me to taꞌ a napan, kee kiun o kiun, pare vahan manih pa pasun a kuruse. O kiun pamëh to soe va non manih pan, “IVAꞌIH E IEESUꞌ VA NASARËT A TEꞌ SUNÖN PO JIUꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","A nap peo po Jiuꞌ to ëh o soe vanat pamëh, suk ataeah, a ö vëh ne Ieesuꞌ to han non to hikta teꞌ varo këh non a vöön va Jerusalëm, o soe vanat pamëh nee to kiun voh po kukön to, o Hibru, me o Latin, me o Grik. ");
INSERT INTO tpz_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","O teꞌ susunön ësës heꞌ to ep a tah vaꞌih, pare pah heve suntan ee, pare soe ke Paëlat pan, “Eën se nat nom kiun vamanih pan, ‘Sunön po Jiuꞌ’. Eën se kiun vamanih pa ö neꞌ to soe vavoh, ‘Eöꞌ a teꞌ Sunön po Jiuꞌ.’” ");
INSERT INTO tpz_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ke Paëlat piun raoe, pareꞌ soe pan, “A soe nöꞌ to taꞌ, kee kiun eꞌ se pah teꞌ va e non nën.” ");
INSERT INTO tpz_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","A nap vëvënsun to ihan këh e Ieesuꞌ pa ma ohop peꞌ. Pare ni ee peꞌ pa kuruse, ko ki vakëkëh ee pa ma ohop peꞌ pa taanaꞌ ö. Ka taanaꞌ teꞌ vëvënsun kon vakëkëh ee pa ma ohop peꞌ. Ee to kon me ee po ohop rë peꞌ, o teꞌ vëvënsun to ep va ne manih pan, o ohop pamëh nee to hikta kukurus o rara, pare kun vavaꞌpeh. Ahik, o ohop pamëh nee to nok voh po paeoh o rara. ");
INSERT INTO tpz_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ee koman to vavasoe e ne, pare soe pan, “Ea se vi a saatuꞌ, para ep këh eteh se kon po ohop pamëh.” Ka tah pamëh to tanok to vapuh en pa soe to kiun non po Puk pe Sosoenën to soe non pan, “Ee to ki vakëkëh ee pa ma ohop peöꞌ, pare vi a saatuꞌ to ep këh eteh vëh se kon po ohop peöꞌ.” Keꞌ a taateꞌ akuk ko pamëh no teꞌ vëvënsun to vatet, pare taum ee pa teꞌ se kon ohop pamëh. ");
INSERT INTO tpz_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Manih pa sinten a kuruse ne Ieesuꞌ to han non, ne sinaneah, pen e kea peꞌ, me e Mariaꞌ köövo pe Kliopas, me e Mariaꞌ va Makdalaꞌ to sun ne. ");
INSERT INTO tpz_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","E Ieesuꞌ to ep in e sinaneah pen e vamomhë peꞌ vëh neꞌ to iu suntan non sih, to sun ne nën, ivëh neꞌ to soe suk va maꞌ manih pe sinaneah pan, “Eꞌ i maneom e koaꞌ pën.” ");
INSERT INTO tpz_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Vasuksuk poꞌ ne Ieesuꞌ to soe ke poꞌ en pe vamomhë peꞌ pamëh pan, “Eꞌ i maneom e sinömah.” Taneo non po poen pamëh no e vamomhë peꞌ pamëh to me en pe sisiꞌ pe Ieesuꞌ pa iuun peꞌ, pareꞌ matop e non peꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","A ma tah kurus to hik ee ke Ieesuꞌ nat en pa ma kiu peꞌ neꞌ to nok to hik en, pareꞌ soe vamanih pan, “Eöꞌ to mët eoꞌ po manoe.” Eꞌ to soe suk a soe vaꞌih marën a vapuh a soe to kiun non po Puk pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Eꞌ to teꞌ non a nöh to pet vatët non nën, no voaën to teꞌ non peꞌ. Ivëh ka nap vëvënsun kon a ta tah pupui nöh, ko vapuhpuh na po voaën, pare vahoꞌ manih po noton in o naon nee to popokaꞌ ne o hisop, ko vahoꞌ na pa rivon e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ke Ieesuꞌ kaak poꞌ en po voaën pamëh, pareꞌ soe en pan, “Eꞌ to hik en”. Eꞌ to soe vahik vakomanih, ka tuvuh peꞌ hik këh en peꞌ, keꞌ vamösru ko mët en. ");
INSERT INTO tpz_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Eꞌ o poen vamatop a ma tah va pa taëën va po Poen Apaapo. Ko Poen Apaapo pamëh, eꞌ o poen apuh rakah. Ko Jiuꞌ nö maꞌ pe Paëlat, pare hi poë, teꞌ vaonöt ke raoe kee kökök a ma moeero teꞌ varih to han ne pa kuruse, pan ee se mët vëvëhöꞌ. Ee to kehkeh herep ne raoe këh a ma kuruse. Suk ataeah, eꞌ o Vatönim ipamëh, kee hikta iu ne a ma sioniire se han ne pa kuruse po Poen Apaapo apuh pee. ");
INSERT INTO tpz_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","A nap vëvënsun to nö maꞌ ko taneo ee pa kökök a ma moeera poa teꞌ varih to han vaꞌpeh me ne e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ivëhkëk, ee to öök manih pe Ieesuꞌ, pare ep ee peꞌ to mët en. Ivëh, nee to hikta kökök suk pa poa moneah. ");
INSERT INTO tpz_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ka pah teꞌ vëvënsun ruk na a apan e Ieesuꞌ po peö, ko eraꞌ me a ruen takoꞌ vëvëhöꞌ rakah ee maꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ka teꞌ to ep voh non pa tah pamëh to hutët en pa tah neꞌ to ep voh, ka tah pamëh neꞌ to ep voh eꞌ a tah a man rakah. Ivëh, ke eöm me se vaman o vahutët pamëh. ");
INSERT INTO tpz_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ka ma tah poë varih to tanok, ee to vapuh ee pa soe to kiun non po Puk pe Sosoenën to soe non pan, “Ahik ta pah teꞌ to kök to pöh soaꞌ va pa teꞌ pamëh.” ");
INSERT INTO tpz_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Me a meh soe to kiun non po Puk pe Sosoenën to soe non pan, “Ee se ut ne pa teꞌ vëh nee to ruk poë po peö.” ");
INSERT INTO tpz_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Vasuksuk poꞌ in a mët pe Ieesuꞌ, ne Jeosëp va pa vöön va Arimatiaꞌ to nö manuh pe Paëlat, pareꞌ hi poan pan, eꞌ se iu non ko heꞌ poan a sionin e Ieesuꞌ. E Jeosëp me voh to vavatet aven voh e non pe Ieesuꞌ. Suk ataeah, eꞌ to nanaöp voh non o te susunön po Jiuꞌ, pareꞌ hikta vataare non o vaman peꞌ. Ke Paëlat soe vaonöt ken peꞌ pa teꞌ a sionin e Ieesuꞌ. Keꞌ nö ko teꞌ en pa sionineah. ");
INSERT INTO tpz_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ke Nikodimus a teꞌ vëh to nö voh pa ep pe Ieesuꞌ pa pah popoen, to nö vaꞌpeh me en pe Jeosëp. Eꞌ to teꞌ maꞌ o vanom avavuh vih rakah, o vanom pamëh nee to kon taneꞌ po hunun in o pöök naon, pare hovën. Ka punis in o vanom pamëh to oah non o 30 kilogram. ");
INSERT INTO tpz_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ka poa teꞌ poë varih e Nikodimus pen Jeosëp to teꞌ ee pa sionin e Ieesuꞌ, pare kupkup poë po rara matan vavih rakah. Ko vatëk poë po vanom vamanih pa ö no o Jiuꞌ to nonok va ne sih po teꞌ mët. ");
INSERT INTO tpz_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Eꞌ to teꞌ voh non a rak, pareꞌ teꞌ non a ö vavahoꞌ teꞌ mët no a hikta pah teꞌ to pet avoeꞌ non nën, to teꞌ vatët non pa ö vëh no a nap vëvënsun to ni voh e Ieesuꞌ pa kuruse. ");
INSERT INTO tpz_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Eꞌ to matanpoen en po poen vamatop in a ma tah va po Poen Apaapo. Ivëh, ke Jeosëp pen e Nikodimus kehkeh vahoꞌ vëhöꞌ ne a sionin e Ieesuꞌ pa ö vavahoꞌ teꞌ mët. A ö vavahoꞌ teꞌ mët pamëh to teꞌ vatët non manih pa ö nee to ni e Ieesuꞌ pa kuruse. Ee to teꞌ ee pa sionin e Ieesuꞌ, pare vahoꞌ ee peꞌ nën. ");
INSERT INTO tpz_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","A siꞌ ö hat ka muhin takah en po poen vamomoaan in o nënkikiu, ke Mariaꞌ va Makdalaꞌ nö en manuh po vapeepe to teꞌ non pa top vös. Eꞌ to tavus, pareꞌ ep in a vös vëh to sunpip non a matan a ö vëh ne Ieesuꞌ to pet non, to vahuk këh en pa matan a top vös vëh no a sionin Ieesuꞌ to pet non. ");
INSERT INTO tpz_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Eꞌ to ep in a vös to vahuk këh a matan o vapeepe, pareꞌ vaveo hah en manuh pe Saëmon Pitaꞌ me a meh vamomhë vëh ne Ieesuꞌ to iu suntan non sih poan. E Mariaꞌ to tavus manih pee, pareꞌ soe ke raoe pan, “O teꞌ to kon taneꞌ a sionin e Apuh manih po vapeepe, pare teꞌ ke ee, kemöm hikta nat nem ee vahoꞌ poë nih.” ");
INSERT INTO tpz_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ke Saëmon Pitaꞌ pen a meh vamomhë sun, pare nö ee manuh po vapeepe. ");
INSERT INTO tpz_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","A poa vahmomhë poë varih to vavaveo nö ne, ka meh vamomhë vavaveo oah e Pitaꞌ, pareꞌ tavus momoaan en manuh pa top vös. ");
INSERT INTO tpz_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","E vamomhë vëh to tavus momoaan manuh po vapeepe to kop, pareꞌ ep varoe na a ma rara to pet ne, pareꞌ hikta hop manuh pa ö nee to vahoꞌ voh e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","E Saëmon Pitaꞌ to suk tavus e meh vamomhë peꞌ, pareꞌ hop en manuh koman a top vös. Pareꞌ ep en po rara to pet non. ");
INSERT INTO tpz_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Eꞌ to ep me en pa ta rara vëh to mon voh non a pasun e Ieesuꞌ. A siꞌ ta rara pamëh to hikta pet vaꞌpeh me non o meoh rara. Eꞌ to pet ke e non maꞌ pa meh ö, eꞌ to ep ke non pan a meh teꞌ to nikun poan, ko vahoꞌ nën. ");
INSERT INTO tpz_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ka teꞌ vamomhë vëh to tavus momoaan manuh po vapeepe, eꞌ me to hop en manuh pa koman a top vös. Pareꞌ ep me en pa ma tah poë varih to tanok koman a top vös, ko vaman en. ");
INSERT INTO tpz_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Manih pa ma poen poë varih nee to hikta nat vamaaka avoeꞌ ne pa soe to kiun voh non po Puk pe Sosoenën to soe non, pan e Ieesuꞌ se sun taneꞌ hah en po vapeepe. ");
INSERT INTO tpz_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Vasuksuk poꞌ no a poa vamomhë to vos hah ee vöön. ");
INSERT INTO tpz_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","E Mariaꞌ to sun avoeꞌ e non sinten a top vös, pareꞌ okook non. Eꞌ to okook non, pareꞌ kop ko ves hop e na pa koman a top vös. ");
INSERT INTO tpz_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Eꞌ to ves hop na pa koman a top vös, pareꞌ ep in a poa ankeroꞌ to ohop ne a ma ohop kakaare. Pare ihoꞌ ne manih pa ö no a sionin e Ieesuꞌ to pet voh non. A paeh to ihoꞌ non manih pa ö no a pasuneah to pet koe voh non, ka meh manih pa moneah. ");
INSERT INTO tpz_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ka poa ankeroꞌ poë varih hi ee pe Mariaꞌ pan, “Köövo, eën okook nom ataeah?” Keꞌ piun raoe, pareꞌ soe pan, “O teꞌ to teꞌ ke ee pa sionin e Sunön peöꞌ. Ke eöꞌ hikta nat noꞌ ee vahoꞌ poë nih.” ");
INSERT INTO tpz_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","E Mariaꞌ to sosoe vahik va ko non manih, pareꞌ tarih ko ep en pe Ieesuꞌ to sun non. Ivëhkëk, eꞌ to hikta nat non pan eꞌ e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ke Ieesuꞌ hi poan, pareꞌ soe pan, “Köövo eën iu nom e teh, parën okook nom? E Mariaꞌ to koman non pan eꞌ a teꞌ vëh to matop non sih a rak. Pareꞌ soe va in poan manih, “Topoan eën se keh teꞌ ke voh a sionin e Ieesuꞌ, soe ka neoꞌ ah a ö nën to vahoꞌ eah, köꞌ nö ko kon eah.” ");
INSERT INTO tpz_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ke Ieesuꞌ vaoe poan, pareꞌ soe pan, “Mariaꞌ”. Ke Mariaꞌ tarih, pareꞌ soe vamanih po to va Hibru. “Rabonaëꞌ”, ka soe pamëh to soe va non manih pan, “Tövavaasis”. ");
INSERT INTO tpz_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ke Ieesuꞌ soe ke Mariaꞌ pan, “Koe a vaket peöꞌ, suk ataeah, eöꞌ to hikta peah avoeꞌ hah noꞌ manuh pe Tamön. Ivëhkëk, eën se nö na manuh pa ma kea peöꞌ, parën soe ke raoe a ö nöꞌ to hah eoꞌ manuh pe Tamön, eꞌ me e Tamëneöm. Eöꞌ to nö eoꞌ manuh pe Sosoenën peöꞌ me eꞌ e Sosoenën peöm.” ");
INSERT INTO tpz_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ivëh, ke Mariaꞌ va Makdalaꞌ nö, pareꞌ soe ken pa ma vamomhë pö neꞌ to ep en maꞌ pe Ieesuꞌ. Pareꞌ soe pet ken pee pataeah ne Ieesuꞌ to soe ke maꞌ poan. ");
INSERT INTO tpz_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","A muhin to matanpoen en po poen vamomoaan in o nënkikiu, ko vamomhë peꞌ tönun ee koman iuun, pare papanih pip rea, ko teꞌ e ne koman iuun. Suk ataeah, ee to nanaöp e ne po Jiuꞌ. E Ieesuꞌ to tavus maꞌ, pareꞌ sun e non pa topniire, pareꞌ soe ke rapoë pan, “Taateꞌ moomo to teꞌ vaꞌpeh me a no neöm.” ");
INSERT INTO tpz_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","E Ieesuꞌ to soe vahik vakomanih, pareꞌ vataare en pee pa poa koreneah me a apaneah. O vamomhë to vaeö suntan rakah ee pö nee to ep in e Sunön pee. ");
INSERT INTO tpz_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ke Ieesuꞌ soe hahah ko ken pee pan, “Taateꞌ moomo to teꞌ vaꞌpeh me a non neöm. E Tamön to vanö voh a maꞌ neoꞌ manih, ke eöꞌ me se vanö eoꞌ peöm manuh po oeh avoes.” ");
INSERT INTO tpz_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Eꞌ to soe vakomanih, pareꞌ piu en pa tuvuh peꞌ manih pa ma vamomhë peꞌ, pareꞌ soe ke raoe pan, “Kon öm a Tuvuh Vasioꞌ, nöꞌ to heꞌ a neöm. ");
INSERT INTO tpz_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Eöm se keh ihan anoe a ma hat pa ma napan, a ma hat pee ne Sosoenën se ihan anoe en pee. Ivëhkëk, eöm se keh hikta ihan anoe a ma hat poë varih, a ma hat poë varih to hikta onöt ne ahik.” ");
INSERT INTO tpz_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","A pah vamomhë to hikta teꞌ voh non pö ne Ieesuꞌ to tavus o vamomhë, ivëh e Tömas. A meh ëhnaneah ne to popokaꞌ ne sih poë pan e Didimus. ");
INSERT INTO tpz_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","E Tömas to hah maꞌ ko upöm vamomhë soe ke poë pan, “Emöm to ep vur em pe Sunön pea.” Ivëhkëk, e Tömas to soe ke raoe pan, “Eöꞌ se keh hikta ep a henen a ma ni, nee to ni manih pa koman a poa koreneah, me eöꞌ se këh hikta vahoꞌ a kumis koreneoꞌ manih pa henen a ma ni, me eöꞌ se keh hikta vahoꞌ a koreneoꞌ manih pa henen o peö vëh pa apaneah, a, eöꞌ hikta onöt noꞌ a vaman a neöm.” ");
INSERT INTO tpz_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","O nënkikiu to oah en ko vamomhë tönun hahah kov ee koman iuun, pare papanih pip rea, manih po poen pamëh ne Tömas to teꞌ vaꞌpeh me non pee. A iuun a papanih vakis rakah, ivëhkëk, e Ieesuꞌ to tavus, pareꞌ sun e non topniire, pareꞌ soe ke raoe pan, “A taateꞌ moomo to teꞌ vaꞌpeh me a no neöm.” ");
INSERT INTO tpz_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","E Ieesuꞌ to soe ke Tömas pan, “Vahoꞌ a kumis koreomah manih, parën ep pa poa koreneoꞌ, ko nö maꞌ, ko vahoꞌ a koreomah manih pa henen o peö vëh pa apaneoꞌ. Parën koe a vapikpiuk, ko vaman a neoꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","E Tömas to piun e Ieesuꞌ, pareꞌ soe pan, “Sunön peöꞌ, eën e Sosoenën peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ke Ieesuꞌ soe ke poꞌ poan pan, “Eën vaman kov eöm pö nën to ep ka neoꞌ oh? Vaeö rakah po teꞌ varih to hikta ep ka neoꞌ, pare vaman a ne neoꞌ, a napan va po oeh vëh se vaeö.” ");
INSERT INTO tpz_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","E Ieesuꞌ to nok a ma tah vatoksean peo rakah, o vamomhë peꞌ he ep ne. A ma tah vatoksean poë varih to hikta kiun vahik ne manih po Puk vaꞌih. ");
INSERT INTO tpz_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ivëhkëk, a soe va pa ma tah vatoksean poë varih nöꞌ to kiun manih po Puk vaꞌih pan eöm se ep, paröm vaman e Ieesuꞌ Kristo a teꞌ ne Sosoenën to vateꞌ voh poan, pan eꞌ se kon taneꞌ hah a napan kurus peꞌ manih pa taateꞌ hat, keꞌeꞌ e koaꞌ pe Sosoenën. Ivëh, köm se keh vaman nem eah, eöm se kon koe em po toꞌtoꞌ tamoaan manih pa ëhnaneah. ");
INSERT INTO tpz_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","A ma tah kurus varih to tanok vahik ee, ke Ieesuꞌ tavus hah en pa ma vamomhë peꞌ manih pa tonon va Galiliꞌ. Ka meh ö nee to popokaꞌ va ne a tonon pamëh ivëh, a Taëberius. Keꞌ eꞌ ivaꞌih a ö ne Ieesuꞌ to vataare hah vavoh in. ");
INSERT INTO tpz_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","A ma pah vamomhë varoe to tönun, pare teꞌ ne nën. E Saëmon Pitaꞌ ke Tömas a meh ëhnaneah e Didimus, ke Nataniel a teꞌ va Kenaꞌ manih pa muhin va Galiliꞌ, me ra poa sunaiꞌ Sëbëdiꞌ, me ra meh poa vamomhë pe Ieesuꞌ, ee to teꞌ vaꞌpeh ne. ");
INSERT INTO tpz_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ke Saëmon Pitaꞌ soe ke ro upöm vamomhë peꞌ pan, “Eöꞌ se nö eoꞌ pa taanaꞌ iian.” Ko upöm soe ee maꞌ pan, “Emöm me se nö vaꞌpeh me a oah pa taanaꞌ iian. Kee nö ko tok ee po paröꞌ. Ivëhkëk, manih pa popoen avoes pamëh, nee to hikta vaon rakah ta pah iian. ");
INSERT INTO tpz_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pa pöstakah rakah no a potan to pepeah nö non maꞌ, ko vamomhë ep i na e Ieesuꞌ to sun non sinten tonon. Ivëhkëk, ee to hikta nat e ne poë e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ke Ieesuꞌ hi en maꞌ pee pan, “Pus koaꞌ, eöm vaon vur em pa ta ma iian ah?” Kee piun a soe peꞌ, pare soe pan, “Ahik! Ahik rakah ta siꞌ tah nemöm to vaon vu.” ");
INSERT INTO tpz_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ke Ieesuꞌ soe ke raoe pan, “Vöknah koe in a kë peöm manih pa papmatö in o paröꞌ, paröm vaon ta ma iian.” Ivëh, kee vöknah ee pa kë pee ko iian oon suntan rakah ee, kee hikta onöt ne a rëh peah hah maꞌ a kë manih po paröꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ke vamomhë vëh ne Ieesuꞌ to iu oah rakah non sih poan soe ke Pitaꞌ pan, “A teꞌ vëh, eꞌ e Sunön.” Ke Pitaꞌ pënton vakomanih pan, “Eꞌ e Sunön”, pareꞌ pakuh vakis hah o ohop peꞌ, pareꞌ surap en na tonon ko akaꞌ takin en. ");
INSERT INTO tpz_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ko upöm vamomhë varih to tok ne po paröꞌ, hoaꞌ takin me ee maꞌ pa kë to puh non po iian. Ee to hikta teꞌ varo këh voh ne a sinten tonon, ee to varo va ne maꞌ manih pa 100 mitaꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","O vamomhë to tatakin këh ko ne maꞌ o paröꞌ, pare ep ee po suraꞌ ororan, no a pah iian to tok non me a pah ö taëën. ");
INSERT INTO tpz_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ke Ieesuꞌ soe ke raoe pan, “Teꞌ maꞌ öm ta ma iian po iian varih nöm to vaon ko maꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ke Saëmon Pitaꞌ peah hah en manuh po paröꞌ, pareꞌ rëh takin en maꞌ pa kë to puh rakah non po iian apaꞌpuh. O iian to peo onöt ne a 153. Ivëhkëk, a kë vëh nee to rëh o iian to hikta tökrus. ");
INSERT INTO tpz_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ke Ieesuꞌ vaoe e na pee, pareꞌ soe na pan, “Nö maꞌ öm ko ëën.” Ivëhkëk, ahikta pah vamomhë to hi e Ieesuꞌ pan, “Eën eteh?” Suk ataeah, ee to nat e ne pe, eꞌ akuk kuru e Sunön. ");
INSERT INTO tpz_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ivëh, ke Ieesuꞌ nö en manuh pee, pareꞌ kon a ö taëën ko heꞌ en pee. Eꞌ to kon a iian, pareꞌ heꞌ pet en pee. ");
INSERT INTO tpz_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Keꞌ ivaꞌih a vakön poen ne Ieesuꞌ to tavus a ma vamomhë peꞌ murin in a ö neꞌ to sun taneꞌ hah pa mët. ");
INSERT INTO tpz_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ee to ëën vahik ee ke Ieesuꞌ soe ke Saëmon Pitaꞌ pan, “Saëmon, sunaiꞌ Jon, eën iu oah rakah kës e nom peöꞌ pa ö no upöm to iu va ka ne neoꞌ? Ke Pitaꞌ soe ken pe Ieesuꞌ pan, “A, Sunön, eën to nat e nom peöꞌ to iu e noꞌ pën.” Ke Ieesuꞌ soe ke poan pan, “Makën vavih a ma soneꞌ sipsip peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","E Ieesuꞌ to vapöök hi en pe Pitaꞌ pan, “Saëmon sunaiꞌ Jon, eën iu rakah e nom peöꞌ öh?” Ke Pitaꞌ piun, pareꞌ soe pan, “A, Sunön, eën to nat e nom peöꞌ to iu e noꞌ pën.” Ke Ieesuꞌ soe ken peꞌ pan, “Matop vavih nom o sipsip peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","E Ieesuꞌ to vakön hi en pe Pitaꞌ pan, “Saëmon sunaiꞌ Jon, eën iu e nom peöꞌ öh?” Ke Pitaꞌ haraꞌ vahat rakah en po tamak, suk e Ieesuꞌ to vakön hi en peꞌ pan, “Eën iu e nom peöꞌ öh?” Ivëh, neꞌ to soe suk va in na poan manih pan, “Sunön, eën to nat e nom pa ma moeh tah kurus, parën nat rakah e nom peöꞌ to iu e noꞌ pën.” Ke Ieesuꞌ soe ke poan pan, “Mamakën vavih nom ah o sipsip peöꞌ.” ");
INSERT INTO tpz_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Eöꞌ to soe vamaman rakah keoꞌ pën, “O poen nën to teꞌ sekaꞌ voh nom, eën se voh o voh pën, parën nö eom pa ö nën to iu nö nom. Ivëhkëk, o poen nën se manot, eën se kë a koreomah ka meh teꞌ voh a oah po voh pën. Ko me koe ken pën pa ma ö nën to hikta iu nö nom.” ");
INSERT INTO tpz_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","E Ieesuꞌ to heꞌ a soe vaꞌih, eꞌ to sosoe suk non a ö ne Pitaꞌ se mët vah va, marën a kë a ëhnan e Sosoenën. E Ieesuꞌ to soe vahik vakomanih, pareꞌ soe ke Pitaꞌ pan, “Pitaꞌ, suk a maꞌ neoꞌ ah.” ");
INSERT INTO tpz_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","E Pitaꞌ to tarih ko ep i na e vamomhë vëh ne Ieesuꞌ to iu oah rakah non sih, to suksuk nö non maꞌ raoe. E vamomhë pamëh to vahoꞌ voh a pasuneah manih pa poen e Ieesuꞌ, po poen nee to ënëën ne, pareꞌ hi poan pan, “Sunön eteh vëh se vikuh ka oah manih pa napan varih to hat ov a nom oah?” ");
INSERT INTO tpz_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","E Pitaꞌ to ep na poan to suksuk nö non raoe, pareꞌ hi e Ieesuꞌ pan, “Sunön, ka teꞌ poꞌ vëh no ataeah se tavus amot maꞌ manih peꞌ?” ");
INSERT INTO tpz_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ke Ieesuꞌ piun poan, pareꞌ soe pan, “Eöꞌ se keh iu noꞌ a ö neꞌ se teꞌ toꞌtoꞌ non, ko onöt po poen nöꞌ se hah maꞌ, keꞌ teꞌ e non. Suk ataeah, a tah pamëh to hikta teꞌ non pan, a tah pën. Suk varoe a maꞌ neoꞌ ah.” ");
INSERT INTO tpz_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ivëh, ka soe nö vavah en topniira napan va po vaman, a soe pamëh to soe suk non e vamomhë pamëh to hikta antoen non a mët. Ivëhkëk, e Ieesuꞌ to hikta sosoe voh non pan, e vamomhë pamëh to hikta antoen non a mët. Ahik, eꞌ to sosoe vavoh non manih pan, “Eöꞌ se keh iu noꞌ, ke vamomhë pamëh teꞌ toꞌtoꞌ e non, keꞌ onöt po poen nöꞌ se hah maꞌ. A tah pamëh to hikta teꞌ non pan eꞌ a tah pën.” ");
INSERT INTO tpz_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","E vamomhë akuk ko pamëh ivaꞌih, to ep voh non a ma tah poë varih, pareꞌ kiuntön, ivëh, ka nat e no pa ma soe neꞌ to vavatvus non, ee a ma soe man vaviꞌ. ");
INSERT INTO tpz_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Eꞌ to teꞌ me non a ma meh tah peo ne Ieesuꞌ to nonok voh non. Ea se keh kiun suk vahik rakah raoe, eöꞌ to koman noꞌ pan, o oeh avoes vëh to hikta apuh onöt non a ö neꞌ se öt non a ma puk poë varih. ");
INSERT INTO tpz_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Eöꞌ e Luk to kiun ka nös oah Tiopiras, eën a teꞌ apuh. Manih po puk va momoaan nöꞌ to kiun, eöꞌ to kiun suk voh a ma tah kurus ne Ieesuꞌ to nok voh, pareꞌ vavaasis voh non a ma napan. ");
INSERT INTO tpz_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Eöꞌ to kiun suk rakah a pop pe Ieesuꞌ pa taneo, keꞌ öök maꞌ po poen ne Sosoenën to me hah en peꞌ manuh pa vöön va kin. Momoaan in a peah peꞌ eꞌ to vavaasis a ma teꞌ varih neꞌ to vateꞌ, pareꞌ vëhnan raoe o aposol peꞌ. Pa vaꞌaus pa Tuvuh Vasioꞌ eꞌ to soe ke raoe a ma tah nee se nonok ne. ");
INSERT INTO tpz_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Vasuksuk in a kamis me a mët peꞌ, eꞌ to nok a ma tah peo to vataare non raoe pan, eꞌ to teꞌ toꞌtoꞌ e non. O aposol to epep voh ne e Ieesuꞌ komön o 40 poen. Ke Ieesuꞌ vaato me non raoe suk a Matop Vih pe Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Po poen neꞌ to vaënëën me non raoe, eꞌ to soe ke raoe pan, “Nat nem këh a vöön Jerusalëm, eöm se anoeh nem o heꞌ vëh va pa Tuvuh Vasioꞌ ne Tamön to soe vaman voh a ö neꞌ se heꞌ a maꞌ neöm pa ö nöꞌ to soe vavoh ka neöm. ");
INSERT INTO tpz_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","E Jon Tövapupui to pupui voh a ma napan pa ruen, ka hikta ma poen peo to teꞌ ne nöm se kon a pupui manih pa Tuvuh Vasioꞌ.” ");
INSERT INTO tpz_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Manih po poen pamëh o aposol to tönun pa Tope Öliv, pare hi poë pan, “Apuh, kuru eën se pöꞌ ununun hah eom po vakum va Israël, ha?” Ee to hi, suk ee to koman ne pan, e Ieesuꞌ to se kon hah këh a matop pa Kaman va Room ko heꞌ a napan va Israël. ");
INSERT INTO tpz_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ke Ieesuꞌ soe ke raoe pan, “Eꞌ hikta teꞌ non pan, eöm se nat nem po poen me a potan, e Tamön koman to vateꞌ maꞌ, pareꞌ matop non. ");
INSERT INTO tpz_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ivëhkëk, a Tuvuh Vasioꞌ se nö maꞌ manih peöm ko vakikis a neöm pa vatvus a soe peöꞌ manih Jerusalëm, me pa moeh Jiutiaꞌ, me pa moeh Samëriaꞌ, me po oeh avoes.” ");
INSERT INTO tpz_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","E Ieesuꞌ to soe vahik a soe pamëh, kee ep e ne peꞌ to peah. Ka unöh koaan en peꞌ, kee hikta ep hah i ne na poë. ");
INSERT INTO tpz_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Eꞌ to nö en kee kuteꞌ suk e ne na, ka varuꞌ vakomanih a poa teꞌ to sun vaꞌpeh me e ne pee, ee to ohop ne a ma ohop kakaare. ");
INSERT INTO tpz_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ka poa teꞌ soe ke raoe pan, “Topa voe va Galiliꞌ, suk ataeah, köm kuteꞌ nem na akis? E Ieesuꞌ vëh ne Sosoenën to me këh a neöm manuh pa vöön va kin, eꞌ se hah va en maꞌ manih pa ö nöm to ep va nem eah to nö.” ");
INSERT INTO tpz_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ka ma aposol hah ee Jerusalëm to këh ee maꞌ pa Tope Öliv, a ö pamëh to hikta teꞌ varo non. ");
INSERT INTO tpz_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ee to vos Jerusalëm, ko ho ee pa iuun nee to teꞌ ne, e Pitaꞌ, ke Jon, ke Jëmis, ke Ëndruꞌ, ke Filip, ke Tömas, ke Batromioꞌ, ke Matiu, ke Jëmis e sunaiꞌ Apias, ke Saëmon a teꞌ va po vakum nee to pokaꞌ ne Selöt, me e Jiutas e sunaiꞌ Jëmis. ");
INSERT INTO tpz_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tamoaan a ma teꞌ poë varih to teꞌ vatönun ne, pare hinhin ne sih. A ma köövo to teꞌ vaꞌpeh me ne raoe, e Mariaꞌ sinan e Ieesuꞌ, me a ma kea pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","A ma siꞌ poen to oah ee, ko teꞌ varih to vaman ne a soe pe Ieesuꞌ to öt o ihoꞌ, a napan to onöt va ne manih po 120 teꞌ. Ke Pitaꞌ sun, pareꞌ heꞌ a soe. ");
INSERT INTO tpz_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","E Pitaꞌ to soe pan, “Kën kea, a soe to teꞌ non po Puk Vapenpen to tavus vaman en, moaan voh no a Tuvuh Vasioꞌ to soe voh manih pa rivon e Devit. E Devit to soe suk voh e Jiutas pan, eꞌ a teꞌ vëh to vovoh non pa napan marën a öt e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","E Jiutas a teꞌ vavoh po vakum pea, eꞌ to kon voh a kiu marën a vaꞌaus a ma meh teꞌ to teꞌ ne a punis.” ");
INSERT INTO tpz_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","A moniꞌ ne Jiutas to kon suk a hat neꞌ to nok voh no teꞌ ësës heꞌ to öt, ko voen a ö oeh. E Jiutas to oot ko vuꞌ en po oeh nee to voen ka ma kakomaneah tësvak ee ko tavus kurus ee maꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","A ma napan kurus to teꞌ ne Jerusalëm to tënan a tah vaꞌih, ka manih po to pee, ee to vëhnan a ö oeh pamëh “Akëltamaꞌ”, to soe va non manih pan, “Oeh va po Eraꞌ.” ");
INSERT INTO tpz_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ke Pitaꞌ soe vamanih pan, “A soe vëh nee to kiun voh po Puk Vaëhëh eꞌ to teꞌ va non manih pan, ‘A iuun peꞌ se teꞌ upin e non, ahikta teꞌ se teꞌ non manih peꞌ.’ O meoh vaëhëh to soe non pan, ‘A meh teꞌ se kon a kiu peꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ivëh, pa vapuh a soe, ea se vateꞌ ta pah teꞌ manih komön o vakum pea to teꞌ vaꞌpeh me a rora taneo no maꞌ po poen ne Ieesuꞌ to nönö vah me voh a rora. ");
INSERT INTO tpz_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","A teꞌ to teꞌ vaꞌpeh me voh a rora po poen ne Jon to pupui voh non e Ieesuꞌ, keꞌ nö no maꞌ, ko antoen po poen ne Sosoenën to me peah hah e Ieesuꞌ. A teꞌ pamëh to ep voh non a ma tah me a sun hah pe Ieesuꞌ, eꞌ se vavaasis me a soe tavus a ma tah poë varih.” ");
INSERT INTO tpz_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ee to vateꞌ ee pa poa teꞌ, e Jeosëp Basabas, pareꞌ teꞌ non o meoh ëhnan, e Jastus. Ka meh teꞌ, e Matias. ");
INSERT INTO tpz_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Pare hin va ee manih pan, “Apuh, eën to nat nom o kokoman po teꞌ kurus. ");
INSERT INTO tpz_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Eën se vataare a möm a paeh va pa poa teꞌ varih nën to vateꞌ pa kon a kiu aposol, keꞌ panih non e Jiutas to mët ko nö en pa vöön pa nap hat.” ");
INSERT INTO tpz_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kee soe vaonöt poꞌ ee pe Matias se vakorot en po havun me a paeh aposol. ");
INSERT INTO tpz_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","O Pëntëkös, eꞌ o poen apuh po Jiuꞌ ka ma teꞌ varih to vaman ne tönun ee pa pah koman iuun. ");
INSERT INTO tpz_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ka varuꞌ rakah vakomanih, ee to pënton a muhin to noeꞌtan en maꞌ vamanih pa tuvuh apuh to taneꞌ maꞌ kin, a noeꞌtan pamëh to ho maꞌ koman iuun nee to teꞌ ne. ");
INSERT INTO tpz_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kee ep a pah tah to matan va non manih po tëkrea va po suraꞌ, to teꞌ nö non pa ma pasuire kurus. ");
INSERT INTO tpz_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ee kurus to puh rakah ne pa Tuvuh Vasioꞌ, pare taneo ee pa vaato pa ma meh upöm to, suk a Tuvuh Vasioꞌ to vaꞌaus raoe pa vaato. ");
INSERT INTO tpz_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Eꞌ to teꞌ non o Jiuꞌ to teꞌ ne manih Jerusalëm to taneꞌ maꞌ pa ma ö kurus va po oeh to vasunön vatëh ne e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Manih po poen no a taheak pamëh to nö maꞌ, a nap peo rakah to tönun maꞌ. Ee to toksean rakah ee pa ö nee to tënan a ö no a ma teꞌ varih to vaman ne to vavaato e ne pa ma to koman pee. ");
INSERT INTO tpz_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ee to töhkak, pare pah kokoman vörep e ne, pare soe pan, “A ma teꞌ varih to vavaato ne, ee a ma teꞌ va Galiliꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Vahvanih kea kurus varih pënton e no pee to vaato ne pa ma to koman pea? ");
INSERT INTO tpz_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ea a ma teꞌ va Patiaꞌ, me Midiaꞌ, me Ilam, me to taneꞌ maꞌ Mësopotemiaꞌ, me manih Jiutiaꞌ, me Kapadosiaꞌ, me manih Pontus, me Esiaꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Manih Frigiaꞌ, me Pamfiliaꞌ, me manih Isip, me manih pa ö va Libiaꞌ to vatët non Saëriniꞌ, me a ma teꞌ va Room to nö maꞌ ko teꞌ ne manih. ");
INSERT INTO tpz_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ea a ma to Jiuꞌ, me o upöm teꞌ to kon a taateꞌ po Jiuꞌ. A ma meh va pea to taneꞌ maꞌ Krit, me Arebiaꞌ, ea kurus to tënan e no pee to vavaato ne pa ma to koman pea pa ma tah apuh ne Sosoenën to nok voh.” ");
INSERT INTO tpz_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ee kurus to toksean, pare pah kokoman vörep e ne, pare vaiihi koman hah e ne, “A tah vaꞌih, eꞌ teꞌ vah va non nih?” ");
INSERT INTO tpz_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ivëhkëk, a ma upöm to vavovoeak ne, pare soe pan, “A ma teꞌ varih to kaak o voaën voon, pare sipak.” ");
INSERT INTO tpz_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ivëh, ke Pitaꞌ me a havun me a pah aposol sun, pareꞌ vaato me a napan varih to teꞌ ne, ko soe pan, “Eöm o Jiuꞌ, me a ma napan kurus to nö maꞌ ko teꞌ nem manih Jerusalëm, pënton öm, köꞌ soe ka neöm a ö no a tah vaꞌih to teꞌ va non, köm se nat. ");
INSERT INTO tpz_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Eöm to koman nem pan, a ma teꞌ varih to kaak, ko vaato ne, ivëhkëk ahik, eꞌ to naën kirök non pa pöstakah. ");
INSERT INTO tpz_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","E Joel, a teꞌ vanënën soe to sosoe suk voh non a ma tah varih pan, ");
INSERT INTO tpz_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“E Sosoenën to soe pan, ‘A ma tah varih se tanok po poen to vatët non pa ö no oeh se hik. Eöꞌ se vanö nös a Tuvuh peöꞌ manih po teꞌ kurus. A ma koaꞌ oeteꞌ me o teꞌ o mon, se vavatvus ne a soe vamanih po teꞌ vanënën soe, eöꞌ se vataare a ma teꞌ sesekaꞌ peöm pa taateꞌ tata, ka ma teꞌ mamanot se tatarep a ma tatarep. ");
INSERT INTO tpz_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","A, manih po poen pamëh, eöꞌ se vanö nös a Tuvuh Vasioꞌ peöꞌ, manih pa nap oeteꞌ kikiu akuk, me o köövo kikiu akuk. Kee se vatvus a soe vamanih po teꞌ vanënën soe. ");
INSERT INTO tpz_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Eöꞌ se nok a tah vatoksean manih pa akis, me manih vakunah po oeh. O eraꞌ me o suraꞌ me o öh vëh o apuh se tavus. ");
INSERT INTO tpz_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","A potan se popoen, ka sivö se ereraꞌ vamanih po eraꞌ. Po vasuksuk ne Sunön se tavus maꞌ. O poen pamëh e Sunön se kiiki a ma moeh tah. ");
INSERT INTO tpz_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ka napan kurus rakah to hinhin ne a ö ne Sosoenën se kon hah raoe, a, e Sosoenën se kon hah raoe, kee teꞌ ne a ma napan peꞌ.’” ");
INSERT INTO tpz_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pënton öm a soe vaꞌih ma napan va Israël, e Ieesuꞌ va Nasarët a teꞌ ne Sosoenën to vateꞌ voh. Eöm to nat e nem pa ma kiu apuh me a ma vu tah vatoksean ne Sosoenën to nok topnineöm pa koren a teꞌ pamëh. A ma tah poë varih to vataare e non pe Ieesuꞌ to teꞌ toꞌtoꞌ e non. ");
INSERT INTO tpz_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Moaan voh ne Sosoenën to koman voh e non pa vahoꞌ e Ieesuꞌ manih pa koreneöm, köm heꞌ eah pa koren a nap hat, pan ee se ip vamët ko vahan poë pa kuruse. ");
INSERT INTO tpz_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ivëhkëk, e Sosoenën to vatoꞌ taneꞌ hah poan po vapeepe, marën a vahik këh poan pa ma kamis va pa mët, suk a mët to hikta onöt non a ötöön a teꞌ pamëh. ");
INSERT INTO tpz_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","E Devit to vahutët suk voh non pan, ‘Eöꞌ to ep tamoaan e noꞌ pe Sunön to teꞌ non pa havineoꞌ, eꞌ to teꞌ non po papmatö peöꞌ. Ivëh, ka hikta tah to onöt non pa miröꞌ a neoꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ivëh, ka komaneoꞌ vih rakah, köꞌ soe a soe vaeö. Eöꞌ to teꞌ noꞌ pa taateꞌ anoeh. ");
INSERT INTO tpz_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Eën to hikta se koe nom apeneoꞌ, keꞌ teꞌ non manih pa ö teꞌteꞌ pa nap mët. Eën hikta se koe nom a teꞌ vivihan pën, keꞌ koa manih po vapeepe. ");
INSERT INTO tpz_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Eën to vataare eom peöꞌ pa hanan to nö non po toꞌtoꞌ tamoaan. Eën se teꞌ vaꞌpeh me a no neoꞌ, köꞌ se teꞌ vaeö rakah noꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Kën kea, eöꞌ to iu soe tavus rakah ka no neöm pe sipuura e Devit. Eꞌ to mët voh en, kee pe ee peꞌ, ko vapeepe peꞌ to teꞌ e non manih topniira kuru vëh. ");
INSERT INTO tpz_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","E Devit voh a teꞌ vanënën soe, keꞌ nat voh e non pe Sosoenën to heꞌ voh a soe kikis manih pe Devit, pareꞌ soe pan, ‘Amot eöꞌ se vateꞌ a pah koaꞌ pën, keꞌ tavus a teꞌ sunön vamanih pën.’ ");
INSERT INTO tpz_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","E Devit to ep voh en pa tah ne Sosoenën se nok, pareꞌ soe voh a ö ne Kristo se sun taneꞌ hah po vapeepe. E Devit to vatvus a soe pe Sosoenën, pareꞌ soe pan, ‘Eöꞌ hikta se koe noꞌ eah, keꞌ teꞌ non manih pa ö teꞌteꞌ pa nap mët. Ka sionineah hikta se koa non.’ ");
INSERT INTO tpz_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","E Sosoenën to vatoꞌ hah e Ieesuꞌ po vapeepe, kemöm kurus varih to ep voh e nem peꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","E Sosoenën to vasunön eah, pareꞌ vahoꞌ poan pa papmatö peꞌ. Keꞌ kon taneꞌ manih peꞌ a Tuvuh Vasioꞌ vamanih pa ö neꞌ to soe vaman vavoh. A ma vaato varih nöm to ep me pënton nem kuru, eꞌ a Tuvuh Vasioꞌ to heꞌ tavus manih pemöm. ");
INSERT INTO tpz_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","E Devit to hikta nö voh manuh pa vöön va kin, ivëhkëk, eꞌ to soe pan, ‘E Sunön to soe ke Sunön peöꞌ vamanih pan, “Eën se ihoꞌ pa papmatö peöꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Ka amot eöꞌ se vahoꞌ a ma teꞌ varih to hat ka nom oah, kee teꞌ rakah ne maꞌ paan eën.” ’ ");
INSERT INTO tpz_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ka ma napan va Israël se nat ne, eꞌ e Ieesuꞌ vëh, neöm to ni eah pa kuruse, ne Sosoenën to vateꞌ poan e Sunön, e Kristo.” ");
INSERT INTO tpz_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","A soe no a napan to tënan to ruk rakah en po kokoman pee, kee soe ke Pitaꞌ me a ma meh aposol pan, “Emöm se nok poꞌ ataeah, kën kea?” ");
INSERT INTO tpz_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ke Pitaꞌ soe ke raoe, “Eöm papaeh teꞌ se panih o kokoman me a taateꞌ peöm, kemöm pupui a neöm pa ëhnan e Ieesuꞌ Kristo, ke Sosoenën se ihan anoe a ma hat peöm, köm kon o heꞌ peꞌ, ivëh a Tuvuh Vasioꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Moaan voh ne Sosoenën to soe vaman voh ken peöm me a ma koaꞌ peöm, pa ö neꞌ se heꞌ a neöm a Tuvuh Vasioꞌ. Manih me pa ma napan to teꞌ varo ne maꞌ, e Sosoenën to vaoe non raoe kee pënton ko vatet. ");
INSERT INTO tpz_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","E Pitaꞌ to kömköm a napan, ko hi vakis raoe pan, “Vaꞌaus koman hah ëm pa ma kamis apuh varih se tavus manih pa ma nap hat vatösoe.” ");
INSERT INTO tpz_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","A napan peo rakah to pënton a soe pe Pitaꞌ, pare vaman, kee pupui ee pee po poen pamëh. Ee to antoen ne a 3,000 teꞌ to hop po vakum teꞌ to vaman ne. ");
INSERT INTO tpz_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Pa ma poen kurus o teꞌ to vaman ne to teꞌ vaꞌpeh me ne a ma aposol pa ëën, me a vavaasis a ma tah, me a hin vaꞌpeh. ");
INSERT INTO tpz_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","A napan to ep a ma tah vatoksean no aposol to nonok ne, pare toksean rakah ee. ");
INSERT INTO tpz_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","A ma napan varih to vaman ne Ieesuꞌ, to teꞌ vatönun tamoaan e ne. Ee to vaneah kurus e ne pa ma tah. ");
INSERT INTO tpz_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ee to vavoen hah a ma tah pee manih po meoh upöm teꞌ, kee voen, ka moniꞌ nee to kon, a moniꞌ pamëh nee se heꞌ a ma teꞌ varih to kökööt ne ta ma tah. ");
INSERT INTO tpz_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Pa ma poen kurus nee to vatönun ne manih pa Iuun Hinhin Apuh. Ee to ënëën ne pa ma iuun po upöm pee, pare vapöh kokoman ne, ko teꞌ vaeö rakah e ne. ");
INSERT INTO tpz_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ee to kë tamoaan rakah e ne pa ëhnan e Sosoenën, ka napan vih rakah ke ne pee. Pa ma poen kurus ne Sosoenën to vavapeo avoeꞌ e non maꞌ po vakum teꞌ to vaman ne. ");
INSERT INTO tpz_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","O pöh poen ne Pitaꞌ pen Jon to nö hahah kov ee pa Iuun Hinhin Apuh pa hin pa matanpoen pa 3 kirök. ");
INSERT INTO tpz_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Manuh po matan o Hopaꞌ Ep Vamanin a ö nee to pokaꞌ va ne o hopaꞌ pamëh, a pah teꞌ hat mon to teꞌ non. E sinaneah to vahuh koman vavoh en peꞌ nën. Pa ma poen kurus nee to teꞌteꞌ ariuk ne poë nën, keꞌ hinhin moniꞌ non a napan varih to oho ne pa Iuun Hinhin Apuh. ");
INSERT INTO tpz_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","A teꞌ pamëh to ep e Pitaꞌ pen e Jon to oho ne ko hin vakis raoe pan, ee se heꞌ poë ta moniꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ee to kuteꞌ rakah ne peꞌ, ke Pitaꞌ soe pan, “Kuteꞌ maꞌ möm ah.” ");
INSERT INTO tpz_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Keꞌ kuteꞌ en na manuh pee, ko anoeh non a öt a tah nee se heꞌ poë. ");
INSERT INTO tpz_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ke Pitaꞌ soe ke poan pan, “Eöꞌ a hikta moniꞌ rakah, ivëhkëk, eöꞌ se heꞌ oah a tah nöꞌ to teꞌ me noꞌ pa ëhnan e Ieesuꞌ va Nasarët, eöꞌ to taꞌ oah, sun ah, ko nö.” ");
INSERT INTO tpz_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ke Pitaꞌ öt pa papmatö peꞌ, pareꞌ kës vasun en peꞌ. Ka varuꞌ rakahvakomanih a ma mon me a ma ëkoꞌ moneah, to vih, ko eh hah ee. ");
INSERT INTO tpz_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Keꞌ taꞌkë ko sun en, ko taneo en pa nö vavah. Ko ho vaꞌpeh me en pee manuh pa Iuun Hinhin Apuh to vasusurap nö non, pareꞌ kë rakah non a ëhnan e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","A napan kurus to ep in poë to nönö vah non, pareꞌ kë rakah nö non a ëhnan Sosoenën, ");
INSERT INTO tpz_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","a napan to inan poë, pare nat e ne eꞌ a teꞌ voh vëh to hinhin moniꞌ voh non sih, manih po sinten o Matan Hopaꞌ Ep Vamanin in a Iuun Hinhin Apuh. Ee to töhkak ko toksean rakah e ne pa tah to vavih poan. ");
INSERT INTO tpz_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","E voe to vaket nö non pe Pitaꞌ pen Jon, ka napan kurus toksean rakah ee, ko vaveo ee manuh pa Parantaꞌ pe Solomon, eꞌ o ëhnan in a ö pamëh. ");
INSERT INTO tpz_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","E Pitaꞌ to ep a napan, pareꞌ soe ke raoe pan, “Ma napan va Israël, suk ataeah, köm toksean paröm kuteꞌ nemöm. Eöm koman nem pan, eꞌ o kikis me a taateꞌ vivihan koman pemöm ivaꞌih ka teꞌ vëh nö vavih hah, ha? ");
INSERT INTO tpz_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","E Sosoenën pe Abraham, pe Aësak, me e Jekop, e Sosoenën pa kën sipuura. Eꞌ to kë voh a teꞌ kikiu peꞌ e Ieesuꞌ, eꞌ a teꞌ vëh nöm to rës ko heꞌ voh eah manih pa koren e Paëlat, ke Paëlat iu vahah e non peꞌ pa vih, ivëhkëk eꞌ to vatet en po iu peöm pa ip vamët e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Eꞌ a teꞌ vivihan, pareꞌ vih vörep nöm to heꞌ tonun voh eah. Eöm to hin voh e Paëlat a ö neꞌ se vanö ka neöm a teꞌ ipip teꞌ keꞌ heꞌ en peöm. ");
INSERT INTO tpz_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ivëh, köm ip voh em peꞌ, a teꞌ to heꞌ non o toꞌtoꞌ, ivëhkëk, e Sosoenën to vatoꞌ hah poan këh a nap mët, kemöm ep voh em pa tah vaꞌih. ");
INSERT INTO tpz_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Eꞌ o kikis va pa ëhnan e Ieesuꞌ ivëh, nemöm poꞌ to vaman nem ivëh, to vavih hah a teꞌ hat mon vëh. A tah vëh nöm to ep, a, ko nat nem to tanok suk o vaman pemöm poꞌ pa ëhnan e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Varuꞌ vamanih kën kea, eöꞌ to nat e noꞌ eöm kurus, me a ma teꞌ susun, me o teꞌ ësës heꞌ peöm to hikta nat voh ne pataeah nöm to nok voh manih pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Moaan rakah voh ne Sosoenën to heꞌ voh a soe manih po teꞌ vanënën soe pan, e Kristo se teꞌ o kamis apuh, eꞌ ivaꞌih to tavus vaman en. ");
INSERT INTO tpz_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ivëh, köm se panih a ma taateꞌ me kokoman hat peöm, ko tarih hah manih pe Sosoenën, suk a ö neꞌ se ihan anoe a ma hat peöm. ");
INSERT INTO tpz_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Eöm se keh nok va nën, o kikis voon se nö maꞌ manih peöm to taneꞌ maꞌ pe Sosoenën, pareꞌ vanö maꞌ e Ieesuꞌ, eꞌ e Kristo, moaan voh neꞌ to vateꞌ ka neöm. ");
INSERT INTO tpz_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Eꞌ se teꞌ non manih pa vöön va kin, to anoeh non o poen ne Sosoenën se vateꞌ vavoon hah a ma moeh tah kurus, vamanih pa ö neꞌ to soe vavoh manih po teꞌ vivihan vanënën soe peꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","E Mosës to soe voh pan, ‘E Sunön Sosoenën peöm, se vanö maꞌ a teꞌ vanënën soe manih peöm, vamanih pa ö neꞌ to vanö vavoh ka maꞌ neoꞌ. Eꞌ a teꞌ poaneöm. Eöm se tënan nem a ma soe kurus neꞌ se soe ka neöm. ");
INSERT INTO tpz_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","A teꞌ to hikta tënan non a soe pa teꞌ vanënën soe pamëh, eꞌ se tavus këh en po vakum teꞌ pe Sosoenën, ko tamiröꞌ en.’ ");
INSERT INTO tpz_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","A ma teꞌ vanënën soe vamoaan vaꞌpeh me e Samuël, me o teꞌ varih to suk maꞌ poë, ee kurus to teꞌ me ne a soe vëh to teꞌ non kuru. ");
INSERT INTO tpz_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","A soe man vëh ne Sosoenën to heꞌ koe voh manih po teꞌ vanënën soe. Eöm a ma teꞌ se kon a ma soe ne Sosoenën to soe vaman voh, a ö neꞌ se heꞌ a ra komön o vatompoan ne Sosoenën to nok me voh a ma sipuura. Eꞌ to soe ke voh e sipuura Abraham pan, ‘Manih pe koaꞌ pën, eöꞌ se tapui a ma napan kurus varih po oeh.’ ");
INSERT INTO tpz_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","E Sosoenën to vateꞌ a teꞌ kikiu peꞌ e Ieesuꞌ, pareꞌ vanö vovoh maꞌ poan manih pea a napan va Israël, pa vaꞌaus a ra pa koe a ma taateꞌ hat.” ");
INSERT INTO tpz_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","E Pitaꞌ pen e Jon to vavaato me ne pa napan, ko teꞌ ësës heꞌ, me o teꞌ susun va pa Iuun Hinhin Apuh, me o Sëdiusi to nö ee maꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ee to heve ne e Pitaꞌ pen Jon, suk ee pon to vavaasis ne a ma napan pan e Ieesuꞌ to sun taneꞌ hah po vapeepe to vainan e non pa nap mët se sun hah ee. ");
INSERT INTO tpz_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ivëh, kee öt raoe pon, pare vahoꞌ ee pee pa nohnoh, suk a muhin to poen en kee anoeh ne o meoh poen. ");
INSERT INTO tpz_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ivëhkëk, a napan peo varih to pënton a soe va pe Ieesuꞌ ko vaman, ee to antoen va ne manih pa 5,000 teꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pa pöstakah po meoh poen a ma teꞌ sunön ësës heꞌ, me a ma teꞌ sunön po Jiuꞌ, me a ma teꞌ nat in o Vavaasis pe Mosës to vatönun manih Jerusalëm. ");
INSERT INTO tpz_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ee to vatönun me e Anas a Teꞌ Susun po Teꞌ Ësës Heꞌ, Kaëfas, me Jon, me Alëksantaꞌ, me a ma meh teꞌ va po vuteꞌ pe Teꞌ Susun po Teꞌ Ësës Heꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ee to vasun e Pitaꞌ pen Jon pa matëëre, ko hi raoe pan, “Eöm pom kon o kikis me a ëhnan eteh nöm to pokaꞌ, paröm nok a tah vëh?” ");
INSERT INTO tpz_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","E Pitaꞌ no a Tuvuh Vasioꞌ to puh non peꞌ, to piun, pareꞌ soe pan, “Eöm a ma teꞌ sunön va Israël, me a ma teꞌ sunön, ");
INSERT INTO tpz_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","eöm pöꞌ to iu hi a nemöm pa vih vëh to tanok pa teꞌ hat mon pa ö neꞌ to vih hah a va. ");
INSERT INTO tpz_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Eöm kurus se nat e nem, me a ma napan va Israël, ee se nat e ne. A teꞌ vëh to vih hah po kikis pa ëhnan e Ieesuꞌ va Nasarët, a teꞌ nöm to ni voh eah pa kuruse. Ivëhkëk, e Sosoenën to vatoꞌ hah poan. ");
INSERT INTO tpz_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","E Ieesuꞌ a teꞌ no a soe vivihan to sosoe suk non poan pan, ‘O toon vëh no a nap ekeok to vi tavus, to tavus en o toon vamomoaan in a iuun.’ ");
INSERT INTO tpz_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","A hikta meh teꞌ to onöt non a kon hah këh a ra a ma hat pea, a ëhnan e Ieesuꞌ varoe kuru a paeh ne Sosoenën to heꞌ voh a ra.” ");
INSERT INTO tpz_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","A ma teꞌ poë varih to tënan a ö ne Pitaꞌ pen Jon to hikta naöp ne a vaato, ko pah toksean rakah ee. Suk ee pon to hikta siku voh. Ivëhkëk, ee to nat e ne pee pon a poa vamomhë voh pe Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ivëhkëk, ee to ep e ne pa teꞌ vëh to vih hah to sun me e non pe Pitaꞌ pen Jon, ka hikta tah nee se soe. ");
INSERT INTO tpz_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ivëh, kee soe ke pee pa tavus këh a iuun ko nö. Ee koman to vavasoe e ne pan, ");
INSERT INTO tpz_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ea se nok ataeah manih pa poa teꞌ varih? Ea to nat e no, a napan kurus varih to teꞌ ne manih Jerusalëm to ep voh e ne pa tah vatoksean nee to nok voh, ka hikta se koaan no. ");
INSERT INTO tpz_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ivëhkëk, o meoh upöm teꞌ tomeꞌ vaman, pare hop maꞌ po vakum pee, ea se soepip in a poa teꞌ varih, kee nat ne vatënan hah a napan pa ëhnan a teꞌ vëh e Ieesuꞌ.” ");
INSERT INTO tpz_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ivëh, kee vaoe hah ee pe Pitaꞌ pen Jon, pare kömköm vakis raoe, pan ee se nat ne vatvus hah ta meh soe me a vavaasis pa ëhnan e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ivëhkëk, e Pitaꞌ pen Jon to piun a soe pee pan, “Eöm koman se kiiki ataeah to teꞌ totoopin non pa matan e Sosoenën, emöm se vatet a neöm, keꞌ, emöm se vatet e Sosoenën. ");
INSERT INTO tpz_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Emöm hikta se vahik vaato këh nem ataeah nemöm to ep me tënan voh.” ");
INSERT INTO tpz_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","O teꞌ varih to pënton vu ne pee pon, to kömköm vakis raoe, pare vanö ee pee. Ee to hikta ep in tah hat nee se vateꞌ suk raoe. A napan to kë rakah ne a ëhnan e Sosoenën pa ö neꞌ to vavih hah a teꞌ hat mon. ");
INSERT INTO tpz_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","A teꞌ vëh to vih hah, a ma kirismas peꞌ to oah ne o 40. ");
INSERT INTO tpz_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","O Vakum Teꞌ Susunön po Jiuꞌ to vahah ee pee, kee nö hah ee manuh po vakum pee, ko soe ke po vakum pataeah no teꞌ sunön ësës heꞌ, me o Vakum Teꞌ Susunön po Jiuꞌ to soe maꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ee kurus to pënton, pare vapöh kokoman pa hin e Sosoenën pan, “Sunön, eën to nok voh o oeh, ka akis, me a tahiꞌ, me a ma moeh tah to teꞌ hop ne manih pee. ");
INSERT INTO tpz_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Moaan voh e Sosoenën to soe koe voh pa Tuvuh Vasioꞌ manih pa rivon e sipunmöm Devit pan, ‘Suk ataeah, ko teꞌ hikta teꞌ ne o Jiuꞌ heve ne? Suk ataeah, ko Jiuꞌ kokoman pinpiun ne? ");
INSERT INTO tpz_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","O teꞌ susunön to hikta teꞌ ne pan ee ro Jiuꞌ manih po oeh to vamatop ne a vapus, ka ma teꞌ susunön poë varih vatönun, marën a vöknah e Sunön, me a vöknah e Kristo peꞌ.’ ");
INSERT INTO tpz_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","O man rakah, e Ponsius Paëlat pen e Hëërot me a ma teꞌ va Israël to vatönun manih Jerusalëm marën a vöknah e Kristo, a teꞌ kikiu vivihan pën nën to vateꞌ voh. ");
INSERT INTO tpz_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ee to vatönun voh, ko nok suk rakah ee po kokoman pën. ");
INSERT INTO tpz_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Sunön, vaꞌaus a möm a ma teꞌ kikiu pën, kemöm se teꞌ eh nem pa vatvus a soe pamöm nat nem teꞌ naöp i nem a ma soepip pee. ");
INSERT INTO tpz_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Vataare o kikis pën manih po teꞌ varih to haraꞌ ne a moeh, kee se vih hah, parën nok a ma vu tah vatoksean manih pa ëhnan e Ieesuꞌ a teꞌ kikiu vivihan pën.” ");
INSERT INTO tpz_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ee to hin vahik ee, ka iuun vëh nee to teꞌ ne takö en. A Tuvuh Vasioꞌ to puh rakah non manih pee, kee taneo ee pa vatvus a soe pe Sosoenën, ko ahikta nanaöp ne. ");
INSERT INTO tpz_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","O teꞌ va po vaman to vapöh kokoman e ne, pare hikta öt vakëkëh ne a ma tah, a ma tah to vaneah e non pee kurus. Kee heꞌheꞌ ne a ma teꞌ varih to kökööt ne ta ma tah. ");
INSERT INTO tpz_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","O kikis vëh no aposol pe Ieesuꞌ to teꞌ me ne, to vasoë rakah e non pee pa soe tavus a ö ne Ieesuꞌ to sun taneꞌ hah en po vapeepe. ");
INSERT INTO tpz_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","A hikta paeh komön o vakum pee to kökööt non ta pah tah. O teꞌ varih to teꞌ me ne o oeh, ka iuun, se vavoen a iuun, keꞌ o oeh, ka moniꞌ nee to kon nën, to hop en po vakum. ");
INSERT INTO tpz_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","O aposol to kiiki ne a moniꞌ pa ma teꞌ varih to kökööt ne ta ma tah. ");
INSERT INTO tpz_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Keꞌ teꞌ non a pah teꞌ va po vuteꞌ nee to pokaꞌ ne Livaë, pa ö muhin soneꞌ nee to pokaꞌ ne Saëprus, a ëhnaneah e Jeosëp. Ee to pokaꞌ ne eah e Banabas, o ëhnan vëh e Banabas to soe va non manih pan, “A teꞌ heꞌheꞌ soe va pa vaeh o vaman.” ");
INSERT INTO tpz_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Eꞌ to vavoen a ö oeh peꞌ manih pa meh teꞌ, ka moniꞌ neꞌ to kon, eꞌ to teꞌ maꞌ pareꞌ heꞌ en po aposol. ");
INSERT INTO tpz_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","A meh teꞌ to teꞌ non, a ëhnaneah e Ananaës, ke köövo peꞌ a ëhnaneah e Sapaëraꞌ. E Ananaës to vavoen a ma pah tah neꞌ to vaneah non. ");
INSERT INTO tpz_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ivëhkëk, ee pon to vaonöt ee pa öt kök hah a meh moniꞌ, ke Ananaës nö ko heꞌ en po aposol pa moniꞌ to keok, pareꞌ soe pan, “Eꞌ vaꞌih a moniꞌ avoes va pa ma tah nöꞌ to vavoen.” ");
INSERT INTO tpz_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ke Pitaꞌ soe ke Ananaës pan, “Ananaës, vahvanih kën vaonöt ke susun po oraꞌ hat, keꞌ matop e non po kokoman pën. Kën piuk in a Tuvuh Vasioꞌ pa moniꞌ nën to kon pa tah nën to vavoen. ");
INSERT INTO tpz_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Eën to vaneah nom a tah pën, parën vavoen eom peꞌ, ka moniꞌ nën to kon eën to vaneah nom. Manih po kokoman pën eën nok vamanih suk ataeah? Eën to hikta piuk in a teꞌ, ahik, eën to piuk eom pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","E Ananaës to pënton a soe vëh, ko vuꞌ en po oeh a mët. Ka ma napan varih to ep ne, me a ma teꞌ varih to pënton maꞌ pah naöp ee. ");
INSERT INTO tpz_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ka ma teꞌ sekaꞌ ho maꞌ, pare kupkup ee pa sionineah, pare teꞌ ee pa pe. ");
INSERT INTO tpz_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","A kukön aoaꞌ to oah ee, ke köövo ho maꞌ to hikta nat non pa tah to tavus vu. ");
INSERT INTO tpz_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ke Pitaꞌ soe ke köövo pan, “Soe ka neoꞌ ah, a moniꞌ kës vëh eꞌ a moniꞌ avoes nöm to vavoen a tah peöm, paröm kon?” Ke köövo piun, pareꞌ soe pan, “A, eꞌ a moniꞌ avoes.” ");
INSERT INTO tpz_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ke Pitaꞌ soe ke köövo pan, “Suk ataeah, köm vahoꞌ a Tuvuh Vasioꞌ pe Sunön pa punöꞌ? A ma teꞌ varih to pe ko maꞌ e voe pën, to sun e ne po matön hopaꞌ, ee me se vateꞌ tavus ee pën.” ");
INSERT INTO tpz_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ka varuꞌ vakomanih e köövo to vuꞌ en pa havin mon e Pitaꞌ a mët. Ka ma teꞌ sekaꞌ ho maꞌ, ko ep ee pe köövo to mët en, pare vateꞌ tavus e köövo, pare pe ee peꞌ havin e voe peꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ka napan varih to vaman voh ee, me a ma meh teꞌ to pënton maꞌ, ee to pah naöp vörep ee. ");
INSERT INTO tpz_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","O aposol to vatvus a ma vëknöm me ma tah vatoksean manih pa napan, ka napan varih to vaman ne to vapöh kokoman, pare vatötönun pa ö in a Iuun Hinhin Apuh, nee to pokaꞌ ne a Parantaꞌ pe Solomon. ");
INSERT INTO tpz_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ka ma napan varih to hikta teꞌ ne po vakum pee, hikta nönö ne maꞌ pa vakum me raoe. Ivëhkëk, a ma napan to ta rakah e ne po aposol. ");
INSERT INTO tpz_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ka nap peo rakah to vaman ee pe Sunön, ko hop ee maꞌ manih po vakum pee. ");
INSERT INTO tpz_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","O aposol to nonok ne a ma tah vatoksean, ka napan teꞌteꞌ ee maꞌ po teꞌ to haraꞌ ne a moeh. Pare vökroh ee pee manih sinten hanan, ke Pitaꞌ se oah non ka apeneah apon raoe, kee toꞌ hah ee. ");
INSERT INTO tpz_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","A ma napan to taneꞌ maꞌ pa ma vöön to teꞌ ne sinten Jerusalëm, ee me to vatönun maꞌ. Ee to meeme maꞌ ro teꞌ no oraꞌ hat to miröꞌ voh, me ro teꞌ to haraꞌ ne a moeh. Ee kurus to vihvih hah ee. ");
INSERT INTO tpz_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ivëh, ka Teꞌ Susun po Teꞌ Ësës Heꞌ, me a ma vakamöꞌ peꞌ o Sëdiusi to puhioꞌ a ma tah vatoksean no aposol to nonok ne. ");
INSERT INTO tpz_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ee to öt o aposol, pare vaho raoe pa nohnoh apuh vaꞌpeh me a nap hat. ");
INSERT INTO tpz_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ivëhkëk, pa popoen no a ankeroꞌ pe Sosoenën to peret ke raoe o hopaꞌ, ko vatvus raoe ko soe ke raoe pan, ");
INSERT INTO tpz_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Eöm se nö manuh pa Iuun Hinhin Apuh, paröm soe tavus ke ra napan o toꞌtoꞌ voon vëh nöm to teꞌ nem.” ");
INSERT INTO tpz_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ko aposol vatet a soe pamëh, pare nö ee manuh koman a Iuun Hinhin Apuh pa ö no a muhin to mamaaka nö non, ko taneo ee pa vavaasis a ma napan. Ka Teꞌ Susun po Teꞌ Ësës Heꞌ, me a ma vakamöꞌ peꞌ vaoe ununun ee po Vakum Teꞌ Susunön po Jiuꞌ, kee vakum ee, pare vanö ee pa soe pa me taneꞌ maꞌ o aposol pa iuun nohnoh. ");
INSERT INTO tpz_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ivëhkëk, o pirisman to nö ko hikta ep in o aposol, manuh koman a iuun nohnoh, ko hah ee, pare soe vanat pan, ");
INSERT INTO tpz_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Emöm to nö na pa iuun nohnoh ko ep in a ma hopaꞌ to papanih, ka ma teꞌ utut ut e ne. Ivëhkëk, emöm to ho pamöm hikta ep in ta teꞌ koman.” ");
INSERT INTO tpz_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ka teꞌ susun po pirisman va pa Iuun Hinhin Apuh, me a ma teꞌ sunön ësës heꞌ pënton a soe vaꞌih, pare toksean ko pah kokoman vörep rakah e ne pataeah se tavus suk maꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ka pah teꞌ ho maꞌ, pareꞌ soe pan, “Pënton öm! A ma teꞌ varih nöm to vahoꞌ pa nohnoh to teꞌ ne pa Iuun Hinhin Apuh to vavaasis ne a ma napan.” ");
INSERT INTO tpz_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ivëh, ko pirisman, me e susun pee nö ee pa me hah o aposol, ko hikta ip maꞌ raoe. Ee to nanaöp e ne pa napan to meꞌ tösvös raoe. ");
INSERT INTO tpz_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","O pirisman to me ho maꞌ o aposol, kee sun e ne matëëro Vakum Teꞌ Susunön po Jiuꞌ, ka Teꞌ Susun po Teꞌ Ësës Heꞌ hi raoe a ma hi. ");
INSERT INTO tpz_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Emöm to kömköm voh a neöm, pan eöm se nat nem vavaasis nem pa ëhnan e Ieesuꞌ. Ivëhkëk, eöm to vavaasis avoeꞌ e nem pa ëhnan e Ieesuꞌ. Ep öm! A nap peo rakah to vaman o vavaasis peöm manih Jerusalëm. Eöm to vateen a möm pa mët pe Ieesuꞌ.” ");
INSERT INTO tpz_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ke Pitaꞌ me o upöm aposol piun, pare soe pan, “Emöm se vatet varoe nem a soe pe Sosoenën, ka manih pa teꞌ akuk, ahik.” ");
INSERT INTO tpz_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Eöm to ip vamët voh e Ieesuꞌ pa ö nöm to ni eah pa kuruse. Ivëhkëk, e Sosoenën pa kën sipuura to vatoꞌ taneꞌ hah poan po vapeepe. ");
INSERT INTO tpz_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","E Sosoenën to vasunön poan, ko vaihoꞌ poan pa papmatö peꞌ, keꞌ vovoh ka rora pa panih a taateꞌ hat, me kon hah a napan va Israël, me a ihan anoe a ma hat pea. ");
INSERT INTO tpz_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Emöm a ma teꞌ va pa soe tavus a ma tah kurus poë varih no a Tuvuh Vasioꞌ to heꞌ non o nat. E Sosoenën to heꞌheꞌ non a Tuvuh Vasioꞌ pa napan varih to nonok ne a ma tah neꞌ to soe.” ");
INSERT INTO tpz_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","O Vakum Teꞌ Susunön po Jiuꞌ to pënton a soe vaꞌih, pare pah heve ee, ko iu ip vamët e ne po aposol. ");
INSERT INTO tpz_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ivëhkëk, a paeh va pee, a to Parësiꞌ a ëhnaneah Gameliel, a teꞌ vavaasis va po Vavaasis pe Mosës no a napan to ta ne poë to sun, pareꞌ taꞌ a ö no aposol se tavus. ");
INSERT INTO tpz_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","E Gameliel to soe ke a napan va po Vakum Teꞌ Susunön po Jiuꞌ pan, “Eöm a napan va Israël, eöm se matop nem pa tah nöm to iu nok nem pa ma teꞌ varih. ");
INSERT INTO tpz_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Eöm to nat e nem, moaan voh ne Teutas to soe pan, ‘Eöꞌ a teꞌ sunön.’ Ivëh, ka 400 teꞌ vatet voh poë. Ivëhkëk, ee to ip vamët ee peꞌ, ka ma napan varih to vaman ne poë rusin vahok ee, ka kiu peꞌ hik en. ");
INSERT INTO tpz_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Po vasuksuk ne Jiutas, a to Galiliꞌ to tavus pa ö no kaman to kokon ëhnan non, eꞌ me no a napan to vatet poë. Ivëhkëk, ee to ip vamët ee peꞌ, ka ma napan varih to vatet ne poë rusin vahok ee. ");
INSERT INTO tpz_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ivëh, ka varuꞌ a manih, eöꞌ to soe ka neöm, eöm se nat nem nok ta pah tah manih pa ma teꞌ varih, eöm se koe raoe, suk ataeah, eꞌ se keh teꞌ non a kiu me o kokoman pa teꞌ, a, eꞌ se hik hah en. ");
INSERT INTO tpz_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ivëhkëk, a tah vëh se keh taneꞌ maꞌ pe Sosoenën, eöm hikta onöt nem a soepip raoe. Eöm tomeꞌ vavapus me e nem pe Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ivëh, ko Vakum Teꞌ Susunön po Jiuꞌ vatet ee pa soe pe Gameliel. Ee to vaoe ho o aposol, pare rëp raoe po uris rëprëp teꞌ. Ee to heꞌ a soepip kikis, pan ee se nat ne vavaasis ne a ma tah varih pa ëhnan e Ieesuꞌ. Ee to vahik, ko vanö ee pee. ");
INSERT INTO tpz_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ivëh, ko aposol tavus këh ee pa iuun vëh no Vakum Teꞌ Susunön po Jiuꞌ to vakum ne. Ee to vaeö rakah, suk e Sosoenën to koman non raoe to onöt e ne pa kon poet pa kiu vih nee to nonok ne pa ëhnan e Ieesuꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Pa ma poen kurus manih koman a Iuun Hinhin Apuh, me pa ma koman iuun po teꞌ, o aposol to vavaasis, me ee to vatvus ne a Soe Vih va pe Ieesuꞌ, e Kristo. ");
INSERT INTO tpz_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Manih pa ma poen varih no a napan to vaman ne to pepeo rakah nö e ne. Ka ma to Jiuꞌ to nat ne o to va Grik heve e ne po Jiuꞌ manih Jerusalëm, ee to soe pan, “Pa ma poen kurus eöm to vavaꞌaus nem o teꞌ varih to kökööt ne pa moniꞌ, ivëhkëk, eöm to hikta vaꞌaus nem a ma köövo amop pemöm.” ");
INSERT INTO tpz_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ivëh, ka havun me a poa aposol vaoe ee po ihoꞌ pee kurus, pare soe pan, “Eꞌ to hikta vih non pa ö na se vakah a vavaasis a soe pe Sosoenën, para matop no o moniꞌ me a taëën. ");
INSERT INTO tpz_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kën kea, ea se vateꞌ ta tönim me a poa teꞌ no a Tuvuh Vasioꞌ me o nat vih to teꞌ non pee, kee matop ne a ma tah poë varih. ");
INSERT INTO tpz_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ivëh, ka se matop varoe no a taateꞌ va pa vavaasis a soe pe Sosoenën, me a hin vaꞌaus a ma napan.” ");
INSERT INTO tpz_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ee kurus varih to teꞌ ne po vakum to vaeö me ne po kokoman pamëh. Pare vateꞌ ee pe Stivin, eꞌ a teꞌ rakah va po vaman no a Tuvuh Vasioꞌ to puh non peꞌ. Ee to vateꞌ me e Filip, ke Prökoras, ke Nikenor, ke Timon, ke Pamenas, me e Nikolas. E Nikolas a teꞌ to hikta teꞌ non a to Jiuꞌ va pa vöön apuh va Antiök, eꞌ to vaman a taateꞌ po Jiuꞌ, ko tavus en a to Jiuꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ee to me raoe manuh po aposol, pan o aposol se hin, pare vahoꞌ a koreere ko vateꞌ raoe pa nok a kiu vaꞌaus. ");
INSERT INTO tpz_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","A soe pe Sosoenën to nö vavah en pa ma ö kurus. Ka napan peo tavus ee o teꞌ va po vaman manih Jerusalëm. O teꞌ ësës heꞌ peo to vatet a soe pe Sosoenën ko vaman. ");
INSERT INTO tpz_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","E Stivin, a teꞌ va po vaman to puh non po ururuan me o kikis ne Sosoenën to heꞌ voh poan pa nok a ma tah vatoksean topnin a ma napan. ");
INSERT INTO tpz_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ivëhkëk, o pöök vakum to Jiuꞌ to vavaato vasukaꞌ me ne pe Stivin. Ee to teꞌ hop ne po iuun hinhin soneꞌ po Jiuꞌ, a ëhnëëro teꞌ varih to teꞌ hop ne po vakum pamëh, o Libertin. A ma teꞌ to teꞌ hop ne nën to taneꞌ maꞌ Saëriniꞌ, me Alëksëndriaꞌ. O vapöök vakum to taneꞌ maꞌ Silisiaꞌ me Esiaꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ivëhkëk, a Tuvuh Vasioꞌ to heꞌ e Stivin o nat vih oah, ke Stivin se keh vaato ka napan hikta onöt ne piun poë. ");
INSERT INTO tpz_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ivëh, ka napan piuk in e Stivin, ee to vateꞌ a ma teꞌ pa piuk e Stivin pan, “Emöm to tënan e Stivin to sosoe vahat non o Vavaasis pe Mosës, me eꞌ to sosoe vavahat non e Sosoenën.” ");
INSERT INTO tpz_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Manih po piuk pamëh nee to nok, ee to kuin ee po heve po teꞌ susunön po Jiuꞌ, me o teꞌ vavaasis to nat i ne o Vavaasis pe Mosës, me a napan. Ivëh, kee nö ee manuh pe Stivin ko me ee peꞌ manuh po Vakum Teꞌ Susunön po Jiuꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Pare me ee maꞌ pa ma teꞌ pa heꞌ a soe piuk. A ma teꞌ poë varih to piuk e Stivin pan, “Tamoaan rakah, a teꞌ vëh to sosoe non a ma soe hat suk a Iuun Hinhin Apuh me o Vavaasis pe Mosës. ");
INSERT INTO tpz_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Emöm to tënan nem eah to soe pan, e Ieesuꞌ va Nasarët se kök a Iuun Hinhin Apuh, me a ö neꞌ se panih o Vavaasis to taneꞌ voh maꞌ pe Mosës.” ");
INSERT INTO tpz_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ka ma napan varih to ihoꞌ ne ko kuteꞌ ne pa matan e Stivin to ep ne a mataneah to maaka va non manih pa matan a ankeroꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ke Susun po Teꞌ Ësës heꞌ hi e Stivin pan, “A soe vëh teꞌ man e non ha?” ");
INSERT INTO tpz_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ke Stivin piun pareꞌ soe pan, “Kën kea me kën taman, pënton a neoꞌ öm pa tah nöꞌ se soe. Moaan voh o maaka pe Sosoenën to tavus voh e sipuura Abraham pa ö neꞌ to teꞌ non pa muhin va Mësopotemiaꞌ, momoaan in a nö peꞌ manuh pa vöön Haran. ");
INSERT INTO tpz_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","E Sosoenën to soe ke Abraham pan, ‘Këh a napan me a muhin pën, parën nö manuh po oeh nöꞌ se vataare oah.’ ");
INSERT INTO tpz_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ke Abraham këh en pa muhin va Kaldiaꞌ, ko nö en manuh Haran. Ke taman e Abraham mët, ke Sosoenën vanö en maꞌ peꞌ manih po oeh vëh nöm to teꞌ nem kuru. ");
INSERT INTO tpz_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","E Sosoenën to hikta heꞌ voh e Abraham to oeh neꞌ se vaneah koman non, ahik oah rakah. Ivëhkëk, e Sosoenën to soe vaman voh a ö seꞌ heꞌ en peꞌ, ko oeh vaneah non peꞌ me a ma koaꞌ peꞌ varih se suk maꞌ poë. E Abraham to hikta vataman avoeꞌ voh non tah pah koaꞌ, ke Sosoenën soe a soe vëh. ");
INSERT INTO tpz_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","E Sosoenën to soe ke voh e Abraham pan, ‘A ma koaꞌ pën se teꞌ ne po oeh po upöm teꞌ, ka napan poë varih se vateꞌ raoe a ma teꞌ kikiu akuk, pare nonok vahat e ne pee po 400 kirismas. ");
INSERT INTO tpz_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ivëhkëk amot, Eöꞌ, e Sosoenën se vateꞌ a napan varih po vahutët. A ma koaꞌ pën se këh ee po oeh pamëh, pare nö ee maꞌ pa vasunön a neoꞌ manih pa ö vëh. ");
INSERT INTO tpz_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ke Sosoenën heꞌ en pe Abraham pa taateꞌ vapeepe a ö kokoaan vamanih po vatom poan peꞌ ke Sosoenën. Ivëh, ke Abraham pe a ö kokoaan pe sunaiꞌeah Aësak murin o pöh nënkikiu. Ke Aësak pe a ö kokoaan pe sunaiꞌeah Jekop. Ke Jekop peepe en pa ma ö kokoaan pa havun me a poa koaꞌ oeteꞌ peꞌ, ee varih to tavus voh a havun me a poa sipuura. ");
INSERT INTO tpz_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","A kën sipuura a ma kea pe Jeosëp to puhioꞌ voh poë, pare vavoen ee peꞌ po meoh upöm napan, keꞌ nö en manuh muhin va Isip pa kiu akuk. Ivëhkëk, e Sosoenën to teꞌ vaꞌpeh me e non peꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","E Sosoenën to vaꞌaus e Jeosëp pa ma punis peꞌ. Ko poen neꞌ to vaato me e Përo, e Sosoenën to heꞌ e Jeosëp o nat vih, ivëh, ke Përo iu vi rakah e non peꞌ. Pareꞌ vasun e Jeosëp a teꞌ to vovoh non pa kaman va Isip, me a iuun pe Përo neꞌ to matop non. ");
INSERT INTO tpz_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","O maë o pöh apuh to tavus manuh pa muhin va Isip, me manih pa muhin va Keenan, ka napan kon a punis apuh ka kën sipuura hikta ö nee se voh kon a taëën. ");
INSERT INTO tpz_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ke Jekop pënton a ö no a taëën to teꞌ non manuh Isip, ko vanö en pa ma koaꞌ oeteꞌ peꞌ. Ka kën sipuura nö ee manuh Isip, eꞌ a nö vamomoaan. ");
INSERT INTO tpz_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ivëhkëk, a vapöök nö pee, e Jeosëp to vataare ea vamanih peꞌ e kea pee. Ke Përo nat en pee a ma kea pe Jeosëp. ");
INSERT INTO tpz_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ke Jeosëp vanö en pa soe pa ö ne tamaneah Jekop, me o pus koaꞌ peꞌ se nö maꞌ manih Isip. Ee kurus to onöt ne o 75 teꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ke Jekop me a ma teꞌ peꞌ nö ee Isip, pare teꞌ ne nën ko mët ee. ");
INSERT INTO tpz_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kee teꞌ hah ee maꞌ pa sioniire, ko pe ee po vapeepe vëh ne Abraham to voen taneꞌ voh pa ma koaꞌ pe Hemoꞌ manuh Sekem. ");
INSERT INTO tpz_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","E Stivin to vavaato avoeꞌ e non, pareꞌ soe pan, “O poen to tavus vatët en pa ö ne Sosoenën to soe vaman vavoh manih pe Abraham, suk a napan va Israël to se peo rakah ee manih Isip. ");
INSERT INTO tpz_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ka meh teꞌ tavus en a teꞌ sunön manih Isip, a teꞌ pamëh to hikta nat non e Jeosëp. ");
INSERT INTO tpz_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","A teꞌ sunön pamëh to vatomore ke voh a napan pea, pareꞌ hat rakah ke voh non a kën sipuura. Eꞌ to rës rakah voh non a ma koaꞌ sosoneꞌ vahuh varuꞌ po Jiuꞌ, pareꞌ vi tavus këh voh raoe a vöön, pan ee se mët. ");
INSERT INTO tpz_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Manih po poen pamëh a mu Jiuꞌ to vahuh en pe Mosës e koaꞌ ep vavih po epep pe Sosoenën. A poa manot to matop ne Mosës pa iuun pee pa kukön sivö. ");
INSERT INTO tpz_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ee to me këh ee peꞌ pa iuun pee, pare këh ke ee maꞌ peꞌ. Ke semon Përo ep in e Mosës, pareꞌ me en peꞌ, ko vaꞌpuh poan vamanih pe koaꞌ peꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","E Mosës to apuh ko nö en pa siku, ko kon rakah en po nat vih pa ma taateꞌ va Isip, pareꞌ teꞌ non a teꞌ vih me a teꞌ susun. ");
INSERT INTO tpz_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","E Mosës to teꞌ non o 40 kirismas, pareꞌ iu nö non pa ep pa kën poaneah, a napan va Israël. ");
INSERT INTO tpz_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","E Mosës to nö, pareꞌ ep in a to Isip to ipip non a teꞌ va Israël, pareꞌ vaꞌaus en peꞌ, ko ip vamët en pa to Isip. ");
INSERT INTO tpz_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","E Mosës to koman non pan, a kën poaneah, a napan va Israël se nat e ne pa ö ne Sosoenën se vaꞌaus raoe, ko me tavus këh raoe a nohnoh va Isip pa koren e Mosës, ivëhkëk, ee to hikta nat ne pa tah pamëh. ");
INSERT INTO tpz_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","O meoh poen ne Mosës to tavus a poa to Israël to vavapus ne, pareꞌ iu ki non raoe, pan ee se koe a vapus. Eꞌ to soe ke raoe pan, ‘Eöm a poa tom kea, eöm vavapus suk nem ataeah?’ ");
INSERT INTO tpz_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ivëhkëk, a teꞌ vëh to taneo po vapus to toon ke e Mosës, pareꞌ soe pan, ‘A teꞌ to vateꞌ oah e susun me a teꞌ to kiiki hat ka no möm? ");
INSERT INTO tpz_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Eën to iu ip vamët e nom peöꞌ vamanih pa ö nën to ip va in a to Isip nopoen, ha?’ ");
INSERT INTO tpz_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","E Mosës to tënan a soe vëh, pareꞌ rusin en manuh pa muhin va Midian. Eꞌ to vaen en pa vöön pamëh, ko vatvus en pa poa koaꞌ oeteꞌ. ");
INSERT INTO tpz_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","O 40 kirismas to oah ee, ka ankeroꞌ pe Sosoenën tavus e Mosës koman o tëkrea to susun taneꞌ non pa vu veovöön manih pa moeh upin, sinten a Tope Saënaëꞌ. Ivëhkëk, o tëkrea pamëh to hikta ësës non a vu veovöön ");
INSERT INTO tpz_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","E Mosës to ep in a tah pamëh, ko pah toksean rakah en, pareꞌ huk vatët en pa ep. Ivëhkëk, eꞌ to tënan e Sosoenën to soe pan, ");
INSERT INTO tpz_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Eöꞌ e Sosoenën pa kën sipuneöm, e Sosoenën pe Abraham, pe Aësak, me Jekop, ee to vavatet voh ne a ma soe peöꞌ.’ E Mosës to naöp ko rikrik e non, pareꞌ hikta iu kuteꞌ hah non. ");
INSERT INTO tpz_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ke Sunön soe ke Mosës pan, ‘Pureꞌ a suꞌ pën, o oeh vëh nën to sun nom, eꞌ o oeh peöꞌ, pareꞌ vivihan. ");
INSERT INTO tpz_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Eöꞌ to ep vahik eoꞌ pa ma taateꞌ hat no napan va Isip to nonok ne manih pa ma napan peöꞌ. Eöꞌ to tënan a ook pee, ko nö eoꞌ maꞌ pa me tavus raoe. Ivëh, kën se nö maꞌ, köꞌ vanö a oah manuh Isip.’ ");
INSERT INTO tpz_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","E Mosës a teꞌ no a napan va Israël to rës voh. Ee to hi voh poë pan, ‘A teꞌ to vateꞌ voh a oah a teꞌ se matop, ko kiiki non a ma hat pemöm?’ E Mosës a teꞌ ne Sosoenën to vateꞌ voh pa kon hah a ra pa vaꞌaus pa ankeroꞌ vëh, to tavus voh poan manih pa ö no a suraꞌ to ësës voh non. ");
INSERT INTO tpz_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","E Mosës to nok voh a ma tah vatoksean manih Isip, pareꞌ me tavus këh a m