﻿USE sofia;
DROP TABLE IF EXISTS sofia.tpu_vpl;
CREATE TABLE tpu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tpu_vpl WRITE;
INSERT INTO tpu_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","សាគ់ ប៉ាន់ដា កាខាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាំងកើត តេះ លូ ប៉្លៃង។ ");
INSERT INTO tpu_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ផះ ណោះ តេះ បើ តាន័ ទី ត្រង័ ទ្រៀយ អុះ អ្វៃ តាដោះ ទី ដឹង ម៉ាម៉ាំង លូ ទៀក ជ្រុ។ ប៉ាង៉ាត័ ប៉ាលឹង ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ៃង រ៉ូ អំប៉ាំង អង់កក់ ទៀក។ ");
INSERT INTO tpu_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ប‌៉្រ័ះ ប៊កកាតយ័ កាប ផា «ហគ់ អន់ ទី តាតារ» តាតារ កា ទី តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ប‌៉្រ័ះ ប៊កកាតយ័ ហៃ តាតារ ណោះ ដាគ់ កេះ។ អ៊ែ កា កះ ឡាច់ តាតារ ឡឹង ម៉ាម៉ាំង។ ");
INSERT INTO tpu_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សិច តាតារ ណោះ ផា «កាដារ់» លូ អន់ សិច ម៉ាម៉ាំង ផា «កាម៉ាំង»។ ផះ ណោះ ទី កាង៉ាច ទី កាំលឺ ដារ់ ទី ម៉ោញ។ ");
INSERT INTO tpu_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ប‌៉្រ័ះ ប៊កកាតយ័ ផា «ហគ់ អន់ ទី ឡាក់ កា អន់តល័ ពឹង អន់តិគ័ ទៀក ភឿ កះ ទៀក ឡាច់ ឡឹង គួប អ៊ែ»។ ");
INSERT INTO tpu_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉ាំងកើត អន់តល័ កេះណោះ អ៊ែ កះ ទៀក ឡាក់ អ្វៃ គែង កាន់តេ័ះ អន់តល័ អន់ ឡាច់ ឡឹង ទៀក ឡាក់ អ្វៃ គែង អំប៉ាំង។ ណោះ កា កើត ទី តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សិច អន់តល័ ណោះ ផា «ប៉្លៃង»។ ផះ ណោះ ទី កាង៉ាច ទី កាំលឺ ដារ់ ទី ពៀរ។ ");
INSERT INTO tpu_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ប‌៉្រ័ះ ប៊កកាតយ័ ផា «ហគ់ អន់ ទៀក អ្វៃ គែង កាន់តេ័ះ ប៉្លៃង ប៉ាតុំ អ្វៃ ម៉ោញ ចារ លូ អន់ ទី គោក ដេល»។ ណោះ កា កើត ទី តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សិច គោក ណោះ ផា «តេះ» ទៀក ឡាក់ អ្វៃ ម៉ោញ ចារ ណោះ អ៊ែ អន់ សិច ផា «ទៀក សាឡីគ សាឡាយ»។ ប‌៉្រ័ះ ប៊កកាតយ័ ហៃ តេះ លូ ទៀក ដាគ់ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ប‌៉្រ័ះ ប៊កកាតយ័ កាប ផា «ហគ់ អន់ ទី កាណាគ័ គ្រឹប នែវ ឡាក់ ទី ការ័ ទី តីល ហ៊ន កើត ពឹង តេះ។ ហគ់ អន់ ទី តើម អ៊្លង គ្រឹប នែវ ឡាក់ ទី ប៉្លៃ ប៉ាកាវ»។ ណោះ កា កើត ទី តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","កាណាគ័ គ្រឹប នែវ ឡាក់ ទី ការ័ ទី តីល កា កើត ហ៊ន ពឹង តេះ តាទឹច។ តើម អ៊្លង គ្រឹប នែវ ឡាក់ ទី ប៉្លៃ ប៉ាកាវ កា កើត ហ៊ន តាទឹច ដេល។ ប‌៉្រ័ះ ប៊កកាតយ័ ហៃ កាណាគ័ ទិណោ័ះ កា ដាគ់ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ផះ ណោះ ទី កាង៉ាច ទី កាំលឺ ដារ់ ទី ប៉ៃង។ ");
INSERT INTO tpu_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ប‌៉្រ័ះ ប៊កកាតយ័ កាប ផា «ហគ់ អន់ ទី ប៉ាខ្វាល់ តាតារ អ្វៃ ពឹង ប៉្លៃង ភឿ កះ ឡាច់ កាដារ់ ឡឹង កាម៉ាំង ភឿ កាំឡត់ លូ ប៉្រគ័ អន់ អន់ហ្នាល់ ថុន ដារ់ ខៃ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ហគ់ អន់ ប៉ាខ្វាល់ តាតារ អ្វៃ ពឹង ប៉្លៃង ភឿ តាគ់ តាតារ អង់កក់ តេះ»។ ណោះ កា កើត ទី តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ណោះ ហង ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាំងកើត ប៉ាខ្វាល់ តាតារ តីសៗ ពៀរ ប៉ាខ្វាល់ តាតារ ម៉ោញ បក់ តីស ហ៊្លត អន់ តាតារ ផះ កាដារ់ ប៉ាខ្វាល់ តាតារ បក់ ថិ ហ៊្លត អន់ តាតារ ផះ កាម៉ាំង។ អ៊ែ កា ប៉ាំងកើត សំឡង់ ទិណោ័ះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ប‌៉្រ័ះ ប៊កកាតយ័ ចៃគ ប៉ាខ្វាល់ តាតារ ទិណោ័ះ ពឹង ប៉្លៃង ភឿ តាគ់ តាតារ អង់កក់ តេះ ");
INSERT INTO tpu_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ភឿ កាំឡត់ កាដារ់ កាំឡត់ កាម៉ាំង ភឿ កះ ឡាច់ តាតារ ឡឹង ម៉ាម៉ាំង។ ប‌៉្រ័ះ ប៊កកាតយ័ ហៃ កាណាគ័ ទិណោ័ះ ដាគ់ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ផះ ណោះ ទី កាង៉ាច ទី កាំលឺ ដារ់ ទី ប៉្វាន់។ ");
INSERT INTO tpu_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ប‌៉្រ័ះ ប៊កកាតយ័ ផា «ហគ់ អន់ ទី កាណាគ័ រ៉ាវ៉ឺញ អៀង អ្វៃ កាណុង ទៀក លូ សៃម ប៉ារ់ ពឹង ប៉្លៃង»។ ");
INSERT INTO tpu_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉ាំងកើត កាណាគ័ តីស កេង ខាក់ កាណុង សាឡីគ សាឡាយ លូ កាណាគ័ អន់ទៀគៗ ឡាក់ រែ រ៉ាវ៉ឺញ ម៉ឺញ កាណុង ទៀក គ្រឹប នែវ។ អ៊ែ កា ប៉ាំងកើត សៃម ប៉ារ់ គ្រឹប នែវ ដេល។ ប‌៉្រ័ះ ប៊កកាតយ័ ហៃ កាណាគ័ ទិណោ័ះ ដាគ់ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ប‌៉្រ័ះ ប៊កកាតយ័ កាប ផា «ហគ់ អន់ កើត រ៉ាល ទៀល ស៊ក ប៉ាញ័ ទៀក សាឡីគ សាឡាយ លូ អន់ ទី សៃម អៀង ពឹង អង់កក់ តេះ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ផះ ណោះ ទី កាង៉ាច ទី កាំលឺ ដារ់ ទី ប៉ាតាម័។ ");
INSERT INTO tpu_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ប‌៉្រ័ះ ប៊កកាតយ័ កាប ផា «ហគ់ អន់ ទី កាណាគ័ គ្រឹប នែវ កើត អៀង ពឹង អង់កក់ តេះ ឃឺ កាណាគ័ ស្រុក កាណាគ័ ព្រី លូ កាណាគ័ វ៉ាវ៉ារ គ្រឹប នែវ»។ ណោះ កា កើត ទី តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉ាំងកើត កាណាគ័ ព្រី គ្រឹប នែវ កាណាគ័ ស្រុក គ្រឹប នែវ លូ កាណាគ័ វ៉ាវ៉ារ ពឹង តេះ គ្រឹប នែវ ដេល។ អ៊ែ ហៃ ប៉ប័ កាណាគ័ ទិណោ័ះ ដាគ់ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ប‌៉្រ័ះ ប៊កកាតយ័ កាប ផា «អាញ់ ចឹង ប៉ាំងកើត ប៉ាណូស អន់ វ៉ឹច លូ អាញ់ ភឿ អន់ អន់ឌែ ទី អំរ៉ាញ អំប៉ាំង កា ពឹង ទៀក សាឡីគ សាឡាយ លូ អំប៉ាំង សៃម ប៉ារ់ ពឹង ប៉្លៃង លូ កាណាគ័ ស្រុក លូ កាណាគ័ វ៉ាវ៉ារ ទិណោ័ះ ឡាក់ អ្វៃ ពឹង អង់កក់ តេះ លូ ទី អំរ៉ាញ អំប៉ាំង អង់កក់ តេះ ទិណោ័ះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉ាំងកើត ប៉ាណូស អន់ វ៉ឹច លូ អ៊ែ។ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាំងកើត អន់ឌែ កាម៉ាក័ អង់កាន់។ ");
INSERT INTO tpu_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ដាគ់ កា អន់ឌែ អ៊ែ ផា «ហគ់ ប៉ាំងកើត គន សោ អន់ អៀង ប៉ាញ័ អង់កក់ តេះ។ កេះណោះ រ៉ាំងហៃ អង់កក់ តេះ អា ពិ អន់ ទី អំរ៉ាញ អំប៉ាំង កា ពឹង ទៀក សាឡីគ សាឡាយ អំប៉ាំង សៃម ប៉ារ់ ពឹង ប៉្លៃង លូ កាណាគ័ ទិណោ័ះ ឡាក់ ចាក ពឹង តេះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ប‌៉្រ័ះ ប៊កកាតយ័ កាប ផា «ហៃ អាញ់ ចឹង អន់ អន់ដីស សា សាណា ទិ អា ឡាក់ ទី តីល ហ៊ន គ្រឹប នែវ លូ តើម អ៊្លង ឡាក់ ទី ប៉្លៃ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","អាញ់ ចឹង អន់ អ្យិត ឡន់ ឡាញ់ចឺន ទិណោ័ះ កា អ្យាំ សៃម លូ កាណាគ័ វ៉ាវ៉ារ ឡាក់ អ្វៃ រ៉ីស ពឹង អង់កក់ តេះ ទិណោ័ះ សា ដេល»។ ណោះ កើត ទី តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ប‌៉្រ័ះ ប៊កកាតយ័ ហៃ កាណាគ័ ញ៉ា ៗ ទិណោ័ះ ឡាក់ អ៊ែ ទី ប៉ាំងកើត អ៊ែ ប៉ប័ ផា ដាគ់ ឡាយ៉ាម័ ខាក់ កេះ។ ផះ ណោះ ទី កាង៉ាច ទី កាំលឺ ដារ់ ទី ត្រោ។ ");
INSERT INTO tpu_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","នីអៀ ហង ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាំងកើត តេះ ប៉្លៃង លូ កាណាគ័ ញ៉ាៗ ទិណោ័ះ អ្វៃ ពឹង តេះ លូ អ្វៃ ពឹង ប៉្លៃង កេះ ទិ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ទឹល ដារ់ ទី តាំប៉ើះ ង៉ារ ឡាក់ អ៊ែ ប៉្រគ័ កា កេះ ទិ កេះ អ៊ែ កា រ៉ាឡូវ ពឹង ដារ់ ទី តាំប៉ើះ។ ");
INSERT INTO tpu_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ ដារ់ ទី តាំប៉ើះ កើត ដារ់ ដាគ់ សាំរ៉ាប់ រ៉ាឡូវ ប៉ានេ អ៊ែ ខង ដារ់ ណោះ អ៊ែ រ៉ាឡូវ ឡឹង ង៉ារការ អ៊ែ ប៉្រគ័ កេះ ទិ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","អា ហង គុល សារ តេះ ប៉្លៃង ផះ ប‌៉្រ័ះ ប៊កកាតយ័ ទី ប៉ាំងកើត ពែ។ ");
INSERT INTO tpu_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ពឹង អង់កក់ តេះ បើ តាន័ ទី កាណាគ័ ញ៉ា ហ៊ន អុះ អ្យិត ម៉ោញ តើម កា បើ ទី ដេល ខង ប‌៉្រ័ះ ប៊កកាតយ័ បើ តាន័ ប៉ាឡិ ទៀក បី ពឹង អង់កក់ តេះ អុះ កា អូ ទី ប៉ាណូស ពឿ ប៉្រគ័ ម៉ីរ ប៉្រគ័ ង៉ារ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ហះកា ទី ទៀក ហុយ ឡាច់ ឡឹង តេះ ប៉្រគ័ អន់ កា តេះ អ្យោគ។ ");
INSERT INTO tpu_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ប‌៉្រ័ះ ប៊កកាតយ័ កា អ្យក់ តេះ ម៉ាន ប៉្រគ័ ប៉ាណូស កេះណោះ អ៊ែ ខ្លោម តាម៉ុត កាស៊ែ តាំងហើម រ៉ីស ទ្រង ត្រោម ម៉ូះ ប៉ាណូស អ៊ែ ម៉ាន ណោះ។ ប៉ាណូស ណោះ កា រ៉ីស តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉្រគ័ សួន សាណា ម៉ោញ ពឹង ព្រី អេឌែន អ្វៃ គែង ដារ់ ឡាច់ កេះណោះ អ្យក់ ប៉ាណូស ឡាក់ អ៊ែ ម៉ាន អន់ អ្វៃ ពឹង សួន សាណា ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ កា តើម អ៊្លង គ្រឹប នែវ ឡាក់ ដាគ់ ឡាយ៉ាម័ ហៃ លូ ប៉្លៃ ប៉ាអាំ សា ហ៊ន ពឹង សួន។ ពឹង អន់តិគ័ សួន ទី តើម អ៊្លង ពៀរ។ ម៉ោញ ប៉្រគ័ អន់ ទី អាញុ រ៉ីស លើយ អូ អ្លុ តោ័ ម៉ោញ ណាវ្គ ប៉្រគ័ អន់ អ្លុ អន់ហ្នាល់ យច ត្រគ់ និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ទី តាំងលេ ម៉ោញ ហូរ័ ពឹង ព្រី អេឌែន ជ្រោ សួន ណោះ កេះណោះ តាំងលេ សាក្លះ ឡាច់ ប៉្វាន់។ ");
INSERT INTO tpu_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","តាំងលេ ទី ម៉ោញ សិច ពិសុន តាំងលេ អា ហូរ័ យ៉្វារ ព្រី ហាវីឡា ឡាក់ ចារ ទី ម៉ាស។ ");
INSERT INTO tpu_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ម៉ាស ឡឹង ចារ ណោះ ដាគ់ ឡាយ៉ាម័ លូ ទី ចារ័ បោផូវ លូ ទី តាយ៉ាល័ ចាយ រ៉ាំង ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","តាំងលេ ទី ពៀរ សិច គីហុន អ៊ែ ហូរ័ យ៉្វារ ព្រី គូស។ ");
INSERT INTO tpu_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","តាំងលេ ទី ប៉ៃង សិច ហ៊ីដេគែល តាំងលេ អា ហូរ័ គែង ដារ់ ឡាច់ ព្រី អាស៊ីរី។ តាំងលេ ទី ប៉្វាន់ សិច អឺប៉្រាត។ ");
INSERT INTO tpu_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ប‌៉្រ័ះ ប៊កកាតយ័ អ្យក់ ប៉ាណូស សិច អាដាំ ណោះ អន់ អ្វៃ ពឹង សួន អេឌែន ភឿ ប៉្រគ័ ង៉ារ លូ រ៉ាំងហៃ សួន ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អាដាំ នីអៀ «ទិ ប៉្លៃ អ៊្លង ពឹង សួន អា អីស ខឹន សា ");
INSERT INTO tpu_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ហះកា ប៉្លៃ អ៊្លង ម៉ោញ តើម ឡាក់ ប៉្រគ័ អន់ អ្លុ អន់ហ្នាល់ យច ត្រគ់ ណោះ អីស ជែ សា។ ផា ដារ់ ចំ អីស សា ប៉្លៃ អ៊្លង ណោះ អីស ចឹង តោ័ តាទឹច ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កាប ផា «ប៉ាណូស កាម៉ាក័ អា អ្វៃ ម៉ោញ ដូវ ម៉ោញ ឌែន នីអៀ អូ ដាគ់ អុះ អាញ់ ចឹង ប៉ាំងកើត ប៉ាណូស ម៉ោញ ដូវ ណាវ្គ អន់ តង័ លូ ទី គួប»។ ");
INSERT INTO tpu_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ អ្យក់ តេះ ម៉ាន កាណាគ័ ចាក ពឹង តេះ លូ សៃម ប៉ារ់ ពឹង ប៉្លៃង ទិណោ័ះ។ កេះណោះ អ៊ែ ជឹន កាណាគ័ ទិណោ័ះ ឡាំ ប៉ាគ់ ចារ អាដាំ ខង អ៊ែ ប៉ិច អ្លុ អន់តគ់ ផា អាដាំ ចឹង អន់ សិច នីចម័។ ទឹល នីណោ័ះ កាណាគ័ ទិណោ័ះ កា ទី សិច ពួយ អាដាំ អន់ កា អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","អាដាំ អន់ សិច កា អ្យាំ សៃម កាណាគ័ ស្រុក កាណាគ័ ព្រី លូ សៃម ប៉ារ់ ទិណោ័ះ ហះកា អូ ប៉ប័ កាណាគ័ ញ៉ា ចឹង ត្រគ់ អ្លុ តង័ អ៊ែ លូ ប៉្រគ័ គួប អ៊ែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","ទឹល នីណោ័ះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ អាដាំ តៃប ពឹល តៃប វ៉ឹច។ អ៊ែ កា អ្យក់ ឡាច់ កាន់តីង ហត់ អាដាំ ម៉ោញ កេះណោះ ប៉ាសឹរ តាំងហាល តៃល ទៅ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ប‌៉្រ័ះ ប៊កកាតយ័ អ្យក់ កាន់តីង ហត់ ណោះ ប៉ាំងកើត ប៉ាណូស អង់កាន់ កេះណោះ អ៊ែ ជឹន អន់ កា អាដាំ។ ");
INSERT INTO tpu_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","អាដាំ កាប ផា៖ «អា ហង កាន់តីង កើត ឡាច់ ឡឹង កាន់តីង អាញ់ ប៉ាំងឡៃ កើត ឡាច់ ឡឹង ប៉ាំងឡៃ អាញ់ តាទឹច ហង អាញ់ ចឹង អន់ សិច អ៊ែ ផា អង់កាន់ ខង អ៊ែ កើត ឡាច់ ឡឹង កាម៉ាក័»។ ");
INSERT INTO tpu_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ញន ខ អា ហង បះ កាម៉ាក័ ឡាច់ ឡឹង មើគ ពឹ ឡាំ អ្វៃ អន់ឌូ លូ កាម៉ាញ់ ទឹប វ៉ឹន កា គួប សោប ទឹល រ៉ប់ ដារ់ អា។ អន់ឌែ ពៀរ ដូវ ណោះ កេះ ឡាក់ កា ឡាកោ ប៉ាំងឡៃ ដឹង ម៉ោញ។ ");
INSERT INTO tpu_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ផះ ណោះ កាម៉ាក័ លូ កាម៉ាញ់ អ៊ែ អ្វៃ សាឡុន អូ អ្លុ តាយួស អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","កេះណោះ ពិះ ឡាក់ កាណាគ័ អ្លុ ប៉ាញ៉ា ប៉្លាច័ ហ៊្លត ឡឹង ពូ កាណុង កាណាគ័ ព្រី ទិណោ័ះ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាំងកើត អ៊ែ ឡាំ កាកាប លូ អង់កាន់ ផា «នីចម័ ប‌៉្រ័ះ រ៉ះ ផា ទិ ប៉្លៃ អ៊្លង កាណុង សួន អា អ៊ែ អូ អន់ អន់ដីស សា តាទឹច ប ?» ");
INSERT INTO tpu_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","អង់កាន់ កា តើល ពិះ ផា «អូ អុះ ប៉្លៃ អ៊្លង កាណុង សួន អា អ៊ែ អន់ ញឹន សា ដោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ហះកា ដឹង តើម អ៊្លង អ្វៃ ពឹង អន់តិគ័ សួន តោ ប‌៉្រ័ះ ប៊កកាតយ័ ផា \"ជែ សា ប៉្លៃ អ៊្លង ណោះ លូ ជែ សាប៉ាគ់ ដៃ ផា អន់ដីស សា លើ សាប៉ាគ់ អន់ដីស ចឹង តោ័\"»។ ");
INSERT INTO tpu_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","កេះណោះ ពិះ រ៉ះ កា អង់កាន់ ផា «អន់ដីស អូ តោ័ តាទឹច អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ប‌៉្រ័ះ រ៉ះ កា អន់ដីស នីណោ័ះ ខង អ៊ែ អ្លុ អន់តគ់ ផា ដារ់ ចំ អន់ដីស សា ប៉្លៃ អ៊្លង ណោះ ម៉ាត់ អន់ដីស ចឹង តាតារ អន់ដីស ចឹង វ៉ឹច លូ អ៊ែ អ្លុ អន់ហ្នាល់ យច ត្រគ់ និះទៅ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","កេះណោះ អង់កាន់ កា ហៃ តើម អ៊្លង ណោះ ដាគ់ ឡាយ៉ាម័ ទឹប ប៉ិច សា តាទឹច លូ ប៉ិច កា ហ្យាំង សាឡាច់ ដេល អ៊ែ កា អ្លេះ សា ប៉្លៃ អ៊្លង ណោះ តាទឹច លូ ជែក អន់ កា ក្លោ ឡាក់ អ្វៃ អន់ឌូ លូ អ៊ែ ក្លោ អ៊ែ កា សា ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","កេះណោះ ម៉ាត់ អន់ឌែ កា តាតារ តាទឹច អន់ឌែ កា អ្លុ អន់តគ់ ផា ឡាកោ អ្វៃ សាឡុន។ ណោះ ហង បះ អន់ឌែ អ្លេះ ហ្លា ហ្រា ទៀកម៉ូះ តោត ប៉ាតឹត ប៉្រគ័ អន់ទួប អំប៉ៃន។ ");
INSERT INTO tpu_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ប៉ាគ់ ទឹល កាង៉ាច ខ្យាល ឡាអត់ ផិរៗ អន់ឌែ កាតាំង រ៉ាយ៉ាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ ចាក ពឹង សួន អន់ឌែ កា ប៉ាណាំ គួប សាតាក់ អោន កាន់ទឹង តើម អ៊្លង កាណុង សួន ជែ អន់ អ៊ែ ប៉ប័។ ");
INSERT INTO tpu_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ប‌៉្រ័ះ ប៊កកាតយ័ កា អើ កាម៉ាក័ ណោះ ផា «អឺ អាដាំ ប៉ាគ់ ចំ អីស អ្វៃ ?» ");
INSERT INTO tpu_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","អ៊ែ តើល ផា «អាញ់ កាតាំង រ៉ាយ៉ាគ់ អីស ចាក កាណុង សួន អាញ់ អ្យូគ ខាក់ អាញ់ សាតាក់ អោន ខង អាញ់ អ្វៃ ឡាកោ តាដោះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ អំប៉ញ់ អ៊ែ ផា «ពឿ រ៉ះ កា អីស អន់ អ្លុ អន់តគ់ ផា អីស អ្វៃ ឡាកោ តាដោះ ណោះ ? នីចម័ អីស សា ប៉្លៃ អ៊្លង អាញ់ អូ អន់ សា ពែ ត័ះ ?» ");
INSERT INTO tpu_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","អាដាំ តើល ផា «អង់កាន់ បក់ អីស អន់ អ្វៃ អន់ឌូ លូ អាញ់ អ៊ែ ហង អន់ ប៉្លៃ អ៊្លង កា អាញ់ អាញ់ កា សា និះទៅ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កាប កា អង់កាន់ ផា «ញ៉ា ត្រគ់ អីស ប៉្រគ័ នីអៀ ?» អង់កាន់ រ៉ះ ផា «ពិះ ប៉ាង៉ល់ ប៉្រើ អាញ់ សា ណោះ ហង បះ អាញ់ សា ប៉្លៃ អ៊្លង ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កាប កា ពិះ ផា «ញន កា អីស ប៉្រគ័ នីអៀ ទិ កាណាគ័ ស្រុក កាណាគ័ ព្រី អីស ហង ចឹង ត្រគ់ ប៉ាស្យាប ក្វា ឡឹង ពូ។ អីស ត្រគ់ ចាក ឡាឡាន លូ វ៉ាច់ សា តេះ ឡុច អាញុ អីស។ ");
INSERT INTO tpu_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","អាញ់ ចឹង ប៉្រគ័ អន់ អីស លូ អង់កាន់ ទឹប គន សោ អីស លូ គន សោ អង់កាន់ ចឹង កើត តាម៉ឺរ លូ គួប សោប ផូង័ អង់កាន់ ចឹង ចគ័ កល់ អីស អីស ចឹង ចោះ កាន់ទឺល ជុង អ៊ែ»។ ");
INSERT INTO tpu_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កាប កា អង់កាន់ ផា «ផះ អីស ឡាកោ គៀម លូ អ្វៃ ហាអុញ អាញ់ ចឹង ប៉្រគ័ អន់ អីស អីគ ប៉ាណាប ប៉ាបប៉ុន កាខាក់។ អីស ចឹង ទី ពុត ប៉ិច ទី អំរ៉ាញ អំប៉ាំង ក្លោ ហះកា ក្លោ ចឹង ប៉្រគ័ តាំងឡា អ្វៃ អំប៉ាំង អីស»។ ");
INSERT INTO tpu_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កាប កា អាដាំ ផា «ញន កា អីស សាំយ៉ាំង ពួយ ប៉ានឹរ កាម៉ាញ់ លូ សា ប៉្លៃ អ៊្លង ឡាក់ អាញ់ អូ អន់ សា បះ អាញ់ ចឹង ប៉ាស្យាប តេះ អា ញន កា អីស ហង។ អីស ត្រគ់ ប៉្រគ័ ង៉ារ ពឹង តេះ អា សិម ឡាកោ ក្លេ័ះ ប៉ាណាប ប៉ាបប៉ុន លើយ រ៉ប់ ដារ់ ឡុច អាញុ អីស។ ");
INSERT INTO tpu_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","តេះ ចឹង ហ៊ន អ្យិត សាលៀ អីស ត្រគ់ ប៉្រគ័ ម៉ីរ តប់ សាណា ម៉ាគ់ អីស ចឹង ទី សា។ ");
INSERT INTO tpu_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","អីស ត្រគ់ ណាំង សា សិម ឡាកោ ក្លេ័ះ ឡាច់ សាអូះ តូះ កាម៉ោគ លើយ ទឹល ដារ់ អីស តោ័ សឹត កេះ តេះ ណាវ្គ ខង អីស កើត ឡឹង តេះ អីស ត្រគ់ កេះ តេះ ទៅ»។ ");
INSERT INTO tpu_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","កេះណោះ អាដាំ អន់ សិច កាម៉ាញ់ អ៊ែ ផា អេវ៉ា ខង អ៊ែ ឡាក់ ម៉ៃគ ប៉ាណូស ទិឌូ។ ");
INSERT INTO tpu_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កា អ្យក់ អង់ការ អ្យាំ ប៉្រគ័ អញ់ជុ ទឹប អាវ ទឹប អន់ កា អាដាំ លូ កាម៉ាញ់ អ៊ែ អន់តុក ពៀត។ ");
INSERT INTO tpu_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កាប ផា «កិញអៀ អា ប៉ាណូស អ្លុ អន់ហ្នាល់ យច អន់ហ្នាល់ ត្រគ់ ឡាក់ កា អាញ់ កេះ ដេល។ ទឹល នីណោ័ះ អាញ់ ចឹង កាន់ទឹង ទ្រង ភឿ ជែ អន់ អន់ឌែ ម៉ុត អ្លេះ សា ប៉្លៃ អ៊្លង ឡាក់ អន់ អាញុ រ៉ីស។ ផា អន់ឌែ សា ចឹង ទី អាញុ រ៉ីស លើយ អូ អ្លុ តោ័ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កា តាំងហ្យិត ឡាច់ អន់ឌែ ឡឹង សួន អេឌែន ភឿ អន់ អន់ឌែ ប៉្រគ័ ម៉ីរ ប៉្រគ័ ង៉ារ សិម ឡាកោ ឡឹង តេះ ឡាក់ អ៊ែ អ្យក់ ម៉ាន ប៉ាំងកើត អន់ឌែ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","តាំងហ្យិត អន់ឌែ កេះ ប‌៉្រ័ះ កា ប៉្រើ មួត ចេរូប៊ីន អ្វៃ ញ៉ាម ហះ អន់ទ្រឹល សួន គែង ដារ់ ឡាច់ ទឹប ទី ដាវ អុញ ឡាក់ កា សាលៀស ញ៉ាម ទ្រង អូ អន់ អន់ឌែ ម៉ុត អ្លេះ សា ប៉្លៃ អ៊្លង ឡាក់ អន់ អាញុ រ៉ីស ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ឡៃង ឡឹង ណោះ អាដាំ តៃប លូ កាម៉ាញ់ អ៊ែ អេវ៉ា កា គៀម អ្វៃ ហាអុញ កើត គន កាម៉ាក័ អន់ឌែ អន់ សិច ផា កាអ៊ីន ។ អេវ៉ា ផា «អាញ់ ទី គន កាម៉ាក័ ម៉ោញ ខង ប‌៉្រ័ះ ប៊កកាតយ័ តង័ អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ឡៃង ឡឹង ណោះ អេវ៉ា ទី គន កាម៉ាក័ ម៉ោញ ណាវ្គ ឡាក់ អុះ កាអ៊ីន អ៊ែ អន់ សិច ផា អេបិល។ ប៉ាគ់ អន់ឌែ តីស កេះ អេបិល អ៊ែ រង ចៀម រង ប៉ារ់ពេ កាប៉ាច់ កាអ៊ីន អ៊ែ ប៉្រគ័ ម៉ីរ។ ");
INSERT INTO tpu_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","ទុញ ខៃ ឡឹង ណោះ កាអ៊ីន អ្យក់ សាណា ឡឹង ម៉ីរ អ៊ែ ឡាំ ទៀន អន់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","អេបិល អ្យក់ គន ចៀម គន ប៉ារ់ពេ ឡាក់ តេ័ះ អន់ទ្រួល ឡឹង ពូ ដាគ់ តីស តង់ អ៊ែ ឡះ អ្យក់ ប៉ាំងឡៃ លូ ប៉ុង ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ ដេល។ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាញ័ ពុត កា អេបិល លូ កាណាគ័ អ៊ែ ពុះ រ៉ាម៉ះ ណោះ ");
INSERT INTO tpu_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ អូ ប៉ាញ័ ពុត កា កាអ៊ីន លូ កាណាគ័ អ៊ែ ទៀន អន់ ណោះ អុះ។ កាអ៊ីន ប៉ិច អឺក ខាក់ ម៉ូះ ម៉ាត់ អ៊ែ ការ់ញិវ។ ");
INSERT INTO tpu_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","ប‌៉្រ័ះ ប៊កកាតយ័ កា អំប៉ញ់ កាអ៊ីន ផា «ខ ញ៉ា ត្រគ់ អីស ប៉ិច អឺក ? ញ៉ា ត្រគ់ ម៉ូះ ម៉ាត់ អីស ការ់ញិវ នីអៀ ? ");
INSERT INTO tpu_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ផា អីស ប៉្រគ័ ដាគ់ ណោះ អីស ចឹង ទី ពុត ហោក រ៉គ់។ ហះកា ផា អីស ប៉្រគ័ អូ ដាគ់ សារ យច អ្វៃ ក្រាប់ ហះ អំប៉ារ អីស ភឿ ប៉ិច ប៉្រើ អីស ប៉្រគ័ ពួយ អ៊ែ ហះកា អីស ជែ ប៉្រគ័ ពួយ អ៊ែ ដៃ»។ ");
INSERT INTO tpu_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","កេះណោះ កាអ៊ីន ជៀក អេបិល ឡាំ ប៉ាគ់ ម៉ីរ។ ប៉ាគ់ ទឹល ម៉ីរ អ៊ែ កា តាឡូះ កាមៃ ប៉ាន់តោ័ អុះ អ៊ែ ណោះ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ប‌៉្រ័ះ ប៊កកាតយ័ អំប៉ញ់ កាអ៊ីន ផា «ប៉ាគ់ ចំ អេបិល អុះ អីស អ្វៃ ?» កាអ៊ីន តើល ផា «អាញ់ អូ អ្លុ អុះ អូ ត្រគ់ អាញ់ អ្វៃ រ៉ាំងហៃ អ៊ែ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កាប កា កាអ៊ីន ផា «ញ៉ា ត្រគ់ អីស ប៉្រគ័ នីអៀ ? អាញ់ កាតាំង ផាម អុះ អីស ពឹង តេះ ឡាក់ កា ពូ អង់ហ្យាំង កាតាំង ទឹល ប៉ាគ់ អាញ់ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","កិញអៀ អា អីស ត្រគ់ ប៉ាស្យាប ហង។ តេះ អា ស្រាម ផាម អុះ អីស អា ផាម ឡាក់ អីស ប៉ាំងហូរ័ លូ តី អីស ទៅ។ ");
INSERT INTO tpu_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ទឹល នីណោ័ះ ប៉ាគ់ អីស ប៉្រគ័ ម៉ីរ តេះ ចឹង អូ ដាគ់ សាណា អូ ទី ប៉្លៃ ប៉ាកាវ អុះ អីស ចឹង អ្វៃ ឡង់លែ ដឹង អីស ពឹង អង់កក់ តេះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","កាអ៊ីន កា តើល ប‌៉្រ័ះ ប៊កកាតយ័ ផា «អីស ចៃគ ថូត អាញ់ ក្លាំង យ៉ឹប អាញ់ អូ ដាម័ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ដារ់ អា អីស តាំងហ្យិត ឡាច់ អាញ់ អូ អន់ ប៉្រគ័ ម៉ីរ កេះ អាញ់ កា ត្រគ់ ឡាច់ ចាំងហាយ្គ ឡឹង ម៉ាត់ អីស ដេល ចឹង អ្វៃ ឡង់លែ ដឹង អាញ់ ពឹង អង់កក់ តេះ។ ពឿ ប៉ប័ អាញ់ ពូ ចឹង ប៉ាន់តោ័ អាញ់ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា កាអ៊ីន ផា «អូ អុះ ! ផា ទី ប៉ាណូស ពឿ ប៉ាន់តោ័ អីស អាញ់ ចឹង ប៉ាន់តោ័ តូ ពូ ណោះ អន់ ទី តាំប៉ើះ ដូវ»។ កេះណោះ អ៊ែ ឡាប ចាណាំ ពឹង កាអ៊ីន ម៉ាគ់ ពូ អន់ហ្នាល់ ផា ពូ ប៉ាត័ះ ដាគ់ ពូ អូ ប៉ាន់តោ័ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","កេះណោះ កាអ៊ីន កា ចាក ឡាច់ ឡឹង ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាំ អ្វៃ ប៉ាគ់ ព្រី ណូត គែង ដារ់ ឡាច់ សួន អេឌែន។ ");
INSERT INTO tpu_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","ឡៃង ឡឹង ណោះ កាអ៊ីន តៃប លូ កាម៉ាញ់ អ៊ែ កាម៉ាញ់ អ៊ែ កា គៀម អ្វៃ ហាអុញ កើត គន កាម៉ាក័ អន់ សិច ហេណុក។ កេះណោះ កាអ៊ីន ប៉្រគ័ ស្រុក ម៉ោញ អន់ សិច ផា ស្រុក ហេណុក ពួយ សិច គន អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ឡៃង ឡឹង ណោះ ហេណុក កា ទី គន សិច អ៊ីរ៉ាត អ៊ីរ៉ាត គន អ៊ែ មេហ៊ូយ៉ាអ៊ែល មេហ៊ូយ៉ាអ៊ែល គន អ៊ែ មេទូសាអ៊ែល មេទូសាអ៊ែល គន អ៊ែ ឡាមេក។ ");
INSERT INTO tpu_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ឡាមេក កា ទី កាម៉ាញ់ ពៀរ ម៉ោញ ដូវ សិច អាដះ ម៉ោញ ណាវ្គ សិច ស៊ីឡះ។ ");
INSERT INTO tpu_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","កេះណោះ អាដះ ប៉ាំងកើត គន កាម៉ាក័ ម៉ោញ សិច យ៉ាបាល ឡាក់ វគ័ យ៉ាគ់ មួត បក់ ឌុ ប៉្រគ័ រ៉ាណើះ អ្វៃ លូ រង កាណាគ័ ឡាក់ កា រ៉ក់ ចៀម ប៉ារ់ពេ។ ");
INSERT INTO tpu_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","យ៉ាបាល ទី អុះ ម៉ោញ ណាវ្គ សិច យូបាល ឡាក់ វគ័ យ៉ាគ់ មួត បក់ អន់ទែង ព្រួក ខ្លោម ច្យាប័។ ");
INSERT INTO tpu_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","កាប៉ាច់ ស៊ីឡះ អ៊ែ ប៉ាំងកើត គន ម៉ោញ សិច ទូបាលកាអ៊ីន អ៊ែ រ៉ាគឹយ សាប៉ាន័ រ៉ាគឹយ ប៉ាសយ់។ ឡៃង ឡឹង ណោះ ទូបាលកាអ៊ីន ទី អុះ អង់កាន់ ម៉ោញ សិច ណាម៉ះ។ ");
INSERT INTO tpu_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ឡាមេក រ៉ះ លូ កាម៉ាញ់ អ៊ែ ទិ ពៀរ ផា៖ «អឺ អាដះ អឺ ស៊ីឡះ ហគ់ អន់ដីស សាំយ៉ាំង អាញ់ ចឹង រ៉ះ កា អន់ដីស។ អឺ កាម៉ាញ់ ទិ ពៀរ អន់ដីស សាំយ៉ាំង កាខាក់ ហោគ។ អាញ់ ប៉ាន់តោ័ ប៉ាណូស ម៉ោញ ដូវ ខង អ៊ែ តាគ់ ឡាកា អាញ់។ អាញ់ កា ប៉ាន់តោ័ សាស្វា ម៉ោញ ដូវ ខង អ៊ែ តាគ់ ប៉ារ់ម៉ូ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ផា ពូ ប៉ាន់តោ័ កាអ៊ីន ត្រគ់ ប៉ាន់តោ័ តូ ពូ តាំប៉ើះ ដូវ ភឿ ស៊ង កាន់តីង ហះកា ផា ពូ ប៉ាន់តោ័ អាញ់ ត្រគ់ ប៉ាន់តោ័ តូ ពូ ៧៧ ដូវ ណាវ្គ ភឿ ស៊ង កាន់តីង»។ ");
INSERT INTO tpu_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","កាប៉ាច់ អាដាំ លូ អេវ៉ា កា ទី គន កាម៉ាក័ ម៉ោញ ណាវ្គ អន់ សិច ផា សេត  ខង អេវ៉ា ផា «ប‌៉្រ័ះ ប៊កកាតយ័ អន់ គន កា អាញ់ ម៉ោញ ណាវ្គ ភឿ តូ ផូង័ ប៉ាតាង អេបិល ឡាក់ កាអ៊ីន ប៉ាន់តោ័ ពែ»។ ");
INSERT INTO tpu_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ឡៃង ឡឹង ណោះ សេត កា ទី គន កាម៉ាក័ ដេល អន់ សិច ផា អេណុះ។ គឹត ឡឹង រ៉ាំងហាវ អេណុះ ហង ពូ ប៉ាណាំ គួប សាំប‌៉័ះ លូ អើ សិច ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","អា ហង សារ ផូង័ វ៉ាច់ វគ័ អាដាំ។ ផះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាំងកើត ប៉ាណូស ពែ អ៊ែ ប៉ាំងកើត ប៉ាណូស អន់ វ៉ឹច លូ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ប‌៉្រ័ះ ប៉ាំងកើត កាម៉ាក័ ប៉ាំងកើត អង់កាន់ លូ អន់ សារ ដាគ់ កា អន់ឌែ។ ដារ់ ប‌៉្រ័ះ ប៉ាំងកើត អន់ឌែ ណោះ អ៊ែ អន់ សិច ផា «ប៉ាណូស»។ ");
INSERT INTO tpu_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ប៉ាគ់ វគ័ អាដាំ អាញុ ១៣០ សាណាំ អ៊ែ ទី គន កាម៉ាក័ ម៉ោញ ឡាក់ វ៉ឹច លូ អ៊ែ ណោះ អ៊ែ កា អន់ សិច ផា សេត។ ");
INSERT INTO tpu_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","ឡៃង ឡឹង គន អ៊ែ សិច សេត កើត ណោះ អ៊ែ អ្វៃ រ៉ីស ៨០០ សាណាំ ណាវ្គ អ៊ែ កា ទី គន កាម៉ាក័ គន អង់កាន់ អន់ទៀគ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","អ៊ែ តោ័ គឹត អាញុ ៩៣០ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","ប៉ាគ់ វគ័ សេត អាញុ ១០៥ សាណាំ អ៊ែ ទី គន សិច អេណុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ឡៃង ឡឹង គន អ៊ែ សិច អេណុះ កើត ណោះ អ៊ែ អ្វៃ រ៉ីស ៨០៧ សាណាំ ណាវ្គ អ៊ែ កា ទី គន កាម៉ាក័ គន អង់កាន់ អន់ទៀគ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","អ៊ែ តោ័ គឹត អាញុ ៩១២ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ប៉ាគ់ វគ័ អេណុះ អាញុ ៩០ សាណាំ អ៊ែ ទី គន សិច កៃណាន។ ");
INSERT INTO tpu_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ឡៃង ឡឹង គន អ៊ែ សិច កៃណាន កើត ណោះ អ៊ែ អ្វៃ រ៉ីស ៨១៥ សាណាំ ណាវ្គ អ៊ែ កា ទី គន កាម៉ាក័ គន អង់កាន់ អន់ទៀគ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","អ៊ែ តោ័ គឹត អាញុ ៩០៥ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","ប៉ាគ់ វគ័ កៃណាន អាញុ ៧០ សាណាំ អ៊ែ ទី គន សិច ម៉ាលេលៀល។ ");
INSERT INTO tpu_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ឡៃង ឡឹង គន អ៊ែ សិច ម៉ាលេលៀល កើត ណោះ អ៊ែ អ្វៃ រ៉ីស ៨៤០ សាណាំ ណាវ្គ អ៊ែ កា ទី គន កាម៉ាក័ គន អង់កាន់ អន់ទៀគ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","អ៊ែ តោ័ គឹត អាញុ ៩១០ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","ប៉ាគ់ វគ័ ម៉ាលេលៀល អាញុ ៦៥ សាណាំ អ៊ែ ទី គន សិច យ៉ារែត។ ");
INSERT INTO tpu_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ឡៃង ឡឹង គន អ៊ែ សិច យ៉ារែត កើត ណោះ អ៊ែ អ្វៃ រ៉ីស ៨៣០ សាណាំ ណាវ្គ អ៊ែ កា ទី គន កាម៉ាក័ គន អង់កាន់ អន់ទៀគ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","អ៊ែ តោ័ គឹត អាញុ ៨៩៥ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ប៉ាគ់ វគ័ យ៉ារែត អាញុ ១៦២ សាណាំ អ៊ែ ទី គន សិច ហេណុក។ ");
INSERT INTO tpu_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ឡៃង ឡឹង គន អ៊ែ សិច ហេណុក កើត ណោះ អ៊ែ អ្វៃ រ៉ីស ៨០០ សាណាំ ណាវ្គ អ៊ែ កា ទី គន កាម៉ាក័ គន អង់កាន់ អន់ទៀគ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","អ៊ែ តោ័ គឹត អាញុ ៩៦២ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ប៉ាគ់ វគ័ ហេណុក អាញុ ៦៥ សាណាំ អ៊ែ ទី គន សិច មេធូសាឡា។ ");
INSERT INTO tpu_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ឡៃង ឡឹង គន អ៊ែ សិច មេធូសាឡា កើត ណោះ អ៊ែ អ្វៃ រ៉ីស ៣០០ សាណាំ ណាវ្គ អ៊ែ កា ទី គន កាម៉ាក័ គន អង់កាន់ អន់ទៀគ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","ឡៃង ឡឹង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ អ្យក់ វគ័ ហេណុក ទឹប រ៉ីស អន់ អ្វៃ អន់ឌូ លូ អ៊ែ ខង វគ័ ហេណុក ប៉ិច ចៃ លូ រ៉ាប់ សឿ ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ ហង បះ ពូ អូ ប៉ប័ អ៊ែ ណាវ្គ កេះ។ អាញុ វគ័ ហេណុក ទិណោ័ះ ទី ៣៦៥ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","ប៉ាគ់ វគ័ មេធូសាឡា អាញុ ១៨៧ សាណាំ អ៊ែ ទី គន សិច ឡាមេក។ ");
INSERT INTO tpu_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ឡៃង ឡឹង គន អ៊ែ សិច ឡាមេក កើត ណោះ អ៊ែ អ្វៃ រ៉ីស ៧៨២ សាណាំ ណាវ្គ អ៊ែ កា ទី គន កាម៉ាក័ គន អង់កាន់ អន់ទៀគ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","អ៊ែ តោ័ គឹត អាញុ ៩៦៩ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ប៉ាគ់ វគ័ ឡាមេក អាញុ ១៨២ សាណាំ អ៊ែ ទី គន កាម៉ាក័ ម៉ោញ ");
INSERT INTO tpu_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","អ៊ែ អន់ សិច ផា ណូអេ  ខង អ៊ែ កាប ផា «សើគ ពែ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាស្យាប តេះ ប៉្រគ័ អន់ ពិន ត្រគ់ ប៉្រគ័ ង៉ារ ក្លេ័ះ ក្លាំង ឡាំបាក ខាក់ ហះកា គន អា ចឹង ប៉្រគ័ អន់ ពិន រ៉ាឡូវ ឡគ»។ ");
INSERT INTO tpu_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","ឡៃង ឡឹង គន អ៊ែ សិច ណូអេ កើត ណោះ អ៊ែ អ្វៃ រ៉ីស ៥៩៥ សាណាំ ណាវ្គ អ៊ែ កា ទី គន កាម៉ាក័ គន អង់កាន់ អន់ទៀគ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","អ៊ែ តោ័ គឹត អាញុ ៧៧៧ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","កាប៉ាច់ វគ័ ណូអេ ប៉ាគ់ អ៊ែ អាញុ ៥០០ សាណាំ អ៊ែ ទី គន កាម៉ាក័ ប៉ៃង ដូវ សិច សិម ហាំ លូ យ៉ាភែត។ ");
INSERT INTO tpu_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ផះ ប៉ាណូស កើត រ៉ាល អៀង ប៉ាញ័ អង់កក់ តេះ គន អង់កាន់ កា កើត អៀង ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","មួត ប‌៉្រ័ះ ប៊កកាតយ័ ទី ប៉ាំងកើត ប៉ប័ គន អង់កាន់ ណោះ ដាគ់ ឡាយ៉ាម័ អន់ឌែ កា ទី មួត អង់កាន់ ណោះ ប៉្រគ័ កាម៉ាញ់ តាម ពុត អន់ឌែ ប៉ិច។ ");
INSERT INTO tpu_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ទឹល នីណោ័ះ ប‌៉្រ័ះ ប៊កកាតយ័ ផា «ប៉ាង៉ាត័ អាញ់ អូ អ្វៃ អន់ឌូ លូ ប៉ាណូស លើយ អុះ ខង អន់ឌែ ក្រាន័ កា ឡាកោ ប៉ាំងឡៃ ដោច អាញ់ ចឹង អន់ អន់ឌែ អ្វៃ រ៉ីស គឹត ១២០ សាណាំ ឡគ»។ ");
INSERT INTO tpu_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ផះ រ៉ាំងវ៉ាង ណោះ ទី ប៉ាណូស រ៉ាតីសៗ ខាក់ ពឹង អង់កក់ តេះ ខង មួត ប‌៉្រ័ះ ទី ប៉ាំងកើត តៃប អន់ឌូ លូ មួត អង់កាន់ ណោះ។ អន់តីគ ឡឹង ណោះ ណាវ្គ កា អ្វៃ ទី ប៉ាណូស រ៉ាតីស និះទៅ ដេល។ អន់ឌែ ណោះ ហង ឡាក់ ប៉ាណូស ទី សាងុំ កេង លូ លៅ លែង សិច ផះ សើគ ពែៗ។ ");
INSERT INTO tpu_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ប័ ផា ប៉ាណូស អ្វៃ ពឹង អង់កក់ តេះ អន់ឌែ ប៉្រគ័ អូ ដាគ់ ហ៊ែង អៀង ៗ។ កាណុង ពុត ពៀក អន់ឌែ ស៊ុត ដឹង កា សារ អ៊ក ទិណោ័ះ លើយៗ រ៉ប់ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ណោះ ហង បះ ប‌៉្រ័ះ ប៊កកាតយ័ ថុច កា អ៊ែ ប៉ាំងកើត ប៉ាណូស ពឹង អង់កក់ តេះ ទឹប អុក ពុត។ ");
INSERT INTO tpu_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ផា «អាញ់ ចឹង ថាំឡាយ អ្លាត ប៉ាណូស ឡាក់ អាញ់ ទី ប៉ាំងកើត ឡឹង អង់កក់ តេះ អា អន់ ទិ ប្លី ឡូត ទឹប ប៉ាណូស ទឹប កាណាគ័ ជុង ប៉្វាន់ ទឹប កាណាគ័ វ៉ាវ៉ារ ទឹប សៃម ប៉ារ់ អំប៉ាំង តេះ។ អាញ់ ថុច ខាក់ កា អាញ់ ប៉ាំងកើត អន់ឌែ»។ ");
INSERT INTO tpu_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ ដាគ់ ពុត កា វគ័ ណូអេ។ ");
INSERT INTO tpu_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","អា ហង សារ ផូង័ វ៉ាច់ វគ័ ណូអេ។ អ៊ែ ឡាក់ ប៉ាណូស ដាគ់ ត្រង់ ទី ដឹង អ៊ែ ហង អូ ប៉្រគ័ សារ អ៊ក ពឹង រ៉ាំងវ៉ាង រ៉ាំងហាវ អ៊ែ។ វគ័ ណូអេ ប៉ិច ចៃ លូ រ៉ាប់ សឿ ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","វគ័ ណូអេ ទី គន កាម៉ាក័ ប៉ៃង ដូវ សិច សិម ហាំ លូ យ៉ាភែត។ ");
INSERT INTO tpu_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ផះ ណោះ ប៉ាណូស អ្វៃ ពឹង អង់កក់ តេះ អា ប៉្រគ័ សារ បឺគ សារ អ៊ក គ្រឹប នែវ លូ ទី ពុត ខូយ ប៉ាអ្យប់ កាខាក់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ប‌៉្រ័ះ ប៊កកាតយ័ ហៃ ប៉ប័ ផា អង់កក់ តេះ អា បឺគ អ៊ក កេះ ខង ប៉ាណូស ប៉្រគ័ សារ អ៊ក អៀង យ៉ឹប។ ");
INSERT INTO tpu_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ណោះ ហង បះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ណូអេ ផា «អាញ់ ចឹង ថាំឡាយ អ្លាត កាណាគ័ លូ ប៉ាណូស ទឹប អង់កក់ តេះ អន់ ទិ ប្លី ឡូត ខង ប៉ាណូស ប៉្រគ័ សារ ខូយ ប៉ាអ្យប់ ប៉ាញ័ អង់កក់ តេះ នីអៀ»។ ");
INSERT INTO tpu_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ណូអេ ផា «ហគ់ អីស ណាំង អ៊្លង ដាគ់ៗ ប៉្រគ័ ទូក តីស សាំរ៉ាប់ ខាប់ខួ អីស ពិ។ កាណុង ទូក ណោះ ត្រគ់ ប៉ិង អន់ ទី កាណុង អៀង លូ អ្យក់ ចារ័ អ៊្លង ឡាប ប៉ាសឹរ ទឹប គែង កាណុង ទឹប គែង ឡីង។ ");
INSERT INTO tpu_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","អីស ត្រគ់ ប៉្រគ័ ទូក ណោះ អំពុ អ្លឹង ៣០០ ហាត់ អំពុ តីស ៥០ ហាត់ ចាំងហីគ ៣០ ហាត់។ ");
INSERT INTO tpu_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ហះកា អីស ត្រគ់ ប៉្រគ័ អន់តល័ ទូក អន់ ចាំងហីគ ឡឹង ទូក ម៉ោញ ហាត់ លូ ប៉្រគ័ អំប៉ារ ហះ សានែង។ កាណុង ទូក ណោះ ប៉្រគ័ អន់ ទី ប៉ៃង តាល់ ទី តាល់ អន់តេ័ះ លូ តាល់ ទី ម៉ោញ តាល់ ទី ពៀរ។ ");
INSERT INTO tpu_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","អីស ត្រគ់ ប៉្រគ័ ទូក ខង អាញ់ ចឹង ប៉្រគ័ អន់ ទៀក រ៉ាឡាប ពឹង អង់កក់ តេះ អា ភឿ ថាំឡាយ កាណាគ័ លូ ប៉ាណូស ឡាក់ អ្វៃ រ៉ីស អន់តេ័ះ ប៉្លៃង ទឹប កាណាគ័ ញ៉ាៗ ពឹង អង់កក់ តេះ អន់ តោ័ ទិ។ ");
INSERT INTO tpu_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ហះកា អាញ់ ចឹង សាញ៉ា រែវ ពុត លូ អីស។ អីស កា ចឹង ម៉ុត អ្វៃ កាណុង ទូក តីស ណោះ ទឹប គន ទឹប កាម៉ាញ់ ទឹប ម៉ាយ កាំហ្មាន់ កា ម៉ុត អន់ឌូ លូ អីស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","អីស ត្រគ់ អន់ កាណាគ័ រ៉ីស គ្រឹប នែវ ម៉ោញ ឃូ ៗ ទោល ម៉ោញ យ៉ង់ ម៉ោញ ម៉ុត អ្វៃ កាណុង ទូក តីស អន់ឌូ លូ អីស ម៉ាគ់ អន់ឌែ អ្វៃ រ៉ីស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ណោះ កាណាគ័ ព្រី កាណាគ័ ស្រុក កាណាគ័ ប៉ារ់ លូ កាណាគ័ វ៉ាវ៉ារ គ្រឹប នែវ អ្វៃ ពឹង អង់កក់ តេះ ម៉ោញ ឃូ ៗ ចឹង ប៉ាណាំ គួប ពឹះ ណាំង អីស ភឿ អ្វៃ រ៉ីស។ ");
INSERT INTO tpu_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","អីស ត្រគ់ អ្យក់ សាប្យាំង រ៉ាំងតយ័ គម សាំរ៉ាប់ អន់ដីស សង់ សា លូ សាណា អៀង នែវ សាំរ៉ាប់ កា កាណាគ័ អ្វៃ កាណុង ទូក ទិណោ័ះ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","វគ័ ណូអេ កា ប៉្រគ័ ពួយ គ្រឹប សារ ប‌៉្រ័ះ ប៊កកាតយ័ អន់តគ់ រ៉ះ កា អ៊ែ តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ណូអេ ផា «ហគ់ អីស លូ គន កាម៉ាញ់ លូ ម៉ាយ កាំហ្មាន់ អីស អន់ដីស ម៉ុត អ្វៃ កាណុង ទូក ពិ ខង អាញ់ ប៉ប័ ទិ ប៉ាណូស ពឹង រ៉ាំងហាវ អា ទី ដឹង អីស ហង ដាគ់ ត្រង់។ ");
INSERT INTO tpu_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","ហះកា អីស ត្រគ់ អ្យក់ កាណាគ័ ជុង ប៉្វាន់ ឡាក់ ត្រគ់ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ ទោល ម៉ោញ យ៉ង់ ម៉ោញ អន់ ទី តាំប៉ើះ ឃូ។ កាណាគ័ ជុង ប៉្វាន់ ឡាក់ អូ ត្រគ់ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ អ្យក់ ដឹង ម៉ោញ ឃូ យ៉ង់ ម៉ោញ ទោល ម៉ោញ បគ័ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","កេះណោះ អីស អ្យក់ សៃម ប៉ារ់ ពឹង ប៉្លៃង តាម៉ុង ម៉ោញ យ៉ង់ ម៉ោញ អន់ ទី តាំប៉ើះ ឃូ និះទៅ ដេល ភឿ អន់ កាណាគ័ ទិណោ័ះ តេ័ះ រ៉ាល អ្វៃ ពឹង អង់កក់ តេះ អា ដេល ");
INSERT INTO tpu_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ខង អ្វៃ ដឹង តាំប៉ើះ ដារ់ ណាវ្គ អាញ់ ចឹង អន់ ប៉្លៃង បី ពឹង តេះ ៤០ ម៉ាំង ៤០ ដារ់ ភឿ ចឹង ថាំឡាយ អ្លាត ទិ កាណាគ័ ឡាក់ អាញ់ ប៉ាំងកើត ពឹង អង់កក់ តេះ អា»។ ");
INSERT INTO tpu_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","កេះណោះ វគ័ ណូអេ កា ប៉្រគ័ ពួយ គ្រឹប សារ ប‌៉្រ័ះ ប៊កកាតយ័ អន់តគ់ រ៉ះ កា អ៊ែ តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ផះ រ៉ាំងវ៉ាង ទៀក តីស រ៉ាឡាប អង់កក់ តេះ ណោះ វគ័ ណូអេ អាញុ ៦០០ សាណាំ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ផះ ណោះ វគ័ ណូអេ លូ គន កាម៉ាញ់ លូ ម៉ាយ កាំហ្មាន់ អ៊ែ អន់ឌែ ម៉ុត អ្វៃ កាណុង ទូក ភឿ អន់ រ៉ាវ៉ាច់ ឡឹង ទៀក រ៉ាឡាប។ ");
INSERT INTO tpu_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","កា ទី កាណាគ័ ជុង ប៉្វាន់ ឡាក់ ត្រគ់ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ លូ កាណាគ័ ជុង ប៉្វាន់ ឡាក់ អូ ត្រគ់ ពុះ រ៉ាម៉ះ ទឹប សៃម លូ កាណាគ័ វ៉ាវ៉ារ ពឹង តេះ គ្រឹប នែវ ");
INSERT INTO tpu_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","អន់ឌែ ម៉ុត កាណុង ទូក អន់ឌូ លូ វគ័ ណូអេ ម៉ោញ ឃូ ៗ ទឹប ទោល យ៉ង់ តាម៉ុង ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ប៉ាគ់ ទឹល តាំប៉ើះ ដារ់ កេះ ទៀក តីស កា រ៉ាឡាប អង់កក់ តេះ តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","ផះ ខៃ ២ ដារ់ ទី ១៧ សាណាំ វគ័ ណូអេ ទី អាញុ ៦០០ សាណាំ ដារ់ ណោះ ហង ទិ ត្រោម ទៀក ពឹង តេះ កា ប៉្លោហ ហាវ ត្រោម ទៀក ឡឹង ប៉្លៃង កា ប៉ាឡូះ ជឹរ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","កេះណោះ ប៉្លៃង បី ៤០ ម៉ាំង ៤០ ដារ់ តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ដារ់ ប៉្លៃង បី ណោះ ហង វគ័ ណូអេ លូ កាម៉ាញ់ ទឹប គន អ៊ែ សិម ហាំ លូ យ៉ាភែត ទឹប ម៉ាយ ទិ ប៉ៃង អន់ឌែ ម៉ុត អ្វៃ កាណុង ទូក តីស។ ");
INSERT INTO tpu_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","កា ទី កាណាគ័ ស្រុក កាណាគ័ ព្រី កាណាគ័ វ៉ាវ៉ារ ពឹង តេះ លូ សៃម គ្រឹប នែវ ម៉ុត កាណុង ទូក លូ អន់ឌែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","គ្រឹប កាណាគ័ ឡាក់ អ្លុ តាំងហើម ម៉ោញ ឃូ ៗ ប៉ាណាំ គួប ឡាំ ម៉ុត ពឹង ទូក តីស អន់ឌូ លូ វគ័ ណូអេ។ ");
INSERT INTO tpu_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","កា ទី កាណាគ័ ទឹប ទោល យ៉ង់ តាម៉ុង កា ម៉ុត កាណុង ទូក តីស ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ណូអេ តាទឹច។ កេះណោះ ប‌៉្រ័ះ កាត្រើគ អំប៉ារ ទូក តីស ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ទៀក តីស កា រ៉ាឡាប អង់កក់ តេះ ៤០ ដារ់ ទៀក កា ហ៊ែង ហាវ ៗ ប៉្រគ័ អន់ កា ទូក តីស ណោះ ដោង ឡឹង តេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","ទៀក រ៉ាឡាប ណោះ ហ៊ែង ហាវ ហ៊ែង ថាំង ទូក តីស ណោះ កា ដោង ពឹង អង់កក់ ទៀក។ ");
INSERT INTO tpu_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ទៀក រ៉ាឡាប ណោះ ហ៊ែង ហាវ ៗ កាខាក់ ប៉្រគ័ អន់ កា ប៉ានឹម ចាំងហីគ ប៉ុប ចំ កា សាគឹម ទិ អ៊្យ្វែត។ ");
INSERT INTO tpu_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","កេះណោះ ទៀក រ៉ាឡាប ណោះ ហាវ ចាំងហីគ ឡឹង ប៉ានឹម ១៥ ហាត់ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","ទិ កាណាគ័ ឡាក់ ចាក អ្វៃ ពឹង អង់កក់ តេះ អូ ផា កាណាគ័ ស្រុក កាណាគ័ ព្រី សៃម ប៉ារ់ កាណាគ័ បឹកៗ បៃកៗ ព្រុងៗ គ្រឹប នែវ លូ ប៉ាណូស កា តោ័ ទិ និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","កាណាគ័ ឡាក់ អ្លុ តាំងហើម អ្វៃ ពឹង តេះ គោក កា តោ័ ទិ។ ");
INSERT INTO tpu_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","ប‌៉្រ័ះ ប៊កកាតយ័ កា ថាំឡាយ ទិ កាណាគ័ ឡាក់ អ្វៃ ពឹង អង់កក់ តេះ ទឹប ប៉ាណូស ទឹប កាណាគ័ ជុង ប៉្វាន់ ទឹប កាណាគ័ វ៉ាវ៉ារ ទឹប សៃម ប៉ារ់ ពឹង ប៉្លៃង។ អ្វៃ សល់ ដឹង ខាប់ខួ វគ័ ណូអេ លូ កាណាគ័ អ្វៃ កាណុង ទូក អន់ឌូ លូ អន់ឌែ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ទៀក តីស ណោះ អ្វៃ ទួម ពឹង អង់កក់ តេះ ១៥០ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ផះ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កាចាំង កា វគ័ ណូអេ លូ កាណាគ័ អ្វៃ កាណុង ទូក ទិណោ័ះ អ៊ែ កា ប៉្រគ័ អន់ ទី ខ្យាល ពឹង តេះ ភឿ អន់ ទៀក ស្រក ទៀក កា ស្រក តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ត្រោម ទៀក ឡាក់ ប៉្លោហ ឡាច់ ឡឹង តេះ លូ ត្រោម ទៀក ឡឹង ប៉្លៃង អ៊ែ តាគ់ អញ់សឹរ ណាវ្គ ប៉្លៃង បី កា ស្វាស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","កេះណោះ ទៀក កា ស្រក ឡាំ ៗ ប៉ាគ់ ទឹល ១៥០ ដារ់ ទៀក ណោះ កា ហ៊ែង ស្រក ណាវ្គ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ប៉ាគ់ ទឹល ខៃ ៧ ដារ់ ទី ១៧ ផាឌី ទូក តីស ណោះ ទួម ពឹង ប៉ានឹម អារ៉ារ៉ាត។ ");
INSERT INTO tpu_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","ទៀក ណោះ កា ស្រក ឡាំ លើយ ប៉ាគ់ ទឹល ខៃ ១០ ដារ់ ទី ១ កា ទី តាបាង កល់ ប៉ានឹម អន់ទៀគៗ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ប៉ាគ់ ទី ៤០ ដារ់ ឡឹង ណោះ វគ័ ណូអេ កា បើក រ៉ាំបោះ ទូក ឡាក់ អ៊ែ ប៉្រគ័ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","8","អ៊ែ ប៉ិច អ្លុ អន់តគ់ ផា ទៀក ស្វាត់ ទិ ឡឹង អង់កក់ តេះ កេះ ញ៉ា បើ។ អ៊ែ កា ឡើយ សៃម អង់អៀក ម៉ោញ ហះកា អង់អៀក ណោះ ប៉ារ់ សឹត ប៉ារ់ ឡាំ លើយ ទឹល ទៀក ស្វាត់ ទិ ឡឹង អង់កក់ តេះ។ ឡៃង ឡឹង ណោះ ណាវ្គ អ៊ែ ឡើយ អន់តើប រ៉ាក់ សាណាង័ ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ហះកា អន់តើប រ៉ាក់ សាណាង័ ណាំង ចារ ឡើះ ហះ ចំ កា អូ ទី ខង ទៀក អ្វៃ ប៉ាញ័ ទឹប អង់កក់ តេះ។ សៃម ណោះ កា វ៉ីល សឹត ណាំង វគ័ ណូអេ ប៉ាគ់ ទូក តីស ទៅ។ អ៊ែ កា អន់ទឺប តី អ្យក់ សៃម ម៉ុត កាណុង ទូក អន់ឌូ លូ អ៊ែ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","វគ័ ណូអេ កា ក្យាគ់ តាំប៉ើះ ដារ់ ឡឹង ណោះ ណាវ្គ កេះណោះ ឡើយ អន់តើប រ៉ាក់ សាណាង័ ម៉ោញ ទង ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ប៉ាគ់ ទឹល កាង៉ាច អន់តើប រ៉ាក់ សាណាង័ សឹត ណាំង វគ័ ណូអេ ណាវ្គ ទឹប សាំងកង់ សឹត ឡាំបុង តើម អូលេវ ណោះ ហង បះ វគ័ ណូអេ អ្លុ អន់តគ់ ផា ទៀក ស្វាត់ ឡឹង អង់កក់ តេះ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","អ៊ែ អ្វៃ ក្យាគ់ តាំប៉ើះ ដារ់ ណាវ្គ កេះណោះ អ៊ែ ឡើយ អន់តើប រ៉ាក់ សាណាង័ ម៉ោញ ទង ណាវ្គ ហះកា អូ ប៉ប័ អន់តើប វ៉ីល សឹត ប៉ាគ់ អ៊ែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","ផះ វគ័ ណូអេ អាញុ ៦០១ សាណាំ រ៉ាំងវ៉ាង ខៃ ១ ដារ់ ទី ១ ទៀក កា ស្វាត់ ទិ ឡឹង អង់កក់ តេះ។ កេះណោះ អ៊ែ បើក អន់តល័ ទូក ហៃ ប៉ប័ តេះ គោក កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ប៉ាគ់ ទឹល ខៃ ២ ដារ់ ២៧ អង់កក់ តេះ កា ដាគ់ សាអ្យាំង ក្រោះ ទិ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ណូអេ ផា ");
INSERT INTO tpu_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«ហគ់ អីស លូ គន កាម៉ាញ់ លូ ម៉ាយ កាំហ្មាន់ អីស អន់ដីស ឡាច់ ឡឹង ទូក អា ពិ។ ");
INSERT INTO tpu_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","អីស ឡើយ ទិ កាណាគ័ ឡាក់ អ្វៃ កាណុង ទូក អន់ឌូ លូ អីស ណោះ ទឹប កាណាគ័ ជុង ប៉្វាន់ សៃម ប៉ារ់ លូ កាណាគ័ វ៉ាវ៉ារ គ្រឹប នែវ អន់ អន់ឌែ ឡាច់ ដេល ភឿ អន់ អន់ឌែ កើត រ៉ាល ទៀល ស៊ក អ្វៃ ប៉ាញ័ ទឹប អង់កក់ តេះ អា»។ ");
INSERT INTO tpu_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","កេះណោះ វគ័ ណូអេ កា ឡាច់ ឡឹង ទូក ណោះ តាទឹច ហង ទឹប គន កាម៉ាញ់ លូ ម៉ាយ កាំហ្មាន់ អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","គ្រឹប កាណាគ័ អ្វៃ កាណុង ទូក ឡាក់ កា កាណាគ័ ជុង ប៉្វាន់ សៃម ប៉ារ់ លូ កាណាគ័ វ៉ាវ៉ារ ទិណោ័ះ កា ប៉ាណាំ គួប ឡាច់ ឡឹង ទូក តាម នែវ និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","កេះណោះ វគ័ ណូអេ ប៉្រគ័ ចារ សាំរ៉ាប់ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័  អ៊ែ កា រ៉ើស អ្យក់ កាណាគ័ ជុង ប៉្វាន់ គ្រឹប នែវ ឡាក់ ត្រគ់ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ លូ សៃម ប៉ារ់ គ្រឹប នែវ ឡាក់ ត្រគ់ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ។ កេះណោះ អ៊ែ ពុះ អ្លាត ពឹង ចារ អ៊ែ ប៉្រគ័ ណោះ ភឿ រ៉ាម៉ះ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","ប‌៉្រ័ះ ប៊កកាតយ័ កាតាំង បោ ប៉ុង បោ រ៉ិញ អ៊ែ កា ប៉ាញ័ ពុត ឡូត ទឹប ឃឹត កាណុង ពុត ផា «យ‌៉័ះ ប៉ាណូស ទី ពុត ពៀក អូ ដាគ់ ឡឹង អ្វៃ សាស្វា កាតាម អាញ់ អូ ថាំឡាយ អង់កក់ តេះ ញន កា អន់ឌែ ណាវ្គ អុះ។ អាញ់ ចឹង អូ ប៉ាន់តោ័ កាណាគ័ រ៉ីស វ៉ឹច លូ អាញ់ ប៉្រគ័ ពែ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","ផា អ្វៃ ទី អង់កក់ តេះ ណោះ កា ចឹង ទី ថុន សាមូល ថុន តប់ ថុន កាច់ ថុន ច្រូត័ លូ ទី ថុន បី ថុន ប៉្រាំង ទី ថុន សាអូះ ថុន គ្រឹន ទី កាម៉ាំង ទី កាដារ់ លើយ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កាប ដាគ់ កា វគ័ ណូអេ លូ គន កាម៉ាក័ អ៊ែ ផា «ហគ់ អន់ដីស ទី គន សោ កើត រ៉ាល អន់ អៀង កាខាក់ អ្វៃ ប៉ាញ័ ទឹប អង់កក់ តេះ អា ពិ។ ");
INSERT INTO tpu_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","ទិ កាណាគ័ អ្វៃ ពឹង អង់កក់ តេះ លូ កា កាណុង ទៀក សាឡីគ សាឡាយ ទឹប សៃម ប៉ារ់ ពឹង ប៉្លៃង លូ កាណាគ័ វ៉ាវ៉ារ គ្រឹប នែវ អន់ឌែ ចឹង អ្យូគ កា អន់ដីស លើយ។ អាញ់ ចឹង អន់ កាណាគ័ ទិណោ័ះ អ្វៃ កាន់តេ័ះ អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","គ្រឹប កាណាគ័ ទិណោ័ះ អាញ់ ចឹង អន់ អន់ដីស សា ហង ឡាក់ កា អាញ់ អន់ សាណា ហ្លាអ្យិត កា អន់ដីស ផះ អន់ទ្រួល ពែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","ហះកា អន់ដីស អូ ត្រគ់ សា ប៉ាំងឡៃ ឡាក់ ទី ផាម ខង ផាម ប៉្រគ័ អន់ កាណាគ័ រ៉ីស។ អន់ទ្រួល ចឹង សា អ្យាំ សៃម អន់ដីស ត្រគ់ សាក អង់កូ អន់ ឡាច់ ផាម ទិ ហិ។ ");
INSERT INTO tpu_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ផា ប៉ាណូស ពឿ ប៉ាន់តោ័ អន់ដីស អាញ់ ចឹង ចៃគ ថូត ប៉្រើ ពូ ប៉ាន់តោ័ អ៊ែ និះទៅ ដេល លូ ផា ទី កាណាគ័ ញ៉ា ប៉ាន់តោ័ អន់ដីស អាញ់ ចឹង ប៉ាន់តោ័ កាណាគ័ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","ផា ទី ប៉ាណូស ពឿ ប៉ាន់តោ័ ប៉ាណូស ប៉ាណូស ណោះ ពូ ចឹង ប៉ាន់តោ័ អ៊ែ និះទៅ ដេល ខង ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាំងកើត ប៉ាណូស អន់ វ៉ឹច លូ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","កាប៉ាច់ អន់ដីស ត្រគ់ ទី គន សោ អន់ អៀង អ្វៃ ប៉ាញ័ អង់កក់ តេះ អា ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ណូអេ លូ គន អ៊ែ ណាវ្គ ផា ");
INSERT INTO tpu_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«ហៃ អាញ់ សាញ៉ា រែវ ពុត លូ អន់ដីស កេះ លូ ទឹល ផូង័ វ៉ាច់ អន់ដីស រ៉ាំងហាវ អន់តីគ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","អាញ់ សាញ៉ា អា សាំរ៉ាប់ ទិ កាណាគ័ ឡាក់ ឡាច់ ឡឹង ទូក អន់ឌូ លូ អន់ដីស ដេល ឡាក់ កា កាណាគ័ ស្រុក កាណាគ័ ព្រី កាណាគ័ ប៉ារ់ ទឹប កាណាគ័ ទិណោ័ះ ចឹង អ្វៃ ពឹង អង់កក់ តេះ អន់ទៀ។ ");
INSERT INTO tpu_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","អាញ់ សាញ៉ា លូ អន់ដីស ផា ចឹង អូ ទី ទៀក រ៉ាឡាប ថាំឡាយ ប៉ាណូស លូ កាណាគ័ ទិ ប្លី ណាវ្គ ហង លូ ចឹង អូ ទី ទៀក តីស រ៉ាឡាប អង់កក់ តេះ ណាវ្គ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ផា «អាញ់ ប៉្រគ័ សារ សាញ៉ា រែវ ពុត អា លូ អន់ដីស ទឹប កាណាគ័ ទិណោ័ះ អ្វៃ អន់ឌូ លូ អន់ដីស លើយ គ្រឹប រ៉ាំងហាវ។ ចឹង ទី សាញ៉ា ចាណាំ ម៉ោញ ប៉្រគ័ អន់ កាចាំង សារ អា ");
INSERT INTO tpu_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ឃឺ អាញ់ ចឹង ចៃគ កាញ់ច្រូ ពឹង ប៉្លៃង ភឿ អន់ កាចាំង សារ អាញ់ សាញ៉ា លូ ប៉ាណូស ទឹប កាណាគ័ អ្វៃ ពឹង អង់កក់ តេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ផះ អាញ់ ប៉្រគ័ អន់ ទី តើម បី ពឹង ប៉្លៃង ណោះ ចឹង ប៉ប័ កាញ់ច្រូ ឡាច់ ពឹង ប៉្លៃង ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ផះ ណោះ អាញ់ ចឹង កាចាំង កា សារ អាញ់ សាញ៉ា លូ អន់ដីស លូ កាណាគ័ រ៉ីស ទិណោ័ះ ម៉ាគ់ ចឹង អូ ទី ទៀក តីស រ៉ាឡាប ថាំឡាយ ទិ កាណាគ័ ពឹង អង់កក់ តេះ ណាវ្គ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","ផះ ចំ អាញ់ ប៉ប័ កាញ់ច្រូ ពឹង ប៉្លៃង អាញ់ ចឹង កាចាំង លើយ កា សារ ឡាក់ អាញ់ សាញ៉ា លូ កាណាគ័ លូ ប៉ាណូស ទិណោ័ះ អ្វៃ ពឹង អង់កក់ តេះ អា។ ");
INSERT INTO tpu_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","កាញ់ច្រូ អា ប៉្រគ័ អន់ អន់ហ្នាល់ សារ អាញ់ សាញ៉ា លូ កាណាគ័ លូ ប៉ាណូស ពឹង អង់កក់ តេះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","គន កាម៉ាក័ វគ័ ណូអេ ឡាច់ ឡឹង ទូក តីស ណោះ សិច សិម ហាំ លូ យ៉ាភែត។ ហាំ ណោះ ហង ពឹ កាណាន។ ");
INSERT INTO tpu_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","កេះណោះ គន កាម៉ាក័ វគ័ ណូអេ ទិ ប៉ៃង អន់ឌែ កា ទី គន សោ អៀង ចាក អ្វៃ ប៉ាញ័ អង់កក់ តេះ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","វគ័ ណូអេ ប៉្រគ័ ម៉ីរ តប់ ប៉្លៃ អង់កាច អន់ទ្រួល ឡឹង ពូ។ ");
INSERT INTO tpu_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","ទី ដារ់ ម៉ោញ វគ័ ណូអេ ប៉ាញឹល តាពែ ប៉្លៃ អង់កាច តៃប សាឡុន កាណុង រ៉ាណើះ អ៊ែ ទៅ។ ");
INSERT INTO tpu_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ផះ ណោះ ហាំ ពឹ កាណាន ប៉ប័ ពឹ អ៊ែ តៃប សាឡុន នីណោ័ះ កា ឡាំ រ៉ះ លូ ម៉ី អ៊ែ ពៀរ ដូវ ណាវ្គ ឡាក់ អ្វៃ គែង ឡីង រ៉ាណើះ។ ");
INSERT INTO tpu_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","កេះណោះ សិម លូ យ៉ាភែត អ្យក់ អង់យ៉ាគ័ សាំពៀយ ពឹង កាពែង អន់ឌែ ចាក រ៉ុញ កល់ កាទុត ឡាំ តាគ់ អញ់សូវ ពឹ អន់ឌែ ហះកា ម៉ាត់ អន់ឌែ អូ កាលែង ហៃ អុះ ហៃ ដឹង ប៉ាគ់ ង៉ីរ លើយ ខង អន់ឌែ អូ ប៉ិច ប៉ប័ ពឹ អន់ឌែ អ្វៃ សាឡុន។ ");
INSERT INTO tpu_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","ប៉ាគ់ វគ័ ណូអេ ស្វាស ប៉ាញឹល អ៊ែ កា អ្លុ អន់តគ់ សារ គន ស្រុច អ៊ែ ប៉្រគ័។ ");
INSERT INTO tpu_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","អ៊ែ កា ប៉ាស្យាប កា ហាំ ផា៖ «កាណាន ត្រគ់ សារ ប៉ាស្យាប ហង។ អន់ អុះ ម៉ី អ៊ែ យរ អ៊ែ វ៉ឹច លូ ទុច អូ គឹត អូ ខា ក្វា ឡឹង ពូ ឡូត»។ ");
INSERT INTO tpu_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","អ៊ែ កាប ណាវ្គ ផា៖ «ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សិម។ អន់ កាណាន កេះ ទុច សិម ពិ។ ");
INSERT INTO tpu_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ យ៉ាភែត ទី គន សោ លូ ស្រុក តេះ អន់ សិម លូ យ៉ាភែត ដាគ់ កា គួប អន់ឌែ។ អន់ កាណាន កេះ ទុច យ៉ាភែត ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ឡៃង ឡឹង ទៀក តីស រ៉ាឡាប អង់កក់ តេះ វគ័ ណូអេ អ្វៃ រ៉ីស ទី ៣៥០ សាណាំ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","អាញុ វគ័ ណូអេ ទិណោ័ះ ទី ៩៥០ សាណាំ កេះណោះ តោ័ កា អ៊ែ។ … ");
INSERT INTO tpu_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ផះ សើគ ពែ ប៉ាណូស ទិឌូ អ្វៃ ពឹង អង់កក់ តេះ អា កាប ដឹង ម៉ោញ សុនសាត ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ផះ អន់ឌែ ចាក ឡឹង ដារ់ ឡាច់ ទឹល ប៉ាគ់ ព្រី ស៊ីណើ អន់ឌែ ប៉ប័ ចារ ដាគ់ តាប៉ង់ អន់ឌែ កា ប៉្រគ័ ចារ អ្វៃ ហះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ឡៃង ឡឹង ណោះ អន់ឌែ កាកាប លូ គួប ផា «ពិ ពិន អ្យក់ តេះ ប៉្រគ័ អិត កេះណោះ ពុះ អន់ កាង័»។ អន់ឌែ យរ អិត ណោះ ប៉ាតាង អំហ្មោ លូ អ្យក់ ចារ័ ម៉ូ ឡឹង តេះ ភឿ ប៉ាតឹត អិត ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","កេះណោះ អន់ឌែ ផា «ពិ ពិន ប៉្រគ័ មឿង តីស ម៉ោញ លូ ប៉្រគ័ ហី ម៉ោញ តីស ចាំងហីគ អន់ ទឹល ប៉្លៃង ឡូត ម៉ាគ់ ពិន លៅ លែង សិច ដាគ់ ពិន អូ ក្លះ គួប ចាក អ្វៃ ប៉ាញ័ ទឹប អង់កក់ តេះ អា»។ ");
INSERT INTO tpu_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ប‌៉្រ័ះ ប៊កកាតយ័ កា ជឹរ ហៃ មឿង លូ ហី តីស អន់ឌែ ផះ ប៉្រគ័ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","កេះណោះ អ៊ែ ផា «ហៃ អន់ឌែ អា សុនសាត ដឹង ម៉ោញ កាប កា និះទៅ ដេល។ ផា អន់ឌែ អ្លុ ប៉្រគ័ កេះ ង៉ារ អា ង៉ារ ញ៉ា ឡាក់ អន់ឌែ ប៉ិច ប៉្រគ័ កា ចឹង អ្លុ និះទៅ ហង អូ ទី សារ ញ៉ា ចឹង ប៉ាំងខើក អន់ឌែ ទី អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ទឹល នីណោ័ះ អាញ់ ចឹង ជឹរ ប៉្រគ័ អន់ កា អន់ឌែ កាប តាងៗ ឡឹង គួប ភឿ ជែ អន់ អ្លុ កាប លូ គួប សោប ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ជឹរ ប៉ាក្លះ អន់ឌែ អន់ ឡាច់ ឡឹង ចារ ណោះ ចាក អ្វៃ ប៉ាញ័ ទឹប អង់កក់ តេះ។ មឿង ណោះ អន់ឌែ អ្លាត អូ ជៀ ប៉្រគ័ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","ញន ខ អា ហង បះ ពូ អន់ សិច ផា មឿង បាប៊ីឡូន  ខង ចារ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ កា ប៉ាណូស ទិឌូ កាប តាងៗ ឡឹង គួប សោប ទឹប ប៉្រគ័ អន់ កា ពូ ក្លះ ឡាច់ ឡឹង ចារ ណោះ ចាក អ្វៃ ប៉ាញ័ អង់កក់ តេះ។ … ");
INSERT INTO tpu_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","អា ហង សារ ផូង័ វ៉ាច់ វគ័ ថេរ៉ា ។ ថេរ៉ា គន អ៊ែ អាប់រ៉ាម ណាហ៊រ លូ ហារ៉ាន។ ហារ៉ាន គន អ៊ែ ឡត។ ");
INSERT INTO tpu_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ហារ៉ាន កា តោ័ អន់ទ្រួល ឡឹង ពឹ អ៊ែ ថេរ៉ា ពឹង មឿង អ៊ុរ ប៉ាគ់ ប៉ាថេត បាប៊ីឡូន ឡាក់ ស្រុក កាណើត អ៊ែ ទៅ។ ");
INSERT INTO tpu_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","អាប់រ៉ាម លូ ណាហ៊រ អន់ឌែ ទី កាម៉ាញ់ កាម៉ាញ់ អាប់រ៉ាម សិច សារ៉ាយ កាម៉ាញ់ ណាហ៊រ សិច មីលកា។ មីលកា អ៊ែ ឡាក់ គន ហារ៉ាន អុះ មីលកា សិច យីសាកា។ ");
INSERT INTO tpu_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","សារ៉ាយ ឡាក់ អង់កាន់ អូ អ្លុ ទី គន អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","វគ័ ថេរ៉ា កា ប៉ាណាំ គន អ៊ែ អាប់រ៉ាម លូ សោ អ៊ែ ឡត ទឹប ម៉ាយ កាំហ្មាន់ អ៊ែ សារ៉ាយ អន់ឌែ ចាក ឡាច់ ឡឹង មឿង អ៊ុរ ប៉ាថេត បាប៊ីឡូន ចាក ឡាំ ប៉ាគ់ ប៉ាថេត កាណាន។ ហះកា បើ ទឹល ប៉ាថេត កាណាន អុះ អន់ឌែ ចាក អង់ក័ះ ទឹល គឹត តេះ ហារ៉ាន់ អន់ឌែ ប៉្រគ័ ចារ អ្វៃ ពឹង ស្រុក ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","អាញុ វគ័ ថេរ៉ា ទី ២០៥ សាណាំ កេះណោះ អ៊ែ តោ័ ពឹង ស្រុក ហារ៉ាន់ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","ឡៃង ឡឹង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ អាប់រ៉ាម ផា «ហគ់ អីស ឡាច់ ឡឹង មើគ ពឹ អុះ ម៉ី ស្រុក តេះ អីស អា ឡាំ អ្វៃ ប៉ាគ់ ប៉ាថេត អាញ់ ចឹង តាំបាង អន់ កា អីស។ ");
INSERT INTO tpu_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","អាញ់ ចឹង ប៉្រគ័ អន់ គន សោ អីស កើត អៀង កាខាក់ ម៉ោញ សុនសាត ទឹប អាញ់ ចឹង អន់ សារ ដាគ់ កា អីស។ អាញ់ ចឹង ប៉្រគ័ អន់ អីស លៅ លែង សិច។ អីស ចឹង កេះ ប៉ាណូស អន់ សារ ដាគ់ កា ពូ។ ");
INSERT INTO tpu_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","អាញ់ ចឹង អន់ សារ ដាគ់ កា ប៉ាណូស បក់ ចំ ឡាក់ ដាគ់ កា អីស ហះកា ផា ពូ ប៉ាស្យាប អីស អាញ់ ចឹង ប៉ាស្យាប ពូ ដេល។ គ្រឹប ផូង័ អ្វៃ ពឹង អង់កក់ តេះ ចឹង ទី សារ សាណុក សាវ៉ាក ញន កា សារ អាញ់ សាញ៉ា លូ អីស ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","វគ័ អាប់រ៉ាម កា ប៉្រគ័ ពួយ ប៉ានឹរ ប‌៉្រ័ះ រ៉ះ កា អ៊ែ តាទឹច។ មន អ៊ែ ឡត កា ចាក ពួយ អ៊ែ ដេល។ ផះ វគ័ អាប់រ៉ាម ឡាច់ ឡឹង ស្រុក ហារ៉ាន់ ណោះ អាញុ អ៊ែ ៧៥ សាណាំ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","អ៊ែ ជៀក ទឹប កាម៉ាញ់ អ៊ែ យ៉ាគ់ សារ៉ាយ លូ មន អ៊ែ ឡត អ្យក់ ទឹប រ៉ាស អំប៉ាស ឡាក់ អន់ឌែ ណាំង ទី លូ ទុច ឡាក់ អន់ឌែ តាច់ ពឹង ស្រុក ហារ៉ាន់ ឡាំ អន់ឌូ ដេល។ អន់ឌែ ប៉ាណាំ គួប ចាក ឡាំ ប៉ាគ់ ប៉ាថេត កាណាន។ ");
INSERT INTO tpu_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ប៉ាគ់ ទឹល ប៉ាថេត កាណាន កេះ វគ័ អាប់រ៉ាម ចាក ឡាំ អ្វៃ ប៉ាគ់ ស្រុក ស៊ីគែម ក្យាម័ តើម ជ្រី ឡាក់ ចារ អំរ៉ាញ។ រ៉ាំងហាវ ណោះ សុនសាត កាណាន ឡាក់ តាំងឡា ប៉ាថេត ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ តាំបាង ឡាកោ អន់ កា វគ័ អាប់រ៉ាម ប៉ប័ ទឹប រ៉ះ ផា «អាញ់ ចឹង មប ប៉ាថេត អា អន់ កា ផូង័ វ៉ាច់ អីស ហង»។ កេះណោះ វគ័ អាប់រ៉ាម ប៉្រគ័ ចារ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ តាំបាង ឡាកោ អន់ អ៊ែ ប៉ប័។ ");
INSERT INTO tpu_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","កេះណោះ អន់ឌែ ចាក ឡាំ អ្វៃ ប៉ាគ់ ប៉ានឹម ក្យាម័ ស្រុក បេតអ៊ែល គែង ដារ់ ឡាច់។ អ៊ែ ប៉្រគ័ រ៉ាណើះ អ្វៃ ហះ ណោះ ស្រុក បេតអ៊ែល អ្វៃ គែង ដារ់ ឡាច់ លូ ស្រុក អៃ អ្វៃ គែង ដារ់ ម៉ុត។ ហះ ណោះ អ៊ែ ប៉្រគ័ ចារ ម៉ោញ ណាវ្គ សាំរ៉ាប់ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ទឹប អើ សិច អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ឡៃង ឡឹង ណោះ អន់ឌែ ចាក ឡាំ ណាវ្គ រ៉ើ ឡឹង ចារ ម៉ោញ ណាំង ចារ ម៉ោញ ឡាំ ប៉ាគ់ ព្រី ស៊្រែ ណេកិប។ … ");
INSERT INTO tpu_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ឡត ឡាក់ ឡាំ អន់ឌូ លូ វគ័ អាប់រ៉ាម ទី តាប៉ល់ ចៀម តាប៉ល់ រ៉ក់ អៀង ឡាក់ កា វគ័ អាប់រ៉ាម អ៊ែ កា ទី រ៉ាណើះ អៀង សាំរ៉ាប់ មួត ទុច អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ហះកា ចារ ណោះ អូ បគ័ អន់ឌែ ចឹង អ្វៃ អន់ឌូ អុះ ខង អន់ឌែ ពៀរ ដូវ ទី កាណាគ័ អៀង តាឡាម័ បះ អន់ឌែ អូ អ្លុ អ្វៃ អន់ឌូ។ ");
INSERT INTO tpu_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ផះ ណោះ មួត រង រ៉ក់ រង ចៀម កា វគ័ អាប់រ៉ាម លូ មួត រង រ៉ក់ រង ចៀម កា ឡត កា តាប៉ុញ គួប សោប លើយ។ ផះ ណោះ សុនសាត កាណាន លូ សុនសាត ពែរិស៊ីត កា អ្វៃ ពឹង ប៉ាថេត ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","វគ័ អាប់រ៉ាម កាប លូ ឡត ផា «អីស លូ អាញ់ ជែ អន់ ទី សារ តាប៉ុញ តាប៉ាក់ ហង លូ ជែ អន់ មួត រង រ៉ក់ រង ចៀម អីស លូ មួត រង រ៉ក់ រង ចៀម អាញ់ តាប៉ុញ លូ គួប សោប ដេល ខង ពិន អុះ ម៉ី វ៉ា លូ មន ឡក់។ ");
INSERT INTO tpu_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ហៃ ព្រី ទៀក ទិ អា តីស ខាក់ ទឹល នីណោ័ះ ប៉រ់ មន ក្លះ ឡាច់ ឡឹង អាញ់ ពិ ផា អីស ឡាំ គែង សាំងអ្យោ អាញ់ ចឹង ឡាំ គែង សាម៉ា ផានែវ អីស ឡាំ គែង សាម៉ា ណោះ អាញ់ ចឹង ឡាំ គែង សាំងអ្យោ ឡគ»។ ");
INSERT INTO tpu_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ឡត កា ហៃ ប៉ប័ ព្រី ទៀក ទ្រូង យដាន់ ទិណោ័ះ ទី ទៀក គ្រឹប ចារ។ អន់ទ្រួល ឡឹង ប‌៉្រ័ះ ប៊កកាតយ័ ថាំឡាយ មឿង សូដុំ លូ មឿង កូម៉ូរ៉ា ព្រី ទៀក ចារ ណោះ លើយ ទឹល ស្រុក សូអា ពៀប ឡាក់ កា សួន អេឌែន ឃឺ ឡាក់ កា ព្រី ទៀក ប៉ាថេត អ៊ីស៊ីប រក្យាម័ តាំងលេ នីល ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ឡត រ៉ើស អ្យក់ ព្រី ទៀក ទ្រូង យដាន់ ទិណោ័ះ កា អ៊ែ អ៊ែ កា ចាក ឡាំ គែង ដារ់ ឡាច់។ អន់ឌែ ពៀរ ដូវ ក្លះ ឡាច់ ឡឹង គួប សោប នីអៀ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","វគ័ អាប់រ៉ាម កា អ្វៃ ពឹង ព្រី ទៀក សុនសាត កាណាន កាប៉ាច់ ឡត អ្វៃ រមឿង អន់ទៀគៗ អ្វៃ រទៀក ទ្រូង យដាន់ ណោះ ហង អ៊ែ កា ប៉្រគ័ រ៉ាណើះ ក្យាម័ មឿង សូដុំ។ ");
INSERT INTO tpu_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","មួត មឿង សូដុំ ស៊ុត កា ប៉ាណូស អូ ដាគ់ ឡាក់ ប៉្រគ័ យច តីស ប៉ាសាំង លូ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","អន់តីគ ឡឹង ឡត ក្លះ ឡាច់ ឡឹង វគ័ អាប់រ៉ាម ប‌៉្រ័ះ ប៊កកាតយ័ កាប លូ វគ័ អាប់រ៉ាម ផា «ហគ់ ហៃ គែង ដារ់ ឡាច់ លូ គែង ដារ់ ម៉ុត គែង សាម៉ា លូ គែង សាំងអ្យោ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","អាញ់ ចឹង មប ព្រី ទៀក ឡាក់ អីស ហៃ ប៉ប័ ទិ អា កា អីស លូ កា ផូង័ វ៉ាច់ អីស រ៉ាយ៉ោ័ះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","អាញ់ ចឹង ប៉្រគ័ អន់ ផូង័ វ៉ាច់ អីស ទី ចំលួន អៀង ឡាក់ កា កាបក់ តេះ អូ ទី ពឿ ចឹង ដាម័ យ៉ាប ផូង័ វ៉ាច់ អីស អុះ ឃឺ ពៀប ឡាក់ កា ពូ អូ ដាម័ យ៉ាប កាបក់ តេះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ហគ់ ចាក គ្រឹប ចារ កាណុង ប៉ាថេត អា ពិ ខង អាញ់ ចឹង មប អន់ កា អីស ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","វគ័ អាប់រ៉ាម យ៉ះ រ៉ាណើះ អ្យក់ ឡាំ ប៉្រគ័ ក្យាម័ តើម ជ្រី ម៉ះ វគ័ ម៉ាមរេ ក្យាម័ មឿង ហេប្រូន។ ប៉ាគ់ ណោះ អ៊ែ ប៉្រគ័ ចារ ម៉ោញ ណាវ្គ សាំរ៉ាប់ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ផះ ណោះ ទី សាដាច់ អន់ទៀគៗ ប៉ាណាំ គួប អន់ឌែ ឡាំ តាកូះ។ ទី អាំរ៉ាភែល ឡាក់ សាដាច់ ប៉ាថេត ស៊ីណើ អារីយ៉ុក ឡាក់ សាដាច់ មឿង អេឡាសារ កេដូឡោមើរ សាដាច់ ប៉ាថេត អេឡាំ លូ ធីដាល សាដាច់ មឿង កូយីម ");
INSERT INTO tpu_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","អន់ឌែ ប៉ាណាំ គួប ជៀក តាហាន ឡាំ តាកូះ លូ បេរ៉ា សាដាច់ មឿង សូដុំ លូ ប៊ីរសា សាដាច់ មឿង កូម៉ូរ៉ា ស៊ីណាប សាដាច់ មឿង អាតម៉ា សេមេប៊ើរ សាដាច់ មឿង សេបោម លូ សាដាច់ ស្រុក បេឡា ឃឺ ស្រុក សូអា។ ");
INSERT INTO tpu_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","សាដាច់ ប៉ាតាម័ ដូវ ណោះ ប៉ាណាំ តាហាន ឡាំ អ្វៃ ពឹង ក្លូះ ប៉ានឹម ស៊ីឌីម (កិញអៀ ចារ ណោះ កេះ តាំងលោ័ តីស ទៀក ប៉្រៃ កេះ)។ ");
INSERT INTO tpu_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","សាដាច់ ប៉ាតាម័ ដូវ ណោះ ផះ ប៉ាន់ដា ពែ អន់ឌែ អ្វៃ អន់តេ័ះ សាដាច់ កេដូឡោមើរ លូ ស៊ង រ៉ាបៃ អន់ កា អ៊ែ ទិ ១២ សាណាំ។ ប៉ាគ់ ទឹល ១៣ សាណាំ កេះ អន់ឌែ ប៉ាណាំ គួប អ្លាត អូ ស៊ង ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","ប៉ាគ់ ទឹល ១៤ សាណាំ សាដាច់ កេដូឡោមើរ លូ សាដាច់ អន់ទៀគៗ ឡាក់ អ្វៃ អន់ឌូ លូ អ៊ែ ណោះ អន់ឌែ ប៉ាណាំ គួប ឡាំ តាកូះ លូ សុនសាត រែផៃម ឡាក់ អ្វៃ ពឹង មឿង អាសាថារ៉ូត ការ់ណៃម កេះណោះ ឡាំ តាកូះ លូ សុនសាត ស៊ូស៊ីម ពឹង មឿង ហាំ កេះណោះ ណាវ្គ តាកូះ លូ សុនសាត អេម អ្វៃ ពឹង ស្រុក គិរីយ៉ាថៃម ");
INSERT INTO tpu_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ឡៃង ឡឹង ណោះ ណាវ្គ តាកូះ លូ សុនសាត ហូរី ឡាក់ អ្វៃ ប៉ាគ់ ប៉ានឹម សៀរ តាយ៉ិប លើយ ទឹល ប៉ាគ់ ព្រី ប៉ារ៉ាន ឡាក់ ក្យាម័ ស៊្រែ តីស ។ ");
INSERT INTO tpu_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","កេះណោះ អន់ឌែ វ៉ីល សឹត ណាវ្គ ប៉ាគ់ ទឹល ស្រុក អេនមីសាផាត ឃឺ ស្រុក កាដេះ អន់ឌែ តាកូះ លូ សុនសាត អាម៉ាឡេក ឡាក់ អ្វៃ ពឹង ស្រុក ណោះ ទឹប សុនសាត អាម៉ូរី ឡាក់ អ្វៃ ពឹង ស្រុក ហាសាសូន តាម៉ារ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ផះ ណោះ មួត សាដាច់ ប៉ាតាម័ ដូវ កាតាំង លៅ សារ ណោះ ចឹង ទឹល ប៉ាគ់ អន់ឌែ ណោះ ហង បះ សាដាច់ មឿង សូដុំ សាដាច់ មឿង កូម៉ូរ៉ា សាដាច់ មឿង អាតម៉ា សាដាច់ មឿង សេបោម លូ សាដាច់ ស្រុក បេឡា ឃឺ ស្រុក សូអា កា ប៉ាណាំ គួប ជៀក តាហាន ឡាំ ប៉ាគ់ ក្លូះ ប៉ានឹម ស៊ីឌីម ");
INSERT INTO tpu_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ភឿ តាកូះ លូ កេដូឡោមើរ សាដាច់ ប៉ាថេត អេឡាំ ធីដាល សាដាច់ មឿង កូយីម អាំរ៉ាភែល សាដាច់ ប៉ាថេត ស៊ីណើ លូ អារីយ៉ុក ឡាក់ សាដាច់ មឿង អេឡាសារ។ សាដាច់ ប៉្វាន់ ដូវ តាកូះ លូ សាដាច់ ប៉ាតាម័ ដូវ។ ");
INSERT INTO tpu_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ពឹង ក្លូះ ប៉ានឹម ស៊ីឌីម ណោះ ទី ឡូះ អៀង ពូ សីរ អ្យក់ ចារ័ ម៉ូ។ សាដាច់ មឿង សូដុំ លូ សាដាច់ មឿង កូម៉ូរ៉ា អន់ឌែ អូ ដាម័ ពូ កា សាតាក់ ម៉ុត អោន ពឹង ឡូះ ណោះ សាដាច់ អន់ទៀគ ណាវ្គ អន់ឌែ សាតាក់ រហ្លូវ្គ ប៉ានឹម។ ");
INSERT INTO tpu_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","12","សាដាច់ បក់ សាណ័ះ អន់ឌែ ប៉ាណាំ គួប អ្យក់ រ៉ាស អំប៉ាស លូ សាប្យាំង ពឹង មឿង សូដុំ លូ មឿង កូម៉ូរ៉ា ទិ ប៉្យើះ។ ផះ ណោះ ឡត មន អាប់រ៉ាម អ្វៃ ពឹង មឿង សូដុំ ទឹល នីណោ័ះ អន់ឌែ រ៉ុប ទឹប ឡត លូ អ្យក់ ទឹប រ៉ាស អំប៉ាស អ៊ែ ដេល។ កេះណោះ ចាក ឡាច់ កា អន់ឌែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ទី ប៉ាណូស ម៉ោញ ដូវ ក្លាស សាតាក់ ឡាំ រ៉ះ លូ វគ័ អាប់រ៉ាម ឡាក់ សុនសាត ហេព្រឺ អ៊ែ អ្វៃ ប៉ាគ់ តើម ជ្រី វគ័ ម៉ាមរេ។ វគ័ ម៉ាមរេ អ៊ែ សុនសាត អាម៉ូរី អុះ ម៉ី អេសាកុល លូ អានើរ។ អន់ឌែ ប៉ៃង ដូវ ប៉្រគ័ គួប លូ វគ័ អាប់រ៉ាម។ ");
INSERT INTO tpu_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","ផះ វគ័ អាប់រ៉ាម កាតាំង ពូ រ៉ះ ផា ពូ រ៉ុប មន អ៊ែ ឡត អ៊ែ កា ប៉ាណាំ ទុច ញង គង កាវៀង ចំលួន ៣១៨ ដូវ ឡាក់ អ្លុ តាកូះ ឡាំ តាយ៉ិប ពួយ មួត សាដាច់ ណោះ លើយ ទឹល ប៉ាគ់ មឿង ដាន់។ ");
INSERT INTO tpu_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","អ៊ែ ជែក ទុច ញង គង កាវៀង ប៉ិន តាប៉ល់ កេះណោះ តាកូះ លូ មួត សាដាច់ ទឹប កាម៉ាំង ណោះ ហង កា ទី ទ្រង អ៊ែ អ៊ែ កា តាយ៉ិប ពួយ លើយ ទឹល ស្រុក ហូបា អ្វៃ គែង ជើង មឿង ដាម៉ះ។ ");
INSERT INTO tpu_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","កេះណោះ អ៊ែ អ្យក់ សឹត រ៉ាស អំប៉ាស ទិណោ័ះ លូ មន អ៊ែ ឡត ណោះ ណាវ្គ ទឹប រ៉ាស អំប៉ាស ឡត ទឹប មួត អង់កាន់ ទឹប មួត ប៉ាសុន អ្វៃ ពឹង មឿង សូដុំ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","វគ័ អាប់រ៉ាម សឹត ឡឹង តាកូះ លូ សាដាច់ កេដូឡោមើរ លូ សាដាច់ អន់ទៀគ ឡាក់ អ្វៃ អន់ឌូ កេះណោះ សាដាច់ មឿង សូដុំ ឡាំ កាកាប លូ វគ័ អាប់រ៉ាម អ្វៃ ប៉ាគ់ ក្លូះ ប៉ានឹម សាវេ (ពូ អើ ផា ក្លូះ ប៉ានឹម សាដាច់)។ ");
INSERT INTO tpu_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ផះ ណោះ វគ័ ម៉ិលគីសាឌែក ឡាក់ សាដាច់ មឿង សាឡឹម អ៊ែ ប៉្រើ ពូ អ្យក់ សាណា សាណឹត លូ តាពែ ប៉្លៃ អង់កាច ឡាំ ជឹន កា វគ័ អាប់រ៉ាម លូ កាំឡាំង អ៊ែ។ ម៉ិលគីសាឌែក ឡាក់ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ឡាក់ តីស ហ៊្លត។ ");
INSERT INTO tpu_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","សាដាច់ ម៉ិលគីសាឌែក អ៊ែ ផា «អឺ ប‌៉្រ័ះ ឡាក់ តីស ហ៊្លត ឡាក់ ប៉ាំងកើត តេះ ប៉្លៃង អីស អន់ សារ ដាគ់ កា អាប់រ៉ាម អា ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","កេះណោះ អ៊ែ ផា «ពិ ពិន ប៉ានេ ប‌៉្រ័ះ ឡាក់ តីស ហ៊្លត ខង អ៊ែ មប តាម៉ឺរ ទិណោ័ះ អន់ កា អីស ទី ទ្រង អីស»។ វគ័ អាប់រ៉ាម កា អ្យក់ រ៉ាស អំប៉ាស ឡាក់ អ៊ែ អ្យក់ ឡឹង ពូ ណោះ អញ់ជឹត ចានែក អន់ កា ម៉ិលគីសាឌែក ម៉ោញ ចានែក។ ");
INSERT INTO tpu_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","កេះណោះ សាដាច់ មឿង សូដុំ រ៉ះ កា វគ័ អាប់រ៉ាម ផា «ប៉រ់ អីស ជឹន ដឹង ប៉ាសុន ណោះ អន់ កា អាញ់ រ៉ាស អំប៉ាស ទិណោ័ះ អ្យក់ កា អីស ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","វគ័ អាប់រ៉ាម តើល សាដាច់ មឿង សូដុំ ផា «អាញ់ ម៉ត់ កេះ លូ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ តីស ហ៊្លត ឡាក់ ប៉ាំងកើត តេះ ប៉្លៃង ផា ");
INSERT INTO tpu_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","យ‌៉័ះ ព្រៀយ ម៉ោញ តាំងហារ័ លើ កាស៊ែ កឺប ម៉ោញ កាស៊ែ កា អាញ់ ចឹង អូ អ្យក់ អុះ កាណាគ័ ញ៉ា ឡាក់ រ៉ាស អំប៉ាស អីស ណោះ អន់ទៀ អីស ចឹង ផា \"ញឹន ហង ប៉្រគ័ អន់ កា អាប់រ៉ាម កើត ប‌៉្រ័ះ ប៉ាត្រង័\"។ ");
INSERT INTO tpu_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","អាញ់ អូ ប៉ិច កា កាណាគ័ ញ៉ា អុះ អាញ់ ប៉រ់ ដឹង សាណា សាណឹត ឡាក់ កាំឡាំង ញឹន សា ទិ កេះ ណោះ លូ ចានែក មួត បក់ ឡាំ តាកូះ អន់ឌូ លូ អាញ់ ណោះ។ អន់ អានើរ អេសាកុល លូ ម៉ាមរេ អ្យក់ ពិ ចានែក អន់ឌែ»។ ");
INSERT INTO tpu_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","រ៉ាវ៉ាច់ ឡឹង សារ ណោះ កេះ វគ័ អាប់រ៉ាម ប៉ប័ ប‌៉្រ័ះ ប៊កកាតយ័ តាំបាង ឡាកោ កា អ៊ែ លូ រ៉ះ ផា «អឺ អាប់រ៉ាម អីស ជែ អ្យូគ។ អាញ់ ឡាក់ ខៃល ប៉ងកាន់ អីស អីស ចឹង ទី សារ ដាគ់ អៀង កាខាក់»។ ");
INSERT INTO tpu_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","វគ័ អាប់រ៉ាម កា តើល ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័ យ‌៉័ះ អីស អន់ កាណាគ័ ញ៉ា កា អាញ់ កា អូ ទី ខា អុះ ខង អាញ់ ចឹង តោ័ ហង គន ម៉ោញ ដូវ កា អាញ់ អូ ទី ដេល។ ប៉ាណូស បក់ ចឹង អ្យក់ ប៉ាដក់ អាញ់ ណោះ ឃឺ អ៊ែលីស៊ើរ ឡឹង មឿង ដាម៉ះ តោ ");
INSERT INTO tpu_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ខង អីស អូ អន់ អាញ់ ទី គន ភឿ អ្យក់ ប៉ាដក់ អាញ់ អា ទី ដឹង ទុច អ្វៃ ពឹង ហី អាញ់ អា ហង ចឹង អ្យក់ ប៉ាដក់ អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ អាប់រ៉ាម ផា «អូ ត្រគ់ អ៊ែលីស៊ើរ អុះ ឃឺ គន អីស ទៅ ចឹង អ្យក់ ប៉ាដក់ អីស ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ជៀក វគ័ អាប់រ៉ាម ឡាច់ ប៉ាគ់ ឡីង អ៊ែ ផា «អីស ង៉ើយ ហៃ ពឹង ប៉្លៃង តោ ហគ់ អីស យ៉ាប សំឡង់ តោ ទិ ញ៉ា អូ ?» អ៊ែ រ៉ះ ណាវ្គ ផា «ផូង័ វ៉ាច់ អីស ចឹង អៀង ឡាក់ កា សំឡង់ តោ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","វគ័ អាប់រ៉ាម កា សឿ សារ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ ណោះ។ ញន កា អ៊ែ សឿ ប‌៉្រ័ះ ផា អ៊ែ ប៉ាណូស ដាគ់ ត្រង់។ ");
INSERT INTO tpu_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","ឡៃង ឡឹង ណោះ ប‌៉្រ័ះ រ៉ះ កា អ៊ែ ណាវ្គ ផា «អាញ់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ទី ប៉ាណាំ អីស ឡាច់ ឡឹង មឿង អ៊ុរ ប៉ាថេត បាប៊ីឡូន ពែ ភឿ មប ប៉ាថេត អា អន់ អីស ប៉្រគ័ តាំងឡា»។ ");
INSERT INTO tpu_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","វគ័ អាប់រ៉ាម តើល ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័ នីចម័ អាញ់ ចឹង អ្លុ អន់តគ់ ផា ប៉ាថេត អា ចឹង ទី កា អាញ់ ?» ");
INSERT INTO tpu_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ អាប់រ៉ាម ផា «ហគ់ អីស អ្យក់ រ៉ក់ យ៉ង់ ម៉ោញ អាញុ ប៉ៃង សាណាំ ប៉ារ់ពេ យ៉ង់ ម៉ោញ អាញុ ប៉ៃង សាណាំ លូ ចៀម ទោល ម៉ោញ អាញុ ប៉ៃង សាណាំ អន់តើប ដោច ម៉ោញ លូ អន់តើប រ៉ាក់ សាណាង័ ប៉ាញ័ សាតង័ ម៉ោញ អន់ កា អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","វគ័ អាប់រ៉ាម អ្យក់ កាណាគ័ ទិណោ័ះ អន់ កា ប‌៉្រ័ះ។ រ៉ក់ ប៉ារ់ពេ លូ ចៀម ណោះ អ៊ែ ច្រះ ទងតិគ័ កេះណោះ អន់ ហះ សានែង គួប អ៊ែ ទៅ ណោះ ហង ហះកា អន់តើប អ៊ែ អូ ច្រះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ផាឌី ទី ម៉ីត ជឹរ ឡើះ ប៉ិច សា កាណាគ័ អ៊ែ ណោះ ហះកា វគ័ អាប់រ៉ាម ទ្រុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","ប៉ាគ់ ដារ់ ចិរៗ ក្យាម័ ចឹង ម៉ុត កេះ វគ័ អាប់រ៉ាម តៃប ហ្លាក់ អ៊ែ អំប៉ោ អ្យូគ កាខាក់ ខង អ៊ែ ប៉ប័ ទី ដឹង ម៉ាម៉ាំង រ៉ាំងអ៊ត ជុំ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កាប លូ វគ័ អាប់រ៉ាម ផា «អាញ់ រ៉ះ អន់ អីស អ្លុ អន់តគ់ ផូង័ វ៉ាច់ អីស អន់ឌែ ចឹង ឡាំ អ្វៃ ប៉ាគ់ ប៉ាថេត អន់ទៀគ ឡាក់ អូ ត្រគ់ ប៉ាថេត អន់ឌែ តាំងឡា។ អន់ឌែ ចឹង កេះ ទុច ពូ ប៉ាសុន ពឹង ប៉ាថេត ណោះ ចឹង ជិះ ចគ័ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ប៉ាគ់ ទឹល ៤០០ សាណាំ កេះ អាញ់ ចឹង ចៃគ ថូត ពូ បក់ អ្យក់ ផូង័ វ៉ាច់ អីស ប៉្រគ័ ទុច។ កេះណោះ ផូង័ វ៉ាច់ អីស អន់ឌែ ចឹង ឡាច់ ឡឹង ប៉ាថេត ពូ ណោះ លូ អ្យក់ សឹត ទឹប រ៉ាស អំប៉ាស តុត អៀង ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","កាប៉ាច់ អីស ចឹង ទី អាញុ រ៉ីស ទុញ អ្វៃ សាណុក សាវ៉ាក ទឹល តោ័ អ្វៃ អន់ឌូ លូ វគ័ យ៉ាគ់ អីស។ ");
INSERT INTO tpu_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","ប៉ាគ់ ទឹល រ៉ាំងហាវ ទី ប៉្វាន់ ទៀ ផូង័ វ៉ាច់ អីស អន់ឌែ ចឹង សឹត ប៉ាគ់ ប៉ាថេត អីស អ្វៃ អា ណាវ្គ ខង កិញអៀ អា សុនសាត អាម៉ូរី ប៉្រគ័ អ៊ក បើ តាន័ អៀង បើ ទឹល ដារ់ ចៃគ ថូត អន់ឌែ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","ប៉ាគ់ ទឹល ដារ់ ម៉ុត ប៉្លៃង ម៉ាំង កេះ ផាឌី វគ័ អាប់រ៉ាម ប៉ប័ កាណាគ័ ចៃគ ង៉ារ អុញ លូ អំប៉្យិត អុញ កាបង កីត ចាក ហះ អន់តិគ័ អ្យាំ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ដារ់ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ សាញ៉ា រែវ ពុត លូ វគ័ អាប់រ៉ាម ទឹប រ៉ះ ផា «អាញ់ ចឹង មប ប៉ាថេត អា អន់ កា ផូង័ វ៉ាច់ អីស អ្យក់ ឡឹង ទៀក ទ្រូង ហះ គួយ ប៉ាថេត អ៊ីស៊ីប ទឹល ប៉ាគ់ តាំងលេ អឺប៉្រាត ");
INSERT INTO tpu_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ទឹប ស្រុក តេះ សុនសាត គែន សុនសាត កេនិស៊ីត សុនសាត កាត់ម៉ូនី ");
INSERT INTO tpu_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","លូ ស្រុក តេះ សុនសាត ហេត សុនសាត ពែរិស៊ីត សុនសាត រែផៃម ");
INSERT INTO tpu_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","លូ ស្រុក តេះ សុនសាត អាម៉ូរី សុនសាត កាណាន សុនសាត គើកាស៊ី លូ សុនសាត យេប៊ូស»។ ");
INSERT INTO tpu_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","សារ៉ាយ កាម៉ាញ់ អាប់រ៉ាម អ៊ែ អូ ទី គន អុះ ហះកា អ៊ែ ទី ទុច អង់កាន់ ម៉ោញ ដូវ សិច ហាការ សុនសាត អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","យ៉ាគ់ សារ៉ាយ រ៉ះ កា វគ័ អាប់រ៉ាម ផា «ហៃ ប‌៉្រ័ះ ប៊កកាតយ័ អូ អន់ អាញ់ ទី គន នីអៀ។ ទឹល នីណោ័ះ អីស ឡាំ តៃប លូ អង់កាន់ ទុច អាញ់ ណោះ ពិ អ្លុ ផៃគ អ៊ែ ចឹង ទី គន អាញ់ ចឹង អ្យក់ គន ណោះ ប៉្រគ័ គន អាញ់»។ វគ័ អាប់រ៉ាម កា ភម ពួយ កាម៉ាញ់ អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ឡៃង ឡឹង វគ័ អាប់រ៉ាម អ្វៃ កាណុង ប៉ាថេត កាណាន ទី អញ់ជឹត សាណាំ កេះ យ៉ាគ់ សារ៉ាយ ប៉្រើ វគ័ អាប់រ៉ាម អ្យក់ ទុច អ៊ែ ហាការ ប៉្រគ័ កាម៉ាញ់ ក្យង់។ ");
INSERT INTO tpu_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","វគ័ អាប់រ៉ាម កា ឡាំ តៃប លូ ហាការ តាទឹច ឡៃង ឡឹង ណោះ ហាការ កា គៀម ហង។ ហាការ អ្លុ អន់តគ់ កា ឡាកោ អ៊ែ គៀម កេះ កា ប៉ាំងខូយ លូ ម៉ៃគ តាំងឡា អ៊ែ យ៉ាគ់ សារ៉ាយ។ ");
INSERT INTO tpu_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","យ៉ាគ់ សារ៉ាយ កាប កា វគ័ អាប់រ៉ាម ផា «ញន អីស អា ហង បះ ហាការ ប៉្រគ័ បាប អាញ់។ ហៃ អាញ់ អន់ ហាការ ប៉្រគ័ កាម៉ាញ់ អីស ហះកា ឡឹង អ៊ែ ឡាកោ គៀម អ៊ែ ប៉ាំងខូយ កា អាញ់ កេះ។ អន់ ប‌៉្រ័ះ ប៊កកាតយ័ តាត់ស៊ិន សារ ពិន អា ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","កេះណោះ វគ័ អាប់រ៉ាម តើល យ៉ាគ់ សារ៉ាយ ផា «អង់កាន់ ទុច អីស ណោះ អ៊ែ អ្វៃ កាន់តេ័ះ អីស កេះ នីចម័ អីស ប៉ិច ប៉្រគ័ កា អ៊ែ ភឿ ចឹង ដាគ់ ណោះ អីស ប៉្រគ័ ពិ»។ យ៉ាគ់ សារ៉ាយ កា ប៉្រគ័ បាប ហាការ កាខាក់ ទឹល ហាការ សាតាក់ ឡាច់ ឡឹង អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ផះ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ប័ ហាការ អ្វៃ ពឹង ស៊្រែ តីស ក្យាម័ កល់ ទៀក រទ្រង ឡាំ ប៉ាគ់ ស៊្រែ តីស ស៊ុរ។ ");
INSERT INTO tpu_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ប‌៉្រ័ះ ប៊កកាតយ័ តាំបាង ឡាកោ ឡាក់ កា ប៉ាណូស អំប៉ញ់ ផា «ហាការ ទុច សារ៉ាយ អីស ពឹះ ឡឹង ចំ ? ប៉ាគ់ ចំ អីស ចឹង ឃឹត ឡាំ ណោះ ហះ ?» ហាការ តើល ផា «អាញ់ សាតាក់ ឡាច់ ឡឹង ម៉ៃគ តាំងឡា អាញ់ យ៉ាគ់ សារ៉ាយ»។ ");
INSERT INTO tpu_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","ប‌៉្រ័ះ ប៊កកាតយ័ ផា «ហាការ អីស វ៉ីល សឹត ប៉ាគ់ ម៉ៃគ តាំងឡា អីស ទៅ ពិ លូ អ្វៃ រ៉ាប់ សឿ អ៊ែ ណោះ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","អ៊ែ រ៉ះ កា ហាការ ណាវ្គ ផា «អាញ់ ចឹង ប៉្រគ័ អន់ ផូង័ វ៉ាច់ អីស កើត អៀង កាខាក់ អូ ទី ពឿ ដាម័ យ៉ាប អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","កិញអៀ អា អីស គៀម កេះ អីស ចឹង អ្វៃ ហាអុញ កើត គន កាម៉ាក័។ អីស ត្រគ់ អន់ សិច គន ណោះ ផា អ៊ីសាម៉ាអ៊ែល  ខង អាញ់ កាតាំង អីស អង់ហ្យាំង ផះ អីស ទី សារ ឡាំបាក ពែ។ ");
INSERT INTO tpu_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","គន ណោះ ពៀប ឡាក់ កា កាណាគ័ ព្រី។ តី អ៊ែ ចឹង ពីត ពូ វ៉ីវ៉ាច័ ពូ ចឹង ពីត អ៊ែ និះទៅ ដេល អ៊ែ ចឹង អូ ចៃ អ្វៃ អន់ឌូ លូ អុះ ម៉ី អ៊ែ»។ ");
INSERT INTO tpu_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ហាការ កា អន់ សិច ប‌៉្រ័ះ ឡាក់ កាកាប លូ អ៊ែ ណោះ ផា «ប‌៉្រ័ះ ហៃ អាញ់»។ អ៊ែ ផា «អាញ់ ប៉ប័ កេះ ប‌៉្រ័ះ ឡាក់ ហៃ អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ខ អា ហង បះ ពូ អន់ សិច កល់ ទៀក ណោះ ផា ទៀក ឡាហាយ រយ  កល់ ទៀក អា អ្វៃ ហះ អន់តិគ័ អំពុន ស្រុក កាដេះ លូ ស្រុក បិរ៉ិត។ ");
INSERT INTO tpu_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ហាការ កា ទី គន កាម៉ាក័ ម៉ោញ លូ វគ័ អាប់រ៉ាម វគ័ អាប់រ៉ាម អន់ សិច គន ណោះ ផា អ៊ីសាម៉ាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ផះ រ៉ាំងវ៉ាង ហាការ ទី គន លូ វគ័ អាប់រ៉ាម ណោះ អាប់រ៉ាម អាញុ អ៊ែ ៨៦ សាណាំ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ប៉ាគ់ វគ័ អាប់រ៉ាម អាញុ ៩៩ សាណាំ ប‌៉្រ័ះ ប៊កកាតយ័ តាំបាង ឡាកោ អន់ អ៊ែ ប៉ប័ លូ រ៉ះ កា អ៊ែ ផា «អាញ់ អា ហង ឡាក់ ប‌៉្រ័ះ ទី អំរ៉ាញ អឺញ ហ៊្លត ឡឹង ពូ។ អីស ត្រគ់ សឿ អាញ់ លូ ជែ ប៉្រគ័ សារ បឺគ អ៊ក ");
INSERT INTO tpu_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","បះ អាញ់ ចឹង សាញ៉ា រែវ ពុត លូ អីស លូ ចឹង ប៉្រគ័ អន់ ផូង័ វ៉ាច់ អីស កើត រ៉ាល អៀង កាខាក់»។ ");
INSERT INTO tpu_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","កេះណោះ អាប់រ៉ាម ជន តាកុល មូប កល់ ទឹះ តេះ។ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ ផា ");
INSERT INTO tpu_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«ហៃ អាញ់ ចឹង សាញ៉ា រែវ ពុត លូ អីស នីអៀ ឃឺ អីស ចឹង ប៉្រគ័ វគ័ ពូ អៀង សុនសាត។ ");
INSERT INTO tpu_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ពូ អូ អើ ហង សិច អីស អាប់រ៉ាម ពូ ចឹង អើ ផា អាប៉្រាហាំ ឡគ ខង អាញ់ ចឹង អន់ អីស ប៉្រគ័ វគ័ ពូ អៀង សុនសាត។ ");
INSERT INTO tpu_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","អាញ់ ចឹង ប៉្រគ័ អន់ អីស ទី គន សោ អៀង កាខាក់ អាញ់ ចឹង ប៉្រគ័ អន់ ទី សុនសាត អៀង កើត ឡាច់ ឡឹង ផូង័ វ៉ាច់ អីស។ កាណុង ផូង័ វ៉ាច់ អីស ចឹង កើត សាដាច់ អៀង ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","អាញ់ ចឹង សាញ៉ា រែវ ពុត លូ អីស ទឹប ផូង័ វ៉ាច់ អីស ឡាក់ ចឹង កើត អន់តីគ ទៀ។ សារ សាញ៉ា រែវ ពុត អា ចឹង អ្វៃ លើយ គ្រឹប រ៉ាំងហាវ អាញ់ ចឹង ប៉្រគ័ ប‌៉្រ័ះ រ៉ាំងហៃ អីស លូ ប‌៉្រ័ះ រ៉ាំងហៃ ផូង័ វ៉ាច់ អីស អន់តីគ ទៀ និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","អាញ់ ចឹង មប ប៉ាថេត កាណាន អា អន់ កា អីស លូ ផូង័ វ៉ាច់ អីស លើយ។ កិញអៀ អីស អ្វៃ អង់រ៉ាម័ ទឹល រ៉ាំងហាវ អន់តីគ ផូង័ វ៉ាច់ អីស ចឹង ប៉្រគ័ តាំងឡា ប៉ាថេត អា លើយ។ អាញ់ ចឹង ប៉្រគ័ ប‌៉្រ័ះ រ៉ាំងហៃ អន់ឌែ»។ ");
INSERT INTO tpu_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ អាប៉្រាហាំ ណាវ្គ ផា «កាប៉ាច់ អីស ត្រគ់ ប៉្រគ័ ពួយ សារ អាញ់ សាញ៉ា រែវ ពុត លូ អីស អា លើយ ទឹល គន សោ អីស រ៉ាំងហាវ អន់តីគ ទៀ។ ");
INSERT INTO tpu_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","អន់ដីស ត្រគ់ ប៉្រគ័ ពួយ សារ អាញ់ សាញ៉ា រែវ ពុត លូ អន់ដីស លូ ផូង័ វ៉ាច់ អីស កើត រ៉ាំងហាវ អន់តីគ ទៀ មួត កាម៉ាក័ ទិឌូ កាណុង កាំឡាំង អីស ត្រគ់ កាសិត អង់ការ ម៉ូះ ឡោ។ ");
INSERT INTO tpu_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","អន់ដីស កាសិត អង់ការ ភឿ ប៉្រគ័ អន់ អន់ហ្នាល់ សារ អាញ់ សាញ៉ា រែវ ពុត លូ អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","ទិ គន កាម៉ាក័ កើត កាណុង ហី អីស ទី តាំងហាម ដារ់ កេះ គន អីស ទៅ កាតាម គន ទុច កាតាម ត្រគ់ កាសិត អង់ការ។ ទុច តាច់ ឡឹង សុនសាត អន់ទៀគ ត្រគ់ កាសិត អង់ការ និះទៅ ដេល។ ប៉្រគ័ នីអៀ លើយ គ្រឹប រ៉ាំងហាវ។ ");
INSERT INTO tpu_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","កាម៉ាក័ ទិឌូ យ‌៉័ះ គន កើត កាណុង ហី អីស កាតាម លើ ទុច តាច់ ឡឹង ពូ កាតាម ពូ ត្រគ់ កាសិត អង់ការ និះទៅ ដេល ម៉ាគ់ សារ អាញ់ សាញ៉ា រែវ ពុត ចឹង អ្វៃ ពឹង ឡាកោ អន់ដីស លើយ។ ");
INSERT INTO tpu_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ផា កាម៉ាក័ អ៊ែ ចំ អូ កាសិត អង់ការ អន់ដីស ត្រគ់ តាំងហ្យិត ឡាច់ ឡឹង កាំឡាំង អន់ដីស ខង អ៊ែ អូ ចៃ ប៉្រគ័ ពួយ សារ អាញ់ សាញ៉ា រែវ ពុត លូ អីស អា»។ ");
INSERT INTO tpu_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ អាប៉្រាហាំ ណាវ្គ ផា «កាប៉ាច់ សារ៉ាយ កាម៉ាញ់ អីស អូ ត្រគ់ អើ សិច អ៊ែ សារ៉ាយ ណាវ្គ អុះ ឃឺ ត្រគ់ អើ សិច ផា សារ៉ា ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","អាញ់ ចឹង អន់ សារ ដាគ់ កា អ៊ែ អាញ់ ចឹង អន់ អន់ដីស ទី គន ម៉ោញ អាញ់ ចឹង អន់ សារ ដាគ់ កា សារ៉ា តាទឹច អ៊ែ ចឹង ប៉្រគ័ យ៉ាគ់ ពូ អៀង សុនសាត។ កាណុង ផូង័ វ៉ាច់ អ៊ែ ចឹង កើត សាដាច់ អៀង ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","វគ័ អាប៉្រាហាំ ជន តាកុល មូប កល់ ទឹះ តេះ អ៊ែ កាកីក លូ កាគឹន កាណុង ពុត ផា «ប៉ាណូស ក្រាគ់ អាញុ ១០០ សាណាំ កេះ ឡាក់ កា អាញ់ អា អ្លុ ទី គន ដេល ប ? សារ៉ា កា អាញុ ៩០ សាណាំ កេះ ដេល អ៊ែ ចឹង អ្លុ អ្វៃ ហាអុញ ប ?» ");
INSERT INTO tpu_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","វគ័ អាប៉្រាហាំ ប៉រ់ ហះ ប‌៉្រ័ះ ប៊កកាតយ័ ផា «ប៉រ់ ដឹង អីស រ៉ាំងហៃ អ៊ីសាម៉ាអ៊ែល បគ័ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ អាប៉្រាហាំ ផា «អូ អុះ ! សារ៉ា កាម៉ាញ់ អីស ចឹង ទី គន កាម៉ាក័ ម៉ោញ លូ អីស តាទឹច។ អីស ត្រគ់ អន់ សិច គន ណោះ ផា អ៊ីសាក់។ អាញ់ ចឹង សាញ៉ា រែវ ពុត លូ អ៊ែ លើយ ទឹល គន សោ ផូង័ វ៉ាច់ អ៊ែ រ៉ាំងហាវ អន់តីគ។ ");
INSERT INTO tpu_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","កាប៉ាច់ អ៊ីសាម៉ាអ៊ែល ណោះ អាញ់ ភម ដេល ឡាក់ អីស ផា ណោះ។ ហៃ អាញ់ ចឹង អន់ សារ ដាគ់ កា អ៊ែ អាញ់ ចឹង ប៉្រគ័ អន់ អ៊ែ ទី គន អៀង។ ផូង័ វ៉ាច់ អ៊ែ កា ចឹង កើត អៀង កាខាក់។ អ៊ែ ចឹង ទី គន ១២ ដូវ អន់ឌែ ចឹង ប៉្រគ័ ក្រាគ់ ស្រុក ក្រាគ់ មឿង។ អាញ់ ចឹង ប៉្រគ័ អន់ ទី សុនសាត ម៉ោញ ឡាក់ អៀង កាខាក់ កើត ឡាច់ ឡឹង អ៊ែ និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ហះកា អាញ់ ចឹង សាញ៉ា រែវ ពុត លូ អ៊ីសាក់ ឡាក់ គន សារ៉ា ចឹង ទី លូ អីស កាណុង ខៃ អា សាណាំ អន់តីគ ទៀ»។ ");
INSERT INTO tpu_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ឡៃង ឡឹង ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ សារ កេះ ទិ កេះ អ៊ែ ចាក ឡាច់ ឡឹង វគ័ អាប៉្រាហាំ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ដារ់ ណោះ ទៅ ហង វគ័ អាប៉្រាហាំ ប៉ាណាំ គន អ៊ែ អ៊ីសាម៉ាអ៊ែល លូ មួត បក់ កើត ពឹង ហី អ៊ែ ទឹប មួត ទុច អ៊ែ។ ទិ មួត កាម៉ាក័ បក់ អ្វៃ អន់ឌូ លូ អ៊ែ កា ពឹះ កាសិត អង់ការ ទិឌូ ដេល អន់ ត្រគ់ ពួយ ប៉ានឹរ ប‌៉្រ័ះ រ៉ះ កា អ៊ែ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ផះ រ៉ាំងវ៉ាង វគ័ អាប៉្រាហាំ កាសិត អង់ការ ណោះ អ៊ែ អាញុ ៩៩ សាណាំ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ផះ គន អ៊ែ អ៊ីសាម៉ាអ៊ែល កាសិត អង់ការ ណោះ អ៊ែ ទី អាញុ ១៣ សាណាំ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","វគ័ អាប៉្រាហាំ លូ គន អ៊ែ អ៊ីសាម៉ាអ៊ែល អន់ឌែ កាសិត អង់ការ ម៉ោញ ដារ់ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ទិ មួត កាម៉ាក័ បក់ អ្វៃ ពឹង ហី អ៊ែ យ‌៉័ះ គន កើត កាណុង ហី កាតាម លើ ទុច តាច់ ឡឹង សុនសាត អន់ទៀគ កាតាម កា កាសិត អង់ការ ឡាក់ កា អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","អន់តីគ ឡឹង ណោះ ផះ ដារ់ ប៉ង់ ប៉្លៃង តុ កាខាក់ វគ័ អាប៉្រាហាំ អ៊ែ អ្វៃ ហះ អំប៉ារ រ៉ាណើះ ហះ សានែង តើម ជ្រី វគ័ ម៉ាមរេ។ ផះ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កា តាំបាង ឡាកោ អន់ អ៊ែ ប៉ប័។ ");
INSERT INTO tpu_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","អ៊ែ ហៃ ប៉ប័ កាម៉ាក័ ប៉ៃង ដូវ អន់តាវ ប៉ាគ់ ម៉ាត់។ អ៊ែ កា ឡាច់ ឡឹង អំប៉ារ រ៉ាណើះ តាយ៉ិប ឡាំ ហាប់ លូ ជន តាកុល មូប កល់ ទឹះ តេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","កេះណោះ អ៊ែ ផា «អឺ ពឹ តាំងឡា ផា អីស ប៉ិច ចៃ កា អាញ់ អីស ជែ ចាក ទ្រួង អាញ់ អា យ‌៉័ះ អាញ់ ប៉ាណូស អូ គឹត អូ ខា ប៉រ់ អីស អ្វៃ រ៉ាឡូវ ហះ អា ហិ។ ");
INSERT INTO tpu_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","កូម័ អន់ ពូ អ្យក់ ទៀក រ៉ាវ ជុង ហិ ប៉រ់ អន់ដីស អ្វៃ រ៉ាឡូវ ហះ កានឺប អ៊្លង អា ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ញន កា អន់ដីស ពឹះ ទឹល ប៉ាគ់ ចារ អាញ់ កេះ កូម័ អាញ់ ចឹង អ្យក់ សាណា បាប៊ត បាប៊ែត អន់ កា អន់ដីស សា ហិ ម៉ាគ់ អន់ដីស ទី សាងុំ ចាក ណាវ្គ»។ អន់ឌែ តើល ផា «អឺះ ប៉្រគ័ ឡាក់ កា អីស ផា ណោះ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","វគ័ អាប៉្រាហាំ ប៉ាន់តាន ម៉ុត កាណុង រ៉ាណើះ រ៉ះ លូ កាម៉ាញ់ អ៊ែ យ៉ាគ់ សារ៉ា ផា «អីស អ្យក់ តាប៉ុង ដាគ់ ប៉ៃង កាអ្លី ប៉្រគ័ ណុំ ប៉ាំង អន់ ស៊្រសៗ ប៊ែត ហោគ»។ ");
INSERT INTO tpu_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","កេះណោះ វគ័ អាប៉្រាហាំ សាតាក់ ឡាំ ប៉ាគ់ ចារ រ៉ក់ អ្យក់ គន រ៉ក់ ម៉ោញ កាតុ ដាគ់ តីស តង់ អន់ កា ទុច ពុះ ប៉្រគ័ សាអ៊្លង ស៊្រសៗ។ ");
INSERT INTO tpu_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","វគ័ អាប៉្រាហាំ អ្យក់ ទៀក តុះ រ៉ក់ អន់ កា អន់ឌែ អៃត លូ ទៀក តុះ រ៉ក់ អ្យូគ សា អន់ឌូ លូ សាអ៊្លង ពូ ប៉្រគ័ ណោះ។ អ៊ែ តាំងឡា អ្វៃ អន់តាវ អង់រ៉ើង ហះ តើម អ៊្លង ហៃ អន់ឌែ សា។ ");
INSERT INTO tpu_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","កេះណោះ អន់ឌែ អំប៉ញ់ វគ័ អាប៉្រាហាំ ផា «ប៉ាគ់ ចំ កាម៉ាញ់ អីស សារ៉ា អ៊ែ អ្វៃ ?» វគ័ អាប៉្រាហាំ តើល ផា «អ៊ែ អ្វៃ កាណុង រ៉ាណើះ ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","អំហ៊្មយ ម៉ោញ ដូវ រ៉ះ ផា «សាណាំ អន់តីគ ខៃ អា ទៅ អាញ់ ចឹង ឡាំ ប៉ាគ់ ចារ អីស អា ណាវ្គ ផះ ណោះ សារ៉ា ចឹង ទី គន កាម៉ាក័ ម៉ោញ ហង»។ យ៉ាគ់ សារ៉ា អ្វៃ សាំយ៉ាំង គែង អង់កក់ អន់ឌែ ហះ អំប៉ារ។ ");
INSERT INTO tpu_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","វគ័ អាប៉្រាហាំ លូ យ៉ាគ់ សារ៉ា អន់ឌែ ក្រាគ់ ខាក់ កេះ យ៉ាគ់ សារ៉ា កាយ អាញុ ទី គន កេះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ណោះ ហង បះ យ៉ាគ់ សារ៉ា អ៊ែ កាកីក កាប កាណុង ពុត ផា «អាញ់ ក្រាគ់ ប៉ុប អា កេះ អ្វៃ ទី គន ណាវ្គ ប ? ក្លោ អាញ់ កា ក្រាគ់ ខាក់ កេះ ដេល អា»។ ");
INSERT INTO tpu_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","ប‌៉្រ័ះ ប៊កកាតយ័ អំប៉ញ់ វគ័ អាប៉្រាហាំ ផា «ញ៉ា ត្រគ់ សារ៉ា កាកីក នីណោ័ះ លូ ផា \"អាញ់ ក្រាគ់ ប៉ុប អា កេះ នីចម័ ចឹង អ្លុ ទី គន ?\" ");
INSERT INTO tpu_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","អូ ទី ង៉ារ ញ៉ា អាញ់ ចឹង អូ អ្លុ ប៉្រគ័ អុះ គ្រឹប ង៉ារ អាញ់ អ្លុ ប៉្រគ័ ទិ។ ប៉ាគ់ ទឹល ដារ់ កាំឡត់ សាណាំ អន់តីគ ខៃ អា ទៅ អាញ់ ចឹង ឡាំ ប៉ាគ់ អា ណាវ្គ សារ៉ា ចឹង ទី គន កាម៉ាក័ ម៉ោញ តាទឹច ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","យ៉ាគ់ សារ៉ា តើល ផា «ចំ ទី អាញ់ កាកីក ? អូ ទី កាកីក អុះ»។ អ៊ែ ផា នីណោ័ះ ញន កា អ៊ែ អ្យូគ យ៉ឹប ហះកា ប‌៉្រ័ះ តើល អ៊ែ ផា «អីស កាកីក តាទឹច»។ ");
INSERT INTO tpu_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","កេះណោះ កាម៉ាក័ ប៉ៃង ដូវ អន់ឌែ អ្យូវ ចាក ឡាច់ ឡឹង ចារ ណោះ លូ ហៃ ជឹរ គែង មឿង សូដុំ។ វគ័ អាប៉្រាហាំ កា ចាក ពួយ អន់ឌូ ដេល ភឿ ជឹន អន់ឌែ ចាក។ ");
INSERT INTO tpu_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ប‌៉្រ័ះ ប៊កកាតយ័ កាប កាណុង ពុត ផា «នីចម័ អាញ់ ចឹង អោន អូ អន់ អាប៉្រាហាំ អ្លុ ប ង៉ារ អាញ់ ចឹង ប៉្រគ័ អា ? ");
INSERT INTO tpu_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","អាប៉្រាហាំ ចឹង ទី គន សោ អៀង កាខាក់ ម៉ោញ សុនសាត ឡាក់ អំរ៉ាញ កេង ទិ សុនសាត អ្វៃ ពឹង អង់កក់ តេះ អា ចឹង ទី សារ ដាគ់ ញន អ៊ែ ហង ");
INSERT INTO tpu_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","ខង អាញ់ រ៉ើស អ្យក់ អ៊ែ ភឿ អន់តគ់ ប៉ាតោ កា គន សោ រ៉ាំងហាវ អន់តីគ អន់ អន់ឌែ សឿ អាញ់ ទឹប អ្វៃ ដាគ់ ត្រង់ លូ តាត់ស៊ិន សារ អន់ ត្រង់។ ទឹល នីណោ័ះ អាញ់ ចឹង អន់ កា អាប៉្រាហាំ ពួយ សារ អាញ់ សាញ៉ា»។ ");
INSERT INTO tpu_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ អាប៉្រាហាំ ផា «អាញ់ កាតាំង លៅ សារ ពូ ច្រោម មឿង សូដុំ លូ កូម៉ូរ៉ា ណោះ យ៉ឹប ខាក់ លូ ប៉ាណូស អ្វៃ ពឹង មឿង ណោះ ប៉្រគ័ យច អៀង កាខាក់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ណោះ ហង បះ អាញ់ ជឹរ ហៃ អា ខង អាញ់ ប៉ិច អ្លុ អន់តគ់ ផា សារ អន់ឌែ ប៉្រគ័ អូ ដាគ់ ណោះ ត្រគ់ ឡាក់ កា អាញ់ កាតាំង លៅ តាទឹច ប ? ផា តាទឹច លើ អូ តាទឹច អាញ់ ចឹង ប៉ប័ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","កេះណោះ កាម៉ាក័ ពៀរ ដូវ អន់ឌែ ចាក អន់ គែង មឿង សូដុំ ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ លូ វគ័ អាប៉្រាហាំ ហះ ណោះ ទៅ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","វគ័ អាប៉្រាហាំ ឡាំ អ្វៃ ក្យាម័ អ៊ែ លូ អំប៉ញ់ ផា «អីស ចឹង ថាំឡាយ ប៉ាណូស ដាគ់ ត្រង់ អន់ឌូ លូ ប៉ាណូស អូ ដាគ់ ដេល ប ? ");
INSERT INTO tpu_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","កាណុង មឿង ណោះ ផា ទី ប៉ាណូស ដាគ់ ត្រង់ ៥០ ដូវ នីចម័ អីស ចឹង ថាំឡាយ មឿង ណោះ ដេល ប ? អីស អូ តាប៉ាប ប ញន កា ប៉ាណូស ដាគ់ ៥០ ដូវ អ្វៃ កាណុង មឿង ណោះ ? ");
INSERT INTO tpu_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ផា អីស ប៉្រគ័ នីណោ័ះ អូ ដាគ់ អុះ ប៉រ់ អីស ជែ ប៉ាន់តោ័ ប៉ាណូស ដាគ់ ត្រង់ អន់ឌូ លូ ប៉ាណូស អូ ដាគ់ ណោះ។ ផា ប៉្រគ័ នីណោ័ះ ប៉ាណូស ដាគ់ លូ ប៉ាណូស អូ ដាគ់ ចឹង ទី សារ និះទៅ ហង។ ផា អីស ប៉្រគ័ នីណោ័ះ អូ ត្រគ់ អុះ អីស ឡាក់ ប‌៉្រ័ះ កាប សារ ទឹប អង់កក់ តេះ អីស ត្រគ់ កាប សារ អា អន់ ត្រគ់ តាទឹច»។ ");
INSERT INTO tpu_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ប‌៉្រ័ះ ប៊កកាតយ័ កា តើល ផា «ផា អាញ់ ប៉ប័ ទី ប៉ាណូស ដាគ់ ត្រង់ ៥០ ដូវ កាណុង មឿង សូដុំ ណោះ អាញ់ ចឹង តាប៉ាប ទឹប មឿង ណោះ ញន កា អន់ឌែ»។ ");
INSERT INTO tpu_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","កេះណោះ វគ័ អាប៉្រាហាំ កាប ណាវ្គ «ប៉រ់ អីស ជែ អ្យក់ យ៉ូ អាញ់ ខង អាញ់ ប៉ាណូស អូ តាឡា អូ តាឡយ ខឹន ប៉ាគែក លូ អីស នីអៀ។ ");
INSERT INTO tpu_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","កាណុង មឿង ណោះ ផា ទី ប៉ាណូស ដាគ់ ត្រង់ ដឹង ៤៥ ដូវ អូ ទឹល ៥០ ដូវ អីស ចឹង ថាំឡាយ ដេល ប ?» ប‌៉្រ័ះ ប៊កកាតយ័ ផា «ផា អាញ់ ប៉ប័ ទី ប៉ាណូស ដាគ់ ត្រង់ ៤៥ ដូវ អ្វៃ ពឹង មឿង ណោះ អាញ់ អូ ថាំឡាយ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","កេះណោះ វគ័ អាប៉្រាហាំ អំប៉ញ់ ណាវ្គ «ផា ទី ប៉ាណូស ដាគ់ ត្រង់ ដឹង ៤០ ដូវ អ្វៃ ពឹង មឿង ណោះ នីចម័ អីស ចឹង ថាំឡាយ ដេល ប ?» ប‌៉្រ័ះ ប៊កកាតយ័ តើល ផា «ផា ទី ប៉ាណូស ដាគ់ ត្រង់ ៤០ ដូវ អាញ់ អូ ថាំឡាយ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","វគ័ អាប៉្រាហាំ កាប ផា «អាញ់ ប៉រ់ ឡោម ឡា អីស ជែ អឺក កា អាញ់ ឃឺ អ៊ែ កាណុង មឿង ណោះ ទី ប៉ាណូស ដាគ់ ត្រង់ ដឹង ៣០ ដូវ តាម ហៃ»។ ប‌៉្រ័ះ ផា «ផា ទី ប៉ាណូស ដាគ់ ត្រង់ ដឹង ៣០ ដូវ កា អាញ់ អូ ថាំឡាយ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","កេះណោះ វគ័ អាប៉្រាហាំ ផា ណាវ្គ «ប‌៉្រ័ះ ប៊កកាតយ័ ជែ អ្យក់ យ៉ូ អាញ់ ខង អាញ់ ខឹន ប៉ាគែក លូ អីស។ កាណុង មឿង ណោះ ឃឺ អ៊ែ ចឹង ទី ប៉ាណូស ដាគ់ ត្រង់ ដឹង ២០ ដូវ តាម ហៃ»។ ប‌៉្រ័ះ ប៊កកាតយ័ តើល ផា «ផា ទី ប៉ាណូស ដាគ់ ត្រង់ ដឹង ២០ ដូវ កា អាញ់ អូ ថាំឡាយ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","វគ័ អាប៉្រាហាំ ផា ណាវ្គ «ប៉រ់ អីស ជែ អឺក កា អាញ់ អាញ់ ប៉រ់ ឡោម ឡា អីស ម៉ោញ ទង ណាវ្គ។ ពឹង មឿង ណោះ ឃឺ អ៊ែ ទី ប៉ាណូស ដាគ់ ត្រង់ ដឹង ១០ ដូវ តាម ហៃ ?» ប‌៉្រ័ះ ប៊កកាតយ័ ផា «ផា ទី ដឹង ១០ ដូវ កា អាញ់ អូ ថាំឡាយ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ប‌៉្រ័ះ ប៊កកាតយ័ កាកាប លូ វគ័ អាប៉្រាហាំ កេះ ទិ កេះ ចាក ឡាច់ កា អ៊ែ ហង។ វគ័ អាប៉្រាហាំ កា វ៉ីល សឹត ប៉ាគ់ រ៉ាណើះ អ៊ែ ទៅ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ប៉ាគ់ កាង៉ាច ប៊យ ប‌៉្រ័ះ ពៀរ ដូវ ណោះ ឡាំ ទឹល មឿង សូដុំ ត្រគ់ ផះ ឡត អ្វៃ ហះ អំប៉ារ ទ្រួក មឿង ចារ ពូ លួម។ សាគ់ អ៊ែ ប៉ប័ ប៊យ ប‌៉្រ័ះ អ៊ែ តាយ៉ិប ឡាំ ហាប់ លូ ជន តាកុល មូប កល់ ទឹះ តេះ ");
INSERT INTO tpu_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","លូ កាប ផា «ម៉ៃគ តាំងឡា ពឹ តាំងឡា ចុ អន់ដីស ម៉ុត រ៉ាឡូវ រ៉ាវ ជុង តៃប ពឹង ហី អាញ់ ម៉ោញ ម៉ាំង អា ហិ ប៉ាគ់ កាំលឺ តាយ៉ាង័ អន់ដីស ចាក ឡាំ ណាវ្គ»។ ប៊យ ប‌៉្រ័ះ តើល ផា «អូ អុះ ម៉ាំង អា ញឹន តៃប រតេះ រឡាន មឿង អា កា ដាគ់ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","ញន កា ឡត ឡោម ជៀក កាខាក់ ប៊យ ប‌៉្រ័ះ កា ម៉ុត ពឹង ហី អ៊ែ តាទឹច ហង។ អ៊ែ ប៉្រើ ពូ ប៉្រគ័ សាណា សាណឹត លូ ពុះ ណុំ ប៉ាំង ឡាតាំង អន់ កា អន់ឌែ សា។ ");
INSERT INTO tpu_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","អន់ឌែ បើ តាន័ តៃប អុះ ផាឌី កាម៉ាក័ អ្វៃ ពឹង មឿង សូដុំ ណោះ ទឹប ក្រាគ់ ទឹប សាស្វា ទិឌូ ប៉ាណាំ គួប វ៉ិង ជុំ ហី ឡត។ ");
INSERT INTO tpu_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","កេះណោះ អន់ឌែ អំប៉ញ់ ឡត ផា «ចំ មួត អំហ៊្មយ ម៉ុត អ្វៃ ពឹង ហី អីស ផះ កាង៉ាច ពែ ? អីស ប៉្រើ អន់ឌែ ឡាច់ ប៉ាគ់ អា ញឹន ចឹង ទម តៃប លូ អន់ឌែ»។ ");
INSERT INTO tpu_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ឡត កា ឡាច់ ឡឹង ហី កាត្រើគ អំប៉ារ ឡាំ ប៉ាគ់ ចារ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","កេះណោះ ឡត រ៉ះ ផា «អឺ អុះ ម៉ី អន់ដីស ជែ ប៉្រគ័ សារ អូ ដាគ់ នីអៀ។ ");
INSERT INTO tpu_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","អាញ់ ប៉រ់ ឡោម ឡា អន់ដីស ជែ ប៉្រគ័ កា កាម៉ាក័ ពៀរ ដូវ អា ខង អន់ឌែ អ្វៃ ពឹង ហី អាញ់។ ហៃ អាញ់ ទី គន អង់កាន់ ពៀរ ដូវ បើ ទី តៃប លូ កាម៉ាក័ ពឿ អុះ អាញ់ ចឹង ប៉្រើ អន់ឌែ ឡាច់ ប៉ាគ់ អា អន់ អន់ដីស តៃប តាម ពុត ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","ហះកា អន់ឌែ តើល ផា «អីស ឡាច់ ពិ»។ អន់ឌែ កាប លូ គួប អន់ឌែ ផា «ហៃ ឡត អា អ៊ែ អំហ៊្មយ ម៉ុត អ្វៃ ពឹង ស្រុក ពិន កិញអៀ អ៊ែ ប៉ិច ប៉្រគ័ ក្រាគ់ តាត់ស៊ិន សារ។ អឺ ផា នីណោ័ះ ញឹន ចឹង ប៉្រគ័ កា អីស អន់ ក្វា ឡឹង មួត ពៀរ ដូវ ណោះ ឡូត»។ អន់ឌែ តាឡក័ ឡត តុត ពុត កេះណោះ ម៉ុត ចឹង ត្រុត បើក អំប៉ារ ");
INSERT INTO tpu_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ហះកា ប៊យ ប‌៉្រ័ះ ទុង តី ឡត អ្យក់ ម៉ុត កាណុង ហី កេះណោះ កាត្រើគ អំប៉ារ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","កេះណោះ ប៊យ ប‌៉្រ័ះ តាគ់ ម៉ាម៉ាំង ម៉ាត់ មួត អ្វៃ ហះ អំប៉ារ ណោះ ទិឌូ ទឹប មួត តាតាម័ ទឹប មួត ក្រាគ់ តាំងកង់ អន់ឌែ រ៉ាប៉ត់ ណាំង ទ្រង ម៉ុត អូ ប៉ប័ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ប៊យ ប‌៉្រ័ះ អំប៉ញ់ ឡត ផា «ទី ពឿ អន់ដា ណាវ្គ អ្វៃ អន់ឌូ លូ អីស ? ផា អីស ទី អង់ ទី គន សោ លូ គួប អីស ពឿ អន់ដា អ្វៃ ពឹង មឿង អា អីស ប៉ាណាំ អន់ឌែ ឡាច់ ឡឹង មឿង អា ពិ។ ");
INSERT INTO tpu_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ ញឹន ជឹរ ថាំឡាយ មឿង អា ខង អ៊ែ កាតាំង សារ អូ ដាគ់ ម៉ះ ប៉ាណូស កាណុង មឿង អា អៀង ខាក់ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","កេះណោះ ឡត ឡាំ រ៉ះ លូ កាម៉ាក័ ឡាក់ ចឹង ទី គន អ៊ែ ណោះ ផា «អន់ដីស អ្យូវ ចាក ឡាច់ ឡឹង ចារ អា ពិ ខង ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ថាំឡាយ អ្លាត ហង មឿង អា»។ ហះកា អន់ឌែ អូ សឿ អុះ សាម៉គ័ កា ឡត កាប រ៉ល់ ដោច។ ");
INSERT INTO tpu_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ប៉ាគ់ តារ រ៉ីង សារ៉ីង ប៊យ ប‌៉្រ័ះ ប៉ាំងខំ ឡត ផា «អីស អ្យូវ ជៀក កាម៉ាញ់ លូ គន អីស ពៀរ ដូវ អា ចាក ឡាច់ ឡឹង ចារ អា ឡគ ម៉ាគ់ ដាគ់ អន់ដីស អូ តោ័ ប៉ាគ់ ញឹន ចឹង ថាំឡាយ មឿង អា»។ ");
INSERT INTO tpu_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ហះកា ឡត អ្វៃ ប៉ាំងក្រូ ប៉ាំងក្រាន់ ប៊យ ប‌៉្រ័ះ រ៉ុប តី អ៊ែ លូ តី កាម៉ាញ់ តី គន អង់កាន់ ពៀរ ដូវ ទុង ឡាច់ អ្លាត គែង ឡីង មឿង ខង ប‌៉្រ័ះ ប៊កកាតយ័ តាប៉ាប កា ឡត ប៉ិច កា អ៊ែ អ្វៃ រ៉ីស។ ");
INSERT INTO tpu_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ប៉ាគ់ អន់ឌែ រ៉ាវ៉ាច់ គែង ឡីង មឿង កេះ ប៊យ ប‌៉្រ័ះ ផា «អន់ដីស សាតាក់ អន់ រ៉ាវ៉ាច់ ឡាកោ ជែ កាលែង ហៃ គែង ប៉ាអច់ លូ ជែ តាវ រ៉ាឡូវ រក្លូះ ប៉ានឹម អា។ សាតាក់ ឡាំ អ្វៃ ប៉ាគ់ ប៉ានឹម តោ ម៉ាគ់ រ៉ាវ៉ាច់ ឡាកោ»។ ");
INSERT INTO tpu_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","ហះកា ឡត តើល ប៊យ ប‌៉្រ័ះ ផា «អឺ ពឹ តាំងឡា ប៉រ់ អីស សាំយ៉ាំង ប៉ានឹរ អាញ់ ហិ។ ");
INSERT INTO tpu_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ហៃ កិញអៀ អីស តង័ អាញ់ អៀង កាខាក់ កេះ យ‌៉័ះ អាញ់ ប៉ាណូស អូ គឹត អូ ខា ញន កា អីស តាប៉ាប តាប៉ុន អន់ អាញ់ អ្វៃ រ៉ីស ហះកា អាញ់ សាតាក់ ឡាំ ប៉ាគ់ ប៉ានឹម តោ អូ តាន័ អុះ។ សារ អន់ដីស ចឹង ប៉្រគ័ អា ចឹង តាន័ អាញ់ ប៉្រគ័ អន់ អាញ់ តោ័ តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ហៃ តោ ទី ស្រុក ថិ ម៉ោញ ក្យាម័ រអា។ អន់ អាញ់ សាតាក់ ម៉ុត អ្វៃ ពឹង ស្រុក ណោះ ពិ ម៉ាគ់ ចឹង រ៉ាវ៉ាច់ ឡាកោ ដាគ់ អូ តោ័។ ជែ ថាំឡាយ ស្រុក ណោះ ខង អ៊ែ ថិ»។ ");
INSERT INTO tpu_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ប៊យ ប‌៉្រ័ះ តើល ផា «កិញអៀ អាញ់ ប៉្រគ័ ពួយ ប៉ានឹរ អីស ម៉ោញ ទង ណាវ្គ កាតាម ស្រុក អីស ផា ណោះ អាញ់ អូ ថាំឡាយ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ហគ់ សាតាក់ ឡាំ អ្វៃ ប៉ាគ់ ស្រុក ណោះ ប៉្រាល់ៗ ពិ។ ផះ អីស បើ ទឹល ប៉ាគ់ ណោះ អាញ់ អូ ប៉្រគ័ ញ៉ា អុះ»។ ណោះ ហង បះ ពូ អន់ សិច ស្រុក ណោះ សូអា ។ ");
INSERT INTO tpu_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","ប៉ាគ់ ឡត ឡាំ ទឹល ម៉ុត ស្រុក សូអា ដារ់ ឡាច់ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាឡិ ជឹរ អុញ ចាយ ណាយ កាទីរ ឡឹង ប៉្លៃង អន់ សា មឿង សូដុំ លូ មឿង កូម៉ូរ៉ា ទិ ប៉្យើះ។ ");
INSERT INTO tpu_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","អ៊ែ ថាំឡាយ មឿង ទិ ពៀរ ណោះ ទឹប ប៉ាណូស អ្វៃ ពឹង មឿង ណោះ។ កាណាគ័ ហ៊ន ពឹង ក្លូះ ប៉ានឹម ណោះ កា ត្រគ់ អុញ សា ទិ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","កាប៉ាច់ កាម៉ាញ់ ឡត អ៊ែ កាលែង ហៃ គែង អង់កក់ កា កេះ អំហ្មោ ប៉ោ័ះ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","វគ័ អាប៉្រាហាំ ទ្រង អា អ្យូវ ឡឹង តៃប កាំលឺ ផុងម៉ាំង ឡាំ ប៉ាគ់ ចារ អ៊ែ អ្វៃ រ៉ះ សារ លូ ប‌៉្រ័ះ ប៊កកាតយ័ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","អ៊ែ ហៃ ជឹរ គែង មឿង សូដុំ លូ មឿង កូម៉ូរ៉ា ទឹប ព្រី ស៊្រែ រក្លូះ ប៉ានឹម ណោះ អ៊ែ ប៉ប័ អ្យី អុញ ឡាច់ ឡឹង តេះ ចុកៗ ឡាក់ កា ពូ សុះ ម៉ីរ។ ");
INSERT INTO tpu_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ផះ ប‌៉្រ័ះ ប៊កកាតយ័ ថាំឡាយ មឿង ពឹង ក្លូះ ប៉ានឹម ណោះ អ៊ែ កាចាំង កា វគ័ អាប៉្រាហាំ ណោះ ហង បះ អ៊ែ ប៉្រើ ឡត ឡាច់ អន់ រ៉ាវ៉ាច់ ឡឹង កាន ចុនចៃ អន់ទ្រួល អ៊ែ ចឹង ថាំឡាយ មឿង ណោះ។ … ");
INSERT INTO tpu_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ យ៉ាគ់ សារ៉ា ទី គន ឡាក់ កា អ៊ែ រ៉ះ សាញ៉ា លូ អន់ឌែ ផះ អន់ទ្រួល ពែ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","យ៉ាគ់ សារ៉ា ឡាកោ គៀម លូ អ្វៃ ហាអុញ ត្រគ់ ពឹង ខៃ ប‌៉្រ័ះ កាំឡត់ ពែ ហង សារ៉ា លូ អាប៉្រាហាំ ទី គន កាម៉ាក័ ម៉ោញ ប៉ាគ់ អន់ឌែ ក្រាគ់ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","វគ័ អាប៉្រាហាំ អ៊ែ អន់ សិច គន អន់ឌែ ណោះ ផា អ៊ីសាក់ ។ ");
INSERT INTO tpu_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","អ៊ីសាក់ កើត ទី តាំងហាម ដារ់ កេះ វគ័ អាប៉្រាហាំ កាសិត អង់ការ គន អ៊ែ ណោះ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ ពែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ផះ អ៊ីសាក់ កើត ណោះ វគ័ អាប៉្រាហាំ អាញុ ១០០ សាណាំ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","យ៉ាគ់ សារ៉ា កាប ផា «ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ អាញ់ កាកីក ហោក រ៉គ់ ផា ពូ អ្លុ អន់តគ់ កា អាញ់ ទី គន ពូ ចឹង កាកីក ឡាក់ កា អាញ់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ផះ អន់ទ្រួល ពែ អូ ទី ពឿ អ្លុ រ៉ះ កា អាប៉្រាហាំ ផា \"ទី ដារ់ ម៉ោញ សារ៉ា ចឹង តាម៉ម់ គន អុះ\" ហះកា កិញអៀ អា អាញ់ ទី គន ប៉ាគ់ ញឹន ក្រាគ់ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ប៉ាគ់ អ៊ីសាក់ តីស បគ័ អ្លាត ម៉ម់ កេះ វគ័ អាប៉្រាហាំ ទ្រៀម អៃត សា តុត កានឹត កានោរ កាខាក់ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ផះ ណោះ យ៉ាគ់ សារ៉ា អ៊ែ ប៉ប័ គន ហាការ ឡាក់ សុនសាត អ៊ីស៊ីប ទី លូ វគ័ អាប៉្រាហាំ ណោះ ផះ អ្វៃ កាកីក រ៉ល់។ ");
INSERT INTO tpu_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","កេះណោះ អ៊ែ រ៉ះ លូ វគ័ អាប៉្រាហាំ ផា «អីស តាំងហ្យិត ឡាច់ អង់កាន់ ទុច អា លូ គន អ៊ែ ណោះ ពិ ជែ អន់ គន ទុច អា អ្យក់ ប៉ាដក់ ប៉ាជៀ អន់ឌូ លូ គន អាញ់ អ៊ីសាក់»។ ");
INSERT INTO tpu_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","សារ អា ប៉្រគ័ អន់ កា វគ័ អាប៉្រាហាំ អុក ពុត ពៀក ខាក់ ខង អ៊ីសាម៉ាអ៊ែល ណោះ កា គន អ៊ែ និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ អាប៉្រាហាំ ផា «ជែ អុក ពុត ពៀក ញន កា សាស្វា លូ អង់កាន់ ទុច អីស ណោះ អីស ត្រគ់ ប៉្រគ័ ពួយ គ្រឹប សារ សារ៉ា រ៉ះ កា អីស ណោះ ពិ ខង ទី ដឹង គន សោ អ៊ីសាក់ អាញ់ ចឹង សាញ៉ា រែវ ពុត។ ");
INSERT INTO tpu_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","កាប៉ាច់ គន ទុច អីស ណោះ អាញ់ ចឹង ប៉្រគ័ អន់ គន សោ អ៊ែ កើត ប៉ាថេត ម៉ោញ ខង អ៊ែ គន អីស និះទៅ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ប៉ាគ់ តាយ៉ាង័ វគ័ អាប៉្រាហាំ អ្យូវ ឡឹង កាំលឺ ផុងម៉ាំង អ្យក់ សាណា សាណឹត លូ ស្រោ អង់ការ ចៃគ ទៀក ប៉ាញ័ អន់ ហាការ គ្វី កេះណោះ ជឹន ហាការ លូ គន អ៊ែ ចាក។ ហាការ កា ចាក ឡាំ អ្វៃ វ៉ីវ៉ាច័ ពឹង ស៊្រែ តីស ក្យាម័ ស្រុក បៀសេបា។ ");
INSERT INTO tpu_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","ប៉ាគ់ ទិ ទៀក ឡឹង ស្រោ អង់ការ ណោះ កេះ ហាការ អ្លាត គន អ៊ែ ហះ កានឺប តើម អ៊្លង ថិ។ ");
INSERT INTO tpu_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","កេះណោះ អ៊ែ ឡាំ អង់អ្វៃ ប៉ាគ់ ចាំងហាយ្គ ខា ទិ សាងុំ កាំ ស្រាគ់ ឡិ ខង អ៊ែ ឃឹត ផា «អាញ់ អូ ប៉ិច ប៉ប័ គន អាញ់ តោ័ ហះ ម៉ាត់ អាញ់ អុះ»។ ទឹល នីណោ័ះ អ៊ែ អ្វៃ ញ៉ាំ អង់ហ្យាំង ដឹង អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ប‌៉្រ័ះ ប៊កកាតយ័ កាតាំង ប៉ានឹរ គន ហាការ អង់ហ្យាំង ញ៉ាំ ដេល អ៊ែ អើ ឡឹង ប៉្លៃង អំប៉ញ់ ហាការ ផា «អឺ ហាការ អីស ទី សារ ញ៉ា ? អីស ជែ អ្យូគ អាញ់ កាតាំង កេះ គន អីស អង់ហ្យាំង ញ៉ាំ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","អ្យូវ ឡាំ ប៉ោក ប៉ាឡោម គន អីស ណោះ ពិ ខង អាញ់ ចឹង ប៉្រគ័ អន់ គន សោ អ៊ែ កើត ម៉ោញ ប៉ាថេត តីស»។ ");
INSERT INTO tpu_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ ហាការ ប៉ប័ ទៀក អន់ដូង័។ ហាការ កា អោះ ទៀក ប៉ាញ័ ស្រោ អង់ការ ឡាំ ជឹន អន់ កា គន អ៊ែ អៃត។ ");
INSERT INTO tpu_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ាំងហៃ រ៉ាំងខ្យា គន ហាការ ណោះ។ អ៊ែ អ្វៃ ពឹង ស៊្រែ តីស ណោះ ទឹល អ៊ែ តីស អ៊ែ កើត ប៉ាណូស ផាន អ្លុ ប៉ាញ់ អ្យាំ។ ");
INSERT INTO tpu_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","អ៊ីសាម៉ាអ៊ែល អ្វៃ ពឹង ស៊្រែ តីស ព្រី ប៉ារ៉ាន។ មើគ អ៊ែ ឡាំ ណាំង អង់កាន់ សុនសាត អ៊ីស៊ីប ម៉ោញ ដូវ អន់ កា អ៊ែ ទី។ … ");
INSERT INTO tpu_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","អន់តីគ ឡឹង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ សាគ់ ពុត វគ័ អាប៉្រាហាំ។ ប‌៉្រ័ះ អើ អ៊ែ ផា «អឺ អាប៉្រាហាំ»។ អ៊ែ តើល ផា «ញ៉ា ប‌៉្រ័ះ ប៊កកាតយ័ ?» ");
INSERT INTO tpu_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","ប‌៉្រ័ះ រ៉ះ កា អ៊ែ ផា «អ្យក់ គន អីស អ៊ីសាក់ ឡាក់ គន អីស ប៉ិច ចៃ ដឹង ម៉ោញ ណោះ ជៀក អ៊ែ ឡាំ ប៉ាគ់ ស្រុក ម៉ូរីយ៉ា។ ទឹល ប៉ាគ់ ណោះ កេះ អីស ពុះ អ៊ែ រ៉ាម៉ះ អាញ់ ពឹង ប៉ានឹម អាញ់ ចឹង តាំបាង រ៉ះ កា អីស»។ ");
INSERT INTO tpu_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","វគ័ អាប៉្រាហាំ អ្យូវ ឡឹង កាំលឺ ផុងម៉ាំង រ៉ាន់ដាប់ ឃឿង ខង លូ ប៉ះ រ៉ាម៉េះ សាំរ៉ាប់ អ្យក់ ឡាំ ប៉ាកូះ កេះណោះ កត់ ប៉ាទុក ពឹង លៀ។ អ៊ែ ជៀក ទុច ពៀរ ដូវ លូ គន អ៊ែ អ៊ីសាក់។ ចាក ឡាំ កា អន់ឌែ ប៉ាគ់ ចារ ប‌៉្រ័ះ ប៉្រើ អ៊ែ ឡាំ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ប៉ាគ់ អន់ឌែ ចាក ទី ប៉ៃង ដារ់ កេះ វគ័ អាប៉្រាហាំ ហៃ ប៉ប័ ចារ ណោះ ឡឹង ចាំងហាយ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","វគ័ អាប៉្រាហាំ រ៉ះ កា ទុច អ៊ែ ពៀរ ដូវ ផា «អន់ដីស អ្វៃ ក្យាគ់ លៀ ហះ អា ហង ហោគ។ អាញ់ លូ អ៊ីសាក់ ញឹន ចឹង ហាវ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ពឹង ប៉ានឹម តោ កេះណោះ ញឹន ចឹង សឹត ប៉ាគ់ អា ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","វគ័ អាប៉្រាហាំ អ្យក់ រ៉ាម៉េះ អន់ កា អ៊ីសាក់ គយ កាប៉ាច់ អ៊ែ ចឹក អុញ លូ សាំង។ កេះណោះ ចាក ឡាំ កា អន់ឌែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","កេះណោះ អ៊ីសាក់ អើ ពឹ អ៊ែ ផា «ពឹ !» «ញ៉ា គន ?» អ៊ីសាក់ អំប៉ញ់ ផា «ពិន ទី អុញ ទី រ៉ាម៉េះ កេះ ចំ គន ចៀម ពិន ចឹង ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ ?» ");
INSERT INTO tpu_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","វគ័ អាប៉្រាហាំ តើល ផា «គន ចៀម ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ទៅ ចឹង អន់ កា ពិន»។ កេះណោះ ចាក ឡាំ កា អន់ឌែ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ប៉ាគ់ ទឹល ចារ ប‌៉្រ័ះ ប៊កកាតយ័ តាំបាង រ៉ះ កា អ៊ែ កេះ វគ័ អាប៉្រាហាំ កា ប៉្រគ័ ចារ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ លូ អ្យក់ រ៉ាម៉េះ តគ័ អំប៉ាំង កេះណោះ រ៉ុប អ៊ីសាក់ កត់ ជុង តី ចៃគ អំប៉ាំង រ៉ាម៉េះ ពឹង ចារ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","កេះណោះ វគ័ អាប៉្រាហាំ ដះ សាំង ចឹង ប៉ាន់តោ័ គន អ៊ែ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ ");
INSERT INTO tpu_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ អើ ឡឹង ប៉្លៃង ផា «អាប៉្រាហាំ អឺ អាប៉្រាហាំ !» អ៊ែ តើល ផា «ញ៉ា ប‌៉្រ័ះ ប៊កកាតយ័ ?» ");
INSERT INTO tpu_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","កេះណោះ ប‌៉្រ័ះ រ៉ះ កា អ៊ែ ផា «អីស ជែ ប៉ាន់តោ័ ហង គន អីស ណោះ អូ អន់ អីស ប៉្រគ័ នីចម័ កា អ៊ែ អុះ។ កិញអៀ អា អាញ់ អ្លុ កេះ កា អីស រ៉ាប់ សឿ អាញ់ តាទឹច យ‌៉័ះ គន អីស ប៉ិច ចៃ ដឹង ម៉ោញ ដូវ កា អីស អូ ខាត អូ តាមៀន អន់ កា អាញ់ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","វគ័ អាប៉្រាហាំ កាលែង ហៃ ប៉ប័ ចៀម ទោល ម៉ោញ ទួម អង់គែ ពឹង ប៉ោម សាលៀ អ៊ែ ឡាំ អ្យក់ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ តាង គន អ៊ែ ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","វគ័ អាប៉្រាហាំ អន់ សិច ចារ ណោះ ផា យ៉ះវេះ យិរ៉េះ ។ ណោះ ហង បះ រ៉ប់ ដារ់ អា ពូ ផា «ពឹង ប៉ានឹម ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ ចឹង មប អន់ កាណាគ័ ពិន តងកាន»។ ");
INSERT INTO tpu_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ អើ វគ័ អាប៉្រាហាំ ឡឹង ប៉្លៃង ណាវ្គ ផា ");
INSERT INTO tpu_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","«អាញ់ ប៉រ់ រ៉ះ កា អីស ខង អីស អូ ប៉ាគែក លូ អូ ខាត អូ តាមៀន អន់ គន អីស កា អាញ់ ទឹល នីណោ័ះ អាញ់ ចឹង អ្យក់ សិច អាញ់ ទៅ ម៉ត់ លូ អីស។ ");
INSERT INTO tpu_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","អាញ់ ចឹង អន់ សារ ដាគ់ កា អីស អៀង អាញ់ ចឹង ប៉្រគ័ អន់ ផូង័ វ៉ាច់ អីស កើត រ៉ាល អៀង ឡាក់ កា សំឡង់ ពឹង ប៉្លៃង លូ ឡាក់ កា តេះ ឡាពុក ពឹង ហាង សាឡីគ សាឡាយ។ មួត តាម៉ឺរ ចឹង អូ ដាម័ ផូង័ វ៉ាច់ អីស អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","គ្រឹប សុនសាត អ្វៃ ពឹង អង់កក់ តេះ ចឹង ប៉រ់ សារ ដាគ់ ឡឹង អាញ់ ឡាក់ កា អាញ់ ចឹង អន់ កា ផូង័ វ៉ាច់ អីស ខង អីស សឿ លូ ប៉្រគ័ ពួយ ប៉ានឹរ អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","កេះណោះ វគ័ អាប៉្រាហាំ សឹត ប៉ាគ់ ចារ ទុច អ៊ែ ណាវ្គ កេះណោះ ជៀក គួប សឹត ប៉ាគ់ ស្រុក បៀសេបា ទៅ។ វគ័ អាប៉្រាហាំ កា អ្វៃ ពឹង ស្រុក បៀសេបា ណោះ ហង។ … ");
INSERT INTO tpu_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","អា ហង សារ គន សោ អ៊ីសាក់ ឡាក់ គន វគ័ អាប៉្រាហាំ។ ");
INSERT INTO tpu_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ប៉ាគ់ អ៊ីសាក់ អាញុ ៤០ សាណាំ អ៊ែ ទី រេបិកា ប៉្រគ័ កាម៉ាញ់។ រេបិកា អុះ ឡាបាន់ គន បេធូអ៊ែល សុនសាត អារ៉ាម។ បេធូអ៊ែល អ្វៃ ប៉ាគ់ ប៉ាថេត អារ៉ាម ហះ តាវ៉ាង័ តាំងលេ ពៀរ ។ ");
INSERT INTO tpu_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","កាម៉ាញ់ អ៊ីសាក់ អ៊ែ អង់កាន់ អូ អ្លុ ទី គន។ អ៊ីសាក់ កា ម៉ន់ ឡោម ឡា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អន់ កាម៉ាញ់ ទី គន។ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ ឡាក់ កា អ៊ែ ប៉រ់ តាទឹច រេបិកា កា ឡាកោ គៀម ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","កាណុង វ៉ាច់ អ៊ែ ទី គន ពៀរ អន់ឌែ សាំប៉ត់ កាន់តើស គួប កាខាក់ ណោះ ហង បះ រេបិកា កាប ផា «កាណាគ័ ញ៉ា កើត កាណុង វ៉ាច់ អាញ់ អា ?» អ៊ែ កា អំប៉ញ់ លូ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ ផា «កាណុង វ៉ាច់ អីស ណោះ ទី ប៉ាថេត ពៀរ។ សុនសាត ពៀរ ចឹង កើត ឡាច់ ឡឹង អីស អន់ឌែ ចឹង កើត តាម៉ឺរ លូ គួប សោប។ សុនសាត ម៉ោញ ចឹង កេង ឡឹង សុនសាត ម៉ោញ ណាវ្គ គន ឡោងទ្រៀ ចឹង កេះ ទុច អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","ប៉ាគ់ គ្រឹប ខៃ អ្វៃ ហាអុញ អ៊ែ ទី គន ម៉ាត់ ប៉្វាន់ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","គន កើត អន់ទ្រួល អង់ការ អ៊ែ កាហ្រី ហ៊ន សក់ ប៉ាញ័ ឡាកោ ឡាក់ កា សក់ អ្យាំ អន់ឌែ អន់ សិច ផា អេសាវ ។ ");
INSERT INTO tpu_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","កេះណោះ អុះ អ៊ែ ឡាច់ ពួយ និះទៅ ដេល តី ក្វារ់ កាន់ទឺល ជុង ម៉ី អ៊ែ អន់ឌែ អន់ សិច ផា យ៉ាកុប ។ ផះ រេបិកា ទី គន ណោះ អ៊ីសាក់ អាញុ ៦០ សាណាំ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","គន ពៀរ ដូវ ណោះ ប៉ាគ់ អន់ឌែ តីស កេះ អេសាវ កើត ប៉ាណូស ផាន អ្វៃ ដឹង ពឹង ព្រី ណាំង ប៉ាញ់ អ្យាំ សៃម។ កាប៉ាច់ យ៉ាកុប អ្វៃ ដឹង ពឹង រ៉ាណើះ អូ សូវ កាកាប។ ");
INSERT INTO tpu_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","អ៊ីសាក់ ប៉ិច កា អេសាវ ខាក់ ខង អ៊ែ ប៉ិច សា អ្យាំ សៃម អេសាវ ប៉ាញ់ ណោះ។ កាប៉ាច់ រេបិកា ប៉ិច កា យ៉ាកុប។ ");
INSERT INTO tpu_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","អន់តីគ ឡឹង ណោះ យ៉ាកុប ផះ អ្វៃ ប៉្រគ័ សាអ៊្លង អេសាវ អ៊ែ សឹត ឡឹង ព្រី ក្លេ័ះ ឡាយ៉ិត ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","អេសាវ កា ប៉រ់ ហះ យ៉ាកុប ផា «អន់ អាញ់ សា ណើ សាអ៊្លង សាន់ឌែក កាហ្រី អីស ណោះ អាញ់ ឡាយ៉ិត ខាក់»។ ខ អា ហង បះ ពូ អើ អ៊ែ ផា អេដំ ។ ");
INSERT INTO tpu_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ហះកា យ៉ាកុប តើល ផា «អីស តូរ័ លូ ប៉ាដក់ ប៉ាជៀ កាប៉ាច់ អីស ណោះ ហិ អន់ កា អាញ់ កិញអៀ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","អេសាវ តើល ផា «អាញ់ ឡាយ៉ិត ប៊ែត ចឹង តោ័ កេះ អា ប៉ាដក់ ប៉ាជៀ ណោះ ទី ខា ញ៉ា សាំរ៉ាប់ អាញ់ ?» ");
INSERT INTO tpu_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","យ៉ាកុប ផា «ទឹល នីណោ័ះ ហគ់ អីស ម៉ត់ អន់ កា អាញ់ ហិ»។ អេសាវ កា ម៉ត់ តូរ័ ប៉ាដក់ ប៉ាជៀ អ៊ែ អន់ កា យ៉ាកុប តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","កេះណោះ យ៉ាកុប អ្យក់ ណុំ ប៉ាំង លូ សាអ៊្លង សាន់ឌែក កាហ្រី អន់ កា អ៊ែ សា អៃត អេសាវ សា កេះៗ កា ចាក ឡាច់ ឡូត។ នីអៀ ហង អ៊ែ បឺង៉ាយ ប៉ាដក់ ប៉ាជៀ ចានែក គន ឡោងទ្រៀ ម៉ះ អ៊ែ។ … ");
INSERT INTO tpu_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ប៉ាគ់ វគ័ អ៊ីសាក់ ក្រាគ់ ខាក់ កេះ ម៉ាត់ អ៊ែ កា ម៉ាម៉ាំង ហៃ អូ ប៉ប័ កេះ ដេល អ៊ែ អើ អេសាវ ឡាក់ គន ឡោងទ្រៀ ផា «អឺ គន»។ អេសាវ តើល ផា «ញ៉ា ពឹ ?» ");
INSERT INTO tpu_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","អ៊ែ កា រ៉ះ ផា «អាញ់ ក្រាគ់ ខាក់ កេះ អូ អ្លុ កា ចឹង តោ័ ដារ់ ចំ។ ");
INSERT INTO tpu_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ទឹល នីណោ័ះ អីស អ្យក់ ស្រាគ់ អ្យក់ ទឹងគង ឡាំ ប៉ាញ់ អ្យាំ ប៉ាគ់ ព្រី តោ រិញ។ ");
INSERT INTO tpu_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","កេះណោះ ប៉្រគ័ សាអ៊្លង ប៉ាអាំៗ ឡាក់ កា អាញ់ បាត់ សា អ្យក់ អន់ កា អាញ់ សា ម៉ាគ់ អាញ់ ចឹង ប៉រ់ សារ ដាគ់ ឡឹង ប‌៉្រ័ះ អន់ កា អីស អន់ទ្រួល អាញ់ ចឹង តោ័»។ ");
INSERT INTO tpu_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ផះ វគ័ អ៊ីសាក់ រ៉ះ លូ អេសាវ ណោះ យ៉ាគ់ រេបិកា សាំយ៉ាំង អន់តុង ដេល។ ប៉ាគ់ អេសាវ ឡាំ ប៉ាគ់ ព្រី ណាំង ប៉ាញ់ អ្យាំ កេះ ");
INSERT INTO tpu_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","យ៉ាគ់ រេបិកា រ៉ះ លូ យ៉ាកុប ផា «គន អាញ់ កាតាំង ពឹ អីស រ៉ះ លូ ម៉ី អីស ផា ");
INSERT INTO tpu_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","\"ហគ់ អីស ឡាំ ប៉ាគ់ ព្រី ណាំង ប៉ាញ់ អ្យាំ ប៉្រគ័ សាអ៊្លង ប៉ាអាំៗ អន់ កា អាញ់ សា ម៉ាគ់ អាញ់ ចឹង ប៉រ់ សារ ដាគ់ អន់ កា អីស ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ទ្រួល អាញ់ ចឹង តោ័\"។ ");
INSERT INTO tpu_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ទឹល នីណោ័ះ អីស សាំយ៉ាំង អាញ់ ចឹង ប៉្រើ អីស ប៉្រគ័ ហោគ។ ");
INSERT INTO tpu_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ហគ់ អីស ឡាំ អ្យក់ គន ប៉ារ់ពេ តីស តង់ៗ ពៀរ កាតុ អាញ់ ចឹង ប៉្រគ័ សាអ៊្លង ប៉ាអាំៗ ឡាក់ កា ពឹ អីស បាត់ សា។ ");
INSERT INTO tpu_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","កេះណោះ អីស អ្យក់ សាអ៊្លង ឡាំ ជឹន អន់ កា អ៊ែ សា ម៉ាគ់ អ៊ែ ចឹង ប៉រ់ សារ ដាគ់ អន់ កា អីស អន់ទ្រួល អ៊ែ ចឹង តោ័»។ ");
INSERT INTO tpu_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ហះកា យ៉ាកុប តើល មើគ ផា «អេសាវ អ៊ែ ទី ហ៊ន សាសក់ ប៉ាញ័ ឡាកោ អាញ់ អូ ទី សាសក់ ឡាក់ កា អ៊ែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ផា ពឹ សាពច ឡាកោ អាញ់ អ៊ែ អ្លុ អន់តគ់ កា អាញ់ ប៉ាង៉ល់ អ៊ែ អ៊ែ ចឹង ប៉ាស្យាប អាញ់ អូ ត្រគ់ ទី សារ ដាគ់ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","មើគ អ៊ែ ផា «អឺ គន ផា អ៊ែ ប៉ាស្យាប អីស អន់ ឡិ ពឹង អាញ់ ពិ អីស ក្រាន័ កា សាំយ៉ាំង អាញ់ បគ័ ហង។ ហគ់ អីស ឡាំ អ្យក់ គន ប៉ារ់ពេ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","យ៉ាកុប កា ឡាំ អ្យក់ គន ប៉ារ់ពេ តាទឹច មើគ អ៊ែ កា ប៉្រគ័ សាអ៊្លង ប៉ាអាំៗ ឡាក់ កា ពឹ អ៊ែ បាត់ សា។ ");
INSERT INTO tpu_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","កេះណោះ យ៉ាគ់ រេបិកា អ្យក់ ខោ អាវ អេសាវ រ៉ាន់ដាប់ ពឹង ហី បក់ ដាគ់ៗ ឡឹង ពូ អន់ កា យ៉ាកុប ពៀត កាស៊ប។ ");
INSERT INTO tpu_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","កេះណោះ ណាវ្គ អ្យក់ អង់ការ ប៉ារ់ពេ អ៊ែ ប៉្រគ័ សាអ៊្លង ណោះ លម ពឹង តី ពឹង អង់កូ យ៉ាកុប ពឹង ចារ អូ ទី សាសក់។ ");
INSERT INTO tpu_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","អ៊ែ កា អ្យក់ ណុំ ប៉ាំង លូ សាអ៊្លង ប៉ាអាំៗ អ៊ែ ប៉្រគ័ ណោះ អន់ កា យ៉ាកុប។ ");
INSERT INTO tpu_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","យ៉ាកុប កា ឡាំ ជឹន កា ពឹ អ៊ែ លូ អើ «ពឹ !» វគ័ អ៊ីសាក់ តើល ផា «ញ៉ា គន ពឿ អីស ណោះ ?» ");
INSERT INTO tpu_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","យ៉ាកុប តើល ផា «អាញ់ អេសាវ ឡាក់ គន ឡោងទ្រៀ អីស អាញ់ ប៉្រគ័ ឡាក់ កា អីស រ៉ះ ពែ ហង។ ហគ់ អីស អ្យូវ សា សាអ៊្លង អ្យាំ អាញ់ ប៉ាញ់ ឡឹង ព្រី អា ហិ កេះណោះ អីស ប៉រ់ សារ ដាគ់ អន់ កា អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","វគ័ អ៊ីសាក់ អំប៉ញ់ ផា «ញ៉ា ត្រគ់ អីស ឡាំ ណាំង ប៉ាញ់ អ្យាំ ប៉្រាល់ ទី ខាក់ ហះ ?» អ៊ែ តើល ផា «ខង ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អីស តង័ អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","កេះណោះ វគ័ អ៊ីសាក់ ផា «អីស អ្វៃ ក្យាម័ៗ ប៉ាគ់ អា ប៊ែត អាញ់ ចឹង សាពច ភឿ អន់ អ្លុ អន់តគ់ ផា អេសាវ តាទឹច ញ៉ា អូ»។ ");
INSERT INTO tpu_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","យ៉ាកុប កា ម៉ុត ក្យាម័ ពឹ អ៊ែ តាទឹច វគ័ អ៊ីសាក់ កា សាពច លូ កាប កាណុង ពុត ផា «ប៉ានឹរ ឃឺ ប៉ានឹរ យ៉ាកុប ហះកា តី ឃឺ តី អេសាវ»។ ");
INSERT INTO tpu_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ណោះ ហង បះ វគ័ អ៊ីសាក់ អូ អ្លុ អន់តគ់ កា យ៉ាកុប អុះ ខង តី អ៊ែ ទី សាសក់ ឡាក់ កា តី អេសាវ ដេល ហះកា ផះ ចឹង អន់ សារ ដាគ់ ");
INSERT INTO tpu_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","អ៊ែ អំប៉ញ់ ប៉ាឡាក់ ផា «អីស អា គន អាញ់ អេសាវ តាទឹច ប ?» យ៉ាកុប តើល ផា «អឺះ អាញ់ តាទឹច ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","វគ័ អ៊ីសាក់ ផា «អ្យក់ សាអ៊្លង អ្យាំ អីស ប៉ាញ់ ណោះ អន់ កា អាញ់ សា ហិ កេះណោះ អាញ់ ចឹង ប៉រ់ សារ ដាគ់ អន់ កា អីស»។ យ៉ាកុប កា អ្យក់ សាអ៊្លង អន់ កា ពឹ អ៊ែ សា លូ ត្រឹង តាពែ ប៉្លៃ អង់កាច អន់ កា អ៊ែ អៃត ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","កេះណោះ វគ័ អ៊ីសាក់ ផា កា យ៉ាកុប «អឺ គន អ្វៃ ក្យាម័ ពឹ ប៉ាគ់ អា។ ហគ់ អីស ចុំ អាញ់ ហិ »។ ");
INSERT INTO tpu_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","យ៉ាកុប កា អ្វៃ ក្យាម័ លូ ចុំ វគ័ អ៊ីសាក់ កា អន់ហ្នាល់ កាម៉ឹល ខោ អាវ អេសាវ កា ប៉រ់ សារ ដាគ់ អន់ កា យ៉ាកុប ឡាក់ កា អា៖ «កាម៉ឹល គន ឡាក់ កា កាម៉ឹល សាណា ពឹង ម៉ីរ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ ទី ប៉្លៃ អៀង។ ");
INSERT INTO tpu_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ ទៀក ងម ឡឹង ប៉្លៃង កា គន លូ មប សាណា ដាគ់ៗ ឡឹង តេះ អៀង ឡាក់ កា ប៉ូ ពៀ លូ តាពែ ប៉្លៃ អង់កាច អន់ កា គន ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","អន់ សុនសាត អន់ទៀគៗ កេះ ទុច អីស អន់ ទី ប៉ាសុន អៀង ជន តាកុល សាំប‌៉័ះ អីស។ អន់ អីស ប៉្រគ័ តាំងឡា អំប៉ាំង អុះ ម៉ី អីស លូ អន់ អន់ឌែ ជន តាកុល សាំប‌៉័ះ អីស។ ពឿ ត័ះ ប៉ាស្យាប អីស អន់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាស្យាប អ៊ែ និះទៅ ដេល ពឿ អន់ សារ ដាគ់ កា អីស អន់ អ៊ែ ទី សារ ដាគ់ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ប៉ាគ់ វគ័ អ៊ីសាក់ ប៉រ់ សារ ដាគ់ កា យ៉ាកុប កេះៗ យ៉ាកុប ឡាច់ ឡឹង ចារ ពឹ អ៊ែ ណោះ ប៊ែត ចឹង អូ តាន័ រ៉ាវ៉ាច់ ផាឌី អេសាវ ទឹល សឹត ឡឹង ណាំង ប៉ាញ់ អ្យាំ ឡឹង ព្រី។ ");
INSERT INTO tpu_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","កេះណោះ អ៊ែ ប៉្រគ័ សាអ៊្លង ប៉ាអាំៗ ឡាំ ជឹន អន់ កា ពឹ អ៊ែ ដេល។ អ៊ែ អើ ផា «ពឹ ហគ់ អីស អ្យូវ សា សាអ៊្លង អ្យាំ អាញ់ ប៉ាញ់ អា ហិ កេះណោះ អីស ប៉រ់ សារ ដាគ់ អន់ កា អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","វគ័ អ៊ីសាក់ អំប៉ញ់ ផា «ពឿ អីស ណោះ ?» អ៊ែ តើល «អាញ់ អេសាវ ឡាក់ គន ឡោងទ្រៀ អីស»។ ");
INSERT INTO tpu_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","វគ័ អ៊ីសាក់ កា រ៉ារ៉ៃត ឡាកោ ប៉ាំងឡៃ ប៉្រយ លូ អំប៉ញ់ ផា «ពឿ អន់ សាអ៊្លង កា អាញ់ សា អំពែ ពែ ផះ អីស បើ សឹត ? ពឿ អ៊ែ ណោះ ? អាញ់ សា កេះៗ អាញ់ ប៉រ់ សារ ដាគ់ អន់ កា អ៊ែ កេះ។ អ៊ែ ចឹង ទី សារ ដាគ់ លើយ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","អេសាវ កាតាំង ពឹ អ៊ែ រ៉ះ នីណោ័ះ អ៊ែ អង់ហ្យាំង ឡុង ម៉ៃៗ ខង អ៊ែ អីគ ពុត ខាក់។ អ៊ែ ឡោម ផា «ពឹ អីស ប៉រ់ សារ ដាគ់ អន់ កា អាញ់ ណើ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","វគ័ អ៊ីសាក់ តើល ផា «អូ ទី កេះ ! អុះ អីស ប៉ាញ៉ា ព្លូង អន់តុង អ្យក់ សារ ដាគ់ អាញ់ ឃឹត ចឹង អន់ កា អីស ណោះ ទិ កា អ៊ែ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","កេះណោះ អេសាវ ផា «ត្រគ់ កេះ ពូ អន់ សិច អ៊ែ យ៉ាកុប  ខង អ៊ែ តាប៉ីត ឡឹង អាញ់ ពៀរ ទង ហះ អា ហង។ ប៉ាន់ដា ពែ តាប៉ីត ប៉ាដក់ ប៉ាជៀ ចានែក អាញ់ កិញអៀ អា តាប៉ីត សារ ដាគ់ ឡឹង អាញ់ ណាវ្គ។ ពឹ អីស អូ ទី គម សារ ដាគ់ សាំរ៉ាប់ កា អាញ់ អន់ដា ប ?» ");
INSERT INTO tpu_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","វគ័ អ៊ីសាក់ រ៉ះ កា អេសាវ ផា «អាញ់ អន់ អ៊ែ ប៉្រគ័ តាំងឡា អីស កេះ លូ អុះ ម៉ី អ៊ែ ទិឌូ ចឹង កេះ ទុច អ៊ែ។ អាញ់ កា អន់ ប៉ូ ពៀ លូ តាពែ ប៉្លៃ អង់កាច អន់ អៀង កា អ៊ែ ដេល។ ទឹល នីណោ័ះ អាញ់ អូ ទី ញ៉ា ចឹង អន់ កា អីស ណាវ្គ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","អេសាវ អំប៉ញ់ ពឹ អ៊ែ ណាវ្គ ផា «ពឹ អីស ទី សារ ដាគ់ ដឹង ណោះ ហង ប ? អីស ប៉រ់ សារ ដាគ់ ដឹង ម៉ោញ អន់ កា អាញ់ ណើ វ៉គ»។ កេះណោះ អេសាវ កា អង់ហ្យាំង ញ៉ាំ។ ");
INSERT INTO tpu_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","វគ័ អ៊ីសាក់ រ៉ះ កា អេសាវ ណាវ្គ ផា៖ «អីស ចឹង អ្វៃ ពឹង តេះ អូ ដាគ់ សាណា លូ អូ ទី ទៀក ងម ឡិ ឡឹង ប៉្លៃង ហង ");
INSERT INTO tpu_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","អីស ចឹង ណាំង សា លូ ដាវ។ អីស ចឹង កេះ ទុច អុះ អីស ហះកា ដារ់ ចំ អីស ខំ ចាក ឡាច់ អន់ រ៉ាវ៉ាច់ អីស ចឹង ទី ឡាច់ ឡឹង អ៊ែ តាទឹច»។ ");
INSERT INTO tpu_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","អេសាវ កាគឹម កា យ៉ាកុប ខាក់ ខង យ៉ាកុប ទី សារ ដាគ់។ អ៊ែ កាប ម៉ោញ ដូវ ផា «អ្វៃ បាប៊ែត ណាវ្គ ពឹ ចឹង តោ័ ហង ប៉ាគ់ រ៉ាវ៉ាច់ តប់ ពឹ កេះ អាញ់ ចឹង ប៉ាន់តោ័ អ្លាត យ៉ាកុប»។ ");
INSERT INTO tpu_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ហះកា ពូ កាតាំង កេះណោះ ឡាំ រ៉ះ កា យ៉ាគ់ រេបិកា ឡឹង សារ អេសាវ កាប ណោះ។ អ៊ែ កា ប៉្រើ ពូ ឡាំ អើ យ៉ាកុប អ៊ែ កា រ៉ះ ផា «ហៃ ម៉ី អីស អេសាវ ឃឹត ចឹង ប៉ាន់តោ័ អីស។ ");
INSERT INTO tpu_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","អឺ គន កិញអៀ អា អីស សាំយ៉ាំង អាញ់ អីស ឡាំ អ្វៃ លូ ម៉ី អាញ់ ឡាបាន់ ប៉ាគ់ ស្រុក ហារ៉ាន់ តោ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","អីស ត្រគ់ ឡាំ អ្វៃ លូ អ៊ែ ហិ ទឹល ម៉ី អីស ស្វាស អឺក។ ");
INSERT INTO tpu_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ដារ់ ចំ ម៉ី អីស ស្វាស អឺក លូ ពឹល ទិ សារ អីស ប៉្រគ័ កា អ៊ែ ណោះ អាញ់ ចឹង ប៉្រើ ពូ ឡាំ រ៉ះ កា អីស ណាវ្គ។ អាញ់ អូ ប៉ិច ហ៊្យង អន់ដីស ពៀរ ដូវ ដារ់ ដឹង ម៉ោញ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","កេះណោះ យ៉ាគ់ រេបិកា រ៉ះ លូ វគ័ អ៊ីសាក់ ផា «អាញ់ អូ ណីស ខាក់ កា កាម៉ាញ់ អេសាវ សុនសាត ហេត។ ផា យ៉ាកុប ទី អង់កាន់ សុនសាត ហេត រស្រុក អា ដេល អាញ់ អ្វៃ រ៉ីស ប៉្រគ័ ញ៉ា ណាវ្គ ?»។ ");
INSERT INTO tpu_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","វគ័ អ៊ីសាក់ អើ យ៉ាកុប ឡាំ ប៉ាគ់ អ៊ែ លូ ប៉រ់ សារ ដាគ់ ឡឹង ប‌៉្រ័ះ កា អ៊ែ កេះណោះ អន់តគ់ រ៉ះ ផា «អូ អន់ អីស ទី កាម៉ាញ់ ពឹង ប៉ាថេត កាណាន អា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ហគ់ អីស ឡាំ អ្វៃ ប៉ាគ់ ហី វគ័ បេធូអ៊ែល គែង មើគ អីស ប៉ាគ់ ប៉ាថេត អារ៉ាម ហះ តាវ៉ាង័ តាំងលេ ពៀរ កេះណោះ ណាំង ទី កាម៉ាញ់ ពឹង គន សោ ឡាបាន់ វ៉ា អីស ទៅ ។ ");
INSERT INTO tpu_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","អន់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ទី អំរ៉ាញ អឺញ តីស ឡឹង ពូ អន់ សារ ដាគ់ កា អីស លូ អន់ អីស ទី គន សោ អៀង កើត អៀង ផូង័ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ដាគ់ កា អីស លូ ផូង័ វ៉ាច់ អីស ឡាក់ កា អ៊ែ អន់ កា វគ័ អីស អាប៉្រាហាំ ផះ អន់ទ្រួល ពែ ដេល ភឿ អន់ ប៉ាថេត អីស អ្វៃ អង់រ៉ាម័ អា ទី កា អីស ឃឺ ប៉ាថេត អា ហង ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ មប អន់ កា វគ័ អីស អាប៉្រាហាំ»។ ");
INSERT INTO tpu_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","កេះណោះ វគ័ អ៊ីសាក់ ប៉្រើ យ៉ាកុប ឡាំ ប៉ាគ់ ប៉ាថេត អារ៉ាម ហះ តាវ៉ាង័ តាំងលេ ពៀរ អ្វៃ ប៉ាគ់ ហី ឡាបាន់ ឡាក់ គន វគ័ បេធូអ៊ែល សុនសាត អារ៉ាម។ ឡាបាន់ ណោះ ម៉ី កាម៉ាក័ យ៉ាគ់ រេបិកា ឡាក់ មើគ យ៉ាកុប លូ អេសាវ។ … ");
INSERT INTO tpu_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","កេះណោះ យ៉ាកុប ឡាច់ ឡឹង ស្រុក បៀសេបា ឡាំ ប៉ាគ់ ស្រុក ហារ៉ាន់។ ");
INSERT INTO tpu_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ប៉ាគ់ អ៊ែ ទឹល ចារ ម៉ោញ ដារ់ ម៉ុត កេះ អ៊ែ រ៉ាឡូវ ដំ ហះ ណោះ ហង អ្យក់ អំហ្មោ ម៉ោញ ខើយ្គ កល់ តៃប ហ្លាក់ កា អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","អ៊ែ អំប៉ោ ប៉ប័ ជុង កឺង ម៉ោញ តគ័ ឡឹង តេះ ទឹល ប៉្លៃង លូ ប៉ប័ ប៊យ ប‌៉្រ័ះ ប៉ាណាំ គួប ជឹរ ហាវ ៗ ទ្រង ជុង កឺង ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ផះ ណោះ អ៊ែ ប៉ប័ ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ ហះ សានែង អ៊ែ ដេល លូ រ៉ះ ផា «អាញ់ អា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អាប៉្រាហាំ វគ័ អីស លូ ប‌៉្រ័ះ អ៊ីសាក់ ដេល។ អាញ់ ចឹង មប ប៉ាថេត កាណាន កា អីស លូ ផូង័ វ៉ាច់ អីស ឡាក់ ប៉ាថេត អីស ផះ អ្វៃ តៃប អា។ ");
INSERT INTO tpu_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","ផូង័ វ៉ាច់ អីស ចឹង ទី ចំលួន អៀង វ៉ឹច លូ កាបក់ តេះ តេះ អីស កា តីស ឡាឡីគ ឡាឡាយ ឡឹង គែង ដារ់ ឡាច់ ទឹល គែង ដារ់ ម៉ុត។ គ្រឹប ខាប់ខួ អ្វៃ ពឹង អង់កក់ តេះ ចឹង ទី សារ ដាគ់ ញន អីស លូ ផូង័ វ៉ាច់ អីស។ ");
INSERT INTO tpu_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","ហៃ អាញ់ អ្វៃ អន់ឌូ លូ អីស លូ រ៉ាំងហៃ អីស គ្រឹប ចារ អីស ចាក អាញ់ ចឹង ប៉ាណាំ អីស សឹត ប៉ាគ់ ប៉ាថេត អា ណាវ្គ។ អាញ់ អូ អ្លាត អីស អុះ ឃឺ អាញ់ ចឹង ប៉្រគ័ ទិ សារ អាញ់ រ៉ះ កា អីស អា»។ ");
INSERT INTO tpu_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","កេះណោះ យ៉ាកុប កា សាទឹរ ព្រឺត លូ កាប កាណុង ពុត ផា «ចារ អា ចាបះ កា ទី ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ តាទឹច ហង ហះកា អាញ់ អូ អ្លុ អន់តគ់»។ ");
INSERT INTO tpu_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","អ៊ែ អ្យូគ លូ កាប ផា «ចារ អា ត្រគ់ អ្យូគ តាទឹច ឡាក់ កា ហី ប‌៉្រ័ះ ប៊កកាតយ័ លូ អំប៉ារ ទ្រង ហាវ ពឹង ប៉្លៃង តាទឹច ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","យ៉ាកុប កា អ្យូវ ឡឹង កាំលឺ ផុងម៉ាំង លូ អ្យក់ អំហ្មោ អ៊ែ ខើយ្គ កល់ ណោះ តាគ់ អន់តាវ ភឿ ចាណាំ ចារ ប‌៉្រ័ះ តាំបាង ឡាកោ កា អ៊ែ កេះណោះ ស្រោច អំហ្មោ ណោះ លូ សាងី។ ");
INSERT INTO tpu_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","យ៉ាកុប អន់ សិច ចារ ណោះ ផា បេតអ៊ែល  ផះ សើគ ពែ ពូ អន់ សិច ចារ ណោះ ផា លូស។ ");
INSERT INTO tpu_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","កេះណោះ យ៉ាកុប បន់ ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ផា អីស អ្វៃ អន់ឌូ លូ អាញ់ តាទឹច លូ រ៉ាំងហៃ អាញ់ ចាក រទ្រង លូ អន់ សាណា សាណឹត កា អាញ់ សា ទឹប អន់ ខោ អាវ កា អាញ់ កាស៊ប ពៀត ");
INSERT INTO tpu_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","លូ អន់ អាញ់ សឹត ប៉ាគ់ ហី ពឹ អាញ់ ណាវ្គ ទឹប ទី កាន សាណុក សាវ៉ាក ណោះ អាញ់ ចឹង អ្យិល កូត័ សាំប‌៉័ះ អីស លូ អ្យក់ អីស ប៉្រគ័ ប‌៉្រ័ះ អាញ់ ទៅ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","អំហ្មោ អាញ់ តាគ់ អន់តាវ អា ចឹង កេះ ចារ ប៉ានេ អីស។ កាណាគ័ ញ៉ា កាតាម ឡាក់ អីស អន់ កា អាញ់ កាណាគ័ អញ់ជឹត កាតុ អាញ់ ចឹង អ្យក់ ឡាច់ ម៉ោញ ទៀន អន់ កា អីស ទៅ»។ ");
INSERT INTO tpu_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","យ៉ាកុប ចាក ទឹល ប៉ាគ់ ប៉ាថេត ពូ គែង ដារ់ ឡាច់។ ");
INSERT INTO tpu_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ផាឌី អ៊ែ ប៉ប័ ទី ទៀក អន់ដូង័ ម៉ោញ ពឹង ស៊្រែ លូ ប៉ប័ ប៉ារ់ពេ លូ ចៀម ប៉ៃង តាប៉ល់ អ្វៃ រ៉ាឡូវ ហះ ណោះ ដេល ខង ពូ ឃើយ អន់ អន់ឌែ អៃត ទៀក អន់ដូង័ ណោះ ហះកា អំហ្មោ កាត្រើគ ពឹរ អន់ដូង័ ណោះ តីស ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ប៉ាគ់ ចៀម អន់ឌែ ពឹះ តុំ ទិ កេះ មួត រង ចៀម ចឹង បើក កល់ អន់ដូង័ អោះ ទៀក អន់ ចៀម អៃត កេះណោះ អន់ឌែ កាត្រើគ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","យ៉ាកុប អំប៉ញ់ អន់ឌែ ផា «អុះ ម៉ី តេះ ចំ អន់ដីស អា ?» អន់ឌែ តើល ផា «ញឹន តេះ ហារ៉ាន់»។ ");
INSERT INTO tpu_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","អ៊ែ អំប៉ញ់ ណាវ្គ ផា «អន់ដីស អន់ហ្នាល់ ញ៉ា អូ វ៉ា ឡាបាន់ សោ វគ័ ណាហ៊រ ?» អន់ឌែ ផា «ញឹន អន់ហ្នាល់ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","កេះណោះ យ៉ាកុប អំប៉ញ់ ណាវ្គ ផា «នីចម័ អ៊ែ ដាគ់ ឡាកោ ប៉ាំងឡៃ ដេល ប ?» អន់ឌែ ផា «អ៊ែ អ្វៃ ដាគ់ ដេល។ ញ៉ា តោ ! គន អ៊ែ រ៉ាជែល ផះ គៀរ ចៀម តោ»។ ");
INSERT INTO tpu_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","យ៉ាកុប ផា «ញ៉ា ត្រគ់ អន់ដីស រិញ កា ប៉ាតុំ អ្យក់ សឹត ចៀម ឡគ ? ហៃ ដារ់ អ្វៃ ចាំងហីគ ស៊្រែល តោ បើ តាន័ ម៉ាំង អុះ អន់ អន់ឌែ អៃត ទៀក កេះណោះ អន់ សា សាម៉ោង ណាវ្គ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","មួត រង ចៀម តើល ផា «អូ ត្រគ់ អន់ អន់ឌែ អៃត អន់ទ្រួល អុះ ក្យាគ់ ទិ តាប៉ល់ ចៀម ពឹះ តុំ ហិ ផះ ណោះ ញឹន ចឹង បើក កល់ អន់ដូង័ អោះ ទៀក អន់ កា អន់ឌែ អៃត»។ ");
INSERT INTO tpu_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","ផះ យ៉ាកុប អ្វៃ កាកាប លូ មួត រង ចៀម ណោះ ណាង រ៉ាជែល កា ពឹះ ទឹល ដេល ទឹប គៀរ ចៀម ពឹ អ៊ែ ម៉ោញ តាប៉ល់ ខង អ៊ែ កា ប៉ាណូស រង ចៀម និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ផះ យ៉ាកុប ប៉ប័ ណាង រ៉ាជែល គន វ៉ា អ៊ែ ឡាបាន់ លូ តាប៉ល់ ចៀម អ៊ែ កា ឡាំ បើក កល់ អន់ដូង័ ឡូត អោះ ទៀក អន់ កា ចៀម ឡាបាន់ អៃត។ ");
INSERT INTO tpu_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","យ៉ាកុប ចុំ ណាង រ៉ាជែល អ៊ែ ហោក ឡាច់ ទៀក ម៉ាត់។ ");
INSERT INTO tpu_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","យ៉ាកុប រ៉ះ កា ណាង រ៉ាជែល ផា «អាញ់ អុះ ម៉ី លូ ឡាបាន់ អាញ់ គន រេបិកា»។ ណោះ ណាង បះ រ៉ាជែល កា សាតាក់ ឡាំ រ៉ះ កា ពឹ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","សាគ់ ឡាបាន់ កាតាំង គន អ៊ែ ផា មន អ៊ែ យ៉ាកុប គន យ៉ាគ់ រេបិកា ពឹះ ទឹល អ៊ែ កា ប៉ាន់តាន ឡាំ ហាប់ ទឹប គ្វែត ចុំ កេះណោះ ជៀក ម៉ុត ពឹង ហី។ យ៉ាកុប កា រ៉ះ សារ ទិណោ័ះ អន់ កា ឡាបាន់ សាំយ៉ាំង។ ");
INSERT INTO tpu_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","កេះណោះ ឡាបាន់ ផា «អីស អា អុះ មន អាញ់ តាទឹច ហង»។ យ៉ាកុប អ្វៃ លូ ឡាបាន់ ទុញ ទី ម៉ោញ ខៃ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","17","ឡាបាន់ អ៊ែ ទី គន អង់កាន់ ពៀរ ដូវ គន ឡោងទ្រៀ សិច លេអា គន ស្រុច សិច រ៉ាជែល។ ណាង លេអា ម៉ាត់ អ៊ែ ឡាយ៉ាម័ កាប៉ាច់ ណាង រ៉ាជែល អ៊ែ ឡាយ៉ាម័ ថិ ហ្រាងៗ។ ទី ដារ់ ម៉ោញ ឡាបាន់ កាកាប លូ យ៉ាកុប ផា «អីស ផូង័ វ៉ាច់ អាញ់ តាទឹច ហង ហះកា អីស អូ ត្រគ់ ប៉្រគ័ ង៉ារ អន់ កា អាញ់ តាដោះ អូ អ្យក់ ខា នីអៀ អុះ។ ប៉រ់ អីស រ៉ះ កា អាញ់ ពិ អីស ប៉ិច កាណាគ័ ញ៉ា ?» ");
INSERT INTO tpu_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ហះកា យ៉ាកុប ប៉ិច កា រ៉ាជែល ណោះ ហង អ៊ែ តើល ផា «អាញ់ ចឹង ប៉្រគ័ ង៉ារ អន់ កា អីស តាំប៉ើះ សាណាំ ហិ អីស អន់ អាញ់ ទី រ៉ាជែល ពិ ណោះ អាញ់ ប៉ិច »។ ");
INSERT INTO tpu_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","កេះណោះ ឡាបាន់ ផា «ទឹល នីណោ័ះ អីស អ្វៃ លូ អាញ់ ពិ។ អាញ់ អន់ គន ណោះ កា អីស ដាគ់ ហ៊្លត អន់ កា កាម៉ាក័ អន់ទៀគ»។ ");
INSERT INTO tpu_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","យ៉ាកុប អ្វៃ ប៉្រគ័ ង៉ារ កា ឡាបាន់ ទុញ តាំប៉ើះ សាណាំ ភឿ ទី ណាង រ៉ាជែល។ ញន កា អ៊ែ ប៉ិច កា រ៉ាជែល តាឡាម័ ទុញ តាំប៉ើះ សាណាំ ណោះ វ៉ឹច លូ តាម័ ត្រោ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","កេះណោះ យ៉ាកុប រ៉ះ លូ ឡាបាន់ ផា «អាញ់ ប៉្រគ័ ង៉ារ ទី តាំប៉ើះ សាណាំ ឡាក់ កា ពិន កាំឡត់ ពែ កេះ អីស អន់ អាញ់ ទី កាម៉ាញ់ ឡគ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","ឡាបាន់ កា ជៀក កាំឡាំង ស្រុក ទិឌូ ពឹះ ប៉ាគ់ ហី អ៊ែ កេះណោះ អៃត ប៉ាញ់សង់ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","30","ហះកា ប៉ាគ់ កាម៉ាំង ឡាបាន់ ប៉្រើ លេអា ឡាំ ប៉ាគ់ កាណុង យ៉ាកុប។ យ៉ាកុប សាម៉គ័ កា រ៉ាជែល អ៊ែ កា ម៉ុត តៃប លូ លេអា ហង។ ប៉ាគ់ តារ កាំលឺ យ៉ាកុប ប៉ប័ លេអា តៃប អន់ឌូ លូ អ៊ែ។ យ៉ាកុប កាប កា ឡាបាន់ ផា «ញ៉ា ត្រគ់ អីស ប៉្រគ័ នីអៀ ? អាញ់ ប៉្រគ័ ង៉ារ អន់ កា អីស ភឿ ប៉ិច ទី រ៉ាជែល។ ញ៉ា ត្រគ់ អីស ប៉ាង៉ល់ អាញ់ នីអៀ ?» ឡាបាន់ តើល ផា «ពឹង ស្រុក ញឹន អា អូ ទី ពឿ អន់ អុះ ទី ក្លោ អន់ទ្រួល ឡឹង ម៉ី អុះ។ ហគ់ អីស អ្វៃ តាគ់ អង់គ្រឹប ដារ់ ប៉ាញ់សង់ អា អន់ ទី តាំប៉ើះ ដារ់ ហិ កេះណោះ អាញ់ ចឹង អន់ អុះ អ៊ែ ណោះ ណាវ្គ។ ហះកា អីស ត្រគ់ ប៉្រគ័ ង៉ារ អន់ កា អាញ់ តាំប៉ើះ សាណាំ ណាវ្គ»។ យ៉ាកុប កា ប៉្រគ័ ពួយ ប៉ានឹរ ឡាបាន់ អ៊ែ អ្វៃ តាគ់ អង់គ្រឹប ដារ់ ប៉ាញ់សង់ លូ ណាង លេអា ទី តាំប៉ើះ ដារ់ កេះណោះ ឡាបាន់ អន់ ណាង រ៉ាជែល កា យ៉ាកុប ហង។ យ៉ាកុប តៃប លូ រ៉ាជែល ដេល អ៊ែ ប៉ិច កា រ៉ាជែល ហ៊្លត ឡឹង ប៉ិច កា លេអា។ ឡាបាន់ ប៉្រើ ទុច អ៊ែ សិច ស៊ីលប៉ា ឡាំ ប៉្រគ័ ទុច លេអា ឡគ។ អ៊ែ អន់ ទុច អ៊ែ សិច ប៊ីលហា ឡាំ ប៉្រគ័ ទុច រ៉ាជែល ដេល។ ឡៃង ឡឹង ទី រ៉ាជែល យ៉ាកុប ប៉្រគ័ ង៉ារ កា ឡាបាន់ តាំប៉ើះ សាណាំ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","ប‌៉្រ័ះ ប៊កកាតយ័ អ្លុ អន់តគ់ កា យ៉ាកុប អូ សូវ ប៉ិច កា លេអា អុះ ទឹល នីណោ័ះ ប‌៉្រ័ះ អន់ លេអា ទី គន។ កាប៉ាច់ រ៉ាជែល កេះ អង់កាន់ អូ អ្លុ ទី គន។ ");
INSERT INTO tpu_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","លេអា គៀម កេះណោះ អ្វៃ ហាអុញ កើត គន កាម៉ាក័ ម៉ោញ។ អ៊ែ អន់ សិច ផា រូបេន  ខង អ៊ែ កាប ផា «ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ាំងហៃ អាញ់ ផះ អាញ់ អ្វៃ ថុក ពុត ថុក ពៀក កិញអៀ អា ក្លោ អាញ់ ចឹង ប៉ិច កា អាញ់ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ឡៃង ឡឹង ណោះ អ៊ែ គៀម ណាវ្គ អ្វៃ ហាអុញ កើត គន កាម៉ាក័ ម៉ោញ ណាវ្គ។ អ៊ែ ផា «ប‌៉្រ័ះ ប៊កកាតយ័ អ្លុ អន់តគ់ ផា ក្លោ អាញ់ អូ សូវ ប៉ិច កា អាញ់ អុះ ណោះ ហង បះ អ៊ែ អន់ គន កាម៉ាក័ កា អាញ់ ម៉ោញ ណាវ្គ»។ អ៊ែ អន់ សិច ផា ស៊ីមៀន ។ ");
INSERT INTO tpu_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ឡៃង ឡឹង ណោះ អ៊ែ អ្វៃ ហាអុញ កើត គន កាម៉ាក័ ណាវ្គ។ អ៊ែ កាប ផា «ម៉ោញ ទង អា ក្លោ អាញ់ ចឹង វ៉ឹន កា អាញ់ តាទឹច ហង ខង អាញ់ ទី ប៉ាំងកើត គន កាម៉ាក័ ប៉ៃង ដូវ កេះ»។ ញន ខ អា ហង បះ អ៊ែ អន់ សិច គន ណោះ ផា លេវី ។ ");
INSERT INTO tpu_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","អ៊ែ អ្វៃ ហាអុញ កើត គន កាម៉ាក័ ម៉ោញ ណាវ្គ។ អ៊ែ កាប ផា «អាញ់ ប៉រ់ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ »។ ខ អា ហង បះ អ៊ែ អន់ សិច គន ណោះ ផា យូដា ។ ឡៃង ឡឹង ណោះ អ៊ែ អូ ទី គន ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","រ៉ាជែល សាណីង កា ម៉ី អ៊ែ លេអា ញន កា អ៊ែ អូ ទី គន។ អ៊ែ កាប កា យ៉ាកុប ផា «អន់ អាញ់ ទី គន ណើ ផា អាញ់ អូ ទី គន អាញ់ ចឹង តោ័ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","យ៉ាកុប កាប អឺក កា រ៉ាជែល ផា «អាញ់ អូ ត្រគ់ ប‌៉្រ័ះ ប៊កកាតយ័ អុះ អាញ់ អា ប‌៉្រ័ះ អូ ប៉្រគ័ អន់ អីស ទី គន ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","កេះណោះ រ៉ាជែល កាប ផា «អា ប៊ីលហា ទុច អាញ់ ហគ់ អីស តៃប លូ អ៊ែ ពិ ផា អ៊ែ ទី គន អាញ់ ចឹង អ្យក់ រង ប៉្រគ័ គន អាញ់ តាំងឡា ឡូត»។ ");
INSERT INTO tpu_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","រ៉ាជែល អន់ ប៊ីលហា កា យ៉ាកុប ប៉្រគ័ កាម៉ាញ់ ក្យង់ យ៉ាកុប កា តៃប លូ ប៊ីលហា តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ឡៃង ឡឹង ណោះ ប៊ីលហា កា គៀម អ្វៃ ហាអុញ កើត គន កាម៉ាក័ ម៉ោញ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","រ៉ាជែល កាប ផា «ប‌៉្រ័ះ ប៊កកាតយ័ តាត់ស៊ិន អន់ កា អាញ់ លូ កាតាំង អាញ់ ម៉ន់ អ៊ែ កា អន់ គន កាម៉ាក័ កា អាញ់ ម៉ោញ ដេល»។ ខ អា ហង បះ អ៊ែ អន់ សិច គន ណោះ ផា ដាន់ ។ ");
INSERT INTO tpu_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","ឡៃង ឡឹង ណោះ ប៊ីលហា ទុច រ៉ាជែល អ៊ែ ទី គន កាម៉ាក័ ម៉ោញ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","កេះណោះ រ៉ាជែល ផា «អាញ់ ប៉ាលួង លូ ម៉ី កេង ខាក់ កិញអៀ អា សាណ័ះ ទ្រង អាញ់ កេះ»។ អ៊ែ អន់ សិច គន ណោះ ផា ណាប់ថាលី ។ ");
INSERT INTO tpu_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","លេអា អ្លុ អន់តគ់ កា ឡាកោ អ៊ែ អូ អ្លុ ទី គន កេះ កា ប៉្រើ ទុច អ៊ែ ស៊ីលប៉ា ប៉្រគ័ កាម៉ាញ់ ក្យង់ យ៉ាកុប ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ស៊ីលប៉ា ទុច លេអា ណោះ អ៊ែ អ្វៃ ហាអុញ កើត គន កាម៉ាក័ ម៉ោញ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","លេអា កាប ផា «ប៊ុន កេះ !» អ៊ែ អន់ សិច គន ណោះ ផា កាត ។ ");
INSERT INTO tpu_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ឡៃង ឡឹង ណោះ ស៊ីលប៉ា ទុច លេអា អ៊ែ អ្វៃ ហាអុញ កើត គន កាម៉ាក័ ម៉ោញ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","លេអា កាប ណាវ្គ ផា «អាញ់ ទី កាន សាណុក សាវ៉ាក ខាក់ កិញអៀ អា អង់កាន់ ទិឌូ ចឹង ផា អាញ់ ទី កាន សាណុក សាវ៉ាក តាទឹច ហង»។ អ៊ែ អន់ សិច គន ណោះ ផា អាស៊ើរ ។ ");
INSERT INTO tpu_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ប៉ាគ់ ទឹល ថុន ច្រូត័ ពៀ សាឡី រូបេន ឡាំ ប៉ាគ់ ម៉ីរ អ្លេះ ប៉្លៃ សាអ្យាគ់ អ្យក់ សឹត អន់ កា មើគ អ៊ែ លេអា។ រ៉ាជែល ផា កា លេអា «អីស ជែក ប៉្លៃ សាអ្យាគ់ គន អីស អ្លេះ ណោះ អន់ កា អាញ់ ណើ»។ ");
INSERT INTO tpu_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","លេអា តើល ផា «អីស អ្យក់ ក្លោ អាញ់ កេះ បើ ខាក់ ប ? ញ៉ា ត្រគ់ អីស ប៉ិច អ្យក់ ប៉្លៃ សាអ្យាគ់ គន អាញ់ ណាវ្គ ?» រ៉ាជែល តើល ផា «ទឹល នីណោ័ះ ម៉ាំង អា អន់ អ៊ែ តៃប លូ អីស ពិ ខា ប៉្លៃ សាអ្យាគ់ គន អីស ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ប៉ាគ់ កាង៉ាច លេអា ប៉ប័ យ៉ាកុប សឹត ឡឹង ម៉ីរ អ៊ែ តាយ៉ិប ឡាំ ហាប់ លូ រ៉ះ ផា «ម៉ាំង អា អីស ត្រគ់ តៃប លូ អាញ់ ហង ខង អាញ់ ច្វាល់ អីស លូ ប៉្លៃ សាអ្យាគ់ គន អាញ់ កេះ»។ យ៉ាកុប កា តៃប លូ អ៊ែ តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ប‌៉្រ័ះ ប៊កកាតយ័ សាំយ៉ាំង លេអា ម៉ន់ លូ ប៉្រគ័ អន់ អ៊ែ គៀម អ្វៃ ហាអុញ កើត គន កាម៉ាក័ ម៉ោញ ណាវ្គ ឃឺ គន លេអា ទី ប៉ាតាម័។ ");
INSERT INTO tpu_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","លេអា កាប ផា «ប‌៉្រ័ះ ប៊កកាតយ័ អន់ ខា កា អាញ់ ខង អាញ់ ទី អន់ ទុច អាញ់ កា ក្លោ អាញ់ កេះ»។ លេអា អន់ សិច គន អ៊ែ ណោះ អ៊ីសាខារ ។ ");
INSERT INTO tpu_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ឡៃង ឡឹង ណោះ លេអា អ្វៃ ហាអុញ កើត គន កាម៉ាក័ ម៉ោញ ណាវ្គ ឃឺ គន ទី ត្រោ។ ");
INSERT INTO tpu_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","លេអា ផា «ប‌៉្រ័ះ ប៊កកាតយ័ អន់ កាណាគ័ កា អាញ់ ដាគ់ ខាក់ ម៉ោញ ទង អា ក្លោ អាញ់ ចឹង អ្យិល កូត័ កា អាញ់ តាទឹច ហង ខង អាញ់ ទី គន កាម៉ាក័ ត្រោ ដូវ ហះ អា ហង»។ លេអា អន់ សិច គន ណោះ សេប៊ូលុន ។ ");
INSERT INTO tpu_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ឡៃង ឡឹង ណោះ អ៊ែ អ្វៃ ហាអុញ កើត គន អង់កាន់ ម៉ោញ ដេល អ៊ែ អន់ សិច ផា ឌីណា។ ");
INSERT INTO tpu_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ប‌៉្រ័ះ ប៊កកាតយ័ កា អូ ពឹល រ៉ាជែល អុះ ប‌៉្រ័ះ សាំយ៉ាំង អ៊ែ ម៉ន់ លូ អន់ អ៊ែ ទី គន និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","រ៉ាជែល កា គៀម អ្វៃ ហាអុញ កើត គន កាម៉ាក័ ម៉ោញ កេះណោះ អ៊ែ ផា «ប‌៉្រ័ះ ប៊កកាតយ័ អូ អន់ អាញ់ ទី សារ តាយួស កេះ ពូ ចឹង អូ កាប ញគ័ កា អាញ់ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","អ៊ែ អន់ សិច គន ណោះ ផា យូស៊ែប លូ កាប ផា «អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ អាញ់ ទី គន កាម៉ាក័ ម៉ោញ ណាវ្គ»។ … ");
INSERT INTO tpu_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","យ៉ាកុប ចាក ឡាំ ប៉ាគ់ ម៉ាត់ ណាវ្គ ផាឌី ប៉ាត័ះ មួត ប៊យ ប‌៉្រ័ះ ឡាំ ប៉ាគ់ ចារ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ផះ អ៊ែ ប៉ប័ មួត ប៊យ ប‌៉្រ័ះ យ៉ាកុប កាប ផា «អា ហង ចារ មួត តាហាន ប‌៉្រ័ះ ប៊កកាតយ័ តាទឹច»។ អ៊ែ អន់ សិច ចារ ណោះ ផា ម៉ាហាណៃម ។ ");
INSERT INTO tpu_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","កេះណោះ យ៉ាកុប ប៉្រើ មួត ទុច អ៊ែ ឡាំ អន់ទ្រួល ប៉ាគ់ ម៉ី អ៊ែ អេសាវ អ្វៃ ប៉ាគ់ ប៉ានឹម សៀរ ពឹង ប៉ាថេត អេដំ។ ");
INSERT INTO tpu_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","អ៊ែ អន់តគ់ រ៉ះ កា ទុច បក់ ឡាំ អន់ទ្រួល ណោះ ផា «អន់ដីស ត្រគ់ រ៉ះ កា ពឹ តាំងឡា អាញ់ អេសាវ នីអៀ \"យ៉ាកុប អ៊ែ អ្វៃ លូ វ៉ា ឡាបាន់ លើយ ទឹល កិញអៀ។ ");
INSERT INTO tpu_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","អ៊ែ ទី រ៉ក់ លៀ ចៀម លូ ទី ទុច កាម៉ាក័ ទុច អង់កាន់ អៀង អ៊ែ ប៉្រើ ញឹន ឡាំ រ៉ះ កា អីស អន់ អ្លុ អន់តគ់ ភឿ ប៉រ់ ឡោម អន់ ពឹ តាំងឡា តាប៉ាប តាប៉ុន កា អ៊ែ\"»។ ");
INSERT INTO tpu_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ប៉ាគ់ មួត ទុច រ៉ះ កា អេសាវ កេះ អន់ឌែ សឹត រ៉ះ លូ យ៉ាកុប ណាវ្គ «ញឹន ទឹល ប៉ាគ់ អេសាវ ម៉ី អីស កេះ អ៊ែ ផះ ចាក ឡាំ ប៉ាគ់ អា លូ ទី កាំឡាំង ៤០០ ដូវ ឡាំ អន់ឌូ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ផះ ណោះ យ៉ាកុប កា អ្យូគ លូ អុក ពុត ពៀក ខាក់ អ៊ែ ជែក កាំឡាំង អ៊ែ ពៀរ តាប៉ល់ លូ ជែក ចៀម រ៉ក់ អូត ពៀរ តាប៉ល់ ដេល ");
INSERT INTO tpu_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","ខង អ៊ែ ឃឹត ផា ផា អេសាវ ឡាំ ប្ល‌៉័ះ លូ អន់ឌែ ម៉ោញ តាប៉ល់ ម៉ោញ តាប៉ល់ ណាវ្គ ចឹង សាតាក់ រ៉ាវ៉ាច់។ ");
INSERT INTO tpu_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","កេះណោះ យ៉ាកុប ម៉ន់ ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័  អីស ប‌៉្រ័ះ វគ័ អាប៉្រាហាំ លូ ប‌៉្រ័ះ អ៊ីសាក់ ពឹ អាញ់ ដេល។ អីស រ៉ះ កា អាញ់ ពែ ផា \"ហគ់ អីស សឹត ប៉ាគ់ ស្រុក អ្វៃ លូ អុះ ម៉ី អីស ទៅ អាញ់ ចឹង អន់ អីស ទី កាន សាណុក សាវ៉ាក\"។ ");
INSERT INTO tpu_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","យ‌៉័ះ អាញ់ អា ប៉ាណូស អូ គឹត អូ ខា កា អីស តាំបាង សារ ដាគ់ ត្រង់ លូ ប៉ិច ចៃ កា អាញ់ អាញ់ អូ ឃឺ ចឹង ទី សារ ដាគ់ អា អុះ។ ផះ អាញ់ ឃ្លង ទៀក ទ្រូង យដាន់ ពែ អាញ់ ទី ដឹង អ៊្លង កាទូង ម៉ោញ។ កិញអៀ អា អាញ់ ទី កាំឡាំង លូ កាណាគ័ រង អៀង ទឹល ពៀរ តាប៉ល់ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ប៉រ់ អីស តាប៉ាប តាប៉ុន កា អាញ់ ណើ អន់ រ៉ាវ៉ាច់ ឡឹង តី ម៉ី អាញ់ អេសាវ ខង អាញ់ អ្យូគ កា អ៊ែ ចឹង ឡាំ ប៉ាន់តោ័ អាញ់ លូ គន កាម៉ាញ់ អាញ់ ");
INSERT INTO tpu_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","ហះកា អីស ផា ចឹង អន់ អាញ់ ទី កាន សាណុក សាវ៉ាក លូ ប៉្រគ័ អន់ ផូង័ វ៉ាច់ អាញ់ ទី ចំលួន អៀង ឡាក់ កា តេះ ឡាពុក រហាង សាឡីគ សាឡាយ អូ ដាម័ យ៉ាប»។ ");
INSERT INTO tpu_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ម៉ាំង ណោះ យ៉ាកុប អ្វៃ ហះ ចារ ណោះ ហង។ កេះណោះ អ៊ែ អ្យក់ កាណាគ័ ម៉ោញ ចំលួន ម៉ះ អ៊ែ ភឿ ជឹន អន់ កា ម៉ី អ៊ែ អេសាវ។ ");
INSERT INTO tpu_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ប៉ារ់ពេ យ៉ង់ ២០០ កល់ ប៉ារ់ពេ ទោល ២០ កល់ ចៀម យ៉ង់ ២០០ កល់ ចៀម ទោល ២០ កល់ ");
INSERT INTO tpu_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","អូត យ៉ង់ ៣០ កល់ ទឹប គន អ្វៃ ម៉ម់ ដេល រ៉ក់ យ៉ង់ ៤០ កល់ លូ រ៉ក់ ទោល ១០ កល់ លៀ យ៉ង់ ២០ កល់ លៀ ទោល ១០ កល់។ ");
INSERT INTO tpu_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","កេះណោះ អ៊ែ មប កាណាគ័ ទិណោ័ះ អន់ កា ទុច អ៊ែ តាម តាប៉ល់ ចាំងហាយ្គៗ ឡឹង គួប កេះណោះ អ៊ែ រ៉ះ កា មួត ទុច ផា «ហគ់ អន់ដីស ចាក អន់ទ្រួល ឡឹង អាញ់ លូ អន់ កាណាគ័ អា អ្វៃ ចាំងហាយ្គៗ ឡឹង គួប អ៊ែ»។ ");
INSERT INTO tpu_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","កេះណោះ អ៊ែ អន់តគ់ រ៉ះ កា ទុច បក់ ចាក អន់ទ្រួល ឡឹង ពូ ផា «ផា ម៉ី អាញ់ អេសាវ ប៉ប័ អីស លូ អំប៉ញ់ ផា \"ប៉ាគ់ ចំ អីស ចឹង ឡាំ ? ពឿ ពឹ តាំងឡា អីស ? កាណាគ័ ពឿ អីស គៀរ អា ?\" ");
INSERT INTO tpu_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","អីស ត្រគ់ រ៉ះ ផា \"កាណាគ័ ទិ អា ឃឺ កាណាគ័ យ៉ាកុប។ អ៊ែ ប៉្រើ ញឹន ឡាំ ជឹន កាណាគ័ ទិ អា អន់ កា អីស ឡាក់ ពឹ តាំងឡា។ កាប៉ាច់ អ៊ែ តាំងឡា ឡាំ ពួយ អន់តីគ ឡឹង ញឹន\"»។ ");
INSERT INTO tpu_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","យ៉ាកុប អន់តគ់ រ៉ះ កា បក់ ចាក ទី ពៀរ ទី ប៉ៃង លូ មួត គៀរ រ៉ក់ ចៀម ប៉ារ់ពេ និះទៅៗ។ អ៊ែ អន់តគ់ រ៉ះ ផា «ផា អន់ដីស ប៉ប័ អេសាវ អន់ដីស រ៉ះ នីអៀ ");
INSERT INTO tpu_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ឃឺ អន់ដីស ត្រគ់ ផា \"យ៉ាកុប អ៊ែ ឡាំ ពួយ អន់តីគ ឡឹង ញឹន\"»។ យ៉ាកុប ប៉្រគ័ នីអៀ ខង អ៊ែ ឃឹត ផា «កាណាគ័ អាញ់ អន់ ឡាំ អន់ទ្រួល អា ចឹង ប៉្រគ័ អន់ កា អេសាវ ដាគ់ ពុត ហង តាម ហៃ។ អ្លុ ផៃគ ប៉ាគ់ អ៊ែ ប៉ប័ អាញ់ ទៀ អ៊ែ ចឹង ដាគ់ កា អាញ់ តាទឹច»។ ");
INSERT INTO tpu_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ពូ កា គៀរ កាណាគ័ អ៊ែ អន់ ទិណោ័ះ ចាក អន់ទ្រួល តាទឹច ហង ហះកា ម៉ាំង ណោះ អ៊ែ តាំងឡា អ្វៃ ហះ រ៉ាណើះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ម៉ាំង ណោះ ទៅ អ៊ែ ប៉្រើ កាម៉ាញ់ អ៊ែ ទិ ពៀរ លូ ទុច អង់កាន់ ពៀរ ទឹប គន អ៊ែ ១១ ដូវ ឃ្លង ទ្រូង ទៀក យ៉ាបុក ហះ ចារ ទៀក ដាល។ ");
INSERT INTO tpu_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ប៉ាគ់ គន កាម៉ាញ់ អ៊ែ ឃ្លង ទៀក រ៉ាវ៉ាច់ ទិ កេះ អ៊ែ ប៉្រើ ពូ ប៉ាំងឃ្លង កាណាគ័ ទិណោ័ះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","យ៉ាកុប អ្វៃ ម៉ោញ ដូវ អ៊ែ ផាឌី ទី កាម៉ាក័ ម៉ោញ ដូវ ឡាំ ទម លូ អ៊ែ លើយ ទឹល តារ។ ");
INSERT INTO tpu_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","កាម៉ាក័ ណោះ ហៃ ចឹង អូ ដាម័ យ៉ាកុប អ៊ែ កា ពីត សាំងគៀង យ៉ាកុប យ៉ាកុប កា ខ្លេះ សាំងគៀង ផះ អន់ឌែ ទម គួប អន់ឌែ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","កេះណោះ កាម៉ាក័ ណោះ កាប ផា «បគ័ ហង អ្លាត អាញ់ ឡគ ខង តារ កេះ»។ យ៉ាកុប តើល ផា «អាញ់ អូ អន់ ចាក អុះ អីស អន់ សារ ដាគ់ កា អាញ់ ហិ»។ ");
INSERT INTO tpu_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","កាម៉ាក័ ណោះ អំប៉ញ់ ផា «ញ៉ា សិច អីស ?» អ៊ែ តើល ផា «អាញ់ សិច យ៉ាកុប»។ ");
INSERT INTO tpu_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","កាម៉ាក័ ណោះ កាប ណាវ្គ ផា «ពូ អូ អើ ហង សិច អីស យ៉ាកុប ពូ ចឹង អើ ផា អ៊ីស្រាអ៊ែល ឡគ ខង អីស ប៉ាលួង ប៉ាណាំង លូ ប‌៉្រ័ះ ប៉ាលួង ប៉ាណាំង លូ ប៉ាណូស កា ទី ទ្រង អីស ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","កេះណោះ យ៉ាកុប អំប៉ញ់ អ៊ែ ផា «ញ៉ា សិច អីស ? ប៉រ់ អីស រ៉ះ សិច អន់ អាញ់ អ្លុ ដេល»។ កាម៉ាក័ ណោះ តើល ផា «ខ ញ៉ា បះ អីស ប៉ិច អ្លុ សិច អាញ់ ?» កេះណោះ អ៊ែ អន់ សារ ដាគ់ កា យ៉ាកុប ហះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","យ៉ាកុប អន់ សិច ចារ ណោះ ផា ប៉ានីអ៊ែល  អ៊ែ កាប ផា «ខង អាញ់ ទី ប៉ប័ ប‌៉្រ័ះ ប៊កកាតយ័ ម៉ាត់ អាញ់ តាំងឡា ហះកា អាញ់ អ្វៃ រ៉ីស អូ តោ័»។ ");
INSERT INTO tpu_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","ផះ យ៉ាកុប ចាក ឃ្លង ចារ ប៉ានីអ៊ែល ណោះ ដារ់ ឡាច់ កេះ អ៊ែ ចាក ប៉ឺងកឺចៗ ខង អ៊ែ ខ្លេះ សាំងគៀង។ ");
INSERT INTO tpu_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ញន សារ អា ហង បះ ទឹល រ៉ប់ ដារ់ អា គន សោ អ៊ីស្រាអ៊ែល អូ សា ប៉ាំងឡៃ ប៉ាឡគ់ ហះ សាំងគៀង ខង ប‌៉្រ័ះ ប៊កកាតយ័ ពីត សាំងគៀង យ៉ាកុប។ ");
INSERT INTO tpu_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","យ៉ាកុប តាង៉ើន ហៃ ប៉ាគ់ ម៉ាត់ ផាឌី ប៉ប័ អេសាវ ចាក អន់ឌូ លូ ប៉ាណូស អៀង ៤០០ ដូវ ណោះ។ យ៉ាកុប កា ជែក គន អន់ កា លេអា អន់ កា រ៉ាជែល លូ អន់ កា ទុច អង់កាន់ ទិ ពៀរ ដូវ និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","អ៊ែ អន់ ទុច អង់កាន់ ពៀរ ដូវ លូ គន អន់ឌែ ចាក អន់ទ្រួល កេះណោះ លេអា លូ គន អ៊ែ រ៉ាជែល លូ គន អ៊ែ យូស៊ែប ចាក អន់តីគ ឡឹង ពូ។ ");
INSERT INTO tpu_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","កាប៉ាច់ យ៉ាកុប តាំងឡា អ៊ែ ចាក អន់ទ្រួល ឡឹង ពូ លូ ជន តាកុល មូប កល់ ទឹះ តេះ សាំប‌៉័ះ តាំប៉ើះ ទង លើយ ប៊ែត ចឹង ទឹល ប៉ាគ់ អេសាវ។ ");
INSERT INTO tpu_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","ហះកា ប៉ាគ់ អេសាវ ប៉ប័ យ៉ាកុប អ៊ែ តាយ៉ិប ឡាំ ហាប់ ឡូត លូ គ្វែត ចុំ អន់ឌែ ហោក ឡាច់ ទៀក ម៉ាត់ ទិ អន់ឌែ ពៀរ ដូវ។ ");
INSERT INTO tpu_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ប៉ាគ់ អេសាវ ង៉ើយ ហៃ ប៉ប័ មួត អង់កាន់ លូ មួត សាស្វា អ៊ែ អំប៉ញ់ ផា «ពឿ អ្វៃ អន់ឌូ លូ អីស អា ?» យ៉ាកុប ផា «មួត អា ឃឺ គន កាម៉ាញ់ អាញ់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ ញន អ៊ែ តាប៉ាប កា អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","មួត ទុច អង់កាន់ ពៀរ ដូវ លូ គន អន់ឌែ កា ម៉ុត អន់ឌូ ដេល កេះណោះ ជន តាកុល សាំប‌៉័ះ អេសាវ។ ");
INSERT INTO tpu_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","កេះណោះ លេអា លូ គន អ៊ែ ម៉ុត ជន តាកុល សាំប‌៉័ះ។ ប៉ាគ់ អន់តីគ រ៉ាជែល លូ គន អ៊ែ យូស៊ែប អន់ឌែ ម៉ុត ជន តាកុល សាំប‌៉័ះ អេសាវ និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","កេះណោះ អេសាវ អំប៉ញ់ លូ យ៉ាកុប ផា «អីស ចឹង ប៉្រគ័ ញ៉ា បះ អីស អ្យក់ ឡាំ កាណាគ័ អៀងៗ ឡាក់ អាញ់ ប៉ប័ ពែ ?» យ៉ាកុប តើល ផា «អឺ ពឹ តាំងឡា អាញ់ អ្យក់ ឡាំ អន់ កា អីស ភឿ ប៉រ់ អន់ អីស តាប៉ាប តាប៉ុន កា អាញ់ ណើ»។ ");
INSERT INTO tpu_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","អេសាវ តើល ផា «អឺ អុះ អាញ់ កា ទី អៀង កេះ ដេល រង កា អីស ទៅ ហះ ណោះ ហង កាណាគ័ អីស ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","យ៉ាកុប តើល ផា «អូ ត្រគ់ អុះ នីណោ័ះ ផា ពឹ តាំងឡា តាប៉ាប តាប៉ុន កា អាញ់ តាទឹច ប៉រ់ អីស អ្យក់ សារ ដាគ់ លូ កាណាគ័ អាញ់ អន់ កា អីស អា។ ប៊ុន កេះ អាញ់ ទី ប៉ប័ អីស ឡាក់ កា អាញ់ ប៉ប័ ប‌៉្រ័ះ ប៊កកាតយ័ ដេល ខង អីស ដាគ់ អូ អឺក កា អាញ់ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ទឹល នីណោ័ះ ប៉រ់ ពឹ តាំងឡា អ្យក់ សារ ដាគ់ លូ កាណាគ័ អាញ់ អន់ អា ពិ ខង ប‌៉្រ័ះ ប៊កកាតយ័ អន់ កាណាគ័ កា អាញ់ អៀង គ្រឹប កេះ»។ ញន កា យ៉ាកុប ប៉ាំងខំ តាឡាម័ បះ អេសាវ ចៃ អ្យក់។ ");
INSERT INTO tpu_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","កេះណោះ អេសាវ ផា «ពិ ពិន ចាក អាញ់ ចឹង ចាក អន់ឌូ លូ អីស ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","យ៉ាកុប តើល ផា «អឺ ពឹ តាំងឡា អីស អ្លុ អន់តគ់ កេះ ពិន ចាក លូ មួត សាស្វា អូ ប៉្រាល់ អុះ អាញ់ ទី ចៀម លូ រ៉ក់ អន់ដា គន កាសៃគ ផា ពិន ប៉ាំងខំ អន់ឌែ ចាក ប៉្រាល់ យ‌៉័ះ ម៉ោញ ដារ់ កាតាម ចាបះ កា ចឹង ទី កាន ខូច័ ខាច តាទឹច ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ទឹល នីណោ័ះ អីស ចាក អន់ទ្រួល កា ពិន ពិ អាញ់ ចឹង ចាក ចោង មួត សាស្វា អន់ឌូ លូ ចៀម លូ រ៉ក់ ឡាំ ពួយ អន់តីគ ទឹល ប៉ាគ់ ចារ អីស ប៉ានឹម សៀរ តោ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","អេសាវ កាប ផា «ទឹល នីណោ័ះ អាញ់ ចឹង ប៉្រើ កាំឡាំង អាញ់ អន់ដា អន់ ចាក អន់ឌូ លូ អីស ដេល»។ យ៉ាកុប តើល ផា «អូ អុះ ដឹង ពឹ តាំងឡា ដាគ់ កា អាញ់ បគ័ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ដារ់ ណោះ ហង អេសាវ កា វ៉ីល សឹត ប៉ាគ់ ប៉ានឹម សៀរ ទៅ។ ");
INSERT INTO tpu_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ហះកា យ៉ាកុប វ៉ីល ឡាំ អ្វៃ ប៉ាគ់ ព្រី ស៊ុកូត។ ទឹល ប៉ាគ់ ណោះ កេះ អ៊ែ កា ប៉្រគ័ ហី អ្វៃ លូ ប៉្រគ័ អន់ទ្រួង កា ចៀម លូ រ៉ក់ អ៊ែ ដេល។ ខ អា ហង បះ អ៊ែ អន់ សិច ចារ ណោះ ផា ស៊ុកូត ។ … ");
INSERT INTO tpu_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","យ៉ាកុប អ្វៃ ពឹង ប៉ាថេត កាណាន ឡាក់ ប៉ាថេត ពឹ អ៊ែ អ្វៃ អង់រ៉ាម័ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","អា ហង សារ គន សោ យ៉ាកុប។ ផះ យូស៊ែប អ្វៃ សាស្វា អាញុ ១៧ សាណាំ ពែ អ៊ែ រង ចៀម រង ប៉ារ់ពេ អន់ឌូ លូ មួត ម៉ី អ៊ែ។ អ៊ែ ឃើយ តង័ គន កាម៉ាញ់ ក្យង់ ពឹ អ៊ែ សិច ប៊ីលហា លូ ស៊ីលប៉ា ដេល។ ដារ់ ម៉ោញ យូស៊ែប រ៉ះ កា ពឹ អ៊ែ ឡឹង សារ អូ ដាគ់ មួត ម៉ី អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","វគ័ យ៉ាកុប ប៉ិច កា យូស៊ែប លឺន ឡឹង គន អន់ទៀគៗ ខង គន អ៊ែ យូស៊ែប អា កើត ប៉ាគ់ អ៊ែ ឡាកោ ក្រាគ់ កេះ។ អ៊ែ កាត់ អាវ ដាគ់ ឡាយ៉ាម័ ម៉ោញ អន់ កា យូស៊ែប ពៀត។ ");
INSERT INTO tpu_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","មួត ម៉ី អ៊ែ ប៉ប័ ពឹ អន់ឌែ ប៉ិច កា យូស៊ែប លឺន ឡឹង ប៉ិច កា អន់ឌែ ណោះ ហង បះ អន់ឌែ អូ ណីស លូ កាប អូ ដាគ់ ប៉ានឹរ កា យូស៊ែប។ ");
INSERT INTO tpu_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ឡៃង ឡឹង ណោះ យូស៊ែប អំប៉ោ កេះណោះ រ៉ះ សារ អ៊ែ អំប៉ោ ណោះ កា មួត ម៉ី អ៊ែ ហ៊ែង ណោះ ហង អន់ឌែ អូ ណីស កា អ៊ែ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","អ៊ែ រ៉ះ កា អន់ឌែ ផា «ប៉រ់ អន់ដីស សាំយ៉ាំង អាញ់ ចឹង រ៉ះ សារ អាញ់ អំប៉ោ។ ");
INSERT INTO tpu_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","អាញ់ អំប៉ោ ប៉ប័ ពិន ទិឌូ ផះ អ្វៃ កត់ ពៀ ពឹង ម៉ីរ ហះកា ចាណគ់ ពៀ អាញ់ អ្យូវ អន់តាវ តាគឹង។ ចាណគ់ ពៀ អន់ដីស ឡាំ អ្វៃ វ៉ិង ជុំ ចាណគ់ ពៀ អាញ់ លូ សាំប‌៉័ះ ចាណគ់ ពៀ អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","មួត ម៉ី អ៊ែ តើល ផា «នីចម័ ពុត អីស ណោះ ឃឹត ចឹង ប៉្រគ័ សាដាច់ អ្វៃ អំប៉ាំង ញឹន ប ?» អន់ឌែ អូ ណីស កា អ៊ែ ក្វា ឡឹង អន់ទ្រួល ណាវ្គ ញន កា អ៊ែ រ៉ះ សារ អំប៉ោ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ឡៃង ឡឹង ណោះ យូស៊ែប អំប៉ោ ណាវ្គ កេះណោះ រ៉ះ លូ មួត ម៉ី អ៊ែ ផា «អាញ់ អំប៉ោ ណាវ្គ ប៉ប័ ដារ់ ខៃ លូ សំឡង់ ទិ ១១ ពឹះ សាំប‌៉័ះ អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","កេះណោះ អ៊ែ ឡាំ រ៉ះ សារ អំប៉ោ ណោះ កា ពឹ អ៊ែ ណាវ្គ ពឹ អ៊ែ កាប កា អ៊ែ «ញ៉ា ត្រគ់ អីស អំប៉ោ នីណោ័ះ ? មើគ ពឹ លូ មួត ម៉ី អីស ញឹន អា ចឹង ជន តាកុល សាំប‌៉័ះ អីស ហង ប ?»។ ");
INSERT INTO tpu_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","មួត ម៉ី អ៊ែ សាណីង កា យូស៊ែប ខាក់ ហះកា ពឹ អ៊ែ គម សារ ណោះ កាណុង ពុត។ ");
INSERT INTO tpu_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ឡៃង ឡឹង ណោះ មួត ម៉ី យូស៊ែប ប៉ាណាំ គួប ឡាំ រង ចៀម ពឹ អន់ឌែ ប៉ាគ់ ស្រុក ស៊ីគែម។ ");
INSERT INTO tpu_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","វគ័ យ៉ាកុប រ៉ះ លូ យូស៊ែប ផា «គន មួត ម៉ី អីស អន់ឌែ អ្វៃ រង ចៀម ប៉ាគ់ ស្រុក ស៊ីគែម តោ អាញ់ ប៉ិច ប៉្រើ អីស ឡាំ ហៃៗ អន់ឌែ»។ យូស៊ែប តើល ផា «អឺះ ពឹ អាញ់ ចឹង ឡាំ»។ ");
INSERT INTO tpu_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","វគ័ យ៉ាកុប កាប ណាវ្គ ផា «ឡាំ ហៃ មួត ម៉ី អីស លូ តាប៉ល់ ចៀម ណោះ អន់ឌែ អ្វៃ ដាគ់ ញ៉ា អូ ? កេះណោះ សឹត រ៉ះ កា អាញ់ ណាវ្គ»។ យូស៊ែប ចាក ឡាច់ ឡឹង ក្លូះ ប៉ានឹម ហេប្រូន។ ប៉ាគ់ ទឹល ស្រុក ស៊ីគែម ");
INSERT INTO tpu_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","អ៊ែ ចាក សឹត ចាក ឡាំ ណាំង ម៉ី អ៊ែ ពឹង ស៊្រែ។ ទី កាម៉ាក័ ម៉ោញ ដូវ ប៉ប័ យូស៊ែប អ៊ែ កា អំប៉ញ់ ផា «ញ៉ា អីស ចាក ណាំង មន ?» ");
INSERT INTO tpu_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","អ៊ែ តើល ផា «អាញ់ ឡាំ ណាំង មួត ម៉ី អាញ់ ក្លឹញ។ អីស ប៉ប័ ញ៉ា អូ ប៉ាគ់ ចំ អន់ឌែ រង ចៀម ណោះ ? អីស រ៉ះ កា អាញ់ ណើ»។ ");
INSERT INTO tpu_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ប៉ាណូស ណោះ តើល ផា «អន់ឌែ ឡាច់ ឡឹង ចារ អា កេះ អាញ់ កាតាំង អន់ឌែ ផា \"ពិ ពិន ឡាំ ប៉ាគ់ ស្រុក ដូថាន តោ ឡគ\"»។ យូស៊ែប កា ឡាំ ពួយ ប៉ប័ អន់ឌែ ប៉ាគ់ ស្រុក ដូថាន តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","19","អន់ឌែ ប៉ប័ យូស៊ែប ឡឹង ចាំងហាយ្គ។ ផះ អ៊ែ បើ តាន័ ទឹល អន់ឌែ រ៉ះ លូ គួប ផា «ហៃ តោ ! ម៉ៃគ អំប៉ោ ពឹះ ទឹល កេះ»។ អន់ឌែ ឃឹត ចឹង ប៉ាន់តោ័ អ្លាត អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","អន់ឌែ ផា «ពិ ពិន ប៉ាន់តោ័ អ្លាត ប៉ាឡិ ពឹង ឡូះ ទៀក កិញអៀ ហង កេះណោះ រ៉ះ ផា កាណាគ័ កាប់ សា អ៊ែ កេះ។ ចាំ ហៃ សារ អ៊ែ អំប៉ោ ណោះ ចឹង កើត នីចម័ ណាវ្គ ?» ");
INSERT INTO tpu_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","រូបេន កាតាំង អន់ឌែ កាប នីណោ័ះ អ៊ែ ប៉ិច តង័ យូស៊ែប អន់ រ៉ាវ៉ាច់ ឡឹង តី អន់ឌែ អ៊ែ ផា «ញ៉ា ចឹង ប៉ាន់តោ័ កា អ៊ែ ណោះ ?» ");
INSERT INTO tpu_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","រូបេន ផា ណាវ្គ «ជែ ប៉ាន់តោ័ អ៊ែ ក្រាន័ កា ប៉ាឡិ អ្លាត កាណុង ឡូះ ពឹង ស៊្រែ តីស អា បគ័ កេះ»។ អ៊ែ ផា នីណោ័ះ ខង អ៊ែ ឃឹត តង័ យូស៊ែប អន់ រ៉ាវ៉ាច់ កេះណោះ អ្យក់ សឹត ជឹន កា ពឹ អ៊ែ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ប៉ាគ់ យូស៊ែប ទឹល ប៉ាគ់ អន់ឌែ កេះ អន់ឌែ រ៉ុប រ៉ីស អាវ យូស៊ែប ពៀត ដាគ់ៗ ណោះ ");
INSERT INTO tpu_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","លូ ប៉ាឡិ អ៊ែ កាណុង ឡូះ។ ហះកា ឡូះ ណោះ អូ ទី ទៀក អុះ ស្វាត់ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","កេះណោះ អន់ឌែ អង់អ្វៃ សា សាណា ផាឌី ប៉ប័ ប៉ាណូស ចាក ប្រូ ម៉ោញ ក្រុំ ជិះ អូត ពឹះ ឡឹង ស្រុក កាឡាត។ អន់ឌែ ប៉ាទុក ឃឿង បោផូវ លូ ចារ័ អ៊្លង បោផូវ ឡាំ ប្រូ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","យូដា រ៉ះ លូ អុះ ម៉ី អ៊ែ ផា «ផា ពិន ប៉ាន់តោ័ អ្លាត អុះ ពិន អា លូ អោន សារ អូ ដាគ់ អា អូ ទី ខា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ពិ ពិន ប្រូ អ៊ែ កា មួត តោ ជែ ប៉ាន់តោ័ ខង អ៊ែ កា អុះ ពិន ដេល»។ អន់ឌែ កា ប៉្រគ័ ពួយ ប៉ានឹរ អ៊ែ តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ប៉ាគ់ ប៉ាណូស ចាក ប្រូ ណោះ ពឹះ ទឹល កេះ ម៉ី យូស៊ែប អ្យក់ ឡាច់ យូស៊ែប ឡឹង ឡូះ ប្រូ អន់ កា មួត ណោះ ខា ប៉្រាក់ ពៀរ ខាំ។ មួត ណោះ អ្យក់ យូស៊ែប ឡាំ ប្រូ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ប៉ាគ់ រូបេន សឹត ទឹល ប៉ាគ់ ចារ អន់ឌែ អ្វៃ អំពែ ហៃ កាណុង ឡូះ អូ ប៉ប័ យូស៊ែប កេះ អ៊ែ អុក ពុត ហ៊ែក ខោ អាវ អ៊ែ ទៅ។ ");
INSERT INTO tpu_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","កេះណោះ អ៊ែ ឡាំ រ៉ះ មួត អុះៗ អ៊ែ ផា «យូស៊ែប កាណុង ឡូះ ណោះ ហ៊្យង កេះ។ នីចម័ អាញ់ ចឹង ប៉្រគ័ អា ?» ");
INSERT INTO tpu_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","អន់ឌែ កា ប៉ាន់តោ័ ប៉ារ់ពេ ទោល ម៉ោញ កេះណោះ អ្យក់ អាវ យូស៊ែប ប៉ាពុល ពឹង ផាម ប៉ារ់ពេ។ ");
INSERT INTO tpu_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","កេះណោះ ជឹន អាវ ណោះ ប៉ាគ់ ពឹ អន់ឌែ លូ រ៉ះ ផា «ពឹ ! ញឹន ប៉ប័ អាវ អា ប៉ាគ់ តោ អីស ហៃៗ ត្រគ់ ញ៉ា អូ អាវ គន អីស»។ ");
INSERT INTO tpu_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","វគ័ យ៉ាកុប កា អន់ហ្នាល់ អាវ ណោះ ទឹប កាប ផា «អាវ គន អាញ់ តាទឹច ហង អា ចាបះ កា កាណាគ័ កាប់ សា អ៊ែ កេះ។ យូស៊ែប តោ័ កា កាណាគ័ ព្រី កាប់ សា តាទឹច ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","វគ័ យ៉ាកុប កា ហ៊ែក ខោ អាវ អ៊ែ ទៅ លូ អ្យក់ កាប៉ោ អន់តុក លូ អ្វៃ ឡាងត រ៉ាំបីស ទុញ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","គន សោ អ៊ែ ទឹប កាម៉ាក័ ទឹប អង់កាន់ ប៉ាណាំ គួប ឡាំ ប៉ាឡោម អ៊ែ ហះកា អ៊ែ អូ ចៃ អុះ។ អ៊ែ ញ៉ាំ សោក លូ កាប ផា «អាញ់ ចឹង អ្វៃ ឡាងត លើយ ទឹល ដារ់ អាញ់ តោ័ ពួយ គន អាញ់ និះទៅ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","កាប៉ាច់ យូស៊ែប មួត ចាក ប្រូ អ្យក់ ឡាំ ប្រូ អ៊ែ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ឃឺ ប្រូ អន់ កា ប៉ូទីផារ ឡាក់ ម៉ៃគ តាហាន ប៉ងកាន់ សាដាច់ អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ផះ រ៉ាំងវ៉ាង ណោះ យូដា ឡាច់ ឡឹង អុះ ម៉ី អ៊ែ ឡាំ អ្វៃ អន់ឌូ លូ ប៉ាណូស ម៉ោញ ដូវ សិច ហ៊ីរ៉ា ប៉ាគ់ ស្រុក អាឌូឡាំ។ ");
INSERT INTO tpu_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","អ្វៃ ពឹង ស្រុក ណោះ អ៊ែ ប៉ប័ អង់កាន់ រ៉ូះ សុនសាត កាណាន គន ស៊ូអា អ៊ែ កា ទី អង់កាន់ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","កាម៉ាញ់ អ៊ែ ណោះ កា ឡាកោ គៀម អ្វៃ ហាអុញ កើត គន កាម៉ាក័ ម៉ោញ យូដា អន់ សិច ផា អឺរ។ ");
INSERT INTO tpu_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ឡៃង ឡឹង ណោះ អ៊ែ គៀម ណាវ្គ អ្វៃ ហាអុញ កើត គន កាម៉ាក័ ម៉ោញ ណាវ្គ អ៊ែ អន់ សិច ផា អូណាន់។ ");
INSERT INTO tpu_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ឡៃង ឡឹង ណោះ អ៊ែ គៀម ម៉ោញ ទង ណាវ្គ អ្វៃ ហាអុញ កើត គន កាម៉ាក័ ណាវ្គ អ៊ែ អន់ សិច ផា សេឡា។ ផះ អ៊ែ អ្វៃ ហាអុញ ណោះ យូដា អ្វៃ ពឹង ស្រុក កេស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","ទុញ សាណាំ ឡឹង ណោះ យូដា ឡាំ កាណង័ លូ អង់កាន់ ម៉ោញ ដូវ សិច តាម៉ារ អន់ កា គន អ៊ែ អឺរ ទី។ ");
INSERT INTO tpu_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","អឺរ អ៊ែ ឡាក់ ប៉ាណូស អូ ដាគ់ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ អុះ។ ទឹល នីណោ័ះ ប‌៉្រ័ះ តាគ់ អន់តោ័ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ឡៃង ឡឹង ណោះ យូដា ប៉្រើ គន អ៊ែ អូណាន់ ផា «អីស អ្យក់ កា អីស ណាវ្គ អៃ អីស ណោះ ហោគ ម៉ាគ់ តូ ផូង័ វ៉ាច់ អន់ កា ម៉ី អីស តាម តាឡាប័ ឃើយ គុន ពិន»។ ");
INSERT INTO tpu_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","អូណាន់ អ៊ែ អ្លុ អន់តគ់ ផា គន ចឹង កើត ណោះ អូ ទី សិច ផូង័ វ៉ាច់ អ៊ែ អុះ។ ទឹល នីណោ័ះ រ៉ប់ អ៊ែ តៃប លូ អៃ អ៊ែ ណោះ អ៊ែ ប៉ាឡាច់ អ្លាត ទៀក គែង ឡីង ប៉ាគ់ តេះ ខង អ៊ែ អូ ចៃ តូ ផូង័ វ៉ាច់ អន់ កា ម៉ី អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","អ៊ែ ប៉្រគ័ នីណោ័ះ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ អុះ។ ទឹល នីណោ័ះ ប‌៉្រ័ះ កា តាគ់ អន់តោ័ អ៊ែ និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","ឡៃង ឡឹង ណោះ ណាវ្គ យូដា រ៉ះ លូ ម៉ាយ អ៊ែ តាម៉ារ ផា «អីស អ្វៃ អន់ត្រោ័ នីអៀ ហង។ ហះកា អីស សឹត អ្វៃ ប៉ាគ់ ហី ពឹ អីស តោ ហិ។ កូម័ គន អាញ់ សេឡា ប៉ាញ័ តាម័ ហិ ផះ ណោះ អាញ់ ចឹង អន់ អ៊ែ ទី អីស ណាវ្គ»។ អ៊ែ កាប នីណោ័ះ ខង អ៊ែ អ្យូគ កា គន អា ចឹង តោ័ ឡាក់ កា ម៉ី អ៊ែ ដេល។ តាម៉ារ កា សឹត អ្វៃ លូ ពឹ អ៊ែ ទៅ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ទុញ សាណាំ ឡឹង ណោះ កាម៉ាញ់ យូដា ឡាក់ គន ស៊ូអា ណោះ អ៊ែ តោ័។ ប៉ាគ់ យូដា ប៉ាញ់សះ អន់ត្រោ័ កេះ អ៊ែ កា ឡាំ ប៉ាគ់ ស្រុក ធីមណា អន់ឌូ លូ គួប អ៊ែ វគ័ ហ៊ីរ៉ា ភឿ ឡាំ ហៃ មួត កាត់ សក់ ចៀម អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","ពូ ឡាំ រ៉ះ លូ តាម៉ារ ផា «ពឹ អន់ហ្នី អីស ឡាំ កាត់ សក់ ចៀម ប៉ាគ់ ស្រុក ធីមណា»។ ");
INSERT INTO tpu_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","តាម៉ារ អ៊ែ អ្លុ អន់តគ់ ផា សេឡា ប៉ាញ័ តាម័ កេះ ហះកា យូដា អូ ឡាំ អ្យក់ អ៊ែ អន់ កា សេឡា ប៉្រគ័ កាម៉ាញ់។ ទឹល នីណោ័ះ អ៊ែ កា រ៉ីស អ្លាត អញ់ជុ អាវ អន់ត្រោ័ អ៊ែ ណោះ អ្យក់ អញ់ជុ អាវ អន់ទៀគ ណាវ្គ លូ អ្យក់ កាណាត់ មុង តល័ សាក្លុំ ម៉ូះ ម៉ាត់ អូ អន់ ពូ អន់ហ្នាល់។ កេះណោះ ឡាំ អ្វៃ ហះ អំប៉ារ ទ្រួក ម៉ុត ពឹង ស្រុក អេនែម រទ្រង ឡាំ ប៉ាគ់ ធីមណា។ ");
INSERT INTO tpu_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ផះ យូដា ប៉ប័ តាម៉ារ អង់អ្វៃ ហះ ទ្រង អ៊ែ សាម៉គ័ កា អង់កាន់ ម៉ាលេង។ អ៊ែ អូ អន់ហ្នាល់ អុះ ខង តាម៉ារ កាត្រើគ ម៉ូះ ម៉ាត់ លូ កាណាត់ មុង។ ");
INSERT INTO tpu_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","អ៊ែ កាលែង គែង តាម៉ារ លូ ជៀក ផា «ពិ តៃប លូ អាញ់»។ អ៊ែ អូ អ្លុ អន់តគ់ អុះ កា ម៉ាយ អ៊ែ ទៅ។ តាម៉ារ ផា «ផា តៃប លូ អីស ញ៉ា អីស ចឹង អន់ កា អាញ់ ?» ");
INSERT INTO tpu_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","អ៊ែ តើល ផា «អាញ់ ចឹង ប៉ាហ្យើ គន ប៉ារ់ពេ ម៉ោញ អន់ កា អីស»។ តាម៉ារ តើល «អឺះ ចៃ ឡគ ហះកា អីស ត្រគ់ ប៉ាក់ កាណាគ័ ញ៉ា ម៉ោញ អន់ទ្រួល ហិ សំ អាញ់ ចឹង ទី គន ប៉ារ់ពេ ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","អ៊ែ តើល ផា «អីស ប៉ិច កា អាញ់ ប៉ាក់ លូ កាណាគ័ ញ៉ា ?» តាម៉ារ តើល ផា «អីស មប ត្រា ទឹប កាស៊ែ អ៊ែ ណោះ លូ អ៊្លង កាទូង អីស ចឹក ណោះ អន់ កា អាញ់»។ យូដា កា មប កាណាគ័ ទិណោ័ះ អន់ កា តាម៉ារ តាទឹច កេះណោះ អ៊ែ តៃប លូ តាម៉ារ។ កេះណោះ តាម៉ារ សឹត ប៉ាគ់ ហី រ៉ីស អ្លាត កាណាត់ មុង ឡឹង ម៉ូះ ម៉ាត់ អ៊ែ អ្យក់ អន់តុក អញ់ជុ អាវ អន់ត្រោ័ អ៊ែ ទៅ ណាវ្គ។ ឡៃង ឡឹង ណោះ តាម៉ារ កា ឡាកោ គៀម លូ អ៊ែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","យូដា កា ប៉ាហ្យើ គន ប៉ារ់ពេ ពឹង គួប អ៊ែ ហ៊ីរ៉ា អន់ កា តាម៉ារ ភឿ ហ្វាយ សឹត កាណាគ័ អ៊ែ ប៉ាក់ ណោះ ហះកា គួប អ៊ែ ណាំង អង់កាន់ ណោះ ហះ ចំ កា អូ ប៉ប័ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","អ៊ែ អំប៉ញ់ លូ កាំឡាំង ស្រុក ណោះ ផា «អង់កាន់ ម៉ាលេង បក់ អ្វៃ ហះ ទ្រង ម៉ុត ពឹង ស្រុក អេនែម ណោះ ពែ អ៊ែ អ្វៃ ប៉ាគ់ ចំ ?» ពូ តើល ផា «ពឹង ស្រុក អា អូ ទី អង់កាន់ ម៉ាលេង អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","កេះណោះ អ៊ែ សឹត ប៉ាគ់ យូដា ណាវ្គ លូ រ៉ះ ផា «អាញ់ ណាំង អង់កាន់ ណោះ អូ ប៉ប័ អុះ។ កាំឡាំង ស្រុក ណោះ រ៉ះ កា អាញ់ ផា កាណុង ស្រុក អន់ឌែ អូ ឃើយ ទី អង់កាន់ ម៉ាលេង អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","យូដា តើល ផា «ទឹល អីស ណាំង អូ ប៉ប័ នីចម័ ចឹង ប៉្រគ័ ? អន់ កា អ៊ែ រ៉ាន់ដាប់ ហះ ណោះ ហង កាណាគ័ អាញ់ ណោះ។ អាញ់ ប៉ាហ្យើ គន ប៉ារ់ពេ កេះ ដេល ទឹល ណាំង អ៊ែ អូ ប៉ប័ ជែ អំប៉ញ់ ណាវ្គ ហង អន់ទៀ តាយួស កា កាំឡាំង ស្រុក»។ ");
INSERT INTO tpu_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ប៉ៃង ខៃ ឡឹង ណោះ ពូ ឡាំ រ៉ះ កា យូដា ផា «ម៉ាយ អីស តាម៉ារ អ៊ែ ប៉្រគ័ លូ កាម៉ាក័ កិញអៀ អ៊ែ ឡាកោ គៀម កេះ»។ យូដា តើល ផា «អូស ឡាច់ អ៊ែ ប៉ាគ់ ឡីង កេះណោះ ពុះ អ៊ែ ទឹប រ៉ីស ណោះ ហង ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","ផះ ពូ ជៀក តាម៉ារ ឡាច់ ប៉ាគ់ ឡីង អ៊ែ ប៉្រើ ពូ ឡាំ រ៉ះ លូ យូដា ផា «អាញ់ គៀម លូ តាំងឡា កាណាគ័ ទិ អា ហង។ ហគ់ អីស ហៃៗ ត្រា ទឹប កាស៊ែ អា លូ អ៊្លង កាទូង អា កាណាគ័ ពឿ អា ?» ");
INSERT INTO tpu_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","យូដា កា អន់ហ្នាល់ កាណាគ័ អ៊ែ ណោះ លូ កាប ផា «អ៊ែ ដាគ់ ត្រង់ តាទឹច ហះកា អាញ់ ប៉្រគ័ យច ខង អាញ់ អូ ទី ឡាំ អ្យក់ អ៊ែ អន់ កា គន អាញ់ សេឡា ប៉្រគ័ កាម៉ាញ់»។ គឹត ណោះ ហង យូដា អូ តៃប កេះ លូ តាម៉ារ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","ប៉ាគ់ ក្យាម័ ចឹង អ្វៃ ហាអុញ ពូ អ្លុ អន់តគ់ ផា កាណុង វ៉ាច់ តាម៉ារ ណោះ ទី គន ម៉ាត់ ប៉្វាន់។ ");
INSERT INTO tpu_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ប៉ាគ់ អ៊ែ អ្វៃ ហាអុញ ទី គន ម៉ោញ ឡាច់ តី អន់ទ្រួល យ៉ាគ់ប៊យ កា អ្យក់ ព្រៀយ កាហ្រី កត់ តី សាស្វា ណោះ លូ កាប ផា «សាស្វា អា កើត អន់ទ្រួល»។ ");
INSERT INTO tpu_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ហះកា សាស្វា ណោះ អ្យក់ ម៉ុត តី កាណុង វ៉ាច់ ណាវ្គ កេះណោះ ម៉ី អ៊ែ កា ឡាច់ អ៊ែ ណាវ្គ។ យ៉ាគ់ប៊យ ផា កា សាស្វា ណោះ «អីស អា តាប៉ីត ឡាច់ អន់ទ្រួល»។ អន់ឌែ អន់ សិច គន ណោះ ផា ពែរេះ ។ ");
INSERT INTO tpu_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","កេះណោះ អុះ អ៊ែ ឡាច់ អ៊ែ ណាវ្គ ទឹប ទី ព្រៀយ កាហ្រី ពឹង តី អ៊ែ ណោះ ហង។ អន់ឌែ អន់ សិច គន ណោះ ផា សេរ៉ះ ។ ");
INSERT INTO tpu_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","មួត ចាក ប្រូ ប៉ាណាំ យូស៊ែប ឡាំ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប កេះណោះ ប្រូ អន់ កា សុនសាត អ៊ីស៊ីប សិច ប៉ូទីផារ ឡាក់ ម៉ៃគ តាហាន ប៉ងកាន់ សាដាច់ អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","ផះ យូស៊ែប អ្វៃ ប៉ាគ់ ហី ពឹ តាំងឡា អ៊ែ ឡាក់ សុនសាត អ៊ីស៊ីប ប‌៉្រ័ះ ប៊កកាតយ័ កា អ្វៃ រ៉ាំងហៃ យូស៊ែប ដេល។ ង៉ារ ញ៉ា ឡាក់ អ៊ែ ប៉្រគ័ ស៊ុត កា ដាគ់ ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","ពឹ តាំងឡា យូស៊ែប ប៉ប័ ផា គ្រឹប ង៉ារ អ៊ែ ប៉្រគ័ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ ដាគ់ ទិណោ័ះ ញន កា ប‌៉្រ័ះ អ្វៃ អន់ឌូ លូ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","យូស៊ែប ត្រគ់ ពុត ប៉ូទីផារ ខាក់ អ៊ែ កា អន់ យូស៊ែប ប៉្រគ័ ទុច កានឹង រ៉ាំងហៃ ហី ក្រាន លូ រ៉ាស អំប៉ាស ម៉ះ អ៊ែ ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","គឹត អ៊ែ អន់ យូស៊ែប រ៉ាំងហៃ ហី ក្រាន លូ រ៉ាស អំប៉ាស អ៊ែ ទិណោ័ះ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ដាគ់ កា ខាប់ខួ ប៉ូទីផារ ញន កា យូស៊ែប កាណាគ័ អ៊ែ ស៊ុត កា ដាគ់ ទឹប ពឹង ហី ទឹប ប៉ាគ់ ម៉ីរ។ ");
INSERT INTO tpu_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","អ៊ែ មប ទិ កាណាគ័ ញ៉ា ឡាក់ អ៊ែ ទី អន់ កា យូស៊ែប រ៉ាំងហៃ អ៊ែ តាំងឡា អូ វ៉ឹនវ៉ាយ ឡឹង កាន ញ៉ា ណាវ្គ អុះ ហ្វាស ឡឹង កាន សង់ សា អ៊ែ ទៅ។ យូស៊ែប ឡាកោ អ៊ែ ដាគ់ ឡាយ៉ាម័ ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ប៉ាគ់ អ៊ែ អ្វៃ ពឹង ហី ណោះ ទុញ កេះ កាម៉ាញ់ ប៉ូទីផារ ហៃ អ៊ែ លើយ លូ ប៉ិច កា អ៊ែ ខាក់ កាម៉ាញ់ ប៉ូទីផារ ជៀក អ៊ែ ផា «ចុ តៃប លូ អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","ហះកា យូស៊ែប អូ ចៃ អុះ លូ តើល ផា «ពឹ តាំងឡា អាញ់ អ៊ែ មប ទិ កាណាគ័ ញ៉ា ឡាក់ អ៊ែ ទី អន់ អាញ់ រ៉ាំងហៃ។ អ៊ែ តាំងឡា អូ វ៉ឹនវ៉ាយ ឡឹង ង៉ារ ញ៉ា ណាវ្គ អុះ កាណុង ហី ក្រាន អា។ ");
INSERT INTO tpu_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","កាណុង ហី អា អូ ទី ពឿ តីស ឡឹង អាញ់ អុះ។ ទិ កាណាគ័ ពឹង ហី អ៊ែ មប អន់ កា អាញ់ យរ ហះកា អ៊ែ អូ ទី មប អីស អន់ កា អាញ់ អុះ ខង អីស កាម៉ាញ់ អ៊ែ។ ទឹល នីណោ័ះ សារ អូ ដាគ់ នែវ អា អាញ់ អូ ចៃ ប៉្រគ័ អុះ ផា ប៉្រគ័ នែវ អា ចឹង យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","អង់កាន់ ណោះ ប៉ាឡោម យូស៊ែប ជៀក តៃប លូ អ៊ែ រ៉ប់ ដារ់ ហះកា យូស៊ែប អូ ចៃ តៃប លូ អ៊ែ អុះ លូ អូ ចៃ អ្វៃ ក្យាម័ អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ប៉ាគ់ ដារ់ អន់តីគ យូស៊ែប ម៉ុត ប៉្រគ័ ង៉ារ កាណុង ហី។ ផះ អ៊ែ អ្វៃ ប៉្រគ័ ង៉ារ ណោះ អូ ទី ប៉ាណូស ពឿ អ្វៃ កាណុង ហី ណោះ អុះ ទី ដឹង កាម៉ាញ់ ប៉ូទីផារ។ ");
INSERT INTO tpu_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","អ៊ែ កា រ៉ុប ទុង អញ់ស៊ែង យូស៊ែប អន់តុក លូ ជៀក ផា «ចុ តៃប លូ អាញ់»។ យូស៊ែប សាំប៉ត់ តារ៉ីស អ្លាត អញ់ស៊ែង សាតាក់ ឡាច់ ប៉ាគ់ ឡីង។ ");
INSERT INTO tpu_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","អង់កាន់ ណោះ ហៃ កា យូស៊ែប សាតាក់ ឡាច់ ប៉ាគ់ ឡីង លូ អ្លាត អញ់ស៊ែង អ្វៃ ពឹង តី អ៊ែ នីណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","អ៊ែ កា អង់ហ្យាំង ស៊្រែក អើ មួត ទុច លូ រ៉ះ ផា «អន់ដីស ហៃ អា ក្លោ អាញ់ តាច់ សុនសាត ហេព្រឺ អា ប៉្រគ័ ទុច កិញអៀ អ៊ែ ប៉ិច បឺង៉ាយ ពិន។ អ៊ែ ឃឹត ចឹង ម៉ុត ទម អាញ់ ហះកា អាញ់ អង់ហ្យាំង តុត ពុត។ ");
INSERT INTO tpu_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","អ៊ែ កាតាំង អាញ់ អង់ហ្យាំង អើ ពូ អ៊ែ សាតាក់ ឡាច់ ប៉ាគ់ ឡីង អ្លាត អញ់ស៊ែង ពឹង ចារ អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","អ៊ែ រ៉ាន់ដាប់ អញ់ស៊ែង យូស៊ែប ណោះ ពឹង ចារ អ៊ែ លើយ ទឹល ក្លោ សឹត ប៉ាគ់ ហី។ ");
INSERT INTO tpu_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","អ៊ែ រ៉ះ សារ ទៅ កា ក្លោ អ៊ែ ផា «ទុច សុនសាត ហេព្រឺ ឡាក់ អីស តាច់ ណោះ អ៊ែ ម៉ុត ចឹង ទម អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","អ៊ែ កាតាំង អាញ់ អង់ហ្យាំង អើ ពូ តុត ពុត អ៊ែ សាតាក់ ឡាច់ ប៉ាគ់ ឡីង អ្លាត អញ់ស៊ែង ពឹង ចារ អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","ប៉ូទីផារ អ៊ែ កាតាំង កាម៉ាញ់ អ៊ែ រ៉ះ ផា «ទុច អីស ប៉្រគ័ នែវ អា កា អាញ់» អ៊ែ អឺក ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","អ៊ែ ប៉្រើ ពូ រ៉ុប យូស៊ែប ចៃគ ពឹង ខុក ចារ ពូ គ្រន មួត ថូត បក់ ប៉្រគ័ យច លូ សាដាច់។ ផះ យូស៊ែប ត្រគ់ ខុក ");
INSERT INTO tpu_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","ប‌៉្រ័ះ ប៊កកាតយ័ កា អ្វៃ រ៉ាំងហៃ អ៊ែ ដេល លូ តាំបាង ផា អ៊ែ អូ អ្លាត ប៉ិច កា យូស៊ែប អុះ។ អ៊ែ ប៉្រគ័ អន់ ម៉ៃគ រ៉ាំងហៃ ខុក ប៉ាញ័ ពុត កា យូស៊ែប។ ");
INSERT INTO tpu_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ទឹល នីណោ័ះ ម៉ៃគ រ៉ាំងហៃ ខុក ប៉្រើ យូស៊ែប រ៉ាំងហៃ មួត ថូត លូ ង៉ារ កាណុង ខុក ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ម៉ៃគ រ៉ាំងហៃ ខុក អូ វ៉ឹនវ៉ាយ ឡឹង កានង៉ាន ញ៉ា ឡាក់ អ៊ែ មប អន់ កា យូស៊ែប ប៉្រគ័ ណោះ អុះ ខង ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ អន់ឌូ លូ យូស៊ែប។ គ្រឹប កានង៉ាន ញ៉ា ឡាក់ យូស៊ែប ប៉្រគ័ ប‌៉្រ័ះ ប៉្រគ័ អន់ ដាគ់ ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ឡៃង ឡឹង ណោះ ទី ប៉ាណូស ពៀរ ដូវ ប៉្រគ័ ង៉ារ កា សាដាច់ អ៊ីស៊ីប អន់ឌែ ប៉្រគ័ យច ពុត សាដាច់។ ម៉ោញ ដូវ ម៉ៃគ មួត អន់ទឺប ចក តាពែ អន់ កា សាដាច់ ម៉ោញ ដូវ ណាវ្គ ម៉ៃគ មួត ប៉្រគ័ ណុំ ប៉ាំង អន់ កា សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","សាដាច់ អឺក ខាក់ កា មួត ពៀរ ដូវ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","អ៊ែ ប៉្រើ ពូ រ៉ុប អន់ឌែ ចៃគ ពឹង ខុក ឡាក់ ខុក ម៉ៃគ តាហាន ប៉ងកាន់ សាដាច់ រ៉ាំងហៃ។ យូស៊ែប កា អ្វៃ កាណុង ខុក ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ម៉ៃគ តាហាន ប៉ងកាន់ សាដាច់ មប មួត ពៀរ ដូវ ណោះ អន់ កា យូស៊ែប រ៉ាំងហៃ។ ឡៃង ឡឹង អន់ឌែ អ្វៃ កាណុង ខុក ទុញ ដារ់ កេះ ");
INSERT INTO tpu_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","មួត ពៀរ ដូវ ណោះ អន់ឌែ អំប៉ោ ទិ អន់ឌែ ពៀរ ដូវ កាណុង ម៉ោញ ម៉ាំង ណោះ ហង ហះកា អំប៉ោ តាងៗ ឡឹង គួប ប៉ាណោ កា តាង ឡឹង គួប ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ប៉ាគ់ តារ កាំលឺ យូស៊ែប ឡាំ ប៉ាគ់ ចារ អន់ឌែ ប៉ប័ អន់ឌែ អ្វៃ សាំងអយ។ ");
INSERT INTO tpu_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","យូស៊ែប អំប៉ញ់ អន់ឌែ ផា «ដារ់ អា ញ៉ា ត្រគ់ អន់ដីស អ្វៃ សាំងអយ នីអៀ ?»។ ");
INSERT INTO tpu_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","អន់ឌែ តើល ផា «ម៉ាំង ពែ ញឹន អំប៉ោ ហះកា អ្វៃ ពឹង ខុក អា អូ ទី ពឿ ចឹង អ្លុ រ៉ះ សារ អំប៉ោ អា ទី ប៉ាណោ នីចម័ អុះ»។ យូស៊ែប រ៉ះ កា អន់ឌែ ផា «ទី ដឹង ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង អ្លុ រ៉ះ ឡឹង ប៉ាណោ សារ អំប៉ោ ណោះ។ ប៉រ់ អន់ដីស រ៉ះ ហៃ កា អាញ់ នីចម័ អន់ដីស អំប៉ោ ណោះ ?» ");
INSERT INTO tpu_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ប៉ាណូស បក់ អន់ទឺប ចក តាពែ កា សាដាច់ អ៊ែ រ៉ះ កា យូស៊ែប ផា «អាញ់ អំប៉ោ ប៉ប័ តើម អង់កាច ម៉ោញ តើម ហះ ង៉ីរ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","តើម ប៉្លៃ អង់កាច ណោះ ទី តាំងកង់ ប៉ៃង កេះណោះ ចាត់ ឡាំបុង ទី ប៉ាកាវ ប៉្លៃ ទុំ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","អាញ់ ចឹក ចក សាដាច់ កេះណោះ អាញ់ អ្លេះ ប៉្លៃ អង់កាច ទុំ រ៉ូត័ ចៃគ ពឹង ចក អន់ទឺប អន់ កា សាដាច់»។ ");
INSERT INTO tpu_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","យូស៊ែប រ៉ះ កា អ៊ែ ផា «សារ អីស អំប៉ោ ណោះ ប៉ាណោ អ៊ែ នីអៀ ទី តាំងកង់ ប៉ៃង ណោះ ប៉ៃង ដារ់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","អ្វៃ ប៉ៃង ដារ់ ណាវ្គ ឃឺ សាដាច់ ចឹង តោះ ឡាច់ អីស អន់ ប៉្រគ័ ង៉ារ អន់ទឺប ចក តាពែ អន់ កា អ៊ែ ណាវ្គ ឡាក់ កា អីស ឃើយ ប៉្រគ័ ផះ អន់ទ្រួល ពែ ទៅ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","ហះកា ប៉ាគ់ អីស អ្វៃ ដាគ់ សាណុក សាវ៉ាក កេះ អីស ជែ ពឹល អាញ់ ដេល អ៊ែ។ ប៉រ់ អីស រ៉ះ លូ សាដាច់ អន់ អ៊ែ អ្លុ ឡឹង សារ អាញ់ ត្រគ់ ខុក អា អន់ អ៊ែ តោះ ឡាច់ អាញ់ ឡឹង ខុក អា ណើ ");
INSERT INTO tpu_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ខង ពូ រ៉ុប អាញ់ ឡឹង ស្រុក អាញ់ អ្យក់ ឡាំ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប អា។ អាញ់ អ្វៃ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប អា កា អូ ទី ប៉្រគ័ យច ញ៉ា ដេល ពូ រ៉ុប ចៃគ ខុក អាញ់ អា»។ ");
INSERT INTO tpu_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","ប៉ាណូស បក់ ប៉្រគ័ ណុំ ប៉ាំង អន់ កា សាដាច់ ណោះ កាតាំង យូស៊ែប រ៉ះ ប៉ាណោ សារ អំប៉ោ កា ប៉ាណូស បក់ អន់ទឺប ចក តាពែ កា សាដាច់ ណោះ ដាគ់ លូ ត្រគ់ ពុត។ អ៊ែ កា រ៉ះ ឡឹង សារ អ៊ែ អំប៉ោ កា យូស៊ែប ដេល អ៊ែ ផា «កាប៉ាច់ អាញ់ អំប៉ោ តល័ ណុំ ប៉ាំង ប៉ៃង តាដង់ ពឹង កល់ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ពឹង តាដង់ ទ្រង អំប៉ាំង ឡឹង ពូ ទី ណុំ គ្រឹប នែវ ឡាក់ ណុំ សាដាច់ អ៊ីស៊ីប ឃើយ សា ហះកា ទី សៃម ឡាំ ចោះ សា ណុំ ពឹង តាដង់ អំប៉ាំង កល់ អាញ់ ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","យូស៊ែប រ៉ះ កា អ៊ែ ផា «សារ អីស អំប៉ោ ណោះ ប៉ាណោ អ៊ែ នីអៀ តាដង់ ប៉ៃង ណោះ ប៉ៃង ដារ់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","អ្វៃ ប៉ៃង ដារ់ ណាវ្គ សាដាច់ ចឹង តោះ ឡាច់ អីស ប៉្រើ ពូ កាសិត អ្លាត កល់ កេះណោះ កត់ អន់ទល ឡាកោ អីស ពឹង ក្យង់ អ៊្លង សៃម ចឹង ឡាំ ចោះ សា ប៉ាំងឡៃ អីស»។ ");
INSERT INTO tpu_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ប៉ៃង ដារ់ ឡឹង ណោះ ត្រគ់ ដារ់ ពូ អៃត សា ប៊ុន កាណើត សាដាច់ អ៊ីស៊ីប សាដាច់ អើ មួត ប៉្រគ័ កាន លូ អ៊ែ។ អ៊ែ កា ប៉្រើ ពូ ឡាំ តោះ ឡាច់ ម៉ៃគ មួត អន់ទឺប ចក តាពែ លូ ម៉ៃគ មួត ប៉្រគ័ ណុំ ប៉ាំង អន់ អ្វៃ ហះ ង៉ីរ មួត ប៉្រគ័ កាន ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","អ៊ែ ប៉្រើ ប៉ាណូស បក់ អន់ទឺប ចក តាពែ ណោះ អន់ អ៊ែ ប៉្រគ័ ង៉ារ អន់ទឺប ចក តាពែ តៃល ទៅ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ហះកា សាដាច់ ប៉្រើ ពូ អ្យក់ ប៉ាណូស បក់ ប៉្រគ័ ណុំ ប៉ាំង ណោះ កត់ អន់ទល ឡាកោ ពឹង ក្យង់ អ៊្លង ត្រគ់ ឡាក់ កា ប៉ានឹរ យូស៊ែប រ៉ះ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","កាប៉ាច់ ប៉ាណូស បក់ អន់ទឺប ចក តាពែ កា សាដាច់ ណោះ អ៊ែ អូ កាចាំង កា យូស៊ែប អុះ អ៊ែ ពឹល ខ្លឹប ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ពៀរ សាណាំ ឡឹង ណោះ ណាវ្គ សាដាច់ អ៊ីស៊ីប អ៊ែ អំប៉ោ អន់តាវ ហះ ហាង តាំងលេ នីល។ ");
INSERT INTO tpu_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","អ៊ែ ប៉ប័ រ៉ក់ យ៉ង់ តាំប៉ើះ កល់ ដាគ់ តីស តង់ ឡាច់ ឡឹង ទៀក តាំងលេ អ្វៃ សា សាម៉ោង រហាង។ ");
INSERT INTO tpu_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","កេះណោះ អ៊ែ ប៉ប័ រ៉ក់ យ៉ង់ តាំប៉ើះ កល់ ណាវ្គ រ៉ាំងកៃគ ខាក់ អ្វៃ ដឹង កាន់តីង លូ អង់ការ ឡាច់ ឡឹង ទៀក តាំងលេ អ្វៃ រហាង ក្យាម័ រ៉ក់ តង់ៗ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ហះកា រ៉ក់ យ៉ង់ រ៉ាំងកៃគ ណោះ ឡាវ៉ាន័ រ៉ក់ ដាគ់ តីស តង់ ណោះ ទិ ប្លី កេះណោះ សាដាច់ សាទឹរ។ ");
INSERT INTO tpu_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","កេះណោះ អ៊ែ ហ្លាក់ ណាវ្គ អ៊ែ អំប៉ោ ប៉ប័ ពៀ ម៉ោញ តើម ទី ប៉ាយ៉ក័ តាំប៉ើះ ដាគ់ ឡាកោ រ៉ាយ៉ូគ័។ ");
INSERT INTO tpu_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","កេះណោះ ទី ពៀ តាំប៉ើះ ប៉ាយ៉ក័ ណាវ្គ ឡាច់ ឡឹង តើម ណោះ ដេល។ ប៉ាយ៉ក័ ណោះ កាសៃង កាខាក់ អ្វៃ ដឹង អញ់ជែប ដោះ ញន កា ត្រគ់ ខ្យាល តុ។ ");
INSERT INTO tpu_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ប៉ាយ៉ក័ ពៀ កាសៃង ណោះ ឡាវ៉ាន័ ប៉ាយ៉ក័ ពៀ ដាគ់ ឡាកោ រ៉ាយ៉ូគ័ ណោះ ទិ ប្លី ឡូត កេះណោះ អ៊ែ សាទឹរ លូ ឃឹត ផា «អូ អាញ់ អំប៉ោ ឡា»។ ");
INSERT INTO tpu_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ប៉ាគ់ តារ កាំលឺ សាដាច់ អ៊ែ ទី កាន វ៉ឹនវ៉ាយ កាណុង ពុត ខាក់ អ៊ែ កា ប៉្រើ ពូ ឡាំ អ្យក់ មួត គ្រូ ហ្យាំង សាឡាច់ ទិឌូ អ្វៃ ពឹង ប៉ាថេត អ៊ីស៊ីប អន់ ពឹះ ប៉ាគ់ ចារ អ៊ែ។ កេះណោះ អ៊ែ រ៉ះ សារ អ៊ែ អំប៉ោ កា មួត ណោះ ហះកា អូ ទី ពឿ អ្លុ រ៉ះ ប៉ាណោ អ៊ែ អំប៉ោ ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","កេះណោះ ម៉ៃគ មួត អន់ទឺប ចក តាពែ រ៉ះ លូ សាដាច់ ផា «ដារ់ អា អាញ់ ប៉រ់ ឡាប់ ញម សារ អាញ់ ប៉្រគ័ យច ពែ។ ");
INSERT INTO tpu_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ផះ អីស អឺក កា មួត ទុច អីស ពែ លូ អីស ប៉្រើ ពូ រ៉ុប ញឹន ពៀរ ដូវ ចៃគ ពឹង ខុក ប៉ាគ់ ចារ ម៉ៃគ តាហាន ប៉ងកាន់ អីស តោ ពែ ");
INSERT INTO tpu_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ញឹន ពៀរ ដូវ អំប៉ោ ដឹង ម៉ោញ ម៉ាំង ណោះ ហង ហះកា ញឹន អំប៉ោ តាងៗ ឡឹង គួប ប៉ាណោ ណោះ កា តាងៗ ឡឹង គួប ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","កាណុង ខុក ណោះ ទី តាតាម័ សុនសាត ហេព្រឺ ម៉ោញ ដូវ អ៊ែ កេះ ទុច ម៉ៃគ តាហាន បក់ ប៉ងកាន់ អីស។ ញឹន រ៉ះ សារ អំប៉ោ កា អ៊ែ កេះណោះ អ៊ែ រ៉ះ ប៉ាណោ ញឹន អំប៉ោ ណោះ តាងៗ ឡឹង គួប។ ");
INSERT INTO tpu_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ឡៃង ឡឹង ណោះ ទី សារ កើត ពឹះ ត្រគ់ ឡាក់ កា អ៊ែ រ៉ះ តាទឹច។ កាប៉ាច់ អាញ់ អីស អន់ ប៉្រគ័ ង៉ារ តៃល ទៅ ណាវ្គ។ កាប៉ាច់ ប៉ាណូស ប៉្រគ័ ណុំ ប៉ាំង អីស ប៉្រើ ពូ កត់ អន់ទល ពឹង ក្យង់ អ៊្លង»។ ");
INSERT INTO tpu_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","សាដាច់ កាតាំង នីណោ័ះ កា ប៉្រើ ពូ ឡាំ អ្យក់ យូស៊ែប ពូ កា តោះ ឡាច់ យូស៊ែប ឡឹង ខុក ស៊្រសៗ។ អ៊ែ កា ប៉្លេះ ខោ អាវ លូ កូរ័ សក់ ពុក កេះណោះ ឡាំ ប៉ាគ់ ចារ សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","សាដាច់ អ៊ីស៊ីប រ៉ះ កា យូស៊ែប ផា «ម៉ាំង ពែ អាញ់ អំប៉ោ ហះកា អូ ទី ពឿ អ្លុ រ៉ះ ប៉ាណោ អាញ់ អំប៉ោ ណោះ អុះ។ ហះកា អាញ់ កាតាំង ពូ រ៉ះ ផា អីស អ្លុ រ៉ះ ឡឹង ប៉ាណោ ពូ អំប៉ោ»។ ");
INSERT INTO tpu_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","យូស៊ែប តើល សាដាច់ ផា «អូ ត្រគ់ អាញ់ អុះ អ្លុ រ៉ះ ឡឹង ប៉ាណោ សារ អំប៉ោ ណោះ ទី ដឹង ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង អ្លុ រ៉ះ ប៉ាណោ ណោះ អន់ កា អីស ម៉ាគ់ អីស ចឹង អ្វៃ សាណុក»។ ");
INSERT INTO tpu_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","កេះណោះ សាដាច់ រ៉ះ កា យូស៊ែប ផា «អាញ់ អំប៉ោ អាញ់ អន់តាវ ហះ ហាង តាំងលេ នីល។ ");
INSERT INTO tpu_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","អាញ់ ប៉ប័ រ៉ក់ យ៉ង់ តាំប៉ើះ កាតុ ដាគ់ តីស តង់ ឡាច់ ឡឹង ទៀក តាំងលេ អ្វៃ សា សាម៉ោង រហាង។ ");
INSERT INTO tpu_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","កេះណោះ ទី រ៉ក់ យ៉ង់ តាំប៉ើះ កាតុ ណាវ្គ រ៉ាំងកៃគ អ៊ក កាលក អ្វៃ ដឹង កាន់តីង លូ អង់ការ ឡាច់ ឡឹង ទៀក តាំងលេ អ្វៃ រហាង ដេល។ ពឹង ប៉ាថេត អ៊ីស៊ីប អា អាញ់ អូ ឃើយ ប៉ប័ ទី រ៉ក់ អ៊ក នីណោ័ះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","រ៉ក់ រ៉ាំងកៃគ អ៊ក អ្វៃ ដឹង កាន់តីង លូ អង់ការ ណោះ ឡាវ៉ាន័ សា រ៉ក់ តីស តង់ ណោះ ទិ ប្លី ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","យ‌៉័ះ រ៉ក់ រ៉ាំងកៃគ ឡាវ៉ាន័ សា រ៉ក់ តីស តង់ ទិ កាណុង វ៉ាច់ កាតាម ហះកា អន់ឌែ អូ ទី តីស តង់ អុះ អ្វៃ កា រ៉ាំងកៃគ និះទៅ ណោះ ហង។ កេះណោះ អាញ់ កា សាទឹរ។ ");
INSERT INTO tpu_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","កេះណោះ អាញ់ ហ្លាក់ ណាវ្គ អំប៉ោ ប៉ប័ ពៀ ម៉ោញ តើម ទី ប៉ាយ៉ក័ តាំប៉ើះ ដាគ់ ឡាកោ រ៉ាយ៉ូគ័។ ");
INSERT INTO tpu_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","កេះណោះ អាញ់ ប៉ប័ ពៀ តាំប៉ើះ ប៉ាយ៉ក័ ឡាច់ ឡឹង តើម ណោះ ដេល កាសៃង ខាក់ អ្វៃ ដឹង អញ់ជែប ដោះ ញន កា ត្រគ់ ខ្យាល តុ។ ");
INSERT INTO tpu_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ពៀ កាសៃង ណោះ ឡាវ៉ាន័ ពៀ ដាគ់ ឡាកោ រ៉ាយ៉ូគ័ ណោះ ទិ។ អាញ់ រ៉ះ សារ អាញ់ អំប៉ោ អា កា មួត គ្រូ ដេល ហះកា អូ ទី ពឿ អ្លុ រ៉ះ ប៉ាណោ ណោះ កា អាញ់ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","យូស៊ែប រ៉ះ កា សាដាច់ ផា «សារ អីស អំប៉ោ ទិ ពៀរ ណោះ ប៉ាណោ និះទៅ ឃឺ ប‌៉្រ័ះ ប៊កកាតយ័ តាំបាង អន់ អីស អ្លុ ឡឹង ង៉ារ ឡាក់ អ៊ែ ចឹង ប៉្រគ័។ ");
INSERT INTO tpu_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","រ៉ក់ យ៉ង់ ដាគ់ តីស តង់ តាំប៉ើះ កាតុ ណោះ ឃឺ តាំប៉ើះ សាណាំ។ ពៀ ដាគ់ ឡាកោ រ៉ាយ៉ូគ័ តាំប៉ើះ ប៉ាយ៉ក័ ណោះ កា តាំប៉ើះ សាណាំ ដេល។ សារ អំប៉ោ ទិ ពៀរ អា ទី ប៉ាណោ ដឹង ម៉ោញ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","រ៉ក់ យ៉ង់ រ៉ាំងកៃគ អ្វៃ ដឹង កាន់តីង លូ អង់ការ តាំប៉ើះ កាតុ ណោះ ឃឺ តាំប៉ើះ សាណាំ ដេល។ ប៉ាយ៉ក័ ពៀ កាសៃង ដឹង អញ់ជែប ដោះ តាំប៉ើះ ប៉ាយ៉ក័ ណោះ ឃឺ ចឹង កើត ឡាយ៉ិត តាំប៉ើះ សាណាំ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","សារ អា ហង អាញ់ រ៉ះ កា អីស អំពែ ពែ ប‌៉្រ័ះ ប៊កកាតយ័ តាំបាង ង៉ារ អ៊ែ ទ្រៀម ចឹង ប៉្រគ័ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","កាណុង រ៉ាំងវ៉ាង តាំប៉ើះ សាណាំ ពឹង ប៉ាថេត អ៊ីស៊ីប អា ចឹង ទី ពៀ ភែ សាណា សាណឹត អៀង កាខាក់ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ឡៃង ឡឹង ណោះ ចឹង កើត ឡាយ៉ិត ប៉្រគ័ អន់ កា ប៉ាសុន ពឹង ប៉ាថេត អ៊ីស៊ីប អា ចឹង ពឹល កា អន់ឌែ ឃើយ ទី ពៀ ភែ អៀង កាខាក់ ពែ ញន កា ឡាយ៉ិត តាគ្រួប ទឹប ប៉ាថេត។ ");
INSERT INTO tpu_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ញន កា ឡាយ៉ិត ឡាំងវ៉ាញ់ តាឡាម័ ប៉ាសុន ចឹង ពឹល ហង កា អន់ឌែ តាឡាប័ ឃើយ ទី ពៀ ភែ អៀង ផះ រ៉ាំងវ៉ាង អន់ទ្រួល ពែ។ ");
INSERT INTO tpu_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","អីស អំប៉ោ ពៀរ ទង នីអៀ ចាបះ កា ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉្រគ័ សារ អា តាទឹច លូ អ៊ែ ឃឹត ចឹង ប៉្រគ័ ស៊្រសៗ គែង ម៉ាត់ អា ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","ទឹល នីណោ័ះ អីស ត្រគ់ ណាំង ប៉ាណូស ម៉ោញ ដូវ ឡាក់ ហ្យាំង សាឡាច់ អីស អន់ អ៊ែ ប៉្រគ័ តីស រ៉ាំងហៃ ប៉ាថេត អ៊ីស៊ីប អា ពិ។ ");
INSERT INTO tpu_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ប៉រ់ អីស ប៉្រើ មួត ប៉្រគ័ កាន រ៉ាតីស អន់ទៀគៗ រ៉ាំងហៃ ប៉ាថេត អ៊ីស៊ីប អា ឡិង អ្យក់ ពៀ ភែ ឡឹង ប៉ាសុន។ ផា អន់ឌែ ទី តាម័ រែវ ត្រគ់ អ្យក់ ឡាច់ ម៉ោញ រែវ គម រ៉ាន់ដាប់ កាណុង រ៉ាំងវ៉ាង តាំប៉ើះ សាណាំ ឡាក់ ទី ពៀ ភែ អៀង គែង ម៉ាត់ អា ទៀ។ ");
INSERT INTO tpu_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","អីស ត្រគ់ ប៉្រើ អន់ឌែ ប៉ាតុំ រ៉ាន់ដាប់ ពៀ ភែ រ៉ាំងវ៉ាង តាំប៉ើះ សាណាំ អា ចៃគ ពឹង ហី ពៀ តាម ស្រុក តាម មឿង អន់ទៀគៗ លូ ញ៉ាម ពៀ ភែ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ពៀ ភែ ណោះ គម សាំរ៉ាប់ រ៉ាំងវ៉ាង តាំប៉ើះ សាណាំ ប៉ាថេត អ៊ីស៊ីប ចឹង កើត ឡាយ៉ិត ទៀ ភឿ ជែ អន់ ប៉ាសុន តោ័ កា ឡាយ៉ិត»។ ");
INSERT INTO tpu_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","សារ យូស៊ែប រ៉ះ ណោះ កា ត្រគ់ ពុត សាដាច់ ខាក់ មួត ប៉្រគ័ កាន ទិណោ័ះ កា ត្រគ់ ពុត អន់ឌែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","សាដាច់ រ៉ះ កា មួត ប៉្រគ័ កាន ទិណោ័ះ ផា «អាញ់ អូ អ្លុ ចឹង ណាំង ប៉ាណូស ពឿ ចឹង ត្រគ់ ឡាក់ កា ប៉ាណូស អា អុះ។ អ៊ែ ទី ប៉ាង៉ាត័ ប៉ាលឹង ប‌៉្រ័ះ អ្វៃ ពឹង អ៊ែ»។ ");
INSERT INTO tpu_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","សាដាច់ រ៉ះ កា យូស៊ែប ផា «ប‌៉្រ័ះ តាំបាង សារ អា អន់ កា អីស អ្លុ កេះ ទឹល នីណោ័ះ អូ ទី ប៉ាណូស ពឿ ចឹង ហ្យាំង សាឡាច់ ក្វា ឡឹង អីស ណាវ្គ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ទឹល នីណោ័ះ អាញ់ ចឹង ប៉្រើ អីស ហង រ៉ាំងហៃ ប៉ាថេត អ៊ីស៊ីប អា  ប៉ាសុន អាញ់ ទិ អា ចឹង ប៉្រគ័ ពួយ ប៉ានឹរ អីស ឡគ។ អាញ់ ចឹង តីស ឡឹង អីស ដឹង ពឹង ចារ សាដាច់ អា ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","សាដាច់ អ៊ីស៊ីប រ៉ះ កា យូស៊ែប ណាវ្គ «កិញអៀ អា អាញ់ ប៉្រើ អីស រ៉ាំងហៃ ប៉ាថេត អ៊ីស៊ីប ទិ អា ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","កេះណោះ សាដាច់ ហ្វាត់ ឡាច់ អញ់ចិន ត្រា សាដាច់ ឡឹង តី អ៊ែ ចៃគ ពឹង តី យូស៊ែប។ អ៊ែ អ្យក់ អាវ ដាគ់ៗ អន់ យូស៊ែប ពៀត លូ អ្យក់ កាស៊ែ ស៊យ ម៉ាស ម៉ោញ កាស៊ែ អន់ យូស៊ែប ប៉ាក័ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","សាដាច់ កា អន់ យូស៊ែប ជិះ រ៉ាតេ័ះ សាដាច់ អន់តីគ ឡឹង អ៊ែ លូ ប៉្រើ ពូ ចាក អន់ទ្រួល ប៉ាគ់ ម៉ាត់ លូ ឡុង រ៉ះ ផា «ជន តាកុល សាំប‌៉័ះ យូស៊ែប !» សាដាច់ ប៉្រើ យូស៊ែប រ៉ាំងហៃ ទឹប ប៉ាថេត អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","សាដាច់ អ៊ីស៊ីប រ៉ះ កា យូស៊ែប ណាវ្គ ផា «យ‌៉័ះ អាញ់ សាដាច់ កាតាម ហះកា កានង៉ាន ញ៉ា ពឹង ប៉ាថេត អ៊ីស៊ីប អា ផា អូ កាតាំង ប៉ានឹរ អីស ប៉្រើ អូ ទី ពឿ ខឹន ប៉្រគ័ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","សាដាច់ ចៃគ សិច យូស៊ែប ផា សាប់ណាត់ផានៀ ឡគ។ កេះណោះ ណាវ្គ អ៊ែ ឡាំ កាណង័ យូស៊ែប ប៉ាគ់ អង់កាន់ សិច អាសិណាត់ គន វគ័ ប៉ូទីផេរ៉ា ឡាក់ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ អ្វៃ ប៉ាគ់ មឿង អូន អន់ កា យូស៊ែប ទី។ យូស៊ែប ប៉្រគ័ កាន ហ៊ែង តីស ៗ ពឹង ប៉ាថេត អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ផះ សាដាច់ ប៉្រើ យូស៊ែប រ៉ាំងហៃ ប៉ាថេត អ៊ីស៊ីប ណោះ អ៊ែ អាញុ ៣០ សាណាំ កេះ។ អ៊ែ ឡាច់ ឡឹង ចារ សាដាច់ ចាក ប៉ាញ័ ទឹប ប៉ាថេត អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","កាណុង រ៉ាំងវ៉ាង តាំប៉ើះ សាណាំ ណោះ តេះ ពឹង ប៉ាថេត អ៊ីស៊ីប ដាគ់ សាណា កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","រ៉ាំងវ៉ាង តាំប៉ើះ សាណាំ ណោះ យូស៊ែប ប៉្រើ ពូ ចាក ប៉ាតុំ ពៀ ភែ ពឹង ប៉ាថេត អ៊ីស៊ីប ឡឹង ម៉ីរ អ្យក់ រ៉ាន់ដាប់ ពឹង ហី ពៀ តាម មឿង អន់ទៀគៗ។ ");
INSERT INTO tpu_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","យូស៊ែប ចាក ប៉ាតុំ ពៀ ភែ ទី អៀង កាខាក់ ឡាក់ កា តេះ ឡាពុក រហាង សាឡីគ សាឡាយ និះ ពូ អូ ដាម័ យ៉ាប កេះ ខង អៀង តាឡាម័ យ៉ាប អូ អ្លុ ប៉្រគ័ ទិ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","ផះ បើ តាន័ ទឹល សាណាំ កើត ឡាយ៉ិត យូស៊ែប លូ អាសិណាត់ អន់ឌែ ទី គន កាម៉ាក័ ពៀរ ដូវ។ អាសិណាត់ ណោះ គន វគ័ ប៉ូទីផេរ៉ា ឡាក់ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ អ្វៃ ប៉ាគ់ មឿង អូន។ ");
INSERT INTO tpu_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","យូស៊ែប ចៃគ សិច គន ឡោងទ្រៀ អ៊ែ ណោះ ផា ម៉ាណាសេ  ខង អ៊ែ ផា «ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ កា អាញ់ ពឹល សារ ឡាំបាក ទិណោ័ះ ផះ អាញ់ អ្វៃ ប៉ាគ់ ហី ពឹ អាញ់ ពែ»។ ");
INSERT INTO tpu_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","កេះណោះ អ៊ែ ចៃគ សិច គន អ៊ែ ម៉ោញ ណាវ្គ ផា អេប៉្រាអ៊ីម  ខង អ៊ែ ផា «ប‌៉្រ័ះ ប៊កកាតយ័ អន់ អាញ់ ទី គន សោ ពឹង ប៉ាថេត អ៊ីស៊ីប អា ឡាក់ អាញ់ ឃើយ ទី កាន ថុក ញ៉ាក ពែ»។ ");
INSERT INTO tpu_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ទី ពៀ ភែ អៀង គ្រឹប តាំប៉ើះ សាណាំ កេះ ");
INSERT INTO tpu_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","កា កើត ឡាយ៉ិត ឡាំងវ៉ាញ់ តាំប៉ើះ សាណាំ ត្រគ់ ឡាក់ កា យូស៊ែប រ៉ះ តាទឹច។ ផះ រ៉ាំងវ៉ាង ណោះ កើត ឡាយ៉ិត គ្រឹប ប៉ាថេត ហះកា ពឹង ប៉ាថេត អ៊ីស៊ីប អ្វៃ ទី ពៀ ភែ ឡាក់ ពូ រ៉ាន់ដាប់ កេះៗ។ ");
INSERT INTO tpu_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ប៉ាគ់ ប៉ាសុន ប៉ាថេត អ៊ីស៊ីប ឡាយ៉ិត អន់ឌែ កា ប៉ាណាំ គួប ឡាំ ប៉រ់ សាប្យាំង ប៉ាគ់ សាដាច់។ កេះណោះ សាដាច់ រ៉ះ កា អន់ឌែ ផា «អន់ដីស ឡាំ ប៉រ់ ប៉ាគ់ យូស៊ែប តោ ពិ ផា អ៊ែ ប៉្រើ អន់ដីស ប៉្រគ័ ញ៉ា ត្រគ់ ប៉្រគ័ ពួយ អ៊ែ ណោះ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ឡាយ៉ិត ឡាំងវ៉ាញ់ ណោះ កា កើត ប៉ាញ័ ទឹប ប៉ាថេត អ៊ីស៊ីប។ យូស៊ែប កា បើក ហី ពៀ គ្រឹប មឿង កេះណោះ អ៊ែ ប្រូ ពៀ ភែ អន់ កា ពូ ញន ប៉ាសុន អ៊ីស៊ីប ឡាយ៉ិត ទិឌូ។ ");
INSERT INTO tpu_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","កាយ ឡឹង ណោះ ណាវ្គ ប៉ាណូស គ្រឹប ប៉ាថេត ប៉ាណាំ គួប ឡាំ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ភឿ ប៉រ់ តាច់ ពៀ ភែ ឡឹង យូស៊ែប ខង កើត ឡាយ៉ិត ឡាំងវ៉ាញ់ ហ៊ែង យ៉ឹប ៗ គ្រឹប ប៉ាថេត អ្វៃ ពឹង អង់កក់ តេះ អា។ ");
INSERT INTO tpu_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ផះ ណោះ វគ័ យ៉ាកុប កាតាំង លៅ ផា ទី ពៀ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប។ អ៊ែ កាប លូ គន អ៊ែ ផា «ញ៉ា ត្រគ់ អន់ដីស អ្វៃ ហៃ ម៉ាត់ គួប សោប នីអៀ ?» ");
INSERT INTO tpu_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","កេះណោះ អ៊ែ រ៉ះ ផា «អាញ់ កាតាំង លៅ ពូ ផា ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ទី ពៀ អៀង ទឹល នីណោ័ះ អន់ដីស ប៉ាណាំ គួប ឡាំ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ណាំង តាច់ សាប្យាំង ពិ ម៉ាគ់ ពិន អ្វៃ រ៉ីស ជែ អន់ តោ័ កា ឡាយ៉ិត អា»។ ");
INSERT INTO tpu_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","ម៉ីៗ យូស៊ែប ទិ អញ់ជឹត ដូវ កា ប៉ាណាំ គួប ឡាំ ណាំង តាច់ ពៀ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ");
INSERT INTO tpu_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ហះកា វគ័ យ៉ាកុប អូ ប៉្រើ បេនយ៉ាមីន ឡាក់ អុះ យូស៊ែប ឡាំ អន់ឌូ លូ ម៉ីៗ អ៊ែ អុះ ខង អ្យូគ កា ទី កាន ខូច័ ខាច ត្រគ់ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","គន វគ័ យ៉ាកុប កា ប៉ាណាំ គួប ឡាំ តាច់ ពៀ ឡាក់ កា ពូ ដេល ខង ប៉ាគ់ ប៉ាថេត កាណាន កា ឡាយ៉ិត ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ផះ រ៉ាំងវ៉ាង ណោះ យូស៊ែប ប៉្រគ័ តីស ពឹង ប៉ាថេត អ៊ីស៊ីប អ៊ែ ហង តាំងឡា ប្រូ ពៀ អន់ កា ប៉ាណូស ទឹប អង់កក់ តេះ។ ម៉ីៗ អ៊ែ ប៉ាណាំ គួប ម៉ុត សាំប‌៉័ះ អ៊ែ កុប កល់ ទឹះ តេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","សាគ់ យូស៊ែប ប៉ប័ មួត ម៉ី អ៊ែ អន់ហ្នាល់ ឡូត ហះកា អ៊ែ តាគ់ អំប៉្រគ័ អូ អន់ហ្នាល់ ឡាក់ កា ពូ អន់ទៀគ។ អ៊ែ កាប កានឹតៗ អំប៉ញ់ ផា «អន់ដីស ពឹះ ឡឹង ចំ ?» មួត ម៉ី អ៊ែ តើល ផា «ញឹន ពឹះ ឡឹង ប៉ាថេត កាណាន ឡាំ ណាំង តាច់ សាប្យាំង»។ ");
INSERT INTO tpu_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","យូស៊ែប អន់ហ្នាល់ មួត ម៉ី អ៊ែ ហះកា អន់ឌែ អូ អន់ហ្នាល់ អ៊ែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ផះ យូស៊ែប ប៉ប័ មួត ម៉ី អ៊ែ ជន តាកុល សាំប‌៉័ះ អ៊ែ នីណោ័ះ អ៊ែ កា កាចាំង ឡឹង សារ អ៊ែ អំប៉ោ ពែ។ កេះណោះ អ៊ែ កាប ផា «អន់ដីស អា ឡាក់ មួត សឺប កាន។ អន់ដីស ពឹះ ប៉ាគ់ ប៉ាថេត អា ឃឺ អន់ដីស ប៉ិច ណាំង ហៃ ចារ ចំ ឡាក់ អូ ទី ប៉ាណូស ញ៉ាម»។ ");
INSERT INTO tpu_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","មួត ម៉ី អ៊ែ តើល ផា «អូ អុះ ពឹ តាំងឡា។ ញឹន ពឹះ ប៉ាគ់ អា ឃឺ ណាំង តាច់ សាប្យាំង តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ញឹន ទិឌូ អា អុះ ម៉ី ម៉ោញ ពឹ ណោះ ហង ញឹន អា ឃឺ ប៉ាណូស ត្រង់ អូ ត្រគ់ ប៉ាណូស សឺប កាន អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","យូស៊ែប តើល ផា «អូ អុះ ! អន់ដីស ពឹះ ប៉ាគ់ អា ឃឺ ប៉ិច ណាំង ហៃ ចារ ចំ ឡាក់ អូ ទី ប៉ាណូស ញ៉ាម»។ ");
INSERT INTO tpu_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","អន់ឌែ តើល ណាវ្គ ផា «ញឹន អា ទី អុះ ម៉ី ១២ ដូវ ពឹ ដឹង ម៉ោញ អ្វៃ ប៉ាគ់ ប៉ាថេត កាណាន តោ អុះ ស្រុច ញឹន អ្វៃ លូ ពឹ ញឹន ហះកា អុះ ញឹន ម៉ោញ ណាវ្គ អ៊ែ តោ័ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","កេះណោះ យូស៊ែប កាប ផា «ញ៉ា អូ ហៃ ត្រគ់ ឡាក់ កា អាញ់ ផា អន់ដីស អា ឃឺ ប៉ាណូស សឺប កាន តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","អាញ់ ចឹង សាគ់ ហៃ លួង ពុត អន់ដីស ហិ។ អាញ់ ម៉ត់ អើ សិច សាដាច់ អ៊ីស៊ីប ផា អន់ដីស ចឹង អូ ទី ចាក ឡាច់ ឡឹង ចារ អា អុះ ផា អុះ ស្រុច អន់ដីស អូ ឡាំ ប៉ាគ់ អា។ ");
INSERT INTO tpu_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","ហគ់ ប៉្រើ កាំឡាំង អន់ដីស ម៉ោញ ដូវ ឡាំ អ្យក់ អុះ ស្រុច អន់ដីស ណោះ ពឹះ ប៉ាគ់ អា កាប៉ាច់ បក់ អ្វៃ ហះ អា រ៉ុប ចៃគ ពឹង ខុក ហិ។ ប៉្រគ័ នីអៀ ភឿ ចឹង អ្លុ អន់តគ់ ផា ប៉ានឹរ អន់ដីស កាប ណោះ ត្រគ់ តាទឹច ប។ អាញ់ ម៉ត់ ផា ផា អូ ត្រគ់ ឡាក់ កា អន់ដីស កាប ឃឺ អន់ដីស មួត ចាក សឺប កាន តាទឹច ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","កេះណោះ យូស៊ែប ប៉្រើ ពូ រ៉ុប គ្រន មួត ម៉ីៗ អ៊ែ កាណុង ខុក ប៉ៃង ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ប៉ាគ់ ទឹល ប៉ៃង ដារ់ កេះ យូស៊ែប រ៉ះ កា ម៉ីៗ អ៊ែ ផា «អាញ់ ឡាក់ ប៉ាណូស អ្យិល កូត័ កា ប‌៉្រ័ះ។ ផា អន់ដីស ប៉ិច អ្វៃ រ៉ីស ត្រគ់ ប៉្រគ័ នីអៀ៖ ");
INSERT INTO tpu_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ផា អន់ដីស ឡាក់ ប៉ាណូស ត្រង់ អូ ព្លូង តាទឹច ត្រគ់ អន់ អុះ ម៉ី អន់ដីស ម៉ោញ ដូវ អ្វៃ កាណុង ខុក អា ហិ សល់ ឡឹង ណោះ សឹត ប៉ាគ់ ស្រុក អន់ដីស ទៅ ជឹន ពៀ ភែ អន់ កា កាំឡាំង ហី ក្រាន ផះ អ្វៃ ក្យាគ់ អូ ទី សាណា សា តោ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","កេះណោះ អន់ដីស ត្រគ់ អ្យក់ ឡាំ អុះ ស្រុច អន់ដីស ណោះ ឡាំ ប៉ាគ់ អាញ់ អា ម៉ាគ់ អាញ់ ចឹង ប៉ប័ លូ អ្លុ អន់តគ់ ផា ត្រគ់ ឡាក់ កា អន់ដីស រ៉ះ តាទឹច។ ផា អន់ដីស ត្រង់ អូ ព្លូង ណោះ ដាគ់ អន់ដីស ចឹង អូ តោ័»។ អន់ឌែ កា ភម ប៉្រគ័ ពួយ ");
INSERT INTO tpu_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ទឹប កាកាប លូ គួប សោប ផា «ប៉ប័ ប ពិន ទី ប៉្រគ័ បាប អុះ ពិន។ ពិន ប៉ប័ ដេល អ៊ែ ទី សារ ឡាំបាក ផះ អ៊ែ អ្វៃ ឡោម ពិន ពែ ហះកា ពិន អូ ចៃ សាំយ៉ាំង អ៊ែ អុះ។ ញន សារ ណោះ ហង បះ ពិន ទី សារ ឡាំបាក ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","រូបេន តើល ផា «អាញ់ រ៉ះ កេះ កា អន់ដីស ផា \"ជែ ប៉្រគ័ បាប កា អុះ ពិន\" ហះកា អន់ដីស អូ សឿ អុះ។ កិញអៀ អា ពិន ទី ថូត ញន កា ពិន ប៉ាន់តោ័ អុះ ពិន»។ ");
INSERT INTO tpu_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","អន់ឌែ សាម៉គ័ កា យូស៊ែប អូ អ្លុ សាំយ៉ាំង អុះ សារ អន់ឌែ កាប ណោះ ខង ផះ យូស៊ែប កាប លូ អន់ឌែ អ៊ែ កាប សុនសាត អ៊ីស៊ីប ទី ប៉ាណូស រ៉ះ ប៉ាតាង។ ");
INSERT INTO tpu_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","យូស៊ែប ចាក ឡាច់ ឡឹង ចារ អន់ឌែ បាប៊ែត ភឿ ឡាំ ញ៉ាំ ជែ អន់ ពូ ប៉ប័ កេះណោះ សឹត កាកាប លូ អន់ឌែ ណាវ្គ។ កេះណោះ អ៊ែ ប៉្រើ ពូ អ្យក់ ស៊ីមៀន ចៃគ ពឹង ខុក ហះ ម៉ាត់ អន់ឌែ ណោះ ហង។ … ");
INSERT INTO tpu_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ពឹង ប៉ាថេត កាណាន កើត ឡាយ៉ិត ឡាំងវ៉ាញ់ ហ៊ែង ខាក់ ៗ។ ");
INSERT INTO tpu_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ពៀ អន់ឌែ តាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ណោះ កា សង់ ទិ កេះ ទឹល នីណោ័ះ វគ័ យ៉ាកុប រ៉ះ លូ គន អ៊ែ ផា «អឺ គន អន់ដីស ប៉ាណាំ គួប ឡាំ តាច់ ពៀ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ណាវ្គ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","យូដា តើល ពឹ អ៊ែ ផា «ម៉ៃគ ណាំផា ប៉ាថេត អ៊ីស៊ីប ណោះ រ៉ះ កា ញឹន ចាបះ កាខាក់ អ៊ែ កាប ផា \"ផា អុះ អន់ដីស អូ ឡាំ អន់ឌូ អន់ដីស ជែ ពឹះ អន់ អាញ់ ប៉ប័ អន់ដីស ណាវ្គ ដៃ\"។ ");
INSERT INTO tpu_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ផា ពឹ អន់ អុះ ញឹន ឡាំ អន់ឌូ ណោះ ញឹន ចឹង ចៃ ឡាំ តាច់ សាប្យាំង ");
INSERT INTO tpu_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ហះកា ផា ពឹ អូ អន់ អ៊ែ ឡាំ ញឹន កា អូ ឡាំ ដេល ខង វគ័ ណោះ រ៉ះ កា ញឹន ផា \"ផា អុះ អន់ដីស អូ ឡាំ អន់ឌូ អន់ដីស ជែ ពឹះ អន់ អាញ់ ប៉ប័ អន់ដីស ណាវ្គ ដៃ\"» ");
INSERT INTO tpu_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","វគ័ យ៉ាកុប កាប ផា «ញ៉ា គន ប៉្រគ័ បាប អាញ់ នីអៀ ? ញ៉ា ត្រគ់ រ៉ះ លូ វគ័ ណោះ ផា ទី អុះ ម៉ោញ ណាវ្គ ?» ");
INSERT INTO tpu_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","អន់ឌែ តើល ណាវ្គ ផា «វគ័ ណោះ អំប៉ញ់ ចាជៀក ឡាលៀក លូ ញឹន អំប៉ញ់ ឡឹង សារ អុះ ម៉ី ម៉ៃគ ពឹ អ៊ែ ផា \"ពឹ អន់ដីស អ្វៃ រ៉ីស ប ? អន់ដីស ទី អុះ ដេល ប ?\" ញឹន កា រ៉ះ ពួយ ប៉ានឹរ អ៊ែ អំប៉ញ់ ណោះ ហង ញឹន អូ អ្លុ អន់តគ់ កា អ៊ែ ចឹង ប៉្រើ ញឹន អ្យក់ ពឹះ អុះ ញឹន ឡាំ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប នីអៀ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","យូដា ឡោម វគ័ យ៉ាកុប ផា «អឺ ពឹ អាញ់ ប៉រ់ ហះ អីស អន់ អុះ ញឹន ឡាំ អន់ឌូ លូ អាញ់ ពិ ម៉ាគ់ ញឹន ចឹង ឡាំ ម៉ាគ់ ពិន ទិឌូ អ្វៃ រ៉ីស អូ តោ័។ ");
INSERT INTO tpu_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","អាញ់ ចឹង រ៉ាំងហៃ អ៊ែ អាញ់ ឡាប់ ទិណោ័ះ។ ផានែវ អាញ់ អូ អ្យក់ សឹត អ៊ែ អន់ ពឹ ប៉ប័ អ៊ែ ណាវ្គ អាញ់ ចឹង ទី ថូត ឡុច រ៉ាំងហាវ។ ");
INSERT INTO tpu_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ផា ញឹន អូ ប៉ាហ្រើយ្គ ដារ់ នីអៀ ញឹន សឹត ឡាំ ពៀរ ទង កេះ ប៉ុប អា»។ ");
INSERT INTO tpu_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","វគ័ យ៉ាកុប កា កាប លូ អន់ឌែ ផា «ផា នីណោ័ះ អន់ដីស ប៉ាណាំ គួប ឡាំ ពិ អ្យក់ ឃឿង ដាគ់ៗ ឡឹង ស្រុក ពិន អា ទ្រុង អន់ កា វគ័ ណោះ ណើ។ អ្យក់ ឡាក់ កា ចារ័ អ៊្លង បោផូវ បាប៊ែត ទៀក សុត បាប៊ែត លូ ឃឿង បោផូវ អន់ដា អ្យក់ ការ័ អ៊្លង ឡាក់ ពូ ឃើយ សា។ … ");
INSERT INTO tpu_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ហគ់ ទ្រុង អុះ អន់ដីស អា កាតាម ឡាំ តាំបាង កា វគ័ ណោះ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","កេះណោះ អ៊ែ ផា «អន់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ទី អំរ៉ាញ ហ៊្លត ឡឹង ពូ ប៉្រគ័ អន់ កា វគ័ ណោះ ទី ពុត ដាគ់ តាប៉ាប តាប៉ុន កា គន អាញ់ ទិឌូ ទឹប អន់ ស៊ីមៀន លូ បេនយ៉ាមីន សឹត អន់ឌូ លូ អុះ ម៉ី អន់ឌែ ដេល។ កាប៉ាច់ អាញ់ ផា គន អាញ់ ត្រគ់ ហ៊្យង កា ហ៊្យង ហះ ណោះ ហង ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","មួត គន យ៉ាកុប កា អ្យក់ ឡាំ កាណាគ័ លូ លៀន ពៀរ ចានែក លូ ទ្រុង ឡាំ ទឹប អុះ អន់ឌែ បេនយ៉ាមីន ឡាំ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ម៉ុត ប៉ាគ់ ចារ យូស៊ែប ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","សាគ់ យូស៊ែប ប៉ប័ អុះ អ៊ែ បេនយ៉ាមីន ឡាំ អន់ឌូ លូ មួត ម៉ីៗ អ៊ែ រ៉ះ លូ ម៉ៃគ ទុច អ៊ែ ផា «អីស ជៀក មួត អា អ្វៃ ពឹង ហី អាញ់ ពិ កេះណោះ អីស កោះ ប៉ារ់ពេ ប៉្រគ័ សាអ៊្លង ខង អន់ឌែ ចឹង សា សាណា អន់ឌូ លូ អាញ់ កាដារ់ ប៉ង់ ទៀ»។ ");
INSERT INTO tpu_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ទុច អ៊ែ ណោះ ជៀក មួត ម៉ី អ៊ែ ម៉ុត អ្វៃ ពឹង ហី តាទឹច កេះណោះ ប៉្រគ័ ពួយ ឡាក់ កា អ៊ែ ប៉្រើ ណោះ ហង។ … ");
INSERT INTO tpu_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","យូស៊ែប អូ ដាម័ កាតត់ ពុត កេះ ហះ ម៉ាត់ មួត អ៊ីស៊ីប អ៊ែ កា ប៉្រើ ពូ ឡាច់ ឡឹង ហី ទិឌូ។ ផះ អ៊ែ រ៉ះ សិច អ៊ែ អន់ កា អុះ ម៉ី អ៊ែ អន់ហ្នាល់ ណោះ អូ ទី ពូ អន់ទៀគ អ្វៃ អន់ឌូ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","យូស៊ែប កា អង់ហ្យាំង ញ៉ាំ តុត ពុត កាតាំង ទឹល ប៉ាគ់ មួត សុនសាត អ៊ីស៊ីប លូ កាតាំង លៅ ទឹល ប៉ាគ់ ហី សាដាច់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","កេះណោះ អ៊ែ រ៉ះ លូ អុះ ម៉ី អ៊ែ ផា «អាញ់ អា ហង យូស៊ែប។ នីចម័ ពឹ ពិន អ្វៃ រ៉ីស ដេល ប ?» ហះកា អុះ ម៉ី អ៊ែ អូ អ្លុ តើល អុះ អន់ឌែ កាខរ់ ណូស ខង ប៉ប័ អ៊ែ ញ៉ាំ អង់ហ្យាំង នីណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","យូស៊ែប រ៉ះ កា អន់ឌែ ផា «ប៉រ់ អន់ដីស ម៉ុត អ្វៃ ក្យាម័ អាញ់ អា»។ អន់ឌែ កា ម៉ុត អ្វៃ ក្យាម័ យូស៊ែប កេះណោះ អ៊ែ រ៉ះ ផា «អាញ់ អា ហង យូស៊ែប អុះ អន់ដីស ឡាក់ អន់ដីស ប្រូ អន់ កា ពូ អ្យក់ ឡាំ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប អា។ ");
INSERT INTO tpu_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","កិញអៀ អន់ដីស ជែ អ្យូគ ជែ ឃឹត ហង កា អន់ដីស ប្រូ អាញ់ ណោះ ខង ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អាញ់ ឡាំ ប៉ាគ់ អា ភឿ អន់ រ៉ាំងហៃ អាញុ ប៉ាណូស អន់ អ្វៃ រ៉ីស។ ");
INSERT INTO tpu_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","អន់ដីស ហៃ កើត ឡាយ៉ិត ពឹង ប៉ាថេត អា ពៀរ សាណាំ កេះ អ្វៃ ប៉ាតាម័ សាណាំ ណាវ្គ ចឹង ឡាយ៉ិត អូ ទី ប៉ាណូស ពឿ ចឹង អ្លុ សាមូល តប់ ច្រូត័ កាច់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អាញ់ ឡាំ ប៉ាគ់ អា អន់ទ្រួល ឡឹង អន់ដីស ភឿ អន់ អន់ដីស អ្វៃ រ៉ីស ម៉ាគ់ ទី គន ទី សោ អន់ អៀង ប៉ាគ់ ម៉ាត់ ប៉ាគ់ ង៉ីរ ទៀ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","ទឹល នីណោ័ះ អូ ត្រគ់ អន់ដីស អុះ ប៉្រគ័ កា អាញ់ ឃឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប៉្រើ អាញ់ ឡាំ ប៉ាគ់ អា។ អ៊ែ ប៉្រើ អាញ់ ប៉្រគ័ ពឹ អ្វៃ ពឹង ហី សាដាច់ អ៊ីស៊ីប លូ អន់ អាញ់ រ៉ាំងហៃ ទិ ប៉ាថេត អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","ហគ់ អន់ដីស ប៉ាន់តាន សឹត ប៉ាគ់ ពឹ ពិន ណាវ្គ ពិ កេះណោះ រ៉ះ កា អ៊ែ ផា \"គន អីស យូស៊ែប អន់តគ់ រ៉ះ ផា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អ៊ែ ប៉្រគ័ តីស រ៉ាំងហៃ ប៉ាថេត អ៊ីស៊ីប ទិណោ័ះ កេះ។ ទឹល នីណោ័ះ អ៊ែ ប៉្រើ អីស ឡាំ ប៉ាគ់ អ៊ែ ស៊្រសៗ ជែ ប៉ាំងក្រូ។ ");
INSERT INTO tpu_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ពឹ ចឹង អ្វៃ ពឹង ព្រី កូស៊ែន ក្យាម័ ហះ សានែង គន។ ប៉រ់ អ្យក់ ឡាំ ទឹប គន សោ ទឹប ចៀម រ៉ក់ លូ កាណាគ័ ញ៉ាៗ ឡាក់ ពឹ ទី ទិណោ័ះ ដេល ");
INSERT INTO tpu_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ខង កើត ឡាយ៉ិត អា អ្វៃ ប៉ាតាម័ សាណាំ ណាវ្គ។ ទឹល នីណោ័ះ គន ចឹង តង័ ពឹ អូ អន់ ពឹ លូ គន សោ ទឹប កាណាគ័ ពឹ រង ទិណោ័ះ ឡាយ៉ិត ឡាំងវ៉ាញ់ អុះ\"»។ … ");
INSERT INTO tpu_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","អន់ឌែ កា ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប វ៉ីល សឹត ប៉ាគ់ ពឹ អន់ឌែ វគ័ យ៉ាកុប អ្វៃ ប៉ាគ់ ប៉ាថេត កាណាន ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","អន់ឌែ រ៉ះ លូ វគ័ យ៉ាកុប ផា «ពឹ ! យូស៊ែប អ្វៃ រ៉ីស អូ តោ័ អុះ។ អ៊ែ ហង ប៉្រគ័ តីស អ្វៃ រ៉ាំងហៃ ពឹង ប៉ាថេត អ៊ីស៊ីប ណោះ»។ សារ អា ប៉្រគ័ អន់ វគ័ យ៉ាកុប អូ អ្លុ ឃឹត នីចម័ អុះ ហះកា អ៊ែ អូ សឿ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","អន់ឌែ កា រ៉ះ ណាវ្គ ពួយ ប៉ានឹរ យូស៊ែប អន់តគ់ កា អន់ឌែ។ ប៉ាគ់ វគ័ យ៉ាកុប ប៉ប័ រ៉ាតេ័ះ យូស៊ែប អន់ សឹត ភឿ ប៉ាទុក អ៊ែ ឡាំ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ណោះ អ៊ែ កា ហោក ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","កេះណោះ អ៊ែ ផា «បគ័ ហង អាញ់ សឿ កេះ គន អាញ់ យូស៊ែប អ្វៃ រ៉ីស តាទឹច អ្យូ។ អាញ់ ចឹង ឡាំ ប៉ាគ់ ណោះ ស៊្រសៗ អន់ ប៉ប័ ម៉ូះ ម៉ាត់ អ៊ែ អន់ទ្រួល ឡឹង អាញ់ ចឹង តោ័»។ ");
INSERT INTO tpu_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","វគ័ យ៉ាកុប ចាក ឡាំ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប អ្យក់ ឡាំ ទិ កាណាគ័ ញ៉ា ឡាក់ អ៊ែ ទី។ ប៉ាគ់ ទឹល ស្រុក បៀសេបា អ៊ែ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ពឹ អ៊ែ អ៊ីសាក់។ ");
INSERT INTO tpu_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ប៉ាគ់ កាម៉ាំង វគ័ យ៉ាកុប តៃប អ៊ែ ប៉ប័ ប‌៉្រ័ះ ប៊កកាតយ័ តាំបាង ឡាកោ ទឹប កាកាប លូ អ៊ែ ផា «យ៉ាកុប ! អឺ យ៉ាកុប !» យ៉ាកុប តើល ផា «ញ៉ា ប‌៉្រ័ះ ប៊កកាតយ័ ?»។ ");
INSERT INTO tpu_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","ប‌៉្រ័ះ រ៉ះ កា អ៊ែ ផា «អាញ់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ពឹ អីស។ ជែ អ្យូគ កា ឡាំ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ណោះ ខង ប៉ាគ់ ប៉ាថេត ណោះ ហង អាញ់ ចឹង ប៉្រគ័ អន់ ផូង័ វ៉ាច់ អីស កើត រ៉ាល ចឹង កេះ ប៉ាថេត ម៉ោញ តុត តីស ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","អាញ់ ចឹង ឡាំ អន់ឌូ លូ អីស ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ណោះ ដេល លូ រ៉ាំងហៃ អីស។ ប៉ាគ់ ទឹល សាណាំ ត្រគ់ សឹត កេះ អាញ់ ចឹង ប៉ាណាំ គន សោ អីស សឹត ប៉ាគ់ ស្រុក អីស ទៅ ណាវ្គ។ ប៉ាគ់ អីស តោ័ ទៀ យូស៊ែប ចឹង តាគ់ សាំងអ្យឹប ម៉ាត់ អីស»។ ");
INSERT INTO tpu_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","យ៉ាកុប ចាក ឡាច់ ឡឹង ស្រុក បៀសេបា គន វគ័ យ៉ាកុប កា ប៉ាណាំ អ៊ែ លូ គន កាម៉ាញ់ អន់ឌែ ហាវ ជិះ រ៉ាតេ័ះ ឡាក់ សាដាច់ អ៊ីស៊ីប អន់ សាំរ៉ាប់ ឡាំ អ្យក់ អន់ឌែ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","អន់ឌែ អ្យក់ ឡាំ ទិ កាណាគ័ ញ៉ា ឡាក់ អន់ឌែ ទី ពឹង ប៉ាថេត កាណាន។ វគ័ យ៉ាកុប ឡាំ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ណោះ អ៊ែ កា ប៉ាណាំ ទិ គន សោ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","អ៊ែ កា ប៉ាណាំ គន កាម៉ាក័ គន អង់កាន់ ទឹប សោ កាម៉ាក័ សោ អង់កាន់ លូ ផូង័ វ៉ាច់ អ៊ែ ទិណោ័ះ កា ចាក អន់ឌូ ឡាំ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ដេល។ … ");
INSERT INTO tpu_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ប៉ាណូស បក់ ឡាំ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប អន់ឌូ លូ វគ័ យ៉ាកុប ណោះ ទី ៦៦ ដូវ ម៉ាយ អ៊ែ អូ ទី យ៉ាប អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ផា យ៉ាប ទឹប គន យូស៊ែប ពៀរ ដូវ ឡាក់ កើត ពឹង ប៉ាថេត អ៊ីស៊ីប ចំលួន កាំឡាំង វគ័ យ៉ាកុប ទិណោ័ះ ឡាក់ ទី អ្វៃ ពឹង ប៉ាថេត អ៊ីស៊ីប ទី ៧០ ដូវ ។ ");
INSERT INTO tpu_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","វគ័ យ៉ាកុប ប៉្រើ យូដា ឡាំ ប៉ាគ់ យូស៊ែប អន់ទ្រួល ភឿ អំប៉ញ់ ទ្រង ឡាំ ប៉ាគ់ ព្រី កូស៊ែន។ ប៉ាគ់ កាំឡាំង យ៉ាកុប ឡាំ ទឹល ព្រី កូស៊ែន កេះ ");
INSERT INTO tpu_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","យូស៊ែប កា ចៃគ រ៉ាតេ័ះ អ៊ែ ឡាំ ប៉ាគ់ ព្រី កូស៊ែន ណោះ ដេល ភឿ ឡាំ ហាប់ ពឹ អ៊ែ វគ័ យ៉ាកុប។ សាគ់ ទឹល អ៊ែ កា គ្វែត ពឹ អ៊ែ តុត ទុញ អ៊ែ ហោក ឡាច់ ទៀក ម៉ាត់។ ");
INSERT INTO tpu_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","វគ័ យ៉ាកុប កា កាប លូ យូស៊ែប ផា «កិញអៀ អា យ‌៉័ះ អាញ់ តោ័ កា ដាគ់ ហង ខង អាញ់ ទី ប៉ប័ ម៉ាត់ គន អាញ់ កេះ អីស អ្វៃ រ៉ីស តាទឹច»។ ");
INSERT INTO tpu_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","យូស៊ែប រ៉ះ កា មួត ម៉ីៗ លូ ពឹ អ៊ែ ផា «អាញ់ ចឹង ឡាំ រ៉ះ លូ សាដាច់ អ៊ីស៊ីប ផា \"អុះ ម៉ី លូ ខាប់ខួ ពឹ អាញ់ ពឹះ ឡឹង ប៉ាថេត កាណាន អ្វៃ ប៉ាគ់ អាញ់ អា កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","អន់ឌែ ណោះ ឃឺ មួត រង កាណាគ័ អន់ឌែ កា អ្យក់ ឡាំ ទិ ទឹប តាប៉ល់ ចៀម តាប៉ល់ រ៉ក់ លូ កាណាគ័ ញ៉ា ឡាក់ អន់ឌែ ទី\"។ ");
INSERT INTO tpu_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ផា សាដាច់ អ៊ីស៊ីប អើ អន់ដីស កេះណោះ អំប៉ញ់ ផា \"អន់ដីស ឃើយ ណាំង សា ញ៉ា ?\" ");
INSERT INTO tpu_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","អន់ដីស ត្រគ់ តើល ផា \"ឡឹង ញឹន អ្វៃ សាស្វា ទឹល រ៉ប់ ដារ់ អា ញឹន ឃើយ ដឹង រង កាណាគ័ ឡាក់ វគ័ យ៉ាគ់ ញឹន សើគ ពែ ដេល\"។ ផា អន់ដីស តើល នីណោ័ះ ណោះ ចឹង ទី អ្វៃ ពឹង ព្រី កូស៊ែន អា ខង សុនសាត អ៊ីស៊ីប អូ ណីស អុះ កា មួត រង ចៀម»។ ");
INSERT INTO tpu_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","យូស៊ែប ឡាំ រ៉ះ លូ សាដាច់ អ៊ីស៊ីប ផា «មួត ម៉ី លូ ពឹ អាញ់ អន់ឌែ ឡាំ ឡឹង ប៉ាថេត កាណាន អ្យក់ ពឹះ ទិ ទឹប កាណាគ័ ញ៉ា ឡាក់ អន់ឌែ ទី តាប៉ល់ ចៀម តាប៉ល់ រ៉ក់។ កិញអៀ អា អន់ឌែ អ្វៃ ប៉ាគ់ ព្រី កូស៊ែន តោ»។ ");
INSERT INTO tpu_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","យូស៊ែប កា ប៉ាណាំ ម៉ី អ៊ែ ប៉ាតាម័ ដូវ ឡាំ ប៉ាគ់ សាដាច់ អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","សាដាច់ អ៊ីស៊ីប អំប៉ញ់ ម៉ី យូស៊ែប ផា «អន់ដីស ណាំង សា ប៉្រគ័ ង៉ារ ញ៉ា ?» អន់ឌែ តើល ផា «ញឹន រង ចៀម ឡាក់ កា វគ័ យ៉ាគ់ ញឹន ពែ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","អន់ឌែ រ៉ះ លូ សាដាច់ អ៊ីស៊ីប ណាវ្គ ផា «បះ ញឹន ឡាំ អ្វៃ ប៉ាគ់ ប៉ាថេត អា ញន កា ប៉ាថេត កាណាន កើត ឡាយ៉ិត យ៉ឹប ចៀម ញឹន អូ ទី សាម៉ោង សា អុះ។ ទឹល នីណោ័ះ ប៉រ់ អីស តាប៉ាប តាប៉ុន កា ញឹន ណើ អន់ អ្វៃ ប៉ាគ់ ព្រី កូស៊ែន ណោះ អង់រ៉ាម័»។ ");
INSERT INTO tpu_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","សាដាច់ រ៉ះ កា យូស៊ែប ផា «អុះ ម៉ី លូ ពឹ អីស អន់ឌែ ពឹះ ប៉ាគ់ អីស អា កេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ប៉ាថេត អ៊ីស៊ីប ទិ អា ស៊ុត កា អីស កេះ រ៉ាំងហៃ ទឹល នីណោ័ះ អន់ អុះ ម៉ី លូ ពឹ អីស អន់ឌែ អ្វៃ ពឹង ព្រី ចំ ឡាក់ ដាគ់ ហ៊្លត ឡឹង ពូ ពិ។ ហគ់ អន់ អន់ឌែ ឡាំ អ្វៃ ប៉ាគ់ ព្រី កូស៊ែន តោ ពិ។ ទិ អុះ ម៉ី អីស ណោះ ផា អីស ប៉ប័ ពឿ អន់ដា ដាគ់ សាឡាច់ អីស ប៉្រើ អន់ឌែ រង ចៀម អាញ់ ណើ»។ ");
INSERT INTO tpu_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","យូស៊ែប កា ប៉ាណាំ ពឹ អ៊ែ ឡាំ ប៉ាគ់ សាដាច់ អ៊ីស៊ីប ដេល។ វគ័ យ៉ាកុប កាប លូ សាដាច់ ផា «អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ដាគ់ កា អីស»។ ");
INSERT INTO tpu_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","សាដាច់ អំប៉ញ់ វគ័ យ៉ាកុប ផា «អីស អាញុ ប៉ុប ចំ កេះ វគ័ ?» ");
INSERT INTO tpu_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","វគ័ យ៉ាកុប តើល ផា «អាញ់ អាញុ ១៣០ សាណាំ កេះ ទឹប រ៉ើ ចារ អ្វៃ អៀង ចារ កេះ ទឹប ទី សារ ឡាំបាក អៀង ដេល។ អាញុ អាញ់ អូ អ្លឹង អុះ អាញ់ អូ រ៉ីស ទុញ ឡាក់ កា វគ័ យ៉ាគ់ អាញ់ សើគ ពែ ទី អាញុ អ្លឹង អ្វៃ ពឹង អង់កក់ តេះ អា»។ ");
INSERT INTO tpu_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","កេះណោះ វគ័ យ៉ាកុប ប៉រ់ សារ ដាគ់ អន់ កា សាដាច់ អ៊ែ កា ចាក ឡាច់ ឡឹង ចារ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","យូស៊ែប អន់ ចារ កា អុះ ម៉ី លូ ពឹ អ៊ែ ប៉្រគ័ ស្រុក អ្វៃ ក្យាម័ មឿង រ៉ាមសេ ឡាក់ តេះ ដាគ់ ហ៊្លត ឡឹង ពូ ពឹង ប៉ាថេត អ៊ីស៊ីប ត្រគ់ ឡាក់ កា សាដាច់ ប៉្រើ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","យូស៊ែប កា អន់ សាប្យាំង កា ពឹ អ៊ែ លូ អុះ ម៉ី ហី ក្រាន ទិណោ័ះ តាម ចំលួន គន សោ អន់ឌែ ណោះ ហង។ … ");
INSERT INTO tpu_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","មួត អ៊ីស្រាអ៊ែល អ្វៃ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ណោះ ប៉្រគ័ ស្រុក ប៉ាគ់ ព្រី កូស៊ែន ចារ ណោះ កា កើត ចារ អន់ឌែ ទៅ ហង។ ឡៃង ឡឹង ណោះ អន់ឌែ កើត គន សោ តុត អៀង។ ");
INSERT INTO tpu_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","វគ័ យ៉ាកុប អ្វៃ ពឹង ប៉ាថេត អ៊ីស៊ីប ទី ១៧ សាណាំ អាញុ អ៊ែ ទិណោ័ះ ទី ១៤៧ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ប៉ាគ់ វគ័ យ៉ាកុប ក្យាម័ ចឹង តោ័ កេះ អ៊ែ អើ គន អ៊ែ យូស៊ែប ឡាំ ប៉ាគ់ ចារ អ៊ែ កេះណោះ អន់តគ់ រ៉ះ ផា «អឺ គន ផា អីស ប៉ិច ចៃ កា ពឹ តាទឹច ហគ់ អីស ចៃគ តី កាន់តេ័ះ ព្លូ អាញ់ អា  លូ ម៉ត់ ផា អីស ចឹង ដាគ់ ត្រង់ លូ តាប៉ាប តាប៉ុន កា អាញ់ លូ អីស ចឹង អូ តប់ ប៉ាទ្រូ អាញ់ ពឹង ប៉ាថេត អ៊ីស៊ីប អា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ប៉ាគ់ អាញ់ តោ័ អីស អន់ អាញ់ អ្វៃ ប៉ាគ់ ចារ វគ័ យ៉ាគ់ អាញ់។ អីស ត្រគ់ អ្យក់ ឡាច់ ប៉ាទ្រូ អាញ់ ឡឹង ប៉ាថេត អ៊ីស៊ីប អា សឹត តប់ ប៉ាគ់ រ៉ូង័ ចារ តប់ ប៉ាទ្រូ វគ័ យ៉ាគ់ ពិន តោ ហោគ»។ យូស៊ែប តើល ផា «អឺះ ពឹ អាញ់ ចឹង ប៉្រគ័ ពួយ ប៉ានឹរ អីស រ៉ះ អា»។ ");
INSERT INTO tpu_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","កេះណោះ វគ័ យ៉ាកុប កាប ណាវ្គ ផា «គន ហគ់ អីស ម៉ត់ លូ អាញ់»។ យូស៊ែប កា ម៉ត់ លូ អ៊ែ តាទឹច។ វគ័ យ៉ាកុប កា មូប កល់ ប៉ានេ ប‌៉្រ័ះ ហះ គ្រេ ចារ អ៊ែ តៃប។ ");
INSERT INTO tpu_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ឡៃង ឡឹង ណោះ ពូ ឡាំ រ៉ះ កា យូស៊ែប ផា «ពឹ អីស អីគ»។ យូស៊ែប កា ឡាំ ហៃ ពឹ អ៊ែ ទ្រុង ឡាំ ទឹប គន កាម៉ាក័ អ៊ែ ពៀរ ដូវ សិច ម៉ាណាសេ លូ អេប៉្រាអ៊ីម ឡាំ អន់ឌូ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","ពូ រ៉ះ កា វគ័ យ៉ាកុប ផា «គន អីស យូស៊ែប ឡាំ ហៃ អីស»។ អ៊ែ កា ខំ រ៉ូល័ អ្យូវ អង់អ្វៃ។ ");
INSERT INTO tpu_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","យ៉ាកុប រ៉ះ កា យូស៊ែប ផា «ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ទី អំរ៉ាញ អឺញ តីស ហ៊្លត ឡឹង ពូ អ៊ែ តាំបាង ឡាកោ អន់ អាញ់ ប៉ប័ ប៉ាគ់ ស្រុក លូស ពឹង ប៉ាថេត កាណាន ពែ កេះណោះ អន់ សារ ដាគ់ កា អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","អ៊ែ រ៉ះ ផា \"អាញ់ ចឹង ប៉្រគ័ អន់ អីស ទី គន សោ អៀង កើត សុនសាត អៀង ដេល អាញ់ ចឹង មប ប៉ាថេត កាណាន អា អន់ កា ផូង័ វ៉ាច់ អីស ប៉្រគ័ ប៉ាថេត អន់ឌែ លើយ\"។ ");
INSERT INTO tpu_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","កិញអៀ អា គន អីស អេប៉្រាអ៊ីម លូ ម៉ាណាសេ ពៀរ ដូវ អា អន់ឌែ កើត ពឹង ប៉ាថេត អ៊ីស៊ីប អន់ទ្រួល ឡឹង អាញ់ បើ ទឹល ប៉ាគ់ អា។ ត្រគ់ យ៉ាប ផា គន អាញ់ ឡាក់ កា រូបេន លូ ស៊ីមៀន ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ប៉ាគ់ គន អីស ចឹង កើត លឺក អន់តីគ ទៀ ណាវ្គ ណោះ អីស ផា គន អីស។ គន អីស ចឹង កើត អន់តីគ ទៀ អន់ឌែ ចឹង ទី ប៉ាដក់ ប៉ាជៀ តេះ តាម រួម អន់ឌូ លូ អេប៉្រាអ៊ីម លូ ម៉ាណាសេ។ ");
INSERT INTO tpu_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ផះ អាញ់ សឹត ឡឹង ចារ តាវ៉ាង័ តាំងលេ ពៀរ រ៉ាជែល មើគ អីស អ៊ែ តោ័ ក្យាម័ ស្រុក អេប៉្រាតា ពឹង ប៉ាថេត កាណាន អាញ់ ឡាងត រ៉ាំបីស កាខាក់ កា អ៊ែ។ អាញ់ តប់ ប៉ាទ្រូ មើគ អីស រទ្រង ឡាំ ប៉ាគ់ ស្រុក អេប៉្រាតា»។ កិញអៀ ពូ អើ ស្រុក បេតាលេហិម ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","10","ផះ រ៉ាំងវ៉ាង ណោះ វគ័ យ៉ាកុប ក្រាគ់ កេះ ម៉ាត់ អ៊ែ កា អូ សូវ តាតារ ហៃ កាណាគ័ ញ៉ា កា អូ សូវ ប៉ប័ អុះ។ អ៊ែ ប៉ាញ់ចាក័ ហៃ គន កាម៉ាក័ យូស៊ែប លូ អំប៉ញ់ ផា «ពឿ មួត ពៀរ ដូវ អា ?» យូស៊ែប តើល ផា «អន់ឌែ អា គន អាញ់ កើត ប៉ាគ់ អា ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ កា អាញ់»។ វគ័ យ៉ាកុប កាប ផា «អីស ប៉្រើ អន់ឌែ ម៉ុត អ្វៃ ក្យាម័ អាញ់ អា អាញ់ ចឹង ប៉រ់ សារ ដាគ់ ឡឹង ប‌៉្រ័ះ អន់ កា អន់ឌែ»។ យូស៊ែប កា ប៉ាណាំ គន អ៊ែ ម៉ុត អ្វៃ ក្យាម័ ពឹ អ៊ែ យ៉ាកុប កា គ្វែត ចុំ សោ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","កេះណោះ យ៉ាកុប កាប លូ យូស៊ែប ផា «ផះ ណោះ ពែ អាញ់ អូ ទី ម៉ឹង ផា ចឹង ប៉ប័ ម៉ាត់ គន អាញ់ អុះ ហះកា កិញអៀ អា ប‌៉្រ័ះ ប៊កកាតយ័ អន់ អាញ់ ប៉ប័ ទឹប គន អីស ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","យូស៊ែប អ្យក់ ឡាច់ គន អ៊ែ ឡឹង សានែង ជុង ពឹ អ៊ែ កេះណោះ ជន តាកុល មូប កល់ ទឹះ តេះ។ ");
INSERT INTO tpu_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","កេះណោះ យូស៊ែប កា ប៉ាណាំ គន អ៊ែ ទិ ពៀរ ម៉ុត អ្វៃ ក្យាម័ ពឹ អ៊ែ ណាវ្គ។ តី សាម៉ា យូស៊ែប ចឹក អេប៉្រាអ៊ីម អន់ អ្វៃ គែង សាំងអ្យោ វគ័ យ៉ាកុប តី សាំងអ្យោ ចឹក ម៉ាណាសេ អន់ អ្វៃ គែង សាម៉ា យ៉ាកុប។ ");
INSERT INTO tpu_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","កេះណោះ វគ័ យ៉ាកុប កា ប៉ាខាត់ តី អ៊ែ តី សាម៉ា សាប៉ាគ់ ពឹង កល់ អេប៉្រាអ៊ីម ឡាក់ អុះ តី សាំងអ្យោ សាប៉ាគ់ ពឹង កល់ ម៉ាណាសេ ឡាក់ ម៉ី ។ ");
INSERT INTO tpu_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","កេះណោះ អ៊ែ ប៉រ់ សារ ដាគ់ អន់ កា អន់ឌែ ផា៖ «អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ វគ័ អាប៉្រាហាំ លូ ពឹ អាញ់ អ៊ីសាក់ រ៉ាប់ សឿ អីស រ៉ាំងហៃ អាញ់ ឡឹង កើត លើយ ទឹល រ៉ប់ ដារ់ អា។ ");
INSERT INTO tpu_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","អីស តង័ អាញ់ គ្រឹប សារ អូ ដាគ់។ កិញអៀ ប៉រ់ អីស អន់ សារ ដាគ់ កា សាស្វា ពៀរ ដូវ អា ភឿ ប៉្រគ័ អន់ ពូ កាចាំង សិច អាញ់ លូ សិច វគ័ អាប៉្រាហាំ លូ សិច ពឹ អាញ់ អ៊ីសាក់។ អន់ អន់ឌែ កើត អៀង កាខាក់ អ្វៃ ពឹង អង់កក់ តេះ អា»។ ");
INSERT INTO tpu_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","យូស៊ែប ប៉ប័ ពឹ អ៊ែ សាប៉ាគ់ តី សាម៉ា ពឹង កល់ អេប៉្រាអ៊ីម នីណោ័ះ អូ ត្រគ់ ពុត អ៊ែ អុះ អ៊ែ អ្យក់ ឡាច់ តី ពឹ អ៊ែ ឡឹង កល់ អេប៉្រាអ៊ីម ចឹង ចៃគ ពឹង កល់ ម៉ាណាសេ។ ");
INSERT INTO tpu_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","យូស៊ែប រ៉ះ កា ពឹ អ៊ែ ផា «អូ ត្រគ់ នីអៀ អុះ ពឹ ម៉ី អ៊ែ អ្វៃ គែង អា ប៉រ់ អីស សាប៉ាគ់ តី សាម៉ា ពឹង កល់ អ៊ែ គែង អា» ");
INSERT INTO tpu_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","ហះកា វគ័ យ៉ាកុប ប៉ាគែក ផា «ពឹ អ្លុ កេះ កា ម៉ាណាសេ ឡាក់ ម៉ី គន។ អ៊ែ កា ចឹង ទី សុនសាត ម៉ោញ កើត ឡាច់ ឡឹង អ៊ែ ដេល។ ហះកា អុះ អ៊ែ ចឹង កើត សុនសាត ម៉ោញ ឡាក់ អៀង ហ៊្លត ឡឹង អ៊ែ ណាវ្គ ឃឺ ផូង័ វ៉ាច់ អេប៉្រាអ៊ីម ចឹង កើត សុនសាត អៀង ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ដារ់ ណោះ អ៊ែ ប៉រ់ សារ ដាគ់ អន់ កា សាស្វា ពៀរ ដូវ ណោះ ផា៖ «សុនសាត អ៊ីស្រាអ៊ែល ចឹង យរ សិច អន់ដីស ប៉រ់ សារ ដាគ់ អន់ កា គួប សោប ផា៖ អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ដាគ់ កា អីស អៀង ឡាក់ កា អេប៉្រាអ៊ីម លូ ម៉ាណាសេ ដេល»។ វគ័ យ៉ាកុប អើ សិច អេប៉្រាអ៊ីម អន់ទ្រួល ឡឹង ម៉ាណាសេ។ ");
INSERT INTO tpu_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","យ៉ាកុប រ៉ះ កា យូស៊ែប ផា «ហៃ អាញ់ ក្យាម័ ចឹង តោ័ កេះ ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ អន់ឌូ លូ រ៉ាំងហៃ អន់ដីស ទិឌូ ដេល។ អ៊ែ ចឹង ប៉ាណាំ អន់ដីស សឹត ប៉ាគ់ ប៉ាថេត វគ័ យ៉ាគ់ អន់ដីស ទៅ ណាវ្គ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","អាញ់ ចឹង អន់ តេះ កា អីស ម៉ោញ ចានែក ណាវ្គ ហ៊្លត ឡឹង អុះ ម៉ី អីស ឃឺ ប៉ានឹម ស៊ីគែម ឡាក់ អាញ់ អ្យក់ ឡឹង សុនសាត អាម៉ូរី លូ ដាវ លូ ស្រាគ់ ឡាកោ អាញ់ តាំងឡា»។ ");
INSERT INTO tpu_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","កេះណោះ វគ័ យ៉ាកុប អើ គន អ៊ែ ទិណោ័ះ លូ រ៉ះ ផា «ហគ់ អន់ដីស ពឹះ ប៉ាតុំ គួប សោប ទិឌូ អាញ់ ចឹង រ៉ះ អន់ កា អន់ដីស អ្លុ ឡឹង សារ ឡាក់ ចឹង ត្រគ់ កើត ពឹះ ពឹង គន សោ អន់ដីស ប៉ាគ់ យ៉ាង័ តោ ទៀ។ ");
INSERT INTO tpu_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","អឺ គន យ៉ាកុប ហគ់ អន់ដីស ពឹះ ប៉ាតុំ គួប កេះណោះ សាំយ៉ាំង អាញ់ ឡាក់ ពឹ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","អឺ រូបេន អីស ឡាក់ គន គុល អាញ់ ឡាក់ កើត អន់ទ្រួល ឡឹង ពូ ផះ អាញ់ អ្វៃ រ៉ាំងហាវ ទី សាងុំ សើគ ពែ។ អីស ឡាក់ ប៉ាណូស ហ្យាំង សាឡាច់ លូ ទី អំរ៉ាញ ហ៊្លត ឡឹង ពូ។ ");
INSERT INTO tpu_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","អីស ឡាក់ កា ទៀក ហូរ័ អូ អ្លុ តាវ ទឹល នីណោ័ះ អីស ចឹង អូ ទី ប៉្រគ័ ម៉ៃគ ពូ អុះ ខង អីស អន់តុង តៃប លូ កាម៉ាញ់ ក្យង់ អាញ់ ណោះ ហង អីស ប៉្រគ័ យច លូ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","កាប៉ាច់ ស៊ីមៀន លូ លេវី អន់ឌែ អុះ ម៉ី ប៉ាណាំ គួប ប៉្រគ័ សារ ប៉ាអ្យប់ ខូយ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","អាញ់ អូ រែវ ពុត ប៉្រគ័ សារ អូ ដាគ់ លូ អន់ឌែ អុះ អាញ់ កា អូ ចៃ ម៉ុត លួម អន់ឌូ លូ អន់ឌែ ដេល ខង ផា អន់ឌែ អឺក អន់ឌែ ប៉ាន់តោ័ ប៉ាណូស ផា អន់ឌែ ហោក រ៉គ់ អន់ឌែ កោះ រ៉ាណាញ់ ជួន រ៉ក់។ ");
INSERT INTO tpu_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","អាញ់ ប៉ាស្យាប កា សារ អន់ឌែ អឺក ណោះ ខង អន់ឌែ ប៉ាអ្យប់ ខូយ យ៉ឹប។ អាញ់ ចឹង អន់ គន សោ អន់ឌែ ពៀរ ដូវ ណោះ ក្លះ ឡឹង អុះ ម៉ី អន់ឌែ លូ អាញ់ ចឹង អូ អន់ ចារ កា អន់ឌែ កាណុង ផូង័ វ៉ាច់ យ៉ាកុប»។ ");
INSERT INTO tpu_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","កេះណោះ អ៊ែ ផា៖ «អឺ យូដា អុះ ម៉ី អីស ចឹង ប៉ានេ តាគ់ អំប៉ោក អីស អីស ចឹង ទី អំរ៉ាញ អឺញ ទី ទ្រង អីស លូ មួត តាម៉ឺរ អុះ ម៉ី អីស អន់ឌែ ចឹង ជន តាកុល សាំប‌៉័ះ អីស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","អឺ យូដា អីស ឡាក់ កា ប៊ក ផះ ប៉ាញ័ តាម័ សឹត ឡឹង កាប់ សា អ្យាំ អីស ឡាក់ កា ប៊ក តីស ប៊ក ក្រាគ់ អ៊ែ តៃប កាតាម ប៉្វាន័ កាតាម អូ ទី ពឿ ខឹន រ៉ោ អ៊ែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","ផូង័ វ៉ាច់ យូដា ចឹង ប៉្រគ័ សាដាច់ លើយ អូ ទី ហ៊្យង អុះ និះ ទឹល គន សោ ម៉ោញ ដូវ ណាវ្គ ចឹង ហាវ ប៉្រគ័ សាដាច់ ប៉ាសុន ទិឌូ កា ចឹង ម៉ុត គែង អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","តេះ អ៊ែ ចឹង ដាគ់ សាណា ខាក់ ណោះ ហង បះ អ៊ែ ចឹង កត់ លៀ ពឹង តើម អង់កាច។ តាពែ ប៉្លៃ អង់កាច អ៊ែ ចឹង ហូរ័ ឡាក់ កា ទៀក ណោះ ហង បះ អ៊ែ ចឹង ប៉ីស ខោ អាវ លូ ទៀក តាពែ។ ");
INSERT INTO tpu_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ម៉ាត់ អ៊ែ ម៉ូ ក្វា ឡឹង តាពែ ប៉្លៃ អង់កាច សាណាញ់ អ៊ែ បាក ក្វា ឡឹង ទៀក តុះ រ៉ក់។ ");
INSERT INTO tpu_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","កាប៉ាច់ សេប៊ូលុន អ៊ែ ចឹង អ្វៃ រហាង សាឡីគ សាឡាយ អ៊ែ ចឹង ទី ចារ ដាគ់ សាំរ៉ាប់ កត់ កាំប៉ាន់។ គួយ ព្រី ទៀក សេប៊ូលុន តីស កាខាក់ ទឹល មឿង ស៊ីដូន។ ");
INSERT INTO tpu_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","កាប៉ាច់ អ៊ីសាខារ វ៉ឹច លូ លៀ តីស សាងុំ តៃប ទឹប កាប៉ោ ពៀរ ពឹង អង់កក់ ។ ");
INSERT INTO tpu_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","អ៊ីសាខារ ឃឹត ផា ចារ អ៊ែ រ៉ាឡូវ ណោះ ដាគ់ ខាក់ ផា អ្វៃ ពឹង ស្រុក ណោះ ឃឺ ដាគ់ សាណុក ដេល។ ទឹល នីណោ័ះ អ៊ែ មូប ឡាកោ អន់ ពូ ចៃគ ងង ប៉ាទុក កាណាគ័ លូ អន់ ពូ យរ អ៊ែ ឡាក់ កា ទុច។ ");
INSERT INTO tpu_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","កាប៉ាច់ ដាន់ អ៊ែ ចឹង រ៉ាំងហៃ ប៉ាសុន អ៊ែ ទៅ ឡាក់ កា ផូង័ វ៉ាច់ អ៊ីស្រាអ៊ែល អន់ទៀគៗ រ៉ាំងហៃ ប៉ាសុន អន់ឌែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ដាន់ អ៊ែ វ៉ឹច លូ ពិះ ចាក រទ្រង ឡាក់ កា ពិះ ប្លក់កាង ក្យាគ់ ចោះ ជុង សេះ ប៉្រគ័ អន់ កា បក់ ជិះ សេះ ឡិ កាតាង។ ");
INSERT INTO tpu_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","អឺ ប‌៉្រ័ះ ប៊កកាតយ័  អាញ់ ម៉ឹង អីស ហង ចឹង តង័ អន់ ញឹន រ៉ីស។ ");
INSERT INTO tpu_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","កាប៉ាច់ កាត តាហាន ពូ អន់ទៀគ ចឹង ឡាំ តាកូះ ប្ល‌៉័ះ លូ កាំឡាំង អ៊ែ ហះកា អ៊ែ ចឹង ម៉ុត តាកូះ លូ តាហាន ណោះ ទ្រង អង់កក់ ពូ។ ");
INSERT INTO tpu_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","កាប៉ាច់ អាស៊ើរ តេះ អ៊ែ ដាគ់ សាណា ខាក់ អ៊ែ ចឹង ប៉្រគ័ សាណា ប៉ាអាំៗ អន់ កា សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","កាប៉ាច់ ណាប់ថាលី អ៊ែ ឡាក់ កា ជ្វេ យ៉ង់ សាតាក់ ប៉ាប៉្លង់ តាម ពុត ប៉ិច កេះណោះ ប៉ាំងកើត គន ដាគ់ ឡាយ៉ាម័។ ");
INSERT INTO tpu_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","កាប៉ាច់ យូស៊ែប ពៀប ឡាក់ កា ចាណាត់ តើម អ៊្លង ចាត់ ហះ ហាង ទៀក តាំងកង់ អ៊ែ ចាំងហីគ ឡឹង ប៉ាន់ទៀយ មឿង។ ");
INSERT INTO tpu_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","មួត តាម៉ឺរ ប៉ាណាំ គួប ណាំង សារ លូ យូស៊ែប អន់ឌែ ប៉ាញ់ អ៊ែ លូ ស្រាគ់។ ");
INSERT INTO tpu_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ហះកា ស្រាគ់ យូស៊ែប រ៉ាក់ កេង តី អ៊ែ កា តាំរ៉ាល់ ប៉្រាល់ ដេល ខង ប‌៉្រ័ះ អាញ់ ឡាក់ ទី អំរ៉ាញ អឺញ តង័ អ៊ែ ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ រ៉ាំងហៃ រង លូ ប៉ងកាន់ សុនសាត អ៊ីស្រាអ៊ែល តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","អន់ ប‌៉្រ័ះ អាញ់ តង័ អីស ប៉រ់ ប‌៉្រ័ះ ឡាក់ ទី អំរ៉ាញ អឺញ ហ៊្លត ឡឹង ពូ អន់ សារ ដាគ់ កា អីស លូ អន់ ទៀក បី ឡឹង ប៉្លៃង លូ អន់ ទី ទៀក អន់ដូង័ ទៀក ទ្រូង។ អន់ អីស ទី គន សោ អៀង លូ ទី កាណាគ័ រង អៀង ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","សារ ដាគ់ អាញ់ ប៉រ់ អន់ កា អីស អា អន់ ដាគ់ តីស លឺន ឡឹង ប៉ានឹម លូ ចាំងហីគ ក្វា ឡឹង កល់ ប៉ានឹម ឡាក់ អ្វៃ លើយ។ អន់ សារ ដាគ់ ទិ អា ទី ទិ កា យូស៊ែប ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ើស អន់ ប៉្រគ័ ម៉ៃគ អុះ ម៉ី អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","បេនយ៉ាមីន អ៊ែ ខូយ តាកេះ ឡាក់ កា សូ ព្រី ណាំង កាប់ សា អ្យាំ រ៉ប់ កាំលឺ លូ អ្យក់ សឹត ជែក អន់ កា គួប សា ប៉ាគ់ កាង៉ាច»។ ");
INSERT INTO tpu_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","យ៉ាកុប ប៉រ់ សារ ដាគ់ ឡឹង ប‌៉្រ័ះ ប៊កកាតយ័ អន់ កា គន អ៊ែ ទិ ១២ ដូវ ឡាក់ កា អន់ឌែ ចឹង ត្រគ់ ទី។ អន់ឌែ អា ហង ឡាក់ ផូង័ វ៉ាច់ អ៊ីស្រាអ៊ែល ១២ ផូង័ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","កេះណោះ វគ័ យ៉ាកុប អន់តគ់ រ៉ះ កា គន អ៊ែ ណាវ្គ ផា «អាញ់ ចឹង តោ័ ពួយ វគ័ យ៉ាគ់ អាញ់ ហង។ អន់ដីស ត្រគ់ តប់ អាញ់ ពឹង រ៉ូង័ ហះ សានែង អន់ឌែ ប៉ាគ់ ម៉ីរ វគ័ អេប៉្រូន សុនសាត ហេត តោ។ ");
INSERT INTO tpu_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ត្រគ់ តប់ ប៉ាទ្រូ អាញ់ ពឹង ម៉ីរ ប៉ាគ់ ស្រុក ម៉ាកពេឡា ក្យាម័ ចារ វគ័ ម៉ាមរេ ពឹង ប៉ាថេត កាណាន ឡាក់ ម៉ីរ វគ័ អាប៉្រាហាំ តាច់ ឡឹង វគ័ អេប៉្រូន សាំរ៉ាប់ ចារ តប់ ប៉ាទ្រូ។ ");
INSERT INTO tpu_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","ពឹង ចារ ណោះ ហង ពូ តប់ វគ័ អាប៉្រាហាំ លូ កាម៉ាញ់ អ៊ែ យ៉ាគ់ សារ៉ា ទឹប ពឹ អាញ់ អ៊ីសាក់ លូ មើគ អាញ់ រេបិកា។ អាញ់ កា តប់ លេអា ហះ ចារ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ម៉ីរ លូ រ៉ូង័ ណោះ វគ័ អាប៉្រាហាំ តាច់ ឡឹង សុនសាត ហេត»។ ");
INSERT INTO tpu_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","វគ័ យ៉ាកុប អន់តគ់ រ៉ះ កា គន ទិ កេះ អ៊ែ តៃប ពឹង គ្រេ ណាវ្គ កេះណោះ កាតាច់ កាស៊ែ តាំងហើម តោ័ ពួយ វគ័ យ៉ាគ់ អ៊ែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","យូស៊ែប ញ៉ាំ គ្វែត ចុំ ពឹ អ៊ែ លូ ហូរ័ ទៀក ម៉ាត់ ត្រគ់ ម៉ូះ ម៉ាត់ ពឹ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","កេះណោះ យូស៊ែប ប៉្រើ មួត ម៉ូអ្យា អ៊ែ ចាឡប់ អន់ហ៊្នង ប៉ាទ្រូ ពឹ អ៊ែ ជែ អន់ អោម។ មួត ម៉ូអ្យា កា ប៉ាណាំ គួប ចាឡប់ អន់ហ៊្នង ប៉ាទ្រូ វគ័ យ៉ាកុប តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","អន់ឌែ អ្វៃ ប៉្រគ័ ង៉ារ អន់ហ៊្នង ប៉ាទ្រូ ណោះ ទុញ ៤០ ដារ់។ សុនសាត អ៊ីស៊ីប ប៉ាណាំ គួប អ្វៃ ឃឹត រ៉ាំបីស កា ប៉ាទ្រូ វគ័ យ៉ាកុប ណោះ ទុញ ៧០ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","ទឹល គ្រឹប ដារ់ ពូ អ្វៃ ឃឹត រ៉ាំបីស កេះ យូស៊ែប រ៉ះ កា មួត បក់ អ្វៃ ប៉្រគ័ កាន លូ សាដាច់ ផា «អឺ អុះ ម៉ី ផា អន់ដីស តាប៉ាប តាប៉ុន កា អាញ់ តាទឹច ប៉រ់ អន់ដីស រ៉ះ ប៉ានឹរ អាញ់ អា កា សាដាច់ ណើ។ ");
INSERT INTO tpu_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","ផះ ពឹ អាញ់ អ្វៃ រ៉ីស ពែ អ៊ែ រ៉ះ ផា \"អាញ់ ក្យាម័ ចឹង តោ័ កេះ គន។ ប៉រ់ អីស ម៉ត់ ផា ចឹង ឡាំ តប់ ប៉ាទ្រូ អាញ់ ប៉ាគ់ ប៉ាថេត កាណាន តោ កាណុង រ៉ូង័ ឡាក់ អាញ់ ទី ទ្រៀម កេះៗ\"។ ទឹល នីណោ័ះ អាញ់ ប៉រ់ ឡាំ តប់ ប៉ាទ្រូ ពឹ អាញ់ អា ហិ។ កេះ តប់ អាញ់ ចឹង សឹត ប៉ាគ់ អា ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","សាដាច់ តើល ផា «ឡាំ តប់ ប៉ាទ្រូ ពឹ អីស ណោះ ពិ ប៉្រគ័ ឡាក់ កា អ៊ែ ប៉្រើ អីស ម៉ត់ ណោះ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ផះ យូស៊ែប ឡាំ តប់ ពឹ អ៊ែ ណោះ មួត អ្វៃ ប៉្រគ័ កាន ពឹង ចារ សាដាច់ ទឹប មួត ក្រាគ់ មួត រ៉ាតីស ពឹង ប៉ាថេត អ៊ីស៊ីប កា ឡាំ អន់ឌូ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ហី ក្រាន យូស៊ែប លូ ហី ក្រាន ពឹ អ៊ែ ទិឌូ លូ អុះ ម៉ី អ៊ែ ណោះ កា ឡាំ អន់ឌូ ដេល អ្លាត ដឹង គន សោ លូ តាប៉ល់ ចៀម លូ តាប៉ល់ រ៉ក់ អ្វៃ ពឹង ស្រុក កូស៊ែន ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ទី រ៉ាតេ័ះ លូ ទី មួត តាហាន ជិះ សេះ លូ ទី ប៉ាណូស អៀង កាគឹក កាគួរ ឡាំ អន់ឌូ លូ យូស៊ែប ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ប៉ាគ់ ទឹល ស្រុក អាថាត់ ចារ ពូ ប៉្រះ ពៀ គែង ដារ់ ឡាច់ ទៀក ទ្រូង យដាន់ អន់ឌែ ញ៉ាំ អង់ហ្យាំង រ៉ាវ៉ើក ថើក កាខាក់។ យូស៊ែប អ្វៃ ញ៉ាំ សោក កា ពឹ អ៊ែ ហះ ណោះ ទុញ តាំប៉ើះ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","សុនសាត កាណាន បក់ អ្វៃ ពឹង ស្រុក ណោះ អន់ឌែ ប៉ប័ ពូ អង់ហ្យាំង ញ៉ាំ កាខាក់ កា ប៉ាទ្រូ យ៉ាកុប ពឹង ចារ ប៉្រះ ពៀ ណោះ។ អន់ឌែ កា កាប ផា «យើយ សុនសាត អ៊ីស៊ីប ទី កាន ចុនចៃ ខាក់ អ៊ិះ» ញន ខ ណោះ ហង បះ ពូ អន់ សិច ចារ គែង ដារ់ ឡាច់ ទៀក ទ្រូង យដាន់ ណោះ ផា អេបិល មីសារ៉ៃម ។ ");
INSERT INTO tpu_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","គន សោ វគ័ យ៉ាកុប អន់ឌែ ប៉ាណាំ គួប ប៉្រគ័ ពួយ ប៉ានឹរ ពឹ អន់ឌែ អន់តគ់ រ៉ះ ពែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","អន់ឌែ កា អ្យក់ សឹត ប៉ាទ្រូ ពឹ អន់ឌែ ប៉ាគ់ ប៉ាថេត កាណាន កេះណោះ តប់ កាណុង រ៉ូង័ ពឹង ម៉ីរ ប៉ាគ់ ស្រុក ម៉ាកពេឡា ក្យាម័ ចារ ម៉ាមរេ ឡាក់ ម៉ីរ វគ័ អាប៉្រាហាំ តាច់ ឡឹង វគ័ អេប៉្រូន សុនសាត ហេត សាំរ៉ាប់ ចារ តប់ ប៉ាទ្រូ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ឡៃង ឡឹង តប់ ប៉ាទ្រូ កេះៗ យូស៊ែប លូ អុះ ម៉ី អ៊ែ លូ កាំឡាំង ឡាក់ ឡាំ តប់ ប៉ាទ្រូ ពឹ អ៊ែ ណោះ កា សឹត ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","ម៉ីៗ យូស៊ែប ហៃ កា ពឹ អន់ឌែ តោ័ កេះ អន់ឌែ កា កាប លូ គួប ផា «ចាបះ កា យូស៊ែប ចឹង អឺក កា ពិន លូ អ៊ែ ចឹង តូ គ្រឹប សារ អូ ដាគ់ ឡាក់ ពិន ប៉្រគ័ កា អ៊ែ ពែ ហង តាម ហៃ»។ ");
INSERT INTO tpu_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","ទឹល នីណោ័ះ ម៉ីៗ យូស៊ែប អន់ឌែ ប៉្រើ ពូ ឡាំ រ៉ះ កា យូស៊ែប នីអៀ «ផះ ពឹ ពិន បើ តោ័ ពែ អ៊ែ អន់តគ់ រ៉ះ ផា ");
INSERT INTO tpu_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","\"អ្យគ័ អន់ដីស រ៉ះ ប៉ានឹរ អាញ់ ផា កា យូស៊ែប 'អឺ គន អីស ជែ អ្យក់ យ៉ូ សារ អូ ដាគ់ លូ បាប ឡាក់ ម៉ីៗ អីស ប៉្រគ័ កា អីស ណោះ' \"។ ញឹន ប៉្រគ័ អូ ដាគ់ កា អីស កេង តាទឹច ហះកា កិញអៀ អា ប៉រ់ អីស តាប៉ាប តាប៉ុន កា ញឹន ណើ ខង ញឹន ឡាក់ ទុច ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ពឹ ពិន ឃើយ អ្យិល កូត័ ណោះ ដេល»។ យូស៊ែប កាតាំង ពូ រ៉ះ នីណោ័ះ អ៊ែ កា ញ៉ាំ។ ");
INSERT INTO tpu_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","កេះណោះ ម៉ីៗ យូស៊ែប អន់ឌែ ឡាំ ឡាកោ អន់ឌែ ទៅ ឡគ ប៉ាគ់ យូស៊ែប ណោះ អន់ឌែ ប៉ាណាំ គួប ជន តាកុល សាំប‌៉័ះ ហះ ជុង យូស៊ែប លូ កាប ផា «ញឹន ចឹង ប៉្រគ័ ទុច អីស កាតាម អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","យូស៊ែប រ៉ះ កា អន់ឌែ ផា «ជែ អ្យូគ អាញ់ អូ ចៃគ ថូត អន់ដីស តាង ប‌៉្រ័ះ ប៊កកាតយ័ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","អន់ដីស ប៉ាណាំ គួប ឃឹត ប៉្រគ័ អូ ដាគ់ កា អាញ់ ផះ អន់ទ្រួល ពែ ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ សារ អូ ដាគ់ ណោះ កើត ដាគ់ កេះ ឡាក់ កា ពិន ទី ប៉ប័ ដារ់ អា ហង។ ប‌៉្រ័ះ ប៊កកាតយ័ ទី តង័ ប៉ាណូស អៀង អន់ អ្វៃ រ៉ីស»។ ");
INSERT INTO tpu_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","យូស៊ែប កាប ប៉ាឡោម ពុត ពៀក មួត ម៉ីៗ អ៊ែ ដាគ់ៗ ប៉ាឡឹងៗ អ៊ែ ផា «កិញអៀ អា អន់ដីស ជែ អ្យូគ អាញ់ ចឹង តង័ សិម អន់ដីស លូ គន សោ អន់ដីស ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","យូស៊ែប លូ គន សោ ពឹ អ៊ែ អន់ឌែ អ្វៃ ពឹង ប៉ាថេត អ៊ីស៊ីប ណោះ ហង។ យូស៊ែប អ្វៃ រ៉ីស ទី ១១០ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","យូស៊ែប តាន័ ប៉ប័ សោ អ៊ែ គន អេប៉្រាអ៊ីម លូ តាន័ ប៉ប័ សោ ចិច អ៊ែ ឃឺ គន ម៉ាគីរ ឡាក់ សោ ម៉ាណាសេ លូ ទី ពៅ ពឹង ព្លូ អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","យូស៊ែប រ៉ះ លូ អុះ ម៉ី អ៊ែ ផា «អាញ់ ក្យាម័ ចឹង តោ័ ហង ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ជឹរ តង័ អន់ដីស ណាវ្គ ទឹប អ៊ែ ចឹង ប៉ាណាំ អន់ដីស ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប អា សឹត ប៉ាគ់ ប៉ាថេត កាណាន ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ម៉ត់ ចឹង អន់ កា វគ័ អាប៉្រាហាំ លូ អ៊ីសាក់ លូ យ៉ាកុប»។ ");
INSERT INTO tpu_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","កេះណោះ យូស៊ែប រ៉ះ កា គន សោ យ៉ាកុប ផា «ហគ់ អន់ដីស ម៉ត់ លូ អាញ់។ ប៉ាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ ជឹរ តង័ អន់ដីស ទៀ អន់ដីស ត្រគ់ អ្យក់ ឡាច់ កាន់តីង ប៉ាទ្រូ អាញ់ ឡឹង ប៉ាថេត អា អ្យក់ សឹត អន់ឌូ លូ អន់ដីស ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","យូស៊ែប តោ័ ណោះ អ៊ែ អាញុ ១១០ សាណាំ។ ពូ ចាឡប់ អន់ហ៊្នង ចៃគ កាណុង ឡោង កេះណោះ គម រ៉ាន់ដាប់ ពឹង ប៉ាថេត អ៊ីស៊ីប ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","អា ហង គន វគ័ យ៉ាកុប ឡាក់ ម៉ុត អ្វៃ ពឹង ប៉ាថេត អ៊ីស៊ីប អន់ឌូ លូ អ៊ែ ទឹប ខាប់ខួ អន់ឌែ ទី សិច ឡាក់ កា នីអៀ៖ ");
INSERT INTO tpu_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","រូបេន ស៊ីមៀន លេវី យូដា ");
INSERT INTO tpu_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","អ៊ីសាខារ សេប៊ូលុន បេនយ៉ាមីន ");
INSERT INTO tpu_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ដាន់ ណាប់ថាលី កាត លូ អាស៊ើរ។ ");
INSERT INTO tpu_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","គន សោ វគ័ យ៉ាកុប ទិណោ័ះ ទី ៧០ ដូវ ទឹប យូស៊ែប ឡាក់ អ្វៃ ពឹង ប៉ាថេត អ៊ីស៊ីប អន់ទ្រួល កេះ។ ");
INSERT INTO tpu_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","ឡៃង ឡឹង រ៉ាំងហាវ យូស៊ែប លូ អុះ ម៉ី អ៊ែ តោ័ ទិ កេះ ");
INSERT INTO tpu_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","សុនសាត អ៊ីស្រាអ៊ែល កើត រ៉ាល ហ៊ែង អៀង កាខាក់ អន់ឌែ អ្វៃ ប៉ាញ័ ទឹប ប៉ាថេត អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ឡៃង ឡឹង ណោះ ទី សាដាច់ ណាវ ម៉ោញ ដូវ ណាវ្គ អ្វៃ រ៉ាំងហៃ ពឹង ប៉ាថេត អ៊ីស៊ីប អ៊ែ អូ អន់ហ្នាល់ យូស៊ែប អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","សាដាច់ អ៊ីស៊ីប រ៉ះ កា ប៉ាសុន អ៊ែ ផា «កិញអៀ អា អន់ដីស ហៃៗ សុនសាត អ៊ីស្រាអ៊ែល ទី កាំឡាំង អៀង តាឡាម័ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","ទឹល នីណោ័ះ ពិ ពិន ប៉ាញ៉ា កា អន់ឌែ ភឿ ជែ អន់ កើត រ៉ាល ហ៊ែង អៀង ណាវ្គ។ ផា ពិន អូ ប៉្រគ័ នីណោ័ះ ផា ប៉ាថេត ពិន អា កើត សាំងខាម ទៀ ចាបះ កា អន់ឌែ ចឹង ម៉ុត ពុត អន់ឌូ លូ មួត តាម៉ឺរ តាកូះ ប្ល‌៉័ះ លូ ពិន កេះណោះ ប៉ាណាំ គួប ឡាច់ ឡឹង ប៉ាថេត ពិន អា»។ ");
INSERT INTO tpu_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","ទឹល នីណោ័ះ សុនសាត អ៊ីស៊ីប ប៉្រើ កាំឡាំង អន់ឌែ ប៉្រគ័ ម៉ៃគ រ៉ាំងហៃ សុនសាត អ៊ីស្រាអ៊ែល ភឿ ប៉ាំងខំ អន់ ប៉្រគ័ ង៉ារ ក្លេ័ះ ក្លាំង។ សុនសាត អ៊ីស្រាអ៊ែល ប៉្រគ័ មឿង ពិថុំ លូ មឿង រ៉ាមសេ អន់ កា សាដាច់ អ៊ីស៊ីប សាំរ៉ាប់ ចៃគ រ៉ាន់ដាប់ ភែ លូ រ៉ាស អំប៉ាស។ ");
INSERT INTO tpu_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","ពូ ប៉្រគ័ បាប សុនសាត អ៊ីស្រាអ៊ែល ប៉ុប ចំ អ៊ីស្រាអ៊ែល កា កើត ហ៊ែង អៀង កាខាក់ ដេល អ្វៃ ប៉ាញ័ ទឹប ប៉ាថេត ប៉្រគ័ អន់ កា សុនសាត អ៊ីស៊ីប អ្យូគ លូ អូ ណីស កា អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ណោះ ហង បះ អន់ឌែ យរ អ៊ីស្រាអ៊ែល ប៉្រគ័ ង៉ារ ហ៊ែង ក្លេ័ះ ហ៊ែង ក្លាំង។ ");
INSERT INTO tpu_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","អន់ឌែ ប៉្រគ័ អន់ កា អ៊ីស្រាអ៊ែល ថុក ញ៉ាក ឡាំបាក កាខាក់ លូ យរ ប៉្រគ័ អិត លូ យរ ប៉្រគ័ ង៉ារ ក្លេ័ះ ក្លាំង គ្រឹប នែវ ទឹប ប៉ាគ់ ម៉ីរ ប៉ាគ់ ស៊្រែ។ ");
INSERT INTO tpu_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","សាដាច់ អ៊ីស៊ីប ប៉្រើ មួត យ៉ាគ់ប៊យ សុនសាត ហេព្រឺ ពៀរ ដូវ ម៉ោញ សិច ស៊ីប៉្រា ម៉ោញ ណាវ្គ សិច ពូអា ផា ");
INSERT INTO tpu_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","«ដារ់ ចំ អន់ដីស ប៉្រគ័ យ៉ាគ់ប៊យ កា មួត សុនសាត ហេព្រឺ អន់ដីស ត្រគ់ ប៉ានិត ហៃ គន ណោះ ផា គន កាម៉ាក័ ត្រគ់ ប៉ាន់តោ័ អ្លាត ផា គន អង់កាន់ គម អន់ អ៊ែ អ្វៃ រ៉ីស ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ហះកា មួត យ៉ាគ់ប៊យ ណោះ អូ ប៉្រគ័ ពួយ សារ សាដាច់ ប៉្រើ ណោះ អុះ ខង អន់ឌែ អ្យិល កូត័ អ្យូគ កា ប‌៉្រ័ះ ប៊កកាតយ័។ អន់ឌែ គម អន់ គន កាម៉ាក័ អ្វៃ រ៉ីស និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","សាដាច់ អ៊ីស៊ីប អ្លុ អន់តគ់ អ៊ែ កា អើ មួត យ៉ាគ់ប៊យ ណោះ កេះណោះ អំប៉ញ់ ផា «ខ ញ៉ា បះ អន់ដីស ប៉្រគ័ នីអៀ ? ញ៉ា ត្រគ់ គម អន់ គន កាម៉ាក័ អ្វៃ រ៉ីស នីណោ័ះ ?» ");
INSERT INTO tpu_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","អន់ឌែ រ៉ះ កា សាដាច់ ផា «អង់កាន់ សុនសាត ហេព្រឺ អូ ត្រគ់ ឡាក់ កា អង់កាន់ សុនសាត អ៊ីស៊ីប អុះ។ អង់កាន់ អន់ឌែ ណោះ អ្វៃ ហះ អុញ ឡាម៉គ់ ខាក់ យ៉ាគ់ប៊យ ឡាំ បើ តាន័ ទឹល អន់ឌែ រ៉ាវ៉ាច់ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","ទឹល នីណោ័ះ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ដាគ់ កា មួត យ៉ាគ់ប៊យ ណោះ។ ញន កា អន់ឌែ អ្យិល កូត័ អ្យូគ កា អ៊ែ អ៊ែ កា អន់ អន់ឌែ ទី គន ដេល អ៊ែ កា ប៉្រគ័ អន់ សុនសាត ហេព្រឺ កើត ហ៊ែង អៀង ៗ ទឹប ទី សាងុំ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ឡៃង ឡឹង ណោះ សាដាច់ ប៉្រើ ប៉ាសុន អ៊ីស៊ីប ផា «អន់ដីស ត្រគ់ អ្យក់ គន កាម៉ាក័ សុនសាត ហេព្រឺ បក់ អង់ក័ះ កើត ទិណោ័ះ វ៉ឹត អ្លាត ពឹង ទៀក តាំងលេ នីល គម ដឹង គន អង់កាន់ អន់ អ្វៃ រ៉ីស»។ ");
INSERT INTO tpu_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","រ៉ាំងវ៉ាង ណោះ ទី កាម៉ាក័ ម៉ោញ ដូវ កាណុង ផូង័ លេវី អ៊ែ ទី កាម៉ាញ់ កាណុង ផូង័ លេវី និះទៅ ដេល ។ ");
INSERT INTO tpu_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ឡៃង ឡឹង ណោះ កាម៉ាញ់ អ៊ែ ឡាកោ គៀម អ្វៃ ហាអុញ កើត គន កាម៉ាក័ ម៉ោញ គន ណោះ ដាគ់ តីស តង់ ឡាយ៉ាម័ ខាក់ អ៊ែ អោន ទី ប៉ៃង ខៃ។ ");
INSERT INTO tpu_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ឡៃង ឡឹង ណោះ អ៊ែ ហៃ កា អោន គន ណោះ អូ អ្លុ ប៉្រគ័ សាគឹម ហង អ៊ែ កា អ្យក់ ពុង ពូ តាញ លូ តើម ទ្រែង កេះណោះ អ្យក់ ចារ័ ឡាប ប៉ាសឹរ ជែ អន់ ទៀក ម៉ុត កេះណោះ តាគ់ អន់តៃប គន អន់ឌែ កាណុង ពុង ណោះ ឡាំ ប៉ាឡង់ ពឹង ទៀក តាំងលេ នីល រគុំ ទ្រែង។ ");
INSERT INTO tpu_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ម៉ី អង់កាន់ សាស្វា ណោះ តាវ ហៃ ឡឹង ចាំងហាយ្គ ប៉ិច កា អ្លុ អន់តគ់ ផា ចឹង ទី សារ ញ៉ា កើត ពឹះ។ ");
INSERT INTO tpu_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ផះ ណោះ គន អង់កាន់ សាដាច់ អ៊ីស៊ីប ជឹរ ហុំ ប៉ាគ់ ទៀក តាំងលេ ទុច អ៊ែ ប៉ាណាំ គួប ចាចាក រហាង តាំងលេ។ ផាឌី គន អង់កាន់ សាដាច់ ប៉ប័ ពុង ហះ គុំ ទ្រែង អ៊ែ ប៉្រើ ទុច អ៊ែ ឡាំ អ្យក់។ ");
INSERT INTO tpu_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","កេះណោះ អ៊ែ បើក ហៃ ប៉ប័ គន សាស្វា ណោះ ផះ ញ៉ាំ អ៊ែ ទី ពុត តាប៉ាប តាប៉ុន ខាក់ លូ កាប ផា «សាស្វា អា ឃឺ គន មួត ហេព្រឺ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","ម៉ី គន សាស្វា ណោះ ឡាំ អំប៉ញ់ លូ គន អង់កាន់ សាដាច់ ណោះ ផា «អីស ប៉ិច ប កា អាញ់ ចឹង ណាំង ប៉ាណូស សុនសាត ហេព្រឺ តាម៉ម់ សាស្វា អា កា អីស ?» ");
INSERT INTO tpu_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","គន អង់កាន់ សាដាច់ ណោះ តើល ផា «អីស ឡាំ ពិ»។ ម៉ី សាស្វា ណោះ កា ឡាំ អ្យក់ មើគ សាស្វា ណោះ ទៅ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","គន អង់កាន់ សាដាច់ ណោះ រ៉ះ កា អ៊ែ ផា «ហគ់ អីស តាម៉ម់ សាស្វា អា កា អាញ់ អាញ់ ចឹង ច្វាល់ អីស លូ លៀន»។ មើគ សាស្វា ណោះ អ្យក់ តាម៉ម់ ប៉ាគ់ ហី អ៊ែ ទៅ។ ");
INSERT INTO tpu_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ប៉ាគ់ គន សាស្វា ណោះ តីស ប៊ែត កេះ អ៊ែ ឡាំ ជឹន ប៉ាគ់ គន អង់កាន់ សាដាច់ ទៅ។ គន អង់កាន់ សាដាច់ អ្យក់ អ៊ែ ប៉្រគ័ គន អ៊ែ តាំងឡា ឡូត លូ អន់ សិច ផា ម៉ូសេ ទឹប កាប ផា «សាស្វា អាញ់ ទូញ ឡឹង ទៀក»។ ");
INSERT INTO tpu_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","ប៉ាគ់ ម៉ូសេ តីស ប៉ាញ័ តាម័ កេះ អ៊ែ ឡាំ ចាចាក ប៉ាគ់ អុះ ម៉ី ផូង័ វ៉ាច់ អ៊ែ អ៊ីស្រាអ៊ែល។ អ៊ែ ប៉ប័ ពូ ប៉្រគ័ ង៉ារ ក្លេ័ះ ក្លាំង ខាក់ លូ ប៉ប័ សុនសាត អ៊ីស៊ីប ម៉ោញ ដូវ ពីត សុនសាត ហេព្រឺ ឡាក់ អុះ ម៉ី អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","អ៊ែ កាលែង ហៃ សាំងអ្យោ សាម៉ា អូ ប៉ប័ ប៉ាណូស ពឿ ហៃ អ៊ែ អុះ អ៊ែ កា តាឡូះ កាមៃ ប៉ាន់តោ័ សុនសាត អ៊ីស៊ីប ណោះ កេះណោះ តប់ កាណុង តេះ ឡាពុក។ ");
INSERT INTO tpu_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ប៉ាគ់ ដារ់ អន់តីគ ឡឹង ណោះ ណាវ្គ អ៊ែ ឡាច់ ចាចាក ណាវ្គ ប៉ប័ មួត សុនសាត ហេព្រឺ ពៀរ ដូវ ផះ តាប៉ុញ ពីត គួប សោប។ អ៊ែ អំប៉ញ់ បក់ ប៉្រគ័ យច «ញ៉ា ត្រគ់ តាប៉ុញ ពីត អុះ ម៉ី ទៅ នីអៀ ?» ");
INSERT INTO tpu_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ប៉ាណូស ណោះ តើល ផា «ពឿ ប៉្រើ អីស ប៉្រគ័ ម៉ៃគ ញឹន លូ អន់ អីស ឡាំ តាត់ស៊ិន សារ កា ញឹន ? នីចម័ អីស ឃឹត ចឹង ប៉ាន់តោ័ អាញ់ ឡាក់ កា អីស ប៉ាន់តោ័ សុនសាត អ៊ីស៊ីប ពែ ប ?» ម៉ូសេ កាខរ់ ណូស អ្យូគ ខាក់ លូ ឃឹត ផា «សារ អា ចាបះ កា ពូ អ្លុ ទិ កេះ តាម ហៃ»។ ");
INSERT INTO tpu_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","សារ អា កា អ្លុ ទឹល ប៉ាគ់ សាដាច់ អ៊ីស៊ីប ដេល ទឹល នីណោ័ះ អ៊ែ ឃឹត ណាំង ទ្រង ចឹង ប៉ាន់តោ័ អ្លាត ម៉ូសេ ហះកា ម៉ូសេ អ្លុ អន់តគ់ អ៊ែ កា សាតាក់ ឡាច់ ឡឹង ចារ សាដាច់ ណោះ។ អ៊ែ ឡាំ អ្វៃ ប៉ាគ់ ប៉ាថេត ម៉ាឌៀន។ អ៊ែ អង់អ្វៃ ហះ សានែង ទៀក អន់ដូង័។ ");
INSERT INTO tpu_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","កាណុង ប៉ាថេត ម៉ាឌៀន ណោះ ទី ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ម៉ោញ ដូវ អ៊ែ ទី គន អង់កាន់ តាំប៉ើះ ដូវ។ គន អង់កាន់ អ៊ែ ណោះ ប៉ាណាំ គួប ឡាំ អោះ ទៀក តូះ ពឹង រ៉ាពួង អន់ កា តាប៉ល់ ចៀម ពឹ អន់ឌែ អៃត ");
INSERT INTO tpu_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ហះកា ទី មួត រង ចៀម ពូ អន់ទៀគ ណាវ្គ ទ្រុះ ឡាច់ អន់ឌែ អូ អន់ អោះ ទៀក អុះ ម៉ូសេ អ្យូវ ឡាំ តង័ មួត អង់កាន់ លូ អោះ ទៀក អន់ កា ចៀម អន់ឌែ អៃត។ ");
INSERT INTO tpu_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","កេះណោះ មួត អង់កាន់ ណោះ សឹត ប៉ាគ់ ហី។ វគ័ យេត្រូ ពឹ អន់ឌែ អំប៉ញ់ ផា «ញ៉ា ត្រគ់ អន់ដីស សឹត ស៊្រស ដារ់ អា ?» ");
INSERT INTO tpu_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","អន់ឌែ តើល ផា «ខង ទី កាម៉ាក័ សុនសាត អ៊ីស៊ីប ម៉ោញ ដូវ អ៊ែ តង័ ញឹន អន់ រ៉ាវ៉ាច់ ឡឹង មួត រង ចៀម ពូ អន់ទៀគ ទឹប អ៊ែ អោះ ទៀក អន់ កា ចៀម ពិន អៃត ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","ពឹ អន់ឌែ អំប៉ញ់ ផា «កាម៉ាក័ ណោះ អ្វៃ ប៉ាគ់ ចំ ? ញ៉ា ត្រគ់ អន់ដីស អ្លាត អ៊ែ នីណោ័ះ ? ហគ់ អន់ដីស ឡាំ ជៀក អ៊ែ ឡាំ សា សាណា លូ ពិន ប៉ាគ់ អា រិញ»។ ");
INSERT INTO tpu_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","ម៉ូសេ កា អ្វៃ អន់ឌូ លូ វគ័ យេត្រូ ណោះ ហង ឡៃង ឡឹង ណោះ អ៊ែ អន់ ម៉ូសេ ទី គន អង់កាន់ អ៊ែ សិច ស៊ិប៉ុរ៉ា។ ");
INSERT INTO tpu_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ឡៃង ឡឹង ណោះ កាម៉ាញ់ ម៉ូសេ គៀម អ្វៃ ហាអុញ កើត គន កាម៉ាក័ ម៉ោញ អ៊ែ អន់ សិច ផា គើសម ទឹប កាប ផា «អាញ់ ឡាក់ ប៉ាណូស អំហ៊្មយ អ្វៃ ពឹង ស្រុក ពូ អង់រ៉ាម័»។ ");
INSERT INTO tpu_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ប៉ាគ់ ទុញ សាណាំ ឡឹង ណោះ សាដាច់ អ៊ីស៊ីប កា តោ័ ហង។ គន សោ អ៊ីស្រាអ៊ែល ឡាក់ កេះ ទុច អ៊ីស៊ីប អ្វៃ ថុក ញ៉ាក លូ តាំងអឹះ កាខាក់។ អន់ឌែ កា ប៉ាណាំ គួប ម៉ន់ ឡោម ឡា ប‌៉្រ័ះ ប៊កកាតយ័។ សារ អន់ឌែ ម៉ន់ កា ថុក ញ៉ាក ណោះ កាតាំង ទឹល ប៉ាគ់ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ប‌៉្រ័ះ ប៊កកាតយ័ កាតាំង អន់ឌែ តាំងអឹះ អ៊ែ កា កាចាំង កា សារ អ៊ែ សាញ៉ា រែវ ពុត លូ វគ័ អាប៉្រាហាំ លូ អ៊ីសាក់ លូ យ៉ាកុប ។ ");
INSERT INTO tpu_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","អ៊ែ ប៉ប័ គន សោ អ៊ីស្រាអ៊ែល ទី សារ ឡាំបាក អ៊ែ កា រ៉ាំបីស កា អន់ឌែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","ផះ វគ័ ម៉ូសេ អ្វៃ រង ចៀម ពឹ អន់ហ្នី អ៊ែ វគ័ យេត្រូ ឡាក់ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ កាណុង ប៉ាថេត ម៉ាឌៀន អ៊ែ គៀរ ចៀម ណោះ ឡាំ គែង ដារ់ ម៉ុត ស៊្រែ តីស  អ៊ែ ចាក លើយ ទឹល ប៉ានឹម ស៊ីណាយ ឃឺ ប៉ានឹម ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ហះ ចារ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ តាំបាង ឡាកោ កាណុង ប៉ោម អន់ វគ័ ម៉ូសេ ប៉ប័ ឡាក់ កា អំប៉្យិត អុញ។ អ៊ែ ប៉ប័ អំប៉្យិត អុញ កីត កាណុង ប៉ោម ហះកា ប៉ោម ណោះ អុញ អូ សា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","វគ័ ម៉ូសេ ឃឹត កាណុង ពុត ផា «អាញ់ ចឹង ម៉ុត ហៃៗ អុញ នីចម័ ណោះ ? ខ ញ៉ា បះ ប៉ោម ណោះ អុញ អូ សា ?» ");
INSERT INTO tpu_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ប័ វគ័ ម៉ូសេ ម៉ុត ក្យាម័ នីណោ័ះ អ៊ែ អើ ម៉ូសេ ឡឹង ប៉ោម ណោះ ផា «អឺ ម៉ូសេ ! ម៉ូសេ !» ម៉ូសេ តើល «ញ៉ា ?» ");
INSERT INTO tpu_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ ផា «អីស ជែ ម៉ុត ក្យាម័ ចារ អា ! អីស តាឡេះ ឡាច់ កឺប អីស ណោះ ពិ ខង ចារ អីស តាវ ណោះ ឃឺ ចារ ប‌៉្រ័ះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ប‌៉្រ័ះ រ៉ះ ណាវ្គ ផា «អាញ់ ប‌៉្រ័ះ ឡាក់ ពឹ អីស ឃើយ អ្យិល កូត័ លូ ប‌៉្រ័ះ អាប៉្រាហាំ អ៊ីសាក់ លូ យ៉ាកុប»។ វគ័ ម៉ូសេ ប៉ឹត ម៉ាត់ ខង អ៊ែ អូ ខឹន ហៃ ប‌៉្រ័ះ ប៊កកាតយ័ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ណាវ្គ ផា «អាញ់ ប៉ប័ ប៉ាសុន អាញ់ អ្វៃ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប តោ ទី សារ ឡាំបាក ខាក់ លូ អាញ់ កាតាំង អន់ឌែ តាំងអឹះ ញន កា មួត អ៊ីស៊ីប ប៉្រគ័ បាប អន់ឌែ យ៉ឹប។ អាញ់ រ៉ាំបីស ដេល កា អន់ឌែ ទី សារ ឡាំបាក ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ទឹល នីណោ័ះ អាញ់ ជឹរ ភឿ ឡាំ តង័ អន់ឌែ អន់ រ៉ាវ៉ាច់ ឡឹង តី មួត សុនសាត អ៊ីស៊ីប។ អាញ់ ចឹង ប៉ាណាំ អន់ឌែ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ណោះ ឡាំ អ្វៃ ប៉ាគ់ ប៉ាថេត តីស លូ ដាគ់ សាណា ខាក់ ទី ទៀក សុត លូ ទៀក តុះ រ៉ក់ អៀង ឃឺ ប៉ាគ់ ប៉ាថេត មួត សុនសាត កាណាន សុនសាត ហេត សុនសាត អាម៉ូរី សុនសាត ពែរិស៊ីត សុនសាត ហេវី លូ សុនសាត យេប៊ូស។ ");
INSERT INTO tpu_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","កិញអៀ អា អន់ឌែ តាំងអឹះ ណោះ អាញ់ កាតាំង កេះ។ អាញ់ ប៉ប័ ដេល សុនសាត អ៊ីស៊ីប ប៉្រគ័ បាប ជិះ ចគ័ អន់ឌែ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","កិញអៀ អា អាញ់ ប៉្រើ អីស ឡាំ កាប កា សាដាច់ អ៊ីស៊ីប។ ហគ់ អីស ឡាំ ប៉ាណាំ ប៉ាសុន អាញ់ អ៊ីស្រាអ៊ែល អន់ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ណោះ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ហះកា វគ័ ម៉ូសេ តើល ប‌៉្រ័ះ ប៊កកាតយ័ ផា «ហៃ អាញ់ ប៉ាសុន ដោច ដាច នីចម័ អាញ់ ចឹង អ្លុ ឡាំ កាប កា សាដាច់ អ៊ីស៊ីប លូ ប៉ាណាំ ប៉ាសុន អ៊ីស្រាអ៊ែល អន់ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ណោះ ?» ");
INSERT INTO tpu_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ផា «អាញ់ ចឹង អ្វៃ អន់ឌូ លូ អីស។ អីស ចឹង អ្លុ អន់តគ់ ផា អាញ់ ប៉្រើ អីស តាទឹច នីអៀ ដារ់ ចំ អីស ប៉ាណាំ សុនសាត អ៊ីស្រាអ៊ែល ឡាច់ រ៉ាវ៉ាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប កេះ អន់ដីស ចឹង ឡាំ សាំប‌៉័ះ ប៉ានេ អាញ់ ហះ ប៉ានឹម អា»។ ");
INSERT INTO tpu_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","ហះកា វគ័ ម៉ូសេ តើល ប‌៉្រ័ះ ប៊កកាតយ័ ផា «ផានែវ អាញ់ ឡាំ រ៉ះ កា សុនសាត អ៊ីស្រាអ៊ែល ផា \"ប‌៉្រ័ះ វគ័ យ៉ាគ់ អន់ដីស អ៊ែ ប៉្រើ អាញ់ ឡាំ រ៉ះ កា អន់ដីស\" ផា អន់ឌែ អំប៉ញ់ អាញ់ ផា \"ញ៉ា សិច ប‌៉្រ័ះ ណោះ ?\" អាញ់ ចឹង ត្រគ់ រ៉ះ កា អន់ឌែ នីចម័ ?» ");
INSERT INTO tpu_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «អាញ់ អ្វៃ រ៉ីស លើយ។ អីស ត្រគ់ រ៉ះ កា អន់ឌែ ផា \"ប‌៉្រ័ះ ឡាក់ អ្វៃ រ៉ីស លើយ ប៉្រើ អាញ់ ឡាំ ប៉ាគ់ អា\"»។ ");
INSERT INTO tpu_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ប៉ាឡាក់ កា វគ័ ម៉ូសេ ណាវ្គ ផា «អីស ត្រគ់ រ៉ះ កា អន់ឌែ នីអៀ \"ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ វគ័ អន់ដីស អាប៉្រាហាំ អ៊ីសាក់ យ៉ាកុប អ៊ែ ប៉្រើ អាញ់ ឡាំ រ៉ះ កា អន់ដីស\"។ អា ហង សិច អាញ់ ភឿ អន់ ប៉ាណូស គ្រឹប រ៉ាំងហាវ កាចាំង កា អាញ់ លើយ។ ");
INSERT INTO tpu_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","ហគ់ អីស ឡាំ អើ ប៉ាតុំ មួត ក្រាគ់ៗ កាណុង សុនសាត អ៊ីស្រាអ៊ែល កេះណោះ រ៉ះ ផា \"ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ វគ័ អន់ដីស អាប៉្រាហាំ អ៊ីសាក់ យ៉ាកុប អ៊ែ តាំបាង ឡាកោ អន់ អាញ់ ប៉ប័។ អ៊ែ រ៉ះ ផា អ៊ែ រ៉ាំបីស កា អន់ដីស ញន សុនសាត អ៊ីស៊ីប ប៉្រគ័ បាប អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","អ៊ែ ចឹង ប៉ាណាំ អន់ដីស ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប អា ឡាក់ ចារ ថុក ញ៉ាក ប៉ាកម៉ង កេះណោះ ប៉ាណាំ អន់ដីស ឡាំ អ្វៃ ប៉ាគ់ ប៉ាថេត សុនសាត កាណាន សុនសាត ហេត សុនសាត អាម៉ូរី សុនសាត ពែរិស៊ីត សុនសាត ហេវី លូ សុនសាត យេប៊ូស ឡាក់ ប៉ាថេត ទី សាណា អៀង ខាក់\"។ ");
INSERT INTO tpu_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","អន់ឌែ ចឹង សាំយ៉ាំង ប៉ានឹរ អីស កេះណោះ អីស លូ មួត ក្រាគ់ តាំងកង់ សុនសាត អ៊ីស្រាអ៊ែល ត្រគ់ ឡាំ រ៉ះ កា សាដាច់ អ៊ីស៊ីប ផា \"ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ សុនសាត ហេព្រឺ ញឹន ឃើយ អ្យិល កូត័ អ៊ែ ឡាំ រ៉ះ កា ញឹន។ កិញអៀ អា ញឹន ប៉រ់ ឡាំ ប៉ាគ់ ស៊្រែ តីស ចាំងហាយ្គ ខា ប៉ៃង ដារ់ ចាក ភឿ ចឹង ពុះ កាណាគ័ រ៉ាម៉ះ អ៊ែ\"។ ");
INSERT INTO tpu_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","ហះកា អាញ់ អ្លុ អន់តគ់ ផា សាដាច់ អ៊ីស៊ីប អ៊ែ អូ អន់ អន់ដីស ឡាច់ អុះ ទី ដឹង អាញ់ ចឹង ប៉ាំងខំ អ៊ែ លូ អំរ៉ាញ អឺញ អាញ់ ណោះ អ៊ែ ចឹង អន់ អន់ដីស ឡាច់។ ");
INSERT INTO tpu_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ទឹល នីណោ័ះ អាញ់ ចឹង តាំបាង សារ អំរ៉ាញ អឺញ គ្រឹប នែវ ពីត ប៉ាថេត អ៊ីស៊ីប កេះណោះ សាដាច់ អ៊ីស៊ីប ចឹង អន់ អន់ដីស ឡាច់ ឡឹង ប៉ាថេត អ៊ែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","អាញ់ ចឹង ប៉្រគ័ អន់ សុនសាត អ៊ីស៊ីប អ្យូគ កា អន់ដីស។ ប៉ាគ់ អន់ដីស ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ណោះ ទៀ អន់ដីស អូ ឡាច់ តី តាដោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","មួត អង់កាន់ អ៊ីស្រាអ៊ែល ចឹង ប៉រ់ រ៉ាស អំប៉ាស ម៉ាស ប៉្រាក់ លូ ខោ អាវ ឡឹង មួត អង់កាន់ អ៊ីស៊ីប ឡាក់ អ្វៃ រសានែង។ អន់ឌែ ចឹង អន់ កាណាគ័ ទិណោ័ះ កា អន់ដីស កេះណោះ ត្រគ់ អន់ គន សោ អន់ដីស ទ្រុង កាណាគ័ ទិណោ័ះ។ សារ អា វ៉ឹច លូ អន់ដីស រ៉ាត អ្យក់ គ្រឹប កាណាគ័ ម៉ះ អន់ឌែ»។ ");
INSERT INTO tpu_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","វគ័ ម៉ូសេ តើល ផា «ឃឺ អ៊ែ សុនសាត អ៊ីស្រាអ៊ែល អូ សឿ លូ អូ ចៃ សាំយ៉ាំង អាញ់ អុះ តាម ហៃ។ អន់ឌែ ចឹង តើល ផា \"ប‌៉្រ័ះ ប៊កកាតយ័ អូ ទី តាំបាង អន់ អីស ប៉ប័ អ៊ែ អុះ\"»។ ");
INSERT INTO tpu_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","ប‌៉្រ័ះ ប៊កកាតយ័ អំប៉ញ់ វគ័ ម៉ូសេ ផា «ញ៉ា អីស ចឹក ពឹង តី អីស ណោះ ?» អ៊ែ តើល ផា «អាញ់ ចឹក អ៊្លង កាទូង»។ ");
INSERT INTO tpu_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","ប‌៉្រ័ះ ប៊កកាតយ័ ផា «អីស វ៉ឹត ហៃ ពឹង តេះ ណោះ»។ វគ័ ម៉ូសេ កា វ៉ឹត អ្លាត អ៊្លង កាទូង ពឹង តេះ តាទឹច។ ផាឌី អ៊្លង កាទូង ណោះ កា កេះ ពិះ វគ័ ម៉ូសេ ប៉្លង់ ឡាច់ ឡឹង ចារ ពិះ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ ផា «អីស រ៉ុប ក្យាំង អ៊ែ ណោះ រិញ»។ វគ័ ម៉ូសេ កា រ៉ុប ក្យាំង អ៊ែ តាទឹច ពិះ ណោះ កា កេះ អ៊្លង កាទូង ទៅ។ ");
INSERT INTO tpu_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","ប‌៉្រ័ះ រ៉ះ កា អ៊ែ ណាវ្គ ផា «ប៉្រគ័ នីអៀ ម៉ាគ់ គន សោ អ៊ីស្រាអ៊ែល ចឹង សឿ ផា អាញ់ ឡាក់ ប‌៉្រ័ះ វគ័ អន់ឌែ អាប៉្រាហាំ អ៊ីសាក់ លូ យ៉ាកុប តាំបាង ឡាកោ អន់ អីស ប៉ប័ តាទឹច»។ ");
INSERT INTO tpu_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ណាវ្គ ផា «ហគ់ អីស តាម៉ុត តី កាណុង អាវ ពឹង អន់តើះ»។ វគ័ ម៉ូសេ កា តាម៉ុត តាទឹច ប៉ាគ់ អ៊ែ អ្យក់ ឡាច់ តី ឡឹង អន់តើះ ប៉ប័ តី អ៊ែ ត្រគ់ រ៉ោះ បាក វ៉ឹច លូ កាប៉ាស។ ");
INSERT INTO tpu_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ណាវ្គ ផា «ហគ់ អីស តាម៉ុត តី ពឹង អាវ អីស ម៉ោញ ទង ណាវ្គ»។ វគ័ ម៉ូសេ កា តាម៉ុត ណាវ្គ ប៉ាគ់ អ៊ែ អ្យក់ ឡាច់ តី ផាឌី ដាគ់ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ផា «ផា អន់ឌែ អូ សឿ សារ អ៊្លង កាទូង អា អន់ឌែ សឿ សារ ចឹង តាំបាង បក់ អន់តីគ អា។ ");
INSERT INTO tpu_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ផា អន់ឌែ អូ សឿ សារ អីស តាំបាង ទិ ពៀរ អា លូ អូ សាំយ៉ាំង សារ អីស រ៉ះ អីស ឡាំ វ៉ាល់ អ្យក់ ទៀក តាំងលេ នីល កេះណោះ តូះ ពឹង តេះ គោក ទៀក អីស តូះ ណោះ ចឹង កេះ ផាម»។ ");
INSERT INTO tpu_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","វគ័ ម៉ូសេ តើល ប‌៉្រ័ះ ប៊កកាតយ័ ផា «អឺ ប‌៉្រ័ះ តាំងឡា អាញ់ ឡឹង សើគ ឡឹង ពែ ទឹល ដារ់ អីស កាកាប លូ អាញ់ អា អាញ់ ឡាក់ ប៉ាណូស អូ សូវ ទី ប៉ានឹរ ពឹរ កាង អុះ ខង អាញ់ ប៉ាណូស កាង័ ពឹរ កាង័ កាង។ ទឹល កិញអៀ អា កា អ្វៃ និះទៅ ណោះ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","ប‌៉្រ័ះ ប៊កកាតយ័ អំប៉ញ់ វគ័ ម៉ូសេ ផា «ពឿ ប៉ាំងកើត ពឹរ ប៉ាណូស ? ពឿ ប៉្រគ័ អន់ កា ប៉ាណូស កាំឡូ លើ ក្លឹក លើ តាតារ ម៉ាត់ លើ ម៉ាម៉ាំង ម៉ាត់ ? ញ៉ា អូ ត្រគ់ អាញ់ ប ? ");
INSERT INTO tpu_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ហគ់ ចាក ឡាំ ពិ ប៉ាគ់ អីស កាកាប លូ ពូ ទៀ អាញ់ ចឹង តង័ អីស កាប លូ អាញ់ ចឹង រ៉ះ កា អីស ឡឹង សារ ត្រគ់ កាប»។ ");
INSERT INTO tpu_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","ហះកា វគ័ ម៉ូសេ តើល ផា «អឺ ប‌៉្រ័ះ តាំងឡា អីស ប៉្រើ ពូ អន់ទៀគ ឡាំ ណោះ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","ផះ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ អឺក កា វគ័ ម៉ូសេ ខាក់ លូ កាប ផា «អីស ទី ម៉ី កាម៉ាក័ ម៉ោញ ដូវ សិច អារ៉ុន ឡាក់ មួត លេវី។ អាញ់ អ្លុ អន់តគ់ ផា អ៊ែ ឃឺ ប៉ាណូស ទី ប៉ានឹរ ពឹរ កាង ខាក់ អ៊ែ ផះ ចាក ឡាំ ណាំង អីស កេះ។ ប៉ាគ់ អ៊ែ ប៉ប័ អីស ទៀ អ៊ែ ចឹង ហោក ខាក់ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","អីស រ៉ះ អន់ អ៊ែ កាប ប៉ាតាង អីស សារ ញ៉ា ឡាក់ អីស ចឹង កាប ណោះ។ អាញ់ ចឹង តង័ អន់ដីស កាប ដេល លូ ចឹង រ៉ះ សារ ញ៉ា ឡាក់ អន់ដីស ត្រគ់ ប៉្រគ័ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","អ៊ែ ចឹង កាកាប លូ ពូ ប៉ាតាង អីស អ៊ែ ឡាក់ ប៉ាណូស ចឹង អ្យក់ សារ ឡឹង អីស រ៉ះ កា ពូ អីស វ៉ឹច លូ ប‌៉្រ័ះ រ៉ះ កា អ៊ែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ហគ់ ចឹក ឡាំ អ៊្លង កាទូង អា ពិ ភឿ សាំរ៉ាប់ តាំបាង សារ អំរ៉ាញ អឺញ កេង ខាក់»។ ");
INSERT INTO tpu_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","វគ័ ម៉ូសេ កា សឹត ប៉ាគ់ ពឹ អន់ហ្នី អ៊ែ លូ រ៉ះ ផា «អាញ់ ប៉រ់ សឹត ប៉ាគ់ អុះ ម៉ី អាញ់ អ្វៃ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប តោ ណាវ្គ ភឿ ប៉ិច អ្លុ អន់តគ់ ផា អន់ឌែ អ្វៃ រ៉ីស ដេល ប»។ វគ័ យេត្រូ រ៉ះ កា ម៉ូសេ ផា «សឹត ពិ គន ចាក ដាគ់ ចាក ប៉ាឡឹង»។ ");
INSERT INTO tpu_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","ផះ វគ័ ម៉ូសេ អ្វៃ ពឹង ប៉ាថេត ម៉ាឌៀន ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ ផា «អ្យគ័ អីស សឹត ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប តោ ណាវ្គ ពិ ខង មួត បក់ ប៉ិច ប៉ាន់តោ័ អីស ពែ តោ័ ទិ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","វគ័ ម៉ូសេ អន់ គន កាម៉ាញ់ អ៊ែ ជិះ លៀ អន់ឌែ សឹត ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ណាវ្គ។ អ៊ែ កា ចឹក សឹត ទឹប អ៊្លង កាទូង ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ អំរ៉ាញ អឺញ កា អ៊ែ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ប៉ាគ់ អីស សឹត ទឹល ប៉ាថេត អ៊ីស៊ីប កេះ អីស ត្រគ់ តាំបាង សារ អំរ៉ាញ អឺញ កេង ខាក់ ឡាក់ អាញ់ អន់ កា អីស អា អន់ កា សាដាច់ អ៊ីស៊ីប ប៉ប័។ ហះកា អាញ់ ចឹង ប៉្រគ័ អន់ សាដាច់ អ៊ីស៊ីប កាង័ កល់ កាខាក់។ អ៊ែ ចឹង អូ អន់ ប៉ាសុន អ៊ីស្រាអ៊ែល ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","អីស ត្រគ់ រ៉ះ កា សាដាច់ អ៊ីស៊ីប ផា នីអៀ \"ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ផា ប៉ាសុន អ៊ីស្រាអ៊ែល ឡាក់ កា គន ឡោងទ្រៀ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","អ៊ែ ប៉្រើ អីស អន់ គន អ៊ែ ចាក ឡាច់ ភឿ អន់ អន់ឌែ សាំប‌៉័ះ ប៉ានេ អ៊ែ។ ហះកា អីស អូ អន់ អន់ឌែ ឡាច់ ទឹល នីណោ័ះ អ៊ែ ចឹង ប៉ាន់តោ័ គន ឡោងទ្រៀ អីស\"»។ ");
INSERT INTO tpu_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ផះ អន់ឌែ រ៉ាឡូវ ដំ ប៉ាគ់ ចារ ម៉ោញ ប‌៉្រ័ះ ប៊កកាតយ័ ម៉ុត ក្យាម័ វគ័ ម៉ូសេ ភឿ ចឹង ប៉ាន់តោ័ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","កេះណោះ ស៊ិប៉ុរ៉ា អ្យក់ សាំង ពូ ប៉្រគ័ លូ អំហ្មោ កាសិត អង់ការ កា គន អ៊ែ ប៉ឹត ពឹង ជុង អ៊ែ។ អ៊ែ កាប ផា «ញន កា ផាម អា អីស ក្លោ អាញ់ តាទឹច ហង»។ អ៊ែ កាប នីអៀ ញន កា អ៊ែ កាសិត អង់ការ កា គន អ៊ែ។ កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាច់ ឡឹង ចារ វគ័ ម៉ូសេ អ៊ែ អូ ជៀ ប៉ាន់តោ័ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ អារ៉ុន ផា «ហគ់ អីស ឡាំ តាកាន ម៉ូសេ ប៉ាគ់ ស៊្រែ តីស តោ»។ អ៊ែ កា ឡាំ តាកាន វគ័ ម៉ូសេ តាទឹច ផាឌី ប៉ាត័ះ គួប ហះ ប៉ានឹម ប‌៉្រ័ះ ប៊កកាតយ័។ អន់ឌែ កា គ្វែត ចុំ គួប សោប។ ");
INSERT INTO tpu_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","វគ័ ម៉ូសេ រ៉ះ កា វគ័ អារ៉ុន គ្រឹប សារ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អ៊ែ ឡាំ រ៉ះ កា ពូ លូ រ៉ះ ឡឹង សារ អំរ៉ាញ អឺញ ឡាក់ ប‌៉្រ័ះ ប៉្រើ អ៊ែ ប៉្រគ័ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","កេះណោះ វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ឡាំ អើ ប៉ាតុំ មួត ក្រាគ់ តាំងកង់ សុនសាត អ៊ីស្រាអ៊ែល ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","វគ័ អារ៉ុន រ៉ះ ទិ សារ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ណោះ ហង ទឹប អ៊ែ តាំបាង សារ អំរ៉ាញ អឺញ អន់ កា មួត ប៉ាសុន ប៉ប័ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","សុនសាត អ៊ីស្រាអ៊ែល កា សឿ សារ ណោះ។ ផះ អន់ឌែ កាតាំង ផា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ាំបីស កា អន់ឌែ ទី សារ ឡាំបាក ណោះ អន់ឌែ ប៉ាណាំ គួប កុប កល់ សាំប‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","កេះណោះ វគ័ អារ៉ុន លូ វគ័ ម៉ូសេ ឡាំ រ៉ះ កា សាដាច់ អ៊ីស៊ីប ផា «ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល អ៊ែ រ៉ះ ផា នីអៀ \"អីស ត្រគ់ អន់ ប៉ាសុន អាញ់ ឡាំ អៃត សា រ៉ាម៉ះ អាញ់ ប៉ាគ់ ស៊្រែ តីស \"»។ ");
INSERT INTO tpu_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","សាដាច់ អ៊ីស៊ីប តើល ផា «ពឿ ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ បះ អាញ់ ចឹង ត្រគ់ ប៉្រគ័ ពួយ អ៊ែ លូ ចឹង អន់ អ៊ីស្រាអ៊ែល ចាក ឡាច់ ? អាញ់ អូ អន់ហ្នាល់ អ៊ែ អុះ អាញ់ កា អូ អន់ អ៊ីស្រាអ៊ែល ចាក ឡាច់ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","អន់ឌែ តើល សាដាច់ អ៊ីស៊ីប ផា «ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត ហេព្រឺ ឡាំ រ៉ះ កា ញឹន។ កិញអៀ អា ប៉រ់ អីស អន់ ញឹន ឡាំ ប៉ាគ់ ស៊្រែ តីស ចាំងហាយ្គ ខា ប៉ៃង ដារ់ ចាក ភឿ ឡាំ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ញឹន។ ផា ញឹន អូ ឡាំ អ៊ែ ចឹង ប៉ាន់តោ័ ញឹន លូ សារ អីគ ព្លុ លើ កា ប៉ាន់តោ័ លូ ដាវ»។ ");
INSERT INTO tpu_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","សាដាច់ អ៊ីស៊ីប កាប កា អន់ឌែ ផា «អឺ ម៉ូសេ លូ អារ៉ុន ញ៉ា ត្រគ់ អន់ដីស ប៉ាណាំ ប៉ាសុន អ៊ីស្រាអ៊ែល អូ អន់ ប៉្រគ័ ង៉ារ នីអៀ ? ហគ់ ប៉ាណាំ គួប សឹត ប៉្រគ័ ង៉ារ ណាវ្គ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","សាដាច់ កាប ណាវ្គ ផា «កិញអៀ អា ប៉ាសុន អ៊ីស្រាអ៊ែល អ្វៃ ពឹង ប៉ាថេត អ៊ីស៊ីប ទី អៀង ខាក់ ហះកា អន់ដីស ពៀរ ដូវ ប៉ិច អន់ អន់ឌែ អ្លាត ប៉្រគ័ ង៉ារ នីអៀ»។ ");
INSERT INTO tpu_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ដារ់ ណោះ ទៅ ហង សាដាច់ រ៉ះ លូ ម៉ៃគ រ៉ាំងហៃ ប៉ាសុន លូ កល់ ក្រុំ ផា ");
INSERT INTO tpu_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«ជែ អន់ ហង ឡានង ពៀ កា អន់ឌែ ប៉្រគ័ អិត ឡាក់ កា អន់ទ្រួល ពែ ត្រគ់ អន់ អន់ឌែ ចាក ណាំង ឡានង ពៀ អន់ឌែ ទៅ ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ហះកា ត្រគ់ ប៉ាំងខំ អន់ឌែ ប៉្រគ័ អិត អន់ គ្រឹប ចំលួន ឡាក់ កា អន់ទ្រួល ពែ ទៅ ហង ជែ ប៉ាំងគ្លឹះ ចំលួន ខង អន់ឌែ ប៉ាណូស កាជីល ខ អា ហង បះ អន់ឌែ ប៉រ់ ឡាច់ ឡាំ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ត្រគ់ អន់ ង៉ារ កា អន់ឌែ ប៉្រគ័ ក្លេ័ះ ក្លាំង ក្វា ឡឹង អន់ទ្រួល ពែ ណាវ្គ ភឿ ជែ អន់ អន់ឌែ ទី រ៉ាឡូវ ម៉ាគ់ ដាគ់ អន់ឌែ អូ ឃឹត ឡឹង សារ ព្លូង អា»។ ");
INSERT INTO tpu_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","ម៉ៃគ រ៉ាំងហៃ ប៉ាសុន លូ កល់ ក្រុំ ឡាំ រ៉ះ កា ប៉ាសុន ផា «កិញអៀ អា សាដាច់ រ៉ះ ផា អូ អន់ ហង ឡានង ពៀ កា អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","អន់ដីស ត្រគ់ ចាក ណាំង ឡានង ពៀ អន់ដីស ទៅ ឡគ ប៉ាគ់ ចារ ចំ ឡាក់ ទី ឡានង ពៀ ហះកា អិត អន់ គ្រឹប ចំលួន ឡាក់ កា អន់ទ្រួល ពែ ទៅ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","ទឹល នីណោ័ះ ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ ឡាច់ ចាក ណាំង ប៉ាតុំ ឡានង ពៀ គ្រឹប ចារ កាណុង ប៉ាថេត អ៊ីស៊ីប ភឿ អ្យក់ ប៉្រគ័ អិត។ ");
INSERT INTO tpu_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","មួត រ៉ាំងហៃ ប៉ាសុន កាប ប៉ាំងខំ ផា «ង៉ារ ឡាក់ អន់ដីស ត្រគ់ ប៉្រគ័ កាណុង ម៉ោញ ដារ់ អន់ដីស ត្រគ់ ប៉្រគ័ អន់ គ្រឹប ចំលួន ឡាក់ កា ផះ រ៉ាំងវ៉ាង ទី ឡានង ពៀ ពែ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","មួត រ៉ាំងហៃ ប៉ាសុន ណោះ អន់ឌែ ពីត កល់ ក្រុំ មួត អ៊ីស្រាអ៊ែល ឡាក់ អន់ឌែ ប៉្រើ រ៉ាំងហៃ ពូ ប៉្រគ័ ង៉ារ លូ កាប ផា «ញ៉ា ត្រគ់ រ៉ាំងវ៉ាង ពៀរ ប៉ៃង ដារ់ អា អន់ដីស ប៉្រគ័ អិត អូ គ្រឹប ចំលួន ឡាក់ កា ផះ អន់ទ្រួល ពែ ?»។ ");
INSERT INTO tpu_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ឡៃង ឡឹង ណោះ មួត កល់ ក្រុំ សុនសាត អ៊ីស្រាអ៊ែល ប៉ាណាំ គួប ឡាំ ប៉ាគែក លូ សាដាច់ អ៊ីស៊ីប ផា «ញ៉ា ត្រគ់ អីស ប៉្រគ័ កា ញឹន នីអៀ ? ");
INSERT INTO tpu_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ពូ អូ ទី អន់ ឡានង ពៀ កា ញឹន អុះ ហះកា ពូ ប៉្រើ ញឹន ប៉្រគ័ អិត អន់ គ្រឹប ចំលួន ទឹប ពីត ញឹន ដេល។ ប៉ាសុន អីស ប៉្រគ័ នីអៀ យច កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","សាដាច់ អ៊ីស៊ីប តើល ផា «អន់ដីស ទិឌូ អា ស៊ុត កា ប៉ាណូស កាជីល កាជីល តាទឹច អន់ដីស អា។ ខ អា ហង បះ អន់ដីស ប៉រ់ ឡាច់ ឡាំ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","កិញអៀ អន់ដីស ប៉ាណាំ គួប សឹត ប៉្រគ័ ង៉ារ ណាវ្គ ពិ។ អាញ់ អូ អន់ ឡានង ពៀ កា អន់ដីស អុះ ហះកា អន់ដីស ត្រគ់ ប៉្រគ័ អិត អន់ គ្រឹប ចំលួន ឡាក់ កា អន់ទ្រួល ពែ ទៅ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ផះ មួត កល់ ក្រុំ អ៊ីស្រាអ៊ែល កាតាំង សាដាច់ រ៉ះ នីណោ័ះ អន់ឌែ អ្លុ អន់តគ់ ផា អន់ឌែ ទី សារ ឡាំបាក ខាក់ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ប៉ាគ់ អន់ឌែ ឡាច់ ឡឹង ចារ សាដាច់ កេះ អន់ឌែ ប៉ាត័ះ វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ឡាក់ ផះ អ្វៃ ក្យាគ់ អន់ឌែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","អន់ឌែ កាប កា វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ផា «អន់ ប‌៉្រ័ះ ប៊កកាតយ័ ចៃគ ថូត អន់ដីស ពៀរ ដូវ អា ពិ ខង អន់ដីស ប៉្រគ័ អន់ កា សាដាច់ អ៊ីស៊ីប លូ មួត រ៉ាតីស ទិណោ័ះ អូ ណីស កា ញឹន។ អន់ដីស អា ហង អន់ ដាវ កា អន់ឌែ ប៉ាន់តោ័ ញឹន»។ ");
INSERT INTO tpu_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","វគ័ ម៉ូសេ វ៉ីល សឹត ឡាំ ម៉ន់ អើ ប‌៉្រ័ះ ប៊កកាតយ័ ណាវ្គ ផា «អឺ ប‌៉្រ័ះ ឡាក់ តាំងឡា ញ៉ា ត្រគ់ អីស ប៉្រគ័ បាប ប៉ាសុន នីអៀ ? អីស ប៉្រើ អាញ់ ឡាំ ប៉្រគ័ ញ៉ា ? ");
INSERT INTO tpu_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ឡឹង អីស ប៉្រើ អាញ់ ឡាំ រ៉ះ កា សាដាច់ អ៊ីស៊ីប ពួយ ប៉ានឹរ អីស ពែ អ៊ែ ប៉្រគ័ បាប ប៉ាសុន អីស កាខាក់ ហះកា អីស អូ ទី តង័ ញឹន អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «កិញអៀ អា អីស ចឹង ប៉ប័ សារ អាញ់ ចឹង ប៉្រគ័ កា សាដាច់ អ៊ីស៊ីប។ ញន កា សារ អំរ៉ាញ អឺញ អាញ់ អ៊ែ ចឹង អន់ អ៊ីស្រាអ៊ែល ចាក ឡាច់ ទឹប អ៊ែ ចឹង ទ្រុះ ឡាច់ អន់ដីស ឡឹង ប៉ាថេត អ៊ីស៊ីប អា»។ ");
INSERT INTO tpu_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","កេះណោះ អ៊ែ រ៉ះ កា វគ័ ម៉ូសេ ណាវ្គ ផា «អាញ់ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","អាញ់ តាំបាង ឡាកោ អន់ កា អាប៉្រាហាំ អ៊ីសាក់ លូ យ៉ាកុប ប៉ប័ ពែ អន់ឌែ អើ សិច អាញ់ ផា ប‌៉្រ័ះ ទី អំរ៉ាញ អឺញ ហ៊្លត ហះកា អាញ់ អូ រ៉ះ អន់ អន់ឌែ អន់ហ្នាល់ សិច អាញ់ តាទឹច អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","អាញ់ ទី សាញ៉ា រែវ ពុត លូ អន់ឌែ ផា ចឹង មប ប៉ាថេត កាណាន ឡាក់ អន់ឌែ អ្វៃ អង់រ៉ាម័ ណោះ ពែ អន់ កា អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","អាញ់ កាតាំង សុនសាត អ៊ីស្រាអ៊ែល តាំងអឹះ ញន កា សុនសាត អ៊ីស៊ីប អ្យក់ អន់ឌែ ប៉្រគ័ ទុច អាញ់ កា កាចាំង កា សារ អាញ់ សាញ៉ា ពែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","ទឹល នីណោ័ះ ហគ់ អីស ឡាំ រ៉ះ កា អន់ឌែ ផា \"អាញ់ ប‌៉្រ័ះ ប៊កកាតយ័ ។ អាញ់ ចឹង តោះ ឡើយ អន់ដីស អន់ រ៉ាវ៉ាច់ ឡឹង ង៉ារ ឡាំបាក ឡាក់ មួត អ៊ីស៊ីប ប៉ាំងខំ ប៉្រើ ប៉្រគ័ ណោះ។ អាញ់ ចឹង តង័ អន់ រ៉ាវ៉ាច់ ឡឹង កេះ ទុច អ៊ីស៊ីប។ អាញ់ ចឹង ហ្វាយ អន់ដីស លូ សារ អំរ៉ាញ អឺញ អាញ់ ទឹប ចៃគ ថូត សុនសាត អ៊ីស៊ីប តិម ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","អាញ់ ចឹង អ្យក់ អន់ដីស ប៉្រគ័ ប៉ាសុន អាញ់ ទឹប អាញ់ ចឹង ប៉្រគ័ ប‌៉្រ័ះ អន់ដីស ដេល។ អាញ់ ចឹង តោះ ឡើយ អន់ដីស អន់ រ៉ាវ៉ាច់ ឡឹង ង៉ារ ឡាំបាក ឡាក់ មួត អ៊ីស៊ីប ប៉ាំងខំ ប៉្រើ ប៉្រគ័ ណោះ។ ដារ់ ណោះ អន់ដីស ចឹង អ្លុ អន់តគ់ ផា អាញ់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","កេះណោះ អាញ់ ចឹង ប៉ាណាំ អន់ដីស ឡាំ អ្វៃ ប៉ាគ់ ប៉ាថេត ឡាក់ អាញ់ ម៉ត់ ចឹង អន់ កា អាប៉្រាហាំ អ៊ីសាក់ លូ យ៉ាកុប ឃឺ អាញ់ ចឹង អន់ ប៉ាថេត ណោះ កា អន់ដីស ប៉្រគ័ ប៉ាដក់។ អាញ់ ប‌៉្រ័ះ ប៊កកាតយ័ \"»។ ");
INSERT INTO tpu_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","វគ័ ម៉ូសេ ឡាំ រ៉ះ កា មួត អ៊ីស្រាអ៊ែល ឡាក់ កា ប៉ានឹរ ប‌៉្រ័ះ រ៉ះ ណោះ ហង ហះកា អន់ឌែ អូ សឿ អ៊ែ អុះ ខង អន់ឌែ អុក ពុត ញន អន់ឌែ កេះ ទុច មួត អ៊ីស៊ីប ឡាំបាក ខាក់ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ឡៃង ឡឹង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ណាវ្គ ផា ");
INSERT INTO tpu_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«ហគ់ អីស ឡាំ រ៉ះ កា សាដាច់ អ៊ីស៊ីប ផា \"អីស ត្រគ់ អន់ សុនសាត អ៊ីស្រាអ៊ែល ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប អា ពិ\"»។ ");
INSERT INTO tpu_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","វគ័ ម៉ូសេ តើល ប‌៉្រ័ះ ប៊កកាតយ័ ផា «ញ៉ាង កា អ៊ីស្រាអ៊ែល អូ សាំយ៉ាំង អូ សឿ កេះ សាឡង់ កា សាដាច់ ឡគ ចឹង ចៃ សាំយ៉ាំង ប៉ាណូស អូ ទី ប៉ានឹរ ពឹរ កាង ឡាក់ កា អាញ់ អា»។ ");
INSERT INTO tpu_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ឡាំ រ៉ះ កា ប៉ាសុន អ៊ីស្រាអ៊ែល លូ រ៉ះ កា សាដាច់ ភឿ អន់ មួត អ៊ីស្រាអ៊ែល ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប។ … ");
INSERT INTO tpu_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហៃ អាញ់ ចឹង ប៉្រគ័ អន់ អីស វ៉ឹច លូ ប‌៉្រ័ះ អ្វៃ ហះ ង៉ីរ សាដាច់ អ៊ីស៊ីប។ ម៉ី អីស អារ៉ុន ចឹង រ៉ះ សារ ប៉ាតាង អីស ឡាក់ កា រ៉ាគឹយ ប‌៉្រ័ះ ។ ");
INSERT INTO tpu_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","អីស ត្រគ់ រ៉ះ កា អារ៉ុន ទិ សារ អាញ់ អន់តគ់ រ៉ះ កា អីស អា ហង អន់ អ៊ែ ឡាំ រ៉ះ កា សាដាច់ ភឿ អន់ អ៊ីស្រាអ៊ែល ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","កាប៉ាច់ អាញ់ ចឹង ប៉្រគ័ អន់ សាដាច់ កាង័ កល់។ យ‌៉័ះ អាញ់ តាំបាង សារ អំរ៉ាញ អឺញ អៀង នែវ ពឹង ប៉ាថេត អ៊ីស៊ីប អា កាតាម ");
INSERT INTO tpu_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","សាដាច់ អ៊ីស៊ីប អ៊ែ ចឹង អូ ចៃ សាំយ៉ាំង អន់ដីស អុះ។ ទឹល នីណោ័ះ អាញ់ ចឹង ពីត ប៉ាថេត អ៊ីស៊ីប លូ ចៃគ ថូត អន់ឌែ តិម ខាក់ ឡូត កេះណោះ ប៉ាណាំ ប៉ាសុន អាញ់ អ៊ីស្រាអ៊ែល អន់ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប វ៉ឹច លូ មួត តាហាន ចាក ប៉ិន តាប៉ល់ ៗ។ ");
INSERT INTO tpu_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ប៉ាគ់ អាញ់ ពីត ប៉ាថេត អ៊ីស៊ីប លូ ប៉ាណាំ អ៊ីស្រាអ៊ែល ឡាច់ កេះណោះ ប៉ាសុន អ៊ីស៊ីប ចឹង អ្លុ អន់តគ់ ផា អាញ់ ប‌៉្រ័ះ ប៊កកាតយ័ តាទឹច»។ ");
INSERT INTO tpu_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ប៉្រគ័ ពួយ ទិ សារ ប‌៉្រ័ះ ប៊កកាតយ័ អន់តគ់ រ៉ះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ផះ រ៉ាំងវ៉ាង អន់ឌែ ឡាំ កាប កា សាដាច់ អ៊ីស៊ីប ណោះ អាញុ វគ័ ម៉ូសេ ៨០ សាណាំ កេះ អាញុ វគ័ អារ៉ុន កា ៨៣ សាណាំ កេះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ផា ");
INSERT INTO tpu_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«ផា សាដាច់ អ៊ីស៊ីប ប៉្រើ អន់ដីស តាំបាង សារ អំរ៉ាញ អឺញ អីស ត្រគ់ ប៉្រើ អារ៉ុន វ៉ឹត អ៊្លង កាទូង ណោះ ហះ ង៉ីរ សាដាច់។ អ៊្លង កាទូង ចឹង កេះ ពិះ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន កា ឡាំ ប៉ាគ់ ចារ សាដាច់ អ៊ីស៊ីប លូ ប៉្រគ័ ពួយ គ្រឹប សារ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អន់ឌែ ប៉្រគ័ ណោះ ហង។ វគ័ អារ៉ុន កា ហឹរ អ៊្លង កាទូង ហះ ង៉ីរ សាដាច់ លូ មួត រ៉ាតីស អ៊្លង កាទូង ណោះ កា កេះ ពិះ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ហះកា សាដាច់ អើ មួត គ្រូ អំហ្ម សុនសាត អ៊ីស៊ីប ប៉្រើ អន់ឌែ ប៉្រគ័ លូ គ្រូ គុន អន់ឌែ អន់ អ៊្លង កាទូង កេះ ពិះ និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","អន់ឌែ កា ហឹរ អ៊្លង កាទូង ម៉ះ អន់ឌែ អ៊្លង កាទូង ណោះ កា កេះ ពិះ តាទឹច ហះកា អ៊្លង កាទូង វគ័ អារ៉ុន ឡាវ៉ាន័ អ៊្លង កាទូង អន់ឌែ ទិ។ ");
INSERT INTO tpu_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ហះកា សាដាច់ កាង័ កល់ ខាក់ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ណោះ ហង អ៊ែ អូ ចៃ សាំយ៉ាំង វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «សាដាច់ កាង័ កល់ ខាក់ អ៊ែ អូ អន់ ប៉ាសុន អាញ់ ឡាច់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ទឹល នីណោ័ះ កាំលឺ ទៀ ផះ សាដាច់ ឡាំ ប៉ាគ់ ហាង តាំងលេ នីល អីស ត្រគ់ ឡាំ តាកាន អ៊ែ ប៉ាគ់ ចារ ណោះ ដេល។ អីស ចឹក ឡាំ ទឹប អ៊្លង កាទូង ឡាក់ អ្លុ កេះ ពិះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","អីស ត្រគ់ រ៉ះ កា សាដាច់ ផា \"ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត ហេព្រឺ អ៊ែ ប៉្រើ អាញ់ ឡាំ រ៉ះ កា អីស។ អ៊ែ ផា អីស ត្រគ់ អន់ ប៉ាសុន អ៊ែ ឡាច់ ឡាំ សាំប‌៉័ះ ប៉ានេ អ៊ែ ប៉ាគ់ ស៊្រែ តីស តោ។ ហះកា ទឹល កិញអៀ អា អីស អូ សាំយ៉ាំង អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","អ៊ែ រ៉ះ ផា នីអៀ ម៉ោញ ទង អា ណាវ្គ អីស ចឹង អន់ហ្នាល់ ផា អ៊ែ ប‌៉្រ័ះ ប៊កកាតយ័ តាទឹច ហង។ អាញ់ ចឹង ពីត ទៀក តាំងលេ នីល លូ អ៊្លង កាទូង អាញ់ ចឹក អា កេះណោះ ទៀក តាំងលេ នីល អា ចឹង កេះ ផាម ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","កា ឡាក់ អ្វៃ កាណុង ទៀក អា ត្រគ់ តោ័ ទិ ទៀក តាំងលេ ចឹង បោ អោម សុនសាត អ៊ីស៊ីប ចឹង ខាអឺម អៃត ហង ទៀក អា\"»។ ");
INSERT INTO tpu_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ វគ័ ម៉ូសេ រ៉ះ កា វគ័ អារ៉ុន ផា «ហគ់ អីស អ្យក់ អ៊្លង កាទូង យ៉ើរ អំប៉ាំង ទៀក តាំងលេ តាំងលោ័ លូ ទៀក ទ្រូង ពឹង ប៉ាថេត អ៊ីស៊ីប អា រិញ ភឿ អន់ ទៀក ទិណោ័ះ កេះ ផាម យ‌៉័ះ ទៀក កាណុង ព្រឺយ កាណុង រ៉ាពួង កា កេះ ផាម និះទៅ ដេល» ");
INSERT INTO tpu_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន កា ប៉្រគ័ ពួយ គ្រឹប សារ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អន់ឌែ ប៉្រគ័ ណោះ ហង។ វគ័ អារ៉ុន កា យ៉ើរ ពីត ទៀក តាំងលេ នីល លូ អ៊្លង កាទូង ហះ ម៉ាត់ សាដាច់ លូ មួត រ៉ាតីស ផាឌី ទៀក តាំងលេ នីល ណោះ កា កេះ ផាម តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","កា ឡាក់ អ្វៃ កាណុង ទៀក តាំងលេ នីល ណោះ តោ័ ទិ ទៀក តាំងលេ កើត បោ អោម សុនសាត អ៊ីស៊ីប ខាអឺម អូ ចៃ អៃត ទៀក ណោះ កេះ។ ទិ ទៀក កាណុង ប៉ាថេត អ៊ីស៊ីប កា កេះ ផាម ដោះ។ ");
INSERT INTO tpu_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ហះកា មួត គ្រូ អំហ្ម សុនសាត អ៊ីស៊ីប ណោះ អន់ឌែ ប៉្រគ័ លូ គ្រូ គុន អន់ឌែ អ្លុ និះទៅ ដេល។ ញន ខ អា ហង បះ សាដាច់ កាង័ កល់ អ៊ែ អូ ចៃ សាំយ៉ាំង វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ត្រគ់ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ពែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","អ៊ែ សឹត ម៉ុត អ្វៃ ពឹង ហី អ៊ែ ណាវ្គ អ៊ែ អូ ឃឹត ឡឹង សារ ទិណោ័ះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ប៉ាសុន អ៊ីស៊ីប ទិឌូ សីរ ទៀក អន់ដូង័ រហាង តាំងលេ នីល ភឿ អ្យក់ ទៀក ដាគ់ អៃត ខង ទៀក តាំងលេ នីល ណោះ អន់ឌែ អូ អ្លុ អៃត កេះ។ ");
INSERT INTO tpu_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","តាំប៉ើះ ដារ់ ឡឹង ប‌៉្រ័ះ ប៊កកាតយ័ ពីត ទៀក តាំងលេ នីល ");
INSERT INTO tpu_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","អ៊ែ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហគ់ អីស ឡាំ រ៉ះ កា សាដាច់ អ៊ីស៊ីប ផា \"ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អីស អន់ ប៉ាសុន អ៊ែ ឡាច់ ចាក ឡាំ សាំប‌៉័ះ ប៉ានេ អ៊ែ ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ផា អីស អូ អន់ អ៊ែ ចឹង ប៉្រើ កឹត អៀង ឡាំ អ្វៃ ពឹង ប៉ាថេត អ៊ីស៊ីប អា ប៉្រគ័ អន់ កា អន់ដីស គៀម គូន។ ");
INSERT INTO tpu_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","កឹត ចឹង កើត អៀង ប៉ាញ័ តាំងលេ នីល លូ ចឹង ប៉្លង់ ម៉ុត កាណុង ហី ទឹប ចឹង ប៉្លង់ ហាវ ពឹង គ្រេ អីស តៃប។ កឹត ណោះ ចឹង ប៉្លង់ ម៉ុត កាណុង ហី មួត រ៉ាតីស ដេល លូ កាណុង ហី មួត ប៉ាសុន អីស ទឹប ចឹង ម៉ុត ពឹង អំហ្មូវ អុញ ចារ ប៉្រគ័ សាណា លូ ចឹង ម៉ុត អ្វៃ កាណុង កាបឺង ពូ ឡាយ តាប៉ុង កា អីស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","កេះណោះ អន់ឌែ ចឹង ប៉្លង់ ហាវ ពឹង ឡាកោ អីស លូ ពឹង ឡាកោ មួត រ៉ាតីស ទឹប ពឹង ឡាកោ មួត ប៉ាសុន អីស ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ណាវ្គ ផា «ហគ់ អីស ប៉្រើ អារ៉ុន យ៉ើរ អ៊្លង កាទូង អំប៉ាំង ទៀក តាំងលេ ទៀក ទ្រូង លូ ទៀក តាំងលោ័ ម៉ាគ់ កឹត ហាវ ចាក ប៉ាញ័ ទឹប ប៉ាថេត អ៊ីស៊ីប អា»។ ");
INSERT INTO tpu_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","វគ័ អារ៉ុន កា យ៉ើរ តី អំប៉ាំង ទៀក ពឹង ប៉ាថេត អ៊ីស៊ីប ផាឌី ទី កឹត ឡាច់ ចាក ប៉ាញ័ ទឹប ប៉ាថេត អ៊ីស៊ីប តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ហះកា គ្រូ អំហ្ម សុនសាត អ៊ីស៊ីប អន់ឌែ អ្លុ ប៉្រគ័ លូ គ្រូ គុន អន់ឌែ អន់ ឡាច់ កឹត ចាក ពឹង ប៉ាថេត អ៊ីស៊ីប និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","កេះណោះ សាដាច់ អើ វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ទឹប រ៉ះ ផា «ហគ់ អន់ដីស ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ អន់ អ៊ែ អ្យក់ ឡាច់ កឹត ឡឹង ប៉ាថេត អាញ់ អា អាញ់ ចឹង អន់ ប៉ាសុន អ៊ែ ឡាច់ ឡាំ ពុះ កាណាគ័ រ៉ាម៉ះ អ៊ែ»។ ");
INSERT INTO tpu_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","វគ័ ម៉ូសេ តើល សាដាច់ ផា «ប៉រ់ អីស កាំឡត់ ដារ់ កា អាញ់ ពិ ដារ់ ចំ អាញ់ ចឹង ត្រគ់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ សាំរ៉ាប់ កា អីស លូ មួត រ៉ាតីស ទឹប ប៉ាសុន អីស ភឿ អន់ អ៊ែ អ្យក់ ឡាច់ កឹត ឡឹង ហី អន់ដីស អន់ អ្វៃ សល់ ដឹង ពឹង តាំងលេ»។ ");
INSERT INTO tpu_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","សាដាច់ តើល ផា «ដារ់ តាយ៉ាង័»។ វគ័ ម៉ូសេ តើល ផា «អឺះ អាញ់ ចឹង ប៉្រគ័ ពួយ អីស ប៉្រើ ម៉ាគ់ អីស ចឹង អ្លុ អន់តគ់ ផា អូ ទី ប‌៉្រ័ះ ចំ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ញឹន អា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","កឹត ចឹង ឡាច់ ឡឹង ឡាកោ អីស លូ ឡឹង ហី អន់ដីស លូ ឡឹង មួត រ៉ាតីស ទឹប ប៉ាសុន អីស ចឹង អ្វៃ សល់ ដឹង ពឹង តាំងលេ»។ ");
INSERT INTO tpu_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន កា ចាក ឡាច់ ឡឹង ចារ សាដាច់ កេះណោះ ម៉ូសេ ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ឡឹង សារ កឹត ឡាក់ អ៊ែ ប៉្រើ ឡាំ ប៉្រគ័ អន់ សាដាច់ អ៊ីស៊ីប គៀម គូន ពែ។ ");
INSERT INTO tpu_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉្រគ័ ពួយ សារ វគ័ ម៉ូសេ ឡោម ណោះ កឹត អ្វៃ កាណុង ហី ពឹង ស្រុក លូ ប៉ាគ់ ម៉ីរ តោ័ ទិ។ ");
INSERT INTO tpu_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","ពូ ចាក ប៉ាតុំ កឹត តោ័ ណោះ ពូក ប៉ិន ប៉ានូក បោ អោម ប៉ាញ័ ទឹប ប៉ាថេត។ ");
INSERT INTO tpu_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ប៉ាគ់ ប៉ប័ កឹត តោ័ ទិ កេះ សាដាច់ កាង័ កល់ អូ ចៃ សាំយ៉ាំង វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន អុះ ត្រគ់ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ពែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ឡៃង ឡឹង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហគ់ អីស ប៉្រើ អារ៉ុន យ៉ើរ អ៊្លង កាទូង អ៊ែ ពីត តេះ ភឿ អន់ កើត តាកាច់ អៀង ប៉ាញ័ ទឹប ប៉ាថេត អ៊ីស៊ីប»។ ");
INSERT INTO tpu_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","អន់ឌែ កា ប៉្រគ័ ពួយ ប៉ានឹរ ប‌៉្រ័ះ អន់តគ់ រ៉ះ វគ័ អារ៉ុន កា យ៉ើរ អ៊្លង កាទូង ពីត តេះ កាបក់ តេះ កា កេះ តាកាច់ ប៉ាញ័ ទឹប ប៉ាថេត អ៊ីស៊ីប ចាក អ្យោម ប៉ាណូស លូ កាណាគ័។ ");
INSERT INTO tpu_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","មួត គ្រូ អំហ្ម ប៉្រគ័ លូ គ្រូ គុន អន់ឌែ ប៉ាំងកើត តាកាច់ និះទៅ ដេល ហះកា អន់ឌែ ប៉្រគ័ អូ កើត អុះ។ តាកាច់ ណោះ អ្យោម ប៉ាណូស លូ កាណាគ័។ ");
INSERT INTO tpu_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","កេះណោះ មួត គ្រូ អំហ្ម រ៉ះ លូ សាដាច់ ផា «សារ អា កើត ឡាច់ ឡឹង ប‌៉្រ័ះ តាទឹច»។ ហះកា សាដាច់ កាង័ កល់ ខាក់ អូ ចៃ សាំយ៉ាំង វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន អុះ ត្រគ់ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ពែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ឡៃង ឡឹង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ លូ វគ័ ម៉ូសេ ផា «កាំលឺ តាយ៉ាង័ អីស អ្យូវ ឡឹង កាំលឺ ផុងម៉ាំង ឡាំ តាកាន សាដាច់ ផះ អ៊ែ ជឹរ ប៉ាគ់ ទៀក តាំងលេ។ កេះណោះ អីស រ៉ះ កា អ៊ែ ផា \"ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អីស អន់ ប៉ាសុន អ៊ែ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ឡាំ សាំប‌៉័ះ ប៉ានេ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","ផា អីស អូ អន់ ប៉ាសុន អ៊ែ ឡាច់ អ៊ែ ចឹង ប៉្រើ អន់ ទី ស្វ្រៃ អៀង ឡាំ កាប់ អីស លូ មួត រ៉ាតីស លូ ប៉ាសុន អីស ដេល។ កាណុង ហី សុនសាត អ៊ីស៊ីប ទិឌូ ចឹង ទី ស្វ្រៃ អៀង ព្រុងៗ ពឹង តេះ ស៊ុត ដឹង កា ស្វ្រៃ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","ហះកា ដារ់ ណោះ អ៊ែ ចឹង ប៉្រគ័ អន់ ស្រុក កូស៊ែន ឡាក់ ចារ សុនសាត អ៊ីស្រាអ៊ែល អ្វៃ ណោះ យច ឡឹង ចារ អន់ទៀគ ពឹង ប៉ាថេត អ៊ីស៊ីប ឃឺ អ៊ែ អូ អន់ ទី ស្វ្រៃ អុះ ភឿ អន់ អីស អ្លុ អន់តគ់ ផា អ៊ែ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ ពឹង ចារ ណោះ ។ ");
INSERT INTO tpu_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","អ៊ែ អូ អន់ ប៉ាសុន អ៊ែ ទី កាន ខូច័ ខាច អន់ឌូ លូ ប៉ាសុន អីស ណោះ អុះ សារ អា ដារ់ តាយ៉ាង័ កើត ហង»។ ");
INSERT INTO tpu_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ ពួយ សារ អ៊ែ រ៉ះ អ៊ែ ប៉្រើ ស្វ្រៃ អៀង ព្រុងៗ ប៉ារ់ ម៉ុត កាណុង ហី សាដាច់ លូ ហី មួត រ៉ាតីស។ ស្វ្រៃ ទិណោ័ះ កា ម៉ុត តាគ់ ប៉ាណាប អ្វៃ ប៉ាញ័ ទឹប ប៉ាថេត អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","ផះ ណោះ សាដាច់ អើ វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន លូ រ៉ះ ផា «ហគ់ អន់ដីស ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ អន់ដីស ពឹង ប៉ាថេត អា ហង ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","ហះកា វគ័ ម៉ូសេ តើល សាដាច់ ផា «ប៉្រគ័ នីណោ័ះ អូ ត្រគ់ អុះ ខង ញឹន ចឹង អ្យក់ កាណាគ័ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័  ណោះ ចឹង ប៉្រគ័ អន់ សុនសាត អ៊ីស៊ីប ខាអឺម ខាក់។ ផា អន់ឌែ ប៉ប័ ញឹន ប៉្រគ័ នីណោ័ះ ចាបះ កា អន់ឌែ ចឹង អ្យក់ អំហ្មោ ហឹរ ញឹន អន់ តោ័ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ញឹន ត្រគ់ ឡាំ ប៉ាគ់ ស៊្រែ តីស តោ ចាំងហាយ្គ ខា ប៉ៃង ដារ់ ចាក ភឿ ចឹង ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ញឹន ប៉្រគ័ ពួយ សារ អ៊ែ រ៉ះ កា ញឹន»។ ");
INSERT INTO tpu_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","សាដាច់ តើល ផា «អាញ់ ចឹង អន់ អន់ដីស ចាក ឡាំ ពុះ កាណាគ័ រ៉ាម៉ះ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ប៉ាគ់ ស៊្រែ តីស តោ ហះកា អន់ដីស ជែ ចាក ចាំងហាយ្គ តាឡាម័។ អន់ដីស ម៉ន់ ឡោម ប‌៉្រ័ះ អន់ដីស ណោះ អន់ កា អាញ់ ណើ ហោគ»។ ");
INSERT INTO tpu_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","វគ័ ម៉ូសេ តើល ផា «ប៉ាគ់ ញឹន ចាក ឡាច់ ឡឹង ចារ អីស អា ទៀ អាញ់ ចឹង ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ។ តាយ៉ាង័ ស្វ្រៃ ចឹង ប៉ារ់ ឡាច់ ឡឹង ចារ អីស លូ មួត រ៉ាតីស លូ ឡឹង ចារ ប៉ាសុន អីស ដេល។ ហះកា អីស ជែ កាប ប៉ាង៉ល់ ញឹន ណាវ្គ ហង លូ អីស ជែ កាឡីស កា ប៉ាសុន ញឹន ចាក ឡាំ ប៉ាគ់ ស៊្រែ តីស ភឿ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ »។ ");
INSERT INTO tpu_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","វគ័ ម៉ូសេ កា ចាក ឡាច់ ឡឹង ចារ សាដាច់ កេះណោះ អ៊ែ ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉្រគ័ ពួយ សារ វគ័ ម៉ូសេ ម៉ន់ ឡោម ណោះ អ៊ែ តាគ់ អង់ហ៊្យង ស្វ្រៃ ឡឹង ចារ សាដាច់ លូ ចារ មួត រ៉ាតីស លូ ចារ ប៉ាសុន អន់ ទិ អូ ទី គម អន់ អ្វៃ សល់ លូ ម៉ោញ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ហះកា សាដាច់ អ្វៃ កា កាង័ កល់ និះទៅ ម៉ោញ ទង ណាវ្គ អូ អន់ អ៊ីស្រាអ៊ែល ចាក ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ឡៃង ឡឹង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហគ់ អីស ឡាំ រ៉ះ កា សាដាច់ ផា \"ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត ហេព្រឺ អ៊ែ ប៉្រើ អីស អន់ ប៉ាសុន អ៊ែ ឡាច់ ឡាំ សាំប‌៉័ះ ប៉ានេ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ផា អីស អូ សឿ សារ អ៊ែ រ៉ះ លូ អូ អន់ ប៉ាសុន អ៊ែ ចាក ឡាច់ ណាវ្គ ");
INSERT INTO tpu_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉្រគ័ អន់ កាណាគ័ អីស រង ឡាក់ កា សេះ រ៉ក់ លៀ អូត ចៀម ប៉ារ់ពេ ឡាក់ អ្វៃ ប៉ាគ់ ព្រី ប៉ាគ់ អ្យិត ត្រគ់ ប៉ាញុ ត្រគ់ រ៉ាំបល់ តុត យ៉ឹប ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉្រគ័ អន់ កាណាគ័ អ៊ីស៊ីប លូ កាណាគ័ អ៊ីស្រាអ៊ែល យច ឡឹង គួប សោប ឃឺ កាណាគ័ អ៊ីស្រាអ៊ែល ចឹង អូ តោ័ អុះ ឡាក់ កា កាណាគ័ អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","ប‌៉្រ័ះ ប៊កកាតយ័ កាំឡត់ ផា ដារ់ តាយ៉ាង័ ទៀ ហង អ៊ែ ចឹង ប៉្រគ័ សារ អា ពឹង ប៉ាថេត អ៊ីស៊ីប\"»។ ");
INSERT INTO tpu_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","ប៉ាគ់ ទឹល ដារ់ តាយ៉ាង័ ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉្រគ័ តាទឹច អ៊ែ ប៉្រគ័ អន់ កាណាគ័ សុនសាត អ៊ីស៊ីប រង ត្រគ់ ប៉ាញុ រ៉ាំបល់ តោ័ ទិ ហះកា កាណាគ័ សុនសាត អ៊ីស្រាអ៊ែល រង ម៉ោញ កាតុ កា អូ ទី តោ័ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","សាដាច់ ប៉្រើ ពូ ឡាំ សឺប ហៃ កាណាគ័ សុនសាត អ៊ីស្រាអ៊ែល រង តោ័ ដេល ប ពូ កា ប៉ប័ ម៉ោញ កាតុ កា អូ តោ័ អុះ។ យ‌៉័ះ នីណោ័ះ កាតាម អ៊ែ អ្វៃ កា កាង័ កល់ អូ អន់ សុនសាត អ៊ីស្រាអ៊ែល ឡាច់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ផា «ហគ់ អន់ដីស កោច អំហ្មូវ ម៉ោញ កាំប៉ង់ អន់ កា ម៉ូសេ ចី ហាវ ពឹង ប៉្លៃង ហះ ម៉ាត់ សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","អំហ្មូវ ណោះ ចឹង កើត កាបក់ ឡាអ៊ង ចឹង តាប៉ើះ ប៉ាញ័ ទឹប ប៉ាថេត អ៊ីស៊ីប ប៉្រគ័ អន់ ប៉ាណូស លូ កាណាគ័ ពូ រង កើត អេះ អោម ទិឌូ»។ ");
INSERT INTO tpu_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន កា កោច អំហ្មូវ កេះណោះ អន់ឌែ ឡាំ ប៉ាគ់ ចារ សាដាច់ ម៉ូសេ កា ចី អំហ្មូវ ពឹង ប៉្លៃង ប៉្រគ័ អន់ ប៉ាណូស លូ កាណាគ័ ពូ រង កើត អេះ អោម តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","មួត គ្រូ អំហ្ម អន់ឌែ អូ អ្លុ អ្វៃ ក្យាម័ វគ័ ម៉ូសេ អុះ ខង អន់ឌែ កា កើត អេះ អោម ឡាក់ កា សុនសាត អ៊ីស៊ីប និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ កា សាដាច់ កាង័ កល់ កាខាក់ លូ អូ ចៃ សាំយ៉ាំង វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន អុះ ត្រគ់ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ពែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ឡៃង ឡឹង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ លូ វគ័ ម៉ូសេ ណាវ្គ ផា «ដារ់ តាយ៉ាង័ អីស អ្យូវ ឡឹង កាំលឺ ផុងម៉ាំង ឡាំ រ៉ះ លូ សាដាច់ ផា \"ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត ហេព្រឺ អ៊ែ រ៉ះ ផា 'អីស ត្រគ់ អន់ ប៉ាសុន អាញ់ ឡាំ សាំប‌៉័ះ ប៉ានេ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ម៉ោញ ទង អា អាញ់ ចឹង ប៉្រគ័ អន់ អីស លូ មួត រ៉ាតីស ទឹប ប៉ាសុន អីស អន់ ទី សារ ឡាំបាក គ្រឹប នែវ ភឿ អន់ អីស អ្លុ អន់តគ់ ផា អាញ់ អា កេង ហ៊្លត ពឹង អង់កក់ តេះ អា អូ ទី កាណាគ័ ញ៉ា ចឹង ប៉ាន់ដឹប លូ អាញ់ ទី អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ផា អាញ់ ចៃ ប៉្រើ ប៉ាញុ រ៉ាំបល់ សា អីស លូ ប៉ាសុន អីស ណោះ អន់ដីស តោ័ ទិ ប្លី ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ហះកា អាញ់ គម អីស អន់ អ្វៃ រ៉ីស ភឿ ចឹង តាំបាង សារ អំរ៉ាញ អឺញ អាញ់ អន់ អីស ប៉ប័ ម៉ាគ់ ពូ ចឹង រ៉ះ សិច អាញ់ លៅ លែង ប៉ាញ័ ទឹប អង់កក់ តេះ។ ");
INSERT INTO tpu_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","អីស អា អ្វៃ កា តីស ពុត ខឹន ប៉ាសាំង លូ ប៉ាសុន អាញ់ ឃឺ អីស អូ អន់ អន់ឌែ ចាក ឡាច់។ ");
INSERT INTO tpu_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ទឹល នីណោ័ះ ដារ់ តាយ៉ាង័ ទៀ ដារ់ ប៉ុប អា ទៅ អាញ់ ចឹង ប៉្រគ័ អន់ ប៉្លៃ ម៉ារៀល តីសៗ ឡិ ពឹង ប៉ាថេត អា ឡូត។ ឡឹង ប៉ាថេត អ៊ីស៊ីប កើត ទឹល រ៉ប់ ដារ់ អា ពូ អូ ឃើយ ប៉ប័ អុះ ឡាក់ កា ម៉ោញ ទង អា។ ");
INSERT INTO tpu_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","កិញអៀ អា ហគ់ រ៉ះ កា ពូ ប៉្រើ អ្យក់ សឹត កាណាគ័ ញ៉ា ឡាក់ ពូ រង ប៉ាគ់ ព្រី ប៉ាគ់ អ្យិត អ្យក់ សឹត អន់ ប៉ាគ់ ហី។ ផា កាណាគ័ លើ កា ប៉ាណូស អ្វៃ ប៉ាគ់ ព្រី ប៉ាគ់ អ្យិត អូ ទី ចារ ម៉ុត កាន់ទឹង ប៉ាគ់ ប៉្លៃ ម៉ារៀល ឡិ ទៀ ចឹង ប៉្រគ័ អន់ កា អន់ឌែ តោ័' \"»។ ");
INSERT INTO tpu_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","មួត រ៉ាតីស បក់ អន់ដា អ្យូគ កា ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័  អន់ឌែ ប៉្រើ មួត ទុច អ្យក់ សឹត កាណាគ័ អន់ឌែ រង ម៉ុត ទិ កាណុង ហី។ ");
INSERT INTO tpu_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","កាប៉ាច់ មួត បក់ អូ សឿ អូ រ៉ាប់ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ អន់ឌែ អ្លាត មួត ទុច លូ កាណាគ័ អន់ឌែ រង ប៉ាគ់ ព្រី ប៉ាគ់ អ្យិត ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហគ់ អីស លឺក តី សាំប្លោ ពឹង ប៉្លៃង ម៉ាគ់ ប៉្លៃ ម៉ារៀល ចឹង ឡិ ត្រគ់ ប៉ាណូស ត្រគ់ កាណាគ័ ពូ រង លូ ត្រគ់ សាណា ពូ តប់ ប៉ាញ័ ទឹប ប៉ាថេត អ៊ីស៊ីប អា»។ ");
INSERT INTO tpu_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","វគ័ ម៉ូសេ កា លឺក អ៊្លង កាទូង សាំប្លោ ពឹង ប៉្លៃង ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉្រគ័ អន់ ទី សាលៀស តេះតរ់ តះ ពឹង តេះ។ កេះណោះ អ៊ែ ប៉ាឡិ ជឹរ ប៉្លៃ ម៉ារៀល ពឹង ប៉ាថេត អ៊ីស៊ីប ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ប៉្លៃ ម៉ារៀល តីសៗ ឡិ ពឹង ប៉ាថេត អ៊ីស៊ីប អន់ឌូ លូ សាលៀស តេះតរ់ តុត ថាំង។ ឡឹង កើត ប៉ាសុន អ៊ីស៊ីប ពូ អូ ឃើយ ប៉ប័ ទី នីអៀ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ប៉្លៃ ម៉ារៀល ឡិ ណោះ ប៉ាញ័ ប៉ាថេត អ៊ីស៊ីប ត្រគ់ ប៉ាណូស ត្រគ់ កាណាគ័ ពូ រង បក់ អ្វៃ ប៉ាគ់ ព្រី ប៉ាគ់ អ្យិត លូ ថាំឡាយ សាណា ពូ តប់ ប៉ាគ់ ម៉ីរ ទិ ប្លី ទឹប តាគ់ អំប៉ាក់ តើម អ៊្លង ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","ទី ដឹង ពឹង ស្រុក កូស៊ែន ឡាក់ ស្រុក សុនសាត អ៊ីស្រាអ៊ែល អ្វៃ អូ ទី ប៉្លៃ ម៉ារៀល ឡិ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","កេះណោះ សាដាច់ អើ វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន លូ រ៉ះ ផា «លឺក អា អាញ់ ប៉្រគ័ យច តាទឹច ហង ទី ដឹង ប‌៉្រ័ះ ប៊កកាតយ័ ដាគ់ អាញ់ លូ ប៉ាសុន អាញ់ ឡាក់ ប៉ាណូស អូ ដាគ់។ ");
INSERT INTO tpu_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ហគ់ អីស ឡោម ប‌៉្រ័ះ ប៊កកាតយ័  អន់ តេះតរ់ លូ ប៉្លៃ ម៉ារៀល ឡិ ដឹង គឹត អា បគ័ ហង អាញ់ ចឹង អន់ អន់ដីស ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប អា តាទឹច ហង អន់ដីស ចឹង អូ អ្វៃ ហង ពឹង ប៉ាថេត អា ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","វគ័ ម៉ូសេ តើល ផា «ប៉ាគ់ អាញ់ ចាក ឡាច់ ឡឹង មឿង អា កេះ អាញ់ ចឹង លឺក តី ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័  តេះតរ់ ចឹង ស្វាស ប៉្លៃ ម៉ារៀល កា អូ ឡិ ហង ម៉ាគ់ អីស ចឹង អ្លុ អន់តគ់ ផា អង់កក់ តេះ អា ឃឺ ម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","ហះកា អាញ់ អ្លុ អន់តគ់ ផា អីស លូ មួត រ៉ាតីស អន់ដីស បើ អ្យូគ កា ប‌៉្រ័ះ ប៊កកាតយ័ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","ផះ រ៉ាំងវ៉ាង ប៉្លៃ ម៉ារៀល ឡិ ណោះ តើម តាមៃ ផះ ប៉ាកាវ ពៀ សាឡី ឡាក់ ស៊្រស ឡឹង ពូ ផះ រក។ ");
INSERT INTO tpu_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","កាប៉ាច់ ពៀ សាឡី ឡាក់ ក្រូ អូ ទី រ៉ាយ រ៉ាំ អុះ ខង បើ តាន័ រក។ ");
INSERT INTO tpu_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","កេះណោះ វគ័ ម៉ូសេ ឡាច់ ឡឹង ចារ សាដាច់ ចាក ឡាំ គែង ឡីង មឿង លឺក តី ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ។ បី លូ តេះតរ់ កា ស្វាស ប៉្លៃ ម៉ារៀល កា អូ ឡិ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","សាដាច់ ហៃ កា តេះតរ់ លូ បី ស្វាស កេះ ប៉្លៃ ម៉ារៀល កា អូ ឡិ កេះ អ៊ែ លូ មួត រ៉ាតីស អន់ឌែ កាង័ កល់ លូ ប៉្រគ័ យច ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","អ៊ែ កាង័ កល់ អូ អន់ សុនសាត អ៊ីស្រាអ៊ែល ចាក ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប អុះ ត្រគ់ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ពែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ឡៃង ឡឹង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហគ់ អីស ម៉ុត ពឹង ចារ សាដាច់ ខង អាញ់ ប៉្រគ័ អន់ កា អ៊ែ លូ មួត រ៉ាតីស កាង័ កល់ ម៉ាគ់ អាញ់ ចឹង ប៉្រគ័ សារ អំរ៉ាញ អឺញ កេង ខាក់ អន់ កា អន់ឌែ ប៉ប័ ");
INSERT INTO tpu_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ម៉ាគ់ អន់ដីស ចឹង អ្លុ រ៉ះ កា គន សោ អ៊ីស្រាអ៊ែល រ៉ាំងហាវ អន់តីគ ទៀ អាញ់ ប៉្រគ័ កា សុនសាត អ៊ីស៊ីប នីចម័ លូ អាញ់ តាំបាង សារ អំរ៉ាញ អឺញ កេង ខាក់ នីចម័ អន់ដា កា អន់ឌែ។ ណោះ ហង បះ អន់ដីស ចឹង អ្លុ អន់តគ់ ផា អាញ់ អា ហង ប‌៉្រ័ះ ប៊កកាតយ័ »។ ");
INSERT INTO tpu_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ម៉ុត ពឹង ចារ សាដាច់ កេះណោះ រ៉ះ ផា «ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត ហេព្រឺ អ៊ែ ផា នីអៀ \"ដារ់ ចំ អីស ចឹង ចៃ រ៉ាប់ សឿ អាញ់ ? ហគ់ អីស អន់ ប៉ាសុន អាញ់ ឡាច់ ឡាំ សាំប‌៉័ះ ប៉ានេ អាញ់ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","ផា អីស អូ អន់ ប៉ាសុន អាញ់ ឡាច់ ដារ់ តាយ៉ាង័ ទៀ អាញ់ ចឹង ប៉្រើ ឡៃប អៀង កាខាក់ ម៉ុត អ្វៃ ពឹង ប៉ាថេត អីស អា។ ");
INSERT INTO tpu_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","អន់ឌែ ចឹង ឡើះ ប៉ាញ័ ទឹប ប៉ាថេត សាគឹម អូ ប៉ប័ អង់កក់ តេះ អន់ឌែ ចឹង សា សាណា ពូ តប់ ឡាក់ អ្វៃ សល់ ឡឹង ប៉្លៃ ម៉ារៀល ថាំឡាយ ពែ លូ អន់ឌែ ចឹង សា ហ្លា លូ ប៉្លៃ អ៊្លង ឡាក់ ហ៊ន ពឹង ម៉ីរ ពឹង ស៊្រែ អន់ ទិ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","អន់ឌែ ចឹង ម៉ុត ប៉ាញ័ ហី អីស លូ ហី មួត រ៉ាតីស ទឹប ហី ប៉ាសុន អីស ដេល។ ឡឹង វគ័ យ៉ាគ់ អីស សើគ ពែ ទឹល រ៉ប់ ដារ់ អា អូ ទី ពឿ ឃើយ ប៉ប័ សារ នែវ អា អុះ\"»។ កេះណោះ វគ័ ម៉ូសេ ចាក ឡាច់ ឡឹង ចារ សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","មួត រ៉ាតីស រ៉ះ កា សាដាច់ ផា «នីចម័ ចឹង អន់ ប៉ាណូស អា ប៉្រគ័ អន់ ពិន ទី សារ ឡាំបាក នីអៀ លើយ ហង ប ? អីស អន់ អន់ឌែ ចាក ឡាំ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ឌែ ទៅ ពិ។ អីស អូ ប៉ប័ ប ប៉ាថេត អ៊ីស៊ីប ផះ ទី សារ ឡាំបាក តាគ្រួប ទឹប ប៉ាថេត អា»។ ");
INSERT INTO tpu_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","ពូ ជៀក វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ឡាំ កាកាប លូ សាដាច់ ណាវ្គ សាដាច់ រ៉ះ កា អន់ឌែ ផា «អន់ដីស ប៉ាណាំ គួប ឡាំ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស កាតាម ហះកា ពឿ អន់ដា ចឹង ត្រគ់ ឡាំ ណោះ ?» ");
INSERT INTO tpu_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","វគ័ ម៉ូសេ តើល ផា «ត្រគ់ ឡាំ ទិឌូ ញឹន ហង ទឹប កាម៉ាក័ ទឹប អង់កាន់ ទឹប សាស្វា ទឹប ក្រាគ់ ទឹប តាប៉ល់ ប៉ារ់ពេ តាប៉ល់ ចៀម តាប៉ល់ រ៉ក់ ខង ញឹន ចឹង អៃត សា រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ »។ ");
INSERT INTO tpu_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","សាដាច់ តើល ផា «អាញ់ អូ អន់ អុះ អន់ដីស ឡាំ ទិឌូ ទឹប អង់កាន់ លូ សាស្វា ណោះ ខង អន់ដីស ទី ពុត អូ ដាគ់។ ");
INSERT INTO tpu_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","អន់ ដឹង មួត កាម៉ាក័ៗ ឡាំ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ បគ័ ហង តាលួម កា អន់ដីស ប៉រ់ នីអៀ»។ កេះណោះ ពូ តាំងហ្យិត ឡាច់ អន់ឌែ ឡឹង ចារ សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហគ់ អីស លឺក តី សាំប្លោ ប៉ាថេត អ៊ីស៊ីប ភឿ អន់ ឡៃប ពឹះ អ្វៃ ប៉ាញ័ ទឹប ប៉ាថេត អា ម៉ាគ់ អន់ឌែ សា ទិ សាណា ញ៉ា ឡាក់ អ្វៃ សល់ ឡឹង ប៉្លៃ ម៉ារៀល ថាំឡាយ ពែ»។ ");
INSERT INTO tpu_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","វគ័ ម៉ូសេ កា លឺក អ៊្លង កាទូង សាំប្លោ ប៉ាថេត អ៊ីស៊ីប ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ ទី ខ្យាល ពឹះ ឡឹង ដារ់ ឡាច់ ប៉ឹ ម៉ុត ពឹង ប៉ាថេត អ៊ីស៊ីប ទុញ ម៉ោញ ដារ់ ម៉ោញ ម៉ាំង។ ប៉ាគ់ កាំលឺ តាយ៉ាង័ ខ្យាល ប៉ឹ ប៉ាណាំ ពឹះ ទឹប ឡៃប ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ទី ឡៃប អៀង កាខាក់ ប៉ារ់ ម៉ុត អ្វៃ ប៉ាញ័ ទឹប ប៉ាថេត អ៊ីស៊ីប។ ឡឹង សើគ ឡឹង ពែ ពូ អូ ឃើយ ប៉ប័ អុះ ប៉ាគ់ ម៉ាត់ ទៀ ណាវ្គ កា អូ ទី ឡៃប អៀង ប៉ុប អា ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ឡៃប ឡើះ ប៉ាញ័ ទឹប តេះ ប៉្រគ័ អន់ ម៉ាម៉ាំង ទឹប ប៉ាថេត អ៊ីស៊ីប អន់ឌែ សា ទិ សាណា លូ ប៉្លៃ អ៊្លង ឡាក់ អ្វៃ សល់ ឡឹង ប៉្លៃ ម៉ារៀល ថាំឡាយ ពែ។ ហ្លា អ្យិត ហ្លា អ៊្លង ពឹង ប៉ាថេត អ៊ីស៊ីប អន់ឌែ សា ទិ អូ ទី សល់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","សាដាច់ កា ប៉ាន់តាន អើ វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ទឹប កាប ផា «អាញ់ ប៉្រគ័ យច លូ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ទឹប ប៉្រគ័ យច លូ អន់ដីស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","កិញអៀ អា ប៉រ់ អីស ជែ អ្យក់ យ៉ូ សារ អាញ់ ប៉្រគ័ យច ម៉ោញ ទង អា ណាវ្គ ប៉រ់ អន់ដីស ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ អន់ អ៊ែ អ្យក់ ឡាច់ សារ ឡៃប ថាំឡាយ អា ឡឹង ចារ អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","វគ័ ម៉ូសេ ចាក ឡាច់ ឡឹង ចារ សាដាច់ កេះណោះ ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉្រគ័ អន់ ទី ខ្យាល តីស ពឹះ ឡឹង ដារ់ ម៉ុត ត្រុត អន់ គែង ទៀក តាំងលេ តីស ស៊ូប ទិ ប្លី ឡៃប ម៉ោញ កាតុ កា អូ អ្វៃ សល់ ពឹង ប៉ាថេត អ៊ីស៊ីប អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ កា សាដាច់ កាង័ កល់ អូ អន់ ប៉ាសុន អ៊ីស្រាអ៊ែល ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ឡៃង ឡឹង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហគ់ លឺក ហាវ តី ពឹង ប៉្លៃង ម៉ាគ់ ចឹង ទី ម៉ាម៉ាំង ពឹង ប៉ាថេត អ៊ីស៊ីប អា ឃឺ ម៉ាម៉ាំង ក្លិង ហៃ កាណាគ័ ញ៉ា កា អូ ប៉ប័ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","វគ័ ម៉ូសេ កា លឺក ហាវ តី ពឹង ប៉្លៃង កា កើត ទី ម៉ាម៉ាំង ប៉ាញ័ ទឹប ប៉ាថេត អ៊ីស៊ីប ឃឺ ម៉ាម៉ាំង ក្លិង ទុញ ប៉ៃង ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","កាណុង រ៉ាំងវ៉ាង ប៉ៃង ដារ់ ណោះ សុនសាត អ៊ីស៊ីប ហៃ គួប សោប អូ ប៉ប័ អុះ លូ អូ ទី ពឿ អ្លុ ឡាច់ ឡឹង ហី ទី ដេល ហះកា ចារ សុនសាត អ៊ីស្រាអ៊ែល អ្វៃ ទី តាតារ។ ");
INSERT INTO tpu_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","កេះណោះ សាដាច់ អើ វគ័ ម៉ូសេ លូ រ៉ះ ផា «ហគ់ ប៉ាណាំ គួប អន់ដីស ឡាំ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ពិ។ អន់ដីស អ្យក់ ឡាំ ទឹប អង់កាន់ លូ សាស្វា កា ទី ដេល ហះកា តាប៉ល់ ចៀម លូ រ៉ក់ ម៉ះ អន់ដីស ត្រគ់ អ្លាត ពឹង ប៉ាថេត អា ហង»។ ");
INSERT INTO tpu_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","វគ័ ម៉ូសេ តើល ផា «ញឹន ត្រគ់ អ្យក់ ឡាំ ទឹប កាណាគ័ ទិណោ័ះ ហង ខង ញឹន ចឹង ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ដា អន់ដា ញឹន ចឹង ពុះ អ្លាត ទិ អន់ កា ប‌៉្រ័ះ ញឹន។ ");
INSERT INTO tpu_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ញឹន ត្រគ់ អ្យក់ ឡាំ កាណាគ័ ទិណោ័ះ ហង យ‌៉័ះ ម៉ោញ កាតុ កា អូ អ្លាត អុះ ខង ញឹន ចឹង ពុះ កាណាគ័ ណោះ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ដា។ ហះកា ញឹន បើ អ្លុ អន់តគ់ ផា ចឹង ត្រគ់ ពុះ កាណាគ័ បក់ អ៊ែ ចំ រ៉ាម៉ះ ប‌៉្រ័ះ អុះ ទឹល ប៉ាគ់ ណោះ ទៀ ញឹន ចឹង អ្លុ»។ ");
INSERT INTO tpu_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ កា សាដាច់ កាង័ កល់ អូ អន់ សុនសាត អ៊ីស្រាអ៊ែល ចាក ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","សាដាច់ កាប កា វគ័ ម៉ូសេ ផា «ចាក ឡាច់ ឡឹង អាញ់ ពិ ! ជែ វ៉ីល អន់ អាញ់ ប៉ប័ ម៉ាត់ អីស ណាវ្គ ដៃ ! ផា ដារ់ ចំ អីស វ៉ីល សឹត អន់ អាញ់ ប៉ប័ ម៉ាត់ អីស ណាវ្គ អីស ចឹង តោ័ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","វគ័ ម៉ូសេ តើល ផា «អីស រ៉ះ អា ត្រគ់ ហង អាញ់ អូ វ៉ីល ហៃ អីស ណាវ្គ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ហះកា ផះ អន់ទ្រួល ពែ ប‌៉្រ័ះ ប៊កកាតយ័ ទី រ៉ះ កា វគ័ ម៉ូសេ ផា «ម៉ោញ ទង អា អាញ់ ចឹង ប៉្រគ័ អន់ សាដាច់ លូ ប៉ាសុន អ៊ីស៊ីប ចឹង កើត សារ ចុនចៃ ខាក់។ ហ៊ូត អា អ៊ែ ចឹង អន់ អន់ដីស ចាក ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប អា តាទឹច ហង។ អូ ត្រគ់ ដឹង ចឹង អន់ អន់ដីស ចាក ឡាច់ ដោច អុះ ឃឺ អ៊ែ ចឹង ទ្រុះ តាំងហ្យិត ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","អ្យគ័ អីស រ៉ះ កា គន សោ អ៊ីស្រាអ៊ែល ទឹប កាម៉ាក័ ទឹប អង់កាន់ ប៉្រើ អន់ឌែ ប៉រ់ កាណាគ័ ម៉ាស កាណាគ័ ប៉្រាក់ ឡឹង សុនសាត អ៊ីស៊ីប ឡាក់ អ្វៃ ក្យាម័ អន់ឌូ លូ អន់ឌែ»។ ");
INSERT INTO tpu_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ កា មួត សុនសាត អ៊ីស៊ីប ប៉ិច ចៃ កា មួត អ៊ីស្រាអ៊ែល។ កាប៉ាច់ វគ័ ម៉ូសេ មួត ប៉ាសុន លូ មួត រ៉ាតីស អ៊ីស៊ីប អ្យិល កូត័ កា អ៊ែ ខាក់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","វគ័ ម៉ូសេ រ៉ះ កា សាដាច់ ផា «ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ផា ប៉ាគ់ ទឹល ទងតិគ័ ម៉ាំង អ៊ែ ចឹង ចាក តាត់ ប៉ាថេត អ៊ីស៊ីប អា។ ");
INSERT INTO tpu_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","គន ឡោងទ្រៀ សុនសាត អ៊ីស៊ីប ត្រគ់ តោ័ ទិ អ្យក់ ឡឹង គន កាម៉ាក័ ឡោងទ្រៀ សាដាច់ ឡាក់ អ្វៃ រ៉ាំងហៃ ប៉ាថេត អន់ ទឹល គន កាម៉ាក័ ឡោងទ្រៀ ទុច អង់កាន់ បក់ ប៉េះ ពៀ លូ គន ទោល ឡោងទ្រៀ កាណាគ័ ពូ រង ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","កាណុង ប៉ាថេត អ៊ីស៊ីប ចឹង កាតាំង ដឹង ពូ អង់ហ្យាំង ញ៉ាំ។ ឡឹង សើគ ឡឹង ពែ ពូ អូ ឃើយ កាតាំង នែវ អា អុះ ប៉ាគ់ ម៉ាត់ ទៀ កា អូ ទី នែវ អា ណាវ្គ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ហះកា កាណុង សុនសាត អ៊ីស្រាអ៊ែល អូ ទី កាតាំង ប៉ានឹរ ញ៉ា អុះ យ‌៉័ះ សូ កា អូ ក្វាល់ សាំ។ ណោះ ហង បះ អន់ដីស ចឹង អ្លុ អន់តគ់ ផា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ សុនសាត អ៊ីស្រាអ៊ែល យច ឡឹង សុនសាត អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","«ផះ ណោះ ទិ មួត រ៉ាតីស អន់ឌែ ចឹង ឡាំ ជន តាកុល សាំប‌៉័ះ អាញ់។ កេះណោះ អន់ឌែ ចឹង រ៉ះ កា អាញ់ ផា \"ហគ់ អីស លូ ប៉ាសុន អីស អន់ដីស ចាក ឡាំ ពិ\"។ ផះ ណោះ អាញ់ ចឹង ចាក ហង»។ វគ័ ម៉ូសេ ចាក ឡាច់ ឡឹង ចារ សាដាច់ ទឹប ប៉ិច អឺក ");
INSERT INTO tpu_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","ត្រគ់ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ពែ ហង ផា «សាដាច់ ចឹង អូ សាំយ៉ាំង អីស អុះ ម៉ាគ់ អាញ់ ចឹង តាំបាង សារ អំរ៉ាញ អឺញ កេង ខាក់ ហ៊ែង អៀង ៗ ពឹង ប៉ាថេត អ៊ីស៊ីប អា»។ ");
INSERT INTO tpu_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន តាំបាង សារ អំរ៉ាញ អឺញ កេង ខាក់ អា ហះ ម៉ាត់ សាដាច់ ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ សាដាច់ កាង័ កល់ អូ អន់ គន សោ អ៊ីស្រាអ៊ែល ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ពឹង ប៉ាថេត អ៊ីស៊ីប ផា ");
INSERT INTO tpu_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«អន់ដីស ត្រគ់ យ៉ាប ខៃ អា ឃឺ ខៃ ទី ម៉ោញ តើម សាណាំ សាំរ៉ាប់ អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ហគ់ អន់ដីស រ៉ះ កា មួត អ៊ីស្រាអ៊ែល កាណុង ខៃ អា ប៉ាគ់ ដារ់ ទី ១០ ទៀ កាណុង ម៉ោញ ហី លើ ម៉ោញ ខាប់ខួ ត្រគ់ អ្យក់ គន ប៉ារ់ពេ លើ គន ចៀម ម៉ោញ សាំរ៉ាប់ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ផា ខាប់ខួ ចំ ប៊ែត ដូវ តាឡាម័ សា ចៀម អូ អ្លុ ប៉្រគ័ ទិ ដឹង អន់ឌែ ត្រគ់ អន់ អន់ឌែ ម៉ុត អន់ឌូ លូ ខាប់ខួ ពូ ឡាក់ អ្វៃ ហី ក្យាម័ គួប សោប កេះណោះ ត្រគ់ យ៉ាប ចំលួន ប៉ាណូស ឡាក់ ចឹង ត្រគ់ សា ចៀម ម៉ោញ អន់ ទិ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","អន់ឌែ ត្រគ់ អ្យក់ គន ចៀម ទោល លើ គន ប៉ារ់ពេ ទោល ឡាក់ ដាគ់ កាខាក់ តីស តង់ អូ ទី ឡាកា ឡាកាច់ អេះ អោម ញ៉ា អុះ ឡាក់ ទី អាញុ ម៉ោញ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ត្រគ់ គម គន ចៀម ណោះ អន់ ទឹល ដារ់ ទី ១៤ កាណុង ខៃ អា ប៉ាគ់ ដារ់ ម៉ុត ម៉ាំង យ៉ោម សាយ៉ោម កេះ មួត អ៊ីស្រាអ៊ែល ត្រគ់ សាក អង់កូ ចៀម។ ");
INSERT INTO tpu_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","កេះណោះ អ្យក់ ផាម ឡាប ពឹង អ៊្លង អ៊ប អំប៉ារ ទិ ពៀរ ប៊ែង លូ គែង អំប៉ាំង អន់ដា ពឹង ហី អន់ឌែ អ្វៃ សា ចៀម ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ចៀម ណោះ អន់ឌែ ត្រគ់ តាអាំង អន់ សឹន កេះណោះ សា ម៉ាំង ណោះ ហង។ ត្រគ់ សា លូ ណុំ ប៉ាំង ឡាតាំង លូ សាណា តាំង។ ");
INSERT INTO tpu_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","ចៀម ណោះ ជែ អន់ អន់ឌែ សា អន់ទ្រិះ ត្រគ់ តាអាំង ទឹប កាតុ នីណោ័ះ ហង អូ ឡះ អូ រ៉ាឡៃ អុះ លូ ជែ សា សាន់តុក។ ");
INSERT INTO tpu_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ត្រគ់ សា អន់ ទិ ម៉ាំង ទៅ ឡូត ផា សា អូ ទិ ត្រគ់ ប៉ាតុំ ពុះ អ្លាត ទិ ពឹង អុញ ជែ អន់ សល់ កាណាគ័ ញ៉ា ទឹល ដារ់ តាយ៉ាង័ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","ប៉ាគ់ សា ទៀ ត្រគ់ ប៉្រគ័ នីអៀ ត្រគ់ រឹត សាំងគៀង លូ ជិះ កឺប ចឹក អ៊្លង ពឹង តី លូ សា អន់ ប៉្រាល់ៗ ខង អា ឃឺ ប៊ុន ទ្រួង កោះ ចៀម រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","«ម៉ាំង ណោះ អាញ់ ចឹង ចាក តាត់ ប៉ាថេត អ៊ីស៊ីប លូ ប៉ាន់តោ័ ទិ គន កាម៉ាក័ ឡោងទ្រៀ សុនសាត អ៊ីស៊ីប ទឹប គន ប៉ាណូស ទឹប គន កាណាគ័ អន់ឌែ រង។ អាញ់ ហង ប‌៉្រ័ះ ប៊កកាតយ័  អាញ់ ចឹង ចៃគ ថូត មួត ប‌៉្រ័ះ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","ហះកា ផាម ឡាក់ អន់ដីស ឡាប ពឹង អ៊្លង អ៊ប អំប៉ារ ហី ណោះ ចឹង ប៉្រគ័ សាញ៉ា អន់ អ្លុ អន់តគ់ ផា អន់ដីស អ្វៃ កាណុង ហី ណោះ។ ផះ អាញ់ ចាក ប៉ាន់តោ័ គន ឡោងទ្រៀ មួត អ៊ីស៊ីប ហី ចំ អាញ់ ប៉ប័ ទី ផាម ហី ណោះ អាញ់ ចឹង ចាក ទ្រួង ម៉ាគ់ អន់ដីស ចឹង រ៉ាវ៉ាច់ ឡឹង សារ តោ័ អា។ ");
INSERT INTO tpu_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","អន់ដីស ត្រគ់ អ្យក់ ដារ់ អា ប៉្រគ័ ប៊ុន កាចាំង ឡឹង សារ ឡាក់ កើត ពឹះ ពឹង ប៉ាថេត អ៊ីស៊ីប ភឿ អន់ អន់ដីស ប៉ានេ អាញ់។ សារ អា អន់ដីស ត្រគ់ ប៉្រគ័ លើយ រ៉ប់ សាណាំ គ្រឹប រ៉ាំងហាវ អូ ត្រគ់ អ្លាត អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","«កាណុង រ៉ាំងវ៉ាង តាំប៉ើះ ដារ់ អន់ដីស ត្រគ់ សា ដឹង ណុំ ប៉ាំង ឡាតាំង ឡឹង ដារ់ ទី ម៉ោញ អន់ដីស ត្រគ់ អ្យក់ ឡាច់ ពុះ សាំរ៉ាប់ ប៉្រគ័ ណុំ ប៉ាំង ឡឹង ហី អន់ដីស កោ័ះ អ្លាត អន់ ទិ។ ពឿ សា ណុំ ប៉ាំង កាពុល ឡឹង ដារ់ ទី ម៉ោញ ទឹល ដារ់ ទី តាំប៉ើះ ប៉ាណូស ណោះ ត្រគ់ តាំងហ្យិត ឡាច់ ឡឹង សុនសាត អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","កាណុង ដារ់ ទី ម៉ោញ លូ ដារ់ ទី តាំប៉ើះ អន់ដីស ត្រគ់ ប៉ាតុំ គួប សោប លួម ប៉ានេ អាញ់ រ៉ាំងវ៉ាង ពៀរ ដារ់ ណោះ អន់ដីស អូ ត្រគ់ ប៉្រគ័ ង៉ារ ញ៉ា អុះ ប៉្រគ័ ដឹង សាណា សា បគ័ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","អន់ដីស ត្រគ់ ប៉្រគ័ ប៊ុន ណុំ ប៉ាំង ឡាតាំង អា លើយ ខង ដារ់ អា ហង អាញ់ ប៉ាណាំ អន់ដីស ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ចាក ប៉ិន តាប៉ល់។ អន់ដីស ត្រគ់ អ្យក់ ដារ់ អា ប៉្រគ័ ចាបាប់ សាំរ៉ាប់ អន់ដីស ត្រគ់ ប៉្រគ័ លើយ អូ អ្លាត អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","កាណុង ខៃ ១ អ្យក់ ឡឹង កាង៉ាច ដារ់ ទី ១៤ ទឹល កាង៉ាច ដារ់ ទី ២១ អន់ដីស ត្រគ់ សា ដឹង ណុំ ប៉ាំង ឡាតាំង ជែ សា ណុំ ប៉ាំង កាពុល។ ");
INSERT INTO tpu_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","កាណុង រ៉ាំងវ៉ាង តាំប៉ើះ ដារ់ ណោះ អូ អន់ ទី ពុះ សាំរ៉ាប់ ប៉្រគ័ ណុំ ប៉ាំង អ្វៃ កាណុង ហី អន់ដីស អុះ។ ពឿ សា ណុំ ប៉ាំង ចៃគ ពុះ អន់ដីស ត្រគ់ តាំងហ្យិត ឡាច់ ឡឹង សុនសាត អ៊ីស្រាអ៊ែល អូ ផា កា មួត អំហ៊្មយ អូ ផា កា ប៉ាណូស ស្រុក ទៅ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","អន់ដីស អ្វៃ ប៉ាគ់ ចារ ចំ កាតាម ជែ សា ណុំ ប៉ាំង ចៃគ ពុះ ត្រគ់ សា ដឹង ណុំ ប៉ាំង អូ ចៃគ ពុះ ណោះ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","កេះណោះ វគ័ ម៉ូសេ អើ មួត ក្រាគ់ តាំងកង់ សុនសាត អ៊ីស្រាអ៊ែល លូ រ៉ះ ផា «ហគ់ ឡាំ អ្យក់ គន ចៀម សាំរ៉ាប់ ខាប់ខួ អន់ដីស ប៉ាន់តោ័ ប៉្រគ័ ប៊ុន ទ្រួង។ ");
INSERT INTO tpu_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","អន់ដីស ត្រគ់ អ្យក់ តាំងកង់ អ្យិត ម៉ោញ រ៉ាំងអ៊្យែ ឡុក ពឹង ផាម ចៀម ឡាក់ ចៃគ ពឹង គូម កេះណោះ ឡាប ពឹង អ៊្លង អ៊ប អំប៉ារ ហី ទិ ពៀរ ប៊ែង លូ គែង អំប៉ាំង ដេល។ អន់ដីស ត្រគ់ អ្វៃ កាណុង ហី ណោះ លើយ ទឹល កាំលឺ អូ អន់ ពឿ ឡាច់ ប៉ាគ់ ឡីង អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","ប៉ាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ ចាក ប៉ាន់តោ័ គន ឡោងទ្រៀ សុនសាត អ៊ីស៊ីប ទៀ ផា អ៊ែ ហៃ ប៉ប័ ផាម ឡាប ពឹង អ៊្លង អ៊ប អំប៉ារ ហី ទិ ពៀរ ប៊ែង លូ គែង អំប៉ាំង អ៊ែ ចឹង ចាក ទ្រួង ហី អន់ដីស អ្វៃ ណោះ អ៊ែ អូ អន់ ប៊យ បក់ ចាក ថាំឡាយ ម៉ុត ប៉ាន់តោ័ អន់ដីស អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","អន់ដីស លូ គន សោ អន់ដីស ត្រគ់ ប៉្រគ័ ពួយ សារ អា លើយ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","ប៉ាគ់ អន់ដីស ម៉ុត ពឹង ប៉ាថេត ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ សាញ៉ា ផា អន់ កា អន់ដីស ពែ អន់ដីស ត្រគ់ ប៉្រគ័ ប៊ុន អា ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","ផា គន សោ អន់ដីស អំប៉ញ់ ផា \"ញ៉ា ត្រគ់ ពូ ប៉្រគ័ ប៊ុន អា ?\" ");
INSERT INTO tpu_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","អន់ដីស ត្រគ់ រ៉ះ កា អន់ឌែ ផា \"អា ប៊ុន ទ្រួង កោះ ចៀម រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ផះ ពិន អ្វៃ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ពែ អ៊ែ ប៉ាន់តោ័ សុនសាត អ៊ីស៊ីប ហះកា ហី សុនសាត ពិន អ៊ែ ទ្រួង អូ ប៉ាន់តោ័ អុះ គម អន់ ពិន អ្វៃ រ៉ីស\"»។ ណោះ ហង បះ កាំឡាំង ប៉ាណាំ គួប មូប កល់ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","សុនសាត អ៊ីស្រាអ៊ែល កា ប៉ាណាំ គួប ប៉្រគ័ ពួយ ទិ សារ ប‌៉្រ័ះ ប៊កកាតយ័ អន់តគ់ រ៉ះ ពឹង វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ណោះ តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ប៉ាគ់ ទឹល ទងតិគ័ ម៉ាំង ប‌៉្រ័ះ ប៊កកាតយ័ ចាក ប៉ាន់តោ័ គន ឡោងទ្រៀ មួត សុនសាត អ៊ីស៊ីប ទិណោ័ះ ឡឹង គន ឡោងទ្រៀ សាដាច់ ឡាក់ អ្វៃ រ៉ាំងហៃ ប៉ាថេត ទឹល គន មួត ត្រគ់ ខុក ទឹប គន កាណាគ័ ពូ រង ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ម៉ាំង ណោះ សាដាច់ លូ មួត រ៉ាតីស លូ សុនសាត អ៊ីស៊ីប អ្យូវ អង់ហ្យាំង ញ៉ាំ រ៉ាវ៉ើក ថើក ទិឌូ យឹង ទឹប ប៉ាថេត អ៊ីស៊ីប ខង គ្រឹប ហី ទី ប៉ាណូស តោ័។ ");
INSERT INTO tpu_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","សាដាច់ កា អើ វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ទឹប កាម៉ាំង ណោះ ហង កេះណោះ រ៉ះ ផា «អន់ដីស ប៉ាណាំ សុនសាត អ៊ីស្រាអ៊ែល ឡាច់ ឡឹង ប៉ាថេត អាញ់ អា កិញអៀ ហង រិញ ! លូ ប៉ាណាំ គួប អន់ដីស ឡាំ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ឡាក់ កា អន់ដីស ប៉រ់ ពែ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","អ្យក់ ឡាំ ទឹប ប៉ារ់ពេ ទឹប ចៀម ទឹប រ៉ក់ ឡាក់ អន់ដីស ប៉រ់ ពែ ហង ពិ កេះណោះ អីស ប៉រ់ សារ ដាគ់ កា អាញ់ ណើ»។ ");
INSERT INTO tpu_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","មួត សុនសាត អ៊ីស៊ីប សាម៉គ័ កា អន់ឌែ ចឹង តោ័ ទិឌូ ណោះ ហង បះ អន់ឌែ ប៉ាំងខំ អន់ មួត អ៊ីស្រាអ៊ែល ចាក ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ស៊្រសៗ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ខ អា ហង បះ សុនសាត អ៊ីស្រាអ៊ែល អ្យក់ តាប៉ុង ប៉្រគ័ ណុំ ប៉ាំង ត្រាំ កេះ ហះកា បើ តាន័ ចៃគ ពុះ កាតូត័ ទឹប កាបឺង ពឹង អាវ កេះណោះ គយ ចាក ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","សុនសាត អ៊ីស្រាអ៊ែល កា ប៉្រគ័ ពួយ សារ វគ័ ម៉ូសេ អន់តគ់ រ៉ះ កា អន់ឌែ ឃឺ ប៉រ់ ម៉ាស ប៉្រាក់ លូ ខោ អាវ ឡឹង មួត អ៊ីស៊ីប ឡាក់ អ្វៃ ហី ក្យាម័ លូ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ មួត សុនសាត អ៊ីស៊ីប ដាគ់ ពុត កា សុនសាត អ៊ីស្រាអ៊ែល លូ អន់ កាណាគ័ ញ៉ា ឡាក់ អ៊ីស្រាអ៊ែល ប៉រ់ ឡឹង អន់ឌែ។ ណោះ ហង បះ វ៉ឹច លូ សុនសាត អ៊ីស្រាអ៊ែល រ៉ាត អ្យក់ ទិ រ៉ាស អំប៉ាស មួត សុនសាត អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","កាំឡាំង សុនសាត អ៊ីស្រាអ៊ែល ចាក ឡាច់ ឡឹង មឿង រ៉ាមសេ ឡាំ ប៉ាគ់ ស្រុក ស៊ុកូត ណោះ ឃឺ អ៊ែ ត្រោ ស៊ែន ដូវ មួត សាស្វា មួត អង់កាន់ អូ យ៉ាប សាំ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ទី ប៉ាសុន អន់ទៀគ ណាវ្គ តុត អៀង ដេល ចាក អន់ឌូ លូ អន់ឌែ តាប៉ល់ ប៉ារ់ពេ តាប៉ល់ ចៀម តាប៉ល់ រ៉ក់ កា អៀង និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","អន់ឌែ ប៉្រគ័ ណុំ ប៉ាំង ឡាតាំង លូ តាប៉ុង បើ តាន័ ចៃគ ពុះ ឡាក់ អន់ឌែ អ្យក់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ពែ ហង ខង មួត សុនសាត អ៊ីស៊ីប ទ្រុះ អន់ឌែ អន់ ឡាច់ ស៊្រសៗ អូ តាន័ ទ្រៀម សាប្យាំង សាំរ៉ាប់ សា រទ្រង អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","សុនសាត អ៊ីស្រាអ៊ែល អ្វៃ ពឹង ប៉ាថេត អ៊ីស៊ីប ទុញ ៤៣០ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","រ៉ាវ៉ាច់ ឡឹង ៤៣០ សាណាំ កេះ ប៉ាគ់ ទឹល ដារ់ កាំឡត់ ប៉ាសុន ប‌៉្រ័ះ ប៊កកាតយ័ ទិឌូ ប៉ាណាំ គួប ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ប៉ិន តាប៉ល់ ៗ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ម៉ាំង ណោះ ហង ប‌៉្រ័ះ ប៊កកាតយ័ ញ៉ាម អន់ឌែ លូ ប៉ាណាំ អន់ឌែ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ណោះ ហង បះ រ៉ប់ សាណាំ ម៉ាំង ណោះ សុនសាត អ៊ីស្រាអ៊ែល ទិឌូ ត្រគ់ កាចាំង គ្រឹប រ៉ាំងហាវ លើយ លូ ប៉ានេ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ផា «ប៊ុន ទ្រួង អា ត្រគ់ ប៉្រគ័ នីអៀ មួត អំហ៊្មយ ឡឹង ប៉ាថេត អន់ទៀគ ត្រគ់ កំ អូ អន់ ម៉ុត សា សាណា ប៊ុន អា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ហះកា មួត ទុច អន់ដីស ឡាក់ សុនសាត អន់ទៀគ ណោះ អន់ឌែ សា សាណា ប៊ុន អា ទី និះទៅ ដេល ផា អន់ដីស កាសិត អង់ការ កា អន់ឌែ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","សុនសាត អន់ទៀគ ឡាក់ អ្វៃ អង់រ៉ាម័ លូ អន់ដីស លើ មួត អំហ៊្មយ ឡឹង ប៉ាថេត អន់ទៀគ ឡាក់ អ្វៃ ប៉្រគ័ គូលី អន់ដីស ត្រគ់ កំ អូ អន់ សា សាណា ប៊ុន អា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","អន់ដីស ត្រគ់ អ្វៃ សា ចៀម កាណុង ហី អូ អន់ អ្យក់ ឡាច់ ប៉ាំងឡៃ ចៀម ណោះ គែង ឡីង អុះ លូ ជែ គុ តាគ់ អំប៉ាក់ កាន់តីង ចៀម ណោះ ដៃ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ ត្រគ់ ប៉្រគ័ ប៊ុន អា។ ");
INSERT INTO tpu_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","ផា មួត អំហ៊្មយ ឡឹង ប៉ាថេត អន់ទៀគ អ្វៃ អន់ឌូ លូ អន់ដីស ផា អន់ឌែ ប៉ិច ម៉ុត ប៉្រគ័ ប៊ុន ទ្រួង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ឌូ លូ អន់ដីស ដេល ត្រគ់ ប៉្រើ មួត កាម៉ាក័ៗ អន់ឌែ ណោះ កាសិត អង់ការ កាហិ។ កេះណោះ អន់ឌែ ចឹង ទី ម៉ុត ប៉្រគ័ ប៊ុន ឡាក់ កា តាំងឡា ស្រុក ដេល។ បក់ អ៊ែ ចំ អូ កាសិត អង់ការ អូ អន់ ម៉ុត សា សាណា ប៊ុន ទ្រួង អា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ទី ចាបាប់ ដឹង ម៉ោញ សាំរ៉ាប់ កា សុនសាត អ៊ីស្រាអ៊ែល លូ មួត អំហ៊្មយ ឡឹង ប៉ាថេត អន់ទៀគ ឡាក់ អ្វៃ អន់ឌូ លូ អន់ដីស»។ ");
INSERT INTO tpu_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","សុនសាត អ៊ីស្រាអ៊ែល ទិឌូ ប៉្រគ័ ពួយ សារ ប‌៉្រ័ះ ប៊កកាតយ័ អន់តគ់ រ៉ះ ពឹង វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន។ ");
INSERT INTO tpu_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ពឹង ដារ់ ណោះ ហង ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាណាំ សុនសាត អ៊ីស្រាអ៊ែល ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ប៉ិន តាប៉ល់។ ");
INSERT INTO tpu_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ផះ សាដាច់ អ៊ីស៊ីប អន់ ប៉ាសុន អ៊ីស្រាអ៊ែល ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ អូ ទី ប៉ាណាំ ទ្រង អន់ឌែ ឡាំ តាត់ ប៉ាថេត ភីលីសាទីន អុះ យ‌៉័ះ ទ្រង ណោះ ក្យាម័ កាតាម ខង អ៊ែ អ្លុ អន់តគ់ ផា ចឹង ទី ពូ តាកូះ លូ អន់ឌែ ប៉្រគ័ អន់ អន់ឌែ ចឹង ទី ពុត ពៀក ប៉ិច វ៉ីល សឹត ប៉ាគ់ អ៊ីស៊ីប ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ញន ខ អា ហង បះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាណាំ អន់ឌែ ចាក យ៉្វារ តាត់ ស៊្រែ តីស អន់ ឡាំ ប៉ាគ់ ទៀក តាំងលេ តីស ស៊ូប។ សុនសាត អ៊ីស្រាអ៊ែល ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ណោះ ចឹក ឃឿង តាកូះ ប្ល‌៉័ះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","កាន់តីង ប៉ាទ្រូ យូស៊ែប កា វគ័ ម៉ូសេ អ្យក់ សឹត ដេល ខង យូស៊ែប រ៉ះ កា គន សោ អ៊ីស្រាអ៊ែល សើគ ពែ ផា «ប៉រ់ អន់ដីស ម៉ត់ លូ អាញ់ ខង ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ជឹរ តង័ អន់ដីស ហង ប៉ាគ់ អន់ដីស ឡាច់ ឡឹង អា ទៀ អន់ដីស អ្យក់ សឹត ទឹប កាន់តីង អាញ់ ណើ»។ ");
INSERT INTO tpu_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","សុនសាត អ៊ីស្រាអ៊ែល ចាក ឡឹង ស្រុក ស៊ុកូត ឡាំ ប៉្រគ័ រ៉ាណើះ អ្វៃ ត្រង់ ហះ ស្រុក អេថាម ក្យាម័ ហះ អន់ទ្រឹល ស៊្រែ តីស។ ");
INSERT INTO tpu_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","ផះ កាដារ់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាណាំ ទ្រង អន់ឌែ លូ កាម៉ល់ ប៉ាគ់ កាម៉ាំង អ៊ែ ប៉ាណាំ ទ្រង លូ អុញ តាគ់ តាតារ អន់ឌែ នីណោ័ះ ហង បះ កាដារ់ កា ចាក កាម៉ាំង កា ចាក។ ");
INSERT INTO tpu_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ផះ កាដារ់ កាម៉ល់ អូ ក្លះ ឡឹង អន់ឌែ អុះ ទឹល កាម៉ាំង ទី អុញ អ្វៃ ប៉ាគ់ ម៉ាត់ អន់ឌែ លើយ។ ");
INSERT INTO tpu_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា ");
INSERT INTO tpu_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«ហគ់ អីស រ៉ះ កា ប៉ាសុន អ៊ីស្រាអ៊ែល អន់ វ៉ីល ប៉្រគ័ រ៉ាណើះ ហះ សានែង ចារ ពីហាហ៊ីរ៉ុត ហះ អន់តិគ័ ចារ មីកដូល លូ តាំងលេ តីស។ អន់ដីស ត្រគ់ ប៉្រគ័ រ៉ាណើះ អ្វៃ រហាង តាំងលេ តីស ត្រង់ ហះ ង៉ីរ ចារ បាលសេផុន។ ");
INSERT INTO tpu_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ណោះ ហង បះ សាដាច់ អ៊ីស៊ីប ចឹង ឃឹត ផា \"មួត អ៊ីស្រាអ៊ែល ហ្យើត វ៉ឹល វ៉ើង រចារ អា ហង អន់ឌែ ចាក អូ រ៉ាវ៉ាច់ ឡឹង ស៊្រែ តីស ណោះ អុះ\"។ ");
INSERT INTO tpu_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","អាញ់ ចឹង ប៉្រគ័ អន់ កា សាដាច់ កាង័ កល់ កេះណោះ អ៊ែ ចឹង តាយ៉ិប ពួយ អន់ដីស ហះកា អាញ់ ចឹង តាកូះ លូ អ៊ែ លូ តាហាន អ៊ែ ទិណោ័ះ ចឹង ទី ទ្រង អាញ់ ម៉ាគ់ សុនសាត អ៊ីស៊ីប ចឹង អ្លុ អន់តគ់ ផា អាញ់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ តាទឹច ហង»។ សុនសាត អ៊ីស្រាអ៊ែល ប៉្រគ័ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ទី ពូ ឡាំ រ៉ះ កា សាដាច់ ផា សុនសាត អ៊ីស្រាអ៊ែល ប៉ាណាំ គួប ឡាច់ ចាក ទិ កេះ កេះណោះ សាដាច់ លូ មួត រ៉ាតីស ប៉ាង៉ាច់ អូ អន់ អ៊ីស្រាអ៊ែល ចាក ឡាច់ ណាវ្គ។ អន់ឌែ កា កាប ផា «ញ៉ា ត្រគ់ ពិន អន់ អ៊ីស្រាអ៊ែល ឡាច់ ចាក នីអៀ ? ទី ពឿ ចឹង ប៉្រគ័ ទុច ពិន ណាវ្គ ?» ");
INSERT INTO tpu_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","សាដាច់ ប៉្រើ ពូ ចៃគ រ៉ាតេ័ះ តាកូះ កា អ៊ែ កេះណោះ ជៀក តាហាន ឡាំ អន់ឌូ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","រ៉ាតេ័ះ តាកូះ ពឹង ប៉ាថេត អ៊ីស៊ីប សាដាច់ អ្យក់ ឡាំ ទិ រ៉ាតេ័ះ កាចាប័ៗ ទី ៦០០ កល់ ទឹប ទី ម៉ៃគ តាហាន ជិះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ កា សាដាច់ អ៊ីស៊ីប កាង័ កល់ លូ តាយ៉ិប ពួយ សុនសាត អ៊ីស្រាអ៊ែល។ ហះកា សុនសាត អ៊ីស្រាអ៊ែល ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ទឹប ទី ពុត ខឹន។ ");
INSERT INTO tpu_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ទិ តាហាន ពឹង ប៉ាថេត អ៊ីស៊ីប ទឹប តាហាន ជិះ សេះ លូ តាហាន ជិះ រ៉ាតេ័ះ លូ តាហាន ចាក ជុង ប៉ាណាំ គួប តាយ៉ិប ពួយ សុនសាត អ៊ីស្រាអ៊ែល ផាឌី តាន័ ហះ ចារ ពីហាហ៊ីរ៉ុត ត្រង់ ហះ ម៉ាត់ ចារ បាលសេផុន ឡាក់ ចារ អន់ឌែ ប៉្រគ័ រ៉ាណើះ អ្វៃ រហាង តាំងលេ តីស ស៊ូប ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ផះ អន់ឌែ ប៉ប័ កាំឡាំង សាដាច់ ឡាំ ក្យាម័ តាយ៉ិប ពួយ ទ្រង ប៉ាអច់ សុនសាត អ៊ីស្រាអ៊ែល អ្យូគ កាខរ់ ណូស ខាក់ អន់ឌែ អង់ហ្យាំង ណាំង ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","អន់ឌែ កាប កា វគ័ ម៉ូសេ ផា «នីចម័ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប អូ ទី ចារ តប់ ប៉ាទ្រូ ប បះ អីស ប៉ាណាំ ញឹន អន់ ឡាំ តោ័ ពឹង ស៊្រែ តីស នីអៀ ? ខ ញ៉ា បះ អីស ប៉ាណាំ ញឹន ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ? ");
INSERT INTO tpu_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ផះ អ្វៃ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ពែ ញឹន រ៉ះ កា អីស ផា \"អន់ ញឹន អ្វៃ ប៉្រគ័ ទុច សុនសាត អ៊ីស៊ីប ហះ អា ហង ពិ\"។ ផា ញឹន អ្វៃ ប៉្រគ័ ទុច ពូ ដាគ់ ហ៊្លត ឡឹង ឡាំ តោ័ ពឹង ស៊្រែ តីស នែវ អា»។ ");
INSERT INTO tpu_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","វគ័ ម៉ូសេ តើល អន់ឌែ ផា «អន់ដីស ជែ អ្យូគ ជែ សាតាក់ ! ក្យាគ់ ហៃ ដារ់ អា ហង អន់ដីស ចឹង ប៉ប័ ប‌៉្រ័ះ ប៊កកាតយ័ តង័ អន់ដីស។ សុនសាត អ៊ីស៊ីប ឡាក់ អន់ដីស ប៉ប័ ដារ់ អា បាប៊ែត ណាវ្គ អន់ដីស ចឹង អូ ប៉ប័ អន់ឌែ លើយ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","អន់ដីស អ្វៃ គ្រឺយ ពិ ខង ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង តាកូះ ប៉ាតាង អន់ដីស»។ ");
INSERT INTO tpu_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ញ៉ា ត្រគ់ អង់ហ្យាំង ណាំង អាញ់ នីអៀ ? ហគ់ រ៉ះ កា គន សោ អ៊ីស្រាអ៊ែល រ៉ើ រ៉ាណើះ ចាក ប៉ាគ់ ម៉ាត់ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ហគ់ អីស លឺក អ៊្លង កាទូង អីស ណោះ ពឹង ចាំងហីគ លូ សាំប្លោ គែង តាំងលេ តីស អន់ ទៀក ខ្លាក ឡាច់ ឡឹង គួប អ៊ែ ភឿ អន់ គន សោ អ៊ីស្រាអ៊ែល ចាក ទ្រង ឡាអារ ទៀក។ ");
INSERT INTO tpu_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","អាញ់ ចឹង ប៉្រគ័ អន់ សុនសាត អ៊ីស៊ីប កាង័ កល់ ម៉ាគ់ អន់ឌែ ចឹង ម៉ុត តាយ៉ិប ពួយ អន់ដីស អាញ់ ចឹង តាកូះ លូ សាដាច់ អ៊ីស៊ីប លូ តាហាន ជិះ សេះ ជិះ រ៉ាតេ័ះ លូ តាហាន ចាក ជុង អ៊ែ ចឹង ចាយ័ ទ្រង អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ផះ ណោះ សុនសាត អ៊ីស៊ីប ចឹង អ្លុ អន់តគ់ ផា អាញ់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ តាទឹច ហង»។ ");
INSERT INTO tpu_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ប៊យ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ អ្វៃ គែង ម៉ាត់ មួត អ៊ីស្រាអ៊ែល ពែ ឡាំ អ្វៃ គែង អង់កក់ អន់ឌែ ឡគ កាម៉ល់ ឡាក់ ប៉ាណាំ ទ្រង ពែ កា អ្វៃ គែង អង់កក់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","អ៊ែ អ្វៃ ហះ អន់តិគ័ អំពុន តាហាន អ៊ីស៊ីប លូ តាហាន អ៊ីស្រាអ៊ែល។ ប៉ាគ់ កាម៉ាំង កាម៉ល់ ណោះ ប៉្រគ័ អន់ ម៉ាម៉ាំង គែង មួត តាហាន អ៊ីស៊ីប ហះកា គែង មួត តាហាន អ៊ីស្រាអ៊ែល កាម៉ល់ ប៉្រគ័ អន់ តាតារ។ ខ ណោះ ហង បះ មួត តាហាន ទិ ពៀរ ប៊ែង អូ ទី ម៉ុត ក្យាម័ គួប សោប អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","កេះណោះ វគ័ ម៉ូសេ លឺក តី សាំប្លោ ទៀក តាំងលេ តីស ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉្រគ័ អន់ ទី ខ្យាល តីស ពឹះ ឡឹង ដារ់ ឡាច់ តឹ ត្រុត ទៀក តាំងលេ តីស ទឹល តារ លូ ប៉្រគ័ អន់ ទៀក ខ្លាក ឡាច់ ឡឹង គួប អ៊ែ លូ ស្វាត់ ក្រើង។ ");
INSERT INTO tpu_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","កេះណោះ សុនសាត អ៊ីស្រាអ៊ែល ប៉ាណាំ គួប ចាក ទ្រង ឡាអារ ទៀក ស្វាត់ ណោះ ហង លូ ទី ទៀក តាំងលេ តីស អ្វៃ គែង សាំងអ្យោ គែង សាម៉ា អន់ឌែ ឡាក់ កា រ៉ាំប៊ង។ ");
INSERT INTO tpu_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","តាហាន អ៊ីស៊ីប ទិណោ័ះ ទឹប រ៉ាតេ័ះ ទឹប សេះ ម៉ះ សាដាច់ កា តាយ៉ិប ម៉ុត ពួយ អ៊ីស្រាអ៊ែល ទឹល ប៉ាគ់ អន់តិគ័ ទៀក តាំងលេ តីស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ប៉ាគ់ ក្យាម័ ប៉ាតារ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ អ្វៃ ពឹង អុញ លូ ពឹង កាម៉ល់ អ៊ែ ហៃ គែង តាហាន អ៊ីស៊ីប លូ ប៉្រគ័ អន់ កា អន់ឌែ ទី សារ វ៉ឹនវ៉ាយ កាដុក កាដុល។ ");
INSERT INTO tpu_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","អ៊ែ ប៉្រគ័ អន់ កា រ៉ាតេ័ះ តាកូះ តាប៉្លុច កុង អូ អ្លុ ចាក។ តាហាន អ៊ីស៊ីប កា អង់ហ្យាំង ផា «ពិ ពិន សាតាក់ ឡាច់ អន់ ចាំងហាយ្គ ឡឹង សុនសាត អ៊ីស្រាអ៊ែល អា ខង ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ អន់ឌូ លូ អន់ឌែ តាកូះ លូ ពិន»។ ");
INSERT INTO tpu_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «អីស លឺក តី សាំប្លោ គែង ទៀក តាំងលេ តីស ណាវ្គ ពិ ភឿ អន់ ទៀក កាត្រោប តាហាន អ៊ីស៊ីប ទឹប រ៉ាតេ័ះ ទឹប សេះ ឡូត»។ ");
INSERT INTO tpu_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","វគ័ ម៉ូសេ កា លឺក តី សាំប្លោ គែង ទៀក តាំងលេ តីស ប៉ាគ់ ទឹល ដារ់ ឡាច់ ទៀក តាំងលេ តីស ហូរ័ សឹត ចារ ទៅ ណាវ្គ។ តាហាន អ៊ីស៊ីប ប៉ាណាំ គួប សាតាក់ ឡាច់ ហះកា អន់ឌែ សាតាក់ អូ រ៉ាវ៉ាច់ អុះ។ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ អន់ឌែ តោ័ ឡង់ ពឹង អន់តិគ័ ទៀក ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","ទៀក តាំងលេ តីស កា ហូរ័ កាត្រោប តាហាន អ៊ីស៊ីប ទិ ទឹប រ៉ាតេ័ះ ទឹប សេះ លូ តាហាន សាដាច់ ឡាក់ តាយ៉ិប ពួយ សុនសាត អ៊ីស្រាអ៊ែល ណោះ អន់ឌែ តោ័ ទិ អូ ទី ពឿ សាតាក់ រ៉ាវ៉ាច់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","កាប៉ាច់ មួត អ៊ីស្រាអ៊ែល ចាក ទ្រង ឡាអារ ទៀក ស្វាត់ ណោះ ដាគ់ សាំបាយ លូ ទី ទៀក តាំងលេ តីស អ្វៃ គែង សាំងអ្យោ គែង សាម៉ា អន់ឌែ ឡាក់ កា រ៉ាំប៊ង។ ");
INSERT INTO tpu_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ដារ់ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ តង័ សុនសាត អ៊ីស្រាអ៊ែល អន់ រ៉ាវ៉ាច់ ឡឹង តី មួត អ៊ីស៊ីប។ សុនសាត អ៊ីស្រាអ៊ែល ប៉ប័ ប៉ាទ្រូ តាហាន អ៊ីស៊ីប រហាង តាំងលេ។ ");
INSERT INTO tpu_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","សុនសាត អ៊ីស្រាអ៊ែល ប៉ប័ សារ អំរ៉ាញ អឺញ កេង ខាក់ ម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាន់តោ័ សុនសាត អ៊ីស៊ីប។ ខ អា ហង បះ ប៉ាសុន អ៊ីស្រាអ៊ែល អ្យូគ កា អ៊ែ ខាក់។ អន់ឌែ សឿ ប‌៉្រ័ះ លូ សឿ វគ័ ម៉ូសេ ឡាក់ ប៉ាណូស ប៉្រគ័ ង៉ារ ប‌៉្រ័ះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","កេះណោះ វគ័ ម៉ូសេ ប៉ាណាំ សុនសាត អ៊ីស្រាអ៊ែល ឡាច់ ឡឹង ទៀក តាំងលេ តីស ស៊ូប ឡាំ ប៉ាគ់ ស៊្រែ តីស ស៊ុរ។ អន់ឌែ ចាក ពឹង ស៊្រែ តីស ណោះ ទិ ប៉ៃង ដារ់ ហះកា អូ ទី ប៉ប័ ទៀក អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","ប៉ាគ់ ទឹល ព្រី ម៉ារ៉ា កេះ អន់ឌែ ប៉ប័ ទៀក ហះកា ទៀក ណោះ អូ អ្លុ អៃត អុះ ខង អ៊ែ តាំង។ ខ ណោះ ហង បះ ពូ អន់ សិច ចារ ណោះ ផា ម៉ារ៉ា ។ ");
INSERT INTO tpu_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","មួត ប៉ាសុន កាប កា វគ័ ម៉ូសេ រ៉ាបឹក រ៉ាចប់ ផា «កាណាគ័ ញ៉ា ពិន ចឹង អៃត អា ?» ");
INSERT INTO tpu_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","វគ័ ម៉ូសេ កា ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័  ប‌៉្រ័ះ កា តាំបាង អ៊្លង ម៉ោញ នែវ កា អ៊ែ វគ័ ម៉ូសេ អ្យក់ អ៊្លង ណោះ ហឹរ ពឹង ទៀក។ កេះណោះ អន់ឌែ អ្យក់ អៃត ទៀក ណោះ ដាគ់ អូ តាំង ហង។ ហះ ចារ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ ចាបាប់ កា សុនសាត អ៊ីស្រាអ៊ែល លូ សាគ់ លួង ពុត អន់ឌែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","អ៊ែ រ៉ះ កា អន់ឌែ ផា «ផា អន់ដីស អ្យក់ ពុត ចៃគ រ៉ាប់ សឿ អាញ់ ឡាក់ ប‌៉្រ័ះ អន់ដីស លូ ប៉្រគ័ សារ ដាគ់ ត្រង់ ឡាក់ ត្រគ់ ពុត អាញ់ ទឹប ប៉្រគ័ ពួយ ចាបាប់ ទិ អា ណោះ អាញ់ ចឹង អូ ប៉្រគ័ អន់ អន់ដីស កើត អីគ ព្លុ ឡាក់ កា អាញ់ ប៉្រគ័ កា សុនសាត អ៊ីស៊ីប ពែ ណោះ អុះ ខង អាញ់ អា ហង ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ តាគ់ អន់ដាគ់ អន់ដីស អា»។ ");
INSERT INTO tpu_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","កេះណោះ សុនសាត អ៊ីស្រាអ៊ែល ចាក ទឹល ប៉ាគ់ ព្រី អេលីម ហះ ចារ ណោះ ទី កល់ ទៀក ១២ ចារ ទឹប ទី តើម កាជៀង ៧០ តើម ដេល អន់ឌែ ប៉្រគ័ រ៉ាណើះ ហះ សានែង ហាង ទៀក ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ ចាក ឡាច់ ឡឹង ព្រី អេលីម ឡាំ ទឹល ប៉ាគ់ ស៊្រែ តីស ស៊ិន ហះ អន់តិគ័ អំពុន ព្រី អេលីម លូ ប៉ានឹម ស៊ីណាយ។ អន់ឌែ ទឹល ហះ ចារ ណោះ ដារ់ ទី ១៥ ខៃ ២ ឡៃង ឡឹង អន់ឌែ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ផះ ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ អ្វៃ ពឹង ស៊្រែ តីស ណោះ អន់ឌែ ប៉ាណាំ គួប កាប រ៉ាបឹក រ៉ាចប់ កា វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន។ ");
INSERT INTO tpu_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","អន់ឌែ កាប ផា «ផះ ញឹន អ្វៃ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ពែ ញឹន ឃើយ អង់អ្វៃ ជុំ កគ័ ឡាក់ ទី រ៉ាឡា អ្យាំ លូ ទី សាណា សា ផីគ។ ផា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាន់តោ័ ញឹន ពឹង ប៉ាថេត អ៊ីស៊ីប ពែ ណោះ ដាគ់ ហ៊្លត ឡឹង អន់ អន់ដីស ពៀរ ដូវ ប៉ាណាំ ញឹន ទិឌូ ឡាំ តោ័ កា ឡាយ៉ិត ពឹង ស៊្រែ តីស អា»។ ");
INSERT INTO tpu_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «អាញ់ ចឹង អន់ សាណា ឡឹង ប៉្លៃង កា អន់ដីស សា ហ្រុង ព្រុកៗ ឡាក់ កា ប៉្លៃង បី។ ប៉ាសុន ទិឌូ ត្រគ់ ឡាំ ទូញ សាណា ណោះ រ៉ប់ ដារ់ សាំពុះ ហ្លោះ សា កាណុង ម៉ោញ ដារ់។ ប៉្រគ័ នែវ អា ឃឺ អាញ់ ចឹង សាគ់ លួង ពុត អន់ឌែ ភឿ ប៉ិច អ្លុ អន់តគ់ ផា អន់ឌែ ចឹង ប៉្រគ័ ពួយ ញ៉ា អូ ចាបាប់ អាញ់ អា។ ");
INSERT INTO tpu_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ប៉ាគ់ ទឹល ដារ់ ទី ត្រោ ណោះ ត្រគ់ អន់ អន់ឌែ ទូញ សាំរ៉ាប់ ពៀរ ដារ់ ភឿ គម សា ដារ់ ទី តាំប៉ើះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន រ៉ះ កា ប៉ាសុន អ៊ីស្រាអ៊ែល ផា «ង៉ាច អា អន់ដីស ចឹង អ្លុ កាខាក់ ផា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប៉ាណាំ អន់ដីស ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ណោះ ពែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ប៉ាគ់ កាំលឺ តាយ៉ាង័ ទៀ អន់ដីស ចឹង ប៉ប័ តាតារ ក្លាគ់ ប‌៉្រ័ះ ប៊កកាតយ័  ខង អ៊ែ កាតាំង អន់ដីស កាប រ៉ាបឹក រ៉ាចប់ កា អ៊ែ។ អូ ត្រគ់ ញឹន អុះ ប៉ាណាំ អន់ដីស អា ញ៉ា ត្រគ់ អន់ដីស កាប រ៉ាបឹក រ៉ាចប់ កា ញឹន នីអៀ ?» ");
INSERT INTO tpu_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","វគ័ ម៉ូសេ រ៉ះ ណាវ្គ ផា «ខង ប‌៉្រ័ះ ប៊កកាតយ័ កាតាំង អន់ដីស កាប រ៉ាបឹក រ៉ាចប់ កា អ៊ែ ង៉ាច អា អ៊ែ ចឹង អន់ សាណា ខាច កា អន់ដីស សា ប៉ាគ់ កាំលឺ តាយ៉ាង័ អ៊ែ ចឹង អន់ ណុំ ប៉ាំង កា អន់ដីស សា ផីគ ដេល។ ញឹន ពៀរ ដូវ អា ប៉ាណូស នីចម័ បះ អន់ដីស កាប កា ញឹន នីអៀ ? អន់ដីស កាប រ៉ាបឹក រ៉ាចប់ ណោះ អូ ត្រគ់ កា ញឹន អុះ ឃឺ អន់ដីស កាប កា ប‌៉្រ័ះ ប៊កកាតយ័ »។ ");
INSERT INTO tpu_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","កេះណោះ វគ័ ម៉ូសេ រ៉ះ កា វគ័ អារ៉ុន ផា «ហគ់ អីស ប៉្រើ សុនសាត អ៊ីស្រាអ៊ែល ឡាំ អ្វៃ ហះ ង៉ីរ ប‌៉្រ័ះ ប៊កកាតយ័ រិញ ខង អ៊ែ កាតាំង អន់ឌែ កាប រ៉ាបឹក រ៉ាចប់ កា អ៊ែ នីណោ័ះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ផះ វគ័ អារ៉ុន អ្វៃ កាកាប លូ សុនសាត អ៊ីស្រាអ៊ែល អន់ឌែ កាលែង ហៃ គែង ស៊្រែ តីស ផាឌី ប៉ប័ តាតារ ក្លាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាច់ ពឹង កាម៉ល់។ ");
INSERT INTO tpu_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា ");
INSERT INTO tpu_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«អាញ់ កាតាំង មួត អ៊ីស្រាអ៊ែល កាប រ៉ាបឹក រ៉ាចប់ កេះ។ ហគ់ អីស រ៉ះ កា អន់ឌែ នីអៀ \"ផះ កាង៉ាច ម៉ាំង យ៉ោម សាយ៉ោម អន់ដីស ចឹង សា សាណា ខាច ប៉ាគ់ កាំលឺ អន់ដីស ចឹង ទី ណុំ ប៉ាំង សា ផីគ ណោះ ហង បះ អន់ដីស ចឹង អ្លុ អន់តគ់ ផា អាញ់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស តាទឹច\"»។ ");
INSERT INTO tpu_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ប៉ាគ់ កាង៉ាច ទី សៃម ព្រោច ប៉ារ់ ឡាំ ឡើះ ជុំ រ៉ាណើះ ប៉ាគ់ កាំលឺ ទី ទៀក ងម ឡិ ជឹរ ជុំ រ៉ាណើះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","ប៉ាគ់ សាអ្យាំង ទៀក ងម កេះ ទី តីល រ៉ាហឺញៗ ឡាក់ កា ប៉្លៃ ម៉ារៀល ប៉ាញ័ ទឹប ស៊្រែ តីស។ ");
INSERT INTO tpu_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ប៉ាគ់ មួត អ៊ីស្រាអ៊ែល ប៉ប័ នីណោ័ះ ម៉ោញ អំប៉ញ់ ម៉ោញ ផា «កាណាគ័ ញ៉ា អា ?» ខង អន់ឌែ អូ អន់ហ្នាល់ កា កាណាគ័ ញ៉ា អុះ។ វគ័ ម៉ូសេ រ៉ះ កា អន់ឌែ ផា «អា ហង សាណា ប‌៉្រ័ះ ប៊កកាតយ័ អន់ កា អន់ដីស សា។ ");
INSERT INTO tpu_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អន់ដីស ទូញ សាណា អា ប៉ុប ចំ ក្យិប ផីគ សា ត្រគ់ ទូញ ប៉ុប ណោះ ហង តាម ចំលួន ប៉ាណូស កាណុង ខាប់ខួ ម៉ោញ ដូវ ឃឺ ម៉ោញ កាអ្លី ថិ»។ ");
INSERT INTO tpu_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","សុនសាត អ៊ីស្រាអ៊ែល កា ប៉្រគ័ ពួយ ប៉ានឹរ អ៊ែ ប៉្រើ ណោះ ហង បក់ អន់ដា ទូញ អៀង បក់ អន់ដា ទូញ ប៊ែត។ ");
INSERT INTO tpu_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","កេះណោះ អន់ឌែ វ៉ាល់ ណុំ ណោះ បក់ ទូញ អៀង កា អូ ទី អៀង ឡឹង ពូ អុះ បក់ ទូញ ប៊ែត កា អូ ខ្វះ និះទៅ ដេល ម៉ោញ ដូវ ៗ ទី បគ័ ហ្លោះ សា ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","វគ័ ម៉ូសេ រ៉ះ កា អន់ឌែ ផា «អូ អន់ ពឿ គម ណុំ អា ទឹល កាំលឺ តាយ៉ាង័ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ហះកា បក់ អន់ដា អូ សឿ វគ័ ម៉ូសេ រ៉ះ ណោះ អុះ អន់ឌែ គម ណុំ ណោះ ទឹល កាំលឺ តាយ៉ាង័។ ណុំ ណោះ ទិ ហ្រាយ សា កើត អោម ឡូត វគ័ ម៉ូសេ អឺក កា អន់ឌែ ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ឡៃង ឡឹង ណោះ រ៉ប់ កាំលឺ អន់ឌែ កា ទូញ ណុំ ណោះ បគ័ ហ្លោះ សា ឡគ។ ប៉ាគ់ ដារ់ ឡាច់ តុ កេះ ណុំ អ្វៃ សល់ ពូ អូ ទូញ ណោះ កា ហ្លច់ ទិ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ប៉ាគ់ ទឹល ដារ់ ទី ត្រោ អន់ឌែ ទូញ ណុំ កាណុង ម៉ោញ ដូវ ពៀរ កាអ្លី ថិ ឃឺ សាំរ៉ាប់ ដារ់ ទី តាំប៉ើះ។ ទិ ម៉ៃគ ណាំផា មួត ប៉ាសុន អន់ឌែ ឡាំ រ៉ះ កា វគ័ ម៉ូសេ។ ");
INSERT INTO tpu_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","វគ័ ម៉ូសេ រ៉ះ កា អន់ឌែ ផា «ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ នីណោ័ះ តាទឹច ខង ដារ់ តាយ៉ាង័ ទៀ ឃឺ ដារ់ រ៉ាឡូវ ឡាក់ ដារ់ ដាគ់ សាំរ៉ាប់ ប៉ានេ ប‌៉្រ័ះ។ សាណា ចំ ប៉ិច ពុះ អន់ដីស ពុះ ពិ សាណា ចំ ប៉ិច សាន់តុក កា សាន់តុក ពិ សាណា បក់ សល់ ត្រគ់ គម សាំរ៉ាប់ អន់ដីស សា តាយ៉ាង័»។ ");
INSERT INTO tpu_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","អន់ឌែ កា គម សាណា ណោះ ទឹល តាយ៉ាង័ ពួយ ប៉ានឹរ វគ័ ម៉ូសេ រ៉ះ ហះកា ណុំ ណោះ ដាគ់ អូ អោម អូ ហ្លច់ អូ ទី ហ្រាយ សា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","ប៉ាគ់ ទឹល ដារ់ តាយ៉ាង័ វគ័ ម៉ូសេ រ៉ះ ផា «ដារ់ អា អន់ដីស សា សាណា សល់ អា ហង ខង ដារ់ អា ឃឺ ដារ់ រ៉ាឡូវ សាំរ៉ាប់ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ដារ់ អា គែង ឡីង កាណាគ័ ញ៉ា កា អូ ទី អុះ ឡាក់ អន់ដីស ចឹង ត្រគ់ ទូញ។ ");
INSERT INTO tpu_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","អន់ដីស ត្រគ់ ទូញ ណុំ អា ដឹង រ៉ាំងវ៉ាង ត្រោ ដារ់ ប៉ាគ់ ទឹល ដារ់ ទី តាំប៉ើះ អូ ទី កាណាគ័ ញ៉ា ចឹង ទូញ អុះ ខង ដារ់ រ៉ាឡូវ»។ ");
INSERT INTO tpu_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","យ‌៉័ះ វគ័ ម៉ូសេ រ៉ះ នីចម័ កាតាម កាណុង ដារ់ ទី តាំប៉ើះ ណោះ ទី ប៉ាណូស អន់ដា ឡាច់ ឡឹង រ៉ាណើះ ចាក ណាំង ទូញ ណុំ ដេល ហះកា អន់ឌែ ណាំង ទូញ អូ ទី អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","ប‌៉្រ័ះ ប៊កកាតយ័ អំប៉ញ់ វគ័ ម៉ូសេ ផា «ដារ់ ចំ អន់ដីស ចឹង រ៉ាប់ សឿ លូ ចៃ ប៉្រគ័ ពួយ ចាបាប់ អាញ់ អា ? ");
INSERT INTO tpu_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","អន់ដីស ត្រគ់ អ្លុ អន់តគ់ ផា អាញ់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ ដារ់ រ៉ាឡូវ កា អន់ដីស។ ញន ខ អា ហង បះ ពឹង ដារ់ ទី ត្រោ អាញ់ អន់ សាណា កា អន់ដីស ខា ពៀរ ដារ់។ ពឹង ដារ់ ទី តាំប៉ើះ អន់ដីស ទិឌូ ត្រគ់ អ្វៃ ដឹង ពឹង ចារ រ៉ាណើះ អូ អន់ ពឿ ឡាច់ គែង ឡីង អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","ខ អា ហង បះ ប៉ាសុន ទិឌូ អ្វៃ រ៉ាឡូវ ពឹង ដារ់ ទី តាំប៉ើះ។ ");
INSERT INTO tpu_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","គន សោ អ៊ីស្រាអ៊ែល អន់ សិច សាណា ណោះ ផា ណុំ ម៉ាណា ។ ណុំ ម៉ាណា អា បាក ត្រង័ អ៊ែ វ៉ឹច លូ តីល ឡាង៉ា ប៉ាអាំ អាម វ៉ឹច លូ ណុំ ពូ ប៉្រគ័ លូ ទៀក សុត។ ");
INSERT INTO tpu_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","វគ័ ម៉ូសេ រ៉ះ ផា «ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អន់ដីស អ្យក់ ណុំ ម៉ាណា ចៃគ អន់ ប៉ាញ័ ម៉ោញ កាអ្លី ថិ កេះណោះ គម រ៉ាន់ដាប់ សាំរ៉ាប់ តាំបាង អន់ កា គន សោ អ៊ីស្រាអ៊ែល រ៉ាំងហាវ អន់តីគ ប៉ប័ ដេល ឃឺ សាណា ឡាក់ អ៊ែ អន់ កា អន់ដីស សា ពឹង ស៊្រែ តីស អា ផះ រ៉ាំងវ៉ាង អ៊ែ ប៉ាណាំ អន់ដីស ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប»។ ");
INSERT INTO tpu_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","វគ័ ម៉ូសេ រ៉ះ កា វគ័ អារ៉ុន ផា «ហគ់ អីស អ្យក់ ណុំ ម៉ាណា ម៉ោញ កាអ្លី ណោះ ចៃគ ពឹង ព្រឺយ ថិ កេះណោះ គម រ៉ាន់ដាប់ ហះ ចារ ប‌៉្រ័ះ ប៊កកាតយ័ លើយ គ្រឹប រ៉ាំងហាវ»។ ");
INSERT INTO tpu_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","អ៊ែ ប៉្រគ័ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ តាទឹច វគ័ អារ៉ុន អ្យក់ ណុំ ម៉ាណា ចៃគ ហះ ហ៊ីប ចារ ប‌៉្រ័ះ ប៊កកាតយ័ សាញ៉ា រែវ ពុត ។ ");
INSERT INTO tpu_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","សុនសាត អ៊ីស្រាអ៊ែល សា ណុំ ម៉ាណា ណោះ ទិ ៤០ សាណាំ លើយ ទឹល អន់ឌែ ចាក ទឹល ប៉ាគ់ ស្រុក ម៉ោញ ទី ប៉ាណូស អ្វៃ ឃឺ ប៉ាគ់ គួយ ប៉ាថេត កាណាន។ ");
INSERT INTO tpu_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","កាអ្លី សាំរ៉ាប់ វ៉ាល់ ណុំ ម៉ាណា ណោះ សិច អូម៊ែរ។ ១០ អូម៊ែរ សាម៉ើ លូ ម៉ោញ អេផា ។ ");
INSERT INTO tpu_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","មួត អ៊ីស្រាអ៊ែល អន់ឌែ ប៉្រគ័ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អន់ឌែ រ៉ើ រ៉ាណើះ ចាក ឡាច់ ឡឹង ស៊្រែ តីស ស៊ិន ឡាំ ប៉ាគ់ ចារ អន់ទៀគ ណាវ្គ ទឹល ប៉ាគ់ ព្រី រេផិឌីម អន់ឌែ ប៉្រគ័ រ៉ាណើះ អ្វៃ ហះ ណោះ ហង ហះកា ចារ ណោះ អូ ទី ទៀក អន់ឌែ ចឹង អៃត អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","អន់ឌែ កា ណាំង សារ តាប៉ុញ លូ វគ័ ម៉ូសេ ទឹប កាប ផា «អន់ដីស ត្រគ់ អន់ ទៀក កា ញឹន អៃត»។ វគ័ ម៉ូសេ តើល ផា «ខ ញ៉ា បះ អន់ដីស ណាំង សារ តាប៉ុញ លូ អាញ់ ? ញ៉ា ត្រគ់ អន់ដីស ប៉ិច សាគ់ លួង ប‌៉្រ័ះ ប៊កកាតយ័ នីអៀ ?» ");
INSERT INTO tpu_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","អ្វៃ ហះ ចារ ណោះ មួត ប៉ាសុន ហ៊្រែង ទៀក ខាក់ អន់ឌែ កាប រ៉ាបឹក រ៉ាចប់ កា វគ័ ម៉ូសេ ផា «ខ ញ៉ា បះ អីស ប៉ាណាំ ញឹន ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ទឹប គន សោ លូ កាណាគ័ ញឹន រង អន់ ឡាំ តោ័ កា អូ ទី ទៀក អៃត នីអៀ ?» ");
INSERT INTO tpu_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","កេះណោះ វគ័ ម៉ូសេ ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ផា «អាញ់ ចឹង ប៉្រគ័ នីចម័ កា មួត ប៉ាសុន អា ? អន់ទៀ ចាបះ កា អន់ឌែ ចឹង អ្យក់ អំហ្មោ ហឹរ ប៉ាន់តោ័ អាញ់ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហគ់ អីស ចាក ឡាំ ប៉ាគ់ ម៉ាត់ មួត ប៉ាសុន ណោះ ពិ ជៀក ទឹប មួត ក្រាគ់ តាំងកង់ អ៊ីស្រាអ៊ែល អន់ដា លូ ចឹក ឡាំ ទឹប អ៊្លង កាទូង អីស ពីត តាំងលេ នីល ពែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","អីស ចាក ទឹល ប៉ាគ់ ប៉ានឹម ស៊ីណាយ ពិ ហះ ណោះ អាញ់ ចឹង អន់តាវ ហះ ង៉ីរ អីស អំប៉ាំង អំហ្មោ។ កេះណោះ អីស ចោះ អំហ្មោ ណោះ ម៉ាគ់ ចឹង ទី ទៀក ហូរ័ ឡាច់ ឡឹង អំហ្មោ អន់ កា ប៉ាសុន អៃត ហង»។ វគ័ ម៉ូសេ កា ប៉្រគ័ ហះ ម៉ាត់ មួត ក្រាគ់ តាំងកង់ អ៊ីស្រាអ៊ែល តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","កេះណោះ វគ័ ម៉ូសេ អន់ សិច ចារ ណោះ ផា ម៉ាសា លូ មេរីបា  ខង គន សោ អ៊ីស្រាអ៊ែល ណាំង សារ តាប៉ុញ លូ អ៊ែ ទឹប សាគ់ លួង ប‌៉្រ័ះ ប៊កកាតយ័ លូ កាប ផា «ប‌៉្រ័ះ អ្វៃ អន់ឌូ លូ ពិន តាទឹច ប ?»។ ");
INSERT INTO tpu_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","ឡៃង ឡឹង ណោះ ទី សុនសាត អាម៉ាឡេក ប៉ាណាំ គួប ឡាំ តាកូះ លូ សុនសាត អ៊ីស្រាអ៊ែល អ្វៃ ពឹង ព្រី រេផិឌីម ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","វគ័ ម៉ូសេ រ៉ះ កា យូស្វេ ផា «ហគ់ អីស រ៉ើស អ្យក់ ប៉ាណូស ម៉ោញ ចំលួន កេះណោះ ឡាំ តាកូះ លូ មួត អាម៉ាឡេក ណោះ ពិ កាប៉ាច់ អាញ់ តាយ៉ាង័ ទៀ អាញ់ ចឹង ហាវ អន់តាវ ពឹង កល់ ប៉ានឹម លូ ចឹក អ៊្លង កាទូង ម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័»។ ");
INSERT INTO tpu_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","យូស្វេ កា ឡាំ តាកូះ លូ សុនសាត អាម៉ាឡេក ប៉្រគ័ ពួយ វគ័ ម៉ូសេ រ៉ះ តាទឹច។ កាប៉ាច់ វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន លូ វគ័ ហ៊ើរ អន់ឌែ ហាវ ពឹង កល់ ប៉ានឹម។ ");
INSERT INTO tpu_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ផះ វគ័ ម៉ូសេ លឺក តី ពឹង ចាំងហីគ មួត អ៊ីស្រាអ៊ែល ទី សាងុំ លឺន ឡឹង សុនសាត អាម៉ាឡេក ហះកា ផះ វគ័ ម៉ូសេ ប៉ាឡិ ជឹរ តី មួត សុនសាត អាម៉ាឡេក ទី សាងុំ លឺន ឡឹង អន់ឌែ ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","ញន កា តី វគ័ ម៉ូសេ ឡាកាញ័ កេះ វគ័ អារ៉ុន លូ វគ័ ហ៊ើរ អ្យក់ អំហ្មោ អន់ កា វគ័ ម៉ូសេ អង់អ្វៃ អន់ឌែ តាប៉ោង តី វគ័ ម៉ូសេ ម៉ោញ ដូវ ម៉ោញ ប៊ែង ប៉្រគ័ អន់ កា វគ័ ម៉ូសេ ដាម័ លឺក តី លើយ ទឹល ដារ់ ម៉ុត។ ");
INSERT INTO tpu_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","អន់ឌែ តាកូះ ណោះ កា ទី ទ្រង យូស្វេ ហង ទឹប អ៊ែ ប៉ាន់តោ័ តាហាន សុនសាត អាម៉ាឡេក ណោះ លូ ដាវ។ ");
INSERT INTO tpu_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","ឡៃង ឡឹង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហគ់ អីស ច្រាគ់ សារ ទិ អា គម កាណុង ផាប់ ម៉ាគ់ កាចាំង ដាគ់ អូ ពឹល។ កេះណោះ អីស រ៉ះ កា យូស្វេ ផា អាញ់ ចឹង ឡុំ អ្លាត សុនសាត អាម៉ាឡេក អន់ ទិ ប៉្យើះ ឡឹង អង់កក់ តេះ អា ឡូត អូ អន់ ពឿ កាចាំង ឡឹង សិច អន់ឌែ ណាវ្គ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","ហះ ចារ ណោះ វគ័ ម៉ូសេ ប៉្រគ័ ចារ ម៉ោញ សាំរ៉ាប់ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ កេះណោះ អន់ សិច ផា យ៉ះវេះ និស៊ី ។ ");
INSERT INTO tpu_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","កេះណោះ អ៊ែ កាប ផា «ញន កា សុនសាត អាម៉ាឡេក ខឹន លឺក តី ប៉ាសាំង លូ អំរ៉ាញ ប‌៉្រ័ះ ប៊កកាតយ័ បះ ប‌៉្រ័ះ ចឹង តាកូះ លូ អន់ឌែ លើយ»។ … ");
INSERT INTO tpu_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ឡៃង ឡឹង សុនសាត អ៊ីស្រាអ៊ែល ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប អន់ឌែ ចាក ទឹល ប៉ាគ់ ស៊្រែ ស៊ីណាយ ពឹង ដារ់ ទី ១ ខៃ ៣ អា ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","អន់ឌែ ឡាច់ ឡឹង ព្រី រេផិឌីម ចាក ទឹល ស៊្រែ ស៊ីណាយ កេះ អន់ឌែ ប៉្រគ័ រ៉ាណើះ អ្វៃ ត្រង់ ប៉ានឹម ស៊ីណាយ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","វគ័ ម៉ូសេ ហាវ ប៉ាគ់ ចារ ប‌៉្រ័ះ ប៊កកាតយ័ ប‌៉្រ័ះ អើ អ៊ែ ឡឹង ប៉ានឹម លូ រ៉ះ ផា «អីស ត្រគ់ រ៉ះ កា សុនសាត អ៊ីស្រាអ៊ែល ឡាក់ គន សោ យ៉ាកុប ណោះ នីអៀ ");
INSERT INTO tpu_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","\"ម៉ាត់ អន់ដីស តាំងឡា ប៉ប័ កេះ សារ អាញ់ ប៉្រគ័ កា សុនសាត អ៊ីស៊ីប កេះណោះ អាញ់ ប៉ាណាំ អន់ដីស ឡាំ ប៉ាគ់ ចារ អាញ់ អា ឡាក់ កា ក្លាង ប៉ោម គ្វី គន អ៊ែ ពឹង អង់កក់។ ");
INSERT INTO tpu_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ទឹល នីណោ័ះ ផា អន់ដីស សាំយ៉ាំង ប៉ានឹរ អាញ់ លូ សឿ សារ អាញ់ សាញ៉ា រែវ ពុត លូ អន់ដីស ណោះ អន់ដីស ចឹង កេះ ប៉ាសុន អាញ់ តាទឹច ទី ខា ក្វា ឡឹង សុនសាត អន់ទៀគៗ។ យ‌៉័ះ អង់កក់ តេះ អា ម៉ះ អាញ់ កាតាម ");
INSERT INTO tpu_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","កា អន់ដីស ចឹង ប៉្រគ័ ក្រាគ់ រ៉ាម៉ះ អាញ់ ឡាក់ អាញ់ ចឹង រ៉ាំងហៃ រ៉ាំងខ្យា ឃឺ អន់ដីស ចឹង ប៉្រគ័ សុនសាត ដាគ់ កាខាក់ សាំរ៉ាប់ កា អាញ់\"។ សារ អា ហង អីស ត្រគ់ រ៉ះ កា សុនសាត អ៊ីស្រាអ៊ែល ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","កេះណោះ វគ័ ម៉ូសេ សឹត ប៉ាគ់ សុនសាត អ៊ីស្រាអ៊ែល ណាវ្គ លូ អើ មួត ក្រាគ់ តាំងកង់ អ៊ីស្រាអ៊ែល ទិឌូ ពឹះ ប៉ាតុំ គួប កេះណោះ អ៊ែ រ៉ះ ទិ សារ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","មួត ប៉ាសុន ទិឌូ កា តើល ផា «ញឹន ចឹង ប៉្រគ័ ពួយ គ្រឹប សារ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ»។ កេះណោះ វគ័ ម៉ូសេ ឡាំ រ៉ះ លូ ប‌៉្រ័ះ ប៊កកាតយ័ ណាវ្គ សារ មួត ប៉ាសុន កាប ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «អាញ់ ចឹង ឡាំ កាប លូ អីស អាញ់ ចឹង អ្វៃ កាណុង កាម៉ល់ តុត កាពុល ភឿ អន់ មួត ប៉ាសុន កាតាំង ផះ អាញ់ កាកាប លូ អីស ម៉ាគ់ អន់ឌែ ចឹង សឿ អីស លើយ»។ ប៉ាគ់ វគ័ ម៉ូសេ រ៉ះ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡឹង សារ មួត ប៉ាសុន កាប កេះ ");
INSERT INTO tpu_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ប‌៉្រ័ះ រ៉ះ កា អ៊ែ ផា «ហគ់ អីស សឹត ប៉ាគ់ មួត ប៉ាសុន ណាវ្គ ពិ កេះណោះ អីស ប៉្រគ័ អន់ អន់ឌែ ដាគ់ សាំរ៉ាប់ កា អាញ់ កាណុង ដារ់ អា លូ ដារ់ តាយ៉ាង័ លូ ប៉្រើ អន់ឌែ ប៉ីស ខោ អាវ អន់ ដាគ់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","កេះណោះ អីស ប៉្រើ អន់ឌែ ទ្រៀម ឡាកោ អន់ កេះ សាំរ៉ាប់ ដារ់ តាយ៉ាង័ តោ ខង ដារ់ ណោះ អាញ់ ចឹង ជឹរ ពឹង ប៉ានឹម ស៊ីណាយ ផះ ប៉ាសុន ទិឌូ អ្វៃ ហៃ។ ");
INSERT INTO tpu_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","អីស ត្រគ់ អ្យក់ អំហ្មោ តគ័ គួយ ជុំ ប៉ានឹម លូ រ៉ះ កា អន់ឌែ អន់ ឡាវ៉ាំង ឡាកោ ជែ អន់ ហាវ ពឹង ប៉ានឹម លូ ជែ ឡាំ ចគ័ ជុង ប៉ានឹម ដេល។ ផា ពឿ ឡាំ ចគ័ ប៉ានឹម ប៉ាណូស ណោះ ត្រគ់ ប៉ាន់តោ័ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","អូ ផា កា ប៉ាណូស អូ ផា កា កាណាគ័ ញ៉ា កាតាម អូ អន់ អ្វៃ រ៉ីស អុះ ត្រគ់ ប៉ាន់តោ័ ទិ។ ប៉ាណូស ណោះ អូ អន់ ពឿ ឡាំ រ៉ុប អ្យក់ អុះ អីស ត្រគ់ ហឹរ លូ អំហ្មោ លើ ប៉ាញ់ លូ ស្រាគ់។ ប៉ាគ់ កាតាំង ខ្លោម សាណៃង កេះ ត្រគ់ អន់ អន់ឌែ ឡាំ ក្យាម័ ប៉ានឹម»។ ");
INSERT INTO tpu_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","វគ័ ម៉ូសេ ជឹរ ឡឹង ប៉ានឹម សឹត ប៉ាគ់ មួត ប៉ាសុន ណាវ្គ អ៊ែ ប៉្រគ័ អន់ អន់ឌែ ដាគ់ សាំរ៉ាប់ កា ប‌៉្រ័ះ លូ ប៉្រើ អន់ឌែ ប៉ីស ខោ អាវ អន់ ដាគ់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","កេះណោះ វគ័ ម៉ូសេ រ៉ះ កា ប៉ាសុន ផា «អន់ដីស ត្រគ់ ទ្រៀម ឡាកោ សាំរ៉ាប់ ដារ់ តាយ៉ាង័ តោ លូ អូ អន់ ពឿ តៃប លូ អង់កាន់ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","ទឹល កាំលឺ ដារ់ កាំឡត់ កេះ ពឹង ប៉ានឹម កា ទី តើម បី ម៉ាម៉ាំង ម៉ាមត ទឹប ទី កាំឡាត លូ កាតាំង តេះតរ់ លូ កាតាំង ខ្លោម សាណៃង ដេល។ មួត ប៉ាសុន អ្វៃ កាណុង ចារ រ៉ាណើះ អ្យូគ រ៉ារ៉ៃត ឡាកោ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","កេះណោះ វគ័ ម៉ូសេ ប៉ាណាំ ប៉ាសុន ឡាច់ ឡឹង ចារ រ៉ាណើះ ឡាំ ប៉ាគ់ ចារ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ឌែ អ្វៃ ហះ ជុង ប៉ានឹម។ ");
INSERT INTO tpu_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","អ្យី អុញ ប៉ាញ័ ទឹប ប៉ានឹម ស៊ីណាយ ខង ប‌៉្រ័ះ ប៊កកាតយ័ ជឹរ ពឹង ប៉ានឹម អ្វៃ កាណុង អុញ។ អ្យី ឡាច់ ឡឹង ប៉ានឹម ណោះ ឡាក់ កា អ្យី អុញ ពូ សុះ ម៉ីរ ប៉ានឹម ណោះ រ៉ារ៉ៃត ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ផះ វគ័ ម៉ូសេ កាកាប លូ ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ ប៉ានឹរ សាណៃង ហ៊ែង ថាំង ៗ។ ពូ កា កាតាំង ប៉ានឹរ ប‌៉្រ័ះ តើល វគ័ ម៉ូសេ។ ");
INSERT INTO tpu_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","ប‌៉្រ័ះ ប៊កកាតយ័ ជឹរ អ្វៃ ពឹង កល់ ប៉ានឹម ស៊ីណាយ លូ អើ វគ័ ម៉ូសេ វគ័ ម៉ូសេ កា ហាវ ពឹង ប៉ានឹម ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហគ់ អីស ជឹរ ទឹប ប៉ាសុន ជែ អន់ អន់ឌែ ម៉ុត ឃ្លង គួយ ញន កា ប៉ិច ប៉ប័ អាញ់ អ្យូគ អន់ឌែ តោ័ អៀង ដូវ។ ");
INSERT INTO tpu_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","យ‌៉័ះ មួត ក្រាគ់ រ៉ាម៉ះ អាញ់ ឡាក់ ឃើយ ម៉ុត ក្យាម័ អាញ់ កេះ កាតាម ត្រគ់ ប៉្រគ័ អន់ អន់ឌែ ដាគ់ កាខាក់ និះទៅ ដេល អ្យូគ អាញ់ ពីត អន់ឌែ តោ័»។ ");
INSERT INTO tpu_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","វគ័ ម៉ូសេ តើល ផា «ប៉ាសុន អូ ខឹន ហាវ ពឹង ប៉ានឹម ស៊ីណាយ អា អុះ ខង អីស ប៉្រើ ញឹន តគ័ គួយ ជុំ ប៉ានឹម អា កេះ ប៉្រគ័ អន់ អ្លុ អន់តគ់ ផា ប៉ានឹម អា ឡាក់ ចារ ប‌៉្រ័ះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ណាវ្គ ផា «អ្យគ័ អីស សឹត ឡគ ពិ កេះណោះ ជៀក អារ៉ុន ឡាំ អន់ឌូ លូ អីស ប៉ាគ់ អា ដេល ហះកា មួត ក្រាគ់ រ៉ាម៉ះ អាញ់ លូ មួត ប៉ាសុន អូ អន់ អន់ឌែ ម៉ុត ហាវ ប៉ាគ់ ចារ អាញ់ អុះ អ្យូគ អាញ់ ចឹង ប៉ាន់តោ័ អន់ឌែ»។ ");
INSERT INTO tpu_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","កេះណោះ វគ័ ម៉ូសេ កា ជឹរ ប៉ាគ់ មួត ប៉ាសុន ណាវ្គ លូ រ៉ះ កា អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កាកាប លូ គន សោ អ៊ីស្រាអ៊ែល ផា ");
INSERT INTO tpu_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«អាញ់ អា ហង ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស។ អាញ់ ហង ប៉ាណាំ អន់ដីស ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ឡាក់ ចារ អន់ដីស អ្វៃ ប៉្រគ័ ទុច ពែ។ ");
INSERT INTO tpu_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","ទឹល នីណោ័ះ អូ អន់ អន់ដីស សឿ ប‌៉្រ័ះ អន់ទៀគ ណាវ្គ ហ្វាស ឡឹង អាញ់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","«អូ អន់ អន់ដីស ប៉្រគ័ ហ៊ូប កាណាគ័ ញ៉ា ឡាក់ អ្វៃ ពឹង ប៉្លៃង លូ ពឹង តេះ លូ កាណុង ទៀក ប៉្រគ័ ហ៊ូប ប‌៉្រ័ះ សាំរ៉ាប់ អន់ដីស អុះ ");
INSERT INTO tpu_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","លូ អូ អន់ អន់ដីស សាំប‌៉័ះ សៃន ហ៊ូប ប‌៉្រ័ះ ទិណោ័ះ អុះ ខង អាញ់ ក្យាគ់ អូ អន់ អន់ដីស ប៉ិច កា ប‌៉្រ័ះ អន់ទៀគ អុះ។ ពឿ អូ ណីស កា អាញ់ អាញ់ ចឹង ចៃគ ថូត ប៉ាណូស ណោះ ឡឹង ពឹ ទឹល គន សោ ប៉្វាន់ រ៉ាំងហាវ ឡូត ");
INSERT INTO tpu_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ហះកា អាញ់ ចឹង តាំបាង សារ អាញ់ ប៉ិច ចៃ កា ប៉ាណូស បក់ ប៉ិច កា អាញ់ លូ ចៃ ប៉្រគ័ ពួយ សារ អាញ់ ប៉្រើ ទឹល ញ៉ាង រ៉ាពូ រ៉ាំងហាវ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","«អាញ់ អូ អន់ អន់ដីស អើ សិច អាញ់ ឡាក់ ប‌៉្រ័ះ អន់ដីស កាណុង សារ អូ ទី ខា អុះ ខង អាញ់ ចឹង ចៃគ ថូត បក់ អើ សិច អាញ់ ម៉ាឡាំ ម៉ាឡយ នីណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","«អន់ដីស ត្រគ់ កាចាំង ឡឹង ដារ់ រ៉ាឡូវ ត្រគ់ ឃឹត ផា ដារ់ ណោះ ឡាក់ ដារ់ សាំរ៉ាប់ ប៉ានេ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ង៉ារ ញ៉ា ឡាក់ អន់ដីស ត្រគ់ ប៉្រគ័ ណោះ អន់ដីស ត្រគ់ ប៉្រគ័ ដឹង កាណុង រ៉ាំងវ៉ាង ត្រោ ដារ់ ណោះ ហង ");
INSERT INTO tpu_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ហះកា កាណុង ដារ់ ទី តាំប៉ើះ ឃឺ ដារ់ រ៉ាឡូវ សាំរ៉ាប់ ប៉ានេ អាញ់ ឡាក់ ប‌៉្រ័ះ អន់ដីស។ ទឹល នីណោ័ះ កាណុង ដារ់ ណោះ អន់ដីស លូ គន សោ អន់ដីស ទឹប កាម៉ាក័ ទឹប អង់កាន់ លូ ទុច អន់ដីស ទឹប កាម៉ាក័ ទឹប អង់កាន់ លូ អំហ៊្មយ ឡាក់ អ្វៃ ពឹង ស្រុក អន់ដីស អន់ដីស ត្រគ់ រ៉ាឡូវ ទិឌូ អូ អន់ ប៉្រគ័ ង៉ារ ញ៉ា អុះ។ កាណាគ័ អន់ដីស រង កា ត្រគ់ រ៉ាឡូវ និះទៅ ដេល ");
INSERT INTO tpu_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ខង អាញ់ ប៉ាំងកើត តេះ ប៉្លៃង ទឹប ទៀក សាឡីគ សាឡាយ លូ កាណាគ័ គ្រឹប នែវ អ្វៃ ពឹង អង់កក់ តេះ អា ដឹង រ៉ាំងវ៉ាង ត្រោ ដារ់ ប៉ាគ់ ទឹល ដារ់ ទី តាំប៉ើះ អាញ់ រ៉ាឡូវ។ ខ អា ហង បះ អាញ់ ផា ដារ់ ទី តាំប៉ើះ ឃឺ ដារ់ ដាគ់ សាំរ៉ាប់ រ៉ាឡូវ ប៉ានេ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","«អន់ដីស ត្រគ់ អ្យិល កូត័ មើគ ពឹ ម៉ាគ់ អន់ដីស ទី អាញុ រ៉ីស ទុញ អ្វៃ ពឹង ប៉ាថេត ឡាក់ អាញ់ ចឹង អន់ កា អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","«អូ អន់ ប៉ាន់តោ័ ប៉ាណូស អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","«អូ អន់ រ៉ាលង កល់ កាម៉ាញ់ លើ ក្លោ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","«អូ អន់ អន់តុង រ៉ាត ម៉ះ ពូ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","«អូ អន់ ព្លូង ប៉្លាច័ ប៉្រគ័ អន់ កា ពូ ត្រគ់ ថូត អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","«អូ អន់ ប៉ិច កា ហី ពូ លើ ប៉ិច កា ទុច ពូ លើ កា ប៉ិច កា រ៉ក់ លៀ លូ កាណាគ័ ញ៉ា ឡាក់ ម៉ះ ពូ អុះ លូ ជែ ប៉ិច កា កាម៉ាញ់ ពូ ដៃ»។ ");
INSERT INTO tpu_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","ប៉ាសុន ទិឌូ កាតាំង តេះតរ់ លូ កាតាំង ប៉ានឹរ សាណៃង ទឹប ប៉ប័ កាំឡាត លូ ប៉ប័ អ្យី អុញ ឡាច់ ឡឹង ប៉ានឹម អន់ឌែ អ្យូគ រ៉ារ៉ៃត ឡាកោ កេះណោះ អន់ឌែ ឡាំ អន់តាវ ហៃ ឡឹង ចាំងហាយ្គ។ ");
INSERT INTO tpu_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","កេះណោះ អន់ឌែ រ៉ះ កា វគ័ ម៉ូសេ ផា «ប៉រ់ អីស រ៉ះ កា ញឹន ឡគ ញឹន ចឹង សាំយ៉ាំង អីស ហះកា អីស ជែ អន់ ប‌៉្រ័ះ ប៊កកាតយ័ កាកាប លូ ញឹន អ្យូគ ផៃគ ញឹន ចឹង តោ័»។ ");
INSERT INTO tpu_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","ហះកា វគ័ ម៉ូសេ រ៉ះ កា អន់ឌែ ផា «ជែ អ្យូគ ! ប‌៉្រ័ះ ប៊កកាតយ័ ជឹរ នែវ អា ភឿ សាគ់ លួង ពុត អន់ដីស លូ អន់ អន់ដីស អ្យិល កូត័ អ្យូគ កា អ៊ែ ភឿ អូ អន់ អន់ដីស ប៉្រគ័ យច លូ អ៊ែ»។ ");
INSERT INTO tpu_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","មួត ប៉ាសុន អន់ឌែ អន់តាវ ឡឹង ចាំងហាយ្គ ហះកា វគ័ ម៉ូសេ ម៉ុត ក្យាម័ កាម៉ល់ កាពុល ឡាក់ ចារ ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ។ … ");
INSERT INTO tpu_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ណាវ្គ ផា «ហគ់ អីស ជៀក អារ៉ុន លូ គន អ៊ែ ណាដាប លូ អាប៊ីហ៊ូ ទឹប ក្រាគ់ តាំងកង់ សុនសាត អ៊ីស្រាអ៊ែល ចំលួន ៧០ ដូវ ហាវ ពឹង ប៉ានឹម ឡាំ ប៉ាគ់ ចារ អាញ់ កេះណោះ អន់ដីស ជន តាកុល សាំប‌៉័ះ អាញ់ ឡឹង ចាំងហាយ្គ ប៊ែត។ ");
INSERT INTO tpu_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","ទី ដឹង អីស ម៉ោញ ដូវ អីស ម៉ុត ក្យាម័ អាញ់ ពូ អន់ទៀគ ម៉ុត អូ ទី អុះ។ មួត ប៉ាសុន អូ ត្រគ់ ហាវ អុះ ពឹង ប៉ានឹម អន់ឌូ លូ អីស»។ ");
INSERT INTO tpu_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","កេះណោះ វគ័ ម៉ូសេ ឡាំ រ៉ះ ទិ សារ លូ ចាបាប់ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ ណោះ ហង អន់ កា មួត ប៉ាសុន សាំយ៉ាំង ប៉ាសុន ទិឌូ តើល ផា «ទិ សារ ប‌៉្រ័ះ រ៉ះ ណោះ ញឹន ចឹង ប៉្រគ័ ពួយ»។ ");
INSERT INTO tpu_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","វគ័ ម៉ូសេ ច្រាគ់ គម ទិ សារ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ។ ប៉ាគ់ តាយ៉ាង័ អ៊ែ អ្យូវ ឡឹង កាំលឺ ផុងម៉ាំង ឡាំ ប៉្រគ័ ចារ សាំរ៉ាប់ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ហះ ជុង ប៉ានឹម កេះណោះ តាគ់ អន់តាវ អំហ្មោ ១២ កាតុ ភឿ ប៉ាតាង ផូង័ វ៉ាច់ អ៊ីស្រាអ៊ែល ទិ ១២ ផូង័។ ");
INSERT INTO tpu_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","កេះណោះ វគ័ ម៉ូសេ ប៉្រើ មួត តាតាម័ អ៊ីស្រាអ៊ែល កោះ រ៉ក់ ទោល រ៉ក់ អន់ដា អន់ឌែ ពុះ អ្លាត សាំរ៉ាប់ រ៉ាម៉ះ ប‌៉្រ័ះ អន់ដា អន់ឌែ ពុះ រ៉ាម៉ះ សាំរ៉ាប់ សា អន់ឌូ លូ គួប សោប។ ");
INSERT INTO tpu_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","វគ័ ម៉ូសេ អ្យក់ ផាម រ៉ក់ ទងតិគ័ ចៃគ ពឹង កាប៊ែ អ្យក់ ទងតិគ័ ណាវ្គ ស្រោច ពឹង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","កេះណោះ អ៊ែ អ្យក់ ផាប់ សាញ៉ា រែវ ពុត អ៊ែ ច្រាគ់ ពែ អាន អន់ កា មួត ប៉ាសុន សាំយ៉ាំង។ អន់ឌែ តើល ផា «ទិ សារ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ណោះ ញឹន ចឹង ប៉្រគ័ ពួយ លូ រ៉ាប់ សឿ អ៊ែ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","វគ័ ម៉ូសេ អ្យក់ ផាម អ៊ែ ចៃគ ពឹង កាប៊ែ ប៉ាប៉្រះ ពឹង មួត ប៉ាសុន លូ កាប ផា «ផាម អា តាគ់ អង់កេះ សារ សាញ៉ា រែវ ពុត ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ លូ អន់ដីស ពួយ ប៉ានឹរ អ៊ែ រ៉ះ អា»។ ");
INSERT INTO tpu_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","កេះណោះ វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ទឹប ណាដាប លូ អាប៊ីហ៊ូ ទឹប មួត ក្រាគ់ តាំងកង់ អ៊ីស្រាអ៊ែល ៧០ ដូវ អន់ឌែ ហាវ ពឹង ប៉ានឹម។ ");
INSERT INTO tpu_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","អន់ឌែ ប៉ប័ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល។ ចារ អ៊ែ ចគ័ ណោះ ប៉្រគ័ លូ តាយ៉ាល័ ឡាយ៉ាម័ ខៀវ សាង វ៉ឹច លូ ប៉្លៃង តាំង។ ");
INSERT INTO tpu_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ អូ ពីត អូ ប៉ាន់តោ័ អុះ មួត ក្រាគ់ តាំងកង់ សុនសាត អ៊ីស្រាអ៊ែល ណោះ។ អន់ឌែ ទិឌូ ប៉ប័ ប‌៉្រ័ះ ប៊កកាតយ័ កេះណោះ អន់ឌែ អៃត សា។ ");
INSERT INTO tpu_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","ឡៃង ឡឹង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហគ់ អីស ហាវ ពឹង ប៉ានឹម ឡាំ ប៉ាគ់ ចារ អាញ់ កេះណោះ អីស អ្វៃ ក្យាគ់ ហះ អា ហិ អាញ់ ចឹង អន់ អំហ្មោ ឡាត កា អីស។ ពឹង អំហ្មោ ឡាត ណោះ អាញ់ ច្រាគ់ កេះ ចាបាប់ លូ សារ អន់តគ់ ប៉ាតោ ឡាក់ ចឹង ត្រគ់ អ្យក់ ប៉ាំងហៀន ប៉ាសុន»។ ");
INSERT INTO tpu_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","14","កេះណោះ វគ័ ម៉ូសេ រ៉ះ កា មួត ក្រាគ់ តាំងកង់ ផា «អ្យគ័ អន់ដីស អ្វៃ ក្យាគ់ ហះ អា ហិ ទឹល ញឹន សឹត ប៉ាគ់ អន់ដីស អា ណាវ្គ។ អារ៉ុន លូ ហ៊ើរ កា អ្វៃ អន់ឌូ លូ អន់ដីស ហះ អា ដេល ផា ពឿ ទី សារ ញ៉ា ត្រគ់ តាត់ស៊ិន ប៉្រើ អ៊ែ ឡាំ រ៉ះ កា មួត ពៀរ ដូវ អា ឡគ»។ កេះណោះ អ៊ែ ចាក អន់ឌូ លូ យូស្វេ ឡាក់ តង័ ង៉ារ អ៊ែ។ អ៊ែ កា ហាវ ពឹង ប៉ានឹម ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","ផះ វគ័ ម៉ូសេ ហាវ ពឹង ប៉ានឹម គឹត អន់តិគ័ ផាឌី ទី កាម៉ល់ ពឹះ កាត្រោប កាន់ទឹង កល់ ប៉ានឹម ឡូត ");
INSERT INTO tpu_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","លូ ទី តាតារ ក្លាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ ពឹង ប៉ានឹម ស៊ីណាយ។ កាម៉ល់ កាត្រោប កាន់ទឹង ប៉ានឹម ណោះ ទុញ ត្រោ ដារ់។ ប៉ាគ់ ទឹល ដារ់ ទី តាំប៉ើះ ប‌៉្រ័ះ ប៊កកាតយ័ អើ វគ័ ម៉ូសេ ឡឹង កាម៉ល់។ ");
INSERT INTO tpu_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","មួត សុនសាត អ៊ីស្រាអ៊ែល ប៉ប័ តាតារ ក្លាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ ពឹង ប៉ានឹម ណោះ ឡាក់ កា អុញ សា កល់ ប៉ានឹម។ ");
INSERT INTO tpu_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","វគ័ ម៉ូសេ ហាវ ណាវ្គ ម៉ុត កាណុង កាម៉ល់ អ៊ែ អ្វៃ ពឹង ប៉ានឹម ណោះ ទុញ ៤០ ម៉ាំង ៤០ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ លូ វគ័ ម៉ូសេ ផា ");
INSERT INTO tpu_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«ហគ់ រ៉ះ កា សុនសាត អ៊ីស្រាអ៊ែល ប៉្រើ អន់ឌែ ឡិង កាណាគ័ សាំរ៉ាប់ កា អាញ់។ ត្រគ់ អ្យក់ កាណាគ័ ឡឹង បក់ ចំ ឡាក់ ប៉ិច អន់ កា អាញ់ ទិ ពុត ទិ ពៀក។ ");
INSERT INTO tpu_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","កាណាគ័ ឡាក់ អីស ត្រគ់ អ្យក់ ឡឹង អន់ឌែ ណោះ ឃឺ៖ ម៉ាស ប៉្រាក់ សាប៉ាន័ ");
INSERT INTO tpu_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","កាណាត់ នែវ ខៀវ នែវ ណាំអ៊ិត នែវ កាហ្រី កាណាត់ បាក ឡាក់ គឹត ខា ទឹប កាណាត់ ប៉្រគ័ លូ សក់ ប៉ារ់ពេ ");
INSERT INTO tpu_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","អង់ការ ចៀម ឡុក ចារ័ នែវ កាហ្រី អង់ការ កា ប៉ាសោត លូ អ៊្លង សាំងឡាញ់ ");
INSERT INTO tpu_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ប៉ុង សាំរ៉ាប់ សុះ តាគៀង ឃឿង បោផូវ សាំរ៉ាប់ ឡាយ លូ សាងី ភឿ ជ្រោ ពឹង ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ លូ តាំងហ៊ុម សាំរ៉ាប់ សុះ ");
INSERT INTO tpu_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","តាយ៉ាល័ ចាយ រ៉ាំង លូ តាយ៉ាល័ អន់ទៀគៗ សាំរ៉ាប់ ប៉ាតឹត ពឹង អាវ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ លូ ប៉ាតឹត ពឹង កាណាគ័ ពឹង កាន់តើះ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","កេះណោះ ប៉្រើ អន់ឌែ ប៉្រគ័ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ម៉ាគ់ អាញ់ ចឹង អ្វៃ ពឹង អន់តិគ័ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","អន់ឌែ ត្រគ់ ប៉្រគ័ រ៉ាណើះ សាំរ៉ាប់ ចារ ម៉ុត រ៉ាម៉ះ អាញ់ លូ ឃឿង ខង ទិណោ័ះ ពួយ អាញ់ តាំបាង កា អីស។ ");
INSERT INTO tpu_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«អន់ឌែ ត្រគ់ ប៉្រគ័ ហ៊ីប លូ អ៊្លង សាំងឡាញ់ អំពុ អ្លឹង ពៀរ ហាត់ ទងតិគ័ អំពុ កាន័ ម៉ោញ ហាត់ ទងតិគ័ ចាំងហីគ ម៉ោញ ហាត់ ទងតិគ័។ ");
INSERT INTO tpu_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","ត្រគ់ ប៉្រះ ចារ័ ម៉ាស ង៉ាតៗ ពឹង ហ៊ីប ណោះ ទឹប គែង កាណុង ទឹប គែង ឡីង កេះណោះ ត្រគ់ អ៊ប តារ់ ហ៊ីប លូ ម៉ាស អន់ ជុំ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ត្រគ់ ប៉្រគ័ គង ម៉ាស ប៉្វាន់ ចៃគ ប៉ាតឹត ពឹង ជួច គែង កាន់តេ័ះ ហ៊ីប ទិ ប៉្វាន់ ជួច។ ");
INSERT INTO tpu_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","កេះណោះ ត្រគ់ អ្យក់ អ៊្លង សាំងឡាញ់ ប៉្រគ័ អ៊្លង តាណូង័ ត្រគ់ ប៉្រះ ចារ័ ម៉ាស និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ត្រគ់ ស្រូ អ៊្លង តាណូង័ ពឹង គង ឡាក់ ប៉ាតឹត ពឹង ហ៊ីប ណោះ ទិ ពៀរ ប៊ែង ភឿ តូង័ ហ៊ីប ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","អ៊្លង តាណូង័ ត្រគ់ ចៃគ ពឹង គង ហ៊ីប ណោះ លើយ អូ ត្រគ់ អ្យក់ ឡាច់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ត្រគ់ ចៃគ សារ ឡាក់ អាញ់ ចឹង ច្រាគ់ រ៉ះ ឡាក់ អាញ់ ចឹង អន់ កា អីស ពឹង ហ៊ីប អា។ ");
INSERT INTO tpu_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","«ត្រគ់ ប៉្រគ័ កល់ កាត្រោប ហ៊ីប លូ ម៉ាស ង៉ាតៗ អំពុ អ្លឹង ពៀរ ហាត់ ទងតិគ័ លូ អំពុ កាន័ ម៉ោញ ហាត់ ទងតិគ័។ ");
INSERT INTO tpu_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","ត្រគ់ អ្យក់ ម៉ាស ប៉្រគ័ ហ៊ូប ចេរូប៊ីន ពៀរ ចៃគ ពឹង ឡាណុច កល់ កាត្រោប ហ៊ីប ទិ ពៀរ ប៊ែង។ ");
INSERT INTO tpu_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ត្រគ់ ប៉ាតឹត ហ៊ូប ចេរូប៊ីន ទិ ពៀរ ពឹង ឡាណុច កល់ កាត្រោប ហ៊ីប ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ត្រគ់ ចៃគ ចេរូប៊ីន ទិ ពៀរ ណោះ អន់ ង៉ីរ គួប អ៊ែ ទឹប អន់ ម៉ាត់ ហៃ កល់ កាត្រោប ហ៊ីប ទឹប ប៉ាហ្យាង កាហ្លាប អំប៉ាំង កល់ កាត្រោប ហ៊ីប ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ត្រគ់ ចៃគ សារ អាញ់ ចឹង ច្រាគ់ រ៉ះ ឡាក់ អាញ់ ចឹង អន់ កា អីស ណោះ ពឹង ហ៊ីប កេះណោះ អ្យក់ កល់ ហ៊ីប កាត្រោប។ ");
INSERT INTO tpu_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ហះ ណោះ ហង អាញ់ ចឹង ឡាំ កាប លូ អីស ហះ អន់តិគ័ ហ៊ូប ចេរូប៊ីន ទិ ពៀរ ឡាក់ អ្វៃ ពឹង ហ៊ីប សារ សាញ៉ា រែវ ពុត។ អាញ់ ចឹង រ៉ះ កា អីស គ្រឹប សារ ឡាក់ ត្រគ់ ប៉្រើ ប៉ាសុន អ៊ីស្រាអ៊ែល»។ … ");
INSERT INTO tpu_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«ត្រគ់ តាញ កាណាត់ សាំរ៉ាប់ ប៉ិង កាណុង លូ ព្រៀយ បាក ឡាក់ គឹត ខា ឡាយ លូ ព្រៀយ នែវ ខៀវ នែវ ណាំអ៊ិត លូ នែវ កាហ្រី។ កាណាត់ អា ត្រគ់ ប៉្រើ ពូ ជឹង ហ៊ូប ចេរូប៊ីន អន់ ដាគ់ ឡាយ៉ាម័។ ");
INSERT INTO tpu_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ត្រគ់ សាំប៉ាក័ កាណាត់ អា ពឹង អញ់ជុង ប៉្វាន់ ប៉្រគ័ លូ អ៊្លង សាំងឡាញ់។ អញ់ជុង ណោះ ត្រគ់ ប៉្រះ លូ ចារ័ ម៉ាស កេះណោះ តាគ់ អន់តាវ ពឹង ជុងតាង ប៉្វាន់ ប៉្រគ័ លូ ប៉្រាក់។ កាប៉ាច់ អង់វ៉ាក័ កា ត្រគ់ ប៉្រគ័ លូ ម៉ាស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","ត្រគ់ អ្យក់ កាណាត់ សាំប៉ាក័ ពឹង អង់វ៉ាក័ ទិណោ័ះ កេះណោះ អ្យក់ ហ៊ីប សារ សាញ៉ា រែវ ពុត ចៃគ ពឹង កាណុង ពូ ប៉ិង លូ កាណាត់ អា។ កាណាត់ អា ប៉ិង កាណុង ដាគ់ អន់ តាង ឡឹង កាណុង ដាគ់ កាខាក់ »។ … ");
INSERT INTO tpu_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«ត្រគ់ ប៉្រគ័ អន់ហ្នឹង រ៉ាម៉ះ ប‌៉្រ័ះ លូ អ៊្លង សាំងឡាញ់ អំពុ អ្លឹង ប៉ាតាម័ ហាត់ អំពុ កាន័ ប៉ាតាម័ ហាត់ ប៉្វាន់ ជួច សាម៉ើ ទៅ ចាំងហីគ ប៉ៃង ហាត់។ ");
INSERT INTO tpu_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ត្រគ់ ប៉្រគ័ អង់គែ អន់ហ្នឹង រ៉ាម៉ះ ប‌៉្រ័ះ ទិ ប៉្វាន់ ជួច ណោះ កេះណោះ ត្រគ់ ប៉្រះ លូ ចារ័ សាប៉ាន័»។ … ");
INSERT INTO tpu_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","«ត្រគ់ អើ អារ៉ុន ឡាក់ ម៉ី អីស ទឹប គន កាម៉ាក័ អ៊ែ ណាដាប អាប៊ីហ៊ូ អេឡាសារ លូ អ៊ីថាម៉ារ ឡឹង កាំឡាំង ប៉ាសុន អ៊ីស្រាអ៊ែល អន់ ម៉ុត អ្វៃ ក្យាម័ អីស ភឿ ប៉្រគ័ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ »។ … ");
INSERT INTO tpu_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ប៉ាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ កាកាប លូ វគ័ ម៉ូសេ ពឹង ប៉ានឹម ស៊ីណាយ ណោះ កេះ ទិ កេះ អ៊ែ អន់ អំហ្មោ ឡាត កា វគ័ ម៉ូសេ ពៀរ កាតុ ឡាក់ អ៊ែ ច្រាគ់ ចាបាប់ ពឹង អំហ្មោ ណោះ អ៊ែ ទៅ។ ");
INSERT INTO tpu_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","មួត ប៉ាសុន ហៃ កា អូ ប៉ប័ វគ័ ម៉ូសេ ជឹរ នីណោ័ះ អន់ឌែ ប៉ាណាំ គួប ឡាំ កាកាប លូ វគ័ អារ៉ុន ផា «ប៉រ់ អីស ប៉្រគ័ ហ៊ូប ប‌៉្រ័ះ សាំរ៉ាប់ ប៉ាណាំ ញឹន ពិ ខង ញឹន អូ អ្លុ អន់តគ់ ផា វគ័ ម៉ូសេ ឡាក់ ប៉ាណាំ ពិន ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ពែ អ៊ែ ទី សារ ញ៉ា កើត ពឹះ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","វគ័ អារ៉ុន រ៉ះ កា អន់ឌែ ផា «ហគ់ អន់ដីស ព្រិច អ្យក់ កាជន ម៉ាស ឡឹង តោរ គន កាម៉ាញ់ ប៉ាតុំ អន់ ទិ ប៉ាគ់ អាញ់ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","មួត ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ ព្រិច ឡាច់ កាជន ម៉ាស ឡឹង តោរ ឡាំ ជឹន អន់ កា វគ័ អារ៉ុន។ ");
INSERT INTO tpu_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","វគ័ អារ៉ុន អ្យក់ កាជន ម៉ាស អន់ឌែ អន់ ណោះ តូះ ប៉្រគ័ ហ៊ូប គន រ៉ក់ ម៉ោញ។ កេះណោះ អន់ឌែ ឡុង ផា «អឺ អ៊ីស្រាអ៊ែល អា ហង ប‌៉្រ័ះ ឡាក់ ប៉ាណាំ ពិន ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ពែ»។ ");
INSERT INTO tpu_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","វគ័ អារ៉ុន ប៉ប័ នីណោ័ះ កេះ អ៊ែ កា ប៉្រគ័ ចារ រ៉ាម៉ះ ម៉ោញ ហះ ម៉ាត់ ហ៊ូប រ៉ក់ កេះណោះ រ៉ះ ផា ដារ់ តាយ៉ាង័ ទៀ ចឹង ប៉្រគ័ ប៊ុន រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","ប៉ាគ់ ដារ់ តាយ៉ាង័ មួត ប៉ាសុន អ្យូវ ឡឹង កាំលឺ ផុងម៉ាំង ប៉ាណាំ គួប ពុះ អ្លាត កាណាគ័ សាំរ៉ាប់ រ៉ាម៉ះ ហ៊ូប រ៉ក់ ណោះ លូ ពុះ កាណាគ័ សា អន់ឌូ លូ គួប សោប ដេល។ កេះណោះ មួត ប៉ាសុន អន់ឌែ ប៉ាណាំ គួប អ្វៃ អៃត សា លូ កាតាប័ រ៉ល់ អង់គុន អន់ឌែ ប្លាល។ ");
INSERT INTO tpu_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហគ់ អីស សឹត ឡគ ពិ ខង ប៉ាសុន ឡាក់ អីស ប៉ាណាំ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ណោះ អន់ឌែ ប៉្រគ័ យច កាខាក់ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","អន់ឌែ ឡាម៉គ់ ពឹល ឡឹង សារ ឡាក់ អាញ់ តាំបាង កា អន់ឌែ ពែ កេះ។ អន់ឌែ តូះ ប៉្រគ័ ហ៊ូប គន រ៉ក់ ម៉ោញ កេះណោះ ជន តាកុល សាំប‌៉័ះ លូ ពុះ កាណាគ័ រ៉ាម៉ះ ហ៊ូប រ៉ក់ ណោះ ដេល។ អន់ឌែ កាប ផា \"អឺ អ៊ីស្រាអ៊ែល អា ហង ប‌៉្រ័ះ ឡាក់ ប៉ាណាំ អន់ដីស ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប\"»។ ");
INSERT INTO tpu_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ណាវ្គ ផា «អាញ់ អ្លុ អន់តគ់ ដេល កា ប៉ាសុន អា ស៊ុត កា ប៉ាណូស កាង័ កល់។ ");
INSERT INTO tpu_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","កិញអៀ អា អាញ់ ចឹង ថាំឡាយ អ្លាត មួត ប៉ាសុន អា អន់ ទិ ប៉្យើះ ប៉ុប ពុត អាញ់ អឺក ឡូត ជែ ប៉ាំងក្រូ អាញ់ ហង។ កេះណោះ អាញ់ ចឹង ប៉្រគ័ អន់ សុនសាត ម៉ោញ ឡាក់ អៀង កាខាក់ អន់ កើត ឡាច់ ឡឹង អីស ឡគ»។ ");
INSERT INTO tpu_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","ហះកា វគ័ ម៉ូសេ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អ៊ែ ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័  ញ៉ា ត្រគ់ អីស អឺក ខាក់ កា ប៉ាសុន ឡាក់ អីស ប៉ាណាំ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប លូ សារ អំរ៉ាញ អឺញ កេង ខាក់ នីអៀ ? ");
INSERT INTO tpu_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","ប៉រ់ អីស ជែ អឺក ហង កា អន់ឌែ ណោះ លូ រ៉ើ ពុត ឡាក់ អីស ឃឹត ចឹង ប៉្រគ័ អន់ ប៉ាសុន អីស រ៉ាយ រ៉ាំ ណោះ ពិ។ ជែ អន់ សុនសាត អ៊ីស៊ីប កាប ផា អីស ប៉ាណាំ សុនសាត អ៊ីស្រាអ៊ែល ឡាច់ ឡឹង ប៉ាថេត អន់ឌែ ញន កា អីស ទី ពុត អូ ដាគ់ ប៉ិច ប៉ាន់តោ័ ប៉ាសុន រប៉ានឹម លូ ប៉ិច ថាំឡាយ អ្លាត ប៉ាសុន អន់ ទិ ប៉្យើះ ឡឹង អង់កក់ តេះ។ ");
INSERT INTO tpu_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ប៉រ់ អីស កាចាំង ឡឹង សារ អីស ម៉ត់ អ្យក់ សិច អីស ទៅ សាញ៉ា លូ វគ័ អាប៉្រាហាំ អ៊ីសាក់ លូ យ៉ាកុប ឡាក់ មួត ទុច អីស។ អីស ផា ចឹង ប៉្រគ័ អន់ គន សោ ផូង័ វ៉ាច់ អន់ឌែ ទី ចំលួន អៀង ឡាក់ កា សំឡង់ ពឹង ប៉្លៃង។ អីស ផា ចឹង មប អន់ ប៉ាថេត ឡាក់ អីស សាញ៉ា ណោះ អន់ កា ផូង័ វ៉ាច់ អន់ឌែ អន់ឌែ ចឹង អ្យក់ ប៉ាថេត ណោះ ប៉្រគ័ ប៉ាដក់ ប៉ាជៀ អន់ឌែ លើយ»។ ");
INSERT INTO tpu_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","ប‌៉្រ័ះ ប៊កកាតយ័ កា រ៉ើ ពុត អូ ជៀ ប៉ាន់តោ័ ប៉ាសុន អ៊ែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","កេះណោះ វគ័ ម៉ូសេ ជឹរ ឡឹង ប៉ានឹម ចឹក សឹត អំហ្មោ ឡាត ពៀរ ឡាក់ ទី ច្រាគ់ សារ សាញ៉ា រែវ ពុត ។ ពឹង អំហ្មោ ណោះ ទី សត់ត្រា ទិ ពៀរ ប៊ែង។ ");
INSERT INTO tpu_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","អំហ្មោ ឡាត អា ឃឺ ប‌៉្រ័ះ ប៊កកាតយ័ ទៅ ឡាក់ ប៉្រគ័ អ៊ែ កា ច្រាគ់ សត់ត្រា ពឹង អំហ្មោ ណោះ អ៊ែ ទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","ផះ យូស្វេ កាតាំង ប៉ានឹរ មួត ប៉ាសុន ឡុង តាំងហើ អ៊ែ រ៉ះ លូ វគ័ ម៉ូសេ ផា «កាតាំង ប៉ានឹរ ពូ តាកូះ លូ គួប សោប ប៉ាគ់ ចារ រ៉ាណើះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","វគ័ ម៉ូសេ តើល ផា «អូ ត្រគ់ ប៉ានឹរ ពូ អង់ហ្យាំង ឡុង តាំងហើ កា ពូ សាណ័ះ លើ ប៉ានឹរ ពូ អង់ហ្យាំង រ៉ាវ៉ើក ថើក កា ពូ អូ សាណ័ះ ណោះ អុះ អាញ់ កាតាំង អាញ់ ឃឺ ប៉ានឹរ ពូ យ៉ិល»។ ");
INSERT INTO tpu_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","ប៉ាគ់ អន់ឌែ ក្យាម័ ចឹង ទឹល រ៉ាណើះ កេះ វគ័ ម៉ូសេ ប៉ប័ ហ៊ូប គន រ៉ក់ លូ ប៉ប័ មួត ប៉ាសុន ផះ កាតាប័ រ៉ល់។ វគ័ ម៉ូសេ អឺក ខាក់ អ៊ែ សាន់តាគ់ អ្លាត អំហ្មោ ឡាត អ៊ែ ចឹក ណោះ ហះ ជុង ប៉ានឹម អន់ ប៉ាទុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","វគ័ ម៉ូសេ អ្យក់ ហ៊ូប រ៉ក់ ពូ ប៉្រគ័ ណោះ ពុះ ពឹង អុញ កេះណោះ គស អន់ ហាច់ កេះ តាប៉ុង អ៊ែ អ្យក់ តាប៉ុង ណោះ ចៃគ ពឹង ទៀក អន់ កា សុនសាត អ៊ីស្រាអ៊ែល អៃត។ ");
INSERT INTO tpu_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","កេះណោះ អ៊ែ ឡាំ អំប៉ញ់ លូ វគ័ អារ៉ុន ផា «មួត ប៉ាសុន អា ប៉្រគ័ នីចម័ កា អីស បះ អីស ណាំផា អន់ អន់ឌែ ប៉្រគ័ យច យ៉ឹប ខាក់ នីអៀ ?» ");
INSERT INTO tpu_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","វគ័ អារ៉ុន តើល ផា «ពឹ តាំងឡា អីស ជែ អឺក អីស កា អ្លុ អន់តគ់ កេះ មួត ប៉ាសុន អា អន់ឌែ ប៉ិច ដឹង ប៉្រគ័ សារ អូ ដាគ់។ ");
INSERT INTO tpu_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","អន់ឌែ ប៉ាណាំ គួប ឡាំ រ៉ះ លូ អាញ់ ផា \"ប៉រ់ អីស ប៉្រគ័ ហ៊ូប ប‌៉្រ័ះ សាំរ៉ាប់ ប៉ាណាំ ញឹន ពិ ខង ញឹន អូ អ្លុ អន់តគ់ ផា វគ័ ម៉ូសេ ឡាក់ ប៉ាណាំ ពិន ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ពែ អ៊ែ ទី សារ ញ៉ា កើត ពឹះ អុះ\"។ ");
INSERT INTO tpu_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","កេះណោះ អាញ់ កា រ៉ះ កា អន់ឌែ ផា \"ពឿ ទី ម៉ាស អ្យក់ ឡាំ ជឹន អន់ កា អាញ់\"។ អន់ឌែ កា ព្រិច អ្យក់ កាជន ម៉ាស ឡាំ ជឹន កា អាញ់ តាទឹច អាញ់ អ្យក់ ម៉ាស ណោះ ប៉ាឡិ ទិ ពឹង អុញ ផាឌី កេះ ហ៊ូប គន រ៉ក់ អា ហង»។ ");
INSERT INTO tpu_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","វគ័ ម៉ូសេ ហៃ កា វគ័ អារ៉ុន ទឹមវ៉ៃរ អន់ ប៉ាសុន ប៉្រគ័ តាម ពុត ប៉ិច ឡាក់ ប៉្រគ័ អន់ មួត តាម៉ឺរ បឺង៉ាយ។ ");
INSERT INTO tpu_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ទឹល នីណោ័ះ អ៊ែ ឡាំ អន់តាវ ហះ អំប៉ារ ទ្រួក ម៉ុត ពឹង ចារ រ៉ាណើះ កេះណោះ កាប ផា «ពឿ ប៉ិច កា ប‌៉្រ័ះ ប៊កកាតយ័  ប៉ាណូស ណោះ ឡាំ អ្វៃ គែង អាញ់»។ មួត គន សោ លេវី ទិឌូ ប៉ាណាំ គួប ឡាំ អ្វៃ ជុំ វគ័ ម៉ូសេ។ ");
INSERT INTO tpu_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","កេះណោះ វគ័ ម៉ូសេ រ៉ះ កា អន់ឌែ ផា «ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល អ៊ែ រ៉ះ ផា នីអៀ អន់ដីស ត្រគ់ ចោ ដាវ ដូវ ម៉ោញ ៗ ចាក សឹត ចាក ឡាំ ឡឹង អំប៉ារ អា ឡាំ ប៉ាគ់ តោ កេះណោះ កោះ ប៉ាន់តោ័ អុះ ម៉ី គួប សោប លូ កាំឡាំង ឡាក់ អ្វៃ រសានែង អន់ដីស ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","គន សោ លេវី ប៉ាណាំ គួប ប៉្រគ័ ពួយ ប៉ានឹរ វគ័ ម៉ូសេ រ៉ះ។ ដារ់ ណោះ សុនសាត អ៊ីស្រាអ៊ែល មួត កាម៉ាក័ តោ័ ទិ ៣០០០ ដូវ។ ");
INSERT INTO tpu_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","កេះណោះ វគ័ ម៉ូសេ រ៉ះ ផា «ដារ់ អា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ើស អន់ដីស ប៉្រគ័ ង៉ារ អ៊ែ កេះ ខង អន់ដីស អូ ប៉ាគែក ឡឹង សារ កោះ ប៉ាន់តោ័ អុះ ម៉ី ទៅ អ៊ែ កា អន់ សារ ដាគ់ កា អន់ដីស កាណុង ដារ់ អា»។ ");
INSERT INTO tpu_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ប៉ាគ់ ដារ់ តាយ៉ាង័ វគ័ ម៉ូសេ រ៉ះ កា ប៉ាសុន ផា «អន់ដីស ប៉្រគ័ យច កាខាក់ កេះ។ កិញអៀ អា អាញ់ ត្រគ់ ហាវ ពឹង ប៉ានឹម ឡាំ ប៉ាគ់ ចារ ប‌៉្រ័ះ ប៊កកាតយ័ ម៉ោញ ទង ណាវ្គ ឃឺ អាញ់ ចឹង ប៉រ់ ឡោម ជែ អន់ អ៊ែ អ្យក់ យ៉ូ សារ អន់ដីស ប៉្រគ័ យច ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","កេះណោះ វគ័ ម៉ូសេ កា ហាវ ពឹង ប៉ានឹម ឡាំ ប៉ាគ់ ចារ ប‌៉្រ័ះ ប៊កកាតយ័ ណាវ្គ លូ រ៉ះ ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាសុន អា ប៉្រគ័ យច យ៉ឹប ខាក់ អន់ឌែ អ្យក់ ម៉ាស តូះ ប៉្រគ័ ហ៊ូប ប‌៉្រ័ះ សាំរ៉ាប់ អន់ឌែ ទៅ។ ");
INSERT INTO tpu_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ប៉រ់ អីស តាប៉ាប តាប៉ុន ជែ អ្យក់ យ៉ូ សារ អន់ឌែ ប៉្រគ័ យច ណោះ។ ផា អូ នីណោ័ះ ប៉រ់ អីស អ៊្យូត ឡាច់ សិច អាញ់ ឡឹង ផាប់ ចារ អីស ច្រាគ់ សិច ប៉ាសុន អីស»។ ");
INSERT INTO tpu_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ពឿ ប៉្រគ័ យច ប៉ិច តាប៉ុញ លូ អាញ់ អាញ់ ចឹង អ៊្យូត ឡាច់ សិច អ៊ែ ណោះ ឡឹង ផាប់ អាញ់ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ហគ់ អីស ចាក កិញអៀ ហង ពិ ប៉ាណាំ ប៉ាសុន ឡាំ ប៉ាគ់ ចារ ឡាក់ អាញ់ រ៉ះ កា អីស ណោះ ប៊យ អាញ់ ចឹង ចាក អន់ទ្រួល ប៉ាណាំ ទ្រង កា អីស។ ហះកា ប៉ាគ់ ទឹល ដារ់ ចៃគ ថូត ទៀ ណោះ អាញ់ ចឹង ចៃគ ថូត អន់ឌែ ញន កា សារ យច ឡាក់ អន់ឌែ ប៉្រគ័ ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ ប៉ាសុន អីគ ប៉ាណាប ខង អន់ឌែ ប៉្រើ វគ័ អារ៉ុន ប៉្រគ័ ហ៊ូប គន រ៉ក់។ ");
INSERT INTO tpu_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","ឡៃង ឡឹង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហគ់ អីស លូ មួត ប៉ាសុន ឡាក់ អីស ប៉ាណាំ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ណោះ អន់ដីស ឡាច់ ឡឹង ចារ អា ពិ។ កេះណោះ អន់ដីស ឡាំ ប៉ាគ់ ប៉ាថេត ឡាក់ អាញ់ ម៉ត់ លូ អាប៉្រាហាំ អ៊ីសាក់ លូ យ៉ាកុប ពែ អាញ់ ផា ចឹង មប ប៉ាថេត ណោះ អន់ កា ផូង័ វ៉ាច់ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","អាញ់ ចឹង ប៉្រើ ប៊យ អាញ់ ចាក អន់ទ្រួល ភឿ ប៉ាណាំ ទ្រង កា អីស លូ អាញ់ ចឹង ទ្រុះ ឡាច់ សុនសាត កាណាន សុនសាត អាម៉ូរី សុនសាត ហេត សុនសាត ពែរិស៊ីត សុនសាត ហេវី លូ សុនសាត យេប៊ូស។ ");
INSERT INTO tpu_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","កេះណោះ អន់ដីស ចឹង ម៉ុត អ្វៃ ពឹង ប៉ាថេត ឡាក់ ដាគ់ សាណា ខាក់ ទឹប ទី ទៀក សុត លូ ទៀក តុះ រ៉ក់ អៀង កាខាក់ ហះកា អាញ់ អូ អ្វៃ អន់ឌូ លូ អន់ដីស អុះ អន់ទៀ អាញ់ ប៉្រគ័ អន់ អន់ដីស តោ័ ទិ រទ្រង ខង អន់ដីស ឡាក់ ប៉ាសុន កាង័ កល់»។ ");
INSERT INTO tpu_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","5","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហគ់ អីស រ៉ះ កា សុនសាត អ៊ីស្រាអ៊ែល ណោះ នីអៀ អន់ដីស ឡាក់ ប៉ាសុន កាង័ កល់ ផា អាញ់ អ្វៃ អន់ឌូ លូ អន់ដីស ម៉ោញ ទ្រុ កាតាម អាញ់ ចឹង ថាំឡាយ អ្លាត អន់ដីស អន់ ទិ ប៉្យើះ។ ហគ់ តាឡេះ ឡាច់ ឃឿង ម៉ាស ប៉្រាក់ លូ រ៉ីស អ្លាត ខោ អាវ ដាគ់ ឡាយ៉ាម័ ឡឹង ឡាកោ អន់ដីស កិញអៀ ហង ពិ កេះណោះ អាញ់ ចឹង ឃឹត ត្រគ់ ប៉្រគ័ នីចម័ កា អន់ដីស អា»។ ផះ ប៉ាសុន កាតាំង ប៉ានឹរ ប‌៉្រ័ះ ផា នីណោ័ះ អន់ឌែ អុក ពុត ខាក់ លូ អូ ទី បក់ ពឿ ទ្រុង ឃឿង ម៉ាស ប៉្រាក់ លើ កាស៊ប ពៀត ខោ អាវ ដាគ់ ឡាយ៉ាម័ ណាវ្គ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ឡៃង ឡឹង អន់ឌែ ឡាច់ ឡឹង ប៉ានឹម ស៊ីណាយ ប៉ាសុន អ៊ីស្រាអ៊ែល អ្លាត អូ ទ្រុង ឃឿង ម៉ាស ប៉្រាក់ ណាវ្គ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","រ៉ប់ ប៉ាសុន អ៊ីស្រាអ៊ែល ប៉្រគ័ រ៉ាណើះ វគ័ ម៉ូសេ កា ប៉្រគ័ រ៉ាណើះ ម៉ោញ គែង ឡីង ចាំងហាយ្គ ឡឹង មួត ប៉ាសុន ប៊ែត ចារ អា អ៊ែ អើ ផា រ៉ាណើះ កាកាប លូ ប‌៉្រ័ះ។ ផា ពឿ ប៉ិច ឡាំ ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ត្រគ់ ឡាច់ គែង ឡីង ឡាំ ប៉ាគ់ រ៉ាណើះ កាកាប លូ ប‌៉្រ័ះ តោ។ ");
INSERT INTO tpu_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","រ៉ប់ វគ័ ម៉ូសេ ឡាំ ប៉ាគ់ រ៉ាណើះ កាកាប លូ ប‌៉្រ័ះ មួត ប៉ាសុន ទិឌូ អន់តាវ ហៃ ឡឹង អំប៉ារ រ៉ាណើះ អន់ឌែ ទៅ សាលយ ហៃ វគ័ ម៉ូសេ ទឹល អ៊ែ ម៉ុត កាណុង រ៉ាណើះ កាកាប លូ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","ប៉ាគ់ វគ័ ម៉ូសេ ម៉ុត កាណុង រ៉ាណើះ កាកាប លូ ប‌៉្រ័ះ កេះ កាម៉ល់ កា ជឹរ អ្វៃ ហះ អំប៉ារ រ៉ាណើះ កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កាកាប លូ វគ័ ម៉ូសេ។ ");
INSERT INTO tpu_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ផះ ប៉ាសុន ទិឌូ ប៉ប័ កាម៉ល់ ជឹរ អ្វៃ ហះ អំប៉ារ រ៉ាណើះ កាកាប លូ ប‌៉្រ័ះ អន់ឌែ កា ជន តាកុល សាំប‌៉័ះ ប‌៉្រ័ះ អ្វៃ ឡឹង អំប៉ារ រ៉ាណើះ អន់ឌែ ទៅ។ ");
INSERT INTO tpu_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ប‌៉្រ័ះ ប៊កកាតយ័ ឃើយ កាកាប លូ វគ័ ម៉ូសេ ហះ ង៉ីរ ឡាក់ កា ចាង័ អ្វៃ រ៉ះ សារ លូ គួប សោប។ កេះណោះ វគ័ ម៉ូសេ សឹត ប៉ាគ់ រ៉ាណើះ អ៊ែ ទៅ ណាវ្គ។ កាប៉ាច់ យូស្វេ គន វគ័ នូន ឡាក់ តាតាម័ តង័ ង៉ារ វគ័ ម៉ូសេ អ៊ែ អូ ទី ឡាច់ ឡឹង រ៉ាណើះ កាកាប លូ ប‌៉្រ័ះ ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","កេះណោះ វគ័ ម៉ូសេ តើល ប‌៉្រ័ះ ប៊កកាតយ័ ផា «ហៃ អីស ប៉្រើ អាញ់ ប៉ាណាំ ប៉ាសុន ឡាំ ប៉ាគ់ ប៉ាថេត អីស សាញ៉ា ណោះ។ អីស រ៉ះ ផា អីស អន់ហ្នាល់ អាញ់ ឡាក់ ខាក់ លូ ត្រគ់ ពុត អីស ដេល ហះកា អីស អូ ទី រ៉ះ អន់ អាញ់ អ្លុ អន់តគ់ ពឿ អីស ចឹង ប៉្រើ ឡាំ អន់ឌូ លូ អាញ់ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","កិញអៀ អា ផា អាញ់ អា ត្រគ់ ពុត អីស តាទឹច ប៉រ់ អីស រ៉ះ សារ អីស ឃឹត ចឹង ប៉្រគ័ ណោះ កា អាញ់ ណើ ភឿ អន់ អាញ់ អន់ហ្នាល់ អីស លូ អន់ ត្រគ់ ពុត អីស តាទឹច។ អីស កាចាំង ប មួត ប៉ាសុន អា ឡាក់ ប៉ាសុន អីស ?» ");
INSERT INTO tpu_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ផា «អាញ់ ចឹង ឡាំ អន់ឌូ លូ អីស លូ អន់ អីស អ្វៃ សាណុក សាវ៉ាក ហង»។ ");
INSERT INTO tpu_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","វគ័ ម៉ូសេ តើល ផា «ផា អីស អូ ឡាំ អន់ឌូ លូ ញឹន អីស ជែ អន់ ញឹន ឡាច់ ឡឹង ចារ អា។ ");
INSERT INTO tpu_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","នីចម័ ពូ ចឹង អ្លុ អន់តគ់ ផា អាញ់ លូ ប៉ាសុន អីស អា ត្រគ់ ពុត អីស តាទឹច ? ទឹល នីណោ័ះ ទី ដឹង កា អីស ឡាំ អន់ឌូ លូ ញឹន ដេល ពូ ចឹង ប៉ប័ អាញ់ លូ ប៉ាសុន អីស អា យច ឡឹង សុនសាត អន់ទៀគៗ ទិណោ័ះ ឡាក់ អ្វៃ ពឹង អង់កក់ តេះ អា»។ ");
INSERT INTO tpu_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «អាញ់ ចឹង ប៉្រគ័ ពួយ សារ អីស ប៉រ់ ណោះ ខង អីស ឡាក់ ប៉ាណូស ត្រគ់ ពុត អាញ់ ទឹប អាញ់ អន់ហ្នាល់ អីស ឡាក់ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","កេះណោះ វគ័ ម៉ូសេ កាប ណាវ្គ ផា «ប៉រ់ អីស តាំបាង តាតារ ក្លាគ់ អីស ណោះ អន់ អាញ់ ប៉ប័ ណើ»។ ");
INSERT INTO tpu_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ផា «អាញ់ ចឹង តាំបាង សារ ដាគ់ ត្រង់ ម៉ះ អាញ់ ទិណោ័ះ ហះ ម៉ាត់ អីស លូ ចឹង រ៉ះ សិច អាញ់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ហះ ម៉ាត់ អីស ដេល។ អាញ់ ចឹង ដាគ់ ពុត កា ប៉ាណូស ចំ ឡាក់ អាញ់ ប៉ិច ដាគ់ ពុត អាញ់ ចឹង ទី ពុត តាប៉ាប តាប៉ុន កា ប៉ាណូស បក់ អ៊ែ ចំ ឡាក់ អាញ់ ប៉ិច តាប៉ាប តាប៉ុន ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ហះកា អាញ់ អូ អន់ អីស ប៉ប័ ម៉ូះ ម៉ាត់ អាញ់ អុះ ខង អូ ទី ប៉ាណូស ពឿ ប៉ប័ ម៉ូះ ម៉ាត់ អាញ់ កេះណោះ អ្វៃ រ៉ីស ណាវ្គ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","អីស ចឹង តាវ ក្យាម័ អាញ់ អំប៉ាំង អំហ្មោ ហះ ចារ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ប៉ាគ់ តាតារ ក្លាគ់ ម៉ះ អាញ់ ឃ្លង ទ្រង ណោះ ទៀ អាញ់ ចឹង អោន អីស កាណុង ត្រោម អំហ្មោ កេះណោះ អាញ់ ចឹង កាន់ទឹង អីស លូ តី លើយ ទឹល អាញ់ ឃ្លង អីស រ៉ាវ៉ាច់។ ");
INSERT INTO tpu_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","កេះណោះ អាញ់ ចឹង អ្យក់ ឡាច់ តី អាញ់ អីស ចឹង ប៉ប័ អង់កក់ អាញ់ ខង អូ ទី ពឿ ហៃ ប៉ប័ ម៉ូះ ម៉ាត់ អាញ់ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហគ់ អីស ផាត ប៉្រគ័ អំហ្មោ ឡាត ពៀរ ប៉ក់ ឡាក់ កា អំហ្មោ ឡាត អន់ទ្រួល ពែ ហង អាញ់ ចឹង ច្រាគ់ ទិ សារ ឡាក់ អាញ់ ច្រាគ់ ពឹង អំហ្មោ ឡាត ឡាក់ អីស តាគ់ ប៉ាទុះ អន់ទ្រួល ពែ ទៅ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","អ្យគ័ អីស ទ្រៀម ឡាកោ អ្យូវ ឡឹង កាំលឺ ឡាំ ប៉ាគ់ ប៉ានឹម ស៊ីណាយ កេះណោះ អ្វៃ ក្យាគ់ អាញ់ ពឹង កល់ ប៉ានឹម ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","អូ អន់ ពឿ ហាវ អន់ឌូ លូ អីស អុះ លូ អូ អន់ ពឿ អ្វៃ ពឹង ប៉ានឹម អា ដេល យ‌៉័ះ ប៉ារ់ពេ ចៀម លូ រ៉ក់ កាតាម កា អូ អន់ ឡាំ សា សាម៉ោង រជុង ប៉ានឹម អា ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","កេះណោះ វគ័ ម៉ូសេ កា ផាត ប៉្រគ័ អំហ្មោ ឡាត ពៀរ ប៉ក់ ឡាក់ កា អំហ្មោ ឡាត អន់ទ្រួល ពែ ទៅ ហង។ អ៊ែ អ្យូវ ឡឹង កាំលឺ ផុងម៉ាំង ឡាំ ប៉ាគ់ ប៉ានឹម ស៊ីណាយ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ លូ ចឹក ឡាំ ទឹប អំហ្មោ ឡាត ពៀរ ប៉ក់ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ ពឹង កាម៉ល់ ជឹរ អ្វៃ ហះ សានែង វគ័ ម៉ូសេ លូ រ៉ះ សិច អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ចាក ទ្រួង ម៉ាត់ វគ័ ម៉ូសេ លូ រ៉ះ ផា «អាញ់ អា ហង ប‌៉្រ័ះ ប៊កកាតយ័  ឡាក់ ប‌៉្រ័ះ ទី ពុត តាប៉ាប តាប៉ុន លូ ទី ពុត ប៉ិច ចៃ។ អាញ់ ទី ពុត អត់ សាំរ៉ាញ័ លូ ទី ពុត ដាគ់ ត្រង់ លើយ។ ");
INSERT INTO tpu_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","អាញ់ ចឹង តាំបាង សារ អាញ់ ប៉ិច ចៃ កា បក់ សឿ អាញ់ លើយ ទឹល ញ៉ាង រ៉ាពូ រ៉ាំងហាវ លូ អាញ់ អូ អ្យក់ យ៉ូ សារ យច លូ សារ អូ ដាគ់ ឡាក់ អន់ឌែ ប៉្រគ័។ ហះកា ប៉ាណូស បក់ ប៉្រគ័ យច ប៉ាសាំង លូ អាញ់ អាញ់ ចឹង ចៃគ ថូត ប៉ាណូស ណោះ ឡឹង ពឹ ទឹល គន សោ ប៉ៃង ប៉្វាន់ រ៉ាំងហាវ ឡូត»។ ");
INSERT INTO tpu_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","វគ័ ម៉ូសេ កា ប៉ាន់តាន ជន តាកុល សាំប‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័ មូប កល់ ទឹះ តេះ។ ");
INSERT INTO tpu_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","កេះណោះ វគ័ ម៉ូសេ កាប ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ផា អីស ប៉ាញ័ ពុត កា អាញ់ តាទឹច ប៉រ់ អីស ឡាំ អន់ឌូ លូ ញឹន ដេល យ‌៉័ះ ប៉ាសុន អា ឡាក់ ប៉ាណូស កាង័ កល់ កាតាម។ ប៉រ់ អីស ជែ អ្យក់ យ៉ូ សារ យច លូ សារ អូ ដាគ់ ឡាក់ ញឹន ប៉្រគ័ ណោះ ប៉រ់ អីស អ្យក់ ញឹន ប៉្រគ័ ប៉ាសុន អីស ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «កិញអៀ អា អាញ់ ចឹង សាញ៉ា រែវ ពុត លូ អន់ដីស ទឹប អាញ់ ចឹង តាំបាង សារ អំរ៉ាញ អឺញ កេង ខាក់ អន់ សុនសាត អ៊ីស្រាអ៊ែល ប៉ប័ ឡាក់ សារ អំរ៉ាញ អឺញ កេង ខាក់ ឡឹង សើគ ឡឹង ពែ ពូ អូ ឃើយ ប៉ប័ ទី ពឹង អង់កក់ តេះ អា។ សុនសាត អន់ទៀគៗ ឡាក់ អ្វៃ រសានែង អន់ដីស ពូ ចឹង អ្យូគ ខាក់ ប៉ប័ សារ អាញ់ ប៉្រើ អន់ដីស ប៉្រគ័ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","អន់ដីស ត្រគ់ អ្យក់ ពុត ចៃគ លូ ប៉្រគ័ ពួយ សារ អាញ់ អន់តគ់ រ៉ះ កា អីស ដារ់ អា។ អាញ់ ចឹង ទ្រុះ ឡាច់ សុនសាត អាម៉ូរី សុនសាត កាណាន សុនសាត ហេត សុនសាត ពែរិស៊ីត សុនសាត ហេវី លូ សុនសាត យេប៊ូស អន់ អន់ឌែ ឡាច់ ឡឹង ម៉ាត់ អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","អន់ដីស ត្រគ់ ឡាវ៉ាំង ជែ សាញ៉ា ប៉្រគ័ គួប លូ មួត សុនសាត កាណុង ប៉ាថេត ឡាក់ អន់ដីស ចឹង ម៉ុត អ្វៃ ណោះ អ្យូគ ត្រគ់ សាទួង ពូ។ ");
INSERT INTO tpu_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","ហះកា អន់ដីស ត្រគ់ តាគ់ អំព្លូក ចារ អន់ឌែ រ៉ាម៉ះ ប‌៉្រ័ះ អន់ឌែ។ ហ៊ូប ប‌៉្រ័ះ អន់ឌែ ប៉្រគ័ លូ អំហ្មោ អន់ដីស ត្រគ់ កាមៃ តាគ់ ប៉ាទុះ លូ ហ៊ូប ប‌៉្រ័ះ អន់ឌែ ប៉្រគ័ លូ អ៊្លង ត្រគ់ កាល់ តាគ់ អំព្លូក ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","អូ អន់ អន់ដីស សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ អន់ទៀគ ណាវ្គ អុះ ខង អាញ់ ឡាក់ ប‌៉្រ័ះ ក្យាគ់ កាខាក់ អូ អន់ អន់ដីស ប៉ិច កា ប‌៉្រ័ះ អន់ទៀគ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","ជែ សាញ៉ា ប៉្រគ័ គួប លូ មួត សុនសាត កាណុង ប៉ាថេត ណោះ អ្យូគ ផាហៃគ ប៉ាគ់ អន់ឌែ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ អន់ឌែ ទៀ អន់ឌែ ចឹង ជៀក អន់ដីស ម៉ុត សា សាណា ណោះ អន់ឌូ លូ អន់ឌែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ម៉ោញ ណាវ្គ ផា គន កាម៉ាក័ អន់ដីស ទី គន អង់កាន់ អន់ឌែ ប៉ាគ់ អង់កាន់ ណោះ ឡាំ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ អន់ឌែ ទៀ អ៊ែ ចឹង ប៉្រគ័ អន់ កា គន កាម៉ាក័ អន់ដីស ចឹង ទី ពុត អូ ត្រង់ លូ អាញ់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","«ជែ អ្យក់ ម៉ាស ប៉្រាក់ សាប៉ាន័ តូះ ប៉្រគ័ ហ៊ូប ប‌៉្រ័ះ សាំរ៉ាប់ អន់ដីស ដៃ។ ");
INSERT INTO tpu_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«ប៉ាគ់ ទឹល ខៃ ១ ដារ់ កាំឡត់ អន់ដីស ត្រគ់ ប៉្រគ័ ប៊ុន ណុំ ប៉ាំង ឡាតាំង។ អន់ដីស ត្រគ់ សា ណុំ ប៉ាំង អូ ចៃគ ពុះ ណោះ ចំលួន តាំប៉ើះ ដារ់ ឡាក់ កា អាញ់ អន់តគ់ រ៉ះ កា អន់ដីស ណោះ ហង ខង កាណុង ខៃ ១ ណោះ ហង អាញ់ ប៉ាណាំ អន់ដីស ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ពែ។ ");
INSERT INTO tpu_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«មួត កាម៉ាក័ ឡាក់ គន ឡោងទ្រៀ ទិឌូ ឃឺ ម៉ះ អាញ់ យ‌៉័ះ គន ចៀម គន រ៉ក់ គន ទោល កាណាគ័ រង ទិណោ័ះ ឡាក់ កើត ប៉ាន់ដា កា ម៉ះ សាន់ទួ អាញ់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","ផា គន លៀ ទោល កើត ប៉ាន់ដា អន់ដីស ត្រគ់ ហ្វាយ អ៊ែ លូ គន ចៀម ផា អន់ដីស អូ ចៃ ហ្វាយ ត្រគ់ កាមៃ អន់ ប៉ាក់ អង់កូ គន លៀ ណោះ។ គន កាម៉ាក័ អន់ដីស បក់ ឡោងទ្រៀ កា អន់ដីស ត្រគ់ ហ្វាយ និះទៅ ដេល។ «អន់ដីស អូ ត្រគ់ ម៉ុត ប៉ាគ់ ង៉ីរ អាញ់ តី តាដោះ ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","«អន់ដីស ត្រគ់ ប៉្រគ័ ង៉ារ ដឹង រ៉ាំងវ៉ាង ត្រោ ដារ់ ហះកា ប៉ាគ់ ទឹល ដារ់ ទី តាំប៉ើះ អន់ដីស ត្រគ់ រ៉ាឡូវ។ យ‌៉័ះ ថុន ជីក ថុន ករ់ លើ ថុន ច្រូត័ ថុន កាច់ កាតាម កា អន់ដីស ត្រគ់ រ៉ាឡូវ និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«ប៉ាគ់ ប៉ាន់ដា ច្រូត័ កាច់ ពៀ អន់ដីស ត្រគ់ ប៉្រគ័ ប៊ុន ច្រូត័ លូ ទៀន ពៀ ឡាក់ ច្រូត័ អន់ទ្រួល អន់ កា អាញ់។ កេះណោះ ប៉្រគ័ ប៊ុន ប៉ាតុំ សាណា ក្យង់ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","កាណុង ម៉ោញ សាណាំ មួត កាម៉ាក័ ទិឌូ ត្រគ់ ឡាំ តាំបាង ឡាកោ ហះ ម៉ាត់ អាញ់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល អន់ ទី ប៉ៃង ទង។ ");
INSERT INTO tpu_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","យ‌៉័ះ អន់ដីស ចាក ឡាំ តាំបាង ឡាកោ ហះ ម៉ាត់ អាញ់ ប៉ៃង ទង កាណុង ម៉ោញ សាណាំ កាតាម កា អូ ទី ពឿ ចឹង រ៉ាត អ្យក់ តេះ អន់ដីស អុះ ខង អាញ់ ចឹង ទ្រុះ ឡាច់ សុនសាត អន់ទៀគ ឡឹង ម៉ាត់ អន់ដីស ទៀ លូ ចឹង ប៉ារ៉ាយ្គ តាគ់ អន់តីស ប៉ាថេត អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«អូ អន់ អ្យក់ ណុំ ប៉ាំង ចៃគ ពុះ ទៀន អន់ឌូ លូ កាណាគ័ ពុះ រ៉ាម៉ះ អាញ់ អុះ។ រ៉ាឡា អ្យាំ ឡាក់ រ៉ាម៉ះ ប‌៉្រ័ះ ប៉្រគ័ ប៊ុន ទ្រួង ណោះ ជែ គម អន់ ទឹល កាំលឺ។ ");
INSERT INTO tpu_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","អន់ដីស ត្រគ់ អ្យក់ សាណា សាណឹត ឡាក់ អ្យក់ អន់ទ្រួល ឡាក់ ដាគ់ កាខាក់ ទៀន អន់ កាណុង ចារ រ៉ាម៉ះ អាញ់ ឡាក់ ប‌៉្រ័ះ អន់ដីស ដេល។ «ជែ សាន់តុក គន ប៉ារ់ពេ លូ ទៀក តុះ ម៉ៃគ អ៊ែ»។ ");
INSERT INTO tpu_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ណាវ្គ ផា «ហគ់ អីស ច្រាគ់ គម ប៉ានឹរ អាញ់ រ៉ះ ទិ អា ខង ប៉ានឹរ ទិ អា ឡាក់ ប៉ានឹរ អាញ់ ទី សាញ៉ា រែវ ពុត លូ អីស លូ ប៉ាសុន អ៊ីស្រាអ៊ែល ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","វគ័ ម៉ូសេ អ្វៃ ពឹង ប៉ានឹម លូ ប‌៉្រ័ះ ប៊កកាតយ័ ទុញ ៤០ ម៉ាំង ៤០ ដារ់ អ៊ែ អូ ទី សា សាណា ញ៉ា អុះ យ‌៉័ះ ទៀក កា អ៊ែ អូ អៃត សាំ។ ប៉ានឹរ ប‌៉្រ័ះ សាញ៉ា រែវ ពុត លូ ប៉ានឹរ ប៉្រើ ទិ ១០ ខ អ៊ែ ច្រាគ់ ទិ ពឹង អំហ្មោ ឡាត ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","កេះណោះ វគ័ ម៉ូសេ ជឹរ ឡឹង ប៉ានឹម ចឹក សឹត ទឹប អំហ្មោ ឡាត ទិ ពៀរ ឡាក់ អ៊ែ ច្រាគ់ ប៉ានឹរ ប‌៉្រ័ះ សាញ៉ា រែវ ពុត ណោះ ហង។ ផះ អ៊ែ ជឹរ ឡឹង ប៉ានឹម ណោះ អ៊ែ អូ អ្លុ អន់តគ់ អុះ កា ម៉ូះ ម៉ាត់ អ៊ែ ឡាច់ តាតារ ញន កា អ៊ែ កាកាប លូ ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","វគ័ អារ៉ុន លូ មួត សុនសាត អ៊ីស្រាអ៊ែល ប៉ប័ ម៉ូះ ម៉ាត់ វគ័ ម៉ូសេ ឡាច់ តាតារ នីណោ័ះ អន់ឌែ អូ ខឹន ឡាំ ក្យាម័ វគ័ ម៉ូសេ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ប៉ាគ់ វគ័ ម៉ូសេ អើ អន់ឌែ វគ័ អារ៉ុន លូ ម៉ៃគ ណាំផា មួត ប៉ាសុន អន់ឌែ ខឹន ឡាំ ក្យាម័ វគ័ ម៉ូសេ កេះណោះ វគ័ ម៉ូសេ កាកាប លូ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","កេះណោះ មួត ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ ប៉ាណាំ គួប ឡាំ ក្យាម័ វគ័ ម៉ូសេ ដេល។ វគ័ ម៉ូសេ រ៉ះ ទិ សារ ប‌៉្រ័ះ ប៊កកាតយ័ អន់តគ់ រ៉ះ កា អ៊ែ ពឹង ប៉ានឹម ស៊ីណាយ អន់ កា ប៉ាសុន សាំយ៉ាំង។ ");
INSERT INTO tpu_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","ប៉ាគ់ វគ័ ម៉ូសេ រ៉ះ សារ កេះៗ អ៊ែ អ្យក់ អញ់ស៊ែង តល័ សាក្លុំ ម៉ូះ ម៉ាត់។ ");
INSERT INTO tpu_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","រ៉ប់ អ៊ែ ម៉ុត រ៉ះ សារ លូ ប‌៉្រ័ះ ប៊កកាតយ័  អ៊ែ អ្យក់ ឡាច់ អញ់ស៊ែង អ៊ែ តល័ សាក្លុំ ម៉ូះ ម៉ាត់ ណោះ ទឹល កេះ រ៉ះ សារ។ ប៉ាគ់ អ៊ែ ឡាច់ គែង ឡីង ណាវ្គ អ៊ែ រ៉ះ សារ តាងៗ ណាវ្គ កា សុនសាត អ៊ីស្រាអ៊ែល ទិ សារ ឡាក់ ប‌៉្រ័ះ អន់តគ់ រ៉ះ កា អ៊ែ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","សុនសាត អ៊ីស្រាអ៊ែល ប៉ប័ ម៉ូះ ម៉ាត់ វគ័ ម៉ូសេ ឡាច់ តាតារ។ កេះណោះ អ៊ែ អ្យក់ អញ់ស៊ែង តល័ សាក្លុំ ម៉ូះ ម៉ាត់ លើយ ទឹល ដារ់ អ៊ែ ម៉ុត រ៉ះ សារ លូ ប‌៉្រ័ះ ប៊កកាតយ័ ណាវ្គ។ … ");
INSERT INTO tpu_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","សុនសាត អ៊ីស្រាអ៊ែល ប៉្រគ័ ឃឿង ខង សាំរ៉ាប់ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ កេះ ទិ កេះ ត្រគ់ ពួយ ទិ សារ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ វគ័ ម៉ូសេ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","វគ័ ម៉ូសេ ប៉ានិត ហៃ ង៉ារ ទិណោ័ះ ប៉ប័ ផា អន់ឌែ ប៉្រគ័ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អ៊ែ តាទឹច។ វគ័ ម៉ូសេ កា ប៉រ់ សារ ដាគ់ អន់ កា អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ឡៃង ឡឹង ប៉ាសុន អ៊ីស្រាអ៊ែល ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ប៉ាគ់ ទឹល សាណាំ អន់តីគ កាណុង ខៃ ១ ដារ់ ទី ១ អន់ឌែ ប៉្រគ័ ចារ សាំរ៉ាប់ ម៉ុត រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","វគ័ ម៉ូសេ ប៉្រើ ពូ ប៉្រគ័ ចារ សាំរ៉ាប់ ម៉ុត រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ ពូ ចៃគ ជុងតាង ប៉្រាក់ លូ ចៃគ អញ់ជុង អ៊្លង កេះណោះ ចៃគ កានួង លូ ចៃគ ច្រើយ។ ");
INSERT INTO tpu_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","កេះណោះ ពូ ឡាង កាណាត់ ប៉ិង ជុំ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ លូ អ្យក់ អង់ការ កាត្រើគ ប៉្រគ័ អន់តល័ ឡាក់ កា ប‌៉្រ័ះ រ៉ះ កា វគ័ ម៉ូសេ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","វគ័ ម៉ូសេ អ្យក់ អំហ្មោ ឡាត ឡាក់ ទី ច្រាគ់ ប៉ានឹរ ប‌៉្រ័ះ ចៃគ កាណុង ហ៊ីប សារ សាញ៉ា រែវ ពុត  កេះណោះ អ្យក់ កល់ កាត្រើគ លូ ស្រូ អ៊្លង តាណូង័ ");
INSERT INTO tpu_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","កេះណោះ ពូ អ្យក់ ហ៊ីប ចៃគ កាណុង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ លូ អ្យក់ កាណាត់ ប៉ិង កាន់ទឹង ចារ ហ៊ីប ណោះ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ អន់តគ់ រ៉ះ កា វគ័ ម៉ូសេ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","ពូ ចៃគ គ្រេ សាំរ៉ាប់ ចៃគ ឃឿង ខង គែង សាម៉ា កាណុង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ត្រង់ ហះ ចារ ពូ ប៉ិង កាណាត់។ ");
INSERT INTO tpu_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ពូ ទ្រៀម ណុំ ប៉ាំង សាំរ៉ាប់ ទៀន ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ចៃគ ពឹង គ្រេ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ។ ");
INSERT INTO tpu_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","ពូ អន់ ចារ ចៃគ តាគៀង គែង សាំងអ្យោ កាណុង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ គែង ង៉ីរ ចារ ពូ ចៃគ គ្រេ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ពូ ទ្រៀម តាគៀង ទិណោ័ះ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","ពូ អ្យក់ អន់ហ្នឹង ប៉្រគ័ លូ ម៉ាស ចៃគ កាណុង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ត្រង់ កាណាត់ ពូ ប៉ិង។ ");
INSERT INTO tpu_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ពូ សុះ តាំងហ៊ុម ពឹង អន់ហ្នឹង ម៉ាស ណោះ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ។ ");
INSERT INTO tpu_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","ពូ ប៉ិង កាណាត់ ហះ អំប៉ារ ទ្រង ម៉ុត កាណុង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ពូ ចៃគ អន់ហ្នឹង សាំរ៉ាប់ ចៃគ កាណាគ័ ពូ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ក្យាម័ អំប៉ារ ម៉ុត កាណុង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ។ វគ័ ម៉ូសេ ពុះ អ្លាត កាណាគ័ អន់ឌូ លូ តាប៉ុង ពឹង អន់ហ្នឹង ណោះ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","31","ពូ ចៃគ កាប៊ែ ហះ អន់តិគ័ អំពុន ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ លូ អន់ហ្នឹង រ៉ាម៉ះ។ កេះណោះ ចៃគ ទៀក ប៉ាញ័ កាប៊ែ ណោះ សាំរ៉ាប់ វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន លូ គន កាម៉ាក័ អ៊ែ យរ រ៉ាវ តី រ៉ាវ ជុង។ ");
INSERT INTO tpu_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ប៉ាគ់ អន់ឌែ ចឹង ម៉ុត កាណុង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ លើ កា ម៉ុត ក្យាម័ អន់ហ្នឹង រ៉ាម៉ះ អន់ឌែ ត្រគ់ រ៉ាវ ជុង តី អន់ទ្រួល ហិ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","វគ័ ម៉ូសេ ប៉្រើ ពូ ប៉្រគ័ រ៉ាំប៊ង ជុំ ឡាន ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ លូ អន់ហ្នឹង រ៉ាម៉ះ កេះណោះ ប៉ិង កាណាត់ ហះ អំប៉ារ ម៉ុត កាណុង ឡាន ចារ ណោះ។ ចារ ណោះ វគ័ ម៉ូសេ ប៉្រគ័ កេះ ទិ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ឡៃង ឡឹង ណោះ ទី កាម៉ល់ ពឹះ កាត្រោប កាន់ទឹង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ លូ ទី តាតារ ក្លាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាញ័ ទឹប កាណុង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","វគ័ ម៉ូសេ អូ អ្លុ ម៉ុត អុះ កាណុង ចារ ណោះ ខង ទី កាម៉ល់ ពឹះ កាត្រោប កាន់ទឹង ចារ ណោះ ទឹប ទី តាតារ ក្លាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាញ័ ទឹប កាណុង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ផះ រ៉ាំងវ៉ាង អន់ឌែ ចាក ណោះ រ៉ប់ កាម៉ល់ ឡាច់ ចាក ឡឹង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល កា ប៉ាណាំ គួប រ៉ើ រ៉ាណើះ ចាក ពួយ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ផា កាម៉ល់ អូ ឡាច់ ចាក ឡឹង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ណោះ សុនសាត អ៊ីស្រាអ៊ែល កា អូ ចាក ដេល ឃឺ អន់ឌែ អ្វៃ ក្យាគ់ ដារ់ កាម៉ល់ ចឹង ឡាច់ ចាក។ ");
INSERT INTO tpu_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","គ្រឹប ចារ អន់ឌែ អ្វៃ ផះ កាដារ់ សុនសាត អ៊ីស្រាអ៊ែល ប៉ប័ កាម៉ល់ ម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ កាត្រោប ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ណោះ ផះ កាម៉ាំង ប៉ប័ អុញ អ្វៃ ពឹង កាណុង កាម៉ល់ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","ប‌៉្រ័ះ ប៊កកាតយ័ អើ វគ័ ម៉ូសេ ឡឹង កាណុង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ លូ រ៉ះ កា អ៊ែ ផា ");
INSERT INTO tpu_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«ហគ់ អីស រ៉ះ កា សុនសាត អ៊ីស្រាអ៊ែល នីអៀ៖ ផា កាណុង កាំឡាំង អន់ដីស អា ផា ទី ពឿ ប៉ិច អ្យក់ កាណាគ័ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ កាណាគ័ អន់ដីស ត្រគ់ អន់ ណោះ អ្យក់ រ៉ក់ កាតាម ចៀម កាតាម ប៉ារ់ពេ កាតាម។ ");
INSERT INTO tpu_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","«ផា អ៊ែ អ្យក់ រ៉ក់ ពុះ អ្លាត អន់ កា ប‌៉្រ័ះ អ៊ែ ត្រគ់ អ្យក់ រ៉ក់ ទោល ម៉ោញ ឡាក់ ដាគ់ អូ ទី ឡាកា ឡាកាច់ អេះ អោម ហះ ចំ អុះ អ៊ែ ត្រគ់ អ្យក់ កាណាគ័ អ៊ែ អន់ កា ប‌៉្រ័ះ ណោះ ឡាំ តាំបាង ហះ អំប៉ារ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ម៉ាគ់ ត្រគ់ ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","តាំងឡា បក់ រ៉ាម៉ះ ត្រគ់ សាប៉ាគ់ ពឹង កល់ រ៉ក់ ឡាក់ ត្រគ់ ពុះ អ្លាត ណោះ ម៉ាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង អ្យក់ កាណាគ័ អ៊ែ រ៉ាម៉ះ ណោះ លូ ចឹង តង័ អ៊ែ អន់ រ៉ាវ៉ាច់ ឡឹង សារ យច។ ");
INSERT INTO tpu_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","អ៊ែ ត្រគ់ ប៉ាន់តោ័ រ៉ក់ ណោះ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័  កេះណោះ មួត គន សោ អារ៉ុន ឡាក់ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ត្រគ់ អ្យក់ ផាម រ៉ក់ ណោះ ស្រោច ជុំ អន់ហ្នឹង ឡាក់ អន់ ហះ អំប៉ារ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","រ៉ក់ ណោះ អន់ឌែ ត្រគ់ សាទៀរ ឡាច់ អង់ការ លូ ឡះ រ៉ាឡៃ ប៉ាំងឡៃ កាតុៗ។ ");
INSERT INTO tpu_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","គន សោ អារ៉ុន ឡាក់ មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ អន់ឌែ ត្រគ់ អ្យក់ រ៉ាម៉េះ ចៃគ ពឹង អន់ហ្នឹង លូ អ្យក់ អុញ ប៉ាកូះ ");
INSERT INTO tpu_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","កេះណោះ អ្យក់ រ៉ាឡា អ្យក់ កល់ លូ ប៉ុង ចៃគ ពឹង អុញ ពឹង អន់ហ្នឹង ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","ហះកា វ៉ាច់ ពុង លូ ជុង រ៉ក់ ទិណោ័ះ ត្រគ់ រ៉ាវ លូ ទៀក កេះណោះ អន់ កា ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ពុះ ពឹង អន់ហ្នឹង ទិណោ័ះ ហង ឃឺ កាណាគ័ រ៉ាម៉ះ សាំរ៉ាប់ អន់ បោ ប៉ុង បោ រ៉ិញ ទឹល ប‌៉្រ័ះ ប៊កកាតយ័ »។ … ");
INSERT INTO tpu_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","ប‌៉្រ័ះ ប៊កកាតយ័ កា កាប លូ វគ័ ម៉ូសេ ឡៃង ឡឹង គន អារ៉ុន ពៀរ ដូវ តោ័ ញន កា អន់ឌែ ម៉ុត ប៉ាគ់ ចារ ប‌៉្រ័ះ ប៊កកាតយ័ យច ខ។ ");
INSERT INTO tpu_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ លូ វគ័ ម៉ូសេ ផា «ហគ់ រ៉ះ កា ម៉ី អីស អារ៉ុន ជែ អន់ ហង អ៊ែ ម៉ុត លើយៗ ពឹង កាណុង ដាគ់ កាខាក់  ឃឺ ពឹង កាណុង ពូ ប៉ិង លូ កាណាត់ ហះ ចារ កល់ ហ៊ីប សារ សាញ៉ា រែវ ពុត  អន់ទៀ អ្យូគ កា អ៊ែ តោ័ ខង អាញ់ ចឹង អ្វៃ កាណុង កាម៉ល់ អំប៉ាំង ហ៊ីប ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","ផា អារ៉ុន ម៉ុត ប៉ាគ់ កាណុង ដាគ់ កាខាក់ អ៊ែ ត្រគ់ ប៉្រគ័ នីអៀ៖ អ៊ែ ត្រគ់ អ្យក់ រ៉ក់ ទោល ផះ ប៉ាញ័ តាម័ ម៉ោញ កាតុ ភឿ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ សាំរ៉ាប់ អន់ រ៉ាវ៉ាច់ ឡឹង សារ យច លូ ចៀម ទោល ម៉ោញ កាតុ សាំរ៉ាប់ ពុះ អ្លាត អន់ កា ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","អ៊ែ ត្រគ់ ពៀត អាវ អ្លឹង ប៉្រគ័ លូ តាមៃ អ៊ែ ត្រគ់ កាស៊ប ខោ អ្លេះ ប៉្រគ័ លូ តាមៃ អ៊ែ ត្រគ់ ចៃគ ម៉ាអ៊ែវ ប៉្រគ័ លូ តាមៃ អ៊ែ ត្រគ់ អំប៉ន់ អញ់ស៊ែង ប៉្រគ័ លូ តាមៃ ដេល ឃឺ ត្រគ់ កាស៊ប ពៀត ខោ អាវ នែវ អា សាំរ៉ាប់ ម៉ុត រ៉ាម៉ះ ប‌៉្រ័ះ។ អន់ទ្រួល ចឹង កាស៊ប ពៀត ខោ អាវ ទិ អា អ៊ែ ត្រគ់ ហុំ ហិ។ ");
INSERT INTO tpu_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","អ៊ែ ត្រគ់ អ្យក់ ប៉ារ់ពេ ទោល ពៀរ កាតុ ឡឹង សុនសាត អ៊ីស្រាអ៊ែល សាំរ៉ាប់ រ៉ាម៉ះ ប‌៉្រ័ះ ភឿ អន់ ពូ រ៉ាវ៉ាច់ ឡឹង សារ យច លូ អ្យក់ ចៀម ទោល ម៉ោញ កាតុ សាំរ៉ាប់ ពុះ អ្លាត ដេល។ ");
INSERT INTO tpu_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","«អារ៉ុន ត្រគ់ អ្យក់ រ៉ក់ ទោល ណោះ រ៉ាម៉ះ ប‌៉្រ័ះ ភឿ ហ្វាយ ឡាកោ អ៊ែ អន់ រ៉ាវ៉ាច់ ឡឹង សារ យច លូ ហ្វាយ ខាប់ខួ ហី ក្រាន អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","កេះណោះ អ៊ែ ត្រគ់ អ្យក់ ឡាំ ប៉ារ់ពេ ទោល ពៀរ កាតុ អន់ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ត្រង់ ហះ អំប៉ារ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","អ៊ែ ត្រគ់ រ៉ុប កាប៉ាច់ រ៉ើស អ្យក់ ប៉ារ់ពេ ទោល ពៀរ កាតុ ណោះ ម៉ោញ អន់ កា ប‌៉្រ័ះ ប៊កកាតយ័  ម៉ោញ ណាវ្គ អន់ កា អាសាស៊ែល ។ ");
INSERT INTO tpu_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","កេះ រ៉ុប កាប៉ាច់ កេះ អារ៉ុន ត្រគ់ អ្យក់ ប៉ារ់ពេ ឡាក់ សាំរ៉ាប់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ ពុះ រ៉ាម៉ះ ភឿ អន់ ពូ រ៉ាវ៉ាច់ ឡឹង សារ យច។ ");
INSERT INTO tpu_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","ហះកា កាប៉ាច់ ប៉ារ់ពេ ឡាក់ ត្រគ់ អន់ កា អាសាស៊ែល ណោះ កា អ្យក់ ពឹះ អន់ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ដេល ភឿ ហ្វាយ ប៉ាសុន អន់ រ៉ាវ៉ាច់ ឡឹង សារ យច កេះណោះ ប៉្រើ ពូ ឡាំ ឡើយ ប៉ាគ់ ស៊្រែ តីស អន់ កា អាសាស៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","«អារ៉ុន ត្រគ់ អន់ រ៉ក់ ទោល ណោះ សាំរ៉ាប់ ហ្វាយ ឡាកោ អ៊ែ អន់ រ៉ាវ៉ាច់ ឡឹង សារ យច លូ ហ្វាយ ខាប់ខួ ហី ក្រាន អ៊ែ ដេល។ អ៊ែ ត្រគ់ ច្រាគ័ អង់កូ រ៉ក់ ទោល ណោះ សាំរ៉ាប់ ហ្វាយ ឡាកោ អ៊ែ អន់ រ៉ាវ៉ាច់ ឡឹង សារ យច។ ");
INSERT INTO tpu_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","អ៊ែ ត្រគ់ អ្យក់ ខាល់ សាំរ៉ាប់ ចៃគ ង៉ារ អុញ កេះណោះ អ្យក់ ង៉ារ អុញ ឡឹង អន់ហ្នឹង ឡាក់ អ្វៃ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ចៃគ ប៉ាញ័ ខាល់ លូ អ្យក់ តាំងហ៊ុម ឡាក់ គ្លែ ហាច់ កេះ ពៀរ ចាប់ អ្យក់ ម៉ុត គែង កាណុង ចារ ពូ ប៉ិង លូ កាណាត់ ");
INSERT INTO tpu_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","កេះណោះ ប៉ាច្រើយ ពឹង ង៉ារ អុញ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ភឿ អន់ អ្យី តាំងហ៊ុម ណោះ ហុយ ហាវ កាន់ទឹង កល់ ហ៊ីប ឡាក់ ចារ ប‌៉្រ័ះ អ្វៃ អ្យូគ អ៊ែ ប៉ប័ ប‌៉្រ័ះ ប៉្រគ័ អន់ អ៊ែ តោ័ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","អ៊ែ ត្រគ់ អ្យក់ ផាម រ៉ក់ ទោល ណោះ កេះណោះ ឡុក រ៉ាំងអ្យា តី ពឹង ផាម រ៉ាន់ថាត់ អំប៉ាំង កល់ ហ៊ីប គែង ដារ់ ឡាច់។ អ៊ែ ត្រគ់ ឡុក រ៉ាំងអ្យា តី ពឹង ផាម រ៉ាន់ថាត់ អំប៉ាំង កល់ ហ៊ីប ណោះ ចំលួន តាំប៉ើះ ទង។ ");
INSERT INTO tpu_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","«អ៊ែ ត្រគ់ ច្រាគ័ អង់កូ ប៉ារ់ពេ ទោល ភឿ ហ្វាយ មួត ប៉ាសុន អន់ រ៉ាវ៉ាច់ ឡឹង សារ យច កេះណោះ អ្យក់ ម៉ុត ផាម ណោះ គែង កាណុង ចារ ពូ ប៉ិង លូ កាណាត់។ អ៊ែ ត្រគ់ រ៉ាន់ថាត់ ផាម ប៉ារ់ពេ ណោះ អំប៉ាំង កល់ ហ៊ីប លូ គែង ង៉ីរ កល់ ហ៊ីប ឡាក់ អ៊ែ រ៉ាន់ថាត់ ផាម រ៉ក់ ទោល ពែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","អ៊ែ ប៉្រគ័ នីណោ័ះ ភឿ តាគ់ អន់ដាគ់ ចារ ប‌៉្រ័ះ អ្វៃ អន់ ដាគ់ ភឿ អន់ រ៉ាវ៉ាច់ ឡឹង សារ បឺគ អ៊ក មួត សុនសាត អ៊ីស្រាអ៊ែល ទឹប សារ អូ ដាគ់ លូ សារ យច អន់ឌែ ទិណោ័ះ ឡាក់ ប៉្រគ័ អន់ ចារ ណោះ កើត អូ ដាគ់ ដេល។ អ៊ែ ត្រគ់ រ៉ាន់ថាត់ ផាម នែវ អា ពឹង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ទិណោ័ះ ឡាក់ អ្វៃ ហះ អន់តិគ័ អន់ឌែ ឡាក់ ប៉ាណូស ប៉្រគ័ យច។ ");
INSERT INTO tpu_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","ឡឹង អ៊ែ ម៉ុត ពឹង កាណុង ដាគ់ កាខាក់ ភឿ ហ្វាយ ឡាកោ អ៊ែ ទៅ ទឹប ខាប់ខួ ហី ក្រាន អ៊ែ លូ ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ លើយ ទឹល អ៊ែ ឡាច់ ឡឹង ចារ ណោះ អូ អន់ ទី ពឿ ម៉ោញ ដូវ អ្វៃ កាណុង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","កេះណោះ អ៊ែ ត្រគ់ ឡាច់ ឡាំ គែង ង៉ីរ អន់ហ្នឹង ឡាក់ អ្វៃ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ កេះណោះ តាគ់ អន់ដាគ់ អន់ហ្នឹង អន់ ដាគ់។ អ៊ែ ត្រគ់ អ្យក់ ផាម រ៉ក់ ទោល លូ ផាម ប៉ារ់ពេ ទោល ឡាប ពឹង អង់គែ អន់ហ្នឹង ទិ ប៉្វាន់ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","អ៊ែ ត្រគ់ ឡុក រ៉ាំងអ្យា តី ពឹង ផាម កេះណោះ រ៉ាន់ថាត់ ផាម ពឹង អន់ហ្នឹង តាំប៉ើះ ទង។ ប៉្រគ័ នីណោ័ះ ភឿ តាគ់ អន់ដាគ់ អន់ហ្នឹង អន់ រ៉ាវ៉ាច់ ឡឹង សារ បឺគ អ៊ក មួត ប៉ាសុន អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","«ប៉ាគ់ អ៊ែ តាគ់ អន់ដាគ់ ចារ ប‌៉្រ័ះ អ្វៃ លូ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ លូ អន់ហ្នឹង កេះៗ អារ៉ុន ត្រគ់ អ្យក់ ប៉ារ់ពេ ទោល ទឹប រ៉ីស ណោះ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","តី អ៊ែ ទិ ពៀរ ត្រគ់ សាប៉ាគ់ ពឹង កល់ ប៉ារ់ពេ ឡាក់ អ្វៃ រ៉ីស ណោះ លូ ឡាប់ ញម សារ យច ទឹប សារ បឺគ អ៊ក លូ សារ អូ ដាគ់ មួត សុនសាត អ៊ីស្រាអ៊ែល ទិណោ័ះ អន់ អ្វៃ ទិ ពឹង កល់ ប៉ារ់ពេ ណោះ កេះណោះ ប៉្រើ កាម៉ាក័ ម៉ោញ ដូវ ឡាក់ អ៊ែ រ៉ើស កេះៗ អន់ ទ្រុះ ប៉ារ់ពេ ណោះ ឡាំ ប៉ាគ់ ស៊្រែ តីស។ ");
INSERT INTO tpu_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ប៉ារ់ពេ ណោះ ចឹង ប៉ាទុក ទិ សារ យច មួត សុនសាត អ៊ីស្រាអ៊ែល ពឹង ឡាកោ អ៊ែ អ្យក់ ឡាំ ប៉ាគ់ ចារ ឡាង៉ាន់ កេះណោះ អន់ អ៊ែ ឡើយ អ្លាត ពឹង ស៊្រែ តីស។ ");
INSERT INTO tpu_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","«កេះណោះ អារ៉ុន ត្រគ់ ម៉ុត កាណុង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ណាវ្គ។ ខោ អាវ ពូ ប៉្រគ័ លូ តាមៃ ឡាក់ អ៊ែ កាស៊ប ពៀត សាំរ៉ាប់ ម៉ុត រ៉ាម៉ះ ប‌៉្រ័ះ ណោះ ត្រគ់ រ៉ីស អន់ កាណុង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","អ៊ែ ត្រគ់ ហុំ កាណុង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ណោះ ហង កេះណោះ កាស៊ប ពៀត ខោ អាវ អ៊ែ ទៅ ឡាក់ ឃើយ កាស៊ប ពៀត រ៉ប់ ដារ់ ពែ ណាវ្គ។ កេះណោះ ឡាច់ ប៉ាគ់ ឡីង អ្យក់ កាណាគ័ ម៉ះ អ៊ែ លូ កាណាគ័ ម៉ះ មួត ប៉ាសុន ពុះ អ្លាត អន់ កា ប‌៉្រ័ះ ភឿ ហ្វាយ ឡាកោ អ៊ែ លូ ឡាកោ មួត ប៉ាសុន អន់ រ៉ាវ៉ាច់ ឡឹង សារ យច។ ");
INSERT INTO tpu_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","កាប៉ាច់ ប៉ុង ប៉ារ់ពេ លូ រ៉ក់ អ៊ែ រ៉ាម៉ះ ប‌៉្រ័ះ ពែ ត្រគ់ ពុះ ពឹង អន់ហ្នឹង ដេល។ ");
INSERT INTO tpu_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","កាម៉ាក័ បក់ ទ្រុះ ប៉ារ់ពេ ឡាំ ប៉ាគ់ ស៊្រែ តីស ណោះ អ៊ែ ត្រគ់ ប៉ីស ខោ អាវ លូ ហុំ អន់ ដាគ់ និះទៅ ដេល កេះណោះ អ៊ែ ចឹង ទី ម៉ុត កាណុង ចារ រ៉ាណើះ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","កាប៉ាច់ រ៉ក់ ទោល លូ ប៉ារ់ពេ ទោល ផាម អ៊ែ អ្យក់ ម៉ុត គែង កាណុង ចារ ប‌៉្រ័ះ អ្វៃ ពែ សាំរ៉ាប់ ហ្វាយ ឡាកោ អន់ រ៉ាវ៉ាច់ ឡឹង សារ យច ណោះ ហះកា ឡាកោ អ៊ែ ត្រគ់ អ្យក់ អ្លាត គែង ឡីង ចារ រ៉ាណើះ។ កាប៉ាច់ អង់ការ លូ ប៉ាំងឡៃ លូ វ៉ាច់ ពុង ត្រគ់ អ្យក់ ឡាច់ គែង ឡីង ចារ រ៉ាណើះ ដេល កេះណោះ ពុះ ទិណោ័ះ ពឹង អុញ។ ");
INSERT INTO tpu_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ប៉ាណូស បក់ ពុះ ណោះ អ៊ែ ត្រគ់ ប៉ីស ខោ អាវ លូ ហុំ អន់ ដាគ់ និះទៅ ដេល កេះណោះ អ៊ែ ចឹង ទី ម៉ុត កាណុង ចារ រ៉ាណើះ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","«អា ហង ចាបាប់ ឡាក់ អន់ដីស ត្រគ់ ប៉្រគ័ ពួយ លើយ អូ អន់ តូរ័ អុះ។ សារ ទិ អា ត្រគ់ ប៉្រគ័ ពឹង ដារ់ ទី ១០ ខៃ ៧ ពឹង ដារ់ ណោះ អន់ដីស ត្រគ់ កំ អូ សា សាណា ញ៉ា លូ អូ ប៉្រគ័ ង៉ារ ញ៉ា អុះ យ‌៉័ះ អន់ដីស ឡាក់ តាំងឡា ស្រុក យ‌៉័ះ មួត អំហ៊្មយ ឡឹង ប៉ាថេត អន់ទៀគ ឡាក់ អ្វៃ អន់ឌូ លូ អន់ដីស កាតាម ");
INSERT INTO tpu_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ខង ដារ់ ណោះ ពូ រ៉ាម៉ះ ប‌៉្រ័ះ ហ្វាយ អន់ដីស ឡឹង សារ យច ភឿ អន់ អន់ដីស ដាគ់ រ៉ាវ៉ាច់ ឡឹង សារ បឺគ អ៊ក ផះ ណោះ អន់ដីស ចឹង ដាគ់ អូ ទី សារ យច ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ដារ់ ណោះ ឃឺ ដារ់ រ៉ាឡូវ ឡាក់ ដារ់ អន់ដីស ត្រគ់ រ៉ាឡូវ លូ កំ អូ សា សាណា ញ៉ា។ អា ហង ចាបាប់ ឡាក់ អន់ដីស ត្រគ់ ប៉្រគ័ ពួយ លើយ អូ អន់ តូរ័ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","ប៉ាណូស បក់ ពូ ចឹង រ៉ើស ជ្រោ សាងី អន់ ប៉្រគ័ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ប៉ាតាង ពឹ អ៊ែ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ណោះ ត្រគ់ ហ្វាយ ពូ អន់ រ៉ាវ៉ាច់ ឡឹង សារ យច លូ កាស៊ប ពៀត ខោ អាវ ប៉្រគ័ លូ តាមៃ ឃឺ កាស៊ប ពៀត សាំរ៉ាប់ ប៉្រគ័ ង៉ារ រ៉ាម៉ះ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","អ៊ែ ត្រគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ភឿ តាគ់ អន់ដាគ់ ចារ ប‌៉្រ័ះ អ្វៃ លូ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ទិណោ័ះ ទឹប អន់ហ្នឹង អន់ ដាគ់ លូ ហ្វាយ មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ លូ មួត ប៉ាសុន ទិឌូ អន់ រ៉ាវ៉ាច់ ឡឹង សារ យច។ ");
INSERT INTO tpu_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","ចាបាប់ អា ហង សាំរ៉ាប់ កា អន់ដីស ត្រគ់ ប៉្រគ័ ពួយ លើយ ម៉ោញ សាណាំ ម៉ោញ ទង អូ អន់ តូរ័ អុះ ភឿ អន់ សុនសាត អ៊ីស្រាអ៊ែល រ៉ាវ៉ាច់ ឡឹង សារ យច ទិណោ័ះ»។ វគ័ ម៉ូសេ កា ប៉្រគ័ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ អន់តគ់ រ៉ះ កា អ៊ែ ណោះ ហង។ … ");
INSERT INTO tpu_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា ");
INSERT INTO tpu_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«ហគ់ រ៉ះ កា មួត ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ នីអៀ៖ ហគ់ អន់ដីស ប៉ិនពែង ពុត ពៀក អន់ ដាគ់ ត្រង់ ខង អាញ់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អាញ់ ដាគ់ ត្រង់។ ");
INSERT INTO tpu_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","អន់ដីស ទិឌូ ត្រគ់ អ្យិល កូត័ កា មើគ ពឹ អន់ដីស ទៅ លូ ត្រគ់ រ៉ាឡូវ ពួយ ដារ់ អាញ់ ប៉្រើ អន់ដីស រ៉ាឡូវ ដេល។ អាញ់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","«អន់ដីស ជែ សឿ ប‌៉្រ័ះ អន់ទៀគ លូ ជែ ប៉្រគ័ ហ៊ូប ប‌៉្រ័ះ សាំរ៉ាប់ កា អន់ដីស ដេល។ អាញ់ អា ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","«ដារ់ ចំ អន់ដីស ពុះ កាណាគ័ រ៉ាម៉ះ អាញ់ សាំរ៉ាប់ សា អន់ឌូ លូ គួប សោប ត្រគ់ រ៉ាម៉ះ នែវ ឡាបៀប អាញ់ ប៉ាញ័ ពុត។ ");
INSERT INTO tpu_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","ត្រគ់ សា រ៉ាឡា អ្យាំ រ៉ាម៉ះ អាញ់ ណោះ ពឹង ដារ់ រ៉ាម៉ះ លូ ដារ់ តាយ៉ាង័ ផា អ្វៃ សល់ ទឹល ដារ់ តាយ៉ាង័ តោ ត្រគ់ ពុះ អ្លាត ទិ ពឹង អុញ។ ");
INSERT INTO tpu_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ផា សា រ៉ាឡា អ្យាំ ណោះ ទឹល ដារ់ តាយ៉ាង័ តោ អូ ដាគ់ អុះ លូ អាញ់ អូ ប៉ាញ័ ពុត កា កាណាគ័ រ៉ាម៉ះ ណោះ ចឹង កើត អូ ទី ខា ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ពឿ សា រ៉ាឡា អ្យាំ ណោះ ទឹល ដារ់ តាយ៉ាង័ តោ ប៉ាណូស ណោះ ចឹង ត្រគ់ ថូត ខង អ៊ែ បឺង៉ាយ កាណាគ័ អ៊ែ រ៉ាម៉ះ អាញ់។ ប៉ាណូស បក់ ប៉្រគ័ នីណោ័ះ ត្រគ់ តាំងហ្យិត ឡាច់ ឡឹង សុនសាត អ៊ែ ទៅ។ ");
INSERT INTO tpu_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","«ផា ដារ់ ចំ អន់ដីស ច្រូត័ ពៀ ពឹង ម៉ីរ ជែ ច្រូត័ ទឹល អន់ទ្រឹល លូ ជែ ទូញ ប៉ាយ៉ក័ ពៀ ឡាក់ ឡិ ហ្រុង ណោះ ដេល ");
INSERT INTO tpu_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","លូ ជែ អ្លេះ ប៉្លៃ អង់កាច ឡាក់ អ្វៃ សល់ ពឹង ម៉ីរ អន់ដីស ណោះ លូ ជែ ទូញ ប៉្លៃ អង់កាច ឡាក់ ហ្រុង ពឹង តេះ ណោះ ដេល ឃឺ អ្លាត អន់ កា មួត ថុក ញ៉ាក លូ អំហ៊្មយ ទូញ សា អន់ឌែ ឡគ។ អាញ់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","«អន់ដីស ជែ អន់តុង ជែ ប៉ាលុ ជែ ប៉ាង៉ល់ អ្យក់ រ៉ាស អំប៉ាស ម៉ះ ពូ លូ ជែ កាប ព្លូង កា គួប សោប ");
INSERT INTO tpu_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","លូ ជែ ម៉ត់ ប៉ាឡម័ អើ សិច អាញ់ ផា ប៉្រគ័ នីណោ័ះ អន់ដីស បឺង៉ាយ អាញ់ ឡាក់ ប‌៉្រ័ះ អន់ដីស ហង។ អាញ់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","«ជែ ជិះ ចគ័ អុះ ម៉ី ឡីង គែង ជែ អន់តុង រ៉ាត រ៉ាស អំប៉ាស ពូ។ ផា អន់ដីស ច្វាល់ ពូ ប៉្រគ័ គូលី ត្រគ់ អន់ លៀន ឡូត ជែ ផា \"កូម័ អន់ ដារ់ តាយ៉ាង័\"។ ");
INSERT INTO tpu_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","ជែ ត័ះ កាប បឺគ កា ប៉ាណូស ក្លឹក លូ ជែ អ្យក់ កាណាគ័ ញ៉ា អន់ ហះ ង៉ីរ ប៉ាណូស ម៉ាម៉ាំង ម៉ាត់ ប៉្រគ័ អន់ កា អ៊ែ សាលឹម ប៉ក់។ ត្រគ់ អ្យិល កូត័ អ្យូគ កា អាញ់ ឡាក់ ប‌៉្រ័ះ អន់ដីស។ អាញ់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","«ផះ តាត់ស៊ិន សារ អន់ដីស ជែ កាប សារ អូ ត្រង់ លូ ជែ រ៉ើស ម៉ាត់ ប៉ាណូស ថិ លើ ប៉ាណូស តីស។ ហះកា ត្រគ់ តាត់ស៊ិន សារ កា អុះ ម៉ី ឡីង គែង អន់ ដាគ់ ត្រង់។ ");
INSERT INTO tpu_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","ជែ ចាចាក កាប ពោ គួប សោប កាណុង មួត ប៉ាសុន អន់ដីស លូ ជែ ច្រោម ពូ អន់ទៀគ ប៉្រគ័ អន់ ពូ ទី ថូត ត្រគ់ តោ័។ អាញ់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","«ជែ ទី ពុត អូ ណីស កា អុះ ម៉ី អន់ដីស ទៅ ហះកា ត្រគ់ អន់តគ់ ប៉ាតោ កា កាំឡាំង អន់ដីស ប៉្រគ័ នីណោ័ះ អន់ដីស ចឹង អូ រែវ ពុត អន់ឌូ លូ ពូ បក់ ប៉្រគ័ សារ យច។ ");
INSERT INTO tpu_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","ជែ តូ ពូ លូ ជែ កាគឹម កា សុនសាត អន់ដីស ទៅ ដេល។ ត្រគ់ ប៉ិច ចៃ កា អុះ ម៉ី ឡីង គែង ឡាក់ កា ប៉ិច ចៃ កា ឡាកោ អន់ដីស ទៅ។ អាញ់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ »។ … ");
INSERT INTO tpu_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា ");
INSERT INTO tpu_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«ហគ់ រ៉ះ កា ប៉ាសុន អ៊ីស្រាអ៊ែល នីអៀ៖ អាញ់ កាំឡត់ ដារ់ អន់ទៀគៗ ឡាក់ អីស ត្រគ់ រ៉ះ ប៉្រើ ប៉ាសុន ប៉ាតុំ គួប សោប ភឿ ប៉ានេ សាំប‌៉័ះ អាញ់ ឃឺ នីអៀ៖ ");
INSERT INTO tpu_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","«អន់ដីស ត្រគ់ ប៉្រគ័ ង៉ារ ដឹង ត្រោ ដារ់ ហះកា ប៉ាគ់ ទឹល ដារ់ ទី តាំប៉ើះ ឃឺ ដារ់ រ៉ាឡូវ សាំរ៉ាប់ អន់ដីស ប៉ាតុំ គួប សោប ប៉ានេ សាំប‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័  អូ អន់ អន់ដីស ប៉្រគ័ ង៉ារ ញ៉ា អុះ គ្រឹប ចារ អន់ដីស អ្វៃ ហះ ចំ កាតាម ខង ដារ់ រ៉ាឡូវ ណោះ សាំរ៉ាប់ ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","«ដារ់ សាំខាន់ៗ ម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ អន់ដីស ត្រគ់ កាំឡត់ ប៉ាតុំ គួប សោប ប៉ានេ សាំប‌៉័ះ អ៊ែ ឃឺ នីអៀ៖ ");
INSERT INTO tpu_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","«ពឹង ដារ់ ទី ១៤ ខៃ ១ ឡឹង ដារ់ ម៉ុត ទឹល កាំលឺ ណោះ ឃឺ ប៊ុន ទ្រួង ម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ប៉ាគ់ ទឹល ដារ់ ទី ១៥ កាណុង ខៃ ណោះ ទៅ ឃឺ ប៊ុន ណុំ ប៉ាំង ឡាតាំង សាំរ៉ាប់ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ។ អន់ដីស ត្រគ់ សា ណុំ ប៉ាំង អូ ចៃគ ពុះ ណោះ ចំលួន តាំប៉ើះ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ពឹង ដារ់ ទី ម៉ោញ អន់ដីស ត្រគ់ ប៉ាតុំ គួប សោប ប៉ានេ សាំប‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ដីស អូ ត្រគ់ ប៉្រគ័ ង៉ារ ញ៉ា អុះ ពឹង ដារ់ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","អន់ដីស ត្រគ់ អ្យក់ កាណាគ័ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ចំលួន តាំប៉ើះ ដារ់។ ប៉ាគ់ ទឹល ដារ់ ទី តាំប៉ើះ អន់ដីស ត្រគ់ ប៉ាតុំ គួប សោប ប៉ានេ សាំប‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័ ឃឺ អូ ត្រគ់ ប៉្រគ័ ង៉ារ ញ៉ា អុះ ពឹង ដារ់ ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា ");
INSERT INTO tpu_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«ហគ់ រ៉ះ កា ប៉ាសុន អ៊ីស្រាអ៊ែល នីអៀ៖ ប៉ាគ់ អន់ដីស ម៉ុត ពឹង ប៉ាថេត ឡាក់ អាញ់ មប អន់ កា អន់ដីស ទៀ រ៉ប់ សាណាំ ប៉ាគ់ អន់ដីស ច្រូត័ ពៀ អន់ដីស ត្រគ់ អ្យក់ ចាណគ់ ពៀ ឡាក់ ច្រូត័ អន់ទ្រួល ឡឹង ពូ ពឹះ ជឹន កា ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ។ ");
INSERT INTO tpu_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ឡៃង ឡឹង ដារ់ រ៉ាឡូវ មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ត្រគ់ លឺក ចាណគ់ ពៀ ណោះ មប កា ប‌៉្រ័ះ ប៊កកាតយ័ ភឿ អន់ អន់ដីស ត្រគ់ ពុត អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ដារ់ អន់ដីស លឺក ចាណគ់ ពៀ មប កា ប‌៉្រ័ះ អន់ដីស ត្រគ់ អ្យក់ គន ចៀម ទោល ម៉ោញ កាតុ អាញុ ម៉ោញ សាណាំ ឡាក់ អូ ទី ឡាកា ឡាកាច់ អេះ អោម ហះ ចំ អុះ ពុះ អ្លាត សាំរ៉ាប់ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","កេះណោះ អ្យក់ តាប៉ុង ពៀរ កាឡូ ឡាយ អន់ឌូ លូ សាងី ពុះ អន់ឌូ លូ គន ចៀម សាំរ៉ាប់ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ ដេល ឡាក់ កាណាគ័ ពុះ បោ ប៉ុង បោ រ៉ិញ ត្រគ់ ពុត ប‌៉្រ័ះ ប៊កកាតយ័។ ត្រគ់ អ្យក់ តាពែ ប៉្លៃ អង់កាច ម៉ោញ លិត សាំរ៉ាប់ ស្រោច អន់ហ្នឹង ដេល។ ");
INSERT INTO tpu_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","អន់ដីស ជែ សា ណុំ ញ៉ា ឡាក់ ប៉្រគ័ លូ ពៀ ណាវ ផា អន់ដីស បើ អ្យក់ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ទ្រួល ហិ។ អា ហង ឃឺ ចាបាប់ ឡាក់ អន់ដីស ត្រគ់ ប៉្រគ័ ពួយ លើយ អូ តូរ័ អុះ អន់ គ្រឹប រ៉ាំងហាវ លូ គ្រឹប ចារ អន់ដីស អ្វៃ។ ");
INSERT INTO tpu_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","16","«ឡៃង ឡឹង ដារ់ រ៉ាឡូវ ណោះ ឃឺ អ្យក់ ឡឹង ដារ់ អន់ដីស លឺក ចាណគ់ ពៀ មប កា ប‌៉្រ័ះ ប៊កកាតយ័ អន់ដីស ត្រគ់ យ៉ាប ដារ់ អន់ ទី ៥០ ដារ់ សាម៉ើ លូ តាំប៉ើះ អាទិត។ ប៉ាគ់ ទឹល ដារ់ អន់តីគ ឡឹង ដារ់ រ៉ាឡូវ ពឹង អាទិត ទី តាំប៉ើះ ណោះ ដារ់ ណោះ អន់ដីស ត្រគ់ អ្យក់ ពៀ ណាវ ពឹះ ទៀន អន់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","អន់ដីស ត្រគ់ អ្យក់ ណុំ ប៉ាំង ឡឹង ហី អន់ដីស ពៀរ កាតុ ឡាក់ ប៉្រគ័ លូ តាប៉ុង ពៀរ កាឡូ ពឹះ លឺក មប កា ប‌៉្រ័ះ ប៊កកាតយ័។ ណុំ ប៉ាំង ឡាក់ ប៉្រគ័ អន់ទ្រួល ឡឹង ពូ ណោះ ត្រគ់ ចៃគ ពុះ សាំរ៉ាប់ អន់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","អន់ដីស ត្រគ់ អ្យក់ គន ចៀម តាំប៉ើះ កាតុ អាញុ ម៉ោញ សាណាំ ឡាក់ អូ ទី ឡាកា ឡាកាច់ អេះ អោម ហះ ចំ អុះ លូ រ៉ក់ ប៉ាញ័ តាម័ ម៉ោញ កាតុ លូ ចៀម ទោល ពៀរ កាតុ អន់ឌូ លូ ណុំ ប៉ាំង ណោះ ពឹះ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័  ឃឺ កាណាគ័ ពុះ អ្លាត ទិ ទឹប អ្យក់ តាប៉ុង លូ អ្យក់ តាពែ ប៉្លៃ អង់កាច សាំរ៉ាប់ ស្រោច អន់ហ្នឹង ដេល។ កាណាគ័ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ ទិណោ័ះ សាំរ៉ាប់ បោ ប៉ុង បោ រ៉ិញ ត្រគ់ ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","អន់ដីស ត្រគ់ អ្យក់ គន ប៉ារ់ពេ ទោល ម៉ោញ សាំរ៉ាប់ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ ភឿ អន់ អន់ដីស រ៉ាវ៉ាច់ ឡឹង សារ យច។ កេះណោះ អ្យក់ គន ចៀម ទោល ពៀរ កាតុ អាញុ ម៉ោញ សាណាំ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ សាំរ៉ាប់ សា អន់ឌូ លូ គួប សោប ដេល។ ");
INSERT INTO tpu_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ត្រគ់ លឺក គន ចៀម ពៀរ កាតុ ណោះ អន់ឌូ លូ ណុំ ប៉ាំង ឡាក់ ប៉្រគ័ អន់ទ្រួល ឡឹង ពូ ឃឺ កាណាគ័ លឺក រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ កាណាគ័ រ៉ាម៉ះ ទិណោ័ះ ឃឺ សាំរ៉ាប់ ប‌៉្រ័ះ ប៊កកាតយ័  កេះណោះ មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ចឹង ទី សា។ ");
INSERT INTO tpu_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ដារ់ ណោះ អន់ដីស ត្រគ់ ប៉ាតុំ គួប សោប ប៉ានេ សាំប‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ដីស អូ ត្រគ់ ប៉្រគ័ ង៉ារ ញ៉ា អុះ។ អា ហង ឃឺ ចាបាប់ ឡាក់ អន់ដីស ត្រគ់ ប៉្រគ័ ពួយ លើយ អូ តូរ័ អុះ អន់ គ្រឹប រ៉ាំងហាវ លូ គ្រឹប ចារ អន់ដីស អ្វៃ។ ");
INSERT INTO tpu_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","«ផា ដារ់ ចំ អន់ដីស ច្រូត័ ពៀ ពឹង ម៉ីរ ជែ ច្រូត័ ទឹល អន់ទ្រឹល លូ ជែ ទូញ ប៉ាយ៉ក័ ពៀ ហ្រុង ឡិ ពឹង ម៉ីរ ណោះ។ ត្រគ់ អ្លាត អន់ កា មួត ថុក ញ៉ាក លូ មួត អំហ៊្មយ ឡឹង ប៉ាថេត អន់ទៀគ ទូញ អន់ឌែ ឡគ។ «អាញ់ ឃឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស»។ ");
INSERT INTO tpu_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា ");
INSERT INTO tpu_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«ហគ់ រ៉ះ កា ប៉ាសុន អ៊ីស្រាអ៊ែល នីអៀ៖ ពឹង ដារ់ ទី ១ ខៃ ៧ ឃឺ ដារ់ រ៉ាឡូវ អន់ដីស ត្រគ់ ប៉្រគ័ ប៊ុន កាចាំង លូ ខ្លោម សាណៃង លូ ប៉ាតុំ គួប សោប ប៉ានេ សាំប‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","អន់ដីស អូ ត្រគ់ ប៉្រគ័ ង៉ារ ញ៉ា អុះ ឃឺ ត្រគ់ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ »។ ");
INSERT INTO tpu_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា ");
INSERT INTO tpu_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«ពឹង ដារ់ ទី ១០ ខៃ ៧ ឃឺ ដារ់ ប៊ុន ហ្វាយ អន់ រ៉ាវ៉ាច់ ឡឹង សារ យច អន់ដីស ត្រគ់ ប៉ាតុំ គួប សោប ប៉ានេ សាំប‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័។ ត្រគ់ កំ អូ សា សាណា ញ៉ា លូ អ្យក់ កាណាគ័ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ពឹង ដារ់ ណោះ អន់ដីស អូ ត្រគ់ ប៉្រគ័ ង៉ារ ញ៉ា អុះ ខង ដារ់ ណោះ សាំរ៉ាប់ ហ្វាយ ឡាកោ អន់ រ៉ាវ៉ាច់ ឡឹង សារ យច ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ពឹង ដារ់ ណោះ បក់ ពឿ សា សាណា អូ ចៃ កំ ឡាក់ កា ពូ ត្រគ់ តាំងហ្យិត ឡាច់ ឡឹង កាំឡាំង សុនសាត អ៊ែ ទៅ។ ");
INSERT INTO tpu_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","បក់ ចំ ប៉្រគ័ ង៉ារ ពឹង ដារ់ ណោះ អាញ់ ចឹង ប៉ាន់តោ័ អ្លាត អ៊ែ ឡឹង កាំឡាំង សុនសាត អ៊ែ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","អន់ដីស អូ ត្រគ់ ប៉្រគ័ ង៉ារ ញ៉ា អុះ អា ហង ឃឺ ចាបាប់ ឡាក់ អន់ដីស ត្រគ់ ប៉្រគ័ ពួយ លើយ គ្រឹប រ៉ាំងហាវ លូ គ្រឹប ចារ អន់ដីស អ្វៃ។ ");
INSERT INTO tpu_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","ដារ់ ទី ១០ ណោះ ឃឺ ដារ់ អន់ដីស ត្រគ់ រ៉ាឡូវ លូ កំ អូ សា សាណា ញ៉ា ដេល។ ហះកា អន់ដីស ត្រគ់ រ៉ាឡូវ អ្យក់ ឡឹង កាង៉ាច ដារ់ ទី ៩ លើយ ទឹល កាង៉ាច ដារ់ ទី ១០»។ ");
INSERT INTO tpu_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា ");
INSERT INTO tpu_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«ហគ់ រ៉ះ កា ប៉ាសុន អ៊ីស្រាអ៊ែល នីអៀ៖ ពឹង ដារ់ ទី ១៥ កាណុង ខៃ ៧ ឃឺ ដារ់ ប៊ុន រ៉ាណើះ សាំរ៉ាប់ ប៉ានេ សាំប‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័ ចំលួន តាំប៉ើះ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ពឹង ដារ់ ទី ម៉ោញ អន់ដីស ត្រគ់ ប៉ាតុំ គួប សោប ប៉ានេ សាំប‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័។ អន់ដីស អូ ត្រគ់ ប៉្រគ័ ង៉ារ ញ៉ា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","អន់ដីស ត្រគ់ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ចំលួន តាំប៉ើះ ដារ់។ ពឹង ដារ់ ទី តាំងហាម ត្រគ់ ប៉ាតុំ គួប សោប ប៉ានេ សាំប‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័ លូ ពុះ កាណាគ័ រ៉ាម៉ះ អ៊ែ។ ដារ់ ណោះ ឃឺ ដារ់ តាគ់ អង់កេះ ប៊ុន អន់ដីស អូ ត្រគ់ ប៉្រគ័ ង៉ារ ញ៉ា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","«អា ឡាក់ ដារ់ សាំខាន់ៗ ម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ដារ់ អន់ដីស ត្រគ់ ប៉ាតុំ គួប សោប ប៉ានេ សាំប‌៉័ះ អ៊ែ ភឿ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័  ឃឺ ពុះ អ្លាត កាណាគ័ ទិ មប តាប៉ុង លូ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ភឿ សា អន់ឌូ លូ គួប សោប លូ អ្យក់ តាពែ ស្រោច អន់ហ្នឹង។ ត្រគ់ អន់ កាណាគ័ ម៉ោញៗ ណោះ តាម ដារ់ កាំឡត់។ ");
INSERT INTO tpu_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ប៊ុន ទិ អា ឃឺ ត្រគ់ ប៉្រគ័ តាង ឡឹង ដារ់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ រ៉ាឡូវ រ៉ប់ អាទិត។ កាណាគ័ រ៉ាម៉ះ ទិ អា កា តាង ឡឹង កាណាគ័ រ៉ាម៉ះ អន់ទៀគៗ ឡាក់ អន់ដីស ឃើយ អន់ តាង ឡឹង កាណាគ័ អន់ដីស បន់ លូ តាង ឡឹង កាណាគ័ អន់ដីស មប កា ប‌៉្រ័ះ ប៊កកាតយ័ តាម ពុត ប៉ិច។ ");
INSERT INTO tpu_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","«ពឹង ដារ់ ទី ១៥ កាណុង ខៃ ៧ ប៉ាគ់ អន់ដីស ប៉ាតុំ ពៀ ភែ សាណា សាណឹត កេះ ទិ កេះ ត្រគ់ ប៉្រគ័ ប៊ុន កា ប‌៉្រ័ះ ប៊កកាតយ័ ចំលួន តាំប៉ើះ ដារ់។ ដារ់ ទី ម៉ោញ លូ ដារ់ ទី តាំងហាម ឃឺ ដារ់ រ៉ាឡូវ។ ");
INSERT INTO tpu_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ពឹង ដារ់ ទី ម៉ោញ អន់ដីស ត្រគ់ អ្យក់ ប៉្លៃ អ៊្លង ដាគ់ៗ តាំងកង់ រ៉ាសៃ លូ តាំងកង់ អ្យិត ដាគ់ តាឌុក ទឹប ហ្លា អ៊្លង ឡាក់ ហ៊ន រហាង ទៀក សាំរ៉ាប់ ប៉្រគ័ រ៉ាណើះ កេះណោះ ប៉្រគ័ ប៊ុន អន់ រ៉គ់ សើម ចំលួន តាំប៉ើះ ដារ់ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","រ៉ប់ សាណាំ ត្រគ់ ប៉្រគ័ ប៊ុន ម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ចំលួន តាំប៉ើះ ដារ់ ចាបាប់ អា អន់ដីស ត្រគ់ ប៉្រគ័ ពួយ លើយ គ្រឹប រ៉ាំងហាវ។ ប៊ុន អា ត្រគ់ ប៉្រគ័ ពឹង ខៃ ៧។ ");
INSERT INTO tpu_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","អន់ដីស ទិឌូ ត្រគ់ អ្វៃ កាណុង រ៉ាណើះ ចំលួន តាំប៉ើះ ដារ់ តាំងឡា ស្រុក ទិឌូ កាណុង ប៉ាថេត អ៊ីស្រាអ៊ែល គ្រឹប ស្រុក ត្រគ់ អ្វៃ កាណុង រ៉ាណើះ ");
INSERT INTO tpu_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ភឿ អន់ គន សោ អន់ដីស អ្លុ អន់តគ់ ផា ផះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាណាំ សុនសាត អ៊ីស្រាអ៊ែល ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប អ៊ែ អន់ អន់ឌែ អ្វៃ កាណុង រ៉ាណើះ។ «អាញ់ ឃឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស»។ ");
INSERT INTO tpu_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","វគ័ ម៉ូសេ កា រ៉ះ កា សុនសាត អ៊ីស្រាអ៊ែល ឡឹង ឡាបៀប ត្រគ់ ប៉្រគ័ ប៊ុន សាំខាន់ៗ ទិ អា សាំរ៉ាប់ ប៉ានេ សាំប‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ …");
INSERT INTO tpu_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","មួត ប៉ាសុន អ៊ីស្រាអ៊ែល អន់ឌែ កាប រ៉ាបឹក រ៉ាចប់ ញន កា សារ ឡាំបាក កាតាំង ទឹល ប៉ាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ផះ អ៊ែ កាតាំង មួត ប៉ាសុន កាប រ៉ាបឹក រ៉ាចប់ នីណោ័ះ អ៊ែ អឺក ខាក់។ អ៊ែ ប៉្រគ័ អន់ ទី អុញ សា ថាំឡាយ ចារ រ៉ាណើះ រសានែង។ ");
INSERT INTO tpu_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","មួត ប៉ាសុន អន់ឌែ អង់ហ្យាំង អើ វគ័ ម៉ូសេ ម៉ូសេ កា ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័  អុញ ណោះ កា ប៉ាត់ រ៉ាង៉ាប់ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","អន់ឌែ អន់ សិច ចារ ណោះ ផា តាបេរ៉ា  ខង អុញ ប‌៉្រ័ះ ប៊កកាតយ័ សា ថាំឡាយ ពឹង ចារ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","កាប៉ាច់ មួត សុនសាត អន់ទៀគ ឡាក់ អ្វៃ អន់ឌូ លូ សុនសាត អ៊ីស្រាអ៊ែល អន់ឌែ កា កាចាំង ប៉ិច កា ទី សាណា ប៉ាអាំៗ មួត អ៊ីស្រាអ៊ែល អន់ឌែ កា ញ៉ាំ ឡូត ពួយ ពូ ដេល លូ កាប ផា «នីចម័ ចឹង ទី សាណា ខាច កា ពិន ចឹង សា ? ");
INSERT INTO tpu_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ពិន កាចាំង កា កា ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ឡាក់ ពិន សា អូ ទី ឡាច់ លៀន លូ កាចាំង កា ប៉្យា លូ កាចាម័ គ្រឹប នែវ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","កិញអៀ អា ពិន អូ ត្រូះ ខង អូ ទី សាណា ញ៉ា អុះ ទី ដឹង ណុំ ម៉ាណា អា ហង អ្វៃ ហះ ម៉ាត់ ពិន អា»។ ");
INSERT INTO tpu_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","ណុំ ម៉ាណា ណោះ ត្រង័ អ៊ែ ឡាក់ កា តីល ឡាង៉ា ហះកា បាក។ ");
INSERT INTO tpu_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","មួត ប៉ាសុន ទូញ ណុំ ម៉ាណា ណោះ អ្យក់ គ្លែ ពឹង តាប៉ាល់ កេះណោះ សាន់តុក លើ ប៉្រគ័ ណុំ ឡាតាំង ណុំ ម៉ាណា ប៉ាអាំ ឡាក់ កា ណុំ រ៉ាំងអ្វាល់ លូ ប៉ុង។ ");
INSERT INTO tpu_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","ផះ កាម៉ាំង ទៀក ងម ឡិ ពឹង ចារ រ៉ាណើះ ណោះ ណុំ ម៉ាណា កា ហ្រុង អន់ឌូ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","វគ័ ម៉ូសេ កាតាំង មួត ប៉ាសុន អង់ហ្យាំង ញ៉ាំ ហះ អំប៉ារ រ៉ាណើះ ពឿ រ៉ាណើះ អ៊ែ ទិឌូ។ ប‌៉្រ័ះ ប៊កកាតយ័ អឺក កា អន់ឌែ ខាក់ វគ័ ម៉ូសេ កា យច ពុត ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","វគ័ ម៉ូសេ កា អំប៉ញ់ លូ ប‌៉្រ័ះ ប៊កកាតយ័ ផា «ញ៉ា ត្រគ់ អីស ប៉្រគ័ អន់ អាញ់ ថុក ពុត នីអៀ ? ខ ញ៉ា បះ អីស អូ តាប៉ាប កា អាញ់ ? ញ៉ា ត្រគ់ អីស មប មួត ប៉ាសុន ទិ អា អន់ កា អាញ់ រ៉ាំងហៃ ? ");
INSERT INTO tpu_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ញ៉ា អាញ់ ប ប៉ាំងកើត មួត ប៉ាសុន ទិ អា ? ញ៉ា អាញ់ ហង ប មើគ ពឹ អន់ឌែ អា បះ អីស ប៉្រើ អាញ់ រ៉ាំងហៃ រ៉ាំងខ្យា អន់ឌែ ឡាក់ កា មើគ តាម៉ម់ គន លើយ ទឹល ប៉ាថេត ឡាក់ អីស ម៉ត់ លូ វគ័ យ៉ាគ់ ញឹន ពែ ផា ចឹង មប ប៉ាថេត អន់ កា អន់ឌែ ណោះ ? ");
INSERT INTO tpu_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","អាញ់ ចឹង ឡាំ ណាំង សាណា ខាច ឡឹង ចំ ចឹង ទី អន់ កា មួត ប៉ាសុន ទិ អា សា ? អន់ឌែ កា ញ៉ាំ ជុំ អាញ់ លូ កាប ផា \"អីស ណាំង សាណា ខាច អន់ កា ញឹន សា ពិ\"។ ");
INSERT INTO tpu_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","អាញ់ អូ អ្លុ អុះ រ៉ាំងហៃ ប៉ាសុន ទិ អា ដឹង អាញ់ ខង សារ អា ឡាំបាក តាឡាម័ សាំរ៉ាប់ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ផា អីស ប៉្រគ័ កា អាញ់ នីអៀ ហគ់ ប៉ាន់តោ័ អាញ់ ឡូត ពិ ជែ អន់ អាញ់ ទី សារ ឡាំបាក នែវ អា ផា អីស តាប៉ាប កា អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហគ់ អីស ប៉ាតុំ មួត ក្រាគ់ តាំងកង់ កាណុង សុនសាត អ៊ីស្រាអ៊ែល ឡាក់ អីស អន់ហ្នាល់ ផា ម៉ៃគ ណាំផា មួត ប៉ាសុន តាទឹច អន់ ទី ៧០ ដូវ ប៉្រើ អន់ឌែ ឡាំ ប៉ាគ់ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ លូ អន់តាវ ហះ ចារ ណោះ អន់ឌូ លូ អីស។ ");
INSERT INTO tpu_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","អាញ់ ចឹង ជឹរ កាកាប លូ អីស កេះណោះ អាញ់ ចឹង អ្យក់ ប៉ាង៉ាត័ ប៉ាលឹង អាញ់ ឡាក់ អ្វៃ កាណុង អីស អន់ដា អន់ អ្វៃ ពឹង អន់ឌែ ភឿ អន់ អន់ឌែ តង័ ង៉ារ ឡាំបាក រ៉ាំងហៃ រ៉ាំងខ្យា មួត ប៉ាសុន អន់ឌូ លូ អីស ដេល ជែ អន់ ទី សារ ឡាំបាក ម៉ោញ ដូវ អីស។ ");
INSERT INTO tpu_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","ហគ់ រ៉ះ កា មួត ប៉ាសុន ផា \"អ្យគ័ អន់ដីស ទ្រៀម ឡាកោ អន់ ដាគ់ សាំរ៉ាប់ ដារ់ តាយ៉ាង័ ម៉ាគ់ អន់ដីស ចឹង ទី សាណា ខាច សា ហង ខង អន់ដីស ញ៉ាំ កាតាំង ទឹល ប‌៉្រ័ះ ប៊កកាតយ័ កេះ អន់ដីស ផា 'ពឿ ចឹង អន់ សាណា ខាច កា ពិន សា ? ផះ ពិន អ្វៃ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ពែ ដាគ់ រ៉គ់ ហ៊្លត'។ ទឹល នីណោ័ះ ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង អន់ សាណា ខាច កា អន់ដីស សា ហង។ ");
INSERT INTO tpu_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","អន់ដីស ចឹង សា សាណា ខាច ណោះ អូ ត្រគ់ ដឹង ម៉ោញ ដារ់ ពៀរ ដារ់ តាម័ ដារ់ ១០ ដារ់ ២០ ដារ់ ណោះ អុះ ");
INSERT INTO tpu_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ឃឺ អន់ដីស ចឹង សា លើយ ទឹល ម៉ោញ ខៃ តុត ផីគ តុត យ៉ឺម កាខាក់ ទឹល ឡាច់ ហាក់ ឡាច់ តាលន ឡូត ខង អន់ដីស អ្លាត ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ អ្វៃ អន់ឌូ លូ អន់ដីស ទឹប ញ៉ាំ ហះ ម៉ាត់ អ៊ែ លូ កាប ផា 'ញ៉ា ត្រគ់ ពិន ប៉ាណាំ គួប ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប នីអៀ ?' \"»។ ");
INSERT INTO tpu_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","វគ័ ម៉ូសេ តើល ផា «មួត កាំឡាំង ប៉ាសុន ឡាក់ អ្វៃ អន់ឌូ លូ អាញ់ ទី ត្រោ ស៊ែន ដូវ កាគ់ ដឹង កាម៉ាក័ ផា អីស អន់ សាណា ខាច កា អន់ឌែ សា ប៉ាញ័ ម៉ោញ ខៃ នីចម័ ចឹង ហ្លោះ ? ");
INSERT INTO tpu_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","យ‌៉័ះ កោះ តាប៉ល់ ចៀម កោះ តាប៉ល់ រ៉ក់ អន់ កា អន់ឌែ សា កា អូ ហ្លោះ អុះ យ‌៉័ះ ត្រេះ ជៀល អ្យក់ កា ឡឹង ទៀក សាឡីគ សាឡាយ ទិ អន់ កា អន់ឌែ សា កា អូ ហ្លោះ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","ប‌៉្រ័ះ ប៊កកាតយ័ តើល វគ័ ម៉ូសេ ផា «ញ៉ា អំរ៉ាញ អាញ់ អា អូ អ្លុ ប៉្រគ័ សារ អា ប ? បាប៊ែត ណាវ្គ អីស ចឹង ប៉ប័ ផា ប៉ានឹរ អាញ់ កាប អា កើត តាទឹច ញ៉ា អូ»។ ");
INSERT INTO tpu_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","វគ័ ម៉ូសេ កា ចាក ឡាច់ ឡឹង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ កេះណោះ ឡាំ រ៉ះ ប៉ានឹរ ប‌៉្រ័ះ ណោះ កា មួត ប៉ាសុន។ អ៊ែ ប៉ាតុំ មួត ម៉ៃគ ណាំផា កាណុង សុនសាត អ៊ីស្រាអ៊ែល ណោះ ទី ៧០ ដូវ កេះណោះ ប៉ាណាំ អន់ឌែ ពឹះ អន់តាវ ជុំ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","ប‌៉្រ័ះ ប៊កកាតយ័ ជឹរ អ្វៃ កាណុង កាម៉ល់ កេះណោះ កាកាប លូ វគ័ ម៉ូសេ។ អ៊ែ អ្យក់ ឡាច់ ប៉ាង៉ាត័ ប៉ាលឹង អ៊ែ អន់ដា ឡឹង វគ័ ម៉ូសេ អន់ ពឹង មួត ម៉ៃគ ណាំផា ៧០ ដូវ ណោះ។ ផះ ប៉ាង៉ាត័ ប៉ាលឹង ប‌៉្រ័ះ ជឹរ អ្វៃ ពឹង អន់ឌែ ណោះ អន់ឌែ កាកាប ឡាក់ កា រ៉ាគឹយ ប‌៉្រ័ះ ឡូត ហះកា អន់ឌែ កាកាប នែវ អា ដឹង ម៉ោញ ទង ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","ទី មួត ម៉ៃគ ណាំផា ពៀរ ដូវ ម៉ោញ ដូវ សិច អ៊ែលដាត ម៉ោញ ដូវ មីដាត អន់ឌែ ឡាក់ កាំឡាំង ណោះ ដេល ហះកា អន់ឌែ អូ ឡាំ ប៉ាគ់ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ អុះ អន់ឌែ អ្វៃ ប៉ាគ់ ចារ រ៉ាណើះ ទៅ។ ប៉ាង៉ាត័ ប៉ាលឹង ប‌៉្រ័ះ កា ម៉ុត អ្វៃ ពឹង អន់ឌែ ដេល អន់ឌែ កា កាកាប ឡាក់ កា រ៉ាគឹយ ប‌៉្រ័ះ ប៉ាគ់ ចារ រ៉ាណើះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ទី តាតាម័ ម៉ោញ ដូវ សាតាក់ ឡាំ រ៉ះ កា វគ័ ម៉ូសេ ផា «វគ័ អ៊ែលដាត លូ វគ័ មីដាត ផះ អ្វៃ កាកាប ឡាក់ កា រ៉ាគឹយ ប‌៉្រ័ះ ប៉ាគ់ ចារ រ៉ាណើះ តោ»។ ");
INSERT INTO tpu_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","ផះ ណោះ យូស្វេ ឡាក់ តង័ ង៉ារ វគ័ ម៉ូសេ ឡឹង អ៊ែ អ្វៃ តាតាម័ អ៊ែ កាប ផា «អឺ ពឹ តាំងឡា អីស ឡាំ ទឹប អន់ឌែ រិញ»។ ");
INSERT INTO tpu_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","ហះកា វគ័ ម៉ូសេ តើល ផា «ញ៉ា អីស សាណីង តាង អាញ់ ប ? អាញ់ ប៉ិច អន់ មួត ប៉ាសុន ប‌៉្រ័ះ ប៊កកាតយ័ ទិឌូ អ្លុ ប៉្រគ័ រ៉ាគឹយ ប‌៉្រ័ះ ដេល។ អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ ប៉ាង៉ាត័ ប៉ាលឹង អ៊ែ អ្វៃ ពឹង អន់ឌែ ទិឌូ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","កេះណោះ វគ័ ម៉ូសេ លូ មួត ម៉ៃគ ណាំផា សុនសាត អ៊ីស្រាអ៊ែល កា សឹត ប៉ាគ់ ចារ រ៉ាណើះ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ ទី ខ្យាល ប៉ឹ ប៉ាណាំ ពឹះ សៃម ព្រោច ឡឹង ទៀក សាឡីគ សាឡាយ ឡិ ប៉ាញ័ ទឹប ចារ រណោះ ជុំ រ៉ាណើះ។ អំពុ តីស ចារ ព្រោច ឡិ ណោះ ចាំងហាយ្គ ខា ម៉ោញ ដារ់ ចាក លូ ពូក អំប៉ាំង គួប អ៊ែ កាពុល ពៀរ ហាត់ ។ ");
INSERT INTO tpu_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","មួត ប៉ាសុន ទិឌូ កា អ្យូវ រ៉ុប សៃម ព្រោច ណោះ ម៉ោញ ដារ់ ម៉ោញ ម៉ាំង ទឹល ដារ់ តាយ៉ាង័ ម៉ោញ ដារ់ ណាវ្គ កាណុង ម៉ោញ ដូវ រ៉ុប ព្រោច អ្យាង ប៊ែត ទី ១០ កាប៉ោ អន់ឌែ តាគ័ ព្រោច ណោះ ជុំ រ៉ាណើះ។ ");
INSERT INTO tpu_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ផះ អន់ឌែ អ្វៃ សា រ៉ាឡា ព្រោច ណោះ បើ តាន័ ទិ ប‌៉្រ័ះ ប៊កកាតយ័ អឺក ខាក់ អ៊ែ ប៉្រគ័ អន់ អន់ឌែ អីគ ព្លុ តោ័ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","ពូ អន់ សិច ចារ ណោះ ផា គីប៉្រូត ហាតាវ៉ា ខង ហះ ចារ ណោះ ពូ តប់ ប៉ាទ្រូ មួត បក់ ទី ពុត ប៉ិច កាខាក់ កា សាណា ខាច ពែ។ ");
INSERT INTO tpu_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","កេះណោះ មួត ប៉ាសុន អន់ឌែ ចាក ឡាច់ ឡឹង ចារ គីប៉្រូត ហាតាវ៉ា ឡាំ ប៉ាគ់ ចារ ហាសិរ៉ូត អន់ឌែ កា ប៉្រគ័ រ៉ាណើះ ហះ ណោះ ហង។ … ");
INSERT INTO tpu_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា ");
INSERT INTO tpu_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«ហគ់ អីស ប៉្រើ ពូ ឡាំ ហៃ ប៉ាថេត កាណាន ឡាក់ អាញ់ មប អន់ កា ប៉ាសុន អ៊ីស្រាអ៊ែល ណោះ ពិ ត្រគ់ អ្យក់ កាណុង ម៉ោញ ផូង័ ម៉ោញ ដូវ ត្រគ់ អ្យក់ ប៉ាណូស បក់ ប៉្រគ័ ម៉ៃគ ណាំផា ពូ»។ ");
INSERT INTO tpu_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","វគ័ ម៉ូសេ កា ប៉្រើ ពូ ឡាំ ឡឹង ស៊្រែ តីស ប៉ារ៉ាន ពួយ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ ណោះ ហង មួត កាម៉ាក័ បក់ ឡាំ ណោះ ស៊ុត កា ម៉ៃគ ណាំផា សុនសាត អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","សិច អន់ឌែ ណោះ ទី ឡាក់ កា អា៖ ឡឹង ផូង័ រូបេន សិច សាមួ ឡាក់ គន វគ័ សាគើរ ");
INSERT INTO tpu_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ឡឹង ផូង័ ស៊ីមៀន សិច សាផាត ឡាក់ គន វគ័ ហូរី ");
INSERT INTO tpu_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","ឡឹង ផូង័ យូដា សិច កាលែប ឡាក់ គន វគ័ យេភូនេ ");
INSERT INTO tpu_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ឡឹង ផូង័ អ៊ីសាខារ សិច យីកាល់ ឡាក់ គន វគ័ យូស៊ែប ");
INSERT INTO tpu_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ឡឹង ផូង័ អេប៉្រាអ៊ីម សិច ហូសេ ឡាក់ គន វគ័ នូន ");
INSERT INTO tpu_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ឡឹង ផូង័ បេនយ៉ាមីន សិច ប៉ាល់ធី ឡាក់ គន វគ័ រ៉ាភូ ");
INSERT INTO tpu_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ឡឹង ផូង័ សេប៊ូលុន សិច កាឌៀល ឡាក់ គន វគ័ ស៊ូឌី ");
INSERT INTO tpu_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ឡឹង ផូង័ ម៉ាណាសេ ឡាក់ គន សោ វគ័ យូស៊ែប សិច កាឌី ឡាក់ គន វគ័ ស៊ូស៊ី ");
INSERT INTO tpu_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","ឡឹង ផូង័ ដាន់ សិច អាមៀល ឡាក់ គន វគ័ កេម៉ាលី ");
INSERT INTO tpu_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ឡឹង ផូង័ អាស៊ើរ សិច សេធើរ ឡាក់ គន វគ័ មីគែល ");
INSERT INTO tpu_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","ឡឹង ផូង័ ណាប់ថាលី សិច ណាប៊ី ឡាក់ គន វគ័ វ៉ុបស៊ី ");
INSERT INTO tpu_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ឡឹង ផូង័ កាត សិច កេអួល ឡាក់ គន វគ័ ម៉ាគី។ ");
INSERT INTO tpu_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","អា ហង សិច មួត បក់ វគ័ ម៉ូសេ ប៉្រើ ឡាំ ហៃ ប៉ាថេត ណោះ។ គន វគ័ នូន សិច ហូសេ ហះកា វគ័ ម៉ូសេ អន់ សិច ផា យូស្វេ ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","វគ័ ម៉ូសេ ប៉្រើ អន់ឌែ ឡាំ ហៃ ប៉ាថេត កេះណោះ អន់តគ់ រ៉ះ ផា «ហគ់ ប៉ាណាំ គួប អន់ដីស ចាក ឡឹង ស៊្រែ ណេកិប អា ចាក ហាវ ទ្រង ព្រី ប៉ានឹម តោ។ ");
INSERT INTO tpu_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ហគ់ ហៃៗ នីចម័ ប៉ាថេត ណោះ ដាគ់ ដេល ប ? ប៉ាណូស អ្វៃ កាណុង ណោះ សាងុំ ញ៉ា អូ សាងុំ ? អន់ឌែ ណោះ ទី កាំឡាំង អៀង ដូវ ញ៉ា ប៊ែត ដូវ ? ");
INSERT INTO tpu_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ប៉ាថេត អន់ឌែ អ្វៃ ណោះ ដាគ់ ញ៉ា អូ ដាគ់ ? គ្រឹប ចារ អន់ឌែ អ្វៃ ណោះ ស្រុក ដោច ញ៉ា មឿង តីស ឡាក់ ទី ប៉ាន់ទៀយ កាចាប័ ? ");
INSERT INTO tpu_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","តេះ កាណុង ប៉ាថេត ណោះ ដាគ់ សាណា ញ៉ា អូ ដាគ់ ? ទី តើម អ៊្លង ញ៉ា អូ ទី ? អន់ដីស ត្រគ់ ទី ពុត ខឹន លូ អ្យក់ សឹត សាណា ឡឹង ប៉ាថេត ណោះ»។ ផះ រ៉ាំងវ៉ាង ណោះ ត្រគ់ ពឹង ថុន ប៉្លៃ អង់កាច ទុំ។ ");
INSERT INTO tpu_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","អន់ឌែ កា ចាក ឡាំ ហៃ ប៉ាថេត ណោះ ឡឹង ស៊្រែ តីស ស៊ីន លើយ ទឹល ស្រុក រេហូប ឡាក់ អ្វៃ ក្យាម័ ចារ ឡេបូ ហាម៉ាត់។ ");
INSERT INTO tpu_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","អន់ឌែ ឡាំ ប៉ាគ់ ស៊្រែ ណេកិប ចាក ឡាំ ទឹល ប៉ាគ់ មឿង ហេប្រូន អ្វៃ ពឹង មឿង ណោះ ទី គន សោ វគ័ អាណាក់ អន់ដា ទី សិច ឡាក់ កា អាហ៊ីម៉ាន សេសាយ លូ តាល់ម៉ាយ។ ពូ ប៉្រគ័ មឿង ហេប្រូន ណោះ អន់ទ្រួល ឡឹង ប៉្រគ័ មឿង សូអាន ពឹង ប៉ាថេត អ៊ីស៊ីប តាំប៉ើះ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","អន់ឌែ ចាក ទឹល ប៉ាគ់ តាចាង័ អេសាកុល។ ហះ ចារ ណោះ អន់ឌែ កាសិត តាំងកង់ ប៉្លៃ អង់កាច ម៉ោញ រ៉ាំប៉ឹល អន់ កា គួប អន់ឌែ ពៀរ ដូវ តូង័ អន់ឌែ កា អ្លេះ ប៉្លៃ ទទឹម លូ ប៉្លៃ ហ្រា អន់ដា ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ពូ អន់ សិច ចារ ណោះ ផា អេសាកុល  ខង ហះ ចារ ណោះ សុនសាត អ៊ីស្រាអ៊ែល អន់ឌែ កាសិត តាំងកង់ ប៉្លៃ អង់កាច ម៉ោញ រ៉ាំប៉ឹល។ ");
INSERT INTO tpu_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","អន់ឌែ ឡាំ ហៃ ប៉ាថេត ណោះ ទុញ ៤០ ដារ់ កេះ អន់ឌែ កា សឹត ហង។ ");
INSERT INTO tpu_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ទឹល ប៉ាគ់ ចារ រ៉ាណើះ កេះ អន់ឌែ កា ឡាំ ប៉ាគ់ វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ទឹប ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ ឡាក់ អ្វៃ ពឹង ចារ កាដេះ កាណុង ស៊្រែ តីស ប៉ារ៉ាន ណោះ ហង កេះណោះ រ៉ះ សារ អន់ឌែ ឡាំ ហៃ ប៉ាថេត ណោះ កា វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ទឹប កា ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ លូ តាំបាង ប៉្លៃ ឡាក់ អន់ឌែ អ្លេះ អ្យក់ សឹត ឡឹង ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","អន់ឌែ រ៉ះ កា វគ័ ម៉ូសេ នីអៀ «ញឹន ឡាំ ទឹល ប៉ាគ់ ប៉ាថេត ឡាក់ អីស ប៉្រើ ឡាំ ហៃ ពែ កេះ ពឹង ប៉ាថេត ណោះ ទី ទៀក តុះ រ៉ក់ លូ ទៀក សុត អៀង តាទឹច ហង អីស ហៃ ប៉្លៃ ញឹន អ្លេះ អ្យក់ សឹត អា។ ");
INSERT INTO tpu_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","ហះកា ប៉ាណូស បក់ អ្វៃ ពឹង ប៉ាថេត ណោះ ស៊ុត កា ប៉ាណូស សាងុំ កេង ខាក់ មឿង អន់ឌែ កា តីស ទឹប ទី ប៉ាន់ទៀយ កាចាប័។ ញឹន ប៉ប័ គន សោ វគ័ អាណាក់ អន់ឌែ អ្វៃ ពឹង ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","សុនសាត អាម៉ាឡេក អ្វៃ ពឹង ស៊្រែ ណេកិប។ សុនសាត ហេត សុនសាត យេប៊ូស លូ សុនសាត អាម៉ូរី អន់ឌែ អ្វៃ ពឹង ព្រី ប៉ានឹម។ កាប៉ាច់ សុនសាត កាណាន អន់ឌែ អ្វៃ រហាង ទៀក សាឡីគ សាឡាយ លូ រហាង ទៀក ទ្រូង យដាន់»។ ");
INSERT INTO tpu_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","មួត ប៉ាសុន ប៉ាណាំ គួប ណាំង សារ លូ វគ័ ម៉ូសេ ហះកា កាលែប ទឹប អន់ឌែ ផា «អ្វៃ រ៉ាង៉ាប់» លូ កាប ផា «ពិ ពិន ឡាំ តាប៉ីត អ្យក់ ប៉ាថេត ណោះ ខង ចឹង ទី ទ្រង ពិន ឡូត»។ ");
INSERT INTO tpu_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","ហះកា មួត បក់ ឡាំ ហៃ ប៉ាថេត អន់ឌូ លូ អ៊ែ ណោះ កាប ផា «ពិន ចឹង ឡាំ តាកូះ លូ អន់ឌែ អូ ដាម័ អុះ ខង អន់ឌែ សាងុំ កេង ឡឹង ពិន»។ ");
INSERT INTO tpu_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","អន់ឌែ រ៉ះ ផា ប៉ាថេត អន់ឌែ ឡាំ ហៃ ណោះ អូ ដាគ់ អុះ លូ រ៉ះ កា ប៉ាសុន អ៊ីស្រាអ៊ែល ផា «ប៉ាថេត ញឹន ឡាំ ហៃ ណោះ ឃឺ ប៉ាថេត ថាំឡាយ មួត ប៉ាសុន។ ញឹន ប៉ប័ ប៉ាណូស អ្វៃ ពឹង ប៉ាថេត ណោះ ស៊ុត កា តីស ចាំងហីគ។ ");
INSERT INTO tpu_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","ញឹន ប៉ប័ ប៉ាណូស រ៉ាតីស ឃឺ គន សោ វគ័ អាណាក់។ ផះ ញឹន ហៃ អន់ឌែ ញឹន ពៀប ឡាក់ កា ឡៃប អន់ឌែ កា កាប ដេល ផា \"អន់ដីស ឡាក់ កា ឡៃប\"»។ ");
INSERT INTO tpu_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","កេះណោះ មួត ប៉ាសុន អ៊ីស្រាអ៊ែល អង់ហ្យាំង ឡុង ម៉ាំង ណោះ អន់ឌែ កា ញ៉ាំ ទិឌូ។ ");
INSERT INTO tpu_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","អន់ឌែ កាប រ៉ាបឹក រ៉ាចប់ អឺក កា វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន អន់ឌែ ទិឌូ កាប ផា «ផា អន់ ញឹន តោ័ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប លើ តោ័ ពឹង ស៊្រែ តីស អា ណោះ ដាគ់ ហ៊្លត។ ");
INSERT INTO tpu_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","ញ៉ា ត្រគ់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាណាំ ញឹន ឡាំ ប៉ាគ់ ប៉ាថេត អា អន់ ញឹន តោ័ ញន កា ត្រគ់ ដាវ នីអៀ លូ អន់ គន កាម៉ាញ់ ញឹន ត្រគ់ តី ពូ ដេល ? នីចម័ ផា ពិន វ៉ីល សឹត ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ណាវ្គ ញ៉ា អូ ដាគ់ ប ?» ");
INSERT INTO tpu_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","អន់ឌែ កា កាប លូ គួប ផា «ពិ ពិន រ៉ើស ប៉ាណូស ម៉ោញ ដូវ អន់ អ៊ែ ប៉្រគ័ ម៉ៃគ ណាំផា កេះណោះ ប៉ាណាំ ពិន វ៉ីល សឹត ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ជន តាកុល មូប កល់ ទឹះ តេះ ហះ ម៉ាត់ មួត ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ។ ");
INSERT INTO tpu_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","កាណុង កាំឡាំង អន់ឌែ បក់ ឡាំ ហៃ ប៉ាថេត កាណាន ណោះ ពែ យូស្វេ គន វគ័ នូន លូ កាលែប គន វគ័ យេភូនេ អន់ឌែ កា ហ៊ែក អាវ អន់ឌែ ទៅ ");
INSERT INTO tpu_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","លូ រ៉ះ កា ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ ផា «ប៉ាថេត ញឹន ឡាំ ហៃ ណោះ ឃឺ ប៉ាថេត ដាគ់ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","ផា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាញ័ ពុត កា ពិន អ៊ែ ចឹង ប៉ាណាំ ពិន ម៉ុត កាណុង ប៉ាថេត ណោះ ទឹប អ៊ែ ចឹង មប ប៉ាថេត ឡាក់ ទី ទៀក តុះ រ៉ក់ លូ ទៀក សុត អៀង ណោះ អន់ កា ពិន តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","ជែ អ្លុ ដឹង កា តាប៉ុញ អូ ណីស កា ប‌៉្រ័ះ ប៊កកាតយ័ ។ ជែ អ្យូគ កា ប៉ាណូស កាណុង ប៉ាថេត ណោះ ខង សាអ៊្លង ពិន កេះ អន់ឌែ ណោះ អូ ទី កាណាគ័ ញ៉ា ចឹង ប៉ងកាន់ អន់ឌែ អុះ។ ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ អន់ឌូ លូ ពិន កេះ ជែ អ្យូគ ហង កា អន់ឌែ ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","ផះ ណោះ មួត ប៉ាសុន ទិឌូ ឃឹត ចឹង អ្យក់ អំហ្មោ ហឹរ ប៉ាន់តោ័ អន់ឌែ ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ តាំបាង តាតារ ក្លាគ់ អ៊ែ ពឹង ចារ រ៉ាម៉ះ អន់ កា ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ ប៉ប័។ ");
INSERT INTO tpu_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","ប‌៉្រ័ះ ប៊កកាតយ័ កាប លូ វគ័ ម៉ូសេ ផា «ប៉ាសុន អា បឺង៉ាយ អាញ់ ទឹល ដារ់ ចំ ណាវ្គ ? អាញ់ តាំបាង សារ អំរ៉ាញ អឺញ កេង ខាក់ អៀង ទង កេះ អន់ អន់ឌែ ប៉ប័ ហះកា អន់ឌែ អ្វៃ កា អូ ចៃ សឿ អាញ់ ទឹល ដារ់ ចំ ណាវ្គ ? ");
INSERT INTO tpu_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","ទឹល នីណោ័ះ អាញ់ ចឹង ប៉ាន់តោ័ អន់ឌែ លូ ប៉ាញុ រ៉ាំបល់ តីស ទឹប អាញ់ ចឹង អ្យក់ សឹត ប៉ាដក់ ប៉ាជៀ ឡឹង អន់ឌែ ហង។ កេះណោះ អាញ់ ចឹង ប៉្រគ័ អន់ ទី ប៉ាសុន អៀង កើត ឡាច់ ឡឹង អីស ឡាក់ សាងុំ កេង ខាក់ ហ៊្លត ឡឹង អន់ឌែ អា»។ ");
INSERT INTO tpu_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","ហះកា វគ័ ម៉ូសេ រ៉ះ កា ប‌៉្រ័ះ ប៊កកាតយ័ ផា «ផា អីស ប៉្រគ័ នីណោ័ះ ប៉ាសុន អ៊ីស៊ីប ចឹង អ្លុ អន់តគ់ ខង អីស ប៉ាណាំ ប៉ាសុន អា ឡាច់ ឡឹង ប៉ាថេត អន់ឌែ ណោះ ពែ ញន កា អំរ៉ាញ អឺញ កេង ខាក់ ម៉ះ អីស។ ");
INSERT INTO tpu_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ពូ កា ចឹង រ៉ះ តូៗ ទឹល ប៉ាណូស កាណុង ប៉ាថេត អា ពូ កាតាំង លៅ កេះ ផា អីស អ្វៃ អន់ឌូ លូ មួត ប៉ាសុន អា។ ពូ កា កាតាំង ដេល ផា មួត ប៉ាសុន អា ប៉ប័ អីស ម៉ាត់ អន់ឌែ តាំងឡា ទឹប ប៉ប័ អីស ម៉ាច់ កេះ កាម៉ល់ អ្វៃ អំប៉ាំង អន់ឌែ លូ ប៉ាណាំ ទ្រង អន់ឌែ រ៉ប់ ដារ់ ផះ កាម៉ាំង ប៉ប័ អីស ម៉ាច់ កេះ អុញ ប៉ាណាំ ទ្រង អន់ឌែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ផា អីស ប៉ាន់តោ័ ប៉ាសុន អា អន់ តោ័ ទិ នែវ អា មួត សុនសាត អន់ទៀគ បក់ កាតាំង លៅ ឡឹង សារ អីស អា អន់ឌែ ចឹង កាប ផា ");
INSERT INTO tpu_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","\"ញន កា អ៊ែ អូ អ្លុ ប៉ាណាំ ប៉ាសុន ណោះ ម៉ុត កាណុង ប៉ាថេត ឡាក់ អ៊ែ ម៉ត់ ផា ចឹង មប កា អន់ឌែ ណោះ ពែ ណោះ ហង បះ អ៊ែ ប៉ាន់តោ័ អន់ឌែ ពឹង ស៊្រែ តីស ឡគ\"។ ");
INSERT INTO tpu_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","កិញអៀ អា អាញ់ ប៉រ់ ឡោម ឡា អីស អន់ តាំបាង សារ អំរ៉ាញ អឺញ កេង ខាក់ ម៉ះ អីស ឡាក់ កា អីស រ៉ះ ផា ");
INSERT INTO tpu_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","\"អាញ់ ទី ពុត អត់ សាំរ៉ាញ័ លូ ទី ពុត ប៉ិច ចៃ លើយ។ អាញ់ អូ អ្យក់ យ៉ូ សារ យច លូ សារ អូ ដាគ់ ឡាក់ អន់ឌែ ប៉្រគ័ ហះកា បក់ ប៉្រគ័ យច ប៉ាសាំង លូ អាញ់ អាញ់ ចឹង ចៃគ ថូត ប៉ាណូស ណោះ ឡឹង ពឹ ទឹល គន សោ ប៉ៃង ប៉្វាន់ រ៉ាំងហាវ ឡូត\"។ ");
INSERT INTO tpu_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","ប៉រ់ អីស ជែ អ្យក់ យ៉ូ សារ យច មួត ប៉ាសុន អា ពួយ ឡាក់ កា ពុត អីស ប៉ិច ចៃ ណោះ ហង ឡាក់ កា អីស អូ អ្យក់ យ៉ូ សារ អន់ឌែ ប៉្រគ័ យច ឡឹង ប៉ាថេត អ៊ីស៊ីប ទឹល ប៉ាគ់ ចារ អា ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","ប‌៉្រ័ះ ប៊កកាតយ័ តើល ផា «អាញ់ ចឹង អូ អ្យក់ យ៉ូ សារ អន់ឌែ យច ណោះ ពួយ ប៉ានឹរ អីស កេះ។ ");
INSERT INTO tpu_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ហះកា អាញ់ ឡាក់ ប‌៉្រ័ះ ទី អាញុ អ្វៃ រ៉ីស លើយ លូ ទី សារ អំរ៉ាញ អឺញ ប៉ាញ័ ទឹប អង់កក់ តេះ អាញ់ ប៉រ់ រ៉ះ តាទឹច ផា ");
INSERT INTO tpu_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","មួត អា ប៉ប័ កេះ សារ អំរ៉ាញ អឺញ អាញ់ លូ ប៉ប័ ទិ សារ កេង ខាក់ ឡាក់ អាញ់ ប៉្រគ័ កាណុង ប៉ាថេត អ៊ីស៊ីប ពែ លូ ពឹង ស៊្រែ តីស អា ហះកា អន់ឌែ ប៉្រគ័ យច លូ អាញ់ អញ់ជឹត ទង កេះ។ ");
INSERT INTO tpu_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ទឹល នីណោ័ះ អន់ឌែ ចឹង អូ ទី ប៉ប័ ប៉ាថេត ឡាក់ អាញ់ ម៉ត់ លូ វគ័ យ៉ាគ់ អន់ឌែ ពែ ផា អាញ់ ចឹង មប អន់ កា អន់ឌែ ណោះ។ ទិ បក់ បឺង៉ាយ អាញ់ នីអៀ អន់ឌែ ចឹង អូ ទី ប៉ប័ ប៉ាថេត ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","ហះកា កាលែប ឡាក់ ប៉្រគ័ ង៉ារ កា អាញ់ ណោះ អាញ់ ចឹង ប៉ាណាំ អ៊ែ ម៉ុត កាណុង ប៉ាថេត ឡាក់ អ៊ែ ឡាំ ហៃ ណោះ។ ផូង័ វ៉ាច់ អ៊ែ ចឹង ទី ប៉ាថេត ណោះ ប៉្រគ័ ប៉ាដក់ ប៉ាជៀ ខង អ៊ែ ទី ពុត តាង ឡឹង ពូ ទឹប អ៊ែ ប៉្រគ័ ពួយ ប៉ានឹរ អាញ់ ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","ហៃ សុនសាត អាម៉ាឡេក លូ សុនសាត កាណាន អ្វៃ ពឹង ស៊្រែ រជុង ប៉ានឹម ណោះ ទឹល នីណោ័ះ ដារ់ តាយ៉ាង័ ទៀ អន់ដីស ត្រគ់ វ៉ីល សឹត ប៉ាគ់ ស៊្រែ តីស ចាក ទ្រង តាំងលេ តីស ស៊ូប ណាវ្គ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ផា ");
INSERT INTO tpu_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«អាញ់ កាតាំង កេះ ប៉ានឹរ ប៉ាសុន អ៊ីស្រាអ៊ែល កាប រ៉ាបឹក រ៉ាចប់ អឺក កា អាញ់ ណោះ។ មួត ប៉ាសុន អូ ដាគ់ អា ចឹង កាប នីអៀ ទឹល ដារ់ ចំ ណាវ្គ ? ");
INSERT INTO tpu_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","ហគ់ រ៉ះ កា អន់ឌែ ផា \"អាញ់ ឡាក់ ប‌៉្រ័ះ ទី អាញុ អ្វៃ រ៉ីស លើយ ប៉រ់ រ៉ះ ផា អាញ់ ចឹង ប៉្រគ័ កា អន់ដីស តាទឹច ពួយ ប៉ានឹរ អាញ់ កាតាំង អន់ដីស កាប ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","អន់ដីស ចឹង តោ័ អ្លាត កាន់តីង ពឹង ស៊្រែ តីស អា ហង ឃឺ ទិ ប៉ាណូស ឡាក់ ពូ ទី ច្រាគ់ សិច កាណុង ផាប់ អ្យក់ ឡឹង អាញុ ២០ សាណាំ អន់ ហាវ ឃឺ ប៉ាណូស បក់ កាប រ៉ាបឹក រ៉ាចប់ អឺក កា អាញ់ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","អន់ដីស ទិឌូ ចឹង អូ ទី ម៉ុត កាណុង ប៉ាថេត ឡាក់ អាញ់ ម៉ត់ ផា ចឹង អន់ កា អន់ដីស ម៉ុត អ្វៃ ណោះ អុះ ទី ដឹង កាលែប គន វគ័ យេភូនេ លូ យូស្វេ គន វគ័ នូន ណោះ ហង ចឹង ទី ម៉ុត។ ");
INSERT INTO tpu_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","កាប៉ាច់ គន អន់ដីស ឡាក់ អន់ដីស ផា អន់ឌែ ចឹង ត្រគ់ តី មួត តាម៉ឺរ ណោះ អាញ់ ចឹង ប៉ាណាំ អន់ឌែ ម៉ុត កាណុង ប៉ាថេត ណោះ។ អន់ឌែ ចឹង ទី តាទឹច ប៉ាថេត ឡាក់ អន់ដីស អូ ចៃ អ្វៃ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","កាប៉ាច់ អន់ដីស ត្រគ់ តោ័ ទិ ពឹង ស៊្រែ តីស អា ហង។ ");
INSERT INTO tpu_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","គន សោ អន់ដីស ចឹង ចាក អ្វៃ ប៉ាញ័ ទឹប ស៊្រែ តីស អា ហង ទុញ ៤០ សាណាំ ទឹប អន់ឌែ ចឹង ទី សារ ឡាំបាក ញន កា អន់ដីស អូ ត្រង់ កា ប‌៉្រ័ះ លើយ ទឹល អន់ដីស តោ័ ទិ ពឹង ស៊្រែ តីស អា។ ");
INSERT INTO tpu_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","អន់ដីស ឡាំ ហៃ ប៉ាថេត កាណាន ណោះ ពែ ទុញ ៤០ ដារ់ ទឹល នីណោ័ះ អន់ដីស ត្រគ់ ទី សារ ឡាំបាក ពួយ សារ អន់ដីស ប៉្រគ័ យច ណោះ ទុញ ៤០ សាណាំ ដេល ឃឺ ម៉ោញ សាណាំ សាំរ៉ាប់ ម៉ោញ ដារ់។ ផះ ណោះ អន់ដីស ចឹង អ្លុ អន់តគ់ ផា ផះ អាញ់ អឺក កា អន់ដីស ចឹង ទី សារ ឡាំបាក នីចម័\"។ ");
INSERT INTO tpu_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","អាញ់ ឃឺ ប‌៉្រ័ះ ប៊កកាតយ័  អាញ់ ផា នីចម័ ឃឺ អាញ់ ចឹង ប៉្រគ័ នីណោ័ះ ហង កា ប៉ាសុន អូ ដាគ់ អា ឡាក់ ប៉ាណាំ គួប តាប៉ុញ លូ អាញ់។ អន់ឌែ ចឹង តោ័ ទិឌូ ពឹង ស៊្រែ តីស អា ហង»។ ");
INSERT INTO tpu_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","ទិ មួត បក់ វគ័ ម៉ូសេ ប៉្រើ ឡាំ ហៃ ប៉ាថេត កាណាន ណោះ លូ វ៉ីល សឹត រ៉ះ ផា ប៉ាថេត ណោះ អូ ដាគ់ អុះ ប៉្រគ័ អន់ មួត ប៉ាសុន ទិឌូ កាប រ៉ាបឹក រ៉ាចប់ អឺក កា វគ័ ម៉ូសេ ");
INSERT INTO tpu_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","អន់ឌែ ណោះ ហង តោ័ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ញន កា អ៊ែ ពីត។ ");
INSERT INTO tpu_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","កាណុង កាំឡាំង អន់ឌែ បក់ ឡាំ ហៃ ប៉ាថេត កាណាន ណោះ ទី ដឹង យូស្វេ គន វគ័ នូន លូ កាលែប គន វគ័ យេភូនេ ដោច អ្វៃ រ៉ីស។ ");
INSERT INTO tpu_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","វគ័ ម៉ូសេ កា រ៉ះ សារ ទិ អា កា សុនសាត អ៊ីស្រាអ៊ែល ទិឌូ កេះណោះ អន់ឌែ ញ៉ាំ សោក ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","អន់ឌែ អ្យូវ ឡឹង កាំលឺ ផុងម៉ាំង ទ្រៀម ចឹង ហាវ ពឹង ប៉ានឹម លូ កាប ផា «ហៃ ញឹន ចឹង ហាវ ឡាំ ប៉ាគ់ ចារ ប‌៉្រ័ះ ប៊កកាតយ័ សាញ៉ា ខង ញឹន ប៉្រគ័ យច ពែ តាទឹច»។ ");
INSERT INTO tpu_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","ហះកា វគ័ ម៉ូសេ កាប ផា «ញ៉ា ត្រគ់ អន់ដីស ឌឺ អូ ប៉្រគ័ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ នីអៀ ? អន់ដីស ប៉្រគ័ នីអៀ អូ កើត អុះ។ ");
INSERT INTO tpu_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","ជែ ហាវ ពឹង ប៉ានឹម អន់ទៀ មួត តាម៉ឺរ ប៉ាន់តោ័ អន់ដីស ខង ប‌៉្រ័ះ ប៊កកាតយ័ អូ អ្វៃ អន់ឌូ លូ អន់ដីស អុះ។ ");
INSERT INTO tpu_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","សុនសាត អាម៉ាឡេក លូ សុនសាត កាណាន អ្វៃ ប៉ាគ់ ម៉ាត់ អន់ដីស តោ កេះ អន់ដីស ចឹង តោ័ ត្រគ់ ដាវ អន់ឌែ តាទឹច ហង ខង ប‌៉្រ័ះ ប៊កកាតយ័ អូ អ្វៃ អន់ឌូ លូ អន់ដីស អុះ ញន កា អន់ដីស អ្លាត សឿ អ៊ែ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ហះកា មួត ប៉ាសុន ខំ ហាវ ពឹង ប៉ានឹម ទឹប ទី ពុត អ្វាត់ អេង ហះកា ហ៊ីប សារ សាញ៉ា រែវ ពុត ម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ លូ វគ័ ម៉ូសេ អូ ឡាច់ ឡឹង ចារ រ៉ាណើះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","មួត សុនសាត អាម៉ាឡេក លូ សុនសាត កាណាន ឡាក់ អ្វៃ ពឹង ព្រី ប៉ានឹម ណោះ កា ប៉ាណាំ គួប ជឹរ ប៉ាន់តោ័ អន់ឌែ លូ តាយ៉ិប លើយ ទឹល ប៉ាគ់ តេះ ហោម៉ា។ … ");
INSERT INTO tpu_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ពឹង ខៃ ទី ១ មួត សុនសាត អ៊ីស្រាអ៊ែល ទិណោ័ះ ចាក ឡាំ ប៉ាគ់ ស៊្រែ តីស ស៊ីន អន់ឌែ កា ប៉ាណាំ គួប ប៉្រគ័ រ៉ាណើះ ហះ ចារ កាដេះ។ ផះ ណោះ យ៉ាគ់ ម៉ារៀម តោ័ អន់ឌែ កា តប់ ប៉ាទ្រូ អ៊ែ ហះ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ហះ ចារ ណោះ អូ ទី ទៀក អៃត អុះ អន់ឌែ កា ប៉ាតុំ គួប ឡាំ អឺក កា វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន។ ");
INSERT INTO tpu_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","មួត ប៉ាសុន កាប កា វគ័ ម៉ូសេ ផា «ផា ញឹន តោ័ អន់ឌូ លូ អុះ ម៉ី ញឹន ឡាក់ តោ័ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ ពែ ដាគ់ ហ៊្លត។ ");
INSERT INTO tpu_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","ញ៉ា ត្រគ់ អន់ដីស ប៉ាណាំ ប៉ាសុន ប‌៉្រ័ះ ប៊កកាតយ័ អន់ ឡាំ តោ័ ពឹង ស៊្រែ តីស ទឹប តាប៉ល់ រ៉ក់ តាប៉ល់ ចៀម តាប៉ល់ ប៉ារ់ពេ ញឹន នីអៀ ? ");
INSERT INTO tpu_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ញ៉ា ត្រគ់ អន់ដីស ប៉ាណាំ ញឹន ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ឡាំ អ្វៃ ពឹង ចារ អូ ដាគ់ នីអៀ ? ចារ អា អូ ត្រគ់ ចារ ញឹន អ្លុ សាមូល តប់ អុះ ទឹប អូ ទី តើម ហ្រា អូ ទី តើម អង់កាច លូ អូ ទី តើម ទទឹម ដេល យ‌៉័ះ ទៀក អៃត កា អូ ទី ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន កា ចាក ឡាច់ ឡឹង កាំឡាំង ឡាំ ប៉ាគ់ អំប៉ារ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ។ អន់ឌែ ជន តាកុល មូប កល់ ទឹះ តេះ ប‌៉្រ័ះ ប៊កកាតយ័ កា តាំបាង តាតារ ក្លាគ់ អន់ កា អន់ឌែ ប៉ប័។ ");
INSERT INTO tpu_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា ");
INSERT INTO tpu_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«ហគ់ អីស អ្យក់ អ៊្លង កាទូង កេះណោះ អីស លូ ម៉ី អីស អារ៉ុន ឡាំ ប៉ាតុំ មួត ប៉ាសុន អន់ អ្វៃ តុំ គួប។ ត្រគ់ ប៉្រើ អំហ្មោ តាទៀរ ហះ ម៉ាត់ អន់ឌែ អន់ ឡាច់ ទៀក ម៉ាគ់ ចឹង ទី ទៀក ហូរ័ ឡាច់ ឡឹង អំហ្មោ។ អីស ត្រគ់ ប៉្រគ័ អន់ ទី ទៀក ហូរ័ ឡាច់ ឡឹង អំហ្មោ ណោះ សាំរ៉ាប់ កា ប៉ាសុន លូ តាប៉ល់ រ៉ក់ តាប៉ល់ ចៀម អៃត»។ ");
INSERT INTO tpu_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","វគ័ ម៉ូសេ កា អ្យក់ អ៊្លង កាទូង ឡាក់ អ្វៃ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ កា ប‌៉្រ័ះ ប៉្រើ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","កេះណោះ វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ប៉ាតុំ មួត ប៉ាសុន អន់ អ្វៃ ហះ អំហ្មោ តាទៀរ លូ កាប ផា «អឺ មួត ឌុ តាប៉ុញ អូ ណីស កា ប‌៉្រ័ះ ហគ់ សាំយ៉ាំង ពិ នីចម័ ញឹន ចឹង អ្លុ ញ៉ា អូ ប៉្រគ័ អន់ ទី ទៀក ហូរ័ ឡាច់ ឡឹង អំហ្មោ តាទៀរ អា អន់ កា អន់ដីស អៃត ?» ");
INSERT INTO tpu_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","វគ័ ម៉ូសេ កា អ្យក់ អ៊្លង កាទូង ពីត អំហ្មោ ពៀរ ទង ផាឌី កា ទី ទៀក ហូរ័ ឡាច់ ឡឹង អំហ្មោ តាទៀរ តុត អៀង ឡូត។ មួត ប៉ាសុន លូ តាប៉ល់ រ៉ក់ តាប៉ល់ ចៀម កា អៃត ទៀក ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ផា «ញន អន់ដីស ពៀរ ដូវ អូ សឿ អាញ់ លូ អន់ដីស អូ ទី តាំបាង សារ ដាគ់ ត្រង់ ម៉ះ អាញ់ អន់ កា ប៉ាសុន អ៊ីស្រាអ៊ែល អន់ហ្នាល់ ទឹល នីណោ័ះ អន់ដីស ចឹង អូ ទី ប៉ាណាំ ប៉ាសុន អា ម៉ុត កាណុង ប៉ាថេត ឡាក់ អាញ់ មប អន់ កា អន់ឌែ ណោះ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","ទៀក ណោះ ពូ អន់ សិច ផា មេរីបា  ហះ ចារ ណោះ ហង ប៉ាសុន អ៊ីស្រាអ៊ែល ណាំង សារ លូ ប‌៉្រ័ះ ប៊កកាតយ័  ហះកា ប‌៉្រ័ះ តាំបាង សារ ដាគ់ ត្រង់ ម៉ះ អ៊ែ អន់ កា អន់ឌែ ប៉ប័។ … ");
INSERT INTO tpu_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","មួត សុនសាត អ៊ីស្រាអ៊ែល ទិណោ័ះ ចាក ឡាច់ ឡឹង ចារ កាដេះ ឡាំ ទឹល ប៉ាគ់ ប៉ានឹម ហោ។ ");
INSERT INTO tpu_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ផះ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កាប លូ វគ័ ម៉ូសេ លូ វគ័ អារ៉ុន ប៉ាគ់ ប៉ានឹម ហោ ហះ គួយ ប៉ាថេត អេដំ ផា ");
INSERT INTO tpu_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«ប៊ែត ណាវ្គ អារ៉ុន ចឹង តោ័ ពួយ វគ័ យ៉ាគ់ អ៊ែ ហង។ អ៊ែ ចឹង អូ ទី ម៉ុត អ្វៃ កាណុង ប៉ាថេត ឡាក់ អាញ់ មប អន់ កា សុនសាត អ៊ីស្រាអ៊ែល អុះ ខង អន់ដីស ទិ ពៀរ ដូវ អូ រ៉ាប់ អូ សឿ ប៉ានឹរ អាញ់ ប៉ាគ់ ទៀក មេរីបា។ ");
INSERT INTO tpu_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","ហគ់ ប៉ាណាំ អារ៉ុន លូ អេឡាសារ ឡាក់ គន កាម៉ាក័ អ៊ែ ហាវ ពឹង ប៉ានឹម ហោ។ ");
INSERT INTO tpu_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ប៉ាគ់ ទឹល ប៉ាគ់ ណោះ អីស រ៉ីស ឡាច់ ខោ អាវ ម៉ៃគ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ឡឹង ឡាកោ អារ៉ុន តាគ់ អំពៀត ពឹង ឡាកោ អេឡាសារ ឡាក់ គន អ៊ែ ឡគ។ ប៉ាគ់ ណោះ ហង អារ៉ុន ចឹង តោ័»។ ");
INSERT INTO tpu_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","វគ័ ម៉ូសេ ប៉្រគ័ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អ៊ែ។ អន់ឌែ ប៉ាណាំ គួប ហាវ ពឹង ប៉ានឹម ហោ ហះ ម៉ាត់ មួត ប៉ាសុន ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","វគ័ ម៉ូសេ កា រ៉ីស ឡាច់ ខោ អាវ ឡឹង ឡាកោ វគ័ អារ៉ុន តាគ់ អំពៀត ពឹង ឡាកោ អេឡាសារ ឡគ។ កេះណោះ វគ័ អារ៉ុន កា តោ័ ពឹង កល់ ប៉ានឹម ណោះ។ កាប៉ាច់ វគ័ ម៉ូសេ លូ អេឡាសារ កា ជឹរ ឡឹង ប៉ានឹម។ ");
INSERT INTO tpu_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","ប៉ាគ់ មួត ប៉ាសុន អ៊ីស្រាអ៊ែល អ្លុ អន់តគ់ ផា វគ័ អារ៉ុន តោ័ កេះ អន់ឌែ កា ញ៉ាំ សោក កា អ៊ែ ទុញ ៣០ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","កេះណោះ ប៉ាសុន អ៊ីស្រាអ៊ែល ចាក ឡាច់ ឡឹង ប៉ានឹម ហោ ចាក ទ្រង ទៀក តាំងលេ តីស ស៊ូប ភឿ ចាក យ៉្វារ ប៉ាថេត អេដំ។ ផះ ចាក រទ្រង ណោះ មួត ប៉ាសុន អូ ដាគ់ ពុត អុះ ");
INSERT INTO tpu_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ទឹប អន់ឌែ កាប អឺក កា ប‌៉្រ័ះ ប៊កកាតយ័ លូ កា វគ័ ម៉ូសេ ផា «ញ៉ា ត្រគ់ អន់ដីស ប៉ាណាំ ញឹន ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ឡាំ តោ័ ពឹង ស៊្រែ តីស នីអៀ ? ខង ហះ ចារ អា អូ ទី សាណា សា អូ ទី ទៀក អៃត អុះ ញឹន ស្រាប់ ខាក់ កេះ ដេល សា ណុំ ម៉ាណា អូ ប៉ាអាំ អា»។ ");
INSERT INTO tpu_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉្រគ័ អន់ ទី ពិះ អុញ ឡាំ ចោះ អន់ឌែ ប៉្រគ័ អន់ កា អន់ឌែ តោ័ អៀង ដូវ។ ");
INSERT INTO tpu_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","មួត ប៉ាសុន ជៀក គួប ឡាំ រ៉ះ កា វគ័ ម៉ូសេ ផា «ញឹន យច កេះ ខង ញឹន កាប អឺក កា ប‌៉្រ័ះ ប៊កកាតយ័ លូ កាប អឺក កា អីស ដេល។ ទឹល នីណោ័ះ ប៉រ់ អីស ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ អន់ អ៊ែ ទ្រុះ ឡាច់ ពិះ ទិ អា ឡឹង ញឹន ណើ»។ វគ័ ម៉ូសេ កា ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ អន់ កា អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហគ់ អីស ប៉្រគ័ ហ៊ូប ពិះ អុញ ម៉ោញ កេះណោះ អ្យក់ អ៊្លង ម៉ោញ សាន់ទ្រឹប អន់ទល ពិះ ណោះ។ ប៉ាណូស ចំ ពិះ ចោះ ផា អ៊ែ ង៉ើយ ហៃ ហ៊ូប ពិះ ណោះ អ៊ែ ចឹង អ្វៃ រ៉ីស អូ តោ័ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","វគ័ ម៉ូសេ កា អ្យក់ សាប៉ាន័ ប៉្រគ័ ហ៊ូប ពិះ ម៉ោញ កេះណោះ អន់ទល ពឹង អ៊្លង ផា ប៉ាណូស ចំ ពិះ ចោះ អ៊ែ ក្រាន័ កា ង៉ើយ ហៃ ហ៊ូប ពិះ សាប៉ាន័ ណោះ អ៊ែ ចឹង អ្វៃ រ៉ីស អូ តោ័ អុះ។ … ");
INSERT INTO tpu_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","សុនសាត អ៊ីស្រាអ៊ែល កា ចាក ឡាច់ ឡឹង ចារ ណោះ ឡាំ ប៉្រគ័ រ៉ាណើះ ពឹង តេះ សុនសាត ម៉ូអាប់ ប៊ែង អា ទៀក ទ្រូង យដាន់ ត្រង់ មឿង យេរីខូ ឡាក់ អ្វៃ ហាង តោ។ ");
INSERT INTO tpu_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ទី សាដាច់ ម៉ោញ ដូវ សិច បាឡាក់ គន វគ័ ស៊ីបពរ ឡាក់ រ៉ាំងហៃ ប៉ាថេត ម៉ូអាប់ អ៊ែ អ្លុ អន់តគ់ ទិ សារ ឡាក់ សុនសាត អ៊ីស្រាអ៊ែល ប៉្រគ័ កា សុនសាត អាម៉ូរី ពែ។ ");
INSERT INTO tpu_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ណោះ ហង សុនសាត ម៉ូអាប់ កា អ្យូគ រ៉ារ៉ៃត ឡាកោ កាខាក់ កា សុនសាត អ៊ីស្រាអ៊ែល ញន កា អន់ឌែ ទី ចំលួន អៀង។ ");
INSERT INTO tpu_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","ផះ ណោះ សុនសាត ម៉ូអាប់ កា ឡាំ រ៉ះ កា មួត ក្រាគ់ តាំងកង់ សុនសាត ម៉ាឌៀន ផា «មួត ណោះ ចាបះ កា ចឹង អ្យក់ ទិ កាណាគ័ ញ៉ាៗ ឡាក់ ពិន ទី ពៀប ឡាក់ កា រ៉ក់ សា សាម៉ោង ពឹង ម៉ីរ ទិ ប្លី ឡូត»។ ");
INSERT INTO tpu_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","សាដាច់ បាឡាក់ កា ប៉្រើ ពូ ឡាំ រ៉ះ កា វគ័ បាឡាម គន វគ័ បេអ៊រ អ្វៃ ប៉ាគ់ ស្រុក ពេថោរ ឡាក់ អ្វៃ រហាង តាំងលេ ឡាក់ ស្រុក កាណើត អ៊ែ លូ រ៉ះ ផា «ទី សុនសាត ម៉ោញ ឡាក់ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប អន់ឌែ ពឹះ អ្វៃ ប៉ាញ័ តេះ ទឹប ប៉្រគ័ រ៉ាណើះ ក្យាម័ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ទឹល នីណោ័ះ ប៉រ់ អីស ឡាំ ប៉ាគ់ ប៉ាថេត អាញ់ កិញអៀ ហង ម៉ាគ់ អីស ប៉ាស្យាប សុនសាត អា កា អាញ់ ខង អន់ឌែ កេង ក្វា ឡឹង កាំឡាំង អាញ់ កាខាក់។ ផា អីស ប៉ាស្យាប អន់ឌែ ណោះ ឃឺ អ៊ែ អាញ់ ចឹង តាកូះ លូ អន់ឌែ ទី ទ្រង អាញ់ ឡូត លូ ចឹង តាំងហ្យិត ឡាច់ អន់ឌែ ឡឹង ប៉ាថេត អា ទី ដេល ខង អាញ់ អ្លុ អន់តគ់ ផា ផា អីស អន់ សារ ដាគ់ កា បក់ ចំ បក់ ណោះ ចឹង ទី សារ ដាគ់ ហះកា ផា អីស ប៉ាស្យាប កា បក់ ចំ បក់ ណោះ កា ចឹង ត្រគ់ សារ ប៉ាស្យាប តាទឹច ឡូត»។ ");
INSERT INTO tpu_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","មួត ក្រាគ់ តាំងកង់ សុនសាត ម៉ូអាប់ លូ មួត ក្រាគ់ តាំងកង់ សុនសាត ម៉ាឌៀន អន់ឌែ កា ប៉ាណាំ គួប ឡាច់ ចាក ទឹប ទ្រុង លៀន សាំរ៉ាប់ ច្វាល់ គ្រូ អំហ្ម ដេល។ អន់ឌែ កា ឡាំ ទឹល ប៉ាគ់ ហី វគ័ បាឡាម លូ រ៉ះ ពួយ ប៉ានឹរ សាដាច់ បាឡាក់ រ៉ះ កា អន់ឌែ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","កេះណោះ វគ័ បាឡាម តើល ផា «ប៉រ់ អន់ដីស ទិឌូ ដំ ហះ អា ម៉ោញ ម៉ាំង ហិ កេះ ណោះ អាញ់ ចឹង រ៉ះ កា អន់ដីស ពួយ សារ ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង រ៉ះ កា អាញ់»។ ទឹល នីណោ័ះ មួត ម៉ៃគ ណាំផា សុនសាត ម៉ូអាប់ កា តៃប ពឹង ហី វគ័ បាឡាម ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ម៉ាំង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ជឹរ អំប៉ញ់ វគ័ បាឡាម ផា «ពឿ អ្វៃ ពឹង ហី អីស អា ?» ");
INSERT INTO tpu_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","វគ័ បាឡាម តើល ប‌៉្រ័ះ ប៊កកាតយ័ ផា «បាឡាក់ គន វគ័ ស៊ីបពរ ឡាក់ សាដាច់ សុនសាត ម៉ូអាប់ អ៊ែ ប៉្រើ អន់ឌែ ឡាំ រ៉ះ កា អាញ់ ផា ");
INSERT INTO tpu_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","\"ទី សុនសាត ម៉ោញ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ពឹះ អ្វៃ ប៉ាញ័ តេះ , កិញអៀ ប៉រ់ អីស ឡាំ ប៉ាស្យាប សុនសាត ណោះ កា អាញ់ ឃឺ អ៊ែ អាញ់ ចឹង តាកូះ លូ អន់ឌែ ទី ទ្រង អាញ់ ទឹប តាំងហ្យិត ឡាច់ អន់ឌែ ដេល\"»។ ");
INSERT INTO tpu_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ បាឡាម ផា «ជែ ឡាំ ពួយ អន់ឌែ ដៃ កា អូ ត្រគ់ ប៉ាស្យាប កា សុនសាត ណោះ ដេល ខង អាញ់ អន់ សារ ដាគ់ កា អន់ឌែ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","ប៉ាគ់ កាំលឺ វគ័ បាឡាម កា អ្យូវ រ៉ះ កា មួត ម៉ៃគ ណាំផា ឡាក់ សាដាច់ បាឡាក់ ប៉្រើ ឡាំ ណោះ ផា «ប៉រ់ អន់ដីស សឹត ប៉ាគ់ ស្រុក តេះ អន់ដីស ទៅ ពិ ខង ប‌៉្រ័ះ ប៊កកាតយ័ អូ អន់ អាញ់ ឡាំ ពួយ អន់ដីស អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","មួត ម៉ៃគ ណាំផា សុនសាត ម៉ូអាប់ កា អ្យូវ ប៉ាណាំ គួប សឹត រ៉ះ កា សាដាច់ បាឡាក់ ផា «វគ័ បាឡាម អូ ចៃ ឡាំ ពួយ ញឹន អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","កេះណោះ សាដាច់ បាឡាក់ កា ប៉្រើ មួត ម៉ៃគ ណាំផា អៀង ឡឹង មួត អន់ទ្រួល ឡាក់ ប៉្រគ័ កាន តីស ក្វា ឡឹង អន់ទ្រួល ឡាំ ម៉ោញ ទង ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","អន់ឌែ កា ឡាំ ទឹល ប៉ាគ់ ហី វគ័ បាឡាម លូ រ៉ះ ផា «សាដាច់ បាឡាក់ គន វគ័ ស៊ីបពរ អ៊ែ រ៉ះ ផា \"ប៉រ់ អីស ឡាំ ប៉ាគ់ ហី អាញ់ ជែ អន់ ទី សារ ញ៉ា ប៉ាំងខើក អីស អូ អន់ ឡាំ ដៃ ");
INSERT INTO tpu_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ខង អាញ់ ចឹង អន់ រ៉ាំងវ៉ាន័ កា អីស អៀង លូ ផា អីស ប៉ិច ប៉្រើ អាញ់ ប៉្រគ័ ញ៉ា កាតាម កា អាញ់ ចឹង ប៉្រគ័ ពួយ ទិណោ័ះ ឡូត។ ទឹល នីណោ័ះ ប៉រ់ អីស ឡាំ ប៉ាស្យាប សុនសាត ណោះ កា អាញ់ ណើ\"»។ ");
INSERT INTO tpu_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","ហះកា វគ័ បាឡាម តើល អន់ឌែ ផា «យ‌៉័ះ សាដាច់ បាឡាក់ អន់ ម៉ាស លូ ប៉្រាក់ ម៉ោញ ហី អ៊ែ កាតាម កា អាញ់ អូ ប៉្រគ័ យច ឡឹង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អាញ់ រ៉ះ ណោះ អុះ យ‌៉័ះ ង៉ារ ថិ លើ តីស កាតាម»។ ");
INSERT INTO tpu_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","ទឹល នីណោ័ះ ប៉រ់ អន់ដីស ទិឌូ ដំ ហះ អា ម៉ោញ ម៉ាំង ពិ ម៉ាគ់ អាញ់ ចឹង អ្លុ អន់តគ់ ផា ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង រ៉ះ កា អាញ់ នីចម័ ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ប៉ាគ់ កាម៉ាំង ប‌៉្រ័ះ ប៊កកាតយ័ ជឹរ កាប លូ វគ័ បាឡាម ផា «ញន កា អន់ឌែ ឡាំ អ្យក់ អីស នីអៀ ទឹល នីណោ័ះ ហគ់ ឡាំ អន់ឌូ លូ អន់ឌែ ពិ។ ហះកា អីស ត្រគ់ ប៉្រគ័ ពួយ ដឹង សារ ញ៉ា ឡាក់ អាញ់ ចឹង ប៉្រើ អីស ប៉្រគ័»។ ");
INSERT INTO tpu_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","វគ័ បាឡាម កា អ្យូវ ឡឹង កាំលឺ អ៊ែ អ្យក់ អាន ចៃគ ពឹង អង់កក់ លៀ យ៉ង់ កេះណោះ ចាក ឡាច់ ពួយ មួត ម៉ៃគ ណាំផា សុនសាត ម៉ូអាប់។ ");
INSERT INTO tpu_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","ផះ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កា អឺក កាខាក់ ញន កា វគ័ បាឡាម ឡាច់ ចាក ពួយ អន់ឌែ ណោះ។ ផះ វគ័ បាឡាម អ្វៃ ជិះ លៀ ទឹប ទី ទុច ពៀរ ដូវ ចាក អន់ឌូ លូ អ៊ែ ដេល ប៊យ ប‌៉្រ័ះ ប៊កកាតយ័ កា អន់តាវ ពឹង អន់តិគ័ ទ្រង វគ័ បាឡាម ភឿ ប៉ាសាំង លូ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","លៀ កា ប៉ប័ ប៊យ ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ អន់តាវ ពឹង អន់តិគ័ ទ្រង ទឹប ចឹក ដាវ ពឹង តី អ៊ែ ដេល លៀ កា វ៉េះ ម៉ុត ពឹង ម៉ីរ, វគ័ បាឡាម កា ពីត លៀ អន់ ចាក ពឹង ទ្រង ទៅ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","កេះ ណោះ ប៊យ ប‌៉្រ័ះ ប៊កកាតយ័ កា អន់តាវ ពឹង អន់តិគ័ ទ្រង ពឹង ម៉ីរ ប៉្លៃ កាច អង់កាច, ទ្រង ណោះ អង់អ្យាគ័ ខង ទី រ៉ាំប៊ង ទិ ពៀរ ប៊ែង។ ");
INSERT INTO tpu_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","លៀ កា ប៉ប័ ប៊យ ប‌៉្រ័ះ ប៊កកាតយ័ ណាវ្គ អ៊ែ កា វ៉េះ ទឹះ រ៉ាំប៊ង ណោះ ប៉្រគ័ អន់ ជុង វគ័ បាឡាម កាតត់ ពឹង រ៉ាំប៊ង។ បាឡាម កា ពីត អ៊ែ ម៉ោញ ទង ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ប៊យ ប‌៉្រ័ះ ប៊កកាតយ័ កា ចាក ប៉ាគ់ ង៉ីរ ប៊ែត អន់តាវ ត្រង់ ចារ អង់អ្យាគ័ ឡាក់ អូ ទី ទ្រង ចឹង វ៉េះ គែង សាម៉ា គែង សាំងអ្យោ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","លៀ កា ប៉ប័ ប៊យ ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ អ៊ែ កា ជន តាកុល ទឹះ តេះ ទឹប វគ័ បាឡាម អ្វៃ ពឹង អង់កក់ អ៊ែ ដេល, វគ័ បាឡាម កា អឺក ខាក់ កា ពីត លៀ លូ អ៊្លង កាទូង។ ");
INSERT INTO tpu_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉្រគ័ អន់ លៀ អ្លុ កាប អ៊ែ កា កាប កា វគ័ បាឡាម ផា «អាញ់ ប៉្រគ័ កា អីស នីចម័ បះ អីស ពីត អាញ់ ទឹល ប៉ៃង ទង នីអៀ ហះ ?» ");
INSERT INTO tpu_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","វគ័ បាឡាម តើល លៀ ផា «ញន កា អីស អូ ចៃ ប៉្រគ័ ពួយ អាញ់ ប៉្រគ័ អន់ អាញ់ តាយួស កា ពូ ! ផា អាញ់ ចឹក ដាវ អាញ់ ចឹង ប៉ាន់តោ័ អ្លាត អីស ឡូត !»។ ");
INSERT INTO tpu_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","លៀ ណោះ តើល ផា «អាញ់ ឡាក់ លៀ អីស ឡាក់ អីស ឃើយ ជិះ រ៉ប់ អីស ចាក លើយ ទឹល រ៉ប់ ដារ់ អា, ញ៉ា អាញ់ ឃើយ ប៉្រគ័ កា អីស នីអៀ ប ?»។ បាឡាម តើល ផា «អូ អុះ !»។ ");
INSERT INTO tpu_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ផះ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ តាំបាង អន់ វគ័ បាឡាម ប៉ប័ ប៊យ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ អន់តាវ ពឹង ទ្រង ទឹប ចឹក ដាវ ពឹង តី, វគ័ បាឡាម កា ជន តាកុល មូប កល់ ទឹះ តេះ។ ");
INSERT INTO tpu_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","ប៊យ ប‌៉្រ័ះ ប៊កកាតយ័ កា អំប៉ញ់ លូ វគ័ បាឡាម ផា «ញ៉ា ត្រគ់ អីស ពីត សាប៉្វាត័ លៀ អីស ទឹល ប៉ៃង ទង នីអៀ ? អាញ់ ឡាច់ ប៉ាសាំង លូ អីស ខង អីស ទី ពុត អូ ត្រង់ កា អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","លៀ អីស ប៉ប័ អាញ់ អ៊ែ កា វ៉េះ ឡាច់ ឡឹង អាញ់ ទឹល ប៉ៃង ទង ហះ អា កេះ។ ផា អ៊ែ អូ វ៉េះ ឡាច់ ឡឹង អាញ់ ចាបះ កា អាញ់ ប៉ាន់តោ័ អីស កេះ ហះកា អន់ លៀ អីស អ្វៃ រ៉ីស»។ ");
INSERT INTO tpu_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","វគ័ បាឡាម កា តើល ប៊យ ប‌៉្រ័ះ ប៊កកាតយ័ ផា «អាញ់ ប៉្រគ័ សារ យច កេះ ខង អាញ់ អូ អ្លុ អន់តគ់ កា អីស អ្វៃ ពឹង ទ្រង ប៉ាសាំង លូ អាញ់, ផា ង៉ារ ឡាក់ អាញ់ ចឹង ប៉្រគ័ អា អូ ត្រគ់ ពុត ពៀក អីស ទឹល នីណោ័ះ អាញ់ ចឹង វ៉ីល សឹត កិញអៀ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","ហះកា ប៊យ ប‌៉្រ័ះ ប៊កកាតយ័ តើល វគ័ បាឡាម ផា «ហគ់ ឡាំ អន់ឌូ លូ អន់ឌែ ណោះ ពិ ហះកា អីស ត្រគ់ កាប ដឹង សារ ញ៉ា ឡាក់ អាញ់ ចឹង រ៉ះ កា អីស ណោះ ហង»។ វគ័ បាឡាម កា ឡាំ អន់ឌូ លូ មួត ម៉ៃគ ណាំផា សាដាច់ បាឡាក់។ ");
INSERT INTO tpu_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","ផះ សាដាច់ បាឡាក់ អ្លុ អន់តគ់ ផា វគ័ បាឡាម ក្យាម័ ចឹង ទឹល កេះ អ៊ែ កា ឡាំ ហាប់ វគ័ បាឡាម ប៉ាគ់ មឿង ម៉ោញ ពឹង ប៉ាថេត ម៉ូអាប់ ឡាក់ អ្វៃ រហាង ទៀក ទ្រូង អាណូន ឡាក់ គួយ ចាំងហាយ្គ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","សាដាច់ បាឡាក់ កាប លូ វគ័ បាឡាម ផា «អាញ់ ប៉្រើ ពូ ឡាំ រ៉ះ កា អីស ពែ ញ៉ា ត្រគ់ អីស អូ ចៃ ឡាំ ប៉ាគ់ ចារ អាញ់ ? ញ៉ា អាញ់ អូ ទី រ៉ាំងវ៉ាន័ ចឹង អន់ កា អីស ប ?» ");
INSERT INTO tpu_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","វគ័ បាឡាម តើល ផា «ហៃ អាញ់ ឡាំ ទឹល ប៉ាគ់ ចារ អីស កេះ ហះកា កិញអៀ អា អាញ់ អូ កាប ពួយ ពុត អាញ់ ទៅ អុះ ខង សារ ញ៉ា ឡាក់ ប‌៉្រ័ះ ចឹង រ៉ះ កា អាញ់ ឃឺ សារ ណោះ ហង ឡាក់ អាញ់ ចឹង រ៉ះ»។ ");
INSERT INTO tpu_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","វគ័ បាឡាម កា ឡាំ អន់ឌូ លូ សាដាច់ បាឡាក់ ទឹល ប៉ាគ់ មឿង គៀរយ៉ាត់ ហ៊ូសូត ");
INSERT INTO tpu_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","សាដាច់ បាឡាក់ កា អ្យក់ រ៉ក់ លូ ចៀម ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ ទឹប អ្យក់ ប៉ាំងឡៃ អន់ដា ជែក អន់ កា វគ័ បាឡាម លូ កា មួត ម៉ៃគ ណាំផា ឡាក់ អ្វៃ អន់ឌូ លូ អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ប៉ាគ់ កាំលឺ សាដាច់ បាឡាក់ កា ប៉ាណាំ វគ័ បាឡាម ហាវ ពឹង ប៉ានឹម ឡាក់ ចារ ពូ រ៉ាម៉ះ ប‌៉្រ័ះ បាល។ ពឹង ចារ ណោះ អ៊ែ កា ហៃ ជឹរ ប៉ប័ មួត សុនសាត អ៊ីស្រាអ៊ែល អន់ដា។ ");
INSERT INTO tpu_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","វគ័ បាឡាម រ៉ះ កា សាដាច់ បាឡាក់ ផា «ហគ់ អីស ប៉្រគ័ អន់ហ្នឹង តាំប៉ើះ ហះ ចារ អា ភឿ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ លូ អ្យក់ រ៉ក់ ទោល តាំប៉ើះ កា​តុ លូ ចៀម ទោល តាំប៉ើះ កាតុ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","សាដាច់ បាឡាក់ កា ប៉្រគ័ ពួយ ប៉ានឹរ វគ័ បាឡាម រ៉ះ ណោះ ហង។ សាដាច់ បាឡាក់ លូ វគ័ បាឡាម កា ពុះ រ៉ក់ ម៉ោញ លូ ចៀម ម៉ោញ គ្រឹប អន់ហ្នឹង ទិណោ័ះ ភឿ រ៉ាម៉ះ ប‌៉្រ័ះ ");
INSERT INTO tpu_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","កេះណោះ វគ័ បាឡាម រ៉ះ កា សាដាច់ បាឡាក់ ផា «ហគ់ អីស អ្វៃ អន់តាវ ក្យាម័ កាណាគ័ អីស ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ អា ហង ហោគ, អាញ់ ចឹង ចាក ឡាំ ប៉ាគ់ ម៉ាត់ ណាវ្គ អ្លុ ផាហៃគ ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ជឹរ កាកាប លូ អាញ់។ សារ ញ៉ា ប‌៉្រ័ះ រ៉ះ កា អាញ់ ណោះ អាញ់ ចឹង សឹត រ៉ះ កា អីស»។ កេះ ណោះ អ៊ែ កា ហាវ ពឹង ប៉ានឹម ");
INSERT INTO tpu_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ប‌៉្រ័ះ ប៊កកាតយ័ កា ជឹរ ប៉ាគ់ វគ័ បាឡាម វគ័ បាឡាម កា រ៉ះ ផា «អាញ់ ប៉្រគ័ អន់ហ្នឹង តាំប៉ើះ ចារ ពឹង អន់ហ្នឹង ម៉ោញៗ អាញ់ ពុះ រ៉ក់ ទោល ម៉ោញ លូ ចៀម ទោល ម៉ោញ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","ប‌៉្រ័ះ ប៊កកាតយ័ កា អន់តគ់ ប៉ានឹរ អ៊ែ ពឹង វគ័ បាឡាម លូ កាប ផា «ហគ់ សឹត ប៉ាគ់ សាដាច់ បាឡាក់ ទៅ ពិ លូ រ៉ះ នីអៀ»។ ");
INSERT INTO tpu_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","វគ័ បាឡាម កា វ៉ីល សឹត ប៉ាគ់ សាដាច់ បាឡាក់ ប៉ប័ អ៊ែ អ្វៃ អន់តាវ ក្យាម័ កាណាគ័ អ៊ែ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ ទឹប ទី មួត ប៉្រគ័ កាន រ៉ាតីស ឡាក់ ម៉ៃគ ណាំផា សុនសាត ម៉ូអាប់ អ្វៃ អន់ឌូ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","កេះណោះ វគ័ បាឡាម កាប នីអៀ ផា «បាឡាក់ ឡាក់ សាដាច់ សុនសាត ម៉ូអាប់ អ៊ែ ប៉ាណាំ អាញ់ ឡឹង ប៉ាថេត អារ៉ាម ឃឺ ឡឹង ប៉ានឹម គែង ដារ់ ឡាច់ ទឹប រ៉ះ ផា \"ហគ់ ឡាំ ប៉ាស្យាប កា គន សោ យ៉ាកុប អន់ កា អាញ់ ហគ់ ប៉ាសាំង លូ សុនសាត អ៊ីស្រាអ៊ែល ពិ\"។ ");
INSERT INTO tpu_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","នីចម័ អាញ់ ចឹង អ្លុ ប៉ាស្យាប កា មួត ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ អូ ប៉ាស្យាប ? នីចម័ អាញ់ ចឹង អ្លុ ប៉ាសាំង លូ មួត ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ អូ ប៉ាសាំង ? ");
INSERT INTO tpu_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","ឡឹង អំហ្មោ តីស ចាំងហីគ អាញ់ ប៉ប័ អន់ឌែ ឡឹង កល់ ប៉ានឹម អាញ់ ហៃ ប៉ប័ អន់ឌែ, ប៉ាសុន អា អ្វៃ តាង ឡឹង ពូ អន់ឌែ អូ ឃឹត ផា ឡាកោ អន់ឌែ ឡាក់ កា សុនសាត អន់ទៀគៗ ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ពឿ អ្លុ យ៉ាប គន សោ យ៉ាកុប ឡាក់ ទី ចំលួន អៀង ឡាក់ កា តេះ ឡា​ពុក ? ពឿ ដាម័ យ៉ាប ចំលួន សុនសាត អ៊ីស្រាអ៊ែល ឡាក់ អៀង កាខាក់ ណោះ ? ដាគ់ អន់ អាញ់ តោ័ ឡាក់ កា ប៉ាណូស ដាគ់ ត្រង់ អា ពិ, ដាគ់ ប៉ាឡុច អាញុ អាញ់ អន់ ឡាក់ កា អន់ឌែ ដេល !»។ ");
INSERT INTO tpu_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","សាដាច់ បាឡាក់ កាប កា វគ័ បាឡាម ផា «ញ៉ា ត្រគ់ អីស ប៉្រគ័ កា អាញ់ នីណោ័ះ ? អាញ់ ប៉្រើ អីស ឡាំ ប៉ាស្យាប កា មួត តាម៉ឺរ អាញ់ ហះកា អីស ហ៊ែង អន់ សារ ដាគ់ កា អន់ឌែ ឡគ !» ");
INSERT INTO tpu_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","វគ័ បាឡាម តើល អ៊ែ ផា «អាញ់ ត្រគ់ រ៉ះ ដឹង សារ ញ៉ា ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អាញ់ រ៉ះ ណោះ ហង !»។ ");
INSERT INTO tpu_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","សាដាច់ បាឡាក់ រ៉ះ ណាវ្គ ផា «ចុ ឡាំ ពួយ អាញ់ ប៉ាគ់ ចារ ម៉ោញ ណាវ្គ ម៉ាគ់ អីស ចឹង ប៉ប័ អន់ឌែ ហះកា អីស ប៉ប័ អន់ឌែ ចំលួន ប៊ែត ដោច អូ ប៉ប័ ទិណោ័ះ អុះ។ ប៉ាគ់ ចារ ណោះ អីស ត្រគ់ ប៉ាស្យាប អន់ឌែ កា អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","សាដាច់ បាឡាក់ កា ប៉ាណាំ វគ័ បាឡាម ឡាំ ប៉ាគ់ ស៊្រែ សូភីម ពឹង កល់ ប៉ានឹម ពិសាកា។ អ្វៃ ប៉ាគ់ ណោះ អ៊ែ កា ប៉្រគ័ អន់ហ្នឹង តាំប៉ើះ សាំរ៉ាប់ រ៉ាម៉ះ ប‌៉្រ័ះ, ពឹង អន់ហ្នឹង ម៉ោញៗ អ៊ែ ពុះ រ៉ក់ ទោល ម៉ោញ លូ ចៀម ទោល ម៉ោញ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","វគ័ បាឡាម រ៉ះ លូ សាដាច់ បាឡាក់ ផា «អ្យគ័ អីស អ្វៃ ហះ អា ក្យាម័ ចារ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ក្យាគ់ អាញ់ ឡាំ កាកាប លូ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាគ់ តោ»។ ");
INSERT INTO tpu_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","ប‌៉្រ័ះ ប៊កកាតយ័ ជឹរ ប៉ាគ់ វគ័ បាឡាម ទឹប រ៉ះ ឡឹង សារ ឡាក់ វគ័ បាឡាម ត្រគ់ កាប, កេះ ណោះ អ៊ែ ផា «ហគ់ សឹត ប៉ាគ់ សាដាច់ បាឡាក់ ទៅ ពិ អីស ត្រគ់ រ៉ះ នីណោ័ះ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","វគ័ បាឡាម កា វ៉ីល សឹត ប៉ាគ់ សាដាច់ បាឡាក់ ប៉ប័ អ៊ែ អ្វៃ អន់តាវ ក្យាម័ កាណាគ័ អ៊ែ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ ទឹប ទី មួត ប៉្រគ័ កាន រ៉ាតីស ឡាក់ ម៉ៃគ ណាំផា សុនសាត ម៉ូអាប់ អ្វៃ អន់ឌូ ដេល។ សាដាច់ បាឡាក់ អំប៉ញ់ វគ័ បាឡាម ផា «ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ រ៉ះ នីចម័ ?» ");
INSERT INTO tpu_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","វគ័ បាឡាម កាប ផា «អឺ បាឡាក់ អ្យូវ លូ សាំយ៉ាំង ពិ, អឺ គន វគ័ ស៊ីបពរ ហគ់ សាំយ៉ាំង អ្យក់ ពុត ចៃគ ឡឹង សារ ឡាក់ អាញ់ ចឹង រ៉ះ។ ");
INSERT INTO tpu_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","ប‌៉្រ័ះ ប៊កកាតយ័ អូ ត្រគ់ ឡាក់ កា ប៉ាណូស អុះ អ៊ែ អូ អ្លុ កាប ព្លូង អុះ, អ៊ែ កា អូ អ្លុ រ៉ើ ពុត ឡាក់ កា ប៉ាណូស ដេល។ សារ ញ៉ា ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កេះ ញ៉ា អ៊ែ ចឹង អូ ប៉្រគ័ ពួយ ប ? ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ កាប កេះ ញ៉ា អ៊ែ ចឹង អូ តាគ់ អង់កេះ សារ ណោះ ប ? ");
INSERT INTO tpu_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","អាញ់ កាតាំង ប៉ានឹរ ប‌៉្រ័ះ ប៉្រើ អាញ់ អន់ សារ ដាគ់ កា ប៉ាសុន អា, ផា ប‌៉្រ័ះ អន់ សារ ដាគ់ កេះ អាញ់ អូ អ្លុ ប៉ាស្យាប អុះ។ ");
INSERT INTO tpu_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ អូ ប៉ប័ សារ ញ៉ា អូ ដាគ់ ពឹង គន សោ វគ័ យ៉ាកុប អុះ កា អូ ប៉ប័ ពុត អ៊ក កាលក ពឹង គន សោ អ៊ីស្រាអ៊ែល ដេល។ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ឌែ អ៊ែ អ្វៃ អន់ឌូ លូ អន់ឌែ ទឹប អន់ឌែ កាប ម៉ៃៗ ផា អ៊ែ ឡាក់ សាដាច់ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាណាំ អន់ឌែ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ពែ អ៊ែ ពៀប ឡាក់ កា ម៉ៃន។ ");
INSERT INTO tpu_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","អូ ទី គ្រូ អំហ្ម ចំ អ្លុ ប៉ាឡាប គន សោ យ៉ាកុប អុះ លូ អូ ទី ពឿ អ្លុ ប៉ាស្យាប កា សុនសាត អ៊ីស្រាអ៊ែល ដេល។ ប៉ាគ់ ទឹល កាំឡត់ ទៀ ពូ ចឹង រ៉ះ ឡឹង សារ យ៉ាកុប លូ ឡឹង សារ អ៊ីស្រាអ៊ែល ផា \"យើយ ញ៉ា ប‌៉្រ័ះ ប៉្រគ័ នីអៀ អ៊ិះ\"។ ");
INSERT INTO tpu_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ហៃ ប៉ាសុន អា អ្យូវ ឡាក់ កា ក្លា យ៉ង់ លូ អន់តាវ ឡាក់ កា ក្លា ទោល អន់ឌែ អូ តៃប អុះ ផា បើ ទី កាប់ សា អ្យាំ លូ អៃត ផាម កាណាគ័ អន់ឌែ កាប់ ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","សាដាច់ បាឡាក់ កាប កា វគ័ បាឡាម ផា «ផា អូ ប៉ាស្យាប កា អន់ឌែ ណោះ កា ជែ អន់ សារ ដាគ់ កា អន់ឌែ ដេល» ");
INSERT INTO tpu_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","ហះកា វគ័ បាឡាម ផា «ញ៉ា អាញ់ អូ រ៉ះ កា អីស ប ផា គ្រឹប សារ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ ណោះ អាញ់ ចឹង ប៉្រគ័ ពួយ ?» ");
INSERT INTO tpu_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","សាដាច់ បាឡាក់ រ៉ះ កា វគ័ បាឡាម ណាវ្គ ផា «ចុ ឡាំ, អាញ់ ចឹង ប៉ាណាំ អីស ឡាំ ប៉ាគ់ ចារ ម៉ោញ ណាវ្គ ឃឺ អ៊ែ ប‌៉្រ័ះ ចឹង អន់ អីស ប៉ាស្យាប មួត អន់ឌែ ប៉ាគ់ ចារ ណោះ កា អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","សាដាច់ បាឡាក់ កា ប៉ាណាំ វគ័ បាឡាម ហាវ ពឹង កល់ ប៉ានឹម ពេអ៊រ ឡាក់ ចារ ហៃ ប៉ប័ ស៊្រែ តីស។ ");
INSERT INTO tpu_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","វគ័ បាឡាម រ៉ះ កា សាដាច់ បាឡាក់ ផា «ហគ់ អីស ប៉្រគ័ អន់ហ្នឹង តាំប៉ើះ ចារ ហះ អា លូ ទ្រៀម រ៉ក់ តាំប៉ើះ កាតុ លូ ចៀម តាំប៉ើះ កាតុ អន់ កា អាញ់ ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","សាដាច់ បាឡាក់ កា ប៉្រគ័ ពួយ ឡាក់ កា វគ័ បាឡាម រ៉ះ ទឹប ពុះ រ៉ក់ ទោល លូ ចៀម ទោល ពឹង អន់ហ្នឹង ម៉ោញៗ ភឿ រ៉ាម៉ះ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","វគ័ បាឡាម អ្លុ អន់តគ់ ផា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាញ័ ពុត អន់ សារ ដាគ់ កា សុនសាត អ៊ីស្រាអ៊ែល, ណោះ ហង បះ អ៊ែ អូ ឡាំ អំប៉ញ់ លូ ប‌៉្រ័ះ ឡាក់ កា អន់ទ្រួលៗ អុះ ហះកា អ៊ែ អន់ ង៉ីរ គែង ស៊្រែ តីស។ ");
INSERT INTO tpu_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","អ៊ែ កា ប៉ាញ់ចាក័ ហៃ ចារ សុនសាត អ៊ីស្រាអ៊ែល ប៉្រគ័ រ៉ាណើះ អ្វៃ ប៉ិន ផូង័ ពឿ ផូង័ អ៊ែ។ ប៉ាង៉ាត័ ប៉ាលឹង ប‌៉្រ័ះ ប៊កកាតយ័ កា ម៉ុត ពឹង វគ័ បាឡាម ");
INSERT INTO tpu_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","អ៊ែ កាប នីអៀ ផា «អា ឃឺ ប៉ានឹរ វគ័ បាឡាម គន វគ័ បេអ៊រ ឃឺ ប៉ានឹរ បក់ ប‌៉្រ័ះ ប៉្រគ័ អន់ អ្លុ ហៃ ប៉ប័ ");
INSERT INTO tpu_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ឡាក់ ប៉ានឹរ បក់ កាតាំង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ អាញ់ ប៉ប័ សារ តាំបាង ឡឹង ប‌៉្រ័ះ ឡាក់ តីស ហ៊្លត លូ អាញ់ ប៉ក់ ទឹប កាដាប, ប‌៉្រ័ះ កា ប៉្រគ័ អន់ អាញ់ ហៃ ប៉ប័ ");
INSERT INTO tpu_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","អឺ គន សោ យ៉ាកុប រ៉ាណើះ អន់ដីស ឡាយ៉ាម័ ខាក់, អឺ សុនសាត អ៊ីស្រាអ៊ែល ចារ អន់ដីស អ្វៃ កា ដាគ់ ឡាយ៉ាម័ ដេល ");
INSERT INTO tpu_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","រ៉ាណើះ អន់ដីស តីស អ្លឹង ពៀប ឡាក់ កា ក្លូះ ប៉ានឹម លូ ឡាក់ កា សួន រហាង តាំងលេ, ឡាក់ កា តើម អ៊្លង ចាំងហីគ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ តាំងឡា តប់, ឡាក់ កា តើម កាញូង រហាង ទៀក ");
INSERT INTO tpu_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","ចឹង ទី ទៀក ព្លៀយ ឡាច់ ឡឹង ព្រឺយ អន់ឌែ, តីល អន់ឌែ តប់ ចឹង ហ៊ន ដាគ់ ទី ប៉្លៃ ប៉ាកាវ ញន កា ទី ទៀក អៀង, សាដាច់ អន់ឌែ ចឹង តីស ទឹប ទី អំរ៉ាញ ហ៊្លត ឡឹង សាដាច់ អាកាក់ សារ រ៉ាំងហៃ រ៉ាំងខ្យា ម៉ះ សាដាច់ អន់ឌែ ណោះ ចឹង ទី អំរ៉ាញ ខាក់ ទឹប លៅ លែង សិច។ ");
INSERT INTO tpu_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","ប‌៉្រ័ះ ឡាក់ ប៉ាណាំ អន់ឌែ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ពែ អ៊ែ ពៀប ឡាក់ កា ម៉ៃន អ៊ែ ចឹង ថាំឡាយ សុនសាត អន់ទៀគៗ ឡាក់ តាម៉ឺរ អ៊ែ ទឹប ប៉ាន់តោ័ មួត តាម៉ឺរ ប៉ាញ់ លូ ស្រាគ់ លូ តាគ់ អំប៉ាក់ កាន់តីង ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","អន់ឌែ កាដាប លូ តៃប ឡាក់ កា ក្លា, ពឿ ចឹង ខឹន រ៉ោ អន់ឌែ ? ពឿ អន់ សារ ដាគ់ កា សុនសាត អ៊ីស្រាអ៊ែល បក់ ណោះ ចឹង ទី សារ ដាគ់ ដេល ហះកា បក់ ពឿ ប៉ាស្យាប កា អន់ឌែ ណោះ សារ ប៉ាស្យាប ចឹង សឹត ប៉ាគ់ ពូ ទៅ»។ ");
INSERT INTO tpu_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","ផះ ណោះ សាដាច់ បាឡាក់ តាប៉ះ តី ញន អ៊ែ អឺក កា វគ័ បាឡាម កាខាក់ ទឹប កាប ផា «អាញ់ ប៉្រើ អីស ឡាំ ភឿ ប៉ាស្យាប កា តាម៉ឺរ អាញ់ ហះកា កិញអៀ អា អីស ហ៊ែង អន់ សារ ដាគ់ កា អន់ឌែ លើយ ទឹល ប៉ៃង ទង ហះ អា កេះ។ ");
INSERT INTO tpu_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","កិញអៀ អីស សឹត ប៉ាគ់ ហី អីស ទៅ ពិ អាញ់ ផា ចឹង អន់ រ៉ាំងវ៉ាន័ កា អីស ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ ទឹប អូ អន់ អីស ទី រ៉ាំងវ៉ាន័ ណោះ អុះ» ");
INSERT INTO tpu_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","វគ័ បាឡាម តើល សាដាច់ បាឡាក់ ណាវ្គ ផា «អាញ់ រ៉ះ កេះ កា មួត បក់ អីស ប៉្រើ ឡាំ រ៉ះ កា អាញ់ ណោះ ពែ, អាញ់ រ៉ះ ផា ");
INSERT INTO tpu_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","\"យ‌៉័ះ សាដាច់ បាឡាក់ អន់ ម៉ាស លូ ប៉្រាក់ ម៉ោញ ហី អ៊ែ កាតាម កា អាញ់ អូ ប៉្រគ័ យច ឡឹង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អាញ់ រ៉ះ ណោះ អុះ, យ‌៉័ះ ង៉ារ ដាគ់ លើ អូ ដាគ់ កាតាម។ សារ ញ៉ា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អាញ់ ឃឺ សារ ណោះ ហង អាញ់ ចឹង រ៉ះ\"។ ");
INSERT INTO tpu_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","កិញអៀ អា អន់ទ្រួល ឡឹង អាញ់ សឹត ប៉ាគ់ ស្រុក តេះ អាញ់ ទៅ អាញ់ ចឹង រ៉ះ កា អីស ឡឹង សារ ឡាក់ សុនសាត អ៊ីស្រាអ៊ែល ចឹង ប៉្រគ័ កា សុនសាត អីស ប៉ាគ់ ម៉ាត់ ទៀ»។ ");
INSERT INTO tpu_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","វគ័ បាឡាម កាប ម៉ោញ ទង ណាវ្គ ផា «អា ឃឺ ប៉ានឹរ វគ័ បាឡាម គន វគ័ បេអ៊រ ឃឺ ប៉ានឹរ បក់ ប‌៉្រ័ះ ប៉្រគ័ អន់ អ្លុ ហៃ ប៉ប័ ");
INSERT INTO tpu_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ឡាក់ ប៉ានឹរ បក់ កាតាំង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័, ទឹប អ្លុ ហ្លង់ ឡឹង សារ អ៊ែ, អាញ់ ប៉ប័ សារ តាំបាង ឡឹង ប‌៉្រ័ះ ឡាក់ តីស ហ៊្លត លូ អាញ់ ប៉ក់ ទឹប កាដាប, ប‌៉្រ័ះ កា ប៉្រគ័ អន់ អាញ់ ហៃ ប៉ប័ ");
INSERT INTO tpu_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","អាញ់ ប៉ប័ កាម៉ាក័ ម៉ោញ ដូវ ហះកា អូ ត្រគ់ កិញអៀ អុះ, អាញ់ ប៉ាញ់ចាក័ ហៃ កាម៉ាក័ ណោះ ហះកា អូ ត្រគ់ អ្វៃ ក្យាម័ ដេល, ចឹង ទី សំឡង់ ម៉ោញ ឡាច់ ឡឹង ផូង័ វ៉ាច់ យ៉ាកុប ឃឺ ចឹង ទី សាដាច់ ម៉ោញ ដូវ ចឹក អ៊្លង កាទូង ឡាច់ ឡឹង សុនសាត អ៊ីស្រាអ៊ែល, សាដាច់ ណោះ ចឹង ពីត កល់ យ៉ាំង សុនសាត ម៉ូអាប់ អន់ ប៉ាទុះ លូ ចឹង ពីត ទិ គន សោ វគ័ សេត ។ ");
INSERT INTO tpu_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ព្រី ទៀក អេដំ ចឹង កេះ ព្រី ទៀក សុនសាត អ៊ីស្រាអ៊ែល លូ ព្រី ទៀក សៀរ ឡាក់ តាម៉ឺរ អន់ឌែ កា ចឹង កេះ ព្រី ទៀក អ៊ីស្រាអ៊ែល ដេល ឃឺ សាណ័ះ ទ្រង សុនសាត អ៊ីស្រាអ៊ែល ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","ចឹង ទី បក់ រ៉ាំងហៃ រ៉ាំងខ្យា ម៉ោញ ដូវ កើត ឡាច់ ឡឹង ផូង័ វ៉ាច់ យ៉ាកុប, បក់ ណោះ ចឹង ថាំឡាយ ទិ មួត ឡាក់ អ្វៃ សល់ ពឹង មឿង ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","កេះ ណោះ វគ័ បាឡាម អ៊ែ ហៃ ប៊ែង សុនសាត អាម៉ាឡេក លូ កាប ផា «អាម៉ាឡេក ឡាក់ សុនសាត ម៉ោញ តីស ឡឹង ពូ ហះកា ប៉ាគ់ អន់តីគ អន់ឌែ ចឹង តោ័ រ៉ាយ តោ័ រ៉ុង»។ ");
INSERT INTO tpu_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","អ៊ែ កា ហៃ ប៊ែង សុនសាត គែន ណាវ្គ លូ កាប ផា «ចារ អន់ដីស អ្វៃ កាចាប័ ខាក់ ពៀប ឡាក់ កា សៃម ប៉្រគ័ សំប៉ូវ ពឹង គឺប អំហ្មោ ");
INSERT INTO tpu_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","ហះកា សុនសាត គែន ចឹង រ៉ាយ រ៉ាំ ទិ ប៉ាគ់ សុនសាត អាស៊ើ អ្យក់ ប៉្រគ័ ទុច»។ ");
INSERT INTO tpu_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","វគ័ បាឡាម កាប ណាវ្គ ផា «ប៉ាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ សារ ទិ អា ទៀ ទី ពឿ ចឹង អ្វៃ រ៉ីស ? ");
INSERT INTO tpu_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","ហះកា ចឹង ទី តាហាន ជិះ កាំប៉ាន់ ឡាច់ ឡឹង ប៉ាថេត គីទីម អន់ឌែ ចឹង ប៉្រគ័ កា សុនសាត អាស៊ើ ទឹប សុនសាត ហេបើរ ដេល ហះកា អន់ឌែ ចឹង ត្រគ់ តោ័ រ៉ាយ តោ័ រ៉ុង និះទៅ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","កេះ ណោះ វគ័ បាឡាម កា អ្យូវ សឹត ប៉ាគ់ ស្រុក អ៊ែ ទៅ ណាវ្គ កាប៉ាច់ សាដាច់ បាឡាក់ អ៊ែ កា សឹត ប៉ាគ់ មឿង អ៊ែ និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហគ់ អីស ហាវ ពឹង ប៉ានឹម អាបារីម អា កេះណោះ ហៃ គែង ប៉ាថេត ឡាក់ អាញ់ ចឹង មប អន់ កា សុនសាត អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","ប៉ាគ់ អីស ហៃ ប៉ប័ ប៉ាថេត អា កេះ អីស ចឹង តោ័ ពួយ វគ័ យ៉ាគ់ អីស ហង ឡាក់ កា ម៉ី អីស អារ៉ុន ដេល ");
INSERT INTO tpu_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ខង អន់ដីស ពៀរ ដូវ អូ ប៉្រគ័ ពួយ ប៉ានឹរ អាញ់ ផះ មួត ប៉ាសុន ប៉ាណាំ គួប តាប៉ុញ លូ អាញ់ ពឹង ស៊្រែ តីស ស៊ីន អន់ដីស កា អូ ទី តាំបាង សារ អាញ់ ដាគ់ ត្រង់ អន់ កា អន់ឌែ ប៉ប័»។ សារ អា កើត ពឹះ ប៉ាគ់ មេរីបា ចារ មួត ប៉ាសុន តាប៉ុញ ឡឹង សារ អូ ទី ទៀក ផះ អ្វៃ ប៉ាគ់ ចារ កាដេះ ពឹង ស៊្រែ តីស ស៊ីន ពែ។ ");
INSERT INTO tpu_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","វគ័ ម៉ូសេ តើល ប‌៉្រ័ះ ប៊កកាតយ័ ផា ");
INSERT INTO tpu_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«ទឹល នីណោ័ះ ប៉រ់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ តាំងឡា កាស៊ែ តាំងហើម ប៉ាណូស ទិឌូ ប៉រ់ អីស តាប៉ាប តាប៉ុន ប៉្រើ ប៉ាណូស ម៉ោញ ដូវ ប៉្រគ័ ម៉ៃគ ណាំផា សុនសាត អ៊ីស្រាអ៊ែល អា ណើ។ ");
INSERT INTO tpu_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ប៉ាណូស ណោះ ចឹង ប៉ាណាំ មួត ប៉ាសុន ឡាំ តាកូះ លូ ចឹង ប៉ាណាំ អន់ឌែ សឹត ណាវ្គ ភឿ ជែ អន់ ប៉ាសុន អីស ពៀប ឡាក់ កា តាប៉ល់ ចៀម អូ ទី តាំងឡា រង»។ ");
INSERT INTO tpu_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ហគ់ អីស ឡាំ អ្យក់ យូស្វេ គន វគ័ នូន អន់ ពឹះ ប៉ាគ់ អា អ៊ែ ឡាក់ ប៉ាណូស ទី ប៉ាង៉ាត័ ប៉ាលឹង អាញ់ អ្វៃ អន់ឌូ កេះណោះ អីស ម៉ន់ សាប៉ាគ់ ពឹង អ៊ែ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ហគ់ ប៉ាណាំ អ៊ែ ឡាំ អន់តាវ ហះ ង៉ីរ អេឡាសារ ឡាក់ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ លូ ហះ ង៉ីរ មួត ប៉ាសុន ទិឌូ កេះណោះ រ៉ះ ប៉្រើ អ៊ែ ប៉្រគ័ ម៉ៃគ ណាំផា ហះ ម៉ាត់ មួត ប៉ាសុន ទិឌូ។ ");
INSERT INTO tpu_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","ហគ់ អន់ សារ អំរ៉ាញ អឺញ អីស អន់ដា កា អ៊ែ ណើ ភឿ អន់ ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ រ៉ាប់ សឿ អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","ប៉ាគ់ ដារ់ ចំ យូស្វេ ប៉ិច អំប៉ញ់ លូ អាញ់ អ៊ែ ត្រគ់ អន់តាវ ហះ ង៉ីរ អេឡាសារ ឡាក់ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ផះ ណោះ អេឡាសារ ត្រគ់ អ្យក់ យូរីម ម៉ាគ់ ចឹង អ្លុ អាញ់ ចឹង តើល នីចម័ ណោះ។ កេះណោះ យូស្វេ លូ មួត ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ ចឹង ចាក ឡាំ តាកូះ លើ វ៉ីល សឹត ពួយ ប៉ានឹរ អេឡាសារ ប៉្រើ»។ ");
INSERT INTO tpu_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","វគ័ ម៉ូសេ កា ប៉្រគ័ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ អន់តគ់ រ៉ះ កា អ៊ែ។ អ៊ែ ប៉ាណាំ យូស្វេ ឡាំ អន់តាវ ហះ ង៉ីរ អេឡាសារ ឡាក់ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ លូ ហះ ង៉ីរ មួត ប៉ាសុន ទិឌូ។ ");
INSERT INTO tpu_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","អ៊ែ ម៉ន់ សាប៉ាគ់ ពឹង យូស្វេ ភឿ មប ង៉ារ អន់ ត្រគ់ ឡាក់ កា ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ អន់តគ់ រ៉ះ ពឹង អ៊ែ ណោះ ហង។ …");
INSERT INTO tpu_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","សារ ទិ អា ឃឺ សារ វគ័ ម៉ូសេ អន់តគ់ រ៉ះ កា សុនសាត អ៊ីស្រាអ៊ែល ទិឌូ ផះ អ្វៃ គែង ដារ់ ឡាច់ ទៀក ទ្រូង យដាន់ ពឹង ស៊្រែ តីស អារ៉ាបា អ្វៃ ត្រង់ ហះ ស៊ូប អ្វៃ ហះ អន់តិគ័ ប៉ារ៉ាន តូភែល ឡាបាន់ ហាសិរ៉ូត លូ ឌីសាហាប។ ");
INSERT INTO tpu_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","ឡឹង ប៉ានឹម ស៊ីណាយ ចាក ទ្រង ប៉ានឹម សៀរ ឡាំ ទឹល ប៉ាគ់ កាដេះ បារណា ចាំងហាយ្គ ទ្រង ចាក ខា ១១ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","ពឹង សាណាំ ទី ៤០ ខៃ ១១ ដារ់ ទី ១ វគ័ ម៉ូសេ រ៉ះ កា សុនសាត អ៊ីស្រាអ៊ែល ទិ សារ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អ៊ែ រ៉ះ កា ពូ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","ឃឺ អន់តីគ ឡឹង អន់ឌែ តាកូះ លូ ស៊ីហុន ឡាក់ សាដាច់ សុនសាត អាម៉ូរី អ្វៃ ពឹង មឿង ហេសាបូន លូ អុក ឡាក់ សាដាច់ ប៉ាថេត បាសាន អ្វៃ ពឹង មឿង អាសាថារ៉ូត លូ មឿង អេទ្រី។ ");
INSERT INTO tpu_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","ផះ អ្វៃ គែង ដារ់ ឡាច់ ទៀក ទ្រូង យដាន់ កាណុង ប៉ាថេត ម៉ូអាប់ វគ័ ម៉ូសេ អ៊ែ ប៉ាំងហៀន ចាបាប់ ប‌៉្រ័ះ ឡាក់ កា អា៖ ");
INSERT INTO tpu_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","«ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ពិន អ៊ែ រ៉ះ កា ពិន ផះ អ្វៃ ប៉ាគ់ ប៉ានឹម ស៊ីណាយ ពែ ផា \"អន់ដីស អ្វៃ ហះ ប៉ានឹម អា ទុញ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","ទឹល នីណោ័ះ ហគ់ ប៉ាណាំ គួប ចាក ឡាំ ប៉ាគ់ ម៉ាត់ តោ ណាវ្គ ឡាំ ប៉ាគ់ ព្រី ប៉ានឹម ឡាក់ ចារ សុនសាត អាម៉ូរី អ្វៃ លូ គ្រឹប ចារ ជុំ ណោះ ឃឺ ស៊្រែ តីស អារ៉ាបា ព្រី ប៉ានឹម ចារ តាប៉ង់ ស៊្រែ តីស ណេកិប ស្រុក តេះ រហាង ទៀក សាឡីគ សាឡាយ ស្រុក តេះ សុនសាត កាណាន លូ ប៉ាថេត ឡេបាណូន លើយ ទឹល តាំងលេ អឺប៉្រាត។ ");
INSERT INTO tpu_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","ហៃ អាញ់ មប ប៉ាថេត ណោះ អន់ កា អន់ដីស កេះ ទឹល នីណោ័ះ ហគ់ ឡាំ ម៉ុត អ្យក់ ប៉ាថេត ណោះ ពិ ឃឺ ប៉ាថេត ឡាក់ អាញ់ ទី ម៉ត់ ផា ចឹង មប អន់ កា វគ័ អន់ដីស អាប៉្រាហាំ អ៊ីសាក់ លូ យ៉ាកុប ទឹប កា ផូង័ វ៉ាច់ ឡាក់ កើត រ៉ាំងហាវ អន់តីគ ដេល\"។ ");
INSERT INTO tpu_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","«ផះ រ៉ាំងវ៉ាង ណោះ អាញ់ រ៉ះ កា អន់ដីស ផា \"អាញ់ ម៉ោញ ដូវ អាញ់ អូ អ្លុ រ៉ាំងហៃ អន់ដីស ទី អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ប៉្រគ័ អន់ អន់ដីស កើត ចំលួន អៀង ហៃ រ៉ប់ ដារ់ អា អន់ដីស ទី កាំឡាំង អៀង ឡាក់ កា សំឡង់ ពឹង ប៉្លៃង។ ");
INSERT INTO tpu_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","អន់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ វគ័ យ៉ាគ់ អន់ដីស ប៉្រគ័ អន់ ទី ចំលួន អៀង ១០០០ ទង ណាវ្គ អន់ ប‌៉្រ័ះ អន់ សារ ដាគ់ កា អន់ដីស ឡាក់ កា អ៊ែ សាញ៉ា លូ អន់ដីស កេះ។ ");
INSERT INTO tpu_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","ហះកា អាញ់ រ៉ាំងហៃ អន់ដីស ឡាំបាក កាខាក់ អាញ់ ម៉ោញ ដូវ អាញ់ អូ អ្លុ អុះ តាត់ស៊ិន សារ ញន កា អន់ដីស តាប៉ុញ តាប៉ាក់ លើយ។ ");
INSERT INTO tpu_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","ទឹល នីណោ័ះ ហគ់ រ៉ើស ប៉ាណូស បក់ ហ្យាំង សាឡាច់ លូ ហ្លង់ សារ ទឹប លៅ សិច ផា អន់ឌែ ឃឺ ប៉ាណូស ដាគ់ កាណុង ផូង័ អន់ដីស រ៉ប់ ផូង័ ម៉ាគ់ អាញ់ ចឹង ប៉្រើ អន់ឌែ ប៉្រគ័ ម៉ៃគ ណាំផា អន់ដីស\"។ ");
INSERT INTO tpu_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","ផះ ណោះ អន់ដីស តើល អាញ់ ផា \"សារ អីស ប៉រ់ ណោះ ដាគ់ ខាក់\"។ ");
INSERT INTO tpu_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","អាញ់ កា រ៉ើស មួត ម៉ៃគ ណាំផា ឡឹង ផូង័ វ៉ាច់ អន់ដីស ទិណោ័ះ ឃឺ ប៉ាណូស ឡាក់ ហ្យាំង សាឡាច់ លូ លៅ សិច ផា អន់ឌែ ឃឺ ប៉ាណូស ដាគ់ អាញ់ កា ប៉្រើ អន់ឌែ រ៉ាំងហៃ ផូង័ វ៉ាច់ អន់ដីស ឃឺ អន់ដា ប៉្រគ័ ម៉ៃគ ណាំផា កាំឡាំង ១០០០ ដូវ អន់ដា ប៉្រគ័ ម៉ៃគ ណាំផា កាំឡាំង ១០០ ដូវ អន់ដា ប៉្រគ័ ម៉ៃគ ណាំផា កាំឡាំង ៥០ ដូវ អន់ដា ណាវ្គ ប៉្រគ័ ម៉ៃគ ណាំផា កាំឡាំង ១០ ដូវ។ ");
INSERT INTO tpu_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","ផះ រ៉ាំងវ៉ាង ណោះ អាញ់ កា អន់តគ់ កា មួត បក់ តាត់ស៊ិន សារ កា អន់ដីស ផា \"ហគ់ ខំ សាំយ៉ាំង សារ អុះ ម៉ី អន់ដីស កាខាក់ ពិ។ កេះណោះ តាត់ស៊ិន សារ កា អុះ ម៉ី អន់ដីស លូ កា មួត អំហ៊្មយ បក់ អ្វៃ លូ អន់ដីស អន់ ដាគ់ ត្រង់។ ");
INSERT INTO tpu_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","ផះ តាត់ស៊ិន សារ អន់ដីស អូ ត្រគ់ រ៉ើស ម៉ាត់ បក់ ពឿ អុះ ត្រគ់ សាំយ៉ាំង មួត ប៉ាសុន ដោច ដាច ឡាក់ កា សាំយ៉ាំង មួត ប៉្រគ័ កាន រ៉ាតីស ដេល អូ ត្រគ់ អ្យូគ កា បក់ ពឿ អុះ ខង សារ តាត់ស៊ិន ណោះ ស៊ុត កា ប‌៉្រ័ះ ប៊កកាតយ័។ ផា សារ ចំ ញ៉ាក តាឡាម័ សាំរ៉ាប់ អន់ដីស អ្យគ័ ជឹន ប៉ាគ់ អាញ់ ពិ អាញ់ ចឹង តាត់ស៊ិន កា អន់ដីស\"។ ");
INSERT INTO tpu_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","ផះ រ៉ាំងវ៉ាង ណោះ អាញ់ រ៉ះ កា អន់ដីស ឡឹង សារ ទិណោ័ះ ឡាក់ អន់ដីស ចឹង ត្រគ់ ប៉្រគ័ ពួយ។ ");
INSERT INTO tpu_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","«កេះណោះ ពិន ចាក ឡាច់ ឡឹង ប៉ានឹម ស៊ីណាយ ចាក តាត់ ស៊្រែ តីស អា ឡាក់ ស៊្រែ តីស ខាក់ ឃឺ ត្រគ់ អ្យូគ ឡាក់ កា អន់ដីស ប៉ប័ កេះ។ ពិន ចាក ឡាំ ប៉ាគ់ ព្រី ប៉ានឹម មួត សុនសាត អាម៉ូរី ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ពិន អ៊ែ ប៉្រើ លើយ ទឹល ចារ កាដេះ បារណា។ ");
INSERT INTO tpu_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","ផះ ណោះ អាញ់ រ៉ះ កា អន់ដីស ផា \"អន់ដីស ទឹល កេះ ប៉ាគ់ ព្រី ប៉ានឹម មួត សុនសាត អាម៉ូរី ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ពិន អន់ កា ពិន។ ");
INSERT INTO tpu_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","ហៃ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស មប ប៉ាថេត អា អន់ កា អន់ដីស កេះ។ ទឹល នីណោ័ះ ហគ់ ម៉ុត អ្យក់ ពិ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ វគ័ យ៉ាគ់ អន់ដីស រ៉ះ ពែ។ ជែ អ្យូគ ជែ ញ៉ា ហង\"។ ");
INSERT INTO tpu_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","ផះ ណោះ អន់ដីស ម៉ុត ក្យាម័ អាញ់ កេះណោះ រ៉ះ ផា \"ហគ់ អីស ប៉្រើ ប៉ាណូស បក់ អន់ដា ឡាំ អន់ទ្រួល ឡឹង ពិន ភឿ ហៃ ប៉ាថេត ណោះ កេះណោះ សឹត រ៉ះ កា ពិន ឡឹង ទ្រង ឡាក់ ពិន ចឹង ត្រគ់ ចាក លូ មឿង ឡាក់ ចឹង ត្រគ់ ម៉ុត អ្វៃ ណោះ\"។ ");
INSERT INTO tpu_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","អាញ់ ឃឹត ផា សារ ណោះ ដាគ់ អាញ់ កា ប៉្រើ ប៉ាណូស ១២ ដូវ កាណុង កាំឡាំង អន់ដីស ឃឺ កាណុង ម៉ោញ ផូង័ ម៉ោញ ដូវ អន់ ឡាំ។ ");
INSERT INTO tpu_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","អន់ឌែ ណោះ កា ឡាច់ ចាក ឡាំ ប៉ាគ់ ព្រី ប៉ានឹម លើយ ទឹល ប៉ាគ់ តាចាង័ អេសាកុល ទឹប ចាក ហៃ។ ");
INSERT INTO tpu_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","អន់ឌែ កា អ្យក់ សឹត ប៉្លៃ អ៊្លង ឡឹង ប៉ាថេត ណោះ តាំបាង អន់ កា ពិន ហៃ លូ រ៉ះ កា ពិន ផា \"ប៉ាថេត ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ពិន មប អន់ កា ពិន ណោះ ដាគ់ ខាក់\"។ ");
INSERT INTO tpu_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","ហះកា អន់ដីស អូ ចៃ ឡាំ ប៉ាគ់ ប៉ាថេត ណោះ អុះ ទឹប អន់ដីស កាប អឺក កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ញន កា អ៊ែ ប៉្រើ អន់ដីស ឡាំ។ ");
INSERT INTO tpu_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","អន់ដីស កាប រ៉ាបឹក រ៉ាចប់ កាណុង រ៉ាណើះ អន់ដីស ទៅ ផា \"ប‌៉្រ័ះ ប៊កកាតយ័ អូ ណីស កា ពិន បះ អ៊ែ ប៉ាណាំ ពិន ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ភឿ មប ពិន អន់ កា មួត សុនសាត អាម៉ូរី ប៉ាន់តោ័។ ");
INSERT INTO tpu_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","ញ៉ា ត្រគ់ អីស ប៉្រើ ញឹន ឡាំ ប៉ាគ់ ចារ ណោះ ? ញឹន អូ ទី ពុត ប៉ិច ឡាំ ប៉ាគ់ ប៉ាថេត ណោះ អុះ ខង អុះ ម៉ី ញឹន រ៉ះ កា ញឹន ផា 'មួត ប៉ាសុន អ្វៃ កាណុង ប៉ាថេត ណោះ សាងុំ ខាក់ ឡាកោ អន់ឌែ កា រ៉ាតីស ក្វា ឡឹង ពិន។ មឿង អន់ឌែ ណោះ ឃឺ មឿង តីសៗ លូ ទី ប៉ាន់ទៀយ ចាំងហីគ ទឹះ ប៉្លៃង កាម៉ល់។ ញឹន កា ប៉ប័ គន សោ អាណាក់ អ្វៃ កាណុង ប៉ាថេត ណោះ ដេល' \"។ ");
INSERT INTO tpu_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","កេះណោះ អាញ់ រ៉ះ កា អន់ដីស ផា \"ជែ កាខរ់ ណូស ជែ អ្យូគ កា អន់ឌែ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អ៊ែ ចាក អន់ទ្រួល ឡឹង អន់ដីស អ៊ែ ចឹង តាកូះ តាង អន់ដីស ឡាក់ កា អ៊ែ តាកូះ អន់ កា អន់ដីស ប៉ប័ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ពែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ឡៃង ឡឹង ណោះ ណាវ្គ ផះ អ្វៃ ពឹង ស៊្រែ តីស លូ ផះ អន់ដីស ចាក រទ្រង លើយ ទឹល ប៉ាគ់ ចារ អា អន់ដីស កា ទី ប៉ប័ កេះ ដេល ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អ៊ែ ពៅ អន់ដីស ឡាក់ កា ពឹ ពៅ គន\"។ ");
INSERT INTO tpu_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","ហះកា នីចម័ កាតាម អ្វៃ កា អន់ដីស អូ ចៃ ម៉ឹង ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ណោះ អុះ ");
INSERT INTO tpu_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","យ‌៉័ះ អ៊ែ ចាក អន់ទ្រួល ភឿ ណាំង ចារ អន់ កា អន់ដីស ប៉្រគ័ រ៉ាណើះ ផះ កាម៉ាំង ប‌៉្រ័ះ ម៉ាច់ កេះ អុញ តាគ់ តាតារ ទ្រង អន់ កា អន់ដីស ចាក ផះ កាដារ់ អ៊ែ ម៉ាច់ កេះ កាម៉ល់ ភឿ ប៉ាណាំ ទ្រង អន់ដីស ចាក ដេល។ ");
INSERT INTO tpu_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","«ផះ អ៊ែ កាតាំង ប៉ានឹរ អន់ដីស កាប រ៉ាបឹក រ៉ាចប់ ប‌៉្រ័ះ ប៊កកាតយ័ អឺក លូ ម៉ត់ ផា ");
INSERT INTO tpu_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","\"កាណុង កាំឡាំង ប៉ាណូស អូ ដាគ់ រ៉ាំងហាវ អា អូ ទី ពឿ ចឹង ទី ប៉ប័ ប៉ាថេត ដាគ់ ឡាក់ អាញ់ ម៉ត់ ផា ចឹង មប អន់ កា វគ័ យ៉ាគ់ អន់ដីស ណោះ ពែ អុះ ");
INSERT INTO tpu_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ទី ដឹង កាលែប គន វគ័ យេភូនេ ណោះ ហង ចឹង ទី ប៉ប័ អាញ់ ចឹង មប អន់ ប៉ាថេត ឡាក់ អ៊ែ ចាក តាត់ ណោះ អន់ កា អ៊ែ លូ កា គន សោ អ៊ែ ខង អ៊ែ ប៉្រគ័ ពួយ ប៉ានឹរ អាញ់ គ្រឹប នែវ\"។ ");
INSERT INTO tpu_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","ញន កា អន់ដីស បះ ប‌៉្រ័ះ ប៊កកាតយ័ អឺក កា អាញ់ ដេល អ៊ែ កាប ផា \"យ‌៉័ះ អីស កា អូ ទី ម៉ុត កាណុង ប៉ាថេត ណោះ ដេល ");
INSERT INTO tpu_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","ឃឺ យូស្វេ គន វគ័ នូន ឡាក់ ប៉្រគ័ ង៉ារ កា អីស អ៊ែ ចឹង ម៉ុត កាណុង ប៉ាថេត ណោះ។ ទឹល នីណោ័ះ ហគ់ ប៉្រគ័ អន់ អ៊ែ ទី ពុត ខឹន ខង អ៊ែ ចឹង ប៉្រគ័ អន់ កា សុនសាត អ៊ីស្រាអ៊ែល ទី ម៉ុត កាណុង ប៉ាថេត ឡាក់ ប៉ាដក់ ប៉ាជៀ ម៉ះ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","កាប៉ាច់ គន ថិ អន់ដីស ឡាក់ បើ អ្លុ អន់ហ្នាល់ សារ យច ត្រគ់ ឡាក់ អន់ដីស កាប ផា អន់ឌែ ចឹង ត្រគ់ តី មួត តាម៉ឺរ ណោះ ឃឺ អន់ឌែ ណោះ ហង ចឹង ម៉ុត កាណុង ប៉ាថេត ណោះ អាញ់ ចឹង មប ប៉ាថេត ណោះ កា អន់ឌែ។ អន់ឌែ ចឹង ម៉ុត អ្យក់ ប៉ាថេត ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","ហះកា កិញអៀ អា ហគ់ អន់ដីស វ៉ីល សឹត អ្វៃ ប៉ាគ់ ស៊្រែ តីស រទ្រង ឡាំ ប៉ាគ់ ទៀក តាំងលេ តីស ស៊ូប តោ ណាវ្គ ពិ\"។ ");
INSERT INTO tpu_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","ផះ ណោះ អន់ដីស តើល អាញ់ ផា \"ញឹន ប៉្រគ័ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ កេះ ទឹល នីណោ័ះ ញឹន ចឹង ឡាំ តាកូះ អ្យក់ ប៉ាថេត ណោះ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ពិន ប៉្រើ ណោះ ហង\"។ ផះ ណោះ អន់ដីស ចឹក ឃឿង តាកូះ គ្រឹប ដូវ ខង អន់ដីស ឃឹត ផា អូ ក្រូ អុះ ចឹង តាកូះ អ្យក់ ព្រី ប៉ានឹម ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អាញ់ ផា \"ហគ់ រ៉ះ កា អន់ឌែ ជែ អន់ អន់ឌែ ឡាំ តាកូះ អ្យក់ ប៉ាថេត ណោះ អ្យូគ អន់ឌែ អូ ដាម័ មួត តាម៉ឺរ ខង អាញ់ អូ អ្វៃ អន់ឌូ លូ អន់ឌែ អុះ\"។ ");
INSERT INTO tpu_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","អាញ់ រ៉ះ កា អន់ដីស ហះកា អន់ដីស អូ សាំយ៉ាំង អុះ ទឹប អូ ចៃ ប៉្រគ័ ពួយ សារ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ណោះ កេះណោះ អន់ដីស ប៉ាណាំ គួប ឡាំ ប៉ាគ់ ព្រី ប៉ានឹម ទឹប ទី ពុត អ្វាត់ អេង។ ");
INSERT INTO tpu_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","កេះណោះ សុនសាត អាម៉ូរី ឡាក់ អ្វៃ ពឹង ប៉ានឹម ណោះ កា ឡាំ តាកូះ លូ អន់ដីស អន់ឌែ កា តាយ៉ិប អន់ដីស ឡាក់ កា សុត លើយ ទឹល ស្រុក ហោម៉ា ទឹប ប៉ាន់តោ័ អន់ដីស ពឹង ព្រី សៀរ។ ");
INSERT INTO tpu_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","អន់ដីស កា វ៉ីល សឹត ញ៉ាំ សោក ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័  ហះកា អ៊ែ អូ សាំយ៉ាំង អន់ដីស អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","ទឹល នីណោ័ះ អន់ដីស កា អ្វៃ ត្រង់ ហះ ចារ កាដេះ ណោះ ទុញ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","«កេះណោះ ពិន កា វ៉ីល សឹត ចាក ពឹង ស៊្រែ តីស ចាក ទ្រង តាំងលេ តីស ស៊ូប ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ។ ពិន កា ចាក សឹត ចាក ឡាំ ពឹង ព្រី ប៉ានឹម សៀរ ទុញ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អាញ់ ផា ");
INSERT INTO tpu_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","\"អន់ដីស ចាក រប៉ានឹម អា ទុញ ដារ់ កេះ ទឹល នីណោ័ះ ហគ់ អន់ដីស ចាក ឡាំ គែង ជើង តោ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","ហគ់ រ៉ះ កា មួត ប៉ាសុន ផា 'អន់ដីស ប៊ែត ចឹង ចាក តាត់ ប៉ាថេត គន សោ អេសាវ ឡាក់ អុះ ម៉ី អន់ដីស ទៅ ឡាក់ អ្វៃ ពឹង ព្រី ប៉ានឹម សៀរ។ អន់ឌែ ចឹង អ្យូគ កា អន់ដីស ហះកា ត្រគ់ ឡាវ៉ាំង ឡាកោ កាខាក់ ដៃ។ ");
INSERT INTO tpu_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","ជែ តាកូះ លូ អន់ឌែ អាញ់ អូ អន់ ប៉ាថេត អន់ឌែ ណោះ កា អន់ដីស អុះ យ‌៉័ះ តុ តាំប៉ាង ជុង កា អាញ់ អូ អន់ ដេល ខង អាញ់ អន់ ព្រី ប៉ានឹម សៀរ កា អេសាវ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","សាណា សាណឹត អន់ឌែ អន់ដីស ត្រគ់ តាច់ លូ លៀន យ‌៉័ះ ទៀក អៃត កា ត្រគ់ តាច់ ឡឹង អន់ឌែ ដេល ");
INSERT INTO tpu_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","ខង អាញ់ ឡាក់ ប‌៉្រ័ះ អន់ដីស អន់ សារ ដាគ់ កា អន់ដីស កេះ គ្រឹប ង៉ារ អន់ដីស ប៉្រគ័។ អាញ់ ពួយ រ៉ាំងហៃ រ៉ាំងខ្យា អន់ដីស ផះ រ៉ាំងវ៉ាង អន់ដីស ចាក ពឹង ស៊្រែ តីស កាខាក់ អា។ អាញ់ ឡាក់ ប‌៉្រ័ះ អន់ដីស អ្វៃ អន់ឌូ លូ អន់ដីស ទុញ ៤០ សាណាំ កេះ អន់ដីស អូ អឹត កា កាណាគ័ ញ៉ា អុះ' \"។ ");
INSERT INTO tpu_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","«ពិន កា ចាក យ៉្វារ ប៉ាថេត គន សោ អេសាវ ឡាក់ អុះ ម៉ី ពិន ឡាក់ អ្វៃ ពឹង ព្រី ប៉ានឹម សៀរ។ ពិន កា ចាក រទ្រង ឡាក់ ឡាច់ ឡឹង ស៊្រែ តីស អារ៉ាបា ស្រុក អេឡាត លូ ស្រុក អេសៀន គេបើ ដេល។ កេះណោះ ពិន កា តូរ័ ទ្រង ចាក ឃឺ ឡាច់ ចាក ពួយ ទ្រង តាត់ ស៊្រែ តីស កាណុង ប៉ាថេត ម៉ូអាប់។ ");
INSERT INTO tpu_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អាញ់ ផា \"ជែ តាកូះ លូ សុនសាត ម៉ូអាប់ ណោះ អូ អន់ តាប៉ុញ លូ អន់ឌែ អុះ ខង អាញ់ អូ ទី មប ប៉ាថេត ណោះ អន់ កា អន់ដីស ប៉្រគ័ ប៉ាដក់ ប៉ាជៀ អុះ ខង អាញ់ មប អន់ មឿង អារ លូ ព្រី ទៀក ទិណោ័ះ អន់ កា គន សោ ឡត រ៉ាំងហៃ ប៉្រគ័ ប៉ាដក់ ប៉ាជៀ អន់ឌែ កេះ\"»។ ");
INSERT INTO tpu_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","សើគ ពែ សុនសាត អេម អ្វៃ កាណុង ប៉ាថេត ណោះ អន់ឌែ ឡាក់ សុនសាត សាងុំ កេង ខាក់ លូ ទី កាំឡាំង អៀង ទឹប ឡាកោ អន់ឌែ តីស ចាំងហីគ ឡាក់ កា គន សោ អាណាក់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","សុនសាត ណោះ ពូ អើ ផា សុនសាត រែផៃម ឡាក់ កា គន សោ អាណាក់ ដេល ហះកា សុនសាត ម៉ូអាប់ អើ អន់ឌែ ណោះ ផា សុនសាត អេម។ ");
INSERT INTO tpu_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","សើគ ពែ សុនសាត ហូរី អ្វៃ ពឹង ព្រី ប៉ានឹម សៀរ ណោះ ហះកា គន សោ អេសាវ ទ្រុះ ឡាច់ អន់ឌែ ឡឹង ចារ ណោះ ទឹប ប៉ាន់តោ័ អន់ឌែ កេះណោះ ម៉ុត អ្វៃ អន់ឌែ ឡគ ពឹង ចារ ណោះ ឡាក់ កា សារ សុនសាត អ៊ីស្រាអ៊ែល ដេល ប៉ាគ់ អន់តីគ អន់ឌែ ម៉ុត អ្វៃ ពឹង ប៉ាថេត ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់។ ");
INSERT INTO tpu_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","«កេះណោះ ប‌៉្រ័ះ រ៉ះ ផា \"កិញអៀ អា ហគ់ ប៉ាណាំ គួប ចាក ឃ្លង តាចាង័ សេរេត\"។ ពិន កា ចាក ឃ្លង តាចាង័ សេរេត តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","ឡឹង ដារ់ ពិន ចាក ឡឹង ចារ កាដេះ បារណា ទឹល ដារ់ ពិន ចាក ឃ្លង តាចាង័ សេរេត អា ឃឺ ទុញ ៣៨ សាណាំ កេះ និះ ទឹល ប៉ាណូស រ៉ាំងហាវ អន់ទ្រួល បក់ អ្លុ ឡាំ តាកូះ ពែ តោ័ ទិ កេះ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ម៉ត់ ពែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ កា អន់ឌែ លើយ ទឹល អន់ឌែ តោ័ ទិ ឡឹង កាំឡាំង សុនសាត អ៊ីស្រាអ៊ែល កេះ និះ អូ ទី អ្វៃ សល់ ពឿ ម៉ោញ ដូវ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","«ប៉ាគ់ ប៉ាណូស រ៉ាំងហាវ អន់ទ្រួល បក់ អ្លុ ឡាំ តាកូះ ពែ តោ័ ទិ ឡឹង កាំឡាំង សុនសាត អ៊ីស្រាអ៊ែល កេះ ");
INSERT INTO tpu_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អាញ់ ផា ");
INSERT INTO tpu_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","\"ដារ់ អា អន់ដីស ត្រគ់ ចាក ឡាច់ ឡឹង ប៉ាថេត ម៉ូអាប់ ឃ្លង គួយ ក្យាម័ មឿង អារ។ ");
INSERT INTO tpu_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","ទឹល នីណោ័ះ ប៉ាគ់ ចាក ទឹល ប៉ាគ់ ប៉ាថេត អាម៉ូន ជែ ប៉្រគ័ តាគ់ ប៉ាណាប អន់ឌែ កា អូ អន់ តាកូះ លូ អន់ឌែ ដេល អាញ់ អូ អន់ ប៉ាថេត សុនសាត អាម៉ូន ណោះ កា អន់ដីស អ្យក់ ប៉្រគ័ ប៉ាដក់ ប៉ាជៀ អុះ ខង អាញ់ មប អន់ ប៉ាថេត ណោះ កា គន សោ ឡត រ៉ាំងហៃ ប៉្រគ័ ប៉ាដក់ ប៉ាជៀ អន់ឌែ កេះ\"»។ ");
INSERT INTO tpu_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","ប៉ាថេត ណោះ ពូ អើ ផា ប៉ាថេត សុនសាត រែផៃម ខង សើគ ពែ អន់ឌែ អ្វៃ កាណុង ប៉ាថេត ណោះ។ សុនសាត អាម៉ូន អើ អន់ឌែ ផា សុនសាត សាំស៊ូមីម ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","អន់ឌែ ឡាក់ សុនសាត សាងុំ កេង ខាក់ លូ ទី កាំឡាំង អៀង ទឹប ឡាកោ អន់ឌែ កា តីស ចាំងហីគ ឡាក់ កា គន សោ អាណាក់ ដេល។ ប‌៉្រ័ះ ប៊កកាតយ័ ថាំឡាយ អន់ឌែ ហះ ម៉ាត់ សុនសាត អាម៉ូន។ សុនសាត អាម៉ូន ទ្រុះ ឡាច់ អន់ឌែ ឡឹង ប៉ាថេត ណោះ កេះណោះ សុនសាត អាម៉ូន ម៉ុត អ្វៃ អន់ឌែ ឡគ ");
INSERT INTO tpu_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","ឡាក់ កា ប‌៉្រ័ះ ប៉្រគ័ អន់ កា គន សោ អេសាវ អ្វៃ ពឹង ព្រី ប៉ានឹម សៀរ ណោះ ដេល ផះ អ៊ែ ថាំឡាយ សុនសាត ហូរី អន់ ឡាច់ ឡឹង ម៉ាត់ អន់ឌែ កេះណោះ អន់ឌែ ទ្រុះ ឡាច់ សុនសាត ណោះ ម៉ុត អ្វៃ អន់ឌែ ឡគ ពឹង ព្រី ប៉ានឹម ណោះ លើយ ទឹល រ៉ប់ ដារ់ អា ដេល។ ");
INSERT INTO tpu_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","កាប៉ាច់ សុនសាត អាវីម សើគ ពែ អ្វៃ ប៉ិន ស្រុក ៗ លើយ ទឹល មឿង កាសា។ ហះកា សុនសាត កាប់ថោរ ឡាច់ ឡឹង ប៉ាថេត កាប់ថោរ ឡាំ ថាំឡាយ អន់ឌែ ទឹប អ្យក់ ស្រុក អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","«កេះណោះ ប‌៉្រ័ះ រ៉ះ ផា \"ហគ់ ប៉ាណាំ គួប ចាក ឃ្លង ទ្រូង ទៀក អាណូន។ ហៃ អាញ់ មប សាដាច់ ស៊ីហុន ឡាក់ សាដាច់ សុនសាត អាម៉ូរី អ្វៃ ប៉ាគ់ មឿង ហេសាបូន ទឹប តេះ អន់ឌែ ទិណោ័ះ ពឹង តី អន់ដីស កេះ។ ហគ់ ទ្រៀម តាហាន ឡាំ តាកូះ លូ អន់ឌែ ណោះ កិញអៀ ហង កេះណោះ ម៉ុត អ្យក់ ប៉ាថេត ណោះ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","ឡឹង ដារ់ អា ហង អាញ់ ចឹង ប៉្រគ័ អន់ ទិ សុនសាត ឡាក់ អ្វៃ កាន់តេ័ះ ប៉្លៃង គ្រឹប ចារ អ្យូគ រ៉ារ៉ៃត កា អន់ដីស។ ញន កា ពូ កាតាំង ពូ រ៉ះ ឡឹង សារ អន់ដីស ពូ ចឹង អ្យូគ រ៉ារ៉ៃត ឡាកោ លូ ទី សារ ថុក ពុត ពៀក ញន កា អន់ដីស\"។ ");
INSERT INTO tpu_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","«កេះណោះ អាញ់ ប៉្រើ ប៉ាណូស ឡឹង ស៊្រែ តីស កាដេម៉ូត ឡាំ រ៉ះ ប៉ាគ់ សាដាច់ ស៊ីហុន ឡាក់ សាដាច់ មឿង ហេសាបូន ភឿ រ៉ះ កា អ៊ែ អន់ ដាគ់ ប៉ាឡឹង ឃឺ អាញ់ ប៉្រើ ពូ រ៉ះ ផា ");
INSERT INTO tpu_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","\"អន់ ញឹន ចាក តាត់ ប៉ាថេត អីស ណើ ញឹន ក្រាន័ កា ចាក រទ្រង លួង តីស ដោច ញឹន អូ កាលែង សាម៉ា លើ សាំងអ្យោ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","សាណា លូ ទៀក អន់ដីស អន់ កា ញឹន អៃត សា ប៉រ់ អន់ដីស ប្រូ កា ញឹន ពិ ប៉រ់ ហះ អន់ដីស អន់ ដឹង ញឹន ចាក តាត់ ប៉ាថេត អីស អា ");
INSERT INTO tpu_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","ទឹល ញឹន ឃ្លង ទៀក ទ្រូង យដាន់ រ៉ាវ៉ាច់ ចាក ម៉ុត កាណុង ប៉ាថេត ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ញឹន អ៊ែ អន់ កា ញឹន។ ប៉រ់ អីស អន់ ទ្រង កា ញឹន ឡាក់ កា មួត គន សោ អេសាវ ឡាក់ អ្វៃ ពឹង ព្រី ប៉ានឹម សៀរ លូ មួត សុនសាត ម៉ូអាប់ ឡាក់ អ្វៃ ពឹង មឿង អារ អន់ ទ្រង កា ញឹន ដេល\"។ ");
INSERT INTO tpu_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","ហះកា សាដាច់ ស៊ីហុន ឡាក់ សាដាច់ មឿង ហេសាបូន អ៊ែ អូ អន់ ពិន ចាក តាត់ ប៉ាថេត អ៊ែ អុះ ខង ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ប៉្រគ័ អន់ កា សាដាច់ ណោះ កាង័ កល់ ភឿ មប អន់ឌែ ណោះ ពឹង តី អន់ដីស ឡាក់ កា អន់ដីស ប៉ប័ កាណុង ដារ់ អា កេះ។ ");
INSERT INTO tpu_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អាញ់ ផា \"ហៃ អាញ់ មប សាដាច់ ស៊ីហុន លូ ប៉ាថេត អ៊ែ ពឹង តី អីស កិញអៀ ហង។ ទឹល នីណោ័ះ ហគ់ តាប៉ីត អ្យក់ ប៉ាថេត ណោះ កិញអៀ ហង ពិ\"។ ");
INSERT INTO tpu_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","សាដាច់ ស៊ីហុន លូ ប៉ាសុន អ៊ែ ទិឌូ កា ឡាំ តាកូះ លូ ពិន ត្រង់ ហះ ព្រី យ៉ាហះ។ ");
INSERT INTO tpu_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ពិន មប សាដាច់ ណោះ ពឹង តី ពិន។ ពិន កា ប៉ាន់តោ័ សាដាច់ ស៊ីហុន លូ គន សោ អ៊ែ ទឹប តាហាន លូ ប៉ាសុន អ៊ែ ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","រ៉ាំងវ៉ាង ណោះ ពិន តាប៉ីត អ្យក់ មឿង សាដាច់ ស៊ីហុន ទិណោ័ះ ទឹប ប៉ាន់តោ័ អន់ឌែ គ្រឹប មឿង ទឹប កាម៉ាក័ ទឹប អង់កាន់ ទឹប សាស្វា ម៉ោញ ដូវ កា អូ គម អន់ អ្វៃ សល់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","ពិន អ្យក់ ដឹង រ៉ក់ ប៉ារ់ពេ ចៀម លូ រ៉ាស អំប៉ាស ឡឹង មឿង អន់ទៀគៗ ឡាក់ ពិន តាប៉ីត អ្យក់ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","អ្យក់ ឡឹង មឿង អារ៉ូអ៊ើរ ឡាក់ អ្វៃ រហាង ទ្រូង ទៀក អាណូន លូ មឿង ឡាក់ អ្វៃ រក្លូះ ប៉ានឹម លើយ ទឹល ព្រី ប៉ានឹម កាឡាត មឿង ទិណោ័ះ អូ ដាម័ ពិន អុះ ខង ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ពិន មប មឿង ទិណោ័ះ អន់ កា ពិន កេះ។ ");
INSERT INTO tpu_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","ទី ដឹង ប៉ាថេត គន សោ អាម៉ូន ណោះ ហង ឡាក់ អន់ដីស អូ ទី ម៉ុត ក្យាម័ អុះ ឃឺ ស្រុក ឡាក់ អ្វៃ រហាង ទ្រូង ទៀក យ៉ាបុក លូ មឿង អន់ទៀគៗ ឡាក់ អ្វៃ រព្រី ប៉ានឹម ឃឺ ចារ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ពិន ទឹប អូ អន់ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","«កេះណោះ ពិន កា តះ គែង ទ្រង ឡាំ ប៉ាគ់ ប៉ាថេត បាសាន។ អុក ឡាក់ សាដាច់ ប៉ាថេត បាសាន លូ ប៉ាសុន អ៊ែ ទិឌូ កា ឡាំ តាកូះ លូ ពិន ត្រង់ ហះ មឿង អេទ្រី។ ");
INSERT INTO tpu_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អាញ់ ផា \"ជែ អ្យូគ កា អ៊ែ ណោះ ខង អាញ់ មប អ៊ែ ណោះ លូ ប៉ាសុន ទិណោ័ះ ទឹប ប៉ាថេត អន់ឌែ ណោះ ពឹង តី អីស កេះ។ អន់ដីស ចឹង ប៉្រគ័ កា អន់ឌែ ឡាក់ កា អន់ដីស ប៉្រគ័ កា ស៊ីហុន ឡាក់ សាដាច់ សុនសាត អាម៉ូរី អ្វៃ ពឹង មឿង ហេសាបូន ពែ ដេល\"។ ");
INSERT INTO tpu_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ពិន កា មប អុក ឡាក់ សាដាច់ ប៉ាថេត បាសាន ណោះ លូ ប៉ាសុន អ៊ែ ទិណោ័ះ ពឹង តី ពិន ដេល។ កេះណោះ ពិន កា ប៉ាន់តោ័ អន់ឌែ ទិ ម៉ោញ ដូវ កា អូ អ្វៃ សល់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","5","រ៉ាំងវ៉ាង ណោះ ពិន តាប៉ីត អ្យក់ ទិ មឿង ទិ ស្រុក ម៉ះ សាដាច់ អុក។ អូ ទី មឿង លើ ស្រុក អ៊ែ ចំ ឡាក់ ពិន តាប៉ីត អ្យក់ អូ ទី ណោះ អុះ ឃឺ ទី ៦០ ស្រុក ឡាក់ អ្វៃ ពឹង ព្រី ទៀក អាកុប កាណុង ប៉ាថេត បាសាន ឡាក់ សាដាច់ អុក រ៉ាំងហៃ យ៉ាប ដឹង ស្រុក ឡាក់ ទី ប៉ាន់ទៀយ ចាំងហីគៗ លូ ទី អំប៉ារ ប៉ាសយ់។ កាយ ឡឹង ណោះ ទី ស្រុក អៀង ណាវ្គ ឡាក់ អូ ទី ប៉ាន់ទៀយ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","ពិន ប៉ាន់តោ័ អន់ឌែ ឡាក់ កា ពិន ប៉្រគ័ កា សាដាច់ ស៊ីហុន អ្វៃ ពឹង មឿង ហេសាបូន ដេល ឃឺ ពិន ប៉ាន់តោ័ ប៉ាណូស កាណុង ស្រុក ទិណោ័ះ ទឹប កាម៉ាក័ ទឹប អង់កាន់ លូ មួត សាស្វា។ ");
INSERT INTO tpu_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","ហះកា ពិន អ្យក់ រ៉ក់ ប៉ារ់ពេ ចៀម លូ រ៉ាស អំប៉ាស ទិណោ័ះ ឡាក់ ទី កាណុង ស្រុក។ ");
INSERT INTO tpu_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","រ៉ាំងវ៉ាង ណោះ ពិន តាប៉ីត អ្យក់ ប៉ាថេត គែង ដារ់ ឡាច់ ទៀក ទ្រូង យដាន់ ឡឹង សាដាច់ ពៀរ ដូវ ឡាក់ សាដាច់ សុនសាត អាម៉ូរី អ្យក់ ឡឹង ទ្រូង ទៀក អាណូន លើយ ទឹល ប៉ានឹម ហ៊ើម៉ូន»។ ");
INSERT INTO tpu_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","ប៉ានឹម ហ៊ើម៉ូន ណោះ មួត មឿង ស៊ីដូន អើ ផា ប៉ានឹម ស៊ីរៀន ហះកា សុនសាត អាម៉ូរី អើ ផា ប៉ានឹម សេនៀរ។ ");
INSERT INTO tpu_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","«ពិន តាប៉ីត អ្យក់ ទី ទិ មឿង ទិ ស្រុក រចារ ព្រី គោក លូ ព្រី ប៉ានឹម កាឡាត ទិណោ័ះ លូ ប៉ាថេត បាសាន ទិណោ័ះ លើយ ទឹល សាល់កា លូ អេទ្រី ឡាក់ មឿង ម៉ះ សាដាច់ អុក កាណុង ប៉ាថេត បាសាន»។ ");
INSERT INTO tpu_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","ទី ដឹង អុក ឡាក់ សាដាច់ ប៉ាថេត បាសាន ហង ឡាក់ អ្វៃ សល់ ឡឹង សុនសាត រែផៃម ពែ។ គ្រេ អ៊ែ ពូ ប៉្រគ័ លូ ប៉ាសយ់ ពូ អន់ ពឹង មឿង រ៉ាបាត ឡាក់ មឿង មួត សុនសាត អាម៉ូន គ្រេ ណោះ អ្លឹង អញ់សឹន ហាត់ អំពុ តីស ប៉្វាន់ ហាត់ ផា វ៉ាស លូ ហាត់ ប៉ាណូស។ ");
INSERT INTO tpu_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","«រ៉ាំងវ៉ាង ណោះ ពិន តាប៉ីត អ្យក់ ប៉ាថេត ណោះ។ អាញ់ មប ព្រី ទៀក ណោះ អ្យក់ ឡឹង មឿង អារ៉ូអ៊ើរ ឡាក់ អ្វៃ រហាង ទ្រូង ទៀក អាណូន ទឹប ចារ ព្រី ប៉ានឹម កាឡាត ទងតិគ័ លូ មឿង ទិណោ័ះ ឡាក់ អ្វៃ ពឹង ចារ ណោះ អន់ កា ផូង័ រូបេន លូ ផូង័ កាត។ ");
INSERT INTO tpu_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","កាប៉ាច់ ផូង័ ម៉ាណាសេ ឡាក់ ពូ កះ អ្យក់ ទងតិគ័ អាញ់ អន់ ព្រី ប៉ានឹម កាឡាត ឡាក់ អ្វៃ សល់ លូ ប៉ាថេត បាសាន ឡាក់ ប៉ាថេត សាដាច់ អុក ទិណោ័ះ អន់ កា អន់ឌែ»។ … ");
INSERT INTO tpu_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","វគ័ ម៉ូសេ រ៉ះ កា អន់ឌែ ណាវ្គ ផា «អា ចាបាប់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អ៊ែ ប៉្រើ អាញ់ ប៉ាំងហៀន អន់ដីស ភឿ អន់ អន់ដីស ប៉្រគ័ ពួយ ប៉ាគ់ អ្វៃ ពឹង ប៉ាថេត ឡាក់ អន់ដីស ចឹង ម៉ុត អ្យក់ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","អន់ដីស ត្រគ់ អ្យិល កូត័ អ្យូគ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស លូ ប៉្រគ័ ពួយ គ្រឹប ចាបាប់ អ៊ែ ឡាក់ អាញ់ ប៉្រើ លូ រ៉ះ កា អន់ដីស អា អន់ ឡុច អាញុ អន់ដីស លូ គន សោ អន់ដីស ភឿ អន់ អន់ដីស ទី អាញុ រ៉ីស ទុញ។ ");
INSERT INTO tpu_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","អឺ អ៊ីស្រាអ៊ែល ហគ់ សាំយ៉ាំង ចាបាប់ ប‌៉្រ័ះ កេះណោះ ប៉្រគ័ ពួយ ពិ ភឿ អន់ អន់ដីស ទី សារ សាណុក សាវ៉ាក លូ អន់ កើត ចំលួន អៀង កាខាក់ អ្វៃ ពឹង ប៉ាថេត ឡាក់ ទី ទៀក តោះ រ៉ក់ លូ ទៀក សុត អៀង ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ វគ័ យ៉ាគ់ អន់ដីស សាញ៉ា លូ អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","«អឺ មួត អ៊ីស្រាអ៊ែល ហគ់ សាំយ៉ាំង ពិ ! ទី ដឹង ប‌៉្រ័ះ ប៊កកាតយ័ ម៉ោញ ដូវ អា ហង ប‌៉្រ័ះ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","ត្រគ់ ប៉ិច ចៃ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ទិ ពុត ទិ ពៀក ទឹប ប៉ាង៉ាត័ ប៉ាលឹង ទឹប ឡាកោ ប៉ាំងឡៃ។ ");
INSERT INTO tpu_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","ត្រគ់ អន់ ប៉ានឹរ ប‌៉្រ័ះ ឡាក់ អាញ់ រ៉ះ កា អន់ដីស ដារ់ អា អ្វៃ កាណុង ពុត អន់ដីស លើយ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","ហគ់ ខំ ប៉ាំងហៀន ប៉ានឹរ ប‌៉្រ័ះ អា កា គន សោ អន់ដីស ឃឺ ត្រគ់ រ៉ះ អន់ អន់ឌែ សាំយ៉ាំង ផះ អ្វៃ ពឹង ហី កាតាម ផះ ចាក រទ្រង កាតាម ផះ ម៉ុត តៃប កាតាម ផះ អ្យូវ ឡឹង តៃប កាតាម។ ");
INSERT INTO tpu_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","ត្រគ់ ច្រាគ់ ប៉ានឹរ ប‌៉្រ័ះ អា កត់ ពឹង តី អន់ដីស ប៉្រគ័ សាញ៉ា តាគ់ កាចាំង លូ កត់ ពឹង កល់ យ៉ាំង អន់ដីស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","ហគ់ ច្រាគ់ ពឹង អំប៉ារ ហី អន់ដីស លូ ពឹង អំប៉ារ មឿង អន់ដីស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","«ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អ៊ែ ចឹង ប៉ាណាំ អន់ដីស ម៉ុត កាណុង ប៉ាថេត ឡាក់ អ៊ែ ម៉ត់ លូ អាប៉្រាហាំ អ៊ីសាក់ លូ យ៉ាកុប ឡាក់ វគ័ អន់ដីស ប‌៉្រ័ះ ផា ចឹង អន់ កា អន់ដីស។ ប៉ាថេត ណោះ ទី មឿង តីសៗ ដាគ់ៗ ឡាក់ មឿង អន់ដីស អូ ទី ប៉្រគ័ ");
INSERT INTO tpu_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","ទឹប ទី ហី កាណុង ហី ណោះ ទី រ៉ាស អៀង គ្រឹប នែវ ឡាក់ រ៉ាស អំប៉ាស អន់ដីស អូ ទី ណាំង លូ ទី ឡូះ ទៀក ឡាក់ អន់ដីស អូ ទី សីរ លូ ទី ម៉ីរ ប៉្លៃ អង់កាច លូ ម៉ីរ តើម អូលេវ ឡាក់ អន់ដីស អូ ទី តប់ ម៉ាគ់ អន់ដីស ចឹង ទី សា ផីគ។ ");
INSERT INTO tpu_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","ហះកា ត្រគ់ ឡាវ៉ាំង ឡាកោ ណើ អន់ទៀ អន់ដីស ពឹល ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប៉ាណាំ អន់ដីស ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ឡាក់ ប៉ាថេត អន់ដីស អ្វៃ ប៉្រគ័ ទុច ពូ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","ហគ់ អ្យិល កូត័ អ្យូគ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ទឹប សាំប‌៉័ះ ប៉ានេ អ៊ែ។ ផា អន់ដីស ម៉ត់ ត្រគ់ អើ ដឹង សិច អ៊ែ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","អូ អន់ អន់ដីស សឿ ប‌៉្រ័ះ អន់ទៀគៗ ឡាក់ ប‌៉្រ័ះ សុនសាត អន់ទៀគ ឡាក់ អ្វៃ ជុំ អន់ដីស ណោះ អុះ ");
INSERT INTO tpu_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","ខង ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ អ្វៃ ហះ អន់តិគ័ អន់ដីស អ៊ែ ក្យាគ់ អន់ដីស លូ ប‌៉្រ័ះ អន់ទៀគ។ ផា ប៉្រគ័ នីណោ័ះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អ៊ែ ចឹង អឺក កា អន់ដីស កាខាក់ ឡូត កេះណោះ អ៊ែ ចឹង ប៉ាន់តោ័ អន់ដីស អន់ ទិ ឡឹង អង់កក់ តេះ អា។ ");
INSERT INTO tpu_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","អូ អន់ សាគ់ លួង ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ឡាក់ កា អន់ដីស ឃើយ សាគ់ លួង អ៊ែ ផះ អ្វៃ ហះ ព្រី ម៉ាសា ពែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","ហះកា ត្រគ់ ប៉្រគ័ ពួយ សារ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ ណោះ អន់ កាខាក់ ទឹប ប៉្រគ័ ពួយ ចាបាប់ ឡាក់ អ៊ែ រ៉ះ។ ");
INSERT INTO tpu_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","ត្រគ់ ប៉្រគ័ ង៉ារ ដាគ់ ត្រង់ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ភឿ អន់ ទី សារ សាណុក សាវ៉ាក លូ អន់ ទី ម៉ុត អ្យក់ ប៉ាថេត ដាគ់ ឡាក់ អ៊ែ ម៉ត់ លូ វគ័ អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","អ៊ែ ចឹង ទ្រុះ ឡាច់ តាម៉ឺរ ហះ ម៉ាត់ អន់ដីស អន់ ទិ ឡាក់ កា អ៊ែ សាញ៉ា ពែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","«ប៉ាគ់ យ៉ាង័ តោ ទៀ ផា គន អន់ដីស អំប៉ញ់ ផា \"ចាបាប់ ទិ អា ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ពិន រ៉ះ កា ពិន ពែ ទី រ៉ាឡា នីចម័ ?\" ");
INSERT INTO tpu_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","អន់ដីស ត្រគ់ រ៉ះ កា គន អន់ដីស ផា \"សើគ ពែ សុនសាត ពិន អ្វៃ ប៉្រគ័ ទុច សាដាច់ អ៊ីស៊ីប ពឹង ប៉ាថេត អ៊ីស៊ីប ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាណាំ អន់ឌែ ឡាច់ ឡឹង ប៉ាថេត ណោះ ញន កា សារ អំរ៉ាញ អឺញ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","អ៊ែ តាំបាង សារ អំរ៉ាញ អឺញ កេង ខាក់ លូ ប៉្រគ័ អន់ ទី សារ ឡាំបាក កាខាក់ ពឹង សុនសាត អ៊ីស៊ីប ទឹប សាដាច់ លូ ហី ក្រាន អ៊ែ អន់ សុនសាត ពិន ប៉ប័។ ");
INSERT INTO tpu_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","អ៊ែ កា ប៉ាណាំ អន់ឌែ ឡាច់ ឡឹង ប៉ាថេត ណោះ ឡាំ អ្វៃ ពឹង ប៉ាថេត ឡាក់ អ៊ែ ម៉ត់ លូ វគ័ ពិន ផា ចឹង អន់ ប៉ាថេត អា កា អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ ពិន ប៉្រគ័ ពួយ ចាបាប់ ទិ អា ទឹប អ្យិល កូត័ អ្យូគ កា អ៊ែ ឡាក់ ប‌៉្រ័ះ ពិន ភឿ អន់ ពិន ទី សារ សាណុក សាវ៉ាក រ៉ប់ ដារ់ លូ អន់ អ៊ែ រ៉ាំងហៃ រ៉ាំងខ្យា ពិន អន់ អ្វៃ រ៉ីស ឡាក់ កា អ៊ែ រ៉ាំងហៃ រ៉ាំងខ្យា រ៉ប់ ដារ់ អា ហង។ ");
INSERT INTO tpu_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","ពិន ត្រគ់ ខំ ប៉្រគ័ ពួយ ចាបាប់ ទិ អា ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ ភឿ អន់ ពិន ដាគ់ ត្រង់ លូ ត្រគ់ ពុត អ៊ែ ឡាក់ ប‌៉្រ័ះ ពិន\"»។ … ");
INSERT INTO tpu_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","វគ័ ម៉ូសេ រ៉ះ កា អន់ឌែ ណាវ្គ ផា «ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អ៊ែ ចឹង ប៉្រគ័ អន់ ទី រ៉ាគឹយ ប‌៉្រ័ះ កើត ឡាច់ ឡឹង អុះ ម៉ី អន់ដីស។ រ៉ាគឹយ ប‌៉្រ័ះ ណោះ ចឹង វ៉ឹច លូ អាញ់។ អន់ដីស ត្រគ់ ប៉ាណាំ គួប សាំយ៉ាំង រ៉ាគឹយ ប‌៉្រ័ះ ណោះ ពិ ");
INSERT INTO tpu_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","ខង ផះ ដារ់ អន់ដីស អ្វៃ ប៉ាតុំ គួប សោប ហះ ប៉ានឹម ស៊ីណាយ ណោះ ពែ អន់ដីស ប៉រ់ ឡឹង ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ឃឺ អន់ដីស កាប ផា \"ជែ អន់ ញឹន កាតាំង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ពិន នែវ អា ណាវ្គ លូ ជែ អន់ ញឹន ប៉ប័ អុញ តីស អា ដេល អន់ទៀ ញឹន តោ័\"។ ");
INSERT INTO tpu_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","ផះ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ លូ អាញ់ ផា \"សារ អន់ឌែ កាកាប ណោះ ត្រគ់ តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","អាញ់ ចឹង ប៉្រគ័ អន់ ទី រ៉ាគឹយ ប‌៉្រ័ះ កើត ឡាច់ ឡឹង អុះ ម៉ី អន់ឌែ សាំរ៉ាប់ កា អន់ឌែ អន់ ឡាក់ កា អីស កេះណោះ អាញ់ ចឹង ចៃគ ប៉ានឹរ អាញ់ ពឹង ពឹរ រ៉ាគឹយ ប‌៉្រ័ះ ណោះ អ៊ែ ណោះ ចឹង រ៉ះ កា ពូ គ្រឹប សារ អាញ់ ចឹង ប៉្រើ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","ផា ពឿ អូ ចៃ សាំយ៉ាំង សារ អាញ់ ប៉្រើ អ៊ែ រ៉ះ ណោះ អាញ់ ចឹង ចៃគ ថូត ពូ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","ហះកា រ៉ាគឹយ ប‌៉្រ័ះ ចំ រ៉ះ សារ ញ៉ា តាម ពុត អ៊ែ ទៅ ហះកា អ៊ែ ផា រ៉ះ ឡឹង សារ អាញ់ ឡាក់ សារ អាញ់ អូ ទី ប៉្រើ អ៊ែ កាប អ៊ែ ចឹង ត្រគ់ តោ័។ រ៉ាគឹយ ប‌៉្រ័ះ ចំ រ៉ះ ឡឹង សារ ប‌៉្រ័ះ អន់ទៀគ រ៉ាគឹយ ប‌៉្រ័ះ ណោះ ចឹង ត្រគ់ តោ័ ដេល\"។ ");
INSERT INTO tpu_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","ផា អន់ដីស ចឹង អំប៉ញ់ ផា \"ប៉្រគ័ នីចម័ អន់ ញឹន អ្លុ អន់តគ់ ផា សារ ញ៉ា ឡាក់ អូ ត្រគ់ ឡាច់ ឡឹង ប‌៉្រ័ះ ប៊កកាតយ័  ?\" ");
INSERT INTO tpu_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","ផា រ៉ាគឹយ ប‌៉្រ័ះ ចំ ផា អ៊ែ រ៉ះ សារ ឡឹង ប‌៉្រ័ះ ប៊កកាតយ័ ហះកា អូ ប៉ប័ ទី សារ ញ៉ា កើត ពឹះ ឡាក់ កា សារ អ៊ែ រ៉ះ ណោះ សារ ណោះ អូ ត្រគ់ ឡាច់ ឡឹង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ អុះ ឃឺ រ៉ាគឹយ ប‌៉្រ័ះ ណោះ អ៊ែ កាប តាម ពុត អ៊ែ ទៅ។ ទឹល នីណោ័ះ អន់ដីស ជែ អ្យូគ កា អ៊ែ ដៃ»។ … ");
INSERT INTO tpu_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","វគ័ ម៉ូសេ រ៉ះ កា អន់ឌែ ណាវ្គ ផា «ផា អន់ដីស ខំ សាំយ៉ាំង អ្យក់ ពុត ចៃគ រ៉ាប់ សឿ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ទឹប ប៉្រគ័ ពួយ ទិ សារ អ៊ែ ប៉្រើ ឡាក់ កា អាញ់ រ៉ះ កា អន់ដីស កាណុង ដារ់ អា ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អ៊ែ ចឹង ប៉្រគ័ អន់ អន់ដីស កើត សុនសាត ម៉ោញ ឡាក់ អំរ៉ាញ អឺញ ហ៊្លត ឡឹង សុនសាត អន់ទៀគៗ ទិណោ័ះ ពឹង អង់កក់ តេះ អា។ ");
INSERT INTO tpu_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","ផា អន់ដីស ប៉្រគ័ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អ៊ែ ចឹង អន់ សារ ដាគ់ កា អន់ដីស គ្រឹប នែវ ");
INSERT INTO tpu_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","ឃឺ ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង អន់ សារ ដាគ់ កា អន់ដីស ផះ អន់ដីស អ្វៃ ពឹង មឿង លូ ផះ អន់ដីស អ្វៃ ពឹង ម៉ីរ ពឹង ស៊្រែ កា អ៊ែ ចឹង អន់ សារ ដាគ់ និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង អន់ សារ ដាគ់ កា អន់ដីស អន់ អន់ដីស ទី គន សោ អៀង លូ ចឹង ប៉្រគ័ អន់ តេះ អន់ដីស កើត ទី សាណា អៀង។ តាប៉ល់ រ៉ក់ តាប៉ល់ ចៀម អន់ដីស កា ចឹង កើត អៀង និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង អន់ សារ ដាគ់ កា អន់ដីស អន់ អន់ដីស ទី ប៉្លៃ អ៊្លង ប៉ាញ័ កាអ្លី លូ ទី តាប៉ុង ប៉ាញ័ កាបឺង។ ");
INSERT INTO tpu_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","អ៊ែ ចឹង អន់ សារ ដាគ់ កា អន់ដីស រ៉ប់ អន់ដីស ចាក លូ រ៉ប់ អន់ដីស សឹត។ ");
INSERT INTO tpu_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","«ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉្រគ័ អន់ កា មួត តាម៉ឺរ បក់ ឡាំ តាកូះ លូ អន់ដីស អន់ អន់ឌែ អូ ដាម័ អន់ដីស។ អន់ឌែ ចឹង ឡាំ តាកូះ លូ អន់ដីស ដឹង ម៉ោញ ទ្រង ហះកា អន់ឌែ ចឹង សាតាក់ ឡាច់ ឡឹង អន់ដីស ទី តាំប៉ើះ ទ្រង។ ");
INSERT INTO tpu_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង អន់ សារ ដាគ់ កា អន់ដីស អន់ អន់ដីស ទី ពៀ អៀង ប៉ាញ័ រម លូ ង៉ារ ញ៉ា ឡាក់ អន់ដីស ប៉្រគ័ អ៊ែ ចឹង អន់ សារ ដាគ់ លើយ។ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ចឹង អន់ សារ ដាគ់ កា អន់ដីស ពឹង ប៉ាថេត ឡាក់ អ៊ែ អន់ កា អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","ផា អន់ដីស ប៉្រគ័ ពួយ សារ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ លូ អ្វៃ កោប ដាគ់ ពួយ អ៊ែ រ៉ះ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉្រគ័ អន់ អន់ដីស កេះ ប៉ាសុន ដាគ់ សាំរ៉ាប់ កា អ៊ែ តាទឹច ឡាក់ កា អ៊ែ ម៉ត់ លូ អន់ដីស ពែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","គ្រឹប សុនសាត អ្វៃ ពឹង អង់កក់ តេះ ចឹង ប៉ប័ ផា អន់ដីស ឡាក់ ប៉ាសុន ប‌៉្រ័ះ ប៊កកាតយ័  ពូ កា ចឹង អ្យិល កូត័ អ្យូគ កា អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ចឹង ប៉្រគ័ អន់ គន សោ ផូង័ វ៉ាច់ អន់ដីស កើត អៀង លូ ចឹង ប៉្រគ័ អន់ តាប៉ល់ រ៉ក់ តាប៉ល់ ចៀម អន់ដីស កើត អៀង លូ ចឹង ប៉្រគ័ អន់ អន់ដីស ទី សាណា អៀង ផះ អ្វៃ ពឹង ប៉ាថេត ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ម៉ត់ លូ វគ័ អន់ដីស ផា ចឹង មប អន់ កា អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉្រគ័ អន់ ទី ទៀក បី ឡឹង ប៉្លៃង ប៉ាញ័ ទឹប ប៉ាថេត អន់ដីស ពួយ ថុន សាណាំ ភឿ អន់ សារ ដាគ់ កា អន់ដីស គ្រឹប ង៉ារ អន់ដីស ប៉្រគ័។ អន់ដីស ចឹង អន់ រ៉ាស អំប៉ាស កា ពូ បុល អៀង ហះកា អន់ដីស អូ បុល ឡឹង ពូ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","13","ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ចឹង អន់ អន់ដីស ប៉្រគ័ ម៉ៃគ ពូ អូ អន់ អន់ដីស ប៉្រគ័ ទុច ពូ អុះ។ អន់ដីស ចឹង អ្វៃ អំប៉ាំង ពូ លើយ អន់ដីស អូ អ្វៃ កាន់តេ័ះ ពូ អុះ។ ហះកា អន់ដីស ត្រគ់ សាំយ៉ាំង ប៉ានឹរ ប‌៉្រ័ះ លូ ប៉្រគ័ ពួយ ទិ សារ អ៊ែ ប៉្រើ ឡាក់ កា អាញ់ រ៉ះ កា អន់ដីស កាណុង ដារ់ អា។ ");
INSERT INTO tpu_vpl VALUES ("DT28_14","006_28_14","DEU","28","14","14","ត្រគ់ អ្យក់ ពុត ចៃគ រ៉ាប់ សឿ ប៉ានឹរ ប‌៉្រ័ះ ឡាក់ អាញ់ អន់តគ់ រ៉ះ កា អន់ដីស កាណុង ដារ់ អា អូ អន់ អន់ដីស អ្យិល កូត័ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ អន់ទៀគ ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","«ហះកា ផា អន់ដីស អូ សាំយ៉ាំង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ផា អន់ដីស អូ អ្យក់ ពុត ចៃគ ប៉្រគ័ ពួយ សារ អ៊ែ ប៉្រើ លូ ទិ ចាបាប់ ឡាក់ អាញ់ រ៉ះ កា អន់ដីស កាណុង ដារ់ អា ណោះ ប‌៉្រ័ះ ចឹង ប៉ាស្យាប អន់ដីស នីអៀ៖ ");
INSERT INTO tpu_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","អ៊ែ ចឹង ប៉ាស្យាប អន់ដីស ផះ អន់ដីស អ្វៃ កាណុង មឿង ផះ អន់ដីស អ្វៃ ពឹង ម៉ីរ ពឹង ស៊្រែ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","ប‌៉្រ័ះ ចឹង ប៉ាស្យាប អន់ដីស ឃឺ អន់ដីស ចឹង អូ ទី ប៉្លៃ អ៊្លង ចៃគ ពឹង កាអ្លី លូ អន់ដីស អូ ទី តាប៉ុង ចៃគ ពឹង កាបឺង។ ");
INSERT INTO tpu_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","អ៊ែ ចឹង ប៉ាស្យាប អន់ដីស ណាវ្គ ឃឺ អន់ដីស ចឹង អូ ទី គន សោ តេះ អន់ដីស កា ចឹង អូ ដាគ់ សាណា តាប៉ល់ រ៉ក់ តាប៉ល់ ចៀម អន់ដីស កា ចឹង អូ កើត អូ រ៉ាល ដេល។ ");
INSERT INTO tpu_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","អ៊ែ ចឹង ប៉ាស្យាប អន់ដីស រ៉ប់ អន់ដីស ចាក លូ រ៉ប់ អន់ដីស សឹត។ ");
INSERT INTO tpu_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង អន់ សារ ថុក ញ៉ាក លូ សារ ចុនចៃ កើត ពឹះ ពឹង អន់ដីស។ គ្រឹប ង៉ារ ញ៉ា ឡាក់ អន់ដីស ប៉្រគ័ ចឹង ត្រគ់ ថាំឡាយ អ្លាត លើយ ទឹល អន់ដីស តោ័ រ៉ាយ តោ័ រ៉ុង ទិ ញន កា សារ អូ ដាគ់ ឡាក់ អន់ដីស អ្លាត សឿ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉្រគ័ អន់ ទី ប៉ាញុ រ៉ាំបល់ ត្រគ់ អន់ដីស លើយ ទឹល អន់ដីស រ៉ុង រ៉ាយ ទិ ឡូត ឡឹង ប៉ាថេត ឡាក់ អន់ដីស ចឹង ម៉ុត អ្វៃ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉្រគ័ អន់ អន់ដីស កើត អីគ ព្លុ រ៉ាំងអា រ៉ាំងអ៊ង ព្លុ តុ ព្លុ រ៉ាឡច់ រ៉ាឡាក លូ ព្លុ គ្រឹន រ៉ារ៉ៃត។ ប៉្លៃង ចឹង កើត ប៉្រាំង អូ បី ពៀ អន់ដីស ចឹង កាសៃង លូ រ៉ាំបល់ ចឹង សុះ។ សារ ថុក ឡាំបាក ទិ អា ចឹង កើត ពឹង អន់ដីស លើយ ទឹល អន់ដីស តោ័។ ");
INSERT INTO tpu_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","ប៉្លៃង ចឹង តុ ឡាក់ កា អុញ តេះ ចឹង កាង័ ឡាក់ កា អំហ្មោ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉្រគ័ អន់ ទី កាបក់ តេះ លូ តេះ ឡាពុក ឡឹង ប៉្លៃង ហ្រុង ពឹង ប៉ាថេត អន់ដីស ប៉ាតាង ទៀក បី លើយ ទឹល អន់ដីស តោ័ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","«ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉្រគ័ អន់ អន់ដីស អូ ដាម័ មួត តាម៉ឺរ។ អន់ដីស ចឹង ឡាំ តាកូះ លូ មួត តាម៉ឺរ ចាក ដឹង ម៉ោញ ទ្រង ហះកា អន់ដីស ចឹង សាតាក់ ឡាច់ តាំប៉ើះ ទ្រង។ ទិ ប៉ាថេត ពឹង អង់កក់ តេះ អា ចឹង កាតាំង លៅ ឡឹង សារ អន់ដីស ផះ ណោះ ពូ ចឹង អ្យូគ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","ប៉ាទ្រូ អន់ដីស ចឹង កេះ សាណា ម៉ីត លូ សាណា កាណាគ័ ព្រី អូ ទី ពឿ ចឹង ឡាំ ទ្រុះ អន់ឌែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","«ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉្រគ័ អន់ អន់ដីស កើត អេះ អោម ឡាក់ កា អ៊ែ ឃើយ ប៉្រគ័ កា ប៉ាសុន អ៊ីស៊ីប ពែ ដេល អ៊ែ ចឹង ប៉្រគ័ កា អន់ដីស អន់ អេះ ក្លន័ លូ កើត អេះ កើត តាំពួច អន់ដីស ចឹង ច័ះ អូ អ្លុ ប៉្រគ័ ព្រេះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉្រគ័ អន់ អន់ដីស កើត អន់ទ្រុយ លូ ចឹង ប៉្រគ័ អន់ អន់ដីស ម៉ាម៉ាំង ម៉ាត់ ហៃ កាណាគ័ ញ៉ា អូ ប៉ប័។ ");
INSERT INTO tpu_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","ផះ កាដារ់ ប៉ង់ អន់ដីស ចឹង ចាក រ៉ាប៉ត់ ឡាក់ កា ប៉ាណូស ម៉ាម៉ាំង ម៉ាត់។ គ្រឹប ង៉ារ អន់ដីស ចឹង ប៉្រគ័ អូ ជៀ ប៉្រគ័ ដេល។ ពូ ចឹង ជិះ ចគ័ អន់ដីស រ៉ប់ ដារ់ ពូ ចឹង អ្យក់ រ៉ាស អំប៉ាស អន់ដីស លើយៗ អូ ទី ពឿ តង័ អន់ដីស អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","ផា អន់ដីស ទី ម៉ើត ចឹង ទី កាម៉ាក័ ម៉ោញ ណាវ្គ ឡាំ ទម អ៊ែ។ ផា អន់ដីស ប៉្រគ័ ហី អន់ដីស ចឹង អូ ទី អ្វៃ អុះ ពឹង ហី ណោះ។ ផា អន់ដីស តប់ ប៉្លៃ អង់កាច អន់ដីស ចឹង អូ ទី សា អុះ ប៉្លៃ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","ពូ ចឹង ប៉ាន់តោ័ រ៉ក់ អន់ដីស ហះ ម៉ាត់ អន់ដីស ហះកា អន់ដីស អូ ទី សា រ៉ាឡា អ៊ែ អុះ។ ពូ ចឹង អ្យក់ លៀ អន់ដីស ហះ ម៉ាត់ អន់ដីស ពូ អូ ជឹន កា អន់ដីស ណាវ្គ អុះ។ ពូ ចឹង មប តាប៉ល់ ចៀម អន់ដីស អន់ កា មួត តាម៉ឺរ អន់ដីស ហះកា អូ ទី ពឿ ចឹង ឡាំ តង័ អន់ដីស អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","ពូ ចឹង ប្រូ គន កាម៉ាក័ គន អង់កាន់ អន់ដីស អន់ កា សុនសាត អន់ទៀគ ហះ ម៉ាត់ អន់ដីស។ រ៉ប់ ដារ់ អន់ដីស ចឹង ក្យាគ់ ហៃ អន់ឌែ វ៉ីល សឹត ទឹល អីគ ហាង ម៉ាត់ ហះកា អន់ដីស ចឹង អូ អ្លុ ប៉្រគ័ នីចម័ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","សុនសាត អន់ទៀគ ឡាក់ អន់ដីស អូ អន់ហ្នាល់ ចឹង សា ថាំឡាយ សាណា ឡាក់ ហ៊ន ពឹង តេះ អន់ដីស អន់ ទិ ឃឺ សាណា ឡាក់ អន់ដីស ខំ ប៉្រគ័ ទិណោ័ះ។ ពូ ចឹង ជិះ ចគ័ ប៉្រគ័ បាប អន់ដីស លើយៗ រ៉ប់ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","ទិ សារ អន់ដីស ចឹង ប៉ប័ ចឹង ប៉្រគ័ អន់ អន់ដីស កើត អន់ទ្រុយ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ពីត អន់ដីស ពឹង តាកុល លូ ពឹង ជុង អន់ កើត អេះ សា រ៉ីគ ឡឹង តាំប៉ាង ជុង ទឹល តាប៉ាង កល់ ឃឺ អន់ដីស ចឹង ច័ះ អូ អ្លុ ប៉្រគ័ ព្រេះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","«ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង អ្យក់ ឡាំ អន់ដីស ទឹប សាដាច់ ឡាក់ អន់ដីស រ៉ើស ប៉្រើ រ៉ាំងហៃ អន់ដីស ឡាំ អ្វៃ ប៉ាគ់ ប៉ាថេត ម៉ោញ ណាវ្គ ឡាក់ អន់ដីស លូ វគ័ យ៉ាគ់ អន់ដីស អូ អន់ហ្នាល់។ អ្វៃ ពឹង ប៉ាថេត ណោះ អន់ដីស ចឹង ប៉ានេ សាំប‌៉័ះ ប‌៉្រ័ះ សុនសាត អន់ទៀគ ឡាក់ ប‌៉្រ័ះ ពូ ប៉្រគ័ លូ អ៊្លង លូ អំហ្មោ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","ផះ អន់ដីស អ្វៃ លូ សុនសាត អន់ទៀគ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាណាំ អន់ អន់ដីស អ្វៃ ណោះ ពូ ទិឌូ ចឹង ញម កា សារ អន់ដីស កេះណោះ ចឹង កាប ពៀប លូ កាប ស្វាគ់ អន់ដីស ហង។ ");
INSERT INTO tpu_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","អន់ដីស ចឹង អ្យក់ តីល ពៀ តុត អៀង ឡាំ សាមូល តប់ ពឹង ម៉ីរ ហះកា ប៉ាគ់ អន់ដីស ច្រូត័ កាច់ ទៀ ចឹង ទី ពៀ ប៊ែត ខង ទិ កា ឡៃប សា ថាំឡាយ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","អន់ដីស តប់ ប៉្លៃ អង់កាច លូ រ៉ាំងហៃ ហះកា អន់ដីស អូ ទី អ្លេះ ប៉្លៃ លូ អូ ទី អៃត តាពែ ប៉្លៃ អង់កាច អុះ ខង ទិ កា អន់ទ្រុង សា។ ");
INSERT INTO tpu_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","អន់ដីស ទី តើម អូលេវ ប៉ាញ័ ស្រុក ហះកា អន់ដីស អូ ទី អ្យក់ សាងី ឡាប ពឹង ឡាកោ អុះ ខង អង់រម អ៊ែ ចឹង ហ្រុង ទិ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","អន់ដីស ទី គន កាម៉ាក័ គន អង់កាន់ ហះកា អន់ឌែ អូ អ្វៃ អន់ឌូ លូ អន់ដីស អុះ ខង មួត តាម៉ឺរ ចឹង រ៉ុប អន់ឌែ អ្យក់ ប៉្រគ័ ទុច។ ");
INSERT INTO tpu_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","ទិ តើម អ៊្លង លូ សាណា ឡាក់ កើត ឡឹង តេះ អន់ដីស ទិណោ័ះ ចឹង កេះ សាណា ឡៃប ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","ប៉ាណូស ឡឹង ប៉ាថេត អន់ទៀគ ឡាក់ អ្វៃ អន់ឌូ លូ អន់ដីស អន់ឌែ ចឹង ទី អំរ៉ាញ ហ៊ែង ខាក់ ហះកា អន់ដីស ហ៊ែង ចឹង អ្វៃ កាន់តេ័ះ អំរ៉ាញ អន់ឌែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","អន់ឌែ ចឹង អន់ រ៉ាស អំប៉ាស កា អន់ដីស បុល អូ ត្រគ់ អន់ដីស ចឹង អន់ រ៉ាស អំប៉ាស កា អន់ឌែ បុល អុះ។ អន់ឌែ ចឹង ប៉្រគ័ ម៉ៃគ អន់ដីស កាប៉ាច់ អន់ដីស ចឹង ប៉្រគ័ ទុច អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","«សារ ប‌៉្រ័ះ ប៉ាស្យាប ទិ អា ចឹង កើត ពឹង អន់ដីស លូ អ្វៃ ពឹង អន់ដីស លើយ ទឹល អន់ដីស តោ័ ខង អន់ដីស អូ សាំយ៉ាំង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស លូ អន់ដីស អូ ប៉្រគ័ ពួយ សារ អ៊ែ ប៉្រើ លូ ចាបាប់ ឡាក់ អ៊ែ រ៉ះ កា អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","ពូ ចឹង ប៉ប័ អន់ដីស លូ ផូង័ អន់ដីស ទី សារ នីណោ័ះ ពូ ចឹង អ្លុ អន់តគ់ ផា ប‌៉្រ័ះ ចៃគ ថូត អន់ដីស តាទឹច ហង ទឹប ពូ ចឹង ញម កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","«ផះ ទី សាណា អៀង ផា អន់ដីស អូ ហោក កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស លូ អូ ប៉ានេ សាំប‌៉័ះ អ៊ែ ");
INSERT INTO tpu_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","ណោះ អន់ដីស ចឹង ប៉្រគ័ ទុច មួត តាម៉ឺរ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង អន់ ឡាំ តាកូះ លូ អន់ដីស ឃឺ អន់ដីស ចឹង ប៉្រគ័ ទុច ពូ ទឹប ឡាយ៉ិត ឡាំងវ៉ាញ់ ទឹប អ្វៃ សាឡុន ឡាកោ តាដោះ ទឹប អូ ទី កាណាគ័ ញ៉ា ទិណោ័ះ។ ពូ ចឹង ប៉ាំងខំ ប៉ាន់ដាំ អន់ អន់ដីស ប៉្រគ័ ង៉ារ ក្លេ័ះ ក្លាំង លើយ ទឹល អន់ដីស តោ័។ ");
INSERT INTO tpu_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង អ្យក់ សុនសាត ម៉ោញ ឡឹង ឡាណុច តេះ ឡាណុច ប៉្លៃង ប៉្រើ ឡាំ ពីត អន់ដីស។ សុនសាត ណោះ ចឹង ពឹះ ទឹល ឡាក់ កា ក្លាង អ៊ក ឡាំ ប៉ះ អន់ដីស អូ អ្លុ កាប សុនសាត ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","សុនសាត ណោះ ខូយ ប៉ាអ្យប់ ខាក់ អន់ឌែ អូ អ្យិល កូត័ កា ក្រាគ់ តាំងកង់ អុះ កា អូ ទី ពុត តាប៉ាប តាប៉ុន កា មួត សាស្វា ដេល។ ");
INSERT INTO tpu_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","អន់ឌែ ចឹង សា ចៀម សា រ៉ក់ លូ សា សាណា ឡាក់ កើត ឡឹង តេះ អន់ដីស អន់ ទិ ឡូត។ ពៀ ភែ តាពែ ប៉្លៃ អង់កាច សាងី គន ចៀម គន រ៉ក់ កា អន់ឌែ អូ គម អន់ កា អន់ដីស អុះ។ កេះណោះ អន់ឌែ ចឹង ប៉្រគ័ អន់ អន់ដីស តោ័។ ");
INSERT INTO tpu_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","អន់ឌែ ចឹង វ៉ិង ទិ មឿង អន់ដីស អ្វៃ អន់ឌែ ចឹង តាគ់ អំព្លូក ប៉ាន់ទៀយ មឿង ឡាក់ ចាំងហីគ លូ កាចាប័ កាណុង ប៉ាថេត អន់ដីស ឃឺ ប៉ាន់ទៀយ ឡាក់ អន់ដីស ម៉ឹង។ អន់ឌែ ចឹង វ៉ិង អន់ដីស គ្រឹប ចារ កាណុង ប៉ាថេត ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អន់ កា អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","ផះ រ៉ាំងវ៉ាង មួត តាម៉ឺរ វ៉ិង ណោះ អន់ដីស ចឹង ឡាំបាក ខាក់ និះ ចឹង សា គន ទៅ ឃឺ គន កាម៉ាក័ គន អង់កាន់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អន់។ ");
INSERT INTO tpu_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","54","កាណុង កាំឡាំង អន់ដីស បក់ ឃើយ ដាគ់ សីម ឡឹង ពូ លូ ទី ពុត តាប៉ាប តាប៉ុន អ៊ែ ចឹង កើត ឡន័ ម៉ាត់ កា អុះ ម៉ី លូ កា កាម៉ាញ់ ឡាក់ ប៉ិច លូ កា គន ឡាក់ អ្វៃ សល់ ");
INSERT INTO tpu_vpl VALUES ("DT28_55","006_28_55","DEU","28","55","55","ញន កា អ្យូគ កា ពូ តាប៉ីត សា គន អ៊ែ ឡាក់ អ៊ែ គម សាំរ៉ាប់ សា អ៊ែ ទៅ ខង ផះ រ៉ាំងវ៉ាង មួត តាម៉ឺរ វ៉ិង ទិ មឿង អន់ដីស អ្វៃ អន់ដីស ចឹង ថុក ឡាំបាក ខាក់ អូ ទី កាណាគ័ ញ៉ា ចឹង សា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","56","កាណុង កាំឡាំង អន់ដីស អង់កាន់ បក់ ដាគ់ សីម ឡឹង ពូ លូ ទី ពុត តាប៉ាប តាប៉ុន យ‌៉័ះ តេះ កា អូ ឃើយ ថាត់ សាំ ហះកា អ៊ែ ចឹង កើត ឡន័ ម៉ាត់ កា ក្លោ ឡាក់ អ៊ែ ប៉ិច ចៃ លូ កា គន កាម៉ាក័ គន អង់កាន់ ឡាកោ ទៅ ");
INSERT INTO tpu_vpl VALUES ("DT28_57","006_28_57","DEU","28","57","57","ញន កា អូ ទី កាណាគ័ ញ៉ា សា តាឡាម័ អង់កាន់ ណោះ អ៊ែ ចឹង ទី ពុត ប៉ិច អ្យក់ ស៊ក ឡាក់ អង់ក័ះ ឡាច់ ឡឹង វ៉ាច់ អ៊ែ ទៅ ទឹប គន អង់ក័ះ កើត ណោះ ដេល ប៉្រគ័ សាណា សា អន់តុង ដឹង អ៊ែ ខង ផះ រ៉ាំងវ៉ាង មួត តាម៉ឺរ វ៉ិង ទិ មឿង កាណុង ប៉ាថេត អន់ដីស អ្វៃ ណោះ អន់ដីស ចឹង ថុក ឡាំបាក កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","58","«ផា អន់ដីស អូ អ្យក់ ពុត ចៃគ ប៉្រគ័ ពួយ ចាបាប់ ឡាក់ ទី ច្រាគ់ រ៉ះ កាណុង ផាប់ ប៉ានឹរ ប‌៉្រ័ះ អា ភឿ អន់ អន់ដីស អ្យិល កូត័ អ្យូគ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ឡាក់ អំរ៉ាញ អឺញ ឡាក់ ត្រគ់ ញម ");
INSERT INTO tpu_vpl VALUES ("DT28_59","006_28_59","DEU","28","59","59","ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉្រគ័ អន់ អន់ដីស លូ គន សោ អន់ដីស កើត អេះ អោម លូ កើត អីគ ព្លុ យ៉ឹប ក្លាំង យ‌៉័ះ អន់ដីស ចឹង ប៉្រគ័ នីចម័ កា អូ អ្លុ ប៉្រគ័ ដាគ់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉្រគ័ អន់ អីគ ព្លុ អន់ទៀគៗ ឡាក់ កា កើត ពឹង ប៉ាសុន អ៊ីស៊ីប ឡាក់ ប៉្រគ័ អន់ អន់ដីស អ្យូគ ណោះ ពែ ចឹង កើត ពឹង អន់ដីស ដេល។ អីគ ព្លុ ទិណោ័ះ ចឹង អ្វៃ ពឹង អន់ដីស លើយ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉្រគ័ អន់ អីគ ព្លុ ប៉ាញុ រ៉ាំបល់ គ្រឹប នែវ យ‌៉័ះ អូ ទី ច្រាគ់ រ៉ះ កាណុង ផាប់ ចាបាប់ ប‌៉្រ័ះ អា កាតាម ចឹង កើត ពឹង អន់ដីស លើយ ទឹល អន់ដីស តោ័។ ");
INSERT INTO tpu_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","យ‌៉័ះ អន់ដីស ទី ចំលួន អៀង ឡាក់ កា សំឡង់ ពឹង ប៉្លៃង កាតាម កា ចឹង កើត សុនសាត ប៊ែត ឡគ ខង អន់ដីស អូ សាំយ៉ាំង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាញ័ ពុត ប៉្រគ័ អន់ អន់ដីស កើត ចំលួន អៀង នីចម័ អ៊ែ កា ប៉ាញ័ ពុត ចឹង ថាំឡាយ លូ ពីត អន់ដីស អន់ រ៉ុង រ៉ាយ នីណោ័ះ ដេល។ អ៊ែ ចឹង អ្យក់ ឡាច់ អន់ដីស ឡឹង ប៉ាថេត ឡាក់ អន់ដីស ម៉ុត អ្វៃ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","«ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង តាគ់ តាប៉្រះ តាប៉្រោង អន់ដីស អន់ អ្វៃ ប៉ាគ់ សុនសាត អន់ទៀគៗ ឡឹង ឡាណុច ប៉្លៃង ម៉ោញ ប៊ែង ទឹល ឡាណុច ប៉្លៃង ម៉ោញ ប៊ែង ណាវ្គ។ អ្វៃ ប៉ាគ់ ណោះ អន់ដីស ចឹង សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ សុនសាត អន់ទៀគ ឡាក់ អន់ដីស លូ វគ័ យ៉ាគ់ អន់ដីស អូ អន់ហ្នាល់ ឡាក់ ប‌៉្រ័ះ ពូ ប៉្រគ័ លូ អ៊្លង លូ អំហ្មោ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","អ្វៃ អន់ឌូ លូ សុនសាត អន់ទៀគ ណោះ អន់ដីស ចឹង អូ ទី សារ សាណុក សាវ៉ាក អុះ ជុង អន់ដីស កា អូ អ្លុ រ៉ាឡូវ ដេល។ អ្វៃ ហះ ចារ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉្រគ័ អន់ ពុត អន់ដីស អ្យូគ រ៉ារ៉ៃត លូ ប៉្រគ័ អន់ អន់ដីស ទិ សារ ម៉ឹង ទឹប ប៉្រគ័ អន់ ម៉ាត់ អន់ដីស ព្រឹងៗ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","អាញុ អន់ដីស ពៀប ឡាក់ កា ព្រៀយ ដឹង ម៉ោញ តាំងហារ័ អន់ដីស ចឹង អ្យូគ ទឹប កាម៉ាំង ទឹប កាដារ់ អាញុ អន់ដីស កា អូ ម៉ឹង ចឹង រ៉ីស ណាវ្គ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","សារ ឡាក់ ម៉ាត់ អន់ដីស ទៅ ចឹង ប៉ប័ ចឹង ប៉្រគ័ អន់ អន់ដីស អ្យូគ។ ផះ កាំលឺ អន់ដីស ចឹង កាប ផា \"ញ៉ា ត្រគ់ ក្រូ ម៉ាំង\" ផះ កាម៉ាំង ចឹង កាប ផា \"ញ៉ា ត្រគ់ ក្រូ តារ\"។ ");
INSERT INTO tpu_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉ាទុក អន់ដីស លូ កាំប៉ាន់ ប៉ាណាំ អន់ដីស សឹត ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ណាវ្គ អន់ដីស ចឹង សឹត ប៉ាគ់ ប៉ាថេត ឡាក់ អាញ់ រ៉ះ កា អន់ដីស ពែ ផា អន់ដីស ចឹង អូ ទី ប៉ប័ ប៉ាថេត ណោះ ណាវ្គ ហង។ អ្វៃ ពឹង ប៉ាថេត ណោះ អន់ដីស ចឹង ខំ ប្រូ ឡាកោ អន់ កា មួត តាម៉ឺរ ភឿ អ្យក់ ប៉្រគ័ ទុច កាម៉ាក័ ទុច អង់កាន់ ហះកា អូ ទី ពឿ តាច់ អន់ដីស អុះ»។ … ");
INSERT INTO tpu_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","«ផា ដារ់ ចំ សារ ទិ អា កើត ពឹង អន់ដីស ទឹប សារ ដាគ់ ទឹប សារ ប៉ាស្យាប ឡាក់ អាញ់ រ៉ះ កា អន់ដីស អា ផះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស តាំងហ្យិត ឡាច់ អន់ដីស អន់ ឡាំ អ្វៃ ពឹង អន់តិគ័ សុនសាត អន់ទៀគ ផះ ណោះ អន់ដីស ចឹង កាចាំង ឡឹង សារ ទិណោ័ះ កាណុង ពុត។ ");
INSERT INTO tpu_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","ផា អន់ដីស វ៉ីល ប៉ាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ទឹប គន ទឹប សោ កេះណោះ ប៉ាណាំ គួប រ៉ាប់ សឿ ប៉ានឹរ ប‌៉្រ័ះ ទិ ពុត ទិ ពៀក ត្រគ់ ពួយ ទិ សារ អាញ់ រ៉ះ កា អន់ដីស កាណុង ដារ់ អា ");
INSERT INTO tpu_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អ៊ែ ចឹង តាប៉ាប តាប៉ុន កា អន់ដីស លូ អ្យក់ អន់ដីស ឡាច់ ឡឹង កេះ ទុច ពូ កេះណោះ ប៉ាតុំ អ្យក់ សឹត អន់ដីស ឡឹង សុនសាត អន់ទៀគ ឡាក់ អ៊ែ តាំងហ្យិត ឡាច់ អន់ដីស អន់ ឡាំ អ្វៃ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","យ‌៉័ះ ពូ គៀរ អន់ដីស ឡាំ ទឹល ឡាណុច ប៉្លៃង កាតាម កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អ៊ែ ចឹង ឡាំ ប៉ាតុំ អន់ដីស អ្យក់ សឹត ណាវ្គ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អ៊ែ ចឹង ប៉ាណាំ អន់ដីស សឹត អ្យក់ ប៉ាថេត ឡាក់ វគ័ យ៉ាគ់ អន់ដីស រ៉ាំងហៃ ផះ អន់ទ្រួល ពែ។ កេះណោះ អ៊ែ ចឹង អន់ អន់ដីស ទី សារ ហោក រ៉គ់ លូ អន់ កើត ទី ចំលួន អៀង ក្វា ឡឹង វគ័ យ៉ាគ់ អន់ដីស ពែ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អ៊ែ ចឹង ប៉ាណាំ អន់ដីស លូ ផូង័ វ៉ាច់ អន់ដីស អន់ មប ពុត ពៀក សឿ អ៊ែ ភឿ អន់ អន់ដីស ប៉ិច កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អន់ ទិ ពុត ទិ ពៀក ម៉ាគ់ អន់ដីស ចឹង ទី អាញុ រ៉ីស។ ");
INSERT INTO tpu_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អ៊ែ ចឹង ប៉្រគ័ អន់ សារ អ៊ែ ប៉ាស្យាប អន់ដីស ទិណោ័ះ អន់ ត្រគ់ មួត តាម៉ឺរ ឡាក់ ប៉្រគ័ បាប អន់ដីស ពែ។ ");
INSERT INTO tpu_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","អន់ដីស កា ចឹង សាំយ៉ាំង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ណាវ្គ ទឹប ប៉្រគ័ ពួយ គ្រឹប សារ អ៊ែ ប៉្រើ ឡាក់ កា អាញ់ រ៉ះ កាណុង ដារ់ អា។ ");
INSERT INTO tpu_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អ៊ែ ចឹង ប៉្រគ័ អន់ គ្រឹប ង៉ារ ឡាក់ អន់ដីស ប៉្រគ័ កើត អៀង។ អ៊ែ ចឹង ប៉្រគ័ អន់ អន់ដីស ទី គន សោ អៀង តាប៉ល់ ចៀម លូ រ៉ក់ អន់ដីស កា ចឹង កើត ចំលួន អៀង តេះ អន់ដីស កា ចឹង កើត សាណា អៀង ដេល ខង ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាញ័ ពុត ប៉្រគ័ អន់ អន់ដីស សាណុក សាវ៉ាក ឡាក់ កា វគ័ យ៉ាគ់ អន់ដីស ពែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","សារ អា ចឹង កើត ពឹះ ផះ ដារ់ ចំ អន់ដីស សាំយ៉ាំង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស លូ ប៉្រគ័ ពួយ គ្រឹប សារ អ៊ែ ប៉្រើ ឡាក់ ច្រាគ់ រ៉ះ កាណុង ផាប់ ចាបាប់ ប‌៉្រ័ះ អា ឃឺ ផះ ដារ់ ចំ អន់ដីស វ៉ីល ប៉ាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ទិ ពុត ទិ ពៀក។ ");
INSERT INTO tpu_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","«សារ ឡាក់ អាញ់ រ៉ះ កា អន់ដីស កាណុង ដារ់ អា អូ ផូត តាឡាម័ ឡាក់ អន់ដីស ចឹង អូ អ្លុ ប៉្រគ័ ពួយ ណោះ អុះ លូ អូ អ្វៃ ចាំងហាយ្គ ឡឹង អន់ដីស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","សារ អា អូ ត្រគ់ អ្វៃ ពឹង ប៉្លៃង អុះ បះ ចឹង ប៉្រគ័ អន់ អន់ដីស កាប ផា \"ពឿ ចឹង ហាវ ពឹង ប៉្លៃង អ្យក់ ប៉ានឹរ ប‌៉្រ័ះ រ៉ះ កា ញឹន ម៉ាគ់ ញឹន ចឹង ប៉្រគ័ ពួយ ?\" ");
INSERT INTO tpu_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","សារ អា កា អូ ត្រគ់ អ្វៃ ហាង តោ ទៀក សាឡីគ សាឡាយ ដេល បះ ចឹង ប៉្រគ័ អន់ អន់ដីស កាប ផា \"ពឿ ចឹង ឃ្លង ទៀក សាឡីគ សាឡាយ ហាង តោ អ្យក់ ប៉ានឹរ ប‌៉្រ័ះ រ៉ះ កា ញឹន ម៉ាគ់ ញឹន ចឹង ប៉្រគ័ ពួយ ?\" ");
INSERT INTO tpu_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","ហះកា ប៉ានឹរ ប‌៉្រ័ះ អា អ្វៃ ហះ សានែង អន់ដីស អ្វៃ កាណុង ពឹរ អន់ដីស លូ អ្វៃ ពឹង ពុត អន់ដីស ភឿ អន់ អន់ដីស អ្លុ ប៉្រគ័ ពួយ។ ");
INSERT INTO tpu_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","«ហៃ ដារ់ អា អាញ់ អន់ អន់ដីស រ៉ើស សារ រ៉ីស ញ៉ា សារ តោ័ សារ ដាគ់ ញ៉ា សារ អ៊ក សារ ចំ អន់ដីស ចឹង អ្យក់។ ");
INSERT INTO tpu_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","អាញ់ ប៉្រើ អន់ដីស កាណុង ដារ់ អា អន់ អន់ដីស ប៉ិច កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ទឹប អ្វៃ កោប អន់ ដាគ់ ពួយ អ៊ែ ទឹប ប៉្រគ័ ពួយ ទិ ចាបាប់ អ៊ែ លូ សារ អន់តគ់ ប៉ាតោ ប៉្រោ ទឹប ប៉្រគ័ នីអៀ អន់ដីស ចឹង ទី អាញុ អ្វៃ រ៉ីស លូ ចឹង កើត ទី ចំលួន អៀង កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ចឹង អន់ សារ ដាគ់ កា អន់ដីស កាណុង ប៉ាថេត ឡាក់ អន់ដីស ចឹង ម៉ុត អ្យក់ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","ហះកា ផា អន់ដីស អ្លាត សឿ អ៊ែ លូ អូ ចៃ សាំយ៉ាំង ប៉ានឹរ អ៊ែ ទឹប មប ឡាកោ ឡាំ សឿ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ អន់ទៀគ ");
INSERT INTO tpu_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","អាញ់ រ៉ះ កា អន់ដីស កាណុង ដារ់ អា អន់ អ្លុ អន់តគ់ ផា អន់ដីស ចឹង តោ័ រ៉ាយ តោ័ រ៉ុង តាទឹច ហង ឃឺ អន់ដីស ចឹង អូ ទី អាញុ អ្វៃ រ៉ីស ទុញ អ្វៃ ពឹង ប៉ាថេត ឡាក់ អន់ដីស ឃ្លង ទៀក ទ្រូង យដាន់ ចឹង ម៉ុត អ្យក់ ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","ហៃ ដារ់ អា អាញ់ អើ តេះ អើ ប៉្លៃង ប៉្រគ័ ផាញ៉ាន ហៃ អន់ដីស ឃឺ អាញ់ អន់ អន់ដីស រ៉ើស អ្យក់ អាញុ អ្វៃ រ៉ីស លើ សារ តោ័ សារ ដាគ់ លើ សារ ប៉ាស្យាប។ ហគ់ រ៉ើស អ្យក់ អាញុ រ៉ីស ពិ ភឿ អន់ អន់ដីស លូ ផូង័ វ៉ាច់ អន់ដីស អ្វៃ រ៉ីស។ ");
INSERT INTO tpu_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","ហគ់ ប៉ិច កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ហគ់ សាំយ៉ាំង ប៉ានឹរ អ៊ែ លូ ម៉ឹង អ៊ែ ពិ ខង អ៊ែ ហង ឡាក់ តាំងឡា អាញុ អន់ដីស ឡាក់ អន់ អន់ដីស អ្វៃ រ៉ីស ទុញ លូ អន់ អន់ដីស អ្វៃ ពឹង ប៉ាថេត ឡាក់ អ៊ែម៉ត់ ចឹង អន់ កា អាប៉្រាហាំ លូ អ៊ីសាក់ លូ យ៉ាកុប ឡាក់ វគ័ អន់ដីស»។ ");
INSERT INTO tpu_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","វគ័ ម៉ូសេ រ៉ះ សារ ទិ អា កា ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ។ ");
INSERT INTO tpu_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","កេះណោះ អ៊ែ រ៉ះ ណាវ្គ ផា «ដារ់ អា អាញ់ អាញុ ១២០ សាណាំ កេះ អាញ់ អូ អ្លុ ណាំផា អន់ដីស ណាវ្គ អុះ។ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អាញ់ ផា អាញ់ អូ ត្រគ់ ឃ្លង ទៀក ទ្រូង យដាន់ អា ដេល។ ");
INSERT INTO tpu_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អ៊ែ ចឹង ចាក អន់ទ្រួល ប៉ាណាំ ទ្រង អន់ដីស អ៊ែ ចឹង ថាំឡាយ សុនសាត អន់ទៀគ អន់ ឡាច់ ឡឹង ម៉ាត់ អន់ដីស ភឿ អន់ អន់ដីស តាប៉ីត អ្យក់ ប៉ាថេត ណោះ ឡឹង អន់ឌែ។ យូស្វេ អា ចឹង ប៉្រគ័ ម៉ៃគ ណាំផា អន់ដីស ឃ្លង ឡាំ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ។ ");
INSERT INTO tpu_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ថាំឡាយ សុនសាត ទិណោ័ះ ឡាក់ កា អ៊ែ ថាំឡាយ ស៊ីហុន លូ អុក ឡាក់ សាដាច់ សុនសាត អាម៉ូរី លូ ថាំឡាយ ប៉ាថេត អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង មប សុនសាត ទិណោ័ះ ពឹង តី អន់ដីស ទឹល នីណោ័ះ អន់ដីស ត្រគ់ ប៉្រគ័ កា អន់ឌែ ពួយ សារ ឡាក់ អាញ់ ប៉្រើ អន់ដីស កាណុង ដារ់ អា ហង ពិ។ ");
INSERT INTO tpu_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","ទឹល នីណោ័ះ ហគ់ ទី ពុត ខឹន ជែ អ្យូគ ជែ កាខរ់ ណូស កា អន់ឌែ ណោះ ខង ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អ៊ែ ចឹង ឡាំ អន់ឌូ លូ អន់ដីស អ៊ែ អូ អ្លាត អន់ដីស អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","វគ័ ម៉ូសេ អើ យូស្វេ ពឹះ កេះណោះ រ៉ះ កា អ៊ែ ហះ ម៉ាត់ ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ ផា «ហគ់ ទី ពុត ខឹន ខង អីស ចឹង ប៉ាណាំ មួត ប៉ាសុន អា ម៉ុត ពឹង ប៉ាថេត ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ម៉ត់ លូ វគ័ យ៉ាគ់ ពិន ផា ចឹង អន់ កា អន់ឌែ។ អីស ត្រគ់ អ្យក់ ព្រី ទៀក ណោះ ជែក អន់ កា អន់ឌែ ឡាក់ កា ប៉ាដក់ ប៉ាជៀ។ ");
INSERT INTO tpu_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ចាក អន់ទ្រួល ប៉ាគ់ ម៉ាត់ អីស អ៊ែ ចឹង អ្វៃ អន់ឌូ លូ អីស អ៊ែ អូ អ្លាត អីស អុះ។ ទឹល នីណោ័ះ ជែ អ្យូគ ជែ កាខរ់ ណូស ដៃ»។ ");
INSERT INTO tpu_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","វគ័ ម៉ូសេ កា ច្រាគ់ ចាបាប់ អា មប អន់ កា មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ឃឺ គន សោ វគ័ លេវី ឡាក់ មួត តូង័ ហ៊ីប សារ សាញ៉ា រែវ ពុត ម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័  អ៊ែ កា មប អន់ កា មួត ក្រាគ់ តាំងកង់ សុនសាត អ៊ីស្រាអ៊ែល ទិឌូ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","អ៊ែ រ៉ះ កា អន់ឌែ ផា «តាំប៉ើះ សាណាំ ម៉ោញ ទង ឃឺ ទឹល សាណាំ ឡាក់ ត្រគ់ អ្លាត ដោះ សារ ពូ ទួម ផះ រ៉ាំងវ៉ាង ប៊ុន រ៉ាណើះ ");
INSERT INTO tpu_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","ផះ មួត ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ ប៉ាណាំ គួប សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ហះ ចារ ឡាក់ អ៊ែ ចឹង រ៉ើស អន់ដីស ត្រគ់ អាន ចាបាប់ អា ហះ ម៉ាត់ សុនសាត អ៊ីស្រាអ៊ែល ទិឌូ ភឿ អន់ អន់ឌែ កាតាំង ដេល។ ");
INSERT INTO tpu_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","ត្រគ់ ប៉ាតុំ មួត ប៉ាសុន ទឹប កាម៉ាក័ ទឹប អង់កាន់ លូ មួត សាស្វា ទឹប សុនសាត អន់ទៀគ ឡាក់ អ្វៃ កាណុង មឿង អន់ដីស ទិណោ័ះ ភឿ អន់ អន់ឌែ សាំយ៉ាំង ម៉ាគ់ ចឹង អ្លុ អ្យិល កូត័ អ្យូគ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ទឹប អ្យក់ ពុត ចៃគ ប៉្រគ័ ពួយ ទិ សារ កាណុង ចាបាប់ អា។ ");
INSERT INTO tpu_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","កាប៉ាច់ គន សោ អន់ឌែ ឡាក់ អូ អន់ហ្នាល់ ចាបាប់ អា កា ចឹង កាតាំង ដេល កេះណោះ ហៀន អ្យិល កូត័ អ្យូគ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ផះ អន់ដីស អ្វៃ ពឹង ប៉ាថេត ឡាក់ អន់ដីស ត្រគ់ ឃ្លង ទៀក ទ្រូង យដាន់ ម៉ុត អ្យក់ ណោះ»។ … ");
INSERT INTO tpu_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","វគ័ ម៉ូសេ ឡាច់ ឡឹង ស៊្រែ តាប៉ង់ ប៉ាថេត ម៉ូអាប់ ឡាំ ប៉ាគ់ ប៉ានឹម នេបូ ហាវ ពឹង កល់ ប៉ានឹម ឡាក់ ពូ អើ ផា ពិសាកា ត្រង់ មឿង យេរីខូ។ កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ តាំបាង អន់ អ៊ែ ប៉ប័ ព្រី ទៀក ឃឺ ព្រី ប៉ានឹម កាឡាត លើយ ទឹល មឿង ដាន់ ");
INSERT INTO tpu_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","ទឹប ព្រី ទៀក ណាប់ថាលី ទិណោ័ះ ព្រី ទៀក អេប៉្រាអ៊ីម ព្រី ទៀក ម៉ាណាសេ លូ ព្រី ទៀក យូដា ទិណោ័ះ លើយ ទឹល សាឡីគ សាឡាយ គែង ដារ់ ម៉ុត ");
INSERT INTO tpu_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","ទឹប ព្រី ស៊្រែ ណេកិប លូ ចារ រទៀក ទ្រូង យដាន់ ទឹប មឿង យេរីខូ ឡាក់ ពូ អើ ផា មឿង តើម រ៉ាសៃ លើយ ទឹល ស្រុក សូអា។ ");
INSERT INTO tpu_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ផា «ប៉ាថេត អា ហង អាញ់ ម៉ត់ លូ អាប៉្រាហាំ អ៊ីសាក់ លូ យ៉ាកុប ផា ចឹង មប អន់ កា ផូង័ វ៉ាច់ អន់ឌែ។ អាញ់ តាំបាង អន់ ម៉ាត់ អីស ទៅ ប៉ប័ ប៉ាថេត អា ហះកា អីស អូ ទី ម៉ុត អ្វៃ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","វគ័ ម៉ូសេ ឡាក់ ប៉ាណូស ប៉្រគ័ ង៉ារ កា ប‌៉្រ័ះ ប៊កកាតយ័  អ៊ែ កា តោ័ ហះ ចារ ណោះ ឃឺ កាណុង ប៉ាថេត ម៉ូអាប់ ត្រគ់ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","ប‌៉្រ័ះ ប៊កកាតយ័ តប់ ប៉ាទ្រូ អ៊ែ ពឹង ក្លូះ ប៉ានឹម ពឹង ប៉ាថេត ម៉ូអាប់ ត្រង់ មឿង បេតពេអរ ហះកា អូ ទី ពឿ អ្លុ អន់ហ្នាល់ ចារ តប់ អ៊ែ អុះ លើយ ទឹល រ៉ប់ ដារ់ អា។ ");
INSERT INTO tpu_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","ផះ រ៉ាំងវ៉ាង វគ័ ម៉ូសេ តោ័ ណោះ អ៊ែ អាញុ ១២០ សាណាំ កេះ ហះកា ម៉ាត់ អូ ម៉ាម៉ាំង អុះ ឡាកោ អ៊ែ កា អ្វៃ ទី សាងុំ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","សុនសាត អ៊ីស្រាអ៊ែល ប៉ាណាំ គួប អ្វៃ ញ៉ាំ សោក រ៉ាំបីស កា វគ័ ម៉ូសេ ទុញ ៣០ ដារ់ អ្វៃ ហះ ស៊្រែ តាប៉ង់ ប៉ាថេត ម៉ូអាប់។ ");
INSERT INTO tpu_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","កាប៉ាច់ យូស្វេ គន វគ័ នូន អ៊ែ ទី ពុត ហ្យាំង សាឡាច់ ខង វគ័ ម៉ូសេ ម៉ន់ សាប៉ាគ់ អ៊ែ។ ទឹល នីណោ័ះ សុនសាត អ៊ីស្រាអ៊ែល ប៉ាណាំ គួប រ៉ាប់ សឿ យូស្វេ ទឹប ប៉្រគ័ ពួយ សារ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ ម៉ូសេ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","កាណុង សុនសាត អ៊ីស្រាអ៊ែល អូ ឃើយ ទី រ៉ាគឹយ ប‌៉្រ័ះ អ៊ែ ចំ ឡាក់ កា វគ័ ម៉ូសេ អា អុះ ឡាក់ ទី ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ សារ ហះ ង៉ីរ អ៊ែ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","កា អូ ទី ពឿ ឡាក់ កា វគ័ ម៉ូសេ ឡាក់ ទី តាំបាង សារ អំរ៉ាញ អឺញ កេង ខាក់ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អ៊ែ តាំបាង ពឹង ប៉ាថេត អ៊ីស៊ីប ប៉ាសាំង លូ សាដាច់ អ៊ីស៊ីប ទឹប ប៉ាសាំង លូ មួត ប៉្រគ័ កាន កា សាដាច់ ទឹប ប៉ាសុន អ៊ីស៊ីប ទិឌូ។ ");
INSERT INTO tpu_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","កា អូ ទី ពឿ អ្លុ តាំបាង សារ អំរ៉ាញ អឺញ កេង ខាក់ ឡាក់ ត្រគ់ អ្យូគ ត្រគ់ ញម ហះ ង៉ីរ សុនសាត អ៊ីស្រាអ៊ែល ទិឌូ ឡាក់ កា វគ័ ម៉ូសេ អា ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","ឡៃង ឡឹង វគ័ ម៉ូសេ តោ័ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ លូ គន វគ័ នូន សិច យូស្វេ ឡាក់ ប៉ាណូស តង័ ប៉្រគ័ ង៉ារ កា វគ័ ម៉ូសេ ណោះ ផា ");
INSERT INTO tpu_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","«ម៉ូសេ ឡាក់ ទុច អាញ់ អ៊ែ តោ័ កេះ កិញអៀ អា ហគ់ អីស ប៉ាណាំ មួត ប៉ាសុន អ៊ីស្រាអ៊ែល ឃ្លង ទ្រូង ទៀក យដាន់ ម៉ុត ពឹង ប៉ាថេត ឡាក់ អាញ់ ចឹង មប អន់ កា អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","អន់ដីស យ៉ាក ជុង ឡាំ ប៉ាគ់ ចារ ចំ អាញ់ ចឹង មប ចារ ណោះ កា អន់ដីស ឡូត ឡាក់ កា អាញ់ សាញ៉ា លូ ម៉ូសេ ពែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","គួយ តេះ អន់ដីស ណោះ តីស កាខាក់ អ្យក់ ឡឹង ស៊្រែ តីស អន់ ឡាំ លើយ ទឹល ប៉ាគ់ ប៉ានឹម ឡេបាណូន លូ អ្យក់ ឡឹង តាំងលេ អឺប៉្រាត អន់ ឡាំ លើយ ទឹល ប៉ាគ់ សាឡីគ សាឡាយ មេឌីតេរ៉ានេ គែង ដារ់ ម៉ុត ឃឺ តេះ មួត សុនសាត ហេត ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","អូ ទី បក់ ពឿ ចឹង ដាម័ តាកូះ លូ អីស អុះ ខង អាញ់ ចឹង អ្វៃ អន់ឌូ លូ អីស ឡុច អាញុ អីស ឡាក់ កា អាញ់ អ្វៃ អន់ឌូ លូ ម៉ូសេ ពែ ដេល អាញ់ អូ អ្លាត អីស អុះ។ ");
INSERT INTO tpu_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","ហគ់ អន់ អីស ទី ពុត ខឹន ខង អីស ត្រគ់ ប៉ាណាំ ប៉ាសុន អា ម៉ុត កាណុង ប៉ាថេត ឡាក់ អាញ់ ចឹង អន់ កា អន់ឌែ ប៉្រគ័ ប៉ាដក់ ប៉ាជៀ ឡាក់ អាញ់ ម៉ត់ លូ វគ័ យ៉ាគ់ អន់ឌែ សើគ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","ទឹល នីណោ័ះ ហគ់ អន់ ខឹន កាខាក់ ពិ ទឹប អ្យក់ ពុត ចៃគ ប៉្រគ័ ពួយ ចាបាប់ ទិណោ័ះ ឡាក់ ម៉ូសេ ប៉្រើ អីស ប៉្រគ័ ពួយ អូ អន់ យច ឡឹង ចាបាប់ អ៊ែ រ៉ះ ណោះ អុះ ម៉ាគ់ គ្រឹប ង៉ារ ញ៉ា ឡាក់ អីស ប៉្រគ័ ចឹង កើត ហង។ ");
INSERT INTO tpu_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","អីស ត្រគ់ អាន ផាប់ ចាបាប់ អន់ កា ពូ លើយៗ អូ អ្លាត អុះ។ អីស ត្រគ់ កាចាំង ទឹប កាម៉ាំង ទឹប កាដារ់។ ផា អីស ប៉្រគ័ ពួយ ទិ សារ ញ៉ា ឡាក់ ទី ច្រាគ់ កាណុង ផាប់ ចាបាប់ ប‌៉្រ័ះ គ្រឹប ង៉ារ ញ៉ា ឡាក់ អីស ប៉្រគ័ ចឹង ដាគ់ ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","អាញ់ រ៉ះ កា អីស កេះ ផា \"អ្យគ័ ខឹន ពិ លូ ជែ អ្យូគ ជែ ហ្យឹក កា ញ៉ា\" ខង អាញ់ ឡាក់ ប‌៉្រ័ះ អីស ចឹង អ្វៃ អន់ឌូ លូ អីស គ្រឹប ចារ ឡាក់ អីស ឡាំ»។ ");
INSERT INTO tpu_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","កេះណោះ យូស្វេ ប៉្រើ មួត ម៉ៃគ ណាំផា ");
INSERT INTO tpu_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","«ហគ់ អន់ដីស ចាក គ្រឹប រ៉ាណើះ រ៉ះ កា ប៉ាសុន ផា \"ហគ់ រ៉ាន់ដាប់ សាប្យាំង រ៉ាំងតយ័ ពិ ខង អ្វៃ ប៉ៃង ដារ់ ណាវ្គ អន់ដីស ចឹង ឃ្លង ទៀក ទ្រូង យដាន់ ហង ម៉ាគ់ ឡាំ រ៉ុប អ្យក់ តេះ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង អន់ កា អន់ដីស ណោះ\"»។ ");
INSERT INTO tpu_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","កេះណោះ យូស្វេ រ៉ះ លូ ផូង័ រូបេន លូ ផូង័ កាត លូ ផូង័ ម៉ាណាសេ ឡាក់ ពូ កះ អ្យក់ ទងតិគ័ ណោះ ផា ");
INSERT INTO tpu_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","«ហគ់ កាចាំង ឡឹង ប៉ានឹរ វគ័ ម៉ូសេ ឡាក់ ទុច ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ រ៉ះ កា អន់ដីស ពែ ផា \"ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស អន់ តេះ អា កា អន់ដីស កេះ ម៉ាគ់ អ្វៃ សាណុក សាវ៉ាក\"។ ");
INSERT INTO tpu_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","គន កាម៉ាញ់ លូ កាណាគ័ អន់ដីស រង កា ចឹង អ្វៃ ពឹង តេះ ឡាក់ វគ័ ម៉ូសេ មប អន់ កា អន់ដីស អ្វៃ គែង អា ទៀក ទ្រូង យដាន់ អា ហង។ ហះកា អន់ដីស អា ឡាក់ តាហាន អ្លុ តាកូះ កេង ខាក់ ត្រគ់ ចឹក ដាវ ចឹក តាប៉ាក័ ចាក អន់ទ្រួល មួត អុះ ម៉ី អន់ដីស ម៉ាគ់ តង័ អន់ឌែ ");
INSERT INTO tpu_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","លើយ ទឹល ប‌៉្រ័ះ ប៊កកាតយ័ អន់ កា មួត អុះ ម៉ី អន់ដីស អ្វៃ សាណុក សាវ៉ាក ឡាក់ កា អន់ដីស ដេល ទឹប រ៉ុប អ្យក់ តេះ ឡាក់ ចារ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ចឹង អន់ កា អន់ឌែ។ កេះណោះ អន់ដីស ត្រគ់ វ៉ីល សឹត រ៉ាំងហៃ តេះ ឡាក់ វគ័ ម៉ូសេ មប អន់ កា អន់ដីស គែង អា ទ្រូង យដាន់ អា ហង»។ ");
INSERT INTO tpu_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","អន់ឌែ តើល ប៉ានឹរ យូស្វេ ផា «ញឹន ចឹង ប៉្រគ័ ពួយ ប៉ានឹរ អីស ទិ សារ ញ៉ា ឡាក់ អីស រ៉ះ យ‌៉័ះ អីស ប៉្រើ ញឹន ឡាំ ប៉ាគ់ ចំ កាតាម ញឹន ចឹង ឡាំ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","ញឹន ចឹង ប៉្រគ័ ពួយ ប៉ានឹរ អីស ឡាក់ កា ញឹន ប៉្រគ័ ពួយ ប៉ានឹរ វគ័ ម៉ូសេ ពែ ដេល។ អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ អន់ឌូ លូ អីស ឡាក់ កា អ៊ែ អ្វៃ អន់ឌូ លូ វគ័ ម៉ូសេ ពែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","ផា ទី បក់ ពឿ កាណុង កាំឡាំង ញឹន អា អូ ប៉្រគ័ ពួយ ប៉ានឹរ អីស លើ ប៉ាសាំង លូ ប៉ានឹរ អីស បក់ ណោះ ត្រគ់ ថូត ប៉ាន់តោ័ អ៊ែ ឡូត។ ហះកា កាប៉ាច់ អីស អន់ អីស ទី ពុត ខឹន ពិ»។ … ");
INSERT INTO tpu_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","ប៉ាគ់ ដារ់ តាយ៉ាង័ យូស្វេ អ្យូវ ឡឹង កាំលឺ ផុងម៉ាំង ចាក ឡាច់ ឡឹង ព្រី ស៊ីទីម អន់ឌូ លូ មួត សុនសាត អ៊ីស្រាអ៊ែល។ ប៉ាគ់ ក្យាម័ ចឹង ទឹល ទ្រូង យដាន់ កេះ អន់ឌែ អ្វៃ រ៉ាឡូវ ហះ ណោះ ហិ អន់ទ្រួល ចឹង ឃ្លង ប៉ាគ់ ហាង តោ។ ");
INSERT INTO tpu_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","ប៉ៃង ដារ់ ឡឹង ណោះ មួត ម៉ៃគ ណាំផា ចាក រ៉ប់ រ៉ាណើះ ");
INSERT INTO tpu_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","ទឹប អន់តគ់ រ៉ះ កា ប៉ាសុន ផា «ប៉ាគ់ អន់ដីស ប៉ប័ មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ តូង័ ហ៊ីប សារ សាញ៉ា រែវ ពុត  អន់ដីស ត្រគ់ ឡាច់ ឡឹង អា ចាក ពួយ អន់ឌែ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","មួត តូង័ ហ៊ីប ណោះ ចឹង ប៉ាណាំ ទ្រង អន់ដីស ចាក ខង អន់ដីស អូ ឃើយ ចាក ទ្រង ណោះ ហះកា ត្រគ់ ចាក ចាំងហាយ្គ ឡឹង ហ៊ីប ២០០០ ហាត់»។ ");
INSERT INTO tpu_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","កេះណោះ យូស្វេ រ៉ះ កា មួត ប៉ាសុន ផា «ហគ់ ប៉្រគ័ អន់ ឡាកោ ដាគ់ សាំរ៉ាប់ ប‌៉្រ័ះ ប៊កកាតយ័  ខង ប៉ាគ់ តាយ៉ាង័ ទៀ អ៊ែ ចឹង តាំបាង សារ អំរ៉ាញ អឺញ ហះ ម៉ាត់ អន់ដីស»។ ");
INSERT INTO tpu_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","កេះណោះ យូស្វេ រ៉ះ កា មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ផា «ហគ់ អន់ដីស តូង័ ហ៊ីប សារ សាញ៉ា រែវ ពុត ចាក ឡាំ អន់ទ្រួល ឡឹង មួត ប៉ាសុន»។ អន់ឌែ កា តូង័ ឡាំ អន់ទ្រួល ប៉ាសុន តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា យូស្វេ ផា «ដារ់ អា អាញ់ ចឹង អន់ សារ អំរ៉ាញ អឺញ កា អីស ហះ ម៉ាត់ ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ ម៉ាគ់ អន់ឌែ ចឹង អ្លុ អន់តគ់ ផា អាញ់ អ្វៃ អន់ឌូ លូ អីស ឡាក់ កា អាញ់ អ្វៃ អន់ឌូ លូ ម៉ូសេ ពែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","ហគ់ អីស រ៉ះ កា មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ឡាក់ តូង័ ហ៊ីប សារ សាញ៉ា រែវ ពុត ណោះ ផា \"ប៉ាគ់ អន់ដីស ចាក ទឹល ទ្រូង ទៀក យដាន់ កេះ អន់ដីស ត្រគ់ អ្វៃ តាវ ពឹង ទៀក ណោះ ហង\"»។ ");
INSERT INTO tpu_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","កេះណោះ យូស្វេ ឡាំ រ៉ះ កា មួត ប៉ាសុន ផា «ចុ អន់ដីស ឡាំ ប៉ាគ់ អា ម៉ាគ់ សាំយ៉ាំង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស»។ ");
INSERT INTO tpu_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","យូស្វេ រ៉ះ ណាវ្គ ផា «អន់ដីស ចឹង ប៉ប័ សារ កេង ខាក់ ឡាក់ ចឹង ប៉្រគ័ អន់ អន់ដីស អ្លុ អន់តគ់ ផា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ទី អាញុ រ៉ីស អ្វៃ អន់ឌូ លូ អន់ដីស អ៊ែ ចឹង តាំងហ្យិត ឡាច់ សុនសាត កាណាន សុនសាត ហេត សុនសាត ហេវី សុនសាត ពែរិស៊ីត សុនសាត គើកាស៊ី សុនសាត អាម៉ូរី លូ សុនសាត យេប៊ូស ឡាច់ ឡឹង ម៉ាត់ អន់ដីស ឡូត។ … ");
INSERT INTO tpu_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","ផះ មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ តូង័ ហ៊ីប សារ សាញ៉ា រែវ ពុត ម៉ះ ប‌៉្រ័ះ ឡាក់ តាំងឡា អង់កក់ តេះ ប៉ាគ់ អន់ឌែ យ៉ាក ជុង ចគ័ ពឹង ទៀក យដាន់ ណោះ ទៀក ចឹង អូ ហូរ័ ឡូត អ្វៃ ដឹង ម៉ោញ ចារ»។ ");
INSERT INTO tpu_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","15","ផះ ណោះ ត្រគ់ ផះ ថុន កាច់ ទៀក យដាន់ តីស ប៉ាញ័ ហាង ក្រាក់។ ផះ មួត ប៉ាសុន ប៉ាណាំ គួប ចាក ឡាច់ ឡឹង រ៉ាណើះ ចឹង ឃ្លង ទ្រូង ទៀក យដាន់ មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ តូង័ ហ៊ីប សារ សាញ៉ា រែវ ពុត ចាក អន់ទ្រួល ប៉ាគ់ ម៉ាត់ មួត ប៉ាសុន។ ប៉ាគ់ អន់ឌែ ចាក ទឹល ប៉ាគ់ ទ្រូង យដាន់ ផះ អន់ឌែ យ៉ាក ជុង ចគ័ ពឹង ទៀក ហះ ហាង ");
INSERT INTO tpu_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","ទៀក បក់ ហូរ័ ឡឹង អំប៉ាំង កា អូ ហូរ័ ហង អ្វៃ ម៉ោញ ចារ វ៉ៃលៗ ទៀក ណោះ អ្វៃ ប៉ាគ់ តេះ អាដាំ ក្យាម័ តេះ សារ៉ាថាន ចាំងហាយ្គ ឡឹង ចារ អន់ឌែ អ្វៃ។ ទៀក ឡាក់ ហូរ័ ឡាំ ប៉ាគ់ តាំងលោ័ អារ៉ាបា ឃឺ តាំងលោ័ ប៉្រៃ ណោះ កា ស្វាត់ ឡូត ដេល។ មួត ប៉ាសុន កា ប៉ាណាំ គួប ឃ្លង ទ្រូង ទៀក យដាន់ ចឹង ឡាំ ប៉ាគ់ មឿង យេរីខូ។ ");
INSERT INTO tpu_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","ផះ មួត ប៉ាសុន អ៊ីស្រាអ៊ែល ចាក ពឹង ទ្រូង យដាន់ ឡាក់ ស្វាត់ ណោះ មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ឡាក់ តូង័ ហ៊ីប សារ សាញ៉ា រែវ ពុត អន់ឌែ អ្វៃ ពឹង ទ្រូង ទៀក យដាន់ លើយ ទឹល មួត ប៉ាសុន ឃ្លង រ៉ាវ៉ាច់ ទិ។ … ");
INSERT INTO tpu_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","ផះ ណោះ ពូ កាត្រើគ អំប៉ារ មឿង យេរីខូ ក្លិប ខង ពូ អ្យូគ កា មួត អ៊ីស្រាអ៊ែល។ អូ ទី បក់ ពឿ ម៉ុត ឡាច់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ លូ យូស្វេ ផា «ហៃ អាញ់ មប មឿង យេរីខូ អា អន់ ពឹង តី អីស កេះ ទឹប សាដាច់ ទឹប តាហាន ឡាក់ កេង ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","អីស លូ តាហាន អីស ត្រគ់ ចាក តារ័ ជុំ មឿង យេរីខូ អា ម៉ោញ ដារ់ ម៉ោញ ទង ជុំ។ ត្រគ់ ចាក នីណោ័ះ អន់ ទី ត្រោ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","ត្រគ់ ប៉្រើ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ តាំប៉ើះ ដូវ ចឹក សាណៃង ចាក ប៉ាណាំ មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ តូង័ ហ៊ីប សារ សាញ៉ា រែវ ពុត ។ ប៉ាគ់ ទឹល ដារ់ ទី តាំប៉ើះ កេះ អន់ដីស ត្រគ់ ចាក តារ័ ជុំ មឿង តាំប៉ើះ ទង ជុំ កេះណោះ ប៉្រើ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ខ្លោម សាណៃង។ ");
INSERT INTO tpu_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","ប៉ាគ់ អន់ដីស កាតាំង មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ខ្លោម សាណៃង ទុញៗ អន់ដីស ទិឌូ ត្រគ់ តាំងហើ ម៉ៃៗ ប៉ាន់ទៀយ ចឹង ប៉ាក់ ព្លូក ទិ ហង កេះណោះ តាហាន ត្រគ់ តាឡូះ ម៉ុត កាណុង មឿង ឡូត»។ ");
INSERT INTO tpu_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","យូស្វេ កា អើ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ លូ អន់តគ់ រ៉ះ កា អន់ឌែ ផា «ហគ់ អន់ដីស តូង័ ហ៊ីប សារ សាញ៉ា រែវ ពុត លូ ប៉្រើ កាំឡាំង អន់ដីស តាំប៉ើះ ដូវ ណាវ្គ ចឹក សាណៃង ដូវ ម៉ោញ ៗ ចាក ប៉ាណាំ មួត តូង័ ហ៊ីប សារ សាញ៉ា រែវ ពុត»។ ");
INSERT INTO tpu_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","កេះណោះ អ៊ែ រ៉ះ កា មួត តាហាន ផា «ហគ់ ចាក តារ័ ជុំ មឿង លូ ប៉្រើ តាហាន ចឹក ដាវ ចឹក តាប៉ាក័ អន់ដា ចាក ឡាំ អន់ទ្រួល ប៉ាគ់ ម៉ាត់ មួត តូង័ ហ៊ីប សារ សាញ៉ា រែវ ពុត ម៉ះ ប‌៉្រ័ះ»។ ");
INSERT INTO tpu_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","ប៉ាសុន ទិឌូ កា ភម ប៉្រគ័ ពួយ ប៉ានឹរ យូស្វេ រ៉ះ ណោះ។ មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ តាំប៉ើះ ដូវ ឡាក់ ចឹក សាណៃង ចាក ឡាំ អន់ទ្រួល ទឹប ខ្លោម សាណៃង កេះណោះ មួត តូង័ ហ៊ីប សារ សាញ៉ា រែវ ពុត ចាក ពួយ អន់ឌែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","ទី តាហាន ចឹក ដាវ ចឹក តាប៉ាក័ ម៉ោញ ក្រុំ ឡាំ អន់ទ្រួល គែង ម៉ាត់ មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ឡាក់ ផះ ខ្លោម សាណៃង លើយ ហះកា ទី តាហាន ម៉ោញ ក្រុំ ណាវ្គ ចាក អន់តីគ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","កេះណោះ យូស្វេ អន់តគ់ រ៉ះ កា ប៉ាសុន ផា «អន់ដីស ជែ តាំងហើ លូ ជែ កាកាប អន់ ពូ កាតាំង ប៉ានឹរ អន់ដីស លើយ ទឹល ដារ់ អាញ់ ប៉្រើ អន់ដីស តាំងហើ ផះ ណោះ អន់ដីស តាំងហើ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","យូស្វេ កា ប៉្រើ មួត តូង័ ហ៊ីប សារ សាញ៉ា រែវ ពុត ម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ចាក តារ័ ជុំ មឿង ម៉ោញ ទង ជុំ កេះណោះ អន់ឌែ វ៉ីល សឹត ដំ ប៉ាគ់ រ៉ាណើះ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","ប៉ាគ់ ដារ់ តាយ៉ាង័ យូស្វេ កា អ្យូវ ឡឹង កាំលឺ ផុងម៉ាំង។ មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ កា ប៉ាណាំ គួប តូង័ ហ៊ីប សារ សាញ៉ា រែវ ពុត ម៉ះ ប‌៉្រ័ះ ម៉ោញ ទង ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ តាំប៉ើះ ដូវ បក់ ខ្លោម សាណៃង កា ចាក ឡាំ អន់ទ្រួល កា មួត តូង័ ហ៊ីប ទឹប ខ្លោម អន់ដើរ ចាក អន់ដើរ។ ហះកា ទី តាហាន ចឹក ដាវ ចឹក តាប៉ាក័ ឡាំ អន់ទ្រួល លូ ទី តាហាន ចាក អន់តីគ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","ដារ់ ទី ពៀរ ណោះ អន់ឌែ ចាក តារ័ ជុំ មឿង ម៉ោញ ទង ជុំ និះទៅ ដេល កេះណោះ វ៉ីល សឹត ប៉ាគ់ រ៉ាណើះ ណាវ្គ។ អន់ឌែ ចាក នីណោ័ះ គ្រឹប ត្រោ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","ប៉ាគ់ ទឹល ដារ់ ទី តាំប៉ើះ អន់ឌែ អ្យូវ ឡឹង កាំលឺ ផុងម៉ាំង តារ័ ជុំ មឿង យេរីខូ ឡាក់ កា អន់ឌែ ឃើយ តារ័ ណោះ ហង ហះកា ដារ់ ណោះ អន់ឌែ តារ័ ចំលួន តាំប៉ើះ ទង ជុំ។ ");
INSERT INTO tpu_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","ប៉ាគ់ ចាក គ្រឹប តាំប៉ើះ ទង ជុំ កេះ មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ កា ខ្លោម សាណៃង ផះ ណោះ យូស្វេ ប៉្រើ ប៉ាសុន ផា «ហគ់ តាំងហើ ពិ ខង ប‌៉្រ័ះ ប៊កកាតយ័ មប អន់ កា ពិន កេះ មឿង អា។ ");
INSERT INTO tpu_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","ហគ់ ថាំឡាយ មឿង អា លូ កាណាគ័ ញ៉ាៗ ទិណោ័ះ កាណុង មឿង អា ភឿ មប អន់ កា ប‌៉្រ័ះ ប៊កកាតយ័  ហះកា ត្រគ់ គម ណាង រ៉ាហាប់ ឡាក់ អង់កាន់ ម៉ាលេង លូ កាំឡាំង ហី ក្រាន អ៊ែ អន់ អ្វៃ រ៉ីស ខង អ៊ែ អោន កាម៉ាក័ ពៀរ ដូវ ឡាក់ ឡាំ សឺប កាន ណោះ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","កាប៉ាច់ អន់ដីស ជែ អ្យក់ កាណាគ័ ញ៉ា កា អន់ដីស ទៅ អ្យូគ ផៃគ អន់ដីស តោ័ រ៉ាយ តោ័ រ៉ុង ទឹប ប៉្រគ័ អន់ ប៉ាសុន ទិឌូ តោ័ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","ហះកា កាណាគ័ ពូ ប៉្រគ័ លូ ម៉ាស ប៉្រាក់ សាប៉ាន័ លូ ប៉ាសយ់ ត្រគ់ មប អន់ កា ប‌៉្រ័ះ ត្រគ់ អ្យក់ កាណាគ័ ទិណោ័ះ ឡាំ អន់ ប៉ាគ់ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ»។ ");
INSERT INTO tpu_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","ប៉ាសុន កា តាំងហើ ម៉ៃៗ មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ កា ខ្លោម សាណៃង។ ផះ ប៉ាសុន កាតាំង ប៉ានឹរ សាណៃង មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ខ្លោម អន់ឌែ កា ប៉ាណាំ គួប តាំងហើ ម៉ៃៗ ខាក់។ ផះ ណោះ ប៉ាន់ទៀយ មឿង យេរីខូ កា ប៉ាក់ ព្លូក មួត តាហាន កា តាឡូះ ឡាំ ប៉ាគ់ ង៉ីរ ពឿ ង៉ីរ អ៊ែ ឡាំ តាប៉ីត អ្យក់ មឿង ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","មួត អ៊ីស្រាអ៊ែល ថាំឡាយ អ្លាត ប៉ាណូស លូ កាណាគ័ ឡាក់ អ្វៃ ពឹង មឿង ណោះ អន់ ទិ ភឿ មប អន់ កា ប‌៉្រ័ះ ប៊កកាតយ័។ អន់ឌែ កោះ ប៉ាន់តោ័ ប៉ាណូស ពឹង មឿង ណោះ ទឹប កាម៉ាក័ ទឹប អង់កាន់ ទឹប ក្រាគ់ ទឹប សាស្វា។ កាប៉ាច់ រ៉ក់ ចៀម លៀ អន់ឌែ កោះ ប៉ាន់តោ័ លូ ដាវ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","យូស្វេ រ៉ះ លូ កាម៉ាក័ ពៀរ ដូវ ឡាក់ សឺប កាន ណោះ ផា «ហគ់ ឡាំ ប៉ាគ់ ហី ណាង រ៉ាហាប់ ណោះ លូ ប៉ាណាំ អ៊ែ ឡាំ ប៉ាគ់ អា ទឹប ខាប់ខួ ហី ក្រាន អ៊ែ ទិណោ័ះ ឡាក់ កា អន់ដីស ម៉ត់ លូ អ៊ែ ពែ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","កាម៉ាក័ ពៀរ ដូវ ឡាក់ សឺប កាន ណោះ កា ឡាំ ប៉ាគ់ ហី ណាង រ៉ាហាប់ លូ ប៉ាណាំ អ៊ែ ឡាច់ ឡឹង ណោះ ទឹប ពឹ មើគ អុះ ម៉ី អ៊ែ លូ បក់ អ្វៃ អន់ឌូ លូ អ៊ែ ទិឌូ អន់ រ៉ាវ៉ាច់ ឡឹង សារ តោ័ ឡាំ អ្វៃ ក្យាម័ ចារ រ៉ាណើះ អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","កាប៉ាច់ មឿង យេរីខូ ណោះ មួត អ៊ីស្រាអ៊ែល សុះ ថាំឡាយ ទឹប កាណាគ័ ទិណោ័ះ ឡាក់ ទី កាណុង មឿង ណោះ គម ដឹង កាណាគ័ ឡាក់ កា ម៉ាស ប៉្រាក់ សាប៉ាន័ ប៉ាសយ់ អ្យក់ ប៉ាតុំ ឡាំ អន់ ប៉ាគ់ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","យូស្វេ កា គម ណាង រ៉ាហាប់ ឡាក់ អង់កាន់ ម៉ាលេង លូ ខាប់ខួ ពឹ មើគ អុះ ម៉ី ហី ក្រាន អ៊ែ អន់ អ្វៃ រ៉ីស ញន កា អ៊ែ អោន កាម៉ាក័ ពៀរ ដូវ ឡាក់ យូស្វេ ប៉្រើ ឡាំ សឺប កាន ពឹង មឿង យេរីខូ។ អ៊ែ កា អ្វៃ អន់ឌូ លូ ប៉ាសុន អ៊ីស្រាអ៊ែល ដេល លើយ ទឹល រ៉ប់ ដារ់ អា។ ");
INSERT INTO tpu_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","ផះ ណោះ យូស្វេ ប៉ាស្យាប ផា «បក់ ពឿ ប៉ាំងកើត មឿង យេរីខូ អា ណាវ្គ លូ ប៉្រគ័ ប៉ាន់ទៀយ មឿង យេរីខូ អា អន់ គន តាម័ ឡោងទ្រៀ អ៊ែ តោ័។ ផា អ៊ែ ខឹន ប៉្រគ័ អំប៉ារ មឿង អា អន់ គន ស្រុច អ៊ែ តោ័ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","ប‌៉្រ័ះ ប៊កកាតយ័ កា អ្វៃ អន់ឌូ លូ យូស្វេ យូស្វេ កា លៅ លែង សិច ប៉ាញ័ ទឹប ប៉ាថេត ណោះ។ … ");
INSERT INTO tpu_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","វគ័ យូស្វេ តាប៉ីត អ្យក់ ប៉ាថេត ទិណោ័ះ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ លូ វគ័ ម៉ូសេ។ វគ័ យូស្វេ អ្យក់ តេះ ទិណោ័ះ ជែក អន់ កា សុនសាត អ៊ីស្រាអ៊ែល ប៉្រគ័ ប៉ាដក់ ប៉ាជៀ តាម ផូង័ វ៉ាច់ ពឿ ផូង័ វ៉ាច់ អ៊ែ។ ឡៃង ឡឹង ណោះ ប៉ាថេត ណោះ ទី សារ សាណុក សាវ៉ាក អូ ទី សារ តាកូះ ណាវ្គ ហង។ … ");
INSERT INTO tpu_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","យូស្វេ អើ ប៉ាតុំ ផូង័ វ៉ាច់ អ៊ីស្រាអ៊ែល ទិណោ័ះ ឡាំ ប៉ាតុំ គួប ប៉ាគ់ ស្រុក ស៊ីគែម លូ អើ មួត ក្រាគ់ តាំងកង់ លូ មួត ម៉ៃគ រ៉ាំងហៃ ក្រុំ ទិណោ័ះ ដេល អន់ អន់ឌែ អ្វៃ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","កេះណោះ យូស្វេ រ៉ះ កា ប៉ាសុន ទិឌូ ផា «ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល រ៉ះ ផា \"ផះ សើគ ពែ វគ័ អន់ដីស ថេរ៉ា ឡាក់ ពឹ អាប៉្រាហាំ លូ ណាហ៊រ អន់ឌែ អ្វៃ ហាង តោ តាំងលេ អឺប៉្រាត អន់ឌែ កា សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ អន់ទៀគ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","អាញ់ ប៉ាណាំ អាប៉្រាហាំ ឡាក់ វគ័ អន់ដីស ឃ្លង តាំងលេ អឺប៉្រាត អន់ ចាក ឡាំ ប៉ាគ់ ប៉ាថេត កាណាន អា លូ ប៉ាណាំ អ៊ែ ចាក ប៉ាញ័ ទឹប ប៉ាថេត អាញ់ កា ប៉្រគ័ អន់ គន សោ អ៊ែ រ៉ាល ហ៊ែង អៀង ទឹប អាញ់ អន់ អ៊ែ ទី គន សិច អ៊ីសាក់។ ");
INSERT INTO tpu_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","អាញ់ អន់ អ៊ីសាក់ ទី គន សិច យ៉ាកុប លូ អេសាវ ដេល លូ មប អន់ អេសាវ រ៉ាំងហៃ ព្រី ប៉ានឹម សៀរ កាប៉ាច់ យ៉ាកុប លូ គន អ៊ែ ទិណោ័ះ ឡាំ អ្វៃ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","ឡៃង ឡឹង ណោះ អាញ់ កា ប៉្រើ ម៉ូសេ លូ អារ៉ុន ឡាំ កាកាប លូ សាដាច់ អ៊ីស៊ីប អាញ់ កា ប៉្រគ័ អន់ សុនសាត អ៊ីស៊ីប ទី សារ ថុក ប៉ាណាប ឡាំបាក កាខាក់ កេះណោះ អាញ់ ប៉ាណាំ វគ័ យ៉ាគ់ អន់ដីស ឡាច់ ឡឹង ប៉ាថេត ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","ប៉ាគ់ អាញ់ ប៉ាណាំ វគ័ យ៉ាគ់ អន់ដីស ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប កេះ អន់ឌែ កា ចាក ទឹល ប៉ាគ់ ហាង តាំងលេ តីស ស៊ូប ផាឌី កា តាហាន អ៊ីស៊ីប តាយ៉ិប ពួយ ជិះ សេះ ជិះ រ៉ាតេ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","វគ័ យ៉ាគ់ អន់ដីស ឡោម អើ អាញ់ អាញ់ កា ប៉្រគ័ អន់ ទី កាម៉ល់ ម៉ាម៉ាំង ម៉ាមត អ្វៃ ពឹង អន់តិគ័ វគ័ យ៉ាគ់ អន់ដីស លូ សុនសាត អ៊ីស៊ីប កេះណោះ អាញ់ ប៉្រគ័ អន់ ទៀក តាំងលេ តឹ សុនសាត អ៊ីស៊ីប ឡង់ តោ័ ទិ អន់ដីស ទិឌូ កា អ្លុ ដេល សារ អាញ់ ប៉្រគ័ ណោះ។ អន់តីគ ឡឹង ណោះ ប៉ាសុន អន់ដីស ទិឌូ កា អ្វៃ ពឹង ស៊្រែ តីស ទុញ សាណាំ ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","ឡៃង ឡឹង ណោះ អាញ់ ប៉ាណាំ អន់ដីស ចាក ឡាំ ទឹល ប៉ាគ់ ប៉ាថេត សុនសាត អាម៉ូរី ឡាក់ អ្វៃ គែង ដារ់ ឡាច់ ទ្រូង យដាន់។ សុនសាត អាម៉ូរី កា តាកូះ លូ អន់ដីស ហះកា អាញ់ មប អន់ឌែ កា អន់ដីស។ អន់ដីស កា តាប៉ីត អ្យក់ តេះ អន់ឌែ ណោះ ទឹប អាញ់ ថាំឡាយ អន់ឌែ អន់ ហ៊្យង ឡឹង ម៉ាត់ អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","កេះណោះ សាដាច់ បាឡាក់ គន វគ័ ស៊ីបពរ ឡាក់ រ៉ាំងហៃ ប៉ាថេត ម៉ូអាប់ ប៉ាសាំង លូ សុនសាត អ៊ីស្រាអ៊ែល អ៊ែ កា ប៉្រើ ពូ ឡាំ រ៉ះ កា វគ័ បាឡាម គន វគ័ បេអ៊រ ម៉ាគ់ ចឹង ប៉ាស្យាប អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","ហះកា អាញ់ អូ ប៉្រគ័ ពួយ ប៉ានឹរ បាឡាម អុះ អ៊ែ កា ប៉ាង៉ាច់ កាប ដាគ់ កា អន់ដីស អាញ់ កា តង័ អន់ដីស អន់ រ៉ាវ៉ាច់ ឡឹង តី សាដាច់ បាឡាក់។ ");
INSERT INTO tpu_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","អន់ដីស កា ឃ្លង ទ្រូង យដាន់ ឡាំ ទឹល ប៉ាគ់ មឿង យេរីខូ។ មួត មឿង យេរីខូ ណោះ ប៉ាណាំ គួប តាកូះ លូ អន់ដីស កេះណោះ មួត សុនសាត អាម៉ូរី លូ មួត សុនសាត ពែរិស៊ីត សុនសាត កាណាន សុនសាត ហេត សុនសាត គើកាស៊ី សុនសាត ហេវី សុនសាត យេប៊ូស កា ឡាំ តាកូះ ដេល ហះកា អាញ់ មប អន់ឌែ កា អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","អាញ់ ប៉្រគ័ អន់ កា ពូ កាដើត ឡាក់ កា អ៊ង តាយ៉ិប សោច នែវ អា ហង អាញ់ ទ្រុះ ឡាច់ សាដាច់ សុនសាត អាម៉ូរី ទិ ពៀរ ដូវ អន់ ឡាច់ ឡឹង ម៉ាត់ អន់ដីស ណោះ ហង បះ ចាយ័ ទ្រង អន់ដីស អូ ត្រគ់ ញន កា ដាវ លើ ស្រាគ់ អន់ដីស អុះ។ ");
INSERT INTO tpu_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","អាញ់ កា មប ប៉ាថេត អា អន់ កា អន់ដីស ឡាក់ អន់ដីស អូ ក្លេ័ះ ម៉ូស អូ ក្លេ័ះ កាល់ អុះ អន់ដីស ទី ស្រុក ទី មឿង អ្វៃ ឡាក់ អូ ក្លេ័ះ ប៉្រគ័ កា ទី ប៉្លៃ អង់កាច សា លូ ប៉្លៃ អូលេវ ឡាក់ អន់ដីស អូ ទី តប់\"»។ ");
INSERT INTO tpu_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","យូស្វេ រ៉ះ ណាវ្គ ផា «ទឹល នីណោ័ះ ហគ់ អ្យិល កូត័ អ្យូគ កា ប‌៉្រ័ះ ប៊កកាតយ័ លូ សាំប‌៉័ះ ប៉ានេ អ៊ែ ទិ ពុត ទិ ពៀក ញន ពុត ដាគ់ ត្រង់ ហគ់ អ្លាត ពិ ប‌៉្រ័ះ អន់ទៀគ ឡាក់ វគ័ យ៉ាគ់ អន់ដីស ឃើយ សាំប‌៉័ះ ប៉ានេ ផះ អ្វៃ ហាង តោ តាំងលេ អឺប៉្រាត លូ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ពែ ហគ់ អន់ដីស ប៉ាណាំ គួប សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","ហះកា ផា អន់ដីស អូ ចៃ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័  ហគ់ អន់ដីស ណាំង ប‌៉្រ័ះ ចំ ឡាក់ ត្រគ់ ពុត អន់ដីស ពឹង ដារ់ អា ហង ពិ ទី ប‌៉្រ័ះ ឡាក់ វគ័ យ៉ាគ់ អន់ដីស ឃើយ សាំប‌៉័ះ ប៉ានេ ផះ អ្វៃ ហាង តោ តាំងលេ អឺប៉្រាត ពែ លើ ប‌៉្រ័ះ សុនសាត អាម៉ូរី ឡាក់ អ្វៃ ពឹង ប៉ាថេត ឡាក់ អន់ដីស ផះ អ្វៃ អា ហះកា កាប៉ាច់ អាញ់ លូ ហី ក្រាន អាញ់ ញឹន ចឹង សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ »។ ");
INSERT INTO tpu_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","ប៉ាសុន ទិឌូ តើល ផា «ញឹន អូ អ្លាត ប‌៉្រ័ះ ប៊កកាតយ័ ភឿ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ អន់ទៀគ អុះ ");
INSERT INTO tpu_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","ខង ទី ដឹង ប‌៉្រ័ះ ប៊កកាតយ័ អា ហង ឡាក់ ប‌៉្រ័ះ ពិន អ៊ែ ហង ប៉ាណាំ វគ័ យ៉ាគ់ ពិន ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ឡាក់ ពិន ឃើយ ប៉្រគ័ ទុច អ៊ែ កា តាំបាង សារ អំរ៉ាញ អឺញ អន់ ពិន ប៉ប័ ម៉ាត់ ពិន តាំងឡា ទឹប អ៊ែ ប៉ងកាន់ រ៉ាំងហៃ ពិន រទ្រង ផះ ពិន ចាក តាត់ ព្រី ទៀក សុនសាត អន់ទៀគៗ។ ");
INSERT INTO tpu_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","អ៊ែ កា តាំងហ្យិត សុនសាត អន់ទៀគ ឡាច់ ចាំងហាយ្គ ឡឹង ម៉ាត់ ពិន ឡាក់ កា សុនសាត អាម៉ូរី ឡាក់ អ្វៃ ពឹង ប៉ាថេត អា ពែ ទឹល នីណោ័ះ ញឹន ចឹង សាំប‌៉័ះ ប៉ានេ អ៊ែ ដេល ខង អ៊ែ ឡាក់ ប‌៉្រ័ះ ពិន»។ ");
INSERT INTO tpu_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","យូស្វេ រ៉ះ កា ប៉ាសុន ផា «ជែ រិញ កាប ផា ចឹង សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័  អន់ដីស អូ អ្លុ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ អុះ ខង អ៊ែ ដាគ់ ត្រង់ កាខាក់ អ៊ែ កា អូ ចៃ កា អន់ដីស សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ អន់ទៀគ ណាវ្គ អុះ អ៊ែ អូ អ្លាត ដោះ អុះ សារ យច លូ សារ ញ៉ា ឡាក់ អន់ដីស ប៉ាសាំង លូ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","ផា អន់ដីស អ្លាត អូ សឿ អ៊ែ កេះណោះ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ អន់ទៀគ ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ថាំឡាយ អន់ដីស ឡូត យ‌៉័ះ អ៊ែ ឃើយ អន់ សារ ដាគ់ កា អន់ដីស កាតាម»។ ");
INSERT INTO tpu_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","ប៉ាសុន តើល យូស្វេ ផា «អូ អុះ ញឹន ចឹង សាំប‌៉័ះ ប៉ានេ ដឹង ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","យូស្វេ រ៉ះ កា ប៉ាសុន ណាវ្គ ផា «អន់ដីស ផា ចឹង សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័  ទឹល នីណោ័ះ ប៉ាគ់ អន់តីគ ទៀ ជែ ប៉ាគែក ផា អូ កាប ដៃ»។ អន់ឌែ កា តើល ផា «ណោះ ហង ញឹន អូ ប៉ាគែក អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","យូស្វេ រ៉ះ ណាវ្គ ផា «ទឹល នីណោ័ះ ហគ់ អន់ដីស អ្លាត ទិ ប‌៉្រ័ះ អន់ទៀគ ពិ កេះណោះ ខំ សឿ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល ពិន ទិ ពុត ទិ ពៀក»។ ");
INSERT INTO tpu_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","ប៉ាសុន តើល ផា «ញឹន ចឹង សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ពិន ទឹប ចឹង ប៉្រគ័ ពួយ ប៉ានឹរ អ៊ែ រ៉ះ ឡូត»។ ");
INSERT INTO tpu_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","ដារ់ ណោះ ហង យូស្វេ កា ប៉ាណាំ ប៉ាសុន សាញ៉ា រែវ ពុត លូ ប‌៉្រ័ះ ប៊កកាតយ័ ពឹង ស្រុក ស៊ីគែម ទឹប អ៊ែ អន់ ចាបាប់ ប៉ិច កា ពូ ប៉្រគ័ ពួយ។ ");
INSERT INTO tpu_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","យូស្វេ កា ច្រាគ់ សារ ទិណោ័ះ កាណុង ផាប់ ចាបាប់ ប‌៉្រ័ះ ទឹប អ្យក់ អំហ្មោ តាគ់ អន់តាវ ហះ កានឺប តើម ជ្រី ឡាក់ ក្យាម័ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","យូស្វេ រ៉ះ កា ប៉ាសុន ផា «ហៃ អំហ្មោ អា ហង ឡាក់ ប៉្រគ័ ផាញ៉ាន កា អន់ដីស ខង អំហ្មោ អា កាតាំង ប៉ានឹរ ប‌៉្រ័ះ រ៉ះ កា ពិន គ្រឹប សារ អន់ទៀគៗ អន់ទៀ អន់ដីស ប៉្រគ័ អូ ត្រង់ លូ ប‌៉្រ័ះ»។ ");
INSERT INTO tpu_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","កេះណោះ យូស្វេ អន់ ប៉ាសុន សឹត ប៉ាគ់ ព្រី ទៀក ចានែក ប៉ាដក់ ប៉ាជៀ ទ្រង ពឿ ទ្រង អ៊ែ។ …");
INSERT INTO tpu_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","វគ័ យូស្វេ ប៉្រើ ប៉ាសុន ចាក ឡាច់ ឡឹង ចារ ណោះ សុនសាត អ៊ីស្រាអ៊ែល កា ប៉ាណាំ គួប សឹត អ្វៃ ប៉ាគ់ ព្រី ទៀក ចានែក ប៉ាដក់ ប៉ាជៀ ទ្រង ពឿ ទ្រង អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","អន់ឌែ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ផះ វគ័ យូស្វេ អ្វៃ រ៉ីស។ អន់តីគ ឡឹង អ៊ែ តោ័ ណោះ ផះ រ៉ាំងវ៉ាង ក្រាគ់ តាំងកង់ អ្វៃ រ៉ីស ប៉ាសុន កា អ្វៃ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ និះទៅ ដេល។ មួត ក្រាគ់ តាំងកង់ ណោះ ហង ឃឺ មួត បក់ ឃើយ ប៉ប័ សារ អំរ៉ាញ អឺញ កេង ខាក់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ កា សុនសាត អ៊ីស្រាអ៊ែល ពែ។ ");
INSERT INTO tpu_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","វគ័ យូស្វេ គន វគ័ នូន ឡាក់ ប៉ាណូស ប៉្រគ័ ង៉ារ ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ តោ័ ផះ អាញុ ១១០ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","ពូ តប់ ប៉ាទ្រូ អ៊ែ ពឹង តេះ ប៉ាដក់ ចានែក អ៊ែ ប៉ាគ់ តេះ ធីមណាត ហេរេះ ពឹង ព្រី ប៉ានឹម ផូង័ អេប៉្រាអ៊ីម គែង ជើង ប៉ានឹម កាអះ។ ");
INSERT INTO tpu_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","ប៉ាសុន អ៊ីស្រាអ៊ែល រ៉ាំងហាវ ណោះ កា តោ័ ពួយ វគ័ យ៉ាគ់ អន់ឌែ ពែ ដេល។ ទី ប៉ាណូស រ៉ាំងហាវ អន់តីគ ណាវ្គ កើត ពឹះ អន់ឌែ ទិណោ័ះ អូ អន់ហ្នាល់ ប‌៉្រ័ះ ប៊កកាតយ័ កា អូ អ្លុ អន់តគ់ ឡឹង ង៉ារ អ៊ែ ប៉្រគ័ អន់ កា មួត អ៊ីស្រាអ៊ែល ពែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","សុនសាត អ៊ីស្រាអ៊ែល ប៉្រគ័ យច លូ ប‌៉្រ័ះ ប៊កកាតយ័  អន់ឌែ ប៉ាណាំ គួប សាំប‌៉័ះ ប៉ានេ ហ៊ូប ប‌៉្រ័ះ បាល ");
INSERT INTO tpu_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","អន់ឌែ អ្លាត ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ វគ័ យ៉ាគ់ អន់ឌែ ឡាក់ ប៉ាណាំ វគ័ យ៉ាគ់ អន់ឌែ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ពែ។ អន់ឌែ អ្យិល កូត័ កា ប‌៉្រ័ះ អន់ទៀគ ឡគ ឡាក់ ប‌៉្រ័ះ សុនសាត អន់ទៀគៗ ឡាក់ អ្វៃ ជុំ អន់ឌែ ណោះ។ អន់ឌែ ជន តាកុល សាំប‌៉័ះ ប‌៉្រ័ះ ទិណោ័ះ ប៉្រគ័ អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អឺក កា អន់ឌែ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","អន់ឌែ អ្លាត ប‌៉្រ័ះ ប៊កកាតយ័  សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ បាល លូ ប‌៉្រ័ះ អាសាថារ៉ូត ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","ប‌៉្រ័ះ ប៊កកាតយ័ អឺក កា សុនសាត អ៊ីស្រាអ៊ែល កាខាក់ កា មប អន់ឌែ ពឹង តី មួត ថាំឡាយ ឡាក់ រ៉ាត អ្យក់ រ៉ាស អំប៉ាស គឹត ខា ម៉ះ អន់ឌែ ប‌៉្រ័ះ មប អន់ឌែ អន់ កា មួត តាម៉ឺរ ឡាក់ អ្វៃ ជុំ អន់ឌែ អន់ឌែ កា អូ ដាម័ មួត តាម៉ឺរ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","រ៉ប់ អន់ឌែ ឡាំ តាកូះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ អន់ឌែ តាកូះ អូ ដាម័ តាម៉ឺរ លើយ ឡាក់ កា អ៊ែ រ៉ះ កេះៗ ឡាក់ កា អ៊ែម៉ត់ ដេល ណោះ ហង បះ អន់ឌែ ប៉ាណាប ឡាំបាក កាខាក់ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","ផះ រ៉ាំងវ៉ាង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ើស ប៉ាណូស ម៉ោញ ដូវ ប៉្រើ ប៉្រគ័ ម៉ៃគ ណាំផា ភឿ តង័ អន់ឌែ អន់ រ៉ាវ៉ាច់ ឡឹង តី មួត ថាំឡាយ។ ");
INSERT INTO tpu_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","ហះកា អន់ឌែ អូ សាំយ៉ាំង ប៉ានឹរ ម៉ៃគ ណាំផា អន់ឌែ ណោះ អុះ អន់ឌែ ប៉្រគ័ យច លូ ប‌៉្រ័ះ ប៊កកាតយ័ ពៀប ឡាក់ កា កាម៉ាញ់ រ៉ាលង កល់ ក្លោ អន់ឌែ ប៉ិច កា ប‌៉្រ័ះ អន់ទៀគ ទឹប ជន តាកុល សាំប‌៉័ះ។ អន់ឌែ ឡាម៉គ់ ខាក់ អ្លាត សារ វគ័ យ៉ាគ់ អន់ឌែ អន់ឌែ អូ ប៉្រគ័ ពួយ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ កា វគ័ យ៉ាគ់ អន់ឌែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","ផះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ើស ម៉ៃគ ណាំផា អន់ កា អន់ឌែ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កា អ្វៃ អន់ឌូ លូ ម៉ៃគ ណាំផា ណោះ លើយ ឡុច អាញុ លូ តង័ អន់ឌែ អន់ រ៉ាវ៉ាច់ ឡឹង តី មួត តាម៉ឺរ ញន កា ប‌៉្រ័ះ ប៊កកាតយ័ តាប៉ាប កា អន់ឌែ ផះ អ៊ែ កាតាំង អន់ឌែ ញ៉ាំ តាំងអឹះ ញន កា មួត តាម៉ឺរ ប៉្រគ័ បាប អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","ប៉ាគ់ ម៉ៃគ ណាំផា អន់ឌែ តោ័ កេះ អន់ឌែ កា ប៉ាណាំ គួប ប៉្រគ័ យច ក្វា ឡឹង ពឹ មើគ អន់ឌែ ពែ សាំ។ អន់ឌែ អ្យិល កូត័ ជន តាកុល សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ អន់ទៀគ ណាវ្គ អន់ឌែ កាង័ កល់ អូ អ្លាត សារ អន់ឌែ ប៉្រគ័ យច ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","ផះ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ អឺក កា សុនសាត អ៊ីស្រាអ៊ែល កាខាក់ ឡូត លូ កាប ផា «ញន កា សុនសាត អា អ្លាត សារ សាញ៉ា រែវ ពុត ឡាក់ អាញ់ អន់តគ់ រ៉ះ កា វគ័ យ៉ាគ់ អន់ឌែ ពែ លូ អូ សាំយ៉ាំង ប៉ានឹរ អាញ់ អុះ ");
INSERT INTO tpu_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","ទឹល នីណោ័ះ គឹត អៀ គែង ម៉ាត់ អាញ់ ចឹង អូ ទ្រុះ សុនសាត បក់ អ៊ែ ចំ ម៉ោញ កាណុង សុនសាត ទិណោ័ះ ឡាក់ យូស្វេ បើ តាន័ ទ្រុះ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","អាញ់ ចឹង អន់ សុនសាត ទិណោ័ះ ណាំង សារ ហៃ លួង ម៉ាគ់ អ្លុ អន់តគ់ ផា មួត សុនសាត អ៊ីស្រាអ៊ែល អ្វៃ ចាក ពួយ ទ្រង អាញ់ ឡាក់ កា វគ័ យ៉ាគ់ អន់ឌែ ដេល ប»។ ");
INSERT INTO tpu_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","ប‌៉្រ័ះ ប៊កកាតយ័ គម សុនសាត ទិណោ័ះ អន់ អ្វៃ ពឹង ប៉ាថេត ណោះ ភឿ ចឹង សាគ់ ហៃ លួង សុនសាត អ៊ីស្រាអ៊ែល ប៉ិច កា អ្លុ អន់តគ់ ផា អន់ឌែ ចឹង ប៉្រគ័ ពួយ អ៊ែ ឡាក់ កា វគ័ យ៉ាគ់ អន់ឌែ ប៉្រគ័ ពួយ អ៊ែ សើគ ពែ ដេល ប ខ ណោះ ហង បះ អ៊ែ អូ អន់ យូស្វេ ទ្រុះ ឡាច់ ពូ ស៊្រសៗ អុះ។ … ");
INSERT INTO tpu_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","សុនសាត អ៊ីស្រាអ៊ែល ប៉ាណាំ គួប ប៉្រគ័ សារ អូ ដាគ់ ម៉ោញ ទង ណាវ្គ ឡាក់ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័  ញន ណោះ ហង បះ ប‌៉្រ័ះ ប៊កកាតយ័ មប អន់ឌែ ពឹង តី សុនសាត ម៉ាឌៀន ទុញ ទិ តាំប៉ើះ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","សុនសាត ម៉ាឌៀន ជិះ ចគ័ ប៉្រគ័ បាប សុនសាត អ៊ីស្រាអ៊ែល តិម ពុត តិម ចៃ។ សុនសាត អ៊ីស្រាអ៊ែល កា ណាំង រ៉ូង័ ប៉ានឹម លូ ក្លូះ ជុង ប៉ានឹម ប៉្រគ័ ចារ អ្វៃ ភឿ អោន ឡាកោ ឡឹង សុនសាត ម៉ាឌៀន។ ");
INSERT INTO tpu_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","រ៉ប់ ថុន សុនសាត អ៊ីស្រាអ៊ែល សាមូល សុនសាត ម៉ាឌៀន លូ សុនសាត អាម៉ាឡេក ទឹប មួត ប៉ាណូស ពឹះ ឡឹង ដារ់ ឡាច់ កា ពឹះ ថាំឡាយ។ ");
INSERT INTO tpu_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","អន់ឌែ ប៉្រើ តាហាន ឡាំ អ្វៃ ក្យាម័ សុនសាត អ៊ីស្រាអ៊ែល កេះណោះ ថាំឡាយ អ្លាត កាណាគ័ សុនសាត អ៊ីស្រាអ៊ែល តប់ ទឹល មឿង កាសា។ អន់ឌែ អូ ទី គម កាណាគ័ ញ៉ា កា សុនសាត អ៊ីស្រាអ៊ែល សា អុះ យ‌៉័ះ ចៀម រ៉ក់ លូ លៀ កាតាម កា អូ អន់ សល់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","អន់ឌែ ពឹះ ណោះ អ្យក់ ឡាំ ទឹប កាណាគ័ រង លូ រ៉ាណើះ ដេល កាំឡាំង អន់ឌែ អៀង ខាក់ ប៉ុប កា អំហ្មោច ទឹប ប៉ាណូស ទឹប អូត ទី ចំលួន អៀង កាខាក់ យ៉ាប អូ ទិ អន់ឌែ ពឹះ ថាំឡាយ ប៉ាថេត អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","ញន កា សុនសាត ម៉ាឌៀន ណោះ សុនសាត អ៊ីស្រាអ៊ែល កើត ថុក ញ៉ាក កាខាក់ អន់ឌែ កា ម៉ន់ ឡោម អើ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ តង័ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","ផះ សុនសាត អ៊ីស្រាអ៊ែល ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ តង័ អន់ឌែ អន់ រ៉ាវ៉ាច់ ឡឹង តី មួត សុនសាត ម៉ាឌៀន ");
INSERT INTO tpu_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉្រើ រ៉ាគឹយ អ៊ែ ម៉ោញ ដូវ ពឹះ រ៉ះ កា អន់ឌែ ផា «ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល អ៊ែ រ៉ះ ផា \"អាញ់ ប៉ាណាំ អន់ដីស ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ចារ អន់ដីស ប៉្រគ័ ទុច ពែ។ ");
INSERT INTO tpu_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","អាញ់ កា តង័ អន់ដីស អន់ រ៉ាវ៉ាច់ ឡឹង តី មួត សុនសាត អ៊ីស៊ីប លូ មួត បក់ ជិះ ចគ័ ប៉្រគ័ បាប អន់ដីស ពែ។ អាញ់ តាំងហ្យិត ពូ ឡាច់ ឡឹង ម៉ាត់ អន់ដីស ទឹប មប ព្រី ទៀក ស្រុក តេះ ពូ អន់ កា អន់ដីស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","អាញ់ រ៉ះ កា អន់ដីស កេះ 'អាញ់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ជែ អ្យិល កូត័ អ្យូគ កា ប‌៉្រ័ះ សុនសាត អាម៉ូរី កាណុង ប៉ាថេត ឡាក់ អន់ដីស អ្វៃ ណោះ' ហះកា អន់ដីស ទិឌូ អូ សាំយ៉ាំង អាញ់ អុះ\"»។ ");
INSERT INTO tpu_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","ផះ រ៉ាំងវ៉ាង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាំ ប៉ាគ់ តេះ អូប៉្រា អ្វៃ ហះ តើម ជ្រី វគ័ យ៉ូអះ ឡាក់ ផូង័ វ៉ាច់ អាបៀស៊ើរ។ ផះ ណោះ គេឌៀន គន វគ័ យ៉ូអះ ផះ អ្វៃ ប៉្រះ ពៀ កាណុង ឡូះ រ៉ូត័ ប៉្លៃ អង់កាច ភឿ ជែ អន់ សុនសាត ម៉ាឌៀន ប៉ប័។ ");
INSERT INTO tpu_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","ប‌៉្រ័ះ ប៊កកាតយ័ កា តាំបាង ឡាកោ ឡាក់ កា ប៉ាណូស អន់ គេឌៀន ប៉ប័ លូ កាប ផា «អឺ បក់ កេង ខាក់ ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ អន់ឌូ លូ អីស កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","គេឌៀន តើល ផា «ផា ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ អន់ឌូ លូ ញឹន តាទឹច ខ ញ៉ា បះ សារ ថុក ឡាំបាក កើត ពឹះ ពឹង ញឹន នីអៀ ? ចំ សារ អំរ៉ាញ អឺញ កេង ខាក់ ឡាក់ វគ័ យ៉ាគ់ ញឹន រ៉ះ ផា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាណាំ អន់ឌែ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប សើគ ពែ ណោះ ? ហះកា កិញអៀ អា ប‌៉្រ័ះ ប៊កកាតយ័ អ្លាត ញឹន មប អន់ កា សុនសាត ម៉ាឌៀន»។ ");
INSERT INTO tpu_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","ប‌៉្រ័ះ ប៊កកាតយ័ កាលែង ហៃ គែង អ៊ែ កេះណោះ រ៉ះ ផា «ហគ់ ឡាំ តង័ អ៊ីស្រាអ៊ែល អន់ រ៉ាវ៉ាច់ ឡឹង តី សុនសាត អន់ទៀគ ញន កា សាងុំ អីស ទៅ ហៃ អាញ់ ប៉្រើ អីស ឡាំ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","គេឌៀន តើល ផា «អឺ ពឹ តាំងឡា ប៉្រគ័ នីចម័ អាញ់ ចឹង អ្លុ តង័ អ៊ីស្រាអ៊ែល ? ខង កាណុង ផូង័ ម៉ាណាសេ វ៉ាច់ ញឹន អូ កាឡោះ ឡឹង ពូ ពឹង វ៉ាច់ ញឹន អាញ់ កា ប៉ាណូស អូ កាឡោះ ឡឹង ពូ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ ណាវ្គ ផា «អាញ់ ចឹង អ្វៃ អន់ឌូ លូ អីស ម៉ាគ់ អីស ចឹង តាកូះ លូ សុនសាត ម៉ាឌៀន ចាយ័ ទ្រង អីស ឡាក់ កា អីស ពីត លូ ប៉ាណូស ដឹង ម៉ោញ ដូវ»។ ");
INSERT INTO tpu_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","គេឌៀន អ៊ែ តើល ផា «ផា អីស ប៉ាញ័ ពុត កា អាញ់ តាទឹច ប៉រ់ អីស តាំបាង សារ អំរ៉ាញ អឺញ អន់ អាញ់ អ្លុ អន់តគ់ ផា អីស ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ កាប លូ អាញ់ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","អ្យគ័ អីស អ្វៃ ហះ អា ហង ជែ ឡាំ ប៉ាគ់ ចំ ហោគ ក្យាគ់ អាញ់ ចឹង សឹត អ្យក់ កាណាគ័ រ៉ាម៉ះ អីស ហិ»។ ប‌៉្រ័ះ ប៊កកាតយ័ តើល ផា «អាញ់ ចឹង ក្យាគ់ ហះ អា ហង ទឹល អីស ពឹះ ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","គេឌៀន ឡាំ អ្យក់ គន ប៉ារ់ពេ ម៉ោញ ពុះ ប៉្រគ័ សាអ៊្លង លូ អ្យក់ តាប៉ុង ម៉ោញ កាអ្លី ប៉្រគ័ ណុំ ប៉ាំង អូ ចៃគ ពុះ។ អ៊ែ អោះ ដឹង ប៉ាំងឡៃ ចៃគ ពឹង គ្រៀង កេះណោះ អោះ ទៀក សាអ៊្លង ចៃគ ពឹង គូម កេះណោះ អ្យក់ ឡាំ អន់ កា ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ ហះ តើម ជ្រី។ ");
INSERT INTO tpu_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","ប‌៉្រ័ះ ប៊កកាតយ័ កាប លូ អ៊ែ ផា «ចៃគ ប៉ាំងឡៃ លូ ណុំ ប៉ាំង អំប៉ាំង អំហ្មោ ណោះ ពិ កេះណោះ តូះ ទៀក សាអ៊្លង អំប៉ាំង ណោះ ដេល»។ គេឌៀន កា ប៉្រគ័ ពួយ។ ");
INSERT INTO tpu_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","ប‌៉្រ័ះ ប៊កកាតយ័ អ្យក់ អ៊្លង កាទូង អ៊ែ ចឹក តាគ់ កាន់តើស ពឹង សាអ៊្លង លូ ណុំ ប៉ាំង ផាឌី ទី អុញ កីត ឡាច់ ឡឹង អំហ្មោ សា ប៉ាំងឡៃ លូ ណុំ ប៉ាំង ទិ ប្លី កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កា ហ៊្យង តាតិង។ ");
INSERT INTO tpu_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","ផះ ណោះ គេឌៀន កា អ្លុ អន់តគ់ ផា ប‌៉្រ័ះ ប៊កកាតយ័ តាទឹច។ អ៊ែ កាកាប ផា «យើយ តោ័ ហង ប‌៉្រ័ះ តាំងឡា ខង អាញ់ ប៉ប័ អីស ប៉ាន់តិង ហះ ម៉ាត់»។ ");
INSERT INTO tpu_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ ផា «ជែ អ្យូគ ហង អ្វៃ គ្រឺយ ពិ អីស អូ តោ័ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","កេះណោះ គេឌៀន អ៊ែ ពូក អំហ្មោ ប៉្រគ័ អន់ហ្នឹង ម៉ោញ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ហះ ចារ ណោះ លូ អន់ សិច ផា យ៉ះវេះ សាឡឹម ។ អន់ហ្នឹង ណោះ អ្វៃ លើយ ទឹល រ៉ប់ ដារ់ អា ពឹង តេះ អូប៉្រា ឡាក់ តេះ ផូង័ វ៉ាច់ អាបៀស៊ើរ។ ");
INSERT INTO tpu_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","ម៉ាំង ណោះ ទៅ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា គេឌៀន ផា «ហគ់ អ្យក់ រ៉ក់ ទោល ពឹ អីស ឡាក់ រ៉ក់ ទី ពៀរ ឡាក់ ទី អាញុ តាំប៉ើះ សាណាំ។ កេះណោះ យ៉ះ អ្លាត អន់ហ្នឹង ពឹ អីស សាំរ៉ាប់ រ៉ាម៉ះ ប‌៉្រ័ះ បាល ទឹប កាល់ អ្លាត អ៊្លង ពូ ប៉្រគ័ ហ៊ូប ប‌៉្រ័ះ អាសេរ៉ា អ្វៃ ក្យាម័ ហះ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","កេះណោះ ណាវ្គ ហគ់ ប៉្រគ័ អន់ហ្នឹង ម៉ោញ ឃឺ សាំរ៉ាប់ រ៉ាម៉ះ អាញ់ ឡាក់ ប‌៉្រ័ះ អីស អ្វៃ ពឹង កល់ ប៉ានឹម ណោះ កេះណោះ អ្យក់ រ៉ក់ ទោល ទី ពៀរ ណោះ ពុះ អ្លាត ទិ ភឿ រ៉ាម៉ះ អាញ់ អ្យក់ អ៊្លង ហ៊ូប ប‌៉្រ័ះ អាសេរ៉ា ឡាក់ អីស កាល់ អ្លាត ណោះ អ្យក់ ប៉្រគ័ រ៉ាម៉េះ»។ ");
INSERT INTO tpu_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","គេឌៀន កា ប៉ាណាំ ទុច អ៊ែ អញ់ជឹត ដូវ ឡាំ ប៉្រគ័ ពួយ សារ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ ហះកា ញន កា អ៊ែ អ្យូគ កា អុះ ម៉ី អ៊ែ លូ កាំឡាំង ស្រុក តេះ អ៊ែ អូ ខឹន ប៉្រគ័ កាដារ់ អុះ អ៊ែ កា ប៉្រគ័ កាម៉ាំង។ ");
INSERT INTO tpu_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","ប៉ាគ់ តារ កាំលឺ មួត ស្រុក តេះ ប៉ប័ អន់ហ្នឹង ប‌៉្រ័ះ បាល តាយ៉ះ លូ អ៊្លង ហ៊ូប ប‌៉្រ័ះ អាសេរ៉ា ឡាក់ អ្វៃ ក្យាម័ ហះ ណោះ កា ពូ កាល់ អ្លាត ដេល ទឹប ប៉ប័ រ៉ក់ ទោល ទី ពៀរ ឡាក់ ពូ ពុះ រ៉ាម៉ះ អ្វៃ អំប៉ាំង អន់ហ្នឹង អង់ក័ះ ប៉្រគ័ ណាវៗ។ ");
INSERT INTO tpu_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","អន់ឌែ អំប៉ញ់ លូ គួប សោប សឹត ឡាំ ផា «ពឿ ប៉្រគ័ អា ?» ប៉ាគ់ អន់ឌែ សឺប អំប៉ញ់ ទី ពូ រ៉ះ ផា «គេឌៀន គន វគ័ យ៉ូអះ ប៉្រគ័ អា»។ ");
INSERT INTO tpu_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","មួត ស្រុក តេះ ឡាំ កាប កា វគ័ យ៉ូអះ ផា «ហគ់ អើ គន អីស ឡាច់ ប៉ាគ់ អា អ៊ែ ត្រគ់ តោ័ ហង ខង អ៊ែ យ៉ះ អន់ហ្នឹង ប‌៉្រ័ះ បាល ទឹប កាល់ អ្លាត អ៊្លង ហ៊ូប ប‌៉្រ័ះ អាសេរ៉ា ឡាក់ អ្វៃ ក្យាម័ ហះ ណោះ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","វគ័ យ៉ូអះ កា តើល មួត បក់ កាប កា អ៊ែ ណោះ ផា «ញ៉ា អុះ ម៉ី ប ឡាក់ ត្រគ់ ប៉ាគែក ប៉ាតាង ប‌៉្រ័ះ បាល ? ញ៉ា អុះ ម៉ី ប ឡាក់ ត្រគ់ តង័ ប‌៉្រ័ះ បាល ? ពឿ ប៉ាគែក ប៉ាតាង ប‌៉្រ័ះ បាល បក់ ណោះ ចឹង តោ័ អន់ទ្រួល ឡឹង ប៉្លៃង បើ តារ។  ផា ប‌៉្រ័ះ បាល ឡាក់ ប‌៉្រ័ះ តាទឹច អន់ អ៊ែ ប៉ាគែក អ៊ែ ទៅ ខង ពូ យ៉ះ អន់ហ្នឹង អ៊ែ»។ ");
INSERT INTO tpu_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","គឹត ណោះ ហង ពឹ អ៊ែ អើ គេឌៀន ផា យេរូបាល លូ កាប ផា «អន់ ប‌៉្រ័ះ បាល ប៉ាគែក លូ អ៊ែ ពិ ខង អ៊ែ យ៉ះ អន់ហ្នឹង ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","ផះ រ៉ាំងវ៉ាង ណោះ សុនសាត ម៉ាឌៀន ទិណោ័ះ ទឹប សុនសាត អាម៉ាឡេក លូ មួត អ្វៃ គែង ដារ់ ឡាច់ កា ប៉ាតុំ គួប ឃ្លង ទៀក ទ្រូង យដាន់ កេះណោះ ប៉្រគ័ រ៉ាណើះ អ្វៃ ហះ ក្លូះ ប៉ានឹម យេសារៀល។ ");
INSERT INTO tpu_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","ហះកា ប៉ាង៉ាត័ ប៉ាលឹង ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ អន់ឌូ លូ គេឌៀន អ៊ែ កា ខ្លោម សាណៃង ភឿ អើ ប៉ាសុន កាណុង ផូង័ វ៉ាច់ អាបៀស៊ើរ អន់ ឡាំ ប៉ាគ់ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","អ៊ែ ប៉្រើ ពូ ឡាំ រ៉ះ កា ផូង័ វ៉ាច់ ម៉ាណាសេ ទិឌូ ភឿ អើ អន់ឌែ ឡាំ ប៉ាគ់ ចារ អ៊ែ។ អ៊ែ កា ប៉្រើ ពូ ឡាំ រ៉ះ កា ផូង័ វ៉ាច់ អាស៊ើរ សេប៊ូលុន លូ ណាប់ថាលី ដេល អន់ឌែ កា ប៉ាណាំ គួប ឡាំ ប៉ាគ់ ចារ អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","ផះ ណោះ គេឌៀន កា កាប លូ ប‌៉្រ័ះ ប៊កកាតយ័ ណាវ្គ ផា «អីស រ៉ះ ផា អីស ចឹង តង័ អ៊ីស្រាអ៊ែល ញន កា អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","ទឹល នីណោ័ះ អាញ់ ប៉រ់ អ្យក់ អង់ការ ចៀម ត្រាក័ ពឹង អន់តិគ័ ចារ ប៉្រះ ពៀ។ ផា ទៀក ងម ទួម ពឹង សក់ អង់ការ ចៀម ហះកា តេះ ជុំ ណោះ សាអ្យាំង ណោះ អាញ់ ចឹង អ្លុ អន់តគ់ ផា អីស ចឹង តង័ អ៊ីស្រាអ៊ែល ញន អាញ់ ឡាក់ កា អីស រ៉ះ តាទឹច»។ ");
INSERT INTO tpu_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉្រគ័ អន់ កើត នីណោ័ះ តាទឹច។ តារ កាំលឺ គេឌៀន កា ម៉ាច់ សក់ អង់ការ ចៀម ទី ទៀក ងម ប៉ាញ័ គូម។ ");
INSERT INTO tpu_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","គេឌៀន កា កាប លូ ប‌៉្រ័ះ ប៊កកាតយ័ ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ជែ អឺក កា អាញ់។ អាញ់ ប៉រ់ ដឹង ម៉ោញ ទង អា ហង ប៉រ់ អីស តាប៉ាប អន់ កា អាញ់ សាគ់ លួង ម៉ោញ ទង អា ណាវ្គ អន់ សក់ អង់ការ ចៀម សាអ្យាំង ហះកា តេះ ជុំ អា សប់ ទៀក ងម»។ ");
INSERT INTO tpu_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","ម៉ាំង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉្រគ័ ពួយ ឡាក់ កា គេឌៀន ប៉រ់ ណោះ ហង សក់ អង់ការ ចៀម កា សាអ្យាំង តេះ ជុំ ណោះ សប់ ទៀក ងម តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","គេឌៀន ឡាក់ ពូ អន់ សិច ផា យេរូបាល អ៊ែ អ្យូវ ឡឹង កាំលឺ ចាក លូ មួត តាហាន អន់ឌែ ឡាំ អ្វៃ ក្យាម័ កល់ ទៀក ហារ៉ុត។ កាប៉ាច់ តាហាន មួត សុនសាត ម៉ាឌៀន អ្វៃ គែង ជើង ចារ មួត តាហាន អ៊ីស្រាអ៊ែល ត្រង់ ក្លូះ ប៉ានឹម ម៉ូរេ។ ");
INSERT INTO tpu_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា គេឌៀន ផា «តាហាន អីស អៀង តាឡាម័ អាញ់ ចឹង ប៉្រគ័ អន់ អន់ឌែ អូ ដាម័ មួត សុនសាត ម៉ាឌៀន អុះ អ្យូគ សុនសាត អ៊ីស្រាអ៊ែល អ្វាត់ អេង ផា អន់ឌែ ចាយ័ ញន កា ឡាកោ អន់ឌែ ទៅ។ ");
INSERT INTO tpu_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","ទឹល នីណោ័ះ អីស រ៉ះ កា ក្រុំ តាហាន ទិណោ័ះ ផា \"ពឿ អ្យូគ តាឡាម័ បក់ ណោះ ត្រគ់ ជឹរ ឡឹង ប៉ានឹម កាឡាត អា សឹត ពិ\"»។ ផះ ណោះ មួត តាហាន ២២.០០០ ដូវ ប៉ាណាំ គួប វ៉ីល សឹត អ្វៃ ដឹង ១០.០០០ ដូវ ដោច។ ");
INSERT INTO tpu_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា គេឌៀន ណាវ្គ ផា «មួត តាហាន អីស អ្វៃ កា អៀង តាឡាម័ ដេល។ ហគ់ ប៉ាណាំ អន់ឌែ ជឹរ ប៉ាគ់ ទៀក ប៉ាគ់ ណោះ អាញ់ ចឹង រ៉ើស តាហាន អន់ កា អីស។ អាញ់ ចឹង រ៉ះ អន់ អ្លុ អន់តគ់ ផា បក់ អ៊ែ ចំ ត្រគ់ ឡាំ អន់ឌូ លូ អីស បក់ អ៊ែ ចំ អូ ត្រគ់ ឡាំ»។ ");
INSERT INTO tpu_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","គេឌៀន ប៉ាណាំ មួត តាហាន ជឹរ ប៉ាគ់ ទៀក ប‌៉្រ័ះ ប៊កកាតយ័ កា រ៉ះ កា អ៊ែ ផា «តាហាន បក់ ចំ ជន តាកុល អៃត ទៀក ឡាក់ កា សូ បក់ ណោះ ត្រគ់ អន់ អ្វៃ ម៉ោញ ចារ»។ ");
INSERT INTO tpu_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","ផះ ណោះ ទី ដឹង ប៉ាណូស ៣០០ ដូវ អៃត ទៀក អំប៉ង់ លូ តី កាយ ឡឹង ណោះ អន់ឌែ ទិឌូ អៃត ទៀក ជន តាកុល។ ");
INSERT INTO tpu_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា គេឌៀន ផា «អាញ់ ចឹង តង័ អ៊ីស្រាអ៊ែល ញន កា ប៉ាណូស ៣០០ ដូវ ឡាក់ អៃត ទៀក អំប៉ង់ លូ តី អា។ អាញ់ ចឹង មប សុនសាត ម៉ាឌៀន អន់ កា អីស ហះកា បក់ អៃត ទៀក ជន តាកុល ណោះ ត្រគ់ ប៉្រើ អន់ឌែ សឹត ប៉ាគ់ ហី ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","ទឹល នីណោ័ះ គេឌៀន ប៉្រើ ពូ សឹត ប៉ាគ់ ហី អ៊ែ គម ដឹង តាហាន ៣០០ ដូវ លូ អ្យក់ ដឹង សាប្យាំង លូ សាណៃង កា អន់ឌែ។ កាប៉ាច់ ចារ តាហាន មួត សុនសាត ម៉ាឌៀន អ្វៃ គែង អន់តេ័ះ ពឹង ក្លូះ ប៉ានឹម។ ");
INSERT INTO tpu_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","ម៉ាំង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា គេឌៀន ផា «ហគ់ ជឹរ ឡាំ តាកូះ លូ មួត តាម៉ឺរ ពិ ខង អាញ់ មប អន់ឌែ អន់ កា អន់ដីស កេះ។ ");
INSERT INTO tpu_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","ផា អីស អូ ខឹន ជឹរ ឡាំ តាកូះ លូ មួត តាម៉ឺរ ហគ់ ជៀក ពូរ៉ា ឡាក់ ទុច អីស ជឹរ ឡាំ ហៃ អន់ទ្រួល ពិ ");
INSERT INTO tpu_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","ម៉ាគ់ អីស ចឹង កាតាំង សារ ពូ កាកាប លូ គួប ពូ ហង ផះ ណោះ អីស ចឹង ទី ពុត ខឹន តាកូះ លូ មួត តាម៉ឺរ»។ អ៊ែ កា ឡាំ អន់ឌូ លូ ពូរ៉ា ឡាក់ ទុច អ៊ែ លើយ ទឹល ប៉ាគ់ ចារ មួត តាម៉ឺរ ញ៉ាម។ ");
INSERT INTO tpu_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","សុនសាត ម៉ាឌៀន សុនសាត អាម៉ាឡេក លូ មួត ពឹះ ឡឹង ដារ់ ឡាច់ ទិណោ័ះ អ្វៃ ប៉ាញ័ ព្រី ពឹង ក្លូះ ហះ ចារ តាប៉ង់ ប៉ាគ់ ជុង ប៉ានឹម កាំឡាំង អន់ឌែ អៀង ប៉ុប កា អំហ្មោច អូត អន់ឌែ អៀង អូ ដាម័ យ៉ាប ប៉ុប កា តេះ ឡាពុក រហាង សាឡីគ សាឡាយ។ ");
INSERT INTO tpu_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","ផះ គេឌៀន ឡាំ ទឹល ចារ ណោះ អ៊ែ កាតាំង សុនសាត ម៉ាឌៀន ម៉ោញ ដូវ រ៉ះ សារ អំប៉ោ លូ គួប ចាង័ អ៊ែ ផា «អាញ់ អំប៉ោ ប៉ប័ ណុំ ប៉ាំង តាហ្វាល់ ម៉ុត ពឹង កាណុង ចារ តាហាន ពិន អា។ ណុំ ណោះ កា តាហ្វាល់ ក្លាគ់ រ៉ាណើះ ប៉្រគ័ អន់ រ៉ាណើះ ពិន ប៉ាក់»។ ");
INSERT INTO tpu_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","គួប ចាង័ អ៊ែ កា រ៉ះ ផា «សារ ណោះ ឃឺ ដាវ គេឌៀន គន វគ័ យ៉ូអះ ឡាក់ សុនសាត អ៊ីស្រាអ៊ែល ហង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ មប សុនសាត ម៉ាឌៀន ពិន លូ តាហាន ទិណោ័ះ អន់ កា អ៊ែ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","ផះ គេឌៀន កាតាំង អន់ឌែ រ៉ះ ឡឹង ប៉ាណោ អំប៉ោ ណោះ អ៊ែ កា សាំប‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័ កេះណោះ អ៊ែ វ៉ីល សឹត ឡាំ ប៉ាគ់ ចារ មួត តាហាន សុនសាត អ៊ីស្រាអ៊ែល ណាវ្គ ផះ ណោះ អ៊ែ រ៉ះ ផា «ហគ់ ប៉ាណាំ គួប អ្យូវ ពិ ប‌៉្រ័ះ ប៊កកាតយ័ មប តាហាន ម៉ាឌៀន អន់ កា អន់ដីស កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","គេឌៀន កា កះ តាហាន ៣០០ ដូវ ទី ប៉ៃង កង អ៊ែ ជែក សាណៃង លូ អុញ កាបង លូ កគ័ កាអ៊ល សាំរ៉ាប់ កាត្រោប អុញ កាបង ណោះ គ្រឹប ម៉ាត់ ទិឌូ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","កេះណោះ គេឌៀន រ៉ះ កា អន់ឌែ ផា «ហគ់ អន់ដីស ហៃ អាញ់ ប៉ាគ់ អាញ់ ឡាំ ទឹល ចារ តាហាន ពូ ទៀ ផា អាញ់ ប៉្រគ័ នីចម័ អន់ដីស កា ប៉ាណាំ គួប ប៉្រគ័ ពួយ នីណោ័ះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","ប៉ាគ់ អាញ់ លូ មួត បក់ អ្វៃ អន់ឌូ លូ អាញ់ ខ្លោម សាណៃង អន់ដីស ទិឌូ ឡាក់ អ្វៃ ជុំ ចារ តាហាន កា ខ្លោម ដេល កេះណោះ តាំងហើ ផា \"ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័  ! ប៉ានេ គេឌៀន !\"»។ ");
INSERT INTO tpu_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","ប៉ាគ់ ទឹល អន់តិគ័ ម៉ាំង កេះ មង ពូ អង់ក័ះ តូរ័ ប៉ាណូស ញ៉ាម ណាវ គេឌៀន លូ តាហាន ១០០ ដូវ ឡាក់ អ្វៃ អន់ឌូ លូ អ៊ែ កា ឡាំ ទឹល ប៉ាគ់ ចារ តាហាន ម៉ាឌៀន ញ៉ាម ណោះ កា ប៉ាណាំ គួប ខ្លោម សាណៃង លូ ប៉្រះ អ្លាត កគ័ កាអ៊ល ឡាក់ អន់ឌែ ចឹក ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","តាហាន ទិ ប៉ៃង កង ខ្លោម សាណៃង លូ ប៉្រះ កគ័ កាអ៊ល អញ់ស្រំ គួប សោប អន់ឌែ ចឹក អុញ កាបង គែង តី សាំងអ្យោ គែង សាម៉ា ចឹក សាណៃង សាំរ៉ាប់ ខ្លោម ទឹប តាំងហើ ផា «ពិ ពិន តាកូះ អន់ កា ប‌៉្រ័ះ ប៊កកាតយ័ លូ អន់ កា គេឌៀន»។ ");
INSERT INTO tpu_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","អន់ឌែ អ្វៃ ចារ ពឿ ចារ អ៊ែ វ៉ិង ជុំ ចារ តាហាន ម៉ាឌៀន ហះកា តាហាន ទិណោ័ះ ឡាក់ អ្វៃ កាណុង ចារ រ៉ាណើះ កា ប៉ាណាំ គួប សាតាក់ តាប៉្រះ តាប៉្រោង ទឹប អង់ហ្យាំង រ៉ាវ៉ើក ថើក កា អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","ផះ តាហាន ទិ ៣០០ ដូវ ខ្លោម សាណៃង ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉្រគ័ អន់ សុនសាត ម៉ាឌៀន វ៉ឹនវ៉ាយ កោះ ប៉ាន់តោ័ គួប អន់ឌែ ទៅ លូ សាតាក់ តាប៉្រះ តាប៉្រោង លើយ ទឹល ប៉ាគ់ ស្រុក តេះ បេតស៊ីតា រទ្រង ឡាំ ប៉ាគ់ ស្រុក តេះ សេរេរ៉ា លើយ ទឹល ប៉ាគ់ គួយ ហះ ស្រុក តេះ អេបិល មេហូឡា ឡាក់ អ្វៃ ក្យាម័ ស្រុក តេះ តាបាត់។ ");
INSERT INTO tpu_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","គេឌៀន ប៉្រើ ពូ ឡាំ រ៉ះ កា សុនសាត អ៊ីស្រាអ៊ែល ឡាក់ ផូង័ វ៉ាច់ ណាប់ថាលី ផូង័ វ៉ាច់ អាស៊ើរ លូ ផូង័ វ៉ាច់ ម៉ាណាសេ ទិណោ័ះ អន់ ប៉ាតុំ គួប ពឹះ តាយ៉ិប សុនសាត ម៉ាឌៀន។ ");
INSERT INTO tpu_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","អ៊ែ កា ប៉្រើ ពូ ឡាំ រ៉ះ កា មួត ស្រុក តេះ ប៉ានឹម អេប៉្រាអ៊ីម ទិណោ័ះ ផា «ហគ់ ប៉ាណាំ គួប ជឹរ វ៉ាត់ ទ្រង មួត ម៉ាឌៀន រហាង ទ្រូង ទៀក ទិណោ័ះ ឡាក់ ចារ ពូ ឃ្លង លើយ អន់ ទឹល ប៉ាគ់ បេតបារ៉ា លូ ទៀក ទ្រូង យដាន់»។ ផូង័ វ៉ាច់ អេប៉្រាអ៊ីម ទិណោ័ះ កា ប៉ាណាំ គួប ឡាំ ក្រាប់ រហាង ទៀក ទិណោ័ះ លើយ ទឹល ប៉ាគ់ បេតបារ៉ា លូ ទៀក ទ្រូង យដាន់ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","អន់ឌែ កា រ៉ុប ម៉ៃគ ណាំផា មួត សុនសាត ម៉ាឌៀន ទិ ពៀរ ដូវ ឃឺ អូរិប លូ សៀប។ ពូ ប៉ាន់តោ័ អូរិប ហះ ចារ អំហ្មោ ពូ កា អន់ សិច ចារ ណោះ ផា អំហ្មោ អូរិប។ កេះណោះ ពូ ប៉ាន់តោ័ សៀប ហះ ចារ ឡូះ រ៉ូត័ ប៉្លៃ អង់កាច ពូ កា អន់ សិច ចារ ណោះ ផា ឡូះ រ៉ូត័ ប៉្លៃ អង់កាច សៀប។ កេះណោះ អន់ឌែ តាយ៉ិប សុនសាត ម៉ាឌៀន ណាវ្គ។ ពូ កា អ្យក់ កល់ អូរិប លូ សៀប ជឹន កា គេឌៀន អ្វៃ ប៉ាគ់ ហាង តោ ទ្រូង យដាន់។ ");
INSERT INTO tpu_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","ផូង័ វ៉ាច់ អេប៉្រាអ៊ីម កាប កា គេឌៀន ផា «ខ ញ៉ា បះ អីស ប៉្រគ័ កា ញឹន នីអៀ ? ផះ អីស ឡាំ តាកូះ លូ សុនសាត ម៉ាឌៀន ញ៉ា ត្រគ់ អីស អូ អើ ញឹន ឡាំ អន់ឌូ ?» អន់ឌែ កាប អឺក កា គេឌៀន កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","គេឌៀន កា តើល អន់ឌែ ផា «សារ អុះ ម៉ី ប៉្រគ័ អា ដាគ់ កាខាក់ ក្វា ឡឹង សារ អាញ់ ចាយ័ សាំ។ អឺ ផូង័ វ៉ាច់ អេប៉្រាអ៊ីម យ‌៉័ះ អន់ដីស តាកូះ តុ សិត តុ ង៉ិត កាតាម កា ដាគ់ ហ៊្លត ឡឹង សារ តាកូះ ផូង័ វ៉ាច់ អាបៀស៊ើរ អាញ់ សាំ។ ");
INSERT INTO tpu_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","ប‌៉្រ័ះ ប៊កកាតយ័ មប អូរិប លូ សៀប ឡាក់ ម៉ៃគ ណាំផា សុនសាត ម៉ាឌៀន ពឹង តី អុះ ម៉ី កេះ អាញ់ ប៉្រគ័ អូ សាម៉ើ លូ សារ អុះ ម៉ី ប៉្រគ័ ណោះ អុះ»។ ប៉ាគ់ កាតាំង គេឌៀន កាប នីណោ័ះ អន់ឌែ កា អូ អឺក ហង។ ");
INSERT INTO tpu_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","ផះ អន់ទ្រួល ពែ គេឌៀន លូ តាហាន ៣០០ ដូវ ឡាំ ទឹល ប៉ាគ់ ហាង ទៀក ទ្រូង យដាន់ អន់ឌែ កា ឃ្លង ឡាំ ប៉ាគ់ ហាង តោ។ យ‌៉័ះ អន់ឌែ ក្លេ័ះ នីចម័ កាតាម កា អន់ឌែ អ្វៃ កា តាយ៉ិប ពួយ មួត តាម៉ឺរ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","ប៉ាគ់ អន់ឌែ ឡាំ ទឹល មឿង ស៊ុកូត គេឌៀន កាកាប លូ មួត មឿង ណោះ ផា «ប៉រ់ អន់ដីស អន់ ណុំ ប៉ាំង កា មួត តាហាន ចាក ពួយ អាញ់ អា ណើ ខង អន់ឌែ ក្លេ័ះ ទឹប ឡាយ៉ិត ឡក់ កេះ ញឹន ផះ តាយ៉ិប សេបះ លូ សាលមូណា ឡាក់ សាដាច់ សុនសាត ម៉ាឌៀន»។ ");
INSERT INTO tpu_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","ហះកា ម៉ៃគ ណាំផា មឿង ស៊ុកូត ណោះ តើល អ៊ែ ផា «ញ៉ា អីស រ៉ុប សាដាច់ សេបះ លូ សាលមូណា ទី កេះ ប បះ ញឹន ត្រគ់ អ្យក់ សាណា អន់ កា តាហាន អីស សា ?» ");
INSERT INTO tpu_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","គេឌៀន តើល អន់ឌែ ផា «ប៉ាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ មប សេបា លូ សាលមូណា ពឹង តី អាញ់ កេះ អាញ់ ចឹង វ៉ីល សឹត អ្យក់ សាលៀ ពីត សាប៉្វាត័ អន់ដីស ឡូត»។ ");
INSERT INTO tpu_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","គេឌៀន កា ឡាច់ ឡឹង មឿង ណោះ ឡាំ ប៉ាគ់ មឿង ប៉ានីអ៊ែល អ៊ែ កា ប៉រ់ សាណា ឡឹង មួត មឿង ណោះ ឡាក់ កា អ៊ែ ប៉រ់ ឡឹង មួត មឿង ស៊ុកូត អំពែ ដេល ហះកា អន់ឌែ តើល ឡាក់ កា មួត មឿង ស៊ុកូត ទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","គេឌៀន កាប កា មួត មឿង ប៉ានីអ៊ែល ផា «ប៉ាគ់ អាញ់ តាកូះ ចាយ័ ទ្រង អាញ់ កេះ អាញ់ ចឹង សឹត ថាំឡាយ អ្លាត ហី ចាំងហីគ ឡាក់ ចារ អន់ដីស អ្វៃ ញ៉ាម អា»។ ");
INSERT INTO tpu_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","កាប៉ាច់ សាដាច់ សេបះ លូ សាដាច់ សាលមូណា កា សាតាក់ ទឹល ប៉ាគ់ ព្រី កើកូរ អន់ឌូ លូ មួត តាហាន អន់ឌែ ១៥.០០០ ដូវ ឡាក់ អ្វៃ សល់ ឡឹង មួត តាហាន ឡាក់ ពឹះ ឡឹង ដារ់ ឡាច់ ហះកា តោ័ ទិ ១២០.០០០ ដូវ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","គេឌៀន កា ចាក ពួយ ទ្រង មួត ប្រូ ប្រី ទ្រង ណោះ គែង ដារ់ ឡាច់ តេះ ណូបះ លូ តេះ យ៉ុកបិហា កេះណោះ ម៉ុត តាកូះ លូ មួត តាម៉ឺរ ឡាក់ អន់ឌែ សាម៉គ័ ផា អន់ឌែ រ៉ាវ៉ាច់ ឡាកោ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","សេបះ លូ សាលមូណា ឡាក់ សាដាច់ សុនសាត ម៉ាឌៀន អន់ឌែ សាតាក់ អោន ហះកា គេឌៀន តាយ៉ិប រ៉ុប សាដាច់ ណោះ ទី ទិ ពៀរ ដូវ ទឹប តាកូះ លូ តាហាន សាដាច់ ណោះ ចាយ័ ទ្រង អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","គេឌៀន គន វគ័ យ៉ូអះ សឹត ឡឹង តាកូះ ចាក ទ្រង ប៉ានឹម ហេរេះ។ ");
INSERT INTO tpu_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","ផះ ណោះ គេឌៀន រ៉ុប តាតាម័ ម៉ោញ ដូវ ឡឹង មឿង ស៊ុកូត ភឿ អ្យក់ ឡាំ អំប៉ញ់ ទឹប ប៉្រើ អ៊ែ ច្រាគ់ សិច ម៉ៃគ ណាំផា លូ ក្រាគ់ តាំងកង់ ឡាក់ អ្វៃ ពឹង មឿង ណោះ ទី ចំលួន ៧៧ ដូវ។ ");
INSERT INTO tpu_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","កេះណោះ គេឌៀន ឡាំ ប៉ាគ់ មឿង ស៊ុកូត លូ កាប កា មួត អ្វៃ ពឹង មឿង ណោះ ផា «អា ហង សាដាច់ ឡាក់ អន់ដីស កាប កា អាញ់ ទឹប បឺង៉ាយ ផា \"ញ៉ា អីស រ៉ុប សាដាច់ សេបះ លូ សាលមូណា ទី កេះ ប បះ ញឹន ត្រគ់ អ្យក់ សាណា អន់ កា មួត តាហាន អីស ឡាក់ ឡាយ៉ិត ក្លេ័ះ ណោះ ?\"» ");
INSERT INTO tpu_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","គេឌៀន រ៉ុប មួត ក្រាគ់ តាំងកង់ អ្វៃ ពឹង មឿង ណោះ កេះណោះ អ្យក់ សាលៀ ពីត សាប៉្វាត័ អន់ឌែ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","អ៊ែ កា ថាំឡាយ ហី ចាំងហីគ សាំរ៉ាប់ ញ៉ាម ពឹង មឿង ប៉ានីអ៊ែល ទឹប ប៉ាន់តោ័ មួត កាម៉ាក័ អ្វៃ ពឹង មឿង ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","កេះណោះ គេឌៀន អំប៉ញ់ លូ សាដាច់ សេបះ លូ សាដាច់ សាលមូណា ផា «ប៉ាណូស ឡាក់ អន់ដីស ប៉ាន់តោ័ ប៉ាគ់ ប៉ានឹម តាបោរ ពែ ប៉ាណូស នីចម័ អន់ឌែ ណោះ ?» អន់ឌែ រ៉ះ ផា «មួត ណោះ ម៉ូះ ម៉ាត់ ឡាក់ កា អីស ដេល អន់ឌែ ឡាក់ កា គន សាដាច់»។ ");
INSERT INTO tpu_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","គេឌៀន កាប ផា «អន់ឌែ ឡាក់ អុះ ម៉ី ម៉ោញ ម៉ៃគ លូ អាញ់។ សារ អាញ់ រ៉ះ អា កា តាទឹច ហង ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ រ៉ីស ដេល ផា អន់ដីស អូ ប៉ាន់តោ័ មួត ណោះ ពែ អាញ់ កា អូ ប៉ាន់តោ័ អន់ដីស ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","កេះណោះ គេឌៀន កា ប៉្រើ យេធើរ ឡាក់ គន ឡោងទ្រៀ អ៊ែ ផា «ហគ់ ប៉ាន់តោ័ អ្លាត មួត អា ពិ»។ ហះកា គន អ៊ែ អូ ខឹន ហ្វាត់ ដាវ អុះ ខង អ៊ែ អ្វៃ សាស្វា។ ");
INSERT INTO tpu_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","សាដាច់ សេបះ លូ សាដាច់ សាលមូណា កាប លូ គេឌៀន ផា «អីស ប៉ាន់តោ័ ញឹន លូ តី អីស តាំងឡា ពិ ផា អីស កេង»។ ផះ ណោះ គេឌៀន កា អ្យូវ ប៉ាន់តោ័ សាដាច់ ណោះ ឡូត កេះណោះ តាឡេះ អ្យក់ ម៉ៃគ សាស៊យ ម៉ាស ឡឹង អង់កូ អូត អន់ឌែ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","ឡៃង ឡឹង ណោះ សុនសាត អ៊ីស្រាអ៊ែល កា កាប លូ គេឌៀន ផា «ប៉រ់ អីស តាប៉ាប តាប៉ុន រ៉ាំងហៃ រ៉ាំងខ្យា ញឹន លើយ អន់ ទឹល គន សោ អីស ខង អីស តង័ ញឹន អន់ រ៉ាវ៉ាច់ ឡឹង តី មួត ម៉ាឌៀន»។ ");
INSERT INTO tpu_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","គេឌៀន កា តើល អន់ឌែ ផា «អូ អុះ អាញ់ អូ រ៉ាំងហៃ រ៉ាំងខ្យា អន់ដីស អុះ យ‌៉័ះ គន អាញ់ កា អូ រ៉ាំងហៃ រ៉ាំងខ្យា អន់ដីស ដេល ឃឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ រ៉ាំងហៃ រ៉ាំងខ្យា អន់ដីស ទិឌូ»។ ");
INSERT INTO tpu_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","គេឌៀន កា រ៉ះ លូ អន់ឌែ ណាវ្គ ផា «អាញ់ ទី សារ ម៉ោញ ប៉រ់ ឡឹង អន់ដីស ប៉រ់ អន់ដីស ទិឌូ អន់ កាជន ម៉ាស ឡាក់ អន់ដីស អ្យក់ ឡឹង មួត តាម៉ឺរ ណោះ អន់ កា អាញ់ ឡគ ពិ»។ សុនសាត ម៉ាឌៀន ទិណោ័ះ ទី កាជន ម៉ាស ញន កា អន់ឌែ គន សោ វគ័ អ៊ីសាម៉ាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","សុនសាត អ៊ីស្រាអ៊ែល តើល ផា «ញឹន ចឹង អន់ ទឹប ពុត ហោក រ៉គ់»។ អន់ឌែ កា រ៉ីស អាវ ម៉ោញ ត្រាក័ ពឹង តេះ អន់ឌែ កា អ្យក់ កាជន ពឿ កាជន អ៊ែ ឡាក់ កា អន់ឌែ អ្យក់ ឡឹង មួត តាម៉ឺរ ចៃគ ពឹង អាវ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","កាជន ម៉ាស ទិណោ័ះ ឡាក់ គេឌៀន ប៉រ់ ឡឹង ពូ ណោះ ទី ២០ កាឡូ។ អ៊ែ កា ទី ឃឿង ខង សាស៊យ ម៉ាស លូ អាវ នែវ កាហ្រី ណាំអ៊ិត ម៉ះ សាដាច់ សុនសាត ម៉ាឌៀន ទឹប ម៉ៃគ សាស៊យ ម៉ាស ពូ ចៃគ ពឹង អង់កូ អូត ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","គេឌៀន អ្យក់ ម៉ាស ទិណោ័ះ តូះ ប៉្រគ័ ហ៊ូប ប‌៉្រ័ះ ម៉ោញ កាតុ កេះណោះ អ៊ែ អន់ ពឹង ស្រុក តេះ អូប៉្រា ឡាក់ ស្រុក អ៊ែ កើត ណោះ ហង បះ សុនសាត អ៊ីស្រាអ៊ែល ប៉ាណាំ គួប ប៉្រគ័ យច លូ ប‌៉្រ័ះ ប៊កកាតយ័ ពៀប ឡាក់ កា កាម៉ាញ់ រ៉ាលង កល់ ក្លោ ញន កា អន់ឌែ ប៉ិច ហ៊ូប ប‌៉្រ័ះ ណោះ។ ហ៊ូប ប‌៉្រ័ះ ណោះ ពៀប ឡាក់ កា សាទួង ត្រគ់ គេឌៀន លូ ខាប់ខួ អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","គឹត ឡឹង គេឌៀន តាកូះ លូ សុនសាត ម៉ាឌៀន ចាយ័ ទ្រង អ៊ែ អន់ឌែ អូ ខឹន ប៉ាសាំង លូ សុនសាត អ៊ីស្រាអ៊ែល អុះ។ ផះ រ៉ាំងហាវ គេឌៀន ណោះ ប៉ាថេត ណោះ កា ទី សារ សាណុក សាវ៉ាក ទុញ ៤០ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","យេរូបាល គន វគ័ យ៉ូអះ កា អ្វៃ ពឹង ហី អ៊ែ ទៅ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","អ៊ែ កា ទី គន កាម៉ាក័ ទិណោ័ះ ៧០ ដូវ ញន កា អ៊ែ ទី កាម៉ាញ់ អៀង។ ");
INSERT INTO tpu_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","អ៊ែ កា ទី មួត អង់កាន់ អន់ទៀគ ណាវ្គ អង់កាន់ អ៊ែ ម៉ោញ ដូវ ឡាក់ អ្វៃ ប៉ាគ់ មឿង ស៊ីគែម អ៊ែ កា ទី គន កាម៉ាក័ ម៉ោញ ដេល គេឌៀន អន់ សិច ផា អាប៊ីម៉ាឡេក។ ");
INSERT INTO tpu_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","គេឌៀន គន វគ័ យ៉ូអះ អ៊ែ អ្វៃ រ៉ីស ទុញ ទឹប ទី សារ សាណុក សាវ៉ាក អន់តីគ ឡឹង ណោះ អ៊ែ កា តោ័ ហង។ ពូ អ្យក់ អ៊ែ តប់ ពឹង រ៉ូង័ អន់ឌូ លូ វគ័ យ៉ូអះ ឡាក់ ប៉ាទ្រូ ពឹ អ៊ែ ប៉ាគ់ អូប៉្រា ពឹង តេះ ផូង័ វ៉ាច់ អាបៀស៊ើរ។ ");
INSERT INTO tpu_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","អន់តីគ ឡឹង គេឌៀន តោ័ កេះ សុនសាត អ៊ីស្រាអ៊ែល ប៉ាណាំ គួប ប៉្រគ័ យច លូ ប‌៉្រ័ះ ប៊កកាតយ័ ម៉ោញ ទង ណាវ្គ អន់ឌែ អ្យិល កូត័ កា ប‌៉្រ័ះ បាល ទឹប អ្យក់ ប‌៉្រ័ះ បាល បេរីត ប៉្រគ័ ប‌៉្រ័ះ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","អន់ឌែ អូ កាចាំង កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ឌែ ឡាក់ តង័ អន់ឌែ អន់ រ៉ាវ៉ាច់ ឡឹង តាម៉ឺរ ឡាក់ អ្វៃ ជុំ អន់ឌែ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","អន់ឌែ អូ កាចាំង តោរ កា ខាប់ខួ យេរូបាល អើ ផា គេឌៀន ឡឹង សារ ដាគ់ ទិណោ័ះ ឡាក់ អ៊ែ ប៉្រគ័ អន់ កា សុនសាត អ៊ីស្រាអ៊ែល អុះ។ … ");
INSERT INTO tpu_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","សុនសាត អ៊ីស្រាអ៊ែល ប៉្រគ័ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាឡក់ ណាវ្គ ញន ណោះ ហង បះ ប‌៉្រ័ះ ប៊កកាតយ័ មប អន់ឌែ ពឹង តី មួត សុនសាត ភីលីសាទីន ទុញ ៤០ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","ផះ រ៉ាំងវ៉ាង ណោះ ពឹង តេះ សូរ៉ះ ទី កាម៉ាក័ សិច ម៉ាណូអា ពឹង ផូង័ វ៉ាច់ ដាន់ កាម៉ាញ់ អ៊ែ ឡាក់ អង់កាន់ អូ អ្លុ ទី គន អុះ។ ");
INSERT INTO tpu_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","ប‌៉្រ័ះ ប៊កកាតយ័ តាំបាង ឡាកោ ឡាក់ កា ប៉ាណូស អន់ អង់កាន់ ណោះ ប៉ប័ កេះណោះ កាប ផា «អឺ ណាង អីស ឡាក់ អង់កាន់ អូ អ្លុ ទី គន អុះ ហះកា អីស ចឹង ឡាកោ គៀម អ្វៃ ហាអុញ ទី គន កាម៉ាក័។ ");
INSERT INTO tpu_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","អ្យក់ ឡឹង ដារ់ អា ត្រគ់ ឡាវ៉ាំង ជែ អៃត តាពែ លូ ជែ សា សាណា ញ៉ា ឡាក់ ចាបាប់ អូ អន់ សា ដេល ");
INSERT INTO tpu_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","ខង អីស ឡាកោ គៀម កេះ ចឹង អ្វៃ ហាអុញ ទី គន កាម៉ាក័ ហះកា អីស អូ ត្រគ់ កូរ័ កល់ លូ កាត់ សក់ អ៊ែ អុះ ខង អ៊ែ ចឹង ប៉្រគ័ ណាសារីត សាំរ៉ាប់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡឹង អ្វៃ កាណុង វ៉ាច់ មើគ អ៊ែ គន ណោះ ចឹង តង័ សុនសាត អ៊ីស្រាអ៊ែល អន់ រ៉ាវ៉ាច់ ឡឹង តី មួត សុនសាត ភីលីសាទីន»។ ");
INSERT INTO tpu_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","អង់កាន់ ណោះ កា ឡាំ រ៉ះ លូ ក្លោ អ៊ែ ផា «ទី បក់ រ៉ះ ប៉ាតាង ប‌៉្រ័ះ ប៊កកាតយ័ ម៉ោញ ដូវ ពឹះ ប៉ាគ់ ចារ អាញ់ ត្រង័ ទ្រៀយ អ៊ែ ឡាក់ កា ប៊យ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ អាញ់ កាខរ់ ណូស កាខាក់។ អាញ់ កា អូ ទី អំប៉ញ់ លូ អ៊ែ អុះ ផា អ៊ែ ពឹះ ឡឹង ចំ អ៊ែ ណោះ កា អូ រ៉ះ អន់ អាញ់ អន់ហ្នាល់ សិច អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","អ៊ែ រ៉ះ កា អាញ់ ផា អាញ់ គៀម កេះ ប៉ាគ់ អ្វៃ ហាអុញ ចឹង ទី គន កាម៉ាក័ អ៊ែ អូ អន់ អាញ់ អៃត តាពែ អុះ លូ អូ អន់ អាញ់ សា សាណា ញ៉ា ឡាក់ ចាបាប់ អូ អន់ សា ដេល ញន កា គន ណោះ ត្រគ់ ប៉្រគ័ ណាសារីត សាំរ៉ាប់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡឹង អ្វៃ កាណុង វ៉ាច់ អាញ់ លើយ ទឹល ឡុច អាញុ អ៊ែ»។ ");
INSERT INTO tpu_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","កេះណោះ វគ័ ម៉ាណូអា ម៉ន់ អើ ប‌៉្រ័ះ ប៊កកាតយ័ ផា «អឺ ប‌៉្រ័ះ តាំងឡា ប៉រ់ អីស តាប៉ាប តាប៉ុន ប៉្រើ ទុច អីស ឡាក់ ពឹះ ប៉ាគ់ ចារ ញឹន ពែ ពឹះ ម៉ោញ ទង ណាវ្គ ភឿ អន់ អ៊ែ អន់តគ់ ឡឹង ឡាបៀប ត្រគ់ រ៉ាំងហៃ គន បក់ ចឹង កើត ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","ប‌៉្រ័ះ ប៊កកាតយ័ សាំយ៉ាំង សារ វគ័ ម៉ាណូអា ម៉ន់ ណោះ កេះណោះ អ៊ែ ជឹរ ពឹះ ប៉ាគ់ ចារ អង់កាន់ ណោះ ម៉ោញ ទង ណាវ្គ ផះ អ៊ែ អ្វៃ ប៉ាគ់ ម៉ីរ ផះ ណោះ ក្លោ អ៊ែ វគ័ ម៉ាណូអា អូ ទី អ្វៃ អន់ឌូ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","អ៊ែ ប៉ាន់តាន សាតាក់ ឡាំ រ៉ះ កា ក្លោ អ៊ែ ផា «តោ ហង កាម៉ាក័ បក់ ពឹះ ប៉ាគ់ ចារ អាញ់ ដារ់ ណោះ ពែ អ៊ែ តាំបាង អន់ អាញ់ ប៉ប័ ម៉ោញ ទង ណាវ្គ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","វគ័ ម៉ាណូអា កា អ្យូវ ចាក ពួយ កាម៉ាញ់ អ៊ែ ឡាំ ប៉ាគ់ ចារ កាម៉ាក័ ណោះ ឡូត កេះណោះ អំប៉ញ់ ផា «ញ៉ា អីស ហង ប កាប លូ កាម៉ាញ់ អាញ់ ពែ ?» ប‌៉្រ័ះ កា តើល ផា «អឺះ អាញ់ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","វគ័ ម៉ាណូអា អំប៉ញ់ ណាវ្គ ផា «ផា សារ ណោះ កើត ពឹះ ឡាក់ កា ប៉ានឹរ អីស ផា តាទឹច គន ណោះ ចឹង ត្រគ់ ប៉្រគ័ ពួយ ចាបាប់ ញ៉ា អន់ដា ? អ៊ែ ចឹង ត្រគ់ ប៉្រគ័ ង៉ារ ញ៉ា អន់ដា ?» ");
INSERT INTO tpu_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","ប‌៉្រ័ះ ប៊កកាតយ័ តើល វគ័ ម៉ាណូអា ណាវ្គ ផា «កាម៉ាញ់ អីស ត្រគ់ កំ ទិ កាណាគ័ ញ៉ា ឡាក់ កា អាញ់ រ៉ះ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","អ៊ែ អូ ត្រគ់ សា សាណា ញ៉ា ឡាក់ ប៉្រគ័ លូ ប៉្លៃ អង់កាច អុះ កា អូ ត្រគ់ អៃត តាពែ ញ៉ា អុះ កា អូ ត្រគ់ សា សាណា ញ៉ា ឡាក់ ចាបាប់ អូ អន់ សា ដេល។ កាម៉ាញ់ អីស ត្រគ់ ប៉្រគ័ ពួយ ប៉ានឹរ អាញ់ រ៉ះ ទិណោ័ះ»។ ");
INSERT INTO tpu_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","វគ័ ម៉ាណូអា កាប លូ ប‌៉្រ័ះ ប៊កកាតយ័ ផា «អ្យគ័ អីស អ្វៃ ក្យាគ់ ហះ អា ប៊ែត ហោគ ញឹន ចឹង ឡាំ អ្យក់ គន ប៉ារ់ពេ ម៉ោញ ប៉្រគ័ សាអ៊្លង អន់ កា អីស សា»។ ");
INSERT INTO tpu_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","ប‌៉្រ័ះ ប៊កកាតយ័ តើល ផា «យ‌៉័ះ អាញ់ អ្វៃ ក្យាគ់ ហះ អា កា អាញ់ អូ សា សាណា អន់ដីស ប៉្រគ័ ណោះ អុះ។ ហះកា ផា អីស ចៃ អ្យក់ ប៉ារ់ពេ ណោះ ពុះ អ្លាត ទិ សាំរ៉ាប់ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡគ ពិ»។ វគ័ ម៉ាណូអា អូ អ្លុ អន់តគ់ កា ប‌៉្រ័ះ ប៊កកាតយ័ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","អ៊ែ អំប៉ញ់ ផា «ពឿ សិច អីស ? អីស រ៉ះ ហៃ អន់ ញឹន អ្លុ សិច អីស ភឿ ម៉ាគ់ ញឹន ប៉ានេ អីស ប៉ាគ់ សារ ណោះ កើត ពឹះ ឡាក់ កា ប៉ានឹរ អីស កាប»។ ");
INSERT INTO tpu_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","ប‌៉្រ័ះ ប៊កកាតយ័ តើល ផា «ញ៉ា អីស ប៉ិច កា អ្លុ សិច អាញ់ នីអៀ ? សិច អាញ់ អា រ៉គ់ កេង ខាក់»។ ");
INSERT INTO tpu_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","ទឹល នីណោ័ះ វគ័ ម៉ាណូអា កា អ្យក់ គន ប៉ារ់ពេ លូ តាប៉ុង ឡាក់ ត្រគ់ រ៉ាម៉ះ អន់ឌូ ពុះ អ្លាត ពឹង អំហ្មោ រ៉ាម៉ះ អន់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ។ ផះ វគ័ ម៉ាណូអា លូ កាម៉ាញ់ អ្វៃ ហៃ ផាឌី កា ទី សារ អំរ៉ាញ អឺញ។ ");
INSERT INTO tpu_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","ផះ អុញ កីត ពឹង អន់ហ្នឹង ប៉្រគ័ លូ អំហ្មោ ណោះ អំប៉្យិត អុញ កា កីត ហាវ ទឹល ប៉្លៃង ប‌៉្រ័ះ ប៊កកាតយ័ កា ហាវ ពួយ អំប៉្យិត អុញ ណោះ ដេល។ ផះ វគ័ ម៉ាណូអា លូ កាម៉ាញ់ អ៊ែ ប៉ប័ នីណោ័ះ អន់ឌែ សាំប‌៉័ះ កុប កល់ ទឹះ តេះ។ ");
INSERT INTO tpu_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","ប៉ាគ់ អន់ឌែ ហៃ ប‌៉្រ័ះ ប៊កកាតយ័ អូ ប៉ប័ កេះ វគ័ ម៉ាណូអា កា អ្លុ អន់តគ់ ផា ប‌៉្រ័ះ ប៊កកាតយ័ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","អ៊ែ កា កាប លូ កាម៉ាញ់ អ៊ែ ផា «ពិន ចាបះ កា តោ័ ហង ខង ពិន ប៉ប័ ប‌៉្រ័ះ ប៊កកាតយ័»។ ");
INSERT INTO tpu_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","កាម៉ាញ់ អ៊ែ តើល ផា «ផា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ិច កា ពិន តោ័ តាទឹច អ៊ែ អូ អ្យក់ កាណាគ័ លូ តាប៉ុង ពិន រ៉ាម៉ះ អា អុះ កា អូ តាំបាង សារ អំរ៉ាញ អឺញ ទិណោ័ះ អន់ ពិន ប៉ប័ ទឹប អូ រ៉ះ ឡឹង សារ ញ៉ា ឡាក់ ពិន កាតាំង ទិណោ័ះ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","កាម៉ាញ់ វគ័ ម៉ាណូអា កា អ្វៃ ហាអុញ កើត គន កាម៉ាក័ អ៊ែ អន់ សិច ផា សាំសុន។ ប៉ាគ់ គន ណោះ តីស កេះ ប‌៉្រ័ះ ប៊កកាតយ័ កា អន់ សារ ដាគ់ កា អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","ផះ សាំសុន អ្វៃ ប៉ាគ់ តេះ ម៉ាហានេ ដាន់ ពឹង តាវ៉ាង័ តេះ សូរ៉ះ លូ តេះ អ៊ែសាថោល ប៉ាង៉ាត័ ប៉ាលឹង ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉្រគ័ ង៉ារ ពឹង ឡាកោ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","សាំសុន កា ឡាំ ប៉ាគ់ តេះ ធីមណា ផះ អ្វៃ ប៉ាគ់ ណោះ អ៊ែ ប៉ប័ អង់កាន់ រ៉ូះ សុនសាត ភីលីសាទីន ម៉ោញ ដូវ។ ");
INSERT INTO tpu_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","ប៉ាគ់ សឹត ទឹល ហី កេះ អ៊ែ កា រ៉ះ លូ មើគ ពឹ អ៊ែ ផា «អាញ់ ប៉ិច កា អង់កាន់ រ៉ូះ សុនសាត ភីលីសាទីន ម៉ោញ ដូវ អ្វៃ ប៉ាគ់ តេះ ធីមណា អន់ដីស ឡាំ អំប៉ញ់ អង់កាន់ ណោះ កា អាញ់ ណើ ខង អាញ់ ប៉ិច ទី អង់កាន់ ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","ហះកា ពឹ មើគ កាប កា អ៊ែ ផា «កាណុង អុះ ម៉ី សុនសាត ពិន អា ញ៉ា អូ ទី អង់កាន់ រ៉ូះ ប បះ គន ប៉ិច ទី អង់កាន់ សុនសាត ភីលីសាទីន ឡាក់ សុនសាត អន់ទៀគ នីអៀ ?» ហះកា សាំសុន កាប លូ ពឹ អ៊ែ ផា «អីស ឡាំ អំប៉ញ់ អង់កាន់ ណោះ ពិ ខង អាញ់ ប៉ិច ដឹង កា អង់កាន់ ម៉ោញ ដូវ ណោះ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","ពឹ មើគ សាំសុន អូ អ្លុ អន់តគ់ អុះ ផា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ សាំសុន ទី ពុត នីណោ័ះ ភឿ ណាំង សារ លូ សុនសាត ភីលីសាទីន ខង ផះ រ៉ាំងហាវ ណោះ សុនសាត ភីលីសាទីន ប៉្រគ័ ម៉ៃគ រ៉ាំងហៃ សុនសាត អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","ឡៃង ឡឹង ណោះ សាំសុន ចាក ឡាំ ប៉ាគ់ តេះ ធីមណា អន់ឌូ លូ ពឹ មើគ អ៊ែ។ ប៉ាគ់ ទឹល ម៉ីរ ប៉្លៃ អង់កាច ក្យាម័ តេះ ធីមណា ផាឌី ទី ក្លា ផះ ប៉ាញ័ តាម័ ម៉ោញ ក្រាញ័ តាឡូះ កា សាំសុន។ ");
INSERT INTO tpu_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","ផាឌី ប៊ែត ឡឹង ណោះ ប៉ាង៉ាត័ ប៉ាលឹង ប‌៉្រ័ះ ប៊កកាតយ័ កា ម៉ុត ពឹង សាំសុន ប៉្រគ័ អន់ អ៊ែ ទី សាងុំ រ៉ុប វ៉ាក ពឹរ ប៉ាន់តោ័ ក្លា ណោះ ឡាក់ កា ពូ វ៉ាក ពឹរ គន ប៉ារ់ពេ ហះកា ពឹង តី អ៊ែ អូ ទី ចឹក ញ៉ា អុះ។ សារ ណោះ អ៊ែ អូ ទី រ៉ះ លូ ពឹ មើគ អ៊ែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","កេះណោះ សាំសុន កា ចាក ឡាំ ណាវ្គ ទឹល ប៉ាគ់ តេះ ធីមណា អ៊ែ កា កាប លូ អង់កាន់ រ៉ូះ ភីលីសាទីន ណោះ អ៊ែ ប៉ាញ័ ពុត កា អង់កាន់ ណោះ ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","ទុញ ដារ់ ឡឹង ណោះ ប៊ែត អ៊ែ កា ឡាំ ប៉ាគ់ តេះ ធីមណា ណាវ្គ ភឿ ចឹង ឡាំ ប៉ាញ់សង់ លូ អង់កាន់ ណោះ។ ផះ ចាក រទ្រង ណោះ អ៊ែ កា វ៉េះ ម៉ុត ហៃ កាម៉ាប់ ក្លា អ៊ែ ប៉ាន់តោ័ ពែ ផាឌី ប៉ប័ គ្រត ប៉្រគ័ ហី កាណុង កាម៉ាប់ ក្លា ណោះ ផះ ឡាកោ។ ");
INSERT INTO tpu_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","អ៊ែ កា ពួត អ្យក់ ម៉ល់ គ្រត ណោះ អន់ដា ចឹក ចាក អន់ដើរ សា អន់ដើរ។ ប៉ាគ់ អ៊ែ ទឹល ប៉ាគ់ ចារ ពឹ មើគ កេះ អ៊ែ កា អន់ កា អន់ឌែ សា ដេល ហះកា អូ ទី រ៉ះ ផា អ៊ែ អ្យក់ គ្រត កាណុង កាម៉ាប់ ក្លា ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","ពឹ សាំសុន កា ឡាំ ប៉ាគ់ ហី គែង អង់កាន់។ សាំសុន កា ទ្រៀម អៃត សា ហះ ណោះ គុន ពូ ប៉ាញ់សង់ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","ប៉ាគ់ សុនសាត ភីលីសាទីន ប៉ប័ អ៊ែ អន់ឌែ កា រ៉ើស មួត តាតាម័ ៣០ ដូវ អន់ ពឹះ អង់រ៉ើង អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","សាំសុន កា កាប លូ មួត តាតាម័ ណោះ ផា «អាញ់ ទី សារ ម៉ោញ ប៉ិច វ៉ាម លូ អន់ដីស ទិឌូ ផា អន់ដីស រ៉ះ ត្រគ់ កាណុង តាំប៉ើះ ដារ់ រ៉ាំងវ៉ាង ដារ់ ប៉ាញ់សង់ អាញ់ អា អាញ់ ចឹង អន់ ខោ អាវ ៣០ ប្ល‌៉័ះ កា អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","ផា រ៉ះ អូ ត្រគ់ អន់ដីស ទិឌូ ត្រគ់ អន់ ខោ អាវ កា អាញ់ ៣០ ប្ល‌៉័ះ និះទៅ ដេល»។ អន់ឌែ តើល ផា «ហគ់ អីស វ៉ាម អន់ កា ញឹន សាំយ៉ាំង ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","សាំសុន កា វ៉ាម ផា៖ «ទី សាណា ឡាច់ ឡឹង បក់ ម៉ាម ទី កាណាគ័ អាម ឡាច់ ឡឹង បក់ កេង កាណាគ័ ញ៉ា ណោះ ប៉ឹះ ?»។ មួត តាតាម័ កា ណាំង ទ្រង ចឹង រ៉ះ ទិ ប៉ៃង ដារ់ កេះ អ្វៃ កា អូ អ្លុ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","ប៉ាគ់ ទឹល ដារ់ ទី ប៉្វាន់ អន់ឌែ កា ឡាំ កាប ប៉ាំងអ្យូគ កាម៉ាញ់ សាំសុន ផា «ហគ់ ឡាំ ប៉ាឡោម ក្លោ អីស ប៉្រើ រ៉ះ ឡឹង សារ អ៊ែ វ៉ាម ណោះ កេះណោះ ពឹះ រ៉ះ កា ញឹន អន់ អ្លុ អន់តគ់។ ផា អីស អូ ប៉្រគ័ ពួយ សារ ញឹន ប៉្រើ អា ញឹន ចឹង សុះ អីស ទឹប ខាប់ខួ ហី ក្រាន អីស អន់ តោ័ ទិឌូ ឡូត។ អន់ដីស អើ ញឹន ពឹះ ភឿ រ៉ាត អ្យក់ រ៉ាស ឡឹង ញឹន ប ?» ");
INSERT INTO tpu_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","កាម៉ាញ់ សាំសុន កា ញ៉ាំ ហះ ម៉ាត់ ក្លោ អ៊ែ លូ កាប ផា «អីស អូ ណីស អូ ប៉ិច កា អាញ់ អុះ បះ អីស វ៉ាម អន់ កា សុនសាត អាញ់ ហះកា អីស អូ ទី រ៉ះ ឡឹង សារ វ៉ាម ណោះ អន់ កា អាញ់ អ្លុ អុះ»។ សាំសុន តើល កាម៉ាញ់ អ៊ែ ផា «យ‌៉័ះ ពឹ មើគ អាញ់ កា អាញ់ អូ រ៉ះ អុះ ខ ញ៉ា បះ អាញ់ ចឹង ត្រគ់ រ៉ះ កា អីស ?» ");
INSERT INTO tpu_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","កាម៉ាញ់ អ៊ែ កា ញ៉ាំ ឡោម ហះ ម៉ាត់ អ៊ែ រ៉ាំងវ៉ាង តាំប៉ើះ ដារ់ ណោះ។ ញន កា កាម៉ាញ់ អ៊ែ ឡោម តាឡាម័ សាំសុន កា រ៉ះ ឡឹង សារ វ៉ាម ណោះ។ កាម៉ាញ់ អ៊ែ កា ប៉ាន់តាន ឡាំ រ៉ះ ឡឹង សារ វ៉ាម ណោះ កា សុនសាត អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","ប៉ាគ់ កាង៉ាច ដារ់ ទី តាំប៉ើះ ដារ់ ក្យាម័ ចឹង ម៉ុត កេះ មួត បក់ អ្វៃ ពឹង ស្រុក ណោះ កា ប៉ាណាំ គួប ពឹះ រ៉ះ ផា «អូ ទី ញ៉ា អាម ឡឹង ទៀក គ្រត អុះ កា អូ ទី ញ៉ា កេង ឡឹង ក្លា ដេល»។ សាំសុន កា តើល អន់ឌែ ផា «ផា អន់ដីស អូ ទី ថៃ ណា លូ រ៉ក់ យ៉ង់ អាញ់ សារ អាញ់ វ៉ាម ណោះ អន់ដីស អូ អ្លុ រ៉ះ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","ផះ ណោះ ប៉ាង៉ាត័ ប៉ាលឹង ប‌៉្រ័ះ ប៊កកាតយ័ កា ម៉ុត ពឹង សាំសុន ប៉្រគ័ អន់ អ៊ែ ទី សាងុំ កេង ខាក់ អ៊ែ កា ឡាំ ប៉ាគ់ មឿង អាសាកាឡូន ប៉ាន់តោ័ សុនសាត ភីលីសាទីន ពឹង មឿង ណោះ ទី ៣០ ដូវ កេះណោះ អ្យក់ ខោ អាវ មួត ណោះ ជែក អន់ កា មួត បក់ រ៉ះ សារ អ៊ែ វ៉ាម ណោះ។ កេះណោះ សាំសុន ហ៊ែង ប៉ិច អឺក កាខាក់ កា សឹត ប៉ាគ់ ហី ពឹ មើគ អ៊ែ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","ពូ កា អន់ កាម៉ាញ់ អ៊ែ កា កាម៉ាក័ ម៉ោញ ដូវ បក់ អង់រ៉ើង ផះ ប៉ាញ់សង់ សាំសុន ពែ។ ");
INSERT INTO tpu_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","អន់តីគ ឡឹង ណោះ ប៉ាគ់ ទឹល ថុន ពូ ច្រូត័ ពៀ កេះ សាំសុន កា ឡាំ ឡាងត កាម៉ាញ់ អ៊ែ កា អ្យក់ ឡាំ គន ប៉ារ់ពេ អន់ កា កាម៉ាញ់ អ៊ែ ដេល។ អ៊ែ ឃឹត ចឹង ម៉ុត ពឹង កាណុង កាម៉ាញ់ ហះកា ពឹ អន់ហ្នី អ៊ែ អូ អន់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","ពឹ អន់ហ្នី កាប លូ អ៊ែ ផា «អាញ់ សាម៉គ័ កា អីស អូ ប៉ិច កា អ៊ែ កេះ បះ អាញ់ អន់ កា កាម៉ាក័ បក់ អង់រ៉ើង អីស ពែ ឡគ។ ហះកា អុះ អ៊ែ ឡាយ៉ាម័ ឡឹង ម៉ី អ៊ែ សាំ។ ញ៉ា អីស ប៉ិច ដេល ប ? ផា អីស ប៉ិច អ្យក់ អ៊ែ ប៉ាតាង ម៉ី អ៊ែ កា ទី ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","សាំសុន កាប អឺក ផា «ម៉ោញ ទង អា ផា អាញ់ ប៉្រគ័ បាប មួត ភីលីសាទីន អា អាញ់ អូ យច អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","កេះណោះ អ៊ែ កា ឡាំ រ៉ុប សូ ព្រី ៣០០ កាតុ។ អ៊ែ កា កត់ ក្យាំង សូ ព្រី អន់ ទួម គួប អ៊ែ ពៀរ កាតុ ៗ កេះណោះ អ្យក់ អុញ កាបង កត់ ពឹង ក្យាំង សូ។ ");
INSERT INTO tpu_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","កេះណោះ អ៊ែ សុះ អុញ កាបង ឡើយ សូ ព្រី អន់ សាតាក់ ពឹង ម៉ីរ មួត ភីលីសាទីន ប៉្រគ័ អន់ អុញ សា ចាណគ់ ពៀ ពូ ច្រូត័ កេះៗ លូ សា ពៀ បើ តាន័ ច្រូត័ ទឹប សា ម៉ីរ តើម អូលេវ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","សុនសាត ភីលីសាទីន អំប៉ញ់ គួប សោប ផា «ពឿ ប៉្រគ័ នីអៀ ?» ទី ពូ រ៉ះ ផា «សាំសុន អ៊ែ ប៉្រគ័ នែវ អា ញន កា ពឹ អន់ហ្នី អ៊ែ ប៉ាំងកាប័ អន់ កាម៉ាញ់ អ៊ែ កា កាម៉ាក័ បក់ អង់រ៉ើង អ៊ែ»។ សុនសាត ភីលីសាទីន កា ប៉ាណាំ គួប ឡាំ សុះ ប៉ាន់តោ័ អង់កាន់ ណោះ លូ ពឹ អ៊ែ ទឹប រ៉ីស។ ");
INSERT INTO tpu_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","សាំសុន កាប កាគឹម កា អន់ឌែ ផា «អន់ដីស ប៉្រគ័ កា អាញ់ នីអៀ អាញ់ អូ អ្លាត តាដោះ អុះ អាញ់ ចឹង ប៉្រគ័ តូ កា អន់ដីស ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","អ៊ែ កា ប៉ាន់តោ័ ពូ អៀង កាខាក់ កេះណោះ អ៊ែ សាតាក់ អោន ឡាកោ កាណុង ឡូះ ហះ ប៉ានឹម អេតាំ។ ");
INSERT INTO tpu_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","សុនសាត ភីលីសាទីន កា ប៉ាណាំ គួប ឡាំ អ្វៃ ពឹង ព្រី ទៀក ស្រុក តេះ ផូង័ យូដា កេះណោះ វ៉ិង ទឹល ស្រុក តេះ លេហ៊ី។ ");
INSERT INTO tpu_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","មួត យូដា កា អំប៉ញ់ អន់ឌែ ផា «ញ៉ា ត្រគ់ អន់ដីស ពឹះ តាកូះ លូ ញឹន នីអៀ ?» អន់ឌែ តើល ផា «ញឹន ពឹះ អា ភឿ ចឹង រ៉ុប សាំសុន កេះណោះ ប៉្រគ័ កា អ៊ែ ឡាក់ កា អ៊ែ ប៉្រគ័ កា ញឹន ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","ទឹល នីណោ័ះ មួត យូដា ៣០០០ ដូវ កា ប៉ាណាំ គួប ឡាំ ប៉ាគ់ ឡូះ ហះ ប៉ានឹម អេតាំ កេះណោះ កាប លូ សាំសុន ផា «អីស អូ អ្លុ អន់តគ់ ប ផា សុនសាត ភីលីសាទីន ឡាក់ តាំងឡា រ៉ាំងហៃ ពិន ? ញ៉ា ត្រគ់ អីស ប៉្រគ័ កា ញឹន នីអៀ ?» សាំសុន តើល ផា «អាញ់ ប៉្រគ័ កា អន់ឌែ ឡាក់ កា អន់ឌែ ប៉្រគ័ កា អាញ់ ពែ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","មួត យូដា កាប ណាវ្គ ផា «ញឹន ពឹះ អា ភឿ ចឹង រ៉ុប ចគ់ អីស អ្យក់ ឡាំ មប អន់ កា សុនសាត ភីលីសាទីន»។ សាំសុន កាប លូ អន់ឌែ ផា «ទឹល នីណោ័ះ ហគ់ អន់ដីស ម៉ត់ លូ អាញ់ ផា អន់ដីស អូ ប៉ាន់តោ័ អាញ់ អន់ដីស ទៅ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","អន់ឌែ កា តើល ផា «អូ អុះ ញឹន អូ ឃឹត ចឹង ប៉ាន់តោ័ អីស អុះ ញឹន ក្រាន័ កា ចគ់ អីស មប អន់ កា សុនសាត ភីលីសាទីន ដោច»។ អន់ឌែ កា អ្យក់ កាស៊ែ សាន់ត្រាន័ ណាវៗ ពៀរ កាស៊ែ ចគ់ អ៊ែ កេះៗ អន់ឌែ កា អ្យក់ ឡាច់ អ៊ែ ឡឹង ឡូះ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","ប៉ាគ់ អ៊ែ ទឹល ស្រុក តេះ លេហ៊ី សុនសាត ភីលីសាទីន ប៉ប័ អ៊ែ អន់ឌែ កា តាំងហើ ឡូត។ ផាឌី ប៉ាង៉ាត័ ប៉ាលឹង ប‌៉្រ័ះ ប៊កកាតយ័ កា ម៉ុត ពឹង សាំសុន កាស៊ែ សាន់ត្រាន័ ពូ ចគ់ ពឹង តី អ៊ែ កា តាប៉្លុច ឡាម៉គ់ ឡាម៉ាយ ឡាក់ កាស៊ែ ព្រៀយ ត្រគ់ អុញ។ ");
INSERT INTO tpu_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","សាំសុន កា ប៉ប័ អន់តីង កាង លៀ ម៉ោញ ឡៃង ពូ ប៉ាន់តោ័ ណាវៗ អ៊ែ កា ទូញ កាមៃ ប៉ាន់តោ័ ប៉ាណូស ១០០០ ដូវ។ ");
INSERT INTO tpu_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","កេះណោះ អ៊ែ កាប ផា៖ «ញន កា អន់តីង កាង លៀ បះ អាញ់ ពីត ប៉ាន់តោ័ ប៉ាណូស ១០០០ ដូវ ញន កា អន់តីង កាង លៀ អា ទី ប៉ានូក ប៉ាទ្រូ ពូក អំប៉ាំង គួប អ៊ែ»។ ");
INSERT INTO tpu_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","ប៉ាគ់ អ៊ែ កាប កេះៗ អ៊ែ កា វ៉ឹត ហឹរ អន់តីង កាង ណោះ។ ញន ខ ណោះ ហង បះ ពូ អើ ចារ ណោះ ផា រ៉ាម៉ាត់ លេហ៊ី ។ ");
INSERT INTO tpu_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","ប៊ែត ឡឹង ណោះ អ៊ែ ហ៊្រែង ទៀក ខាក់ អ៊ែ កា ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ផា «អឺ ប‌៉្រ័ះ តាំងឡា អីស ហង ឡាក់ អន់ អាញ់ ចាយ័ កាខាក់ កេះ អា ហះកា នីចម័ កិញអៀ អា អីស ចឹង អន់ អាញ់ តោ័ កា ហ៊្រែង ទៀក ប ? កេះណោះ សុនសាត អន់ទៀគ ទិណោ័ះ ចឹង អ្យក់ ប៉ាទ្រូ អាញ់ ប៉្រគ័ តាម ពុត អន់ឌែ»។ ");
INSERT INTO tpu_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","ផះ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ អំហ្មោ ប៉ាទុះ ហូរ័ ឡាច់ ទៀក ក្យាម័ តេះ លេហ៊ី ណោះ។ សាំសុន កា អៃត ទៀក ណោះ កេះណោះ អ៊ែ កា ទី សាងុំ ណាវ្គ លូ ទី ពុត ហោក រ៉គ់ ដេល។ ញន ណោះ បះ ពូ អើ កល់ ទៀក ណោះ ផា អេនហាកូរេ  កល់ ទៀក ក្យាម័ តេះ លេហ៊ី ណោះ អ្វៃ លើយ ទឹល រ៉ប់ ដារ់ អា។ ");
INSERT INTO tpu_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","ផះ រ៉ាំងវ៉ាង សុនសាត ភីលីសាទីន រ៉ាំងហៃ អ៊ីស្រាអ៊ែល ផះ ណោះ សាំសុន កា ប៉្រគ័ ម៉ៃគ ណាំផា សុនសាត អ៊ីស្រាអ៊ែល ទុញ ២០ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","អន់តីគ ឡឹង ណោះ សាំសុន ឡាំ ប៉ាគ់ មឿង កាសា ទឹល ប៉ាគ់ ណោះ អ៊ែ ប៉ប័ អង់កាន់ ម៉ាលេង ម៉ោញ ដូវ អ៊ែ កា ម៉ុត កាណុង ចារ អង់កាន់ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","កា ទី ពូ រ៉ះ កា មួត មឿង កាសា ផា «សាំសុន ពឹះ ប៉ាគ់ អា កេះ»។ អន់ឌែ កា ប៉្រើ កាំឡាំង ញ៉ាម លូ ក្រាប់ ហះ អំប៉ារ ទ្រួក មឿង ណោះ ម៉ោញ ម៉ាំង តារ ទឹប កាកាប លូ គួប អន់ឌែ ផា «ក្យាគ់ តារ ហិ ពិន ប៉ាន់តោ័ អ៊ែ»។ ");
INSERT INTO tpu_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","ហះកា សាំសុន តៃប ហះ ណោះ អូ តាន័ តារ អុះ។ ប៉ាគ់ អន់តិគ័ ម៉ាំង អ៊ែ កា អ្យូវ ទុង រ៉ាន់ដះ អំប៉ារ ទ្រួក ណោះ លូ អញ់ជុង អំប៉ារ ណោះ ទិ ពៀរ ដេល កា លឺក តី ពឹង កាពែង អ្យក់ ចៃគ ពឹង កល់ ប៉ានឹម ត្រង់ មឿង ហេប្រូន។ ");
INSERT INTO tpu_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","អន់តីគ ឡឹង ណោះ អ៊ែ កា ប៉ិច កា អង់កាន់ ម៉ោញ ដូវ ណាវ្គ សិច ដេលីឡា អ្វៃ ហះ តាចាង័ សូរេក។ ");
INSERT INTO tpu_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","ផះ ណោះ មួត ម៉ៃគ ណាំផា សុនសាត ភីលីសាទីន ប៉ាណាំ គួប ឡាំ កាប លូ ដេលីឡា ផា «ហគ់ ប៉ាឡោម សាំសុន ភឿ អន់ អ្លុ អន់តគ់ ផា ខ ញ៉ា បះ អ៊ែ ទី សាងុំ កេង ខាក់ នីណោ័ះ ? ប៉្រគ័ នីចម័ ញឹន ចឹង ដាម័ អ៊ែ ម៉ាគ់ ញឹន ចឹង រ៉ុប ចគ់ អ៊ែ ទី ? កេះណោះ ញឹន ទិឌូ ចឹង អន់ ប៉្រាក់ កា អីស ម៉ោញ ដូវ ១២ កាឡូ»។ ");
INSERT INTO tpu_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","ឡៃង ឡឹង ណោះ ដេលីឡា កា អំប៉ញ់ លូ សាំសុន ផា «ប៉រ់ អីស រ៉ះ ហៃ កា អាញ់ ណើ ខ ញ៉ា បះ អីស ទី សាងុំ កេង ខាក់ នីអៀ ? ប៉្រគ័ នីចម័ ចឹង រ៉ុប កត់ អីស ទួម ?» ");
INSERT INTO tpu_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","សាំសុន រ៉ះ កា អ៊ែ ផា «ផា ពូ អ្យក់ កាស៊ែ តាមៃ អ្វៃ សាត់ៗ បើ តាន័ ក្រោះ ទី តាំប៉ើះ អន់ហ្នារ័ កត់ អាញ់ ណោះ អាញ់ ចឹង អូ ទី សាងុំ ឡាក់ កា ពូ អន់ទៀគ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","ទឹល នីណោ័ះ មួត ម៉ៃគ ណាំផា សុនសាត ភីលីសាទីន កា អ្យក់ កាស៊ែ តាមៃ អ្វៃ សាត់ បើ តាន័ ក្រោះ ទី តាំប៉ើះ អន់ហ្នារ័ ឡាំ អន់ កា ដេលីឡា។ ផះ សាំសុន តៃប ហ្លាក់ ដេលីឡា កា អ្យក់ កាស៊ែ ណោះ កត់ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","ហះកា ដេលីឡា ប៉្រើ ពូ ក្រាប់ កាណុង ហី កេះៗ កេះណោះ អ៊ែ អើ ផា «អឺ សាំសុន មួត ភីលីសាទីន ពឹះ រ៉ុប អីស»។ អ៊ែ កា សាំប៉ត់ កាតាច់ កាស៊ែ ណោះ ឡាម៉គ់ ឡាម៉ាយ ឡាក់ កា កាស៊ែ ព្រៀយ កាន់តើស អុញ ណោះ ហង អូ ទី ពឿ អ្លុ អន់តគ់ ផា ខ ញ៉ា អ៊ែ ទី សាងុំ នីណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","កេះណោះ ដេលីឡា កា កាប លូ សាំសុន ផា «អីស អ្លុ ប៉ាង៉ល់ លូ កាប តាំព្លូង កា អាញ់។ កិញអៀ អា អីស រ៉ះ ហៃ កា អាញ់ តាទឹច ប៉្រគ័ នីចម័ កត់ អីស ចឹង ទួម ?» ");
INSERT INTO tpu_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","សាំសុន កា រ៉ះ កា អ៊ែ ផា «ផា ពូ អ្យក់ កាស៊ែ ប៉្រាត័ ណាវៗ បើ តាន័ យរ កត់ អាញ់ ណោះ អាញ់ ចឹង អូ ទី សាងុំ ឡាក់ កា ពូ អន់ទៀគ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","ដេលីឡា កា អ្យក់ កាស៊ែ ប៉្រាត័ ណាវៗ កេះណោះ កត់ ចគ់ សាំសុន កេះៗ អ៊ែ អើ ផា «អឺ សាំសុន មួត ភីលីសាទីន ពឹះ រ៉ុប អីស»។ ផះ ណោះ កា ទី ប៉ាណូស ក្រាប់ កាណុង ហី កេះ ដេល។ ហះកា សាំសុន សាំប៉ត់ កាតាច់ កាស៊ែ ប៉្រាត័ ពូ កត់ ពឹង តី អ៊ែ ឡាក់ កា ពូ ព្រិច កាស៊ែ ព្រៀយ។ ");
INSERT INTO tpu_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","ដេលីឡា កាប លូ សាំសុន ផា «ឡឹង គុល ទឹល កិញអៀ អីស ប៉ាង៉ល់ លូ កាប តាំព្លូង កា អាញ់ កាខាក់។ កិញអៀ អា ប៉រ់ អីស រ៉ះ ហៃ កា អាញ់ តាទឹច ប៉្រគ័ នីចម័ កត់ អីស ចឹង ទួម ?» សាំសុន តើល ផា «ផា អីស គល សក់ អាញ់ អន់ ទី តាំប៉ើះ កានល តាញ អន់ឌូ លូ ព្រៀយ ពឹង ខោង ណោះ អាញ់ ចឹង អូ ទី សាងុំ ឡាក់ កា ប៉ាណូស អន់ទៀគៗ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","ដេលីឡា កា ប៉្រគ័ អន់ សាំសុន តៃប ហ្លាក់ កេះណោះ គល សក់ អ៊ែ អន់ ទួម លូ ព្រៀយ ពូ តាញ ពឹង ខោង កេះណោះ ស្រូ ប៉ាន់ហ្នាក់ កត់ កាតត់ អន់ឌូ លូ ប៉ាសា ណាវ្គ កេះៗ អើ ផា «សាំសុន មួត ភីលីសាទីន ពឹះ រ៉ុប អីស កេះ»។ សាំសុន កា សាទឹរ រ៉ាន់ដះ សក់ ពូ គល អន់ឌូ លូ ព្រៀយ ពឹង ខោង តាប៉្លុច ទិ។ ");
INSERT INTO tpu_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","ដេលីឡា កាប លូ សាំសុន ផា «អីស ផា អីស ប៉ិច កា អាញ់ ហះកា ពុត អីស តាង ឡឹង អាញ់ នីអៀ ? ហៃ អីស តាំព្លូង កា អាញ់ ប៉ៃង ទង ហះ អា កេះ ហះកា អីស អូ ចៃ រ៉ះ អុះ អន់ អាញ់ អ្លុ អន់តគ់ ផា ខ ញ៉ា បះ អីស ទី សាងុំ»។ ");
INSERT INTO tpu_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","ញន កា ដេលីឡា កាប ញ៉ាញ៉ម់ ញ៉ាញ៉ាច់ តៃល ទៅ ៗ ផូត សាំសុន អូ អត់ សាំរ៉ាញ័ កេះ សិន ដាគ់ តោ័ ");
INSERT INTO tpu_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","អ៊ែ កា រ៉ះ កា ដេលីឡា តាទឹច ហង អ៊ែ កាប ផា «សក់ អាញ់ អូ ត្រគ់ កូរ័ លើ កាត់ អុះ ខង ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ើស អ្យក់ អាញ់ អន់ ប៉្រគ័ ណាសារីត ឡឹង អ្វៃ កាណុង វ៉ាច់ មើគ ពែ កេះ ផា អាញ់ កូរ័ ឡាច់ អាញ់ ចឹង អូ ទី សាងុំ ហង ឡាក់ កា ប៉ាណូស អន់ទៀគ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","ដេលីឡា អ្លុ អន់តគ់ ផា សាំសុន រ៉ះ កា អ៊ែ តាទឹច កេះ អ៊ែ កា ប៉្រើ ពូ ឡាំ រ៉ះ កា ម៉ៃគ ណាំផា សុនសាត ភីលីសាទីន «ហគ់ អន់ដីស ពឹះ ពិ ម៉ោញ ទង អា អ៊ែ រ៉ះ តាទឹច កេះ»។ មួត ម៉ៃគ ណាំផា កា ប៉ាណាំ គួប ឡាំ ប៉ាគ់ ហី ដេលីឡា ទ្រុង ឡាំ លៀន។ ");
INSERT INTO tpu_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","ដេលីឡា អន់ សាំសុន តៃប កើល កល់ ពឹង ព្លូ អ៊ែ ទឹល ហ្លាក់ កេះណោះ អើ ប៉ាណូស ម៉ោញ ដូវ ប៉្រើ កូរ័ សក់ អ៊ែ ចាក់ ទិ តាំប៉ើះ ចាណគ់។ សាគ់ ឡឹង ណោះ អ៊ែ កា អូ ទី សាងុំ កេះ។ ផះ ណោះ ដេលីឡា កា ប៉្រគ័ បាប កា អ៊ែ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","ដេលីឡា កា អើ សាំសុន ផា «សាំសុន មួត ភីលីសាទីន ពឹះ រ៉ុប អីស»។ សាំសុន សាទឹរ ឡឹង តៃប អ៊ែ ឃឹត ផា ចឹង រ៉ាវ៉ាច់ ឡាកោ ឡាក់ កា អន់ទ្រួល ពែ ដេល ខង អ៊ែ អូ អ្លុ អន់តគ់ ផា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាច់ ឡឹង អ៊ែ ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","មួត ភីលីសាទីន កា រ៉ុប សាំសុន កេះណោះ ខ្វិក ឡាច់ តីល ម៉ាត់ អ៊ែ ទិ ពៀរ។ អន់ឌែ អ្យក់ ឡាំ អ៊ែ ប៉ាគ់ មឿង កាសា ប៉ាគ់ ទឹល កេះ អ្យក់ ច្រ្វាល់ សាប៉ាន័ កត់ អ៊ែ កេះណោះ ចៃគ ពឹង ខុក លូ ប៉ាំងខំ ប៉្រើ ប៉ាតារ័ តាប៉ាល់ អំហ្មោ។ ");
INSERT INTO tpu_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","ហះកា អន់តីគ ឡឹង ពូ កូរ័ សក់ អ៊ែ កា ហ៊ន ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","មួត ម៉ៃគ ណាំផា សុនសាត ភីលីសាទីន កា អើ គួប អន់ឌែ ភឿ ចឹង ប៉្រគ័ ប៊ុន រ៉គ់ ហោក កា អន់ឌែ ចាយ័ ទឹប សៃន ប‌៉្រ័ះ ដាកុន ឡាក់ ប‌៉្រ័ះ អន់ឌែ ដេល។ អន់ឌែ ប៉ាណាំ គួប ចាជែ ផា «ប‌៉្រ័ះ ពិន មប សាំសុន ឡាក់ តាម៉ឺរ ពិន ពឹង តី ពិន កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","ប៉ាគ់ ប៉ប័ ហ៊ូប ប‌៉្រ័ះ អន់ឌែ កេះ មួត ប៉ាសុន កា ប៉ាណាំ គួប ប៉ានេ តាំប៉ោក លូ កាប ផា «ប‌៉្រ័ះ ពិន មប តាម៉ឺរ ពឹង តី ពិន កេះ បក់ ថាំឡាយ ស្រុក តេះ ពិន លូ ប៉ាន់តោ័ ប៉ាសុន ពិន អៀង ដូវ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","ផះ អន់ឌែ អ្វៃ ហោក រ៉គ់ កាខាក់ ណោះ អន់ឌែ កាប ផា «ហគ់ ឡាំ អ្យក់ សាំសុន ពឹះ ប៉ាគ់ អា ប៉្រើ អ៊ែ កាតាប័ អន់ ពិន ហៃ»។ អន់ឌែ កា ទុង សាំសុន ឡាច់ ឡឹង ខុក ភឿ កាតាប័ អន់ កា អន់ឌែ ហៃ។ អន់ឌែ អន់ សាំសុន អ្វៃ ហះ តាវ៉ាង័ អញ់ជុង អន់តិគ័ រ៉ោង រ៉ាម៉ះ។ ");
INSERT INTO tpu_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","សាំសុន កាប លូ តាតាម័ ទុង អ៊ែ ផា «ប៉រ់ អីស អន់ អាញ់ សាប៉ាគ់ អញ់ជុង រ៉ោង រ៉ាម៉ះ ណើ ម៉ាគ់ អាញ់ អង់អ៊េន ពឹង អញ់ជុង ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","ផះ ណោះ ទី ប៉ាណូស ទឹប កាម៉ាក័ ទឹប អង់កាន់ អ្វៃ ប៉ាញ័ រ៉ោង រ៉ាម៉ះ។ មួត ម៉ៃគ ណាំផា សុនសាត ភីលីសាទីន ទិណោ័ះ កា អ្វៃ ហះ ណោះ ដេល កា ទី ប៉ាណូស ៣០០០ ដូវ ណាវ្គ អ្វៃ ពឹង ចាំងហីគ អំប៉ាំង សាំសុន ភឿ ហៃ សាំសុន កាតាប័។ ");
INSERT INTO tpu_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","សាំសុន កា ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ផា «អឺ ប‌៉្រ័ះ ឡាក់ តាំងឡា ជែ ពឹល អាញ់ ប៉រ់ តាប៉ាប អន់ អាញ់ ទី សាងុំ ម៉ោញ ទង អា ណាវ្គ ពិ ម៉ោញ ទង កាប្លេះ ម៉ាត់ អន់ អាញ់ ប៉្រគ័ កា មួត ភីលីសាទីន អន់ តោ័ ទិ ឡូត ឡាក់ កា អន់ឌែ ខ្វិក ម៉ាត់ អាញ់ ទិ ពៀរ ពែ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","កេះណោះ សាំសុន កា រ៉ាប៉ត់ ចឹក អញ់ជុង រ៉ោង រ៉ាម៉ះ អន់តិគ័ ទិ ពៀរ អ៊ែ ត្រាគ័ តី សាម៉ា អ៊ែ ពឹង អញ់ជុង ម៉ោញ លូ តី សាំងអ្យោ ត្រាគ័ ពឹង អញ់ជុង ម៉ោញ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","កេះណោះ សាំសុន កាប ម៉ៃៗ ផា «អន់ អាញ់ តោ័ អន់ឌូ លូ មួត ភីលីសាទីន ពិ»។ អ៊ែ កា ត្រុត អញ់ជុង ណោះ តុត ពុត អ៊ែ រ៉ោង រ៉ាម៉ះ កា ប៉ាក់ គ្លឹម ម៉ៃគ ណាំផា លូ មួត សុនសាត ភីលីសាទីន ឡាក់ អ្វៃ ហះ ណោះ ទិឌូ។ ប៉ាណូស បក់ តោ័ អន់ឌូ លូ អ៊ែ ហះ ណោះ អៀង ឡឹង ប៉ាណូស អ៊ែ ប៉ាន់តោ័ ផះ អ៊ែ អ្វៃ រ៉ីស ពែ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","កេះណោះ អុះ ម៉ី លូ ផូង័ វ៉ាច់ អ៊ែ ទិណោ័ះ កា ប៉ាណាំ គួប ឡាំ តូង័ ប៉ាទ្រូ សាំសុន អ្យក់ សឹត តប់ អន់ឌូ លូ ប៉ាទ្រូ ពឹ អ៊ែ វគ័ ម៉ាណូអា ឡាក់ ពូ តប់ ហះ តាវ៉ាង័ តេះ សូរ៉ះ លូ តេះ អ៊ែសាថោល។ សាំសុន រ៉ាំងហៃ សុនសាត អ៊ីស្រាអ៊ែល ទុញ ២០ សាណាំ ផះ រ៉ាំងវ៉ាង អ៊ែ អ្វៃ រ៉ីស ពែ។ …");
INSERT INTO tpu_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","ផះ រ៉ាំងវ៉ាង មួត ម៉ៃគ ណាំផា បក់ ប‌៉្រ័ះ ប៉្រើ តង័ សុនសាត អ៊ីស្រាអ៊ែល ផះ អន់ឌែ រ៉ាំងហៃ ផះ ណោះ ទី សារ ឡាយ៉ិត ឡាំងវ៉ាញ់ កាខាក់ កាណុង ប៉ាថេត ណោះ។ ទី កាម៉ាក័ ម៉ោញ ដូវ អ្វៃ ប៉ាគ់ តេះ បេតាលេហិម ប៉ាគ់ ព្រី ទៀក ផូង័ យូដា អ៊ែ កា ប៉ាណាំ កាម៉ាញ់ អ៊ែ លូ គន កាម៉ាក័ អ៊ែ ពៀរ ដូវ ឡាំ អ្វៃ អង់រ៉ាម័ ប៉ាគ់ ប៉ាថេត ម៉ូអាប់។ ");
INSERT INTO tpu_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","សិច អ៊ែ ណោះ អេលីម៉ាឡេក កាម៉ាញ់ អ៊ែ សិច ណាអូមី លូ គន អ៊ែ ពៀរ ដូវ សិច ម៉ាឡូន លូ គីលីយ៉ូន។ អន់ឌែ កា ឡាច់ ឡឹង តេះ អេប៉្រាតា ឡាក់ ពូ អើ ផា បេតាលេហិម ពឹង ព្រី ទៀក ផូង័ យូដា។ អន់ឌែ ឡាំ ទឹល ប៉ាគ់ ប៉ាថេត ម៉ូអាប់ កា អ្វៃ ប៉ាគ់ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","អន់តីគ ឡឹង ណោះ អេលីម៉ាឡេក ឡាក់ ក្លោ ណាអូមី កា តោ័ ហង អ្វៃ ដឹង ណាអូមី លូ គន អ៊ែ ពៀរ ដូវ។ ");
INSERT INTO tpu_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","គន អ៊ែ ពៀរ ដូវ ណោះ កា ទី កាម៉ាញ់ សុនសាត ម៉ូអាប់ សិច កាម៉ាញ់ អន់ឌែ ម៉ោញ ដូវ សិច អ៊ែ អ៊រប៉ា លូ ម៉ោញ ដូវ ណាវ្គ សិច អ៊ែ រូត។ អន់ឌែ អ្វៃ កាណុង ប៉ាថេត ណោះ ឃឺ អ៊ែ ទុញ ១2០ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","ផះ រ៉ាំងវ៉ាង ណោះ ម៉ាឡូន លូ គីលីយ៉ូន កា តោ័ ដេល ណាអូមី កា អ្វៃ ដឹង ម៉ោញ ដូវ អ៊ែ ក្លោ កា អូ ទី គន កា អូ ទី។ ");
INSERT INTO tpu_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","ផះ ណាអូមី អ្វៃ ពឹង ប៉ាថេត ម៉ូអាប់ ណោះ អ៊ែ កាតាំង ពូ រ៉ះ ផា ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ដាគ់ កា ប៉ាសុន អ៊ែ ឃឺ អន់ឌែ ទី សាណា សា អៀង កេះ។ ទឹល នីណោ័ះ អ៊ែ ទ្រៀម ឡាកោ ចឹង ចាក សឹត អន់ឌូ លូ ម៉ាយ អ៊ែ ទិ ពៀរ ដូវ។ ");
INSERT INTO tpu_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","កេះណោះ ណាអូមី លូ ម៉ាយ អ៊ែ ចាក ឡាច់ ឡឹង ប៉ាថេត ម៉ូអាប់ សឹត ប៉ាគ់ ព្រី ទៀក ផូង័ យូដា ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","ហះកា ប៉ាគ់ គឹត អន់តិគ័ ទ្រង កេះ ណាអូមី រ៉ះ កា ម៉ាយ អ៊ែ ផា «អន់ដីស សឹត ប៉ាគ់ ហី ពឹ មើគ អន់ដីស ទៅ ពិ។ អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ដាគ់ កា អន់ដីស ឡាក់ កា អន់ដីស ប៉្រគ័ ដាគ់ កា គន អាញ់ ណោះ ពែ លូ ប៉្រគ័ ដាគ់ កា អាញ់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ អន់ដីស ទី ក្លោ ណាវ្គ ពិ ម៉ាគ់ ចឹង ទី សារ សាណុក សាវ៉ាក»។ កេះណោះ ណាអូមី កា គ្វែត ចុំ ម៉ាយ អ៊ែ ទិ ពៀរ ដូវ។ អន់ឌែ ទិ ប៉ៃង ដូវ កា ញ៉ាំ រ៉ាវ៉ើក ថើក។ ");
INSERT INTO tpu_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","ហះកា ម៉ាយ ណាអូមី តើល ផា «អូ អុះ ញឹន ចឹង ឡាំ អន់ឌូ លូ អីស ដេល ញឹន ចឹង ឡាំ អ្វៃ លូ សុនសាត អីស ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","ហះកា ណាអូមី ប៉ាគែក លូ អន់ឌែ ផា «អន់ដីស ពៀរ ដូវ អា សឹត ប៉ាគ់ ពឹ មើគ អន់ដីស ពិ។ ញ៉ា ត្រគ់ ប៉ិច ចាក ពួយ អាញ់ ? អាញ់ ក្រាគ់ កេះ អូ អ្លុ ទី គន ចឹង ធែម ថាអុះ អន់ កា អន់ដីស ណាវ្គ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","សឹត ឡគ ពិ អាញ់ ក្រាគ់ ឡក់ កេះ អូ អ្លុ ទី ក្លោ អុះ។ ផា អាញ់ ទី ក្លោ ម៉ាំង អា កេះណោះ ទី គន កាម៉ាក័ ");
INSERT INTO tpu_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","ញ៉ា អន់ដីស ចឹង ក្យាគ់ ទឹល អន់ឌែ តីស ប ? ញ៉ា អន់ដីស ចឹង អ្វៃ តាដោះ អូ ទី ក្លោ លើយ នីអៀ ហង ប ? អូ ត្រគ់ អុះ ប៉្រគ័ នីណោ័ះ។ អាញ់ អុក ពុត ខាក់ ញន កា អន់ដីស ទឹប ប‌៉្រ័ះ ប៊កកាតយ័ អឺក កា អាញ់ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","ផះ ណោះ អន់ឌែ កា អង់ហ្យាំង ញ៉ាំ ម៉ោញ ទង ណាវ្គ រ៉ាវ៉ើក ថើក កា អន់ឌែ។ កេះណោះ អ៊រប៉ា កា ចុំ មើគ អន់ហ្នី អ៊ែ កា ចាក ឡាច់ ឡូត ហះកា រូត អ្វៃ ខំ ចាក ពួយ មើគ អន់ហ្នី អ៊ែ លើយ។ ");
INSERT INTO tpu_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","ណាអូមី រ៉ះ កា រូត ផា «ហៃ តោ អៃ អីស អ៊រប៉ា ចាក សឹត ប៉ាគ់ សុនសាត អ៊ែ ទៅ លូ ឡាំ សាំប‌៉័ះ ប‌៉្រ័ះ អ៊ែ ទៅ ណាវ្គ កេះ។ ហគ់ អីស ឡាំ ពួយ អ៊ែ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","ហះកា រូត តើល អ៊ែ ផា «អីស ជែ ប៉ាំងខំ ហង អាញ់ ឡាច់ ឡឹង អីស។ ផា អីស ឡាំ ប៉ាគ់ ចំ កា អាញ់ ចឹង ឡាំ ពួយ អីស ដេល ផា អីស អ្វៃ ប៉ាគ់ ចំ កា អាញ់ ចឹង អ្វៃ ពួយ ប៉ាគ់ ណោះ ដេល សុនសាត អីស កា សុនសាត អាញ់ ដេល ប‌៉្រ័ះ អីស កា ប‌៉្រ័ះ អាញ់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","ផា អីស តោ័ ហះ ចំ កា អាញ់ តោ័ ហះ ណោះ ដេល អាញ់ ប៉ិច កា ពូ តប់ អាញ់ ហះ ណោះ ដេល ទី ដឹង សារ តោ័ ហង អ្លុ ប៉ាក្លះ អាញ់ ឡឹង អីស។ ផា អាញ់ ឡាច់ ឡឹង អីស អន់ ប‌៉្រ័ះ ប៊កកាតយ័ ចៃគ ថូត អាញ់ នីចម័ កាតាម»។ ");
INSERT INTO tpu_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","ណាអូមី ហៃ កា ម៉ាយ អ៊ែ រូត ប៉ិច ពួយ អ៊ែ ខាក់ អ៊ែ កា អ្វៃ តាតិង។ ");
INSERT INTO tpu_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","ណាអូមី លូ រូត កា ចាក ទឹល ប៉ាគ់ តេះ បេតាលេហិម។ ផះ អន់ឌែ ទឹល ប៉ាគ់ ណោះ មួត ស្រុក តេះ ណោះ កា ញម កាខាក់ មួត អង់កាន់ កាកាប លូ គួប អន់ឌែ ផា «យើយ ណាអូមី ប អា ?» ");
INSERT INTO tpu_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","ណាអូមី តើល ផា «ជែ អើ ហង សិច អាញ់ ណាអូមី  ត្រគ់ អើ ផា ម៉ារ៉ា ឡគ ខង ប‌៉្រ័ះ ឡាក់ ទី អំរ៉ាញ អឺញ ប៉្រគ័ អន់ អាញ់ អុក ពុត ខាក់ ប៉ុប អា។ ");
INSERT INTO tpu_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","អាញ់ ចាក ឡាច់ ឡឹង អា ពែ អាញ់ ទី គន ទី ក្លោ ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ អន់ អាញ់ សឹត ប៉ាគ់ អា តាដោះ តាឌែល។ ជែ អើ ហង សិច អាញ់ ណាអូមី ខង ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាសាំង លូ អាញ់ កេះ។ ប‌៉្រ័ះ ឡាក់ ទី អំរ៉ាញ អឺញ ប៉្រគ័ អន់ អាញ់ ថុក ប៉ាណាប ខាក់»។ ");
INSERT INTO tpu_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","នីអៀ ហង ណាអូមី សឹត ប៉ាគ់ ស្រុក អ៊ែ តាំងឡា ទឹប អ្យក់ សឹត ម៉ាយ អ៊ែ រូត សុនសាត ម៉ូអាប់ ឡាំ អន់ឌូ លូ អ៊ែ ដេល។ អន់ឌែ សឹត ទឹល ប៉ាគ់ បេតាលេហិម ត្រគ់ ផះ ថុន កាច់ ថុន ច្រូត័។ ");
INSERT INTO tpu_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","ណាអូមី ទី ថាអុះ ថាមន គែង ក្លោ អ៊ែ អេលីម៉ាឡេក។ កាម៉ាក័ ណោះ សិច បូអុះ អ៊ែ ឡាក់ ប៉ាណូស កានឹត កានោរ។ ");
INSERT INTO tpu_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","កាប៉ាច់ រូត ឡាក់ សុនសាត ម៉ូអាប់ អ៊ែ រ៉ះ លូ មើគ អន់ហ្នី អ៊ែ ណាអូមី ផា «អាញ់ ប៉រ់ ហះ អីស អន់ អាញ់ ចាក ទូញ ពៀ ពូ ហ្រុង ពឹង ម៉ីរ អ្យូគ ផៃគ ពូ ចឹង តាប៉ាប តាប៉ុន អន់ អាញ់ ទូញ ពួយ ប៉ាអច់ ពូ»។ ណាអូមី តើល ផា «ឡាំ ពិ គន»។ ");
INSERT INTO tpu_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","រូត កា ចាក ឡាំ ទូញ ពៀ ពូ ហ្រុង ពួយ ប៉ាអច់ មួត ច្រូត័ ពឹង ម៉ីរ។ ម៉ីរ រូត អ្វៃ ទូញ ណោះ ផាឌី ត្រគ់ ពឹង ម៉ីរ បូអុះ ឡាក់ អុះ មន វគ័ អេលីម៉ាឡេក។ ");
INSERT INTO tpu_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","បៀត ឡឹង ណោះ បូអុះ កា ពឹះ ឡឹង បេតាលេហិម អ៊ែ កាប លូ មួត បក់ ច្រូត័ ណោះ ផា «អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ អន់ឌូ លូ អន់ដីស»។ អន់ឌែ កា តើល ផា «អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ដាគ់ កា អីស ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","កេះណោះ បូអុះ កា អំប៉ញ់ លូ ទុច អ៊ែ បក់ រ៉ាំងហៃ មួត ច្រូត័ ណោះ ផា «គន ពឿ អង់កាន់ ណោះ ?» ");
INSERT INTO tpu_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","បក់ ណោះ តើល ផា «អ៊ែ សុនសាត ម៉ូអាប់ ឡាក់ ពឹះ អន់ឌូ លូ ណាអូមី។ ");
INSERT INTO tpu_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","អ៊ែ កាប លូ អាញ់ កេះ ប៉រ់ ទូញ តាតិប ពៀ ឡាក់ ហ្រុង ឡឹង តី មួត ច្រូត័។ អ៊ែ កា ទូញ ឡឹង កាំលឺ ពែ កេះ ទឹល កិញអៀ អា ហះកា អ៊ែ រ៉ាឡូវ ពឹង ប៉ើក ដឹង ម៉ោញ ទ្រុ ដោច»។ ");
INSERT INTO tpu_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","កេះណោះ បូអុះ កា រ៉ះ លូ រូត ផា «ប៉រ់ អីស សាំយ៉ាំង អាញ់ ចឹង រ៉ះ កា អីស ជែ ឡាំ ទូញ ហង ពៀ ហ្រុង ពឹង ម៉ីរ ពូ អន់ទៀគ ហោគ ទឹប ជែ ចាក ចាំងហាយ្គ ឡឹង ម៉ីរ អា ដេល។ ប៉រ់ អីស អ្វៃ អន់ឌូ លូ មួត ទុច អង់កាន់ អាញ់ អា ហង ពិ។ ");
INSERT INTO tpu_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","អីស ហៃ ហោគ ផា ប៉ប័ ពូ ចាក ប៉ាគ់ ចំ អីស ឡាំ ពួយ ហោគ។ អាញ់ រ៉ះ លូ មួត កាម៉ាក័ អូ អន់ កាន់តើស អីស អុះ។ ផា អីស ហ៊្រែង ទៀក អីស ឡាំ អៃត ពឹង ព្រឺយ មួត ទុច អាញ់ អោះ ណោះ ហោគ»។ ");
INSERT INTO tpu_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","ផះ ណោះ រូត កា សាំប‌៉័ះ កុប កល់ ទឹះ តេះ កេះណោះ រ៉ះ កា បូអុះ ផា «ញ៉ា ត្រគ់ អីស តាប៉ាប តាប៉ុន កា អាញ់ ឡាក់ សុនសាត អន់ទៀគ នីអៀ ?» ");
INSERT INTO tpu_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","បូអុះ តើល ផា «អាញ់ កាតាំង ពូ រ៉ះ ផា អីស ប៉្រគ័ ដាគ់ ខាក់ កា មើគ អន់ហ្នី អីស ឡៃង ឡឹង ក្លោ អីស តោ័ ណោះ។ ទឹប អីស អ្លាត មើគ ពឹ លូ ស្រុក តេះ អីស ទៅ កេះណោះ ឡាំ អ្វៃ ប៉ាគ់ សុនសាត ឡាក់ អីស អូ ឃើយ អ្វៃ ឡឹង សើគ ឡឹង ពែ។ ");
INSERT INTO tpu_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ដាគ់ កា អីស ញន កា អីស ប៉ាណូស ដាគ់ ត្រង់ លូ អន់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល អន់ កាណាគ័ ដាគ់ កា អីស ញន កា អីស ឡាំ ប៉ាគ់ អា អ្វៃ កាន់តេ័ះ ប‌៉្រ័ះ ឡាក់ កា គន អ្យិរ ឡាំ អ្វៃ កាន់តេ័ះ កាហ្លាប ម៉ៃគ អ៊ែ»។ ");
INSERT INTO tpu_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","កេះណោះ រូត តើល ផា «ពឹ តាំងឡា អីស ដាគ់ ពុត កា អាញ់ ខាក់ យ‌៉័ះ អាញ់ ឡាក់ អង់កាន់ អូ គឹត អូ ខា ហ៊្លត ឡឹង អង់កាន់ ទុច អីស កាតាម ហះកា អីស កាប ដាគ់ កាប រ៉គ់ លូ ប៉ាំងហោក ពុត អាញ់ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","ប៉ាគ់ ទឹល មង សា សាណា កេះ បូអុះ រ៉ះ លូ រូត ផា «ចុ ពឹះ ប៉ាគ់ អា សា ណុំ ប៉ាំង តាគ់ លូ សាអ៊្លង»។ កេះណោះ រូត ឡាំ អង់អ្វៃ លូ មួត បក់ ច្រូត័ ពៀ ណោះ បូអុះ កា អន់ទឺប ភែ សាន់តុក កា អ៊ែ ដេល រូត កា សា ទឹល ផីគ ទឹប គម សាណា ឡាក់ អ្វៃ សល់ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","កេះណោះ រូត កា ឡាំ ទូញ ពៀ ណាវ្គ ផះ ណោះ បូអុះ រ៉ះ លូ មួត ទុច អ៊ែ ផា «អន់ អ៊ែ ទូញ ពៀ បក់ បើ តាន័ ចគ់ ណោះ ណើ ជែ ទឹប អ៊ែ ដៃ។ ");
INSERT INTO tpu_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","អន់ដីស ប៉ាឡិ ប៉ាយ៉ក័ ពៀ ឡឹង ចាណគ់ អន់ដា អន់ អ៊ែ ទូញ ណើ ជែ កាប កា អ៊ែ ដៃ»។ ");
INSERT INTO tpu_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","រូត កា ទូញ ពៀ ទឹល កាង៉ាច កេះណោះ ប៉្រះ ពៀ ណោះ ទី ម៉ោញ រែវ។ ");
INSERT INTO tpu_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","រូត កា គ្វី សឹត ពៀ តាំបាង អន់ មើគ អន់ហ្នី អ៊ែ ប៉ប័ លូ អ្យក់ សឹត សាណា ឡាក់ សល់ អន់ កា មើគ អន់ហ្នី ដេល។ ");
INSERT INTO tpu_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","ណាអូមី អំប៉ញ់ អ៊ែ ផា «ដារ់ អា អីស ឡាំ ទូញ ពៀ ប៉ាគ់ ចំ ? ពឹង ម៉ីរ ពឿ ? អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ដាគ់ កា បក់ តាប៉ាប តាប៉ុន កា អីស»។ រូត កា តើល ផា «អាញ់ ឡាំ ទូញ ពឹង ម៉ីរ កាម៉ាក័ ម៉ោញ ដូវ សិច អ៊ែ បូអុះ»។ ");
INSERT INTO tpu_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","ណាអូមី កាប ហះ ម៉ាត់ រូត ផា «អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ដាគ់ កា បូអុះ។ ប‌៉្រ័ះ តាប៉ាប តាប៉ុន កា ប៉ាណូស រ៉ីស លូ ប៉ាណូស តោ័ ដេល»។ ណាអូមី រ៉ះ ណាវ្គ ផា «កាម៉ាក័ ណោះ អ៊ែ ផូង័ វ៉ាច់ ក្យាម័ លូ ពិន ទឹប អ៊ែ ទី ចាបាប់ តង័ ពិន ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","រូត សុនសាត ម៉ូអាប់ អ៊ែ តើល ផា «បូអុះ រ៉ះ លូ អាញ់ អន់ អាញ់ ទូញ ពៀ លូ មួត ទុច អ៊ែ ទឹល ពៀ ណោះ ហាវ»។ ");
INSERT INTO tpu_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","ណាអូមី រ៉ះ កា ម៉ាយ អ៊ែ ផា «ត្រគ់ ហង អីស ឡាំ ទូញ ពៀ ប៉ាគ់ ម៉ីរ បូអុះ លូ ទុច អង់កាន់ អ៊ែ ណោះ។ ផា អីស ឡាំ ទូញ ប៉ាគ់ ម៉ីរ ពូ អន់ទៀគ អ្យូគ ផៃគ ពូ ចឹង ប៉្រគ័ បាប អីស»។ ");
INSERT INTO tpu_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","ណោះ ហង បះ រូត ទូញ ពៀ លូ មួត ទុច អង់កាន់ បូអុះ លើយ ទឹល ពៀ ណោះ ច្រូត័ ទិ។ រូត កា អ្វៃ អន់ឌូ លូ មើគ អន់ហ្នី អ៊ែ តូ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","ប៉ាគ់ ពូ ច្រូត័ កេះ ណាអូមី រ៉ះ លូ រូត ផា «អឺ គន អាញ់ ចឹង ណាំង អន់ ក្លោ កា អីស ម៉ាគ់ អីស ចឹង សាណុក សាវ៉ាក។ ");
INSERT INTO tpu_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","បូអុះ បក់ អីស ឃើយ ឡាំ ទូញ ពៀ លូ មួត ទុច អង់កាន់ អ៊ែ ណោះ អ៊ែ កា ផូង័ វ៉ាច់ ក្យាម័ លូ ពិន ដេល។ ម៉ាំង អា អ៊ែ ឡាំ ប៉្រះ ពៀ ប៉ាគ់ ចារ ប៉្រះ ពៀ។ ");
INSERT INTO tpu_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","ហគ់ អីស ឡាំ ហុំ លូ ឡាប ទៀក បោផូវ កេះណោះ ពៀត អាវ គ្រឹន ឡាំ ប៉ាគ់ ចារ អ៊ែ ប៉្រះ ពៀ ណោះ ហះកា ជែ តាំបាង ឡាកោ អន់ អ៊ែ ប៉ប័ ដៃ ក្យាគ់ អ៊ែ អៃត សា កេះ ហិ។ ");
INSERT INTO tpu_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","ប៉ាគ់ អ៊ែ ឡាំ តៃប អីស ត្រគ់ ហៃ ចារ អ៊ែ តៃប ណោះ។ ទឹល អ៊ែ តៃប ហ្លាក់ កេះ អីស ឡាំ បើក អង់យ៉ាគ័ គែង ជុង អ៊ែ កេះណោះ ម៉ុត តៃប ហះ ជុង អ៊ែ ណោះ ហង អីស ត្រគ់ ចាំ ហៃ នីចម័ អ៊ែ ចឹង រ៉ះ កា អីស»។ ");
INSERT INTO tpu_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","រូត តើល ផា «អាញ់ ចឹង ប៉្រគ័ ពួយ ទិ ប៉ានឹរ អីស រ៉ះ អា ហង»។ ");
INSERT INTO tpu_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","កេះណោះ រូត កា ឡាំ ប៉ាគ់ ចារ ប៉្រះ ពៀ លូ ប៉្រគ័ ពួយ គ្រឹប សារ មើគ អន់ហ្នី អ៊ែ អន់តគ់ រ៉ះ កា អ៊ែ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","បូអុះ អៃត សា កេះ ទិ កេះ ផះ ណោះ ពុត ពៀក អ៊ែ ហោក រ៉គ់ ខាក់ កេះណោះ អ៊ែ ឡាំ តៃប ប៉ាគ់ ប៉ានូក ពៀ។ រូត កា មច ឡាំ បើក អង់យ៉ាគ័ គែង ជុង អ៊ែ កេះណោះ តៃប ហះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","ទឹល ទងតិគ័ ម៉ាំង កេះ បូអុះ សាទឹរ ប្លើក អ៊ែ ប៉ប័ អង់កាន់ តៃប ហះ ជុង អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","អ៊ែ អំប៉ញ់ ផា «ពឿ អា ?» រូត តើល ផា «អាញ់ សិច រូត។ អឺ ពឹ តាំងឡា ប៉រ់ អីស គ្រុំ អាញ់ លូ កាហ្លាប អីស ពិ ខង អីស ទី ចាបាប់ តង័ ញឹន ដេល »។ ");
INSERT INTO tpu_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","បូអុះ តើល ផា «អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ដាគ់ កា អីស។ អីស ប៉្រគ័ នែវ អា ឃឺ អីស តាំបាង ពុត ដាគ់ ត្រង់ ហ៊្លត ឡឹង អន់ទ្រួល ពែ ណាវ្គ ខង អីស អូ ឡាំ ណាំង តាតាម័ សាស្វា យ‌៉័ះ ប‌៉្រ័ះ ប៉ាត្រង័ លើ ថុក អ្យក់ ប៉្រគ័ ក្លោ អីស អុះ។ ");
INSERT INTO tpu_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","កិញអៀ អា អីស ជែ ហ្យឹក ហង សារ អីស ប៉រ់ អា អាញ់ ចឹង ប៉្រគ័ ពួយ ពុត អីស ដេល ខង ទិ ប៉ាសុន ពឹង ស្រុក អា ពូ ប៉ប័ អីស ឡាក់ កា អង់កាន់ ដាគ់ កានឹត កានោរ»។ ");
INSERT INTO tpu_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","បូអុះ រ៉ះ ណាវ្គ ផា «ត្រគ់ ឡាក់ កា អីស ផា ណោះ ហង អាញ់ ផូង័ វ៉ាច់ ក្យាម័ លូ ក្លោ អីស ទឹប ទី ចាបាប់ តង័ អីស តាទឹច ហះកា ទី កាម៉ាក័ ម៉ោញ ដូវ ណាវ្គ ផូង័ វ៉ាច់ ក្យាម័ លូ ក្លោ អីស ហ៊្លត ឡឹង អាញ់ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","ម៉ាំង អា អីស តៃប ហះ អា ហង ពិ។ ប៉ាគ់ តារ កាំលឺ តាយ៉ាង័ អាញ់ ចឹង ឡាំ អំប៉ញ់ លួង អ៊ែ។ ផា អ៊ែ ចៃ កា ដាគ់ ហង ហះកា ផា អ៊ែ អូ ចៃ អាញ់ សាញ៉ា ផា ចឹង ទី អីស លូ រ៉ាំងហៃ រ៉ាំងខ្យា អីស សារ អាញ់ រ៉ះ កា អីស តាទឹច ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ រ៉ីស ដេល។ ប៉រ់ អីស តៃប ហះ អា ហង ម៉ាំង អា លើយ ទឹល តារ»។ ");
INSERT INTO tpu_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","រូត កា តៃប ហះ ជុង បូអុះ ទឹល តារ។ អ៊ែ អ្យូវ ឡឹង ផុងម៉ាំង ជែ អន់ ពូ ប៉ប័ ញន កា បូអុះ អូ អន់ ពឿ អ្លុ កា រូត តៃប ហះ ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","បូអុះ រ៉ះ កា រូត ផា «រ៉ីស អញ់ស៊ែង អីស ពិ»។ រូត កា រ៉ីស អញ់ស៊ែង អ៊ែ។ បូអុះ កា កោច អន់ ពៀ ប៉ាញ័ អញ់ស៊ែង កេះណោះ លឺក អន់ ពឹង កាពែង អ៊ែ រូត កា គ្វី សឹត ប៉ាគ់ ស្រុក ។ ");
INSERT INTO tpu_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","ប៉ាគ់ ទឹល ហី មើគ អន់ហ្នី អ៊ែ អំប៉ញ់ ផា «នីចម័ គន សារ ម៉ាំង ពែ ណោះ ?» រូត កា រ៉ះ លូ មើគ អន់ហ្នី អ៊ែ ទិ សារ បូអុះ កាប លូ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","អ៊ែ រ៉ះ ណាវ្គ «បូអុះ អូ អន់ អាញ់ សឹត ប៉ាគ់ អា តី តាដោះ អុះ ហៃ អា ពៀ អ៊ែ អន់ កា អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","ណាអូមី រ៉ះ កា អ៊ែ ផា «អីស ក្យាគ់ ហៃ សារ អា ចឹង កើត នីចម័ ខង បូអុះ អូ អ្វៃ គ្រឺយ អុះ ដារ់ អា អ៊ែ ចឹង តាគ់ អង់កេះ សារ អា ហង»។ ");
INSERT INTO tpu_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","កេះណោះ បូអុះ ឡាំ អង់អ្វៃ ប៉ាគ់ អំប៉ារ ទ្រួក ផាឌី ប៉ប័ កាម៉ាក័ ឡាក់ ផូង័ វ៉ាច់ ក្យាម័ លូ អេលីម៉ាឡេក កា ពឹះ ទឹល ប៉ាគ់ ណោះ កាម៉ាក័ ណោះ ហង បក់ បូអុះ រ៉ះ លូ រូត ពែ។ ផះ បូអុះ ប៉ប័ កាម៉ាក័ ណោះ អ៊ែ អើ ផា «អឺ ម៉ី ចុ ពឹះ អង់អ្វៃ ប៉ាគ់ អា បៀត ហៃ»។ អ៊ែ កា ឡាំ អង់អ្វៃ ប៉ាគ់ ណោះ តាទឹច ");
INSERT INTO tpu_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","កេះណោះ បូអុះ ឡាំ រ៉ះ លូ មួត ក្រាគ់ តាំងកង់ កាណុង ស្រុក ណោះ ទី ១០ ដូវ ឡាំ អង់អ្វៃ ហះ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","កេះណោះ បូអុះ រ៉ះ លូ កាម៉ាក័ ណោះ ផា «អាញ់ ប៉រ់ កាកាប ឡឹង តេះ ប៉ាដក់ ប៉ាជៀ ឡាក់ ម៉ី ពិន អេលីម៉ាឡេក ប្រូ ពែ កិញអៀ អា ណាអូមី សឹត ឡឹង ប៉ាថេត ម៉ូអាប់ កេះ អ៊ែ ប៉ិច កា ផូង័ វ៉ាច់ ក្លោ អ៊ែ ម៉ោញ ដូវ ហ្វាយ តេះ ណោះ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","អាញ់ ប៉រ់ រ៉ះ លូ អីស អន់ អីស ហ្វាយ ពិ តេះ ណោះ ហះ ម៉ាត់ មួត ក្រាគ់ តាំងកង់ ទិឌូ អា អន់ អន់ឌែ កាតាំង ដេល។ ហះកា ផា អីស អូ ចៃ ប៉រ់ អីស រ៉ះ អន់ អាញ់ អ្លុ ដេល ខង អីស ឡាក់ អុះ ម៉ី ក្យាម័ ឡឹង ពូ ឡៃង ឡឹង អីស អាញ់ អា ហង»។ អ៊ែ តើល ផា «អាញ់ ចឹង ហ្វាយ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","បូអុះ រ៉ះ ផា «ផា អីស ហ្វាយ អ្យក់ តេះ ណោះ ប៉រ់ អីស អ្យក់ ទឹប រូត សុនសាត ម៉ូអាប់ ប៉្រគ័ កាម៉ាញ់ អីស ម៉ាគ់ អីស ចឹង ប៉ាំងកើត គន  តេះ ណោះ ចឹង ត្រគ់ ប៉ាដក់ ប៉ាជៀ កា គន ណោះ ម៉ាគ់ ដាគ់ អូ ហ៊្យង សិច ម៉ី ពិន ឡាក់ តោ័ ណោះ ឃឺ តេះ ណោះ ឡាក់ តេះ អ៊ែ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","កាម៉ាក័ ណោះ តើល ផា «ផា នីណោ័ះ អាញ់ អូ ចៃ ហ្វាយ ហង ផា ប៉្រគ័ នីណោ័ះ ប៉ាដក់ ប៉ាជៀ អាញ់ លូ សិច អាញ់ ចឹង ហ៊្យង ហង។ ហគ់ ហ្វាយ អ្យក់ កា អីស ឡគ ពិ អាញ់ អូ ហ្វាយ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","ផះ សើគ ពែ សុនសាត អ៊ីស្រាអ៊ែល ផា ពូ តាច់ រ៉ាស អំប៉ាស លូ មប កាណាគ័ ញ៉ា កាតាម ពូ ឃើយ តាឡេះ កឺប អន់ទឺប អន់ កា ប៉ាណូស ម៉ោញ ដូវ ណាវ្គ ឃឺ ប៉្រគ័ សាញ៉ា ផា សារ ណោះ ពូ ភម លូ គួប កេះ។ ");
INSERT INTO tpu_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","ទឹល នីណោ័ះ ផះ កាម៉ាក័ ណោះ រ៉ះ ផា «ហគ់ ហ្វាយ អ្យក់ កា អីស ពិ» អ៊ែ កា តាឡេះ ឡាច់ កឺប អន់ទឺប អន់ កា បូអុះ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","បូអុះ កា រ៉ះ លូ មួត ក្រាគ់ តាំងកង់ លូ មួត ប៉ាសុន អ្វៃ រសានែង ណោះ ផា «ដារ់ អា ប៉រ់ អន់ដីស ប៉្រគ័ ផាញ៉ាន កា អាញ់។ អាញ់ ចឹង ហ្វាយ កាណាគ័ ញ៉ា ៗ ឡាក់ ម៉ះ អេលីម៉ាឡេក លូ ម៉ះ គន អ៊ែ គីលីយ៉ូន ទឹប ម៉ាឡូន ហង។ ");
INSERT INTO tpu_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","អាញ់ ចឹង អ្យក់ ទឹប រូត សុនសាត ម៉ូអាប់ ឡាក់ កាម៉ាញ់ ម៉ាឡូន ពែ អាញ់ ចឹង ទី កា អាញ់ ឡគ ភឿ តូ ផូង័ ម៉ាគ់ អន់ ប៉ាដក់ ប៉ាជៀ ម៉ាឡូន អ្វៃ លើយ ប៉្រគ័ នីណោ័ះ ម៉ាគ់ សិច អ៊ែ ដាគ់ អូ ហ៊្យង ឡឹង ផូង័ ពិន។ អន់ដីស ទិឌូ ប៉្រគ័ ផាញ៉ាន កា អាញ់ ដារ់ អា»។ ");
INSERT INTO tpu_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","មួត ក្រាគ់ តាំងកង់ លូ មួត ប៉ាសុន អ្វៃ រសានែង ណោះ ទិឌូ កា តើល ផា «ញឹន ទិឌូ ប៉្រគ័ ផាញ៉ាន កា អីស កេះ។ អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ គន សោ អៀង កា អង់កាន់ បក់ ចឹង អ្វៃ លូ អីស អន់ អ៊ែ ឡាក់ កា យ៉ាគ់ រ៉ាជែល លូ យ៉ាគ់ លេអា ដេល ឡាក់ ប៉ាំងកើត សុនសាត អ៊ីស្រាអ៊ែល ពែ។ អន់ អីស ប‌៉្រ័ះ ប៉ាត្រង័ លូ លៅ លែង សិច ពឹង តេះ បេតាលេហិម។ ");
INSERT INTO tpu_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","អន់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ អន់ដីស ទី គន សោ ឡាក់ កា គន សោ វគ័ ពែរេះ គន យ៉ាគ់ តាម៉ារ លូ វគ័ យូដា ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","កេះណោះ បូអុះ កា ទី រូត ហង។ ឡៃង ឡឹង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ រូត ឡាកោ គៀម អ្វៃ ហាអុញ កើត គន កាម៉ាក័។ ");
INSERT INTO tpu_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","មួត អង់កាន់ អ្វៃ ពឹង តេះ បេតាលេហិម កាប លូ ណាអូមី ផា «ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ខង អ៊ែ អន់ សោ កាម៉ាក័ កា អីស ម៉ោញ ដូវ សាំរ៉ាប់ រ៉ាំងហៃ រ៉ាំងខ្យា អីស។ អន់ សោ អីស ណោះ លៅ លែង សិច ប៉ាញ័ ទឹប ប៉ាថេត អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","សោ អីស អា ចឹង ប៉្រគ័ អន់ អីស សាណុក សាវ៉ាក លូ ចឹង រ៉ាំងហៃ រ៉ាំងខ្យា ប៉ាគ់ អីស ក្រាគ់ ទៀ។ សាស្វា អា កើត ឡឹង ម៉ាយ អីស បក់ ប៉ិច ចៃ កា អីស ខាក់។ ណាង អា ដាគ់ ហ៊្លត ឡឹង គន កាម៉ាក័ តាំប៉ើះ ដូវ សាំ»។ ");
INSERT INTO tpu_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","ណាអូមី កា អ្យក់ ពៅ សោ អ៊ែ លូ រ៉ាំងហៃ លើយៗ។ ");
INSERT INTO tpu_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","មួត អង់កាន់ អ្វៃ រសានែង ណោះ អន់ឌែ កាប ផា «ណាអូមី ទី សោ កាម៉ាក័ ម៉ោញ ដូវ កេះ»។ អន់ឌែ កា អន់ សិច ផា អូបេត។ អូបេត អា ហង ឡាក់ ពឹ វគ័ យេសាយ ឡាក់ ពឹ សាដាច់ ដាវីត។ ");
INSERT INTO tpu_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","អា ហង សារ ផូង័ វ៉ាច់ ពែរេះ៖ ពែរេះ គន អ៊ែ ហេស្រុន ");
INSERT INTO tpu_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","ហេស្រុន គន អ៊ែ រ៉ាម រ៉ាម គន អ៊ែ អាមីណាដាប់ ");
INSERT INTO tpu_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","អាមីណាដាប់ គន អ៊ែ ណាសូន ណាសូន គន អ៊ែ សាល់ម៉ូន ");
INSERT INTO tpu_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","សាល់ម៉ូន គន អ៊ែ បូអុះ បូអុះ គន អ៊ែ អូបេត ");
INSERT INTO tpu_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","អូបេត គន អ៊ែ យេសាយ យេសាយ គន អ៊ែ សាដាច់ ដាវីត។ ");
INSERT INTO tpu_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","ទី កាម៉ាក័ ម៉ោញ ដូវ សិច អ៊ែ អ៊ែលកាណា អ៊ែ អ្វៃ ពឹង តេះ រ៉ាម៉ា ព្រី ប៉ានឹម អេប៉្រាអ៊ីម អ៊ែ គន វគ័ យេរ៉ូហាំ សោ វគ័ អេលីហ៊ូ សោ ចិច វគ័ ថូហ៊ូ សោ ចាំង វគ័ ស៊ូប កាណុង ផូង័ អេប៉្រាអ៊ីម។ ");
INSERT INTO tpu_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","កាម៉ាក័ ណោះ ទី កាម៉ាញ់ ពៀរ ម៉ោញ សិច ហាណា ម៉ោញ ណាវ្គ សិច ពែនីណា។ ពែនីណា ទី គន អៀង ហះកា ហាណា អូ ទី គន អុះ។ ");
INSERT INTO tpu_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","រ៉ប់ សាណាំ អ៊ែលកាណា ពឹះ ឡឹង ស្រុក អ៊ែ ឡាំ ប៉ាគ់ មឿង ស៊ីឡូ ភឿ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ តេះ ប‌៉្រ័ះ ប៉្លៃង ទឹប ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ដេល។ ផះ រ៉ាំងវ៉ាង ណោះ គន កាម៉ាក័ វគ័ អេលី ទិ ពៀរ ដូវ ហូបនី លូ ភីនេហះ ប៉្រគ័ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ពឹង មឿង ស៊ីឡូ។ ");
INSERT INTO tpu_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","ពឹង ដារ់ អ៊ែ រ៉ាម៉ះ ប‌៉្រ័ះ អ៊ែលកាណា ឃើយ អ្យក់ ប៉ាំងឡៃ អន់ កា កាម៉ាញ់ អ៊ែ ពែនីណា លូ គន កាម៉ាក័ គន អង់កាន់ អ៊ែ ម៉ោញ ដូវ ម៉ោញ ចានែក។ ");
INSERT INTO tpu_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","កាប៉ាច់ កា ហាណា អ៊ែ អន់ ពៀរ ចានែក ញន កា អ៊ែ ប៉ិច កា ហាណា ហ៊្លត ឡឹង ពែនីណា យ‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ ហាណា អូ ទី គន កាតាម។ ");
INSERT INTO tpu_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","ពែនីណា សាណីង អ៊ែ ឌុ ប៉្រគ័ អន់ ហាណា អីគ ពុត អ៊ែ ប៉្រគ័ អន់ កា ហាណា តាយួស ញន កា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ ហាណា អូ អ្លុ ទី គន។ ");
INSERT INTO tpu_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","ពែនីណា ប៉្រគ័ នែវ ណោះ រ៉ប់ សាណាំ។ រ៉ប់ ហាណា ឡាំ ប៉ាគ់ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាគ់ មឿង ស៊ីឡូ ពែនីណា ប៉្រគ័ កា ហាណា នីណោ័ះ លើយៗ។ ហាណា កា ញ៉ាំ លូ អូ ចៃ សា សាណា ញ៉ា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","ផះ ណោះ អ៊ែលកាណា កា អំប៉ញ់ អ៊ែ ផា «ហាណា ញ៉ា ត្រគ់ អីស ញ៉ាំ លូ អូ សា សាណា នីអៀ ? ខ ញ៉ា បះ អីស អុក ពុត? ញ៉ា អីស ឃឹត ផា អាញ់ អូ សាម៉ើ លូ គន អញ់ជឹត ដូវ ណោះ ប ?»។ ");
INSERT INTO tpu_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","កេះ ពូ អៃត សា កេះៗ ហាណា កា អ្យូវ ឡាំ ម៉ន់ អើ ប‌៉្រ័ះ។ ផះ ណោះ វគ័ អេលី ឡាក់ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ កា អង់អ្វៃ ពឹង គ្រេ ហះ អំប៉ារ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","ហាណា អុក ពុត ខាក់ កា ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ទឹប ញ៉ាំ ហូរ័ ទៀក ម៉ូះ ទៀក ម៉ាត់។ ");
INSERT INTO tpu_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","អ៊ែ ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ តេះ ប‌៉្រ័ះ ប៉្លៃង ប៉រ់ អីស ហៃ អាញ់ ណើ អាញ់ អុក ពុត ខាក់ ប៉រ់ អីស តាប៉ាប ជែ អ្លាត អាញ់ ឡាក់ ទុច អីស ដៃ។ ផា អីស តាប៉ាប អន់ អាញ់ ទី គន កាម៉ាក័ ម៉ោញ អាញ់ ចឹង មប គន ណោះ អន់ កា អីស ភឿ អន់ ប៉្រគ័ ង៉ារ កា អីស ឡុច អាញុ អ៊ែ សក់ អ៊ែ ចឹង អូ កូរ័ លើ កាត់ អុះ »។ ");
INSERT INTO tpu_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","ហាណា ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ទុញៗ ផះ ណោះ វគ័ អេលី ចាំ ហៃ ពឹរ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","ហាណា ម៉ន់ អូ កាតាំង តេះ អុះ ប៉ប័ ដឹង យ៉ើល អន់តង់ ពឹរ ដោច។ ណោះ ហង បះ វគ័ អេលី សាម៉គ័ កា ហាណា ប៉ាញឹល តាពែ ");
INSERT INTO tpu_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","អ៊ែ កាប កា ហាណា ផា «ញ៉ា ត្រគ់ អីស អ្វៃ ប៉ាញឹល នែវ អា ? អ្យគ័ អ្លាត អៃត ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","ហាណា តើល ផា «អូ អុះ ពឹ តាំងឡា អាញ់ អូ ទី អៃត តាពែ អុះ អាញ់ អ្វៃ ហះ អា ភឿ រ៉ះ លូ ប‌៉្រ័ះ ប៊កកាតយ័ ឡឹង សារ អាញ់ អុក ពុត។ ");
INSERT INTO tpu_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","ជែ ឃឹត ផា អាញ់ ឡាក់ អង់កាន់ អូ ដាគ់ អាញ់ ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ តុត ទុញ នីអៀ ញន កា អាញ់ អុក ពុត លូ ទី សារ ប៉ាណាប ប៉ាបប៉ុន អៀង ឡក់ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","វគ័ អេលី កាប លូ អ៊ែ ផា «ហគ់ អន់ អីស ចាក ដាគ់ ចាក ប៉ាឡឹង អន់ ប‌៉្រ័ះ សុនសាត ពិន អន់ សារ ដាគ់ កា អីស ឡាក់ កា អីស ប៉រ់ ឡឹង អ៊ែ ណោះ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","ហាណា កាប ផា «អាញ់ ប៉ានេ កា អីស ទី ពុត ដាគ់ កា អាញ់»។ កេះណោះ ហាណា ចាក ឡាច់ ឡឹង ណោះ លូ សា សាណា ទឹប រ៉គ់ រែ។ ");
INSERT INTO tpu_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","អ៊ែលកាណា លូ ខាប់ខួ អ៊ែ អ្យូវ ឡឹង កាំលឺ ផុងម៉ាំង ឡាំ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័  កេះណោះ អន់ឌែ សឹត ប៉ាគ់ ហី អន់ឌែ ប៉ាគ់ តេះ រ៉ាម៉ា។ អ៊ែលកាណា កា តៃប លូ កាម៉ាញ់ អ៊ែ ហាណា ប‌៉្រ័ះ ប៊កកាតយ័ កា កាចាំង ឡឹង សារ ហាណា ម៉ន់ ឡោម។ ");
INSERT INTO tpu_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","រ៉ាំងវ៉ាង សាណាំ ណោះ ហាណា កា ឡាកោ គៀម ប៉ាគ់ គ្រឹប ខៃ អ៊ែ អ្វៃ ហាអុញ ទី គន កាម៉ាក័ អ៊ែ អន់ សិច ផា សាំយូអ៊ែល ទឹប កាប ផា «អាញ់ ម៉ន់ ប៉រ់ លូ ប‌៉្រ័ះ ប៊កកាតយ័ »។ ");
INSERT INTO tpu_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","ឡៃង ឡឹង ណោះ អ៊ែលកាណា លូ ខាប់ខួ អ៊ែ ទិឌូ អន់ឌែ អ្យក់ កាណាគ័ ឡាំ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ឃើយ ប៉្រគ័ រ៉ប់ សាណាំ ទឹប ពុះ កាណាគ័ ឡាក់ កា អ៊ែ សាញ៉ា ចឹង រ៉ាម៉ះ កា ប‌៉្រ័ះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","ហះកា ហាណា អូ ឡាំ អន់ឌូ លូ ក្លោ អ៊ែ អុះ អ៊ែ រ៉ះ កា ក្លោ អ៊ែ ផា «ក្យាគ់ គន អាញ់ អ្លាត ម៉ម់ ហិ ណោះ អាញ់ ចឹង ឡាំ មប អ៊ែ អន់ កា ប‌៉្រ័ះ ប៊កកាតយ័  អាញ់ ចឹង អន់ អ៊ែ អ្វៃ ហះ ណោះ លើយ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","ក្លោ អ៊ែ តើល ផា «ហគ់ ប៉្រគ័ ពួយ ឡាក់ កា អីស ឃឹត ផា ដាគ់ ពិ អីស អ្វៃ អន់ឌូ លូ គន ទឹល អ៊ែ អ្លាត ម៉ម់។ អន់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ ពួយ ប៉ានឹរ អ៊ែ សាញ៉ា ណោះ ហង»។ ហាណា កា អ្វៃ ក្យាគ់ ហី លូ តាម៉ម់ គន អ៊ែ លើយ ទឹល គន អ៊ែ អ្លាត ម៉ម់។ ");
INSERT INTO tpu_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","ប៉ាគ់ គន អ៊ែ អ្លាត ម៉ម់ កេះ អ៊ែ កា អ្យក់ គន ឡាំ ប៉ាគ់ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាគ់ មឿង ស៊ីឡូ ទឹប អ្យក់ រ៉ក់ ទោល ម៉ោញ កាតុ អាញុ ប៉ៃង សាណាំ តាប៉ុង ម៉ោញ កាអ្លី លូ តាពែ ប៉្លៃ អង់កាច ម៉ោញ ស្រោ អង់ការ។ ផះ ណោះ សាំយូអ៊ែល អ្វៃ សាស្វា ឡក់។ ");
INSERT INTO tpu_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","អន់ឌែ កោះ រ៉ក់ កេះណោះ ប៉ាណាំ សាស្វា សាំយូអ៊ែល ឡាំ អ្វៃ លូ វគ័ អេលី។ ");
INSERT INTO tpu_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","ហាណា កាប ផា «ពឹ តាំងឡា អាញ់ អា ហង អង់កាន់ បក់ អន់តាវ ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ហះ អា ក្យាម័ អីស ផះ អន់ទ្រួល ពែ។ សារ អា ត្រគ់ តាទឹច ឡាក់ កា អីស អ្វៃ រ៉ីស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","អាញ់ ខំ ឡោម ប៉រ់ ហះ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ អាញ់ ទី គន អ៊ែ កា អន់ អាញ់ ទី គន តាទឹច ពួយ ប៉ានឹរ អាញ់ ប៉រ់ ពែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","កិញអៀ អា អាញ់ អ្យក់ គន មប កា ប‌៉្រ័ះ ប៊កកាតយ័ ម៉ាគ់ ប៉្រគ័ ង៉ារ កា ប‌៉្រ័ះ ឡុច អាញុ អ៊ែ»។ កេះណោះ សាំយូអ៊ែល កា សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ហះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","កេះណោះ វគ័ អ៊ែលកាណា កា សឹត ប៉ាគ់ ហី អ៊ែ ទៅ ប៉ាគ់ តេះ រ៉ាម៉ា ណាវ្គ ហះកា សាស្វា សាំយូអ៊ែល អ្វៃ ប៉្រគ័ ង៉ារ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ឌូ លូ វគ័ អេលី ឡាក់ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ។ ");
INSERT INTO tpu_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","គន កាម៉ាក័ វគ័ អេលី ឡាក់ ប៉ាណូស អូ ដាគ់ កាខាក់ អន់ឌែ អូ អ្យិល កូត័ កា ប‌៉្រ័ះ ប៊កកាតយ័ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","យ‌៉័ះ អន់ឌែ ឡាក់ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ កាតាម អន់ឌែ ប៉្រគ័ អូ ដាគ់ កា មួត ប៉ាសុន លើយៗ រ៉ប់ ពូ អ្យក់ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ប៉្រើ ទុច អន់ឌែ ម៉ុត ផះ ពូ សាន់តុក ប៉ាំងឡៃ សាអ៊្លង ណោះ ដេល លូ ចឹក បួង រ៉ាណះ ទី សាណាញ់ ប៉ៃង។ ");
INSERT INTO tpu_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","ទុច ណោះ កា អ្យក់ បួង រ៉ាណះ តាល់ ប៉ាំងឡៃ សាអ៊្លង ពូ សាន់តុក កាណុង កគ័ ប៉ាំងឡៃ សាអ៊្លង ឡាក់ ទួម ពឹង បួង រ៉ាណះ ណោះ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ អ្យក់ កា អ៊ែ តាំងឡា ទិណោ័ះ អន់ឌែ ប៉្រគ័ នីណោ័ះ លើយៗ កា សុនសាត អ៊ីស្រាអ៊ែល បក់ ពឹះ រ៉ាម៉ះ ប‌៉្រ័ះ ប៉ាគ់ មឿង ស៊ីឡូ។ ");
INSERT INTO tpu_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","ម៉ោញ ណាវ្គ អន់ទ្រួល ឡឹង ពូ ពុះ អ្លាត ប៉ុង  ទុច ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ពឹះ កាប លូ បក់ ពឹះ រ៉ាម៉ះ ណោះ ផា «ប៉ឹះ អន់ ប៉ាំងឡៃ កា ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ តាទៀង អ៊ែ អូ អ្យក់ ប៉ាំងឡៃ សាន់តុក ឡឹង អីស អុះ អ៊ែ អ្យក់ ដឹង ប៉ាំងឡៃ អន់ទ្រិះ»។ ");
INSERT INTO tpu_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","ផា បក់ ណោះ កាប ផា «កូម័ ពុះ ប៉ុង អន់ទ្រួល ហិ កេះណោះ អ្យក់ តាម ពុត ពិ» ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ កាប ផា «អូ អុះ ត្រគ់ អន់ កា អាញ់ កិញអៀ ហង ផា អូ នីណោ័ះ អាញ់ ចឹង រ៉ាត អ្យក់ ឡូត»។ ");
INSERT INTO tpu_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","សារ អូ ដាគ់ គន វគ័ អេលី ប៉្រគ័ ណោះ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ កាខាក់ ឡូត ខង អន់ឌែ បឺង៉ាយ កាណាគ័ ពូ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","កាប៉ាច់ សាស្វា សាំយូអ៊ែល ប៉្រគ័ ង៉ារ ប‌៉្រ័ះ ប៊កកាតយ័  អ៊ែ កា ពៀត អាវ អ្លឹង ឡាក់ កា មួត ក្រាគ់ រ៉ាម៉ះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","មើគ អ៊ែ ជឹង អាវ ថិ ម៉ោញ អ្យក់ ឡាំ អន់ កា អ៊ែ រ៉ប់ សាណាំ ផះ អ៊ែ ពឹះ អន់ឌូ លូ ក្លោ អ៊ែ ភឿ រ៉ាម៉ះ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","វគ័ អេលី ប៉រ់ សារ ដាគ់ កា អ៊ែលកាណា លូ កាម៉ាញ់ អ៊ែ ហាណា ផា «អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ អីស ទី គន ណាវ្គ លូ អង់កាន់ អា ប៉ាតាង គន បក់ កាម៉ាញ់ អីស មប កា ប‌៉្រ័ះ ប៊កកាតយ័ »។ កេះណោះ អន់ឌែ កា សឹត ប៉ាគ់ ហី ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","ប‌៉្រ័ះ ប៊កកាតយ័ កា អន់ សារ ដាគ់ កា ហាណា អ៊ែ កា ឡាកោ គៀម ទី គន លើយ ហង គន កាម៉ាក័ អ៊ែ ប៉ៃង ដូវ លូ គន អង់កាន់ ពៀរ ដូវ។ សាស្វា សាំយូអ៊ែល កា ហ៊ែង តីស ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","កាប៉ាច់ វគ័ អេលី អ៊ែ ក្រាគ់ ឡក់ កេះ អ៊ែ កាតាំង ពូ រ៉ះ សារ អៀង ខ ឡឹង គន អ៊ែ ទិ ពៀរ ប៉្រគ័ អូ ដាគ់ កា សុនសាត អ៊ីស្រាអ៊ែល ទិណោ័ះ ទឹប អន់ឌែ តៃប លូ អង់កាន់ ឡាក់ ប៉្រគ័ ង៉ារ ហះ អំប៉ារ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","វគ័ អេលី កាប កា គន អ៊ែ ផា «ញ៉ា ត្រគ់ អន់ដីស ប៉្រគ័ នីអៀ ? អាញ់ កាតាំង មួត ប៉ាសុន ទិឌូ រ៉ះ ឡឹង សារ អូ ដាគ់ ឡាក់ អន់ដីស ប៉្រគ័។ ");
INSERT INTO tpu_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","គន អូ ត្រគ់ ប៉្រគ័ នែវ ណោះ អុះ សារ ឡាក់ អាញ់ កាតាំង មួត ប៉ាសុន ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ឡឹង សារ អន់ដីស ប៉្រគ័ ណោះ អ៊ែ អូ ដាគ់ យ៉ឹប។ ");
INSERT INTO tpu_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","ផា ប៉ាណូស ម៉ោញ ដូវ ប៉្រគ័ អូ ដាគ់ កា ប៉ាណូស ម៉ោញ ដូវ ណាវ្គ ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង រ៉ះកះ ប៉ារម ហះកា ផា ប៉ាណូស ប៉្រគ័ យច លូ ប‌៉្រ័ះ ប៊កកាតយ័  អូ ទី ពឿ ចឹង រ៉ះកះ ប៉ារម កា អ៊ែ អុះ» ហះកា គន វគ័ អេលី ទិ ពៀរ អូ សាំយ៉ាំង អ៊ែ អុះ ខង ប‌៉្រ័ះ ប៊កកាតយ័ ឃឹត ចឹង ប៉ាន់តោ័ អ្លាត អន់ឌែ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","កាប៉ាច់ សាស្វា សាំយូអ៊ែល កា ហ៊ែង តីស ទឹប ប៉ាញ័ ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ហ៊ែង ខាក់ លូ ប៉ាញ័ ពុត ប៉ាណូស អន់ទៀគៗ ណាវ្គ ដេល។ … ");
INSERT INTO tpu_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","សាស្វា សាំយូអ៊ែល ប៉្រគ័ ង៉ារ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ឌូ លូ វគ័ អេលី។ ផះ រ៉ាំងវ៉ាង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ អូ ង៉ាយ ចឹង កាប លូ ប៉ាណូស អុះ កា អូ សូវ តាំបាង ឡាកោ អន់ ពូ ប៉ប័ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","រ៉ាំងវ៉ាង ណោះ ម៉ាត់ វគ័ អេលី កា ចឹង ម៉ាម៉ាំង ហៃ អូ សូវ ប៉ប័ កេះ។ ផះ វគ័ អេលី តៃប ពឹង កាណុង អ៊ែ ទៅ ");
INSERT INTO tpu_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","តាគៀង ពូ សុះ ពឹង កាណុង ដាគ់ បើ ប៉ាត់ អុះ សាស្វា សាំយូអ៊ែល តៃប ពឹង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ក្យាម័ ចារ ពូ ចៃគ ហ៊ីប សារ សាញ៉ា រែវ ពុត ។ ");
INSERT INTO tpu_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","ផាឌី ប‌៉្រ័ះ ប៊កកាតយ័ អើ សាំយូអ៊ែល អ៊ែ កា តើល ផា «ញ៉ា ?» ");
INSERT INTO tpu_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","កេះណោះ អ៊ែ សាតាក់ ឡាំ ប៉ាគ់ ចារ វគ័ អេលី អ៊ែ អំប៉ញ់ ផា «អើ អាញ់ ទី កាន ញ៉ា ?» វគ័ អេលី តើល ផា «អាញ់ អូ ទី អើ អីស អុះ អីស ឡាំ តៃប ណាវ្គ ពិ»។ សាំយូអ៊ែល កា ឡាំ តៃប ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","ប‌៉្រ័ះ ប៊កកាតយ័ កា អើ សាំយូអ៊ែល ម៉ោញ ទង ណាវ្គ សាំយូអ៊ែល កា អ្យូវ ឡាំ ប៉ាគ់ ចារ វគ័ អេលី លូ អំប៉ញ់ ផា «អីស អើ អាញ់ ទី កាន ញ៉ា ?» វគ័ អេលី តើល ផា «អាញ់ អូ ទី អើ អីស អុះ ឡាំ តៃប ណាវ្គ ពិ សោ»។ ");
INSERT INTO tpu_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","សាំយូអ៊ែល អូ អន់ហ្នាល់ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ អុះ ខង ប‌៉្រ័ះ ប៊កកាតយ័ បើ កាកាប លូ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","ប‌៉្រ័ះ ប៊កកាតយ័ អើ សាំយូអ៊ែល លឺក ទី ប៉ៃង។ សាំយូអ៊ែល កា អ្យូវ ឡាំ ប៉ាគ់ ចារ វគ័ អេលី លូ អំប៉ញ់ ផា «អីស អើ អាញ់ ទី កាន ញ៉ា ?» វគ័ អេលី កា អ្លុ អន់តគ់ ផា ប‌៉្រ័ះ ប៊កកាតយ័ ហង អើ សាំយូអ៊ែល ");
INSERT INTO tpu_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","ទឹល នីណោ័ះ វគ័ អេលី រ៉ះ កា សាំយូអ៊ែល ផា «ឡាំ តៃប ណាវ្គ ពិ។ ផា កាតាំង ប៉ានឹរ ពូ អើ ម៉ោញ ទង ណាវ្គ អីស ត្រគ់ កាប ផា \"អឺ ប‌៉្រ័ះ ប៊កកាតយ័  ប៉រ់ អីស រ៉ះ កា អាញ់ ពិ អាញ់ ឡាក់ ទុច អីស ក្យាគ់ សាំយ៉ាំង អីស កេះ\"»។ កេះណោះ សាំយូអ៊ែល កា ឡាំ តៃប ប៉ាគ់ ចារ ទៅ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","ផះ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កា ជឹរ អន់តាវ ក្យាម័ ហះ ណោះ អ៊ែ អើ ឡាក់ កា អ៊ែ អើ អន់ទ្រួល ពែ ដេល «សាំយូអ៊ែល សាំយូអ៊ែល !» សាំយូអ៊ែល តើល ផា «ប៉រ់ អីស រ៉ះ កា អាញ់ ពិ អាញ់ ឡាក់ ទុច អីស ក្យាគ់ សាំយ៉ាំង អីស កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ ផា «ហៃ អាញ់ ចឹង ប៉្រគ័ អន់ ទី សារ ប៉ាណាប ម៉ោញ កើត ពឹះ ពឹង ប៉ាថេត អ៊ីស្រាអ៊ែល។ ពឿ កាតាំង សារ អា បក់ ណោះ ចឹង កាខរ់ ណូស ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","ប៉ាគ់ ដារ់ អន់តីគ អាញ់ ចឹង ប៉្រគ័ កា ខាប់ខួ អេលី អន់ ត្រគ់ ពួយ គ្រឹប សារ អាញ់ រ៉ះ កា អ៊ែ ពែ ឡឹង គុល ទឹល ឡុច។ ");
INSERT INTO tpu_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","អាញ់ រ៉ះ កា អ៊ែ ផា អាញ់ ចឹង ចៃគ ថូត ខាប់ខួ អ៊ែ លើយ ញន កា សារ គន អ៊ែ ទិ ពៀរ ប៉្រគ័ យច ណោះ ខង អ៊ែ អ្លុ អន់តគ់ ផា គន អ៊ែ បឺង៉ាយ អាញ់ ហះកា អ៊ែ អូ ប៉្រគ័ តាគ់ អញ់ចាល អន់ឌែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","ញន ណោះ ហង បះ អាញ់ ម៉ត់ លូ ខាប់ខួ អ៊ែ ផា អាញ់ អូ អ្លាត ដោះ សារ អន់ឌែ ប៉្រគ័ យច ណោះ អុះ យ‌៉័ះ អន់ឌែ ពុះ កាណាគ័ ញ៉ា រ៉ាម៉ះ អាញ់ កាតាម»។ ");
INSERT INTO tpu_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","សាំយូអ៊ែល កា តៃប ទឹល តារ ប៉ាគ់ តារ កាំលឺ អ៊ែ កា បើក អំប៉ារ ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ សាំយូអ៊ែល អូ ខឹន រ៉ះ កា វគ័ អេលី ឡឹង សារ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ អ៊ែ កាតាំង លូ ប៉ប័ ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","វគ័ អេលី អើ សាំយូអ៊ែល ផា «អឺ សោ»។ សាំយូអ៊ែល តើល ផា «ញ៉ា ?» ");
INSERT INTO tpu_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","វគ័ អេលី អំប៉ញ់ ផា «ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ សារ ញ៉ា អន់ដា កា អីស ? អីស ជែ អោន សារ ញ៉ា កា អាញ់ ដៃ។ ផា អីស អោន សារ ញ៉ា ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ណោះ អន់ ប‌៉្រ័ះ ប៊កកាតយ័ ចៃគ ថូត អីស ក្លាំង ខាក់»។ ");
INSERT INTO tpu_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","សាំយូអ៊ែល កា រ៉ះ កា វគ័ អេលី ឡឹង សារ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ ទិណោ័ះ អូ ទី អោន សារ ញ៉ា អុះ។ វគ័ អេលី កាប ផា «អ៊ែ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័  អន់ អ៊ែ ប៉្រគ័ ឡាក់ កា ពុត អ៊ែ ប៉ិច ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","សាំយូអ៊ែល កា ហ៊ែង តីស ៗ ប‌៉្រ័ះ ប៊កកាតយ័ កា អ្វៃ អន់ឌូ លូ អ៊ែ ទិ សារ អ៊ែ រ៉ះ ប‌៉្រ័ះ កា ប៉្រគ័ អន់ កើត ពឹះ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","ពឹង ប៉ាថេត អ៊ីស្រាអ៊ែល ទិណោ័ះ ឡឹង មឿង ដាន់ លើយ ទឹល មឿង បៀសេបា ប៉ាសុន ទិឌូ ឃឹត ផា សាំយូអ៊ែល ឡាក់ រ៉ាគឹយប‌៉្រ័ះ ប៊កកាតយ័ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","ប‌៉្រ័ះ ប៊កកាតយ័ តាំបាង ឡាកោ អន់ សាំយូអ៊ែល ប៉ប័ លើយៗ ប៉ាគ់ មឿង ស៊ីឡូ។ អ្វៃ ប៉ាគ់ មឿង ណោះ ប‌៉្រ័ះ ឃើយ រ៉ះ អន់ សាំយូអ៊ែល សាំយ៉ាំង សាំយូអ៊ែល កា រ៉ះ តូ កា ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ។ … ");
INSERT INTO tpu_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","ប៉ាគ់ វគ័ សាំយូអ៊ែល ក្រាគ់ កេះ អ៊ែ ប៉្រើ គន កាម៉ាក័ អ៊ែ ពៀរ ដូវ រ៉ាំងហៃ សុនសាត អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","គន ឡោងទ្រៀ អ៊ែ សិច យូអ៊ែល លូ គន ទី ពៀរ សិច អាប៊ីយ៉ា។ អន់ឌែ ទិ ពៀរ ដូវ រ៉ាំងហៃ ពឹង មឿង បៀសេបា។ ");
INSERT INTO tpu_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","ហះកា គន វគ័ សាំយូអ៊ែល អូ ប៉្រគ័ ពួយ អ៊ែ អុះ។ អន់ឌែ ខ្វាម ប៉ិច ដឹង កា ទី លៀន លូ អ្យក់ លៀន ពូ ច្វាល់ តាត់ស៊ិន សារ អូ ត្រង់។ ");
INSERT INTO tpu_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","មួត ក្រាគ់ តាំងកង់ សុនសាត អ៊ីស្រាអ៊ែល ទិឌូ កា លួម គួប សោប ឡាំ កាកាប លូ វគ័ សាំយូអ៊ែល អ្វៃ ប៉ាគ់ តេះ រ៉ាម៉ា។ ");
INSERT INTO tpu_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","ក្រាគ់ តាំងកង់ ទិណោ័ះ រ៉ះ លូ អ៊ែ ផា «កិញអៀ អា អីស ក្រាគ់ កេះ គន អីស កា អូ ប៉្រគ័ ពួយ អីស ដេល។ ទឹល នីណោ័ះ ប៉រ់ អីស រ៉ើស ប៉ាណូស ម៉ោញ ដូវ ប៉្រើ ប៉្រគ័ សាដាច់ រ៉ាំងហៃ ញឹន ឡាក់ កា សុនសាត អន់ទៀគ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","ផះ កាតាំង មួត ក្រាគ់ តាំងកង់ ផា «ប៉រ់ អន់ ទី សាដាច់ ម៉ោញ ដូវ រ៉ាំងហៃ ញឹន» វគ័ សាំយូអ៊ែល អុក ពុត ខាក់ អ៊ែ កា ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ ផា «ហគ់ សាំយ៉ាំង ប៉ានឹរ ប៉ាសុន ប៉រ់ ណោះ ពិ។ អូ ត្រគ់ អន់ឌែ អ្លាត អីស អុះ អន់ឌែ អ្លាត អាញ់ អន់ឌែ អូ ប៉ិច អន់ អាញ់ ប៉្រគ័ សាដាច់ រ៉ាំងហៃ អន់ឌែ ណាវ្គ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","ឡឹង ដារ់ អាញ់ ប៉ាណាំ អន់ឌែ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប លើយ ទឹល កិញអៀ អា អន់ឌែ អ្លាត អាញ់ ភឿ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ អន់ទៀគ ណាវ្គ។ អន់ឌែ ប៉្រគ័ កា អីស ឡាក់ កា អន់ឌែ តាឡាប័ ប៉្រគ័ កា អាញ់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","ទឹល នីណោ័ះ ហគ់ សាំយ៉ាំង ប៉ានឹរ អន់ឌែ ពិ ហះកា ត្រគ់ រ៉ះ កា អន់ឌែ អន់ទ្រួល អន់ អន់ឌែ អ្លុ អន់តគ់ សាដាច់ ឡាក់ ចឹង រ៉ាំងហៃ អន់ឌែ ណោះ ចឹង ប៉្រគ័ កា អន់ឌែ នីចម័ អន់ដា»។ ");
INSERT INTO tpu_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","វគ័ សាំយូអ៊ែល អ្យក់ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាំ រ៉ះ កា ប៉ាសុន ឡាក់ ប៉រ់ ខំៗ ប៉ិច កា ទី សាដាច់ ណោះ ផា ");
INSERT INTO tpu_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","«សាដាច់ ឡាក់ ចឹង រ៉ាំងហៃ អន់ដីស ណោះ អ៊ែ ចឹង ប៉្រគ័ នីអៀ អ៊ែ ចឹង អ្យក់ គន កាម៉ាក័ អន់ដីស ប៉្រគ័ តាហាន បក់ អន់ដា ប៉្រគ័ តាហាន ជិះ រ៉ាតេ័ះ បក់ អន់ដា ប៉្រគ័ តាហាន ជិះ សេះ បក់ អន់ដា ណាវ្គ សាតាក់ អន់ទ្រួល គែង ង៉ីរ រ៉ាតេ័ះ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","អ៊ែ ចឹង ប៉្រើ ពូ ប៉្រគ័ ម៉ៃគ រ៉ាំងហៃ តាហាន ១០០០ ដូវ ម៉ៃគ រ៉ាំងហៃ តាហាន ៥០ ដូវ។ អ៊ែ ចឹង ប៉្រើ បក់ អន់ដា ឡាំ ប៉្រគ័ ម៉ីរ កាច់ ច្រូត័ អន់ កា អ៊ែ បក់ អន់ដា ណាវ្គ ប៉្រគ័ ឃឿង ខង តាកូះ ប្ល‌៉័ះ លូ រ៉ាតេ័ះ អន់ កា អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","អ៊ែ ចឹង ប៉្រើ គន អង់កាន់ អន់ដីស ប៉្រគ័ ឃឿង បោផូវ ប៉្រគ័ សាណា លូ ប៉្រគ័ ណុំ។ ");
INSERT INTO tpu_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","អ៊ែ ចឹង អ្យក់ ម៉ីរ អន់ដីស ទឹប អ្យក់ តើម ប៉្លៃ អង់កាច លូ តើម អូលេវ ឃឺ ម៉ីរ ចំ ឡាក់ ដាគ់ មប អន់ កា មួត ប៉្រគ័ កាន កា អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","អ៊ែ ចឹង អ្យក់ ពៀ លូ ប៉្លៃ អង់កាច ឡឹង ម៉ីរ អន់ដីស អញ់ជឹត ចានែក អ្យក់ ម៉ោញ ចានែក អន់ កា មួត ប៉្រគ័ កាន កា អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","អ៊ែ ចឹង អ្យក់ ទុច កាម៉ាក័ ទុច អង់កាន់ ទឹប មួត តាតាម័ បក់ ទី សាងុំ ឡឹង ពូ ទឹប អ្យក់ លៀ អន់ដីស អន់ ប៉្រគ័ ង៉ារ កា អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","ប៉ារ់ពេ លូ ចៀម អន់ដីស អញ់ជឹត កាតុ អ៊ែ ចឹង អ្យក់ ម៉ោញ កាតុ។ អន់ដីស ទិឌូ ចឹង កេះ ទុច អ៊ែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","ដារ់ ណោះ អន់ដីស ចឹង ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ញន កា សាដាច់ អន់ដីស រ៉ើស ណោះ ហះកា ដារ់ ណោះ ប‌៉្រ័ះ អូ សាំយ៉ាំង អន់ដីស អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","ហះកា ប៉ាសុន អូ សាំយ៉ាំង ប៉ានឹរ វគ័ សាំយូអ៊ែល អុះ។ អន់ឌែ ប៉ាគែក ផា «អូ អុះ ! ញឹន ប៉ិច កា ទី សាដាច់ រ៉ាំងហៃ ញឹន ");
INSERT INTO tpu_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","ភឿ អន់ ញឹន ទី សាដាច់ ឡាក់ កា សុនសាត អន់ទៀគ ដេល។ សាដាច់ ណោះ អ៊ែ ចឹង រ៉ាំងហៃ ពិន លូ ប៉ាណាំ ពិន ឡាំ តាកូះ ប្ល‌៉័ះ»។ ");
INSERT INTO tpu_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","ប៉ាគ់ ប៉ាសុន រ៉ះ កា វគ័ សាំយូអ៊ែល កេះៗ អ៊ែ ឡាំ រ៉ះ លូ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា វគ័ សាំយូអ៊ែល ផា «ហគ់ សាំយ៉ាំង ប៉ានឹរ អន់ឌែ លូ រ៉ើស ម៉ោញ ដូវ ប៉្រើ ប៉្រគ័ សាដាច់ រ៉ាំងហៃ អន់ឌែ ពិ»។ កេះណោះ វគ័ សាំយូអ៊ែល រ៉ះ លូ ប៉ាសុន អ៊ីស្រាអ៊ែល ផា «ហគ់ ប៉ាណាំ គួប សឹត ប៉ាគ់ ស្រុក ពឿ ស្រុក អ៊ែ ណាវ្គ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","កាណុង ផូង័ វ៉ាច់ បេនយ៉ាមីន ទី កាម៉ាក័ ម៉ោញ ដូវ សិច គិះ គន វគ័ អាបៀល សោ វគ័ សេរោ សោ ចិច វគ័ បេកូរ៉ាត សោ ចាំង វគ័ អាភីយ៉ា។ វគ័ គិះ ឡាក់ ប៉ាណូស ប‌៉្រ័ះ ប៉ាត្រង័។ ");
INSERT INTO tpu_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","អ៊ែ ទី គន កាម៉ាក័ ម៉ោញ សិច អ៊ែ សូល។ សូល ណោះ ឡាកោ អ៊ែ ដាគ់ ឡាយ៉ាម័ កាខាក់។ កាណុង កាំឡាំង សុនសាត អ៊ីស្រាអ៊ែល អូ ទី ពឿ ដាគ់ ឡាយ៉ាម័ ឡាក់ កា អ៊ែ អុះ ឡាកោ អ៊ែ កា ចាំងហីគ ឡឹង ពូ ទិណោ័ះ ពូ គឹត កាពែង អ៊ែ ដោច។ … ");
INSERT INTO tpu_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","វគ័ សាំយូអ៊ែល កា អ្យក់ សាងី ពឹង ចាយ ជ្រោ ពឹង កល់ សូល កេះណោះ អ៊ែ ចុំ សូល ទឹប កាប ផា «ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ើស អ្យក់ អីស ប៉្រើ រ៉ាំងហៃ ប៉ាសុន អ៊ែ»។ … ");
INSERT INTO tpu_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","កេះណោះ វគ័ សាំយូអ៊ែល រ៉ះ កា ប៉ាសុន ទិណោ័ះ ផា «ពិ ពិន ប៉ាណាំ គួប ឡាំ ប៉ាគ់ មឿង គីលកាល ភឿ ហាប់ សាដាច់ ណាវ»។ ");
INSERT INTO tpu_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","ទឹល នីណោ័ះ ប៉ាសុន ទិណោ័ះ កា ប៉ាណាំ គួប ឡាំ ប៉ាគ់ មឿង គីលកាល។ ប៉ាគ់ ណោះ អន់ឌែ កា អ្យក់ សូល ប៉្រើ ប៉្រគ័ សាដាច់ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័  កេះណោះ អន់ឌែ ពុះ កាណាគ័ រ៉ាម៉ះ ភឿ សា អន់ឌូ លូ គួប សោប ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ។ សាដាច់ សូល លូ ប៉ាសុន អ៊ីស្រាអ៊ែល ទិណោ័ះ កា ទី ពុត ហោក រ៉គ់ កាខាក់។ … ");
INSERT INTO tpu_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","សាដាច់ សូល រ៉ើស តាហាន កាណុង កាំឡាំង ប៉ាសុន អ៊ីស្រាអ៊ែល ចំលួន ៣០០០ ដូវ អ៊ែ អ្យក់ ២០០០ ដូវ អ្វៃ អន់ឌូ លូ អ៊ែ ហះ ស្រុក មីកម៉ះ ពឹង ព្រី ប៉ានឹម ក្យាម័ មឿង បេតអ៊ែល ១០០០ ដូវ ណាវ្គ អ៊ែ ប៉្រើ អ្វៃ អន់ឌូ លូ គន អ៊ែ យ៉ូណាថាន អ្វៃ ប៉ាគ់ ស្រុក គីបៀ ពឹង ព្រី ទៀក ផូង័ បេនយ៉ាមីន។ កាប៉ាច់ ប៉ាសុន ឡាក់ អ្វៃ សល់ សាដាច់ សូល ប៉្រើ អន់ឌែ សឹត ប៉ាគ់ ហី ពឿ ហី អ៊ែ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","យ៉ូណាថាន កា ឡាំ ថាំឡាយ ខាយ តាហាន សុនសាត ភីលីសាទីន ប៉ាគ់ ស្រុក គីបៀ សុនសាត ភីលីសាទីន កា កាតាំង សារ អា។ ផះ ណោះ សាដាច់ សូល ប៉្រើ ពូ ខ្លោម សាណៃង ប៉ាញ័ ទឹប ប៉ាថេត លូ កាប ផា «អឺ សុនសាត អ៊ីស្រាអ៊ែល ហគ់ សាំយ៉ាំង ពិ ទឹប ឡាំ តាកូះ កិញអៀ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","សុនសាត អ៊ីស្រាអ៊ែល ទិឌូ កាតាំង ពូ រ៉ះ ផា សាដាច់ សូល ថាំឡាយ ខាយ តាហាន សុនសាត ភីលីសាទីន ប៉្រគ័ អន់ សុនសាត ភីលីសាទីន អឺក កា សុនសាត អ៊ីស្រាអ៊ែល ខាក់។ ផះ ណោះ ប៉ាសុន កា ប៉ាណាំ គួប ឡាំ អ្វៃ ជុំ សាដាច់ សូល ប៉ាគ់ មឿង គីលកាល។ ");
INSERT INTO tpu_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","សុនសាត ភីលីសាទីន ប៉ាតុំ តាហាន ឡាំ តាកូះ តូ លូ សុនសាត អ៊ីស្រាអ៊ែល។ អន់ឌែ ទី រ៉ាតេ័ះ តាកូះ ចំលួន ៣០.០០០ កល់ ទី តាហាន ជិះ សេះ ៦០០០ ដូវ លូ កាំឡាំង តាហាន ចាក ជុង អៀង កាខាក់ ឡាក់ កា តេះ ឡាពុក រហាង សាឡីគ សាឡាយ។ អន់ឌែ ប៉ាណាំ គួប ប៉្រគ័ រ៉ាណើះ ប៉ាគ់ ស្រុក មីកម៉ះ គែង ដារ់ ឡាច់ ស្រុក បេតអាវេន។ ");
INSERT INTO tpu_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","ប៉ាគ់ សុនសាត អ៊ីស្រាអ៊ែល អ្លុ អន់តគ់ ផា អន់ឌែ ចឹង អូ ដាម័ ពូ កេះ ខង តាម៉ឺរ អៀង ហ៊្លត ឡឹង អន់ឌែ ទឹល នីណោ័ះ កា ប៉ាណាំ គួប សាតាក់ អោន ពឹង រ៉ូង័ ប៉ានឹម ពឹង អ្យិត ប៉ោម លូ ពឹង ឡូះ ទឹប ពឹង កានឺប អំហ្មោ លូ ឡូះ សាំរ៉ាប់ គម ទៀក។ ");
INSERT INTO tpu_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","ទី ប៉ាសុន អន់ដា ឃ្លង ទៀក ទ្រូង យដាន់ សាតាក់ ឡាំ ប៉ាគ់ ព្រី ទៀក ផូង័ កាត លូ ប៉ាគ់ ព្រី ប៉ានឹម កាឡាត។ ហះកា សាដាច់ សូល អ៊ែ អ្វៃ ប៉ាគ់ មឿង គីលកាល ណោះ ហង កាំឡាំង តាហាន បក់ អ្វៃ អន់ឌូ លូ អ៊ែ អ្យូគ រ៉ារ៉ៃត កាខរ់ ណូស កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","សាដាច់ សូល អ្វៃ ក្យាគ់ វគ័ សាំយូអ៊ែល តាំប៉ើះ ដារ់ ហះកា អូ ប៉ប័ អ៊ែ ពឹះ ប៉ាគ់ មឿង គីលកាល ឡាក់ កា ទី កាំឡត់ ណោះ អុះ។ មួត តាហាន កា សាតាក់ តាប៉្រះ តាប៉្រោង ឡាកោ ពឿ ឡាកោ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","សាដាច់ សូល កាប ផា «ហគ់ អ្យក់ កាណាគ័ ពុះ អ្លាត សាំរ៉ាប់ រ៉ាម៉ះ ប‌៉្រ័ះ លូ កាណាគ័ ពុះ រ៉ាម៉ះ សា អន់ឌូ លូ គួប»។ អ៊ែ កា ពុះ អ្លាត កាណាគ័ រ៉ាម៉ះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","ប៉ាគ់ អ៊ែ ពុះ រ៉ាម៉ះ កេះៗ វគ័ សាំយូអ៊ែល កា ពឹះ ទឹល។ សាដាច់ សូល ឡាច់ ហាប់ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","វគ័ សាំយូអ៊ែល អំប៉ញ់ ផា «អីស ប៉្រគ័ ញ៉ា ណោះ ?» សាដាច់ សូល តើល ផា «ញន កា អាញ់ ប៉ប័ មួត តាហាន សាតាក់ តាប៉្រះ តាប៉្រោង អីស កា អូ ប៉ប័ ពឹះ ឡាក់ កា សារ អីស កាំឡត់ ណោះ ដេល ទឹប អាញ់ ប៉ប័ មួត ភីលីសាទីន ប៉ាណាំ គួប ឡាំ ប៉ាគ់ ស្រុក មីកម៉ះ កេះ ");
INSERT INTO tpu_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","អាញ់ ឃឹត ផា ចាបះ កា មួត ភីលីសាទីន ចឹង ជឹរ ពឹះ តាកូះ លូ អាញ់ ប៉ាគ់ អា ផះ ណោះ អាញ់ បើ ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័  ទឹល នីណោ័ះ អាញ់ ប៉ាន់តាន ពុះ កាណាគ័ រ៉ាម៉ះ»។ ");
INSERT INTO tpu_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","វគ័ សាំយូអ៊ែល តើល សាដាច់ សូល ផា «អីស ឌឺ ង៉ល់ កេះ អីស ប៉្រគ័ សារ អា។ អីស អូ ប៉្រគ័ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អីស ប៉្រើ ពែ អុះ។ ផា អីស ប៉្រគ័ ពួយ ចាបះ កា ប‌៉្រ័ះ ប៊កកាតយ័ អន់ អីស លូ គន សោ អីស រ៉ាំងហៃ សុនសាត អ៊ីស្រាអ៊ែល លើយ។ ");
INSERT INTO tpu_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","កិញអៀ អា សារ អីស រ៉ាំងហៃ អូ អ្វៃ លើយ អុះ។ ប‌៉្រ័ះ ប៊កកាតយ័ ណាំង ប៉ាណូស ចំ ឡាក់ ត្រគ់ ពុត អ៊ែ កេះណោះ ប៉្រើ ប៉្រគ័ ម៉ៃគ ណាំផា ប៉ាសុន អ៊ែ ខង អីស អូ ប៉្រគ័ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","វគ័ សាំយូអ៊ែល កា ចាក ឡាច់ ឡឹង មឿង គីលកាល។ … ");
INSERT INTO tpu_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","ផះ ណោះ វគ័ សាំយូអ៊ែល កាប លូ សាដាច់ សូល ផា «ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អាញ់ ពឹះ ជ្រោ សាងី ពឹង អីស ពែ ភឿ ប៉្រើ ប៉្រគ័ សាដាច់ សុនសាត អ៊ីស្រាអ៊ែល ឡាក់ ប៉ាសុន អ៊ែ។ ទឹល នីណោ័ះ ហគ់ អីស សាំយ៉ាំង សារ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ តេះ ប‌៉្រ័ះ ប៉្លៃង រ៉ះ ផា \"អាញ់ ប៉ិច ចៃគ ថូត សុនសាត អាម៉ាឡេក ឡាក់ ប៉្រគ័ បាប សុនសាត អ៊ីស្រាអ៊ែល ផះ អន់ឌែ ចាក ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ពែ។ ");
INSERT INTO tpu_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","កិញអៀ អា ហគ់ ឡាំ តាកូះ លូ សុនសាត អាម៉ាឡេក ពិ។ ត្រគ់ ថាំឡាយ កាណាគ័ អន់ឌែ ទិណោ័ះ ភឿ មប អន់ កា អាញ់ ជែ អន់ សល់ លូ ជែ តាប៉ាប តាប៉ុន ត្រគ់ ប៉ាន់តោ័ អ្លាត អន់ឌែ ទឹប កាម៉ាក័ ទឹប អង់កាន់ ទឹប សាស្វា គន ឡន់ គន ពែត ទឹប រ៉ក់ លូ ចៀម ទឹប អូត លូ លៀ ទិណោ័ះ ដេល\"»។ ");
INSERT INTO tpu_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","សាដាច់ សូល កា ប៉ាតុំ តាហាន ប៉ាគ់ តេះ ថេលែម តាហាន ១០.០០០ ដូវ ឡឹង ផូង័ យូដា ២០០.០០០ ដូវ ឡឹង ផូង័ វ៉ាច់ អ៊ីស្រាអ៊ែល អន់ទៀគ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","ប៉ាគ់ សាដាច់ សូល ឡាំ ទឹល ប៉ាគ់ មឿង សុនសាត អាម៉ាឡេក អ៊ែ ប៉្រើ តាហាន ក្រាប់ រក្លូះ ប៉ានឹម។ ");
INSERT INTO tpu_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","កេះណោះ សាដាច់ សូល កាប លូ សុនសាត គែន ផា «ហគ់ ឡាច់ ឡឹង មួត អាម៉ាឡេក ម៉ាគ់ ញឹន អូ ថាំឡាយ អន់ដីស អន់ឌូ លូ អន់ឌែ ខង អន់ដីស ប៉្រគ័ ដាគ់ កា ប៉ាសុន អ៊ីស្រាអ៊ែល ផះ អន់ឌែ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ពែ»។ សុនសាត គែន កា ឡាច់ ឡឹង សុនសាត អាម៉ាឡេក ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","សាដាច់ សូល តាកូះ លូ មួត អាម៉ាឡេក អ្យក់ ឡឹង ព្រី ហាវីឡា លើយ ទឹល ប៉ាគ់ ស៊្រែ តីស ស៊ុរ គែង ដារ់ ឡាច់ ប៉ាថេត អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","អ៊ែ កោះ ប៉ាន់តោ័ ប៉ាសុន ទិណោ័ះ មប អន់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ហះកា រ៉ុប អាកាក់ ឡាក់ សាដាច់ មួត អាម៉ាឡេក ទឹប រ៉ីស ");
INSERT INTO tpu_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","សាដាច់ សូល លូ តាហាន អ៊ែ អូ ប៉ាន់តោ័ សាដាច់ អាកាក់ អុះ ទឹប រ៉ក់ លូ ចៀម ឡាក់ ដាគ់ៗ អន់ឌែ អូ ចៃ ថាំឡាយ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ដេល។ អន់ឌែ ថាំឡាយ ដឹង កាណាគ័ ញ៉ា ឡាក់ អូ ទី ខា លូ កាណាគ័ អូ ដាគ់ ដោច។ ");
INSERT INTO tpu_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","ប‌៉្រ័ះ ប៊កកាតយ័ កាប លូ វគ័ សាំយូអ៊ែល ផា ");
INSERT INTO tpu_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","«អាញ់ ថុច កា ប៉្រើ សូល ប៉្រគ័ សាដាច់ ខង អ៊ែ ឡាច់ ឡឹង អាញ់ អូ ប៉្រគ័ ពួយ ប៉ានឹរ អាញ់ កេះ»។ វគ័ សាំយូអ៊ែល ប៉ិច អឺក ខាក់ អ៊ែ កា ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ឡឹង កាម៉ាំង ទឹល តារ។ ");
INSERT INTO tpu_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","អ៊ែ អ្យូវ ឡឹង កាំលឺ ផុងម៉ាំង ភឿ ឡាំ ប៉ាគ់ ចារ សាដាច់ សូល ហះកា ពូ រ៉ះ កា អ៊ែ ផា «សាដាច់ សូល ឡាំ ប៉ាគ់ តេះ កាមែល កេះ អ៊ែ ប៉ាន់តាវ អញ់ជុង កា អ៊ែ ទៅ ភឿ ច្រាគ់ រ៉ះ ឡឹង សារ អ៊ែ ចាយ័ ទ្រង អ៊ែ លូ សុនសាត អាម៉ាឡេក ណោះ កេះណោះ អ៊ែ ចាក ឡាំ ប៉ាគ់ មឿង គីលកាល ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","ប៉ាគ់ វគ័ សាំយូអ៊ែល ប៉ាត័ះ សាដាច់ សូល សូល កាប ផា «អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ដាគ់ កា អីស។ អាញ់ ប៉្រគ័ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","វគ័ សាំយូអ៊ែល អំប៉ញ់ ផា «ផា នីណោ័ះ ញ៉ា អាញ់ កាតាំង ប៉ានឹរ ចៀម លូ រ៉ក់ នីអៀ ?» ");
INSERT INTO tpu_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","សាដាច់ សូល កាប ផា «មួត តាហាន អ្យក់ កាណាគ័ ណោះ ឡឹង មឿង សុនសាត អាម៉ាឡេក។ អន់ឌែ គម ចៀម លូ រ៉ក់ ឡាក់ ដាគ់ៗ អា សាំរ៉ាប់ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អីស  ហះកា កាណាគ័ ញ៉ា តាង ឡឹង ណោះ ណាវ្គ ញឹន ថាំឡាយ មប កា ប‌៉្រ័ះ ប៊កកាតយ័ ទិណោ័ះ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","វគ័ សាំយូអ៊ែល តើល ផា «បគ័ កេះ កិញអៀ អា អាញ់ ប៉រ់ រ៉ះ សារ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អាញ់ ម៉ាំង ពែ»។ សាដាច់ សូល កាប ផា «ប៉រ់ អីស រ៉ះ ហៃ»។ ");
INSERT INTO tpu_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","វគ័ សាំយូអ៊ែល រ៉ះ ផា «អន់ទ្រួល ពែ អីស ឃឹត ផា ឡាកោ អីស ឡាក់ ប៉ាណូស អូ កាឡោះ ហះកា កិញអៀ អា អីស កេះ ប៉ាណូស ណាំផា ផូង័ វ៉ាច់ សុនសាត អ៊ីស្រាអ៊ែល ទិណោ័ះ កេះ ខង ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ើស អ្យក់ អីស ប៉្រើ ប៉្រគ័ សាដាច់ សុនសាត អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អីស ឡាំ តាកូះ ទឹប កាប ផា \"ហគ់ ឡាំ ថាំឡាយ សុនសាត អាម៉ាឡេក ឡាក់ ប៉ាណូស យច ហគ់ ប៉ាន់តោ័ អន់ឌែ អន់ ទិ ប្លី ឡូត\"។ ");
INSERT INTO tpu_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","ខ ញ៉ា បះ អីស អូ ប៉្រគ័ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័  ? ញ៉ា ត្រគ់ អីស អ្យក់ កាណាគ័ ពូ លូ ប៉្រគ័ សារ អូ ដាគ់ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ នីអៀ ?» ");
INSERT INTO tpu_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","សាដាច់ សូល តើល កា វគ័ សាំយូអ៊ែល ផា «អាញ់ ប៉្រគ័ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ កេះ អាញ់ ឡាំ តាកូះ ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ កេះ។ អាញ់ រ៉ុប អាកាក់ ឡាក់ សាដាច់ សុនសាត អាម៉ាឡេក អ្យក់ សឹត អាញ់ កា ប៉ាន់តោ័ សុនសាត អាម៉ាឡេក ទិណោ័ះ មប កា ប‌៉្រ័ះ ប៊កកាតយ័ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","មួត តាហាន រ៉ុប អ្យក់ រ៉ក់ លូ ចៀម ឡាក់ ដាគ់ ឡឹង ពូ ឡឹង កាណាគ័ ញ៉ា ឡាក់ ត្រគ់ ថាំឡាយ ភឿ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អីស អ្វៃ ប៉ាគ់ មឿង អា»។ ");
INSERT INTO tpu_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","វគ័ សាំយូអ៊ែល តើល ផា៖ «ញ៉ា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ិច កា កាណាគ័ រ៉ាម៉ះ ក្វា ឡឹង សាំយ៉ាំង ប៉ានឹរ អ៊ែ ប ? រ៉ាប់ សឿ ប‌៉្រ័ះ ដាគ់ ក្វា ឡឹង រ៉ាម៉ះ សាំយ៉ាំង ប៉ានឹរ អ៊ែ ដាគ់ ក្វា ឡឹង ទៀន ប៉ុង ចៀម ដេល ");
INSERT INTO tpu_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","ហះកា សារ ប៉ាសាំង លូ ប‌៉្រ័ះ អូ ដាគ់ ឡាក់ កា សារ គ្រូ ស៊ល ពុត ឌឺ អូ ដាគ់ ឡាក់ កា ប៉ានេ សាំប‌៉័ះ ហ៊ូប ប‌៉្រ័ះ ដេល។ អីស អ្លាត ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ កា អ្លាត អីស អូ អន់ ប៉្រគ័ សាដាច់ ណាវ្គ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","សាដាច់ សូល កាប លូ វគ័ សាំយូអ៊ែល ផា «អាញ់ ប៉្រគ័ សារ យច អាញ់ អូ ប៉្រគ័ ពួយ សារ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អាញ់ កា ប៉្រគ័ យច លូ ប៉ានឹរ អីស ដេល ខង អាញ់ អ្យូគ កា មួត តាហាន អាញ់ កា ប៉្រគ័ ពួយ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","កិញអៀ អា អាញ់ ប៉រ់ ឡោម អីស ជែ អ្យក់ យ៉ូ សារ យច អាញ់។ ប៉រ់ អីស សឹត អន់ឌូ លូ អាញ់ ភឿ អន់ អាញ់ ឡាំ ជន តាកុល សាំប‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័ »។ ");
INSERT INTO tpu_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","វគ័ សាំយូអ៊ែល តើល ផា «អាញ់ អូ សឹត អន់ឌូ លូ អីស អុះ ខង អីស អ្លាត ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័  អ៊ែ កា អ្លាត អីស អូ អន់ ប៉្រគ័ សាដាច់ សុនសាត អ៊ីស្រាអ៊ែល ណាវ្គ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","ផះ វគ័ សាំយូអ៊ែល វ៉ីស អង់កក់ ចឹង ចាក ឡាច់ សាដាច់ សូល រ៉ុប ទុង ឡាណុច អាវ តីស អ៊ែ ទឹល កាតាច់ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","វគ័ សាំយូអ៊ែល រ៉ះ កា អ៊ែ ផា «ដារ់ អា ប‌៉្រ័ះ ប៊កកាតយ័ អ្យក់ សារ រ៉ាំងហៃ រ៉ាំងខ្យា កាតាច់ ឡាច់ ឡឹង អីស អូ អន់ រ៉ាំងហៃ សុនសាត អ៊ីស្រាអ៊ែល ណាវ្គ កេះ អ៊ែ មប សារ រ៉ាំងហៃ អា អន់ កា កាម៉ាក័ ម៉ោញ ដូវ ណាវ្គ ឡាក់ ដាគ់ ឡឹង អីស។ ");
INSERT INTO tpu_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល ឡាក់ អ្វៃ លើយ អ៊ែ អូ អ្លុ តាំព្លូង ទឹប អូ រ៉ើ ពុត ឡាក់ កា ប៉ាណូស អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","សាដាច់ សូល កាប ណាវ្គ ផា «អាញ់ ប៉្រគ័ សារ យច កិញអៀ អា អាញ់ ប៉រ់ ឡោម អីស ហៃ កា អាញ់ ណើ ជែ អន់ អាញ់ តាយួស កា ក្រាគ់ តាំងកង់ ទឹប ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ។ ប៉រ់ អីស សឹត អន់ឌូ លូ អាញ់ អាញ់ ចឹង ជន តាកុល សាំប‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អីស»។ ");
INSERT INTO tpu_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","វគ័ សាំយូអ៊ែល កា ភម សឹត អន់ឌូ ហះកា អ៊ែ ចាក ពួយ ប៉ាអច់ សាដាច់ សូល។ ប៉ាគ់ សឹត ទឹល កេះ សូល ជន តាកុល សាំប‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","កេះណោះ វគ័ សាំយូអ៊ែល កាប ផា «ហគ់ អ្យក់ អាកាក់ ឡាក់ សាដាច់ សុនសាត អាម៉ាឡេក ប៉ាគ់ អា»។ សាដាច់ អាកាក់ កា ម៉ុត ក្យាម័ វគ័ សាំយូអ៊ែល អ៊ែ ហោក រ៉គ់ ខង សាម៉គ័ ផា ចឹង រ៉ាវ៉ាច់ ឡឹង តោ័។ ");
INSERT INTO tpu_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","វគ័ សាំយូអ៊ែល កាប ផា «អីស ប៉្រគ័ អន់ គន ពូ ហ៊្យង ឡឹង មើគ ពូ នីចម័ មើគ អីស ចឹង ហ៊្យង គន អ៊ែ នីណោ័ះ ដេល»។ កេះណោះ វគ័ សាំយូអ៊ែល កា ប៉ាន់តោ័ សាដាច់ អាកាក់ លូ កោះ ចាចោះ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ពឹង មឿង គីលកាល។ ");
INSERT INTO tpu_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","កេះណោះ វគ័ សាំយូអ៊ែល ឡាំ ប៉ាគ់ តេះ រ៉ាម៉ា កាប៉ាច់ សាដាច់ សូល កា សឹត ប៉ាគ់ ហី ប៉ាគ់ ស្រុក គីបៀ។ ");
INSERT INTO tpu_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","វគ័ សាំយូអ៊ែល អូ ឡាំ ច្វាគ់ សាដាច់ សូល ណាវ្គ អុះ លើយ ទឹល ដារ់ អ៊ែ តោ័ ហះកា អ៊ែ កាចាំង រ៉ាំបីស កា សាដាច់ សូល ខាក់។ កាប៉ាច់ ប‌៉្រ័ះ ប៊កកាតយ័ ថុច កា ប៉្រើ សូល ប៉្រគ័ សាដាច់ សុនសាត អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","ប‌៉្រ័ះ ប៊កកាតយ័ កាប លូ វគ័ សាំយូអ៊ែល ផា «អីស អ្វៃ រ៉ាំបីស កា សូល ទឹល ដារ់ ចំ ណាវ្គ ? អាញ់ អ្លាត អ៊ែ អូ អន់ ប៉្រគ័ សាដាច់ សុនសាត អ៊ីស្រាអ៊ែល កេះ។ ហគ់ អ្យក់ អង់គែ ចៃគ សាងី អន់ ប៉ាញ័ កេះណោះ ចាក ឡាំ ពិ។ អាញ់ ប៉្រើ អីស ឡាំ ប៉ាគ់ ហី វគ័ យេសាយ ប៉ាគ់ តេះ បេតាលេហិម ខង កាណុង កាំឡាំង គន កាម៉ាក័ អ៊ែ អាញ់ រ៉ើស អ្យក់ ម៉ោញ ដូវ ប៉្រើ ប៉្រគ័ សាដាច់»។ ");
INSERT INTO tpu_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","វគ័ សាំយូអ៊ែល កាប ផា «អាញ់ អូ ខឹន ឡាំ អុះ។ ផា សូល អ្លុ អន់តគ់ ចាបះ កា អ៊ែ ប៉ាន់តោ័ អាញ់ ឡូត»។ ប‌៉្រ័ះ ប៊កកាតយ័ កាប ផា «ហគ់ ទុង ឡាំ រ៉ក់ ប៉ាញ័ សាតង័ ម៉ោញ រ៉ះ លូ ពូ ផា \"អាញ់ ពឹះ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ \"។ ");
INSERT INTO tpu_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","កេះណោះ ជៀក យេសាយ ឡាំ រ៉ាម៉ះ អន់ឌូ ដេល។ ប៉ាគ់ ណោះ អាញ់ ចឹង រ៉ះ អន់ អីស អ្លុ ឡឹង ង៉ារ អីស ត្រគ់ ប៉្រគ័។ អីស ត្រគ់ អ្យក់ សាងី ជ្រោ ពឹង កល់ បក់ អាញ់ ចឹង រ៉ះ កា អីស»។ ");
INSERT INTO tpu_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","វគ័ សាំយូអ៊ែល កា ប៉្រគ័ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័  អ៊ែ ឡាំ ប៉ាគ់ តេះ បេតាលេហិម។ មួត ក្រាគ់ តាំងកង់ ទិឌូ កាណុង ស្រុក ណោះ ឡាំ ហាប់ អ៊ែ ទឹប កាខរ់ ណូស អ្យូគ រ៉ារ៉ៃត ពូ អំប៉ញ់ អ៊ែ ផា «អីស ពឹះ ប៉ាគ់ អា ទី សារ ញ៉ា ?» ");
INSERT INTO tpu_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","វគ័ សាំយូអ៊ែល តើល ផា «អាញ់ ពឹះ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ទឹល នីណោ័ះ ប៉រ់ អន់ដីស ទិឌូ ពឹះ សៃន រ៉ាវ ឡាកោ អន់ ដាគ់ កេះណោះ ពឹះ រ៉ាម៉ះ ប‌៉្រ័ះ អន់ឌូ លូ អាញ់»។ វគ័ សាំយូអ៊ែល កា ប៉ាណាំ វគ័ យេសាយ លូ គន កាម៉ាក័ៗ អ៊ែ អន់ សៃន រ៉ាវ ឡាកោ អន់ ដាគ់ ទឹប ជៀក អន់ឌែ ម៉ុត រ៉ាម៉ះ ប‌៉្រ័ះ អន់ឌូ លូ អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","ផះ វគ័ យេសាយ លូ គន កាម៉ាក័ អ៊ែ ឡាំ ទឹល វគ័ សាំយូអ៊ែល កា ប៉ប័ អេលៀប ទឹប ឃឹត កាណុង ពុត ផា «ចាបះ កា បក់ អា ហង ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ើស»។ ");
INSERT INTO tpu_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ ផា «ជែ ហៃ កា ឡាកោ អ៊ែ ដាគ់ ឡាយ៉ាម័ លូ តីស ចាំងហីគ។ អាញ់ អូ រ៉ើស អ៊ែ អុះ អាញ់ អូ ហៃ ឡាក់ កា ប៉ាណូស ពឹង អង់កក់ តេះ អុះ ពូ ហៃ ដឹង ឡាកោ អំប៉ាំង អា ដោច អាញ់ ហៃ តាំ ពុត ពៀក តោ»។ ");
INSERT INTO tpu_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","វគ័ យេសាយ អើ អាប៊ីណាដាប់ ប៉្រើ ចាក ហះ ង៉ីរ វគ័ សាំយូអ៊ែល វគ័ សាំយូអ៊ែល កាប ផា «ប‌៉្រ័ះ ប៊កកាតយ័ អូ រ៉ើស អ្យក់ បក់ អា អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","វគ័ យេសាយ ប៉្រើ សាំម៉ា ចាក ហះ ង៉ីរ វគ័ សាំយូអ៊ែល វគ័ សាំយូអ៊ែល កាប ផា «ប‌៉្រ័ះ ប៊កកាតយ័ កា អូ រ៉ើស អ្យក់ បក់ អា ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","វគ័ យេសាយ កា ប៉្រើ គន កាម៉ាក័ អ៊ែ តាំប៉ើះ ដូវ ចាក ហះ ង៉ីរ វគ័ សាំយូអ៊ែល ហះកា អ៊ែ កាប លូ វគ័ យេសាយ ផា «កាណុង កាំឡាំង ទិ អា ប‌៉្រ័ះ ប៊កកាតយ័ អូ ទី រ៉ើស អ្យក់ បក់ ចំ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","កេះណោះ វគ័ សាំយូអ៊ែល អំប៉ញ់ លូ វគ័ យេសាយ ផា «ញ៉ា អីស ទី គន ដឹង អា ហង ប ?» វគ័ យេសាយ តើល ផា «អូ អុះ ! អ្វៃ គន ស្រុច ម៉ោញ ដូវ ណាវ្គ ឡាក់ អ្វៃ ក្យាគ់ ចៀម»។ វគ័ សាំយូអ៊ែល កាប លូ វគ័ យេសាយ ផា «ហគ់ ប៉្រើ ពូ ឡាំ អើ អ៊ែ ពឹះ ប៉ាគ់ អា រិញ។ ផា អ៊ែ បើ ទឹល ពិន អូ សា សាណា អា អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","វគ័ យេសាយ កា ប៉្រើ ពូ ឡាំ រ៉ះ កា គន ស្រុច អ៊ែ ណោះ សិច ដាវីត។ អ៊ែ ណោះ ដាគ់ បាក ទុំៗ ទឹប ត្រគ់ ត្រង័ ឡាយ៉ាម័ ខាក់ ម៉ាត់ អ៊ែ ដាគ់ សាងៗ។ ប‌៉្រ័ះ ប៊កកាតយ័ កាប ផា «បក់ អា ហង ហគ់ ជ្រោ សាងី ពឹង អ៊ែ ពិ !» ");
INSERT INTO tpu_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","វគ័ សាំយូអ៊ែល កា អ្យក់ អង់គែ ចៃគ សាងី ណោះ ជ្រោ ពឹង កល់ ដាវីត ហះ ម៉ាត់ មួត ម៉ីៗ អ៊ែ។ ឡឹង ដារ់ ណោះ ប៉ាង៉ាត័ ប៉ាលឹង ប‌៉្រ័ះ ប៊កកាតយ័ ម៉ុត អ្វៃ ពឹង អ៊ែ ឡូត។ កេះណោះ វគ័ សាំយូអ៊ែល កា សឹត ប៉ាគ់ តេះ រ៉ាម៉ា ណាវ្គ។ … ");
INSERT INTO tpu_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","ផះ រ៉ាំងវ៉ាង ណោះ មួត ភីលីសាទីន ប៉ាតុំ កាំឡាំង តាហាន ភឿ ចឹង តាកូះ។ អន់ឌែ ប៉ាតុំ គួប ប៉ាគ់ តេះ សូកូ ឡាក់ ស្រុក ផូង័ យូដា កេះណោះ ឡាំ ប៉្រគ័ រ៉ាណើះ ប៉ាគ់ អេផេះ ដាមីម អ្វៃ ហះ អន់តិគ័ តេះ សូកូ លូ តេះ អាសេកា។ ");
INSERT INTO tpu_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","សាដាច់ សូល លូ តាហាន អ៊ីស្រាអ៊ែល កា ប៉ាតុំ គួប និះទៅ ដេល កេះណោះ ប៉្រគ័ រ៉ាណើះ អ្វៃ ក្យាម័ តាចាង័ អេឡា តគ័ កាំឡាំង ភឿ តាកូះ លូ មួត ភីលីសាទីន។ ");
INSERT INTO tpu_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","មួត ភីលីសាទីន អន់ឌែ អ្វៃ ពឹង ប៉ានឹម ម៉ោញ មួត អ៊ីស្រាអ៊ែល អន់ឌែ អ្វៃ ពឹង ប៉ានឹម ម៉ោញ ណាវ្គ ទី ក្លូះ ប៉ានឹម ហះ អន់តិគ័។ ");
INSERT INTO tpu_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","ទី តាហាន កេង ម៉ោញ ដូវ ឡាច់ ឡឹង ចារ រ៉ាណើះ ភីលីសាទីន អ៊ែ ណោះ សិច កូលីយ៉ាត ឡឹង មឿង កាត ឡាកោ អ៊ែ ចាំងហីគ ប៉ៃង មិត។ ");
INSERT INTO tpu_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","អ៊ែ តល័ មួក ប៉្រគ័ លូ សាប៉ាន័ លូ ពៀត អាវ សាំរ៉ាប់ តាកូះ ឡាក់ ប៉្រគ័ លូ សាប៉ាន័ ដេល អាវ ណោះ ក្លាំង ៥៧ កាឡូ។ ");
INSERT INTO tpu_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","អ៊ែ ទី ស្រោ ជុង ប៉្រគ័ លូ សាប៉ាន័។ អ៊ែ កា ប៉ាក័ ដាវ សាប៉ាន័ គែង អង់កក់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","ទង តាប៉ាក័ អ៊ែ តីស តុ ប៉្វេះ ប៉្លៃ តាប៉ាក័ អ៊ែ ប៉្រគ័ លូ ប៉ាសយ់ ក្លាំង ៧ កាឡូ។ ទី តាហាន ម៉ោញ ដូវ ចឹក ខៃល អ្វៃ គែង ង៉ីរ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","កូលីយ៉ាត អន់តាវ លូ កាប ម៉ៃៗ កា តាហាន អ៊ីស្រាអ៊ែល ផា «កា ញ៉ា អន់ដីស តគ័ តាហាន ចឹង តាកូះ នីអៀ ? អាញ់ តាកូះ ប៉ាតាង សុនសាត ភីលីសាទីន អន់ដីស ឡាក់ ទុច សូល។ ហគ់ រ៉ើស កាំឡាំង អន់ដីស ម៉ោញ ដូវ ឡាច់ ពឹះ តាកូះ លូ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","ផានែវ អ៊ែ ប៉ាន់តោ័ អាញ់ ចាយ័ ទ្រង អ៊ែ ណោះ កាំឡាំង ញឹន ចឹង ប៉្រគ័ ទុច អន់ដីស។ ផានែវ អាញ់ ប៉ាន់តោ័ អ៊ែ ចាយ័ ទ្រង អាញ់ អន់ដីស ទិឌូ ចឹង កេះ ទុច ញឹន»។ ");
INSERT INTO tpu_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","តាហាន ភីលីសាទីន ណោះ កាប ណាវ្គ ផា «ដារ់ អា អាញ់ ណាគ់ តាហាន អ៊ីស្រាអ៊ែល។ ហគ់ អន់ ម៉ោញ ដូវ ឡាច់ តាកូះ លូ អាញ់ ហៃ !» ");
INSERT INTO tpu_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","ផះ សាដាច់ សូល លូ តាហាន អ៊ីស្រាអ៊ែល ទិឌូ កាតាំង ប៉ានឹរ តាហាន ភីលីសាទីន ណោះ អន់ឌែ កាខរ់ ណូស អ្យូគ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","ទី តាតាម័ សិច ដាវីត អ៊ែ ណោះ គន វគ័ យេសាយ ឡឹង ផូង័ អេប៉្រាតា ឡាក់ អ្វៃ ប៉ាគ់ ស្រុក បេតាលេហិម ឡាក់ ស្រុក ផូង័ យូដា។ វគ័ យេសាយ ទី គន កាម៉ាក័ តាំងហាម ដូវ។ ផះ រ៉ាំងហាវ សូល ប៉្រគ័ សាដាច់ យេសាយ អ៊ែ ក្រាគ់ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","គន កាម៉ាក័ វគ័ យេសាយ មួត ម៉ី ពូ ប៉ៃង ដូវ អេលៀប អាប៊ីណាដាប់ លូ សាំម៉ា អន់ឌែ ឡាំ តាកូះ អន់ឌូ លូ សាដាច់ សូល។ ");
INSERT INTO tpu_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","ដាវីត អ៊ែ ឡាក់ គន ស្រុច។ ប៉ាគ់ ម៉ីៗ ប៉ៃង ដូវ ឡាំ អន់ឌូ លូ សាដាច់ សូល កេះ ");
INSERT INTO tpu_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","ដាវីត ចាក សឹត ចាក ឡាំ ឡឹង ចារ សាដាច់ សូល តាកូះ លូ ប៉ាគ់ ហី ភឿ រង ចៀម កា ពឹ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","កូលីយ៉ាត សុនសាត ភីលីសាទីន ណោះ អ៊ែ ឡាច់ ពឹះ កាប ប៉ាំងអ្យូគ តាហាន អ៊ីស្រាអ៊ែល រ៉ប់ កាំលឺ រ៉ប់ ង៉ាច ទិ ៤០ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","ផះ ណោះ វគ័ យេសាយ កាប លូ គន អ៊ែ ដាវីត ផា «ហគ់ អ្យក់ ភែ សាន់តុក ម៉ោញ រែវ លូ ណុំ ប៉ាំង អញ់ជឹត កាតុ អា ឡាំ ជឹន កា ម៉ីៗ អីស ប៉ាគ់ ចារ តាហាន តោ រិញ។ ");
INSERT INTO tpu_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","ហគ់ អ្យក់ ឡាំ ណុំ ទៀក តុះ អញ់ជឹត លឹប អា ជឹន កា ម៉ៃគ ណាំផា តាហាន អន់ឌែ ដេល ទឹប អំប៉ញ់ មួត ម៉ី អីស ណើ អន់ឌែ ដាគ់ ឡាកោ ដេល ប លូ អ្យក់ កាណាគ័ ញ៉ា ពឹង ឡាកោ អន់ឌែ ភឿ អ្លុ អន់តគ់ ផា អន់ឌែ អ្វៃ ដាគ់ តាទឹច»។ ");
INSERT INTO tpu_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","សាដាច់ សូល លូ ម៉ី ដាវីត ប៉ៃង ដូវ ណោះ ទឹប តាហាន អ៊ីស្រាអ៊ែល ទិណោ័ះ អ្វៃ ក្យាម័ តាចាង័ អេឡា ផះ ចឹង តាកូះ លូ មួត ភីលីសាទីន។ ");
INSERT INTO tpu_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","ដាវីត អ្យូវ ឡឹង ផុងម៉ាំង មប តាប៉ល់ ចៀម កា បក់ រ៉ាំងហៃ ម៉ោញ ដូវ ណាវ្គ កេះណោះ អ្យក់ សាប្យាំង រ៉ាំងតយ័ កា ចាក ពួយ ប៉ានឹរ ពឹ អ៊ែ វគ័ យេសាយ។ ដាវីត ឡាំ ទឹល ចារ តាហាន ផះ ណោះ មួត តាហាន តគ័ កាំឡាំង ភឿ ចឹង តាកូះ ទឹប តាំងហើ ម៉ៃៗ។ ");
INSERT INTO tpu_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","តាហាន អ៊ីស្រាអ៊ែល លូ តាហាន ភីលីសាទីន អន់ឌែ ផះ តគ័ កាំឡាំង ហះ ង៉ីរ គួប សោប ភឿ ចឹង តាកូះ។ ");
INSERT INTO tpu_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","ដាវីត អន់ កាណាគ័ អ៊ែ កា បក់ រ៉ាំងហៃ ឃឿង ខង កេះណោះ អ៊ែ ឡាំ ប៉ាគ់ កាំឡាំង តាហាន ឡាក់ អ្វៃ គែង ង៉ីរ ទឹប អំប៉ញ់ លូ មួត ម៉ីៗ អ៊ែ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","ដាវីត ផះ កាកាប លូ មួត ម៉ីៗ អ៊ែ ផាឌី កូលីយ៉ាត ឡាក់ តាហាន ភីលីសាទីន បក់ កេង ឡឹង ពូ ឡាច់ គែង ង៉ីរ តាហាន អ៊ែ ទៅ ទឹប កាប ម៉ៃៗ តៃល ទៅ ៗ ដាវីត កាតាំង សារ អ៊ែ កាប ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","ប៉ាគ់ ប៉ប័ កូលីយ៉ាត ឡាច់ ពឹះ តាហាន អ៊ីស្រាអ៊ែល ប៉ាណាំ គួប សាតាក់ អោន កា អ៊ែ ខង អន់ឌែ អ្យូគ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","តាហាន អ៊ីស្រាអ៊ែល កា កាប លូ គួប ផា «អីស ប៉ប័ ប៉ាណូស ណោះ ប ? អ៊ែ ពឹះ កាប ណាគ់ ពិន។ ពឿ ខឹន ប៉ាន់តោ័ អ៊ែ បក់ ណោះ សាដាច់ ចឹង អន់ រ៉ាស អំប៉ាស ទឹប អន់ បក់ ណោះ ទី គន អង់កាន់ អ៊ែ លូ អន់ រ៉ាវ៉ាច់ ឡឹង ស៊ង រ៉ាបៃ ទឹប ខាប់ខួ»។ ");
INSERT INTO tpu_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","ដាវីត អំប៉ញ់ លូ បក់ អ្វៃ ក្យាម័ អ៊ែ «សាដាច់ ចឹង អន់ កាណាគ័ ញ៉ា កា បក់ ប៉ាន់តោ័ សុនសាត ភីលីសាទីន ណោះ ម៉ាគ់ ជែ អន់ អ៊ីស្រាអ៊ែល តាយួស កា ពូ ? សុនសាត ភីលីសាទីន ឡាក់ អូ កាសិត អង់ការ ពឿ អ៊ែ ណោះ បះ អ៊ែ ខឹន កាប ណាគ់ តាហាន ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អ្វៃ លើយ ?» ");
INSERT INTO tpu_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","បក់ ណោះ រ៉ះ ពួយ ប៉ានឹរ សាដាច់ រ៉ះ ផា ចឹង អន់ កា បក់ ពឿ ខឹន ប៉ាន់តោ័ សុនសាត ភីលីសាទីន ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","អេលៀប ឡាក់ ម៉ី កាតាំង ដាវីត កាប លូ តាហាន នីណោ័ះ អ៊ែ អឺក កា ដាវីត ខាក់ អ៊ែ កាប ផា «ខ ញ៉ា អីស ពឹះ ប៉ាគ់ អា ? អីស អន់ ពឿ ហៃ ចៀម បាប៊ត បាប៊ែត ណោះ ប៉ាគ់ ស៊្រែ តោ ? អាញ់ អ្លុ កេះ អីស តីស ពុត លូ អូ ដាគ់ ខាក់ អីស ពឹះ ប៉ាគ់ អា ប៉ិច ដឹង ហៃ ពូ តាកូះ គួប សោប»។ ");
INSERT INTO tpu_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","ដាវីត តើល ផា «អាញ់ ប៉្រគ័ យច នីចម័ ? អាញ់ ក្រាន័ កា អំប៉ញ់ ពូ ដោច»។ ");
INSERT INTO tpu_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","ដាវីត កា ឡាច់ ឡឹង ម៉ី អ៊ែ ឡាំ អំប៉ញ់ តាហាន ម៉ោញ ដូវ ណាវ្គ សារ ទៅ ណោះ ហង។ មួត តាហាន កា រ៉ះ ប៉ាឡាក់ ឡឹង សារ ទៅ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","ប៉ាគ់ កាំឡាំង តាហាន ទិឌូ កាតាំង សារ ដាវីត កាប ណោះ អន់ឌែ កា រ៉ះ កា សាដាច់ សូល សូល កា ប៉្រើ ពូ រ៉ះ កា ដាវីត ប៉្រើ ឡាំ ប៉ាគ់ ចារ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","ដាវីត រ៉ះ កា សាដាច់ សូល ផា «អឺ ពឹ តាំងឡា ជែ អន់ ពឿ អ្យូគ កា សុនសាត ភីលីសាទីន ណោះ។ អាញ់ ចឹង ឡាំ តាកូះ លូ អ៊ែ»។ ");
INSERT INTO tpu_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","សាដាច់ សូល រ៉ះ កា ដាវីត ផា «អីស អូ ដាម័ សុនសាត ភីលីសាទីន ណោះ អុះ អីស អ្វៃ សាស្វា ឡក់ អ៊ែ ណោះ ឡាក់ ប៉ាណូស អ្លុ តាកូះ កេង ខាក់ ឡឹង អ្វៃ សាស្វា ឡូត»។ ");
INSERT INTO tpu_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","ដាវីត រ៉ះ លូ សាដាច់ សូល ផា «អាញ់ ឃើយ រង ចៀម ពឹ អាញ់ ផះ ទី ក្លា លើ សាគោ ពឹះ កាប់ អ្យក់ គន ចៀម ឡឹង តាប៉ល់ ចៀម ");
INSERT INTO tpu_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","អាញ់ កា តាយ៉ិប ពួយ ឡូត អាញ់ ពីត រ៉ាត អ្យក់ ឡាច់ គន ចៀម ឡឹង ពឹរ កាណាគ័ ណោះ។ ផា អ៊ែ តាឡូះ ចឹង កាប់ អាញ់ អាញ់ រ៉ុប សក់ ពុក អ៊ែ ពីត ប៉ាន់តោ័ អ៊ែ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","សុនសាត ភីលីសាទីន ឡាក់ អូ កាសិត អង់ការ អា អ៊ែ ចឹង តោ័ ឡាក់ កា ក្លា លូ សាគោ ឡាក់ អាញ់ ប៉ាន់តោ័ ណោះ ដេល ខង អ៊ែ កាប ណាគ់ តាហាន ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ អ្វៃ រ៉ីស លើយ»។ ");
INSERT INTO tpu_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","ដាវីត កាប ណាវ្គ ផា «ប‌៉្រ័ះ ប៊កកាតយ័ ឃើយ តង័ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង អង់ហ្យះ ក្លា លូ សាគោ អ៊ែ កា ចឹង តង័ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង សុនសាត ភីលីសាទីន អា ដេល»។ សាដាច់ សូល កាតាំង នីណោ័ះ អ៊ែ កាប លូ ដាវីត ផា «ឡាំ ពិ ! អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ អន់ឌូ លូ អីស»។ ");
INSERT INTO tpu_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","សាដាច់ សូល អ្យក់ ឃឿង តាកូះ ម៉ះ អ៊ែ អន់ កា ដាវីត អ្យក់ មួក សាប៉ាន័ តាគ់ អន់តល័ ពឹង កល់ ដាវីត លូ អ្យក់ អាវ សាំរ៉ាប់ តាកូះ តាគ់ អំពៀត ពឹង ឡាកោ ដាវីត ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","ដាវីត អ្យក់ ដាវ សូល ប៉ាក័ ពឹង កាពែង កេះណោះ ចាក សាគ់ លួង ខង អ៊ែ អូ ឃើយ ពៀត ឃឿង តាកូះ ណោះ អុះ។ ដាវីត រ៉ះ លូ សាដាច់ សូល ផា «អាញ់ ពៀត ឃឿង ខង អា អូ ដាម័ យ៉ាក អុះ ខង អាញ់ អូ ឃើយ ពៀត ឡក់»។ ដាវីត កា តាឡេះ អ្លាត ឃឿង ខង ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","កេះណោះ អ៊ែ អ្យក់ អ៊្លង ឡាក់ អ៊ែ ឃើយ ចឹក លូ ទូញ អំហ្មោ ជៀលៗ ប៉ាតាម័ កាតុ ឡឹង តាចាង័ អ្យក់ ចៃគ ពឹង កាទុង ឡាក់ អ៊ែ ប៉ាក័ ទឹប កាណាគ័ វ៉ឹត អំហ្មោ ចាក ឡាំ ក្យាម័ ប៉ាគ់ ម៉ាត់ សុនសាត ភីលីសាទីន ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","កាប៉ាច់ សុនសាត ភីលីសាទីន ណោះ អ៊ែ កា ឡាំ ក្យាម័ ដាវីត ដេល ទឹប ទី ប៉ាណូស ចឹក ខៃល ចាក គែង ង៉ីរ អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","ប៉ាគ់ សុនសាត ភីលីសាទីន ប៉ប័ ដាវីត អ៊ែ បឺង៉ាយ ខង ប៉ប័ ដាវីត អ្វៃ សាស្វា មែង អ៊ែ បាក ទុំ ម៉ូះ ម៉ាត់ អ៊ែ កា ដាគ់ ឡាយ៉ាម័ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","សុនសាត ភីលីសាទីន ណោះ កាប កា ដាវីត ផា «ញ៉ា អាញ់ អា សូ ប បះ អីស ចឹក អ៊្លង ពឹះ ពីត អាញ់ នីអៀ ?» អ៊ែ កា អើ ប‌៉្រ័ះ អ៊ែ ប៉ាស្យាប កា ដាវីត។ ");
INSERT INTO tpu_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","អ៊ែ កាប កា ដាវីត ណាវ្គ «ពឹះ ប៉ាគ់ អា ពិ ! អាញ់ ចឹង អ្យក់ ប៉ាំងឡៃ អីស អន់ កា ម៉ីត លូ កាណាគ័ ព្រី សា»។ ");
INSERT INTO tpu_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","ដាវីត តើល ផា «អីស ចឹក ដាវ ចឹក តាប៉ាក័ ពឹះ តាកូះ លូ អាញ់ កាប៉ាច់ អាញ់ ពឹះ តាកូះ លូ អីស ញន កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ តេះ ប‌៉្រ័ះ ប៉្លៃង ឡាក់ ប‌៉្រ័ះ តាហាន អ៊ីស្រាអ៊ែល ឡាក់ អីស កាប ណាគ់ អា។ ");
INSERT INTO tpu_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","ដារ់ អា ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង មប អីស កា អាញ់ អាញ់ ចឹង ប៉ាន់តោ័ អីស ទឹប កាសិត អង់កូ។ ដារ់ អា អាញ់ ចឹង អន់ ប៉ាទ្រូ តាហាន ភីលីសាទីន កា ម៉ីត លូ កាណាគ័ ព្រី សា ដេល។ ប៉ាណូស ទិឌូ អ្វៃ ពឹង អង់កក់ តេះ ចឹង អ្លុ អន់តគ់ ផា ទី ប‌៉្រ័ះ រ៉ាំងហៃ សុនសាត អ៊ីស្រាអ៊ែល តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","កាំឡាំង ទិឌូ អ្វៃ ហះ អា ចឹង អ្លុ អន់តគ់ ផា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ ញឹន សាណ័ះ អូ ត្រគ់ ញន កា ដាវ លើ តាប៉ាក័ អុះ ខង ប‌៉្រ័ះ ប៊កកាតយ័ តាកូះ តាង ញឹន អ៊ែ ចឹង មប អន់ដីស កា ញឹន»។ ");
INSERT INTO tpu_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","ផះ ណោះ សុនសាត ភីលីសាទីន ម៉ុត ប៉ាគ់ ចារ ដាវីត ដាវីត កា តាឡូះ ឡាំ តាកូះ លូ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","ដាវីត ពួត កាទុង អ្យក់ អំហ្មោ ម៉ោញ កាតុ ចៃគ ពឹង កាណាគ័ វ៉ឹត អំហ្មោ ណោះ កេះណោះ វ៉ី ត្រគ់ ពឹង កល់ យ៉ាំង សុនសាត ភីលីសាទីន។ សុនសាត ភីលីសាទីន ណោះ កា ប៉ាទុះ កល់ យ៉ាំង ប៉ក់ គ្រួប តាគ្រួប ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","សាណ័ះ ទ្រង ដាវីត លូ សុនសាត ភីលីសាទីន ញន កា អំហ្មោ ម៉ោញ កាតុ។ អ៊ែ ប៉ាន់តោ័ សុនសាត ភីលីសាទីន ណោះ អូ ចឹក ដាវ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","កេះណោះ ដាវីត តាឡូះ ម៉ុត តាវ ហះ សានែង សុនសាត ភីលីសាទីន ណោះ អ៊ែ កា ហ្វាត់ ដាវ វគ័ ណោះ ឡឹង អង់លប ប៉ាន់តោ័ កាសិត អង់កូ កាតាច់ ប៉ុត។ ប៉ាគ់ មួត តាហាន ភីលីសាទីន ប៉ប័ តាហាន អន់ឌែ បក់ កេង ឡឹង ពូ តោ័ កេះ អន់ឌែ សាតាក់ ទិ ប៉្យើះ។ ");
INSERT INTO tpu_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","តាហាន អ៊ីស្រាអ៊ែល លូ តាហាន យូដា កា អ្យូវ ទិឌូ តាំងហើ តាយ៉ិប ពួយ មួត ភីលីសាទីន លើយ ទឹល ប៉ាគ់ មឿង កាត លូ អំប៉ារ ទ្រួក មឿង អេក្រូន។ ប៉ាទ្រូ មួត ភីលីសាទីន ប៉ក់ តោ័ រ៉ាតក ប៉ក រទ្រង ឡាំ ប៉ាគ់ មឿង សារ៉ៃម លើយ ទឹល មឿង កាត លូ មឿង អេក្រូន។ ");
INSERT INTO tpu_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","ឡៃង ឡឹង តាយ៉ិប ពួយ មួត ភីលីសាទីន កេះៗ តាហាន អ៊ីស្រាអ៊ែល វ៉ីល សឹត អ្យក់ រ៉ាស ពឹង ចារ រ៉ាណើះ មួត ភីលីសាទីន។ ");
INSERT INTO tpu_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","ដាវីត អ្យក់ កល់ សុនសាត ភីលីសាទីន ណោះ ឡាំ ប៉ាគ់ មឿង យេរូសាឡឹម ទឹប អ្យក់ ឃឿង តាកូះ ម៉ះ វគ័ ណោះ ឡាំ ចៃគ ពឹង រ៉ាណើះ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","ប៉ាគ់ សាដាច់ សូល ប៉ប័ ដាវីត ឡាំ តាកូះ លូ សុនសាត ភីលីសាទីន អ៊ែ កា អំប៉ញ់ វគ័ អាប់នើរ ឡាក់ ម៉ៃគ តាហាន ផា «អាប់នើរ ! មន ណោះ គន ពឿ អ៊ែ ណោះ ?» វគ័ អាប់នើរ កា តើល ផា «អឺ សាដាច់ អាញ់ អូ អ្លុ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","សាដាច់ សូល ប៉្រើ ផា «អ្យគ័ អីស សាគ់ អំប៉ញ់ ហៃ មន ណោះ អ៊ែ គន ពឿ ណោះ ?» ");
INSERT INTO tpu_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","ប៉ាគ់ ដាវីត សឹត ឡឹង ប៉ាន់តោ័ សុនសាត ភីលីសាទីន វគ័ អាប់នើរ ប៉ាណាំ អ៊ែ ម៉ុត ឡាំ ប៉ាគ់ ចារ សាដាច់ សូល ផះ ណោះ ដាវីត ចឹក ឡាំ កល់ សុនសាត ភីលីសាទីន ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","សាដាច់ សូល កា អំប៉ញ់ ផា «អឺ មន ! អីស គន ពឿ អីស អា ?» ដាវីត តើល ផា «អឺ ពឹ តាំងឡា អាញ់ គន យេសាយ អ្វៃ ប៉ាគ់ ស្រុក បេតាលេហិម»។ ");
INSERT INTO tpu_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","ឡៃង ឡឹង ដាវីត ប៉ាន់តោ័ សុនសាត ភីលីសាទីន កាំឡាំង តាហាន កា សឹត ឡឹង តាកូះ ប្ល‌៉័ះ ផះ ណោះ មួត អង់កាន់ អ្វៃ គ្រឹប មឿង កាណុង ប៉ាថេត អ៊ីស្រាអ៊ែល ឡាច់ ឡាំ ហាប់ សាដាច់ សូល ទឹប ចាជែ លូ កាតាប័ ទឹប តាប៉ះ សាគឹរ អន់ទែង ព្រួក អ៊ត កាណី អន់ឌែ ចាជែ អញ់ស៊ែ រ៉គ់ រែ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","មួត អង់កាន់ ទិណោ័ះ ចាជែ តើល គួប សោប រ៉គ់ សើម ខាក់ ផា៖ «សាដាច់ សូល ប៉ាន់តោ័ យ៉ាប រ៉ាពូ ដូវ ដាវីត ប៉ាន់តោ័ យ៉ាប មឺន ដូវ»។ ");
INSERT INTO tpu_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","ប៉ានឹរ ពូ ចាជែ អា ប៉្រគ័ អន់ សាដាច់ សូល ប៉ិច អឺក កាខាក់ អ៊ែ កាប ផា «ពូ ប៉ានេ ដាវីត ផា ប៉ាន់តោ័ យ៉ាប មឺន ដូវ ហះកា អាញ់ ដឹង យ៉ាប រ៉ាពូ ដូវ ឃឺ អ៊ែ ដាវីត ចឹង ហាវ ប៉្រគ័ សាដាច់ ប៉ាតាង អាញ់ តាម ហៃ»។ ");
INSERT INTO tpu_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","សាគ់ ឡឹង ដារ់ ណោះ សាដាច់ សូល សាណីង កា ដាវីត កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","ប៉ាគ់ តាយ៉ាង័ ដាវីត ផះ អន់ទែង ព្រួក អន់ កា សាដាច់ សូល ឡាក់ កា រ៉ប់ ដារ់ ផះ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ ប‌៉្រ័ះ បឺគ ម៉ុត ពឹង សាដាច់ សូល អ៊ែ កា កាប ឡាក់ កា ប៉ាណូស អន់ទ្រុយ ពឹង ហី ផះ ណោះ អ៊ែ ចឹក តាប៉ាក័ ");
INSERT INTO tpu_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","ផាឌី អ៊ែ ស្រាង តាប៉ាក័ ប៉ិច ត្រគ់ ដាវីត ញន ឃឹត ផា «អាញ់ ចឹង ស្រាង ដាវីត អន់ ក្លាច់ ទួម ពឹង ប៉ាណីរ ឡូត»។ ហះកា ដាវីត វ៉េះ រ៉ាវ៉ាច់ ពៀរ ទង។ … ");
INSERT INTO tpu_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","ប៉ាគ់ សាដាច់ សូល សឹត ឡឹង តាកូះ លូ មួត ភីលីសាទីន ពូ រ៉ះ កា អ៊ែ ផា «ដាវីត អ្វៃ ប៉ាគ់ ស៊្រែ តីស អេនគេឌី»។ ");
INSERT INTO tpu_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","កេះណោះ អ៊ែ ប៉ាណាំ តាហាន ៣០០០ ដូវ ឡាក់ កេង ឡឹង ពូ កាណុង កាំឡាំង តាហាន អ៊ីស្រាអ៊ែល ទិណោ័ះ ឡាំ ណាំង ដាវីត លូ មួត កាំឡាំង ដាវីត ឡាក់ អ្វៃ ប៉ាគ់ ប៉ានឹម ប៉ារ់ពេ ព្រី។ ");
INSERT INTO tpu_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","សាដាច់ សូល ចាក ឡាំ ទឹល អន់ទ្រួង ចៀម ក្យាម័ ចារ ណោះ ទី រ៉ូង័ ប៉ានឹម ម៉ោញ អ៊ែ កា ម៉ុត អីគ វ៉ាច់ កាណុង រ៉ូង័ ណោះ។ ហះកា ដាវីត លូ គួប អ៊ែ អោន ពឹង រ៉ូង័ ណោះ ដេល ដឹង កា ប៉ាគ់ ជ្រុ។ ");
INSERT INTO tpu_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","មួត បក់ អ្វៃ អន់ឌូ លូ ដាវីត រ៉ះ កា អ៊ែ ផា «អា ហង ដារ់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អីស ផា អ៊ែ ចឹង មប តាម៉ឺរ ពឹង តី អីស អន់ អីស ប៉្រគ័ កា អ៊ែ តាម ពុត អីស ប៉ិច ប៉្រគ័»។ ដាវីត កា មច ឡាំ កាសិត ឡាណុច អាវ សូល។ ");
INSERT INTO tpu_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","ប៉ាគ់ អ៊ែ កាសិត ឡាណុច អាវ កេះ អ៊ែ អ្វះ ឡាកោ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","អ៊ែ រ៉ះ លូ មួត អ្វៃ អន់ឌូ លូ អ៊ែ ផា «អន់ ប‌៉្រ័ះ ប៊កកាតយ័ ទឹប អាញ់ ជែ អន់ អាញ់ ប៉ាន់តោ័ ពឹ តាំងឡា អាញ់ ឡាក់ ប‌៉្រ័ះ រ៉ើស ប៉្រើ ប៉្រគ័ សាដាច់ អាញ់ អូ ប៉្រគ័ កា សាដាច់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ើស អា អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","ញន កា ប៉ានឹរ ដាវីត កាប ណោះ អ៊ែ ទឹប មួត ណោះ អូ អន់ អន់ឌែ ប៉ាន់តោ័ សាដាច់ សូល អុះ។ សូល កា ឡាច់ ឡឹង រ៉ូង័ ប៉ានឹម ចាក ឡាំ ប៉ាគ់ ង៉ីរ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","ប៊ែត ឡឹង ណោះ ដាវីត កា ឡាច់ ឡឹង រ៉ូង័ ប៉ានឹម ណោះ កា អើ គែង អង់កក់ សាដាច់ សូល «អឺ ពឹ តាំងឡា !» សាដាច់ សូល កាលែង គែង អង់កក់ ដាវីត កា កុប កល់ ទឹះ តេះ សាំប‌៉័ះ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","អ៊ែ រ៉ះ កា សាដាច់ សូល ផា «ខ ញ៉ា បះ អីស សាំយ៉ាំង ប៉ានឹរ ពូ រ៉ះ កា អីស ផា អាញ់ ប៉ិច ប៉ាន់តោ័ អីស នីអៀ ? ");
INSERT INTO tpu_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","អីស ប៉ប័ កេះ ដារ់ អា ប‌៉្រ័ះ ប៊កកាតយ័ មប អីស ពឹង តី អាញ់ ផះ អីស អ្វៃ កាណុង រ៉ូង័ ប៉ានឹម អា។ ពូ ប៉្រើ អាញ់ ប៉ាន់តោ័ អីស ហះកា អាញ់ អូ ប៉្រគ័ ពួយ អុះ។ អាញ់ កាប ផា \"អាញ់ អូ ប៉្រគ័ កា ពឹ តាំងឡា អាញ់ អុះ ខង ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ើស អ៊ែ ប៉្រើ ប៉្រគ័ សាដាច់ កេះ\"។ ");
INSERT INTO tpu_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","អឺ ពឹ ប៉រ់ អីស ហៃ គែង អា ឡាណុច អាវ អីស អាញ់ ចឹក អា។ អាញ់ ក្រាន័ កា កាសិត ឡាណុច អាវ អីស ដោច ហះកា អាញ់ អូ ប៉ាន់តោ័ អីស អុះ។ ទឹល នីណោ័ះ អីស អ្លុ ចាបះ កេះ ផា អាញ់ អូ ទី ពុត អូ ណីស ប៉ិច ប៉ាន់តោ័ លើ ប៉ាសាំង លូ អីស អុះ។ យ‌៉័ះ អីស តាយ៉ិប ពួយ ប៉ិច ប៉ាន់តោ័ អាញ់ កាតាម កា អាញ់ អូ ប៉្រគ័ យច លូ អីស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","អន់ ប‌៉្រ័ះ ប៊កកាតយ័ តាត់ស៊ិន សារ កា ពិន ពៀរ ដូវ ពិ។ អន់ ប‌៉្រ័ះ តូ អីស ប៉ាតាង អាញ់។ កាប៉ាច់ អាញ់ អូ ប៉្រគ័ កា អីស អុះ។ ");
INSERT INTO tpu_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","ឡាក់ កា ពូ ឃើយ អន់តគ់ ប៉ាតោ ឡឹង សើគ ពែ ផា \"ប៉ាណូស អូ ដាគ់ ប៉្រគ័ ដឹង សារ អូ ដាគ់\"។ កាប៉ាច់ អាញ់ អូ ប៉្រគ័ កា អីស អុះ។ ");
INSERT INTO tpu_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","អីស ជែ តាយ៉ិប ពួយ អាញ់ ហង ខង អាញ់ ឡាក់ កា សូ តោ័ លើ ឡាក់ កា សី សូ។ ");
INSERT INTO tpu_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","អន់ ប‌៉្រ័ះ ប៊កកាតយ័ តាត់ស៊ិន សារ កា ពិន ពៀរ ដូវ ពិ។ អន់ ប‌៉្រ័ះ ហៃ ប៉ប័ សារ អាញ់ ទឹប តង័ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង តី អីស ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","ប៉ាគ់ ដាវីត រ៉ះ សារ ទិណោ័ះ កេះ សាដាច់ សូល កាប ផា «អឺ គន ! ប៉ានឹរ អីស តាទឹច ប កាប អា ?» អ៊ែ កា ញ៉ាំ ម៉ៃៗ ខាក់ ឡូត ");
INSERT INTO tpu_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","ទឹប កាប ផា «អីស ឡាក់ ប៉ាណូស ដាគ់ ត្រង់ ក្វា ឡឹង អាញ់ ខង អីស ប៉្រគ័ ដាគ់ កា អាញ់ ហះកា អាញ់ ប៉្រគ័ អូ ដាគ់ កា អីស។ ");
INSERT INTO tpu_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","ដារ់ អា អីស តាំបាង ពុត ដាគ់ កា អាញ់ តាទឹច ខង ប‌៉្រ័ះ ប៊កកាតយ័ មប អាញ់ ពឹង តី អីស ហះកា អីស អូ ប៉ាន់តោ័ អាញ់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","អាញ់ ឃើយ ប៉ប័ ផានែវ ពូ ប៉ាត័ះ តាម៉ឺរ កេះ ពូ អូ អន់ អ៊ែ អ្វៃ រ៉ីស អុះ។ ទឹល នីណោ័ះ អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ដាគ់ កា អីស ញន កា អីស ប៉្រគ័ ដាគ់ កា អាញ់ ពឹង ដារ់ អា។ ");
INSERT INTO tpu_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","អាញ់ ឃឹត ផា ប៉ាគ់ ម៉ាត់ ទៀ អីស ចឹង ហាវ ប៉្រគ័ សាដាច់ អីស កា ចឹង រ៉ាំងហៃ រ៉ាំងខ្យា ប៉ាថេត អ៊ីស្រាអ៊ែល លើយ។ ");
INSERT INTO tpu_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","ទឹល នីណោ័ះ អន់ អីស ម៉ត់ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ កិញអៀ ហង ពិ ផា អីស ចឹង អូ ថាំឡាយ ផូង័ វ៉ាច់ អាញ់ រ៉ាំងហាវ អន់តីគ ទៀ អុះ ទឹប អូ ប៉្រគ័ អន់ សិច អាញ់ ហ៊្យង ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","ដាវីត កា ម៉ត់ លូ សាដាច់ សូល។ កេះណោះ សាដាច់ សូល សឹត ប៉ាគ់ ហី ណាវ្គ កាប៉ាច់ ដាវីត លូ មួត បក់ អ្វៃ លូ អ៊ែ កា វ៉ីល សឹត ប៉ាគ់ ចារ អោន ណាវ្គ។ … ");
INSERT INTO tpu_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","រ៉ាំងវ៉ាង ណោះ វគ័ សាំយូអ៊ែល តោ័ កេះ ប៉ាសុន អ៊ីស្រាអ៊ែល ទិណោ័ះ ប៉ាណាំ គួប ញ៉ាំ សោក ពូ កា តប់ អ៊ែ ប៉ាគ់ តេះ រ៉ាម៉ា ឡាក់ ស្រុក អ៊ែ ទៅ។ ផះ អន់ទ្រួល ពែ សាដាច់ សូល តាំងហ្យិត ឡាច់ គ្រូ អំហ្ម លូ គ្រូ អ្លុ អើ ប៉ាទ្រូ ឡឹង ប៉ាថេត អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","ផះ ណោះ សុនសាត ភីលីសាទីន ប៉ាតុំ តាហាន ហះ មឿង ស៊ូនែម។ សាដាច់ សូល កា ប៉ាតុំ កាំឡាំង តាហាន អ៊ីស្រាអ៊ែល ទិណោ័ះ អ្វៃ ហះ ប៉ានឹម គីលបោ។ ");
INSERT INTO tpu_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","ប៉ាគ់ សាដាច់ សូល ប៉ប័ កាំឡាំង តាហាន ភីលីសាទីន អ៊ែ អ្យូគ កាខរ់ ណូស កាខាក់ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","កេះណោះ អ៊ែ អំប៉ញ់ ប‌៉្រ័ះ ប៊កកាតយ័  ហះកា ប‌៉្រ័ះ អូ តើល អ៊ែ អុះ យ‌៉័ះ អំប៉ោ លើ យូរីម លើ ពឹង មួត រ៉ាគឹយ ប‌៉្រ័ះ កាតាម កា ប‌៉្រ័ះ អូ រ៉ះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","ទឹល នីណោ័ះ សាដាច់ សូល រ៉ះ កា មួត ប៉្រគ័ កាន កា អ៊ែ ផា «ហគ់ ឡាំ ណាំង អង់កាន់ បក់ អ្លុ អើ ប៉ាទ្រូ ម៉ាគ់ អាញ់ ចឹង ឡាំ អំប៉ញ់ អ៊ែ ឡឹង សារ អា»។ មួត ប៉្រគ័ កាន កា អ៊ែ រ៉ះ ផា «ប៉ាគ់ មឿង អេនដោរ ទី អង់កាន់ ម៉ោញ ដូវ អ្លុ អើ ប៉ាទ្រូ»។ ");
INSERT INTO tpu_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","សាដាច់ សូល កា កាស៊ប ពៀត ខោ អាវ ឡាក់ កា ប៉ាសុន ដោច ដាច កេះណោះ ឡាំ អន់ឌូ លូ គួប អ៊ែ ពៀរ ដូវ។ អ៊ែ ឡាំ ទឹល ប៉ាគ់ ហី អង់កាន់ ណោះ ផះ កាម៉ាំង អ៊ែ កាប លូ អង់កាន់ ណោះ ផា «អាញ់ ប៉ិច កា អីស អើ ប៉ាទ្រូ ម៉ោញ ដូវ កា អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","អង់កាន់ ណោះ តើល ផា «អីស អូ អ្លុ អន់តគ់ ប ? សាដាច់ សូល តាំងហ្យិត ឡាច់ គ្រូ អំហ្ម លូ គ្រូ អើ ប៉ាទ្រូ អូ អន់ ទី កាណុង ប៉ាថេត អា អុះ។ ខ ញ៉ា បះ អីស ប៉ិច ប៉្រគ័ សាទួង កា អាញ់ នីអៀ ? អីស ប៉ិច កា អាញ់ តោ័ ប ?» ");
INSERT INTO tpu_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","សាដាច់ សូល ម៉ត់ អើ ប‌៉្រ័ះ ប៊កកាតយ័ ផា «អាញ់ រ៉ះ កា អីស តាទឹច ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ រ៉ីស ដេល អីស អូ ទី ថូត ញ៉ា ញន កា សារ អា អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","អង់កាន់ ណោះ អំប៉ញ់ ផា «អីស ប៉ិច កា អាញ់ អើ ប៉ាង៉ាត័ ពឿ ?» សាដាច់ សូល តើល ផា «អាញ់ ប៉ិច កា អីស អើ វគ័ សាំយូអ៊ែល»។ ");
INSERT INTO tpu_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","ប៉ាគ់ អង់កាន់ ណោះ ប៉ប័ វគ័ សាំយូអ៊ែល អ៊ែ អង់ហ្យាំង ម៉ៃៗ ផា «ខ ញ៉ា បះ អីស តាំព្លូង កា អាញ់ នីអៀ ? អីស ហង សាដាច់ សូល !» ");
INSERT INTO tpu_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","ហះកា សាដាច់ សូល កាប ផា «ជែ អ្យូគ ហង ! អីស រ៉ះ ហៃ កា អាញ់ អីស ប៉ប័ ញ៉ា ?» អង់កាន់ ណោះ រ៉ះ ផា «អាញ់ ប៉ប័ ប៉ាទ្រូ ផះ អ្យូវ ឡាច់ ឡឹង តេះ»។ ");
INSERT INTO tpu_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","សាដាច់ សូល អំប៉ញ់ ផា «នីចម័ ត្រង័ អ៊ែ ណោះ ?» អង់កាន់ ណោះ តើល ផា «កាម៉ាក័ ក្រាគ់ ម៉ោញ ដូវ អ៊ែ ពៀត អាវ តីស អ៊ែ ផះ ហាវ ប៉ាគ់ អា»។ ផះ ណោះ សូល អ្លុ អន់តគ់ ផា វគ័ សាំយូអ៊ែល កេះ អ៊ែ កា កុប កល់ ទឹះ តេះ សាំប‌៉័ះ វគ័ សាំយូអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","វគ័ សាំយូអ៊ែល អំប៉ញ់ ផា «ខ ញ៉ា បះ អីស អើ តាគ់ អង់ខើក អាញ់ នីអៀ ?» សាដាច់ សូល តើល ផា «អាញ់ ទី សារ តីស ខាក់ ខង មួត ភីលីសាទីន ប៉ាណាំ គួប ពឹះ តាកូះ លូ អាញ់។ ប‌៉្រ័ះ ប៊កកាតយ័ កា អ្លាត អាញ់ កេះ អ៊ែ អូ តើល អាញ់ អុះ យ‌៉័ះ ពឹង រ៉ាគឹយ ប‌៉្រ័ះ លើ អំប៉ោ កាតាម កា អ៊ែ អូ រ៉ះ ដេល។ ញន ណោះ ហង បះ អាញ់ អើ អីស ពឹះ ភឿ រ៉ះ កា អាញ់ ត្រគ់ ប៉្រគ័ នីចម័ អន់ដា»។ ");
INSERT INTO tpu_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","វគ័ សាំយូអ៊ែល តើល ផា «ខ ញ៉ា បះ អីស ខំ អ្វៃ អំប៉ញ់ អាញ់ នីអៀ ? ប‌៉្រ័ះ ប៊កកាតយ័ អ្លាត អីស កេះ អ៊ែ កេះ តាម៉ឺរ លូ អីស ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ កា អីស ត្រគ់ ពួយ ប៉ានឹរ អាញ់ រ៉ះ កា អីស ពែ ហង អ៊ែ អូ អន់ អីស ប៉្រគ័ សាដាច់ កេះ អ៊ែ មប ប៉ាថេត អន់ កា ដាវីត រ៉ាំងហៃ ឡគ ");
INSERT INTO tpu_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","ខង អីស អូ ប៉្រគ័ ពួយ ប៉ានឹរ អ៊ែ លូ អូ ថាំឡាយ សុនសាត អាម៉ាឡេក ពួយ ពុត អ៊ែ អឺក កា អន់ឌែ ណោះ អុះ។ ញន ណោះ ហង បះ ពឹង ដារ់ អា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ កា អីស នីអៀ។ ");
INSERT INTO tpu_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","ម៉ោញ ណាវ្គ ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង មប អីស ទឹប មួត អ៊ីស្រាអ៊ែល កា សុនសាត ភីលីសាទីន។ ប៉ាគ់ តាយ៉ាង័ ទៀ អីស លូ គន កាម៉ាក័ អីស ចឹង ឡាំ អ្វៃ អន់ឌូ លូ អាញ់ ប៉ាគ់ ចារ ប៉ាទ្រូ ប‌៉្រ័ះ ប៊កកាតយ័ កា ចឹង មប តាហាន អ៊ីស្រាអ៊ែល កា មួត ភីលីសាទីន ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","ផាឌី សាដាច់ សូល ប៉ក់ គ្រួប ពឹង តេះ ញន កា ប៉ានឹរ សាំយូអ៊ែល រ៉ះ ណោះ ប៉្រគ័ អន់ អ៊ែ កាខរ់ ណូស ខាក់។ ផះ ណោះ អ៊ែ ទិ សាងុំ ខង អ៊ែ អូ សា សាណា ញ៉ា ម៉ោញ ដារ់ ម៉ោញ ម៉ាំង កេះ។ ");
INSERT INTO tpu_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","អង់កាន់ ណោះ កា ឡាំ ក្យាម័ សាដាច់ សូល អ៊ែ កា ប៉ប័ សូល កាខរ់ ណូស កាខាក់ អ៊ែ កា រ៉ះ ផា «អឺ ពឹ តាំងឡា អាញ់ សាំយ៉ាំង ប៉ានឹរ អីស កេះ។ អាញ់ កា សាឡាគ់ ឡាកោ ប៉្រគ័ ពួយ ប៉ានឹរ អីស ប៉្រើ។ ");
INSERT INTO tpu_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","កិញអៀ អា ប៉រ់ អីស សាំយ៉ាំង ប៉ានឹរ អាញ់ អាញ់ ចឹង ប៉្រគ័ សាណា អន់ កា អីស សា ហិ ម៉ាគ់ ចឹង ទី សាងុំ ចាក ប៉ាគ់ ម៉ាត់ ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","សាដាច់ សូល កា ប៉ាគែក អូ ចៃ សា សាណា អុះ ហះកា ញន កា អង់កាន់ លូ បក់ ប៉្រគ័ កាន កា អ៊ែ ណោះ កាប ប៉ាឡោម តាឡាម័ អ៊ែ កា ភម។ អ៊ែ កា អ្យូវ ឡឹង តេះ អង់អ្វៃ ពឹង គ្រេ។ ");
INSERT INTO tpu_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","អង់កាន់ ណោះ ទី គន រ៉ក់ តីស តង់ ម៉ោញ ពឹង អង់រឺម ហី អ៊ែ កា ប៉ាន់តាន កោះ ប៉្រគ័ សាអ៊្លង លូ អ្យក់ តាប៉ុង ម៉ាន ប៉្រគ័ ណុំ ប៉ាំង អូ ចៃគ ពុះ។ ");
INSERT INTO tpu_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","កេះណោះ អ៊ែ អោះ សាណា អន់ កា សាដាច់ សូល លូ មួត ប៉្រគ័ កាន កា អ៊ែ។ អន់ឌែ កា សា សាណា ទិឌូ កេះៗ កា អ្យូវ ចាក ឡាំ ណាវ្គ ម៉ាំង ណោះ ទៅ។ … ");
INSERT INTO tpu_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","តាហាន ភីលីសាទីន តាកូះ លូ តាហាន អ៊ីស្រាអ៊ែល។ តាហាន អ៊ីស្រាអ៊ែល សាតាក់ តាប៉្រះ តាប៉្រោង គែង ង៉ីរ មួត ភីលីសាទីន ផះ ណោះ តាហាន អ៊ីស្រាអ៊ែល អៀង ដូវ តោ័ ពឹង ប៉ានឹម គីលបោ។ ");
INSERT INTO tpu_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","មួត ភីលីសាទីន តាយ៉ិប ពួយ សាដាច់ សូល លូ គន អ៊ែ តិបៗ អន់ឌែ កា ប៉ាន់តោ័ យ៉ូណាថាន អាប៊ីណាដាប់ លូ ម៉ាល់គីស៊ូអា ឡាក់ គន សាដាច់ សូល។ ");
INSERT INTO tpu_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","ផះ ណោះ ពូ តាកូះ កេង ខាក់ ក្យាម័ សាដាច់ សូល តាហាន បក់ ចឹក ស្រាគ់ ប៉ាញ់ សាដាច់ សូល ឡាកា ជ្រុ ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","កេះណោះ អ៊ែ រ៉ះ លូ តាហាន បក់ ចឹក ឃឿង តាកូះ ផា «ហគ់ ហ្វាត់ ដាវ អីស ច្រាគ័ ប៉ាន់តោ័ អាញ់ ពិ ខង អាញ់ អូ ចៃ តោ័ ញន កា សុនសាត អន់ទៀគ ណោះ អុះ អន់ទៀ អន់ឌែ តាគ់ ប៉ាណាប អាញ់»។ ហះកា តាហាន ណោះ អូ ខឹន ប៉ាន់តោ័ អ៊ែ អុះ ខង អ៊ែ កាខរ់ ណូស អ្យូគ កាខាក់។ ទឹល នីណោ័ះ សាដាច់ សូល កា ហ្វាត់ ដាវ តាគ់ អំប៉ក់ ឡាកោ អ៊ែ អំប៉ាំង ម៉ូះ ដាវ។ ");
INSERT INTO tpu_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","ប៉ាគ់ តាហាន ចឹក ឃឿង តាកូះ ប៉ប័ សាដាច់ សូល តោ័ កេះ អ៊ែ កា ហ្វាត់ ដាវ តាគ់ អំប៉ក់ ឡាកោ អំប៉ាំង ម៉ូះ ដាវ តោ័ អន់ឌូ លូ សាដាច់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","សាដាច់ សូល លូ គន កាម៉ាក័ អ៊ែ ប៉ៃង ដូវ ទឹប តាហាន ឡាក់ ចឹក ឃឿង តាកូះ លូ តាហាន អ៊ែ ទិណោ័ះ កា តោ័ អន់ឌូ កាណុង ម៉ោញ ដារ់ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","ផះ ប៉ាសុន អ៊ីស្រាអ៊ែល ឡាក់ អ្វៃ គែង តោ ក្លូះ ប៉ានឹម លូ ប៉ាសុន អ៊ីស្រាអ៊ែល អ្វៃ ហាង តោ ទៀក ទ្រូង យដាន់ អ្លុ អន់តគ់ ផា តាហាន អ៊ីស្រាអ៊ែល សាតាក់ កេះ សាដាច់ សូល លូ គន កាម៉ាក័ អ៊ែ កា តោ័ ទិ កេះ អន់ឌែ ទិឌូ កា សាតាក់ ឡាច់ ឡឹង មឿង ទិណោ័ះ ឡូត។ តាហាន ភីលីសាទីន កា ឡាំ អ្វៃ ប៉ាញ័ ទឹប មឿង ណោះ គ្រឹប ចារ។ …");
INSERT INTO tpu_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","ផះ រ៉ាំងវ៉ាង ណោះ ផូង័ វ៉ាច់ អ៊ីស្រាអ៊ែល ទិណោ័ះ ប៉ាណាំ គួប ឡាំ ប៉ាគ់ ចារ សាដាច់ ដាវីត អ្វៃ ប៉ាគ់ មឿង ហេប្រូន លូ រ៉ះ ផា «ញឹន ផូង័ វ៉ាច់ អន់ឌូ លូ អីស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","ផះ រ៉ាំងវ៉ាង សាដាច់ សូល រ៉ាំងហៃ ញឹន អីស ហង ឃើយ ប៉ាណាំ ញឹន ឡាំ តាកូះ។ ផះ អន់ទ្រួល ពែ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អីស ផា \"អីស ចឹង រ៉ាំងហៃ សុនសាត អ៊ីស្រាអ៊ែល ឡាក់ ប៉ាសុន អាញ់ ឡាក់ កា ពូ រង ចៀម អីស ចឹង ប៉្រគ័ ម៉ៃគ ណាំផា អន់ឌែ\"»។ ");
INSERT INTO tpu_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","អា សារ មួត ក្រាគ់ តាំងកង់ ពឹះ រ៉ះ លូ សាដាច់ ដាវីត ប៉ាគ់ មឿង ហេប្រូន។ សាដាច់ ដាវីត កា សាញ៉ា រែវ ពុត លូ ក្រាគ់ តាំងកង់ ទិណោ័ះ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ពឹង មឿង ហេប្រូន កេះណោះ អន់ឌែ ជ្រោ សាងី ពឹង កល់ ដាវីត ប៉្រើ ប៉្រគ័ សាដាច់ សុនសាត អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","ផះ ដាវីត ហាវ ប៉្រគ័ សាដាច់ អ៊ែ អាញុ ៣០ សាណាំ អ៊ែ រ៉ាំងហៃ ទុញ ៤០ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","អ៊ែ រ៉ាំងហៃ ផូង័ វ៉ាច់ យូដា ប៉ាគ់ មឿង ហេប្រូន ៧ សាណាំ ៦ ខៃ ហះកា ប៉ាគ់ មឿង យេរូសាឡឹម អ៊ែ រ៉ាំងហៃ មួត យូដា លូ មួត អ៊ីស្រាអ៊ែល ទិឌូ ៣៣ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","សាដាច់ ដាវីត កា ប៉ាណាំ តាហាន ឡាំ តាកូះ លូ សុនសាត យេប៊ូស ភឿ អ្យក់ មឿង យេរូសាឡឹម។ ផះ ណោះ សុនសាត យេប៊ូស កាប បឺង៉ាយ សាដាច់ ដាវីត ផា «អីស ម៉ុត ពឹង មឿង អា អូ ទី អុះ យ‌៉័ះ ប៉ាណូស កាជក កាជែល ប៊្លែល ម៉ាត់ ត្រុត ឡាច់ អីស កា ទី ដេល»។ អន់ឌែ កាប នីណោ័ះ ញន អន់ឌែ ឃឹត ផា សាដាច់ ដាវីត តាប៉ីត អ្យក់ មឿង ណោះ អូ ដាម័ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("S25_7","011_5_7","2SA","5","7","7","ហះកា សាដាច់ ដាវីត តាប៉ីត អ្យក់ ខាយ តាហាន ពឹង ប៉ានឹម ស៊ីយ៉ូន ឡៃង ឡឹង ណោះ ពូ អើ ចារ ណោះ ផា «ស្រុក តេះ សាដាច់ ដាវីត»។ ");
INSERT INTO tpu_vpl VALUES ("S25_8","011_5_8","2SA","5","8","8","ផះ ណោះ សាដាច់ ដាវីត កាប ផា «ផានែវ បក់ ពឿ ចឹង តាកូះ លូ មួត យេប៊ូស ត្រគ់ ហាវ ពួយ ទ្រង ទៀក ជ្រៀយ កេះណោះ តាកូះ លូ មួត កាជក កាជែល ប៊្លែល ម៉ាត់ ឡាក់ អូ ណីស កា អាញ់ »។ ញន ណោះ ហង បះ ពូ កាប ផា «មួត កាជក កាជែល ប៊្លែល ម៉ាត់ អូ ទី ម៉ុត ពឹង ហី សាដាច់ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","សាដាច់ ដាវីត អ្វៃ ហះ ខាយ តាហាន ពឹង ប៉ានឹម ស៊ីយ៉ូន ណោះ ហង បះ អ៊ែ អើ ចារ ណោះ ផា «ស្រុក តេះ សាដាច់ ដាវីត»។ អន់តីគ ឡឹង ណោះ អ៊ែ ប៉្រគ័ មឿង ណោះ ហ៊ែង តីស ឡឹង ចារ ពូ តគ័ អំហ្មោ ប៉្រគ័ ប៉ាន់ទៀយ លើយ ទឹល ហី អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","សាដាច់ ដាវីត ទី អំរ៉ាញ ហ៊ែង កេង ៗ ខង ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ តេះ ប‌៉្រ័ះ ប៉្លៃង អ្វៃ អន់ឌូ លូ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S25_11","011_5_11","2SA","5","11","11","ហ៊ីរ៉ាម ឡាក់ សាដាច់ មឿង ទីរ៉ូះ ប៉្រើ ពូ ឡាំ រ៉ះ កា សាដាច់ ដាវីត ទឹប ប៉្រើ ពូ ប៉ាទុក ឡាំ អ៊្លង កាញូង លូ ប៉្រើ រ៉ាគឹយ ប៉្រគ័ ហី រ៉ាគឹយ ផាត អំហ្មោ ភឿ ប៉្រគ័ ហី អន់ កា សាដាច់ ដាវីត។ ");
INSERT INTO tpu_vpl VALUES ("S25_12","011_5_12","2SA","5","12","12","សាដាច់ ដាវីត អ្លុ អន់តគ់ ផា ប‌៉្រ័ះ ប៊កកាតយ័ អន់ អ៊ែ ប៉្រគ័ សាដាច់ រ៉ាំងហៃ ប៉ាថេត អ៊ីស្រាអ៊ែល ទឹប ទី អំរ៉ាញ អឺញ កេង ខាក់ ញន កា ប‌៉្រ័ះ ហៃ កា សុនសាត អ៊ីស្រាអ៊ែល ឡាក់ ប៉ាសុន អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S25_13","011_5_13","2SA","5","13","13","ប៉ាគ់ អ៊ែ ឡាច់ ឡឹង មឿង ហេប្រូន ឡាំ អ្វៃ ប៉ាគ់ មឿង យេរូសាឡឹម សាដាច់ ដាវីត ទី កាម៉ាញ់ ធែម ណាវ្គ ទឹប ទី មួត អង់កាន់ អន់ទៀគ ដេល អ៊ែ កា ទី គន កាម៉ាក័ គន អង់កាន់ អៀង ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S25_14","011_5_14","2SA","5","14","14","អា ហង សិច គន អ៊ែ ឡាក់ កើត ពឹង មឿង យេរូសាឡឹម៖ ទី សាមួ សូបាប់ ណាថាន សាឡូម៉ូន ");
INSERT INTO tpu_vpl VALUES ("S25_15","011_5_15","2SA","5","15","15","យីបហារ អេលីសួ នេផេក យ៉ាភៀ ");
INSERT INTO tpu_vpl VALUES ("S25_16","011_5_16","2SA","5","16","16","អេលីសាម៉ា អេលៀដា លូ អេលីផាលេត។ ");
INSERT INTO tpu_vpl VALUES ("S25_17","011_5_17","2SA","5","17","17","ប៉ាគ់ សុនសាត ភីលីសាទីន កាតាំង លៅ ផា ពូ ប៉្រើ ដាវីត ប៉្រគ័ សាដាច់ សុនសាត អ៊ីស្រាអ៊ែល ផះ ណោះ អន់ឌែ ប៉ាណាំ គួប ឡាំ តាកូះ លូ អ៊ែ។ ហះកា អ៊ែ អ្លុ អន់តគ់ ឡឹង សារ ណោះ អ៊ែ កា ឡាំ អ្វៃ ប៉ាគ់ ខាយ តាហាន។ ");
INSERT INTO tpu_vpl VALUES ("S25_18","011_5_18","2SA","5","18","18","ប៉ាគ់ មួត ភីលីសាទីន ពឹះ ទឹល អន់ឌែ កា អ្វៃ ប៉ាញ័ ទឹប ក្លូះ ប៉ានឹម រែផៃម។ ");
INSERT INTO tpu_vpl VALUES ("S25_19","011_5_19","2SA","5","19","19","ផះ ណោះ សាដាច់ ដាវីត អំប៉ញ់ ប‌៉្រ័ះ ប៊កកាតយ័ ផា «ញ៉ា អាញ់ ត្រគ់ ឡាំ តាកូះ លូ សុនសាត ភីលីសាទីន ញ៉ា អូ ? ញ៉ា អីស ចឹង មប អន់ឌែ កា អាញ់ ប ?» ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ផា «ឡាំ ពិ អាញ់ ចឹង មប អន់ឌែ កា អីស ហង»។ ");
INSERT INTO tpu_vpl VALUES ("S25_20","011_5_20","2SA","5","20","20","ផះ ណោះ ដាវីត កា ឡាំ ប៉ាគ់ បាលពេរ៉ាស៊ីម ប៉ាគ់ ចារ ណោះ អ៊ែ តាកូះ សាណ័ះ ទ្រង អ៊ែ។ កេះណោះ អ៊ែ កាប ផា «ប‌៉្រ័ះ ប៊កកាតយ័ ថាំឡាយ តាម៉ឺរ ឡាក់ កា ទៀក ប៉ាទុះ ប៉ានឹត»។ ញន ខ អា ហង បះ ពូ អើ ចារ ណោះ ផា បាលពេរ៉ាស៊ីម ។ ");
INSERT INTO tpu_vpl VALUES ("S25_21","011_5_21","2SA","5","21","21","ផះ តាហាន ភីលីសាទីន សាតាក់ តាប៉្រះ តាប៉្រោង អន់ឌែ អ្លាត ហ៊ូប ប‌៉្រ័ះ ហះ ចារ ណោះ។ សាដាច់ ដាវីត លូ តាហាន អ៊ែ អ្យក់ ហ៊ូប ប‌៉្រ័ះ ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("S25_22","011_5_22","2SA","5","22","22","អន់តីគ ឡឹង ណោះ សុនសាត ភីលីសាទីន ប៉ាណាំ គួប ឡាំ អ្វៃ ប៉ាញ័ ទឹប ក្លូះ ប៉ានឹម រែផៃម ម៉ោញ ទង ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("S25_23","011_5_23","2SA","5","23","23","សាដាច់ ដាវីត កា អំប៉ញ់ ប‌៉្រ័ះ ប៊កកាតយ័  ប‌៉្រ័ះ កា រ៉ះ ផា «ជែ ឡាំ តាកូះ លូ អន់ឌែ ទ្រង ង៉ីរ។ ហគ់ ចាក តារ័ គែង អង់កក់ តាកូះ លូ អន់ឌែ ហះ តើម អ៊្លង តីសៗ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("S25_24","011_5_24","2SA","5","24","24","ប៉ាគ់ អីស កាតាំង រ៉ាយ៉ាគ់ ពឹង ក្យង់ អ៊្លង ហគ់ តាឡូះ ឡាំ ពិ ខង ផះ ណោះ ហង អាញ់ ចាក អន់ទ្រួល ភឿ តាកូះ លូ តាហាន ភីលីសាទីន»។ ");
INSERT INTO tpu_vpl VALUES ("S25_25","011_5_25","2SA","5","25","25","សាដាច់ ដាវីត ប៉្រគ័ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័  អ៊ែ តាកូះ សាណ័ះ ទ្រង អ៊ែ អន់ឌែ តាយ៉ិប ពួយ មួត ភីលីសាទីន ឡឹង មឿង កេបា លើយ ទឹល មឿង កេស៊ើរ។ ");
INSERT INTO tpu_vpl VALUES ("S26_1","011_6_1","2SA","6","1","1","ឡៃង ឡឹង ណោះ សាដាច់ ដាវីត កា ប៉ាតុំ តាហាន បក់ កេង ខាក់ ម៉ោញ ទង ណាវ្គ ឃឺ អ៊ែ ៣០.០០០ ដូវ។ ");
INSERT INTO tpu_vpl VALUES ("S26_2","011_6_2","2SA","6","2","2","សាដាច់ ដាវីត លូ តាហាន អ៊ែ កា ចាក ទឹល តេះ បាលេ ឡាក់ ស្រុក ផូង័ យូដា ភឿ អ្យក់ ហ៊ីប សារ សាញ៉ា រែវ ពុត ឡឹង ចារ ណោះ។ ហ៊ីប ណោះ ពូ អន់ សិច ផា ហ៊ីប ម៉ះ ប‌៉្រ័ះ តេះ ប‌៉្រ័ះ ប៉្លៃង ដេល ខង អ៊ែ អ្វៃ អំប៉ាំង មួត ចេរូប៊ីន។ ");
INSERT INTO tpu_vpl VALUES ("S26_3","011_6_3","2SA","6","3","3","ពូ អ្យក់ ឡាច់ ហ៊ីប ប‌៉្រ័ះ ប៊កកាតយ័ ឡឹង ហី វគ័ អាប៊ីណាដាប់ ឡាក់ អ្វៃ ពឹង ប៉ានឹម ប៉ាទុក ពឹង រ៉ាតេ័ះ ណាវ។ អ៊ុសា លូ អាហ៊ីយ៉ូ គន វគ័ អាប៊ីណាដាប់ ទុង រ៉ក់ រ៉ាតេ័ះ ");
INSERT INTO tpu_vpl VALUES ("S26_4","011_6_4","2SA","6","4","4","ឡាក់ ពូ ប៉ាទុក ហ៊ីប ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ អាហ៊ីយ៉ូ កា ចាក គែង ង៉ីរ។ ");
INSERT INTO tpu_vpl VALUES ("S26_5","011_6_5","2SA","6","5","5","សាដាច់ ដាវីត លូ ប៉ាសុន អ៊ីស្រាអ៊ែល ទិណោ័ះ រ៉គ់ សើម កាខាក់ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័  អន់ឌែ ប៉ាណាំ គួប ចាជែ អញ់ស៊ែ ទឹប អន់ទែង ព្រួក អ៊ត កាណី តាប៉ះ សាគឹរ តាប៉ះ សារ។ ");
INSERT INTO tpu_vpl VALUES ("S26_6","011_6_6","2SA","6","6","6","ប៉ាគ់ ទឹល ចារ ប៉្រះ ពៀ វគ័ ណាកុន អ៊ុសា តាឡូះ ឡាំ ត្រាគ័ ហ៊ីប ប‌៉្រ័ះ ប៊កកាតយ័ ខង រ៉ក់ តាហ៊្រច ជុង ចឹង ប៉្រគ័ អន់ ហ៊ីប ណោះ ឡិ។ ");
INSERT INTO tpu_vpl VALUES ("S26_7","011_6_7","2SA","6","7","7","ផះ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ អឺក កា អ៊ុសា អ៊ែ ប៉ាន់តោ័ អ៊ុសា ញន កា សារ យច អ៊ែ ណោះ។ អ៊ុសា តោ័ ហះ សានែង ហ៊ីប ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("S26_8","011_6_8","2SA","6","8","8","សាដាច់ ដាវីត ប៉ិច អឺក ខាក់ ញន កា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ កា អ៊ុសា នីអៀ។ ញន ណោះ ហង បះ ពូ អន់ សិច ចារ ណោះ ផា ពែរេះ អ៊ុសា លើយ ទឹល រ៉ប់ ដារ់ អា។ ");
INSERT INTO tpu_vpl VALUES ("S26_9","011_6_9","2SA","6","9","9","ផះ ណោះ សាដាច់ ដាវីត អ្យូគ កា ប‌៉្រ័ះ ប៊កកាតយ័  អ៊ែ កាប ផា «អាញ់ អូ ខឹន អ្យក់ ហ៊ីប ប‌៉្រ័ះ ប៊កកាតយ័ ម៉ុត ក្យាម័ អាញ់ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("S26_10","011_6_10","2SA","6","10","10","ទឹល នីណោ័ះ អ៊ែ អូ ប៉ិច អ្យក់ ហ៊ីប ប‌៉្រ័ះ ប៊កកាតយ័ ម៉ុត ពឹង ស្រុក តេះ សាដាច់ ដាវីត ហង ហះកា អ៊ែ ប៉្រើ ពូ អ្យក់ ហ៊ីប ណោះ រ៉ាន់ដាប់ ប៉ាគ់ ហី អូបេតអេដំ ឡាក់ ប៉ាណូស ឡឹង មឿង កាត។ ");
INSERT INTO tpu_vpl VALUES ("S26_11","011_6_11","2SA","6","11","11","ហ៊ីប ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ ប៉ាគ់ ហី អូបេតអេដំ ទុញ ប៉ៃង ខៃ។ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ដាគ់ កា អូបេតអេដំ លូ ហី ក្រាន អ៊ែ ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("S26_12","011_6_12","2SA","6","12","12","ពូ រ៉ះ កា សាដាច់ ដាវីត ផា «ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ដាគ់ កា ហី ក្រាន អូបេតអេដំ ទឹប កាណាគ័ ញ៉ាៗ ឡាក់ អ៊ែ ទី ញន កា ហ៊ីប ប‌៉្រ័ះ ប៊កកាតយ័»។ សាដាច់ ដាវីត កា ឡាំ ប៉ាគ់ ហី វគ័ អូបេតអេដំ ភឿ អ្យក់ ហ៊ីប ណោះ ម៉ុត ពឹង ស្រុក តេះ សាដាច់ ដាវីត ទឹប ទី ពូ ចាក អន់ឌូ រ៉គ់ សើម ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S26_13","011_6_13","2SA","6","13","13","ផះ មួត បក់ តូង័ ហ៊ីប ប‌៉្រ័ះ ប៊កកាតយ័ យ៉ាក ទី ត្រោ ទង យ៉ាក សាដាច់ ដាវីត អ្យក់ រ៉ក់ ទោល ម៉ោញ កាតុ លូ គន រ៉ក់ តង់ៗ ម៉ោញ កាតុ រ៉ាម៉ះ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("S26_14","011_6_14","2SA","6","14","14","សាដាច់ ដាវីត កាតាប័ ប៉ាប៉្លង់ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ទិ ពុត ទិ ពៀក ទឹប ពៀត អាវ បាក ប៉្រគ័ លូ តាមៃ។ ");
INSERT INTO tpu_vpl VALUES ("S26_15","011_6_15","2SA","6","15","15","សាដាច់ ដាវីត លូ ប៉ាសុន អ៊ីស្រាអ៊ែល ទិណោ័ះ ចាក ឡាំ ជឹន ហ៊ីប ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាគ់ មឿង យេរូសាឡឹម អន់ឌែ តាំងហើ ម៉ៃៗ លូ ខ្លោម សាណៃង។ ");
INSERT INTO tpu_vpl VALUES ("S26_16","011_6_16","2SA","6","16","16","ផះ ហ៊ីប ប‌៉្រ័ះ ប៊កកាតយ័ ម៉ុត ពឹង ស្រុក តេះ សាដាច់ ដាវីត កេះ មីកាល គន អង់កាន់ សាដាច់ សូល សាម៉ង័ ហៃ ឡឹង រ៉ាំបោះ ប៉ប័ សាដាច់ ដាវីត កាតាប័ ប៉ាប៉្លង់ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័  ផះ ណោះ អ៊ែ បឺង៉ាយ សាដាច់ ដាវីត ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("S26_17","011_6_17","2SA","6","17","17","ប៉ាគ់ អ្យក់ ហ៊ីប ប‌៉្រ័ះ ប៊កកាតយ័ ទឹល កេះ ពូ ចៃគ ពឹង រ៉ាណើះ ឡាក់ សាដាច់ ដាវីត ប៉្រគ័ សាំរ៉ាប់ រ៉ាន់ដាប់ ហ៊ីប ណោះ។ អ៊ែ ពុះ អ្លាត កាណាគ័ រ៉ាម៉ះ លូ ពុះ កាណាគ័ រ៉ាម៉ះ សាំរ៉ាប់ សា អន់ឌូ លូ គួប សោប ហោក រ៉គ់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("S26_18","011_6_18","2SA","6","18","18","កេះ អ៊ែ ពុះ កាណាគ័ រ៉ាម៉ះ កេះៗ សាដាច់ ដាវីត កា ប៉រ់ ឡឹង ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ តេះ ប‌៉្រ័ះ ប៉្លៃង អន់ សារ ដាគ់ កា ប៉ាសុន ទិឌូ។ ");
INSERT INTO tpu_vpl VALUES ("S26_19","011_6_19","2SA","6","19","19","សាដាច់ ដាវីត អន់ សាណា កា ប៉ាសុន អ៊ីស្រាអ៊ែល ទិណោ័ះ ទឹប កាម៉ាក័ ទឹប អង់កាន់ ឃឺ ម៉ោញ ដូវ ៗ ទី ណុំ ប៉ាំង ម៉ោញ កាតុ លូ ប៉ាំងឡៃ រ៉ក់ ម៉ោញ រ៉ាឡា លូ ណុំ ពូ ប៉្រគ័ លូ ប៉្លៃ កាច អង់កាច ម៉ោញ កាតុ។ កេះណោះ ប៉ាសុន អ៊ីស្រាអ៊ែល ទិណោ័ះ ប៉ាណាំ គួប សឹត ប៉ាគ់ ហី ពឿ ហី អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S26_20","011_6_20","2SA","6","20","20","សាដាច់ ដាវីត កា សឹត ប៉ាគ់ ហី អ៊ែ ទៅ ដេល ភឿ ប៉រ់ សារ ដាគ់ កា ហី ក្រាន អ៊ែ។ មីកាល កា ឡាំ ប៉ាគ់ ចារ អ៊ែ ទឹប កាប ប៉ាឡៃវ ផា «ដារ់ អា សាដាច់ សុនសាត អ៊ីស្រាអ៊ែល ប៉្រគ័ អន់ ឡាកោ លៅ លែង ខាក់ ខង អីស អ្វៃ ឡាកោ ដោះ ឡាក់ កា ប៉ាណូស អូ គឹត អូ ខា ហះ ម៉ាត់ មួត ទុច អង់កាន់ ឡាក់ ថិ ឡឹង ពូ»។ ");
INSERT INTO tpu_vpl VALUES ("S26_21","011_6_21","2SA","6","21","21","សាដាច់ ដាវីត តើល មីកាល ផា «អាញ់ ប៉្រគ័ នីណោ័ះ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ រ៉ើស អាញ់ ប៉្រើ រ៉ាំងហៃ សុនសាត អ៊ីស្រាអ៊ែល ឡាក់ ប៉ាសុន អ៊ែ ប៉ាតាង ពឹ អីស លូ មួត ហី ក្រាន ពឹ អីស។ អាញ់ រ៉គ់ សើម ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("S26_22","011_6_22","2SA","6","22","22","អាញ់ ចឹង ប៉្រគ័ កា ឡាកោ ច្រាប័ ក្វា ឡឹង អា ណាវ្គ សាំ។ យ‌៉័ះ យច ម៉ាត់ អីស កាតាម ហះកា មួត ទុច អង់កាន់ ឡាក់ អីស កាប ណោះ អន់ឌែ ប៉ានេ អាញ់ ខាក់»។ ");
INSERT INTO tpu_vpl VALUES ("S26_23","011_6_23","2SA","6","23","23","ញន កា មីកាល កាប កា សាដាច់ ដាវីត នីអៀ បះ អ៊ែ អូ ទី គន លើយ ឡុច អាញុ។ ");
INSERT INTO tpu_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","ប៉ាគ់ សាដាច់ ដាវីត ទី ហី សាដាច់ អ្វៃ ដាគ់ រ៉គ់ កេះ ឡៃង ឡឹង ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ សាណុក សាវ៉ាក រ៉ាវ៉ាច់ ឡឹង តាម៉ឺរ គ្រឹប ចារ ");
INSERT INTO tpu_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","អ៊ែ កាប លូ រ៉ាគឹយ ប‌៉្រ័ះ សិច ណាថាន ផា «អីស ឃឹត ហៃ អាញ់ អ្វៃ កាណុង ហី ប៉្រគ័ លូ អ៊្លង កាញូង ហះកា ហ៊ីប ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ កាណុង រ៉ាណើះ»។ ");
INSERT INTO tpu_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","វគ័ ណាថាន រ៉ះ កា អ៊ែ ផា «ង៉ារ ញ៉ា ឡាក់ ពុត អីស ប៉ិច ប៉្រគ័ អ្យគ័ ប៉្រគ័ ពិ ខង ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ អន់ឌូ លូ អីស កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","ហះកា ម៉ាំង ណោះ ហង ប‌៉្រ័ះ ប៊កកាតយ័ កាប លូ វគ័ ណាថាន ផា ");
INSERT INTO tpu_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","«ហគ់ រ៉ះ កា ទុច អាញ់ ដាវីត \"ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ កាប នីអៀ 'ញ៉ា អីស ចឹង ប៉្រគ័ ហី កា អាញ់ អ្វៃ ប ? ");
INSERT INTO tpu_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","ឡឹង ដារ់ អាញ់ ប៉ាណាំ សុនសាត អ៊ីស្រាអ៊ែល ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប លើយ ទឹល ដារ់ អា អាញ់ អូ ឃើយ អ្វៃ កាណុង ហី អុះ។ អាញ់ ចាក ឡឹង ចារ ម៉ោញ អន់ ប៉ាគ់ ចារ ម៉ោញ អ្វៃ ដឹង កាណុង រ៉ាណើះ។ ");
INSERT INTO tpu_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","គ្រឹប ចារ អាញ់ ចាក អន់ឌូ លូ សុនសាត អ៊ីស្រាអ៊ែល អាញ់ អូ ឃើយ រ៉ះ កា ម៉ៃគ ណាំផា ឡាក់ អាញ់ ប៉្រើ រ៉ាំងហៃ ប៉ាសុន អ៊ីស្រាអ៊ែល បក់ ចំ ម៉ោញ ប៉្រើ ប៉្រគ័ ហី លូ អ៊្លង កាញូង សាំរ៉ាប់ អាញ់ អុះ' \"។ ");
INSERT INTO tpu_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","ទឹល នីណោ័ះ អីស ត្រគ់ រ៉ះ កា ដាវីត ឡាក់ ទុច អាញ់ ផា \"ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ តេះ ប‌៉្រ័ះ ប៉្លៃង អ៊ែ រ៉ះ នីអៀ 'ផះ អីស អ្វៃ រង ចៀម អាញ់ អ្យក់ អីស ឡឹង ស៊្រែ ភឿ ប៉្រើ អីស ប៉្រគ័ ម៉ៃគ ណាំផា សុនសាត អ៊ីស្រាអ៊ែល ឡាក់ ប៉ាសុន អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","អាញ់ អ្វៃ អន់ឌូ លូ អីស គ្រឹប ចារ អីស ឡាំ ទឹប អាញ់ ថាំឡាយ តាម៉ឺរ អីស ទិ ឡឹង ង៉ីរ អីស។ អាញ់ ចឹង ប៉្រគ័ អន់ អីស លៅ លែង សិច ឡាក់ កា មួត រ៉ាតីសៗ ពឹង អង់កក់ តេះ អា។ ");
INSERT INTO tpu_vpl VALUES ("S27_10","011_7_10","2SA","7","10","10","អាញ់ ចឹង ប៉្រគ័ អន់ អ៊ីស្រាអ៊ែល ឡាក់ ប៉ាសុន អាញ់ អ្វៃ លើយ ពឹង ប៉ាថេត អាញ់ អន់ កា អន់ឌែ អាញ់ ចឹង អន់ អន់ឌែ ប៉្រគ័ ចារ អ្វៃ លើយ អូ ទី ពឿ ពឹះ ប៉ាំងអ្យូគ អុះ។ អូ ទី មួត អូ ដាគ់ ជិះ ចគ់ អន់ឌែ ឡាក់ កា ផះ អន់ទ្រួល ពែ អុះ ");
INSERT INTO tpu_vpl VALUES ("S27_11","011_7_11","2SA","7","11","11","ឡាក់ កា ផះ រ៉ាំងវ៉ាង អាញ់ រ៉ើស មួត ម៉ៃគ ណាំផា ប៉្រើ រ៉ាំងហៃ អ៊ីស្រាអ៊ែល ពែ។ អាញ់ អន់ អីស ទី សារ សាណុក សាវ៉ាក រ៉ាវ៉ាច់ ឡឹង តាម៉ឺរ ទិណោ័ះ។ ម៉ោញ ណាវ្គ អាញ់ រ៉ះ កា អីស ផា ចឹង ប៉ោក ហាវ ផូង័ វ៉ាច់ អីស ហង។ ");
INSERT INTO tpu_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","ដារ់ ចំ អីស ឡុច អាញុ តោ័ ពួយ វគ័ យ៉ាគ់ អីស កេះ អាញ់ ចឹង អន់ គន អីស ទៅ ហាវ ប៉្រគ័ សាដាច់ តាង អីស ណាវ្គ លូ អាញ់ ចឹង ប៉្រគ័ អន់ អ៊ែ ទី អំរ៉ាញ កេង ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","គន អីស ហង ចឹង ប៉្រគ័ រ៉ោង រ៉ាម៉ះ សាំរ៉ាប់ កា អាញ់ លូ អាញ់ ចឹង ប៉្រគ័ អន់ អ៊ែ រ៉ាំងហៃ លើយ។ ");
INSERT INTO tpu_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","អាញ់ ចឹង ប៉្រគ័ ពឹ អ៊ែ អ៊ែ កា ចឹង ប៉្រគ័ គន អាញ់ ដេល។ ផានែវ អ៊ែ ប៉្រគ័ ញ៉ា យច អាញ់ ចឹង សាប៉្វាត័ តាគ់ អញ់ចាល អ៊ែ ឡាក់ កា ប៉ាណូស ពឹង អង់កក់ តេះ សាប៉្វាត័ តាគ់ អញ់ចាល គន អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","ហះកា អាញ់ អូ អ្លាត ប៉ិច ចៃ កា អ៊ែ អុះ ឡាក់ កា អាញ់ អ្លាត ប៉ិច ចៃ កា សូល ឡាក់ អាញ់ អ្យក់ ឡាច់ ឡឹង ម៉ាត់ អីស។ ");
INSERT INTO tpu_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","ផូង័ វ៉ាច់ អីស ចឹង អ្វៃ រ៉ាំងហៃ អ៊ីស្រាអ៊ែល ហះ ម៉ាត់ អាញ់ លើយ អូ ឡុច អុះ' \"»។ ");
INSERT INTO tpu_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","វគ័ ណាថាន រ៉ះ កា សាដាច់ ដាវីត ឡឹង សារ ប‌៉្រ័ះ ប៊កកាតយ័ តាំបាង លូ រ៉ះ កា អ៊ែ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("S27_18","011_7_18","2SA","7","18","18","សាដាច់ ដាវីត កា ម៉ុត អង់អ្វៃ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ លូ កាប ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ តាំងឡា អាញ់ លូ ផូង័ វ៉ាច់ អាញ់ ប៉ាណូស នីចម័ បះ អីស ដាគ់ កា អាញ់ លើយ ទឹល រ៉ប់ ដារ់ អា ? ");
INSERT INTO tpu_vpl VALUES ("S27_19","011_7_19","2SA","7","19","19","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ តាំងឡា អីស ឃឹត ផា កាន ប៉្រគ័ ដាគ់ កា អាញ់ អា ថិ ប សាំរ៉ាប់ អីស បះ អីស សាញ៉ា លូ អាញ់ ទឹប ទឹល គន សោ អាញ់ អ្វៃ រ៉ាំងហាវ អន់តីគ ទៀ ដេល ? ញ៉ា អីស ឃើយ ប៉្រគ័ នីអៀ ហង ប លូ ប៉ាណូស ? ");
INSERT INTO tpu_vpl VALUES ("S27_20","011_7_20","2SA","7","20","20","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ តាំងឡា សារ ញ៉ា អាញ់ ចឹង រ៉ះ កា អីស ? ខង អីស អន់ហ្នាល់ អាញ់ ខាក់ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("S27_21","011_7_21","2SA","7","21","21","អីស ប៉្រគ័ ង៉ារ តីស អា អន់ អាញ់ ប៉ប័ ត្រគ់ ពួយ ប៉ានឹរ អីស សាញ៉ា លូ ពុត អីស ដាគ់ ត្រង់។ ");
INSERT INTO tpu_vpl VALUES ("S27_22","011_7_22","2SA","7","22","22","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ តាំងឡា អីស តីស ខាក់ អូ ទី ប‌៉្រ័ះ ចំ សាម៉ើ លូ អីស អុះ។ ទី ដឹង អីស ហង ប‌៉្រ័ះ តាទឹច ឡាក់ ញឹន ឃើយ កាតាំង ឡឹង ម៉ោហ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("S27_23","011_7_23","2SA","7","23","23","អ្វៃ ពឹង អង់កក់ តេះ អា អូ ទី សុនសាត ចំ ឡាក់ កា សុនសាត អ៊ីស្រាអ៊ែល អុះ ឃឺ អីស តង័ ញឹន អ្យក់ ប៉្រគ័ ប៉ាសុន អីស ភឿ អន់ អីស លៅ លែង សិច។ អីស តាំបាង សារ អំរ៉ាញ កេង ខាក់ ត្រគ់ អ្យូគ អន់ ប៉ាសុន អីស ប៉ប័ ឃឺ ប៉ាសុន ឡាក់ អីស ហ្វាយ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ឃឺ អន់ រ៉ាវ៉ាច់ ឡឹង សុនសាត អន់ទៀគ លូ ប‌៉្រ័ះ អន់ឌែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S27_24","011_7_24","2SA","7","24","24","អឺ ប‌៉្រ័ះ ប៊កកាតយ័  អីស រ៉ើស សុនសាត អ៊ីស្រាអ៊ែល ភឿ អន់ ញឹន ប៉្រគ័ ប៉ាសុន អីស លើយ អីស កា កេះ ប‌៉្រ័ះ ញឹន ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S27_25","011_7_25","2SA","7","25","25","កិញអៀ អា អឺ ប‌៉្រ័ះ ប៊កកាតយ័  ប៉រ់ អីស អន់ សារ ឡាក់ អីស សាញ៉ា លូ អាញ់ ទឹប គន សោ អាញ់ អ្វៃ លើយ ប៉រ់ អីស ប៉្រគ័ ពួយ ប៉ានឹរ អីស ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("S27_26","011_7_26","2SA","7","26","26","អន់ អីស លៅ លែង សិច លើយ ទឹប អន់ ពូ កាប ផា \"ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ តេះ ប‌៉្រ័ះ ប៉្លៃង អ៊ែ ហង ប‌៉្រ័ះ រ៉ាំងហៃ សុនសាត អ៊ីស្រាអ៊ែល\"។ អន់ ផូង័ វ៉ាច់ អាញ់ អ្វៃ ហះ ម៉ាត់ អីស លើយ។ ");
INSERT INTO tpu_vpl VALUES ("S27_27","011_7_27","2SA","7","27","27","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ តេះ ប‌៉្រ័ះ ប៉្លៃង ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល អីស ប៉្រគ័ អន់ អាញ់ អ្លុ អន់តគ់ កេះ ឡឹង កាន អីស ចឹង ប៉ោក ហាវ ផូង័ វ៉ាច់ អាញ់។ ខ អា ហង បះ អាញ់ ទី ពុត ខឹន ម៉ន់ ប៉រ់ ហះ អីស នីអៀ។ ");
INSERT INTO tpu_vpl VALUES ("S27_28","011_7_28","2SA","7","28","28","កិញអៀ អា អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ តាំងឡា អីស ឡាក់ ប‌៉្រ័ះ តាទឹច ប៉ានឹរ អីស ស៊ុត កា ដាគ់ ត្រង់ តាទឹច អីស សាញ៉ា ចឹង ប៉្រគ័ ដាគ់ កា អាញ់ នីអៀ។ ");
INSERT INTO tpu_vpl VALUES ("S27_29","011_7_29","2SA","7","29","29","ទឹល នីណោ័ះ ប៉រ់ អីស អន់ សារ ដាគ់ កា ផូង័ វ៉ាច់ អាញ់ ភឿ អន់ អន់ឌែ អ្វៃ ហះ ម៉ាត់ អីស លើយ។ អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ តាំងឡា ប៉រ់ អន់ សារ ដាគ់ កា ផូង័ វ៉ាច់ អាញ់ ត្រគ់ ពួយ ប៉ានឹរ អីស អា ម៉ាគ់ អន់ឌែ ចឹង ទី សារ ដាគ់ លើយ»។ ");
INSERT INTO tpu_vpl VALUES ("S28_1","011_8_1","2SA","8","1","1","អន់តីគ ឡឹង ណោះ សាដាច់ ដាវីត តាកូះ លូ សុនសាត ភីលីសាទីន សាណ័ះ ទ្រង អ៊ែ អ៊ែ តាប៉ីត អ្យក់ មឿង តីស ឡឹង ពូ ឡឹង តី សុនសាត ភីលីសាទីន ដេល អន់ឌែ អូ ខឹន កា អ៊ែ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("S28_2","011_8_2","2SA","8","2","2","អ៊ែ កា តាកូះ លូ សុនសាត ម៉ូអាប់ កា សាណ័ះ ទ្រង អ៊ែ ដេល អ៊ែ ប៉ាំងខំ ប៉្រើ អន់ឌែ តៃប ពឹង តេះ កេះណោះ ជែក ប៉ៃង តាប៉ល់ ពៀរ តាប៉ល់ អ្យក់ ឡាំ ប៉ាន់តោ័ លូ ម៉ោញ តាប៉ល់ អន់ អ្វៃ រ៉ីស។ សុនសាត ម៉ូអាប់ កា មប ឡាកោ អន់ សាដាច់ ដាវីត រ៉ាំងហៃ ទឹប ស៊ង រ៉ាបៃ កា អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S28_3","011_8_3","2SA","8","3","3","ផះ ហាដាដេស៊ើរ គន សាដាច់ រេហូប ឡាក់ សាដាច់ មឿង សូបា ចាក ឡាំ ភឿ តាប៉ីត អ្យក់ សឹត ព្រី ទៀក ក្យាម័ តាំងលេ អឺប៉្រាត ផះ ណោះ សាដាច់ ដាវីត កា តាកូះ លូ តាហាន អ៊ែ កា សាណ័ះ ទ្រង សាដាច់ ដាវីត ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S28_4","011_8_4","2SA","8","4","4","សាដាច់ ដាវីត រ៉ុប តាហាន សាដាច់ ហាដាដេស៊ើរ បក់ ជិះ សេះ ១៧០០ ដូវ លូ តាហាន ចាក ជុង ២០.០០០ ដូវ។ អ៊ែ កា កាសិត រ៉ាត់ ជួន សេះ ទិណោ័ះ គម ដឹង ១០០ កាតុ។ ");
INSERT INTO tpu_vpl VALUES ("S28_5","011_8_5","2SA","8","5","5","ផះ ណោះ សុនសាត ស៊ីរី អ្វៃ ពឹង មឿង ដាម៉ះ ប៉ាណាំ គួប ឡាំ តង័ សាដាច់ ហាដាដេស៊ើរ សាដាច់ ដាវីត កា តាកូះ សាណ័ះ ទ្រង អ៊ែ ដេល ទឹប អ៊ែ ប៉ាន់តោ័ សុនសាត ស៊ីរី ណោះ ២២.០០០ ដូវ។ ");
INSERT INTO tpu_vpl VALUES ("S28_6","011_8_6","2SA","8","6","6","សុនសាត ស៊ីរី កា មប ឡាកោ អន់ សាដាច់ ដាវីត រ៉ាំងហៃ លូ ស៊ង រ៉ាបៃ កា អ៊ែ ដេល។ សាដាច់ ដាវីត កា ប៉្រើ មួត តាហាន រ៉ាំងហៃ ពឹង មឿង ដាម៉ះ លូ ស្រុក តេះ សុនសាត ស៊ីរី អន់ទៀគៗ។ ប‌៉្រ័ះ ប៊កកាតយ័ តង័ សាដាច់ ដាវីត គ្រឹប សារ។ ");
INSERT INTO tpu_vpl VALUES ("S28_7","011_8_7","2SA","8","7","7","សាដាច់ ដាវីត អ្យក់ ខៃល ម៉ាស ឡឹង មួត បក់ ប៉្រគ័ កាន រ៉ាតីស លូ សាដាច់ ហាដាដេស៊ើរ អ្យក់ ឡាំ រ៉ាន់ដាប់ ប៉ាគ់ មឿង យេរូសាឡឹម។ ");
INSERT INTO tpu_vpl VALUES ("S28_8","011_8_8","2SA","8","8","8","សាដាច់ ដាវីត អ្យក់ សាប៉ាន័ អៀង ខាក់ ឡឹង មឿង បេថះ លូ មឿង បេរ៉ូថាយ ឡាក់ មឿង សាដាច់ ហាដាដេស៊ើរ រ៉ាំងហៃ។ ");
INSERT INTO tpu_vpl VALUES ("S28_9","011_8_9","2SA","8","9","9","ប៉ាគ់ ថូអ៊ី ឡាក់ សាដាច់ មឿង ហាម៉ាត អ្លុ អន់តគ់ ផា សាដាច់ ដាវីត តាកូះ លូ សាដាច់ ហាដាដេស៊ើរ សាណ័ះ ទ្រង អ៊ែ កេះ ");
INSERT INTO tpu_vpl VALUES ("S28_10","011_8_10","2SA","8","10","10","សាដាច់ ថូអ៊ី ហោក រ៉គ់ ខង សាដាច់ ហាដាដេស៊ើរ ឃើយ ឡាំ តាកូះ លូ អ៊ែ ដេល។ អ៊ែ កា ប៉្រើ យ៉ូរ៉ាម ឡាក់ គន កាម៉ាក័ អ៊ែ ឡាំ ប៉ាគ់ ចារ សាដាច់ ដាវីត ភឿ អំប៉ញ់ សាដាច់ ដាវីត អ៊ែ ដាគ់ ឡាកោ ប៉ាំងឡៃ ដេល ប។ យ៉ូរ៉ាម កា ហោក រ៉គ់ អន់ឌូ លូ សាដាច់ ដាវីត ញន កា សាដាច់ ដាវីត តាកូះ លូ សាដាច់ ហាដាដេស៊ើរ ទឹប សាណ័ះ ទ្រង អ៊ែ។ យ៉ូរ៉ាម កា អ្យក់ ឃឿង ខង ប៉្រគ័ លូ ម៉ាស ប៉្រាក់ លូ សាប៉ាន័ ឡាំ មប អន់ កា សាដាច់ ដាវីត។ ");
INSERT INTO tpu_vpl VALUES ("S28_11","011_8_11","2SA","8","11","11","សាដាច់ ដាវីត កា អ្យក់ ឃឿង ខង ទិណោ័ះ ឡាំ មប កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ កា អ៊ែ មប ម៉ាស ប៉្រាក់ ឡាក់ អ៊ែ អ្យក់ ឡឹង សុនសាត ទិណោ័ះ ឡាក់ អ៊ែ តាកូះ សាណ័ះ ពែ ");
INSERT INTO tpu_vpl VALUES ("S28_12","011_8_12","2SA","8","12","12","ឃឺ សុនសាត ស៊ីរី  សុនសាត ម៉ូអាប់ សុនសាត អាម៉ូន សុនសាត ភីលីសាទីន សុនសាត អាម៉ាឡេក លូ រ៉ាស អំប៉ាស អ៊ែ អ្យក់ ឡឹង ហាដាដេស៊ើរ គន សាដាច់ រេហូប ឡាក់ សាដាច់ មឿង សូបា។ ");
INSERT INTO tpu_vpl VALUES ("S28_13","011_8_13","2SA","8","13","13","ប៉ាគ់ សាដាច់ ដាវីត សឹត ឡឹង តាកូះ លូ សុនសាត ស៊ីរី អ៊ែ ឡាំ តាកូះ លូ សុនសាត អេដំ ប៉ាន់តោ័ អន់ឌែ ១៨.០០០ ដូវ ប៉ាគ់ ក្លូះ ប៉ានឹម កាន់ហ្នាច។ សារ ណោះ ប៉្រគ័ អន់ អ៊ែ ហ៊ែង លៅ លែង សិច ធែម ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("S28_14","011_8_14","2SA","8","14","14","សុនសាត អេដំ កា មប ឡាកោ អន់ សាដាច់ ដាវីត រ៉ាំងហៃ អ៊ែ កា ប៉្រើ តាហាន រ៉ាំងហៃ ពឹង ប៉ាថេត អេដំ ទិណោ័ះ។ ប‌៉្រ័ះ ប៊កកាតយ័ តង័ សាដាច់ ដាវីត គ្រឹប សារ។ ");
INSERT INTO tpu_vpl VALUES ("S28_15","011_8_15","2SA","8","15","15","ដាវីត ប៉្រគ័ សាដាច់ រ៉ាំងហៃ ប៉ាថេត អ៊ីស្រាអ៊ែល ទិណោ័ះ ទឹប តាត់ស៊ិន សារ ដាគ់ ត្រង់។ ");
INSERT INTO tpu_vpl VALUES ("S28_16","011_8_16","2SA","8","16","16","យ៉ូអាប់ គន យ៉ាគ់ សេរូយ៉ា ប៉្រគ័ ម៉ៃគ ណាំផា តាហាន។ យេហូសាផាត គន វគ័ អាហ៊ីលូត អ៊ែ ច្រាគ់ រ៉ាន់ដាប់ សារ សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("S28_17","011_8_17","2SA","8","17","17","សាដុក គន វគ័ អាហ៊ីទូប លូ អាហ៊ីម៉ាឡេក គន វគ័ អាបៀថារ ប៉្រគ័ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ។ សេរ៉ាយ៉ា ច្រាគ់ សត់ត្រា កា សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("S28_18","011_8_18","2SA","8","18","18","បេណាយ៉ា គន វគ័ យេហូយ៉ាដា ប៉្រគ័ ម៉ៃគ ណាំផា ក្រុំ កេរេធីម លូ ក្រុំ ពេលេធីម ។ កាប៉ាច់ គន កាម៉ាក័ សាដាច់ ដាវីត ទិណោ័ះ ប៉្រគ័ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ។ ");
INSERT INTO tpu_vpl VALUES ("S29_1","011_9_1","2SA","9","1","1","រ៉ាំងវ៉ាង ណោះ សាដាច់ ដាវីត អំប៉ញ់ ផា «ញ៉ា អ្វៃ ទី ដេល ប គន សោ សូល អ្វៃ រ៉ីស? អាញ់ ប៉ិច ប៉្រគ័ ដាគ់ កា អ៊ែ ញន កាចាំង តោរ កា យ៉ូណាថាន»។ ");
INSERT INTO tpu_vpl VALUES ("S29_2","011_9_2","2SA","9","2","2","ទី ទុច សាដាច់ សូល ម៉ោញ ដូវ សិច ស៊ីបា។ ពូ រ៉ះ កា អ៊ែ ប៉្រើ ឡាំ ប៉ាគ់ ចារ សាដាច់ ដាវីត សាដាច់ ដាវីត កា អំប៉ញ់ ផា «ញ៉ា អីស ហង ប សិច ស៊ីបា ?» អ៊ែ តើល ផា «អឺះ ពឹ តាំងឡា អាញ់ អា ហង»។ ");
INSERT INTO tpu_vpl VALUES ("S29_3","011_9_3","2SA","9","3","3","សាដាច់ ដាវីត កា អំប៉ញ់ ណាវ្គ ផា «ញ៉ា ផូង័ វ៉ាច់ សាដាច់ សូល ទី បក់ ពឿ អ្វៃ រ៉ីស ដេល ប ? អាញ់ ប៉ិច ប៉្រគ័ ដាគ់ កា អ៊ែ កាខាក់»។ ស៊ីបា តើល ផា «អ្វៃ ម៉ោញ ដូវ គន កាម៉ាក័ យ៉ូណាថាន សិច អ៊ែ មេភីបូស៊ែត អ៊ែ រ៉ាំងវែន ជុង ទិ ពៀរ»។ ");
INSERT INTO tpu_vpl VALUES ("S29_4","011_9_4","2SA","9","4","4","សាដាច់ ដាវីត អំប៉ញ់ ណាវ្គ ផា «អ៊ែ អ្វៃ ប៉ាគ់ ចំ ?» ស៊ីបា រ៉ះ ផា «អ៊ែ អ្វៃ ប៉ាគ់ ហី ម៉ាគៀរ គន វគ័ អាមៀល ប៉ាគ់ មឿង ឡូដេបារ»។ ");
INSERT INTO tpu_vpl VALUES ("S29_5","011_9_5","2SA","9","5","5","កេះណោះ សាដាច់ ដាវីត ប៉្រើ ពូ ឡាំ អ្យក់ មេភីបូស៊ែត ឡឹង ហី ម៉ាគៀរ អ្វៃ ប៉ាគ់ មឿង ឡូដេបារ។ ");
INSERT INTO tpu_vpl VALUES ("S29_6","011_9_6","2SA","9","6","6","កេះណោះ មេភីបូស៊ែត គន យ៉ូណាថាន សោ សាដាច់ សូល ឡាំ ប៉ាគ់ ចារ សាដាច់ ដាវីត អ៊ែ កា កុប កល់ ទឹះ តេះ សាំប‌៉័ះ សាដាច់ ដាវីត។ កេះណោះ សាដាច់ ដាវីត អំប៉ញ់ អ៊ែ ផា «អីស ហង ប សិច មេភីបូស៊ែត ?» អ៊ែ តើល ផា «អឺះ ពឹ តាំងឡា អាញ់ អា ហង»។ ");
INSERT INTO tpu_vpl VALUES ("S29_7","011_9_7","2SA","9","7","7","សាដាច់ ដាវីត កាប ផា «ជែ អ្យូគ ហង អាញ់ ចឹង ប៉្រគ័ ដាគ់ ខង អាញ់ កាចាំង កា ពឹ អីស យ៉ូណាថាន។ អាញ់ ចឹង មប តេះ ម៉ះ សាដាច់ សូល ឡាក់ វគ័ អីស អន់ ទិ កា អីស ទឹប អីស ចឹង សា សាណា អន់ឌូ លូ អាញ់ រ៉ប់ ដារ់»។ ");
INSERT INTO tpu_vpl VALUES ("S29_8","011_9_8","2SA","9","8","8","មេភីបូស៊ែត កា សាំប‌៉័ះ សាដាច់ ដាវីត ទឹប កាប ផា «អាញ់ ប៉ាណូស នីចម័ បះ អីស ដាគ់ ពុត កា អាញ់ នីអៀ ? អាញ់ ពៀប ឡាក់ កា សូ តោ័»។ ");
INSERT INTO tpu_vpl VALUES ("S29_9","011_9_9","2SA","9","9","9","កេះណោះ សាដាច់ ដាវីត អើ ស៊ីបា ឡាក់ ទុច សាដាច់ សូល លូ រ៉ះ ផា «អាញ់ មប ប៉ាដក់ ប៉ាជៀ សាដាច់ សូល លូ ប៉ាដក់ ប៉ាជៀ ផូង័ វ៉ាច់ អ៊ែ ទិណោ័ះ អន់ កា សោ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S29_10","011_9_10","2SA","9","10","10","ហគ់ អីស ទឹប គន សោ អីស លូ ទុច អីស ប៉ាណាំ គួប ប៉្រគ័ ម៉ីរ ជែក ពៀ ភែ អន់ កា មេភីបូស៊ែត ម៉ាគ់ អ៊ែ ទី សាណា សា។ ហះកា មេភីបូស៊ែត ចឹង សា សាណា អន់ឌូ លូ អាញ់ រ៉ប់ ដារ់ លើយ»។ ស៊ីបា ទី គន កាម៉ាក័ ១៥ ដូវ លូ ទុច អ៊ែ ២០ ដូវ។ ");
INSERT INTO tpu_vpl VALUES ("S29_11","011_9_11","2SA","9","11","11","ស៊ីបា រ៉ះ កា សាដាច់ ផា «អឺះ ពឹ តាំងឡា អាញ់ ចឹង ប៉្រគ័ ពួយ ប៉ានឹរ អីស ទិណោ័ះ»។ មេភីបូស៊ែត កា សា សាណា អន់ឌូ លូ សាដាច់ ដាវីត រ៉ប់ ដារ់ ឡាក់ កា គន សោ សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("S29_12","011_9_12","2SA","9","12","12","មេភីបូស៊ែត ទី គន កាម៉ាក័ ម៉ោញ ដូវ សិច អ៊ែ មីកា។ ហី ក្រាន ស៊ីបា ទិណោ័ះ កា កេះ ទុច មេភីបូស៊ែត។ ");
INSERT INTO tpu_vpl VALUES ("S29_13","011_9_13","2SA","9","13","13","ញន កា មេភីបូស៊ែត សា សាណា អន់ឌូ អូ សាដាច់ ដាវីត រ៉ប់ ដារ់ អ៊ែ កា អ្វៃ ពឹង មឿង យេរូសាឡឹម។ អ៊ែ ណោះ រ៉ាំងវែន ជុង ទិ ពៀរ។ … ");
INSERT INTO tpu_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","ម៉ោញ សាណាំ ឡឹង ណោះ ឃឺ ត្រគ់ ថុន ឡាក់ សាដាច់ ទិណោ័ះ ឃើយ ឡាំ តាកូះ ផះ ណោះ សាដាច់ ដាវីត ប៉្រើ យ៉ូអាប់ ទឹប តាហាន អ៊ីស្រាអ៊ែល ទិណោ័ះ ឡាំ តាកូះ លូ សុនសាត អាម៉ូន។ អន់ឌែ កា វ៉ិង ជុំ មឿង រ៉ាបាត ហះកា សាដាច់ ដាវីត អ្វៃ ប៉ាគ់ មឿង យេរូសាឡឹម។ ");
INSERT INTO tpu_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","ប៉ាគ់ ដារ់ អន់តីគ ផះ កាង៉ាច កេះ សាដាច់ ដាវីត អ្យូវ ឡឹង តៃប ផះ ណោះ អ៊ែ ហាវ ពឹង អន់តល័ ហី។ អ៊ែ ហៃ ប៉ប័ អង់កាន់ ម៉ោញ ដូវ ផះ អ្វៃ ហុំ អង់កាន់ ណោះ ឡាយ៉ាម័ ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","អ៊ែ ប៉្រើ ពូ ឡាំ អំប៉ញ់ ឡឹង អង់កាន់ ណោះ ផះ ណោះ ទី ប៉ាណូស ម៉ោញ រ៉ះ ផា «សិច អ៊ែ បាតសេបា គន វគ័ អេលៀម ក្លោ អ៊ែ អ៊ូរី ឡាក់ សុនសាត ហេត»។ ");
INSERT INTO tpu_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","សាដាច់ ដាវីត ប៉្រើ ពូ ឡាំ អ្យក់ អង់កាន់ ណោះ ឡាំ ប៉ាគ់ ចារ អ៊ែ អ៊ែ កា តៃប លូ អង់កាន់ ណោះ កេះណោះ អង់កាន់ ណោះ សឹត ប៉ាគ់ ហី អ៊ែ ទៅ ណាវ្គ។ ផះ សាដាច់ ដាវីត តៃប លូ អ៊ែ អ៊ែ អង់ក័ះ សៃន រ៉ាវ ឡាកោ ឡៃង ឡឹង ជឹរ អញ់ជុ។ ");
INSERT INTO tpu_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","បាតសេបា កា ឡាកោ គៀម អ៊ែ ប៉្រើ ពូ ឡាំ រ៉ះ កា សាដាច់ ដាវីត ផា «អាញ់ ឡាកោ គៀម កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","កេះណោះ សាដាច់ ដាវីត ប៉្រើ ពូ ឡាំ រ៉ះ កា យ៉ូអាប់ ផា «ហគ់ ប៉្រើ អ៊ូរី សុនសាត ហេត ពឹះ ប៉ាគ់ អាញ់»។ យ៉ូអាប់ កា ប៉្រើ អ៊ូរី ឡាំ ប៉ាគ់ ចារ សាដាច់ ដាវីត។ ");
INSERT INTO tpu_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","ប៉ាគ់ អ៊ូរី ឡាំ ទឹល កេះ សាដាច់ ដាវីត អំប៉ញ់ ឡឹង សារ យ៉ូអាប់ លូ ឡឹង កាំឡាំង តាហាន ទឹប សារ តាកូះ ណោះ នីចម័ អន់ដា។ ");
INSERT INTO tpu_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","កេះណោះ ដាវីត កាប លូ អ៊ូរី ផា «ហគ់ អីស សឹត ប៉ាគ់ ហី អ្វៃ អន់ឌូ លូ ខាប់ខួ អីស ពិ»។ អ៊ូរី ចាក ឡាច់ ឡឹង ហី សាដាច់ កេះណោះ សាដាច់ កា ប៉្រើ ពូ អ្យក់ កាណាគ័ ឡាំ ជឹន អន់តីគ។ ");
INSERT INTO tpu_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","ហះកា អ៊ូរី អ៊ែ អូ សឹត ប៉ាគ់ ហី អ៊ែ ទៅ អុះ ឃឺ អ៊ែ តៃប លូ មួត ញ៉ាម ហី ហះ អំប៉ារ ហី សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","ពូ រ៉ះ កា សាដាច់ ដាវីត ផា «អ៊ូរី អូ សឹត ប៉ាគ់ ហី អ៊ែ អុះ»។ ដាវីត កា អំប៉ញ់ អ៊ូរី ផា «អីស អង់ក័ះ សឹត ឡឹង ចាំងហាយ្គ ញ៉ា ត្រគ់ អីស អូ សឹត ប៉ាគ់ ហី អីស ?» ");
INSERT INTO tpu_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","អ៊ូរី កា តើល អ៊ែ ផា «ហ៊ីប ប‌៉្រ័ះ ប៊កកាតយ័ លូ តាហាន អ៊ីស្រាអ៊ែល ទឹប តាហាន យូដា ទឹប យ៉ូអាប់ ឡាក់ ម៉ៃគ តាំងឡា អាញ់ កា តៃប ពឹង រ៉ាណើះ ដេល។ ទឹល នីណោ័ះ ផា អាញ់ អ្វៃ ប៉ាគ់ ហី អៃត សា លូ តៃប ក្រក់ កាម៉ាញ់ នីចម័ ចឹង ត្រគ់ ? អាញ់ រ៉ះ តាទឹច ឡាក់ កា អីស អ្វៃ រ៉ីស ដេល អាញ់ អូ ប៉្រគ័ នីណោ័ះ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","ទឹល នីណោ័ះ ដាវីត កាប ផា «ដារ់ អា អីស អ្វៃ ហះ អា ហង ពិ ប៉ាគ់ កាំលឺ ទៀ អាញ់ ប៉្រើ អីស សឹត»។ អ៊ូរី កា អ្វៃ ហះ មឿង យេរូសាឡឹម ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","ប៉ាគ់ កាង៉ាច សាដាច់ ដាវីត អើ អ៊ែ អៃត សា ទឹប ប៉ាំងខំ អ៊ែ អៃត តាពែ អន់ ប៉ាញឹល ឡូត។ ប៉ាគ់ កាម៉ាំង អ៊ូរី កា ឡាំ តៃប អន់ឌូ លូ មួត ញ៉ាម អំប៉ារ ហី ទៅ ណាវ្គ អ៊ែ អូ សឹត ប៉ាគ់ ហី អ៊ែ ទៅ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","តារ កាំលឺ សាដាច់ ដាវីត ច្រាគ់ សត់ត្រា ប៉ាហ្យើ កា យ៉ូអាប់ ពឹង អ៊ូរី។ ");
INSERT INTO tpu_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","កាណុង សត់ត្រា ណោះ អ៊ែ ច្រាគ់ ផា «ប៉្រើ អ៊ូរី អ្វៃ ប៉ាគ់ ង៉ីរ ត្រង់ ហះ ចារ ពូ តាកូះ កេះណោះ ប៉្រើ កាំឡាំង តាហាន ឡាច់ អន់ អ៊ែ អ្វៃ ដូវ អ៊ែ ហះ ណោះ ម៉ាគ់ តាម៉ឺរ ប៉ាន់តោ័ អ៊ែ»។ ");
INSERT INTO tpu_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","យ៉ូអាប់ កា តារ័ ហៃ មឿង អន់ឌែ វ៉ិង ណោះ កេះណោះ ប៉្រើ អ៊ូរី អ្វៃ ហះ ចារ ឡាក់ អ៊ែ អ្លុ អន់តគ់ ផា ទី តាម៉ឺរ កេង ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","មួត តាហាន ពឹង មឿង ណោះ កា ឡាច់ ឡាំ តាកូះ លូ តាហាន យ៉ូអាប់។ អន់ឌែ កា ប៉ាន់តោ័ តាហាន សាដាច់ ដាវីត អន់ដា អ៊ូរី សុនសាត ហេត កា តោ័ ហះ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","កេះណោះ យ៉ូអាប់ ប៉្រើ ពូ ឡាំ រ៉ះ កា សាដាច់ ដាវីត ឡឹង សារ តាកូះ ទិណោ័ះ ");
INSERT INTO tpu_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","អ៊ែ កាប លូ បក់ ឡាំ ណោះ ផា «ប៉ាគ់ អីស រ៉ះ ឡឹង សារ តាកូះ ទិណោ័ះ កេះ ទិ កេះ ");
INSERT INTO tpu_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","ផានែវ សាដាច់ អឺក លូ កាប ផា \"ខ ញ៉ា បះ អន់ដីស ម៉ុត តាកូះ ក្យាម័ ទ្រួក មឿង ? ញ៉ា អន់ដីស អូ អ្លុ ប កា តាម៉ឺរ ចឹង ប៉ាញ់ ជឹរ ឡឹង ទ្រួក ? ");
INSERT INTO tpu_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","ញ៉ា អន់ដីស អូ អ្លុ ប អាប៊ីម៉ាឡេក គន វគ័ យេរូបាល តោ័ ប៉ាគ់ មឿង ថេបេះ ពែ ញន កា អង់កាន់ ម៉ោញ ដូវ ប៉ាឡិ ជឹរ អំហ្មោ តីស ឡឹង ទ្រួក ត្រគ់ ពឹង អ៊ែ ? ទឹល នីណោ័ះ ខ ញ៉ា បះ អន់ដីស ម៉ុត ឡាំ ក្យាម័ ទ្រួក មឿង នីណោ័ះ ?\" អីស ត្រគ់ រ៉ះ កា អ៊ែ ផា \"អ៊ូរី សុនសាត ហេត កា តោ័ ដេល\"»។ ");
INSERT INTO tpu_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","បក់ ណោះ កា ឡាំ រ៉ះ កា សាដាច់ ដាវីត ឡឹង សារ ទិណោ័ះ ឡាក់ កា យ៉ូអាប់ អន់តគ់ រ៉ះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","បក់ ណោះ រ៉ះ កា សាដាច់ ដាវីត ផា «មួត តាម៉ឺរ អន់ឌែ កេង ក្វា ឡឹង ញឹន អន់ឌែ ឡាច់ ពឹះ តាកូះ លូ ញឹន ប៉ាគ់ ឡីង។ ប៉ាគ់ អន់តីគ ញឹន តាយ៉ិប ទ្រុះ អន់ឌែ ណាវ្គ លើយ ទឹល ប៉ាគ់ អំប៉ារ ទ្រួក មឿង។ ");
INSERT INTO tpu_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","ហះកា ផះ ណោះ មួត តាម៉ឺរ ប៉ាញ់ ជឹរ ឡឹង ទ្រួក តាម៉ង់ ប៉ាគ់ ញឹន ប៉្រគ័ អន់ កា តាហាន អន់ដា តោ័។ អ៊ូរី សុនសាត ហេត ណោះ កា តោ័ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","សាដាច់ ដាវីត រ៉ះ កា បក់ ពឹះ រ៉ះ ណោះ ផា «ហគ់ អីស សឹត កាប ប៉ាឡោម ពុត យ៉ូអាប់ នីអៀ \"ជែ អុក ពុត ញន កា សារ ណោះ ខង ផះ តាកូះ តាហាន ចឹង តោ័ អន់ដា។ ហគ់ ខំ តាកូះ អន់ កាខាក់ ក្វា ឡឹង អា ណាវ្គ ទឹប ថាំឡាយ មឿង ណោះ អន់ ទិ ឡូត\"»។ ");
INSERT INTO tpu_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","ប៉ាគ់ បាតសេបា អ្លុ អន់តគ់ ផា ក្លោ អ៊ែ តោ័ កេះ អ៊ែ កា ញ៉ាំ សោក កា ក្លោ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","ប៉ាគ់ គ្រឹប ម៉ាំង ប៉ាទ្រូ កេះ សាដាច់ ដាវីត ប៉្រើ ពូ ឡាំ អ្យក់ បាតសេបា ពឹះ អ្វៃ ប៉ាគ់ ហី អ៊ែ អ៊ែ កា ទី បាតសេបា ឡៃង ឡឹង ណោះ បាតសេបា អ្វៃ ហាអុញ កើត គន កាម៉ាក័ លូ សាដាច់ ដាវីត។ ហះកា សារ សាដាច់ ដាវីត ប៉្រគ័ ណោះ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","ឡៃង ឡឹង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ រ៉ាគឹយ ប‌៉្រ័ះ សិច ណាថាន ឡាំ កាប កា សាដាច់ ដាវីត។ អ៊ែ រ៉ះ ផា «ពឹង ស្រុក ម៉ោញ ទី ប៉ាណូស ពៀរ ដូវ ម៉ោញ ដូវ ប‌៉្រ័ះ ប៉ាត្រង័ ម៉ោញ ដូវ ណាវ្គ ថុក ញ៉ាក ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","បក់ ប‌៉្រ័ះ ប៉ាត្រង័ ណោះ ទី រ៉ក់ លូ ចៀម អៀង កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","កាប៉ាច់ បក់ ថុក ញ៉ាក ទី គន ចៀម យ៉ង់ ដឹង ម៉ោញ ឡក់ ឡាក់ អ៊ែ តាច់ រង អន់ អ្វៃ អន់ឌូ លូ គន អ៊ែ លូ អន់ សា សាណា ពឹង អង់គៀន អ៊ែ ទៅ ទឹប អន់ អៃត ទៀក ពឹង ចក អន់ឌូ លូ អ៊ែ ដេល លូ អ៊ែ តៃប ក្រក់ គន ចៀម ណោះ។ អ៊ែ ប៉ិច កា គន ចៀម ណោះ ឡាក់ កា គន អង់កាន់ អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","ដារ់ ម៉ោញ ទី អំហ៊្មយ ពឹះ ឡឹង ចាំងហាយ្គ ឡាំ ប៉ាគ់ ហី បក់ ប‌៉្រ័ះ ប៉ាត្រង័ ណោះ ហះកា បក់ ប‌៉្រ័ះ ប៉ាត្រង័ ណោះ អ៊ែ ហ្វាច ខាក់ អ្យក់ ចៀម លើ រ៉ក់ ម៉ះ អ៊ែ ពុះ ប៉្រគ័ សាណា អន់ កា អំហ៊្មយ អ៊ែ អ្យក់ គន ចៀម បក់ ថុក ញ៉ាក ណោះ ពុះ ប៉្រគ័ សាណា អន់ កា អំហ៊្មយ ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","សាដាច់ ដាវីត អឺក ខាក់ កា បក់ ប៉ាត្រង័ ណោះ អ៊ែ កាប លូ វគ័ ណាថាន ផា «អាញ់ រ៉ះ តាទឹច ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ រ៉ីស ដេល ប៉ាណូស ប៉្រគ័ យច នែវ ណោះ ត្រគ់ តោ័ ហង។ ");
INSERT INTO tpu_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","អ៊ែ ត្រគ់ ស៊ង គន ចៀម ណោះ ម៉ោញ ស៊ង ប៉្វាន់ ខង អ៊ែ ប៉្រគ័ នែវ ណោះ អូ ទី ពុត តាប៉ាប តាប៉ុន ឡក់»។ ");
INSERT INTO tpu_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","វគ័ ណាថាន កាប កា សាដាច់ ដាវីត ផា «ប៉ាណូស ណោះ ឃឺ អីស អា ហង ! ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល កាប ផា \"អាញ់ រ៉ើស អីស ប៉្រើ ប៉្រគ័ សាដាច់ សុនសាត អ៊ីស្រាអ៊ែល កេះ អាញ់ កា តង័ អីស អន់ រ៉ាវ៉ាច់ ឡឹង តី សូល ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","អាញ់ មប ហី សាដាច់ លូ កាម៉ាញ់ សូល ទិណោ័ះ កា អីស កេះ។ អាញ់ កា អន់ អីស រ៉ាំងហៃ សុនសាត អ៊ីស្រាអ៊ែល លូ មួត យូដា ដេល។ ផានែវ អីស បើ សាណិ ពុត អាញ់ ចឹង ធែម ហ៊្លត ឡឹង អា ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","ខ ញ៉ា បះ អីស បឺង៉ាយ ប៉ានឹរ អាញ់ នីអៀ ទឹប ប៉្រគ័ សារ ឡាក់ យច ពុត អាញ់ ? អីស មប អ៊ូរី សុនសាត ហេត អន់ កា សុនសាត អាម៉ូន ប៉ាន់តោ័ កេះណោះ អ្យក់ កាម៉ាញ់ អ៊ែ ទី កា អីស ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","ទឹល នីណោ័ះ ខាប់ខួ អីស ចឹង ទី សារ ចុនចៃ លើយៗ ខង អីស បឺង៉ាយ អាញ់ លូ អ្យក់ កាម៉ាញ់ អ៊ូរី ប៉្រគ័ កាម៉ាញ់ អីស\"។ ");
INSERT INTO tpu_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","ប‌៉្រ័ះ ប៊កកាតយ័ កាប ផា \"អាញ់ ចឹង ប៉្រគ័ អន់ អីស ទី សារ អូ ដាគ់ កើត ឡាច់ ឡឹង បក់ អ្វៃ ពឹង ហី ក្រាន អីស ទៅ។ អាញ់ ចឹង អ្យក់ មួត កាម៉ាញ់ អីស មប អន់ កា ប៉ាណូស ឡាក់ ក្យាម័ អីស។ អ៊ែ ចឹង តៃប លូ កាម៉ាញ់ អីស ពឹង ចារ តាតារ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","អីស ប៉្រគ័ សារ អូ ដាគ់ ណោះ ពឹង ចារ ម៉ាម៉ាំង ចារ សាគឹម កាប៉ាច់ អាញ់ ចឹង ប៉្រគ័ សារ ណោះ កា អីស ពឹង ចារ តាតារ អន់ សុនសាត អ៊ីស្រាអ៊ែល ទិឌូ ប៉ប័\"»។ ");
INSERT INTO tpu_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","សាដាច់ ដាវីត កាប លូ វគ័ ណាថាន ផា «អាញ់ ប៉្រគ័ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ កេះ»។ វគ័ ណាថាន កាប ផា «ប‌៉្រ័ះ ប៊កកាតយ័ អូ អ្យក់ យ៉ូ អីស អីស កា អូ តោ័ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","ហះកា ញន កា អីស ប៉្រគ័ សារ យច តីស បឺង៉ាយ ប‌៉្រ័ះ ប៊កកាតយ័ កាខាក់ បះ គន អីស ឡាក់ អង់ក័ះ កើត ណោះ ត្រគ់ តោ័ តាទឹច ហង»។ ");
INSERT INTO tpu_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","កេះណោះ វគ័ ណាថាន កា សឹត ប៉ាគ់ ហី អ៊ែ ទៅ។ ឡៃង ឡឹង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ គន ឡាក់ កាម៉ាញ់ អ៊ូរី ប៉ាំងកើត លូ សាដាច់ ដាវីត ណោះ កើត អីគ ព្លុ។ ");
INSERT INTO tpu_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","សាដាច់ ដាវីត ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ កា គន អ៊ែ ណោះ លូ កំ អូ សា សាណា ទឹប អ៊ែ តៃប ពឹង តេះ ទឹល តារ។ ");
INSERT INTO tpu_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","មួត ក្រាគ់ តាំងកង់ កាណុង ហី សាដាច់ ឡោម ប៉្រើ អ៊ែ អ្យូវ ឡឹង តេះ ហះកា អ៊ែ អូ ចៃ អុះ លូ អូ ចៃ សា សាណា អន់ឌូ អូ អន់ឌែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","ប៉ាគ់ ទឹល តាំប៉ើះ ដារ់ គន អ៊ែ ណោះ កា តោ័។ មួត ប៉្រគ័ កាន កា អ៊ែ អូ ខឹន រ៉ះ សារ ណោះ កា អ៊ែ អុះ ខង អន់ឌែ កាកាប លូ គួប អន់ឌែ ផា «ផះ គន អ៊ែ អ្វៃ រ៉ីស ពិន កាប លូ អ៊ែ ញ៉ាង កា អ៊ែ អូ សាំយ៉ាំង ពិន សាំ សាឡង់ កា គន អ៊ែ តោ័ ទឹល នីណោ័ះ ពិន ត្រគ់ រ៉ះ នីចម័ ភឿ ជែ អន់ អ៊ែ ប៉្រគ័ កា ឡាកោ អ៊ែ ទៅ»។ ");
INSERT INTO tpu_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","ប៉ាគ់ សាដាច់ ដាវីត ហៃ ប៉ប័ មួត ប៉្រគ័ កាន កាប កាហៀច គួប អន់ឌែ អ៊ែ ឃឹត ផា គន អ៊ែ តោ័ កេះ អ៊ែ កា អំប៉ញ់ អន់ឌែ ផា «គន អាញ់ តោ័ កេះ ប ?» អន់ឌែ តើល ផា «អឺះ គន អីស ណោះ តោ័ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","កេះណោះ សាដាច់ ដាវីត កា អ្យូវ ឡឹង តេះ ឡាំ ហុំ ឡាប សាប៊ូ បោផូវ ទឹប ផ្លេះ ខោ អាវ កេះណោះ ម៉ុត ពឹង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ភឿ សាំប‌៉័ះ ប‌៉្រ័ះ។ ប៉ាគ់ សឹត ឡឹង ណោះ អ៊ែ ប៉្រើ ពូ អ្យក់ សាណា កា អ៊ែ សា។ ");
INSERT INTO tpu_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","មួត ប៉្រគ័ កាន កា អំប៉ញ់ អ៊ែ ផា «ខ ញ៉ា អីស ប៉្រគ័ នីអៀ ? ផះ គន អីស អ្វៃ រ៉ីស អីស ញ៉ាំ សោក ទឹប កំ អូ សា សាណា។ ហះកា ប៉ាគ់ គន អីស តោ័ អីស សា សាណា ឡគ»។ ");
INSERT INTO tpu_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","សាដាច់ ដាវីត តើល ផា «ផះ គន អាញ់ អ្វៃ រ៉ីស អាញ់ ញ៉ាំ សោក កំ អូ សា សាណា សាម៉គ័ ផា ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង តាប៉ាប តាប៉ុន កា អាញ់ លូ អន់ គន អ្វៃ រ៉ីស។ ");
INSERT INTO tpu_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","កិញអៀ អា គន អាញ់ តោ័ កេះ អាញ់ ចឹង កំ កា សាណា ប៉្រគ័ ញ៉ា ណាវ្គ ? អាញ់ អូ អ្លុ ប៉្រគ័ អន់ អ៊ែ រ៉ីស សឹត ណាវ្គ អុះ។ អាញ់ ចឹង ឡាំ ប៉ាគ់ ចារ អ៊ែ អូ ត្រគ់ អ៊ែ អុះ សឹត ប៉ាគ់ ចារ អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","សាដាច់ ដាវីត កា អ្វៃ អង់រ៉ើង កាម៉ាញ់ អ៊ែ បាតសេបា កេះណោះ អ៊ែ តៃប លូ កាម៉ាញ់ អ៊ែ។ បាតសេបា កា ទី គន កាម៉ាក័ អន់ សិច ផា សាឡូម៉ូន។ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ិច កា សាឡូម៉ូន ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","ប‌៉្រ័ះ ប៉្រើ វគ័ ណាថាន ឡាំ រ៉ះ កា សាដាច់ ដាវីត ឡឹង សារ ណោះ។ អ៊ែ កា អន់ សិច ផា យេឌីឌីយ៉ា ញន កា ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ។ … ");
INSERT INTO tpu_vpl VALUES ("S224_1","011_24_1","2SA","24","1","1","ឡៃង ឡឹង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ អឺក កា សុនសាត អ៊ីស្រាអ៊ែល ណាវ្គ។ អ៊ែ អន់ សាដាច់ ដាវីត ប៉្រគ័ យច លូ អន់ឌែ លូ ប៉្រើ ច្រាគ់ ចំលួន ប៉ាសុន អ៊ីស្រាអ៊ែល លូ ប៉ាសុន យូដា។ ");
INSERT INTO tpu_vpl VALUES ("S224_2","011_24_2","2SA","24","2","2","ផះ ណោះ សាដាច់ ដាវីត ប៉្រើ វគ័ យ៉ូអាប់ ឡាក់ ម៉ៃគ ណាំផា តាហាន ឡាក់ អ្វៃ លូ អ៊ែ អ៊ែ កាប ផា «ហគ់ អីស ចាក គ្រឹប ចារ ផូង័ វ៉ាច់ សុនសាត អ៊ីស្រាអ៊ែល ទិណោ័ះ ឃឺ ឡឹង មឿង ដាន់ លើយ ទឹល មឿង បៀសេបា ភឿ ច្រាគ់ ចំលួន ប៉ាសុន ខង អាញ់ ប៉ិច កា អ្លុ អន់តគ់ ផា ទី ចំលួន ប៉ុប ចំ»។ ");
INSERT INTO tpu_vpl VALUES ("S224_3","011_24_3","2SA","24","3","3","វគ័ យ៉ូអាប់ កាប លូ សាដាច់ ផា «អឺ ពឹ តាំងឡា អន់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អីស អន់ ធែម ចំលួន ប៉ាសុន អន់ អៀង ឡឹង អា ណាវ្គ ម៉ោញ រ៉ាយ៉ាំង ទង ទឹប អន់ អីស តាំងឡា ហៃ ប៉ប័ ដេល។ ហះកា ខ ញ៉ា បះ អីស ប៉ិច កា ច្រាគ់ ចំលួន ប៉ាសុន នីអៀ ?» ");
INSERT INTO tpu_vpl VALUES ("S224_4","011_24_4","2SA","24","4","4","ញន កា សាដាច់ ប៉ាំងខំ តាឡាម័ វគ័ យ៉ូអាប់ លូ ម៉ៃគ តាហាន អន់ទៀគៗ អន់ឌែ អូ ខឹន ប៉ាគែក អុះ។ អន់ឌែ ប៉ាណាំ គួប ឡាច់ ឡឹង ចារ សាដាច់ ភឿ ឡាំ ច្រាគ់ ចំលួន ប៉ាសុន អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("S224_5","011_24_5","2SA","24","5","5","អន់ឌែ ឃ្លង ទៀក ទ្រូង យដាន់ អន់ឌែ កា ប៉ាន់ដា ច្រាគ់ ចំលួន ប៉ាសុន ប៉ាគ់ មឿង អារ៉ូអ៊ើរ លូ ប៉ាគ់ មឿង ឡាក់ អ្វៃ ហះ អន់តិគ័ ក្លូះ ប៉ានឹម ពឹង ព្រី ទៀក ផូង័ កាត ក្យាម័ តេះ យ៉ាស៊ើរ។ ");
INSERT INTO tpu_vpl VALUES ("S224_6","011_24_6","2SA","24","6","6","កេះណោះ អន់ឌែ ឡាំ ទឹល ប៉ាគ់ ព្រី ប៉ានឹម កាឡាត លូ មឿង កាដេះ ពឹង ព្រី ទៀក សុនសាត ហេត កេះណោះ ឡាំ ប៉ាគ់ មឿង អ៊ីយ៉ូន លូ ស្រុក តេះ ក្យាម័ មឿង ស៊ីដូន។ ");
INSERT INTO tpu_vpl VALUES ("S224_7","011_24_7","2SA","24","7","7","អន់ឌែ កា ចាក ឡាំ ទឹល ទ្រួក មឿង ទីរ៉ូះ លូ មឿង សុនសាត ហេវី លូ សុនសាត កាណាន អន់ទៀគៗ ណាវ្គ កេះណោះ ចាក ឡាំ លើយ ប៉ាគ់ មឿង បៀសេបា ឡាក់ អ្វៃ ពឹង ព្រី ទៀក ផូង័ យូដា គែង តាបូង។ ");
INSERT INTO tpu_vpl VALUES ("S224_8","011_24_8","2SA","24","8","8","ឡៃង ឡឹង អន់ឌែ ច្រាគ់ ចំលួន ប៉ាសុន គ្រឹប ស្រុក កេះ អន់ឌែ កា វ៉ីល សឹត ប៉ាគ់ មឿង យេរូសាឡឹម ណាវ្គ។ អន់ឌែ ប៉្រគ័ ង៉ារ ណោះ ទុញ ៩ ខៃ ២០ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("S224_9","011_24_9","2SA","24","9","9","វគ័ យ៉ូអាប់ រ៉ះ ចំលួន ប៉ាសុន កា សាដាច់។ អ៊ីស្រាអ៊ែល ទី ៨០០.០០០ ដូវ ឡាក់ អ្លុ តាកូះ យូដា កា ទី ៥០០.០០០ ដូវ។ ");
INSERT INTO tpu_vpl VALUES ("S224_10","011_24_10","2SA","24","10","10","ឡៃង ឡឹង ច្រាគ់ ចំលួន ប៉ាសុន សាដាច់ ដាវីត អ្វះ ឡាកោ ខាក់ កេះណោះ រ៉ះ លូ ប‌៉្រ័ះ ប៊កកាតយ័ ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័  អាញ់ យច ខាក់ កេះ កិញអៀ អា ប៉រ់ អីស ជែ អ្យក់ យ៉ូ សារ យច អាញ់។ អាញ់ ប៉្រគ័ ឡាក់ កា ប៉ាណូស អូ ហ្លង់ អូ ហ្លី»។ ");
INSERT INTO tpu_vpl VALUES ("S224_11","011_24_11","2SA","24","11","11","ប៉ាគ់ កាំលឺ ដារ់ តាយ៉ាង័ ផះ សាដាច់ ដាវីត អ្យូវ ឡឹង តៃប ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ រ៉ាគឹយ អ៊ែ សិច កាត បក់ ឃើយ រ៉ះ ប៉ានឹរ ប‌៉្រ័ះ កា សាដាច់ ដាវីត ");
INSERT INTO tpu_vpl VALUES ("S224_12","011_24_12","2SA","24","12","12","ប‌៉្រ័ះ កាប ផា «ហគ់ ឡាំ រ៉ះ កា សាដាច់ ដាវីត \"ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ រ៉ះ ផា នីអៀ 'អាញ់ ចឹង ចៃគ ថូត អីស ហគ់ អីស រ៉ើស សារ ញ៉ា អាញ់ ចឹង ប៉្រគ័ កា អីស អាញ់ ចឹង ប៉្រគ័ កា អីស ឡាក់ កា អីស រ៉ើស ណោះ ហង' \"»។ ");
INSERT INTO tpu_vpl VALUES ("S224_13","011_24_13","2SA","24","13","13","ទឹល នីណោ័ះ វគ័ កាត ឡាំ រ៉ះ កា សាដាច់ ដាវីត ផា «អីស ប៉ិច កា សារ នែវ ចំ ប៉ិច កា ឡាយ៉ិត ឡាំងវ៉ាញ់ តាំប៉ើះ សាណាំ ទឹប ប៉ាថេត លើ ប៉ិច សាតាក់ កា មួត តាម៉ឺរ ទិ ប៉ៃង ខៃ លើ ប៉ិច អន់ ប៉ាញុ រ៉ាំបល់ កើត ទឹប ប៉ាថេត ទិ ប៉ៃង ដារ់ ? ហគ់ ឃឹត ហៃ ពិ អាញ់ ចឹង អ្យក់ ប៉ានឹរ អីស ឡាំ រ៉ះ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប៉្រើ អាញ់ ពឹះ អា»។ ");
INSERT INTO tpu_vpl VALUES ("S224_14","011_24_14","2SA","24","14","14","សាដាច់ ដាវីត កាប លូ វគ័ កាត ផា «អាញ់ ថុក ពុត ខាក់។ អន់ ពិន ត្រគ់ តី ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ ដាគ់ ហ៊្លត ឡឹង ត្រគ់ តី ប៉ាណូស ខង ប‌៉្រ័ះ តាប៉ាប តាប៉ុន ខាក់»។ ");
INSERT INTO tpu_vpl VALUES ("S224_15","011_24_15","2SA","24","15","15","ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉្រគ័ អន់ ទី ប៉ាញុ រ៉ាំបល់ កើត ពឹះ ពឹង ប៉ាថេត អ៊ីស្រាអ៊ែល ឡឹង កាំលឺ ណោះ លើយ ទឹល ដារ់ កាំឡត់។ គ្រឹប ចារ ឡឹង មឿង ដាន់ លើយ ទឹល មឿង បៀសេបា ប៉ាសុន តោ័ អៀង ខាក់ ៧០.០០០ ដូវ។ ");
INSERT INTO tpu_vpl VALUES ("S224_16","011_24_16","2SA","24","16","16","ផះ ប៊យ ប‌៉្រ័ះ ចឹង ថាំឡាយ មឿង យេរូសាឡឹម ប‌៉្រ័ះ ប៊កកាតយ័ កា រ៉ើ ពុត អូ ចៃ ចៃគ ថូត មឿង ណោះ អុះ។ អ៊ែ កាប លូ ប៊យ អ៊ែ ផះ ចឹង ថាំឡាយ ប៉ាសុន ណោះ ផា «ដឹង ណោះ បគ័ កេះ ជែ ប៉ាន់តោ័ ពូ ហង !» ផះ ណោះ ប៊យ ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ ក្យាម័ ចារ ពូ ប៉្រះ ពៀ វគ័ អារ៉ោណា ឡាក់ សុនសាត យេប៊ូស។ ");
INSERT INTO tpu_vpl VALUES ("S224_17","011_24_17","2SA","24","17","17","ប៉ាគ់ សាដាច់ ដាវីត ប៉ប័ ប៊យ ប‌៉្រ័ះ ផះ ប៉ាន់តោ័ ប៉ាសុន អ៊ែ កា កាប លូ ប‌៉្រ័ះ ប៊កកាតយ័ ផា «អាញ់ អា ហង ប៉្រគ័ យច អាញ់ ប៉្រគ័ អូ ដាគ់។ កាប៉ាច់ ប៉ាសុន អា អន់ឌែ អូ ទី ប៉្រគ័ យច ញ៉ា អុះ។ ហគ់ អន់ អីស ចៃគ ថូត អាញ់ លូ មួត ហី ក្រាន អាញ់ ឡគ»។ ");
INSERT INTO tpu_vpl VALUES ("S224_18","011_24_18","2SA","24","18","18","ពឹង ដារ់ ណោះ ទៅ វគ័ កាត ឡាំ រ៉ះ លូ សាដាច់ ដាវីត ផា «អ្យគ័ ឡាំ ប៉ាគ់ ចារ ប៉្រះ ពៀ វគ័ អារ៉ោណា ឡាក់ សុនសាត យេប៊ូស កេះណោះ ប៉្រគ័ អន់ហ្នឹង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាគ់ ណោះ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("S224_19","011_24_19","2SA","24","19","19","សាដាច់ ដាវីត កា ឡាំ ពួយ ប៉ានឹរ វគ័ កាត ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("S224_20","011_24_20","2SA","24","20","20","ប៉ាគ់ វគ័ អារ៉ោណា ប៉ប័ សាដាច់ ដាវីត លូ មួត ប៉្រគ័ កាន កា សាដាច់ អ៊ែ កា ឡាំ កុប កល់ ទឹះ តេះ សាំប‌៉័ះ សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("S224_21","011_24_21","2SA","24","21","21","វគ័ អារ៉ោណា អំប៉ញ់ ផា «អឺ ពឹ តាំងឡា អីស ពឹះ ប៉ាគ់ ហី អាញ់ ទី សារ ញ៉ា ?» សាដាច់ ដាវីត តើល ផា «អាញ់ ពឹះ តាច់ ចារ អីស ប៉្រះ ពៀ ប៉្រគ័ អន់ហ្នឹង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ភឿ អន់ ប៉ាសុន រ៉ាវ៉ាច់ ឡឹង សារ ចុនចៃ»។ ");
INSERT INTO tpu_vpl VALUES ("S224_22","011_24_22","2SA","24","22","22","វគ័ អារ៉ោណា តើល សាដាច់ ដាវីត ផា «អឺ ពឹ តាំងឡា កាណាគ័ ញ៉ា អីស ប៉ិច អ្យក់ ពិ តាម ពុត អីស អ្យក់ រ៉ក់ ពុះ អ្លាត សាំរ៉ាប់ រ៉ាម៉ះ ប‌៉្រ័ះ អ្យក់ អ៊្លង រ៉ាស លូ អ៊្លង ឡាក់ រ៉ក់ អូស ប៉្លៃន ពៀ ម៉ាគ់ ប៉្រគ័ រ៉ាម៉េះ។ ");
INSERT INTO tpu_vpl VALUES ("S224_23","011_24_23","2SA","24","23","23","អឺ សាដាច់ អាញ់ អន់ កាណាគ័ ទិ អា កា អីស»។ វគ័ អារ៉ោណា កាប ណាវ្គ ផា «អន់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អីស ដាគ់ ពុត កា អីស»។ ");
INSERT INTO tpu_vpl VALUES ("S224_24","011_24_24","2SA","24","24","24","ហះកា សាដាច់ កាប លូ វគ័ អារ៉ោណា ផា «អូ អុះ អាញ់ ប៉ិច តាច់ កាណាគ័ អីស អន់ ត្រគ់ ខា។ អាញ់ អូ ចៃ អុះ អ្យក់ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ពូ អន់ កា អាញ់ តាដោះ ណោះ»។ សាដាច់ ដាវីត តាច់ ចារ ប៉្រះ ពៀ លូ រ៉ក់ ណោះ ខា ប៉្រាក់ ទងតិគ័ កាឡូ។ ");
INSERT INTO tpu_vpl VALUES ("S224_25","011_24_25","2SA","24","25","25","អ៊ែ កា ប៉្រគ័ អន់ហ្នឹង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ហះ ណោះ ហង កេះណោះ ពុះ អ្លាត កាណាគ័ រ៉ាម៉ះ លូ ពុះ កាណាគ័ រ៉ាម៉ះ សាំរ៉ាប់ សា អន់ឌូ។ ប‌៉្រ័ះ ប៊កកាតយ័ កា សាំយ៉ាំង សារ អ៊ែ ឡោម អន់ កា ប៉ាថេត ណោះ អ៊ីស្រាអ៊ែល កា រ៉ាវ៉ាច់ ឡឹង សារ ចុនចៃ។ ");
INSERT INTO tpu_vpl VALUES ("K11_1","012_1_1","1KI","1","1","1","ផះ សាដាច់ ដាវីត ក្រាគ់ ឡក់ កេះ យ‌៉័ះ ពូ អ្យក់ អង់យ៉ាគ័ តាគ់ អញ់សូវ អ៊ែ កាតាម កា អ្វៃ គ្រឹន ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K11_2","012_1_2","1KI","1","2","2","ផះ ណោះ មួត ប៉្រគ័ កាន រ៉ាតីស រ៉ះ កា អ៊ែ ផា «អីស អន់ ញឹន ណាំង អង់កាន់ រ៉ូះ ភឿ អ្វៃ តាគ់ អង់រ៉ើង លូ រ៉ាំងហៃ អីស ទឹប អ៊ែ តៃប ក្រក់ អីស ម៉ាគ់ អីស អូ គ្រឹន»។ ");
INSERT INTO tpu_vpl VALUES ("K11_3","012_1_3","1KI","1","3","3","អន់ឌែ កា ចាក ណាំង អង់កាន់ ប៉ាញ័ ទឹប ប៉ាថេត អ៊ីស្រាអ៊ែល ប៉ប័ អង់កាន់ ដាគ់ ឡាយ៉ាម័ ម៉ោញ ដូវ សិច អ៊ែ អាប៊ីសាក អ៊ែ អ្វៃ ពឹង មឿង ស៊ូនែម កេះណោះ អន់ឌែ អ្យក់ អ៊ែ ឡាំ ប៉ាគ់ សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("K11_4","012_1_4","1KI","1","4","4","ណាង អា ដាគ់ ឡាយ៉ាម័ ខាក់ អ៊ែ អ្វៃ តាគ់ អង់រ៉ើង លូ រ៉ាំងហៃ សាដាច់ ហះកា សាដាច់ អូ ប៉្រគ័ លូ អ៊ែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K11_5","012_1_5","1KI","1","5","5","ផះ ណោះ អាដូនីយ៉ា ឡាក់ គន សាដាច់ ដាវីត លូ យ៉ាគ់ ហាគីត អ៊ែ តាំប៉ោក ឡាកោ អ៊ែ ផា «អាញ់ ចឹង ប៉្រគ័ សាដាច់»។ កេះណោះ អ៊ែ អ្យក់ រ៉ាតេ័ះ លូ សេះ អៀង ទឹប ទី តាហាន ៥០ ដូវ ចាក ឡាំ អន់ទ្រួល។ ");
INSERT INTO tpu_vpl VALUES ("K11_6","012_1_6","1KI","1","6","6","ឡឹង កើត អ៊ែ ពឹ អ៊ែ អូ ឃើយ កាប អឺក កា អ៊ែ ផា «ញ៉ា អីស ប៉្រគ័ នែវ អា ហះ ?» អាដូនីយ៉ា អា អ៊ែ ដាគ់ ឡាយ៉ាម័ ខាក់។ កាណុង គន សាដាច់ ដាវីត ឡៃង ឡឹង អាប់សាឡុំ ឃឺ អាដូនីយ៉ា អា ហង។ ");
INSERT INTO tpu_vpl VALUES ("K11_7","012_1_7","1KI","1","7","7","អ៊ែ ឡាំ ពឹកសា លូ យ៉ូអាប់ ឡាក់ គន យ៉ាគ់ សេរូយ៉ា ទឹប ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ម៉ោញ ដូវ សិច អ៊ែ អាបៀថារ។ អន់ឌែ ពៀរ ដូវ ណោះ ភម ពុត លូ អាដូនីយ៉ា។ ");
INSERT INTO tpu_vpl VALUES ("K11_8","012_1_8","1KI","1","8","8","ហះកា ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ សិច សាដុក លូ បេណាយ៉ា ឡាក់ គន វគ័ យេហូយ៉ាដា ទឹប វគ័ ណាថាន ឡាក់ រ៉ាគឹយ ប‌៉្រ័ះ ទឹប ស៊ីម៉ៃ ទឹប រេអ៊ី លូ មួត តាហាន សាដាច់ ដាវីត ឡាក់ កេង ខាក់ អន់ឌែ អូ ម៉ុត អន់ឌូ លូ អាដូនីយ៉ា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K11_9","012_1_9","1KI","1","9","9","ឡៃង ឡឹង ណោះ អាដូនីយ៉ា ទ្រៀម សារ អៃត សា ប៉ាគ់ ចារ អំហ្មោ សូហេលែត ក្យាម័ កល់ ទៀក រូគែល ទឹប ពុះ ចៀម ពុះ រ៉ក់ តីស តង់ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័។ អ៊ែ កា រ៉ះ កា មួត អុះ ម៉ី អ៊ែ ទិឌូ ទឹប មួត ផូង័ យូដា ឡាក់ ប៉្រគ័ កាន រ៉ាតីស កា សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("K11_10","012_1_10","1KI","1","10","10","ហះកា អ៊ែ អូ រ៉ះ លូ វគ័ ណាថាន ឡាក់ រ៉ាគឹយ ប‌៉្រ័ះ លូ បេណាយ៉ា លូ តាហាន ឡាក់ កេង ខាក់ អ៊ែ កា អូ រ៉ះ លូ អុះ អ៊ែ សាឡូម៉ូន ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K11_11","012_1_11","1KI","1","11","11","ផះ ណោះ វគ័ ណាថាន ឡាំ អំប៉ញ់ លូ យ៉ាគ់ បាតសេបា ឡាក់ មើគ សាឡូម៉ូន ផា «អីស អូ កាតាំង ពូ រ៉ះ ប ? អាដូនីយ៉ា គន យ៉ាគ់ ហាគីត អ៊ែ តាគ់ អំប៉ោក ឡាកោ អ៊ែ ទៅ អន់ កេះ សាដាច់ ហះកា សាដាច់ ដាវីត ឡាក់ ពឹ តាំងឡា ពិន អ៊ែ អូ អ្លុ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K11_12","012_1_12","1KI","1","12","12","កិញអៀ អា អាញ់ ប៉រ់ អន់តគ់ រ៉ះ កា អីស ម៉ាគ់ ពូ អូ ប៉ាន់តោ័ អីស លូ គន អីស សាឡូម៉ូន។ ");
INSERT INTO tpu_vpl VALUES ("K11_13","012_1_13","1KI","1","13","13","ហគ់ អីស ឡាំ រ៉ះ លូ សាដាច់ ដាវីត រិញ អីស កាប នីអៀ \"អឺ ពឹ តាំងឡា អីស ម៉ត់ លូ អាញ់ ពែ ផា សាឡូម៉ូន ឡាក់ គន ពិន ចឹង ហាវ ប៉្រគ័ សាដាច់ លូ អង់អ្វៃ ពឹង គ្រេ សាដាច់ ប៉ាតាង អីស។ ហះកា កិញអៀ អា ញ៉ា ត្រគ់ អាដូនីយ៉ា ហាវ ប៉្រគ័ សាដាច់ ឡគ ?\"» ");
INSERT INTO tpu_vpl VALUES ("K11_14","012_1_14","1KI","1","14","14","វគ័ ណាថាន កា រ៉ះ ណាវ្គ ផា «ផះ អីស អ្វៃ រ៉ះ លូ សាដាច់ ដាវីត អន់ទៀ អាញ់ ចឹង ឡាំ ពួយ អីស ដេល ម៉ាគ់ អាញ់ ចឹង រ៉ះ ប៉ាឡក់ ណាវ្គ ទិ សារ ញ៉ា ឡាក់ អីស ផះ អ្វៃ រ៉ះ ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("K11_15","012_1_15","1KI","1","15","15","យ៉ាគ់ បាតសេបា កា ឡាំ កាកាប លូ សាដាច់ ដាវីត ពឹង កាណុង អ៊ែ។ ផះ ណោះ សាដាច់ ដាវីត កា ក្រាគ់ ឡក់ កេះ ណាង អាប៊ីសាក ឡឹង មឿង ស៊ូនែម ផះ អ្វៃ រ៉ាំងហៃ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("K11_16","012_1_16","1KI","1","16","16","យ៉ាគ់ បាតសេបា ជន តាកុល សាំប‌៉័ះ សាដាច់ ដាវីត កេះណោះ សាដាច់ ដាវីត អំប៉ញ់ អ៊ែ ផា «អីស ទី សារ ញ៉ា ?» ");
INSERT INTO tpu_vpl VALUES ("K11_17","012_1_17","1KI","1","17","17","អ៊ែ តើល ផា «អឺ ពឹ តាំងឡា អីស ម៉ត់ លូ អាញ់ ពែ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អីស ផា សាឡូម៉ូន ឡាក់ គន ពិន ចឹង ហាវ ប៉្រគ័ សាដាច់ ប៉ាតាង អីស អ៊ែ ហង ចឹង អង់អ្វៃ ពឹង គ្រេ សាដាច់ ម៉ះ អីស។ ");
INSERT INTO tpu_vpl VALUES ("K11_18","012_1_18","1KI","1","18","18","ហះកា កិញអៀ អា ញ៉ា ត្រគ់ អាដូនីយ៉ា ឡគ ហាវ ប៉្រគ័ សាដាច់ ? ញ៉ា អីស អូ អ្លុ ប ? ");
INSERT INTO tpu_vpl VALUES ("K11_19","012_1_19","1KI","1","19","19","អាដូនីយ៉ា ពុះ រ៉ក់ តីស តង់ លូ ចៀម តុត អៀង រ៉ាម៉ះ ប‌៉្រ័ះ។ អ៊ែ កា រ៉ះ កា គន កាម៉ាក័ អីស ទិណោ័ះ ប៉្រើ ឡាំ អៃត ឡាំ សា អន់ឌូ លូ អ៊ែ ទឹប រ៉ះ លូ អាបៀថារ ឡាក់ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ លូ យ៉ូអាប់ ឡាក់ ម៉ៃគ តាហាន ហះកា អ៊ែ អូ រ៉ះ អុះ លូ សាឡូម៉ូន ឡាក់ ដាគ់ ត្រង់ លូ អីស។ ");
INSERT INTO tpu_vpl VALUES ("K11_20","012_1_20","1KI","1","20","20","អឺ សាដាច់ ឡាក់ ពឹ តាំងឡា អាញ់ កិញអៀ អា ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ អ្វៃ ក្យាគ់ ដឹង អីស ចឹង រ៉ះ កា ញឹន ពឿ ចឹង ត្រគ់ ប៉្រគ័ សាដាច់ ប៉ាតាង អីស។ ");
INSERT INTO tpu_vpl VALUES ("K11_21","012_1_21","1KI","1","21","21","ផា អីស អូ ប៉្រគ័ នីណោ័ះ ប៉ាគ់ អីស ពូយ ទៀ ណោះ ពូ ចឹង ផា កា អាញ់ លូ គន អាញ់ សាឡូម៉ូន ឡាក់ ប៉ាណូស ថូត តាទឹច ហង»។ ");
INSERT INTO tpu_vpl VALUES ("K11_22","012_1_22","1KI","1","22","22","ផះ យ៉ាគ់ បាតសេបា អ្វៃ កាកាប លូ សាដាច់ ផាឌី វគ័ ណាថាន ឡាំ ទឹល ប៉ាគ់ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K11_23","012_1_23","1KI","1","23","23","ពូ ឡាំ រ៉ះ លូ សាដាច់ ផា «វគ័ ណាថាន ឡាក់ រ៉ាគឹយ ប‌៉្រ័ះ ពឹះ ទឹល ប៉ាគ់ អា កេះ»។ វគ័ ណាថាន កា ម៉ុត ប៉ាគ់ ចារ សាដាច់ លូ ជន តាកុល កុប កល់ ទឹះ តេះ។ ");
INSERT INTO tpu_vpl VALUES ("K11_24","012_1_24","1KI","1","24","24","កេះណោះ អ៊ែ អំប៉ញ់ ផា «អឺ សាដាច់ ញ៉ា អីស ប ប៉្រើ អាដូនីយ៉ា ហាវ ប៉្រគ័ សាដាច់ ប៉ាតាង អីស លូ អន់ អ៊ែ អ្វៃ ពឹង គ្រេ សាដាច់ ម៉ះ អីស ? ");
INSERT INTO tpu_vpl VALUES ("K11_25","012_1_25","1KI","1","25","25","ខង ដារ់ អា អាដូនីយ៉ា ឡាំ ប៉ាគ់ អំហ្មោ សូហេលែត ទឹប ពុះ រ៉ក់ តីស តង លូ ចៀម តុត អៀង រ៉ាម៉ះ ប‌៉្រ័ះ។ អ៊ែ ជៀក ឡាំ គន អីស ទិណោ័ះ ទឹប មួត ម៉ៃគ តាហាន លូ វគ័ អាបៀថារ ឡាក់ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ឡាំ អន់ឌូ ដេល។ កិញអៀ អា អន់ឌែ ផះ អៃត សា រ៉គ់ សើម អន់ឌូ លូ អាដូនីយ៉ា ទឹប ស៊្រែក តាំងហើ ផា \"អន់ សាដាច់ អាដូនីយ៉ា ទី អាញុ រ៉ីស ទុញ\"។ ");
INSERT INTO tpu_vpl VALUES ("K11_26","012_1_26","1KI","1","26","26","ហះកា អាដូនីយ៉ា អូ រ៉ះ អុះ កា អាញ់ ឡាក់ ទុច អីស លូ វគ័ សាដុក ឡាក់ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ទឹប បេណាយ៉ា ឡាក់ គន វគ័ យេហូយ៉ាដា។ អ៊ែ កា អូ រ៉ះ កា គន អីស សាឡូម៉ូន ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K11_27","012_1_27","1KI","1","27","27","អឺ ពឹ តាំងឡា ញ៉ា អីស ប ប៉្រើ គន អីស អាដូនីយ៉ា ហាវ ប៉្រគ័ សាដាច់ ប៉ាតាង អីស ? អ្យូគ ផៃគ អីស អូ អន់ ញឹន អ្លុ ត័ះ ?»។ ");
INSERT INTO tpu_vpl VALUES ("K11_28","012_1_28","1KI","1","28","28","កេះណោះ សាដាច់ ដាវីត រ៉ះ ផា «អន់ បាតសេបា ម៉ុត ប៉ាគ់ អា ហៃ»។ បាតសេបា កា ម៉ុត អ្វៃ ប៉ាគ់ ចារ សាដាច់ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("K11_29","012_1_29","1KI","1","29","30","សាដាច់ កា ម៉ត់ លូ អ៊ែ ផា «ដារ់ អា អាញ់ ចឹង ប៉ោក ហាវ សាឡូម៉ូន ឡាក់ គន អីស អន់ ប៉្រគ័ សាដាច់ ប៉ាតាង អាញ់ អ៊ែ ហង ចឹង អង់អ្វៃ ពឹង គ្រេ សាដាច់ អាញ់ ឡាក់ កា អាញ់ ម៉ត់ លូ អីស ពែ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល។ សារ អាញ់ រ៉ះ កា អីស អា តាទឹច ហង ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ រ៉ីស អ៊ែ តង័ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង សារ ប៉ាណាប គ្រឹប នែវ»។ ");
INSERT INTO tpu_vpl VALUES ("K11_31","012_1_31","1KI","1","31","31","កេះណោះ បាតសេបា ជន តាកុល កុប កល់ ទឹះ តេះ សាំប‌៉័ះ សាដាច់ ដាវីត ទឹប កាប ផា «អន់ ពឹ តាំងឡា ឡាក់ សាដាច់ អាញ់ ទី អាញុ រ៉ីស លើយ»។ ");
INSERT INTO tpu_vpl VALUES ("K11_32","012_1_32","1KI","1","32","32","កេះណោះ សាដាច់ ដាវីត រ៉ះ ផា «ហគ់ ឡាំ រ៉ះ កា វគ័ សាដុក ឡាក់ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ លូ វគ័ ណាថាន ឡាក់ រ៉ាគឹយ ប‌៉្រ័ះ ទឹប បេណាយ៉ា គន វគ័ យេហូយ៉ាដា ម៉ុត ប៉ាគ់ អា»។ អន់ឌែ កា ម៉ុត ប៉ាគ់ ចារ សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("K11_33","012_1_33","1KI","1","33","33","អ៊ែ ប៉្រើ អន់ឌែ ផា «អ្យគ័ អន់ដីស ឡាំ រ៉ះ ប៉ាតុំ មួត ប៉្រគ័ កាន កា អាញ់ លូ អន់ សាឡូម៉ូន ឡាក់ គន អាញ់ ហាវ ជិះ លៀ អាញ់ កេះណោះ ប៉ាណាំ អ៊ែ ឡាំ ប៉ាគ់ កល់ ទៀក គីហុន។ ");
INSERT INTO tpu_vpl VALUES ("K11_34","012_1_34","1KI","1","34","34","ប៉ាគ់ ចារ ណោះ វគ័ សាដុក លូ វគ័ ណាថាន ចឹង ជ្រោ សាងី ពឹង កល់ សាឡូម៉ូន ប៉្រើ អ៊ែ ប៉្រគ័ សាដាច់ សុនសាត អ៊ីស្រាអ៊ែល កេះណោះ ខ្លោម សាណៃង លូ តាំងហើ ផា \"អន់ សាដាច់ សាឡូម៉ូន ទី អាញុ រ៉ីស ទុញ\"។ ");
INSERT INTO tpu_vpl VALUES ("K11_35","012_1_35","1KI","1","35","35","កេះណោះ ជឹន សាឡូម៉ូន ម៉ុត ប៉ាគ់ ហី សាដាច់។ អ៊ែ ចឹង អង់អ្វៃ ពឹង គ្រេ សាដាច់ ម៉ះ អាញ់ អ៊ែ ហង ចឹង ហាវ ប៉្រគ័ សាដាច់ ប៉ាតាង អាញ់។ អាញ់ ប៉្រើ អ៊ែ ប៉្រគ័ ម៉ៃគ ណាំផា ប៉ាសុន អ៊ីស្រាអ៊ែល លូ ប៉ាសុន យូដា»។ ");
INSERT INTO tpu_vpl VALUES ("K11_36","012_1_36","1KI","1","36","36","បេណាយ៉ា តើល ផា «អឺ ពឹ តាំងឡា ញឹន ចឹង ប៉្រគ័ ពួយ ប៉ានឹរ អីស ហង។ អន់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អីស ប៉្រគ័ អន់ សារ អា កើត ពឹះ ឡាក់ កា អីស ផា ណោះ ហង ពិ។ ");
INSERT INTO tpu_vpl VALUES ("K11_37","012_1_37","1KI","1","37","37","អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ អន់ឌូ លូ សាឡូម៉ូន ឡាក់ កា អ៊ែ អ្វៃ អន់ឌូ លូ អីស អា ដេល។ អន់ សារ រ៉ាំងហៃ ម៉ះ សាដាច់ សាឡូម៉ូន ដាគ់ ហ៊្លត ឡឹង សារ រ៉ាំងហៃ ម៉ះ អីស ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("K11_38","012_1_38","1KI","1","38","38","វគ័ សាដុក លូ វគ័ ណាថាន លូ បេណាយ៉ា ទឹប មួត កេរេធីម លូ មួត ពេលេធីម ឡាំ ជឹន សាដាច់ សាឡូម៉ូន ហាវ ជិះ លៀ សាដាច់ ដាវីត ទឹប ជឹន អ៊ែ ឡាំ ប៉ាគ់ កល់ ទៀក គីហុន។ ");
INSERT INTO tpu_vpl VALUES ("K11_39","012_1_39","1KI","1","39","39","វគ័ សាដុក ឡាក់ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ កា អ្យក់ អង់គែ ឡាក់ ចៃគ សាងី កេះៗ ឡឹង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ កេះណោះ ជ្រោ ពឹង សាឡូម៉ូន ប៉្រើ ប៉្រគ័ សាដាច់។ កេះណោះ ពូ ខ្លោម សាណៃង មួត ប៉ាសុន ទិឌូ កា តាំងហើ ម៉ៃៗ ផា «អន់ សាដាច់ សាឡូម៉ូន ទី អាញុ រ៉ីស ទុញ»។ ");
INSERT INTO tpu_vpl VALUES ("K11_40","012_1_40","1KI","1","40","40","កេះណោះ ប៉ាសុន ទិឌូ ចាក ពួយ សាដាច់ សឹត ប៉ាគ់ មឿង យេរូសាឡឹម ទឹប ខ្លោម ច្យាប័ ខ្លោម ប៉ី ហោក រ៉គ់ កាខាក់ អរ់ៗ សោៗ ទឹល រ៉ាយ៉ាគ់ តេះ ប៉្លៃង។ ");
INSERT INTO tpu_vpl VALUES ("K11_41","012_1_41","1KI","1","41","41","ផះ អាដូនីយ៉ា លូ មួត អំហ៊្មយ ឡាក់ អ្វៃ អន់ឌូ លូ អ៊ែ ផះ អន់ឌែ អៃត សា ប៊ែត ចឹង កេះៗ ផាឌី កាតាំង យឹង អរ់ៗ សោៗ។ ប៉ាគ់ វគ័ យ៉ូអាប់ កាតាំង សាណៃង អ៊ែ កា អំប៉ញ់ ផា «ញ៉ា ត្រគ់ ទី សាណៃង តេះ កាណុង មឿង នីណោ័ះ ហះ ?» ");
INSERT INTO tpu_vpl VALUES ("K11_42","012_1_42","1KI","1","42","42","អ៊ែ ផះ អ្វៃ កាកាប ឡឹង សារ ណោះ ផាឌី យ៉ូណាថាន គន វគ័ អាបៀថារ កា ឡាំ ទឹល ប៉ាគ់ ណោះ។ អាដូនីយ៉ា កាប ផា «ចុ ពឹះ ប៉ាគ់ អា ឃឺ អ៊ែ អីស ពឹះ រ៉ះ សារ ដាគ់ ហង ខង អីស ប៉ាណូស កានឹត កានោរ»។ ");
INSERT INTO tpu_vpl VALUES ("K11_43","012_1_43","1KI","1","43","43","យ៉ូណាថាន កា តើល ផា «អូ ត្រគ់ ឡាក់ កា អីស ផា ណោះ អុះ សាដាច់ ដាវីត ឡាក់ ពឹ តាំងឡា ពិន ប៉្រើ សាឡូម៉ូន ប៉្រគ័ សាដាច់ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("K11_44","012_1_44","1KI","1","44","44","អ៊ែ ប៉្រើ វគ័ សាដុក ឡាក់ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ លូ វគ័ ណាថាន ឡាក់ រ៉ាគឹយ ប‌៉្រ័ះ ទឹប បេណាយ៉ា គន វគ័ យេហូយ៉ាដា ទឹប មួត កេរេធីម លូ មួត ពេលេធីម អន់ឌែ ណោះ ហង ប៉ោក ហាវ សាឡូម៉ូន អន់ ជិះ លៀ សាដាច់ ដាវីត។ ");
INSERT INTO tpu_vpl VALUES ("K11_45","012_1_45","1KI","1","45","45","វគ័ សាដុក លូ វគ័ ណាថាន ជ្រោ សាងី ពឹង សាឡូម៉ូន ប៉ាគ់ ចារ កល់ ទៀក គីហុន ប៉្រើ ប៉្រគ័ សាដាច់។ កេះណោះ អន់ឌែ សឹត ឡឹង ណោះ ទឹប ហោក រ៉គ់ អរ់ៗ សោៗ ប៉ាញ័ ទឹប មឿង ឡាក់ កា អន់ដីស កាតាំង អា ហង។ ");
INSERT INTO tpu_vpl VALUES ("K11_46","012_1_46","1KI","1","46","46","កិញអៀ អា សាឡូម៉ូន អង់អ្វៃ ពឹង គ្រេ សាដាច់ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("K11_47","012_1_47","1KI","1","47","47","មួត បក់ ប៉្រគ័ កាន រ៉ាតីស កា សាដាច់ កា ប៉ាណាំ គួប ឡាំ កាកាប លូ សាដាច់ ដាវីត ទឹប ប៉រ់ សារ ដាគ់ ឡឹង ប‌៉្រ័ះ ប៊កកាតយ័ អន់ឌែ កាប ផា \"អន់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អីស អន់ សាឡូម៉ូន លៅ លែង សិច ហ៊្លត ឡឹង អីស។ អន់ សារ រ៉ាំងហៃ ម៉ះ សាដាច់ សាឡូម៉ូន ដាគ់ ហ៊្លត ឡឹង សារ រ៉ាំងហៃ ម៉ះ អីស\"។ ផះ ណោះ សាដាច់ ដាវីត អ្វៃ ពឹង គ្រេ ជន តាកុល សាំប‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័ ");
INSERT INTO tpu_vpl VALUES ("K11_48","012_1_48","1KI","1","48","48","ទឹប កាប ផា \"ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល អ៊ែ អន់ គន អាញ់ អង់អ្វៃ ពឹង គ្រេ សាដាច់ ប៉ាតាង អាញ់ ទឹប អន់ ម៉ាត់ អាញ់ តាន័ ប៉ប័\"»។ ");
INSERT INTO tpu_vpl VALUES ("K11_49","012_1_49","1KI","1","49","49","ផះ កាតាំង សារ ណោះ កេះ មួត អំហ៊្មយ ទិឌូ ឡាក់ អ្វៃ អន់ឌូ លូ អាដូនីយ៉ា កា អ្យូគ រ៉ារ៉ៃត ខាក់ ទឹប ប៉ាន់តាន សាតាក់ ទ្រង ពឿ ទ្រង អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("K11_50","012_1_50","1KI","1","50","50","អាដូនីយ៉ា អ្យូគ កា សាដាច់ សាឡូម៉ូន កាខាក់ អ៊ែ សាតាក់ ឡាំ ក្វារ់ អង់គែ អន់ហ្នឹង រ៉ាម៉ះ ប‌៉្រ័ះ ។ ");
INSERT INTO tpu_vpl VALUES ("K11_51","012_1_51","1KI","1","51","51","ទី ពូ ឡាំ រ៉ះ កា សាដាច់ សាឡូម៉ូន ផា «អាដូនីយ៉ា អ្យូគ កា អីស ខាក់។ អ៊ែ កា ឡាំ ក្វារ់ អង់គែ អន់ហ្នឹង រ៉ាម៉ះ ប‌៉្រ័ះ ទឹប រ៉ះ ផា \"អន់ សាដាច់ សាឡូម៉ូន ម៉ត់ លូ អាញ់ កាណុង ដារ់ អា ផា អូ ប៉ាន់តោ័ អាញ់\"»។ ");
INSERT INTO tpu_vpl VALUES ("K11_52","012_1_52","1KI","1","52","52","សាដាច់ សាឡូម៉ូន រ៉ះ ផា «ផានែវ អ៊ែ ដាគ់ ត្រង់ តាទឹច សក់ ម៉ោញ កាស៊ែ ឡឹង កល់ អ៊ែ កា អូ ហ្រុង អុះ។ ហះកា ផា អ៊ែ ប៉្រគ័ អូ ត្រង់ ណោះ អ៊ែ ចឹង តោ័ តាទឹច ហង»។ ");
INSERT INTO tpu_vpl VALUES ("K11_53","012_1_53","1KI","1","53","53","សាដាច់ សាឡូម៉ូន កា ប៉្រើ ពូ ឡាំ អ្យក់ អាដូនីយ៉ា អន់ ឡាច់ ឡឹង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ។ កេះណោះ អាដូនីយ៉ា ឡាំ សាំប‌៉័ះ សាដាច់ សាឡូម៉ូន សាដាច់ សាឡូម៉ូន កា រ៉ះ ផា «ហគ់ សឹត ប៉ាគ់ ហី អីស តោ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("K12_1","012_2_1","1KI","2","1","1","ក្យាម័ ដារ់ សាដាច់ ដាវីត ចឹង តោ័ កេះ អ៊ែ អន់តគ់ ប៉ាតោ កា គន អ៊ែ សាឡូម៉ូន ផា ");
INSERT INTO tpu_vpl VALUES ("K12_2","012_2_2","1KI","2","2","2","«អាញ់ ក្យាម័ ចឹង តោ័ ឡក់ កេះ ហគ់ ទី ពុត ខឹន អន់ ត្រគ់ គុន កាម៉ាក័។ ");
INSERT INTO tpu_vpl VALUES ("K12_3","012_2_3","1KI","2","3","3","ត្រគ់ សាំយ៉ាំង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ទឹប អ្វៃ កោប អន់ ដាគ់ ពួយ អ៊ែ លូ ប៉្រគ័ ពួយ ចាបាប់ លូ សារ អន់តគ់ ប៉ាតោ ប៉្រោ ទឹប ឡាក់ ទី ច្រាគ់ រ៉ះ កាណុង ផាប់ ចាបាប់ ឡាក់ ប‌៉្រ័ះ អន់ កា វគ័ ម៉ូសេ ពែ ម៉ាគ់ គ្រឹប ង៉ារ អីស ប៉្រគ័ ចឹង ដាគ់ ទិណោ័ះ ");
INSERT INTO tpu_vpl VALUES ("K12_4","012_2_4","1KI","2","4","4","លូ សារ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អាញ់ ចឹង កើត ពឹះ តាទឹច ឃឺ ប‌៉្រ័ះ រ៉ះ ផា \"ផា គន សោ អីស អ្យក់ ពុត ចៃគ លូ ប៉្រគ័ ពួយ អាញ់ អន់ ដាគ់ ត្រង់ ទិ ពុត ទិ ពៀក អន់ឌែ ចឹង ប៉្រគ័ សាដាច់ រ៉ាំងហៃ ប៉ាថេត អ៊ីស្រាអ៊ែល លើយ\"»។ … ");
INSERT INTO tpu_vpl VALUES ("K12_10","012_2_10","1KI","2","10","10","ឡៃង ឡឹង ណោះ សាដាច់ ដាវីត តោ័ ពួយ វគ័ យ៉ាគ់ អ៊ែ កេះណោះ ពូ តប់ ប៉ាទ្រូ អ៊ែ ប៉ាគ់ ចារ ម៉ោញ កាណុង មឿង យេរូសាឡឹម ឡាក់ ពូ អើ ផា ស្រុក តេះ សាដាច់ ដាវីត។ ");
INSERT INTO tpu_vpl VALUES ("K12_11","012_2_11","1KI","2","11","11","ផះ អ៊ែ អ្វៃ រ៉ីស ពែ អ៊ែ រ៉ាំងហៃ សុនសាត អ៊ីស្រាអ៊ែល ទុញ ៤០ សាណាំ។ ៧ សាណាំ អ៊ែ អ្វៃ ប៉ាគ់ មឿង ហេប្រូន ៣៣ សាណាំ អ៊ែ អ្វៃ ប៉ាគ់ មឿង យេរូសាឡឹម។ ");
INSERT INTO tpu_vpl VALUES ("K12_12","012_2_12","1KI","2","12","12","គន អ៊ែ សាឡូម៉ូន កា ហាវ ប៉្រគ័ សាដាច់ ប៉ាតាង ពឹ អ៊ែ។ សាឡូម៉ូន កា រ៉ាំងហៃ ប៉ាថេត ទឹប ទី អំរ៉ាញ អឺញ កេង ខាក់។ … ");
INSERT INTO tpu_vpl VALUES ("K13_1","012_3_1","1KI","3","1","1","សាដាច់ សាឡូម៉ូន អ្យក់ គន សាដាច់ ប៉ាថេត អ៊ីស៊ីប ប៉្រគ័ កាម៉ាញ់ អ៊ែ ភឿ ប៉្រគ័ គួប លូ សាដាច់ អ៊ីស៊ីប។ អ៊ែ កា អ្យក់ កាម៉ាញ់ ឡាំ ប៉ាគ់ ស្រុក តេះ សាដាច់ ដាវីត អ្វៃ លើយ ទឹល អ៊ែ កេះ ប៉្រគ័ ហី អ៊ែ ទៅ លូ កេះ ប៉្រគ័ រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ លូ ប៉ាន់ទៀយ ជុំ មឿង យេរូសាឡឹម។ ");
INSERT INTO tpu_vpl VALUES ("K13_2","012_3_2","1KI","3","2","2","ផះ ណោះ មួត ប៉ាសុន ឃើយ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ពឹង ចារ ប៉ាឌួល អន់ទៀគៗ ខង ផះ ណោះ ពូ បើ តាន័ ប៉្រគ័ រ៉ោង រ៉ាម៉ះ សាំរ៉ាប់ ចារ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K13_3","012_3_3","1KI","3","3","3","សាដាច់ សាឡូម៉ូន ប៉ិច ចៃ កា ប‌៉្រ័ះ ប៊កកាតយ័ ខាក់ ទឹប អ៊ែ ប៉្រគ័ ពួយ ប៉ានឹរ ពឹ អ៊ែ អន់តគ់ ប៉ាតោ ហះកា អ៊ែ ឡាំ ប៉ាគ់ ចារ ប៉ាឌួល លើយៗ ភឿ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ លូ សុះ តាំងហ៊ុម។ ");
INSERT INTO tpu_vpl VALUES ("K13_4","012_3_4","1KI","3","4","4","សាដាច់ សាឡូម៉ូន កា ឡាំ ប៉ាគ់ មឿង គីបៀន ចឹង ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ខង ប៉ាគ់ ណោះ ទី ចារ ប៉ាឌួល ឡាក់ សាំខាន់ ខាក់ សាំរ៉ាប់ រ៉ាម៉ះ ប‌៉្រ័ះ។ សាដាច់ សាឡូម៉ូន ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ១០០០ កាតុ ពុះ អ្លាត ទិណោ័ះ ពឹង អន់ហ្នឹង ប៉ាគ់ ចារ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K13_5","012_3_5","1KI","3","5","5","ផះ អ៊ែ អ្វៃ ប៉ាគ់ មឿង គីបៀន ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ លូ អ៊ែ កាណុង សារ អំប៉ោ ផះ កាម៉ាំង។ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ផា «ផា អីស ប៉ិច កា កាណាគ័ ញ៉ា ហគ់ ប៉រ់ ពិ ណោះ អាញ់ ចឹង អន់»។ ");
INSERT INTO tpu_vpl VALUES ("K13_6","012_3_6","1KI","3","6","6","សាដាច់ សាឡូម៉ូន តើល ផា «អីស តាំបាង ពុត ប៉ិច ចៃ កា ពឹ អាញ់ សាដាច់ ដាវីត ពែ ខង អ៊ែ ប៉្រគ័ សារ ដាគ់ លូ ទី ពុត ដាគ់ ត្រង់ ហះ ម៉ាត់ អីស។ អីស កា អ្វៃ តាំបាង ពុត ប៉ិច ចៃ កា អ៊ែ លើយ បះ អីស អន់ អាញ់ ឡាក់ គន អ៊ែ ប៉្រគ័ សាដាច់ ប៉ាតាង អ៊ែ ឡាក់ កា រ៉ប់ ដារ់ អា។ ");
INSERT INTO tpu_vpl VALUES ("K13_7","012_3_7","1KI","3","7","7","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អាញ់ អីស អន់ អាញ់ ហាវ ប៉្រគ័ សាដាច់ ប៉ាតាង ពឹ អាញ់ ហះកា អាញ់ អ្វៃ សាស្វា បើ អ្លុ រ៉ាំងហៃ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K13_8","012_3_8","1KI","3","8","8","ប៉ាសុន ឡាក់ អីស ទី រ៉ើស ឡាក់ អាញ់ ត្រគ់ ណាំផា អា អន់ឌែ អៀង ខាក់ អូ ដាម័ យ៉ាប អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K13_9","012_3_9","1KI","3","9","9","ញន ណោះ ហង ប៉រ់ អីស អន់ ពុត ហ្យាំង សាឡាច់ កា អាញ់ ម៉ាគ់ អាញ់ រ៉ាំងហៃ ប៉ាសុន អីស ទឹប អន់ អាញ់ អ្លុ ឃឹត ចាជ្រែប ឡឹង សារ យច សារ ត្រគ់។ ផា អីស អូ អន់ សារ ហ្យាំង សាឡាច់ អូ ទី ពឿ ចឹង អ្លុ រ៉ាំងហៃ ប៉ាសុន អីស ឡាក់ អៀង ខាក់ អា អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("K13_10","012_3_10","1KI","3","10","10","ត្រគ់ ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ខាក់ សារ សាដាច់ សាឡូម៉ូន ប៉រ់ ឡឹង អ៊ែ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K13_11","012_3_11","1KI","3","11","11","អ៊ែ រ៉ះ កា សាឡូម៉ូន ផា «អីស អូ ប៉រ់ អន់ ទី អាញុ រ៉ីស ទុញ លូ រ៉ាស អំប៉ាស អន់ អៀង ខាក់ លូ អីស អូ ប៉រ់ អន់ តាម៉ឺរ អីស អន់ តោ័ រ៉ាយ តោ័ រ៉ុង អុះ ហះកា អីស ប៉រ់ សារ ហ្យាំង សាឡាច់ ម៉ាគ់ អ្លុ ឃឹត ចាជ្រែប ឡឹង សារ ដាគ់ ត្រគ់។ ");
INSERT INTO tpu_vpl VALUES ("K13_12","012_3_12","1KI","3","12","12","ទឹល នីណោ័ះ អាញ់ ចឹង ប៉្រគ័ ពួយ សារ អីស ប៉រ់ ណោះ ហង អាញ់ ចឹង អន់ អីស ហ្យាំង សាឡាច់ ទឹប ទី ពុត អ្លុ ហ្លង់ អូ ទី បក់ ពឿ ចឹង សាម៉ើ លូ អីស អុះ យ‌៉័ះ ឡឹង សើគ ពែ កាតាម យ‌៉័ះ ប៉ាគ់ ម៉ាត់ ទៀ កាតាម។ ");
INSERT INTO tpu_vpl VALUES ("K13_13","012_3_13","1KI","3","13","13","ក្វា ឡឹង ណោះ ណាវ្គ អាញ់ ចឹង អន់ កា អីស កាណាគ័ ញ៉ាៗ ឡាក់ អីស អូ ប៉រ់ ឡឹង អាញ់។ អាញ់ ចឹង អន់ អីស កេះ ប‌៉្រ័ះ ប៉ាត្រង័ ទី រ៉ាស អំប៉ាស អៀង ខាក់ លូ ប៉្រគ័ អន់ អីស លៅ លែង សិច។ ពឹង រ៉ាំងហាវ អីស អូ ទី សាដាច់ ចំ ចឹង សាម៉ើ លូ អីស អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K13_14","012_3_14","1KI","3","14","14","ម៉ោញ ណាវ្គ ផា អីស ចាក ពួយ ទ្រង អាញ់ ទឹប ប៉្រគ័ ពួយ ចាបាប់ លូ ប៉ានឹរ អាញ់ ប៉្រើ ឡាក់ កា ពឹ អីស សាដាច់ ដាវីត ពែ ណោះ អាញ់ ចឹង អន់ អីស ទី អាញុ រ៉ីស ទុញ»។ ");
INSERT INTO tpu_vpl VALUES ("K13_15","012_3_15","1KI","3","15","15","កេះណោះ សាដាច់ សាឡូម៉ូន កា សាទឹរ ឡឹង តៃប ទឹប អ្លុ អន់តគ់ ផា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ កាណុង សារ អំប៉ោ។ កេះណោះ អ៊ែ សឹត ប៉ាគ់ មឿង យេរូសាឡឹម ទឹប ឡាំ អ្វៃ ក្យាម័ ហ៊ីប សារ សាញ៉ា រែវ ពុត ឡាក់ ហ៊ីប ប‌៉្រ័ះ ប៊កកាតយ័ ផះ ណោះ អ៊ែ សាំប‌៉័ះ ប‌៉្រ័ះ។ អ៊ែ កា ពុះ អ្លាត កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ លូ ពុះ កាណាគ័ សាំរ៉ាប់ រ៉ាម៉ះ អៃត សា លូ មួត ប៉្រគ័ កាន រ៉ាតីសៗ ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("K13_16","012_3_16","1KI","3","16","16","ឡៃង ឡឹង ណោះ ទី អង់កាន់ ម៉ាលេង ពៀរ ដូវ ឡាំ ប៉ាគ់ ចារ សាដាច់ សាឡូម៉ូន ប៉្រើ អ៊ែ តាត់ស៊ិន សារ។ ");
INSERT INTO tpu_vpl VALUES ("K13_17","012_3_17","1KI","3","17","17","អង់កាន់ ម៉ោញ ដូវ រ៉ះ ផា «អឺ ពឹ តាំងឡា អាញ់ លូ អង់កាន់ អា ញឹន អ្វៃ ម៉ោញ ហី។ ផះ អ៊ែ អ្វៃ ពឹង ហី អន់ឌូ អាញ់ អ្វៃ ហាអុញ។ ");
INSERT INTO tpu_vpl VALUES ("K13_18","012_3_18","1KI","3","18","18","គន អាញ់ កើត ប៉ៃង ដារ់ កេះ អ៊ែ កា អ្វៃ ហាអុញ និះទៅ ដេល។ អ្វៃ ពឹង ហី ណោះ អូ ទី ពឿ អុះ ទី ដឹង ញឹន ពៀរ ដូវ។ ");
INSERT INTO tpu_vpl VALUES ("K13_19","012_3_19","1KI","3","19","19","ប៉ាគ់ កាម៉ាំង គន អ៊ែ ណោះ តោ័ ញន កា អ៊ែ តៃប កាតត់។ ");
INSERT INTO tpu_vpl VALUES ("K13_20","012_3_20","1KI","3","20","20","ប៉ាគ់ ទងតិគ័ ម៉ាំង ផះ អាញ់ តៃប ហ្លាក់ អ៊ែ ឡាំ ប៉ោក អ្យក់ គន អាញ់ កា អ៊ែ កេះណោះ អ្យក់ គន អ៊ែ ឡាក់ តោ័ ណោះ អន់ ហះ ង៉ីរ អាញ់ ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("K13_21","012_3_21","1KI","3","21","21","ប៉ាគ់ តារ កាំលឺ អាញ់ សាទឹរ ឡឹង តៃប។ ផះ ចឹង តាម៉ម់ គន អាញ់ ណោះ អាញ់ ប៉ប័ សាស្វា ណោះ តោ័។ អាញ់ ហៃ ប៉ាញ់ចាក័ កាខាក់ កា អ្លុ អន់តគ់ ផា អូ ត្រគ់ គន អាញ់ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("K13_22","012_3_22","1KI","3","22","22","ផះ ណោះ អង់កាន់ ម៉ោញ ណាវ្គ ណោះ ប៉ាគែក ផា «អូ ត្រគ់ គន អាញ់ អុះ ! គន អាញ់ អ្វៃ រ៉ីស គន អីស ហង បក់ តោ័ អា !» ហះកា អង់កាន់ ណោះ តើល ផា «អូ អុះ ! បក់ រ៉ីស ឃឺ គន អាញ់ បក់ តោ័ ណោះ គន អីស !» នែវ អា ហង មួត អង់កាន់ ពៀរ ដូវ ប៉ាគែក គួប សោប ហះ ង៉ីរ សាដាច់ សាឡូម៉ូន។ ");
INSERT INTO tpu_vpl VALUES ("K13_23","012_3_23","1KI","3","23","23","សាដាច់ សាឡូម៉ូន កាប ផា «អន់ដីស ពៀរ ដូវ អា ម៉ោញ ដូវ រ៉ះ ផា \"គន អាញ់ អ្វៃ រ៉ីស គន អីស តោ័\" ម៉ោញ ដូវ ផា \"អូ ត្រគ់ អុះ គន អាញ់ ហង អ្វៃ រ៉ីស អា គន អីស តោ័ ណោះ\"»។ ");
INSERT INTO tpu_vpl VALUES ("K13_24","012_3_24","1KI","3","24","24","អ៊ែ កា ប៉្រើ ពូ ផា «ប៉ឹះ អ្យក់ ដាវ កា អាញ់ ប៉ាគ់ អា ហៃ»។ ពូ កា អ្យក់ ដាវ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("K13_25","012_3_25","1KI","3","25","25","អ៊ែ កា រ៉ះ ណាវ្គ ផា «ហគ់ ច្រះ សាស្វា បក់ អ្វៃ រ៉ីស អា អន់ ទី ពៀរ ចានែក កេះណោះ អន់ ម៉ោញ ដូវ ទងតិគ័ ម៉ោញ ដូវ ទងតិគ័ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("K13_26","012_3_26","1KI","3","26","26","មើគ សាស្វា បក់ អ្វៃ រ៉ីស ណោះ អ៊ែ ឡិ ណូស ស្រូគ កាខាក់ ឡូត អ៊ែ កា តើល សាដាច់ ផា «អឺ ពឹ តាំងឡា អាញ់ ប៉រ់ ឡោម ឡា អីស ជែ ប៉ាន់តោ័ ហង គន សាស្វា អា។ អន់ កា អ៊ែ ពិ»។ កាប៉ាច់ អង់កាន់ ម៉ោញ ណាវ្គ ណោះ តើល ផា «ហគ់ ច្រះ ពិ អីស ប៉្រគ័ នីណោ័ះ ដាគ់ ហង អាញ់ កា អូ ទី អ៊ែ កា អូ ទី ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("K13_27","012_3_27","1KI","3","27","27","ទឹល នីណោ័ះ សាដាច់ រ៉ះ ផា «ហគ់ អន់ គន សាស្វា បក់ អ្វៃ រ៉ីស អា កា អង់កាន់ បក់ រ៉ះ អន់ទ្រួល ណោះ ពិ ជែ ប៉ាន់តោ័ ហង សាស្វា អា ខង អង់កាន់ អា ហង មើគ អ៊ែ តាទឹច»។ ");
INSERT INTO tpu_vpl VALUES ("K13_28","012_3_28","1KI","3","28","28","មួត ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ កាតាំង លៅ ឡឹង សារ សាដាច់ សាឡូម៉ូន តាត់ស៊ិន សារ ណោះ អន់ឌែ ទិឌូ កា អ្យិល កូត័ អ្យូគ កា សាដាច់ សាឡូម៉ូន ខង អន់ឌែ អ្លុ អន់តគ់ ផា សាដាច់ សាឡូម៉ូន អ្លុ តាត់ស៊ិន សារ ណោះ ដាគ់ ត្រគ់ ញន កា ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ហ្យាំង សាឡាច់ កា អ៊ែ។ … ");
INSERT INTO tpu_vpl VALUES ("K16_1","012_6_1","1KI","6","1","1","សាដាច់ សាឡូម៉ូន ប៉្រគ័ រ៉ោង រ៉ាម៉ះ ផះ រ៉ាំងវ៉ាង សាណាំ ៤៨០ ឡៃង ឡឹង ប៉ាសុន អ៊ីស្រាអ៊ែល ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ពឹង សាណាំ ទី ៤ ផះ សាដាច់ សាឡូម៉ូន រ៉ាំងហៃ សុនសាត អ៊ីស្រាអ៊ែល។ ត្រគ់ ផះ ខៃ ២ អ៊ែ ប៉ាន់ដា ប៉្រគ័ រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("K16_2","012_6_2","1KI","6","2","2","រ៉ោង រ៉ាម៉ះ ឡាក់ សាដាច់ សាឡូម៉ូន ប៉្រគ័ កា ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ អំពុ អ្លឹង ៦០ ហាត់ អំពុ តីស ២០ ហាត់ ចាំងហីគ ៣០ ហាត់។ ");
INSERT INTO tpu_vpl VALUES ("K16_3","012_6_3","1KI","6","3","3","ហប់ រ៉ោង រ៉ាម៉ះ ណោះ អំពុ អ្លឹង ១០ ហាត់ អំពុ តីស ២០ ហាត់ សាម៉ើ លូ អំពុ តីស រ៉ោង រ៉ាម៉ះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K16_4","012_6_4","1KI","6","4","4","អ៊ែ ប៉្រើ ពូ ប៉្រគ័ រ៉ាំបោះ ទឹប ប៉្រគ័ ច្រើយ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K16_5","012_6_5","1KI","6","5","5","អ៊ែ ប៉្រើ ពូ ប៉្រគ័ កាណុង ថិៗ ជុំ ប៉ាណីរ គែង ឡីង រ៉ោង រ៉ាម៉ះ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K16_6","012_6_6","1KI","6","6","6","កាណុង ថិៗ ណោះ ទី ប៉ៃង តាល់ តាល់ គែង កាន់តេ័ះ អំពុ តីស ៥ ហាត់ តាល់ អន់តិគ័ អំពុ តីស ៦ ហាត់ តាល់ គែង អំប៉ាំង អំពុ តីស ៧ ហាត់។ ប៉ាណីរ គែង ឡីង រ៉ោង រ៉ាម៉ះ អូ សាម៉ើ អុះ ពូ ប៉្រគ័ នីណោ័ះ ភឿ ចៃគ អំប៉ង់ ជែ អន់ បោះ ប៉ាណីរ។ ");
INSERT INTO tpu_vpl VALUES ("K16_7","012_6_7","1KI","6","7","7","ពូ ប៉្រគ័ រ៉ោង រ៉ាម៉ះ ណោះ ប៉្រគ័ លូ អំហ្មោ ពូ ផាត អន់ទ្រួល កេះ ញន ណោះ ហង បះ ផះ ពូ ប៉្រគ័ រ៉ោង ណោះ អូ កាតាំង រ៉ាយ៉ាគ់ ប៉ាសយ់ លើ ឃឿង ខង ញ៉ា ពឹង រ៉ោង រ៉ាម៉ះ ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K16_8","012_6_8","1KI","6","8","8","ទី អំប៉ារ ម៉ុត ពឹង តាល់ ទី ពៀរ គែង សាម៉ា រ៉ោង រ៉ាម៉ះ ទឹប ទី ជុង កឺង ហាវ ពឹង តាល់ ទី ពៀរ កេះណោះ ហាវ ពឹង តាល់ ទី ប៉ៃង ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("K16_9","012_6_9","1KI","6","9","9","សាដាច់ សាឡូម៉ូន ប៉្រគ័ ប៉ាណីរ រ៉ោង រ៉ាម៉ះ កេះ ទិ កេះ។ កេះណោះ អ៊ែ ប៉្រើ ពូ ប៉្រគ័ អន់តល័ ទឹប ម៉ាល់ ទឹប ប៉្រោក ប៉្រគ័ លូ អ៊្លង កាញូង។ ");
INSERT INTO tpu_vpl VALUES ("K16_10","012_6_10","1KI","6","10","10","កាណុង ថិៗ ពូ ប៉្រគ័ ជុំ ណោះ ពែ កាណុង ម៉ោញៗ ចាំងហីគ ៥ ហាត់ កាណុង ទិណោ័ះ ទី អំប៉ង់ ប៉្រគ័ លូ អ៊្លង កាញូង ទឹះ លូ ប៉ាណីរ រ៉ោង រ៉ាម៉ះ។ ");
INSERT INTO tpu_vpl VALUES ("K16_11","012_6_11","1KI","6","11","11","ផះ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ លូ សាដាច់ សាឡូម៉ូន ផា ");
INSERT INTO tpu_vpl VALUES ("K16_12","012_6_12","1KI","6","12","12","«អីស ផះ ប៉្រគ័ រ៉ោង រ៉ាម៉ះ កា អាញ់ ដាគ់ ហង ផា អីស ប៉្រគ័ ពួយ ចាបាប់ លូ សារ អន់តគ់ ប៉ាតោ ប៉្រោ ទឹប ឡាក់ អាញ់ រ៉ះ ណោះ អាញ់ ចឹង ប៉្រគ័ ដាគ់ កា អីស ឡាក់ កា អាញ់ សាញ៉ា លូ ពឹ អីស សាដាច់ ដាវីត ពែ។ ");
INSERT INTO tpu_vpl VALUES ("K16_13","012_6_13","1KI","6","13","13","អាញ់ ចឹង អ្វៃ លូ សុនសាត អ៊ីស្រាអ៊ែល ទឹប អូ អ្លាត អន់ឌែ ឡាក់ ប៉ាសុន អាញ់ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("K16_14","012_6_14","1KI","6","14","14","សាដាច់ សាឡូម៉ូន ប៉្រគ័ រ៉ោង កេះ ប៉ាណីរ លូ អន់តល័ ");
INSERT INTO tpu_vpl VALUES ("K16_15","012_6_15","1KI","6","15","15","កេះណោះ អ៊ែ កា ប៉្រើ ពូ ប៉្រគ័ ប៉ាណីរ គែង កាណុង រ៉ោង រ៉ាម៉ះ លូ ប៉ាតាគ់ អ៊្លង កាញូង ប៉ាញ័ ទឹប ណោះ ឡឹង តេះ ទឹល អន់តល័ ពូ កា ប៉្រគ័ រ៉ានែ លូ អ៊្លង កាទៀង។ ");
INSERT INTO tpu_vpl VALUES ("K16_16","012_6_16","1KI","6","16","17","គែង កាណុង រ៉ោង រ៉ាម៉ះ អ៊ែ ប៉្រើ ពូ ប៉្រគ័ កាណុង ពៀរ។ ប៉ាតាគ់ ពូ ប៉ិង ប៉្រគ័ លូ អ៊្លង កាញូង ឡឹង តេះ ទឹល អន់តល័។ កាណុង គែង ម៉ាត់ អំពុ អ្លឹង ៤០ ហាត់។ កាណុង គែង អំពុត អំពុ អ្លឹង ២០ ហាត់ កាណុង ណោះ ហង ពូ អើ ផា កាណុង ដាគ់ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("K16_18","012_6_18","1KI","6","18","18","ពឹង ប៉ាណីរ ពូ ប៉ិង លូ អ៊្លង កាញូង ណោះ ពូ ផាត ប៉្រគ័ ហ៊ូប គៀត លូ ហ៊ូប ប៉ាកាវ ឡាក។ ប៉ាណីរ គែង កាណុង ប៉្រគ័ លូ អ៊្លង កាញូង ប៉ាញ័ ទឹប ណោះ អូ អន់ ប៉ប័ ប៉ាណីរ ប៉្រគ័ លូ អំហ្មោ ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K16_19","012_6_19","1KI","6","19","19","អ៊ែ ប៉្រើ ពូ ប៉្រគ័ កាណុង ដាគ់ កាខាក់ សាំរ៉ាប់ ចៃគ ហ៊ីប សារ សាញ៉ា រែវ ពុត ឡាក់ ហ៊ីប ម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("K16_20","012_6_20","1KI","6","20","20","កាណុង ដាគ់ កាខាក់ ណោះ អំពុ អ្លឹង ២០ ហាត់ អំពុ តីស ២០ ហាត់ ចាំងហីគ ២០ ហាត់ និះទៅ ដេល។ ពូ កា ប៉្រះ ចារ័ ម៉ាស ង៉ាតៗ ប៉ាញ័ ទឹប ណោះ។ អន់ហ្នឹង ពូ ប៉្រគ័ លូ អ៊្លង កាញូង កា ប៉្រះ ចារ័ ម៉ាស និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K16_21","012_6_21","1KI","6","21","21","សាដាច់ សាឡូម៉ូន កា ប៉្រើ ពូ ប៉្រះ ចារ័ ម៉ាស ង៉ាតៗ ប៉ាញ័ ទឹប កាណុង ណោះ ទឹប អ្យក់ ច្រ្វាល់ ម៉ាស កត់ ហះ ទ្រង ម៉ុត ");
INSERT INTO tpu_vpl VALUES ("K16_22","012_6_22","1KI","6","22","22","កេះណោះ ពូ ប៉្រះ ចារ័ ម៉ាស ប៉ាញ័ ទឹប គែង កាណុង រ៉ោង រ៉ាម៉ះ ណោះ អន់ហ្នឹង កា ប៉្រះ ចារ័ ម៉ាស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K16_23","012_6_23","1KI","6","23","23","ពឹង កាណុង ដាគ់ កាខាក់ ណោះ សាដាច់ សាឡូម៉ូន កា ប៉្រើ ពូ ប៉្រគ័ ហ៊ូប ចេរូប៊ីន ពៀរ កាតុ លូ អ៊្លង ប៉ុង ចាំងហីគ ១០ ហាត់។ ");
INSERT INTO tpu_vpl VALUES ("K16_24","012_6_24","1KI","6","24","24","កាហ្លាប ចេរូប៊ីន ម៉ោញ ប៊ែង ៥ ហាត់ ម៉ោញ ប៊ែង ៥ ហាត់ ទិ ពៀរ ប៊ែង ណោះ ១០ ហាត់។ ");
INSERT INTO tpu_vpl VALUES ("K16_25","012_6_25","1KI","6","25","25","ចេរូប៊ីន ទិ ពៀរ កាតុ ណោះ ត្រង័ ទ្រៀយ និះទៅ តីស ថិ កា និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K16_26","012_6_26","1KI","6","26","26","ចេរូប៊ីន ទី ម៉ោញ ចាំងហីគ ១០ ហាត់ ទី ពៀរ កា សាម៉ើ ទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K16_27","012_6_27","1KI","6","27","27","សាដាច់ សាឡូម៉ូន កា ប៉្រើ ពូ ចៃគ ហ៊ូប ចេរូប៊ីន ទិ ពៀរ ពឹង កាណុង ដាគ់ កាខាក់ ចេរូប៊ីន ទិ ពៀរ កា ប៉ាហ្យាង កាហ្លាប ឃឺ ឡាណុច កាហ្លាប ចេរូប៊ីន ទី ម៉ោញ ឡាង ទឹះ លូ ប៉ាណីរ ម៉ោញ ប៊ែង កាហ្លាប ចេរូប៊ីន ទី ពៀរ កា ទឹះ លូ ប៉ាណីរ ម៉ោញ ប៊ែង ណាវ្គ។ កាហ្លាប ម៉ោញ ប៊ែង ណាវ្គ កា ទឹះ លូ កាហ្លាប គួប អន់ឌែ ត្រង់ ហះ អន់តិគ័ កាណុង ដាគ់ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("K16_28","012_6_28","1KI","6","28","28","សាដាច់ សាឡូម៉ូន កា ប៉្រើ ពូ ប៉្រះ ចារ័ ម៉ាស ពឹង ហ៊ូប ចេរូប៊ីន ទិ ពៀរ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K16_29","012_6_29","1KI","6","29","29","ពឹង ប៉ាណីរ រ៉ោង រ៉ាម៉ះ ណោះ សាដាច់ សាឡូម៉ូន ប៉្រើ ពូ ផាត ប៉្រគ័ ហ៊ូប ចេរូប៊ីន លូ ហ៊ូប តើម រ៉ាសៃ ទឹប ផាត ប៉្រគ័ ហ៊ូប ប៉ាកាវ ឡាក ពឹង កាណុង ដាគ់ លូ កាណុង ដាគ់ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("K16_30","012_6_30","1KI","6","30","30","ប៉ាតាគ់ រ៉ានែ រ៉ោង រ៉ាម៉ះ ណោះ ពូ ប៉្រះ ចារ័ ម៉ាស ទឹប ពឹង កាណុង ដាគ់ លូ កាណុង ដាគ់ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("K16_31","012_6_31","1KI","6","31","31","ទ្រង ម៉ុត ពឹង កាណុង ដាគ់ កាខាក់ ណោះ សាដាច់ សាឡូម៉ូន ប៉្រើ ពូ ប៉្រគ័ អំប៉ារ ពៀរ ប៉ក់ លូ អ៊្លង ប៉ុង អ៊្លង អ៊ប អំប៉ារ ណោះ ទី ប៉ាតាម័ កាតុ។ ");
INSERT INTO tpu_vpl VALUES ("K16_32","012_6_32","1KI","6","32","32","អំប៉ារ ណោះ ពូ ប៉្រគ័ លូ អ៊្លង ប៉ុង សាដាច់ សាឡូម៉ូន កា ប៉្រើ ពូ ផាត ប៉្រគ័ ហ៊ូប ចេរូប៊ីន លូ តើម រ៉ាសៃ ទឹប ហ៊ូប ប៉ាកាវ ឡាក ពឹង អំប៉ារ ណោះ កេះណោះ ប៉្រះ ចារ័ ម៉ាស ពឹង អំប៉ារ ទឹប ពឹង ហ៊ូប ចេរូប៊ីន លូ ហ៊ូប តើម រ៉ាសៃ។ ");
INSERT INTO tpu_vpl VALUES ("K16_33","012_6_33","1KI","6","33","33","អំប៉ារ រ៉ោង រ៉ាម៉ះ ណោះ សាដាច់ សាឡូម៉ូន ប៉្រើ ពូ ប៉្រគ័ អ៊្លង អ៊ប អំប៉ារ លូ អ៊្លង ប៉ុង។ អ៊្លង អ៊ប អំប៉ារ ណោះ ទី ប៉្វាន់ កាតុ។ ");
INSERT INTO tpu_vpl VALUES ("K16_34","012_6_34","1KI","6","34","34","ទី អំប៉ារ ពៀរ ពូ ប៉្រគ័ លូ អ៊្លង កាទៀង អំប៉ារ ម៉ោញៗ ទី ពៀរ ប៉ាហាក ទឹប អ្លុ សាគុត ទិ ពៀរ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K16_35","012_6_35","1KI","6","35","35","ពឹង អំប៉ារ ទិ ពៀរ ប៉ក់ ណោះ សាដាច់ សាឡូម៉ូន ប៉្រើ ពូ ផាត ប៉្រគ័ ហ៊ូប ចេរូប៊ីន លូ ហ៊ូប តើម រ៉ាសៃ ទឹប ផាត ប៉្រគ័ ហ៊ូប ប៉ាកាវ ឡាក ទឹប ប៉្រះ ចារ័ ម៉ាស អន់ ត្រគ់ លូ ហ៊ូប ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("K16_36","012_6_36","1KI","6","36","36","កេះណោះ សាដាច់ សាឡូម៉ូន ប៉្រើ ពូ ប៉្រគ័ ឡាន រ៉ោង រ៉ាម៉ះ ពូ ប៉្រគ័ រ៉ាំប៊ង លូ អំហ្មោ ពូ ផាត ប៉ៃង តាល់ លូ អ៊្លង កាញូង ម៉ោញ តាល់។ ");
INSERT INTO tpu_vpl VALUES ("K16_37","012_6_37","1KI","6","37","37","ផះ សាណាំ ទី ៤ ខៃ ២ ផះ រ៉ាំងហាវ សាដាច់ សាឡូម៉ូន រ៉ាំងហៃ ប៉ាថេត ពូ ចៃគ អំហ្មោ ទ្រង កាន់តេ័ះ រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("K16_38","012_6_38","1KI","6","38","38","ផះ សាណាំ ទី ១១ ខៃ ៨ ពូ ប៉្រគ័ រ៉ោង រ៉ាម៉ះ កេះ ទិណោ័ះ ពួយ ផិនកាន សាដាច់ សាឡូម៉ូន ណោះ ហង។ ពូ ប៉្រគ័ រ៉ោង រ៉ាម៉ះ ណោះ ទុញ តាំប៉ើះ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("K17_51","012_7_51","1KI","7","51","51","សាដាច់ សាឡូម៉ូន ប៉្រគ័ រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ កេះ ទិ កេះ។ កេះណោះ អ៊ែ អញ់ជូន ម៉ុត កាណាគ័ ឡាក់ កា ម៉ាស ប៉្រាក់ លូ ឃឿង ខង អន់ទៀគៗ ឡាក់ ពឹ អ៊ែ សាដាច់ ដាវីត មប កា ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ អន់ កាណាគ័ ទិណោ័ះ កាណុង ចារ រ៉ាន់ដាប់ រ៉ាស អំប៉ាស ពឹង រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K18_1","012_8_1","1KI","8","1","2","ផះ ខៃ ៧ ប៉ាសុន អ៊ីស្រាអ៊ែល ឡាំ ប៉ាគ់ មឿង យេរូសាឡឹម ភឿ ប៉្រគ័ ប៊ុន រ៉ាណើះ។ ផះ ណោះ សាដាច់ សាឡូម៉ូន អើ ប៉ាតុំ មួត ក្រាគ់ ណាំផា ផូង័ លូ ក្រាគ់ ហី ទិណោ័ះ ម៉ាគ់ ចឹង តូង័ ហ៊ីប សារ សាញ៉ា រែវ ពុត ឡឹង ស្រុក តេះ សាដាច់ ដាវីត ឡាក់ អ្វៃ ពឹង ប៉ានឹម ស៊ីយ៉ូន អ្យក់ ម៉ុត ពឹង រ៉ោង រ៉ាម៉ះ ។ ");
INSERT INTO tpu_vpl VALUES ("K18_3","012_8_3","1KI","8","3","3","ប៉ាគ់ មួត ក្រាគ់ តាំងកង់ ឡាំ ទឹល កេះ មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ កា តូង័ ហ៊ីប ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K18_4","012_8_4","1KI","8","4","4","មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ទឹប មួត លេវី កា តូង័ ហ៊ីប ប‌៉្រ័ះ ប៊កកាតយ័ លូ តូង័ រ៉ាណើះ ឡាក់ ចារ ពូ រ៉ាម៉ះ ប‌៉្រ័ះ ពែ ទឹប ឃឿង ខង សាំរ៉ាប់ ប៉្រគ័ ង៉ារ ប‌៉្រ័ះ ទិណោ័ះ ឡាក់ អ្វៃ ពឹង រ៉ាណើះ ណោះ ពែ កា អ្យក់ ឡាំ ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("K18_5","012_8_5","1KI","8","5","5","សាដាច់ សាឡូម៉ូន លូ ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ ឡាក់ ប៉ាតុំ គួប ហះ ម៉ាត់ សាដាច់ អន់ឌែ អន់តាវ ហះ ចារ ហ៊ីប ណោះ។ អន់ឌែ អ្យក់ ចៀម លូ រ៉ក់ អៀង ខាក់ អូ ដាម័ យ៉ាប ភឿ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("K18_6","012_8_6","1KI","8","6","6","កេះណោះ មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ កា អ្យក់ ម៉ុត ហ៊ីប សារ សាញ៉ា រែវ ពុត ពឹង កាណុង ដាគ់ កាខាក់ អន់ កាន់តេ័ះ កាហ្លាប ចេរូប៊ីន។ ");
INSERT INTO tpu_vpl VALUES ("K18_7","012_8_7","1KI","8","7","7","ចេរូប៊ីន ទិ ពៀរ ប៉ាហ្យាង កាហ្លាប អំប៉ាំង ចារ ពូ ចៃគ ហ៊ីប ភឿ កាន់ទឹង ហ៊ីប លូ អ៊្លង តាណូង័ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K18_8","012_8_8","1KI","8","8","8","ញន កា អ៊្លង តាណូង័ ណោះ អ្លឹង តាឡាម័ ក្លាច់ គែង កាណុង ដាគ់ ពូ កា ហៃ ប៉ប័ ដេល ហះកា ឡឹង ឡីង ពូ ហៃ អូ ប៉ប័ អុះ។ អ៊្លង ណោះ អ្វៃ ស្រូ ពឹង ហ៊ីប លើយ ទឹល រ៉ប់ ដារ់ អា។ ");
INSERT INTO tpu_vpl VALUES ("K18_9","012_8_9","1KI","8","9","9","កាណុង ហ៊ីប ណោះ ទី ដឹង អំហ្មោ ឡាត ពៀរ ឡាក់ វគ័ ម៉ូសេ ចៃគ ពឹង ណោះ ផះ អ្វៃ ប៉ាគ់ ប៉ានឹម ស៊ីណាយ ផះ ប‌៉្រ័ះ ប៊កកាតយ័ សាញ៉ា រែវ ពុត លូ ប៉ាសុន អ៊ីស្រាអ៊ែល ឡៃង ឡឹង អន់ឌែ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("K18_10","012_8_10","1KI","8","10","10","ផះ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ឡាច់ ឡឹង កាណុង ដាគ់ ផាឌី ទី កាម៉ល់ ប៉ាញ័ ពឹង រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("K18_11","012_8_11","1KI","8","11","11","ញន កាម៉ល់ ណោះ បះ មួត ក្រាគ់ រ៉ាម៉ះ អូ អ្លុ ម៉ុត ប៉្រគ័ ង៉ារ រ៉ាម៉ះ ប‌៉្រ័ះ ណាវ្គ អុះ ខង តាតារ ក្លាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាញ័ ទឹប រ៉ោង រ៉ាម៉ះ។ ");
INSERT INTO tpu_vpl VALUES ("K18_12","012_8_12","1KI","8","12","12","ផះ ណោះ សាដាច់ សាឡូម៉ូន ម៉ន់ ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័  អីស រ៉ះ ផា អីស ចឹង អ្វៃ ពឹង កាម៉ល់ ឡាក់ ម៉ូ ម៉ិត។ ");
INSERT INTO tpu_vpl VALUES ("K18_13","012_8_13","1KI","8","13","13","អាញ់ ប៉្រគ័ រ៉ោង រ៉ាម៉ះ ឡាក់ ដាគ់ កាខាក់ អា អន់ កា អីស អ្វៃ ពឹង អា លើយ»។ ");
INSERT INTO tpu_vpl VALUES ("K18_14","012_8_14","1KI","8","14","14","កេះណោះ សាដាច់ សាឡូម៉ូន កាលែង ហៃ គែង ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ ឡាក់ អន់តាវ ហះ ណោះ ទឹប ប៉រ់ សារ ដាគ់ កា ពូ ទិឌូ។ ");
INSERT INTO tpu_vpl VALUES ("K18_15","012_8_15","1KI","8","15","15","អ៊ែ កាប ផា «ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល អ៊ែ តាំបាង សារ អំរ៉ាញ អឺញ ភឿ តាគ់ អង់កេះ សារ អ៊ែ សាញ៉ា លូ ពឹ អាញ់ សាដាច់ ដាវីត ");
INSERT INTO tpu_vpl VALUES ("K18_16","012_8_16","1KI","8","16","16","ផះ ណោះ ពែ ប‌៉្រ័ះ រ៉ះ ផា \"ឡៃង ឡឹង ដារ់ អាញ់ ប៉ាណាំ អ៊ីស្រាអ៊ែល ឡាក់ ប៉ាសុន អាញ់ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ពែ អាញ់ បើ រ៉ើស មឿង ចំ កាណុង ព្រី ទៀក ផូង័ វ៉ាច់ អន់ឌែ អ្វៃ អា អុះ ម៉ាគ់ អន់ឌែ ប៉្រគ័ រ៉ោង រ៉ាម៉ះ សាំរ៉ាប់ ចារ ប៉ានេ អាញ់ ហះកា អាញ់ រ៉ើស ដាវីត ប៉្រើ ប៉្រគ័ ម៉ៃគ រ៉ាំងហៃ អ៊ីស្រាអ៊ែល ឡាក់ ប៉ាសុន អាញ់\"។ ");
INSERT INTO tpu_vpl VALUES ("K18_17","012_8_17","1KI","8","17","17","សាដាច់ ដាវីត ឡាក់ ពឹ អាញ់ ឃឹត ចឹង ប៉្រគ័ រ៉ោង រ៉ាម៉ះ សាំរ៉ាប់ ចារ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល ");
INSERT INTO tpu_vpl VALUES ("K18_18","012_8_18","1KI","8","18","18","ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា ពឹ អាញ់ ផា \"អីស ប៉ិច ប៉្រគ័ រ៉ោង រ៉ាម៉ះ សាំរ៉ាប់ ចារ ប៉ានេ អាញ់ ណោះ ដាគ់ កាខាក់ ហង ");
INSERT INTO tpu_vpl VALUES ("K18_19","012_8_19","1KI","8","19","19","ហះកា អូ ត្រគ់ អីស អុះ ឡាក់ ចឹង ប៉្រគ័ រ៉ោង រ៉ាម៉ះ ណោះ។ គន អីស ទៅ ណោះ ហង ចឹង ប៉្រគ័ រ៉ោង រ៉ាម៉ះ សាំរ៉ាប់ ចារ ប៉ានេ អាញ់\"។ ");
INSERT INTO tpu_vpl VALUES ("K18_20","012_8_20","1KI","8","20","20","កិញអៀ អា ប‌៉្រ័ះ ប៊កកាតយ័ តាគ់ អង់កេះ សារ អ៊ែ សាញ៉ា ណោះ ពែ អ៊ែ អន់ អាញ់ ហាវ ប៉្រគ័ សាដាច់ ប៉ាតាង ពឹ អាញ់ សាដាច់ ដាវីត អាញ់ រ៉ាំងហៃ សុនសាត អ៊ីស្រាអ៊ែល ត្រគ់ ពួយ សារ អ៊ែ សាញ៉ា ពែ ហង អាញ់ កា ប៉្រគ័ រ៉ោង រ៉ាម៉ះ អា សាំរ៉ាប់ ចារ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("K18_21","012_8_21","1KI","8","21","21","អាញ់ ប៉្រគ័ ចារ ម៉ោញ សាំរ៉ាប់ កា ហ៊ីប សារ សាញ៉ា រែវ ពុត ពឹង ហ៊ីប ណោះ ហង វគ័ ម៉ូសេ ចៃគ អំហ្មោ ឡាត ពៀរ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ច្រាគ់ គម សារ សាញ៉ា រែវ ពុត ឡាក់ អ៊ែ សាញ៉ា លូ វគ័ យ៉ាគ់ ពិន ផះ អ៊ែ ប៉ាណាំ អន់ឌែ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ពែ»។ ");
INSERT INTO tpu_vpl VALUES ("K18_22","012_8_22","1KI","8","22","22","កេះណោះ សាដាច់ សាឡូម៉ូន លូ ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ កា អន់តាវ ហះ ង៉ីរ អន់ហ្នឹង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័  អ៊ែ កា លឺក តី ពឹង ចាំងហីគ ទឹប ម៉ន់ ផា ");
INSERT INTO tpu_vpl VALUES ("K18_23","012_8_23","1KI","8","23","23","«អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល អូ ទី ប‌៉្រ័ះ ចំ ឡាក់ កា អីស អុះ យ‌៉័ះ អ្វៃ ពឹង ប៉្លៃង លើ ពឹង តេះ កាតាម អីស ប៉្រគ័ ពួយ សារ អីស សាញ៉ា រែវ ពុត ទឹប អីស តាំបាង ពុត ប៉ិច ចៃ កា ទុច អីស ឡាក់ រ៉ាប់ សឿ អីស ទិ ពុត ទិ ពៀក។ ");
INSERT INTO tpu_vpl VALUES ("K18_24","012_8_24","1KI","8","24","24","អីស ប៉្រគ័ ពួយ ប៉ានឹរ អីស សាញ៉ា លូ សាដាច់ ដាវីត ឡាក់ ពឹ អាញ់។ ដារ់ អា អីស តាគ់ អង់កេះ សារ អីស សាញ៉ា ញន សារ អំរ៉ាញ អឺញ អីស។ ");
INSERT INTO tpu_vpl VALUES ("K18_25","012_8_25","1KI","8","25","25","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល កិញអៀ អា ប៉រ់ អីស ប៉្រគ័ ពួយ សារ អីស សាញ៉ា លូ សាដាច់ ដាវីត ពែ ឃឺ នីអៀ៖ ផា ផូង័ វ៉ាច់ អ៊ែ អ្យក់ ពុត ចៃគ រ៉ាប់ សឿ អីស ឡាក់ កា អ៊ែ ដេល អន់ឌែ ចឹង រ៉ាំងហៃ សុនសាត អ៊ីស្រាអ៊ែល ហះ ម៉ាត់ អីស លើយ។ ");
INSERT INTO tpu_vpl VALUES ("K18_26","012_8_26","1KI","8","26","26","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល ប៉រ់ អីស តាគ់ អង់កេះ សារ អីស សាញ៉ា លូ សាដាច់ ដាវីត ណោះ ពែ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("K18_27","012_8_27","1KI","8","27","27","«អឺ ប‌៉្រ័ះ ប៊កកាតយ័  ញ៉ា អីស ចឹង អ្លុ អ្វៃ ពឹង អង់កក់ តេះ អា ប ? ប៉្លៃង តីស ទឹប ចាំងហីគ ខាក់ ហះកា អីស អ្វៃ កា អូ បគ័ អុះ អំរ៉ាគ់ កា រ៉ោង រ៉ាម៉ះ ឡាក់ អាញ់ ប៉្រគ័ អា ថិ ឡក់ ហ៊ែង ខាក់ អីស អ្វៃ អូ បគ័។ ");
INSERT INTO tpu_vpl VALUES ("K18_28","012_8_28","1KI","8","28","28","ហះកា ប៉រ់ អីស សាំយ៉ាំង ប៉ានឹរ អាញ់ ម៉ន់ ឡោម អីស កាណុង ដារ់ អា អន់ អីស តាប៉ាប តាប៉ុន កា អាញ់ ណើ។ ");
INSERT INTO tpu_vpl VALUES ("K18_29","012_8_29","1KI","8","29","29","ប៉រ់ អីស ហៃ គែង រ៉ោង រ៉ាម៉ះ អា ទឹប កាម៉ាំង ទឹប កាដារ់ ខង អីស រ៉ះ ផា ចារ អា ហង សាំរ៉ាប់ ប៉ានេ អីស។ ផះ ចំ អាញ់ ម៉ន់ អើ អីស ហៃ គែង រ៉ោង រ៉ាម៉ះ អា ប៉រ់ អីស សាំយ៉ាំង អាញ់ ណើ។ ");
INSERT INTO tpu_vpl VALUES ("K18_30","012_8_30","1KI","8","30","30","ប៉រ់ អីស សាំយ៉ាំង សារ អាញ់ លូ ប៉ាសុន អ៊ីស្រាអ៊ែល ម៉ន់ ផះ អ្វៃ ហៃ គែង រ៉ោង រ៉ាម៉ះ អា។ ប៉រ់ អីស សាំយ៉ាំង ឡឹង ប៉្លៃង ឡាក់ ចារ អីស អ្វៃ កេះណោះ ជែ អ្យក់ យ៉ូ សារ ញឹន យច។ ");
INSERT INTO tpu_vpl VALUES ("K18_31","012_8_31","1KI","8","31","31","«ផា ទី បក់ ពឿ ប៉្រគ័ យច លូ ពូ លូ ផា ពូ ប៉្រើ អ៊ែ ម៉ត់ កេះណោះ អ៊ែ ឡាំ ម៉ត់ ហះ ង៉ីរ អន់ហ្នឹង ប៉ាគ់ ចារ រ៉ោង រ៉ាម៉ះ អា ");
INSERT INTO tpu_vpl VALUES ("K18_32","012_8_32","1KI","8","32","32","ប៉រ់ អីស សាំយ៉ាំង ឡឹង ប៉្លៃង ទឹប អីស តាត់ស៊ិន សារ កា អន់ឌែ ពៀរ ដូវ កេះណោះ អីស ចៃគ ថូត បក់ ប៉្រគ័ យច អន់ ត្រគ់ លូ សារ យច ឡាក់ អ៊ែ ប៉្រគ័ ណោះ ហង។ ប៉រ់ អីស អន់ សារ ដាគ់ កា បក់ ដាគ់ ត្រង់ ពួយ សារ ដាគ់ ឡាក់ អ៊ែ ប៉្រគ័ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K18_33","012_8_33","1KI","8","33","33","«ផា សុនសាត អ៊ីស្រាអ៊ែល ឡាក់ ប៉ាសុន អីស អន់ឌែ តាកូះ លូ តាម៉ឺរ អូ ដាម័ ញន កា អន់ឌែ ប៉្រគ័ យច ប៉ាសាំង លូ អីស ហះកា ផា អន់ឌែ ប៉ិនពែង ពុត ពៀក ម៉ន់ ឡោម អីស ទឹប ប៉ានេ អីស ពឹង រ៉ោង រ៉ាម៉ះ ");
INSERT INTO tpu_vpl VALUES ("K18_34","012_8_34","1KI","8","34","34","ទឹល នីណោ័ះ ប៉រ់ អីស សាំយ៉ាំង ឡឹង ប៉្លៃង ទឹប ជែ អ្យក់ យ៉ូ សារ យច សុនសាត អ៊ីស្រាអ៊ែល ឡាក់ ប៉ាសុន អីស ទឹប ប៉ាណាំ អន់ឌែ អន់ សឹត អ្វៃ ពឹង ប៉ាថេត អា ឡាក់ អីស អន់ កា វគ័ យ៉ាគ់ អន់ឌែ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("K18_35","012_8_35","1KI","8","35","35","«ផា ប៉្លៃង ប៉ាដាំង អូ បី ញន កា ប៉ាសុន ប៉្រគ័ សារ យច លូ អីស ហះកា ផា អន់ឌែ ម៉ន់ អើ អីស ទឹប ហៃ គែង រ៉ោង រ៉ាម៉ះ អា លូ ប៉ានេ អីស លូ អ្លាត សារ អន់ឌែ ប៉្រគ័ យច លូ អីស ");
INSERT INTO tpu_vpl VALUES ("K18_36","012_8_36","1KI","8","36","36","ប៉រ់ អីស សាំយ៉ាំង ឡឹង ប៉្លៃង ទឹប ជែ អ្យក់ យ៉ូ សារ យច សុនសាត អ៊ីស្រាអ៊ែល ឡាក់ ប៉ាសុន អីស។ ប៉រ់ អីស ប៉ាំងហៀន អន់ឌែ អន់ អ្លុ ប៉្រគ័ សារ ដាគ់ ត្រង់ ឡាក់ អន់ឌែ ត្រគ់ ប៉្រគ័ ទឹប អន់ ជឹរ ទៀក បី ពឹង ប៉ាថេត ឡាក់ អីស អន់ កា អន់ឌែ ប៉្រគ័ ប៉ាដក់ ប៉ាជៀ។ ");
INSERT INTO tpu_vpl VALUES ("K18_37","012_8_37","1KI","8","37","37","«ផា ទី សារ ឡាយ៉ិត ឡាំងវ៉ាញ់ លូ សារ អីគ ព្លុ ប៉ាញុ រ៉ាំបល់ ទឹប ពៀ កាសៃង ភែ ប៉ារ់មោ័ ទឹប ឡៃប លូ អន់ទ្រុង សា ទឹប ទី តាម៉ឺរ វ៉ិង មឿង លូ ទី សារ ប៉ាណាប អៀង នែវ កាតាម ");
INSERT INTO tpu_vpl VALUES ("K18_38","012_8_38","1KI","8","38","38","ផា ទី បក់ ពឿ កាណុង កាំឡាំង ប៉ាសុន អ៊ីស្រាអ៊ែល ម៉ន់ ឡោម ឡា អីស ញន កា អ៊ែ ថុក ពុត ពៀក ផា អ៊ែ លឺក តី គែង រ៉ោង រ៉ាម៉ះ អា ");
INSERT INTO tpu_vpl VALUES ("K18_39","012_8_39","1KI","8","39","39","ប៉រ់ អីស សាំយ៉ាំង ឡឹង ប៉្លៃង ឡាក់ ចារ អីស អ្វៃ ទឹប អីស ជែ អ្យក់ យ៉ូ សារ យច អន់ឌែ ហង។ ប៉រ់ អីស ប៉្រគ័ កា ពូ ម៉ោញ ដូវ ៗ ពួយ សារ ពូ ប៉្រគ័ លូ ពួយ សារ ញ៉ា ឡាក់ អីស ប៉ប័ កាណុង ពុត ពូ ខង ទី ដឹង អីស ហង អ្លុ អន់ហ្នាល់ ពុត ប៉ាណូស។ ");
INSERT INTO tpu_vpl VALUES ("K18_40","012_8_40","1KI","8","40","40","ប៉្រគ័ នីណោ័ះ ម៉ាគ់ អន់ឌែ អ្យិល កូត័ អ្យូគ កា អីស ឡុច អាញុ ផះ អន់ឌែ អ្វៃ ពឹង ប៉ាថេត អា ឡាក់ អីស អន់ កា វគ័ យ៉ាគ់ អន់ឌែ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("K18_41","012_8_41","1KI","8","41","41","«ម៉ោញ ណាវ្គ ផា អំហ៊្មយ ឡាក់ អូ ត្រគ់ ប៉ាសុន អ៊ីស្រាអ៊ែល អុះ អ៊ែ ពឹះ ឡឹង ប៉ាថេត ចាំងហាយ្គ ភឿ ប៉ានេ អីស ");
INSERT INTO tpu_vpl VALUES ("K18_42","012_8_42","1KI","8","42","42","(ខង ពូ ចឹង កាតាំង លៅ សិច អីស ទឹប សារ អំរ៉ាញ អឺញ កេង ខាក់ ម៉ះ អីស) ផា អ៊ែ ម៉ន់ ឡោម អីស ទឹប ហៃ គែង រ៉ោង រ៉ាម៉ះ អា ");
INSERT INTO tpu_vpl VALUES ("K18_43","012_8_43","1KI","8","43","43","ប៉រ់ អីស សាំយ៉ាំង ឡឹង ប៉្លៃង ពិ ទឹប អន់ ទិ សារ ញ៉ា ឡាក់ អ៊ែ ប៉រ់ ឡឹង អីស ម៉ាគ់ ប៉ាណូស គ្រឹប សុនសាត ពឹង អង់កក់ តេះ អា អន់ហ្នាល់ លូ អ្យិល កូត័ អ្យូគ កា អីស ឡាក់ កា ប៉ាសុន អីស អ៊ីស្រាអ៊ែល ដេល លូ ពូ ចឹង អ្លុ អន់តគ់ ផា រ៉ោង រ៉ាម៉ះ ឡាក់ អាញ់ ប៉្រគ័ អា ឡាក់ ចារ ប៉ានេ អីស តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("K18_44","012_8_44","1KI","8","44","44","«ផា ប៉ាសុន អីស ឡាំ តាកូះ លូ មួត តាម៉ឺរ ប៉ាគ់ ចារ ចំ អីស ប៉្រើ អន់ឌែ ឡាំ ណោះ ផា អន់ឌែ ម៉ន់ ឡោម អីស ហៃ គែង មឿង អា ឡាក់ ចារ អីស រ៉ើស លូ ហៃ គែង រ៉ោង រ៉ាម៉ះ អា ឡាក់ អាញ់ ប៉្រគ័ សាំរ៉ាប់ ប៉ានេ អីស ");
INSERT INTO tpu_vpl VALUES ("K18_45","012_8_45","1KI","8","45","45","ប៉រ់ អីស សាំយ៉ាំង ឡឹង ប៉្លៃង សារ អន់ឌែ ម៉ន់ ឡោម ឡា អីស ទឹប ប៉្រគ័ អន់ ចាយ័ ទ្រង អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("K18_46","012_8_46","1KI","8","46","46","«ផះ ចំ សុនសាត អ៊ីស្រាអ៊ែល ប៉្រគ័ យច លូ អីស (ខង អូ ទី បក់ ពឿ ចឹង អូ ប៉្រគ័ យច អុះ) ផះ ណោះ អីស ចឹង អឺក កា អន់ឌែ ហង ទឹប មប អន់ឌែ កា តាម៉ឺរ តាម៉ឺរ កា ចឹង គៀរ ឡាំ អន់ឌែ អន់ ប៉្រគ័ ទុច ប៉ាគ់ ប៉ាថេត ពូ យ‌៉័ះ ចាំងហាយ្គ លើ ក្យាម័ កាតាម។ ");
INSERT INTO tpu_vpl VALUES ("K18_47","012_8_47","1KI","8","47","47","ផះ អន់ឌែ អ្វៃ ប៉្រគ័ ទុច ពឹង ប៉ាថេត មួត តាម៉ឺរ ណោះ ផា អន់ឌែ ប៉ិនពែង ពុត ពៀក លូ ម៉ន់ ឡោម ឡា អីស ផា \"ញឹន ប៉្រគ័ យច កេះ ញឹន ប៉្រគ័ វ៉ីវ៉ាច័\" ");
INSERT INTO tpu_vpl VALUES ("K18_48","012_8_48","1KI","8","48","48","ផា អន់ឌែ ប៉ិនពែង ទិ ពុត ទិ ពៀក ទឹប ម៉ន់ អើ អីស ហៃ គែង ប៉ាថេត ឡាក់ អីស អន់ កា វគ័ យ៉ាគ់ អន់ឌែ លូ គែង មឿង ឡាក់ អីស រ៉ើស លូ គែង រ៉ោង រ៉ាម៉ះ ឡាក់ អាញ់ ប៉្រគ័ សាំរ៉ាប់ ចារ ប៉ានេ អីស ");
INSERT INTO tpu_vpl VALUES ("K18_49","012_8_49","1KI","8","49","49","ប៉រ់ អីស សាំយ៉ាំង ឡឹង ប៉្លៃង ឡាក់ ចារ អីស អ្វៃ ទិ សារ ឡាក់ អន់ឌែ ម៉ន់ ឡោម ឡា ណោះ ទឹប តង័ អន់ឌែ ណើ។ ");
INSERT INTO tpu_vpl VALUES ("K18_50","012_8_50","1KI","8","50","50","អីស ជែ អ្យក់ យ៉ូ សារ ប៉ាសុន អីស ប៉្រគ័ យច លូ អីស លូ ទិ សារ អន់ឌែ ប៉្រគ័ អូ ដាគ់ ប៉ាសាំង លូ អីស ណោះ ប៉រ់ អីស ប៉្រគ័ អន់ មួត តាម៉ឺរ អន់ឌែ ទី ពុត តាប៉ាប តាប៉ុន កា អន់ឌែ ឡគ ");
INSERT INTO tpu_vpl VALUES ("K18_51","012_8_51","1KI","8","51","51","ខង អន់ឌែ ប៉ាសុន អីស ទៅ ឡាក់ អីស ប៉ាណាំ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ឡាក់ ចារ វគ័ យ៉ាគ់ អន់ឌែ ប៉្រគ័ ទុច តុត ប៉ាណាប ផះ សើគ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("K18_52","012_8_52","1KI","8","52","52","«ប៉រ់ អីស ហៃ កា អាញ់ ឡាក់ ទុច អីស ទឹប សុនសាត អ៊ីស្រាអ៊ែល ឡាក់ ប៉ាសុន អីស លូ សាំយ៉ាំង សារ ឡាក់ ញឹន ប៉រ់ ឡោម ឡា អីស ផះ ចំ ញឹន ម៉ន់ ");
INSERT INTO tpu_vpl VALUES ("K18_53","012_8_53","1KI","8","53","53","ខង អីស កះ ឡាច់ ញឹន ឡឹង សុនសាត អន់ទៀគៗ ពឹង អង់កក់ តេះ ម៉ាគ់ អន់ ញឹន កេះ ប៉ាសុន អីស ឡាក់ កា អីស រ៉ះ លូ វគ័ ម៉ូសេ កេះ ផះ អីស ប៉ាណាំ វគ័ យ៉ាគ់ ញឹន ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ពែ»។ ");
INSERT INTO tpu_vpl VALUES ("K18_54","012_8_54","1KI","8","54","54","ប៉ាគ់ សាដាច់ សាឡូម៉ូន ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ កេះ ទិ កេះ អ៊ែ កា អ្យូវ ឡាច់ ឡឹង ចារ អ៊ែ ជន តាកុល លូ លឺក តី ពឹង ប៉្លៃង ហះ ង៉ីរ អន់ហ្នឹង រ៉ាម៉ះ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("K18_55","012_8_55","1KI","8","55","55","កេះណោះ អ៊ែ ប៉រ់ សារ ដាគ់ កា សុនសាត អ៊ីស្រាអ៊ែល ទិឌូ ឡាក់ ប៉ាតុំ គួប ទឹប អ៊ែ កាប ទិ ពុត ផា ");
INSERT INTO tpu_vpl VALUES ("K18_56","012_8_56","1KI","8","56","56","«ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ អន់ សុនសាត អ៊ីស្រាអ៊ែល ទី សារ សាណុក សាវ៉ាក ឡាក់ កា អ៊ែ សាញ៉ា ពែ ហង។ អ៊ែ អូ ពឹល សារ ញ៉ា ឡាក់ អ៊ែ សាញ៉ា លូ វគ័ ម៉ូសេ ពែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K18_57","012_8_57","1KI","8","57","57","អន់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ពិន អ្វៃ អន់ឌូ លូ ពិន ឡាក់ កា អ៊ែ អ្វៃ អន់ឌូ លូ វគ័ យ៉ាគ់ ពិន ពែ ដេល ជែ អន់ អ៊ែ អ្លាត ពិន។ ");
INSERT INTO tpu_vpl VALUES ("K18_58","012_8_58","1KI","8","58","58","អន់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ ពិន ទី ពុត ប៉ិច ចៃ កា អ៊ែ ម៉ាគ់ ពិន អ្លុ ប៉្រគ័ ពួយ ពុត អ៊ែ ទឹប អន់ ពិន អ្លុ ប៉្រគ័ ពួយ ចាបាប់ អ៊ែ លូ សារ អន់តគ់ ប៉ាតោ ប៉្រោ ទឹប ទិណោ័ះ ឡាក់ អ៊ែ ប៉្រើ វគ័ យ៉ាគ់ ពិន ពែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K18_59","012_8_59","1KI","8","59","59","អន់ ប‌៉្រ័ះ ប៊កកាតយ័ កាចាំង ទឹប កាដារ់ ទឹប កាម៉ាំង កា សារ អាញ់ ម៉ន់ ឡោម ឡា អា ទឹប អន់ អ៊ែ តាប៉ាប តាប៉ុន កា អាញ់ ឡាក់ ទុច អ៊ែ លូ ប៉ាសុន អ៊ីស្រាអ៊ែល ពួយ សារ ពិន តងកាន រ៉ប់ ដារ់ ");
INSERT INTO tpu_vpl VALUES ("K18_60","012_8_60","1KI","8","60","60","ម៉ាគ់ គ្រឹប សុនសាត ឡាក់ អ្វៃ ពឹង អង់កក់ តេះ អា ចឹង អ្លុ អន់តគ់ ផា ទី ដឹង ប‌៉្រ័ះ ប៊កកាតយ័ ហង ឡាក់ ប‌៉្រ័ះ តាទឹច អូ ទី ប‌៉្រ័ះ អន់ទៀគ ណាវ្គ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K18_61","012_8_61","1KI","8","61","61","ហគ់ អន់ ពុត អន់ដីស ដាគ់ ត្រង់ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ លូ ប៉្រគ័ ពួយ ចាបាប់ លូ សារ អន់តគ់ ប៉ាតោ ម៉ះ អ៊ែ ឡាក់ កា អន់ដីស ប៉្រគ័ រ៉ប់ ដារ់ អា ហង»។ ");
INSERT INTO tpu_vpl VALUES ("K18_62","012_8_62","1KI","8","62","62","កេះណោះ សាដាច់ សាឡូម៉ូន លូ ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ កា ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("K18_63","012_8_63","1KI","8","63","63","កាណាគ័ ឡាក់ សាដាច់ សាឡូម៉ូន ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ សាំរ៉ាប់ សា អន់ឌូ លូ គួប សោប ណោះ ឃឺ រ៉ក់ ២២.០០០ កាតុ លូ ចៀម ១២០.០០០ កាតុ។ នែវ អា ហង សាដាច់ សាឡូម៉ូន លូ ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ អៃត សា ហាវ រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K18_64","012_8_64","1KI","8","64","64","ដារ់ ណោះ សាដាច់ សាឡូម៉ូន ប៉្រគ័ អន់ ចារ ពឹង អន់តិគ័ ឡាន រ៉ោង រ៉ាម៉ះ ណោះ កើត ដាគ់ សាំរ៉ាប់ រ៉ាម៉ះ ប‌៉្រ័ះ កេះណោះ ពុះ អ្លាត កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ទឹប តាប៉ុង លូ ប៉ុង កាណាគ័ ឡាក់ ពូ ពុះ សា អន់ឌូ លូ គួប សោប ណោះ ខង អន់ហ្នឹង សាប៉ាន័ រ៉ាម៉ះ ប‌៉្រ័ះ ណោះ ថិ តាឡាម័ អូ បគ័ ចឹង ចៃគ កាណាគ័ ពូ រ៉ាម៉ះ ទិណោ័ះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K18_65","012_8_65","1KI","8","65","65","ផះ ណោះ សាដាច់ សាឡូម៉ូន លូ ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ កា ប៉្រគ័ ប៊ុន រ៉ាណើះ ឃឺ មួត បក់ ពឹះ ឡឹង គួយ ហះ តេះ ហាម៉ាត់ លើយ ទឹល ទៀក ទ្រូង ហះ គួយ ប៉ាថេត អ៊ីស៊ីប ឡាំ ប៉ាតុំ គួប តុត អៀង លួម ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ពិន អន់ឌែ អៃត សា ណោះ ទុញ តាំប៉ើះ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("K18_66","012_8_66","1KI","8","66","66","ប៉ាគ់ ដារ់ ទី តាំងហាម សាដាច់ សាឡូម៉ូន ប៉្រើ ប៉ាសុន សឹត ប៉ាគ់ ហី ពឿ ហី អ៊ែ។ អន់ឌែ កា ប៉រ់ សារ ដាគ់ អន់ កា សាដាច់ កេះណោះ ចាក សឹត ទឹប ទី ពុត ហោក រ៉គ់ ខាក់ ញន កា ប‌៉្រ័ះ ប៊កកាតយ័ ដាគ់ ពុត កា សាដាច់ ដាវីត លូ កា ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ។ ");
INSERT INTO tpu_vpl VALUES ("K19_1","012_9_1","1KI","9","1","1","ប៉ាគ់ សាដាច់ សាឡូម៉ូន ប៉្រគ័ រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ លូ ហី សាដាច់ លូ ទិ ហី អន់ទៀគៗ ទឹប ប៉ាន់ទៀយ ឡាក់ អ៊ែ ប៉ិច ប៉្រគ័ ណោះ កេះ ទិ កេះ ");
INSERT INTO tpu_vpl VALUES ("K19_2","012_9_2","1KI","9","2","2","ប‌៉្រ័ះ ប៊កកាតយ័ តាំបាង ឡាកោ អន់ សាដាច់ សាឡូម៉ូន ប៉ប័ លឺក ទី ពៀរ ឡាក់ កា អ៊ែ តាំបាង ឡាកោ ប៉ាគ់ មឿង គីបៀន ពែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K19_3","012_9_3","1KI","9","3","3","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កា អ៊ែ ផា «អាញ់ កាតាំង សារ អីស ម៉ន់ ឡោម អាញ់ ពែ រ៉ោង រ៉ាម៉ះ ឡាក់ អីស ប៉្រគ័ អា អាញ់ ប៉្រគ័ អន់ ដាគ់ សាំរ៉ាប់ អាញ់ កេះ អាញ់ ចឹង អន់ ពូ ប៉ានេ អាញ់ ហះ ចារ អា លើយ អាញ់ ចឹង រ៉ាំងហៃ ទឹប ពុត ប៉ិច ចៃ កា ចារ អា លើយ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K19_4","012_9_4","1KI","9","4","4","កាប៉ាច់ អីស ទៅ ផា អីស ប៉្រគ័ ពួយ អាញ់ អន់ ដាគ់ ត្រង់ ឡាក់ កា ពឹ អីស សាដាច់ ដាវីត ទឹប ប៉្រគ័ ពួយ ទិ សារ ញ៉ា ឡាក់ អាញ់ ប៉្រើ អីស លូ ប៉្រគ័ ពួយ ចាបាប់ អាញ់ ");
INSERT INTO tpu_vpl VALUES ("K19_5","012_9_5","1KI","9","5","5","ណោះ អាញ់ ចឹង ប៉្រគ័ អន់ ផូង័ វ៉ាច់ អីស រ៉ាំងហៃ រ៉ាំងខ្យា លើយ ឡាក់ កា អាញ់ សាញ៉ា លូ ពឹ អីស ដាវីត ពែ \"កាណុង ផូង័ វ៉ាច់ អីស ចឹង ទី បក់ ប៉្រគ័ សាដាច់ សុនសាត អ៊ីស្រាអ៊ែល លើយ\"។ ");
INSERT INTO tpu_vpl VALUES ("K19_6","012_9_6","1KI","9","6","6","ហះកា ផា អីស លូ ផូង័ វ៉ាច់ អីស ប៉ាង៉ាច់ ពុត ឡាច់ ឡឹង អាញ់ ទឹប អូ សាំយ៉ាំង ប៉ានឹរ អាញ់ ប៉្រើ អន់ដីស លើ ផា អន់ដីស សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ អន់ទៀគ ណាវ្គ ");
INSERT INTO tpu_vpl VALUES ("K19_7","012_9_7","1KI","9","7","7","អាញ់ ចឹង តាំងហ្យិត ឡាច់ សុនសាត អ៊ីស្រាអ៊ែល ឡឹង ប៉ាថេត ឡាក់ អាញ់ អន់ កា អន់ឌែ ពែ ទឹប ចឹង អ្លាត រ៉ោង រ៉ាម៉ះ ឡាក់ អាញ់ ប៉្រគ័ អន់ ដាគ់ សាំរ៉ាប់ ចារ ប៉ានេ អាញ់ ទឹប អូ រ៉ាំងហៃ ហង។ គ្រឹប សុនសាត ពូ ចឹង បឺង៉ាយ លូ កាប ប៉ាឡៃវ កា សុនសាត អ៊ីស្រាអ៊ែល ហង។ ");
INSERT INTO tpu_vpl VALUES ("K19_8","012_9_8","1KI","9","8","8","រ៉ោង រ៉ាម៉ះ អា ចឹង ប៉ាក់ ព្លូក ទិ ទិ បក់ ពឿ ចាក ទ្រួង ពូ ចឹង ញម ខាក់ ទឹប កាប ផា \"យើយ ខ ញ៉ា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ កា ប៉ាថេត អា លូ ប៉្រគ័ កា រ៉ោង រ៉ាម៉ះ អា កេះ នីអៀ ឡគ ?\" ");
INSERT INTO tpu_vpl VALUES ("K19_9","012_9_9","1KI","9","9","9","ពូ ចឹង តើល ផា \"ញន សុនសាត អ៊ីស្រាអ៊ែល អ្លាត អូ សឿ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ឌែ ឡាក់ ប៉ាណាំ វគ័ យ៉ាគ់ អន់ឌែ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប កិញអៀ អា អន់ឌែ ឡាំ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ អន់ទៀគ ខ ណោះ ហង បះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ អន់ឌែ ទី សារ ចុនចៃ ទិ អា\"»។ … ");
INSERT INTO tpu_vpl VALUES ("K110_1","012_10_1","1KI","10","1","1","សាដាច់ សាឡូម៉ូន កា លៅ លែង សិច ញន កា ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ដាគ់ កា អ៊ែ។ សារ សាដាច់ សាឡូម៉ូន ណោះ កាតាំង លៅ ទឹល ប៉ាគ់ សាដាច់ អង់កាន់ ប៉ាគ់ ប៉ាថេត សេបា អ៊ែ កា ឡាំ ប៉ាគ់ ចារ សាដាច់ សាឡូម៉ូន ភឿ ប៉ិច សាគ់ លួង អ៊ែ លូ អំប៉ញ់ សារ ញ៉ាកៗ។ ");
INSERT INTO tpu_vpl VALUES ("K110_2","012_10_2","1KI","10","2","2","អ៊ែ ឡាំ ទឹល ប៉ាគ់ មឿង យេរូសាឡឹម អន់ឌូ លូ មួត ប៉្រគ័ កាន កា អ៊ែ អៀង ដូវ ទឹប ទី អូត អៀង ប៉ាទុក ឃឿង បោផូវ លូ ម៉ាស អៀង ខាក់ ទឹប តាយ៉ាល័ ដេល។ ប៉ាគ់ អ៊ែ ឡាំ ទឹល ចារ សាដាច់ សាឡូម៉ូន អ៊ែ អំប៉ញ់ គ្រឹប សារ ឡាក់ អ៊ែ ឃឹត កាណុង ពុត។ ");
INSERT INTO tpu_vpl VALUES ("K110_3","012_10_3","1KI","10","3","3","សាដាច់ សាឡូម៉ូន តើល សារ អ៊ែ អំប៉ញ់ ទិណោ័ះ អូ ទី សារ ញ៉ា សាដាច់ សាឡូម៉ូន អូ អ្លុ តើល អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K110_4","012_10_4","1KI","10","4","4","ផះ សាដាច់ អង់កាន់ កាតាំង សារ អ៊ែ តើល ណោះ ហ្យាំង សាឡាច់ ខាក់ ទឹប ប៉ប័ ហី សាដាច់ សាឡូម៉ូន ប៉្រគ័ ណោះ ");
INSERT INTO tpu_vpl VALUES ("K110_5","012_10_5","1KI","10","5","5","លូ សាណា ឡាក់ សាឡូម៉ូន សា រ៉ប់ ដារ់ អន់ឌូ លូ មួត ប៉្រគ័ កាន រ៉ាតីស ទឹប ប៉ប័ មួត ប៉្រគ័ ង៉ារ កា អ៊ែ លូ ខោ អាវ ដាគ់ ឡាយ៉ាម័ ពូ កាស៊ប ពៀត ដេល ទឹប មួត អន់ទឺប ចក តាពែ ទឹប អ៊ែ ប៉ប័ កាណាគ័ សាឡូម៉ូន ពុះ អ្លាត សាំរ៉ាប់ រ៉ាម៉ះ ប‌៉្រ័ះ ប៉ាគ់ ចារ រ៉ោង រ៉ាម៉ះ  អ៊ែ កា ញម ខាក់ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("K110_6","012_10_6","1KI","10","6","6","សាដាច់ អង់កាន់ រ៉ះ លូ សាដាច់ សាឡូម៉ូន ផា «សារ ញ៉ា ឡាក់ អាញ់ កាតាំង ឡឹង ពូ ពឹង ប៉ាថេត អាញ់ ទៅ ឡឹង សារ អីស ហ្យាំង សាឡាច់ ត្រគ់ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("K110_7","012_10_7","1KI","10","7","7","ផះ អាញ់ កាតាំង ឡឹង ពូ អាញ់ អូ សឿ អុះ ហះកា កិញអៀ អា អាញ់ ប៉ប័ ម៉ាត់ អាញ់ ទៅ ទិ សារ ឡាក់ ពូ រ៉ះ ណោះ។ សារ ឡាក់ អាញ់ កាតាំង លៅ ណោះ ក្រាន័ កា ពូ រ៉ះ គឹត អន់តិគ័ ដោច។ អីស ហ្យាំង សាឡាច់ លូ ប‌៉្រ័ះ ប៉ាត្រង័ ហ៊្លត ឡឹង សារ អាញ់ កាតាំង ណោះ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("K110_8","012_10_8","1KI","10","8","8","មួត ទុច លូ មួត រ៉ាតីស ឡាក់ អ្វៃ ប៉្រគ័ កាន កា អីស កា សាណុក សាវ៉ាក ទិឌូ ខង រ៉ប់ ដារ់ អន់ឌែ សាំយ៉ាំង ប៉ានឹរ អីស ឡាក់ ហ្យាំង សាឡាច់។ ");
INSERT INTO tpu_vpl VALUES ("K110_9","012_10_9","1KI","10","9","9","ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អីស អ៊ែ ដាគ់ ពុត កា អីស ទឹប រ៉ើស អីស ប៉្រើ ហាវ ប៉្រគ័ សាដាច់ រ៉ាំងហៃ សុនសាត អ៊ីស្រាអ៊ែល។ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ិច ចៃ កា សុនសាត អ៊ីស្រាអ៊ែល ណោះ ហង បះ អ៊ែ រ៉ើស អីស ប៉្រើ ប៉្រគ័ សាដាច់ ម៉ាគ់ អីស រ៉ាំងហៃ លូ តាត់ស៊ិន សារ អន់ ដាគ់ ត្រង់»។ ");
INSERT INTO tpu_vpl VALUES ("K110_10","012_10_10","1KI","10","10","10","កេះណោះ អ៊ែ អន់ ម៉ាស កា សាដាច់ សាឡូម៉ូន ៤០០០ កាឡូ ទឹប ឃឿង បោផូវ ទឹប តាយ៉ាល័ អៀង ខាក់។ ឡៃង ឡឹង ណោះ អូ ទី ពឿ អ្យក់ ឡាំ ឃឿង បោផូវ អៀង សាម៉ើ លូ កាណាគ័ ឡាក់ សាដាច់ អង់កាន់ ឡឹង ប៉ាថេត សេបា អន់ កា សាដាច់ សាឡូម៉ូន ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K110_11","012_10_11","1KI","10","11","11","ផះ ណោះ កាំប៉ាន់ ហ៊ីរ៉ាម ឡាក់ សាដាច់ មឿង ទីរ៉ូះ ប៉ាទុក ម៉ាស លូ អ៊្លង តាំងហ៊ុម ទឹប តាយ៉ាល័ អៀង ខាក់ ពឹះ ឡឹង ប៉ាថេត អូភៀរ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K110_12","012_10_12","1KI","10","12","12","សាដាច់ សាឡូម៉ូន កា ប៉្រើ ពូ អ្យក់ អ៊្លង តាំងហ៊ុម ណោះ ប៉្រគ័ ប៉្វារ័ ហាវ ពឹង រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ទឹប ប៉្រគ័ ប៉្វារ័ ហាវ ពឹង ហី សាដាច់។ អ៊ែ កា ប៉្រើ ពូ ប៉្រគ័ ព្រួក លូ កាណី សាំរ៉ាប់ អ៊ត អន់ទែង អន់ឌូ លូ មួត ចាជែ អញ់ស៊ែ។ ឡឹង ដារ់ ណោះ លើយ ទឹល រ៉ប់ ដារ់ អា អូ ទី ពឿ អ្យក់ ម៉ុត អ៊្លង តាំងហ៊ុម អៀង ខាក់ ម៉ុត ពឹង ប៉ាថេត អ៊ីស្រាអ៊ែល សាម៉ើ លូ អ៊្លង តាំងហ៊ុម ឡាក់ សាដាច់ ហ៊ីរ៉ាម អន់ ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K110_13","012_10_13","1KI","10","13","13","សាដាច់ សាឡូម៉ូន ដាគ់ ពុត អន់ កាណាគ័ អៀង កា សាដាច់ អង់កាន់ ឡឹង ប៉ាថេត សេបា ហ៊្លត ឡឹង ណោះ ណាវ្គ អ៊ែ អន់ កាណាគ័ ញ៉ា ឡាក់ សាដាច់ អង់កាន់ ប៉ិច ដេល។ កេះណោះ សាដាច់ អង់កាន់ សឹត ប៉ាគ់ ប៉ាថេត អ៊ែ ទៅ អន់ឌូ លូ មួត ប៉្រគ័ កាន។ ");
INSERT INTO tpu_vpl VALUES ("K110_14","012_10_14","1KI","10","14","14","កាណុង ម៉ោញ សាណាំ ៗ សាដាច់ សាឡូម៉ូន ទី ម៉ាស ឡឹង ពូ ២៣.០០០ កាឡូ។ ");
INSERT INTO tpu_vpl VALUES ("K110_15","012_10_15","1KI","10","15","15","ហ៊្លត ឡឹង ណោះ ណាវ្គ ទី ម៉ាស ឡឹង មួត តាច់ តូរ័ លូ មួត ប្រូ ប្រី ស៊ង រ៉ាបៃ ទឹប ឡឹង សាដាច់ ប៉ាថេត អារ៉ាប់ លូ មួត រ៉ាំងហៃ មឿង អន់ទៀគៗ ណាវ្គ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K110_16","012_10_16","1KI","10","16","16","សាដាច់ សាឡូម៉ូន កា ប៉្រើ ពូ តាង ម៉ាស ក្លប់ ពឹង ខៃល តីស ២០០ កាតុ ពឹង ខៃល ម៉ោញៗ ទី ម៉ាស ត្រោ កាឡូ។ ");
INSERT INTO tpu_vpl VALUES ("K110_17","012_10_17","1KI","10","17","17","អ៊ែ កា ប៉្រើ ពូ ប៉្រគ័ ខៃល ថិៗ ៣០០ កាតុ និះទៅ ដេល ពឹង ខៃល ម៉ោញ ទី ម៉ាស ម៉ោញ កាឡូ ទងតិគ័។ អ៊ែ កា អ្យក់ ខៃល ឡាំ អន់ ប៉ាគ់ ហី សាដាច់ ឡាក់ ពូ អើ ផា ហី ព្រី ឡេបាណូន។ ");
INSERT INTO tpu_vpl VALUES ("K110_18","012_10_18","1KI","10","18","18","អ៊ែ កា ប៉្រើ ពូ ប៉្រគ័ គ្រេ សាដាច់ លូ ព្លុក ប៉្រះ លូ ចារ័ ម៉ាស ង៉ាតៗ។ ");
INSERT INTO tpu_vpl VALUES ("K110_19","012_10_19","1KI","10","19","19","គ្រេ សាដាច់ ណោះ ចៃគ ពឹង ចារ ចាំងហីគ ទី កឺង ហាវ ត្រោ រ៉ាំងឡាក់ ហាវ ពឹង គ្រេ ណោះ ចារ អង់អ៊េន ណោះ វ៉ឹល ទឹប ទី ចារ ទឺរ តី ទិ ពៀរ ប៊ែង ទឹប ទី ហ៊ូប ក្លា អ្វៃ សានែង ចារ ទឺរ តី ទិ ពៀរ ប៊ែង ណោះ ដេល ");
INSERT INTO tpu_vpl VALUES ("K110_20","012_10_20","1KI","10","20","20","ទឹប ទី ហ៊ូប ក្លា ១២ កាតុ ចៃគ ពឹង កឺង ពឹង រ៉ាំងឡាក់ ម៉ោញៗ ទី ក្លា ពៀរ កាតុ ម៉ោញ ប៊ែង ម៉ោញ កាតុ។ អូ ឃើយ ទី ប៉ាថេត ចំ ទី គ្រេ សាដាច់ នែវ អា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K110_21","012_10_21","1KI","10","21","21","កាប៉ាច់ ពៀង ឡាក់ សាដាច់ សាឡូម៉ូន យរ ទិណោ័ះ ពូ ប៉្រគ័ លូ ម៉ាស ទឹប ឃឿង ខង ញ៉ាៗ ពឹង ហី ព្រី ឡេបាណូន ណោះ ពូ ប៉្រគ័ លូ ម៉ាស ទិណោ័ះ ដេល អូ ទី កាណាគ័ ញ៉ា ពូ ប៉្រគ័ លូ ប៉្រាក់ អុះ ខង ផះ រ៉ាំងហាវ សាដាច់ សាឡូម៉ូន ណោះ ប៉្រាក់ អូ គឹត ខា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K110_22","012_10_22","1KI","10","22","22","សាដាច់ សាឡូម៉ូន ទី កាំប៉ាន់ អៀង សាំរ៉ាប់ ជិះ ពឹង ទៀក សាឡីគ សាឡាយ ភឿ ឡាម៉គ់ ឡាំ តាច់ តូរ័ ប៉ាគ់ ប៉ាថេត ចាំងហាយ្គ អន់ឌូ លូ កាំប៉ាន់ សាដាច់ ហ៊ីរ៉ាម។ ប៉ៃង សាណាំ ម៉ោញ ទង កាំប៉ាន់ ណោះ ប៉ាទុក សឹត ទឹប កាណាគ័ គឹត ខា ឡាក់ កា ម៉ាស ប៉្រាក់ ព្លុក តក័ លូ ព្រៀក។ ");
INSERT INTO tpu_vpl VALUES ("K110_23","012_10_23","1KI","10","23","23","សាដាច់ សាឡូម៉ូន ប‌៉្រ័ះ ប៉ាត្រង័ កេង ខាក់ ទឹប អ៊ែ ហ្យាំង សាឡាច់ ក្វា ឡឹង ពូ អូ ទី សាដាច់ ចំ ពឹង អង់កក់ តេះ អា សាម៉ើ លូ អ៊ែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K110_24","012_10_24","1KI","10","24","24","ប៉ាណូស គ្រឹប ប៉ាថេត ពឹង អង់កក់ តេះ អា ពូ ប៉ិច ឡាំ ប៉ាគ់ ចារ អ៊ែ ខង ពូ ប៉ិច សាំយ៉ាំង ប៉ានឹរ ហ្យាំង សាឡាច់ ឡាក់ ប‌៉្រ័ះ អន់ កា អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("K110_25","012_10_25","1KI","10","25","25","ទិ បក់ ឡាំ សាំយ៉ាំង អ៊ែ ណោះ ពូ អ្យក់ ឡាំ កាណាគ័ អន់ កា សាដាច់ សាឡូម៉ូន ឡាក់ កា កាណាគ័ ពូ ប៉្រគ័ លូ ម៉ាស លូ ប៉្រាក់ ទឹប ខោ អាវ លូ ឃឿង តាកូះ ឃឿង បោផូវ ទឹប សេះ លូ លៀ។ រ៉ប់ សាណាំ ពូ អន់ កាណាគ័ នីអៀ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K110_26","012_10_26","1KI","10","26","26","សាដាច់ សាឡូម៉ូន ទ្រៀម រ៉ាតេ័ះ តាកូះ ទឹប តាហាន ជិះ សេះ រ៉ាតេ័ះ តាកូះ ទិណោ័ះ ទី ១៤០០ តាហាន ជិះ សេះ ទី ១២.០០០ ដូវ បក់ អន់ដា អ៊ែ អន់ អ្វៃ អន់ឌូ លូ អ៊ែ ពឹង មឿង យេរូសាឡឹម បក់ អន់ដា ណាវ្គ អ៊ែ អន់ អ្វៃ ពឹង មឿង អន់ទៀគៗ។ ");
INSERT INTO tpu_vpl VALUES ("K110_27","012_10_27","1KI","10","27","27","ផះ ណោះ ទី ប៉្រាក់ អៀង ខាក់ ពឹង មឿង យេរូសាឡឹម ប៉ុប កា អំហ្មោ ញន កា សាដាច់ សាឡូម៉ូន។ កា ទី អ៊្លង កាញូង អៀង ឡាក់ កា អ៊្លង ហ្រោល ពូ កាល់ ប៉ាគ់ ជុង ប៉ានឹម ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K110_28","012_10_28","1KI","10","28","28","មួត តាច់ តូរ័ អន់ឌែ តាច់ សេះ ឡឹង ប៉ាថេត អ៊ីស៊ីប លូ ឡឹង ប៉ាថេត គីលីគៀ អន់ កា សាដាច់ សាឡូម៉ូន។ ");
INSERT INTO tpu_vpl VALUES ("K110_29","012_10_29","1KI","10","29","29","រ៉ាតេ័ះ តាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ម៉ោញ កាតុ ខា អ៊ែ ប៉្រាក់ ត្រោ កាឡូ សេះ ម៉ោញ កល់ ខា អ៊ែ ប៉្រាក់ ម៉ោញ កាឡូ ទងតិគ័។ សាដាច់ សាឡូម៉ូន កា ប៉្រើ មួត ប្រូ ប្រី អ្យក់ សេះ លូ រ៉ាតេ័ះ ឡាំ ប្រូ កា សាដាច់ សុនសាត ហេត លូ សាដាច់ ប៉ាថេត ស៊ីរី។ ");
INSERT INTO tpu_vpl VALUES ("K111_1","012_11_1","1KI","11","1","1","សាដាច់ សាឡូម៉ូន ប៉ិច កា អង់កាន់ សុនសាត អន់ទៀគៗ អៀង ដូវ ណាវ្គ កាយ ឡឹង កាម៉ាញ់ អ៊ែ គន សាដាច់ អ៊ីស៊ីប។ អង់កាន់ ទិណោ័ះ សុនសាត ម៉ូអាប់ សុនសាត អាម៉ូន សុនសាត អេដំ សុនសាត ស៊ីដូន លូ សុនសាត ហេត។ ");
INSERT INTO tpu_vpl VALUES ("K111_2","012_11_2","1KI","11","2","2","សុនសាត ទិណោ័ះ ហង ប‌៉្រ័ះ ប៊កកាតយ័ ទឹប អូ អន់ មួត អ៊ីស្រាអ៊ែល អ្យក់ ប៉្រគ័ កាម៉ាញ់ អុះ កា អូ អន់ ពូ ទី សុនសាត អ៊ីស្រាអ៊ែល ដេល ខង ពូ ចឹង ប៉ាឡោម ពុត ពៀក អន់ឌែ ជៀក ឡាំ សាំប‌៉័ះ ប‌៉្រ័ះ ពូ ហង  ហះកា សាដាច់ សាឡូម៉ូន វ៉ឹន កា អង់កាន់ ទិណោ័ះ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("K111_3","012_11_3","1KI","11","3","3","កាម៉ាញ់ សាដាច់ សាឡូម៉ូន ទិណោ័ះ ទី ៧០០ ដូវ ឡាក់ ស៊ុត កា គន សាដាច់ ទិណោ័ះ ទឹប ទី មួត អង់កាន់ ៣០០ ដូវ ណាវ្គ។ កាម៉ាញ់ អ៊ែ ទិណោ័ះ ហង ប៉ាឡោម ពុត អ៊ែ ឡាច់ ឡឹង ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("K111_4","012_11_4","1KI","11","4","4","ប៉ាគ់ សាដាច់ សាឡូម៉ូន ក្រាគ់ កេះ កាម៉ាញ់ អ៊ែ ប៉ាឡោម ពុត អ៊ែ ជៀក ឡាំ សាំប‌៉័ះ ប‌៉្រ័ះ អន់ទៀគ។ សាដាច់ សាឡូម៉ូន អូ ប៉ិច កា ប‌៉្រ័ះ ប៊កកាតយ័ ទិ ពុត ទិ ពៀក ឡាក់ ពឹ អ៊ែ សាដាច់ ដាវីត អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K111_5","012_11_5","1KI","11","5","5","សាដាច់ សាឡូម៉ូន កា សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ អាសាថារ៉ូត ឡាក់ ប‌៉្រ័ះ សុនសាត ស៊ីដូន លូ ប‌៉្រ័ះ មីលកូម ឡាក់ បឺគ អ៊ក ខាក់ ឡាក់ ប‌៉្រ័ះ សុនសាត អាម៉ូន។ ");
INSERT INTO tpu_vpl VALUES ("K111_6","012_11_6","1KI","11","6","6","សាដាច់ សាឡូម៉ូន កា ប៉្រគ័ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ខាក់ លូ អូ ប៉្រគ័ ពួយ ប៉ានឹរ ប‌៉្រ័ះ គ្រឹប នែវ ឡាក់ កា ពឹ អ៊ែ សាដាច់ ដាវីត ពែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K111_7","012_11_7","1KI","11","7","7","ផះ ណោះ សាដាច់ សាឡូម៉ូន កា ប៉្រគ័ អន់ហ្នឹង ពឹង ចារ ប៉ាឌួល គែង ដារ់ ឡាច់ មឿង យេរូសាឡឹម សាំរ៉ាប់ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ កេម៉ូះ ឡាក់ បឺគ អ៊ក កាខាក់ ឡាក់ ប‌៉្រ័ះ សុនសាត ម៉ូអាប់ លូ ប‌៉្រ័ះ ម៉ូឡុក ឡាក់ បឺគ អ៊ក ខាក់ ដេល ឡាក់ ប‌៉្រ័ះ សុនសាត អាម៉ូន។ ");
INSERT INTO tpu_vpl VALUES ("K111_8","012_11_8","1KI","11","8","8","អ៊ែ កា ប៉្រគ័ ចារ សាំប‌៉័ះ ប៉ានេ អៀង ចារ ណាវ្គ អន់ កា កាម៉ាញ់ អ៊ែ សុនសាត អន់ទៀគ ទិណោ័ះ ភឿ អន់ អន់ឌែ សុះ តាំងហ៊ុម លូ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("K111_9","012_11_9","1KI","11","9","9","ប‌៉្រ័ះ ប៊កកាតយ័ អឺក កាខាក់ កា សាដាច់ សាឡូម៉ូន ខង អ៊ែ ឡាច់ ឡឹង ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល ឡាក់ តាំបាង ឡាកោ អន់ កា អ៊ែ ប៉ប័ ពៀរ ទង ពែ ");
INSERT INTO tpu_vpl VALUES ("K111_10","012_11_10","1KI","11","10","10","ទឹប កាប ផា «អីស ជែ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ អន់ទៀគ ដៃ»។ ហះកា សាដាច់ សាឡូម៉ូន អូ ចៃ ប៉្រគ័ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K111_11","012_11_11","1KI","11","11","11","ទឹល នីណោ័ះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ផា «ញន កា អីស ប៉្រគ័ នែវ អា អីស អូ ប៉្រគ័ ពួយ សារ អាញ់ សាញ៉ា រែវ ពុត ទឹប អូ ប៉្រគ័ ពួយ ចាបាប់ ឡាក់ អាញ់ ប៉្រើ អីស ណោះ អាញ់ ចឹង អ្យក់ ឡាច់ សារ អីស រ៉ាំងហៃ ប៉ាថេត អ៊ីស្រាអ៊ែល ឡឹង អីស កេះណោះ អន់ កា បក់ ប៉្រគ័ ង៉ារ កា អីស រ៉ាំងហៃ ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("K111_12","012_11_12","1KI","11","12","12","ហះកា ញន កា អាញ់ ហៃ កា ពឹ អីស សាដាច់ ដាវីត អាញ់ អូ អ្យក់ ឡាច់ សារ រ៉ាំងហៃ ផះ រ៉ាំងហាវ អីស អា អុះ។ អាញ់ ចឹង អ្យក់ ឡាច់ សារ រ៉ាំងហៃ ឡឹង គន អីស ទៀ។ ");
INSERT INTO tpu_vpl VALUES ("K111_13","012_11_13","1KI","11","13","13","អាញ់ កា អូ អ្យក់ ឡាច់ សារ រ៉ាំងហៃ អន់ ទិ ឡូត អុះ ហះកា អាញ់ អន់ អ៊ែ អ្វៃ រ៉ាំងហៃ ម៉ោញ ផូង័ ញន កា អាញ់ ហៃ កា សាដាច់ ដាវីត លូ មឿង យេរូសាឡឹម ឡាក់ មឿង អាញ់ រ៉ើស អ្យក់»។ … ");
INSERT INTO tpu_vpl VALUES ("K111_26","012_11_26","1KI","11","26","26","ផះ ណោះ ទី ប៉ាណូស ម៉ោញ ដូវ ប៉ាសាំង លូ សាដាច់ សាឡូម៉ូន។ អ៊ែ ណោះ សិច យេរ៉ូបោម គន វគ័ នេបាត ឡាក់ ផូង័ អេប៉្រាអ៊ីម អ្វៃ ពឹង តេះ សេរេដា មើគ អ៊ែ សិច សេរូអា ឡាក់ អង់កាន់ អន់ត្រោ័។ សារ ណោះ នីអៀ៖ ផះ អន់ទ្រួល ពែ យេរ៉ូបោម ប៉្រគ័ កាន អន់ឌូ លូ សាដាច់ សាឡូម៉ូន។ ");
INSERT INTO tpu_vpl VALUES ("K111_27","012_11_27","1KI","11","27","27","ផះ សាដាច់ សាឡូម៉ូន ប៉្រើ ពូ តគ័ អំហ្មោ ត្រាគ័ ប៉ាន់ទៀយ ប៉ាគ់ មឿង យេរូសាឡឹម លូ ប៉ាយ៉ាម័ ប៉ាន់ទៀយ ឡាក់ ប៉ាក់ ព្លូក ប៉ាគ់ ស្រុក តេះ សាដាច់ ដាវីត ឡាក់ ពឹ អ៊ែ ");
INSERT INTO tpu_vpl VALUES ("K111_28","012_11_28","1KI","11","28","28","អ៊ែ ប៉ប័ ផា យេរ៉ូបោម ឡាក់ ប៉ាណូស ត្រះ ត្រាំង ហ្យាំង សាឡាច់ ទឹល នីណោ័ះ អ៊ែ ប៉្រើ រ៉ាំងហៃ មួត គូលី ឡឹង ផូង័ វ៉ាច់ វគ័ យូស៊ែប។ ");
INSERT INTO tpu_vpl VALUES ("K111_29","012_11_29","1KI","11","29","29","រ៉ាំងវ៉ាង ណោះ យេរ៉ូបោម ផះ ចាក ឡាច់ ឡឹង មឿង យេរូសាឡឹម។ ផះ ណោះ រ៉ាគឹយ ប‌៉្រ័ះ ឡឹង មឿង ស៊ីឡូ សិច អាហ៊ីយ៉ា ឡាំ ណាំង យេរ៉ូបោម ប៉ប័ អ៊ែ ប៉ាគ់ ទ្រង។ អន់ឌែ ពៀរ ដូវ អ្វៃ ចាំងហាយ្គ ឡឹង ពូ ប៉ាគ់ ស៊្រែ។ វគ័ អាហ៊ីយ៉ា ពៀត អាវ ណាវ។ ");
INSERT INTO tpu_vpl VALUES ("K111_30","012_11_30","1KI","11","30","30","អ៊ែ រ៉ីស ឡាច់ អាវ ណាវ ណោះ ហ៊ែក អន់ ទី ១២ សាំរែក។ ");
INSERT INTO tpu_vpl VALUES ("K111_31","012_11_31","1KI","11","31","31","កេះណោះ អ៊ែ រ៉ះ កា យេរ៉ូបោម ផា «ហគ់ អ្យក់ ១០ សាំរែក អា ពិ ខង ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល រ៉ះ ផា \"អាញ់ ចឹង អ្យក់ ឡាច់ អ៊ីស្រាអ៊ែល ១០ ផូង័ ឡឹង សាដាច់ សាឡូម៉ូន មប អន់ កា អីស ");
INSERT INTO tpu_vpl VALUES ("K111_32","012_11_32","1KI","11","32","32","ហះកា អាញ់ ចឹង គម អន់ កា សាឡូម៉ូន ម៉ោញ ផូង័ ញន កា អាញ់ ហៃ កា ដាវីត ឡាក់ ពឹ អ៊ែ ទឹប ហៃ កា មឿង យេរូសាឡឹម ឡាក់ អាញ់ រ៉ើស ឡឹង ផូង័ វ៉ាច់ អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("K111_33","012_11_33","1KI","11","33","33","អាញ់ ប៉្រគ័ នីអៀ ញន កា អ៊ែ អ្លាត អាញ់ ទឹប សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ អាសាថារ៉ូត ឡាក់ ប‌៉្រ័ះ សុនសាត ស៊ីដូន លូ ប‌៉្រ័ះ កេម៉ូះ ឡាក់ ប‌៉្រ័ះ ម៉ូអាប់ ទឹប ប‌៉្រ័ះ មីលកូម ឡាក់ ប‌៉្រ័ះ សុនសាត អាម៉ូន។ អ៊ែ អូ អ្វៃ កោប អន់ ដាគ់ ហះ ម៉ាត់ អាញ់ លូ អូ ប៉្រគ័ ពួយ ចាបាប់ ឡាក់ កា ពឹ អ៊ែ សាដាច់ ដាវីត អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K111_34","012_11_34","1KI","11","34","34","ហះកា អាញ់ អូ អ្យក់ ឡាច់ សារ រ៉ាំងហៃ ឡឹង សាឡូម៉ូន តាំងឡា អុះ អាញ់ ចឹង អន់ អ៊ែ រ៉ាំងហៃ ឡុច អាញុ អ៊ែ ញន កា ហៃ កា ដាវីត ឡាក់ ទុច អាញ់ ឡាក់ អាញ់ រ៉ើស ខង អ៊ែ ប៉្រគ័ ពួយ ចាបាប់ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("K111_35","012_11_35","1KI","11","35","35","អាញ់ ចឹង អ្យក់ ឡាច់ សារ រ៉ាំងហៃ ឡឹង គន សាឡូម៉ូន ឡគ កេះណោះ មប ១០ ផូង័ អន់ កា អីស រ៉ាំងហៃ។ ");
INSERT INTO tpu_vpl VALUES ("K111_36","012_11_36","1KI","11","36","36","កាប៉ាច់ គន សាឡូម៉ូន អាញ់ ចឹង គម ម៉ោញ ផូង័ អន់ កា អ៊ែ រ៉ាំងហៃ ម៉ាគ់ ដាវីត តូ ផូង័ វ៉ាច់ លើយ ហះ ម៉ាត់ អាញ់ អ្វៃ កាណុង មឿង យេរូសាឡឹម ឡាក់ អាញ់ រ៉ើស សាំរ៉ាប់ ចារ ប៉ានេ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("K111_37","012_11_37","1KI","11","37","37","កាប៉ាច់ អីស អាញ់ ចឹង អន់ អីស ប៉្រគ័ សាដាច់ រ៉ាំងហៃ គ្រឹប ចារ តាម ពុត អីស ប៉ិច។ អីស កា ចឹង ហាវ ប៉្រគ័ សាដាច់ អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("K111_38","012_11_38","1KI","11","38","38","ផា អីស សាំយ៉ាំង ពួយ ប៉ានឹរ អាញ់ ប៉្រើ លូ អ្វៃ កោប អន់ ដាគ់ ត្រង់ ហះ ម៉ាត់ អាញ់ ទឹប ប៉្រគ័ ពួយ ចាបាប់ អាញ់ ឡាក់ កា ដាវីត ប៉្រគ័ ណោះ ពែ អាញ់ ចឹង អ្វៃ អន់ឌូ លូ អីស អាញ់ ចឹង ប៉្រគ័ អន់ ផូង័ វ៉ាច់ អីស រ៉ាំងហៃ រ៉ាំងខ្យា លើយ ឡាក់ កា អាញ់ អន់ កា ដាវីត អាញ់ កា ចឹង មប សុនសាត អ៊ីស្រាអ៊ែល កា អីស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K111_39","012_11_39","1KI","11","39","39","កាប៉ាច់ គន សោ ដាវីត អាញ់ ចឹង ប៉្រគ័ អន់ អន់ឌែ ប៉ាណាប ញន កា សារ សាឡូម៉ូន យច អា ហះកា អូ ត្រគ់ ប៉្រគ័ អន់ ប៉ាណាប លើយ អុះ\"»។ ");
INSERT INTO tpu_vpl VALUES ("K111_40","012_11_40","1KI","11","40","40","ផះ សាដាច់ សាឡូម៉ូន អ្លុ ឡឹង សារ អា អ៊ែ ប៉ិច ប៉ាន់តោ័ យេរ៉ូបោម ហះកា យេរ៉ូបោម សាតាក់ ឡាំ ម៉ឹង ស៊ីសាក់ ឡាក់ សាដាច់ អ៊ីស៊ីប អ៊ែ អ្វៃ ពឹង ប៉ាថេត អ៊ីស៊ីប លើយ ទឹល សាដាច់ សាឡូម៉ូន តោ័។ ");
INSERT INTO tpu_vpl VALUES ("K111_41","012_11_41","1KI","11","41","41","សារ អន់ទៀគៗ ណាវ្គ រ៉ះ ឡឹង សាដាច់ សាឡូម៉ូន ទឹប ង៉ារ អ៊ែ ប៉្រគ័ លូ សារ អ៊ែ ហ្យាំង សាឡាច់ ពូ ច្រាគ់ គម ពឹង ផាប់ «ង៉ារ សាដាច់ សាឡូម៉ូន»។ ");
INSERT INTO tpu_vpl VALUES ("K111_42","012_11_42","1KI","11","42","42","សាដាច់ សាឡូម៉ូន រ៉ាំងហៃ ប៉ាសុន អ៊ីស្រាអ៊ែល ពឹង មឿង យេរូសាឡឹម ទុញ ៤០ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("K111_43","012_11_43","1KI","11","43","43","ប៉ាគ់ សាដាច់ សាឡូម៉ូន តោ័ ពួយ វគ័ យ៉ាគ់ អ៊ែ កេះ ពូ តប់ អ៊ែ ប៉ាគ់ ស្រុក តេះ សាដាច់ ដាវីត ឡាក់ ពឹ អ៊ែ។ រេហូបោម ឡាក់ គន អ៊ែ កា ហាវ ប៉្រគ័ សាដាច់ ប៉ាតាង អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("K112_1","012_12_1","1KI","12","1","1","រេហូបោម ឡាំ ប៉ាគ់ មឿង ស៊ីគែម ខង ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ ឡាំ អ្វៃ ប៉ាតុំ គួប ប៉ាគ់ មឿង ណោះ ម៉ាគ់ ចឹង តាគ់ អំប៉ោក អ៊ែ ប៉្រើ ប៉្រគ័ សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("K112_2","012_12_2","1KI","12","2","2","ផះ ណោះ យេរ៉ូបោម គន វគ័ នេបាត អ៊ែ អ្វៃ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ញន កា អ៊ែ សាតាក់ អោន ឡឹង សាដាច់ សាឡូម៉ូន ពែ។ ប៉ាគ់ អ៊ែ កាតាំង លៅ ផា សាដាច់ សាឡូម៉ូន តោ័ កេះ អ៊ែ កា សឹត ឡឹង ប៉ាថេត អ៊ីស៊ីប។ ");
INSERT INTO tpu_vpl VALUES ("K112_3","012_12_3","1KI","12","3","3","ផះ ណោះ ពូ ឡាំ រ៉ះ កា យេរ៉ូបោម អន់ ម៉ុត អន់ឌូ ដេល។ យេរ៉ូបោម លូ ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ កា ពឹះ ប៉ាតុំ គួប កេះណោះ ពូ រ៉ះ កា សាដាច់ រេហូបោម ផា ");
INSERT INTO tpu_vpl VALUES ("K112_4","012_12_4","1KI","12","4","4","«ពឹ អីស ប៉ាំងខំ ញឹន ប៉្រគ័ ង៉ារ ក្លេ័ះ ក្លាំង ខាក់។ កិញអៀ អា ប៉រ់ អីស អន់ ញឹន ប៉្រគ័ ង៉ារ ឡាម៉គ់ បៀត ពិ ម៉ាគ់ ញឹន ចឹង ប៉្រគ័ ពួយ ពុត អីស»។ ");
INSERT INTO tpu_vpl VALUES ("K112_5","012_12_5","1KI","12","5","5","អ៊ែ តើល ផា «ហគ់ អន់ដីស សឹត ពិ ក្យាគ់ ប៉ៃង ដារ់ កេះណោះ ឡាំ ប៉ាគ់ អា ណាវ្គ»។ ប៉ាសុន កា ប៉ាណាំ គួប ឡាច់ ឡឹង ចារ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K112_6","012_12_6","1KI","12","6","6","សាដាច់ រេហូបោម កា ឡាំ ពឹកសា លូ មួត ក្រាគ់ តាំងកង់ ឡាក់ ក្រុំ ពឹកសា អន់ឌូ លូ ពឹ អ៊ែ សាដាច់ សាឡូម៉ូន ពែ។ អ៊ែ អំប៉ញ់ អន់ឌែ ផា «តាម អន់ដីស ឃឹត នីចម័ អាញ់ ត្រគ់ តើល ប៉ាសុន អា ?» ");
INSERT INTO tpu_vpl VALUES ("K112_7","012_12_7","1KI","12","7","7","មួត ក្រាគ់ តាំងកង់ តើល ផា «ផា អីស ប៉្រគ័ ពួយ ពុត ប៉ាសុន ដឹង ម៉ោញ ដារ់ លូ កាប ដាគ់ ប៉ានឹរ កា អន់ឌែ ណោះ អន់ឌែ ចឹង ប៉្រគ័ ពួយ ពុត អីស លើយ»។ ");
INSERT INTO tpu_vpl VALUES ("K112_8","012_12_8","1KI","12","8","8","ហះកា សាដាច់ រេហូបោម អូ វ៉ឹនវ៉ាយ កា ប៉ានឹរ អន់ឌែ រ៉ះ ណោះ អុះ អ៊ែ ឡាំ អំប៉ញ់ លូ មួត តាតាម័ សានឺរ លូ អ៊ែ បក់ ឃើយ រ៉ាំពង លូ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("K112_9","012_12_9","1KI","12","9","9","អ៊ែ កាប ផា «ប៉ាសុន រ៉ះ កា អាញ់ ផា \"ពឹ អីស ប៉ាំងខំ ញឹន ប៉្រគ័ ង៉ារ ក្លេ័ះ ក្លាំង ខាក់ ប៉រ់ អីស អន់ ញឹន ប៉្រគ័ ង៉ារ ឡាម៉គ់ បៀត\"។ តាម អន់ដីស ឃឹត អាញ់ ត្រគ់ តើល នីចម័ កា ប៉ាសុន អា ?» ");
INSERT INTO tpu_vpl VALUES ("K112_10","012_12_10","1KI","12","10","10","មួត តាតាម័ តើល ផា «ប៉ាសុន អា រ៉ះ ផា \"ពឹ អីស ប៉្រើ ញឹន ប៉្រគ័ ង៉ារ ក្លេ័ះ ក្លាំង ខាក់ អីស អន់ ញឹន ប៉្រគ័ ង៉ារ ឡាម៉គ់ បៀត ឡគ\" អីស ត្រគ់ រ៉ះ កា អន់ឌែ ផា \"សាឌែង តី អាញ់ តីស ឡឹង ព្លូ ពឹ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("K112_11","012_12_11","1KI","12","11","11","ពឹ អាញ់ ប៉្រើ អន់ដីស ប៉្រគ័ ង៉ារ ក្លេ័ះ ក្លាំង ខាក់ ហះកា អាញ់ ចឹង ប៉្រើ អន់ដីស ប៉្រគ័ ង៉ារ ក្លេ័ះ ក្លាំង ក្វា ឡឹង ណោះ ណាវ្គ។ ពឹ អាញ់ ពីត ប៉ាញ់ចាល អន់ដីស លូ ប៉្រាត័ ហះកា អាញ់ ចឹង ប៉ាញ់ចាល អន់ដីស លូ កាត្វាយ័ \"»។ ");
INSERT INTO tpu_vpl VALUES ("K112_12","012_12_12","1KI","12","12","12","ប៉ៃង ដារ់ ឡឹង ណោះ ណាវ្គ យេរ៉ូបោម លូ ប៉ាសុន ទិឌូ ឡាំ ប៉ាគ់ ចារ សាដាច់ រេហូបោម ឡាក់ អ៊ែ កាចះ ផា «ប៉ៃង ដារ់ ត្រគ់ ពឹះ ប៉ាគ់ អាញ់ ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("K112_13","012_12_13","1KI","12","13","13","ផះ ណោះ សាដាច់ រេហូបោម កាប អូ ដាគ់ ប៉ានឹរ លូ ប៉ាសុន អ៊ែ អូ សាំយ៉ាំង ប៉ានឹរ មួត ក្រាគ់ តាំងកង់ រ៉ះ កា អ៊ែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K112_14","012_12_14","1KI","12","14","14","អ៊ែ រ៉ះ កា ប៉ាសុន ពួយ ប៉ានឹរ មួត តាតាម័ ផា «ពឹ អាញ់ ប៉្រើ អន់ដីស ប៉្រគ័ ង៉ារ ក្លេ័ះ ក្លាំង ខាក់ ហះកា អាញ់ ចឹង ប៉្រើ អន់ អន់ដីស ប៉្រគ័ ង៉ារ ក្លេ័ះ ក្លាំង ក្វា ឡឹង ណោះ ណាវ្គ។ ពឹ អាញ់ ពីត ប៉ាញ់ចាល អន់ដីស លូ ប៉្រាត័ ហះកា អាញ់ ចឹង ប៉ាញ់ចាល អន់ដីស លូ កាត្វាយ័»។ ");
INSERT INTO tpu_vpl VALUES ("K112_15","012_12_15","1KI","12","15","15","សាដាច់ រេហូបោម អូ ចៃ ប៉្រគ័ ពួយ ប៉ានឹរ ប៉ាសុន ប៉រ់ ណោះ អុះ សារ អា កើត ពឹះ ពួយ ផិនកាន ប‌៉្រ័ះ ប៊កកាតយ័ ភឿ តាគ់ អង់កេះ សារ អ៊ែ រ៉ះ កា យេរ៉ូបោម ពឹង វគ័ អាហ៊ីយ៉ា ឡាក់ រ៉ាគឹយ ប‌៉្រ័ះ ឡឹង មឿង ស៊ីឡូ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("K112_16","012_12_16","1KI","12","16","16","ប៉ាគ់ ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ ប៉ប័ ផា សាដាច់ អូ សាំយ៉ាំង ពួយ ប៉ានឹរ អន់ឌែ ប៉រ់ ណោះ អន់ឌែ តើល អ៊ែ ផា «ញឹន អូ ទួម ញ៉ា លូ សាដាច់ ដាវីត អុះ ញឹន អូ ទី ចានែក ប៉ាដក់ ប៉ាជៀ ញ៉ា អន់ឌូ លូ គន វគ័ យេសាយ។ អឺ ប៉ាសុន អ៊ីស្រាអ៊ែល ពិ ពិន សឹត ប៉ាគ់ ហី ពឿ ហី អ៊ែ ពិ។ អឺ សោ វគ័ ដាវីត ហគ់ រ៉ាំងហៃ ផូង័ វ៉ាច់ អីស ទៅ ពិ»។ ប៉ាសុន អ៊ីស្រាអ៊ែល កា សឹត ប៉ាគ់ ហី អន់ឌែ ទៅ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K112_17","012_12_17","1KI","12","17","17","កាប៉ាច់ សាដាច់ រេហូបោម រ៉ាំងហៃ ប៉ាសុន អ៊ីស្រាអ៊ែល ឡាក់ អ្វៃ ពឹង មឿង លូ ស្រុក តេះ ផូង័ យូដា។ ");
INSERT INTO tpu_vpl VALUES ("K112_18","012_12_18","1KI","12","18","18","អ៊ែ កា ប៉្រើ អាដូរ៉ាម ឡាក់ រ៉ាំងហៃ មួត បក់ ពូ ប៉ាំងខំ ប៉្រើ ប៉្រគ័ ង៉ារ ណោះ។ អាដូរ៉ាម កា ឡាំ កាកាប លូ មួត អ៊ីស្រាអ៊ែល ហះកា អន់ឌែ ទិឌូ ហឹរ ប៉ាន់តោ័ អ៊ែ លូ អំហ្មោ។ កាប៉ាច់ សាដាច់ រេហូបោម ប៉ាន់តាន ជិះ រ៉ាតេ័ះ សាតាក់ សឹត ប៉ាគ់ មឿង យេរូសាឡឹម។ ");
INSERT INTO tpu_vpl VALUES ("K112_19","012_12_19","1KI","12","19","19","នីអៀ ហង ប៉ាសុន អ៊ីស្រាអ៊ែល ១០ ផូង័ ប៉ាសាំង លូ គន សោ សាដាច់ ដាវីត លើយ ទឹល រ៉ប់ ដារ់ អា។ ");
INSERT INTO tpu_vpl VALUES ("K112_20","012_12_20","1KI","12","20","20","ផះ ណោះ ប៉ាសុន អ៊ីស្រាអ៊ែល កា កាតាំង ផា យេរ៉ូបោម វ៉ីល សឹត កេះ អន់ឌែ ប៉្រើ កាំឡាំង អន់ឌែ ឡាំ រ៉ះ លូ អ៊ែ ប៉្រើ ឡាំ ប៉ាគ់ ចារ អន់ឌែ លួម អន់ឌែ ចឹង ប៉្រើ អ៊ែ ហាវ ប៉្រគ័ សាដាច់ សុនសាត អ៊ីស្រាអ៊ែល ទិឌូ។ ទី ដឹង ផូង័ វ៉ាច់ យូដា ហង អ្វៃ ពួយ គន សោ សាដាច់ ដាវីត។ ");
INSERT INTO tpu_vpl VALUES ("K112_21","012_12_21","1KI","12","21","21","ប៉ាគ់ សាដាច់ រេហូបោម សឹត ទឹល ប៉ាគ់ មឿង យេរូសាឡឹម អ៊ែ កា ប៉ាតុំ តាហាន ឡឹង ផូង័ វ៉ាច់ យូដា លូ ផូង័ វ៉ាច់ បេនយ៉ាមីន ទិណោ័ះ ទី ចំលួន ១៨០.០០០ ដូវ ឡាក់ អ្លុ តាកូះ កេង ខាក់។ អន់ឌែ ប៉ាណាំ គួប ឡាំ តាកូះ លូ ប៉ាសុន អ៊ីស្រាអ៊ែល ម៉ាគ់ ចឹង រ៉ាត អ្យក់ ប៉ាថេត អ៊ីស្រាអ៊ែល អន់ កា រេហូបោម គន សាដាច់ សាឡូម៉ូន។ ");
INSERT INTO tpu_vpl VALUES ("K112_22","012_12_22","1KI","12","22","22","ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ លូ វគ័ សេម៉ាយ៉ា បក់ រ៉ះ ប៉ាតាង ប‌៉្រ័ះ ផា ");
INSERT INTO tpu_vpl VALUES ("K112_23","012_12_23","1KI","12","23","23","«ហគ់ រ៉ះ លូ រេហូបោម គន សាដាច់ សាឡូម៉ូន ឡាក់ សាដាច់ យូដា ទឹប រ៉ះ កា ប៉ាសុន ឡឹង ផូង័ យូដា លូ ផូង័ បេនយ៉ាមីន ទឹប មួត អន់ទៀគ ឡាក់ អ្វៃ អន់ឌូ លូ អន់ឌែ ផា ");
INSERT INTO tpu_vpl VALUES ("K112_24","012_12_24","1KI","12","24","24","\"ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ផា 'ជែ ឡាំ តាកូះ លូ មួត ប៉ាសុន អ៊ីស្រាអ៊ែល ខង អន់ឌែ ណោះ អុះ ម៉ី អន់ដីស ទៅ ហគ់ វ៉ីល សឹត ប៉ាគ់ ហី ពឿ ហី អ៊ែ ពិ ខង សារ អា អាញ់ ហង ប៉្រគ័ អន់ កើត នែវ អា' \"»។ អន់ឌែ កា សាំយ៉ាំង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័  អន់ឌែ កា វ៉ីល សឹត ប៉ាគ់ ហី អន់ឌែ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("K112_25","012_12_25","1KI","12","25","25","សាដាច់ យេរ៉ូបោម ប៉្រគ័ ប៉ាន់ទៀយ មឿង ស៊ីគែម ពឹង ព្រី ប៉ានឹម អេប៉្រាអ៊ីម អ៊ែ កា អ្វៃ ពឹង មឿង ណោះ។ ឡៃង ឡឹង ណោះ អ៊ែ ឡាច់ ឡឹង មឿង ស៊ីគែម ឡាំ ប៉្រគ័ ប៉ាន់ទៀយ មឿង ពេនួល ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("K112_26","012_12_26","1KI","12","26","26","ហះកា អ៊ែ ឃឹត កាណុង ពុត ផា «ប៉ាថេត អ៊ីស្រាអ៊ែល អា ចឹង ទី កា ផូង័ វ៉ាច់ សាដាច់ ដាវីត ណាវ្គ តាម ហៃ។ ");
INSERT INTO tpu_vpl VALUES ("K112_27","012_12_27","1KI","12","27","27","ផា មួត ប៉ាសុន អា ឡាំ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ពឹង រ៉ោង រ៉ាម៉ះ ប៉ាគ់ មឿង យេរូសាឡឹម ណោះ ពុត អន់ឌែ ចឹង កាចាំង កា រេហូបោម ឡាក់ សាដាច់ យូដា ផះ ណោះ អន់ឌែ ចឹង ប៉ាន់តោ័ អាញ់ លូ វ៉ីល សឹត ប៉ាគ់ រេហូបោម ហង»។ ");
INSERT INTO tpu_vpl VALUES ("K112_28","012_12_28","1KI","12","28","28","សាដាច់ យេរ៉ូបោម កា ពឹកសា លូ មួត ប៉្រគ័ កាន កេះណោះ អ៊ែ ប៉្រើ ពូ អ្យក់ ម៉ាស តូះ ប៉្រគ័ ហ៊ូប រ៉ក់ ពៀរ កាតុ កេះណោះ រ៉ះ កា ប៉ាសុន ផា «អឺ អ៊ីស្រាអ៊ែល បគ័ កេះ អន់ដីស ជែ ឡាំ ហង ប៉ាគ់ មឿង យេរូសាឡឹម ណោះ។ អា ហង ប‌៉្រ័ះ ឡាក់ ប៉ាណាំ វគ័ យ៉ាគ់ អន់ដីស ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ពែ»។ ");
INSERT INTO tpu_vpl VALUES ("K112_29","012_12_29","1KI","12","29","29","អ៊ែ អន់ ហ៊ូប រ៉ក់ ម៉ោញ កាតុ ប៉ាគ់ មឿង បេតអ៊ែល ម៉ោញ កាតុ ណាវ្គ អន់ ប៉ាគ់ មឿង ដាន់។ ");
INSERT INTO tpu_vpl VALUES ("K112_30","012_12_30","1KI","12","30","30","អ៊ែ កា ប៉ាណាំ ប៉ាសុន ប៉្រគ័ សារ យច ញន កា ហ៊ូប រ៉ក់ ណោះ។ ប៉ាសុន កា ប៉ាណាំ គួប ឡាំ ប៉ាគ់ មឿង ដាន់ ភឿ ជន តាកុល សាំប‌៉័ះ ហ៊ូប រ៉ក់ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K112_31","012_12_31","1KI","12","31","31","សាដាច់ យេរ៉ូបោម កា ប៉្រគ័ រ៉ោង រ៉ាម៉ះ ពឹង ចារ ប៉ាឌួល អន់ទៀគៗ កេះណោះ អ៊ែ រ៉ើស ប៉ាណូស ប៉្រើ ប៉្រគ័ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ឡាក់ អូ ត្រគ់ ផូង័ វ៉ាច់ លេវី ។ ");
INSERT INTO tpu_vpl VALUES ("K112_32","012_12_32","1KI","12","32","32","អ៊ែ កា ប៉្រើ ពូ ប៉្រគ័ ប៊ុន ត្រគ់ ពឹង ដារ់ ទី ១៥ ខៃ ៨ ឡាក់ កា ពូ ប៉្រគ័ ប៊ុន ពឹង ប៉ាថេត យូដា ដេល ផះ ណោះ អ៊ែ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ពឹង អន់ហ្នឹង។ អ៊ែ កា ប៉្រគ័ នែវ អា ដេល ប៉ាគ់ មឿង បេតអ៊ែល អ៊ែ កា ពុះ កាណាគ័ រ៉ាម៉ះ ហ៊ូប រ៉ក់ ឡាក់ ពូ ប៉្រគ័ ណោះ។ អ៊ែ កា ប៉្រើ មួត ក្រាគ់ រ៉ាម៉ះ ឡាក់ អ៊ែ រ៉ើស ណោះ ប៉្រើ ប៉្រគ័ ង៉ារ ប៉ាគ់ រ៉ោង រ៉ាម៉ះ ពឹង ចារ ប៉ាឌួល ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("K112_33","012_12_33","1KI","12","33","33","ប៉ាគ់ ដារ់ ទី ១៥ ខៃ ៨ ឡាក់ ដារ់ អ៊ែ កាំឡត់ អ៊ែ ទៅ ណោះ អ៊ែ ជៀក ប៉ាសុន អ៊ីស្រាអ៊ែល ប៉្រគ័ ប៊ុន អន់ឌូ លូ អ៊ែ ប៉ាគ់ មឿង បេតអ៊ែល។ ផះ ណោះ អ៊ែ ហាវ ប៉ាគ់ អន់ហ្នឹង ឡាក់ អ៊ែ ប៉្រគ័ ណោះ អ៊ែ កា សុះ តាំងហ៊ុម ពឹង អន់ហ្នឹង ណោះ ហង។ … ");
INSERT INTO tpu_vpl VALUES ("K116_29","012_16_29","1KI","16","29","29","ផះ សាណាំ ទី ៣៨ រ៉ាំងវ៉ាង សាដាច់ អេសា រ៉ាំងហៃ ប៉ាថេត យូដា អាហាប់ គន សាដាច់ អំរី ហាវ ប៉្រគ័ សាដាច់ អ៊ីស្រាអ៊ែល។ អ៊ែ រ៉ាំងហៃ ទុញ ២២ សាណាំ ពឹង មឿង សាម៉ារី។ ");
INSERT INTO tpu_vpl VALUES ("K116_30","012_16_30","1KI","16","30","30","សាដាច់ អាហាប់ ប៉្រគ័ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ក្វា ឡឹង សាដាច់ អន់ទ្រួលៗ ពែ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("K116_31","012_16_31","1KI","16","31","31","អូ ត្រគ់ ដឹង កា អ៊ែ ប៉្រគ័ សារ យច ពួយ សាដាច់ យេរ៉ូបោម ណោះ អុះ ទឹប អ៊ែ ទី កាម៉ាញ់ សិច យេសិបិល គន អង់កាន់ សាដាច់ អេតបាល ឡាក់ សាដាច់ មឿង ស៊ីដូន ទឹប អ៊ែ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ បាល ដេល ");
INSERT INTO tpu_vpl VALUES ("K116_32","012_16_32","1KI","16","32","32","លូ អ៊ែ ប៉្រគ័ រ៉ោង រ៉ាម៉ះ កា ប‌៉្រ័ះ បាល ពឹង មឿង សាម៉ារី លូ ប៉្រគ័ អន់ហ្នឹង រ៉ាម៉ះ ប‌៉្រ័ះ បាល ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K116_33","012_16_33","1KI","16","33","33","អ៊ែ កា ប៉្រគ័ ហ៊ូប ប‌៉្រ័ះ អាសេរ៉ា។ អ៊ែ ប៉្រគ័ សារ អូ ដាគ់ ក្វា ឡឹង សាដាច់ អ៊ីស្រាអ៊ែល អន់ទ្រួលៗ សាំ ប៉្រគ័ អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អឺក ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("K116_34","012_16_34","1KI","16","34","34","ផះ រ៉ាំងវ៉ាង ណោះ វគ័ ហ៊ីអ៊ែល ឡឹង មឿង បេតអ៊ែល ប៉្រគ័ មឿង យេរីខូ ណាវ្គ។ ផះ អ៊ែ ប៉្រគ័ ប៉ាន់ទៀយ មឿង អាប៊ីរ៉ាម គន ឡោងទ្រៀ អ៊ែ កា តោ័។ ផះ អ៊ែ ប៉ោក ចៃគ អំប៉ារ មឿង ណោះ សេគូប គន ស្រុច អ៊ែ កា តោ័ ដេល ត្រគ់ ឡាក់ កា យូស្វេ គន វគ័ នូន រ៉ះ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ពែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K117_1","012_17_1","1KI","17","1","1","វគ័ អេលីយ៉ា ឡឹង តេះ ធេសាប៊ី ពឹង ព្រី ប៉ានឹម កាឡាត អ៊ែ រ៉ះ លូ សាដាច់ អាហាប់ ផា «អាញ់ ឡាក់ ប៉្រគ័ ង៉ារ កា ប‌៉្រ័ះ ប៊កកាតយ័ អាញ់ រ៉ះ កា អីស តាទឹច ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល អ្វៃ រ៉ីស ដេល៖ គឹត អា ប៉ាគ់ ម៉ាត់ ទៀ ចឹង អូ ទី ទៀក ងម លូ ទៀក បី អុះ ផា អាញ់ អូ ប៉រ់»។ ");
INSERT INTO tpu_vpl VALUES ("K117_2","012_17_2","1KI","17","2","2","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ លូ វគ័ អេលីយ៉ា ផា ");
INSERT INTO tpu_vpl VALUES ("K117_3","012_17_3","1KI","17","3","3","«ហគ់ ចាក ឡាច់ ឡឹង អា ឡាំ គែង ដារ់ ឡាច់ កេះណោះ ឡាំ អោន ឡាកោ ប៉ាគ់ តាចាង័ កេរីត គែង ដារ់ ឡាច់ ទៀក ទ្រូង យដាន់។ ");
INSERT INTO tpu_vpl VALUES ("K117_4","012_17_4","1KI","17","4","4","អីស ចឹង អៃត ទៀក តាចាង័ អាញ់ ចឹង ប៉្រើ សាំងអៀក ចោះ សាំងកង់ សាណា អ្យក់ ឡាំ អន់ កា អីស អ្វៃ ប៉ាគ់ ណោះ» ");
INSERT INTO tpu_vpl VALUES ("K117_5","012_17_5","1KI","17","5","5","អ៊ែ កា ចាក ឡាច់ ឡឹង ចារ ណោះ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័  អ៊ែ កា អ្វៃ ក្យាម័ តាចាង័ កេរីត គែង ដារ់ ឡាច់ ទ្រូង យដាន់។ ");
INSERT INTO tpu_vpl VALUES ("K117_6","012_17_6","1KI","17","6","6","សាំងអៀក កា ចោះ សាំងកង់ ឡាំ ណុំ ប៉ាំង លូ ប៉ាំងឡៃ អន់ កា អ៊ែ រ៉ប់ អំលឺ រ៉ប់ ង៉ាច អន់ កា អ៊ែ សា អ៊ែ កា អៃត ទៀក តាចាង័ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K117_7","012_17_7","1KI","17","7","7","អន់តីគ ឡឹង ណោះ តាចាង័ កា ស្វាត់ ដេល ខង ប៉្លៃង អូ ទី បី អុះ ពឹង ប៉ាថេត ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K117_8","012_17_8","1KI","17","8","8","ផះ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ លូ វគ័ អេលីយ៉ា ផា ");
INSERT INTO tpu_vpl VALUES ("K117_9","012_17_9","1KI","17","9","9","«ហគ់ ឡាំ អ្វៃ ប៉ាគ់ តេះ សារិបតា ឡាក់ តេះ សុនសាត ស៊ីដូន អាញ់ ចឹង ប៉្រើ អង់កាន់ អន់ត្រោ័ ម៉ោញ ដូវ អន់ សាណា កា អីស សា»។ ");
INSERT INTO tpu_vpl VALUES ("K117_10","012_17_10","1KI","17","10","10","អ៊ែ កា ចាក ឡាំ ប៉ាគ់ តេះ សារិបតា។ ប៉ាគ់ ទឹល អំប៉ារ ទ្រួក កេះ អ៊ែ កា ប៉ប័ អង់កាន់ អន់ត្រោ័ ផះ អ្វៃ ណាំង រ៉ាម៉េះ។ អ៊ែ កា អើ អង់កាន់ ណោះ លូ រ៉ះ ផា «ប៉រ់ អីស ឡាំ អ្យក់ ទៀក បាប៊ែត អន់ កា អាញ់ អៃត ហៃ»។ ");
INSERT INTO tpu_vpl VALUES ("K117_11","012_17_11","1KI","17","11","11","អង់កាន់ ណោះ ផះ ចឹង ឡាំ អ្យក់ ទៀក ហះកា វគ័ អេលីយ៉ា អើ អ៊ែ ផា «ប៉រ់ អីស អ្យក់ ទឹប ណុំ ប៉ាំង អន់ កា អាញ់ សា ម៉ោញ នឹរ ណើ»។ ");
INSERT INTO tpu_vpl VALUES ("K117_12","012_17_12","1KI","17","12","12","អង់កាន់ ណោះ តើល ផា «អាញ់ រ៉ះ កា អីស តាទឹច ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អីស អ្វៃ រ៉ីស ដេល៖ អាញ់ អូ ទី ណុំ ប៉ាំង អុះ ទី ដឹង តាប៉ុង ម៉ោញ កាំប៉ង់ ឡាក់ អ្វៃ សល់ កាណុង ព្រឺយ លូ ប៉ុង បៀត កាណុង ព្រឺយ យ៉ាំង។ ណោះ ហង អាញ់ ណាំង រ៉ាម៉េះ អា ភឿ ចឹង ពុះ ណុំ ប៉ាំង ម៉ាគ់ អាញ់ លូ គន អាញ់ សា ប៉ាគ់ ញឹន សា ទិ កេះ ញឹន ចឹង តោ័ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("K117_13","012_17_13","1KI","17","13","13","ហះកា វគ័ អេលីយ៉ា រ៉ះ កា អង់កាន់ ណោះ ផា «ជែ អ្យូគ ហង ! ហគ់ ឡាំ ប៉្រគ័ ឡាក់ កា អីស រ៉ះ ណោះ ហង ពិ ហះកា អីស ត្រគ់ ពុះ ឡាំ ជឹន កា អាញ់ ម៉ោញ កាតុ ថិ អន់ អាញ់ សា អន់ទ្រួល ហិ កេះណោះ ពុះ កា អីស លូ គន អីស ");
INSERT INTO tpu_vpl VALUES ("K117_14","012_17_14","1KI","17","14","14","ខង ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល អ៊ែ រ៉ះ ផា តាប៉ុង ពឹង ព្រឺយ អីស ណោះ អូ អ្លុ ទិ អុះ លូ ប៉ុង ឡាក់ អ្វៃ កាណុង ព្រឺយ យ៉ាំង អីស ណោះ កា អូ អ្លុ ទិ ដេល លើយ ទឹល ដារ់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ ប៉្លៃង បី ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("K117_15","012_17_15","1KI","17","15","15","ទឹល នីណោ័ះ អង់កាន់ ណោះ កា សឹត ប៉្រគ័ ពួយ ប៉ានឹរ វគ័ អេលីយ៉ា រ៉ះ ណោះ ហង។ អន់ឌែ កា ទី សាណា សា ទុញ ដារ់ ទឹប អ៊ែ លូ គន អ៊ែ ទឹប វគ័ អេលីយ៉ា។ ");
INSERT INTO tpu_vpl VALUES ("K117_16","012_17_16","1KI","17","16","16","តាប៉ុង អ៊ែ កា អូ អ្លុ ទិ ឡឹង ព្រឺយ ប៉ុង កា អូ អ្លុ ទិ ឡឹង ព្រឺយ យ៉ាំង ដេល ត្រគ់ ឡាក់ កា វគ័ អេលីយ៉ា រ៉ះ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K117_17","012_17_17","1KI","17","17","17","ឡៃង ឡឹង ណោះ គន កាម៉ាក័ អង់កាន់ អន់ត្រោ័ ណោះ ព្លុ ហ៊ែង ក្លាំង ៗ ទឹល កាតាច់ កាស៊ែ តាំងហើម។ ");
INSERT INTO tpu_vpl VALUES ("K117_18","012_17_18","1KI","17","18","18","អង់កាន់ អន់ត្រោ័ ណោះ រ៉ះ កា វគ័ អេលីយ៉ា ផា «អឺ បក់ រ៉ះ ប៉ាតាង ប‌៉្រ័ះ ប៊កកាតយ័ សារ ញ៉ា អាញ់ ទី លូ អីស បះ អីស ឡាំ អ្វៃ ពឹង ហី អាញ់ ភឿ តាគ់ កាចាំង កា សារ អាញ់ យច លូ ប៉្រគ័ អន់ គន អាញ់ តោ័»។ ");
INSERT INTO tpu_vpl VALUES ("K117_19","012_17_19","1KI","17","19","19","វគ័ អេលីយ៉ា តើល ផា «ប៉ឹះ មប គន អីស កា អាញ់ ពិ»។ វគ័ អេលីយ៉ា អ្យក់ សាស្វា ណោះ ឡឹង តី មើគ អ៊ែ ពៅ ហាវ ពឹង កាណុង អ៊ែ អ្វៃ កេះណោះ តាគ់ អន់តៃប សាស្វា ពឹង គ្រេ អ៊ែ តៃប។ ");
INSERT INTO tpu_vpl VALUES ("K117_20","012_17_20","1KI","17","20","20","កេះណោះ វគ័ អេលីយ៉ា ម៉ន់ ឡោម ប‌៉្រ័ះ ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អាញ់ អង់កាន់ អន់ត្រោ័ អា ហាប់ អាញ់ អន់ អ្វៃ ពឹង ហី អ៊ែ។ ញ៉ា ត្រគ់ អីស ប៉្រគ័ អន់ អ៊ែ អុក ពុត នីអៀ ? ញ៉ា អីស ប៉្រគ័ អន់ គន អ៊ែ តោ័ ?» ");
INSERT INTO tpu_vpl VALUES ("K117_21","012_17_21","1KI","17","21","21","អ៊ែ តៃប ត្រ្វាត់ អំប៉ាំង សាស្វា ណោះ ប៉ៃង ទង ទឹប ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អាញ់ ប៉រ់ អន់ សាស្វា អា រ៉ីស សឹត ពិ» ");
INSERT INTO tpu_vpl VALUES ("K117_22","012_17_22","1KI","17","22","22","ប‌៉្រ័ះ ប៊កកាតយ័ កា សាំយ៉ាំង ពួយ សារ វគ័ អេលីយ៉ា ម៉ន់ ឡោម ណោះ សាស្វា ណោះ កា ហ្រក់ សឹត ទឹប ហ្លង់ ប៉ាណូស។ ");
INSERT INTO tpu_vpl VALUES ("K117_23","012_17_23","1KI","17","23","23","វគ័ អេលីយ៉ា កា ពៅ ជឹរ សាស្វា ណោះ អន់ កា មើគ អ៊ែ លូ កាប ផា «ហៃ គន អីស អា រ៉ីស សឹត កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("K117_24","012_17_24","1KI","17","24","24","អង់កាន់ ណោះ កាប លូ វគ័ អេលីយ៉ា ផា «កិញអៀ អា អាញ់ អ្លុ អន់តគ់ ផា អីស ឡាក់ ប៉ាណូស រ៉ះ ប៉ាតាង ប‌៉្រ័ះ ប៊កកាតយ័ ទិ សារ ឡាក់ អីស រ៉ះ ឃឺ ប៉ានឹរ ប‌៉្រ័ះ តាទឹច ហង»។ ");
INSERT INTO tpu_vpl VALUES ("K118_1","012_18_1","1KI","18","1","1","ទុញ ដារ់ ឡឹង ណោះ ពឹង សាណាំ ទី ប៉ៃង ផះ ប៉្លៃង ប៉ាដាំង ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ លូ វគ័ អេលីយ៉ា ផា «ហគ់ ឡាំ រ៉ះ កា សាដាច់ អាហាប់ កេះណោះ អាញ់ ចឹង អន់ ទៀក បី ពឹង ប៉ាថេត អា»។ ");
INSERT INTO tpu_vpl VALUES ("K118_2","012_18_2","1KI","18","2","2","វគ័ អេលីយ៉ា កា ឡាំ ប៉ាគ់ ចារ សាដាច់ អាហាប់។ ផះ ណោះ ទី សារ ឡាយ៉ិត ឡាំងវ៉ាញ់ ខាក់ ពឹង មឿង សាម៉ារី។ ");
INSERT INTO tpu_vpl VALUES ("K118_3","012_18_3","1KI","18","3","3","សាដាច់ អាហាប់ កា ប៉្រើ ពូ ឡាំ អ្យក់ វគ័ អូបាឌៀ ឡាក់ រ៉ាំងហៃ ហី សាដាច់ អ៊ែ ឡាក់ ប៉ាណូស អ្យិល កូត័ កា ប‌៉្រ័ះ ប៊កកាតយ័ ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("K118_4","012_18_4","1KI","18","4","4","ផះ យេសិបិល ប៉ាន់តោ័ មួត រ៉ាគឹយប‌៉្រ័ះ ប៊កកាតយ័ ពែ វគ័ អូបាឌៀ ឡាំ អោន មួត រ៉ាគឹយ ប‌៉្រ័ះ ១០០ ដូវ ពឹង រ៉ូង័ ប៉ានឹម ពៀរ ចារ កាណុង ម៉ោញ ចារ ៥០ ដូវ ទឹប អ៊ែ ទ្រុង ឡាំ សាណា លូ ទៀក អៃត អន់ កា អន់ឌែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K118_5","012_18_5","1KI","18","5","5","សាដាច់ អាហាប់ រ៉ះ កា វគ័ អូបាឌៀ ផា «អ្យគ័ អីស ឡាំ ណាំង ចារ កល់ ទៀក លូ ចារ ទី ទ្រូង ទៀក អ្លុ ផាហៃគ ទី សាម៉ោង អន់ កា សេះ លូ លៀ សា ម៉ាគ់ អ្វៃ រ៉ីស ដាគ់ អូ តោ័»។ ");
INSERT INTO tpu_vpl VALUES ("K118_6","012_18_6","1KI","18","6","6","កេះណោះ អន់ឌែ ក្លះ ទ្រង ចាក ទ្រង ពឿ ទ្រង អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("K118_7","012_18_7","1KI","18","7","7","វគ័ អូបាឌៀ ផះ ចាក ផាឌី ប៉ាត័ះ វគ័ អេលីយ៉ា។ វគ័ អូបាឌៀ កា អន់ហ្នាល់ អ៊ែ លូ ជន តាកុល កុប កល់ ទឹះ តេះ ទឹប កាប ផា «អឺ ពឹ តាំងឡា អីស ហង ប វគ័ អេលីយ៉ា ?» ");
INSERT INTO tpu_vpl VALUES ("K118_8","012_18_8","1KI","18","8","8","វគ័ អេលីយ៉ា តើល ផា «អឺះ អាញ់ ហង ! ហគ់ ឡាំ រ៉ះ កា ពឹ តាំងឡា អីស ផា អាញ់ ពឹះ ទឹល កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("K118_9","012_18_9","1KI","18","9","9","វគ័ អូបាឌៀ តើល ផា «អាញ់ ប៉្រគ័ យច សារ ញ៉ា បះ អីស មប អាញ់ កា សាដាច់ អាហាប់ អន់ អ៊ែ ប៉ាន់តោ័ ? ");
INSERT INTO tpu_vpl VALUES ("K118_10","012_18_10","1KI","18","10","10","អាញ់ រ៉ះ កា អីស តាទឹច ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អីស អ៊ែ អ្វៃ រ៉ីស ដេល៖ សាដាច់ អាហាប់ ប៉្រើ ពូ ចាក ណាំង អីស គ្រឹប ប៉ាថេត។ ផានែវ ពូ ផា អូ ប៉ប័ អុះ អ៊ែ ប៉្រើ ពូ ម៉ត់ ផា អូ ប៉ប័ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("K118_11","012_18_11","1KI","18","11","11","កិញអៀ អា អីស ប៉្រើ អាញ់ ឡាំ រ៉ះ លូ ពឹ តាំងឡា ផា អីស ពឹះ ទឹល កេះ ");
INSERT INTO tpu_vpl VALUES ("K118_12","012_18_12","1KI","18","12","12","ហះកា ផះ អាញ់ ចាក ឡាច់ ឡឹង អីស ប៉ាង៉ាត័ ប៉ាលឹង ប‌៉្រ័ះ ចឹង ពឹះ ប៉ោក ឡាច់ អីស ឡាំ ប៉ាគ់ ចារ អន់ទៀគ ណាវ្គ ចារ ឡាក់ អាញ់ អូ អ្លុ។ ប៉ាគ់ សាដាច់ អាហាប់ ណាំង អីស អូ ប៉ប័ ឡាក់ កា អាញ់ រ៉ះ លូ អ៊ែ ណោះ ចាបះ កា អ៊ែ ចឹង ប៉ាន់តោ័ អ្លាត អាញ់ ហង យ‌៉័ះ អាញ់ ឃើយ អ្យិល កូត័ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡឹង អ្វៃ សាស្វា កាតាម។ ");
INSERT INTO tpu_vpl VALUES ("K118_13","012_18_13","1KI","18","13","13","អូ ទី ពឿ រ៉ះ កា អីស ត័ះ ឡឹង សារ អាញ់ តង័ រ៉ាគឹយ ប‌៉្រ័ះ ប៊កកាតយ័ ផះ រ៉ាំងវ៉ាង យេសិបិល ប៉ាន់តោ័ អន់ឌែ ពែ អាញ់ អោន អន់ឌែ ណោះ ពែ ទី ១០០ ដូវ ពឹង រ៉ូង័ ប៉ានឹម ទី ពៀរ ចារ ម៉ោញ ចារ ៥០ ដូវ ទឹប អន់ សាណា លូ ទៀក កា អន់ឌែ អៃត ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K118_14","012_18_14","1KI","18","14","14","ហះកា កិញអៀ អា អីស ប៉្រើ អាញ់ ឡាំ រ៉ះ លូ សាដាច់ អាហាប់ ផា អីស ពឹះ ទឹល ប៉ាគ់ អា កេះ សាដាច់ អាហាប់ ចឹង ប៉ាន់តោ័ អាញ់ តាទឹច ហង»។ ");
INSERT INTO tpu_vpl VALUES ("K118_15","012_18_15","1KI","18","15","15","វគ័ អេលីយ៉ា តើល ផា «អាញ់ រ៉ះ កា អីស តាទឹច ឡាក់ កា ប‌៉្រ័ះ តេះ ប‌៉្រ័ះ ប៉្លៃង ឡាក់ ប‌៉្រ័ះ អាញ់ សាំប‌៉័ះ ប៉ានេ អ៊ែ អ្វៃ រ៉ីស ដេល៖ ដារ់ អា អាញ់ ចឹង ឡាំ តាំបាង ម៉ូះ ម៉ាត់ កា សាដាច់ អាហាប់»។ ");
INSERT INTO tpu_vpl VALUES ("K118_16","012_18_16","1KI","18","16","16","ទឹល នីណោ័ះ វគ័ អូបាឌៀ កា ឡាំ រ៉ះ កា សាដាច់ អាហាប់ កេះណោះ សាដាច់ អាហាប់ ឡាំ ប៉ាគ់ ចារ វគ័ អេលីយ៉ា។ ");
INSERT INTO tpu_vpl VALUES ("K118_17","012_18_17","1KI","18","17","17","ផះ សាដាច់ អាហាប់ ប៉ប័ វគ័ អេលីយ៉ា អ៊ែ កាប ផា «អីស អា ហង ប៉្រគ័ អន់ ប៉ាសុន អ៊ីស្រាអ៊ែល ថុក ឡាំបាក !» ");
INSERT INTO tpu_vpl VALUES ("K118_18","012_18_18","1KI","18","18","18","វគ័ អេលីយ៉ា តើល ផា «អាញ់ អូ ទី ប៉្រគ័ អន់ ប៉ាសុន អ៊ីស្រាអ៊ែល ថុក ឡាំបាក អុះ អីស លូ អុះ ម៉ី ផូង័ វ៉ាច់ អីស ហង ប៉្រគ័ អន់ កើត សារ ឡាំបាក អា ខង អន់ដីស អ្លាត អូ រ៉ាប់ អូ សឿ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័  កាប៉ាច់ អីស កា សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ បាល ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("K118_19","012_18_19","1KI","18","19","19","កិញអៀ អា ហគ់ អើ ប៉ាតុំ មួត ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ ប៉្រើ ឡាំ ប៉ាគ់ ចារ អាញ់ ប៉ាគ់ ប៉ានឹម កាមែល ទឹប មួត រ៉ាគឹយ ប‌៉្រ័ះ បាល ទិ ៤៥០ ដូវ ទឹប រ៉ាគឹយ ប‌៉្រ័ះ អាសេរ៉ា ៤០០ ដូវ ឡាក់ ឃើយ សា សាណា អន់ឌូ លូ យេសិបិល ត្រគ់ ប៉្រើ ពឹះ ទិឌូ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("K118_20","012_18_20","1KI","18","20","20","សាដាច់ អាហាប់ ប៉្រើ ពូ ឡាំ រ៉ះ កា ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ ប៉្រើ ប៉ាតុំ គួប ទឹប ប៉្រើ មួត រ៉ាគឹយ ប‌៉្រ័ះ បាល ប៉ាតុំ គួប ពឹង ប៉ានឹម កាមែល។ ");
INSERT INTO tpu_vpl VALUES ("K118_21","012_18_21","1KI","18","21","21","វគ័ អេលីយ៉ា រ៉ះ កា ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ ផា «អន់ដីស អ្វៃ វ៉ឹល វ៉ើង កា ញ៉ា ណាវ្គ ? ផា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ តាទឹច ហគ់ ប៉្រគ័ ពួយ អ៊ែ ហះកា ផា ប‌៉្រ័ះ បាល ឡាក់ ប‌៉្រ័ះ តាទឹច ហគ់ ពួយ អ៊ែ ពិ !» ហះកា ប៉ាសុន ទិឌូ អ្វៃ រ៉ាង៉ាប់ អូ តើល អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K118_22","012_18_22","1KI","18","22","22","វគ័ អេលីយ៉ា កាប ណាវ្គ ផា «កាណុង រ៉ាគឹយ ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ សល់ ដឹង ម៉ោញ ដូវ អាញ់ អា ហង ហះកា មួត រ៉ាគឹយ ប‌៉្រ័ះ បាល ទី ៤៥០ ដូវ។ ");
INSERT INTO tpu_vpl VALUES ("K118_23","012_18_23","1KI","18","23","23","ហគ់ អ្យក់ ឡាំ រ៉ក់ ទោល ពៀរ កាតុ កេះណោះ អន់ អន់ឌែ រ៉ើស អ្យក់ កា អន់ឌែ ម៉ោញ កាតុ កេះណោះ កោះ រ៉ាឡៃ ចៃគ ពឹង ប៉ានូក រ៉ាម៉េះ ហះកា ជែ ប៉ាកូះ អុញ។ កាប៉ាច់ អាញ់ ចឹង អ្យក់ រ៉ក់ ម៉ោញ កាតុ ចៃគ ពឹង ប៉ានូក រ៉ាម៉េះ អូ ប៉ាកូះ អុញ និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K118_24","012_18_24","1KI","18","24","24","កេះណោះ ប៉្រើ រ៉ាគឹយ ប‌៉្រ័ះ បាល ម៉ន់ អើ ប‌៉្រ័ះ អន់ឌែ ហះកា អាញ់ ម៉ន់ អើ ប‌៉្រ័ះ ប៊កកាតយ័ ដេល។ ចាំ ហៃ ប‌៉្រ័ះ ចំ ចឹង ប៉្រគ័ ពួយ អន់ អុញ សា ប‌៉្រ័ះ ណោះ ហង ឡាក់ ប‌៉្រ័ះ តាទឹច»។ ប៉ាសុន ទិឌូ តើល ផា «អឺះ ដាគ់ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("K118_25","012_18_25","1KI","18","25","25","វគ័ អេលីយ៉ា រ៉ះ កា មួត រ៉ាគឹយ ប‌៉្រ័ះ បាល ផា «ហគ់ រ៉ើស អ្យក់ រ៉ក់ ទោល ម៉ោញ កាតុ សាំរ៉ាប់ កា អន់ដីស កេះណោះ កោះ ចៃគ ពឹង រ៉ាម៉េះ ហះកា ជែ ប៉ាកូះ អុញ។ ហគ់ អន់ដីស ម៉ន់ អើ ប‌៉្រ័ះ អន់ដីស អន់ទ្រួល ឡឹង អាញ់ ពិ ខង អន់ដីស អៀង ដូវ»។ ");
INSERT INTO tpu_vpl VALUES ("K118_26","012_18_26","1KI","18","26","26","អន់ឌែ កា អ្យក់ រ៉ក់ ទោល ម៉ោញ កាតុ កោះ រ៉ាឡៃ ចៃគ ពឹង ប៉ានូក រ៉ាម៉េះ កេះណោះ ម៉ន់ ឡោម ប‌៉្រ័ះ បាល ឡឹង កាំលឺ ទឹល ដារ់ ប៉ង់ «អឺ ប‌៉្រ័ះ បាល ប៉រ់ អីស ប៉្រគ័ អន់ ទី អុញ កា ញឹន ណើ !» ហះកា អូ កាតាំង ប៉ានឹរ ញ៉ា តើល អុះ។ អន់ឌែ កាតាប័ តារ័ ជុំ អន់ហ្នឹង ឡាក់ អន់ឌែ ប៉្រគ័ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K118_27","012_18_27","1KI","18","27","27","ប៉ាគ់ ទឹល ដារ់ ប៉ង់ វគ័ អេលីយ៉ា កាប ប៉ាឡៃវ កា អន់ឌែ ផា «ហគ់ អន់ដីស ខំ ស៊្រែក អន់ ម៉ៃៗ ប‌៉្រ័ះ បាល ឡាក់ ប‌៉្រ័ះ តាទឹច ហង អ្យូគ ផាហៃគ អ៊ែ ផះ ឃឹត ចាជ្រែប លើ ផោត លើ អ្យូគ ផាហៃគ អ៊ែ ផះ ចាក លើ ផះ តៃប ហ្លាក់ ត័ះ ទឹល នីណោ័ះ រ៉ោ អន់ អ៊ែ សាទឹរ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("K118_28","012_18_28","1KI","18","28","28","អន់ឌែ ស៊្រែក លូ ឡោម ឡា ហ៊ែង ម៉ៃៗ ទឹប អ្យក់ ដាវ លើ សាំង រែក ឡាកោ ប៉ាំងឡៃ ពួយ គុន តាឡាប័ ឃើយ អន់ឌែ ទឹល ផាម ហូរ័ ប៉ាញ័ ឡាកោ។ ");
INSERT INTO tpu_vpl VALUES ("K118_29","012_18_29","1KI","18","29","29","ប៉ាគ់ ទឹល ដារ់ សិ អន់ឌែ កា អ្វៃ ស៊្រែក អើ ប‌៉្រ័ះ បាល លើយ ទឹល កាង៉ាច មង ពូ ឃើយ ទៀន សាណា កា ប‌៉្រ័ះ ប៊កកាតយ័ ។ ហះកា អូ កាតាំង ប៉ានឹរ តើល លូ អូ ទី សារ ញ៉ា កើត ពឹះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K118_30","012_18_30","1KI","18","30","30","កេះណោះ វគ័ អេលីយ៉ា រ៉ះ កា ប៉ាសុន ទិឌូ ផា «ចុ ម៉ុត អន់ ក្យាម័ អាញ់ !» ប៉ាសុន ទិឌូ កា ម៉ុត ក្យាម័ អ៊ែ។ វគ័ អេលីយ៉ា កា ប៉ាយ៉ាម័ អន់ហ្នឹង សាំរ៉ាប់ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ពូ ថាំឡាយ អ្លាត ពែ។ ");
INSERT INTO tpu_vpl VALUES ("K118_31","012_18_31","1KI","18","31","31","អ៊ែ អ្យក់ អំហ្មោ ១២ កាតុ ពួយ ចំលួន ផូង័ វ៉ាច់ គន សោ វគ័ យ៉ាកុប។ វគ័ យ៉ាកុប អា ហង ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ តូរ័ សិច ផា អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("K118_32","012_18_32","1KI","18","32","32","វគ័ អេលីយ៉ា អ្យក់ អំហ្មោ ១២ កាតុ ណោះ ប៉្រគ័ អន់ហ្នឹង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ទឹប សីរ ឡូះ ជុំ ណោះ ម៉ាគ់ អ្លុ តូះ ទៀក ឃឺ អ៊ែ ក្យិប ១៥ លិត។ ");
INSERT INTO tpu_vpl VALUES ("K118_33","012_18_33","1KI","18","33","33","អ៊ែ កា ពូក រ៉ាម៉េះ ចៃគ ពឹង អន់ហ្នឹង កេះណោះ អ្យក់ រ៉ក់ កោះ រ៉ាឡៃ ចៃគ ពឹង រ៉ាម៉េះ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K118_34","012_18_34","1KI","18","34","34","អ៊ែ រ៉ះ ផា «ហគ់ អោះ ទៀក អន់ ទី ប៉្វាន់ ព្រឺយ តូះ ពឹង កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ លូ ពឹង រ៉ាម៉េះ ណោះ»។ ពូ កា ប៉្រគ័ ពួយ ប៉ានឹរ អ៊ែ រ៉ះ។ កេះណោះ អ៊ែ រ៉ះ ណាវ្គ ផា «ហគ់ អោះ ទៀក ម៉ោញ ទង ណាវ្គ»។ ពូ កា ប៉្រគ័ ពួយ ប៉ានឹរ អ៊ែ រ៉ះ លឺក ទី ពៀរ។ កេះណោះ អ៊ែ រ៉ះ ណាវ្គ ផា «ហគ់ អោះ ទៀក ម៉ោញ ទង ណាវ្គ»។ ពូ កា ប៉្រគ័ ពួយ ប៉ានឹរ អ៊ែ លឺក ទី ប៉ៃង។ ");
INSERT INTO tpu_vpl VALUES ("K118_35","012_18_35","1KI","18","35","35","ទៀក ហូរ័ ប៉ាញ័ ទឹប អន់ហ្នឹង ណោះ ពឹង ឡូះ ឡាក់ អ៊ែ សីរ ណោះ ប៉ាញ័ កា ទៀក ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K118_36","012_18_36","1KI","18","36","36","ប៉ាគ់ កាង៉ាច ផះ មង ពូ ឃើយ ទៀន សាណា កា ប‌៉្រ័ះ ប៊កកាតយ័ វគ័ អេលីយ៉ា ម៉ុត ក្យាម័ អន់ហ្នឹង លូ កាប ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អាប៉្រាហាំ អ៊ីសាក់ លូ អ៊ីស្រាអ៊ែល ដារ់ អា ប៉រ់ អីស តាំបាង អន់ កា ប៉ាសុន អ្លុ អន់តគ់ ផា អីស ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល តាទឹច លូ អ្លុ អន់តគ់ ផា អាញ់ ឡាក់ ទុច អីស លូ អាញ់ ប៉្រគ័ សារ អំរ៉ាញ អឺញ អា ឃឺ ឡាច់ ឡឹង អីស។ ");
INSERT INTO tpu_vpl VALUES ("K118_37","012_18_37","1KI","18","37","37","អឺ ប‌៉្រ័ះ ប៊កកាតយ័  ប៉រ់ អីស តាប៉ាប តាប៉ុន សាំយ៉ាំង អាញ់ ណើ ប៉រ់ អីស ប៉្រគ័ អន់ ទី អុញ ភឿ អន់ ប៉ាសុន ទិ អា អ្លុ អន់តគ់ ផា អីស ឡាក់ ប‌៉្រ័ះ តាទឹច លូ អីស ប៉្រគ័ អន់ អន់ឌែ ប៉ិនពែង ពុត ពៀក វ៉ីល ប៉ាគ់ អីស ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("K118_38","012_18_38","1KI","18","38","38","ផាឌី ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉ាឡិ ជឹរ អុញ អន់ សា កាណាគ័ វគ័ អេលីយ៉ា រ៉ាម៉ះ ណោះ ទឹប រ៉ាម៉េះ ទឹប អំហ្មោ ទឹប តេះ ទៀក ឡាក់ ពូ តូះ ណោះ កា ស្វាត់ ក្រោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K118_39","012_18_39","1KI","18","39","39","ផះ មួត ប៉ាសុន ប៉ប័ សារ ទិណោ័ះ អន់ឌែ កា ប៉ាណាំ គួប កុប កល់ ទឹះ តេះ ឡូត ទឹប កាប ផា «ប‌៉្រ័ះ ប៊កកាតយ័ ហង ឡាក់ ប‌៉្រ័ះ តាទឹច !» ");
INSERT INTO tpu_vpl VALUES ("K118_40","012_18_40","1KI","18","40","40","វគ័ អេលីយ៉ា រ៉ះ កា ពូ ផា «ហគ់ រ៉ុប ចគ់ មួត រ៉ាគឹយ ប‌៉្រ័ះ បាល ជែ អន់ ទី ម៉ោញ ដូវ សាតាក់ រ៉ាវ៉ាច់ ដៃ !» ប៉ាសុន កា ប៉ាណាំ គួប រ៉ុប មួត រ៉ាគឹយ ប‌៉្រ័ះ បាល តាទឹច ហង។ កេះណោះ វគ័ អេលីយ៉ា ប៉្រើ ពូ អ្យក់ ឡាំ ប៉ាគ់ ទ្រូង ទៀក គីសុន កេះណោះ អ៊ែ ប៉ាន់តោ័ អ្លាត រ៉ាគឹយ ប‌៉្រ័ះ បាល ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("K118_41","012_18_41","1KI","18","41","41","វគ័ អេលីយ៉ា ឡាំ រ៉ះ លូ សាដាច់ អាហាប់ ផា «ហគ់ អីស សឹត សា សាណា អៃត ទៀក ពិ ខង អាញ់ កាតាំង យឹង បី តីស ចឹង ទឹល កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("K118_42","012_18_42","1KI","18","42","42","កេះណោះ សាដាច់ អាហាប់ កា សឹត សា សាណា អៃត ទៀក ឡូត។ ហះកា វគ័ អេលីយ៉ា ហាវ ពឹង កល់ ប៉ានឹម កាមែល កេះណោះ ជន តាកុល កុប កល់ ហះ តាវ៉ាង័ តាកុល។ ");
INSERT INTO tpu_vpl VALUES ("K118_43","012_18_43","1KI","18","43","43","អ៊ែ រ៉ះ កា ទុច អ៊ែ ផា «ហគ់ ហាវ បៀត ហៃ គែង ទៀក សាឡីគ សាឡាយ»។ ទុច អ៊ែ ណោះ អ្យូវ ហៃ កេះណោះ រ៉ះ ផា «អាញ់ អូ ប៉ប័ ញ៉ា អុះ»។ វគ័ អេលីយ៉ា ប៉្រើ ទុច អ្យូវ ហៃ អន់ តាំប៉ើះ ទង។ ");
INSERT INTO tpu_vpl VALUES ("K118_44","012_18_44","1KI","18","44","44","ប៉ាគ់ ទុច អ៊ែ អ្យូវ ហៃ លឺក ទី តាំប៉ើះ អ៊ែ រ៉ះ លូ វគ័ អេលីយ៉ា ផា «អាញ់ ប៉ប័ កាម៉ល់ ថិ តុ អំប៉ាំង តី ហាវ ឡឹង ទៀក សាឡីគ សាឡាយ»។ វគ័ អេលីយ៉ា រ៉ះ ផា «ហគ់ ឡាំ រ៉ះ កា សាដាច់ អាហាប់ ពិ ប៉្រើ អ៊ែ ជិះ រ៉ាតេ័ះ ជឹរ ឡឹង ប៉ានឹម ស៊្រសៗ ជែ អន់ ត្រគ់ ទៀក បី»។ ");
INSERT INTO tpu_vpl VALUES ("K118_45","012_18_45","1KI","18","45","45","ផះ ណោះ តើម បី ហ៊ែង តីស ៗ ទឹប ទី បី ខ្យាល វ៉ាល ពុត សាដាច់ អាហាប់ ជិះ រ៉ាតេ័ះ សេះ ឡាំ ប៉ាគ់ មឿង យេសារៀល។ ");
INSERT INTO tpu_vpl VALUES ("K118_46","012_18_46","1KI","18","46","46","វគ័ អេលីយ៉ា កា កត់ អាវ ពឹង សាំងគៀង ផះ ណោះ សារ អំរ៉ាញ អឺញ ប‌៉្រ័ះ ប៊កកាតយ័ ម៉ុត ពឹង អ៊ែ អ៊ែ កា សាតាក់ ហះ ង៉ីរ រ៉ាតេ័ះ សាដាច់ អាហាប់ លើយ ទឹល ប៉ាគ់ អំប៉ារ ទ្រួក មឿង យេសារៀល។ ");
INSERT INTO tpu_vpl VALUES ("K119_1","012_19_1","1KI","19","1","1","សាដាច់ អាហាប់ រ៉ះ លូ កាម៉ាញ់ អ៊ែ យេសិបិល ទិ សារ ឡាក់ វគ័ អេលីយ៉ា ប៉្រគ័ លូ សារ អ៊ែ ប៉ាន់តោ័ មួត រ៉ាគឹយ ប‌៉្រ័ះ បាល ទិណោ័ះ លូ ដាវ។ ");
INSERT INTO tpu_vpl VALUES ("K119_2","012_19_2","1KI","19","2","2","យ៉ាគ់ យេសិបិល កា ប៉្រើ ពូ ឡាំ រ៉ះ លូ វគ័ អេលីយ៉ា ផា «ប៉ាគ់ ដារ់ តាយ៉ាង័ មង ប៉ុប អា ទៅ ផា អាញ់ អូ ប៉ាន់តោ័ អីស ឡាក់ កា អីស ប៉ាន់តោ័ រ៉ាគឹយ ប‌៉្រ័ះ បាល ពែ អន់ ប‌៉្រ័ះ ពឹង អង់កក់ តេះ អា ទិណោ័ះ ចៃគ ថូត អាញ់ អន់ ក្លាំង កាខាក់ ឡូត»។ ");
INSERT INTO tpu_vpl VALUES ("K119_3","012_19_3","1KI","19","3","3","វគ័ អេលីយ៉ា អ្យូគ កាខរ់ ណូស ខាក់ អ៊ែ សាតាក់ ឡាំ ប៉ាគ់ មឿង បៀសេបា ពឹង ប៉ាថេត យូដា ភឿ អន់ រ៉ាវ៉ាច់ ឡាកោ អ៊ែ កា ប៉្រើ ទុច អ៊ែ អ្វៃ ហះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K119_4","012_19_4","1KI","19","4","4","កាប៉ាច់ អ៊ែ ចាក ឡាំ ប៉ាគ់ ស៊្រែ តីស ទិ ម៉ោញ ដារ់ ឡាំ អង់អ្វៃ ហះ កានឺប តើម អ៊្លង កេះណោះ ម៉ន់ ឡោម ប‌៉្រ័ះ ប៉ិច កា តោ័ ទឹប កាប ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័  អាញ់ អូ ដាម័ អត់ កេះ កិញអៀ អា ប៉រ់ អីស អ្យក់ ឡាច់ អាញុ អាញ់ ខង អាញ់ ប៉ិច កា តោ័ ឡាក់ កា វគ័ យ៉ាគ់ អាញ់ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("K119_5","012_19_5","1KI","19","5","5","កេះណោះ អ៊ែ តៃប ហ្លាក់ ហះ កានឺប តើម អ៊្លង។ ផាឌី ទី ប៊យ ប‌៉្រ័ះ ម៉ោញ ដូវ ពឹះ រ៉ោ អ៊ែ ផា «ហគ់ អ្យូវ សា សាណា ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("K119_6","012_19_6","1KI","19","6","6","វគ័ អេលីយ៉ា កាលែង ហៃ ប៉ប័ ណុំ ប៉ាំង ផះ អ្វៃ តាទៀង ពឹង អំហ្មោ តុ លូ ទៀក ពឹង ព្រឺយ អ៊ែ កា សា លូ អៃត ទៀក កេះណោះ អ៊ែ តៃប ហ្លាក់ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("K119_7","012_19_7","1KI","19","7","7","ផះ ណោះ ប៊យ ប‌៉្រ័ះ ប៊កកាតយ័ ជឹរ រ៉ោ អ៊ែ ម៉ោញ ទង ណាវ្គ ទឹប កាប ផា «ហគ់ អ្យូវ សា សាណា ខង អីស ត្រគ់ ចាក ចាំងហាយ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("K119_8","012_19_8","1KI","19","8","8","អ៊ែ កា អ្យូវ សា ណុំ ប៉ាំង លូ អៃត ទៀក។ ញន កា សាណា ណោះ អ៊ែ ទី សាងុំ ចាក ៤០ ម៉ាំង ៤០ ដារ់ លើយ ទឹល ប៉ាគ់ ប៉ានឹម ស៊ីណាយ ឡាក់ ចារ ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("K119_9","012_19_9","1KI","19","9","9","ប៉ាគ់ ទឹល ប៉ានឹម ស៊ីណាយ កេះ វគ័ អេលីយ៉ា ម៉ុត ដំ ពឹង រ៉ូង័ អំហ្មោ។ ផះ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កាប លូ អ៊ែ ផា «អឺ អេលីយ៉ា អីស ឡាំ ប៉ាគ់ អា ប៉្រគ័ ញ៉ា ?» ");
INSERT INTO tpu_vpl VALUES ("K119_10","012_19_10","1KI","19","10","10","អ៊ែ តើល ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ តេះ ប‌៉្រ័ះ ប៉្លៃង អាញ់ ប៉្រគ័ ង៉ារ កា អីស ទិ ពុត ទិ ពៀក។ ហះកា ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ អ្លាត ប៉្រគ័ ពួយ សារ អីស សាញ៉ា រែវ ពុត  ទឹប អន់ឌែ ថាំឡាយ អន់ហ្នឹង រ៉ាម៉ះ អីស លូ ប៉ាន់តោ័ អ្លាត រ៉ាគឹយ អីស ទិណោ័ះ លូ ដាវ អ្វៃ សល់ ដឹង ម៉ោញ ដូវ អាញ់ កិញអៀ អា ពូ ណាំង ប៉ាន់តោ័ អាញ់ ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("K119_11","012_19_11","1KI","19","11","11","ប‌៉្រ័ះ ប៊កកាតយ័ តើល ផា «ហគ់ ឡាច់ ប៉ាគ់ ឡីង កេះណោះ តាវ ពឹង ប៉ានឹម ហះ ម៉ាត់ អាញ់។ បៀត ណាវ្គ អាញ់ ចឹង ចាក ទ្រួង»។ កេះណោះ កា ទី ខ្យាល តីស កាខាក់ ប៉្រគ័ អន់ រ៉ាយ៉ាគ់ ប៉ាញ័ ប៉ានឹម ទឹប ប៉្រគ័ អន់ អំហ្មោ ប៉ាទុះ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័  ហះកា អ៊ែ អូ អ្វៃ ពឹង ខ្យាល ណោះ អុះ។ ប៉ាគ់ ស្វាស ខ្យាល កេះ កា ទី រ៉ារ៉ៃត តេះ ណាវ្គ ហះកា ប‌៉្រ័ះ កា អូ អ្វៃ ពឹង តេះ រ៉ារ៉ៃត ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K119_12","012_19_12","1KI","19","12","12","ឡៃង ឡឹង រ៉ារ៉ៃត តេះ កា ទី អុញ ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ អូ អ្វៃ ពឹង អុញ ណោះ ដេល។ ឡៃង ឡឹង អុញ កាតាំង ប៉ានឹរ កាប ប៉ាឡឹងៗ ។ ");
INSERT INTO tpu_vpl VALUES ("K119_13","012_19_13","1KI","19","13","13","ផះ វគ័ អេលីយ៉ា កាតាំង ប៉ានឹរ ណោះ អ៊ែ កា អ្យក់ អាវ តីស សាក្លុំ ម៉ាត់ កេះណោះ ឡាច់ ឡាំ អន់តាវ ហះ អំប៉ារ រ៉ូង័ អំហ្មោ អ៊ែ កាតាំង ប៉ានឹរ ប‌៉្រ័ះ អំប៉ញ់ អ៊ែ ផា «អឺ អេលីយ៉ា អីស ឡាំ ប៉ាគ់ អា ប៉្រគ័ ញ៉ា ?» ");
INSERT INTO tpu_vpl VALUES ("K119_14","012_19_14","1KI","19","14","14","អ៊ែ តើល ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ តេះ ប‌៉្រ័ះ ប៉្លៃង អាញ់ ប៉្រគ័ ង៉ារ កា អីស ទិ ពុត ទិ ពៀក។ ហះកា ប៉ាសុន អ៊ីស្រាអ៊ែល ទិឌូ អ្លាត ប៉្រគ័ ពួយ សារ អីស សាញ៉ា រែវ ពុត ទឹប អន់ឌែ ថាំឡាយ អន់ហ្នឹង រ៉ាម៉ះ អីស លូ ប៉ាន់តោ័ អ្លាត រ៉ាគឹយ អីស ទិណោ័ះ លូ ដាវ អ្វៃ សល់ ដឹង ម៉ោញ ដូវ អាញ់ កិញអៀ អា ពូ ណាំង ប៉ាន់តោ័ អាញ់ ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("K119_15","012_19_15","1KI","19","15","15","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ផា «ហគ់ សឹត ទ្រង ទៅ កេះណោះ ឡាំ ប៉ាគ់ ស៊្រែ តីស ក្យាម័ មឿង ដាម៉ះ។ ប៉ាគ់ ឡាំ ទឹល ប៉ាគ់ ណោះ កេះ អីស ត្រគ់ ជ្រោ សាងី ពឹង ហាស៊ែល ប៉្រើ អ៊ែ ប៉្រគ័ សាដាច់ ពឹង ប៉ាថេត ស៊ីរី។ ");
INSERT INTO tpu_vpl VALUES ("K119_16","012_19_16","1KI","19","16","16","ឡៃង ឡឹង ណោះ អីស ត្រគ់ ជ្រោ សាងី ពឹង យេហ៊ូ គន នឹមស៊ី ប៉្រើ អ៊ែ ប៉្រគ័ សាដាច់ ប៉ាថេត អ៊ីស្រាអ៊ែល កេះណោះ អីស ត្រគ់ ជ្រោ សាងី ពឹង អេលីសេ គន វគ័ សាផាត ប៉ាគ់ តេះ អេបិល ម៉ាហូឡា ប៉្រើ ប៉្រគ័ រ៉ាគឹយ ប‌៉្រ័ះ ប៉ាតាង អីស។ ");
INSERT INTO tpu_vpl VALUES ("K119_17","012_19_17","1KI","19","17","17","ទឹល នីណោ័ះ ពឿ រ៉ាវ៉ាច់ ឡឹង ប៉្លា ដាវ ហាស៊ែល ណោះ ចឹង ត្រគ់ ប៉្លា ដាវ យេហ៊ូ ពឿ រ៉ាវ៉ាច់ ឡឹង ប៉្លា ដាវ យេហ៊ូ ណោះ ចឹង ត្រគ់ ប៉្លា ដាវ អេលីសេ។ ");
INSERT INTO tpu_vpl VALUES ("K119_18","012_19_18","1KI","19","18","18","ហះកា អាញ់ ចឹង គម ប៉ាណូស ៧០០០ ដូវ ពឹង ប៉ាថេត អ៊ីស្រាអ៊ែល អន់ អ្វៃ រ៉ីស ឃឺ មួត បក់ អូ ជន តាកុល សាំប‌៉័ះ ប‌៉្រ័ះ បាល ទឹប អូ ចុំ ហ៊ូប អ៊ែ ណោះ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("K119_19","012_19_19","1KI","19","19","19","វគ័ អេលីយ៉ា ឡាច់ ឡឹង ណោះ ឡាំ ណាំង អេលីសេ គន វគ័ សាផាត អ៊ែ ប៉ប័ ផះ អ្វៃ ថៃ ម៉ីរ ប៉ាណូស ថៃ ម៉ីរ ទិណោ័ះ ទី ១២ ដូវ វគ័ អេលីសេ អ្វៃ ថៃ អន់តីគ ឡឹង ពូ។ វគ័ អេលីយ៉ា កា ឡាំ ក្យាម័ ទឹប រ៉ីស អាវ តីស តាគ់ អំពៀត អេលីសេ កេះណោះ ចាក ឡាច់។ ");
INSERT INTO tpu_vpl VALUES ("K119_20","012_19_20","1KI","19","20","20","វគ័ អេលីសេ កា អ្លាត រ៉ក់ កេះណោះ ប៉ាន់តាន ចាក ពួយ វគ័ អេលីយ៉ា លូ កាប ផា «អាញ់ ប៉រ់ សឹត រ៉ះ លូ ពឹ មើគ អាញ់ បៀត ហិ កេះណោះ អាញ់ ចឹង ឡាំ ពួយ អីស»។ វគ័ អេលីយ៉ា តើល ផា «សឹត ពិ អាញ់ អូ ផា ញ៉ា អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("K119_21","012_19_21","1KI","19","21","21","វគ័ អេលីសេ កា ឡាច់ ឡឹង វគ័ អេលីយ៉ា វ៉ីល សឹត ប៉ាគ់ ចារ អ៊ែ ថៃ ម៉ីរ ណាវ្គ។ អ៊ែ អ្យក់ រ៉ក់ ទិ ពៀរ កាតុ កោះ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ លូ អ្យក់ ហាក ថៃ ប៉្រគ័ រ៉ាម៉េះ តាអាំង ប៉ាំងឡៃ រ៉ក់ កេះណោះ ជែក អន់ កា មួត អ្វៃ រសានែង ណោះ សា។ កេះណោះ អ៊ែ ចាក ពួយ វគ័ អេលីយ៉ា ភឿ ប៉្រគ័ ង៉ារ កា អ៊ែ។ … ");
INSERT INTO tpu_vpl VALUES ("K121_1","012_21_1","1KI","21","1","1","ឡៃង ឡឹង ណោះ ទី កាម៉ាក័ ម៉ោញ ដូវ ឡឹង មឿង យេសារៀល សិច អ៊ែ ណាបោត អ៊ែ ទី ម៉ីរ ប៉្លៃ អង់កាច ក្យាម័ ហី សាដាច់ អាហាប់ ឡាក់ រ៉ាំងហៃ ពឹង មឿង សាម៉ារី។ ");
INSERT INTO tpu_vpl VALUES ("K121_2","012_21_2","1KI","21","2","2","សាដាច់ អាហាប់ អ៊ែ ប៉រ់ លូ វគ័ ណាបោត ផា «ប៉ឹះ អន់ កា អាញ់ ម៉ីរ ប៉្លៃ អង់កាច អីស អា ម៉ាគ់ អាញ់ តប់ ហ្លា អ្យិត ខង ម៉ីរ អីស អា ក្យាម័ ហី អាញ់។ អាញ់ ចឹង អន់ ម៉ីរ ប៉្លៃ អង់កាច ម៉ោញ ចារ ឡាក់ ដាគ់ ហ៊្លត ឡឹង អា ណាវ្គ លើ ផា អីស ប៉ិច កា លៀន អាញ់ ចឹង អន់ លៀន តាម ខា ម៉ីរ អីស អា»។ ");
INSERT INTO tpu_vpl VALUES ("K121_3","012_21_3","1KI","21","3","3","វគ័ ណាបោត តើល សាដាច់ អាហាប់ ផា «អាញ់ អូ អន់ កា អីស អុះ ប៉ាដក់ ប៉ាជៀ ឡឹង វគ័ យ៉ាគ់ អាញ់ អន់ ប‌៉្រ័ះ ប៊កកាតយ័ ចៃគ ថូត អាញ់ ផា អាញ់ អន់ ប៉ាដក់ ប៉ាជៀ អា កា អីស»។ ");
INSERT INTO tpu_vpl VALUES ("K121_4","012_21_4","1KI","21","4","4","សាដាច់ អាហាប់ សឹត ប៉ាគ់ ហី អ៊ែ ទឹប អុក ពុត ពៀក ទឹប ប៉ិច អឺក ខាក់ ញន កា សារ វគ័ ណាបោត កាប ផា «អាញ់ អូ អន់ តេះ ប៉ាដក់ ប៉ាជៀ អា កា អីស អុះ»។ កេះណោះ អ៊ែ តៃប វ៉ីស ម៉ាត់ គែង ប៉ាណីរ ទឹប អូ សា សាណា ញ៉ា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K121_5","012_21_5","1KI","21","5","5","កាម៉ាញ់ អ៊ែ យេសិបិល កា ម៉ុត ប៉ាគ់ ចារ អ៊ែ លូ អំប៉ញ់ ផា «ញ៉ា ត្រគ់ អីស អុក ពុត ពៀក អូ សា សាណា នីអៀ ?» ");
INSERT INTO tpu_vpl VALUES ("K121_6","012_21_6","1KI","21","6","6","អ៊ែ រ៉ះ លូ កាម៉ាញ់ អ៊ែ ផា «អាញ់ ប៉រ់ លូ ណាបោត ឡឹង មឿង យេសារៀល ផា \"អីស ប្រូ ម៉ីរ ប៉្លៃ អង់កាច អីស អា អន់ កា អាញ់ លើ ផា អីស អូ ចៃ កា លៀន អាញ់ ចឹង តូរ័ លូ ម៉ីរ ប៉្លៃ អង់កាច ម៉ោញ ចារ ណាវ្គ កាតាម\"។ ហះកា អ៊ែ តើល ផា \"អាញ់ អូ អន់ ម៉ីរ អា កា អីស អុះ\"»។ ");
INSERT INTO tpu_vpl VALUES ("K121_7","012_21_7","1KI","21","7","7","កាម៉ាញ់ អ៊ែ កាប ផា «ញ៉ា អីស អូ ត្រគ់ សាដាច់ អ៊ីស្រាអ៊ែល ប ? ហគ់ អ្យូវ សា សាណា ពិ ទឹប ទី ពុត ហោក រ៉គ់ ក្យាគ់ អាញ់ ចឹង ឡាំ អ្យក់ ម៉ីរ ប៉្លៃ អង់កាច វគ័ ណាបោត ណោះ អន់ កា អីស»។ ");
INSERT INTO tpu_vpl VALUES ("K121_8","012_21_8","1KI","21","8","8","កេះណោះ យេសិបិល ច្រាគ់ សត់ត្រា ចៃគ សិច អាហាប់ ទឹប ប៉ាតឹត ត្រា អ៊ែ ដេល កេះណោះ ប៉ាហ្យើ សត់ត្រា អន់ កា មួត ក្រាគ់ តាំងកង់ លូ មួត ម៉ៃគ ណាំផា ឡាក់ អ្វៃ ពឹង មឿង យេសារៀល អន់ឌូ លូ វគ័ ណាបោត។ ");
INSERT INTO tpu_vpl VALUES ("K121_9","012_21_9","1KI","21","9","9","ពឹង សត់ត្រា ណោះ យេសិបិល ច្រាគ់ ផា «ហគ់ រ៉ះ លូ ប៉ាសុន អន់ ប៉ាតុំ គួប កំ អូ សា សាណា ទឹប អន់ វគ័ ណាបោត អង់អ្វៃ ពឹង ចារ ក្រាគ់ បក់ កានឹត ហ៊្លត ឡឹង ពូ ហះ ម៉ាត់ ប៉ាសុន។ ");
INSERT INTO tpu_vpl VALUES ("K121_10","012_21_10","1KI","21","10","10","កេះណោះ ប៉្រើ ប៉ាណូស អូ ដាគ់ ពៀរ ដូវ ប៉្រគ័ ផាញ៉ាន ច្រោម ផា អ៊ែ អា ផាម៉ាត ប‌៉្រ័ះ ប៊កកាតយ័ លូ ផាម៉ាត សាដាច់។ កេះណោះ អ្យក់ អ៊ែ ឡាច់ ប៉ាគ់ ឡីង ហឹរ ប៉ាន់តោ័ អ៊ែ លូ អំហ្មោ»។ ");
INSERT INTO tpu_vpl VALUES ("K121_11","012_21_11","1KI","21","11","11","មួត ក្រាគ់ តាំងកង់ លូ ម៉ៃគ ណាំផា ឡាក់ អ្វៃ ពឹង មឿង ណោះ កា ប៉្រគ័ ពួយ សារ យេសិបិល ច្រាគ់ កាណុង សត់ត្រា ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K121_12","012_21_12","1KI","21","12","12","អន់ឌែ រ៉ះ ឡឹង សារ កំ អូ សា សាណា ទឹប អន់ វគ័ ណាបោត អង់អ្វៃ ពឹង ចារ ដាគ់ ហះ ម៉ាត់ ប៉ាសុន។ ");
INSERT INTO tpu_vpl VALUES ("K121_13","012_21_13","1KI","21","13","13","មួត ព្លូង ប៉្លាច័ ពៀរ ដូវ កា អ្វៃ អន់ឌូ ហះ ង៉ីរ វគ័ ណាបោត ទឹប ច្រោម អ៊ែ ហះ ម៉ាត់ ប៉ាសុន ផា «វគ័ ណាបោត ផាម៉ាត ប‌៉្រ័ះ លូ ផាម៉ាត សាដាច់»។ ណោះ ហង បះ ប៉ាសុន អ្យក់ អ៊ែ ឡាច់ គែង ឡីង មឿង កេះណោះ ហឹរ ប៉ាន់តោ័ អ៊ែ លូ អំហ្មោ។ ");
INSERT INTO tpu_vpl VALUES ("K121_14","012_21_14","1KI","21","14","14","កេះណោះ អន់ឌែ ប៉្រើ ពូ ឡាំ រ៉ះ លូ យេសិបិល ផា «ញឹន ហឹរ ប៉ាន់តោ័ កេះ វគ័ ណាបោត ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("K121_15","012_21_15","1KI","21","15","15","ប៉ាគ់ យេសិបិល កាតាំង ផា ពូ ប៉ាន់តោ័ វគ័ ណាបោត កេះ អ៊ែ កា រ៉ះ លូ សាដាច់ អាហាប់ ផា «ហគ់ ឡាំ អ្យក់ ពិ ម៉ីរ ប៉្លៃ អង់កាច ណាបោត ឡាក់ អ៊ែ អូ ចៃ ប្រូ អន់ កា អីស ខង អ៊ែ តោ័ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("K121_16","012_21_16","1KI","21","16","16","ប៉ាគ់ សាដាច់ អាហាប់ កាតាំង ផា វគ័ ណាបោត តោ័ កេះ អ៊ែ កា ឡាំ អ្យក់ ម៉ីរ ប៉្លៃ អង់កាច វគ័ ណាបោត ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K121_17","012_21_17","1KI","21","17","17","ផះ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ លូ វគ័ អេលីយ៉ា ឡាក់ ប៉ាណូស ឡឹង តេះ ធេសាប៊ី ផា ");
INSERT INTO tpu_vpl VALUES ("K121_18","012_21_18","1KI","21","18","18","«ហគ់ អីស ឡាំ កាប កា អាហាប់ ឡាក់ សាដាច់ អ៊ីស្រាអ៊ែល ឡាក់ រ៉ាំងហៃ ពឹង មឿង សាម៉ារី។ កិញអៀ អា អាហាប់ អ្វៃ ពឹង ម៉ីរ ប៉្លៃ អង់កាច ណាបោត ឡាក់ អ៊ែ រ៉ាត អ្យក់ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K121_19","012_21_19","1KI","21","19","19","អីស ត្រគ់ រ៉ះ កា អ៊ែ ផា \"ខ ញ៉ា អីស ប៉ាន់តោ័ ពូ កេះណោះ រ៉ាត អ្យក់ តេះ ពូ ?\" លូ អីស ត្រគ់ រ៉ះ ណាវ្គ ផា \"ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ផា 'សូ ឡីត ផាម ណាបោត ប៉ាគ់ ចំ សូ កា ចឹង ឡីត ផាម អីស ប៉ាគ់ ណោះ ដេល' \"»។ ");
INSERT INTO tpu_vpl VALUES ("K121_20","012_21_20","1KI","21","20","20","ផះ សាដាច់ អាហាប់ ប៉ប័ វគ័ អេលីយ៉ា អ៊ែ កាប ផា «អឺ តាម៉ឺរ អីស ណាំង អាញ់ ប៉ប័ កេះ អ៊ិះ ?» វគ័ អេលីយ៉ា តើល ផា «អាញ់ ណាំង អីស ញន កា អីស ទឹមវ៉ៃរ ឡាកោ អន់ ប៉្រគ័ សារ អូ ដាគ់ ឡាក់ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("K121_21","012_21_21","1KI","21","21","21","ទឹល នីណោ័ះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ផា \"អាញ់ ចឹង ប៉្រគ័ អន់ អីស ទី សារ ចុនចៃ អាញ់ ចឹង ប៉ាន់តោ័ អ្លាត អីស ទឹប ប៉ាន់តោ័ គន កាម៉ាក័ អីស ទិណោ័ះ យ‌៉័ះ ក្រាគ់ លើ សាស្វា កាតាម អន់ ទិ ឡឹង ប៉ាថេត អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("K121_22","012_21_22","1KI","21","22","22","អាញ់ ចឹង ប៉្រគ័ កា ផូង័ វ៉ាច់ អីស ឡាក់ កា អាញ់ ប៉្រគ័ កា ផូង័ វ៉ាច់ យេរ៉ូបោម គន នេបាត លូ ឡាក់ កា អាញ់ ប៉្រគ័ កា ផូង័ វ៉ាច់ បាសា គន អាហ៊ីយ៉ា ដេល ខង អីស ប៉្រគ័ អន់ អាញ់ អឺក ទឹប អីស ប៉្រគ័ អន់ ប៉ាសុន អ៊ីស្រាអ៊ែល ប៉្រគ័ សារ យច អៀង ខាក់\"។ ");
INSERT INTO tpu_vpl VALUES ("K121_23","012_21_23","1KI","21","23","23","ប‌៉្រ័ះ ប៊កកាតយ័ កា រ៉ះ ឡឹង សារ យេសិបិល ផា \"សូ ចឹង ហ៊ែក សា យេសិបិល ប៉ាគ់ ទ្រួក មឿង យេសារៀល\"។ ");
INSERT INTO tpu_vpl VALUES ("K121_24","012_21_24","1KI","21","24","24","គន សោ អីស បក់ តោ័ ពឹង មឿង ទិ កា សូ សា បក់ តោ័ ប៉ាគ់ ម៉ីរ ស៊្រែ ទិ កា ម៉ីត ចោះ សា ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("K121_25","012_21_25","1KI","21","25","25","អូ ឃើយ ទី បក់ ពឿ ឡាក់ កា សាដាច់ អាហាប់ អុះ ឡាក់ ទឹមវ៉ៃរ ឡាកោ អន់ ប៉្រគ័ សារ អូ ដាគ់ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ញន កាម៉ាញ់ អ៊ែ យេសិបិល ប៉ាញ់សុះ។ ");
INSERT INTO tpu_vpl VALUES ("K121_26","012_21_26","1KI","21","26","26","អ៊ែ ប៉្រគ័ សារ បឺគ អ៊ក ខាក់ ខង អ៊ែ សាំប‌៉័ះ ហ៊ូប ប‌៉្រ័ះ ឡាក់ កា សុនសាត អាម៉ូរី ឃើយ ប៉្រគ័ ដេល ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ តាំងហ្យិត ឡាច់ ឡឹង ម៉ាត់ ប៉ាសុន អ៊ីស្រាអ៊ែល ពែ។ …");
INSERT INTO tpu_vpl VALUES ("K22_1","013_2_1","2KI","2","1","1","ផះ ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉្រគ័ ខ្យាល តាវ៉ាញ់ អ្យក់ ហាវ វគ័ អេលីយ៉ា ពឹង ប៉្លៃង វគ័ អេលីយ៉ា លូ វគ័ អេលីសេ ចាក ឡាច់ ឡឹង មឿង គីលកាល។ ");
INSERT INTO tpu_vpl VALUES ("K22_2","013_2_2","2KI","2","2","2","វគ័ អេលីយ៉ា រ៉ះ កា វគ័ អេលីសេ ផា «ហគ់ អីស ក្យាគ់ អាញ់ ហះ អា ហោគ ខង ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អាញ់ ឡាំ ប៉ាគ់ មឿង បេតអ៊ែល»។ វគ័ អេលីសេ តើល ផា «អាញ់ រ៉ះ កា អីស តាទឹច ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ រ៉ីស លូ ឡាក់ កា អីស អ្វៃ រ៉ីស អាញ់ អូ ក្លះ ឡឹង អីស អុះ»។ អន់ឌែ ពៀរ ដូវ កា ចាក ឡាំ ប៉ាគ់ មឿង បេតអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("K22_3","013_2_3","2KI","2","3","3","ទី រ៉ាគឹយ ប‌៉្រ័ះ ម៉ោញ ក្រុំ អ្វៃ ប៉ាគ់ មឿង បេតអ៊ែល ឡាំ រ៉ះ លូ វគ័ អេលីសេ ផា «ញ៉ា អីស អ្លុ ដេល ប ផា ដារ់ អា ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង អ្យក់ ហាវ ណៃឃូ អីស ពឹង ប៉្លៃង ?» អ៊ែ តើល ផា «អាញ់ អ្លុ ដេល អូ រ៉ះ កា ដាគ់ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("K22_4","013_2_4","2KI","2","4","4","វគ័ អេលីយ៉ា រ៉ះ កា អ៊ែ ផា «អឺ អេលីសេ ហគ់ ក្យាគ់ អាញ់ ហះ អា ហោគ ខង ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អាញ់ ឡាំ ប៉ាគ់ មឿង យេរីខូ»។ វគ័ អេលីសេ តើល ផា «អាញ់ រ៉ះ កា អីស តាទឹច ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ រ៉ីស លូ ឡាក់ កា អីស អ្វៃ រ៉ីស អាញ់ អូ ក្លះ ឡឹង អីស អុះ»។ អន់ឌែ ពៀរ ដូវ កា ឡាំ ទឹល ប៉ាគ់ មឿង យេរីខូ។ ");
INSERT INTO tpu_vpl VALUES ("K22_5","013_2_5","2KI","2","5","5","ទី រ៉ាគឹយ ប‌៉្រ័ះ ម៉ោញ ក្រុំ អ្វៃ ពឹង មឿង យេរីខូ ឡាំ រ៉ះ កា វគ័ អេលីសេ ផា «ញ៉ា អីស អ្លុ ដេល ប ដារ់ អា ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង អ្យក់ ហាវ ណៃឃូ អីស ពឹង ប៉្លៃង ?» អ៊ែ តើល ផា «អាញ់ អ្លុ ដេល អូ រ៉ះ កា ដាគ់ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("K22_6","013_2_6","2KI","2","6","6","វគ័ អេលីយ៉ា រ៉ះ កា អ៊ែ ផា «ហគ់ ក្យាគ់ អាញ់ ហះ អា ហោគ ខង ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អាញ់ ឡាំ ប៉ាគ់ ទៀក ទ្រូង យដាន់»។ វគ័ អេលីសេ តើល អ៊ែ ផា «អាញ់ រ៉ះ កា អីស តាទឹច ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ រ៉ីស លូ ឡាក់ កា អីស អ្វៃ រ៉ីស អាញ់ អូ ក្លះ ឡឹង អីស អុះ»។ អន់ឌែ ពៀរ ដូវ កា ចាក ឡាំ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("K22_7","013_2_7","2KI","2","7","7","ទី រ៉ាគឹយ ប‌៉្រ័ះ ៥០ ដូវ ចាក ពួយ អន់តីគ។ អន់ឌែ ពៀរ ដូវ តាវ ហះ ទ្រូង ទៀក យដាន់ មួត រ៉ាគឹយ ប‌៉្រ័ះ កា តាវ ហៃ ឡឹង ចាំងហាយ្គ។ ");
INSERT INTO tpu_vpl VALUES ("K22_8","013_2_8","2KI","2","8","8","កេះណោះ វគ័ អេលីយ៉ា តាមួរ អាវ គ្រឹន អ៊ែ ប៉្រះ ទៀក។ ទៀក កា ខ្លាក ឡាច់ ឡឹង គួប អន់ឌែ ពៀរ ដូវ កា ឃ្លង ទ្រូង ទៀក ស្វាត់ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K22_9","013_2_9","2KI","2","9","9","ប៉ាគ់ អន់ឌែ ពៀរ ដូវ ចាក រ៉ាវ៉ាច់ កេះ វគ័ អេលីយ៉ា រ៉ះ កា វគ័ អេលីសេ ផា «ផា អីស ប៉ិច កា ទី ញ៉ា ឡឹង អាញ់ ប៉រ់ ឡឹង អាញ់ ពិ អន់ទ្រួល ឡឹង ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង អ្យក់ ឡាច់ អាញ់ ឡឹង អីស»។ វគ័ អេលីសេ តើល ផា «អន់ ប៉ាង៉ាត័ ប៉ាលឹង អីស អ្វៃ ពឹង អាញ់ ឡគ អន់ អាញ់ ទី ពៀរ ចានែក ឡាក់ កា គន ឡោងទ្រៀ អ្យក់ ប៉ាដក់ ប៉ាជៀ ពៀរ ចានែក ដេល» ");
INSERT INTO tpu_vpl VALUES ("K22_10","013_2_10","2KI","2","10","10","វគ័ អេលីយ៉ា រ៉ះ ផា «សារ អីស ប៉រ់ អា ញ៉ាក ខាក់ ហះកា ប៉ាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ អ្យក់ ឡាច់ អាញ់ ឡឹង អីស អន់ទៀ ផា អីស ហៃ អាញ់ ប៉ប័ ណោះ សារ អីស ប៉រ់ ចឹង ទី ហង។ ផា អីស ហៃ អូ ប៉ប័ ណោះ អូ ទី អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("K22_11","013_2_11","2KI","2","11","11","អន់ឌែ កា ចាក អន់ដើរ រ៉ះ សារ អន់ដើរ ផាឌី អន់ឌែ ប៉ប័ រ៉ាតេ័ះ សេះ អុញ ឡាំ ប៉ាក្លះ អន់ឌែ ផះ ណោះ ខ្យាល តាវ៉ាញ់ កា ប៉ោក ហាវ វគ័ អេលីយ៉ា ពឹង ប៉្លៃង។ ");
INSERT INTO tpu_vpl VALUES ("K22_12","013_2_12","2KI","2","12","12","ប៉ាគ់ វគ័ អេលីសេ ប៉ប័ សារ ណោះ អ៊ែ កា ស៊្រែក ម៉ៃៗ «អឺ ពឹ តាំងឡា អឺ ពឹ តាំងឡា ហៃ តោ រ៉ាតេ័ះ តាកូះ លូ តាហាន ជិះ សេះ មួត អ៊ីស្រាអ៊ែល»។ វគ័ អេលីសេ សាលយ ហៃ វគ័ អេលីយ៉ា ហាវ ពឹង ប៉្លៃង ទឹល អ៊ែ អូ ប៉ប័ កេះ។ អ៊ែ កា ហ៊ែក អាវ អ៊ែ ទៅ កាតាច់ ប៉ុត ");
INSERT INTO tpu_vpl VALUES ("K22_13","013_2_13","2KI","2","13","13","លូ ទូញ អ្យក់ អាវ គ្រឹន វគ័ អេលីយ៉ា ឡាក់ ឡិ ណោះ កេះណោះ វគ័ អេលីសេ ឡាំ ប៉ាគ់ ទ្រូង ទៀក យដាន់។ ");
INSERT INTO tpu_vpl VALUES ("K22_14","013_2_14","2KI","2","14","14","អ៊ែ កា អ្យក់ អាវ គ្រឹន វគ័ អេលីយ៉ា ឡាំ ប៉្រះ ពឹង ទៀក ទ្រូង យដាន់ ទឹប កាប ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ វគ័ អេលីយ៉ា អីស អ្វៃ លូ អាញ់ ដេល ប ?» ផះ អ៊ែ ប៉្រះ អាវ ពឹង ទៀក ណោះ ទៀក កា ខ្លាក ឡាច់ ឡឹង គួប កេះណោះ អ៊ែ ឃ្លង សឹត ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("K22_15","013_2_15","2KI","2","15","15","ផះ មួត រ៉ាគឹយ ប‌៉្រ័ះ អ្វៃ តាវ ហាង អា រសានែង មឿង យេរីខូ ប៉ប័ អ៊ែ អន់ឌែ កាប ផា «ប៉ាង៉ាត័ វគ័ អេលីយ៉ា ម៉ុត ពឹង វគ័ អេលីសេ កេះ»។ អន់ឌែ ឡាំ ប៉ាគ់ ចារ វគ័ អេលីសេ ទឹប ជន តាកុល មូប កល់ ទឹះ តេះ ហះ ង៉ីរ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("K22_16","013_2_16","2KI","2","16","16","កេះណោះ អន់ឌែ កាប ផា «កាណុង កាំឡាំង ញឹន អា ទី ៥០ ដូវ ឡាក់ សាងុំ ខាក់ ប៉រ់ អីស អន់ អន់ឌែ ឡាំ ណាំង ណៃឃូ អីស អ្យូគ ផៃគ ប៉ាង៉ាត័ ប៉ាលឹង ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ោក ប៉ាឡិ អ្លាត អ៊ែ ពឹង ប៉ានឹម លើ ពឹង ក្លូះ ចំ អ្លុ អ៊ែ»។ វគ័ អេលីសេ តើល ផា «ជែ ប៉្រើ អន់ឌែ ឡាំ ហោគ»។ ");
INSERT INTO tpu_vpl VALUES ("K22_17","013_2_17","2KI","2","17","17","ហះកា ញន កា អន់ឌែ ឡោម ខំៗ អ៊ែ កា ភម អន់ ពូ ឡាំ ទឹប កាប ផា «ប៉ិច ឡាំ កា ឡាំ ពិ»។ អន់ឌែ កា ប៉្រើ កាំឡាំង អន់ឌែ ៥០ ដូវ ឡាំ ណាំង វគ័ អេលីយ៉ា ទិ ប៉ៃង ដារ់ ហះកា ណាំង អូ ប៉ប័ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K22_18","013_2_18","2KI","2","18","18","អន់ឌែ កា វ៉ីល សឹត ប៉ាគ់ ចារ វគ័ អេលីសេ អ្វៃ ប៉ាគ់ មឿង យេរីខូ។ វគ័ អេលីសេ រ៉ះ ផា «អាញ់ រ៉ះ កា អន់ដីស កេះ ហះកា អន់ដីស ឡាំ ណាំង អ៊ែ កា ញ៉ា»។ ");
INSERT INTO tpu_vpl VALUES ("K22_19","013_2_19","2KI","2","19","19","បក់ អ្វៃ ពឹង មឿង យេរីខូ រ៉ះ លូ វគ័ អេលីសេ ផា «អឺ ពឹ តាំងឡា អីស ប៉ប័ កេះ មឿង អា រ៉គ់ ខាក់ ហះកា ទៀក អូ ដាគ់ អុះ ទឹប តេះ កា អូ ដាគ់ សាណា ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("K22_20","013_2_20","2KI","2","20","20","អ៊ែ រ៉ះ ផា «ប៉ឹះ អ្យក់ អង់គៀន ណាវ កា អាញ់ ទឹប ចៃគ ប៉ោ័ះ ពឹង ណោះ»។ ពូ កា ឡាំ អ្យក់ អន់ កា អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("K22_21","013_2_21","2KI","2","21","21","អ៊ែ កា ចាក ឡាំ ប៉ាគ់ កល់ ទៀក ទឹប តូះ ម៉ុត ប៉ោ័ះ ពឹង ត្រោម ទៀក ទឹប កាប ផា «ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ផា \"អាញ់ ប៉្រគ័ អន់ ទៀក អា ដាគ់ តៃល ទៅ កេះ អូ ទី បក់ ពឿ ចឹង តោ័ តេះ កា ចឹង ដាគ់ សាណា ដេល\"»។ ");
INSERT INTO tpu_vpl VALUES ("K22_22","013_2_22","2KI","2","22","22","ទៀក ណោះ កា ដាគ់ តាទឹច លើយ ទឹល រ៉ប់ ដារ់ អា ត្រគ់ ឡាក់ កា វគ័ អេលីសេ កាប ណោះ ហង។ … ");
INSERT INTO tpu_vpl VALUES ("K24_1","013_4_1","2KI","4","1","1","ទី អង់កាន់ អន់ត្រោ័ ម៉ោញ ដូវ ឡាក់ កាម៉ាញ់ រ៉ាគឹយ ប‌៉្រ័ះ ឡាំ ប៉ាគ់ ចារ វគ័ អេលីសេ ទឹប ឡោម ឡា អ៊ែ ផា «អឺ ពឹ តាំងឡា ក្លោ អាញ់ តោ័ កេះ។ អីស កា អ្លុ អន់តគ់ កេះ អ៊ែ ណោះ អ្យិល កូត័ កា ប‌៉្រ័ះ ប៊កកាតយ័ ខាក់។ កិញអៀ អា តាំងឡា លៀន បក់ ញឹន ទួម អ៊ែ ចឹង រ៉ុប អ្យក់ គន កាម៉ាក័ អាញ់ ទិ ពៀរ ដូវ អ្យក់ ឡាំ ប៉្រគ័ ទុច អ៊ែ»។ ");
INSERT INTO tpu_vpl VALUES ("K24_2","013_4_2","2KI","4","2","2","វគ័ អេលីសេ តើល អ៊ែ ផា «អីស ប៉ិច កា អាញ់ តង័ អីស នីចម័ ? ហគ់ រ៉ះ កា អាញ់ ហៃ ពឹង ហី អីស ណោះ អីស ទី ញ៉ា អន់ដា ?» អ៊ែ តើល ផា «ពឹង ហី អាញ់ អូ ទី ញ៉ា អុះ ទី ដឹង ចាយ សាងី ថិ ដឹង ម៉ោញ ណោះ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("K24_3","013_4_3","2KI","4","3","3","វគ័ អេលីសេ រ៉ះ កា អ៊ែ ផា «ហគ់ ឡាំ អ៊្យឺម ចាយ លូ ព្រឺយ ពូ អ្វៃ តាដោះ ឡឹង មួត អ្វៃ រសានែង អីស ហះកា ត្រគ់ អ៊្យឺម អន់ អៀង។ ");
INSERT INTO tpu_vpl VALUES ("K24_4","013_4_4","2KI","4","4","4","កេះណោះ អីស លូ គន អីស ត្រគ់ ម៉ុត ពឹង ហី កាត្រើគ អំប៉ារ កេះណោះ អ្យក់ ចាយ សាងី អីស ទៅ ត្រឹង អន់ គ្រឹប ចាយ ឡាក់ អីស អ៊្យឺម ទិណោ័ះ។ ចាយ ចំ ឡាក់ ប៉ាញ័ កេះ អីស ត្រគ់ អន់ ចារ តាង»។ ");
INSERT INTO tpu_vpl VALUES ("K24_5","013_4_5","2KI","4","5","5","អ៊ែ ឡាច់ ឡឹង វគ័ អេលីសេ ប៉ាណាំ គន អ៊ែ ម៉ុត ពឹង ហី ទឹប កាត្រើគ អំប៉ារ។ កេះណោះ អ៊ែ អ្យក់ ចាយ សាងី ត្រឹង ពឹង ចាយ អ៊ែ អ៊្យឺម គន អ៊ែ កា អន់ទឺប ចាយ កា អ៊ែ ម៉ោញ ទង ម៉ោញ កាតុ។ ");
INSERT INTO tpu_vpl VALUES ("K24_6","013_4_6","2KI","4","6","6","ប៉ាគ់ ប៉ាញ័ គ្រឹប ចាយ ទិណោ័ះ កេះ អ៊ែ រ៉ះ កា គន អ៊ែ ផា «ប៉ឹះ អន់ទឺប ចាយ កា អាញ់ ម៉ោញ ណាវ្គ»។ គន តើល ផា «ទិ ចាយ កេះ មើគ !» ផះ ណោះ សាងី កា អូ ហូរ័ ណាវ្គ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K24_7","013_4_7","2KI","4","7","7","អ៊ែ ឡាំ រ៉ះ សារ ណោះ កា វគ័ អេលីសេ បក់ រ៉ះ ប៉ាតាង ប‌៉្រ័ះ វគ័ អេលីសេ រ៉ះ កា អ៊ែ ផា «ហគ់ អ្យក់ សាងី ណោះ ប្រូ អ្យក់ លៀន ស៊ង កា បក់ អន់ដីស ទួម ណោះ ពិ ហះកា លៀន បក់ អ្វៃ សល់ ណោះ គម តាច់ សាណា សិម គន លូ អីស ទៅ ហោគ»។ ");
INSERT INTO tpu_vpl VALUES ("K24_8","013_4_8","2KI","4","8","8","ទី ដារ់ ម៉ោញ វគ័ អេលីសេ ចាក តាត់ មឿង ស៊ូនែម។ អ្វៃ ពឹង មឿង ណោះ ទី អង់កាន់ ប‌៉្រ័ះ ប៉ាត្រង័ ម៉ោញ ដូវ អ៊ែ ជៀក វគ័ អេលីសេ ម៉ុត សា សាណា ពឹង ហី អ៊ែ។ ទឹល នីណោ័ះ រ៉ប់ អ៊ែ ចាក តាត់ មឿង ណោះ អ៊ែ កា ម៉ុត សា សាណា ពឹង ហី អង់កាន់ ណោះ លើយ។ ");
INSERT INTO tpu_vpl VALUES ("K24_9","013_4_9","2KI","4","9","9","អង់កាន់ ណោះ រ៉ះ លូ ក្លោ អ៊ែ ផា «តាម អាញ់ ឃឹត កាម៉ាក័ បក់ ឃើយ ម៉ុត ហី ពិន អា អ៊ែ ប៉ាណូស ដាគ់ ត្រង់ បក់ រ៉ះ ប៉ាតាង ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("K24_10","013_4_10","2KI","4","10","10","ទឹល នីណោ័ះ ពិ ពិន ប៉្រគ័ កាណុង ថិ ម៉ោញ ពឹង តាល់ គែង អំប៉ាំង សាំរ៉ាប់ កា អ៊ែ ទឹប ប៉្រគ័ គ្រេ តៃប គ្រេ អង់អ្វៃ គ្រេ សាំរ៉ាប់ ច្រាគ់ សត់ត្រា លូ ចារ តាគៀង ម៉ាគ់ ដារ់ ចំ អ៊ែ ឡាំ ប៉ាគ់ អា អ៊ែ ម៉ុត ដំ ពឹង ហី ពិន អា ហង»។ ");
INSERT INTO tpu_vpl VALUES ("K24_11","013_4_11","2KI","4","11","11","ប៉ាគ់ ដារ់ អន់តីគ វគ័ អេលីសេ ឡាំ ប៉ាគ់ ហី ណោះ អ៊ែ កា តៃប ពឹង កាណុង ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K24_12","013_4_12","2KI","4","12","12","ប៉ាគ់ កាំលឺ អ៊ែ រ៉ះ លូ ទុច អ៊ែ សិច កេហាស៊ី ផា «ហគ់ ឡាំ រ៉ះ កា អង់កាន់ ណោះ ប៉្រើ ហាវ ប៉ាគ់ អា ហៃ»។ ទុច ណោះ កា ឡាំ រ៉ះ លូ អង់កាន់ អង់កាន់ កា ហាវ ប៉ាគ់ ចារ វគ័ អេលីសេ។ ");
INSERT INTO tpu_vpl VALUES ("K24_13","013_4_13","2KI","4","13","13","វគ័ អេលីសេ រ៉ះ កា ទុច អ៊ែ ផា «ហគ់ អីស អំប៉ញ់ លូ អង់កាន់ អា \"អីស ហាប់ ញឹន ទឹប រ៉ាំងហៃ ញឹន ដាគ់ៗ ញ៉ា ញឹន ចឹង អន់ កា អីស ? ញ៉ា ប៉ិច ប៉្រើ ញឹន ឡាំ កាប លូ សាដាច់ លើ ម៉ៃគ តាហាន ប៉ាតាង អីស ប ?\"» អង់កាន់ តើល ផា «អាញ់ អូ តងកាន កា ញ៉ា អុះ ខង អាញ់ ទី សារ សាណុក សាវ៉ាក លូ ផូង័ វ៉ាច់ អាញ់ ទៅ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("K24_14","013_4_14","2KI","4","14","14","វគ័ អេលីសេ កា អំប៉ញ់ កេហាស៊ី ផា «ទឹល នីណោ័ះ ពិន ចឹង អន់ ញ៉ា កា អ៊ែ អា ?» កេហាស៊ី តើល ផា «អ៊ែ អា អូ ទី គន កាម៉ាក័ អុះ ក្លោ អ៊ែ កា ក្រាគ់ កេះ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("K24_15","013_4_15","2KI","4","15","15","វគ័ អេលីសេ រ៉ះ ផា «ហគ់ អើ អ៊ែ ឡាំ ប៉ាគ់ អា ណាវ្គ»។ កេហាស៊ី កា អើ កេះណោះ អង់កាន់ កា ហាវ អន់តាវ ហះ អំប៉ារ។ ");
INSERT INTO tpu_vpl VALUES ("K24_16","013_4_16","2KI","4","16","16","វគ័ អេលីសេ រ៉ះ ផា «ប៉ាគ់ សាណាំ អន់តីគ ពឹង ខៃ អា ទៅ អីស ចឹង ទី គន កាម៉ាក័ ពៅ ហង»។ អង់កាន់ ណោះ តើល ផា «អឺ ពឹ តាំងឡា បក់ រ៉ះ ប៉ាតាង ប‌៉្រ័ះ អីស ជែ តាំព្លូង កា អាញ់ ដៃ»។ ");
INSERT INTO tpu_vpl VALUES ("K24_17","013_4_17","2KI","4","17","17","ឡៃង ឡឹង ណោះ អ៊ែ ឡាកោ គៀម តាទឹច អ៊ែ កា ទី គន ត្រគ់ ពឹង ខៃ ឡាក់ វគ័ អេលីសេ រ៉ះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K24_18","013_4_18","2KI","4","18","18","ប៉ាគ់ សាស្វា ណោះ តីស ប៊ែត កេះ អ៊ែ ឡាំ ណាំង ពឹ អ៊ែ ប៉ាគ់ ចារ ពូ ច្រូត័ ពៀ។ ");
INSERT INTO tpu_vpl VALUES ("K24_19","013_4_19","2KI","4","19","19","ផះ ណោះ អ៊ែ ញ៉ាំ អើ ពឹ អ៊ែ ផា «អាញ់ អីគ កល់ អីគ កល់ ខាក់»។ ពឹ អ៊ែ រ៉ះ កា ទុច អ៊ែ ផា «ហគ់ ពៅ ឡាំ ជឹន ប៉ាគ់ មើគ អ៊ែ រិញ»។ ");
INSERT INTO tpu_vpl VALUES ("K24_20","013_4_20","2KI","4","20","20","ទុច កា អ្យក់ សាស្វា ណោះ ឡាំ អន់ កា មើគ អ៊ែ។ សាស្វា ណោះ តៃប ពឹង ព្លូ មើគ អ៊ែ លើយ ទឹល ដារ់ ប៉ង់ កេះណោះ អ៊ែ តោ័។ ");
INSERT INTO tpu_vpl VALUES ("K24_21","013_4_21","2KI","4","21","21","មើគ សាស្វា ណោះ កា ពៅ ឡាំ អន់តៃប ពឹង កាណុង វគ័ អេលីសេ កេះណោះ កាត្រើគ អំប៉ារ ចាក ឡាច់ ឡាំ ណាំង ក្លោ អ៊ែ ប៉ាគ់ ម៉ីរ។ ");
INSERT INTO tpu_vpl VALUES ("K24_22","013_4_22","2KI","4","22","22","អ៊ែ រ៉ះ លូ ក្លោ អ៊ែ ផា «ហគ់ អីស ប៉្រើ ទុច ម៉ោញ ដូវ អ្យក់ លៀ ម៉ោញ អន់ កា អាញ់ ជិះ។ អាញ់ ចឹង ប៉ាន់តាន ឡាំ ប៉ាគ់ ហី រ៉ាគឹយ ប‌៉្រ័ះ កេះណោះ វ៉ីល សឹត ប៉ាគ់ អា ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("K24_23","013_4_23","2KI","4","23","23","ក្លោ អ៊ែ អំប៉ញ់ ផា «ខ ញ៉ា អីស ប៉ិច ឡាំ ប៉ាគ់ ហី វគ័ ណោះ ដារ់ អា ? ដារ់ អា អូ ត្រគ់ ដារ់ ប៊ុន លើ ដារ់ រ៉ាឡូវ អុះ»។ អ៊ែ តើល ផា «អីស ជែ ហ្យឹក ហង»។ ");
INSERT INTO tpu_vpl VALUES ("K24_24","013_4_24","2KI","4","24","24","អ៊ែ ប៉្រើ ពូ កត់ អាន ពឹង អង់កក់ លៀ កេះណោះ រ៉ះ កា ទុច ផា «ហគ់ បរ ជែ តាវ រទ្រង ដៃ ផា អាញ់ អូ ប៉្រើ តាវ»។ ");
INSERT INTO tpu_vpl VALUES ("K24_25","013_4_25","2KI","4","25","25","អ៊ែ កា ឡាំ ប៉ាគ់ ចារ វគ័ អេលីសេ បក់ រ៉ះ ប៉ាតាង ប‌៉្រ័ះ អ្វៃ ប៉ាគ់ ប៉ានឹម កាមែល។ ផះ វគ័ អេលីសេ ប៉ប័ អង់កាន់ ណោះ ឡឹង ចាំងហាយ្គ អ៊ែ រ៉ះ លូ ទុច អ៊ែ កេហាស៊ី ផា «តោ អង់កាន់ ឡឹង មឿង ស៊ូនែម ហង តោ។ ");
INSERT INTO tpu_vpl VALUES ("K24_26","013_4_26","2KI","4","26","26","ហគ់ ឡាំ ហាប់ អ៊ែ ប៉្រាល់ លូ អំប៉ញ់ ផា \"អីស ដាគ់ ឡាកោ ដេល ប ? ក្លោ លូ គន អីស ដាគ់ ឡាកោ ប៉ាំងឡៃ ដេល ប ?\"» ទុច កា អំប៉ញ់ ឡាក់ កា អ៊ែ រ៉ះ ណោះ ហង អង់កាន់ តើល ផា «ដាគ់ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("K24_27","013_4_27","2KI","4","27","27","ប៉ាគ់ អ៊ែ ទឹល ប៉ាគ់ ប៉ានឹម កាមែល ប៉ប័ រ៉ាគឹយ ប‌៉្រ័ះ អ៊ែ កា ជន តាកុល គ្វែត ជុង។ កេហាស៊ី ប៉ិច ទុង ឡាច់ ហះកា រ៉ាគឹយ ប‌៉្រ័ះ កាប ផា «ជែ ទុង ឡាច់ អ៊ែ ខង អ៊ែ អុក ពុត ខាក់ កេះ អា។ ប‌៉្រ័ះ ប៊កកាតយ័ អោន សារ អា អូ អន់ អាញ់ អ្លុ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("K24_28","013_4_28","2KI","4","28","28","អង់កាន់ កាប ផា «ពឹ តាំងឡា អាញ់ អូ ប៉រ់ គន ឡឹង អីស អុះ អាញ់ រ៉ះ លូ អីស កេះ ផា \"អីស ជែ តាំព្លូង អាញ់ ដៃ\"»។ ");
INSERT INTO tpu_vpl VALUES ("K24_29","013_4_29","2KI","4","29","29","វគ័ អេលីសេ រ៉ះ កា កេហាស៊ី ផា «ហគ់ កត់ អាវ ពឹង សាំងគៀង កេះណោះ ចាក ឡាំ ពិ។ ផា ប៉ាត័ះ ពូ រទ្រង ជែ អំប៉ញ់ ពូ ដៃ ផា ពូ អំប៉ញ់ អីស កា ជែ តើល ពូ ដេល។ អីស ត្រគ់ អ្យក់ ឡាំ អ៊្លង កាទូង អាញ់ អា តាគ់ កាន់តើស ពឹង ម៉ូះ ម៉ាត់ សាស្វា ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("K24_30","013_4_30","2KI","4","30","30","ហះកា មើគ សាស្វា ណោះ កាប ផា «អាញ់ រ៉ះ កា អីស តាទឹច ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ រ៉ីស លូ ឡាក់ កា អីស អ្វៃ រ៉ីស ដេល អាញ់ អូ ឡាច់ ឡឹង អីស អុះ»។ វគ័ អេលីសេ កា ចាក សឹត អន់ឌូ លូ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("K24_31","013_4_31","2KI","4","31","31","កេហាស៊ី ចាក អន់ទ្រួល ទឹល ប៉ាគ់ ហី ណោះ អ៊ែ អ្យក់ អ៊្លង កាទូង តាគ់ កាន់តើស ពឹង ម៉ូះ ម៉ាត់ សាស្វា ណោះ ហះកា អូ កាតាំង តាំងហើម លូ អូ ប៉ប័ សាំប៉ត់ អុះ។ កេហាស៊ី កា វ៉ីល សឹត ប៉ាគ់ វគ័ អេលីសេ រ៉ះ ផា «សាស្វា ណោះ អូ សាទឹរ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("K24_32","013_4_32","2KI","4","32","32","ផះ វគ័ អេលីសេ ទឹល ប៉ាគ់ ហី អង់កាន់ ណោះ អ៊ែ ប៉ប័ សាស្វា ណោះ តោ័ ពឹង គ្រេ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("K24_33","013_4_33","2KI","4","33","33","វគ័ អេលីសេ កា ម៉ុត ពឹង កាណុង កេះណោះ កាត្រើគ អំប៉ារ អ្វៃ ដឹង អ៊ែ លូ សាស្វា ណោះ ហង ពឹង កាណុង ណោះ កេះណោះ អ៊ែ ម៉ន់ ឡោម ឡា ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("K24_34","013_4_34","2KI","4","34","34","កេះណោះ អ៊ែ តៃប ត្រ្វាត់ អំប៉ាំង សាស្វា ណោះ អន់ ពឹរ អ៊ែ ត្រគ់ លូ ពឹរ សាស្វា អន់ ម៉ាត់ អ៊ែ ត្រគ់ លូ ម៉ាត់ សាស្វា តី កា សាប៉ាគ់ ពឹង តី សាស្វា ណោះ ដេល។ ផះ អ៊ែ ប៉្រគ័ នីណោ័ះ ឡាកោ សាស្វា កា រ៉ាតុ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("K24_35","013_4_35","2KI","4","35","35","កេះណោះ អ៊ែ អ្យូវ ចាក សឹត ចាក ឡាំ ពឹង កាណុង កេះណោះ អ៊ែ តៃប ត្រ្វាត់ ម៉ោញ ទង ណាវ្គ។ ផះ ណោះ សាស្វា កាញ់សេះ តាំប៉ើះ ទង កេះណោះ រ៉ាល ម៉ាត់ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("K24_36","013_4_36","2KI","4","36","36","វគ័ អេលីសេ អើ កេហាស៊ី ពឹះ ប៉ាគ់ អ៊ែ ទឹប រ៉ះ ផា «ហគ់ អើ អង់កាន់ ពឹះ ប៉ាគ់ អា»។ កេហាស៊ី កា អើ អង់កាន់ ណោះ ប៉ាគ់ អ៊ែ ឡាំ ទឹល វគ័ អេលីសេ រ៉ះ ផា «ហគ់ អ្យក់ គន អីស អា ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("K24_37","013_4_37","2KI","4","37","37","អ៊ែ កា សាំប‌៉័ះ កុប កល់ ទឹះ តេះ ហះ ជុង វគ័ អេលីសេ កេះណោះ អ្យក់ ពៅ គន អ៊ែ ចាក ឡាច់ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("K24_38","013_4_38","2KI","4","38","38","វគ័ អេលីសេ កា ឡាំ ប៉ាគ់ មឿង គីលកាល ណាវ្គ ផះ ណោះ កើត ឡាយ៉ិត ឡាំងវ៉ាញ់ កាខាក់ ទឹប ប៉ាថេត អ៊ីស្រាអ៊ែល។ មួត រ៉ាគឹយ ប‌៉្រ័ះ កា អ្វៃ អន់ឌូ លូ វគ័ អេលីសេ អ៊ែ រ៉ះ កា ទុច អ៊ែ ផា «ហគ់ ប៉្រគ័ សាអ៊្លង ម៉ោញ កគ័ តីស អន់ កា មួត អា ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("K24_39","013_4_39","2KI","4","39","39","កាណុង កាំឡាំង អន់ឌែ ណោះ ទី ម៉ោញ ដូវ ចាក ឡាច់ ណាំង ហ្លា អ្យិត ប៉ាគ់ ព្រី អ៊ែ ប៉ប័ ប៉្លៃ ប៉ាតោ ព្រី អ៊ែ កា អ្លេះ ប៉្លៃ ណោះ ប៉ាញ័ កាន់ឌុង អាវ អ៊ែ កា អ្យក់ សឹត កេះណោះ កាត់ រ៉ាហឺញ ចៃគ ពឹង កគ័ ហះកា អូ ទី ពឿ អ្លុ អន់ហ្នាល់ ប៉្លៃ ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K24_40","013_4_40","2KI","4","40","40","កេះណោះ ពូ កា អោះ អន់ កា មួត ណោះ ទិឌូ អន់ឌែ ហុច សា កេះណោះ រ៉ះ ផា «អឺ ពឹ តាំងឡា សាអ៊្លង អា អូ អ្លុ សា អុះ ប៉ាញឹល»។ ");
INSERT INTO tpu_vpl VALUES ("K24_41","013_4_41","2KI","4","41","41","វគ័ អេលីសេ រ៉ះ ផា «ប៉ឹះ អ្យក់ តាប៉ុង អន់ កា អាញ់» កេះណោះ អ៊ែ ចៃគ តាប៉ុង ណោះ ពឹង កគ័ ទឹប រ៉ះ ផា «ហគ់ អោះ សាអ៊្លង អន់ កា អន់ឌែ សា ទិឌូ ពិ»។ ផះ ណោះ ដាគ់ អូ ប៉ាញឹល ហង។ ");
INSERT INTO tpu_vpl VALUES ("K24_42","013_4_42","2KI","4","42","42","ឡៃង ឡឹង ណោះ ទី កាម៉ាក័ ម៉ោញ ដូវ ពឹះ ឡឹង តេះ បាលសាលីសា ទឹប អ្យក់ ណុំ ប៉ាំង ពូ ប៉្រគ័ លូ តាប៉ុង ណាវ ទី ២០ កាតុ ទឹប ភែ សាន់តុក ឡាក់ ច្រូត័ អន់ទ្រួល ឡឹង ពូ ចៃគ ពឹង កាទុង ទ្រុង ឡាំ អន់ កា វគ័ អេលីសេ។ វគ័ អេលីសេ កា រ៉ះ លូ ទុច អ៊ែ ផា «ហគ់ អ្យក់ អន់ កា មួត រ៉ាគឹយ ប‌៉្រ័ះ សា ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("K24_43","013_4_43","2KI","4","43","43","ហះកា ទុច អ៊ែ តើល ផា «អ្យក់ សាណា អា អន់ កា ប៉ាណូស ម៉ោញ រ៉ាយ៉ាំង ដូវ ចឹង សើយ ដេល ប ?» វគ័ អេលីសេ រ៉ះ ណាវ្គ ផា «ហគ់ អន់ អន់ឌែ សា ពិ ខង ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ផា \"អន់ឌែ ចឹង សា ផីគ ទឹប អ្វៃ សល់ ណាវ្គ សាំ\"»។ ");
INSERT INTO tpu_vpl VALUES ("K24_44","013_4_44","2KI","4","44","44","ទុច កា អ្យក់ សាណា ណោះ អន់ កា មួត ណោះ។ អន់ឌែ សា ផីគ ទឹប អ្វៃ សល់ ត្រគ់ ឡាក់ កា ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K25_1","013_5_1","2KI","5","1","1","ទី កាម៉ាក័ ម៉ោញ ដូវ សិច ណាម៉ាន់ ឡាក់ ម៉ៃគ រ៉ាំងហៃ តាហាន សាដាច់ ប៉ាថេត ស៊ីរី។ សាដាច់ ត្រគ់ ពុត ខាក់ កា អ៊ែ ណោះ ខង ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ ប៉ាថេត ស៊ីរី សាណ័ះ ទ្រង អន់ឌែ លើយ ញន កា ណាម៉ាន់។ អ៊ែ ឡាក់ តាហាន កេង កាខាក់ ហះកា អ៊ែ ត្រគ់ រ៉ោះ។ ");
INSERT INTO tpu_vpl VALUES ("K25_2","013_5_2","2KI","5","2","2","ផះ អន់ទ្រួល ពែ តាហាន ស៊ីរី ឡាំ តាកូះ លូ ប៉ាថេត អ៊ីស្រាអ៊ែល ទឹប ទី រ៉ុប អ្យក់ អង់កាន់ រ៉ូះ ម៉ោញ ដូវ អ្យក់ ឡាំ ប៉្រគ័ ទុច។ អង់កាន់ រ៉ូះ ណោះ ប៉្រគ័ ង៉ារ កា កាម៉ាញ់ ណាម៉ាន់។ ");
INSERT INTO tpu_vpl VALUES ("K25_3","013_5_3","2KI","5","3","3","អង់កាន់ រ៉ូះ ណោះ អ៊ែ រ៉ះ លូ កាម៉ាញ់ ណាម៉ាន់ ផា «ផា ពឹ តាំងឡា ឡាំ ប៉ាគ់ ចារ រ៉ាគឹយ ប‌៉្រ័ះ អ្វៃ ប៉ាគ់ មឿង សាម៉ារី អ៊ែ ចឹង តាគ់ អន់ដាគ់ រ៉ោះ ពឹ តាំងឡា ឡូត»។ ");
INSERT INTO tpu_vpl VALUES ("K25_4","013_5_4","2KI","5","4","4","កេះណោះ ណាម៉ាន់ ឡាំ រ៉ះ កា សាដាច់ ស៊ីរី ឡឹង សារ ទុច អង់កាន់ ឡឹង ប៉ាថេត អ៊ីស្រាអ៊ែល រ៉ះ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K25_5","013_5_5","2KI","5","5","5","សាដាច់ តើល ផា «ទឹល នីណោ័ះ អីស ឡាំ ប៉ាគ់ មឿង សាម៉ារី ពិ អាញ់ ចឹង ច្រាគ់ សត់ត្រា ប៉ាហ្យើ កា សាដាច់ ប៉ាថេត អ៊ីស្រាអ៊ែល ពឹង អីស»។ ណាម៉ាន់ កា ឡាំ ទឹប ទ្រុង ឡាំ ប៉្រាក់ ៣០០ កាឡូ លូ ម៉ាស ៧០ កាឡូ ទឹប ខោ អាវ ១០ ប្ល‌៉័ះ។ ");
INSERT INTO tpu_vpl VALUES ("K25_6","013_5_6","2KI","5","6","6","អ៊ែ អ្យក់ ឡាំ សត់ត្រា ណោះ អន់ កា សាដាច់ អ៊ីស្រាអ៊ែល។ កាណុង សត់ត្រា ណោះ រ៉ះ ផា «អាញ់ ប៉្រើ គន សោ អាញ់ ណាម៉ាន់ អា ឡាំ ប៉ាគ់ ចារ អីស។ អាញ់ ប៉រ់ អីស តាគ់ អន់ដាគ់ រ៉ោះ អ៊ែ ណើ»។ ");
INSERT INTO tpu_vpl VALUES ("K25_7","013_5_7","2KI","5","7","7","ផះ សាដាច់ អ៊ីស្រាអ៊ែល អាន សត់ត្រា ណោះ ទិ កេះ អ៊ែ កា ហ៊ែក អាវ អ៊ែ ទៅ ញន កា វ៉ឹនវ៉ាយ ពុត ពៀក កេះណោះ កាប ផា «ញ៉ា អាញ់ អា ប‌៉្រ័ះ ប៊កកាតយ័ ប អ្លុ ប៉ាន់តោ័ កេះណោះ តាគ់ អង់រ៉ីស សឹត ណាវ្គ បះ សាដាច់ ស៊ីរី ប៉្រើ ប៉ាណូស អា ពឹះ ប៉ាគ់ អា ប៉្រើ អាញ់ តាគ់ អន់ដាគ់ រ៉ោះ អ៊ែ អា ? ហៃ អា សាដាច់ ស៊ីរី ណាំង សារ លូ អាញ់ ហង អា»។ ");
INSERT INTO tpu_vpl VALUES ("K25_8","013_5_8","2KI","5","8","8","ផះ វគ័ អេលីសេ ឡាក់ បក់ រ៉ះ ប៉ាតាង ប‌៉្រ័ះ អ៊ែ កាតាំង សារ សាដាច់ អ៊ីស្រាអ៊ែល ហ៊ែក អាវ អ៊ែ ទៅ ណោះ អ៊ែ ប៉្រើ ពូ ឡាំ រ៉ះ លូ សាដាច់ ផា «ញន ញ៉ា បះ អីស ហ៊ែក អ្លាត អាវ អីស នីអៀ ? ប៉្រើ ណាម៉ាន់ ឡាំ ប៉ាគ់ ចារ អាញ់ ពិ ម៉ាគ់ អ៊ែ ចឹង អ្លុ អន់តគ់ ផា ពឹង ប៉ាថេត អ៊ីស្រាអ៊ែល ទី រ៉ាគឹយ ប‌៉្រ័ះ តាទឹច»។ ");
INSERT INTO tpu_vpl VALUES ("K25_9","013_5_9","2KI","5","9","9","ណាម៉ាន់ កា ជិះ រ៉ាតេ័ះ សេះ ឡាំ ប៉ាគ់ ហី វគ័ អេលីសេ។ ");
INSERT INTO tpu_vpl VALUES ("K25_10","013_5_10","2KI","5","10","10","វគ័ អេលីសេ ប៉្រើ ពូ ឡាច់ រ៉ះ លូ ណាម៉ាន់ ផា «ហគ់ ឡាំ ហុំ ទៀក ទ្រូង យដាន់ អន់ ទី តាំប៉ើះ ទង ម៉ាគ់ ឡាកោ អីស ចឹង ព្រេះ ដាគ់ តាទឹច ហង»។ ");
INSERT INTO tpu_vpl VALUES ("K25_11","013_5_11","2KI","5","11","11","ហះកា ណាម៉ាន់ ប៉ិច អឺក ខាក់ អ៊ែ ចាក ឡាច់ ទឹប កាប ផា «អាញ់ សាម៉គ័ ផា អ៊ែ ចឹង ឡាច់ ប៉ាគ់ ចារ អាញ់ កេះណោះ ម៉ន់ អើ ប‌៉្រ័ះ អ៊ែ អន់ កា អាញ់ លូ វ៉ី តី អំប៉ាំង តាំងហាល ម៉ាគ់ រ៉ោះ អាញ់ ចឹង ព្រេះ ព្យោ័។ ");
INSERT INTO tpu_vpl VALUES ("K25_12","013_5_12","2KI","5","12","12","ប៉ាគ់ មឿង ដាម៉ះ ទី ទៀក ទ្រូង ដាគ់ ហ៊្លត ឡឹង ទៀក ពឹង ប៉ាថេត អ៊ីស្រាអ៊ែល ទិណោ័ះ សាំ ឡាក់ កា ទៀក ទ្រូង អាបាណា លូ ទៀក ទ្រូង ផើផើរ។ ញ៉ា ត្រគ់ អូ ប៉្រើ អាញ់ ហុំ ប៉ាគ់ ណោះ ម៉ាគ់ ដាគ់ ព្រេះ ?» ណាម៉ាន់ ចាក ឡាច់ ទឹប ប៉ិច អឺក ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("K25_13","013_5_13","2KI","5","13","13","ហះកា ទុច អ៊ែ រ៉ះ កា អ៊ែ ផា «អឺ ពឹ តាំងឡា ផា រ៉ាគឹយ ប‌៉្រ័ះ ប៉្រើ អីស ប៉្រគ័ សារ ញ៉ាក ប៉ុប ចំ កាតាម ឃឺ អីស ចឹង ខំ ប៉្រគ័ ពួយ ទិណោ័ះ ឡូត។ កិញអៀ អា អ៊ែ ក្រាន័ កា ប៉្រើ អីស ឡាំ ហុំ ម៉ាគ់ ដាគ់ ព្រេះ ញ៉ា ត្រគ់ អីស អូ ប៉្រគ័ ពួយ អ៊ែ ?» ");
INSERT INTO tpu_vpl VALUES ("K25_14","013_5_14","2KI","5","14","14","ទឹល នីណោ័ះ ណាម៉ាន់ កា ឡាំ ប៉ាគ់ ទៀក ទ្រូង យដាន់ កេះណោះ ហុំ គ្រឹប តាំប៉ើះ ទង ឡាក់ កា បក់ រ៉ះ ប៉ាតាង ប‌៉្រ័ះ រ៉ះ ណោះ ហង។ ផះ ណោះ ឡាកោ អ៊ែ កា ដាគ់ ព្រេះ ឡូត ឡាក់ កា ឡាកោ សាស្វា។ ");
INSERT INTO tpu_vpl VALUES ("K25_15","013_5_15","2KI","5","15","15","កេះណោះ អ៊ែ លូ គួប អ៊ែ កា វ៉ីល សឹត តាវ ហះ ង៉ីរ វគ័ អេលីសេ លូ រ៉ះ ផា «អាញ់ អ្លុ កេះ ពឹង អង់កក់ តេះ អា អូ ទី ប‌៉្រ័ះ ចំ កាយ ឡឹង ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល។ កិញអៀ អា ហគ់ អ្យក់ ពិ កាណាគ័ អាញ់ អន់ អា»។ ");
INSERT INTO tpu_vpl VALUES ("K25_16","013_5_16","2KI","5","16","16","ហះកា វគ័ អេលីសេ រ៉ះ ផា «អាញ់ រ៉ះ តាទឹច ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ អាញ់ អ្យិល កូត័ អ៊ែ អ្វៃ រ៉ីស អាញ់ អូ អ្យក់ កាណាគ័ ញ៉ា ឡឹង អីស អុះ»។ ណាម៉ាន់ អ្វៃ ឡោម ឡា ប៉្រើ អ៊ែ អ្យក់ ហះកា អ៊ែ អូ អ្យក់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K25_17","013_5_17","2KI","5","17","17","ណាម៉ាន់ កាប ផា «ផា អីស អូ ចៃ អ្យក់ អន់ អីស តាប៉ាប តាប៉ុន អន់ អាញ់ អ្យក់ តេះ ប៉ាទុក ពឹង អង់កក់ លៀ ទិ ពៀរ អា ខង គឹត អា អន់ ប៉ាគ់ ម៉ាត់ អាញ់ អូ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ អន់ទៀគ កាយ ឡឹង ប‌៉្រ័ះ ប៊កកាតយ័ ណាវ្គ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K25_18","013_5_18","2KI","5","18","18","ហះកា អាញ់ ប៉រ់ ប‌៉្រ័ះ ប៊កកាតយ័ តាប៉ាប តាប៉ុន កា អាញ់ ណើ ខង រ៉ប់ ពឹ តាំងឡា អាញ់ ម៉ុត ឡាំ សាំប‌៉័ះ ប‌៉្រ័ះ រីម៉ូន ពឹង រ៉ោង រ៉ាម៉ះ អ៊ែ ទឺរ តី ពឹង ការ់កង់ អាញ់ អាញ់ កា ជន តាកុល ពួយ អ៊ែ ដេល ទឹល នីណោ័ះ អន់ ប‌៉្រ័ះ ប៊កកាតយ័ តាប៉ាប តាប៉ុន កា អាញ់ ណើ»។ ");
INSERT INTO tpu_vpl VALUES ("K25_19","013_5_19","2KI","5","19","19","វគ័ អេលីសេ រ៉ះ ផា «ហគ់ ចាក ដាគ់ ប៉ាឡឹង ពិ»។ ប៉ាគ់ ណាម៉ាន់ ចាក ឡាច់ ឡឹង វគ័ អេលីសេ ចាំងហាយ្គ កេះ ");
INSERT INTO tpu_vpl VALUES ("K25_20","013_5_20","2KI","5","20","20","កេហាស៊ី ឡាក់ ទុច វគ័ អេលីសេ អ៊ែ ឃឹត កាណុង ពុត អ៊ែ ផា «ពឹ តាំងឡា អាញ់ ប៉ាគែក អូ ចៃ អ្យក់ ខា ឡឹង ណាម៉ាន់ ឡាក់ សុនសាត ស៊ីរី ណោះ អុះ។ អាញ់ ចឹង ប៉្រគ័ នីអៀ តាទឹច ឡាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ រ៉ីស អាញ់ ចឹង តាយ៉ិប ពួយ ណាម៉ាន់ ម៉ាគ់ អ្យក់ កាណាគ័ អន់ដា ឡឹង អ៊ែ»។ ");
INSERT INTO tpu_vpl VALUES ("K25_21","013_5_21","2KI","5","21","21","កេហាស៊ី កា តាយ៉ិប ពួយ ណាម៉ាន់។ សាគ់ ណាម៉ាន់ ប៉ប័ កេហាស៊ី តាយ៉ិប ពួយ អ៊ែ អ៊ែ កា ប៉ាន់តាន ជឹរ ឡឹង រ៉ាតេ័ះ ឡាំ ហាប់ កេះណោះ អំប៉ញ់ ផា «អីស ទី សារ ញ៉ា ?» ");
INSERT INTO tpu_vpl VALUES ("K25_22","013_5_22","2KI","5","22","22","កេហាស៊ី តើល ផា «អូ ទី សារ ញ៉ា អុះ ហះកា ពឹ តាំងឡា អាញ់ ប៉្រើ អាញ់ ឡាំ រ៉ះ លូ អីស ផា \"ទី ប៉ាណូស ពៀរ ដូវ ឡាក់ ក្រុំ រ៉ាគឹយ ប‌៉្រ័ះ អង់ក័ះ ពឹះ ឡឹង ព្រី ប៉ានឹម អេប៉្រាអ៊ីម ផះ អ្វៃ ប៉ាគ់ ហី។ អាញ់ ប៉រ់ អីស តាប៉ាប តាប៉ុន អន់ ប៉្រាក់ ៣០ កាឡូ លូ ខោ អាវ ពៀរ ប្ល‌៉័ះ កា អន់ឌែ ណើ\"»។ ");
INSERT INTO tpu_vpl VALUES ("K25_23","013_5_23","2KI","5","23","23","ណាម៉ាន់ តើល ផា «ហគ់ អ្យក់ ៦០ កាឡូ ពិ»។ អ៊ែ កា ប៉ាំងខំ កេហាស៊ី អ្យក់ ប៉្រាក់ ៦០ កាឡូ ទឹប ខោ អាវ ពៀរ ប្ល‌៉័ះ ចៃគ ពឹង កាទុង ពៀរ កេះណោះ ប៉្រើ ទុច អ៊ែ ពៀរ ដូវ គយ ចាក អន់ឌូ លូ កេហាស៊ី។ ");
INSERT INTO tpu_vpl VALUES ("K25_24","013_5_24","2KI","5","24","24","ប៉ាគ់ ទឹល ប៉ាគ់ ប៉ានឹម ឡាក់ ចារ វគ័ អេលីសេ អ្វៃ កេហាស៊ី កា អ្យក់ កាណាគ័ ឡឹង តី ទុច ចៃគ កាណុង ហី កេះណោះ រ៉ះ កា ទុច ពៀរ ដូវ ណោះ ប៉្រើ វ៉ីល សឹត។ ");
INSERT INTO tpu_vpl VALUES ("K25_25","013_5_25","2KI","5","25","25","កេះណោះ អ៊ែ ម៉ុត ឡាំ ប៉ាគ់ ចារ វគ័ អេលីសេ ឡាក់ ពឹ តាំងឡា អ៊ែ វគ័ អេលីសេ កា អំប៉ញ់ អ៊ែ ផា «កេហាស៊ី អីស សឹត ឡឹង ចំ ?» អ៊ែ តើល ផា «អាញ់ អូ ទី ឡាំ ប៉ាគ់ ចំ អុះ ពឹ តាំងឡា»។ ");
INSERT INTO tpu_vpl VALUES ("K25_26","013_5_26","2KI","5","26","26","វគ័ អេលីសេ រ៉ះ ផា «ផះ កាម៉ាក័ ណោះ ជឹរ ឡឹង រ៉ាតេ័ះ ឡាំ ហាប់ អីស ណោះ ប៉ាង៉ាត័ អាញ់ អ្វៃ អន់ឌូ លូ អីស ដេល។ កិញអៀ អា ពិន អូ ត្រគ់ អ្យក់ កាណាគ័ ឡឹង ពូ ឡាក់ កា ប៉្រាក់ លូ ខោ អាវ លើ ម៉ីរ ប៉្លៃ អូលេវ ម៉ីរ ប៉្លៃ អង់កាច លើ ចៀម រ៉ក់ លើ ទុច កាម៉ាក័ ទុច អង់កាន់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K25_27","013_5_27","2KI","5","27","27","ទឹល នីណោ័ះ រ៉ោះ ណាម៉ាន់ ណោះ ចឹង ត្រគ់ ពឹង អីស លើយ ទឹប គន សោ អីស ដេល»។ ផះ កេហាស៊ី ចាក ឡាច់ ឡឹង វគ័ អេលីសេ កេះ អ៊ែ ត្រគ់ រ៉ោះ ប៉ាញ័ ទឹប ឡាកោ បាក ឡាក់ កា កាប៉ាស។ ");
INSERT INTO tpu_vpl VALUES ("K26_1","013_6_1","2KI","6","1","1","ឡៃង ឡឹង ណោះ មួត រ៉ាគឹយ ប‌៉្រ័ះ រ៉ះ លូ វគ័ អេលីសេ ផា «ហៃ ចារ ពិន លួម អា អង់អ្យាគ័ ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("K26_2","013_6_2","2KI","6","2","2","អីស អន់ ញឹន ឡាំ ប៉ាគ់ ទ្រូង យដាន់ ភឿ កាល់ អ៊្លង ដូវ ម៉ោញ ៗ ម៉ាគ់ ញឹន ប៉្រគ័ ហី លួម»។ វគ័ អេលីសេ កា តើល ផា «ឡាំ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("K26_3","013_6_3","2KI","6","3","3","ទី ម៉ោញ ដូវ កាណុង កាំឡាំង អន់ឌែ ណោះ កាប ផា «ប៉រ់ អីស ឡាំ អន់ឌូ លូ ញឹន ណើ»។ វគ័ អេលីសេ តើល ផា «អឺះ អាញ់ ចឹង ឡាំ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("K26_4","013_6_4","2KI","6","4","4","អ៊ែ កា ឡាំ អន់ឌូ លូ អន់ឌែ។ ប៉ាគ់ ឡាំ ទឹល ប៉ាគ់ ទ្រូង យដាន់ អន់ឌែ ប៉ាណាំ គួប កាល់ អ៊្លង។ ");
INSERT INTO tpu_vpl VALUES ("K26_5","013_6_5","2KI","6","5","5","ផះ ណោះ ទី ម៉ោញ ដូវ កាណុង កាំឡាំង កាល់ អ៊្លង ណោះ តាហ្វាត់ ឡាច់ ប៉្លៃ សូង័ ឡិ កាណុង ទៀក។ អ៊ែ កាប ផា «អូ រ៉ៃ ពឹ តាំងឡា តោ័ ហង សូង័ អា អាញ់ ប៉រ់ អ៊្យឺម ឡឹង ពូ សាំ»។ ");
INSERT INTO tpu_vpl VALUES ("K26_6","013_6_6","2KI","6","6","6","វគ័ អេលីសេ អំប៉ញ់ ផា «សូង័ អីស ណោះ ឡិ ហះ ចំ ?» អ៊ែ តាំបាង ចារ សូង័ ឡិ ណោះ។ វគ័ អេលីសេ កា គុ តាំងកង់ អ៊្លង ម៉ោញ កាតុ ប៉ាឡិ ពឹង ទៀក កេះណោះ សូង័ កា ដោង ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("K26_7","013_6_7","2KI","6","7","7","វគ័ អេលីសេ រ៉ះ ផា «ហគ់ អ្យក់ ពិ»។ បក់ ណោះ កា អ្យក់ សូង័ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K26_8","013_6_8","2KI","6","8","8","ឡៃង ឡឹង ណោះ ផះ សាដាច់ ប៉ាថេត ស៊ីរី តាកូះ លូ សុនសាត អ៊ីស្រាអ៊ែល អ៊ែ ពឹកសា លូ មួត ម៉ៃគ តាហាន អ៊ែ កា រ៉ះ ឡឹង ចារ ចឹង ត្រគ់ ប៉ាតុំ តាហាន។ ");
INSERT INTO tpu_vpl VALUES ("K26_9","013_6_9","2KI","6","9","9","ផះ ណោះ វគ័ អេលីសេ ប៉្រើ ពូ ឡាំ រ៉ះ លូ សាដាច់ អ៊ីស្រាអ៊ែល ផា «អ្យគ័ សាំងកៃ ជែ ចាក ឡាំ ប៉ាគ់ ចារ ណោះ ដៃ ខង តាហាន សុនសាត ស៊ីរី អ្វៃ ក្រាប់ ហះ ណោះ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("K26_10","013_6_10","2KI","6","10","10","កេះណោះ សាដាច់ អ៊ីស្រាអ៊ែល កា ប៉្រើ ពូ ឡាំ រ៉ះ អន់ ពូ សាំងកៃ កាខាក់ ប៉ាគ់ ចារ វគ័ អេលីសេ រ៉ះ ណោះ។ សារ នែវ អា កើត ពឹះ អៀង ទង កេះ។ ");
INSERT INTO tpu_vpl VALUES ("K26_11","013_6_11","2KI","6","11","11","ញន សារ ណោះ ហង បះ សាដាច់ ស៊ីរី វ៉ឹនវ៉ាយ កាណុង ពុត អ៊ែ កា អើ សឹត មួត ម៉ៃគ តាហាន លូ អំប៉ញ់ ផា «អន់ដីស រ៉ះ ហៃ កា អាញ់ ទី ពឿ កាណុង កាំឡាំង ពិន តង័ គែង សាដាច់ អ៊ីស្រាអ៊ែល ?» ");
INSERT INTO tpu_vpl VALUES ("K26_12","013_6_12","2KI","6","12","12","ទី ម៉ោញ ដូវ កាណុង កាំឡាំង អន់ឌែ តើល ផា «អឺ ពឹ តាំងឡា អូ ទី បក់ ពឿ តង័ រ៉ះ កា អ៊ែ ណោះ អុះ ទី ដឹង រ៉ាគឹយ ប‌៉្រ័ះ សិច អេលីសេ ណោះ ហង អ៊ែ រ៉ះ កា សាដាច់ អ៊ីស្រាអ៊ែល ទិ សារ ឡាក់ អីស កាប កាហៀច លូ ញឹន»។ ");
INSERT INTO tpu_vpl VALUES ("K26_13","013_6_13","2KI","6","13","13","សាដាច់ ស៊ីរី កាប ផា «ហគ់ ឡាំ ណាំង ហៃ ប៉ាគ់ ចំ អ៊ែ អ្វៃ អាញ់ ចឹង ប៉្រើ ពូ ឡាំ រ៉ុប អ៊ែ»។ ពូ តើល ផា «អ៊ែ អ្វៃ ប៉ាគ់ មឿង ដូថាន»។ ");
INSERT INTO tpu_vpl VALUES ("K26_14","013_6_14","2KI","6","14","14","សាដាច់ ស៊ីរី ប៉្រើ ឡាំ តាហាន អ៊ែ អៀង កាខាក់ ទឹប តាហាន ជិះ សេះ លូ រ៉ាតេ័ះ តាកូះ។ តាហាន ស៊ីរី ឡាំ ទឹល ប៉ាគ់ ណោះ ទឹប កាម៉ាំង អន់ឌែ កា វ៉ិង ជុំ មឿង ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K26_15","013_6_15","2KI","6","15","15","ប៉ាគ់ តារ កាំលឺ ទុច វគ័ អេលីសេ អ៊ែ អ្យូវ ឡាច់ ប៉ាគ់ ឡីង កា ប៉ប័ មួត តាហាន លូ សេះ ទឹប រ៉ាតេ័ះ តាកូះ វ៉ិង ជុំ មឿង ណោះ។ ទុច ណោះ រ៉ះ ផា «អឺ ពឹ តាំងឡា នីចម័ ពិន ចឹង ប៉្រគ័ អា ហះ ?» ");
INSERT INTO tpu_vpl VALUES ("K26_16","013_6_16","2KI","6","16","16","វគ័ អេលីសេ តើល ផា «អីស ជែ អ្យូគ ហង ខង ទី ពូ អ្វៃ គែង ពិន អៀង ឡឹង អន់ឌែ សាំ»។ ");
INSERT INTO tpu_vpl VALUES ("K26_17","013_6_17","2KI","6","17","17","អ៊ែ ម៉ន់ អើ ប‌៉្រ័ះ ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័  ប៉រ់ អីស តាំបាង អន់ កា ទុច អាញ់ ហៃ ប៉ប័»។ ប‌៉្រ័ះ ប៊កកាតយ័ កា តាំបាង អន់ ទុច ណោះ ប៉ប័ តាហាន ប‌៉្រ័ះ អ្វៃ ពឹង ប៉ានឹម អៀង កាខាក់ ទឹប តាហាន ជិះ សេះ ទឹប រ៉ាតេ័ះ សេះ អុញ អ្វៃ ជុំ វគ័ អេលីសេ។ ");
INSERT INTO tpu_vpl VALUES ("K26_18","013_6_18","2KI","6","18","18","មួត តាហាន ស៊ីរី កា ឡាំ ណាំង វគ័ អេលីសេ អ៊ែ កា ម៉ន់ អើ ប‌៉្រ័ះ ប៊កកាតយ័ ផា «ប៉រ់ អីស ប៉្រគ័ អន់ ម៉ាត់ អន់ឌែ ម៉ាម៉ាំង»។ ប‌៉្រ័ះ កា ប៉្រគ័ អន់ ម៉ាត់ មួត តាហាន ស៊ីរី ម៉ាម៉ាំង តាទឹច ឡាក់ កា ប៉ានឹរ វគ័ អេលីសេ ប៉រ់ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K26_19","013_6_19","2KI","6","19","19","វគ័ អេលីសេ រ៉ះ កា អន់ឌែ ផា «អន់ដីស អា ចាក យច ទ្រង កេះ អូ ត្រគ់ មឿង អា អុះ ឡាក់ អន់ដីស ត្រគ់ ឡាំ ណោះ។ ចុ ចាក ពួយ អាញ់ អាញ់ ចឹង ប៉ាណាំ អន់ដីស អន់ ប៉ប័ បក់ អន់ដីស ណាំង ណោះ»។ អ៊ែ កា ប៉ាណាំ អន់ឌែ ឡាំ ប៉ាគ់ មឿង សាម៉ារី។ ");
INSERT INTO tpu_vpl VALUES ("K26_20","013_6_20","2KI","6","20","20","ប៉ាគ់ អន់ឌែ ម៉ុត កាណុង មឿង សាម៉ារី កេះ វគ័ អេលីសេ កា ម៉ន់ ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័  ប៉រ់ អីស ប៉្រគ័ អន់ ម៉ាត់ មួត អា តាតារ ហៃ ប៉ប័ ពិ»។ ប‌៉្រ័ះ ប៊កកាតយ័ កា ប៉្រគ័ អន់ ម៉ាត់ អន់ឌែ តាតារ ហៃ ប៉ប័ ផាឌី អ្លុ អន់តគ់ ផា ឡាកោ អ្វៃ ពឹង អន់តិគ័ មឿង សាម៉ារី។ ");
INSERT INTO tpu_vpl VALUES ("K26_21","013_6_21","2KI","6","21","21","ផះ សាដាច់ អ៊ីស្រាអ៊ែល ប៉ប័ តាហាន សុនសាត ស៊ីរី អ៊ែ កា អំប៉ញ់ លូ វគ័ អេលីសេ ផា «អឺ ពឹ តាំងឡា ញ៉ា អីស អន់ អាញ់ ប៉ាន់តោ័ អន់ឌែ ដេល ប ?» ");
INSERT INTO tpu_vpl VALUES ("K26_22","013_6_22","2KI","6","22","22","វគ័ អេលីសេ រ៉ះ ផា «ជែ ប៉ាន់តោ័ អន់ឌែ ហង។ ញ៉ា អីស ចឹង ប៉ាន់តោ័ បក់ អីស រ៉ុប ផះ តាកូះ ដេល ប ? ហគ់ អន់ អន់ឌែ សា ណុំ ប៉ាំង លូ អៃត ទៀក កេះណោះ ឡើយ អន់ អន់ឌែ សឹត ប៉ាគ់ ពឹ តាំងឡា អន់ឌែ ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("K26_23","013_6_23","2KI","6","23","23","សាដាច់ អ៊ីស្រាអ៊ែល ប៉ាញ់ចីម អន់ឌែ កេះណោះ ឡើយ អន់ឌែ សឹត ប៉ាគ់ ពឹ តាំងឡា អន់ឌែ ទៅ ណាវ្គ។ គឹត ណោះ តាហាន ស៊ីរី អូ ឡាំ តាកូះ រ៉ាត អ្យក់ គួយ កាណុង ប៉ាថេត អ៊ីស្រាអ៊ែល ណាវ្គ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K26_24","013_6_24","2KI","6","24","24","ទុញ ឡឹង ណោះ ណាវ្គ បេនហាដាត ឡាក់ សាដាច់ ប៉ាថេត ស៊ីរី ប៉ាតុំ តាហាន ទិណោ័ះ ឡាំ វ៉ិង ជុំ មឿង សាម៉ារី។ ");
INSERT INTO tpu_vpl VALUES ("K26_25","013_6_25","2KI","6","25","25","ទឹល នីណោ័ះ មឿង សាម៉ារី ថុក ប៉ាណាប ទឹប ឡាយ៉ិត ឡាំងវ៉ាញ់ កាខាក់។ តាហាន ស៊ីរី វ៉ិង ជុំ ទុញ កាខាក់ ផះ ណោះ កល់ លៀ ម៉ោញ ខា អ៊ែ ប៉្រាក់ ម៉ោញ កាឡូ សាន់ឌែក ម៉ោញ អំប៉ង់ តី ពៀរ ខា អ៊ែ ប៉្រាក់ ទងតិគ័ ខាំ។ ");
INSERT INTO tpu_vpl VALUES ("K26_26","013_6_26","2KI","6","26","26","ផះ រ៉ាំងវ៉ាង ណោះ សាដាច់ អ៊ីស្រាអ៊ែល ហាវ ពឹង ប៉ាន់ទៀយ ផះ ណោះ អ៊ែ ប៉ាត័ះ អង់កាន់ ម៉ោញ ដូវ រ៉ះ ផា «អឺ ពឹ តាំងឡា ប៉រ់ អីស តង័ អាញ់ ណើ»។ ");
INSERT INTO tpu_vpl VALUES ("K26_27","013_6_27","2KI","6","27","27","ហះកា សាដាច់ តើល ផា «ផា ប‌៉្រ័ះ ប៊កកាតយ័ អូ តង័ អីស ប៉្រគ័ នីចម័ អាញ់ អ្លុ តង័ អីស ? ខង ពៀ កា អាញ់ អូ ទី តាពែ ប៉្លៃ អង់កាច កា អាញ់ អូ ទី ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("K26_28","013_6_28","2KI","6","28","28","សាដាច់ អំប៉ញ់ ណាវ្គ ផា «អីស ទី សារ ញ៉ា ?» អង់កាន់ តើល ផា «ផះ ដារ់ ណោះ ពែ ទី អង់កាន់ ម៉ោញ ដូវ ជៀក អាញ់ ផា \"ពិ ពិន អ្យក់ គន អីស សាន់តុក សា ជែក គួប សោប ដារ់ អា ប៉ាគ់ ដារ់ តាយ៉ាង័ ពិន អ្យក់ សា គន អាញ់ ឡគ\"។ ");
INSERT INTO tpu_vpl VALUES ("K26_29","013_6_29","2KI","6","29","29","ទឹល នីណោ័ះ ញឹន កា សាន់តុក សា គន អាញ់។ ហះកា ប៉ាគ់ ដារ់ តាយ៉ាង័ អាញ់ រ៉ះ ផា \"ពិ អ្យក់ គន អីស ម៉ាគ់ ពិន សាន់តុក សា\" ហះកា អង់កាន់ ណោះ អ្យក់ គន អ៊ែ ឡាំ អោន អន់ទ្រួល»។ ");
INSERT INTO tpu_vpl VALUES ("K26_30","013_6_30","2KI","6","30","30","ប៉ាគ់ សាដាច់ កាតាំង សារ អង់កាន់ រ៉ះ ណោះ អ៊ែ កា អុក ពុត ខាក់ ហ៊ែក អាវ អ៊ែ ទៅ ផះ អ៊ែ អ្វៃ ពឹង ប៉ាន់ទៀយ ប៉ាសុន កា ប៉ប័ អ៊ែ អន់តុក កាប៉ោ។ ");
INSERT INTO tpu_vpl VALUES ("K26_31","013_6_31","2KI","6","31","31","អ៊ែ រ៉ះ ផា «ដារ់ អា ផា អាញ់ អូ កាសិត អង់កូ អេលីសេ គន វគ័ សាផាត អន់ ប‌៉្រ័ះ ប៊កកាតយ័ ចៃគ ថូត អាញ់ អន់ ក្លាំង កាខាក់ ឡូត»។ ");
INSERT INTO tpu_vpl VALUES ("K26_32","013_6_32","2KI","6","32","32","ផះ ណោះ វគ័ អេលីសេ អ្វៃ ពឹង ហី មួត ក្រាគ់ តាំងកង់ កា អ្វៃ អន់ឌូ លូ អ៊ែ ដេល។ ផះ ណោះ សាដាច់ ប៉្រើ ប៉ាណូស ម៉ោញ ដូវ ឡាំ ប៉ាន់តោ័ វគ័ អេលីសេ ហះកា ប៉ាណូស ណោះ ឡាំ បើ តាន័ ទឹល វគ័ អេលីសេ អ្លុ អន់ទ្រួល អ៊ែ រ៉ះ កា មួត ក្រាគ់ តាំងកង់ ណោះ ផា «ហៃ បក់ ប៉ាន់តោ័ ប៉ាណូស ណោះ អ៊ែ ប៉្រើ ពូ ឡាំ កាសិត អង់កូ អាញ់។ អន់ដីស សាំងកៃ ហោគ ប៉ាគ់ បក់ ណោះ ពឹះ ទឹល ទៀ អន់ អន់ដីស កាត្រើគ អំប៉ារ ជែ អន់ អ៊ែ ម៉ុត ដៃ។ ហះកា ពិន ចឹង កាតាំង រ៉ាយ៉ាគ់ ជុង ពឹ តាំងឡា អ៊ែ ពឹះ ពួយ អន់តីគ»។ ");
INSERT INTO tpu_vpl VALUES ("K26_33","013_6_33","2KI","6","33","33","ផះ វគ័ អេលីសេ អ្វៃ កាកាប សាដាច់ កា ពឹះ ទឹល លូ កាប ផា «ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ ពិន ប៉ាណាប ប៉ាបប៉ុន នែវ អា ញ៉ា ត្រគ់ ម៉ឹង ប‌៉្រ័ះ ប៊កកាតយ័ ណាវ្គ ?» ");
INSERT INTO tpu_vpl VALUES ("K27_1","013_7_1","2KI","7","1","1","វគ័ អេលីសេ រ៉ះ ផា «ហគ់ សាំយ៉ាំង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ រ៉ះ នីអៀ \"ប៉ាគ់ ដារ់ តាយ៉ាង័ មង ប៉ុប អា ទៅ ប៉ាគ់ អំប៉ារ ទ្រួក សាម៉ារី តាប៉ុង ម៉ោញ កាអ្លី ខា អ៊ែ ប៉្រាក់ ប៉ៃង ជី លូ ភែ ពៀរ កាអ្លី ខា អ៊ែ ប៉្រាក់ ប៉ៃង ជី ដេល\"»។ ");
INSERT INTO tpu_vpl VALUES ("K27_2","013_7_2","2KI","7","2","2","ម៉ៃគ តាហាន ឡាក់ អ្វៃ អន់ឌូ លូ សាដាច់ តើល ផា «យ‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័ បើក អំប៉ារ ប៉្លៃង កាតាម កា សារ ណោះ អូ ទី កើត ពឹះ ដេល»។ វគ័ អេលីសេ រ៉ះ ផា «ក្យាគ់ ហៃ លួង ពិ អីស ចឹង ប៉ប័ ម៉ាត់ អីស ទៅ ហះកា អីស អូ ទី សា សាណា ណោះ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("K27_3","013_7_3","2KI","7","3","3","អ្វៃ ហះ អំប៉ារ ទ្រួក ណោះ ទី ប៉ាណូស ប៉្វាន់ ដូវ ឡាក់ ត្រគ់ រ៉ោះ អ្វៃ រ៉ះ សារ លូ គួប ផា «ខ ញ៉ា បះ ពិន អង់អ្វៃ ក្យាគ់ ចឹង តោ័ ហះ អា នីអៀ ? ");
INSERT INTO tpu_vpl VALUES ("K27_4","013_7_4","2KI","7","4","4","ផា ពិន ម៉ុត កាណុង មឿង ណោះ ពិន ចឹង តោ័ កា ឡាយ៉ិត ផា ពិន អ្វៃ ហះ អា កា ចឹង តោ័ និះទៅ ដេល។ ទឹល នីណោ័ះ ពិ ពិន ម៉ុត អ្វៃ អន់ឌូ លូ តាហាន ស៊ីរី អ្លុ ផៃគ ពូ គម ពិន អន់ អ្វៃ រ៉ីស ផា អន់ឌែ ប៉ាន់តោ័ ពិន កា តោ័ កាតាម»។ ");
INSERT INTO tpu_vpl VALUES ("K27_5","013_7_5","2KI","7","5","5","ផះ យ៉ោម សាយ៉ោម អន់ឌែ ប៉ាណាំ គួប ឡាំ ប៉ាគ់ ចារ តាហាន ស៊ីរី។ ផះ អន់ឌែ ឡាំ ក្យាម័ ចឹង ទឹល ចារ តាហាន ស៊ីរី អន់ឌែ ហៃ អូ ប៉ប័ ពឿ ម៉ោញ ដូវ អុះ ");
INSERT INTO tpu_vpl VALUES ("K27_6","013_7_6","2KI","7","6","6","ខង ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ តាហាន ស៊ីរី កាតាំង យឹង រ៉ាតេ័ះ តាកូះ លូ សេះ ទឹប តាហាន អៀង កាខាក់ ក្យាម័ ចារ អន់ឌែ។ អន់ឌែ កាប លូ គួប ផា «សាំយ៉ាំង ហៃ ឃឺ អ៊ែ សាដាច់ អ៊ីស្រាអ៊ែល ច្វាល់ តាហាន សាដាច់ ហេត លូ តាហាន សាដាច់ អ៊ីស៊ីប ពឹះ តាកូះ លូ ពិន ហង»។ ");
INSERT INTO tpu_vpl VALUES ("K27_7","013_7_7","2KI","7","7","7","ផះ យ៉ោម សាយ៉ោម មួត តាហាន ស៊ីរី ប៉ាណាំ គួប អ្យូវ សាតាក់ អ្លាត សេះ លូ លៀ ទឹប រ៉ាស អំប៉ាស ពឹង រ៉ាណើះ អន់ឌែ សាតាក់ អ្យក់ កា រ៉ាវ៉ាច់ ឡាកោ ដោច។ ");
INSERT INTO tpu_vpl VALUES ("K27_8","013_7_8","2KI","7","8","8","ផះ មួត ត្រគ់ រ៉ោះ ប៉្វាន់ ដូវ ណោះ ឡាំ ទឹល ប៉ាគ់ ចារ ណោះ អន់ឌែ កា ម៉ុត កាណុង រ៉ាណើះ ម៉ោញ អៃត សា លូ អ្យក់ ម៉ាស ប៉្រាក់ លូ ខោ អាវ ឡាំ អោន។ កេះណោះ វ៉ីល សឹត ម៉ុត កាណុង រ៉ាណើះ ម៉ោញ ណាវ្គ ទឹប ប៉ាតុំ អ្យក់ កាណាគ័ ញ៉ាៗ ឡាក់ ទី កាណុង ណោះ កា អោន និះទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K27_9","013_7_9","2KI","7","9","9","កេះណោះ អន់ឌែ កាប លូ គួប អន់ឌែ ផា «ពិន ប៉្រគ័ នែវ អា អូ ដាគ់ អុះ ខង ដារ់ អា ពិន ត្រគ់ រ៉ះ សារ ដាគ់ អា ផា ពិន អ្វៃ គ្រឺយ លើយ ទឹល តារ អូ រ៉ះ លូ ពូ អុះ ពូ ចឹង ចៃគ ថូត ពិន ហង។ ទឹល នីណោ័ះ ពិ ពិន អ្យក់ សារ ដាគ់ អា ឡាំ រ៉ះ កា ពូ ប៉ាគ់ ហី សាដាច់»។ ");
INSERT INTO tpu_vpl VALUES ("K27_10","013_7_10","2KI","7","10","10","កេះណោះ អន់ឌែ កា ឡាំ អើ មួត ញ៉ាម អំប៉ារ ទ្រួក លូ រ៉ះ ផា «ញឹន ឡាំ ប៉ាគ់ ចារ រ៉ាណើះ មួត តាហាន ស៊ីរី ហះកា អូ ប៉ប័ ពឿ លូ អូ កាតាំង ប៉ានឹរ ញ៉ា អុះ។ ញឹន ប៉ប័ ដឹង រ៉ាណើះ លូ លៀ លូ សេះ ឡាក់ ពូ កត់ អ្លាត លូ កាណាគ័ ឡាក់ ពូ អ្លាត ហះ ណោះ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("K27_11","013_7_11","2KI","7","11","11","មួត បក់ ញ៉ាម អំប៉ារ ទ្រួក អើ ឡុង ម៉ៃៗ កា មួត អ្វៃ គែង កាណុង ប៉្រើ រ៉ះ កា មួត អ្វៃ ពឹង ហី សាដាច់ ឡឹង សារ ដាគ់ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K27_12","013_7_12","2KI","7","12","12","សាដាច់ កា អ្យូវ ទឹប កាម៉ាំង កេះណោះ រ៉ះ កា មួត ប៉្រគ័ កាន រ៉ាតីស ផា «អាញ់ ប៉រ់ រ៉ះ កា អន់ដីស អន់ អ្លុ អន់តគ់ មួត ស៊ីរី ប៉ាញ៉ា កា ពិន ខង អន់ឌែ អ្លុ អន់តគ់ កា ពិន ឡាយ៉ិត ឡាំងវ៉ាញ់ ណោះ ហង បះ អន់ឌែ ឡាច់ ឡឹង រ៉ាណើះ អន់ឌែ ឡាំ អោន ប៉ាគ់ ព្រី ខង អន់ឌែ ឃឹត ផា ប៉ាគ់ ពិន ឡាច់ ឡឹង មឿង អន់ឌែ ចឹង រ៉ុប ពិន ទឹប រ៉ីស កេះណោះ តាប៉ីត អ្យក់ មឿង ឡូត»។ ");
INSERT INTO tpu_vpl VALUES ("K27_13","013_7_13","2KI","7","13","13","ទី បក់ ប៉្រគ័ កាន រ៉ាតីស ម៉ោញ ដូវ រ៉ះ ផា «អីស ប៉្រើ ពូ អ្យក់ សេះ ប៉ាតាម័ កាតុ ឡាក់ អ្វៃ សល់ កាណុង មឿង ឡាំ ហៃ សារ ណោះ។ យ‌៉័ះ អ្វៃ នីអៀ សេះ ទិណោ័ះ ចឹង តោ័ ឡាក់ កា ប៉ាសុន អ៊ីស្រាអ៊ែល បក់ អ្វៃ កាណុង មឿង អា ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("K27_14","013_7_14","2KI","7","14","14","ទឹល នីណោ័ះ សាដាច់ ប៉្រើ ពូ ឡាំ ពួយ តាហាន ស៊ីរី ទឹប រ៉ះ ផា «ហគ់ ឡាំ ហៃ សារ ណោះ ពិ»។ ពូ កា អ្យក់ រ៉ាតេ័ះ តាកូះ ពៀរ ទឹប សេះ ទឹប តាហាន។ ");
INSERT INTO tpu_vpl VALUES ("K27_15","013_7_15","2KI","7","15","15","អន់ឌែ កា ឡាំ ពួយ តាហាន ស៊ីរី លើយ ទឹល ប៉ាគ់ ទ្រូង ទៀក យដាន់ អន់ឌែ ចាក រទ្រង ប៉ប័ ខោ អាវ លូ កាណាគ័ ញ៉ាៗ ឡាក់ តាហាន ស៊ីរី រ៉ីស អ្លាត រ៉ាសាយ្គ ប៉ាយ្គ ខង អន់ឌែ ប៉ាន់តាន សាតាក់ ប៉្រាល់ៗ។ មួត បក់ សាដាច់ ប៉្រើ ឡាំ ណោះ អន់ឌែ កា វ៉ីល សឹត រ៉ះ លូ សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("K27_16","013_7_16","2KI","7","16","16","ផះ ណោះ មួត ប៉ាសុន ប៉ាណាំ គួប ឡាច់ ឡឹង មឿង ឡាំ អ្យក់ កាណាគ័ ញ៉ាៗ ប៉ាគ់ ចារ តាហាន ស៊ីរី ប៉្រគ័ រ៉ាណើះ។ ទឹល នីណោ័ះ តាប៉ុង ម៉ោញ កាអ្លី ខា អ៊ែ ប៉្រាក់ ប៉ៃង ជី ភែ ពៀរ កាអ្លី ខា អ៊ែ ប៉្រាក់ ប៉ៃង ជី ដេល ត្រគ់ ឡាក់ កា ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K27_17","013_7_17","2KI","7","17","17","ផះ ណោះ សាដាច់ ប៉្រើ ម៉ៃគ តាហាន ឡាក់ អ្វៃ អន់ឌូ លូ អ៊ែ ណោះ ឡាំ ញ៉ាម ហៃ អំប៉ារ ទ្រួក ហះកា មួត ប៉ាសុន តាឡូះ ឡាច់ ចគ័ ត្រគ់ អ៊ែ ទឹល តោ័ ឡូត ត្រគ់ ឡាក់ កា ប៉ានឹរ បក់ រ៉ះ ប៉ាតាង ប‌៉្រ័ះ ផះ សាដាច់ ឡាំ ប៉ាគ់ ចារ អ៊ែ ពែ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K27_18","013_7_18","2KI","7","18","18","សារ អា កើត ពឹះ ឡាក់ កា វគ័ អេលីសេ រ៉ះ ណោះ ហង «ប៉ាគ់ តាយ៉ាង័ មង ប៉ុប អា ទៅ ប៉ាគ់ អំប៉ារ ទ្រួក មឿង សាម៉ារី តាប៉ុង ម៉ោញ កាអ្លី ខា អ៊ែ ប៉្រាក់ ប៉ៃង ជី លូ ភែ ពៀរ កាអ្លី ខា អ៊ែ ប៉្រាក់ ប៉ៃង ជី ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("K27_19","013_7_19","2KI","7","19","19","ហះកា ម៉ៃគ តាហាន តើល ផា «យ‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័ បើក អំប៉ារ ប៉្លៃង កាតាម កា សារ អា អូ កើត ពឹះ ដេល»។ វគ័ អេលីសេ តើល ផា «ក្យាគ់ ហៃ ហោគ អីស ចឹង ប៉ប័ ម៉ាត់ អីស ទៅ ហះកា អីស អូ ទី សា អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("K27_20","013_7_20","2KI","7","20","20","សារ អា កា កើត ត្រគ់ ពឹង អ៊ែ តាទឹច ខង មួត ប៉ាសុន ចគ័ អ៊ែ ហះ អំប៉ារ ទ្រួក ទឹល តោ័ ឡូត។ … ");
INSERT INTO tpu_vpl VALUES ("K217_1","013_17_1","2KI","17","1","1","ផះ សាណាំ ទី ១២ រ៉ាំងវ៉ាង អេហះ ប៉្រគ័ សាដាច់ ប៉ាថេត យូដា ផះ ណោះ ហូសៀ គន វគ័ អេឡា ហាវ ប៉្រគ័ សាដាច់ ប៉ាថេត អ៊ីស្រាអ៊ែល អ្វៃ ពឹង មឿង សាម៉ារី អ៊ែ រ៉ាំងហៃ ទី ៩ សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("K217_2","013_17_2","2KI","17","2","2","អ៊ែ ប៉្រគ័ សារ អូ ដាគ់ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័  ហះកា អូ សាម៉ើ លូ សាដាច់ អ៊ីស្រាអ៊ែល ផះ សើគ ពែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K217_3","013_17_3","2KI","17","3","3","ផះ ណោះ សាលម៉ានេស៊ើរ សាដាច់ ប៉ាថេត អាស៊ីរី ប៉ាតុំ តាហាន ឡាំ តាកូះ លូ សាដាច់ ហូសៀ។ សាដាច់ ហូសៀ កា ញម ទឹប ស៊ង រ៉ាបៃ កា សាដាច់ អាស៊ីរី។ ");
INSERT INTO tpu_vpl VALUES ("K217_4","013_17_4","2KI","17","4","4","ហះកា សាដាច់ អាស៊ីរី អ្លុ អន់តគ់ ផា សាដាច់ ហូសៀ ទី ពុត អូ ត្រង់ កា អ៊ែ ខង សាដាច់ ហូសៀ ប៉្រើ ពូ ឡាំ កាកាប លូ សាដាច់ សូក ឡាក់ សាដាច់ ប៉ាថេត អ៊ីស៊ីប ប៉ិច ប៉រ់ អន់ ពូ តង័ អ៊ែ ទឹប អ៊ែ អូ ស៊ង រ៉ាបៃ កា សាដាច់ អាស៊ីរី ឡាក់ កា រ៉ប់ សាណាំ ណាវ្គ ហង។ ទឹល នីណោ័ះ សាដាច់ ប៉ាថេត អាស៊ីរី ប៉្រើ ពូ រ៉ុប គ្រន អ៊ែ កាណុង ខុក។ ");
INSERT INTO tpu_vpl VALUES ("K217_5","013_17_5","2KI","17","5","5","ឡៃង ឡឹង ណោះ សាដាច់ ប៉ាថេត អាស៊ីរី ឡាំ តាកូះ លូ ប៉ាថេត អ៊ីស្រាអ៊ែល ប៉ាញ័ ទឹប ប៉ាថេត លូ វ៉ិង ជុំ មឿង សាម៉ារី ទុញ ប៉ៃង សាណាំ។ ");
INSERT INTO tpu_vpl VALUES ("K217_6","013_17_6","2KI","17","6","6","ផះ សាណាំ ទី ៩ រ៉ាំងវ៉ាង ហូសៀ រ៉ាំងហៃ អ៊ីស្រាអ៊ែល សាដាច់ ប៉ាថេត អាស៊ីរី តាប៉ីត អ្យក់ មឿង សាម៉ារី ទឹប គៀរ ឡាំ សុនសាត អ៊ីស្រាអ៊ែល ប៉ាគ់ ប៉ាថេត អាស៊ីរី អន់ អន់ឌែ អ្វៃ ពឹង មឿង ហាឡា លូ រហាង ទៀក ទ្រូង ហាបោ ឡាក់ ទៀក ទ្រូង ព្រី កូសាន ទឹប អ្វៃ ពឹង មឿង អន់ទៀគៗ ឡាក់ ចារ សុនសាត មេឌី ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K217_7","013_17_7","2KI","17","7","7","សារ ណោះ កើត ពឹះ ញន កា សុនសាត អ៊ីស្រាអ៊ែល ប៉្រគ័ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ឌែ ឡាក់ ប៉ាណាំ អន់ឌែ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ពែ លូ តោះ ឡើយ អន់ឌែ ឡឹង តី សាដាច់ ប៉ាថេត អ៊ីស៊ីប។ អន់ឌែ កា អ្យិល កូត័ កា ប‌៉្រ័ះ អន់ទៀគ ");
INSERT INTO tpu_vpl VALUES ("K217_8","013_17_8","2KI","17","8","8","លូ ប៉្រគ័ ពួយ សារ តាឡាប័ ឃើយ គុន សុនសាត ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ទ្រុះ ឡាច់ ឡឹង ម៉ាត់ អន់ឌែ ទឹប ប៉្រគ័ ពួយ គុន សាដាច់ សុនសាត អ៊ីស្រាអ៊ែល ឡាក់ ប៉្រគ័ សារ យច ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K217_9","013_17_9","2KI","17","9","9","សុនសាត អ៊ីស្រាអ៊ែល កា អន់តុង ប៉្រគ័ សារ អូ ដាគ់ ប៉ាសាំង លូ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ឌែ។ អន់ឌែ ប៉្រគ័ អន់ហ្នឹង ប៉ាគ់ ចារ ប៉ាឌួល គ្រឹប ស្រុក គ្រឹប មឿង ឡឹង ស្រុក តេះ ឡាក់ ថិ ឡឹង ពូ លើយ ទឹល មឿង តីស ឡាក់ ទី ប៉ាន់ទៀយ កាចាប័។ ");
INSERT INTO tpu_vpl VALUES ("K217_10","013_17_10","2KI","17","10","10","អន់ឌែ ប៉ាណាំ គួប ប៉្រគ័ អញ់ជុង លូ ប៉្រគ័ ហ៊ូប ប‌៉្រ័ះ អាសេរ៉ា សាំរ៉ាប់ សាំប‌៉័ះ ប៉ានេ ពឹង កល់ ប៉ានឹម ទិណោ័ះ លូ ពឹង កានឺប តើម អ៊្លង ឡាក់ ទី ហ្លា កាសៃគ តាឌុក គ្រឹប ចារ។ ");
INSERT INTO tpu_vpl VALUES ("K217_11","013_17_11","2KI","17","11","11","ពឹង ចារ ប៉ាឌួល ទិណោ័ះ សុនសាត អ៊ីស្រាអ៊ែល ប៉ាណាំ គួប សុះ តាំងហ៊ុម ឡាក់ កា សុនសាត អន់ទៀគ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ តាំងហ្យិត ឡាច់ ឡឹង ម៉ាត់ អន់ឌែ។ អន់ឌែ ប៉្រគ័ សារ អូ ដាគ់ ប៉្រគ័ អន់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ិច អឺក កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("K217_12","013_17_12","2KI","17","12","12","អន់ឌែ សាំប‌៉័ះ ប៉ានេ ហ៊ូប ប‌៉្រ័ះ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ អូ អន់ អន់ឌែ ប៉្រគ័ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K217_13","013_17_13","2KI","17","13","13","ប‌៉្រ័ះ ប៊កកាតយ័ អន់តគ់ ប៉ាតោ កា មួត អ៊ីស្រាអ៊ែល លូ កា មួត យូដា ពឹង រ៉ាគឹយ អ៊ែ ទិណោ័ះ ឡឹង អន់ទ្រួល សារ ណោះ ចឹង កើត ពឹះ អ៊ែ រ៉ះ ផា «ហគ់ អ្លាត ពិ ទិ សារ អូ ដាគ់ កេះណោះ ប៉្រគ័ ពួយ សារ អាញ់ ប៉្រើ លូ ចាបាប់ ទិណោ័ះ ឡាក់ អាញ់ អន់ កា វគ័ យ៉ាគ់ អន់ដីស ពែ ពឹង មួត រ៉ាគឹយ ឡាក់ ប៉្រគ័ ង៉ារ កា អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("K217_14","013_17_14","2KI","17","14","14","ហះកា អន់ឌែ អូ ចៃ សាំយ៉ាំង អុះ អន់ឌែ កាង័ កល់ ខាក់ ឡាក់ កា វគ័ យ៉ាគ់ អន់ឌែ អូ សឿ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ឌែ ពែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K217_15","013_17_15","2KI","17","15","15","អន់ឌែ បឺង៉ាយ ចាបាប់ ប‌៉្រ័ះ លូ សារ សាញ៉ា រែវ ពុត ឡាក់ អ៊ែ សាញ៉ា លូ វគ័ យ៉ាគ់ អន់ឌែ ផះ សើគ ពែ អន់ឌែ អូ វ៉ឹនវ៉ាយ កា ប៉ានឹរ ប‌៉្រ័ះ កាប កា អន់ឌែ ណោះ អុះ។ អន់ឌែ ប៉ាណាំ គួប សាំប‌៉័ះ ហ៊ូប ប‌៉្រ័ះ ឡាក់ អូ ទី ខា អន់ឌែ ទឹមវ៉ៃរ ឡាកោ ប៉្រគ័ សារ អូ ទី ខា ដេល។ អន់ឌែ ប៉្រគ័ ពួយ គុន សុនសាត អន់ទៀគ អ្វៃ រសានែង អន់ឌែ ឡាក់ សុនសាត ប‌៉្រ័ះ ប៊កកាតយ័ អូ អន់ ប៉្រគ័ ពួយ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K217_16","013_17_16","2KI","17","16","16","អន់ឌែ អ្លាត ទិ សារ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ឌែ ប៉្រើ អន់ឌែ ប៉្រគ័ អន់ឌែ ប៉ាណាំ គួប តូះ ហ៊ូប រ៉ក់ ពៀរ កាតុ កេះណោះ ប៉្រគ័ ហ៊ូប ប‌៉្រ័ះ អាសេរ៉ា ទឹប សាំប‌៉័ះ ប៉ានេ សំឡង់ ពឹង ប៉្លៃង ទិណោ័ះ ទឹប សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ បាល ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K217_17","013_17_17","2KI","17","17","18","អន់ឌែ អ្យក់ គន កាម៉ាក័ គន អង់កាន់ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ បឺគ ប‌៉្រ័ះ រ៉ឺគ អន់ឌែ កា ប៉្រគ័ គ្រូ ប៉្រគ័ ប៉ាជូ។ អន់ឌែ ទឹមវ៉ៃរ ឡាកោ ប៉្រគ័ អូ ដាគ់ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័  ញន ណោះ ហង បះ ប‌៉្រ័ះ ប៊កកាតយ័ អឺក កេង ខាក់ កា សុនសាត អ៊ីស្រាអ៊ែល អ៊ែ តាំងហ្យិត ឡាច់ អន់ឌែ អន់ ចាំងហាយ្គ ឡឹង ម៉ាត់ អ៊ែ អ្វៃ សល់ ដឹង ផូង័ វ៉ាច់ យូដា ណោះ ហង។ … ");
INSERT INTO tpu_vpl VALUES ("K218_1","013_18_1","2KI","18","1","1","ពឹង សាណាំ ទី ៣ ផះ ហូសៀ គន វគ័ អេឡា ប៉្រគ័ សាដាច់ អ៊ីស្រាអ៊ែល ផះ ណោះ ហេសេគៀ គន សាដាច់ អេហះ កា ហាវ ប៉្រគ័ សាដាច់ ប៉ាថេត យូដា។ ");
INSERT INTO tpu_vpl VALUES ("K218_2","013_18_2","2KI","18","2","2","ផះ អ៊ែ ហាវ ប៉្រគ័ សាដាច់ អាញុ អ៊ែ ២៥ សាណាំ អ៊ែ រ៉ាំងហៃ ទុញ ២៩ សាណាំ អ្វៃ ពឹង មឿង យេរូសាឡឹម។ មើគ អ៊ែ សិច អាប៊ីយ៉ា គន វគ័ សាការី។ ");
INSERT INTO tpu_vpl VALUES ("K218_3","013_18_3","2KI","18","3","3","សាដាច់ ហេសេគៀ ប៉្រគ័ សារ ដាគ់ ត្រគ់ ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ខាក់ ឡាក់ កា វគ័ អ៊ែ សាដាច់ ដាវីត ពែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K218_4","013_18_4","2KI","18","4","4","អ៊ែ តាគ់ អំប៉ាក់ អន់ហ្នឹង សាំរ៉ាប់ រ៉ាម៉ះ ប‌៉្រ័ះ អន់ទៀគ ប៉ាគ់ ចារ ប៉ាឌួល ទឹប តាគ់ ប៉ាទុះ អញ់ជុង លូ តាឡក័ អ្លាត ហ៊ូប ប‌៉្រ័ះ អាសេរ៉ា។ កេះណោះ អ៊ែ កាមៃ តាគ់ ប៉ាទុះ ហ៊ូប ពិះ សាប៉ាន័ ឡាក់ វគ័ ម៉ូសេ ប៉្រគ័ ផះ សើគ ពែ  ខង រ៉ាំងវ៉ាង ណោះ មួត ប៉ាសុន អ៊ីស្រាអ៊ែល ប៉ាណាំ គួប សុះ តាំងហ៊ុម អន់ កា ហ៊ូប ពិះ ណោះ ឡាក់ ពូ អន់ សិច ផា នេហ៊ូសាថាន់។ ");
INSERT INTO tpu_vpl VALUES ("K218_5","013_18_5","2KI","18","5","5","សាដាច់ ហេសេគៀ ម៉ឹង អេង កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល។ សាដាច់ យូដា ទិណោ័ះ ទឹប សាដាច់ អន់ទ្រួល ទឹប សាដាច់ អន់តីគ អូ ទី បក់ ពឿ ឡាក់ កា អ៊ែ ណោះ អុះ ");
INSERT INTO tpu_vpl VALUES ("K218_6","013_18_6","2KI","18","6","6","ខង អ៊ែ ម៉ឹង ប‌៉្រ័ះ ប៊កកាតយ័ ទិ ពុត ទិ ពៀក អូ អ្លាត សឿ អុះ ទឹប អ៊ែ ប៉្រគ័ ពួយ ចាបាប់ ឡាក់ ប‌៉្រ័ះ រ៉ះ ពឹង វគ័ ម៉ូសេ។ ");
INSERT INTO tpu_vpl VALUES ("K218_7","013_18_7","2KI","18","7","7","ប‌៉្រ័ះ ប៊កកាតយ័ កា អ្វៃ អន់ឌូ លូ អ៊ែ គ្រឹប ង៉ារ អ៊ែ ប៉្រគ័ កា កើត ទី។ អ៊ែ ប៉ាសាំង អូ ចៃ ប៉្រគ័ ពួយ សាដាច់ អាស៊ីរី។ ");
INSERT INTO tpu_vpl VALUES ("K218_8","013_18_8","2KI","18","8","8","អ៊ែ តាកូះ លូ មួត ភីលីសាទីន លើយ ទឹល ប៉ាគ់ មឿង កាសា លូ ចារ អ្វៃ រសានែង ណោះ អ៊ែ តាប៉ីត អ្យក់ ទឹប ស្រុក តេះ ថិៗ ទឹប មឿង តីស ឡាក់ ទី ប៉ាន់ទៀយ កាចាប័។ ");
INSERT INTO tpu_vpl VALUES ("K218_9","013_18_9","2KI","18","9","9","ផះ សាណាំ ទី ៤ រ៉ាំងវ៉ាង សាដាច់ ហេសេគៀ អ្វៃ រ៉ាំងហៃ ត្រគ់ ពឹង សាណាំ ទី ៧ ផា ឃឹត ឡឹង ហូសៀ ប៉្រគ័ សាដាច់ ប៉ាថេត អ៊ីស្រាអ៊ែល សាលម៉ានេស៊ើរ ឡាក់ សាដាច់ អាស៊ីរី អ៊ែ ប៉ាណាំ តាហាន វ៉ិង ជុំ មឿង សាម៉ារី ");
INSERT INTO tpu_vpl VALUES ("K218_10","013_18_10","2KI","18","10","10","ទុញ ប៉ៃង សាណាំ កេះណោះ អ៊ែ រ៉ាត អ្យក់ មឿង ណោះ ពឹង សាណាំ ទី ៦ ផះ សាដាច់ ហេសេគៀ រ៉ាំងហៃ ឃឺ ពឹង សាណាំ ទី ៩ ផះ ហូសៀ ប៉្រគ័ សាដាច់ អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("K218_11","013_18_11","2KI","18","11","11","សាដាច់ ប៉ាថេត អាស៊ីរី កា គៀរ ឡាំ សុនសាត អ៊ីស្រាអ៊ែល ប៉ាគ់ ប៉ាថេត អាស៊ីរី អន់ អន់ឌែ អ្វៃ ពឹង មឿង ហាឡា លូ រហាង ទៀក ទ្រូង ហាបោ ឡាក់ ទៀក ទ្រូង ព្រី កូសាន ទឹប អ្វៃ ពឹង មឿង អន់ទៀគៗ ឡាក់ ចារ សុនសាត មេឌី ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K218_12","013_18_12","2KI","18","12","12","សារ អា កើត ពឹះ ញន កា សុនសាត អ៊ីស្រាអ៊ែល អូ សាំយ៉ាំង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ឌែ ទឹប អូ ចៃ ប៉្រគ័ ពួយ សារ សាញ៉ា រែវ ពុត ឃឺ ទិ សារ វគ័ ម៉ូសេ ឡាក់ ទុច ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ អន់ឌែ ណោះ ពែ។ អន់ឌែ អូ សាំយ៉ាំង លូ អូ រ៉ាប់ អូ សឿ ឡក់។ ");
INSERT INTO tpu_vpl VALUES ("K218_13","013_18_13","2KI","18","13","13","ប៉ាគ់ សាណាំ ទី ១៤ ផះ សាដាច់ ហេសេគៀ អ្វៃ រ៉ាំងហៃ សានហេរីប ឡាក់ សាដាច់ អាស៊ីរី កា ឡាំ តាកូះ អ្យក់ មឿង ឡាក់ ទី ប៉ាន់ទៀយ តីស កាចាប័ ទិណោ័ះ ពឹង ប៉ាថេត យូដា។ ");
INSERT INTO tpu_vpl VALUES ("K218_14","013_18_14","2KI","18","14","14","សាដាច់ ហេសេគៀ កា ប៉្រើ ពូ ឡាំ ប៉ាគ់ មឿង ឡាគិះ ភឿ ប៉រ់ អន់ សាដាច់ អាស៊ីរី តាប៉ាប តាប៉ុន អ៊ែ ផា «អាញ់ ប៉្រគ័ យច កេះ ប៉រ់ អីស ជែ ប៉្រគ័ កា ញឹន ហង អាញ់ ចឹង ឡាប់ អន់ កាណាគ័ ញ៉ា ឡាក់ អីស ប៉រ់»។ ទឹល នីណោ័ះ សាដាច់ អាស៊ីរី កា ប៉្រើ សាដាច់ ហេសេគៀ អន់ ប៉្រាក់ ១០.០០០ កាឡូ លូ ម៉ាស ១០០០ កាឡូ។ ");
INSERT INTO tpu_vpl VALUES ("K218_15","013_18_15","2KI","18","15","15","សាដាច់ ហេសេគៀ កា ប៉ាតុំ ប៉្រាក់ ទិណោ័ះ ឡឹង រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ លូ ឡឹង ហី សាដាច់ មប អន់ កា សាដាច់ អាស៊ីរី។ ");
INSERT INTO tpu_vpl VALUES ("K218_16","013_18_16","2KI","18","16","16","ផះ ណោះ សាដាច់ ហេសេគៀ កា ផក់ អ្យក់ ម៉ាស អ៊ែ ប៉ាតឹត ពឹង អំប៉ារ លូ ពឹង អ៊្លង អ៊ប អំប៉ារ ពឹង រ៉ោង រ៉ាម៉ះ ពែ ឡាំ មប អន់ កា សាដាច់ អាស៊ីរី ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K218_17","013_18_17","2KI","18","17","17","យ‌៉័ះ នីណោ័ះ កាតាម សាដាច់ អាស៊ីរី កា ប៉្រើ បក់ ប៉្រគ័ តីស ឡឹង ពូ ប៉ៃង ដូវ ចាក ឡាច់ ឡឹង មឿង ឡាគិះ ឡាំ ប៉ាគ់ សាដាច់ ហេសេគៀ អ្វៃ ពឹង មឿង យេរូសាឡឹម ទឹប អ្យក់ ឡាំ តាហាន អៀង កាខាក់។ អន់ឌែ កា ឡាំ ប៉ាគ់ មឿង យេរូសាឡឹម។ ប៉ាគ់ អន់ឌែ ឡាំ ទឹល ប៉ាគ់ ណោះ កេះ អន់ឌែ អ្វៃ តាវ ក្យាម័ ចាំងវែរ ទៀក ហូរ័ ឡាច់ ឡឹង ស្រះ គែង អំប៉ាំង មឿង ប៉ាគ់ ទ្រង ឡាំ ម៉ីរ បក់ រ៉ាវ សក់ ចៀម ");
INSERT INTO tpu_vpl VALUES ("K218_18","013_18_18","2KI","18","18","18","កេះណោះ អន់ឌែ អើ សាដាច់ យូដា។ ផះ ណោះ អេលៀគីម គន វគ័ ហ៊ីលគីយ៉ា ឡាក់ រ៉ាំងហៃ ង៉ារ ពឹង ហី សាដាច់ ឡាច់ ឡាំ ប៉ាគ់ អន់ឌែ អន់ឌូ លូ សេបណា ឡាក់ ច្រាគ់ សត់ត្រា អន់ កា សាដាច់ ទឹប យ៉ូអា គន វគ័ អេសាប ឡាក់ រ៉ះ សារ ប៉ាតាង សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("K218_19","013_18_19","2KI","18","19","19","កាណុង មួត សុនសាត អាស៊ីរី បក់ ប៉្រគ័ កាន តីស ណោះ ទី ម៉ោញ ដូវ កាប ផា «ហគ់ ឡាំ រ៉ះ កា ហេសេគៀ នីអៀ \"សាដាច់ អាស៊ីរី ឡាក់ សាដាច់ តីស ហ៊្លត អ៊ែ កាប ផា 'អីស ម៉ឹង អេង កា ញ៉ា បះ អីស ទី ពុត ខឹន ខាក់ នីអៀ ? ");
INSERT INTO tpu_vpl VALUES ("K218_20","013_18_20","2KI","18","20","20","អីស កាប ផា ទី កាំឡាំង តាកូះ ទឹប ទី តាហាន កេង ខាក់ សាណ័ះ ទ្រង អីស ឡូត ហះកា អីស ក្រាន័ កា កាប ដោច។ ពឿ អីស ម៉ឹង បះ អីស ខឹន ប៉ាសាំង លូ អាញ់ ហះ ? ");
INSERT INTO tpu_vpl VALUES ("K218_21","013_18_21","2KI","18","21","21","កិញអៀ អីស ម៉ឹង ប៉ាថេត អ៊ីស៊ីប ប ? ប៉ាថេត ណោះ ពៀប ឡាក់ កា តើម ទ្រែង ប៉ាក់ ផា អីស ម៉ឹង ពូ ណោះ ពូ ចឹង តាល់ តាគ់ តាលុះ អំប៉ាំង តី អីស ឡូត។ សាដាច់ អ៊ីស៊ីប ចឹង តាល់ តាគ់ តាលុះ តី ទិ បក់ ម៉ឹង អ៊ែ ពៀប ឡាក់ កា ពូ ចឹក តើម ទ្រែង ប៉ាក់ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K218_22","013_18_22","2KI","18","22","22","ផា អីស រ៉ះ កា អាញ់ ផា អីស ម៉ឹង ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ហះកា អីស ហង ឡាក់ តាគ់ អំប៉ាក់ អន់ហ្នឹង ប៉ាគ់ ចារ ប៉ាឌួល សាំរ៉ាប់ សាំប‌៉័ះ អ៊ែ ទឹប ប៉្រើ មួត យូដា លូ មួត មឿង យេរូសាឡឹម សាំប‌៉័ះ អ៊ែ ដឹង ហះ ង៉ីរ អន់ហ្នឹង ពឹង មឿង យេរូសាឡឹម អា ហង'។ ");
INSERT INTO tpu_vpl VALUES ("K218_23","013_18_23","2KI","18","23","23","ទឹល នីណោ័ះ ហគ់ អីស ប៉ាល័ លូ សាដាច់ អាស៊ីរី ឡាក់ ពឹ តាំងឡា អាញ់ ណោះ ពិ អ៊ែ ចឹង អន់ សេះ ២០០០ កាតុ ផានែវ អីស ណាំង ប៉ាណូស អ្លុ ជិះ ទី ២០០០ ដូវ។ ");
INSERT INTO tpu_vpl VALUES ("K218_24","013_18_24","2KI","18","24","24","យ‌៉័ះ ក្រុំ តាហាន សាដាច់ អាស៊ីរី ឡាក់ បៀត ឡឹង ពូ ណោះ កា អីស តាកូះ អូ ដាម័ សាំ អីស កា ម៉ឹង តាហាន ជិះ សេះ លូ រ៉ាតេ័ះ តាកូះ ឡឹង ប៉ាថេត អ៊ីស៊ីប ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K218_25","013_18_25","2KI","18","25","25","ញ៉ា អីស ឃឹត ផា អាញ់ ឡាំ ថាំឡាយ ប៉ាថេត អីស អា អាញ់ ប៉្រគ័ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ប ? អូ ត្រគ់ អុះ ប‌៉្រ័ះ ប៊កកាតយ័ ហង រ៉ះ កា អាញ់ ផា 'ហគ់ ឡាំ តាកូះ ថាំឡាយ ប៉ាថេត យូដា ណោះ ពិ' \"»។ ");
INSERT INTO tpu_vpl VALUES ("K218_26","013_18_26","2KI","18","26","26","ផះ ណោះ អេលៀគីម សេបណា លូ យ៉ូអា រ៉ះ កា បក់ ប៉្រគ័ កាន កា សាដាច់ អាស៊ីរី ណោះ ផា «អឺ ពឹ តាំងឡា ប៉រ់ អីស កាប សុនសាត អារ៉ាម លូ ញឹន ពិ ខង ញឹន អ្លុ ដេល កាប សុនសាត ណោះ អីស ជែ កាប ហង សុនសាត យូដា អ្យូគ ផាហៃគ មួត ប៉ាសុន អ្វៃ រប៉ាន់ទៀយ អ្លុ»។ ");
INSERT INTO tpu_vpl VALUES ("K218_27","013_18_27","2KI","18","27","27","បក់ ប៉្រគ័ កាន តីស ណោះ តើល ផា «ពឹ តាំងឡា អាញ់ ប៉្រើ អាញ់ ពឹះ រ៉ះ សារ អា អូ ត្រគ់ ដឹង កា សាដាច់ អន់ដីស លូ អន់ដីស អុះ ឃឺ អ៊ែ រ៉ះ កា ប៉ាណូស ទិឌូ ឡាក់ អ្វៃ រប៉ាន់ទៀយ អា ដេល។ អន់ឌែ ទិឌូ ចឹង សា អច់ លូ អៃត ទៀក ដោម អន់ឌែ ទៅ ឡាក់ កា អន់ដីស ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("K218_28","013_18_28","2KI","18","28","28","កេះណោះ អ៊ែ អ្យូវ អន់តាវ កាប សុនសាត យូដា ស៊្រែក ម៉ៃៗ ផា «ហគ់ អន់ដីស សាំយ៉ាំង ប៉ានឹរ សាដាច់ អាស៊ីរី ឡាក់ សាដាច់ តីស ហ៊្លត៖ ");
INSERT INTO tpu_vpl VALUES ("K218_29","013_18_29","2KI","18","29","29","\"ជែ សឿ ហេសេគៀ តាំព្លូង កា អន់ដីស ដៃ ខង អ៊ែ អូ អ្លុ តង័ អន់ដីស អន់ រ៉ាវ៉ាច់ ឡឹង តី អាញ់ អុះ ");
INSERT INTO tpu_vpl VALUES ("K218_30","013_18_30","2KI","18","30","30","ទឹប ជែ ពួយ ហេសេគៀ ប៉ាណាំ អន់ដីស ម៉ឹង ប‌៉្រ័ះ ប៊កកាតយ័ ដៃ។ ផា អ៊ែ រ៉ះ ផា 'ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង តង័ ពិន ទឹប មឿង អា អូ ទី កា សាដាច់ អាស៊ីរី អុះ' ");
INSERT INTO tpu_vpl VALUES ("K218_31","013_18_31","2KI","18","31","31","ជែ សាំយ៉ាំង អ៊ែ ហង\" ខង សាដាច់ អាស៊ីរី រ៉ះ ផា \"អន់ដីស សាញ៉ា រែវ ពុត លូ អាញ់ ពិ ទឹប ឡាច់ អ្វៃ គែង អាញ់ ម៉ាគ់ អន់ដីស ចឹង ទី សា ប៉្លៃ អង់កាច លូ ប៉្លៃ ហ្រា អន់ដីស ទៅ ទឹប អៃត ទៀក អន់ដូង័ អន់ដីស ទៅ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K218_32","013_18_32","2KI","18","32","32","ប៉ាគ់ អាញ់ ឡាំ ទៀ អាញ់ ចឹង អ្យក់ អន់ដីស ឡាំ អន់ឌូ លូ អាញ់ ប៉ាគ់ ប៉ាថេត ម៉ោញ ណាវ្គ វ៉ឹច លូ ប៉ាថេត អន់ដីស ទៅ ឡាក់ ប៉ាថេត ទី ពៀ ប៉ូ អៀង សាំរ៉ាប់ ប៉្រគ័ ណុំ ប៉ាំង លូ ទី តើម ប៉្លៃ អង់កាច អៀង សាំរ៉ាប់ ប៉្រគ័ តាពែ លូ ទី តើម ប៉្លៃ អូលេវ អៀង សាំរ៉ាប់ ប៉្រគ័ សាងី ទឹប ទី ទៀក សុត អៀង ដេល ម៉ាគ់ អន់ដីស ចឹង ទី អាញុ រ៉ីស អូ តោ័ អុះ។ ជែ សាំយ៉ាំង ហង ហេសេគៀ ណោះ ខង អ៊ែ តាំព្លូង កា អន់ដីស ផា ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង តង័ អន់ដីស។ ");
INSERT INTO tpu_vpl VALUES ("K218_33","013_18_33","2KI","18","33","33","ទី ប‌៉្រ័ះ ចំ អ្វៃ ពឹង អង់កក់ តេះ អា អ្លុ តង័ ប៉ាសុន អ៊ែ អន់ រ៉ាវ៉ាច់ ឡឹង សាដាច់ អាស៊ីរី អា ប ? ");
INSERT INTO tpu_vpl VALUES ("K218_34","013_18_34","2KI","18","34","34","ប‌៉្រ័ះ មួត មឿង ហាម៉ាត ប‌៉្រ័ះ មួត មឿង អាផាត ប‌៉្រ័ះ មួត មឿង សេផាវែម លូ មឿង ហេណា លូ មឿង អ៊ីវ៉ា អន់ឌែ អ្វៃ ប៉ាគ់ ចំ ? អូ ប៉ប័ អន់ឌែ ឡាំ តង័ ពូ។ ញ៉ា ប‌៉្រ័ះ មឿង សាម៉ារី តង័ អន់ ពូ រ៉ាវ៉ាច់ ឡឹង តី អាញ់ ប ? ");
INSERT INTO tpu_vpl VALUES ("K218_35","013_18_35","2KI","18","35","35","អូ ទី ប‌៉្រ័ះ ចំ កាណុង ប‌៉្រ័ះ ទិណោ័ះ អ្លុ តង័ ពូ អន់ រ៉ាវ៉ាច់ ឡឹង តី អាញ់ អុះ ទឹល នីណោ័ះ ប‌៉្រ័ះ ប៊កកាតយ័ កា អូ អ្លុ តង័ មួត មឿង យេរូសាឡឹម អន់ រ៉ាវ៉ាច់ ឡឹង តី អាញ់ ដេល\"»។ ");
INSERT INTO tpu_vpl VALUES ("K218_36","013_18_36","2KI","18","36","36","មួត ប៉ាសុន អ្វៃ រ៉ាង៉ាប់ អូ តើល ប៉ានឹរ បក់ ប៉្រគ័ កាន កា សាដាច់ អាស៊ីរី ណោះ អុះ ខង សាដាច់ ហេសេគៀ អូ អន់ តើល ប៉ានឹរ បក់ ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K218_37","013_18_37","2KI","18","37","37","អេលៀគីម គន វគ័ ហ៊ីលគីយ៉ា ឡាក់ រ៉ាំងហៃ ង៉ារ ពឹង ហី សាដាច់ លូ សេបណា ឡាក់ ច្រាគ់ សត់ត្រា អន់ កា សាដាច់ ទឹប យ៉ូអា គន វគ័ អេសាប ឡាក់ រ៉ះ សារ ប៉ាតាង សាដាច់ អន់ឌែ ប៉ាណាំ គួប សឹត ប៉ាគ់ ចារ សាដាច់ ហេសេគៀ ទឹប ហ៊ែក ខោ អាវ អន់ឌែ ទៅ លូ រ៉ះ ទិ សារ បក់ ប៉្រគ័ កាន កា សាដាច់ អាស៊ីរី កាប កា អន់ឌែ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K219_1","013_19_1","2KI","19","1","1","ផះ សាដាច់ ហេសេគៀ កាតាំង សារ ណោះ អ៊ែ កា ហ៊ែក អាវ អ៊ែ ទៅ កេះណោះ អន់តុក កាប៉ោ ម៉ុត ពឹង ចារ រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("K219_2","013_19_2","2KI","19","2","2","កេះណោះ អ៊ែ ប៉្រើ អេលៀគីម ឡាក់ រ៉ាំងហៃ ង៉ារ ពឹង ហី សាដាច់ លូ សេបណា ឡាក់ ច្រាគ់ សត់ត្រា កា សាដាច់ ទឹប មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ប៉្រើ អន់ឌែ អន់តុក កាប៉ោ ឡាំ ប៉ាគ់ ចារ រ៉ាគឹយ ប‌៉្រ័ះ សិច អេសាយ គន វគ័ អាម៉ូះ។ ");
INSERT INTO tpu_vpl VALUES ("K219_3","013_19_3","2KI","19","3","3","អន់ឌែ រ៉ះ កា វគ័ អេសាយ ផា «សាដាច់ ហេសេគៀ អ៊ែ រ៉ះ ផា \"ដារ់ អា ពិន អុក ពុត ខាក់ ញន កា ប‌៉្រ័ះ ចៃគ ថូត ពិន កា តាយួស កា ពូ ដេល ពៀប ឡាក់ កា អង់កាន់ ក្យាម័ ចឹង អ្វៃ ហាអុញ ហះកា អូ ទី សាងុំ ចឹង អ្វៃ ហាអុញ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K219_4","013_19_4","2KI","19","4","4","ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អីស អ៊ែ កាតាំង កេះ តាម ហៃ សារ បក់ រ៉ះ ប៉ាតាង សាដាច់ អាស៊ីរី កាប បឺង៉ាយ កា អ៊ែ ឡាក់ ប‌៉្រ័ះ ទី អាញុ រ៉ីស ឃឺ អ៊ែ ចឹង ចៃគ ថូត អន់ឌែ ញន កា សារ អន់ឌែ កាប បឺង៉ាយ ណោះ។ ទឹល នីណោ័ះ ប៉រ់ អីស ឡោម ឡា ប‌៉្រ័ះ ប៉្រើ អ៊ែ តាប៉ាប តាប៉ុន កា ប៉ាសុន ឡាក់ អ្វៃ សល់ បាប៊ត បាប៊ែត អា ណើ\"»។ ");
INSERT INTO tpu_vpl VALUES ("K219_5","013_19_5","2KI","19","5","5","ប៉ាគ់ មួត ប៉្រគ័ កាន កា សាដាច់ ហេសេគៀ ណោះ រ៉ះ កេះ ");
INSERT INTO tpu_vpl VALUES ("K219_6","013_19_6","2KI","19","6","6","វគ័ អេសាយ រ៉ះ កា អន់ឌែ ផា «អន់ដីស ត្រគ់ រ៉ះ លូ ពឹ តាំងឡា អន់ដីស \"ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ផា 'ជែ អ្យូគ ហង កា សារ អីស កាតាំង ណោះ ឡាក់ មួត គន សោ សាដាច់ អាស៊ីរី កាប បឺង៉ាយ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("K219_7","013_19_7","2KI","19","7","7","បៀត ណាវ្គ អាញ់ ចឹង ប៉្រគ័ អន់ សាដាច់ អាស៊ីរី វ៉ឹនវ៉ាយ កាណុង ពុត ញន កា សារ អ៊ែ កាតាំង ពូ រ៉ះ កេះណោះ អ៊ែ ចឹង វ៉ីល សឹត ប៉ាគ់ ប៉ាថេត អ៊ែ ទៅ។ ប៉ាគ់ ណោះ អាញ់ ចឹង ប៉្រគ័ អន់ ពូ កោះ ប៉ាន់តោ័ អ៊ែ លូ ដាវ' \"»។ ");
INSERT INTO tpu_vpl VALUES ("K219_8","013_19_8","2KI","19","8","8","កាប៉ាច់ បក់ ប៉្រគ័ កាន កា សាដាច់ អាស៊ីរី ណោះ អ៊ែ វ៉ីល សឹត ប៉ាគ់ មឿង ឡាគិះ ណាំង ពឹ តាំងឡា អ៊ែ ទឹល ប៉ាគ់ ណោះ អ៊ែ កាតាំង ពូ រ៉ះ ផា សាដាច់ ឡាំ តាកូះ ប៉ាគ់ មឿង លីបណា អ៊ែ កា ឡាំ ប៉ាគ់ មឿង ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K219_9","013_19_9","2KI","19","9","9","ផះ ណោះ សាដាច់ អាស៊ីរី កាតាំង លៅ ពូ ផា ទីរហាកា ឡាក់ សាដាច់ អេធីយ៉ូពី ប៉ាតុំ តាហាន ចឹង ឡាំ តាកូះ លូ អ៊ែ។ ទឹល នីណោ័ះ អ៊ែ ច្រាគ់ សត់ត្រា កេះណោះ ប៉ាហ្យើ កា សាដាច់ ហេសេគៀ ");
INSERT INTO tpu_vpl VALUES ("K219_10","013_19_10","2KI","19","10","10","ឃឺ អ៊ែ រ៉ះ កា សាដាច់ ហេសេគៀ នីអៀ៖ ជែ សឿ ប‌៉្រ័ះ អីស ណោះ អ៊ែ កាប តាំព្លូង កា អីស ផា មឿង យេរូសាឡឹម ណោះ អូ ទី កា អាញ់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K219_11","013_19_11","2KI","19","11","11","អីស អ្លុ អន់តគ់ កេះ ឡឹង សារ សាដាច់ អាស៊ីរី ផះ សើគ ពែ អន់ឌែ ថាំឡាយ ប៉ាថេត ទិណោ័ះ ញ៉ា អីស សាម៉គ័ ផា ប‌៉្រ័ះ អីស ចឹង តង័ អីស អន់ រ៉ាវ៉ាច់ ដេល ប ? ");
INSERT INTO tpu_vpl VALUES ("K219_12","013_19_12","2KI","19","12","12","ផះ រ៉ាំងវ៉ាង វគ័ លូ ពឹ អាញ់ ថាំឡាយ មឿង កូសាន លូ មឿង ហារ៉ាន់ មឿង រេស៊ែប ទឹប គន សោ អេឌែន ឡាក់ ពូ អ្យក់ អន់ អ្វៃ ប៉ាគ់ ព្រី ធេឡាសារ អូ ទី ប‌៉្រ័ះ ចំ តង័ អន់ឌែ អន់ រ៉ាវ៉ាច់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K219_13","013_19_13","2KI","19","13","13","កាប៉ាច់ សាដាច់ មឿង ហាម៉ាត សាដាច់ មឿង អាផាត សាដាច់ មឿង សេផាវែម សាដាច់ មឿង ហេណា លូ សាដាច់ មឿង អ៊ីវ៉ា អន់ឌែ កា អូ រ៉ាវ៉ាច់ ឡាកោ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K219_14","013_19_14","2KI","19","14","14","សាដាច់ ហេសេគៀ អ្យក់ អាន សត់ត្រា ឡឹង តី បក់ ឡាំ ជឹន ប៉ាគ់ អ៊ែ។ កេះណោះ អ៊ែ ឡាំ ប៉ាគ់ ចារ រ៉ោង រ៉ាម៉ះ ទឹប ឡាង តាំបាង សត់ត្រា ណោះ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("K219_15","013_19_15","2KI","19","15","15","កេះណោះ អ៊ែ ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល ឡាក់ អ្វៃ អំប៉ាំង មួត ចេរូប៊ីន ទី ដឹង អីស ហង ឡាក់ ប‌៉្រ័ះ រ៉ាំងហៃ គ្រឹប សុនសាត ពឹង អង់កក់ តេះ អា ខង អីស ហង ប៉ាំងកើត តេះ លូ ប៉្លៃង។ ");
INSERT INTO tpu_vpl VALUES ("K219_16","013_19_16","2KI","19","16","16","អឺ ប‌៉្រ័ះ ប៊កកាតយ័  ប៉រ់ អីស សាំយ៉ាំង លូ ហៃ ពិ សារ សាដាច់ សានហេរីប ច្រាគ់ កាប បឺង៉ាយ អីស ឡាក់ ប‌៉្រ័ះ អ្វៃ រ៉ីស។ ");
INSERT INTO tpu_vpl VALUES ("K219_17","013_19_17","2KI","19","17","17","អឺ ប‌៉្រ័ះ ប៊កកាតយ័  មួត សាដាច់ អាស៊ីរី ថាំឡាយ គ្រឹប សុនសាត លូ ប៉ាថេត ពូ ទិណោ័ះ តាទឹច ហង ");
INSERT INTO tpu_vpl VALUES ("K219_18","013_19_18","2KI","19","18","18","ទឹប អន់ឌែ អ្យក់ សុះ ថាំឡាយ ប‌៉្រ័ះ ពូ ទិណោ័ះ ខង ប‌៉្រ័ះ ទិណោ័ះ អូ ត្រគ់ ប‌៉្រ័ះ តាទឹច អុះ ក្រាន័ កា ហ៊ូប ដោច ឡាក់ ប៉ាណូស ប៉្រគ័ លូ អ៊្លង លូ អំហ្មោ ខ ណោះ ហង បះ អន់ឌែ អ្លុ ថាំឡាយ អ្លាត ទិ។ ");
INSERT INTO tpu_vpl VALUES ("K219_19","013_19_19","2KI","19","19","19","កិញអៀ អា អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ញឹន ប៉រ់ អីស តង័ ញឹន អន់ រ៉ាវ៉ាច់ ឡឹង តី សាដាច់ សានហេរីប ណើ ម៉ាគ់ ប៉ាណូស គ្រឹប ប៉ាថេត អ្វៃ ពឹង អង់កក់ តេះ អា អ្លុ អន់តគ់ ផា ទី ដឹង អីស ហង ប‌៉្រ័ះ តាទឹច»។ ");
INSERT INTO tpu_vpl VALUES ("K219_20","013_19_20","2KI","19","20","20","ផះ ណោះ វគ័ អេសាយ ប៉្រើ ពូ ឡាំ រ៉ះ លូ សាដាច់ ហេសេគៀ ផា «ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល រ៉ះ ផា \"អាញ់ កាតាំង កេះ ទិ សារ ឡាក់ អីស ឡោម ឡា អាញ់ ឡឹង សារ សានហេរីប ឡាក់ សាដាច់ អាស៊ីរី ណោះ\"។ ");
INSERT INTO tpu_vpl VALUES ("K219_21","013_19_21","2KI","19","21","21","អា ហង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ កាប កា សានហេរីប៖ \"មឿង យេរូសាឡឹម ពៀប ឡាក់ កា អង់កាន់ រ៉ូះ អ៊ែ បឺង៉ាយ អូ ណីស កា អីស ទឹប តាតះ កល់ គែង អង់កក់ អីស។ ");
INSERT INTO tpu_vpl VALUES ("K219_22","013_19_22","2KI","19","22","22","អីស ត័ះ ផាម៉ាត កា ពឿ ? អីស កាប ប៉ាំងអ្យូគ ទឹប បឺង៉ាយ កា ពឿ ? ឃឺ អីស ប៉ាសាំង លូ អាញ់ ឡាក់ ប‌៉្រ័ះ ដាគ់ ត្រង់ ឡាក់ រ៉ាំងហៃ សុនសាត អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("K219_23","013_19_23","2KI","19","23","23","អីស ប៉្រើ ពូ ឡាំ កាប បឺង៉ាយ កា អាញ់ ទឹប អីស កាប ផា អីស ទី រ៉ាតេ័ះ តាកូះ អៀង កាខាក់ អីស ផា អីស ហាវ ពឹង កល់ ប៉ានឹម កេះ ទឹប ម៉ុត ពឹង អន់តិគ័ ព្រី ឡេបាណូន ឡាំ កាល់ អ្យក់ អ៊្លង កាញូង ឡាក់ តីស ឡឹង ពូ លូ អ៊្លង កាទៀង ឡាក់ ដាគ់ ឡឹង ពូ អីស ផា អីស ឡាំ ប៉ាគ់ អន់តិគ័ ព្រី ឃឺ ម៉ុត ពឹង ព្រី ក្រង់ ឡាក់ ទី អ៊្លង គឹត ខា កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("K219_24","013_19_24","2KI","19","24","24","អីស ផា អីស សីរ អន់ដូង័ ទឹប អៃត ទៀក ពឹង ប៉ាថេត អន់ទៀគ អីស ផា ផះ អីស យ៉ាក ជុង ចគ័ ពឹង ទៀក តាំងលេ នីល ផះ ណោះ តាំងលេ នីល កា ស្វាត់ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("K219_25","013_19_25","2KI","19","25","25","អឺ សានហេរីប អីស អូ អ្លុ អន់តគ់ ប ? អាញ់ ទ្រៀម សារ អា ឡឹង ទុញ កេះ កិញអៀ អា អាញ់ តាគ់ អង់កេះ សារ អា ហង ឃឺ អាញ់ ប៉្រើ អីស ថាំឡាយ អ្លាត មឿង ឡាក់ ទី ប៉ាន់ទៀយ កាង័ កាចាប័ អន់ កេះ រ៉ាងល។ ");
INSERT INTO tpu_vpl VALUES ("K219_26","013_19_26","2KI","19","26","26","មួត ឡាក់ អ្វៃ ពឹង មឿង ណោះ អូ សាងុំ ចឹង តូ ពូ អន់ឌែ អ្យូគ លូ តាយួស អន់ឌែ ពៀប ឡាក់ កា អ្យិត ពឹង ម៉ីរ លើ អ្យិត ឡន់ អង់ក័ះ ហ៊ន ពឹង ស៊្រែ លើ ឡាក់ កា សាម៉ោង ហ៊ន ពឹង អន់តល័ ហី ឡាក់ ឡាយ៉ោ អន់ទ្រួល ចឹង តីស។ ");
INSERT INTO tpu_vpl VALUES ("K219_27","013_19_27","2KI","19","27","27","អាញ់ អ្លុ គ្រឹប សារ អីស ប៉្រគ័ ទិណោ័ះ យ‌៉័ះ អីស អង់អ្វៃ លើ អ្យូវ អន់តាវ កាតាម យ‌៉័ះ អីស ម៉ុត លើ ឡាច់ កាតាម អាញ់ កា អ្លុ ដេល ផះ អីស កាប អឺក កា អាញ់ ");
INSERT INTO tpu_vpl VALUES ("K219_28","013_19_28","2KI","19","28","28","ខង អាញ់ កាតាំង កេះ អីស កាប អឺក កាប ហឺន ពែ ទឹល នីណោ័ះ អាញ់ ចឹង អ្យក់ កាស៊ែ តោត ម៉ូះ លូ អ្យក់ ប៉ាសយ់ សាំងកាម័ ពឹរ អីស ទុង អន់ វ៉ីល សឹត ប៉ាគ់ ស្រុក តេះ អីស ទៅ ពួយ ទ្រង ឡាក់ អីស ឡាំ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("K219_29","013_19_29","2KI","19","29","29","«អឺ ហេសេគៀ អាញ់ ចឹង តាំបាង សារ ម៉ោញ អន់ អីស ប៉ប័ ម៉ាគ់ អីស ហ្លង់ ឃឺ សាណាំ អា អន់ដីស ចឹង សា ប៉ូ ពៀ ហ៊ន អ៊ែ ទៅ ប៉ាគ់ សាណាំ អន់តីគ កា និះទៅ ដេល ហះកា ប៉ាគ់ សាណាំ អន់តីគ តោ អន់ដីស ចឹង សាមូល លូ ច្រូត័ កាច់ អន់ដីស ទៅ លូ តប់ ប៉្លៃ អង់កាច កេះណោះ សា ប៉្លៃ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K219_30","013_19_30","2KI","19","30","30","មួត ប៉ាសុន យូដា បក់ រ៉ាវ៉ាច់ ឡាកោ ឡាក់ អ្វៃ សល់ ពៀប ឡាក់ កា តើម អ៊្លង ចាត់ រ៉ាយ៉ះ តោត ពឹង តេះ ទឹប ទី តាំងកង់ ទី ប៉្លៃ ប៉ាកាវ ");
INSERT INTO tpu_vpl VALUES ("K219_31","013_19_31","2KI","19","31","31","ខង មួត ប៉ាសុន អ្វៃ សល់ ណោះ ចឹង កើត រ៉ាល ឡឹង មឿង យេរូសាឡឹម ឃឺ ទិ បក់ រ៉ាវ៉ាច់ ឡាកោ ណោះ។ ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉្រគ័ អន់ សារ អា កើត ពឹះ ញន កា អ៊ែ ក្យាគ់ អន់ឌែ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("K219_32","013_19_32","2KI","19","32","32","«កាប៉ាច់ សាដាច់ អាស៊ីរី ប‌៉្រ័ះ ប៊កកាតយ័ កាប ផា \"អ៊ែ អូ ម៉ុត កាណុង មឿង យេរូសាឡឹម អា អុះ ទឹប អូ ប៉ាញ់ ស្រាគ់ លើ ចឹក ខៃល ម៉ុត ក្យាម័ មឿង អា លើ ពូក តេះ អន់ ចាំងហីគ ភឿ ចឹង ម៉ុត តាកូះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K219_33","013_19_33","2KI","19","33","34","អន់ឌែ ចឹង វ៉ីល សឹត ពួយ ទ្រង ឡាក់ អន់ឌែ ឡាំ ណោះ ហង ឃឺ អន់ឌែ អូ ម៉ុត កាណុង មឿង អា អុះ។ អាញ់ ចឹង ប៉ងកាន់ មឿង អា ម៉ាគ់ អាញ់ លៅ លែង សិច លូ ញន ហៃ កា ដាវីត ឡាក់ ទុច អាញ់ ណោះ ដេល\"។ អា ហង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ »។ ");
INSERT INTO tpu_vpl VALUES ("K219_35","013_19_35","2KI","19","35","35","ម៉ាំង ណោះ ហង ប៊យ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាំ ប៉ាគ់ ចារ តាហាន អាស៊ីរី កេះណោះ ប៉ាន់តោ័ អន់ឌែ ទិ ១៨៥.០០០ ដូវ។ ប៉ាគ់ តារ កាំលឺ មួត មឿង យេរូសាឡឹម អ្យូវ ឡឹង តៃប អន់ឌែ ប៉ប័ ប៉ាទ្រូ ប៉ាញ័ ពឹង ចារ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K219_36","013_19_36","2KI","19","36","36","សានហេរីប ឡាក់ សាដាច់ ប៉ាថេត អាស៊ីរី កា វ៉ីល សឹត អ្វៃ ប៉ាគ់ មឿង នីនីវេ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("K219_37","013_19_37","2KI","19","37","37","ផះ អ៊ែ អ្វៃ សាំប‌៉័ះ ប៉ានេ ពឹង រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ នីសារ៉ូក ឡាក់ ប‌៉្រ័ះ អ៊ែ ផះ ណោះ អាដ្រាម៉ាឡិក លូ សារេស៊ើរ ឡាក់ គន អ៊ែ ទៅ កោះ ប៉ាន់តោ័ អ៊ែ លូ ដាវ កេះណោះ សាតាក់ ឡាំ ប៉ាគ់ ព្រី អារ៉ារ៉ាត។ ផះ ណោះ អេសាហាដោន ឡាក់ គន អ៊ែ ម៉ោញ ណាវ្គ កា ហាវ ប៉្រគ័ សាដាច់ ប៉ាតាង អ៊ែ។ … ");
INSERT INTO tpu_vpl VALUES ("K221_1","013_21_1","2KI","21","1","1","ម៉ាណាសេ ហាវ ប៉្រគ័ សាដាច់ ផះ អាញុ អ៊ែ ១២ សាណាំ អ៊ែ ប៉្រគ័ សាដាច់ ពឹង មឿង យេរូសាឡឹម ទុញ ៥៥ សាណាំ។ មើគ អ៊ែ សិច ហ៊ែបស៊ីបា។ ");
INSERT INTO tpu_vpl VALUES ("K221_2","013_21_2","2KI","21","2","2","សាដាច់ ម៉ាណាសេ ប៉្រគ័ សារ អូ ដាគ់ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ។ អ៊ែ ប៉្រគ័ ពួយ សារ បឺគ អ៊ក គុន សុនសាត អន់ទៀគ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ តាំងហ្យិត ឡាច់ ឡឹង សុនសាត អ៊ីស្រាអ៊ែល ពែ។ ");
INSERT INTO tpu_vpl VALUES ("K221_3","013_21_3","2KI","21","3","3","អ៊ែ ប៉្រគ័ ចារ រ៉ាម៉ះ ពឹង ចារ ប៉ាឌួល ឡាក់ ពឹ អ៊ែ ហេសេគៀ តាគ់ អំព្លូក ពែ ទឹប អ៊ែ ប៉្រគ័ អន់ហ្នឹង សាំរ៉ាប់ រ៉ាម៉ះ ប‌៉្រ័ះ បាល លូ អ៊ែ ប៉្រគ័ ហ៊ូប ប‌៉្រ័ះ អាសេរ៉ា ឡាក់ កា អាហាប់ ឡាក់ សាដាច់ ប៉ាថេត អ៊ីស្រាអ៊ែល ផះ អន់ទ្រួល ពែ ដេល ទឹប អ៊ែ សាំប‌៉័ះ ប៉ានេ សំឡង់ អ្វៃ ពឹង ប៉្លៃង ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("K221_4","013_21_4","2KI","21","4","4","អ៊ែ ប៉្រគ័ អន់ហ្នឹង សាំរ៉ាប់ រ៉ាម៉ះ ប‌៉្រ័ះ អន់ទៀគៗ កាណុង រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ។ ផះ អន់ទ្រួល ពែ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ឡឹង សារ រ៉ោង រ៉ាម៉ះ ណោះ ផា «អាញ់ រ៉ើស មឿង យេរូសាឡឹម សាំរ៉ាប់ ចារ អាញ់ អ្វៃ»។ ");
INSERT INTO tpu_vpl VALUES ("K221_5","013_21_5","2KI","21","5","5","សាដាច់ ម៉ាណាសេ ប៉្រគ័ អន់ហ្នឹង សាំរ៉ាប់ រ៉ាម៉ះ សំឡង់ ពឹង រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ពឹង ឡាន ទិ ពៀរ។ ");
INSERT INTO tpu_vpl VALUES ("K221_6","013_21_6","2KI","21","6","6","អ៊ែ ពុះ គន អ៊ែ ទៅ រ៉ាម៉ះ ប‌៉្រ័ះ អន់ទៀគ ទឹប ណាំង ប៉ាជូ គ្រូ អ្លុ អន់ទួង លូ គ្រូ អើ ប៉ាទ្រូ។ អ៊ែ កា ប៉្រគ័ សារ អូ ដាគ់ ហ៊ែង អៀង ៗ ឡាក់ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ ប‌៉្រ័ះ អឺក ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("K221_7","013_21_7","2KI","21","7","7","ឡៃង ឡឹង ណោះ ណាវ្គ អ៊ែ អ្យក់ ហ៊ូប ប‌៉្រ័ះ អាសេរ៉ា ឡាក់ ពូ ប៉្រគ័ ណោះ ឡាំ អន់ ពឹង រ៉ោង រ៉ាម៉ះ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ កេះ កា សាដាច់ ដាវីត លូ គន អ៊ែ សាដាច់ សាឡូម៉ូន ផា «ពូ ចឹង ប៉ានេ អាញ់ លើយ កាណុង រ៉ោង រ៉ាម៉ះ អា លូ ពឹង មឿង យេរូសាឡឹម ឡាក់ អាញ់ រ៉ើស អ្យក់ ឡឹង ផូង័ វ៉ាច់ អ៊ីស្រាអ៊ែល ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("K221_8","013_21_8","2KI","21","8","8","ផា សុនសាត អ៊ីស្រាអ៊ែល អ្យក់ ពុត ចៃគ ប៉្រគ័ ពួយ ចាបាប់ ទិណោ័ះ ឡាក់ អាញ់ រ៉ះ លូ ម៉ូសេ ឡាក់ ទុច អាញ់ ពែ អាញ់ អូ អន់ ពូ តាំងហ្យិត អន់ដីស ឡាច់ ឡឹង ប៉ាថេត ឡាក់ អាញ់ មប អន់ កា វគ័ យ៉ាគ់ អន់ដីស ណោះ អុះ» ");
INSERT INTO tpu_vpl VALUES ("K221_9","013_21_9","2KI","21","9","9","ហះកា អន់ឌែ អូ ចៃ សាំយ៉ាំង អុះ។ សាដាច់ ម៉ាណាសេ ប៉្រគ័ អន់ អន់ឌែ វ៉ឹល វ៉ើង លើយ ទឹល អន់ឌែ ប៉្រគ័ ពួយ សារ អូ ដាគ់ ហ៊្លត ឡឹង សុនសាត អន់ទៀគ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ថាំឡាយ ហះ ម៉ាត់ ប៉ាសុន អ៊ីស្រាអ៊ែល ពែ សាំ។ ");
INSERT INTO tpu_vpl VALUES ("K221_10","013_21_10","2KI","21","10","10","ផះ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ពឹង មួត រ៉ាគឹយ ឡាក់ ប៉្រគ័ ង៉ារ កា អ៊ែ ផា ");
INSERT INTO tpu_vpl VALUES ("K221_11","013_21_11","2KI","21","11","11","«ម៉ាណាសេ ឡាក់ សាដាច់ យូដា អ៊ែ ប៉្រគ័ សារ បឺគ អ៊ក អៀង ខាក់ លូ ប៉្រគ័ សារ អូ ដាគ់ ក្វា ឡឹង សុនសាត អាម៉ូរី ផះ សើគ ពែ សាំ ទឹប អ៊ែ ប៉ាណាំ ប៉ាសុន យូដា ប៉្រគ័ សារ យច ញន កា ហ៊ូប ប‌៉្រ័ះ ទិណោ័ះ ឡាក់ អ៊ែ ប៉្រគ័។ ");
INSERT INTO tpu_vpl VALUES ("K221_12","013_21_12","2KI","21","12","12","ញន សារ ណោះ ហង បះ អាញ់ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល រ៉ះ ផា អាញ់ ចឹង ប៉្រគ័ អន់ ទី សារ ចុនចៃ ពឹង មឿង យេរូសាឡឹម លូ ប៉ាថេត យូដា ពឿ កាតាំង សារ អា បក់ ណោះ ចឹង កាខរ់ ណូស ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("K221_13","013_21_13","2KI","21","13","13","អាញ់ ចឹង ថាំឡាយ មឿង យេរូសាឡឹម ឡាក់ កា អាញ់ ថាំឡាយ មឿង សាម៉ារី លូ ប៉ាន់តោ័ ផូង័ វ៉ាច់ សាដាច់ អាហាប់ ពែ ដេល។ អាញ់ ចឹង ប៉្រគ័ អន់ មួត ប៉ាសុន មឿង យេរូសាឡឹម រ៉ាយ រ៉ាំ អន់ ទិ ឡូត ឡាក់ កា ពូ អ៊្យូត អង់គៀន កេះណោះ តាគ្រួប អ្លាត។ ");
INSERT INTO tpu_vpl VALUES ("K221_14","013_21_14","2KI","21","14","14","អាញ់ ចឹង អ្លាត ប៉ាសុន អាញ់ ឡាក់ អ្វៃ សល់ បាប៊ត បាប៊ែត ទឹប ចឹង មប អន់ឌែ អន់ កា តាម៉ឺរ រ៉ុប អ្យក់ ទិឌូ ទិឌៀន ");
INSERT INTO tpu_vpl VALUES ("K221_15","013_21_15","2KI","21","15","15","ខង អន់ឌែ ប៉្រគ័ សារ អូ ដាគ់ ឡាក់ យច ពុត អាញ់ ខាក់ អន់ឌែ ប៉្រគ័ អន់ អាញ់ ប៉ិច អឺក កាខាក់ ឡឹង វគ័ យ៉ាគ់ អន់ឌែ ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប ពែ លើយ ទឹល រ៉ប់ ដារ់ អា»។ ");
INSERT INTO tpu_vpl VALUES ("K221_16","013_21_16","2KI","21","16","16","សាដាច់ ម៉ាណាសេ អូ ត្រគ់ ដឹង ប៉ាណាំ មួត ប៉ាសុន ប៉្រគ័ សារ អូ ដាគ់ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ អុះ អ៊ែ កា ប៉ាន់តោ័ ប៉ាណូស ដាគ់ ត្រង់ អៀង ដូវ ដេល ប៉ាញ័ ទឹប មឿង យេរូសាឡឹម ទី ដឹង កា ផាម ដោះ។ ");
INSERT INTO tpu_vpl VALUES ("K221_17","013_21_17","2KI","21","17","17","ង៉ារ អន់ទៀគៗ ណាវ្គ ទឹប សារ យច ឡាក់ សាដាច់ ម៉ាណាសេ ប៉្រគ័ ទិណោ័ះ ទី ច្រាគ់ រ៉ាន់ដាប់ ពឹង ផាប់ «សារ ម៉ាមន សាដាច់ ប៉ាថេត យូដា»។ ");
INSERT INTO tpu_vpl VALUES ("K221_18","013_21_18","2KI","21","18","18","សាដាច់ ម៉ាណាសេ តោ័ ពួយ វគ័ យ៉ាគ់ អ៊ែ ពូ កា អ្យក់ ប៉ាទ្រូ អ៊ែ ឡាំ តប់ ពឹង សួន ក្យាម័ ហី អ៊ែ ទៅ ឡាក់ ពូ អើ ផា សួន អ៊ូសា កេះណោះ អាម៉ូន គន អ៊ែ ហាវ ប៉្រគ័ សាដាច់ ប៉ាតាង អ៊ែ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("K221_19","013_21_19","2KI","21","19","19","ផះ អាម៉ូន ហាវ ប៉្រគ័ សាដាច់ អាញុ អ៊ែ ២២ សាណាំ អ៊ែ រ៉ាំងហៃ ពឹង មឿង យេរូសាឡឹម ទី ពៀរ សាណាំ។ មើគ អ៊ែ សិច ម៉ិស៊ូលេម៉េត គន វគ័ ហារុះ ឡឹង តេះ យ៉ុតប៉ា។ ");
INSERT INTO tpu_vpl VALUES ("K221_20","013_21_20","2KI","21","20","20","សាដាច់ អាម៉ូន កា ប៉្រគ័ សារ អូ ដាគ់ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ កា ពឹ អ៊ែ ម៉ាណាសេ ពែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K221_21","013_21_21","2KI","21","21","21","អ៊ែ ប៉្រគ័ សារ អូ ដាគ់ គ្រឹប នែវ លូ សាំប‌៉័ះ ប៉ានេ ហ៊ូប ប‌៉្រ័ះ ឡាក់ កា ពឹ អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K221_22","013_21_22","2KI","21","22","22","សាដាច់ អាម៉ូន អូ វ៉ឹនវ៉ាយ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ វគ័ យ៉ាគ់ អ៊ែ អុះ អ៊ែ អូ ប៉្រគ័ ពួយ ឡក់។ ");
INSERT INTO tpu_vpl VALUES ("K221_23","013_21_23","2KI","21","23","23","មួត ប៉្រគ័ កាន រ៉ាតីសៗ កា សាដាច់ អាម៉ូន អន់ឌែ ភម ពុត លូ គួប សោប ប៉ាន់តោ័ អ្លាត អ៊ែ ពឹង ហី សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("K221_24","013_21_24","2KI","21","24","24","ប៉ាគ់ អន់ឌែ ប៉ាន់តោ័ សាដាច់ កេះ ប៉ាសុន យូដា កា ប៉ាន់តោ័ អ្លាត ទិ បក់ ប៉ាន់តោ័ អ៊ែ ណោះ កេះណោះ អ្យក់ យ៉ូសៀស គន អាម៉ូន ប៉្រើ ហាវ ប៉្រគ័ សាដាច់ តាង អ៊ែ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("K221_25","013_21_25","2KI","21","25","25","ទិ សារ អន់ទៀគៗ ណាវ្គ ឡាក់ សាដាច់ អាម៉ូន ប៉្រគ័ ពូ កា ច្រាគ់ ពឹង ផាប់ «សារ ម៉ាមន សាដាច់ ប៉ាថេត យូដា»។ ");
INSERT INTO tpu_vpl VALUES ("K221_26","013_21_26","2KI","21","26","26","ពូ កា តប់ ប៉ាទ្រូ សាដាច់ អាម៉ូន កាណុង រ៉ូង័ ពឹង សួន អ៊ូសា កេះណោះ គន អ៊ែ យ៉ូសៀស ហាវ ប៉្រគ័ សាដាច់ តាំង អ៊ែ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("K222_1","013_22_1","2KI","22","1","1","ផះ យ៉ូសៀស ហាវ ប៉្រគ័ សាដាច់ អាញុ អ៊ែ ៨ សាណាំ អ៊ែ រ៉ាំងហៃ ពឹង មឿង យេរូសាឡឹម ៣១ សាណាំ។ មើគ អ៊ែ សិច យេឌីដា គន វគ័ អាដាយ៉ា ឡឹង តេះ បូសាកាត់។ ");
INSERT INTO tpu_vpl VALUES ("K222_2","013_22_2","2KI","22","2","2","អ៊ែ ប៉្រគ័ សារ ដាគ់ ត្រគ់ ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ខាក់ ឡាក់ កា វគ័ អ៊ែ សាដាច់ ដាវីត អ៊ែ ប៉្រគ័ ពួយ ប‌៉្រ័ះ កាខាក់ អូ អ្លាត អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K222_3","013_22_3","2KI","22","3","3","ផះ សាដាច់ យ៉ូសៀស រ៉ាំងហៃ ប៉ាថេត ១៨ សាណាំ កេះ អ៊ែ ប៉្រើ សាផាន បក់ ច្រាគ់ សត់ត្រា គន អាសាលៀ សោ វគ័ មិស៊ូឡាម ប៉្រើ ឡាំ ប៉ាគ់ រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័  អ៊ែ កាប ផា ");
INSERT INTO tpu_vpl VALUES ("K222_4","013_22_4","2KI","22","4","4","«ហគ់ ឡាំ រ៉ះ កា វគ័ ហ៊ីលគីយ៉ា ឡាក់ ម៉ៃគ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ប៉្រើ អ៊ែ យ៉ាប លៀន ឡាក់ ប៉ាសុន មប កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ មួត ញ៉ាម អំប៉ារ រ៉ោង រ៉ាម៉ះ អ្យក់ រ៉ាន់ដាប់។ ");
INSERT INTO tpu_vpl VALUES ("K222_5","013_22_5","2KI","22","5","5","ហគ់ មប លៀន ណោះ អន់ កា មួត ម៉ៃគ រ៉ាគឹយ ប៉្រគ័ ហី ម៉ាគ់ អន់ឌែ ច្វាល់ ពូ ប៉ាយ៉ាម័ រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ");
INSERT INTO tpu_vpl VALUES ("K222_6","013_22_6","2KI","22","6","6","ឃឺ មួត បក់ អ្លុ សាក អ៊្លង លូ រ៉ាគឹយ តគ័ អំហ្មោ លូ រ៉ាគឹយ ប៉្រគ័ ង៉ារ អន់ទៀគៗ ប៉្រើ អន់ឌែ ឡាំ តាច់ អ៊្លង លូ អំហ្មោ ឡាក់ ពូ ផាត កេះ ម៉ាគ់ ប៉ាយ៉ាម័ រ៉ោង រ៉ាម៉ះ។ ");
INSERT INTO tpu_vpl VALUES ("K222_7","013_22_7","2KI","22","7","7","ហះកា ជែ អំប៉ញ់ ហង លៀន ឡាក់ អីស មប អន់ កា អន់ឌែ ណោះ ខង អន់ឌែ ប៉្រគ័ ង៉ារ ដាគ់ ត្រង់ ខាក់»។ ");
INSERT INTO tpu_vpl VALUES ("K222_8","013_22_8","2KI","22","8","8","ផះ ណោះ វគ័ ហ៊ីលគីយ៉ា រ៉ះ កា សាផាន ផា «អាញ់ ប៉ប័ ផាប់ ចាបាប់ ប‌៉្រ័ះ កាណុង រ៉ោង រ៉ាម៉ះ»។ វគ័ ហ៊ីលគីយ៉ា អន់ ផាប់ ណោះ កា សាផាន អាន។ ");
INSERT INTO tpu_vpl VALUES ("K222_9","013_22_9","2KI","22","9","9","កេះណោះ សាផាន កា ឡាំ រ៉ះ កា សាដាច់ ផា «ពូ មប លៀន ឡាក់ រ៉ាន់ដាប់ ពឹង រ៉ោង រ៉ាម៉ះ អន់ កា ម៉ៃគ រ៉ាគឹយ ឡាក់ រ៉ាំងហៃ ង៉ារ ប៉ាយ៉ាម័ រ៉ោង រ៉ាម៉ះ ណោះ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("K222_10","013_22_10","2KI","22","10","10","កេះណោះ សាផាន រ៉ះ លូ សាដាច់ ផា «វគ័ ហ៊ីលគីយ៉ា ឡាក់ ម៉ៃគ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ មប ផាប់ អា កា អាញ់»។ កេះណោះ សាផាន អាន អន់ កា សាដាច់ សាំយ៉ាំង។ ");
INSERT INTO tpu_vpl VALUES ("K222_11","013_22_11","2KI","22","11","11","ផះ សាដាច់ កាតាំង សារ ទិណោ័ះ ឡាក់ ច្រាគ់ រ៉ះ ពឹង ផាប់ ចាបាប់ ប‌៉្រ័ះ ណោះ អ៊ែ កា ហ៊ែក អាវ អ៊ែ ទៅ ញន កា អ៊ែ ហ្យឹក ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("K222_12","013_22_12","2KI","22","12","12","កេះណោះ អ៊ែ កា ប៉្រើ វគ័ ហ៊ីលគីយ៉ា លូ អាហ៊ីកាម គន សាផាន ទឹប អាក់បោរ គន មីកាយ៉ា លូ សាផាន បក់ ច្រាគ់ សត់ត្រា ទឹប អាសាយ៉ា ឡាក់ ប៉្រគ័ ង៉ារ កា សាដាច់ ");
INSERT INTO tpu_vpl VALUES ("K222_13","013_22_13","2KI","22","13","13","«ហគ់ អន់ដីស អំប៉ញ់ ប‌៉្រ័ះ ប៊កកាតយ័ កា អាញ់ ទឹប កា ប៉ាសុន យូដា ទិឌូ ឡឹង សារ ទិណោ័ះ ពឹង ផាប់ ចាបាប់ ប‌៉្រ័ះ អា ឡាក់ ពូ អង់ក័ះ ប៉ប័ ខង ប‌៉្រ័ះ ប៊កកាតយ័ អឺក កា ពិន កាខាក់ នីអៀ ញន កា វគ័ យ៉ាគ់ ពិន ផះ សើគ ពែ អន់ឌែ អូ សាំយ៉ាំង សារ ទិណោ័ះ ឡាក់ ទី ច្រាគ់ រ៉ះ ពឹង ផាប់ អា ទឹប អូ ប៉្រគ័ ពួយ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("K222_14","013_22_14","2KI","22","14","14","ទឹល នីណោ័ះ វគ័ ហ៊ីលគីយ៉ា អាហ៊ីកាម អាក់បោរ សាផាន លូ អាសាយ៉ា ប៉ាណាំ គួប ឡាំ អំប៉ញ់ រ៉ាគឹយ ប‌៉្រ័ះ សិច ហ៊ូលដា កាម៉ាញ់ វគ័ សាលូម គន វគ័ ទីកវ៉ា សោ វគ័ ហារ់ហះ ឡាក់ រ៉ាំងហៃ អាវ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ។ យ៉ាគ់ ហ៊ូលដា អ្វៃ ពឹង ស្រុក តេះ ទី ពៀរ ពឹង មឿង យេរូសាឡឹម។ ");
INSERT INTO tpu_vpl VALUES ("K222_15","013_22_15","2KI","22","15","15","អ៊ែ រ៉ះ លូ អន់ឌែ ផា «ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល រ៉ះ ផា \"ហគ់ រ៉ះ លូ បក់ ប៉្រើ អន់ដីស ណោះ នីអៀ ");
INSERT INTO tpu_vpl VALUES ("K222_16","013_22_16","2KI","22","16","16","'អាញ់ ចឹង អន់ សារ ចុនចៃ ពឹង ចារ អា លូ ពឹង មួត ប៉ាសុន ដេល ឡាក់ កា ទី ច្រាគ់ រ៉ះ កេះ ពឹង ផាប់ ចាបាប់ ឡាក់ សាដាច់ យូដា អាន ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K222_17","013_22_17","2KI","22","17","17","អន់ឌែ អ្លាត អាញ់ កេះ ទឹប សុះ តាំងហ៊ុម កា ប‌៉្រ័ះ អន់ទៀគ ណោះ ហង ប៉្រគ័ អន់ អាញ់ ប៉ិច អឺក ខាក់។ ញន កា ហ៊ូប ប‌៉្រ័ះ ឡាក់ អន់ឌែ ប៉្រគ័ លូ តី អន់ឌែ ទៅ ណោះ អាញ់ ចឹង អឺក ខាក់ កា មឿង អា អូ ស្វាស អុះ'។ ");
INSERT INTO tpu_vpl VALUES ("K222_18","013_22_18","2KI","22","18","18","ហះកា អន់ដីស ត្រគ់ សឹត រ៉ះ នីអៀ កា សាដាច់ យូដា ឡាក់ ប៉្រើ អន់ដីស ឡាំ អំប៉ញ់ លូ អាញ់ 'អាញ់ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ សុនសាត អ៊ីស្រាអ៊ែល រ៉ះ នីអៀ៖ កាប៉ាច់ ប៉ានឹរ ឡាក់ ច្រាគ់ រ៉ះ ពឹង ផាប់ ឡាក់ អីស កាតាំង ណោះ ");
INSERT INTO tpu_vpl VALUES ("K222_19","013_22_19","2KI","22","19","19","អីស កា ប៉ាន់ថិ ពុត ហះ ម៉ាត់ អាញ់ ផះ អីស កាតាំង អាញ់ កាប ប៉ាសាំង លូ មឿង យេរូសាឡឹម ទឹប កាប ប៉ាសាំង លូ ប៉ាសុន ឡាក់ អ្វៃ ពឹង មឿង អា ផា អន់ឌែ ចឹង តោ័ រ៉ុង តោ័ រ៉ាយ ទឹប សុនសាត អន់ទៀគ ចឹង ត័ះ ប៉ាស្យាប។ ញន កា អីស ហ៊ែក ខោ អាវ អីស ទៅ ទឹប ញ៉ាំ ហះ ម៉ាត់ អាញ់ ទឹល នីណោ័ះ អាញ់ កា សាំយ៉ាំង អីស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K222_20","013_22_20","2KI","22","20","20","ញន ណោះ ហង បះ អីស អូ ប៉ប័ សារ ចុនចៃ ណោះ អីស ចឹង អ្វៃ សាណុក សាវ៉ាក។ អន់តីគ ឡឹង អីស តោ័ ពួយ វគ័ យ៉ាគ់ អីស អាញ់ ចឹង អន់ សារ ចុនចៃ ពឹង មឿង អា' \"»។ កេះណោះ អន់ឌែ អ្យក់ សារ ណោះ ឡាំ រ៉ះ លូ សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("K223_1","013_23_1","2KI","23","1","1","កេះណោះ សាដាច់ យ៉ូសៀស អើ ក្រាគ់ តាំងកង់ អ្វៃ ពឹង ប៉ាថេត យូដា លូ ពឹង មឿង យេរូសាឡឹម ប៉ាតុំ គួប។ ");
INSERT INTO tpu_vpl VALUES ("K223_2","013_23_2","2KI","23","2","2","កេះណោះ អ៊ែ ឡាំ ប៉ាគ់ រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ឌូ លូ ប៉ាសុន ទិឌូ ឡាក់ អ្វៃ ពឹង ប៉ាថេត យូដា លូ មឿង យេរូសាឡឹម ទឹប ទី មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ទឹប មួត រ៉ាគឹយ ប‌៉្រ័ះ លូ ប៉ាសុន ទិណោ័ះ ទឹប មួត ប៉្រគ័ កាន រ៉ាតីស ទឹប ប៉ាសុន ដោច ដាច។ កេះណោះ អ៊ែ អាន គ្រឹប ខ ពឹង ផាប់ សាញ៉ា រែវ ពុត ឡាក់ ពូ ប៉ប័ កាណុង រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ពែ អន់ កា ប៉ាសុន ទិឌូ សាំយ៉ាំង។ ");
INSERT INTO tpu_vpl VALUES ("K223_3","013_23_3","2KI","23","3","3","អ៊ែ អ្វៃ អន់តាវ ហះ អញ់ជុង រ៉ោង រ៉ាម៉ះ កេះណោះ សាញ៉ា រែវ ពុត លូ ប‌៉្រ័ះ ប៊កកាតយ័ ផា ចឹង ប៉្រគ័ ពួយ ចាបាប់ ប‌៉្រ័ះ លូ សារ ប‌៉្រ័ះ ប៉្រើ ទិ ពុត ទិ ពៀក ទឹប ប៉្រគ័ ពួយ សារ សាញ៉ា រែវ ពុត ឡាក់ ទី ច្រាគ់ រ៉ះ ពឹង ផាប់ ណោះ ហង។ ប៉ាសុន ទិឌូ សាញ៉ា ផា ចឹង ប៉្រគ័ ពួយ ទិ សារ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K223_4","013_23_4","2KI","23","4","4","សាដាច់ កា ប៉្រើ វគ័ ហ៊ីលគីយ៉ា ឡាក់ ម៉ៃគ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ លូ មួត ក្រាគ់ រ៉ាម៉ះ ឡាក់ អ្វៃ កាន់តេ័ះ អ៊ែ ទឹប មួត ញ៉ាម អំប៉ារ ប៉្រើ អន់ឌែ អ្យក់ ឡាច់ ទិ កាណាគ័ សាំរ៉ាប់ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ បាល លូ ប‌៉្រ័ះ អាសេរ៉ា ទឹប កាណាគ័ សាំរ៉ាប់ សាំប‌៉័ះ ប៉ានេ សំឡង់ ពឹង ប៉្លៃង អ្យក់ ឡាច់ ទិ ឡឹង រ៉ោង រ៉ាម៉ះ ឡាំ សុះ អ្លាត គែង ឡីង មឿង យេរូសាឡឹម ក្យាម័ តាចាង័ កេដ្រូន កេះណោះ អ្យក់ អំហ្មូវ ណោះ ឡាំ កោ័ះ ប៉ាគ់ មឿង បេតអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("K223_5","013_23_5","2KI","23","5","5","អ៊ែ តាំងហ្យិត ឡាច់ ទិ មួត ក្រាគ់ រ៉ាម៉ះ ឡាក់ មួត សាដាច់ យូដា អន់ទ្រួលៗ ប៉្រើ អន់ឌែ សុះ តាំងហ៊ុម កា ប‌៉្រ័ះ បាល លូ ពុះ កាណាគ័ រ៉ាម៉ះ ពឹង ចារ ប៉ាឌួល ពឹង មឿង យេរូសាឡឹម លូ ប៉ាញ័ ទឹប ប៉ាថេត យូដា។ អន់ឌែ ណោះ ឃើយ សុះ តាំងហ៊ុម កា ប‌៉្រ័ះ បាល ទឹប ដារ់ ខៃ លូ សំឡង់ ទិណោ័ះ ឡាក់ អ្វៃ ពឹង ប៉្លៃង។ ");
INSERT INTO tpu_vpl VALUES ("K223_6","013_23_6","2KI","23","6","6","អ៊ែ កា អ្យក់ ឡាច់ ហ៊ូប ប‌៉្រ័ះ អាសេរ៉ា ឡឹង រ៉ោង រ៉ាម៉ះ ឡាំ សុះ អ្លាត គែង ឡីង មឿង យេរូសាឡឹម ក្យាម័ តាចាង័ កេដ្រូន។ ពូ សុះ កេះណោះ កាមៃ អន់ ហាច់ ហ៊ច អ្យក់ ឡាំ ចី ព្រឹះ ពឹង ចារ ពូ តប់ ប៉ាទ្រូ ប៉ាសុន ដោច ដាច។ ");
INSERT INTO tpu_vpl VALUES ("K223_7","013_23_7","2KI","23","7","7","រ៉ាំងហាវ ណោះ កា ទី កាម៉ាក័ ប្រូ ឡាកោ ប៉្រគ័ ប៉ារ៉គ់ កាម៉ាក័ ទៅ អ្វៃ ប៉ាគ់ រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ដេល ណោះ ហង បះ សាដាច់ យ៉ូសៀស យ៉ះ អ្លាត ចារ មួត ណោះ អ្វៃ។ កា ទី មួត អង់កាន់ តាញ ព្រៀយ ប៉្រគ័ អញ់ជុ សាំរ៉ាប់ តាគ់ អន់តុក ហ៊ូប ប‌៉្រ័ះ អាសេរ៉ា។ ");
INSERT INTO tpu_vpl VALUES ("K223_8","013_23_8","2KI","23","8","8","កេះណោះ អ៊ែ កា អើ មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ទិណោ័ះ ឡឹង មឿង អន់ទៀគៗ កាណុង ប៉ាថេត យូដា។ អ៊ែ ប៉្រគ័ អន់ ចារ រ៉ាម៉ះ ពឹង ចារ ប៉ាឌួល ទិណោ័ះ កេះ សាប ឡឹង មឿង កេបា លើយ ទឹល មឿង បៀសេបា ឡាក់ ចារ មួត ក្រាគ់ រ៉ាម៉ះ ណោះ សុះ តាំងហ៊ុម។ អ៊ែ កា តាគ់ អំព្លូក អន់ហ្នឹង ប៉ាគ់ ចារ ប៉ាឌួល ក្យាម័ អំប៉ារ វគ័ យូស្វេ គែង សាំងអ្យោ អំប៉ារ ទ្រួក តីស ពឹង មឿង ណោះ (វគ័ យូស្វេ ឃឺ ម៉ៃគ ណាំផា មឿង ណោះ)។ ");
INSERT INTO tpu_vpl VALUES ("K223_9","013_23_9","2KI","23","9","9","មួត ក្រាគ់ រ៉ាម៉ះ ណោះ អូ ខឹន ហាវ អន់តាវ ហះ អន់ហ្នឹង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ពឹង មឿង យេរូសាឡឹម ណាវ្គ ហង ហះកា អន់ឌែ សា ណុំ ប៉ាំង ឡាតាំង អន់ឌូ លូ មួត ក្រាគ់ រ៉ាម៉ះ អន់ទៀគ ណាវ្គ ទី ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K223_10","013_23_10","2KI","23","10","10","សាដាច់ យ៉ូសៀស កា ប៉្រគ័ អន់ ចារ តូផេត រជុង ប៉ានឹម ហ៊ិនណម កេះ សាប ម៉ាគ់ ជែ អន់ ទី បក់ ពឿ អ្យក់ គន កាម៉ាក័ លើ គន អង់កាន់ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ ម៉ូឡុក ណាវ្គ ហង។ ");
INSERT INTO tpu_vpl VALUES ("K223_11","013_23_11","2KI","23","11","11","អ៊ែ កា អ្យក់ ឡាច់ ហ៊ូប សេះ ទិណោ័ះ ឡាក់ សាដាច់ យូដា អន់ទ្រួលៗ ប៉្រគ័ សាំរ៉ាប់ កា អន់ឌែ សាំប‌៉័ះ ប៉ានេ ដារ់ ហះ អំប៉ារ រ៉ោង រ៉ាម៉ះ។ អ៊ែ កា សុះ អ្លាត រ៉ាតេ័ះ សាំរ៉ាប់ សាំប‌៉័ះ ប៉ានេ ដារ់ ដេល។ ហ៊ូប ទិណោ័ះ អ្វៃ ក្យាម័ កាណុង បក់ ប៉្រគ័ ង៉ារ កា សាដាច់ សិច នេថាន មេឡេក កាណុង ណោះ ពឹង ឡាន រ៉ោង រ៉ាម៉ះ។ ");
INSERT INTO tpu_vpl VALUES ("K223_12","013_23_12","2KI","23","12","12","កាប៉ាច់ អន់ហ្នឹង ឡាក់ សាដាច់ អន់ទ្រួលៗ ប៉្រគ័ ពឹង អន់តល័ ត្រង់ កាណុង សាដាច់ អេហះ លូ អន់ហ្នឹង ឡាក់ សាដាច់ ម៉ាណាសេ ប៉្រគ័ ពឹង ឡាន រ៉ោង រ៉ាម៉ះ ពៀរ ចារ ពែ សាដាច់ យ៉ូសៀស យ៉ះ អ្លាត អន់ ទិ កេះណោះ កាមៃ អន់ ប៉ាទុះ អ្យក់ គួក អ្លាត ពឹង តាចាង័ កេដ្រូន។ ");
INSERT INTO tpu_vpl VALUES ("K223_13","013_23_13","2KI","23","13","13","អ៊ែ កា ប៉្រគ័ អន់ សាប ចារ រ៉ាម៉ះ ពឹង ចារ ប៉ាឌួល គែង ដារ់ ឡាច់ មឿង យេរូសាឡឹម លូ គែង តាបូង ប៉ានឹម តើម អូលេវ ឡាក់ សាដាច់ សាឡូម៉ូន ប៉្រគ័ ពែ សាំរ៉ាប់ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ អាសាថារ៉ូត ឡាក់ ប‌៉្រ័ះ សុនសាត ស៊ីដូន ឡាក់ បឺគ អ៊ក កាខាក់ លូ សាំរ៉ាប់ ប‌៉្រ័ះ កេម៉ូះ ឡាក់ ប‌៉្រ័ះ សុនសាត ម៉ូអាប់ ឡាក់ បឺគ អ៊ក កាខាក់ ដេល លូ សាំរ៉ាប់ ប‌៉្រ័ះ មីលកូម ឡាក់ ប‌៉្រ័ះ សុនសាត អាម៉ូន ឡាក់ អូ ដាគ់ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("K223_14","013_23_14","2KI","23","14","14","សាដាច់ យ៉ូសៀស កា កាមៃ តាគ់ ប៉ាទុះ អញ់ជុង លូ តាឡក័ អ្លាត ហ៊ូប ប‌៉្រ័ះ អាសេរ៉ា កេះណោះ អ្យក់ កាន់តីង ប៉ាទ្រូ វ៉ឹត ប៉ាញ័ ទឹប ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K223_15","013_23_15","2KI","23","15","15","កេះណោះ សាដាច់ យ៉ូសៀស ឡាំ ប៉ាគ់ មឿង បេតអ៊ែល ទឹប យ៉ះ អ្លាត អន់ហ្នឹង ឡាក់ សាដាច់ យេរ៉ូបោម ប៉្រគ័ ប៉ាគ់ ចារ ប៉ាឌួល ពែ។ សាដាច់ យេរ៉ូបោម គន វគ័ នេបាត ណោះ ហង ប៉ាណាំ ប៉ាសុន អ៊ីស្រាអ៊ែល ប៉្រគ័ យច សើគ ពែ។ សាដាច់ យ៉ូសៀស សុះ អ្លាត ចារ រ៉ាម៉ះ ពឹង ចារ ប៉ាឌួល លូ អន់ហ្នឹង ណោះ ទឹប កាមៃ អន់ ហាច់ ហ៊ច។ កេះណោះ អ៊ែ សុះ អ្លាត ហ៊ូប ប‌៉្រ័ះ អាសេរ៉ា ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K223_16","013_23_16","2KI","23","16","16","ផះ ណោះ អ៊ែ កាលែង ហៃ ប៉ប័ រ៉ូង័ ចារ ពូ តប់ ប៉ាទ្រូ រជុង ប៉ានឹម កេះណោះ អ៊ែ ប៉្រើ ពូ ឡាំ អ្យក់ កាន់តីង ឡឹង រ៉ូង័ ណោះ ឡាំ ពុះ ពឹង អន់ហ្នឹង ភឿ ប៉ិច ប៉្រគ័ អន់ សាប ត្រគ់ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ កា បក់ រ៉ះ ប៉ាតាង ប‌៉្រ័ះ អន់ទួង ផះ សើគ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("K223_17","013_23_17","2KI","23","17","17","កេះណោះ សាដាច់ យ៉ូសៀស អំប៉ញ់ ផា «ហៃ រ៉ូង័ ពឿ ណោះ ?» មួត មឿង ណោះ តើល ផា «អា ហង រ៉ូង័ ប៉ាទ្រូ រ៉ាគឹយ ប‌៉្រ័ះ ឡាក់ ពឹះ ឡឹង ប៉ាថេត យូដា អ៊ែ ហង អន់ទួង ឡឹង សារ អីស ចឹង ថាំឡាយ អន់ហ្នឹង ប៉ាគ់ មឿង បេតអ៊ែល អា»។ ");
INSERT INTO tpu_vpl VALUES ("K223_18","013_23_18","2KI","23","18","18","សាដាច់ យ៉ូសៀស រ៉ះ ផា «អ្លាត ហះ ណោះ ហង ជែ អន់ ពឿ ឡាំ ទូញ កាន់តីង អ៊ែ ដៃ»។ ទឹល នីណោ័ះ ពូ អូ ទូញ កាន់តីង អ៊ែ អុះ កាប៉ាច់ កាន់តីង ប៉ាទ្រូ រ៉ាគឹយ ប‌៉្រ័ះ ឡឹង ប៉ាថេត អ៊ីស្រាអ៊ែល ឡាក់ តប់ អន់ឌូ ពូ កា អូ ទូញ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K223_19","013_23_19","2KI","23","19","19","សាដាច់ យ៉ូសៀស កា ថាំឡាយ រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ អន់ទៀគ ប៉ាគ់ ចារ ប៉ាឌួល ពឹង មឿង អន់ទៀគៗ ទិណោ័ះ ឡាក់ មួត សាដាច់ អ៊ីស្រាអ៊ែល ប៉្រគ័ ពែ។ រ៉ោង រ៉ាម៉ះ ទិណោ័ះ ប៉្រគ័ អន់ ប‌៉្រ័ះ ប៊កកាតយ័ អឺក ខាក់។ សាដាច់ យ៉ូសៀស ថាំឡាយ អន់ ទិ ឡាក់ កា អ៊ែ ប៉្រគ័ ប៉ាគ់ មឿង បេតអ៊ែល ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K223_20","013_23_20","2KI","23","20","20","អ៊ែ កា ប៉ាន់តោ័ ទិ ក្រាគ់ រ៉ាម៉ះ អ្វៃ ប៉ាគ់ ចារ ប៉ាឌួល ណោះ ពឹង អន់ហ្នឹង ទឹប ពុះ កាន់តីង ប៉ាទ្រូ ពឹង អន់ហ្នឹង ណោះ ដេល។ កេះណោះ អ៊ែ វ៉ីល សឹត ប៉ាគ់ មឿង យេរូសាឡឹម ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("K223_21","013_23_21","2KI","23","21","21","កេះណោះ សាដាច់ យ៉ូសៀស រ៉ះ កា ប៉ាសុន ទិឌូ ផា «ហគ់ ប៉្រគ័ ប៊ុន ទ្រួង អន់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ឡាក់ កា ច្រាគ់ រ៉ះ ពឹង ផាប់ សាញ៉ា រែវ ពុត»។ ");
INSERT INTO tpu_vpl VALUES ("K223_22","013_23_22","2KI","23","22","22","ឡឹង រ៉ាំងហាវ មួត ម៉ៃគ ណាំផា លើយ ទឹល រ៉ាំងហាវ សាដាច់ អ៊ីស្រាអ៊ែល លូ សាដាច់ យូដា ពូ អូ ឃើយ ប៉្រគ័ ប៊ុន ទ្រួង ដាគ់ នែវ អា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K223_23","013_23_23","2KI","23","23","23","អន់ឌែ ប៉្រគ័ ប៊ុន ទ្រួង កា ប‌៉្រ័ះ ប៊កកាតយ័ កាណុង មឿង យេរូសាឡឹម ត្រគ់ ផះ សាណាំ ទី ១៨ ផះ សាដាច់ យ៉ូសៀស អ្វៃ រ៉ាំងហៃ។ ");
INSERT INTO tpu_vpl VALUES ("K223_24","013_23_24","2KI","23","24","24","ម៉ោញ ណាវ្គ សាដាច់ យ៉ូសៀស តាំងហ្យិត ឡាច់ គ្រូ អ្លុ ស៊ល លូ គ្រូ អ្លុ អើ ប៉ាទ្រូ ទឹប អ្យក់ ឡាច់ ហ៊ូប ប‌៉្រ័ះ អន់ទៀគៗ ឡាក់ ទី ពឹង មឿង យេរូសាឡឹម លូ ពឹង ប៉ាថេត យូដា អន់ ទិ ភឿ ប៉្រគ័ ពួយ ទិ សារ ឡាក់ ច្រាគ់ រ៉ះ ពឹង ផាប់ ចាបាប់ ប‌៉្រ័ះ ឡាក់ វគ័ ហ៊ីលគីយ៉ា ប៉ប័ ពឹង រ៉ោង រ៉ាម៉ះ។ ");
INSERT INTO tpu_vpl VALUES ("K223_25","013_23_25","2KI","23","25","25","អន់ទ្រួល ឡឹង អ៊ែ អូ ទី សាដាច់ ចំ វ៉ីល ណាំង ប‌៉្រ័ះ ប៊កកាតយ័ ទិ ពុត ទិ ពៀក ទឹប ប៉ាង៉ាត័ ប៉ាលឹង ទឹប ឡាកោ ប៉ាំងឡៃ ទឹប ប៉្រគ័ ពួយ ចាបាប់ វគ័ ម៉ូសេ ទិណោ័ះ ឡាក់ កា សាដាច់ យ៉ូសៀស អុះ អន់តីគ ឡឹង អ៊ែ កា អូ ទី ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K223_26","013_23_26","2KI","23","26","26","យ‌៉័ះ នីណោ័ះ កាតាម ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ អឺក កា មួត ប៉ាថេត យូដា ញន កា សារ អូ ដាគ់ ឡាក់ សាដាច់ ម៉ាណាសេ ប៉្រគ័ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("K223_27","013_23_27","2KI","23","27","27","ប‌៉្រ័ះ ប៊កកាតយ័ កា រ៉ះ ផា «អាញ់ ចឹង តាំងហ្យិត ឡាច់ មួត ប៉ាសុន យូដា អន់ ចាំងហាយ្គ ឡឹង ម៉ាត់ អាញ់ ឡាក់ កា អាញ់ តាំងហ្យិត ប៉ាសុន អ៊ីស្រាអ៊ែល ពែ ដេល។ អាញ់ ចឹង អ្លាត មឿង យេរូសាឡឹម ឡាក់ មឿង អាញ់ រ៉ើស ទឹប អាញ់ ចឹង អ្លាត រ៉ោង រ៉ាម៉ះ ឡាក់ ចារ អាញ់ ផា ពូ ចឹង ប៉ានេ អាញ់ ហះ ណោះ ហង»។ ");
INSERT INTO tpu_vpl VALUES ("K223_28","013_23_28","2KI","23","28","28","សារ អន់ទៀគៗ ណាវ្គ រ៉ះ ឡឹង សាដាច់ យ៉ូសៀស ទឹប ង៉ារ អ៊ែ ប៉្រគ័ ពូ ច្រាគ់ គម ពឹង ផាប់ «សារ ម៉ាមន សាដាច់ ប៉ាថេត យូដា»។ ");
INSERT INTO tpu_vpl VALUES ("K223_29","013_23_29","2KI","23","29","29","ផះ រ៉ាំងហាវ ណោះ នេកោ ឡាក់ សាដាច់ ប៉ាថេត អ៊ីស៊ីប អ្យក់ តាហាន អ៊ែ ឡាំ ប៉ាគ់ តាំងលេ អឺប៉្រាត ចឹង តង័ សាដាច់ អាស៊ីរី។ ផះ ណោះ សាដាច់ យ៉ូសៀស កា អ្យក់ តាហាន ឡាំ សាំងកាត់ ហះ ទ្រូង ចឹង តាកូះ លូ អ៊ែ ហះកា សាគ់ សាដាច់ នេកោ ប៉ប័ កា កោះ ប៉ាន់តោ័ អ្លាត អ៊ែ ហះ មឿង មេគីដោ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("K223_30","013_23_30","2KI","23","30","30","មួត ម៉ៃគ តាហាន សាដាច់ យ៉ូសៀស កា ប៉ោក ហាវ ប៉ាទ្រូ អ៊ែ ពឹង រ៉ាតេ័ះ អ្យក់ សឹត ប៉ាគ់ មឿង យេរូសាឡឹម កេះណោះ ពូ តប់ ពឹង រ៉ូង័ អ៊ែ ទៅ។ ឡៃង ឡឹង ណោះ ណាវ្គ មួត ប៉ាសុន កា អ្យក់ យ៉ូអាហះ គន សាដាច់ យ៉ូសៀស ប៉្រើ ហាវ ប៉្រគ័ សាដាច់ តាង ពឹ អ៊ែ ណាវ្គ។ … ");
INSERT INTO tpu_vpl VALUES ("K224_8","013_24_8","2KI","24","8","8","ផះ យេហូយ៉ាគីន ហាវ ប៉្រគ័ សាដាច់ អាញុ អ៊ែ ១៨ សាណាំ អ៊ែ ប៉្រគ័ សាដាច់ ដឹង ៣ ខៃ ពឹង មឿង យេរូសាឡឹម។ មើគ អ៊ែ សិច នេហ៊ូសាថា គន វគ័ អ៊ែលណាថាន ឡឹង មឿង យេរូសាឡឹម។ ");
INSERT INTO tpu_vpl VALUES ("K224_9","013_24_9","2KI","24","9","9","សាដាច់ យេហូយ៉ាគីន ប៉្រគ័ សារ អូ ដាគ់ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ កាខាក់ ឡាក់ កា ពឹ អ៊ែ ឃើយ ប៉្រគ័ ពែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K224_10","013_24_10","2KI","24","10","10","ផះ ណោះ តាហាន នេប៊ូកានេសា ឡាក់ សាដាច់ បាប៊ីឡូន ឡាំ វ៉ិង ជុំ មឿង យេរូសាឡឹម។ ");
INSERT INTO tpu_vpl VALUES ("K224_11","013_24_11","2KI","24","11","11","ផះ តាហាន វ៉ិង ជុំ មឿង យេរូសាឡឹម ណោះ សាដាច់ នេប៊ូកានេសា កា ឡាំ អ៊ែ តាំងឡា ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K224_12","013_24_12","2KI","24","12","12","ផះ ណោះ សាដាច់ យេហូយ៉ាគីន ទឹប មើគ អ៊ែ លូ មួត រ៉ាតីស ម៉ៃគ តាហាន លូ មួត ប៉្រគ័ កាន កា សាដាច់ កា ឡាច់ ឡាំ ញម ហះ ង៉ីរ សាដាច់ បាប៊ីឡូន។ សាដាច់ បាប៊ីឡូន រ៉ុប អ្យក់ សាដាច់ យេហូយ៉ាគីន ផះ សាណាំ ទី ៨ ផះ អ៊ែ អ្វៃ រ៉ាំងហៃ។ ");
INSERT INTO tpu_vpl VALUES ("K224_13","013_24_13","2KI","24","13","13","សាដាច់ នេប៊ូកានេសា អ្យក់ ទិ កាណាគ័ ពឹង រ៉ោង រ៉ាម៉ះ លូ រ៉ាស អំប៉ាស ពឹង ហី សាដាច់ ទឹប កាមៃ តាគ់ ប៉ាទុះ អ្យក់ ម៉ាស ឡឹង ឃឿង ខង ឡាក់ សាដាច់ សាឡូម៉ូន ប៉្រគ័ សាំរ៉ាប់ យរ កាណុង រ៉ោង រ៉ាម៉ះ ពែ។ សារ អា កើត ពឹះ ត្រគ់ ពួយ ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ រ៉ះ អន់ទ្រួល កេះ។ ");
INSERT INTO tpu_vpl VALUES ("K224_14","013_24_14","2KI","24","14","14","សាដាច់ នេប៊ូកានេសា កា គៀរ ឡាំ មួត អ្វៃ ពឹង មឿង យេរូសាឡឹម ទិណោ័ះ ឃឺ មួត រ៉ាតីស លូ មួត តាហាន ឡាក់ កេង ខាក់។ មួត ឡាក់ អ៊ែ គៀរ ទិណោ័ះ ទី ចំលួន ម៉ោញ មឺន ដូវ ទឹប មួត រ៉ាគឹយ ប៉្រគ័ ហី លូ រ៉ាគឹយ រស អ្វៃ សល់ ដឹង មួត ថុក ញ៉ាក ដោច អ្វៃ ពឹង មឿង ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K224_15","013_24_15","2KI","24","15","15","សាដាច់ នេប៊ូកានេសា កា គៀរ ឡាំ សាដាច់ យេហូយ៉ាគីន លូ មើគ អ៊ែ ទឹប មួត កាម៉ាញ់ លូ មួត រ៉ាតីស ទឹប ម៉ៃគ ណាំផា ឡឹង មឿង យេរូសាឡឹម អ្យក់ ឡាំ ប៉្រគ័ ទុច ប៉ាគ់ ប៉ាថេត បាប៊ីឡូន។ ");
INSERT INTO tpu_vpl VALUES ("K224_16","013_24_16","2KI","24","16","16","អ៊ែ កា គៀរ ឡាំ ប៉ាណូស កេង ខាក់ ៧០០០ ដូវ លូ មួត រ៉ាគឹយ ប៉្រគ័ ហី លូ រ៉ាគឹយ រស ១០០០ ដូវ។ មួត ទិណោ័ះ ស៊ុត កា សាងុំ កេង អ្លុ តាកូះ ប្ល‌៉័ះ។ ");
INSERT INTO tpu_vpl VALUES ("K224_17","013_24_17","2KI","24","17","17","កេះណោះ សាដាច់ បាប៊ីឡូន កា អ្យក់ ម៉ាថានៀ ឡាក់ ក្លឹញ សាដាច់ យេហូយ៉ាគីន ប៉្រើ ប៉្រគ័ សាដាច់ ប៉ាតាង អ៊ែ ម៉ាគ់ រ៉ាំងហៃ មួត ឡាក់ អ្វៃ សល់។ សាដាច់ បាប៊ីឡូន កា តូរ័ សិច ម៉ាថានៀ ផា សេដេគៀ ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("K224_18","013_24_18","2KI","24","18","18","ផះ សេដេគៀ ហាវ ប៉្រគ័ សាដាច់ អាញុ អ៊ែ ២១ សាណាំ។ អ៊ែ រ៉ាំងហៃ ពឹង មឿង យេរូសាឡឹម ទុញ ១១ សាណាំ មើគ អ៊ែ សិច ហាមូថាល គន វគ័ យេរេមៀ ឡឹង តេះ លីបណា។ ");
INSERT INTO tpu_vpl VALUES ("K224_19","013_24_19","2KI","24","19","19","សាដាច់ សេដេគៀ ប៉្រគ័ សារ អូ ដាគ់ យច ពុត ប‌៉្រ័ះ ប៊កកាតយ័ កាខាក់ ឡាក់ កា សាដាច់ យេហូយ៉ាគីម ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K224_20","013_24_20","2KI","24","20","20","ប៉ាគ់ អន់តីគ ប‌៉្រ័ះ ប៊កកាតយ័ អឺក ខាក់ កា មួត មឿង យេរូសាឡឹម លូ មួត ប៉ាថេត យូដា បះ អ៊ែ តាំងហ្យិត ឡាច់ អន់ឌែ ឡឹង ម៉ាត់ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("K225_1","013_25_1","2KI","25","1","1","ផះ ណោះ សាដាច់ សេដេគៀ កា ប៉ាសាំង លូ សាដាច់ បាប៊ីឡូន។ ប៉ាគ់ ទឹល សាណាំ ទី ៩ ផះ រ៉ាំងវ៉ាង សាដាច់ សេដេគៀ រ៉ាំងហៃ ផះ ដារ់ ទី ១០ ខៃ ១០ នេប៊ូកានេសា ឡាក់ សាដាច់ បាប៊ីឡូន អ្យក់ ឡាំ តាហាន អ៊ែ ទិណោ័ះ វ៉ិង ជុំ មឿង យេរូសាឡឹម។ អន់ឌែ កា ពូក តេះ ជុំ មឿង ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("K225_2","013_25_2","2KI","25","2","2","អន់ឌែ វ៉ិង ជុំ មឿង លើយ ទឹល សាណាំ ទី ១១ ផះ រ៉ាំងវ៉ាង សាដាច់ សេដេគៀ រ៉ាំងហៃ។ ");
INSERT INTO tpu_vpl VALUES ("K225_3","013_25_3","2KI","25","3","3","ប៉ាគ់ ទឹល ដារ់ ទី ៩ ខៃ ៤ សាណា ពឹង មឿង យេរូសាឡឹម កា ទិ ប៉ាសុន កា ឡាយ៉ិត ឡាំងវ៉ាញ់ ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("K225_4","013_25_4","2KI","25","4","4","ផះ ណោះ តាម៉ឺរ កា តាល់ តាគ់ តាលុះ ប៉ាន់ទៀយ ម៉ោញ ចារ។ យ‌៉័ះ តាហាន បាប៊ីឡូន វ៉ិង ជុំ មឿង កាតាម មួត តាហាន យូដា សាតាក់ ឡាច់ ផះ កាម៉ាំង ទ្រង អំប៉ារ ហះ តាវ៉ាង័ ប៉ាន់ទៀយ ទិ ពៀរ ក្យាម័ សួន សាដាច់ អន់ឌែ កា ចាក ទ្រង ឡាំ ប៉ាគ់ ស៊្រែ អារ៉ាបា។ ");
INSERT INTO tpu_vpl VALUES ("K225_5","013_25_5","2KI","25","5","5","តាហាន បាប៊ីឡូន តាយ៉ិប ពួយ តាន័ សាដាច់ សេដេគៀ ពឹង ស៊្រែ ក្យាម័ មឿង យេរីខូ។ ផះ ណោះ មួត តាហាន អ៊ែ សាតាក់ អ្លាត អ៊ែ តាប៉្រះ តាប៉្រោង។ ");
INSERT INTO tpu_vpl VALUES ("K225_6","013_25_6","2KI","25","6","6","តាហាន បាប៊ីឡូន រ៉ុប សាដាច់ សេដេគៀ អ្យក់ ឡាំ ប៉ាគ់ សាដាច់ នេប៊ូកានេសា អ្វៃ ប៉ាគ់ មឿង រីបឡា កេះណោះ ពូ តាត់ស៊ិន សារ ចៃគ ថូត អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("K225_7","013_25_7","2KI","25","7","7","ពូ ប៉ាន់តោ័ គន កាម៉ាក័ អ៊ែ ទិណោ័ះ ហះ ម៉ាត់ អ៊ែ ទៅ។ កេះណោះ ពូ ខ្វិក ឡាច់ ម៉ាត់ អ៊ែ ទឹប កត់ ចគ់ លូ ច្រ្វាល់ សាប៉ាន័ អ្យក់ ឡាំ ប៉ាគ់ មឿង បាប៊ីឡូន។ ");
INSERT INTO tpu_vpl VALUES ("K225_8","013_25_8","2KI","25","8","8","ដារ់ ទី ៧ ខៃ ៥ កាណុង សាណាំ ទី ១៩ ផះ សាដាច់ នេប៊ូកានេសា អ្វៃ រ៉ាំងហៃ ប៉ាថេត បាប៊ីឡូន វគ័ នេប៊ូសារ៉ាដាន ឡាក់ ម៉ៃគ តាហាន ឡាក់ ប៉្រគ័ កាន កា សាដាច់ បាប៊ីឡូន អ៊ែ ឡាំ ប៉ាគ់ មឿង យេរូសាឡឹម។ ");
INSERT INTO tpu_vpl VALUES ("K225_9","013_25_9","2KI","25","9","9","អ៊ែ សុះ ថាំឡាយ រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ទឹប សុះ ហី សាដាច់ លូ ហី ឡាក់ ដាគ់ តីស ពឹង មឿង ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("K225_10","013_25_10","2KI","25","10","10","តាហាន បាប៊ីឡូន ទិណោ័ះ ឡាក់ អ្វៃ អន់ឌូ លូ ម៉ៃគ តាហាន ណោះ កា តាគ់ អំព្លូក ប៉ាន់ទៀយ ជុំ មឿង យេរូសាឡឹម។ ");
INSERT INTO tpu_vpl VALUES ("K225_11","013_25_11","2KI","25","11","11","ប៉ាណូស បក់ អ្វៃ សល់ កាណុង មឿង ណោះ ទឹប មួត បក់ ឡាច់ ញម កា សាដាច់ បាប៊ីឡូន លូ កាំឡាំង ប៉ាសុន ទិឌូ វគ័ នេប៊ូសារ៉ាដាន កា គៀរ ឡាំ អន់ឌែ ប៉ាគ់ ប៉ាថេត បាប៊ីឡូន ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("K225_12","013_25_12","2KI","25","12","12","ហះកា អ៊ែ អ្លាត បក់ ថុក ញ៉ាក កាខាក់ អន់ អ្វៃ កាណុង ស្រុក តេះ ណោះ ម៉ាគ់ អន់ឌែ ប៉្រគ័ ម៉ីរ លូ រ៉ាំងហៃ តើម ប៉្លៃ អង់កាច។ ");
INSERT INTO tpu_vpl VALUES ("K225_13","013_25_13","2KI","25","13","13","មួត បាប៊ីឡូន កាមៃ តាគ់ ប៉ាទុះ អញ់ជុង សាប៉ាន័ រ៉ោង រ៉ាម៉ះ លូ រ៉ាតេ័ះ សាប៉ាន័ ទឹប កាមៃ តាគ់ ប៉ាទុះ អាង តីស ពូ ប៉្រគ័ លូ សាប៉ាន័ ពឹង ឡាន រ៉ោង រ៉ាម៉ះ អន់ឌែ អ្យក់ សឹត សាប៉ាន័ ទិណោ័ះ ប៉ាគ់ មឿង បាប៊ីឡូន។ ");
INSERT INTO tpu_vpl VALUES ("K225_14","013_25_14","2KI","25","14","14","អន់ឌែ អ្យក់ កគ័ អ្យក់ វ៉ាក ចាណាស ខាល់ លូ កាណាគ័ អន់ទៀគៗ ណាវ្គ ឡាក់ ពូ ប៉្រគ័ លូ សាប៉ាន័ សាំរ៉ាប់ យរ កាណុង រ៉ោង រ៉ាម៉ះ ទិណោ័ះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K225_15","013_25_15","2KI","25","15","15","កាណាគ័ សាំរ៉ាប់ ចៃគ ង៉ារ អុញ អោ លូ កាណាគ័ ញ៉ាៗ ឡាក់ ពូ ប៉្រគ័ លូ ម៉ាស លូ ប៉្រាក់ កា ម៉ៃគ តាហាន ណោះ អ្យក់ ទិ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K225_16","013_25_16","2KI","25","16","16","អញ់ជុង ទិ ពៀរ លូ អាង តីស ទឹប រ៉ាតេ័ះ ឡាក់ សាដាច់ សាឡូម៉ូន ប៉្រគ័ សាំរ៉ាប់ យរ កាណុង រ៉ោង រ៉ាម៉ះ កាណាគ័ ទិណោ័ះ ឡាក់ ពូ ប៉្រគ័ លូ សាប៉ាន័ អូ ទី ពឿ ចឹង អ្លុ កា ក្លាំង ប៉ុប ចំ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("K225_17","013_25_17","2KI","25","17","17","អញ់ជុង ម៉ោញៗ ចាំងហីគ ១៨ ហាត់ កល់ អញ់ជុង ពូ ប៉្រគ័ លូ សាប៉ាន័ ណោះ ចាំងហីគ ៣ ហាត់ ណាវ្គ ទឹប ពូ អ្យក់ ច្រ្វាល់ ប៉្រគ័ ម៉ាត់ ច្យិត លូ ប៉្រគ័ ហ៊ូប ប៉្លៃ ទទឹម ជុំ ណោះ កាណាគ័ ទិណោ័ះ កា ប៉្រគ័ លូ សាប៉ាន័។ អញ់ជុង ទិ ពៀរ កា និះទៅ ទី ច្រ្វាល់ ម៉ាត់ ច្យិត ពឹង កល់ អញ់ជុង ដេល។ ");
INSERT INTO tpu_vpl VALUES ("K225_18","013_25_18","2KI","25","18","18","ម៉ៃគ តាហាន រ៉ុប វគ័ សេរ៉ាយ៉ា ឡាក់ ម៉ៃគ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ឡាក់ តីស ហ៊្លត លូ សេផានៀ ឡាក់ ម៉ៃគ ក្រាគ់ រ៉ាម៉ះ និះទៅ ដេល លូ មួត ញ៉ាម អំប៉ារ រ៉ោង រ៉ាម៉ះ ទិ ប៉ៃង ដូវ ");
INSERT INTO tpu_vpl VALUES ("K225_19","013_25_19","2KI","25","19","19","ទឹប រ៉ុប ម៉ៃគ តាហាន ម៉ោញ ដូវ ឡឹង មឿង ណោះ លូ រ៉ុប ក្រុំ ពឹកសា លូ សាដាច់ ប៉ាតាម័ ដូវ លូ បក់ ច្រាគ់ សត់ត្រា កា ម៉ៃគ តាហាន ឡាក់ អើ ប៉ាសុន ប៉្រគ័ តាហាន។ វគ័ នេប៊ូសារ៉ាដាន កា រ៉ុប ប៉ាសុន ៦០ ដូវ ណាវ្គ ឡាក់ ផះ អ្វៃ ពឹង មឿង។ ");
INSERT INTO tpu_vpl VALUES ("K225_20","013_25_20","2KI","25","20","20","អ៊ែ កា អ្យក់ ឡាំ មួត ណោះ ប៉ាគ់ សាដាច់ បាប៊ីឡូន ឡាក់ អ្វៃ ប៉ាគ់ មឿង រីបឡា។ ");
INSERT INTO tpu_vpl VALUES ("K225_21","013_25_21","2KI","25","21","21","សាដាច់ បាប៊ីឡូន កា ប៉ាន់តោ័ ទិ មួត ណោះ ប៉ាគ់ មឿង រីបឡា កាណុង ខេត ហាម៉ាត។ នីអៀ ហង ពូ គៀរ ឡាច់ ប៉ាសុន យូដា ចាំងហាយ្គ ឡឹង ប៉ាថេត អន់ឌែ ទៅ។ ");
INSERT INTO tpu_vpl VALUES ("K225_22","013_25_22","2KI","25","22","22","សាដាច់ នេប៊ូកានេសា គម ប៉ាសុន អន់ដា អន់ អ្វៃ ពឹង ខេត យូដា ទឹប អ៊ែ ប៉្រើ កេដាលៀ គន វគ័ អាហ៊ីកាម សោ វគ័ សាផាន ប៉្រើ រ៉ាំងហៃ មួត ប៉ាសុន។ ");
INSERT INTO tpu_vpl VALUES ("K225_23","013_25_23","2KI","25","23","23","កាប៉ាច់ មួត ម៉ៃគ តាហាន លូ មួត តាហាន ឡាក់ អូ ចៃ ញម កា សាដាច់ បាប៊ីឡូន ណោះ ផះ អន់ឌែ កាតាំង ផា សាដាច់ បាប៊ីឡូន អ្យក់ ហាវ វគ័ កេដាលៀ ប៉្រើ ប៉្រគ័ ម៉ៃគ រ៉ាំងហៃ ប៉ាសុន អន់ឌែ កា ប៉ាណាំ គួប ឡាំ កាកាប លូ អ៊ែ ប៉ាគ់ មឿង មីសាប៉ា។ អន់ឌែ ណោះ ទី សិច ឡាក់ កា អា៖ អ៊ីសាម៉ាអ៊ែល គន វគ័ នេថានៀ យ៉ូហាណាន គន វគ័ ការៀ លូ សេរ៉ាយ៉ា គន វគ័ ថាន់ហ៊ូមែត ឡឹង តេះ នេថូផា លូ យ៉ាសានៀ គន បក់ ពឹះ ឡឹង តេះ ម៉ាកាធី។ ");
INSERT INTO tpu_vpl VALUES ("K225_24","013_25_24","2KI","25","24","24","វគ័ កេដាលៀ ម៉ត់ លូ អន់ឌែ ទឹប មួត តាហាន ទិណោ័ះ អ៊ែ កាប ផា «អន់ដីស ជែ អ្យូគ កា មួត បាប៊ីឡូន ហគ់ អ្វៃ កាណុង ប៉ាថេត អា ទឹប ប៉្រគ័ ពួយ សាដាច់ បាប៊ីឡូន ពិ ម៉ាគ់ អន់ដីស ចឹង ទី សារ សាណុក សាវ៉ាក តាទឹច»។ ");
INSERT INTO tpu_vpl VALUES ("K225_25","013_25_25","2KI","25","25","25","ហះកា ប៉ាគ់ ទឹល ខៃ ៧ អ៊ីសាម៉ាអ៊ែល គន វគ័ នេថានៀ សោ វគ័ អេលីសាម៉ា ឡាក់ ផូង័ វ៉ាច់ សាដាច់ ដាវីត ឡាំ អន់ឌូ លូ តាហាន ១០ ដូវ អន់ឌែ ប៉ាន់តោ័ អ្លាត វគ័ កេដាលៀ ទឹប មួត យូដា លូ មួត បាប៊ីឡូន ឡាក់ អ្វៃ អន់ឌូ លូ អ៊ែ ប៉ាគ់ មឿង មីសាប៉ា។ ");
INSERT INTO tpu_vpl VALUES ("K225_26","013_25_26","2KI","25","26","26","ផះ ណោះ សុនសាត អ៊ីស្រាអ៊ែល ទិឌូ ទឹប មួត ប៉ាសុន ទឹប មួត រ៉ាតីស លូ មួត តាហាន កា សាតាក់ ឡាំ ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ញន កា អ្យូគ កា មួត បាប៊ីឡូន។ ");
INSERT INTO tpu_vpl VALUES ("K225_27","013_25_27","2KI","25","27","27","៣៧ សាណាំ អន់តីគ ឡឹង ពូ រ៉ុប សាដាច់ យេហូយ៉ាគីន ត្រគ់ ពឹង សាណាំ អេវីល មេរ៉ូដាក ហាវ ប៉្រគ័ សាដាច់ ប៉ាថេត បាប៊ីឡូន ផះ ដារ់ ទី ២៧ ខៃ ១២ អ៊ែ តោះ ឡើយ សាដាច់ យេហូយ៉ាគីន ឡឹង ខុក ");
INSERT INTO tpu_vpl VALUES ("K225_28","013_25_28","2KI","25","28","28","ទឹប អ៊ែ ប៉្រគ័ គួប រ៉ាំពង លូ យេហូយ៉ាគីន ទឹប អន់ យេហូយ៉ាគីន អ្វៃ ចារ ដាគ់ៗ ហ៊្លត ឡឹង មួត សាដាច់ អន់ទៀគៗ ឡាក់ អ្វៃ កាន់តេ័ះ អំរ៉ាញ សាដាច់ បាប៊ីឡូន ឡាក់ អ្វៃ ពឹង មឿង បាប៊ីឡូន។ ");
INSERT INTO tpu_vpl VALUES ("K225_29","013_25_29","2KI","25","29","29","យេហូយ៉ាគីន កា អ្លាត ខោ អាវ ពូ ត្រគ់ ខុក ទឹប សង់ សា អន់ឌូ លូ សាដាច់ បាប៊ីឡូន រ៉ប់ ដារ់ លើយ ទឹល ឡុច អាញុ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("K225_30","013_25_30","2KI","25","30","30","សាដាច់ បាប៊ីឡូន ឃើយ អន់ លៀន កា អ៊ែ រ៉ប់ ដារ់ ពួយ អ៊ែ តងកាន ទឹល ឡុច អាញុ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("NH1_1","017_1_1","NEH","1","1","1","អា ឡាក់ ប៉ានឹរ នេហេមៀ គន វគ័ ហាកាលៀ។ ពឹង ខៃ ៩ សាណាំ ២០ រ៉ាំងវ៉ាង សាដាច់ អាថាស៊ើកសេះ រ៉ាំងហៃ ឃឺ ផះ អាញ់ អ្វៃ ពឹង ហី សាដាច់ ប៉ាគ់ មឿង ស៊ូសាន ");
INSERT INTO tpu_vpl VALUES ("NH1_2","017_1_2","NEH","1","2","2","អុះ អាញ់ សិច ហាណានី លូ បក់ អន់ដា ណាវ្គ ពឹះ ឡឹង ខេត យូដា ឡាំ ប៉ាគ់ ណោះ ដេល។ អាញ់ អំប៉ញ់ អន់ឌែ ឡឹង សារ សុនសាត អ៊ីស្រាអ៊ែល ឡាក់ រ៉ាវ៉ាច់ ឡឹង ប៉្រគ័ ទុច ណោះ ពែ ឡាក់ សឹត ប៉ាគ់ ប៉ាថេត ទៅ ណាវ្គ លូ អំប៉ញ់ ឡឹង សារ មឿង យេរូសាឡឹម ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NH1_3","017_1_3","NEH","1","3","3","អន់ឌែ រ៉ះ កា អាញ់ ផា «មួត បក់ ពូ អ្យក់ ប៉្រគ័ ទុច ឡាក់ សឹត ប៉ាគ់ ខេត យូដា កេះ អន់ឌែ ទី សារ ប៉ាណាប ប៉ាបប៉ុន លូ តាយួស ខាក់។ កាប៉ាច់ មឿង យេរូសាឡឹម ទ្រួក កា សាដះ ព្លូក អំប៉ារ មឿង កា ពូ សុះ ទិ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("NH1_4","017_1_4","NEH","1","4","4","ប៉ាគ់ អាញ់ កាតាំង សារ ទិណោ័ះ អាញ់ អង់អ្វៃ ញ៉ាំ សោក ទុញ ដារ់ អាញ់ កា កំ អូ សា សាណា លូ ម៉ន់ អើ ប‌៉្រ័ះ ពឹង ប៉្លៃង ផា ");
INSERT INTO tpu_vpl VALUES ("NH1_5","017_1_5","NEH","1","5","5","«អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ អ្វៃ ពឹង ប៉្លៃង អីស ប‌៉្រ័ះ តីស កាខាក់ ឡាក់ ត្រគ់ អ្យូគ អ្យិល កូត័ អីស អូ ពឹល អុះ សារ សាញ៉ា រែវ ពុត  អីស កា តាប៉ាប តាប៉ុន លើយ កា បក់ ចំ ឡាក់ ប៉ិច ចៃ កា អីស លូ ប៉្រគ័ ពួយ ប៉ានឹរ អីស ប៉្រើ។ ");
INSERT INTO tpu_vpl VALUES ("NH1_6","017_1_6","NEH","1","6","6","ប៉រ់ អីស សាំយ៉ាំង លូ ហៃ គែង អាញ់ ឡាក់ ទុច អីស ផះ អាញ់ ម៉ន់ ឡោម អីស ទឹប កាម៉ាំង ទឹប កាដារ់ រ៉ះ ឡឹង សារ មួត ប៉ាសុន អ៊ីស្រាអ៊ែល អាញ់ ឡាប់ ញម សារ យច ប៉ាសុន អ៊ីស្រាអ៊ែល ខង ញឹន ទិឌូ ប៉្រគ័ យច លូ អីស ឡាកោ អាញ់ ទៅ លូ ផូង័ វ៉ាច់ វគ័ យ៉ាគ់ អាញ់ កា ប៉្រគ័ យច ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NH1_7","017_1_7","NEH","1","7","7","ញឹន ប៉្រគ័ អូ ដាគ់ កាខាក់ ប៉ាសាំង លូ អីស ឃឺ ញឹន អូ ប៉្រគ័ ពួយ ចាបាប់ លូ សារ អន់តគ់ ប៉ាតោ ប៉្រោ ទឹប ទិណោ័ះ ឡាក់ អីស រ៉ះ កា វគ័ ម៉ូសេ ឡាក់ ទុច អីស ពែ។ ");
INSERT INTO tpu_vpl VALUES ("NH1_8","017_1_8","NEH","1","8","8","ប៉រ់ អីស កាចាំង ឡឹង ប៉ានឹរ ឡាក់ អីស រ៉ះ កា វគ័ ម៉ូសេ \"ផា អន់ដីស អូ ត្រង់ កា អាញ់ ណោះ អាញ់ ចឹង ប៉ាក្លះ ប៉ាក្លាយ អន់ដីស អន់ អ្វៃ ពឹង អន់តិគ័ សុនសាត អន់ទៀគ ");
INSERT INTO tpu_vpl VALUES ("NH1_9","017_1_9","NEH","1","9","9","ហះកា ផា អន់ដីស វ៉ីល ប៉ាគ់ អាញ់ លូ ប៉្រគ័ ពួយ ប៉ានឹរ អាញ់ ប៉្រើ យ‌៉័ះ ពូ អ្យក់ អន់ដីស ឡាំ អ្វៃ ប៉ាគ់ ឡាណុច ប៉្លៃង កាតាម កា អាញ់ ចឹង ប៉ាតុំ លូ ប៉ាណាំ អន់ដីស សឹត ប៉ាគ់ ចារ ទៅ ឡាក់ អាញ់ រ៉ើស សាំរ៉ាប់ ចារ អាញ់ អ្វៃ ដេល\"។ ");
INSERT INTO tpu_vpl VALUES ("NH1_10","017_1_10","NEH","1","10","10","មួត បក់ សឹត ប៉ាគ់ ខេត យូដា អន់ឌែ ឡាក់ ទុច អីស ឃឺ ប៉ាសុន ឡាក់ អីស ហ្វាយ លូ អំរ៉ាញ អឺញ កេង ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("NH1_11","017_1_11","NEH","1","11","11","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អីស សាំយ៉ាំង ប៉ានឹរ អាញ់ ម៉ន់ ឡោម លូ ប៉ានឹរ ទុច អីស អន់ទៀគៗ ណាវ្គ ឡាក់ ប៉ិច ប៉្រគ័ ពួយ អ្យិល កូត័ អ្យូគ កា អីស។ អន់ សារ អាញ់ ចឹង ប៉្រគ័ ដារ់ អា កើត ទី លូ អន់ សាដាច់ តាប៉ាប តាប៉ុន កា អាញ់ ណើ»។ ផះ រ៉ាំងវ៉ាង ណោះ អាញ់ ប៉្រគ័ ង៉ារ អន់ទឺប ចក តាពែ កា សាដាច់។ ");
INSERT INTO tpu_vpl VALUES ("NH2_1","017_2_1","NEH","2","1","1","ពឹង ខៃ ១ សាណាំ ២០ រ៉ាំងវ៉ាង សាដាច់ អាថាស៊ើកសេះ រ៉ាំងហៃ ផះ អ៊ែ អ្វៃ អៃត សា អាញ់ អ្យក់ តាពែ ប៉្លៃ អង់កាច ត្រឹង អន់ កា អ៊ែ។ អាញ់ អូ ឃើយ ប៉្រគ័ ម៉ូះ ម៉ាត់ សាំងអយ នែវ អា ហះ ម៉ាត់ សាដាច់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("NH2_2","017_2_2","NEH","2","2","2","សាដាច់ អំប៉ញ់ អាញ់ ផា «អីស អូ ទី អីគ ញ៉ា អុះ ខ ញ៉ា បះ ម៉ូះ ម៉ាត់ អីស សាំងអយ នីអៀ ? អីស អុក ពុត ពៀក ឡឹង សារ ញ៉ា ?» ផះ ណោះ អាញ់ កាខរ់ ណូស អ្យូគ ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("NH2_3","017_2_3","NEH","2","3","3","អាញ់ រ៉ះ កា សាដាច់ ផា «អន់ អីស ទី អាញុ អ្វៃ លើយ។ នីចម័ ម៉ូះ ម៉ាត់ អាញ់ ចឹង អ្លុ ហោក រ៉គ់ ខង មឿង ឡាក់ ទី រ៉ូង័ ប៉ាទ្រូ វគ័ យ៉ាគ់ អាញ់ តាលៀយ រ៉ាយ រ៉ាំ កេះ កាប៉ាច់ អំប៉ារ ទ្រួក មឿង កា អុញ សា ទិ ដេល»។ ");
INSERT INTO tpu_vpl VALUES ("NH2_4","017_2_4","NEH","2","4","4","សាដាច់ អំប៉ញ់ អាញ់ ផា «អីស ប៉ិច ប៉រ់ ញ៉ា ឡឹង អាញ់ ?» ផះ ណោះ អាញ់ កា ម៉ន់ ឡោម ប‌៉្រ័ះ ");
INSERT INTO tpu_vpl VALUES ("NH2_5","017_2_5","NEH","2","5","5","កេះណោះ អាញ់ រ៉ះ កា សាដាច់ ផា «ផានែវ កា ត្រគ់ ពុត អីស ផា អីស តាប៉ាប តាប៉ុន កា អាញ់ តាទឹច អីស អន់ អាញ់ ឡាំ ប៉ាគ់ ខេត យូដា ឃឺ ឡាំ ប៉ាគ់ មឿង ឡាក់ ទី រ៉ូង័ ប៉ាទ្រូ វគ័ យ៉ាគ់ អាញ់ ភឿ អន់ អាញ់ ប៉្រគ័ មឿង ណោះ ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("NH2_6","017_2_6","NEH","2","6","6","ផះ ណោះ កាម៉ាញ់ អ៊ែ អ្វៃ ហះ ណោះ ដេល សាដាច់ កា អំប៉ញ់ អាញ់ ណាវ្គ ផា «ទុញ ប៉ុប ចំ អីស ចឹង អ្វៃ ប៉ាគ់ ណោះ ? ខៃ ចំ អីស ចឹង សឹត ប៉ាគ់ អា ណាវ្គ ?» អាញ់ រ៉ះ កា សាដាច់ ឡឹង ខៃ អាញ់ ចឹង សឹត ណាវ្គ ណោះ សាដាច់ កា ភម អន់ អាញ់ ឡាំ។ ");
INSERT INTO tpu_vpl VALUES ("NH2_7","017_2_7","NEH","2","7","7","កេះណោះ ណាវ្គ អាញ់ រ៉ះ កា សាដាច់ ផា «ផានែវ ត្រគ់ ពុត អីស ប៉រ់ អីស ច្រាគ់ សត់ត្រា ប៉ាហ្យើ ពឹង អាញ់ ម៉ាគ់ អាញ់ អ្យក់ ឡាំ ជឹន កា ម៉ៃគ រ៉ាំងហៃ ខេត អន់ទៀគៗ ឡាក់ អ្វៃ គែង ដារ់ ម៉ុត តាំងលេ អឺប៉្រាត ម៉ាគ់ អន់ឌែ អន់ អាញ់ ឡាំ ទឹល ប៉ាគ់ ខេត យូដា ");
INSERT INTO tpu_vpl VALUES ("NH2_8","017_2_8","NEH","2","8","8","លូ សត់ត្រា ម៉ោញ ណាវ្គ រ៉ះ កា អេសាប ឡាក់ ម៉ៃគ រ៉ាំងហៃ ព្រី កា អីស ភឿ ម៉ាគ់ អ៊ែ អន់ អ៊្លង កា អាញ់ ប៉្រគ័ អ៊្លង អ៊ប អំប៉ារ ទ្រួក ក្យាម័ ហះ រ៉ោង រ៉ាម៉ះ លូ ប៉្រគ័ ទ្រួក មឿង ទឹប ប៉្រគ័ ហី អាញ់ ចឹង អ្វៃ ដេល»។ សាដាច់ កា ច្រាគ់ សត់ត្រា ពួយ សារ អាញ់ ប៉រ់ ខង ប‌៉្រ័ះ អាញ់ ដាគ់ ពុត កា អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("NH2_9","017_2_9","NEH","2","9","9","សាដាច់ កា ប៉្រើ ម៉ៃគ តាហាន លូ តាហាន ជិះ សេះ ឡាំ ជឹន អាញ់ ដេល។ អាញ់ កា ឡាំ ប៉ាគ់ ចារ មួត ម៉ៃគ រ៉ាំងហៃ ខេត ឡាក់ អ្វៃ គែង ដារ់ ម៉ុត តាំងលេ អឺប៉្រាត អន់ សត់ត្រា ប៉ានឹរ សាដាច់ កា អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("NH2_10","017_2_10","NEH","2","10","10","ប៉ាគ់ វគ័ សាន់បាឡាត់ ឡឹង តេះ ហូរ៉ូនែម លូ វគ័ ថូប៊ីយ៉ា ឡាក់ សុនសាត អាម៉ូន ឡាក់ ប៉្រគ័ កាន តីស អន់ឌែ អ្លុ សារ ណោះ អន់ឌែ អូ រ៉គ់ ពុត អុះ ខង ប៉ប័ អាញ់ ចឹង ប៉្រគ័ អន់ ទី ខា សាំរ៉ាប់ កា សុនសាត អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("NH2_11","017_2_11","NEH","2","11","11","អាញ់ កា ឡាំ ទឹល ប៉ាគ់ មឿង យេរូសាឡឹម អាញ់ អ្វៃ ហះ ណោះ ប៉ៃង ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("NH2_12","017_2_12","NEH","2","12","12","កេះណោះ អាញ់ អ្យូវ ឡឹង កាម៉ាំង លូ ប៉ាណាំ ពៀរ ប៉ៃង ដូវ ណាវ្គ ឡាំ អន់ឌូ ដេល ហះកា អាញ់ អូ ទី រ៉ះ កា ពឿ អន់ អ្លុ អុះ ឡឹង សារ ប‌៉្រ័ះ អាញ់ ប៉្រគ័ អន់ ពុត អាញ់ ប៉ិច ប៉ាយ៉ាម័ ទ្រួក មឿង យេរូសាឡឹម ណោះ។ ទី ដឹង លៀ អាញ់ ជិះ អូ ទី កាណាគ័ ញ៉ា អន់ទៀគ ណាវ្គ អុះ អ្វៃ អន់ឌូ លូ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("NH2_13","017_2_13","NEH","2","13","13","ម៉ាំង ណោះ អាញ់ ចាក ឡាច់ ឡឹង មឿង ទ្រង អំប៉ារ ក្លូះ ប៉ានឹម បង់ ឡាំ ប៉ាគ់ អន់ដូង័ ណាក លូ ប៉ាគ់ អំប៉ារ ចារ ពូ អ្លាត អំហ្មូវ។ អាញ់ ហៃ ទ្រួក មឿង យេរូសាឡឹម ហះ ចារ ប៉ាក់ រ៉ាយ រ៉ាំ ទឹប អំប៉ារ មឿង ឡាក់ អុញ សា ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NH2_14","017_2_14","NEH","2","14","14","អាញ់ ឡាំ ក្យាម័ ចឹង ទឹល អំប៉ារ ហះ កល់ ទៀក លូ ស្រះ សាដាច់ ហះកា អូ ទី ទ្រង អន់ លៀ ឡាក់ អាញ់ ជិះ ណោះ ចាក ឡាំ ប៉ាគ់ ង៉ីរ ណាវ្គ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("NH2_15","017_2_15","NEH","2","15","15","ទឹល នីណោ័ះ អាញ់ កា ហាវ ទ្រង តាចាង័ ទឹប កាម៉ាំង ភឿ ឡាំ ហៃ ទ្រួក មឿង កេះណោះ អាញ់ សឹត ម៉ុត ទ្រង អំប៉ារ ក្លូះ ប៉ានឹម ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("NH2_16","017_2_16","NEH","2","16","16","កាប៉ាច់ មួត ក្រាគ់ រ៉ាំងហៃ មឿង អូ អ្លុ អន់តគ់ កា អាញ់ ឡាំ ប៉ាគ់ ចំ លើ ប៉្រគ័ ញ៉ា អុះ ផះ ណោះ អាញ់ បើ រ៉ះ កា ប៉ាសុន យូដា មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ  មួត ផូង័ វ៉ាច់ បក់ ប៉្រគ័ កាន តីស មួត ក្រាគ់ រ៉ាំងហៃ លើ មួត ឡាក់ ចឹង ត្រគ់ ប៉្រគ័ ង៉ារ ប៉ាយ៉ាម័ ទ្រួក អន់ អ្លុ ឡឹង ង៉ារ អាញ់ ឃឹត ប៉្រគ័ ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("NH2_17","017_2_17","NEH","2","17","17","កេះណោះ អាញ់ កាប លូ អន់ឌែ ផា «អន់ដីស អ្លុ កេះ ពិន ទី សារ ថុក ប៉ាណាប ប៉ុប ចំ មឿង យេរូសាឡឹម អា អ្វៃ កា រ៉ាយ រ៉ាំ អំប៉ារ ទ្រួក មឿង កា អុញ សា ទិ ដេល។ ទឹល នីណោ័ះ ពិ ពិន ប៉ាណាំ គួប ប៉្រគ័ ទ្រួក មឿង យេរូសាឡឹម ណាវ្គ ម៉ាគ់ ដាគ់ ពិន អូ តាយួស ណាវ្គ»។ ");
INSERT INTO tpu_vpl VALUES ("NH2_18","017_2_18","NEH","2","18","18","កេះណោះ អាញ់ រ៉ះ អន់ អន់ឌែ អ្លុ អន់តគ់ ឡឹង សារ ប‌៉្រ័ះ អាញ់ ដាគ់ ពុត កា អាញ់ លូ សារ សាដាច់ កាប លូ អាញ់ នីចម័ អន់ដា។ អន់ឌែ កា កាប ផា «ពិ ពិន ប៉ាណាំ គួប ប៉្រគ័»។ ទឹល នីណោ័ះ អន់ឌែ កា ទី ពុត ប៉ិច ប៉្រគ័ ង៉ារ ឡាក់ ដាគ់ កាខាក់ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("NH2_19","017_2_19","NEH","2","19","19","កាប៉ាច់ វគ័ សាន់បាឡាត់ វគ័ ថូប៊ីយ៉ា លូ វគ័ កេស៊ែម ឡាក់ សុនសាត អារ៉ាប់ ផះ អន់ឌែ កាតាំង សារ ណោះ អន់ឌែ កាកីក ប៉ាឡៃវ លូ បឺង៉ាយ ញឹន អន់ឌែ កាប ផា «អន់ដីស ប៉ិច ប៉្រគ័ ញ៉ា ណោះ ? ញ៉ា អន់ដីស ប៉ិច ប៉ាសាំង លូ សាដាច់ ប ?» ");
INSERT INTO tpu_vpl VALUES ("NH2_20","017_2_20","NEH","2","20","20","អាញ់ តើល អន់ឌែ ផា «ប‌៉្រ័ះ ពឹង ប៉្លៃង ចាបះ កា ចឹង អន់ ញឹន ប៉្រគ័ កើត។ ញឹន ឡាក់ ទុច ប‌៉្រ័ះ ញឹន ចឹង ប៉្រគ័ មឿង អា។ កាប៉ាច់ អន់ដីស អូ ទី ចានែក លូ អូ ទី ចាបាប់ ញ៉ា ពឹង មឿង យេរូសាឡឹម អន់ដីស កា អូ ខឹន ម៉ុត សង់ខុំ ញឹន ដេល»។ … ");
INSERT INTO tpu_vpl VALUES ("NH4_1","017_4_1","NEH","4","1","1","ប៉ាគ់ វគ័ សាន់បាឡាត់ កាតាំង ពូ រ៉ះ ផា ញឹន ប៉្រគ័ ទ្រួក មឿង ណាវ្គ អ៊ែ អឺក កាខាក់ អ៊ែ កាប ប៉ាឡៃវ កា សុនសាត អ៊ីស្រាអ៊ែល ");
INSERT INTO tpu_vpl VALUES ("NH4_2","017_4_2","NEH","4","2","2","ទឹប កាប ហះ ម៉ាត់ គួប អ៊ែ លូ មួត តាហាន មឿង សាម៉ារី ផា «មួត យូដា អូ កាឡោះ អា អន់ឌែ ប៉ាណាំ គួប ប៉្រគ័ ញ៉ា ? អន់ឌែ ឃឹត ចឹង ប៉ាយ៉ាម័ ទ្រួក ដឹង អន់ឌែ ប ? ញ៉ា អន់ឌែ ចឹង រ៉ាម៉ះ ប‌៉្រ័ះ អន់ឌែ ដេល ប ? ញ៉ា អន់ឌែ ចឹង ប៉្រគ័ តាគ់ អង់កេះ កាណុង ម៉ោញ ដារ់ ឡូត ប ? ញ៉ា អន់ឌែ ចឹង ប៉្រគ័ អន់ អំហ្មោ ទិណោ័ះ ឡាច់ ឡឹង ប៉ានូក អំហ្មោ ឡាក់ អុញ សា ទិ កេះណោះ អ្យក់ តគ័ អំប៉ាំង គួប អ៊ែ ណាវ្គ អ្លុ ដេល ប ?» ");
INSERT INTO tpu_vpl VALUES ("NH4_3","017_4_3","NEH","4","3","3","វគ័ ថូប៊ីយ៉ា សុនសាត អាម៉ូន ឡាក់ អ្វៃ ហះ ណោះ ដេល កា កាប ផា «ហៃ ទ្រួក អន់ឌែ ប៉្រគ័ ណោះ ផា ទី សូ ព្រី ដឹង ម៉ោញ ហាវ អំប៉ាំង ទ្រួក ណោះ កា ប៉ាក់ ឡូត !» ");
INSERT INTO tpu_vpl VALUES ("NH4_4","017_4_4","NEH","4","4","4","អឺ ប‌៉្រ័ះ ញឹន ហគ់ សាំយ៉ាំង ពិ អន់ឌែ បឺង៉ាយ ញឹន ខាក់។ ប៉រ់ អីស ប៉្រគ័ អន់ អន់ឌែ ទៅ កើត តាយួស ពិ អន់ តាម៉ឺរ រ៉ុប អ្យក់ រ៉ាស អំប៉ាស អន់ឌែ លូ អ្យក់ អន់ឌែ ប៉្រគ័ ទុច។ ");
INSERT INTO tpu_vpl VALUES ("NH4_5","017_4_5","NEH","4","5","5","អីស ជែ អ្លាត ដោះ កា សារ អន់ឌែ ប៉្រគ័ អូ ដាគ់ ណោះ លូ ជែ តាគ់ អង់ហ៊្យង សារ យច ម៉ះ អន់ឌែ ឡឹង ម៉ាត់ អីស ដេល ខង អន់ឌែ ត័ះ ផាម៉ាត កា ញឹន ឡាក់ ប៉្រគ័ ទ្រួក មឿង អា ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("NH4_6","017_4_6","NEH","4","6","6","ញឹន ប៉ាណាំ គួប ប៉្រគ័ ទ្រួក មឿង ទឹល ជុំ លូ ចាំងហីគ គឹត ទងតិគ័ ខង ប៉ាសុន ខំ ប៉្រគ័ ង៉ារ អា ទិ ពុត ទិ ពៀក។ ");
INSERT INTO tpu_vpl VALUES ("NH4_7","017_4_7","NEH","4","7","7","កាប៉ាច់ វគ័ សាន់បាឡាត់ វគ័ ថូប៊ីយ៉ា ទឹប សុនសាត អារ៉ាប់ សុនសាត អាម៉ូន លូ មួត ខេត អាសាដូត ផះ អន់ឌែ កាតាំង ពូ រ៉ះ ផា ង៉ារ ប៉្រគ័ ប៉ាយ៉ាម័ ទ្រួក មឿង យេរូសាឡឹម ដាគ់ អូ ទី សារ ញ៉ា អុះ ចារ ប៉ាក់ រ៉ាយ រ៉ាំ កា តគ័ អំហ្មោ ប៉ឹត ប៉ាសឹរ ណាវ្គ កេះ អន់ឌែ ប៉ិច អឺក កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("NH4_8","017_4_8","NEH","4","8","8","អន់ឌែ កា ប៉ាតុំ តាហាន ចឹង ឡាំ ប៉ាំងអ្យូគ មួត មឿង យេរូសាឡឹម ភឿ ប៉្រគ័ អន់ ញឹន អ្លាត អូ ជៀ ប៉្រគ័។ ");
INSERT INTO tpu_vpl VALUES ("NH4_9","017_4_9","NEH","4","9","9","ផះ ណោះ ញឹន កា ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ កេះណោះ ប៉្រើ កាំឡាំង ញឹន អន់ដា ញ៉ាម លូ ប៉ាទ្រុយ ទឹប កាម៉ាំង ទឹប កាដារ់ ភឿ ប៉ងកាន់ មឿង អ្យូគ ផៃគ ពូ ឡាំ តាកូះ។ ");
INSERT INTO tpu_vpl VALUES ("NH4_10","017_4_10","NEH","4","10","10","កាប៉ាច់ មួត យូដា អន់ឌែ កាប ផា «មួត បក់ គយ មួត បក់ តូង័ អន់ឌែ ហ៊ែង អូ សាងុំ កេះ ប៉ានូក អំហ្មោ ឡាក់ ប៉ាក់ រ៉ាយ រ៉ាំ ណោះ កា អៀង តាឡាម័ ពិន អូ ដាម័ ប៉្រគ័ ទ្រួក មឿង អន់ កេះ អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("NH4_11","017_4_11","NEH","4","11","11","ម៉ោញ ណាវ្គ មួត តាម៉ឺរ ញឹន អន់ឌែ កាប ផា «មួត ណោះ អូ អ្លុ អន់តគ់ លូ អូ ប៉ប័ សារ ញ៉ា អុះ ពិន ចឹង មច ម៉ុត ឡាំ ទឹល ប៉ាគ់ អន់តិគ័ កាំឡាំង អន់ឌែ កេះណោះ ប៉ាន់តោ័ អន់ឌែ ម៉ាគ់ អន់ឌែ ចឹង អូ ប៉្រគ័ ង៉ារ អន់ឌែ ណោះ»។ ");
INSERT INTO tpu_vpl VALUES ("NH4_12","017_4_12","NEH","4","12","12","មួត សុនសាត អ៊ីស្រាអ៊ែល បក់ អ្វៃ ក្យាម័ ចារ មួត តាម៉ឺរ ណោះ អន់ឌែ ប៉ាណាំ គួប ឡាំ រ៉ះ កា ញឹន ទឹល អញ់ជឹត ទង ផា «តាម៉ឺរ ប៉ាណាំ គួប គ្រឹប ចារ ចឹង ឡាំ តាកូះ ប៉ាន់តោ័ ពិន»។ ");
INSERT INTO tpu_vpl VALUES ("NH4_13","017_4_13","NEH","4","13","13","ទឹល នីណោ័ះ អាញ់ កា ប៉្រើ ប៉ាសុន ឡាំ តាម ផូង័ ញ៉ាម គែង កាណុង ទ្រួក ប៉ាគ់ ចារ ទ្រួក កាតេ័ះ លូ ប៉ាគ់ តាវ៉ាង័ ទ្រួក បើ កេះ ដេល ទឹប ចឹក ដាវ ចឹក តាប៉ាក័ ចឹក ស្រាគ់។ ");
INSERT INTO tpu_vpl VALUES ("NH4_14","017_4_14","NEH","4","14","14","ប៉ាគ់ អាញ់ ចាក ហៃ គ្រឹប ចារ កេះ អាញ់ កា រ៉ះ កា មួត បក់ ប៉្រគ័ កាន តីស មួត ក្រាគ់ រ៉ាំងហៃ មឿង លូ មួត ប៉ាសុន ទិណោ័ះ ផា «ជែ អ្យូគ ហង កា អន់ឌែ ណោះ។ ហគ់ កាចាំង កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ តីស ទឹប ត្រគ់ អ្យូគ។ ទឹល នីណោ័ះ ហគ់ ប៉ាណាំ គួប ប៉ងកាន់ អុះ ម៉ី គន កាម៉ាញ់ លូ ហី ក្រាន អន់ដីស ពិ»។ ");
INSERT INTO tpu_vpl VALUES ("NH4_15","017_4_15","NEH","4","15","15","មួត តាម៉ឺរ កាតាំង ពូ រ៉ះ ផា ញឹន អ្លុ អន់តគ់ ឡឹង សារ អន់ឌែ ឃឹត ចឹង ប៉្រគ័ កា ញឹន ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ កា តាគ់ អង់រ៉ាយ សារ អន់ឌែ ឃឹត ណោះ ញឹន កា សឹត ប៉្រគ័ ទ្រួក មឿង ចារ ពឿ ចារ អ៊ែ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("NH4_16","017_4_16","NEH","4","16","16","សាគ់ ឡឹង ដារ់ ណោះ គួប ញឹន ទងតិគ័ ប៉្រគ័ ង៉ារ ទងតិគ័ ចឹក តាប៉ាក័ ចឹក ខៃល ចឹក ស្រាគ់ លូ ពៀត អាវ ប៉ាសយ់។ មួត ម៉ៃគ ណាំផា តង័ រ៉ាំងហៃ មួត យូដា ទិឌូ ");
INSERT INTO tpu_vpl VALUES ("NH4_17","017_4_17","NEH","4","17","17","បក់ ប៉្រគ័ ទ្រួក។ ទិ បក់ តូង័ បក់ គយ តី ម៉ោញ ប៊ែង ប៉្រគ័ ង៉ារ តី ម៉ោញ ប៊ែង ចឹក កាណាគ័ តាកូះ។ ");
INSERT INTO tpu_vpl VALUES ("NH4_18","017_4_18","NEH","4","18","18","កាប៉ាច់ បក់ តគ័ អំហ្មោ អន់ឌែ ចោ ដាវ ពឹង សាំងគៀង ប៉្រគ័ ង៉ារ ទឹប ណោះ ហង។ កាប៉ាច់ បក់ ខ្លោម សាណៃង កា អន់តាវ អ្វៃ ក្យាម័ ចារ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("NH4_19","017_4_19","NEH","4","19","19","អាញ់ រ៉ះ កា មួត បក់ ប៉្រគ័ កាន តីស មួត ក្រាគ់ រ៉ាំងហៃ មឿង លូ ប៉ាសុន ទិឌូ ផា «ង៉ារ ពិន អ្វៃ អៀង ខាក់ ខង ទ្រួក អា អ្លឹង ពិន កា អ្វៃ ចាំងហាយ្គ ឡឹង គួប សោប ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NH4_20","017_4_20","NEH","4","20","20","ទឹល នីណោ័ះ ផា អន់ដីស កាតាំង សាណៃង ប៉ាគ់ ចារ ចំ អ្យគ័ អន់ដីស ឡាំ ប៉ាតុំ គួប ប៉ាគ់ ចារ ណោះ ពិ។ ប‌៉្រ័ះ ពិន ចឹង តាកូះ តាង ពិន ហង»។ ");
INSERT INTO tpu_vpl VALUES ("NH4_21","017_4_21","NEH","4","21","21","ញឹន ប៉្រគ័ ង៉ារ ឃឺ នែវ អា កាំឡាំង ញឹន ទងតិគ័ ចឹក តាប៉ាក័ ឡឹង កាំលឺ ទឹល កាម៉ាំង។ ");
INSERT INTO tpu_vpl VALUES ("NH4_22","017_4_22","NEH","4","22","22","ផះ ណោះ អាញ់ រ៉ះ លូ មួត ប៉ាសុន ណាវ្គ ផា «ប៉ាគ់ កាម៉ាំង អន់ដីស លូ គួប អន់ដីស ត្រគ់ តៃប កាណុង មឿង យេរូសាឡឹម ម៉ាគ់ ប៉ងកាន់ គួប សោប កាម៉ាំង កាដារ់ ប៉្រគ័ ង៉ារ»។ ");
INSERT INTO tpu_vpl VALUES ("NH4_23","017_4_23","NEH","4","23","23","ទឹល នីណោ័ះ អាញ់ លូ អុះ ម៉ី អាញ់ ទឹប ទុច អាញ់ លូ តាហាន ឡាក់ ចាក ពួយ អាញ់ ផះ កាម៉ាំង អូ ទី ពឿ រ៉ីស ឡាច់ ខោ អាវ ឡឹង ឡាកោ អុះ ញឹន កា ចឹក កាណាគ័ តាកូះ ពឹង ឡាកោ លើយ ដេល។ … ");
INSERT INTO tpu_vpl VALUES ("NH6_15","017_6_15","NEH","6","15","15","ទិ ៥២ ដារ់ ញឹន ប៉្រគ័ ទ្រួក មឿង កេះ ទិណោ័ះ ពឹង ដារ់ ទី ២៥ ខៃ ៦។ ");
INSERT INTO tpu_vpl VALUES ("NH6_16","017_6_16","NEH","6","16","16","ប៉ាគ់ មួត តាម៉ឺរ ឡាក់ អ្វៃ ជុំ ញឹន ទិណោ័ះ កាតាំង សារ ណោះ អន់ឌែ កា អ្យូគ ខាក់។ អន់ឌែ តាយួស ខាក់ ខង អន់ឌែ អ្លុ អន់តគ់ ផា ង៉ារ ទិ អា កេះ ទិ កេះ ញន កា ប‌៉្រ័ះ ញឹន តង័។ … ");
INSERT INTO tpu_vpl VALUES ("NH8_1","017_8_1","NEH","8","1","1","ប៉ាគ់ ទឹល ខៃ ៧ សុនសាត អ៊ីស្រាអ៊ែល ឡាក់ អ្វៃ ពឹង មឿង អន់ទៀគៗ អន់ឌែ ពឹះ ប៉ាតុំ គួប ទឹប រែវ ពុត គួប សោប អន់ឌែ អ្វៃ ពឹង អន់តិគ័ ឡាន គែង ង៉ីរ អំប៉ារ មឿង ឡាក់ ពូ អន់ សិច ផា «អំប៉ារ ទៀក»។ អន់ឌែ កា ប៉្រើ វគ័ អ៊ែសារ៉ា ឡាក់ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ លូ រ៉ាគឹយ គែង ចាបាប់ ប៉្រើ អ៊ែ អ្យក់ ផាប់ ចាបាប់ វគ័ ម៉ូសេ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ កា សុនសាត អ៊ីស្រាអ៊ែល។ ");
INSERT INTO tpu_vpl VALUES ("NH8_2","017_8_2","NEH","8","2","2","វគ័ អ៊ែសារ៉ា កា អ្យក់ ចាបាប់ ប‌៉្រ័ះ ឡាំ គែង ង៉ីរ ចារ ពូ លួម ឡាក់ ទី ប៉ាសុន កាម៉ាក័ អង់កាន់ លូ សាស្វាៗ ឡាក់ ចឹង ហ្លង់ ចាបាប់ ដេល។ ដារ់ ណោះ ឡាក់ ដារ់ ទី ១ ពឹង ខៃ ៧ ទៅ។ ");
INSERT INTO tpu_vpl VALUES ("NH8_3","017_8_3","NEH","8","3","3","វគ័ អ៊ែសារ៉ា អាន ផាប់ ចាបាប់ ប‌៉្រ័ះ អា សាគ់ ឡឹង កាំលឺ ទឹល ដារ់ ប៉ង់ ប៉ាគ់ អន់តិគ័ ឡាន ហះ ង៉ីរ អំប៉ារ ទៀក អន់ កា ប៉ាសុន សាំយ៉ាំង ឃឺ ប៉ាសុន ទឹប កាម៉ាក័ ទឹប អង់កាន់ លូ សាស្វាៗ ឡាក់ ចឹង ហ្លង់ ដេល។ ប៉ាសុន ទិណោ័ះ អ្យក់ ពុត ចៃគ សាំយ៉ាំង អ៊ែ អាន ចាបាប់ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("NH8_4","017_8_4","NEH","8","4","4","វគ័ អ៊ែសារ៉ា អន់តាវ ពឹង ចារ ចាំងហីគ ឡាក់ ពូ ប៉្រគ័ លូ អ៊្លង សាំរ៉ាប់ កា ង៉ារ ណោះ ហង។ វគ័ ម៉ាធិធៀ វគ័ សេម៉ា វគ័ អាណាយ៉ា វគ័ អ៊ូរីយ៉ា វគ័ ហ៊ីលគីយ៉ា លូ វគ័ ម៉ាសេយ៉ា អន់តាវ គែង សាម៉ា អ៊ែ។ វគ័ ពេដាយ៉ា វគ័ មីសាអ៊ែល វគ័ ម៉ាល់គៀ វគ័ ហាស៊ូម វគ័ ហាសាបាដាណា វគ័ សាការី លូ វគ័ មិស៊ូឡាម អន់តាវ គែង សាំងអ្យោ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("NH8_5","017_8_5","NEH","8","5","5","ផះ វគ័ អ៊ែសារ៉ា អាន ផាប់ ប៉ានឹរ ប‌៉្រ័ះ ប៉ាសុន ប៉ប័ ទិឌូ ខង អ៊ែ អន់តាវ ពឹង ចារ ចាំងហីគ ឡឹង ពូ។ ផះ អ៊ែ បើក ផាប់ ប៉ានឹរ ប‌៉្រ័ះ ប៉ាសុន កា អ្យូវ អន់តាវ ទិឌូ។ ");
INSERT INTO tpu_vpl VALUES ("NH8_6","017_8_6","NEH","8","6","6","កេះណោះ វគ័ អ៊ែសារ៉ា ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ តីស ប៉ាសុន ទិឌូ កា លឺក តី ទឹប តើល ផា «អាមែន ! អាមែន !» កេះណោះ អន់ឌែ សាំប‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័ មូប កល់ ទឹះ តេះ។ ");
INSERT INTO tpu_vpl VALUES ("NH8_7","017_8_7","NEH","8","7","7","វគ័ យេសួ វគ័ បានី វគ័ សេរេប៊ីយ៉ា វគ័ យ៉ាមីន វគ័ អាគូប វគ័ សាបិថាយ វគ័ ហូឌៀ វគ័ ម៉ាសេយ៉ា វគ័ កេលីថា វគ័ អាសារៀ វគ័ យ៉ូសាបាត វគ័ ហាណាន លូ វគ័ ពេឡាយ៉ា ឡាក់ មួត ក្រុំ លេវី អន់ឌែ រ៉ះ ចាបាប់ ប‌៉្រ័ះ អន់ ប៉ាសុន ហ្លង់ ប៉ាសុន អ្វៃ ហះ ចារ អន់ឌែ ទៅ។ ");
INSERT INTO tpu_vpl VALUES ("NH8_8","017_8_8","NEH","8","8","8","ក្រុំ លេវី ណោះ អាន ផាប់ ចាបាប់ ប‌៉្រ័ះ ប៊កកាតយ័ ម៉ោញ ខ ៗ ទឹប រ៉ះ រ៉ាឡា សារ អន់ឌែ អាន ណោះ អន់ កា ប៉ាសុន ហ្លង់។ ");
INSERT INTO tpu_vpl VALUES ("NH8_9","017_8_9","NEH","8","9","9","ប៉ាគ់ ប៉ាសុន ទិណោ័ះ កាតាំង សារ ពឹង ចាបាប់ ប‌៉្រ័ះ អន់ឌែ កា ញ៉ាំ។ ទឹល នីណោ័ះ វគ័ នេហេមៀ ឡាក់ ម៉ៃគ រ៉ាំងហៃ មឿង លូ វគ័ អ៊ែសារ៉ា ឡាក់ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ទឹប រ៉ាគឹយ គែង ចាបាប់ ប‌៉្រ័ះ លូ ក្រុំ លេវី ឡាក់ ប៉ាំងហៀន ចាបាប់ ប‌៉្រ័ះ អន់ឌែ កាប លូ ប៉ាសុន ទិណោ័ះ ផា «ដារ់ អា ឡាក់ ដារ់ ដាគ់ សាំរ៉ាប់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ពិន អូ ត្រគ់ ដារ់ ញ៉ាំ សោក អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("NH8_10","017_8_10","NEH","8","10","10","អ៊ែ កាប ណាវ្គ ផា «ហគ់ ប៉ាណាំ គួប សឹត សា សាអ៊្លង អៃត តាពែ ឡាក់ ប៉ាអាំៗ លូ ជែក អន់ កា បក់ អូ ទី សាណា សា ណោះ ដេល ខង ដារ់ អា ឡាក់ ដារ់ ដាគ់ សាំរ៉ាប់ កា ប‌៉្រ័ះ ពិន អូ ត្រគ់ អុក ពុត ពៀក អុះ ខង សារ ហោក រ៉គ់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ប៉្រគ័ អន់ អន់ដីស ទី ពុត ខឹន»។ ");
INSERT INTO tpu_vpl VALUES ("NH8_11","017_8_11","NEH","8","11","11","ក្រុំ លេវី កា ប៉ាឡោម ប៉ាសុន លូ កាប ផា «អន់ដីស ជែ ញ៉ាំ ហង ខង ដារ់ អា ឡាក់ ដារ់ ដាគ់ សាំរ៉ាប់ កា ប‌៉្រ័ះ អូ ត្រគ់ អុក ពុត ពៀក អុះ»។ ");
INSERT INTO tpu_vpl VALUES ("NH8_12","017_8_12","NEH","8","12","12","ទឹល នីណោ័ះ ប៉ាសុន ទិណោ័ះ កា សឹត សា សាណា លូ អៃត តាពែ លូ ជែក អន់ កា បក់ អូ ទី។ អន់ឌែ ហោក រ៉គ់ កាខាក់ ញន កា ហ្លង់ សារ ប‌៉្រ័ះ ឡាក់ ពូ រ៉ះ អន់ កា អន់ឌែ សាំយ៉ាំង។ ");
INSERT INTO tpu_vpl VALUES ("NH8_13","017_8_13","NEH","8","13","13","ប៉ាគ់ ដារ់ ទី ២ មួត ម៉ៃគ ក្រាគ់ ហី កាណុង កាំឡាំង ប៉ាសុន ទិណោ័ះ ទឹប មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ លូ ក្រុំ លេវី ប៉ាតុំ គួប អ្វៃ ជុំ វគ័ អ៊ែសារ៉ា ឡាក់ រ៉ាគឹយ គែង ចាបាប់ ប‌៉្រ័ះ ភឿ ហៀន ចាបាប់ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("NH8_14","017_8_14","NEH","8","14","14","អន់ឌែ ប៉ប័ សារ ម៉ោញ ពឹង ផាប់ ចាបាប់ ប‌៉្រ័ះ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ ពឹង វគ័ ម៉ូសេ ទី ច្រាគ់ រ៉ះ ផា ពឹង ដារ់ ប៊ុន ខៃ ទី ៧ សុនសាត អ៊ីស្រាអ៊ែល ត្រគ់ អ្វៃ កាណុង រ៉ាណើះ។ ");
INSERT INTO tpu_vpl VALUES ("NH8_15","017_8_15","NEH","8","15","15","អន់ឌែ ត្រគ់ រ៉ះ សារ អា ពឹង មឿង អន់ទៀគៗ លូ ពឹង មឿង យេរូសាឡឹម ដេល អន់ ប៉ាសុន ទិណោ័ះ អ្លុ អន់តគ់ ឃឺ អន់ឌែ រ៉ះ ផា «ហគ់ ឡាំ ប៉ាគ់ ប៉ានឹម កេះណោះ កោះ តាំងកង់ អូលេវ តាំងកង់ រ៉ាសៃ លូ តាំងកង់ អ៊្លង អន់ទៀគៗ ឡាក់ ទី ហ្លា អៀង អ្យក់ ប៉្រគ័ រ៉ាណើះ ពួយ សារ ឡាក់ ទី ច្រាគ់ រ៉ះ កាណុង ចាបាប់ ប‌៉្រ័ះ»។ ");
INSERT INTO tpu_vpl VALUES ("NH8_16","017_8_16","NEH","8","16","16","ទឹល នីណោ័ះ មួត ប៉ាសុន កា ប៉ាណាំ គួប ឡាំ កោះ តាំងកង់ អ៊្លង អ្យក់ ពឹះ ប៉្រគ័ រ៉ាណើះ ពឹង អន់តល័ ហី ពឿ ហី អ៊ែ  លូ ពឹង អន់តិគ័ ឡាន ហី ពឿ ហី អ៊ែ ទឹប ប៉្រគ័ រ៉ាណើះ ប៉ាគ់ អន់តិគ័ ឡាន រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាគ់ អន់តិគ័ ឡាន ហះ អំប៉ារ ទៀក លូ អន់តិគ័ ឡាន ហះ អំប៉ារ អេប៉្រាអ៊ីម។ ");
INSERT INTO tpu_vpl VALUES ("NH8_17","017_8_17","NEH","8","17","17","កាំឡាំង ប៉ាសុន ទិណោ័ះ ឃឺ មួត បក់ សឹត ឡឹង កេះ ទុច ពូ ពែ អន់ឌែ កា ប៉ាណាំ គួប ប៉្រគ័ រ៉ាណើះ កេះណោះ អ្វៃ កាណុង រ៉ាណើះ ណោះ ហង។ ឡឹង រ៉ាំងហាវ វគ័ យូស្វេ គន វគ័ នូន លើយ ទឹល ដារ់ ណោះ មួត សុនសាត អ៊ីស្រាអ៊ែល អូ ឃើយ ប៉្រគ័ នីណោ័ះ អុះ។ ផះ ណោះ ប៉ាសុន ទី សារ ហោក រ៉គ់ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("NH8_18","017_8_18","NEH","8","18","18","ផះ ពូ ប៉្រគ័ ប៊ុន ណោះ ឃឺ សាគ់ ឡឹង ដារ់ ប៉ាន់ដា លើយ ទឹល ដារ់ តាគ់ អង់កេះ ប៊ុន អន់ឌែ អាន ផាប់ ចាបាប់ ប‌៉្រ័ះ រ៉ប់ ដារ់។ អន់ឌែ ប៉្រគ័ ប៊ុន ណោះ តាំប៉ើះ ដារ់ ប៉ាគ់ ដារ់ ទី តាំងហាម អន់ឌែ ប៉ាតុំ គួប ណាវ្គ ត្រគ់ ពួយ ចាបាប់ ឡាក់ ច្រាគ់ រ៉ះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("NH9_1","017_9_1","NEH","9","1","1","ពឹង ដារ់ ទី ២៤ កាណុង ខៃ ណោះ ទៅ សុនសាត អ៊ីស្រាអ៊ែល ប៉ាតុំ គួប កំ អូ សា សាណា លូ អន់តុក កាប៉ោ ប៉ាច្រើយ តេះ ពឹង កល់។ ");
INSERT INTO tpu_vpl VALUES ("NH9_2","017_9_2","NEH","9","2","2","ទិ មួត ផូង័ វ៉ាច់ អ៊ីស្រាអ៊ែល ឡាច់ ឡឹង សុនសាត អន់ទៀគ ទិណោ័ះ កេះណោះ អន់ឌែ ប៉ាណាំ គួប ឡាប់ ញម សារ យច អន់ឌែ ទៅ លូ សារ យច វគ័ យ៉ាគ់ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("NH9_3","017_9_3","NEH","9","3","3","អន់ឌែ អ្យូវ អន់តាវ ហះ ចារ ពឿ ចារ អ៊ែ សាំយ៉ាំង ពូ អាន ផាប់ ចាបាប់ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ឌែ រ៉ាំងវ៉ាង ប៉ៃង មង កេះណោះ អន់ឌែ ឡាប់ ញម សារ យច លូ សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ឌែ រ៉ាំងវ៉ាង ប៉ៃង មង ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("NH9_4","017_9_4","NEH","9","4","4","ផះ ណោះ វគ័ យេសួ វគ័ បានី វគ័ កាតមៀល វគ័ សេបានៀ វគ័ ប៊ូនី វគ័ សេរេប៊ីយ៉ា វគ័ បានី លូ វគ័ កេណានី ឡាក់ ក្រុំ លេវី កា ប៉ាណាំ គួប ហាវ ពឹង ចារ ចាំងហីគ ប៊ែត គែង ង៉ីរ កាំឡាំង កេះណោះ អន់ឌែ កាប ម៉ៃៗ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("NH9_5","017_9_5","NEH","9","5","5","កេះណោះ ក្រុំ លេវី វគ័ យេសួ វគ័ កាតមៀល វគ័ បានី វគ័ ហាសាបនៀ វគ័ សេរេប៊ីយ៉ា វគ័ ហូឌៀ វគ័ សេបានៀ លូ វគ័ ពេថាហ៊ីយ៉ា កាប ផា «ពិ អ្យូវ អន់តាវ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ដីស ឡាក់ អ្វៃ ឡឹង សាគ់ ប៉ាន់ដា កាខាក់ ទឹល ប៉ាគ់ ម៉ាត់ ទៀ លើយ»។ អន់ឌែ កា ម៉ន់ ផា «អឺ ប‌៉្រ័ះ ញឹន ប៉រ់ ប៉ានេ អីស ឡាក់ ប‌៉្រ័ះ ដាគ់ ហ៊្លត ឡឹង កាណាគ័ ញ៉ាៗ ទិណោ័ះ ឡាក់ ពូ ឃើយ ប៉ានេ។ ");
INSERT INTO tpu_vpl VALUES ("NH9_6","017_9_6","NEH","9","6","6","អឺ ប‌៉្រ័ះ ប៊កកាតយ័  ទី ដឹង អីស ឡាក់ ប‌៉្រ័ះ តាទឹច អីស ប៉ាំងកើត ប៉្លៃង ឡាក់ ចាំងហីគ កាខាក់ លូ កាណាគ័ ញ៉ាៗ ទិណោ័ះ ឡាក់ អ្វៃ ពឹង ប៉្លៃង អីស កា ប៉ាំងកើត តេះ លូ កាណាគ័ ញ៉ាៗ ទិណោ័ះ ពឹង តេះ ទៀក សាឡីគ សាឡាយ លូ កាណាគ័ ញ៉ាៗ អ្វៃ កាណុង ទៀក សាឡីគ សាឡាយ។ អីស កា អន់ អាញុ រ៉ីស កា កាណាគ័ ទិណោ័ះ កាណាគ័ ញ៉ាៗ ឡាក់ អ្វៃ ពឹង ប៉្លៃង ទិណោ័ះ ប៉ាណាំ គួប សាំប‌៉័ះ អីស។ ");
INSERT INTO tpu_vpl VALUES ("NH9_7","017_9_7","NEH","9","7","7","អឺ ប‌៉្រ័ះ ប៊កកាតយ័  អីស ហង ឡាក់ រ៉ើស វគ័ អាប់រ៉ាម លូ ប៉ាណាំ អ៊ែ ឡាច់ ឡឹង មឿង អ៊ុរ ពឹង ប៉ាថេត បាប៊ីឡូន កេះណោះ អីស អន់ សិច អ៊ែ ផា អាប៉្រាហាំ។ ");
INSERT INTO tpu_vpl VALUES ("NH9_8","017_9_8","NEH","9","8","8","អីស ប៉ប័ ផា វគ័ អាប៉្រាហាំ ទី ពុត ដាគ់ ត្រង់ កា អីស កេះណោះ សាញ៉ា លូ អ៊ែ ផា ចឹង អន់ ព្រី ទៀក សុនសាត កាណាន សុនសាត ហេត សុនសាត អាម៉ូរី សុនសាត ពែរិស៊ីត សុនសាត យេប៊ូស លូ សុនសាត គើកាស៊ី អន់ កា ផូង័ វ៉ាច់ អ៊ែ។ អីស កា ប៉្រគ័ ពួយ សារ អីស សាញ៉ា ណោះ ខង អីស ដាគ់ ត្រង់ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("NH9_9","017_9_9","NEH","9","9","9","«អីស ហៃ ប៉ប័ សារ វគ័ យ៉ាគ់ ញឹន ថុក ប៉ាណាប ប៉ាគ់ ប៉ាថេត អ៊ីស៊ីប ពែ អីស កាតាំង ប៉ានឹរ អន់ឌែ អង់ហ្យាំង អើ អីស ហះ ហាង តាំងលេ តីស ស៊ូប។ ");
INSERT INTO tpu_vpl VALUES ("NH9_10","017_9_10","NEH","9","10","10","អីស កា តាំបាង សារ អំរ៉ាញ អឺញ ប៉ាសាំង លូ សាដាច់ អ៊ីស៊ីប ទឹប មួត ប៉្រគ័ កាន កា សាដាច់ លូ ប៉ាសុន ពឹង ប៉ាថេត អ៊ីស៊ីប ទិណោ័ះ ខង អីស អ្លុ អន់តគ់ ផា អន់ឌែ ទី ពុត ខូយ តាកេះ ប៉្រគ័ បាប វគ័ យ៉ាគ់ ញឹន នីចម័ អន់ដា។ អីស ប៉្រគ័ អន់ សិច អីស លៅ លែង ទឹល រ៉ប់ ដារ់ អា។ ");
INSERT INTO tpu_vpl VALUES ("NH9_11","017_9_11","NEH","9","11","11","អីស ប៉្រគ័ អន់ ទៀក តាំងលេ ក្លះ ឡាច់ ឡឹង គួប អ៊ែ ហះ ម៉ាត់ វគ័ យ៉ាគ់ ញឹន អន់ឌែ កា ចាក ទ្រង ឡាអារ ទៀក ស្វាត់ ណោះ ហង ហះកា អីស ប៉ាឡិ ទិ បក់ តាយ៉ិប ពួយ អន់ឌែ ពឹង ទៀក ជ្រុ ឡាក់ កា ពូ ប៉ាឡិ អំហ្មោ ពឹង ទៀក ថាំង។ ");
INSERT INTO tpu_vpl VALUES ("NH9_12","017_9_12","NEH","9","12","12","កាដារ់ អីស ប៉ាណាំ អន់ឌែ លូ កាម៉ល់ ប៉ាគ់ កាម៉ាំង អីស តាគ់ តាតារ ទ្រង អន់ឌែ ចាក លូ អុញ។ ");
INSERT INTO tpu_vpl VALUES ("NH9_13","017_9_13","NEH","9","13","13","អីស ជឹរ ពឹង ប៉ានឹម ស៊ីណាយ កាប លូ អន់ឌែ ឡឹង ប៉្លៃង ទឹប អន់ ចាបាប់ ឡាក់ ដាគ់ ត្រង់ ចាបាប់ ឡាក់ តាទឹច លូ សារ អីស ប៉្រើ អន់ទៀគៗ ណាវ្គ អន់ កា អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("NH9_14","017_9_14","NEH","9","14","14","អីស អន់តគ់ ប៉ាតោ អន់ឌែ ឡឹង សារ ដារ់ រ៉ាឡូវ ឡាក់ ដារ់ ដាគ់ សាំរ៉ាប់ កា អីស ទឹប អន់ ចាបាប់ លូ សារ អីស ប៉្រើ អន់ទៀគ ណាវ្គ ពឹង វគ័ ម៉ូសេ ឡាក់ ទុច អីស។ ");
INSERT INTO tpu_vpl VALUES ("NH9_15","017_9_15","NEH","9","15","15","ផះ អន់ឌែ ឡាយ៉ិត អីស អន់ សាណា ឡឹង ប៉្លៃង។ ផះ អន់ឌែ ហ៊្រែង ទៀក អីស ប៉្រគ័ អន់ ទៀក ហូរ័ ឡាច់ ឡឹង អំហ្មោ។ អីស ប៉្រើ អន់ឌែ ម៉ុត អ្យក់ ព្រី ទៀក ឡាក់ អីស ម៉ត់ ផា ចឹង អន់ កា អន់ឌែ ពែ។ ");
INSERT INTO tpu_vpl VALUES ("NH9_16","017_9_16","NEH","9","16","16","«ហះកា វគ័ យ៉ាគ់ ញឹន អន់ឌែ តីស ពុត កាង័ កល់ អូ សាំយ៉ាំង ប៉ានឹរ អីស ប៉្រើ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("NH9_17","017_9_17","NEH","9","17","17","អន់ឌែ អូ ចៃ សាំយ៉ាំង ប៉ានឹរ អីស ប៉្រើ អុះ លូ ពឹល ទិ សារ អំរ៉ាញ អឺញ ឡាក់ អីស ប៉្រគ័ ភឿ តង័ អន់ឌែ។ អន់ឌែ កាង័ កល់ លូ ប៉្រើ ប៉ាណូស ម៉ោញ ដូវ ប៉្រគ័ ម៉ៃគ ណាំផា ភឿ ប៉ាណាំ អន់ឌែ សឹត ប៉ាគ់ ចារ អន់ឌែ ប៉្រគ័ ទុច ពឹង ប៉ាថេត អ៊ីស៊ីប ណាវ្គ។ ហះកា អីស ឡាក់ ប‌៉្រ័ះ អូ អ្យក់ យ៉ូ សារ យច ទី ពុត តាប៉ាប តាប៉ុន លូ ទី ពុត ប៉ិច ចៃ អីស ទី ពុត អត់ សាំរ៉ាញ័ អីស អូ អ្លាត អន់ឌែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("NH9_18","017_9_18","NEH","9","18","18","យ‌៉័ះ អន់ឌែ ប៉្រគ័ ហ៊ូប គន រ៉ក់ ម៉ោញ ទឹប កាប ផា \"អា ហង ប‌៉្រ័ះ ពិន ឡាក់ ប៉ាណាំ ពិន ឡាច់ ឡឹង ប៉ាថេត អ៊ីស៊ីប\" យ‌៉័ះ អន់ឌែ បឺង៉ាយ អីស កាខាក់ នីចម័ កាតាម ");
INSERT INTO tpu_vpl VALUES ("NH9_19","017_9_19","NEH","9","19","19","កា អីស អូ អ្លាត អន់ឌែ ពឹង ស៊្រែ តីស អុះ ខង អីស ទី ពុត តាប៉ាប តាប៉ុន កា អន់ឌែ កាខាក់។ ផះ កាដារ់ អីស អ្វៃ កា ប៉ាណាំ អន់ឌែ លូ កាម៉ល់ អូ អ្លាត អុះ ប៉ាគ់ កាម៉ាំង អីស តាគ់ តាតារ ទ្រង អន់ឌែ ចាក លូ អុញ។ ");
INSERT INTO tpu_vpl VALUES ("NH9_20","017_9_20","NEH","9","20","20","អីស អន់ ប៉ាង៉ាត័ ប៉ាលឹង អីស ឡាក់ ដាគ់ កា អន់ឌែ ភឿ អន់តគ់ ប៉ាតោ អន់ឌែ អីស កា អន់ ណុំ ម៉ាណា កា អន់ឌែ សា លូ អន់ ទៀក កា អន់ឌែ អៃត អូ លន អុះ។ ");
INSERT INTO tpu_vpl VALUES ("NH9_21","017_9_21","NEH","9","21","21","រ៉ាំងវ៉ាង ៤០ សាណាំ អីស រង អន់ឌែ ពឹង ស៊្រែ តីស អន់ កាណាគ័ ញ៉ា ឡាក់ អន់ឌែ តងកាន អន់ឌែ អូ អឹត កា ញ៉ា អុះ ខោ អាវ អន់ឌែ កាស៊ប ពៀត កា អូ ស្យាត ជុង អន់ឌែ កា អូ ឡា អូ ប៉ុក ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NH9_22","017_9_22","NEH","9","22","22","«អន់តីគ ឡឹង ណោះ អីស មប ប៉ាថេត លូ សុនសាត អន់ទៀគៗ ឡាក់ អ្វៃ រក្យាម័ អន់ កា អន់ឌែ។ អន់ឌែ កា តាប៉ីត អ្យក់ ព្រី ទៀក សាដាច់ ស៊ីហុន ឡាក់ សាដាច់ មឿង ហេសាបូន លូ ព្រី ទៀក សាដាច់ អុក ឡាក់ សាដាច់ ប៉ាថេត បាសាន។ ");
INSERT INTO tpu_vpl VALUES ("NH9_23","017_9_23","NEH","9","23","23","អីស កា ប៉្រគ័ អន់ អន់ឌែ ទី គន សោ អៀង ឡាក់ កា សំឡង់ ពឹង ប៉្លៃង កេះណោះ អីស ប៉ាណាំ អន់ឌែ ឡាំ រ៉ុប អ្យក់ ព្រី ទៀក ឡាក់ អីស សាញ៉ា លូ វគ័ យ៉ាគ់ អន់ឌែ ផា ចឹង អន់ កា អន់ឌែ អ្វៃ។ ");
INSERT INTO tpu_vpl VALUES ("NH9_24","017_9_24","NEH","9","24","24","អន់ឌែ ឡាក់ គន សោ មួត ណោះ កា ម៉ុត រ៉ុប អ្យក់ ព្រី ទៀក អីស កា ប៉ាំងអ្យូគ សុនសាត កាណាន ឡាក់ អ្វៃ ពឹង ប៉ាថេត ណោះ ហះ ម៉ាត់ អន់ឌែ អីស មប សុនសាត ណោះ ទឹប សាដាច់ ទឹប ប៉ាសុន ពឹង តី អន់ឌែ ភឿ អន់ កា អន់ឌែ ប៉្រគ័ តាម ពុត។ ");
INSERT INTO tpu_vpl VALUES ("NH9_25","017_9_25","NEH","9","25","25","អន់ឌែ តាប៉ីត អ្យក់ មឿង ឡាក់ ទី ទ្រួក ដាគ់ កាចាប័ លូ ព្រី ទៀក ឡាក់ ដាគ់ សាណា។ អន់ឌែ រ៉ុប អ្យក់ ហី អៀង ឡាក់ ទី រ៉ាស អំប៉ាស ប៉ាដក់ ប៉ាជៀ គ្រឹប នែវ ទី ទឹប ឡូះ សាំរ៉ាប់ គម ទៀក ម៉ីរ តើម អង់កាច ម៉ីរ តើម អូលេវ លូ តើម អ៊្លង សា ប៉្លៃ គ្រឹប នែវ អៀង កាខាក់។ អន់ឌែ សា ផីគ តីស តង់ ទី ឡាកោ ទី ប៉ាំងឡៃ អ្វៃ រ៉គ់ សើម ញន កា អីស ដាគ់ ពុត ខាក់ កា អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("NH9_26","017_9_26","NEH","9","26","26","«ហះកា អន់ឌែ ប៉ាណាំ គួប ប៉ាសាំង លូ អីស អន់ឌែ អ្លាត ចាបាប់ អីស លូ ប៉ាន់តោ័ មួត រ៉ាគឹយ ប‌៉្រ័ះ ឡាក់ អន់តគ់ រ៉ះ កា អន់ឌែ ប៉្រើ ប៉ិនពែង ពុត វ៉ីល ប៉ាគ់ អីស ណាវ្គ អន់ឌែ ប៉ាណាំ គួប បឺង៉ាយ អីស កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("NH9_27","017_9_27","NEH","9","27","27","ញន ណោះ ហង បះ អីស មប អន់ឌែ ពឹង តី មួត តាម៉ឺរ មួត តាម៉ឺរ កា ជិះ ចគ័ ប៉្រគ័ បាប អន់ឌែ។ ប៉ាគ់ អន់ឌែ ទី សារ ប៉ាណាប ប៉ាបប៉ុន អន់ឌែ កា ម៉ន់ ឡោម អើ អីស អីស កា សាំយ៉ាំង អន់ឌែ ឡឹង ប៉្លៃង អីស តាប៉ាប កាខាក់ អីស កា ប៉្រគ័ អន់ ទី បក់ តង័ ឡាំ តង័ អន់ឌែ អន់ រ៉ាវ៉ាច់ ឡឹង តី មួត តាម៉ឺរ។ ");
INSERT INTO tpu_vpl VALUES ("NH9_28","017_9_28","NEH","9","28","28","ប៉ាគ់ អន់ឌែ អ្វៃ សាណុក សាវ៉ាក កេះ អន់ឌែ កា ប៉្រគ័ សារ អូ ដាគ់ យច ពុត អីស ណាវ្គ អីស កា អ្លាត អន់ឌែ អន់ ពឹង តី មួត តាម៉ឺរ មួត តាម៉ឺរ កា ជិះ ចគ័ ប៉្រគ័ បាប អន់ឌែ។ ផះ ណោះ អន់ឌែ ម៉ន់ ឡោម អីស ណាវ្គ អីស កា សាំយ៉ាំង អន់ឌែ ឡឹង ប៉្លៃង អីស តាប៉ាប កា អន់ឌែ ទឹប តង័ អន់ឌែ អូ អ្លុ កា ញ៉ាង ទង។ ");
INSERT INTO tpu_vpl VALUES ("NH9_29","017_9_29","NEH","9","29","29","អីស រ៉ះ កា អន់ឌែ ប៉្រើ ប៉្រគ័ ពួយ ចាបាប់ អីស ណាវ្គ ហះកា អន់ឌែ តីស ពុត អូ សាំយ៉ាំង ប៉ានឹរ អីស ប៉្រើ អុះ។ ចាបាប់ អីស អន់ អាញុ រ៉ីស កា បក់ ចំ ឡាក់ ប៉្រគ័ ពួយ ហះកា អន់ឌែ ប៉្រគ័ យច លូ ចាបាប់ អីស ទិណោ័ះ អន់ឌែ ឌឺ កាង័ កល់ អូ ចៃ សាំយ៉ាំង អុះ។ ");
INSERT INTO tpu_vpl VALUES ("NH9_30","017_9_30","NEH","9","30","30","អីស អត់ សាំរ៉ាញ័ កា អន់ឌែ ទុញ សាណាំ ប៉ាង៉ាត័ ប៉ាលឹង អីស កា ប៉្រើ មួត រ៉ាគឹយ ប‌៉្រ័ះ ឡាំ រ៉ះ កា អន់ឌែ ហះកា អន់ឌែ អូ ចៃ សាំយ៉ាំង អុះ។ ទឹល នីណោ័ះ អីស មប អន់ឌែ ពឹង តី សុនសាត ប៉ាថេត អន់ទៀគ។ ");
INSERT INTO tpu_vpl VALUES ("NH9_31","017_9_31","NEH","9","31","31","ញន កា អីស តាប៉ាប តាប៉ុន កា អន់ឌែ កាខាក់ បះ អីស អូ ថាំឡាយ អន់ឌែ លូ អូ អ្លាត អន់ឌែ អុះ ខង អីស ឡាក់ ប‌៉្រ័ះ ដាគ់ ពុត តាប៉ាប តាប៉ុន។ ");
INSERT INTO tpu_vpl VALUES ("NH9_32","017_9_32","NEH","9","32","32","«អឺ ប‌៉្រ័ះ ញឹន អីស ឡាក់ ប‌៉្រ័ះ តីស ទឹប ទី អំរ៉ាញ អឺញ ឡាក់ ញឹន ត្រគ់ អ្យូគ ប‌៉្រ័ះ ឡាក់ ប៉្រគ័ ពួយ សារ សាញ៉ា រែវ ពុត លូ ទី ពុត ប៉ិច ចៃ លើយ។ កិញអៀ អា ប៉រ់ អីស ហៃ ញឹន ផះ ទី សារ ប៉ាណាប កើត ពឹង ញឹន ទឹប សាដាច់ មួត ម៉ៃគ ណាំផា មួត ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ  មួត រ៉ាគឹយ ប‌៉្រ័ះ មួត វគ័ យ៉ាគ់ ញឹន លូ ប៉ាសុន អីស សាគ់ ឡឹង រ៉ាំងហាវ សាដាច់ ប៉ាថេត អាស៊ីរី ប៉្រគ័ បាប ញឹន ទឹល រ៉ប់ ដារ់ អា។ ");
INSERT INTO tpu_vpl VALUES ("NH9_33","017_9_33","NEH","9","33","33","ទិ សារ ឡាក់ កើត ពឹង ញឹន ណោះ អីស ប៉្រគ័ ដាគ់ ត្រង់ តាទឹច ហះកា ញឹន ប៉្រគ័ សារ យច។ ");
INSERT INTO tpu_vpl VALUES ("NH9_34","017_9_34","NEH","9","34","34","សាដាច់ ញឹន ម៉ៃគ ណាំផា ញឹន ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ ញឹន លូ វគ័ យ៉ាគ់ ញឹន អន់ឌែ អូ ប៉្រគ័ ពួយ ចាបាប់ អីស លូ អូ អ្យក់ ពុត ចៃគ សាំយ៉ាំង ប៉ានឹរ អីស ប៉្រើ លើ ប៉ានឹរ អីស ទឹប ប៉្រោ អន់ឌែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NH9_35","017_9_35","NEH","9","35","35","អន់ឌែ អ្វៃ ពឹង ប៉ាថេត អន់ឌែ ទៅ អីស អន់ អន់ឌែ ទី កាណាគ័ ញ៉ាៗ គ្រឹប នែវ អៀង កាខាក់ ពឹង ព្រី ទៀក តីស ឡាក់ តេះ ដាគ់ សាណា យ‌៉័ះ នីណោ័ះ កាតាម អន់ឌែ អូ អ្យិល កូត័ ប៉្រគ័ ពួយ អីស អុះ លូ អូ ចៃ អ្លាត ប៉្រគ័ សារ អូ ដាគ់ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("NH9_36","017_9_36","NEH","9","36","36","ដារ់ អា ញឹន កេះ ទុច ពូ ពឹង ប៉ាថេត ឡាក់ អីស អន់ កា វគ័ យ៉ាគ់ ញឹន ភឿ អន់ អន់ឌែ ទី សាណា សា លូ សារ ដាគ់ គ្រឹប នែវ ដេល។ ហៃ ញឹន កេះ ទុច ពូ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("NH9_37","017_9_37","NEH","9","37","37","ហះកា សាណា ឡាក់ អៀង កាខាក់ ទិ អា កើត សាំរ៉ាប់ កា សាដាច់ អន់ទៀគៗ ឡាក់ អីស អន់ ជិះ ចគ័ ញឹន ញន កា សារ យច ញឹន។ អន់ឌែ យរ ញឹន តាម ពុត ប៉ិច លូ អ្យក់ កាណាគ័ ញឹន រង ញឹន កា ទី សារ ប៉ាណាប ប៉ាបប៉ុន កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("NH9_38","017_9_38","NEH","9","38","38","«ញន កា កើត សារ នីអៀ ញឹន កា ច្រាគ់ សត់ត្រា សាញ៉ា រែវ ពុត។ កាណុង សត់ត្រា អា ទី ប៉ាតឹត ត្រា លូ ច្រាគ់ សិច ម៉ៃគ ណាំផា ញឹន ទឹប ក្រុំ លេវី លូ ក្រាគ់ រ៉ាម៉ះ ប‌៉្រ័ះ»។ …");
INSERT INTO tpu_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","អ៊ែ ចឹង អ្វៃ ដាគ់ សាណុក សាវ៉ាក តាទឹច ហង បក់ អូ រ៉ាំពង លូ ប៉ាណូស តីស ពុត អូ ម៉ុត លូ ប៉ាណូស អូ ដាគ់ អូ ក្យាគ់ លូ បក់ បឺង៉ាយ ប‌៉្រ័ះ ");
INSERT INTO tpu_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","ហះកា អ៊ែ ប៉ិច កា ចាបាប់ ប‌៉្រ័ះ ឡាក់ ត្រគ់ តាំ ពុត ម៉ុត តាំ ពៀក កាដារ់ កាចាំង កាម៉ាំង កា ឃឹត។ ");
INSERT INTO tpu_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","អ៊ែ ណោះ ពៀប ឡាក់ កា តើម អ៊្លង ហ៊ន ហះ ហាង តាំងលេ ទី ប៉្លៃ ទី ប៉ាកាវ រ៉ប់ ខៃ រ៉ប់ សាណាំ ហ្លា អូ ឡាយ៉ោ ប៉ាកាវ អូ ហ្រុង សារ ញ៉ា អ៊ែ ប៉្រគ័ ស៊ុត កា ដាគ់ ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","ហះកា បក់ ឌឺ ង៉ល់ អូ ត្រគ់ នីណោ័ះ អុះ អ៊ែ ពៀប ឡាក់ កា អញ់ជែប ពៀ តាប៉ើះ កា ខ្យាល។ ");
INSERT INTO tpu_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","ប៉ាគ់ ដារ់ ប‌៉្រ័ះ តាត់ស៊ិន សារ ចៃគ ថូត មួត អូ ដាគ់ អូ រ៉ាវ៉ាច់ ឡាកោ អុះ បក់ ប៉្រគ័ យច កា អូ អ្វៃ លូ ប៉ាសុន ប‌៉្រ័ះ ដេល ");
INSERT INTO tpu_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","ខង ប‌៉្រ័ះ ចឹង រ៉ាំងហៃ ប៉ាណូស ដាគ់ ត្រង់ ហះកា ប៉ាណូស អូ ដាគ់ ចឹង តោ័ រ៉ាយ តោ័ រ៉ុង ហង។ ");
INSERT INTO tpu_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","ញ៉ា ត្រគ់ សុនសាត អន់ទៀគ ប៉ាណាំ គួប ប៉ាំងកើត សារ តាប៉ុញ តាប៉ាក់ នីអៀ ? ញ៉ា ត្រគ់ កាំឡាំង ប៉ាសុន ប៉ាណាំ គួប ឃឹត ប៉ាសាំង លូ ប‌៉្រ័ះ នីអៀ អូ ទី ខា អុះ ? ");
INSERT INTO tpu_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","មួត សាដាច់ ពឹង អង់កក់ តេះ លូ មួត ម៉ៃគ ណាំផា អន់ឌែ ប៉ាណាំ គួប ប៉ាសាំង លូ ប‌៉្រ័ះ ប៊កកាតយ័ ទឹប ប៉ាសាំង លូ បក់ ប‌៉្រ័ះ រ៉ើស ប៉្រើ ប៉្រគ័ សាដាច់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","អន់ឌែ ផា «ពិ ពិន វ៉ាក ណូះ សាន់ដូះ ច្រ្វាល់ ឡាក់ ប‌៉្រ័ះ កត់ ពិន»។ ");
INSERT INTO tpu_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","កាប៉ាច់ ប‌៉្រ័ះ ឡាក់ អ្វៃ ពឹង ប៉្លៃង អ៊ែ កាកីក ប៉ាឡាប កាប ប៉ាឡៃវ កា ពូ។ ");
INSERT INTO tpu_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","កេះណោះ អ៊ែ ចឹង កាប អឺក កា ពូ លូ ប៉្រគ័ អន់ ពូ អ្យូគ កាខាក់ ទឹប កាប ផា៖ ");
INSERT INTO tpu_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","«អាញ់ ប៉្រើ ម៉ោញ ដូវ ប៉្រគ័ សាដាច់ កេះ ប៉្រើ រ៉ាំងហៃ ពឹង ប៉ានឹម ស៊ីយ៉ូន ឡាក់ ប៉ានឹម ដាគ់ កាខាក់ ម៉ះ អាញ់»។ ");
INSERT INTO tpu_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","អាញ់ ចឹង រ៉ះ ឡឹង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ កាប លូ អាញ់ ផា៖ «អីស អា ហង គន អាញ់ ដារ់ អា អាញ់ អន់ ពូ អ្លុ អន់តគ់ ផា អីស គន អាញ់ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","ហគ់ ប៉រ់ ឡឹង អាញ់ ម៉ាគ់ អាញ់ ចឹង អន់ សុនសាត ទិណោ័ះ កា អីស ប៉្រគ័ ប៉ាដក់ ប៉ាជៀ អាញ់ ចឹង មប អង់កក់ តេះ ទិ អា កា អីស ហង។ ");
INSERT INTO tpu_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","អីស ចឹង ពីត ប៉ាន់តោ័ អន់ឌែ លូ អ៊្លង កាទូង ប៉ាសយ់ ឡាក់ កា ពូ តាគ់ ប៉ាទុះ កគ័ កាអ៊ល»។ ");
INSERT INTO tpu_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","ទឹល នីណោ័ះ អឺ មួត សាដាច់ ទិឌូ ហគ់ ឃឹត ចាជ្រែប ពិ។ អឺ មួត ម៉ៃគ ណាំផា អ្វៃ ពឹង អង់កក់ តេះ ហគ់ សាំយ៉ាំង សារ អន់តគ់ ប៉ាតោ អា ពិ។ ");
INSERT INTO tpu_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","ហគ់ អ្យិល កូត័ អ្យូគ កា ប‌៉្រ័ះ ប៊កកាតយ័ ហគ់ ហោក រ៉គ់ ទឹប អ្យូគ រ៉ារ៉ៃត ");
INSERT INTO tpu_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","ហគ់ សាំប‌៉័ះ គន ប‌៉្រ័ះ អ្យូគ ផៃគ អ៊ែ អឺក ណោះ អន់ដីស ចឹង ត្រគ់ តោ័ រ៉ាយ តោ័ រ៉ុង ខង អ៊ែ ចឹង អឺក ស៊្រសៗ ឡូត ហះកា ទិ បក់ ម៉ឹង អ៊ែ ចឹង ទី សារ សាណុក សាវ៉ាក ហង។ ");
INSERT INTO tpu_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ មួត តាម៉ឺរ អាញ់ ទី គួប អៀង ខាក់ កាប៉ាច់ ប៉ាណូស បក់ ប៉ាសាំង លូ អាញ់ កា ទី គួប អៀង ដេល ");
INSERT INTO tpu_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","ទី ប៉ាណូស អៀង ដូវ កាប កា អាញ់ ផា ប‌៉្រ័ះ អូ តង័ អ៊ែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","កាប៉ាច់ អីស អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អីស ឡាក់ ខៃល ប៉ងកាន់ អាញ់ លូ តាតារ (?)សាំរ៉ាប់ អាញ់ ទឹប អីស ប៉្រគ័ អន់ អាញ់ អ្លុ ង៉ើយ (?) ម៉ាត់ ណាវ្គ ដេល ");
INSERT INTO tpu_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","អាញ់ ស៊្រែក ម៉ៃៗ អើ ប‌៉្រ័ះ ប៊កកាតយ័ អីស កា តើល អាញ់ ឡឹង ប៉ានឹម ឡាក់ ដាគ់ កាខាក់ ម៉ះ អីស។ ");
INSERT INTO tpu_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","អាញ់ តៃប ហ្លាក់ កេះ ហះកា សាទឹរ ណាវ្គ ខង ប‌៉្រ័ះ ប៊កកាតយ័ តង័ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","យ‌៉័ះ ទី ប៉ាណូស អៀង ឡាក់ កា អំហ្មោច ប៉ាសាំង លូ អាញ់ នីចម័ កាតាម កា អាញ់ អូ អ្យូគ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ជែ អ្វៃ គ្រឺយ អឺ ប‌៉្រ័ះ អាញ់ អីស តង័ អាញ់ ណើ ខង អីស ឃើយ តាប៉ះ គៀង តោរ មួត តាម៉ឺរ អាញ់ ទិណោ័ះ ទឹប អីស កា តាគ់ អំប៉ាក់ សាណាញ់ ប៉ាណូស អូ ដាគ់ ដេល ");
INSERT INTO tpu_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ទី ដឹង អីស ហង អ្លុ តង័ ប៉រ់ អីស អន់ សារ ដាគ់ កា ប៉ាសុន អីស ណើ។ ");
INSERT INTO tpu_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","អឺ ប‌៉្រ័ះ ឡាក់ ដាគ់ ត្រង់ ផា អាញ់ ម៉ន់ អើ អីស ប៉រ់ អីស តើល កា អាញ់ ណើ ផា អាញ់ កើត កាឌី ទី សារ ប៉រ់ អីស តង័ អាញ់ ណើ ប៉រ់ អីស តាប៉ាប តាប៉ុន កា អាញ់ លូ សាំយ៉ាំង ប៉ានឹរ អាញ់ ឡោម ឡា ណើ។ ");
INSERT INTO tpu_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","អឺ ប៉ាណូស ទិណោ័ះ អន់ដីស ចឹង ប៉្រគ័ អន់ អាញ់ តាយួស ម៉ូះ ម៉ាត់ ទឹល ដារ់ ចំ ណាវ្គ ? ញ៉ា អន់ដីស ប៉ិច ច្រោម សារ អូ ទី ខា លូ កាប ព្លូង ច្រោម ពូ តាដោះ ទឹល ដារ់ ចំ ណាវ្គ ? ");
INSERT INTO tpu_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","ត្រគ់ អ្លុ អន់តគ់ ផា ប‌៉្រ័ះ ប៊កកាតយ័ កះ ឡាច់ ប៉ាណូស បក់ អ្យិល កូត័ អ្យូគ កា អ៊ែ គម សាំរ៉ាប់ កា អ៊ែ ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង សាំយ៉ាំង អាញ់ ដារ់ ចំ អាញ់ ម៉ន់ អើ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","ផា អន់ដីស ឡាម៉គ់ អឺក ជែ ប៉្រគ័ សារ យច ដៃ ហះកា ត្រគ់ តៃប ឃឹត ចាជ្រែប ពុត ឡាអត់ អន់ អំប៉ាំង ពុត ថាំង អន់ អន់តេ័ះ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","ហគ់ ពុះ កាណាគ័ រ៉ាម៉ះ ប‌៉្រ័ះ ឡាក់ ត្រគ់ ពុត ប‌៉្រ័ះ កេះណោះ ម៉ឹង ប‌៉្រ័ះ ប៊កកាតយ័ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","ទី ប៉ាណូស អៀង ដូវ កាប ផា «ពឿ អន់ សារ សាណុក សាវ៉ាក កា ញឹន ? អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ អីស ហៃ ញឹន ណើ ញន កា ពុត ដាគ់ ម៉ះ អីស។ ");
INSERT INTO tpu_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","អីស អន់ សារ ហោគ រ៉គ់ កា អាញ់ អៀង ឡឹង ពូ ផះ ច្រូត័ ពៀ លូ ប្លេះ ប៉្លៃ អង់កាច កា ទី អៀង ឡឹង ពូ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","ប៉ាគ់ អាញ់ ម៉ុត តៃប ណោះ អាញ់ ចឹង តៃប ហ្លាក់ ឡូត។ អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ទី ដឹង អីស ហង ឡាក់ ប៉្រគ័ អន់ អាញ់ អ្វៃ សាណុក សាវ៉ាក។ ");
INSERT INTO tpu_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អីស សាំយ៉ាំង ប៉ានឹរ អាញ់ លូ អីស សាំយ៉ាំង ប៉ានឹរ អាញ់ អង់ហ្យាំង ឡុង កា សារ ថុក ប៉ាណាប អា ណើ។ ");
INSERT INTO tpu_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","អឺ ប‌៉្រ័ះ ឡាក់ សាដាច់ អាញ់ ប៉រ់ អីស អ្យក់ ពុត ចៃគ សាំយ៉ាំង ប៉ានឹរ អាញ់ តាំងអឹះ ណើ ខង អាញ់ ម៉ន់ អើ អីស។ ");
INSERT INTO tpu_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាគ់ កាំលឺ អីស សាំយ៉ាំង ប៉ានឹរ អាញ់ អាញ់ ចឹង រ៉ះ កា អីស ទឹប អាញ់ ក្យាគ់ អីស ឡឹង កាំលឺ ផុងម៉ាំង។ ");
INSERT INTO tpu_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","អីស អូ ត្រគ់ ប‌៉្រ័ះ ចៃ កា សារ អូ ដាគ់ ណោះ អុះ សារ បឺគ អ៊ក កា អូ អ្លុ អ្វៃ ក្យាម័ អីស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","អីស អូ ប៉ិច កា ប៉ាណូស ឌឺ ម៉ុត ក្យាម័ អីស អុះ អីស កា អូ ចៃ កា ប៉ាណូស បក់ ប៉្រគ័ អូ ដាគ់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","អីស ចឹង ថាំឡាយ មួត បក់ កាប ព្លូង ប‌៉្រ័ះ ប៊កកាតយ័ អូ ណីស ខាអឺម កា បក់ កោះ ប៉ាន់តោ័ ពូ លូ បក់ កាប ប៉ាញ៉ា ប៉្លាច័។ ");
INSERT INTO tpu_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","កាប៉ាច់ អាញ់ ទី ម៉ុត កាណុង ហី អីស ញន កា អីស ដាគ់ ពុត កា អាញ់ កាខាក់ អាញ់ កាដាប សាំប‌៉័ះ ហះ ង៉ីរ អីស កាណុង រ៉ោង រ៉ាម៉ះ ឡាក់ ដាគ់ កាខាក់ ម៉ះ អីស ទឹប អ្យិល កូត័ អ្យូគ កា អីស។ ");
INSERT INTO tpu_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ទី ប៉ាណូស អៀង ប៉ាសាំង លូ អាញ់ ប៉រ់ អីស ប៉ាណាំ អាញ់ អន់ ប៉្រគ័ ពួយ ពុត អីស ប៉រ់ អីស ប៉្រគ័ ទ្រង អីស អន់ ត្រង់ ហះ ង៉ីរ អាញ់ ណើ។ ");
INSERT INTO tpu_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","មួត ទិណោ័ះ ប៉ានឹរ អន់ឌែ អូ ត្រង់ អុះ អន់ឌែ ឃឹត ដឹង កា ប៉ិច ថាំឡាយ អំប៉្យិត អន់ឌែ កាប ឡាច់ ដឹង សារ អូ ដាគ់ ឡាក់ កា កាណាគ័ ប៉ាញឹល សាំរ៉ាប់ ប៉ាន់តោ័ ពូ។ ");
INSERT INTO tpu_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អីស ចៃគ ថូត អន់ឌែ ពិ អន់ អន់ឌែ តោ័ រ៉ាយ តោ័ រ៉ុង ញន កា ផិនកាន អន់ឌែ ទៅ ប៉្រគ័ សារ អូ ដាគ់ អៀង យ៉ាប អូ ទិ ខង អន់ឌែ ប៉ាសាំង លូ អីស ទឹល នីណោ័ះ អីស អ្លាត អន់ឌែ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","កាប៉ាច់ បក់ ម៉ឹង អីស អន់ឌែ ចឹង ទី សារ សាណុក សាវ៉ាក លូ ចឹង ហោគ រ៉គ់ លើយ ខង អីស ចឹង ប៉ងកាន់ រ៉ាំងហៃ រ៉ាំងខ្យា អន់ឌែ ទិ បក់ ប៉ិច កា អីស ចឹង ហោគ រ៉គ់ ញន កា អីស។ ");
INSERT INTO tpu_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អីស ចឹង អន់ សារ ដាគ់ កា ប៉ាណូស ដាគ់ ត្រង់ ពុត ដាគ់ ម៉ះ អីស ពៀប ឡាក់ កា ខៃល ប៉ងកាន់ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ យ‌៉័ះ អីស អឺក កា អាញ់ កាតាម អីស ជែ ចៃគ ថូត អាញ់ ហង យ‌៉័ះ អីស អុក ពុត កា អាញ់ កាតាម អីស ជែ ពីត ប៉្រគ័ បាប អាញ់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អីស តាប៉ាប តាប៉ុន កា អាញ់ ណើ ខង អាញ់ ហ៊ែង ទិ សាងុំ ឡក់ កេះ អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អីស តាគ់ អន់ដាគ់ អាញ់ ណើ ខង ឡាកោ អាញ់ អា រ៉ារ៉ៃត អ្យឹរៗ។ ");
INSERT INTO tpu_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","ពុត ពៀគ អាញ់ កាដុក កាដុល អ៊ល ប៉្លៃ ណូស ខាក់ អីស ចឹង អន់ អាញ់ អ្វៃ នីអៀ ទឹល ដារ់ ចំ ណាវ្គ ? ");
INSERT INTO tpu_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អីស ជឹរ តង័ អាញ់ ណើ លូ អ្យក់ ឡាច់ អាញ់ ញន កា ពុត អីស ដាគ់ ");
INSERT INTO tpu_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","ខង ប៉ាគ់ តោ័ កេះ អូ ទី ពឿ អ្លុ កាចាំង កា អីស ណាវ្គ អុះ កា អូ ឃើយ ទី ពឿ ប៉ានេ អីស កាណុង ចារ ពូ គ្រន ប៉ាង៉ាត័ ប៉ាណូស តោ័ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","អាញ់ ទិ សាងុំ ញន កា អាញ់ ញ៉ាំ សោក ពឹង ចារ អាញ់ តៃប សប់ សាអ្យប័ ទឹល តារ ទៀក ម៉ាត់ អាញ់ ហូរ័ សប់ កាន់ហ្នើយ្គ ");
INSERT INTO tpu_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","សារ អុក ពុត ពៀក ប៉្រគ័ អន់ ម៉ូះ ម៉ាត់ អាញ់ ស្រក ម៉ាត់ អាញ់ កា កើត ព្រឹងៗ ញន កា មួត តាម៉ឺរ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","អឺ បក់ ប៉្រគ័ សារ អូ ដាគ់ ហគ់ ឡាច់ ឡឹង អាញ់ អន់ ចាំងហាយ្គ ពិ ខង ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ សាំយ៉ាំង កាតាំង ប៉ានឹរ អាញ់ ញ៉ាំ សោក កេះ។ ");
INSERT INTO tpu_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","ប‌៉្រ័ះ ប៊កកាតយ័ សាំយ៉ាំង ប៉ានឹរ អាញ់ ឡោម កេះ ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ ចឹង អ្យក់ ប៉ានឹរ អាញ់ ម៉ន់ ដេល ");
INSERT INTO tpu_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","អន់ មួត តាម៉ឺរ អាញ់ ទិណោ័ះ តាយួស លូ អ្យូគ រ៉ារ៉ៃត កេះណោះ អន់ អន់ឌែ ប៉ាណាំ គួប វ៉ីល សឹត ទឹប តាយួស កាខាក់ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អាញ់ អាញ់ ប៉រ់ ម៉ឹង អេង អីស ប៉រ់ អីស តង័ អាញ់ ណើ អន់ រ៉ាវ៉ាច់ ឡឹង តី មួត បក់ ប៉ិច ប៉្រគ័ អូ ដាគ់ កា អាញ់ ");
INSERT INTO tpu_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","អ្យូគ ផៃគ ពូ ហ៊ែក អាញ់ ឡាក់ កា ក្លា កាប់ សាំងកង់ ឡាំ លើយ លូ អូ ទី ពឿ ចឹង តង័ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អាញ់ ផា អាញ់ ប៉្រគ័ ឡាក់ កា ប៉ានឹរ ពូ កាប ផា តី អាញ់ ប៉្រគ័ សារ អូ ដាគ់ ");
INSERT INTO tpu_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","ផា អាញ់ ប៉្រគ័ សារ អូ ដាគ់ តូ លូ គួប ចាង័ អាញ់ លើ កា ផា អាញ់ រ៉ាត អ្យក់ រ៉ាស អំប៉ាស ពូ អូ ទី ខ អូ ទី សារ ឡឹង មួត បក់ ប៉ាសាំង លូ អាញ់ ផា អាញ់ ប៉្រគ័ នីណោ័ះ តាទឹច ");
INSERT INTO tpu_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","អន់ មួត តាម៉ឺរ តាយ៉ិប ប៉ាន់តោ័ អាញ់ ពិ អន់ ពូ ចគ័ ប៉្លៃន អាញ់ ពឹង តេះ លូ អន់ ពូ ប៉្រគ័ អន់ សារ អាញ់ លៅ លែង សិច ហ៊្យង ហ្យើត ឡាក់ ពូ ប៉ាឡិ ពឹង តេះ ត្រប់ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អីស អឺក កាខាក់ ប៉រ់ អីស អឺក តូ កា មួត តាម៉ឺរ ឡាក់ ប៉្រគ័ សារ ខូយ ប៉ាអ្យប់ ប៉ាសាំង លូ អាញ់ ខង អីស ហង ប៉ាំងកើត ចាបាប់។ ");
INSERT INTO tpu_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","អន់ សុនសាត ទិណោ័ះ ប៉ាណាំ គួប ពឹះ អ្វៃ ជុំ អីស ប៉រ់ អីស រ៉ាំងហៃ រ៉ាំងខ្យា អន់ឌែ ទិឌូ ");
INSERT INTO tpu_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ក្រាគ់ តាត់ស៊ិន សារ កា ប៉ាសុន ទិណោ័ះ អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អីស តាត់ស៊ិន អន់ ត្រង់ កា អាញ់ ណើ ខង អាញ់ ដាគ់ ត្រង់ ដេល ");
INSERT INTO tpu_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","អន់ សារ អូ ដាគ់ ម៉ះ ប៉ាណូស ង៉ល់ ឌឺ រ៉ាយ រ៉ាំ តាដោះ ហះកា ប៉្រគ័ អន់ ប៉ាណូស បក់ ដាគ់ ត្រង់ ទី សាងុំ ពិ អឺ ប‌៉្រ័ះ ឡាក់ ដាគ់ ត្រង់ អីស អ្លុ ហ្លង់ ឡឹង ពុត ពៀក ប៉ាណូស ");
INSERT INTO tpu_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","ប‌៉្រ័ះ ប៊កកាតយ័ ហង ឡាក់ ខៃល ប៉ងកាន់ អាញ់ អីស តង័ បក់ ទី ពុត ដាគ់ ត្រង់។ ");
INSERT INTO tpu_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ក្រាគ់ តាត់ស៊ិន សារ ដាគ់ ត្រង់ អីស ប៉ាសាំង លូ សារ អូ ដាគ់ រ៉ប់ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","ផា ប៉ាណូស បក់ អូ ដាគ់ អូ ប៉ិនពែង ពុត ពៀគ ប‌៉្រ័ះ ចឹង ធែង ដាវ រ៉ាយ្គ អ្លាត ស្រាគ់ កេះ ភឿ ប៉ាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","អីស ទ្រៀម ឃឿង ខង ចឹង ប៉ាន់តោ័ ពូ កេះ ទឹប អីស ប៉្រគ័ កាំ អុញ ចឹង ប៉ាញ់ ពូ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","បក់ ចំ ឃឹត ដឹង ប៉្រគ័ សារ អូ ដាគ់ លូ ឃឹត ឡឹង សារ ប៉ាន់តោ័ ពូ បក់ ណោះ ចឹង ទី ដឹង សារ ព្លូង ប៉្លាច័ ");
INSERT INTO tpu_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","បក់ ចំ សីរ ឡូះ ហ៊ែង ជ្រុ ៗ បក់ ណោះ ចាបះ កា ចឹង ឡិ កាណុង ឡូះ ឡាក់ អ៊ែ សីរ ណោះ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","សារ អូ ដាគ់ ឡាក់ អន់ឌែ ប៉្រគ័ ចឹង ឡិ ពឹង កល់ អន់ឌែ ទៅ សារ អន់ឌែ ខូយ ប៉ាអ្យប់ កា ចឹង ឡិ ពឹង កាន់តីង កល់ អន់ឌែ ទៅ ដេល ");
INSERT INTO tpu_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","អាញ់ ចឹង ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ខង អីស ដាគ់ ត្រង់ អាញ់ ចឹង ចាជែ ប៉ានេ តាគ់ អំប៉ោក សិច អីស ឡាក់ ប‌៉្រ័ះ តីស ហ៊្លត។ ");
INSERT INTO tpu_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","អញ់ស៊ែ ដាវីត ប៉ាហ្យើ អន់ កា ម៉ៃគ ណាំផា អញ់ស៊ែ សាំរ៉ាប់ ចាជែ លូ គួងទឹង។ អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ តាំងឡា ញឹន អីស តីស សាន់ត្រាគ័ ដាគ់ សាន់ទ្រឹម សាងុំ កេង ខាក់ អីស លៅ លែង សិច ប៉ាញ័ ទឹប អង់កក់ តេះ អីស កា អន់ ពូ ប៉ប័ សារ អំរ៉ាញ អឺញ អីស ពឹង ប៉្លៃង ដេល ");
INSERT INTO tpu_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","ម៉ាគ់ ប៉ានឹរ ប៉ានេ អីស ឡាច់ ឡឹង ពឹរ សាស្វា ឡន់។ អីស កា ប៉្រគ័ ប៉ាន់ទៀយ តីស កាចាប័ ញន កា មួត តាម៉ឺរ លូ បក់ ប៉ាសាំង លូ អីស ម៉ាគ់ ប៉ាន់តោ័ អ្លាត អន់ឌែ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","ផះ អាញ់ ង៉ើយ ហៃ ពឹង ប៉្លៃង អាញ់ ប៉ប័ កាណាគ័ អីស ប៉ាំងកើត អាញ់ ប៉ប័ ខៃ សំឡង់ ឡាក់ អីស អន់ អ្វៃ ពឹង ប៉្លៃង ");
INSERT INTO tpu_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","អាញ់ អូ ហ្លង់ អុះ ខ ញ៉ា បះ អីស ឃឹត កា ប៉ាណូស ញឹន នីអៀ ខ ញ៉ា បះ អីស អ្យក់ ពុត ចៃគ រ៉ាំងហៃ ញឹន នែវ អា។ ");
INSERT INTO tpu_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","អីស ប៉្រគ័ អន់ ប៉ាណូស អ្វៃ កាន់តេ័ះ ប៊យ ប‌៉្រ័ះ ប៊ែត អីស អន់ ញឹន ប៉្រគ័ សាដាច់ ពឹង អង់កក់ តេះ ទឹប ទី អំរ៉ាញ អឺញ លូ លៅ លែង សិច។ ");
INSERT INTO tpu_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","អីស អន់ ញឹន រ៉ាំងហៃ កាណាគ័ ញ៉ាៗ ទិណោ័ះ ឡាក់ អីស ប៉ាំងកើត អីស ប៉្រគ័ អន់ កាណាគ័ ទិណោ័ះ អ្វៃ កាន់តេ័ះ ជុង ញឹន កេះៗ ");
INSERT INTO tpu_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","ទឹប កាណាគ័ ស្រុក ទឹប កាណាគ័ ព្រី គ្រឹប នែវ ទិណោ័ះ ");
INSERT INTO tpu_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","ទឹប សៃម ប៉ារ់ ពឹង ប៉្លៃង ទឹប កា កាណុង ទៀក លូ កាណាគ័ គ្រឹប នែវ ឡាក់ អ្វៃ កាណុង ទៀក សាឡីគ សាឡាយ។ ");
INSERT INTO tpu_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ តាំងឡា ញឹន អីស តីស សាន់ត្រាគ័ ដាគ់ សាន់ទ្រឹម សាងុំ កេង ខាក់ អីស លៅ លែង សិច ប៉ាញ័ ទឹប អង់កក់ តេះ។ ");
INSERT INTO tpu_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","អាញ់ ចឹង ចាជែ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ ទិ ពុត ទឹប អាញ់ ចឹង រ៉ះ សារ កេង ខាក់ ម៉ះ អីស ដេល ");
INSERT INTO tpu_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","អាញ់ ចឹង ហោក រ៉គ់ ញន កា អីស អាញ់ ចឹង ហោគ កាខាក់ អឺ ប‌៉្រ័ះ ឡាក់ តីស ហ៊្លត អាញ់ ចឹង ចាជែ ប៉ានេ សិច អីស។ ");
INSERT INTO tpu_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","មួត តាម៉ឺរ អន់ឌែ សាតាក់ ឡាច់ ទឹប សាឡឹម ប៉ក់ តោ័។ ");
INSERT INTO tpu_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","ខង ផះ អីស អ្វៃ ពឹង គ្រេ សាដាច់ អីស តាត់ស៊ិន សារ ដាគ់ ត្រង់ កា អាញ់ ម៉ាគ់ ពូ អ្លុ អន់ហ្នាល់ ផា អាញ់ ឡាក់ ប៉ាណូស ដាគ់ ត្រង់ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","ផះ អីស តាត់ស៊ិន សារ កា សុនសាត អន់ទៀគ អីស ថាំឡាយ អន់ឌែ អន់ ទិ ឡូត ទឹប អីស អ៊្យូត ឡាច់ សិច អន់ឌែ លើយ ទឹល រ៉ាប់ ដារ់ អា។ ");
INSERT INTO tpu_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","មួត តាម៉ឺរ រ៉ាយ រ៉ាំ ហ៊្យង ហ្យើត លើយ កាប៉ាច់ មឿង អន់ឌែ កា អីស ថាំឡាយ ទិ ដេល អូ ទី ពឿ ចឹង កា ចាំង កា អន់ឌែ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","ហះកា អីស ប៉្រគ័ សាដាច់ លើយ អីស អង់អ្វៃ ពឹង គ្រេ សាដាច់ ភឿ តាត់ សិត សារ។ ");
INSERT INTO tpu_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ាំងហៃ អង់កក់ តេះ ញន សារ ដាគ់ ត្រង់ ទឹប អីស តាត់ស៊ិន សារ ញន សារ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","ប៉រ់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ ប៉ាន់ទៀយ កាង័ កាចាប័ ប៉ងកាន់ មួត បក់ ពូ ជិះ ចគ័ ឃឺ ប៉ាន់ទៀយ ប៉ងកាន់ ផះ ពូ ទី សារ ចុនចៃ។ ");
INSERT INTO tpu_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ទិ បក់ អន់ហ្នាល់ សិច អីស បក់ ណោះ ចឹង សឿ ម៉ឹង អីស ហង ខង អីស អូ អ្លាត បក់ ពឿ ឡាក ណាំង អីស ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","ហគ់ ប៉ាណាំ គួប ចាជែ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក អ្វៃ ពឹង មឿង ស៊ីយ៉ូន ហគ់ រ៉ះ កា ប៉ាសុន ទិឌូ ឡឹង កាណាគ័ ញ៉ា ឡាក ប‌៉្រ័ះ ប៉ាំងកើត។ ");
INSERT INTO tpu_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","ខង ប‌៉្រ័ះ ចៃគ ថូត បក់ ពឿ ឡាក់ ប៉ាន់តោ័ ប៉ាណូស ប‌៉្រ័ះ អូ ពឹល ឡឹង សារ ពូ ញ៉ាំ តាំងអឹះ ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អីស តាប៉ាប តាប៉ុន កា អាញ់ ណើ អីស ហៃ អាញ់ ផះ ទី សារ ថុក ឡាំបាក ញន កា មួត តាម៉ឺរ ទី ដឹង អីស ហង អ្លុ ប៉ាណាំ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង សារ តោ័ ");
INSERT INTO tpu_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","ម៉ាគ់ អាញ់ រ៉ះ គ្រឹប សារ អាញ់ ចាជែ ប៉ានេ អីស ហះ ម៉ាត់ មួត ប៉ាសុន ពឹង មឿង ស៊ីយ៉ូន អាញ់ ចឹង ហោក រ៉គ់ កាខាក់ ញន កា សារ អីស តង័ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","មួត សុនសាត អន់ទៀគ អន់ឌែ ចឹង ឡិ កាណុង ឡូះ ឡាក់ អន់ឌែ ទៅ សីរ ជុង អន់ឌែ ត្រគ់ សាទួង អន់ឌែ ទៅ ប៉្រគ័។ ");
INSERT INTO tpu_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","ប‌៉្រ័ះ ប៊កកាតយ័ តាំបាង អន់ ពូ អន់ហ្នាល់ អ៊ែ អ៊ែ តាត់ស៊ិន សារ ពូ យច មួត បក់ អូ ដាគ់ ចឹង ត្រគ់ សាទួង អន់ឌែ ទៅ។ ");
INSERT INTO tpu_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","មួត បក់ អូ ដាគ់ អន់ឌែ ចឹង ឡាំ ប៉ាគ់ ស្រុក ប៉ាទ្រូ ចារ គ្រន ប៉ាង៉ាត័ ប៉ាណូស តោ័ ឃឺ ទិ សុនសាត ចំ ឡាក ពឹល ប‌៉្រ័ះ អន់ឌែ ណាំង សារ តោ័ ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","ហះកា ប៉ាណូស បក់ តាបាយ កាសត់ ប‌៉្រ័ះ អូ ពឹល អន់ឌែ អុះ សារ មួត ថុក ញ៉ាក ម៉ឹង ណោះ កា អូ ហ៊្យង ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អីស អ្យូវ ពិ ជែ អន់ ទី ទ្រង ប៉ាណូស ហង ហគ់ តាត់ស៊ិន សារ កា សុនសាត អន់ទៀគៗ ហះ ម៉ាត់ អីស ពិ។ ");
INSERT INTO tpu_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ហគ់ ប៉្រគ័ អន់ អន់ឌែ អ្យូគ ពិ ប៉រ់ អីស ប៉្រគ័ អន់ មួត ប៉ាសុន ទិណោ័ះ អ្លុ អន់តគ់ ផា អន់ឌែ ក្រាន័ កា ប៉ាណូស ដោច។ ");
INSERT INTO tpu_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ខ ញ៉ា បះ អីស អ្វៃ ចាំងហាយ្គ ឡឹង អាញ់ ? ផះ អាញ់ ទី សារ ថុក ប៉ាណាប ខ ញ៉ា បះ អីស អ្វៃ គ្រឺយ នីអៀ ? ");
INSERT INTO tpu_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","ប៉ាណូស អូ ដាគ់ អន់ឌែ ប៉្រគ័ បាប មួត បក់ ថុក ញ៉ាក អន់ឌែ ប៉ាញ៉ា ប៉្លាច័ កា ប៉ាណូស អូ គឹត អូ ខា ប៉្រគ័ អន់ បក់ ថុក ញ៉ាក តោ័ ");
INSERT INTO tpu_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","ប៉ាណូស អូ ដាគ់ អន់ឌែ ឌុ កាប អ្វាត់ អេង ឡឹង សារ អន់ឌែ ខ្វាម ទឹប អន់ឌែ បឺង៉ាយ ប‌៉្រ័ះ ប៊កកាតយ័ ដេល ");
INSERT INTO tpu_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","ប៉ាណូស អូ ដាគ់ អន់ឌែ កាប ខូយ អ្វាត់ អេង ទឹប អន់ឌែ អូ វ៉ឹនវ៉ាយ កា សារ ញ៉ា អុះ ខង អន់ឌែ ឃឹត ផា អូ ទី ប‌៉្រ័ះ ប៊កកាតយ័ អុះ ");
INSERT INTO tpu_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","សារ ញ៉ា ឡាក់ អន់ឌែ ប៉្រគ័ ស៊ុត កា អូ ដាគ់ លើយ អន់ឌែ អូ អ្លុ អុះ កា ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ចៃគ ថូត អន់ឌែ ទឹល នីណោ័ះ អន់ឌែ ខំ កាប អូ ដាគ់ កា ពូ លើយ ");
INSERT INTO tpu_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","អន់ឌែ ឃឹត កាណុង ពុត ផា ញឹន ចឹង អូ ទី សារ ចុនចៃ លូ អូ ថុក ប៉ាណាប អុះ ");
INSERT INTO tpu_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","ពឹរ អន់ឌែ ត័ះ ប៉ាស្យាប កាប បឺង៉ាយ ទឹប សារ ព្លូង ប៉្លាច័ លូ សារ អូ ដាគ់ គ្រប នែវ អ្វៃ កាណុង អំប៉្យិត អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","កាម៉ាំង អន់ឌែ ឃើយ អ្វៃ ក្រាប់ ហះ អំប៉ារ ទ្រួក ចឹង ប៉ាន់តោ័ អន់តុង បក់ ដាគ់ ត្រង់ បក់ ចំ ឡាក់ អូ គឹត អូ ខា ");
INSERT INTO tpu_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","អន់ឌែ អ្វៃ ក្រាប់ ហះ ចារ ឡាង៉ាន់ ឡាក់ កា ប៊ក អ្វៃ កាណុង ប៉ោម អន់ឌែ ក្យាគ់ ជៀក ប៉ាឡោម មួត បក់ ថុក ញ៉ាក អន់ ត្រគ់ អង់កោ អន់ឌែ ");
INSERT INTO tpu_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","មួត បក់ ថុក ញ៉ាក កា សាឡឹម ប៉ក់ ពឹង តេះ ទឹប ទី ពឹង តី មួត អូ ដាគ់ កេះ ");
INSERT INTO tpu_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","មួត អូ ដាគ់ អន់ឌែ ឃឹត កាណុង ពុត ផា ប‌៉្រ័ះ ប៊កកាតយ័ អូ ឃឹត ឡឹង សារ ណោះ អុះ ទឹប កាប ផា ប‌៉្រ័ះ ប៊កកាតយ័ សាំងអ្យឹប ម៉ាត់ អ៊ែ អូ ហៃ អុះ ");
INSERT INTO tpu_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អីស ពឹះ រិញ ពិ ម៉ាគ់ អីស ថាំឡាយ មួត បក់ អូ ដាគ់ ទឹប អីស ជែ ពឹល មួត បក់ ថុក ញ៉ាក ");
INSERT INTO tpu_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","ខ ញ៉ា បះ មួត អូ ដាគ់ កាប បឺង៉ាយ កា ប‌៉្រ័ះ ប៊កកាតយ័ នីអៀ ? អន់ឌែ ឃឹត កាណុង ពុត ផា ប‌៉្រ័ះ ប៊កកាតយ័ អូ ចៃគ ថូត អន់ឌែ អុះ ");
INSERT INTO tpu_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អីស កា ប៉ប័ កេះ ដេល សារ ថុក ប៉ាណាប លូ សារ ប៉ាណូស បក់ អូ គឹត អូ ខា អីគ ពុត ពៀក ទឹប អីស ចឹង តង័ អន់ឌែ លើយ បក់ អូ គឹត អូ ខា កា មប អាញុ រ៉ីស ទិណោ័ះ កា អីស ទី ដឹង អីស ហង ចឹង ជឹរ តង័ មួត គន កាន់តី ");
INSERT INTO tpu_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","ប៉រ់ អីស គុ តាគ់ អំប៉ាក់ ពិ តី មួត ខូយ ប៉ាអ្យប់ លូ ចៃគ ថូត អន់ឌែ ភឿ ជែ អន់ ប៉្រគ័ សារ អូ ដាគ់ ណាវ្គ ");
INSERT INTO tpu_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ សាដាច់ អ៊ែ អ្វៃ លើយ ឡឹង អន់ទ្រួល កេះ សុនសាត អន់ទៀគ ឡាក់ សាំប‌៉័ះ ហ៊ូប ប‌៉្រ័ះ អន់ទៀគ ចឹង អ៊្យូត ឡាច់ ឡឹង អង់កក់ តេះ ");
INSERT INTO tpu_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អីស អ្លុ ហ្លង់ កេះ ឡឹង ពុត មួត អ្លុ អ្យិល កូត័ កា អីស ទឹប អីស អ្លុ ប៉ាំងហោក ពុត ពៀក អន់ឌែ ដេល ");
INSERT INTO tpu_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","អីស ឃើយ សាំយ៉ាំង មួត គន កាន់តី ម៉ន់ អើ លូ មួត បក់ ពូ ជិះ ចគ័ ទឹប អីស តាត់ស៊ិន សារ អន់ ដាគ់ ត្រង់ កា អន់ឌែ ជែ អន់ ប៉ាណូស អូ ដាគ់ អ្វៃ ពឹង អង់កក់ តេះ អា ជិះ ចគ័ អន់ឌែ លើយ។ ");
INSERT INTO tpu_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","អាញ់ ម៉ឹង ប‌៉្រ័ះ ប៊កកាតយ័ កេះ ញ៉ា ត្រគ់ អន់ដីស កាប ផា៖ «ហគ់ សាតាក់ ឡាំ អោន ប៉ាគ់ ប៉ានឹម តោ ពិ ឡាក់ កា សៃម ");
INSERT INTO tpu_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","ហៃ ប៉ាណូស បក់ អូ ដាគ់ ផះ អ្វៃ រ៉ាយ្គ ស្រាគ់ លូ តាំ កាំ ក្រាប់ ប៉ាគ់ ចារ ម៉ាម៉ាំង តាម៉ង់ គែង ប៉ាណូស ដាគ់ ត្រង់។ ");
INSERT INTO tpu_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","ផានែវ កា សារ តាឡាប័ ឃើយ ម៉ះ ប៉ាសុន ត្រគ់ ថាំឡាយ ទិណោ័ះ កេះ ប៉ាណូស បក់ ដាគ់ ត្រង់ ចឹង ប៉្រគ័ ញ៉ា កើត ?» ");
INSERT INTO tpu_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ ពឹង ហី ឡាក់ ដាគ់ កាខាក់ ទឹប អ្វៃ ពឹង គ្រេ សាដាច់ ពឹង ប៉្លៃង តោ អ៊ែ ហៃ ប៉ប័ លូ អ្លុ ហ្លង់ ឡឹង សារ ញ៉ាៗ ទិណោ័ះ ឡាក់ ប៉ាណូស ប៉្រគ័។ ");
INSERT INTO tpu_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ប័ ពុត ប៉ាណូស ដាគ់ លូ ប៉ាណូស អូ ដាគ់ ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ អូ ណីស កា ពុត ប៉ាណូស ង៉ល់ ឌឺ លូ សារ អូ ដាគ់ ម៉ះ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","ប៉រ់ ប‌៉្រ័ះ ប៊កកាតយ័ ចៃគ ថូត ប៉ាណូស បក់ អូ ដាគ់ លូ តូះ អុញ ចាយ ណាយ កាទីរ ឡឹង ប៉្លៃង ឡាក់ កា បី លូ អន់ ទី ខ្យាល តុ កាខាក់ ត្រគ់ ពឹង អន់ឌែ ដេល ");
INSERT INTO tpu_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","ខង ប‌៉្រ័ះ ប៊កកាតយ័ ដាគ់ ត្រង់ ណោះ ហង បះ អ៊ែ ប៉ិច កា សារ ដាគ់ ត្រង់។ បក់ ពឿ ទី ពុត ដាគ់ ត្រង់ បក់ ណោះ ហង ចឹង ប៉ប័ ម៉ូះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អីស តង័ អាញ់ ណើ ខង អូ ទី ប៉ាណូស ដាគ់ ត្រង់ កេះ កិញអៀ ពូ ឃឹត ដឹង កា សារ អូ ដាគ់ ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","ពូ ឃឹត ដឹង កា សារ ព្លូង ប៉្លាច័ កា គួប សោប ប៉ានឹរ ពឹរ កាង ពូ កាប កា អូ ដាគ់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អីស ប៉្រគ័ អន់ ប៉ានឹរ ពឹរ កាង អន់ឌែ កាកាប អូ ដាគ់ ណោះ អន់ រ៉ាង៉ាប់ រ៉ាអ៊ែត ពិ។ ");
INSERT INTO tpu_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","អន់ឌែ កាប ផា ញន កា ប៉ានឹរ ពឹរ កាង ពិន កាប ណោះ ហង ប៉្រគ័ សារ ញ៉ា កាតាម ចយ័ ទ្រង ពិន យ៉ះ ពិន កាប នែវ ចំ កា ដាគ់ ដេល អូ ទី ពឿ ចឹង ទឹប ពិន ទី អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","ប‌៉្រ័ះ ប៊កកាតយ័ កាប ផា អាញ់ ប៉ប័ ពូ ជិះ ចគ័ ទឹប អាញ់ កាតាំង មួត ថុក ញ៉ាក ញ៉ាំ អង់ហ្យាំង ទឹល នីណោ័ះ អាញ់ ចឹង ជឹរ កិញអៀ ហង អាញ់ ចឹង តង័ អន់ឌែ អន់ រ៉ាវ៉ាច់ ឡឹង សារ ពូ បឺង៉ាយ។ ");
INSERT INTO tpu_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ដាគ់ កាខាក់ ក្វា ឡឹង ប៉្រាក់ ឡាក់ ពូ សុះ កាណុង អុញ តាំប៉ើះ ទង សាំ។ ");
INSERT INTO tpu_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អីស រ៉ាំងហៃ ញឹន ណើ លូ តង័ ញឹន អន់ រ៉ាវ៉ាច់ ឡឹង ប៉ាណូស អូ ដាគ់ លើយ។ ");
INSERT INTO tpu_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","យ៉ះ ប៉ាណូស អូ ដាគ់ ខំ ប៉្រគ័ សារ អូ ដាគ់ កា ញឹន គ្រប ចារ កាតាម អីស អ្វៃ រ៉ាំងហៃ ញឹន លើយ។ ");
INSERT INTO tpu_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ញ៉ា អីស ពឹល អាញ់ កេះ ប ? អីស អូ កាលែង ហៃ អាញ់ ទឹល ដារ់ ចំ ណាវ្គ ? ");
INSERT INTO tpu_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អីស អន់ អាញ់ អុក ពុត ទឹល ដារ់ ចំ ណាវ្គ ? ញ៉ា អីស អន់ អាញ់ អ្យូគ ហ្យឹក ទឹប កាដារ់ ទឹប កាម៉ាំង នែវ ហង ប ? មួត តាម៉ឺរ អាញ់ អន់ឌែ កេង ឡឹង អាញ់ ទឹល ដារ់ ចំ ណាវ្គ ? ");
INSERT INTO tpu_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អាញ់ ប៉រ់ អីស ឃឹត ហៃ លូ រ៉ះ កា អាញ់ ណើ ណោះ អាញ់ ចឹង ទី សាងុំ ម៉ាគ់ ដាគ់ អាញ់ អូ តោ័ ");
INSERT INTO tpu_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","អ្យូគ ផៃគ មួត តាម៉ឺរ ចឹង រ៉ះ ផា ចយ័ ទ្រង អន់ឌែ កេះ ជែ អន់ អន់ឌែ ហោក ញន កា អាញ់ អូ ដាម័ អន់ឌែ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","ហះកា អាញ់ ម៉ឹង អេង កា ពុត ដាគ់ ត្រង់ ម៉ះ អីស ទឹប អាញ់ ហោក រ៉គ់ ញន កា អីស តង័ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","អាញ់ ចឹង ចាជែ ប៉ានេ អីស ខង អីស ដាគ់ (តាប៉ាប តាប៉ុន) កា អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","ប៉ាណូស បក់ ង៉ល់ អូ ហ្លង់ ពូ ឃឹត កាណុង ពុត ផា អូ ទី ប‌៉្រ័ះ អុះ អន់ឌែ ទិឌូ ស៊ុត កា អូ ដាគ់ (?) អន់ឌែ ប៉ាណាំ គួប ប៉្រគ័ សារ អូ ដាគ់ គ្រុប នែវ អូ ទី ពឿ ម៉ោញ ដូវ ប៉្រគ័ សារ ដាគ់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","ប‌៉្រ័ះ ប៊កកាតយ័ ហៃ ឡឹង ប៉្លៃង ហៃ ប៉ាណូស ពឹង អង់កក់ តេះ អ្យូគ ផៃគ ទី ពឿ អន់ដា ទី ពុត ហ្យាំង សាឡាច់ ឃឹត ណាំង ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","ហះកា ប៉ាណូស ទិឌូ ក្លះ ឡាច់ ឡឹង ប‌៉្រ័ះ ទឹប ប៉ាណាំ គួប ប៉្រគ័ សារ អូ ដាគ់ គ្រប នែវ អូ ទី ពឿ ប៉្រគ័ សារ ដាគ់ អុះ យ៉ះ ម៉ោញ ដូវ កា អូ ទី សាំ ");
INSERT INTO tpu_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","ប‌៉្រ័ះ ប៊កកាតយ័ កាប ផា មួត បក់ ប៉្រគ័ សារ អូ ដាគ់ ញ៉ា អន់ឌែ អូ ហ្លង់ ឡគ ប ? អន់ឌែ ណាំង សា សិម ឡាកោ ប៉ាំងឡៃ ញន សារ ជិះ ចគ័ ប៉ាសុន អាញ់ អន់ឌែ អូ ម៉ន់ អើ អាញ់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","អន់ឌែ ណោះ ចឹង អ្យូគ រ៉ារ៉ៃត ខាក់ ខង ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ គែង មួត ដាគ់ ត្រង់។ ");
INSERT INTO tpu_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","មួត អូ ដាគ់ ប៉្រគ័ អន់ កា មួត ថុក ញ៉ាក អូ ទី សារ ម៉ឹង ហះកា ប‌៉្រ័ះ ប៉្រគ័ អន់ មួត ថុក ញ៉ាក ទី សារ ម៉ឹង។ ");
INSERT INTO tpu_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","អន់ អ៊ីស្រាអ៊ែល ទី សារ ប‌៉្រ័ះ តង័ ឡាច់ ឡឹង មឿង ស៊ីយ៉ូន។ ប៉ាគ់ ដារ់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាណាំ ប៉ាសុន អ៊ែ អន់ រ៉ាវ៉ាច់ ឡឹង កេះ ទុច ណោះ ផូង័ វ៉ាច់ យ៉ាកុប ឡាក់ ពូ អើ ផា អ៊ីស្រាអ៊ែល ចឹង ទី សារ សាណុក សាវ៉ាក លូ សារ ហោក រ៉ក់ តាទឹច ។ ");
INSERT INTO tpu_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ពឿ ចឹង ម៉ុត អ្វៃ កាណុង រ៉ោង រ៉ាម៉ះ អីស ពឿ ចឹង ហាវ ពឹង ប៉ានឹម ស៊ីយ៉ូន ឡាក់ ចារ ដាគ់ កាខាក់ ម៉ះ អីស ណោះ ? ");
INSERT INTO tpu_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","ឃឺ ទី ដឹង បក់ ដាគ់ ត្រង់ ញន កា ប៉្រគ័ ពួយ ប៉ានឹរ អីស លូ កាប សារ តាទឹច លើយ ឡាច់ ឡឹង ពុត ដាគ់ ត្រង់ បក់ ណោះ ហង ចឹង ទី ម៉ុត អ្វៃ។ ");
INSERT INTO tpu_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","ប៉ានឹរ ពឹរ កាង អន់ឌែ អូ កាប ក្លិ ក្លក់ ទឹប អូ ប៉្រគ័ អូ ដាគ់ កា គួប ចាង័ លូ អុះ ម៉ី ឡាក អ្វៃ រសានែង អន់ឌែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","អន់ឌែ អូ ប៉្រគ័ គួប លូ មួត បក់ អូ ដាគ់ ឡាក់ អូ ត្រគ់ ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ អុះ ហះកា អន់ឌែ ប៉្រគ័ គួប ដឹង បក់ ចំ ឡាក អ្លុ អ្យិល កូត័ កា ប‌៉្រ័ះ ប៊កកាតយ័ ។ ផា អន់ឌែ សាញ៉ា សារ ញ៉ា កាតាម យ៉ះ អន់ឌែ ត្រគ់ លុប ប៉ុប ចំ កាតាម កា ខំ ប៉្រគ័ ពួយ ឡាក កា ប៉ានឹរ អន់ឌែ រ៉ះ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","ផា អន់ឌែ អន់ លៀន កា ពូ បុល អន់ឌែ អូ ដក អុះ លូ អូ ចៃ អ្យក់ លៀន ពូ ច្វាល់ ប៉្រើ អន់ឌែ ចៃគ ថូត បក់ ចំ ឡាក អូ ទី សារ យច ដេល។ បក់ ចំ ប៉្រគ័ សារ ដាគ់ បក់ ណោះ ចឹង ទី សារ សាណុក សាវ៉ាក តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","អញ់ស៊ែ ដាវីត អឺ ប‌៉្រ័ះ តាំងឡា ប៉រ់ អីស ប៉ងកាន់ អាញ់ ណើ ខង អាញ់ ឡាំ អ្វៃ ម៉ឹង អីស ហង។ ");
INSERT INTO tpu_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អីស ហង ឡាក់ ប‌៉្រ័ះ តាំងឡា អាញ់ សារ ដាគ់ អាញ់ ទិណោ័ះ ឡាច់ ឡឹង អីស ហង។ ");
INSERT INTO tpu_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","ប៉ាសុន អីស ឡាក់ អ្វៃ ពឹង ប៉ាថេត អន់ឌែ ឃឺ ប៉ាណូស ដាគ់ ខាក់ ឡាក់ ត្រគ់ ពុត អាញ់ ហង។ ");
INSERT INTO tpu_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","ហ៊ែង ឡាំបាក តាទឹច បក់ ប៉ិច ឡាំ ប៉ានេ សាំប‌៉័ះ ប‌៉្រ័ះ អន់ទៀគ អាញ់ អូ ចៃ ស្រោច ផាម អន់ កា ប‌៉្រ័ះ អន់ឌែ ណោះ អុះ អាញ់ កា អូ ចៃ ម៉ន់ ប៉ានេ ប‌៉្រ័ះ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","អីស ហង ពៀប ឡាក់ កា ចានែក ប៉ាដក់ ប៉ាជៀ ម៉ះ អាញ់ ស៊ុត កា អីស ហង អន់ អាញ់ ទី សារ ដាគ់ ប៉ាគ់ យ៉ាង័ តោ័ ទៀ អីស ចឹង រ៉ាំងហៃ សារ អាញ់ លើយ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","អីស អន់ អាញ់ ទី ចារ ដាគ់ រ៉គ់ ប៉ាដក់ ប៉ាជៀ អាញ់ គឹត ខា តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","អឺ ប‌៉្រ័ះ ប៊កកាតយ័  អាញ់ ប៉ានេ អីស ហង ខង អីស រ៉ះ សារ ហ្យាំង សាឡាច់ កាប៉ាច់ ពុត អាញ់ កា រ៉ះ ផះ កាម៉ាំង អន់ សាំងកៃ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","អឺ ប‌៉្រ័ះ ប៊កកាតយ័  អាញ់ កាចាំង កា អីស អ្វៃ អន់ឌូ លូ អាញ់ លើយ អីស អ្វៃ គែង សាម៉ា ប៉ងកាន់ អាញ់ អូ អន់ អាញ់ អ្យូគ រ៉ារ៉ៃត អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","ខ អា ហង បះ ពុត អាញ់ ហោក រ៉គ់ ប៉្រគ័ អន់ ឡាកោ ប៉ាំងឡៃ អាញ់ អ្វៃ សាណុក សាវ៉ាក ខាក់ ");
INSERT INTO tpu_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","ខង អីស អូ ចាក អ្លាត អាញ់ ពឹង ស្រុក ប៉ាទ្រូ លូ អូ អន់ ប៉ាណូស ដាគ់ ម៉ះ អីស ជឹរ អ្វៃ ពឹង ឡូះ ចារ ពូ គ្រន ប៉ាង៉ាត័ ប៉ាណូស តោ័។ ");
INSERT INTO tpu_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","អីស តាំបាង អន់ អាញ់ អ្លុ ទ្រង ឡាំ ប៉ាគ់ ចារ ទី អាញុ រ៉ីស អីស អ្វៃ អន់ឌូ លូ អាញ់ បះ អាញ់ ហោក រ៉គ់ ខាក់ អាញ់ អ្វៃ គែង សាម៉ា អីស ឃឺ សាណុក សាវ៉ាក លើយ។ ");
INSERT INTO tpu_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អីស សាំយ៉ាំង សារ អាញ់ ប៉រ់ ឡាក់ ដាគ់ ត្រគ់ ប៉រ់ អីស ឃឹត ឡឹង ប៉ានឹរ អាញ់ អង់ហ្យាំង ប៉រ់ អីស សាំយ៉ាំង ប៉ានឹរ ពឹរ កាង ឡាក់ អាញ់ ម៉ន់ ឡោម អីស ឡាក់ ឡាច់ ឡឹង ពុត ដាគ់ ត្រង់។ ");
INSERT INTO tpu_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","ប៉រ់ អីស តាត់ស៊ិន សារ អាញ់ អន់ ត្រង់ ខង អីស ហៃ ប៉ប័ ទិណោ័ះ សារ ញ៉ា ឡាក់ ដាគ់ ត្រគ់។ ");
INSERT INTO tpu_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","អីស អ្លុ អន់ហ្នាល់ ពុត អាញ់ ខង អីស សាគ់ លួង ពុត អាញ់ កេះ យ‌៉័ះ កាម៉ាំង កា អីស ហៃ ហះកា អូ ប៉ប័ សារ អូ ដាគ់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","អាញ់ អ្យក់ ពុត ចៃគ ប៉្រគ័ ពួយ ប៉ានឹរ អីស ទឹប អាញ់ សាំងកៃ ឡាកោ អូ ប៉្រគ័ ពួយ សារ អូ ដាគ់ ឡាក់ កា បក់ អន់ទៀគ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","អាញ់ ប៉្រគ័ ពួយ ប៉ានឹរ អីស លើយ កាណុង ពុត អាញ់ អូ ឃឹត កា សារ អន់ទៀគ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អាញ់ ម៉ន់ ឡោម ឡា អីស ខង អាញ់ ឃឹត ផា អីស ចឹង រ៉ះ កា អាញ់ ប៉រ់ អីស សាំយ៉ាំង ប៉ានឹរ ពឹរ កាង អាញ់ ណើ។ ");
INSERT INTO tpu_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អីស ឃើយ តង័ ទិ មួត បក់ ម៉ឹង សារ អំរ៉ាញ អឺញ អីស អន់ អន់ឌែ រ៉ាវ៉ាច់ ឡឹង សារ ពូ ប៉្រគ័ បាប អន់ឌែ ទឹល នីណោ័ះ ប៉រ់ អីស តាំប៉ាង ពុត ប៉ិច ចៃ។ ");
INSERT INTO tpu_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","ប៉រ់ អីស រ៉ាំងហៃ អាញ់ រ៉ាវ៉ាច់ ឡឹង មួត អូ ដាគ់ ឡាក់ ចឹង ប៉ាន់តោ័ អាញ់ អន់ឌែ ណោះ ហង ឡាក់ តាម៉ឺរ អាញ់ ទឹប វ៉ិង ជុំ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","ពុត ពៀក អន់ឌែ អូ តាប៉ាប អូ តាប៉ុន អុះ ប៉ានឹរ ពឹរ កាង អន់ឌែ កាប ដឹង សារ អ្វាត់ អេង។ ");
INSERT INTO tpu_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","កិញអៀ អា អន់ឌែ តាយ៉ិប វ៉ាង ជុំ អាញ់ អន់ឌែ ប៉ាញ់ចាក័ ហៃ អាញ់ ចឹង ប៉ាន់តោ័ ");
INSERT INTO tpu_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","អន់ឌែ ពៀប ឡាក់ កា ប៊ក ចឹង កាប់ សា ឡាក់ កា ក្លា ក្រាប់ ចឹង កាប់ អូស។ ");
INSERT INTO tpu_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អីស កាន់ទឹង ទ្រង អន់ឌែ ទឹប ថាំឡាយ សារ អន់ឌែ ប៉្រគ័ ណោះ ទឹប តង័ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង មួត អូ ដាគ់ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អីស តង័ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង ប៉ាណូស អូ ដាគ់ ពឹង តេះ អា ញន កា អំរ៉ាញ អឺញ អីស។ ប៉រ់ អីស ចៃគ ថូត អន់ឌែ អន់ ថុក ប៉ាណាប លើយ ទឹល គន សោ អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","កាប៉ាច់ អាញ់ ឃឹត ផា ចឹង ប៉ប័ ម៉ូះ ម៉ាត់ អីស ហង ខង អាញ់ អូ ទី ប៉្រគ័ យច អុះ ផះ អាញ់ អ្យូវ ឡឹង តៃប អាញ់ ហោក រ៉គ់ កាខាក់ ហះ ម៉ាត់ អីស (ខង អីស អ្វៃ អន់ឌូ លូ អាញ់ រឺ អាញ់ ប៉ប័ អីស)។ ");
INSERT INTO tpu_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","អ៊ែ កាប ណាវ្គ ផា៖ អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អាញ់ ប៉ិច កា អីស ខាក់ ខង អីស ហង ឡាក់ សាងុំ អាញ់ ");
INSERT INTO tpu_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ កា អំហ្មោ តីស កាខាក់ អីស ហង ឡាក់ ប‌៉្រ័ះ តង័ អាញ់ ខង អីស ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ឃឺ ប‌៉្រ័ះ ម៉ះ អាញ់ ទឹប អីស ឡាក់ អំហ្មោ អាញ់ កាដាប លូ សាណៃង ទឹប ខៃល តង័ កាន់ទឹង អាញ់ ទឹប អីស ឡាក់ កា ចារ កាង័ កាចាប័ ឡាក់ អាញ់ ម៉ុត អោន (?) ");
INSERT INTO tpu_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","ផះ អាញ់ ម៉ន់ អើ ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ តង័ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង មួត តាម៉ឺរ អាញ់ ណោះ ហង បះ អាញ់ ប៉រ់ ប៉ានេ អ៊ែ ");
INSERT INTO tpu_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","សារ តោ័ អ្វៃ ជុំ អាញ់ កាប៉ាច់ សារ ចុនចៃ កា ពឹះ ទឹល ដេល ឡាក់ កា ទៀក ហូរ័ ថាំង ");
INSERT INTO tpu_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","សារ តោ័ វ៉ិង ជុំ អាញ់ ឡាក់ កា ជៀល ពូ ត្រេះ ពឹង អាញ់ ");
INSERT INTO tpu_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","ផះ ទី សារ ថុក ឡាំបាក អាញ់ កា ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ពឹង រ៉ោង រ៉ាម៉ះ អ៊ែ ឡាក់ ប‌៉្រ័ះ អាញ់ លូ អ៊ែ កា កាតាំង ប៉ានឹរ អាញ់ អង់ហ្យាំង ឡុង អើ ប៉្រើ អ៊ែ តង័ ");
INSERT INTO tpu_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","ផះ ណោះ អង់កក់ តេះ កា រ៉ាន់ថើគ ប៉ានឹម ទិណោ័ះ កា រ៉ារ៉ៃត ញន កា ប‌៉្រ័ះ ប៊កកាតយ័ អឺក ");
INSERT INTO tpu_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","ទី អ្យី អុញ ហុយ ឡាច់ ឡឹង ត្រោម ម៉ូះ លូ ទី អំប៉្យិត អុញ ទឹប ទី ង៉ារ អុញ ឡាច់ ឡឹង ពឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ដេល ");
INSERT INTO tpu_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ ប៉្លៃង សានែង កេះណោះ ជឹរ ពឹះ ទឹប ទី កាម៉ល់ (ម៉ូ តុត តីស) ម៉ាម៉ាំង ម៉ាមត អ្វៃ អន់តេ័ះ ជុង អ៊ែ ");
INSERT INTO tpu_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","ប‌៉្រ័ះ ប៊កកាតយ័ ជិះ ពឹង ចេរូប៊ីន ប៉ារ់ ឡាំ ពួយ ខ្យាល ខ្យាល តឹ អ៊ែ (?) ឡាក់ កា សៃម ប៉ារ់ ");
INSERT INTO tpu_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","អ៊ែ កាន់ទឹង ឡាកោ លូ ម៉ាម៉ាំង ទឹប ប៉្រគ័ ចារ អ្វៃ លូ (តើម បី ម៉ូ ម៉ិត) ញន កា កាម៉ល់ ម៉ូ ម៉ិត ណោះ កាពុល ទឹប ទី ទៀក អ្វៃ ជុំ អ៊ែ ");
INSERT INTO tpu_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","ទឹប ទី (កាំឡាត) តេះតរ់ ឡាច់ ឡឹង កាម៉ល់ តាតារ ក្លាគ់ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ទឹប ទី ប៉្លៃ ម៉ារៀល លូ ង៉ារ អុញ ឡិ ជឹរ ដេល ");
INSERT INTO tpu_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","កេះណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ ទី តេះតរ់ ពឹង ប៉្លៃង (ប‌៉្រ័ះ ឡាក់ តីស ហ៊្លត អ៊ែ ប៉ាឡាច់ ប៉ានឹរ) ឡាក់ ចាំងហីគ ");
INSERT INTO tpu_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាញ់ មួត តាម៉ឺរ (លូ សាលៀស) ម៉ាគ់ អន់ឌែ តាប៉្រះ តាប៉្រោង ណោះ អន់ឌែ ចឹង អ្យូគ រ៉ារ៉ៃត ឡូត ");
INSERT INTO tpu_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","អីស កាប ប៉ាំងអ្យូគ លូ ប៉ានឹរ អីស ខ្យាល ឡាក់ ឡាច់ ឡឹង ត្រោម ម៉ូះ អីស ណោះ ផះ ណោះ ទៀក សាឡីគ សាឡាយ កា ក្លាច់ ឡាច់ ទឹប អង់កក់ តេះ កា ក្លាច់ ឡាច់ ដេល (??) ");
INSERT INTO tpu_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","ប‌៉្រ័ះ ប៊កកាតយ័ កា អន់ទឺប តី កា អាញ់ ឡឹង ប៉្លៃង អ៊ែ រ៉ុប អ្យក់ ឡាច់ អាញ់ ឡឹង ទៀក ជ្រុ ");
INSERT INTO tpu_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","ប‌៉្រ័ះ ប៊កកាតយ័ តង័ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង មួត តាម៉ឺរ ឡាក់ កេង ខាក់ លូ អន់ អាញ់ រ៉ាវ៉ាច់ ឡឹង មួត ឡាក់ អូ ណីស កា អាញ់ ទឹប មួត បក់ សាងុំ ក្វា ឡឹង អាញ់ ដេល ");
INSERT INTO tpu_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","ផះ អាញ់ ទី សារ ថុក ឡាំបាក អន់ឌែ ប៉ាណាំ គួប ចឹង ប៉ាន់តោ័ អាញ់ ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ តង័ អាញ់ ");
INSERT INTO tpu_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","អ៊ែ ប៉ាណាំ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង សារ តោ័ អ៊ែ តង័ អាញ់ ញន កា អ៊ែ ប៉ិច ចៃ កា អាញ់ ");
INSERT INTO tpu_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ ដាគ់ កា អាញ់ ត្រគ់ ពួយ សារ អាញ់ ដាគ់ ត្រង់ អ៊ែ អន់ សារ ដាគ់ កា អាញ់ ញន កា អាញ់ អូ ប៉្រគ័ សារ យច ");
INSERT INTO tpu_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","ខង អាញ់ ទី ប៉្រគ័ ពួយ ចាបាប់ អ៊ែ ទិណោ័ះ ទឹប អាញ់ អូ ឡាច់ ចាំងហាយ្គ ឡឹង ប‌៉្រ័ះ លូ អូ ប៉្រគ័ សារ អូ ដាគ់ ណោះ អុះ ");
INSERT INTO tpu_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","អាញ់ ប៉្រគ័ ពួយ ចាបាប់ អីស ទិណោ័ះ អាញ់ អូ ពឹល ចាបាប់ អីស អន់តគ់ រ៉ះ ណោះ អុះ ");
INSERT INTO tpu_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","ប‌៉្រ័ះ ប៊កកាតយ័ កា អ្លុ អន់តគ់ ផា អាញ់ អូ ទី ប៉្រគ័ ឡាឡិគ័ ឡាឡាគ័ ទឹប អាញ់ អ្លុ សាំងកៃ ឡាកោ អូ អន់ ទី សារ យច ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","ប‌៉្រ័ះ ប៊កកាតយ័ តាប៉ាប កា អាញ់ ពួយ សារ ដាគ់ ឡាក់ អាញ់ ប៉្រគ័ ញន កា អ៊ែ អ្លុ អន់តគ់ ផា អាញ់ ប៉្រគ័ សារ ដាគ់។ ");
INSERT INTO tpu_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អីស តាំបាង ពុត ដាគ់ ត្រង់ កា បក់ ពឿ ឡាក់ ដាគ់ ត្រង់ អីស តាំបាង ពុត ដាគ់ កា ពឿ ឡាក់ ទី ពុត ដាគ់ ");
INSERT INTO tpu_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","បក់ ពឿ ឡាក់ ទី ពុត ដាគ់ អីស រ៉ះ ផា ដាគ់ ដេល កាប៉ាច់ បក់ ទី ពុត អូ ត្រង់ អីស រ៉ះ ផា អូ ដាគ់ ដេល ");
INSERT INTO tpu_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","ខង អីស ហង តង័ បក់ អូ គឹត អូ ខា ហះកា អីស ប៉្រគ័ អន់ បក់ ពឿ ឡាក់ អ្វាត់ អេង កើត អូ រ៉ាឡា អូ រ៉ាឡយ់ ឡគ ");
INSERT INTO tpu_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អាញ់ អីស ហង ឡាក់ សារ តាតារ ទឹប អីស តាក់ តាតារ ពឹង ចារ (?) ម៉ាម៉ាំង កា អាញ់ ");
INSERT INTO tpu_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","ប‌៉្រ័ះ ប៊កកាតយ័ អន់ អាញ់ ទី សាងុំ តាកូះ លូ មួត តាម៉ឺរ ទឹប អន់ អាញ់ ទី សាងុំ ប៉្លង់ រ៉ាវ៉ាច់ ប៉ាន់ទៀយ មឿង អន់ឌែ ណោះ ដេល ");
INSERT INTO tpu_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","ទ្រង ប‌៉្រ័ះ ប៊កកាតយ័ ដាគ់ កាខាក់ សារ អ៊ែ សាញ៉ា ស៊ុត កា ដាគ់ ត្រង់ ទិណោ័ះ ដេល អ៊ែ ពៀប ឡាក់ កា ខៃល ប៉ងកាន់ កាន់ទឹង បក់ ពឿ ឡាំ ម៉ឹង អ៊ែ ");
INSERT INTO tpu_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","ដឹង ប‌៉្រ័ះ ប៊កកាតយ័ ហង ឡាក់ ពឹ តាង ឡា ទី ដឹង អ៊ែ ហង ឡាក់ អំហ្មោ តីស អាញ់ ចឹង ម៉ុត កាន់ទឹង ");
INSERT INTO tpu_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ អាញ់ ទី សាងុំ ទឹប អ៊ែ ប៉្រគ័ អន់ ទ្រង (?) អាញ់ ដាគ់ កាខាក់ ដេល ");
INSERT INTO tpu_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","អ៊ែ ប៉្រគ័ អន់ អាញ់ អ្លុ សាតាក់ ប៉្រាល់ ឡាក់ កា ជឹល លូ អ៊ែ រ៉ាំងហៃ អាញ់ ទី សារ សាណុក សាវ៉ាក (?) ផះ អ្វៃ ពឹង ប៉ានឹម ប៉ាណ័ះ ");
INSERT INTO tpu_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាំងហៀន អាញ់ អន់ អ្លុ តាកូះ ប្ល‌៉័ះ លូ ប៉្រគ័ អន់ អាញ់ ដាម័ រ៉ាយ្គ ស្រាគ់ សាប៉ាន័ ឡាក់ រ៉ាក់ កាខាក់ ");
INSERT INTO tpu_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អីស ហង រ៉ាំងហៃ អាញ់ ទឹប អីស តង័ អាញ់ លូ អំរ៉ាញ អឺញ ម៉ះ អីស លូ អីស ប៉ាំងហោក (?) អាញ់ ញន ពុត អីស ប៉ិច ចៃ ");
INSERT INTO tpu_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","អីស ទី តាំបាង កេះ ទ្រង អាញ់ ចាក ម៉ាគ់ ជែ អន់ ជុង អាញ់ សាលឹម ប៉ក់ ");
INSERT INTO tpu_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","អាញ់ តាយ៉ិប រ៉ុប មួត តាម៉ឺរ ប៉ាគ់ ទី កេះ អូ វ៉ីល សឹត អុះ ឡាំ លើយ ទឹល ទី ថាំឡាយ ទិ ឡូត។ (អាញ់ ចឹង តាយ៉ិប រ៉ុប មួត តាម៉ឺរ អន់ ទី អាញ់ អូ វ៉ីល សឹត អុះ អាញ់ ចឹង ថាំឡាយ អន់ ទិ ឡូត) ");
INSERT INTO tpu_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","អាញ់ កោះ ប៉ាន់តោ័ អន់ឌែ អូ អន់ អន់ឌែ រ៉ាវ៉ាច់ ឡាកោ អុះ អន់ឌែ ប៉ក់ តោ័ ហះ ជុង អាញ់ ");
INSERT INTO tpu_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","ប‌៉្រ័ះ ប៊កកាតយ័ អន់ អាញ់ ទី សាងុំ តាកូះ ប្ល‌៉័ះ លូ មួត តាម៉ឺរ ទឹប ទី ទ្រង អាញ់ ");
INSERT INTO tpu_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ មួត តាហាន អន់ឌែ សាតាក់ តាប៉្រះ តាប៉្រោង ហះ ម៉ាត់ អាញ់ ទឹប អីស ប៉្រគ័ អន់ មួត បក់ អូ ណីស កា អាញ់ តោ័ ទិ ");
INSERT INTO tpu_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","អន់ឌែ អើ ណាំង ពូ តង័ ហះកា អូ ទី ពឿ ចឹង អន់ឌែ អុះ អន់ឌែ អើ ប‌៉្រ័ះ ប៊កកាតយ័ ហះកា ប‌៉្រ័ះ អូ តើល កា អន់ឌែ អុះ ");
INSERT INTO tpu_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","អាញ់ ថាំឡាយ អន់ឌែ ហាច់ ឡាក់ កា កាបក់ តេះ តាប៉ើះ កា ខ្យាល អាញ់ ចគ័ ប៉្លៃន អន់ឌែ ឡាក់ កា ចគ័ តេះ ត្រប់ ពឹង ទ្រង។ ");
INSERT INTO tpu_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","ប‌៉្រ័ះ ប៊កកាតយ័ តង័ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង សារ មួត ប៉ាសុន ប៉ាសាំង ទឹប អីស ប៉្រើ អាញ់ ប៉្រគ័ ម៉ៃគ ណាំផា សុនសាត អន់ទៀគ ឡាក់ អាញ់ អូ ឃើយ អន់ហ្នាល់ ឡឹង សើគ ពែ អន់ អ្វៃ អន់តេ័ះ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","សុនសាត អន់ទៀគ សាំយ៉ាំង ប៉ានឹរ អាញ់ ផះ អាញ់ កាប ម៉ោញ នឹរ អន់ឌែ កា ប៉្រគ័ ពួយ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","មួត សុនសាត អន់ទៀគ អន់ឌែ អ្យូគ រ៉ារ៉ៃត ឡាច់ ឡឹង ចារ អន់ឌែ កាដាប (?) ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ទី អាញុ រ៉ីស លើយ អីស ឡាក់ អំហ្មោ តីស អាញ់ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ អីស ហង ឡាក់ បក់ តង័ អាញ់ ");
INSERT INTO tpu_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","ខង ប‌៉្រ័ះ ប៊កកាតយ័ ហង ប៉្រគ័ អន់ ទី ទ្រង អាញ់ លូ មួត តាម៉ឺរ ទឹប អីស ប៉្រគ័ អន់ សុនសាត អន់ទៀគ អ្វៃ អន់តេ័ះ អាញ់ ដេល ");
INSERT INTO tpu_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","ប‌៉្រ័ះ ប៊កកាតយ័ ហង តង័ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង តី មួត តាម៉ឺរ អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អីស អន់ អាញ់ អ្វៃ សាណុក សាវ៉ាក រ៉ាវ៉ាច់ ឡឹង មួត ចឹង ឡាំ តាកូះ លូ អាញ់ ទឹប អីស រ៉ាំងហៃ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង មួត ខូយ ប៉ាអ្យប់។ ");
INSERT INTO tpu_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","ញន ណោះ ហង បះ អាញ់ ប៉ានេ អីស ហះ ម៉ាត់ សុនសាត អន់ទៀគៗ អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អាញ់ ចាជែ ប៉ានេ សិច អីស។ ");
INSERT INTO tpu_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","អីស អន់ សារ អំរ៉ាញ អឺញ ម៉ាគ់ តង័ បក់ អីស ប៉្រើ ប៉្រគ័ សាដាច់ អីស តាំប៉ាង សារ ប៉ិច ចៃ កា បក់ អីស ជ្រោ សាងី ឃឺ ពឹង សាដាច់ ដាវីត ទឹប គន សោ អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","អញ់ស៊ែ ដាវីត ប៉ាហ្យើ អន់ កា ម៉ៃគ ណាំផា អញ់ស៊ែ។ ប៉្លៃង តាំបាង ឡឹង សារ តាតារ ក្លាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ កាម៉ល់ តាំបាង ឡឹង ង៉ារ ប‌៉្រ័ះ ប៉ាំងកើត ");
INSERT INTO tpu_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","រ៉ប់ ដារ់ តាំបាង អន់ ប៉ាណូស ប៉ប័ សារ តាតារ ក្លាគ់ រ៉ប់ ម៉ាំង ប‌៉្រ័ះ ប៉ិច តាំបាង អន់ កា ប៉ាណូស ប៉ប័ ង៉ារ អ៊ែ ប៉្រគ័។ ");
INSERT INTO tpu_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","ហះកា ប៉្លៃង អូ កាប គុន សុនសាត ញ៉ា លើ កា អូ ទី ប៉ានឹរ រ៉ះ អុះ លើ កា អូ កាតាំង ញ៉ា ដេល ");
INSERT INTO tpu_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","ហះកា សារ អន់ឌែ រ៉ះ ណោះ ទី ប៉ាញ័ ទឹប អង់កក់ តេះ លូ ទឹល ប៉ាគ់ ឡាណុច តេះ។ ");
INSERT INTO tpu_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","ហះកា ដារ់ ឡាច់ រ៉ប់ ដារ់ ពៀប ឡាក់ កា ក្លោ ឡាច់ ឡឹង កាណុង ចារ តៃប ទឹប ហោក រ៉គ់ ចឹង ឡាំ សាតាក់ ប៉ាលួង ប៉ាណាំង ឡាក់ កា ប៉ាណូស បក់ កេង ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","ដារ់ ឡាច់ ឡឹង ឡាណុច ប៉្លៃង គែង អំប៉ាំង ម៉ុត ប៉ាគ់ ឡាណុច ប៉្លៃង គែង អន់តេ័ះ អូ ទី កាណាគ័ ញ៉ា ចឹង សាគឹម ឡឹង តុ ដារ់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","ចាបាប់ ប‌៉្រ័ះ ដាគ់ កាខាក់ ប៉្រគ័ អន់ ពុត អាញ់ ទី សាងុំ ណាវ្គ សារ ប‌៉្រ័ះ អន់តគ់ ប៉ាតោ ពិន ត្រគ់ ម៉ឹង ទឹប ប៉្រគ័ អន់ ប៉ាណូស កាតូល័ ង៉ល់ កើត ហ្យាំង សាឡាច់។ ");
INSERT INTO tpu_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","សារ ប‌៉្រ័ះ អន់តគ់ រ៉ះ ស៊ុត កា ដាគ់ ត្រគ់ ទិណោ័ះ ប៉្រគ័ អន់ ពុត ហោក រ៉គ់ សារ អ៊ែ ប៉្រើ កា ដាគ់ កាខាក់ និះទៅ ដេល ប៉្រគ័ អន់ ខំឃឹត ពុត ពៀក អ្លុ ហ្លង់។ ");
INSERT INTO tpu_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","សារ អ្យិល កូត័ អ្យូគ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ សារ ដាគ់ កាខាក់ លូ អ្វៃ ឡើយ ខង ចាបាប់ ប‌៉្រ័ះ ស៊ុត កាដាគ់ ត្រង់ ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","សារ ទិណោ័ះ ដាគ់ ខាក់ ក្វា ឡឹង ម៉ាស សាំ លូ អាម ក្វា ឡឹង ទៀក សុត ឡាក់ ហូរ័ ឡាច់ ឡឹង ម៉ល់។ ");
INSERT INTO tpu_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","សារ ទិណោ័ះ តាគ់ តាតារ ម៉ូះ ម៉ាត់ អាញ់ ឡាក់ ទុច ប‌៉្រ័ះ ប៊កកាតយ័ ញន កា ប៉្រគ័ ពួយ ណោះ ហង បះ អាញ់ ទី សារ ដាគ់ កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","អូ ទី បក់ ពឿ អ្លុ អន់ហ្នាល់ សារ យច ឡាកោ ទៅ ឡាក់ អូ ប៉ិច ប៉្រគ័ ណោះ អុះ អឺ ប‌៉្រ័ះ ប៊កកាតយ័ តង័ អាញ់ ណើ អន់ រ៉ាវ៉ាច់ ឡឹង សារ យច ឡាក់ អាញ់ ហៃ អូ ប៉ប័ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","ប៉រ់ អីស រ៉ាំងហៃ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង ពុត អ្វាត់ អេង ជែ អន់ ពុត អ្វាត់ អេង អា ប៉្រគ័ ម៉ៃគ ណាំផា អាញ់ ដៃ ណោះ អាញ់ ចឹង ដាគ់ ត្រង់ លូ រ៉ាវ៉ាច់ ឡឹង សារ យច តីស អា។ ");
INSERT INTO tpu_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អីស សាំយ៉ាំង ប៉ានឹរ ពឹរ កាង អាញ់ រ៉ះ កា អីស លូ ពុត ពៀក អាញ់ ឃឹត ខង អីស ពៀប ឡាក់ កា អំហ្មោ តីស អាញ់ កាន់ទឹង ទឹប អីស តង័ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","អន់ ប‌៉្រ័ះ រ៉ះ កា អីស ឡឹង សារ ចឹង កើត រ៉ាចក រ៉ាចល់ លូ អន់ ប‌៉្រ័ះ យ៉ាកុប រ៉ាំងហៃ អីស​។ ");
INSERT INTO tpu_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","អន់ ប‌៉្រ័ះ តង័ អីស ឡឹង រ៉ោង រ៉ាម៉ះ អ៊ែ លូ អន់ ប‌៉្រ័ះ រ៉ាំងហៃ អីស ឡឹង ប៉ានឹម ស៊ីយ៉ូន។ ");
INSERT INTO tpu_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","អន់ ប‌៉្រ័ះ កាចាំង កា កាណាគ័ ឡាក់ អីស មប ទឹប អន់ ប‌៉្រ័ះ ប៉ាញ័ ពុត កា កាណាគ័ ទិណោ័ះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","អន់ ប‌៉្រ័ះ អន់ ទិ សារ ញ៉ា ឡាក់ ពុត អីស ប៉ិច ទឹប ផិនកាន ញ៉ា ឡាក់ អីស ចឹង ប៉្រគ័ ណោះ អន់ កេះ ទិណោ័ះ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","ញឹន ហោក រ៉គ់ កាខាក់ ញន កា សាណ័ះ ទ្រង អីស ទឹប ចឹង ប៉ាន់តាវ ហាវ ថុង (?) ញន ប‌៉្រ័ះ ប៊កកាតយ័ អន់ គ្រឹប សារ ញ៉ា ឡាក់ អីស ប៉រ់។ ");
INSERT INTO tpu_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","កិញអៀ អា អាញ់ អ្លុ ឡាក់ កេះ ផា ប‌៉្រ័ះ ប៊កកាតយ័ តង័ អីស ឡាក់ បក់ អ៊ែ រ៉ើស ប៉្រើ ប៉្រគ័ សាដាច់ អ៊ែ រ៉ះ កា អីស ឡឹង ប៉្លៃង ឡាក់ ចារ ដាគ់ កាខាក់ លូ អន់ សារ អំរ៉ាញ អឺញ ឡឹង តី សាម៉ា អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","កាប៉ាច់ ពូ បក់ អន់ដា ម៉ឹង កា រ៉ាតេ័ះ សេះ ម៉ះ អន់ឌែ បក់ អន់ដា ម៉ឹង កា ហាន (?) តាកូះ ប្ល‌៉័ះ ហះកា កា ប៉ាច ពិន ម៉ឹង អំរ៉ាញ អឺញ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ ពិន។ ");
INSERT INTO tpu_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","អន់ឌែ ចឹង សាតាក់ តាប៉្រះ តាប៉្រោង ហះកា កាប៉ាច់ ពិន ចឹង អ្វៃ តាវ ម៉ោញ ចារ។ ");
INSERT INTO tpu_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ តង័ សាដាច់ ញឹន ណើ ផះ ញឹន អើ ឡោម អីស ប៉រ់ អីស តើល កា ញឹន ណើ។ ");
INSERT INTO tpu_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អាញ់ ហោក រ៉គ់ ខាក់ ញន សារ អីស ប៉ិច ចៃ ខាក់ (?) អីស អន់ អាញ់ សាណ័ះ ទ្រង អាញ់ លូ មួត តាម៉ឺរ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","អីស អន់ គ្រឹប កាណាគ័ ញ៉ា ឡាក់ អាញ់ តងកាន អីស អូ ប៉ាគែក អុះ សារ ញ៉ា ឡាក អាញ់ ប៉រ់។ ");
INSERT INTO tpu_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","អីស ហាប់ អាញ់ លូ អន់ សារ ដាគ់ កា អាញ់ ទឹប អីស អន់ អាញ់ តល័ មួក ម៉ាស។ ");
INSERT INTO tpu_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","ផះ អាញ់ ប៉រ់ អន់ ទី អាញុ រ៉ីស អីស កា អន់ កា អាញ់ ទី អាញុ រ៉ីស ទុញ។ ");
INSERT INTO tpu_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","ញន កា អីស តង័ អាញ់ កេះ ទឹប អីស អន់ អាញ់ ទី សារ លៅ លែង លូ ប‌៉្រ័ះ ប៉ាត្រង័ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","អីស អន់ អាញ់ ទី សារ ដាគ់ លើយ ញន កា អីស អ្វៃ អន់ឌូ ណោះ ហង បះ អាញ់ ទី សារ សាណុក សាវ៉ាក លើយ។ ");
INSERT INTO tpu_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","អាញ់ ម៉ឹង អេង កា ប‌៉្រ័ះ ប៊កកាតយ័ ញន កា ពុត អ៊ែ ដាគ់ ត្រង់ សារ អាញ់ រ៉ាំងហៃ រ៉ាំងខ្យា អូ រ៉ាយ រ៉ាំ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","អឺ សាដាច់ អីស ចឹង រ៉ុប ទិ មួត តាម៉ឺរ ម៉ះ អីស (ញន កា អីស ទី អំរ៉ាញ អឺញ កេង ខាក់ អីស ចឹង រ៉ុប ទិ បក់ អូ ណីស កា អីស) អីស រ៉ុប ទិ បក់ អូ ណីស កា អីស លូ តី សាម៉ា ឡាក កេង ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","ប៉ាគ់ ដារ់ អីស ជឹរ ពឹះ អីស ចឹង ថាំឡាយ អន់ឌែ ឡាក់ កា អុញ សា ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ថាំឡាយ អន់ឌែ ញន កា សារ អ៊ែ អឺក ទឹប អុញ ចឹង សា ថាំឡាយ អន់ឌែ ទិ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","អីស ចឹង ថាំឡាយ ផូង័ វ៉ាច់ អន់ឌែ អន់ ទិ ឡឹង អង់កក់ តេះ អា ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","អន់ឌែ ឃឹត គួប អន់ឌែ ចឹង ប៉្រគ័ អូ ដាគ់ កា អីស ហះកា អន់ឌែ ប៉្រគ័ អូ ដាម័ អុះ (អន់ឌែ រែវ ពុត គួប សោប ប៉្រគ័ អូ ដាគ់ កា អីស ហះកា អន់ឌែ ប៉្រគ័ អូ ដាម័ អីស អុះ) ");
INSERT INTO tpu_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","ខង អីស ប៉្រគ័ អន់ អន់ឌែ អូ ដាម័ លូ អីស រ៉ាយ្គ ស្រាគ់ ប៉ាញ់ ត្រគ់ ហះ ម៉ាត់ អន់ឌែ ។ ");
INSERT INTO tpu_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ញឹន ចឹង ប៉ានេ អីស ញន កា សារ អីស កេង ខាក់ ទឹប ញឹន ចាជែ ប៉ានេ អីស ញន កា សារ អំរ៉ាញ អឺញ អីស។ ");
INSERT INTO tpu_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","អញ់ស៊ែ ដាវីត ប៉ាហ្យើ អន់ កា ម៉ៃគ ណាំផា អញ់ស៊ែ ត្រគ់ ចាជែ ពួយ យុ «ជ្វេ យ៉ង់ ប៉ាប៉្លង់ ផះ ដារ់ ឡាច់» អឺ ប‌៉្រ័ះ ! ប‌៉្រ័ះ អាញ់ វ៉ៃ ! ញ៉ា ត្រគ់ អីស អ្លាត អាញ់ នីអៀ ? អាញ់ អើ ឡោម អីស លើយៗ ញ៉ា ត្រគ់ អីស អូ ចៃ តង័ អាញ់ ? ");
INSERT INTO tpu_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","អឺ ប‌៉្រ័ះ ឡាក់ តាំងឡា អាញ់ កាដារ់ អាញ់ ណាំង កាម៉ាំង អាញ់ អើ ហះកា អីស អូ តើល អូ អន់ អាញ់ សាណុក សាវ៉ាក អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","ហះកា អីស ឡាក់ ប‌៉្រ័ះ ដាគ់ ត្រង់ កាខាក់ សុនសាត អ៊ីស្រាអ៊ែល ប៉ានេ តាំប៉ោក ហោក កា អីស ហង។ ");
INSERT INTO tpu_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","វគ័ យ៉ាគ់ ញឹន ម៉ឹង អីស អីស កា តង័ អន់ឌែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","អន់ឌែ ម៉ន់ ឡោម អើ អីស អន់ឌែ កា រ៉ាវ៉ាច់ ឡឹង មួត តាម៉ឺរ អន់ឌែ មប អាញុ រ៉ីស ពឹង អីស អន់ឌែ កា អូ អ្វះ ឡាកោ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","កាប៉ាច់ អាញ់ ពូ ផា អាញ់ អូ ត្រគ់ ប៉ាណូស អុះ ពូ ផា អាញ់ អា ឡុងឡាំង កាំឡាំង សួន អៀង ត័ះ ប៉ាស្យាប កាប បឺង៉ាយ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","ទិ បក់ ប៉ប័ អាញ់ ពូ កាប ប៉ាឡៃវ កា អាញ់ ទិឌូ ពូ តាគ់ អង់វ៉ៃគ អន់តង់ ពឹរ ង៉ាង៉ិរ កល់ កា អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","ពូ កាប ផា «អ៊ែ ម៉ឹង ប‌៉្រ័ះ ប៊កកាតយ័ កេះ អន់ ប‌៉្រ័ះ តង័ អន់ អ៊ែ រ៉ាវ៉ាច់ ឡាកោ ពិ ផា ប‌៉្រ័ះ ប៉ិច កា អ៊ែ អន់ ប‌៉្រ័ះ តង័ អ៊ែ ហៃ»។ ");
INSERT INTO tpu_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អីស ហង អ្យក់ ឡាច់ អាញ់ ឡឹង វ៉ាច់ មើគ អាញ់ ពែ ផះ មើគ អ្វៃ តាម៉ម់ អាញ់ អីស ប៉ាណាំ អាញ់ អន់ ម៉ឹង អីស។ ");
INSERT INTO tpu_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","ឡឹង អាញ់ កើត ពែ អីស រង អាញ់ ឡឹង អាញ់ បើ ប៉ប័ តាតារ ដារ់ ពែ អីស ឡាក់ ប‌៉្រ័ះ រ៉ាំងហៃ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","កិញអៀ អា អាញ់ ទី សារ ថុក ឡាំបាក អូ ទី ពឿ ចឹង តង័ អាញ់ អុះ អីស ជែ អ្វៃ ចាំងហាយ្គ ឡឹង អាញ់ ដៃ។ ");
INSERT INTO tpu_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","ទី មួត តាម៉ឺរ អៀង ដូវ វ៉ិង ជុំ អាញ់ ឡាក់ កា រ៉ក់ តាកេះ ឡឹង ព្រី បាសាន។ ");
INSERT INTO tpu_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","អន់ឌែ កាប អឺក កាប ប៉ាំងអ្យូគ ឡាក់ កា ប៊ក ក្រាញ័ ចឹង កាប់ សា។ ");
INSERT INTO tpu_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","ឡាកោ អាញ់ ទិ សាងុំ ឡាក់ កា ពូ ជោរ ឡាច់ ទៀក ពុត ពៀក អាញ់ ឡាក់ កា ជ្រេង ហ្លច់ កាន់តីង កា តាប៉្លុច ឡាច់ ឡឹង គួប។ ");
INSERT INTO tpu_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","តាដក័ អាញ់ ក្រោះ ឡាក់ កា តេះ សាដះ អំប៉្យិត អាញ់ កា តឹត លូ អង់អើក អីស អ្លាត អន់ អាញ់ តោ័ ពឹង តេះ។ ");
INSERT INTO tpu_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","ទី មួត អូ ដាគ់ វ៉ិង ជុំ អាញ់ កេះ ឡាក់ កា តាប៉ល់ សូ តាកេះ អន់ឌែ ច្រាគ័ តាគ់ តាលុះ ជុង តី អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","អាញ់ រ៉ាំងកៃគ តាបាង កាន់តីង ហត់ រ៉ាំងគឹះ មួត តាម៉ឺរ កា ប៉ាញ់ចាក័ ហៃ អាញ់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","អន់ឌែ អ្យក់ ខោ អាវ អាញ់ ជែក គួប សោប ទឹប អន់ឌែ រ៉ុប កាប៉ាច់ ភឿ អ្លុ អន់តគ់ ចឹង ទី កា ពឿ។ ");
INSERT INTO tpu_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ជែ អ្វៃ ចាំងហាយ្គ ឡឹង អាញ់ អឺ ប‌៉្រ័ះ ឡាក់ អន់ សាងុំ កា អាញ់ ពឹះ តង័ អាញ់ ស៊្រសៗ ណើ។ ");
INSERT INTO tpu_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","អន់ អាញ់ រ៉ាវ៉ាច់ ឡឹង ដាវ ពូ លូ អន់ រ៉ាវ៉ាច់ ឡឹង កានៀង សូ។ ");
INSERT INTO tpu_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","ប៉រ់ អីស តង័ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង ពឹរ ប៊ក លូ អន់ រ៉ាវ៉ាច់ ឡឹង អង់គែ កាប៉ូវ ព្រី។ អូ អីស សាំយ៉ាំង អាញ់ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","អាញ់ ចឹង រ៉ះ សារ អីស កា អុះ ម៉ី អាញ់ អាញ់ ចឹង ចាជែ ប៉ានេ អីស ពឹង ចារ ពូ លួម។ ");
INSERT INTO tpu_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","កាប៉ាច់ អន់ដីស ឡាក់ អ្យិល កូត័ អ្យូគ កា ប‌៉្រ័ះ ប៊កកាតយ័ ហគ់ ចាជែ ប៉ានេ អ៊ែ ពិ អឺ ផូង័ វ៉ាច់ យ៉ាកុប ទិឌូ ហគ់ ប៉ានេ សារ អំរ៉ាញ អឺញ អ៊ែ ពិ អឺ គន សោ អ៊ីស្រាអ៊ែល ទិឌូ ហគ់ អ្យូគ រ៉ារ៉ៃត ហះ ម៉ាត់ អ៊ែ ពិ ");
INSERT INTO tpu_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","ខង ផះ ប៉ាណូស ទី សារ ថុក ឡាំបាក ប‌៉្រ័ះ អូ បឺង៉ាយ អូ អ្វៃ គ្រឺយ អុះ អ៊ែ អូ អន់ អង់កក់ កា បក់ ថុក ឡាំបាក អ៊ែ សាំយ៉ាំង បក់ ម៉ន់ អើ អ៊ែ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","ញន កា អ៊ែ តាប៉ាប តាប៉ុន កា អាញ់ បះ អាញ់ ប៉ានេ អ៊ែ ពឹង ចារ កាំឡាំង លួម អៀង ដូវ កាណាគ័ អាញ់ បន់ ចឹង អន់ អាញ់ អ្យក់ ពុះ រ៉ាម៉ះ ប‌៉្រ័ះ ហះ ម៉ាត់ កាំឡាំង បក់ អ្យិល កូត័ អ្យូគ កា អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","អាញ់ ចឹង ជៀក បក់ ថិ ពុត ចឹត យរ អន់ឌែ ចឹង សា ប៉ាំងឡៃ អន់ឌូ លូ អាញ់ អន់ ផីគ បក់ អើ ណាំង ប‌៉្រ័ះ ប៊កកាតយ័ អន់ឌែ ចឹង ចាជែ ប៉ានេ អ៊ែ អ្យគ័ អន់ អន់ដីស ទី អាញុ រ៉ីស ទុញ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","ទិ បក់ អ្វៃ ប៉ាគ់ ឡាណុច តេះ ឡាណុច ប៉្លៃង អន់ឌែ ចឹង កាចាំង កា ប‌៉្រ័ះ ប៊កកាតយ័ អន់ឌែ ចឹង ប៉ិនពែង ពុត ម៉ុត សឿ អ៊ែ គ្រឹប ផូង័ វ៉ាច់ គ្រឹប សុនសាត អន់ទៀគៗ ចឹង ជៀក គួប ប៉ានេ សាំប‌៉័ះ ប‌៉្រ័ះ ប៊កកាតយ័ ");
INSERT INTO tpu_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","ខង ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ សាដាច់ រ៉ាំងហៃ រ៉ាំងខ្យា គ្រឹប ប៉ាថេត ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","ទិ មួត ប‌៉្រ័ះ ប៉ាត្រង័ ពឹង អង់កក់ តេះ អន់ឌែ សា សាណា កេះណោះ សាំប‌៉័ះ ប‌៉្រ័ះ ហង ទិ បក់ តោ័ តប់ ពឹង តេះ អន់ឌែ ចឹង ជន តាកុល ហះ ម៉ាត់ អ៊ែ ឃឺ ទិ បក់ អូ អ្លុ រ៉ាំងហៃ ឡាកោ អន់ អ្វៃ រ៉ីស។ ");
INSERT INTO tpu_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","ប៉ាណូស រ៉ាំងហាវ អន់តីគ ចឹង ប៉្រគ័ ង៉ារ កា ប‌៉្រ័ះ ពូ ចឹង រ៉ះ សារ អ៊ែ កា គន សោ ពូ។ ");
INSERT INTO tpu_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","យ‌៉័ះ បក់ បើ កើត អន់ឌែ ចឹង កាតាំង លៅ សារ អ៊ែ ដាគ់ ត្រង់ ខង អ៊ែ តង័ ប៉ាសុន អ៊ែ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","អញ់ស៊ែ ដាវីត ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ តាំងឡា រង អាញ់ ឡាក់ ចៀម អ៊ែ ទឹល នីណោ័ះ អាញ់ អូ អឹត កា ញ៉ា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","អ៊ែ អន់ អាញ់ រ៉ាឡូវ ពឹង ចារ សាម៉ោង ឡន់ ម៉ាគ់ ប៉ាអាំ ប៉ាណាំ អាញ់ ឡាំ ប៉ាគ់ ទៀក ឡាក់ ដាគ់ សាង។ ");
INSERT INTO tpu_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","អ៊ែ ប៉្រគ័ អន់ អាញ់ ហើយ ពុត ពៀក ជៀក អាញ់ ចាក ពួយ ទ្រង ដាគ់ ម៉ាគ់ អ៊ែ លៅ លែង សិច។ ");
INSERT INTO tpu_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","អឺ ប‌៉្រ័ះ យ‌៉័ះ អាញ់ ម៉ុត ទ្រង ត្រោម ណាក ចាក ទ្រង កាប៉ារ ប៊ក កាតាម កា អាញ់ អូ អ្យូគ កា ញ៉ា ហង ខង អីស អ្វៃ អន់ឌូ លូ អាញ់ លើយ ឃើយ ចឹក អ៊្លង ប៉ងកាន់ រ៉ាំងហៃ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","អីស ជៀក អាញ់ ម៉ុត ពឹង ហី អីស កេះណោះ តូះ តាពែ សៃ ពរ អន់ កា អាញ់ អីស ឡាប សាងី ពឹង កល់ អាញ់ ដាគ់ ប៉ាឡឹង ត្រឹង តាពែ ពឹង ពៀង អាញ់ ប៉ាញ័ លើយ ភឿ អន់ មួត តាម៉ឺរ ប៉ប័ ផា អីស ប៉ិច កា អាញ់ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","សារ អីស តាប៉ាប តាប៉ុន លូ ប៉ិច ចៃ អ្វៃ ពឹង អាញ់ រ៉ប់ ដារ់ លើយ ឡុច អាញុ អាញ់ ចឹង អ្វៃ ពឹង ហី អីស លើយ។ ");
INSERT INTO tpu_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","អង់កក់ តេះ លូ ទិ កាណាគ័ ញ៉ា ឡាក់ អ្វៃ ពឹង អង់កក់ តេះ ស៊ុត កា ម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ទិណោ័ះ ប៉ាណូស លូ កាណាគ័ ទី អាញុ រ៉ីស ពឹង អង់កក់ តេះ អា ស៊ុត កា ម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ ទិណោ័ះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","អ៊ែ ហង ប៉ាំងកើត តេះ កោគ លូ ម៉ាន គុល តេះ ពឹង ទៀក ជ្រុ សាឡីគ សាឡាយ ។ ");
INSERT INTO tpu_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","ពឿ ចឹង អ្លុ ហាវ ពឹង ប៉ានឹម ប‌៉្រ័ះ តាំង ឡា ? ពឿ ចឹង ម៉ុត កាណុង រ៉ោង រ៉ាម៉ះ ប‌៉្រ័ះ ។ ");
INSERT INTO tpu_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","ទី ដឹង បក់ ប៉្រគ័ សារ ដាគ់ លូ ពុត ដាគ់ ត្រង់ ទឹប អ៊ែ អូ សាំប‌៉័ះ ហ៊ូប ប‌៉្រ័ះ បឺគ លូ អូ កាប តាំព្លូង កា ពូ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","បក់ ណោះ ចឹង ទី សារ ដាគ់ ឡឹង ប‌៉្រ័ះ ប៊កកាតយ័ ទឹប ប‌៉្រ័ះ ឡាក់ តាំង ឡា តង័ អ៊ែ ចឹង រ៉ះ ផា អ៊ែ ឡាក់ ប៉ាណូស ដាគ់ ត្រង់។ ");
INSERT INTO tpu_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","បក់ ណោះ ហង ឡាក់ ប៉ាណូស ណាំង ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ វ៉គ យ៉ាកុប ។ ");
INSERT INTO tpu_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","អឺ បក់ រ៉ាំងហៃ អំប៉ារ ហគ់ បើក អំប៉ារ ពិ ហគ់ បើក អន់ តីស ម៉ាគ់ សាដាច់ ឡាក់ លៅ លែង កាខាក់ ម៉ុត អ្វៃ។ ");
INSERT INTO tpu_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","សាដាច់ ឡាក់ លៅ លែង សិច អា ពឿ អ៊ែ ណោះ? ឃឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ទី សារ អំរ៉ាញ អឺញ កេង ខាក់ អ៊ែ ហង ឡាក់ តាំ ឡា អ្លុ តាកូះ ប៉្លាស ");
INSERT INTO tpu_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","អឺ មួត រ៉ាំងហៃ អំប៉ារ ហគ់ បើក លើយ ពិ ហគ់ បើក អន់ តីស ម៉ាគ់ ប‌៉្រ័ះ ឡាក់ លៅ លែង សិច ម៉ុត អ្វៃ។ ");
INSERT INTO tpu_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","សាដាច់ ឡាក់ លៅ លែង សិច អា ពឿ អ៊ែ ណោះ? ឃឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ តាំងឡា ពឹង អង់កក់ តេះ អា អ៊ែ ហង ឡាក់ សាដាច់ លៅ លែង សិច កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អាញ់ មប ពុត ពៀក អាញ់ កា អីស។ ");
INSERT INTO tpu_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អាញ់ ប៉ាហ្យើ អាញុ រ៉ីស អាញ់ ពឹង អីស ហង ទឹល នីណោ័ះ ជែ អន់ អាញ់ តាយួស ហង លូ ជែ អន់ មួត តាម៉ឺរ ហោក រ៉គ់ ញន កា ទី ទ្រង អន់ឌែ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","មួត បក់ ម៉ឹង អីស ណោះ អូ អ្វះ ឡាកោ អុះ ទី ដឹង បក់ ព្លូង ប៉្លាច័ កា ប‌៉្រ័ះ ណោះ ហង ចឹង អ្វះ ឡាកោ។ ");
INSERT INTO tpu_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ តាំប៉ាង អន់ អាញ់ អ្លុ អន់ហ្នាល់ ឡឹង ទ្រង អីស លូ អន់តគ់ រ៉ះ កា អាញ់ ឡឹង ចារ អីស អ្វៃ។ ");
INSERT INTO tpu_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","អន់ អីស អន់តគ់ ប៉ាតោ កា អាញ់ ឡឹង សារ អ្វៃ កោប អន់ ដាគ់ ត្រង់ ឡាក់ កា ពុត អីស ប៉ិច ខង អីស ឡាក់ ប‌៉្រ័ះ តង័ អាញ់ រ៉ប់ ដារ់ អាញ់ ម៉ឹង ដឹង អីស ហង។ ");
INSERT INTO tpu_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","អឺ ប‌៉្រ័ះ តាំងឡា ឡឹង សើគ ពែ អីស អូ ពឹល តាំប៉ាង ពុត តាប៉ាប តាប៉ុន លូ ពុត ប៉ិច ចៃ កា អាញ់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","អីស ជែ កាចាំង កា សារ យច ឡាក់ អាញ់ ប៉្រគ័ ផះ អ្វៃ សាស្វា សើគ ពែ អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អីស ទី ពុត តាប៉ាប តាប៉ុន លូ ដាគ់ ពុត កា អាញ់ ឡើយ។ ");
INSERT INTO tpu_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","ញន កា អីស ឡាក់ ប‌៉្រ័ះ ដាគ់ ត្រង់ ណោះ ហង បះ អីស ប៉ាំងហៀន ប៉ាណូស អូ ដាគ់ អន់ អ្លុ ប៉្រគ័ ពួយ ពុត អីស។ ");
INSERT INTO tpu_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","អីស ប៉្រគ័ អន់ ប៉ាណូស ថិ ពុត អ្លុ ប៉្រគ័ ពួយ សារ ដាគ់ ម៉ះ អីស លូ ប៉ាំងហៀន អន់ ពូ អ្លុ អន់ហ្នាល់ ឡឹង ពុត អីស ប៉ិច។ ");
INSERT INTO tpu_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","អីស ទី ពុត តាប៉ាប តាប៉ុន កាខាក់ កា បក់ ពឿ ប៉្រគ័ ពួយ សារ សាញ៉ា រែវ ពុត លូ ប៉្រគ័ ពួយ សារ អីស អន់តគ់ ប៉ាតោ។ ");
INSERT INTO tpu_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","អឺ ប‌៉្រ័ះ តាំងឡា អាញ់ ទី សារ យច តីស ខាក់ អីស ជែ អ្យក់ យ៉ូ សារ អាញ់ ប៉្រគ័ យច ណឺ។ ");
INSERT INTO tpu_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ ហៃ អាញ់ ណើ ខង អាញ់ ប៉្រគ័ ពួយ សារ ដាគ់ ត្រង់ ម៉ះ អីស។ ");
INSERT INTO tpu_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អីស ឃឹត ចាជ្រែប លូ ប៉ានឹត ហៃ ទឹប សាគ់ លួង ពុត ពៀក អាញ់ ពិ ។ ");
INSERT INTO tpu_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","អាញ់ កាចាំង កា ពុត តាប៉ាប តាប៉ុន ម៉ះ អីស លើយ ទឹប អាញ់ ប៉្រគ័ ពួយ សារ តាទឹច អីស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","អាញ់ អូ ចៃ អង់អ្វៃ អន់ឌូ លូ ប៉ាណូស បក់ ព្លូង ប៉្លាច័ ទឹប អូ ចៃ ប៉្រគ័ គួប លូ ប៉ាណូស បក់ តាគ់ អំប៉្រគ័ ដាគ់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","អាញ់ អូ ណីស កា ប៉ាណូស អូ ដាគ់ ទឹប អូ ចៃ ប៉្រគ័ គួប លូ ប៉ាណូស អូ ដាគ់។ ");
INSERT INTO tpu_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អាញ់ រ៉ាវ តី ប៉ិច តាំបាង ផា អាញ់ អូ ទី ប៉្រគ័ យច អុះ ទឹប ចាក ជុំ ដឹង រ៉ាំងវ៉ាង ចារ រ៉ាម៉ះ អីស។ ");
INSERT INTO tpu_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","ទឹប អាញ់ ចាជែ ប៉ានេ កា សារ ដាគ់ លូ សារ អំរ៉ាញ អឺញ កេង ខាក់ ម៉ះ អីស។ ");
INSERT INTO tpu_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អាញ់ ប៉ិច ឡាំ អ្វៃ ប៉ាគ់ ចារ អីស លូ ពឹង ហី អីស ឡាក់ ចារ ដាគ់ លូ លៅ លែង កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","ជែ អន់ អាញ់ តោ័ អន់ឌូ លូ មួត បក់ អូ ដាគ់ ដៃ ទឹប ជែ អ្យក់ ឡាច់ អាញុ រ៉ីស អាញ់ អន់ឌូ លូ មួត ឌុ ប៉ាំងហូរ័ ផាម ពូ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","អន់ឌែ ឌុ ប៉្រគ័ សារ អូ ដាគ់ គ្រឹប នែវ រ៉ប់ ដារ់ ទឹប អន់ឌែ ឃើយ អ្យក់ លៀន ឡាក់ ពូ ច្វាល់ ប៉្រគ័ សារ អូ ដាគ់ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","ហះកា កាប៉ាច់ អាញ់ ប៉្រគ័ ដឹង សារ ដាគ់ លើយ ប៉រ់ អីស តាប៉ាប លូ តង័ អាញ់ ណើ។ ");
INSERT INTO tpu_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","ទឹប អាញ់ អ្វៃ ដឹង ពឹង ចារ ដាគ់ លូ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ហះ ម៉ាត់ កាំឡាំង អៀង ។ ");
INSERT INTO tpu_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ តាតារ លូ ប‌៉្រ័ះ ឡាក់ តង័ អាញ់ អាញ់ អូ អ្យូគ កា បក់ ពឿ អុះ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ចារ អាញ់ មប អាញុ រ៉ីស អាញ់ កា អូ អ្យូគ កា ពឿ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","ផះ មួត បក់ ប៉្រគ័ អូ ដាគ់ ឃឺ មួត បក់ ប៉្រគ័ យច ចាបាប់ លូ មួត តាម៉ឺរ អាញ់ អន់ឌែ ប៉ាណាំ គួប ម៉ុត ប៉ាគ់ អាញ់ ភឿ ចឹង ប៉ាន់តោ័ អាញ់ ហះកា អន់ឌែ ប៉ក់ ទិឌូ ឡូត។ ");
INSERT INTO tpu_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","យ‌៉័ះ ទី មួត តាហាន ពឹះ វ៉ាង អាញ់ កា អាញ់ អូ អ្យូគ ដេល យ‌៉័ះ ទី ពូ ឡាំ តាកូះ លូ អាញ់ កាតាម អាញ់ អ្វៃ ម៉ឹង ប‌៉្រ័ះ តាំងឡា លើយ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","អាញ់ ប៉រ់ ហះ ប‌៉្រ័ះ ប៊កកាតយ័ ដឹង សារ ម៉ោញ ខង អាញ់ ប៉ិច ដឹង កា សារ ណោះ ហង ឃឺ អន់ អាញ់ អ្វៃ កាណុង ចារ រ៉ាម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ប់ ដារ់ លើយ ឡុច អាញុ ភឿ អន់ អាញ់ (អ្យិល កូត័ អ្យូគ) លូ ញម កាខាក់ កា សារ តាតារ ក្លាគ់ ម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ លូ អាញ់ ចឹង សាំប‌៉័ះ ប៉ានេ អីស កាណុង រ៉ោង រ៉ាម៉ះ ។ ");
INSERT INTO tpu_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","ខង ផះ អាញ់ ទី សារ អ្យូគ តុ ឌួន អីស អន់ អាញ់ អ្វៃ កាណុង ចារ អីស លូ អីស អោន អាញ់ ពឹង រ៉ាណើះ (រ៉ោង រ៉ាម៉ះ) អីស លូ អីស ប៉ោក អាញ់ អន់ អ្វៃ ពឹង អំហ្មោ តាទៀរ។ ");
INSERT INTO tpu_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","កិញអៀ អា អីស (ប៉្រគ័ អន់) លឺក អាញ់ អន់ ចាំងហីគ ក្វា ឡឹង មួត តាម៉ឺរ ឡាក់ អ្វៃ វ៉ាង ជុំ អាញ់ ណោះ សាំ អាញ់ ចឹង ពុះ កាណាគ័ រ៉ាម៉ះ កាណុង (រ៉ាណើះ) ចារ អីស ទឹប កាប ម៉ៃៗ ញន កា អាញ់ ហោក រ៉គ់ អាញ់ ចឹង ចាជែ លូ ចឹង យ៉ិល ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អីស សាំយ៉ាំង ប៉ានឹរ អាញ់ អើ ណាំង អីស ប៉រ់ អីស តាប៉ាប តាប៉ុន តើល កា អាញ់ ណើ។ ");
INSERT INTO tpu_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","អាញ់ កាចាំង កា ប៉ានឹរ អីស រ៉ះ ផា៖ «ហគ់ អើ ណាំង អាញ់ ពិ» ណោះ អាញ់ តើល ផា «អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អាញ់ អើ ណាំង អីស កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","ជែ អោន កា (ម៉ូះ ម៉ាត់ អីស អូ អន់) អាញ់ (ប៉ប័) ជែ អឺក ជែ តាំងហ្យិត ឡាច់ អាញ់ ឡាក់ ប៉្រគ័ ង៉ារ កា អីស ខង អីស តង័ អាញ់ អីស ជែ អ្លាត អាញ់ អឺ ប‌៉្រ័ះ ឡាក់ តង័ អាញ់ អីស ជែ អ្លាត អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","យ‌៉័ះ មើគ ពឹ អាញ់ អ្លាត អាញ់ កាតាម ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ អីស ចឹង អ្យក់ អាញ់ អ្វៃ អន់ឌូ លូ អីស លើយ។ ");
INSERT INTO tpu_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាំងហៀន អាញ់ អន់ អន់ហ្នាល់ (?) ទ្រង អីស លូ អន់តគ់ រ៉ះ កា អាញ់ អន់ ចាក ពួយ ទ្រង ដាគ់ ទ្រង ត្រង់ ខង អាញ់ ទី តាម៉ឺរ អៀង។ ");
INSERT INTO tpu_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","ជែ មប អន់ អាញ់ ពឹង តី មួត បក់ ប៉ាសាំង លូ អាញ់ ខង ទី ផាញ៉ាន កាប ព្លូង ពឹះ ច្រោម អាញ់ មួត ណោះ កាប ស៊ុត កា ខូយ ប៉ាអ្យប់ ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","អាញ់ សឿ ផា ពឹង អង់កក់ តេះ អា អាញ់ ចឹង ប៉ប័ សារ សាណុក សាវ៉ាក ឡឹង ប‌៉្រ័ះ ប៊កកាតយ័ តាទឹច។ ");
INSERT INTO tpu_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","ហគ់ សឿ ម៉ឹង ប‌៉្រ័ះ ប៊កកាតយ័ ហគ់ អន់ ទី សាងុំ លូ ទី ពុត ខឹន ហគ់ សឿ ម៉ឹង (អ្វៃ ក្យាគ់) ប‌៉្រ័ះ ប៊កកាតយ័ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","អឺ ប៊កកាតយ័ អាញ់ ម៉ន់ អើ អីស ខង អីស ពៀប ឡាក់ កា អំហ្មោ ឡាក់ អាញ់ កាដាប ប៉រ់ សាំយ៉ាំង ប៉ានឹរ អាញ់ ម៉ន់ ណើ ផានែវ អីស អ្វៃ គ្រឺយ អូ សាំយ៉ាំង ប៉ានឹរ អាញ់ ណោះ អាញ់ ចឹង ឡិ ពឹង ឡូះ តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","ផះ អាញ់ ម៉ន់ យ៉ើរ (?) តី គែង ចារ ដាគ់ កាខាក់ ប៉រ់ អីស សាំយ៉ាំង ប៉ានឹរ អាញ់ ឡោម ឡា អីស ណើ។ ");
INSERT INTO tpu_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","ជែ អន់ អាញ់ ឡាំ អន់ឌូ លូ មួត ង៉ល់ ឌឺ លូ មួត ប៉្រគ័ សារ អូ ដាគ់ ឡាក់ កាប ដាគ់ ប៉ានឹរ ពឹរ កាង ហះកា កាណុង ពុត អន់ឌែ ទី ដឹង សារ ព្លូង ប៉្លាច័។ ");
INSERT INTO tpu_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","ហគ់ អីស ចៃគ ថូត អន់ឌែ ណោះ អន់ ត្រគ់ លូ សារ អន់ឌែ ប៉្រគ័ ណោះ ហង ពិ ឡាក់ កា សារ ព្លូង ប៉្លាច័ លូ សារ ង៉ល់ ឌឺ ណោះ ទឹប អីស ចៃគ ថូត អន់ឌែ ពួយ សារ តី អន់ឌែ ប៉្រគ័ ");
INSERT INTO tpu_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","ខង អន់ឌែ អូ ហ្លង់ ឡឹង ង៉ារការ អីស ប៉្រគ័ ណោះ អុះ ហគ់ អីស ថាំឡាយ អន់ឌែ ជែ អន់ អ្លុ អ្យូវ។ ");
INSERT INTO tpu_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","ប៉រ់ ប៉ានេ ប‌៉្រ័ះ តាំងឡា ខង អ៊ែ សាំយ៉ាំង សារ ឡាក់ អាញ់ ម៉ន់ ឡោម។ ");
INSERT INTO tpu_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","ប‌៉្រ័ះ តាំងឡា ហង ឡាក់ ប៉្រគ័ អន់ អាញ់ ទី សាងុំ លូ ឡាក់ ខៃល ឡាក់ ប៉ងកាន់ អាញ់ លូ អាញ់ ម៉ឹង កា អ៊ែ (?) ហង ឡាក់ តង័ អាញ់ ពុត អាញ់ ហោគ រ៉គ់ កាខាក់ អាញ់ ចឹង ចាជែ ប៉ានេ អ៊ែ ឡើយ។ ");
INSERT INTO tpu_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","ខង អីស ប៉ងកាន់ ប៉ាសុន អីស ទឹប អីស ឡាក់ ប៉ាន់ទៀយ តង័ សាដាច់ ឡាក់ អីស ទី រ៉ើស។ ");
INSERT INTO tpu_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","ប៉រ់ អីស តង័ ប៉ាសុន អីស លូ អន់ សារ ដាគ់ កា អន់ឌែ ណើ លូ អីស រ៉ាំងហៃ អន់ឌែ លើយ។ ");
INSERT INTO tpu_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","អឺ មួត ប៊យ ឡាក់ អ្វៃ ពឹង ប៉្លៃង ហគ់ ប៉ាណាំ គួប ប៉ានេ សារ អំរ៉ាញ អឺញ លូ ឡើ លែង (?) ប‌៉្រ័ះ ប៊កកាតយ័ ។ ");
INSERT INTO tpu_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","ហគ់ ប៉ានេ សារ លៅ លែង លូ សារ អំរ៉ាញ អឺញ ប‌៉្រ័ះ ប៊កកាតយ័ ហគ់ ប៉ាណាំ គួប សាំប‌៉័ះ ប៉ានេ ប‌៉្រ័ះ ផះ អ៊ែ តាំប៉ាង សារ ដាគ់ ត្រង់ ម៉ះ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ កាតាំង យឹង អំប៉ាំង អង់កក់ ទៀក ប‌៉្រ័ះ ទី សារ អំរ៉ាញ អឺញ ប៉្រគ័ អន់ ទី តេះតរ់ តេះ អំប៉ាំង អង់កក់ ទៀក ជ្រុ (?)។ ");
INSERT INTO tpu_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ កេង ដាគ់ ខាក់ លូ អំរ៉ាញ អឺញ ទឹប លៅ លែង ដេល (?)។ ");
INSERT INTO tpu_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ តើម ប៉ាយ៉ាង័ ហ្រាច ពឹង ប៉ានឹម លី បង់ ប៉ាក់ តាប្រូគ។ ");
INSERT INTO tpu_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","ប‌៉្រ័ះ ប៉្រគ័ អន់ តើម អ៊្លង ទិណោ័ះ ប៉្លង់ ឡាក់ កា រ៉ក់ ទឹម (?) អ៊ែ ប៉្រគ័ អន់ ប៉ានឹម លី បង់ លូ ប៉ានឹម ស៊ីរ៉ាន ប៉្លង់ ឡាក់ កា កាប៉ូវ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","ប៉ានឹរ ប‌៉្រ័ះ ប៉្រគ័ ឡាក់ កា កាំឡាត តាតារ ក្លាគ់ (?)។ ");
INSERT INTO tpu_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","ប៉ានឹរ ប‌៉្រ័ះ ប៉្រគ័ អន់ ស៊្រែ តីស រ៉ាន់ថើគ ទឹប អ៊ែ ប៉្រគ័ អន់ ស៊្រែ តីស កាដេះ រ៉ារ៉ៃត ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","ប៉ានឹរ ប‌៉្រ័ះ ប៉្រគ័ អន់ ជឹល យ៉ង់ ទី គន លូ ប៉្រគ័ ព្រី អ៊្លង ហ្រុង ហ្លា ទិ។ ផះ ណោះ កាណាគ័ ញ៉ាៗ ស៊្រែក ផា៖ «ប៉ានេ កាខាក់ កា ប‌៉្រ័ះ (?)»។ ");
INSERT INTO tpu_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ាំងហៃ ទៀក រ៉ាឡាប ទឹប អ៊ែ អ្វៃ ប៉្រគ័ សាដាច់ រ៉ាំងហៃ លើយ ។ ");
INSERT INTO tpu_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ អំរ៉ាញ កេង ខាក់ កា ប៉ាសុន អ៊ែ លូ អ៊ែ អន់ សារ ដាគ់ លូ សារ សាណុក សាវ៉ាក ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អាញ់ ប៉រ់ ប៉ានេ អីស ញន កា អីស តង័ អាញ់ ទឹប អីស កា អូ ទឹមវ៉ៃរ អន់ មួត តាម៉ឺរ កាកីក ហោក ញន កា សាណ័ះ ទ្រង អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អាញ់ អាញ់ ប៉រ់ ឡោម ឡា អីស អន់ អីស តាគ់ អន់ដាគ់ អាញ់ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អីស ប៉ាណាំ ប៉ាង៉ាត័ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង ចារ ប៉ាទ្រូ ម៉ាគ់ អាញ់ រ៉ាវ៉ាច់ ឡឹង ឡូះ ជ្រុ ឡាក់ ចារ ប៉ាង៉ាត័ ប៉ាទ្រូ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","អឺ មួត ប៉ាសុន ប‌៉្រ័ះ ហគ់ ចាជែ ប៉ានេ ប‌៉្រ័ះ ខង អ៊ែ ដាគ់ ត្រង់ ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","ខង សារ ប‌៉្រ័ះ អឺក ដឹង ម៉ោញ ទ្រុ ដោច ហះកា ពុត តាប៉ាប តាប៉ុន ម៉ះ អ៊ែ អ្វៃ លើយ។ ផះ កាម៉ាំង ទៀក ម៉ាត់ ពិន ហូរ័ ហះកា តារ កាំលឺ ពិន ហោក រ៉គ់ ណាវ្គ។ ");
INSERT INTO tpu_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","កាប៉ាច់ អាញ់ ផះ អាញ់ ទី សារ សាណុក សាវ៉ាក អាញ់ ឃឹត កាណុង ពុត ផា អាញ់ អូ សាលឹម (?) ប៉ក់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ញន សារ តាប៉ាប តាប៉ុន អីស ប៉្រគ័ អន់ អាញ់ កាង័ កាចាប័ (?) ឡាក់ កា ប៉ានឹម ហះកា ផា អីស អូ អ្វៃ អន់ឌូ អាញ់ អ្យូគ ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អាញ់ អើ ម៉ន់ អីស ទឹប ឡោម ឡា អីស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","ផានែវ អីស អន់ អាញ់ តោ័ ចឹង ទី ខា ញ៉ា ? លើ ផានែវ អីស អន់ អាញ់ ឡិ កាណុង ឡូះ ចារ ប៉ាទ្រូ ចឹង ទី ខា ញ៉ា ? ញ៉ា ប៉ាណូស តោ័ អ្លុ ប៉ានេ ប‌៉្រ័ះ ប ? ញ៉ា អន់ឌែ អ្លុ រ៉ះ ឡឹង ពុត ដាគ់ ត្រង់ ម៉ះ ប‌៉្រ័ះ ប ? ");
INSERT INTO tpu_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","អឺ ប‌៉្រ័ះ តាំងឡា ប៉រ់ អីស តាប៉ាប តាប៉ុន លូ សាំយ៉ាំង ប៉ានឹរ អាញ់ ម៉ន់ អើ អឺ ប‌៉្រ័ះ អន់ អីស តង័ អាញ់ ណើ ");
INSERT INTO tpu_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ សារ អាញ់ ញ៉ាំ សោក កេះ សារ ហោក រ៉គ់ ទឹប អីស រ៉ីស អ្លាត អាវ ក្យាគ់ អន់ត្រោ័ កេះណោះ ប៉្រគ័ អន់ អាញ់ ទី សារ ហោក រ៉គ់ ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","ទឹល នីណោ័ះ អាញ់ ចឹង ចាជែ ប៉ានេ អីស ខង អីស ប‌៉្រ័ះ អាញ់ អាញ់ ចឹង ចាជែ ប៉ានេ អីស លើយ អូ អ្វៃ តាដោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អាញ់ ប៉រ់ កាដាប (?) ពឹង អីស លូ ជែ អន់ អាញ់ តាយួស ហង អឺ ប‌៉្រ័ះ ឡាក់ ដាគ់ ត្រង់ ប៉រ់ អីស តង័ អាញ់ ណើ។ ");
INSERT INTO tpu_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","ប៉រ់ អីស សាំយ៉ាំង អាញ់ លូ តង័ អាញ់ ស៊្រសៗ ទឹប ប៉្រគ័ ឡាក់ កា ប៉ាន់ទៀយ កាន់ទឹង អាញ់ ទឹប តង័ អាញ់ ណើ។ ");
INSERT INTO tpu_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","ខង អីស ពៀប ឡាក់ កា អំហ្មោ លូ ប៉ាន់ ទៀយ កាង័ កាចាប័ ឡាក់ អាញ់ កាន់ទឹង ប៉រ់ អីស ប៉ាណាំ ទ្រង កា អាញ់ ញន កា សិច អីស។ ");
INSERT INTO tpu_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","ប៉រ់ អីស រ៉ាំងហៃ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង សាទួង ឡាក់ អន់ឌែ ប៉្រគ័ កា អាញ់ ខង ទី ដឹង អីស ហង ឡាក់ អាញ់ ម៉ឹង។ ");
INSERT INTO tpu_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","អាញ់ មប ប៉ាង៉ាត័ ប៉ាលឹង អាញ់ កា អីស។ អឺ ប‌៉្រ័ះ តាំងឡា អីស ហង ឡាក់ ដាគ់ ត្រង់ អីស តោះ ឡើយ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","អាញ់ មប អាញុ រ៉ីស កា អីស អាញ់ អូ ណីស កា បក់ សាំប‌៉័ះ ប‌៉្រ័ះ ឡាឡិគ័ ឡាឡាគ័ អូ ទី ខា ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","អាញ់ ហោក រ៉គ់ ខាក់ ញន កា អីស ដាគ់ ពុត កា អាញ់ ខង អីស ប៉ប័ សារ ថុក ឡាំបាក ម៉ះ អាញ់ លូ អ្លុ អន់ហ្នាល់ ឡឹង សារ អាញ់ អុក ពុត ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","អីស អូ មប អន់ អាញ់ ពឹង តី មួត តាម៉ឺរ អុះ ហះកា អីស តង័ អាញ់ រ៉ាវ៉ាច់ ឡឹង សារ អ្យូគ សារ ហ្យឹក។ ");
INSERT INTO tpu_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ តាប៉ាប តាប៉ុន កា អាញ់ ណើ ខង អាញ់ ផះ ទី សារ ឡាំបាក អាញ់ ញ៉ាំ ទឹល ស្វាត់ ទៀក ម៉ាត់ ទឹប ពុត អាញ់ កា អ្យូគ ហ្យឹក ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","អាញ់ អូ ត្រូះ អូ ថូន ខាក់ ញន កា អាញ់ អ្យូគ ហ្យឹក អាញុ រ៉ីស អាញ់ កា ចឹង ឡុច ឡាកោ អាញ់ កា អូ សាងុំ កាន់តីង អាញ់ កា ចឹង ពុក ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","មួត តាម៉ឺរ ទឹប មួត អ្វៃ រសានែង អាញ់ អន់ឌែ កាប ញគ័ អាញ់ យ‌៉័ះ មួត គួប ចាង័ អាញ់ កា អូ ខឹន ឡាំ ក្យាម័ អាញ់ ដេល ផា អន់ឌែ ប៉ប័ អាញ់ អន់ឌែ ប៉ាណាំ គួប សាតាក់ ឡាច់។ ");
INSERT INTO tpu_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","អូ ទី បក់ ពឿ កាចាំង កា អាញ់ អុះ អាញ់ ពៀប ឡាក ប៉ាណូស តោ័ លូ ឡាក់ កា កគ័ ប៉ាទុះ ឡាក់ ពូ ហឹរ អ្លាត។ ");
INSERT INTO tpu_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","អាញ់ កាតាំង ប៉ាណូស សួន អៀង ពូ កាប ព្លូង ប៉្លាច័ ច្រោម អាញ់ អ្វៃ ជុំ អាញ់ ប៉្រគ័ អន់ អាញ់ អ្យូគ ហ្យឹក ខាក់ អន់ឌែ ប៉ាណាំ គួប ប៉ាសាំង លូ អាញ់ ទឹប ជៀក គួប សោប ចឹង ឡាំ ប៉ាន់តោ័ អាញ់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អាញ់ ប៉រ់ មប អាញុ រ៉ីស អាញ់ កា អីស អាញ់ ចឹង ផា អីស ហង ឡាក់ ប‌៉្រ័ះ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","អាញុ រ៉ីស អាញ់ ពឹង តី អីស កេះ ប៉រ់ អីស តង័ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង តី មួត តាម៉ឺរ លូ មួត បក់ អូ ណីស កា អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","ប៉រ់ អីស កាលែង ហៃ គែង អាញ់ ឡាក់ ទុច អីស លូ តង័ អាញ់ ញន ពុត ដាគ់ ត្រង់ ម៉ះ អីស។ ");
INSERT INTO tpu_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អាញ់ ប៉រ់ ឡោម ឡា អីស ជែ អន់ អាញ់ តាយួស ដៃ ហះកា ប៉រ់ អីស ប៉្រគ័ អន់ ប៉ាណូស អូ ដាគ់ ណោះ អន់ឌែ តាយួស ទឹប អន់ អន់ឌែ តោ័ រ៉ុង តោ័ រ៉ាយ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","ប៉រ់ អីស ប៉្រគ័ អន់ មួត ឡាក់ កាប ព្លូង ប៉្លាច័ ណោះ កាំឡូ ញន អន់ឌែ កាប ឌឺ លូ កាប អូ ដាគ់ លូ អូ ណីស កា (?) បក់ ដាគ់ ត្រង់។ ");
INSERT INTO tpu_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ពុត អីស ដាគ់ ត្រង់ ខាក់ អីស គម កា បក់ ពឿ ឡាក់ អ្យិល កូត័ កា អីស ប៉ាណូស ទិឌូ ពូ អ្លុ អន់តគ់ ផា អីស តាប៉ាប តាប៉ុន កា ពឿ ឡាំ ម៉ឹង អីស។ ");
INSERT INTO tpu_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","អីស អោន អន់ឌែ ពឹង ចារ អីស អន់ រ៉ាវ៉ាច់ ឡឹង សារ ប៉ាណូស អូ ដាគ់ អីស រ៉ាំងហៃ អន់ឌែ ពឹង ចារ អីស អន់ រ៉ាវ៉ាច់ ឡឹង ប៉ានឹរ ពឹរ កាង មួត តាម៉ឺរ ច្រោម អន់ឌែ។ ");
INSERT INTO tpu_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ខង ផះ ទី តាម៉ឺរ វ៉ិង ជុំ អាញ់ អ៊ែ (?) តាំបាង ពុត ដាគ់ ត្រង់ កាខាក់ កា អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","ផះ អាញ់ វ៉ឹនវ៉ាយ កាណុង ពុត អាញ់ សាម៉គ័ កា អីស តាំងហ្យិត អាញ់ អន់ ឡាច់ ឡឹង ម៉ាត់ អីស កេះ ហះកា ប៉ាគ់ អាញ់ ម៉ន់ ឡោម អីស កា សាំយ៉ាំង ប៉ានឹរ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","អឺ ប៉ាណូស បក់ ដាគ់ ត្រង់ (?) ហគ់ ប៉ិច ចៃ កា ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង រ៉ាំងហៃ បក់ ចំ ឡាក់ សឿ ហះកា ប‌៉្រ័ះ ចឹង ចៃគ ថូត បក់ ពឿ ឡាក់ ង៉ល់ ឌឺ។ ");
INSERT INTO tpu_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","អឺ បក់ ពឿ ឡាក់ ម៉ឹង ប‌៉្រ័ះ ប៊កកាតយ័ ហគ់ ទី សាងុំ លូ ទី ពុត ខឹន ពិ។ ");
INSERT INTO tpu_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","ទី សារ សាណុក សាវ៉ាក តាទឹច ហង បក់ ពឿ ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ អូ ឃឹត សារ អ៊ែ យច ទឹប អ្លាត ដោះ សារ យច អ៊ែ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","សាណុក សាវ៉ាក តាទឹច ហង បក់ ពឿ ប‌៉្រ័ះ ប៊កកាតយ័ អូ អ្យក់ យ៉ូ សារ យច អ៊ែ លូ អ៊ែ អូ ទី ប៉្រគ័ សារ ឡិគ័ ឡាគ័ (?) ");
INSERT INTO tpu_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","ផានែវ អាញ់ អូ ឡាប់ ញម សារ អាញ់ យច អុះ អាញ់ ចឹង ប៉ាណាប ខាក់ ហង ញន កា អាញ់ ញ៉ាំ អុក (?) រ៉ប់ ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","ខង ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ចៃគ ថូត អាញ់ ទឹប កាដារ់ ទឹប កាម៉ាំង សាងុំ អាញ់ កា អូ ត្រូះ អូ ត្រាន ឡគ កេះ ឡាក់ កា ទៀក ស្វាត់ ថុន ប៉្រាំង។ ");
INSERT INTO tpu_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","អាញ់ ឡាប់ ញម សារ យច កេះ អាញ់ អូ អោន សារ អាញ់ យច អុះ អាញ់ រ៉ះ ផា អាញ់ ប៉្រគ័ យច លូ ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ កា អូ អ្យក់ យ៉ូ អ្លាត ដោះ សារ យច អាញ់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","ញន ណោះ ហង បះ មួត បក់ អ្យិល កូត័ កា ប‌៉្រ័ះ ប៊កកាតយ័ អន់ឌែ ឃើយ ឡោម ឡា អើ ប‌៉្រ័ះ ផះ ដារ់ ចំ ឡាក់ អន់ឌែ តងកាន យ‌៉័ះ ទី សារ តីស ពៀប ឡាក់ កា ទៀក រ៉ាឡាប ប៉ុប ចំ កាតាម អន់ឌែ កា រ៉ាវ៉ាច់ ឡាកោ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","ប‌៉្រ័ះ ប៊កកាតយ័ ពៀប ឡាក់ កា ចារ អាញ់ អោន ខង អ៊ែ រ៉ាំងហៃ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង សារ ចុនចៃ អ៊ែ អន់ អាញ់ ចាជែ ប៉ានេ អ៊ែ ខង អ៊ែ ឡាក់ តាំងឡា តង័ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ះ ផា អាញ់ ចឹង អន់តគ់ ប៉ាតោ អីស កា អន់ អ្លុ អន់ហ្នាល់ ទ្រង ឡាក់ អីស ត្រគ់ ចាក អាញ់ ចឹង តង័ រ៉ះ លូ រ៉ាំងហៃ អីស ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","អីស ជែ ង៉ល់ អូ ហ្លង់ ឡាក់ កា សេះ លើ លៀ អន់ ពូ ចៃគ ប៉ាសយ់ ពឹង ពឹរ ម៉ាគ់ ឡាម៉គ់ ញ៉ាក់ លើ ទុង អន់ ប៉្រគ័ ពួយ ពូ។ ");
INSERT INTO tpu_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","ប៉ាណូស អូ ដាគ់ ទី សារ ថុក ប៉ាណាប អៀង ខាក់ ហះកា កាប៉ាច់ បក់ សឿ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ិច ចៃ កា អ៊ែ ខាក់។ ");
INSERT INTO tpu_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","អឺ បក់ ដាគ់ ត្រង់ ហគ់ ប៉ាណាំ គួប ហោក រ៉គ់ ពិ អឺ បក់ ទី ពុត ដាគ់ ហគ់ ចាជែ ប៉ានេ ញន កា ពុត ហោក រ៉គ់ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","អឺ បក់ ដាគ់ ត្រង់ ហគ់ ប៉ាណាំ គួប ហោក រ៉គ់ ចាជែ ប៉ានេ កា សារ ញ៉ា ឡាក់ ប‌៉្រ័ះ ប៊កកាតយ័ ទី ប៉្រគ័ ទី ដឹង បក់ ដាគ់ ត្រង់ ណោះ ហង ចឹង អ្យិល កូត័ កា ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","ហគ់ ប៉្រគ័ អញ់ស៊ែ ចាជែ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ លូ គួង ទឹង អន់ រ៉គ់ សើម ពិ។ ");
INSERT INTO tpu_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","ហគ់ ចាជែ ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ យុ ណាវ ទឹប ចំ គួង អន់ តេះ រ៉គ់ លូ ប៉្រគ័ អញ់ស៊ែ ចាជែ យ៉ិល អន់ ហោក រ៉គ់ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","ខង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ដាគ់ ត្រង់ ខាក់ ទឹប អ៊ែ ប៉្រគ័ ពួយ សារ ញ៉ា ឡាក់ អ៊ែ ទី សាញ៉ា។ ");
INSERT INTO tpu_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","ខង អ៊ែ ប៉ិច កា សារ ដាគ់ ត្រង់ លូ សារ ប៉ិច ចៃ ពឹង អង់កក់ តេះ អា ញន កា ឡាច់ ឡឹង អ៊ែ ហង (?)។ ");
INSERT INTO tpu_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","ប៉្លៃង លូ កាណាគ័ ញ៉ាៗ ទិណោ័ះ កា កើត ឡាច់ ឡឹង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាតុំ ទៀក សាឡីគ សាឡាយ លូ ទៀក ជ្រុ ណោះ អន់ អ្វៃ ម៉ោញ ចារ ៗ តាង ឡឹង គួប។ ");
INSERT INTO tpu_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","ហគ់ អន់ ប៉ាណូស លូ កាណាគ័ ញ៉ាៗ ឡាក់ អ្វៃ ពឹង អង់កក់ តេះ អា អ្យិល កូត័ កា ប‌៉្រ័ះ ប៊កកាតយ័ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","ខង កាណាគ័ ញ៉ាៗ ទិណោ័ះ កា កើត ពឹះ ឡឹង ប៉ានឹរ ប‌៉្រ័ះ ប៊កកាតយ័ ទិណោ័ះ ហង សារ ញ៉ា ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រើ កា កើត ទី នែវ ណោះ ហង។ ");
INSERT INTO tpu_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","ប‌៉្រ័ះ ប៊កកាតយ័ ថាំឡាយ ផិនកាន ប៉ាថេត អន់ទៀគៗ លូ ប៉ាសុន (?) ទិឌូ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","ហះកា ង៉ារការ លូ ផិនកាន ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ លើយ។ ");
INSERT INTO tpu_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","ទី សារ សាណុក សាវ៉ាក តាទឹច ហង ប៉ាថេត ចំ ឡាក់ អ្យិល កូត័ កា ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ អន់ឌែ ទឹប ហោក រ៉គ់ (?) ពិ ប៉ាថេត ចំ ឡាក់ ប‌៉្រ័ះ ទី រ៉ើស អន់ កេះ ប៉ាសុន អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","ប‌៉្រ័ះ ប៊កកាតយ័ ហៃ ឡឹង ប៉្លៃង អ៊ែ ប៉ប័ ប៉ាណូស ទិណោ័ះ ពឹង អង់កក់ តេះ អា។ ");
INSERT INTO tpu_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","អ៊ែ អង់អ្វៃ ពឹង ចារ សាដាច់ ហៃ ប៉ាណូស ទិណោ័ះ ពឹង អង់កក់ តេះ អា។ ");
INSERT INTO tpu_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","ប‌៉្រ័ះ ប៊កកាតយ័ ហង ប៉ាំងកើត ពុត ពៀក ប៉ាណូស ទិឌូ ទឹល នីណោ័ះ អ៊ែ ប៉ប័ ទិ សារ ញ៉ា ឡាក់ ពូ ឃឹត ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","អូ ទី សាដាច់ ចំ សាណ័ះ ញន កា តា ហាន កេង ខាក់ ណោះ អុះ កា អូ ទី ប៉ាណូស ពឿ សាណ័ះ ញន កា សាងុំ កេង ខាក់ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","សេះ សាងុំ អូ អ្លុ ប៉្រគ័ អន់ សាណ័ះ អុះ យ‌៉័ះ អ៊ែ កេង ប៉ុប ចំ កាតាម កា អូ អ្លុ តង័ ពិន អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","ប‌៉្រ័ះ ប៊កកាតយ័ ពួយ រ៉ាំងហៃ បក់ អ្យិល កូត័ លូ ទិ បក់ ម៉ឹង ពុត តាប៉ាប តាប៉ុន ម៉ះ ប‌៉្រ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","ប‌៉្រ័ះ ប៊កកាតយ័ តង័ អន់ឌែ អន់ រ៉ាវ៉ាច់ ឡឹង សារ តោ័ លូ អន់ អន់ឌែ រ៉ាវ៉ាច់ ឡឹង សារ ឡាយ៉ិត ឡាំងវ៉ាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","ពិន ត្រគ់ មប ឡាកោ កា ប‌៉្រ័ះ ម៉ាគ់ អ៊ែ តង័ លើ រ៉ាំងហៃ ពិន។ ");
INSERT INTO tpu_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","ពិន ទី សារ ហោក រ៉គ់ អន់ឌូ លូ ប‌៉្រ័ះ លូ ម៉ឹង សិច (?) ឡាក់ ដាគ់ ត្រង់ ម៉ះ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អន់ អីស តាំបាង ពុត អីស ប៉ិច ចៃ កា ញឹន ណើ ខង ញឹន មប អាញុ រ៉ីស ញឹន កា អីស កេះ។ ");
INSERT INTO tpu_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","អាញ់ ចឹង ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ លើយ រ៉ប់ ដារ់ ទឹប អាញ់ ចាជែ ប៉ានេ ប‌៉្រ័ះ អូ រ៉ាឡូវ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","អាញ់ ចឹង តីស ម៉ូះ ញន កា ប‌៉្រ័ះ ប៊កកាតយ័ ហគ់ អន់ បក់ អូ គឹត អូ ខា សាំយ៉ាំង ទឹប ទី សារ ហោក រ៉គ់ ពិ។ ");
INSERT INTO tpu_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","តាំប៉ោក ប៉ានេ កា ប‌៉្រ័ះ អន់ឌូ លូ អាញ់ ទឹប អន់ ពិន ប៉ានេ កា សិច ប‌៉្រ័ះ ប៊កកាតយ័ ទិឌូ។ (?) ");
INSERT INTO tpu_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","អាញ់ ឡោម ឡា ប‌៉្រ័ះ ប៊កកាតយ័ អ៊ែ កា ប៉្រគ័ ពួយ តាម ប៉ានឹរ អាញ់ ប៉រ់ ដេល អ៊ែ តង័ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង សារ ហ្យឹក សារ អ្យូគ ទិណោ័ះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","បក់ ពឿ ហៃ ប៉ាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ បក់ ណោះ ចឹង ទី សារ ហោក រ៉គ់ លូ អូ អ្វះ ឡាកោ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","ប៉ាណូស បក់ អូ គឹត អូ ខា ម៉ន់ ឡោម ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ អ៊ែ សាំយ៉ាំង សារ អន់ឌែ ម៉ន់ ទឹប តង័ អន់ឌែ អន់ រ៉ាវ៉ាច់ ឡឹង សារ ថុក ប៉ាណាប។ ");
INSERT INTO tpu_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","ប៊យ ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ាំងហៃ រ៉ាំងខ្យា ទិ បក់ អ្យិល កូត័ កា ប‌៉្រ័ះ ប៊កកាតយ័ ទឹប តង័ អន់ឌែ អន់ រ៉ាវ៉ាច់ ឡឹង សារ ចុនចៃ។ ");
INSERT INTO tpu_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","ហគ់ សាគ់ លួង ពិ ម៉ាគ់ អន់ដីស អ្លុ អន់ហ្នាល់ ឡឹង ពុត ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ដាគ់ កាខាក់ ខង បក់ ពឿ ឡាក់ ម៉ឹង ប‌៉្រ័ះ បក់ ណោះ ទី សារ សាណុក សាវ៉ាក តាទឹច ហង។ ");
INSERT INTO tpu_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","អឺ ប៉ាសុន ប‌៉្រ័ះ ប៊កកាតយ័ ហគ់ អ្យិល កូត័ កា អ៊ែ ខង បក់ ពឿ អ្យិល កូត័ កា អ៊ែ បក់ ណោះ ចឹង អូ កាសត់ កា ញ៉ា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","មួត បក់ ប‌៉្រ័ះ ប៉ាត្រង័ កា ចឹង ទី សារ ឡាយ៉ិត ឡាំងវ៉ាញ់ អូ ទី សាណា សា ដេល ហះកា បក់ ពឿ ឡាក់ ណាង ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ អ៊ែ អូ កា សត់ កា ញ៉ា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","អឺ គន សោ ហគ់ សាំយ៉ាំង ប៉ានឹរ អាញ់ អាញ់ ចឹង ប៉ាំងហៀន អន់ដីស អន់ អ្លុ អ្យិល កូត័ កា ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","ទី ពឿ ប៉ិច កា អាញុ រ៉ីស អ្លឹង ទឹប ទី សារ សារ សាណុក សាវ៉ាក ប ? ");
INSERT INTO tpu_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","ផា ប៉ិច កា ទី អាញុ រ៉ីស ត្រគ់ កាតត់ ពុត លូ អំប៉្យិត ជែ កាប អូ ដាគ់ លូ ព្លូង ប៉្លាច័។ ");
INSERT INTO tpu_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","ជែ ប៉្រគ័ សារ អូ ដាគ់ កេះណោះ ប៉្រគ័ សារ ដាគ់ ណាវ្គ ទឹប ណាំង សារ សាណុក សាវ៉ាក អន់ ទិ ពុត។ ");
INSERT INTO tpu_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ រ៉ាំងហៃ ប៉ាណូស បក់ ដាគ់ ត្រង់ ទឹប អ៊ែ សាំយ៉ាំង លើយ សារ អន់ឌែ ម៉ន់ អើ។ ");
INSERT INTO tpu_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាសាំង លូ បក់ ប៉្រគ័ អូ ដាគ់ ប៉ាគ់ អន់ឌែ តោ័ អូ ទី ពឿ កាចាំង កា អន់ឌែ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","ប៉ាគ់ ប៉ាណូស បក់ ដាគ់ ត្រង់ ម៉ន់ ឡោម អើ ប‌៉្រ័ះ អ៊ែ កា សាំយ៉ាំង លូ តង័ អន់ឌែ អន់ រ៉ាវ៉ាច់ ឡឹង សារ ថុក ប៉ាណាប ទិណោ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","ប‌៉្រ័ះ ប៊កកាតយ័ អ្វៃ អន់ឌូ លូ បក់ ពឿ ឡាក់ អុក ពុត ទឹប អ៊ែ តង័ បក់ ពឿ ឡាក់ ទី ពុត អុក អ៊ល។ ");
INSERT INTO tpu_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","ប៉ាណូស បក់ ដាគ់ ត្រង់ កា ចឹង ទី សារ ថុក ប៉ាណាប ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង តង័ អន់ឌែ អន់ រ៉ាវ៉ាច់ ឡឹង សារ ថុក ប៉ាណាប ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ាំងហៃ អន់ឌែ អន់ ទី សារ សាណុក សាវ៉ាក លូ អូ អន់ ទី កាន់តីង អន់ឌែ ប៉ាក់ លើ ប៉ាទុះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","សារ អូ ដាគ់ ចឹង ប៉ាន់តោ័ ប៉ាណូស បក់ អូ ដាគ់ ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង ចៃគ ថូត ប៉ាណូស បក់ អូ ណីស កា ប៉ាណូស ដាគ់ ត្រង់។ ");
INSERT INTO tpu_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","ប‌៉្រ័ះ ប៊កកាតយ័ តង័ ប៉ាសុន អ៊ែ ទិ បក់ ម៉ឹង អ៊ែ ចឹង រ៉ាវ៉ាច់ ឡឹង ថូត។ ");
INSERT INTO tpu_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉រ់ អីស ប៉ាសាំង លូ បក់ ពឿ ប៉ាសាំង លូ អាញ់ លូ អន់ អីស តាកូះ ប្ល‌៉័ះ លូ បក់ ពឿ តាកូះ ប្ល‌៉័ះ លូ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","ប៉រ់ អីស អ្យក់ ខៃល ទឹប តីស ទឹប ថិ ជឹរ ពឹះ តង័ អាញ់ ស៊្រសៗ។ ");
INSERT INTO tpu_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","អន់ អីស ស្រាង តាប៉ាក័ លូ ហឹរ ប៉ាថោ ប៉ាន់តោ័ មួត បក់ តាយ៉ិប ពួយ អាញ់ អន់ អីស ប៉ាឡាក់ អន់ អាញ់ អ្លុ សាឡះ ផា អីស ហង ប‌៉្រ័ះ ឡាក់ តង័ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","អន់ ប៉ាណូស បក់ ចឹង ប៉ាន់តោ័ អាញ់ អន់ អន់ឌែ តាយួស ម៉ូះ ម៉ាត់ អន់ បក់ ឃឹត ចឹង ប៉ាន់តោ័ អាញ់ វ៉ីល សឹត ទឹប តាយួស កាខាក់។ ");
INSERT INTO tpu_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","ប៉ាគ់ ប៊យ ប‌៉្រ័ះ តាំងហ្យិត អន់ឌែ អន់ អន់ឌែ ពៀប ឡាក់ កា ទុក តាប៉ើះ កា ខ្យាល។ ");
INSERT INTO tpu_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","ប៉ាគ់ ប៊យ ប‌៉្រ័ះ តាយ៉ិប ពួយ អន់ឌែ អន់ ទ្រង អន់ឌែ ម៉ាម៉ាំង ម៉ាមត ទឹប រ៉ាផល់។ ");
INSERT INTO tpu_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","មួត ណោះ ប៉្រគ័ សាទួង ប៉ិច កា ត្រគ់ អាញ់ លូ សីរ ឡូះ ប៉ិច កា អាញ់ ឡិ ម៉ាគ់ ចឹង ទី រ៉ុប អាញ់ ញន អូ ទី សារ ញ៉ា អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","អន់ អន់ឌែ តោ័ រ៉ាយ រ៉ុង ទឹប អូ អ្លុ អន់តគ់ លូ អន់ អន់ឌែ ត្រគ់ សាទួង អន់ឌែ ទៅ លូ ឡិ ឡូះ ឡាក់ អន់ឌែ សីរ អន់ឌែ ទៅ។ ");
INSERT INTO tpu_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","ផះ ណោះ អាញ់ ចឹង ហោក រ៉គ់ កាខាក់ ញន កា ង៉ារ ឡាក់ ប‌៉្រ័ះ តាំងឡា ទី ប៉្រគ័ ដាគ់ កា អាញ់ ណោះ លូ អាញ់ ចឹង ហោក ខាក់ កា ប‌៉្រ័ះ ប៊កកាតយ័ ទី តង័ អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","អាញ់ ចឹង រ៉ះ កា ប‌៉្រ័ះ ប៊កកាតយ័ ទិ ពុត ពៀក ផា «អឺ ប‌៉្រ័ះ តាំងឡា អូ ទី បក់ ពឿ ឡាក់ កា អីស អុះ អីស ទី តង័ ប៉ាណូស ឡាក់ អូ គឹត អូ ខា អន់ រ៉ាវ៉ាច់ ឡឹង តី មួត កេង ខាក់ ទឹប អីស តង័ ប៉ាណូស ថុក ញ៉ាក អន់ រ៉ាវ៉ាច់ ឡឹង សារ ពូ ជិះ ចគ័។ ");
INSERT INTO tpu_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","ទី ប៉ាណូស អៀង ខាក់ ប៉ាណាំ គួប ប៉្រគ័ ផាញ៉ាន ប៉ាសាំង លូ អាញ់ ពូ ច្រោម អាញ់ ឡឹង សារ ឡាក់ អាញ់ អូ អ្លុ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","អន់ឌែ ប៉្រគ័ សារ អូ ដាគ់ ញន កា អាញ់ ប៉្រគ័ សារ ដាគ់ កា អន់ឌែ អាញ់ ចឹង អ្វៃ ម៉ោញ ដូវ អាញ់ អូ ទី គួប។ ");
INSERT INTO tpu_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","ផះ ពូ អីគ ព្លុ អាញ់ ឃើយ ឡាំ តង័ អង់រ៉ើង ទឹប ម៉ន់ កំ អូ សា សាណា ប៉ាតាង ពូ លើយៗ។ ");
INSERT INTO tpu_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","អាញ់ ប៉្រគ័ ដាគ់ កា អន់ឌែ ឡាក់ កា គួប ចាង័ លើ អុះ ម៉ី អាញ់ អុក ពុត លូ ញ៉ាំ សោក ឡាក់ កា ញ៉ាំ សោក កា ម៉ៃគ អាញ់ តោ័។ ");
INSERT INTO tpu_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","ហះកា ប៉ាគ់ អាញ់ ទី សារ ថុក ឡាំបាក អន់ឌែ កាកីក ហោក រ៉គ់ សាំបាយ អន់ឌែ រែវ ពុត គួប សោប ប៉ាសាំង លូ អាញ់ ទឹប ទី ប៉ាណូស អន់ទៀគ ឡាក់ អាញ់ អូ អ្លុ អន់ហ្នាល់ ពីត អូស អាញ់ លើយ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","អន់ឌែ រែវ ពុត លូ ប៉ាណូស អូ ដាគ់ ឡាក់ អ្វៃ ជុំ អាញ់ ទឹប អន់ឌែ រ៉ាំងគែត សាណាញ់ កា អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","អឺ ប‌៉្រ័ះ តាំងឡា ញ៉ា អីស អ្វៃ គ្រឺយ ទឹល ដារ់ ចំ ណាវ្គ ? អីស តង័ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង តី អន់ឌែ រិញ អីស រ៉ាំងហៃ អាញ់ អន់ រ៉ាវ៉ាច់ ឡឹង តាប៉ល់ ប៊ក ណោះ ណើ។ ");
INSERT INTO tpu_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","អាញ់ ចឹង ហោក រ៉គ់ កា អីស ពឹង ចារ ពូ លួម អៀង ដូវ អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អាញ់ ចឹង ប៉ានេ អីស ហះ ម៉ាត់ ប៉ាសុន ទិឌូ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","អីស ជែ ទឹមវ៉ៃរ អន់ មួត តាម៉ឺរ ហោក រ៉គ់ ញន កា អាញ់ អូ ដាម័ អន់ឌែ លូ ជែ អន់ មួត ឡាក់ អូ ណីស កា អាញ់ ឡាក់ អូ ទី សារ ញ៉ា សាំងអ្យឹប ម៉ាត់ អាញ់ (?) ");
INSERT INTO tpu_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","ខង អន់ឌែ អូ ចៃ កាប ដាគ់ កាប ប៉ាឡឹង អុះ អន់ឌែ ឃឹត ដឹង កា ណាំង សារ ព្លូង ប៉្លាច័ កា ប៉ាណូស បក់ អ្វៃ ពឹង ស្រុក ឡាក់ ប៉ិច កា សារ សាណុក សាវ៉ាក។ ");
INSERT INTO tpu_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","អន់ឌែ ច្រោម អាញ់ ទឹប អន់ឌែ កាកីក ប៉ាំងហ្រល់ កា អាញ់ ផា៖ «ហះៗ ញឹន ប៉ប័ អីស ប៉្រគ័ សារ អូ ដាគ់ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","អឺ ប‌៉្រ័ះ តាំងឡា អីស ប៉ប័ ម៉ាត់ អីស ទៅ កេះ អីស ជែ អ្វៃ គ្រឺយ ហង អីស ជែ អ្លាត អាញ់ ដៃ។ ");
INSERT INTO tpu_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ តាំងឡា អាញ់ អីស អ្យូវ ឡគ ម៉ាគ់ តាត់ស៊ិន សារ អន់ ត្រង់ កា អាញ់។ ");
INSERT INTO tpu_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ តាំងឡា អាញ់ អីស ហង ឡាក់ ដាគ់ ត្រង់ ប៉រ់ អីស តាត់ស៊ិន សារ អន់ ដាគ់ ត្រង់ កា អាញ់ ណើ អីស ជែ អន់ អន់ឌែ ហោក រ៉គ់ ញន កា អាញ់ អូ ដាម័ អន់ឌែ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","ជែ អន់ អន់ឌែ ឃឹត កាណុង ពុត ផា «ពិន ទី ឡាក់ កា ពុត ពិន ប៉ិច (?) កេះ លូ ជែ អន់ អន់ឌែ រ៉ះ ផា «ពិន ទី ថាំឡាយ អ៊ែ កេះ»។ ");
INSERT INTO tpu_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","អន់ បក់ កាកីក ហោក កា អាញ់ ថុក ប៉ាណាប ណោះ កេះ តាយួស ម៉ាត់ ទិឌូ អន់ បក់ ឌឺ អាញ់ អន់ ទី សារ តាយួស អូ ខឹន ង៉ើយ ម៉ាត់។ ");
INSERT INTO tpu_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","ហះកា បក់ ពឿ ប៉ិច កា អាញ់ ឡាក់ ប៉ាណូស អូ ទី សារ យច អីស ប៉្រគ័ អន់ អន់ឌែ តាំងហើ ញន ពុត ហោក រ៉គ់ ទឹប អន់ អន់ឌែ កាប ផា «ប៉ានេ ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ ប‌៉្រ័ះ តាំងឡា អន់ ទុច អ៊ែ សាណ័ះ។ ");
INSERT INTO tpu_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","ផះ ណោះ អាញ់ ចឹង រ៉ះ ឡឹង សារ ដាគ់ ត្រង់ ម៉ះ ប‌៉្រ័ះ ប៊កកាតយ័ លើយ លូ អាញ់ ចឹង ប៉ានេ អីស លើយ រ៉ាប ដារ់។ ");
INSERT INTO tpu_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","អាញ់ កាចាំង កា ប៉ានឹរ មួត ង៉ល់ ឌឺ កាប ផះ អន់ឌែ កាប ប៉ាសាំង លូ ប‌៉្រ័ះ ផា អូ ចៃ អ្យិល កូត័ អ្យូគ កា ប‌៉្រ័ះ ប៊កកាតយ័ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","អន់ឌែ អ្វាត់ អេង លូ ប៉ានេ ឡាកោ ទៅ អូ អន់ហ្នាល់ កា ឡាកោ អន់ឌែ ទី សារ យច អូ ដាគ់ ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","អន់ឌែ កាប ស៊ុត កា សារ ព្លូង ប៉្លាច័ អន់ឌែ អូ អន់ហ្នាល់ សារ យច សារ ត្រគ់ ណាវ្គ កេះ។ ");
INSERT INTO tpu_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","យ‌៉័ះ អន់ឌែ ផះ អ្វៃ តៃប ពឹង គ្រេ កាតាម អន់ឌែ កា ឃឹត ដឹង កា ប៉្រគ័ សារ អូ ដាគ់ ដេល អន់ឌែ ប៉ិច ចាក ពួយ ទ្រង អូ ដាគ់ អន់ឌែ អូ ចៃ អ្លាត សារ អូ ដាគ់ ណោះ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ពុត អីស តាប៉ាប តាប៉ុន តីស ក្វា ឡឹង ប៉្លៃង លូ ពុត អីស ដាគ់ ត្រង់ កា ចាំងហីគ ក្វា ឡឹង ប៉្លៃង កាម៉ល់ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","ពុត អីស ដាគ់ ត្រង់ ឡាក់ កា ប៉ានឹម ចាំងហីគ កាខាក់ ពុត ខំឃឹត អីស ជ្រុ ឡាក់ កា ទៀក សាឡីគ សាឡាយ អឺ ប‌៉្រ័ះ ប៊កកាតយ័ អីស តង័ ទឹប ប៉ាណូស ទឹប អ្យាំ សៃម។ ");
INSERT INTO tpu_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","អឺ ប‌៉្រ័ះ ប៊កកាតយ័ ពុត អីស តាប៉ាប តាប៉ុន ដាគ់ ខាក់ (?) ប៉ាណូស ទិឌូ ពឹះ កាដាប កាន់តេ័ះ (?) សារ អំរ៉ាញ អឺញ អីស ឡាក់ កា គន អ្យិរ អ្វៃ កាដាប កាន់តេ័ះ កាហ្លាប ម៉ៃគ អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សាណា សា សល់ តាលៀយ កា ប៉ាណូស ពឹង ហី អ៊ែ ទឹប អ៊ែ អន់ សារ ហោក រ៉គ់ កា ពូ ឡាក់ កា ទៀក តាំងលេ ហូរ័ ");
INSERT INTO tpu_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","ខង ប‌៉្រ័ះ ប៊កកាតយ័ ឡាក់ គុល អាញុ រ៉ីស ញឹម ប៉ប័ តាតារ ញន កា តាតារ ប‌៉្រ័ះ ប៊កកាតយ័។ ");
INSERT INTO tpu_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","ប៉រ់ អីស តាំប៉ាង ពុត ប៉ិច ចៃ ណាវ្គ កា បក់ ពឿ ឡាក អន់ហ្នាល់ អីស ទឹប តាំប៉ាង ពុត ដាគ់ កា បក់ ពឿ ឡាក់ ដាគ់ ត្រង់។ ");
INSERT INTO tpu_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","ជែ អន់ ប៉ាណូស បក់ ខូយ ឌឺ ឡាំ ប៉្រគ័ បាប កា អាញ់ លូ ជែ អន់ បក់ ង៉ល់ អូ ដាគ់ ឡាំ តាំងហ្យិត អាញ់ ដៃ។ ");
INSERT INTO tpu_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","ប៉ាណូស បក់ ប៉្រគ័ អូ ដាគ់ ចឹង អូ ដាម័ ពូ អុះ អន់ឌែ ចឹង ប៉ក់ អូ អ្លុ រ៉ាវ៉ាច់ អុះ។ ");
INSERT INTO tpu_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","ចៃ អន់ អឺក ក្វាច់ លូ បក់ ពឿ ឡាក់ (ជែ អឺក អោន ពឹង វ៉ាច់ ក្វាច់ ពឹង អ៊្យែវ គែវ ពឹង ប៉ាល់អាក កា បក់) ប៉្រគ័ អូ ដាគ់ កា អន់ដីស ដៃ លូ ជែ សាណីង លូ បក់ ប៉្រគ័ សារ អូ ដាគ់ ដេល ");
INSERT INTO tpu_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","ខង អន់ឌែ ចឹង ទី សារ ប៉ាណាប ខាក់ (?) ឡាក់ កា ហ្លា អ្យិត ឡាយ៉ោ ក្រោះ លូ ឡាក កា ប៉ាកាវ ហ្យោ ហ្យិត ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","ហគ់ ម៉ឹង ប‌៉្រ័ះ ពិ ទឹប ប៉្រគ័ សារ ដាគ់ ណោះ អីស ចឹង អ្វៃ រ៉ីស ពឹង អង់កក់ តេះ អា ទី សារ សាណុក សាវ៉ាក។ ");
INSERT INTO tpu_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","ហគ់ អន់ដីស ណាំង សារ សាណុក សាវ៉ាក ឡឹង ប‌៉្រ័ះ ណោះ អ៊ែ ចឹង អន់ កា អន់ដីស កាណាគ័ ញ៉ាៗ ឡាក់ អន់ដីស តងកាន។ ");
INSERT INTO tpu_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","ហគ់ មប កា ប‌៉្រ័ះ ប៊កកាតយ័ គ្រឹប ង៉ារ ឡាក អីស ប៉្រគ័ លូ មប ទឹប អាញុ រ៉ីស អីស កា អ៊ែ ណោះ អ៊ែ ចឹង តង័ អីស។ ");
INSERT INTO tpu_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","ប‌៉្រ័ះ ប៊កកាតយ័ តាំប៉ាង អន់ ពូ ប៉ប័ សារ ដាគ់ ត្រង់ អីស (?) ឡាក់ កា តាតារ ដារ់ ទឹប អ៊ែ ចឹង តាំប៉ាង អន់ ពូ ប៉ប័ សារ ដាគ់ អីស ឡាក់ តាតារ ផះ កា ដារ់ ប៉ង់។ ");
INSERT INTO tpu_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","ហគ់ អ្វៃ គ្រឺយ ហះ ម៉ាត់ ប‌៉្រ័ះ ប៊កកាតយ័ ទឹប សឿ អ៊ែ (?) ពិ លូ ជែ អឺក ក្វាច់ កា បក់ ឌុ ប៉្រគ័ អូ ដាគ់ គ្រឹប នែវ ណោះ ដៃ។ ");
INSERT INTO tpu_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","ហគ់ កា តត់ ពុត តុ លូ អ្លាត ពុត អឺក ក្វាច់ ពិ (?) ខង សារ អឺក ហង ប៉្រគ័ អន់ ទី សារ អូ ដាគ់។ ");
INSERT INTO tpu_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","ប‌៉្រ័ះ ប៊កកាតយ័ តាំងហ្យិត ឡាច់ បក់ ពឿ ឡាក់ ប៉្រគ័ សារ អូ ដាគ់ ហះកា បក់ ពឿ ឡាក់ ម៉ឹង ប‌៉្រ័ះ ប៊កកាតយ័ ណោះ ចឹង ទី តេះ ប៉្រគ័ ប៉ាដក់ ប៉ាជៀ។ ");
INSERT INTO tpu_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","អ្វៃ បៀត ណាវ្គ ចឹង អូ ទី ប៉ាណូស អូ ដាគ់ ណាវ្គ ហង យ‌៉័ះ អីស ខំ ចាក ណាំង រចារ ឡាក់ អន់ឌែ ឃើយ អ្វៃ កា អូ ប៉ប័ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","កាប៉ាច់ ប៉ាណូស បក់ អ្យិល កូត័ អន់ឌែ ចឹង ទី តេះ ប៉្រគ័ ប៉ាដក់ ប៉ាជៀ លូ ចឹង ទី សារ សាណុក សាវ៉ាក។ ");
INSERT INTO tpu_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","កាប៉ាច់ ប៉ាណូស បក់ អូ ដាគ់ អន់ឌែ ឃឹត ដឹង ចឹង ប៉្រគ័ អូ ដាគ់ កា បក់ ដាគ់ ត្រង់ ទឹប រ៉ាំងគែត សាណាញ់ កា បក់ ដាគ់ ត្រង់ ណោះ។ ");
INSERT INTO tpu_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","ហះកា ប‌៉្រ័ះ ប៊កកាតយ័ កាកីក ប៉ាំងហ្រល់ កា ប៉ាណូស អូ ដាគ់ ញន កា អ៊ែ អ្លុ អន់តគ់ ផា ដារ់ ឡាក់ អន់ឌែ ចឹង ប៉ាណាប (?) ណោះ ក្យាម័ ចឹង ទឹល កេះ។ ");
INSERT INTO tpu_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","ប៉ាណូស ឡាក់ អូ ដាគ់ អន់ឌែ ប៉ាណាំ គួប ហ្វាត់ ដាវ លូ ក្រាគ់ (?) ស្រាគ់ ម៉ាគ់ ចឹង ប៉ាន់តោ័ បក់ ថុក ញ៉ាក លូ សាក អង់កូ ប៉ាណូស បក់ ដាគ់ ត្រង់។ ");
INSERT INTO tpu_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","ហះកា ដាវ អន់ឌែ ចឹង ច្រាគ័ ប៉្លៃ ណូស អន់ឌែ ទៅ ស្រាគ់ អន់ឌែ កា ចឹង ប៉ាក់ ទិ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","រ៉ាស អំប៉ាស បាប៊ត បាប៊ែត ម៉ះ ប៉ាណូស បក់ ដាគ់ ត្រង់ ដាគ់ ក្វា ឡឹង ប៉ាណូស អូ ដាគ់ (?) ទី រ៉ាស អំប៉ាស អៀង ");
INSERT INTO tpu_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","ខង ប‌៉្រ័ះ ប៊កកាតយ័ ចឹង តង័ ប៉ាណូស បក់ ដាគ់ ត្រង់ ហះកា អ៊ែ តាគ់ អំប៉ាក់ តី (?) ប៉ាណូស បក់ អូ ដាគ់ ឡគ។ ");
INSERT INTO tpu_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","ប‌៉្រ័ះ ប៊កកាតយ័ រ៉ាំងហៃ ប៉ាណូស បក់ ដាគ់ ត្រង់ លូ រ៉ាំងហៃ តេះ តាម ម៉ះ អន់ឌែ អន់ អ្វៃ លើយ។ ");
INSERT INTO tpu_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","ប៉ាគ់ ដារ់ ទី សារ ថុក ឡាំបាក អន់ឌែ អូ តាយួស អុះ លូ ប៉ាគ់ ដារ់ ទី សារ ឡាយ៉ិត ឡាំងវ៉ាញ់ អន់ឌែ ចឹង ទី សាណា សា ផីគ។ ");
INSERT INTO tpu_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","ហះកា ប៉ាណូស អូ ដាគ់ អន់ឌែ ចឹង តោ័ រ៉ាយ រ៉ុង ទឹប តាម៉ឺរ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ឌែ ចឹង ហ្លាញ លូ អ្យី អុញ សា (?) ឡាក់ កា ពុង គន ចៀម។ ");
INSERT INTO tpu_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","ប៉ាណូស បក់ អូ ដាគ់ បុល កាណាគ័ ពូ អន់ឌែ អូ ចៃ ស៊ង អុះ ហះកា ប៉ាណូស បក់ ដាគ់ ត្រង់ អន់ឌែ អូ កាឡីស ទឹប អន់ កាណាគ័ កា ពូ អន់ទៀគ សាំ។ ");
INSERT INTO tpu_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","បក់ ពឿ ប‌៉្រ័ះ ប៊កកាតយ័ អន់ សារ ដាគ់ បក់ ណោះ ចឹង ទី តេះ ប៉្រគ័ ប៉ាដក់ ប៉ាជៀ កាប៉ាច់ បក់ ប‌៉្រ័ះ ប៊កកាតយ័ ប៉ាស្យាប បក់ ណោះ ពូ ចឹង តាំងហ្យិត អ្លាត។ ");
INSERT INTO tpu_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","ប‌៉្រ័ះ ប៊កកាតយ័ ប៉្រគ័ អន់ ជុង អន់ឌែ យ៉ាក កា ដាគ់ ទឹប អ៊ែ ហោក រ៉គ់ (?) កា ង៉ារ ឡាក់ អន់ឌែ ប៉្រគ័ ណោះ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","ផានែវ បក់ ណោះ តាព្លៀស ជុង កា អ៊ែ អូ ប៉ក់ ដេល ខង ប‌៉្រ័ះ ប៊កកាតយ័ ចឹក កាចាប័ (?) តី អ៊ែ។ ");
INSERT INTO tpu_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","ឡឹង អាញ់ អ្វៃ សាស្វា លើយ ទឹល អាញ់ ក្រាគ់ អាញ់ អូ ឃើយ ប៉ប័ ប‌៉្រ័ះ ប៊កកាតយ័ អ្លាត ប៉ាណូស ដាគ់ ត្រង់ អុះ កា អូ ឃើយ ប៉ប័ គន សោ អន់ឌែ ប៉រ់ កាណាគ័ ពូ ដេល។ ");
INSERT INTO tpu_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","ប៉ាណូស បក់ ដាគ់ ត្រង់ អ៊ែ ទី ពុត តាប៉ាប តាប៉ុន ទឹប អ្លុ អន់ កាណាគ័ កា ពូ អន់ទៀគ បុល ទ គន សោ អន់ឌែ ចឹង ទី សារ ដាគ់។ ");
INSERT INTO tpu_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","ហគ់ យ៉្វារ ឡឹង សារ អូ ដាគ់ កេះណោះ ប៉្រគ័ ដឹង សារ ដាគ់ ប៉្រគ័ នីណោ័ះ អីស ចឹង អ្វៃ រ៉ីស លើយ។ (?) ");
INSERT INTO tpu_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","ញន 